// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S1457C5_nt  {
  int s1457c5f0[2];
  void  mf1457c5(); // _ZN10S1457C5_nt8mf1457c5Ev
};
//SIG(-1 S1457C5_nt) C1{ m Fi[2]}


void  S1457C5_nt ::mf1457c5(){}

//skip512 S1457C5_nt

#else // __cplusplus

Class_Descriptor cd_S1457C5_nt = {  "S1457C5_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1457C4_nt  {
  int s1457c4f0;
  __tsi64 s1457c4f1;
  void *s1457c4f2[4];
  int s1457c4f3[2];
  void *s1457c4f4;
  ::S1457C5_nt s1457c4f5;
  void *s1457c4f6[2];
  virtual  ~S1457C4_nt(); // _ZN10S1457C4_ntD1Ev
  virtual void  v5(); // _ZN10S1457C4_nt2v5Ev
  virtual void  v6(); // _ZN10S1457C4_nt2v6Ev
  virtual void  v7(); // _ZN10S1457C4_nt2v7Ev
  virtual void  v8(); // _ZN10S1457C4_nt2v8Ev
  virtual void  v9(); // _ZN10S1457C4_nt2v9Ev
  virtual void  v10(); // _ZN10S1457C4_nt3v10Ev
  virtual void  v11(); // _ZN10S1457C4_nt3v11Ev
  virtual void  v12(); // _ZN10S1457C4_nt3v12Ev
  virtual void  v13(); // _ZN10S1457C4_nt3v13Ev
  virtual void  v14(); // _ZN10S1457C4_nt3v14Ev
  virtual void  v15(); // _ZN10S1457C4_nt3v15Ev
  virtual void  v16(); // _ZN10S1457C4_nt3v16Ev
  virtual void  v17(); // _ZN10S1457C4_nt3v17Ev
  virtual void  v18(); // _ZN10S1457C4_nt3v18Ev
  virtual void  v19(); // _ZN10S1457C4_nt3v19Ev
  virtual void  v20(); // _ZN10S1457C4_nt3v20Ev
  virtual void  v21(); // _ZN10S1457C4_nt3v21Ev
  virtual void  v22(); // _ZN10S1457C4_nt3v22Ev
  virtual void  v23(); // _ZN10S1457C4_nt3v23Ev
  virtual void  v24(); // _ZN10S1457C4_nt3v24Ev
  virtual void  v25(); // _ZN10S1457C4_nt3v25Ev
  virtual void  v26(); // _ZN10S1457C4_nt3v26Ev
  virtual void  v27(); // _ZN10S1457C4_nt3v27Ev
  virtual void  v28(); // _ZN10S1457C4_nt3v28Ev
  virtual void  v29(); // _ZN10S1457C4_nt3v29Ev
  virtual void  v30(); // _ZN10S1457C4_nt3v30Ev
  virtual void  v31(); // _ZN10S1457C4_nt3v31Ev
  virtual void  v32(); // _ZN10S1457C4_nt3v32Ev
  virtual void  v33(); // _ZN10S1457C4_nt3v33Ev
  virtual void  v34(); // _ZN10S1457C4_nt3v34Ev
  virtual void  v35(); // _ZN10S1457C4_nt3v35Ev
  virtual void  v36(); // _ZN10S1457C4_nt3v36Ev
  virtual void  v37(); // _ZN10S1457C4_nt3v37Ev
  virtual void  v38(); // _ZN10S1457C4_nt3v38Ev
  virtual void  v39(); // _ZN10S1457C4_nt3v39Ev
  virtual void  v40(); // _ZN10S1457C4_nt3v40Ev
  virtual void  v41(); // _ZN10S1457C4_nt3v41Ev
  virtual void  v42(); // _ZN10S1457C4_nt3v42Ev
  virtual void  v43(); // _ZN10S1457C4_nt3v43Ev
  virtual void  v44(); // _ZN10S1457C4_nt3v44Ev
  virtual void  v45(); // _ZN10S1457C4_nt3v45Ev
  virtual void  v46(); // _ZN10S1457C4_nt3v46Ev
  virtual void  v47(); // _ZN10S1457C4_nt3v47Ev
  virtual void  v48(); // _ZN10S1457C4_nt3v48Ev
  virtual void  v49(); // _ZN10S1457C4_nt3v49Ev
  virtual void  v50(); // _ZN10S1457C4_nt3v50Ev
  virtual void  v51(); // _ZN10S1457C4_nt3v51Ev
  virtual void  v52(); // _ZN10S1457C4_nt3v52Ev
  virtual void  v53(); // _ZN10S1457C4_nt3v53Ev
  virtual void  v54(); // _ZN10S1457C4_nt3v54Ev
  virtual void  v55(); // _ZN10S1457C4_nt3v55Ev
  virtual void  v56(); // _ZN10S1457C4_nt3v56Ev
  virtual void  v57(); // _ZN10S1457C4_nt3v57Ev
  virtual void  v58(); // _ZN10S1457C4_nt3v58Ev
  virtual void  v59(); // _ZN10S1457C4_nt3v59Ev
  virtual void  v60(); // _ZN10S1457C4_nt3v60Ev
  virtual void  v61(); // _ZN10S1457C4_nt3v61Ev
  virtual void  v62(); // _ZN10S1457C4_nt3v62Ev
  virtual void  v63(); // _ZN10S1457C4_nt3v63Ev
  virtual void  v64(); // _ZN10S1457C4_nt3v64Ev
  virtual void  v65(); // _ZN10S1457C4_nt3v65Ev
  virtual void  v66(); // _ZN10S1457C4_nt3v66Ev
  virtual void  v67(); // _ZN10S1457C4_nt3v67Ev
  virtual void  v68(); // _ZN10S1457C4_nt3v68Ev
  S1457C4_nt(); // tgen
};
//SIG(-1 S1457C4_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1457C4_nt ::~S1457C4_nt(){ note_dtor("S1457C4_nt", this);}
void  S1457C4_nt ::v5(){vfunc_called(this, "_ZN10S1457C4_nt2v5Ev");}
void  S1457C4_nt ::v6(){vfunc_called(this, "_ZN10S1457C4_nt2v6Ev");}
void  S1457C4_nt ::v7(){vfunc_called(this, "_ZN10S1457C4_nt2v7Ev");}
void  S1457C4_nt ::v8(){vfunc_called(this, "_ZN10S1457C4_nt2v8Ev");}
void  S1457C4_nt ::v9(){vfunc_called(this, "_ZN10S1457C4_nt2v9Ev");}
void  S1457C4_nt ::v10(){vfunc_called(this, "_ZN10S1457C4_nt3v10Ev");}
void  S1457C4_nt ::v11(){vfunc_called(this, "_ZN10S1457C4_nt3v11Ev");}
void  S1457C4_nt ::v12(){vfunc_called(this, "_ZN10S1457C4_nt3v12Ev");}
void  S1457C4_nt ::v13(){vfunc_called(this, "_ZN10S1457C4_nt3v13Ev");}
void  S1457C4_nt ::v14(){vfunc_called(this, "_ZN10S1457C4_nt3v14Ev");}
void  S1457C4_nt ::v15(){vfunc_called(this, "_ZN10S1457C4_nt3v15Ev");}
void  S1457C4_nt ::v16(){vfunc_called(this, "_ZN10S1457C4_nt3v16Ev");}
void  S1457C4_nt ::v17(){vfunc_called(this, "_ZN10S1457C4_nt3v17Ev");}
void  S1457C4_nt ::v18(){vfunc_called(this, "_ZN10S1457C4_nt3v18Ev");}
void  S1457C4_nt ::v19(){vfunc_called(this, "_ZN10S1457C4_nt3v19Ev");}
void  S1457C4_nt ::v20(){vfunc_called(this, "_ZN10S1457C4_nt3v20Ev");}
void  S1457C4_nt ::v21(){vfunc_called(this, "_ZN10S1457C4_nt3v21Ev");}
void  S1457C4_nt ::v22(){vfunc_called(this, "_ZN10S1457C4_nt3v22Ev");}
void  S1457C4_nt ::v23(){vfunc_called(this, "_ZN10S1457C4_nt3v23Ev");}
void  S1457C4_nt ::v24(){vfunc_called(this, "_ZN10S1457C4_nt3v24Ev");}
void  S1457C4_nt ::v25(){vfunc_called(this, "_ZN10S1457C4_nt3v25Ev");}
void  S1457C4_nt ::v26(){vfunc_called(this, "_ZN10S1457C4_nt3v26Ev");}
void  S1457C4_nt ::v27(){vfunc_called(this, "_ZN10S1457C4_nt3v27Ev");}
void  S1457C4_nt ::v28(){vfunc_called(this, "_ZN10S1457C4_nt3v28Ev");}
void  S1457C4_nt ::v29(){vfunc_called(this, "_ZN10S1457C4_nt3v29Ev");}
void  S1457C4_nt ::v30(){vfunc_called(this, "_ZN10S1457C4_nt3v30Ev");}
void  S1457C4_nt ::v31(){vfunc_called(this, "_ZN10S1457C4_nt3v31Ev");}
void  S1457C4_nt ::v32(){vfunc_called(this, "_ZN10S1457C4_nt3v32Ev");}
void  S1457C4_nt ::v33(){vfunc_called(this, "_ZN10S1457C4_nt3v33Ev");}
void  S1457C4_nt ::v34(){vfunc_called(this, "_ZN10S1457C4_nt3v34Ev");}
void  S1457C4_nt ::v35(){vfunc_called(this, "_ZN10S1457C4_nt3v35Ev");}
void  S1457C4_nt ::v36(){vfunc_called(this, "_ZN10S1457C4_nt3v36Ev");}
void  S1457C4_nt ::v37(){vfunc_called(this, "_ZN10S1457C4_nt3v37Ev");}
void  S1457C4_nt ::v38(){vfunc_called(this, "_ZN10S1457C4_nt3v38Ev");}
void  S1457C4_nt ::v39(){vfunc_called(this, "_ZN10S1457C4_nt3v39Ev");}
void  S1457C4_nt ::v40(){vfunc_called(this, "_ZN10S1457C4_nt3v40Ev");}
void  S1457C4_nt ::v41(){vfunc_called(this, "_ZN10S1457C4_nt3v41Ev");}
void  S1457C4_nt ::v42(){vfunc_called(this, "_ZN10S1457C4_nt3v42Ev");}
void  S1457C4_nt ::v43(){vfunc_called(this, "_ZN10S1457C4_nt3v43Ev");}
void  S1457C4_nt ::v44(){vfunc_called(this, "_ZN10S1457C4_nt3v44Ev");}
void  S1457C4_nt ::v45(){vfunc_called(this, "_ZN10S1457C4_nt3v45Ev");}
void  S1457C4_nt ::v46(){vfunc_called(this, "_ZN10S1457C4_nt3v46Ev");}
void  S1457C4_nt ::v47(){vfunc_called(this, "_ZN10S1457C4_nt3v47Ev");}
void  S1457C4_nt ::v48(){vfunc_called(this, "_ZN10S1457C4_nt3v48Ev");}
void  S1457C4_nt ::v49(){vfunc_called(this, "_ZN10S1457C4_nt3v49Ev");}
void  S1457C4_nt ::v50(){vfunc_called(this, "_ZN10S1457C4_nt3v50Ev");}
void  S1457C4_nt ::v51(){vfunc_called(this, "_ZN10S1457C4_nt3v51Ev");}
void  S1457C4_nt ::v52(){vfunc_called(this, "_ZN10S1457C4_nt3v52Ev");}
void  S1457C4_nt ::v53(){vfunc_called(this, "_ZN10S1457C4_nt3v53Ev");}
void  S1457C4_nt ::v54(){vfunc_called(this, "_ZN10S1457C4_nt3v54Ev");}
void  S1457C4_nt ::v55(){vfunc_called(this, "_ZN10S1457C4_nt3v55Ev");}
void  S1457C4_nt ::v56(){vfunc_called(this, "_ZN10S1457C4_nt3v56Ev");}
void  S1457C4_nt ::v57(){vfunc_called(this, "_ZN10S1457C4_nt3v57Ev");}
void  S1457C4_nt ::v58(){vfunc_called(this, "_ZN10S1457C4_nt3v58Ev");}
void  S1457C4_nt ::v59(){vfunc_called(this, "_ZN10S1457C4_nt3v59Ev");}
void  S1457C4_nt ::v60(){vfunc_called(this, "_ZN10S1457C4_nt3v60Ev");}
void  S1457C4_nt ::v61(){vfunc_called(this, "_ZN10S1457C4_nt3v61Ev");}
void  S1457C4_nt ::v62(){vfunc_called(this, "_ZN10S1457C4_nt3v62Ev");}
void  S1457C4_nt ::v63(){vfunc_called(this, "_ZN10S1457C4_nt3v63Ev");}
void  S1457C4_nt ::v64(){vfunc_called(this, "_ZN10S1457C4_nt3v64Ev");}
void  S1457C4_nt ::v65(){vfunc_called(this, "_ZN10S1457C4_nt3v65Ev");}
void  S1457C4_nt ::v66(){vfunc_called(this, "_ZN10S1457C4_nt3v66Ev");}
void  S1457C4_nt ::v67(){vfunc_called(this, "_ZN10S1457C4_nt3v67Ev");}
void  S1457C4_nt ::v68(){vfunc_called(this, "_ZN10S1457C4_nt3v68Ev");}
S1457C4_nt ::S1457C4_nt(){ note_ctor("S1457C4_nt", this);} // tgen

//skip512 S1457C4_nt

#else // __cplusplus

extern void _ZN10S1457C4_ntC1Ev();
extern void _ZN10S1457C4_ntD1Ev();
Name_Map name_map_S1457C4_nt[] = {
  NSPAIR(_ZN10S1457C4_ntC1Ev),
  NSPAIR(_ZN10S1457C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S1457C4_nt[];
extern void _ZN10S1457C4_ntD1Ev();
extern void _ZN10S1457C4_ntD0Ev();
extern void _ZN10S1457C4_nt2v5Ev();
extern void _ZN10S1457C4_nt2v6Ev();
extern void _ZN10S1457C4_nt2v7Ev();
extern void _ZN10S1457C4_nt2v8Ev();
extern void _ZN10S1457C4_nt2v9Ev();
extern void _ZN10S1457C4_nt3v10Ev();
extern void _ZN10S1457C4_nt3v11Ev();
extern void _ZN10S1457C4_nt3v12Ev();
extern void _ZN10S1457C4_nt3v13Ev();
extern void _ZN10S1457C4_nt3v14Ev();
extern void _ZN10S1457C4_nt3v15Ev();
extern void _ZN10S1457C4_nt3v16Ev();
extern void _ZN10S1457C4_nt3v17Ev();
extern void _ZN10S1457C4_nt3v18Ev();
extern void _ZN10S1457C4_nt3v19Ev();
extern void _ZN10S1457C4_nt3v20Ev();
extern void _ZN10S1457C4_nt3v21Ev();
extern void _ZN10S1457C4_nt3v22Ev();
extern void _ZN10S1457C4_nt3v23Ev();
extern void _ZN10S1457C4_nt3v24Ev();
extern void _ZN10S1457C4_nt3v25Ev();
extern void _ZN10S1457C4_nt3v26Ev();
extern void _ZN10S1457C4_nt3v27Ev();
extern void _ZN10S1457C4_nt3v28Ev();
extern void _ZN10S1457C4_nt3v29Ev();
extern void _ZN10S1457C4_nt3v30Ev();
extern void _ZN10S1457C4_nt3v31Ev();
extern void _ZN10S1457C4_nt3v32Ev();
extern void _ZN10S1457C4_nt3v33Ev();
extern void _ZN10S1457C4_nt3v34Ev();
extern void _ZN10S1457C4_nt3v35Ev();
extern void _ZN10S1457C4_nt3v36Ev();
extern void _ZN10S1457C4_nt3v37Ev();
extern void _ZN10S1457C4_nt3v38Ev();
extern void _ZN10S1457C4_nt3v39Ev();
extern void _ZN10S1457C4_nt3v40Ev();
extern void _ZN10S1457C4_nt3v41Ev();
extern void _ZN10S1457C4_nt3v42Ev();
extern void _ZN10S1457C4_nt3v43Ev();
extern void _ZN10S1457C4_nt3v44Ev();
extern void _ZN10S1457C4_nt3v45Ev();
extern void _ZN10S1457C4_nt3v46Ev();
extern void _ZN10S1457C4_nt3v47Ev();
extern void _ZN10S1457C4_nt3v48Ev();
extern void _ZN10S1457C4_nt3v49Ev();
extern void _ZN10S1457C4_nt3v50Ev();
extern void _ZN10S1457C4_nt3v51Ev();
extern void _ZN10S1457C4_nt3v52Ev();
extern void _ZN10S1457C4_nt3v53Ev();
extern void _ZN10S1457C4_nt3v54Ev();
extern void _ZN10S1457C4_nt3v55Ev();
extern void _ZN10S1457C4_nt3v56Ev();
extern void _ZN10S1457C4_nt3v57Ev();
extern void _ZN10S1457C4_nt3v58Ev();
extern void _ZN10S1457C4_nt3v59Ev();
extern void _ZN10S1457C4_nt3v60Ev();
extern void _ZN10S1457C4_nt3v61Ev();
extern void _ZN10S1457C4_nt3v62Ev();
extern void _ZN10S1457C4_nt3v63Ev();
extern void _ZN10S1457C4_nt3v64Ev();
extern void _ZN10S1457C4_nt3v65Ev();
extern void _ZN10S1457C4_nt3v66Ev();
extern void _ZN10S1457C4_nt3v67Ev();
extern void _ZN10S1457C4_nt3v68Ev();
static  VTBL_ENTRY vtc_S1457C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1457C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S1457C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v68Ev,
};
extern VTBL_ENTRY _ZTI10S1457C4_nt[];
VTBL_ENTRY *P__ZTI10S1457C4_nt = _ZTI10S1457C4_nt; 
extern  VTBL_ENTRY _ZTV10S1457C4_nt[];
Class_Descriptor cd_S1457C4_nt = {  "S1457C4_nt", // class name
  0,0,//no base classes
  &(vtc_S1457C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI10S1457C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S1457C4_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1457C8_nt  {
  void *s1457c8f0;
  int s1457c8f1[2];
  void  mf1457c8(); // _ZN10S1457C8_nt8mf1457c8Ev
};
//SIG(-1 S1457C8_nt) C1{ m Fp Fi[2]}


void  S1457C8_nt ::mf1457c8(){}

//skip512 S1457C8_nt

#else // __cplusplus

Class_Descriptor cd_S1457C8_nt = {  "S1457C8_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1457C7_nt  : S1457C8_nt {
};
//SIG(-1 S1457C7_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S1457C7_nt

#else // __cplusplus

extern Class_Descriptor cd_S1457C8_nt;
static Base_Class bases_S1457C7_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1457C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1457C7_nt = {  "S1457C7_nt", // class name
  bases_S1457C7_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1457C6_nt  : S1457C7_nt {
};
//SIG(-1 S1457C6_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S1457C6_nt

#else // __cplusplus

extern Class_Descriptor cd_S1457C8_nt;
extern Class_Descriptor cd_S1457C7_nt;
static Base_Class bases_S1457C6_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1457C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1457C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1457C9_nt  {
  int s1457c9f0;
  void  mf1457c9(); // _ZN10S1457C9_nt8mf1457c9Ev
};
//SIG(-1 S1457C9_nt) C1{ m Fi}


void  S1457C9_nt ::mf1457c9(){}

//skip512 S1457C9_nt

#else // __cplusplus

Class_Descriptor cd_S1457C9_nt = {  "S1457C9_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1457C13  : S1457C8_nt {
};
//SIG(-1 S1457C13) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1457C13()
{
  extern Class_Descriptor cd_S1457C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1457C13, buf);
    S1457C13 &lv = *(new (buf) S1457C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1457C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1457C13)");
    check_base_class_offset(lv, (S1457C8_nt*), 0, "S1457C13");
    test_class_info(&lv, &cd_S1457C13);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1457C13(Test_S1457C13, "S1457C13", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1457C8_nt;
static Base_Class bases_S1457C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1457C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1457C13 = {  "S1457C13", // class name
  bases_S1457C13, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1457C12  : S1457C13 {
};
//SIG(-1 S1457C12) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1457C12()
{
  extern Class_Descriptor cd_S1457C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1457C12, buf);
    S1457C12 &lv = *(new (buf) S1457C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1457C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1457C12)");
    check_base_class_offset(lv, (S1457C8_nt*)(S1457C13*), 0, "S1457C12");
    check_base_class_offset(lv, (S1457C13*), 0, "S1457C12");
    test_class_info(&lv, &cd_S1457C12);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1457C12(Test_S1457C12, "S1457C12", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1457C8_nt;
extern Class_Descriptor cd_S1457C13;
static Base_Class bases_S1457C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1457C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1457C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1457C12 = {  "S1457C12", // class name
  bases_S1457C12, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1457C14_nt  {
  int s1457c14f0[3];
  void  mf1457c14(); // _ZN11S1457C14_nt9mf1457c14Ev
};
//SIG(-1 S1457C14_nt) C1{ m Fi[3]}


void  S1457C14_nt ::mf1457c14(){}

//skip512 S1457C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1457C19  : S1457C8_nt {
};
//SIG(-1 S1457C19) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1457C19()
{
  extern Class_Descriptor cd_S1457C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1457C19, buf);
    S1457C19 &lv = *(new (buf) S1457C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1457C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1457C19)");
    check_base_class_offset(lv, (S1457C8_nt*), 0, "S1457C19");
    test_class_info(&lv, &cd_S1457C19);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1457C19(Test_S1457C19, "S1457C19", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1457C8_nt;
static Base_Class bases_S1457C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1457C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1457C19 = {  "S1457C19", // class name
  bases_S1457C19, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1457C18  : S1457C19 {
};
//SIG(-1 S1457C18) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1457C18()
{
  extern Class_Descriptor cd_S1457C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1457C18, buf);
    S1457C18 &lv = *(new (buf) S1457C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1457C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1457C18)");
    check_base_class_offset(lv, (S1457C8_nt*)(S1457C19*), 0, "S1457C18");
    check_base_class_offset(lv, (S1457C19*), 0, "S1457C18");
    test_class_info(&lv, &cd_S1457C18);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1457C18(Test_S1457C18, "S1457C18", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1457C8_nt;
extern Class_Descriptor cd_S1457C19;
static Base_Class bases_S1457C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1457C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1457C19,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1457C18 = {  "S1457C18", // class name
  bases_S1457C18, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1457C3_nt  : S1457C4_nt {
  ::S1457C6_nt s1457c3f0;
  ::S1457C6_nt s1457c3f1;
  ::S1457C9_nt s1457c3f2;
  int s1457c3f3;
  char s1457c3f4[4];
  void *s1457c3f5[2];
  ::S1457C6_nt s1457c3f6;
  unsigned int s1457c3f7:1;
  unsigned int s1457c3f8:1;
  unsigned int s1457c3f9:1;
  unsigned int s1457c3f10:1;
  unsigned int s1457c3f11:1;
  unsigned int s1457c3f12:1;
  unsigned int s1457c3f13:1;
  unsigned int s1457c3f14:1;
  unsigned int s1457c3f15:1;
  unsigned int s1457c3f16:1;
  unsigned int s1457c3f17:1;
  unsigned int s1457c3f18:1;
  unsigned int s1457c3f19:1;
  unsigned int s1457c3f20:1;
  unsigned int s1457c3f21:1;
  unsigned int s1457c3f22:1;
  unsigned int s1457c3f23:1;
  unsigned int s1457c3f24:1;
  unsigned int s1457c3f25:1;
  unsigned int s1457c3f26:1;
  unsigned int s1457c3f27:1;
  unsigned int s1457c3f28:1;
  unsigned int s1457c3f29:1;
  unsigned int s1457c3f30:1;
  unsigned int s1457c3f31:1;
  unsigned int s1457c3f32:1;
  unsigned int s1457c3f33:1;
  unsigned int s1457c3f34:1;
  unsigned int s1457c3f35:1;
  unsigned int s1457c3f36:1;
  unsigned int s1457c3f37:1;
  unsigned int s1457c3f38:1;
  unsigned int s1457c3f39:1;
  unsigned int s1457c3f40:1;
  unsigned int s1457c3f41:1;
  unsigned int s1457c3f42:1;
  unsigned int s1457c3f43:1;
  unsigned int s1457c3f44:1;
  unsigned int s1457c3f45:1;
  unsigned int s1457c3f46:1;
  unsigned int s1457c3f47:1;
  unsigned int s1457c3f48:1;
  unsigned int s1457c3f49:1;
  unsigned int s1457c3f50:1;
  unsigned int s1457c3f51:1;
  unsigned int s1457c3f52:1;
  unsigned int s1457c3f53:1;
  unsigned int s1457c3f54:1;
  unsigned int s1457c3f55:1;
  unsigned int s1457c3f56:1;
  unsigned int s1457c3f57:1;
  unsigned int s1457c3f58:1;
  unsigned int s1457c3f59:1;
  unsigned int s1457c3f60:1;
  unsigned int s1457c3f61:1;
  unsigned int s1457c3f62:1;
  unsigned int s1457c3f63:1;
  unsigned int s1457c3f64:1;
  unsigned int s1457c3f65:1;
  unsigned int s1457c3f66:1;
  unsigned int s1457c3f67:1;
  unsigned int s1457c3f68:1;
  unsigned int s1457c3f69:1;
  unsigned int s1457c3f70:1;
  unsigned int s1457c3f71:1;
  unsigned int s1457c3f72:1;
  unsigned int s1457c3f73:1;
  unsigned int s1457c3f74:1;
  unsigned int s1457c3f75:1;
  unsigned int s1457c3f76:1;
  unsigned int s1457c3f77:1;
  unsigned int s1457c3f78:1;
  unsigned int s1457c3f79:1;
  unsigned int s1457c3f80:1;
  unsigned int s1457c3f81:1;
  unsigned int s1457c3f82:1;
  unsigned int s1457c3f83:1;
  int s1457c3f84[5];
  void *s1457c3f85[2];
  int s1457c3f86[3];
  ::S1457C5_nt s1457c3f87;
  ::S1457C5_nt s1457c3f88;
  ::S1457C5_nt s1457c3f89;
  ::S1457C12 s1457c3f90;
  ::S1457C12 s1457c3f91;
  int s1457c3f92;
  void *s1457c3f93[2];
  ::S1457C14_nt s1457c3f94;
  ::S1457C14_nt s1457c3f95;
  ::S1457C14_nt s1457c3f96;
  ::S1457C14_nt s1457c3f97;
  void *s1457c3f98;
  ::S1457C5_nt s1457c3f99;
  ::S1457C12 s1457c3f100;
  ::S1457C14_nt s1457c3f101;
  ::S1457C14_nt s1457c3f102;
  int s1457c3f103;
  ::S1457C14_nt s1457c3f104;
  ::S1457C14_nt s1457c3f105;
  void *s1457c3f106;
  int s1457c3f107;
  char s1457c3f108;
  ::S1457C14_nt s1457c3f109;
  ::S1457C14_nt s1457c3f110;
  void *s1457c3f111;
  int s1457c3f112;
  void *s1457c3f113;
  ::S1457C12 s1457c3f114;
  ::S1457C18 s1457c3f115;
  ::S1457C18 s1457c3f116;
  virtual  ~S1457C3_nt(); // _ZN10S1457C3_ntD1Ev
  virtual void  v69(); // _ZN10S1457C3_nt3v69Ev
  virtual void  v70(); // _ZN10S1457C3_nt3v70Ev
  virtual void  v71(); // _ZN10S1457C3_nt3v71Ev
  virtual void  v72(); // _ZN10S1457C3_nt3v72Ev
  virtual void  v73(); // _ZN10S1457C3_nt3v73Ev
  virtual void  v74(); // _ZN10S1457C3_nt3v74Ev
  virtual void  v75(); // _ZN10S1457C3_nt3v75Ev
  virtual void  v76(); // _ZN10S1457C3_nt3v76Ev
  virtual void  v77(); // _ZN10S1457C3_nt3v77Ev
  virtual void  v78(); // _ZN10S1457C3_nt3v78Ev
  virtual void  v79(); // _ZN10S1457C3_nt3v79Ev
  virtual void  v80(); // _ZN10S1457C3_nt3v80Ev
  virtual void  v81(); // _ZN10S1457C3_nt3v81Ev
  virtual void  v82(); // _ZN10S1457C3_nt3v82Ev
  virtual void  v83(); // _ZN10S1457C3_nt3v83Ev
  virtual void  v84(); // _ZN10S1457C3_nt3v84Ev
  virtual void  v85(); // _ZN10S1457C3_nt3v85Ev
  virtual void  v86(); // _ZN10S1457C3_nt3v86Ev
  virtual void  v87(); // _ZN10S1457C3_nt3v87Ev
  virtual void  v88(); // _ZN10S1457C3_nt3v88Ev
  virtual void  v89(); // _ZN10S1457C3_nt3v89Ev
  virtual void  v90(); // _ZN10S1457C3_nt3v90Ev
  virtual void  v91(); // _ZN10S1457C3_nt3v91Ev
  virtual void  v92(); // _ZN10S1457C3_nt3v92Ev
  virtual void  v93(); // _ZN10S1457C3_nt3v93Ev
  virtual void  v94(); // _ZN10S1457C3_nt3v94Ev
  virtual void  v95(); // _ZN10S1457C3_nt3v95Ev
  virtual void  v96(); // _ZN10S1457C3_nt3v96Ev
  virtual void  v97(); // _ZN10S1457C3_nt3v97Ev
  virtual void  v98(); // _ZN10S1457C3_nt3v98Ev
  virtual void  v99(); // _ZN10S1457C3_nt3v99Ev
  virtual void  v100(); // _ZN10S1457C3_nt4v100Ev
  virtual void  v101(); // _ZN10S1457C3_nt4v101Ev
  virtual void  v102(); // _ZN10S1457C3_nt4v102Ev
  virtual void  v103(); // _ZN10S1457C3_nt4v103Ev
  virtual void  v104(); // _ZN10S1457C3_nt4v104Ev
  virtual void  v105(); // _ZN10S1457C3_nt4v105Ev
  virtual void  v106(); // _ZN10S1457C3_nt4v106Ev
  virtual void  v107(); // _ZN10S1457C3_nt4v107Ev
  virtual void  v108(); // _ZN10S1457C3_nt4v108Ev
  virtual void  v109(); // _ZN10S1457C3_nt4v109Ev
  virtual void  v110(); // _ZN10S1457C3_nt4v110Ev
  virtual void  v111(); // _ZN10S1457C3_nt4v111Ev
  virtual void  v112(); // _ZN10S1457C3_nt4v112Ev
  virtual void  v113(); // _ZN10S1457C3_nt4v113Ev
  virtual void  v114(); // _ZN10S1457C3_nt4v114Ev
  virtual void  v115(); // _ZN10S1457C3_nt4v115Ev
  virtual void  v116(); // _ZN10S1457C3_nt4v116Ev
  virtual void  v117(); // _ZN10S1457C3_nt4v117Ev
  virtual void  v118(); // _ZN10S1457C3_nt4v118Ev
  virtual void  v119(); // _ZN10S1457C3_nt4v119Ev
  virtual void  v120(); // _ZN10S1457C3_nt4v120Ev
  virtual void  v121(); // _ZN10S1457C3_nt4v121Ev
  virtual void  v122(); // _ZN10S1457C3_nt4v122Ev
  virtual void  v123(); // _ZN10S1457C3_nt4v123Ev
  virtual void  v124(); // _ZN10S1457C3_nt4v124Ev
  virtual void  v125(); // _ZN10S1457C3_nt4v125Ev
  virtual void  v126(); // _ZN10S1457C3_nt4v126Ev
  virtual void  v127(); // _ZN10S1457C3_nt4v127Ev
  virtual void  v128(); // _ZN10S1457C3_nt4v128Ev
  virtual void  v129(); // _ZN10S1457C3_nt4v129Ev
  virtual void  v130(); // _ZN10S1457C3_nt4v130Ev
  virtual void  v131(); // _ZN10S1457C3_nt4v131Ev
  virtual void  v132(); // _ZN10S1457C3_nt4v132Ev
  virtual void  v133(); // _ZN10S1457C3_nt4v133Ev
  virtual void  v134(); // _ZN10S1457C3_nt4v134Ev
  virtual void  v135(); // _ZN10S1457C3_nt4v135Ev
  virtual void  v136(); // _ZN10S1457C3_nt4v136Ev
  virtual void  v137(); // _ZN10S1457C3_nt4v137Ev
  virtual void  v138(); // _ZN10S1457C3_nt4v138Ev
  virtual void  v139(); // _ZN10S1457C3_nt4v139Ev
  virtual void  v140(); // _ZN10S1457C3_nt4v140Ev
  virtual void  v141(); // _ZN10S1457C3_nt4v141Ev
  virtual void  v142(); // _ZN10S1457C3_nt4v142Ev
  virtual void  v143(); // _ZN10S1457C3_nt4v143Ev
  virtual void  v144(); // _ZN10S1457C3_nt4v144Ev
  virtual void  v145(); // _ZN10S1457C3_nt4v145Ev
  virtual void  v146(); // _ZN10S1457C3_nt4v146Ev
  virtual void  v147(); // _ZN10S1457C3_nt4v147Ev
  virtual void  v148(); // _ZN10S1457C3_nt4v148Ev
  virtual void  v149(); // _ZN10S1457C3_nt4v149Ev
  virtual void  v150(); // _ZN10S1457C3_nt4v150Ev
  virtual void  v151(); // _ZN10S1457C3_nt4v151Ev
  virtual void  v152(); // _ZN10S1457C3_nt4v152Ev
  virtual void  v153(); // _ZN10S1457C3_nt4v153Ev
  virtual void  v154(); // _ZN10S1457C3_nt4v154Ev
  virtual void  v155(); // _ZN10S1457C3_nt4v155Ev
  virtual void  v156(); // _ZN10S1457C3_nt4v156Ev
  virtual void  v157(); // _ZN10S1457C3_nt4v157Ev
  virtual void  v158(); // _ZN10S1457C3_nt4v158Ev
  virtual void  v159(); // _ZN10S1457C3_nt4v159Ev
  virtual void  v160(); // _ZN10S1457C3_nt4v160Ev
  virtual void  v161(); // _ZN10S1457C3_nt4v161Ev
  virtual void  v162(); // _ZN10S1457C3_nt4v162Ev
  virtual void  v163(); // _ZN10S1457C3_nt4v163Ev
  virtual void  v164(); // _ZN10S1457C3_nt4v164Ev
  virtual void  v165(); // _ZN10S1457C3_nt4v165Ev
  virtual void  v166(); // _ZN10S1457C3_nt4v166Ev
  virtual void  v167(); // _ZN10S1457C3_nt4v167Ev
  virtual void  v168(); // _ZN10S1457C3_nt4v168Ev
  virtual void  v169(); // _ZN10S1457C3_nt4v169Ev
  virtual void  v170(); // _ZN10S1457C3_nt4v170Ev
  virtual void  v171(); // _ZN10S1457C3_nt4v171Ev
  virtual void  v172(); // _ZN10S1457C3_nt4v172Ev
  virtual void  v173(); // _ZN10S1457C3_nt4v173Ev
  virtual void  v174(); // _ZN10S1457C3_nt4v174Ev
  virtual void  v175(); // _ZN10S1457C3_nt4v175Ev
  virtual void  v176(); // _ZN10S1457C3_nt4v176Ev
  virtual void  v177(); // _ZN10S1457C3_nt4v177Ev
  virtual void  v178(); // _ZN10S1457C3_nt4v178Ev
  virtual void  v179(); // _ZN10S1457C3_nt4v179Ev
  virtual void  v180(); // _ZN10S1457C3_nt4v180Ev
  virtual void  v181(); // _ZN10S1457C3_nt4v181Ev
  virtual void  v182(); // _ZN10S1457C3_nt4v182Ev
  virtual void  v183(); // _ZN10S1457C3_nt4v183Ev
  virtual void  v184(); // _ZN10S1457C3_nt4v184Ev
  virtual void  v185(); // _ZN10S1457C3_nt4v185Ev
  virtual void  v186(); // _ZN10S1457C3_nt4v186Ev
  virtual void  v187(); // _ZN10S1457C3_nt4v187Ev
  virtual void  v188(); // _ZN10S1457C3_nt4v188Ev
  virtual void  v189(); // _ZN10S1457C3_nt4v189Ev
  virtual void  v190(); // _ZN10S1457C3_nt4v190Ev
  virtual void  v191(); // _ZN10S1457C3_nt4v191Ev
  virtual void  v192(); // _ZN10S1457C3_nt4v192Ev
  virtual void  v193(); // _ZN10S1457C3_nt4v193Ev
  virtual void  v194(); // _ZN10S1457C3_nt4v194Ev
  virtual void  v195(); // _ZN10S1457C3_nt4v195Ev
  virtual void  v196(); // _ZN10S1457C3_nt4v196Ev
  virtual void  v197(); // _ZN10S1457C3_nt4v197Ev
  virtual void  v198(); // _ZN10S1457C3_nt4v198Ev
  virtual void  v199(); // _ZN10S1457C3_nt4v199Ev
  virtual void  v200(); // _ZN10S1457C3_nt4v200Ev
  virtual void  v201(); // _ZN10S1457C3_nt4v201Ev
  virtual void  v202(); // _ZN10S1457C3_nt4v202Ev
  virtual void  v203(); // _ZN10S1457C3_nt4v203Ev
  virtual void  v204(); // _ZN10S1457C3_nt4v204Ev
  virtual void  v205(); // _ZN10S1457C3_nt4v205Ev
  virtual void  v206(); // _ZN10S1457C3_nt4v206Ev
  virtual void  v207(); // _ZN10S1457C3_nt4v207Ev
  virtual void  v208(); // _ZN10S1457C3_nt4v208Ev
  virtual void  v209(); // _ZN10S1457C3_nt4v209Ev
  virtual void  v210(); // _ZN10S1457C3_nt4v210Ev
  virtual void  v211(); // _ZN10S1457C3_nt4v211Ev
  S1457C3_nt(); // tgen
};
//SIG(-1 S1457C3_nt) C1{ BC2{ vd v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 FC4{ BC5{ BC6{ m Fp Fi[2]}}} FC4 FC7{ m Fi} Fi Fc[4] Fp[2] FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC3 FC3 FC3 FC8{ BC9{ BC6}} FC8 Fi Fp[2] FC10{ m Fi[3]} FC10 FC10 FC10 Fp FC3 FC8 FC10 FC10 Fi FC10 FC10 Fp Fi Fc FC10 FC10 Fp Fi Fp FC8 FC11{ BC12{ BC6}} FC11}


 S1457C3_nt ::~S1457C3_nt(){ note_dtor("S1457C3_nt", this);}
void  S1457C3_nt ::v69(){vfunc_called(this, "_ZN10S1457C3_nt3v69Ev");}
void  S1457C3_nt ::v70(){vfunc_called(this, "_ZN10S1457C3_nt3v70Ev");}
void  S1457C3_nt ::v71(){vfunc_called(this, "_ZN10S1457C3_nt3v71Ev");}
void  S1457C3_nt ::v72(){vfunc_called(this, "_ZN10S1457C3_nt3v72Ev");}
void  S1457C3_nt ::v73(){vfunc_called(this, "_ZN10S1457C3_nt3v73Ev");}
void  S1457C3_nt ::v74(){vfunc_called(this, "_ZN10S1457C3_nt3v74Ev");}
void  S1457C3_nt ::v75(){vfunc_called(this, "_ZN10S1457C3_nt3v75Ev");}
void  S1457C3_nt ::v76(){vfunc_called(this, "_ZN10S1457C3_nt3v76Ev");}
void  S1457C3_nt ::v77(){vfunc_called(this, "_ZN10S1457C3_nt3v77Ev");}
void  S1457C3_nt ::v78(){vfunc_called(this, "_ZN10S1457C3_nt3v78Ev");}
void  S1457C3_nt ::v79(){vfunc_called(this, "_ZN10S1457C3_nt3v79Ev");}
void  S1457C3_nt ::v80(){vfunc_called(this, "_ZN10S1457C3_nt3v80Ev");}
void  S1457C3_nt ::v81(){vfunc_called(this, "_ZN10S1457C3_nt3v81Ev");}
void  S1457C3_nt ::v82(){vfunc_called(this, "_ZN10S1457C3_nt3v82Ev");}
void  S1457C3_nt ::v83(){vfunc_called(this, "_ZN10S1457C3_nt3v83Ev");}
void  S1457C3_nt ::v84(){vfunc_called(this, "_ZN10S1457C3_nt3v84Ev");}
void  S1457C3_nt ::v85(){vfunc_called(this, "_ZN10S1457C3_nt3v85Ev");}
void  S1457C3_nt ::v86(){vfunc_called(this, "_ZN10S1457C3_nt3v86Ev");}
void  S1457C3_nt ::v87(){vfunc_called(this, "_ZN10S1457C3_nt3v87Ev");}
void  S1457C3_nt ::v88(){vfunc_called(this, "_ZN10S1457C3_nt3v88Ev");}
void  S1457C3_nt ::v89(){vfunc_called(this, "_ZN10S1457C3_nt3v89Ev");}
void  S1457C3_nt ::v90(){vfunc_called(this, "_ZN10S1457C3_nt3v90Ev");}
void  S1457C3_nt ::v91(){vfunc_called(this, "_ZN10S1457C3_nt3v91Ev");}
void  S1457C3_nt ::v92(){vfunc_called(this, "_ZN10S1457C3_nt3v92Ev");}
void  S1457C3_nt ::v93(){vfunc_called(this, "_ZN10S1457C3_nt3v93Ev");}
void  S1457C3_nt ::v94(){vfunc_called(this, "_ZN10S1457C3_nt3v94Ev");}
void  S1457C3_nt ::v95(){vfunc_called(this, "_ZN10S1457C3_nt3v95Ev");}
void  S1457C3_nt ::v96(){vfunc_called(this, "_ZN10S1457C3_nt3v96Ev");}
void  S1457C3_nt ::v97(){vfunc_called(this, "_ZN10S1457C3_nt3v97Ev");}
void  S1457C3_nt ::v98(){vfunc_called(this, "_ZN10S1457C3_nt3v98Ev");}
void  S1457C3_nt ::v99(){vfunc_called(this, "_ZN10S1457C3_nt3v99Ev");}
void  S1457C3_nt ::v100(){vfunc_called(this, "_ZN10S1457C3_nt4v100Ev");}
void  S1457C3_nt ::v101(){vfunc_called(this, "_ZN10S1457C3_nt4v101Ev");}
void  S1457C3_nt ::v102(){vfunc_called(this, "_ZN10S1457C3_nt4v102Ev");}
void  S1457C3_nt ::v103(){vfunc_called(this, "_ZN10S1457C3_nt4v103Ev");}
void  S1457C3_nt ::v104(){vfunc_called(this, "_ZN10S1457C3_nt4v104Ev");}
void  S1457C3_nt ::v105(){vfunc_called(this, "_ZN10S1457C3_nt4v105Ev");}
void  S1457C3_nt ::v106(){vfunc_called(this, "_ZN10S1457C3_nt4v106Ev");}
void  S1457C3_nt ::v107(){vfunc_called(this, "_ZN10S1457C3_nt4v107Ev");}
void  S1457C3_nt ::v108(){vfunc_called(this, "_ZN10S1457C3_nt4v108Ev");}
void  S1457C3_nt ::v109(){vfunc_called(this, "_ZN10S1457C3_nt4v109Ev");}
void  S1457C3_nt ::v110(){vfunc_called(this, "_ZN10S1457C3_nt4v110Ev");}
void  S1457C3_nt ::v111(){vfunc_called(this, "_ZN10S1457C3_nt4v111Ev");}
void  S1457C3_nt ::v112(){vfunc_called(this, "_ZN10S1457C3_nt4v112Ev");}
void  S1457C3_nt ::v113(){vfunc_called(this, "_ZN10S1457C3_nt4v113Ev");}
void  S1457C3_nt ::v114(){vfunc_called(this, "_ZN10S1457C3_nt4v114Ev");}
void  S1457C3_nt ::v115(){vfunc_called(this, "_ZN10S1457C3_nt4v115Ev");}
void  S1457C3_nt ::v116(){vfunc_called(this, "_ZN10S1457C3_nt4v116Ev");}
void  S1457C3_nt ::v117(){vfunc_called(this, "_ZN10S1457C3_nt4v117Ev");}
void  S1457C3_nt ::v118(){vfunc_called(this, "_ZN10S1457C3_nt4v118Ev");}
void  S1457C3_nt ::v119(){vfunc_called(this, "_ZN10S1457C3_nt4v119Ev");}
void  S1457C3_nt ::v120(){vfunc_called(this, "_ZN10S1457C3_nt4v120Ev");}
void  S1457C3_nt ::v121(){vfunc_called(this, "_ZN10S1457C3_nt4v121Ev");}
void  S1457C3_nt ::v122(){vfunc_called(this, "_ZN10S1457C3_nt4v122Ev");}
void  S1457C3_nt ::v123(){vfunc_called(this, "_ZN10S1457C3_nt4v123Ev");}
void  S1457C3_nt ::v124(){vfunc_called(this, "_ZN10S1457C3_nt4v124Ev");}
void  S1457C3_nt ::v125(){vfunc_called(this, "_ZN10S1457C3_nt4v125Ev");}
void  S1457C3_nt ::v126(){vfunc_called(this, "_ZN10S1457C3_nt4v126Ev");}
void  S1457C3_nt ::v127(){vfunc_called(this, "_ZN10S1457C3_nt4v127Ev");}
void  S1457C3_nt ::v128(){vfunc_called(this, "_ZN10S1457C3_nt4v128Ev");}
void  S1457C3_nt ::v129(){vfunc_called(this, "_ZN10S1457C3_nt4v129Ev");}
void  S1457C3_nt ::v130(){vfunc_called(this, "_ZN10S1457C3_nt4v130Ev");}
void  S1457C3_nt ::v131(){vfunc_called(this, "_ZN10S1457C3_nt4v131Ev");}
void  S1457C3_nt ::v132(){vfunc_called(this, "_ZN10S1457C3_nt4v132Ev");}
void  S1457C3_nt ::v133(){vfunc_called(this, "_ZN10S1457C3_nt4v133Ev");}
void  S1457C3_nt ::v134(){vfunc_called(this, "_ZN10S1457C3_nt4v134Ev");}
void  S1457C3_nt ::v135(){vfunc_called(this, "_ZN10S1457C3_nt4v135Ev");}
void  S1457C3_nt ::v136(){vfunc_called(this, "_ZN10S1457C3_nt4v136Ev");}
void  S1457C3_nt ::v137(){vfunc_called(this, "_ZN10S1457C3_nt4v137Ev");}
void  S1457C3_nt ::v138(){vfunc_called(this, "_ZN10S1457C3_nt4v138Ev");}
void  S1457C3_nt ::v139(){vfunc_called(this, "_ZN10S1457C3_nt4v139Ev");}
void  S1457C3_nt ::v140(){vfunc_called(this, "_ZN10S1457C3_nt4v140Ev");}
void  S1457C3_nt ::v141(){vfunc_called(this, "_ZN10S1457C3_nt4v141Ev");}
void  S1457C3_nt ::v142(){vfunc_called(this, "_ZN10S1457C3_nt4v142Ev");}
void  S1457C3_nt ::v143(){vfunc_called(this, "_ZN10S1457C3_nt4v143Ev");}
void  S1457C3_nt ::v144(){vfunc_called(this, "_ZN10S1457C3_nt4v144Ev");}
void  S1457C3_nt ::v145(){vfunc_called(this, "_ZN10S1457C3_nt4v145Ev");}
void  S1457C3_nt ::v146(){vfunc_called(this, "_ZN10S1457C3_nt4v146Ev");}
void  S1457C3_nt ::v147(){vfunc_called(this, "_ZN10S1457C3_nt4v147Ev");}
void  S1457C3_nt ::v148(){vfunc_called(this, "_ZN10S1457C3_nt4v148Ev");}
void  S1457C3_nt ::v149(){vfunc_called(this, "_ZN10S1457C3_nt4v149Ev");}
void  S1457C3_nt ::v150(){vfunc_called(this, "_ZN10S1457C3_nt4v150Ev");}
void  S1457C3_nt ::v151(){vfunc_called(this, "_ZN10S1457C3_nt4v151Ev");}
void  S1457C3_nt ::v152(){vfunc_called(this, "_ZN10S1457C3_nt4v152Ev");}
void  S1457C3_nt ::v153(){vfunc_called(this, "_ZN10S1457C3_nt4v153Ev");}
void  S1457C3_nt ::v154(){vfunc_called(this, "_ZN10S1457C3_nt4v154Ev");}
void  S1457C3_nt ::v155(){vfunc_called(this, "_ZN10S1457C3_nt4v155Ev");}
void  S1457C3_nt ::v156(){vfunc_called(this, "_ZN10S1457C3_nt4v156Ev");}
void  S1457C3_nt ::v157(){vfunc_called(this, "_ZN10S1457C3_nt4v157Ev");}
void  S1457C3_nt ::v158(){vfunc_called(this, "_ZN10S1457C3_nt4v158Ev");}
void  S1457C3_nt ::v159(){vfunc_called(this, "_ZN10S1457C3_nt4v159Ev");}
void  S1457C3_nt ::v160(){vfunc_called(this, "_ZN10S1457C3_nt4v160Ev");}
void  S1457C3_nt ::v161(){vfunc_called(this, "_ZN10S1457C3_nt4v161Ev");}
void  S1457C3_nt ::v162(){vfunc_called(this, "_ZN10S1457C3_nt4v162Ev");}
void  S1457C3_nt ::v163(){vfunc_called(this, "_ZN10S1457C3_nt4v163Ev");}
void  S1457C3_nt ::v164(){vfunc_called(this, "_ZN10S1457C3_nt4v164Ev");}
void  S1457C3_nt ::v165(){vfunc_called(this, "_ZN10S1457C3_nt4v165Ev");}
void  S1457C3_nt ::v166(){vfunc_called(this, "_ZN10S1457C3_nt4v166Ev");}
void  S1457C3_nt ::v167(){vfunc_called(this, "_ZN10S1457C3_nt4v167Ev");}
void  S1457C3_nt ::v168(){vfunc_called(this, "_ZN10S1457C3_nt4v168Ev");}
void  S1457C3_nt ::v169(){vfunc_called(this, "_ZN10S1457C3_nt4v169Ev");}
void  S1457C3_nt ::v170(){vfunc_called(this, "_ZN10S1457C3_nt4v170Ev");}
void  S1457C3_nt ::v171(){vfunc_called(this, "_ZN10S1457C3_nt4v171Ev");}
void  S1457C3_nt ::v172(){vfunc_called(this, "_ZN10S1457C3_nt4v172Ev");}
void  S1457C3_nt ::v173(){vfunc_called(this, "_ZN10S1457C3_nt4v173Ev");}
void  S1457C3_nt ::v174(){vfunc_called(this, "_ZN10S1457C3_nt4v174Ev");}
void  S1457C3_nt ::v175(){vfunc_called(this, "_ZN10S1457C3_nt4v175Ev");}
void  S1457C3_nt ::v176(){vfunc_called(this, "_ZN10S1457C3_nt4v176Ev");}
void  S1457C3_nt ::v177(){vfunc_called(this, "_ZN10S1457C3_nt4v177Ev");}
void  S1457C3_nt ::v178(){vfunc_called(this, "_ZN10S1457C3_nt4v178Ev");}
void  S1457C3_nt ::v179(){vfunc_called(this, "_ZN10S1457C3_nt4v179Ev");}
void  S1457C3_nt ::v180(){vfunc_called(this, "_ZN10S1457C3_nt4v180Ev");}
void  S1457C3_nt ::v181(){vfunc_called(this, "_ZN10S1457C3_nt4v181Ev");}
void  S1457C3_nt ::v182(){vfunc_called(this, "_ZN10S1457C3_nt4v182Ev");}
void  S1457C3_nt ::v183(){vfunc_called(this, "_ZN10S1457C3_nt4v183Ev");}
void  S1457C3_nt ::v184(){vfunc_called(this, "_ZN10S1457C3_nt4v184Ev");}
void  S1457C3_nt ::v185(){vfunc_called(this, "_ZN10S1457C3_nt4v185Ev");}
void  S1457C3_nt ::v186(){vfunc_called(this, "_ZN10S1457C3_nt4v186Ev");}
void  S1457C3_nt ::v187(){vfunc_called(this, "_ZN10S1457C3_nt4v187Ev");}
void  S1457C3_nt ::v188(){vfunc_called(this, "_ZN10S1457C3_nt4v188Ev");}
void  S1457C3_nt ::v189(){vfunc_called(this, "_ZN10S1457C3_nt4v189Ev");}
void  S1457C3_nt ::v190(){vfunc_called(this, "_ZN10S1457C3_nt4v190Ev");}
void  S1457C3_nt ::v191(){vfunc_called(this, "_ZN10S1457C3_nt4v191Ev");}
void  S1457C3_nt ::v192(){vfunc_called(this, "_ZN10S1457C3_nt4v192Ev");}
void  S1457C3_nt ::v193(){vfunc_called(this, "_ZN10S1457C3_nt4v193Ev");}
void  S1457C3_nt ::v194(){vfunc_called(this, "_ZN10S1457C3_nt4v194Ev");}
void  S1457C3_nt ::v195(){vfunc_called(this, "_ZN10S1457C3_nt4v195Ev");}
void  S1457C3_nt ::v196(){vfunc_called(this, "_ZN10S1457C3_nt4v196Ev");}
void  S1457C3_nt ::v197(){vfunc_called(this, "_ZN10S1457C3_nt4v197Ev");}
void  S1457C3_nt ::v198(){vfunc_called(this, "_ZN10S1457C3_nt4v198Ev");}
void  S1457C3_nt ::v199(){vfunc_called(this, "_ZN10S1457C3_nt4v199Ev");}
void  S1457C3_nt ::v200(){vfunc_called(this, "_ZN10S1457C3_nt4v200Ev");}
void  S1457C3_nt ::v201(){vfunc_called(this, "_ZN10S1457C3_nt4v201Ev");}
void  S1457C3_nt ::v202(){vfunc_called(this, "_ZN10S1457C3_nt4v202Ev");}
void  S1457C3_nt ::v203(){vfunc_called(this, "_ZN10S1457C3_nt4v203Ev");}
void  S1457C3_nt ::v204(){vfunc_called(this, "_ZN10S1457C3_nt4v204Ev");}
void  S1457C3_nt ::v205(){vfunc_called(this, "_ZN10S1457C3_nt4v205Ev");}
void  S1457C3_nt ::v206(){vfunc_called(this, "_ZN10S1457C3_nt4v206Ev");}
void  S1457C3_nt ::v207(){vfunc_called(this, "_ZN10S1457C3_nt4v207Ev");}
void  S1457C3_nt ::v208(){vfunc_called(this, "_ZN10S1457C3_nt4v208Ev");}
void  S1457C3_nt ::v209(){vfunc_called(this, "_ZN10S1457C3_nt4v209Ev");}
void  S1457C3_nt ::v210(){vfunc_called(this, "_ZN10S1457C3_nt4v210Ev");}
void  S1457C3_nt ::v211(){vfunc_called(this, "_ZN10S1457C3_nt4v211Ev");}
S1457C3_nt ::S1457C3_nt(){ note_ctor("S1457C3_nt", this);} // tgen

//skip512 S1457C3_nt

#else // __cplusplus

extern void _ZN10S1457C3_ntC1Ev();
extern void _ZN10S1457C3_ntD1Ev();
Name_Map name_map_S1457C3_nt[] = {
  NSPAIR(_ZN10S1457C3_ntC1Ev),
  NSPAIR(_ZN10S1457C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1457C4_nt;
extern VTBL_ENTRY _ZTI10S1457C4_nt[];
extern  VTBL_ENTRY _ZTV10S1457C4_nt[];
static Base_Class bases_S1457C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1457C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S1457C3_nt[];
extern void _ZN10S1457C3_ntD1Ev();
extern void _ZN10S1457C3_ntD0Ev();
extern void _ZN10S1457C4_nt2v5Ev();
extern void _ZN10S1457C4_nt2v6Ev();
extern void _ZN10S1457C4_nt2v7Ev();
extern void _ZN10S1457C4_nt2v8Ev();
extern void _ZN10S1457C4_nt2v9Ev();
extern void _ZN10S1457C4_nt3v10Ev();
extern void _ZN10S1457C4_nt3v11Ev();
extern void _ZN10S1457C4_nt3v12Ev();
extern void _ZN10S1457C4_nt3v13Ev();
extern void _ZN10S1457C4_nt3v14Ev();
extern void _ZN10S1457C4_nt3v15Ev();
extern void _ZN10S1457C4_nt3v16Ev();
extern void _ZN10S1457C4_nt3v17Ev();
extern void _ZN10S1457C4_nt3v18Ev();
extern void _ZN10S1457C4_nt3v19Ev();
extern void _ZN10S1457C4_nt3v20Ev();
extern void _ZN10S1457C4_nt3v21Ev();
extern void _ZN10S1457C4_nt3v22Ev();
extern void _ZN10S1457C4_nt3v23Ev();
extern void _ZN10S1457C4_nt3v24Ev();
extern void _ZN10S1457C4_nt3v25Ev();
extern void _ZN10S1457C4_nt3v26Ev();
extern void _ZN10S1457C4_nt3v27Ev();
extern void _ZN10S1457C4_nt3v28Ev();
extern void _ZN10S1457C4_nt3v29Ev();
extern void _ZN10S1457C4_nt3v30Ev();
extern void _ZN10S1457C4_nt3v31Ev();
extern void _ZN10S1457C4_nt3v32Ev();
extern void _ZN10S1457C4_nt3v33Ev();
extern void _ZN10S1457C4_nt3v34Ev();
extern void _ZN10S1457C4_nt3v35Ev();
extern void _ZN10S1457C4_nt3v36Ev();
extern void _ZN10S1457C4_nt3v37Ev();
extern void _ZN10S1457C4_nt3v38Ev();
extern void _ZN10S1457C4_nt3v39Ev();
extern void _ZN10S1457C4_nt3v40Ev();
extern void _ZN10S1457C4_nt3v41Ev();
extern void _ZN10S1457C4_nt3v42Ev();
extern void _ZN10S1457C4_nt3v43Ev();
extern void _ZN10S1457C4_nt3v44Ev();
extern void _ZN10S1457C4_nt3v45Ev();
extern void _ZN10S1457C4_nt3v46Ev();
extern void _ZN10S1457C4_nt3v47Ev();
extern void _ZN10S1457C4_nt3v48Ev();
extern void _ZN10S1457C4_nt3v49Ev();
extern void _ZN10S1457C4_nt3v50Ev();
extern void _ZN10S1457C4_nt3v51Ev();
extern void _ZN10S1457C4_nt3v52Ev();
extern void _ZN10S1457C4_nt3v53Ev();
extern void _ZN10S1457C4_nt3v54Ev();
extern void _ZN10S1457C4_nt3v55Ev();
extern void _ZN10S1457C4_nt3v56Ev();
extern void _ZN10S1457C4_nt3v57Ev();
extern void _ZN10S1457C4_nt3v58Ev();
extern void _ZN10S1457C4_nt3v59Ev();
extern void _ZN10S1457C4_nt3v60Ev();
extern void _ZN10S1457C4_nt3v61Ev();
extern void _ZN10S1457C4_nt3v62Ev();
extern void _ZN10S1457C4_nt3v63Ev();
extern void _ZN10S1457C4_nt3v64Ev();
extern void _ZN10S1457C4_nt3v65Ev();
extern void _ZN10S1457C4_nt3v66Ev();
extern void _ZN10S1457C4_nt3v67Ev();
extern void _ZN10S1457C4_nt3v68Ev();
extern void _ZN10S1457C3_nt3v69Ev();
extern void _ZN10S1457C3_nt3v70Ev();
extern void _ZN10S1457C3_nt3v71Ev();
extern void _ZN10S1457C3_nt3v72Ev();
extern void _ZN10S1457C3_nt3v73Ev();
extern void _ZN10S1457C3_nt3v74Ev();
extern void _ZN10S1457C3_nt3v75Ev();
extern void _ZN10S1457C3_nt3v76Ev();
extern void _ZN10S1457C3_nt3v77Ev();
extern void _ZN10S1457C3_nt3v78Ev();
extern void _ZN10S1457C3_nt3v79Ev();
extern void _ZN10S1457C3_nt3v80Ev();
extern void _ZN10S1457C3_nt3v81Ev();
extern void _ZN10S1457C3_nt3v82Ev();
extern void _ZN10S1457C3_nt3v83Ev();
extern void _ZN10S1457C3_nt3v84Ev();
extern void _ZN10S1457C3_nt3v85Ev();
extern void _ZN10S1457C3_nt3v86Ev();
extern void _ZN10S1457C3_nt3v87Ev();
extern void _ZN10S1457C3_nt3v88Ev();
extern void _ZN10S1457C3_nt3v89Ev();
extern void _ZN10S1457C3_nt3v90Ev();
extern void _ZN10S1457C3_nt3v91Ev();
extern void _ZN10S1457C3_nt3v92Ev();
extern void _ZN10S1457C3_nt3v93Ev();
extern void _ZN10S1457C3_nt3v94Ev();
extern void _ZN10S1457C3_nt3v95Ev();
extern void _ZN10S1457C3_nt3v96Ev();
extern void _ZN10S1457C3_nt3v97Ev();
extern void _ZN10S1457C3_nt3v98Ev();
extern void _ZN10S1457C3_nt3v99Ev();
extern void _ZN10S1457C3_nt4v100Ev();
extern void _ZN10S1457C3_nt4v101Ev();
extern void _ZN10S1457C3_nt4v102Ev();
extern void _ZN10S1457C3_nt4v103Ev();
extern void _ZN10S1457C3_nt4v104Ev();
extern void _ZN10S1457C3_nt4v105Ev();
extern void _ZN10S1457C3_nt4v106Ev();
extern void _ZN10S1457C3_nt4v107Ev();
extern void _ZN10S1457C3_nt4v108Ev();
extern void _ZN10S1457C3_nt4v109Ev();
extern void _ZN10S1457C3_nt4v110Ev();
extern void _ZN10S1457C3_nt4v111Ev();
extern void _ZN10S1457C3_nt4v112Ev();
extern void _ZN10S1457C3_nt4v113Ev();
extern void _ZN10S1457C3_nt4v114Ev();
extern void _ZN10S1457C3_nt4v115Ev();
extern void _ZN10S1457C3_nt4v116Ev();
extern void _ZN10S1457C3_nt4v117Ev();
extern void _ZN10S1457C3_nt4v118Ev();
extern void _ZN10S1457C3_nt4v119Ev();
extern void _ZN10S1457C3_nt4v120Ev();
extern void _ZN10S1457C3_nt4v121Ev();
extern void _ZN10S1457C3_nt4v122Ev();
extern void _ZN10S1457C3_nt4v123Ev();
extern void _ZN10S1457C3_nt4v124Ev();
extern void _ZN10S1457C3_nt4v125Ev();
extern void _ZN10S1457C3_nt4v126Ev();
extern void _ZN10S1457C3_nt4v127Ev();
extern void _ZN10S1457C3_nt4v128Ev();
extern void _ZN10S1457C3_nt4v129Ev();
extern void _ZN10S1457C3_nt4v130Ev();
extern void _ZN10S1457C3_nt4v131Ev();
extern void _ZN10S1457C3_nt4v132Ev();
extern void _ZN10S1457C3_nt4v133Ev();
extern void _ZN10S1457C3_nt4v134Ev();
extern void _ZN10S1457C3_nt4v135Ev();
extern void _ZN10S1457C3_nt4v136Ev();
extern void _ZN10S1457C3_nt4v137Ev();
extern void _ZN10S1457C3_nt4v138Ev();
extern void _ZN10S1457C3_nt4v139Ev();
extern void _ZN10S1457C3_nt4v140Ev();
extern void _ZN10S1457C3_nt4v141Ev();
extern void _ZN10S1457C3_nt4v142Ev();
extern void _ZN10S1457C3_nt4v143Ev();
extern void _ZN10S1457C3_nt4v144Ev();
extern void _ZN10S1457C3_nt4v145Ev();
extern void _ZN10S1457C3_nt4v146Ev();
extern void _ZN10S1457C3_nt4v147Ev();
extern void _ZN10S1457C3_nt4v148Ev();
extern void _ZN10S1457C3_nt4v149Ev();
extern void _ZN10S1457C3_nt4v150Ev();
extern void _ZN10S1457C3_nt4v151Ev();
extern void _ZN10S1457C3_nt4v152Ev();
extern void _ZN10S1457C3_nt4v153Ev();
extern void _ZN10S1457C3_nt4v154Ev();
extern void _ZN10S1457C3_nt4v155Ev();
extern void _ZN10S1457C3_nt4v156Ev();
extern void _ZN10S1457C3_nt4v157Ev();
extern void _ZN10S1457C3_nt4v158Ev();
extern void _ZN10S1457C3_nt4v159Ev();
extern void _ZN10S1457C3_nt4v160Ev();
extern void _ZN10S1457C3_nt4v161Ev();
extern void _ZN10S1457C3_nt4v162Ev();
extern void _ZN10S1457C3_nt4v163Ev();
extern void _ZN10S1457C3_nt4v164Ev();
extern void _ZN10S1457C3_nt4v165Ev();
extern void _ZN10S1457C3_nt4v166Ev();
extern void _ZN10S1457C3_nt4v167Ev();
extern void _ZN10S1457C3_nt4v168Ev();
extern void _ZN10S1457C3_nt4v169Ev();
extern void _ZN10S1457C3_nt4v170Ev();
extern void _ZN10S1457C3_nt4v171Ev();
extern void _ZN10S1457C3_nt4v172Ev();
extern void _ZN10S1457C3_nt4v173Ev();
extern void _ZN10S1457C3_nt4v174Ev();
extern void _ZN10S1457C3_nt4v175Ev();
extern void _ZN10S1457C3_nt4v176Ev();
extern void _ZN10S1457C3_nt4v177Ev();
extern void _ZN10S1457C3_nt4v178Ev();
extern void _ZN10S1457C3_nt4v179Ev();
extern void _ZN10S1457C3_nt4v180Ev();
extern void _ZN10S1457C3_nt4v181Ev();
extern void _ZN10S1457C3_nt4v182Ev();
extern void _ZN10S1457C3_nt4v183Ev();
extern void _ZN10S1457C3_nt4v184Ev();
extern void _ZN10S1457C3_nt4v185Ev();
extern void _ZN10S1457C3_nt4v186Ev();
extern void _ZN10S1457C3_nt4v187Ev();
extern void _ZN10S1457C3_nt4v188Ev();
extern void _ZN10S1457C3_nt4v189Ev();
extern void _ZN10S1457C3_nt4v190Ev();
extern void _ZN10S1457C3_nt4v191Ev();
extern void _ZN10S1457C3_nt4v192Ev();
extern void _ZN10S1457C3_nt4v193Ev();
extern void _ZN10S1457C3_nt4v194Ev();
extern void _ZN10S1457C3_nt4v195Ev();
extern void _ZN10S1457C3_nt4v196Ev();
extern void _ZN10S1457C3_nt4v197Ev();
extern void _ZN10S1457C3_nt4v198Ev();
extern void _ZN10S1457C3_nt4v199Ev();
extern void _ZN10S1457C3_nt4v200Ev();
extern void _ZN10S1457C3_nt4v201Ev();
extern void _ZN10S1457C3_nt4v202Ev();
extern void _ZN10S1457C3_nt4v203Ev();
extern void _ZN10S1457C3_nt4v204Ev();
extern void _ZN10S1457C3_nt4v205Ev();
extern void _ZN10S1457C3_nt4v206Ev();
extern void _ZN10S1457C3_nt4v207Ev();
extern void _ZN10S1457C3_nt4v208Ev();
extern void _ZN10S1457C3_nt4v209Ev();
extern void _ZN10S1457C3_nt4v210Ev();
extern void _ZN10S1457C3_nt4v211Ev();
static  VTBL_ENTRY vtc_S1457C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1457C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S1457C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v211Ev,
};
extern VTBL_ENTRY _ZTI10S1457C3_nt[];
VTBL_ENTRY *P__ZTI10S1457C3_nt = _ZTI10S1457C3_nt; 
extern  VTBL_ENTRY _ZTV10S1457C3_nt[];
Class_Descriptor cd_S1457C3_nt = {  "S1457C3_nt", // class name
  bases_S1457C3_nt, 1,
  &(vtc_S1457C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(568,436), // object size
  NSPAIRA(_ZTI10S1457C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S1457C3_nt),211, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1457C2  : S1457C3_nt {
  virtual  ~S1457C2(); // _ZN7S1457C2D1Ev
  virtual void  v212(); // _ZN7S1457C24v212Ev
  virtual void  v213(); // _ZN7S1457C24v213Ev
  virtual void  v214(); // _ZN7S1457C24v214Ev
  S1457C2(); // tgen
};
//SIG(-1 S1457C2) C1{ BC2{ BC3{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC5 FC8{ m Fi} Fi Fc[4] Fp[2] FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC4 FC4 FC4 FC9{ BC10{ BC7}} FC9 Fi Fp[2] FC11{ m Fi[3]} FC11 FC11 FC11 Fp FC4 FC9 FC11 FC11 Fi FC11 FC11 Fp Fi Fc FC11 FC11 Fp Fi Fp FC9 FC12{ BC13{ BC7}} FC12} vd v1 v2 v3}


 S1457C2 ::~S1457C2(){ note_dtor("S1457C2", this);}
void  S1457C2 ::v212(){vfunc_called(this, "_ZN7S1457C24v212Ev");}
void  S1457C2 ::v213(){vfunc_called(this, "_ZN7S1457C24v213Ev");}
void  S1457C2 ::v214(){vfunc_called(this, "_ZN7S1457C24v214Ev");}
S1457C2 ::S1457C2(){ note_ctor("S1457C2", this);} // tgen

static void Test_S1457C2()
{
  extern Class_Descriptor cd_S1457C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(72,110)];
    init_test(&cd_S1457C2, buf);
    S1457C2 *dp, &lv = *(dp=new (buf) S1457C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(568,436), "sizeof(S1457C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1457C2)");
    check_base_class_offset(lv, (S1457C4_nt*)(S1457C3_nt*), 0, "S1457C2");
    check_base_class_offset(lv, (S1457C3_nt*), 0, "S1457C2");
    test_class_info(&lv, &cd_S1457C2);
    dp->~S1457C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1457C2(Test_S1457C2, "S1457C2", ABISELECT(568,436));

#else // __cplusplus

extern void _ZN7S1457C2C1Ev();
extern void _ZN7S1457C2D1Ev();
Name_Map name_map_S1457C2[] = {
  NSPAIR(_ZN7S1457C2C1Ev),
  NSPAIR(_ZN7S1457C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1457C4_nt;
extern VTBL_ENTRY _ZTI10S1457C4_nt[];
extern  VTBL_ENTRY _ZTV10S1457C4_nt[];
extern Class_Descriptor cd_S1457C3_nt;
extern VTBL_ENTRY _ZTI10S1457C3_nt[];
extern  VTBL_ENTRY _ZTV10S1457C3_nt[];
static Base_Class bases_S1457C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1457C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1457C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1457C2[];
extern void _ZN7S1457C2D1Ev();
extern void _ZN7S1457C2D0Ev();
extern void _ZN10S1457C4_nt2v5Ev();
extern void _ZN10S1457C4_nt2v6Ev();
extern void _ZN10S1457C4_nt2v7Ev();
extern void _ZN10S1457C4_nt2v8Ev();
extern void _ZN10S1457C4_nt2v9Ev();
extern void _ZN10S1457C4_nt3v10Ev();
extern void _ZN10S1457C4_nt3v11Ev();
extern void _ZN10S1457C4_nt3v12Ev();
extern void _ZN10S1457C4_nt3v13Ev();
extern void _ZN10S1457C4_nt3v14Ev();
extern void _ZN10S1457C4_nt3v15Ev();
extern void _ZN10S1457C4_nt3v16Ev();
extern void _ZN10S1457C4_nt3v17Ev();
extern void _ZN10S1457C4_nt3v18Ev();
extern void _ZN10S1457C4_nt3v19Ev();
extern void _ZN10S1457C4_nt3v20Ev();
extern void _ZN10S1457C4_nt3v21Ev();
extern void _ZN10S1457C4_nt3v22Ev();
extern void _ZN10S1457C4_nt3v23Ev();
extern void _ZN10S1457C4_nt3v24Ev();
extern void _ZN10S1457C4_nt3v25Ev();
extern void _ZN10S1457C4_nt3v26Ev();
extern void _ZN10S1457C4_nt3v27Ev();
extern void _ZN10S1457C4_nt3v28Ev();
extern void _ZN10S1457C4_nt3v29Ev();
extern void _ZN10S1457C4_nt3v30Ev();
extern void _ZN10S1457C4_nt3v31Ev();
extern void _ZN10S1457C4_nt3v32Ev();
extern void _ZN10S1457C4_nt3v33Ev();
extern void _ZN10S1457C4_nt3v34Ev();
extern void _ZN10S1457C4_nt3v35Ev();
extern void _ZN10S1457C4_nt3v36Ev();
extern void _ZN10S1457C4_nt3v37Ev();
extern void _ZN10S1457C4_nt3v38Ev();
extern void _ZN10S1457C4_nt3v39Ev();
extern void _ZN10S1457C4_nt3v40Ev();
extern void _ZN10S1457C4_nt3v41Ev();
extern void _ZN10S1457C4_nt3v42Ev();
extern void _ZN10S1457C4_nt3v43Ev();
extern void _ZN10S1457C4_nt3v44Ev();
extern void _ZN10S1457C4_nt3v45Ev();
extern void _ZN10S1457C4_nt3v46Ev();
extern void _ZN10S1457C4_nt3v47Ev();
extern void _ZN10S1457C4_nt3v48Ev();
extern void _ZN10S1457C4_nt3v49Ev();
extern void _ZN10S1457C4_nt3v50Ev();
extern void _ZN10S1457C4_nt3v51Ev();
extern void _ZN10S1457C4_nt3v52Ev();
extern void _ZN10S1457C4_nt3v53Ev();
extern void _ZN10S1457C4_nt3v54Ev();
extern void _ZN10S1457C4_nt3v55Ev();
extern void _ZN10S1457C4_nt3v56Ev();
extern void _ZN10S1457C4_nt3v57Ev();
extern void _ZN10S1457C4_nt3v58Ev();
extern void _ZN10S1457C4_nt3v59Ev();
extern void _ZN10S1457C4_nt3v60Ev();
extern void _ZN10S1457C4_nt3v61Ev();
extern void _ZN10S1457C4_nt3v62Ev();
extern void _ZN10S1457C4_nt3v63Ev();
extern void _ZN10S1457C4_nt3v64Ev();
extern void _ZN10S1457C4_nt3v65Ev();
extern void _ZN10S1457C4_nt3v66Ev();
extern void _ZN10S1457C4_nt3v67Ev();
extern void _ZN10S1457C4_nt3v68Ev();
extern void _ZN10S1457C3_nt3v69Ev();
extern void _ZN10S1457C3_nt3v70Ev();
extern void _ZN10S1457C3_nt3v71Ev();
extern void _ZN10S1457C3_nt3v72Ev();
extern void _ZN10S1457C3_nt3v73Ev();
extern void _ZN10S1457C3_nt3v74Ev();
extern void _ZN10S1457C3_nt3v75Ev();
extern void _ZN10S1457C3_nt3v76Ev();
extern void _ZN10S1457C3_nt3v77Ev();
extern void _ZN10S1457C3_nt3v78Ev();
extern void _ZN10S1457C3_nt3v79Ev();
extern void _ZN10S1457C3_nt3v80Ev();
extern void _ZN10S1457C3_nt3v81Ev();
extern void _ZN10S1457C3_nt3v82Ev();
extern void _ZN10S1457C3_nt3v83Ev();
extern void _ZN10S1457C3_nt3v84Ev();
extern void _ZN10S1457C3_nt3v85Ev();
extern void _ZN10S1457C3_nt3v86Ev();
extern void _ZN10S1457C3_nt3v87Ev();
extern void _ZN10S1457C3_nt3v88Ev();
extern void _ZN10S1457C3_nt3v89Ev();
extern void _ZN10S1457C3_nt3v90Ev();
extern void _ZN10S1457C3_nt3v91Ev();
extern void _ZN10S1457C3_nt3v92Ev();
extern void _ZN10S1457C3_nt3v93Ev();
extern void _ZN10S1457C3_nt3v94Ev();
extern void _ZN10S1457C3_nt3v95Ev();
extern void _ZN10S1457C3_nt3v96Ev();
extern void _ZN10S1457C3_nt3v97Ev();
extern void _ZN10S1457C3_nt3v98Ev();
extern void _ZN10S1457C3_nt3v99Ev();
extern void _ZN10S1457C3_nt4v100Ev();
extern void _ZN10S1457C3_nt4v101Ev();
extern void _ZN10S1457C3_nt4v102Ev();
extern void _ZN10S1457C3_nt4v103Ev();
extern void _ZN10S1457C3_nt4v104Ev();
extern void _ZN10S1457C3_nt4v105Ev();
extern void _ZN10S1457C3_nt4v106Ev();
extern void _ZN10S1457C3_nt4v107Ev();
extern void _ZN10S1457C3_nt4v108Ev();
extern void _ZN10S1457C3_nt4v109Ev();
extern void _ZN10S1457C3_nt4v110Ev();
extern void _ZN10S1457C3_nt4v111Ev();
extern void _ZN10S1457C3_nt4v112Ev();
extern void _ZN10S1457C3_nt4v113Ev();
extern void _ZN10S1457C3_nt4v114Ev();
extern void _ZN10S1457C3_nt4v115Ev();
extern void _ZN10S1457C3_nt4v116Ev();
extern void _ZN10S1457C3_nt4v117Ev();
extern void _ZN10S1457C3_nt4v118Ev();
extern void _ZN10S1457C3_nt4v119Ev();
extern void _ZN10S1457C3_nt4v120Ev();
extern void _ZN10S1457C3_nt4v121Ev();
extern void _ZN10S1457C3_nt4v122Ev();
extern void _ZN10S1457C3_nt4v123Ev();
extern void _ZN10S1457C3_nt4v124Ev();
extern void _ZN10S1457C3_nt4v125Ev();
extern void _ZN10S1457C3_nt4v126Ev();
extern void _ZN10S1457C3_nt4v127Ev();
extern void _ZN10S1457C3_nt4v128Ev();
extern void _ZN10S1457C3_nt4v129Ev();
extern void _ZN10S1457C3_nt4v130Ev();
extern void _ZN10S1457C3_nt4v131Ev();
extern void _ZN10S1457C3_nt4v132Ev();
extern void _ZN10S1457C3_nt4v133Ev();
extern void _ZN10S1457C3_nt4v134Ev();
extern void _ZN10S1457C3_nt4v135Ev();
extern void _ZN10S1457C3_nt4v136Ev();
extern void _ZN10S1457C3_nt4v137Ev();
extern void _ZN10S1457C3_nt4v138Ev();
extern void _ZN10S1457C3_nt4v139Ev();
extern void _ZN10S1457C3_nt4v140Ev();
extern void _ZN10S1457C3_nt4v141Ev();
extern void _ZN10S1457C3_nt4v142Ev();
extern void _ZN10S1457C3_nt4v143Ev();
extern void _ZN10S1457C3_nt4v144Ev();
extern void _ZN10S1457C3_nt4v145Ev();
extern void _ZN10S1457C3_nt4v146Ev();
extern void _ZN10S1457C3_nt4v147Ev();
extern void _ZN10S1457C3_nt4v148Ev();
extern void _ZN10S1457C3_nt4v149Ev();
extern void _ZN10S1457C3_nt4v150Ev();
extern void _ZN10S1457C3_nt4v151Ev();
extern void _ZN10S1457C3_nt4v152Ev();
extern void _ZN10S1457C3_nt4v153Ev();
extern void _ZN10S1457C3_nt4v154Ev();
extern void _ZN10S1457C3_nt4v155Ev();
extern void _ZN10S1457C3_nt4v156Ev();
extern void _ZN10S1457C3_nt4v157Ev();
extern void _ZN10S1457C3_nt4v158Ev();
extern void _ZN10S1457C3_nt4v159Ev();
extern void _ZN10S1457C3_nt4v160Ev();
extern void _ZN10S1457C3_nt4v161Ev();
extern void _ZN10S1457C3_nt4v162Ev();
extern void _ZN10S1457C3_nt4v163Ev();
extern void _ZN10S1457C3_nt4v164Ev();
extern void _ZN10S1457C3_nt4v165Ev();
extern void _ZN10S1457C3_nt4v166Ev();
extern void _ZN10S1457C3_nt4v167Ev();
extern void _ZN10S1457C3_nt4v168Ev();
extern void _ZN10S1457C3_nt4v169Ev();
extern void _ZN10S1457C3_nt4v170Ev();
extern void _ZN10S1457C3_nt4v171Ev();
extern void _ZN10S1457C3_nt4v172Ev();
extern void _ZN10S1457C3_nt4v173Ev();
extern void _ZN10S1457C3_nt4v174Ev();
extern void _ZN10S1457C3_nt4v175Ev();
extern void _ZN10S1457C3_nt4v176Ev();
extern void _ZN10S1457C3_nt4v177Ev();
extern void _ZN10S1457C3_nt4v178Ev();
extern void _ZN10S1457C3_nt4v179Ev();
extern void _ZN10S1457C3_nt4v180Ev();
extern void _ZN10S1457C3_nt4v181Ev();
extern void _ZN10S1457C3_nt4v182Ev();
extern void _ZN10S1457C3_nt4v183Ev();
extern void _ZN10S1457C3_nt4v184Ev();
extern void _ZN10S1457C3_nt4v185Ev();
extern void _ZN10S1457C3_nt4v186Ev();
extern void _ZN10S1457C3_nt4v187Ev();
extern void _ZN10S1457C3_nt4v188Ev();
extern void _ZN10S1457C3_nt4v189Ev();
extern void _ZN10S1457C3_nt4v190Ev();
extern void _ZN10S1457C3_nt4v191Ev();
extern void _ZN10S1457C3_nt4v192Ev();
extern void _ZN10S1457C3_nt4v193Ev();
extern void _ZN10S1457C3_nt4v194Ev();
extern void _ZN10S1457C3_nt4v195Ev();
extern void _ZN10S1457C3_nt4v196Ev();
extern void _ZN10S1457C3_nt4v197Ev();
extern void _ZN10S1457C3_nt4v198Ev();
extern void _ZN10S1457C3_nt4v199Ev();
extern void _ZN10S1457C3_nt4v200Ev();
extern void _ZN10S1457C3_nt4v201Ev();
extern void _ZN10S1457C3_nt4v202Ev();
extern void _ZN10S1457C3_nt4v203Ev();
extern void _ZN10S1457C3_nt4v204Ev();
extern void _ZN10S1457C3_nt4v205Ev();
extern void _ZN10S1457C3_nt4v206Ev();
extern void _ZN10S1457C3_nt4v207Ev();
extern void _ZN10S1457C3_nt4v208Ev();
extern void _ZN10S1457C3_nt4v209Ev();
extern void _ZN10S1457C3_nt4v210Ev();
extern void _ZN10S1457C3_nt4v211Ev();
extern void _ZN7S1457C24v212Ev();
extern void _ZN7S1457C24v213Ev();
extern void _ZN7S1457C24v214Ev();
static  VTBL_ENTRY vtc_S1457C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1457C2[0]),
  (VTBL_ENTRY)&_ZN7S1457C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1457C2D0Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v211Ev,
  (VTBL_ENTRY)&_ZN7S1457C24v212Ev,
  (VTBL_ENTRY)&_ZN7S1457C24v213Ev,
  (VTBL_ENTRY)&_ZN7S1457C24v214Ev,
};
extern VTBL_ENTRY _ZTI7S1457C2[];
extern  VTBL_ENTRY _ZTV7S1457C2[];
Class_Descriptor cd_S1457C2 = {  "S1457C2", // class name
  bases_S1457C2, 2,
  &(vtc_S1457C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(568,436), // object size
  NSPAIRA(_ZTI7S1457C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1457C2),214, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1457C23  : S1457C8_nt {
};
//SIG(-1 S1457C23) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1457C23()
{
  extern Class_Descriptor cd_S1457C23;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1457C23, buf);
    S1457C23 &lv = *(new (buf) S1457C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1457C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1457C23)");
    check_base_class_offset(lv, (S1457C8_nt*), 0, "S1457C23");
    test_class_info(&lv, &cd_S1457C23);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1457C23(Test_S1457C23, "S1457C23", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1457C8_nt;
static Base_Class bases_S1457C23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1457C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1457C23 = {  "S1457C23", // class name
  bases_S1457C23, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1457C22  : S1457C23 {
};
//SIG(-1 S1457C22) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1457C22()
{
  extern Class_Descriptor cd_S1457C22;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1457C22, buf);
    S1457C22 &lv = *(new (buf) S1457C22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1457C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1457C22)");
    check_base_class_offset(lv, (S1457C8_nt*)(S1457C23*), 0, "S1457C22");
    check_base_class_offset(lv, (S1457C23*), 0, "S1457C22");
    test_class_info(&lv, &cd_S1457C22);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1457C22(Test_S1457C22, "S1457C22", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1457C8_nt;
extern Class_Descriptor cd_S1457C23;
static Base_Class bases_S1457C22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1457C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1457C23,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1457C22 = {  "S1457C22", // class name
  bases_S1457C22, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1457C1  : S1457C2 {
  ::S1457C22 s1457c1f0;
  int s1457c1f1;
  virtual  ~S1457C1(); // _ZN7S1457C1D1Ev
  virtual void  v1(); // _ZN7S1457C12v1Ev
  virtual void  v2(); // _ZN7S1457C12v2Ev
  virtual void  v3(); // _ZN7S1457C12v3Ev
  virtual void  v4(); // _ZN7S1457C12v4Ev
  S1457C1(); // tgen
};
//SIG(1 S1457C1) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC6 FC9{ m Fi} Fi Fc[4] Fp[2] FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC5 FC5 FC5 FC10{ BC11{ BC8}} FC10 Fi Fp[2] FC12{ m Fi[3]} FC12 FC12 FC12 Fp FC5 FC10 FC12 FC12 Fi FC12 FC12 Fp Fi Fc FC12 FC12 Fp Fi Fp FC10 FC13{ BC14{ BC8}} FC13} vd v212 v213 v214} vd v1 v2 v3 v4 FC15{ BC16{ BC8}} Fi}


 S1457C1 ::~S1457C1(){ note_dtor("S1457C1", this);}
void  S1457C1 ::v1(){vfunc_called(this, "_ZN7S1457C12v1Ev");}
void  S1457C1 ::v2(){vfunc_called(this, "_ZN7S1457C12v2Ev");}
void  S1457C1 ::v3(){vfunc_called(this, "_ZN7S1457C12v3Ev");}
void  S1457C1 ::v4(){vfunc_called(this, "_ZN7S1457C12v4Ev");}
S1457C1 ::S1457C1(){ note_ctor("S1457C1", this);} // tgen

static void Test_S1457C1()
{
  extern Class_Descriptor cd_S1457C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(75,114)];
    init_test(&cd_S1457C1, buf);
    S1457C1 *dp, &lv = *(dp=new (buf) S1457C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(592,452), "sizeof(S1457C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1457C1)");
    check_base_class_offset(lv, (S1457C4_nt*)(S1457C3_nt*)(S1457C2*), 0, "S1457C1");
    check_base_class_offset(lv, (S1457C3_nt*)(S1457C2*), 0, "S1457C1");
    check_base_class_offset(lv, (S1457C2*), 0, "S1457C1");
    check_field_offset(lv, s1457c1f0, ABISELECT(568,436), "S1457C1.s1457c1f0");
    check_field_offset(lv, s1457c1f1, ABISELECT(584,448), "S1457C1.s1457c1f1");
    test_class_info(&lv, &cd_S1457C1);
    dp->~S1457C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1457C1(Test_S1457C1, "S1457C1", ABISELECT(592,452));

#else // __cplusplus

extern void _ZN7S1457C1C1Ev();
extern void _ZN7S1457C1D1Ev();
Name_Map name_map_S1457C1[] = {
  NSPAIR(_ZN7S1457C1C1Ev),
  NSPAIR(_ZN7S1457C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1457C4_nt;
extern VTBL_ENTRY _ZTI10S1457C4_nt[];
extern  VTBL_ENTRY _ZTV10S1457C4_nt[];
extern Class_Descriptor cd_S1457C3_nt;
extern VTBL_ENTRY _ZTI10S1457C3_nt[];
extern  VTBL_ENTRY _ZTV10S1457C3_nt[];
extern Class_Descriptor cd_S1457C2;
extern VTBL_ENTRY _ZTI7S1457C2[];
extern  VTBL_ENTRY _ZTV7S1457C2[];
static Base_Class bases_S1457C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1457C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1457C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1457C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1457C1[];
extern void _ZN7S1457C1D1Ev();
extern void _ZN7S1457C1D0Ev();
extern void _ZN10S1457C4_nt2v5Ev();
extern void _ZN10S1457C4_nt2v6Ev();
extern void _ZN10S1457C4_nt2v7Ev();
extern void _ZN10S1457C4_nt2v8Ev();
extern void _ZN10S1457C4_nt2v9Ev();
extern void _ZN10S1457C4_nt3v10Ev();
extern void _ZN10S1457C4_nt3v11Ev();
extern void _ZN10S1457C4_nt3v12Ev();
extern void _ZN10S1457C4_nt3v13Ev();
extern void _ZN10S1457C4_nt3v14Ev();
extern void _ZN10S1457C4_nt3v15Ev();
extern void _ZN10S1457C4_nt3v16Ev();
extern void _ZN10S1457C4_nt3v17Ev();
extern void _ZN10S1457C4_nt3v18Ev();
extern void _ZN10S1457C4_nt3v19Ev();
extern void _ZN10S1457C4_nt3v20Ev();
extern void _ZN10S1457C4_nt3v21Ev();
extern void _ZN10S1457C4_nt3v22Ev();
extern void _ZN10S1457C4_nt3v23Ev();
extern void _ZN10S1457C4_nt3v24Ev();
extern void _ZN10S1457C4_nt3v25Ev();
extern void _ZN10S1457C4_nt3v26Ev();
extern void _ZN10S1457C4_nt3v27Ev();
extern void _ZN10S1457C4_nt3v28Ev();
extern void _ZN10S1457C4_nt3v29Ev();
extern void _ZN10S1457C4_nt3v30Ev();
extern void _ZN10S1457C4_nt3v31Ev();
extern void _ZN10S1457C4_nt3v32Ev();
extern void _ZN10S1457C4_nt3v33Ev();
extern void _ZN10S1457C4_nt3v34Ev();
extern void _ZN10S1457C4_nt3v35Ev();
extern void _ZN10S1457C4_nt3v36Ev();
extern void _ZN10S1457C4_nt3v37Ev();
extern void _ZN10S1457C4_nt3v38Ev();
extern void _ZN10S1457C4_nt3v39Ev();
extern void _ZN10S1457C4_nt3v40Ev();
extern void _ZN10S1457C4_nt3v41Ev();
extern void _ZN10S1457C4_nt3v42Ev();
extern void _ZN10S1457C4_nt3v43Ev();
extern void _ZN10S1457C4_nt3v44Ev();
extern void _ZN10S1457C4_nt3v45Ev();
extern void _ZN10S1457C4_nt3v46Ev();
extern void _ZN10S1457C4_nt3v47Ev();
extern void _ZN10S1457C4_nt3v48Ev();
extern void _ZN10S1457C4_nt3v49Ev();
extern void _ZN10S1457C4_nt3v50Ev();
extern void _ZN10S1457C4_nt3v51Ev();
extern void _ZN10S1457C4_nt3v52Ev();
extern void _ZN10S1457C4_nt3v53Ev();
extern void _ZN10S1457C4_nt3v54Ev();
extern void _ZN10S1457C4_nt3v55Ev();
extern void _ZN10S1457C4_nt3v56Ev();
extern void _ZN10S1457C4_nt3v57Ev();
extern void _ZN10S1457C4_nt3v58Ev();
extern void _ZN10S1457C4_nt3v59Ev();
extern void _ZN10S1457C4_nt3v60Ev();
extern void _ZN10S1457C4_nt3v61Ev();
extern void _ZN10S1457C4_nt3v62Ev();
extern void _ZN10S1457C4_nt3v63Ev();
extern void _ZN10S1457C4_nt3v64Ev();
extern void _ZN10S1457C4_nt3v65Ev();
extern void _ZN10S1457C4_nt3v66Ev();
extern void _ZN10S1457C4_nt3v67Ev();
extern void _ZN10S1457C4_nt3v68Ev();
extern void _ZN10S1457C3_nt3v69Ev();
extern void _ZN10S1457C3_nt3v70Ev();
extern void _ZN10S1457C3_nt3v71Ev();
extern void _ZN10S1457C3_nt3v72Ev();
extern void _ZN10S1457C3_nt3v73Ev();
extern void _ZN10S1457C3_nt3v74Ev();
extern void _ZN10S1457C3_nt3v75Ev();
extern void _ZN10S1457C3_nt3v76Ev();
extern void _ZN10S1457C3_nt3v77Ev();
extern void _ZN10S1457C3_nt3v78Ev();
extern void _ZN10S1457C3_nt3v79Ev();
extern void _ZN10S1457C3_nt3v80Ev();
extern void _ZN10S1457C3_nt3v81Ev();
extern void _ZN10S1457C3_nt3v82Ev();
extern void _ZN10S1457C3_nt3v83Ev();
extern void _ZN10S1457C3_nt3v84Ev();
extern void _ZN10S1457C3_nt3v85Ev();
extern void _ZN10S1457C3_nt3v86Ev();
extern void _ZN10S1457C3_nt3v87Ev();
extern void _ZN10S1457C3_nt3v88Ev();
extern void _ZN10S1457C3_nt3v89Ev();
extern void _ZN10S1457C3_nt3v90Ev();
extern void _ZN10S1457C3_nt3v91Ev();
extern void _ZN10S1457C3_nt3v92Ev();
extern void _ZN10S1457C3_nt3v93Ev();
extern void _ZN10S1457C3_nt3v94Ev();
extern void _ZN10S1457C3_nt3v95Ev();
extern void _ZN10S1457C3_nt3v96Ev();
extern void _ZN10S1457C3_nt3v97Ev();
extern void _ZN10S1457C3_nt3v98Ev();
extern void _ZN10S1457C3_nt3v99Ev();
extern void _ZN10S1457C3_nt4v100Ev();
extern void _ZN10S1457C3_nt4v101Ev();
extern void _ZN10S1457C3_nt4v102Ev();
extern void _ZN10S1457C3_nt4v103Ev();
extern void _ZN10S1457C3_nt4v104Ev();
extern void _ZN10S1457C3_nt4v105Ev();
extern void _ZN10S1457C3_nt4v106Ev();
extern void _ZN10S1457C3_nt4v107Ev();
extern void _ZN10S1457C3_nt4v108Ev();
extern void _ZN10S1457C3_nt4v109Ev();
extern void _ZN10S1457C3_nt4v110Ev();
extern void _ZN10S1457C3_nt4v111Ev();
extern void _ZN10S1457C3_nt4v112Ev();
extern void _ZN10S1457C3_nt4v113Ev();
extern void _ZN10S1457C3_nt4v114Ev();
extern void _ZN10S1457C3_nt4v115Ev();
extern void _ZN10S1457C3_nt4v116Ev();
extern void _ZN10S1457C3_nt4v117Ev();
extern void _ZN10S1457C3_nt4v118Ev();
extern void _ZN10S1457C3_nt4v119Ev();
extern void _ZN10S1457C3_nt4v120Ev();
extern void _ZN10S1457C3_nt4v121Ev();
extern void _ZN10S1457C3_nt4v122Ev();
extern void _ZN10S1457C3_nt4v123Ev();
extern void _ZN10S1457C3_nt4v124Ev();
extern void _ZN10S1457C3_nt4v125Ev();
extern void _ZN10S1457C3_nt4v126Ev();
extern void _ZN10S1457C3_nt4v127Ev();
extern void _ZN10S1457C3_nt4v128Ev();
extern void _ZN10S1457C3_nt4v129Ev();
extern void _ZN10S1457C3_nt4v130Ev();
extern void _ZN10S1457C3_nt4v131Ev();
extern void _ZN10S1457C3_nt4v132Ev();
extern void _ZN10S1457C3_nt4v133Ev();
extern void _ZN10S1457C3_nt4v134Ev();
extern void _ZN10S1457C3_nt4v135Ev();
extern void _ZN10S1457C3_nt4v136Ev();
extern void _ZN10S1457C3_nt4v137Ev();
extern void _ZN10S1457C3_nt4v138Ev();
extern void _ZN10S1457C3_nt4v139Ev();
extern void _ZN10S1457C3_nt4v140Ev();
extern void _ZN10S1457C3_nt4v141Ev();
extern void _ZN10S1457C3_nt4v142Ev();
extern void _ZN10S1457C3_nt4v143Ev();
extern void _ZN10S1457C3_nt4v144Ev();
extern void _ZN10S1457C3_nt4v145Ev();
extern void _ZN10S1457C3_nt4v146Ev();
extern void _ZN10S1457C3_nt4v147Ev();
extern void _ZN10S1457C3_nt4v148Ev();
extern void _ZN10S1457C3_nt4v149Ev();
extern void _ZN10S1457C3_nt4v150Ev();
extern void _ZN10S1457C3_nt4v151Ev();
extern void _ZN10S1457C3_nt4v152Ev();
extern void _ZN10S1457C3_nt4v153Ev();
extern void _ZN10S1457C3_nt4v154Ev();
extern void _ZN10S1457C3_nt4v155Ev();
extern void _ZN10S1457C3_nt4v156Ev();
extern void _ZN10S1457C3_nt4v157Ev();
extern void _ZN10S1457C3_nt4v158Ev();
extern void _ZN10S1457C3_nt4v159Ev();
extern void _ZN10S1457C3_nt4v160Ev();
extern void _ZN10S1457C3_nt4v161Ev();
extern void _ZN10S1457C3_nt4v162Ev();
extern void _ZN10S1457C3_nt4v163Ev();
extern void _ZN10S1457C3_nt4v164Ev();
extern void _ZN10S1457C3_nt4v165Ev();
extern void _ZN10S1457C3_nt4v166Ev();
extern void _ZN10S1457C3_nt4v167Ev();
extern void _ZN10S1457C3_nt4v168Ev();
extern void _ZN10S1457C3_nt4v169Ev();
extern void _ZN10S1457C3_nt4v170Ev();
extern void _ZN10S1457C3_nt4v171Ev();
extern void _ZN10S1457C3_nt4v172Ev();
extern void _ZN10S1457C3_nt4v173Ev();
extern void _ZN10S1457C3_nt4v174Ev();
extern void _ZN10S1457C3_nt4v175Ev();
extern void _ZN10S1457C3_nt4v176Ev();
extern void _ZN10S1457C3_nt4v177Ev();
extern void _ZN10S1457C3_nt4v178Ev();
extern void _ZN10S1457C3_nt4v179Ev();
extern void _ZN10S1457C3_nt4v180Ev();
extern void _ZN10S1457C3_nt4v181Ev();
extern void _ZN10S1457C3_nt4v182Ev();
extern void _ZN10S1457C3_nt4v183Ev();
extern void _ZN10S1457C3_nt4v184Ev();
extern void _ZN10S1457C3_nt4v185Ev();
extern void _ZN10S1457C3_nt4v186Ev();
extern void _ZN10S1457C3_nt4v187Ev();
extern void _ZN10S1457C3_nt4v188Ev();
extern void _ZN10S1457C3_nt4v189Ev();
extern void _ZN10S1457C3_nt4v190Ev();
extern void _ZN10S1457C3_nt4v191Ev();
extern void _ZN10S1457C3_nt4v192Ev();
extern void _ZN10S1457C3_nt4v193Ev();
extern void _ZN10S1457C3_nt4v194Ev();
extern void _ZN10S1457C3_nt4v195Ev();
extern void _ZN10S1457C3_nt4v196Ev();
extern void _ZN10S1457C3_nt4v197Ev();
extern void _ZN10S1457C3_nt4v198Ev();
extern void _ZN10S1457C3_nt4v199Ev();
extern void _ZN10S1457C3_nt4v200Ev();
extern void _ZN10S1457C3_nt4v201Ev();
extern void _ZN10S1457C3_nt4v202Ev();
extern void _ZN10S1457C3_nt4v203Ev();
extern void _ZN10S1457C3_nt4v204Ev();
extern void _ZN10S1457C3_nt4v205Ev();
extern void _ZN10S1457C3_nt4v206Ev();
extern void _ZN10S1457C3_nt4v207Ev();
extern void _ZN10S1457C3_nt4v208Ev();
extern void _ZN10S1457C3_nt4v209Ev();
extern void _ZN10S1457C3_nt4v210Ev();
extern void _ZN10S1457C3_nt4v211Ev();
extern void _ZN7S1457C24v212Ev();
extern void _ZN7S1457C24v213Ev();
extern void _ZN7S1457C24v214Ev();
extern void _ZN7S1457C12v1Ev();
extern void _ZN7S1457C12v2Ev();
extern void _ZN7S1457C12v3Ev();
extern void _ZN7S1457C12v4Ev();
static  VTBL_ENTRY vtc_S1457C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1457C1[0]),
  (VTBL_ENTRY)&_ZN7S1457C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1457C1D0Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1457C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S1457C3_nt4v211Ev,
  (VTBL_ENTRY)&_ZN7S1457C24v212Ev,
  (VTBL_ENTRY)&_ZN7S1457C24v213Ev,
  (VTBL_ENTRY)&_ZN7S1457C24v214Ev,
  (VTBL_ENTRY)&_ZN7S1457C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1457C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1457C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1457C12v4Ev,
};
extern VTBL_ENTRY _ZTI7S1457C1[];
extern  VTBL_ENTRY _ZTV7S1457C1[];
Class_Descriptor cd_S1457C1 = {  "S1457C1", // class name
  bases_S1457C1, 3,
  &(vtc_S1457C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(592,452), // object size
  NSPAIRA(_ZTI7S1457C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1457C1),218, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1412C4  {
  int s1412c4f0;
  __tsi64 s1412c4f1;
  void *s1412c4f2[4];
  int s1412c4f3[2];
  void *s1412c4f4;
  ::S1457C5_nt s1412c4f5;
  void *s1412c4f6[2];
  virtual  ~S1412C4(); // _ZN7S1412C4D1Ev
  virtual void  v4(); // _ZN7S1412C42v4Ev
  virtual void  v5(); // _ZN7S1412C42v5Ev
  virtual void  v6(); // _ZN7S1412C42v6Ev
  virtual void  v7(); // _ZN7S1412C42v7Ev
  virtual void  v8(); // _ZN7S1412C42v8Ev
  virtual void  v9(); // _ZN7S1412C42v9Ev
  virtual void  v10(); // _ZN7S1412C43v10Ev
  virtual void  v11(); // _ZN7S1412C43v11Ev
  virtual void  v12(); // _ZN7S1412C43v12Ev
  virtual void  v13(); // _ZN7S1412C43v13Ev
  virtual void  v14(); // _ZN7S1412C43v14Ev
  virtual void  v15(); // _ZN7S1412C43v15Ev
  virtual void  v16(); // _ZN7S1412C43v16Ev
  virtual void  v17(); // _ZN7S1412C43v17Ev
  virtual void  v18(); // _ZN7S1412C43v18Ev
  virtual void  v19(); // _ZN7S1412C43v19Ev
  virtual void  v20(); // _ZN7S1412C43v20Ev
  virtual void  v21(); // _ZN7S1412C43v21Ev
  virtual void  v22(); // _ZN7S1412C43v22Ev
  virtual void  v23(); // _ZN7S1412C43v23Ev
  virtual void  v24(); // _ZN7S1412C43v24Ev
  virtual void  v25(); // _ZN7S1412C43v25Ev
  virtual void  v26(); // _ZN7S1412C43v26Ev
  virtual void  v27(); // _ZN7S1412C43v27Ev
  virtual void  v28(); // _ZN7S1412C43v28Ev
  virtual void  v29(); // _ZN7S1412C43v29Ev
  virtual void  v30(); // _ZN7S1412C43v30Ev
  virtual void  v31(); // _ZN7S1412C43v31Ev
  virtual void  v32(); // _ZN7S1412C43v32Ev
  virtual void  v33(); // _ZN7S1412C43v33Ev
  virtual void  v34(); // _ZN7S1412C43v34Ev
  virtual void  v35(); // _ZN7S1412C43v35Ev
  virtual void  v36(); // _ZN7S1412C43v36Ev
  virtual void  v37(); // _ZN7S1412C43v37Ev
  virtual void  v38(); // _ZN7S1412C43v38Ev
  virtual void  v39(); // _ZN7S1412C43v39Ev
  virtual void  v40(); // _ZN7S1412C43v40Ev
  virtual void  v41(); // _ZN7S1412C43v41Ev
  virtual void  v42(); // _ZN7S1412C43v42Ev
  virtual void  v43(); // _ZN7S1412C43v43Ev
  virtual void  v44(); // _ZN7S1412C43v44Ev
  virtual void  v45(); // _ZN7S1412C43v45Ev
  virtual void  v46(); // _ZN7S1412C43v46Ev
  virtual void  v47(); // _ZN7S1412C43v47Ev
  virtual void  v48(); // _ZN7S1412C43v48Ev
  virtual void  v49(); // _ZN7S1412C43v49Ev
  virtual void  v50(); // _ZN7S1412C43v50Ev
  virtual void  v51(); // _ZN7S1412C43v51Ev
  virtual void  v52(); // _ZN7S1412C43v52Ev
  virtual void  v53(); // _ZN7S1412C43v53Ev
  virtual void  v54(); // _ZN7S1412C43v54Ev
  virtual void  v55(); // _ZN7S1412C43v55Ev
  virtual void  v56(); // _ZN7S1412C43v56Ev
  virtual void  v57(); // _ZN7S1412C43v57Ev
  virtual void  v58(); // _ZN7S1412C43v58Ev
  virtual void  v59(); // _ZN7S1412C43v59Ev
  virtual void  v60(); // _ZN7S1412C43v60Ev
  virtual void  v61(); // _ZN7S1412C43v61Ev
  virtual void  v62(); // _ZN7S1412C43v62Ev
  virtual void  v63(); // _ZN7S1412C43v63Ev
  virtual void  v64(); // _ZN7S1412C43v64Ev
  virtual void  v65(); // _ZN7S1412C43v65Ev
  virtual void  v66(); // _ZN7S1412C43v66Ev
  virtual void  v67(); // _ZN7S1412C43v67Ev
  S1412C4(); // tgen
};
//SIG(-1 S1412C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1412C4 ::~S1412C4(){ note_dtor("S1412C4", this);}
void  S1412C4 ::v4(){vfunc_called(this, "_ZN7S1412C42v4Ev");}
void  S1412C4 ::v5(){vfunc_called(this, "_ZN7S1412C42v5Ev");}
void  S1412C4 ::v6(){vfunc_called(this, "_ZN7S1412C42v6Ev");}
void  S1412C4 ::v7(){vfunc_called(this, "_ZN7S1412C42v7Ev");}
void  S1412C4 ::v8(){vfunc_called(this, "_ZN7S1412C42v8Ev");}
void  S1412C4 ::v9(){vfunc_called(this, "_ZN7S1412C42v9Ev");}
void  S1412C4 ::v10(){vfunc_called(this, "_ZN7S1412C43v10Ev");}
void  S1412C4 ::v11(){vfunc_called(this, "_ZN7S1412C43v11Ev");}
void  S1412C4 ::v12(){vfunc_called(this, "_ZN7S1412C43v12Ev");}
void  S1412C4 ::v13(){vfunc_called(this, "_ZN7S1412C43v13Ev");}
void  S1412C4 ::v14(){vfunc_called(this, "_ZN7S1412C43v14Ev");}
void  S1412C4 ::v15(){vfunc_called(this, "_ZN7S1412C43v15Ev");}
void  S1412C4 ::v16(){vfunc_called(this, "_ZN7S1412C43v16Ev");}
void  S1412C4 ::v17(){vfunc_called(this, "_ZN7S1412C43v17Ev");}
void  S1412C4 ::v18(){vfunc_called(this, "_ZN7S1412C43v18Ev");}
void  S1412C4 ::v19(){vfunc_called(this, "_ZN7S1412C43v19Ev");}
void  S1412C4 ::v20(){vfunc_called(this, "_ZN7S1412C43v20Ev");}
void  S1412C4 ::v21(){vfunc_called(this, "_ZN7S1412C43v21Ev");}
void  S1412C4 ::v22(){vfunc_called(this, "_ZN7S1412C43v22Ev");}
void  S1412C4 ::v23(){vfunc_called(this, "_ZN7S1412C43v23Ev");}
void  S1412C4 ::v24(){vfunc_called(this, "_ZN7S1412C43v24Ev");}
void  S1412C4 ::v25(){vfunc_called(this, "_ZN7S1412C43v25Ev");}
void  S1412C4 ::v26(){vfunc_called(this, "_ZN7S1412C43v26Ev");}
void  S1412C4 ::v27(){vfunc_called(this, "_ZN7S1412C43v27Ev");}
void  S1412C4 ::v28(){vfunc_called(this, "_ZN7S1412C43v28Ev");}
void  S1412C4 ::v29(){vfunc_called(this, "_ZN7S1412C43v29Ev");}
void  S1412C4 ::v30(){vfunc_called(this, "_ZN7S1412C43v30Ev");}
void  S1412C4 ::v31(){vfunc_called(this, "_ZN7S1412C43v31Ev");}
void  S1412C4 ::v32(){vfunc_called(this, "_ZN7S1412C43v32Ev");}
void  S1412C4 ::v33(){vfunc_called(this, "_ZN7S1412C43v33Ev");}
void  S1412C4 ::v34(){vfunc_called(this, "_ZN7S1412C43v34Ev");}
void  S1412C4 ::v35(){vfunc_called(this, "_ZN7S1412C43v35Ev");}
void  S1412C4 ::v36(){vfunc_called(this, "_ZN7S1412C43v36Ev");}
void  S1412C4 ::v37(){vfunc_called(this, "_ZN7S1412C43v37Ev");}
void  S1412C4 ::v38(){vfunc_called(this, "_ZN7S1412C43v38Ev");}
void  S1412C4 ::v39(){vfunc_called(this, "_ZN7S1412C43v39Ev");}
void  S1412C4 ::v40(){vfunc_called(this, "_ZN7S1412C43v40Ev");}
void  S1412C4 ::v41(){vfunc_called(this, "_ZN7S1412C43v41Ev");}
void  S1412C4 ::v42(){vfunc_called(this, "_ZN7S1412C43v42Ev");}
void  S1412C4 ::v43(){vfunc_called(this, "_ZN7S1412C43v43Ev");}
void  S1412C4 ::v44(){vfunc_called(this, "_ZN7S1412C43v44Ev");}
void  S1412C4 ::v45(){vfunc_called(this, "_ZN7S1412C43v45Ev");}
void  S1412C4 ::v46(){vfunc_called(this, "_ZN7S1412C43v46Ev");}
void  S1412C4 ::v47(){vfunc_called(this, "_ZN7S1412C43v47Ev");}
void  S1412C4 ::v48(){vfunc_called(this, "_ZN7S1412C43v48Ev");}
void  S1412C4 ::v49(){vfunc_called(this, "_ZN7S1412C43v49Ev");}
void  S1412C4 ::v50(){vfunc_called(this, "_ZN7S1412C43v50Ev");}
void  S1412C4 ::v51(){vfunc_called(this, "_ZN7S1412C43v51Ev");}
void  S1412C4 ::v52(){vfunc_called(this, "_ZN7S1412C43v52Ev");}
void  S1412C4 ::v53(){vfunc_called(this, "_ZN7S1412C43v53Ev");}
void  S1412C4 ::v54(){vfunc_called(this, "_ZN7S1412C43v54Ev");}
void  S1412C4 ::v55(){vfunc_called(this, "_ZN7S1412C43v55Ev");}
void  S1412C4 ::v56(){vfunc_called(this, "_ZN7S1412C43v56Ev");}
void  S1412C4 ::v57(){vfunc_called(this, "_ZN7S1412C43v57Ev");}
void  S1412C4 ::v58(){vfunc_called(this, "_ZN7S1412C43v58Ev");}
void  S1412C4 ::v59(){vfunc_called(this, "_ZN7S1412C43v59Ev");}
void  S1412C4 ::v60(){vfunc_called(this, "_ZN7S1412C43v60Ev");}
void  S1412C4 ::v61(){vfunc_called(this, "_ZN7S1412C43v61Ev");}
void  S1412C4 ::v62(){vfunc_called(this, "_ZN7S1412C43v62Ev");}
void  S1412C4 ::v63(){vfunc_called(this, "_ZN7S1412C43v63Ev");}
void  S1412C4 ::v64(){vfunc_called(this, "_ZN7S1412C43v64Ev");}
void  S1412C4 ::v65(){vfunc_called(this, "_ZN7S1412C43v65Ev");}
void  S1412C4 ::v66(){vfunc_called(this, "_ZN7S1412C43v66Ev");}
void  S1412C4 ::v67(){vfunc_called(this, "_ZN7S1412C43v67Ev");}
S1412C4 ::S1412C4(){ note_ctor("S1412C4", this);} // tgen

static void Test_S1412C4()
{
  extern Class_Descriptor cd_S1412C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1412C4, buf);
    S1412C4 *dp, &lv = *(dp=new (buf) S1412C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1412C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1412C4)");
    check_field_offset(lv, s1412c4f0, ABISELECT(8,4), "S1412C4.s1412c4f0");
    check_field_offset(lv, s1412c4f1, ABISELECT(16,8), "S1412C4.s1412c4f1");
    check_field_offset(lv, s1412c4f2, ABISELECT(24,16), "S1412C4.s1412c4f2");
    check_field_offset(lv, s1412c4f3, ABISELECT(56,32), "S1412C4.s1412c4f3");
    check_field_offset(lv, s1412c4f4, ABISELECT(64,40), "S1412C4.s1412c4f4");
    check_field_offset(lv, s1412c4f5, ABISELECT(72,44), "S1412C4.s1412c4f5");
    check_field_offset(lv, s1412c4f6, ABISELECT(80,52), "S1412C4.s1412c4f6");
    test_class_info(&lv, &cd_S1412C4);
    dp->~S1412C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1412C4(Test_S1412C4, "S1412C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1412C4C1Ev();
extern void _ZN7S1412C4D1Ev();
Name_Map name_map_S1412C4[] = {
  NSPAIR(_ZN7S1412C4C1Ev),
  NSPAIR(_ZN7S1412C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1412C4[];
extern void _ZN7S1412C4D1Ev();
extern void _ZN7S1412C4D0Ev();
extern void _ZN7S1412C42v4Ev();
extern void _ZN7S1412C42v5Ev();
extern void _ZN7S1412C42v6Ev();
extern void _ZN7S1412C42v7Ev();
extern void _ZN7S1412C42v8Ev();
extern void _ZN7S1412C42v9Ev();
extern void _ZN7S1412C43v10Ev();
extern void _ZN7S1412C43v11Ev();
extern void _ZN7S1412C43v12Ev();
extern void _ZN7S1412C43v13Ev();
extern void _ZN7S1412C43v14Ev();
extern void _ZN7S1412C43v15Ev();
extern void _ZN7S1412C43v16Ev();
extern void _ZN7S1412C43v17Ev();
extern void _ZN7S1412C43v18Ev();
extern void _ZN7S1412C43v19Ev();
extern void _ZN7S1412C43v20Ev();
extern void _ZN7S1412C43v21Ev();
extern void _ZN7S1412C43v22Ev();
extern void _ZN7S1412C43v23Ev();
extern void _ZN7S1412C43v24Ev();
extern void _ZN7S1412C43v25Ev();
extern void _ZN7S1412C43v26Ev();
extern void _ZN7S1412C43v27Ev();
extern void _ZN7S1412C43v28Ev();
extern void _ZN7S1412C43v29Ev();
extern void _ZN7S1412C43v30Ev();
extern void _ZN7S1412C43v31Ev();
extern void _ZN7S1412C43v32Ev();
extern void _ZN7S1412C43v33Ev();
extern void _ZN7S1412C43v34Ev();
extern void _ZN7S1412C43v35Ev();
extern void _ZN7S1412C43v36Ev();
extern void _ZN7S1412C43v37Ev();
extern void _ZN7S1412C43v38Ev();
extern void _ZN7S1412C43v39Ev();
extern void _ZN7S1412C43v40Ev();
extern void _ZN7S1412C43v41Ev();
extern void _ZN7S1412C43v42Ev();
extern void _ZN7S1412C43v43Ev();
extern void _ZN7S1412C43v44Ev();
extern void _ZN7S1412C43v45Ev();
extern void _ZN7S1412C43v46Ev();
extern void _ZN7S1412C43v47Ev();
extern void _ZN7S1412C43v48Ev();
extern void _ZN7S1412C43v49Ev();
extern void _ZN7S1412C43v50Ev();
extern void _ZN7S1412C43v51Ev();
extern void _ZN7S1412C43v52Ev();
extern void _ZN7S1412C43v53Ev();
extern void _ZN7S1412C43v54Ev();
extern void _ZN7S1412C43v55Ev();
extern void _ZN7S1412C43v56Ev();
extern void _ZN7S1412C43v57Ev();
extern void _ZN7S1412C43v58Ev();
extern void _ZN7S1412C43v59Ev();
extern void _ZN7S1412C43v60Ev();
extern void _ZN7S1412C43v61Ev();
extern void _ZN7S1412C43v62Ev();
extern void _ZN7S1412C43v63Ev();
extern void _ZN7S1412C43v64Ev();
extern void _ZN7S1412C43v65Ev();
extern void _ZN7S1412C43v66Ev();
extern void _ZN7S1412C43v67Ev();
static  VTBL_ENTRY vtc_S1412C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1412C4[0]),
  (VTBL_ENTRY)&_ZN7S1412C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1412C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1412C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1412C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1412C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1412C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1412C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1412C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v67Ev,
};
extern VTBL_ENTRY _ZTI7S1412C4[];
extern  VTBL_ENTRY _ZTV7S1412C4[];
Class_Descriptor cd_S1412C4 = {  "S1412C4", // class name
  0,0,//no base classes
  &(vtc_S1412C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1412C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1412C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1412C15_nt  {
  int s1412c15f0[3];
  void  mf1412c15(); // _ZN11S1412C15_nt9mf1412c15Ev
};
//SIG(-1 S1412C15_nt) C1{ m Fi[3]}


void  S1412C15_nt ::mf1412c15(){}

//skip512 S1412C15_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1412C19  : S1457C8_nt {
};
//SIG(-1 S1412C19) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1412C19()
{
  extern Class_Descriptor cd_S1412C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1412C19, buf);
    S1412C19 &lv = *(new (buf) S1412C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1412C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1412C19)");
    check_base_class_offset(lv, (S1457C8_nt*), 0, "S1412C19");
    test_class_info(&lv, &cd_S1412C19);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1412C19(Test_S1412C19, "S1412C19", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1457C8_nt;
static Base_Class bases_S1412C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1457C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1412C19 = {  "S1412C19", // class name
  bases_S1412C19, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1412C18_nt  : S1412C19 {
};
//SIG(-1 S1412C18_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S1412C18_nt

#else // __cplusplus

extern Class_Descriptor cd_S1457C8_nt;
extern Class_Descriptor cd_S1412C19;
static Base_Class bases_S1412C18_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1457C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1412C19,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1412C3  : S1412C4 {
  ::S1457C22 s1412c3f0;
  ::S1457C22 s1412c3f1;
  ::S1457C9_nt s1412c3f2;
  int s1412c3f3;
  char s1412c3f4[4];
  void *s1412c3f5[2];
  ::S1457C18 s1412c3f6;
  unsigned int s1412c3f7:1;
  unsigned int s1412c3f8:1;
  unsigned int s1412c3f9:1;
  unsigned int s1412c3f10:1;
  unsigned int s1412c3f11:1;
  unsigned int s1412c3f12:1;
  unsigned int s1412c3f13:1;
  unsigned int s1412c3f14:1;
  unsigned int s1412c3f15:1;
  unsigned int s1412c3f16:1;
  unsigned int s1412c3f17:1;
  unsigned int s1412c3f18:1;
  unsigned int s1412c3f19:1;
  unsigned int s1412c3f20:1;
  unsigned int s1412c3f21:1;
  unsigned int s1412c3f22:1;
  unsigned int s1412c3f23:1;
  unsigned int s1412c3f24:1;
  unsigned int s1412c3f25:1;
  unsigned int s1412c3f26:1;
  unsigned int s1412c3f27:1;
  unsigned int s1412c3f28:1;
  unsigned int s1412c3f29:1;
  unsigned int s1412c3f30:1;
  unsigned int s1412c3f31:1;
  unsigned int s1412c3f32:1;
  unsigned int s1412c3f33:1;
  unsigned int s1412c3f34:1;
  unsigned int s1412c3f35:1;
  unsigned int s1412c3f36:1;
  unsigned int s1412c3f37:1;
  unsigned int s1412c3f38:1;
  unsigned int s1412c3f39:1;
  unsigned int s1412c3f40:1;
  unsigned int s1412c3f41:1;
  unsigned int s1412c3f42:1;
  unsigned int s1412c3f43:1;
  unsigned int s1412c3f44:1;
  unsigned int s1412c3f45:1;
  unsigned int s1412c3f46:1;
  unsigned int s1412c3f47:1;
  unsigned int s1412c3f48:1;
  unsigned int s1412c3f49:1;
  unsigned int s1412c3f50:1;
  unsigned int s1412c3f51:1;
  unsigned int s1412c3f52:1;
  unsigned int s1412c3f53:1;
  unsigned int s1412c3f54:1;
  unsigned int s1412c3f55:1;
  unsigned int s1412c3f56:1;
  unsigned int s1412c3f57:1;
  unsigned int s1412c3f58:1;
  unsigned int s1412c3f59:1;
  unsigned int s1412c3f60:1;
  unsigned int s1412c3f61:1;
  unsigned int s1412c3f62:1;
  unsigned int s1412c3f63:1;
  unsigned int s1412c3f64:1;
  unsigned int s1412c3f65:1;
  unsigned int s1412c3f66:1;
  unsigned int s1412c3f67:1;
  unsigned int s1412c3f68:1;
  unsigned int s1412c3f69:1;
  unsigned int s1412c3f70:1;
  unsigned int s1412c3f71:1;
  unsigned int s1412c3f72:1;
  unsigned int s1412c3f73:1;
  unsigned int s1412c3f74:1;
  unsigned int s1412c3f75:1;
  unsigned int s1412c3f76:1;
  unsigned int s1412c3f77:1;
  unsigned int s1412c3f78:1;
  unsigned int s1412c3f79:1;
  unsigned int s1412c3f80:1;
  unsigned int s1412c3f81:1;
  unsigned int s1412c3f82:1;
  unsigned int s1412c3f83:1;
  int s1412c3f84[5];
  void *s1412c3f85[2];
  int s1412c3f86[3];
  ::S1457C5_nt s1412c3f87;
  ::S1457C5_nt s1412c3f88;
  ::S1457C5_nt s1412c3f89;
  ::S1457C12 s1412c3f90;
  ::S1457C12 s1412c3f91;
  int s1412c3f92;
  void *s1412c3f93[2];
  ::S1457C14_nt s1412c3f94;
  ::S1412C15_nt s1412c3f95;
  ::S1457C14_nt s1412c3f96;
  ::S1457C14_nt s1412c3f97;
  void *s1412c3f98;
  ::S1457C5_nt s1412c3f99;
  ::S1457C12 s1412c3f100;
  ::S1457C14_nt s1412c3f101;
  ::S1412C15_nt s1412c3f102;
  int s1412c3f103;
  ::S1457C14_nt s1412c3f104;
  ::S1457C14_nt s1412c3f105;
  void *s1412c3f106;
  int s1412c3f107;
  char s1412c3f108;
  ::S1412C15_nt s1412c3f109;
  ::S1412C15_nt s1412c3f110;
  void *s1412c3f111;
  int s1412c3f112;
  void *s1412c3f113;
  ::S1457C6_nt s1412c3f114;
  ::S1412C18_nt s1412c3f115;
  ::S1412C18_nt s1412c3f116;
  virtual  ~S1412C3(); // _ZN7S1412C3D1Ev
  virtual void  v68(); // _ZN7S1412C33v68Ev
  virtual void  v69(); // _ZN7S1412C33v69Ev
  virtual void  v70(); // _ZN7S1412C33v70Ev
  virtual void  v71(); // _ZN7S1412C33v71Ev
  virtual void  v72(); // _ZN7S1412C33v72Ev
  virtual void  v73(); // _ZN7S1412C33v73Ev
  virtual void  v74(); // _ZN7S1412C33v74Ev
  virtual void  v75(); // _ZN7S1412C33v75Ev
  virtual void  v76(); // _ZN7S1412C33v76Ev
  virtual void  v77(); // _ZN7S1412C33v77Ev
  virtual void  v78(); // _ZN7S1412C33v78Ev
  virtual void  v79(); // _ZN7S1412C33v79Ev
  virtual void  v80(); // _ZN7S1412C33v80Ev
  virtual void  v81(); // _ZN7S1412C33v81Ev
  virtual void  v82(); // _ZN7S1412C33v82Ev
  virtual void  v83(); // _ZN7S1412C33v83Ev
  virtual void  v84(); // _ZN7S1412C33v84Ev
  virtual void  v85(); // _ZN7S1412C33v85Ev
  virtual void  v86(); // _ZN7S1412C33v86Ev
  virtual void  v87(); // _ZN7S1412C33v87Ev
  virtual void  v88(); // _ZN7S1412C33v88Ev
  virtual void  v89(); // _ZN7S1412C33v89Ev
  virtual void  v90(); // _ZN7S1412C33v90Ev
  virtual void  v91(); // _ZN7S1412C33v91Ev
  virtual void  v92(); // _ZN7S1412C33v92Ev
  virtual void  v93(); // _ZN7S1412C33v93Ev
  virtual void  v94(); // _ZN7S1412C33v94Ev
  virtual void  v95(); // _ZN7S1412C33v95Ev
  virtual void  v96(); // _ZN7S1412C33v96Ev
  virtual void  v97(); // _ZN7S1412C33v97Ev
  virtual void  v98(); // _ZN7S1412C33v98Ev
  virtual void  v99(); // _ZN7S1412C33v99Ev
  virtual void  v100(); // _ZN7S1412C34v100Ev
  virtual void  v101(); // _ZN7S1412C34v101Ev
  virtual void  v102(); // _ZN7S1412C34v102Ev
  virtual void  v103(); // _ZN7S1412C34v103Ev
  virtual void  v104(); // _ZN7S1412C34v104Ev
  virtual void  v105(); // _ZN7S1412C34v105Ev
  virtual void  v106(); // _ZN7S1412C34v106Ev
  virtual void  v107(); // _ZN7S1412C34v107Ev
  virtual void  v108(); // _ZN7S1412C34v108Ev
  virtual void  v109(); // _ZN7S1412C34v109Ev
  virtual void  v110(); // _ZN7S1412C34v110Ev
  virtual void  v111(); // _ZN7S1412C34v111Ev
  virtual void  v112(); // _ZN7S1412C34v112Ev
  virtual void  v113(); // _ZN7S1412C34v113Ev
  virtual void  v114(); // _ZN7S1412C34v114Ev
  virtual void  v115(); // _ZN7S1412C34v115Ev
  virtual void  v116(); // _ZN7S1412C34v116Ev
  virtual void  v117(); // _ZN7S1412C34v117Ev
  virtual void  v118(); // _ZN7S1412C34v118Ev
  virtual void  v119(); // _ZN7S1412C34v119Ev
  virtual void  v120(); // _ZN7S1412C34v120Ev
  virtual void  v121(); // _ZN7S1412C34v121Ev
  virtual void  v122(); // _ZN7S1412C34v122Ev
  virtual void  v123(); // _ZN7S1412C34v123Ev
  virtual void  v124(); // _ZN7S1412C34v124Ev
  virtual void  v125(); // _ZN7S1412C34v125Ev
  virtual void  v126(); // _ZN7S1412C34v126Ev
  virtual void  v127(); // _ZN7S1412C34v127Ev
  virtual void  v128(); // _ZN7S1412C34v128Ev
  virtual void  v129(); // _ZN7S1412C34v129Ev
  virtual void  v130(); // _ZN7S1412C34v130Ev
  virtual void  v131(); // _ZN7S1412C34v131Ev
  virtual void  v132(); // _ZN7S1412C34v132Ev
  virtual void  v133(); // _ZN7S1412C34v133Ev
  virtual void  v134(); // _ZN7S1412C34v134Ev
  virtual void  v135(); // _ZN7S1412C34v135Ev
  virtual void  v136(); // _ZN7S1412C34v136Ev
  virtual void  v137(); // _ZN7S1412C34v137Ev
  virtual void  v138(); // _ZN7S1412C34v138Ev
  virtual void  v139(); // _ZN7S1412C34v139Ev
  virtual void  v140(); // _ZN7S1412C34v140Ev
  virtual void  v141(); // _ZN7S1412C34v141Ev
  virtual void  v142(); // _ZN7S1412C34v142Ev
  virtual void  v143(); // _ZN7S1412C34v143Ev
  virtual void  v144(); // _ZN7S1412C34v144Ev
  virtual void  v145(); // _ZN7S1412C34v145Ev
  virtual void  v146(); // _ZN7S1412C34v146Ev
  virtual void  v147(); // _ZN7S1412C34v147Ev
  virtual void  v148(); // _ZN7S1412C34v148Ev
  virtual void  v149(); // _ZN7S1412C34v149Ev
  virtual void  v150(); // _ZN7S1412C34v150Ev
  virtual void  v151(); // _ZN7S1412C34v151Ev
  virtual void  v152(); // _ZN7S1412C34v152Ev
  virtual void  v153(); // _ZN7S1412C34v153Ev
  virtual void  v154(); // _ZN7S1412C34v154Ev
  virtual void  v155(); // _ZN7S1412C34v155Ev
  virtual void  v156(); // _ZN7S1412C34v156Ev
  virtual void  v157(); // _ZN7S1412C34v157Ev
  virtual void  v158(); // _ZN7S1412C34v158Ev
  virtual void  v159(); // _ZN7S1412C34v159Ev
  virtual void  v160(); // _ZN7S1412C34v160Ev
  virtual void  v161(); // _ZN7S1412C34v161Ev
  virtual void  v162(); // _ZN7S1412C34v162Ev
  virtual void  v163(); // _ZN7S1412C34v163Ev
  virtual void  v164(); // _ZN7S1412C34v164Ev
  virtual void  v165(); // _ZN7S1412C34v165Ev
  virtual void  v166(); // _ZN7S1412C34v166Ev
  virtual void  v167(); // _ZN7S1412C34v167Ev
  virtual void  v168(); // _ZN7S1412C34v168Ev
  virtual void  v169(); // _ZN7S1412C34v169Ev
  virtual void  v170(); // _ZN7S1412C34v170Ev
  virtual void  v171(); // _ZN7S1412C34v171Ev
  virtual void  v172(); // _ZN7S1412C34v172Ev
  virtual void  v173(); // _ZN7S1412C34v173Ev
  virtual void  v174(); // _ZN7S1412C34v174Ev
  virtual void  v175(); // _ZN7S1412C34v175Ev
  virtual void  v176(); // _ZN7S1412C34v176Ev
  virtual void  v177(); // _ZN7S1412C34v177Ev
  virtual void  v178(); // _ZN7S1412C34v178Ev
  virtual void  v179(); // _ZN7S1412C34v179Ev
  virtual void  v180(); // _ZN7S1412C34v180Ev
  virtual void  v181(); // _ZN7S1412C34v181Ev
  virtual void  v182(); // _ZN7S1412C34v182Ev
  virtual void  v183(); // _ZN7S1412C34v183Ev
  virtual void  v184(); // _ZN7S1412C34v184Ev
  virtual void  v185(); // _ZN7S1412C34v185Ev
  virtual void  v186(); // _ZN7S1412C34v186Ev
  virtual void  v187(); // _ZN7S1412C34v187Ev
  virtual void  v188(); // _ZN7S1412C34v188Ev
  virtual void  v189(); // _ZN7S1412C34v189Ev
  virtual void  v190(); // _ZN7S1412C34v190Ev
  virtual void  v191(); // _ZN7S1412C34v191Ev
  virtual void  v192(); // _ZN7S1412C34v192Ev
  virtual void  v193(); // _ZN7S1412C34v193Ev
  virtual void  v194(); // _ZN7S1412C34v194Ev
  virtual void  v195(); // _ZN7S1412C34v195Ev
  virtual void  v196(); // _ZN7S1412C34v196Ev
  virtual void  v197(); // _ZN7S1412C34v197Ev
  virtual void  v198(); // _ZN7S1412C34v198Ev
  virtual void  v199(); // _ZN7S1412C34v199Ev
  virtual void  v200(); // _ZN7S1412C34v200Ev
  virtual void  v201(); // _ZN7S1412C34v201Ev
  virtual void  v202(); // _ZN7S1412C34v202Ev
  virtual void  v203(); // _ZN7S1412C34v203Ev
  virtual void  v204(); // _ZN7S1412C34v204Ev
  virtual void  v205(); // _ZN7S1412C34v205Ev
  virtual void  v206(); // _ZN7S1412C34v206Ev
  virtual void  v207(); // _ZN7S1412C34v207Ev
  virtual void  v208(); // _ZN7S1412C34v208Ev
  virtual void  v209(); // _ZN7S1412C34v209Ev
  virtual void  v210(); // _ZN7S1412C34v210Ev
  S1412C3(); // tgen
};
//SIG(-1 S1412C3) C1{ BC2{ vd v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 FC4{ BC5{ BC6{ m Fp Fi[2]}}} FC4 FC7{ m Fi} Fi Fc[4] Fp[2] FC8{ BC9{ BC6}} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC3 FC3 FC3 FC10{ BC11{ BC6}} FC10 Fi Fp[2] FC12{ m Fi[3]} FC13{ m Fi[3]} FC12 FC12 Fp FC3 FC10 FC12 FC13 Fi FC12 FC12 Fp Fi Fc FC13 FC13 Fp Fi Fp FC14{ BC15{ BC6}} FC16{ BC17{ BC6}} FC16}


 S1412C3 ::~S1412C3(){ note_dtor("S1412C3", this);}
void  S1412C3 ::v68(){vfunc_called(this, "_ZN7S1412C33v68Ev");}
void  S1412C3 ::v69(){vfunc_called(this, "_ZN7S1412C33v69Ev");}
void  S1412C3 ::v70(){vfunc_called(this, "_ZN7S1412C33v70Ev");}
void  S1412C3 ::v71(){vfunc_called(this, "_ZN7S1412C33v71Ev");}
void  S1412C3 ::v72(){vfunc_called(this, "_ZN7S1412C33v72Ev");}
void  S1412C3 ::v73(){vfunc_called(this, "_ZN7S1412C33v73Ev");}
void  S1412C3 ::v74(){vfunc_called(this, "_ZN7S1412C33v74Ev");}
void  S1412C3 ::v75(){vfunc_called(this, "_ZN7S1412C33v75Ev");}
void  S1412C3 ::v76(){vfunc_called(this, "_ZN7S1412C33v76Ev");}
void  S1412C3 ::v77(){vfunc_called(this, "_ZN7S1412C33v77Ev");}
void  S1412C3 ::v78(){vfunc_called(this, "_ZN7S1412C33v78Ev");}
void  S1412C3 ::v79(){vfunc_called(this, "_ZN7S1412C33v79Ev");}
void  S1412C3 ::v80(){vfunc_called(this, "_ZN7S1412C33v80Ev");}
void  S1412C3 ::v81(){vfunc_called(this, "_ZN7S1412C33v81Ev");}
void  S1412C3 ::v82(){vfunc_called(this, "_ZN7S1412C33v82Ev");}
void  S1412C3 ::v83(){vfunc_called(this, "_ZN7S1412C33v83Ev");}
void  S1412C3 ::v84(){vfunc_called(this, "_ZN7S1412C33v84Ev");}
void  S1412C3 ::v85(){vfunc_called(this, "_ZN7S1412C33v85Ev");}
void  S1412C3 ::v86(){vfunc_called(this, "_ZN7S1412C33v86Ev");}
void  S1412C3 ::v87(){vfunc_called(this, "_ZN7S1412C33v87Ev");}
void  S1412C3 ::v88(){vfunc_called(this, "_ZN7S1412C33v88Ev");}
void  S1412C3 ::v89(){vfunc_called(this, "_ZN7S1412C33v89Ev");}
void  S1412C3 ::v90(){vfunc_called(this, "_ZN7S1412C33v90Ev");}
void  S1412C3 ::v91(){vfunc_called(this, "_ZN7S1412C33v91Ev");}
void  S1412C3 ::v92(){vfunc_called(this, "_ZN7S1412C33v92Ev");}
void  S1412C3 ::v93(){vfunc_called(this, "_ZN7S1412C33v93Ev");}
void  S1412C3 ::v94(){vfunc_called(this, "_ZN7S1412C33v94Ev");}
void  S1412C3 ::v95(){vfunc_called(this, "_ZN7S1412C33v95Ev");}
void  S1412C3 ::v96(){vfunc_called(this, "_ZN7S1412C33v96Ev");}
void  S1412C3 ::v97(){vfunc_called(this, "_ZN7S1412C33v97Ev");}
void  S1412C3 ::v98(){vfunc_called(this, "_ZN7S1412C33v98Ev");}
void  S1412C3 ::v99(){vfunc_called(this, "_ZN7S1412C33v99Ev");}
void  S1412C3 ::v100(){vfunc_called(this, "_ZN7S1412C34v100Ev");}
void  S1412C3 ::v101(){vfunc_called(this, "_ZN7S1412C34v101Ev");}
void  S1412C3 ::v102(){vfunc_called(this, "_ZN7S1412C34v102Ev");}
void  S1412C3 ::v103(){vfunc_called(this, "_ZN7S1412C34v103Ev");}
void  S1412C3 ::v104(){vfunc_called(this, "_ZN7S1412C34v104Ev");}
void  S1412C3 ::v105(){vfunc_called(this, "_ZN7S1412C34v105Ev");}
void  S1412C3 ::v106(){vfunc_called(this, "_ZN7S1412C34v106Ev");}
void  S1412C3 ::v107(){vfunc_called(this, "_ZN7S1412C34v107Ev");}
void  S1412C3 ::v108(){vfunc_called(this, "_ZN7S1412C34v108Ev");}
void  S1412C3 ::v109(){vfunc_called(this, "_ZN7S1412C34v109Ev");}
void  S1412C3 ::v110(){vfunc_called(this, "_ZN7S1412C34v110Ev");}
void  S1412C3 ::v111(){vfunc_called(this, "_ZN7S1412C34v111Ev");}
void  S1412C3 ::v112(){vfunc_called(this, "_ZN7S1412C34v112Ev");}
void  S1412C3 ::v113(){vfunc_called(this, "_ZN7S1412C34v113Ev");}
void  S1412C3 ::v114(){vfunc_called(this, "_ZN7S1412C34v114Ev");}
void  S1412C3 ::v115(){vfunc_called(this, "_ZN7S1412C34v115Ev");}
void  S1412C3 ::v116(){vfunc_called(this, "_ZN7S1412C34v116Ev");}
void  S1412C3 ::v117(){vfunc_called(this, "_ZN7S1412C34v117Ev");}
void  S1412C3 ::v118(){vfunc_called(this, "_ZN7S1412C34v118Ev");}
void  S1412C3 ::v119(){vfunc_called(this, "_ZN7S1412C34v119Ev");}
void  S1412C3 ::v120(){vfunc_called(this, "_ZN7S1412C34v120Ev");}
void  S1412C3 ::v121(){vfunc_called(this, "_ZN7S1412C34v121Ev");}
void  S1412C3 ::v122(){vfunc_called(this, "_ZN7S1412C34v122Ev");}
void  S1412C3 ::v123(){vfunc_called(this, "_ZN7S1412C34v123Ev");}
void  S1412C3 ::v124(){vfunc_called(this, "_ZN7S1412C34v124Ev");}
void  S1412C3 ::v125(){vfunc_called(this, "_ZN7S1412C34v125Ev");}
void  S1412C3 ::v126(){vfunc_called(this, "_ZN7S1412C34v126Ev");}
void  S1412C3 ::v127(){vfunc_called(this, "_ZN7S1412C34v127Ev");}
void  S1412C3 ::v128(){vfunc_called(this, "_ZN7S1412C34v128Ev");}
void  S1412C3 ::v129(){vfunc_called(this, "_ZN7S1412C34v129Ev");}
void  S1412C3 ::v130(){vfunc_called(this, "_ZN7S1412C34v130Ev");}
void  S1412C3 ::v131(){vfunc_called(this, "_ZN7S1412C34v131Ev");}
void  S1412C3 ::v132(){vfunc_called(this, "_ZN7S1412C34v132Ev");}
void  S1412C3 ::v133(){vfunc_called(this, "_ZN7S1412C34v133Ev");}
void  S1412C3 ::v134(){vfunc_called(this, "_ZN7S1412C34v134Ev");}
void  S1412C3 ::v135(){vfunc_called(this, "_ZN7S1412C34v135Ev");}
void  S1412C3 ::v136(){vfunc_called(this, "_ZN7S1412C34v136Ev");}
void  S1412C3 ::v137(){vfunc_called(this, "_ZN7S1412C34v137Ev");}
void  S1412C3 ::v138(){vfunc_called(this, "_ZN7S1412C34v138Ev");}
void  S1412C3 ::v139(){vfunc_called(this, "_ZN7S1412C34v139Ev");}
void  S1412C3 ::v140(){vfunc_called(this, "_ZN7S1412C34v140Ev");}
void  S1412C3 ::v141(){vfunc_called(this, "_ZN7S1412C34v141Ev");}
void  S1412C3 ::v142(){vfunc_called(this, "_ZN7S1412C34v142Ev");}
void  S1412C3 ::v143(){vfunc_called(this, "_ZN7S1412C34v143Ev");}
void  S1412C3 ::v144(){vfunc_called(this, "_ZN7S1412C34v144Ev");}
void  S1412C3 ::v145(){vfunc_called(this, "_ZN7S1412C34v145Ev");}
void  S1412C3 ::v146(){vfunc_called(this, "_ZN7S1412C34v146Ev");}
void  S1412C3 ::v147(){vfunc_called(this, "_ZN7S1412C34v147Ev");}
void  S1412C3 ::v148(){vfunc_called(this, "_ZN7S1412C34v148Ev");}
void  S1412C3 ::v149(){vfunc_called(this, "_ZN7S1412C34v149Ev");}
void  S1412C3 ::v150(){vfunc_called(this, "_ZN7S1412C34v150Ev");}
void  S1412C3 ::v151(){vfunc_called(this, "_ZN7S1412C34v151Ev");}
void  S1412C3 ::v152(){vfunc_called(this, "_ZN7S1412C34v152Ev");}
void  S1412C3 ::v153(){vfunc_called(this, "_ZN7S1412C34v153Ev");}
void  S1412C3 ::v154(){vfunc_called(this, "_ZN7S1412C34v154Ev");}
void  S1412C3 ::v155(){vfunc_called(this, "_ZN7S1412C34v155Ev");}
void  S1412C3 ::v156(){vfunc_called(this, "_ZN7S1412C34v156Ev");}
void  S1412C3 ::v157(){vfunc_called(this, "_ZN7S1412C34v157Ev");}
void  S1412C3 ::v158(){vfunc_called(this, "_ZN7S1412C34v158Ev");}
void  S1412C3 ::v159(){vfunc_called(this, "_ZN7S1412C34v159Ev");}
void  S1412C3 ::v160(){vfunc_called(this, "_ZN7S1412C34v160Ev");}
void  S1412C3 ::v161(){vfunc_called(this, "_ZN7S1412C34v161Ev");}
void  S1412C3 ::v162(){vfunc_called(this, "_ZN7S1412C34v162Ev");}
void  S1412C3 ::v163(){vfunc_called(this, "_ZN7S1412C34v163Ev");}
void  S1412C3 ::v164(){vfunc_called(this, "_ZN7S1412C34v164Ev");}
void  S1412C3 ::v165(){vfunc_called(this, "_ZN7S1412C34v165Ev");}
void  S1412C3 ::v166(){vfunc_called(this, "_ZN7S1412C34v166Ev");}
void  S1412C3 ::v167(){vfunc_called(this, "_ZN7S1412C34v167Ev");}
void  S1412C3 ::v168(){vfunc_called(this, "_ZN7S1412C34v168Ev");}
void  S1412C3 ::v169(){vfunc_called(this, "_ZN7S1412C34v169Ev");}
void  S1412C3 ::v170(){vfunc_called(this, "_ZN7S1412C34v170Ev");}
void  S1412C3 ::v171(){vfunc_called(this, "_ZN7S1412C34v171Ev");}
void  S1412C3 ::v172(){vfunc_called(this, "_ZN7S1412C34v172Ev");}
void  S1412C3 ::v173(){vfunc_called(this, "_ZN7S1412C34v173Ev");}
void  S1412C3 ::v174(){vfunc_called(this, "_ZN7S1412C34v174Ev");}
void  S1412C3 ::v175(){vfunc_called(this, "_ZN7S1412C34v175Ev");}
void  S1412C3 ::v176(){vfunc_called(this, "_ZN7S1412C34v176Ev");}
void  S1412C3 ::v177(){vfunc_called(this, "_ZN7S1412C34v177Ev");}
void  S1412C3 ::v178(){vfunc_called(this, "_ZN7S1412C34v178Ev");}
void  S1412C3 ::v179(){vfunc_called(this, "_ZN7S1412C34v179Ev");}
void  S1412C3 ::v180(){vfunc_called(this, "_ZN7S1412C34v180Ev");}
void  S1412C3 ::v181(){vfunc_called(this, "_ZN7S1412C34v181Ev");}
void  S1412C3 ::v182(){vfunc_called(this, "_ZN7S1412C34v182Ev");}
void  S1412C3 ::v183(){vfunc_called(this, "_ZN7S1412C34v183Ev");}
void  S1412C3 ::v184(){vfunc_called(this, "_ZN7S1412C34v184Ev");}
void  S1412C3 ::v185(){vfunc_called(this, "_ZN7S1412C34v185Ev");}
void  S1412C3 ::v186(){vfunc_called(this, "_ZN7S1412C34v186Ev");}
void  S1412C3 ::v187(){vfunc_called(this, "_ZN7S1412C34v187Ev");}
void  S1412C3 ::v188(){vfunc_called(this, "_ZN7S1412C34v188Ev");}
void  S1412C3 ::v189(){vfunc_called(this, "_ZN7S1412C34v189Ev");}
void  S1412C3 ::v190(){vfunc_called(this, "_ZN7S1412C34v190Ev");}
void  S1412C3 ::v191(){vfunc_called(this, "_ZN7S1412C34v191Ev");}
void  S1412C3 ::v192(){vfunc_called(this, "_ZN7S1412C34v192Ev");}
void  S1412C3 ::v193(){vfunc_called(this, "_ZN7S1412C34v193Ev");}
void  S1412C3 ::v194(){vfunc_called(this, "_ZN7S1412C34v194Ev");}
void  S1412C3 ::v195(){vfunc_called(this, "_ZN7S1412C34v195Ev");}
void  S1412C3 ::v196(){vfunc_called(this, "_ZN7S1412C34v196Ev");}
void  S1412C3 ::v197(){vfunc_called(this, "_ZN7S1412C34v197Ev");}
void  S1412C3 ::v198(){vfunc_called(this, "_ZN7S1412C34v198Ev");}
void  S1412C3 ::v199(){vfunc_called(this, "_ZN7S1412C34v199Ev");}
void  S1412C3 ::v200(){vfunc_called(this, "_ZN7S1412C34v200Ev");}
void  S1412C3 ::v201(){vfunc_called(this, "_ZN7S1412C34v201Ev");}
void  S1412C3 ::v202(){vfunc_called(this, "_ZN7S1412C34v202Ev");}
void  S1412C3 ::v203(){vfunc_called(this, "_ZN7S1412C34v203Ev");}
void  S1412C3 ::v204(){vfunc_called(this, "_ZN7S1412C34v204Ev");}
void  S1412C3 ::v205(){vfunc_called(this, "_ZN7S1412C34v205Ev");}
void  S1412C3 ::v206(){vfunc_called(this, "_ZN7S1412C34v206Ev");}
void  S1412C3 ::v207(){vfunc_called(this, "_ZN7S1412C34v207Ev");}
void  S1412C3 ::v208(){vfunc_called(this, "_ZN7S1412C34v208Ev");}
void  S1412C3 ::v209(){vfunc_called(this, "_ZN7S1412C34v209Ev");}
void  S1412C3 ::v210(){vfunc_called(this, "_ZN7S1412C34v210Ev");}
S1412C3 ::S1412C3(){ note_ctor("S1412C3", this);} // tgen

static void Test_S1412C3()
{
  extern Class_Descriptor cd_S1412C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(72,110)];
    init_test(&cd_S1412C3, buf);
    S1412C3 *dp, &lv = *(dp=new (buf) S1412C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(568,436), "sizeof(S1412C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1412C3)");
    check_base_class_offset(lv, (S1412C4*), 0, "S1412C3");
    check_field_offset(lv, s1412c3f0, ABISELECT(96,60), "S1412C3.s1412c3f0");
    check_field_offset(lv, s1412c3f1, ABISELECT(112,72), "S1412C3.s1412c3f1");
    check_field_offset(lv, s1412c3f2, ABISELECT(128,84), "S1412C3.s1412c3f2");
    check_field_offset(lv, s1412c3f3, ABISELECT(132,88), "S1412C3.s1412c3f3");
    check_field_offset(lv, s1412c3f4, ABISELECT(136,92), "S1412C3.s1412c3f4");
    check_field_offset(lv, s1412c3f5, ABISELECT(144,96), "S1412C3.s1412c3f5");
    check_field_offset(lv, s1412c3f6, ABISELECT(160,104), "S1412C3.s1412c3f6");
    set_bf_and_test(lv, s1412c3f7, ABISELECT(176,116), 0, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f8, ABISELECT(176,116), 1, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f9, ABISELECT(176,116), 2, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f10, ABISELECT(176,116), 3, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f11, ABISELECT(176,116), 4, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f12, ABISELECT(176,116), 5, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f13, ABISELECT(176,116), 6, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f14, ABISELECT(176,116), 7, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f15, ABISELECT(177,117), 0, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f16, ABISELECT(177,117), 1, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f17, ABISELECT(177,117), 2, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f18, ABISELECT(177,117), 3, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f19, ABISELECT(177,117), 4, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f20, ABISELECT(177,117), 5, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f21, ABISELECT(177,117), 6, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f22, ABISELECT(177,117), 7, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f23, ABISELECT(178,118), 0, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f24, ABISELECT(178,118), 1, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f25, ABISELECT(178,118), 2, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f26, ABISELECT(178,118), 3, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f27, ABISELECT(178,118), 4, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f28, ABISELECT(178,118), 5, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f29, ABISELECT(178,118), 6, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f30, ABISELECT(178,118), 7, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f31, ABISELECT(179,119), 0, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f32, ABISELECT(179,119), 1, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f33, ABISELECT(179,119), 2, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f34, ABISELECT(179,119), 3, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f35, ABISELECT(179,119), 4, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f36, ABISELECT(179,119), 5, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f37, ABISELECT(179,119), 6, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f38, ABISELECT(179,119), 7, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f39, ABISELECT(180,120), 0, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f40, ABISELECT(180,120), 1, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f41, ABISELECT(180,120), 2, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f42, ABISELECT(180,120), 3, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f43, ABISELECT(180,120), 4, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f44, ABISELECT(180,120), 5, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f45, ABISELECT(180,120), 6, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f46, ABISELECT(180,120), 7, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f47, ABISELECT(181,121), 0, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f48, ABISELECT(181,121), 1, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f49, ABISELECT(181,121), 2, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f50, ABISELECT(181,121), 3, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f51, ABISELECT(181,121), 4, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f52, ABISELECT(181,121), 5, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f53, ABISELECT(181,121), 6, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f54, ABISELECT(181,121), 7, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f55, ABISELECT(182,122), 0, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f56, ABISELECT(182,122), 1, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f57, ABISELECT(182,122), 2, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f58, ABISELECT(182,122), 3, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f59, ABISELECT(182,122), 4, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f60, ABISELECT(182,122), 5, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f61, ABISELECT(182,122), 6, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f62, ABISELECT(182,122), 7, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f63, ABISELECT(183,123), 0, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f64, ABISELECT(183,123), 1, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f65, ABISELECT(183,123), 2, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f66, ABISELECT(183,123), 3, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f67, ABISELECT(183,123), 4, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f68, ABISELECT(183,123), 5, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f69, ABISELECT(183,123), 6, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f70, ABISELECT(183,123), 7, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f71, ABISELECT(184,124), 0, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f72, ABISELECT(184,124), 1, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f73, ABISELECT(184,124), 2, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f74, ABISELECT(184,124), 3, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f75, ABISELECT(184,124), 4, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f76, ABISELECT(184,124), 5, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f77, ABISELECT(184,124), 6, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f78, ABISELECT(184,124), 7, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f79, ABISELECT(185,125), 0, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f80, ABISELECT(185,125), 1, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f81, ABISELECT(185,125), 2, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f82, ABISELECT(185,125), 3, 1, 1, "S1412C3");
    set_bf_and_test(lv, s1412c3f83, ABISELECT(185,125), 4, 1, 1, "S1412C3");
    check_field_offset(lv, s1412c3f84, ABISELECT(188,128), "S1412C3.s1412c3f84");
    check_field_offset(lv, s1412c3f85, ABISELECT(208,148), "S1412C3.s1412c3f85");
    check_field_offset(lv, s1412c3f86, ABISELECT(224,156), "S1412C3.s1412c3f86");
    check_field_offset(lv, s1412c3f87, ABISELECT(236,168), "S1412C3.s1412c3f87");
    check_field_offset(lv, s1412c3f88, ABISELECT(244,176), "S1412C3.s1412c3f88");
    check_field_offset(lv, s1412c3f89, ABISELECT(252,184), "S1412C3.s1412c3f89");
    check_field_offset(lv, s1412c3f90, ABISELECT(264,192), "S1412C3.s1412c3f90");
    check_field_offset(lv, s1412c3f91, ABISELECT(280,204), "S1412C3.s1412c3f91");
    check_field_offset(lv, s1412c3f92, ABISELECT(296,216), "S1412C3.s1412c3f92");
    check_field_offset(lv, s1412c3f93, ABISELECT(304,220), "S1412C3.s1412c3f93");
    check_field_offset(lv, s1412c3f94, ABISELECT(320,228), "S1412C3.s1412c3f94");
    check_field_offset(lv, s1412c3f95, ABISELECT(332,240), "S1412C3.s1412c3f95");
    check_field_offset(lv, s1412c3f96, ABISELECT(344,252), "S1412C3.s1412c3f96");
    check_field_offset(lv, s1412c3f97, ABISELECT(356,264), "S1412C3.s1412c3f97");
    check_field_offset(lv, s1412c3f98, ABISELECT(368,276), "S1412C3.s1412c3f98");
    check_field_offset(lv, s1412c3f99, ABISELECT(376,280), "S1412C3.s1412c3f99");
    check_field_offset(lv, s1412c3f100, ABISELECT(384,288), "S1412C3.s1412c3f100");
    check_field_offset(lv, s1412c3f101, ABISELECT(400,300), "S1412C3.s1412c3f101");
    check_field_offset(lv, s1412c3f102, ABISELECT(412,312), "S1412C3.s1412c3f102");
    check_field_offset(lv, s1412c3f103, ABISELECT(424,324), "S1412C3.s1412c3f103");
    check_field_offset(lv, s1412c3f104, ABISELECT(428,328), "S1412C3.s1412c3f104");
    check_field_offset(lv, s1412c3f105, ABISELECT(440,340), "S1412C3.s1412c3f105");
    check_field_offset(lv, s1412c3f106, ABISELECT(456,352), "S1412C3.s1412c3f106");
    check_field_offset(lv, s1412c3f107, ABISELECT(464,356), "S1412C3.s1412c3f107");
    check_field_offset(lv, s1412c3f108, ABISELECT(468,360), "S1412C3.s1412c3f108");
    check_field_offset(lv, s1412c3f109, ABISELECT(472,364), "S1412C3.s1412c3f109");
    check_field_offset(lv, s1412c3f110, ABISELECT(484,376), "S1412C3.s1412c3f110");
    check_field_offset(lv, s1412c3f111, ABISELECT(496,388), "S1412C3.s1412c3f111");
    check_field_offset(lv, s1412c3f112, ABISELECT(504,392), "S1412C3.s1412c3f112");
    check_field_offset(lv, s1412c3f113, ABISELECT(512,396), "S1412C3.s1412c3f113");
    check_field_offset(lv, s1412c3f114, ABISELECT(520,400), "S1412C3.s1412c3f114");
    check_field_offset(lv, s1412c3f115, ABISELECT(536,412), "S1412C3.s1412c3f115");
    check_field_offset(lv, s1412c3f116, ABISELECT(552,424), "S1412C3.s1412c3f116");
    test_class_info(&lv, &cd_S1412C3);
    dp->~S1412C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1412C3(Test_S1412C3, "S1412C3", ABISELECT(568,436));

#else // __cplusplus

extern void _ZN7S1412C3C1Ev();
extern void _ZN7S1412C3D1Ev();
Name_Map name_map_S1412C3[] = {
  NSPAIR(_ZN7S1412C3C1Ev),
  NSPAIR(_ZN7S1412C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1412C4;
extern VTBL_ENTRY _ZTI7S1412C4[];
extern  VTBL_ENTRY _ZTV7S1412C4[];
static Base_Class bases_S1412C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1412C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1412C3[];
extern void _ZN7S1412C3D1Ev();
extern void _ZN7S1412C3D0Ev();
extern void _ZN7S1412C42v4Ev();
extern void _ZN7S1412C42v5Ev();
extern void _ZN7S1412C42v6Ev();
extern void _ZN7S1412C42v7Ev();
extern void _ZN7S1412C42v8Ev();
extern void _ZN7S1412C42v9Ev();
extern void _ZN7S1412C43v10Ev();
extern void _ZN7S1412C43v11Ev();
extern void _ZN7S1412C43v12Ev();
extern void _ZN7S1412C43v13Ev();
extern void _ZN7S1412C43v14Ev();
extern void _ZN7S1412C43v15Ev();
extern void _ZN7S1412C43v16Ev();
extern void _ZN7S1412C43v17Ev();
extern void _ZN7S1412C43v18Ev();
extern void _ZN7S1412C43v19Ev();
extern void _ZN7S1412C43v20Ev();
extern void _ZN7S1412C43v21Ev();
extern void _ZN7S1412C43v22Ev();
extern void _ZN7S1412C43v23Ev();
extern void _ZN7S1412C43v24Ev();
extern void _ZN7S1412C43v25Ev();
extern void _ZN7S1412C43v26Ev();
extern void _ZN7S1412C43v27Ev();
extern void _ZN7S1412C43v28Ev();
extern void _ZN7S1412C43v29Ev();
extern void _ZN7S1412C43v30Ev();
extern void _ZN7S1412C43v31Ev();
extern void _ZN7S1412C43v32Ev();
extern void _ZN7S1412C43v33Ev();
extern void _ZN7S1412C43v34Ev();
extern void _ZN7S1412C43v35Ev();
extern void _ZN7S1412C43v36Ev();
extern void _ZN7S1412C43v37Ev();
extern void _ZN7S1412C43v38Ev();
extern void _ZN7S1412C43v39Ev();
extern void _ZN7S1412C43v40Ev();
extern void _ZN7S1412C43v41Ev();
extern void _ZN7S1412C43v42Ev();
extern void _ZN7S1412C43v43Ev();
extern void _ZN7S1412C43v44Ev();
extern void _ZN7S1412C43v45Ev();
extern void _ZN7S1412C43v46Ev();
extern void _ZN7S1412C43v47Ev();
extern void _ZN7S1412C43v48Ev();
extern void _ZN7S1412C43v49Ev();
extern void _ZN7S1412C43v50Ev();
extern void _ZN7S1412C43v51Ev();
extern void _ZN7S1412C43v52Ev();
extern void _ZN7S1412C43v53Ev();
extern void _ZN7S1412C43v54Ev();
extern void _ZN7S1412C43v55Ev();
extern void _ZN7S1412C43v56Ev();
extern void _ZN7S1412C43v57Ev();
extern void _ZN7S1412C43v58Ev();
extern void _ZN7S1412C43v59Ev();
extern void _ZN7S1412C43v60Ev();
extern void _ZN7S1412C43v61Ev();
extern void _ZN7S1412C43v62Ev();
extern void _ZN7S1412C43v63Ev();
extern void _ZN7S1412C43v64Ev();
extern void _ZN7S1412C43v65Ev();
extern void _ZN7S1412C43v66Ev();
extern void _ZN7S1412C43v67Ev();
extern void _ZN7S1412C33v68Ev();
extern void _ZN7S1412C33v69Ev();
extern void _ZN7S1412C33v70Ev();
extern void _ZN7S1412C33v71Ev();
extern void _ZN7S1412C33v72Ev();
extern void _ZN7S1412C33v73Ev();
extern void _ZN7S1412C33v74Ev();
extern void _ZN7S1412C33v75Ev();
extern void _ZN7S1412C33v76Ev();
extern void _ZN7S1412C33v77Ev();
extern void _ZN7S1412C33v78Ev();
extern void _ZN7S1412C33v79Ev();
extern void _ZN7S1412C33v80Ev();
extern void _ZN7S1412C33v81Ev();
extern void _ZN7S1412C33v82Ev();
extern void _ZN7S1412C33v83Ev();
extern void _ZN7S1412C33v84Ev();
extern void _ZN7S1412C33v85Ev();
extern void _ZN7S1412C33v86Ev();
extern void _ZN7S1412C33v87Ev();
extern void _ZN7S1412C33v88Ev();
extern void _ZN7S1412C33v89Ev();
extern void _ZN7S1412C33v90Ev();
extern void _ZN7S1412C33v91Ev();
extern void _ZN7S1412C33v92Ev();
extern void _ZN7S1412C33v93Ev();
extern void _ZN7S1412C33v94Ev();
extern void _ZN7S1412C33v95Ev();
extern void _ZN7S1412C33v96Ev();
extern void _ZN7S1412C33v97Ev();
extern void _ZN7S1412C33v98Ev();
extern void _ZN7S1412C33v99Ev();
extern void _ZN7S1412C34v100Ev();
extern void _ZN7S1412C34v101Ev();
extern void _ZN7S1412C34v102Ev();
extern void _ZN7S1412C34v103Ev();
extern void _ZN7S1412C34v104Ev();
extern void _ZN7S1412C34v105Ev();
extern void _ZN7S1412C34v106Ev();
extern void _ZN7S1412C34v107Ev();
extern void _ZN7S1412C34v108Ev();
extern void _ZN7S1412C34v109Ev();
extern void _ZN7S1412C34v110Ev();
extern void _ZN7S1412C34v111Ev();
extern void _ZN7S1412C34v112Ev();
extern void _ZN7S1412C34v113Ev();
extern void _ZN7S1412C34v114Ev();
extern void _ZN7S1412C34v115Ev();
extern void _ZN7S1412C34v116Ev();
extern void _ZN7S1412C34v117Ev();
extern void _ZN7S1412C34v118Ev();
extern void _ZN7S1412C34v119Ev();
extern void _ZN7S1412C34v120Ev();
extern void _ZN7S1412C34v121Ev();
extern void _ZN7S1412C34v122Ev();
extern void _ZN7S1412C34v123Ev();
extern void _ZN7S1412C34v124Ev();
extern void _ZN7S1412C34v125Ev();
extern void _ZN7S1412C34v126Ev();
extern void _ZN7S1412C34v127Ev();
extern void _ZN7S1412C34v128Ev();
extern void _ZN7S1412C34v129Ev();
extern void _ZN7S1412C34v130Ev();
extern void _ZN7S1412C34v131Ev();
extern void _ZN7S1412C34v132Ev();
extern void _ZN7S1412C34v133Ev();
extern void _ZN7S1412C34v134Ev();
extern void _ZN7S1412C34v135Ev();
extern void _ZN7S1412C34v136Ev();
extern void _ZN7S1412C34v137Ev();
extern void _ZN7S1412C34v138Ev();
extern void _ZN7S1412C34v139Ev();
extern void _ZN7S1412C34v140Ev();
extern void _ZN7S1412C34v141Ev();
extern void _ZN7S1412C34v142Ev();
extern void _ZN7S1412C34v143Ev();
extern void _ZN7S1412C34v144Ev();
extern void _ZN7S1412C34v145Ev();
extern void _ZN7S1412C34v146Ev();
extern void _ZN7S1412C34v147Ev();
extern void _ZN7S1412C34v148Ev();
extern void _ZN7S1412C34v149Ev();
extern void _ZN7S1412C34v150Ev();
extern void _ZN7S1412C34v151Ev();
extern void _ZN7S1412C34v152Ev();
extern void _ZN7S1412C34v153Ev();
extern void _ZN7S1412C34v154Ev();
extern void _ZN7S1412C34v155Ev();
extern void _ZN7S1412C34v156Ev();
extern void _ZN7S1412C34v157Ev();
extern void _ZN7S1412C34v158Ev();
extern void _ZN7S1412C34v159Ev();
extern void _ZN7S1412C34v160Ev();
extern void _ZN7S1412C34v161Ev();
extern void _ZN7S1412C34v162Ev();
extern void _ZN7S1412C34v163Ev();
extern void _ZN7S1412C34v164Ev();
extern void _ZN7S1412C34v165Ev();
extern void _ZN7S1412C34v166Ev();
extern void _ZN7S1412C34v167Ev();
extern void _ZN7S1412C34v168Ev();
extern void _ZN7S1412C34v169Ev();
extern void _ZN7S1412C34v170Ev();
extern void _ZN7S1412C34v171Ev();
extern void _ZN7S1412C34v172Ev();
extern void _ZN7S1412C34v173Ev();
extern void _ZN7S1412C34v174Ev();
extern void _ZN7S1412C34v175Ev();
extern void _ZN7S1412C34v176Ev();
extern void _ZN7S1412C34v177Ev();
extern void _ZN7S1412C34v178Ev();
extern void _ZN7S1412C34v179Ev();
extern void _ZN7S1412C34v180Ev();
extern void _ZN7S1412C34v181Ev();
extern void _ZN7S1412C34v182Ev();
extern void _ZN7S1412C34v183Ev();
extern void _ZN7S1412C34v184Ev();
extern void _ZN7S1412C34v185Ev();
extern void _ZN7S1412C34v186Ev();
extern void _ZN7S1412C34v187Ev();
extern void _ZN7S1412C34v188Ev();
extern void _ZN7S1412C34v189Ev();
extern void _ZN7S1412C34v190Ev();
extern void _ZN7S1412C34v191Ev();
extern void _ZN7S1412C34v192Ev();
extern void _ZN7S1412C34v193Ev();
extern void _ZN7S1412C34v194Ev();
extern void _ZN7S1412C34v195Ev();
extern void _ZN7S1412C34v196Ev();
extern void _ZN7S1412C34v197Ev();
extern void _ZN7S1412C34v198Ev();
extern void _ZN7S1412C34v199Ev();
extern void _ZN7S1412C34v200Ev();
extern void _ZN7S1412C34v201Ev();
extern void _ZN7S1412C34v202Ev();
extern void _ZN7S1412C34v203Ev();
extern void _ZN7S1412C34v204Ev();
extern void _ZN7S1412C34v205Ev();
extern void _ZN7S1412C34v206Ev();
extern void _ZN7S1412C34v207Ev();
extern void _ZN7S1412C34v208Ev();
extern void _ZN7S1412C34v209Ev();
extern void _ZN7S1412C34v210Ev();
static  VTBL_ENTRY vtc_S1412C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1412C3[0]),
  (VTBL_ENTRY)&_ZN7S1412C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1412C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1412C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1412C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1412C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1412C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1412C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1412C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v68Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v69Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v102Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v103Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v104Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v105Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v106Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v107Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v108Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v109Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v110Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v111Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v112Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v113Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v114Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v115Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v116Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v117Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v118Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v119Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v120Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v121Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v122Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v123Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v124Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v125Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v126Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v127Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v128Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v129Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v130Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v131Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v132Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v133Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v134Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v135Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v136Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v137Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v138Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v139Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v140Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v141Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v142Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v143Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v144Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v145Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v146Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v147Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v148Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v149Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v150Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v151Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v152Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v153Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v154Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v155Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v156Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v157Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v158Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v159Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v160Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v161Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v162Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v163Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v164Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v165Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v166Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v167Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v168Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v169Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v170Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v171Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v172Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v173Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v174Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v175Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v176Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v177Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v178Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v179Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v180Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v181Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v182Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v183Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v184Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v185Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v186Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v187Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v188Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v189Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v190Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v191Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v192Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v193Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v194Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v195Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v196Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v197Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v198Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v199Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v200Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v201Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v202Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v203Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v204Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v205Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v206Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v207Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v208Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v209Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v210Ev,
};
extern VTBL_ENTRY _ZTI7S1412C3[];
extern  VTBL_ENTRY _ZTV7S1412C3[];
Class_Descriptor cd_S1412C3 = {  "S1412C3", // class name
  bases_S1412C3, 1,
  &(vtc_S1412C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(568,436), // object size
  NSPAIRA(_ZTI7S1412C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1412C3),211, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1412C2  : S1412C3 {
  virtual  ~S1412C2(); // _ZN7S1412C2D1Ev
  virtual void  v211(); // _ZN7S1412C24v211Ev
  virtual void  v212(); // _ZN7S1412C24v212Ev
  virtual void  v213(); // _ZN7S1412C24v213Ev
  S1412C2(); // tgen
};
//SIG(-1 S1412C2) C1{ BC2{ BC3{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC5 FC8{ m Fi} Fi Fc[4] Fp[2] FC9{ BC10{ BC7}} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC4 FC4 FC4 FC11{ BC12{ BC7}} FC11 Fi Fp[2] FC13{ m Fi[3]} FC14{ m Fi[3]} FC13 FC13 Fp FC4 FC11 FC13 FC14 Fi FC13 FC13 Fp Fi Fc FC14 FC14 Fp Fi Fp FC15{ BC16{ BC7}} FC17{ BC18{ BC7}} FC17} vd v1 v2 v3}


 S1412C2 ::~S1412C2(){ note_dtor("S1412C2", this);}
void  S1412C2 ::v211(){vfunc_called(this, "_ZN7S1412C24v211Ev");}
void  S1412C2 ::v212(){vfunc_called(this, "_ZN7S1412C24v212Ev");}
void  S1412C2 ::v213(){vfunc_called(this, "_ZN7S1412C24v213Ev");}
S1412C2 ::S1412C2(){ note_ctor("S1412C2", this);} // tgen

static void Test_S1412C2()
{
  extern Class_Descriptor cd_S1412C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(72,110)];
    init_test(&cd_S1412C2, buf);
    S1412C2 *dp, &lv = *(dp=new (buf) S1412C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(568,436), "sizeof(S1412C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1412C2)");
    check_base_class_offset(lv, (S1412C4*)(S1412C3*), 0, "S1412C2");
    check_base_class_offset(lv, (S1412C3*), 0, "S1412C2");
    test_class_info(&lv, &cd_S1412C2);
    dp->~S1412C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1412C2(Test_S1412C2, "S1412C2", ABISELECT(568,436));

#else // __cplusplus

extern void _ZN7S1412C2C1Ev();
extern void _ZN7S1412C2D1Ev();
Name_Map name_map_S1412C2[] = {
  NSPAIR(_ZN7S1412C2C1Ev),
  NSPAIR(_ZN7S1412C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1412C4;
extern VTBL_ENTRY _ZTI7S1412C4[];
extern  VTBL_ENTRY _ZTV7S1412C4[];
extern Class_Descriptor cd_S1412C3;
extern VTBL_ENTRY _ZTI7S1412C3[];
extern  VTBL_ENTRY _ZTV7S1412C3[];
static Base_Class bases_S1412C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1412C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1412C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1412C2[];
extern void _ZN7S1412C2D1Ev();
extern void _ZN7S1412C2D0Ev();
extern void _ZN7S1412C42v4Ev();
extern void _ZN7S1412C42v5Ev();
extern void _ZN7S1412C42v6Ev();
extern void _ZN7S1412C42v7Ev();
extern void _ZN7S1412C42v8Ev();
extern void _ZN7S1412C42v9Ev();
extern void _ZN7S1412C43v10Ev();
extern void _ZN7S1412C43v11Ev();
extern void _ZN7S1412C43v12Ev();
extern void _ZN7S1412C43v13Ev();
extern void _ZN7S1412C43v14Ev();
extern void _ZN7S1412C43v15Ev();
extern void _ZN7S1412C43v16Ev();
extern void _ZN7S1412C43v17Ev();
extern void _ZN7S1412C43v18Ev();
extern void _ZN7S1412C43v19Ev();
extern void _ZN7S1412C43v20Ev();
extern void _ZN7S1412C43v21Ev();
extern void _ZN7S1412C43v22Ev();
extern void _ZN7S1412C43v23Ev();
extern void _ZN7S1412C43v24Ev();
extern void _ZN7S1412C43v25Ev();
extern void _ZN7S1412C43v26Ev();
extern void _ZN7S1412C43v27Ev();
extern void _ZN7S1412C43v28Ev();
extern void _ZN7S1412C43v29Ev();
extern void _ZN7S1412C43v30Ev();
extern void _ZN7S1412C43v31Ev();
extern void _ZN7S1412C43v32Ev();
extern void _ZN7S1412C43v33Ev();
extern void _ZN7S1412C43v34Ev();
extern void _ZN7S1412C43v35Ev();
extern void _ZN7S1412C43v36Ev();
extern void _ZN7S1412C43v37Ev();
extern void _ZN7S1412C43v38Ev();
extern void _ZN7S1412C43v39Ev();
extern void _ZN7S1412C43v40Ev();
extern void _ZN7S1412C43v41Ev();
extern void _ZN7S1412C43v42Ev();
extern void _ZN7S1412C43v43Ev();
extern void _ZN7S1412C43v44Ev();
extern void _ZN7S1412C43v45Ev();
extern void _ZN7S1412C43v46Ev();
extern void _ZN7S1412C43v47Ev();
extern void _ZN7S1412C43v48Ev();
extern void _ZN7S1412C43v49Ev();
extern void _ZN7S1412C43v50Ev();
extern void _ZN7S1412C43v51Ev();
extern void _ZN7S1412C43v52Ev();
extern void _ZN7S1412C43v53Ev();
extern void _ZN7S1412C43v54Ev();
extern void _ZN7S1412C43v55Ev();
extern void _ZN7S1412C43v56Ev();
extern void _ZN7S1412C43v57Ev();
extern void _ZN7S1412C43v58Ev();
extern void _ZN7S1412C43v59Ev();
extern void _ZN7S1412C43v60Ev();
extern void _ZN7S1412C43v61Ev();
extern void _ZN7S1412C43v62Ev();
extern void _ZN7S1412C43v63Ev();
extern void _ZN7S1412C43v64Ev();
extern void _ZN7S1412C43v65Ev();
extern void _ZN7S1412C43v66Ev();
extern void _ZN7S1412C43v67Ev();
extern void _ZN7S1412C33v68Ev();
extern void _ZN7S1412C33v69Ev();
extern void _ZN7S1412C33v70Ev();
extern void _ZN7S1412C33v71Ev();
extern void _ZN7S1412C33v72Ev();
extern void _ZN7S1412C33v73Ev();
extern void _ZN7S1412C33v74Ev();
extern void _ZN7S1412C33v75Ev();
extern void _ZN7S1412C33v76Ev();
extern void _ZN7S1412C33v77Ev();
extern void _ZN7S1412C33v78Ev();
extern void _ZN7S1412C33v79Ev();
extern void _ZN7S1412C33v80Ev();
extern void _ZN7S1412C33v81Ev();
extern void _ZN7S1412C33v82Ev();
extern void _ZN7S1412C33v83Ev();
extern void _ZN7S1412C33v84Ev();
extern void _ZN7S1412C33v85Ev();
extern void _ZN7S1412C33v86Ev();
extern void _ZN7S1412C33v87Ev();
extern void _ZN7S1412C33v88Ev();
extern void _ZN7S1412C33v89Ev();
extern void _ZN7S1412C33v90Ev();
extern void _ZN7S1412C33v91Ev();
extern void _ZN7S1412C33v92Ev();
extern void _ZN7S1412C33v93Ev();
extern void _ZN7S1412C33v94Ev();
extern void _ZN7S1412C33v95Ev();
extern void _ZN7S1412C33v96Ev();
extern void _ZN7S1412C33v97Ev();
extern void _ZN7S1412C33v98Ev();
extern void _ZN7S1412C33v99Ev();
extern void _ZN7S1412C34v100Ev();
extern void _ZN7S1412C34v101Ev();
extern void _ZN7S1412C34v102Ev();
extern void _ZN7S1412C34v103Ev();
extern void _ZN7S1412C34v104Ev();
extern void _ZN7S1412C34v105Ev();
extern void _ZN7S1412C34v106Ev();
extern void _ZN7S1412C34v107Ev();
extern void _ZN7S1412C34v108Ev();
extern void _ZN7S1412C34v109Ev();
extern void _ZN7S1412C34v110Ev();
extern void _ZN7S1412C34v111Ev();
extern void _ZN7S1412C34v112Ev();
extern void _ZN7S1412C34v113Ev();
extern void _ZN7S1412C34v114Ev();
extern void _ZN7S1412C34v115Ev();
extern void _ZN7S1412C34v116Ev();
extern void _ZN7S1412C34v117Ev();
extern void _ZN7S1412C34v118Ev();
extern void _ZN7S1412C34v119Ev();
extern void _ZN7S1412C34v120Ev();
extern void _ZN7S1412C34v121Ev();
extern void _ZN7S1412C34v122Ev();
extern void _ZN7S1412C34v123Ev();
extern void _ZN7S1412C34v124Ev();
extern void _ZN7S1412C34v125Ev();
extern void _ZN7S1412C34v126Ev();
extern void _ZN7S1412C34v127Ev();
extern void _ZN7S1412C34v128Ev();
extern void _ZN7S1412C34v129Ev();
extern void _ZN7S1412C34v130Ev();
extern void _ZN7S1412C34v131Ev();
extern void _ZN7S1412C34v132Ev();
extern void _ZN7S1412C34v133Ev();
extern void _ZN7S1412C34v134Ev();
extern void _ZN7S1412C34v135Ev();
extern void _ZN7S1412C34v136Ev();
extern void _ZN7S1412C34v137Ev();
extern void _ZN7S1412C34v138Ev();
extern void _ZN7S1412C34v139Ev();
extern void _ZN7S1412C34v140Ev();
extern void _ZN7S1412C34v141Ev();
extern void _ZN7S1412C34v142Ev();
extern void _ZN7S1412C34v143Ev();
extern void _ZN7S1412C34v144Ev();
extern void _ZN7S1412C34v145Ev();
extern void _ZN7S1412C34v146Ev();
extern void _ZN7S1412C34v147Ev();
extern void _ZN7S1412C34v148Ev();
extern void _ZN7S1412C34v149Ev();
extern void _ZN7S1412C34v150Ev();
extern void _ZN7S1412C34v151Ev();
extern void _ZN7S1412C34v152Ev();
extern void _ZN7S1412C34v153Ev();
extern void _ZN7S1412C34v154Ev();
extern void _ZN7S1412C34v155Ev();
extern void _ZN7S1412C34v156Ev();
extern void _ZN7S1412C34v157Ev();
extern void _ZN7S1412C34v158Ev();
extern void _ZN7S1412C34v159Ev();
extern void _ZN7S1412C34v160Ev();
extern void _ZN7S1412C34v161Ev();
extern void _ZN7S1412C34v162Ev();
extern void _ZN7S1412C34v163Ev();
extern void _ZN7S1412C34v164Ev();
extern void _ZN7S1412C34v165Ev();
extern void _ZN7S1412C34v166Ev();
extern void _ZN7S1412C34v167Ev();
extern void _ZN7S1412C34v168Ev();
extern void _ZN7S1412C34v169Ev();
extern void _ZN7S1412C34v170Ev();
extern void _ZN7S1412C34v171Ev();
extern void _ZN7S1412C34v172Ev();
extern void _ZN7S1412C34v173Ev();
extern void _ZN7S1412C34v174Ev();
extern void _ZN7S1412C34v175Ev();
extern void _ZN7S1412C34v176Ev();
extern void _ZN7S1412C34v177Ev();
extern void _ZN7S1412C34v178Ev();
extern void _ZN7S1412C34v179Ev();
extern void _ZN7S1412C34v180Ev();
extern void _ZN7S1412C34v181Ev();
extern void _ZN7S1412C34v182Ev();
extern void _ZN7S1412C34v183Ev();
extern void _ZN7S1412C34v184Ev();
extern void _ZN7S1412C34v185Ev();
extern void _ZN7S1412C34v186Ev();
extern void _ZN7S1412C34v187Ev();
extern void _ZN7S1412C34v188Ev();
extern void _ZN7S1412C34v189Ev();
extern void _ZN7S1412C34v190Ev();
extern void _ZN7S1412C34v191Ev();
extern void _ZN7S1412C34v192Ev();
extern void _ZN7S1412C34v193Ev();
extern void _ZN7S1412C34v194Ev();
extern void _ZN7S1412C34v195Ev();
extern void _ZN7S1412C34v196Ev();
extern void _ZN7S1412C34v197Ev();
extern void _ZN7S1412C34v198Ev();
extern void _ZN7S1412C34v199Ev();
extern void _ZN7S1412C34v200Ev();
extern void _ZN7S1412C34v201Ev();
extern void _ZN7S1412C34v202Ev();
extern void _ZN7S1412C34v203Ev();
extern void _ZN7S1412C34v204Ev();
extern void _ZN7S1412C34v205Ev();
extern void _ZN7S1412C34v206Ev();
extern void _ZN7S1412C34v207Ev();
extern void _ZN7S1412C34v208Ev();
extern void _ZN7S1412C34v209Ev();
extern void _ZN7S1412C34v210Ev();
extern void _ZN7S1412C24v211Ev();
extern void _ZN7S1412C24v212Ev();
extern void _ZN7S1412C24v213Ev();
static  VTBL_ENTRY vtc_S1412C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1412C2[0]),
  (VTBL_ENTRY)&_ZN7S1412C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1412C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1412C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1412C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1412C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1412C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1412C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1412C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v68Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v69Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v102Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v103Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v104Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v105Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v106Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v107Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v108Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v109Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v110Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v111Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v112Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v113Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v114Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v115Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v116Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v117Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v118Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v119Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v120Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v121Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v122Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v123Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v124Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v125Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v126Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v127Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v128Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v129Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v130Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v131Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v132Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v133Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v134Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v135Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v136Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v137Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v138Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v139Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v140Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v141Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v142Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v143Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v144Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v145Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v146Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v147Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v148Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v149Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v150Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v151Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v152Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v153Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v154Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v155Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v156Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v157Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v158Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v159Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v160Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v161Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v162Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v163Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v164Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v165Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v166Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v167Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v168Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v169Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v170Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v171Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v172Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v173Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v174Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v175Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v176Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v177Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v178Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v179Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v180Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v181Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v182Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v183Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v184Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v185Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v186Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v187Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v188Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v189Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v190Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v191Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v192Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v193Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v194Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v195Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v196Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v197Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v198Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v199Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v200Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v201Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v202Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v203Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v204Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v205Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v206Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v207Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v208Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v209Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v210Ev,
  (VTBL_ENTRY)&_ZN7S1412C24v211Ev,
  (VTBL_ENTRY)&_ZN7S1412C24v212Ev,
  (VTBL_ENTRY)&_ZN7S1412C24v213Ev,
};
extern VTBL_ENTRY _ZTI7S1412C2[];
extern  VTBL_ENTRY _ZTV7S1412C2[];
Class_Descriptor cd_S1412C2 = {  "S1412C2", // class name
  bases_S1412C2, 2,
  &(vtc_S1412C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(568,436), // object size
  NSPAIRA(_ZTI7S1412C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1412C2),214, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1412C1  : S1412C2 {
  void *s1412c1f0;
  virtual  ~S1412C1(); // _ZN7S1412C1D1Ev
  virtual void  v1(); // _ZN7S1412C12v1Ev
  virtual void  v2(); // _ZN7S1412C12v2Ev
  virtual void  v3(); // _ZN7S1412C12v3Ev
  S1412C1(); // tgen
};
//SIG(1 S1412C1) C1{ BC2{ BC3{ BC4{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC6 FC9{ m Fi} Fi Fc[4] Fp[2] FC10{ BC11{ BC8}} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC5 FC5 FC5 FC12{ BC13{ BC8}} FC12 Fi Fp[2] FC14{ m Fi[3]} FC15{ m Fi[3]} FC14 FC14 Fp FC5 FC12 FC14 FC15 Fi FC14 FC14 Fp Fi Fc FC15 FC15 Fp Fi Fp FC16{ BC17{ BC8}} FC18{ BC19{ BC8}} FC18} vd v211 v212 v213} vd v1 v2 v3 Fp}


 S1412C1 ::~S1412C1(){ note_dtor("S1412C1", this);}
void  S1412C1 ::v1(){vfunc_called(this, "_ZN7S1412C12v1Ev");}
void  S1412C1 ::v2(){vfunc_called(this, "_ZN7S1412C12v2Ev");}
void  S1412C1 ::v3(){vfunc_called(this, "_ZN7S1412C12v3Ev");}
S1412C1 ::S1412C1(){ note_ctor("S1412C1", this);} // tgen

static void Test_S1412C1()
{
  extern Class_Descriptor cd_S1412C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(73,111)];
    init_test(&cd_S1412C1, buf);
    S1412C1 *dp, &lv = *(dp=new (buf) S1412C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(576,440), "sizeof(S1412C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1412C1)");
    check_base_class_offset(lv, (S1412C4*)(S1412C3*)(S1412C2*), 0, "S1412C1");
    check_base_class_offset(lv, (S1412C3*)(S1412C2*), 0, "S1412C1");
    check_base_class_offset(lv, (S1412C2*), 0, "S1412C1");
    check_field_offset(lv, s1412c1f0, ABISELECT(568,436), "S1412C1.s1412c1f0");
    test_class_info(&lv, &cd_S1412C1);
    dp->~S1412C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1412C1(Test_S1412C1, "S1412C1", ABISELECT(576,440));

#else // __cplusplus

extern void _ZN7S1412C1C1Ev();
extern void _ZN7S1412C1D1Ev();
Name_Map name_map_S1412C1[] = {
  NSPAIR(_ZN7S1412C1C1Ev),
  NSPAIR(_ZN7S1412C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1412C4;
extern VTBL_ENTRY _ZTI7S1412C4[];
extern  VTBL_ENTRY _ZTV7S1412C4[];
extern Class_Descriptor cd_S1412C3;
extern VTBL_ENTRY _ZTI7S1412C3[];
extern  VTBL_ENTRY _ZTV7S1412C3[];
extern Class_Descriptor cd_S1412C2;
extern VTBL_ENTRY _ZTI7S1412C2[];
extern  VTBL_ENTRY _ZTV7S1412C2[];
static Base_Class bases_S1412C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1412C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1412C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1412C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1412C1[];
extern void _ZN7S1412C1D1Ev();
extern void _ZN7S1412C1D0Ev();
extern void _ZN7S1412C42v4Ev();
extern void _ZN7S1412C42v5Ev();
extern void _ZN7S1412C42v6Ev();
extern void _ZN7S1412C42v7Ev();
extern void _ZN7S1412C42v8Ev();
extern void _ZN7S1412C42v9Ev();
extern void _ZN7S1412C43v10Ev();
extern void _ZN7S1412C43v11Ev();
extern void _ZN7S1412C43v12Ev();
extern void _ZN7S1412C43v13Ev();
extern void _ZN7S1412C43v14Ev();
extern void _ZN7S1412C43v15Ev();
extern void _ZN7S1412C43v16Ev();
extern void _ZN7S1412C43v17Ev();
extern void _ZN7S1412C43v18Ev();
extern void _ZN7S1412C43v19Ev();
extern void _ZN7S1412C43v20Ev();
extern void _ZN7S1412C43v21Ev();
extern void _ZN7S1412C43v22Ev();
extern void _ZN7S1412C43v23Ev();
extern void _ZN7S1412C43v24Ev();
extern void _ZN7S1412C43v25Ev();
extern void _ZN7S1412C43v26Ev();
extern void _ZN7S1412C43v27Ev();
extern void _ZN7S1412C43v28Ev();
extern void _ZN7S1412C43v29Ev();
extern void _ZN7S1412C43v30Ev();
extern void _ZN7S1412C43v31Ev();
extern void _ZN7S1412C43v32Ev();
extern void _ZN7S1412C43v33Ev();
extern void _ZN7S1412C43v34Ev();
extern void _ZN7S1412C43v35Ev();
extern void _ZN7S1412C43v36Ev();
extern void _ZN7S1412C43v37Ev();
extern void _ZN7S1412C43v38Ev();
extern void _ZN7S1412C43v39Ev();
extern void _ZN7S1412C43v40Ev();
extern void _ZN7S1412C43v41Ev();
extern void _ZN7S1412C43v42Ev();
extern void _ZN7S1412C43v43Ev();
extern void _ZN7S1412C43v44Ev();
extern void _ZN7S1412C43v45Ev();
extern void _ZN7S1412C43v46Ev();
extern void _ZN7S1412C43v47Ev();
extern void _ZN7S1412C43v48Ev();
extern void _ZN7S1412C43v49Ev();
extern void _ZN7S1412C43v50Ev();
extern void _ZN7S1412C43v51Ev();
extern void _ZN7S1412C43v52Ev();
extern void _ZN7S1412C43v53Ev();
extern void _ZN7S1412C43v54Ev();
extern void _ZN7S1412C43v55Ev();
extern void _ZN7S1412C43v56Ev();
extern void _ZN7S1412C43v57Ev();
extern void _ZN7S1412C43v58Ev();
extern void _ZN7S1412C43v59Ev();
extern void _ZN7S1412C43v60Ev();
extern void _ZN7S1412C43v61Ev();
extern void _ZN7S1412C43v62Ev();
extern void _ZN7S1412C43v63Ev();
extern void _ZN7S1412C43v64Ev();
extern void _ZN7S1412C43v65Ev();
extern void _ZN7S1412C43v66Ev();
extern void _ZN7S1412C43v67Ev();
extern void _ZN7S1412C33v68Ev();
extern void _ZN7S1412C33v69Ev();
extern void _ZN7S1412C33v70Ev();
extern void _ZN7S1412C33v71Ev();
extern void _ZN7S1412C33v72Ev();
extern void _ZN7S1412C33v73Ev();
extern void _ZN7S1412C33v74Ev();
extern void _ZN7S1412C33v75Ev();
extern void _ZN7S1412C33v76Ev();
extern void _ZN7S1412C33v77Ev();
extern void _ZN7S1412C33v78Ev();
extern void _ZN7S1412C33v79Ev();
extern void _ZN7S1412C33v80Ev();
extern void _ZN7S1412C33v81Ev();
extern void _ZN7S1412C33v82Ev();
extern void _ZN7S1412C33v83Ev();
extern void _ZN7S1412C33v84Ev();
extern void _ZN7S1412C33v85Ev();
extern void _ZN7S1412C33v86Ev();
extern void _ZN7S1412C33v87Ev();
extern void _ZN7S1412C33v88Ev();
extern void _ZN7S1412C33v89Ev();
extern void _ZN7S1412C33v90Ev();
extern void _ZN7S1412C33v91Ev();
extern void _ZN7S1412C33v92Ev();
extern void _ZN7S1412C33v93Ev();
extern void _ZN7S1412C33v94Ev();
extern void _ZN7S1412C33v95Ev();
extern void _ZN7S1412C33v96Ev();
extern void _ZN7S1412C33v97Ev();
extern void _ZN7S1412C33v98Ev();
extern void _ZN7S1412C33v99Ev();
extern void _ZN7S1412C34v100Ev();
extern void _ZN7S1412C34v101Ev();
extern void _ZN7S1412C34v102Ev();
extern void _ZN7S1412C34v103Ev();
extern void _ZN7S1412C34v104Ev();
extern void _ZN7S1412C34v105Ev();
extern void _ZN7S1412C34v106Ev();
extern void _ZN7S1412C34v107Ev();
extern void _ZN7S1412C34v108Ev();
extern void _ZN7S1412C34v109Ev();
extern void _ZN7S1412C34v110Ev();
extern void _ZN7S1412C34v111Ev();
extern void _ZN7S1412C34v112Ev();
extern void _ZN7S1412C34v113Ev();
extern void _ZN7S1412C34v114Ev();
extern void _ZN7S1412C34v115Ev();
extern void _ZN7S1412C34v116Ev();
extern void _ZN7S1412C34v117Ev();
extern void _ZN7S1412C34v118Ev();
extern void _ZN7S1412C34v119Ev();
extern void _ZN7S1412C34v120Ev();
extern void _ZN7S1412C34v121Ev();
extern void _ZN7S1412C34v122Ev();
extern void _ZN7S1412C34v123Ev();
extern void _ZN7S1412C34v124Ev();
extern void _ZN7S1412C34v125Ev();
extern void _ZN7S1412C34v126Ev();
extern void _ZN7S1412C34v127Ev();
extern void _ZN7S1412C34v128Ev();
extern void _ZN7S1412C34v129Ev();
extern void _ZN7S1412C34v130Ev();
extern void _ZN7S1412C34v131Ev();
extern void _ZN7S1412C34v132Ev();
extern void _ZN7S1412C34v133Ev();
extern void _ZN7S1412C34v134Ev();
extern void _ZN7S1412C34v135Ev();
extern void _ZN7S1412C34v136Ev();
extern void _ZN7S1412C34v137Ev();
extern void _ZN7S1412C34v138Ev();
extern void _ZN7S1412C34v139Ev();
extern void _ZN7S1412C34v140Ev();
extern void _ZN7S1412C34v141Ev();
extern void _ZN7S1412C34v142Ev();
extern void _ZN7S1412C34v143Ev();
extern void _ZN7S1412C34v144Ev();
extern void _ZN7S1412C34v145Ev();
extern void _ZN7S1412C34v146Ev();
extern void _ZN7S1412C34v147Ev();
extern void _ZN7S1412C34v148Ev();
extern void _ZN7S1412C34v149Ev();
extern void _ZN7S1412C34v150Ev();
extern void _ZN7S1412C34v151Ev();
extern void _ZN7S1412C34v152Ev();
extern void _ZN7S1412C34v153Ev();
extern void _ZN7S1412C34v154Ev();
extern void _ZN7S1412C34v155Ev();
extern void _ZN7S1412C34v156Ev();
extern void _ZN7S1412C34v157Ev();
extern void _ZN7S1412C34v158Ev();
extern void _ZN7S1412C34v159Ev();
extern void _ZN7S1412C34v160Ev();
extern void _ZN7S1412C34v161Ev();
extern void _ZN7S1412C34v162Ev();
extern void _ZN7S1412C34v163Ev();
extern void _ZN7S1412C34v164Ev();
extern void _ZN7S1412C34v165Ev();
extern void _ZN7S1412C34v166Ev();
extern void _ZN7S1412C34v167Ev();
extern void _ZN7S1412C34v168Ev();
extern void _ZN7S1412C34v169Ev();
extern void _ZN7S1412C34v170Ev();
extern void _ZN7S1412C34v171Ev();
extern void _ZN7S1412C34v172Ev();
extern void _ZN7S1412C34v173Ev();
extern void _ZN7S1412C34v174Ev();
extern void _ZN7S1412C34v175Ev();
extern void _ZN7S1412C34v176Ev();
extern void _ZN7S1412C34v177Ev();
extern void _ZN7S1412C34v178Ev();
extern void _ZN7S1412C34v179Ev();
extern void _ZN7S1412C34v180Ev();
extern void _ZN7S1412C34v181Ev();
extern void _ZN7S1412C34v182Ev();
extern void _ZN7S1412C34v183Ev();
extern void _ZN7S1412C34v184Ev();
extern void _ZN7S1412C34v185Ev();
extern void _ZN7S1412C34v186Ev();
extern void _ZN7S1412C34v187Ev();
extern void _ZN7S1412C34v188Ev();
extern void _ZN7S1412C34v189Ev();
extern void _ZN7S1412C34v190Ev();
extern void _ZN7S1412C34v191Ev();
extern void _ZN7S1412C34v192Ev();
extern void _ZN7S1412C34v193Ev();
extern void _ZN7S1412C34v194Ev();
extern void _ZN7S1412C34v195Ev();
extern void _ZN7S1412C34v196Ev();
extern void _ZN7S1412C34v197Ev();
extern void _ZN7S1412C34v198Ev();
extern void _ZN7S1412C34v199Ev();
extern void _ZN7S1412C34v200Ev();
extern void _ZN7S1412C34v201Ev();
extern void _ZN7S1412C34v202Ev();
extern void _ZN7S1412C34v203Ev();
extern void _ZN7S1412C34v204Ev();
extern void _ZN7S1412C34v205Ev();
extern void _ZN7S1412C34v206Ev();
extern void _ZN7S1412C34v207Ev();
extern void _ZN7S1412C34v208Ev();
extern void _ZN7S1412C34v209Ev();
extern void _ZN7S1412C34v210Ev();
extern void _ZN7S1412C24v211Ev();
extern void _ZN7S1412C24v212Ev();
extern void _ZN7S1412C24v213Ev();
extern void _ZN7S1412C12v1Ev();
extern void _ZN7S1412C12v2Ev();
extern void _ZN7S1412C12v3Ev();
static  VTBL_ENTRY vtc_S1412C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1412C1[0]),
  (VTBL_ENTRY)&_ZN7S1412C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1412C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1412C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1412C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1412C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1412C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1412C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1412C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1412C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v68Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v69Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1412C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v102Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v103Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v104Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v105Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v106Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v107Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v108Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v109Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v110Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v111Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v112Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v113Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v114Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v115Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v116Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v117Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v118Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v119Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v120Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v121Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v122Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v123Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v124Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v125Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v126Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v127Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v128Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v129Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v130Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v131Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v132Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v133Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v134Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v135Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v136Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v137Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v138Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v139Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v140Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v141Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v142Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v143Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v144Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v145Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v146Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v147Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v148Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v149Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v150Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v151Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v152Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v153Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v154Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v155Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v156Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v157Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v158Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v159Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v160Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v161Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v162Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v163Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v164Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v165Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v166Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v167Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v168Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v169Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v170Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v171Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v172Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v173Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v174Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v175Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v176Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v177Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v178Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v179Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v180Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v181Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v182Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v183Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v184Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v185Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v186Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v187Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v188Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v189Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v190Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v191Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v192Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v193Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v194Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v195Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v196Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v197Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v198Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v199Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v200Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v201Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v202Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v203Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v204Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v205Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v206Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v207Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v208Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v209Ev,
  (VTBL_ENTRY)&_ZN7S1412C34v210Ev,
  (VTBL_ENTRY)&_ZN7S1412C24v211Ev,
  (VTBL_ENTRY)&_ZN7S1412C24v212Ev,
  (VTBL_ENTRY)&_ZN7S1412C24v213Ev,
  (VTBL_ENTRY)&_ZN7S1412C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1412C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1412C12v3Ev,
};
extern VTBL_ENTRY _ZTI7S1412C1[];
extern  VTBL_ENTRY _ZTV7S1412C1[];
Class_Descriptor cd_S1412C1 = {  "S1412C1", // class name
  bases_S1412C1, 3,
  &(vtc_S1412C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(576,440), // object size
  NSPAIRA(_ZTI7S1412C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1412C1),217, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S694C5  {
  int s694c5f0;
  __tsi64 s694c5f1;
  void *s694c5f2[4];
  int s694c5f3[2];
  void *s694c5f4;
  ::S1457C5_nt s694c5f5;
  void *s694c5f6[2];
  virtual  ~S694C5(); // _ZN6S694C5D1Ev
  virtual void  v7(); // _ZN6S694C52v7Ev
  virtual void  v8(); // _ZN6S694C52v8Ev
  virtual void  v9(); // _ZN6S694C52v9Ev
  virtual void  v10(); // _ZN6S694C53v10Ev
  virtual void  v11(); // _ZN6S694C53v11Ev
  virtual void  v12(); // _ZN6S694C53v12Ev
  virtual void  v13(); // _ZN6S694C53v13Ev
  virtual void  v14(); // _ZN6S694C53v14Ev
  virtual void  v15(); // _ZN6S694C53v15Ev
  virtual void  v16(); // _ZN6S694C53v16Ev
  virtual void  v17(); // _ZN6S694C53v17Ev
  virtual void  v18(); // _ZN6S694C53v18Ev
  virtual void  v19(); // _ZN6S694C53v19Ev
  virtual void  v20(); // _ZN6S694C53v20Ev
  virtual void  v21(); // _ZN6S694C53v21Ev
  virtual void  v22(); // _ZN6S694C53v22Ev
  virtual void  v23(); // _ZN6S694C53v23Ev
  virtual void  v24(); // _ZN6S694C53v24Ev
  virtual void  v25(); // _ZN6S694C53v25Ev
  virtual void  v26(); // _ZN6S694C53v26Ev
  virtual void  v27(); // _ZN6S694C53v27Ev
  virtual void  v28(); // _ZN6S694C53v28Ev
  virtual void  v29(); // _ZN6S694C53v29Ev
  virtual void  v30(); // _ZN6S694C53v30Ev
  virtual void  v31(); // _ZN6S694C53v31Ev
  virtual void  v32(); // _ZN6S694C53v32Ev
  virtual void  v33(); // _ZN6S694C53v33Ev
  virtual void  v34(); // _ZN6S694C53v34Ev
  virtual void  v35(); // _ZN6S694C53v35Ev
  virtual void  v36(); // _ZN6S694C53v36Ev
  virtual void  v37(); // _ZN6S694C53v37Ev
  virtual void  v38(); // _ZN6S694C53v38Ev
  virtual void  v39(); // _ZN6S694C53v39Ev
  virtual void  v40(); // _ZN6S694C53v40Ev
  virtual void  v41(); // _ZN6S694C53v41Ev
  virtual void  v42(); // _ZN6S694C53v42Ev
  virtual void  v43(); // _ZN6S694C53v43Ev
  virtual void  v44(); // _ZN6S694C53v44Ev
  virtual void  v45(); // _ZN6S694C53v45Ev
  virtual void  v46(); // _ZN6S694C53v46Ev
  virtual void  v47(); // _ZN6S694C53v47Ev
  virtual void  v48(); // _ZN6S694C53v48Ev
  virtual void  v49(); // _ZN6S694C53v49Ev
  virtual void  v50(); // _ZN6S694C53v50Ev
  virtual void  v51(); // _ZN6S694C53v51Ev
  virtual void  v52(); // _ZN6S694C53v52Ev
  virtual void  v53(); // _ZN6S694C53v53Ev
  virtual void  v54(); // _ZN6S694C53v54Ev
  virtual void  v55(); // _ZN6S694C53v55Ev
  virtual void  v56(); // _ZN6S694C53v56Ev
  virtual void  v57(); // _ZN6S694C53v57Ev
  virtual void  v58(); // _ZN6S694C53v58Ev
  virtual void  v59(); // _ZN6S694C53v59Ev
  virtual void  v60(); // _ZN6S694C53v60Ev
  virtual void  v61(); // _ZN6S694C53v61Ev
  virtual void  v62(); // _ZN6S694C53v62Ev
  virtual void  v63(); // _ZN6S694C53v63Ev
  virtual void  v64(); // _ZN6S694C53v64Ev
  virtual void  v65(); // _ZN6S694C53v65Ev
  virtual void  v66(); // _ZN6S694C53v66Ev
  virtual void  v67(); // _ZN6S694C53v67Ev
  virtual void  v68(); // _ZN6S694C53v68Ev
  virtual void  v69(); // _ZN6S694C53v69Ev
  virtual void  v70(); // _ZN6S694C53v70Ev
  S694C5(); // tgen
};
//SIG(-1 S694C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S694C5 ::~S694C5(){ note_dtor("S694C5", this);}
void  S694C5 ::v7(){vfunc_called(this, "_ZN6S694C52v7Ev");}
void  S694C5 ::v8(){vfunc_called(this, "_ZN6S694C52v8Ev");}
void  S694C5 ::v9(){vfunc_called(this, "_ZN6S694C52v9Ev");}
void  S694C5 ::v10(){vfunc_called(this, "_ZN6S694C53v10Ev");}
void  S694C5 ::v11(){vfunc_called(this, "_ZN6S694C53v11Ev");}
void  S694C5 ::v12(){vfunc_called(this, "_ZN6S694C53v12Ev");}
void  S694C5 ::v13(){vfunc_called(this, "_ZN6S694C53v13Ev");}
void  S694C5 ::v14(){vfunc_called(this, "_ZN6S694C53v14Ev");}
void  S694C5 ::v15(){vfunc_called(this, "_ZN6S694C53v15Ev");}
void  S694C5 ::v16(){vfunc_called(this, "_ZN6S694C53v16Ev");}
void  S694C5 ::v17(){vfunc_called(this, "_ZN6S694C53v17Ev");}
void  S694C5 ::v18(){vfunc_called(this, "_ZN6S694C53v18Ev");}
void  S694C5 ::v19(){vfunc_called(this, "_ZN6S694C53v19Ev");}
void  S694C5 ::v20(){vfunc_called(this, "_ZN6S694C53v20Ev");}
void  S694C5 ::v21(){vfunc_called(this, "_ZN6S694C53v21Ev");}
void  S694C5 ::v22(){vfunc_called(this, "_ZN6S694C53v22Ev");}
void  S694C5 ::v23(){vfunc_called(this, "_ZN6S694C53v23Ev");}
void  S694C5 ::v24(){vfunc_called(this, "_ZN6S694C53v24Ev");}
void  S694C5 ::v25(){vfunc_called(this, "_ZN6S694C53v25Ev");}
void  S694C5 ::v26(){vfunc_called(this, "_ZN6S694C53v26Ev");}
void  S694C5 ::v27(){vfunc_called(this, "_ZN6S694C53v27Ev");}
void  S694C5 ::v28(){vfunc_called(this, "_ZN6S694C53v28Ev");}
void  S694C5 ::v29(){vfunc_called(this, "_ZN6S694C53v29Ev");}
void  S694C5 ::v30(){vfunc_called(this, "_ZN6S694C53v30Ev");}
void  S694C5 ::v31(){vfunc_called(this, "_ZN6S694C53v31Ev");}
void  S694C5 ::v32(){vfunc_called(this, "_ZN6S694C53v32Ev");}
void  S694C5 ::v33(){vfunc_called(this, "_ZN6S694C53v33Ev");}
void  S694C5 ::v34(){vfunc_called(this, "_ZN6S694C53v34Ev");}
void  S694C5 ::v35(){vfunc_called(this, "_ZN6S694C53v35Ev");}
void  S694C5 ::v36(){vfunc_called(this, "_ZN6S694C53v36Ev");}
void  S694C5 ::v37(){vfunc_called(this, "_ZN6S694C53v37Ev");}
void  S694C5 ::v38(){vfunc_called(this, "_ZN6S694C53v38Ev");}
void  S694C5 ::v39(){vfunc_called(this, "_ZN6S694C53v39Ev");}
void  S694C5 ::v40(){vfunc_called(this, "_ZN6S694C53v40Ev");}
void  S694C5 ::v41(){vfunc_called(this, "_ZN6S694C53v41Ev");}
void  S694C5 ::v42(){vfunc_called(this, "_ZN6S694C53v42Ev");}
void  S694C5 ::v43(){vfunc_called(this, "_ZN6S694C53v43Ev");}
void  S694C5 ::v44(){vfunc_called(this, "_ZN6S694C53v44Ev");}
void  S694C5 ::v45(){vfunc_called(this, "_ZN6S694C53v45Ev");}
void  S694C5 ::v46(){vfunc_called(this, "_ZN6S694C53v46Ev");}
void  S694C5 ::v47(){vfunc_called(this, "_ZN6S694C53v47Ev");}
void  S694C5 ::v48(){vfunc_called(this, "_ZN6S694C53v48Ev");}
void  S694C5 ::v49(){vfunc_called(this, "_ZN6S694C53v49Ev");}
void  S694C5 ::v50(){vfunc_called(this, "_ZN6S694C53v50Ev");}
void  S694C5 ::v51(){vfunc_called(this, "_ZN6S694C53v51Ev");}
void  S694C5 ::v52(){vfunc_called(this, "_ZN6S694C53v52Ev");}
void  S694C5 ::v53(){vfunc_called(this, "_ZN6S694C53v53Ev");}
void  S694C5 ::v54(){vfunc_called(this, "_ZN6S694C53v54Ev");}
void  S694C5 ::v55(){vfunc_called(this, "_ZN6S694C53v55Ev");}
void  S694C5 ::v56(){vfunc_called(this, "_ZN6S694C53v56Ev");}
void  S694C5 ::v57(){vfunc_called(this, "_ZN6S694C53v57Ev");}
void  S694C5 ::v58(){vfunc_called(this, "_ZN6S694C53v58Ev");}
void  S694C5 ::v59(){vfunc_called(this, "_ZN6S694C53v59Ev");}
void  S694C5 ::v60(){vfunc_called(this, "_ZN6S694C53v60Ev");}
void  S694C5 ::v61(){vfunc_called(this, "_ZN6S694C53v61Ev");}
void  S694C5 ::v62(){vfunc_called(this, "_ZN6S694C53v62Ev");}
void  S694C5 ::v63(){vfunc_called(this, "_ZN6S694C53v63Ev");}
void  S694C5 ::v64(){vfunc_called(this, "_ZN6S694C53v64Ev");}
void  S694C5 ::v65(){vfunc_called(this, "_ZN6S694C53v65Ev");}
void  S694C5 ::v66(){vfunc_called(this, "_ZN6S694C53v66Ev");}
void  S694C5 ::v67(){vfunc_called(this, "_ZN6S694C53v67Ev");}
void  S694C5 ::v68(){vfunc_called(this, "_ZN6S694C53v68Ev");}
void  S694C5 ::v69(){vfunc_called(this, "_ZN6S694C53v69Ev");}
void  S694C5 ::v70(){vfunc_called(this, "_ZN6S694C53v70Ev");}
S694C5 ::S694C5(){ note_ctor("S694C5", this);} // tgen

static void Test_S694C5()
{
  extern Class_Descriptor cd_S694C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S694C5, buf);
    S694C5 *dp, &lv = *(dp=new (buf) S694C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S694C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S694C5)");
    check_field_offset(lv, s694c5f0, ABISELECT(8,4), "S694C5.s694c5f0");
    check_field_offset(lv, s694c5f1, ABISELECT(16,8), "S694C5.s694c5f1");
    check_field_offset(lv, s694c5f2, ABISELECT(24,16), "S694C5.s694c5f2");
    check_field_offset(lv, s694c5f3, ABISELECT(56,32), "S694C5.s694c5f3");
    check_field_offset(lv, s694c5f4, ABISELECT(64,40), "S694C5.s694c5f4");
    check_field_offset(lv, s694c5f5, ABISELECT(72,44), "S694C5.s694c5f5");
    check_field_offset(lv, s694c5f6, ABISELECT(80,52), "S694C5.s694c5f6");
    test_class_info(&lv, &cd_S694C5);
    dp->~S694C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS694C5(Test_S694C5, "S694C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S694C5C1Ev();
extern void _ZN6S694C5D1Ev();
Name_Map name_map_S694C5[] = {
  NSPAIR(_ZN6S694C5C1Ev),
  NSPAIR(_ZN6S694C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S694C5[];
extern void _ZN6S694C5D1Ev();
extern void _ZN6S694C5D0Ev();
extern void _ZN6S694C52v7Ev();
extern void _ZN6S694C52v8Ev();
extern void _ZN6S694C52v9Ev();
extern void _ZN6S694C53v10Ev();
extern void _ZN6S694C53v11Ev();
extern void _ZN6S694C53v12Ev();
extern void _ZN6S694C53v13Ev();
extern void _ZN6S694C53v14Ev();
extern void _ZN6S694C53v15Ev();
extern void _ZN6S694C53v16Ev();
extern void _ZN6S694C53v17Ev();
extern void _ZN6S694C53v18Ev();
extern void _ZN6S694C53v19Ev();
extern void _ZN6S694C53v20Ev();
extern void _ZN6S694C53v21Ev();
extern void _ZN6S694C53v22Ev();
extern void _ZN6S694C53v23Ev();
extern void _ZN6S694C53v24Ev();
extern void _ZN6S694C53v25Ev();
extern void _ZN6S694C53v26Ev();
extern void _ZN6S694C53v27Ev();
extern void _ZN6S694C53v28Ev();
extern void _ZN6S694C53v29Ev();
extern void _ZN6S694C53v30Ev();
extern void _ZN6S694C53v31Ev();
extern void _ZN6S694C53v32Ev();
extern void _ZN6S694C53v33Ev();
extern void _ZN6S694C53v34Ev();
extern void _ZN6S694C53v35Ev();
extern void _ZN6S694C53v36Ev();
extern void _ZN6S694C53v37Ev();
extern void _ZN6S694C53v38Ev();
extern void _ZN6S694C53v39Ev();
extern void _ZN6S694C53v40Ev();
extern void _ZN6S694C53v41Ev();
extern void _ZN6S694C53v42Ev();
extern void _ZN6S694C53v43Ev();
extern void _ZN6S694C53v44Ev();
extern void _ZN6S694C53v45Ev();
extern void _ZN6S694C53v46Ev();
extern void _ZN6S694C53v47Ev();
extern void _ZN6S694C53v48Ev();
extern void _ZN6S694C53v49Ev();
extern void _ZN6S694C53v50Ev();
extern void _ZN6S694C53v51Ev();
extern void _ZN6S694C53v52Ev();
extern void _ZN6S694C53v53Ev();
extern void _ZN6S694C53v54Ev();
extern void _ZN6S694C53v55Ev();
extern void _ZN6S694C53v56Ev();
extern void _ZN6S694C53v57Ev();
extern void _ZN6S694C53v58Ev();
extern void _ZN6S694C53v59Ev();
extern void _ZN6S694C53v60Ev();
extern void _ZN6S694C53v61Ev();
extern void _ZN6S694C53v62Ev();
extern void _ZN6S694C53v63Ev();
extern void _ZN6S694C53v64Ev();
extern void _ZN6S694C53v65Ev();
extern void _ZN6S694C53v66Ev();
extern void _ZN6S694C53v67Ev();
extern void _ZN6S694C53v68Ev();
extern void _ZN6S694C53v69Ev();
extern void _ZN6S694C53v70Ev();
static  VTBL_ENTRY vtc_S694C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S694C5[0]),
  (VTBL_ENTRY)&_ZN6S694C5D1Ev,
  (VTBL_ENTRY)&_ZN6S694C5D0Ev,
  (VTBL_ENTRY)&_ZN6S694C52v7Ev,
  (VTBL_ENTRY)&_ZN6S694C52v8Ev,
  (VTBL_ENTRY)&_ZN6S694C52v9Ev,
  (VTBL_ENTRY)&_ZN6S694C53v10Ev,
  (VTBL_ENTRY)&_ZN6S694C53v11Ev,
  (VTBL_ENTRY)&_ZN6S694C53v12Ev,
  (VTBL_ENTRY)&_ZN6S694C53v13Ev,
  (VTBL_ENTRY)&_ZN6S694C53v14Ev,
  (VTBL_ENTRY)&_ZN6S694C53v15Ev,
  (VTBL_ENTRY)&_ZN6S694C53v16Ev,
  (VTBL_ENTRY)&_ZN6S694C53v17Ev,
  (VTBL_ENTRY)&_ZN6S694C53v18Ev,
  (VTBL_ENTRY)&_ZN6S694C53v19Ev,
  (VTBL_ENTRY)&_ZN6S694C53v20Ev,
  (VTBL_ENTRY)&_ZN6S694C53v21Ev,
  (VTBL_ENTRY)&_ZN6S694C53v22Ev,
  (VTBL_ENTRY)&_ZN6S694C53v23Ev,
  (VTBL_ENTRY)&_ZN6S694C53v24Ev,
  (VTBL_ENTRY)&_ZN6S694C53v25Ev,
  (VTBL_ENTRY)&_ZN6S694C53v26Ev,
  (VTBL_ENTRY)&_ZN6S694C53v27Ev,
  (VTBL_ENTRY)&_ZN6S694C53v28Ev,
  (VTBL_ENTRY)&_ZN6S694C53v29Ev,
  (VTBL_ENTRY)&_ZN6S694C53v30Ev,
  (VTBL_ENTRY)&_ZN6S694C53v31Ev,
  (VTBL_ENTRY)&_ZN6S694C53v32Ev,
  (VTBL_ENTRY)&_ZN6S694C53v33Ev,
  (VTBL_ENTRY)&_ZN6S694C53v34Ev,
  (VTBL_ENTRY)&_ZN6S694C53v35Ev,
  (VTBL_ENTRY)&_ZN6S694C53v36Ev,
  (VTBL_ENTRY)&_ZN6S694C53v37Ev,
  (VTBL_ENTRY)&_ZN6S694C53v38Ev,
  (VTBL_ENTRY)&_ZN6S694C53v39Ev,
  (VTBL_ENTRY)&_ZN6S694C53v40Ev,
  (VTBL_ENTRY)&_ZN6S694C53v41Ev,
  (VTBL_ENTRY)&_ZN6S694C53v42Ev,
  (VTBL_ENTRY)&_ZN6S694C53v43Ev,
  (VTBL_ENTRY)&_ZN6S694C53v44Ev,
  (VTBL_ENTRY)&_ZN6S694C53v45Ev,
  (VTBL_ENTRY)&_ZN6S694C53v46Ev,
  (VTBL_ENTRY)&_ZN6S694C53v47Ev,
  (VTBL_ENTRY)&_ZN6S694C53v48Ev,
  (VTBL_ENTRY)&_ZN6S694C53v49Ev,
  (VTBL_ENTRY)&_ZN6S694C53v50Ev,
  (VTBL_ENTRY)&_ZN6S694C53v51Ev,
  (VTBL_ENTRY)&_ZN6S694C53v52Ev,
  (VTBL_ENTRY)&_ZN6S694C53v53Ev,
  (VTBL_ENTRY)&_ZN6S694C53v54Ev,
  (VTBL_ENTRY)&_ZN6S694C53v55Ev,
  (VTBL_ENTRY)&_ZN6S694C53v56Ev,
  (VTBL_ENTRY)&_ZN6S694C53v57Ev,
  (VTBL_ENTRY)&_ZN6S694C53v58Ev,
  (VTBL_ENTRY)&_ZN6S694C53v59Ev,
  (VTBL_ENTRY)&_ZN6S694C53v60Ev,
  (VTBL_ENTRY)&_ZN6S694C53v61Ev,
  (VTBL_ENTRY)&_ZN6S694C53v62Ev,
  (VTBL_ENTRY)&_ZN6S694C53v63Ev,
  (VTBL_ENTRY)&_ZN6S694C53v64Ev,
  (VTBL_ENTRY)&_ZN6S694C53v65Ev,
  (VTBL_ENTRY)&_ZN6S694C53v66Ev,
  (VTBL_ENTRY)&_ZN6S694C53v67Ev,
  (VTBL_ENTRY)&_ZN6S694C53v68Ev,
  (VTBL_ENTRY)&_ZN6S694C53v69Ev,
  (VTBL_ENTRY)&_ZN6S694C53v70Ev,
};
extern VTBL_ENTRY _ZTI6S694C5[];
extern  VTBL_ENTRY _ZTV6S694C5[];
Class_Descriptor cd_S694C5 = {  "S694C5", // class name
  0,0,//no base classes
  &(vtc_S694C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S694C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S694C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S694C9  : S1457C8_nt {
};
//SIG(-1 S694C9) C1{ BC2{ m Fp Fi[2]}}



static void Test_S694C9()
{
  extern Class_Descriptor cd_S694C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S694C9, buf);
    S694C9 &lv = *(new (buf) S694C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S694C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S694C9)");
    check_base_class_offset(lv, (S1457C8_nt*), 0, "S694C9");
    test_class_info(&lv, &cd_S694C9);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS694C9(Test_S694C9, "S694C9", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1457C8_nt;
static Base_Class bases_S694C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1457C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S694C9 = {  "S694C9", // class name
  bases_S694C9, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S694C8  : S694C9 {
};
//SIG(-1 S694C8) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S694C8()
{
  extern Class_Descriptor cd_S694C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S694C8, buf);
    S694C8 &lv = *(new (buf) S694C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S694C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S694C8)");
    check_base_class_offset(lv, (S1457C8_nt*)(S694C9*), 0, "S694C8");
    check_base_class_offset(lv, (S694C9*), 0, "S694C8");
    test_class_info(&lv, &cd_S694C8);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS694C8(Test_S694C8, "S694C8", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1457C8_nt;
extern Class_Descriptor cd_S694C9;
static Base_Class bases_S694C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1457C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S694C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S694C8 = {  "S694C8", // class name
  bases_S694C8, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S694C7_nt  : S694C8 {
};
//SIG(-1 S694C7_nt) C1{ BC2{ BC3{ BC4{ m Fp Fi[2]}}}}



//skip512 S694C7_nt

#else // __cplusplus

extern Class_Descriptor cd_S1457C8_nt;
extern Class_Descriptor cd_S694C9;
extern Class_Descriptor cd_S694C8;
static Base_Class bases_S694C7_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1457C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S694C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S694C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S694C11_nt  {
  void  mf694c11(); // _ZN10S694C11_nt8mf694c11Ev
};
//SIG(-1 S694C11_nt) C1{ m}


void  S694C11_nt ::mf694c11(){}

//skip512 S694C11_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S694C11_nt[];
VTBL_ENTRY *P__ZTI10S694C11_nt = _ZTI10S694C11_nt; 
Class_Descriptor cd_S694C11_nt = {  "S694C11_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI10S694C11_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S694C4_nt  : S694C5 {
  int s694c4f0[2];
  void *s694c4f1;
  int s694c4f2[2];
  ::S694C7_nt s694c4f3;
  ::S694C7_nt s694c4f4;
  ::S694C11_nt s694c4f5;
  ::S694C7_nt s694c4f6;
  unsigned int s694c4f7:1;
  unsigned int s694c4f8:1;
  unsigned int s694c4f9:1;
  unsigned int s694c4f10:1;
  unsigned int s694c4f11:1;
  int s694c4f12[2];
  virtual  ~S694C4_nt(); // _ZN9S694C4_ntD1Ev
  virtual void  v71(); // _ZN9S694C4_nt3v71Ev
  virtual void  v72(); // _ZN9S694C4_nt3v72Ev
  virtual void  v73(); // _ZN9S694C4_nt3v73Ev
  virtual void  v74(); // _ZN9S694C4_nt3v74Ev
  virtual void  v75(); // _ZN9S694C4_nt3v75Ev
  virtual void  v76(); // _ZN9S694C4_nt3v76Ev
  virtual void  v77(); // _ZN9S694C4_nt3v77Ev
  virtual void  v78(); // _ZN9S694C4_nt3v78Ev
  virtual void  v79(); // _ZN9S694C4_nt3v79Ev
  virtual void  v80(); // _ZN9S694C4_nt3v80Ev
  virtual void  v81(); // _ZN9S694C4_nt3v81Ev
  virtual void  v82(); // _ZN9S694C4_nt3v82Ev
  virtual void  v83(); // _ZN9S694C4_nt3v83Ev
  virtual void  v84(); // _ZN9S694C4_nt3v84Ev
  virtual void  v85(); // _ZN9S694C4_nt3v85Ev
  virtual void  v86(); // _ZN9S694C4_nt3v86Ev
  virtual void  v87(); // _ZN9S694C4_nt3v87Ev
  virtual void  v88(); // _ZN9S694C4_nt3v88Ev
  virtual void  v89(); // _ZN9S694C4_nt3v89Ev
  virtual void  v90(); // _ZN9S694C4_nt3v90Ev
  virtual void  v91(); // _ZN9S694C4_nt3v91Ev
  virtual void  v92(); // _ZN9S694C4_nt3v92Ev
  S694C4_nt(); // tgen
};
//SIG(-1 S694C4_nt) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S694C4_nt ::~S694C4_nt(){ note_dtor("S694C4_nt", this);}
void  S694C4_nt ::v71(){vfunc_called(this, "_ZN9S694C4_nt3v71Ev");}
void  S694C4_nt ::v72(){vfunc_called(this, "_ZN9S694C4_nt3v72Ev");}
void  S694C4_nt ::v73(){vfunc_called(this, "_ZN9S694C4_nt3v73Ev");}
void  S694C4_nt ::v74(){vfunc_called(this, "_ZN9S694C4_nt3v74Ev");}
void  S694C4_nt ::v75(){vfunc_called(this, "_ZN9S694C4_nt3v75Ev");}
void  S694C4_nt ::v76(){vfunc_called(this, "_ZN9S694C4_nt3v76Ev");}
void  S694C4_nt ::v77(){vfunc_called(this, "_ZN9S694C4_nt3v77Ev");}
void  S694C4_nt ::v78(){vfunc_called(this, "_ZN9S694C4_nt3v78Ev");}
void  S694C4_nt ::v79(){vfunc_called(this, "_ZN9S694C4_nt3v79Ev");}
void  S694C4_nt ::v80(){vfunc_called(this, "_ZN9S694C4_nt3v80Ev");}
void  S694C4_nt ::v81(){vfunc_called(this, "_ZN9S694C4_nt3v81Ev");}
void  S694C4_nt ::v82(){vfunc_called(this, "_ZN9S694C4_nt3v82Ev");}
void  S694C4_nt ::v83(){vfunc_called(this, "_ZN9S694C4_nt3v83Ev");}
void  S694C4_nt ::v84(){vfunc_called(this, "_ZN9S694C4_nt3v84Ev");}
void  S694C4_nt ::v85(){vfunc_called(this, "_ZN9S694C4_nt3v85Ev");}
void  S694C4_nt ::v86(){vfunc_called(this, "_ZN9S694C4_nt3v86Ev");}
void  S694C4_nt ::v87(){vfunc_called(this, "_ZN9S694C4_nt3v87Ev");}
void  S694C4_nt ::v88(){vfunc_called(this, "_ZN9S694C4_nt3v88Ev");}
void  S694C4_nt ::v89(){vfunc_called(this, "_ZN9S694C4_nt3v89Ev");}
void  S694C4_nt ::v90(){vfunc_called(this, "_ZN9S694C4_nt3v90Ev");}
void  S694C4_nt ::v91(){vfunc_called(this, "_ZN9S694C4_nt3v91Ev");}
void  S694C4_nt ::v92(){vfunc_called(this, "_ZN9S694C4_nt3v92Ev");}
S694C4_nt ::S694C4_nt(){ note_ctor("S694C4_nt", this);} // tgen

//skip512 S694C4_nt

#else // __cplusplus

extern void _ZN9S694C4_ntC1Ev();
extern void _ZN9S694C4_ntD1Ev();
Name_Map name_map_S694C4_nt[] = {
  NSPAIR(_ZN9S694C4_ntC1Ev),
  NSPAIR(_ZN9S694C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S694C5;
extern VTBL_ENTRY _ZTI6S694C5[];
extern  VTBL_ENTRY _ZTV6S694C5[];
static Base_Class bases_S694C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S694C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S694C4_nt[];
extern void _ZN9S694C4_ntD1Ev();
extern void _ZN9S694C4_ntD0Ev();
extern void _ZN6S694C52v7Ev();
extern void _ZN6S694C52v8Ev();
extern void _ZN6S694C52v9Ev();
extern void _ZN6S694C53v10Ev();
extern void _ZN6S694C53v11Ev();
extern void _ZN6S694C53v12Ev();
extern void _ZN6S694C53v13Ev();
extern void _ZN6S694C53v14Ev();
extern void _ZN6S694C53v15Ev();
extern void _ZN6S694C53v16Ev();
extern void _ZN6S694C53v17Ev();
extern void _ZN6S694C53v18Ev();
extern void _ZN6S694C53v19Ev();
extern void _ZN6S694C53v20Ev();
extern void _ZN6S694C53v21Ev();
extern void _ZN6S694C53v22Ev();
extern void _ZN6S694C53v23Ev();
extern void _ZN6S694C53v24Ev();
extern void _ZN6S694C53v25Ev();
extern void _ZN6S694C53v26Ev();
extern void _ZN6S694C53v27Ev();
extern void _ZN6S694C53v28Ev();
extern void _ZN6S694C53v29Ev();
extern void _ZN6S694C53v30Ev();
extern void _ZN6S694C53v31Ev();
extern void _ZN6S694C53v32Ev();
extern void _ZN6S694C53v33Ev();
extern void _ZN6S694C53v34Ev();
extern void _ZN6S694C53v35Ev();
extern void _ZN6S694C53v36Ev();
extern void _ZN6S694C53v37Ev();
extern void _ZN6S694C53v38Ev();
extern void _ZN6S694C53v39Ev();
extern void _ZN6S694C53v40Ev();
extern void _ZN6S694C53v41Ev();
extern void _ZN6S694C53v42Ev();
extern void _ZN6S694C53v43Ev();
extern void _ZN6S694C53v44Ev();
extern void _ZN6S694C53v45Ev();
extern void _ZN6S694C53v46Ev();
extern void _ZN6S694C53v47Ev();
extern void _ZN6S694C53v48Ev();
extern void _ZN6S694C53v49Ev();
extern void _ZN6S694C53v50Ev();
extern void _ZN6S694C53v51Ev();
extern void _ZN6S694C53v52Ev();
extern void _ZN6S694C53v53Ev();
extern void _ZN6S694C53v54Ev();
extern void _ZN6S694C53v55Ev();
extern void _ZN6S694C53v56Ev();
extern void _ZN6S694C53v57Ev();
extern void _ZN6S694C53v58Ev();
extern void _ZN6S694C53v59Ev();
extern void _ZN6S694C53v60Ev();
extern void _ZN6S694C53v61Ev();
extern void _ZN6S694C53v62Ev();
extern void _ZN6S694C53v63Ev();
extern void _ZN6S694C53v64Ev();
extern void _ZN6S694C53v65Ev();
extern void _ZN6S694C53v66Ev();
extern void _ZN6S694C53v67Ev();
extern void _ZN6S694C53v68Ev();
extern void _ZN6S694C53v69Ev();
extern void _ZN6S694C53v70Ev();
extern void _ZN9S694C4_nt3v71Ev();
extern void _ZN9S694C4_nt3v72Ev();
extern void _ZN9S694C4_nt3v73Ev();
extern void _ZN9S694C4_nt3v74Ev();
extern void _ZN9S694C4_nt3v75Ev();
extern void _ZN9S694C4_nt3v76Ev();
extern void _ZN9S694C4_nt3v77Ev();
extern void _ZN9S694C4_nt3v78Ev();
extern void _ZN9S694C4_nt3v79Ev();
extern void _ZN9S694C4_nt3v80Ev();
extern void _ZN9S694C4_nt3v81Ev();
extern void _ZN9S694C4_nt3v82Ev();
extern void _ZN9S694C4_nt3v83Ev();
extern void _ZN9S694C4_nt3v84Ev();
extern void _ZN9S694C4_nt3v85Ev();
extern void _ZN9S694C4_nt3v86Ev();
extern void _ZN9S694C4_nt3v87Ev();
extern void _ZN9S694C4_nt3v88Ev();
extern void _ZN9S694C4_nt3v89Ev();
extern void _ZN9S694C4_nt3v90Ev();
extern void _ZN9S694C4_nt3v91Ev();
extern void _ZN9S694C4_nt3v92Ev();
static  VTBL_ENTRY vtc_S694C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S694C4_nt[0]),
  (VTBL_ENTRY)&_ZN9S694C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S694C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S694C52v7Ev,
  (VTBL_ENTRY)&_ZN6S694C52v8Ev,
  (VTBL_ENTRY)&_ZN6S694C52v9Ev,
  (VTBL_ENTRY)&_ZN6S694C53v10Ev,
  (VTBL_ENTRY)&_ZN6S694C53v11Ev,
  (VTBL_ENTRY)&_ZN6S694C53v12Ev,
  (VTBL_ENTRY)&_ZN6S694C53v13Ev,
  (VTBL_ENTRY)&_ZN6S694C53v14Ev,
  (VTBL_ENTRY)&_ZN6S694C53v15Ev,
  (VTBL_ENTRY)&_ZN6S694C53v16Ev,
  (VTBL_ENTRY)&_ZN6S694C53v17Ev,
  (VTBL_ENTRY)&_ZN6S694C53v18Ev,
  (VTBL_ENTRY)&_ZN6S694C53v19Ev,
  (VTBL_ENTRY)&_ZN6S694C53v20Ev,
  (VTBL_ENTRY)&_ZN6S694C53v21Ev,
  (VTBL_ENTRY)&_ZN6S694C53v22Ev,
  (VTBL_ENTRY)&_ZN6S694C53v23Ev,
  (VTBL_ENTRY)&_ZN6S694C53v24Ev,
  (VTBL_ENTRY)&_ZN6S694C53v25Ev,
  (VTBL_ENTRY)&_ZN6S694C53v26Ev,
  (VTBL_ENTRY)&_ZN6S694C53v27Ev,
  (VTBL_ENTRY)&_ZN6S694C53v28Ev,
  (VTBL_ENTRY)&_ZN6S694C53v29Ev,
  (VTBL_ENTRY)&_ZN6S694C53v30Ev,
  (VTBL_ENTRY)&_ZN6S694C53v31Ev,
  (VTBL_ENTRY)&_ZN6S694C53v32Ev,
  (VTBL_ENTRY)&_ZN6S694C53v33Ev,
  (VTBL_ENTRY)&_ZN6S694C53v34Ev,
  (VTBL_ENTRY)&_ZN6S694C53v35Ev,
  (VTBL_ENTRY)&_ZN6S694C53v36Ev,
  (VTBL_ENTRY)&_ZN6S694C53v37Ev,
  (VTBL_ENTRY)&_ZN6S694C53v38Ev,
  (VTBL_ENTRY)&_ZN6S694C53v39Ev,
  (VTBL_ENTRY)&_ZN6S694C53v40Ev,
  (VTBL_ENTRY)&_ZN6S694C53v41Ev,
  (VTBL_ENTRY)&_ZN6S694C53v42Ev,
  (VTBL_ENTRY)&_ZN6S694C53v43Ev,
  (VTBL_ENTRY)&_ZN6S694C53v44Ev,
  (VTBL_ENTRY)&_ZN6S694C53v45Ev,
  (VTBL_ENTRY)&_ZN6S694C53v46Ev,
  (VTBL_ENTRY)&_ZN6S694C53v47Ev,
  (VTBL_ENTRY)&_ZN6S694C53v48Ev,
  (VTBL_ENTRY)&_ZN6S694C53v49Ev,
  (VTBL_ENTRY)&_ZN6S694C53v50Ev,
  (VTBL_ENTRY)&_ZN6S694C53v51Ev,
  (VTBL_ENTRY)&_ZN6S694C53v52Ev,
  (VTBL_ENTRY)&_ZN6S694C53v53Ev,
  (VTBL_ENTRY)&_ZN6S694C53v54Ev,
  (VTBL_ENTRY)&_ZN6S694C53v55Ev,
  (VTBL_ENTRY)&_ZN6S694C53v56Ev,
  (VTBL_ENTRY)&_ZN6S694C53v57Ev,
  (VTBL_ENTRY)&_ZN6S694C53v58Ev,
  (VTBL_ENTRY)&_ZN6S694C53v59Ev,
  (VTBL_ENTRY)&_ZN6S694C53v60Ev,
  (VTBL_ENTRY)&_ZN6S694C53v61Ev,
  (VTBL_ENTRY)&_ZN6S694C53v62Ev,
  (VTBL_ENTRY)&_ZN6S694C53v63Ev,
  (VTBL_ENTRY)&_ZN6S694C53v64Ev,
  (VTBL_ENTRY)&_ZN6S694C53v65Ev,
  (VTBL_ENTRY)&_ZN6S694C53v66Ev,
  (VTBL_ENTRY)&_ZN6S694C53v67Ev,
  (VTBL_ENTRY)&_ZN6S694C53v68Ev,
  (VTBL_ENTRY)&_ZN6S694C53v69Ev,
  (VTBL_ENTRY)&_ZN6S694C53v70Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v92Ev,
};
extern VTBL_ENTRY _ZTI9S694C4_nt[];
VTBL_ENTRY *P__ZTI9S694C4_nt = _ZTI9S694C4_nt; 
extern  VTBL_ENTRY _ZTV9S694C4_nt[];
Class_Descriptor cd_S694C4_nt = {  "S694C4_nt", // class name
  bases_S694C4_nt, 1,
  &(vtc_S694C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI9S694C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S694C4_nt),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S694C3_nt  : S694C4_nt {
  unsigned int s694c3f0:1;
  unsigned int s694c3f1:1;
  unsigned int s694c3f2:1;
  ::S1457C22 s694c3f3;
  ::S1457C18 s694c3f4;
  ::S1457C12 s694c3f5;
  ::S1457C6_nt s694c3f6;
  int s694c3f7[3];
  virtual  ~S694C3_nt(); // _ZN9S694C3_ntD1Ev
  virtual void  v93(); // _ZN9S694C3_nt3v93Ev
  virtual void  v94(); // _ZN9S694C3_nt3v94Ev
  virtual void  v95(); // _ZN9S694C3_nt3v95Ev
  virtual void  v96(); // _ZN9S694C3_nt3v96Ev
  virtual void  v97(); // _ZN9S694C3_nt3v97Ev
  virtual void  v98(); // _ZN9S694C3_nt3v98Ev
  virtual void  v99(); // _ZN9S694C3_nt3v99Ev
  virtual void  v100(); // _ZN9S694C3_nt4v100Ev
  virtual void  v101(); // _ZN9S694C3_nt4v101Ev
  virtual void  v102(); // _ZN9S694C3_nt4v102Ev
  virtual void  v103(); // _ZN9S694C3_nt4v103Ev
  virtual void  v104(); // _ZN9S694C3_nt4v104Ev
  virtual void  v105(); // _ZN9S694C3_nt4v105Ev
  virtual void  v106(); // _ZN9S694C3_nt4v106Ev
  virtual void  v107(); // _ZN9S694C3_nt4v107Ev
  virtual void  v108(); // _ZN9S694C3_nt4v108Ev
  virtual void  v109(); // _ZN9S694C3_nt4v109Ev
  virtual void  v110(); // _ZN9S694C3_nt4v110Ev
  virtual void  v111(); // _ZN9S694C3_nt4v111Ev
  virtual void  v112(); // _ZN9S694C3_nt4v112Ev
  S694C3_nt(); // tgen
};
//SIG(-1 S694C3_nt) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} FC16{ BC17{ BC8}} Fi[3]}


 S694C3_nt ::~S694C3_nt(){ note_dtor("S694C3_nt", this);}
void  S694C3_nt ::v93(){vfunc_called(this, "_ZN9S694C3_nt3v93Ev");}
void  S694C3_nt ::v94(){vfunc_called(this, "_ZN9S694C3_nt3v94Ev");}
void  S694C3_nt ::v95(){vfunc_called(this, "_ZN9S694C3_nt3v95Ev");}
void  S694C3_nt ::v96(){vfunc_called(this, "_ZN9S694C3_nt3v96Ev");}
void  S694C3_nt ::v97(){vfunc_called(this, "_ZN9S694C3_nt3v97Ev");}
void  S694C3_nt ::v98(){vfunc_called(this, "_ZN9S694C3_nt3v98Ev");}
void  S694C3_nt ::v99(){vfunc_called(this, "_ZN9S694C3_nt3v99Ev");}
void  S694C3_nt ::v100(){vfunc_called(this, "_ZN9S694C3_nt4v100Ev");}
void  S694C3_nt ::v101(){vfunc_called(this, "_ZN9S694C3_nt4v101Ev");}
void  S694C3_nt ::v102(){vfunc_called(this, "_ZN9S694C3_nt4v102Ev");}
void  S694C3_nt ::v103(){vfunc_called(this, "_ZN9S694C3_nt4v103Ev");}
void  S694C3_nt ::v104(){vfunc_called(this, "_ZN9S694C3_nt4v104Ev");}
void  S694C3_nt ::v105(){vfunc_called(this, "_ZN9S694C3_nt4v105Ev");}
void  S694C3_nt ::v106(){vfunc_called(this, "_ZN9S694C3_nt4v106Ev");}
void  S694C3_nt ::v107(){vfunc_called(this, "_ZN9S694C3_nt4v107Ev");}
void  S694C3_nt ::v108(){vfunc_called(this, "_ZN9S694C3_nt4v108Ev");}
void  S694C3_nt ::v109(){vfunc_called(this, "_ZN9S694C3_nt4v109Ev");}
void  S694C3_nt ::v110(){vfunc_called(this, "_ZN9S694C3_nt4v110Ev");}
void  S694C3_nt ::v111(){vfunc_called(this, "_ZN9S694C3_nt4v111Ev");}
void  S694C3_nt ::v112(){vfunc_called(this, "_ZN9S694C3_nt4v112Ev");}
S694C3_nt ::S694C3_nt(){ note_ctor("S694C3_nt", this);} // tgen

//skip512 S694C3_nt

#else // __cplusplus

extern void _ZN9S694C3_ntC1Ev();
extern void _ZN9S694C3_ntD1Ev();
Name_Map name_map_S694C3_nt[] = {
  NSPAIR(_ZN9S694C3_ntC1Ev),
  NSPAIR(_ZN9S694C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S694C5;
extern VTBL_ENTRY _ZTI6S694C5[];
extern  VTBL_ENTRY _ZTV6S694C5[];
extern Class_Descriptor cd_S694C4_nt;
extern VTBL_ENTRY _ZTI9S694C4_nt[];
extern  VTBL_ENTRY _ZTV9S694C4_nt[];
static Base_Class bases_S694C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S694C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S694C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S694C3_nt[];
extern void _ZN9S694C3_ntD1Ev();
extern void _ZN9S694C3_ntD0Ev();
extern void _ZN6S694C52v7Ev();
extern void _ZN6S694C52v8Ev();
extern void _ZN6S694C52v9Ev();
extern void _ZN6S694C53v10Ev();
extern void _ZN6S694C53v11Ev();
extern void _ZN6S694C53v12Ev();
extern void _ZN6S694C53v13Ev();
extern void _ZN6S694C53v14Ev();
extern void _ZN6S694C53v15Ev();
extern void _ZN6S694C53v16Ev();
extern void _ZN6S694C53v17Ev();
extern void _ZN6S694C53v18Ev();
extern void _ZN6S694C53v19Ev();
extern void _ZN6S694C53v20Ev();
extern void _ZN6S694C53v21Ev();
extern void _ZN6S694C53v22Ev();
extern void _ZN6S694C53v23Ev();
extern void _ZN6S694C53v24Ev();
extern void _ZN6S694C53v25Ev();
extern void _ZN6S694C53v26Ev();
extern void _ZN6S694C53v27Ev();
extern void _ZN6S694C53v28Ev();
extern void _ZN6S694C53v29Ev();
extern void _ZN6S694C53v30Ev();
extern void _ZN6S694C53v31Ev();
extern void _ZN6S694C53v32Ev();
extern void _ZN6S694C53v33Ev();
extern void _ZN6S694C53v34Ev();
extern void _ZN6S694C53v35Ev();
extern void _ZN6S694C53v36Ev();
extern void _ZN6S694C53v37Ev();
extern void _ZN6S694C53v38Ev();
extern void _ZN6S694C53v39Ev();
extern void _ZN6S694C53v40Ev();
extern void _ZN6S694C53v41Ev();
extern void _ZN6S694C53v42Ev();
extern void _ZN6S694C53v43Ev();
extern void _ZN6S694C53v44Ev();
extern void _ZN6S694C53v45Ev();
extern void _ZN6S694C53v46Ev();
extern void _ZN6S694C53v47Ev();
extern void _ZN6S694C53v48Ev();
extern void _ZN6S694C53v49Ev();
extern void _ZN6S694C53v50Ev();
extern void _ZN6S694C53v51Ev();
extern void _ZN6S694C53v52Ev();
extern void _ZN6S694C53v53Ev();
extern void _ZN6S694C53v54Ev();
extern void _ZN6S694C53v55Ev();
extern void _ZN6S694C53v56Ev();
extern void _ZN6S694C53v57Ev();
extern void _ZN6S694C53v58Ev();
extern void _ZN6S694C53v59Ev();
extern void _ZN6S694C53v60Ev();
extern void _ZN6S694C53v61Ev();
extern void _ZN6S694C53v62Ev();
extern void _ZN6S694C53v63Ev();
extern void _ZN6S694C53v64Ev();
extern void _ZN6S694C53v65Ev();
extern void _ZN6S694C53v66Ev();
extern void _ZN6S694C53v67Ev();
extern void _ZN6S694C53v68Ev();
extern void _ZN6S694C53v69Ev();
extern void _ZN6S694C53v70Ev();
extern void _ZN9S694C4_nt3v71Ev();
extern void _ZN9S694C4_nt3v72Ev();
extern void _ZN9S694C4_nt3v73Ev();
extern void _ZN9S694C4_nt3v74Ev();
extern void _ZN9S694C4_nt3v75Ev();
extern void _ZN9S694C4_nt3v76Ev();
extern void _ZN9S694C4_nt3v77Ev();
extern void _ZN9S694C4_nt3v78Ev();
extern void _ZN9S694C4_nt3v79Ev();
extern void _ZN9S694C4_nt3v80Ev();
extern void _ZN9S694C4_nt3v81Ev();
extern void _ZN9S694C4_nt3v82Ev();
extern void _ZN9S694C4_nt3v83Ev();
extern void _ZN9S694C4_nt3v84Ev();
extern void _ZN9S694C4_nt3v85Ev();
extern void _ZN9S694C4_nt3v86Ev();
extern void _ZN9S694C4_nt3v87Ev();
extern void _ZN9S694C4_nt3v88Ev();
extern void _ZN9S694C4_nt3v89Ev();
extern void _ZN9S694C4_nt3v90Ev();
extern void _ZN9S694C4_nt3v91Ev();
extern void _ZN9S694C4_nt3v92Ev();
extern void _ZN9S694C3_nt3v93Ev();
extern void _ZN9S694C3_nt3v94Ev();
extern void _ZN9S694C3_nt3v95Ev();
extern void _ZN9S694C3_nt3v96Ev();
extern void _ZN9S694C3_nt3v97Ev();
extern void _ZN9S694C3_nt3v98Ev();
extern void _ZN9S694C3_nt3v99Ev();
extern void _ZN9S694C3_nt4v100Ev();
extern void _ZN9S694C3_nt4v101Ev();
extern void _ZN9S694C3_nt4v102Ev();
extern void _ZN9S694C3_nt4v103Ev();
extern void _ZN9S694C3_nt4v104Ev();
extern void _ZN9S694C3_nt4v105Ev();
extern void _ZN9S694C3_nt4v106Ev();
extern void _ZN9S694C3_nt4v107Ev();
extern void _ZN9S694C3_nt4v108Ev();
extern void _ZN9S694C3_nt4v109Ev();
extern void _ZN9S694C3_nt4v110Ev();
extern void _ZN9S694C3_nt4v111Ev();
extern void _ZN9S694C3_nt4v112Ev();
static  VTBL_ENTRY vtc_S694C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S694C3_nt[0]),
  (VTBL_ENTRY)&_ZN9S694C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S694C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S694C52v7Ev,
  (VTBL_ENTRY)&_ZN6S694C52v8Ev,
  (VTBL_ENTRY)&_ZN6S694C52v9Ev,
  (VTBL_ENTRY)&_ZN6S694C53v10Ev,
  (VTBL_ENTRY)&_ZN6S694C53v11Ev,
  (VTBL_ENTRY)&_ZN6S694C53v12Ev,
  (VTBL_ENTRY)&_ZN6S694C53v13Ev,
  (VTBL_ENTRY)&_ZN6S694C53v14Ev,
  (VTBL_ENTRY)&_ZN6S694C53v15Ev,
  (VTBL_ENTRY)&_ZN6S694C53v16Ev,
  (VTBL_ENTRY)&_ZN6S694C53v17Ev,
  (VTBL_ENTRY)&_ZN6S694C53v18Ev,
  (VTBL_ENTRY)&_ZN6S694C53v19Ev,
  (VTBL_ENTRY)&_ZN6S694C53v20Ev,
  (VTBL_ENTRY)&_ZN6S694C53v21Ev,
  (VTBL_ENTRY)&_ZN6S694C53v22Ev,
  (VTBL_ENTRY)&_ZN6S694C53v23Ev,
  (VTBL_ENTRY)&_ZN6S694C53v24Ev,
  (VTBL_ENTRY)&_ZN6S694C53v25Ev,
  (VTBL_ENTRY)&_ZN6S694C53v26Ev,
  (VTBL_ENTRY)&_ZN6S694C53v27Ev,
  (VTBL_ENTRY)&_ZN6S694C53v28Ev,
  (VTBL_ENTRY)&_ZN6S694C53v29Ev,
  (VTBL_ENTRY)&_ZN6S694C53v30Ev,
  (VTBL_ENTRY)&_ZN6S694C53v31Ev,
  (VTBL_ENTRY)&_ZN6S694C53v32Ev,
  (VTBL_ENTRY)&_ZN6S694C53v33Ev,
  (VTBL_ENTRY)&_ZN6S694C53v34Ev,
  (VTBL_ENTRY)&_ZN6S694C53v35Ev,
  (VTBL_ENTRY)&_ZN6S694C53v36Ev,
  (VTBL_ENTRY)&_ZN6S694C53v37Ev,
  (VTBL_ENTRY)&_ZN6S694C53v38Ev,
  (VTBL_ENTRY)&_ZN6S694C53v39Ev,
  (VTBL_ENTRY)&_ZN6S694C53v40Ev,
  (VTBL_ENTRY)&_ZN6S694C53v41Ev,
  (VTBL_ENTRY)&_ZN6S694C53v42Ev,
  (VTBL_ENTRY)&_ZN6S694C53v43Ev,
  (VTBL_ENTRY)&_ZN6S694C53v44Ev,
  (VTBL_ENTRY)&_ZN6S694C53v45Ev,
  (VTBL_ENTRY)&_ZN6S694C53v46Ev,
  (VTBL_ENTRY)&_ZN6S694C53v47Ev,
  (VTBL_ENTRY)&_ZN6S694C53v48Ev,
  (VTBL_ENTRY)&_ZN6S694C53v49Ev,
  (VTBL_ENTRY)&_ZN6S694C53v50Ev,
  (VTBL_ENTRY)&_ZN6S694C53v51Ev,
  (VTBL_ENTRY)&_ZN6S694C53v52Ev,
  (VTBL_ENTRY)&_ZN6S694C53v53Ev,
  (VTBL_ENTRY)&_ZN6S694C53v54Ev,
  (VTBL_ENTRY)&_ZN6S694C53v55Ev,
  (VTBL_ENTRY)&_ZN6S694C53v56Ev,
  (VTBL_ENTRY)&_ZN6S694C53v57Ev,
  (VTBL_ENTRY)&_ZN6S694C53v58Ev,
  (VTBL_ENTRY)&_ZN6S694C53v59Ev,
  (VTBL_ENTRY)&_ZN6S694C53v60Ev,
  (VTBL_ENTRY)&_ZN6S694C53v61Ev,
  (VTBL_ENTRY)&_ZN6S694C53v62Ev,
  (VTBL_ENTRY)&_ZN6S694C53v63Ev,
  (VTBL_ENTRY)&_ZN6S694C53v64Ev,
  (VTBL_ENTRY)&_ZN6S694C53v65Ev,
  (VTBL_ENTRY)&_ZN6S694C53v66Ev,
  (VTBL_ENTRY)&_ZN6S694C53v67Ev,
  (VTBL_ENTRY)&_ZN6S694C53v68Ev,
  (VTBL_ENTRY)&_ZN6S694C53v69Ev,
  (VTBL_ENTRY)&_ZN6S694C53v70Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v112Ev,
};
extern VTBL_ENTRY _ZTI9S694C3_nt[];
VTBL_ENTRY *P__ZTI9S694C3_nt = _ZTI9S694C3_nt; 
extern  VTBL_ENTRY _ZTV9S694C3_nt[];
Class_Descriptor cd_S694C3_nt = {  "S694C3_nt", // class name
  bases_S694C3_nt, 2,
  &(vtc_S694C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI9S694C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S694C3_nt),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S694C2_nt  : S694C3_nt {
  ::S1457C5_nt s694c2f0;
  unsigned int s694c2f1:1;
  ::S1412C18_nt s694c2f2;
  virtual  ~S694C2_nt(); // _ZN9S694C2_ntD1Ev
  virtual void  v113(); // _ZN9S694C2_nt4v113Ev
  virtual void  v114(); // _ZN9S694C2_nt4v114Ev
  virtual void  v115(); // _ZN9S694C2_nt4v115Ev
  virtual void  v116(); // _ZN9S694C2_nt4v116Ev
  S694C2_nt(); // tgen
};
//SIG(-1 S694C2_nt) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} FC17{ BC18{ BC9}} Fi[3]} vd v1 v2 v3 v4 FC5 Fi:1 FC19{ BC20{ BC9}}}


 S694C2_nt ::~S694C2_nt(){ note_dtor("S694C2_nt", this);}
void  S694C2_nt ::v113(){vfunc_called(this, "_ZN9S694C2_nt4v113Ev");}
void  S694C2_nt ::v114(){vfunc_called(this, "_ZN9S694C2_nt4v114Ev");}
void  S694C2_nt ::v115(){vfunc_called(this, "_ZN9S694C2_nt4v115Ev");}
void  S694C2_nt ::v116(){vfunc_called(this, "_ZN9S694C2_nt4v116Ev");}
S694C2_nt ::S694C2_nt(){ note_ctor("S694C2_nt", this);} // tgen

//skip512 S694C2_nt

#else // __cplusplus

extern void _ZN9S694C2_ntC1Ev();
extern void _ZN9S694C2_ntD1Ev();
Name_Map name_map_S694C2_nt[] = {
  NSPAIR(_ZN9S694C2_ntC1Ev),
  NSPAIR(_ZN9S694C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S694C5;
extern VTBL_ENTRY _ZTI6S694C5[];
extern  VTBL_ENTRY _ZTV6S694C5[];
extern Class_Descriptor cd_S694C4_nt;
extern VTBL_ENTRY _ZTI9S694C4_nt[];
extern  VTBL_ENTRY _ZTV9S694C4_nt[];
extern Class_Descriptor cd_S694C3_nt;
extern VTBL_ENTRY _ZTI9S694C3_nt[];
extern  VTBL_ENTRY _ZTV9S694C3_nt[];
static Base_Class bases_S694C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S694C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S694C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S694C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S694C2_nt[];
extern void _ZN9S694C2_ntD1Ev();
extern void _ZN9S694C2_ntD0Ev();
extern void _ZN6S694C52v7Ev();
extern void _ZN6S694C52v8Ev();
extern void _ZN6S694C52v9Ev();
extern void _ZN6S694C53v10Ev();
extern void _ZN6S694C53v11Ev();
extern void _ZN6S694C53v12Ev();
extern void _ZN6S694C53v13Ev();
extern void _ZN6S694C53v14Ev();
extern void _ZN6S694C53v15Ev();
extern void _ZN6S694C53v16Ev();
extern void _ZN6S694C53v17Ev();
extern void _ZN6S694C53v18Ev();
extern void _ZN6S694C53v19Ev();
extern void _ZN6S694C53v20Ev();
extern void _ZN6S694C53v21Ev();
extern void _ZN6S694C53v22Ev();
extern void _ZN6S694C53v23Ev();
extern void _ZN6S694C53v24Ev();
extern void _ZN6S694C53v25Ev();
extern void _ZN6S694C53v26Ev();
extern void _ZN6S694C53v27Ev();
extern void _ZN6S694C53v28Ev();
extern void _ZN6S694C53v29Ev();
extern void _ZN6S694C53v30Ev();
extern void _ZN6S694C53v31Ev();
extern void _ZN6S694C53v32Ev();
extern void _ZN6S694C53v33Ev();
extern void _ZN6S694C53v34Ev();
extern void _ZN6S694C53v35Ev();
extern void _ZN6S694C53v36Ev();
extern void _ZN6S694C53v37Ev();
extern void _ZN6S694C53v38Ev();
extern void _ZN6S694C53v39Ev();
extern void _ZN6S694C53v40Ev();
extern void _ZN6S694C53v41Ev();
extern void _ZN6S694C53v42Ev();
extern void _ZN6S694C53v43Ev();
extern void _ZN6S694C53v44Ev();
extern void _ZN6S694C53v45Ev();
extern void _ZN6S694C53v46Ev();
extern void _ZN6S694C53v47Ev();
extern void _ZN6S694C53v48Ev();
extern void _ZN6S694C53v49Ev();
extern void _ZN6S694C53v50Ev();
extern void _ZN6S694C53v51Ev();
extern void _ZN6S694C53v52Ev();
extern void _ZN6S694C53v53Ev();
extern void _ZN6S694C53v54Ev();
extern void _ZN6S694C53v55Ev();
extern void _ZN6S694C53v56Ev();
extern void _ZN6S694C53v57Ev();
extern void _ZN6S694C53v58Ev();
extern void _ZN6S694C53v59Ev();
extern void _ZN6S694C53v60Ev();
extern void _ZN6S694C53v61Ev();
extern void _ZN6S694C53v62Ev();
extern void _ZN6S694C53v63Ev();
extern void _ZN6S694C53v64Ev();
extern void _ZN6S694C53v65Ev();
extern void _ZN6S694C53v66Ev();
extern void _ZN6S694C53v67Ev();
extern void _ZN6S694C53v68Ev();
extern void _ZN6S694C53v69Ev();
extern void _ZN6S694C53v70Ev();
extern void _ZN9S694C4_nt3v71Ev();
extern void _ZN9S694C4_nt3v72Ev();
extern void _ZN9S694C4_nt3v73Ev();
extern void _ZN9S694C4_nt3v74Ev();
extern void _ZN9S694C4_nt3v75Ev();
extern void _ZN9S694C4_nt3v76Ev();
extern void _ZN9S694C4_nt3v77Ev();
extern void _ZN9S694C4_nt3v78Ev();
extern void _ZN9S694C4_nt3v79Ev();
extern void _ZN9S694C4_nt3v80Ev();
extern void _ZN9S694C4_nt3v81Ev();
extern void _ZN9S694C4_nt3v82Ev();
extern void _ZN9S694C4_nt3v83Ev();
extern void _ZN9S694C4_nt3v84Ev();
extern void _ZN9S694C4_nt3v85Ev();
extern void _ZN9S694C4_nt3v86Ev();
extern void _ZN9S694C4_nt3v87Ev();
extern void _ZN9S694C4_nt3v88Ev();
extern void _ZN9S694C4_nt3v89Ev();
extern void _ZN9S694C4_nt3v90Ev();
extern void _ZN9S694C4_nt3v91Ev();
extern void _ZN9S694C4_nt3v92Ev();
extern void _ZN9S694C3_nt3v93Ev();
extern void _ZN9S694C3_nt3v94Ev();
extern void _ZN9S694C3_nt3v95Ev();
extern void _ZN9S694C3_nt3v96Ev();
extern void _ZN9S694C3_nt3v97Ev();
extern void _ZN9S694C3_nt3v98Ev();
extern void _ZN9S694C3_nt3v99Ev();
extern void _ZN9S694C3_nt4v100Ev();
extern void _ZN9S694C3_nt4v101Ev();
extern void _ZN9S694C3_nt4v102Ev();
extern void _ZN9S694C3_nt4v103Ev();
extern void _ZN9S694C3_nt4v104Ev();
extern void _ZN9S694C3_nt4v105Ev();
extern void _ZN9S694C3_nt4v106Ev();
extern void _ZN9S694C3_nt4v107Ev();
extern void _ZN9S694C3_nt4v108Ev();
extern void _ZN9S694C3_nt4v109Ev();
extern void _ZN9S694C3_nt4v110Ev();
extern void _ZN9S694C3_nt4v111Ev();
extern void _ZN9S694C3_nt4v112Ev();
extern void _ZN9S694C2_nt4v113Ev();
extern void _ZN9S694C2_nt4v114Ev();
extern void _ZN9S694C2_nt4v115Ev();
extern void _ZN9S694C2_nt4v116Ev();
static  VTBL_ENTRY vtc_S694C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S694C2_nt[0]),
  (VTBL_ENTRY)&_ZN9S694C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S694C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S694C52v7Ev,
  (VTBL_ENTRY)&_ZN6S694C52v8Ev,
  (VTBL_ENTRY)&_ZN6S694C52v9Ev,
  (VTBL_ENTRY)&_ZN6S694C53v10Ev,
  (VTBL_ENTRY)&_ZN6S694C53v11Ev,
  (VTBL_ENTRY)&_ZN6S694C53v12Ev,
  (VTBL_ENTRY)&_ZN6S694C53v13Ev,
  (VTBL_ENTRY)&_ZN6S694C53v14Ev,
  (VTBL_ENTRY)&_ZN6S694C53v15Ev,
  (VTBL_ENTRY)&_ZN6S694C53v16Ev,
  (VTBL_ENTRY)&_ZN6S694C53v17Ev,
  (VTBL_ENTRY)&_ZN6S694C53v18Ev,
  (VTBL_ENTRY)&_ZN6S694C53v19Ev,
  (VTBL_ENTRY)&_ZN6S694C53v20Ev,
  (VTBL_ENTRY)&_ZN6S694C53v21Ev,
  (VTBL_ENTRY)&_ZN6S694C53v22Ev,
  (VTBL_ENTRY)&_ZN6S694C53v23Ev,
  (VTBL_ENTRY)&_ZN6S694C53v24Ev,
  (VTBL_ENTRY)&_ZN6S694C53v25Ev,
  (VTBL_ENTRY)&_ZN6S694C53v26Ev,
  (VTBL_ENTRY)&_ZN6S694C53v27Ev,
  (VTBL_ENTRY)&_ZN6S694C53v28Ev,
  (VTBL_ENTRY)&_ZN6S694C53v29Ev,
  (VTBL_ENTRY)&_ZN6S694C53v30Ev,
  (VTBL_ENTRY)&_ZN6S694C53v31Ev,
  (VTBL_ENTRY)&_ZN6S694C53v32Ev,
  (VTBL_ENTRY)&_ZN6S694C53v33Ev,
  (VTBL_ENTRY)&_ZN6S694C53v34Ev,
  (VTBL_ENTRY)&_ZN6S694C53v35Ev,
  (VTBL_ENTRY)&_ZN6S694C53v36Ev,
  (VTBL_ENTRY)&_ZN6S694C53v37Ev,
  (VTBL_ENTRY)&_ZN6S694C53v38Ev,
  (VTBL_ENTRY)&_ZN6S694C53v39Ev,
  (VTBL_ENTRY)&_ZN6S694C53v40Ev,
  (VTBL_ENTRY)&_ZN6S694C53v41Ev,
  (VTBL_ENTRY)&_ZN6S694C53v42Ev,
  (VTBL_ENTRY)&_ZN6S694C53v43Ev,
  (VTBL_ENTRY)&_ZN6S694C53v44Ev,
  (VTBL_ENTRY)&_ZN6S694C53v45Ev,
  (VTBL_ENTRY)&_ZN6S694C53v46Ev,
  (VTBL_ENTRY)&_ZN6S694C53v47Ev,
  (VTBL_ENTRY)&_ZN6S694C53v48Ev,
  (VTBL_ENTRY)&_ZN6S694C53v49Ev,
  (VTBL_ENTRY)&_ZN6S694C53v50Ev,
  (VTBL_ENTRY)&_ZN6S694C53v51Ev,
  (VTBL_ENTRY)&_ZN6S694C53v52Ev,
  (VTBL_ENTRY)&_ZN6S694C53v53Ev,
  (VTBL_ENTRY)&_ZN6S694C53v54Ev,
  (VTBL_ENTRY)&_ZN6S694C53v55Ev,
  (VTBL_ENTRY)&_ZN6S694C53v56Ev,
  (VTBL_ENTRY)&_ZN6S694C53v57Ev,
  (VTBL_ENTRY)&_ZN6S694C53v58Ev,
  (VTBL_ENTRY)&_ZN6S694C53v59Ev,
  (VTBL_ENTRY)&_ZN6S694C53v60Ev,
  (VTBL_ENTRY)&_ZN6S694C53v61Ev,
  (VTBL_ENTRY)&_ZN6S694C53v62Ev,
  (VTBL_ENTRY)&_ZN6S694C53v63Ev,
  (VTBL_ENTRY)&_ZN6S694C53v64Ev,
  (VTBL_ENTRY)&_ZN6S694C53v65Ev,
  (VTBL_ENTRY)&_ZN6S694C53v66Ev,
  (VTBL_ENTRY)&_ZN6S694C53v67Ev,
  (VTBL_ENTRY)&_ZN6S694C53v68Ev,
  (VTBL_ENTRY)&_ZN6S694C53v69Ev,
  (VTBL_ENTRY)&_ZN6S694C53v70Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S694C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S694C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S694C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S694C2_nt4v116Ev,
};
extern VTBL_ENTRY _ZTI9S694C2_nt[];
VTBL_ENTRY *P__ZTI9S694C2_nt = _ZTI9S694C2_nt; 
extern  VTBL_ENTRY _ZTV9S694C2_nt[];
Class_Descriptor cd_S694C2_nt = {  "S694C2_nt", // class name
  bases_S694C2_nt, 3,
  &(vtc_S694C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,220), // object size
  NSPAIRA(_ZTI9S694C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S694C2_nt),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S694C22_nt  {
  int s694c22f0[2];
  void  mf694c22(); // _ZN10S694C22_nt8mf694c22Ev
};
//SIG(-1 S694C22_nt) C1{ m Fi[2]}


void  S694C22_nt ::mf694c22(){}

//skip512 S694C22_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S694C1  : S694C2_nt {
  unsigned int s694c1f0:1;
  unsigned int s694c1f1:1;
  unsigned int s694c1f2:1;
  unsigned int s694c1f3:1;
  unsigned int s694c1f4:1;
  unsigned int s694c1f5:1;
  unsigned int s694c1f6:1;
  unsigned int s694c1f7:1;
  unsigned int s694c1f8:1;
  unsigned int s694c1f9:1;
  unsigned int s694c1f10:1;
  ::S694C22_nt s694c1f11;
  ::S694C22_nt s694c1f12;
  ::S1457C5_nt s694c1f13;
  ::S694C7_nt s694c1f14;
  int s694c1f15[3];
  virtual  ~S694C1(); // _ZN6S694C1D1Ev
  virtual void  v1(); // _ZN6S694C12v1Ev
  virtual void  v2(); // _ZN6S694C12v2Ev
  virtual void  v3(); // _ZN6S694C12v3Ev
  virtual void  v4(); // _ZN6S694C12v4Ev
  virtual void  v5(); // _ZN6S694C12v5Ev
  virtual void  v6(); // _ZN6S694C12v6Ev
  S694C1(); // tgen
};
//SIG(1 S694C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} FC18{ BC19{ BC10}} Fi[3]} vd v113 v114 v115 v116 FC6 Fi:1 FC20{ BC21{ BC10}}} vd v1 v2 v3 v4 v5 v6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC22{ m Fi[2]} FC22 FC6 FC7 Fi[3]}


 S694C1 ::~S694C1(){ note_dtor("S694C1", this);}
void  S694C1 ::v1(){vfunc_called(this, "_ZN6S694C12v1Ev");}
void  S694C1 ::v2(){vfunc_called(this, "_ZN6S694C12v2Ev");}
void  S694C1 ::v3(){vfunc_called(this, "_ZN6S694C12v3Ev");}
void  S694C1 ::v4(){vfunc_called(this, "_ZN6S694C12v4Ev");}
void  S694C1 ::v5(){vfunc_called(this, "_ZN6S694C12v5Ev");}
void  S694C1 ::v6(){vfunc_called(this, "_ZN6S694C12v6Ev");}
S694C1 ::S694C1(){ note_ctor("S694C1", this);} // tgen

static void Test_S694C1()
{
  extern Class_Descriptor cd_S694C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(46,69)];
    init_test(&cd_S694C1, buf);
    S694C1 *dp, &lv = *(dp=new (buf) S694C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(360,272), "sizeof(S694C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S694C1)");
    check_base_class_offset(lv, (S694C5*)(S694C4_nt*)(S694C3_nt*)(S694C2_nt*), 0, "S694C1");
    check_base_class_offset(lv, (S694C4_nt*)(S694C3_nt*)(S694C2_nt*), 0, "S694C1");
    check_base_class_offset(lv, (S694C3_nt*)(S694C2_nt*), 0, "S694C1");
    check_base_class_offset(lv, (S694C2_nt*), 0, "S694C1");
    set_bf_and_test(lv, s694c1f0, ABISELECT(296,220), 0, 1, 1, "S694C1");
    set_bf_and_test(lv, s694c1f1, ABISELECT(296,220), 1, 1, 1, "S694C1");
    set_bf_and_test(lv, s694c1f2, ABISELECT(296,220), 2, 1, 1, "S694C1");
    set_bf_and_test(lv, s694c1f3, ABISELECT(296,220), 3, 1, 1, "S694C1");
    set_bf_and_test(lv, s694c1f4, ABISELECT(296,220), 4, 1, 1, "S694C1");
    set_bf_and_test(lv, s694c1f5, ABISELECT(296,220), 5, 1, 1, "S694C1");
    set_bf_and_test(lv, s694c1f6, ABISELECT(296,220), 6, 1, 1, "S694C1");
    set_bf_and_test(lv, s694c1f7, ABISELECT(296,220), 7, 1, 1, "S694C1");
    set_bf_and_test(lv, s694c1f8, ABISELECT(297,221), 0, 1, 1, "S694C1");
    set_bf_and_test(lv, s694c1f9, ABISELECT(297,221), 1, 1, 1, "S694C1");
    set_bf_and_test(lv, s694c1f10, ABISELECT(297,221), 2, 1, 1, "S694C1");
    check_field_offset(lv, s694c1f11, ABISELECT(300,224), "S694C1.s694c1f11");
    check_field_offset(lv, s694c1f12, ABISELECT(308,232), "S694C1.s694c1f12");
    check_field_offset(lv, s694c1f13, ABISELECT(316,240), "S694C1.s694c1f13");
    check_field_offset(lv, s694c1f14, ABISELECT(328,248), "S694C1.s694c1f14");
    check_field_offset(lv, s694c1f15, ABISELECT(344,260), "S694C1.s694c1f15");
    test_class_info(&lv, &cd_S694C1);
    dp->~S694C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS694C1(Test_S694C1, "S694C1", ABISELECT(360,272));

#else // __cplusplus

extern void _ZN6S694C1C1Ev();
extern void _ZN6S694C1D1Ev();
Name_Map name_map_S694C1[] = {
  NSPAIR(_ZN6S694C1C1Ev),
  NSPAIR(_ZN6S694C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S694C5;
extern VTBL_ENTRY _ZTI6S694C5[];
extern  VTBL_ENTRY _ZTV6S694C5[];
extern Class_Descriptor cd_S694C4_nt;
extern VTBL_ENTRY _ZTI9S694C4_nt[];
extern  VTBL_ENTRY _ZTV9S694C4_nt[];
extern Class_Descriptor cd_S694C3_nt;
extern VTBL_ENTRY _ZTI9S694C3_nt[];
extern  VTBL_ENTRY _ZTV9S694C3_nt[];
extern Class_Descriptor cd_S694C2_nt;
extern VTBL_ENTRY _ZTI9S694C2_nt[];
extern  VTBL_ENTRY _ZTV9S694C2_nt[];
static Base_Class bases_S694C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S694C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S694C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S694C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S694C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S694C1[];
extern void _ZN6S694C1D1Ev();
extern void _ZN6S694C1D0Ev();
extern void _ZN6S694C52v7Ev();
extern void _ZN6S694C52v8Ev();
extern void _ZN6S694C52v9Ev();
extern void _ZN6S694C53v10Ev();
extern void _ZN6S694C53v11Ev();
extern void _ZN6S694C53v12Ev();
extern void _ZN6S694C53v13Ev();
extern void _ZN6S694C53v14Ev();
extern void _ZN6S694C53v15Ev();
extern void _ZN6S694C53v16Ev();
extern void _ZN6S694C53v17Ev();
extern void _ZN6S694C53v18Ev();
extern void _ZN6S694C53v19Ev();
extern void _ZN6S694C53v20Ev();
extern void _ZN6S694C53v21Ev();
extern void _ZN6S694C53v22Ev();
extern void _ZN6S694C53v23Ev();
extern void _ZN6S694C53v24Ev();
extern void _ZN6S694C53v25Ev();
extern void _ZN6S694C53v26Ev();
extern void _ZN6S694C53v27Ev();
extern void _ZN6S694C53v28Ev();
extern void _ZN6S694C53v29Ev();
extern void _ZN6S694C53v30Ev();
extern void _ZN6S694C53v31Ev();
extern void _ZN6S694C53v32Ev();
extern void _ZN6S694C53v33Ev();
extern void _ZN6S694C53v34Ev();
extern void _ZN6S694C53v35Ev();
extern void _ZN6S694C53v36Ev();
extern void _ZN6S694C53v37Ev();
extern void _ZN6S694C53v38Ev();
extern void _ZN6S694C53v39Ev();
extern void _ZN6S694C53v40Ev();
extern void _ZN6S694C53v41Ev();
extern void _ZN6S694C53v42Ev();
extern void _ZN6S694C53v43Ev();
extern void _ZN6S694C53v44Ev();
extern void _ZN6S694C53v45Ev();
extern void _ZN6S694C53v46Ev();
extern void _ZN6S694C53v47Ev();
extern void _ZN6S694C53v48Ev();
extern void _ZN6S694C53v49Ev();
extern void _ZN6S694C53v50Ev();
extern void _ZN6S694C53v51Ev();
extern void _ZN6S694C53v52Ev();
extern void _ZN6S694C53v53Ev();
extern void _ZN6S694C53v54Ev();
extern void _ZN6S694C53v55Ev();
extern void _ZN6S694C53v56Ev();
extern void _ZN6S694C53v57Ev();
extern void _ZN6S694C53v58Ev();
extern void _ZN6S694C53v59Ev();
extern void _ZN6S694C53v60Ev();
extern void _ZN6S694C53v61Ev();
extern void _ZN6S694C53v62Ev();
extern void _ZN6S694C53v63Ev();
extern void _ZN6S694C53v64Ev();
extern void _ZN6S694C53v65Ev();
extern void _ZN6S694C53v66Ev();
extern void _ZN6S694C53v67Ev();
extern void _ZN6S694C53v68Ev();
extern void _ZN6S694C53v69Ev();
extern void _ZN6S694C53v70Ev();
extern void _ZN9S694C4_nt3v71Ev();
extern void _ZN9S694C4_nt3v72Ev();
extern void _ZN9S694C4_nt3v73Ev();
extern void _ZN9S694C4_nt3v74Ev();
extern void _ZN9S694C4_nt3v75Ev();
extern void _ZN9S694C4_nt3v76Ev();
extern void _ZN9S694C4_nt3v77Ev();
extern void _ZN9S694C4_nt3v78Ev();
extern void _ZN9S694C4_nt3v79Ev();
extern void _ZN9S694C4_nt3v80Ev();
extern void _ZN9S694C4_nt3v81Ev();
extern void _ZN9S694C4_nt3v82Ev();
extern void _ZN9S694C4_nt3v83Ev();
extern void _ZN9S694C4_nt3v84Ev();
extern void _ZN9S694C4_nt3v85Ev();
extern void _ZN9S694C4_nt3v86Ev();
extern void _ZN9S694C4_nt3v87Ev();
extern void _ZN9S694C4_nt3v88Ev();
extern void _ZN9S694C4_nt3v89Ev();
extern void _ZN9S694C4_nt3v90Ev();
extern void _ZN9S694C4_nt3v91Ev();
extern void _ZN9S694C4_nt3v92Ev();
extern void _ZN9S694C3_nt3v93Ev();
extern void _ZN9S694C3_nt3v94Ev();
extern void _ZN9S694C3_nt3v95Ev();
extern void _ZN9S694C3_nt3v96Ev();
extern void _ZN9S694C3_nt3v97Ev();
extern void _ZN9S694C3_nt3v98Ev();
extern void _ZN9S694C3_nt3v99Ev();
extern void _ZN9S694C3_nt4v100Ev();
extern void _ZN9S694C3_nt4v101Ev();
extern void _ZN9S694C3_nt4v102Ev();
extern void _ZN9S694C3_nt4v103Ev();
extern void _ZN9S694C3_nt4v104Ev();
extern void _ZN9S694C3_nt4v105Ev();
extern void _ZN9S694C3_nt4v106Ev();
extern void _ZN9S694C3_nt4v107Ev();
extern void _ZN9S694C3_nt4v108Ev();
extern void _ZN9S694C3_nt4v109Ev();
extern void _ZN9S694C3_nt4v110Ev();
extern void _ZN9S694C3_nt4v111Ev();
extern void _ZN9S694C3_nt4v112Ev();
extern void _ZN9S694C2_nt4v113Ev();
extern void _ZN9S694C2_nt4v114Ev();
extern void _ZN9S694C2_nt4v115Ev();
extern void _ZN9S694C2_nt4v116Ev();
extern void _ZN6S694C12v1Ev();
extern void _ZN6S694C12v2Ev();
extern void _ZN6S694C12v3Ev();
extern void _ZN6S694C12v4Ev();
extern void _ZN6S694C12v5Ev();
extern void _ZN6S694C12v6Ev();
static  VTBL_ENTRY vtc_S694C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S694C1[0]),
  (VTBL_ENTRY)&_ZN6S694C1D1Ev,
  (VTBL_ENTRY)&_ZN6S694C1D0Ev,
  (VTBL_ENTRY)&_ZN6S694C52v7Ev,
  (VTBL_ENTRY)&_ZN6S694C52v8Ev,
  (VTBL_ENTRY)&_ZN6S694C52v9Ev,
  (VTBL_ENTRY)&_ZN6S694C53v10Ev,
  (VTBL_ENTRY)&_ZN6S694C53v11Ev,
  (VTBL_ENTRY)&_ZN6S694C53v12Ev,
  (VTBL_ENTRY)&_ZN6S694C53v13Ev,
  (VTBL_ENTRY)&_ZN6S694C53v14Ev,
  (VTBL_ENTRY)&_ZN6S694C53v15Ev,
  (VTBL_ENTRY)&_ZN6S694C53v16Ev,
  (VTBL_ENTRY)&_ZN6S694C53v17Ev,
  (VTBL_ENTRY)&_ZN6S694C53v18Ev,
  (VTBL_ENTRY)&_ZN6S694C53v19Ev,
  (VTBL_ENTRY)&_ZN6S694C53v20Ev,
  (VTBL_ENTRY)&_ZN6S694C53v21Ev,
  (VTBL_ENTRY)&_ZN6S694C53v22Ev,
  (VTBL_ENTRY)&_ZN6S694C53v23Ev,
  (VTBL_ENTRY)&_ZN6S694C53v24Ev,
  (VTBL_ENTRY)&_ZN6S694C53v25Ev,
  (VTBL_ENTRY)&_ZN6S694C53v26Ev,
  (VTBL_ENTRY)&_ZN6S694C53v27Ev,
  (VTBL_ENTRY)&_ZN6S694C53v28Ev,
  (VTBL_ENTRY)&_ZN6S694C53v29Ev,
  (VTBL_ENTRY)&_ZN6S694C53v30Ev,
  (VTBL_ENTRY)&_ZN6S694C53v31Ev,
  (VTBL_ENTRY)&_ZN6S694C53v32Ev,
  (VTBL_ENTRY)&_ZN6S694C53v33Ev,
  (VTBL_ENTRY)&_ZN6S694C53v34Ev,
  (VTBL_ENTRY)&_ZN6S694C53v35Ev,
  (VTBL_ENTRY)&_ZN6S694C53v36Ev,
  (VTBL_ENTRY)&_ZN6S694C53v37Ev,
  (VTBL_ENTRY)&_ZN6S694C53v38Ev,
  (VTBL_ENTRY)&_ZN6S694C53v39Ev,
  (VTBL_ENTRY)&_ZN6S694C53v40Ev,
  (VTBL_ENTRY)&_ZN6S694C53v41Ev,
  (VTBL_ENTRY)&_ZN6S694C53v42Ev,
  (VTBL_ENTRY)&_ZN6S694C53v43Ev,
  (VTBL_ENTRY)&_ZN6S694C53v44Ev,
  (VTBL_ENTRY)&_ZN6S694C53v45Ev,
  (VTBL_ENTRY)&_ZN6S694C53v46Ev,
  (VTBL_ENTRY)&_ZN6S694C53v47Ev,
  (VTBL_ENTRY)&_ZN6S694C53v48Ev,
  (VTBL_ENTRY)&_ZN6S694C53v49Ev,
  (VTBL_ENTRY)&_ZN6S694C53v50Ev,
  (VTBL_ENTRY)&_ZN6S694C53v51Ev,
  (VTBL_ENTRY)&_ZN6S694C53v52Ev,
  (VTBL_ENTRY)&_ZN6S694C53v53Ev,
  (VTBL_ENTRY)&_ZN6S694C53v54Ev,
  (VTBL_ENTRY)&_ZN6S694C53v55Ev,
  (VTBL_ENTRY)&_ZN6S694C53v56Ev,
  (VTBL_ENTRY)&_ZN6S694C53v57Ev,
  (VTBL_ENTRY)&_ZN6S694C53v58Ev,
  (VTBL_ENTRY)&_ZN6S694C53v59Ev,
  (VTBL_ENTRY)&_ZN6S694C53v60Ev,
  (VTBL_ENTRY)&_ZN6S694C53v61Ev,
  (VTBL_ENTRY)&_ZN6S694C53v62Ev,
  (VTBL_ENTRY)&_ZN6S694C53v63Ev,
  (VTBL_ENTRY)&_ZN6S694C53v64Ev,
  (VTBL_ENTRY)&_ZN6S694C53v65Ev,
  (VTBL_ENTRY)&_ZN6S694C53v66Ev,
  (VTBL_ENTRY)&_ZN6S694C53v67Ev,
  (VTBL_ENTRY)&_ZN6S694C53v68Ev,
  (VTBL_ENTRY)&_ZN6S694C53v69Ev,
  (VTBL_ENTRY)&_ZN6S694C53v70Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S694C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S694C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S694C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S694C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S694C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S694C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN6S694C12v1Ev,
  (VTBL_ENTRY)&_ZN6S694C12v2Ev,
  (VTBL_ENTRY)&_ZN6S694C12v3Ev,
  (VTBL_ENTRY)&_ZN6S694C12v4Ev,
  (VTBL_ENTRY)&_ZN6S694C12v5Ev,
  (VTBL_ENTRY)&_ZN6S694C12v6Ev,
};
extern VTBL_ENTRY _ZTI6S694C1[];
extern  VTBL_ENTRY _ZTV6S694C1[];
Class_Descriptor cd_S694C1 = {  "S694C1", // class name
  bases_S694C1, 4,
  &(vtc_S694C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(360,272), // object size
  NSPAIRA(_ZTI6S694C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S694C1),120, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S262C6  {
  int s262c6f0;
  __tsi64 s262c6f1;
  void *s262c6f2[4];
  int s262c6f3[2];
  void *s262c6f4;
  ::S1457C5_nt s262c6f5;
  void *s262c6f6[2];
  virtual  ~S262C6(); // _ZN6S262C6D1Ev
  virtual void  v6(); // _ZN6S262C62v6Ev
  virtual void  v7(); // _ZN6S262C62v7Ev
  virtual void  v8(); // _ZN6S262C62v8Ev
  virtual void  v9(); // _ZN6S262C62v9Ev
  virtual void  v10(); // _ZN6S262C63v10Ev
  virtual void  v11(); // _ZN6S262C63v11Ev
  virtual void  v12(); // _ZN6S262C63v12Ev
  virtual void  v13(); // _ZN6S262C63v13Ev
  virtual void  v14(); // _ZN6S262C63v14Ev
  virtual void  v15(); // _ZN6S262C63v15Ev
  virtual void  v16(); // _ZN6S262C63v16Ev
  virtual void  v17(); // _ZN6S262C63v17Ev
  virtual void  v18(); // _ZN6S262C63v18Ev
  virtual void  v19(); // _ZN6S262C63v19Ev
  virtual void  v20(); // _ZN6S262C63v20Ev
  virtual void  v21(); // _ZN6S262C63v21Ev
  virtual void  v22(); // _ZN6S262C63v22Ev
  virtual void  v23(); // _ZN6S262C63v23Ev
  virtual void  v24(); // _ZN6S262C63v24Ev
  virtual void  v25(); // _ZN6S262C63v25Ev
  virtual void  v26(); // _ZN6S262C63v26Ev
  virtual void  v27(); // _ZN6S262C63v27Ev
  virtual void  v28(); // _ZN6S262C63v28Ev
  virtual void  v29(); // _ZN6S262C63v29Ev
  virtual void  v30(); // _ZN6S262C63v30Ev
  virtual void  v31(); // _ZN6S262C63v31Ev
  virtual void  v32(); // _ZN6S262C63v32Ev
  virtual void  v33(); // _ZN6S262C63v33Ev
  virtual void  v34(); // _ZN6S262C63v34Ev
  virtual void  v35(); // _ZN6S262C63v35Ev
  virtual void  v36(); // _ZN6S262C63v36Ev
  virtual void  v37(); // _ZN6S262C63v37Ev
  virtual void  v38(); // _ZN6S262C63v38Ev
  virtual void  v39(); // _ZN6S262C63v39Ev
  virtual void  v40(); // _ZN6S262C63v40Ev
  virtual void  v41(); // _ZN6S262C63v41Ev
  virtual void  v42(); // _ZN6S262C63v42Ev
  virtual void  v43(); // _ZN6S262C63v43Ev
  virtual void  v44(); // _ZN6S262C63v44Ev
  virtual void  v45(); // _ZN6S262C63v45Ev
  virtual void  v46(); // _ZN6S262C63v46Ev
  virtual void  v47(); // _ZN6S262C63v47Ev
  virtual void  v48(); // _ZN6S262C63v48Ev
  virtual void  v49(); // _ZN6S262C63v49Ev
  virtual void  v50(); // _ZN6S262C63v50Ev
  virtual void  v51(); // _ZN6S262C63v51Ev
  virtual void  v52(); // _ZN6S262C63v52Ev
  virtual void  v53(); // _ZN6S262C63v53Ev
  virtual void  v54(); // _ZN6S262C63v54Ev
  virtual void  v55(); // _ZN6S262C63v55Ev
  virtual void  v56(); // _ZN6S262C63v56Ev
  virtual void  v57(); // _ZN6S262C63v57Ev
  virtual void  v58(); // _ZN6S262C63v58Ev
  virtual void  v59(); // _ZN6S262C63v59Ev
  virtual void  v60(); // _ZN6S262C63v60Ev
  virtual void  v61(); // _ZN6S262C63v61Ev
  virtual void  v62(); // _ZN6S262C63v62Ev
  virtual void  v63(); // _ZN6S262C63v63Ev
  virtual void  v64(); // _ZN6S262C63v64Ev
  virtual void  v65(); // _ZN6S262C63v65Ev
  virtual void  v66(); // _ZN6S262C63v66Ev
  virtual void  v67(); // _ZN6S262C63v67Ev
  virtual void  v68(); // _ZN6S262C63v68Ev
  virtual void  v69(); // _ZN6S262C63v69Ev
  S262C6(); // tgen
};
//SIG(-1 S262C6) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S262C6 ::~S262C6(){ note_dtor("S262C6", this);}
void  S262C6 ::v6(){vfunc_called(this, "_ZN6S262C62v6Ev");}
void  S262C6 ::v7(){vfunc_called(this, "_ZN6S262C62v7Ev");}
void  S262C6 ::v8(){vfunc_called(this, "_ZN6S262C62v8Ev");}
void  S262C6 ::v9(){vfunc_called(this, "_ZN6S262C62v9Ev");}
void  S262C6 ::v10(){vfunc_called(this, "_ZN6S262C63v10Ev");}
void  S262C6 ::v11(){vfunc_called(this, "_ZN6S262C63v11Ev");}
void  S262C6 ::v12(){vfunc_called(this, "_ZN6S262C63v12Ev");}
void  S262C6 ::v13(){vfunc_called(this, "_ZN6S262C63v13Ev");}
void  S262C6 ::v14(){vfunc_called(this, "_ZN6S262C63v14Ev");}
void  S262C6 ::v15(){vfunc_called(this, "_ZN6S262C63v15Ev");}
void  S262C6 ::v16(){vfunc_called(this, "_ZN6S262C63v16Ev");}
void  S262C6 ::v17(){vfunc_called(this, "_ZN6S262C63v17Ev");}
void  S262C6 ::v18(){vfunc_called(this, "_ZN6S262C63v18Ev");}
void  S262C6 ::v19(){vfunc_called(this, "_ZN6S262C63v19Ev");}
void  S262C6 ::v20(){vfunc_called(this, "_ZN6S262C63v20Ev");}
void  S262C6 ::v21(){vfunc_called(this, "_ZN6S262C63v21Ev");}
void  S262C6 ::v22(){vfunc_called(this, "_ZN6S262C63v22Ev");}
void  S262C6 ::v23(){vfunc_called(this, "_ZN6S262C63v23Ev");}
void  S262C6 ::v24(){vfunc_called(this, "_ZN6S262C63v24Ev");}
void  S262C6 ::v25(){vfunc_called(this, "_ZN6S262C63v25Ev");}
void  S262C6 ::v26(){vfunc_called(this, "_ZN6S262C63v26Ev");}
void  S262C6 ::v27(){vfunc_called(this, "_ZN6S262C63v27Ev");}
void  S262C6 ::v28(){vfunc_called(this, "_ZN6S262C63v28Ev");}
void  S262C6 ::v29(){vfunc_called(this, "_ZN6S262C63v29Ev");}
void  S262C6 ::v30(){vfunc_called(this, "_ZN6S262C63v30Ev");}
void  S262C6 ::v31(){vfunc_called(this, "_ZN6S262C63v31Ev");}
void  S262C6 ::v32(){vfunc_called(this, "_ZN6S262C63v32Ev");}
void  S262C6 ::v33(){vfunc_called(this, "_ZN6S262C63v33Ev");}
void  S262C6 ::v34(){vfunc_called(this, "_ZN6S262C63v34Ev");}
void  S262C6 ::v35(){vfunc_called(this, "_ZN6S262C63v35Ev");}
void  S262C6 ::v36(){vfunc_called(this, "_ZN6S262C63v36Ev");}
void  S262C6 ::v37(){vfunc_called(this, "_ZN6S262C63v37Ev");}
void  S262C6 ::v38(){vfunc_called(this, "_ZN6S262C63v38Ev");}
void  S262C6 ::v39(){vfunc_called(this, "_ZN6S262C63v39Ev");}
void  S262C6 ::v40(){vfunc_called(this, "_ZN6S262C63v40Ev");}
void  S262C6 ::v41(){vfunc_called(this, "_ZN6S262C63v41Ev");}
void  S262C6 ::v42(){vfunc_called(this, "_ZN6S262C63v42Ev");}
void  S262C6 ::v43(){vfunc_called(this, "_ZN6S262C63v43Ev");}
void  S262C6 ::v44(){vfunc_called(this, "_ZN6S262C63v44Ev");}
void  S262C6 ::v45(){vfunc_called(this, "_ZN6S262C63v45Ev");}
void  S262C6 ::v46(){vfunc_called(this, "_ZN6S262C63v46Ev");}
void  S262C6 ::v47(){vfunc_called(this, "_ZN6S262C63v47Ev");}
void  S262C6 ::v48(){vfunc_called(this, "_ZN6S262C63v48Ev");}
void  S262C6 ::v49(){vfunc_called(this, "_ZN6S262C63v49Ev");}
void  S262C6 ::v50(){vfunc_called(this, "_ZN6S262C63v50Ev");}
void  S262C6 ::v51(){vfunc_called(this, "_ZN6S262C63v51Ev");}
void  S262C6 ::v52(){vfunc_called(this, "_ZN6S262C63v52Ev");}
void  S262C6 ::v53(){vfunc_called(this, "_ZN6S262C63v53Ev");}
void  S262C6 ::v54(){vfunc_called(this, "_ZN6S262C63v54Ev");}
void  S262C6 ::v55(){vfunc_called(this, "_ZN6S262C63v55Ev");}
void  S262C6 ::v56(){vfunc_called(this, "_ZN6S262C63v56Ev");}
void  S262C6 ::v57(){vfunc_called(this, "_ZN6S262C63v57Ev");}
void  S262C6 ::v58(){vfunc_called(this, "_ZN6S262C63v58Ev");}
void  S262C6 ::v59(){vfunc_called(this, "_ZN6S262C63v59Ev");}
void  S262C6 ::v60(){vfunc_called(this, "_ZN6S262C63v60Ev");}
void  S262C6 ::v61(){vfunc_called(this, "_ZN6S262C63v61Ev");}
void  S262C6 ::v62(){vfunc_called(this, "_ZN6S262C63v62Ev");}
void  S262C6 ::v63(){vfunc_called(this, "_ZN6S262C63v63Ev");}
void  S262C6 ::v64(){vfunc_called(this, "_ZN6S262C63v64Ev");}
void  S262C6 ::v65(){vfunc_called(this, "_ZN6S262C63v65Ev");}
void  S262C6 ::v66(){vfunc_called(this, "_ZN6S262C63v66Ev");}
void  S262C6 ::v67(){vfunc_called(this, "_ZN6S262C63v67Ev");}
void  S262C6 ::v68(){vfunc_called(this, "_ZN6S262C63v68Ev");}
void  S262C6 ::v69(){vfunc_called(this, "_ZN6S262C63v69Ev");}
S262C6 ::S262C6(){ note_ctor("S262C6", this);} // tgen

static void Test_S262C6()
{
  extern Class_Descriptor cd_S262C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S262C6, buf);
    S262C6 *dp, &lv = *(dp=new (buf) S262C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S262C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S262C6)");
    check_field_offset(lv, s262c6f0, ABISELECT(8,4), "S262C6.s262c6f0");
    check_field_offset(lv, s262c6f1, ABISELECT(16,8), "S262C6.s262c6f1");
    check_field_offset(lv, s262c6f2, ABISELECT(24,16), "S262C6.s262c6f2");
    check_field_offset(lv, s262c6f3, ABISELECT(56,32), "S262C6.s262c6f3");
    check_field_offset(lv, s262c6f4, ABISELECT(64,40), "S262C6.s262c6f4");
    check_field_offset(lv, s262c6f5, ABISELECT(72,44), "S262C6.s262c6f5");
    check_field_offset(lv, s262c6f6, ABISELECT(80,52), "S262C6.s262c6f6");
    test_class_info(&lv, &cd_S262C6);
    dp->~S262C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS262C6(Test_S262C6, "S262C6", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S262C6C1Ev();
extern void _ZN6S262C6D1Ev();
Name_Map name_map_S262C6[] = {
  NSPAIR(_ZN6S262C6C1Ev),
  NSPAIR(_ZN6S262C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S262C6[];
extern void _ZN6S262C6D1Ev();
extern void _ZN6S262C6D0Ev();
extern void _ZN6S262C62v6Ev();
extern void _ZN6S262C62v7Ev();
extern void _ZN6S262C62v8Ev();
extern void _ZN6S262C62v9Ev();
extern void _ZN6S262C63v10Ev();
extern void _ZN6S262C63v11Ev();
extern void _ZN6S262C63v12Ev();
extern void _ZN6S262C63v13Ev();
extern void _ZN6S262C63v14Ev();
extern void _ZN6S262C63v15Ev();
extern void _ZN6S262C63v16Ev();
extern void _ZN6S262C63v17Ev();
extern void _ZN6S262C63v18Ev();
extern void _ZN6S262C63v19Ev();
extern void _ZN6S262C63v20Ev();
extern void _ZN6S262C63v21Ev();
extern void _ZN6S262C63v22Ev();
extern void _ZN6S262C63v23Ev();
extern void _ZN6S262C63v24Ev();
extern void _ZN6S262C63v25Ev();
extern void _ZN6S262C63v26Ev();
extern void _ZN6S262C63v27Ev();
extern void _ZN6S262C63v28Ev();
extern void _ZN6S262C63v29Ev();
extern void _ZN6S262C63v30Ev();
extern void _ZN6S262C63v31Ev();
extern void _ZN6S262C63v32Ev();
extern void _ZN6S262C63v33Ev();
extern void _ZN6S262C63v34Ev();
extern void _ZN6S262C63v35Ev();
extern void _ZN6S262C63v36Ev();
extern void _ZN6S262C63v37Ev();
extern void _ZN6S262C63v38Ev();
extern void _ZN6S262C63v39Ev();
extern void _ZN6S262C63v40Ev();
extern void _ZN6S262C63v41Ev();
extern void _ZN6S262C63v42Ev();
extern void _ZN6S262C63v43Ev();
extern void _ZN6S262C63v44Ev();
extern void _ZN6S262C63v45Ev();
extern void _ZN6S262C63v46Ev();
extern void _ZN6S262C63v47Ev();
extern void _ZN6S262C63v48Ev();
extern void _ZN6S262C63v49Ev();
extern void _ZN6S262C63v50Ev();
extern void _ZN6S262C63v51Ev();
extern void _ZN6S262C63v52Ev();
extern void _ZN6S262C63v53Ev();
extern void _ZN6S262C63v54Ev();
extern void _ZN6S262C63v55Ev();
extern void _ZN6S262C63v56Ev();
extern void _ZN6S262C63v57Ev();
extern void _ZN6S262C63v58Ev();
extern void _ZN6S262C63v59Ev();
extern void _ZN6S262C63v60Ev();
extern void _ZN6S262C63v61Ev();
extern void _ZN6S262C63v62Ev();
extern void _ZN6S262C63v63Ev();
extern void _ZN6S262C63v64Ev();
extern void _ZN6S262C63v65Ev();
extern void _ZN6S262C63v66Ev();
extern void _ZN6S262C63v67Ev();
extern void _ZN6S262C63v68Ev();
extern void _ZN6S262C63v69Ev();
static  VTBL_ENTRY vtc_S262C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S262C6[0]),
  (VTBL_ENTRY)&_ZN6S262C6D1Ev,
  (VTBL_ENTRY)&_ZN6S262C6D0Ev,
  (VTBL_ENTRY)&_ZN6S262C62v6Ev,
  (VTBL_ENTRY)&_ZN6S262C62v7Ev,
  (VTBL_ENTRY)&_ZN6S262C62v8Ev,
  (VTBL_ENTRY)&_ZN6S262C62v9Ev,
  (VTBL_ENTRY)&_ZN6S262C63v10Ev,
  (VTBL_ENTRY)&_ZN6S262C63v11Ev,
  (VTBL_ENTRY)&_ZN6S262C63v12Ev,
  (VTBL_ENTRY)&_ZN6S262C63v13Ev,
  (VTBL_ENTRY)&_ZN6S262C63v14Ev,
  (VTBL_ENTRY)&_ZN6S262C63v15Ev,
  (VTBL_ENTRY)&_ZN6S262C63v16Ev,
  (VTBL_ENTRY)&_ZN6S262C63v17Ev,
  (VTBL_ENTRY)&_ZN6S262C63v18Ev,
  (VTBL_ENTRY)&_ZN6S262C63v19Ev,
  (VTBL_ENTRY)&_ZN6S262C63v20Ev,
  (VTBL_ENTRY)&_ZN6S262C63v21Ev,
  (VTBL_ENTRY)&_ZN6S262C63v22Ev,
  (VTBL_ENTRY)&_ZN6S262C63v23Ev,
  (VTBL_ENTRY)&_ZN6S262C63v24Ev,
  (VTBL_ENTRY)&_ZN6S262C63v25Ev,
  (VTBL_ENTRY)&_ZN6S262C63v26Ev,
  (VTBL_ENTRY)&_ZN6S262C63v27Ev,
  (VTBL_ENTRY)&_ZN6S262C63v28Ev,
  (VTBL_ENTRY)&_ZN6S262C63v29Ev,
  (VTBL_ENTRY)&_ZN6S262C63v30Ev,
  (VTBL_ENTRY)&_ZN6S262C63v31Ev,
  (VTBL_ENTRY)&_ZN6S262C63v32Ev,
  (VTBL_ENTRY)&_ZN6S262C63v33Ev,
  (VTBL_ENTRY)&_ZN6S262C63v34Ev,
  (VTBL_ENTRY)&_ZN6S262C63v35Ev,
  (VTBL_ENTRY)&_ZN6S262C63v36Ev,
  (VTBL_ENTRY)&_ZN6S262C63v37Ev,
  (VTBL_ENTRY)&_ZN6S262C63v38Ev,
  (VTBL_ENTRY)&_ZN6S262C63v39Ev,
  (VTBL_ENTRY)&_ZN6S262C63v40Ev,
  (VTBL_ENTRY)&_ZN6S262C63v41Ev,
  (VTBL_ENTRY)&_ZN6S262C63v42Ev,
  (VTBL_ENTRY)&_ZN6S262C63v43Ev,
  (VTBL_ENTRY)&_ZN6S262C63v44Ev,
  (VTBL_ENTRY)&_ZN6S262C63v45Ev,
  (VTBL_ENTRY)&_ZN6S262C63v46Ev,
  (VTBL_ENTRY)&_ZN6S262C63v47Ev,
  (VTBL_ENTRY)&_ZN6S262C63v48Ev,
  (VTBL_ENTRY)&_ZN6S262C63v49Ev,
  (VTBL_ENTRY)&_ZN6S262C63v50Ev,
  (VTBL_ENTRY)&_ZN6S262C63v51Ev,
  (VTBL_ENTRY)&_ZN6S262C63v52Ev,
  (VTBL_ENTRY)&_ZN6S262C63v53Ev,
  (VTBL_ENTRY)&_ZN6S262C63v54Ev,
  (VTBL_ENTRY)&_ZN6S262C63v55Ev,
  (VTBL_ENTRY)&_ZN6S262C63v56Ev,
  (VTBL_ENTRY)&_ZN6S262C63v57Ev,
  (VTBL_ENTRY)&_ZN6S262C63v58Ev,
  (VTBL_ENTRY)&_ZN6S262C63v59Ev,
  (VTBL_ENTRY)&_ZN6S262C63v60Ev,
  (VTBL_ENTRY)&_ZN6S262C63v61Ev,
  (VTBL_ENTRY)&_ZN6S262C63v62Ev,
  (VTBL_ENTRY)&_ZN6S262C63v63Ev,
  (VTBL_ENTRY)&_ZN6S262C63v64Ev,
  (VTBL_ENTRY)&_ZN6S262C63v65Ev,
  (VTBL_ENTRY)&_ZN6S262C63v66Ev,
  (VTBL_ENTRY)&_ZN6S262C63v67Ev,
  (VTBL_ENTRY)&_ZN6S262C63v68Ev,
  (VTBL_ENTRY)&_ZN6S262C63v69Ev,
};
extern VTBL_ENTRY _ZTI6S262C6[];
extern  VTBL_ENTRY _ZTV6S262C6[];
Class_Descriptor cd_S262C6 = {  "S262C6", // class name
  0,0,//no base classes
  &(vtc_S262C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S262C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S262C6),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S262C5  : S262C6 {
  int s262c5f0[2];
  void *s262c5f1;
  int s262c5f2[2];
  ::S694C7_nt s262c5f3;
  ::S694C7_nt s262c5f4;
  ::S694C11_nt s262c5f5;
  ::S694C7_nt s262c5f6;
  unsigned int s262c5f7:1;
  unsigned int s262c5f8:1;
  unsigned int s262c5f9:1;
  unsigned int s262c5f10:1;
  unsigned int s262c5f11:1;
  int s262c5f12[2];
  virtual  ~S262C5(); // _ZN6S262C5D1Ev
  virtual void  v70(); // _ZN6S262C53v70Ev
  virtual void  v71(); // _ZN6S262C53v71Ev
  virtual void  v72(); // _ZN6S262C53v72Ev
  virtual void  v73(); // _ZN6S262C53v73Ev
  virtual void  v74(); // _ZN6S262C53v74Ev
  virtual void  v75(); // _ZN6S262C53v75Ev
  virtual void  v76(); // _ZN6S262C53v76Ev
  virtual void  v77(); // _ZN6S262C53v77Ev
  virtual void  v78(); // _ZN6S262C53v78Ev
  virtual void  v79(); // _ZN6S262C53v79Ev
  virtual void  v80(); // _ZN6S262C53v80Ev
  virtual void  v81(); // _ZN6S262C53v81Ev
  virtual void  v82(); // _ZN6S262C53v82Ev
  virtual void  v83(); // _ZN6S262C53v83Ev
  virtual void  v84(); // _ZN6S262C53v84Ev
  virtual void  v85(); // _ZN6S262C53v85Ev
  virtual void  v86(); // _ZN6S262C53v86Ev
  virtual void  v87(); // _ZN6S262C53v87Ev
  virtual void  v88(); // _ZN6S262C53v88Ev
  virtual void  v89(); // _ZN6S262C53v89Ev
  virtual void  v90(); // _ZN6S262C53v90Ev
  virtual void  v91(); // _ZN6S262C53v91Ev
  S262C5(); // tgen
};
//SIG(-1 S262C5) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S262C5 ::~S262C5(){ note_dtor("S262C5", this);}
void  S262C5 ::v70(){vfunc_called(this, "_ZN6S262C53v70Ev");}
void  S262C5 ::v71(){vfunc_called(this, "_ZN6S262C53v71Ev");}
void  S262C5 ::v72(){vfunc_called(this, "_ZN6S262C53v72Ev");}
void  S262C5 ::v73(){vfunc_called(this, "_ZN6S262C53v73Ev");}
void  S262C5 ::v74(){vfunc_called(this, "_ZN6S262C53v74Ev");}
void  S262C5 ::v75(){vfunc_called(this, "_ZN6S262C53v75Ev");}
void  S262C5 ::v76(){vfunc_called(this, "_ZN6S262C53v76Ev");}
void  S262C5 ::v77(){vfunc_called(this, "_ZN6S262C53v77Ev");}
void  S262C5 ::v78(){vfunc_called(this, "_ZN6S262C53v78Ev");}
void  S262C5 ::v79(){vfunc_called(this, "_ZN6S262C53v79Ev");}
void  S262C5 ::v80(){vfunc_called(this, "_ZN6S262C53v80Ev");}
void  S262C5 ::v81(){vfunc_called(this, "_ZN6S262C53v81Ev");}
void  S262C5 ::v82(){vfunc_called(this, "_ZN6S262C53v82Ev");}
void  S262C5 ::v83(){vfunc_called(this, "_ZN6S262C53v83Ev");}
void  S262C5 ::v84(){vfunc_called(this, "_ZN6S262C53v84Ev");}
void  S262C5 ::v85(){vfunc_called(this, "_ZN6S262C53v85Ev");}
void  S262C5 ::v86(){vfunc_called(this, "_ZN6S262C53v86Ev");}
void  S262C5 ::v87(){vfunc_called(this, "_ZN6S262C53v87Ev");}
void  S262C5 ::v88(){vfunc_called(this, "_ZN6S262C53v88Ev");}
void  S262C5 ::v89(){vfunc_called(this, "_ZN6S262C53v89Ev");}
void  S262C5 ::v90(){vfunc_called(this, "_ZN6S262C53v90Ev");}
void  S262C5 ::v91(){vfunc_called(this, "_ZN6S262C53v91Ev");}
S262C5 ::S262C5(){ note_ctor("S262C5", this);} // tgen

static void Test_S262C5()
{
  extern Class_Descriptor cd_S262C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S262C5, buf);
    S262C5 *dp, &lv = *(dp=new (buf) S262C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S262C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S262C5)");
    check_base_class_offset(lv, (S262C6*), 0, "S262C5");
    check_field_offset(lv, s262c5f0, ABISELECT(96,60), "S262C5.s262c5f0");
    check_field_offset(lv, s262c5f1, ABISELECT(104,68), "S262C5.s262c5f1");
    check_field_offset(lv, s262c5f2, ABISELECT(112,72), "S262C5.s262c5f2");
    check_field_offset(lv, s262c5f3, ABISELECT(120,80), "S262C5.s262c5f3");
    check_field_offset(lv, s262c5f4, ABISELECT(136,92), "S262C5.s262c5f4");
    check_field_offset(lv, s262c5f5, ABISELECT(152,104), "S262C5.s262c5f5");
    check_field_offset(lv, s262c5f6, ABISELECT(160,108), "S262C5.s262c5f6");
    set_bf_and_test(lv, s262c5f7, ABISELECT(176,120), 0, 1, 1, "S262C5");
    set_bf_and_test(lv, s262c5f8, ABISELECT(176,120), 1, 1, 1, "S262C5");
    set_bf_and_test(lv, s262c5f9, ABISELECT(176,120), 2, 1, 1, "S262C5");
    set_bf_and_test(lv, s262c5f10, ABISELECT(176,120), 3, 1, 1, "S262C5");
    set_bf_and_test(lv, s262c5f11, ABISELECT(176,120), 4, 1, 1, "S262C5");
    check_field_offset(lv, s262c5f12, ABISELECT(180,124), "S262C5.s262c5f12");
    test_class_info(&lv, &cd_S262C5);
    dp->~S262C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS262C5(Test_S262C5, "S262C5", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN6S262C5C1Ev();
extern void _ZN6S262C5D1Ev();
Name_Map name_map_S262C5[] = {
  NSPAIR(_ZN6S262C5C1Ev),
  NSPAIR(_ZN6S262C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S262C6;
extern VTBL_ENTRY _ZTI6S262C6[];
extern  VTBL_ENTRY _ZTV6S262C6[];
static Base_Class bases_S262C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S262C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S262C5[];
extern void _ZN6S262C5D1Ev();
extern void _ZN6S262C5D0Ev();
extern void _ZN6S262C62v6Ev();
extern void _ZN6S262C62v7Ev();
extern void _ZN6S262C62v8Ev();
extern void _ZN6S262C62v9Ev();
extern void _ZN6S262C63v10Ev();
extern void _ZN6S262C63v11Ev();
extern void _ZN6S262C63v12Ev();
extern void _ZN6S262C63v13Ev();
extern void _ZN6S262C63v14Ev();
extern void _ZN6S262C63v15Ev();
extern void _ZN6S262C63v16Ev();
extern void _ZN6S262C63v17Ev();
extern void _ZN6S262C63v18Ev();
extern void _ZN6S262C63v19Ev();
extern void _ZN6S262C63v20Ev();
extern void _ZN6S262C63v21Ev();
extern void _ZN6S262C63v22Ev();
extern void _ZN6S262C63v23Ev();
extern void _ZN6S262C63v24Ev();
extern void _ZN6S262C63v25Ev();
extern void _ZN6S262C63v26Ev();
extern void _ZN6S262C63v27Ev();
extern void _ZN6S262C63v28Ev();
extern void _ZN6S262C63v29Ev();
extern void _ZN6S262C63v30Ev();
extern void _ZN6S262C63v31Ev();
extern void _ZN6S262C63v32Ev();
extern void _ZN6S262C63v33Ev();
extern void _ZN6S262C63v34Ev();
extern void _ZN6S262C63v35Ev();
extern void _ZN6S262C63v36Ev();
extern void _ZN6S262C63v37Ev();
extern void _ZN6S262C63v38Ev();
extern void _ZN6S262C63v39Ev();
extern void _ZN6S262C63v40Ev();
extern void _ZN6S262C63v41Ev();
extern void _ZN6S262C63v42Ev();
extern void _ZN6S262C63v43Ev();
extern void _ZN6S262C63v44Ev();
extern void _ZN6S262C63v45Ev();
extern void _ZN6S262C63v46Ev();
extern void _ZN6S262C63v47Ev();
extern void _ZN6S262C63v48Ev();
extern void _ZN6S262C63v49Ev();
extern void _ZN6S262C63v50Ev();
extern void _ZN6S262C63v51Ev();
extern void _ZN6S262C63v52Ev();
extern void _ZN6S262C63v53Ev();
extern void _ZN6S262C63v54Ev();
extern void _ZN6S262C63v55Ev();
extern void _ZN6S262C63v56Ev();
extern void _ZN6S262C63v57Ev();
extern void _ZN6S262C63v58Ev();
extern void _ZN6S262C63v59Ev();
extern void _ZN6S262C63v60Ev();
extern void _ZN6S262C63v61Ev();
extern void _ZN6S262C63v62Ev();
extern void _ZN6S262C63v63Ev();
extern void _ZN6S262C63v64Ev();
extern void _ZN6S262C63v65Ev();
extern void _ZN6S262C63v66Ev();
extern void _ZN6S262C63v67Ev();
extern void _ZN6S262C63v68Ev();
extern void _ZN6S262C63v69Ev();
extern void _ZN6S262C53v70Ev();
extern void _ZN6S262C53v71Ev();
extern void _ZN6S262C53v72Ev();
extern void _ZN6S262C53v73Ev();
extern void _ZN6S262C53v74Ev();
extern void _ZN6S262C53v75Ev();
extern void _ZN6S262C53v76Ev();
extern void _ZN6S262C53v77Ev();
extern void _ZN6S262C53v78Ev();
extern void _ZN6S262C53v79Ev();
extern void _ZN6S262C53v80Ev();
extern void _ZN6S262C53v81Ev();
extern void _ZN6S262C53v82Ev();
extern void _ZN6S262C53v83Ev();
extern void _ZN6S262C53v84Ev();
extern void _ZN6S262C53v85Ev();
extern void _ZN6S262C53v86Ev();
extern void _ZN6S262C53v87Ev();
extern void _ZN6S262C53v88Ev();
extern void _ZN6S262C53v89Ev();
extern void _ZN6S262C53v90Ev();
extern void _ZN6S262C53v91Ev();
static  VTBL_ENTRY vtc_S262C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S262C5[0]),
  (VTBL_ENTRY)&_ZN6S262C5D1Ev,
  (VTBL_ENTRY)&_ZN6S262C5D0Ev,
  (VTBL_ENTRY)&_ZN6S262C62v6Ev,
  (VTBL_ENTRY)&_ZN6S262C62v7Ev,
  (VTBL_ENTRY)&_ZN6S262C62v8Ev,
  (VTBL_ENTRY)&_ZN6S262C62v9Ev,
  (VTBL_ENTRY)&_ZN6S262C63v10Ev,
  (VTBL_ENTRY)&_ZN6S262C63v11Ev,
  (VTBL_ENTRY)&_ZN6S262C63v12Ev,
  (VTBL_ENTRY)&_ZN6S262C63v13Ev,
  (VTBL_ENTRY)&_ZN6S262C63v14Ev,
  (VTBL_ENTRY)&_ZN6S262C63v15Ev,
  (VTBL_ENTRY)&_ZN6S262C63v16Ev,
  (VTBL_ENTRY)&_ZN6S262C63v17Ev,
  (VTBL_ENTRY)&_ZN6S262C63v18Ev,
  (VTBL_ENTRY)&_ZN6S262C63v19Ev,
  (VTBL_ENTRY)&_ZN6S262C63v20Ev,
  (VTBL_ENTRY)&_ZN6S262C63v21Ev,
  (VTBL_ENTRY)&_ZN6S262C63v22Ev,
  (VTBL_ENTRY)&_ZN6S262C63v23Ev,
  (VTBL_ENTRY)&_ZN6S262C63v24Ev,
  (VTBL_ENTRY)&_ZN6S262C63v25Ev,
  (VTBL_ENTRY)&_ZN6S262C63v26Ev,
  (VTBL_ENTRY)&_ZN6S262C63v27Ev,
  (VTBL_ENTRY)&_ZN6S262C63v28Ev,
  (VTBL_ENTRY)&_ZN6S262C63v29Ev,
  (VTBL_ENTRY)&_ZN6S262C63v30Ev,
  (VTBL_ENTRY)&_ZN6S262C63v31Ev,
  (VTBL_ENTRY)&_ZN6S262C63v32Ev,
  (VTBL_ENTRY)&_ZN6S262C63v33Ev,
  (VTBL_ENTRY)&_ZN6S262C63v34Ev,
  (VTBL_ENTRY)&_ZN6S262C63v35Ev,
  (VTBL_ENTRY)&_ZN6S262C63v36Ev,
  (VTBL_ENTRY)&_ZN6S262C63v37Ev,
  (VTBL_ENTRY)&_ZN6S262C63v38Ev,
  (VTBL_ENTRY)&_ZN6S262C63v39Ev,
  (VTBL_ENTRY)&_ZN6S262C63v40Ev,
  (VTBL_ENTRY)&_ZN6S262C63v41Ev,
  (VTBL_ENTRY)&_ZN6S262C63v42Ev,
  (VTBL_ENTRY)&_ZN6S262C63v43Ev,
  (VTBL_ENTRY)&_ZN6S262C63v44Ev,
  (VTBL_ENTRY)&_ZN6S262C63v45Ev,
  (VTBL_ENTRY)&_ZN6S262C63v46Ev,
  (VTBL_ENTRY)&_ZN6S262C63v47Ev,
  (VTBL_ENTRY)&_ZN6S262C63v48Ev,
  (VTBL_ENTRY)&_ZN6S262C63v49Ev,
  (VTBL_ENTRY)&_ZN6S262C63v50Ev,
  (VTBL_ENTRY)&_ZN6S262C63v51Ev,
  (VTBL_ENTRY)&_ZN6S262C63v52Ev,
  (VTBL_ENTRY)&_ZN6S262C63v53Ev,
  (VTBL_ENTRY)&_ZN6S262C63v54Ev,
  (VTBL_ENTRY)&_ZN6S262C63v55Ev,
  (VTBL_ENTRY)&_ZN6S262C63v56Ev,
  (VTBL_ENTRY)&_ZN6S262C63v57Ev,
  (VTBL_ENTRY)&_ZN6S262C63v58Ev,
  (VTBL_ENTRY)&_ZN6S262C63v59Ev,
  (VTBL_ENTRY)&_ZN6S262C63v60Ev,
  (VTBL_ENTRY)&_ZN6S262C63v61Ev,
  (VTBL_ENTRY)&_ZN6S262C63v62Ev,
  (VTBL_ENTRY)&_ZN6S262C63v63Ev,
  (VTBL_ENTRY)&_ZN6S262C63v64Ev,
  (VTBL_ENTRY)&_ZN6S262C63v65Ev,
  (VTBL_ENTRY)&_ZN6S262C63v66Ev,
  (VTBL_ENTRY)&_ZN6S262C63v67Ev,
  (VTBL_ENTRY)&_ZN6S262C63v68Ev,
  (VTBL_ENTRY)&_ZN6S262C63v69Ev,
  (VTBL_ENTRY)&_ZN6S262C53v70Ev,
  (VTBL_ENTRY)&_ZN6S262C53v71Ev,
  (VTBL_ENTRY)&_ZN6S262C53v72Ev,
  (VTBL_ENTRY)&_ZN6S262C53v73Ev,
  (VTBL_ENTRY)&_ZN6S262C53v74Ev,
  (VTBL_ENTRY)&_ZN6S262C53v75Ev,
  (VTBL_ENTRY)&_ZN6S262C53v76Ev,
  (VTBL_ENTRY)&_ZN6S262C53v77Ev,
  (VTBL_ENTRY)&_ZN6S262C53v78Ev,
  (VTBL_ENTRY)&_ZN6S262C53v79Ev,
  (VTBL_ENTRY)&_ZN6S262C53v80Ev,
  (VTBL_ENTRY)&_ZN6S262C53v81Ev,
  (VTBL_ENTRY)&_ZN6S262C53v82Ev,
  (VTBL_ENTRY)&_ZN6S262C53v83Ev,
  (VTBL_ENTRY)&_ZN6S262C53v84Ev,
  (VTBL_ENTRY)&_ZN6S262C53v85Ev,
  (VTBL_ENTRY)&_ZN6S262C53v86Ev,
  (VTBL_ENTRY)&_ZN6S262C53v87Ev,
  (VTBL_ENTRY)&_ZN6S262C53v88Ev,
  (VTBL_ENTRY)&_ZN6S262C53v89Ev,
  (VTBL_ENTRY)&_ZN6S262C53v90Ev,
  (VTBL_ENTRY)&_ZN6S262C53v91Ev,
};
extern VTBL_ENTRY _ZTI6S262C5[];
extern  VTBL_ENTRY _ZTV6S262C5[];
Class_Descriptor cd_S262C5 = {  "S262C5", // class name
  bases_S262C5, 1,
  &(vtc_S262C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI6S262C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S262C5),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S262C4  : S262C5 {
  unsigned int s262c4f0:1;
  unsigned int s262c4f1:1;
  unsigned int s262c4f2:1;
  ::S1457C22 s262c4f3;
  ::S1457C18 s262c4f4;
  ::S1457C12 s262c4f5;
  ::S1457C6_nt s262c4f6;
  int s262c4f7[3];
  virtual  ~S262C4(); // _ZN6S262C4D1Ev
  virtual void  v92(); // _ZN6S262C43v92Ev
  virtual void  v93(); // _ZN6S262C43v93Ev
  virtual void  v94(); // _ZN6S262C43v94Ev
  virtual void  v95(); // _ZN6S262C43v95Ev
  virtual void  v96(); // _ZN6S262C43v96Ev
  virtual void  v97(); // _ZN6S262C43v97Ev
  virtual void  v98(); // _ZN6S262C43v98Ev
  virtual void  v99(); // _ZN6S262C43v99Ev
  virtual void  v100(); // _ZN6S262C44v100Ev
  virtual void  v101(); // _ZN6S262C44v101Ev
  virtual void  v102(); // _ZN6S262C44v102Ev
  virtual void  v103(); // _ZN6S262C44v103Ev
  virtual void  v104(); // _ZN6S262C44v104Ev
  virtual void  v105(); // _ZN6S262C44v105Ev
  virtual void  v106(); // _ZN6S262C44v106Ev
  virtual void  v107(); // _ZN6S262C44v107Ev
  virtual void  v108(); // _ZN6S262C44v108Ev
  virtual void  v109(); // _ZN6S262C44v109Ev
  virtual void  v110(); // _ZN6S262C44v110Ev
  virtual void  v111(); // _ZN6S262C44v111Ev
  S262C4(); // tgen
};
//SIG(-1 S262C4) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} FC16{ BC17{ BC8}} Fi[3]}


 S262C4 ::~S262C4(){ note_dtor("S262C4", this);}
void  S262C4 ::v92(){vfunc_called(this, "_ZN6S262C43v92Ev");}
void  S262C4 ::v93(){vfunc_called(this, "_ZN6S262C43v93Ev");}
void  S262C4 ::v94(){vfunc_called(this, "_ZN6S262C43v94Ev");}
void  S262C4 ::v95(){vfunc_called(this, "_ZN6S262C43v95Ev");}
void  S262C4 ::v96(){vfunc_called(this, "_ZN6S262C43v96Ev");}
void  S262C4 ::v97(){vfunc_called(this, "_ZN6S262C43v97Ev");}
void  S262C4 ::v98(){vfunc_called(this, "_ZN6S262C43v98Ev");}
void  S262C4 ::v99(){vfunc_called(this, "_ZN6S262C43v99Ev");}
void  S262C4 ::v100(){vfunc_called(this, "_ZN6S262C44v100Ev");}
void  S262C4 ::v101(){vfunc_called(this, "_ZN6S262C44v101Ev");}
void  S262C4 ::v102(){vfunc_called(this, "_ZN6S262C44v102Ev");}
void  S262C4 ::v103(){vfunc_called(this, "_ZN6S262C44v103Ev");}
void  S262C4 ::v104(){vfunc_called(this, "_ZN6S262C44v104Ev");}
void  S262C4 ::v105(){vfunc_called(this, "_ZN6S262C44v105Ev");}
void  S262C4 ::v106(){vfunc_called(this, "_ZN6S262C44v106Ev");}
void  S262C4 ::v107(){vfunc_called(this, "_ZN6S262C44v107Ev");}
void  S262C4 ::v108(){vfunc_called(this, "_ZN6S262C44v108Ev");}
void  S262C4 ::v109(){vfunc_called(this, "_ZN6S262C44v109Ev");}
void  S262C4 ::v110(){vfunc_called(this, "_ZN6S262C44v110Ev");}
void  S262C4 ::v111(){vfunc_called(this, "_ZN6S262C44v111Ev");}
S262C4 ::S262C4(){ note_ctor("S262C4", this);} // tgen

static void Test_S262C4()
{
  extern Class_Descriptor cd_S262C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(35,50)];
    init_test(&cd_S262C4, buf);
    S262C4 *dp, &lv = *(dp=new (buf) S262C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,196), "sizeof(S262C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S262C4)");
    check_base_class_offset(lv, (S262C6*)(S262C5*), 0, "S262C4");
    check_base_class_offset(lv, (S262C5*), 0, "S262C4");
    set_bf_and_test(lv, s262c4f0, ABISELECT(188,132), 0, 1, 1, "S262C4");
    set_bf_and_test(lv, s262c4f1, ABISELECT(188,132), 1, 1, 1, "S262C4");
    set_bf_and_test(lv, s262c4f2, ABISELECT(188,132), 2, 1, 1, "S262C4");
    check_field_offset(lv, s262c4f3, ABISELECT(192,136), "S262C4.s262c4f3");
    check_field_offset(lv, s262c4f4, ABISELECT(208,148), "S262C4.s262c4f4");
    check_field_offset(lv, s262c4f5, ABISELECT(224,160), "S262C4.s262c4f5");
    check_field_offset(lv, s262c4f6, ABISELECT(240,172), "S262C4.s262c4f6");
    check_field_offset(lv, s262c4f7, ABISELECT(256,184), "S262C4.s262c4f7");
    test_class_info(&lv, &cd_S262C4);
    dp->~S262C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS262C4(Test_S262C4, "S262C4", ABISELECT(272,196));

#else // __cplusplus

extern void _ZN6S262C4C1Ev();
extern void _ZN6S262C4D1Ev();
Name_Map name_map_S262C4[] = {
  NSPAIR(_ZN6S262C4C1Ev),
  NSPAIR(_ZN6S262C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S262C6;
extern VTBL_ENTRY _ZTI6S262C6[];
extern  VTBL_ENTRY _ZTV6S262C6[];
extern Class_Descriptor cd_S262C5;
extern VTBL_ENTRY _ZTI6S262C5[];
extern  VTBL_ENTRY _ZTV6S262C5[];
static Base_Class bases_S262C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S262C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S262C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S262C4[];
extern void _ZN6S262C4D1Ev();
extern void _ZN6S262C4D0Ev();
extern void _ZN6S262C62v6Ev();
extern void _ZN6S262C62v7Ev();
extern void _ZN6S262C62v8Ev();
extern void _ZN6S262C62v9Ev();
extern void _ZN6S262C63v10Ev();
extern void _ZN6S262C63v11Ev();
extern void _ZN6S262C63v12Ev();
extern void _ZN6S262C63v13Ev();
extern void _ZN6S262C63v14Ev();
extern void _ZN6S262C63v15Ev();
extern void _ZN6S262C63v16Ev();
extern void _ZN6S262C63v17Ev();
extern void _ZN6S262C63v18Ev();
extern void _ZN6S262C63v19Ev();
extern void _ZN6S262C63v20Ev();
extern void _ZN6S262C63v21Ev();
extern void _ZN6S262C63v22Ev();
extern void _ZN6S262C63v23Ev();
extern void _ZN6S262C63v24Ev();
extern void _ZN6S262C63v25Ev();
extern void _ZN6S262C63v26Ev();
extern void _ZN6S262C63v27Ev();
extern void _ZN6S262C63v28Ev();
extern void _ZN6S262C63v29Ev();
extern void _ZN6S262C63v30Ev();
extern void _ZN6S262C63v31Ev();
extern void _ZN6S262C63v32Ev();
extern void _ZN6S262C63v33Ev();
extern void _ZN6S262C63v34Ev();
extern void _ZN6S262C63v35Ev();
extern void _ZN6S262C63v36Ev();
extern void _ZN6S262C63v37Ev();
extern void _ZN6S262C63v38Ev();
extern void _ZN6S262C63v39Ev();
extern void _ZN6S262C63v40Ev();
extern void _ZN6S262C63v41Ev();
extern void _ZN6S262C63v42Ev();
extern void _ZN6S262C63v43Ev();
extern void _ZN6S262C63v44Ev();
extern void _ZN6S262C63v45Ev();
extern void _ZN6S262C63v46Ev();
extern void _ZN6S262C63v47Ev();
extern void _ZN6S262C63v48Ev();
extern void _ZN6S262C63v49Ev();
extern void _ZN6S262C63v50Ev();
extern void _ZN6S262C63v51Ev();
extern void _ZN6S262C63v52Ev();
extern void _ZN6S262C63v53Ev();
extern void _ZN6S262C63v54Ev();
extern void _ZN6S262C63v55Ev();
extern void _ZN6S262C63v56Ev();
extern void _ZN6S262C63v57Ev();
extern void _ZN6S262C63v58Ev();
extern void _ZN6S262C63v59Ev();
extern void _ZN6S262C63v60Ev();
extern void _ZN6S262C63v61Ev();
extern void _ZN6S262C63v62Ev();
extern void _ZN6S262C63v63Ev();
extern void _ZN6S262C63v64Ev();
extern void _ZN6S262C63v65Ev();
extern void _ZN6S262C63v66Ev();
extern void _ZN6S262C63v67Ev();
extern void _ZN6S262C63v68Ev();
extern void _ZN6S262C63v69Ev();
extern void _ZN6S262C53v70Ev();
extern void _ZN6S262C53v71Ev();
extern void _ZN6S262C53v72Ev();
extern void _ZN6S262C53v73Ev();
extern void _ZN6S262C53v74Ev();
extern void _ZN6S262C53v75Ev();
extern void _ZN6S262C53v76Ev();
extern void _ZN6S262C53v77Ev();
extern void _ZN6S262C53v78Ev();
extern void _ZN6S262C53v79Ev();
extern void _ZN6S262C53v80Ev();
extern void _ZN6S262C53v81Ev();
extern void _ZN6S262C53v82Ev();
extern void _ZN6S262C53v83Ev();
extern void _ZN6S262C53v84Ev();
extern void _ZN6S262C53v85Ev();
extern void _ZN6S262C53v86Ev();
extern void _ZN6S262C53v87Ev();
extern void _ZN6S262C53v88Ev();
extern void _ZN6S262C53v89Ev();
extern void _ZN6S262C53v90Ev();
extern void _ZN6S262C53v91Ev();
extern void _ZN6S262C43v92Ev();
extern void _ZN6S262C43v93Ev();
extern void _ZN6S262C43v94Ev();
extern void _ZN6S262C43v95Ev();
extern void _ZN6S262C43v96Ev();
extern void _ZN6S262C43v97Ev();
extern void _ZN6S262C43v98Ev();
extern void _ZN6S262C43v99Ev();
extern void _ZN6S262C44v100Ev();
extern void _ZN6S262C44v101Ev();
extern void _ZN6S262C44v102Ev();
extern void _ZN6S262C44v103Ev();
extern void _ZN6S262C44v104Ev();
extern void _ZN6S262C44v105Ev();
extern void _ZN6S262C44v106Ev();
extern void _ZN6S262C44v107Ev();
extern void _ZN6S262C44v108Ev();
extern void _ZN6S262C44v109Ev();
extern void _ZN6S262C44v110Ev();
extern void _ZN6S262C44v111Ev();
static  VTBL_ENTRY vtc_S262C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S262C4[0]),
  (VTBL_ENTRY)&_ZN6S262C4D1Ev,
  (VTBL_ENTRY)&_ZN6S262C4D0Ev,
  (VTBL_ENTRY)&_ZN6S262C62v6Ev,
  (VTBL_ENTRY)&_ZN6S262C62v7Ev,
  (VTBL_ENTRY)&_ZN6S262C62v8Ev,
  (VTBL_ENTRY)&_ZN6S262C62v9Ev,
  (VTBL_ENTRY)&_ZN6S262C63v10Ev,
  (VTBL_ENTRY)&_ZN6S262C63v11Ev,
  (VTBL_ENTRY)&_ZN6S262C63v12Ev,
  (VTBL_ENTRY)&_ZN6S262C63v13Ev,
  (VTBL_ENTRY)&_ZN6S262C63v14Ev,
  (VTBL_ENTRY)&_ZN6S262C63v15Ev,
  (VTBL_ENTRY)&_ZN6S262C63v16Ev,
  (VTBL_ENTRY)&_ZN6S262C63v17Ev,
  (VTBL_ENTRY)&_ZN6S262C63v18Ev,
  (VTBL_ENTRY)&_ZN6S262C63v19Ev,
  (VTBL_ENTRY)&_ZN6S262C63v20Ev,
  (VTBL_ENTRY)&_ZN6S262C63v21Ev,
  (VTBL_ENTRY)&_ZN6S262C63v22Ev,
  (VTBL_ENTRY)&_ZN6S262C63v23Ev,
  (VTBL_ENTRY)&_ZN6S262C63v24Ev,
  (VTBL_ENTRY)&_ZN6S262C63v25Ev,
  (VTBL_ENTRY)&_ZN6S262C63v26Ev,
  (VTBL_ENTRY)&_ZN6S262C63v27Ev,
  (VTBL_ENTRY)&_ZN6S262C63v28Ev,
  (VTBL_ENTRY)&_ZN6S262C63v29Ev,
  (VTBL_ENTRY)&_ZN6S262C63v30Ev,
  (VTBL_ENTRY)&_ZN6S262C63v31Ev,
  (VTBL_ENTRY)&_ZN6S262C63v32Ev,
  (VTBL_ENTRY)&_ZN6S262C63v33Ev,
  (VTBL_ENTRY)&_ZN6S262C63v34Ev,
  (VTBL_ENTRY)&_ZN6S262C63v35Ev,
  (VTBL_ENTRY)&_ZN6S262C63v36Ev,
  (VTBL_ENTRY)&_ZN6S262C63v37Ev,
  (VTBL_ENTRY)&_ZN6S262C63v38Ev,
  (VTBL_ENTRY)&_ZN6S262C63v39Ev,
  (VTBL_ENTRY)&_ZN6S262C63v40Ev,
  (VTBL_ENTRY)&_ZN6S262C63v41Ev,
  (VTBL_ENTRY)&_ZN6S262C63v42Ev,
  (VTBL_ENTRY)&_ZN6S262C63v43Ev,
  (VTBL_ENTRY)&_ZN6S262C63v44Ev,
  (VTBL_ENTRY)&_ZN6S262C63v45Ev,
  (VTBL_ENTRY)&_ZN6S262C63v46Ev,
  (VTBL_ENTRY)&_ZN6S262C63v47Ev,
  (VTBL_ENTRY)&_ZN6S262C63v48Ev,
  (VTBL_ENTRY)&_ZN6S262C63v49Ev,
  (VTBL_ENTRY)&_ZN6S262C63v50Ev,
  (VTBL_ENTRY)&_ZN6S262C63v51Ev,
  (VTBL_ENTRY)&_ZN6S262C63v52Ev,
  (VTBL_ENTRY)&_ZN6S262C63v53Ev,
  (VTBL_ENTRY)&_ZN6S262C63v54Ev,
  (VTBL_ENTRY)&_ZN6S262C63v55Ev,
  (VTBL_ENTRY)&_ZN6S262C63v56Ev,
  (VTBL_ENTRY)&_ZN6S262C63v57Ev,
  (VTBL_ENTRY)&_ZN6S262C63v58Ev,
  (VTBL_ENTRY)&_ZN6S262C63v59Ev,
  (VTBL_ENTRY)&_ZN6S262C63v60Ev,
  (VTBL_ENTRY)&_ZN6S262C63v61Ev,
  (VTBL_ENTRY)&_ZN6S262C63v62Ev,
  (VTBL_ENTRY)&_ZN6S262C63v63Ev,
  (VTBL_ENTRY)&_ZN6S262C63v64Ev,
  (VTBL_ENTRY)&_ZN6S262C63v65Ev,
  (VTBL_ENTRY)&_ZN6S262C63v66Ev,
  (VTBL_ENTRY)&_ZN6S262C63v67Ev,
  (VTBL_ENTRY)&_ZN6S262C63v68Ev,
  (VTBL_ENTRY)&_ZN6S262C63v69Ev,
  (VTBL_ENTRY)&_ZN6S262C53v70Ev,
  (VTBL_ENTRY)&_ZN6S262C53v71Ev,
  (VTBL_ENTRY)&_ZN6S262C53v72Ev,
  (VTBL_ENTRY)&_ZN6S262C53v73Ev,
  (VTBL_ENTRY)&_ZN6S262C53v74Ev,
  (VTBL_ENTRY)&_ZN6S262C53v75Ev,
  (VTBL_ENTRY)&_ZN6S262C53v76Ev,
  (VTBL_ENTRY)&_ZN6S262C53v77Ev,
  (VTBL_ENTRY)&_ZN6S262C53v78Ev,
  (VTBL_ENTRY)&_ZN6S262C53v79Ev,
  (VTBL_ENTRY)&_ZN6S262C53v80Ev,
  (VTBL_ENTRY)&_ZN6S262C53v81Ev,
  (VTBL_ENTRY)&_ZN6S262C53v82Ev,
  (VTBL_ENTRY)&_ZN6S262C53v83Ev,
  (VTBL_ENTRY)&_ZN6S262C53v84Ev,
  (VTBL_ENTRY)&_ZN6S262C53v85Ev,
  (VTBL_ENTRY)&_ZN6S262C53v86Ev,
  (VTBL_ENTRY)&_ZN6S262C53v87Ev,
  (VTBL_ENTRY)&_ZN6S262C53v88Ev,
  (VTBL_ENTRY)&_ZN6S262C53v89Ev,
  (VTBL_ENTRY)&_ZN6S262C53v90Ev,
  (VTBL_ENTRY)&_ZN6S262C53v91Ev,
  (VTBL_ENTRY)&_ZN6S262C43v92Ev,
  (VTBL_ENTRY)&_ZN6S262C43v93Ev,
  (VTBL_ENTRY)&_ZN6S262C43v94Ev,
  (VTBL_ENTRY)&_ZN6S262C43v95Ev,
  (VTBL_ENTRY)&_ZN6S262C43v96Ev,
  (VTBL_ENTRY)&_ZN6S262C43v97Ev,
  (VTBL_ENTRY)&_ZN6S262C43v98Ev,
  (VTBL_ENTRY)&_ZN6S262C43v99Ev,
  (VTBL_ENTRY)&_ZN6S262C44v100Ev,
  (VTBL_ENTRY)&_ZN6S262C44v101Ev,
  (VTBL_ENTRY)&_ZN6S262C44v102Ev,
  (VTBL_ENTRY)&_ZN6S262C44v103Ev,
  (VTBL_ENTRY)&_ZN6S262C44v104Ev,
  (VTBL_ENTRY)&_ZN6S262C44v105Ev,
  (VTBL_ENTRY)&_ZN6S262C44v106Ev,
  (VTBL_ENTRY)&_ZN6S262C44v107Ev,
  (VTBL_ENTRY)&_ZN6S262C44v108Ev,
  (VTBL_ENTRY)&_ZN6S262C44v109Ev,
  (VTBL_ENTRY)&_ZN6S262C44v110Ev,
  (VTBL_ENTRY)&_ZN6S262C44v111Ev,
};
extern VTBL_ENTRY _ZTI6S262C4[];
extern  VTBL_ENTRY _ZTV6S262C4[];
Class_Descriptor cd_S262C4 = {  "S262C4", // class name
  bases_S262C4, 2,
  &(vtc_S262C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI6S262C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S262C4),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S262C3  : S262C4 {
  ::S1457C5_nt s262c3f0;
  unsigned int s262c3f1:1;
  ::S1412C18_nt s262c3f2;
  virtual  ~S262C3(); // _ZN6S262C3D1Ev
  virtual void  v112(); // _ZN6S262C34v112Ev
  virtual void  v113(); // _ZN6S262C34v113Ev
  virtual void  v114(); // _ZN6S262C34v114Ev
  virtual void  v115(); // _ZN6S262C34v115Ev
  S262C3(); // tgen
};
//SIG(-1 S262C3) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} FC17{ BC18{ BC9}} Fi[3]} vd v1 v2 v3 v4 FC5 Fi:1 FC19{ BC20{ BC9}}}


 S262C3 ::~S262C3(){ note_dtor("S262C3", this);}
void  S262C3 ::v112(){vfunc_called(this, "_ZN6S262C34v112Ev");}
void  S262C3 ::v113(){vfunc_called(this, "_ZN6S262C34v113Ev");}
void  S262C3 ::v114(){vfunc_called(this, "_ZN6S262C34v114Ev");}
void  S262C3 ::v115(){vfunc_called(this, "_ZN6S262C34v115Ev");}
S262C3 ::S262C3(){ note_ctor("S262C3", this);} // tgen

static void Test_S262C3()
{
  extern Class_Descriptor cd_S262C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(38,56)];
    init_test(&cd_S262C3, buf);
    S262C3 *dp, &lv = *(dp=new (buf) S262C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(296,220), "sizeof(S262C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S262C3)");
    check_base_class_offset(lv, (S262C6*)(S262C5*)(S262C4*), 0, "S262C3");
    check_base_class_offset(lv, (S262C5*)(S262C4*), 0, "S262C3");
    check_base_class_offset(lv, (S262C4*), 0, "S262C3");
    check_field_offset(lv, s262c3f0, ABISELECT(268,196), "S262C3.s262c3f0");
    set_bf_and_test(lv, s262c3f1, ABISELECT(276,204), 0, 1, 1, "S262C3");
    check_field_offset(lv, s262c3f2, ABISELECT(280,208), "S262C3.s262c3f2");
    test_class_info(&lv, &cd_S262C3);
    dp->~S262C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS262C3(Test_S262C3, "S262C3", ABISELECT(296,220));

#else // __cplusplus

extern void _ZN6S262C3C1Ev();
extern void _ZN6S262C3D1Ev();
Name_Map name_map_S262C3[] = {
  NSPAIR(_ZN6S262C3C1Ev),
  NSPAIR(_ZN6S262C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S262C6;
extern VTBL_ENTRY _ZTI6S262C6[];
extern  VTBL_ENTRY _ZTV6S262C6[];
extern Class_Descriptor cd_S262C5;
extern VTBL_ENTRY _ZTI6S262C5[];
extern  VTBL_ENTRY _ZTV6S262C5[];
extern Class_Descriptor cd_S262C4;
extern VTBL_ENTRY _ZTI6S262C4[];
extern  VTBL_ENTRY _ZTV6S262C4[];
static Base_Class bases_S262C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S262C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S262C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S262C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S262C3[];
extern void _ZN6S262C3D1Ev();
extern void _ZN6S262C3D0Ev();
extern void _ZN6S262C62v6Ev();
extern void _ZN6S262C62v7Ev();
extern void _ZN6S262C62v8Ev();
extern void _ZN6S262C62v9Ev();
extern void _ZN6S262C63v10Ev();
extern void _ZN6S262C63v11Ev();
extern void _ZN6S262C63v12Ev();
extern void _ZN6S262C63v13Ev();
extern void _ZN6S262C63v14Ev();
extern void _ZN6S262C63v15Ev();
extern void _ZN6S262C63v16Ev();
extern void _ZN6S262C63v17Ev();
extern void _ZN6S262C63v18Ev();
extern void _ZN6S262C63v19Ev();
extern void _ZN6S262C63v20Ev();
extern void _ZN6S262C63v21Ev();
extern void _ZN6S262C63v22Ev();
extern void _ZN6S262C63v23Ev();
extern void _ZN6S262C63v24Ev();
extern void _ZN6S262C63v25Ev();
extern void _ZN6S262C63v26Ev();
extern void _ZN6S262C63v27Ev();
extern void _ZN6S262C63v28Ev();
extern void _ZN6S262C63v29Ev();
extern void _ZN6S262C63v30Ev();
extern void _ZN6S262C63v31Ev();
extern void _ZN6S262C63v32Ev();
extern void _ZN6S262C63v33Ev();
extern void _ZN6S262C63v34Ev();
extern void _ZN6S262C63v35Ev();
extern void _ZN6S262C63v36Ev();
extern void _ZN6S262C63v37Ev();
extern void _ZN6S262C63v38Ev();
extern void _ZN6S262C63v39Ev();
extern void _ZN6S262C63v40Ev();
extern void _ZN6S262C63v41Ev();
extern void _ZN6S262C63v42Ev();
extern void _ZN6S262C63v43Ev();
extern void _ZN6S262C63v44Ev();
extern void _ZN6S262C63v45Ev();
extern void _ZN6S262C63v46Ev();
extern void _ZN6S262C63v47Ev();
extern void _ZN6S262C63v48Ev();
extern void _ZN6S262C63v49Ev();
extern void _ZN6S262C63v50Ev();
extern void _ZN6S262C63v51Ev();
extern void _ZN6S262C63v52Ev();
extern void _ZN6S262C63v53Ev();
extern void _ZN6S262C63v54Ev();
extern void _ZN6S262C63v55Ev();
extern void _ZN6S262C63v56Ev();
extern void _ZN6S262C63v57Ev();
extern void _ZN6S262C63v58Ev();
extern void _ZN6S262C63v59Ev();
extern void _ZN6S262C63v60Ev();
extern void _ZN6S262C63v61Ev();
extern void _ZN6S262C63v62Ev();
extern void _ZN6S262C63v63Ev();
extern void _ZN6S262C63v64Ev();
extern void _ZN6S262C63v65Ev();
extern void _ZN6S262C63v66Ev();
extern void _ZN6S262C63v67Ev();
extern void _ZN6S262C63v68Ev();
extern void _ZN6S262C63v69Ev();
extern void _ZN6S262C53v70Ev();
extern void _ZN6S262C53v71Ev();
extern void _ZN6S262C53v72Ev();
extern void _ZN6S262C53v73Ev();
extern void _ZN6S262C53v74Ev();
extern void _ZN6S262C53v75Ev();
extern void _ZN6S262C53v76Ev();
extern void _ZN6S262C53v77Ev();
extern void _ZN6S262C53v78Ev();
extern void _ZN6S262C53v79Ev();
extern void _ZN6S262C53v80Ev();
extern void _ZN6S262C53v81Ev();
extern void _ZN6S262C53v82Ev();
extern void _ZN6S262C53v83Ev();
extern void _ZN6S262C53v84Ev();
extern void _ZN6S262C53v85Ev();
extern void _ZN6S262C53v86Ev();
extern void _ZN6S262C53v87Ev();
extern void _ZN6S262C53v88Ev();
extern void _ZN6S262C53v89Ev();
extern void _ZN6S262C53v90Ev();
extern void _ZN6S262C53v91Ev();
extern void _ZN6S262C43v92Ev();
extern void _ZN6S262C43v93Ev();
extern void _ZN6S262C43v94Ev();
extern void _ZN6S262C43v95Ev();
extern void _ZN6S262C43v96Ev();
extern void _ZN6S262C43v97Ev();
extern void _ZN6S262C43v98Ev();
extern void _ZN6S262C43v99Ev();
extern void _ZN6S262C44v100Ev();
extern void _ZN6S262C44v101Ev();
extern void _ZN6S262C44v102Ev();
extern void _ZN6S262C44v103Ev();
extern void _ZN6S262C44v104Ev();
extern void _ZN6S262C44v105Ev();
extern void _ZN6S262C44v106Ev();
extern void _ZN6S262C44v107Ev();
extern void _ZN6S262C44v108Ev();
extern void _ZN6S262C44v109Ev();
extern void _ZN6S262C44v110Ev();
extern void _ZN6S262C44v111Ev();
extern void _ZN6S262C34v112Ev();
extern void _ZN6S262C34v113Ev();
extern void _ZN6S262C34v114Ev();
extern void _ZN6S262C34v115Ev();
static  VTBL_ENTRY vtc_S262C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S262C3[0]),
  (VTBL_ENTRY)&_ZN6S262C3D1Ev,
  (VTBL_ENTRY)&_ZN6S262C3D0Ev,
  (VTBL_ENTRY)&_ZN6S262C62v6Ev,
  (VTBL_ENTRY)&_ZN6S262C62v7Ev,
  (VTBL_ENTRY)&_ZN6S262C62v8Ev,
  (VTBL_ENTRY)&_ZN6S262C62v9Ev,
  (VTBL_ENTRY)&_ZN6S262C63v10Ev,
  (VTBL_ENTRY)&_ZN6S262C63v11Ev,
  (VTBL_ENTRY)&_ZN6S262C63v12Ev,
  (VTBL_ENTRY)&_ZN6S262C63v13Ev,
  (VTBL_ENTRY)&_ZN6S262C63v14Ev,
  (VTBL_ENTRY)&_ZN6S262C63v15Ev,
  (VTBL_ENTRY)&_ZN6S262C63v16Ev,
  (VTBL_ENTRY)&_ZN6S262C63v17Ev,
  (VTBL_ENTRY)&_ZN6S262C63v18Ev,
  (VTBL_ENTRY)&_ZN6S262C63v19Ev,
  (VTBL_ENTRY)&_ZN6S262C63v20Ev,
  (VTBL_ENTRY)&_ZN6S262C63v21Ev,
  (VTBL_ENTRY)&_ZN6S262C63v22Ev,
  (VTBL_ENTRY)&_ZN6S262C63v23Ev,
  (VTBL_ENTRY)&_ZN6S262C63v24Ev,
  (VTBL_ENTRY)&_ZN6S262C63v25Ev,
  (VTBL_ENTRY)&_ZN6S262C63v26Ev,
  (VTBL_ENTRY)&_ZN6S262C63v27Ev,
  (VTBL_ENTRY)&_ZN6S262C63v28Ev,
  (VTBL_ENTRY)&_ZN6S262C63v29Ev,
  (VTBL_ENTRY)&_ZN6S262C63v30Ev,
  (VTBL_ENTRY)&_ZN6S262C63v31Ev,
  (VTBL_ENTRY)&_ZN6S262C63v32Ev,
  (VTBL_ENTRY)&_ZN6S262C63v33Ev,
  (VTBL_ENTRY)&_ZN6S262C63v34Ev,
  (VTBL_ENTRY)&_ZN6S262C63v35Ev,
  (VTBL_ENTRY)&_ZN6S262C63v36Ev,
  (VTBL_ENTRY)&_ZN6S262C63v37Ev,
  (VTBL_ENTRY)&_ZN6S262C63v38Ev,
  (VTBL_ENTRY)&_ZN6S262C63v39Ev,
  (VTBL_ENTRY)&_ZN6S262C63v40Ev,
  (VTBL_ENTRY)&_ZN6S262C63v41Ev,
  (VTBL_ENTRY)&_ZN6S262C63v42Ev,
  (VTBL_ENTRY)&_ZN6S262C63v43Ev,
  (VTBL_ENTRY)&_ZN6S262C63v44Ev,
  (VTBL_ENTRY)&_ZN6S262C63v45Ev,
  (VTBL_ENTRY)&_ZN6S262C63v46Ev,
  (VTBL_ENTRY)&_ZN6S262C63v47Ev,
  (VTBL_ENTRY)&_ZN6S262C63v48Ev,
  (VTBL_ENTRY)&_ZN6S262C63v49Ev,
  (VTBL_ENTRY)&_ZN6S262C63v50Ev,
  (VTBL_ENTRY)&_ZN6S262C63v51Ev,
  (VTBL_ENTRY)&_ZN6S262C63v52Ev,
  (VTBL_ENTRY)&_ZN6S262C63v53Ev,
  (VTBL_ENTRY)&_ZN6S262C63v54Ev,
  (VTBL_ENTRY)&_ZN6S262C63v55Ev,
  (VTBL_ENTRY)&_ZN6S262C63v56Ev,
  (VTBL_ENTRY)&_ZN6S262C63v57Ev,
  (VTBL_ENTRY)&_ZN6S262C63v58Ev,
  (VTBL_ENTRY)&_ZN6S262C63v59Ev,
  (VTBL_ENTRY)&_ZN6S262C63v60Ev,
  (VTBL_ENTRY)&_ZN6S262C63v61Ev,
  (VTBL_ENTRY)&_ZN6S262C63v62Ev,
  (VTBL_ENTRY)&_ZN6S262C63v63Ev,
  (VTBL_ENTRY)&_ZN6S262C63v64Ev,
  (VTBL_ENTRY)&_ZN6S262C63v65Ev,
  (VTBL_ENTRY)&_ZN6S262C63v66Ev,
  (VTBL_ENTRY)&_ZN6S262C63v67Ev,
  (VTBL_ENTRY)&_ZN6S262C63v68Ev,
  (VTBL_ENTRY)&_ZN6S262C63v69Ev,
  (VTBL_ENTRY)&_ZN6S262C53v70Ev,
  (VTBL_ENTRY)&_ZN6S262C53v71Ev,
  (VTBL_ENTRY)&_ZN6S262C53v72Ev,
  (VTBL_ENTRY)&_ZN6S262C53v73Ev,
  (VTBL_ENTRY)&_ZN6S262C53v74Ev,
  (VTBL_ENTRY)&_ZN6S262C53v75Ev,
  (VTBL_ENTRY)&_ZN6S262C53v76Ev,
  (VTBL_ENTRY)&_ZN6S262C53v77Ev,
  (VTBL_ENTRY)&_ZN6S262C53v78Ev,
  (VTBL_ENTRY)&_ZN6S262C53v79Ev,
  (VTBL_ENTRY)&_ZN6S262C53v80Ev,
  (VTBL_ENTRY)&_ZN6S262C53v81Ev,
  (VTBL_ENTRY)&_ZN6S262C53v82Ev,
  (VTBL_ENTRY)&_ZN6S262C53v83Ev,
  (VTBL_ENTRY)&_ZN6S262C53v84Ev,
  (VTBL_ENTRY)&_ZN6S262C53v85Ev,
  (VTBL_ENTRY)&_ZN6S262C53v86Ev,
  (VTBL_ENTRY)&_ZN6S262C53v87Ev,
  (VTBL_ENTRY)&_ZN6S262C53v88Ev,
  (VTBL_ENTRY)&_ZN6S262C53v89Ev,
  (VTBL_ENTRY)&_ZN6S262C53v90Ev,
  (VTBL_ENTRY)&_ZN6S262C53v91Ev,
  (VTBL_ENTRY)&_ZN6S262C43v92Ev,
  (VTBL_ENTRY)&_ZN6S262C43v93Ev,
  (VTBL_ENTRY)&_ZN6S262C43v94Ev,
  (VTBL_ENTRY)&_ZN6S262C43v95Ev,
  (VTBL_ENTRY)&_ZN6S262C43v96Ev,
  (VTBL_ENTRY)&_ZN6S262C43v97Ev,
  (VTBL_ENTRY)&_ZN6S262C43v98Ev,
  (VTBL_ENTRY)&_ZN6S262C43v99Ev,
  (VTBL_ENTRY)&_ZN6S262C44v100Ev,
  (VTBL_ENTRY)&_ZN6S262C44v101Ev,
  (VTBL_ENTRY)&_ZN6S262C44v102Ev,
  (VTBL_ENTRY)&_ZN6S262C44v103Ev,
  (VTBL_ENTRY)&_ZN6S262C44v104Ev,
  (VTBL_ENTRY)&_ZN6S262C44v105Ev,
  (VTBL_ENTRY)&_ZN6S262C44v106Ev,
  (VTBL_ENTRY)&_ZN6S262C44v107Ev,
  (VTBL_ENTRY)&_ZN6S262C44v108Ev,
  (VTBL_ENTRY)&_ZN6S262C44v109Ev,
  (VTBL_ENTRY)&_ZN6S262C44v110Ev,
  (VTBL_ENTRY)&_ZN6S262C44v111Ev,
  (VTBL_ENTRY)&_ZN6S262C34v112Ev,
  (VTBL_ENTRY)&_ZN6S262C34v113Ev,
  (VTBL_ENTRY)&_ZN6S262C34v114Ev,
  (VTBL_ENTRY)&_ZN6S262C34v115Ev,
};
extern VTBL_ENTRY _ZTI6S262C3[];
extern  VTBL_ENTRY _ZTV6S262C3[];
Class_Descriptor cd_S262C3 = {  "S262C3", // class name
  bases_S262C3, 3,
  &(vtc_S262C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,220), // object size
  NSPAIRA(_ZTI6S262C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S262C3),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S262C2_nt  : S262C3 {
  ::S694C8 s262c2f0;
  unsigned int s262c2f1:1;
  virtual  ~S262C2_nt(); // _ZN9S262C2_ntD1Ev
  virtual void  v116(); // _ZN9S262C2_nt4v116Ev
  virtual void  v117(); // _ZN9S262C2_nt4v117Ev
  virtual void  v118(); // _ZN9S262C2_nt4v118Ev
  virtual void  v119(); // _ZN9S262C2_nt4v119Ev
  virtual void  v120(); // _ZN9S262C2_nt4v120Ev
  virtual void  v121(); // _ZN9S262C2_nt4v121Ev
  virtual void  v122(); // _ZN9S262C2_nt4v122Ev
  S262C2_nt(); // tgen
};
//SIG(-1 S262C2_nt) C1{ BC2{ BC3{ BC4{ BC5{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} FC18{ BC19{ BC10}} Fi[3]} vd v114 v115 v116 v117 FC6 Fi:1 FC20{ BC21{ BC10}}} vd v1 v2 v3 v4 v5 v6 v7 FC8 Fi:1}


 S262C2_nt ::~S262C2_nt(){ note_dtor("S262C2_nt", this);}
void  S262C2_nt ::v116(){vfunc_called(this, "_ZN9S262C2_nt4v116Ev");}
void  S262C2_nt ::v117(){vfunc_called(this, "_ZN9S262C2_nt4v117Ev");}
void  S262C2_nt ::v118(){vfunc_called(this, "_ZN9S262C2_nt4v118Ev");}
void  S262C2_nt ::v119(){vfunc_called(this, "_ZN9S262C2_nt4v119Ev");}
void  S262C2_nt ::v120(){vfunc_called(this, "_ZN9S262C2_nt4v120Ev");}
void  S262C2_nt ::v121(){vfunc_called(this, "_ZN9S262C2_nt4v121Ev");}
void  S262C2_nt ::v122(){vfunc_called(this, "_ZN9S262C2_nt4v122Ev");}
S262C2_nt ::S262C2_nt(){ note_ctor("S262C2_nt", this);} // tgen

//skip512 S262C2_nt

#else // __cplusplus

extern void _ZN9S262C2_ntC1Ev();
extern void _ZN9S262C2_ntD1Ev();
Name_Map name_map_S262C2_nt[] = {
  NSPAIR(_ZN9S262C2_ntC1Ev),
  NSPAIR(_ZN9S262C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S262C6;
extern VTBL_ENTRY _ZTI6S262C6[];
extern  VTBL_ENTRY _ZTV6S262C6[];
extern Class_Descriptor cd_S262C5;
extern VTBL_ENTRY _ZTI6S262C5[];
extern  VTBL_ENTRY _ZTV6S262C5[];
extern Class_Descriptor cd_S262C4;
extern VTBL_ENTRY _ZTI6S262C4[];
extern  VTBL_ENTRY _ZTV6S262C4[];
extern Class_Descriptor cd_S262C3;
extern VTBL_ENTRY _ZTI6S262C3[];
extern  VTBL_ENTRY _ZTV6S262C3[];
static Base_Class bases_S262C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S262C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S262C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S262C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S262C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S262C2_nt[];
extern void _ZN9S262C2_ntD1Ev();
extern void _ZN9S262C2_ntD0Ev();
extern void _ZN6S262C62v6Ev();
extern void _ZN6S262C62v7Ev();
extern void _ZN6S262C62v8Ev();
extern void _ZN6S262C62v9Ev();
extern void _ZN6S262C63v10Ev();
extern void _ZN6S262C63v11Ev();
extern void _ZN6S262C63v12Ev();
extern void _ZN6S262C63v13Ev();
extern void _ZN6S262C63v14Ev();
extern void _ZN6S262C63v15Ev();
extern void _ZN6S262C63v16Ev();
extern void _ZN6S262C63v17Ev();
extern void _ZN6S262C63v18Ev();
extern void _ZN6S262C63v19Ev();
extern void _ZN6S262C63v20Ev();
extern void _ZN6S262C63v21Ev();
extern void _ZN6S262C63v22Ev();
extern void _ZN6S262C63v23Ev();
extern void _ZN6S262C63v24Ev();
extern void _ZN6S262C63v25Ev();
extern void _ZN6S262C63v26Ev();
extern void _ZN6S262C63v27Ev();
extern void _ZN6S262C63v28Ev();
extern void _ZN6S262C63v29Ev();
extern void _ZN6S262C63v30Ev();
extern void _ZN6S262C63v31Ev();
extern void _ZN6S262C63v32Ev();
extern void _ZN6S262C63v33Ev();
extern void _ZN6S262C63v34Ev();
extern void _ZN6S262C63v35Ev();
extern void _ZN6S262C63v36Ev();
extern void _ZN6S262C63v37Ev();
extern void _ZN6S262C63v38Ev();
extern void _ZN6S262C63v39Ev();
extern void _ZN6S262C63v40Ev();
extern void _ZN6S262C63v41Ev();
extern void _ZN6S262C63v42Ev();
extern void _ZN6S262C63v43Ev();
extern void _ZN6S262C63v44Ev();
extern void _ZN6S262C63v45Ev();
extern void _ZN6S262C63v46Ev();
extern void _ZN6S262C63v47Ev();
extern void _ZN6S262C63v48Ev();
extern void _ZN6S262C63v49Ev();
extern void _ZN6S262C63v50Ev();
extern void _ZN6S262C63v51Ev();
extern void _ZN6S262C63v52Ev();
extern void _ZN6S262C63v53Ev();
extern void _ZN6S262C63v54Ev();
extern void _ZN6S262C63v55Ev();
extern void _ZN6S262C63v56Ev();
extern void _ZN6S262C63v57Ev();
extern void _ZN6S262C63v58Ev();
extern void _ZN6S262C63v59Ev();
extern void _ZN6S262C63v60Ev();
extern void _ZN6S262C63v61Ev();
extern void _ZN6S262C63v62Ev();
extern void _ZN6S262C63v63Ev();
extern void _ZN6S262C63v64Ev();
extern void _ZN6S262C63v65Ev();
extern void _ZN6S262C63v66Ev();
extern void _ZN6S262C63v67Ev();
extern void _ZN6S262C63v68Ev();
extern void _ZN6S262C63v69Ev();
extern void _ZN6S262C53v70Ev();
extern void _ZN6S262C53v71Ev();
extern void _ZN6S262C53v72Ev();
extern void _ZN6S262C53v73Ev();
extern void _ZN6S262C53v74Ev();
extern void _ZN6S262C53v75Ev();
extern void _ZN6S262C53v76Ev();
extern void _ZN6S262C53v77Ev();
extern void _ZN6S262C53v78Ev();
extern void _ZN6S262C53v79Ev();
extern void _ZN6S262C53v80Ev();
extern void _ZN6S262C53v81Ev();
extern void _ZN6S262C53v82Ev();
extern void _ZN6S262C53v83Ev();
extern void _ZN6S262C53v84Ev();
extern void _ZN6S262C53v85Ev();
extern void _ZN6S262C53v86Ev();
extern void _ZN6S262C53v87Ev();
extern void _ZN6S262C53v88Ev();
extern void _ZN6S262C53v89Ev();
extern void _ZN6S262C53v90Ev();
extern void _ZN6S262C53v91Ev();
extern void _ZN6S262C43v92Ev();
extern void _ZN6S262C43v93Ev();
extern void _ZN6S262C43v94Ev();
extern void _ZN6S262C43v95Ev();
extern void _ZN6S262C43v96Ev();
extern void _ZN6S262C43v97Ev();
extern void _ZN6S262C43v98Ev();
extern void _ZN6S262C43v99Ev();
extern void _ZN6S262C44v100Ev();
extern void _ZN6S262C44v101Ev();
extern void _ZN6S262C44v102Ev();
extern void _ZN6S262C44v103Ev();
extern void _ZN6S262C44v104Ev();
extern void _ZN6S262C44v105Ev();
extern void _ZN6S262C44v106Ev();
extern void _ZN6S262C44v107Ev();
extern void _ZN6S262C44v108Ev();
extern void _ZN6S262C44v109Ev();
extern void _ZN6S262C44v110Ev();
extern void _ZN6S262C44v111Ev();
extern void _ZN6S262C34v112Ev();
extern void _ZN6S262C34v113Ev();
extern void _ZN6S262C34v114Ev();
extern void _ZN6S262C34v115Ev();
extern void _ZN9S262C2_nt4v116Ev();
extern void _ZN9S262C2_nt4v117Ev();
extern void _ZN9S262C2_nt4v118Ev();
extern void _ZN9S262C2_nt4v119Ev();
extern void _ZN9S262C2_nt4v120Ev();
extern void _ZN9S262C2_nt4v121Ev();
extern void _ZN9S262C2_nt4v122Ev();
static  VTBL_ENTRY vtc_S262C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S262C2_nt[0]),
  (VTBL_ENTRY)&_ZN9S262C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S262C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S262C62v6Ev,
  (VTBL_ENTRY)&_ZN6S262C62v7Ev,
  (VTBL_ENTRY)&_ZN6S262C62v8Ev,
  (VTBL_ENTRY)&_ZN6S262C62v9Ev,
  (VTBL_ENTRY)&_ZN6S262C63v10Ev,
  (VTBL_ENTRY)&_ZN6S262C63v11Ev,
  (VTBL_ENTRY)&_ZN6S262C63v12Ev,
  (VTBL_ENTRY)&_ZN6S262C63v13Ev,
  (VTBL_ENTRY)&_ZN6S262C63v14Ev,
  (VTBL_ENTRY)&_ZN6S262C63v15Ev,
  (VTBL_ENTRY)&_ZN6S262C63v16Ev,
  (VTBL_ENTRY)&_ZN6S262C63v17Ev,
  (VTBL_ENTRY)&_ZN6S262C63v18Ev,
  (VTBL_ENTRY)&_ZN6S262C63v19Ev,
  (VTBL_ENTRY)&_ZN6S262C63v20Ev,
  (VTBL_ENTRY)&_ZN6S262C63v21Ev,
  (VTBL_ENTRY)&_ZN6S262C63v22Ev,
  (VTBL_ENTRY)&_ZN6S262C63v23Ev,
  (VTBL_ENTRY)&_ZN6S262C63v24Ev,
  (VTBL_ENTRY)&_ZN6S262C63v25Ev,
  (VTBL_ENTRY)&_ZN6S262C63v26Ev,
  (VTBL_ENTRY)&_ZN6S262C63v27Ev,
  (VTBL_ENTRY)&_ZN6S262C63v28Ev,
  (VTBL_ENTRY)&_ZN6S262C63v29Ev,
  (VTBL_ENTRY)&_ZN6S262C63v30Ev,
  (VTBL_ENTRY)&_ZN6S262C63v31Ev,
  (VTBL_ENTRY)&_ZN6S262C63v32Ev,
  (VTBL_ENTRY)&_ZN6S262C63v33Ev,
  (VTBL_ENTRY)&_ZN6S262C63v34Ev,
  (VTBL_ENTRY)&_ZN6S262C63v35Ev,
  (VTBL_ENTRY)&_ZN6S262C63v36Ev,
  (VTBL_ENTRY)&_ZN6S262C63v37Ev,
  (VTBL_ENTRY)&_ZN6S262C63v38Ev,
  (VTBL_ENTRY)&_ZN6S262C63v39Ev,
  (VTBL_ENTRY)&_ZN6S262C63v40Ev,
  (VTBL_ENTRY)&_ZN6S262C63v41Ev,
  (VTBL_ENTRY)&_ZN6S262C63v42Ev,
  (VTBL_ENTRY)&_ZN6S262C63v43Ev,
  (VTBL_ENTRY)&_ZN6S262C63v44Ev,
  (VTBL_ENTRY)&_ZN6S262C63v45Ev,
  (VTBL_ENTRY)&_ZN6S262C63v46Ev,
  (VTBL_ENTRY)&_ZN6S262C63v47Ev,
  (VTBL_ENTRY)&_ZN6S262C63v48Ev,
  (VTBL_ENTRY)&_ZN6S262C63v49Ev,
  (VTBL_ENTRY)&_ZN6S262C63v50Ev,
  (VTBL_ENTRY)&_ZN6S262C63v51Ev,
  (VTBL_ENTRY)&_ZN6S262C63v52Ev,
  (VTBL_ENTRY)&_ZN6S262C63v53Ev,
  (VTBL_ENTRY)&_ZN6S262C63v54Ev,
  (VTBL_ENTRY)&_ZN6S262C63v55Ev,
  (VTBL_ENTRY)&_ZN6S262C63v56Ev,
  (VTBL_ENTRY)&_ZN6S262C63v57Ev,
  (VTBL_ENTRY)&_ZN6S262C63v58Ev,
  (VTBL_ENTRY)&_ZN6S262C63v59Ev,
  (VTBL_ENTRY)&_ZN6S262C63v60Ev,
  (VTBL_ENTRY)&_ZN6S262C63v61Ev,
  (VTBL_ENTRY)&_ZN6S262C63v62Ev,
  (VTBL_ENTRY)&_ZN6S262C63v63Ev,
  (VTBL_ENTRY)&_ZN6S262C63v64Ev,
  (VTBL_ENTRY)&_ZN6S262C63v65Ev,
  (VTBL_ENTRY)&_ZN6S262C63v66Ev,
  (VTBL_ENTRY)&_ZN6S262C63v67Ev,
  (VTBL_ENTRY)&_ZN6S262C63v68Ev,
  (VTBL_ENTRY)&_ZN6S262C63v69Ev,
  (VTBL_ENTRY)&_ZN6S262C53v70Ev,
  (VTBL_ENTRY)&_ZN6S262C53v71Ev,
  (VTBL_ENTRY)&_ZN6S262C53v72Ev,
  (VTBL_ENTRY)&_ZN6S262C53v73Ev,
  (VTBL_ENTRY)&_ZN6S262C53v74Ev,
  (VTBL_ENTRY)&_ZN6S262C53v75Ev,
  (VTBL_ENTRY)&_ZN6S262C53v76Ev,
  (VTBL_ENTRY)&_ZN6S262C53v77Ev,
  (VTBL_ENTRY)&_ZN6S262C53v78Ev,
  (VTBL_ENTRY)&_ZN6S262C53v79Ev,
  (VTBL_ENTRY)&_ZN6S262C53v80Ev,
  (VTBL_ENTRY)&_ZN6S262C53v81Ev,
  (VTBL_ENTRY)&_ZN6S262C53v82Ev,
  (VTBL_ENTRY)&_ZN6S262C53v83Ev,
  (VTBL_ENTRY)&_ZN6S262C53v84Ev,
  (VTBL_ENTRY)&_ZN6S262C53v85Ev,
  (VTBL_ENTRY)&_ZN6S262C53v86Ev,
  (VTBL_ENTRY)&_ZN6S262C53v87Ev,
  (VTBL_ENTRY)&_ZN6S262C53v88Ev,
  (VTBL_ENTRY)&_ZN6S262C53v89Ev,
  (VTBL_ENTRY)&_ZN6S262C53v90Ev,
  (VTBL_ENTRY)&_ZN6S262C53v91Ev,
  (VTBL_ENTRY)&_ZN6S262C43v92Ev,
  (VTBL_ENTRY)&_ZN6S262C43v93Ev,
  (VTBL_ENTRY)&_ZN6S262C43v94Ev,
  (VTBL_ENTRY)&_ZN6S262C43v95Ev,
  (VTBL_ENTRY)&_ZN6S262C43v96Ev,
  (VTBL_ENTRY)&_ZN6S262C43v97Ev,
  (VTBL_ENTRY)&_ZN6S262C43v98Ev,
  (VTBL_ENTRY)&_ZN6S262C43v99Ev,
  (VTBL_ENTRY)&_ZN6S262C44v100Ev,
  (VTBL_ENTRY)&_ZN6S262C44v101Ev,
  (VTBL_ENTRY)&_ZN6S262C44v102Ev,
  (VTBL_ENTRY)&_ZN6S262C44v103Ev,
  (VTBL_ENTRY)&_ZN6S262C44v104Ev,
  (VTBL_ENTRY)&_ZN6S262C44v105Ev,
  (VTBL_ENTRY)&_ZN6S262C44v106Ev,
  (VTBL_ENTRY)&_ZN6S262C44v107Ev,
  (VTBL_ENTRY)&_ZN6S262C44v108Ev,
  (VTBL_ENTRY)&_ZN6S262C44v109Ev,
  (VTBL_ENTRY)&_ZN6S262C44v110Ev,
  (VTBL_ENTRY)&_ZN6S262C44v111Ev,
  (VTBL_ENTRY)&_ZN6S262C34v112Ev,
  (VTBL_ENTRY)&_ZN6S262C34v113Ev,
  (VTBL_ENTRY)&_ZN6S262C34v114Ev,
  (VTBL_ENTRY)&_ZN6S262C34v115Ev,
  (VTBL_ENTRY)&_ZN9S262C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S262C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S262C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S262C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S262C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S262C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S262C2_nt4v122Ev,
};
extern VTBL_ENTRY _ZTI9S262C2_nt[];
VTBL_ENTRY *P__ZTI9S262C2_nt = _ZTI9S262C2_nt; 
extern  VTBL_ENTRY _ZTV9S262C2_nt[];
Class_Descriptor cd_S262C2_nt = {  "S262C2_nt", // class name
  bases_S262C2_nt, 4,
  &(vtc_S262C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(320,236), // object size
  NSPAIRA(_ZTI9S262C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S262C2_nt),121, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S262C1  : S262C2_nt {
  int s262c1f0[4];
  virtual  ~S262C1(); // _ZN6S262C1D1Ev
  virtual void  v1(); // _ZN6S262C12v1Ev
  virtual void  v2(); // _ZN6S262C12v2Ev
  virtual void  v3(); // _ZN6S262C12v3Ev
  virtual void  v4(); // _ZN6S262C12v4Ev
  virtual void  v5(); // _ZN6S262C12v5Ev
  S262C1(); // tgen
};
//SIG(1 S262C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 Fi[2] Fp Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 FC12{ m} FC8 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 Fi:1 Fi:1 Fi:1 FC13{ BC14{ BC11}} FC15{ BC16{ BC11}} FC17{ BC18{ BC11}} FC19{ BC20{ BC11}} Fi[3]} vd v112 v113 v114 v115 FC7 Fi:1 FC21{ BC22{ BC11}}} vd v116 v117 v118 v119 v120 v121 v122 FC9 Fi:1} vd v1 v2 v3 v4 v5 Fi[4]}


 S262C1 ::~S262C1(){ note_dtor("S262C1", this);}
void  S262C1 ::v1(){vfunc_called(this, "_ZN6S262C12v1Ev");}
void  S262C1 ::v2(){vfunc_called(this, "_ZN6S262C12v2Ev");}
void  S262C1 ::v3(){vfunc_called(this, "_ZN6S262C12v3Ev");}
void  S262C1 ::v4(){vfunc_called(this, "_ZN6S262C12v4Ev");}
void  S262C1 ::v5(){vfunc_called(this, "_ZN6S262C12v5Ev");}
S262C1 ::S262C1(){ note_ctor("S262C1", this);} // tgen

static void Test_S262C1()
{
  extern Class_Descriptor cd_S262C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(43,64)];
    init_test(&cd_S262C1, buf);
    S262C1 *dp, &lv = *(dp=new (buf) S262C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(336,252), "sizeof(S262C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S262C1)");
    check_base_class_offset(lv, (S262C6*)(S262C5*)(S262C4*)(S262C3*)(S262C2_nt*), 0, "S262C1");
    check_base_class_offset(lv, (S262C5*)(S262C4*)(S262C3*)(S262C2_nt*), 0, "S262C1");
    check_base_class_offset(lv, (S262C4*)(S262C3*)(S262C2_nt*), 0, "S262C1");
    check_base_class_offset(lv, (S262C3*)(S262C2_nt*), 0, "S262C1");
    check_base_class_offset(lv, (S262C2_nt*), 0, "S262C1");
    check_field_offset(lv, s262c1f0, ABISELECT(316,236), "S262C1.s262c1f0");
    test_class_info(&lv, &cd_S262C1);
    dp->~S262C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS262C1(Test_S262C1, "S262C1", ABISELECT(336,252));

#else // __cplusplus

extern void _ZN6S262C1C1Ev();
extern void _ZN6S262C1D1Ev();
Name_Map name_map_S262C1[] = {
  NSPAIR(_ZN6S262C1C1Ev),
  NSPAIR(_ZN6S262C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S262C6;
extern VTBL_ENTRY _ZTI6S262C6[];
extern  VTBL_ENTRY _ZTV6S262C6[];
extern Class_Descriptor cd_S262C5;
extern VTBL_ENTRY _ZTI6S262C5[];
extern  VTBL_ENTRY _ZTV6S262C5[];
extern Class_Descriptor cd_S262C4;
extern VTBL_ENTRY _ZTI6S262C4[];
extern  VTBL_ENTRY _ZTV6S262C4[];
extern Class_Descriptor cd_S262C3;
extern VTBL_ENTRY _ZTI6S262C3[];
extern  VTBL_ENTRY _ZTV6S262C3[];
extern Class_Descriptor cd_S262C2_nt;
extern VTBL_ENTRY _ZTI9S262C2_nt[];
extern  VTBL_ENTRY _ZTV9S262C2_nt[];
static Base_Class bases_S262C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S262C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S262C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S262C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S262C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S262C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S262C1[];
extern void _ZN6S262C1D1Ev();
extern void _ZN6S262C1D0Ev();
extern void _ZN6S262C62v6Ev();
extern void _ZN6S262C62v7Ev();
extern void _ZN6S262C62v8Ev();
extern void _ZN6S262C62v9Ev();
extern void _ZN6S262C63v10Ev();
extern void _ZN6S262C63v11Ev();
extern void _ZN6S262C63v12Ev();
extern void _ZN6S262C63v13Ev();
extern void _ZN6S262C63v14Ev();
extern void _ZN6S262C63v15Ev();
extern void _ZN6S262C63v16Ev();
extern void _ZN6S262C63v17Ev();
extern void _ZN6S262C63v18Ev();
extern void _ZN6S262C63v19Ev();
extern void _ZN6S262C63v20Ev();
extern void _ZN6S262C63v21Ev();
extern void _ZN6S262C63v22Ev();
extern void _ZN6S262C63v23Ev();
extern void _ZN6S262C63v24Ev();
extern void _ZN6S262C63v25Ev();
extern void _ZN6S262C63v26Ev();
extern void _ZN6S262C63v27Ev();
extern void _ZN6S262C63v28Ev();
extern void _ZN6S262C63v29Ev();
extern void _ZN6S262C63v30Ev();
extern void _ZN6S262C63v31Ev();
extern void _ZN6S262C63v32Ev();
extern void _ZN6S262C63v33Ev();
extern void _ZN6S262C63v34Ev();
extern void _ZN6S262C63v35Ev();
extern void _ZN6S262C63v36Ev();
extern void _ZN6S262C63v37Ev();
extern void _ZN6S262C63v38Ev();
extern void _ZN6S262C63v39Ev();
extern void _ZN6S262C63v40Ev();
extern void _ZN6S262C63v41Ev();
extern void _ZN6S262C63v42Ev();
extern void _ZN6S262C63v43Ev();
extern void _ZN6S262C63v44Ev();
extern void _ZN6S262C63v45Ev();
extern void _ZN6S262C63v46Ev();
extern void _ZN6S262C63v47Ev();
extern void _ZN6S262C63v48Ev();
extern void _ZN6S262C63v49Ev();
extern void _ZN6S262C63v50Ev();
extern void _ZN6S262C63v51Ev();
extern void _ZN6S262C63v52Ev();
extern void _ZN6S262C63v53Ev();
extern void _ZN6S262C63v54Ev();
extern void _ZN6S262C63v55Ev();
extern void _ZN6S262C63v56Ev();
extern void _ZN6S262C63v57Ev();
extern void _ZN6S262C63v58Ev();
extern void _ZN6S262C63v59Ev();
extern void _ZN6S262C63v60Ev();
extern void _ZN6S262C63v61Ev();
extern void _ZN6S262C63v62Ev();
extern void _ZN6S262C63v63Ev();
extern void _ZN6S262C63v64Ev();
extern void _ZN6S262C63v65Ev();
extern void _ZN6S262C63v66Ev();
extern void _ZN6S262C63v67Ev();
extern void _ZN6S262C63v68Ev();
extern void _ZN6S262C63v69Ev();
extern void _ZN6S262C53v70Ev();
extern void _ZN6S262C53v71Ev();
extern void _ZN6S262C53v72Ev();
extern void _ZN6S262C53v73Ev();
extern void _ZN6S262C53v74Ev();
extern void _ZN6S262C53v75Ev();
extern void _ZN6S262C53v76Ev();
extern void _ZN6S262C53v77Ev();
extern void _ZN6S262C53v78Ev();
extern void _ZN6S262C53v79Ev();
extern void _ZN6S262C53v80Ev();
extern void _ZN6S262C53v81Ev();
extern void _ZN6S262C53v82Ev();
extern void _ZN6S262C53v83Ev();
extern void _ZN6S262C53v84Ev();
extern void _ZN6S262C53v85Ev();
extern void _ZN6S262C53v86Ev();
extern void _ZN6S262C53v87Ev();
extern void _ZN6S262C53v88Ev();
extern void _ZN6S262C53v89Ev();
extern void _ZN6S262C53v90Ev();
extern void _ZN6S262C53v91Ev();
extern void _ZN6S262C43v92Ev();
extern void _ZN6S262C43v93Ev();
extern void _ZN6S262C43v94Ev();
extern void _ZN6S262C43v95Ev();
extern void _ZN6S262C43v96Ev();
extern void _ZN6S262C43v97Ev();
extern void _ZN6S262C43v98Ev();
extern void _ZN6S262C43v99Ev();
extern void _ZN6S262C44v100Ev();
extern void _ZN6S262C44v101Ev();
extern void _ZN6S262C44v102Ev();
extern void _ZN6S262C44v103Ev();
extern void _ZN6S262C44v104Ev();
extern void _ZN6S262C44v105Ev();
extern void _ZN6S262C44v106Ev();
extern void _ZN6S262C44v107Ev();
extern void _ZN6S262C44v108Ev();
extern void _ZN6S262C44v109Ev();
extern void _ZN6S262C44v110Ev();
extern void _ZN6S262C44v111Ev();
extern void _ZN6S262C34v112Ev();
extern void _ZN6S262C34v113Ev();
extern void _ZN6S262C34v114Ev();
extern void _ZN6S262C34v115Ev();
extern void _ZN9S262C2_nt4v116Ev();
extern void _ZN9S262C2_nt4v117Ev();
extern void _ZN9S262C2_nt4v118Ev();
extern void _ZN9S262C2_nt4v119Ev();
extern void _ZN9S262C2_nt4v120Ev();
extern void _ZN9S262C2_nt4v121Ev();
extern void _ZN9S262C2_nt4v122Ev();
extern void _ZN6S262C12v1Ev();
extern void _ZN6S262C12v2Ev();
extern void _ZN6S262C12v3Ev();
extern void _ZN6S262C12v4Ev();
extern void _ZN6S262C12v5Ev();
static  VTBL_ENTRY vtc_S262C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S262C1[0]),
  (VTBL_ENTRY)&_ZN6S262C1D1Ev,
  (VTBL_ENTRY)&_ZN6S262C1D0Ev,
  (VTBL_ENTRY)&_ZN6S262C62v6Ev,
  (VTBL_ENTRY)&_ZN6S262C62v7Ev,
  (VTBL_ENTRY)&_ZN6S262C62v8Ev,
  (VTBL_ENTRY)&_ZN6S262C62v9Ev,
  (VTBL_ENTRY)&_ZN6S262C63v10Ev,
  (VTBL_ENTRY)&_ZN6S262C63v11Ev,
  (VTBL_ENTRY)&_ZN6S262C63v12Ev,
  (VTBL_ENTRY)&_ZN6S262C63v13Ev,
  (VTBL_ENTRY)&_ZN6S262C63v14Ev,
  (VTBL_ENTRY)&_ZN6S262C63v15Ev,
  (VTBL_ENTRY)&_ZN6S262C63v16Ev,
  (VTBL_ENTRY)&_ZN6S262C63v17Ev,
  (VTBL_ENTRY)&_ZN6S262C63v18Ev,
  (VTBL_ENTRY)&_ZN6S262C63v19Ev,
  (VTBL_ENTRY)&_ZN6S262C63v20Ev,
  (VTBL_ENTRY)&_ZN6S262C63v21Ev,
  (VTBL_ENTRY)&_ZN6S262C63v22Ev,
  (VTBL_ENTRY)&_ZN6S262C63v23Ev,
  (VTBL_ENTRY)&_ZN6S262C63v24Ev,
  (VTBL_ENTRY)&_ZN6S262C63v25Ev,
  (VTBL_ENTRY)&_ZN6S262C63v26Ev,
  (VTBL_ENTRY)&_ZN6S262C63v27Ev,
  (VTBL_ENTRY)&_ZN6S262C63v28Ev,
  (VTBL_ENTRY)&_ZN6S262C63v29Ev,
  (VTBL_ENTRY)&_ZN6S262C63v30Ev,
  (VTBL_ENTRY)&_ZN6S262C63v31Ev,
  (VTBL_ENTRY)&_ZN6S262C63v32Ev,
  (VTBL_ENTRY)&_ZN6S262C63v33Ev,
  (VTBL_ENTRY)&_ZN6S262C63v34Ev,
  (VTBL_ENTRY)&_ZN6S262C63v35Ev,
  (VTBL_ENTRY)&_ZN6S262C63v36Ev,
  (VTBL_ENTRY)&_ZN6S262C63v37Ev,
  (VTBL_ENTRY)&_ZN6S262C63v38Ev,
  (VTBL_ENTRY)&_ZN6S262C63v39Ev,
  (VTBL_ENTRY)&_ZN6S262C63v40Ev,
  (VTBL_ENTRY)&_ZN6S262C63v41Ev,
  (VTBL_ENTRY)&_ZN6S262C63v42Ev,
  (VTBL_ENTRY)&_ZN6S262C63v43Ev,
  (VTBL_ENTRY)&_ZN6S262C63v44Ev,
  (VTBL_ENTRY)&_ZN6S262C63v45Ev,
  (VTBL_ENTRY)&_ZN6S262C63v46Ev,
  (VTBL_ENTRY)&_ZN6S262C63v47Ev,
  (VTBL_ENTRY)&_ZN6S262C63v48Ev,
  (VTBL_ENTRY)&_ZN6S262C63v49Ev,
  (VTBL_ENTRY)&_ZN6S262C63v50Ev,
  (VTBL_ENTRY)&_ZN6S262C63v51Ev,
  (VTBL_ENTRY)&_ZN6S262C63v52Ev,
  (VTBL_ENTRY)&_ZN6S262C63v53Ev,
  (VTBL_ENTRY)&_ZN6S262C63v54Ev,
  (VTBL_ENTRY)&_ZN6S262C63v55Ev,
  (VTBL_ENTRY)&_ZN6S262C63v56Ev,
  (VTBL_ENTRY)&_ZN6S262C63v57Ev,
  (VTBL_ENTRY)&_ZN6S262C63v58Ev,
  (VTBL_ENTRY)&_ZN6S262C63v59Ev,
  (VTBL_ENTRY)&_ZN6S262C63v60Ev,
  (VTBL_ENTRY)&_ZN6S262C63v61Ev,
  (VTBL_ENTRY)&_ZN6S262C63v62Ev,
  (VTBL_ENTRY)&_ZN6S262C63v63Ev,
  (VTBL_ENTRY)&_ZN6S262C63v64Ev,
  (VTBL_ENTRY)&_ZN6S262C63v65Ev,
  (VTBL_ENTRY)&_ZN6S262C63v66Ev,
  (VTBL_ENTRY)&_ZN6S262C63v67Ev,
  (VTBL_ENTRY)&_ZN6S262C63v68Ev,
  (VTBL_ENTRY)&_ZN6S262C63v69Ev,
  (VTBL_ENTRY)&_ZN6S262C53v70Ev,
  (VTBL_ENTRY)&_ZN6S262C53v71Ev,
  (VTBL_ENTRY)&_ZN6S262C53v72Ev,
  (VTBL_ENTRY)&_ZN6S262C53v73Ev,
  (VTBL_ENTRY)&_ZN6S262C53v74Ev,
  (VTBL_ENTRY)&_ZN6S262C53v75Ev,
  (VTBL_ENTRY)&_ZN6S262C53v76Ev,
  (VTBL_ENTRY)&_ZN6S262C53v77Ev,
  (VTBL_ENTRY)&_ZN6S262C53v78Ev,
  (VTBL_ENTRY)&_ZN6S262C53v79Ev,
  (VTBL_ENTRY)&_ZN6S262C53v80Ev,
  (VTBL_ENTRY)&_ZN6S262C53v81Ev,
  (VTBL_ENTRY)&_ZN6S262C53v82Ev,
  (VTBL_ENTRY)&_ZN6S262C53v83Ev,
  (VTBL_ENTRY)&_ZN6S262C53v84Ev,
  (VTBL_ENTRY)&_ZN6S262C53v85Ev,
  (VTBL_ENTRY)&_ZN6S262C53v86Ev,
  (VTBL_ENTRY)&_ZN6S262C53v87Ev,
  (VTBL_ENTRY)&_ZN6S262C53v88Ev,
  (VTBL_ENTRY)&_ZN6S262C53v89Ev,
  (VTBL_ENTRY)&_ZN6S262C53v90Ev,
  (VTBL_ENTRY)&_ZN6S262C53v91Ev,
  (VTBL_ENTRY)&_ZN6S262C43v92Ev,
  (VTBL_ENTRY)&_ZN6S262C43v93Ev,
  (VTBL_ENTRY)&_ZN6S262C43v94Ev,
  (VTBL_ENTRY)&_ZN6S262C43v95Ev,
  (VTBL_ENTRY)&_ZN6S262C43v96Ev,
  (VTBL_ENTRY)&_ZN6S262C43v97Ev,
  (VTBL_ENTRY)&_ZN6S262C43v98Ev,
  (VTBL_ENTRY)&_ZN6S262C43v99Ev,
  (VTBL_ENTRY)&_ZN6S262C44v100Ev,
  (VTBL_ENTRY)&_ZN6S262C44v101Ev,
  (VTBL_ENTRY)&_ZN6S262C44v102Ev,
  (VTBL_ENTRY)&_ZN6S262C44v103Ev,
  (VTBL_ENTRY)&_ZN6S262C44v104Ev,
  (VTBL_ENTRY)&_ZN6S262C44v105Ev,
  (VTBL_ENTRY)&_ZN6S262C44v106Ev,
  (VTBL_ENTRY)&_ZN6S262C44v107Ev,
  (VTBL_ENTRY)&_ZN6S262C44v108Ev,
  (VTBL_ENTRY)&_ZN6S262C44v109Ev,
  (VTBL_ENTRY)&_ZN6S262C44v110Ev,
  (VTBL_ENTRY)&_ZN6S262C44v111Ev,
  (VTBL_ENTRY)&_ZN6S262C34v112Ev,
  (VTBL_ENTRY)&_ZN6S262C34v113Ev,
  (VTBL_ENTRY)&_ZN6S262C34v114Ev,
  (VTBL_ENTRY)&_ZN6S262C34v115Ev,
  (VTBL_ENTRY)&_ZN9S262C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S262C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S262C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S262C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S262C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S262C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S262C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN6S262C12v1Ev,
  (VTBL_ENTRY)&_ZN6S262C12v2Ev,
  (VTBL_ENTRY)&_ZN6S262C12v3Ev,
  (VTBL_ENTRY)&_ZN6S262C12v4Ev,
  (VTBL_ENTRY)&_ZN6S262C12v5Ev,
};
extern VTBL_ENTRY _ZTI6S262C1[];
extern  VTBL_ENTRY _ZTV6S262C1[];
Class_Descriptor cd_S262C1 = {  "S262C1", // class name
  bases_S262C1, 5,
  &(vtc_S262C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(336,252), // object size
  NSPAIRA(_ZTI6S262C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S262C1),126, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C5_nt  {
  void *s15666c5f0[4];
  void  mf15666c5(); // _ZN11S15666C5_nt9mf15666c5Ev
};
//SIG(-1 S15666C5_nt) C1{ m Fp[4]}


void  S15666C5_nt ::mf15666c5(){}

//skip512 S15666C5_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C4_nt  {
  ::S15666C5_nt s15666c4f0;
  virtual  ~S15666C4_nt(); // _ZN11S15666C4_ntD1Ev
  virtual void  v7(); // _ZN11S15666C4_nt2v7Ev
  virtual void  v8(); // _ZN11S15666C4_nt2v8Ev
  virtual void  v9(); // _ZN11S15666C4_nt2v9Ev
  virtual void  v10(); // _ZN11S15666C4_nt3v10Ev
  virtual void  v11(); // _ZN11S15666C4_nt3v11Ev
  virtual void  v12(); // _ZN11S15666C4_nt3v12Ev
  S15666C4_nt(); // tgen
};
//SIG(-1 S15666C4_nt) C1{ vd v1 v2 v3 v4 v5 v6 FC2{ m Fp[4]}}


 S15666C4_nt ::~S15666C4_nt(){ note_dtor("S15666C4_nt", this);}
void  S15666C4_nt ::v7(){vfunc_called(this, "_ZN11S15666C4_nt2v7Ev");}
void  S15666C4_nt ::v8(){vfunc_called(this, "_ZN11S15666C4_nt2v8Ev");}
void  S15666C4_nt ::v9(){vfunc_called(this, "_ZN11S15666C4_nt2v9Ev");}
void  S15666C4_nt ::v10(){vfunc_called(this, "_ZN11S15666C4_nt3v10Ev");}
void  S15666C4_nt ::v11(){vfunc_called(this, "_ZN11S15666C4_nt3v11Ev");}
void  S15666C4_nt ::v12(){vfunc_called(this, "_ZN11S15666C4_nt3v12Ev");}
S15666C4_nt ::S15666C4_nt(){ note_ctor("S15666C4_nt", this);} // tgen

//skip512 S15666C4_nt

#else // __cplusplus

extern void _ZN11S15666C4_ntC1Ev();
extern void _ZN11S15666C4_ntD1Ev();
Name_Map name_map_S15666C4_nt[] = {
  NSPAIR(_ZN11S15666C4_ntC1Ev),
  NSPAIR(_ZN11S15666C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S15666C4_nt[];
extern void _ZN11S15666C4_ntD1Ev();
extern void _ZN11S15666C4_ntD0Ev();
extern void _ZN11S15666C4_nt2v7Ev();
extern void _ZN11S15666C4_nt2v8Ev();
extern void _ZN11S15666C4_nt2v9Ev();
extern void _ZN11S15666C4_nt3v10Ev();
extern void _ZN11S15666C4_nt3v11Ev();
extern void _ZN11S15666C4_nt3v12Ev();
static  VTBL_ENTRY vtc_S15666C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S15666C4_nt[0]),
  (VTBL_ENTRY)&_ZN11S15666C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S15666C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S15666C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S15666C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN11S15666C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN11S15666C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN11S15666C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN11S15666C4_nt3v12Ev,
};
extern VTBL_ENTRY _ZTI11S15666C4_nt[];
VTBL_ENTRY *P__ZTI11S15666C4_nt = _ZTI11S15666C4_nt; 
extern  VTBL_ENTRY _ZTV11S15666C4_nt[];
Class_Descriptor cd_S15666C4_nt = {  "S15666C4_nt", // class name
  0,0,//no base classes
  &(vtc_S15666C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,20), // object size
  NSPAIRA(_ZTI11S15666C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S15666C4_nt),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C6_nt  {
};
//SIG(-1 S15666C6_nt) C1{}



//skip512 S15666C6_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI11S15666C6_nt[];
VTBL_ENTRY *P__ZTI11S15666C6_nt = _ZTI11S15666C6_nt; 
Class_Descriptor cd_S15666C6_nt = {  "S15666C6_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI11S15666C6_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C8_nt  {
  void *s15666c8f0;
  int s15666c8f1;
  void *s15666c8f2;
  int s15666c8f3[2];
  void  mf15666c8(); // _ZN11S15666C8_nt9mf15666c8Ev
};
//SIG(-1 S15666C8_nt) C1{ m Fp Fi Fp Fi[2]}


void  S15666C8_nt ::mf15666c8(){}

//skip512 S15666C8_nt

#else // __cplusplus

Class_Descriptor cd_S15666C8_nt = {  "S15666C8_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C11_nt  {
  __tsi64 s15666c11f0[2];
  void  mf15666c11(); // _ZN12S15666C11_nt10mf15666c11Ev
};
//SIG(-1 S15666C11_nt) C1{ m FL[2]}


void  S15666C11_nt ::mf15666c11(){}

//skip512 S15666C11_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C10_nt  {
  ::S15666C11_nt s15666c10f0;
  void  mf15666c10(); // _ZN12S15666C10_nt10mf15666c10Ev
};
//SIG(-1 S15666C10_nt) C1{ m FC2{ m FL[2]}}


void  S15666C10_nt ::mf15666c10(){}

//skip512 S15666C10_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C9_nt  {
  ::S15666C10_nt s15666c9f0;
  ::S15666C10_nt s15666c9f1;
  ::S15666C10_nt s15666c9f2;
  ::S15666C10_nt s15666c9f3;
  void  mf15666c9(); // _ZN11S15666C9_nt9mf15666c9Ev
};
//SIG(-1 S15666C9_nt) C1{ m FC2{ m FC3{ m FL[2]}} FC2 FC2 FC2}


void  S15666C9_nt ::mf15666c9(){}

//skip512 S15666C9_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C7_nt  : S15666C8_nt {
  ::S15666C9_nt s15666c7f0;
};
//SIG(-1 S15666C7_nt) C1{ BC2{ m Fp Fi Fp Fi[2]} FC3{ m FC4{ m FC5{ m FL[2]}} FC4 FC4 FC4}}



//skip512 S15666C7_nt

#else // __cplusplus

extern Class_Descriptor cd_S15666C8_nt;
static Base_Class bases_S15666C7_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15666C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C14_nt  {
  void *s15666c14f0;
  int s15666c14f1[2];
  ::S694C11_nt s15666c14f2;
  void  mf15666c14(); // _ZN12S15666C14_nt10mf15666c14Ev
};
//SIG(-1 S15666C14_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S15666C14_nt ::mf15666c14(){}

//skip512 S15666C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C13_nt  {
  ::S15666C14_nt s15666c13f0;
  void  mf15666c13(); // _ZN12S15666C13_nt10mf15666c13Ev
};
//SIG(-1 S15666C13_nt) C1{ m FC2{ m Fp Fi[2] FC3{ m}}}


void  S15666C13_nt ::mf15666c13(){}

//skip512 S15666C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C12_nt  : S15666C8_nt {
  ::S15666C13_nt s15666c12f0;
};
//SIG(-1 S15666C12_nt) C1{ BC2{ m Fp Fi Fp Fi[2]} FC3{ m FC4{ m Fp Fi[2] FC5{ m}}}}



//skip512 S15666C12_nt

#else // __cplusplus

extern Class_Descriptor cd_S15666C8_nt;
static Base_Class bases_S15666C12_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15666C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C16_nt  : S15666C8_nt {
  ::S15666C10_nt s15666c16f0;
};
//SIG(-1 S15666C16_nt) C1{ BC2{ m Fp Fi Fp Fi[2]} FC3{ m FC4{ m FL[2]}}}



//skip512 S15666C16_nt

#else // __cplusplus

extern Class_Descriptor cd_S15666C8_nt;
static Base_Class bases_S15666C16_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15666C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C3  : S15666C4_nt , S15666C6_nt {
  ::S15666C7_nt s15666c3f0;
  ::S15666C12_nt s15666c3f1;
  ::S15666C12_nt s15666c3f2;
  ::S15666C16_nt s15666c3f3;
  virtual void  v1(); // _ZN8S15666C32v1Ev
  virtual void  v2(); // _ZN8S15666C32v2Ev
  virtual void  v3(); // _ZN8S15666C32v3Ev
  virtual void  v4(); // _ZN8S15666C32v4Ev
  virtual void  v5(); // _ZN8S15666C32v5Ev
  virtual void  v6(); // _ZN8S15666C32v6Ev
  ~S15666C3(); // tgen
  S15666C3(); // tgen
};
//SIG(-1 S15666C3) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8}} FC10{ BC6 FC11{ m FC12{ m Fp Fi[2] FC13{ m}}}} FC10 FC14{ BC6 FC8}}


void  S15666C3 ::v1(){vfunc_called(this, "_ZN8S15666C32v1Ev");}
void  S15666C3 ::v2(){vfunc_called(this, "_ZN8S15666C32v2Ev");}
void  S15666C3 ::v3(){vfunc_called(this, "_ZN8S15666C32v3Ev");}
void  S15666C3 ::v4(){vfunc_called(this, "_ZN8S15666C32v4Ev");}
void  S15666C3 ::v5(){vfunc_called(this, "_ZN8S15666C32v5Ev");}
void  S15666C3 ::v6(){vfunc_called(this, "_ZN8S15666C32v6Ev");}
S15666C3 ::~S15666C3(){ note_dtor("S15666C3", this);} // tgen
S15666C3 ::S15666C3(){ note_ctor("S15666C3", this);} // tgen

static void Test_S15666C3()
{
  extern Class_Descriptor cd_S15666C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(38,54)];
    init_test(&cd_S15666C3, buf);
    S15666C3 *dp, &lv = *(dp=new (buf) S15666C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(296,212), "sizeof(S15666C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15666C3)");
    check_base_class_offset(lv, (S15666C4_nt*), 0, "S15666C3");
    check_base_class_offset(lv, (S15666C6_nt*), 0, "S15666C3");
    check_field_offset(lv, s15666c3f0, ABISELECT(40,20), "S15666C3.s15666c3f0");
    check_field_offset(lv, s15666c3f1, ABISELECT(136,104), "S15666C3.s15666c3f1");
    check_field_offset(lv, s15666c3f2, ABISELECT(192,140), "S15666C3.s15666c3f2");
    check_field_offset(lv, s15666c3f3, ABISELECT(248,176), "S15666C3.s15666c3f3");
    test_class_info(&lv, &cd_S15666C3);
    dp->~S15666C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15666C3(Test_S15666C3, "S15666C3", ABISELECT(296,212));

#else // __cplusplus

extern void _ZN8S15666C3C1Ev();
extern void _ZN8S15666C3D1Ev();
Name_Map name_map_S15666C3[] = {
  NSPAIR(_ZN8S15666C3C1Ev),
  NSPAIR(_ZN8S15666C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15666C4_nt;
extern VTBL_ENTRY _ZTI11S15666C4_nt[];
extern  VTBL_ENTRY _ZTV11S15666C4_nt[];
extern Class_Descriptor cd_S15666C6_nt;
extern VTBL_ENTRY _ZTI11S15666C6_nt[];
static Base_Class bases_S15666C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15666C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S15666C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S15666C3[];
extern void _ZN8S15666C3D1Ev();
extern void _ZN8S15666C3D0Ev();
extern void _ZN11S15666C4_nt2v7Ev();
extern void _ZN11S15666C4_nt2v8Ev();
extern void _ZN11S15666C4_nt2v9Ev();
extern void _ZN11S15666C4_nt3v10Ev();
extern void _ZN11S15666C4_nt3v11Ev();
extern void _ZN11S15666C4_nt3v12Ev();
extern void _ZN8S15666C32v1Ev();
extern void _ZN8S15666C32v2Ev();
extern void _ZN8S15666C32v3Ev();
extern void _ZN8S15666C32v4Ev();
extern void _ZN8S15666C32v5Ev();
extern void _ZN8S15666C32v6Ev();
static  VTBL_ENTRY vtc_S15666C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S15666C3[0]),
  (VTBL_ENTRY)&_ZN8S15666C3D1Ev,
  (VTBL_ENTRY)&_ZN8S15666C3D0Ev,
  (VTBL_ENTRY)&_ZN11S15666C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S15666C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN11S15666C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN11S15666C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN11S15666C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN11S15666C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S15666C32v1Ev,
  (VTBL_ENTRY)&_ZN8S15666C32v2Ev,
  (VTBL_ENTRY)&_ZN8S15666C32v3Ev,
  (VTBL_ENTRY)&_ZN8S15666C32v4Ev,
  (VTBL_ENTRY)&_ZN8S15666C32v5Ev,
  (VTBL_ENTRY)&_ZN8S15666C32v6Ev,
};
extern VTBL_ENTRY _ZTI8S15666C3[];
extern  VTBL_ENTRY _ZTV8S15666C3[];
Class_Descriptor cd_S15666C3 = {  "S15666C3", // class name
  bases_S15666C3, 2,
  &(vtc_S15666C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,212), // object size
  NSPAIRA(_ZTI8S15666C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S15666C3),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C19_nt  {
  virtual  ~S15666C19_nt(); // _ZN12S15666C19_ntD1Ev
  virtual void  v13(); // _ZN12S15666C19_nt3v13Ev
  S15666C19_nt(); // tgen
};
//SIG(-1 S15666C19_nt) C1{ vd v1}


 S15666C19_nt ::~S15666C19_nt(){ note_dtor("S15666C19_nt", this);}
void  S15666C19_nt ::v13(){vfunc_called(this, "_ZN12S15666C19_nt3v13Ev");}
S15666C19_nt ::S15666C19_nt(){ note_ctor("S15666C19_nt", this);} // tgen

//skip512 S15666C19_nt

#else // __cplusplus

extern void _ZN12S15666C19_ntC1Ev();
extern void _ZN12S15666C19_ntD1Ev();
Name_Map name_map_S15666C19_nt[] = {
  NSPAIR(_ZN12S15666C19_ntC1Ev),
  NSPAIR(_ZN12S15666C19_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI12S15666C19_nt[];
extern void _ZN12S15666C19_ntD1Ev();
extern void _ZN12S15666C19_ntD0Ev();
extern void _ZN12S15666C19_nt3v13Ev();
static  VTBL_ENTRY vtc_S15666C19_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S15666C19_nt[0]),
  (VTBL_ENTRY)&_ZN12S15666C19_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S15666C19_ntD0Ev,
  (VTBL_ENTRY)&_ZN12S15666C19_nt3v13Ev,
};
extern VTBL_ENTRY _ZTI12S15666C19_nt[];
VTBL_ENTRY *P__ZTI12S15666C19_nt = _ZTI12S15666C19_nt; 
extern  VTBL_ENTRY _ZTV12S15666C19_nt[];
Class_Descriptor cd_S15666C19_nt = {  "S15666C19_nt", // class name
  0,0,//no base classes
  &(vtc_S15666C19_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI12S15666C19_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV12S15666C19_nt),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C23_nt  {
  void *s15666c23f0[2];
  void  mf15666c23(); // _ZN12S15666C23_nt10mf15666c23Ev
};
//SIG(-1 S15666C23_nt) C1{ m Fp[2]}


void  S15666C23_nt ::mf15666c23(){}

//skip512 S15666C23_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C18_nt  : S15666C19_nt {
  void *s15666c18f0[2];
  ::S15666C13_nt s15666c18f1;
  ::S15666C23_nt s15666c18f2;
  virtual  ~S15666C18_nt(); // _ZN12S15666C18_ntD1Ev
  virtual void  v14(); // _ZN12S15666C18_nt3v14Ev
  S15666C18_nt(); // tgen
};
//SIG(-1 S15666C18_nt) C1{ BC2{ vd v2} vd v1 Fp[2] FC3{ m FC4{ m Fp Fi[2] FC5{ m}}} FC6{ m Fp[2]}}


 S15666C18_nt ::~S15666C18_nt(){ note_dtor("S15666C18_nt", this);}
void  S15666C18_nt ::v14(){vfunc_called(this, "_ZN12S15666C18_nt3v14Ev");}
S15666C18_nt ::S15666C18_nt(){ note_ctor("S15666C18_nt", this);} // tgen

//skip512 S15666C18_nt

#else // __cplusplus

extern void _ZN12S15666C18_ntC1Ev();
extern void _ZN12S15666C18_ntD1Ev();
Name_Map name_map_S15666C18_nt[] = {
  NSPAIR(_ZN12S15666C18_ntC1Ev),
  NSPAIR(_ZN12S15666C18_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15666C19_nt;
extern VTBL_ENTRY _ZTI12S15666C19_nt[];
extern  VTBL_ENTRY _ZTV12S15666C19_nt[];
static Base_Class bases_S15666C18_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15666C19_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI12S15666C18_nt[];
extern void _ZN12S15666C18_ntD1Ev();
extern void _ZN12S15666C18_ntD0Ev();
extern void _ZN12S15666C19_nt3v13Ev();
extern void _ZN12S15666C18_nt3v14Ev();
static  VTBL_ENTRY vtc_S15666C18_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S15666C18_nt[0]),
  (VTBL_ENTRY)&_ZN12S15666C18_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S15666C18_ntD0Ev,
  (VTBL_ENTRY)&_ZN12S15666C19_nt3v13Ev,
  (VTBL_ENTRY)&_ZN12S15666C18_nt3v14Ev,
};
extern VTBL_ENTRY _ZTI12S15666C18_nt[];
VTBL_ENTRY *P__ZTI12S15666C18_nt = _ZTI12S15666C18_nt; 
extern  VTBL_ENTRY _ZTV12S15666C18_nt[];
Class_Descriptor cd_S15666C18_nt = {  "S15666C18_nt", // class name
  bases_S15666C18_nt, 1,
  &(vtc_S15666C18_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI12S15666C18_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV12S15666C18_nt),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C25_nt  {
  short s15666c25f0[2];
  char s15666c25f1[2];
  short s15666c25f2;
};
//SIG(1 S15666C25_nt) C1{ Fs[2] Fc[2] Fs}



//skip512 S15666C25_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C26_nt  {
  short s15666c26f0[2];
};
//SIG(1 S15666C26_nt) C1{ Fs[2]}



//skip512 S15666C26_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C24_nt  {
  ::S15666C25_nt s15666c24f0[12];
  int s15666c24f1;
  ::S15666C26_nt s15666c24f2[4];
  int s15666c24f3;
  ::S15666C23_nt s15666c24f4;
  void  mf15666c24(); // _ZN12S15666C24_nt10mf15666c24Ev
};
//SIG(-1 S15666C24_nt) C1{ m FC2{ Fs[2] Fc[2] Fs}[12] Fi FC3{ Fs[2]}[4] Fi FC4{ m Fp[2]}}


void  S15666C24_nt ::mf15666c24(){}

//skip512 S15666C24_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C17_nt  : S15666C18_nt {
  ::S15666C24_nt s15666c17f0;
  virtual  ~S15666C17_nt(); // _ZN12S15666C17_ntD1Ev
  S15666C17_nt(); // tgen
};
//SIG(-1 S15666C17_nt) C1{ BC2{ BC3{ vd v1} vd v2 Fp[2] FC4{ m FC5{ m Fp Fi[2] FC6{ m}}} FC7{ m Fp[2]}} vd FC8{ m FC9{ Fs[2] Fc[2] Fs}[12] Fi FC10{ Fs[2]}[4] Fi FC7}}


 S15666C17_nt ::~S15666C17_nt(){ note_dtor("S15666C17_nt", this);}
S15666C17_nt ::S15666C17_nt(){ note_ctor("S15666C17_nt", this);} // tgen

//skip512 S15666C17_nt

#else // __cplusplus

extern void _ZN12S15666C17_ntC1Ev();
extern void _ZN12S15666C17_ntD1Ev();
Name_Map name_map_S15666C17_nt[] = {
  NSPAIR(_ZN12S15666C17_ntC1Ev),
  NSPAIR(_ZN12S15666C17_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15666C19_nt;
extern VTBL_ENTRY _ZTI12S15666C19_nt[];
extern  VTBL_ENTRY _ZTV12S15666C19_nt[];
extern Class_Descriptor cd_S15666C18_nt;
extern VTBL_ENTRY _ZTI12S15666C18_nt[];
extern  VTBL_ENTRY _ZTV12S15666C18_nt[];
static Base_Class bases_S15666C17_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15666C19_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15666C18_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI12S15666C17_nt[];
extern void _ZN12S15666C17_ntD1Ev();
extern void _ZN12S15666C17_ntD0Ev();
extern void _ZN12S15666C19_nt3v13Ev();
extern void _ZN12S15666C18_nt3v14Ev();
static  VTBL_ENTRY vtc_S15666C17_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S15666C17_nt[0]),
  (VTBL_ENTRY)&_ZN12S15666C17_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S15666C17_ntD0Ev,
  (VTBL_ENTRY)&_ZN12S15666C19_nt3v13Ev,
  (VTBL_ENTRY)&_ZN12S15666C18_nt3v14Ev,
};
extern VTBL_ENTRY _ZTI12S15666C17_nt[];
VTBL_ENTRY *P__ZTI12S15666C17_nt = _ZTI12S15666C17_nt; 
extern  VTBL_ENTRY _ZTV12S15666C17_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C2  {
  ::S15666C3 s15666c2f0;
  ::S15666C17_nt s15666c2f1;
  void  mf15666c2(); // _ZN8S15666C29mf15666c2Ev
};
//SIG(-1 S15666C2) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m FC10{ m FL[2]}} FC9 FC9 FC9}} FC11{ BC7 FC12{ m FC13{ m Fp Fi[2] FC14{ m}}}} FC11 FC15{ BC7 FC9}} FC16{ BC17{ BC18{ vd v13} vd v14 Fp[2] FC12 FC19{ m Fp[2]}} vd FC20{ m FC21{ Fs[2] Fc[2] Fs}[12] Fi FC22{ Fs[2]}[4] Fi FC19}}}


void  S15666C2 ::mf15666c2(){}

static void Test_S15666C2()
{
  {
    init_simple_test("S15666C2");
    S15666C2 lv;
    check2(sizeof(lv), ABISELECT(496,376), "sizeof(S15666C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15666C2)");
    check_field_offset(lv, s15666c2f0, 0, "S15666C2.s15666c2f0");
    check_field_offset(lv, s15666c2f1, ABISELECT(296,212), "S15666C2.s15666c2f1");
  }
}
static Arrange_To_Call_Me vS15666C2(Test_S15666C2, "S15666C2", ABISELECT(496,376));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C32  {
  void *s15666c32f0[2];
  void  mf15666c32(); // _ZN9S15666C3210mf15666c32Ev
};
//SIG(-1 S15666C32) C1{ m Fp[2]}


void  S15666C32 ::mf15666c32(){}

static void Test_S15666C32()
{
  {
    init_simple_test("S15666C32");
    S15666C32 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S15666C32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15666C32)");
    check_field_offset(lv, s15666c32f0, 0, "S15666C32.s15666c32f0");
  }
}
static Arrange_To_Call_Me vS15666C32(Test_S15666C32, "S15666C32", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C33_nt  {
  void *s15666c33f0;
  void  mf15666c33(); // _ZN12S15666C33_nt10mf15666c33Ev
};
//SIG(-1 S15666C33_nt) C1{ m Fp}


void  S15666C33_nt ::mf15666c33(){}

//skip512 S15666C33_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C31_nt  {
  ::S15666C32 s15666c31f0;
  ::S15666C33_nt s15666c31f1;
  void  mf15666c31(); // _ZN12S15666C31_nt10mf15666c31Ev
};
//SIG(-1 S15666C31_nt) C1{ m FC2{ m Fp[2]} FC3{ m Fp}}


void  S15666C31_nt ::mf15666c31(){}

//skip512 S15666C31_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C30_nt  : S15666C8_nt {
  ::S15666C31_nt s15666c30f0;
};
//SIG(-1 S15666C30_nt) C1{ BC2{ m Fp Fi Fp Fi[2]} FC3{ m FC4{ m Fp[2]} FC5{ m Fp}}}



//skip512 S15666C30_nt

#else // __cplusplus

extern Class_Descriptor cd_S15666C8_nt;
static Base_Class bases_S15666C30_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15666C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C29  : S15666C4_nt , S15666C6_nt {
  ::S15666C16_nt s15666c29f0;
  ::S15666C30_nt s15666c29f1;
  virtual void  v15(); // _ZN9S15666C293v15Ev
  virtual void  v16(); // _ZN9S15666C293v16Ev
  virtual void  v17(); // _ZN9S15666C293v17Ev
  virtual void  v18(); // _ZN9S15666C293v18Ev
  virtual void  v19(); // _ZN9S15666C293v19Ev
  virtual void  v20(); // _ZN9S15666C293v20Ev
  ~S15666C29(); // tgen
  S15666C29(); // tgen
};
//SIG(-1 S15666C29) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m FL[2]}}} FC9{ BC6 FC10{ m FC11{ m Fp[2]} FC12{ m Fp}}}}


void  S15666C29 ::v15(){vfunc_called(this, "_ZN9S15666C293v15Ev");}
void  S15666C29 ::v16(){vfunc_called(this, "_ZN9S15666C293v16Ev");}
void  S15666C29 ::v17(){vfunc_called(this, "_ZN9S15666C293v17Ev");}
void  S15666C29 ::v18(){vfunc_called(this, "_ZN9S15666C293v18Ev");}
void  S15666C29 ::v19(){vfunc_called(this, "_ZN9S15666C293v19Ev");}
void  S15666C29 ::v20(){vfunc_called(this, "_ZN9S15666C293v20Ev");}
S15666C29 ::~S15666C29(){ note_dtor("S15666C29", this);} // tgen
S15666C29 ::S15666C29(){ note_ctor("S15666C29", this);} // tgen

static void Test_S15666C29()
{
  extern Class_Descriptor cd_S15666C29;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,23)];
    init_test(&cd_S15666C29, buf);
    S15666C29 *dp, &lv = *(dp=new (buf) S15666C29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,88), "sizeof(S15666C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15666C29)");
    check_base_class_offset(lv, (S15666C4_nt*), 0, "S15666C29");
    check_base_class_offset(lv, (S15666C6_nt*), 0, "S15666C29");
    check_field_offset(lv, s15666c29f0, ABISELECT(40,20), "S15666C29.s15666c29f0");
    check_field_offset(lv, s15666c29f1, ABISELECT(88,56), "S15666C29.s15666c29f1");
    test_class_info(&lv, &cd_S15666C29);
    dp->~S15666C29();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15666C29(Test_S15666C29, "S15666C29", ABISELECT(144,88));

#else // __cplusplus

extern void _ZN9S15666C29C1Ev();
extern void _ZN9S15666C29D1Ev();
Name_Map name_map_S15666C29[] = {
  NSPAIR(_ZN9S15666C29C1Ev),
  NSPAIR(_ZN9S15666C29D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15666C4_nt;
extern VTBL_ENTRY _ZTI11S15666C4_nt[];
extern  VTBL_ENTRY _ZTV11S15666C4_nt[];
extern Class_Descriptor cd_S15666C6_nt;
extern VTBL_ENTRY _ZTI11S15666C6_nt[];
static Base_Class bases_S15666C29[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15666C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S15666C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S15666C29[];
extern void _ZN9S15666C29D1Ev();
extern void _ZN9S15666C29D0Ev();
extern void _ZN11S15666C4_nt2v7Ev();
extern void _ZN11S15666C4_nt2v8Ev();
extern void _ZN11S15666C4_nt2v9Ev();
extern void _ZN11S15666C4_nt3v10Ev();
extern void _ZN11S15666C4_nt3v11Ev();
extern void _ZN11S15666C4_nt3v12Ev();
extern void _ZN9S15666C293v15Ev();
extern void _ZN9S15666C293v16Ev();
extern void _ZN9S15666C293v17Ev();
extern void _ZN9S15666C293v18Ev();
extern void _ZN9S15666C293v19Ev();
extern void _ZN9S15666C293v20Ev();
static  VTBL_ENTRY vtc_S15666C29[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S15666C29[0]),
  (VTBL_ENTRY)&_ZN9S15666C29D1Ev,
  (VTBL_ENTRY)&_ZN9S15666C29D0Ev,
  (VTBL_ENTRY)&_ZN11S15666C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S15666C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN11S15666C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN11S15666C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN11S15666C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN11S15666C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S15666C293v15Ev,
  (VTBL_ENTRY)&_ZN9S15666C293v16Ev,
  (VTBL_ENTRY)&_ZN9S15666C293v17Ev,
  (VTBL_ENTRY)&_ZN9S15666C293v18Ev,
  (VTBL_ENTRY)&_ZN9S15666C293v19Ev,
  (VTBL_ENTRY)&_ZN9S15666C293v20Ev,
};
extern VTBL_ENTRY _ZTI9S15666C29[];
extern  VTBL_ENTRY _ZTV9S15666C29[];
Class_Descriptor cd_S15666C29 = {  "S15666C29", // class name
  bases_S15666C29, 2,
  &(vtc_S15666C29[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,88), // object size
  NSPAIRA(_ZTI9S15666C29),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S15666C29),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C36  {
  ::S15666C14_nt s15666c36f0;
  void  mf15666c36(); // _ZN9S15666C3610mf15666c36Ev
};
//SIG(-1 S15666C36) C1{ m FC2{ m Fp Fi[2] FC3{ m}}}


void  S15666C36 ::mf15666c36(){}

static void Test_S15666C36()
{
  {
    init_simple_test("S15666C36");
    S15666C36 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S15666C36)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15666C36)");
    check_field_offset(lv, s15666c36f0, 0, "S15666C36.s15666c36f0");
  }
}
static Arrange_To_Call_Me vS15666C36(Test_S15666C36, "S15666C36", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C35  : S15666C19_nt {
  void *s15666c35f0[2];
  ::S15666C36 s15666c35f1;
  ::S15666C32 s15666c35f2;
  virtual  ~S15666C35(); // _ZN9S15666C35D1Ev
  virtual void  v21(); // _ZN9S15666C353v21Ev
  S15666C35(); // tgen
};
//SIG(-1 S15666C35) C1{ BC2{ vd v2} vd v1 Fp[2] FC3{ m FC4{ m Fp Fi[2] FC5{ m}}} FC6{ m Fp[2]}}


 S15666C35 ::~S15666C35(){ note_dtor("S15666C35", this);}
void  S15666C35 ::v21(){vfunc_called(this, "_ZN9S15666C353v21Ev");}
S15666C35 ::S15666C35(){ note_ctor("S15666C35", this);} // tgen

static void Test_S15666C35()
{
  extern Class_Descriptor cd_S15666C35;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_S15666C35, buf);
    S15666C35 *dp, &lv = *(dp=new (buf) S15666C35());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(S15666C35)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15666C35)");
    check_base_class_offset(lv, (S15666C19_nt*), 0, "S15666C35");
    check_field_offset(lv, s15666c35f0, ABISELECT(8,4), "S15666C35.s15666c35f0");
    check_field_offset(lv, s15666c35f1, ABISELECT(24,12), "S15666C35.s15666c35f1");
    check_field_offset(lv, s15666c35f2, ABISELECT(48,28), "S15666C35.s15666c35f2");
    test_class_info(&lv, &cd_S15666C35);
    dp->~S15666C35();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15666C35(Test_S15666C35, "S15666C35", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN9S15666C35C1Ev();
extern void _ZN9S15666C35D1Ev();
Name_Map name_map_S15666C35[] = {
  NSPAIR(_ZN9S15666C35C1Ev),
  NSPAIR(_ZN9S15666C35D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15666C19_nt;
extern VTBL_ENTRY _ZTI12S15666C19_nt[];
extern  VTBL_ENTRY _ZTV12S15666C19_nt[];
static Base_Class bases_S15666C35[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15666C19_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S15666C35[];
extern void _ZN9S15666C35D1Ev();
extern void _ZN9S15666C35D0Ev();
extern void _ZN12S15666C19_nt3v13Ev();
extern void _ZN9S15666C353v21Ev();
static  VTBL_ENTRY vtc_S15666C35[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S15666C35[0]),
  (VTBL_ENTRY)&_ZN9S15666C35D1Ev,
  (VTBL_ENTRY)&_ZN9S15666C35D0Ev,
  (VTBL_ENTRY)&_ZN12S15666C19_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S15666C353v21Ev,
};
extern VTBL_ENTRY _ZTI9S15666C35[];
extern  VTBL_ENTRY _ZTV9S15666C35[];
Class_Descriptor cd_S15666C35 = {  "S15666C35", // class name
  bases_S15666C35, 1,
  &(vtc_S15666C35[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI9S15666C35),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S15666C35),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C41_nt  {
  char s15666c41f0;
  char s15666c41f1:4;
  char s15666c41f2:4;
  char s15666c41f3:4;
  char s15666c41f4:4;
  char s15666c41f5:4;
  char s15666c41f6:4;
};
//SIG(-1 S15666C41_nt) C1{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4}



//skip512 S15666C41_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C40_nt  {
  void *s15666c40f0;
  int s15666c40f1;
  ::S15666C41_nt s15666c40f2;
  int s15666c40f3;
  ::S15666C23_nt s15666c40f4;
  void  mf15666c40(); // _ZN12S15666C40_nt10mf15666c40Ev
};
//SIG(-1 S15666C40_nt) C1{ m Fp Fi FC2{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC3{ m Fp[2]}}


void  S15666C40_nt ::mf15666c40(){}

//skip512 S15666C40_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C34_nt  : S15666C35 {
  ::S15666C40_nt s15666c34f0;
  virtual  ~S15666C34_nt(); // _ZN12S15666C34_ntD1Ev
  S15666C34_nt(); // tgen
};
//SIG(-1 S15666C34_nt) C1{ BC2{ BC3{ vd v1} vd v2 Fp[2] FC4{ m FC5{ m Fp Fi[2] FC6{ m}}} FC7{ m Fp[2]}} vd FC8{ m Fp Fi FC9{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC10{ m Fp[2]}}}


 S15666C34_nt ::~S15666C34_nt(){ note_dtor("S15666C34_nt", this);}
S15666C34_nt ::S15666C34_nt(){ note_ctor("S15666C34_nt", this);} // tgen

//skip512 S15666C34_nt

#else // __cplusplus

extern void _ZN12S15666C34_ntC1Ev();
extern void _ZN12S15666C34_ntD1Ev();
Name_Map name_map_S15666C34_nt[] = {
  NSPAIR(_ZN12S15666C34_ntC1Ev),
  NSPAIR(_ZN12S15666C34_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15666C19_nt;
extern VTBL_ENTRY _ZTI12S15666C19_nt[];
extern  VTBL_ENTRY _ZTV12S15666C19_nt[];
extern Class_Descriptor cd_S15666C35;
extern VTBL_ENTRY _ZTI9S15666C35[];
extern  VTBL_ENTRY _ZTV9S15666C35[];
static Base_Class bases_S15666C34_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15666C19_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15666C35,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI12S15666C34_nt[];
extern void _ZN12S15666C34_ntD1Ev();
extern void _ZN12S15666C34_ntD0Ev();
extern void _ZN12S15666C19_nt3v13Ev();
extern void _ZN9S15666C353v21Ev();
static  VTBL_ENTRY vtc_S15666C34_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S15666C34_nt[0]),
  (VTBL_ENTRY)&_ZN12S15666C34_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S15666C34_ntD0Ev,
  (VTBL_ENTRY)&_ZN12S15666C19_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S15666C353v21Ev,
};
extern VTBL_ENTRY _ZTI12S15666C34_nt[];
VTBL_ENTRY *P__ZTI12S15666C34_nt = _ZTI12S15666C34_nt; 
extern  VTBL_ENTRY _ZTV12S15666C34_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C28  {
  ::S15666C29 s15666c28f0;
  ::S15666C34_nt s15666c28f1;
  void  mf15666c28(); // _ZN9S15666C2810mf15666c28Ev
};
//SIG(-1 S15666C28) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m FL[2]}}} FC10{ BC7 FC11{ m FC12{ m Fp[2]} FC13{ m Fp}}}} FC14{ BC15{ BC16{ vd v13} vd v14 Fp[2] FC17{ m FC18{ m Fp Fi[2] FC19{ m}}} FC12} vd FC20{ m Fp Fi FC21{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC22{ m Fp[2]}}}}


void  S15666C28 ::mf15666c28(){}

static void Test_S15666C28()
{
  {
    init_simple_test("S15666C28");
    static S15666C28 lv;
    check2(sizeof(lv), ABISELECT(248,148), "sizeof(S15666C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15666C28)");
    check_field_offset(lv, s15666c28f0, 0, "S15666C28.s15666c28f0");
    check_field_offset(lv, s15666c28f1, ABISELECT(144,88), "S15666C28.s15666c28f1");
  }
}
static Arrange_To_Call_Me vS15666C28(Test_S15666C28, "S15666C28", ABISELECT(248,148));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C43  : S15666C4_nt , S15666C6_nt {
  ::S15666C7_nt s15666c43f0;
  ::S15666C12_nt s15666c43f1;
  ::S15666C12_nt s15666c43f2;
  ::S15666C16_nt s15666c43f3;
  ::S15666C16_nt s15666c43f4;
  ::S15666C7_nt s15666c43f5;
  ::S15666C7_nt s15666c43f6;
  ::S15666C7_nt s15666c43f7;
  ::S15666C16_nt s15666c43f8;
  ::S15666C7_nt s15666c43f9;
  ::S15666C16_nt s15666c43f10;
  virtual void  v22(); // _ZN9S15666C433v22Ev
  virtual void  v23(); // _ZN9S15666C433v23Ev
  virtual void  v24(); // _ZN9S15666C433v24Ev
  virtual void  v25(); // _ZN9S15666C433v25Ev
  virtual void  v26(); // _ZN9S15666C433v26Ev
  virtual void  v27(); // _ZN9S15666C433v27Ev
  ~S15666C43(); // tgen
  S15666C43(); // tgen
};
//SIG(-1 S15666C43) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8}} FC10{ BC6 FC11{ m FC12{ m Fp Fi[2] FC13{ m}}}} FC10 FC14{ BC6 FC8} FC14 FC5 FC5 FC5 FC14 FC5 FC14}


void  S15666C43 ::v22(){vfunc_called(this, "_ZN9S15666C433v22Ev");}
void  S15666C43 ::v23(){vfunc_called(this, "_ZN9S15666C433v23Ev");}
void  S15666C43 ::v24(){vfunc_called(this, "_ZN9S15666C433v24Ev");}
void  S15666C43 ::v25(){vfunc_called(this, "_ZN9S15666C433v25Ev");}
void  S15666C43 ::v26(){vfunc_called(this, "_ZN9S15666C433v26Ev");}
void  S15666C43 ::v27(){vfunc_called(this, "_ZN9S15666C433v27Ev");}
S15666C43 ::~S15666C43(){ note_dtor("S15666C43", this);} // tgen
S15666C43 ::S15666C43(){ note_ctor("S15666C43", this);} // tgen

static void Test_S15666C43()
{
  extern Class_Descriptor cd_S15666C43;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(104,165)];
    init_test(&cd_S15666C43, buf);
    S15666C43 *dp, &lv = *(dp=new (buf) S15666C43());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(824,656), "sizeof(S15666C43)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15666C43)");
    check_base_class_offset(lv, (S15666C4_nt*), 0, "S15666C43");
    check_base_class_offset(lv, (S15666C6_nt*), 0, "S15666C43");
    check_field_offset(lv, s15666c43f0, ABISELECT(40,20), "S15666C43.s15666c43f0");
    check_field_offset(lv, s15666c43f1, ABISELECT(136,104), "S15666C43.s15666c43f1");
    check_field_offset(lv, s15666c43f2, ABISELECT(192,140), "S15666C43.s15666c43f2");
    check_field_offset(lv, s15666c43f3, ABISELECT(248,176), "S15666C43.s15666c43f3");
    check_field_offset(lv, s15666c43f4, ABISELECT(296,212), "S15666C43.s15666c43f4");
    check_field_offset(lv, s15666c43f5, ABISELECT(344,248), "S15666C43.s15666c43f5");
    check_field_offset(lv, s15666c43f6, ABISELECT(440,332), "S15666C43.s15666c43f6");
    check_field_offset(lv, s15666c43f7, ABISELECT(536,416), "S15666C43.s15666c43f7");
    check_field_offset(lv, s15666c43f8, ABISELECT(632,500), "S15666C43.s15666c43f8");
    check_field_offset(lv, s15666c43f9, ABISELECT(680,536), "S15666C43.s15666c43f9");
    check_field_offset(lv, s15666c43f10, ABISELECT(776,620), "S15666C43.s15666c43f10");
    test_class_info(&lv, &cd_S15666C43);
    dp->~S15666C43();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15666C43(Test_S15666C43, "S15666C43", ABISELECT(824,656));

#else // __cplusplus

extern void _ZN9S15666C43C1Ev();
extern void _ZN9S15666C43D1Ev();
Name_Map name_map_S15666C43[] = {
  NSPAIR(_ZN9S15666C43C1Ev),
  NSPAIR(_ZN9S15666C43D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15666C4_nt;
extern VTBL_ENTRY _ZTI11S15666C4_nt[];
extern  VTBL_ENTRY _ZTV11S15666C4_nt[];
extern Class_Descriptor cd_S15666C6_nt;
extern VTBL_ENTRY _ZTI11S15666C6_nt[];
static Base_Class bases_S15666C43[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15666C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S15666C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S15666C43[];
extern void _ZN9S15666C43D1Ev();
extern void _ZN9S15666C43D0Ev();
extern void _ZN11S15666C4_nt2v7Ev();
extern void _ZN11S15666C4_nt2v8Ev();
extern void _ZN11S15666C4_nt2v9Ev();
extern void _ZN11S15666C4_nt3v10Ev();
extern void _ZN11S15666C4_nt3v11Ev();
extern void _ZN11S15666C4_nt3v12Ev();
extern void _ZN9S15666C433v22Ev();
extern void _ZN9S15666C433v23Ev();
extern void _ZN9S15666C433v24Ev();
extern void _ZN9S15666C433v25Ev();
extern void _ZN9S15666C433v26Ev();
extern void _ZN9S15666C433v27Ev();
static  VTBL_ENTRY vtc_S15666C43[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S15666C43[0]),
  (VTBL_ENTRY)&_ZN9S15666C43D1Ev,
  (VTBL_ENTRY)&_ZN9S15666C43D0Ev,
  (VTBL_ENTRY)&_ZN11S15666C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S15666C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN11S15666C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN11S15666C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN11S15666C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN11S15666C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S15666C433v22Ev,
  (VTBL_ENTRY)&_ZN9S15666C433v23Ev,
  (VTBL_ENTRY)&_ZN9S15666C433v24Ev,
  (VTBL_ENTRY)&_ZN9S15666C433v25Ev,
  (VTBL_ENTRY)&_ZN9S15666C433v26Ev,
  (VTBL_ENTRY)&_ZN9S15666C433v27Ev,
};
extern VTBL_ENTRY _ZTI9S15666C43[];
extern  VTBL_ENTRY _ZTV9S15666C43[];
Class_Descriptor cd_S15666C43 = {  "S15666C43", // class name
  bases_S15666C43, 2,
  &(vtc_S15666C43[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(824,656), // object size
  NSPAIRA(_ZTI9S15666C43),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S15666C43),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C42  {
  ::S15666C43 s15666c42f0;
  ::S15666C17_nt s15666c42f1;
  void  mf15666c42(); // _ZN9S15666C4210mf15666c42Ev
};
//SIG(-1 S15666C42) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m FC10{ m FL[2]}} FC9 FC9 FC9}} FC11{ BC7 FC12{ m FC13{ m Fp Fi[2] FC14{ m}}}} FC11 FC15{ BC7 FC9} FC15 FC6 FC6 FC6 FC15 FC6 FC15} FC16{ BC17{ BC18{ vd v13} vd v14 Fp[2] FC12 FC19{ m Fp[2]}} vd FC20{ m FC21{ Fs[2] Fc[2] Fs}[12] Fi FC22{ Fs[2]}[4] Fi FC19}}}


void  S15666C42 ::mf15666c42(){}

static void Test_S15666C42()
{
  {
    init_simple_test("S15666C42");
    S15666C42 lv;
    check2(sizeof(lv), ABISELECT(1024,820), "sizeof(S15666C42)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15666C42)");
    check_field_offset(lv, s15666c42f0, 0, "S15666C42.s15666c42f0");
    check_field_offset(lv, s15666c42f1, ABISELECT(824,656), "S15666C42.s15666c42f1");
  }
}
static Arrange_To_Call_Me vS15666C42(Test_S15666C42, "S15666C42", ABISELECT(1024,820));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C48_nt  : S15666C4_nt , S15666C6_nt {
  ::S15666C30_nt s15666c48f0;
  virtual void  v28(); // _ZN12S15666C48_nt3v28Ev
  virtual void  v29(); // _ZN12S15666C48_nt3v29Ev
  virtual void  v30(); // _ZN12S15666C48_nt3v30Ev
  virtual void  v31(); // _ZN12S15666C48_nt3v31Ev
  virtual void  v32(); // _ZN12S15666C48_nt3v32Ev
  virtual void  v33(); // _ZN12S15666C48_nt3v33Ev
  ~S15666C48_nt(); // tgen
  S15666C48_nt(); // tgen
};
//SIG(-1 S15666C48_nt) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m Fp[2]} FC9{ m Fp}}}}


void  S15666C48_nt ::v28(){vfunc_called(this, "_ZN12S15666C48_nt3v28Ev");}
void  S15666C48_nt ::v29(){vfunc_called(this, "_ZN12S15666C48_nt3v29Ev");}
void  S15666C48_nt ::v30(){vfunc_called(this, "_ZN12S15666C48_nt3v30Ev");}
void  S15666C48_nt ::v31(){vfunc_called(this, "_ZN12S15666C48_nt3v31Ev");}
void  S15666C48_nt ::v32(){vfunc_called(this, "_ZN12S15666C48_nt3v32Ev");}
void  S15666C48_nt ::v33(){vfunc_called(this, "_ZN12S15666C48_nt3v33Ev");}
S15666C48_nt ::~S15666C48_nt(){ note_dtor("S15666C48_nt", this);} // tgen
S15666C48_nt ::S15666C48_nt(){ note_ctor("S15666C48_nt", this);} // tgen

//skip512 S15666C48_nt

#else // __cplusplus

extern void _ZN12S15666C48_ntC1Ev();
extern void _ZN12S15666C48_ntD1Ev();
Name_Map name_map_S15666C48_nt[] = {
  NSPAIR(_ZN12S15666C48_ntC1Ev),
  NSPAIR(_ZN12S15666C48_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15666C4_nt;
extern VTBL_ENTRY _ZTI11S15666C4_nt[];
extern  VTBL_ENTRY _ZTV11S15666C4_nt[];
extern Class_Descriptor cd_S15666C6_nt;
extern VTBL_ENTRY _ZTI11S15666C6_nt[];
static Base_Class bases_S15666C48_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15666C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S15666C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI12S15666C48_nt[];
extern void _ZN12S15666C48_ntD1Ev();
extern void _ZN12S15666C48_ntD0Ev();
extern void _ZN11S15666C4_nt2v7Ev();
extern void _ZN11S15666C4_nt2v8Ev();
extern void _ZN11S15666C4_nt2v9Ev();
extern void _ZN11S15666C4_nt3v10Ev();
extern void _ZN11S15666C4_nt3v11Ev();
extern void _ZN11S15666C4_nt3v12Ev();
extern void _ZN12S15666C48_nt3v28Ev();
extern void _ZN12S15666C48_nt3v29Ev();
extern void _ZN12S15666C48_nt3v30Ev();
extern void _ZN12S15666C48_nt3v31Ev();
extern void _ZN12S15666C48_nt3v32Ev();
extern void _ZN12S15666C48_nt3v33Ev();
static  VTBL_ENTRY vtc_S15666C48_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S15666C48_nt[0]),
  (VTBL_ENTRY)&_ZN12S15666C48_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S15666C48_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S15666C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S15666C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN11S15666C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN11S15666C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN11S15666C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN11S15666C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN12S15666C48_nt3v28Ev,
  (VTBL_ENTRY)&_ZN12S15666C48_nt3v29Ev,
  (VTBL_ENTRY)&_ZN12S15666C48_nt3v30Ev,
  (VTBL_ENTRY)&_ZN12S15666C48_nt3v31Ev,
  (VTBL_ENTRY)&_ZN12S15666C48_nt3v32Ev,
  (VTBL_ENTRY)&_ZN12S15666C48_nt3v33Ev,
};
extern VTBL_ENTRY _ZTI12S15666C48_nt[];
VTBL_ENTRY *P__ZTI12S15666C48_nt = _ZTI12S15666C48_nt; 
extern  VTBL_ENTRY _ZTV12S15666C48_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C47_nt  {
  ::S15666C48_nt s15666c47f0;
  ::S15666C34_nt s15666c47f1;
  void  mf15666c47(); // _ZN12S15666C47_nt10mf15666c47Ev
};
//SIG(-1 S15666C47_nt) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}}} FC11{ BC12{ BC13{ vd v13} vd v14 Fp[2] FC14{ m FC15{ m Fp Fi[2] FC16{ m}}} FC9} vd FC17{ m Fp Fi FC18{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC19{ m Fp[2]}}}}


void  S15666C47_nt ::mf15666c47(){}

//skip512 S15666C47_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15666C1  {
  ::S15666C2 s15666c1f0;
  ::S15666C28 s15666c1f1;
  ::S15666C42 s15666c1f2;
  ::S15666C47_nt s15666c1f3;
  void  mf15666c1(); // _ZN8S15666C19mf15666c1Ev
};
//SIG(1 S15666C1) C1{ m FC2{ m FC3{ BC4{ vd v7 v8 v9 v10 v11 v12 FC5{ m Fp[4]}} BC6{} v1 v2 v3 v4 v5 v6 FC7{ BC8{ m Fp Fi Fp Fi[2]} FC9{ m FC10{ m FC11{ m FL[2]}} FC10 FC10 FC10}} FC12{ BC8 FC13{ m FC14{ m Fp Fi[2] FC15{ m}}}} FC12 FC16{ BC8 FC10}} FC17{ BC18{ BC19{ vd v13} vd v14 Fp[2] FC13 FC20{ m Fp[2]}} vd FC21{ m FC22{ Fs[2] Fc[2] Fs}[12] Fi FC23{ Fs[2]}[4] Fi FC20}}} FC24{ m FC25{ BC4 BC6 v15 v16 v17 v18 v19 v20 FC16 FC26{ BC8 FC27{ m FC28{ m Fp[2]} FC29{ m Fp}}}} FC30{ BC31{ BC19 vd v21 Fp[2] FC32{ m FC14} FC28} vd FC33{ m Fp Fi FC34{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC20}}} FC35{ m FC36{ BC4 BC6 v22 v23 v24 v25 v26 v27 FC7 FC12 FC12 FC16 FC16 FC7 FC7 FC7 FC16 FC7 FC16} FC17} FC37{ m FC38{ BC4 BC6 v28 v29 v30 v31 v32 v33 FC26} FC30}}


void  S15666C1 ::mf15666c1(){}

static void Test_S15666C1()
{
  {
    init_simple_test("S15666C1");
    static S15666C1 lv;
    check2(sizeof(lv), ABISELECT(1968,1456), "sizeof(S15666C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15666C1)");
    check_field_offset(lv, s15666c1f0, 0, "S15666C1.s15666c1f0");
    check_field_offset(lv, s15666c1f1, ABISELECT(496,376), "S15666C1.s15666c1f1");
    check_field_offset(lv, s15666c1f2, ABISELECT(744,524), "S15666C1.s15666c1f2");
    check_field_offset(lv, s15666c1f3, ABISELECT(1768,1344), "S15666C1.s15666c1f3");
  }
}
static Arrange_To_Call_Me vS15666C1(Test_S15666C1, "S15666C1", ABISELECT(1968,1456));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S530C5  {
  int s530c5f0;
  __tsi64 s530c5f1;
  void *s530c5f2[4];
  int s530c5f3[2];
  void *s530c5f4;
  ::S1457C5_nt s530c5f5;
  void *s530c5f6[2];
  virtual  ~S530C5(); // _ZN6S530C5D1Ev
  virtual void  v3(); // _ZN6S530C52v3Ev
  virtual void  v4(); // _ZN6S530C52v4Ev
  virtual void  v5(); // _ZN6S530C52v5Ev
  virtual void  v6(); // _ZN6S530C52v6Ev
  virtual void  v7(); // _ZN6S530C52v7Ev
  virtual void  v8(); // _ZN6S530C52v8Ev
  virtual void  v9(); // _ZN6S530C52v9Ev
  virtual void  v10(); // _ZN6S530C53v10Ev
  virtual void  v11(); // _ZN6S530C53v11Ev
  virtual void  v12(); // _ZN6S530C53v12Ev
  virtual void  v13(); // _ZN6S530C53v13Ev
  virtual void  v14(); // _ZN6S530C53v14Ev
  virtual void  v15(); // _ZN6S530C53v15Ev
  virtual void  v16(); // _ZN6S530C53v16Ev
  virtual void  v17(); // _ZN6S530C53v17Ev
  virtual void  v18(); // _ZN6S530C53v18Ev
  virtual void  v19(); // _ZN6S530C53v19Ev
  virtual void  v20(); // _ZN6S530C53v20Ev
  virtual void  v21(); // _ZN6S530C53v21Ev
  virtual void  v22(); // _ZN6S530C53v22Ev
  virtual void  v23(); // _ZN6S530C53v23Ev
  virtual void  v24(); // _ZN6S530C53v24Ev
  virtual void  v25(); // _ZN6S530C53v25Ev
  virtual void  v26(); // _ZN6S530C53v26Ev
  virtual void  v27(); // _ZN6S530C53v27Ev
  virtual void  v28(); // _ZN6S530C53v28Ev
  virtual void  v29(); // _ZN6S530C53v29Ev
  virtual void  v30(); // _ZN6S530C53v30Ev
  virtual void  v31(); // _ZN6S530C53v31Ev
  virtual void  v32(); // _ZN6S530C53v32Ev
  virtual void  v33(); // _ZN6S530C53v33Ev
  virtual void  v34(); // _ZN6S530C53v34Ev
  virtual void  v35(); // _ZN6S530C53v35Ev
  virtual void  v36(); // _ZN6S530C53v36Ev
  virtual void  v37(); // _ZN6S530C53v37Ev
  virtual void  v38(); // _ZN6S530C53v38Ev
  virtual void  v39(); // _ZN6S530C53v39Ev
  virtual void  v40(); // _ZN6S530C53v40Ev
  virtual void  v41(); // _ZN6S530C53v41Ev
  virtual void  v42(); // _ZN6S530C53v42Ev
  virtual void  v43(); // _ZN6S530C53v43Ev
  virtual void  v44(); // _ZN6S530C53v44Ev
  virtual void  v45(); // _ZN6S530C53v45Ev
  virtual void  v46(); // _ZN6S530C53v46Ev
  virtual void  v47(); // _ZN6S530C53v47Ev
  virtual void  v48(); // _ZN6S530C53v48Ev
  virtual void  v49(); // _ZN6S530C53v49Ev
  virtual void  v50(); // _ZN6S530C53v50Ev
  virtual void  v51(); // _ZN6S530C53v51Ev
  virtual void  v52(); // _ZN6S530C53v52Ev
  virtual void  v53(); // _ZN6S530C53v53Ev
  virtual void  v54(); // _ZN6S530C53v54Ev
  virtual void  v55(); // _ZN6S530C53v55Ev
  virtual void  v56(); // _ZN6S530C53v56Ev
  virtual void  v57(); // _ZN6S530C53v57Ev
  virtual void  v58(); // _ZN6S530C53v58Ev
  virtual void  v59(); // _ZN6S530C53v59Ev
  virtual void  v60(); // _ZN6S530C53v60Ev
  virtual void  v61(); // _ZN6S530C53v61Ev
  virtual void  v62(); // _ZN6S530C53v62Ev
  virtual void  v63(); // _ZN6S530C53v63Ev
  virtual void  v64(); // _ZN6S530C53v64Ev
  virtual void  v65(); // _ZN6S530C53v65Ev
  virtual void  v66(); // _ZN6S530C53v66Ev
  S530C5(); // tgen
};
//SIG(-1 S530C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S530C5 ::~S530C5(){ note_dtor("S530C5", this);}
void  S530C5 ::v3(){vfunc_called(this, "_ZN6S530C52v3Ev");}
void  S530C5 ::v4(){vfunc_called(this, "_ZN6S530C52v4Ev");}
void  S530C5 ::v5(){vfunc_called(this, "_ZN6S530C52v5Ev");}
void  S530C5 ::v6(){vfunc_called(this, "_ZN6S530C52v6Ev");}
void  S530C5 ::v7(){vfunc_called(this, "_ZN6S530C52v7Ev");}
void  S530C5 ::v8(){vfunc_called(this, "_ZN6S530C52v8Ev");}
void  S530C5 ::v9(){vfunc_called(this, "_ZN6S530C52v9Ev");}
void  S530C5 ::v10(){vfunc_called(this, "_ZN6S530C53v10Ev");}
void  S530C5 ::v11(){vfunc_called(this, "_ZN6S530C53v11Ev");}
void  S530C5 ::v12(){vfunc_called(this, "_ZN6S530C53v12Ev");}
void  S530C5 ::v13(){vfunc_called(this, "_ZN6S530C53v13Ev");}
void  S530C5 ::v14(){vfunc_called(this, "_ZN6S530C53v14Ev");}
void  S530C5 ::v15(){vfunc_called(this, "_ZN6S530C53v15Ev");}
void  S530C5 ::v16(){vfunc_called(this, "_ZN6S530C53v16Ev");}
void  S530C5 ::v17(){vfunc_called(this, "_ZN6S530C53v17Ev");}
void  S530C5 ::v18(){vfunc_called(this, "_ZN6S530C53v18Ev");}
void  S530C5 ::v19(){vfunc_called(this, "_ZN6S530C53v19Ev");}
void  S530C5 ::v20(){vfunc_called(this, "_ZN6S530C53v20Ev");}
void  S530C5 ::v21(){vfunc_called(this, "_ZN6S530C53v21Ev");}
void  S530C5 ::v22(){vfunc_called(this, "_ZN6S530C53v22Ev");}
void  S530C5 ::v23(){vfunc_called(this, "_ZN6S530C53v23Ev");}
void  S530C5 ::v24(){vfunc_called(this, "_ZN6S530C53v24Ev");}
void  S530C5 ::v25(){vfunc_called(this, "_ZN6S530C53v25Ev");}
void  S530C5 ::v26(){vfunc_called(this, "_ZN6S530C53v26Ev");}
void  S530C5 ::v27(){vfunc_called(this, "_ZN6S530C53v27Ev");}
void  S530C5 ::v28(){vfunc_called(this, "_ZN6S530C53v28Ev");}
void  S530C5 ::v29(){vfunc_called(this, "_ZN6S530C53v29Ev");}
void  S530C5 ::v30(){vfunc_called(this, "_ZN6S530C53v30Ev");}
void  S530C5 ::v31(){vfunc_called(this, "_ZN6S530C53v31Ev");}
void  S530C5 ::v32(){vfunc_called(this, "_ZN6S530C53v32Ev");}
void  S530C5 ::v33(){vfunc_called(this, "_ZN6S530C53v33Ev");}
void  S530C5 ::v34(){vfunc_called(this, "_ZN6S530C53v34Ev");}
void  S530C5 ::v35(){vfunc_called(this, "_ZN6S530C53v35Ev");}
void  S530C5 ::v36(){vfunc_called(this, "_ZN6S530C53v36Ev");}
void  S530C5 ::v37(){vfunc_called(this, "_ZN6S530C53v37Ev");}
void  S530C5 ::v38(){vfunc_called(this, "_ZN6S530C53v38Ev");}
void  S530C5 ::v39(){vfunc_called(this, "_ZN6S530C53v39Ev");}
void  S530C5 ::v40(){vfunc_called(this, "_ZN6S530C53v40Ev");}
void  S530C5 ::v41(){vfunc_called(this, "_ZN6S530C53v41Ev");}
void  S530C5 ::v42(){vfunc_called(this, "_ZN6S530C53v42Ev");}
void  S530C5 ::v43(){vfunc_called(this, "_ZN6S530C53v43Ev");}
void  S530C5 ::v44(){vfunc_called(this, "_ZN6S530C53v44Ev");}
void  S530C5 ::v45(){vfunc_called(this, "_ZN6S530C53v45Ev");}
void  S530C5 ::v46(){vfunc_called(this, "_ZN6S530C53v46Ev");}
void  S530C5 ::v47(){vfunc_called(this, "_ZN6S530C53v47Ev");}
void  S530C5 ::v48(){vfunc_called(this, "_ZN6S530C53v48Ev");}
void  S530C5 ::v49(){vfunc_called(this, "_ZN6S530C53v49Ev");}
void  S530C5 ::v50(){vfunc_called(this, "_ZN6S530C53v50Ev");}
void  S530C5 ::v51(){vfunc_called(this, "_ZN6S530C53v51Ev");}
void  S530C5 ::v52(){vfunc_called(this, "_ZN6S530C53v52Ev");}
void  S530C5 ::v53(){vfunc_called(this, "_ZN6S530C53v53Ev");}
void  S530C5 ::v54(){vfunc_called(this, "_ZN6S530C53v54Ev");}
void  S530C5 ::v55(){vfunc_called(this, "_ZN6S530C53v55Ev");}
void  S530C5 ::v56(){vfunc_called(this, "_ZN6S530C53v56Ev");}
void  S530C5 ::v57(){vfunc_called(this, "_ZN6S530C53v57Ev");}
void  S530C5 ::v58(){vfunc_called(this, "_ZN6S530C53v58Ev");}
void  S530C5 ::v59(){vfunc_called(this, "_ZN6S530C53v59Ev");}
void  S530C5 ::v60(){vfunc_called(this, "_ZN6S530C53v60Ev");}
void  S530C5 ::v61(){vfunc_called(this, "_ZN6S530C53v61Ev");}
void  S530C5 ::v62(){vfunc_called(this, "_ZN6S530C53v62Ev");}
void  S530C5 ::v63(){vfunc_called(this, "_ZN6S530C53v63Ev");}
void  S530C5 ::v64(){vfunc_called(this, "_ZN6S530C53v64Ev");}
void  S530C5 ::v65(){vfunc_called(this, "_ZN6S530C53v65Ev");}
void  S530C5 ::v66(){vfunc_called(this, "_ZN6S530C53v66Ev");}
S530C5 ::S530C5(){ note_ctor("S530C5", this);} // tgen

static void Test_S530C5()
{
  extern Class_Descriptor cd_S530C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S530C5, buf);
    S530C5 *dp, &lv = *(dp=new (buf) S530C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S530C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S530C5)");
    check_field_offset(lv, s530c5f0, ABISELECT(8,4), "S530C5.s530c5f0");
    check_field_offset(lv, s530c5f1, ABISELECT(16,8), "S530C5.s530c5f1");
    check_field_offset(lv, s530c5f2, ABISELECT(24,16), "S530C5.s530c5f2");
    check_field_offset(lv, s530c5f3, ABISELECT(56,32), "S530C5.s530c5f3");
    check_field_offset(lv, s530c5f4, ABISELECT(64,40), "S530C5.s530c5f4");
    check_field_offset(lv, s530c5f5, ABISELECT(72,44), "S530C5.s530c5f5");
    check_field_offset(lv, s530c5f6, ABISELECT(80,52), "S530C5.s530c5f6");
    test_class_info(&lv, &cd_S530C5);
    dp->~S530C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS530C5(Test_S530C5, "S530C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S530C5C1Ev();
extern void _ZN6S530C5D1Ev();
Name_Map name_map_S530C5[] = {
  NSPAIR(_ZN6S530C5C1Ev),
  NSPAIR(_ZN6S530C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S530C5[];
extern void _ZN6S530C5D1Ev();
extern void _ZN6S530C5D0Ev();
extern void _ZN6S530C52v3Ev();
extern void _ZN6S530C52v4Ev();
extern void _ZN6S530C52v5Ev();
extern void _ZN6S530C52v6Ev();
extern void _ZN6S530C52v7Ev();
extern void _ZN6S530C52v8Ev();
extern void _ZN6S530C52v9Ev();
extern void _ZN6S530C53v10Ev();
extern void _ZN6S530C53v11Ev();
extern void _ZN6S530C53v12Ev();
extern void _ZN6S530C53v13Ev();
extern void _ZN6S530C53v14Ev();
extern void _ZN6S530C53v15Ev();
extern void _ZN6S530C53v16Ev();
extern void _ZN6S530C53v17Ev();
extern void _ZN6S530C53v18Ev();
extern void _ZN6S530C53v19Ev();
extern void _ZN6S530C53v20Ev();
extern void _ZN6S530C53v21Ev();
extern void _ZN6S530C53v22Ev();
extern void _ZN6S530C53v23Ev();
extern void _ZN6S530C53v24Ev();
extern void _ZN6S530C53v25Ev();
extern void _ZN6S530C53v26Ev();
extern void _ZN6S530C53v27Ev();
extern void _ZN6S530C53v28Ev();
extern void _ZN6S530C53v29Ev();
extern void _ZN6S530C53v30Ev();
extern void _ZN6S530C53v31Ev();
extern void _ZN6S530C53v32Ev();
extern void _ZN6S530C53v33Ev();
extern void _ZN6S530C53v34Ev();
extern void _ZN6S530C53v35Ev();
extern void _ZN6S530C53v36Ev();
extern void _ZN6S530C53v37Ev();
extern void _ZN6S530C53v38Ev();
extern void _ZN6S530C53v39Ev();
extern void _ZN6S530C53v40Ev();
extern void _ZN6S530C53v41Ev();
extern void _ZN6S530C53v42Ev();
extern void _ZN6S530C53v43Ev();
extern void _ZN6S530C53v44Ev();
extern void _ZN6S530C53v45Ev();
extern void _ZN6S530C53v46Ev();
extern void _ZN6S530C53v47Ev();
extern void _ZN6S530C53v48Ev();
extern void _ZN6S530C53v49Ev();
extern void _ZN6S530C53v50Ev();
extern void _ZN6S530C53v51Ev();
extern void _ZN6S530C53v52Ev();
extern void _ZN6S530C53v53Ev();
extern void _ZN6S530C53v54Ev();
extern void _ZN6S530C53v55Ev();
extern void _ZN6S530C53v56Ev();
extern void _ZN6S530C53v57Ev();
extern void _ZN6S530C53v58Ev();
extern void _ZN6S530C53v59Ev();
extern void _ZN6S530C53v60Ev();
extern void _ZN6S530C53v61Ev();
extern void _ZN6S530C53v62Ev();
extern void _ZN6S530C53v63Ev();
extern void _ZN6S530C53v64Ev();
extern void _ZN6S530C53v65Ev();
extern void _ZN6S530C53v66Ev();
static  VTBL_ENTRY vtc_S530C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S530C5[0]),
  (VTBL_ENTRY)&_ZN6S530C5D1Ev,
  (VTBL_ENTRY)&_ZN6S530C5D0Ev,
  (VTBL_ENTRY)&_ZN6S530C52v3Ev,
  (VTBL_ENTRY)&_ZN6S530C52v4Ev,
  (VTBL_ENTRY)&_ZN6S530C52v5Ev,
  (VTBL_ENTRY)&_ZN6S530C52v6Ev,
  (VTBL_ENTRY)&_ZN6S530C52v7Ev,
  (VTBL_ENTRY)&_ZN6S530C52v8Ev,
  (VTBL_ENTRY)&_ZN6S530C52v9Ev,
  (VTBL_ENTRY)&_ZN6S530C53v10Ev,
  (VTBL_ENTRY)&_ZN6S530C53v11Ev,
  (VTBL_ENTRY)&_ZN6S530C53v12Ev,
  (VTBL_ENTRY)&_ZN6S530C53v13Ev,
  (VTBL_ENTRY)&_ZN6S530C53v14Ev,
  (VTBL_ENTRY)&_ZN6S530C53v15Ev,
  (VTBL_ENTRY)&_ZN6S530C53v16Ev,
  (VTBL_ENTRY)&_ZN6S530C53v17Ev,
  (VTBL_ENTRY)&_ZN6S530C53v18Ev,
  (VTBL_ENTRY)&_ZN6S530C53v19Ev,
  (VTBL_ENTRY)&_ZN6S530C53v20Ev,
  (VTBL_ENTRY)&_ZN6S530C53v21Ev,
  (VTBL_ENTRY)&_ZN6S530C53v22Ev,
  (VTBL_ENTRY)&_ZN6S530C53v23Ev,
  (VTBL_ENTRY)&_ZN6S530C53v24Ev,
  (VTBL_ENTRY)&_ZN6S530C53v25Ev,
  (VTBL_ENTRY)&_ZN6S530C53v26Ev,
  (VTBL_ENTRY)&_ZN6S530C53v27Ev,
  (VTBL_ENTRY)&_ZN6S530C53v28Ev,
  (VTBL_ENTRY)&_ZN6S530C53v29Ev,
  (VTBL_ENTRY)&_ZN6S530C53v30Ev,
  (VTBL_ENTRY)&_ZN6S530C53v31Ev,
  (VTBL_ENTRY)&_ZN6S530C53v32Ev,
  (VTBL_ENTRY)&_ZN6S530C53v33Ev,
  (VTBL_ENTRY)&_ZN6S530C53v34Ev,
  (VTBL_ENTRY)&_ZN6S530C53v35Ev,
  (VTBL_ENTRY)&_ZN6S530C53v36Ev,
  (VTBL_ENTRY)&_ZN6S530C53v37Ev,
  (VTBL_ENTRY)&_ZN6S530C53v38Ev,
  (VTBL_ENTRY)&_ZN6S530C53v39Ev,
  (VTBL_ENTRY)&_ZN6S530C53v40Ev,
  (VTBL_ENTRY)&_ZN6S530C53v41Ev,
  (VTBL_ENTRY)&_ZN6S530C53v42Ev,
  (VTBL_ENTRY)&_ZN6S530C53v43Ev,
  (VTBL_ENTRY)&_ZN6S530C53v44Ev,
  (VTBL_ENTRY)&_ZN6S530C53v45Ev,
  (VTBL_ENTRY)&_ZN6S530C53v46Ev,
  (VTBL_ENTRY)&_ZN6S530C53v47Ev,
  (VTBL_ENTRY)&_ZN6S530C53v48Ev,
  (VTBL_ENTRY)&_ZN6S530C53v49Ev,
  (VTBL_ENTRY)&_ZN6S530C53v50Ev,
  (VTBL_ENTRY)&_ZN6S530C53v51Ev,
  (VTBL_ENTRY)&_ZN6S530C53v52Ev,
  (VTBL_ENTRY)&_ZN6S530C53v53Ev,
  (VTBL_ENTRY)&_ZN6S530C53v54Ev,
  (VTBL_ENTRY)&_ZN6S530C53v55Ev,
  (VTBL_ENTRY)&_ZN6S530C53v56Ev,
  (VTBL_ENTRY)&_ZN6S530C53v57Ev,
  (VTBL_ENTRY)&_ZN6S530C53v58Ev,
  (VTBL_ENTRY)&_ZN6S530C53v59Ev,
  (VTBL_ENTRY)&_ZN6S530C53v60Ev,
  (VTBL_ENTRY)&_ZN6S530C53v61Ev,
  (VTBL_ENTRY)&_ZN6S530C53v62Ev,
  (VTBL_ENTRY)&_ZN6S530C53v63Ev,
  (VTBL_ENTRY)&_ZN6S530C53v64Ev,
  (VTBL_ENTRY)&_ZN6S530C53v65Ev,
  (VTBL_ENTRY)&_ZN6S530C53v66Ev,
};
extern VTBL_ENTRY _ZTI6S530C5[];
extern  VTBL_ENTRY _ZTV6S530C5[];
Class_Descriptor cd_S530C5 = {  "S530C5", // class name
  0,0,//no base classes
  &(vtc_S530C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S530C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S530C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S530C4  : S530C5 {
  int s530c4f0[2];
  void *s530c4f1;
  int s530c4f2[2];
  ::S694C7_nt s530c4f3;
  ::S694C7_nt s530c4f4;
  ::S694C11_nt s530c4f5;
  ::S694C7_nt s530c4f6;
  unsigned int s530c4f7:1;
  unsigned int s530c4f8:1;
  unsigned int s530c4f9:1;
  unsigned int s530c4f10:1;
  unsigned int s530c4f11:1;
  int s530c4f12[2];
  virtual  ~S530C4(); // _ZN6S530C4D1Ev
  virtual void  v67(); // _ZN6S530C43v67Ev
  virtual void  v68(); // _ZN6S530C43v68Ev
  virtual void  v69(); // _ZN6S530C43v69Ev
  virtual void  v70(); // _ZN6S530C43v70Ev
  virtual void  v71(); // _ZN6S530C43v71Ev
  virtual void  v72(); // _ZN6S530C43v72Ev
  virtual void  v73(); // _ZN6S530C43v73Ev
  virtual void  v74(); // _ZN6S530C43v74Ev
  virtual void  v75(); // _ZN6S530C43v75Ev
  virtual void  v76(); // _ZN6S530C43v76Ev
  virtual void  v77(); // _ZN6S530C43v77Ev
  virtual void  v78(); // _ZN6S530C43v78Ev
  virtual void  v79(); // _ZN6S530C43v79Ev
  virtual void  v80(); // _ZN6S530C43v80Ev
  virtual void  v81(); // _ZN6S530C43v81Ev
  virtual void  v82(); // _ZN6S530C43v82Ev
  virtual void  v83(); // _ZN6S530C43v83Ev
  virtual void  v84(); // _ZN6S530C43v84Ev
  virtual void  v85(); // _ZN6S530C43v85Ev
  virtual void  v86(); // _ZN6S530C43v86Ev
  virtual void  v87(); // _ZN6S530C43v87Ev
  virtual void  v88(); // _ZN6S530C43v88Ev
  S530C4(); // tgen
};
//SIG(-1 S530C4) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S530C4 ::~S530C4(){ note_dtor("S530C4", this);}
void  S530C4 ::v67(){vfunc_called(this, "_ZN6S530C43v67Ev");}
void  S530C4 ::v68(){vfunc_called(this, "_ZN6S530C43v68Ev");}
void  S530C4 ::v69(){vfunc_called(this, "_ZN6S530C43v69Ev");}
void  S530C4 ::v70(){vfunc_called(this, "_ZN6S530C43v70Ev");}
void  S530C4 ::v71(){vfunc_called(this, "_ZN6S530C43v71Ev");}
void  S530C4 ::v72(){vfunc_called(this, "_ZN6S530C43v72Ev");}
void  S530C4 ::v73(){vfunc_called(this, "_ZN6S530C43v73Ev");}
void  S530C4 ::v74(){vfunc_called(this, "_ZN6S530C43v74Ev");}
void  S530C4 ::v75(){vfunc_called(this, "_ZN6S530C43v75Ev");}
void  S530C4 ::v76(){vfunc_called(this, "_ZN6S530C43v76Ev");}
void  S530C4 ::v77(){vfunc_called(this, "_ZN6S530C43v77Ev");}
void  S530C4 ::v78(){vfunc_called(this, "_ZN6S530C43v78Ev");}
void  S530C4 ::v79(){vfunc_called(this, "_ZN6S530C43v79Ev");}
void  S530C4 ::v80(){vfunc_called(this, "_ZN6S530C43v80Ev");}
void  S530C4 ::v81(){vfunc_called(this, "_ZN6S530C43v81Ev");}
void  S530C4 ::v82(){vfunc_called(this, "_ZN6S530C43v82Ev");}
void  S530C4 ::v83(){vfunc_called(this, "_ZN6S530C43v83Ev");}
void  S530C4 ::v84(){vfunc_called(this, "_ZN6S530C43v84Ev");}
void  S530C4 ::v85(){vfunc_called(this, "_ZN6S530C43v85Ev");}
void  S530C4 ::v86(){vfunc_called(this, "_ZN6S530C43v86Ev");}
void  S530C4 ::v87(){vfunc_called(this, "_ZN6S530C43v87Ev");}
void  S530C4 ::v88(){vfunc_called(this, "_ZN6S530C43v88Ev");}
S530C4 ::S530C4(){ note_ctor("S530C4", this);} // tgen

static void Test_S530C4()
{
  extern Class_Descriptor cd_S530C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S530C4, buf);
    S530C4 *dp, &lv = *(dp=new (buf) S530C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S530C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S530C4)");
    check_base_class_offset(lv, (S530C5*), 0, "S530C4");
    check_field_offset(lv, s530c4f0, ABISELECT(96,60), "S530C4.s530c4f0");
    check_field_offset(lv, s530c4f1, ABISELECT(104,68), "S530C4.s530c4f1");
    check_field_offset(lv, s530c4f2, ABISELECT(112,72), "S530C4.s530c4f2");
    check_field_offset(lv, s530c4f3, ABISELECT(120,80), "S530C4.s530c4f3");
    check_field_offset(lv, s530c4f4, ABISELECT(136,92), "S530C4.s530c4f4");
    check_field_offset(lv, s530c4f5, ABISELECT(152,104), "S530C4.s530c4f5");
    check_field_offset(lv, s530c4f6, ABISELECT(160,108), "S530C4.s530c4f6");
    set_bf_and_test(lv, s530c4f7, ABISELECT(176,120), 0, 1, 1, "S530C4");
    set_bf_and_test(lv, s530c4f8, ABISELECT(176,120), 1, 1, 1, "S530C4");
    set_bf_and_test(lv, s530c4f9, ABISELECT(176,120), 2, 1, 1, "S530C4");
    set_bf_and_test(lv, s530c4f10, ABISELECT(176,120), 3, 1, 1, "S530C4");
    set_bf_and_test(lv, s530c4f11, ABISELECT(176,120), 4, 1, 1, "S530C4");
    check_field_offset(lv, s530c4f12, ABISELECT(180,124), "S530C4.s530c4f12");
    test_class_info(&lv, &cd_S530C4);
    dp->~S530C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS530C4(Test_S530C4, "S530C4", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN6S530C4C1Ev();
extern void _ZN6S530C4D1Ev();
Name_Map name_map_S530C4[] = {
  NSPAIR(_ZN6S530C4C1Ev),
  NSPAIR(_ZN6S530C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S530C5;
extern VTBL_ENTRY _ZTI6S530C5[];
extern  VTBL_ENTRY _ZTV6S530C5[];
static Base_Class bases_S530C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S530C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S530C4[];
extern void _ZN6S530C4D1Ev();
extern void _ZN6S530C4D0Ev();
extern void _ZN6S530C52v3Ev();
extern void _ZN6S530C52v4Ev();
extern void _ZN6S530C52v5Ev();
extern void _ZN6S530C52v6Ev();
extern void _ZN6S530C52v7Ev();
extern void _ZN6S530C52v8Ev();
extern void _ZN6S530C52v9Ev();
extern void _ZN6S530C53v10Ev();
extern void _ZN6S530C53v11Ev();
extern void _ZN6S530C53v12Ev();
extern void _ZN6S530C53v13Ev();
extern void _ZN6S530C53v14Ev();
extern void _ZN6S530C53v15Ev();
extern void _ZN6S530C53v16Ev();
extern void _ZN6S530C53v17Ev();
extern void _ZN6S530C53v18Ev();
extern void _ZN6S530C53v19Ev();
extern void _ZN6S530C53v20Ev();
extern void _ZN6S530C53v21Ev();
extern void _ZN6S530C53v22Ev();
extern void _ZN6S530C53v23Ev();
extern void _ZN6S530C53v24Ev();
extern void _ZN6S530C53v25Ev();
extern void _ZN6S530C53v26Ev();
extern void _ZN6S530C53v27Ev();
extern void _ZN6S530C53v28Ev();
extern void _ZN6S530C53v29Ev();
extern void _ZN6S530C53v30Ev();
extern void _ZN6S530C53v31Ev();
extern void _ZN6S530C53v32Ev();
extern void _ZN6S530C53v33Ev();
extern void _ZN6S530C53v34Ev();
extern void _ZN6S530C53v35Ev();
extern void _ZN6S530C53v36Ev();
extern void _ZN6S530C53v37Ev();
extern void _ZN6S530C53v38Ev();
extern void _ZN6S530C53v39Ev();
extern void _ZN6S530C53v40Ev();
extern void _ZN6S530C53v41Ev();
extern void _ZN6S530C53v42Ev();
extern void _ZN6S530C53v43Ev();
extern void _ZN6S530C53v44Ev();
extern void _ZN6S530C53v45Ev();
extern void _ZN6S530C53v46Ev();
extern void _ZN6S530C53v47Ev();
extern void _ZN6S530C53v48Ev();
extern void _ZN6S530C53v49Ev();
extern void _ZN6S530C53v50Ev();
extern void _ZN6S530C53v51Ev();
extern void _ZN6S530C53v52Ev();
extern void _ZN6S530C53v53Ev();
extern void _ZN6S530C53v54Ev();
extern void _ZN6S530C53v55Ev();
extern void _ZN6S530C53v56Ev();
extern void _ZN6S530C53v57Ev();
extern void _ZN6S530C53v58Ev();
extern void _ZN6S530C53v59Ev();
extern void _ZN6S530C53v60Ev();
extern void _ZN6S530C53v61Ev();
extern void _ZN6S530C53v62Ev();
extern void _ZN6S530C53v63Ev();
extern void _ZN6S530C53v64Ev();
extern void _ZN6S530C53v65Ev();
extern void _ZN6S530C53v66Ev();
extern void _ZN6S530C43v67Ev();
extern void _ZN6S530C43v68Ev();
extern void _ZN6S530C43v69Ev();
extern void _ZN6S530C43v70Ev();
extern void _ZN6S530C43v71Ev();
extern void _ZN6S530C43v72Ev();
extern void _ZN6S530C43v73Ev();
extern void _ZN6S530C43v74Ev();
extern void _ZN6S530C43v75Ev();
extern void _ZN6S530C43v76Ev();
extern void _ZN6S530C43v77Ev();
extern void _ZN6S530C43v78Ev();
extern void _ZN6S530C43v79Ev();
extern void _ZN6S530C43v80Ev();
extern void _ZN6S530C43v81Ev();
extern void _ZN6S530C43v82Ev();
extern void _ZN6S530C43v83Ev();
extern void _ZN6S530C43v84Ev();
extern void _ZN6S530C43v85Ev();
extern void _ZN6S530C43v86Ev();
extern void _ZN6S530C43v87Ev();
extern void _ZN6S530C43v88Ev();
static  VTBL_ENTRY vtc_S530C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S530C4[0]),
  (VTBL_ENTRY)&_ZN6S530C4D1Ev,
  (VTBL_ENTRY)&_ZN6S530C4D0Ev,
  (VTBL_ENTRY)&_ZN6S530C52v3Ev,
  (VTBL_ENTRY)&_ZN6S530C52v4Ev,
  (VTBL_ENTRY)&_ZN6S530C52v5Ev,
  (VTBL_ENTRY)&_ZN6S530C52v6Ev,
  (VTBL_ENTRY)&_ZN6S530C52v7Ev,
  (VTBL_ENTRY)&_ZN6S530C52v8Ev,
  (VTBL_ENTRY)&_ZN6S530C52v9Ev,
  (VTBL_ENTRY)&_ZN6S530C53v10Ev,
  (VTBL_ENTRY)&_ZN6S530C53v11Ev,
  (VTBL_ENTRY)&_ZN6S530C53v12Ev,
  (VTBL_ENTRY)&_ZN6S530C53v13Ev,
  (VTBL_ENTRY)&_ZN6S530C53v14Ev,
  (VTBL_ENTRY)&_ZN6S530C53v15Ev,
  (VTBL_ENTRY)&_ZN6S530C53v16Ev,
  (VTBL_ENTRY)&_ZN6S530C53v17Ev,
  (VTBL_ENTRY)&_ZN6S530C53v18Ev,
  (VTBL_ENTRY)&_ZN6S530C53v19Ev,
  (VTBL_ENTRY)&_ZN6S530C53v20Ev,
  (VTBL_ENTRY)&_ZN6S530C53v21Ev,
  (VTBL_ENTRY)&_ZN6S530C53v22Ev,
  (VTBL_ENTRY)&_ZN6S530C53v23Ev,
  (VTBL_ENTRY)&_ZN6S530C53v24Ev,
  (VTBL_ENTRY)&_ZN6S530C53v25Ev,
  (VTBL_ENTRY)&_ZN6S530C53v26Ev,
  (VTBL_ENTRY)&_ZN6S530C53v27Ev,
  (VTBL_ENTRY)&_ZN6S530C53v28Ev,
  (VTBL_ENTRY)&_ZN6S530C53v29Ev,
  (VTBL_ENTRY)&_ZN6S530C53v30Ev,
  (VTBL_ENTRY)&_ZN6S530C53v31Ev,
  (VTBL_ENTRY)&_ZN6S530C53v32Ev,
  (VTBL_ENTRY)&_ZN6S530C53v33Ev,
  (VTBL_ENTRY)&_ZN6S530C53v34Ev,
  (VTBL_ENTRY)&_ZN6S530C53v35Ev,
  (VTBL_ENTRY)&_ZN6S530C53v36Ev,
  (VTBL_ENTRY)&_ZN6S530C53v37Ev,
  (VTBL_ENTRY)&_ZN6S530C53v38Ev,
  (VTBL_ENTRY)&_ZN6S530C53v39Ev,
  (VTBL_ENTRY)&_ZN6S530C53v40Ev,
  (VTBL_ENTRY)&_ZN6S530C53v41Ev,
  (VTBL_ENTRY)&_ZN6S530C53v42Ev,
  (VTBL_ENTRY)&_ZN6S530C53v43Ev,
  (VTBL_ENTRY)&_ZN6S530C53v44Ev,
  (VTBL_ENTRY)&_ZN6S530C53v45Ev,
  (VTBL_ENTRY)&_ZN6S530C53v46Ev,
  (VTBL_ENTRY)&_ZN6S530C53v47Ev,
  (VTBL_ENTRY)&_ZN6S530C53v48Ev,
  (VTBL_ENTRY)&_ZN6S530C53v49Ev,
  (VTBL_ENTRY)&_ZN6S530C53v50Ev,
  (VTBL_ENTRY)&_ZN6S530C53v51Ev,
  (VTBL_ENTRY)&_ZN6S530C53v52Ev,
  (VTBL_ENTRY)&_ZN6S530C53v53Ev,
  (VTBL_ENTRY)&_ZN6S530C53v54Ev,
  (VTBL_ENTRY)&_ZN6S530C53v55Ev,
  (VTBL_ENTRY)&_ZN6S530C53v56Ev,
  (VTBL_ENTRY)&_ZN6S530C53v57Ev,
  (VTBL_ENTRY)&_ZN6S530C53v58Ev,
  (VTBL_ENTRY)&_ZN6S530C53v59Ev,
  (VTBL_ENTRY)&_ZN6S530C53v60Ev,
  (VTBL_ENTRY)&_ZN6S530C53v61Ev,
  (VTBL_ENTRY)&_ZN6S530C53v62Ev,
  (VTBL_ENTRY)&_ZN6S530C53v63Ev,
  (VTBL_ENTRY)&_ZN6S530C53v64Ev,
  (VTBL_ENTRY)&_ZN6S530C53v65Ev,
  (VTBL_ENTRY)&_ZN6S530C53v66Ev,
  (VTBL_ENTRY)&_ZN6S530C43v67Ev,
  (VTBL_ENTRY)&_ZN6S530C43v68Ev,
  (VTBL_ENTRY)&_ZN6S530C43v69Ev,
  (VTBL_ENTRY)&_ZN6S530C43v70Ev,
  (VTBL_ENTRY)&_ZN6S530C43v71Ev,
  (VTBL_ENTRY)&_ZN6S530C43v72Ev,
  (VTBL_ENTRY)&_ZN6S530C43v73Ev,
  (VTBL_ENTRY)&_ZN6S530C43v74Ev,
  (VTBL_ENTRY)&_ZN6S530C43v75Ev,
  (VTBL_ENTRY)&_ZN6S530C43v76Ev,
  (VTBL_ENTRY)&_ZN6S530C43v77Ev,
  (VTBL_ENTRY)&_ZN6S530C43v78Ev,
  (VTBL_ENTRY)&_ZN6S530C43v79Ev,
  (VTBL_ENTRY)&_ZN6S530C43v80Ev,
  (VTBL_ENTRY)&_ZN6S530C43v81Ev,
  (VTBL_ENTRY)&_ZN6S530C43v82Ev,
  (VTBL_ENTRY)&_ZN6S530C43v83Ev,
  (VTBL_ENTRY)&_ZN6S530C43v84Ev,
  (VTBL_ENTRY)&_ZN6S530C43v85Ev,
  (VTBL_ENTRY)&_ZN6S530C43v86Ev,
  (VTBL_ENTRY)&_ZN6S530C43v87Ev,
  (VTBL_ENTRY)&_ZN6S530C43v88Ev,
};
extern VTBL_ENTRY _ZTI6S530C4[];
extern  VTBL_ENTRY _ZTV6S530C4[];
Class_Descriptor cd_S530C4 = {  "S530C4", // class name
  bases_S530C4, 1,
  &(vtc_S530C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI6S530C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S530C4),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S530C3  : S530C4 {
  unsigned int s530c3f0:1;
  unsigned int s530c3f1:1;
  unsigned int s530c3f2:1;
  ::S1457C22 s530c3f3;
  ::S1457C18 s530c3f4;
  ::S1457C12 s530c3f5;
  ::S1457C6_nt s530c3f6;
  int s530c3f7[3];
  virtual  ~S530C3(); // _ZN6S530C3D1Ev
  virtual void  v89(); // _ZN6S530C33v89Ev
  virtual void  v90(); // _ZN6S530C33v90Ev
  virtual void  v91(); // _ZN6S530C33v91Ev
  virtual void  v92(); // _ZN6S530C33v92Ev
  virtual void  v93(); // _ZN6S530C33v93Ev
  virtual void  v94(); // _ZN6S530C33v94Ev
  virtual void  v95(); // _ZN6S530C33v95Ev
  virtual void  v96(); // _ZN6S530C33v96Ev
  virtual void  v97(); // _ZN6S530C33v97Ev
  virtual void  v98(); // _ZN6S530C33v98Ev
  virtual void  v99(); // _ZN6S530C33v99Ev
  virtual void  v100(); // _ZN6S530C34v100Ev
  virtual void  v101(); // _ZN6S530C34v101Ev
  virtual void  v102(); // _ZN6S530C34v102Ev
  virtual void  v103(); // _ZN6S530C34v103Ev
  virtual void  v104(); // _ZN6S530C34v104Ev
  virtual void  v105(); // _ZN6S530C34v105Ev
  virtual void  v106(); // _ZN6S530C34v106Ev
  virtual void  v107(); // _ZN6S530C34v107Ev
  virtual void  v108(); // _ZN6S530C34v108Ev
  S530C3(); // tgen
};
//SIG(-1 S530C3) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} FC16{ BC17{ BC8}} Fi[3]}


 S530C3 ::~S530C3(){ note_dtor("S530C3", this);}
void  S530C3 ::v89(){vfunc_called(this, "_ZN6S530C33v89Ev");}
void  S530C3 ::v90(){vfunc_called(this, "_ZN6S530C33v90Ev");}
void  S530C3 ::v91(){vfunc_called(this, "_ZN6S530C33v91Ev");}
void  S530C3 ::v92(){vfunc_called(this, "_ZN6S530C33v92Ev");}
void  S530C3 ::v93(){vfunc_called(this, "_ZN6S530C33v93Ev");}
void  S530C3 ::v94(){vfunc_called(this, "_ZN6S530C33v94Ev");}
void  S530C3 ::v95(){vfunc_called(this, "_ZN6S530C33v95Ev");}
void  S530C3 ::v96(){vfunc_called(this, "_ZN6S530C33v96Ev");}
void  S530C3 ::v97(){vfunc_called(this, "_ZN6S530C33v97Ev");}
void  S530C3 ::v98(){vfunc_called(this, "_ZN6S530C33v98Ev");}
void  S530C3 ::v99(){vfunc_called(this, "_ZN6S530C33v99Ev");}
void  S530C3 ::v100(){vfunc_called(this, "_ZN6S530C34v100Ev");}
void  S530C3 ::v101(){vfunc_called(this, "_ZN6S530C34v101Ev");}
void  S530C3 ::v102(){vfunc_called(this, "_ZN6S530C34v102Ev");}
void  S530C3 ::v103(){vfunc_called(this, "_ZN6S530C34v103Ev");}
void  S530C3 ::v104(){vfunc_called(this, "_ZN6S530C34v104Ev");}
void  S530C3 ::v105(){vfunc_called(this, "_ZN6S530C34v105Ev");}
void  S530C3 ::v106(){vfunc_called(this, "_ZN6S530C34v106Ev");}
void  S530C3 ::v107(){vfunc_called(this, "_ZN6S530C34v107Ev");}
void  S530C3 ::v108(){vfunc_called(this, "_ZN6S530C34v108Ev");}
S530C3 ::S530C3(){ note_ctor("S530C3", this);} // tgen

static void Test_S530C3()
{
  extern Class_Descriptor cd_S530C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(35,50)];
    init_test(&cd_S530C3, buf);
    S530C3 *dp, &lv = *(dp=new (buf) S530C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,196), "sizeof(S530C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S530C3)");
    check_base_class_offset(lv, (S530C5*)(S530C4*), 0, "S530C3");
    check_base_class_offset(lv, (S530C4*), 0, "S530C3");
    set_bf_and_test(lv, s530c3f0, ABISELECT(188,132), 0, 1, 1, "S530C3");
    set_bf_and_test(lv, s530c3f1, ABISELECT(188,132), 1, 1, 1, "S530C3");
    set_bf_and_test(lv, s530c3f2, ABISELECT(188,132), 2, 1, 1, "S530C3");
    check_field_offset(lv, s530c3f3, ABISELECT(192,136), "S530C3.s530c3f3");
    check_field_offset(lv, s530c3f4, ABISELECT(208,148), "S530C3.s530c3f4");
    check_field_offset(lv, s530c3f5, ABISELECT(224,160), "S530C3.s530c3f5");
    check_field_offset(lv, s530c3f6, ABISELECT(240,172), "S530C3.s530c3f6");
    check_field_offset(lv, s530c3f7, ABISELECT(256,184), "S530C3.s530c3f7");
    test_class_info(&lv, &cd_S530C3);
    dp->~S530C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS530C3(Test_S530C3, "S530C3", ABISELECT(272,196));

#else // __cplusplus

extern void _ZN6S530C3C1Ev();
extern void _ZN6S530C3D1Ev();
Name_Map name_map_S530C3[] = {
  NSPAIR(_ZN6S530C3C1Ev),
  NSPAIR(_ZN6S530C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S530C5;
extern VTBL_ENTRY _ZTI6S530C5[];
extern  VTBL_ENTRY _ZTV6S530C5[];
extern Class_Descriptor cd_S530C4;
extern VTBL_ENTRY _ZTI6S530C4[];
extern  VTBL_ENTRY _ZTV6S530C4[];
static Base_Class bases_S530C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S530C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S530C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S530C3[];
extern void _ZN6S530C3D1Ev();
extern void _ZN6S530C3D0Ev();
extern void _ZN6S530C52v3Ev();
extern void _ZN6S530C52v4Ev();
extern void _ZN6S530C52v5Ev();
extern void _ZN6S530C52v6Ev();
extern void _ZN6S530C52v7Ev();
extern void _ZN6S530C52v8Ev();
extern void _ZN6S530C52v9Ev();
extern void _ZN6S530C53v10Ev();
extern void _ZN6S530C53v11Ev();
extern void _ZN6S530C53v12Ev();
extern void _ZN6S530C53v13Ev();
extern void _ZN6S530C53v14Ev();
extern void _ZN6S530C53v15Ev();
extern void _ZN6S530C53v16Ev();
extern void _ZN6S530C53v17Ev();
extern void _ZN6S530C53v18Ev();
extern void _ZN6S530C53v19Ev();
extern void _ZN6S530C53v20Ev();
extern void _ZN6S530C53v21Ev();
extern void _ZN6S530C53v22Ev();
extern void _ZN6S530C53v23Ev();
extern void _ZN6S530C53v24Ev();
extern void _ZN6S530C53v25Ev();
extern void _ZN6S530C53v26Ev();
extern void _ZN6S530C53v27Ev();
extern void _ZN6S530C53v28Ev();
extern void _ZN6S530C53v29Ev();
extern void _ZN6S530C53v30Ev();
extern void _ZN6S530C53v31Ev();
extern void _ZN6S530C53v32Ev();
extern void _ZN6S530C53v33Ev();
extern void _ZN6S530C53v34Ev();
extern void _ZN6S530C53v35Ev();
extern void _ZN6S530C53v36Ev();
extern void _ZN6S530C53v37Ev();
extern void _ZN6S530C53v38Ev();
extern void _ZN6S530C53v39Ev();
extern void _ZN6S530C53v40Ev();
extern void _ZN6S530C53v41Ev();
extern void _ZN6S530C53v42Ev();
extern void _ZN6S530C53v43Ev();
extern void _ZN6S530C53v44Ev();
extern void _ZN6S530C53v45Ev();
extern void _ZN6S530C53v46Ev();
extern void _ZN6S530C53v47Ev();
extern void _ZN6S530C53v48Ev();
extern void _ZN6S530C53v49Ev();
extern void _ZN6S530C53v50Ev();
extern void _ZN6S530C53v51Ev();
extern void _ZN6S530C53v52Ev();
extern void _ZN6S530C53v53Ev();
extern void _ZN6S530C53v54Ev();
extern void _ZN6S530C53v55Ev();
extern void _ZN6S530C53v56Ev();
extern void _ZN6S530C53v57Ev();
extern void _ZN6S530C53v58Ev();
extern void _ZN6S530C53v59Ev();
extern void _ZN6S530C53v60Ev();
extern void _ZN6S530C53v61Ev();
extern void _ZN6S530C53v62Ev();
extern void _ZN6S530C53v63Ev();
extern void _ZN6S530C53v64Ev();
extern void _ZN6S530C53v65Ev();
extern void _ZN6S530C53v66Ev();
extern void _ZN6S530C43v67Ev();
extern void _ZN6S530C43v68Ev();
extern void _ZN6S530C43v69Ev();
extern void _ZN6S530C43v70Ev();
extern void _ZN6S530C43v71Ev();
extern void _ZN6S530C43v72Ev();
extern void _ZN6S530C43v73Ev();
extern void _ZN6S530C43v74Ev();
extern void _ZN6S530C43v75Ev();
extern void _ZN6S530C43v76Ev();
extern void _ZN6S530C43v77Ev();
extern void _ZN6S530C43v78Ev();
extern void _ZN6S530C43v79Ev();
extern void _ZN6S530C43v80Ev();
extern void _ZN6S530C43v81Ev();
extern void _ZN6S530C43v82Ev();
extern void _ZN6S530C43v83Ev();
extern void _ZN6S530C43v84Ev();
extern void _ZN6S530C43v85Ev();
extern void _ZN6S530C43v86Ev();
extern void _ZN6S530C43v87Ev();
extern void _ZN6S530C43v88Ev();
extern void _ZN6S530C33v89Ev();
extern void _ZN6S530C33v90Ev();
extern void _ZN6S530C33v91Ev();
extern void _ZN6S530C33v92Ev();
extern void _ZN6S530C33v93Ev();
extern void _ZN6S530C33v94Ev();
extern void _ZN6S530C33v95Ev();
extern void _ZN6S530C33v96Ev();
extern void _ZN6S530C33v97Ev();
extern void _ZN6S530C33v98Ev();
extern void _ZN6S530C33v99Ev();
extern void _ZN6S530C34v100Ev();
extern void _ZN6S530C34v101Ev();
extern void _ZN6S530C34v102Ev();
extern void _ZN6S530C34v103Ev();
extern void _ZN6S530C34v104Ev();
extern void _ZN6S530C34v105Ev();
extern void _ZN6S530C34v106Ev();
extern void _ZN6S530C34v107Ev();
extern void _ZN6S530C34v108Ev();
static  VTBL_ENTRY vtc_S530C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S530C3[0]),
  (VTBL_ENTRY)&_ZN6S530C3D1Ev,
  (VTBL_ENTRY)&_ZN6S530C3D0Ev,
  (VTBL_ENTRY)&_ZN6S530C52v3Ev,
  (VTBL_ENTRY)&_ZN6S530C52v4Ev,
  (VTBL_ENTRY)&_ZN6S530C52v5Ev,
  (VTBL_ENTRY)&_ZN6S530C52v6Ev,
  (VTBL_ENTRY)&_ZN6S530C52v7Ev,
  (VTBL_ENTRY)&_ZN6S530C52v8Ev,
  (VTBL_ENTRY)&_ZN6S530C52v9Ev,
  (VTBL_ENTRY)&_ZN6S530C53v10Ev,
  (VTBL_ENTRY)&_ZN6S530C53v11Ev,
  (VTBL_ENTRY)&_ZN6S530C53v12Ev,
  (VTBL_ENTRY)&_ZN6S530C53v13Ev,
  (VTBL_ENTRY)&_ZN6S530C53v14Ev,
  (VTBL_ENTRY)&_ZN6S530C53v15Ev,
  (VTBL_ENTRY)&_ZN6S530C53v16Ev,
  (VTBL_ENTRY)&_ZN6S530C53v17Ev,
  (VTBL_ENTRY)&_ZN6S530C53v18Ev,
  (VTBL_ENTRY)&_ZN6S530C53v19Ev,
  (VTBL_ENTRY)&_ZN6S530C53v20Ev,
  (VTBL_ENTRY)&_ZN6S530C53v21Ev,
  (VTBL_ENTRY)&_ZN6S530C53v22Ev,
  (VTBL_ENTRY)&_ZN6S530C53v23Ev,
  (VTBL_ENTRY)&_ZN6S530C53v24Ev,
  (VTBL_ENTRY)&_ZN6S530C53v25Ev,
  (VTBL_ENTRY)&_ZN6S530C53v26Ev,
  (VTBL_ENTRY)&_ZN6S530C53v27Ev,
  (VTBL_ENTRY)&_ZN6S530C53v28Ev,
  (VTBL_ENTRY)&_ZN6S530C53v29Ev,
  (VTBL_ENTRY)&_ZN6S530C53v30Ev,
  (VTBL_ENTRY)&_ZN6S530C53v31Ev,
  (VTBL_ENTRY)&_ZN6S530C53v32Ev,
  (VTBL_ENTRY)&_ZN6S530C53v33Ev,
  (VTBL_ENTRY)&_ZN6S530C53v34Ev,
  (VTBL_ENTRY)&_ZN6S530C53v35Ev,
  (VTBL_ENTRY)&_ZN6S530C53v36Ev,
  (VTBL_ENTRY)&_ZN6S530C53v37Ev,
  (VTBL_ENTRY)&_ZN6S530C53v38Ev,
  (VTBL_ENTRY)&_ZN6S530C53v39Ev,
  (VTBL_ENTRY)&_ZN6S530C53v40Ev,
  (VTBL_ENTRY)&_ZN6S530C53v41Ev,
  (VTBL_ENTRY)&_ZN6S530C53v42Ev,
  (VTBL_ENTRY)&_ZN6S530C53v43Ev,
  (VTBL_ENTRY)&_ZN6S530C53v44Ev,
  (VTBL_ENTRY)&_ZN6S530C53v45Ev,
  (VTBL_ENTRY)&_ZN6S530C53v46Ev,
  (VTBL_ENTRY)&_ZN6S530C53v47Ev,
  (VTBL_ENTRY)&_ZN6S530C53v48Ev,
  (VTBL_ENTRY)&_ZN6S530C53v49Ev,
  (VTBL_ENTRY)&_ZN6S530C53v50Ev,
  (VTBL_ENTRY)&_ZN6S530C53v51Ev,
  (VTBL_ENTRY)&_ZN6S530C53v52Ev,
  (VTBL_ENTRY)&_ZN6S530C53v53Ev,
  (VTBL_ENTRY)&_ZN6S530C53v54Ev,
  (VTBL_ENTRY)&_ZN6S530C53v55Ev,
  (VTBL_ENTRY)&_ZN6S530C53v56Ev,
  (VTBL_ENTRY)&_ZN6S530C53v57Ev,
  (VTBL_ENTRY)&_ZN6S530C53v58Ev,
  (VTBL_ENTRY)&_ZN6S530C53v59Ev,
  (VTBL_ENTRY)&_ZN6S530C53v60Ev,
  (VTBL_ENTRY)&_ZN6S530C53v61Ev,
  (VTBL_ENTRY)&_ZN6S530C53v62Ev,
  (VTBL_ENTRY)&_ZN6S530C53v63Ev,
  (VTBL_ENTRY)&_ZN6S530C53v64Ev,
  (VTBL_ENTRY)&_ZN6S530C53v65Ev,
  (VTBL_ENTRY)&_ZN6S530C53v66Ev,
  (VTBL_ENTRY)&_ZN6S530C43v67Ev,
  (VTBL_ENTRY)&_ZN6S530C43v68Ev,
  (VTBL_ENTRY)&_ZN6S530C43v69Ev,
  (VTBL_ENTRY)&_ZN6S530C43v70Ev,
  (VTBL_ENTRY)&_ZN6S530C43v71Ev,
  (VTBL_ENTRY)&_ZN6S530C43v72Ev,
  (VTBL_ENTRY)&_ZN6S530C43v73Ev,
  (VTBL_ENTRY)&_ZN6S530C43v74Ev,
  (VTBL_ENTRY)&_ZN6S530C43v75Ev,
  (VTBL_ENTRY)&_ZN6S530C43v76Ev,
  (VTBL_ENTRY)&_ZN6S530C43v77Ev,
  (VTBL_ENTRY)&_ZN6S530C43v78Ev,
  (VTBL_ENTRY)&_ZN6S530C43v79Ev,
  (VTBL_ENTRY)&_ZN6S530C43v80Ev,
  (VTBL_ENTRY)&_ZN6S530C43v81Ev,
  (VTBL_ENTRY)&_ZN6S530C43v82Ev,
  (VTBL_ENTRY)&_ZN6S530C43v83Ev,
  (VTBL_ENTRY)&_ZN6S530C43v84Ev,
  (VTBL_ENTRY)&_ZN6S530C43v85Ev,
  (VTBL_ENTRY)&_ZN6S530C43v86Ev,
  (VTBL_ENTRY)&_ZN6S530C43v87Ev,
  (VTBL_ENTRY)&_ZN6S530C43v88Ev,
  (VTBL_ENTRY)&_ZN6S530C33v89Ev,
  (VTBL_ENTRY)&_ZN6S530C33v90Ev,
  (VTBL_ENTRY)&_ZN6S530C33v91Ev,
  (VTBL_ENTRY)&_ZN6S530C33v92Ev,
  (VTBL_ENTRY)&_ZN6S530C33v93Ev,
  (VTBL_ENTRY)&_ZN6S530C33v94Ev,
  (VTBL_ENTRY)&_ZN6S530C33v95Ev,
  (VTBL_ENTRY)&_ZN6S530C33v96Ev,
  (VTBL_ENTRY)&_ZN6S530C33v97Ev,
  (VTBL_ENTRY)&_ZN6S530C33v98Ev,
  (VTBL_ENTRY)&_ZN6S530C33v99Ev,
  (VTBL_ENTRY)&_ZN6S530C34v100Ev,
  (VTBL_ENTRY)&_ZN6S530C34v101Ev,
  (VTBL_ENTRY)&_ZN6S530C34v102Ev,
  (VTBL_ENTRY)&_ZN6S530C34v103Ev,
  (VTBL_ENTRY)&_ZN6S530C34v104Ev,
  (VTBL_ENTRY)&_ZN6S530C34v105Ev,
  (VTBL_ENTRY)&_ZN6S530C34v106Ev,
  (VTBL_ENTRY)&_ZN6S530C34v107Ev,
  (VTBL_ENTRY)&_ZN6S530C34v108Ev,
};
extern VTBL_ENTRY _ZTI6S530C3[];
extern  VTBL_ENTRY _ZTV6S530C3[];
Class_Descriptor cd_S530C3 = {  "S530C3", // class name
  bases_S530C3, 2,
  &(vtc_S530C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI6S530C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S530C3),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S530C2  : S530C3 {
  ::S1457C5_nt s530c2f0;
  unsigned int s530c2f1:1;
  ::S1412C18_nt s530c2f2;
  virtual  ~S530C2(); // _ZN6S530C2D1Ev
  virtual void  v109(); // _ZN6S530C24v109Ev
  virtual void  v110(); // _ZN6S530C24v110Ev
  virtual void  v111(); // _ZN6S530C24v111Ev
  virtual void  v112(); // _ZN6S530C24v112Ev
  S530C2(); // tgen
};
//SIG(-1 S530C2) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} FC17{ BC18{ BC9}} Fi[3]} vd v1 v2 v3 v4 FC5 Fi:1 FC19{ BC20{ BC9}}}


 S530C2 ::~S530C2(){ note_dtor("S530C2", this);}
void  S530C2 ::v109(){vfunc_called(this, "_ZN6S530C24v109Ev");}
void  S530C2 ::v110(){vfunc_called(this, "_ZN6S530C24v110Ev");}
void  S530C2 ::v111(){vfunc_called(this, "_ZN6S530C24v111Ev");}
void  S530C2 ::v112(){vfunc_called(this, "_ZN6S530C24v112Ev");}
S530C2 ::S530C2(){ note_ctor("S530C2", this);} // tgen

static void Test_S530C2()
{
  extern Class_Descriptor cd_S530C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(38,56)];
    init_test(&cd_S530C2, buf);
    S530C2 *dp, &lv = *(dp=new (buf) S530C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(296,220), "sizeof(S530C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S530C2)");
    check_base_class_offset(lv, (S530C5*)(S530C4*)(S530C3*), 0, "S530C2");
    check_base_class_offset(lv, (S530C4*)(S530C3*), 0, "S530C2");
    check_base_class_offset(lv, (S530C3*), 0, "S530C2");
    check_field_offset(lv, s530c2f0, ABISELECT(268,196), "S530C2.s530c2f0");
    set_bf_and_test(lv, s530c2f1, ABISELECT(276,204), 0, 1, 1, "S530C2");
    check_field_offset(lv, s530c2f2, ABISELECT(280,208), "S530C2.s530c2f2");
    test_class_info(&lv, &cd_S530C2);
    dp->~S530C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS530C2(Test_S530C2, "S530C2", ABISELECT(296,220));

#else // __cplusplus

extern void _ZN6S530C2C1Ev();
extern void _ZN6S530C2D1Ev();
Name_Map name_map_S530C2[] = {
  NSPAIR(_ZN6S530C2C1Ev),
  NSPAIR(_ZN6S530C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S530C5;
extern VTBL_ENTRY _ZTI6S530C5[];
extern  VTBL_ENTRY _ZTV6S530C5[];
extern Class_Descriptor cd_S530C4;
extern VTBL_ENTRY _ZTI6S530C4[];
extern  VTBL_ENTRY _ZTV6S530C4[];
extern Class_Descriptor cd_S530C3;
extern VTBL_ENTRY _ZTI6S530C3[];
extern  VTBL_ENTRY _ZTV6S530C3[];
static Base_Class bases_S530C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S530C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S530C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S530C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S530C2[];
extern void _ZN6S530C2D1Ev();
extern void _ZN6S530C2D0Ev();
extern void _ZN6S530C52v3Ev();
extern void _ZN6S530C52v4Ev();
extern void _ZN6S530C52v5Ev();
extern void _ZN6S530C52v6Ev();
extern void _ZN6S530C52v7Ev();
extern void _ZN6S530C52v8Ev();
extern void _ZN6S530C52v9Ev();
extern void _ZN6S530C53v10Ev();
extern void _ZN6S530C53v11Ev();
extern void _ZN6S530C53v12Ev();
extern void _ZN6S530C53v13Ev();
extern void _ZN6S530C53v14Ev();
extern void _ZN6S530C53v15Ev();
extern void _ZN6S530C53v16Ev();
extern void _ZN6S530C53v17Ev();
extern void _ZN6S530C53v18Ev();
extern void _ZN6S530C53v19Ev();
extern void _ZN6S530C53v20Ev();
extern void _ZN6S530C53v21Ev();
extern void _ZN6S530C53v22Ev();
extern void _ZN6S530C53v23Ev();
extern void _ZN6S530C53v24Ev();
extern void _ZN6S530C53v25Ev();
extern void _ZN6S530C53v26Ev();
extern void _ZN6S530C53v27Ev();
extern void _ZN6S530C53v28Ev();
extern void _ZN6S530C53v29Ev();
extern void _ZN6S530C53v30Ev();
extern void _ZN6S530C53v31Ev();
extern void _ZN6S530C53v32Ev();
extern void _ZN6S530C53v33Ev();
extern void _ZN6S530C53v34Ev();
extern void _ZN6S530C53v35Ev();
extern void _ZN6S530C53v36Ev();
extern void _ZN6S530C53v37Ev();
extern void _ZN6S530C53v38Ev();
extern void _ZN6S530C53v39Ev();
extern void _ZN6S530C53v40Ev();
extern void _ZN6S530C53v41Ev();
extern void _ZN6S530C53v42Ev();
extern void _ZN6S530C53v43Ev();
extern void _ZN6S530C53v44Ev();
extern void _ZN6S530C53v45Ev();
extern void _ZN6S530C53v46Ev();
extern void _ZN6S530C53v47Ev();
extern void _ZN6S530C53v48Ev();
extern void _ZN6S530C53v49Ev();
extern void _ZN6S530C53v50Ev();
extern void _ZN6S530C53v51Ev();
extern void _ZN6S530C53v52Ev();
extern void _ZN6S530C53v53Ev();
extern void _ZN6S530C53v54Ev();
extern void _ZN6S530C53v55Ev();
extern void _ZN6S530C53v56Ev();
extern void _ZN6S530C53v57Ev();
extern void _ZN6S530C53v58Ev();
extern void _ZN6S530C53v59Ev();
extern void _ZN6S530C53v60Ev();
extern void _ZN6S530C53v61Ev();
extern void _ZN6S530C53v62Ev();
extern void _ZN6S530C53v63Ev();
extern void _ZN6S530C53v64Ev();
extern void _ZN6S530C53v65Ev();
extern void _ZN6S530C53v66Ev();
extern void _ZN6S530C43v67Ev();
extern void _ZN6S530C43v68Ev();
extern void _ZN6S530C43v69Ev();
extern void _ZN6S530C43v70Ev();
extern void _ZN6S530C43v71Ev();
extern void _ZN6S530C43v72Ev();
extern void _ZN6S530C43v73Ev();
extern void _ZN6S530C43v74Ev();
extern void _ZN6S530C43v75Ev();
extern void _ZN6S530C43v76Ev();
extern void _ZN6S530C43v77Ev();
extern void _ZN6S530C43v78Ev();
extern void _ZN6S530C43v79Ev();
extern void _ZN6S530C43v80Ev();
extern void _ZN6S530C43v81Ev();
extern void _ZN6S530C43v82Ev();
extern void _ZN6S530C43v83Ev();
extern void _ZN6S530C43v84Ev();
extern void _ZN6S530C43v85Ev();
extern void _ZN6S530C43v86Ev();
extern void _ZN6S530C43v87Ev();
extern void _ZN6S530C43v88Ev();
extern void _ZN6S530C33v89Ev();
extern void _ZN6S530C33v90Ev();
extern void _ZN6S530C33v91Ev();
extern void _ZN6S530C33v92Ev();
extern void _ZN6S530C33v93Ev();
extern void _ZN6S530C33v94Ev();
extern void _ZN6S530C33v95Ev();
extern void _ZN6S530C33v96Ev();
extern void _ZN6S530C33v97Ev();
extern void _ZN6S530C33v98Ev();
extern void _ZN6S530C33v99Ev();
extern void _ZN6S530C34v100Ev();
extern void _ZN6S530C34v101Ev();
extern void _ZN6S530C34v102Ev();
extern void _ZN6S530C34v103Ev();
extern void _ZN6S530C34v104Ev();
extern void _ZN6S530C34v105Ev();
extern void _ZN6S530C34v106Ev();
extern void _ZN6S530C34v107Ev();
extern void _ZN6S530C34v108Ev();
extern void _ZN6S530C24v109Ev();
extern void _ZN6S530C24v110Ev();
extern void _ZN6S530C24v111Ev();
extern void _ZN6S530C24v112Ev();
static  VTBL_ENTRY vtc_S530C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S530C2[0]),
  (VTBL_ENTRY)&_ZN6S530C2D1Ev,
  (VTBL_ENTRY)&_ZN6S530C2D0Ev,
  (VTBL_ENTRY)&_ZN6S530C52v3Ev,
  (VTBL_ENTRY)&_ZN6S530C52v4Ev,
  (VTBL_ENTRY)&_ZN6S530C52v5Ev,
  (VTBL_ENTRY)&_ZN6S530C52v6Ev,
  (VTBL_ENTRY)&_ZN6S530C52v7Ev,
  (VTBL_ENTRY)&_ZN6S530C52v8Ev,
  (VTBL_ENTRY)&_ZN6S530C52v9Ev,
  (VTBL_ENTRY)&_ZN6S530C53v10Ev,
  (VTBL_ENTRY)&_ZN6S530C53v11Ev,
  (VTBL_ENTRY)&_ZN6S530C53v12Ev,
  (VTBL_ENTRY)&_ZN6S530C53v13Ev,
  (VTBL_ENTRY)&_ZN6S530C53v14Ev,
  (VTBL_ENTRY)&_ZN6S530C53v15Ev,
  (VTBL_ENTRY)&_ZN6S530C53v16Ev,
  (VTBL_ENTRY)&_ZN6S530C53v17Ev,
  (VTBL_ENTRY)&_ZN6S530C53v18Ev,
  (VTBL_ENTRY)&_ZN6S530C53v19Ev,
  (VTBL_ENTRY)&_ZN6S530C53v20Ev,
  (VTBL_ENTRY)&_ZN6S530C53v21Ev,
  (VTBL_ENTRY)&_ZN6S530C53v22Ev,
  (VTBL_ENTRY)&_ZN6S530C53v23Ev,
  (VTBL_ENTRY)&_ZN6S530C53v24Ev,
  (VTBL_ENTRY)&_ZN6S530C53v25Ev,
  (VTBL_ENTRY)&_ZN6S530C53v26Ev,
  (VTBL_ENTRY)&_ZN6S530C53v27Ev,
  (VTBL_ENTRY)&_ZN6S530C53v28Ev,
  (VTBL_ENTRY)&_ZN6S530C53v29Ev,
  (VTBL_ENTRY)&_ZN6S530C53v30Ev,
  (VTBL_ENTRY)&_ZN6S530C53v31Ev,
  (VTBL_ENTRY)&_ZN6S530C53v32Ev,
  (VTBL_ENTRY)&_ZN6S530C53v33Ev,
  (VTBL_ENTRY)&_ZN6S530C53v34Ev,
  (VTBL_ENTRY)&_ZN6S530C53v35Ev,
  (VTBL_ENTRY)&_ZN6S530C53v36Ev,
  (VTBL_ENTRY)&_ZN6S530C53v37Ev,
  (VTBL_ENTRY)&_ZN6S530C53v38Ev,
  (VTBL_ENTRY)&_ZN6S530C53v39Ev,
  (VTBL_ENTRY)&_ZN6S530C53v40Ev,
  (VTBL_ENTRY)&_ZN6S530C53v41Ev,
  (VTBL_ENTRY)&_ZN6S530C53v42Ev,
  (VTBL_ENTRY)&_ZN6S530C53v43Ev,
  (VTBL_ENTRY)&_ZN6S530C53v44Ev,
  (VTBL_ENTRY)&_ZN6S530C53v45Ev,
  (VTBL_ENTRY)&_ZN6S530C53v46Ev,
  (VTBL_ENTRY)&_ZN6S530C53v47Ev,
  (VTBL_ENTRY)&_ZN6S530C53v48Ev,
  (VTBL_ENTRY)&_ZN6S530C53v49Ev,
  (VTBL_ENTRY)&_ZN6S530C53v50Ev,
  (VTBL_ENTRY)&_ZN6S530C53v51Ev,
  (VTBL_ENTRY)&_ZN6S530C53v52Ev,
  (VTBL_ENTRY)&_ZN6S530C53v53Ev,
  (VTBL_ENTRY)&_ZN6S530C53v54Ev,
  (VTBL_ENTRY)&_ZN6S530C53v55Ev,
  (VTBL_ENTRY)&_ZN6S530C53v56Ev,
  (VTBL_ENTRY)&_ZN6S530C53v57Ev,
  (VTBL_ENTRY)&_ZN6S530C53v58Ev,
  (VTBL_ENTRY)&_ZN6S530C53v59Ev,
  (VTBL_ENTRY)&_ZN6S530C53v60Ev,
  (VTBL_ENTRY)&_ZN6S530C53v61Ev,
  (VTBL_ENTRY)&_ZN6S530C53v62Ev,
  (VTBL_ENTRY)&_ZN6S530C53v63Ev,
  (VTBL_ENTRY)&_ZN6S530C53v64Ev,
  (VTBL_ENTRY)&_ZN6S530C53v65Ev,
  (VTBL_ENTRY)&_ZN6S530C53v66Ev,
  (VTBL_ENTRY)&_ZN6S530C43v67Ev,
  (VTBL_ENTRY)&_ZN6S530C43v68Ev,
  (VTBL_ENTRY)&_ZN6S530C43v69Ev,
  (VTBL_ENTRY)&_ZN6S530C43v70Ev,
  (VTBL_ENTRY)&_ZN6S530C43v71Ev,
  (VTBL_ENTRY)&_ZN6S530C43v72Ev,
  (VTBL_ENTRY)&_ZN6S530C43v73Ev,
  (VTBL_ENTRY)&_ZN6S530C43v74Ev,
  (VTBL_ENTRY)&_ZN6S530C43v75Ev,
  (VTBL_ENTRY)&_ZN6S530C43v76Ev,
  (VTBL_ENTRY)&_ZN6S530C43v77Ev,
  (VTBL_ENTRY)&_ZN6S530C43v78Ev,
  (VTBL_ENTRY)&_ZN6S530C43v79Ev,
  (VTBL_ENTRY)&_ZN6S530C43v80Ev,
  (VTBL_ENTRY)&_ZN6S530C43v81Ev,
  (VTBL_ENTRY)&_ZN6S530C43v82Ev,
  (VTBL_ENTRY)&_ZN6S530C43v83Ev,
  (VTBL_ENTRY)&_ZN6S530C43v84Ev,
  (VTBL_ENTRY)&_ZN6S530C43v85Ev,
  (VTBL_ENTRY)&_ZN6S530C43v86Ev,
  (VTBL_ENTRY)&_ZN6S530C43v87Ev,
  (VTBL_ENTRY)&_ZN6S530C43v88Ev,
  (VTBL_ENTRY)&_ZN6S530C33v89Ev,
  (VTBL_ENTRY)&_ZN6S530C33v90Ev,
  (VTBL_ENTRY)&_ZN6S530C33v91Ev,
  (VTBL_ENTRY)&_ZN6S530C33v92Ev,
  (VTBL_ENTRY)&_ZN6S530C33v93Ev,
  (VTBL_ENTRY)&_ZN6S530C33v94Ev,
  (VTBL_ENTRY)&_ZN6S530C33v95Ev,
  (VTBL_ENTRY)&_ZN6S530C33v96Ev,
  (VTBL_ENTRY)&_ZN6S530C33v97Ev,
  (VTBL_ENTRY)&_ZN6S530C33v98Ev,
  (VTBL_ENTRY)&_ZN6S530C33v99Ev,
  (VTBL_ENTRY)&_ZN6S530C34v100Ev,
  (VTBL_ENTRY)&_ZN6S530C34v101Ev,
  (VTBL_ENTRY)&_ZN6S530C34v102Ev,
  (VTBL_ENTRY)&_ZN6S530C34v103Ev,
  (VTBL_ENTRY)&_ZN6S530C34v104Ev,
  (VTBL_ENTRY)&_ZN6S530C34v105Ev,
  (VTBL_ENTRY)&_ZN6S530C34v106Ev,
  (VTBL_ENTRY)&_ZN6S530C34v107Ev,
  (VTBL_ENTRY)&_ZN6S530C34v108Ev,
  (VTBL_ENTRY)&_ZN6S530C24v109Ev,
  (VTBL_ENTRY)&_ZN6S530C24v110Ev,
  (VTBL_ENTRY)&_ZN6S530C24v111Ev,
  (VTBL_ENTRY)&_ZN6S530C24v112Ev,
};
extern VTBL_ENTRY _ZTI6S530C2[];
extern  VTBL_ENTRY _ZTV6S530C2[];
Class_Descriptor cd_S530C2 = {  "S530C2", // class name
  bases_S530C2, 3,
  &(vtc_S530C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,220), // object size
  NSPAIRA(_ZTI6S530C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S530C2),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S530C1  : S530C2 {
  void *s530c1f0;
  ::S694C7_nt s530c1f1;
  ::S694C7_nt s530c1f2;
  virtual  ~S530C1(); // _ZN6S530C1D1Ev
  virtual void  v1(); // _ZN6S530C12v1Ev
  virtual void  v2(); // _ZN6S530C12v2Ev
  S530C1(); // tgen
};
//SIG(1 S530C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} FC18{ BC19{ BC10}} Fi[3]} vd v109 v110 v111 v112 FC6 Fi:1 FC20{ BC21{ BC10}}} vd v1 v2 Fp FC7 FC7}


 S530C1 ::~S530C1(){ note_dtor("S530C1", this);}
void  S530C1 ::v1(){vfunc_called(this, "_ZN6S530C12v1Ev");}
void  S530C1 ::v2(){vfunc_called(this, "_ZN6S530C12v2Ev");}
S530C1 ::S530C1(){ note_ctor("S530C1", this);} // tgen

static void Test_S530C1()
{
  extern Class_Descriptor cd_S530C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(43,63)];
    init_test(&cd_S530C1, buf);
    S530C1 *dp, &lv = *(dp=new (buf) S530C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(336,248), "sizeof(S530C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S530C1)");
    check_base_class_offset(lv, (S530C5*)(S530C4*)(S530C3*)(S530C2*), 0, "S530C1");
    check_base_class_offset(lv, (S530C4*)(S530C3*)(S530C2*), 0, "S530C1");
    check_base_class_offset(lv, (S530C3*)(S530C2*), 0, "S530C1");
    check_base_class_offset(lv, (S530C2*), 0, "S530C1");
    check_field_offset(lv, s530c1f0, ABISELECT(296,220), "S530C1.s530c1f0");
    check_field_offset(lv, s530c1f1, ABISELECT(304,224), "S530C1.s530c1f1");
    check_field_offset(lv, s530c1f2, ABISELECT(320,236), "S530C1.s530c1f2");
    test_class_info(&lv, &cd_S530C1);
    dp->~S530C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS530C1(Test_S530C1, "S530C1", ABISELECT(336,248));

#else // __cplusplus

extern void _ZN6S530C1C1Ev();
extern void _ZN6S530C1D1Ev();
Name_Map name_map_S530C1[] = {
  NSPAIR(_ZN6S530C1C1Ev),
  NSPAIR(_ZN6S530C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S530C5;
extern VTBL_ENTRY _ZTI6S530C5[];
extern  VTBL_ENTRY _ZTV6S530C5[];
extern Class_Descriptor cd_S530C4;
extern VTBL_ENTRY _ZTI6S530C4[];
extern  VTBL_ENTRY _ZTV6S530C4[];
extern Class_Descriptor cd_S530C3;
extern VTBL_ENTRY _ZTI6S530C3[];
extern  VTBL_ENTRY _ZTV6S530C3[];
extern Class_Descriptor cd_S530C2;
extern VTBL_ENTRY _ZTI6S530C2[];
extern  VTBL_ENTRY _ZTV6S530C2[];
static Base_Class bases_S530C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S530C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S530C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S530C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S530C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S530C1[];
extern void _ZN6S530C1D1Ev();
extern void _ZN6S530C1D0Ev();
extern void _ZN6S530C52v3Ev();
extern void _ZN6S530C52v4Ev();
extern void _ZN6S530C52v5Ev();
extern void _ZN6S530C52v6Ev();
extern void _ZN6S530C52v7Ev();
extern void _ZN6S530C52v8Ev();
extern void _ZN6S530C52v9Ev();
extern void _ZN6S530C53v10Ev();
extern void _ZN6S530C53v11Ev();
extern void _ZN6S530C53v12Ev();
extern void _ZN6S530C53v13Ev();
extern void _ZN6S530C53v14Ev();
extern void _ZN6S530C53v15Ev();
extern void _ZN6S530C53v16Ev();
extern void _ZN6S530C53v17Ev();
extern void _ZN6S530C53v18Ev();
extern void _ZN6S530C53v19Ev();
extern void _ZN6S530C53v20Ev();
extern void _ZN6S530C53v21Ev();
extern void _ZN6S530C53v22Ev();
extern void _ZN6S530C53v23Ev();
extern void _ZN6S530C53v24Ev();
extern void _ZN6S530C53v25Ev();
extern void _ZN6S530C53v26Ev();
extern void _ZN6S530C53v27Ev();
extern void _ZN6S530C53v28Ev();
extern void _ZN6S530C53v29Ev();
extern void _ZN6S530C53v30Ev();
extern void _ZN6S530C53v31Ev();
extern void _ZN6S530C53v32Ev();
extern void _ZN6S530C53v33Ev();
extern void _ZN6S530C53v34Ev();
extern void _ZN6S530C53v35Ev();
extern void _ZN6S530C53v36Ev();
extern void _ZN6S530C53v37Ev();
extern void _ZN6S530C53v38Ev();
extern void _ZN6S530C53v39Ev();
extern void _ZN6S530C53v40Ev();
extern void _ZN6S530C53v41Ev();
extern void _ZN6S530C53v42Ev();
extern void _ZN6S530C53v43Ev();
extern void _ZN6S530C53v44Ev();
extern void _ZN6S530C53v45Ev();
extern void _ZN6S530C53v46Ev();
extern void _ZN6S530C53v47Ev();
extern void _ZN6S530C53v48Ev();
extern void _ZN6S530C53v49Ev();
extern void _ZN6S530C53v50Ev();
extern void _ZN6S530C53v51Ev();
extern void _ZN6S530C53v52Ev();
extern void _ZN6S530C53v53Ev();
extern void _ZN6S530C53v54Ev();
extern void _ZN6S530C53v55Ev();
extern void _ZN6S530C53v56Ev();
extern void _ZN6S530C53v57Ev();
extern void _ZN6S530C53v58Ev();
extern void _ZN6S530C53v59Ev();
extern void _ZN6S530C53v60Ev();
extern void _ZN6S530C53v61Ev();
extern void _ZN6S530C53v62Ev();
extern void _ZN6S530C53v63Ev();
extern void _ZN6S530C53v64Ev();
extern void _ZN6S530C53v65Ev();
extern void _ZN6S530C53v66Ev();
extern void _ZN6S530C43v67Ev();
extern void _ZN6S530C43v68Ev();
extern void _ZN6S530C43v69Ev();
extern void _ZN6S530C43v70Ev();
extern void _ZN6S530C43v71Ev();
extern void _ZN6S530C43v72Ev();
extern void _ZN6S530C43v73Ev();
extern void _ZN6S530C43v74Ev();
extern void _ZN6S530C43v75Ev();
extern void _ZN6S530C43v76Ev();
extern void _ZN6S530C43v77Ev();
extern void _ZN6S530C43v78Ev();
extern void _ZN6S530C43v79Ev();
extern void _ZN6S530C43v80Ev();
extern void _ZN6S530C43v81Ev();
extern void _ZN6S530C43v82Ev();
extern void _ZN6S530C43v83Ev();
extern void _ZN6S530C43v84Ev();
extern void _ZN6S530C43v85Ev();
extern void _ZN6S530C43v86Ev();
extern void _ZN6S530C43v87Ev();
extern void _ZN6S530C43v88Ev();
extern void _ZN6S530C33v89Ev();
extern void _ZN6S530C33v90Ev();
extern void _ZN6S530C33v91Ev();
extern void _ZN6S530C33v92Ev();
extern void _ZN6S530C33v93Ev();
extern void _ZN6S530C33v94Ev();
extern void _ZN6S530C33v95Ev();
extern void _ZN6S530C33v96Ev();
extern void _ZN6S530C33v97Ev();
extern void _ZN6S530C33v98Ev();
extern void _ZN6S530C33v99Ev();
extern void _ZN6S530C34v100Ev();
extern void _ZN6S530C34v101Ev();
extern void _ZN6S530C34v102Ev();
extern void _ZN6S530C34v103Ev();
extern void _ZN6S530C34v104Ev();
extern void _ZN6S530C34v105Ev();
extern void _ZN6S530C34v106Ev();
extern void _ZN6S530C34v107Ev();
extern void _ZN6S530C34v108Ev();
extern void _ZN6S530C24v109Ev();
extern void _ZN6S530C24v110Ev();
extern void _ZN6S530C24v111Ev();
extern void _ZN6S530C24v112Ev();
extern void _ZN6S530C12v1Ev();
extern void _ZN6S530C12v2Ev();
static  VTBL_ENTRY vtc_S530C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S530C1[0]),
  (VTBL_ENTRY)&_ZN6S530C1D1Ev,
  (VTBL_ENTRY)&_ZN6S530C1D0Ev,
  (VTBL_ENTRY)&_ZN6S530C52v3Ev,
  (VTBL_ENTRY)&_ZN6S530C52v4Ev,
  (VTBL_ENTRY)&_ZN6S530C52v5Ev,
  (VTBL_ENTRY)&_ZN6S530C52v6Ev,
  (VTBL_ENTRY)&_ZN6S530C52v7Ev,
  (VTBL_ENTRY)&_ZN6S530C52v8Ev,
  (VTBL_ENTRY)&_ZN6S530C52v9Ev,
  (VTBL_ENTRY)&_ZN6S530C53v10Ev,
  (VTBL_ENTRY)&_ZN6S530C53v11Ev,
  (VTBL_ENTRY)&_ZN6S530C53v12Ev,
  (VTBL_ENTRY)&_ZN6S530C53v13Ev,
  (VTBL_ENTRY)&_ZN6S530C53v14Ev,
  (VTBL_ENTRY)&_ZN6S530C53v15Ev,
  (VTBL_ENTRY)&_ZN6S530C53v16Ev,
  (VTBL_ENTRY)&_ZN6S530C53v17Ev,
  (VTBL_ENTRY)&_ZN6S530C53v18Ev,
  (VTBL_ENTRY)&_ZN6S530C53v19Ev,
  (VTBL_ENTRY)&_ZN6S530C53v20Ev,
  (VTBL_ENTRY)&_ZN6S530C53v21Ev,
  (VTBL_ENTRY)&_ZN6S530C53v22Ev,
  (VTBL_ENTRY)&_ZN6S530C53v23Ev,
  (VTBL_ENTRY)&_ZN6S530C53v24Ev,
  (VTBL_ENTRY)&_ZN6S530C53v25Ev,
  (VTBL_ENTRY)&_ZN6S530C53v26Ev,
  (VTBL_ENTRY)&_ZN6S530C53v27Ev,
  (VTBL_ENTRY)&_ZN6S530C53v28Ev,
  (VTBL_ENTRY)&_ZN6S530C53v29Ev,
  (VTBL_ENTRY)&_ZN6S530C53v30Ev,
  (VTBL_ENTRY)&_ZN6S530C53v31Ev,
  (VTBL_ENTRY)&_ZN6S530C53v32Ev,
  (VTBL_ENTRY)&_ZN6S530C53v33Ev,
  (VTBL_ENTRY)&_ZN6S530C53v34Ev,
  (VTBL_ENTRY)&_ZN6S530C53v35Ev,
  (VTBL_ENTRY)&_ZN6S530C53v36Ev,
  (VTBL_ENTRY)&_ZN6S530C53v37Ev,
  (VTBL_ENTRY)&_ZN6S530C53v38Ev,
  (VTBL_ENTRY)&_ZN6S530C53v39Ev,
  (VTBL_ENTRY)&_ZN6S530C53v40Ev,
  (VTBL_ENTRY)&_ZN6S530C53v41Ev,
  (VTBL_ENTRY)&_ZN6S530C53v42Ev,
  (VTBL_ENTRY)&_ZN6S530C53v43Ev,
  (VTBL_ENTRY)&_ZN6S530C53v44Ev,
  (VTBL_ENTRY)&_ZN6S530C53v45Ev,
  (VTBL_ENTRY)&_ZN6S530C53v46Ev,
  (VTBL_ENTRY)&_ZN6S530C53v47Ev,
  (VTBL_ENTRY)&_ZN6S530C53v48Ev,
  (VTBL_ENTRY)&_ZN6S530C53v49Ev,
  (VTBL_ENTRY)&_ZN6S530C53v50Ev,
  (VTBL_ENTRY)&_ZN6S530C53v51Ev,
  (VTBL_ENTRY)&_ZN6S530C53v52Ev,
  (VTBL_ENTRY)&_ZN6S530C53v53Ev,
  (VTBL_ENTRY)&_ZN6S530C53v54Ev,
  (VTBL_ENTRY)&_ZN6S530C53v55Ev,
  (VTBL_ENTRY)&_ZN6S530C53v56Ev,
  (VTBL_ENTRY)&_ZN6S530C53v57Ev,
  (VTBL_ENTRY)&_ZN6S530C53v58Ev,
  (VTBL_ENTRY)&_ZN6S530C53v59Ev,
  (VTBL_ENTRY)&_ZN6S530C53v60Ev,
  (VTBL_ENTRY)&_ZN6S530C53v61Ev,
  (VTBL_ENTRY)&_ZN6S530C53v62Ev,
  (VTBL_ENTRY)&_ZN6S530C53v63Ev,
  (VTBL_ENTRY)&_ZN6S530C53v64Ev,
  (VTBL_ENTRY)&_ZN6S530C53v65Ev,
  (VTBL_ENTRY)&_ZN6S530C53v66Ev,
  (VTBL_ENTRY)&_ZN6S530C43v67Ev,
  (VTBL_ENTRY)&_ZN6S530C43v68Ev,
  (VTBL_ENTRY)&_ZN6S530C43v69Ev,
  (VTBL_ENTRY)&_ZN6S530C43v70Ev,
  (VTBL_ENTRY)&_ZN6S530C43v71Ev,
  (VTBL_ENTRY)&_ZN6S530C43v72Ev,
  (VTBL_ENTRY)&_ZN6S530C43v73Ev,
  (VTBL_ENTRY)&_ZN6S530C43v74Ev,
  (VTBL_ENTRY)&_ZN6S530C43v75Ev,
  (VTBL_ENTRY)&_ZN6S530C43v76Ev,
  (VTBL_ENTRY)&_ZN6S530C43v77Ev,
  (VTBL_ENTRY)&_ZN6S530C43v78Ev,
  (VTBL_ENTRY)&_ZN6S530C43v79Ev,
  (VTBL_ENTRY)&_ZN6S530C43v80Ev,
  (VTBL_ENTRY)&_ZN6S530C43v81Ev,
  (VTBL_ENTRY)&_ZN6S530C43v82Ev,
  (VTBL_ENTRY)&_ZN6S530C43v83Ev,
  (VTBL_ENTRY)&_ZN6S530C43v84Ev,
  (VTBL_ENTRY)&_ZN6S530C43v85Ev,
  (VTBL_ENTRY)&_ZN6S530C43v86Ev,
  (VTBL_ENTRY)&_ZN6S530C43v87Ev,
  (VTBL_ENTRY)&_ZN6S530C43v88Ev,
  (VTBL_ENTRY)&_ZN6S530C33v89Ev,
  (VTBL_ENTRY)&_ZN6S530C33v90Ev,
  (VTBL_ENTRY)&_ZN6S530C33v91Ev,
  (VTBL_ENTRY)&_ZN6S530C33v92Ev,
  (VTBL_ENTRY)&_ZN6S530C33v93Ev,
  (VTBL_ENTRY)&_ZN6S530C33v94Ev,
  (VTBL_ENTRY)&_ZN6S530C33v95Ev,
  (VTBL_ENTRY)&_ZN6S530C33v96Ev,
  (VTBL_ENTRY)&_ZN6S530C33v97Ev,
  (VTBL_ENTRY)&_ZN6S530C33v98Ev,
  (VTBL_ENTRY)&_ZN6S530C33v99Ev,
  (VTBL_ENTRY)&_ZN6S530C34v100Ev,
  (VTBL_ENTRY)&_ZN6S530C34v101Ev,
  (VTBL_ENTRY)&_ZN6S530C34v102Ev,
  (VTBL_ENTRY)&_ZN6S530C34v103Ev,
  (VTBL_ENTRY)&_ZN6S530C34v104Ev,
  (VTBL_ENTRY)&_ZN6S530C34v105Ev,
  (VTBL_ENTRY)&_ZN6S530C34v106Ev,
  (VTBL_ENTRY)&_ZN6S530C34v107Ev,
  (VTBL_ENTRY)&_ZN6S530C34v108Ev,
  (VTBL_ENTRY)&_ZN6S530C24v109Ev,
  (VTBL_ENTRY)&_ZN6S530C24v110Ev,
  (VTBL_ENTRY)&_ZN6S530C24v111Ev,
  (VTBL_ENTRY)&_ZN6S530C24v112Ev,
  (VTBL_ENTRY)&_ZN6S530C12v1Ev,
  (VTBL_ENTRY)&_ZN6S530C12v2Ev,
};
extern VTBL_ENTRY _ZTI6S530C1[];
extern  VTBL_ENTRY _ZTV6S530C1[];
Class_Descriptor cd_S530C1 = {  "S530C1", // class name
  bases_S530C1, 4,
  &(vtc_S530C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(336,248), // object size
  NSPAIRA(_ZTI6S530C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S530C1),116, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S814C5_nt  {
  void  mf814c5(); // _ZN9S814C5_nt7mf814c5Ev
  virtual  ~S814C5_nt(); // _ZN9S814C5_ntD1Ev
  S814C5_nt(); // tgen
};
//SIG(-1 S814C5_nt) C1{ vd m}


void  S814C5_nt ::mf814c5(){}
 S814C5_nt ::~S814C5_nt(){ note_dtor("S814C5_nt", this);}
S814C5_nt ::S814C5_nt(){ note_ctor("S814C5_nt", this);} // tgen

//skip512 S814C5_nt

#else // __cplusplus

extern void _ZN9S814C5_ntC1Ev();
extern void _ZN9S814C5_ntD1Ev();
Name_Map name_map_S814C5_nt[] = {
  NSPAIR(_ZN9S814C5_ntC1Ev),
  NSPAIR(_ZN9S814C5_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern void _ZN9S814C5_ntD1Ev();
extern void _ZN9S814C5_ntD0Ev();
static  VTBL_ENTRY vtc_S814C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S814C5_nt[0]),
  (VTBL_ENTRY)&_ZN9S814C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S814C5_ntD0Ev,
};
extern VTBL_ENTRY _ZTI9S814C5_nt[];
VTBL_ENTRY *P__ZTI9S814C5_nt = _ZTI9S814C5_nt; 
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
Class_Descriptor cd_S814C5_nt = {  "S814C5_nt", // class name
  0,0,//no base classes
  &(vtc_S814C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S814C5_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S814C5_nt),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S814C4  : S814C5_nt {
  short s814c4f0[2];
  virtual  ~S814C4(); // _ZN6S814C4D1Ev
  virtual void  v4(); // _ZN6S814C42v4Ev
  S814C4(); // tgen
};
//SIG(-1 S814C4) C1{ BC2{ vd m} vd v1 Fs[2]}


 S814C4 ::~S814C4(){ note_dtor("S814C4", this);}
void  S814C4 ::v4(){vfunc_called(this, "_ZN6S814C42v4Ev");}
S814C4 ::S814C4(){ note_ctor("S814C4", this);} // tgen

static void Test_S814C4()
{
  extern Class_Descriptor cd_S814C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S814C4, buf);
    S814C4 *dp, &lv = *(dp=new (buf) S814C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S814C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S814C4)");
    check_base_class_offset(lv, (S814C5_nt*), 0, "S814C4");
    check_field_offset(lv, s814c4f0, ABISELECT(8,4), "S814C4.s814c4f0");
    test_class_info(&lv, &cd_S814C4);
    dp->~S814C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS814C4(Test_S814C4, "S814C4", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN6S814C4C1Ev();
extern void _ZN6S814C4D1Ev();
Name_Map name_map_S814C4[] = {
  NSPAIR(_ZN6S814C4C1Ev),
  NSPAIR(_ZN6S814C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
static Base_Class bases_S814C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S814C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S814C4[];
extern void _ZN6S814C4D1Ev();
extern void _ZN6S814C4D0Ev();
extern void _ZN6S814C42v4Ev();
static  VTBL_ENTRY vtc_S814C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S814C4[0]),
  (VTBL_ENTRY)&_ZN6S814C4D1Ev,
  (VTBL_ENTRY)&_ZN6S814C4D0Ev,
  (VTBL_ENTRY)&_ZN6S814C42v4Ev,
};
extern VTBL_ENTRY _ZTI6S814C4[];
extern  VTBL_ENTRY _ZTV6S814C4[];
Class_Descriptor cd_S814C4 = {  "S814C4", // class name
  bases_S814C4, 1,
  &(vtc_S814C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI6S814C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S814C4),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S814C6  {
  int s814c6f0;
  short s814c6f1[2];
  void  mf814c6(); // _ZN6S814C67mf814c6Ev
};
//SIG(-1 S814C6) C1{ m Fi Fs[2]}


void  S814C6 ::mf814c6(){}

static void Test_S814C6()
{
  {
    init_simple_test("S814C6");
    S814C6 lv;
    check2(sizeof(lv), 8, "sizeof(S814C6)");
    check2(__alignof__(lv), 4, "__alignof__(S814C6)");
    check_field_offset(lv, s814c6f0, 0, "S814C6.s814c6f0");
    check_field_offset(lv, s814c6f1, 4, "S814C6.s814c6f1");
  }
}
static Arrange_To_Call_Me vS814C6(Test_S814C6, "S814C6", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S814C9  {
  void *s814c9f0;
  int s814c9f1;
  void *s814c9f2[2];
  void  mf814c9(); // _ZN6S814C97mf814c9Ev
};
//SIG(-1 S814C9) C1{ m Fp Fi Fp[2]}


void  S814C9 ::mf814c9(){}

static void Test_S814C9()
{
  {
    init_simple_test("S814C9");
    S814C9 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S814C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S814C9)");
    check_field_offset(lv, s814c9f0, 0, "S814C9.s814c9f0");
    check_field_offset(lv, s814c9f1, ABISELECT(8,4), "S814C9.s814c9f1");
    check_field_offset(lv, s814c9f2, ABISELECT(16,8), "S814C9.s814c9f2");
  }
}
static Arrange_To_Call_Me vS814C9(Test_S814C9, "S814C9", ABISELECT(32,16));

#else // __cplusplus

Class_Descriptor cd_S814C9 = {  "S814C9", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(32,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S814C10  : S1457C9_nt {
  char s814c10f0[2];
  short s814c10f1;
  int s814c10f2;
};
//SIG(-1 S814C10) C1{ BC2{ m Fi} Fc[2] Fs Fi}



static void Test_S814C10()
{
  extern Class_Descriptor cd_S814C10;
  void *lvp;
  {
    int buf[4];
    init_test(&cd_S814C10, buf);
    S814C10 &lv = *(new (buf) S814C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(S814C10)");
    check2(__alignof__(lv), 4, "__alignof__(S814C10)");
    check_base_class_offset(lv, (S1457C9_nt*), 0, "S814C10");
    check_field_offset(lv, s814c10f0, 4, "S814C10.s814c10f0");
    check_field_offset(lv, s814c10f1, 6, "S814C10.s814c10f1");
    check_field_offset(lv, s814c10f2, 8, "S814C10.s814c10f2");
    test_class_info(&lv, &cd_S814C10);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS814C10(Test_S814C10, "S814C10", 12);

#else // __cplusplus

extern Class_Descriptor cd_S1457C9_nt;
static Base_Class bases_S814C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1457C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S814C10 = {  "S814C10", // class name
  bases_S814C10, 1,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S814C8  : S814C9 {
  int s814c8f0;
  ::S814C10 s814c8f1;
  int s814c8f2;
};
//SIG(-1 S814C8) C1{ BC2{ m Fp Fi Fp[2]} Fi FC3{ BC4{ m Fi} Fc[2] Fs Fi} Fi}



static void Test_S814C8()
{
  extern Class_Descriptor cd_S814C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,10)];
    init_test(&cd_S814C8, buf);
    S814C8 &lv = *(new (buf) S814C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,36), "sizeof(S814C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S814C8)");
    check_base_class_offset(lv, (S814C9*), 0, "S814C8");
    check_field_offset(lv, s814c8f0, ABISELECT(32,16), "S814C8.s814c8f0");
    check_field_offset(lv, s814c8f1, ABISELECT(36,20), "S814C8.s814c8f1");
    check_field_offset(lv, s814c8f2, ABISELECT(48,32), "S814C8.s814c8f2");
    test_class_info(&lv, &cd_S814C8);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS814C8(Test_S814C8, "S814C8", ABISELECT(56,36));

#else // __cplusplus

extern Class_Descriptor cd_S814C9;
static Base_Class bases_S814C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S814C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S814C8 = {  "S814C8", // class name
  bases_S814C8, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(56,36), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S814C7  : S814C8 {
  ::S1457C8_nt s814c7f0;
};
//SIG(-1 S814C7) C1{ BC2{ BC3{ m Fp Fi Fp[2]} Fi FC4{ BC5{ m Fi} Fc[2] Fs Fi} Fi} FC6{ m Fp Fi[2]}}



static void Test_S814C7()
{
  extern Class_Descriptor cd_S814C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,13)];
    init_test(&cd_S814C7, buf);
    S814C7 &lv = *(new (buf) S814C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,48), "sizeof(S814C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S814C7)");
    check_base_class_offset(lv, (S814C9*)(S814C8*), 0, "S814C7");
    check_base_class_offset(lv, (S814C8*), 0, "S814C7");
    check_field_offset(lv, s814c7f0, ABISELECT(56,36), "S814C7.s814c7f0");
    test_class_info(&lv, &cd_S814C7);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS814C7(Test_S814C7, "S814C7", ABISELECT(72,48));

#else // __cplusplus

extern Class_Descriptor cd_S814C9;
extern Class_Descriptor cd_S814C8;
static Base_Class bases_S814C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S814C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S814C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S814C7 = {  "S814C7", // class name
  bases_S814C7, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(72,48), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S814C13_nt  {
  void *s814c13f0;
  int s814c13f1[2];
  void  mf814c13(); // _ZN10S814C13_nt8mf814c13Ev
};
//SIG(-1 S814C13_nt) C1{ m Fp Fi[2]}


void  S814C13_nt ::mf814c13(){}

//skip512 S814C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S814C3  : S814C4 {
  void *s814c3f0[3];
  ::S814C6 s814c3f1;
  ::S814C7 s814c3f2;
  ::S814C13_nt s814c3f3;
  virtual  ~S814C3(); // _ZN6S814C3D1Ev
  virtual void  v5(); // _ZN6S814C32v5Ev
  virtual void  v6(); // _ZN6S814C32v6Ev
  virtual void  v7(); // _ZN6S814C32v7Ev
  S814C3(); // tgen
};
//SIG(-1 S814C3) C1{ BC2{ BC3{ vd m} vd v4 Fs[2]} vd v1 v2 v3 Fp[3] FC4{ m Fi Fs[2]} FC5{ BC6{ BC7{ m Fp Fi Fp[2]} Fi FC8{ BC9{ m Fi} Fc[2] Fs Fi} Fi} FC10{ m Fp Fi[2]}} FC11{ m Fp Fi[2]}}


 S814C3 ::~S814C3(){ note_dtor("S814C3", this);}
void  S814C3 ::v5(){vfunc_called(this, "_ZN6S814C32v5Ev");}
void  S814C3 ::v6(){vfunc_called(this, "_ZN6S814C32v6Ev");}
void  S814C3 ::v7(){vfunc_called(this, "_ZN6S814C32v7Ev");}
S814C3 ::S814C3(){ note_ctor("S814C3", this);} // tgen

static void Test_S814C3()
{
  extern Class_Descriptor cd_S814C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,23)];
    init_test(&cd_S814C3, buf);
    S814C3 *dp, &lv = *(dp=new (buf) S814C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,88), "sizeof(S814C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S814C3)");
    check_base_class_offset(lv, (S814C5_nt*)(S814C4*), 0, "S814C3");
    check_base_class_offset(lv, (S814C4*), 0, "S814C3");
    check_field_offset(lv, s814c3f0, ABISELECT(16,8), "S814C3.s814c3f0");
    check_field_offset(lv, s814c3f1, ABISELECT(40,20), "S814C3.s814c3f1");
    check_field_offset(lv, s814c3f2, ABISELECT(48,28), "S814C3.s814c3f2");
    check_field_offset(lv, s814c3f3, ABISELECT(120,76), "S814C3.s814c3f3");
    test_class_info(&lv, &cd_S814C3);
    dp->~S814C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS814C3(Test_S814C3, "S814C3", ABISELECT(136,88));

#else // __cplusplus

extern void _ZN6S814C3C1Ev();
extern void _ZN6S814C3D1Ev();
Name_Map name_map_S814C3[] = {
  NSPAIR(_ZN6S814C3C1Ev),
  NSPAIR(_ZN6S814C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S814C4;
extern VTBL_ENTRY _ZTI6S814C4[];
extern  VTBL_ENTRY _ZTV6S814C4[];
static Base_Class bases_S814C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S814C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S814C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S814C3[];
extern void _ZN6S814C3D1Ev();
extern void _ZN6S814C3D0Ev();
extern void _ZN6S814C42v4Ev();
extern void _ZN6S814C32v5Ev();
extern void _ZN6S814C32v6Ev();
extern void _ZN6S814C32v7Ev();
static  VTBL_ENTRY vtc_S814C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S814C3[0]),
  (VTBL_ENTRY)&_ZN6S814C3D1Ev,
  (VTBL_ENTRY)&_ZN6S814C3D0Ev,
  (VTBL_ENTRY)&_ZN6S814C42v4Ev,
  (VTBL_ENTRY)&_ZN6S814C32v5Ev,
  (VTBL_ENTRY)&_ZN6S814C32v6Ev,
  (VTBL_ENTRY)&_ZN6S814C32v7Ev,
};
extern VTBL_ENTRY _ZTI6S814C3[];
extern  VTBL_ENTRY _ZTV6S814C3[];
Class_Descriptor cd_S814C3 = {  "S814C3", // class name
  bases_S814C3, 2,
  &(vtc_S814C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,88), // object size
  NSPAIRA(_ZTI6S814C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S814C3),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S814C15_nt  {
  char s814c15f0;
  void  mf814c15(); // _ZN10S814C15_nt8mf814c15Ev
};
//SIG(-1 S814C15_nt) C1{ m Fc}


void  S814C15_nt ::mf814c15(){}

//skip512 S814C15_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S814C14  {
  ::S814C15_nt s814c14f0;
  int s814c14f1[2];
  void  mf814c14(); // _ZN7S814C148mf814c14Ev
};
//SIG(-1 S814C14) C1{ m FC2{ m Fc} Fi[2]}


void  S814C14 ::mf814c14(){}

static void Test_S814C14()
{
  {
    init_simple_test("S814C14");
    S814C14 lv;
    check2(sizeof(lv), 12, "sizeof(S814C14)");
    check2(__alignof__(lv), 4, "__alignof__(S814C14)");
    check_field_offset(lv, s814c14f0, 0, "S814C14.s814c14f0");
    check_field_offset(lv, s814c14f1, 4, "S814C14.s814c14f1");
  }
}
static Arrange_To_Call_Me vS814C14(Test_S814C14, "S814C14", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S814C17  {
  void *s814c17f0;
  int s814c17f1[2];
  void  mf814c17(); // _ZN7S814C178mf814c17Ev
};
//SIG(-1 S814C17) C1{ m Fp Fi[2]}


void  S814C17 ::mf814c17(){}

static void Test_S814C17()
{
  {
    init_simple_test("S814C17");
    S814C17 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S814C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S814C17)");
    check_field_offset(lv, s814c17f0, 0, "S814C17.s814c17f0");
    check_field_offset(lv, s814c17f1, ABISELECT(8,4), "S814C17.s814c17f1");
  }
}
static Arrange_To_Call_Me vS814C17(Test_S814C17, "S814C17", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S814C27_nt  {
  char s814c27f0;
  char s814c27f1[15];
  void  mf814c27(); // _ZN10S814C27_nt8mf814c27Ev
};
//SIG(-1 S814C27_nt) C1{ m Fc[16]}


void  S814C27_nt ::mf814c27(){}

//skip512 S814C27_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S814C26  {
  ::S814C27_nt s814c26f0;
  ::S814C27_nt s814c26f1;
  ::S814C27_nt s814c26f2;
  void  mf814c26(); // _ZN7S814C268mf814c26Ev
};
//SIG(-1 S814C26) C1{ m FC2{ m Fc[16]} FC2 FC2}


void  S814C26 ::mf814c26(){}

static void Test_S814C26()
{
  {
    init_simple_test("S814C26");
    S814C26 lv;
    check2(sizeof(lv), 48, "sizeof(S814C26)");
    check2(__alignof__(lv), 1, "__alignof__(S814C26)");
    check_field_offset(lv, s814c26f0, 0, "S814C26.s814c26f0");
    check_field_offset(lv, s814c26f1, 16, "S814C26.s814c26f1");
    check_field_offset(lv, s814c26f2, 32, "S814C26.s814c26f2");
  }
}
static Arrange_To_Call_Me vS814C26(Test_S814C26, "S814C26", 48);

#else // __cplusplus

Class_Descriptor cd_S814C26 = {  "S814C26", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  48, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S814C25  : S814C26 {
};
//SIG(-1 S814C25) C1{ BC2{ m FC3{ m Fc[16]} FC3 FC3}}



static void Test_S814C25()
{
  extern Class_Descriptor cd_S814C25;
  void *lvp;
  {
    char buf[48];
    init_test(&cd_S814C25, buf);
    S814C25 &lv = *(new (buf) S814C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), 48, "sizeof(S814C25)");
    check2(__alignof__(lv), 1, "__alignof__(S814C25)");
    check_base_class_offset(lv, (S814C26*), 0, "S814C25");
    test_class_info(&lv, &cd_S814C25);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS814C25(Test_S814C25, "S814C25", 48);

#else // __cplusplus

extern Class_Descriptor cd_S814C26;
static Base_Class bases_S814C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S814C26,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S814C25 = {  "S814C25", // class name
  bases_S814C25, 1,
  0, // no vftv
  0, //no vtt
  48, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S814C24  {
  ::S814C25 s814c24f0;
  ::S814C27_nt s814c24f1;
  void  mf814c24(); // _ZN7S814C248mf814c24Ev
};
//SIG(-1 S814C24) C1{ m FC2{ BC3{ m FC4{ m Fc[16]} FC4 FC4}} FC4}


void  S814C24 ::mf814c24(){}

static void Test_S814C24()
{
  {
    init_simple_test("S814C24");
    S814C24 lv;
    check2(sizeof(lv), 64, "sizeof(S814C24)");
    check2(__alignof__(lv), 1, "__alignof__(S814C24)");
    check_field_offset(lv, s814c24f0, 0, "S814C24.s814c24f0");
    check_field_offset(lv, s814c24f1, 48, "S814C24.s814c24f1");
  }
}
static Arrange_To_Call_Me vS814C24(Test_S814C24, "S814C24", 64);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S814C29  {
  ::S814C27_nt s814c29f0;
  void  mf814c29(); // _ZN7S814C298mf814c29Ev
};
//SIG(-1 S814C29) C1{ m FC2{ m Fc[16]}}


void  S814C29 ::mf814c29(){}

static void Test_S814C29()
{
  {
    init_simple_test("S814C29");
    S814C29 lv;
    check2(sizeof(lv), 16, "sizeof(S814C29)");
    check2(__alignof__(lv), 1, "__alignof__(S814C29)");
    check_field_offset(lv, s814c29f0, 0, "S814C29.s814c29f0");
  }
}
static Arrange_To_Call_Me vS814C29(Test_S814C29, "S814C29", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S814C28  {
  ::S814C27_nt s814c28f0;
  ::S814C27_nt s814c28f1;
  ::S814C29 s814c28f2;
  ::S814C29 s814c28f3;
  ::S814C27_nt s814c28f4;
  void  mf814c28(); // _ZN7S814C288mf814c28Ev
};
//SIG(-1 S814C28) C1{ m FC2{ m Fc[16]} FC2 FC3{ m FC2} FC3 FC2}


void  S814C28 ::mf814c28(){}

static void Test_S814C28()
{
  {
    init_simple_test("S814C28");
    S814C28 lv;
    check2(sizeof(lv), 80, "sizeof(S814C28)");
    check2(__alignof__(lv), 1, "__alignof__(S814C28)");
    check_field_offset(lv, s814c28f0, 0, "S814C28.s814c28f0");
    check_field_offset(lv, s814c28f1, 16, "S814C28.s814c28f1");
    check_field_offset(lv, s814c28f2, 32, "S814C28.s814c28f2");
    check_field_offset(lv, s814c28f3, 48, "S814C28.s814c28f3");
    check_field_offset(lv, s814c28f4, 64, "S814C28.s814c28f4");
  }
}
static Arrange_To_Call_Me vS814C28(Test_S814C28, "S814C28", 80);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S814C23  {
  ::S814C24 s814c23f0;
  ::S814C28 s814c23f1;
  ::S814C27_nt s814c23f2;
  int s814c23f3[5];
  short s814c23f4[2];
  int s814c23f5[2];
  void  mf814c23(); // _ZN7S814C238mf814c23Ev
};
//SIG(-1 S814C23) C1{ m FC2{ m FC3{ BC4{ m FC5{ m Fc[16]} FC5 FC5}} FC5} FC6{ m FC5 FC5 FC7{ m FC5} FC7 FC5} FC5 Fi[5] Fs[2] Fi[2]}


void  S814C23 ::mf814c23(){}

static void Test_S814C23()
{
  {
    init_simple_test("S814C23");
    S814C23 lv;
    check2(sizeof(lv), 192, "sizeof(S814C23)");
    check2(__alignof__(lv), 4, "__alignof__(S814C23)");
    check_field_offset(lv, s814c23f0, 0, "S814C23.s814c23f0");
    check_field_offset(lv, s814c23f1, 64, "S814C23.s814c23f1");
    check_field_offset(lv, s814c23f2, 144, "S814C23.s814c23f2");
    check_field_offset(lv, s814c23f3, 160, "S814C23.s814c23f3");
    check_field_offset(lv, s814c23f4, 180, "S814C23.s814c23f4");
    check_field_offset(lv, s814c23f5, 184, "S814C23.s814c23f5");
  }
}
static Arrange_To_Call_Me vS814C23(Test_S814C23, "S814C23", 192);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S814C21  : S814C4 {
  ::S814C15_nt s814c21f0;
  char s814c21f1[3];
  ::S814C23 s814c21f2;
  ::S814C27_nt s814c21f3;
  ::S814C27_nt s814c21f4;
  ::S814C27_nt s814c21f5;
  ::S814C27_nt s814c21f6[2];
  virtual void  v11(); // _ZN7S814C213v11Ev
  virtual void  v12(); // _ZN7S814C213v12Ev
  virtual void  v13(); // _ZN7S814C213v13Ev
  virtual void  v14(); // _ZN7S814C213v14Ev
  virtual void  v15(); // _ZN7S814C213v15Ev
  virtual void  v16(); // _ZN7S814C213v16Ev
  virtual void  v17(); // _ZN7S814C213v17Ev
  virtual void  v18(); // _ZN7S814C213v18Ev
  virtual void  v19(); // _ZN7S814C213v19Ev
  virtual void  v20(); // _ZN7S814C213v20Ev
  virtual void  v21(); // _ZN7S814C213v21Ev
  virtual void  v22(); // _ZN7S814C213v22Ev
  virtual void  v23(); // _ZN7S814C213v23Ev
  virtual void  v24(); // _ZN7S814C213v24Ev
  virtual void  v25(); // _ZN7S814C213v25Ev
  virtual void  v26(); // _ZN7S814C213v26Ev
  virtual void  v27(); // _ZN7S814C213v27Ev
  virtual void  v28(); // _ZN7S814C213v28Ev
  virtual void  v29(); // _ZN7S814C213v29Ev
  virtual void  v30(); // _ZN7S814C213v30Ev
  virtual void  v31(); // _ZN7S814C213v31Ev
  virtual void  v32(); // _ZN7S814C213v32Ev
  ~S814C21(); // tgen
  S814C21(); // tgen
};
//SIG(-1 S814C21) C1{ BC2{ BC3{ vd m} vd v23 Fs[2]} v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 FC4{ m Fc} Fc[3] FC5{ m FC6{ m FC7{ BC8{ m FC9{ m Fc[16]} FC9 FC9}} FC9} FC10{ m FC9 FC9 FC11{ m FC9} FC11 FC9} FC9 Fi[5] Fs[2] Fi[2]} FC9 FC9 FC9 FC9[2]}


void  S814C21 ::v11(){vfunc_called(this, "_ZN7S814C213v11Ev");}
void  S814C21 ::v12(){vfunc_called(this, "_ZN7S814C213v12Ev");}
void  S814C21 ::v13(){vfunc_called(this, "_ZN7S814C213v13Ev");}
void  S814C21 ::v14(){vfunc_called(this, "_ZN7S814C213v14Ev");}
void  S814C21 ::v15(){vfunc_called(this, "_ZN7S814C213v15Ev");}
void  S814C21 ::v16(){vfunc_called(this, "_ZN7S814C213v16Ev");}
void  S814C21 ::v17(){vfunc_called(this, "_ZN7S814C213v17Ev");}
void  S814C21 ::v18(){vfunc_called(this, "_ZN7S814C213v18Ev");}
void  S814C21 ::v19(){vfunc_called(this, "_ZN7S814C213v19Ev");}
void  S814C21 ::v20(){vfunc_called(this, "_ZN7S814C213v20Ev");}
void  S814C21 ::v21(){vfunc_called(this, "_ZN7S814C213v21Ev");}
void  S814C21 ::v22(){vfunc_called(this, "_ZN7S814C213v22Ev");}
void  S814C21 ::v23(){vfunc_called(this, "_ZN7S814C213v23Ev");}
void  S814C21 ::v24(){vfunc_called(this, "_ZN7S814C213v24Ev");}
void  S814C21 ::v25(){vfunc_called(this, "_ZN7S814C213v25Ev");}
void  S814C21 ::v26(){vfunc_called(this, "_ZN7S814C213v26Ev");}
void  S814C21 ::v27(){vfunc_called(this, "_ZN7S814C213v27Ev");}
void  S814C21 ::v28(){vfunc_called(this, "_ZN7S814C213v28Ev");}
void  S814C21 ::v29(){vfunc_called(this, "_ZN7S814C213v29Ev");}
void  S814C21 ::v30(){vfunc_called(this, "_ZN7S814C213v30Ev");}
void  S814C21 ::v31(){vfunc_called(this, "_ZN7S814C213v31Ev");}
void  S814C21 ::v32(){vfunc_called(this, "_ZN7S814C213v32Ev");}
S814C21 ::~S814C21(){ note_dtor("S814C21", this);} // tgen
S814C21 ::S814C21(){ note_ctor("S814C21", this);} // tgen

static void Test_S814C21()
{
  extern Class_Descriptor cd_S814C21;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(37,72)];
    init_test(&cd_S814C21, buf);
    S814C21 *dp, &lv = *(dp=new (buf) S814C21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(288,284), "sizeof(S814C21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S814C21)");
    check_base_class_offset(lv, (S814C5_nt*)(S814C4*), 0, "S814C21");
    check_base_class_offset(lv, (S814C4*), 0, "S814C21");
    check_field_offset(lv, s814c21f0, ABISELECT(12,8), "S814C21.s814c21f0");
    check_field_offset(lv, s814c21f1, ABISELECT(13,9), "S814C21.s814c21f1");
    check_field_offset(lv, s814c21f2, ABISELECT(16,12), "S814C21.s814c21f2");
    check_field_offset(lv, s814c21f3, ABISELECT(208,204), "S814C21.s814c21f3");
    check_field_offset(lv, s814c21f4, ABISELECT(224,220), "S814C21.s814c21f4");
    check_field_offset(lv, s814c21f5, ABISELECT(240,236), "S814C21.s814c21f5");
    check_field_offset(lv, s814c21f6, ABISELECT(256,252), "S814C21.s814c21f6");
    test_class_info(&lv, &cd_S814C21);
    dp->~S814C21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS814C21(Test_S814C21, "S814C21", ABISELECT(288,284));

#else // __cplusplus

extern void _ZN7S814C21C1Ev();
extern void _ZN7S814C21D1Ev();
Name_Map name_map_S814C21[] = {
  NSPAIR(_ZN7S814C21C1Ev),
  NSPAIR(_ZN7S814C21D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S814C4;
extern VTBL_ENTRY _ZTI6S814C4[];
extern  VTBL_ENTRY _ZTV6S814C4[];
static Base_Class bases_S814C21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S814C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S814C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S814C21[];
extern void _ZN7S814C21D1Ev();
extern void _ZN7S814C21D0Ev();
extern void _ZN6S814C42v4Ev();
extern void _ZN7S814C213v11Ev();
extern void _ZN7S814C213v12Ev();
extern void _ZN7S814C213v13Ev();
extern void _ZN7S814C213v14Ev();
extern void _ZN7S814C213v15Ev();
extern void _ZN7S814C213v16Ev();
extern void _ZN7S814C213v17Ev();
extern void _ZN7S814C213v18Ev();
extern void _ZN7S814C213v19Ev();
extern void _ZN7S814C213v20Ev();
extern void _ZN7S814C213v21Ev();
extern void _ZN7S814C213v22Ev();
extern void _ZN7S814C213v23Ev();
extern void _ZN7S814C213v24Ev();
extern void _ZN7S814C213v25Ev();
extern void _ZN7S814C213v26Ev();
extern void _ZN7S814C213v27Ev();
extern void _ZN7S814C213v28Ev();
extern void _ZN7S814C213v29Ev();
extern void _ZN7S814C213v30Ev();
extern void _ZN7S814C213v31Ev();
extern void _ZN7S814C213v32Ev();
static  VTBL_ENTRY vtc_S814C21[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S814C21[0]),
  (VTBL_ENTRY)&_ZN7S814C21D1Ev,
  (VTBL_ENTRY)&_ZN7S814C21D0Ev,
  (VTBL_ENTRY)&_ZN6S814C42v4Ev,
  (VTBL_ENTRY)&_ZN7S814C213v11Ev,
  (VTBL_ENTRY)&_ZN7S814C213v12Ev,
  (VTBL_ENTRY)&_ZN7S814C213v13Ev,
  (VTBL_ENTRY)&_ZN7S814C213v14Ev,
  (VTBL_ENTRY)&_ZN7S814C213v15Ev,
  (VTBL_ENTRY)&_ZN7S814C213v16Ev,
  (VTBL_ENTRY)&_ZN7S814C213v17Ev,
  (VTBL_ENTRY)&_ZN7S814C213v18Ev,
  (VTBL_ENTRY)&_ZN7S814C213v19Ev,
  (VTBL_ENTRY)&_ZN7S814C213v20Ev,
  (VTBL_ENTRY)&_ZN7S814C213v21Ev,
  (VTBL_ENTRY)&_ZN7S814C213v22Ev,
  (VTBL_ENTRY)&_ZN7S814C213v23Ev,
  (VTBL_ENTRY)&_ZN7S814C213v24Ev,
  (VTBL_ENTRY)&_ZN7S814C213v25Ev,
  (VTBL_ENTRY)&_ZN7S814C213v26Ev,
  (VTBL_ENTRY)&_ZN7S814C213v27Ev,
  (VTBL_ENTRY)&_ZN7S814C213v28Ev,
  (VTBL_ENTRY)&_ZN7S814C213v29Ev,
  (VTBL_ENTRY)&_ZN7S814C213v30Ev,
  (VTBL_ENTRY)&_ZN7S814C213v31Ev,
  (VTBL_ENTRY)&_ZN7S814C213v32Ev,
};
extern VTBL_ENTRY _ZTI7S814C21[];
extern  VTBL_ENTRY _ZTV7S814C21[];
Class_Descriptor cd_S814C21 = {  "S814C21", // class name
  bases_S814C21, 2,
  &(vtc_S814C21[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(288,284), // object size
  NSPAIRA(_ZTI7S814C21),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S814C21),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S814C20  : S814C21 {
  void *s814c20f0;
  int s814c20f1;
  virtual  ~S814C20(); // _ZN7S814C20D1Ev
  virtual void  v33(); // _ZN7S814C203v33Ev
  virtual void  v34(); // _ZN7S814C203v34Ev
  virtual void  v35(); // _ZN7S814C203v35Ev
  virtual void  v36(); // _ZN7S814C203v36Ev
  virtual void  v37(); // _ZN7S814C203v37Ev
  virtual void  v38(); // _ZN7S814C203v38Ev
  virtual void  v39(); // _ZN7S814C203v39Ev
  virtual void  v40(); // _ZN7S814C203v40Ev
  virtual void  v41(); // _ZN7S814C203v41Ev
  virtual void  v42(); // _ZN7S814C203v42Ev
  virtual void  v43(); // _ZN7S814C203v43Ev
  virtual void  v44(); // _ZN7S814C203v44Ev
  virtual void  v45(); // _ZN7S814C203v45Ev
  virtual void  v46(); // _ZN7S814C203v46Ev
  virtual void  v47(); // _ZN7S814C203v47Ev
  virtual void  v48(); // _ZN7S814C203v48Ev
  S814C20(); // tgen
};
//SIG(-1 S814C20) C1{ BC2{ BC3{ BC4{ vd m} vd v17 Fs[2]} v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 FC5{ m Fc} Fc[3] FC6{ m FC7{ m FC8{ BC9{ m FC10{ m Fc[16]} FC10 FC10}} FC10} FC11{ m FC10 FC10 FC12{ m FC10} FC12 FC10} FC10 Fi[5] Fs[2] Fi[2]} FC10 FC10 FC10 FC10[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 Fp Fi}


 S814C20 ::~S814C20(){ note_dtor("S814C20", this);}
void  S814C20 ::v33(){vfunc_called(this, "_ZN7S814C203v33Ev");}
void  S814C20 ::v34(){vfunc_called(this, "_ZN7S814C203v34Ev");}
void  S814C20 ::v35(){vfunc_called(this, "_ZN7S814C203v35Ev");}
void  S814C20 ::v36(){vfunc_called(this, "_ZN7S814C203v36Ev");}
void  S814C20 ::v37(){vfunc_called(this, "_ZN7S814C203v37Ev");}
void  S814C20 ::v38(){vfunc_called(this, "_ZN7S814C203v38Ev");}
void  S814C20 ::v39(){vfunc_called(this, "_ZN7S814C203v39Ev");}
void  S814C20 ::v40(){vfunc_called(this, "_ZN7S814C203v40Ev");}
void  S814C20 ::v41(){vfunc_called(this, "_ZN7S814C203v41Ev");}
void  S814C20 ::v42(){vfunc_called(this, "_ZN7S814C203v42Ev");}
void  S814C20 ::v43(){vfunc_called(this, "_ZN7S814C203v43Ev");}
void  S814C20 ::v44(){vfunc_called(this, "_ZN7S814C203v44Ev");}
void  S814C20 ::v45(){vfunc_called(this, "_ZN7S814C203v45Ev");}
void  S814C20 ::v46(){vfunc_called(this, "_ZN7S814C203v46Ev");}
void  S814C20 ::v47(){vfunc_called(this, "_ZN7S814C203v47Ev");}
void  S814C20 ::v48(){vfunc_called(this, "_ZN7S814C203v48Ev");}
S814C20 ::S814C20(){ note_ctor("S814C20", this);} // tgen

static void Test_S814C20()
{
  extern Class_Descriptor cd_S814C20;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(39,74)];
    init_test(&cd_S814C20, buf);
    S814C20 *dp, &lv = *(dp=new (buf) S814C20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,292), "sizeof(S814C20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S814C20)");
    check_base_class_offset(lv, (S814C5_nt*)(S814C4*)(S814C21*), 0, "S814C20");
    check_base_class_offset(lv, (S814C4*)(S814C21*), 0, "S814C20");
    check_base_class_offset(lv, (S814C21*), 0, "S814C20");
    check_field_offset(lv, s814c20f0, ABISELECT(288,284), "S814C20.s814c20f0");
    check_field_offset(lv, s814c20f1, ABISELECT(296,288), "S814C20.s814c20f1");
    test_class_info(&lv, &cd_S814C20);
    dp->~S814C20();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS814C20(Test_S814C20, "S814C20", ABISELECT(304,292));

#else // __cplusplus

extern void _ZN7S814C20C1Ev();
extern void _ZN7S814C20D1Ev();
Name_Map name_map_S814C20[] = {
  NSPAIR(_ZN7S814C20C1Ev),
  NSPAIR(_ZN7S814C20D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S814C4;
extern VTBL_ENTRY _ZTI6S814C4[];
extern  VTBL_ENTRY _ZTV6S814C4[];
extern Class_Descriptor cd_S814C21;
extern VTBL_ENTRY _ZTI7S814C21[];
extern  VTBL_ENTRY _ZTV7S814C21[];
static Base_Class bases_S814C20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S814C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S814C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S814C21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S814C20[];
extern void _ZN7S814C20D1Ev();
extern void _ZN7S814C20D0Ev();
extern void _ZN6S814C42v4Ev();
extern void _ZN7S814C213v11Ev();
extern void _ZN7S814C213v12Ev();
extern void _ZN7S814C213v13Ev();
extern void _ZN7S814C213v14Ev();
extern void _ZN7S814C213v15Ev();
extern void _ZN7S814C213v16Ev();
extern void _ZN7S814C213v17Ev();
extern void _ZN7S814C213v18Ev();
extern void _ZN7S814C213v19Ev();
extern void _ZN7S814C213v20Ev();
extern void _ZN7S814C213v21Ev();
extern void _ZN7S814C213v22Ev();
extern void _ZN7S814C213v23Ev();
extern void _ZN7S814C213v24Ev();
extern void _ZN7S814C213v25Ev();
extern void _ZN7S814C213v26Ev();
extern void _ZN7S814C213v27Ev();
extern void _ZN7S814C213v28Ev();
extern void _ZN7S814C213v29Ev();
extern void _ZN7S814C213v30Ev();
extern void _ZN7S814C213v31Ev();
extern void _ZN7S814C213v32Ev();
extern void _ZN7S814C203v33Ev();
extern void _ZN7S814C203v34Ev();
extern void _ZN7S814C203v35Ev();
extern void _ZN7S814C203v36Ev();
extern void _ZN7S814C203v37Ev();
extern void _ZN7S814C203v38Ev();
extern void _ZN7S814C203v39Ev();
extern void _ZN7S814C203v40Ev();
extern void _ZN7S814C203v41Ev();
extern void _ZN7S814C203v42Ev();
extern void _ZN7S814C203v43Ev();
extern void _ZN7S814C203v44Ev();
extern void _ZN7S814C203v45Ev();
extern void _ZN7S814C203v46Ev();
extern void _ZN7S814C203v47Ev();
extern void _ZN7S814C203v48Ev();
static  VTBL_ENTRY vtc_S814C20[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S814C20[0]),
  (VTBL_ENTRY)&_ZN7S814C20D1Ev,
  (VTBL_ENTRY)&_ZN7S814C20D0Ev,
  (VTBL_ENTRY)&_ZN6S814C42v4Ev,
  (VTBL_ENTRY)&_ZN7S814C213v11Ev,
  (VTBL_ENTRY)&_ZN7S814C213v12Ev,
  (VTBL_ENTRY)&_ZN7S814C213v13Ev,
  (VTBL_ENTRY)&_ZN7S814C213v14Ev,
  (VTBL_ENTRY)&_ZN7S814C213v15Ev,
  (VTBL_ENTRY)&_ZN7S814C213v16Ev,
  (VTBL_ENTRY)&_ZN7S814C213v17Ev,
  (VTBL_ENTRY)&_ZN7S814C213v18Ev,
  (VTBL_ENTRY)&_ZN7S814C213v19Ev,
  (VTBL_ENTRY)&_ZN7S814C213v20Ev,
  (VTBL_ENTRY)&_ZN7S814C213v21Ev,
  (VTBL_ENTRY)&_ZN7S814C213v22Ev,
  (VTBL_ENTRY)&_ZN7S814C213v23Ev,
  (VTBL_ENTRY)&_ZN7S814C213v24Ev,
  (VTBL_ENTRY)&_ZN7S814C213v25Ev,
  (VTBL_ENTRY)&_ZN7S814C213v26Ev,
  (VTBL_ENTRY)&_ZN7S814C213v27Ev,
  (VTBL_ENTRY)&_ZN7S814C213v28Ev,
  (VTBL_ENTRY)&_ZN7S814C213v29Ev,
  (VTBL_ENTRY)&_ZN7S814C213v30Ev,
  (VTBL_ENTRY)&_ZN7S814C213v31Ev,
  (VTBL_ENTRY)&_ZN7S814C213v32Ev,
  (VTBL_ENTRY)&_ZN7S814C203v33Ev,
  (VTBL_ENTRY)&_ZN7S814C203v34Ev,
  (VTBL_ENTRY)&_ZN7S814C203v35Ev,
  (VTBL_ENTRY)&_ZN7S814C203v36Ev,
  (VTBL_ENTRY)&_ZN7S814C203v37Ev,
  (VTBL_ENTRY)&_ZN7S814C203v38Ev,
  (VTBL_ENTRY)&_ZN7S814C203v39Ev,
  (VTBL_ENTRY)&_ZN7S814C203v40Ev,
  (VTBL_ENTRY)&_ZN7S814C203v41Ev,
  (VTBL_ENTRY)&_ZN7S814C203v42Ev,
  (VTBL_ENTRY)&_ZN7S814C203v43Ev,
  (VTBL_ENTRY)&_ZN7S814C203v44Ev,
  (VTBL_ENTRY)&_ZN7S814C203v45Ev,
  (VTBL_ENTRY)&_ZN7S814C203v46Ev,
  (VTBL_ENTRY)&_ZN7S814C203v47Ev,
  (VTBL_ENTRY)&_ZN7S814C203v48Ev,
};
extern VTBL_ENTRY _ZTI7S814C20[];
extern  VTBL_ENTRY _ZTV7S814C20[];
Class_Descriptor cd_S814C20 = {  "S814C20", // class name
  bases_S814C20, 3,
  &(vtc_S814C20[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,292), // object size
  NSPAIRA(_ZTI7S814C20),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S814C20),43, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S814C19  : S814C20 {
  ~S814C19(); // tgen
  S814C19(); // tgen
};
//SIG(-1 S814C19) C1{ BC2{ BC3{ BC4{ BC5{ vd m} vd v1 Fs[2]} v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 FC6{ m Fc} Fc[3] FC7{ m FC8{ m FC9{ BC10{ m FC11{ m Fc[16]} FC11 FC11}} FC11} FC12{ m FC11 FC11 FC13{ m FC11} FC13 FC11} FC11 Fi[5] Fs[2] Fi[2]} FC11 FC11 FC11 FC11[2]} vd v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 Fp Fi}}


S814C19 ::~S814C19(){ note_dtor("S814C19", this);} // tgen
S814C19 ::S814C19(){ note_ctor("S814C19", this);} // tgen

static void Test_S814C19()
{
  extern Class_Descriptor cd_S814C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(39,74)];
    init_test(&cd_S814C19, buf);
    S814C19 *dp, &lv = *(dp=new (buf) S814C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,292), "sizeof(S814C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S814C19)");
    check_base_class_offset(lv, (S814C5_nt*)(S814C4*)(S814C21*)(S814C20*), 0, "S814C19");
    check_base_class_offset(lv, (S814C4*)(S814C21*)(S814C20*), 0, "S814C19");
    check_base_class_offset(lv, (S814C21*)(S814C20*), 0, "S814C19");
    check_base_class_offset(lv, (S814C20*), 0, "S814C19");
    test_class_info(&lv, &cd_S814C19);
    dp->~S814C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS814C19(Test_S814C19, "S814C19", ABISELECT(304,292));

#else // __cplusplus

extern void _ZN7S814C19C1Ev();
extern void _ZN7S814C19D1Ev();
Name_Map name_map_S814C19[] = {
  NSPAIR(_ZN7S814C19C1Ev),
  NSPAIR(_ZN7S814C19D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S814C4;
extern VTBL_ENTRY _ZTI6S814C4[];
extern  VTBL_ENTRY _ZTV6S814C4[];
extern Class_Descriptor cd_S814C21;
extern VTBL_ENTRY _ZTI7S814C21[];
extern  VTBL_ENTRY _ZTV7S814C21[];
extern Class_Descriptor cd_S814C20;
extern VTBL_ENTRY _ZTI7S814C20[];
extern  VTBL_ENTRY _ZTV7S814C20[];
static Base_Class bases_S814C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S814C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S814C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S814C21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S814C20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S814C19[];
extern void _ZN7S814C19D1Ev();
extern void _ZN7S814C19D0Ev();
extern void _ZN6S814C42v4Ev();
extern void _ZN7S814C213v11Ev();
extern void _ZN7S814C213v12Ev();
extern void _ZN7S814C213v13Ev();
extern void _ZN7S814C213v14Ev();
extern void _ZN7S814C213v15Ev();
extern void _ZN7S814C213v16Ev();
extern void _ZN7S814C213v17Ev();
extern void _ZN7S814C213v18Ev();
extern void _ZN7S814C213v19Ev();
extern void _ZN7S814C213v20Ev();
extern void _ZN7S814C213v21Ev();
extern void _ZN7S814C213v22Ev();
extern void _ZN7S814C213v23Ev();
extern void _ZN7S814C213v24Ev();
extern void _ZN7S814C213v25Ev();
extern void _ZN7S814C213v26Ev();
extern void _ZN7S814C213v27Ev();
extern void _ZN7S814C213v28Ev();
extern void _ZN7S814C213v29Ev();
extern void _ZN7S814C213v30Ev();
extern void _ZN7S814C213v31Ev();
extern void _ZN7S814C213v32Ev();
extern void _ZN7S814C203v33Ev();
extern void _ZN7S814C203v34Ev();
extern void _ZN7S814C203v35Ev();
extern void _ZN7S814C203v36Ev();
extern void _ZN7S814C203v37Ev();
extern void _ZN7S814C203v38Ev();
extern void _ZN7S814C203v39Ev();
extern void _ZN7S814C203v40Ev();
extern void _ZN7S814C203v41Ev();
extern void _ZN7S814C203v42Ev();
extern void _ZN7S814C203v43Ev();
extern void _ZN7S814C203v44Ev();
extern void _ZN7S814C203v45Ev();
extern void _ZN7S814C203v46Ev();
extern void _ZN7S814C203v47Ev();
extern void _ZN7S814C203v48Ev();
static  VTBL_ENTRY vtc_S814C19[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S814C19[0]),
  (VTBL_ENTRY)&_ZN7S814C19D1Ev,
  (VTBL_ENTRY)&_ZN7S814C19D0Ev,
  (VTBL_ENTRY)&_ZN6S814C42v4Ev,
  (VTBL_ENTRY)&_ZN7S814C213v11Ev,
  (VTBL_ENTRY)&_ZN7S814C213v12Ev,
  (VTBL_ENTRY)&_ZN7S814C213v13Ev,
  (VTBL_ENTRY)&_ZN7S814C213v14Ev,
  (VTBL_ENTRY)&_ZN7S814C213v15Ev,
  (VTBL_ENTRY)&_ZN7S814C213v16Ev,
  (VTBL_ENTRY)&_ZN7S814C213v17Ev,
  (VTBL_ENTRY)&_ZN7S814C213v18Ev,
  (VTBL_ENTRY)&_ZN7S814C213v19Ev,
  (VTBL_ENTRY)&_ZN7S814C213v20Ev,
  (VTBL_ENTRY)&_ZN7S814C213v21Ev,
  (VTBL_ENTRY)&_ZN7S814C213v22Ev,
  (VTBL_ENTRY)&_ZN7S814C213v23Ev,
  (VTBL_ENTRY)&_ZN7S814C213v24Ev,
  (VTBL_ENTRY)&_ZN7S814C213v25Ev,
  (VTBL_ENTRY)&_ZN7S814C213v26Ev,
  (VTBL_ENTRY)&_ZN7S814C213v27Ev,
  (VTBL_ENTRY)&_ZN7S814C213v28Ev,
  (VTBL_ENTRY)&_ZN7S814C213v29Ev,
  (VTBL_ENTRY)&_ZN7S814C213v30Ev,
  (VTBL_ENTRY)&_ZN7S814C213v31Ev,
  (VTBL_ENTRY)&_ZN7S814C213v32Ev,
  (VTBL_ENTRY)&_ZN7S814C203v33Ev,
  (VTBL_ENTRY)&_ZN7S814C203v34Ev,
  (VTBL_ENTRY)&_ZN7S814C203v35Ev,
  (VTBL_ENTRY)&_ZN7S814C203v36Ev,
  (VTBL_ENTRY)&_ZN7S814C203v37Ev,
  (VTBL_ENTRY)&_ZN7S814C203v38Ev,
  (VTBL_ENTRY)&_ZN7S814C203v39Ev,
  (VTBL_ENTRY)&_ZN7S814C203v40Ev,
  (VTBL_ENTRY)&_ZN7S814C203v41Ev,
  (VTBL_ENTRY)&_ZN7S814C203v42Ev,
  (VTBL_ENTRY)&_ZN7S814C203v43Ev,
  (VTBL_ENTRY)&_ZN7S814C203v44Ev,
  (VTBL_ENTRY)&_ZN7S814C203v45Ev,
  (VTBL_ENTRY)&_ZN7S814C203v46Ev,
  (VTBL_ENTRY)&_ZN7S814C203v47Ev,
  (VTBL_ENTRY)&_ZN7S814C203v48Ev,
};
extern VTBL_ENTRY _ZTI7S814C19[];
extern  VTBL_ENTRY _ZTV7S814C19[];
Class_Descriptor cd_S814C19 = {  "S814C19", // class name
  bases_S814C19, 4,
  &(vtc_S814C19[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,292), // object size
  NSPAIRA(_ZTI7S814C19),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S814C19),43, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S814C30  {
  void *s814c30f0;
  int s814c30f1[2];
  void  mf814c30(); // _ZN7S814C308mf814c30Ev
};
//SIG(-1 S814C30) C1{ m Fp Fi[2]}


void  S814C30 ::mf814c30(){}

static void Test_S814C30()
{
  {
    init_simple_test("S814C30");
    S814C30 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S814C30)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S814C30)");
    check_field_offset(lv, s814c30f0, 0, "S814C30.s814c30f0");
    check_field_offset(lv, s814c30f1, ABISELECT(8,4), "S814C30.s814c30f1");
  }
}
static Arrange_To_Call_Me vS814C30(Test_S814C30, "S814C30", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S814C32  {
  void *s814c32f0;
  int s814c32f1[2];
  void  mf814c32(); // _ZN7S814C328mf814c32Ev
};
//SIG(-1 S814C32) C1{ m Fp Fi[2]}


void  S814C32 ::mf814c32(){}

static void Test_S814C32()
{
  {
    init_simple_test("S814C32");
    S814C32 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S814C32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S814C32)");
    check_field_offset(lv, s814c32f0, 0, "S814C32.s814c32f0");
    check_field_offset(lv, s814c32f1, ABISELECT(8,4), "S814C32.s814c32f1");
  }
}
static Arrange_To_Call_Me vS814C32(Test_S814C32, "S814C32", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S814C2  : S814C3 {
  void *s814c2f0;
  ::S814C14 s814c2f1;
  void *s814c2f2;
  ::S814C13_nt s814c2f3;
  ::S814C17 s814c2f4;
  ::S814C17 s814c2f5;
  short s814c2f6[2];
  char s814c2f7;
  int s814c2f8[2];
  ::S814C19 s814c2f9;
  ::S814C30 s814c2f10;
  ::S814C30 s814c2f11;
  ::S814C32 s814c2f12;
  ::S814C32 s814c2f13;
  virtual  ~S814C2(); // _ZN6S814C2D1Ev
  virtual void  v8(); // _ZN6S814C22v8Ev
  virtual void  v9(); // _ZN6S814C22v9Ev
  virtual void  v10(); // _ZN6S814C23v10Ev
  S814C2(); // tgen
};
//SIG(-1 S814C2) C1{ BC2{ BC3{ BC4{ vd m} vd v4 Fs[2]} vd v5 v6 v7 Fp[3] FC5{ m Fi Fs[2]} FC6{ BC7{ BC8{ m Fp Fi Fp[2]} Fi FC9{ BC10{ m Fi} Fc[2] Fs Fi} Fi} FC11{ m Fp Fi[2]}} FC12{ m Fp Fi[2]}} vd v1 v2 v3 Fp FC13{ m FC14{ m Fc} Fi[2]} Fp FC12 FC15{ m Fp Fi[2]} FC15 Fs[2] Fc Fi[2] FC16{ BC17{ BC18{ BC3 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 FC14 Fc[3] FC19{ m FC20{ m FC21{ BC22{ m FC23{ m Fc[16]} FC23 FC23}} FC23} FC24{ m FC23 FC23 FC25{ m FC23} FC25 FC23} FC23 Fi[5] Fs[2] Fi[2]} FC23 FC23 FC23 FC23[2]} vd v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 Fp Fi}} FC26{ m Fp Fi[2]} FC26 FC27{ m Fp Fi[2]} FC27}


 S814C2 ::~S814C2(){ note_dtor("S814C2", this);}
void  S814C2 ::v8(){vfunc_called(this, "_ZN6S814C22v8Ev");}
void  S814C2 ::v9(){vfunc_called(this, "_ZN6S814C22v9Ev");}
void  S814C2 ::v10(){vfunc_called(this, "_ZN6S814C23v10Ev");}
S814C2 ::S814C2(){ note_ctor("S814C2", this);} // tgen

static void Test_S814C2()
{
  extern Class_Descriptor cd_S814C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(76,126)];
    init_test(&cd_S814C2, buf);
    S814C2 *dp, &lv = *(dp=new (buf) S814C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(600,500), "sizeof(S814C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S814C2)");
    check_base_class_offset(lv, (S814C5_nt*)(S814C4*)(S814C3*), 0, "S814C2");
    check_base_class_offset(lv, (S814C4*)(S814C3*), 0, "S814C2");
    check_base_class_offset(lv, (S814C3*), 0, "S814C2");
    check_field_offset(lv, s814c2f0, ABISELECT(136,88), "S814C2.s814c2f0");
    check_field_offset(lv, s814c2f1, ABISELECT(144,92), "S814C2.s814c2f1");
    check_field_offset(lv, s814c2f2, ABISELECT(160,104), "S814C2.s814c2f2");
    check_field_offset(lv, s814c2f3, ABISELECT(168,108), "S814C2.s814c2f3");
    check_field_offset(lv, s814c2f4, ABISELECT(184,120), "S814C2.s814c2f4");
    check_field_offset(lv, s814c2f5, ABISELECT(200,132), "S814C2.s814c2f5");
    check_field_offset(lv, s814c2f6, ABISELECT(216,144), "S814C2.s814c2f6");
    check_field_offset(lv, s814c2f7, ABISELECT(220,148), "S814C2.s814c2f7");
    check_field_offset(lv, s814c2f8, ABISELECT(224,152), "S814C2.s814c2f8");
    check_field_offset(lv, s814c2f9, ABISELECT(232,160), "S814C2.s814c2f9");
    check_field_offset(lv, s814c2f10, ABISELECT(536,452), "S814C2.s814c2f10");
    check_field_offset(lv, s814c2f11, ABISELECT(552,464), "S814C2.s814c2f11");
    check_field_offset(lv, s814c2f12, ABISELECT(568,476), "S814C2.s814c2f12");
    check_field_offset(lv, s814c2f13, ABISELECT(584,488), "S814C2.s814c2f13");
    test_class_info(&lv, &cd_S814C2);
    dp->~S814C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS814C2(Test_S814C2, "S814C2", ABISELECT(600,500));

#else // __cplusplus

extern void _ZN6S814C2C1Ev();
extern void _ZN6S814C2D1Ev();
Name_Map name_map_S814C2[] = {
  NSPAIR(_ZN6S814C2C1Ev),
  NSPAIR(_ZN6S814C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S814C4;
extern VTBL_ENTRY _ZTI6S814C4[];
extern  VTBL_ENTRY _ZTV6S814C4[];
extern Class_Descriptor cd_S814C3;
extern VTBL_ENTRY _ZTI6S814C3[];
extern  VTBL_ENTRY _ZTV6S814C3[];
static Base_Class bases_S814C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S814C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S814C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S814C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S814C2[];
extern void _ZN6S814C2D1Ev();
extern void _ZN6S814C2D0Ev();
extern void _ZN6S814C42v4Ev();
extern void _ZN6S814C32v5Ev();
extern void _ZN6S814C32v6Ev();
extern void _ZN6S814C32v7Ev();
extern void _ZN6S814C22v8Ev();
extern void _ZN6S814C22v9Ev();
extern void _ZN6S814C23v10Ev();
static  VTBL_ENTRY vtc_S814C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S814C2[0]),
  (VTBL_ENTRY)&_ZN6S814C2D1Ev,
  (VTBL_ENTRY)&_ZN6S814C2D0Ev,
  (VTBL_ENTRY)&_ZN6S814C42v4Ev,
  (VTBL_ENTRY)&_ZN6S814C32v5Ev,
  (VTBL_ENTRY)&_ZN6S814C32v6Ev,
  (VTBL_ENTRY)&_ZN6S814C32v7Ev,
  (VTBL_ENTRY)&_ZN6S814C22v8Ev,
  (VTBL_ENTRY)&_ZN6S814C22v9Ev,
  (VTBL_ENTRY)&_ZN6S814C23v10Ev,
};
extern VTBL_ENTRY _ZTI6S814C2[];
extern  VTBL_ENTRY _ZTV6S814C2[];
Class_Descriptor cd_S814C2 = {  "S814C2", // class name
  bases_S814C2, 3,
  &(vtc_S814C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(600,500), // object size
  NSPAIRA(_ZTI6S814C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S814C2),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S814C1  : S814C2 {
  virtual  ~S814C1(); // _ZN6S814C1D1Ev
  virtual void  v1(); // _ZN6S814C12v1Ev
  virtual void  v2(); // _ZN6S814C12v2Ev
  virtual void  v3(); // _ZN6S814C12v3Ev
  S814C1(); // tgen
};
//SIG(1 S814C1) C1{ BC2{ BC3{ BC4{ BC5{ vd m} vd v4 Fs[2]} vd v5 v6 v7 Fp[3] FC6{ m Fi Fs[2]} FC7{ BC8{ BC9{ m Fp Fi Fp[2]} Fi FC10{ BC11{ m Fi} Fc[2] Fs Fi} Fi} FC12{ m Fp Fi[2]}} FC13{ m Fp Fi[2]}} vd v8 v9 v10 Fp FC14{ m FC15{ m Fc} Fi[2]} Fp FC13 FC16{ m Fp Fi[2]} FC16 Fs[2] Fc Fi[2] FC17{ BC18{ BC19{ BC4 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 FC15 Fc[3] FC20{ m FC21{ m FC22{ BC23{ m FC24{ m Fc[16]} FC24 FC24}} FC24} FC25{ m FC24 FC24 FC26{ m FC24} FC26 FC24} FC24 Fi[5] Fs[2] Fi[2]} FC24 FC24 FC24 FC24[2]} vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 Fp Fi}} FC27{ m Fp Fi[2]} FC27 FC28{ m Fp Fi[2]} FC28} vd v1 v2 v3}


 S814C1 ::~S814C1(){ note_dtor("S814C1", this);}
void  S814C1 ::v1(){vfunc_called(this, "_ZN6S814C12v1Ev");}
void  S814C1 ::v2(){vfunc_called(this, "_ZN6S814C12v2Ev");}
void  S814C1 ::v3(){vfunc_called(this, "_ZN6S814C12v3Ev");}
S814C1 ::S814C1(){ note_ctor("S814C1", this);} // tgen

static void Test_S814C1()
{
  extern Class_Descriptor cd_S814C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(76,126)];
    init_test(&cd_S814C1, buf);
    S814C1 *dp, &lv = *(dp=new (buf) S814C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(600,500), "sizeof(S814C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S814C1)");
    check_base_class_offset(lv, (S814C5_nt*)(S814C4*)(S814C3*)(S814C2*), 0, "S814C1");
    check_base_class_offset(lv, (S814C4*)(S814C3*)(S814C2*), 0, "S814C1");
    check_base_class_offset(lv, (S814C3*)(S814C2*), 0, "S814C1");
    check_base_class_offset(lv, (S814C2*), 0, "S814C1");
    test_class_info(&lv, &cd_S814C1);
    dp->~S814C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS814C1(Test_S814C1, "S814C1", ABISELECT(600,500));

#else // __cplusplus

extern void _ZN6S814C1C1Ev();
extern void _ZN6S814C1D1Ev();
Name_Map name_map_S814C1[] = {
  NSPAIR(_ZN6S814C1C1Ev),
  NSPAIR(_ZN6S814C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S814C4;
extern VTBL_ENTRY _ZTI6S814C4[];
extern  VTBL_ENTRY _ZTV6S814C4[];
extern Class_Descriptor cd_S814C3;
extern VTBL_ENTRY _ZTI6S814C3[];
extern  VTBL_ENTRY _ZTV6S814C3[];
extern Class_Descriptor cd_S814C2;
extern VTBL_ENTRY _ZTI6S814C2[];
extern  VTBL_ENTRY _ZTV6S814C2[];
static Base_Class bases_S814C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S814C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S814C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S814C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S814C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S814C1[];
extern void _ZN6S814C1D1Ev();
extern void _ZN6S814C1D0Ev();
extern void _ZN6S814C42v4Ev();
extern void _ZN6S814C32v5Ev();
extern void _ZN6S814C32v6Ev();
extern void _ZN6S814C32v7Ev();
extern void _ZN6S814C22v8Ev();
extern void _ZN6S814C22v9Ev();
extern void _ZN6S814C23v10Ev();
extern void _ZN6S814C12v1Ev();
extern void _ZN6S814C12v2Ev();
extern void _ZN6S814C12v3Ev();
static  VTBL_ENTRY vtc_S814C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S814C1[0]),
  (VTBL_ENTRY)&_ZN6S814C1D1Ev,
  (VTBL_ENTRY)&_ZN6S814C1D0Ev,
  (VTBL_ENTRY)&_ZN6S814C42v4Ev,
  (VTBL_ENTRY)&_ZN6S814C32v5Ev,
  (VTBL_ENTRY)&_ZN6S814C32v6Ev,
  (VTBL_ENTRY)&_ZN6S814C32v7Ev,
  (VTBL_ENTRY)&_ZN6S814C22v8Ev,
  (VTBL_ENTRY)&_ZN6S814C22v9Ev,
  (VTBL_ENTRY)&_ZN6S814C23v10Ev,
  (VTBL_ENTRY)&_ZN6S814C12v1Ev,
  (VTBL_ENTRY)&_ZN6S814C12v2Ev,
  (VTBL_ENTRY)&_ZN6S814C12v3Ev,
};
extern VTBL_ENTRY _ZTI6S814C1[];
extern  VTBL_ENTRY _ZTV6S814C1[];
Class_Descriptor cd_S814C1 = {  "S814C1", // class name
  bases_S814C1, 4,
  &(vtc_S814C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(600,500), // object size
  NSPAIRA(_ZTI6S814C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S814C1),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8279C5  : virtual S694C11_nt {
  virtual void  v1(); // _ZN7S8279C52v1Ev
  ~S8279C5(); // tgen
  S8279C5(); // tgen
};
//SIG(-1 S8279C5) C1{ VBC2{ m} v1}


void  S8279C5 ::v1(){vfunc_called(this, "_ZN7S8279C52v1Ev");}
S8279C5 ::~S8279C5(){ note_dtor("S8279C5", this);} // tgen
S8279C5 ::S8279C5(){ note_ctor("S8279C5", this);} // tgen

static void Test_S8279C5()
{
  extern Class_Descriptor cd_S8279C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S8279C5, buf);
    S8279C5 *dp, &lv = *(dp=new (buf) S8279C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S8279C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8279C5)");
    check_base_class_offset(lv, (S694C11_nt*), 0, "S8279C5");
    test_class_info(&lv, &cd_S8279C5);
    dp->~S8279C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8279C5(Test_S8279C5, "S8279C5", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S8279C5C1Ev();
extern void _ZN7S8279C5D1Ev();
Name_Map name_map_S8279C5[] = {
  NSPAIR(_ZN7S8279C5C1Ev),
  NSPAIR(_ZN7S8279C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S694C11_nt;
extern VTBL_ENTRY _ZTI10S694C11_nt[];
static Base_Class bases_S8279C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S694C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S8279C5[];
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY vtc_S8279C5[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern VTBL_ENTRY _ZTV7S8279C5[];
static  VTT_ENTRY vtt_S8279C5[] = {
  {&(_ZTV7S8279C5[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
Class_Descriptor cd_S8279C5 = {  "S8279C5", // class name
  bases_S8279C5, 1,
  &(vtc_S8279C5[0]), // expected_vtbl_contents
  &(vtt_S8279C5[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S8279C5),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7S8279C5),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S8279C5),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8279C6  : S814C5_nt , S8279C5 {
  ::S15666C6_nt s8279c6f0;
  virtual  ~S8279C6(); // _ZN7S8279C6D2Ev
  S8279C6(); // tgen
};
//SIG(-1 S8279C6) C1{ BC2{ vd m} BC3{ VBC4{ m} v1} vd FC5{}}


 S8279C6 ::~S8279C6(){ note_dtor("S8279C6", this);}
S8279C6 ::S8279C6(){ note_ctor("S8279C6", this);} // tgen

static void Test_S8279C6()
{
  extern Class_Descriptor cd_S8279C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S8279C6, buf);
    S8279C6 *dp, &lv = *(dp=new (buf) S8279C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S8279C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8279C6)");
    check_base_class_offset(lv, (S814C5_nt*), 0, "S8279C6");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C5*), 0, "S8279C6");
    check_base_class_offset(lv, (S8279C5*), ABISELECT(8,4), "S8279C6");
    check_field_offset(lv, s8279c6f0, ABISELECT(16,8), "S8279C6.s8279c6f0");
    test_class_info(&lv, &cd_S8279C6);
    dp->~S8279C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8279C6(Test_S8279C6, "S8279C6", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN7S8279C6C1Ev();
extern void _ZN7S8279C6D2Ev();
Name_Map name_map_S8279C6[] = {
  NSPAIR(_ZN7S8279C6C1Ev),
  NSPAIR(_ZN7S8279C6D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S694C11_nt;
extern VTBL_ENTRY _ZTI10S694C11_nt[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
static Base_Class bases_S8279C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S814C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S694C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S8279C5,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S8279C6[];
extern void _ZN7S8279C6D1Ev();
extern void _ZN7S8279C6D0Ev();
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY vtc_S8279C6[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C6[0]),
  (VTBL_ENTRY)&_ZN7S8279C6D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C6D0Ev,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S8279C6[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern VTBL_ENTRY _ZTV7S8279C6[];
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C6[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
static  VTT_ENTRY vtt_S8279C6[] = {
  {&(_ZTV7S8279C6[3]),  3,9},
  {&(_tg__ZTV7S8279C5__7S8279C6[3]),  3,4},
  {&(_ZTV7S8279C6[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7S8279C6[];
extern  VTBL_ENTRY _ZTV7S8279C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C6[];
Class_Descriptor cd_S8279C6 = {  "S8279C6", // class name
  bases_S8279C6, 3,
  &(vtc_S8279C6[0]), // expected_vtbl_contents
  &(vtt_S8279C6[0]), // expected_vtt_contents
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI7S8279C6),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S8279C6),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S8279C6),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8279C8  : virtual S694C11_nt , virtual S8279C5 , S814C5_nt {
  int s8279c8f0:4;
  virtual  ~S8279C8(); // _ZN7S8279C8D2Ev
  S8279C8(); // tgen
};
//SIG(-1 S8279C8) C1{ VBC2{ m} VBC3{ VBC2 v1} BC4{ vd m} vd Fi:4}


 S8279C8 ::~S8279C8(){ note_dtor("S8279C8", this);}
S8279C8 ::S8279C8(){ note_ctor("S8279C8", this);} // tgen

static void Test_S8279C8()
{
  extern Class_Descriptor cd_S8279C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S8279C8, buf);
    S8279C8 *dp, &lv = *(dp=new (buf) S8279C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S8279C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8279C8)");
    check_base_class_offset(lv, (S694C11_nt*), 0, "S8279C8");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C5*), 0, "S8279C8");
    check_base_class_offset(lv, (S8279C5*), ABISELECT(16,8), "S8279C8");
    check_base_class_offset(lv, (S814C5_nt*), 0, "S8279C8");
    set_bf_and_test(lv, s8279c8f0, ABISELECT(8,4), 0, 4, 1, "S8279C8");
    set_bf_and_test(lv, s8279c8f0, ABISELECT(8,4), 0, 4, hide_sll(1LL<<3), "S8279C8");
    test_class_info(&lv, &cd_S8279C8);
    dp->~S8279C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8279C8(Test_S8279C8, "S8279C8", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN7S8279C8C1Ev();
extern void _ZN7S8279C8D2Ev();
Name_Map name_map_S8279C8[] = {
  NSPAIR(_ZN7S8279C8C1Ev),
  NSPAIR(_ZN7S8279C8D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S694C11_nt;
extern VTBL_ENTRY _ZTI10S694C11_nt[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
static Base_Class bases_S8279C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S694C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S8279C5,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S814C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S8279C8[];
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY vtc_S8279C8[] = {
  ABISELECT(16,8),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern VTBL_ENTRY _ZTV7S8279C8[];
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C8[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
static  VTT_ENTRY vtt_S8279C8[] = {
  {&(_ZTV7S8279C8[4]),  4,11},
  {&(_ZTV7S8279C8[10]),  10,11},
  {&(_tg__ZTV7S8279C5__7S8279C8[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
Class_Descriptor cd_S8279C8 = {  "S8279C8", // class name
  bases_S8279C8, 3,
  &(vtc_S8279C8[0]), // expected_vtbl_contents
  &(vtt_S8279C8[0]), // expected_vtt_contents
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI7S8279C8),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S8279C8),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S8279C8),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8279C3  : virtual S694C11_nt , virtual S8279C5 , virtual S8279C6 , virtual S814C5_nt , S8279C8 {
  ~S8279C3(); // tgen
  S8279C3(); // tgen
};
//SIG(-1 S8279C3) C1{ VBC2{ m} VBC3{ VBC2 v1} VBC4{ BC5{ vd m} BC3 vd FC6{}} VBC5 BC7{ VBC2 VBC3 BC5 vd Fi:4}}


S8279C3 ::~S8279C3(){ note_dtor("S8279C3", this);} // tgen
S8279C3 ::S8279C3(){ note_ctor("S8279C3", this);} // tgen

static void Test_S8279C3()
{
  extern Class_Descriptor cd_S8279C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[8];
    init_test(&cd_S8279C3, buf);
    S8279C3 *dp, &lv = *(dp=new (buf) S8279C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,28), "sizeof(S8279C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8279C3)");
    check_base_class_offset(lv, (S694C11_nt*), 0, "S8279C3");
    /*is_ambiguous_... S8279C3::S8279C5 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C5*), 0, "S8279C3");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C5*)(S8279C6*), 0, "S8279C3");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C8*), 0, "S8279C3");
    /*is_ambiguous_... S8279C3::S8279C5 */ AMB_check_base_class_offset(lv, (S8279C5*), ABISELECT(16,8), "S8279C3");
    check_base_class_offset(lv, (S8279C5*)(S8279C8*), ABISELECT(16,8), "S8279C3");
    check_base_class_offset(lv, (S814C5_nt*)(S8279C6*), ABISELECT(24,12), "S8279C3");
    check_base_class_offset(lv, (S8279C5*)(S8279C6*), ABISELECT(32,16), "S8279C3");
    check_base_class_offset(lv, (S8279C6*), ABISELECT(24,12), "S8279C3");
    /*is_ambiguous_... S8279C3::S814C5_nt */ AMB_check_base_class_offset(lv, (S814C5_nt*), ABISELECT(48,24), "S8279C3");
    check_base_class_offset(lv, (S814C5_nt*)(S8279C8*), 0, "S8279C3");
    check_base_class_offset(lv, (S8279C8*), 0, "S8279C3");
    test_class_info(&lv, &cd_S8279C3);
    dp->~S8279C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8279C3(Test_S8279C3, "S8279C3", ABISELECT(56,28));

#else // __cplusplus

extern void _ZN7S8279C3C1Ev();
extern void _ZN7S8279C3D1Ev();
Name_Map name_map_S8279C3[] = {
  NSPAIR(_ZN7S8279C3C1Ev),
  NSPAIR(_ZN7S8279C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S694C11_nt;
extern VTBL_ENTRY _ZTI10S694C11_nt[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S8279C6;
extern VTBL_ENTRY _ZTI7S8279C6[];
extern  VTBL_ENTRY _ZTV7S8279C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C6[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C8;
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
static Base_Class bases_S8279C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S694C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S8279C5,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S814C5_nt,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S8279C5,    ABISELECT(32,16), //bcp->offset
    20, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S8279C6,    ABISELECT(24,12), //bcp->offset
    13, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S814C5_nt,    ABISELECT(48,24), //bcp->offset
    24, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S814C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S8279C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S8279C3[];
extern void _ZN7S8279C3D1Ev();
extern void _ZN7S8279C3D0Ev();
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTv0_n32_N7S8279C3D1Ev,_ZTv0_n16_N7S8279C3D1Ev)();
extern void ABISELECT(_ZThn24_N7S8279C3D1Ev,_ZThn12_N7S8279C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S8279C3D0Ev,_ZTv0_n16_N7S8279C3D0Ev)();
extern void ABISELECT(_ZThn24_N7S8279C3D0Ev,_ZThn12_N7S8279C3D0Ev)() __attribute__((weak));
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTv0_n24_N7S8279C3D1Ev,_ZTv0_n12_N7S8279C3D1Ev)();
extern void ABISELECT(_ZThn48_N7S8279C3D1Ev,_ZThn24_N7S8279C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S8279C3D0Ev,_ZTv0_n12_N7S8279C3D0Ev)();
extern void ABISELECT(_ZThn48_N7S8279C3D0Ev,_ZThn24_N7S8279C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S8279C3[] = {
  ABISELECT(48,24),
  ABISELECT(24,12),
  ABISELECT(16,8),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&_ZN7S8279C3D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C3D0Ev,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  ABISELECT(8,4),
  ABISELECT(-24,-12),
  ABISELECT(-24,-12),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S8279C3D1Ev,_ZTv0_n16_N7S8279C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S8279C3D0Ev,_ZTv0_n16_N7S8279C3D0Ev),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S8279C3D1Ev,_ZTv0_n12_N7S8279C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S8279C3D0Ev,_ZTv0_n12_N7S8279C3D0Ev),
};
extern VTBL_ENTRY _ZTV7S8279C3[];
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C8__7S8279C3[] = {
  ABISELECT(16,8),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C8__7S8279C3[] = {
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C3[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C6D1Ev();
extern void _ZN7S8279C6D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C6__7S8279C3[] = {
  ABISELECT(-24,-12),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C6[0]),
  (VTBL_ENTRY)&_ZN7S8279C6D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C6D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__7S8279C3[] = {
  ABISELECT(-32,-16),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C6__7S8279C3[] = {
  ABISELECT(-32,-16),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S8279C6[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
static  VTT_ENTRY vtt_S8279C3[] = {
  {&(_ZTV7S8279C3[6]),  6,29},
  {&(_tg__ZTV7S8279C8__7S8279C3[4]),  4,6},
  {&(_tg__ZTV7S8279C5__7S8279C8__7S8279C3[4]),  4,5},
  {&(_ZTV7S8279C3[12]),  12,29},
  {&(_ZTV7S8279C3[18]),  18,29},
  {&(_ZTV7S8279C3[23]),  23,29},
  {&(_ZTV7S8279C3[27]),  27,29},
  {&(_tg__ZTV7S8279C5__7S8279C3[3]),  3,4},
  {&(_tg__ZTV7S8279C6__7S8279C3[3]),  3,5},
  {&(_tg__ZTV7S8279C57S8279C6__A1__7S8279C3[3]),  3,4},
  {&(_tg__ZTV7S8279C5__7S8279C6__7S8279C3[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7S8279C3[];
extern  VTBL_ENTRY _ZTV7S8279C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C3[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S8279C3D0Ev,_ZTv0_n12_N7S8279C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7S8279C3D0Ev,_ZThn24_N7S8279C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S8279C3D1Ev,_ZTv0_n12_N7S8279C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7S8279C3D1Ev,_ZThn24_N7S8279C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S8279C3D0Ev,_ZTv0_n16_N7S8279C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7S8279C3D0Ev,_ZThn12_N7S8279C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S8279C3D1Ev,_ZTv0_n16_N7S8279C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7S8279C3D1Ev,_ZThn12_N7S8279C3D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S8279C3 = {  "S8279C3", // class name
  bases_S8279C3, 8,
  &(vtc_S8279C3[0]), // expected_vtbl_contents
  &(vtt_S8279C3[0]), // expected_vtt_contents
  ABISELECT(56,28), // object size
  NSPAIRA(_ZTI7S8279C3),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV7S8279C3),29, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S8279C3),11, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8279C15  : S814C5_nt , virtual S694C11_nt , virtual S8279C5 , virtual S8279C6 , S8279C8 {
  virtual  ~S8279C15(); // _ZN8S8279C15D2Ev
  S8279C15(); // tgen
};
//SIG(-1 S8279C15) C1{ BC2{ vd m} VBC3{ m} VBC4{ VBC3 v1} VBC5{ BC2 BC4 vd FC6{}} BC7{ VBC3 VBC4 BC2 vd Fi:4} vd}


 S8279C15 ::~S8279C15(){ note_dtor("S8279C15", this);}
S8279C15 ::S8279C15(){ note_ctor("S8279C15", this);} // tgen

static void Test_S8279C15()
{
  extern Class_Descriptor cd_S8279C15;
  void *lvp;
  {
    ABISELECT(double,int) buf[8];
    init_test(&cd_S8279C15, buf);
    S8279C15 *dp, &lv = *(dp=new (buf) S8279C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,28), "sizeof(S8279C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8279C15)");
    /*is_ambiguous_... S8279C15::S814C5_nt */ AMB_check_base_class_offset(lv, (S814C5_nt*), 0, "S8279C15");
    check_base_class_offset(lv, (S694C11_nt*), 0, "S8279C15");
    /*is_ambiguous_... S8279C15::S8279C5 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C5*), 0, "S8279C15");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C5*)(S8279C6*), 0, "S8279C15");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C8*), 0, "S8279C15");
    /*is_ambiguous_... S8279C15::S8279C5 */ AMB_check_base_class_offset(lv, (S8279C5*), ABISELECT(24,12), "S8279C15");
    check_base_class_offset(lv, (S8279C5*)(S8279C8*), ABISELECT(24,12), "S8279C15");
    check_base_class_offset(lv, (S814C5_nt*)(S8279C6*), ABISELECT(32,16), "S8279C15");
    check_base_class_offset(lv, (S8279C5*)(S8279C6*), ABISELECT(40,20), "S8279C15");
    check_base_class_offset(lv, (S8279C6*), ABISELECT(32,16), "S8279C15");
    check_base_class_offset(lv, (S814C5_nt*)(S8279C8*), ABISELECT(8,4), "S8279C15");
    check_base_class_offset(lv, (S8279C8*), ABISELECT(8,4), "S8279C15");
    test_class_info(&lv, &cd_S8279C15);
    dp->~S8279C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8279C15(Test_S8279C15, "S8279C15", ABISELECT(56,28));

#else // __cplusplus

extern void _ZN8S8279C15C1Ev();
extern void _ZN8S8279C15D2Ev();
Name_Map name_map_S8279C15[] = {
  NSPAIR(_ZN8S8279C15C1Ev),
  NSPAIR(_ZN8S8279C15D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S694C11_nt;
extern VTBL_ENTRY _ZTI10S694C11_nt[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S8279C6;
extern VTBL_ENTRY _ZTI7S8279C6[];
extern  VTBL_ENTRY _ZTV7S8279C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C6[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C8;
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
static Base_Class bases_S8279C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S814C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S694C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S8279C5,    ABISELECT(24,12), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S814C5_nt,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S8279C5,    ABISELECT(40,20), //bcp->offset
    25, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S8279C6,    ABISELECT(32,16), //bcp->offset
    18, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S814C5_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S8279C8,    ABISELECT(8,4), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S8279C15[];
extern void _ZN8S8279C15D1Ev();
extern void _ZN8S8279C15D0Ev();
extern void ABISELECT(_ZThn8_N8S8279C15D1Ev,_ZThn4_N8S8279C15D1Ev)();
extern void ABISELECT(_ZThn8_N8S8279C15D0Ev,_ZThn4_N8S8279C15D0Ev)();
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev)();
extern void ABISELECT(_ZThn32_N8S8279C15D1Ev,_ZThn16_N8S8279C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev)();
extern void ABISELECT(_ZThn32_N8S8279C15D0Ev,_ZThn16_N8S8279C15D0Ev)() __attribute__((weak));
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY vtc_S8279C15[] = {
  ABISELECT(32,16),
  ABISELECT(24,12),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN8S8279C15D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C15D0Ev,
  ABISELECT(16,8),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C15D1Ev,_ZThn4_N8S8279C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C15D0Ev,_ZThn4_N8S8279C15D0Ev),
  0,
  ABISELECT(-24,-12),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  ABISELECT(8,4),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev),
  ABISELECT(-40,-20),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern VTBL_ENTRY _ZTV8S8279C15[];
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C8__8S8279C15[] = {
  ABISELECT(16,8),
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C8__8S8279C15[] = {
  0,
  ABISELECT(-24,-12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C15[] = {
  ABISELECT(-24,-12),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C6D1Ev();
extern void _ZN7S8279C6D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C15[] = {
  ABISELECT(-32,-16),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C6[0]),
  (VTBL_ENTRY)&_ZN7S8279C6D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C6D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C15[] = {
  ABISELECT(-40,-20),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C6__8S8279C15[] = {
  ABISELECT(-40,-20),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S8279C6[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
static  VTT_ENTRY vtt_S8279C15[] = {
  {&(_ZTV8S8279C15[5]),  5,29},
  {&(_tg__ZTV7S8279C8__8S8279C15[4]),  4,6},
  {&(_tg__ZTV7S8279C5__7S8279C8__8S8279C15[4]),  4,5},
  {&(_ZTV8S8279C15[17]),  17,29},
  {&(_ZTV8S8279C15[23]),  23,29},
  {&(_ZTV8S8279C15[28]),  28,29},
  {&(_ZTV8S8279C15[11]),  11,29},
  {&(_tg__ZTV7S8279C5__8S8279C15[3]),  3,4},
  {&(_tg__ZTV7S8279C6__8S8279C15[3]),  3,5},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C15[3]),  3,4},
  {&(_tg__ZTV7S8279C5__7S8279C6__8S8279C15[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8S8279C15[];
extern  VTBL_ENTRY _ZTV8S8279C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C15[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S8279C15D0Ev,_ZThn16_N8S8279C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S8279C15D1Ev,_ZThn16_N8S8279C15D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S8279C15 = {  "S8279C15", // class name
  bases_S8279C15, 8,
  &(vtc_S8279C15[0]), // expected_vtbl_contents
  &(vtt_S8279C15[0]), // expected_vtt_contents
  ABISELECT(56,28), // object size
  NSPAIRA(_ZTI8S8279C15),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S8279C15),29, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S8279C15),11, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8279C14  : virtual S8279C8 , S8279C5 , S8279C3 , S814C5_nt , S8279C15 {
  int s8279c14f0[2];
  virtual  ~S8279C14(); // _ZN8S8279C14D2Ev
  S8279C14(); // tgen
};
//SIG(-1 S8279C14) C1{ VBC2{ VBC3{ m} VBC4{ VBC3 v1} BC5{ vd m} vd Fi:4} BC4 BC6{ VBC3 VBC4 VBC7{ BC5 BC4 vd FC8{}} VBC5 BC2} BC5 BC9{ BC5 VBC3 VBC4 VBC7 BC2 vd} vd Fi[2]}


 S8279C14 ::~S8279C14(){ note_dtor("S8279C14", this);}
S8279C14 ::S8279C14(){ note_ctor("S8279C14", this);} // tgen

static void Test_S8279C14()
{
  extern Class_Descriptor cd_S8279C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(16,17)];
    init_test(&cd_S8279C14, buf);
    S8279C14 *dp, &lv = *(dp=new (buf) S8279C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(120,64), "sizeof(S8279C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8279C14)");
    /*is_ambiguous_... S8279C14::S8279C8 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C8*), 0, "S8279C14");
    /*is_ambiguous_... S8279C14::S8279C5 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C5*), 0, "S8279C14");
    /*is_ambiguous_... S8279C14::S8279C5 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C5*), 0, "S8279C14");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C3*), 0, "S8279C14");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C5*)(S8279C6*), 0, "S8279C14");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C8*)(S8279C3*), 0, "S8279C14");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C15*), 0, "S8279C14");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C8*)(S8279C15*), 0, "S8279C14");
    /*is_ambiguous_... S8279C14::S8279C8 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C8*), ABISELECT(80,44), "S8279C14");
    /*is_ambiguous_... S8279C3::S8279C5 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C3*), ABISELECT(80,44), "S8279C14");
    check_base_class_offset(lv, (S8279C5*)(S8279C8*)(S8279C3*), ABISELECT(80,44), "S8279C14");
    /*is_ambiguous_... S8279C15::S8279C5 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C15*), ABISELECT(80,44), "S8279C14");
    check_base_class_offset(lv, (S8279C5*)(S8279C8*)(S8279C15*), ABISELECT(80,44), "S8279C14");
    /*is_ambiguous_... S8279C14::S8279C8 */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C8*), ABISELECT(64,36), "S8279C14");
    /*is_ambiguous_... S8279C14::S8279C8 */ AMB_check_base_class_offset(lv, (S8279C8*), ABISELECT(64,36), "S8279C14");
    /*is_ambiguous_... S8279C14::S8279C5 */ AMB_check_base_class_offset(lv, (S8279C5*), 0, "S8279C14");
    check_base_class_offset(lv, (S814C5_nt*)(S8279C6*), ABISELECT(88,48), "S8279C14");
    check_base_class_offset(lv, (S8279C5*)(S8279C6*), ABISELECT(96,52), "S8279C14");
    check_base_class_offset(lv, (S8279C6*)(S8279C3*), ABISELECT(88,48), "S8279C14");
    check_base_class_offset(lv, (S8279C6*)(S8279C15*), ABISELECT(88,48), "S8279C14");
    /*is_ambiguous_... S8279C3::S814C5_nt */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C3*), ABISELECT(112,60), "S8279C14");
    check_base_class_offset(lv, (S814C5_nt*)(S8279C8*)(S8279C3*), ABISELECT(8,4), "S8279C14");
    check_base_class_offset(lv, (S8279C8*)(S8279C3*), ABISELECT(8,4), "S8279C14");
    check_base_class_offset(lv, (S8279C3*), ABISELECT(8,4), "S8279C14");
    /*is_ambiguous_... S8279C14::S814C5_nt */ AMB_check_base_class_offset(lv, (S814C5_nt*), ABISELECT(24,12), "S8279C14");
    /*is_ambiguous_... S8279C15::S814C5_nt */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C15*), ABISELECT(32,16), "S8279C14");
    check_base_class_offset(lv, (S814C5_nt*)(S8279C8*)(S8279C15*), ABISELECT(40,20), "S8279C14");
    check_base_class_offset(lv, (S8279C8*)(S8279C15*), ABISELECT(40,20), "S8279C14");
    check_base_class_offset(lv, (S8279C15*), ABISELECT(32,16), "S8279C14");
    check_field_offset(lv, s8279c14f0, ABISELECT(52,28), "S8279C14.s8279c14f0");
    test_class_info(&lv, &cd_S8279C14);
    dp->~S8279C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8279C14(Test_S8279C14, "S8279C14", ABISELECT(120,64));

#else // __cplusplus

extern void _ZN8S8279C14C1Ev();
extern void _ZN8S8279C14D2Ev();
Name_Map name_map_S8279C14[] = {
  NSPAIR(_ZN8S8279C14C1Ev),
  NSPAIR(_ZN8S8279C14D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S694C11_nt;
extern VTBL_ENTRY _ZTI10S694C11_nt[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C8;
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S8279C6;
extern VTBL_ENTRY _ZTI7S8279C6[];
extern  VTBL_ENTRY _ZTV7S8279C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C6[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C8;
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
extern Class_Descriptor cd_S8279C3;
extern VTBL_ENTRY _ZTI7S8279C3[];
extern  VTBL_ENTRY _ZTV7S8279C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C3[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C8;
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
extern Class_Descriptor cd_S8279C15;
extern VTBL_ENTRY _ZTI8S8279C15[];
extern  VTBL_ENTRY _ZTV8S8279C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C15[];
static Base_Class bases_S8279C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S694C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S8279C5,    ABISELECT(80,44), //bcp->offset
    42, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    27, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S814C5_nt,    ABISELECT(64,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S8279C8,    ABISELECT(64,36), //bcp->offset
    35, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S8279C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S814C5_nt,    ABISELECT(88,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S8279C5,    ABISELECT(96,52), //bcp->offset
    54, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    29, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S8279C6,    ABISELECT(88,48), //bcp->offset
    47, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S814C5_nt,    ABISELECT(112,60), //bcp->offset
    58, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S814C5_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S8279C8,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S8279C3,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S814C5_nt,    ABISELECT(24,12), //bcp->offset
    18, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S814C5_nt,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S814C5_nt,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S8279C8,    ABISELECT(40,20), //bcp->offset
    29, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S8279C15,    ABISELECT(32,16), //bcp->offset
    22, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S8279C14[];
extern void _ZN7S8279C52v1Ev();
extern void _ZN8S8279C14D1Ev();
extern void _ZN8S8279C14D0Ev();
extern void ABISELECT(_ZThn8_N8S8279C14D1Ev,_ZThn4_N8S8279C14D1Ev)();
extern void ABISELECT(_ZThn8_N8S8279C14D0Ev,_ZThn4_N8S8279C14D0Ev)();
extern void ABISELECT(_ZThn24_N8S8279C14D1Ev,_ZThn12_N8S8279C14D1Ev)();
extern void ABISELECT(_ZThn24_N8S8279C14D0Ev,_ZThn12_N8S8279C14D0Ev)();
extern void ABISELECT(_ZThn32_N8S8279C14D1Ev,_ZThn16_N8S8279C14D1Ev)();
extern void ABISELECT(_ZThn32_N8S8279C14D0Ev,_ZThn16_N8S8279C14D0Ev)();
extern void ABISELECT(_ZThn40_N8S8279C14D1Ev,_ZThn20_N8S8279C14D1Ev)();
extern void ABISELECT(_ZThn40_N8S8279C14D0Ev,_ZThn20_N8S8279C14D0Ev)();
extern void ABISELECT(_ZTv0_n40_N8S8279C14D1Ev,_ZTv0_n20_N8S8279C14D1Ev)();
extern void ABISELECT(_ZThn64_N8S8279C14D1Ev,_ZThn36_N8S8279C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S8279C14D0Ev,_ZTv0_n20_N8S8279C14D0Ev)();
extern void ABISELECT(_ZThn64_N8S8279C14D0Ev,_ZThn36_N8S8279C14D0Ev)() __attribute__((weak));
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTv0_n32_N8S8279C14D1Ev,_ZTv0_n16_N8S8279C14D1Ev)();
extern void ABISELECT(_ZThn88_N8S8279C14D1Ev,_ZThn48_N8S8279C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S8279C14D0Ev,_ZTv0_n16_N8S8279C14D0Ev)();
extern void ABISELECT(_ZThn88_N8S8279C14D0Ev,_ZThn48_N8S8279C14D0Ev)() __attribute__((weak));
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTv0_n24_N8S8279C14D1Ev,_ZTv0_n12_N8S8279C14D1Ev)();
extern void ABISELECT(_ZThn112_N8S8279C14D1Ev,_ZThn60_N8S8279C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S8279C14D0Ev,_ZTv0_n12_N8S8279C14D0Ev)();
extern void ABISELECT(_ZThn112_N8S8279C14D0Ev,_ZThn60_N8S8279C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S8279C14[] = {
  ABISELECT(112,60),
  ABISELECT(88,48),
  ABISELECT(80,44),
  ABISELECT(64,36),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&_ZN8S8279C14D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C14D0Ev,
  ABISELECT(104,56),
  ABISELECT(80,44),
  ABISELECT(72,40),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C14D1Ev,_ZThn4_N8S8279C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C14D0Ev,_ZThn4_N8S8279C14D0Ev),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N8S8279C14D1Ev,_ZThn12_N8S8279C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N8S8279C14D0Ev,_ZThn12_N8S8279C14D0Ev),
  ABISELECT(56,32),
  ABISELECT(48,28),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S8279C14D1Ev,_ZThn16_N8S8279C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S8279C14D0Ev,_ZThn16_N8S8279C14D0Ev),
  ABISELECT(40,24),
  ABISELECT(-40,-20),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N8S8279C14D1Ev,_ZThn20_N8S8279C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N8S8279C14D0Ev,_ZThn20_N8S8279C14D0Ev),
  ABISELECT(-64,-36),
  ABISELECT(16,8),
  ABISELECT(-64,-36),
  ABISELECT(-64,-36),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C14D1Ev,_ZTv0_n20_N8S8279C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C14D0Ev,_ZTv0_n20_N8S8279C14D0Ev),
  0,
  ABISELECT(-80,-44),
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  ABISELECT(8,4),
  ABISELECT(-88,-48),
  ABISELECT(-88,-48),
  ABISELECT(-88,-48),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C14D1Ev,_ZTv0_n16_N8S8279C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C14D0Ev,_ZTv0_n16_N8S8279C14D0Ev),
  ABISELECT(-96,-52),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  ABISELECT(-112,-60),
  ABISELECT(-112,-60),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C14D1Ev,_ZTv0_n12_N8S8279C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C14D0Ev,_ZTv0_n12_N8S8279C14D0Ev),
};
extern VTBL_ENTRY _ZTV8S8279C14[];
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__A__8S8279C14[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C3D1Ev();
extern void _ZN7S8279C3D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C3__8S8279C14[] = {
  ABISELECT(104,56),
  ABISELECT(80,44),
  ABISELECT(72,40),
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&_ZN7S8279C3D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C3D0Ev,
};
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C87S8279C3__A1__8S8279C14[] = {
  ABISELECT(72,40),
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C87S8279C3__A1__8S8279C14[] = {
  0,
  ABISELECT(-80,-44),
  ABISELECT(-72,-40),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C3__8S8279C14[] = {
  0,
  ABISELECT(-80,-44),
  ABISELECT(-72,-40),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N7S8279C3D1Ev,_ZTv0_n16_N7S8279C3D1Ev)();
extern void ABISELECT(_ZThn80_N7S8279C3D1Ev,_ZThn44_N7S8279C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S8279C3D0Ev,_ZTv0_n16_N7S8279C3D0Ev)();
extern void ABISELECT(_ZThn80_N7S8279C3D0Ev,_ZThn44_N7S8279C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S8279C6__7S8279C3__8S8279C14[] = {
  ABISELECT(8,4),
  ABISELECT(-80,-44),
  ABISELECT(-88,-48),
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S8279C3D1Ev,_ZTv0_n16_N7S8279C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S8279C3D0Ev,_ZTv0_n16_N7S8279C3D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__7S8279C3__8S8279C14[] = {
  ABISELECT(-96,-52),
  ABISELECT(-88,-48),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S8279C3D1Ev,_ZTv0_n12_N7S8279C3D1Ev)();
extern void ABISELECT(_ZThn104_N7S8279C3D1Ev,_ZThn56_N7S8279C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S8279C3D0Ev,_ZTv0_n12_N7S8279C3D0Ev)();
extern void ABISELECT(_ZThn104_N7S8279C3D0Ev,_ZThn56_N7S8279C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S814C5_nt__A1__7S8279C3__8S8279C14[] = {
  ABISELECT(-104,-56),
  ABISELECT(-104,-56),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S8279C3D1Ev,_ZTv0_n12_N7S8279C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S8279C3D0Ev,_ZTv0_n12_N7S8279C3D0Ev),
};
extern void _ZN8S8279C15D1Ev();
extern void _ZN8S8279C15D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C15__8S8279C14[] = {
  ABISELECT(56,32),
  ABISELECT(48,28),
  ABISELECT(-32,-16),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN8S8279C15D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C15D0Ev,
};
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C15__A2__8S8279C14[] = {
  ABISELECT(40,24),
  ABISELECT(-40,-20),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C88S8279C15__A2__8S8279C14[] = {
  0,
  ABISELECT(-80,-44),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C15__8S8279C14[] = {
  0,
  ABISELECT(-80,-44),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev)();
extern void ABISELECT(_ZThn56_N8S8279C15D1Ev,_ZThn32_N8S8279C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev)();
extern void ABISELECT(_ZThn56_N8S8279C15D0Ev,_ZThn32_N8S8279C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C15__8S8279C14[] = {
  ABISELECT(8,4),
  ABISELECT(-56,-32),
  ABISELECT(-88,-48),
  ABISELECT(-56,-32),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C15__8S8279C14[] = {
  ABISELECT(-96,-52),
  ABISELECT(-64,-36),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZThn8_N8S8279C15D1Ev,_ZThn4_N8S8279C15D1Ev)();
extern void ABISELECT(_ZThn8_N8S8279C15D0Ev,_ZThn4_N8S8279C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C8__8S8279C15__8S8279C14[] = {
  ABISELECT(40,24),
  ABISELECT(-40,-20),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C15D1Ev,_ZThn4_N8S8279C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C15D0Ev,_ZThn4_N8S8279C15D0Ev),
};
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C8__8S8279C14[] = {
  ABISELECT(16,8),
  ABISELECT(-64,-36),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C8__8S8279C14[] = {
  0,
  ABISELECT(-80,-44),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C14[] = {
  ABISELECT(-80,-44),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C6D1Ev();
extern void _ZN7S8279C6D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C14[] = {
  ABISELECT(-88,-48),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C6[0]),
  (VTBL_ENTRY)&_ZN7S8279C6D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C6D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A2__8S8279C14[] = {
  ABISELECT(-96,-52),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C6__8S8279C14[] = {
  ABISELECT(-96,-52),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S8279C6[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
static  VTT_ENTRY vtt_S8279C14[] = {
  {&(_ZTV8S8279C14[7]),  7,63},
  {&(_tg__ZTV7S8279C5__A__8S8279C14[3]),  3,4},
  {&(_tg__ZTV7S8279C3__8S8279C14[6]),  6,8},
  {&(_tg__ZTV7S8279C87S8279C3__A1__8S8279C14[4]),  4,6},
  {&(_tg__ZTV7S8279C5__7S8279C87S8279C3__A1__8S8279C14[4]),  4,5},
  {&(_tg__ZTV7S8279C5__7S8279C3__8S8279C14[4]),  4,5},
  {&(_tg__ZTV7S8279C6__7S8279C3__8S8279C14[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__7S8279C3__8S8279C14[3]),  3,4},
  {&(_tg__ZTV9S814C5_nt__A1__7S8279C3__8S8279C14[3]),  3,5},
  {&(_tg__ZTV8S8279C15__8S8279C14[5]),  5,7},
  {&(_tg__ZTV7S8279C88S8279C15__A2__8S8279C14[4]),  4,6},
  {&(_tg__ZTV7S8279C5__7S8279C88S8279C15__A2__8S8279C14[4]),  4,5},
  {&(_tg__ZTV7S8279C5__8S8279C15__8S8279C14[4]),  4,5},
  {&(_tg__ZTV7S8279C6__8S8279C15__8S8279C14[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C15__8S8279C14[3]),  3,4},
  {&(_tg__ZTV7S8279C8__8S8279C15__8S8279C14[4]),  4,6},
  {&(_ZTV8S8279C14[40]),  40,63},
  {&(_ZTV8S8279C14[46]),  46,63},
  {&(_ZTV8S8279C14[16]),  16,63},
  {&(_ZTV8S8279C14[52]),  52,63},
  {&(_ZTV8S8279C14[57]),  57,63},
  {&(_ZTV8S8279C14[61]),  61,63},
  {&(_ZTV8S8279C14[27]),  27,63},
  {&(_ZTV8S8279C14[33]),  33,63},
  {&(_tg__ZTV7S8279C8__8S8279C14[4]),  4,6},
  {&(_tg__ZTV7S8279C5__7S8279C8__8S8279C14[4]),  4,5},
  {&(_tg__ZTV7S8279C5__8S8279C14[3]),  3,4},
  {&(_tg__ZTV7S8279C6__8S8279C14[3]),  3,5},
  {&(_tg__ZTV7S8279C57S8279C6__A2__8S8279C14[3]),  3,4},
  {&(_tg__ZTV7S8279C5__7S8279C6__8S8279C14[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8S8279C14[];
extern  VTBL_ENTRY _ZTV8S8279C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C14[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S8279C15D0Ev,_ZThn32_N8S8279C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S8279C15D1Ev,_ZThn32_N8S8279C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S8279C3D0Ev,_ZTv0_n12_N7S8279C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N7S8279C3D0Ev,_ZThn56_N7S8279C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S8279C3D1Ev,_ZTv0_n12_N7S8279C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N7S8279C3D1Ev,_ZThn56_N7S8279C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S8279C3D0Ev,_ZTv0_n16_N7S8279C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N7S8279C3D0Ev,_ZThn44_N7S8279C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S8279C3D1Ev,_ZTv0_n16_N7S8279C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N7S8279C3D1Ev,_ZThn44_N7S8279C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S8279C14D0Ev,_ZTv0_n12_N8S8279C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N8S8279C14D0Ev,_ZThn60_N8S8279C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S8279C14D1Ev,_ZTv0_n12_N8S8279C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N8S8279C14D1Ev,_ZThn60_N8S8279C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C14D0Ev,_ZTv0_n16_N8S8279C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn88_N8S8279C14D0Ev,_ZThn48_N8S8279C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C14D1Ev,_ZTv0_n16_N8S8279C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn88_N8S8279C14D1Ev,_ZThn48_N8S8279C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S8279C14D0Ev,_ZTv0_n20_N8S8279C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N8S8279C14D0Ev,_ZThn36_N8S8279C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S8279C14D1Ev,_ZTv0_n20_N8S8279C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N8S8279C14D1Ev,_ZThn36_N8S8279C14D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S8279C14 = {  "S8279C14", // class name
  bases_S8279C14, 17,
  &(vtc_S8279C14[0]), // expected_vtbl_contents
  &(vtt_S8279C14[0]), // expected_vtt_contents
  ABISELECT(120,64), // object size
  NSPAIRA(_ZTI8S8279C14),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S8279C14),63, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S8279C14),30, //virtual table table var
  16, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8279C13  : virtual S694C11_nt , virtual S8279C5 , virtual S8279C3 , virtual S8279C14 {
  virtual  ~S8279C13(); // _ZN8S8279C13D2Ev
  S8279C13(); // tgen
};
//SIG(-1 S8279C13) C1{ VBC2{ m} VBC3{ VBC2 v1} VBC4{ VBC2 VBC3 VBC5{ BC6{ vd m} BC3 vd FC7{}} VBC6 BC8{ VBC2 VBC3 BC6 vd Fi:4}} VBC9{ VBC8 BC3 BC4 BC6 BC10{ BC6 VBC2 VBC3 VBC5 BC8 vd} vd Fi[2]} vd}


 S8279C13 ::~S8279C13(){ note_dtor("S8279C13", this);}
S8279C13 ::S8279C13(){ note_ctor("S8279C13", this);} // tgen

static void Test_S8279C13()
{
  extern Class_Descriptor cd_S8279C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,19)];
    init_test(&cd_S8279C13, buf);
    S8279C13 *dp, &lv = *(dp=new (buf) S8279C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,72), "sizeof(S8279C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8279C13)");
    check_base_class_offset(lv, (S694C11_nt*), 0, "S8279C13");
    /*is_ambiguous_... S8279C13::S8279C5 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C5*), 0, "S8279C13");
    /*is_ambiguous_... S8279C13::S8279C3 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C3*), 0, "S8279C13");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C5*)(S8279C6*), 0, "S8279C13");
    /*is_ambiguous_... S8279C13::S8279C3 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C8*)(S8279C3*), 0, "S8279C13");
    /*is_ambiguous_... S8279C13::S8279C8 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C8*), 0, "S8279C13");
    /*is_ambiguous_... S8279C14::S8279C5 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C5*)(S8279C14*), 0, "S8279C13");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C3*)(S8279C14*), 0, "S8279C13");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C8*)(S8279C3*)(S8279C14*), 0, "S8279C13");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C15*)(S8279C14*), 0, "S8279C13");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C8*)(S8279C15*)(S8279C14*), 0, "S8279C13");
    /*is_ambiguous_... S8279C13::S8279C5 */ AMB_check_base_class_offset(lv, (S8279C5*), 0, "S8279C13");
    /*is_ambiguous_... S8279C13::S8279C3 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C3*), 0, "S8279C13");
    /*is_ambiguous_... S8279C13::S8279C3 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C8*)(S8279C3*), 0, "S8279C13");
    /*is_ambiguous_... S8279C13::S8279C8 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C8*), 0, "S8279C13");
    /*is_ambiguous_... S8279C3::S8279C5 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C3*)(S8279C14*), 0, "S8279C13");
    check_base_class_offset(lv, (S8279C5*)(S8279C8*)(S8279C3*)(S8279C14*), 0, "S8279C13");
    /*is_ambiguous_... S8279C15::S8279C5 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C15*)(S8279C14*), 0, "S8279C13");
    check_base_class_offset(lv, (S8279C5*)(S8279C8*)(S8279C15*)(S8279C14*), 0, "S8279C13");
    check_base_class_offset(lv, (S814C5_nt*)(S8279C6*), ABISELECT(24,12), "S8279C13");
    check_base_class_offset(lv, (S8279C5*)(S8279C6*), ABISELECT(32,16), "S8279C13");
    /*is_ambiguous_... S8279C13::S8279C3 */ AMB_check_base_class_offset(lv, (S8279C6*)(S8279C3*), ABISELECT(24,12), "S8279C13");
    check_base_class_offset(lv, (S8279C6*)(S8279C3*)(S8279C14*), ABISELECT(24,12), "S8279C13");
    check_base_class_offset(lv, (S8279C6*)(S8279C15*)(S8279C14*), ABISELECT(24,12), "S8279C13");
    /*is_ambiguous_... S8279C13::S8279C3 */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C3*), ABISELECT(48,24), "S8279C13");
    /*is_ambiguous_... S8279C3::S814C5_nt */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C3*)(S8279C14*), ABISELECT(48,24), "S8279C13");
    /*is_ambiguous_... S8279C13::S8279C3 */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C8*)(S8279C3*), ABISELECT(8,4), "S8279C13");
    /*is_ambiguous_... S8279C13::S8279C3 */ AMB_check_base_class_offset(lv, (S8279C8*)(S8279C3*), ABISELECT(8,4), "S8279C13");
    /*is_ambiguous_... S8279C13::S8279C3 */ AMB_check_base_class_offset(lv, (S8279C3*), ABISELECT(8,4), "S8279C13");
    /*is_ambiguous_... S8279C13::S8279C8 */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C8*), ABISELECT(120,64), "S8279C13");
    /*is_ambiguous_... S8279C14::S8279C8 */ AMB_check_base_class_offset(lv, (S8279C8*)(S8279C14*), ABISELECT(120,64), "S8279C13");
    /*is_ambiguous_... S8279C14::S8279C5 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C14*), ABISELECT(56,28), "S8279C13");
    check_base_class_offset(lv, (S814C5_nt*)(S8279C8*)(S8279C3*)(S8279C14*), ABISELECT(64,32), "S8279C13");
    check_base_class_offset(lv, (S8279C8*)(S8279C3*)(S8279C14*), ABISELECT(64,32), "S8279C13");
    check_base_class_offset(lv, (S8279C3*)(S8279C14*), ABISELECT(64,32), "S8279C13");
    /*is_ambiguous_... S8279C14::S814C5_nt */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C14*), ABISELECT(80,40), "S8279C13");
    /*is_ambiguous_... S8279C15::S814C5_nt */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C15*)(S8279C14*), ABISELECT(88,44), "S8279C13");
    check_base_class_offset(lv, (S814C5_nt*)(S8279C8*)(S8279C15*)(S8279C14*), ABISELECT(96,48), "S8279C13");
    check_base_class_offset(lv, (S8279C8*)(S8279C15*)(S8279C14*), ABISELECT(96,48), "S8279C13");
    check_base_class_offset(lv, (S8279C15*)(S8279C14*), ABISELECT(88,44), "S8279C13");
    check_base_class_offset(lv, (S8279C14*), ABISELECT(56,28), "S8279C13");
    test_class_info(&lv, &cd_S8279C13);
    dp->~S8279C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8279C13(Test_S8279C13, "S8279C13", ABISELECT(136,72));

#else // __cplusplus

extern void _ZN8S8279C13C1Ev();
extern void _ZN8S8279C13D2Ev();
Name_Map name_map_S8279C13[] = {
  NSPAIR(_ZN8S8279C13C1Ev),
  NSPAIR(_ZN8S8279C13D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S694C11_nt;
extern VTBL_ENTRY _ZTI10S694C11_nt[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S8279C6;
extern VTBL_ENTRY _ZTI7S8279C6[];
extern  VTBL_ENTRY _ZTV7S8279C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C6[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C8;
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
extern Class_Descriptor cd_S8279C3;
extern VTBL_ENTRY _ZTI7S8279C3[];
extern  VTBL_ENTRY _ZTV7S8279C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C3[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C8;
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C8;
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
extern Class_Descriptor cd_S8279C3;
extern VTBL_ENTRY _ZTI7S8279C3[];
extern  VTBL_ENTRY _ZTV7S8279C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C3[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C8;
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
extern Class_Descriptor cd_S8279C15;
extern VTBL_ENTRY _ZTI8S8279C15[];
extern  VTBL_ENTRY _ZTV8S8279C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C15[];
extern Class_Descriptor cd_S8279C14;
extern VTBL_ENTRY _ZTI8S8279C14[];
extern  VTBL_ENTRY _ZTV8S8279C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C14[];
static Base_Class bases_S8279C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S694C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S8279C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S814C5_nt,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S8279C5,    ABISELECT(32,16), //bcp->offset
    29, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S8279C6,    ABISELECT(24,12), //bcp->offset
    22, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S814C5_nt,    ABISELECT(48,24), //bcp->offset
    33, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S814C5_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S8279C8,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S8279C3,    ABISELECT(8,4), //bcp->offset
    13, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S814C5_nt,    ABISELECT(120,64), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S8279C8,    ABISELECT(120,64), //bcp->offset
    75, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    48, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    20, //immediately_derived
  0, 1},
  {&cd_S8279C5,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S814C5_nt,    ABISELECT(64,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S8279C8,    ABISELECT(64,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    27, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S8279C3,    ABISELECT(64,32), //bcp->offset
    50, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S814C5_nt,    ABISELECT(80,40), //bcp->offset
    58, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S814C5_nt,    ABISELECT(88,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S814C5_nt,    ABISELECT(96,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S8279C8,    ABISELECT(96,48), //bcp->offset
    69, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S8279C15,    ABISELECT(88,44), //bcp->offset
    62, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S8279C14,    ABISELECT(56,28), //bcp->offset
    38, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S8279C13[];
extern void _ZN7S8279C52v1Ev();
extern void _ZN8S8279C13D1Ev();
extern void _ZN8S8279C13D0Ev();
extern void ABISELECT(_ZTv0_n56_N8S8279C13D1Ev,_ZTv0_n28_N8S8279C13D1Ev)();
extern void ABISELECT(_ZThn8_N8S8279C13D1Ev,_ZThn4_N8S8279C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S8279C13D0Ev,_ZTv0_n28_N8S8279C13D0Ev)();
extern void ABISELECT(_ZThn8_N8S8279C13D0Ev,_ZThn4_N8S8279C13D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S8279C13D1Ev,_ZTv0_n16_N8S8279C13D1Ev)();
extern void ABISELECT(_ZThn24_N8S8279C13D1Ev,_ZThn12_N8S8279C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S8279C13D0Ev,_ZTv0_n16_N8S8279C13D0Ev)();
extern void ABISELECT(_ZThn24_N8S8279C13D0Ev,_ZThn12_N8S8279C13D0Ev)() __attribute__((weak));
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTv0_n24_N8S8279C13D1Ev,_ZTv0_n12_N8S8279C13D1Ev)();
extern void ABISELECT(_ZThn48_N8S8279C13D1Ev,_ZThn24_N8S8279C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S8279C13D0Ev,_ZTv0_n12_N8S8279C13D0Ev)();
extern void ABISELECT(_ZThn48_N8S8279C13D0Ev,_ZThn24_N8S8279C13D0Ev)() __attribute__((weak));
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTv0_n72_N8S8279C13D1Ev,_ZTv0_n36_N8S8279C13D1Ev)();
extern void ABISELECT(_ZThn56_N8S8279C13D1Ev,_ZThn28_N8S8279C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S8279C13D0Ev,_ZTv0_n36_N8S8279C13D0Ev)();
extern void ABISELECT(_ZThn56_N8S8279C13D0Ev,_ZThn28_N8S8279C13D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn8_n72_N8S8279C13D1Ev,_ZTvn4_n36_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTvn8_n72_N8S8279C13D0Ev,_ZTvn4_n36_N8S8279C13D0Ev)();
extern void ABISELECT(_ZTvn24_n72_N8S8279C13D1Ev,_ZTvn12_n36_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTvn24_n72_N8S8279C13D0Ev,_ZTvn12_n36_N8S8279C13D0Ev)();
extern void ABISELECT(_ZTvn32_n72_N8S8279C13D1Ev,_ZTvn16_n36_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTvn32_n72_N8S8279C13D0Ev,_ZTvn16_n36_N8S8279C13D0Ev)();
extern void ABISELECT(_ZTvn40_n72_N8S8279C13D1Ev,_ZTvn20_n36_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTvn40_n72_N8S8279C13D0Ev,_ZTvn20_n36_N8S8279C13D0Ev)();
extern void ABISELECT(_ZTv0_n40_N8S8279C13D1Ev,_ZTv0_n20_N8S8279C13D1Ev)();
extern void ABISELECT(_ZThn120_N8S8279C13D1Ev,_ZThn64_N8S8279C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S8279C13D0Ev,_ZTv0_n20_N8S8279C13D0Ev)();
extern void ABISELECT(_ZThn120_N8S8279C13D0Ev,_ZThn64_N8S8279C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S8279C13[] = {
  ABISELECT(120,64),
  ABISELECT(56,28),
  ABISELECT(48,24),
  ABISELECT(24,12),
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&_ZN8S8279C13D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C13D0Ev,
  ABISELECT(-8,-4),
  ABISELECT(40,20),
  ABISELECT(16,8),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S8279C13D1Ev,_ZTv0_n28_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S8279C13D0Ev,_ZTv0_n28_N8S8279C13D0Ev),
  ABISELECT(8,4),
  ABISELECT(-24,-12),
  ABISELECT(-24,-12),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C13D1Ev,_ZTv0_n16_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C13D0Ev,_ZTv0_n16_N8S8279C13D0Ev),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C13D1Ev,_ZTv0_n12_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C13D0Ev,_ZTv0_n12_N8S8279C13D0Ev),
  ABISELECT(-56,-28),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-32,-16),
  ABISELECT(-56,-28),
  ABISELECT(64,36),
  ABISELECT(-56,-28),
  ABISELECT(-56,-28),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S8279C13D1Ev,_ZTv0_n36_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S8279C13D0Ev,_ZTv0_n36_N8S8279C13D0Ev),
  ABISELECT(-16,-8),
  ABISELECT(-40,-20),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n72_N8S8279C13D1Ev,_ZTvn4_n36_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n72_N8S8279C13D0Ev,_ZTvn4_n36_N8S8279C13D0Ev),
  ABISELECT(-80,-40),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn24_n72_N8S8279C13D1Ev,_ZTvn12_n36_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn24_n72_N8S8279C13D0Ev,_ZTvn12_n36_N8S8279C13D0Ev),
  ABISELECT(-64,-32),
  ABISELECT(-88,-44),
  ABISELECT(-88,-44),
  ABISELECT(-88,-44),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n72_N8S8279C13D1Ev,_ZTvn16_n36_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n72_N8S8279C13D0Ev,_ZTvn16_n36_N8S8279C13D0Ev),
  ABISELECT(-96,-48),
  ABISELECT(-96,-48),
  ABISELECT(-96,-48),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn40_n72_N8S8279C13D1Ev,_ZTvn20_n36_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn40_n72_N8S8279C13D0Ev,_ZTvn20_n36_N8S8279C13D0Ev),
  ABISELECT(-120,-64),
  ABISELECT(-120,-64),
  ABISELECT(-120,-64),
  ABISELECT(-120,-64),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C13D1Ev,_ZTv0_n20_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C13D0Ev,_ZTv0_n20_N8S8279C13D0Ev),
};
extern VTBL_ENTRY _ZTV8S8279C13[];
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C13[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C3D1Ev();
extern void _ZN7S8279C3D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C3__8S8279C13[] = {
  ABISELECT(40,20),
  ABISELECT(16,8),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&_ZN7S8279C3D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C3D0Ev,
};
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C87S8279C3__8S8279C13[] = {
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C87S8279C3__8S8279C13[] = {
  0,
  0,
  ABISELECT(8,4),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C3__8S8279C13[] = {
  0,
  0,
  ABISELECT(8,4),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N7S8279C3D1Ev,_ZTv0_n16_N7S8279C3D1Ev)();
extern void ABISELECT(_ZThn16_N7S8279C3D1Ev,_ZThn8_N7S8279C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S8279C3D0Ev,_ZTv0_n16_N7S8279C3D0Ev)();
extern void ABISELECT(_ZThn16_N7S8279C3D0Ev,_ZThn8_N7S8279C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S8279C6__7S8279C3__8S8279C13[] = {
  ABISELECT(8,4),
  ABISELECT(-16,-8),
  ABISELECT(-24,-12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S8279C3D1Ev,_ZTv0_n16_N7S8279C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S8279C3D0Ev,_ZTv0_n16_N7S8279C3D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__7S8279C3__8S8279C13[] = {
  ABISELECT(-32,-16),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S8279C3D1Ev,_ZTv0_n12_N7S8279C3D1Ev)();
extern void ABISELECT(_ZThn40_N7S8279C3D1Ev,_ZThn20_N7S8279C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S8279C3D0Ev,_ZTv0_n12_N7S8279C3D0Ev)();
extern void ABISELECT(_ZThn40_N7S8279C3D0Ev,_ZThn20_N7S8279C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S814C5_nt__A1__7S8279C3__8S8279C13[] = {
  ABISELECT(-40,-20),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S8279C3D1Ev,_ZTv0_n12_N7S8279C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S8279C3D0Ev,_ZTv0_n12_N7S8279C3D0Ev),
};
extern void _ZN7S8279C6D1Ev();
extern void _ZN7S8279C6D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C13[] = {
  ABISELECT(-24,-12),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C6[0]),
  (VTBL_ENTRY)&_ZN7S8279C6D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C6D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C13[] = {
  ABISELECT(-32,-16),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C6__8S8279C13[] = {
  ABISELECT(-32,-16),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S8279C6[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
extern void _ZN8S8279C14D1Ev();
extern void _ZN8S8279C14D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C14__8S8279C13[] = {
  ABISELECT(-8,-4),
  ABISELECT(-32,-16),
  ABISELECT(-56,-28),
  ABISELECT(64,36),
  ABISELECT(-56,-28),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&_ZN8S8279C14D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C14D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C58S8279C14__A2__8S8279C13[] = {
  ABISELECT(-56,-28),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C3D1Ev();
extern void _ZN7S8279C3D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C38S8279C14__A1__8S8279C13[] = {
  ABISELECT(-16,-8),
  ABISELECT(-40,-20),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&_ZN7S8279C3D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C3D0Ev,
};
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C87S8279C38S8279C14__A2__8S8279C13[] = {
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C87S8279C38S8279C14__A2__8S8279C13[] = {
  0,
  0,
  ABISELECT(64,32),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C38S8279C14__A1__8S8279C13[] = {
  0,
  0,
  ABISELECT(64,32),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N7S8279C3D1Ev,_ZTv0_n16_N7S8279C3D1Ev)();
extern void ABISELECT(_ZTv0_n32_N7S8279C3D0Ev,_ZTv0_n16_N7S8279C3D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C6__7S8279C38S8279C14__A1__8S8279C13[] = {
  ABISELECT(8,4),
  ABISELECT(40,20),
  ABISELECT(-24,-12),
  ABISELECT(40,20),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S8279C3D1Ev,_ZTv0_n16_N7S8279C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S8279C3D0Ev,_ZTv0_n16_N7S8279C3D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__7S8279C38S8279C14__A1__8S8279C13[] = {
  ABISELECT(-32,-16),
  ABISELECT(32,16),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S8279C3D1Ev,_ZTv0_n12_N7S8279C3D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S8279C3D0Ev,_ZTv0_n12_N7S8279C3D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S814C5_nt__A1__7S8279C38S8279C14__A1__8S8279C13[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S8279C3D1Ev,_ZTv0_n12_N7S8279C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S8279C3D0Ev,_ZTv0_n12_N7S8279C3D0Ev),
};
extern void _ZN8S8279C15D1Ev();
extern void _ZN8S8279C15D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C158S8279C14__8S8279C13[] = {
  ABISELECT(-64,-32),
  ABISELECT(-88,-44),
  ABISELECT(-88,-44),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN8S8279C15D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C15D0Ev,
};
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C158S8279C14__A3__8S8279C13[] = {
  ABISELECT(-96,-48),
  ABISELECT(-96,-48),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C88S8279C158S8279C14__A3__8S8279C13[] = {
  0,
  0,
  ABISELECT(96,48),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C158S8279C14__8S8279C13[] = {
  0,
  0,
  ABISELECT(88,44),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev)();
extern void ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C158S8279C14__8S8279C13[] = {
  ABISELECT(8,4),
  ABISELECT(64,32),
  ABISELECT(-24,-12),
  ABISELECT(64,32),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C158S8279C14__8S8279C13[] = {
  ABISELECT(-32,-16),
  ABISELECT(56,28),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZThn8_N8S8279C15D1Ev,_ZThn4_N8S8279C15D1Ev)();
extern void ABISELECT(_ZThn8_N8S8279C15D0Ev,_ZThn4_N8S8279C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C8__8S8279C158S8279C14__8S8279C13[] = {
  ABISELECT(-96,-48),
  ABISELECT(-96,-48),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C15D1Ev,_ZThn4_N8S8279C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C15D0Ev,_ZThn4_N8S8279C15D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N8S8279C14D1Ev,_ZTv0_n20_N8S8279C14D1Ev)();
extern void ABISELECT(_ZThn64_N8S8279C14D1Ev,_ZThn36_N8S8279C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S8279C14D0Ev,_ZTv0_n20_N8S8279C14D0Ev)();
extern void ABISELECT(_ZThn64_N8S8279C14D0Ev,_ZThn36_N8S8279C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S8279C8__8S8279C14__8S8279C13[] = {
  ABISELECT(-64,-36),
  ABISELECT(-120,-64),
  ABISELECT(-120,-64),
  ABISELECT(-64,-36),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C14D1Ev,_ZTv0_n20_N8S8279C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C14D0Ev,_ZTv0_n20_N8S8279C14D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C14__8S8279C13[] = {
  0,
  0,
  ABISELECT(56,28),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZThn8_N8S8279C14D1Ev,_ZThn4_N8S8279C14D1Ev)();
extern void ABISELECT(_ZThn8_N8S8279C14D0Ev,_ZThn4_N8S8279C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C3__8S8279C14__8S8279C13[] = {
  ABISELECT(-16,-8),
  ABISELECT(-40,-20),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C14D1Ev,_ZThn4_N8S8279C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C14D0Ev,_ZThn4_N8S8279C14D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S8279C14D1Ev,_ZTv0_n16_N8S8279C14D1Ev)();
extern void ABISELECT(_ZTv0_n32_N8S8279C14D0Ev,_ZTv0_n16_N8S8279C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C14__8S8279C13[] = {
  ABISELECT(8,4),
  ABISELECT(32,16),
  ABISELECT(-24,-12),
  ABISELECT(32,16),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C14D1Ev,_ZTv0_n16_N8S8279C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C14D0Ev,_ZTv0_n16_N8S8279C14D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A2__8S8279C14__8S8279C13[] = {
  ABISELECT(-32,-16),
  ABISELECT(24,12),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S8279C14D1Ev,_ZTv0_n12_N8S8279C14D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S8279C14D0Ev,_ZTv0_n12_N8S8279C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S814C5_nt__A2__8S8279C14__8S8279C13[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C14D1Ev,_ZTv0_n12_N8S8279C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C14D0Ev,_ZTv0_n12_N8S8279C14D0Ev),
};
extern void ABISELECT(_ZThn32_N8S8279C14D1Ev,_ZThn16_N8S8279C14D1Ev)();
extern void ABISELECT(_ZThn32_N8S8279C14D0Ev,_ZThn16_N8S8279C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S8279C15__8S8279C14__8S8279C13[] = {
  ABISELECT(-64,-32),
  ABISELECT(-88,-44),
  ABISELECT(-88,-44),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S8279C14D1Ev,_ZThn16_N8S8279C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S8279C14D0Ev,_ZThn16_N8S8279C14D0Ev),
};
extern void ABISELECT(_ZThn40_N8S8279C14D1Ev,_ZThn20_N8S8279C14D1Ev)();
extern void ABISELECT(_ZThn40_N8S8279C14D0Ev,_ZThn20_N8S8279C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C15__A2__8S8279C14__8S8279C13[] = {
  ABISELECT(-96,-48),
  ABISELECT(-96,-48),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N8S8279C14D1Ev,_ZThn20_N8S8279C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N8S8279C14D0Ev,_ZThn20_N8S8279C14D0Ev),
};
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C8__A1__8S8279C13[] = {
  ABISELECT(-120,-64),
  ABISELECT(-120,-64),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C8__A1__8S8279C13[] = {
  0,
  0,
  ABISELECT(120,64),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
static  VTT_ENTRY vtt_S8279C13[] = {
  {&(_ZTV8S8279C13[10]),  10,82},
  {&(_ZTV8S8279C13[10]),  10,82},
  {&(_ZTV8S8279C13[20]),  20,82},
  {&(_ZTV8S8279C13[27]),  27,82},
  {&(_ZTV8S8279C13[32]),  32,82},
  {&(_ZTV8S8279C13[36]),  36,82},
  {&(_ZTV8S8279C13[47]),  47,82},
  {&(_ZTV8S8279C13[80]),  80,82},
  {&(_ZTV8S8279C13[56]),  56,82},
  {&(_ZTV8S8279C13[60]),  60,82},
  {&(_ZTV8S8279C13[67]),  67,82},
  {&(_ZTV8S8279C13[73]),  73,82},
  {&(_tg__ZTV7S8279C5__8S8279C13[3]),  3,4},
  {&(_tg__ZTV7S8279C3__8S8279C13[6]),  6,8},
  {&(_tg__ZTV7S8279C87S8279C3__8S8279C13[4]),  4,6},
  {&(_tg__ZTV7S8279C5__7S8279C87S8279C3__8S8279C13[4]),  4,5},
  {&(_tg__ZTV7S8279C5__7S8279C3__8S8279C13[4]),  4,5},
  {&(_tg__ZTV7S8279C6__7S8279C3__8S8279C13[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__7S8279C3__8S8279C13[3]),  3,4},
  {&(_tg__ZTV9S814C5_nt__A1__7S8279C3__8S8279C13[3]),  3,5},
  {&(_tg__ZTV7S8279C6__8S8279C13[3]),  3,5},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C13[3]),  3,4},
  {&(_tg__ZTV7S8279C5__7S8279C6__8S8279C13[3]),  3,4},
  {&(_tg__ZTV8S8279C14__8S8279C13[7]),  7,10},
  {&(_tg__ZTV7S8279C58S8279C14__A2__8S8279C13[3]),  3,4},
  {&(_tg__ZTV7S8279C38S8279C14__A1__8S8279C13[6]),  6,8},
  {&(_tg__ZTV7S8279C87S8279C38S8279C14__A2__8S8279C13[4]),  4,6},
  {&(_tg__ZTV7S8279C5__7S8279C87S8279C38S8279C14__A2__8S8279C13[4]),  4,5},
  {&(_tg__ZTV7S8279C5__7S8279C38S8279C14__A1__8S8279C13[4]),  4,5},
  {&(_tg__ZTV7S8279C6__7S8279C38S8279C14__A1__8S8279C13[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__7S8279C38S8279C14__A1__8S8279C13[3]),  3,4},
  {&(_tg__ZTV9S814C5_nt__A1__7S8279C38S8279C14__A1__8S8279C13[3]),  3,5},
  {&(_tg__ZTV8S8279C158S8279C14__8S8279C13[5]),  5,7},
  {&(_tg__ZTV7S8279C88S8279C158S8279C14__A3__8S8279C13[4]),  4,6},
  {&(_tg__ZTV7S8279C5__7S8279C88S8279C158S8279C14__A3__8S8279C13[4]),  4,5},
  {&(_tg__ZTV7S8279C5__8S8279C158S8279C14__8S8279C13[4]),  4,5},
  {&(_tg__ZTV7S8279C6__8S8279C158S8279C14__8S8279C13[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C158S8279C14__8S8279C13[3]),  3,4},
  {&(_tg__ZTV7S8279C8__8S8279C158S8279C14__8S8279C13[4]),  4,6},
  {&(_tg__ZTV7S8279C8__8S8279C14__8S8279C13[5]),  5,7},
  {&(_tg__ZTV7S8279C5__8S8279C14__8S8279C13[4]),  4,5},
  {&(_tg__ZTV7S8279C3__8S8279C14__8S8279C13[6]),  6,8},
  {&(_tg__ZTV7S8279C6__8S8279C14__8S8279C13[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A2__8S8279C14__8S8279C13[3]),  3,4},
  {&(_tg__ZTV9S814C5_nt__A2__8S8279C14__8S8279C13[3]),  3,5},
  {&(_tg__ZTV8S8279C15__8S8279C14__8S8279C13[5]),  5,7},
  {&(_tg__ZTV7S8279C88S8279C15__A2__8S8279C14__8S8279C13[4]),  4,6},
  {&(_tg__ZTV7S8279C8__A1__8S8279C13[4]),  4,6},
  {&(_tg__ZTV7S8279C5__7S8279C8__A1__8S8279C13[4]),  4,5},
};
extern VTBL_ENTRY _ZTI8S8279C13[];
extern  VTBL_ENTRY _ZTV8S8279C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C13[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S8279C14D0Ev,_ZTv0_n20_N8S8279C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N8S8279C14D0Ev,_ZThn36_N8S8279C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S8279C14D1Ev,_ZTv0_n20_N8S8279C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N8S8279C14D1Ev,_ZThn36_N8S8279C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S8279C3D0Ev,_ZTv0_n12_N7S8279C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N7S8279C3D0Ev,_ZThn20_N7S8279C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S8279C3D1Ev,_ZTv0_n12_N7S8279C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N7S8279C3D1Ev,_ZThn20_N7S8279C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S8279C3D0Ev,_ZTv0_n16_N7S8279C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7S8279C3D0Ev,_ZThn8_N7S8279C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S8279C3D1Ev,_ZTv0_n16_N7S8279C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7S8279C3D1Ev,_ZThn8_N7S8279C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S8279C13D0Ev,_ZTv0_n20_N8S8279C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn120_N8S8279C13D0Ev,_ZThn64_N8S8279C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S8279C13D1Ev,_ZTv0_n20_N8S8279C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn120_N8S8279C13D1Ev,_ZThn64_N8S8279C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S8279C13D0Ev,_ZTv0_n36_N8S8279C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S8279C13D0Ev,_ZThn28_N8S8279C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S8279C13D1Ev,_ZTv0_n36_N8S8279C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S8279C13D1Ev,_ZThn28_N8S8279C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S8279C13D0Ev,_ZTv0_n12_N8S8279C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S8279C13D0Ev,_ZThn24_N8S8279C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S8279C13D1Ev,_ZTv0_n12_N8S8279C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S8279C13D1Ev,_ZThn24_N8S8279C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C13D0Ev,_ZTv0_n16_N8S8279C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S8279C13D0Ev,_ZThn12_N8S8279C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C13D1Ev,_ZTv0_n16_N8S8279C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S8279C13D1Ev,_ZThn12_N8S8279C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S8279C13D0Ev,_ZTv0_n28_N8S8279C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N8S8279C13D0Ev,_ZThn4_N8S8279C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S8279C13D1Ev,_ZTv0_n28_N8S8279C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N8S8279C13D1Ev,_ZThn4_N8S8279C13D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S8279C13 = {  "S8279C13", // class name
  bases_S8279C13, 21,
  &(vtc_S8279C13[0]), // expected_vtbl_contents
  &(vtt_S8279C13[0]), // expected_vtt_contents
  ABISELECT(136,72), // object size
  NSPAIRA(_ZTI8S8279C13),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S8279C13),82, //virtual function table var
  10, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S8279C13),49, //virtual table table var
  20, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8279C17  : virtual S8279C15 {
  virtual  ~S8279C17(); // _ZN8S8279C17D2Ev
  S8279C17(); // tgen
};
//SIG(-1 S8279C17) C1{ VBC2{ BC3{ vd m} VBC4{ m} VBC5{ VBC4 v1} VBC6{ BC3 BC5 vd FC7{}} BC8{ VBC4 VBC5 BC3 vd Fi:4} vd} vd}


 S8279C17 ::~S8279C17(){ note_dtor("S8279C17", this);}
S8279C17 ::S8279C17(){ note_ctor("S8279C17", this);} // tgen

static void Test_S8279C17()
{
  extern Class_Descriptor cd_S8279C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[8];
    init_test(&cd_S8279C17, buf);
    S8279C17 *dp, &lv = *(dp=new (buf) S8279C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,28), "sizeof(S8279C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8279C17)");
    /*is_ambiguous_... S8279C15::S814C5_nt */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C15*), ABISELECT(8,4), "S8279C17");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C15*), 0, "S8279C17");
    /*is_ambiguous_... S8279C17::S8279C5 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C5*), 0, "S8279C17");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C5*)(S8279C6*), 0, "S8279C17");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C8*)(S8279C15*), 0, "S8279C17");
    /*is_ambiguous_... S8279C15::S8279C5 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C15*), 0, "S8279C17");
    check_base_class_offset(lv, (S8279C5*)(S8279C8*)(S8279C15*), 0, "S8279C17");
    check_base_class_offset(lv, (S814C5_nt*)(S8279C6*), ABISELECT(32,16), "S8279C17");
    check_base_class_offset(lv, (S8279C5*)(S8279C6*), ABISELECT(40,20), "S8279C17");
    check_base_class_offset(lv, (S8279C6*)(S8279C15*), ABISELECT(32,16), "S8279C17");
    check_base_class_offset(lv, (S814C5_nt*)(S8279C8*)(S8279C15*), ABISELECT(16,8), "S8279C17");
    check_base_class_offset(lv, (S8279C8*)(S8279C15*), ABISELECT(16,8), "S8279C17");
    check_base_class_offset(lv, (S8279C15*), ABISELECT(8,4), "S8279C17");
    test_class_info(&lv, &cd_S8279C17);
    dp->~S8279C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8279C17(Test_S8279C17, "S8279C17", ABISELECT(56,28));

#else // __cplusplus

extern void _ZN8S8279C17C1Ev();
extern void _ZN8S8279C17D2Ev();
Name_Map name_map_S8279C17[] = {
  NSPAIR(_ZN8S8279C17C1Ev),
  NSPAIR(_ZN8S8279C17D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S694C11_nt;
extern VTBL_ENTRY _ZTI10S694C11_nt[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S8279C6;
extern VTBL_ENTRY _ZTI7S8279C6[];
extern  VTBL_ENTRY _ZTV7S8279C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C6[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C8;
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
extern Class_Descriptor cd_S8279C15;
extern VTBL_ENTRY _ZTI8S8279C15[];
extern  VTBL_ENTRY _ZTV8S8279C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C15[];
static Base_Class bases_S8279C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S814C5_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S694C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S8279C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S814C5_nt,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S8279C5,    ABISELECT(40,20), //bcp->offset
    31, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S8279C6,    ABISELECT(32,16), //bcp->offset
    24, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S814C5_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S8279C8,    ABISELECT(16,8), //bcp->offset
    18, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S8279C15,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S8279C17[];
extern void _ZN7S8279C52v1Ev();
extern void _ZN8S8279C17D1Ev();
extern void _ZN8S8279C17D0Ev();
extern void ABISELECT(_ZTv0_n48_N8S8279C17D1Ev,_ZTv0_n24_N8S8279C17D1Ev)();
extern void ABISELECT(_ZThn8_N8S8279C17D1Ev,_ZThn4_N8S8279C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S8279C17D0Ev,_ZTv0_n24_N8S8279C17D0Ev)();
extern void ABISELECT(_ZThn8_N8S8279C17D0Ev,_ZThn4_N8S8279C17D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn8_n48_N8S8279C17D1Ev,_ZTvn4_n24_N8S8279C17D1Ev)();
extern void ABISELECT(_ZTvn8_n48_N8S8279C17D0Ev,_ZTvn4_n24_N8S8279C17D0Ev)();
extern void ABISELECT(_ZTv0_n32_N8S8279C17D1Ev,_ZTv0_n16_N8S8279C17D1Ev)();
extern void ABISELECT(_ZThn32_N8S8279C17D1Ev,_ZThn16_N8S8279C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S8279C17D0Ev,_ZTv0_n16_N8S8279C17D0Ev)();
extern void ABISELECT(_ZThn32_N8S8279C17D0Ev,_ZThn16_N8S8279C17D0Ev)() __attribute__((weak));
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY vtc_S8279C17[] = {
  ABISELECT(32,16),
  0,
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&_ZN8S8279C17D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C17D0Ev,
  ABISELECT(-8,-4),
  ABISELECT(24,12),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C17D1Ev,_ZTv0_n24_N8S8279C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C17D0Ev,_ZTv0_n24_N8S8279C17D0Ev),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S8279C17D1Ev,_ZTvn4_n24_N8S8279C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S8279C17D0Ev,_ZTvn4_n24_N8S8279C17D0Ev),
  ABISELECT(8,4),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C17D1Ev,_ZTv0_n16_N8S8279C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C17D0Ev,_ZTv0_n16_N8S8279C17D0Ev),
  ABISELECT(-40,-20),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern VTBL_ENTRY _ZTV8S8279C17[];
extern void _ZN8S8279C15D1Ev();
extern void _ZN8S8279C15D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C15__8S8279C17[] = {
  ABISELECT(24,12),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN8S8279C15D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C15D0Ev,
};
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C15__8S8279C17[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C88S8279C15__8S8279C17[] = {
  0,
  0,
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C15__8S8279C17[] = {
  0,
  0,
  ABISELECT(8,4),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev)();
extern void ABISELECT(_ZThn24_N8S8279C15D1Ev,_ZThn12_N8S8279C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev)();
extern void ABISELECT(_ZThn24_N8S8279C15D0Ev,_ZThn12_N8S8279C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C15__8S8279C17[] = {
  ABISELECT(8,4),
  ABISELECT(-24,-12),
  ABISELECT(-32,-16),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C15__8S8279C17[] = {
  ABISELECT(-40,-20),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZThn8_N8S8279C15D1Ev,_ZThn4_N8S8279C15D1Ev)();
extern void ABISELECT(_ZThn8_N8S8279C15D0Ev,_ZThn4_N8S8279C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C8__8S8279C15__8S8279C17[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C15D1Ev,_ZThn4_N8S8279C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C15D0Ev,_ZThn4_N8S8279C15D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C17[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C6D1Ev();
extern void _ZN7S8279C6D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C17[] = {
  ABISELECT(-32,-16),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C6[0]),
  (VTBL_ENTRY)&_ZN7S8279C6D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C6D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C17[] = {
  ABISELECT(-40,-20),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C6__8S8279C17[] = {
  ABISELECT(-40,-20),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S8279C6[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
static  VTT_ENTRY vtt_S8279C17[] = {
  {&(_ZTV8S8279C17[7]),  7,35},
  {&(_ZTV8S8279C17[16]),  16,35},
  {&(_ZTV8S8279C17[7]),  7,35},
  {&(_ZTV8S8279C17[29]),  29,35},
  {&(_ZTV8S8279C17[34]),  34,35},
  {&(_ZTV8S8279C17[22]),  22,35},
  {&(_tg__ZTV8S8279C15__8S8279C17[5]),  5,7},
  {&(_tg__ZTV7S8279C88S8279C15__8S8279C17[4]),  4,6},
  {&(_tg__ZTV7S8279C5__7S8279C88S8279C15__8S8279C17[4]),  4,5},
  {&(_tg__ZTV7S8279C5__8S8279C15__8S8279C17[4]),  4,5},
  {&(_tg__ZTV7S8279C6__8S8279C15__8S8279C17[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C15__8S8279C17[3]),  3,4},
  {&(_tg__ZTV7S8279C8__8S8279C15__8S8279C17[4]),  4,6},
  {&(_tg__ZTV7S8279C5__8S8279C17[3]),  3,4},
  {&(_tg__ZTV7S8279C6__8S8279C17[3]),  3,5},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C17[3]),  3,4},
  {&(_tg__ZTV7S8279C5__7S8279C6__8S8279C17[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8S8279C17[];
extern  VTBL_ENTRY _ZTV8S8279C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C17[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S8279C15D0Ev,_ZThn12_N8S8279C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S8279C15D1Ev,_ZThn12_N8S8279C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C17D0Ev,_ZTv0_n16_N8S8279C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S8279C17D0Ev,_ZThn16_N8S8279C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C17D1Ev,_ZTv0_n16_N8S8279C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S8279C17D1Ev,_ZThn16_N8S8279C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S8279C17D0Ev,_ZTv0_n24_N8S8279C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N8S8279C17D0Ev,_ZThn4_N8S8279C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S8279C17D1Ev,_ZTv0_n24_N8S8279C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N8S8279C17D1Ev,_ZThn4_N8S8279C17D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S8279C17 = {  "S8279C17", // class name
  bases_S8279C17, 9,
  &(vtc_S8279C17[0]), // expected_vtbl_contents
  &(vtt_S8279C17[0]), // expected_vtt_contents
  ABISELECT(56,28), // object size
  NSPAIRA(_ZTI8S8279C17),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S8279C17),35, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S8279C17),17, //virtual table table var
  8, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8279C16  : virtual S8279C8 , S8279C13 , S8279C15 , S8279C17 {
  void *s8279c16f0;
  ~S8279C16(); // tgen
  S8279C16(); // tgen
};
//SIG(-1 S8279C16) C1{ VBC2{ VBC3{ m} VBC4{ VBC3 v1} BC5{ vd m} vd Fi:4} BC6{ VBC3 VBC4 VBC7{ VBC3 VBC4 VBC8{ BC5 BC4 vd FC9{}} VBC5 BC2} VBC10{ VBC2 BC4 BC7 BC5 BC11{ BC5 VBC3 VBC4 VBC8 BC2 vd} vd Fi[2]} vd} BC11 BC12{ VBC11 vd} Fp}


S8279C16 ::~S8279C16(){ note_dtor("S8279C16", this);} // tgen
S8279C16 ::S8279C16(){ note_ctor("S8279C16", this);} // tgen

static void Test_S8279C16()
{
  extern Class_Descriptor cd_S8279C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,27)];
    init_test(&cd_S8279C16, buf);
    S8279C16 *dp, &lv = *(dp=new (buf) S8279C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,104), "sizeof(S8279C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8279C16)");
    /*is_ambiguous_... S8279C16::S8279C8 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C8*), 0, "S8279C16");
    /*is_ambiguous_... S8279C16::S8279C5 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C5*), 0, "S8279C16");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C13*), 0, "S8279C16");
    /*is_ambiguous_... S8279C16::S8279C3 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C3*), 0, "S8279C16");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C5*)(S8279C6*), 0, "S8279C16");
    /*is_ambiguous_... S8279C16::S8279C3 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C8*)(S8279C3*), 0, "S8279C16");
    /*is_ambiguous_... S8279C14::S8279C5 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C5*)(S8279C14*), 0, "S8279C16");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C3*)(S8279C14*), 0, "S8279C16");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C8*)(S8279C3*)(S8279C14*), 0, "S8279C16");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C15*)(S8279C14*), 0, "S8279C16");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C8*)(S8279C15*)(S8279C14*), 0, "S8279C16");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C15*), 0, "S8279C16");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C8*)(S8279C15*), 0, "S8279C16");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C15*), 0, "S8279C16");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C8*)(S8279C15*), 0, "S8279C16");
    /*is_ambiguous_... S8279C16::S8279C8 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C8*), 0, "S8279C16");
    /*is_ambiguous_... S8279C13::S8279C5 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C13*), 0, "S8279C16");
    /*is_ambiguous_... S8279C16::S8279C3 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C3*), 0, "S8279C16");
    /*is_ambiguous_... S8279C16::S8279C3 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C8*)(S8279C3*), 0, "S8279C16");
    /*is_ambiguous_... S8279C3::S8279C5 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C3*)(S8279C14*), 0, "S8279C16");
    check_base_class_offset(lv, (S8279C5*)(S8279C8*)(S8279C3*)(S8279C14*), 0, "S8279C16");
    /*is_ambiguous_... S8279C15::S8279C5 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C15*)(S8279C14*), 0, "S8279C16");
    check_base_class_offset(lv, (S8279C5*)(S8279C8*)(S8279C15*)(S8279C14*), 0, "S8279C16");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C15*), 0, "S8279C16");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C8*)(S8279C15*), 0, "S8279C16");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C15*), 0, "S8279C16");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C8*)(S8279C15*), 0, "S8279C16");
    /*is_ambiguous_... S8279C16::S8279C8 */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C8*), ABISELECT(48,24), "S8279C16");
    /*is_ambiguous_... S8279C16::S8279C8 */ AMB_check_base_class_offset(lv, (S8279C8*), ABISELECT(48,24), "S8279C16");
    /*is_ambiguous_... S8279C14::S8279C8 */ AMB_check_base_class_offset(lv, (S8279C8*)(S8279C14*), ABISELECT(48,24), "S8279C16");
    check_base_class_offset(lv, (S814C5_nt*)(S8279C6*), ABISELECT(80,40), "S8279C16");
    check_base_class_offset(lv, (S8279C5*)(S8279C6*), ABISELECT(88,44), "S8279C16");
    /*is_ambiguous_... S8279C16::S8279C3 */ AMB_check_base_class_offset(lv, (S8279C6*)(S8279C3*), ABISELECT(80,40), "S8279C16");
    check_base_class_offset(lv, (S8279C6*)(S8279C3*)(S8279C14*), ABISELECT(80,40), "S8279C16");
    check_base_class_offset(lv, (S8279C6*)(S8279C15*)(S8279C14*), ABISELECT(80,40), "S8279C16");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S8279C6*)(S8279C15*), ABISELECT(80,40), "S8279C16");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S8279C6*)(S8279C15*), ABISELECT(80,40), "S8279C16");
    /*is_ambiguous_... S8279C16::S8279C3 */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C3*), ABISELECT(104,52), "S8279C16");
    /*is_ambiguous_... S8279C3::S814C5_nt */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C3*)(S8279C14*), ABISELECT(104,52), "S8279C16");
    /*is_ambiguous_... S8279C16::S8279C3 */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C8*)(S8279C3*), ABISELECT(64,32), "S8279C16");
    /*is_ambiguous_... S8279C16::S8279C3 */ AMB_check_base_class_offset(lv, (S8279C8*)(S8279C3*), ABISELECT(64,32), "S8279C16");
    /*is_ambiguous_... S8279C13::S8279C3 */ AMB_check_base_class_offset(lv, (S8279C3*)(S8279C13*), ABISELECT(64,32), "S8279C16");
    /*is_ambiguous_... S8279C14::S8279C5 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C14*), ABISELECT(112,56), "S8279C16");
    check_base_class_offset(lv, (S814C5_nt*)(S8279C8*)(S8279C3*)(S8279C14*), ABISELECT(120,60), "S8279C16");
    check_base_class_offset(lv, (S8279C8*)(S8279C3*)(S8279C14*), ABISELECT(120,60), "S8279C16");
    check_base_class_offset(lv, (S8279C3*)(S8279C14*), ABISELECT(120,60), "S8279C16");
    /*is_ambiguous_... S8279C14::S814C5_nt */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C14*), ABISELECT(136,68), "S8279C16");
    /*is_ambiguous_... S8279C15::S814C5_nt */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C15*)(S8279C14*), ABISELECT(144,72), "S8279C16");
    check_base_class_offset(lv, (S814C5_nt*)(S8279C8*)(S8279C15*)(S8279C14*), ABISELECT(152,76), "S8279C16");
    check_base_class_offset(lv, (S8279C8*)(S8279C15*)(S8279C14*), ABISELECT(152,76), "S8279C16");
    check_base_class_offset(lv, (S8279C15*)(S8279C14*), ABISELECT(144,72), "S8279C16");
    check_base_class_offset(lv, (S8279C14*)(S8279C13*), ABISELECT(112,56), "S8279C16");
    check_base_class_offset(lv, (S8279C13*), 0, "S8279C16");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C15*), ABISELECT(8,4), "S8279C16");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C8*)(S8279C15*), ABISELECT(16,8), "S8279C16");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S8279C8*)(S8279C15*), ABISELECT(16,8), "S8279C16");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S8279C15*), ABISELECT(8,4), "S8279C16");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C15*), ABISELECT(176,92), "S8279C16");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C8*)(S8279C15*), ABISELECT(184,96), "S8279C16");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S8279C8*)(S8279C15*), ABISELECT(184,96), "S8279C16");
    check_base_class_offset(lv, (S8279C15*)(S8279C17*), ABISELECT(176,92), "S8279C16");
    check_base_class_offset(lv, (S8279C17*), ABISELECT(32,16), "S8279C16");
    check_field_offset(lv, s8279c16f0, ABISELECT(40,20), "S8279C16.s8279c16f0");
    test_class_info(&lv, &cd_S8279C16);
    dp->~S8279C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8279C16(Test_S8279C16, "S8279C16", ABISELECT(200,104));

#else // __cplusplus

extern void _ZN8S8279C16C1Ev();
extern void _ZN8S8279C16D1Ev();
Name_Map name_map_S8279C16[] = {
  NSPAIR(_ZN8S8279C16C1Ev),
  NSPAIR(_ZN8S8279C16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S694C11_nt;
extern VTBL_ENTRY _ZTI10S694C11_nt[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C8;
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S8279C6;
extern VTBL_ENTRY _ZTI7S8279C6[];
extern  VTBL_ENTRY _ZTV7S8279C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C6[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C8;
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
extern Class_Descriptor cd_S8279C3;
extern VTBL_ENTRY _ZTI7S8279C3[];
extern  VTBL_ENTRY _ZTV7S8279C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C3[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C8;
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
extern Class_Descriptor cd_S8279C3;
extern VTBL_ENTRY _ZTI7S8279C3[];
extern  VTBL_ENTRY _ZTV7S8279C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C3[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C8;
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
extern Class_Descriptor cd_S8279C15;
extern VTBL_ENTRY _ZTI8S8279C15[];
extern  VTBL_ENTRY _ZTV8S8279C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C15[];
extern Class_Descriptor cd_S8279C14;
extern VTBL_ENTRY _ZTI8S8279C14[];
extern  VTBL_ENTRY _ZTV8S8279C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C14[];
extern Class_Descriptor cd_S8279C13;
extern VTBL_ENTRY _ZTI8S8279C13[];
extern  VTBL_ENTRY _ZTV8S8279C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C13[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C8;
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
extern Class_Descriptor cd_S8279C15;
extern VTBL_ENTRY _ZTI8S8279C15[];
extern  VTBL_ENTRY _ZTV8S8279C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C15[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C8;
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
extern Class_Descriptor cd_S8279C15;
extern VTBL_ENTRY _ZTI8S8279C15[];
extern  VTBL_ENTRY _ZTV8S8279C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C15[];
extern Class_Descriptor cd_S8279C17;
extern VTBL_ENTRY _ZTI8S8279C17[];
extern  VTBL_ENTRY _ZTV8S8279C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C17[];
static Base_Class bases_S8279C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S694C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S8279C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    45, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S814C5_nt,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S8279C8,    ABISELECT(48,24), //bcp->offset
    37, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    43, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S814C5_nt,    ABISELECT(80,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S8279C5,    ABISELECT(88,44), //bcp->offset
    60, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    54, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S8279C6,    ABISELECT(80,40), //bcp->offset
    53, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    53, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S814C5_nt,    ABISELECT(104,52), //bcp->offset
    64, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    32, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S814C5_nt,    ABISELECT(64,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S8279C8,    ABISELECT(64,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    47, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S8279C3,    ABISELECT(64,32), //bcp->offset
    44, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    46, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    21, //immediately_derived
  0, 1},
  {&cd_S8279C5,    ABISELECT(112,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    57, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S814C5_nt,    ABISELECT(120,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S8279C8,    ABISELECT(120,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    59, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S8279C3,    ABISELECT(120,60), //bcp->offset
    81, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    34, //bcp->index_in_construction_vtbl_array
    58, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S814C5_nt,    ABISELECT(136,68), //bcp->offset
    89, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    35, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S814C5_nt,    ABISELECT(144,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S814C5_nt,    ABISELECT(152,76), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S8279C8,    ABISELECT(152,76), //bcp->offset
    100, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    37, //bcp->index_in_construction_vtbl_array
    66, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S8279C15,    ABISELECT(144,72), //bcp->offset
    93, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    36, //bcp->index_in_construction_vtbl_array
    65, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S8279C14,    ABISELECT(112,56), //bcp->offset
    69, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    33, //bcp->index_in_construction_vtbl_array
    56, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    21, //immediately_derived
  0, 1},
  {&cd_S8279C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S814C5_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S814C5_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S8279C8,    ABISELECT(16,8), //bcp->offset
    21, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    39, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S8279C15,    ABISELECT(8,4), //bcp->offset
    14, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    38, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S814C5_nt,    ABISELECT(176,92), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S814C5_nt,    ABISELECT(184,96), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S8279C8,    ABISELECT(184,96), //bcp->offset
    114, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    42, //bcp->index_in_construction_vtbl_array
    81, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S8279C15,    ABISELECT(176,92), //bcp->offset
    106, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    41, //bcp->index_in_construction_vtbl_array
    80, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    30, //immediately_derived
  0, 1},
  {&cd_S8279C17,    ABISELECT(32,16), //bcp->offset
    27, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    40, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S8279C16[];
extern void _ZN7S8279C52v1Ev();
extern void _ZN8S8279C16D1Ev();
extern void _ZN8S8279C16D0Ev();
extern void ABISELECT(_ZThn8_N8S8279C16D1Ev,_ZThn4_N8S8279C16D1Ev)();
extern void ABISELECT(_ZThn8_N8S8279C16D0Ev,_ZThn4_N8S8279C16D0Ev)();
extern void ABISELECT(_ZThn16_N8S8279C16D1Ev,_ZThn8_N8S8279C16D1Ev)();
extern void ABISELECT(_ZThn16_N8S8279C16D0Ev,_ZThn8_N8S8279C16D0Ev)();
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZThn32_N8S8279C16D1Ev,_ZThn16_N8S8279C16D1Ev)();
extern void ABISELECT(_ZThn32_N8S8279C16D0Ev,_ZThn16_N8S8279C16D0Ev)();
extern void ABISELECT(_ZTv0_n40_N8S8279C16D1Ev,_ZTv0_n20_N8S8279C16D1Ev)();
extern void ABISELECT(_ZThn48_N8S8279C16D1Ev,_ZThn24_N8S8279C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S8279C16D0Ev,_ZTv0_n20_N8S8279C16D0Ev)();
extern void ABISELECT(_ZThn48_N8S8279C16D0Ev,_ZThn24_N8S8279C16D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S8279C16D1Ev,_ZTv0_n28_N8S8279C16D1Ev)();
extern void ABISELECT(_ZThn64_N8S8279C16D1Ev,_ZThn32_N8S8279C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S8279C16D0Ev,_ZTv0_n28_N8S8279C16D0Ev)();
extern void ABISELECT(_ZThn64_N8S8279C16D0Ev,_ZThn32_N8S8279C16D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S8279C16D1Ev,_ZTv0_n16_N8S8279C16D1Ev)();
extern void ABISELECT(_ZThn80_N8S8279C16D1Ev,_ZThn40_N8S8279C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S8279C16D0Ev,_ZTv0_n16_N8S8279C16D0Ev)();
extern void ABISELECT(_ZThn80_N8S8279C16D0Ev,_ZThn40_N8S8279C16D0Ev)() __attribute__((weak));
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTv0_n24_N8S8279C16D1Ev,_ZTv0_n12_N8S8279C16D1Ev)();
extern void ABISELECT(_ZThn104_N8S8279C16D1Ev,_ZThn52_N8S8279C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S8279C16D0Ev,_ZTv0_n12_N8S8279C16D0Ev)();
extern void ABISELECT(_ZThn104_N8S8279C16D0Ev,_ZThn52_N8S8279C16D0Ev)() __attribute__((weak));
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTv0_n72_N8S8279C16D1Ev,_ZTv0_n36_N8S8279C16D1Ev)();
extern void ABISELECT(_ZThn112_N8S8279C16D1Ev,_ZThn56_N8S8279C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S8279C16D0Ev,_ZTv0_n36_N8S8279C16D0Ev)();
extern void ABISELECT(_ZThn112_N8S8279C16D0Ev,_ZThn56_N8S8279C16D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn8_n72_N8S8279C16D1Ev,_ZTvn4_n36_N8S8279C16D1Ev)();
extern void ABISELECT(_ZTvn8_n72_N8S8279C16D0Ev,_ZTvn4_n36_N8S8279C16D0Ev)();
extern void ABISELECT(_ZTvn24_n72_N8S8279C16D1Ev,_ZTvn12_n36_N8S8279C16D1Ev)();
extern void ABISELECT(_ZTvn24_n72_N8S8279C16D0Ev,_ZTvn12_n36_N8S8279C16D0Ev)();
extern void ABISELECT(_ZTvn32_n72_N8S8279C16D1Ev,_ZTvn16_n36_N8S8279C16D1Ev)();
extern void ABISELECT(_ZTvn32_n72_N8S8279C16D0Ev,_ZTvn16_n36_N8S8279C16D0Ev)();
extern void ABISELECT(_ZTvn40_n72_N8S8279C16D1Ev,_ZTvn20_n36_N8S8279C16D1Ev)();
extern void ABISELECT(_ZTvn40_n72_N8S8279C16D0Ev,_ZTvn20_n36_N8S8279C16D0Ev)();
extern void ABISELECT(_ZTv0_n48_N8S8279C16D1Ev,_ZTv0_n24_N8S8279C16D1Ev)();
extern void ABISELECT(_ZThn176_N8S8279C16D1Ev,_ZThn92_N8S8279C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S8279C16D0Ev,_ZTv0_n24_N8S8279C16D0Ev)();
extern void ABISELECT(_ZThn176_N8S8279C16D0Ev,_ZThn92_N8S8279C16D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn8_n48_N8S8279C16D1Ev,_ZTvn4_n24_N8S8279C16D1Ev)();
extern void ABISELECT(_ZTvn8_n48_N8S8279C16D0Ev,_ZTvn4_n24_N8S8279C16D0Ev)();
static  VTBL_ENTRY vtc_S8279C16[] = {
  ABISELECT(176,92),
  ABISELECT(48,24),
  ABISELECT(112,56),
  ABISELECT(104,52),
  ABISELECT(80,40),
  ABISELECT(64,32),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&_ZN8S8279C16D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C16D0Ev,
  ABISELECT(72,36),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C16D1Ev,_ZThn4_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C16D0Ev,_ZThn4_N8S8279C16D0Ev),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S8279C16D1Ev,_ZThn8_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S8279C16D0Ev,_ZThn8_N8S8279C16D0Ev),
  ABISELECT(48,24),
  ABISELECT(-32,-16),
  ABISELECT(144,76),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S8279C16D1Ev,_ZThn16_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S8279C16D0Ev,_ZThn16_N8S8279C16D0Ev),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C16D1Ev,_ZTv0_n20_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C16D0Ev,_ZTv0_n20_N8S8279C16D0Ev),
  ABISELECT(-64,-32),
  ABISELECT(40,20),
  ABISELECT(16,8),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S8279C16D1Ev,_ZTv0_n28_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S8279C16D0Ev,_ZTv0_n28_N8S8279C16D0Ev),
  ABISELECT(8,4),
  ABISELECT(-80,-40),
  ABISELECT(-80,-40),
  ABISELECT(-80,-40),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C16D1Ev,_ZTv0_n16_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C16D0Ev,_ZTv0_n16_N8S8279C16D0Ev),
  ABISELECT(-88,-44),
  ABISELECT(-88,-44),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  ABISELECT(-104,-52),
  ABISELECT(-104,-52),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C16D1Ev,_ZTv0_n12_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C16D0Ev,_ZTv0_n12_N8S8279C16D0Ev),
  ABISELECT(-112,-56),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-32,-16),
  ABISELECT(-112,-56),
  ABISELECT(-64,-32),
  ABISELECT(-112,-56),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S8279C16D1Ev,_ZTv0_n36_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S8279C16D0Ev,_ZTv0_n36_N8S8279C16D0Ev),
  ABISELECT(-16,-8),
  ABISELECT(-40,-20),
  ABISELECT(-120,-60),
  ABISELECT(-120,-60),
  ABISELECT(-120,-60),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n72_N8S8279C16D1Ev,_ZTvn4_n36_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n72_N8S8279C16D0Ev,_ZTvn4_n36_N8S8279C16D0Ev),
  ABISELECT(-136,-68),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn24_n72_N8S8279C16D1Ev,_ZTvn12_n36_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn24_n72_N8S8279C16D0Ev,_ZTvn12_n36_N8S8279C16D0Ev),
  ABISELECT(-64,-32),
  ABISELECT(-144,-72),
  ABISELECT(-144,-72),
  ABISELECT(-144,-72),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n72_N8S8279C16D1Ev,_ZTvn16_n36_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n72_N8S8279C16D0Ev,_ZTvn16_n36_N8S8279C16D0Ev),
  ABISELECT(-152,-76),
  ABISELECT(-152,-76),
  ABISELECT(-152,-76),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn40_n72_N8S8279C16D1Ev,_ZTvn20_n36_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn40_n72_N8S8279C16D0Ev,_ZTvn20_n36_N8S8279C16D0Ev),
  ABISELECT(-176,-92),
  ABISELECT(-96,-52),
  ABISELECT(-176,-92),
  ABISELECT(-176,-92),
  ABISELECT(-176,-92),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C16D1Ev,_ZTv0_n24_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C16D0Ev,_ZTv0_n24_N8S8279C16D0Ev),
  ABISELECT(-184,-96),
  ABISELECT(-184,-96),
  ABISELECT(-184,-96),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S8279C16D1Ev,_ZTvn4_n24_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S8279C16D0Ev,_ZTvn4_n24_N8S8279C16D0Ev),
};
extern VTBL_ENTRY _ZTV8S8279C16[];
extern void _ZN7S8279C52v1Ev();
extern void _ZN8S8279C13D1Ev();
extern void _ZN8S8279C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C13__8S8279C16[] = {
  ABISELECT(48,24),
  ABISELECT(112,56),
  ABISELECT(104,52),
  ABISELECT(80,40),
  ABISELECT(64,32),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&_ZN8S8279C13D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C13D0Ev,
};
extern void ABISELECT(_ZTv0_n56_N8S8279C13D1Ev,_ZTv0_n28_N8S8279C13D1Ev)();
extern void ABISELECT(_ZThn64_N8S8279C13D1Ev,_ZThn32_N8S8279C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S8279C13D0Ev,_ZTv0_n28_N8S8279C13D0Ev)();
extern void ABISELECT(_ZThn64_N8S8279C13D0Ev,_ZThn32_N8S8279C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S8279C3__8S8279C13__8S8279C16[] = {
  ABISELECT(-64,-32),
  ABISELECT(40,20),
  ABISELECT(16,8),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S8279C13D1Ev,_ZTv0_n28_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S8279C13D0Ev,_ZTv0_n28_N8S8279C13D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S8279C13D1Ev,_ZTv0_n16_N8S8279C13D1Ev)();
extern void ABISELECT(_ZThn80_N8S8279C13D1Ev,_ZThn40_N8S8279C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S8279C13D0Ev,_ZTv0_n16_N8S8279C13D0Ev)();
extern void ABISELECT(_ZThn80_N8S8279C13D0Ev,_ZThn40_N8S8279C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C13__8S8279C16[] = {
  ABISELECT(8,4),
  ABISELECT(-80,-40),
  ABISELECT(-80,-40),
  ABISELECT(-80,-40),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C13D1Ev,_ZTv0_n16_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C13D0Ev,_ZTv0_n16_N8S8279C13D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C13__8S8279C16[] = {
  ABISELECT(-88,-44),
  ABISELECT(-88,-44),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S8279C13D1Ev,_ZTv0_n12_N8S8279C13D1Ev)();
extern void ABISELECT(_ZThn104_N8S8279C13D1Ev,_ZThn52_N8S8279C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S8279C13D0Ev,_ZTv0_n12_N8S8279C13D0Ev)();
extern void ABISELECT(_ZThn104_N8S8279C13D0Ev,_ZThn52_N8S8279C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S814C5_nt__A1__8S8279C13__8S8279C16[] = {
  ABISELECT(-104,-52),
  ABISELECT(-104,-52),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C13D1Ev,_ZTv0_n12_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C13D0Ev,_ZTv0_n12_N8S8279C13D0Ev),
};
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTv0_n72_N8S8279C13D1Ev,_ZTv0_n36_N8S8279C13D1Ev)();
extern void ABISELECT(_ZThn112_N8S8279C13D1Ev,_ZThn56_N8S8279C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S8279C13D0Ev,_ZTv0_n36_N8S8279C13D0Ev)();
extern void ABISELECT(_ZThn112_N8S8279C13D0Ev,_ZThn56_N8S8279C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S8279C14__8S8279C13__8S8279C16[] = {
  ABISELECT(-112,-56),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-32,-16),
  ABISELECT(-112,-56),
  ABISELECT(-64,-32),
  ABISELECT(-112,-56),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S8279C13D1Ev,_ZTv0_n36_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S8279C13D0Ev,_ZTv0_n36_N8S8279C13D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N8S8279C13D1Ev,_ZTv0_n20_N8S8279C13D1Ev)();
extern void ABISELECT(_ZThn48_N8S8279C13D1Ev,_ZThn24_N8S8279C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S8279C13D0Ev,_ZTv0_n20_N8S8279C13D0Ev)();
extern void ABISELECT(_ZThn48_N8S8279C13D0Ev,_ZThn24_N8S8279C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S8279C8__A1__8S8279C13__8S8279C16[] = {
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C13D1Ev,_ZTv0_n20_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C13D0Ev,_ZTv0_n20_N8S8279C13D0Ev),
};
extern void ABISELECT(_ZTvn8_n72_N8S8279C13D1Ev,_ZTvn4_n36_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTvn8_n72_N8S8279C13D0Ev,_ZTvn4_n36_N8S8279C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C38S8279C14__A1__8S8279C13__8S8279C16[] = {
  ABISELECT(-16,-8),
  ABISELECT(-40,-20),
  ABISELECT(-120,-60),
  ABISELECT(-120,-60),
  ABISELECT(-120,-60),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n72_N8S8279C13D1Ev,_ZTvn4_n36_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n72_N8S8279C13D0Ev,_ZTvn4_n36_N8S8279C13D0Ev),
};
extern void ABISELECT(_ZTvn24_n72_N8S8279C13D1Ev,_ZTvn12_n36_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTvn24_n72_N8S8279C13D0Ev,_ZTvn12_n36_N8S8279C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S814C5_nt8S8279C14__A5__8S8279C13__8S8279C16[] = {
  ABISELECT(-136,-68),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn24_n72_N8S8279C13D1Ev,_ZTvn12_n36_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn24_n72_N8S8279C13D0Ev,_ZTvn12_n36_N8S8279C13D0Ev),
};
extern void ABISELECT(_ZTvn32_n72_N8S8279C13D1Ev,_ZTvn16_n36_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTvn32_n72_N8S8279C13D0Ev,_ZTvn16_n36_N8S8279C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S8279C158S8279C14__8S8279C13__8S8279C16[] = {
  ABISELECT(-64,-32),
  ABISELECT(-144,-72),
  ABISELECT(-144,-72),
  ABISELECT(-144,-72),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n72_N8S8279C13D1Ev,_ZTvn16_n36_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n72_N8S8279C13D0Ev,_ZTvn16_n36_N8S8279C13D0Ev),
};
extern void ABISELECT(_ZTvn40_n72_N8S8279C13D1Ev,_ZTvn20_n36_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTvn40_n72_N8S8279C13D0Ev,_ZTvn20_n36_N8S8279C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C158S8279C14__A3__8S8279C13__8S8279C16[] = {
  ABISELECT(-152,-76),
  ABISELECT(-152,-76),
  ABISELECT(-152,-76),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn40_n72_N8S8279C13D1Ev,_ZTvn20_n36_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn40_n72_N8S8279C13D0Ev,_ZTvn20_n36_N8S8279C13D0Ev),
};
extern void _ZN8S8279C15D1Ev();
extern void _ZN8S8279C15D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C15__A__8S8279C16[] = {
  ABISELECT(72,36),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN8S8279C15D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C15D0Ev,
};
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C15__A4__8S8279C16[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C88S8279C15__A4__8S8279C16[] = {
  0,
  0,
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C15__A__8S8279C16[] = {
  0,
  0,
  ABISELECT(8,4),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev)();
extern void ABISELECT(_ZThn72_N8S8279C15D1Ev,_ZThn36_N8S8279C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev)();
extern void ABISELECT(_ZThn72_N8S8279C15D0Ev,_ZThn36_N8S8279C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C15__A__8S8279C16[] = {
  ABISELECT(8,4),
  ABISELECT(-72,-36),
  ABISELECT(-80,-40),
  ABISELECT(-72,-36),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C15__A__8S8279C16[] = {
  ABISELECT(-88,-44),
  ABISELECT(-80,-40),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZThn8_N8S8279C15D1Ev,_ZThn4_N8S8279C15D1Ev)();
extern void ABISELECT(_ZThn8_N8S8279C15D0Ev,_ZThn4_N8S8279C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C8__8S8279C15__A__8S8279C16[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C15D1Ev,_ZThn4_N8S8279C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C15D0Ev,_ZThn4_N8S8279C15D0Ev),
};
extern void _ZN7S8279C52v1Ev();
extern void _ZN8S8279C17D1Ev();
extern void _ZN8S8279C17D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C17__8S8279C16[] = {
  ABISELECT(48,24),
  ABISELECT(-32,-16),
  ABISELECT(144,76),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&_ZN8S8279C17D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C17D0Ev,
};
extern void ABISELECT(_ZTv0_n48_N8S8279C17D1Ev,_ZTv0_n24_N8S8279C17D1Ev)();
extern void ABISELECT(_ZThn144_N8S8279C17D1Ev,_ZThn76_N8S8279C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S8279C17D0Ev,_ZTv0_n24_N8S8279C17D0Ev)();
extern void ABISELECT(_ZThn144_N8S8279C17D0Ev,_ZThn76_N8S8279C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S8279C15__8S8279C17__8S8279C16[] = {
  ABISELECT(-144,-76),
  ABISELECT(-96,-52),
  ABISELECT(-176,-92),
  ABISELECT(-176,-92),
  ABISELECT(-144,-76),
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C17D1Ev,_ZTv0_n24_N8S8279C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C17D0Ev,_ZTv0_n24_N8S8279C17D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C17__8S8279C16[] = {
  0,
  0,
  ABISELECT(32,16),
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S8279C17D1Ev,_ZTv0_n16_N8S8279C17D1Ev)();
extern void ABISELECT(_ZThn48_N8S8279C17D1Ev,_ZThn24_N8S8279C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S8279C17D0Ev,_ZTv0_n16_N8S8279C17D0Ev)();
extern void ABISELECT(_ZThn48_N8S8279C17D0Ev,_ZThn24_N8S8279C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C17__8S8279C16[] = {
  ABISELECT(8,4),
  ABISELECT(-48,-24),
  ABISELECT(-80,-40),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C17D1Ev,_ZTv0_n16_N8S8279C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C17D0Ev,_ZTv0_n16_N8S8279C17D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C17__8S8279C16[] = {
  ABISELECT(-88,-44),
  ABISELECT(-56,-28),
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTvn8_n48_N8S8279C17D1Ev,_ZTvn4_n24_N8S8279C17D1Ev)();
extern void ABISELECT(_ZTvn8_n48_N8S8279C17D0Ev,_ZTvn4_n24_N8S8279C17D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C15__8S8279C17__8S8279C16[] = {
  ABISELECT(-184,-96),
  ABISELECT(-184,-96),
  ABISELECT(-152,-80),
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S8279C17D1Ev,_ZTvn4_n24_N8S8279C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S8279C17D0Ev,_ZTvn4_n24_N8S8279C17D0Ev),
};
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C8__8S8279C16[] = {
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C8__8S8279C16[] = {
  0,
  0,
  ABISELECT(48,24),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C16[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C3D1Ev();
extern void _ZN7S8279C3D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C3__8S8279C16[] = {
  ABISELECT(40,20),
  ABISELECT(16,8),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&_ZN7S8279C3D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C3D0Ev,
};
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C87S8279C3__A1__8S8279C16[] = {
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C87S8279C3__A1__8S8279C16[] = {
  0,
  0,
  ABISELECT(64,32),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C3__8S8279C16[] = {
  0,
  0,
  ABISELECT(64,32),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N7S8279C3D1Ev,_ZTv0_n16_N7S8279C3D1Ev)();
extern void ABISELECT(_ZThn16_N7S8279C3D1Ev,_ZThn8_N7S8279C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S8279C3D0Ev,_ZTv0_n16_N7S8279C3D0Ev)();
extern void ABISELECT(_ZThn16_N7S8279C3D0Ev,_ZThn8_N7S8279C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S8279C6__7S8279C3__8S8279C16[] = {
  ABISELECT(8,4),
  ABISELECT(-16,-8),
  ABISELECT(-80,-40),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S8279C3D1Ev,_ZTv0_n16_N7S8279C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S8279C3D0Ev,_ZTv0_n16_N7S8279C3D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__7S8279C3__8S8279C16[] = {
  ABISELECT(-88,-44),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S8279C3D1Ev,_ZTv0_n12_N7S8279C3D1Ev)();
extern void ABISELECT(_ZThn40_N7S8279C3D1Ev,_ZThn20_N7S8279C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S8279C3D0Ev,_ZTv0_n12_N7S8279C3D0Ev)();
extern void ABISELECT(_ZThn40_N7S8279C3D0Ev,_ZThn20_N7S8279C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S814C5_nt__A1__7S8279C3__8S8279C16[] = {
  ABISELECT(-40,-20),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S8279C3D1Ev,_ZTv0_n12_N7S8279C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S8279C3D0Ev,_ZTv0_n12_N7S8279C3D0Ev),
};
extern void _ZN7S8279C6D1Ev();
extern void _ZN7S8279C6D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C16[] = {
  ABISELECT(-80,-40),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C6[0]),
  (VTBL_ENTRY)&_ZN7S8279C6D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C6D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C16[] = {
  ABISELECT(-88,-44),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C6__8S8279C16[] = {
  ABISELECT(-88,-44),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S8279C6[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
extern void _ZN8S8279C14D1Ev();
extern void _ZN8S8279C14D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C14__8S8279C16[] = {
  ABISELECT(-8,-4),
  ABISELECT(-32,-16),
  ABISELECT(-112,-56),
  ABISELECT(-64,-32),
  ABISELECT(-112,-56),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&_ZN8S8279C14D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C14D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C58S8279C14__A2__8S8279C16[] = {
  ABISELECT(-112,-56),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C3D1Ev();
extern void _ZN7S8279C3D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C38S8279C14__A1__8S8279C16[] = {
  ABISELECT(-16,-8),
  ABISELECT(-40,-20),
  ABISELECT(-120,-60),
  ABISELECT(-120,-60),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&_ZN7S8279C3D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C3D0Ev,
};
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C87S8279C38S8279C14__A2__8S8279C16[] = {
  ABISELECT(-120,-60),
  ABISELECT(-120,-60),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C87S8279C38S8279C14__A2__8S8279C16[] = {
  0,
  0,
  ABISELECT(120,60),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C38S8279C14__A1__8S8279C16[] = {
  0,
  0,
  ABISELECT(120,60),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N7S8279C3D1Ev,_ZTv0_n16_N7S8279C3D1Ev)();
extern void ABISELECT(_ZTv0_n32_N7S8279C3D0Ev,_ZTv0_n16_N7S8279C3D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C6__7S8279C38S8279C14__A1__8S8279C16[] = {
  ABISELECT(8,4),
  ABISELECT(40,20),
  ABISELECT(-80,-40),
  ABISELECT(40,20),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S8279C3D1Ev,_ZTv0_n16_N7S8279C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S8279C3D0Ev,_ZTv0_n16_N7S8279C3D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__7S8279C38S8279C14__A1__8S8279C16[] = {
  ABISELECT(-88,-44),
  ABISELECT(32,16),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S8279C3D1Ev,_ZTv0_n12_N7S8279C3D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S8279C3D0Ev,_ZTv0_n12_N7S8279C3D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S814C5_nt__A1__7S8279C38S8279C14__A1__8S8279C16[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S8279C3D1Ev,_ZTv0_n12_N7S8279C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S8279C3D0Ev,_ZTv0_n12_N7S8279C3D0Ev),
};
extern void _ZN8S8279C15D1Ev();
extern void _ZN8S8279C15D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C158S8279C14__8S8279C16[] = {
  ABISELECT(-64,-32),
  ABISELECT(-144,-72),
  ABISELECT(-144,-72),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN8S8279C15D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C15D0Ev,
};
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C158S8279C14__A3__8S8279C16[] = {
  ABISELECT(-152,-76),
  ABISELECT(-152,-76),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C88S8279C158S8279C14__A3__8S8279C16[] = {
  0,
  0,
  ABISELECT(152,76),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C158S8279C14__8S8279C16[] = {
  0,
  0,
  ABISELECT(144,72),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev)();
extern void ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C158S8279C14__8S8279C16[] = {
  ABISELECT(8,4),
  ABISELECT(64,32),
  ABISELECT(-80,-40),
  ABISELECT(64,32),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C158S8279C14__8S8279C16[] = {
  ABISELECT(-88,-44),
  ABISELECT(56,28),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZThn8_N8S8279C15D1Ev,_ZThn4_N8S8279C15D1Ev)();
extern void ABISELECT(_ZThn8_N8S8279C15D0Ev,_ZThn4_N8S8279C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C8__8S8279C158S8279C14__8S8279C16[] = {
  ABISELECT(-152,-76),
  ABISELECT(-152,-76),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C15D1Ev,_ZThn4_N8S8279C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C15D0Ev,_ZThn4_N8S8279C15D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N8S8279C14D1Ev,_ZTv0_n20_N8S8279C14D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S8279C14D0Ev,_ZTv0_n20_N8S8279C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C8__8S8279C14__8S8279C16[] = {
  ABISELECT(64,32),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(64,32),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C14D1Ev,_ZTv0_n20_N8S8279C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C14D0Ev,_ZTv0_n20_N8S8279C14D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C14__8S8279C16[] = {
  0,
  0,
  ABISELECT(112,56),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZThn8_N8S8279C14D1Ev,_ZThn4_N8S8279C14D1Ev)();
extern void ABISELECT(_ZThn8_N8S8279C14D0Ev,_ZThn4_N8S8279C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C3__8S8279C14__8S8279C16[] = {
  ABISELECT(-16,-8),
  ABISELECT(-40,-20),
  ABISELECT(-120,-60),
  ABISELECT(-120,-60),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C14D1Ev,_ZThn4_N8S8279C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C14D0Ev,_ZThn4_N8S8279C14D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S8279C14D1Ev,_ZTv0_n16_N8S8279C14D1Ev)();
extern void ABISELECT(_ZTv0_n32_N8S8279C14D0Ev,_ZTv0_n16_N8S8279C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C14__8S8279C16[] = {
  ABISELECT(8,4),
  ABISELECT(32,16),
  ABISELECT(-80,-40),
  ABISELECT(32,16),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C14D1Ev,_ZTv0_n16_N8S8279C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C14D0Ev,_ZTv0_n16_N8S8279C14D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A2__8S8279C14__8S8279C16[] = {
  ABISELECT(-88,-44),
  ABISELECT(24,12),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S8279C14D1Ev,_ZTv0_n12_N8S8279C14D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S8279C14D0Ev,_ZTv0_n12_N8S8279C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S814C5_nt__A2__8S8279C14__8S8279C16[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C14D1Ev,_ZTv0_n12_N8S8279C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C14D0Ev,_ZTv0_n12_N8S8279C14D0Ev),
};
extern void ABISELECT(_ZThn32_N8S8279C14D1Ev,_ZThn16_N8S8279C14D1Ev)();
extern void ABISELECT(_ZThn32_N8S8279C14D0Ev,_ZThn16_N8S8279C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S8279C15__8S8279C14__8S8279C16[] = {
  ABISELECT(-64,-32),
  ABISELECT(-144,-72),
  ABISELECT(-144,-72),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S8279C14D1Ev,_ZThn16_N8S8279C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S8279C14D0Ev,_ZThn16_N8S8279C14D0Ev),
};
extern void ABISELECT(_ZThn40_N8S8279C14D1Ev,_ZThn20_N8S8279C14D1Ev)();
extern void ABISELECT(_ZThn40_N8S8279C14D0Ev,_ZThn20_N8S8279C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C15__A2__8S8279C14__8S8279C16[] = {
  ABISELECT(-152,-76),
  ABISELECT(-152,-76),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N8S8279C14D1Ev,_ZThn20_N8S8279C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N8S8279C14D0Ev,_ZThn20_N8S8279C14D0Ev),
};
extern void _ZN8S8279C15D1Ev();
extern void _ZN8S8279C15D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C15__A2__8S8279C16[] = {
  ABISELECT(-96,-52),
  ABISELECT(-176,-92),
  ABISELECT(-176,-92),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN8S8279C15D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C15D0Ev,
};
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C15__A5__8S8279C16[] = {
  ABISELECT(-184,-96),
  ABISELECT(-184,-96),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C88S8279C15__A5__8S8279C16[] = {
  0,
  0,
  ABISELECT(184,96),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C15__A2__8S8279C16[] = {
  0,
  0,
  ABISELECT(176,92),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev)();
extern void ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C15__A2__8S8279C16[] = {
  ABISELECT(8,4),
  ABISELECT(96,52),
  ABISELECT(-80,-40),
  ABISELECT(96,52),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C15__A2__8S8279C16[] = {
  ABISELECT(-88,-44),
  ABISELECT(88,48),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZThn8_N8S8279C15D1Ev,_ZThn4_N8S8279C15D1Ev)();
extern void ABISELECT(_ZThn8_N8S8279C15D0Ev,_ZThn4_N8S8279C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C8__8S8279C15__A2__8S8279C16[] = {
  ABISELECT(-184,-96),
  ABISELECT(-184,-96),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C15D1Ev,_ZThn4_N8S8279C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C15D0Ev,_ZThn4_N8S8279C15D0Ev),
};
static  VTT_ENTRY vtt_S8279C16[] = {
  {&(_ZTV8S8279C16[11]),  11,120},
  {&(_tg__ZTV8S8279C13__8S8279C16[10]),  10,13},
  {&(_tg__ZTV8S8279C13__8S8279C16[10]),  10,13},
  {&(_tg__ZTV7S8279C3__8S8279C13__8S8279C16[7]),  7,9},
  {&(_tg__ZTV7S8279C6__8S8279C13__8S8279C16[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C13__8S8279C16[3]),  3,4},
  {&(_tg__ZTV9S814C5_nt__A1__8S8279C13__8S8279C16[3]),  3,5},
  {&(_tg__ZTV8S8279C14__8S8279C13__8S8279C16[9]),  9,12},
  {&(_tg__ZTV7S8279C8__A1__8S8279C13__8S8279C16[5]),  5,7},
  {&(_tg__ZTV7S8279C38S8279C14__A1__8S8279C13__8S8279C16[6]),  6,8},
  {&(_tg__ZTV9S814C5_nt8S8279C14__A5__8S8279C13__8S8279C16[2]),  2,4},
  {&(_tg__ZTV8S8279C158S8279C14__8S8279C13__8S8279C16[5]),  5,7},
  {&(_tg__ZTV7S8279C88S8279C158S8279C14__A3__8S8279C13__8S8279C16[4]),  4,6},
  {&(_tg__ZTV8S8279C15__A__8S8279C16[5]),  5,7},
  {&(_tg__ZTV7S8279C88S8279C15__A4__8S8279C16[4]),  4,6},
  {&(_tg__ZTV7S8279C5__7S8279C88S8279C15__A4__8S8279C16[4]),  4,5},
  {&(_tg__ZTV7S8279C5__8S8279C15__A__8S8279C16[4]),  4,5},
  {&(_tg__ZTV7S8279C6__8S8279C15__A__8S8279C16[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C15__A__8S8279C16[3]),  3,4},
  {&(_tg__ZTV7S8279C8__8S8279C15__A__8S8279C16[4]),  4,6},
  {&(_tg__ZTV8S8279C17__8S8279C16[7]),  7,10},
  {&(_tg__ZTV8S8279C15__8S8279C17__8S8279C16[6]),  6,8},
  {&(_tg__ZTV7S8279C5__8S8279C17__8S8279C16[4]),  4,5},
  {&(_tg__ZTV7S8279C6__8S8279C17__8S8279C16[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C17__8S8279C16[3]),  3,4},
  {&(_tg__ZTV7S8279C88S8279C15__8S8279C17__8S8279C16[4]),  4,6},
  {&(_ZTV8S8279C16[42]),  42,120},
  {&(_ZTV8S8279C16[11]),  11,120},
  {&(_ZTV8S8279C16[51]),  51,120},
  {&(_ZTV8S8279C16[58]),  58,120},
  {&(_ZTV8S8279C16[63]),  63,120},
  {&(_ZTV8S8279C16[67]),  67,120},
  {&(_ZTV8S8279C16[78]),  78,120},
  {&(_ZTV8S8279C16[87]),  87,120},
  {&(_ZTV8S8279C16[91]),  91,120},
  {&(_ZTV8S8279C16[98]),  98,120},
  {&(_ZTV8S8279C16[104]),  104,120},
  {&(_ZTV8S8279C16[19]),  19,120},
  {&(_ZTV8S8279C16[25]),  25,120},
  {&(_ZTV8S8279C16[34]),  34,120},
  {&(_ZTV8S8279C16[112]),  112,120},
  {&(_ZTV8S8279C16[118]),  118,120},
  {&(_tg__ZTV7S8279C8__8S8279C16[4]),  4,6},
  {&(_tg__ZTV7S8279C5__7S8279C8__8S8279C16[4]),  4,5},
  {&(_tg__ZTV7S8279C5__8S8279C16[3]),  3,4},
  {&(_tg__ZTV7S8279C3__8S8279C16[6]),  6,8},
  {&(_tg__ZTV7S8279C87S8279C3__A1__8S8279C16[4]),  4,6},
  {&(_tg__ZTV7S8279C5__7S8279C87S8279C3__A1__8S8279C16[4]),  4,5},
  {&(_tg__ZTV7S8279C5__7S8279C3__8S8279C16[4]),  4,5},
  {&(_tg__ZTV7S8279C6__7S8279C3__8S8279C16[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__7S8279C3__8S8279C16[3]),  3,4},
  {&(_tg__ZTV9S814C5_nt__A1__7S8279C3__8S8279C16[3]),  3,5},
  {&(_tg__ZTV7S8279C6__8S8279C16[3]),  3,5},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C16[3]),  3,4},
  {&(_tg__ZTV7S8279C5__7S8279C6__8S8279C16[3]),  3,4},
  {&(_tg__ZTV8S8279C14__8S8279C16[7]),  7,10},
  {&(_tg__ZTV7S8279C58S8279C14__A2__8S8279C16[3]),  3,4},
  {&(_tg__ZTV7S8279C38S8279C14__A1__8S8279C16[6]),  6,8},
  {&(_tg__ZTV7S8279C87S8279C38S8279C14__A2__8S8279C16[4]),  4,6},
  {&(_tg__ZTV7S8279C5__7S8279C87S8279C38S8279C14__A2__8S8279C16[4]),  4,5},
  {&(_tg__ZTV7S8279C5__7S8279C38S8279C14__A1__8S8279C16[4]),  4,5},
  {&(_tg__ZTV7S8279C6__7S8279C38S8279C14__A1__8S8279C16[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__7S8279C38S8279C14__A1__8S8279C16[3]),  3,4},
  {&(_tg__ZTV9S814C5_nt__A1__7S8279C38S8279C14__A1__8S8279C16[3]),  3,5},
  {&(_tg__ZTV8S8279C158S8279C14__8S8279C16[5]),  5,7},
  {&(_tg__ZTV7S8279C88S8279C158S8279C14__A3__8S8279C16[4]),  4,6},
  {&(_tg__ZTV7S8279C5__7S8279C88S8279C158S8279C14__A3__8S8279C16[4]),  4,5},
  {&(_tg__ZTV7S8279C5__8S8279C158S8279C14__8S8279C16[4]),  4,5},
  {&(_tg__ZTV7S8279C6__8S8279C158S8279C14__8S8279C16[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C158S8279C14__8S8279C16[3]),  3,4},
  {&(_tg__ZTV7S8279C8__8S8279C158S8279C14__8S8279C16[4]),  4,6},
  {&(_tg__ZTV7S8279C8__8S8279C14__8S8279C16[5]),  5,7},
  {&(_tg__ZTV7S8279C5__8S8279C14__8S8279C16[4]),  4,5},
  {&(_tg__ZTV7S8279C3__8S8279C14__8S8279C16[6]),  6,8},
  {&(_tg__ZTV7S8279C6__8S8279C14__8S8279C16[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A2__8S8279C14__8S8279C16[3]),  3,4},
  {&(_tg__ZTV9S814C5_nt__A2__8S8279C14__8S8279C16[3]),  3,5},
  {&(_tg__ZTV8S8279C15__8S8279C14__8S8279C16[5]),  5,7},
  {&(_tg__ZTV7S8279C88S8279C15__A2__8S8279C14__8S8279C16[4]),  4,6},
  {&(_tg__ZTV8S8279C15__A2__8S8279C16[5]),  5,7},
  {&(_tg__ZTV7S8279C88S8279C15__A5__8S8279C16[4]),  4,6},
  {&(_tg__ZTV7S8279C5__7S8279C88S8279C15__A5__8S8279C16[4]),  4,5},
  {&(_tg__ZTV7S8279C5__8S8279C15__A2__8S8279C16[4]),  4,5},
  {&(_tg__ZTV7S8279C6__8S8279C15__A2__8S8279C16[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C15__A2__8S8279C16[3]),  3,4},
  {&(_tg__ZTV7S8279C8__8S8279C15__A2__8S8279C16[4]),  4,6},
};
extern VTBL_ENTRY _ZTI8S8279C16[];
extern  VTBL_ENTRY _ZTV8S8279C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C16[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S8279C3D0Ev,_ZTv0_n12_N7S8279C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N7S8279C3D0Ev,_ZThn20_N7S8279C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S8279C3D1Ev,_ZTv0_n12_N7S8279C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N7S8279C3D1Ev,_ZThn20_N7S8279C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S8279C3D0Ev,_ZTv0_n16_N7S8279C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7S8279C3D0Ev,_ZThn8_N7S8279C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S8279C3D1Ev,_ZTv0_n16_N7S8279C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7S8279C3D1Ev,_ZThn8_N7S8279C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C17D0Ev,_ZTv0_n16_N8S8279C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S8279C17D0Ev,_ZThn24_N8S8279C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C17D1Ev,_ZTv0_n16_N8S8279C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S8279C17D1Ev,_ZThn24_N8S8279C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S8279C17D0Ev,_ZTv0_n24_N8S8279C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn144_N8S8279C17D0Ev,_ZThn76_N8S8279C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S8279C17D1Ev,_ZTv0_n24_N8S8279C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn144_N8S8279C17D1Ev,_ZThn76_N8S8279C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N8S8279C15D0Ev,_ZThn36_N8S8279C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N8S8279C15D1Ev,_ZThn36_N8S8279C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S8279C13D0Ev,_ZTv0_n20_N8S8279C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S8279C13D0Ev,_ZThn24_N8S8279C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S8279C13D1Ev,_ZTv0_n20_N8S8279C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S8279C13D1Ev,_ZThn24_N8S8279C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S8279C13D0Ev,_ZTv0_n36_N8S8279C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N8S8279C13D0Ev,_ZThn56_N8S8279C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S8279C13D1Ev,_ZTv0_n36_N8S8279C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N8S8279C13D1Ev,_ZThn56_N8S8279C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S8279C13D0Ev,_ZTv0_n12_N8S8279C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N8S8279C13D0Ev,_ZThn52_N8S8279C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S8279C13D1Ev,_ZTv0_n12_N8S8279C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N8S8279C13D1Ev,_ZThn52_N8S8279C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C13D0Ev,_ZTv0_n16_N8S8279C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N8S8279C13D0Ev,_ZThn40_N8S8279C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C13D1Ev,_ZTv0_n16_N8S8279C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N8S8279C13D1Ev,_ZThn40_N8S8279C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S8279C13D0Ev,_ZTv0_n28_N8S8279C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N8S8279C13D0Ev,_ZThn32_N8S8279C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S8279C13D1Ev,_ZTv0_n28_N8S8279C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N8S8279C13D1Ev,_ZThn32_N8S8279C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S8279C16D0Ev,_ZTv0_n24_N8S8279C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S8279C16D0Ev,_ZThn92_N8S8279C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S8279C16D1Ev,_ZTv0_n24_N8S8279C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S8279C16D1Ev,_ZThn92_N8S8279C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S8279C16D0Ev,_ZTv0_n36_N8S8279C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N8S8279C16D0Ev,_ZThn56_N8S8279C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S8279C16D1Ev,_ZTv0_n36_N8S8279C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N8S8279C16D1Ev,_ZThn56_N8S8279C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S8279C16D0Ev,_ZTv0_n12_N8S8279C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N8S8279C16D0Ev,_ZThn52_N8S8279C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S8279C16D1Ev,_ZTv0_n12_N8S8279C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N8S8279C16D1Ev,_ZThn52_N8S8279C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C16D0Ev,_ZTv0_n16_N8S8279C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N8S8279C16D0Ev,_ZThn40_N8S8279C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C16D1Ev,_ZTv0_n16_N8S8279C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N8S8279C16D1Ev,_ZThn40_N8S8279C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S8279C16D0Ev,_ZTv0_n28_N8S8279C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N8S8279C16D0Ev,_ZThn32_N8S8279C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S8279C16D1Ev,_ZTv0_n28_N8S8279C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N8S8279C16D1Ev,_ZThn32_N8S8279C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S8279C16D0Ev,_ZTv0_n20_N8S8279C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S8279C16D0Ev,_ZThn24_N8S8279C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S8279C16D1Ev,_ZTv0_n20_N8S8279C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S8279C16D1Ev,_ZThn24_N8S8279C16D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S8279C16 = {  "S8279C16", // class name
  bases_S8279C16, 31,
  &(vtc_S8279C16[0]), // expected_vtbl_contents
  &(vtt_S8279C16[0]), // expected_vtt_contents
  ABISELECT(200,104), // object size
  NSPAIRA(_ZTI8S8279C16),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S8279C16),120, //virtual function table var
  11, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S8279C16),86, //virtual table table var
  30, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8279C20  : S8279C5 {
  void *s8279c20f0;
  ~S8279C20(); // tgen
  S8279C20(); // tgen
};
//SIG(-1 S8279C20) C1{ BC2{ VBC3{ m} v1} Fp}


S8279C20 ::~S8279C20(){ note_dtor("S8279C20", this);} // tgen
S8279C20 ::S8279C20(){ note_ctor("S8279C20", this);} // tgen

static void Test_S8279C20()
{
  extern Class_Descriptor cd_S8279C20;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S8279C20, buf);
    S8279C20 *dp, &lv = *(dp=new (buf) S8279C20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S8279C20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8279C20)");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C5*), 0, "S8279C20");
    check_base_class_offset(lv, (S8279C5*), 0, "S8279C20");
    check_field_offset(lv, s8279c20f0, ABISELECT(8,4), "S8279C20.s8279c20f0");
    test_class_info(&lv, &cd_S8279C20);
    dp->~S8279C20();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8279C20(Test_S8279C20, "S8279C20", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN8S8279C20C1Ev();
extern void _ZN8S8279C20D1Ev();
Name_Map name_map_S8279C20[] = {
  NSPAIR(_ZN8S8279C20C1Ev),
  NSPAIR(_ZN8S8279C20D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S694C11_nt;
extern VTBL_ENTRY _ZTI10S694C11_nt[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
static Base_Class bases_S8279C20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S694C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S8279C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S8279C20[];
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY vtc_S8279C20[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C20[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern VTBL_ENTRY _ZTV8S8279C20[];
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C20[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
static  VTT_ENTRY vtt_S8279C20[] = {
  {&(_ZTV8S8279C20[3]),  3,4},
  {&(_tg__ZTV7S8279C5__8S8279C20[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8S8279C20[];
extern  VTBL_ENTRY _ZTV8S8279C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C20[];
Class_Descriptor cd_S8279C20 = {  "S8279C20", // class name
  bases_S8279C20, 2,
  &(vtc_S8279C20[0]), // expected_vtbl_contents
  &(vtt_S8279C20[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI8S8279C20),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S8279C20),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S8279C20),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8279C19  : virtual S8279C20 {
  ~S8279C19(); // tgen
  S8279C19(); // tgen
};
//SIG(-1 S8279C19) C1{ VBC2{ BC3{ VBC4{ m} v1} Fp}}


S8279C19 ::~S8279C19(){ note_dtor("S8279C19", this);} // tgen
S8279C19 ::S8279C19(){ note_ctor("S8279C19", this);} // tgen

static void Test_S8279C19()
{
  extern Class_Descriptor cd_S8279C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S8279C19, buf);
    S8279C19 *dp, &lv = *(dp=new (buf) S8279C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S8279C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8279C19)");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C5*)(S8279C20*), 0, "S8279C19");
    check_base_class_offset(lv, (S8279C5*)(S8279C20*), ABISELECT(8,4), "S8279C19");
    check_base_class_offset(lv, (S8279C20*), ABISELECT(8,4), "S8279C19");
    test_class_info(&lv, &cd_S8279C19);
    dp->~S8279C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8279C19(Test_S8279C19, "S8279C19", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN8S8279C19C1Ev();
extern void _ZN8S8279C19D1Ev();
Name_Map name_map_S8279C19[] = {
  NSPAIR(_ZN8S8279C19C1Ev),
  NSPAIR(_ZN8S8279C19D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S694C11_nt;
extern VTBL_ENTRY _ZTI10S694C11_nt[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S8279C20;
extern VTBL_ENTRY _ZTI8S8279C20[];
extern  VTBL_ENTRY _ZTV8S8279C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C20[];
static Base_Class bases_S8279C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S694C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S8279C5,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S8279C20,    ABISELECT(8,4), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S8279C19[];
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY vtc_S8279C19[] = {
  0,
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C19[0]),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C19[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern VTBL_ENTRY _ZTV8S8279C19[];
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C20__8S8279C19[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C20[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C58S8279C20__8S8279C19[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
static  VTT_ENTRY vtt_S8279C19[] = {
  {&(_ZTV8S8279C19[4]),  4,9},
  {&(_ZTV8S8279C19[8]),  8,9},
  {&(_tg__ZTV8S8279C20__8S8279C19[3]),  3,4},
  {&(_tg__ZTV7S8279C58S8279C20__8S8279C19[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8S8279C19[];
extern  VTBL_ENTRY _ZTV8S8279C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C19[];
Class_Descriptor cd_S8279C19 = {  "S8279C19", // class name
  bases_S8279C19, 3,
  &(vtc_S8279C19[0]), // expected_vtbl_contents
  &(vtt_S8279C19[0]), // expected_vtt_contents
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI8S8279C19),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S8279C19),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S8279C19),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8279C21_nt  {
  void  mf8279c21(); // _ZN11S8279C21_nt9mf8279c21Ev
};
//SIG(-1 S8279C21_nt) C1{ m}


void  S8279C21_nt ::mf8279c21(){}

//skip512 S8279C21_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI11S8279C21_nt[];
VTBL_ENTRY *P__ZTI11S8279C21_nt = _ZTI11S8279C21_nt; 
Class_Descriptor cd_S8279C21_nt = {  "S8279C21_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI11S8279C21_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8279C18  : virtual S8279C19 , S8279C6 {
  int s8279c18f0:32;
  ::S8279C21_nt s8279c18f1;
  virtual  ~S8279C18(); // _ZN8S8279C18D2Ev
  S8279C18(); // tgen
};
//SIG(-1 S8279C18) C1{ VBC2{ VBC3{ BC4{ VBC5{ m} v1} Fp}} BC6{ BC7{ vd m} BC4 vd FC8{}} vd Fi:32 FC9{ m}}


 S8279C18 ::~S8279C18(){ note_dtor("S8279C18", this);}
S8279C18 ::S8279C18(){ note_ctor("S8279C18", this);} // tgen

static void Test_S8279C18()
{
  extern Class_Descriptor cd_S8279C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_S8279C18, buf);
    S8279C18 *dp, &lv = *(dp=new (buf) S8279C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S8279C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8279C18)");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C5*)(S8279C20*), 0, "S8279C18");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C5*)(S8279C6*), 0, "S8279C18");
    check_base_class_offset(lv, (S8279C5*)(S8279C20*), ABISELECT(40,24), "S8279C18");
    check_base_class_offset(lv, (S8279C20*)(S8279C19*), ABISELECT(40,24), "S8279C18");
    check_base_class_offset(lv, (S8279C19*), ABISELECT(32,20), "S8279C18");
    check_base_class_offset(lv, (S814C5_nt*)(S8279C6*), 0, "S8279C18");
    check_base_class_offset(lv, (S8279C5*)(S8279C6*), ABISELECT(8,4), "S8279C18");
    check_base_class_offset(lv, (S8279C6*), 0, "S8279C18");
    set_bf_and_test(lv, s8279c18f0, ABISELECT(20,12), 0, 32, 1, "S8279C18");
    set_bf_and_test(lv, s8279c18f0, ABISELECT(20,12), 0, 32, hide_sll(1LL<<31), "S8279C18");
    check_field_offset(lv, s8279c18f1, ABISELECT(24,16), "S8279C18.s8279c18f1");
    test_class_info(&lv, &cd_S8279C18);
    dp->~S8279C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8279C18(Test_S8279C18, "S8279C18", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN8S8279C18C1Ev();
extern void _ZN8S8279C18D2Ev();
Name_Map name_map_S8279C18[] = {
  NSPAIR(_ZN8S8279C18C1Ev),
  NSPAIR(_ZN8S8279C18D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S694C11_nt;
extern VTBL_ENTRY _ZTI10S694C11_nt[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S8279C20;
extern VTBL_ENTRY _ZTI8S8279C20[];
extern  VTBL_ENTRY _ZTV8S8279C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C20[];
extern Class_Descriptor cd_S8279C19;
extern VTBL_ENTRY _ZTI8S8279C19[];
extern  VTBL_ENTRY _ZTV8S8279C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C19[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S8279C6;
extern VTBL_ENTRY _ZTI7S8279C6[];
extern  VTBL_ENTRY _ZTV7S8279C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C6[];
static Base_Class bases_S8279C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S694C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S8279C5,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S8279C20,    ABISELECT(40,24), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S8279C19,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S814C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S8279C5,    ABISELECT(8,4), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S8279C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S8279C18[];
extern void _ZN8S8279C18D1Ev();
extern void _ZN8S8279C18D0Ev();
extern void _ZN7S8279C52v1Ev();
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY vtc_S8279C18[] = {
  ABISELECT(40,24),
  ABISELECT(32,20),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C18[0]),
  (VTBL_ENTRY)&_ZN8S8279C18D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C18D0Ev,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C18[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  ABISELECT(-32,-20),
  ABISELECT(8,4),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI8S8279C18[0]),
  0,
  ABISELECT(-40,-24),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI8S8279C18[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern VTBL_ENTRY _ZTV8S8279C18[];
extern void _ZN7S8279C6D1Ev();
extern void _ZN7S8279C6D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C18[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C6[0]),
  (VTBL_ENTRY)&_ZN7S8279C6D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C6D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C18[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C6__8S8279C18[] = {
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S8279C6[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
static  VTBL_ENTRY _tg__ZTV8S8279C19__8S8279C18[] = {
  ABISELECT(-32,-20),
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C19[0]),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C20__8S8279C19__8S8279C18[] = {
  0,
  ABISELECT(-40,-24),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C19[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C20__8S8279C18[] = {
  ABISELECT(-40,-24),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C20[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C58S8279C20__8S8279C18[] = {
  ABISELECT(-40,-24),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
static  VTT_ENTRY vtt_S8279C18[] = {
  {&(_ZTV8S8279C18[5]),  5,20},
  {&(_tg__ZTV7S8279C6__8S8279C18[3]),  3,5},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C18[3]),  3,4},
  {&(_tg__ZTV7S8279C5__7S8279C6__8S8279C18[3]),  3,4},
  {&(_ZTV8S8279C18[15]),  15,20},
  {&(_ZTV8S8279C18[19]),  19,20},
  {&(_ZTV8S8279C18[10]),  10,20},
  {&(_tg__ZTV8S8279C19__8S8279C18[4]),  4,4},
  {&(_tg__ZTV8S8279C20__8S8279C19__8S8279C18[4]),  4,5},
  {&(_tg__ZTV8S8279C20__8S8279C18[3]),  3,4},
  {&(_tg__ZTV7S8279C58S8279C20__8S8279C18[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8S8279C18[];
extern  VTBL_ENTRY _ZTV8S8279C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C18[];
Class_Descriptor cd_S8279C18 = {  "S8279C18", // class name
  bases_S8279C18, 7,
  &(vtc_S8279C18[0]), // expected_vtbl_contents
  &(vtt_S8279C18[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI8S8279C18),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S8279C18),20, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S8279C18),11, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8279C12  : virtual S8279C13 , virtual S8279C16 , virtual S8279C18 {
  int s8279c12f0;
  ~S8279C12(); // tgen
  S8279C12(); // tgen
};
//SIG(-1 S8279C12) C1{ VBC2{ VBC3{ m} VBC4{ VBC3 v1} VBC5{ VBC3 VBC4 VBC6{ BC7{ vd m} BC4 vd FC8{}} VBC7 BC9{ VBC3 VBC4 BC7 vd Fi:4}} VBC10{ VBC9 BC4 BC5 BC7 BC11{ BC7 VBC3 VBC4 VBC6 BC9 vd} vd Fi[2]} vd} VBC12{ VBC9 BC2 BC11 BC13{ VBC11 vd} Fp} VBC14{ VBC15{ VBC16{ BC4 Fp}} BC6 vd Fi:32 FC17{ m}} Fi}


S8279C12 ::~S8279C12(){ note_dtor("S8279C12", this);} // tgen
S8279C12 ::S8279C12(){ note_ctor("S8279C12", this);} // tgen

static void Test_S8279C12()
{
  extern Class_Descriptor cd_S8279C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(35,37)];
    init_test(&cd_S8279C12, buf);
    S8279C12 *dp, &lv = *(dp=new (buf) S8279C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,144), "sizeof(S8279C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8279C12)");
    /*is_ambiguous_... S8279C12::S8279C13 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C13*), 0, "S8279C12");
    /*is_ambiguous_... S8279C12::S8279C5 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C5*), 0, "S8279C12");
    /*is_ambiguous_... S8279C12::S8279C3 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C3*), 0, "S8279C12");
    /*is_ambiguous_... S8279C12::S8279C6 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C5*)(S8279C6*), 0, "S8279C12");
    /*is_ambiguous_... S8279C12::S8279C3 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C8*)(S8279C3*), 0, "S8279C12");
    /*is_ambiguous_... S8279C12::S8279C8 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C8*), 0, "S8279C12");
    /*is_ambiguous_... S8279C14::S8279C5 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C5*)(S8279C14*), 0, "S8279C12");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C3*)(S8279C14*), 0, "S8279C12");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C8*)(S8279C3*)(S8279C14*), 0, "S8279C12");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C15*)(S8279C14*), 0, "S8279C12");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C8*)(S8279C15*)(S8279C14*), 0, "S8279C12");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C13*)(S8279C16*), 0, "S8279C12");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C15*)(S8279C16*), 0, "S8279C12");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C8*)(S8279C15*)(S8279C16*), 0, "S8279C12");
    /*is_ambiguous_... S8279C12::S8279C15 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C15*), 0, "S8279C12");
    /*is_ambiguous_... S8279C12::S8279C15 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C8*)(S8279C15*), 0, "S8279C12");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C5*)(S8279C20*), 0, "S8279C12");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C5*)(S8279C6*)(S8279C18*), 0, "S8279C12");
    /*is_ambiguous_... S8279C12::S8279C13 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C13*), 0, "S8279C12");
    /*is_ambiguous_... S8279C12::S8279C3 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C3*), 0, "S8279C12");
    /*is_ambiguous_... S8279C12::S8279C3 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C8*)(S8279C3*), 0, "S8279C12");
    /*is_ambiguous_... S8279C12::S8279C8 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C8*), 0, "S8279C12");
    /*is_ambiguous_... S8279C3::S8279C5 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C3*)(S8279C14*), 0, "S8279C12");
    check_base_class_offset(lv, (S8279C5*)(S8279C8*)(S8279C3*)(S8279C14*), 0, "S8279C12");
    /*is_ambiguous_... S8279C15::S8279C5 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C15*)(S8279C14*), 0, "S8279C12");
    check_base_class_offset(lv, (S8279C5*)(S8279C8*)(S8279C15*)(S8279C14*), 0, "S8279C12");
    /*is_ambiguous_... S8279C13::S8279C5 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C13*)(S8279C16*), 0, "S8279C12");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C15*)(S8279C16*), 0, "S8279C12");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C8*)(S8279C15*)(S8279C16*), 0, "S8279C12");
    /*is_ambiguous_... S8279C12::S8279C15 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C15*), 0, "S8279C12");
    /*is_ambiguous_... S8279C12::S8279C15 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C8*)(S8279C15*), 0, "S8279C12");
    /*is_ambiguous_... S8279C12::S8279C6 */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C6*), ABISELECT(32,16), "S8279C12");
    /*is_ambiguous_... S8279C12::S8279C6 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C6*), ABISELECT(40,20), "S8279C12");
    /*is_ambiguous_... S8279C12::S8279C3 */ AMB_check_base_class_offset(lv, (S8279C6*)(S8279C3*), ABISELECT(32,16), "S8279C12");
    check_base_class_offset(lv, (S8279C6*)(S8279C3*)(S8279C14*), ABISELECT(32,16), "S8279C12");
    check_base_class_offset(lv, (S8279C6*)(S8279C15*)(S8279C14*), ABISELECT(32,16), "S8279C12");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S8279C6*)(S8279C15*)(S8279C16*), ABISELECT(32,16), "S8279C12");
    /*is_ambiguous_... S8279C12::S8279C15 */ AMB_check_base_class_offset(lv, (S8279C6*)(S8279C15*), ABISELECT(32,16), "S8279C12");
    /*is_ambiguous_... S8279C12::S8279C3 */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C3*), ABISELECT(56,28), "S8279C12");
    /*is_ambiguous_... S8279C3::S814C5_nt */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C3*)(S8279C14*), ABISELECT(56,28), "S8279C12");
    /*is_ambiguous_... S8279C12::S8279C3 */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C8*)(S8279C3*), ABISELECT(16,8), "S8279C12");
    /*is_ambiguous_... S8279C12::S8279C3 */ AMB_check_base_class_offset(lv, (S8279C8*)(S8279C3*), ABISELECT(16,8), "S8279C12");
    /*is_ambiguous_... S8279C12::S8279C13 */ AMB_check_base_class_offset(lv, (S8279C3*)(S8279C13*), ABISELECT(16,8), "S8279C12");
    /*is_ambiguous_... S8279C13::S8279C3 */ AMB_check_base_class_offset(lv, (S8279C3*)(S8279C13*)(S8279C16*), ABISELECT(16,8), "S8279C12");
    /*is_ambiguous_... S8279C12::S8279C8 */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C8*), ABISELECT(128,68), "S8279C12");
    /*is_ambiguous_... S8279C14::S8279C8 */ AMB_check_base_class_offset(lv, (S8279C8*)(S8279C14*), ABISELECT(128,68), "S8279C12");
    /*is_ambiguous_... S8279C16::S8279C8 */ AMB_check_base_class_offset(lv, (S8279C8*)(S8279C16*), ABISELECT(128,68), "S8279C12");
    /*is_ambiguous_... S8279C14::S8279C5 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C14*), ABISELECT(64,32), "S8279C12");
    check_base_class_offset(lv, (S814C5_nt*)(S8279C8*)(S8279C3*)(S8279C14*), ABISELECT(72,36), "S8279C12");
    check_base_class_offset(lv, (S8279C8*)(S8279C3*)(S8279C14*), ABISELECT(72,36), "S8279C12");
    check_base_class_offset(lv, (S8279C3*)(S8279C14*), ABISELECT(72,36), "S8279C12");
    /*is_ambiguous_... S8279C14::S814C5_nt */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C14*), ABISELECT(88,44), "S8279C12");
    /*is_ambiguous_... S8279C15::S814C5_nt */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C15*)(S8279C14*), ABISELECT(96,48), "S8279C12");
    check_base_class_offset(lv, (S814C5_nt*)(S8279C8*)(S8279C15*)(S8279C14*), ABISELECT(104,52), "S8279C12");
    check_base_class_offset(lv, (S8279C8*)(S8279C15*)(S8279C14*), ABISELECT(104,52), "S8279C12");
    check_base_class_offset(lv, (S8279C15*)(S8279C14*), ABISELECT(96,48), "S8279C12");
    /*is_ambiguous_... S8279C12::S8279C13 */ AMB_check_base_class_offset(lv, (S8279C14*)(S8279C13*), ABISELECT(64,32), "S8279C12");
    check_base_class_offset(lv, (S8279C14*)(S8279C13*)(S8279C16*), ABISELECT(64,32), "S8279C12");
    /*is_ambiguous_... S8279C12::S8279C13 */ AMB_check_base_class_offset(lv, (S8279C13*), 0, "S8279C12");
    check_base_class_offset(lv, (S8279C13*)(S8279C16*), ABISELECT(144,76), "S8279C12");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C15*)(S8279C16*), ABISELECT(152,80), "S8279C12");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C8*)(S8279C15*)(S8279C16*), ABISELECT(160,84), "S8279C12");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S8279C8*)(S8279C15*)(S8279C16*), ABISELECT(160,84), "S8279C12");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S8279C15*)(S8279C16*), ABISELECT(152,80), "S8279C12");
    /*is_ambiguous_... S8279C12::S8279C15 */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C15*), ABISELECT(192,100), "S8279C12");
    /*is_ambiguous_... S8279C12::S8279C15 */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C8*)(S8279C15*), ABISELECT(200,104), "S8279C12");
    /*is_ambiguous_... S8279C12::S8279C15 */ AMB_check_base_class_offset(lv, (S8279C8*)(S8279C15*), ABISELECT(200,104), "S8279C12");
    check_base_class_offset(lv, (S8279C15*)(S8279C17*)(S8279C16*), ABISELECT(192,100), "S8279C12");
    check_base_class_offset(lv, (S8279C17*)(S8279C16*), ABISELECT(176,92), "S8279C12");
    check_base_class_offset(lv, (S8279C16*), ABISELECT(144,76), "S8279C12");
    check_base_class_offset(lv, (S8279C5*)(S8279C20*), ABISELECT(256,136), "S8279C12");
    check_base_class_offset(lv, (S8279C20*)(S8279C19*), ABISELECT(256,136), "S8279C12");
    check_base_class_offset(lv, (S8279C19*)(S8279C18*), ABISELECT(248,132), "S8279C12");
    check_base_class_offset(lv, (S814C5_nt*)(S8279C6*)(S8279C18*), ABISELECT(216,112), "S8279C12");
    check_base_class_offset(lv, (S8279C5*)(S8279C6*)(S8279C18*), ABISELECT(224,116), "S8279C12");
    check_base_class_offset(lv, (S8279C6*)(S8279C18*), ABISELECT(216,112), "S8279C12");
    check_base_class_offset(lv, (S8279C18*), ABISELECT(216,112), "S8279C12");
    check_field_offset(lv, s8279c12f0, ABISELECT(8,4), "S8279C12.s8279c12f0");
    test_class_info(&lv, &cd_S8279C12);
    dp->~S8279C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8279C12(Test_S8279C12, "S8279C12", ABISELECT(272,144));

#else // __cplusplus

extern void _ZN8S8279C12C1Ev();
extern void _ZN8S8279C12D1Ev();
Name_Map name_map_S8279C12[] = {
  NSPAIR(_ZN8S8279C12C1Ev),
  NSPAIR(_ZN8S8279C12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S694C11_nt;
extern VTBL_ENTRY _ZTI10S694C11_nt[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S8279C6;
extern VTBL_ENTRY _ZTI7S8279C6[];
extern  VTBL_ENTRY _ZTV7S8279C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C6[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C8;
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
extern Class_Descriptor cd_S8279C3;
extern VTBL_ENTRY _ZTI7S8279C3[];
extern  VTBL_ENTRY _ZTV7S8279C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C3[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C8;
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C8;
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
extern Class_Descriptor cd_S8279C3;
extern VTBL_ENTRY _ZTI7S8279C3[];
extern  VTBL_ENTRY _ZTV7S8279C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C3[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C8;
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
extern Class_Descriptor cd_S8279C15;
extern VTBL_ENTRY _ZTI8S8279C15[];
extern  VTBL_ENTRY _ZTV8S8279C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C15[];
extern Class_Descriptor cd_S8279C14;
extern VTBL_ENTRY _ZTI8S8279C14[];
extern  VTBL_ENTRY _ZTV8S8279C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C14[];
extern Class_Descriptor cd_S8279C13;
extern VTBL_ENTRY _ZTI8S8279C13[];
extern  VTBL_ENTRY _ZTV8S8279C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C13[];
extern Class_Descriptor cd_S8279C13;
extern VTBL_ENTRY _ZTI8S8279C13[];
extern  VTBL_ENTRY _ZTV8S8279C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C13[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C8;
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
extern Class_Descriptor cd_S8279C15;
extern VTBL_ENTRY _ZTI8S8279C15[];
extern  VTBL_ENTRY _ZTV8S8279C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C15[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C8;
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
extern Class_Descriptor cd_S8279C15;
extern VTBL_ENTRY _ZTI8S8279C15[];
extern  VTBL_ENTRY _ZTV8S8279C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C15[];
extern Class_Descriptor cd_S8279C17;
extern VTBL_ENTRY _ZTI8S8279C17[];
extern  VTBL_ENTRY _ZTV8S8279C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C17[];
extern Class_Descriptor cd_S8279C16;
extern VTBL_ENTRY _ZTI8S8279C16[];
extern  VTBL_ENTRY _ZTV8S8279C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C16[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S8279C20;
extern VTBL_ENTRY _ZTI8S8279C20[];
extern  VTBL_ENTRY _ZTV8S8279C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C20[];
extern Class_Descriptor cd_S8279C19;
extern VTBL_ENTRY _ZTI8S8279C19[];
extern  VTBL_ENTRY _ZTV8S8279C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C19[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S8279C6;
extern VTBL_ENTRY _ZTI7S8279C6[];
extern  VTBL_ENTRY _ZTV7S8279C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C6[];
extern Class_Descriptor cd_S8279C18;
extern VTBL_ENTRY _ZTI8S8279C18[];
extern  VTBL_ENTRY _ZTV8S8279C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C18[];
static Base_Class bases_S8279C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S694C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S8279C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    36, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S814C5_nt,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S8279C5,    ABISELECT(40,20), //bcp->offset
    36, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    45, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S8279C6,    ABISELECT(32,16), //bcp->offset
    29, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    44, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S814C5_nt,    ABISELECT(56,28), //bcp->offset
    40, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S814C5_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S8279C8,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    38, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S8279C3,    ABISELECT(16,8), //bcp->offset
    20, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    37, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    21, //immediately_derived
  0, 1},
  {&cd_S814C5_nt,    ABISELECT(128,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S8279C8,    ABISELECT(128,68), //bcp->offset
    82, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    71, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    20, //immediately_derived
  0, 1},
  {&cd_S8279C5,    ABISELECT(64,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    48, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S814C5_nt,    ABISELECT(72,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S8279C8,    ABISELECT(72,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    50, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S8279C3,    ABISELECT(72,36), //bcp->offset
    57, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    49, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S814C5_nt,    ABISELECT(88,44), //bcp->offset
    65, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S814C5_nt,    ABISELECT(96,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S814C5_nt,    ABISELECT(104,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S8279C8,    ABISELECT(104,52), //bcp->offset
    76, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    57, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S8279C15,    ABISELECT(96,48), //bcp->offset
    69, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    56, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S8279C14,    ABISELECT(64,32), //bcp->offset
    45, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    47, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    21, //immediately_derived
  0, 1},
  {&cd_S8279C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S8279C13,    ABISELECT(144,76), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    74, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S814C5_nt,    ABISELECT(152,80), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S814C5_nt,    ABISELECT(160,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S8279C8,    ABISELECT(160,84), //bcp->offset
    111, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    87, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S8279C15,    ABISELECT(152,80), //bcp->offset
    104, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    86, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S814C5_nt,    ABISELECT(192,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S814C5_nt,    ABISELECT(200,104), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S8279C8,    ABISELECT(200,104), //bcp->offset
    135, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    116, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S8279C15,    ABISELECT(192,100), //bcp->offset
    127, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    115, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    31, //immediately_derived
  0, 1},
  {&cd_S8279C17,    ABISELECT(176,92), //bcp->offset
    117, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    93, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S8279C16,    ABISELECT(144,76), //bcp->offset
    89, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    73, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S8279C5,    ABISELECT(256,136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    132, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S8279C20,    ABISELECT(256,136), //bcp->offset
    158, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    131, //bcp->base_subarray_index_in_construction_vtbl_array
    34, //init_seq
    35, //immediately_derived
  0, 1},
  {&cd_S8279C19,    ABISELECT(248,132), //bcp->offset
    154, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    129, //bcp->base_subarray_index_in_construction_vtbl_array
    35, //init_seq
    39, //immediately_derived
  0, 1},
  {&cd_S814C5_nt,    ABISELECT(216,112), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    36, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S8279C5,    ABISELECT(224,116), //bcp->offset
    150, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    124, //bcp->base_subarray_index_in_construction_vtbl_array
    37, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S8279C6,    ABISELECT(216,112), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    123, //bcp->base_subarray_index_in_construction_vtbl_array
    38, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S8279C18,    ABISELECT(216,112), //bcp->offset
    141, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    122, //bcp->base_subarray_index_in_construction_vtbl_array
    39, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S8279C12[];
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTv0_n88_N8S8279C12D1Ev,_ZTv0_n44_N8S8279C12D1Ev)();
extern void _ZN8S8279C12D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n88_N8S8279C12D0Ev,_ZTv0_n44_N8S8279C12D0Ev)();
extern void _ZN8S8279C12D0Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S8279C12D1Ev,_ZTv0_n28_N8S8279C12D1Ev)();
extern void ABISELECT(_ZThn16_N8S8279C12D1Ev,_ZThn8_N8S8279C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S8279C12D0Ev,_ZTv0_n28_N8S8279C12D0Ev)();
extern void ABISELECT(_ZThn16_N8S8279C12D0Ev,_ZThn8_N8S8279C12D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S8279C12D1Ev,_ZTv0_n16_N8S8279C12D1Ev)();
extern void ABISELECT(_ZThn32_N8S8279C12D1Ev,_ZThn16_N8S8279C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S8279C12D0Ev,_ZTv0_n16_N8S8279C12D0Ev)();
extern void ABISELECT(_ZThn32_N8S8279C12D0Ev,_ZThn16_N8S8279C12D0Ev)() __attribute__((weak));
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTv0_n24_N8S8279C12D1Ev,_ZTv0_n12_N8S8279C12D1Ev)();
extern void ABISELECT(_ZThn56_N8S8279C12D1Ev,_ZThn28_N8S8279C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S8279C12D0Ev,_ZTv0_n12_N8S8279C12D0Ev)();
extern void ABISELECT(_ZThn56_N8S8279C12D0Ev,_ZThn28_N8S8279C12D0Ev)() __attribute__((weak));
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTv0_n72_N8S8279C12D1Ev,_ZTv0_n36_N8S8279C12D1Ev)();
extern void ABISELECT(_ZThn64_N8S8279C12D1Ev,_ZThn32_N8S8279C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S8279C12D0Ev,_ZTv0_n36_N8S8279C12D0Ev)();
extern void ABISELECT(_ZThn64_N8S8279C12D0Ev,_ZThn32_N8S8279C12D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn8_n72_N8S8279C12D1Ev,_ZTvn4_n36_N8S8279C12D1Ev)();
extern void ABISELECT(_ZTvn8_n72_N8S8279C12D0Ev,_ZTvn4_n36_N8S8279C12D0Ev)();
extern void ABISELECT(_ZTvn24_n72_N8S8279C12D1Ev,_ZTvn12_n36_N8S8279C12D1Ev)();
extern void ABISELECT(_ZTvn24_n72_N8S8279C12D0Ev,_ZTvn12_n36_N8S8279C12D0Ev)();
extern void ABISELECT(_ZTvn32_n72_N8S8279C12D1Ev,_ZTvn16_n36_N8S8279C12D1Ev)();
extern void ABISELECT(_ZTvn32_n72_N8S8279C12D0Ev,_ZTvn16_n36_N8S8279C12D0Ev)();
extern void ABISELECT(_ZTvn40_n72_N8S8279C12D1Ev,_ZTvn20_n36_N8S8279C12D1Ev)();
extern void ABISELECT(_ZTvn40_n72_N8S8279C12D0Ev,_ZTvn20_n36_N8S8279C12D0Ev)();
extern void ABISELECT(_ZTv0_n40_N8S8279C12D1Ev,_ZTv0_n20_N8S8279C12D1Ev)();
extern void ABISELECT(_ZThn128_N8S8279C12D1Ev,_ZThn68_N8S8279C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S8279C12D0Ev,_ZTv0_n20_N8S8279C12D0Ev)();
extern void ABISELECT(_ZThn128_N8S8279C12D0Ev,_ZThn68_N8S8279C12D0Ev)() __attribute__((weak));
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTv0_n96_N8S8279C12D1Ev,_ZTv0_n48_N8S8279C12D1Ev)();
extern void ABISELECT(_ZThn144_N8S8279C12D1Ev,_ZThn76_N8S8279C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N8S8279C12D0Ev,_ZTv0_n48_N8S8279C12D0Ev)();
extern void ABISELECT(_ZThn144_N8S8279C12D0Ev,_ZThn76_N8S8279C12D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn8_n96_N8S8279C12D1Ev,_ZTvn4_n48_N8S8279C12D1Ev)();
extern void ABISELECT(_ZTvn8_n96_N8S8279C12D0Ev,_ZTvn4_n48_N8S8279C12D0Ev)();
extern void ABISELECT(_ZTvn16_n96_N8S8279C12D1Ev,_ZTvn8_n48_N8S8279C12D1Ev)();
extern void ABISELECT(_ZTvn16_n96_N8S8279C12D0Ev,_ZTvn8_n48_N8S8279C12D0Ev)();
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTvn32_n96_N8S8279C12D1Ev,_ZTvn16_n48_N8S8279C12D1Ev)();
extern void ABISELECT(_ZTvn32_n96_N8S8279C12D0Ev,_ZTvn16_n48_N8S8279C12D0Ev)();
extern void ABISELECT(_ZTv0_n48_N8S8279C12D1Ev,_ZTv0_n24_N8S8279C12D1Ev)();
extern void ABISELECT(_ZThn192_N8S8279C12D1Ev,_ZThn100_N8S8279C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S8279C12D0Ev,_ZTv0_n24_N8S8279C12D0Ev)();
extern void ABISELECT(_ZThn192_N8S8279C12D0Ev,_ZThn100_N8S8279C12D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn8_n48_N8S8279C12D1Ev,_ZTvn4_n24_N8S8279C12D1Ev)();
extern void ABISELECT(_ZTvn8_n48_N8S8279C12D0Ev,_ZTvn4_n24_N8S8279C12D0Ev)();
extern void ABISELECT(_ZTv0_n48_N8S8279C12D1Ev,_ZTv0_n24_N8S8279C12D1Ev)();
extern void ABISELECT(_ZThn216_N8S8279C12D1Ev,_ZThn112_N8S8279C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S8279C12D0Ev,_ZTv0_n24_N8S8279C12D0Ev)();
extern void ABISELECT(_ZThn216_N8S8279C12D0Ev,_ZThn112_N8S8279C12D0Ev)() __attribute__((weak));
extern void _ZN7S8279C52v1Ev();
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY vtc_S8279C12[] = {
  ABISELECT(256,136),
  ABISELECT(248,132),
  ABISELECT(216,112),
  ABISELECT(192,100),
  ABISELECT(144,76),
  0,
  0,
  ABISELECT(128,68),
  ABISELECT(64,32),
  ABISELECT(56,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n88_N8S8279C12D1Ev,_ZTv0_n44_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n88_N8S8279C12D0Ev,_ZTv0_n44_N8S8279C12D0Ev),
  ABISELECT(-16,-8),
  ABISELECT(40,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S8279C12D1Ev,_ZTv0_n28_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S8279C12D0Ev,_ZTv0_n28_N8S8279C12D0Ev),
  ABISELECT(8,4),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C12D1Ev,_ZTv0_n16_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C12D0Ev,_ZTv0_n16_N8S8279C12D0Ev),
  ABISELECT(-40,-20),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  ABISELECT(-56,-28),
  ABISELECT(-56,-28),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C12D1Ev,_ZTv0_n12_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C12D0Ev,_ZTv0_n12_N8S8279C12D0Ev),
  ABISELECT(-64,-32),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-32,-16),
  ABISELECT(-64,-32),
  ABISELECT(64,36),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S8279C12D1Ev,_ZTv0_n36_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S8279C12D0Ev,_ZTv0_n36_N8S8279C12D0Ev),
  ABISELECT(-16,-8),
  ABISELECT(-40,-20),
  ABISELECT(-72,-36),
  ABISELECT(-72,-36),
  ABISELECT(-72,-36),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n72_N8S8279C12D1Ev,_ZTvn4_n36_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n72_N8S8279C12D0Ev,_ZTvn4_n36_N8S8279C12D0Ev),
  ABISELECT(-88,-44),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn24_n72_N8S8279C12D1Ev,_ZTvn12_n36_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn24_n72_N8S8279C12D0Ev,_ZTvn12_n36_N8S8279C12D0Ev),
  ABISELECT(-64,-32),
  ABISELECT(-96,-48),
  ABISELECT(-96,-48),
  ABISELECT(-96,-48),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n72_N8S8279C12D1Ev,_ZTvn16_n36_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n72_N8S8279C12D0Ev,_ZTvn16_n36_N8S8279C12D0Ev),
  ABISELECT(-104,-52),
  ABISELECT(-104,-52),
  ABISELECT(-104,-52),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn40_n72_N8S8279C12D1Ev,_ZTvn20_n36_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn40_n72_N8S8279C12D0Ev,_ZTvn20_n36_N8S8279C12D0Ev),
  ABISELECT(-128,-68),
  ABISELECT(-128,-68),
  ABISELECT(-128,-68),
  ABISELECT(-128,-68),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C12D1Ev,_ZTv0_n20_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C12D0Ev,_ZTv0_n20_N8S8279C12D0Ev),
  ABISELECT(-144,-76),
  ABISELECT(48,24),
  ABISELECT(-16,-8),
  ABISELECT(-80,-44),
  ABISELECT(-88,-48),
  ABISELECT(-112,-60),
  ABISELECT(-128,-68),
  ABISELECT(-144,-76),
  ABISELECT(-144,-76),
  ABISELECT(-144,-76),
  ABISELECT(-144,-76),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S8279C12D1Ev,_ZTv0_n48_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S8279C12D0Ev,_ZTv0_n48_N8S8279C12D0Ev),
  ABISELECT(-120,-64),
  ABISELECT(-152,-80),
  ABISELECT(-152,-80),
  ABISELECT(-152,-80),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n96_N8S8279C12D1Ev,_ZTvn4_n48_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n96_N8S8279C12D0Ev,_ZTvn4_n48_N8S8279C12D0Ev),
  ABISELECT(-160,-84),
  ABISELECT(-160,-84),
  ABISELECT(-160,-84),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n96_N8S8279C12D1Ev,_ZTvn8_n48_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n96_N8S8279C12D0Ev,_ZTvn8_n48_N8S8279C12D0Ev),
  ABISELECT(-144,-76),
  ABISELECT(-176,-92),
  ABISELECT(16,8),
  ABISELECT(-176,-92),
  ABISELECT(-176,-92),
  ABISELECT(-176,-92),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n96_N8S8279C12D1Ev,_ZTvn16_n48_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n96_N8S8279C12D0Ev,_ZTvn16_n48_N8S8279C12D0Ev),
  ABISELECT(-192,-100),
  ABISELECT(-160,-84),
  ABISELECT(-192,-100),
  ABISELECT(-192,-100),
  ABISELECT(-192,-100),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C12D1Ev,_ZTv0_n24_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C12D0Ev,_ZTv0_n24_N8S8279C12D0Ev),
  ABISELECT(-200,-104),
  ABISELECT(-200,-104),
  ABISELECT(-200,-104),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S8279C12D1Ev,_ZTvn4_n24_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S8279C12D0Ev,_ZTvn4_n24_N8S8279C12D0Ev),
  ABISELECT(8,4),
  ABISELECT(-216,-112),
  ABISELECT(40,24),
  ABISELECT(32,20),
  ABISELECT(-216,-112),
  ABISELECT(-216,-112),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C12D1Ev,_ZTv0_n24_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C12D0Ev,_ZTv0_n24_N8S8279C12D0Ev),
  ABISELECT(-224,-116),
  ABISELECT(-224,-116),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  ABISELECT(-248,-132),
  ABISELECT(8,4),
  ABISELECT(-248,-132),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  0,
  ABISELECT(-256,-136),
  ABISELECT(-256,-136),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern VTBL_ENTRY _ZTV8S8279C12[];
extern void _ZN7S8279C52v1Ev();
extern void _ZN8S8279C13D1Ev();
extern void _ZN8S8279C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C13__8S8279C12[] = {
  ABISELECT(128,68),
  ABISELECT(64,32),
  ABISELECT(56,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&_ZN8S8279C13D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C13D0Ev,
};
extern void ABISELECT(_ZTv0_n56_N8S8279C13D1Ev,_ZTv0_n28_N8S8279C13D1Ev)();
extern void ABISELECT(_ZThn16_N8S8279C13D1Ev,_ZThn8_N8S8279C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S8279C13D0Ev,_ZTv0_n28_N8S8279C13D0Ev)();
extern void ABISELECT(_ZThn16_N8S8279C13D0Ev,_ZThn8_N8S8279C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S8279C3__8S8279C13__8S8279C12[] = {
  ABISELECT(-16,-8),
  ABISELECT(40,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S8279C13D1Ev,_ZTv0_n28_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S8279C13D0Ev,_ZTv0_n28_N8S8279C13D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S8279C13D1Ev,_ZTv0_n16_N8S8279C13D1Ev)();
extern void ABISELECT(_ZThn32_N8S8279C13D1Ev,_ZThn16_N8S8279C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S8279C13D0Ev,_ZTv0_n16_N8S8279C13D0Ev)();
extern void ABISELECT(_ZThn32_N8S8279C13D0Ev,_ZThn16_N8S8279C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C13__8S8279C12[] = {
  ABISELECT(8,4),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C13D1Ev,_ZTv0_n16_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C13D0Ev,_ZTv0_n16_N8S8279C13D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C13__8S8279C12[] = {
  ABISELECT(-40,-20),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S8279C13D1Ev,_ZTv0_n12_N8S8279C13D1Ev)();
extern void ABISELECT(_ZThn56_N8S8279C13D1Ev,_ZThn28_N8S8279C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S8279C13D0Ev,_ZTv0_n12_N8S8279C13D0Ev)();
extern void ABISELECT(_ZThn56_N8S8279C13D0Ev,_ZThn28_N8S8279C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S814C5_nt__A1__8S8279C13__8S8279C12[] = {
  ABISELECT(-56,-28),
  ABISELECT(-56,-28),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C13D1Ev,_ZTv0_n12_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C13D0Ev,_ZTv0_n12_N8S8279C13D0Ev),
};
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTv0_n72_N8S8279C13D1Ev,_ZTv0_n36_N8S8279C13D1Ev)();
extern void ABISELECT(_ZThn64_N8S8279C13D1Ev,_ZThn32_N8S8279C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S8279C13D0Ev,_ZTv0_n36_N8S8279C13D0Ev)();
extern void ABISELECT(_ZThn64_N8S8279C13D0Ev,_ZThn32_N8S8279C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S8279C14__8S8279C13__8S8279C12[] = {
  ABISELECT(-64,-32),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-32,-16),
  ABISELECT(-64,-32),
  ABISELECT(64,36),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S8279C13D1Ev,_ZTv0_n36_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S8279C13D0Ev,_ZTv0_n36_N8S8279C13D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N8S8279C13D1Ev,_ZTv0_n20_N8S8279C13D1Ev)();
extern void ABISELECT(_ZThn128_N8S8279C13D1Ev,_ZThn68_N8S8279C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S8279C13D0Ev,_ZTv0_n20_N8S8279C13D0Ev)();
extern void ABISELECT(_ZThn128_N8S8279C13D0Ev,_ZThn68_N8S8279C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S8279C8__A1__8S8279C13__8S8279C12[] = {
  ABISELECT(-128,-68),
  ABISELECT(-128,-68),
  ABISELECT(-128,-68),
  ABISELECT(-128,-68),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C13D1Ev,_ZTv0_n20_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C13D0Ev,_ZTv0_n20_N8S8279C13D0Ev),
};
extern void ABISELECT(_ZTvn8_n72_N8S8279C13D1Ev,_ZTvn4_n36_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTvn8_n72_N8S8279C13D0Ev,_ZTvn4_n36_N8S8279C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C38S8279C14__A1__8S8279C13__8S8279C12[] = {
  ABISELECT(-16,-8),
  ABISELECT(-40,-20),
  ABISELECT(-72,-36),
  ABISELECT(-72,-36),
  ABISELECT(-72,-36),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n72_N8S8279C13D1Ev,_ZTvn4_n36_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n72_N8S8279C13D0Ev,_ZTvn4_n36_N8S8279C13D0Ev),
};
extern void ABISELECT(_ZTvn24_n72_N8S8279C13D1Ev,_ZTvn12_n36_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTvn24_n72_N8S8279C13D0Ev,_ZTvn12_n36_N8S8279C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S814C5_nt8S8279C14__A5__8S8279C13__8S8279C12[] = {
  ABISELECT(-88,-44),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn24_n72_N8S8279C13D1Ev,_ZTvn12_n36_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn24_n72_N8S8279C13D0Ev,_ZTvn12_n36_N8S8279C13D0Ev),
};
extern void ABISELECT(_ZTvn32_n72_N8S8279C13D1Ev,_ZTvn16_n36_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTvn32_n72_N8S8279C13D0Ev,_ZTvn16_n36_N8S8279C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S8279C158S8279C14__8S8279C13__8S8279C12[] = {
  ABISELECT(-64,-32),
  ABISELECT(-96,-48),
  ABISELECT(-96,-48),
  ABISELECT(-96,-48),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n72_N8S8279C13D1Ev,_ZTvn16_n36_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n72_N8S8279C13D0Ev,_ZTvn16_n36_N8S8279C13D0Ev),
};
extern void ABISELECT(_ZTvn40_n72_N8S8279C13D1Ev,_ZTvn20_n36_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTvn40_n72_N8S8279C13D0Ev,_ZTvn20_n36_N8S8279C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C158S8279C14__A3__8S8279C13__8S8279C12[] = {
  ABISELECT(-104,-52),
  ABISELECT(-104,-52),
  ABISELECT(-104,-52),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn40_n72_N8S8279C13D1Ev,_ZTvn20_n36_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn40_n72_N8S8279C13D0Ev,_ZTvn20_n36_N8S8279C13D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C12[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C3D1Ev();
extern void _ZN7S8279C3D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C3__8S8279C12[] = {
  ABISELECT(40,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&_ZN7S8279C3D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C3D0Ev,
};
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C87S8279C3__8S8279C12[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C87S8279C3__8S8279C12[] = {
  0,
  0,
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C3__8S8279C12[] = {
  0,
  0,
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N7S8279C3D1Ev,_ZTv0_n16_N7S8279C3D1Ev)();
extern void ABISELECT(_ZThn16_N7S8279C3D1Ev,_ZThn8_N7S8279C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S8279C3D0Ev,_ZTv0_n16_N7S8279C3D0Ev)();
extern void ABISELECT(_ZThn16_N7S8279C3D0Ev,_ZThn8_N7S8279C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S8279C6__7S8279C3__8S8279C12[] = {
  ABISELECT(8,4),
  ABISELECT(-16,-8),
  ABISELECT(-32,-16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S8279C3D1Ev,_ZTv0_n16_N7S8279C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S8279C3D0Ev,_ZTv0_n16_N7S8279C3D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__7S8279C3__8S8279C12[] = {
  ABISELECT(-40,-20),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S8279C3D1Ev,_ZTv0_n12_N7S8279C3D1Ev)();
extern void ABISELECT(_ZThn40_N7S8279C3D1Ev,_ZThn20_N7S8279C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S8279C3D0Ev,_ZTv0_n12_N7S8279C3D0Ev)();
extern void ABISELECT(_ZThn40_N7S8279C3D0Ev,_ZThn20_N7S8279C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S814C5_nt__A1__7S8279C3__8S8279C12[] = {
  ABISELECT(-40,-20),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S8279C3D1Ev,_ZTv0_n12_N7S8279C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S8279C3D0Ev,_ZTv0_n12_N7S8279C3D0Ev),
};
extern void _ZN7S8279C6D1Ev();
extern void _ZN7S8279C6D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C12[] = {
  ABISELECT(-32,-16),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C6[0]),
  (VTBL_ENTRY)&_ZN7S8279C6D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C6D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C12[] = {
  ABISELECT(-40,-20),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C6__8S8279C12[] = {
  ABISELECT(-40,-20),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S8279C6[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
extern void _ZN8S8279C14D1Ev();
extern void _ZN8S8279C14D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C14__8S8279C12[] = {
  ABISELECT(-8,-4),
  ABISELECT(-32,-16),
  ABISELECT(-64,-32),
  ABISELECT(64,36),
  ABISELECT(-64,-32),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&_ZN8S8279C14D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C14D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C58S8279C14__A2__8S8279C12[] = {
  ABISELECT(-64,-32),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C3D1Ev();
extern void _ZN7S8279C3D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C38S8279C14__A1__8S8279C12[] = {
  ABISELECT(-16,-8),
  ABISELECT(-40,-20),
  ABISELECT(-72,-36),
  ABISELECT(-72,-36),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&_ZN7S8279C3D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C3D0Ev,
};
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C87S8279C38S8279C14__A2__8S8279C12[] = {
  ABISELECT(-72,-36),
  ABISELECT(-72,-36),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C87S8279C38S8279C14__A2__8S8279C12[] = {
  0,
  0,
  ABISELECT(72,36),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C38S8279C14__A1__8S8279C12[] = {
  0,
  0,
  ABISELECT(72,36),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N7S8279C3D1Ev,_ZTv0_n16_N7S8279C3D1Ev)();
extern void ABISELECT(_ZTv0_n32_N7S8279C3D0Ev,_ZTv0_n16_N7S8279C3D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C6__7S8279C38S8279C14__A1__8S8279C12[] = {
  ABISELECT(8,4),
  ABISELECT(40,20),
  ABISELECT(-32,-16),
  ABISELECT(40,20),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S8279C3D1Ev,_ZTv0_n16_N7S8279C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S8279C3D0Ev,_ZTv0_n16_N7S8279C3D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__7S8279C38S8279C14__A1__8S8279C12[] = {
  ABISELECT(-40,-20),
  ABISELECT(32,16),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S8279C3D1Ev,_ZTv0_n12_N7S8279C3D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S8279C3D0Ev,_ZTv0_n12_N7S8279C3D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S814C5_nt__A1__7S8279C38S8279C14__A1__8S8279C12[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S8279C3D1Ev,_ZTv0_n12_N7S8279C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S8279C3D0Ev,_ZTv0_n12_N7S8279C3D0Ev),
};
extern void _ZN8S8279C15D1Ev();
extern void _ZN8S8279C15D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C158S8279C14__8S8279C12[] = {
  ABISELECT(-64,-32),
  ABISELECT(-96,-48),
  ABISELECT(-96,-48),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN8S8279C15D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C15D0Ev,
};
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C158S8279C14__A3__8S8279C12[] = {
  ABISELECT(-104,-52),
  ABISELECT(-104,-52),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C88S8279C158S8279C14__A3__8S8279C12[] = {
  0,
  0,
  ABISELECT(104,52),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C158S8279C14__8S8279C12[] = {
  0,
  0,
  ABISELECT(96,48),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev)();
extern void ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C158S8279C14__8S8279C12[] = {
  ABISELECT(8,4),
  ABISELECT(64,32),
  ABISELECT(-32,-16),
  ABISELECT(64,32),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C158S8279C14__8S8279C12[] = {
  ABISELECT(-40,-20),
  ABISELECT(56,28),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZThn8_N8S8279C15D1Ev,_ZThn4_N8S8279C15D1Ev)();
extern void ABISELECT(_ZThn8_N8S8279C15D0Ev,_ZThn4_N8S8279C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C8__8S8279C158S8279C14__8S8279C12[] = {
  ABISELECT(-104,-52),
  ABISELECT(-104,-52),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C15D1Ev,_ZThn4_N8S8279C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C15D0Ev,_ZThn4_N8S8279C15D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N8S8279C14D1Ev,_ZTv0_n20_N8S8279C14D1Ev)();
extern void ABISELECT(_ZThn64_N8S8279C14D1Ev,_ZThn36_N8S8279C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S8279C14D0Ev,_ZTv0_n20_N8S8279C14D0Ev)();
extern void ABISELECT(_ZThn64_N8S8279C14D0Ev,_ZThn36_N8S8279C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S8279C8__8S8279C14__8S8279C12[] = {
  ABISELECT(-64,-36),
  ABISELECT(-128,-68),
  ABISELECT(-128,-68),
  ABISELECT(-64,-36),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C14D1Ev,_ZTv0_n20_N8S8279C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C14D0Ev,_ZTv0_n20_N8S8279C14D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C14__8S8279C12[] = {
  0,
  0,
  ABISELECT(64,32),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZThn8_N8S8279C14D1Ev,_ZThn4_N8S8279C14D1Ev)();
extern void ABISELECT(_ZThn8_N8S8279C14D0Ev,_ZThn4_N8S8279C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C3__8S8279C14__8S8279C12[] = {
  ABISELECT(-16,-8),
  ABISELECT(-40,-20),
  ABISELECT(-72,-36),
  ABISELECT(-72,-36),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C14D1Ev,_ZThn4_N8S8279C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C14D0Ev,_ZThn4_N8S8279C14D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S8279C14D1Ev,_ZTv0_n16_N8S8279C14D1Ev)();
extern void ABISELECT(_ZTv0_n32_N8S8279C14D0Ev,_ZTv0_n16_N8S8279C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C14__8S8279C12[] = {
  ABISELECT(8,4),
  ABISELECT(32,16),
  ABISELECT(-32,-16),
  ABISELECT(32,16),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C14D1Ev,_ZTv0_n16_N8S8279C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C14D0Ev,_ZTv0_n16_N8S8279C14D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A2__8S8279C14__8S8279C12[] = {
  ABISELECT(-40,-20),
  ABISELECT(24,12),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S8279C14D1Ev,_ZTv0_n12_N8S8279C14D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S8279C14D0Ev,_ZTv0_n12_N8S8279C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S814C5_nt__A2__8S8279C14__8S8279C12[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C14D1Ev,_ZTv0_n12_N8S8279C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C14D0Ev,_ZTv0_n12_N8S8279C14D0Ev),
};
extern void ABISELECT(_ZThn32_N8S8279C14D1Ev,_ZThn16_N8S8279C14D1Ev)();
extern void ABISELECT(_ZThn32_N8S8279C14D0Ev,_ZThn16_N8S8279C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S8279C15__8S8279C14__8S8279C12[] = {
  ABISELECT(-64,-32),
  ABISELECT(-96,-48),
  ABISELECT(-96,-48),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S8279C14D1Ev,_ZThn16_N8S8279C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S8279C14D0Ev,_ZThn16_N8S8279C14D0Ev),
};
extern void ABISELECT(_ZThn40_N8S8279C14D1Ev,_ZThn20_N8S8279C14D1Ev)();
extern void ABISELECT(_ZThn40_N8S8279C14D0Ev,_ZThn20_N8S8279C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C15__A2__8S8279C14__8S8279C12[] = {
  ABISELECT(-104,-52),
  ABISELECT(-104,-52),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N8S8279C14D1Ev,_ZThn20_N8S8279C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N8S8279C14D0Ev,_ZThn20_N8S8279C14D0Ev),
};
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C8__A1__8S8279C12[] = {
  ABISELECT(-128,-68),
  ABISELECT(-128,-68),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C8__A1__8S8279C12[] = {
  0,
  0,
  ABISELECT(128,68),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
extern void _ZN8S8279C16D1Ev();
extern void _ZN8S8279C16D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C16__8S8279C12[] = {
  ABISELECT(48,24),
  ABISELECT(-16,-8),
  ABISELECT(-80,-44),
  ABISELECT(-88,-48),
  ABISELECT(-112,-60),
  ABISELECT(-128,-68),
  ABISELECT(-144,-76),
  ABISELECT(-144,-76),
  ABISELECT(-144,-76),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&_ZN8S8279C16D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C16D0Ev,
};
extern void _ZN7S8279C52v1Ev();
extern void _ZN8S8279C13D1Ev();
extern void _ZN8S8279C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C138S8279C16__A1__8S8279C12[] = {
  ABISELECT(-16,-8),
  ABISELECT(-80,-44),
  ABISELECT(-88,-48),
  ABISELECT(-112,-60),
  ABISELECT(-128,-68),
  ABISELECT(-144,-76),
  ABISELECT(-144,-76),
  ABISELECT(-144,-76),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&_ZN8S8279C13D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C13D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C138S8279C16__A1__8S8279C12[] = {
  0,
  0,
  ABISELECT(144,76),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n56_N8S8279C13D1Ev,_ZTv0_n28_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTv0_n56_N8S8279C13D0Ev,_ZTv0_n28_N8S8279C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C3__8S8279C138S8279C16__A1__8S8279C12[] = {
  ABISELECT(128,68),
  ABISELECT(40,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(128,68),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S8279C13D1Ev,_ZTv0_n28_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S8279C13D0Ev,_ZTv0_n28_N8S8279C13D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S8279C13D1Ev,_ZTv0_n16_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTv0_n32_N8S8279C13D0Ev,_ZTv0_n16_N8S8279C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C138S8279C16__A1__8S8279C12[] = {
  ABISELECT(8,4),
  ABISELECT(112,60),
  ABISELECT(-32,-16),
  ABISELECT(112,60),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C13D1Ev,_ZTv0_n16_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C13D0Ev,_ZTv0_n16_N8S8279C13D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C138S8279C16__A1__8S8279C12[] = {
  ABISELECT(-40,-20),
  ABISELECT(104,56),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S8279C13D1Ev,_ZTv0_n12_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S8279C13D0Ev,_ZTv0_n12_N8S8279C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S814C5_nt__A1__8S8279C138S8279C16__A1__8S8279C12[] = {
  ABISELECT(88,48),
  ABISELECT(88,48),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C13D1Ev,_ZTv0_n12_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C13D0Ev,_ZTv0_n12_N8S8279C13D0Ev),
};
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTv0_n72_N8S8279C13D1Ev,_ZTv0_n36_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTv0_n72_N8S8279C13D0Ev,_ZTv0_n36_N8S8279C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S8279C14__8S8279C138S8279C16__A1__8S8279C12[] = {
  ABISELECT(80,44),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-32,-16),
  ABISELECT(-64,-32),
  ABISELECT(64,36),
  ABISELECT(-64,-32),
  ABISELECT(80,44),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S8279C13D1Ev,_ZTv0_n36_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S8279C13D0Ev,_ZTv0_n36_N8S8279C13D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N8S8279C13D1Ev,_ZTv0_n20_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S8279C13D0Ev,_ZTv0_n20_N8S8279C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C8__A1__8S8279C138S8279C16__A1__8S8279C12[] = {
  ABISELECT(16,8),
  ABISELECT(-128,-68),
  ABISELECT(-128,-68),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C13D1Ev,_ZTv0_n20_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C13D0Ev,_ZTv0_n20_N8S8279C13D0Ev),
};
extern void ABISELECT(_ZTvn8_n72_N8S8279C13D1Ev,_ZTvn4_n36_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTvn8_n72_N8S8279C13D0Ev,_ZTvn4_n36_N8S8279C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C38S8279C14__A1__8S8279C138S8279C16__A1__8S8279C12[] = {
  ABISELECT(-16,-8),
  ABISELECT(-40,-20),
  ABISELECT(-72,-36),
  ABISELECT(-72,-36),
  ABISELECT(72,40),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n72_N8S8279C13D1Ev,_ZTvn4_n36_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n72_N8S8279C13D0Ev,_ZTvn4_n36_N8S8279C13D0Ev),
};
extern void ABISELECT(_ZTvn24_n72_N8S8279C13D1Ev,_ZTvn12_n36_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTvn24_n72_N8S8279C13D0Ev,_ZTvn12_n36_N8S8279C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S814C5_nt8S8279C14__A5__8S8279C138S8279C16__A1__8S8279C12[] = {
  ABISELECT(56,32),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn24_n72_N8S8279C13D1Ev,_ZTvn12_n36_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn24_n72_N8S8279C13D0Ev,_ZTvn12_n36_N8S8279C13D0Ev),
};
extern void ABISELECT(_ZTvn32_n72_N8S8279C13D1Ev,_ZTvn16_n36_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTvn32_n72_N8S8279C13D0Ev,_ZTvn16_n36_N8S8279C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S8279C158S8279C14__8S8279C138S8279C16__A1__8S8279C12[] = {
  ABISELECT(-64,-32),
  ABISELECT(-96,-48),
  ABISELECT(-96,-48),
  ABISELECT(48,28),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n72_N8S8279C13D1Ev,_ZTvn16_n36_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n72_N8S8279C13D0Ev,_ZTvn16_n36_N8S8279C13D0Ev),
};
extern void ABISELECT(_ZTvn40_n72_N8S8279C13D1Ev,_ZTvn20_n36_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTvn40_n72_N8S8279C13D0Ev,_ZTvn20_n36_N8S8279C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C158S8279C14__A3__8S8279C138S8279C16__A1__8S8279C12[] = {
  ABISELECT(-104,-52),
  ABISELECT(-104,-52),
  ABISELECT(40,24),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn40_n72_N8S8279C13D1Ev,_ZTvn20_n36_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn40_n72_N8S8279C13D0Ev,_ZTvn20_n36_N8S8279C13D0Ev),
};
extern void _ZN8S8279C15D1Ev();
extern void _ZN8S8279C15D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C158S8279C16__A1__8S8279C12[] = {
  ABISELECT(-120,-64),
  ABISELECT(-152,-80),
  ABISELECT(-152,-80),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN8S8279C15D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C15D0Ev,
};
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C158S8279C16__A4__8S8279C12[] = {
  ABISELECT(-160,-84),
  ABISELECT(-160,-84),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C88S8279C158S8279C16__A4__8S8279C12[] = {
  0,
  0,
  ABISELECT(160,84),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C158S8279C16__A1__8S8279C12[] = {
  0,
  0,
  ABISELECT(152,80),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev)();
extern void ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C158S8279C16__A1__8S8279C12[] = {
  ABISELECT(8,4),
  ABISELECT(120,64),
  ABISELECT(-32,-16),
  ABISELECT(120,64),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C158S8279C16__A1__8S8279C12[] = {
  ABISELECT(-40,-20),
  ABISELECT(112,60),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZThn8_N8S8279C15D1Ev,_ZThn4_N8S8279C15D1Ev)();
extern void ABISELECT(_ZThn8_N8S8279C15D0Ev,_ZThn4_N8S8279C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C8__8S8279C158S8279C16__A1__8S8279C12[] = {
  ABISELECT(-160,-84),
  ABISELECT(-160,-84),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C15D1Ev,_ZThn4_N8S8279C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C15D0Ev,_ZThn4_N8S8279C15D0Ev),
};
extern void _ZN7S8279C52v1Ev();
extern void _ZN8S8279C17D1Ev();
extern void _ZN8S8279C17D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C178S8279C16__8S8279C12[] = {
  ABISELECT(-144,-76),
  ABISELECT(-176,-92),
  ABISELECT(16,8),
  ABISELECT(-176,-92),
  ABISELECT(-176,-92),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&_ZN8S8279C17D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C17D0Ev,
};
extern void ABISELECT(_ZTv0_n48_N8S8279C17D1Ev,_ZTv0_n24_N8S8279C17D1Ev)();
extern void ABISELECT(_ZThn16_N8S8279C17D1Ev,_ZThn8_N8S8279C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S8279C17D0Ev,_ZTv0_n24_N8S8279C17D0Ev)();
extern void ABISELECT(_ZThn16_N8S8279C17D0Ev,_ZThn8_N8S8279C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S8279C15__8S8279C178S8279C16__8S8279C12[] = {
  ABISELECT(-16,-8),
  ABISELECT(-160,-84),
  ABISELECT(-192,-100),
  ABISELECT(-192,-100),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C17D1Ev,_ZTv0_n24_N8S8279C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C17D0Ev,_ZTv0_n24_N8S8279C17D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C178S8279C16__8S8279C12[] = {
  0,
  0,
  ABISELECT(176,92),
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S8279C17D1Ev,_ZTv0_n16_N8S8279C17D1Ev)();
extern void ABISELECT(_ZTv0_n32_N8S8279C17D0Ev,_ZTv0_n16_N8S8279C17D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C178S8279C16__8S8279C12[] = {
  ABISELECT(8,4),
  ABISELECT(144,76),
  ABISELECT(-32,-16),
  ABISELECT(144,76),
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C17D1Ev,_ZTv0_n16_N8S8279C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C17D0Ev,_ZTv0_n16_N8S8279C17D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C178S8279C16__8S8279C12[] = {
  ABISELECT(-40,-20),
  ABISELECT(136,72),
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTvn8_n48_N8S8279C17D1Ev,_ZTvn4_n24_N8S8279C17D1Ev)();
extern void ABISELECT(_ZTvn8_n48_N8S8279C17D0Ev,_ZTvn4_n24_N8S8279C17D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C15__8S8279C178S8279C16__8S8279C12[] = {
  ABISELECT(-200,-104),
  ABISELECT(-200,-104),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S8279C17D1Ev,_ZTvn4_n24_N8S8279C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S8279C17D0Ev,_ZTvn4_n24_N8S8279C17D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N8S8279C16D1Ev,_ZTv0_n20_N8S8279C16D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S8279C16D0Ev,_ZTv0_n20_N8S8279C16D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C8__8S8279C16__8S8279C12[] = {
  ABISELECT(16,8),
  ABISELECT(-128,-68),
  ABISELECT(-128,-68),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C16D1Ev,_ZTv0_n20_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C16D0Ev,_ZTv0_n20_N8S8279C16D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C16__8S8279C12[] = {
  0,
  0,
  ABISELECT(144,76),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n56_N8S8279C16D1Ev,_ZTv0_n28_N8S8279C16D1Ev)();
extern void ABISELECT(_ZTv0_n56_N8S8279C16D0Ev,_ZTv0_n28_N8S8279C16D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C3__8S8279C16__8S8279C12[] = {
  ABISELECT(128,68),
  ABISELECT(40,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(128,68),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S8279C16D1Ev,_ZTv0_n28_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S8279C16D0Ev,_ZTv0_n28_N8S8279C16D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S8279C16D1Ev,_ZTv0_n16_N8S8279C16D1Ev)();
extern void ABISELECT(_ZTv0_n32_N8S8279C16D0Ev,_ZTv0_n16_N8S8279C16D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C16__8S8279C12[] = {
  ABISELECT(8,4),
  ABISELECT(112,60),
  ABISELECT(-32,-16),
  ABISELECT(112,60),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C16D1Ev,_ZTv0_n16_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C16D0Ev,_ZTv0_n16_N8S8279C16D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C16__8S8279C12[] = {
  ABISELECT(-40,-20),
  ABISELECT(104,56),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S8279C16D1Ev,_ZTv0_n12_N8S8279C16D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S8279C16D0Ev,_ZTv0_n12_N8S8279C16D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S814C5_nt__A2__8S8279C16__8S8279C12[] = {
  ABISELECT(88,48),
  ABISELECT(88,48),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C16D1Ev,_ZTv0_n12_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C16D0Ev,_ZTv0_n12_N8S8279C16D0Ev),
};
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTv0_n72_N8S8279C16D1Ev,_ZTv0_n36_N8S8279C16D1Ev)();
extern void ABISELECT(_ZTv0_n72_N8S8279C16D0Ev,_ZTv0_n36_N8S8279C16D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S8279C14__8S8279C16__8S8279C12[] = {
  ABISELECT(80,44),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-32,-16),
  ABISELECT(-64,-32),
  ABISELECT(64,36),
  ABISELECT(-64,-32),
  ABISELECT(80,44),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S8279C16D1Ev,_ZTv0_n36_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S8279C16D0Ev,_ZTv0_n36_N8S8279C16D0Ev),
};
extern void ABISELECT(_ZTvn8_n72_N8S8279C16D1Ev,_ZTvn4_n36_N8S8279C16D1Ev)();
extern void ABISELECT(_ZTvn8_n72_N8S8279C16D0Ev,_ZTvn4_n36_N8S8279C16D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C38S8279C14__A1__8S8279C16__8S8279C12[] = {
  ABISELECT(-16,-8),
  ABISELECT(-40,-20),
  ABISELECT(-72,-36),
  ABISELECT(-72,-36),
  ABISELECT(72,40),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n72_N8S8279C16D1Ev,_ZTvn4_n36_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n72_N8S8279C16D0Ev,_ZTvn4_n36_N8S8279C16D0Ev),
};
extern void ABISELECT(_ZTvn24_n72_N8S8279C16D1Ev,_ZTvn12_n36_N8S8279C16D1Ev)();
extern void ABISELECT(_ZTvn24_n72_N8S8279C16D0Ev,_ZTvn12_n36_N8S8279C16D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S814C5_nt8S8279C14__A5__8S8279C16__8S8279C12[] = {
  ABISELECT(56,32),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn24_n72_N8S8279C16D1Ev,_ZTvn12_n36_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn24_n72_N8S8279C16D0Ev,_ZTvn12_n36_N8S8279C16D0Ev),
};
extern void ABISELECT(_ZTvn32_n72_N8S8279C16D1Ev,_ZTvn16_n36_N8S8279C16D1Ev)();
extern void ABISELECT(_ZTvn32_n72_N8S8279C16D0Ev,_ZTvn16_n36_N8S8279C16D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S8279C158S8279C14__8S8279C16__8S8279C12[] = {
  ABISELECT(-64,-32),
  ABISELECT(-96,-48),
  ABISELECT(-96,-48),
  ABISELECT(48,28),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n72_N8S8279C16D1Ev,_ZTvn16_n36_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n72_N8S8279C16D0Ev,_ZTvn16_n36_N8S8279C16D0Ev),
};
extern void ABISELECT(_ZTvn40_n72_N8S8279C16D1Ev,_ZTvn20_n36_N8S8279C16D1Ev)();
extern void ABISELECT(_ZTvn40_n72_N8S8279C16D0Ev,_ZTvn20_n36_N8S8279C16D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C158S8279C14__A3__8S8279C16__8S8279C12[] = {
  ABISELECT(-104,-52),
  ABISELECT(-104,-52),
  ABISELECT(40,24),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn40_n72_N8S8279C16D1Ev,_ZTvn20_n36_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn40_n72_N8S8279C16D0Ev,_ZTvn20_n36_N8S8279C16D0Ev),
};
extern void ABISELECT(_ZThn8_N8S8279C16D1Ev,_ZThn4_N8S8279C16D1Ev)();
extern void ABISELECT(_ZThn8_N8S8279C16D0Ev,_ZThn4_N8S8279C16D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S8279C15__A__8S8279C16__8S8279C12[] = {
  ABISELECT(-120,-64),
  ABISELECT(-152,-80),
  ABISELECT(-152,-80),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C16D1Ev,_ZThn4_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C16D0Ev,_ZThn4_N8S8279C16D0Ev),
};
extern void ABISELECT(_ZThn16_N8S8279C16D1Ev,_ZThn8_N8S8279C16D1Ev)();
extern void ABISELECT(_ZThn16_N8S8279C16D0Ev,_ZThn8_N8S8279C16D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C15__A4__8S8279C16__8S8279C12[] = {
  ABISELECT(-160,-84),
  ABISELECT(-160,-84),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S8279C16D1Ev,_ZThn8_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S8279C16D0Ev,_ZThn8_N8S8279C16D0Ev),
};
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZThn32_N8S8279C16D1Ev,_ZThn16_N8S8279C16D1Ev)();
extern void ABISELECT(_ZThn32_N8S8279C16D0Ev,_ZThn16_N8S8279C16D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S8279C17__8S8279C16__8S8279C12[] = {
  ABISELECT(-144,-76),
  ABISELECT(-176,-92),
  ABISELECT(16,8),
  ABISELECT(-176,-92),
  ABISELECT(-176,-92),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S8279C16D1Ev,_ZThn16_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S8279C16D0Ev,_ZThn16_N8S8279C16D0Ev),
};
extern void ABISELECT(_ZTv0_n48_N8S8279C16D1Ev,_ZTv0_n24_N8S8279C16D1Ev)();
extern void ABISELECT(_ZThn48_N8S8279C16D1Ev,_ZThn24_N8S8279C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S8279C16D0Ev,_ZTv0_n24_N8S8279C16D0Ev)();
extern void ABISELECT(_ZThn48_N8S8279C16D0Ev,_ZThn24_N8S8279C16D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S8279C15__A2__8S8279C16__8S8279C12[] = {
  ABISELECT(-48,-24),
  ABISELECT(-160,-84),
  ABISELECT(-192,-100),
  ABISELECT(-192,-100),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C16D1Ev,_ZTv0_n24_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C16D0Ev,_ZTv0_n24_N8S8279C16D0Ev),
};
extern void ABISELECT(_ZTvn8_n48_N8S8279C16D1Ev,_ZTvn4_n24_N8S8279C16D1Ev)();
extern void ABISELECT(_ZTvn8_n48_N8S8279C16D0Ev,_ZTvn4_n24_N8S8279C16D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C15__A5__8S8279C16__8S8279C12[] = {
  ABISELECT(-200,-104),
  ABISELECT(-200,-104),
  ABISELECT(-56,-28),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S8279C16D1Ev,_ZTvn4_n24_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S8279C16D0Ev,_ZTvn4_n24_N8S8279C16D0Ev),
};
extern void _ZN8S8279C15D1Ev();
extern void _ZN8S8279C15D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C15__A2__8S8279C12[] = {
  ABISELECT(-160,-84),
  ABISELECT(-192,-100),
  ABISELECT(-192,-100),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN8S8279C15D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C15D0Ev,
};
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C15__A5__8S8279C12[] = {
  ABISELECT(-200,-104),
  ABISELECT(-200,-104),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C88S8279C15__A5__8S8279C12[] = {
  0,
  0,
  ABISELECT(200,104),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C15__A2__8S8279C12[] = {
  0,
  0,
  ABISELECT(192,100),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev)();
extern void ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C15__A2__8S8279C12[] = {
  ABISELECT(8,4),
  ABISELECT(160,84),
  ABISELECT(-32,-16),
  ABISELECT(160,84),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C15__A2__8S8279C12[] = {
  ABISELECT(-40,-20),
  ABISELECT(152,80),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZThn8_N8S8279C15D1Ev,_ZThn4_N8S8279C15D1Ev)();
extern void ABISELECT(_ZThn8_N8S8279C15D0Ev,_ZThn4_N8S8279C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C8__8S8279C15__A2__8S8279C12[] = {
  ABISELECT(-200,-104),
  ABISELECT(-200,-104),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C15D1Ev,_ZThn4_N8S8279C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C15D0Ev,_ZThn4_N8S8279C15D0Ev),
};
extern void _ZN8S8279C18D1Ev();
extern void _ZN8S8279C18D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C18__8S8279C12[] = {
  ABISELECT(40,24),
  ABISELECT(32,20),
  ABISELECT(-216,-112),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C18[0]),
  (VTBL_ENTRY)&_ZN8S8279C18D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C18D0Ev,
};
extern void _ZN7S8279C6D1Ev();
extern void _ZN7S8279C6D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C68S8279C18__A1__8S8279C12[] = {
  ABISELECT(-216,-112),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C6[0]),
  (VTBL_ENTRY)&_ZN7S8279C6D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C6D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C68S8279C18__A4__8S8279C12[] = {
  ABISELECT(-224,-116),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C68S8279C18__A1__8S8279C12[] = {
  ABISELECT(-224,-116),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S8279C6[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
static  VTBL_ENTRY _tg__ZTV8S8279C19__8S8279C18__8S8279C12[] = {
  ABISELECT(-248,-132),
  ABISELECT(8,4),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI8S8279C18[0]),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C20__8S8279C18__8S8279C12[] = {
  0,
  ABISELECT(-256,-136),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI8S8279C18[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C18__8S8279C12[] = {
  ABISELECT(-224,-116),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C18[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
static  VTBL_ENTRY _tg__ZTV8S8279C19__8S8279C12[] = {
  ABISELECT(-248,-132),
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C19[0]),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C20__8S8279C19__8S8279C12[] = {
  0,
  ABISELECT(-256,-136),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C19[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C20__8S8279C12[] = {
  ABISELECT(-256,-136),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C20[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C58S8279C20__A3__8S8279C12[] = {
  ABISELECT(-256,-136),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
static  VTT_ENTRY vtt_S8279C12[] = {
  {&(_ZTV8S8279C12[17]),  17,163},
  {&(_ZTV8S8279C12[17]),  17,163},
  {&(_ZTV8S8279C12[17]),  17,163},
  {&(_ZTV8S8279C12[27]),  27,163},
  {&(_ZTV8S8279C12[34]),  34,163},
  {&(_ZTV8S8279C12[39]),  39,163},
  {&(_ZTV8S8279C12[43]),  43,163},
  {&(_ZTV8S8279C12[54]),  54,163},
  {&(_ZTV8S8279C12[87]),  87,163},
  {&(_ZTV8S8279C12[63]),  63,163},
  {&(_ZTV8S8279C12[67]),  67,163},
  {&(_ZTV8S8279C12[74]),  74,163},
  {&(_ZTV8S8279C12[80]),  80,163},
  {&(_ZTV8S8279C12[101]),  101,163},
  {&(_ZTV8S8279C12[109]),  109,163},
  {&(_ZTV8S8279C12[115]),  115,163},
  {&(_ZTV8S8279C12[124]),  124,163},
  {&(_ZTV8S8279C12[133]),  133,163},
  {&(_ZTV8S8279C12[139]),  139,163},
  {&(_ZTV8S8279C12[148]),  148,163},
  {&(_ZTV8S8279C12[158]),  158,163},
  {&(_ZTV8S8279C12[162]),  162,163},
  {&(_ZTV8S8279C12[153]),  153,163},
  {&(_tg__ZTV8S8279C13__8S8279C12[10]),  10,13},
  {&(_tg__ZTV8S8279C13__8S8279C12[10]),  10,13},
  {&(_tg__ZTV7S8279C3__8S8279C13__8S8279C12[7]),  7,9},
  {&(_tg__ZTV7S8279C6__8S8279C13__8S8279C12[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C13__8S8279C12[3]),  3,4},
  {&(_tg__ZTV9S814C5_nt__A1__8S8279C13__8S8279C12[3]),  3,5},
  {&(_tg__ZTV8S8279C14__8S8279C13__8S8279C12[9]),  9,12},
  {&(_tg__ZTV7S8279C8__A1__8S8279C13__8S8279C12[5]),  5,7},
  {&(_tg__ZTV7S8279C38S8279C14__A1__8S8279C13__8S8279C12[6]),  6,8},
  {&(_tg__ZTV9S814C5_nt8S8279C14__A5__8S8279C13__8S8279C12[2]),  2,4},
  {&(_tg__ZTV8S8279C158S8279C14__8S8279C13__8S8279C12[5]),  5,7},
  {&(_tg__ZTV7S8279C88S8279C158S8279C14__A3__8S8279C13__8S8279C12[4]),  4,6},
  {&(_tg__ZTV7S8279C5__8S8279C12[3]),  3,4},
  {&(_tg__ZTV7S8279C3__8S8279C12[6]),  6,8},
  {&(_tg__ZTV7S8279C87S8279C3__8S8279C12[4]),  4,6},
  {&(_tg__ZTV7S8279C5__7S8279C87S8279C3__8S8279C12[4]),  4,5},
  {&(_tg__ZTV7S8279C5__7S8279C3__8S8279C12[4]),  4,5},
  {&(_tg__ZTV7S8279C6__7S8279C3__8S8279C12[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__7S8279C3__8S8279C12[3]),  3,4},
  {&(_tg__ZTV9S814C5_nt__A1__7S8279C3__8S8279C12[3]),  3,5},
  {&(_tg__ZTV7S8279C6__8S8279C12[3]),  3,5},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C12[3]),  3,4},
  {&(_tg__ZTV7S8279C5__7S8279C6__8S8279C12[3]),  3,4},
  {&(_tg__ZTV8S8279C14__8S8279C12[7]),  7,10},
  {&(_tg__ZTV7S8279C58S8279C14__A2__8S8279C12[3]),  3,4},
  {&(_tg__ZTV7S8279C38S8279C14__A1__8S8279C12[6]),  6,8},
  {&(_tg__ZTV7S8279C87S8279C38S8279C14__A2__8S8279C12[4]),  4,6},
  {&(_tg__ZTV7S8279C5__7S8279C87S8279C38S8279C14__A2__8S8279C12[4]),  4,5},
  {&(_tg__ZTV7S8279C5__7S8279C38S8279C14__A1__8S8279C12[4]),  4,5},
  {&(_tg__ZTV7S8279C6__7S8279C38S8279C14__A1__8S8279C12[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__7S8279C38S8279C14__A1__8S8279C12[3]),  3,4},
  {&(_tg__ZTV9S814C5_nt__A1__7S8279C38S8279C14__A1__8S8279C12[3]),  3,5},
  {&(_tg__ZTV8S8279C158S8279C14__8S8279C12[5]),  5,7},
  {&(_tg__ZTV7S8279C88S8279C158S8279C14__A3__8S8279C12[4]),  4,6},
  {&(_tg__ZTV7S8279C5__7S8279C88S8279C158S8279C14__A3__8S8279C12[4]),  4,5},
  {&(_tg__ZTV7S8279C5__8S8279C158S8279C14__8S8279C12[4]),  4,5},
  {&(_tg__ZTV7S8279C6__8S8279C158S8279C14__8S8279C12[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C158S8279C14__8S8279C12[3]),  3,4},
  {&(_tg__ZTV7S8279C8__8S8279C158S8279C14__8S8279C12[4]),  4,6},
  {&(_tg__ZTV7S8279C8__8S8279C14__8S8279C12[5]),  5,7},
  {&(_tg__ZTV7S8279C5__8S8279C14__8S8279C12[4]),  4,5},
  {&(_tg__ZTV7S8279C3__8S8279C14__8S8279C12[6]),  6,8},
  {&(_tg__ZTV7S8279C6__8S8279C14__8S8279C12[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A2__8S8279C14__8S8279C12[3]),  3,4},
  {&(_tg__ZTV9S814C5_nt__A2__8S8279C14__8S8279C12[3]),  3,5},
  {&(_tg__ZTV8S8279C15__8S8279C14__8S8279C12[5]),  5,7},
  {&(_tg__ZTV7S8279C88S8279C15__A2__8S8279C14__8S8279C12[4]),  4,6},
  {&(_tg__ZTV7S8279C8__A1__8S8279C12[4]),  4,6},
  {&(_tg__ZTV7S8279C5__7S8279C8__A1__8S8279C12[4]),  4,5},
  {&(_tg__ZTV8S8279C16__8S8279C12[11]),  11,14},
  {&(_tg__ZTV8S8279C138S8279C16__A1__8S8279C12[10]),  10,13},
  {&(_tg__ZTV7S8279C5__8S8279C138S8279C16__A1__8S8279C12[4]),  4,5},
  {&(_tg__ZTV7S8279C3__8S8279C138S8279C16__A1__8S8279C12[7]),  7,9},
  {&(_tg__ZTV7S8279C6__8S8279C138S8279C16__A1__8S8279C12[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C138S8279C16__A1__8S8279C12[3]),  3,4},
  {&(_tg__ZTV9S814C5_nt__A1__8S8279C138S8279C16__A1__8S8279C12[3]),  3,5},
  {&(_tg__ZTV8S8279C14__8S8279C138S8279C16__A1__8S8279C12[9]),  9,12},
  {&(_tg__ZTV7S8279C8__A1__8S8279C138S8279C16__A1__8S8279C12[5]),  5,7},
  {&(_tg__ZTV7S8279C38S8279C14__A1__8S8279C138S8279C16__A1__8S8279C12[6]),  6,8},
  {&(_tg__ZTV9S814C5_nt8S8279C14__A5__8S8279C138S8279C16__A1__8S8279C12[2]),  2,4},
  {&(_tg__ZTV8S8279C158S8279C14__8S8279C138S8279C16__A1__8S8279C12[5]),  5,7},
  {&(_tg__ZTV7S8279C88S8279C158S8279C14__A3__8S8279C138S8279C16__A1__8S8279C12[4]),  4,6},
  {&(_tg__ZTV8S8279C158S8279C16__A1__8S8279C12[5]),  5,7},
  {&(_tg__ZTV7S8279C88S8279C158S8279C16__A4__8S8279C12[4]),  4,6},
  {&(_tg__ZTV7S8279C5__7S8279C88S8279C158S8279C16__A4__8S8279C12[4]),  4,5},
  {&(_tg__ZTV7S8279C5__8S8279C158S8279C16__A1__8S8279C12[4]),  4,5},
  {&(_tg__ZTV7S8279C6__8S8279C158S8279C16__A1__8S8279C12[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C158S8279C16__A1__8S8279C12[3]),  3,4},
  {&(_tg__ZTV7S8279C8__8S8279C158S8279C16__A1__8S8279C12[4]),  4,6},
  {&(_tg__ZTV8S8279C178S8279C16__8S8279C12[7]),  7,10},
  {&(_tg__ZTV8S8279C15__8S8279C178S8279C16__8S8279C12[6]),  6,8},
  {&(_tg__ZTV7S8279C5__8S8279C178S8279C16__8S8279C12[4]),  4,5},
  {&(_tg__ZTV7S8279C6__8S8279C178S8279C16__8S8279C12[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C178S8279C16__8S8279C12[3]),  3,4},
  {&(_tg__ZTV7S8279C88S8279C15__8S8279C178S8279C16__8S8279C12[4]),  4,6},
  {&(_tg__ZTV7S8279C8__8S8279C16__8S8279C12[5]),  5,7},
  {&(_tg__ZTV7S8279C5__8S8279C16__8S8279C12[4]),  4,5},
  {&(_tg__ZTV7S8279C3__8S8279C16__8S8279C12[7]),  7,9},
  {&(_tg__ZTV7S8279C6__8S8279C16__8S8279C12[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C16__8S8279C12[3]),  3,4},
  {&(_tg__ZTV9S814C5_nt__A2__8S8279C16__8S8279C12[3]),  3,5},
  {&(_tg__ZTV8S8279C14__8S8279C16__8S8279C12[9]),  9,12},
  {&(_tg__ZTV7S8279C38S8279C14__A1__8S8279C16__8S8279C12[6]),  6,8},
  {&(_tg__ZTV9S814C5_nt8S8279C14__A5__8S8279C16__8S8279C12[2]),  2,4},
  {&(_tg__ZTV8S8279C158S8279C14__8S8279C16__8S8279C12[5]),  5,7},
  {&(_tg__ZTV7S8279C88S8279C158S8279C14__A3__8S8279C16__8S8279C12[4]),  4,6},
  {&(_tg__ZTV8S8279C15__A__8S8279C16__8S8279C12[5]),  5,7},
  {&(_tg__ZTV7S8279C88S8279C15__A4__8S8279C16__8S8279C12[4]),  4,6},
  {&(_tg__ZTV8S8279C17__8S8279C16__8S8279C12[7]),  7,10},
  {&(_tg__ZTV8S8279C15__A2__8S8279C16__8S8279C12[6]),  6,8},
  {&(_tg__ZTV7S8279C88S8279C15__A5__8S8279C16__8S8279C12[4]),  4,6},
  {&(_tg__ZTV8S8279C15__A2__8S8279C12[5]),  5,7},
  {&(_tg__ZTV7S8279C88S8279C15__A5__8S8279C12[4]),  4,6},
  {&(_tg__ZTV7S8279C5__7S8279C88S8279C15__A5__8S8279C12[4]),  4,5},
  {&(_tg__ZTV7S8279C5__8S8279C15__A2__8S8279C12[4]),  4,5},
  {&(_tg__ZTV7S8279C6__8S8279C15__A2__8S8279C12[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C15__A2__8S8279C12[3]),  3,4},
  {&(_tg__ZTV7S8279C8__8S8279C15__A2__8S8279C12[4]),  4,6},
  {&(_tg__ZTV8S8279C18__8S8279C12[5]),  5,7},
  {&(_tg__ZTV7S8279C68S8279C18__A1__8S8279C12[3]),  3,5},
  {&(_tg__ZTV7S8279C57S8279C68S8279C18__A4__8S8279C12[3]),  3,4},
  {&(_tg__ZTV7S8279C5__7S8279C68S8279C18__A1__8S8279C12[3]),  3,4},
  {&(_tg__ZTV8S8279C19__8S8279C18__8S8279C12[4]),  4,4},
  {&(_tg__ZTV8S8279C20__8S8279C18__8S8279C12[4]),  4,5},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C18__8S8279C12[3]),  3,4},
  {&(_tg__ZTV8S8279C19__8S8279C12[4]),  4,4},
  {&(_tg__ZTV8S8279C20__8S8279C19__8S8279C12[4]),  4,5},
  {&(_tg__ZTV8S8279C20__8S8279C12[3]),  3,4},
  {&(_tg__ZTV7S8279C58S8279C20__A3__8S8279C12[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8S8279C12[];
extern  VTBL_ENTRY _ZTV8S8279C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C12[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S8279C16D0Ev,_ZTv0_n24_N8S8279C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S8279C16D0Ev,_ZThn24_N8S8279C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S8279C16D1Ev,_ZTv0_n24_N8S8279C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S8279C16D1Ev,_ZThn24_N8S8279C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S8279C17D0Ev,_ZTv0_n24_N8S8279C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S8279C17D0Ev,_ZThn8_N8S8279C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S8279C17D1Ev,_ZTv0_n24_N8S8279C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S8279C17D1Ev,_ZThn8_N8S8279C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S8279C14D0Ev,_ZTv0_n20_N8S8279C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N8S8279C14D0Ev,_ZThn36_N8S8279C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S8279C14D1Ev,_ZTv0_n20_N8S8279C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N8S8279C14D1Ev,_ZThn36_N8S8279C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S8279C3D0Ev,_ZTv0_n12_N7S8279C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N7S8279C3D0Ev,_ZThn20_N7S8279C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S8279C3D1Ev,_ZTv0_n12_N7S8279C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N7S8279C3D1Ev,_ZThn20_N7S8279C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S8279C3D0Ev,_ZTv0_n16_N7S8279C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7S8279C3D0Ev,_ZThn8_N7S8279C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S8279C3D1Ev,_ZTv0_n16_N7S8279C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7S8279C3D1Ev,_ZThn8_N7S8279C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S8279C13D0Ev,_ZTv0_n20_N8S8279C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn128_N8S8279C13D0Ev,_ZThn68_N8S8279C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S8279C13D1Ev,_ZTv0_n20_N8S8279C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn128_N8S8279C13D1Ev,_ZThn68_N8S8279C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S8279C13D0Ev,_ZTv0_n36_N8S8279C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N8S8279C13D0Ev,_ZThn32_N8S8279C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S8279C13D1Ev,_ZTv0_n36_N8S8279C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N8S8279C13D1Ev,_ZThn32_N8S8279C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S8279C13D0Ev,_ZTv0_n12_N8S8279C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S8279C13D0Ev,_ZThn28_N8S8279C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S8279C13D1Ev,_ZTv0_n12_N8S8279C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S8279C13D1Ev,_ZThn28_N8S8279C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C13D0Ev,_ZTv0_n16_N8S8279C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S8279C13D0Ev,_ZThn16_N8S8279C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C13D1Ev,_ZTv0_n16_N8S8279C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S8279C13D1Ev,_ZThn16_N8S8279C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S8279C13D0Ev,_ZTv0_n28_N8S8279C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S8279C13D0Ev,_ZThn8_N8S8279C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S8279C13D1Ev,_ZTv0_n28_N8S8279C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S8279C13D1Ev,_ZThn8_N8S8279C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S8279C12D0Ev,_ZTv0_n24_N8S8279C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn216_N8S8279C12D0Ev,_ZThn112_N8S8279C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn192_N8S8279C12D0Ev,_ZThn100_N8S8279C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S8279C12D1Ev,_ZTv0_n24_N8S8279C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn216_N8S8279C12D1Ev,_ZThn112_N8S8279C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn192_N8S8279C12D1Ev,_ZThn100_N8S8279C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N8S8279C12D0Ev,_ZTv0_n48_N8S8279C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn144_N8S8279C12D0Ev,_ZThn76_N8S8279C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N8S8279C12D1Ev,_ZTv0_n48_N8S8279C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn144_N8S8279C12D1Ev,_ZThn76_N8S8279C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S8279C12D0Ev,_ZTv0_n20_N8S8279C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn128_N8S8279C12D0Ev,_ZThn68_N8S8279C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S8279C12D1Ev,_ZTv0_n20_N8S8279C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn128_N8S8279C12D1Ev,_ZThn68_N8S8279C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S8279C12D0Ev,_ZTv0_n36_N8S8279C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N8S8279C12D0Ev,_ZThn32_N8S8279C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S8279C12D1Ev,_ZTv0_n36_N8S8279C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N8S8279C12D1Ev,_ZThn32_N8S8279C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S8279C12D0Ev,_ZTv0_n12_N8S8279C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S8279C12D0Ev,_ZThn28_N8S8279C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S8279C12D1Ev,_ZTv0_n12_N8S8279C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S8279C12D1Ev,_ZThn28_N8S8279C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C12D0Ev,_ZTv0_n16_N8S8279C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S8279C12D0Ev,_ZThn16_N8S8279C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C12D1Ev,_ZTv0_n16_N8S8279C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S8279C12D1Ev,_ZThn16_N8S8279C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S8279C12D0Ev,_ZTv0_n28_N8S8279C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S8279C12D0Ev,_ZThn8_N8S8279C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S8279C12D1Ev,_ZTv0_n28_N8S8279C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S8279C12D1Ev,_ZThn8_N8S8279C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n88_N8S8279C12D0Ev,_ZTv0_n44_N8S8279C12D0Ev), // 
  (VTBL_ENTRY)_ZN8S8279C12D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n88_N8S8279C12D1Ev,_ZTv0_n44_N8S8279C12D1Ev), // 
  (VTBL_ENTRY)_ZN8S8279C12D1Ev,
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S8279C12 = {  "S8279C12", // class name
  bases_S8279C12, 40,
  &(vtc_S8279C12[0]), // expected_vtbl_contents
  &(vtt_S8279C12[0]), // expected_vtt_contents
  ABISELECT(272,144), // object size
  NSPAIRA(_ZTI8S8279C12),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S8279C12),163, //virtual function table var
  17, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S8279C12),132, //virtual table table var
  39, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8279C23  : virtual S8279C8 {
  int s8279c23f0;
  virtual  ~S8279C23(); // _ZN8S8279C23D2Ev
  S8279C23(); // tgen
};
//SIG(-1 S8279C23) C1{ VBC2{ VBC3{ m} VBC4{ VBC3 v1} BC5{ vd m} vd Fi:4} vd Fi}


 S8279C23 ::~S8279C23(){ note_dtor("S8279C23", this);}
S8279C23 ::S8279C23(){ note_ctor("S8279C23", this);} // tgen

static void Test_S8279C23()
{
  extern Class_Descriptor cd_S8279C23;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S8279C23, buf);
    S8279C23 *dp, &lv = *(dp=new (buf) S8279C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S8279C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8279C23)");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C8*), 0, "S8279C23");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C5*), 0, "S8279C23");
    check_base_class_offset(lv, (S8279C5*)(S8279C8*), 0, "S8279C23");
    check_base_class_offset(lv, (S814C5_nt*)(S8279C8*), ABISELECT(16,8), "S8279C23");
    check_base_class_offset(lv, (S8279C8*), ABISELECT(16,8), "S8279C23");
    check_field_offset(lv, s8279c23f0, ABISELECT(8,4), "S8279C23.s8279c23f0");
    test_class_info(&lv, &cd_S8279C23);
    dp->~S8279C23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8279C23(Test_S8279C23, "S8279C23", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN8S8279C23C1Ev();
extern void _ZN8S8279C23D2Ev();
Name_Map name_map_S8279C23[] = {
  NSPAIR(_ZN8S8279C23C1Ev),
  NSPAIR(_ZN8S8279C23D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S694C11_nt;
extern VTBL_ENTRY _ZTI10S694C11_nt[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C8;
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
static Base_Class bases_S8279C23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S694C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S8279C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S814C5_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S8279C8,    ABISELECT(16,8), //bcp->offset
    9, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S8279C23[];
extern void _ZN7S8279C52v1Ev();
extern void _ZN8S8279C23D1Ev();
extern void _ZN8S8279C23D0Ev();
extern void ABISELECT(_ZTv0_n40_N8S8279C23D1Ev,_ZTv0_n20_N8S8279C23D1Ev)();
extern void ABISELECT(_ZThn16_N8S8279C23D1Ev,_ZThn8_N8S8279C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S8279C23D0Ev,_ZTv0_n20_N8S8279C23D0Ev)();
extern void ABISELECT(_ZThn16_N8S8279C23D0Ev,_ZThn8_N8S8279C23D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S8279C23[] = {
  0,
  ABISELECT(16,8),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C23[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&_ZN8S8279C23D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C23D0Ev,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S8279C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C23D1Ev,_ZTv0_n20_N8S8279C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C23D0Ev,_ZTv0_n20_N8S8279C23D0Ev),
};
extern VTBL_ENTRY _ZTV8S8279C23[];
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C8__8S8279C23[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C8__8S8279C23[] = {
  0,
  0,
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C23[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
static  VTT_ENTRY vtt_S8279C23[] = {
  {&(_ZTV8S8279C23[6]),  6,16},
  {&(_ZTV8S8279C23[14]),  14,16},
  {&(_ZTV8S8279C23[6]),  6,16},
  {&(_tg__ZTV7S8279C8__8S8279C23[4]),  4,6},
  {&(_tg__ZTV7S8279C5__7S8279C8__8S8279C23[4]),  4,5},
  {&(_tg__ZTV7S8279C5__8S8279C23[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8S8279C23[];
extern  VTBL_ENTRY _ZTV8S8279C23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C23[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S8279C23D0Ev,_ZTv0_n20_N8S8279C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S8279C23D0Ev,_ZThn8_N8S8279C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S8279C23D1Ev,_ZTv0_n20_N8S8279C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S8279C23D1Ev,_ZThn8_N8S8279C23D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S8279C23 = {  "S8279C23", // class name
  bases_S8279C23, 4,
  &(vtc_S8279C23[0]), // expected_vtbl_contents
  &(vtt_S8279C23[0]), // expected_vtt_contents
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI8S8279C23),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S8279C23),16, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S8279C23),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8279C22  {
  ::S8279C23 s8279c22f0;
  void  mf8279c22(); // _ZN8S8279C229mf8279c22Ev
};
//SIG(-1 S8279C22) C1{ m FC2{ VBC3{ VBC4{ m} VBC5{ VBC4 v1} BC6{ vd m} vd Fi:4} vd Fi}}


void  S8279C22 ::mf8279c22(){}

static void Test_S8279C22()
{
  {
    init_simple_test("S8279C22");
    static S8279C22 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S8279C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8279C22)");
    check_field_offset(lv, s8279c22f0, 0, "S8279C22.s8279c22f0");
  }
}
static Arrange_To_Call_Me vS8279C22(Test_S8279C22, "S8279C22", ABISELECT(32,16));

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S8279C22[];
VTBL_ENTRY *P__ZTI8S8279C22 = _ZTI8S8279C22; 
Class_Descriptor cd_S8279C22 = {  "S8279C22", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI8S8279C22),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S8279C24_nt  {
  void  mf8279c24(); // _ZN11S8279C24_nt9mf8279c24Ev
};
//SIG(1 S8279C24_nt) U1{ m}

#endif // __cplusplus
#ifdef __cplusplus

struct  S8279C11  : S8279C12 , S8279C22 {
  void *s8279c11f0[4];
  ::S8279C24_nt s8279c11f1;
  virtual  ~S8279C11(); // _ZN8S8279C11D2Ev
  S8279C11(); // tgen
};
//SIG(-1 S8279C11) C1{ BC2{ VBC3{ VBC4{ m} VBC5{ VBC4 v1} VBC6{ VBC4 VBC5 VBC7{ BC8{ vd m} BC5 vd FC9{}} VBC8 BC10{ VBC4 VBC5 BC8 vd Fi:4}} VBC11{ VBC10 BC5 BC6 BC8 BC12{ BC8 VBC4 VBC5 VBC7 BC10 vd} vd Fi[2]} vd} VBC13{ VBC10 BC3 BC12 BC14{ VBC12 vd} Fp} VBC15{ VBC16{ VBC17{ BC5 Fp}} BC7 vd Fi:32 FC18{ m}} Fi} BC19{ m FC20{ VBC10 vd Fi}} vd Fp[4] FU21{ m}}


 S8279C11 ::~S8279C11(){ note_dtor("S8279C11", this);}
S8279C11 ::S8279C11(){ note_ctor("S8279C11", this);} // tgen

static void Test_S8279C11()
{
  extern Class_Descriptor cd_S8279C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(44,46)];
    init_test(&cd_S8279C11, buf);
    S8279C11 *dp, &lv = *(dp=new (buf) S8279C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(344,180), "sizeof(S8279C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8279C11)");
    /*is_ambiguous_... S8279C11::S8279C13 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C13*), 0, "S8279C11");
    /*is_ambiguous_... S8279C11::S8279C5 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C5*), 0, "S8279C11");
    /*is_ambiguous_... S8279C11::S8279C3 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C3*), 0, "S8279C11");
    /*is_ambiguous_... S8279C11::S8279C6 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C5*)(S8279C6*), 0, "S8279C11");
    /*is_ambiguous_... S8279C11::S8279C3 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C8*)(S8279C3*), 0, "S8279C11");
    /*is_ambiguous_... S8279C11::S8279C8 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C8*), 0, "S8279C11");
    /*is_ambiguous_... S8279C14::S8279C5 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C5*)(S8279C14*), 0, "S8279C11");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C3*)(S8279C14*), 0, "S8279C11");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C8*)(S8279C3*)(S8279C14*), 0, "S8279C11");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C15*)(S8279C14*), 0, "S8279C11");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C8*)(S8279C15*)(S8279C14*), 0, "S8279C11");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C13*)(S8279C16*), 0, "S8279C11");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C15*)(S8279C16*), 0, "S8279C11");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C8*)(S8279C15*)(S8279C16*), 0, "S8279C11");
    /*is_ambiguous_... S8279C11::S8279C15 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C15*), 0, "S8279C11");
    /*is_ambiguous_... S8279C11::S8279C15 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C8*)(S8279C15*), 0, "S8279C11");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C5*)(S8279C20*), 0, "S8279C11");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C5*)(S8279C6*)(S8279C18*), 0, "S8279C11");
    /*is_ambiguous_... S8279C11::S8279C13 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C13*), 0, "S8279C11");
    /*is_ambiguous_... S8279C11::S8279C3 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C3*), 0, "S8279C11");
    /*is_ambiguous_... S8279C11::S8279C3 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C8*)(S8279C3*), 0, "S8279C11");
    /*is_ambiguous_... S8279C11::S8279C8 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C8*), 0, "S8279C11");
    /*is_ambiguous_... S8279C3::S8279C5 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C3*)(S8279C14*), 0, "S8279C11");
    check_base_class_offset(lv, (S8279C5*)(S8279C8*)(S8279C3*)(S8279C14*), 0, "S8279C11");
    /*is_ambiguous_... S8279C15::S8279C5 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C15*)(S8279C14*), 0, "S8279C11");
    check_base_class_offset(lv, (S8279C5*)(S8279C8*)(S8279C15*)(S8279C14*), 0, "S8279C11");
    /*is_ambiguous_... S8279C13::S8279C5 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C13*)(S8279C16*), 0, "S8279C11");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C15*)(S8279C16*), 0, "S8279C11");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C8*)(S8279C15*)(S8279C16*), 0, "S8279C11");
    /*is_ambiguous_... S8279C11::S8279C15 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C15*), 0, "S8279C11");
    /*is_ambiguous_... S8279C11::S8279C15 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C8*)(S8279C15*), 0, "S8279C11");
    /*is_ambiguous_... S8279C11::S8279C6 */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C6*), ABISELECT(104,52), "S8279C11");
    /*is_ambiguous_... S8279C11::S8279C6 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C6*), ABISELECT(112,56), "S8279C11");
    /*is_ambiguous_... S8279C11::S8279C3 */ AMB_check_base_class_offset(lv, (S8279C6*)(S8279C3*), ABISELECT(104,52), "S8279C11");
    check_base_class_offset(lv, (S8279C6*)(S8279C3*)(S8279C14*), ABISELECT(104,52), "S8279C11");
    check_base_class_offset(lv, (S8279C6*)(S8279C15*)(S8279C14*), ABISELECT(104,52), "S8279C11");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S8279C6*)(S8279C15*)(S8279C16*), ABISELECT(104,52), "S8279C11");
    /*is_ambiguous_... S8279C11::S8279C15 */ AMB_check_base_class_offset(lv, (S8279C6*)(S8279C15*), ABISELECT(104,52), "S8279C11");
    /*is_ambiguous_... S8279C11::S8279C3 */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C3*), ABISELECT(128,64), "S8279C11");
    /*is_ambiguous_... S8279C3::S814C5_nt */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C3*)(S8279C14*), ABISELECT(128,64), "S8279C11");
    /*is_ambiguous_... S8279C11::S8279C3 */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C8*)(S8279C3*), ABISELECT(88,44), "S8279C11");
    /*is_ambiguous_... S8279C11::S8279C3 */ AMB_check_base_class_offset(lv, (S8279C8*)(S8279C3*), ABISELECT(88,44), "S8279C11");
    /*is_ambiguous_... S8279C11::S8279C13 */ AMB_check_base_class_offset(lv, (S8279C3*)(S8279C13*), ABISELECT(88,44), "S8279C11");
    /*is_ambiguous_... S8279C13::S8279C3 */ AMB_check_base_class_offset(lv, (S8279C3*)(S8279C13*)(S8279C16*), ABISELECT(88,44), "S8279C11");
    /*is_ambiguous_... S8279C11::S8279C8 */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C8*), ABISELECT(200,104), "S8279C11");
    /*is_ambiguous_... S8279C14::S8279C8 */ AMB_check_base_class_offset(lv, (S8279C8*)(S8279C14*), ABISELECT(200,104), "S8279C11");
    /*is_ambiguous_... S8279C16::S8279C8 */ AMB_check_base_class_offset(lv, (S8279C8*)(S8279C16*), ABISELECT(200,104), "S8279C11");
    /*is_ambiguous_... S8279C14::S8279C5 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C14*), ABISELECT(136,68), "S8279C11");
    check_base_class_offset(lv, (S814C5_nt*)(S8279C8*)(S8279C3*)(S8279C14*), ABISELECT(144,72), "S8279C11");
    check_base_class_offset(lv, (S8279C8*)(S8279C3*)(S8279C14*), ABISELECT(144,72), "S8279C11");
    check_base_class_offset(lv, (S8279C3*)(S8279C14*), ABISELECT(144,72), "S8279C11");
    /*is_ambiguous_... S8279C14::S814C5_nt */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C14*), ABISELECT(160,80), "S8279C11");
    /*is_ambiguous_... S8279C15::S814C5_nt */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C15*)(S8279C14*), ABISELECT(168,84), "S8279C11");
    check_base_class_offset(lv, (S814C5_nt*)(S8279C8*)(S8279C15*)(S8279C14*), ABISELECT(176,88), "S8279C11");
    check_base_class_offset(lv, (S8279C8*)(S8279C15*)(S8279C14*), ABISELECT(176,88), "S8279C11");
    check_base_class_offset(lv, (S8279C15*)(S8279C14*), ABISELECT(168,84), "S8279C11");
    /*is_ambiguous_... S8279C11::S8279C13 */ AMB_check_base_class_offset(lv, (S8279C14*)(S8279C13*), ABISELECT(136,68), "S8279C11");
    check_base_class_offset(lv, (S8279C14*)(S8279C13*)(S8279C16*), ABISELECT(136,68), "S8279C11");
    /*is_ambiguous_... S8279C12::S8279C13 */ AMB_check_base_class_offset(lv, (S8279C13*)(S8279C12*), 0, "S8279C11");
    check_base_class_offset(lv, (S8279C13*)(S8279C16*), ABISELECT(216,112), "S8279C11");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C15*)(S8279C16*), ABISELECT(224,116), "S8279C11");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C8*)(S8279C15*)(S8279C16*), ABISELECT(232,120), "S8279C11");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S8279C8*)(S8279C15*)(S8279C16*), ABISELECT(232,120), "S8279C11");
    /*is_ambiguous_... S8279C16::S8279C15 */ AMB_check_base_class_offset(lv, (S8279C15*)(S8279C16*), ABISELECT(224,116), "S8279C11");
    /*is_ambiguous_... S8279C11::S8279C15 */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C15*), ABISELECT(264,136), "S8279C11");
    /*is_ambiguous_... S8279C11::S8279C15 */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C8*)(S8279C15*), ABISELECT(272,140), "S8279C11");
    /*is_ambiguous_... S8279C11::S8279C15 */ AMB_check_base_class_offset(lv, (S8279C8*)(S8279C15*), ABISELECT(272,140), "S8279C11");
    check_base_class_offset(lv, (S8279C15*)(S8279C17*)(S8279C16*), ABISELECT(264,136), "S8279C11");
    check_base_class_offset(lv, (S8279C17*)(S8279C16*), ABISELECT(248,128), "S8279C11");
    check_base_class_offset(lv, (S8279C16*)(S8279C12*), ABISELECT(216,112), "S8279C11");
    check_base_class_offset(lv, (S8279C5*)(S8279C20*), ABISELECT(328,172), "S8279C11");
    check_base_class_offset(lv, (S8279C20*)(S8279C19*), ABISELECT(328,172), "S8279C11");
    check_base_class_offset(lv, (S8279C19*)(S8279C18*), ABISELECT(320,168), "S8279C11");
    check_base_class_offset(lv, (S814C5_nt*)(S8279C6*)(S8279C18*), ABISELECT(288,148), "S8279C11");
    check_base_class_offset(lv, (S8279C5*)(S8279C6*)(S8279C18*), ABISELECT(296,152), "S8279C11");
    check_base_class_offset(lv, (S8279C6*)(S8279C18*), ABISELECT(288,148), "S8279C11");
    check_base_class_offset(lv, (S8279C18*)(S8279C12*), ABISELECT(288,148), "S8279C11");
    check_base_class_offset(lv, (S8279C12*), 0, "S8279C11");
    check_base_class_offset(lv, (S8279C22*), ABISELECT(16,8), "S8279C11");
    check_field_offset(lv, s8279c11f0, ABISELECT(48,24), "S8279C11.s8279c11f0");
    check_field_offset(lv, s8279c11f1, ABISELECT(80,40), "S8279C11.s8279c11f1");
    test_class_info(&lv, &cd_S8279C11);
    dp->~S8279C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8279C11(Test_S8279C11, "S8279C11", ABISELECT(344,180));

#else // __cplusplus

extern void _ZN8S8279C11C1Ev();
extern void _ZN8S8279C11D2Ev();
Name_Map name_map_S8279C11[] = {
  NSPAIR(_ZN8S8279C11C1Ev),
  NSPAIR(_ZN8S8279C11D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S694C11_nt;
extern VTBL_ENTRY _ZTI10S694C11_nt[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S8279C6;
extern VTBL_ENTRY _ZTI7S8279C6[];
extern  VTBL_ENTRY _ZTV7S8279C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C6[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C8;
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
extern Class_Descriptor cd_S8279C3;
extern VTBL_ENTRY _ZTI7S8279C3[];
extern  VTBL_ENTRY _ZTV7S8279C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C3[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C8;
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C8;
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
extern Class_Descriptor cd_S8279C3;
extern VTBL_ENTRY _ZTI7S8279C3[];
extern  VTBL_ENTRY _ZTV7S8279C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C3[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C8;
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
extern Class_Descriptor cd_S8279C15;
extern VTBL_ENTRY _ZTI8S8279C15[];
extern  VTBL_ENTRY _ZTV8S8279C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C15[];
extern Class_Descriptor cd_S8279C14;
extern VTBL_ENTRY _ZTI8S8279C14[];
extern  VTBL_ENTRY _ZTV8S8279C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C14[];
extern Class_Descriptor cd_S8279C13;
extern VTBL_ENTRY _ZTI8S8279C13[];
extern  VTBL_ENTRY _ZTV8S8279C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C13[];
extern Class_Descriptor cd_S8279C13;
extern VTBL_ENTRY _ZTI8S8279C13[];
extern  VTBL_ENTRY _ZTV8S8279C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C13[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C8;
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
extern Class_Descriptor cd_S8279C15;
extern VTBL_ENTRY _ZTI8S8279C15[];
extern  VTBL_ENTRY _ZTV8S8279C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C15[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C8;
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
extern Class_Descriptor cd_S8279C15;
extern VTBL_ENTRY _ZTI8S8279C15[];
extern  VTBL_ENTRY _ZTV8S8279C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C15[];
extern Class_Descriptor cd_S8279C17;
extern VTBL_ENTRY _ZTI8S8279C17[];
extern  VTBL_ENTRY _ZTV8S8279C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C17[];
extern Class_Descriptor cd_S8279C16;
extern VTBL_ENTRY _ZTI8S8279C16[];
extern  VTBL_ENTRY _ZTV8S8279C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C16[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S8279C20;
extern VTBL_ENTRY _ZTI8S8279C20[];
extern  VTBL_ENTRY _ZTV8S8279C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C20[];
extern Class_Descriptor cd_S8279C19;
extern VTBL_ENTRY _ZTI8S8279C19[];
extern  VTBL_ENTRY _ZTV8S8279C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C19[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S8279C6;
extern VTBL_ENTRY _ZTI7S8279C6[];
extern  VTBL_ENTRY _ZTV7S8279C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C6[];
extern Class_Descriptor cd_S8279C18;
extern VTBL_ENTRY _ZTI8S8279C18[];
extern  VTBL_ENTRY _ZTV8S8279C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C18[];
extern Class_Descriptor cd_S8279C12;
extern VTBL_ENTRY _ZTI8S8279C12[];
extern  VTBL_ENTRY _ZTV8S8279C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C12[];
extern Class_Descriptor cd_S8279C22;
extern VTBL_ENTRY _ZTI8S8279C22[];
static Base_Class bases_S8279C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S694C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S8279C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    59, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S814C5_nt,    ABISELECT(104,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S8279C5,    ABISELECT(112,56), //bcp->offset
    36, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    68, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S8279C6,    ABISELECT(104,52), //bcp->offset
    29, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    67, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S814C5_nt,    ABISELECT(128,64), //bcp->offset
    40, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S814C5_nt,    ABISELECT(88,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S8279C8,    ABISELECT(88,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    61, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S8279C3,    ABISELECT(88,44), //bcp->offset
    20, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    60, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    21, //immediately_derived
  0, 1},
  {&cd_S814C5_nt,    ABISELECT(200,104), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S8279C8,    ABISELECT(200,104), //bcp->offset
    82, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    32, //bcp->index_in_construction_vtbl_array
    94, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    20, //immediately_derived
  0, 1},
  {&cd_S8279C5,    ABISELECT(136,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    71, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S814C5_nt,    ABISELECT(144,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S8279C8,    ABISELECT(144,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    73, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S8279C3,    ABISELECT(144,72), //bcp->offset
    57, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    33, //bcp->index_in_construction_vtbl_array
    72, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S814C5_nt,    ABISELECT(160,80), //bcp->offset
    65, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    34, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S814C5_nt,    ABISELECT(168,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S814C5_nt,    ABISELECT(176,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S8279C8,    ABISELECT(176,88), //bcp->offset
    76, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    36, //bcp->index_in_construction_vtbl_array
    80, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S8279C15,    ABISELECT(168,84), //bcp->offset
    69, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    35, //bcp->index_in_construction_vtbl_array
    79, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S8279C14,    ABISELECT(136,68), //bcp->offset
    45, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    70, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    21, //immediately_derived
  0, 1},
  {&cd_S8279C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    47, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    40, //immediately_derived
  0, 1},
  {&cd_S8279C13,    ABISELECT(216,112), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    97, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S814C5_nt,    ABISELECT(224,116), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S814C5_nt,    ABISELECT(232,120), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S8279C8,    ABISELECT(232,120), //bcp->offset
    111, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    39, //bcp->index_in_construction_vtbl_array
    110, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S8279C15,    ABISELECT(224,116), //bcp->offset
    104, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    38, //bcp->index_in_construction_vtbl_array
    109, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S814C5_nt,    ABISELECT(264,136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S814C5_nt,    ABISELECT(272,140), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S8279C8,    ABISELECT(272,140), //bcp->offset
    135, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    42, //bcp->index_in_construction_vtbl_array
    139, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S8279C15,    ABISELECT(264,136), //bcp->offset
    127, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    41, //bcp->index_in_construction_vtbl_array
    138, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    31, //immediately_derived
  0, 1},
  {&cd_S8279C17,    ABISELECT(248,128), //bcp->offset
    117, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    40, //bcp->index_in_construction_vtbl_array
    116, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S8279C16,    ABISELECT(216,112), //bcp->offset
    89, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    37, //bcp->index_in_construction_vtbl_array
    96, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    40, //immediately_derived
  0, 1},
  {&cd_S8279C5,    ABISELECT(328,172), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    155, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S8279C20,    ABISELECT(328,172), //bcp->offset
    158, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    45, //bcp->index_in_construction_vtbl_array
    154, //bcp->base_subarray_index_in_construction_vtbl_array
    34, //init_seq
    35, //immediately_derived
  0, 1},
  {&cd_S8279C19,    ABISELECT(320,168), //bcp->offset
    154, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    44, //bcp->index_in_construction_vtbl_array
    152, //bcp->base_subarray_index_in_construction_vtbl_array
    35, //init_seq
    39, //immediately_derived
  0, 1},
  {&cd_S814C5_nt,    ABISELECT(288,148), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    36, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S8279C5,    ABISELECT(296,152), //bcp->offset
    150, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    46, //bcp->index_in_construction_vtbl_array
    147, //bcp->base_subarray_index_in_construction_vtbl_array
    37, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S8279C6,    ABISELECT(288,148), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    146, //bcp->base_subarray_index_in_construction_vtbl_array
    38, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S8279C18,    ABISELECT(288,148), //bcp->offset
    141, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    43, //bcp->index_in_construction_vtbl_array
    145, //bcp->base_subarray_index_in_construction_vtbl_array
    39, //init_seq
    40, //immediately_derived
  0, 1},
  {&cd_S8279C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    17, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    40, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S8279C22,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S8279C11[];
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTv0_n88_N8S8279C11D1Ev,_ZTv0_n44_N8S8279C11D1Ev)();
extern void _ZN8S8279C11D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n88_N8S8279C11D0Ev,_ZTv0_n44_N8S8279C11D0Ev)();
extern void _ZN8S8279C11D0Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S8279C11D1Ev,_ZTv0_n28_N8S8279C11D1Ev)();
extern void ABISELECT(_ZThn88_N8S8279C11D1Ev,_ZThn44_N8S8279C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S8279C11D0Ev,_ZTv0_n28_N8S8279C11D0Ev)();
extern void ABISELECT(_ZThn88_N8S8279C11D0Ev,_ZThn44_N8S8279C11D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S8279C11D1Ev,_ZTv0_n16_N8S8279C11D1Ev)();
extern void ABISELECT(_ZThn104_N8S8279C11D1Ev,_ZThn52_N8S8279C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S8279C11D0Ev,_ZTv0_n16_N8S8279C11D0Ev)();
extern void ABISELECT(_ZThn104_N8S8279C11D0Ev,_ZThn52_N8S8279C11D0Ev)() __attribute__((weak));
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTv0_n24_N8S8279C11D1Ev,_ZTv0_n12_N8S8279C11D1Ev)();
extern void ABISELECT(_ZThn128_N8S8279C11D1Ev,_ZThn64_N8S8279C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S8279C11D0Ev,_ZTv0_n12_N8S8279C11D0Ev)();
extern void ABISELECT(_ZThn128_N8S8279C11D0Ev,_ZThn64_N8S8279C11D0Ev)() __attribute__((weak));
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTv0_n72_N8S8279C11D1Ev,_ZTv0_n36_N8S8279C11D1Ev)();
extern void ABISELECT(_ZThn136_N8S8279C11D1Ev,_ZThn68_N8S8279C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S8279C11D0Ev,_ZTv0_n36_N8S8279C11D0Ev)();
extern void ABISELECT(_ZThn136_N8S8279C11D0Ev,_ZThn68_N8S8279C11D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn8_n72_N8S8279C11D1Ev,_ZTvn4_n36_N8S8279C11D1Ev)();
extern void ABISELECT(_ZTvn8_n72_N8S8279C11D0Ev,_ZTvn4_n36_N8S8279C11D0Ev)();
extern void ABISELECT(_ZTvn24_n72_N8S8279C11D1Ev,_ZTvn12_n36_N8S8279C11D1Ev)();
extern void ABISELECT(_ZTvn24_n72_N8S8279C11D0Ev,_ZTvn12_n36_N8S8279C11D0Ev)();
extern void ABISELECT(_ZTvn32_n72_N8S8279C11D1Ev,_ZTvn16_n36_N8S8279C11D1Ev)();
extern void ABISELECT(_ZTvn32_n72_N8S8279C11D0Ev,_ZTvn16_n36_N8S8279C11D0Ev)();
extern void ABISELECT(_ZTvn40_n72_N8S8279C11D1Ev,_ZTvn20_n36_N8S8279C11D1Ev)();
extern void ABISELECT(_ZTvn40_n72_N8S8279C11D0Ev,_ZTvn20_n36_N8S8279C11D0Ev)();
extern void ABISELECT(_ZTv0_n40_N8S8279C11D1Ev,_ZTv0_n20_N8S8279C11D1Ev)();
extern void ABISELECT(_ZThn200_N8S8279C11D1Ev,_ZThn104_N8S8279C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S8279C11D0Ev,_ZTv0_n20_N8S8279C11D0Ev)();
extern void ABISELECT(_ZThn200_N8S8279C11D0Ev,_ZThn104_N8S8279C11D0Ev)() __attribute__((weak));
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTv0_n96_N8S8279C11D1Ev,_ZTv0_n48_N8S8279C11D1Ev)();
extern void ABISELECT(_ZThn216_N8S8279C11D1Ev,_ZThn112_N8S8279C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N8S8279C11D0Ev,_ZTv0_n48_N8S8279C11D0Ev)();
extern void ABISELECT(_ZThn216_N8S8279C11D0Ev,_ZThn112_N8S8279C11D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn8_n96_N8S8279C11D1Ev,_ZTvn4_n48_N8S8279C11D1Ev)();
extern void ABISELECT(_ZTvn8_n96_N8S8279C11D0Ev,_ZTvn4_n48_N8S8279C11D0Ev)();
extern void ABISELECT(_ZTvn16_n96_N8S8279C11D1Ev,_ZTvn8_n48_N8S8279C11D1Ev)();
extern void ABISELECT(_ZTvn16_n96_N8S8279C11D0Ev,_ZTvn8_n48_N8S8279C11D0Ev)();
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTvn32_n96_N8S8279C11D1Ev,_ZTvn16_n48_N8S8279C11D1Ev)();
extern void ABISELECT(_ZTvn32_n96_N8S8279C11D0Ev,_ZTvn16_n48_N8S8279C11D0Ev)();
extern void ABISELECT(_ZTv0_n48_N8S8279C11D1Ev,_ZTv0_n24_N8S8279C11D1Ev)();
extern void ABISELECT(_ZThn264_N8S8279C11D1Ev,_ZThn136_N8S8279C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S8279C11D0Ev,_ZTv0_n24_N8S8279C11D0Ev)();
extern void ABISELECT(_ZThn264_N8S8279C11D0Ev,_ZThn136_N8S8279C11D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn8_n48_N8S8279C11D1Ev,_ZTvn4_n24_N8S8279C11D1Ev)();
extern void ABISELECT(_ZTvn8_n48_N8S8279C11D0Ev,_ZTvn4_n24_N8S8279C11D0Ev)();
extern void ABISELECT(_ZTv0_n48_N8S8279C11D1Ev,_ZTv0_n24_N8S8279C11D1Ev)();
extern void ABISELECT(_ZThn288_N8S8279C11D1Ev,_ZThn148_N8S8279C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S8279C11D0Ev,_ZTv0_n24_N8S8279C11D0Ev)();
extern void ABISELECT(_ZThn288_N8S8279C11D0Ev,_ZThn148_N8S8279C11D0Ev)() __attribute__((weak));
extern void _ZN7S8279C52v1Ev();
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY vtc_S8279C11[] = {
  ABISELECT(328,172),
  ABISELECT(320,168),
  ABISELECT(288,148),
  ABISELECT(264,136),
  ABISELECT(216,112),
  0,
  0,
  ABISELECT(200,104),
  ABISELECT(136,68),
  ABISELECT(128,64),
  ABISELECT(104,52),
  ABISELECT(88,44),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C11[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n88_N8S8279C11D1Ev,_ZTv0_n44_N8S8279C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n88_N8S8279C11D0Ev,_ZTv0_n44_N8S8279C11D0Ev),
  ABISELECT(-88,-44),
  ABISELECT(40,20),
  ABISELECT(16,8),
  ABISELECT(-88,-44),
  ABISELECT(-88,-44),
  ABISELECT(-88,-44),
  (VTBL_ENTRY)&(_ZTI8S8279C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S8279C11D1Ev,_ZTv0_n28_N8S8279C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S8279C11D0Ev,_ZTv0_n28_N8S8279C11D0Ev),
  ABISELECT(8,4),
  ABISELECT(-104,-52),
  ABISELECT(-104,-52),
  ABISELECT(-104,-52),
  (VTBL_ENTRY)&(_ZTI8S8279C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C11D1Ev,_ZTv0_n16_N8S8279C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C11D0Ev,_ZTv0_n16_N8S8279C11D0Ev),
  ABISELECT(-112,-56),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI8S8279C11[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  ABISELECT(-128,-64),
  ABISELECT(-128,-64),
  (VTBL_ENTRY)&(_ZTI8S8279C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C11D1Ev,_ZTv0_n12_N8S8279C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C11D0Ev,_ZTv0_n12_N8S8279C11D0Ev),
  ABISELECT(-136,-68),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-32,-16),
  ABISELECT(-136,-68),
  ABISELECT(64,36),
  ABISELECT(-136,-68),
  ABISELECT(-136,-68),
  (VTBL_ENTRY)&(_ZTI8S8279C11[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S8279C11D1Ev,_ZTv0_n36_N8S8279C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S8279C11D0Ev,_ZTv0_n36_N8S8279C11D0Ev),
  ABISELECT(-16,-8),
  ABISELECT(-40,-20),
  ABISELECT(-144,-72),
  ABISELECT(-144,-72),
  ABISELECT(-144,-72),
  (VTBL_ENTRY)&(_ZTI8S8279C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n72_N8S8279C11D1Ev,_ZTvn4_n36_N8S8279C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n72_N8S8279C11D0Ev,_ZTvn4_n36_N8S8279C11D0Ev),
  ABISELECT(-160,-80),
  (VTBL_ENTRY)&(_ZTI8S8279C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn24_n72_N8S8279C11D1Ev,_ZTvn12_n36_N8S8279C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn24_n72_N8S8279C11D0Ev,_ZTvn12_n36_N8S8279C11D0Ev),
  ABISELECT(-64,-32),
  ABISELECT(-168,-84),
  ABISELECT(-168,-84),
  ABISELECT(-168,-84),
  (VTBL_ENTRY)&(_ZTI8S8279C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n72_N8S8279C11D1Ev,_ZTvn16_n36_N8S8279C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n72_N8S8279C11D0Ev,_ZTvn16_n36_N8S8279C11D0Ev),
  ABISELECT(-176,-88),
  ABISELECT(-176,-88),
  ABISELECT(-176,-88),
  (VTBL_ENTRY)&(_ZTI8S8279C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn40_n72_N8S8279C11D1Ev,_ZTvn20_n36_N8S8279C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn40_n72_N8S8279C11D0Ev,_ZTvn20_n36_N8S8279C11D0Ev),
  ABISELECT(-200,-104),
  ABISELECT(-200,-104),
  ABISELECT(-200,-104),
  ABISELECT(-200,-104),
  (VTBL_ENTRY)&(_ZTI8S8279C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C11D1Ev,_ZTv0_n20_N8S8279C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C11D0Ev,_ZTv0_n20_N8S8279C11D0Ev),
  ABISELECT(-216,-112),
  ABISELECT(48,24),
  ABISELECT(-16,-8),
  ABISELECT(-80,-44),
  ABISELECT(-88,-48),
  ABISELECT(-112,-60),
  ABISELECT(-128,-68),
  ABISELECT(-216,-112),
  ABISELECT(-216,-112),
  ABISELECT(-216,-112),
  ABISELECT(-216,-112),
  (VTBL_ENTRY)&(_ZTI8S8279C11[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S8279C11D1Ev,_ZTv0_n48_N8S8279C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S8279C11D0Ev,_ZTv0_n48_N8S8279C11D0Ev),
  ABISELECT(-120,-64),
  ABISELECT(-224,-116),
  ABISELECT(-224,-116),
  ABISELECT(-224,-116),
  (VTBL_ENTRY)&(_ZTI8S8279C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n96_N8S8279C11D1Ev,_ZTvn4_n48_N8S8279C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n96_N8S8279C11D0Ev,_ZTvn4_n48_N8S8279C11D0Ev),
  ABISELECT(-232,-120),
  ABISELECT(-232,-120),
  ABISELECT(-232,-120),
  (VTBL_ENTRY)&(_ZTI8S8279C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n96_N8S8279C11D1Ev,_ZTvn8_n48_N8S8279C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n96_N8S8279C11D0Ev,_ZTvn8_n48_N8S8279C11D0Ev),
  ABISELECT(-144,-76),
  ABISELECT(-248,-128),
  ABISELECT(16,8),
  ABISELECT(-248,-128),
  ABISELECT(-248,-128),
  ABISELECT(-248,-128),
  (VTBL_ENTRY)&(_ZTI8S8279C11[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n96_N8S8279C11D1Ev,_ZTvn16_n48_N8S8279C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n96_N8S8279C11D0Ev,_ZTvn16_n48_N8S8279C11D0Ev),
  ABISELECT(-264,-136),
  ABISELECT(-160,-84),
  ABISELECT(-264,-136),
  ABISELECT(-264,-136),
  ABISELECT(-264,-136),
  (VTBL_ENTRY)&(_ZTI8S8279C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C11D1Ev,_ZTv0_n24_N8S8279C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C11D0Ev,_ZTv0_n24_N8S8279C11D0Ev),
  ABISELECT(-272,-140),
  ABISELECT(-272,-140),
  ABISELECT(-272,-140),
  (VTBL_ENTRY)&(_ZTI8S8279C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S8279C11D1Ev,_ZTvn4_n24_N8S8279C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S8279C11D0Ev,_ZTvn4_n24_N8S8279C11D0Ev),
  ABISELECT(8,4),
  ABISELECT(-288,-148),
  ABISELECT(40,24),
  ABISELECT(32,20),
  ABISELECT(-288,-148),
  ABISELECT(-288,-148),
  (VTBL_ENTRY)&(_ZTI8S8279C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C11D1Ev,_ZTv0_n24_N8S8279C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C11D0Ev,_ZTv0_n24_N8S8279C11D0Ev),
  ABISELECT(-296,-152),
  ABISELECT(-296,-152),
  (VTBL_ENTRY)&(_ZTI8S8279C11[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  ABISELECT(-320,-168),
  ABISELECT(8,4),
  ABISELECT(-320,-168),
  (VTBL_ENTRY)&(_ZTI8S8279C11[0]),
  0,
  ABISELECT(-328,-172),
  ABISELECT(-328,-172),
  (VTBL_ENTRY)&(_ZTI8S8279C11[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern VTBL_ENTRY _ZTV8S8279C11[];
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTv0_n88_N8S8279C12D1Ev,_ZTv0_n44_N8S8279C12D1Ev)();
extern void _ZN8S8279C12D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n88_N8S8279C12D0Ev,_ZTv0_n44_N8S8279C12D0Ev)();
extern void _ZN8S8279C12D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S8279C12__8S8279C11[] = {
  ABISELECT(328,172),
  ABISELECT(320,168),
  ABISELECT(288,148),
  ABISELECT(264,136),
  ABISELECT(216,112),
  0,
  0,
  ABISELECT(200,104),
  ABISELECT(136,68),
  ABISELECT(128,64),
  ABISELECT(104,52),
  ABISELECT(88,44),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n88_N8S8279C12D1Ev,_ZTv0_n44_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n88_N8S8279C12D0Ev,_ZTv0_n44_N8S8279C12D0Ev),
};
extern void ABISELECT(_ZTv0_n56_N8S8279C12D1Ev,_ZTv0_n28_N8S8279C12D1Ev)();
extern void ABISELECT(_ZThn88_N8S8279C12D1Ev,_ZThn44_N8S8279C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S8279C12D0Ev,_ZTv0_n28_N8S8279C12D0Ev)();
extern void ABISELECT(_ZThn88_N8S8279C12D0Ev,_ZThn44_N8S8279C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S8279C3__8S8279C12__8S8279C11[] = {
  ABISELECT(-88,-44),
  ABISELECT(40,20),
  ABISELECT(16,8),
  ABISELECT(-88,-44),
  ABISELECT(-88,-44),
  ABISELECT(-88,-44),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S8279C12D1Ev,_ZTv0_n28_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S8279C12D0Ev,_ZTv0_n28_N8S8279C12D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S8279C12D1Ev,_ZTv0_n16_N8S8279C12D1Ev)();
extern void ABISELECT(_ZThn104_N8S8279C12D1Ev,_ZThn52_N8S8279C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S8279C12D0Ev,_ZTv0_n16_N8S8279C12D0Ev)();
extern void ABISELECT(_ZThn104_N8S8279C12D0Ev,_ZThn52_N8S8279C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C12__8S8279C11[] = {
  ABISELECT(8,4),
  ABISELECT(-104,-52),
  ABISELECT(-104,-52),
  ABISELECT(-104,-52),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C12D1Ev,_ZTv0_n16_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C12D0Ev,_ZTv0_n16_N8S8279C12D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C12__8S8279C11[] = {
  ABISELECT(-112,-56),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S8279C12D1Ev,_ZTv0_n12_N8S8279C12D1Ev)();
extern void ABISELECT(_ZThn128_N8S8279C12D1Ev,_ZThn64_N8S8279C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S8279C12D0Ev,_ZTv0_n12_N8S8279C12D0Ev)();
extern void ABISELECT(_ZThn128_N8S8279C12D0Ev,_ZThn64_N8S8279C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S814C5_nt__A1__8S8279C12__8S8279C11[] = {
  ABISELECT(-128,-64),
  ABISELECT(-128,-64),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C12D1Ev,_ZTv0_n12_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C12D0Ev,_ZTv0_n12_N8S8279C12D0Ev),
};
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTv0_n72_N8S8279C12D1Ev,_ZTv0_n36_N8S8279C12D1Ev)();
extern void ABISELECT(_ZThn136_N8S8279C12D1Ev,_ZThn68_N8S8279C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S8279C12D0Ev,_ZTv0_n36_N8S8279C12D0Ev)();
extern void ABISELECT(_ZThn136_N8S8279C12D0Ev,_ZThn68_N8S8279C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S8279C14__8S8279C12__8S8279C11[] = {
  ABISELECT(-136,-68),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-32,-16),
  ABISELECT(-136,-68),
  ABISELECT(64,36),
  ABISELECT(-136,-68),
  ABISELECT(-136,-68),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S8279C12D1Ev,_ZTv0_n36_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S8279C12D0Ev,_ZTv0_n36_N8S8279C12D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N8S8279C12D1Ev,_ZTv0_n20_N8S8279C12D1Ev)();
extern void ABISELECT(_ZThn200_N8S8279C12D1Ev,_ZThn104_N8S8279C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S8279C12D0Ev,_ZTv0_n20_N8S8279C12D0Ev)();
extern void ABISELECT(_ZThn200_N8S8279C12D0Ev,_ZThn104_N8S8279C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S8279C8__A1__8S8279C12__8S8279C11[] = {
  ABISELECT(-200,-104),
  ABISELECT(-200,-104),
  ABISELECT(-200,-104),
  ABISELECT(-200,-104),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C12D1Ev,_ZTv0_n20_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C12D0Ev,_ZTv0_n20_N8S8279C12D0Ev),
};
extern void ABISELECT(_ZTvn8_n72_N8S8279C12D1Ev,_ZTvn4_n36_N8S8279C12D1Ev)();
extern void ABISELECT(_ZTvn8_n72_N8S8279C12D0Ev,_ZTvn4_n36_N8S8279C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C38S8279C14__A1__8S8279C12__8S8279C11[] = {
  ABISELECT(-16,-8),
  ABISELECT(-40,-20),
  ABISELECT(-144,-72),
  ABISELECT(-144,-72),
  ABISELECT(-144,-72),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n72_N8S8279C12D1Ev,_ZTvn4_n36_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n72_N8S8279C12D0Ev,_ZTvn4_n36_N8S8279C12D0Ev),
};
extern void ABISELECT(_ZTvn24_n72_N8S8279C12D1Ev,_ZTvn12_n36_N8S8279C12D1Ev)();
extern void ABISELECT(_ZTvn24_n72_N8S8279C12D0Ev,_ZTvn12_n36_N8S8279C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S814C5_nt8S8279C14__A5__8S8279C12__8S8279C11[] = {
  ABISELECT(-160,-80),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn24_n72_N8S8279C12D1Ev,_ZTvn12_n36_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn24_n72_N8S8279C12D0Ev,_ZTvn12_n36_N8S8279C12D0Ev),
};
extern void ABISELECT(_ZTvn32_n72_N8S8279C12D1Ev,_ZTvn16_n36_N8S8279C12D1Ev)();
extern void ABISELECT(_ZTvn32_n72_N8S8279C12D0Ev,_ZTvn16_n36_N8S8279C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S8279C158S8279C14__8S8279C12__8S8279C11[] = {
  ABISELECT(-64,-32),
  ABISELECT(-168,-84),
  ABISELECT(-168,-84),
  ABISELECT(-168,-84),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n72_N8S8279C12D1Ev,_ZTvn16_n36_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n72_N8S8279C12D0Ev,_ZTvn16_n36_N8S8279C12D0Ev),
};
extern void ABISELECT(_ZTvn40_n72_N8S8279C12D1Ev,_ZTvn20_n36_N8S8279C12D1Ev)();
extern void ABISELECT(_ZTvn40_n72_N8S8279C12D0Ev,_ZTvn20_n36_N8S8279C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C158S8279C14__A3__8S8279C12__8S8279C11[] = {
  ABISELECT(-176,-88),
  ABISELECT(-176,-88),
  ABISELECT(-176,-88),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn40_n72_N8S8279C12D1Ev,_ZTvn20_n36_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn40_n72_N8S8279C12D0Ev,_ZTvn20_n36_N8S8279C12D0Ev),
};
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTv0_n96_N8S8279C12D1Ev,_ZTv0_n48_N8S8279C12D1Ev)();
extern void ABISELECT(_ZThn216_N8S8279C12D1Ev,_ZThn112_N8S8279C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N8S8279C12D0Ev,_ZTv0_n48_N8S8279C12D0Ev)();
extern void ABISELECT(_ZThn216_N8S8279C12D0Ev,_ZThn112_N8S8279C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S8279C16__8S8279C12__8S8279C11[] = {
  ABISELECT(-216,-112),
  ABISELECT(48,24),
  ABISELECT(-16,-8),
  ABISELECT(-80,-44),
  ABISELECT(-88,-48),
  ABISELECT(-112,-60),
  ABISELECT(-128,-68),
  ABISELECT(-216,-112),
  ABISELECT(-216,-112),
  ABISELECT(-216,-112),
  ABISELECT(-216,-112),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S8279C12D1Ev,_ZTv0_n48_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S8279C12D0Ev,_ZTv0_n48_N8S8279C12D0Ev),
};
extern void ABISELECT(_ZTvn8_n96_N8S8279C12D1Ev,_ZTvn4_n48_N8S8279C12D1Ev)();
extern void ABISELECT(_ZTvn8_n96_N8S8279C12D0Ev,_ZTvn4_n48_N8S8279C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S8279C158S8279C16__A1__8S8279C12__8S8279C11[] = {
  ABISELECT(-120,-64),
  ABISELECT(-224,-116),
  ABISELECT(-224,-116),
  ABISELECT(-224,-116),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n96_N8S8279C12D1Ev,_ZTvn4_n48_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n96_N8S8279C12D0Ev,_ZTvn4_n48_N8S8279C12D0Ev),
};
extern void ABISELECT(_ZTvn16_n96_N8S8279C12D1Ev,_ZTvn8_n48_N8S8279C12D1Ev)();
extern void ABISELECT(_ZTvn16_n96_N8S8279C12D0Ev,_ZTvn8_n48_N8S8279C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C158S8279C16__A4__8S8279C12__8S8279C11[] = {
  ABISELECT(-232,-120),
  ABISELECT(-232,-120),
  ABISELECT(-232,-120),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n96_N8S8279C12D1Ev,_ZTvn8_n48_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n96_N8S8279C12D0Ev,_ZTvn8_n48_N8S8279C12D0Ev),
};
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTvn32_n96_N8S8279C12D1Ev,_ZTvn16_n48_N8S8279C12D1Ev)();
extern void ABISELECT(_ZTvn32_n96_N8S8279C12D0Ev,_ZTvn16_n48_N8S8279C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S8279C178S8279C16__8S8279C12__8S8279C11[] = {
  ABISELECT(-144,-76),
  ABISELECT(-248,-128),
  ABISELECT(16,8),
  ABISELECT(-248,-128),
  ABISELECT(-248,-128),
  ABISELECT(-248,-128),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n96_N8S8279C12D1Ev,_ZTvn16_n48_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n96_N8S8279C12D0Ev,_ZTvn16_n48_N8S8279C12D0Ev),
};
extern void ABISELECT(_ZTv0_n48_N8S8279C12D1Ev,_ZTv0_n24_N8S8279C12D1Ev)();
extern void ABISELECT(_ZThn264_N8S8279C12D1Ev,_ZThn136_N8S8279C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S8279C12D0Ev,_ZTv0_n24_N8S8279C12D0Ev)();
extern void ABISELECT(_ZThn264_N8S8279C12D0Ev,_ZThn136_N8S8279C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S8279C15__A2__8S8279C12__8S8279C11[] = {
  ABISELECT(-264,-136),
  ABISELECT(-160,-84),
  ABISELECT(-264,-136),
  ABISELECT(-264,-136),
  ABISELECT(-264,-136),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C12D1Ev,_ZTv0_n24_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C12D0Ev,_ZTv0_n24_N8S8279C12D0Ev),
};
extern void ABISELECT(_ZTvn8_n48_N8S8279C12D1Ev,_ZTvn4_n24_N8S8279C12D1Ev)();
extern void ABISELECT(_ZTvn8_n48_N8S8279C12D0Ev,_ZTvn4_n24_N8S8279C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C15__A5__8S8279C12__8S8279C11[] = {
  ABISELECT(-272,-140),
  ABISELECT(-272,-140),
  ABISELECT(-272,-140),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S8279C12D1Ev,_ZTvn4_n24_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S8279C12D0Ev,_ZTvn4_n24_N8S8279C12D0Ev),
};
extern void ABISELECT(_ZTv0_n48_N8S8279C12D1Ev,_ZTv0_n24_N8S8279C12D1Ev)();
extern void ABISELECT(_ZThn288_N8S8279C12D1Ev,_ZThn148_N8S8279C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S8279C12D0Ev,_ZTv0_n24_N8S8279C12D0Ev)();
extern void ABISELECT(_ZThn288_N8S8279C12D0Ev,_ZThn148_N8S8279C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S8279C18__8S8279C12__8S8279C11[] = {
  ABISELECT(8,4),
  ABISELECT(-288,-148),
  ABISELECT(40,24),
  ABISELECT(32,20),
  ABISELECT(-288,-148),
  ABISELECT(-288,-148),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C12D1Ev,_ZTv0_n24_N8S8279C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C12D0Ev,_ZTv0_n24_N8S8279C12D0Ev),
};
static  VTBL_ENTRY _tg__ZTV8S8279C19__8S8279C12__8S8279C11[] = {
  ABISELECT(-320,-168),
  ABISELECT(8,4),
  ABISELECT(-320,-168),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C20__8S8279C12__8S8279C11[] = {
  0,
  ABISELECT(-328,-172),
  ABISELECT(-328,-172),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C68S8279C18__A4__8S8279C12__8S8279C11[] = {
  ABISELECT(-296,-152),
  ABISELECT(-296,-152),
  (VTBL_ENTRY)&(_ZTI8S8279C12[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
extern void _ZN8S8279C13D1Ev();
extern void _ZN8S8279C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C13__8S8279C11[] = {
  ABISELECT(200,104),
  ABISELECT(136,68),
  ABISELECT(128,64),
  ABISELECT(104,52),
  ABISELECT(88,44),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&_ZN8S8279C13D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C13D0Ev,
};
extern void ABISELECT(_ZTv0_n56_N8S8279C13D1Ev,_ZTv0_n28_N8S8279C13D1Ev)();
extern void ABISELECT(_ZThn88_N8S8279C13D1Ev,_ZThn44_N8S8279C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S8279C13D0Ev,_ZTv0_n28_N8S8279C13D0Ev)();
extern void ABISELECT(_ZThn88_N8S8279C13D0Ev,_ZThn44_N8S8279C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S8279C3__8S8279C13__8S8279C11[] = {
  ABISELECT(-88,-44),
  ABISELECT(40,20),
  ABISELECT(16,8),
  ABISELECT(-88,-44),
  ABISELECT(-88,-44),
  ABISELECT(-88,-44),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S8279C13D1Ev,_ZTv0_n28_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S8279C13D0Ev,_ZTv0_n28_N8S8279C13D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S8279C13D1Ev,_ZTv0_n16_N8S8279C13D1Ev)();
extern void ABISELECT(_ZThn104_N8S8279C13D1Ev,_ZThn52_N8S8279C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S8279C13D0Ev,_ZTv0_n16_N8S8279C13D0Ev)();
extern void ABISELECT(_ZThn104_N8S8279C13D0Ev,_ZThn52_N8S8279C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C13__8S8279C11[] = {
  ABISELECT(8,4),
  ABISELECT(-104,-52),
  ABISELECT(-104,-52),
  ABISELECT(-104,-52),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C13D1Ev,_ZTv0_n16_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C13D0Ev,_ZTv0_n16_N8S8279C13D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C13__8S8279C11[] = {
  ABISELECT(-112,-56),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S8279C13D1Ev,_ZTv0_n12_N8S8279C13D1Ev)();
extern void ABISELECT(_ZThn128_N8S8279C13D1Ev,_ZThn64_N8S8279C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S8279C13D0Ev,_ZTv0_n12_N8S8279C13D0Ev)();
extern void ABISELECT(_ZThn128_N8S8279C13D0Ev,_ZThn64_N8S8279C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S814C5_nt__A1__8S8279C13__8S8279C11[] = {
  ABISELECT(-128,-64),
  ABISELECT(-128,-64),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C13D1Ev,_ZTv0_n12_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C13D0Ev,_ZTv0_n12_N8S8279C13D0Ev),
};
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTv0_n72_N8S8279C13D1Ev,_ZTv0_n36_N8S8279C13D1Ev)();
extern void ABISELECT(_ZThn136_N8S8279C13D1Ev,_ZThn68_N8S8279C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S8279C13D0Ev,_ZTv0_n36_N8S8279C13D0Ev)();
extern void ABISELECT(_ZThn136_N8S8279C13D0Ev,_ZThn68_N8S8279C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S8279C14__8S8279C13__8S8279C11[] = {
  ABISELECT(-136,-68),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-32,-16),
  ABISELECT(-136,-68),
  ABISELECT(64,36),
  ABISELECT(-136,-68),
  ABISELECT(-136,-68),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S8279C13D1Ev,_ZTv0_n36_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S8279C13D0Ev,_ZTv0_n36_N8S8279C13D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N8S8279C13D1Ev,_ZTv0_n20_N8S8279C13D1Ev)();
extern void ABISELECT(_ZThn200_N8S8279C13D1Ev,_ZThn104_N8S8279C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S8279C13D0Ev,_ZTv0_n20_N8S8279C13D0Ev)();
extern void ABISELECT(_ZThn200_N8S8279C13D0Ev,_ZThn104_N8S8279C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S8279C8__A1__8S8279C13__8S8279C11[] = {
  ABISELECT(-200,-104),
  ABISELECT(-200,-104),
  ABISELECT(-200,-104),
  ABISELECT(-200,-104),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C13D1Ev,_ZTv0_n20_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C13D0Ev,_ZTv0_n20_N8S8279C13D0Ev),
};
extern void ABISELECT(_ZTvn8_n72_N8S8279C13D1Ev,_ZTvn4_n36_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTvn8_n72_N8S8279C13D0Ev,_ZTvn4_n36_N8S8279C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C38S8279C14__A1__8S8279C13__8S8279C11[] = {
  ABISELECT(-16,-8),
  ABISELECT(-40,-20),
  ABISELECT(-144,-72),
  ABISELECT(-144,-72),
  ABISELECT(-144,-72),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n72_N8S8279C13D1Ev,_ZTvn4_n36_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n72_N8S8279C13D0Ev,_ZTvn4_n36_N8S8279C13D0Ev),
};
extern void ABISELECT(_ZTvn24_n72_N8S8279C13D1Ev,_ZTvn12_n36_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTvn24_n72_N8S8279C13D0Ev,_ZTvn12_n36_N8S8279C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S814C5_nt8S8279C14__A5__8S8279C13__8S8279C11[] = {
  ABISELECT(-160,-80),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn24_n72_N8S8279C13D1Ev,_ZTvn12_n36_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn24_n72_N8S8279C13D0Ev,_ZTvn12_n36_N8S8279C13D0Ev),
};
extern void ABISELECT(_ZTvn32_n72_N8S8279C13D1Ev,_ZTvn16_n36_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTvn32_n72_N8S8279C13D0Ev,_ZTvn16_n36_N8S8279C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S8279C158S8279C14__8S8279C13__8S8279C11[] = {
  ABISELECT(-64,-32),
  ABISELECT(-168,-84),
  ABISELECT(-168,-84),
  ABISELECT(-168,-84),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n72_N8S8279C13D1Ev,_ZTvn16_n36_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n72_N8S8279C13D0Ev,_ZTvn16_n36_N8S8279C13D0Ev),
};
extern void ABISELECT(_ZTvn40_n72_N8S8279C13D1Ev,_ZTvn20_n36_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTvn40_n72_N8S8279C13D0Ev,_ZTvn20_n36_N8S8279C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C158S8279C14__A3__8S8279C13__8S8279C11[] = {
  ABISELECT(-176,-88),
  ABISELECT(-176,-88),
  ABISELECT(-176,-88),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn40_n72_N8S8279C13D1Ev,_ZTvn20_n36_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn40_n72_N8S8279C13D0Ev,_ZTvn20_n36_N8S8279C13D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C11[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C3D1Ev();
extern void _ZN7S8279C3D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C3__8S8279C11[] = {
  ABISELECT(40,20),
  ABISELECT(16,8),
  ABISELECT(-88,-44),
  ABISELECT(-88,-44),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&_ZN7S8279C3D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C3D0Ev,
};
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C87S8279C3__8S8279C11[] = {
  ABISELECT(-88,-44),
  ABISELECT(-88,-44),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C87S8279C3__8S8279C11[] = {
  0,
  0,
  ABISELECT(88,44),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C3__8S8279C11[] = {
  0,
  0,
  ABISELECT(88,44),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N7S8279C3D1Ev,_ZTv0_n16_N7S8279C3D1Ev)();
extern void ABISELECT(_ZThn16_N7S8279C3D1Ev,_ZThn8_N7S8279C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S8279C3D0Ev,_ZTv0_n16_N7S8279C3D0Ev)();
extern void ABISELECT(_ZThn16_N7S8279C3D0Ev,_ZThn8_N7S8279C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S8279C6__7S8279C3__8S8279C11[] = {
  ABISELECT(8,4),
  ABISELECT(-16,-8),
  ABISELECT(-104,-52),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S8279C3D1Ev,_ZTv0_n16_N7S8279C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S8279C3D0Ev,_ZTv0_n16_N7S8279C3D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__7S8279C3__8S8279C11[] = {
  ABISELECT(-112,-56),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S8279C3D1Ev,_ZTv0_n12_N7S8279C3D1Ev)();
extern void ABISELECT(_ZThn40_N7S8279C3D1Ev,_ZThn20_N7S8279C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S8279C3D0Ev,_ZTv0_n12_N7S8279C3D0Ev)();
extern void ABISELECT(_ZThn40_N7S8279C3D0Ev,_ZThn20_N7S8279C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S814C5_nt__A1__7S8279C3__8S8279C11[] = {
  ABISELECT(-40,-20),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S8279C3D1Ev,_ZTv0_n12_N7S8279C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S8279C3D0Ev,_ZTv0_n12_N7S8279C3D0Ev),
};
extern void _ZN7S8279C6D1Ev();
extern void _ZN7S8279C6D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C11[] = {
  ABISELECT(-104,-52),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C6[0]),
  (VTBL_ENTRY)&_ZN7S8279C6D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C6D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C11[] = {
  ABISELECT(-112,-56),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C6__8S8279C11[] = {
  ABISELECT(-112,-56),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S8279C6[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
extern void _ZN8S8279C14D1Ev();
extern void _ZN8S8279C14D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C14__8S8279C11[] = {
  ABISELECT(-8,-4),
  ABISELECT(-32,-16),
  ABISELECT(-136,-68),
  ABISELECT(64,36),
  ABISELECT(-136,-68),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&_ZN8S8279C14D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C14D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C58S8279C14__A2__8S8279C11[] = {
  ABISELECT(-136,-68),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C3D1Ev();
extern void _ZN7S8279C3D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C38S8279C14__A1__8S8279C11[] = {
  ABISELECT(-16,-8),
  ABISELECT(-40,-20),
  ABISELECT(-144,-72),
  ABISELECT(-144,-72),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&_ZN7S8279C3D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C3D0Ev,
};
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C87S8279C38S8279C14__A2__8S8279C11[] = {
  ABISELECT(-144,-72),
  ABISELECT(-144,-72),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C87S8279C38S8279C14__A2__8S8279C11[] = {
  0,
  0,
  ABISELECT(144,72),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C38S8279C14__A1__8S8279C11[] = {
  0,
  0,
  ABISELECT(144,72),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N7S8279C3D1Ev,_ZTv0_n16_N7S8279C3D1Ev)();
extern void ABISELECT(_ZTv0_n32_N7S8279C3D0Ev,_ZTv0_n16_N7S8279C3D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C6__7S8279C38S8279C14__A1__8S8279C11[] = {
  ABISELECT(8,4),
  ABISELECT(40,20),
  ABISELECT(-104,-52),
  ABISELECT(40,20),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S8279C3D1Ev,_ZTv0_n16_N7S8279C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S8279C3D0Ev,_ZTv0_n16_N7S8279C3D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__7S8279C38S8279C14__A1__8S8279C11[] = {
  ABISELECT(-112,-56),
  ABISELECT(32,16),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S8279C3D1Ev,_ZTv0_n12_N7S8279C3D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S8279C3D0Ev,_ZTv0_n12_N7S8279C3D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S814C5_nt__A1__7S8279C38S8279C14__A1__8S8279C11[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI7S8279C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S8279C3D1Ev,_ZTv0_n12_N7S8279C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S8279C3D0Ev,_ZTv0_n12_N7S8279C3D0Ev),
};
extern void _ZN8S8279C15D1Ev();
extern void _ZN8S8279C15D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C158S8279C14__8S8279C11[] = {
  ABISELECT(-64,-32),
  ABISELECT(-168,-84),
  ABISELECT(-168,-84),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN8S8279C15D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C15D0Ev,
};
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C158S8279C14__A3__8S8279C11[] = {
  ABISELECT(-176,-88),
  ABISELECT(-176,-88),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C88S8279C158S8279C14__A3__8S8279C11[] = {
  0,
  0,
  ABISELECT(176,88),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C158S8279C14__8S8279C11[] = {
  0,
  0,
  ABISELECT(168,84),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev)();
extern void ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C158S8279C14__8S8279C11[] = {
  ABISELECT(8,4),
  ABISELECT(64,32),
  ABISELECT(-104,-52),
  ABISELECT(64,32),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C158S8279C14__8S8279C11[] = {
  ABISELECT(-112,-56),
  ABISELECT(56,28),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZThn8_N8S8279C15D1Ev,_ZThn4_N8S8279C15D1Ev)();
extern void ABISELECT(_ZThn8_N8S8279C15D0Ev,_ZThn4_N8S8279C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C8__8S8279C158S8279C14__8S8279C11[] = {
  ABISELECT(-176,-88),
  ABISELECT(-176,-88),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C15D1Ev,_ZThn4_N8S8279C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C15D0Ev,_ZThn4_N8S8279C15D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N8S8279C14D1Ev,_ZTv0_n20_N8S8279C14D1Ev)();
extern void ABISELECT(_ZThn64_N8S8279C14D1Ev,_ZThn36_N8S8279C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S8279C14D0Ev,_ZTv0_n20_N8S8279C14D0Ev)();
extern void ABISELECT(_ZThn64_N8S8279C14D0Ev,_ZThn36_N8S8279C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S8279C8__8S8279C14__8S8279C11[] = {
  ABISELECT(-64,-36),
  ABISELECT(-200,-104),
  ABISELECT(-200,-104),
  ABISELECT(-64,-36),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C14D1Ev,_ZTv0_n20_N8S8279C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C14D0Ev,_ZTv0_n20_N8S8279C14D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C14__8S8279C11[] = {
  0,
  0,
  ABISELECT(136,68),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZThn8_N8S8279C14D1Ev,_ZThn4_N8S8279C14D1Ev)();
extern void ABISELECT(_ZThn8_N8S8279C14D0Ev,_ZThn4_N8S8279C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C3__8S8279C14__8S8279C11[] = {
  ABISELECT(-16,-8),
  ABISELECT(-40,-20),
  ABISELECT(-144,-72),
  ABISELECT(-144,-72),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C14D1Ev,_ZThn4_N8S8279C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C14D0Ev,_ZThn4_N8S8279C14D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S8279C14D1Ev,_ZTv0_n16_N8S8279C14D1Ev)();
extern void ABISELECT(_ZTv0_n32_N8S8279C14D0Ev,_ZTv0_n16_N8S8279C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C14__8S8279C11[] = {
  ABISELECT(8,4),
  ABISELECT(32,16),
  ABISELECT(-104,-52),
  ABISELECT(32,16),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C14D1Ev,_ZTv0_n16_N8S8279C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C14D0Ev,_ZTv0_n16_N8S8279C14D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A2__8S8279C14__8S8279C11[] = {
  ABISELECT(-112,-56),
  ABISELECT(24,12),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S8279C14D1Ev,_ZTv0_n12_N8S8279C14D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S8279C14D0Ev,_ZTv0_n12_N8S8279C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S814C5_nt__A2__8S8279C14__8S8279C11[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C14D1Ev,_ZTv0_n12_N8S8279C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C14D0Ev,_ZTv0_n12_N8S8279C14D0Ev),
};
extern void ABISELECT(_ZThn32_N8S8279C14D1Ev,_ZThn16_N8S8279C14D1Ev)();
extern void ABISELECT(_ZThn32_N8S8279C14D0Ev,_ZThn16_N8S8279C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S8279C15__8S8279C14__8S8279C11[] = {
  ABISELECT(-64,-32),
  ABISELECT(-168,-84),
  ABISELECT(-168,-84),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S8279C14D1Ev,_ZThn16_N8S8279C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S8279C14D0Ev,_ZThn16_N8S8279C14D0Ev),
};
extern void ABISELECT(_ZThn40_N8S8279C14D1Ev,_ZThn20_N8S8279C14D1Ev)();
extern void ABISELECT(_ZThn40_N8S8279C14D0Ev,_ZThn20_N8S8279C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C15__A2__8S8279C14__8S8279C11[] = {
  ABISELECT(-176,-88),
  ABISELECT(-176,-88),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI8S8279C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N8S8279C14D1Ev,_ZThn20_N8S8279C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N8S8279C14D0Ev,_ZThn20_N8S8279C14D0Ev),
};
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C8__A1__8S8279C11[] = {
  ABISELECT(-200,-104),
  ABISELECT(-200,-104),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C8__A1__8S8279C11[] = {
  0,
  0,
  ABISELECT(200,104),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
extern void _ZN8S8279C16D1Ev();
extern void _ZN8S8279C16D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C16__8S8279C11[] = {
  ABISELECT(48,24),
  ABISELECT(-16,-8),
  ABISELECT(-80,-44),
  ABISELECT(-88,-48),
  ABISELECT(-112,-60),
  ABISELECT(-128,-68),
  ABISELECT(-216,-112),
  ABISELECT(-216,-112),
  ABISELECT(-216,-112),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&_ZN8S8279C16D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C16D0Ev,
};
extern void _ZN7S8279C52v1Ev();
extern void _ZN8S8279C13D1Ev();
extern void _ZN8S8279C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C138S8279C16__A1__8S8279C11[] = {
  ABISELECT(-16,-8),
  ABISELECT(-80,-44),
  ABISELECT(-88,-48),
  ABISELECT(-112,-60),
  ABISELECT(-128,-68),
  ABISELECT(-216,-112),
  ABISELECT(-216,-112),
  ABISELECT(-216,-112),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&_ZN8S8279C13D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C13D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C138S8279C16__A1__8S8279C11[] = {
  0,
  0,
  ABISELECT(216,112),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n56_N8S8279C13D1Ev,_ZTv0_n28_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTv0_n56_N8S8279C13D0Ev,_ZTv0_n28_N8S8279C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C3__8S8279C138S8279C16__A1__8S8279C11[] = {
  ABISELECT(128,68),
  ABISELECT(40,20),
  ABISELECT(16,8),
  ABISELECT(-88,-44),
  ABISELECT(-88,-44),
  ABISELECT(128,68),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S8279C13D1Ev,_ZTv0_n28_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S8279C13D0Ev,_ZTv0_n28_N8S8279C13D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S8279C13D1Ev,_ZTv0_n16_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTv0_n32_N8S8279C13D0Ev,_ZTv0_n16_N8S8279C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C138S8279C16__A1__8S8279C11[] = {
  ABISELECT(8,4),
  ABISELECT(112,60),
  ABISELECT(-104,-52),
  ABISELECT(112,60),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C13D1Ev,_ZTv0_n16_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C13D0Ev,_ZTv0_n16_N8S8279C13D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C138S8279C16__A1__8S8279C11[] = {
  ABISELECT(-112,-56),
  ABISELECT(104,56),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S8279C13D1Ev,_ZTv0_n12_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S8279C13D0Ev,_ZTv0_n12_N8S8279C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S814C5_nt__A1__8S8279C138S8279C16__A1__8S8279C11[] = {
  ABISELECT(88,48),
  ABISELECT(88,48),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C13D1Ev,_ZTv0_n12_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C13D0Ev,_ZTv0_n12_N8S8279C13D0Ev),
};
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTv0_n72_N8S8279C13D1Ev,_ZTv0_n36_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTv0_n72_N8S8279C13D0Ev,_ZTv0_n36_N8S8279C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S8279C14__8S8279C138S8279C16__A1__8S8279C11[] = {
  ABISELECT(80,44),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-32,-16),
  ABISELECT(-136,-68),
  ABISELECT(64,36),
  ABISELECT(-136,-68),
  ABISELECT(80,44),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S8279C13D1Ev,_ZTv0_n36_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S8279C13D0Ev,_ZTv0_n36_N8S8279C13D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N8S8279C13D1Ev,_ZTv0_n20_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S8279C13D0Ev,_ZTv0_n20_N8S8279C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C8__A1__8S8279C138S8279C16__A1__8S8279C11[] = {
  ABISELECT(16,8),
  ABISELECT(-200,-104),
  ABISELECT(-200,-104),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C13D1Ev,_ZTv0_n20_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C13D0Ev,_ZTv0_n20_N8S8279C13D0Ev),
};
extern void ABISELECT(_ZTvn8_n72_N8S8279C13D1Ev,_ZTvn4_n36_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTvn8_n72_N8S8279C13D0Ev,_ZTvn4_n36_N8S8279C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C38S8279C14__A1__8S8279C138S8279C16__A1__8S8279C11[] = {
  ABISELECT(-16,-8),
  ABISELECT(-40,-20),
  ABISELECT(-144,-72),
  ABISELECT(-144,-72),
  ABISELECT(72,40),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n72_N8S8279C13D1Ev,_ZTvn4_n36_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n72_N8S8279C13D0Ev,_ZTvn4_n36_N8S8279C13D0Ev),
};
extern void ABISELECT(_ZTvn24_n72_N8S8279C13D1Ev,_ZTvn12_n36_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTvn24_n72_N8S8279C13D0Ev,_ZTvn12_n36_N8S8279C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S814C5_nt8S8279C14__A5__8S8279C138S8279C16__A1__8S8279C11[] = {
  ABISELECT(56,32),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn24_n72_N8S8279C13D1Ev,_ZTvn12_n36_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn24_n72_N8S8279C13D0Ev,_ZTvn12_n36_N8S8279C13D0Ev),
};
extern void ABISELECT(_ZTvn32_n72_N8S8279C13D1Ev,_ZTvn16_n36_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTvn32_n72_N8S8279C13D0Ev,_ZTvn16_n36_N8S8279C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S8279C158S8279C14__8S8279C138S8279C16__A1__8S8279C11[] = {
  ABISELECT(-64,-32),
  ABISELECT(-168,-84),
  ABISELECT(-168,-84),
  ABISELECT(48,28),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n72_N8S8279C13D1Ev,_ZTvn16_n36_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n72_N8S8279C13D0Ev,_ZTvn16_n36_N8S8279C13D0Ev),
};
extern void ABISELECT(_ZTvn40_n72_N8S8279C13D1Ev,_ZTvn20_n36_N8S8279C13D1Ev)();
extern void ABISELECT(_ZTvn40_n72_N8S8279C13D0Ev,_ZTvn20_n36_N8S8279C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C158S8279C14__A3__8S8279C138S8279C16__A1__8S8279C11[] = {
  ABISELECT(-176,-88),
  ABISELECT(-176,-88),
  ABISELECT(40,24),
  (VTBL_ENTRY)&(_ZTI8S8279C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn40_n72_N8S8279C13D1Ev,_ZTvn20_n36_N8S8279C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn40_n72_N8S8279C13D0Ev,_ZTvn20_n36_N8S8279C13D0Ev),
};
extern void _ZN8S8279C15D1Ev();
extern void _ZN8S8279C15D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C158S8279C16__A1__8S8279C11[] = {
  ABISELECT(-120,-64),
  ABISELECT(-224,-116),
  ABISELECT(-224,-116),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN8S8279C15D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C15D0Ev,
};
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C158S8279C16__A4__8S8279C11[] = {
  ABISELECT(-232,-120),
  ABISELECT(-232,-120),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C88S8279C158S8279C16__A4__8S8279C11[] = {
  0,
  0,
  ABISELECT(232,120),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C158S8279C16__A1__8S8279C11[] = {
  0,
  0,
  ABISELECT(224,116),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev)();
extern void ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C158S8279C16__A1__8S8279C11[] = {
  ABISELECT(8,4),
  ABISELECT(120,64),
  ABISELECT(-104,-52),
  ABISELECT(120,64),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C158S8279C16__A1__8S8279C11[] = {
  ABISELECT(-112,-56),
  ABISELECT(112,60),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZThn8_N8S8279C15D1Ev,_ZThn4_N8S8279C15D1Ev)();
extern void ABISELECT(_ZThn8_N8S8279C15D0Ev,_ZThn4_N8S8279C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C8__8S8279C158S8279C16__A1__8S8279C11[] = {
  ABISELECT(-232,-120),
  ABISELECT(-232,-120),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C15D1Ev,_ZThn4_N8S8279C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C15D0Ev,_ZThn4_N8S8279C15D0Ev),
};
extern void _ZN7S8279C52v1Ev();
extern void _ZN8S8279C17D1Ev();
extern void _ZN8S8279C17D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C178S8279C16__8S8279C11[] = {
  ABISELECT(-144,-76),
  ABISELECT(-248,-128),
  ABISELECT(16,8),
  ABISELECT(-248,-128),
  ABISELECT(-248,-128),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&_ZN8S8279C17D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C17D0Ev,
};
extern void ABISELECT(_ZTv0_n48_N8S8279C17D1Ev,_ZTv0_n24_N8S8279C17D1Ev)();
extern void ABISELECT(_ZThn16_N8S8279C17D1Ev,_ZThn8_N8S8279C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S8279C17D0Ev,_ZTv0_n24_N8S8279C17D0Ev)();
extern void ABISELECT(_ZThn16_N8S8279C17D0Ev,_ZThn8_N8S8279C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S8279C15__8S8279C178S8279C16__8S8279C11[] = {
  ABISELECT(-16,-8),
  ABISELECT(-160,-84),
  ABISELECT(-264,-136),
  ABISELECT(-264,-136),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C17D1Ev,_ZTv0_n24_N8S8279C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C17D0Ev,_ZTv0_n24_N8S8279C17D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C178S8279C16__8S8279C11[] = {
  0,
  0,
  ABISELECT(248,128),
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S8279C17D1Ev,_ZTv0_n16_N8S8279C17D1Ev)();
extern void ABISELECT(_ZTv0_n32_N8S8279C17D0Ev,_ZTv0_n16_N8S8279C17D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C178S8279C16__8S8279C11[] = {
  ABISELECT(8,4),
  ABISELECT(144,76),
  ABISELECT(-104,-52),
  ABISELECT(144,76),
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C17D1Ev,_ZTv0_n16_N8S8279C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C17D0Ev,_ZTv0_n16_N8S8279C17D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C178S8279C16__8S8279C11[] = {
  ABISELECT(-112,-56),
  ABISELECT(136,72),
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTvn8_n48_N8S8279C17D1Ev,_ZTvn4_n24_N8S8279C17D1Ev)();
extern void ABISELECT(_ZTvn8_n48_N8S8279C17D0Ev,_ZTvn4_n24_N8S8279C17D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C15__8S8279C178S8279C16__8S8279C11[] = {
  ABISELECT(-272,-140),
  ABISELECT(-272,-140),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S8279C17D1Ev,_ZTvn4_n24_N8S8279C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S8279C17D0Ev,_ZTvn4_n24_N8S8279C17D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N8S8279C16D1Ev,_ZTv0_n20_N8S8279C16D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S8279C16D0Ev,_ZTv0_n20_N8S8279C16D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C8__8S8279C16__8S8279C11[] = {
  ABISELECT(16,8),
  ABISELECT(-200,-104),
  ABISELECT(-200,-104),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C16D1Ev,_ZTv0_n20_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S8279C16D0Ev,_ZTv0_n20_N8S8279C16D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C16__8S8279C11[] = {
  0,
  0,
  ABISELECT(216,112),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n56_N8S8279C16D1Ev,_ZTv0_n28_N8S8279C16D1Ev)();
extern void ABISELECT(_ZTv0_n56_N8S8279C16D0Ev,_ZTv0_n28_N8S8279C16D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C3__8S8279C16__8S8279C11[] = {
  ABISELECT(128,68),
  ABISELECT(40,20),
  ABISELECT(16,8),
  ABISELECT(-88,-44),
  ABISELECT(-88,-44),
  ABISELECT(128,68),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S8279C16D1Ev,_ZTv0_n28_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S8279C16D0Ev,_ZTv0_n28_N8S8279C16D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S8279C16D1Ev,_ZTv0_n16_N8S8279C16D1Ev)();
extern void ABISELECT(_ZTv0_n32_N8S8279C16D0Ev,_ZTv0_n16_N8S8279C16D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C16__8S8279C11[] = {
  ABISELECT(8,4),
  ABISELECT(112,60),
  ABISELECT(-104,-52),
  ABISELECT(112,60),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C16D1Ev,_ZTv0_n16_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C16D0Ev,_ZTv0_n16_N8S8279C16D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C16__8S8279C11[] = {
  ABISELECT(-112,-56),
  ABISELECT(104,56),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S8279C16D1Ev,_ZTv0_n12_N8S8279C16D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S8279C16D0Ev,_ZTv0_n12_N8S8279C16D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S814C5_nt__A2__8S8279C16__8S8279C11[] = {
  ABISELECT(88,48),
  ABISELECT(88,48),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C16D1Ev,_ZTv0_n12_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S8279C16D0Ev,_ZTv0_n12_N8S8279C16D0Ev),
};
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTv0_n72_N8S8279C16D1Ev,_ZTv0_n36_N8S8279C16D1Ev)();
extern void ABISELECT(_ZTv0_n72_N8S8279C16D0Ev,_ZTv0_n36_N8S8279C16D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S8279C14__8S8279C16__8S8279C11[] = {
  ABISELECT(80,44),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-32,-16),
  ABISELECT(-136,-68),
  ABISELECT(64,36),
  ABISELECT(-136,-68),
  ABISELECT(80,44),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S8279C16D1Ev,_ZTv0_n36_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S8279C16D0Ev,_ZTv0_n36_N8S8279C16D0Ev),
};
extern void ABISELECT(_ZTvn8_n72_N8S8279C16D1Ev,_ZTvn4_n36_N8S8279C16D1Ev)();
extern void ABISELECT(_ZTvn8_n72_N8S8279C16D0Ev,_ZTvn4_n36_N8S8279C16D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C38S8279C14__A1__8S8279C16__8S8279C11[] = {
  ABISELECT(-16,-8),
  ABISELECT(-40,-20),
  ABISELECT(-144,-72),
  ABISELECT(-144,-72),
  ABISELECT(72,40),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n72_N8S8279C16D1Ev,_ZTvn4_n36_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n72_N8S8279C16D0Ev,_ZTvn4_n36_N8S8279C16D0Ev),
};
extern void ABISELECT(_ZTvn24_n72_N8S8279C16D1Ev,_ZTvn12_n36_N8S8279C16D1Ev)();
extern void ABISELECT(_ZTvn24_n72_N8S8279C16D0Ev,_ZTvn12_n36_N8S8279C16D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S814C5_nt8S8279C14__A5__8S8279C16__8S8279C11[] = {
  ABISELECT(56,32),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn24_n72_N8S8279C16D1Ev,_ZTvn12_n36_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn24_n72_N8S8279C16D0Ev,_ZTvn12_n36_N8S8279C16D0Ev),
};
extern void ABISELECT(_ZTvn32_n72_N8S8279C16D1Ev,_ZTvn16_n36_N8S8279C16D1Ev)();
extern void ABISELECT(_ZTvn32_n72_N8S8279C16D0Ev,_ZTvn16_n36_N8S8279C16D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S8279C158S8279C14__8S8279C16__8S8279C11[] = {
  ABISELECT(-64,-32),
  ABISELECT(-168,-84),
  ABISELECT(-168,-84),
  ABISELECT(48,28),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n72_N8S8279C16D1Ev,_ZTvn16_n36_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n72_N8S8279C16D0Ev,_ZTvn16_n36_N8S8279C16D0Ev),
};
extern void ABISELECT(_ZTvn40_n72_N8S8279C16D1Ev,_ZTvn20_n36_N8S8279C16D1Ev)();
extern void ABISELECT(_ZTvn40_n72_N8S8279C16D0Ev,_ZTvn20_n36_N8S8279C16D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C158S8279C14__A3__8S8279C16__8S8279C11[] = {
  ABISELECT(-176,-88),
  ABISELECT(-176,-88),
  ABISELECT(40,24),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn40_n72_N8S8279C16D1Ev,_ZTvn20_n36_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn40_n72_N8S8279C16D0Ev,_ZTvn20_n36_N8S8279C16D0Ev),
};
extern void ABISELECT(_ZThn8_N8S8279C16D1Ev,_ZThn4_N8S8279C16D1Ev)();
extern void ABISELECT(_ZThn8_N8S8279C16D0Ev,_ZThn4_N8S8279C16D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S8279C15__A__8S8279C16__8S8279C11[] = {
  ABISELECT(-120,-64),
  ABISELECT(-224,-116),
  ABISELECT(-224,-116),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C16D1Ev,_ZThn4_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C16D0Ev,_ZThn4_N8S8279C16D0Ev),
};
extern void ABISELECT(_ZThn16_N8S8279C16D1Ev,_ZThn8_N8S8279C16D1Ev)();
extern void ABISELECT(_ZThn16_N8S8279C16D0Ev,_ZThn8_N8S8279C16D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C15__A4__8S8279C16__8S8279C11[] = {
  ABISELECT(-232,-120),
  ABISELECT(-232,-120),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S8279C16D1Ev,_ZThn8_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S8279C16D0Ev,_ZThn8_N8S8279C16D0Ev),
};
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZThn32_N8S8279C16D1Ev,_ZThn16_N8S8279C16D1Ev)();
extern void ABISELECT(_ZThn32_N8S8279C16D0Ev,_ZThn16_N8S8279C16D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S8279C17__8S8279C16__8S8279C11[] = {
  ABISELECT(-144,-76),
  ABISELECT(-248,-128),
  ABISELECT(16,8),
  ABISELECT(-248,-128),
  ABISELECT(-248,-128),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S8279C16D1Ev,_ZThn16_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S8279C16D0Ev,_ZThn16_N8S8279C16D0Ev),
};
extern void ABISELECT(_ZTv0_n48_N8S8279C16D1Ev,_ZTv0_n24_N8S8279C16D1Ev)();
extern void ABISELECT(_ZThn48_N8S8279C16D1Ev,_ZThn24_N8S8279C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S8279C16D0Ev,_ZTv0_n24_N8S8279C16D0Ev)();
extern void ABISELECT(_ZThn48_N8S8279C16D0Ev,_ZThn24_N8S8279C16D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S8279C15__A2__8S8279C16__8S8279C11[] = {
  ABISELECT(-48,-24),
  ABISELECT(-160,-84),
  ABISELECT(-264,-136),
  ABISELECT(-264,-136),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C16D1Ev,_ZTv0_n24_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C16D0Ev,_ZTv0_n24_N8S8279C16D0Ev),
};
extern void ABISELECT(_ZTvn8_n48_N8S8279C16D1Ev,_ZTvn4_n24_N8S8279C16D1Ev)();
extern void ABISELECT(_ZTvn8_n48_N8S8279C16D0Ev,_ZTvn4_n24_N8S8279C16D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C15__A5__8S8279C16__8S8279C11[] = {
  ABISELECT(-272,-140),
  ABISELECT(-272,-140),
  ABISELECT(-56,-28),
  (VTBL_ENTRY)&(_ZTI8S8279C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S8279C16D1Ev,_ZTvn4_n24_N8S8279C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S8279C16D0Ev,_ZTvn4_n24_N8S8279C16D0Ev),
};
extern void _ZN8S8279C15D1Ev();
extern void _ZN8S8279C15D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C15__A2__8S8279C11[] = {
  ABISELECT(-160,-84),
  ABISELECT(-264,-136),
  ABISELECT(-264,-136),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN8S8279C15D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C15D0Ev,
};
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C15__A5__8S8279C11[] = {
  ABISELECT(-272,-140),
  ABISELECT(-272,-140),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C88S8279C15__A5__8S8279C11[] = {
  0,
  0,
  ABISELECT(272,140),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C15__A2__8S8279C11[] = {
  0,
  0,
  ABISELECT(264,136),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev)();
extern void ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C15__A2__8S8279C11[] = {
  ABISELECT(8,4),
  ABISELECT(160,84),
  ABISELECT(-104,-52),
  ABISELECT(160,84),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C15__A2__8S8279C11[] = {
  ABISELECT(-112,-56),
  ABISELECT(152,80),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZThn8_N8S8279C15D1Ev,_ZThn4_N8S8279C15D1Ev)();
extern void ABISELECT(_ZThn8_N8S8279C15D0Ev,_ZThn4_N8S8279C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C8__8S8279C15__A2__8S8279C11[] = {
  ABISELECT(-272,-140),
  ABISELECT(-272,-140),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C15D1Ev,_ZThn4_N8S8279C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C15D0Ev,_ZThn4_N8S8279C15D0Ev),
};
extern void _ZN8S8279C18D1Ev();
extern void _ZN8S8279C18D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C18__8S8279C11[] = {
  ABISELECT(40,24),
  ABISELECT(32,20),
  ABISELECT(-288,-148),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C18[0]),
  (VTBL_ENTRY)&_ZN8S8279C18D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C18D0Ev,
};
extern void _ZN7S8279C6D1Ev();
extern void _ZN7S8279C6D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C68S8279C18__A1__8S8279C11[] = {
  ABISELECT(-288,-148),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C6[0]),
  (VTBL_ENTRY)&_ZN7S8279C6D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C6D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C68S8279C18__A4__8S8279C11[] = {
  ABISELECT(-296,-152),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C68S8279C18__A1__8S8279C11[] = {
  ABISELECT(-296,-152),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S8279C6[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
static  VTBL_ENTRY _tg__ZTV8S8279C19__8S8279C18__8S8279C11[] = {
  ABISELECT(-320,-168),
  ABISELECT(8,4),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI8S8279C18[0]),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C20__8S8279C18__8S8279C11[] = {
  0,
  ABISELECT(-328,-172),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI8S8279C18[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C18__8S8279C11[] = {
  ABISELECT(-296,-152),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C18[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
static  VTBL_ENTRY _tg__ZTV8S8279C19__8S8279C11[] = {
  ABISELECT(-320,-168),
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C19[0]),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C20__8S8279C19__8S8279C11[] = {
  0,
  ABISELECT(-328,-172),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C19[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C20__8S8279C11[] = {
  ABISELECT(-328,-172),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C20[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C58S8279C20__A3__8S8279C11[] = {
  ABISELECT(-328,-172),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
static  VTT_ENTRY vtt_S8279C11[] = {
  {&(_ZTV8S8279C11[17]),  17,163},
  {&(_tg__ZTV8S8279C12__8S8279C11[17]),  17,20},
  {&(_tg__ZTV8S8279C12__8S8279C11[17]),  17,20},
  {&(_tg__ZTV8S8279C12__8S8279C11[17]),  17,20},
  {&(_tg__ZTV7S8279C3__8S8279C12__8S8279C11[7]),  7,9},
  {&(_tg__ZTV7S8279C6__8S8279C12__8S8279C11[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C12__8S8279C11[3]),  3,4},
  {&(_tg__ZTV9S814C5_nt__A1__8S8279C12__8S8279C11[3]),  3,5},
  {&(_tg__ZTV8S8279C14__8S8279C12__8S8279C11[9]),  9,12},
  {&(_tg__ZTV7S8279C8__A1__8S8279C12__8S8279C11[5]),  5,7},
  {&(_tg__ZTV7S8279C38S8279C14__A1__8S8279C12__8S8279C11[6]),  6,8},
  {&(_tg__ZTV9S814C5_nt8S8279C14__A5__8S8279C12__8S8279C11[2]),  2,4},
  {&(_tg__ZTV8S8279C158S8279C14__8S8279C12__8S8279C11[5]),  5,7},
  {&(_tg__ZTV7S8279C88S8279C158S8279C14__A3__8S8279C12__8S8279C11[4]),  4,6},
  {&(_tg__ZTV8S8279C16__8S8279C12__8S8279C11[12]),  12,15},
  {&(_tg__ZTV8S8279C158S8279C16__A1__8S8279C12__8S8279C11[5]),  5,7},
  {&(_tg__ZTV7S8279C88S8279C158S8279C16__A4__8S8279C12__8S8279C11[4]),  4,6},
  {&(_tg__ZTV8S8279C178S8279C16__8S8279C12__8S8279C11[7]),  7,10},
  {&(_tg__ZTV8S8279C15__A2__8S8279C12__8S8279C11[6]),  6,8},
  {&(_tg__ZTV7S8279C88S8279C15__A5__8S8279C12__8S8279C11[4]),  4,6},
  {&(_tg__ZTV8S8279C18__8S8279C12__8S8279C11[7]),  7,9},
  {&(_tg__ZTV8S8279C19__8S8279C12__8S8279C11[4]),  4,4},
  {&(_tg__ZTV8S8279C20__8S8279C12__8S8279C11[4]),  4,5},
  {&(_tg__ZTV7S8279C57S8279C68S8279C18__A4__8S8279C12__8S8279C11[3]),  3,4},
  {&(_ZTV8S8279C11[17]),  17,163},
  {&(_ZTV8S8279C11[17]),  17,163},
  {&(_ZTV8S8279C11[27]),  27,163},
  {&(_ZTV8S8279C11[34]),  34,163},
  {&(_ZTV8S8279C11[39]),  39,163},
  {&(_ZTV8S8279C11[43]),  43,163},
  {&(_ZTV8S8279C11[54]),  54,163},
  {&(_ZTV8S8279C11[87]),  87,163},
  {&(_ZTV8S8279C11[63]),  63,163},
  {&(_ZTV8S8279C11[67]),  67,163},
  {&(_ZTV8S8279C11[74]),  74,163},
  {&(_ZTV8S8279C11[80]),  80,163},
  {&(_ZTV8S8279C11[101]),  101,163},
  {&(_ZTV8S8279C11[109]),  109,163},
  {&(_ZTV8S8279C11[115]),  115,163},
  {&(_ZTV8S8279C11[124]),  124,163},
  {&(_ZTV8S8279C11[133]),  133,163},
  {&(_ZTV8S8279C11[139]),  139,163},
  {&(_ZTV8S8279C11[148]),  148,163},
  {&(_ZTV8S8279C11[158]),  158,163},
  {&(_ZTV8S8279C11[162]),  162,163},
  {&(_ZTV8S8279C11[153]),  153,163},
  {&(_tg__ZTV8S8279C13__8S8279C11[10]),  10,13},
  {&(_tg__ZTV8S8279C13__8S8279C11[10]),  10,13},
  {&(_tg__ZTV7S8279C3__8S8279C13__8S8279C11[7]),  7,9},
  {&(_tg__ZTV7S8279C6__8S8279C13__8S8279C11[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C13__8S8279C11[3]),  3,4},
  {&(_tg__ZTV9S814C5_nt__A1__8S8279C13__8S8279C11[3]),  3,5},
  {&(_tg__ZTV8S8279C14__8S8279C13__8S8279C11[9]),  9,12},
  {&(_tg__ZTV7S8279C8__A1__8S8279C13__8S8279C11[5]),  5,7},
  {&(_tg__ZTV7S8279C38S8279C14__A1__8S8279C13__8S8279C11[6]),  6,8},
  {&(_tg__ZTV9S814C5_nt8S8279C14__A5__8S8279C13__8S8279C11[2]),  2,4},
  {&(_tg__ZTV8S8279C158S8279C14__8S8279C13__8S8279C11[5]),  5,7},
  {&(_tg__ZTV7S8279C88S8279C158S8279C14__A3__8S8279C13__8S8279C11[4]),  4,6},
  {&(_tg__ZTV7S8279C5__8S8279C11[3]),  3,4},
  {&(_tg__ZTV7S8279C3__8S8279C11[6]),  6,8},
  {&(_tg__ZTV7S8279C87S8279C3__8S8279C11[4]),  4,6},
  {&(_tg__ZTV7S8279C5__7S8279C87S8279C3__8S8279C11[4]),  4,5},
  {&(_tg__ZTV7S8279C5__7S8279C3__8S8279C11[4]),  4,5},
  {&(_tg__ZTV7S8279C6__7S8279C3__8S8279C11[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__7S8279C3__8S8279C11[3]),  3,4},
  {&(_tg__ZTV9S814C5_nt__A1__7S8279C3__8S8279C11[3]),  3,5},
  {&(_tg__ZTV7S8279C6__8S8279C11[3]),  3,5},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C11[3]),  3,4},
  {&(_tg__ZTV7S8279C5__7S8279C6__8S8279C11[3]),  3,4},
  {&(_tg__ZTV8S8279C14__8S8279C11[7]),  7,10},
  {&(_tg__ZTV7S8279C58S8279C14__A2__8S8279C11[3]),  3,4},
  {&(_tg__ZTV7S8279C38S8279C14__A1__8S8279C11[6]),  6,8},
  {&(_tg__ZTV7S8279C87S8279C38S8279C14__A2__8S8279C11[4]),  4,6},
  {&(_tg__ZTV7S8279C5__7S8279C87S8279C38S8279C14__A2__8S8279C11[4]),  4,5},
  {&(_tg__ZTV7S8279C5__7S8279C38S8279C14__A1__8S8279C11[4]),  4,5},
  {&(_tg__ZTV7S8279C6__7S8279C38S8279C14__A1__8S8279C11[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__7S8279C38S8279C14__A1__8S8279C11[3]),  3,4},
  {&(_tg__ZTV9S814C5_nt__A1__7S8279C38S8279C14__A1__8S8279C11[3]),  3,5},
  {&(_tg__ZTV8S8279C158S8279C14__8S8279C11[5]),  5,7},
  {&(_tg__ZTV7S8279C88S8279C158S8279C14__A3__8S8279C11[4]),  4,6},
  {&(_tg__ZTV7S8279C5__7S8279C88S8279C158S8279C14__A3__8S8279C11[4]),  4,5},
  {&(_tg__ZTV7S8279C5__8S8279C158S8279C14__8S8279C11[4]),  4,5},
  {&(_tg__ZTV7S8279C6__8S8279C158S8279C14__8S8279C11[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C158S8279C14__8S8279C11[3]),  3,4},
  {&(_tg__ZTV7S8279C8__8S8279C158S8279C14__8S8279C11[4]),  4,6},
  {&(_tg__ZTV7S8279C8__8S8279C14__8S8279C11[5]),  5,7},
  {&(_tg__ZTV7S8279C5__8S8279C14__8S8279C11[4]),  4,5},
  {&(_tg__ZTV7S8279C3__8S8279C14__8S8279C11[6]),  6,8},
  {&(_tg__ZTV7S8279C6__8S8279C14__8S8279C11[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A2__8S8279C14__8S8279C11[3]),  3,4},
  {&(_tg__ZTV9S814C5_nt__A2__8S8279C14__8S8279C11[3]),  3,5},
  {&(_tg__ZTV8S8279C15__8S8279C14__8S8279C11[5]),  5,7},
  {&(_tg__ZTV7S8279C88S8279C15__A2__8S8279C14__8S8279C11[4]),  4,6},
  {&(_tg__ZTV7S8279C8__A1__8S8279C11[4]),  4,6},
  {&(_tg__ZTV7S8279C5__7S8279C8__A1__8S8279C11[4]),  4,5},
  {&(_tg__ZTV8S8279C16__8S8279C11[11]),  11,14},
  {&(_tg__ZTV8S8279C138S8279C16__A1__8S8279C11[10]),  10,13},
  {&(_tg__ZTV7S8279C5__8S8279C138S8279C16__A1__8S8279C11[4]),  4,5},
  {&(_tg__ZTV7S8279C3__8S8279C138S8279C16__A1__8S8279C11[7]),  7,9},
  {&(_tg__ZTV7S8279C6__8S8279C138S8279C16__A1__8S8279C11[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C138S8279C16__A1__8S8279C11[3]),  3,4},
  {&(_tg__ZTV9S814C5_nt__A1__8S8279C138S8279C16__A1__8S8279C11[3]),  3,5},
  {&(_tg__ZTV8S8279C14__8S8279C138S8279C16__A1__8S8279C11[9]),  9,12},
  {&(_tg__ZTV7S8279C8__A1__8S8279C138S8279C16__A1__8S8279C11[5]),  5,7},
  {&(_tg__ZTV7S8279C38S8279C14__A1__8S8279C138S8279C16__A1__8S8279C11[6]),  6,8},
  {&(_tg__ZTV9S814C5_nt8S8279C14__A5__8S8279C138S8279C16__A1__8S8279C11[2]),  2,4},
  {&(_tg__ZTV8S8279C158S8279C14__8S8279C138S8279C16__A1__8S8279C11[5]),  5,7},
  {&(_tg__ZTV7S8279C88S8279C158S8279C14__A3__8S8279C138S8279C16__A1__8S8279C11[4]),  4,6},
  {&(_tg__ZTV8S8279C158S8279C16__A1__8S8279C11[5]),  5,7},
  {&(_tg__ZTV7S8279C88S8279C158S8279C16__A4__8S8279C11[4]),  4,6},
  {&(_tg__ZTV7S8279C5__7S8279C88S8279C158S8279C16__A4__8S8279C11[4]),  4,5},
  {&(_tg__ZTV7S8279C5__8S8279C158S8279C16__A1__8S8279C11[4]),  4,5},
  {&(_tg__ZTV7S8279C6__8S8279C158S8279C16__A1__8S8279C11[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C158S8279C16__A1__8S8279C11[3]),  3,4},
  {&(_tg__ZTV7S8279C8__8S8279C158S8279C16__A1__8S8279C11[4]),  4,6},
  {&(_tg__ZTV8S8279C178S8279C16__8S8279C11[7]),  7,10},
  {&(_tg__ZTV8S8279C15__8S8279C178S8279C16__8S8279C11[6]),  6,8},
  {&(_tg__ZTV7S8279C5__8S8279C178S8279C16__8S8279C11[4]),  4,5},
  {&(_tg__ZTV7S8279C6__8S8279C178S8279C16__8S8279C11[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C178S8279C16__8S8279C11[3]),  3,4},
  {&(_tg__ZTV7S8279C88S8279C15__8S8279C178S8279C16__8S8279C11[4]),  4,6},
  {&(_tg__ZTV7S8279C8__8S8279C16__8S8279C11[5]),  5,7},
  {&(_tg__ZTV7S8279C5__8S8279C16__8S8279C11[4]),  4,5},
  {&(_tg__ZTV7S8279C3__8S8279C16__8S8279C11[7]),  7,9},
  {&(_tg__ZTV7S8279C6__8S8279C16__8S8279C11[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C16__8S8279C11[3]),  3,4},
  {&(_tg__ZTV9S814C5_nt__A2__8S8279C16__8S8279C11[3]),  3,5},
  {&(_tg__ZTV8S8279C14__8S8279C16__8S8279C11[9]),  9,12},
  {&(_tg__ZTV7S8279C38S8279C14__A1__8S8279C16__8S8279C11[6]),  6,8},
  {&(_tg__ZTV9S814C5_nt8S8279C14__A5__8S8279C16__8S8279C11[2]),  2,4},
  {&(_tg__ZTV8S8279C158S8279C14__8S8279C16__8S8279C11[5]),  5,7},
  {&(_tg__ZTV7S8279C88S8279C158S8279C14__A3__8S8279C16__8S8279C11[4]),  4,6},
  {&(_tg__ZTV8S8279C15__A__8S8279C16__8S8279C11[5]),  5,7},
  {&(_tg__ZTV7S8279C88S8279C15__A4__8S8279C16__8S8279C11[4]),  4,6},
  {&(_tg__ZTV8S8279C17__8S8279C16__8S8279C11[7]),  7,10},
  {&(_tg__ZTV8S8279C15__A2__8S8279C16__8S8279C11[6]),  6,8},
  {&(_tg__ZTV7S8279C88S8279C15__A5__8S8279C16__8S8279C11[4]),  4,6},
  {&(_tg__ZTV8S8279C15__A2__8S8279C11[5]),  5,7},
  {&(_tg__ZTV7S8279C88S8279C15__A5__8S8279C11[4]),  4,6},
  {&(_tg__ZTV7S8279C5__7S8279C88S8279C15__A5__8S8279C11[4]),  4,5},
  {&(_tg__ZTV7S8279C5__8S8279C15__A2__8S8279C11[4]),  4,5},
  {&(_tg__ZTV7S8279C6__8S8279C15__A2__8S8279C11[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C15__A2__8S8279C11[3]),  3,4},
  {&(_tg__ZTV7S8279C8__8S8279C15__A2__8S8279C11[4]),  4,6},
  {&(_tg__ZTV8S8279C18__8S8279C11[5]),  5,7},
  {&(_tg__ZTV7S8279C68S8279C18__A1__8S8279C11[3]),  3,5},
  {&(_tg__ZTV7S8279C57S8279C68S8279C18__A4__8S8279C11[3]),  3,4},
  {&(_tg__ZTV7S8279C5__7S8279C68S8279C18__A1__8S8279C11[3]),  3,4},
  {&(_tg__ZTV8S8279C19__8S8279C18__8S8279C11[4]),  4,4},
  {&(_tg__ZTV8S8279C20__8S8279C18__8S8279C11[4]),  4,5},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C18__8S8279C11[3]),  3,4},
  {&(_tg__ZTV8S8279C19__8S8279C11[4]),  4,4},
  {&(_tg__ZTV8S8279C20__8S8279C19__8S8279C11[4]),  4,5},
  {&(_tg__ZTV8S8279C20__8S8279C11[3]),  3,4},
  {&(_tg__ZTV7S8279C58S8279C20__A3__8S8279C11[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8S8279C11[];
extern  VTBL_ENTRY _ZTV8S8279C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C11[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S8279C16D0Ev,_ZTv0_n24_N8S8279C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S8279C16D0Ev,_ZThn24_N8S8279C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S8279C16D1Ev,_ZTv0_n24_N8S8279C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S8279C16D1Ev,_ZThn24_N8S8279C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S8279C17D0Ev,_ZTv0_n24_N8S8279C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S8279C17D0Ev,_ZThn8_N8S8279C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S8279C17D1Ev,_ZTv0_n24_N8S8279C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S8279C17D1Ev,_ZThn8_N8S8279C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S8279C14D0Ev,_ZTv0_n20_N8S8279C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N8S8279C14D0Ev,_ZThn36_N8S8279C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S8279C14D1Ev,_ZTv0_n20_N8S8279C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N8S8279C14D1Ev,_ZThn36_N8S8279C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S8279C3D0Ev,_ZTv0_n12_N7S8279C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N7S8279C3D0Ev,_ZThn20_N7S8279C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S8279C3D1Ev,_ZTv0_n12_N7S8279C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N7S8279C3D1Ev,_ZThn20_N7S8279C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S8279C3D0Ev,_ZTv0_n16_N7S8279C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7S8279C3D0Ev,_ZThn8_N7S8279C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S8279C3D1Ev,_ZTv0_n16_N7S8279C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7S8279C3D1Ev,_ZThn8_N7S8279C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S8279C13D0Ev,_ZTv0_n20_N8S8279C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn200_N8S8279C13D0Ev,_ZThn104_N8S8279C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S8279C13D1Ev,_ZTv0_n20_N8S8279C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn200_N8S8279C13D1Ev,_ZThn104_N8S8279C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S8279C13D0Ev,_ZTv0_n36_N8S8279C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn136_N8S8279C13D0Ev,_ZThn68_N8S8279C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S8279C13D1Ev,_ZTv0_n36_N8S8279C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn136_N8S8279C13D1Ev,_ZThn68_N8S8279C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S8279C13D0Ev,_ZTv0_n12_N8S8279C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn128_N8S8279C13D0Ev,_ZThn64_N8S8279C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S8279C13D1Ev,_ZTv0_n12_N8S8279C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn128_N8S8279C13D1Ev,_ZThn64_N8S8279C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C13D0Ev,_ZTv0_n16_N8S8279C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N8S8279C13D0Ev,_ZThn52_N8S8279C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C13D1Ev,_ZTv0_n16_N8S8279C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N8S8279C13D1Ev,_ZThn52_N8S8279C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S8279C13D0Ev,_ZTv0_n28_N8S8279C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn88_N8S8279C13D0Ev,_ZThn44_N8S8279C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S8279C13D1Ev,_ZTv0_n28_N8S8279C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn88_N8S8279C13D1Ev,_ZThn44_N8S8279C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S8279C12D0Ev,_ZTv0_n24_N8S8279C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn288_N8S8279C12D0Ev,_ZThn148_N8S8279C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn264_N8S8279C12D0Ev,_ZThn136_N8S8279C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S8279C12D1Ev,_ZTv0_n24_N8S8279C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn288_N8S8279C12D1Ev,_ZThn148_N8S8279C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn264_N8S8279C12D1Ev,_ZThn136_N8S8279C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N8S8279C12D0Ev,_ZTv0_n48_N8S8279C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn216_N8S8279C12D0Ev,_ZThn112_N8S8279C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N8S8279C12D1Ev,_ZTv0_n48_N8S8279C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn216_N8S8279C12D1Ev,_ZThn112_N8S8279C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S8279C12D0Ev,_ZTv0_n20_N8S8279C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn200_N8S8279C12D0Ev,_ZThn104_N8S8279C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S8279C12D1Ev,_ZTv0_n20_N8S8279C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn200_N8S8279C12D1Ev,_ZThn104_N8S8279C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S8279C12D0Ev,_ZTv0_n36_N8S8279C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn136_N8S8279C12D0Ev,_ZThn68_N8S8279C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S8279C12D1Ev,_ZTv0_n36_N8S8279C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn136_N8S8279C12D1Ev,_ZThn68_N8S8279C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S8279C12D0Ev,_ZTv0_n12_N8S8279C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn128_N8S8279C12D0Ev,_ZThn64_N8S8279C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S8279C12D1Ev,_ZTv0_n12_N8S8279C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn128_N8S8279C12D1Ev,_ZThn64_N8S8279C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C12D0Ev,_ZTv0_n16_N8S8279C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N8S8279C12D0Ev,_ZThn52_N8S8279C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C12D1Ev,_ZTv0_n16_N8S8279C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N8S8279C12D1Ev,_ZThn52_N8S8279C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S8279C12D0Ev,_ZTv0_n28_N8S8279C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn88_N8S8279C12D0Ev,_ZThn44_N8S8279C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S8279C12D1Ev,_ZTv0_n28_N8S8279C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn88_N8S8279C12D1Ev,_ZThn44_N8S8279C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n88_N8S8279C12D0Ev,_ZTv0_n44_N8S8279C12D0Ev), // 
  (VTBL_ENTRY)_ZN8S8279C12D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n88_N8S8279C12D1Ev,_ZTv0_n44_N8S8279C12D1Ev), // 
  (VTBL_ENTRY)_ZN8S8279C12D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S8279C11D0Ev,_ZTv0_n24_N8S8279C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn288_N8S8279C11D0Ev,_ZThn148_N8S8279C11D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn264_N8S8279C11D0Ev,_ZThn136_N8S8279C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S8279C11D1Ev,_ZTv0_n24_N8S8279C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn288_N8S8279C11D1Ev,_ZThn148_N8S8279C11D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn264_N8S8279C11D1Ev,_ZThn136_N8S8279C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N8S8279C11D0Ev,_ZTv0_n48_N8S8279C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn216_N8S8279C11D0Ev,_ZThn112_N8S8279C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N8S8279C11D1Ev,_ZTv0_n48_N8S8279C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn216_N8S8279C11D1Ev,_ZThn112_N8S8279C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S8279C11D0Ev,_ZTv0_n20_N8S8279C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn200_N8S8279C11D0Ev,_ZThn104_N8S8279C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S8279C11D1Ev,_ZTv0_n20_N8S8279C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn200_N8S8279C11D1Ev,_ZThn104_N8S8279C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S8279C11D0Ev,_ZTv0_n36_N8S8279C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn136_N8S8279C11D0Ev,_ZThn68_N8S8279C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S8279C11D1Ev,_ZTv0_n36_N8S8279C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn136_N8S8279C11D1Ev,_ZThn68_N8S8279C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S8279C11D0Ev,_ZTv0_n12_N8S8279C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn128_N8S8279C11D0Ev,_ZThn64_N8S8279C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S8279C11D1Ev,_ZTv0_n12_N8S8279C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn128_N8S8279C11D1Ev,_ZThn64_N8S8279C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C11D0Ev,_ZTv0_n16_N8S8279C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N8S8279C11D0Ev,_ZThn52_N8S8279C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C11D1Ev,_ZTv0_n16_N8S8279C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N8S8279C11D1Ev,_ZThn52_N8S8279C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S8279C11D0Ev,_ZTv0_n28_N8S8279C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn88_N8S8279C11D0Ev,_ZThn44_N8S8279C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S8279C11D1Ev,_ZTv0_n28_N8S8279C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn88_N8S8279C11D1Ev,_ZThn44_N8S8279C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n88_N8S8279C11D0Ev,_ZTv0_n44_N8S8279C11D0Ev), // 
  (VTBL_ENTRY)_ZN8S8279C11D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n88_N8S8279C11D1Ev,_ZTv0_n44_N8S8279C11D1Ev), // 
  (VTBL_ENTRY)_ZN8S8279C11D1Ev,
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S8279C11 = {  "S8279C11", // class name
  bases_S8279C11, 42,
  &(vtc_S8279C11[0]), // expected_vtbl_contents
  &(vtt_S8279C11[0]), // expected_vtt_contents
  ABISELECT(344,180), // object size
  NSPAIRA(_ZTI8S8279C11),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S8279C11),163, //virtual function table var
  17, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S8279C11),155, //virtual table table var
  40, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8279C26  {
  void  mf8279c26(); // _ZN8S8279C269mf8279c26Ev
};
//SIG(-1 S8279C26) C1{ m}


void  S8279C26 ::mf8279c26(){}

static void Test_S8279C26()
{
  {
    init_simple_test("S8279C26");
    S8279C26 lv;
    check2(sizeof(lv), 1, "sizeof(S8279C26)");
    check2(__alignof__(lv), 1, "__alignof__(S8279C26)");
  }
}
static Arrange_To_Call_Me vS8279C26(Test_S8279C26, "S8279C26", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S8279C26[];
VTBL_ENTRY *P__ZTI8S8279C26 = _ZTI8S8279C26; 
Class_Descriptor cd_S8279C26 = {  "S8279C26", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S8279C26),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8279C28  : virtual S8279C17 , S814C5_nt , S8279C5 {
  ~S8279C28(); // tgen
  S8279C28(); // tgen
};
//SIG(-1 S8279C28) C1{ VBC2{ VBC3{ BC4{ vd m} VBC5{ m} VBC6{ VBC5 v1} VBC7{ BC4 BC6 vd FC8{}} BC9{ VBC5 VBC6 BC4 vd Fi:4} vd} vd} BC4 BC6}


S8279C28 ::~S8279C28(){ note_dtor("S8279C28", this);} // tgen
S8279C28 ::S8279C28(){ note_ctor("S8279C28", this);} // tgen

static void Test_S8279C28()
{
  extern Class_Descriptor cd_S8279C28;
  void *lvp;
  {
    ABISELECT(double,int) buf[10];
    init_test(&cd_S8279C28, buf);
    S8279C28 *dp, &lv = *(dp=new (buf) S8279C28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,36), "sizeof(S8279C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8279C28)");
    /*is_ambiguous_... S8279C15::S814C5_nt */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C15*), ABISELECT(24,12), "S8279C28");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C15*), 0, "S8279C28");
    /*is_ambiguous_... S8279C28::S8279C5 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C5*), 0, "S8279C28");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C5*)(S8279C6*), 0, "S8279C28");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C8*)(S8279C15*), 0, "S8279C28");
    /*is_ambiguous_... S8279C28::S8279C5 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C5*), 0, "S8279C28");
    /*is_ambiguous_... S8279C15::S8279C5 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C15*), ABISELECT(16,8), "S8279C28");
    check_base_class_offset(lv, (S8279C5*)(S8279C8*)(S8279C15*), ABISELECT(16,8), "S8279C28");
    check_base_class_offset(lv, (S814C5_nt*)(S8279C6*), ABISELECT(48,24), "S8279C28");
    check_base_class_offset(lv, (S8279C5*)(S8279C6*), ABISELECT(56,28), "S8279C28");
    check_base_class_offset(lv, (S8279C6*)(S8279C15*), ABISELECT(48,24), "S8279C28");
    check_base_class_offset(lv, (S814C5_nt*)(S8279C8*)(S8279C15*), ABISELECT(32,16), "S8279C28");
    check_base_class_offset(lv, (S8279C8*)(S8279C15*), ABISELECT(32,16), "S8279C28");
    check_base_class_offset(lv, (S8279C15*)(S8279C17*), ABISELECT(24,12), "S8279C28");
    check_base_class_offset(lv, (S8279C17*), ABISELECT(16,8), "S8279C28");
    /*is_ambiguous_... S8279C28::S814C5_nt */ AMB_check_base_class_offset(lv, (S814C5_nt*), 0, "S8279C28");
    /*is_ambiguous_... S8279C28::S8279C5 */ AMB_check_base_class_offset(lv, (S8279C5*), ABISELECT(8,4), "S8279C28");
    test_class_info(&lv, &cd_S8279C28);
    dp->~S8279C28();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8279C28(Test_S8279C28, "S8279C28", ABISELECT(72,36));

#else // __cplusplus

extern void _ZN8S8279C28C1Ev();
extern void _ZN8S8279C28D1Ev();
Name_Map name_map_S8279C28[] = {
  NSPAIR(_ZN8S8279C28C1Ev),
  NSPAIR(_ZN8S8279C28D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S694C11_nt;
extern VTBL_ENTRY _ZTI10S694C11_nt[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S8279C6;
extern VTBL_ENTRY _ZTI7S8279C6[];
extern  VTBL_ENTRY _ZTV7S8279C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C6[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C8;
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
extern Class_Descriptor cd_S8279C15;
extern VTBL_ENTRY _ZTI8S8279C15[];
extern  VTBL_ENTRY _ZTV8S8279C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C15[];
extern Class_Descriptor cd_S8279C17;
extern VTBL_ENTRY _ZTI8S8279C17[];
extern  VTBL_ENTRY _ZTV8S8279C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C17[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
static Base_Class bases_S8279C28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S814C5_nt,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S694C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S8279C5,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S814C5_nt,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S8279C5,    ABISELECT(56,28), //bcp->offset
    45, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S8279C6,    ABISELECT(48,24), //bcp->offset
    38, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S814C5_nt,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S8279C8,    ABISELECT(32,16), //bcp->offset
    32, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S8279C15,    ABISELECT(24,12), //bcp->offset
    24, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S8279C17,    ABISELECT(16,8), //bcp->offset
    13, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S814C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S8279C5,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S8279C28[];
extern void _ZN8S8279C28D1Ev();
extern void _ZN8S8279C28D0Ev();
extern void _ZN7S8279C52v1Ev();
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTv0_n64_N8S8279C28D1Ev,_ZTv0_n32_N8S8279C28D1Ev)();
extern void ABISELECT(_ZThn16_N8S8279C28D1Ev,_ZThn8_N8S8279C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S8279C28D0Ev,_ZTv0_n32_N8S8279C28D0Ev)();
extern void ABISELECT(_ZThn16_N8S8279C28D0Ev,_ZThn8_N8S8279C28D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S8279C28D1Ev,_ZTv0_n24_N8S8279C28D1Ev)();
extern void ABISELECT(_ZThn24_N8S8279C28D1Ev,_ZThn12_N8S8279C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S8279C28D0Ev,_ZTv0_n24_N8S8279C28D0Ev)();
extern void ABISELECT(_ZThn24_N8S8279C28D0Ev,_ZThn12_N8S8279C28D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn8_n48_N8S8279C28D1Ev,_ZTvn4_n24_N8S8279C28D1Ev)();
extern void ABISELECT(_ZTvn8_n48_N8S8279C28D0Ev,_ZTvn4_n24_N8S8279C28D0Ev)();
extern void ABISELECT(_ZTv0_n32_N8S8279C28D1Ev,_ZTv0_n16_N8S8279C28D1Ev)();
extern void ABISELECT(_ZThn48_N8S8279C28D1Ev,_ZThn24_N8S8279C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S8279C28D0Ev,_ZTv0_n16_N8S8279C28D0Ev)();
extern void ABISELECT(_ZThn48_N8S8279C28D0Ev,_ZThn24_N8S8279C28D0Ev)() __attribute__((weak));
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY vtc_S8279C28[] = {
  ABISELECT(48,24),
  ABISELECT(16,8),
  0,
  ABISELECT(24,12),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C28[0]),
  (VTBL_ENTRY)&_ZN8S8279C28D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C28D0Ev,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C28[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  ABISELECT(-16,-8),
  ABISELECT(32,16),
  0,
  ABISELECT(8,4),
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S8279C28[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S8279C28D1Ev,_ZTv0_n32_N8S8279C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S8279C28D0Ev,_ZTv0_n32_N8S8279C28D0Ev),
  ABISELECT(-24,-12),
  ABISELECT(24,12),
  ABISELECT(-8,-4),
  ABISELECT(-24,-12),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S8279C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C28D1Ev,_ZTv0_n24_N8S8279C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C28D0Ev,_ZTv0_n24_N8S8279C28D0Ev),
  ABISELECT(-16,-8),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S8279C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S8279C28D1Ev,_ZTvn4_n24_N8S8279C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S8279C28D0Ev,_ZTvn4_n24_N8S8279C28D0Ev),
  ABISELECT(8,4),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S8279C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C28D1Ev,_ZTv0_n16_N8S8279C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C28D0Ev,_ZTv0_n16_N8S8279C28D0Ev),
  ABISELECT(-56,-28),
  ABISELECT(-56,-28),
  (VTBL_ENTRY)&(_ZTI8S8279C28[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern VTBL_ENTRY _ZTV8S8279C28[];
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__A__8S8279C28[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
extern void _ZN8S8279C17D1Ev();
extern void _ZN8S8279C17D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C17__8S8279C28[] = {
  ABISELECT(32,16),
  0,
  ABISELECT(8,4),
  0,
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&_ZN8S8279C17D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C17D0Ev,
};
extern void ABISELECT(_ZTv0_n48_N8S8279C17D1Ev,_ZTv0_n24_N8S8279C17D1Ev)();
extern void ABISELECT(_ZThn8_N8S8279C17D1Ev,_ZThn4_N8S8279C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S8279C17D0Ev,_ZTv0_n24_N8S8279C17D0Ev)();
extern void ABISELECT(_ZThn8_N8S8279C17D0Ev,_ZThn4_N8S8279C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S8279C15__8S8279C17__8S8279C28[] = {
  ABISELECT(-8,-4),
  ABISELECT(24,12),
  ABISELECT(-8,-4),
  ABISELECT(-24,-12),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C17D1Ev,_ZTv0_n24_N8S8279C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C17D0Ev,_ZTv0_n24_N8S8279C17D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S8279C17D1Ev,_ZTv0_n16_N8S8279C17D1Ev)();
extern void ABISELECT(_ZThn32_N8S8279C17D1Ev,_ZThn16_N8S8279C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S8279C17D0Ev,_ZTv0_n16_N8S8279C17D0Ev)();
extern void ABISELECT(_ZThn32_N8S8279C17D0Ev,_ZThn16_N8S8279C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C17__8S8279C28[] = {
  ABISELECT(8,4),
  ABISELECT(-32,-16),
  ABISELECT(-48,-24),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C17D1Ev,_ZTv0_n16_N8S8279C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C17D0Ev,_ZTv0_n16_N8S8279C17D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C17__8S8279C28[] = {
  ABISELECT(-56,-28),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTvn8_n48_N8S8279C17D1Ev,_ZTvn4_n24_N8S8279C17D1Ev)();
extern void ABISELECT(_ZTvn8_n48_N8S8279C17D0Ev,_ZTvn4_n24_N8S8279C17D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C15__8S8279C17__8S8279C28[] = {
  ABISELECT(-16,-8),
  ABISELECT(-32,-16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S8279C17D1Ev,_ZTvn4_n24_N8S8279C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S8279C17D0Ev,_ZTvn4_n24_N8S8279C17D0Ev),
};
extern void _ZN8S8279C15D1Ev();
extern void _ZN8S8279C15D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C15__8S8279C28[] = {
  ABISELECT(24,12),
  ABISELECT(-8,-4),
  ABISELECT(-24,-12),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN8S8279C15D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C15D0Ev,
};
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C15__8S8279C28[] = {
  ABISELECT(-16,-8),
  ABISELECT(-32,-16),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C88S8279C15__8S8279C28[] = {
  0,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C15__8S8279C28[] = {
  0,
  ABISELECT(-16,-8),
  ABISELECT(8,4),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev)();
extern void ABISELECT(_ZThn24_N8S8279C15D1Ev,_ZThn12_N8S8279C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev)();
extern void ABISELECT(_ZThn24_N8S8279C15D0Ev,_ZThn12_N8S8279C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C15__8S8279C28[] = {
  ABISELECT(8,4),
  ABISELECT(-24,-12),
  ABISELECT(-48,-24),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C15__8S8279C28[] = {
  ABISELECT(-56,-28),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZThn8_N8S8279C15D1Ev,_ZThn4_N8S8279C15D1Ev)();
extern void ABISELECT(_ZThn8_N8S8279C15D0Ev,_ZThn4_N8S8279C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C8__8S8279C15__8S8279C28[] = {
  ABISELECT(-16,-8),
  ABISELECT(-32,-16),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C15D1Ev,_ZThn4_N8S8279C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C15D0Ev,_ZThn4_N8S8279C15D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C28[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C6D1Ev();
extern void _ZN7S8279C6D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C28[] = {
  ABISELECT(-48,-24),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C6[0]),
  (VTBL_ENTRY)&_ZN7S8279C6D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C6D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C28[] = {
  ABISELECT(-56,-28),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C6__8S8279C28[] = {
  ABISELECT(-56,-28),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S8279C6[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
static  VTT_ENTRY vtt_S8279C28[] = {
  {&(_ZTV8S8279C28[7]),  7,49},
  {&(_tg__ZTV7S8279C5__A__8S8279C28[3]),  3,4},
  {&(_ZTV8S8279C28[21]),  21,49},
  {&(_ZTV8S8279C28[30]),  30,49},
  {&(_ZTV8S8279C28[21]),  21,49},
  {&(_ZTV8S8279C28[43]),  43,49},
  {&(_ZTV8S8279C28[48]),  48,49},
  {&(_ZTV8S8279C28[36]),  36,49},
  {&(_ZTV8S8279C28[12]),  12,49},
  {&(_tg__ZTV8S8279C17__8S8279C28[7]),  7,10},
  {&(_tg__ZTV8S8279C15__8S8279C17__8S8279C28[6]),  6,8},
  {&(_tg__ZTV8S8279C17__8S8279C28[7]),  7,10},
  {&(_tg__ZTV7S8279C6__8S8279C17__8S8279C28[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C17__8S8279C28[3]),  3,4},
  {&(_tg__ZTV7S8279C88S8279C15__8S8279C17__8S8279C28[4]),  4,6},
  {&(_tg__ZTV8S8279C15__8S8279C28[5]),  5,7},
  {&(_tg__ZTV7S8279C88S8279C15__8S8279C28[4]),  4,6},
  {&(_tg__ZTV7S8279C5__7S8279C88S8279C15__8S8279C28[4]),  4,5},
  {&(_tg__ZTV7S8279C5__8S8279C15__8S8279C28[4]),  4,5},
  {&(_tg__ZTV7S8279C6__8S8279C15__8S8279C28[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C15__8S8279C28[3]),  3,4},
  {&(_tg__ZTV7S8279C8__8S8279C15__8S8279C28[4]),  4,6},
  {&(_tg__ZTV7S8279C5__8S8279C28[3]),  3,4},
  {&(_tg__ZTV7S8279C6__8S8279C28[3]),  3,5},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C28[3]),  3,4},
  {&(_tg__ZTV7S8279C5__7S8279C6__8S8279C28[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8S8279C28[];
extern  VTBL_ENTRY _ZTV8S8279C28[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C28[];
static VTBL_ENTRY alt_thunk_names10[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S8279C15D0Ev,_ZThn12_N8S8279C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S8279C15D1Ev,_ZThn12_N8S8279C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C17D0Ev,_ZTv0_n16_N8S8279C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S8279C17D0Ev,_ZThn16_N8S8279C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C17D1Ev,_ZTv0_n16_N8S8279C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S8279C17D1Ev,_ZThn16_N8S8279C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S8279C17D0Ev,_ZTv0_n24_N8S8279C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N8S8279C17D0Ev,_ZThn4_N8S8279C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S8279C17D1Ev,_ZTv0_n24_N8S8279C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N8S8279C17D1Ev,_ZThn4_N8S8279C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C28D0Ev,_ZTv0_n16_N8S8279C28D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S8279C28D0Ev,_ZThn24_N8S8279C28D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S8279C28D1Ev,_ZTv0_n16_N8S8279C28D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S8279C28D1Ev,_ZThn24_N8S8279C28D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S8279C28D0Ev,_ZTv0_n24_N8S8279C28D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S8279C28D0Ev,_ZThn12_N8S8279C28D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S8279C28D1Ev,_ZTv0_n24_N8S8279C28D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S8279C28D1Ev,_ZThn12_N8S8279C28D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S8279C28D0Ev,_ZTv0_n32_N8S8279C28D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S8279C28D0Ev,_ZThn8_N8S8279C28D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S8279C28D1Ev,_ZTv0_n32_N8S8279C28D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S8279C28D1Ev,_ZThn8_N8S8279C28D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S8279C28 = {  "S8279C28", // class name
  bases_S8279C28, 12,
  &(vtc_S8279C28[0]), // expected_vtbl_contents
  &(vtt_S8279C28[0]), // expected_vtt_contents
  ABISELECT(72,36), // object size
  NSPAIRA(_ZTI8S8279C28),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S8279C28),49, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S8279C28),26, //virtual table table var
  11, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names10,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8279C27  : virtual S8279C26 , virtual S8279C28 {
  int s8279c27f0;
  ~S8279C27(); // tgen
  S8279C27(); // tgen
};
//SIG(-1 S8279C27) C1{ VBC2{ m} VBC3{ VBC4{ VBC5{ BC6{ vd m} VBC7{ m} VBC8{ VBC7 v1} VBC9{ BC6 BC8 vd FC10{}} BC11{ VBC7 VBC8 BC6 vd Fi:4} vd} vd} BC6 BC8} Fi}


S8279C27 ::~S8279C27(){ note_dtor("S8279C27", this);} // tgen
S8279C27 ::S8279C27(){ note_ctor("S8279C27", this);} // tgen

static void Test_S8279C27()
{
  extern Class_Descriptor cd_S8279C27;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_S8279C27, buf);
    S8279C27 *dp, &lv = *(dp=new (buf) S8279C27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(S8279C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8279C27)");
    check_base_class_offset(lv, (S8279C26*), 0, "S8279C27");
    /*is_ambiguous_... S8279C15::S814C5_nt */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C15*), ABISELECT(32,16), "S8279C27");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C15*), 0, "S8279C27");
    /*is_ambiguous_... S8279C27::S8279C5 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C5*), 0, "S8279C27");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C5*)(S8279C6*), 0, "S8279C27");
    check_base_class_offset(lv, (S694C11_nt*)(S8279C8*)(S8279C15*), 0, "S8279C27");
    /*is_ambiguous_... S8279C28::S8279C5 */ AMB_check_base_class_offset(lv, (S694C11_nt*)(S8279C5*)(S8279C28*), 0, "S8279C27");
    /*is_ambiguous_... S8279C15::S8279C5 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C15*), 0, "S8279C27");
    check_base_class_offset(lv, (S8279C5*)(S8279C8*)(S8279C15*), 0, "S8279C27");
    check_base_class_offset(lv, (S814C5_nt*)(S8279C6*), ABISELECT(56,28), "S8279C27");
    check_base_class_offset(lv, (S8279C5*)(S8279C6*), ABISELECT(64,32), "S8279C27");
    check_base_class_offset(lv, (S8279C6*)(S8279C15*), ABISELECT(56,28), "S8279C27");
    check_base_class_offset(lv, (S814C5_nt*)(S8279C8*)(S8279C15*), ABISELECT(40,20), "S8279C27");
    check_base_class_offset(lv, (S8279C8*)(S8279C15*), ABISELECT(40,20), "S8279C27");
    check_base_class_offset(lv, (S8279C15*)(S8279C17*), ABISELECT(32,16), "S8279C27");
    check_base_class_offset(lv, (S8279C17*)(S8279C28*), 0, "S8279C27");
    /*is_ambiguous_... S8279C28::S814C5_nt */ AMB_check_base_class_offset(lv, (S814C5_nt*)(S8279C28*), ABISELECT(16,8), "S8279C27");
    /*is_ambiguous_... S8279C28::S8279C5 */ AMB_check_base_class_offset(lv, (S8279C5*)(S8279C28*), ABISELECT(24,12), "S8279C27");
    check_base_class_offset(lv, (S8279C28*), ABISELECT(16,8), "S8279C27");
    check_field_offset(lv, s8279c27f0, ABISELECT(8,4), "S8279C27.s8279c27f0");
    test_class_info(&lv, &cd_S8279C27);
    dp->~S8279C27();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8279C27(Test_S8279C27, "S8279C27", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN8S8279C27C1Ev();
extern void _ZN8S8279C27D1Ev();
Name_Map name_map_S8279C27[] = {
  NSPAIR(_ZN8S8279C27C1Ev),
  NSPAIR(_ZN8S8279C27D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S8279C26;
extern VTBL_ENTRY _ZTI8S8279C26[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S694C11_nt;
extern VTBL_ENTRY _ZTI10S694C11_nt[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S8279C6;
extern VTBL_ENTRY _ZTI7S8279C6[];
extern  VTBL_ENTRY _ZTV7S8279C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C6[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C8;
extern VTBL_ENTRY _ZTI7S8279C8[];
extern  VTBL_ENTRY _ZTV7S8279C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C8[];
extern Class_Descriptor cd_S8279C15;
extern VTBL_ENTRY _ZTI8S8279C15[];
extern  VTBL_ENTRY _ZTV8S8279C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C15[];
extern Class_Descriptor cd_S8279C17;
extern VTBL_ENTRY _ZTI8S8279C17[];
extern  VTBL_ENTRY _ZTV8S8279C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C17[];
extern Class_Descriptor cd_S814C5_nt;
extern VTBL_ENTRY _ZTI9S814C5_nt[];
extern  VTBL_ENTRY _ZTV9S814C5_nt[];
extern Class_Descriptor cd_S8279C5;
extern VTBL_ENTRY _ZTI7S8279C5[];
extern  VTBL_ENTRY _ZTV7S8279C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S8279C5[];
extern Class_Descriptor cd_S8279C28;
extern VTBL_ENTRY _ZTI8S8279C28[];
extern  VTBL_ENTRY _ZTV8S8279C28[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S8279C28[];
static Base_Class bases_S8279C27[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S8279C26,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S814C5_nt,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S694C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S8279C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S814C5_nt,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S8279C5,    ABISELECT(64,32), //bcp->offset
    50, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S8279C6,    ABISELECT(56,28), //bcp->offset
    43, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S814C5_nt,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S8279C8,    ABISELECT(40,20), //bcp->offset
    37, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S8279C15,    ABISELECT(32,16), //bcp->offset
    29, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S8279C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S814C5_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S8279C5,    ABISELECT(24,12), //bcp->offset
    25, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S8279C28,    ABISELECT(16,8), //bcp->offset
    14, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S8279C27[];
extern void _ZN7S8279C52v1Ev();
extern void _ZN8S8279C27D1Ev();
extern void _ZN8S8279C27D0Ev();
extern void ABISELECT(_ZTv0_n64_N8S8279C27D1Ev,_ZTv0_n32_N8S8279C27D1Ev)();
extern void ABISELECT(_ZThn16_N8S8279C27D1Ev,_ZThn8_N8S8279C27D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S8279C27D0Ev,_ZTv0_n32_N8S8279C27D0Ev)();
extern void ABISELECT(_ZThn16_N8S8279C27D0Ev,_ZThn8_N8S8279C27D0Ev)() __attribute__((weak));
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTv0_n48_N8S8279C27D1Ev,_ZTv0_n24_N8S8279C27D1Ev)();
extern void ABISELECT(_ZThn32_N8S8279C27D1Ev,_ZThn16_N8S8279C27D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S8279C27D0Ev,_ZTv0_n24_N8S8279C27D0Ev)();
extern void ABISELECT(_ZThn32_N8S8279C27D0Ev,_ZThn16_N8S8279C27D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn8_n48_N8S8279C27D1Ev,_ZTvn4_n24_N8S8279C27D1Ev)();
extern void ABISELECT(_ZTvn8_n48_N8S8279C27D0Ev,_ZTvn4_n24_N8S8279C27D0Ev)();
extern void ABISELECT(_ZTv0_n32_N8S8279C27D1Ev,_ZTv0_n16_N8S8279C27D1Ev)();
extern void ABISELECT(_ZThn56_N8S8279C27D1Ev,_ZThn28_N8S8279C27D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S8279C27D0Ev,_ZTv0_n16_N8S8279C27D0Ev)();
extern void ABISELECT(_ZThn56_N8S8279C27D0Ev,_ZThn28_N8S8279C27D0Ev)() __attribute__((weak));
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY vtc_S8279C27[] = {
  0,
  ABISELECT(16,8),
  0,
  0,
  ABISELECT(56,28),
  0,
  ABISELECT(32,16),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C27[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&_ZN8S8279C27D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C27D0Ev,
  ABISELECT(8,4),
  ABISELECT(-16,-8),
  ABISELECT(40,20),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S8279C27[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S8279C27D1Ev,_ZTv0_n32_N8S8279C27D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S8279C27D0Ev,_ZTv0_n32_N8S8279C27D0Ev),
  ABISELECT(-24,-12),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S8279C27[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  ABISELECT(-32,-16),
  ABISELECT(24,12),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S8279C27[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C27D1Ev,_ZTv0_n24_N8S8279C27D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C27D0Ev,_ZTv0_n24_N8S8279C27D0Ev),
  ABISELECT(-40,-20),
  ABISELECT(-40,-20),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI8S8279C27[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S8279C27D1Ev,_ZTvn4_n24_N8S8279C27D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S8279C27D0Ev,_ZTvn4_n24_N8S8279C27D0Ev),
  ABISELECT(8,4),
  ABISELECT(-56,-28),
  ABISELECT(-56,-28),
  ABISELECT(-56,-28),
  (VTBL_ENTRY)&(_ZTI8S8279C27[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C27D1Ev,_ZTv0_n16_N8S8279C27D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C27D0Ev,_ZTv0_n16_N8S8279C27D0Ev),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI8S8279C27[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern VTBL_ENTRY _ZTV8S8279C27[];
extern void _ZN8S8279C28D1Ev();
extern void _ZN8S8279C28D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C28__8S8279C27[] = {
  ABISELECT(40,20),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C28[0]),
  (VTBL_ENTRY)&_ZN8S8279C28D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C28D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C58S8279C28__A2__8S8279C27[] = {
  ABISELECT(-24,-12),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
extern void ABISELECT(_ZTv0_n64_N8S8279C28D1Ev,_ZTv0_n32_N8S8279C28D1Ev)();
extern void ABISELECT(_ZTv0_n64_N8S8279C28D0Ev,_ZTv0_n32_N8S8279C28D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S8279C17__8S8279C28__8S8279C27[] = {
  ABISELECT(16,8),
  ABISELECT(56,28),
  0,
  ABISELECT(32,16),
  0,
  0,
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI8S8279C28[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S8279C28D1Ev,_ZTv0_n32_N8S8279C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S8279C28D0Ev,_ZTv0_n32_N8S8279C28D0Ev),
};
extern void ABISELECT(_ZTv0_n48_N8S8279C28D1Ev,_ZTv0_n24_N8S8279C28D1Ev)();
extern void ABISELECT(_ZThn16_N8S8279C28D1Ev,_ZThn8_N8S8279C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S8279C28D0Ev,_ZTv0_n24_N8S8279C28D0Ev)();
extern void ABISELECT(_ZThn16_N8S8279C28D0Ev,_ZThn8_N8S8279C28D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S8279C15__8S8279C28__8S8279C27[] = {
  ABISELECT(-16,-8),
  ABISELECT(24,12),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S8279C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C28D1Ev,_ZTv0_n24_N8S8279C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C28D0Ev,_ZTv0_n24_N8S8279C28D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S8279C28D1Ev,_ZTv0_n16_N8S8279C28D1Ev)();
extern void ABISELECT(_ZThn40_N8S8279C28D1Ev,_ZThn20_N8S8279C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S8279C28D0Ev,_ZTv0_n16_N8S8279C28D0Ev)();
extern void ABISELECT(_ZThn40_N8S8279C28D0Ev,_ZThn20_N8S8279C28D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C28__8S8279C27[] = {
  ABISELECT(8,4),
  ABISELECT(-40,-20),
  ABISELECT(-56,-28),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI8S8279C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C28D1Ev,_ZTv0_n16_N8S8279C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C28D0Ev,_ZTv0_n16_N8S8279C28D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C28__8S8279C27[] = {
  ABISELECT(-64,-32),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S8279C28[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTvn8_n48_N8S8279C28D1Ev,_ZTvn4_n24_N8S8279C28D1Ev)();
extern void ABISELECT(_ZTvn8_n48_N8S8279C28D0Ev,_ZTvn4_n24_N8S8279C28D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C15__8S8279C28__8S8279C27[] = {
  ABISELECT(-40,-20),
  ABISELECT(-40,-20),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S8279C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S8279C28D1Ev,_ZTvn4_n24_N8S8279C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S8279C28D0Ev,_ZTvn4_n24_N8S8279C28D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__A__8S8279C28__8S8279C27[] = {
  ABISELECT(-24,-12),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C28[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
extern void _ZN8S8279C17D1Ev();
extern void _ZN8S8279C17D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C17__8S8279C27[] = {
  ABISELECT(56,28),
  0,
  ABISELECT(32,16),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
  (VTBL_ENTRY)&_ZN8S8279C17D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C17D0Ev,
};
extern void ABISELECT(_ZTv0_n48_N8S8279C17D1Ev,_ZTv0_n24_N8S8279C17D1Ev)();
extern void ABISELECT(_ZThn32_N8S8279C17D1Ev,_ZThn16_N8S8279C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S8279C17D0Ev,_ZTv0_n24_N8S8279C17D0Ev)();
extern void ABISELECT(_ZThn32_N8S8279C17D0Ev,_ZThn16_N8S8279C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S8279C15__8S8279C17__8S8279C27[] = {
  ABISELECT(-32,-16),
  ABISELECT(24,12),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C17D1Ev,_ZTv0_n24_N8S8279C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S8279C17D0Ev,_ZTv0_n24_N8S8279C17D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S8279C17D1Ev,_ZTv0_n16_N8S8279C17D1Ev)();
extern void ABISELECT(_ZThn56_N8S8279C17D1Ev,_ZThn28_N8S8279C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S8279C17D0Ev,_ZTv0_n16_N8S8279C17D0Ev)();
extern void ABISELECT(_ZThn56_N8S8279C17D0Ev,_ZThn28_N8S8279C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C17__8S8279C27[] = {
  ABISELECT(8,4),
  ABISELECT(-56,-28),
  ABISELECT(-56,-28),
  ABISELECT(-56,-28),
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C17D1Ev,_ZTv0_n16_N8S8279C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C17D0Ev,_ZTv0_n16_N8S8279C17D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C17__8S8279C27[] = {
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTvn8_n48_N8S8279C17D1Ev,_ZTvn4_n24_N8S8279C17D1Ev)();
extern void ABISELECT(_ZTvn8_n48_N8S8279C17D0Ev,_ZTvn4_n24_N8S8279C17D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C15__8S8279C17__8S8279C27[] = {
  ABISELECT(-40,-20),
  ABISELECT(-40,-20),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI8S8279C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S8279C17D1Ev,_ZTvn4_n24_N8S8279C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n48_N8S8279C17D0Ev,_ZTvn4_n24_N8S8279C17D0Ev),
};
extern void _ZN8S8279C15D1Ev();
extern void _ZN8S8279C15D0Ev();
static  VTBL_ENTRY _tg__ZTV8S8279C15__8S8279C27[] = {
  ABISELECT(24,12),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  0,
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN8S8279C15D1Ev,
  (VTBL_ENTRY)&_ZN8S8279C15D0Ev,
};
extern void _ZN7S8279C8D1Ev();
extern void _ZN7S8279C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C88S8279C15__8S8279C27[] = {
  ABISELECT(-40,-20),
  ABISELECT(-40,-20),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C8D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C88S8279C15__8S8279C27[] = {
  0,
  0,
  ABISELECT(40,20),
  (VTBL_ENTRY)&(_ZTI7S8279C8[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C15__8S8279C27[] = {
  0,
  0,
  ABISELECT(32,16),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev)();
extern void ABISELECT(_ZThn24_N8S8279C15D1Ev,_ZThn12_N8S8279C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev)();
extern void ABISELECT(_ZThn24_N8S8279C15D0Ev,_ZThn12_N8S8279C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C15__8S8279C27[] = {
  ABISELECT(8,4),
  ABISELECT(-24,-12),
  ABISELECT(-56,-28),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C15D1Ev,_ZTv0_n16_N8S8279C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S8279C15D0Ev,_ZTv0_n16_N8S8279C15D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C15__8S8279C27[] = {
  ABISELECT(-64,-32),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void ABISELECT(_ZThn8_N8S8279C15D1Ev,_ZThn4_N8S8279C15D1Ev)();
extern void ABISELECT(_ZThn8_N8S8279C15D0Ev,_ZThn4_N8S8279C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S8279C8__8S8279C15__8S8279C27[] = {
  ABISELECT(-40,-20),
  ABISELECT(-40,-20),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S8279C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C15D1Ev,_ZThn4_N8S8279C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S8279C15D0Ev,_ZThn4_N8S8279C15D0Ev),
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__8S8279C27[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C6D1Ev();
extern void _ZN7S8279C6D0Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C6__8S8279C27[] = {
  ABISELECT(-56,-28),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C6[0]),
  (VTBL_ENTRY)&_ZN7S8279C6D1Ev,
  (VTBL_ENTRY)&_ZN7S8279C6D0Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C57S8279C6__A1__8S8279C27[] = {
  ABISELECT(-64,-32),
  0,
  (VTBL_ENTRY)&(_ZTI7S8279C5[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
extern void _ZN7S8279C52v1Ev();
static  VTBL_ENTRY _tg__ZTV7S8279C5__7S8279C6__8S8279C27[] = {
  ABISELECT(-64,-32),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S8279C6[0]),
  (VTBL_ENTRY)&_ZN7S8279C52v1Ev,
};
static  VTT_ENTRY vtt_S8279C27[] = {
  {&(_ZTV8S8279C27[11]),  11,54},
  {&(_ZTV8S8279C27[23]),  23,54},
  {&(_ZTV8S8279C27[11]),  11,54},
  {&(_ZTV8S8279C27[35]),  35,54},
  {&(_ZTV8S8279C27[11]),  11,54},
  {&(_ZTV8S8279C27[48]),  48,54},
  {&(_ZTV8S8279C27[53]),  53,54},
  {&(_ZTV8S8279C27[41]),  41,54},
  {&(_ZTV8S8279C27[28]),  28,54},
  {&(_tg__ZTV8S8279C28__8S8279C27[7]),  7,9},
  {&(_tg__ZTV7S8279C58S8279C28__A2__8S8279C27[3]),  3,4},
  {&(_tg__ZTV8S8279C17__8S8279C28__8S8279C27[8]),  8,11},
  {&(_tg__ZTV8S8279C15__8S8279C28__8S8279C27[6]),  6,8},
  {&(_tg__ZTV8S8279C17__8S8279C28__8S8279C27[8]),  8,11},
  {&(_tg__ZTV7S8279C6__8S8279C28__8S8279C27[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C28__8S8279C27[3]),  3,4},
  {&(_tg__ZTV7S8279C88S8279C15__8S8279C28__8S8279C27[4]),  4,6},
  {&(_tg__ZTV7S8279C5__A__8S8279C28__8S8279C27[3]),  3,4},
  {&(_tg__ZTV8S8279C17__8S8279C27[7]),  7,10},
  {&(_tg__ZTV8S8279C15__8S8279C17__8S8279C27[6]),  6,8},
  {&(_tg__ZTV8S8279C17__8S8279C27[7]),  7,10},
  {&(_tg__ZTV7S8279C6__8S8279C17__8S8279C27[5]),  5,7},
  {&(_tg__ZTV7S8279C57S8279C6__A1__8S8279C17__8S8279C27[3]),  3,4},
  {&(_tg__ZTV7S8279C88S8279C15__8S8279C17__8S8279C27[4]),  4,6},
  {&(_tg__ZTV8S8279C15__8S8279C27[5]),  5,7},
  {&(_tg__ZTV7S8279C88S8279C15__8S8279C27[4]),  4,6},
  {&(_tg__ZTV7S8279C5__7S8279C88S8279C15__8S8279C27[4]),  4,5},
  {&(_tg__ZTV7S8279C5__8S8279C15__8S8279C27[4]),  4,5},
  {&(_tg__ZTV7S8279C6__8S8279C15__8S8279C27[5]),  5,7},
  {&(