// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S3350C4_nt  {
  int s3350c4f0[2];
  void  mf3350c4(); // _ZN10S3350C4_nt8mf3350c4Ev
};
//SIG(-1 S3350C4_nt) C1{ m Fi[2]}


void  S3350C4_nt ::mf3350c4(){}

//skip512 S3350C4_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3350C3_nt  {
  int s3350c3f0;
  __tsi64 s3350c3f1;
  void *s3350c3f2[4];
  int s3350c3f3[2];
  void *s3350c3f4;
  ::S3350C4_nt s3350c3f5;
  void *s3350c3f6[2];
  virtual  ~S3350C3_nt(); // _ZN10S3350C3_ntD1Ev
  virtual void  v6(); // _ZN10S3350C3_nt2v6Ev
  virtual void  v7(); // _ZN10S3350C3_nt2v7Ev
  virtual void  v8(); // _ZN10S3350C3_nt2v8Ev
  virtual void  v9(); // _ZN10S3350C3_nt2v9Ev
  virtual void  v10(); // _ZN10S3350C3_nt3v10Ev
  virtual void  v11(); // _ZN10S3350C3_nt3v11Ev
  virtual void  v12(); // _ZN10S3350C3_nt3v12Ev
  virtual void  v13(); // _ZN10S3350C3_nt3v13Ev
  virtual void  v14(); // _ZN10S3350C3_nt3v14Ev
  virtual void  v15(); // _ZN10S3350C3_nt3v15Ev
  virtual void  v16(); // _ZN10S3350C3_nt3v16Ev
  virtual void  v17(); // _ZN10S3350C3_nt3v17Ev
  virtual void  v18(); // _ZN10S3350C3_nt3v18Ev
  virtual void  v19(); // _ZN10S3350C3_nt3v19Ev
  virtual void  v20(); // _ZN10S3350C3_nt3v20Ev
  virtual void  v21(); // _ZN10S3350C3_nt3v21Ev
  virtual void  v22(); // _ZN10S3350C3_nt3v22Ev
  virtual void  v23(); // _ZN10S3350C3_nt3v23Ev
  virtual void  v24(); // _ZN10S3350C3_nt3v24Ev
  virtual void  v25(); // _ZN10S3350C3_nt3v25Ev
  virtual void  v26(); // _ZN10S3350C3_nt3v26Ev
  virtual void  v27(); // _ZN10S3350C3_nt3v27Ev
  virtual void  v28(); // _ZN10S3350C3_nt3v28Ev
  virtual void  v29(); // _ZN10S3350C3_nt3v29Ev
  virtual void  v30(); // _ZN10S3350C3_nt3v30Ev
  virtual void  v31(); // _ZN10S3350C3_nt3v31Ev
  virtual void  v32(); // _ZN10S3350C3_nt3v32Ev
  virtual void  v33(); // _ZN10S3350C3_nt3v33Ev
  virtual void  v34(); // _ZN10S3350C3_nt3v34Ev
  virtual void  v35(); // _ZN10S3350C3_nt3v35Ev
  virtual void  v36(); // _ZN10S3350C3_nt3v36Ev
  virtual void  v37(); // _ZN10S3350C3_nt3v37Ev
  virtual void  v38(); // _ZN10S3350C3_nt3v38Ev
  virtual void  v39(); // _ZN10S3350C3_nt3v39Ev
  virtual void  v40(); // _ZN10S3350C3_nt3v40Ev
  virtual void  v41(); // _ZN10S3350C3_nt3v41Ev
  virtual void  v42(); // _ZN10S3350C3_nt3v42Ev
  virtual void  v43(); // _ZN10S3350C3_nt3v43Ev
  virtual void  v44(); // _ZN10S3350C3_nt3v44Ev
  virtual void  v45(); // _ZN10S3350C3_nt3v45Ev
  virtual void  v46(); // _ZN10S3350C3_nt3v46Ev
  virtual void  v47(); // _ZN10S3350C3_nt3v47Ev
  virtual void  v48(); // _ZN10S3350C3_nt3v48Ev
  virtual void  v49(); // _ZN10S3350C3_nt3v49Ev
  virtual void  v50(); // _ZN10S3350C3_nt3v50Ev
  virtual void  v51(); // _ZN10S3350C3_nt3v51Ev
  virtual void  v52(); // _ZN10S3350C3_nt3v52Ev
  virtual void  v53(); // _ZN10S3350C3_nt3v53Ev
  virtual void  v54(); // _ZN10S3350C3_nt3v54Ev
  virtual void  v55(); // _ZN10S3350C3_nt3v55Ev
  virtual void  v56(); // _ZN10S3350C3_nt3v56Ev
  virtual void  v57(); // _ZN10S3350C3_nt3v57Ev
  virtual void  v58(); // _ZN10S3350C3_nt3v58Ev
  virtual void  v59(); // _ZN10S3350C3_nt3v59Ev
  virtual void  v60(); // _ZN10S3350C3_nt3v60Ev
  virtual void  v61(); // _ZN10S3350C3_nt3v61Ev
  virtual void  v62(); // _ZN10S3350C3_nt3v62Ev
  virtual void  v63(); // _ZN10S3350C3_nt3v63Ev
  virtual void  v64(); // _ZN10S3350C3_nt3v64Ev
  virtual void  v65(); // _ZN10S3350C3_nt3v65Ev
  virtual void  v66(); // _ZN10S3350C3_nt3v66Ev
  virtual void  v67(); // _ZN10S3350C3_nt3v67Ev
  virtual void  v68(); // _ZN10S3350C3_nt3v68Ev
  virtual void  v69(); // _ZN10S3350C3_nt3v69Ev
  S3350C3_nt(); // tgen
};
//SIG(-1 S3350C3_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S3350C3_nt ::~S3350C3_nt(){ note_dtor("S3350C3_nt", this);}
void  S3350C3_nt ::v6(){vfunc_called(this, "_ZN10S3350C3_nt2v6Ev");}
void  S3350C3_nt ::v7(){vfunc_called(this, "_ZN10S3350C3_nt2v7Ev");}
void  S3350C3_nt ::v8(){vfunc_called(this, "_ZN10S3350C3_nt2v8Ev");}
void  S3350C3_nt ::v9(){vfunc_called(this, "_ZN10S3350C3_nt2v9Ev");}
void  S3350C3_nt ::v10(){vfunc_called(this, "_ZN10S3350C3_nt3v10Ev");}
void  S3350C3_nt ::v11(){vfunc_called(this, "_ZN10S3350C3_nt3v11Ev");}
void  S3350C3_nt ::v12(){vfunc_called(this, "_ZN10S3350C3_nt3v12Ev");}
void  S3350C3_nt ::v13(){vfunc_called(this, "_ZN10S3350C3_nt3v13Ev");}
void  S3350C3_nt ::v14(){vfunc_called(this, "_ZN10S3350C3_nt3v14Ev");}
void  S3350C3_nt ::v15(){vfunc_called(this, "_ZN10S3350C3_nt3v15Ev");}
void  S3350C3_nt ::v16(){vfunc_called(this, "_ZN10S3350C3_nt3v16Ev");}
void  S3350C3_nt ::v17(){vfunc_called(this, "_ZN10S3350C3_nt3v17Ev");}
void  S3350C3_nt ::v18(){vfunc_called(this, "_ZN10S3350C3_nt3v18Ev");}
void  S3350C3_nt ::v19(){vfunc_called(this, "_ZN10S3350C3_nt3v19Ev");}
void  S3350C3_nt ::v20(){vfunc_called(this, "_ZN10S3350C3_nt3v20Ev");}
void  S3350C3_nt ::v21(){vfunc_called(this, "_ZN10S3350C3_nt3v21Ev");}
void  S3350C3_nt ::v22(){vfunc_called(this, "_ZN10S3350C3_nt3v22Ev");}
void  S3350C3_nt ::v23(){vfunc_called(this, "_ZN10S3350C3_nt3v23Ev");}
void  S3350C3_nt ::v24(){vfunc_called(this, "_ZN10S3350C3_nt3v24Ev");}
void  S3350C3_nt ::v25(){vfunc_called(this, "_ZN10S3350C3_nt3v25Ev");}
void  S3350C3_nt ::v26(){vfunc_called(this, "_ZN10S3350C3_nt3v26Ev");}
void  S3350C3_nt ::v27(){vfunc_called(this, "_ZN10S3350C3_nt3v27Ev");}
void  S3350C3_nt ::v28(){vfunc_called(this, "_ZN10S3350C3_nt3v28Ev");}
void  S3350C3_nt ::v29(){vfunc_called(this, "_ZN10S3350C3_nt3v29Ev");}
void  S3350C3_nt ::v30(){vfunc_called(this, "_ZN10S3350C3_nt3v30Ev");}
void  S3350C3_nt ::v31(){vfunc_called(this, "_ZN10S3350C3_nt3v31Ev");}
void  S3350C3_nt ::v32(){vfunc_called(this, "_ZN10S3350C3_nt3v32Ev");}
void  S3350C3_nt ::v33(){vfunc_called(this, "_ZN10S3350C3_nt3v33Ev");}
void  S3350C3_nt ::v34(){vfunc_called(this, "_ZN10S3350C3_nt3v34Ev");}
void  S3350C3_nt ::v35(){vfunc_called(this, "_ZN10S3350C3_nt3v35Ev");}
void  S3350C3_nt ::v36(){vfunc_called(this, "_ZN10S3350C3_nt3v36Ev");}
void  S3350C3_nt ::v37(){vfunc_called(this, "_ZN10S3350C3_nt3v37Ev");}
void  S3350C3_nt ::v38(){vfunc_called(this, "_ZN10S3350C3_nt3v38Ev");}
void  S3350C3_nt ::v39(){vfunc_called(this, "_ZN10S3350C3_nt3v39Ev");}
void  S3350C3_nt ::v40(){vfunc_called(this, "_ZN10S3350C3_nt3v40Ev");}
void  S3350C3_nt ::v41(){vfunc_called(this, "_ZN10S3350C3_nt3v41Ev");}
void  S3350C3_nt ::v42(){vfunc_called(this, "_ZN10S3350C3_nt3v42Ev");}
void  S3350C3_nt ::v43(){vfunc_called(this, "_ZN10S3350C3_nt3v43Ev");}
void  S3350C3_nt ::v44(){vfunc_called(this, "_ZN10S3350C3_nt3v44Ev");}
void  S3350C3_nt ::v45(){vfunc_called(this, "_ZN10S3350C3_nt3v45Ev");}
void  S3350C3_nt ::v46(){vfunc_called(this, "_ZN10S3350C3_nt3v46Ev");}
void  S3350C3_nt ::v47(){vfunc_called(this, "_ZN10S3350C3_nt3v47Ev");}
void  S3350C3_nt ::v48(){vfunc_called(this, "_ZN10S3350C3_nt3v48Ev");}
void  S3350C3_nt ::v49(){vfunc_called(this, "_ZN10S3350C3_nt3v49Ev");}
void  S3350C3_nt ::v50(){vfunc_called(this, "_ZN10S3350C3_nt3v50Ev");}
void  S3350C3_nt ::v51(){vfunc_called(this, "_ZN10S3350C3_nt3v51Ev");}
void  S3350C3_nt ::v52(){vfunc_called(this, "_ZN10S3350C3_nt3v52Ev");}
void  S3350C3_nt ::v53(){vfunc_called(this, "_ZN10S3350C3_nt3v53Ev");}
void  S3350C3_nt ::v54(){vfunc_called(this, "_ZN10S3350C3_nt3v54Ev");}
void  S3350C3_nt ::v55(){vfunc_called(this, "_ZN10S3350C3_nt3v55Ev");}
void  S3350C3_nt ::v56(){vfunc_called(this, "_ZN10S3350C3_nt3v56Ev");}
void  S3350C3_nt ::v57(){vfunc_called(this, "_ZN10S3350C3_nt3v57Ev");}
void  S3350C3_nt ::v58(){vfunc_called(this, "_ZN10S3350C3_nt3v58Ev");}
void  S3350C3_nt ::v59(){vfunc_called(this, "_ZN10S3350C3_nt3v59Ev");}
void  S3350C3_nt ::v60(){vfunc_called(this, "_ZN10S3350C3_nt3v60Ev");}
void  S3350C3_nt ::v61(){vfunc_called(this, "_ZN10S3350C3_nt3v61Ev");}
void  S3350C3_nt ::v62(){vfunc_called(this, "_ZN10S3350C3_nt3v62Ev");}
void  S3350C3_nt ::v63(){vfunc_called(this, "_ZN10S3350C3_nt3v63Ev");}
void  S3350C3_nt ::v64(){vfunc_called(this, "_ZN10S3350C3_nt3v64Ev");}
void  S3350C3_nt ::v65(){vfunc_called(this, "_ZN10S3350C3_nt3v65Ev");}
void  S3350C3_nt ::v66(){vfunc_called(this, "_ZN10S3350C3_nt3v66Ev");}
void  S3350C3_nt ::v67(){vfunc_called(this, "_ZN10S3350C3_nt3v67Ev");}
void  S3350C3_nt ::v68(){vfunc_called(this, "_ZN10S3350C3_nt3v68Ev");}
void  S3350C3_nt ::v69(){vfunc_called(this, "_ZN10S3350C3_nt3v69Ev");}
S3350C3_nt ::S3350C3_nt(){ note_ctor("S3350C3_nt", this);} // tgen

//skip512 S3350C3_nt

#else // __cplusplus

extern void _ZN10S3350C3_ntC1Ev();
extern void _ZN10S3350C3_ntD1Ev();
Name_Map name_map_S3350C3_nt[] = {
  NSPAIR(_ZN10S3350C3_ntC1Ev),
  NSPAIR(_ZN10S3350C3_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S3350C3_nt[];
extern void _ZN10S3350C3_ntD1Ev();
extern void _ZN10S3350C3_ntD0Ev();
extern void _ZN10S3350C3_nt2v6Ev();
extern void _ZN10S3350C3_nt2v7Ev();
extern void _ZN10S3350C3_nt2v8Ev();
extern void _ZN10S3350C3_nt2v9Ev();
extern void _ZN10S3350C3_nt3v10Ev();
extern void _ZN10S3350C3_nt3v11Ev();
extern void _ZN10S3350C3_nt3v12Ev();
extern void _ZN10S3350C3_nt3v13Ev();
extern void _ZN10S3350C3_nt3v14Ev();
extern void _ZN10S3350C3_nt3v15Ev();
extern void _ZN10S3350C3_nt3v16Ev();
extern void _ZN10S3350C3_nt3v17Ev();
extern void _ZN10S3350C3_nt3v18Ev();
extern void _ZN10S3350C3_nt3v19Ev();
extern void _ZN10S3350C3_nt3v20Ev();
extern void _ZN10S3350C3_nt3v21Ev();
extern void _ZN10S3350C3_nt3v22Ev();
extern void _ZN10S3350C3_nt3v23Ev();
extern void _ZN10S3350C3_nt3v24Ev();
extern void _ZN10S3350C3_nt3v25Ev();
extern void _ZN10S3350C3_nt3v26Ev();
extern void _ZN10S3350C3_nt3v27Ev();
extern void _ZN10S3350C3_nt3v28Ev();
extern void _ZN10S3350C3_nt3v29Ev();
extern void _ZN10S3350C3_nt3v30Ev();
extern void _ZN10S3350C3_nt3v31Ev();
extern void _ZN10S3350C3_nt3v32Ev();
extern void _ZN10S3350C3_nt3v33Ev();
extern void _ZN10S3350C3_nt3v34Ev();
extern void _ZN10S3350C3_nt3v35Ev();
extern void _ZN10S3350C3_nt3v36Ev();
extern void _ZN10S3350C3_nt3v37Ev();
extern void _ZN10S3350C3_nt3v38Ev();
extern void _ZN10S3350C3_nt3v39Ev();
extern void _ZN10S3350C3_nt3v40Ev();
extern void _ZN10S3350C3_nt3v41Ev();
extern void _ZN10S3350C3_nt3v42Ev();
extern void _ZN10S3350C3_nt3v43Ev();
extern void _ZN10S3350C3_nt3v44Ev();
extern void _ZN10S3350C3_nt3v45Ev();
extern void _ZN10S3350C3_nt3v46Ev();
extern void _ZN10S3350C3_nt3v47Ev();
extern void _ZN10S3350C3_nt3v48Ev();
extern void _ZN10S3350C3_nt3v49Ev();
extern void _ZN10S3350C3_nt3v50Ev();
extern void _ZN10S3350C3_nt3v51Ev();
extern void _ZN10S3350C3_nt3v52Ev();
extern void _ZN10S3350C3_nt3v53Ev();
extern void _ZN10S3350C3_nt3v54Ev();
extern void _ZN10S3350C3_nt3v55Ev();
extern void _ZN10S3350C3_nt3v56Ev();
extern void _ZN10S3350C3_nt3v57Ev();
extern void _ZN10S3350C3_nt3v58Ev();
extern void _ZN10S3350C3_nt3v59Ev();
extern void _ZN10S3350C3_nt3v60Ev();
extern void _ZN10S3350C3_nt3v61Ev();
extern void _ZN10S3350C3_nt3v62Ev();
extern void _ZN10S3350C3_nt3v63Ev();
extern void _ZN10S3350C3_nt3v64Ev();
extern void _ZN10S3350C3_nt3v65Ev();
extern void _ZN10S3350C3_nt3v66Ev();
extern void _ZN10S3350C3_nt3v67Ev();
extern void _ZN10S3350C3_nt3v68Ev();
extern void _ZN10S3350C3_nt3v69Ev();
static  VTBL_ENTRY vtc_S3350C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S3350C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S3350C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v69Ev,
};
extern VTBL_ENTRY _ZTI10S3350C3_nt[];
VTBL_ENTRY *P__ZTI10S3350C3_nt = _ZTI10S3350C3_nt; 
extern  VTBL_ENTRY _ZTV10S3350C3_nt[];
Class_Descriptor cd_S3350C3_nt = {  "S3350C3_nt", // class name
  0,0,//no base classes
  &(vtc_S3350C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI10S3350C3_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S3350C3_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3350C7_nt  {
  void *s3350c7f0;
  int s3350c7f1[2];
  void  mf3350c7(); // _ZN10S3350C7_nt8mf3350c7Ev
};
//SIG(-1 S3350C7_nt) C1{ m Fp Fi[2]}


void  S3350C7_nt ::mf3350c7(){}

//skip512 S3350C7_nt

#else // __cplusplus

Class_Descriptor cd_S3350C7_nt = {  "S3350C7_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3350C6_nt  : S3350C7_nt {
};
//SIG(-1 S3350C6_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S3350C6_nt

#else // __cplusplus

extern Class_Descriptor cd_S3350C7_nt;
static Base_Class bases_S3350C6_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3350C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3350C6_nt = {  "S3350C6_nt", // class name
  bases_S3350C6_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3350C5_nt  : S3350C6_nt {
};
//SIG(-1 S3350C5_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S3350C5_nt

#else // __cplusplus

extern Class_Descriptor cd_S3350C7_nt;
extern Class_Descriptor cd_S3350C6_nt;
static Base_Class bases_S3350C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3350C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3350C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3350C8_nt  {
  int s3350c8f0;
  void  mf3350c8(); // _ZN10S3350C8_nt8mf3350c8Ev
};
//SIG(-1 S3350C8_nt) C1{ m Fi}


void  S3350C8_nt ::mf3350c8(){}

//skip512 S3350C8_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S3350C8_nt[];
VTBL_ENTRY *P__ZTI10S3350C8_nt = _ZTI10S3350C8_nt; 
Class_Descriptor cd_S3350C8_nt = {  "S3350C8_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI10S3350C8_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3350C12  : S3350C7_nt {
};
//SIG(-1 S3350C12) C1{ BC2{ m Fp Fi[2]}}



static void Test_S3350C12()
{
  extern Class_Descriptor cd_S3350C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3350C12, buf);
    S3350C12 &lv = *(new (buf) S3350C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3350C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3350C12)");
    check_base_class_offset(lv, (S3350C7_nt*), 0, "S3350C12");
    test_class_info(&lv, &cd_S3350C12);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3350C12(Test_S3350C12, "S3350C12", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3350C7_nt;
static Base_Class bases_S3350C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3350C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3350C12 = {  "S3350C12", // class name
  bases_S3350C12, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3350C11  : S3350C12 {
};
//SIG(-1 S3350C11) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S3350C11()
{
  extern Class_Descriptor cd_S3350C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3350C11, buf);
    S3350C11 &lv = *(new (buf) S3350C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3350C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3350C11)");
    check_base_class_offset(lv, (S3350C7_nt*)(S3350C12*), 0, "S3350C11");
    check_base_class_offset(lv, (S3350C12*), 0, "S3350C11");
    test_class_info(&lv, &cd_S3350C11);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3350C11(Test_S3350C11, "S3350C11", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3350C7_nt;
extern Class_Descriptor cd_S3350C12;
static Base_Class bases_S3350C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3350C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3350C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3350C11 = {  "S3350C11", // class name
  bases_S3350C11, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3350C13_nt  {
  int s3350c13f0[3];
  void  mf3350c13(); // _ZN11S3350C13_nt9mf3350c13Ev
};
//SIG(-1 S3350C13_nt) C1{ m Fi[3]}


void  S3350C13_nt ::mf3350c13(){}

//skip512 S3350C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3350C18  : S3350C7_nt {
};
//SIG(-1 S3350C18) C1{ BC2{ m Fp Fi[2]}}



static void Test_S3350C18()
{
  extern Class_Descriptor cd_S3350C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3350C18, buf);
    S3350C18 &lv = *(new (buf) S3350C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3350C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3350C18)");
    check_base_class_offset(lv, (S3350C7_nt*), 0, "S3350C18");
    test_class_info(&lv, &cd_S3350C18);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3350C18(Test_S3350C18, "S3350C18", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3350C7_nt;
static Base_Class bases_S3350C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3350C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3350C18 = {  "S3350C18", // class name
  bases_S3350C18, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3350C17  : S3350C18 {
};
//SIG(-1 S3350C17) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S3350C17()
{
  extern Class_Descriptor cd_S3350C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3350C17, buf);
    S3350C17 &lv = *(new (buf) S3350C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3350C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3350C17)");
    check_base_class_offset(lv, (S3350C7_nt*)(S3350C18*), 0, "S3350C17");
    check_base_class_offset(lv, (S3350C18*), 0, "S3350C17");
    test_class_info(&lv, &cd_S3350C17);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3350C17(Test_S3350C17, "S3350C17", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3350C7_nt;
extern Class_Descriptor cd_S3350C18;
static Base_Class bases_S3350C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3350C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3350C18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3350C17 = {  "S3350C17", // class name
  bases_S3350C17, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3350C2_nt  : S3350C3_nt {
  ::S3350C5_nt s3350c2f0;
  ::S3350C5_nt s3350c2f1;
  ::S3350C8_nt s3350c2f2;
  int s3350c2f3;
  char s3350c2f4[4];
  void *s3350c2f5[2];
  ::S3350C5_nt s3350c2f6;
  unsigned int s3350c2f7:1;
  unsigned int s3350c2f8:1;
  unsigned int s3350c2f9:1;
  unsigned int s3350c2f10:1;
  unsigned int s3350c2f11:1;
  unsigned int s3350c2f12:1;
  unsigned int s3350c2f13:1;
  unsigned int s3350c2f14:1;
  unsigned int s3350c2f15:1;
  unsigned int s3350c2f16:1;
  unsigned int s3350c2f17:1;
  unsigned int s3350c2f18:1;
  unsigned int s3350c2f19:1;
  unsigned int s3350c2f20:1;
  unsigned int s3350c2f21:1;
  unsigned int s3350c2f22:1;
  unsigned int s3350c2f23:1;
  unsigned int s3350c2f24:1;
  unsigned int s3350c2f25:1;
  unsigned int s3350c2f26:1;
  unsigned int s3350c2f27:1;
  unsigned int s3350c2f28:1;
  unsigned int s3350c2f29:1;
  unsigned int s3350c2f30:1;
  unsigned int s3350c2f31:1;
  unsigned int s3350c2f32:1;
  unsigned int s3350c2f33:1;
  unsigned int s3350c2f34:1;
  unsigned int s3350c2f35:1;
  unsigned int s3350c2f36:1;
  unsigned int s3350c2f37:1;
  unsigned int s3350c2f38:1;
  unsigned int s3350c2f39:1;
  unsigned int s3350c2f40:1;
  unsigned int s3350c2f41:1;
  unsigned int s3350c2f42:1;
  unsigned int s3350c2f43:1;
  unsigned int s3350c2f44:1;
  unsigned int s3350c2f45:1;
  unsigned int s3350c2f46:1;
  unsigned int s3350c2f47:1;
  unsigned int s3350c2f48:1;
  unsigned int s3350c2f49:1;
  unsigned int s3350c2f50:1;
  unsigned int s3350c2f51:1;
  unsigned int s3350c2f52:1;
  unsigned int s3350c2f53:1;
  unsigned int s3350c2f54:1;
  unsigned int s3350c2f55:1;
  unsigned int s3350c2f56:1;
  unsigned int s3350c2f57:1;
  unsigned int s3350c2f58:1;
  unsigned int s3350c2f59:1;
  unsigned int s3350c2f60:1;
  unsigned int s3350c2f61:1;
  unsigned int s3350c2f62:1;
  unsigned int s3350c2f63:1;
  unsigned int s3350c2f64:1;
  unsigned int s3350c2f65:1;
  unsigned int s3350c2f66:1;
  unsigned int s3350c2f67:1;
  unsigned int s3350c2f68:1;
  unsigned int s3350c2f69:1;
  unsigned int s3350c2f70:1;
  unsigned int s3350c2f71:1;
  unsigned int s3350c2f72:1;
  unsigned int s3350c2f73:1;
  unsigned int s3350c2f74:1;
  unsigned int s3350c2f75:1;
  unsigned int s3350c2f76:1;
  unsigned int s3350c2f77:1;
  unsigned int s3350c2f78:1;
  unsigned int s3350c2f79:1;
  unsigned int s3350c2f80:1;
  unsigned int s3350c2f81:1;
  unsigned int s3350c2f82:1;
  unsigned int s3350c2f83:1;
  int s3350c2f84[5];
  void *s3350c2f85[2];
  int s3350c2f86[3];
  ::S3350C4_nt s3350c2f87;
  ::S3350C4_nt s3350c2f88;
  ::S3350C4_nt s3350c2f89;
  ::S3350C11 s3350c2f90;
  ::S3350C11 s3350c2f91;
  int s3350c2f92;
  void *s3350c2f93[2];
  ::S3350C13_nt s3350c2f94;
  ::S3350C13_nt s3350c2f95;
  ::S3350C13_nt s3350c2f96;
  ::S3350C13_nt s3350c2f97;
  void *s3350c2f98;
  ::S3350C4_nt s3350c2f99;
  ::S3350C11 s3350c2f100;
  ::S3350C13_nt s3350c2f101;
  ::S3350C13_nt s3350c2f102;
  int s3350c2f103;
  ::S3350C13_nt s3350c2f104;
  ::S3350C13_nt s3350c2f105;
  void *s3350c2f106;
  int s3350c2f107;
  char s3350c2f108;
  ::S3350C13_nt s3350c2f109;
  ::S3350C13_nt s3350c2f110;
  void *s3350c2f111;
  int s3350c2f112;
  void *s3350c2f113;
  ::S3350C11 s3350c2f114;
  ::S3350C17 s3350c2f115;
  ::S3350C17 s3350c2f116;
  virtual  ~S3350C2_nt(); // _ZN10S3350C2_ntD1Ev
  virtual void  v70(); // _ZN10S3350C2_nt3v70Ev
  virtual void  v71(); // _ZN10S3350C2_nt3v71Ev
  virtual void  v72(); // _ZN10S3350C2_nt3v72Ev
  virtual void  v73(); // _ZN10S3350C2_nt3v73Ev
  virtual void  v74(); // _ZN10S3350C2_nt3v74Ev
  virtual void  v75(); // _ZN10S3350C2_nt3v75Ev
  virtual void  v76(); // _ZN10S3350C2_nt3v76Ev
  virtual void  v77(); // _ZN10S3350C2_nt3v77Ev
  virtual void  v78(); // _ZN10S3350C2_nt3v78Ev
  virtual void  v79(); // _ZN10S3350C2_nt3v79Ev
  virtual void  v80(); // _ZN10S3350C2_nt3v80Ev
  virtual void  v81(); // _ZN10S3350C2_nt3v81Ev
  virtual void  v82(); // _ZN10S3350C2_nt3v82Ev
  virtual void  v83(); // _ZN10S3350C2_nt3v83Ev
  virtual void  v84(); // _ZN10S3350C2_nt3v84Ev
  virtual void  v85(); // _ZN10S3350C2_nt3v85Ev
  virtual void  v86(); // _ZN10S3350C2_nt3v86Ev
  virtual void  v87(); // _ZN10S3350C2_nt3v87Ev
  virtual void  v88(); // _ZN10S3350C2_nt3v88Ev
  virtual void  v89(); // _ZN10S3350C2_nt3v89Ev
  virtual void  v90(); // _ZN10S3350C2_nt3v90Ev
  virtual void  v91(); // _ZN10S3350C2_nt3v91Ev
  virtual void  v92(); // _ZN10S3350C2_nt3v92Ev
  virtual void  v93(); // _ZN10S3350C2_nt3v93Ev
  virtual void  v94(); // _ZN10S3350C2_nt3v94Ev
  virtual void  v95(); // _ZN10S3350C2_nt3v95Ev
  virtual void  v96(); // _ZN10S3350C2_nt3v96Ev
  virtual void  v97(); // _ZN10S3350C2_nt3v97Ev
  virtual void  v98(); // _ZN10S3350C2_nt3v98Ev
  virtual void  v99(); // _ZN10S3350C2_nt3v99Ev
  virtual void  v100(); // _ZN10S3350C2_nt4v100Ev
  virtual void  v101(); // _ZN10S3350C2_nt4v101Ev
  virtual void  v102(); // _ZN10S3350C2_nt4v102Ev
  virtual void  v103(); // _ZN10S3350C2_nt4v103Ev
  virtual void  v104(); // _ZN10S3350C2_nt4v104Ev
  virtual void  v105(); // _ZN10S3350C2_nt4v105Ev
  virtual void  v106(); // _ZN10S3350C2_nt4v106Ev
  virtual void  v107(); // _ZN10S3350C2_nt4v107Ev
  virtual void  v108(); // _ZN10S3350C2_nt4v108Ev
  virtual void  v109(); // _ZN10S3350C2_nt4v109Ev
  virtual void  v110(); // _ZN10S3350C2_nt4v110Ev
  virtual void  v111(); // _ZN10S3350C2_nt4v111Ev
  virtual void  v112(); // _ZN10S3350C2_nt4v112Ev
  virtual void  v113(); // _ZN10S3350C2_nt4v113Ev
  virtual void  v114(); // _ZN10S3350C2_nt4v114Ev
  virtual void  v115(); // _ZN10S3350C2_nt4v115Ev
  virtual void  v116(); // _ZN10S3350C2_nt4v116Ev
  virtual void  v117(); // _ZN10S3350C2_nt4v117Ev
  virtual void  v118(); // _ZN10S3350C2_nt4v118Ev
  virtual void  v119(); // _ZN10S3350C2_nt4v119Ev
  virtual void  v120(); // _ZN10S3350C2_nt4v120Ev
  virtual void  v121(); // _ZN10S3350C2_nt4v121Ev
  virtual void  v122(); // _ZN10S3350C2_nt4v122Ev
  virtual void  v123(); // _ZN10S3350C2_nt4v123Ev
  virtual void  v124(); // _ZN10S3350C2_nt4v124Ev
  virtual void  v125(); // _ZN10S3350C2_nt4v125Ev
  virtual void  v126(); // _ZN10S3350C2_nt4v126Ev
  virtual void  v127(); // _ZN10S3350C2_nt4v127Ev
  virtual void  v128(); // _ZN10S3350C2_nt4v128Ev
  virtual void  v129(); // _ZN10S3350C2_nt4v129Ev
  virtual void  v130(); // _ZN10S3350C2_nt4v130Ev
  virtual void  v131(); // _ZN10S3350C2_nt4v131Ev
  virtual void  v132(); // _ZN10S3350C2_nt4v132Ev
  virtual void  v133(); // _ZN10S3350C2_nt4v133Ev
  virtual void  v134(); // _ZN10S3350C2_nt4v134Ev
  virtual void  v135(); // _ZN10S3350C2_nt4v135Ev
  virtual void  v136(); // _ZN10S3350C2_nt4v136Ev
  virtual void  v137(); // _ZN10S3350C2_nt4v137Ev
  virtual void  v138(); // _ZN10S3350C2_nt4v138Ev
  virtual void  v139(); // _ZN10S3350C2_nt4v139Ev
  virtual void  v140(); // _ZN10S3350C2_nt4v140Ev
  virtual void  v141(); // _ZN10S3350C2_nt4v141Ev
  virtual void  v142(); // _ZN10S3350C2_nt4v142Ev
  virtual void  v143(); // _ZN10S3350C2_nt4v143Ev
  virtual void  v144(); // _ZN10S3350C2_nt4v144Ev
  virtual void  v145(); // _ZN10S3350C2_nt4v145Ev
  virtual void  v146(); // _ZN10S3350C2_nt4v146Ev
  virtual void  v147(); // _ZN10S3350C2_nt4v147Ev
  virtual void  v148(); // _ZN10S3350C2_nt4v148Ev
  virtual void  v149(); // _ZN10S3350C2_nt4v149Ev
  virtual void  v150(); // _ZN10S3350C2_nt4v150Ev
  virtual void  v151(); // _ZN10S3350C2_nt4v151Ev
  virtual void  v152(); // _ZN10S3350C2_nt4v152Ev
  virtual void  v153(); // _ZN10S3350C2_nt4v153Ev
  virtual void  v154(); // _ZN10S3350C2_nt4v154Ev
  virtual void  v155(); // _ZN10S3350C2_nt4v155Ev
  virtual void  v156(); // _ZN10S3350C2_nt4v156Ev
  virtual void  v157(); // _ZN10S3350C2_nt4v157Ev
  virtual void  v158(); // _ZN10S3350C2_nt4v158Ev
  virtual void  v159(); // _ZN10S3350C2_nt4v159Ev
  virtual void  v160(); // _ZN10S3350C2_nt4v160Ev
  virtual void  v161(); // _ZN10S3350C2_nt4v161Ev
  virtual void  v162(); // _ZN10S3350C2_nt4v162Ev
  virtual void  v163(); // _ZN10S3350C2_nt4v163Ev
  virtual void  v164(); // _ZN10S3350C2_nt4v164Ev
  virtual void  v165(); // _ZN10S3350C2_nt4v165Ev
  virtual void  v166(); // _ZN10S3350C2_nt4v166Ev
  virtual void  v167(); // _ZN10S3350C2_nt4v167Ev
  virtual void  v168(); // _ZN10S3350C2_nt4v168Ev
  virtual void  v169(); // _ZN10S3350C2_nt4v169Ev
  virtual void  v170(); // _ZN10S3350C2_nt4v170Ev
  virtual void  v171(); // _ZN10S3350C2_nt4v171Ev
  virtual void  v172(); // _ZN10S3350C2_nt4v172Ev
  virtual void  v173(); // _ZN10S3350C2_nt4v173Ev
  virtual void  v174(); // _ZN10S3350C2_nt4v174Ev
  virtual void  v175(); // _ZN10S3350C2_nt4v175Ev
  virtual void  v176(); // _ZN10S3350C2_nt4v176Ev
  virtual void  v177(); // _ZN10S3350C2_nt4v177Ev
  virtual void  v178(); // _ZN10S3350C2_nt4v178Ev
  virtual void  v179(); // _ZN10S3350C2_nt4v179Ev
  virtual void  v180(); // _ZN10S3350C2_nt4v180Ev
  virtual void  v181(); // _ZN10S3350C2_nt4v181Ev
  virtual void  v182(); // _ZN10S3350C2_nt4v182Ev
  virtual void  v183(); // _ZN10S3350C2_nt4v183Ev
  virtual void  v184(); // _ZN10S3350C2_nt4v184Ev
  virtual void  v185(); // _ZN10S3350C2_nt4v185Ev
  virtual void  v186(); // _ZN10S3350C2_nt4v186Ev
  virtual void  v187(); // _ZN10S3350C2_nt4v187Ev
  virtual void  v188(); // _ZN10S3350C2_nt4v188Ev
  virtual void  v189(); // _ZN10S3350C2_nt4v189Ev
  virtual void  v190(); // _ZN10S3350C2_nt4v190Ev
  virtual void  v191(); // _ZN10S3350C2_nt4v191Ev
  virtual void  v192(); // _ZN10S3350C2_nt4v192Ev
  virtual void  v193(); // _ZN10S3350C2_nt4v193Ev
  virtual void  v194(); // _ZN10S3350C2_nt4v194Ev
  virtual void  v195(); // _ZN10S3350C2_nt4v195Ev
  virtual void  v196(); // _ZN10S3350C2_nt4v196Ev
  virtual void  v197(); // _ZN10S3350C2_nt4v197Ev
  virtual void  v198(); // _ZN10S3350C2_nt4v198Ev
  virtual void  v199(); // _ZN10S3350C2_nt4v199Ev
  virtual void  v200(); // _ZN10S3350C2_nt4v200Ev
  virtual void  v201(); // _ZN10S3350C2_nt4v201Ev
  virtual void  v202(); // _ZN10S3350C2_nt4v202Ev
  virtual void  v203(); // _ZN10S3350C2_nt4v203Ev
  virtual void  v204(); // _ZN10S3350C2_nt4v204Ev
  virtual void  v205(); // _ZN10S3350C2_nt4v205Ev
  virtual void  v206(); // _ZN10S3350C2_nt4v206Ev
  virtual void  v207(); // _ZN10S3350C2_nt4v207Ev
  virtual void  v208(); // _ZN10S3350C2_nt4v208Ev
  virtual void  v209(); // _ZN10S3350C2_nt4v209Ev
  virtual void  v210(); // _ZN10S3350C2_nt4v210Ev
  virtual void  v211(); // _ZN10S3350C2_nt4v211Ev
  virtual void  v212(); // _ZN10S3350C2_nt4v212Ev
  S3350C2_nt(); // tgen
};
//SIG(-1 S3350C2_nt) C1{ BC2{ vd v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 FC4{ BC5{ BC6{ m Fp Fi[2]}}} FC4 FC7{ m Fi} Fi Fc[4] Fp[2] FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC3 FC3 FC3 FC8{ BC9{ BC6}} FC8 Fi Fp[2] FC10{ m Fi[3]} FC10 FC10 FC10 Fp FC3 FC8 FC10 FC10 Fi FC10 FC10 Fp Fi Fc FC10 FC10 Fp Fi Fp FC8 FC11{ BC12{ BC6}} FC11}


 S3350C2_nt ::~S3350C2_nt(){ note_dtor("S3350C2_nt", this);}
void  S3350C2_nt ::v70(){vfunc_called(this, "_ZN10S3350C2_nt3v70Ev");}
void  S3350C2_nt ::v71(){vfunc_called(this, "_ZN10S3350C2_nt3v71Ev");}
void  S3350C2_nt ::v72(){vfunc_called(this, "_ZN10S3350C2_nt3v72Ev");}
void  S3350C2_nt ::v73(){vfunc_called(this, "_ZN10S3350C2_nt3v73Ev");}
void  S3350C2_nt ::v74(){vfunc_called(this, "_ZN10S3350C2_nt3v74Ev");}
void  S3350C2_nt ::v75(){vfunc_called(this, "_ZN10S3350C2_nt3v75Ev");}
void  S3350C2_nt ::v76(){vfunc_called(this, "_ZN10S3350C2_nt3v76Ev");}
void  S3350C2_nt ::v77(){vfunc_called(this, "_ZN10S3350C2_nt3v77Ev");}
void  S3350C2_nt ::v78(){vfunc_called(this, "_ZN10S3350C2_nt3v78Ev");}
void  S3350C2_nt ::v79(){vfunc_called(this, "_ZN10S3350C2_nt3v79Ev");}
void  S3350C2_nt ::v80(){vfunc_called(this, "_ZN10S3350C2_nt3v80Ev");}
void  S3350C2_nt ::v81(){vfunc_called(this, "_ZN10S3350C2_nt3v81Ev");}
void  S3350C2_nt ::v82(){vfunc_called(this, "_ZN10S3350C2_nt3v82Ev");}
void  S3350C2_nt ::v83(){vfunc_called(this, "_ZN10S3350C2_nt3v83Ev");}
void  S3350C2_nt ::v84(){vfunc_called(this, "_ZN10S3350C2_nt3v84Ev");}
void  S3350C2_nt ::v85(){vfunc_called(this, "_ZN10S3350C2_nt3v85Ev");}
void  S3350C2_nt ::v86(){vfunc_called(this, "_ZN10S3350C2_nt3v86Ev");}
void  S3350C2_nt ::v87(){vfunc_called(this, "_ZN10S3350C2_nt3v87Ev");}
void  S3350C2_nt ::v88(){vfunc_called(this, "_ZN10S3350C2_nt3v88Ev");}
void  S3350C2_nt ::v89(){vfunc_called(this, "_ZN10S3350C2_nt3v89Ev");}
void  S3350C2_nt ::v90(){vfunc_called(this, "_ZN10S3350C2_nt3v90Ev");}
void  S3350C2_nt ::v91(){vfunc_called(this, "_ZN10S3350C2_nt3v91Ev");}
void  S3350C2_nt ::v92(){vfunc_called(this, "_ZN10S3350C2_nt3v92Ev");}
void  S3350C2_nt ::v93(){vfunc_called(this, "_ZN10S3350C2_nt3v93Ev");}
void  S3350C2_nt ::v94(){vfunc_called(this, "_ZN10S3350C2_nt3v94Ev");}
void  S3350C2_nt ::v95(){vfunc_called(this, "_ZN10S3350C2_nt3v95Ev");}
void  S3350C2_nt ::v96(){vfunc_called(this, "_ZN10S3350C2_nt3v96Ev");}
void  S3350C2_nt ::v97(){vfunc_called(this, "_ZN10S3350C2_nt3v97Ev");}
void  S3350C2_nt ::v98(){vfunc_called(this, "_ZN10S3350C2_nt3v98Ev");}
void  S3350C2_nt ::v99(){vfunc_called(this, "_ZN10S3350C2_nt3v99Ev");}
void  S3350C2_nt ::v100(){vfunc_called(this, "_ZN10S3350C2_nt4v100Ev");}
void  S3350C2_nt ::v101(){vfunc_called(this, "_ZN10S3350C2_nt4v101Ev");}
void  S3350C2_nt ::v102(){vfunc_called(this, "_ZN10S3350C2_nt4v102Ev");}
void  S3350C2_nt ::v103(){vfunc_called(this, "_ZN10S3350C2_nt4v103Ev");}
void  S3350C2_nt ::v104(){vfunc_called(this, "_ZN10S3350C2_nt4v104Ev");}
void  S3350C2_nt ::v105(){vfunc_called(this, "_ZN10S3350C2_nt4v105Ev");}
void  S3350C2_nt ::v106(){vfunc_called(this, "_ZN10S3350C2_nt4v106Ev");}
void  S3350C2_nt ::v107(){vfunc_called(this, "_ZN10S3350C2_nt4v107Ev");}
void  S3350C2_nt ::v108(){vfunc_called(this, "_ZN10S3350C2_nt4v108Ev");}
void  S3350C2_nt ::v109(){vfunc_called(this, "_ZN10S3350C2_nt4v109Ev");}
void  S3350C2_nt ::v110(){vfunc_called(this, "_ZN10S3350C2_nt4v110Ev");}
void  S3350C2_nt ::v111(){vfunc_called(this, "_ZN10S3350C2_nt4v111Ev");}
void  S3350C2_nt ::v112(){vfunc_called(this, "_ZN10S3350C2_nt4v112Ev");}
void  S3350C2_nt ::v113(){vfunc_called(this, "_ZN10S3350C2_nt4v113Ev");}
void  S3350C2_nt ::v114(){vfunc_called(this, "_ZN10S3350C2_nt4v114Ev");}
void  S3350C2_nt ::v115(){vfunc_called(this, "_ZN10S3350C2_nt4v115Ev");}
void  S3350C2_nt ::v116(){vfunc_called(this, "_ZN10S3350C2_nt4v116Ev");}
void  S3350C2_nt ::v117(){vfunc_called(this, "_ZN10S3350C2_nt4v117Ev");}
void  S3350C2_nt ::v118(){vfunc_called(this, "_ZN10S3350C2_nt4v118Ev");}
void  S3350C2_nt ::v119(){vfunc_called(this, "_ZN10S3350C2_nt4v119Ev");}
void  S3350C2_nt ::v120(){vfunc_called(this, "_ZN10S3350C2_nt4v120Ev");}
void  S3350C2_nt ::v121(){vfunc_called(this, "_ZN10S3350C2_nt4v121Ev");}
void  S3350C2_nt ::v122(){vfunc_called(this, "_ZN10S3350C2_nt4v122Ev");}
void  S3350C2_nt ::v123(){vfunc_called(this, "_ZN10S3350C2_nt4v123Ev");}
void  S3350C2_nt ::v124(){vfunc_called(this, "_ZN10S3350C2_nt4v124Ev");}
void  S3350C2_nt ::v125(){vfunc_called(this, "_ZN10S3350C2_nt4v125Ev");}
void  S3350C2_nt ::v126(){vfunc_called(this, "_ZN10S3350C2_nt4v126Ev");}
void  S3350C2_nt ::v127(){vfunc_called(this, "_ZN10S3350C2_nt4v127Ev");}
void  S3350C2_nt ::v128(){vfunc_called(this, "_ZN10S3350C2_nt4v128Ev");}
void  S3350C2_nt ::v129(){vfunc_called(this, "_ZN10S3350C2_nt4v129Ev");}
void  S3350C2_nt ::v130(){vfunc_called(this, "_ZN10S3350C2_nt4v130Ev");}
void  S3350C2_nt ::v131(){vfunc_called(this, "_ZN10S3350C2_nt4v131Ev");}
void  S3350C2_nt ::v132(){vfunc_called(this, "_ZN10S3350C2_nt4v132Ev");}
void  S3350C2_nt ::v133(){vfunc_called(this, "_ZN10S3350C2_nt4v133Ev");}
void  S3350C2_nt ::v134(){vfunc_called(this, "_ZN10S3350C2_nt4v134Ev");}
void  S3350C2_nt ::v135(){vfunc_called(this, "_ZN10S3350C2_nt4v135Ev");}
void  S3350C2_nt ::v136(){vfunc_called(this, "_ZN10S3350C2_nt4v136Ev");}
void  S3350C2_nt ::v137(){vfunc_called(this, "_ZN10S3350C2_nt4v137Ev");}
void  S3350C2_nt ::v138(){vfunc_called(this, "_ZN10S3350C2_nt4v138Ev");}
void  S3350C2_nt ::v139(){vfunc_called(this, "_ZN10S3350C2_nt4v139Ev");}
void  S3350C2_nt ::v140(){vfunc_called(this, "_ZN10S3350C2_nt4v140Ev");}
void  S3350C2_nt ::v141(){vfunc_called(this, "_ZN10S3350C2_nt4v141Ev");}
void  S3350C2_nt ::v142(){vfunc_called(this, "_ZN10S3350C2_nt4v142Ev");}
void  S3350C2_nt ::v143(){vfunc_called(this, "_ZN10S3350C2_nt4v143Ev");}
void  S3350C2_nt ::v144(){vfunc_called(this, "_ZN10S3350C2_nt4v144Ev");}
void  S3350C2_nt ::v145(){vfunc_called(this, "_ZN10S3350C2_nt4v145Ev");}
void  S3350C2_nt ::v146(){vfunc_called(this, "_ZN10S3350C2_nt4v146Ev");}
void  S3350C2_nt ::v147(){vfunc_called(this, "_ZN10S3350C2_nt4v147Ev");}
void  S3350C2_nt ::v148(){vfunc_called(this, "_ZN10S3350C2_nt4v148Ev");}
void  S3350C2_nt ::v149(){vfunc_called(this, "_ZN10S3350C2_nt4v149Ev");}
void  S3350C2_nt ::v150(){vfunc_called(this, "_ZN10S3350C2_nt4v150Ev");}
void  S3350C2_nt ::v151(){vfunc_called(this, "_ZN10S3350C2_nt4v151Ev");}
void  S3350C2_nt ::v152(){vfunc_called(this, "_ZN10S3350C2_nt4v152Ev");}
void  S3350C2_nt ::v153(){vfunc_called(this, "_ZN10S3350C2_nt4v153Ev");}
void  S3350C2_nt ::v154(){vfunc_called(this, "_ZN10S3350C2_nt4v154Ev");}
void  S3350C2_nt ::v155(){vfunc_called(this, "_ZN10S3350C2_nt4v155Ev");}
void  S3350C2_nt ::v156(){vfunc_called(this, "_ZN10S3350C2_nt4v156Ev");}
void  S3350C2_nt ::v157(){vfunc_called(this, "_ZN10S3350C2_nt4v157Ev");}
void  S3350C2_nt ::v158(){vfunc_called(this, "_ZN10S3350C2_nt4v158Ev");}
void  S3350C2_nt ::v159(){vfunc_called(this, "_ZN10S3350C2_nt4v159Ev");}
void  S3350C2_nt ::v160(){vfunc_called(this, "_ZN10S3350C2_nt4v160Ev");}
void  S3350C2_nt ::v161(){vfunc_called(this, "_ZN10S3350C2_nt4v161Ev");}
void  S3350C2_nt ::v162(){vfunc_called(this, "_ZN10S3350C2_nt4v162Ev");}
void  S3350C2_nt ::v163(){vfunc_called(this, "_ZN10S3350C2_nt4v163Ev");}
void  S3350C2_nt ::v164(){vfunc_called(this, "_ZN10S3350C2_nt4v164Ev");}
void  S3350C2_nt ::v165(){vfunc_called(this, "_ZN10S3350C2_nt4v165Ev");}
void  S3350C2_nt ::v166(){vfunc_called(this, "_ZN10S3350C2_nt4v166Ev");}
void  S3350C2_nt ::v167(){vfunc_called(this, "_ZN10S3350C2_nt4v167Ev");}
void  S3350C2_nt ::v168(){vfunc_called(this, "_ZN10S3350C2_nt4v168Ev");}
void  S3350C2_nt ::v169(){vfunc_called(this, "_ZN10S3350C2_nt4v169Ev");}
void  S3350C2_nt ::v170(){vfunc_called(this, "_ZN10S3350C2_nt4v170Ev");}
void  S3350C2_nt ::v171(){vfunc_called(this, "_ZN10S3350C2_nt4v171Ev");}
void  S3350C2_nt ::v172(){vfunc_called(this, "_ZN10S3350C2_nt4v172Ev");}
void  S3350C2_nt ::v173(){vfunc_called(this, "_ZN10S3350C2_nt4v173Ev");}
void  S3350C2_nt ::v174(){vfunc_called(this, "_ZN10S3350C2_nt4v174Ev");}
void  S3350C2_nt ::v175(){vfunc_called(this, "_ZN10S3350C2_nt4v175Ev");}
void  S3350C2_nt ::v176(){vfunc_called(this, "_ZN10S3350C2_nt4v176Ev");}
void  S3350C2_nt ::v177(){vfunc_called(this, "_ZN10S3350C2_nt4v177Ev");}
void  S3350C2_nt ::v178(){vfunc_called(this, "_ZN10S3350C2_nt4v178Ev");}
void  S3350C2_nt ::v179(){vfunc_called(this, "_ZN10S3350C2_nt4v179Ev");}
void  S3350C2_nt ::v180(){vfunc_called(this, "_ZN10S3350C2_nt4v180Ev");}
void  S3350C2_nt ::v181(){vfunc_called(this, "_ZN10S3350C2_nt4v181Ev");}
void  S3350C2_nt ::v182(){vfunc_called(this, "_ZN10S3350C2_nt4v182Ev");}
void  S3350C2_nt ::v183(){vfunc_called(this, "_ZN10S3350C2_nt4v183Ev");}
void  S3350C2_nt ::v184(){vfunc_called(this, "_ZN10S3350C2_nt4v184Ev");}
void  S3350C2_nt ::v185(){vfunc_called(this, "_ZN10S3350C2_nt4v185Ev");}
void  S3350C2_nt ::v186(){vfunc_called(this, "_ZN10S3350C2_nt4v186Ev");}
void  S3350C2_nt ::v187(){vfunc_called(this, "_ZN10S3350C2_nt4v187Ev");}
void  S3350C2_nt ::v188(){vfunc_called(this, "_ZN10S3350C2_nt4v188Ev");}
void  S3350C2_nt ::v189(){vfunc_called(this, "_ZN10S3350C2_nt4v189Ev");}
void  S3350C2_nt ::v190(){vfunc_called(this, "_ZN10S3350C2_nt4v190Ev");}
void  S3350C2_nt ::v191(){vfunc_called(this, "_ZN10S3350C2_nt4v191Ev");}
void  S3350C2_nt ::v192(){vfunc_called(this, "_ZN10S3350C2_nt4v192Ev");}
void  S3350C2_nt ::v193(){vfunc_called(this, "_ZN10S3350C2_nt4v193Ev");}
void  S3350C2_nt ::v194(){vfunc_called(this, "_ZN10S3350C2_nt4v194Ev");}
void  S3350C2_nt ::v195(){vfunc_called(this, "_ZN10S3350C2_nt4v195Ev");}
void  S3350C2_nt ::v196(){vfunc_called(this, "_ZN10S3350C2_nt4v196Ev");}
void  S3350C2_nt ::v197(){vfunc_called(this, "_ZN10S3350C2_nt4v197Ev");}
void  S3350C2_nt ::v198(){vfunc_called(this, "_ZN10S3350C2_nt4v198Ev");}
void  S3350C2_nt ::v199(){vfunc_called(this, "_ZN10S3350C2_nt4v199Ev");}
void  S3350C2_nt ::v200(){vfunc_called(this, "_ZN10S3350C2_nt4v200Ev");}
void  S3350C2_nt ::v201(){vfunc_called(this, "_ZN10S3350C2_nt4v201Ev");}
void  S3350C2_nt ::v202(){vfunc_called(this, "_ZN10S3350C2_nt4v202Ev");}
void  S3350C2_nt ::v203(){vfunc_called(this, "_ZN10S3350C2_nt4v203Ev");}
void  S3350C2_nt ::v204(){vfunc_called(this, "_ZN10S3350C2_nt4v204Ev");}
void  S3350C2_nt ::v205(){vfunc_called(this, "_ZN10S3350C2_nt4v205Ev");}
void  S3350C2_nt ::v206(){vfunc_called(this, "_ZN10S3350C2_nt4v206Ev");}
void  S3350C2_nt ::v207(){vfunc_called(this, "_ZN10S3350C2_nt4v207Ev");}
void  S3350C2_nt ::v208(){vfunc_called(this, "_ZN10S3350C2_nt4v208Ev");}
void  S3350C2_nt ::v209(){vfunc_called(this, "_ZN10S3350C2_nt4v209Ev");}
void  S3350C2_nt ::v210(){vfunc_called(this, "_ZN10S3350C2_nt4v210Ev");}
void  S3350C2_nt ::v211(){vfunc_called(this, "_ZN10S3350C2_nt4v211Ev");}
void  S3350C2_nt ::v212(){vfunc_called(this, "_ZN10S3350C2_nt4v212Ev");}
S3350C2_nt ::S3350C2_nt(){ note_ctor("S3350C2_nt", this);} // tgen

//skip512 S3350C2_nt

#else // __cplusplus

extern void _ZN10S3350C2_ntC1Ev();
extern void _ZN10S3350C2_ntD1Ev();
Name_Map name_map_S3350C2_nt[] = {
  NSPAIR(_ZN10S3350C2_ntC1Ev),
  NSPAIR(_ZN10S3350C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3350C3_nt;
extern VTBL_ENTRY _ZTI10S3350C3_nt[];
extern  VTBL_ENTRY _ZTV10S3350C3_nt[];
static Base_Class bases_S3350C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3350C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S3350C2_nt[];
extern void _ZN10S3350C2_ntD1Ev();
extern void _ZN10S3350C2_ntD0Ev();
extern void _ZN10S3350C3_nt2v6Ev();
extern void _ZN10S3350C3_nt2v7Ev();
extern void _ZN10S3350C3_nt2v8Ev();
extern void _ZN10S3350C3_nt2v9Ev();
extern void _ZN10S3350C3_nt3v10Ev();
extern void _ZN10S3350C3_nt3v11Ev();
extern void _ZN10S3350C3_nt3v12Ev();
extern void _ZN10S3350C3_nt3v13Ev();
extern void _ZN10S3350C3_nt3v14Ev();
extern void _ZN10S3350C3_nt3v15Ev();
extern void _ZN10S3350C3_nt3v16Ev();
extern void _ZN10S3350C3_nt3v17Ev();
extern void _ZN10S3350C3_nt3v18Ev();
extern void _ZN10S3350C3_nt3v19Ev();
extern void _ZN10S3350C3_nt3v20Ev();
extern void _ZN10S3350C3_nt3v21Ev();
extern void _ZN10S3350C3_nt3v22Ev();
extern void _ZN10S3350C3_nt3v23Ev();
extern void _ZN10S3350C3_nt3v24Ev();
extern void _ZN10S3350C3_nt3v25Ev();
extern void _ZN10S3350C3_nt3v26Ev();
extern void _ZN10S3350C3_nt3v27Ev();
extern void _ZN10S3350C3_nt3v28Ev();
extern void _ZN10S3350C3_nt3v29Ev();
extern void _ZN10S3350C3_nt3v30Ev();
extern void _ZN10S3350C3_nt3v31Ev();
extern void _ZN10S3350C3_nt3v32Ev();
extern void _ZN10S3350C3_nt3v33Ev();
extern void _ZN10S3350C3_nt3v34Ev();
extern void _ZN10S3350C3_nt3v35Ev();
extern void _ZN10S3350C3_nt3v36Ev();
extern void _ZN10S3350C3_nt3v37Ev();
extern void _ZN10S3350C3_nt3v38Ev();
extern void _ZN10S3350C3_nt3v39Ev();
extern void _ZN10S3350C3_nt3v40Ev();
extern void _ZN10S3350C3_nt3v41Ev();
extern void _ZN10S3350C3_nt3v42Ev();
extern void _ZN10S3350C3_nt3v43Ev();
extern void _ZN10S3350C3_nt3v44Ev();
extern void _ZN10S3350C3_nt3v45Ev();
extern void _ZN10S3350C3_nt3v46Ev();
extern void _ZN10S3350C3_nt3v47Ev();
extern void _ZN10S3350C3_nt3v48Ev();
extern void _ZN10S3350C3_nt3v49Ev();
extern void _ZN10S3350C3_nt3v50Ev();
extern void _ZN10S3350C3_nt3v51Ev();
extern void _ZN10S3350C3_nt3v52Ev();
extern void _ZN10S3350C3_nt3v53Ev();
extern void _ZN10S3350C3_nt3v54Ev();
extern void _ZN10S3350C3_nt3v55Ev();
extern void _ZN10S3350C3_nt3v56Ev();
extern void _ZN10S3350C3_nt3v57Ev();
extern void _ZN10S3350C3_nt3v58Ev();
extern void _ZN10S3350C3_nt3v59Ev();
extern void _ZN10S3350C3_nt3v60Ev();
extern void _ZN10S3350C3_nt3v61Ev();
extern void _ZN10S3350C3_nt3v62Ev();
extern void _ZN10S3350C3_nt3v63Ev();
extern void _ZN10S3350C3_nt3v64Ev();
extern void _ZN10S3350C3_nt3v65Ev();
extern void _ZN10S3350C3_nt3v66Ev();
extern void _ZN10S3350C3_nt3v67Ev();
extern void _ZN10S3350C3_nt3v68Ev();
extern void _ZN10S3350C3_nt3v69Ev();
extern void _ZN10S3350C2_nt3v70Ev();
extern void _ZN10S3350C2_nt3v71Ev();
extern void _ZN10S3350C2_nt3v72Ev();
extern void _ZN10S3350C2_nt3v73Ev();
extern void _ZN10S3350C2_nt3v74Ev();
extern void _ZN10S3350C2_nt3v75Ev();
extern void _ZN10S3350C2_nt3v76Ev();
extern void _ZN10S3350C2_nt3v77Ev();
extern void _ZN10S3350C2_nt3v78Ev();
extern void _ZN10S3350C2_nt3v79Ev();
extern void _ZN10S3350C2_nt3v80Ev();
extern void _ZN10S3350C2_nt3v81Ev();
extern void _ZN10S3350C2_nt3v82Ev();
extern void _ZN10S3350C2_nt3v83Ev();
extern void _ZN10S3350C2_nt3v84Ev();
extern void _ZN10S3350C2_nt3v85Ev();
extern void _ZN10S3350C2_nt3v86Ev();
extern void _ZN10S3350C2_nt3v87Ev();
extern void _ZN10S3350C2_nt3v88Ev();
extern void _ZN10S3350C2_nt3v89Ev();
extern void _ZN10S3350C2_nt3v90Ev();
extern void _ZN10S3350C2_nt3v91Ev();
extern void _ZN10S3350C2_nt3v92Ev();
extern void _ZN10S3350C2_nt3v93Ev();
extern void _ZN10S3350C2_nt3v94Ev();
extern void _ZN10S3350C2_nt3v95Ev();
extern void _ZN10S3350C2_nt3v96Ev();
extern void _ZN10S3350C2_nt3v97Ev();
extern void _ZN10S3350C2_nt3v98Ev();
extern void _ZN10S3350C2_nt3v99Ev();
extern void _ZN10S3350C2_nt4v100Ev();
extern void _ZN10S3350C2_nt4v101Ev();
extern void _ZN10S3350C2_nt4v102Ev();
extern void _ZN10S3350C2_nt4v103Ev();
extern void _ZN10S3350C2_nt4v104Ev();
extern void _ZN10S3350C2_nt4v105Ev();
extern void _ZN10S3350C2_nt4v106Ev();
extern void _ZN10S3350C2_nt4v107Ev();
extern void _ZN10S3350C2_nt4v108Ev();
extern void _ZN10S3350C2_nt4v109Ev();
extern void _ZN10S3350C2_nt4v110Ev();
extern void _ZN10S3350C2_nt4v111Ev();
extern void _ZN10S3350C2_nt4v112Ev();
extern void _ZN10S3350C2_nt4v113Ev();
extern void _ZN10S3350C2_nt4v114Ev();
extern void _ZN10S3350C2_nt4v115Ev();
extern void _ZN10S3350C2_nt4v116Ev();
extern void _ZN10S3350C2_nt4v117Ev();
extern void _ZN10S3350C2_nt4v118Ev();
extern void _ZN10S3350C2_nt4v119Ev();
extern void _ZN10S3350C2_nt4v120Ev();
extern void _ZN10S3350C2_nt4v121Ev();
extern void _ZN10S3350C2_nt4v122Ev();
extern void _ZN10S3350C2_nt4v123Ev();
extern void _ZN10S3350C2_nt4v124Ev();
extern void _ZN10S3350C2_nt4v125Ev();
extern void _ZN10S3350C2_nt4v126Ev();
extern void _ZN10S3350C2_nt4v127Ev();
extern void _ZN10S3350C2_nt4v128Ev();
extern void _ZN10S3350C2_nt4v129Ev();
extern void _ZN10S3350C2_nt4v130Ev();
extern void _ZN10S3350C2_nt4v131Ev();
extern void _ZN10S3350C2_nt4v132Ev();
extern void _ZN10S3350C2_nt4v133Ev();
extern void _ZN10S3350C2_nt4v134Ev();
extern void _ZN10S3350C2_nt4v135Ev();
extern void _ZN10S3350C2_nt4v136Ev();
extern void _ZN10S3350C2_nt4v137Ev();
extern void _ZN10S3350C2_nt4v138Ev();
extern void _ZN10S3350C2_nt4v139Ev();
extern void _ZN10S3350C2_nt4v140Ev();
extern void _ZN10S3350C2_nt4v141Ev();
extern void _ZN10S3350C2_nt4v142Ev();
extern void _ZN10S3350C2_nt4v143Ev();
extern void _ZN10S3350C2_nt4v144Ev();
extern void _ZN10S3350C2_nt4v145Ev();
extern void _ZN10S3350C2_nt4v146Ev();
extern void _ZN10S3350C2_nt4v147Ev();
extern void _ZN10S3350C2_nt4v148Ev();
extern void _ZN10S3350C2_nt4v149Ev();
extern void _ZN10S3350C2_nt4v150Ev();
extern void _ZN10S3350C2_nt4v151Ev();
extern void _ZN10S3350C2_nt4v152Ev();
extern void _ZN10S3350C2_nt4v153Ev();
extern void _ZN10S3350C2_nt4v154Ev();
extern void _ZN10S3350C2_nt4v155Ev();
extern void _ZN10S3350C2_nt4v156Ev();
extern void _ZN10S3350C2_nt4v157Ev();
extern void _ZN10S3350C2_nt4v158Ev();
extern void _ZN10S3350C2_nt4v159Ev();
extern void _ZN10S3350C2_nt4v160Ev();
extern void _ZN10S3350C2_nt4v161Ev();
extern void _ZN10S3350C2_nt4v162Ev();
extern void _ZN10S3350C2_nt4v163Ev();
extern void _ZN10S3350C2_nt4v164Ev();
extern void _ZN10S3350C2_nt4v165Ev();
extern void _ZN10S3350C2_nt4v166Ev();
extern void _ZN10S3350C2_nt4v167Ev();
extern void _ZN10S3350C2_nt4v168Ev();
extern void _ZN10S3350C2_nt4v169Ev();
extern void _ZN10S3350C2_nt4v170Ev();
extern void _ZN10S3350C2_nt4v171Ev();
extern void _ZN10S3350C2_nt4v172Ev();
extern void _ZN10S3350C2_nt4v173Ev();
extern void _ZN10S3350C2_nt4v174Ev();
extern void _ZN10S3350C2_nt4v175Ev();
extern void _ZN10S3350C2_nt4v176Ev();
extern void _ZN10S3350C2_nt4v177Ev();
extern void _ZN10S3350C2_nt4v178Ev();
extern void _ZN10S3350C2_nt4v179Ev();
extern void _ZN10S3350C2_nt4v180Ev();
extern void _ZN10S3350C2_nt4v181Ev();
extern void _ZN10S3350C2_nt4v182Ev();
extern void _ZN10S3350C2_nt4v183Ev();
extern void _ZN10S3350C2_nt4v184Ev();
extern void _ZN10S3350C2_nt4v185Ev();
extern void _ZN10S3350C2_nt4v186Ev();
extern void _ZN10S3350C2_nt4v187Ev();
extern void _ZN10S3350C2_nt4v188Ev();
extern void _ZN10S3350C2_nt4v189Ev();
extern void _ZN10S3350C2_nt4v190Ev();
extern void _ZN10S3350C2_nt4v191Ev();
extern void _ZN10S3350C2_nt4v192Ev();
extern void _ZN10S3350C2_nt4v193Ev();
extern void _ZN10S3350C2_nt4v194Ev();
extern void _ZN10S3350C2_nt4v195Ev();
extern void _ZN10S3350C2_nt4v196Ev();
extern void _ZN10S3350C2_nt4v197Ev();
extern void _ZN10S3350C2_nt4v198Ev();
extern void _ZN10S3350C2_nt4v199Ev();
extern void _ZN10S3350C2_nt4v200Ev();
extern void _ZN10S3350C2_nt4v201Ev();
extern void _ZN10S3350C2_nt4v202Ev();
extern void _ZN10S3350C2_nt4v203Ev();
extern void _ZN10S3350C2_nt4v204Ev();
extern void _ZN10S3350C2_nt4v205Ev();
extern void _ZN10S3350C2_nt4v206Ev();
extern void _ZN10S3350C2_nt4v207Ev();
extern void _ZN10S3350C2_nt4v208Ev();
extern void _ZN10S3350C2_nt4v209Ev();
extern void _ZN10S3350C2_nt4v210Ev();
extern void _ZN10S3350C2_nt4v211Ev();
extern void _ZN10S3350C2_nt4v212Ev();
static  VTBL_ENTRY vtc_S3350C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S3350C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S3350C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v211Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v212Ev,
};
extern VTBL_ENTRY _ZTI10S3350C2_nt[];
VTBL_ENTRY *P__ZTI10S3350C2_nt = _ZTI10S3350C2_nt; 
extern  VTBL_ENTRY _ZTV10S3350C2_nt[];
Class_Descriptor cd_S3350C2_nt = {  "S3350C2_nt", // class name
  bases_S3350C2_nt, 1,
  &(vtc_S3350C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(568,436), // object size
  NSPAIRA(_ZTI10S3350C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S3350C2_nt),211, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3350C21_nt  {
  void *s3350c21f0;
  ::S3350C4_nt s3350c21f1;
  void  mf3350c21(); // _ZN11S3350C21_nt9mf3350c21Ev
};
//SIG(-1 S3350C21_nt) C1{ m Fp FC2{ m Fi[2]}}


void  S3350C21_nt ::mf3350c21(){}

//skip512 S3350C21_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3350C1  : S3350C2_nt {
  void *s3350c1f0;
  char s3350c1f1;
  void *s3350c1f2;
  ::S3350C13_nt s3350c1f3;
  void *s3350c1f4;
  unsigned int s3350c1f5:1;
  ::S3350C21_nt s3350c1f6;
  virtual  ~S3350C1(); // _ZN7S3350C1D1Ev
  virtual void  v1(); // _ZN7S3350C12v1Ev
  virtual void  v2(); // _ZN7S3350C12v2Ev
  virtual void  v3(); // _ZN7S3350C12v3Ev
  virtual void  v4(); // _ZN7S3350C12v4Ev
  virtual void  v5(); // _ZN7S3350C12v5Ev
  S3350C1(); // tgen
};
//SIG(1 S3350C1) C1{ BC2{ BC3{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC5 FC8{ m Fi} Fi Fc[4] Fp[2] FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC4 FC4 FC4 FC9{ BC10{ BC7}} FC9 Fi Fp[2] FC11{ m Fi[3]} FC11 FC11 FC11 Fp FC4 FC9 FC11 FC11 Fi FC11 FC11 Fp Fi Fc FC11 FC11 Fp Fi Fp FC9 FC12{ BC13{ BC7}} FC12} vd v1 v2 v3 v4 v5 Fp Fc Fp FC11 Fp Fi:1 FC14{ m Fp FC4}}


 S3350C1 ::~S3350C1(){ note_dtor("S3350C1", this);}
void  S3350C1 ::v1(){vfunc_called(this, "_ZN7S3350C12v1Ev");}
void  S3350C1 ::v2(){vfunc_called(this, "_ZN7S3350C12v2Ev");}
void  S3350C1 ::v3(){vfunc_called(this, "_ZN7S3350C12v3Ev");}
void  S3350C1 ::v4(){vfunc_called(this, "_ZN7S3350C12v4Ev");}
void  S3350C1 ::v5(){vfunc_called(this, "_ZN7S3350C12v5Ev");}
S3350C1 ::S3350C1(){ note_ctor("S3350C1", this);} // tgen

static void Test_S3350C1()
{
  extern Class_Descriptor cd_S3350C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(81,121)];
    init_test(&cd_S3350C1, buf);
    S3350C1 *dp, &lv = *(dp=new (buf) S3350C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(640,480), "sizeof(S3350C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3350C1)");
    check_base_class_offset(lv, (S3350C3_nt*)(S3350C2_nt*), 0, "S3350C1");
    check_base_class_offset(lv, (S3350C2_nt*), 0, "S3350C1");
    check_field_offset(lv, s3350c1f0, ABISELECT(568,436), "S3350C1.s3350c1f0");
    check_field_offset(lv, s3350c1f1, ABISELECT(576,440), "S3350C1.s3350c1f1");
    check_field_offset(lv, s3350c1f2, ABISELECT(584,444), "S3350C1.s3350c1f2");
    check_field_offset(lv, s3350c1f3, ABISELECT(592,448), "S3350C1.s3350c1f3");
    check_field_offset(lv, s3350c1f4, ABISELECT(608,460), "S3350C1.s3350c1f4");
    set_bf_and_test(lv, s3350c1f5, ABISELECT(616,464), 0, 1, 1, "S3350C1");
    check_field_offset(lv, s3350c1f6, ABISELECT(624,468), "S3350C1.s3350c1f6");
    test_class_info(&lv, &cd_S3350C1);
    dp->~S3350C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3350C1(Test_S3350C1, "S3350C1", ABISELECT(640,480));

#else // __cplusplus

extern void _ZN7S3350C1C1Ev();
extern void _ZN7S3350C1D1Ev();
Name_Map name_map_S3350C1[] = {
  NSPAIR(_ZN7S3350C1C1Ev),
  NSPAIR(_ZN7S3350C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3350C3_nt;
extern VTBL_ENTRY _ZTI10S3350C3_nt[];
extern  VTBL_ENTRY _ZTV10S3350C3_nt[];
extern Class_Descriptor cd_S3350C2_nt;
extern VTBL_ENTRY _ZTI10S3350C2_nt[];
extern  VTBL_ENTRY _ZTV10S3350C2_nt[];
static Base_Class bases_S3350C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3350C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3350C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3350C1[];
extern void _ZN7S3350C1D1Ev();
extern void _ZN7S3350C1D0Ev();
extern void _ZN10S3350C3_nt2v6Ev();
extern void _ZN10S3350C3_nt2v7Ev();
extern void _ZN10S3350C3_nt2v8Ev();
extern void _ZN10S3350C3_nt2v9Ev();
extern void _ZN10S3350C3_nt3v10Ev();
extern void _ZN10S3350C3_nt3v11Ev();
extern void _ZN10S3350C3_nt3v12Ev();
extern void _ZN10S3350C3_nt3v13Ev();
extern void _ZN10S3350C3_nt3v14Ev();
extern void _ZN10S3350C3_nt3v15Ev();
extern void _ZN10S3350C3_nt3v16Ev();
extern void _ZN10S3350C3_nt3v17Ev();
extern void _ZN10S3350C3_nt3v18Ev();
extern void _ZN10S3350C3_nt3v19Ev();
extern void _ZN10S3350C3_nt3v20Ev();
extern void _ZN10S3350C3_nt3v21Ev();
extern void _ZN10S3350C3_nt3v22Ev();
extern void _ZN10S3350C3_nt3v23Ev();
extern void _ZN10S3350C3_nt3v24Ev();
extern void _ZN10S3350C3_nt3v25Ev();
extern void _ZN10S3350C3_nt3v26Ev();
extern void _ZN10S3350C3_nt3v27Ev();
extern void _ZN10S3350C3_nt3v28Ev();
extern void _ZN10S3350C3_nt3v29Ev();
extern void _ZN10S3350C3_nt3v30Ev();
extern void _ZN10S3350C3_nt3v31Ev();
extern void _ZN10S3350C3_nt3v32Ev();
extern void _ZN10S3350C3_nt3v33Ev();
extern void _ZN10S3350C3_nt3v34Ev();
extern void _ZN10S3350C3_nt3v35Ev();
extern void _ZN10S3350C3_nt3v36Ev();
extern void _ZN10S3350C3_nt3v37Ev();
extern void _ZN10S3350C3_nt3v38Ev();
extern void _ZN10S3350C3_nt3v39Ev();
extern void _ZN10S3350C3_nt3v40Ev();
extern void _ZN10S3350C3_nt3v41Ev();
extern void _ZN10S3350C3_nt3v42Ev();
extern void _ZN10S3350C3_nt3v43Ev();
extern void _ZN10S3350C3_nt3v44Ev();
extern void _ZN10S3350C3_nt3v45Ev();
extern void _ZN10S3350C3_nt3v46Ev();
extern void _ZN10S3350C3_nt3v47Ev();
extern void _ZN10S3350C3_nt3v48Ev();
extern void _ZN10S3350C3_nt3v49Ev();
extern void _ZN10S3350C3_nt3v50Ev();
extern void _ZN10S3350C3_nt3v51Ev();
extern void _ZN10S3350C3_nt3v52Ev();
extern void _ZN10S3350C3_nt3v53Ev();
extern void _ZN10S3350C3_nt3v54Ev();
extern void _ZN10S3350C3_nt3v55Ev();
extern void _ZN10S3350C3_nt3v56Ev();
extern void _ZN10S3350C3_nt3v57Ev();
extern void _ZN10S3350C3_nt3v58Ev();
extern void _ZN10S3350C3_nt3v59Ev();
extern void _ZN10S3350C3_nt3v60Ev();
extern void _ZN10S3350C3_nt3v61Ev();
extern void _ZN10S3350C3_nt3v62Ev();
extern void _ZN10S3350C3_nt3v63Ev();
extern void _ZN10S3350C3_nt3v64Ev();
extern void _ZN10S3350C3_nt3v65Ev();
extern void _ZN10S3350C3_nt3v66Ev();
extern void _ZN10S3350C3_nt3v67Ev();
extern void _ZN10S3350C3_nt3v68Ev();
extern void _ZN10S3350C3_nt3v69Ev();
extern void _ZN10S3350C2_nt3v70Ev();
extern void _ZN10S3350C2_nt3v71Ev();
extern void _ZN10S3350C2_nt3v72Ev();
extern void _ZN10S3350C2_nt3v73Ev();
extern void _ZN10S3350C2_nt3v74Ev();
extern void _ZN10S3350C2_nt3v75Ev();
extern void _ZN10S3350C2_nt3v76Ev();
extern void _ZN10S3350C2_nt3v77Ev();
extern void _ZN10S3350C2_nt3v78Ev();
extern void _ZN10S3350C2_nt3v79Ev();
extern void _ZN10S3350C2_nt3v80Ev();
extern void _ZN10S3350C2_nt3v81Ev();
extern void _ZN10S3350C2_nt3v82Ev();
extern void _ZN10S3350C2_nt3v83Ev();
extern void _ZN10S3350C2_nt3v84Ev();
extern void _ZN10S3350C2_nt3v85Ev();
extern void _ZN10S3350C2_nt3v86Ev();
extern void _ZN10S3350C2_nt3v87Ev();
extern void _ZN10S3350C2_nt3v88Ev();
extern void _ZN10S3350C2_nt3v89Ev();
extern void _ZN10S3350C2_nt3v90Ev();
extern void _ZN10S3350C2_nt3v91Ev();
extern void _ZN10S3350C2_nt3v92Ev();
extern void _ZN10S3350C2_nt3v93Ev();
extern void _ZN10S3350C2_nt3v94Ev();
extern void _ZN10S3350C2_nt3v95Ev();
extern void _ZN10S3350C2_nt3v96Ev();
extern void _ZN10S3350C2_nt3v97Ev();
extern void _ZN10S3350C2_nt3v98Ev();
extern void _ZN10S3350C2_nt3v99Ev();
extern void _ZN10S3350C2_nt4v100Ev();
extern void _ZN10S3350C2_nt4v101Ev();
extern void _ZN10S3350C2_nt4v102Ev();
extern void _ZN10S3350C2_nt4v103Ev();
extern void _ZN10S3350C2_nt4v104Ev();
extern void _ZN10S3350C2_nt4v105Ev();
extern void _ZN10S3350C2_nt4v106Ev();
extern void _ZN10S3350C2_nt4v107Ev();
extern void _ZN10S3350C2_nt4v108Ev();
extern void _ZN10S3350C2_nt4v109Ev();
extern void _ZN10S3350C2_nt4v110Ev();
extern void _ZN10S3350C2_nt4v111Ev();
extern void _ZN10S3350C2_nt4v112Ev();
extern void _ZN10S3350C2_nt4v113Ev();
extern void _ZN10S3350C2_nt4v114Ev();
extern void _ZN10S3350C2_nt4v115Ev();
extern void _ZN10S3350C2_nt4v116Ev();
extern void _ZN10S3350C2_nt4v117Ev();
extern void _ZN10S3350C2_nt4v118Ev();
extern void _ZN10S3350C2_nt4v119Ev();
extern void _ZN10S3350C2_nt4v120Ev();
extern void _ZN10S3350C2_nt4v121Ev();
extern void _ZN10S3350C2_nt4v122Ev();
extern void _ZN10S3350C2_nt4v123Ev();
extern void _ZN10S3350C2_nt4v124Ev();
extern void _ZN10S3350C2_nt4v125Ev();
extern void _ZN10S3350C2_nt4v126Ev();
extern void _ZN10S3350C2_nt4v127Ev();
extern void _ZN10S3350C2_nt4v128Ev();
extern void _ZN10S3350C2_nt4v129Ev();
extern void _ZN10S3350C2_nt4v130Ev();
extern void _ZN10S3350C2_nt4v131Ev();
extern void _ZN10S3350C2_nt4v132Ev();
extern void _ZN10S3350C2_nt4v133Ev();
extern void _ZN10S3350C2_nt4v134Ev();
extern void _ZN10S3350C2_nt4v135Ev();
extern void _ZN10S3350C2_nt4v136Ev();
extern void _ZN10S3350C2_nt4v137Ev();
extern void _ZN10S3350C2_nt4v138Ev();
extern void _ZN10S3350C2_nt4v139Ev();
extern void _ZN10S3350C2_nt4v140Ev();
extern void _ZN10S3350C2_nt4v141Ev();
extern void _ZN10S3350C2_nt4v142Ev();
extern void _ZN10S3350C2_nt4v143Ev();
extern void _ZN10S3350C2_nt4v144Ev();
extern void _ZN10S3350C2_nt4v145Ev();
extern void _ZN10S3350C2_nt4v146Ev();
extern void _ZN10S3350C2_nt4v147Ev();
extern void _ZN10S3350C2_nt4v148Ev();
extern void _ZN10S3350C2_nt4v149Ev();
extern void _ZN10S3350C2_nt4v150Ev();
extern void _ZN10S3350C2_nt4v151Ev();
extern void _ZN10S3350C2_nt4v152Ev();
extern void _ZN10S3350C2_nt4v153Ev();
extern void _ZN10S3350C2_nt4v154Ev();
extern void _ZN10S3350C2_nt4v155Ev();
extern void _ZN10S3350C2_nt4v156Ev();
extern void _ZN10S3350C2_nt4v157Ev();
extern void _ZN10S3350C2_nt4v158Ev();
extern void _ZN10S3350C2_nt4v159Ev();
extern void _ZN10S3350C2_nt4v160Ev();
extern void _ZN10S3350C2_nt4v161Ev();
extern void _ZN10S3350C2_nt4v162Ev();
extern void _ZN10S3350C2_nt4v163Ev();
extern void _ZN10S3350C2_nt4v164Ev();
extern void _ZN10S3350C2_nt4v165Ev();
extern void _ZN10S3350C2_nt4v166Ev();
extern void _ZN10S3350C2_nt4v167Ev();
extern void _ZN10S3350C2_nt4v168Ev();
extern void _ZN10S3350C2_nt4v169Ev();
extern void _ZN10S3350C2_nt4v170Ev();
extern void _ZN10S3350C2_nt4v171Ev();
extern void _ZN10S3350C2_nt4v172Ev();
extern void _ZN10S3350C2_nt4v173Ev();
extern void _ZN10S3350C2_nt4v174Ev();
extern void _ZN10S3350C2_nt4v175Ev();
extern void _ZN10S3350C2_nt4v176Ev();
extern void _ZN10S3350C2_nt4v177Ev();
extern void _ZN10S3350C2_nt4v178Ev();
extern void _ZN10S3350C2_nt4v179Ev();
extern void _ZN10S3350C2_nt4v180Ev();
extern void _ZN10S3350C2_nt4v181Ev();
extern void _ZN10S3350C2_nt4v182Ev();
extern void _ZN10S3350C2_nt4v183Ev();
extern void _ZN10S3350C2_nt4v184Ev();
extern void _ZN10S3350C2_nt4v185Ev();
extern void _ZN10S3350C2_nt4v186Ev();
extern void _ZN10S3350C2_nt4v187Ev();
extern void _ZN10S3350C2_nt4v188Ev();
extern void _ZN10S3350C2_nt4v189Ev();
extern void _ZN10S3350C2_nt4v190Ev();
extern void _ZN10S3350C2_nt4v191Ev();
extern void _ZN10S3350C2_nt4v192Ev();
extern void _ZN10S3350C2_nt4v193Ev();
extern void _ZN10S3350C2_nt4v194Ev();
extern void _ZN10S3350C2_nt4v195Ev();
extern void _ZN10S3350C2_nt4v196Ev();
extern void _ZN10S3350C2_nt4v197Ev();
extern void _ZN10S3350C2_nt4v198Ev();
extern void _ZN10S3350C2_nt4v199Ev();
extern void _ZN10S3350C2_nt4v200Ev();
extern void _ZN10S3350C2_nt4v201Ev();
extern void _ZN10S3350C2_nt4v202Ev();
extern void _ZN10S3350C2_nt4v203Ev();
extern void _ZN10S3350C2_nt4v204Ev();
extern void _ZN10S3350C2_nt4v205Ev();
extern void _ZN10S3350C2_nt4v206Ev();
extern void _ZN10S3350C2_nt4v207Ev();
extern void _ZN10S3350C2_nt4v208Ev();
extern void _ZN10S3350C2_nt4v209Ev();
extern void _ZN10S3350C2_nt4v210Ev();
extern void _ZN10S3350C2_nt4v211Ev();
extern void _ZN10S3350C2_nt4v212Ev();
extern void _ZN7S3350C12v1Ev();
extern void _ZN7S3350C12v2Ev();
extern void _ZN7S3350C12v3Ev();
extern void _ZN7S3350C12v4Ev();
extern void _ZN7S3350C12v5Ev();
static  VTBL_ENTRY vtc_S3350C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3350C1[0]),
  (VTBL_ENTRY)&_ZN7S3350C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3350C1D0Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S3350C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v211Ev,
  (VTBL_ENTRY)&_ZN10S3350C2_nt4v212Ev,
  (VTBL_ENTRY)&_ZN7S3350C12v1Ev,
  (VTBL_ENTRY)&_ZN7S3350C12v2Ev,
  (VTBL_ENTRY)&_ZN7S3350C12v3Ev,
  (VTBL_ENTRY)&_ZN7S3350C12v4Ev,
  (VTBL_ENTRY)&_ZN7S3350C12v5Ev,
};
extern VTBL_ENTRY _ZTI7S3350C1[];
extern  VTBL_ENTRY _ZTV7S3350C1[];
Class_Descriptor cd_S3350C1 = {  "S3350C1", // class name
  bases_S3350C1, 2,
  &(vtc_S3350C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(640,480), // object size
  NSPAIRA(_ZTI7S3350C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3350C1),216, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2121C7_nt  {
  void  mf2121c7(); // _ZN10S2121C7_nt8mf2121c7Ev
};
//SIG(-1 S2121C7_nt) C1{ m}


void  S2121C7_nt ::mf2121c7(){}

//skip512 S2121C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2121C6_nt  {
  void *s2121c6f0;
  int s2121c6f1;
  ::S2121C7_nt s2121c6f2;
  ::S2121C7_nt s2121c6f3;
  void  mf2121c6(); // _ZN10S2121C6_nt8mf2121c6Ev
};
//SIG(-1 S2121C6_nt) C1{ m Fp Fi FC2{ m} FC2}


void  S2121C6_nt ::mf2121c6(){}

//skip512 S2121C6_nt

#else // __cplusplus

Class_Descriptor cd_S2121C6_nt = {  "S2121C6_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2121C5_nt  : S2121C6_nt {
};
//SIG(-1 S2121C5_nt) C1{ BC2{ m Fp Fi FC3{ m} FC3}}



//skip512 S2121C5_nt

#else // __cplusplus

extern Class_Descriptor cd_S2121C6_nt;
static Base_Class bases_S2121C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2121C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2121C4_nt  {
  void *s2121c4f0;
  int s2121c4f1;
  ::S2121C5_nt s2121c4f2;
  ::S2121C5_nt s2121c4f3;
  int s2121c4f4;
  virtual  ~S2121C4_nt(); // _ZN10S2121C4_ntD1Ev
  virtual void  v2(); // _ZN10S2121C4_nt2v2Ev
  virtual void  v3(); // _ZN10S2121C4_nt2v3Ev
  virtual void  v4(); // _ZN10S2121C4_nt2v4Ev
  virtual void  v5(); // _ZN10S2121C4_nt2v5Ev
  virtual void  v6(); // _ZN10S2121C4_nt2v6Ev
  virtual void  v7(); // _ZN10S2121C4_nt2v7Ev
  virtual void  v8(); // _ZN10S2121C4_nt2v8Ev
  virtual void  v9(); // _ZN10S2121C4_nt2v9Ev
  virtual void  v10(); // _ZN10S2121C4_nt3v10Ev
  virtual void  v11(); // _ZN10S2121C4_nt3v11Ev
  virtual void  v12(); // _ZN10S2121C4_nt3v12Ev
  virtual void  v13(); // _ZN10S2121C4_nt3v13Ev
  virtual void  v14(); // _ZN10S2121C4_nt3v14Ev
  virtual void  v15(); // _ZN10S2121C4_nt3v15Ev
  virtual void  v16(); // _ZN10S2121C4_nt3v16Ev
  virtual void  v17(); // _ZN10S2121C4_nt3v17Ev
  virtual void  v18(); // _ZN10S2121C4_nt3v18Ev
  virtual void  v19(); // _ZN10S2121C4_nt3v19Ev
  virtual void  v20(); // _ZN10S2121C4_nt3v20Ev
  virtual void  v21(); // _ZN10S2121C4_nt3v21Ev
  virtual void  v22(); // _ZN10S2121C4_nt3v22Ev
  virtual void  v23(); // _ZN10S2121C4_nt3v23Ev
  virtual void  v24(); // _ZN10S2121C4_nt3v24Ev
  S2121C4_nt(); // tgen
};
//SIG(-1 S2121C4_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC2{ BC3{ m Fp Fi FC4{ m} FC4}} FC2 Fi}


 S2121C4_nt ::~S2121C4_nt(){ note_dtor("S2121C4_nt", this);}
void  S2121C4_nt ::v2(){vfunc_called(this, "_ZN10S2121C4_nt2v2Ev");}
void  S2121C4_nt ::v3(){vfunc_called(this, "_ZN10S2121C4_nt2v3Ev");}
void  S2121C4_nt ::v4(){vfunc_called(this, "_ZN10S2121C4_nt2v4Ev");}
void  S2121C4_nt ::v5(){vfunc_called(this, "_ZN10S2121C4_nt2v5Ev");}
void  S2121C4_nt ::v6(){vfunc_called(this, "_ZN10S2121C4_nt2v6Ev");}
void  S2121C4_nt ::v7(){vfunc_called(this, "_ZN10S2121C4_nt2v7Ev");}
void  S2121C4_nt ::v8(){vfunc_called(this, "_ZN10S2121C4_nt2v8Ev");}
void  S2121C4_nt ::v9(){vfunc_called(this, "_ZN10S2121C4_nt2v9Ev");}
void  S2121C4_nt ::v10(){vfunc_called(this, "_ZN10S2121C4_nt3v10Ev");}
void  S2121C4_nt ::v11(){vfunc_called(this, "_ZN10S2121C4_nt3v11Ev");}
void  S2121C4_nt ::v12(){vfunc_called(this, "_ZN10S2121C4_nt3v12Ev");}
void  S2121C4_nt ::v13(){vfunc_called(this, "_ZN10S2121C4_nt3v13Ev");}
void  S2121C4_nt ::v14(){vfunc_called(this, "_ZN10S2121C4_nt3v14Ev");}
void  S2121C4_nt ::v15(){vfunc_called(this, "_ZN10S2121C4_nt3v15Ev");}
void  S2121C4_nt ::v16(){vfunc_called(this, "_ZN10S2121C4_nt3v16Ev");}
void  S2121C4_nt ::v17(){vfunc_called(this, "_ZN10S2121C4_nt3v17Ev");}
void  S2121C4_nt ::v18(){vfunc_called(this, "_ZN10S2121C4_nt3v18Ev");}
void  S2121C4_nt ::v19(){vfunc_called(this, "_ZN10S2121C4_nt3v19Ev");}
void  S2121C4_nt ::v20(){vfunc_called(this, "_ZN10S2121C4_nt3v20Ev");}
void  S2121C4_nt ::v21(){vfunc_called(this, "_ZN10S2121C4_nt3v21Ev");}
void  S2121C4_nt ::v22(){vfunc_called(this, "_ZN10S2121C4_nt3v22Ev");}
void  S2121C4_nt ::v23(){vfunc_called(this, "_ZN10S2121C4_nt3v23Ev");}
void  S2121C4_nt ::v24(){vfunc_called(this, "_ZN10S2121C4_nt3v24Ev");}
S2121C4_nt ::S2121C4_nt(){ note_ctor("S2121C4_nt", this);} // tgen

//skip512 S2121C4_nt

#else // __cplusplus

extern void _ZN10S2121C4_ntC1Ev();
extern void _ZN10S2121C4_ntD1Ev();
Name_Map name_map_S2121C4_nt[] = {
  NSPAIR(_ZN10S2121C4_ntC1Ev),
  NSPAIR(_ZN10S2121C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S2121C4_nt[];
extern void _ZN10S2121C4_ntD1Ev();
extern void _ZN10S2121C4_ntD0Ev();
extern void _ZN10S2121C4_nt2v2Ev();
extern void _ZN10S2121C4_nt2v3Ev();
extern void _ZN10S2121C4_nt2v4Ev();
extern void _ZN10S2121C4_nt2v5Ev();
extern void _ZN10S2121C4_nt2v6Ev();
extern void _ZN10S2121C4_nt2v7Ev();
extern void _ZN10S2121C4_nt2v8Ev();
extern void _ZN10S2121C4_nt2v9Ev();
extern void _ZN10S2121C4_nt3v10Ev();
extern void _ZN10S2121C4_nt3v11Ev();
extern void _ZN10S2121C4_nt3v12Ev();
extern void _ZN10S2121C4_nt3v13Ev();
extern void _ZN10S2121C4_nt3v14Ev();
extern void _ZN10S2121C4_nt3v15Ev();
extern void _ZN10S2121C4_nt3v16Ev();
extern void _ZN10S2121C4_nt3v17Ev();
extern void _ZN10S2121C4_nt3v18Ev();
extern void _ZN10S2121C4_nt3v19Ev();
extern void _ZN10S2121C4_nt3v20Ev();
extern void _ZN10S2121C4_nt3v21Ev();
extern void _ZN10S2121C4_nt3v22Ev();
extern void _ZN10S2121C4_nt3v23Ev();
extern void _ZN10S2121C4_nt3v24Ev();
static  VTBL_ENTRY vtc_S2121C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2121C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S2121C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v2Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v24Ev,
};
extern VTBL_ENTRY _ZTI10S2121C4_nt[];
VTBL_ENTRY *P__ZTI10S2121C4_nt = _ZTI10S2121C4_nt; 
extern  VTBL_ENTRY _ZTV10S2121C4_nt[];
Class_Descriptor cd_S2121C4_nt = {  "S2121C4_nt", // class name
  0,0,//no base classes
  &(vtc_S2121C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI10S2121C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S2121C4_nt),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2121C14_nt  {
  __tsi64 s2121c14f0[2];
  void  mf2121c14(); // _ZN11S2121C14_nt9mf2121c14Ev
};
//SIG(-1 S2121C14_nt) C1{ m FL[2]}


void  S2121C14_nt ::mf2121c14(){}

//skip512 S2121C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2121C13_nt  {
  ::S2121C14_nt s2121c13f0;
  void  mf2121c13(); // _ZN11S2121C13_nt9mf2121c13Ev
};
//SIG(-1 S2121C13_nt) C1{ m FC2{ m FL[2]}}


void  S2121C13_nt ::mf2121c13(){}

//skip512 S2121C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2121C17_nt  {
  ::S2121C13_nt s2121c17f0;
  void  mf2121c17(); // _ZN11S2121C17_nt9mf2121c17Ev
};
//SIG(-1 S2121C17_nt) C1{ m FC2{ m FC3{ m FL[2]}}}


void  S2121C17_nt ::mf2121c17(){}

//skip512 S2121C17_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2121C18_nt  {
  ::S2121C13_nt s2121c18f0;
  ::S2121C13_nt s2121c18f1;
  ::S2121C13_nt s2121c18f2;
  ::S2121C13_nt s2121c18f3;
  void  mf2121c18(); // _ZN11S2121C18_nt9mf2121c18Ev
};
//SIG(-1 S2121C18_nt) C1{ m FC2{ m FC3{ m FL[2]}} FC2 FC2 FC2}


void  S2121C18_nt ::mf2121c18(){}

//skip512 S2121C18_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2121C21  {
  void  mf2121c21(); // _ZN8S2121C219mf2121c21Ev
};
//SIG(-1 S2121C21) C1{ m}


void  S2121C21 ::mf2121c21(){}

static void Test_S2121C21()
{
  {
    init_simple_test("S2121C21");
    S2121C21 lv;
    check2(sizeof(lv), 1, "sizeof(S2121C21)");
    check2(__alignof__(lv), 1, "__alignof__(S2121C21)");
  }
}
static Arrange_To_Call_Me vS2121C21(Test_S2121C21, "S2121C21", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S2121C21[];
VTBL_ENTRY *P__ZTI8S2121C21 = _ZTI8S2121C21; 
Class_Descriptor cd_S2121C21 = {  "S2121C21", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S2121C21),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2121C20_nt  {
  void *s2121c20f0;
  int s2121c20f1;
  ::S2121C21 s2121c20f2;
  void  mf2121c20(); // _ZN11S2121C20_nt9mf2121c20Ev
};
//SIG(-1 S2121C20_nt) C1{ m Fp Fi FC2{ m}}


void  S2121C20_nt ::mf2121c20(){}

//skip512 S2121C20_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2121C19_nt  {
  ::S2121C20_nt s2121c19f0;
  int s2121c19f1;
  void  mf2121c19(); // _ZN11S2121C19_nt9mf2121c19Ev
};
//SIG(-1 S2121C19_nt) C1{ m FC2{ m Fp Fi FC3{ m}} Fi}


void  S2121C19_nt ::mf2121c19(){}

//skip512 S2121C19_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2121C24  {
  void  mf2121c24(); // _ZN8S2121C249mf2121c24Ev
};
//SIG(-1 S2121C24) C1{ m}


void  S2121C24 ::mf2121c24(){}

static void Test_S2121C24()
{
  {
    init_simple_test("S2121C24");
    S2121C24 lv;
    check2(sizeof(lv), 1, "sizeof(S2121C24)");
    check2(__alignof__(lv), 1, "__alignof__(S2121C24)");
  }
}
static Arrange_To_Call_Me vS2121C24(Test_S2121C24, "S2121C24", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S2121C24[];
VTBL_ENTRY *P__ZTI8S2121C24 = _ZTI8S2121C24; 
Class_Descriptor cd_S2121C24 = {  "S2121C24", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S2121C24),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2121C22  {
  void *s2121c22f0;
  int s2121c22f1;
  ::S2121C21 s2121c22f2;
  ::S2121C24 s2121c22f3;
  void  mf2121c22(); // _ZN8S2121C229mf2121c22Ev
};
//SIG(-1 S2121C22) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S2121C22 ::mf2121c22(){}

static void Test_S2121C22()
{
  {
    init_simple_test("S2121C22");
    S2121C22 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2121C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2121C22)");
    check_field_offset(lv, s2121c22f0, 0, "S2121C22.s2121c22f0");
    check_field_offset(lv, s2121c22f1, ABISELECT(8,4), "S2121C22.s2121c22f1");
    check_field_offset(lv, s2121c22f2, ABISELECT(12,8), "S2121C22.s2121c22f2");
    check_field_offset(lv, s2121c22f3, ABISELECT(13,9), "S2121C22.s2121c22f3");
  }
}
static Arrange_To_Call_Me vS2121C22(Test_S2121C22, "S2121C22", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2121C28  {
  void  mf2121c28(); // _ZN8S2121C289mf2121c28Ev
};
//SIG(-1 S2121C28) C1{ m}


void  S2121C28 ::mf2121c28(){}

static void Test_S2121C28()
{
  {
    init_simple_test("S2121C28");
    S2121C28 lv;
    check2(sizeof(lv), 1, "sizeof(S2121C28)");
    check2(__alignof__(lv), 1, "__alignof__(S2121C28)");
  }
}
static Arrange_To_Call_Me vS2121C28(Test_S2121C28, "S2121C28", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S2121C28[];
VTBL_ENTRY *P__ZTI8S2121C28 = _ZTI8S2121C28; 
Class_Descriptor cd_S2121C28 = {  "S2121C28", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S2121C28),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2121C26  {
  void *s2121c26f0;
  int s2121c26f1;
  ::S2121C24 s2121c26f2;
  ::S2121C28 s2121c26f3;
  void  mf2121c26(); // _ZN8S2121C269mf2121c26Ev
};
//SIG(-1 S2121C26) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S2121C26 ::mf2121c26(){}

static void Test_S2121C26()
{
  {
    init_simple_test("S2121C26");
    S2121C26 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2121C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2121C26)");
    check_field_offset(lv, s2121c26f0, 0, "S2121C26.s2121c26f0");
    check_field_offset(lv, s2121c26f1, ABISELECT(8,4), "S2121C26.s2121c26f1");
    check_field_offset(lv, s2121c26f2, ABISELECT(12,8), "S2121C26.s2121c26f2");
    check_field_offset(lv, s2121c26f3, ABISELECT(13,9), "S2121C26.s2121c26f3");
  }
}
static Arrange_To_Call_Me vS2121C26(Test_S2121C26, "S2121C26", ABISELECT(16,12));

#else // __cplusplus

Class_Descriptor cd_S2121C26 = {  "S2121C26", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2121C25  : S2121C26 {
};
//SIG(-1 S2121C25) C1{ BC2{ m Fp Fi FC3{ m} FC4{ m}}}



static void Test_S2121C25()
{
  extern Class_Descriptor cd_S2121C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S2121C25, buf);
    S2121C25 &lv = *(new (buf) S2121C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2121C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2121C25)");
    check_base_class_offset(lv, (S2121C26*), 0, "S2121C25");
    test_class_info(&lv, &cd_S2121C25);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2121C25(Test_S2121C25, "S2121C25", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S2121C26;
static Base_Class bases_S2121C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2121C26,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S2121C25 = {  "S2121C25", // class name
  bases_S2121C25, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2121C29_nt  {
  void *s2121c29f0;
  int s2121c29f1[2];
  ::S2121C28 s2121c29f2;
  void  mf2121c29(); // _ZN11S2121C29_nt9mf2121c29Ev
};
//SIG(-1 S2121C29_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S2121C29_nt ::mf2121c29(){}

//skip512 S2121C29_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2121C38  {
  void  mf2121c38(); // _ZN8S2121C389mf2121c38Ev
};
//SIG(-1 S2121C38) C1{ m}


void  S2121C38 ::mf2121c38(){}

static void Test_S2121C38()
{
  {
    init_simple_test("S2121C38");
    S2121C38 lv;
    check2(sizeof(lv), 1, "sizeof(S2121C38)");
    check2(__alignof__(lv), 1, "__alignof__(S2121C38)");
  }
}
static Arrange_To_Call_Me vS2121C38(Test_S2121C38, "S2121C38", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S2121C38[];
VTBL_ENTRY *P__ZTI8S2121C38 = _ZTI8S2121C38; 
Class_Descriptor cd_S2121C38 = {  "S2121C38", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S2121C38),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2121C37  {
  void *s2121c37f0;
  int s2121c37f1[2];
  ::S2121C38 s2121c37f2;
  void  mf2121c37(); // _ZN8S2121C379mf2121c37Ev
};
//SIG(-1 S2121C37) C1{ m Fp Fi[2] FC2{ m}}


void  S2121C37 ::mf2121c37(){}

static void Test_S2121C37()
{
  {
    init_simple_test("S2121C37");
    S2121C37 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S2121C37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2121C37)");
    check_field_offset(lv, s2121c37f0, 0, "S2121C37.s2121c37f0");
    check_field_offset(lv, s2121c37f1, ABISELECT(8,4), "S2121C37.s2121c37f1");
    check_field_offset(lv, s2121c37f2, ABISELECT(16,12), "S2121C37.s2121c37f2");
  }
}
static Arrange_To_Call_Me vS2121C37(Test_S2121C37, "S2121C37", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2121C3_nt  : S2121C4_nt {
  ::S2121C13_nt s2121c3f0;
  ::S2121C13_nt s2121c3f1;
  ::S2121C13_nt s2121c3f2;
  ::S2121C13_nt s2121c3f3;
  ::S2121C17_nt s2121c3f4;
  ::S2121C18_nt s2121c3f5;
  ::S2121C18_nt s2121c3f6;
  ::S2121C13_nt s2121c3f7;
  ::S2121C13_nt s2121c3f8;
  ::S2121C13_nt s2121c3f9;
  void *s2121c3f10;
  ::S2121C17_nt s2121c3f11;
  ::S2121C19_nt s2121c3f12;
  int s2121c3f13;
  void *s2121c3f14[7];
  ::S2121C22 s2121c3f15;
  int s2121c3f16:8;
  int s2121c3f17:8;
  int s2121c3f18:16;
  int s2121c3f19:16;
  int s2121c3f20:8;
  int s2121c3f21:8;
  int s2121c3f22:8;
  int s2121c3f23:32;
  int s2121c3f24:8;
  int s2121c3f25:4;
  int s2121c3f26:4;
  int s2121c3f27:4;
  int s2121c3f28:4;
  int s2121c3f29:4;
  int s2121c3f30:4;
  int s2121c3f31:4;
  int s2121c3f32:4;
  int s2121c3f33:4;
  int s2121c3f34:4;
  unsigned char s2121c3f35:1;
  unsigned char s2121c3f36:1;
  unsigned char s2121c3f37:1;
  unsigned char s2121c3f38:1;
  unsigned char s2121c3f39:1;
  unsigned char s2121c3f40:1;
  unsigned char s2121c3f41:1;
  unsigned char s2121c3f42:1;
  unsigned char s2121c3f43:1;
  unsigned char s2121c3f44:1;
  unsigned char s2121c3f45:1;
  unsigned char s2121c3f46:1;
  unsigned char s2121c3f47:1;
  unsigned char s2121c3f48:1;
  unsigned char s2121c3f49:1;
  unsigned char s2121c3f50:1;
  unsigned char s2121c3f51:1;
  unsigned char s2121c3f52:1;
  unsigned char s2121c3f53:1;
  unsigned char s2121c3f54:1;
  unsigned char s2121c3f55:1;
  unsigned char s2121c3f56:1;
  unsigned char s2121c3f57:1;
  unsigned char s2121c3f58:1;
  unsigned char s2121c3f59:1;
  unsigned char s2121c3f60:1;
  unsigned char s2121c3f61:1;
  unsigned char s2121c3f62:1;
  unsigned char s2121c3f63:1;
  unsigned char s2121c3f64:1;
  unsigned char s2121c3f65:1;
  unsigned char s2121c3f66:1;
  unsigned char s2121c3f67:1;
  unsigned char s2121c3f68:1;
  unsigned char s2121c3f69:1;
  unsigned char s2121c3f70:1;
  unsigned char s2121c3f71:1;
  unsigned char s2121c3f72:1;
  unsigned char s2121c3f73:1;
  unsigned char s2121c3f74:1;
  unsigned char s2121c3f75:1;
  int s2121c3f76[7];
  void *s2121c3f77[6];
  int s2121c3f78:8;
  int s2121c3f79:8;
  int s2121c3f80:8;
  int s2121c3f81:8;
  int s2121c3f82:8;
  int s2121c3f83:8;
  ::S2121C25 s2121c3f84;
  void *s2121c3f85[4];
  int s2121c3f86:8;
  int s2121c3f87:8;
  int s2121c3f88:8;
  int s2121c3f89:8;
  int s2121c3f90:8;
  int s2121c3f91:16;
  int s2121c3f92:16;
  int s2121c3f93:16;
  int s2121c3f94:4;
  int s2121c3f95:4;
  int s2121c3f96:4;
  int s2121c3f97:4;
  int s2121c3f98:4;
  int s2121c3f99:4;
  int s2121c3f100:4;
  int s2121c3f101:4;
  int s2121c3f102:4;
  int s2121c3f103:4;
  int s2121c3f104:4;
  int s2121c3f105:4;
  int s2121c3f106:8;
  int s2121c3f107:8;
  int s2121c3f108:8;
  void *s2121c3f109[7];
  ::S2121C29_nt s2121c3f110;
  void *s2121c3f111[2];
  int s2121c3f112:16;
  int s2121c3f113:16;
  ::S2121C25 s2121c3f114;
  ::S2121C29_nt s2121c3f115;
  ::S2121C37 s2121c3f116;
  void *s2121c3f117[2];
  int s2121c3f118:24;
  int s2121c3f119:8;
  void *s2121c3f120;
  virtual  ~S2121C3_nt(); // _ZN10S2121C3_ntD1Ev
  virtual void  v25(); // _ZN10S2121C3_nt3v25Ev
  virtual void  v26(); // _ZN10S2121C3_nt3v26Ev
  virtual void  v27(); // _ZN10S2121C3_nt3v27Ev
  virtual void  v28(); // _ZN10S2121C3_nt3v28Ev
  virtual void  v29(); // _ZN10S2121C3_nt3v29Ev
  virtual void  v30(); // _ZN10S2121C3_nt3v30Ev
  virtual void  v31(); // _ZN10S2121C3_nt3v31Ev
  virtual void  v32(); // _ZN10S2121C3_nt3v32Ev
  virtual void  v33(); // _ZN10S2121C3_nt3v33Ev
  virtual void  v34(); // _ZN10S2121C3_nt3v34Ev
  virtual void  v35(); // _ZN10S2121C3_nt3v35Ev
  virtual void  v36(); // _ZN10S2121C3_nt3v36Ev
  virtual void  v37(); // _ZN10S2121C3_nt3v37Ev
  virtual void  v38(); // _ZN10S2121C3_nt3v38Ev
  virtual void  v39(); // _ZN10S2121C3_nt3v39Ev
  virtual void  v40(); // _ZN10S2121C3_nt3v40Ev
  virtual void  v41(); // _ZN10S2121C3_nt3v41Ev
  virtual void  v42(); // _ZN10S2121C3_nt3v42Ev
  virtual void  v43(); // _ZN10S2121C3_nt3v43Ev
  virtual void  v44(); // _ZN10S2121C3_nt3v44Ev
  virtual void  v45(); // _ZN10S2121C3_nt3v45Ev
  virtual void  v46(); // _ZN10S2121C3_nt3v46Ev
  virtual void  v47(); // _ZN10S2121C3_nt3v47Ev
  virtual void  v48(); // _ZN10S2121C3_nt3v48Ev
  virtual void  v49(); // _ZN10S2121C3_nt3v49Ev
  virtual void  v50(); // _ZN10S2121C3_nt3v50Ev
  virtual void  v51(); // _ZN10S2121C3_nt3v51Ev
  virtual void  v52(); // _ZN10S2121C3_nt3v52Ev
  virtual void  v53(); // _ZN10S2121C3_nt3v53Ev
  virtual void  v54(); // _ZN10S2121C3_nt3v54Ev
  virtual void  v55(); // _ZN10S2121C3_nt3v55Ev
  virtual void  v56(); // _ZN10S2121C3_nt3v56Ev
  virtual void  v57(); // _ZN10S2121C3_nt3v57Ev
  virtual void  v58(); // _ZN10S2121C3_nt3v58Ev
  virtual void  v59(); // _ZN10S2121C3_nt3v59Ev
  virtual void  v60(); // _ZN10S2121C3_nt3v60Ev
  virtual void  v61(); // _ZN10S2121C3_nt3v61Ev
  virtual void  v62(); // _ZN10S2121C3_nt3v62Ev
  virtual void  v63(); // _ZN10S2121C3_nt3v63Ev
  virtual void  v64(); // _ZN10S2121C3_nt3v64Ev
  virtual void  v65(); // _ZN10S2121C3_nt3v65Ev
  virtual void  v66(); // _ZN10S2121C3_nt3v66Ev
  virtual void  v67(); // _ZN10S2121C3_nt3v67Ev
  virtual void  v68(); // _ZN10S2121C3_nt3v68Ev
  virtual void  v69(); // _ZN10S2121C3_nt3v69Ev
  virtual void  v70(); // _ZN10S2121C3_nt3v70Ev
  virtual void  v71(); // _ZN10S2121C3_nt3v71Ev
  virtual void  v72(); // _ZN10S2121C3_nt3v72Ev
  virtual void  v73(); // _ZN10S2121C3_nt3v73Ev
  virtual void  v74(); // _ZN10S2121C3_nt3v74Ev
  virtual void  v75(); // _ZN10S2121C3_nt3v75Ev
  virtual void  v76(); // _ZN10S2121C3_nt3v76Ev
  virtual void  v77(); // _ZN10S2121C3_nt3v77Ev
  virtual void  v78(); // _ZN10S2121C3_nt3v78Ev
  virtual void  v79(); // _ZN10S2121C3_nt3v79Ev
  virtual void  v80(); // _ZN10S2121C3_nt3v80Ev
  virtual void  v81(); // _ZN10S2121C3_nt3v81Ev
  virtual void  v82(); // _ZN10S2121C3_nt3v82Ev
  virtual void  v83(); // _ZN10S2121C3_nt3v83Ev
  virtual void  v84(); // _ZN10S2121C3_nt3v84Ev
  virtual void  v85(); // _ZN10S2121C3_nt3v85Ev
  virtual void  v86(); // _ZN10S2121C3_nt3v86Ev
  virtual void  v87(); // _ZN10S2121C3_nt3v87Ev
  virtual void  v88(); // _ZN10S2121C3_nt3v88Ev
  virtual void  v89(); // _ZN10S2121C3_nt3v89Ev
  virtual void  v90(); // _ZN10S2121C3_nt3v90Ev
  virtual void  v91(); // _ZN10S2121C3_nt3v91Ev
  virtual void  v92(); // _ZN10S2121C3_nt3v92Ev
  virtual void  v93(); // _ZN10S2121C3_nt3v93Ev
  virtual void  v94(); // _ZN10S2121C3_nt3v94Ev
  virtual void  v95(); // _ZN10S2121C3_nt3v95Ev
  virtual void  v96(); // _ZN10S2121C3_nt3v96Ev
  virtual void  v97(); // _ZN10S2121C3_nt3v97Ev
  virtual void  v98(); // _ZN10S2121C3_nt3v98Ev
  virtual void  v99(); // _ZN10S2121C3_nt3v99Ev
  virtual void  v100(); // _ZN10S2121C3_nt4v100Ev
  virtual void  v101(); // _ZN10S2121C3_nt4v101Ev
  virtual void  v102(); // _ZN10S2121C3_nt4v102Ev
  S2121C3_nt(); // tgen
};
//SIG(-1 S2121C3_nt) C1{ BC2{ vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fp Fi FC3{ BC4{ m Fp Fi FC5{ m} FC5}} FC3 Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 FC6{ m FC7{ m FL[2]}} FC6 FC6 FC6 FC8{ m FC6} FC9{ m FC6 FC6 FC6 FC6} FC9 FC6 FC6 FC6 Fp FC8 FC10{ m FC11{ m Fp Fi FC12{ m}} Fi} Fi Fp[7] FC13{ m Fp Fi FC12 FC14{ m}} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC15{ BC16{ m Fp Fi FC14 FC17{ m}}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC18{ m Fp Fi[2] FC17} Fp[2] Fi:16 Fi:16 FC15 FC18 FC19{ m Fp Fi[2] FC20{ m}} Fp[2] Fi:24 Fi:8 Fp}


 S2121C3_nt ::~S2121C3_nt(){ note_dtor("S2121C3_nt", this);}
void  S2121C3_nt ::v25(){vfunc_called(this, "_ZN10S2121C3_nt3v25Ev");}
void  S2121C3_nt ::v26(){vfunc_called(this, "_ZN10S2121C3_nt3v26Ev");}
void  S2121C3_nt ::v27(){vfunc_called(this, "_ZN10S2121C3_nt3v27Ev");}
void  S2121C3_nt ::v28(){vfunc_called(this, "_ZN10S2121C3_nt3v28Ev");}
void  S2121C3_nt ::v29(){vfunc_called(this, "_ZN10S2121C3_nt3v29Ev");}
void  S2121C3_nt ::v30(){vfunc_called(this, "_ZN10S2121C3_nt3v30Ev");}
void  S2121C3_nt ::v31(){vfunc_called(this, "_ZN10S2121C3_nt3v31Ev");}
void  S2121C3_nt ::v32(){vfunc_called(this, "_ZN10S2121C3_nt3v32Ev");}
void  S2121C3_nt ::v33(){vfunc_called(this, "_ZN10S2121C3_nt3v33Ev");}
void  S2121C3_nt ::v34(){vfunc_called(this, "_ZN10S2121C3_nt3v34Ev");}
void  S2121C3_nt ::v35(){vfunc_called(this, "_ZN10S2121C3_nt3v35Ev");}
void  S2121C3_nt ::v36(){vfunc_called(this, "_ZN10S2121C3_nt3v36Ev");}
void  S2121C3_nt ::v37(){vfunc_called(this, "_ZN10S2121C3_nt3v37Ev");}
void  S2121C3_nt ::v38(){vfunc_called(this, "_ZN10S2121C3_nt3v38Ev");}
void  S2121C3_nt ::v39(){vfunc_called(this, "_ZN10S2121C3_nt3v39Ev");}
void  S2121C3_nt ::v40(){vfunc_called(this, "_ZN10S2121C3_nt3v40Ev");}
void  S2121C3_nt ::v41(){vfunc_called(this, "_ZN10S2121C3_nt3v41Ev");}
void  S2121C3_nt ::v42(){vfunc_called(this, "_ZN10S2121C3_nt3v42Ev");}
void  S2121C3_nt ::v43(){vfunc_called(this, "_ZN10S2121C3_nt3v43Ev");}
void  S2121C3_nt ::v44(){vfunc_called(this, "_ZN10S2121C3_nt3v44Ev");}
void  S2121C3_nt ::v45(){vfunc_called(this, "_ZN10S2121C3_nt3v45Ev");}
void  S2121C3_nt ::v46(){vfunc_called(this, "_ZN10S2121C3_nt3v46Ev");}
void  S2121C3_nt ::v47(){vfunc_called(this, "_ZN10S2121C3_nt3v47Ev");}
void  S2121C3_nt ::v48(){vfunc_called(this, "_ZN10S2121C3_nt3v48Ev");}
void  S2121C3_nt ::v49(){vfunc_called(this, "_ZN10S2121C3_nt3v49Ev");}
void  S2121C3_nt ::v50(){vfunc_called(this, "_ZN10S2121C3_nt3v50Ev");}
void  S2121C3_nt ::v51(){vfunc_called(this, "_ZN10S2121C3_nt3v51Ev");}
void  S2121C3_nt ::v52(){vfunc_called(this, "_ZN10S2121C3_nt3v52Ev");}
void  S2121C3_nt ::v53(){vfunc_called(this, "_ZN10S2121C3_nt3v53Ev");}
void  S2121C3_nt ::v54(){vfunc_called(this, "_ZN10S2121C3_nt3v54Ev");}
void  S2121C3_nt ::v55(){vfunc_called(this, "_ZN10S2121C3_nt3v55Ev");}
void  S2121C3_nt ::v56(){vfunc_called(this, "_ZN10S2121C3_nt3v56Ev");}
void  S2121C3_nt ::v57(){vfunc_called(this, "_ZN10S2121C3_nt3v57Ev");}
void  S2121C3_nt ::v58(){vfunc_called(this, "_ZN10S2121C3_nt3v58Ev");}
void  S2121C3_nt ::v59(){vfunc_called(this, "_ZN10S2121C3_nt3v59Ev");}
void  S2121C3_nt ::v60(){vfunc_called(this, "_ZN10S2121C3_nt3v60Ev");}
void  S2121C3_nt ::v61(){vfunc_called(this, "_ZN10S2121C3_nt3v61Ev");}
void  S2121C3_nt ::v62(){vfunc_called(this, "_ZN10S2121C3_nt3v62Ev");}
void  S2121C3_nt ::v63(){vfunc_called(this, "_ZN10S2121C3_nt3v63Ev");}
void  S2121C3_nt ::v64(){vfunc_called(this, "_ZN10S2121C3_nt3v64Ev");}
void  S2121C3_nt ::v65(){vfunc_called(this, "_ZN10S2121C3_nt3v65Ev");}
void  S2121C3_nt ::v66(){vfunc_called(this, "_ZN10S2121C3_nt3v66Ev");}
void  S2121C3_nt ::v67(){vfunc_called(this, "_ZN10S2121C3_nt3v67Ev");}
void  S2121C3_nt ::v68(){vfunc_called(this, "_ZN10S2121C3_nt3v68Ev");}
void  S2121C3_nt ::v69(){vfunc_called(this, "_ZN10S2121C3_nt3v69Ev");}
void  S2121C3_nt ::v70(){vfunc_called(this, "_ZN10S2121C3_nt3v70Ev");}
void  S2121C3_nt ::v71(){vfunc_called(this, "_ZN10S2121C3_nt3v71Ev");}
void  S2121C3_nt ::v72(){vfunc_called(this, "_ZN10S2121C3_nt3v72Ev");}
void  S2121C3_nt ::v73(){vfunc_called(this, "_ZN10S2121C3_nt3v73Ev");}
void  S2121C3_nt ::v74(){vfunc_called(this, "_ZN10S2121C3_nt3v74Ev");}
void  S2121C3_nt ::v75(){vfunc_called(this, "_ZN10S2121C3_nt3v75Ev");}
void  S2121C3_nt ::v76(){vfunc_called(this, "_ZN10S2121C3_nt3v76Ev");}
void  S2121C3_nt ::v77(){vfunc_called(this, "_ZN10S2121C3_nt3v77Ev");}
void  S2121C3_nt ::v78(){vfunc_called(this, "_ZN10S2121C3_nt3v78Ev");}
void  S2121C3_nt ::v79(){vfunc_called(this, "_ZN10S2121C3_nt3v79Ev");}
void  S2121C3_nt ::v80(){vfunc_called(this, "_ZN10S2121C3_nt3v80Ev");}
void  S2121C3_nt ::v81(){vfunc_called(this, "_ZN10S2121C3_nt3v81Ev");}
void  S2121C3_nt ::v82(){vfunc_called(this, "_ZN10S2121C3_nt3v82Ev");}
void  S2121C3_nt ::v83(){vfunc_called(this, "_ZN10S2121C3_nt3v83Ev");}
void  S2121C3_nt ::v84(){vfunc_called(this, "_ZN10S2121C3_nt3v84Ev");}
void  S2121C3_nt ::v85(){vfunc_called(this, "_ZN10S2121C3_nt3v85Ev");}
void  S2121C3_nt ::v86(){vfunc_called(this, "_ZN10S2121C3_nt3v86Ev");}
void  S2121C3_nt ::v87(){vfunc_called(this, "_ZN10S2121C3_nt3v87Ev");}
void  S2121C3_nt ::v88(){vfunc_called(this, "_ZN10S2121C3_nt3v88Ev");}
void  S2121C3_nt ::v89(){vfunc_called(this, "_ZN10S2121C3_nt3v89Ev");}
void  S2121C3_nt ::v90(){vfunc_called(this, "_ZN10S2121C3_nt3v90Ev");}
void  S2121C3_nt ::v91(){vfunc_called(this, "_ZN10S2121C3_nt3v91Ev");}
void  S2121C3_nt ::v92(){vfunc_called(this, "_ZN10S2121C3_nt3v92Ev");}
void  S2121C3_nt ::v93(){vfunc_called(this, "_ZN10S2121C3_nt3v93Ev");}
void  S2121C3_nt ::v94(){vfunc_called(this, "_ZN10S2121C3_nt3v94Ev");}
void  S2121C3_nt ::v95(){vfunc_called(this, "_ZN10S2121C3_nt3v95Ev");}
void  S2121C3_nt ::v96(){vfunc_called(this, "_ZN10S2121C3_nt3v96Ev");}
void  S2121C3_nt ::v97(){vfunc_called(this, "_ZN10S2121C3_nt3v97Ev");}
void  S2121C3_nt ::v98(){vfunc_called(this, "_ZN10S2121C3_nt3v98Ev");}
void  S2121C3_nt ::v99(){vfunc_called(this, "_ZN10S2121C3_nt3v99Ev");}
void  S2121C3_nt ::v100(){vfunc_called(this, "_ZN10S2121C3_nt4v100Ev");}
void  S2121C3_nt ::v101(){vfunc_called(this, "_ZN10S2121C3_nt4v101Ev");}
void  S2121C3_nt ::v102(){vfunc_called(this, "_ZN10S2121C3_nt4v102Ev");}
S2121C3_nt ::S2121C3_nt(){ note_ctor("S2121C3_nt", this);} // tgen

//skip512 S2121C3_nt

#else // __cplusplus

extern void _ZN10S2121C3_ntC1Ev();
extern void _ZN10S2121C3_ntD1Ev();
Name_Map name_map_S2121C3_nt[] = {
  NSPAIR(_ZN10S2121C3_ntC1Ev),
  NSPAIR(_ZN10S2121C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2121C4_nt;
extern VTBL_ENTRY _ZTI10S2121C4_nt[];
extern  VTBL_ENTRY _ZTV10S2121C4_nt[];
static Base_Class bases_S2121C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2121C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S2121C3_nt[];
extern void _ZN10S2121C3_ntD1Ev();
extern void _ZN10S2121C3_ntD0Ev();
extern void _ZN10S2121C4_nt2v2Ev();
extern void _ZN10S2121C4_nt2v3Ev();
extern void _ZN10S2121C4_nt2v4Ev();
extern void _ZN10S2121C4_nt2v5Ev();
extern void _ZN10S2121C4_nt2v6Ev();
extern void _ZN10S2121C4_nt2v7Ev();
extern void _ZN10S2121C4_nt2v8Ev();
extern void _ZN10S2121C4_nt2v9Ev();
extern void _ZN10S2121C4_nt3v10Ev();
extern void _ZN10S2121C4_nt3v11Ev();
extern void _ZN10S2121C4_nt3v12Ev();
extern void _ZN10S2121C4_nt3v13Ev();
extern void _ZN10S2121C4_nt3v14Ev();
extern void _ZN10S2121C4_nt3v15Ev();
extern void _ZN10S2121C4_nt3v16Ev();
extern void _ZN10S2121C4_nt3v17Ev();
extern void _ZN10S2121C4_nt3v18Ev();
extern void _ZN10S2121C4_nt3v19Ev();
extern void _ZN10S2121C4_nt3v20Ev();
extern void _ZN10S2121C4_nt3v21Ev();
extern void _ZN10S2121C4_nt3v22Ev();
extern void _ZN10S2121C4_nt3v23Ev();
extern void _ZN10S2121C4_nt3v24Ev();
extern void _ZN10S2121C3_nt3v25Ev();
extern void _ZN10S2121C3_nt3v26Ev();
extern void _ZN10S2121C3_nt3v27Ev();
extern void _ZN10S2121C3_nt3v28Ev();
extern void _ZN10S2121C3_nt3v29Ev();
extern void _ZN10S2121C3_nt3v30Ev();
extern void _ZN10S2121C3_nt3v31Ev();
extern void _ZN10S2121C3_nt3v32Ev();
extern void _ZN10S2121C3_nt3v33Ev();
extern void _ZN10S2121C3_nt3v34Ev();
extern void _ZN10S2121C3_nt3v35Ev();
extern void _ZN10S2121C3_nt3v36Ev();
extern void _ZN10S2121C3_nt3v37Ev();
extern void _ZN10S2121C3_nt3v38Ev();
extern void _ZN10S2121C3_nt3v39Ev();
extern void _ZN10S2121C3_nt3v40Ev();
extern void _ZN10S2121C3_nt3v41Ev();
extern void _ZN10S2121C3_nt3v42Ev();
extern void _ZN10S2121C3_nt3v43Ev();
extern void _ZN10S2121C3_nt3v44Ev();
extern void _ZN10S2121C3_nt3v45Ev();
extern void _ZN10S2121C3_nt3v46Ev();
extern void _ZN10S2121C3_nt3v47Ev();
extern void _ZN10S2121C3_nt3v48Ev();
extern void _ZN10S2121C3_nt3v49Ev();
extern void _ZN10S2121C3_nt3v50Ev();
extern void _ZN10S2121C3_nt3v51Ev();
extern void _ZN10S2121C3_nt3v52Ev();
extern void _ZN10S2121C3_nt3v53Ev();
extern void _ZN10S2121C3_nt3v54Ev();
extern void _ZN10S2121C3_nt3v55Ev();
extern void _ZN10S2121C3_nt3v56Ev();
extern void _ZN10S2121C3_nt3v57Ev();
extern void _ZN10S2121C3_nt3v58Ev();
extern void _ZN10S2121C3_nt3v59Ev();
extern void _ZN10S2121C3_nt3v60Ev();
extern void _ZN10S2121C3_nt3v61Ev();
extern void _ZN10S2121C3_nt3v62Ev();
extern void _ZN10S2121C3_nt3v63Ev();
extern void _ZN10S2121C3_nt3v64Ev();
extern void _ZN10S2121C3_nt3v65Ev();
extern void _ZN10S2121C3_nt3v66Ev();
extern void _ZN10S2121C3_nt3v67Ev();
extern void _ZN10S2121C3_nt3v68Ev();
extern void _ZN10S2121C3_nt3v69Ev();
extern void _ZN10S2121C3_nt3v70Ev();
extern void _ZN10S2121C3_nt3v71Ev();
extern void _ZN10S2121C3_nt3v72Ev();
extern void _ZN10S2121C3_nt3v73Ev();
extern void _ZN10S2121C3_nt3v74Ev();
extern void _ZN10S2121C3_nt3v75Ev();
extern void _ZN10S2121C3_nt3v76Ev();
extern void _ZN10S2121C3_nt3v77Ev();
extern void _ZN10S2121C3_nt3v78Ev();
extern void _ZN10S2121C3_nt3v79Ev();
extern void _ZN10S2121C3_nt3v80Ev();
extern void _ZN10S2121C3_nt3v81Ev();
extern void _ZN10S2121C3_nt3v82Ev();
extern void _ZN10S2121C3_nt3v83Ev();
extern void _ZN10S2121C3_nt3v84Ev();
extern void _ZN10S2121C3_nt3v85Ev();
extern void _ZN10S2121C3_nt3v86Ev();
extern void _ZN10S2121C3_nt3v87Ev();
extern void _ZN10S2121C3_nt3v88Ev();
extern void _ZN10S2121C3_nt3v89Ev();
extern void _ZN10S2121C3_nt3v90Ev();
extern void _ZN10S2121C3_nt3v91Ev();
extern void _ZN10S2121C3_nt3v92Ev();
extern void _ZN10S2121C3_nt3v93Ev();
extern void _ZN10S2121C3_nt3v94Ev();
extern void _ZN10S2121C3_nt3v95Ev();
extern void _ZN10S2121C3_nt3v96Ev();
extern void _ZN10S2121C3_nt3v97Ev();
extern void _ZN10S2121C3_nt3v98Ev();
extern void _ZN10S2121C3_nt3v99Ev();
extern void _ZN10S2121C3_nt4v100Ev();
extern void _ZN10S2121C3_nt4v101Ev();
extern void _ZN10S2121C3_nt4v102Ev();
static  VTBL_ENTRY vtc_S2121C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2121C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S2121C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v2Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt4v102Ev,
};
extern VTBL_ENTRY _ZTI10S2121C3_nt[];
VTBL_ENTRY *P__ZTI10S2121C3_nt = _ZTI10S2121C3_nt; 
extern  VTBL_ENTRY _ZTV10S2121C3_nt[];
Class_Descriptor cd_S2121C3_nt = {  "S2121C3_nt", // class name
  bases_S2121C3_nt, 1,
  &(vtc_S2121C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(832,632), // object size
  NSPAIRA(_ZTI10S2121C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S2121C3_nt),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2121C2_nt  : S2121C3_nt {
  void *s2121c2f0;
  virtual  ~S2121C2_nt(); // _ZN10S2121C2_ntD1Ev
  virtual void  v103(); // _ZN10S2121C2_nt4v103Ev
  virtual void  v104(); // _ZN10S2121C2_nt4v104Ev
  virtual void  v105(); // _ZN10S2121C2_nt4v105Ev
  virtual void  v106(); // _ZN10S2121C2_nt4v106Ev
  virtual void  v107(); // _ZN10S2121C2_nt4v107Ev
  virtual void  v108(); // _ZN10S2121C2_nt4v108Ev
  virtual void  v109(); // _ZN10S2121C2_nt4v109Ev
  virtual void  v110(); // _ZN10S2121C2_nt4v110Ev
  virtual void  v111(); // _ZN10S2121C2_nt4v111Ev
  virtual void  v112(); // _ZN10S2121C2_nt4v112Ev
  S2121C2_nt(); // tgen
};
//SIG(-1 S2121C2_nt) C1{ BC2{ BC3{ vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 Fp Fi FC4{ BC5{ m Fp Fi FC6{ m} FC6}} FC4 Fi} vd v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 FC7{ m FC8{ m FL[2]}} FC7 FC7 FC7 FC9{ m FC7} FC10{ m FC7 FC7 FC7 FC7} FC10 FC7 FC7 FC7 Fp FC9 FC11{ m FC12{ m Fp Fi FC13{ m}} Fi} Fi Fp[7] FC14{ m Fp Fi FC13 FC15{ m}} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC16{ BC17{ m Fp Fi FC15 FC18{ m}}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC19{ m Fp Fi[2] FC18} Fp[2] Fi:16 Fi:16 FC16 FC19 FC20{ m Fp Fi[2] FC21{ m}} Fp[2] Fi:24 Fi:8 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp}


 S2121C2_nt ::~S2121C2_nt(){ note_dtor("S2121C2_nt", this);}
void  S2121C2_nt ::v103(){vfunc_called(this, "_ZN10S2121C2_nt4v103Ev");}
void  S2121C2_nt ::v104(){vfunc_called(this, "_ZN10S2121C2_nt4v104Ev");}
void  S2121C2_nt ::v105(){vfunc_called(this, "_ZN10S2121C2_nt4v105Ev");}
void  S2121C2_nt ::v106(){vfunc_called(this, "_ZN10S2121C2_nt4v106Ev");}
void  S2121C2_nt ::v107(){vfunc_called(this, "_ZN10S2121C2_nt4v107Ev");}
void  S2121C2_nt ::v108(){vfunc_called(this, "_ZN10S2121C2_nt4v108Ev");}
void  S2121C2_nt ::v109(){vfunc_called(this, "_ZN10S2121C2_nt4v109Ev");}
void  S2121C2_nt ::v110(){vfunc_called(this, "_ZN10S2121C2_nt4v110Ev");}
void  S2121C2_nt ::v111(){vfunc_called(this, "_ZN10S2121C2_nt4v111Ev");}
void  S2121C2_nt ::v112(){vfunc_called(this, "_ZN10S2121C2_nt4v112Ev");}
S2121C2_nt ::S2121C2_nt(){ note_ctor("S2121C2_nt", this);} // tgen

//skip512 S2121C2_nt

#else // __cplusplus

extern void _ZN10S2121C2_ntC1Ev();
extern void _ZN10S2121C2_ntD1Ev();
Name_Map name_map_S2121C2_nt[] = {
  NSPAIR(_ZN10S2121C2_ntC1Ev),
  NSPAIR(_ZN10S2121C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2121C4_nt;
extern VTBL_ENTRY _ZTI10S2121C4_nt[];
extern  VTBL_ENTRY _ZTV10S2121C4_nt[];
extern Class_Descriptor cd_S2121C3_nt;
extern VTBL_ENTRY _ZTI10S2121C3_nt[];
extern  VTBL_ENTRY _ZTV10S2121C3_nt[];
static Base_Class bases_S2121C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2121C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2121C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S2121C2_nt[];
extern void _ZN10S2121C2_ntD1Ev();
extern void _ZN10S2121C2_ntD0Ev();
extern void _ZN10S2121C4_nt2v2Ev();
extern void _ZN10S2121C4_nt2v3Ev();
extern void _ZN10S2121C4_nt2v4Ev();
extern void _ZN10S2121C4_nt2v5Ev();
extern void _ZN10S2121C4_nt2v6Ev();
extern void _ZN10S2121C4_nt2v7Ev();
extern void _ZN10S2121C4_nt2v8Ev();
extern void _ZN10S2121C4_nt2v9Ev();
extern void _ZN10S2121C4_nt3v10Ev();
extern void _ZN10S2121C4_nt3v11Ev();
extern void _ZN10S2121C4_nt3v12Ev();
extern void _ZN10S2121C4_nt3v13Ev();
extern void _ZN10S2121C4_nt3v14Ev();
extern void _ZN10S2121C4_nt3v15Ev();
extern void _ZN10S2121C4_nt3v16Ev();
extern void _ZN10S2121C4_nt3v17Ev();
extern void _ZN10S2121C4_nt3v18Ev();
extern void _ZN10S2121C4_nt3v19Ev();
extern void _ZN10S2121C4_nt3v20Ev();
extern void _ZN10S2121C4_nt3v21Ev();
extern void _ZN10S2121C4_nt3v22Ev();
extern void _ZN10S2121C4_nt3v23Ev();
extern void _ZN10S2121C4_nt3v24Ev();
extern void _ZN10S2121C3_nt3v25Ev();
extern void _ZN10S2121C3_nt3v26Ev();
extern void _ZN10S2121C3_nt3v27Ev();
extern void _ZN10S2121C3_nt3v28Ev();
extern void _ZN10S2121C3_nt3v29Ev();
extern void _ZN10S2121C3_nt3v30Ev();
extern void _ZN10S2121C3_nt3v31Ev();
extern void _ZN10S2121C3_nt3v32Ev();
extern void _ZN10S2121C3_nt3v33Ev();
extern void _ZN10S2121C3_nt3v34Ev();
extern void _ZN10S2121C3_nt3v35Ev();
extern void _ZN10S2121C3_nt3v36Ev();
extern void _ZN10S2121C3_nt3v37Ev();
extern void _ZN10S2121C3_nt3v38Ev();
extern void _ZN10S2121C3_nt3v39Ev();
extern void _ZN10S2121C3_nt3v40Ev();
extern void _ZN10S2121C3_nt3v41Ev();
extern void _ZN10S2121C3_nt3v42Ev();
extern void _ZN10S2121C3_nt3v43Ev();
extern void _ZN10S2121C3_nt3v44Ev();
extern void _ZN10S2121C3_nt3v45Ev();
extern void _ZN10S2121C3_nt3v46Ev();
extern void _ZN10S2121C3_nt3v47Ev();
extern void _ZN10S2121C3_nt3v48Ev();
extern void _ZN10S2121C3_nt3v49Ev();
extern void _ZN10S2121C3_nt3v50Ev();
extern void _ZN10S2121C3_nt3v51Ev();
extern void _ZN10S2121C3_nt3v52Ev();
extern void _ZN10S2121C3_nt3v53Ev();
extern void _ZN10S2121C3_nt3v54Ev();
extern void _ZN10S2121C3_nt3v55Ev();
extern void _ZN10S2121C3_nt3v56Ev();
extern void _ZN10S2121C3_nt3v57Ev();
extern void _ZN10S2121C3_nt3v58Ev();
extern void _ZN10S2121C3_nt3v59Ev();
extern void _ZN10S2121C3_nt3v60Ev();
extern void _ZN10S2121C3_nt3v61Ev();
extern void _ZN10S2121C3_nt3v62Ev();
extern void _ZN10S2121C3_nt3v63Ev();
extern void _ZN10S2121C3_nt3v64Ev();
extern void _ZN10S2121C3_nt3v65Ev();
extern void _ZN10S2121C3_nt3v66Ev();
extern void _ZN10S2121C3_nt3v67Ev();
extern void _ZN10S2121C3_nt3v68Ev();
extern void _ZN10S2121C3_nt3v69Ev();
extern void _ZN10S2121C3_nt3v70Ev();
extern void _ZN10S2121C3_nt3v71Ev();
extern void _ZN10S2121C3_nt3v72Ev();
extern void _ZN10S2121C3_nt3v73Ev();
extern void _ZN10S2121C3_nt3v74Ev();
extern void _ZN10S2121C3_nt3v75Ev();
extern void _ZN10S2121C3_nt3v76Ev();
extern void _ZN10S2121C3_nt3v77Ev();
extern void _ZN10S2121C3_nt3v78Ev();
extern void _ZN10S2121C3_nt3v79Ev();
extern void _ZN10S2121C3_nt3v80Ev();
extern void _ZN10S2121C3_nt3v81Ev();
extern void _ZN10S2121C3_nt3v82Ev();
extern void _ZN10S2121C3_nt3v83Ev();
extern void _ZN10S2121C3_nt3v84Ev();
extern void _ZN10S2121C3_nt3v85Ev();
extern void _ZN10S2121C3_nt3v86Ev();
extern void _ZN10S2121C3_nt3v87Ev();
extern void _ZN10S2121C3_nt3v88Ev();
extern void _ZN10S2121C3_nt3v89Ev();
extern void _ZN10S2121C3_nt3v90Ev();
extern void _ZN10S2121C3_nt3v91Ev();
extern void _ZN10S2121C3_nt3v92Ev();
extern void _ZN10S2121C3_nt3v93Ev();
extern void _ZN10S2121C3_nt3v94Ev();
extern void _ZN10S2121C3_nt3v95Ev();
extern void _ZN10S2121C3_nt3v96Ev();
extern void _ZN10S2121C3_nt3v97Ev();
extern void _ZN10S2121C3_nt3v98Ev();
extern void _ZN10S2121C3_nt3v99Ev();
extern void _ZN10S2121C3_nt4v100Ev();
extern void _ZN10S2121C3_nt4v101Ev();
extern void _ZN10S2121C3_nt4v102Ev();
extern void _ZN10S2121C2_nt4v103Ev();
extern void _ZN10S2121C2_nt4v104Ev();
extern void _ZN10S2121C2_nt4v105Ev();
extern void _ZN10S2121C2_nt4v106Ev();
extern void _ZN10S2121C2_nt4v107Ev();
extern void _ZN10S2121C2_nt4v108Ev();
extern void _ZN10S2121C2_nt4v109Ev();
extern void _ZN10S2121C2_nt4v110Ev();
extern void _ZN10S2121C2_nt4v111Ev();
extern void _ZN10S2121C2_nt4v112Ev();
static  VTBL_ENTRY vtc_S2121C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2121C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S2121C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2121C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v2Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S2121C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S2121C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S2121C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S2121C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S2121C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S2121C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S2121C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S2121C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S2121C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S2121C2_nt4v112Ev,
};
extern VTBL_ENTRY _ZTI10S2121C2_nt[];
VTBL_ENTRY *P__ZTI10S2121C2_nt = _ZTI10S2121C2_nt; 
extern  VTBL_ENTRY _ZTV10S2121C2_nt[];
Class_Descriptor cd_S2121C2_nt = {  "S2121C2_nt", // class name
  bases_S2121C2_nt, 2,
  &(vtc_S2121C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(840,636), // object size
  NSPAIRA(_ZTI10S2121C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S2121C2_nt),115, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2121C39_nt  {
  long s2121c39f0;
  void  mf2121c39(); // _ZN11S2121C39_nt9mf2121c39Ev
};
//SIG(-1 S2121C39_nt) C1{ m Fl}


void  S2121C39_nt ::mf2121c39(){}

//skip512 S2121C39_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2121C1  : S2121C2_nt {
  int s2121c1f0[3];
  ::S2121C39_nt s2121c1f1;
  int s2121c1f2[4];
  char s2121c1f3;
  int s2121c1f4[38];
  char s2121c1f5[12];
  void *s2121c1f6[3];
  ::S2121C13_nt s2121c1f7;
  ::S2121C13_nt s2121c1f8;
  ::S2121C13_nt s2121c1f9;
  virtual  ~S2121C1(); // _ZN7S2121C1D1Ev
  virtual void  v1(); // _ZN7S2121C12v1Ev
  S2121C1(); // tgen
};
//SIG(1 S2121C1) C1{ BC2{ BC3{ BC4{ vd v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp Fi FC5{ BC6{ m Fp Fi FC7{ m} FC7}} FC5 Fi} vd v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8 FC10{ m FC8} FC11{ m FC8 FC8 FC8 FC8} FC11 FC8 FC8 FC8 Fp FC10 FC12{ m FC13{ m Fp Fi FC14{ m}} Fi} Fi Fp[7] FC15{ m Fp Fi FC14 FC16{ m}} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC17{ BC18{ m Fp Fi FC16 FC19{ m}}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC20{ m Fp Fi[2] FC19} Fp[2] Fi:16 Fi:16 FC17 FC20 FC21{ m Fp Fi[2] FC22{ m}} Fp[2] Fi:24 Fi:8 Fp} vd v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 Fp} vd v1 Fi[3] FC23{ m Fl} Fi[4] Fc Fi[38] Fc[12] Fp[3] FC8 FC8 FC8}


 S2121C1 ::~S2121C1(){ note_dtor("S2121C1", this);}
void  S2121C1 ::v1(){vfunc_called(this, "_ZN7S2121C12v1Ev");}
S2121C1 ::S2121C1(){ note_ctor("S2121C1", this);} // tgen

static void Test_S2121C1()
{
  extern Class_Descriptor cd_S2121C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(141,225)];
    init_test(&cd_S2121C1, buf);
    S2121C1 *dp, &lv = *(dp=new (buf) S2121C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1120,896), "sizeof(S2121C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2121C1)");
    check_base_class_offset(lv, (S2121C4_nt*)(S2121C3_nt*)(S2121C2_nt*), 0, "S2121C1");
    check_base_class_offset(lv, (S2121C3_nt*)(S2121C2_nt*), 0, "S2121C1");
    check_base_class_offset(lv, (S2121C2_nt*), 0, "S2121C1");
    check_field_offset(lv, s2121c1f0, ABISELECT(840,636), "S2121C1.s2121c1f0");
    check_field_offset(lv, s2121c1f1, ABISELECT(856,648), "S2121C1.s2121c1f1");
    check_field_offset(lv, s2121c1f2, ABISELECT(864,652), "S2121C1.s2121c1f2");
    check_field_offset(lv, s2121c1f3, ABISELECT(880,668), "S2121C1.s2121c1f3");
    check_field_offset(lv, s2121c1f4, ABISELECT(884,672), "S2121C1.s2121c1f4");
    check_field_offset(lv, s2121c1f5, ABISELECT(1036,824), "S2121C1.s2121c1f5");
    check_field_offset(lv, s2121c1f6, ABISELECT(1048,836), "S2121C1.s2121c1f6");
    check_field_offset(lv, s2121c1f7, ABISELECT(1072,848), "S2121C1.s2121c1f7");
    check_field_offset(lv, s2121c1f8, ABISELECT(1088,864), "S2121C1.s2121c1f8");
    check_field_offset(lv, s2121c1f9, ABISELECT(1104,880), "S2121C1.s2121c1f9");
    test_class_info(&lv, &cd_S2121C1);
    dp->~S2121C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2121C1(Test_S2121C1, "S2121C1", ABISELECT(1120,896));

#else // __cplusplus

extern void _ZN7S2121C1C1Ev();
extern void _ZN7S2121C1D1Ev();
Name_Map name_map_S2121C1[] = {
  NSPAIR(_ZN7S2121C1C1Ev),
  NSPAIR(_ZN7S2121C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2121C4_nt;
extern VTBL_ENTRY _ZTI10S2121C4_nt[];
extern  VTBL_ENTRY _ZTV10S2121C4_nt[];
extern Class_Descriptor cd_S2121C3_nt;
extern VTBL_ENTRY _ZTI10S2121C3_nt[];
extern  VTBL_ENTRY _ZTV10S2121C3_nt[];
extern Class_Descriptor cd_S2121C2_nt;
extern VTBL_ENTRY _ZTI10S2121C2_nt[];
extern  VTBL_ENTRY _ZTV10S2121C2_nt[];
static Base_Class bases_S2121C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2121C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2121C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2121C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2121C1[];
extern void _ZN7S2121C1D1Ev();
extern void _ZN7S2121C1D0Ev();
extern void _ZN10S2121C4_nt2v2Ev();
extern void _ZN10S2121C4_nt2v3Ev();
extern void _ZN10S2121C4_nt2v4Ev();
extern void _ZN10S2121C4_nt2v5Ev();
extern void _ZN10S2121C4_nt2v6Ev();
extern void _ZN10S2121C4_nt2v7Ev();
extern void _ZN10S2121C4_nt2v8Ev();
extern void _ZN10S2121C4_nt2v9Ev();
extern void _ZN10S2121C4_nt3v10Ev();
extern void _ZN10S2121C4_nt3v11Ev();
extern void _ZN10S2121C4_nt3v12Ev();
extern void _ZN10S2121C4_nt3v13Ev();
extern void _ZN10S2121C4_nt3v14Ev();
extern void _ZN10S2121C4_nt3v15Ev();
extern void _ZN10S2121C4_nt3v16Ev();
extern void _ZN10S2121C4_nt3v17Ev();
extern void _ZN10S2121C4_nt3v18Ev();
extern void _ZN10S2121C4_nt3v19Ev();
extern void _ZN10S2121C4_nt3v20Ev();
extern void _ZN10S2121C4_nt3v21Ev();
extern void _ZN10S2121C4_nt3v22Ev();
extern void _ZN10S2121C4_nt3v23Ev();
extern void _ZN10S2121C4_nt3v24Ev();
extern void _ZN10S2121C3_nt3v25Ev();
extern void _ZN10S2121C3_nt3v26Ev();
extern void _ZN10S2121C3_nt3v27Ev();
extern void _ZN10S2121C3_nt3v28Ev();
extern void _ZN10S2121C3_nt3v29Ev();
extern void _ZN10S2121C3_nt3v30Ev();
extern void _ZN10S2121C3_nt3v31Ev();
extern void _ZN10S2121C3_nt3v32Ev();
extern void _ZN10S2121C3_nt3v33Ev();
extern void _ZN10S2121C3_nt3v34Ev();
extern void _ZN10S2121C3_nt3v35Ev();
extern void _ZN10S2121C3_nt3v36Ev();
extern void _ZN10S2121C3_nt3v37Ev();
extern void _ZN10S2121C3_nt3v38Ev();
extern void _ZN10S2121C3_nt3v39Ev();
extern void _ZN10S2121C3_nt3v40Ev();
extern void _ZN10S2121C3_nt3v41Ev();
extern void _ZN10S2121C3_nt3v42Ev();
extern void _ZN10S2121C3_nt3v43Ev();
extern void _ZN10S2121C3_nt3v44Ev();
extern void _ZN10S2121C3_nt3v45Ev();
extern void _ZN10S2121C3_nt3v46Ev();
extern void _ZN10S2121C3_nt3v47Ev();
extern void _ZN10S2121C3_nt3v48Ev();
extern void _ZN10S2121C3_nt3v49Ev();
extern void _ZN10S2121C3_nt3v50Ev();
extern void _ZN10S2121C3_nt3v51Ev();
extern void _ZN10S2121C3_nt3v52Ev();
extern void _ZN10S2121C3_nt3v53Ev();
extern void _ZN10S2121C3_nt3v54Ev();
extern void _ZN10S2121C3_nt3v55Ev();
extern void _ZN10S2121C3_nt3v56Ev();
extern void _ZN10S2121C3_nt3v57Ev();
extern void _ZN10S2121C3_nt3v58Ev();
extern void _ZN10S2121C3_nt3v59Ev();
extern void _ZN10S2121C3_nt3v60Ev();
extern void _ZN10S2121C3_nt3v61Ev();
extern void _ZN10S2121C3_nt3v62Ev();
extern void _ZN10S2121C3_nt3v63Ev();
extern void _ZN10S2121C3_nt3v64Ev();
extern void _ZN10S2121C3_nt3v65Ev();
extern void _ZN10S2121C3_nt3v66Ev();
extern void _ZN10S2121C3_nt3v67Ev();
extern void _ZN10S2121C3_nt3v68Ev();
extern void _ZN10S2121C3_nt3v69Ev();
extern void _ZN10S2121C3_nt3v70Ev();
extern void _ZN10S2121C3_nt3v71Ev();
extern void _ZN10S2121C3_nt3v72Ev();
extern void _ZN10S2121C3_nt3v73Ev();
extern void _ZN10S2121C3_nt3v74Ev();
extern void _ZN10S2121C3_nt3v75Ev();
extern void _ZN10S2121C3_nt3v76Ev();
extern void _ZN10S2121C3_nt3v77Ev();
extern void _ZN10S2121C3_nt3v78Ev();
extern void _ZN10S2121C3_nt3v79Ev();
extern void _ZN10S2121C3_nt3v80Ev();
extern void _ZN10S2121C3_nt3v81Ev();
extern void _ZN10S2121C3_nt3v82Ev();
extern void _ZN10S2121C3_nt3v83Ev();
extern void _ZN10S2121C3_nt3v84Ev();
extern void _ZN10S2121C3_nt3v85Ev();
extern void _ZN10S2121C3_nt3v86Ev();
extern void _ZN10S2121C3_nt3v87Ev();
extern void _ZN10S2121C3_nt3v88Ev();
extern void _ZN10S2121C3_nt3v89Ev();
extern void _ZN10S2121C3_nt3v90Ev();
extern void _ZN10S2121C3_nt3v91Ev();
extern void _ZN10S2121C3_nt3v92Ev();
extern void _ZN10S2121C3_nt3v93Ev();
extern void _ZN10S2121C3_nt3v94Ev();
extern void _ZN10S2121C3_nt3v95Ev();
extern void _ZN10S2121C3_nt3v96Ev();
extern void _ZN10S2121C3_nt3v97Ev();
extern void _ZN10S2121C3_nt3v98Ev();
extern void _ZN10S2121C3_nt3v99Ev();
extern void _ZN10S2121C3_nt4v100Ev();
extern void _ZN10S2121C3_nt4v101Ev();
extern void _ZN10S2121C3_nt4v102Ev();
extern void _ZN10S2121C2_nt4v103Ev();
extern void _ZN10S2121C2_nt4v104Ev();
extern void _ZN10S2121C2_nt4v105Ev();
extern void _ZN10S2121C2_nt4v106Ev();
extern void _ZN10S2121C2_nt4v107Ev();
extern void _ZN10S2121C2_nt4v108Ev();
extern void _ZN10S2121C2_nt4v109Ev();
extern void _ZN10S2121C2_nt4v110Ev();
extern void _ZN10S2121C2_nt4v111Ev();
extern void _ZN10S2121C2_nt4v112Ev();
extern void _ZN7S2121C12v1Ev();
static  VTBL_ENTRY vtc_S2121C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2121C1[0]),
  (VTBL_ENTRY)&_ZN7S2121C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2121C1D0Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v2Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2121C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S2121C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S2121C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S2121C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S2121C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S2121C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S2121C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S2121C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S2121C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S2121C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S2121C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S2121C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN7S2121C12v1Ev,
};
extern VTBL_ENTRY _ZTI7S2121C1[];
extern  VTBL_ENTRY _ZTV7S2121C1[];
Class_Descriptor cd_S2121C1 = {  "S2121C1", // class name
  bases_S2121C1, 3,
  &(vtc_S2121C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1120,896), // object size
  NSPAIRA(_ZTI7S2121C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2121C1),116, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S287C6  {
  int s287c6f0;
  __tsi64 s287c6f1;
  void *s287c6f2[4];
  int s287c6f3[2];
  void *s287c6f4;
  ::S3350C4_nt s287c6f5;
  void *s287c6f6[2];
  virtual  ~S287C6(); // _ZN6S287C6D1Ev
  virtual void  v9(); // _ZN6S287C62v9Ev
  virtual void  v10(); // _ZN6S287C63v10Ev
  virtual void  v11(); // _ZN6S287C63v11Ev
  virtual void  v12(); // _ZN6S287C63v12Ev
  virtual void  v13(); // _ZN6S287C63v13Ev
  virtual void  v14(); // _ZN6S287C63v14Ev
  virtual void  v15(); // _ZN6S287C63v15Ev
  virtual void  v16(); // _ZN6S287C63v16Ev
  virtual void  v17(); // _ZN6S287C63v17Ev
  virtual void  v18(); // _ZN6S287C63v18Ev
  virtual void  v19(); // _ZN6S287C63v19Ev
  virtual void  v20(); // _ZN6S287C63v20Ev
  virtual void  v21(); // _ZN6S287C63v21Ev
  virtual void  v22(); // _ZN6S287C63v22Ev
  virtual void  v23(); // _ZN6S287C63v23Ev
  virtual void  v24(); // _ZN6S287C63v24Ev
  virtual void  v25(); // _ZN6S287C63v25Ev
  virtual void  v26(); // _ZN6S287C63v26Ev
  virtual void  v27(); // _ZN6S287C63v27Ev
  virtual void  v28(); // _ZN6S287C63v28Ev
  virtual void  v29(); // _ZN6S287C63v29Ev
  virtual void  v30(); // _ZN6S287C63v30Ev
  virtual void  v31(); // _ZN6S287C63v31Ev
  virtual void  v32(); // _ZN6S287C63v32Ev
  virtual void  v33(); // _ZN6S287C63v33Ev
  virtual void  v34(); // _ZN6S287C63v34Ev
  virtual void  v35(); // _ZN6S287C63v35Ev
  virtual void  v36(); // _ZN6S287C63v36Ev
  virtual void  v37(); // _ZN6S287C63v37Ev
  virtual void  v38(); // _ZN6S287C63v38Ev
  virtual void  v39(); // _ZN6S287C63v39Ev
  virtual void  v40(); // _ZN6S287C63v40Ev
  virtual void  v41(); // _ZN6S287C63v41Ev
  virtual void  v42(); // _ZN6S287C63v42Ev
  virtual void  v43(); // _ZN6S287C63v43Ev
  virtual void  v44(); // _ZN6S287C63v44Ev
  virtual void  v45(); // _ZN6S287C63v45Ev
  virtual void  v46(); // _ZN6S287C63v46Ev
  virtual void  v47(); // _ZN6S287C63v47Ev
  virtual void  v48(); // _ZN6S287C63v48Ev
  virtual void  v49(); // _ZN6S287C63v49Ev
  virtual void  v50(); // _ZN6S287C63v50Ev
  virtual void  v51(); // _ZN6S287C63v51Ev
  virtual void  v52(); // _ZN6S287C63v52Ev
  virtual void  v53(); // _ZN6S287C63v53Ev
  virtual void  v54(); // _ZN6S287C63v54Ev
  virtual void  v55(); // _ZN6S287C63v55Ev
  virtual void  v56(); // _ZN6S287C63v56Ev
  virtual void  v57(); // _ZN6S287C63v57Ev
  virtual void  v58(); // _ZN6S287C63v58Ev
  virtual void  v59(); // _ZN6S287C63v59Ev
  virtual void  v60(); // _ZN6S287C63v60Ev
  virtual void  v61(); // _ZN6S287C63v61Ev
  virtual void  v62(); // _ZN6S287C63v62Ev
  virtual void  v63(); // _ZN6S287C63v63Ev
  virtual void  v64(); // _ZN6S287C63v64Ev
  virtual void  v65(); // _ZN6S287C63v65Ev
  virtual void  v66(); // _ZN6S287C63v66Ev
  virtual void  v67(); // _ZN6S287C63v67Ev
  virtual void  v68(); // _ZN6S287C63v68Ev
  virtual void  v69(); // _ZN6S287C63v69Ev
  virtual void  v70(); // _ZN6S287C63v70Ev
  virtual void  v71(); // _ZN6S287C63v71Ev
  virtual void  v72(); // _ZN6S287C63v72Ev
  S287C6(); // tgen
};
//SIG(-1 S287C6) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S287C6 ::~S287C6(){ note_dtor("S287C6", this);}
void  S287C6 ::v9(){vfunc_called(this, "_ZN6S287C62v9Ev");}
void  S287C6 ::v10(){vfunc_called(this, "_ZN6S287C63v10Ev");}
void  S287C6 ::v11(){vfunc_called(this, "_ZN6S287C63v11Ev");}
void  S287C6 ::v12(){vfunc_called(this, "_ZN6S287C63v12Ev");}
void  S287C6 ::v13(){vfunc_called(this, "_ZN6S287C63v13Ev");}
void  S287C6 ::v14(){vfunc_called(this, "_ZN6S287C63v14Ev");}
void  S287C6 ::v15(){vfunc_called(this, "_ZN6S287C63v15Ev");}
void  S287C6 ::v16(){vfunc_called(this, "_ZN6S287C63v16Ev");}
void  S287C6 ::v17(){vfunc_called(this, "_ZN6S287C63v17Ev");}
void  S287C6 ::v18(){vfunc_called(this, "_ZN6S287C63v18Ev");}
void  S287C6 ::v19(){vfunc_called(this, "_ZN6S287C63v19Ev");}
void  S287C6 ::v20(){vfunc_called(this, "_ZN6S287C63v20Ev");}
void  S287C6 ::v21(){vfunc_called(this, "_ZN6S287C63v21Ev");}
void  S287C6 ::v22(){vfunc_called(this, "_ZN6S287C63v22Ev");}
void  S287C6 ::v23(){vfunc_called(this, "_ZN6S287C63v23Ev");}
void  S287C6 ::v24(){vfunc_called(this, "_ZN6S287C63v24Ev");}
void  S287C6 ::v25(){vfunc_called(this, "_ZN6S287C63v25Ev");}
void  S287C6 ::v26(){vfunc_called(this, "_ZN6S287C63v26Ev");}
void  S287C6 ::v27(){vfunc_called(this, "_ZN6S287C63v27Ev");}
void  S287C6 ::v28(){vfunc_called(this, "_ZN6S287C63v28Ev");}
void  S287C6 ::v29(){vfunc_called(this, "_ZN6S287C63v29Ev");}
void  S287C6 ::v30(){vfunc_called(this, "_ZN6S287C63v30Ev");}
void  S287C6 ::v31(){vfunc_called(this, "_ZN6S287C63v31Ev");}
void  S287C6 ::v32(){vfunc_called(this, "_ZN6S287C63v32Ev");}
void  S287C6 ::v33(){vfunc_called(this, "_ZN6S287C63v33Ev");}
void  S287C6 ::v34(){vfunc_called(this, "_ZN6S287C63v34Ev");}
void  S287C6 ::v35(){vfunc_called(this, "_ZN6S287C63v35Ev");}
void  S287C6 ::v36(){vfunc_called(this, "_ZN6S287C63v36Ev");}
void  S287C6 ::v37(){vfunc_called(this, "_ZN6S287C63v37Ev");}
void  S287C6 ::v38(){vfunc_called(this, "_ZN6S287C63v38Ev");}
void  S287C6 ::v39(){vfunc_called(this, "_ZN6S287C63v39Ev");}
void  S287C6 ::v40(){vfunc_called(this, "_ZN6S287C63v40Ev");}
void  S287C6 ::v41(){vfunc_called(this, "_ZN6S287C63v41Ev");}
void  S287C6 ::v42(){vfunc_called(this, "_ZN6S287C63v42Ev");}
void  S287C6 ::v43(){vfunc_called(this, "_ZN6S287C63v43Ev");}
void  S287C6 ::v44(){vfunc_called(this, "_ZN6S287C63v44Ev");}
void  S287C6 ::v45(){vfunc_called(this, "_ZN6S287C63v45Ev");}
void  S287C6 ::v46(){vfunc_called(this, "_ZN6S287C63v46Ev");}
void  S287C6 ::v47(){vfunc_called(this, "_ZN6S287C63v47Ev");}
void  S287C6 ::v48(){vfunc_called(this, "_ZN6S287C63v48Ev");}
void  S287C6 ::v49(){vfunc_called(this, "_ZN6S287C63v49Ev");}
void  S287C6 ::v50(){vfunc_called(this, "_ZN6S287C63v50Ev");}
void  S287C6 ::v51(){vfunc_called(this, "_ZN6S287C63v51Ev");}
void  S287C6 ::v52(){vfunc_called(this, "_ZN6S287C63v52Ev");}
void  S287C6 ::v53(){vfunc_called(this, "_ZN6S287C63v53Ev");}
void  S287C6 ::v54(){vfunc_called(this, "_ZN6S287C63v54Ev");}
void  S287C6 ::v55(){vfunc_called(this, "_ZN6S287C63v55Ev");}
void  S287C6 ::v56(){vfunc_called(this, "_ZN6S287C63v56Ev");}
void  S287C6 ::v57(){vfunc_called(this, "_ZN6S287C63v57Ev");}
void  S287C6 ::v58(){vfunc_called(this, "_ZN6S287C63v58Ev");}
void  S287C6 ::v59(){vfunc_called(this, "_ZN6S287C63v59Ev");}
void  S287C6 ::v60(){vfunc_called(this, "_ZN6S287C63v60Ev");}
void  S287C6 ::v61(){vfunc_called(this, "_ZN6S287C63v61Ev");}
void  S287C6 ::v62(){vfunc_called(this, "_ZN6S287C63v62Ev");}
void  S287C6 ::v63(){vfunc_called(this, "_ZN6S287C63v63Ev");}
void  S287C6 ::v64(){vfunc_called(this, "_ZN6S287C63v64Ev");}
void  S287C6 ::v65(){vfunc_called(this, "_ZN6S287C63v65Ev");}
void  S287C6 ::v66(){vfunc_called(this, "_ZN6S287C63v66Ev");}
void  S287C6 ::v67(){vfunc_called(this, "_ZN6S287C63v67Ev");}
void  S287C6 ::v68(){vfunc_called(this, "_ZN6S287C63v68Ev");}
void  S287C6 ::v69(){vfunc_called(this, "_ZN6S287C63v69Ev");}
void  S287C6 ::v70(){vfunc_called(this, "_ZN6S287C63v70Ev");}
void  S287C6 ::v71(){vfunc_called(this, "_ZN6S287C63v71Ev");}
void  S287C6 ::v72(){vfunc_called(this, "_ZN6S287C63v72Ev");}
S287C6 ::S287C6(){ note_ctor("S287C6", this);} // tgen

static void Test_S287C6()
{
  extern Class_Descriptor cd_S287C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S287C6, buf);
    S287C6 *dp, &lv = *(dp=new (buf) S287C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S287C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S287C6)");
    check_field_offset(lv, s287c6f0, ABISELECT(8,4), "S287C6.s287c6f0");
    check_field_offset(lv, s287c6f1, ABISELECT(16,8), "S287C6.s287c6f1");
    check_field_offset(lv, s287c6f2, ABISELECT(24,16), "S287C6.s287c6f2");
    check_field_offset(lv, s287c6f3, ABISELECT(56,32), "S287C6.s287c6f3");
    check_field_offset(lv, s287c6f4, ABISELECT(64,40), "S287C6.s287c6f4");
    check_field_offset(lv, s287c6f5, ABISELECT(72,44), "S287C6.s287c6f5");
    check_field_offset(lv, s287c6f6, ABISELECT(80,52), "S287C6.s287c6f6");
    test_class_info(&lv, &cd_S287C6);
    dp->~S287C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS287C6(Test_S287C6, "S287C6", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S287C6C1Ev();
extern void _ZN6S287C6D1Ev();
Name_Map name_map_S287C6[] = {
  NSPAIR(_ZN6S287C6C1Ev),
  NSPAIR(_ZN6S287C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S287C6[];
extern void _ZN6S287C6D1Ev();
extern void _ZN6S287C6D0Ev();
extern void _ZN6S287C62v9Ev();
extern void _ZN6S287C63v10Ev();
extern void _ZN6S287C63v11Ev();
extern void _ZN6S287C63v12Ev();
extern void _ZN6S287C63v13Ev();
extern void _ZN6S287C63v14Ev();
extern void _ZN6S287C63v15Ev();
extern void _ZN6S287C63v16Ev();
extern void _ZN6S287C63v17Ev();
extern void _ZN6S287C63v18Ev();
extern void _ZN6S287C63v19Ev();
extern void _ZN6S287C63v20Ev();
extern void _ZN6S287C63v21Ev();
extern void _ZN6S287C63v22Ev();
extern void _ZN6S287C63v23Ev();
extern void _ZN6S287C63v24Ev();
extern void _ZN6S287C63v25Ev();
extern void _ZN6S287C63v26Ev();
extern void _ZN6S287C63v27Ev();
extern void _ZN6S287C63v28Ev();
extern void _ZN6S287C63v29Ev();
extern void _ZN6S287C63v30Ev();
extern void _ZN6S287C63v31Ev();
extern void _ZN6S287C63v32Ev();
extern void _ZN6S287C63v33Ev();
extern void _ZN6S287C63v34Ev();
extern void _ZN6S287C63v35Ev();
extern void _ZN6S287C63v36Ev();
extern void _ZN6S287C63v37Ev();
extern void _ZN6S287C63v38Ev();
extern void _ZN6S287C63v39Ev();
extern void _ZN6S287C63v40Ev();
extern void _ZN6S287C63v41Ev();
extern void _ZN6S287C63v42Ev();
extern void _ZN6S287C63v43Ev();
extern void _ZN6S287C63v44Ev();
extern void _ZN6S287C63v45Ev();
extern void _ZN6S287C63v46Ev();
extern void _ZN6S287C63v47Ev();
extern void _ZN6S287C63v48Ev();
extern void _ZN6S287C63v49Ev();
extern void _ZN6S287C63v50Ev();
extern void _ZN6S287C63v51Ev();
extern void _ZN6S287C63v52Ev();
extern void _ZN6S287C63v53Ev();
extern void _ZN6S287C63v54Ev();
extern void _ZN6S287C63v55Ev();
extern void _ZN6S287C63v56Ev();
extern void _ZN6S287C63v57Ev();
extern void _ZN6S287C63v58Ev();
extern void _ZN6S287C63v59Ev();
extern void _ZN6S287C63v60Ev();
extern void _ZN6S287C63v61Ev();
extern void _ZN6S287C63v62Ev();
extern void _ZN6S287C63v63Ev();
extern void _ZN6S287C63v64Ev();
extern void _ZN6S287C63v65Ev();
extern void _ZN6S287C63v66Ev();
extern void _ZN6S287C63v67Ev();
extern void _ZN6S287C63v68Ev();
extern void _ZN6S287C63v69Ev();
extern void _ZN6S287C63v70Ev();
extern void _ZN6S287C63v71Ev();
extern void _ZN6S287C63v72Ev();
static  VTBL_ENTRY vtc_S287C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S287C6[0]),
  (VTBL_ENTRY)&_ZN6S287C6D1Ev,
  (VTBL_ENTRY)&_ZN6S287C6D0Ev,
  (VTBL_ENTRY)&_ZN6S287C62v9Ev,
  (VTBL_ENTRY)&_ZN6S287C63v10Ev,
  (VTBL_ENTRY)&_ZN6S287C63v11Ev,
  (VTBL_ENTRY)&_ZN6S287C63v12Ev,
  (VTBL_ENTRY)&_ZN6S287C63v13Ev,
  (VTBL_ENTRY)&_ZN6S287C63v14Ev,
  (VTBL_ENTRY)&_ZN6S287C63v15Ev,
  (VTBL_ENTRY)&_ZN6S287C63v16Ev,
  (VTBL_ENTRY)&_ZN6S287C63v17Ev,
  (VTBL_ENTRY)&_ZN6S287C63v18Ev,
  (VTBL_ENTRY)&_ZN6S287C63v19Ev,
  (VTBL_ENTRY)&_ZN6S287C63v20Ev,
  (VTBL_ENTRY)&_ZN6S287C63v21Ev,
  (VTBL_ENTRY)&_ZN6S287C63v22Ev,
  (VTBL_ENTRY)&_ZN6S287C63v23Ev,
  (VTBL_ENTRY)&_ZN6S287C63v24Ev,
  (VTBL_ENTRY)&_ZN6S287C63v25Ev,
  (VTBL_ENTRY)&_ZN6S287C63v26Ev,
  (VTBL_ENTRY)&_ZN6S287C63v27Ev,
  (VTBL_ENTRY)&_ZN6S287C63v28Ev,
  (VTBL_ENTRY)&_ZN6S287C63v29Ev,
  (VTBL_ENTRY)&_ZN6S287C63v30Ev,
  (VTBL_ENTRY)&_ZN6S287C63v31Ev,
  (VTBL_ENTRY)&_ZN6S287C63v32Ev,
  (VTBL_ENTRY)&_ZN6S287C63v33Ev,
  (VTBL_ENTRY)&_ZN6S287C63v34Ev,
  (VTBL_ENTRY)&_ZN6S287C63v35Ev,
  (VTBL_ENTRY)&_ZN6S287C63v36Ev,
  (VTBL_ENTRY)&_ZN6S287C63v37Ev,
  (VTBL_ENTRY)&_ZN6S287C63v38Ev,
  (VTBL_ENTRY)&_ZN6S287C63v39Ev,
  (VTBL_ENTRY)&_ZN6S287C63v40Ev,
  (VTBL_ENTRY)&_ZN6S287C63v41Ev,
  (VTBL_ENTRY)&_ZN6S287C63v42Ev,
  (VTBL_ENTRY)&_ZN6S287C63v43Ev,
  (VTBL_ENTRY)&_ZN6S287C63v44Ev,
  (VTBL_ENTRY)&_ZN6S287C63v45Ev,
  (VTBL_ENTRY)&_ZN6S287C63v46Ev,
  (VTBL_ENTRY)&_ZN6S287C63v47Ev,
  (VTBL_ENTRY)&_ZN6S287C63v48Ev,
  (VTBL_ENTRY)&_ZN6S287C63v49Ev,
  (VTBL_ENTRY)&_ZN6S287C63v50Ev,
  (VTBL_ENTRY)&_ZN6S287C63v51Ev,
  (VTBL_ENTRY)&_ZN6S287C63v52Ev,
  (VTBL_ENTRY)&_ZN6S287C63v53Ev,
  (VTBL_ENTRY)&_ZN6S287C63v54Ev,
  (VTBL_ENTRY)&_ZN6S287C63v55Ev,
  (VTBL_ENTRY)&_ZN6S287C63v56Ev,
  (VTBL_ENTRY)&_ZN6S287C63v57Ev,
  (VTBL_ENTRY)&_ZN6S287C63v58Ev,
  (VTBL_ENTRY)&_ZN6S287C63v59Ev,
  (VTBL_ENTRY)&_ZN6S287C63v60Ev,
  (VTBL_ENTRY)&_ZN6S287C63v61Ev,
  (VTBL_ENTRY)&_ZN6S287C63v62Ev,
  (VTBL_ENTRY)&_ZN6S287C63v63Ev,
  (VTBL_ENTRY)&_ZN6S287C63v64Ev,
  (VTBL_ENTRY)&_ZN6S287C63v65Ev,
  (VTBL_ENTRY)&_ZN6S287C63v66Ev,
  (VTBL_ENTRY)&_ZN6S287C63v67Ev,
  (VTBL_ENTRY)&_ZN6S287C63v68Ev,
  (VTBL_ENTRY)&_ZN6S287C63v69Ev,
  (VTBL_ENTRY)&_ZN6S287C63v70Ev,
  (VTBL_ENTRY)&_ZN6S287C63v71Ev,
  (VTBL_ENTRY)&_ZN6S287C63v72Ev,
};
extern VTBL_ENTRY _ZTI6S287C6[];
extern  VTBL_ENTRY _ZTV6S287C6[];
Class_Descriptor cd_S287C6 = {  "S287C6", // class name
  0,0,//no base classes
  &(vtc_S287C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S287C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S287C6),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S287C10  : S3350C7_nt {
};
//SIG(-1 S287C10) C1{ BC2{ m Fp Fi[2]}}



static void Test_S287C10()
{
  extern Class_Descriptor cd_S287C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S287C10, buf);
    S287C10 &lv = *(new (buf) S287C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S287C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S287C10)");
    check_base_class_offset(lv, (S3350C7_nt*), 0, "S287C10");
    test_class_info(&lv, &cd_S287C10);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS287C10(Test_S287C10, "S287C10", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3350C7_nt;
static Base_Class bases_S287C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3350C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S287C10 = {  "S287C10", // class name
  bases_S287C10, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S287C9  : S287C10 {
};
//SIG(-1 S287C9) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S287C9()
{
  extern Class_Descriptor cd_S287C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S287C9, buf);
    S287C9 &lv = *(new (buf) S287C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S287C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S287C9)");
    check_base_class_offset(lv, (S3350C7_nt*)(S287C10*), 0, "S287C9");
    check_base_class_offset(lv, (S287C10*), 0, "S287C9");
    test_class_info(&lv, &cd_S287C9);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS287C9(Test_S287C9, "S287C9", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3350C7_nt;
extern Class_Descriptor cd_S287C10;
static Base_Class bases_S287C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3350C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S287C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S287C9 = {  "S287C9", // class name
  bases_S287C9, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S287C8_nt  : S287C9 {
};
//SIG(-1 S287C8_nt) C1{ BC2{ BC3{ BC4{ m Fp Fi[2]}}}}



//skip512 S287C8_nt

#else // __cplusplus

extern Class_Descriptor cd_S3350C7_nt;
extern Class_Descriptor cd_S287C10;
extern Class_Descriptor cd_S287C9;
static Base_Class bases_S287C8_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3350C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S287C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S287C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S287C5  : S287C6 {
  int s287c5f0[2];
  void *s287c5f1;
  int s287c5f2[2];
  ::S287C8_nt s287c5f3;
  ::S287C8_nt s287c5f4;
  ::S2121C38 s287c5f5;
  ::S287C8_nt s287c5f6;
  unsigned int s287c5f7:1;
  unsigned int s287c5f8:1;
  unsigned int s287c5f9:1;
  unsigned int s287c5f10:1;
  unsigned int s287c5f11:1;
  int s287c5f12[2];
  virtual  ~S287C5(); // _ZN6S287C5D1Ev
  virtual void  v73(); // _ZN6S287C53v73Ev
  virtual void  v74(); // _ZN6S287C53v74Ev
  virtual void  v75(); // _ZN6S287C53v75Ev
  virtual void  v76(); // _ZN6S287C53v76Ev
  virtual void  v77(); // _ZN6S287C53v77Ev
  virtual void  v78(); // _ZN6S287C53v78Ev
  virtual void  v79(); // _ZN6S287C53v79Ev
  virtual void  v80(); // _ZN6S287C53v80Ev
  virtual void  v81(); // _ZN6S287C53v81Ev
  virtual void  v82(); // _ZN6S287C53v82Ev
  virtual void  v83(); // _ZN6S287C53v83Ev
  virtual void  v84(); // _ZN6S287C53v84Ev
  virtual void  v85(); // _ZN6S287C53v85Ev
  virtual void  v86(); // _ZN6S287C53v86Ev
  virtual void  v87(); // _ZN6S287C53v87Ev
  virtual void  v88(); // _ZN6S287C53v88Ev
  virtual void  v89(); // _ZN6S287C53v89Ev
  virtual void  v90(); // _ZN6S287C53v90Ev
  virtual void  v91(); // _ZN6S287C53v91Ev
  virtual void  v92(); // _ZN6S287C53v92Ev
  virtual void  v93(); // _ZN6S287C53v93Ev
  virtual void  v94(); // _ZN6S287C53v94Ev
  S287C5(); // tgen
};
//SIG(-1 S287C5) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S287C5 ::~S287C5(){ note_dtor("S287C5", this);}
void  S287C5 ::v73(){vfunc_called(this, "_ZN6S287C53v73Ev");}
void  S287C5 ::v74(){vfunc_called(this, "_ZN6S287C53v74Ev");}
void  S287C5 ::v75(){vfunc_called(this, "_ZN6S287C53v75Ev");}
void  S287C5 ::v76(){vfunc_called(this, "_ZN6S287C53v76Ev");}
void  S287C5 ::v77(){vfunc_called(this, "_ZN6S287C53v77Ev");}
void  S287C5 ::v78(){vfunc_called(this, "_ZN6S287C53v78Ev");}
void  S287C5 ::v79(){vfunc_called(this, "_ZN6S287C53v79Ev");}
void  S287C5 ::v80(){vfunc_called(this, "_ZN6S287C53v80Ev");}
void  S287C5 ::v81(){vfunc_called(this, "_ZN6S287C53v81Ev");}
void  S287C5 ::v82(){vfunc_called(this, "_ZN6S287C53v82Ev");}
void  S287C5 ::v83(){vfunc_called(this, "_ZN6S287C53v83Ev");}
void  S287C5 ::v84(){vfunc_called(this, "_ZN6S287C53v84Ev");}
void  S287C5 ::v85(){vfunc_called(this, "_ZN6S287C53v85Ev");}
void  S287C5 ::v86(){vfunc_called(this, "_ZN6S287C53v86Ev");}
void  S287C5 ::v87(){vfunc_called(this, "_ZN6S287C53v87Ev");}
void  S287C5 ::v88(){vfunc_called(this, "_ZN6S287C53v88Ev");}
void  S287C5 ::v89(){vfunc_called(this, "_ZN6S287C53v89Ev");}
void  S287C5 ::v90(){vfunc_called(this, "_ZN6S287C53v90Ev");}
void  S287C5 ::v91(){vfunc_called(this, "_ZN6S287C53v91Ev");}
void  S287C5 ::v92(){vfunc_called(this, "_ZN6S287C53v92Ev");}
void  S287C5 ::v93(){vfunc_called(this, "_ZN6S287C53v93Ev");}
void  S287C5 ::v94(){vfunc_called(this, "_ZN6S287C53v94Ev");}
S287C5 ::S287C5(){ note_ctor("S287C5", this);} // tgen

static void Test_S287C5()
{
  extern Class_Descriptor cd_S287C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S287C5, buf);
    S287C5 *dp, &lv = *(dp=new (buf) S287C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S287C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S287C5)");
    check_base_class_offset(lv, (S287C6*), 0, "S287C5");
    check_field_offset(lv, s287c5f0, ABISELECT(96,60), "S287C5.s287c5f0");
    check_field_offset(lv, s287c5f1, ABISELECT(104,68), "S287C5.s287c5f1");
    check_field_offset(lv, s287c5f2, ABISELECT(112,72), "S287C5.s287c5f2");
    check_field_offset(lv, s287c5f3, ABISELECT(120,80), "S287C5.s287c5f3");
    check_field_offset(lv, s287c5f4, ABISELECT(136,92), "S287C5.s287c5f4");
    check_field_offset(lv, s287c5f5, ABISELECT(152,104), "S287C5.s287c5f5");
    check_field_offset(lv, s287c5f6, ABISELECT(160,108), "S287C5.s287c5f6");
    set_bf_and_test(lv, s287c5f7, ABISELECT(176,120), 0, 1, 1, "S287C5");
    set_bf_and_test(lv, s287c5f8, ABISELECT(176,120), 1, 1, 1, "S287C5");
    set_bf_and_test(lv, s287c5f9, ABISELECT(176,120), 2, 1, 1, "S287C5");
    set_bf_and_test(lv, s287c5f10, ABISELECT(176,120), 3, 1, 1, "S287C5");
    set_bf_and_test(lv, s287c5f11, ABISELECT(176,120), 4, 1, 1, "S287C5");
    check_field_offset(lv, s287c5f12, ABISELECT(180,124), "S287C5.s287c5f12");
    test_class_info(&lv, &cd_S287C5);
    dp->~S287C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS287C5(Test_S287C5, "S287C5", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN6S287C5C1Ev();
extern void _ZN6S287C5D1Ev();
Name_Map name_map_S287C5[] = {
  NSPAIR(_ZN6S287C5C1Ev),
  NSPAIR(_ZN6S287C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S287C6;
extern VTBL_ENTRY _ZTI6S287C6[];
extern  VTBL_ENTRY _ZTV6S287C6[];
static Base_Class bases_S287C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S287C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S287C5[];
extern void _ZN6S287C5D1Ev();
extern void _ZN6S287C5D0Ev();
extern void _ZN6S287C62v9Ev();
extern void _ZN6S287C63v10Ev();
extern void _ZN6S287C63v11Ev();
extern void _ZN6S287C63v12Ev();
extern void _ZN6S287C63v13Ev();
extern void _ZN6S287C63v14Ev();
extern void _ZN6S287C63v15Ev();
extern void _ZN6S287C63v16Ev();
extern void _ZN6S287C63v17Ev();
extern void _ZN6S287C63v18Ev();
extern void _ZN6S287C63v19Ev();
extern void _ZN6S287C63v20Ev();
extern void _ZN6S287C63v21Ev();
extern void _ZN6S287C63v22Ev();
extern void _ZN6S287C63v23Ev();
extern void _ZN6S287C63v24Ev();
extern void _ZN6S287C63v25Ev();
extern void _ZN6S287C63v26Ev();
extern void _ZN6S287C63v27Ev();
extern void _ZN6S287C63v28Ev();
extern void _ZN6S287C63v29Ev();
extern void _ZN6S287C63v30Ev();
extern void _ZN6S287C63v31Ev();
extern void _ZN6S287C63v32Ev();
extern void _ZN6S287C63v33Ev();
extern void _ZN6S287C63v34Ev();
extern void _ZN6S287C63v35Ev();
extern void _ZN6S287C63v36Ev();
extern void _ZN6S287C63v37Ev();
extern void _ZN6S287C63v38Ev();
extern void _ZN6S287C63v39Ev();
extern void _ZN6S287C63v40Ev();
extern void _ZN6S287C63v41Ev();
extern void _ZN6S287C63v42Ev();
extern void _ZN6S287C63v43Ev();
extern void _ZN6S287C63v44Ev();
extern void _ZN6S287C63v45Ev();
extern void _ZN6S287C63v46Ev();
extern void _ZN6S287C63v47Ev();
extern void _ZN6S287C63v48Ev();
extern void _ZN6S287C63v49Ev();
extern void _ZN6S287C63v50Ev();
extern void _ZN6S287C63v51Ev();
extern void _ZN6S287C63v52Ev();
extern void _ZN6S287C63v53Ev();
extern void _ZN6S287C63v54Ev();
extern void _ZN6S287C63v55Ev();
extern void _ZN6S287C63v56Ev();
extern void _ZN6S287C63v57Ev();
extern void _ZN6S287C63v58Ev();
extern void _ZN6S287C63v59Ev();
extern void _ZN6S287C63v60Ev();
extern void _ZN6S287C63v61Ev();
extern void _ZN6S287C63v62Ev();
extern void _ZN6S287C63v63Ev();
extern void _ZN6S287C63v64Ev();
extern void _ZN6S287C63v65Ev();
extern void _ZN6S287C63v66Ev();
extern void _ZN6S287C63v67Ev();
extern void _ZN6S287C63v68Ev();
extern void _ZN6S287C63v69Ev();
extern void _ZN6S287C63v70Ev();
extern void _ZN6S287C63v71Ev();
extern void _ZN6S287C63v72Ev();
extern void _ZN6S287C53v73Ev();
extern void _ZN6S287C53v74Ev();
extern void _ZN6S287C53v75Ev();
extern void _ZN6S287C53v76Ev();
extern void _ZN6S287C53v77Ev();
extern void _ZN6S287C53v78Ev();
extern void _ZN6S287C53v79Ev();
extern void _ZN6S287C53v80Ev();
extern void _ZN6S287C53v81Ev();
extern void _ZN6S287C53v82Ev();
extern void _ZN6S287C53v83Ev();
extern void _ZN6S287C53v84Ev();
extern void _ZN6S287C53v85Ev();
extern void _ZN6S287C53v86Ev();
extern void _ZN6S287C53v87Ev();
extern void _ZN6S287C53v88Ev();
extern void _ZN6S287C53v89Ev();
extern void _ZN6S287C53v90Ev();
extern void _ZN6S287C53v91Ev();
extern void _ZN6S287C53v92Ev();
extern void _ZN6S287C53v93Ev();
extern void _ZN6S287C53v94Ev();
static  VTBL_ENTRY vtc_S287C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S287C5[0]),
  (VTBL_ENTRY)&_ZN6S287C5D1Ev,
  (VTBL_ENTRY)&_ZN6S287C5D0Ev,
  (VTBL_ENTRY)&_ZN6S287C62v9Ev,
  (VTBL_ENTRY)&_ZN6S287C63v10Ev,
  (VTBL_ENTRY)&_ZN6S287C63v11Ev,
  (VTBL_ENTRY)&_ZN6S287C63v12Ev,
  (VTBL_ENTRY)&_ZN6S287C63v13Ev,
  (VTBL_ENTRY)&_ZN6S287C63v14Ev,
  (VTBL_ENTRY)&_ZN6S287C63v15Ev,
  (VTBL_ENTRY)&_ZN6S287C63v16Ev,
  (VTBL_ENTRY)&_ZN6S287C63v17Ev,
  (VTBL_ENTRY)&_ZN6S287C63v18Ev,
  (VTBL_ENTRY)&_ZN6S287C63v19Ev,
  (VTBL_ENTRY)&_ZN6S287C63v20Ev,
  (VTBL_ENTRY)&_ZN6S287C63v21Ev,
  (VTBL_ENTRY)&_ZN6S287C63v22Ev,
  (VTBL_ENTRY)&_ZN6S287C63v23Ev,
  (VTBL_ENTRY)&_ZN6S287C63v24Ev,
  (VTBL_ENTRY)&_ZN6S287C63v25Ev,
  (VTBL_ENTRY)&_ZN6S287C63v26Ev,
  (VTBL_ENTRY)&_ZN6S287C63v27Ev,
  (VTBL_ENTRY)&_ZN6S287C63v28Ev,
  (VTBL_ENTRY)&_ZN6S287C63v29Ev,
  (VTBL_ENTRY)&_ZN6S287C63v30Ev,
  (VTBL_ENTRY)&_ZN6S287C63v31Ev,
  (VTBL_ENTRY)&_ZN6S287C63v32Ev,
  (VTBL_ENTRY)&_ZN6S287C63v33Ev,
  (VTBL_ENTRY)&_ZN6S287C63v34Ev,
  (VTBL_ENTRY)&_ZN6S287C63v35Ev,
  (VTBL_ENTRY)&_ZN6S287C63v36Ev,
  (VTBL_ENTRY)&_ZN6S287C63v37Ev,
  (VTBL_ENTRY)&_ZN6S287C63v38Ev,
  (VTBL_ENTRY)&_ZN6S287C63v39Ev,
  (VTBL_ENTRY)&_ZN6S287C63v40Ev,
  (VTBL_ENTRY)&_ZN6S287C63v41Ev,
  (VTBL_ENTRY)&_ZN6S287C63v42Ev,
  (VTBL_ENTRY)&_ZN6S287C63v43Ev,
  (VTBL_ENTRY)&_ZN6S287C63v44Ev,
  (VTBL_ENTRY)&_ZN6S287C63v45Ev,
  (VTBL_ENTRY)&_ZN6S287C63v46Ev,
  (VTBL_ENTRY)&_ZN6S287C63v47Ev,
  (VTBL_ENTRY)&_ZN6S287C63v48Ev,
  (VTBL_ENTRY)&_ZN6S287C63v49Ev,
  (VTBL_ENTRY)&_ZN6S287C63v50Ev,
  (VTBL_ENTRY)&_ZN6S287C63v51Ev,
  (VTBL_ENTRY)&_ZN6S287C63v52Ev,
  (VTBL_ENTRY)&_ZN6S287C63v53Ev,
  (VTBL_ENTRY)&_ZN6S287C63v54Ev,
  (VTBL_ENTRY)&_ZN6S287C63v55Ev,
  (VTBL_ENTRY)&_ZN6S287C63v56Ev,
  (VTBL_ENTRY)&_ZN6S287C63v57Ev,
  (VTBL_ENTRY)&_ZN6S287C63v58Ev,
  (VTBL_ENTRY)&_ZN6S287C63v59Ev,
  (VTBL_ENTRY)&_ZN6S287C63v60Ev,
  (VTBL_ENTRY)&_ZN6S287C63v61Ev,
  (VTBL_ENTRY)&_ZN6S287C63v62Ev,
  (VTBL_ENTRY)&_ZN6S287C63v63Ev,
  (VTBL_ENTRY)&_ZN6S287C63v64Ev,
  (VTBL_ENTRY)&_ZN6S287C63v65Ev,
  (VTBL_ENTRY)&_ZN6S287C63v66Ev,
  (VTBL_ENTRY)&_ZN6S287C63v67Ev,
  (VTBL_ENTRY)&_ZN6S287C63v68Ev,
  (VTBL_ENTRY)&_ZN6S287C63v69Ev,
  (VTBL_ENTRY)&_ZN6S287C63v70Ev,
  (VTBL_ENTRY)&_ZN6S287C63v71Ev,
  (VTBL_ENTRY)&_ZN6S287C63v72Ev,
  (VTBL_ENTRY)&_ZN6S287C53v73Ev,
  (VTBL_ENTRY)&_ZN6S287C53v74Ev,
  (VTBL_ENTRY)&_ZN6S287C53v75Ev,
  (VTBL_ENTRY)&_ZN6S287C53v76Ev,
  (VTBL_ENTRY)&_ZN6S287C53v77Ev,
  (VTBL_ENTRY)&_ZN6S287C53v78Ev,
  (VTBL_ENTRY)&_ZN6S287C53v79Ev,
  (VTBL_ENTRY)&_ZN6S287C53v80Ev,
  (VTBL_ENTRY)&_ZN6S287C53v81Ev,
  (VTBL_ENTRY)&_ZN6S287C53v82Ev,
  (VTBL_ENTRY)&_ZN6S287C53v83Ev,
  (VTBL_ENTRY)&_ZN6S287C53v84Ev,
  (VTBL_ENTRY)&_ZN6S287C53v85Ev,
  (VTBL_ENTRY)&_ZN6S287C53v86Ev,
  (VTBL_ENTRY)&_ZN6S287C53v87Ev,
  (VTBL_ENTRY)&_ZN6S287C53v88Ev,
  (VTBL_ENTRY)&_ZN6S287C53v89Ev,
  (VTBL_ENTRY)&_ZN6S287C53v90Ev,
  (VTBL_ENTRY)&_ZN6S287C53v91Ev,
  (VTBL_ENTRY)&_ZN6S287C53v92Ev,
  (VTBL_ENTRY)&_ZN6S287C53v93Ev,
  (VTBL_ENTRY)&_ZN6S287C53v94Ev,
};
extern VTBL_ENTRY _ZTI6S287C5[];
extern  VTBL_ENTRY _ZTV6S287C5[];
Class_Descriptor cd_S287C5 = {  "S287C5", // class name
  bases_S287C5, 1,
  &(vtc_S287C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI6S287C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S287C5),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S287C20  : S3350C7_nt {
};
//SIG(-1 S287C20) C1{ BC2{ m Fp Fi[2]}}



static void Test_S287C20()
{
  extern Class_Descriptor cd_S287C20;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S287C20, buf);
    S287C20 &lv = *(new (buf) S287C20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S287C20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S287C20)");
    check_base_class_offset(lv, (S3350C7_nt*), 0, "S287C20");
    test_class_info(&lv, &cd_S287C20);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS287C20(Test_S287C20, "S287C20", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3350C7_nt;
static Base_Class bases_S287C20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3350C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S287C20 = {  "S287C20", // class name
  bases_S287C20, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S287C19  : S287C20 {
};
//SIG(-1 S287C19) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S287C19()
{
  extern Class_Descriptor cd_S287C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S287C19, buf);
    S287C19 &lv = *(new (buf) S287C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S287C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S287C19)");
    check_base_class_offset(lv, (S3350C7_nt*)(S287C20*), 0, "S287C19");
    check_base_class_offset(lv, (S287C20*), 0, "S287C19");
    test_class_info(&lv, &cd_S287C19);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS287C19(Test_S287C19, "S287C19", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3350C7_nt;
extern Class_Descriptor cd_S287C20;
static Base_Class bases_S287C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3350C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S287C20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S287C19 = {  "S287C19", // class name
  bases_S287C19, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S287C4  : S287C5 {
  unsigned int s287c4f0:1;
  unsigned int s287c4f1:1;
  unsigned int s287c4f2:1;
  ::S3350C17 s287c4f3;
  ::S3350C11 s287c4f4;
  ::S3350C5_nt s287c4f5;
  ::S287C19 s287c4f6;
  int s287c4f7[3];
  virtual  ~S287C4(); // _ZN6S287C4D1Ev
  virtual void  v95(); // _ZN6S287C43v95Ev
  virtual void  v96(); // _ZN6S287C43v96Ev
  virtual void  v97(); // _ZN6S287C43v97Ev
  virtual void  v98(); // _ZN6S287C43v98Ev
  virtual void  v99(); // _ZN6S287C43v99Ev
  virtual void  v100(); // _ZN6S287C44v100Ev
  virtual void  v101(); // _ZN6S287C44v101Ev
  virtual void  v102(); // _ZN6S287C44v102Ev
  virtual void  v103(); // _ZN6S287C44v103Ev
  virtual void  v104(); // _ZN6S287C44v104Ev
  virtual void  v105(); // _ZN6S287C44v105Ev
  virtual void  v106(); // _ZN6S287C44v106Ev
  virtual void  v107(); // _ZN6S287C44v107Ev
  virtual void  v108(); // _ZN6S287C44v108Ev
  virtual void  v109(); // _ZN6S287C44v109Ev
  virtual void  v110(); // _ZN6S287C44v110Ev
  virtual void  v111(); // _ZN6S287C44v111Ev
  virtual void  v112(); // _ZN6S287C44v112Ev
  virtual void  v113(); // _ZN6S287C44v113Ev
  virtual void  v114(); // _ZN6S287C44v114Ev
  S287C4(); // tgen
};
//SIG(-1 S287C4) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} FC16{ BC17{ BC8}} Fi[3]}


 S287C4 ::~S287C4(){ note_dtor("S287C4", this);}
void  S287C4 ::v95(){vfunc_called(this, "_ZN6S287C43v95Ev");}
void  S287C4 ::v96(){vfunc_called(this, "_ZN6S287C43v96Ev");}
void  S287C4 ::v97(){vfunc_called(this, "_ZN6S287C43v97Ev");}
void  S287C4 ::v98(){vfunc_called(this, "_ZN6S287C43v98Ev");}
void  S287C4 ::v99(){vfunc_called(this, "_ZN6S287C43v99Ev");}
void  S287C4 ::v100(){vfunc_called(this, "_ZN6S287C44v100Ev");}
void  S287C4 ::v101(){vfunc_called(this, "_ZN6S287C44v101Ev");}
void  S287C4 ::v102(){vfunc_called(this, "_ZN6S287C44v102Ev");}
void  S287C4 ::v103(){vfunc_called(this, "_ZN6S287C44v103Ev");}
void  S287C4 ::v104(){vfunc_called(this, "_ZN6S287C44v104Ev");}
void  S287C4 ::v105(){vfunc_called(this, "_ZN6S287C44v105Ev");}
void  S287C4 ::v106(){vfunc_called(this, "_ZN6S287C44v106Ev");}
void  S287C4 ::v107(){vfunc_called(this, "_ZN6S287C44v107Ev");}
void  S287C4 ::v108(){vfunc_called(this, "_ZN6S287C44v108Ev");}
void  S287C4 ::v109(){vfunc_called(this, "_ZN6S287C44v109Ev");}
void  S287C4 ::v110(){vfunc_called(this, "_ZN6S287C44v110Ev");}
void  S287C4 ::v111(){vfunc_called(this, "_ZN6S287C44v111Ev");}
void  S287C4 ::v112(){vfunc_called(this, "_ZN6S287C44v112Ev");}
void  S287C4 ::v113(){vfunc_called(this, "_ZN6S287C44v113Ev");}
void  S287C4 ::v114(){vfunc_called(this, "_ZN6S287C44v114Ev");}
S287C4 ::S287C4(){ note_ctor("S287C4", this);} // tgen

static void Test_S287C4()
{
  extern Class_Descriptor cd_S287C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(35,50)];
    init_test(&cd_S287C4, buf);
    S287C4 *dp, &lv = *(dp=new (buf) S287C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,196), "sizeof(S287C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S287C4)");
    check_base_class_offset(lv, (S287C6*)(S287C5*), 0, "S287C4");
    check_base_class_offset(lv, (S287C5*), 0, "S287C4");
    set_bf_and_test(lv, s287c4f0, ABISELECT(188,132), 0, 1, 1, "S287C4");
    set_bf_and_test(lv, s287c4f1, ABISELECT(188,132), 1, 1, 1, "S287C4");
    set_bf_and_test(lv, s287c4f2, ABISELECT(188,132), 2, 1, 1, "S287C4");
    check_field_offset(lv, s287c4f3, ABISELECT(192,136), "S287C4.s287c4f3");
    check_field_offset(lv, s287c4f4, ABISELECT(208,148), "S287C4.s287c4f4");
    check_field_offset(lv, s287c4f5, ABISELECT(224,160), "S287C4.s287c4f5");
    check_field_offset(lv, s287c4f6, ABISELECT(240,172), "S287C4.s287c4f6");
    check_field_offset(lv, s287c4f7, ABISELECT(256,184), "S287C4.s287c4f7");
    test_class_info(&lv, &cd_S287C4);
    dp->~S287C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS287C4(Test_S287C4, "S287C4", ABISELECT(272,196));

#else // __cplusplus

extern void _ZN6S287C4C1Ev();
extern void _ZN6S287C4D1Ev();
Name_Map name_map_S287C4[] = {
  NSPAIR(_ZN6S287C4C1Ev),
  NSPAIR(_ZN6S287C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S287C6;
extern VTBL_ENTRY _ZTI6S287C6[];
extern  VTBL_ENTRY _ZTV6S287C6[];
extern Class_Descriptor cd_S287C5;
extern VTBL_ENTRY _ZTI6S287C5[];
extern  VTBL_ENTRY _ZTV6S287C5[];
static Base_Class bases_S287C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S287C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S287C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S287C4[];
extern void _ZN6S287C4D1Ev();
extern void _ZN6S287C4D0Ev();
extern void _ZN6S287C62v9Ev();
extern void _ZN6S287C63v10Ev();
extern void _ZN6S287C63v11Ev();
extern void _ZN6S287C63v12Ev();
extern void _ZN6S287C63v13Ev();
extern void _ZN6S287C63v14Ev();
extern void _ZN6S287C63v15Ev();
extern void _ZN6S287C63v16Ev();
extern void _ZN6S287C63v17Ev();
extern void _ZN6S287C63v18Ev();
extern void _ZN6S287C63v19Ev();
extern void _ZN6S287C63v20Ev();
extern void _ZN6S287C63v21Ev();
extern void _ZN6S287C63v22Ev();
extern void _ZN6S287C63v23Ev();
extern void _ZN6S287C63v24Ev();
extern void _ZN6S287C63v25Ev();
extern void _ZN6S287C63v26Ev();
extern void _ZN6S287C63v27Ev();
extern void _ZN6S287C63v28Ev();
extern void _ZN6S287C63v29Ev();
extern void _ZN6S287C63v30Ev();
extern void _ZN6S287C63v31Ev();
extern void _ZN6S287C63v32Ev();
extern void _ZN6S287C63v33Ev();
extern void _ZN6S287C63v34Ev();
extern void _ZN6S287C63v35Ev();
extern void _ZN6S287C63v36Ev();
extern void _ZN6S287C63v37Ev();
extern void _ZN6S287C63v38Ev();
extern void _ZN6S287C63v39Ev();
extern void _ZN6S287C63v40Ev();
extern void _ZN6S287C63v41Ev();
extern void _ZN6S287C63v42Ev();
extern void _ZN6S287C63v43Ev();
extern void _ZN6S287C63v44Ev();
extern void _ZN6S287C63v45Ev();
extern void _ZN6S287C63v46Ev();
extern void _ZN6S287C63v47Ev();
extern void _ZN6S287C63v48Ev();
extern void _ZN6S287C63v49Ev();
extern void _ZN6S287C63v50Ev();
extern void _ZN6S287C63v51Ev();
extern void _ZN6S287C63v52Ev();
extern void _ZN6S287C63v53Ev();
extern void _ZN6S287C63v54Ev();
extern void _ZN6S287C63v55Ev();
extern void _ZN6S287C63v56Ev();
extern void _ZN6S287C63v57Ev();
extern void _ZN6S287C63v58Ev();
extern void _ZN6S287C63v59Ev();
extern void _ZN6S287C63v60Ev();
extern void _ZN6S287C63v61Ev();
extern void _ZN6S287C63v62Ev();
extern void _ZN6S287C63v63Ev();
extern void _ZN6S287C63v64Ev();
extern void _ZN6S287C63v65Ev();
extern void _ZN6S287C63v66Ev();
extern void _ZN6S287C63v67Ev();
extern void _ZN6S287C63v68Ev();
extern void _ZN6S287C63v69Ev();
extern void _ZN6S287C63v70Ev();
extern void _ZN6S287C63v71Ev();
extern void _ZN6S287C63v72Ev();
extern void _ZN6S287C53v73Ev();
extern void _ZN6S287C53v74Ev();
extern void _ZN6S287C53v75Ev();
extern void _ZN6S287C53v76Ev();
extern void _ZN6S287C53v77Ev();
extern void _ZN6S287C53v78Ev();
extern void _ZN6S287C53v79Ev();
extern void _ZN6S287C53v80Ev();
extern void _ZN6S287C53v81Ev();
extern void _ZN6S287C53v82Ev();
extern void _ZN6S287C53v83Ev();
extern void _ZN6S287C53v84Ev();
extern void _ZN6S287C53v85Ev();
extern void _ZN6S287C53v86Ev();
extern void _ZN6S287C53v87Ev();
extern void _ZN6S287C53v88Ev();
extern void _ZN6S287C53v89Ev();
extern void _ZN6S287C53v90Ev();
extern void _ZN6S287C53v91Ev();
extern void _ZN6S287C53v92Ev();
extern void _ZN6S287C53v93Ev();
extern void _ZN6S287C53v94Ev();
extern void _ZN6S287C43v95Ev();
extern void _ZN6S287C43v96Ev();
extern void _ZN6S287C43v97Ev();
extern void _ZN6S287C43v98Ev();
extern void _ZN6S287C43v99Ev();
extern void _ZN6S287C44v100Ev();
extern void _ZN6S287C44v101Ev();
extern void _ZN6S287C44v102Ev();
extern void _ZN6S287C44v103Ev();
extern void _ZN6S287C44v104Ev();
extern void _ZN6S287C44v105Ev();
extern void _ZN6S287C44v106Ev();
extern void _ZN6S287C44v107Ev();
extern void _ZN6S287C44v108Ev();
extern void _ZN6S287C44v109Ev();
extern void _ZN6S287C44v110Ev();
extern void _ZN6S287C44v111Ev();
extern void _ZN6S287C44v112Ev();
extern void _ZN6S287C44v113Ev();
extern void _ZN6S287C44v114Ev();
static  VTBL_ENTRY vtc_S287C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S287C4[0]),
  (VTBL_ENTRY)&_ZN6S287C4D1Ev,
  (VTBL_ENTRY)&_ZN6S287C4D0Ev,
  (VTBL_ENTRY)&_ZN6S287C62v9Ev,
  (VTBL_ENTRY)&_ZN6S287C63v10Ev,
  (VTBL_ENTRY)&_ZN6S287C63v11Ev,
  (VTBL_ENTRY)&_ZN6S287C63v12Ev,
  (VTBL_ENTRY)&_ZN6S287C63v13Ev,
  (VTBL_ENTRY)&_ZN6S287C63v14Ev,
  (VTBL_ENTRY)&_ZN6S287C63v15Ev,
  (VTBL_ENTRY)&_ZN6S287C63v16Ev,
  (VTBL_ENTRY)&_ZN6S287C63v17Ev,
  (VTBL_ENTRY)&_ZN6S287C63v18Ev,
  (VTBL_ENTRY)&_ZN6S287C63v19Ev,
  (VTBL_ENTRY)&_ZN6S287C63v20Ev,
  (VTBL_ENTRY)&_ZN6S287C63v21Ev,
  (VTBL_ENTRY)&_ZN6S287C63v22Ev,
  (VTBL_ENTRY)&_ZN6S287C63v23Ev,
  (VTBL_ENTRY)&_ZN6S287C63v24Ev,
  (VTBL_ENTRY)&_ZN6S287C63v25Ev,
  (VTBL_ENTRY)&_ZN6S287C63v26Ev,
  (VTBL_ENTRY)&_ZN6S287C63v27Ev,
  (VTBL_ENTRY)&_ZN6S287C63v28Ev,
  (VTBL_ENTRY)&_ZN6S287C63v29Ev,
  (VTBL_ENTRY)&_ZN6S287C63v30Ev,
  (VTBL_ENTRY)&_ZN6S287C63v31Ev,
  (VTBL_ENTRY)&_ZN6S287C63v32Ev,
  (VTBL_ENTRY)&_ZN6S287C63v33Ev,
  (VTBL_ENTRY)&_ZN6S287C63v34Ev,
  (VTBL_ENTRY)&_ZN6S287C63v35Ev,
  (VTBL_ENTRY)&_ZN6S287C63v36Ev,
  (VTBL_ENTRY)&_ZN6S287C63v37Ev,
  (VTBL_ENTRY)&_ZN6S287C63v38Ev,
  (VTBL_ENTRY)&_ZN6S287C63v39Ev,
  (VTBL_ENTRY)&_ZN6S287C63v40Ev,
  (VTBL_ENTRY)&_ZN6S287C63v41Ev,
  (VTBL_ENTRY)&_ZN6S287C63v42Ev,
  (VTBL_ENTRY)&_ZN6S287C63v43Ev,
  (VTBL_ENTRY)&_ZN6S287C63v44Ev,
  (VTBL_ENTRY)&_ZN6S287C63v45Ev,
  (VTBL_ENTRY)&_ZN6S287C63v46Ev,
  (VTBL_ENTRY)&_ZN6S287C63v47Ev,
  (VTBL_ENTRY)&_ZN6S287C63v48Ev,
  (VTBL_ENTRY)&_ZN6S287C63v49Ev,
  (VTBL_ENTRY)&_ZN6S287C63v50Ev,
  (VTBL_ENTRY)&_ZN6S287C63v51Ev,
  (VTBL_ENTRY)&_ZN6S287C63v52Ev,
  (VTBL_ENTRY)&_ZN6S287C63v53Ev,
  (VTBL_ENTRY)&_ZN6S287C63v54Ev,
  (VTBL_ENTRY)&_ZN6S287C63v55Ev,
  (VTBL_ENTRY)&_ZN6S287C63v56Ev,
  (VTBL_ENTRY)&_ZN6S287C63v57Ev,
  (VTBL_ENTRY)&_ZN6S287C63v58Ev,
  (VTBL_ENTRY)&_ZN6S287C63v59Ev,
  (VTBL_ENTRY)&_ZN6S287C63v60Ev,
  (VTBL_ENTRY)&_ZN6S287C63v61Ev,
  (VTBL_ENTRY)&_ZN6S287C63v62Ev,
  (VTBL_ENTRY)&_ZN6S287C63v63Ev,
  (VTBL_ENTRY)&_ZN6S287C63v64Ev,
  (VTBL_ENTRY)&_ZN6S287C63v65Ev,
  (VTBL_ENTRY)&_ZN6S287C63v66Ev,
  (VTBL_ENTRY)&_ZN6S287C63v67Ev,
  (VTBL_ENTRY)&_ZN6S287C63v68Ev,
  (VTBL_ENTRY)&_ZN6S287C63v69Ev,
  (VTBL_ENTRY)&_ZN6S287C63v70Ev,
  (VTBL_ENTRY)&_ZN6S287C63v71Ev,
  (VTBL_ENTRY)&_ZN6S287C63v72Ev,
  (VTBL_ENTRY)&_ZN6S287C53v73Ev,
  (VTBL_ENTRY)&_ZN6S287C53v74Ev,
  (VTBL_ENTRY)&_ZN6S287C53v75Ev,
  (VTBL_ENTRY)&_ZN6S287C53v76Ev,
  (VTBL_ENTRY)&_ZN6S287C53v77Ev,
  (VTBL_ENTRY)&_ZN6S287C53v78Ev,
  (VTBL_ENTRY)&_ZN6S287C53v79Ev,
  (VTBL_ENTRY)&_ZN6S287C53v80Ev,
  (VTBL_ENTRY)&_ZN6S287C53v81Ev,
  (VTBL_ENTRY)&_ZN6S287C53v82Ev,
  (VTBL_ENTRY)&_ZN6S287C53v83Ev,
  (VTBL_ENTRY)&_ZN6S287C53v84Ev,
  (VTBL_ENTRY)&_ZN6S287C53v85Ev,
  (VTBL_ENTRY)&_ZN6S287C53v86Ev,
  (VTBL_ENTRY)&_ZN6S287C53v87Ev,
  (VTBL_ENTRY)&_ZN6S287C53v88Ev,
  (VTBL_ENTRY)&_ZN6S287C53v89Ev,
  (VTBL_ENTRY)&_ZN6S287C53v90Ev,
  (VTBL_ENTRY)&_ZN6S287C53v91Ev,
  (VTBL_ENTRY)&_ZN6S287C53v92Ev,
  (VTBL_ENTRY)&_ZN6S287C53v93Ev,
  (VTBL_ENTRY)&_ZN6S287C53v94Ev,
  (VTBL_ENTRY)&_ZN6S287C43v95Ev,
  (VTBL_ENTRY)&_ZN6S287C43v96Ev,
  (VTBL_ENTRY)&_ZN6S287C43v97Ev,
  (VTBL_ENTRY)&_ZN6S287C43v98Ev,
  (VTBL_ENTRY)&_ZN6S287C43v99Ev,
  (VTBL_ENTRY)&_ZN6S287C44v100Ev,
  (VTBL_ENTRY)&_ZN6S287C44v101Ev,
  (VTBL_ENTRY)&_ZN6S287C44v102Ev,
  (VTBL_ENTRY)&_ZN6S287C44v103Ev,
  (VTBL_ENTRY)&_ZN6S287C44v104Ev,
  (VTBL_ENTRY)&_ZN6S287C44v105Ev,
  (VTBL_ENTRY)&_ZN6S287C44v106Ev,
  (VTBL_ENTRY)&_ZN6S287C44v107Ev,
  (VTBL_ENTRY)&_ZN6S287C44v108Ev,
  (VTBL_ENTRY)&_ZN6S287C44v109Ev,
  (VTBL_ENTRY)&_ZN6S287C44v110Ev,
  (VTBL_ENTRY)&_ZN6S287C44v111Ev,
  (VTBL_ENTRY)&_ZN6S287C44v112Ev,
  (VTBL_ENTRY)&_ZN6S287C44v113Ev,
  (VTBL_ENTRY)&_ZN6S287C44v114Ev,
};
extern VTBL_ENTRY _ZTI6S287C4[];
extern  VTBL_ENTRY _ZTV6S287C4[];
Class_Descriptor cd_S287C4 = {  "S287C4", // class name
  bases_S287C4, 2,
  &(vtc_S287C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI6S287C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S287C4),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S287C24  : S3350C7_nt {
};
//SIG(-1 S287C24) C1{ BC2{ m Fp Fi[2]}}



static void Test_S287C24()
{
  extern Class_Descriptor cd_S287C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S287C24, buf);
    S287C24 &lv = *(new (buf) S287C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S287C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S287C24)");
    check_base_class_offset(lv, (S3350C7_nt*), 0, "S287C24");
    test_class_info(&lv, &cd_S287C24);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS287C24(Test_S287C24, "S287C24", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3350C7_nt;
static Base_Class bases_S287C24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3350C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S287C24 = {  "S287C24", // class name
  bases_S287C24, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S287C23  : S287C24 {
};
//SIG(-1 S287C23) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S287C23()
{
  extern Class_Descriptor cd_S287C23;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S287C23, buf);
    S287C23 &lv = *(new (buf) S287C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S287C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S287C23)");
    check_base_class_offset(lv, (S3350C7_nt*)(S287C24*), 0, "S287C23");
    check_base_class_offset(lv, (S287C24*), 0, "S287C23");
    test_class_info(&lv, &cd_S287C23);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS287C23(Test_S287C23, "S287C23", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3350C7_nt;
extern Class_Descriptor cd_S287C24;
static Base_Class bases_S287C23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3350C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S287C24,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S287C23 = {  "S287C23", // class name
  bases_S287C23, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S287C28  : S3350C7_nt {
};
//SIG(-1 S287C28) C1{ BC2{ m Fp Fi[2]}}



static void Test_S287C28()
{
  extern Class_Descriptor cd_S287C28;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S287C28, buf);
    S287C28 &lv = *(new (buf) S287C28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S287C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S287C28)");
    check_base_class_offset(lv, (S3350C7_nt*), 0, "S287C28");
    test_class_info(&lv, &cd_S287C28);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS287C28(Test_S287C28, "S287C28", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3350C7_nt;
static Base_Class bases_S287C28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3350C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S287C28 = {  "S287C28", // class name
  bases_S287C28, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S287C27  : S287C28 {
};
//SIG(-1 S287C27) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S287C27()
{
  extern Class_Descriptor cd_S287C27;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S287C27, buf);
    S287C27 &lv = *(new (buf) S287C27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S287C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S287C27)");
    check_base_class_offset(lv, (S3350C7_nt*)(S287C28*), 0, "S287C27");
    check_base_class_offset(lv, (S287C28*), 0, "S287C27");
    test_class_info(&lv, &cd_S287C27);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS287C27(Test_S287C27, "S287C27", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3350C7_nt;
extern Class_Descriptor cd_S287C28;
static Base_Class bases_S287C27[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3350C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S287C28,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S287C27 = {  "S287C27", // class name
  bases_S287C27, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S287C3  : S287C4 {
  void *s287c3f0;
  ::S287C19 s287c3f1;
  ::S287C23 s287c3f2;
  ::S287C23 s287c3f3;
  ::S287C27 s287c3f4;
  ::S287C27 s287c3f5;
  unsigned int s287c3f6:1;
  int s287c3f7[3];
  virtual  ~S287C3(); // _ZN6S287C3D1Ev
  virtual void  v115(); // _ZN6S287C34v115Ev
  virtual void  v116(); // _ZN6S287C34v116Ev
  virtual void  v117(); // _ZN6S287C34v117Ev
  virtual void  v118(); // _ZN6S287C34v118Ev
  virtual void  v119(); // _ZN6S287C34v119Ev
  virtual void  v120(); // _ZN6S287C34v120Ev
  virtual void  v121(); // _ZN6S287C34v121Ev
  virtual void  v122(); // _ZN6S287C34v122Ev
  virtual void  v123(); // _ZN6S287C34v123Ev
  virtual void  v124(); // _ZN6S287C34v124Ev
  virtual void  v125(); // _ZN6S287C34v125Ev
  virtual void  v126(); // _ZN6S287C34v126Ev
  virtual void  v127(); // _ZN6S287C34v127Ev
  virtual void  v128(); // _ZN6S287C34v128Ev
  virtual void  v129(); // _ZN6S287C34v129Ev
  virtual void  v130(); // _ZN6S287C34v130Ev
  virtual void  v131(); // _ZN6S287C34v131Ev
  virtual void  v132(); // _ZN6S287C34v132Ev
  virtual void  v133(); // _ZN6S287C34v133Ev
  virtual void  v134(); // _ZN6S287C34v134Ev
  virtual void  v135(); // _ZN6S287C34v135Ev
  virtual void  v136(); // _ZN6S287C34v136Ev
  S287C3(); // tgen
};
//SIG(-1 S287C3) C1{ BC2{ BC3{ BC4{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} FC17{ BC18{ BC9}} Fi[3]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp FC17 FC19{ BC20{ BC9}} FC19 FC21{ BC22{ BC9}} FC21 Fi:1 Fi[3]}


 S287C3 ::~S287C3(){ note_dtor("S287C3", this);}
void  S287C3 ::v115(){vfunc_called(this, "_ZN6S287C34v115Ev");}
void  S287C3 ::v116(){vfunc_called(this, "_ZN6S287C34v116Ev");}
void  S287C3 ::v117(){vfunc_called(this, "_ZN6S287C34v117Ev");}
void  S287C3 ::v118(){vfunc_called(this, "_ZN6S287C34v118Ev");}
void  S287C3 ::v119(){vfunc_called(this, "_ZN6S287C34v119Ev");}
void  S287C3 ::v120(){vfunc_called(this, "_ZN6S287C34v120Ev");}
void  S287C3 ::v121(){vfunc_called(this, "_ZN6S287C34v121Ev");}
void  S287C3 ::v122(){vfunc_called(this, "_ZN6S287C34v122Ev");}
void  S287C3 ::v123(){vfunc_called(this, "_ZN6S287C34v123Ev");}
void  S287C3 ::v124(){vfunc_called(this, "_ZN6S287C34v124Ev");}
void  S287C3 ::v125(){vfunc_called(this, "_ZN6S287C34v125Ev");}
void  S287C3 ::v126(){vfunc_called(this, "_ZN6S287C34v126Ev");}
void  S287C3 ::v127(){vfunc_called(this, "_ZN6S287C34v127Ev");}
void  S287C3 ::v128(){vfunc_called(this, "_ZN6S287C34v128Ev");}
void  S287C3 ::v129(){vfunc_called(this, "_ZN6S287C34v129Ev");}
void  S287C3 ::v130(){vfunc_called(this, "_ZN6S287C34v130Ev");}
void  S287C3 ::v131(){vfunc_called(this, "_ZN6S287C34v131Ev");}
void  S287C3 ::v132(){vfunc_called(this, "_ZN6S287C34v132Ev");}
void  S287C3 ::v133(){vfunc_called(this, "_ZN6S287C34v133Ev");}
void  S287C3 ::v134(){vfunc_called(this, "_ZN6S287C34v134Ev");}
void  S287C3 ::v135(){vfunc_called(this, "_ZN6S287C34v135Ev");}
void  S287C3 ::v136(){vfunc_called(this, "_ZN6S287C34v136Ev");}
S287C3 ::S287C3(){ note_ctor("S287C3", this);} // tgen

static void Test_S287C3()
{
  extern Class_Descriptor cd_S287C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(48,70)];
    init_test(&cd_S287C3, buf);
    S287C3 *dp, &lv = *(dp=new (buf) S287C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(376,276), "sizeof(S287C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S287C3)");
    check_base_class_offset(lv, (S287C6*)(S287C5*)(S287C4*), 0, "S287C3");
    check_base_class_offset(lv, (S287C5*)(S287C4*), 0, "S287C3");
    check_base_class_offset(lv, (S287C4*), 0, "S287C3");
    check_field_offset(lv, s287c3f0, ABISELECT(272,196), "S287C3.s287c3f0");
    check_field_offset(lv, s287c3f1, ABISELECT(280,200), "S287C3.s287c3f1");
    check_field_offset(lv, s287c3f2, ABISELECT(296,212), "S287C3.s287c3f2");
    check_field_offset(lv, s287c3f3, ABISELECT(312,224), "S287C3.s287c3f3");
    check_field_offset(lv, s287c3f4, ABISELECT(328,236), "S287C3.s287c3f4");
    check_field_offset(lv, s287c3f5, ABISELECT(344,248), "S287C3.s287c3f5");
    set_bf_and_test(lv, s287c3f6, ABISELECT(360,260), 0, 1, 1, "S287C3");
    check_field_offset(lv, s287c3f7, ABISELECT(364,264), "S287C3.s287c3f7");
    test_class_info(&lv, &cd_S287C3);
    dp->~S287C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS287C3(Test_S287C3, "S287C3", ABISELECT(376,276));

#else // __cplusplus

extern void _ZN6S287C3C1Ev();
extern void _ZN6S287C3D1Ev();
Name_Map name_map_S287C3[] = {
  NSPAIR(_ZN6S287C3C1Ev),
  NSPAIR(_ZN6S287C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S287C6;
extern VTBL_ENTRY _ZTI6S287C6[];
extern  VTBL_ENTRY _ZTV6S287C6[];
extern Class_Descriptor cd_S287C5;
extern VTBL_ENTRY _ZTI6S287C5[];
extern  VTBL_ENTRY _ZTV6S287C5[];
extern Class_Descriptor cd_S287C4;
extern VTBL_ENTRY _ZTI6S287C4[];
extern  VTBL_ENTRY _ZTV6S287C4[];
static Base_Class bases_S287C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S287C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S287C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S287C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S287C3[];
extern void _ZN6S287C3D1Ev();
extern void _ZN6S287C3D0Ev();
extern void _ZN6S287C62v9Ev();
extern void _ZN6S287C63v10Ev();
extern void _ZN6S287C63v11Ev();
extern void _ZN6S287C63v12Ev();
extern void _ZN6S287C63v13Ev();
extern void _ZN6S287C63v14Ev();
extern void _ZN6S287C63v15Ev();
extern void _ZN6S287C63v16Ev();
extern void _ZN6S287C63v17Ev();
extern void _ZN6S287C63v18Ev();
extern void _ZN6S287C63v19Ev();
extern void _ZN6S287C63v20Ev();
extern void _ZN6S287C63v21Ev();
extern void _ZN6S287C63v22Ev();
extern void _ZN6S287C63v23Ev();
extern void _ZN6S287C63v24Ev();
extern void _ZN6S287C63v25Ev();
extern void _ZN6S287C63v26Ev();
extern void _ZN6S287C63v27Ev();
extern void _ZN6S287C63v28Ev();
extern void _ZN6S287C63v29Ev();
extern void _ZN6S287C63v30Ev();
extern void _ZN6S287C63v31Ev();
extern void _ZN6S287C63v32Ev();
extern void _ZN6S287C63v33Ev();
extern void _ZN6S287C63v34Ev();
extern void _ZN6S287C63v35Ev();
extern void _ZN6S287C63v36Ev();
extern void _ZN6S287C63v37Ev();
extern void _ZN6S287C63v38Ev();
extern void _ZN6S287C63v39Ev();
extern void _ZN6S287C63v40Ev();
extern void _ZN6S287C63v41Ev();
extern void _ZN6S287C63v42Ev();
extern void _ZN6S287C63v43Ev();
extern void _ZN6S287C63v44Ev();
extern void _ZN6S287C63v45Ev();
extern void _ZN6S287C63v46Ev();
extern void _ZN6S287C63v47Ev();
extern void _ZN6S287C63v48Ev();
extern void _ZN6S287C63v49Ev();
extern void _ZN6S287C63v50Ev();
extern void _ZN6S287C63v51Ev();
extern void _ZN6S287C63v52Ev();
extern void _ZN6S287C63v53Ev();
extern void _ZN6S287C63v54Ev();
extern void _ZN6S287C63v55Ev();
extern void _ZN6S287C63v56Ev();
extern void _ZN6S287C63v57Ev();
extern void _ZN6S287C63v58Ev();
extern void _ZN6S287C63v59Ev();
extern void _ZN6S287C63v60Ev();
extern void _ZN6S287C63v61Ev();
extern void _ZN6S287C63v62Ev();
extern void _ZN6S287C63v63Ev();
extern void _ZN6S287C63v64Ev();
extern void _ZN6S287C63v65Ev();
extern void _ZN6S287C63v66Ev();
extern void _ZN6S287C63v67Ev();
extern void _ZN6S287C63v68Ev();
extern void _ZN6S287C63v69Ev();
extern void _ZN6S287C63v70Ev();
extern void _ZN6S287C63v71Ev();
extern void _ZN6S287C63v72Ev();
extern void _ZN6S287C53v73Ev();
extern void _ZN6S287C53v74Ev();
extern void _ZN6S287C53v75Ev();
extern void _ZN6S287C53v76Ev();
extern void _ZN6S287C53v77Ev();
extern void _ZN6S287C53v78Ev();
extern void _ZN6S287C53v79Ev();
extern void _ZN6S287C53v80Ev();
extern void _ZN6S287C53v81Ev();
extern void _ZN6S287C53v82Ev();
extern void _ZN6S287C53v83Ev();
extern void _ZN6S287C53v84Ev();
extern void _ZN6S287C53v85Ev();
extern void _ZN6S287C53v86Ev();
extern void _ZN6S287C53v87Ev();
extern void _ZN6S287C53v88Ev();
extern void _ZN6S287C53v89Ev();
extern void _ZN6S287C53v90Ev();
extern void _ZN6S287C53v91Ev();
extern void _ZN6S287C53v92Ev();
extern void _ZN6S287C53v93Ev();
extern void _ZN6S287C53v94Ev();
extern void _ZN6S287C43v95Ev();
extern void _ZN6S287C43v96Ev();
extern void _ZN6S287C43v97Ev();
extern void _ZN6S287C43v98Ev();
extern void _ZN6S287C43v99Ev();
extern void _ZN6S287C44v100Ev();
extern void _ZN6S287C44v101Ev();
extern void _ZN6S287C44v102Ev();
extern void _ZN6S287C44v103Ev();
extern void _ZN6S287C44v104Ev();
extern void _ZN6S287C44v105Ev();
extern void _ZN6S287C44v106Ev();
extern void _ZN6S287C44v107Ev();
extern void _ZN6S287C44v108Ev();
extern void _ZN6S287C44v109Ev();
extern void _ZN6S287C44v110Ev();
extern void _ZN6S287C44v111Ev();
extern void _ZN6S287C44v112Ev();
extern void _ZN6S287C44v113Ev();
extern void _ZN6S287C44v114Ev();
extern void _ZN6S287C34v115Ev();
extern void _ZN6S287C34v116Ev();
extern void _ZN6S287C34v117Ev();
extern void _ZN6S287C34v118Ev();
extern void _ZN6S287C34v119Ev();
extern void _ZN6S287C34v120Ev();
extern void _ZN6S287C34v121Ev();
extern void _ZN6S287C34v122Ev();
extern void _ZN6S287C34v123Ev();
extern void _ZN6S287C34v124Ev();
extern void _ZN6S287C34v125Ev();
extern void _ZN6S287C34v126Ev();
extern void _ZN6S287C34v127Ev();
extern void _ZN6S287C34v128Ev();
extern void _ZN6S287C34v129Ev();
extern void _ZN6S287C34v130Ev();
extern void _ZN6S287C34v131Ev();
extern void _ZN6S287C34v132Ev();
extern void _ZN6S287C34v133Ev();
extern void _ZN6S287C34v134Ev();
extern void _ZN6S287C34v135Ev();
extern void _ZN6S287C34v136Ev();
static  VTBL_ENTRY vtc_S287C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S287C3[0]),
  (VTBL_ENTRY)&_ZN6S287C3D1Ev,
  (VTBL_ENTRY)&_ZN6S287C3D0Ev,
  (VTBL_ENTRY)&_ZN6S287C62v9Ev,
  (VTBL_ENTRY)&_ZN6S287C63v10Ev,
  (VTBL_ENTRY)&_ZN6S287C63v11Ev,
  (VTBL_ENTRY)&_ZN6S287C63v12Ev,
  (VTBL_ENTRY)&_ZN6S287C63v13Ev,
  (VTBL_ENTRY)&_ZN6S287C63v14Ev,
  (VTBL_ENTRY)&_ZN6S287C63v15Ev,
  (VTBL_ENTRY)&_ZN6S287C63v16Ev,
  (VTBL_ENTRY)&_ZN6S287C63v17Ev,
  (VTBL_ENTRY)&_ZN6S287C63v18Ev,
  (VTBL_ENTRY)&_ZN6S287C63v19Ev,
  (VTBL_ENTRY)&_ZN6S287C63v20Ev,
  (VTBL_ENTRY)&_ZN6S287C63v21Ev,
  (VTBL_ENTRY)&_ZN6S287C63v22Ev,
  (VTBL_ENTRY)&_ZN6S287C63v23Ev,
  (VTBL_ENTRY)&_ZN6S287C63v24Ev,
  (VTBL_ENTRY)&_ZN6S287C63v25Ev,
  (VTBL_ENTRY)&_ZN6S287C63v26Ev,
  (VTBL_ENTRY)&_ZN6S287C63v27Ev,
  (VTBL_ENTRY)&_ZN6S287C63v28Ev,
  (VTBL_ENTRY)&_ZN6S287C63v29Ev,
  (VTBL_ENTRY)&_ZN6S287C63v30Ev,
  (VTBL_ENTRY)&_ZN6S287C63v31Ev,
  (VTBL_ENTRY)&_ZN6S287C63v32Ev,
  (VTBL_ENTRY)&_ZN6S287C63v33Ev,
  (VTBL_ENTRY)&_ZN6S287C63v34Ev,
  (VTBL_ENTRY)&_ZN6S287C63v35Ev,
  (VTBL_ENTRY)&_ZN6S287C63v36Ev,
  (VTBL_ENTRY)&_ZN6S287C63v37Ev,
  (VTBL_ENTRY)&_ZN6S287C63v38Ev,
  (VTBL_ENTRY)&_ZN6S287C63v39Ev,
  (VTBL_ENTRY)&_ZN6S287C63v40Ev,
  (VTBL_ENTRY)&_ZN6S287C63v41Ev,
  (VTBL_ENTRY)&_ZN6S287C63v42Ev,
  (VTBL_ENTRY)&_ZN6S287C63v43Ev,
  (VTBL_ENTRY)&_ZN6S287C63v44Ev,
  (VTBL_ENTRY)&_ZN6S287C63v45Ev,
  (VTBL_ENTRY)&_ZN6S287C63v46Ev,
  (VTBL_ENTRY)&_ZN6S287C63v47Ev,
  (VTBL_ENTRY)&_ZN6S287C63v48Ev,
  (VTBL_ENTRY)&_ZN6S287C63v49Ev,
  (VTBL_ENTRY)&_ZN6S287C63v50Ev,
  (VTBL_ENTRY)&_ZN6S287C63v51Ev,
  (VTBL_ENTRY)&_ZN6S287C63v52Ev,
  (VTBL_ENTRY)&_ZN6S287C63v53Ev,
  (VTBL_ENTRY)&_ZN6S287C63v54Ev,
  (VTBL_ENTRY)&_ZN6S287C63v55Ev,
  (VTBL_ENTRY)&_ZN6S287C63v56Ev,
  (VTBL_ENTRY)&_ZN6S287C63v57Ev,
  (VTBL_ENTRY)&_ZN6S287C63v58Ev,
  (VTBL_ENTRY)&_ZN6S287C63v59Ev,
  (VTBL_ENTRY)&_ZN6S287C63v60Ev,
  (VTBL_ENTRY)&_ZN6S287C63v61Ev,
  (VTBL_ENTRY)&_ZN6S287C63v62Ev,
  (VTBL_ENTRY)&_ZN6S287C63v63Ev,
  (VTBL_ENTRY)&_ZN6S287C63v64Ev,
  (VTBL_ENTRY)&_ZN6S287C63v65Ev,
  (VTBL_ENTRY)&_ZN6S287C63v66Ev,
  (VTBL_ENTRY)&_ZN6S287C63v67Ev,
  (VTBL_ENTRY)&_ZN6S287C63v68Ev,
  (VTBL_ENTRY)&_ZN6S287C63v69Ev,
  (VTBL_ENTRY)&_ZN6S287C63v70Ev,
  (VTBL_ENTRY)&_ZN6S287C63v71Ev,
  (VTBL_ENTRY)&_ZN6S287C63v72Ev,
  (VTBL_ENTRY)&_ZN6S287C53v73Ev,
  (VTBL_ENTRY)&_ZN6S287C53v74Ev,
  (VTBL_ENTRY)&_ZN6S287C53v75Ev,
  (VTBL_ENTRY)&_ZN6S287C53v76Ev,
  (VTBL_ENTRY)&_ZN6S287C53v77Ev,
  (VTBL_ENTRY)&_ZN6S287C53v78Ev,
  (VTBL_ENTRY)&_ZN6S287C53v79Ev,
  (VTBL_ENTRY)&_ZN6S287C53v80Ev,
  (VTBL_ENTRY)&_ZN6S287C53v81Ev,
  (VTBL_ENTRY)&_ZN6S287C53v82Ev,
  (VTBL_ENTRY)&_ZN6S287C53v83Ev,
  (VTBL_ENTRY)&_ZN6S287C53v84Ev,
  (VTBL_ENTRY)&_ZN6S287C53v85Ev,
  (VTBL_ENTRY)&_ZN6S287C53v86Ev,
  (VTBL_ENTRY)&_ZN6S287C53v87Ev,
  (VTBL_ENTRY)&_ZN6S287C53v88Ev,
  (VTBL_ENTRY)&_ZN6S287C53v89Ev,
  (VTBL_ENTRY)&_ZN6S287C53v90Ev,
  (VTBL_ENTRY)&_ZN6S287C53v91Ev,
  (VTBL_ENTRY)&_ZN6S287C53v92Ev,
  (VTBL_ENTRY)&_ZN6S287C53v93Ev,
  (VTBL_ENTRY)&_ZN6S287C53v94Ev,
  (VTBL_ENTRY)&_ZN6S287C43v95Ev,
  (VTBL_ENTRY)&_ZN6S287C43v96Ev,
  (VTBL_ENTRY)&_ZN6S287C43v97Ev,
  (VTBL_ENTRY)&_ZN6S287C43v98Ev,
  (VTBL_ENTRY)&_ZN6S287C43v99Ev,
  (VTBL_ENTRY)&_ZN6S287C44v100Ev,
  (VTBL_ENTRY)&_ZN6S287C44v101Ev,
  (VTBL_ENTRY)&_ZN6S287C44v102Ev,
  (VTBL_ENTRY)&_ZN6S287C44v103Ev,
  (VTBL_ENTRY)&_ZN6S287C44v104Ev,
  (VTBL_ENTRY)&_ZN6S287C44v105Ev,
  (VTBL_ENTRY)&_ZN6S287C44v106Ev,
  (VTBL_ENTRY)&_ZN6S287C44v107Ev,
  (VTBL_ENTRY)&_ZN6S287C44v108Ev,
  (VTBL_ENTRY)&_ZN6S287C44v109Ev,
  (VTBL_ENTRY)&_ZN6S287C44v110Ev,
  (VTBL_ENTRY)&_ZN6S287C44v111Ev,
  (VTBL_ENTRY)&_ZN6S287C44v112Ev,
  (VTBL_ENTRY)&_ZN6S287C44v113Ev,
  (VTBL_ENTRY)&_ZN6S287C44v114Ev,
  (VTBL_ENTRY)&_ZN6S287C34v115Ev,
  (VTBL_ENTRY)&_ZN6S287C34v116Ev,
  (VTBL_ENTRY)&_ZN6S287C34v117Ev,
  (VTBL_ENTRY)&_ZN6S287C34v118Ev,
  (VTBL_ENTRY)&_ZN6S287C34v119Ev,
  (VTBL_ENTRY)&_ZN6S287C34v120Ev,
  (VTBL_ENTRY)&_ZN6S287C34v121Ev,
  (VTBL_ENTRY)&_ZN6S287C34v122Ev,
  (VTBL_ENTRY)&_ZN6S287C34v123Ev,
  (VTBL_ENTRY)&_ZN6S287C34v124Ev,
  (VTBL_ENTRY)&_ZN6S287C34v125Ev,
  (VTBL_ENTRY)&_ZN6S287C34v126Ev,
  (VTBL_ENTRY)&_ZN6S287C34v127Ev,
  (VTBL_ENTRY)&_ZN6S287C34v128Ev,
  (VTBL_ENTRY)&_ZN6S287C34v129Ev,
  (VTBL_ENTRY)&_ZN6S287C34v130Ev,
  (VTBL_ENTRY)&_ZN6S287C34v131Ev,
  (VTBL_ENTRY)&_ZN6S287C34v132Ev,
  (VTBL_ENTRY)&_ZN6S287C34v133Ev,
  (VTBL_ENTRY)&_ZN6S287C34v134Ev,
  (VTBL_ENTRY)&_ZN6S287C34v135Ev,
  (VTBL_ENTRY)&_ZN6S287C34v136Ev,
};
extern VTBL_ENTRY _ZTI6S287C3[];
extern  VTBL_ENTRY _ZTV6S287C3[];
Class_Descriptor cd_S287C3 = {  "S287C3", // class name
  bases_S287C3, 3,
  &(vtc_S287C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(376,276), // object size
  NSPAIRA(_ZTI6S287C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S287C3),132, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S287C31_nt  {
  virtual  ~S287C31_nt(); // _ZN10S287C31_ntD1Ev
  virtual void  v137(); // _ZN10S287C31_nt4v137Ev
  virtual void  v138(); // _ZN10S287C31_nt4v138Ev
  virtual void  v139(); // _ZN10S287C31_nt4v139Ev
  virtual void  v140(); // _ZN10S287C31_nt4v140Ev
  virtual void  v141(); // _ZN10S287C31_nt4v141Ev
  S287C31_nt(); // tgen
};
//SIG(-1 S287C31_nt) C1{ vd v1 v2 v3 v4 v5}


 S287C31_nt ::~S287C31_nt(){ note_dtor("S287C31_nt", this);}
void  S287C31_nt ::v137(){vfunc_called(this, "_ZN10S287C31_nt4v137Ev");}
void  S287C31_nt ::v138(){vfunc_called(this, "_ZN10S287C31_nt4v138Ev");}
void  S287C31_nt ::v139(){vfunc_called(this, "_ZN10S287C31_nt4v139Ev");}
void  S287C31_nt ::v140(){vfunc_called(this, "_ZN10S287C31_nt4v140Ev");}
void  S287C31_nt ::v141(){vfunc_called(this, "_ZN10S287C31_nt4v141Ev");}
S287C31_nt ::S287C31_nt(){ note_ctor("S287C31_nt", this);} // tgen

//skip512 S287C31_nt

#else // __cplusplus

extern void _ZN10S287C31_ntC1Ev();
extern void _ZN10S287C31_ntD1Ev();
Name_Map name_map_S287C31_nt[] = {
  NSPAIR(_ZN10S287C31_ntC1Ev),
  NSPAIR(_ZN10S287C31_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S287C31_nt[];
extern void _ZN10S287C31_ntD1Ev();
extern void _ZN10S287C31_ntD0Ev();
extern void _ZN10S287C31_nt4v137Ev();
extern void _ZN10S287C31_nt4v138Ev();
extern void _ZN10S287C31_nt4v139Ev();
extern void _ZN10S287C31_nt4v140Ev();
extern void _ZN10S287C31_nt4v141Ev();
static  VTBL_ENTRY vtc_S287C31_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S287C31_nt[0]),
  (VTBL_ENTRY)&_ZN10S287C31_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S287C31_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S287C31_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S287C31_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S287C31_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S287C31_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S287C31_nt4v141Ev,
};
extern VTBL_ENTRY _ZTI10S287C31_nt[];
VTBL_ENTRY *P__ZTI10S287C31_nt = _ZTI10S287C31_nt; 
extern  VTBL_ENTRY _ZTV10S287C31_nt[];
Class_Descriptor cd_S287C31_nt = {  "S287C31_nt", // class name
  0,0,//no base classes
  &(vtc_S287C31_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S287C31_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S287C31_nt),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S287C2  : S287C3 , S287C31_nt {
  ::S3350C18 s287c2f0;
  virtual  ~S287C2(); // _ZN6S287C2D1Ev
  virtual void  v142(); // _ZN6S287C24v142Ev
  virtual void  v143(); // _ZN6S287C24v143Ev
  virtual void  v144(); // _ZN6S287C24v144Ev
  virtual void  v145(); // _ZN6S287C24v145Ev
  virtual void  v146(); // _ZN6S287C24v146Ev
  virtual void  v147(); // _ZN6S287C24v147Ev
  virtual void  v148(); // _ZN6S287C24v148Ev
  virtual void  v149(); // _ZN6S287C24v149Ev
  virtual void  v150(); // _ZN6S287C24v150Ev
  virtual void  v151(); // _ZN6S287C24v151Ev
  virtual void  v152(); // _ZN6S287C24v152Ev
  virtual void  v153(); // _ZN6S287C24v153Ev
  virtual void  v154(); // _ZN6S287C24v154Ev
  virtual void  v155(); // _ZN6S287C24v155Ev
  virtual void  v156(); // _ZN6S287C24v156Ev
  virtual void  v157(); // _ZN6S287C24v157Ev
  virtual void  v158(); // _ZN6S287C24v158Ev
  virtual void  v159(); // _ZN6S287C24v159Ev
  virtual void  v160(); // _ZN6S287C24v160Ev
  S287C2(); // tgen
};
//SIG(-1 S287C2) C1{ BC2{ BC3{ BC4{ BC5{ vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} FC18{ BC19{ BC10}} Fi[3]} vd v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 Fp FC18 FC20{ BC21{ BC10}} FC20 FC22{ BC23{ BC10}} FC22 Fi:1 Fi[3]} BC24{ vd v148 v149 v150 v151 v152} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 FC13}


 S287C2 ::~S287C2(){ note_dtor("S287C2", this);}
void  S287C2 ::v142(){vfunc_called(this, "_ZN6S287C24v142Ev");}
void  S287C2 ::v143(){vfunc_called(this, "_ZN6S287C24v143Ev");}
void  S287C2 ::v144(){vfunc_called(this, "_ZN6S287C24v144Ev");}
void  S287C2 ::v145(){vfunc_called(this, "_ZN6S287C24v145Ev");}
void  S287C2 ::v146(){vfunc_called(this, "_ZN6S287C24v146Ev");}
void  S287C2 ::v147(){vfunc_called(this, "_ZN6S287C24v147Ev");}
void  S287C2 ::v148(){vfunc_called(this, "_ZN6S287C24v148Ev");}
void  S287C2 ::v149(){vfunc_called(this, "_ZN6S287C24v149Ev");}
void  S287C2 ::v150(){vfunc_called(this, "_ZN6S287C24v150Ev");}
void  S287C2 ::v151(){vfunc_called(this, "_ZN6S287C24v151Ev");}
void  S287C2 ::v152(){vfunc_called(this, "_ZN6S287C24v152Ev");}
void  S287C2 ::v153(){vfunc_called(this, "_ZN6S287C24v153Ev");}
void  S287C2 ::v154(){vfunc_called(this, "_ZN6S287C24v154Ev");}
void  S287C2 ::v155(){vfunc_called(this, "_ZN6S287C24v155Ev");}
void  S287C2 ::v156(){vfunc_called(this, "_ZN6S287C24v156Ev");}
void  S287C2 ::v157(){vfunc_called(this, "_ZN6S287C24v157Ev");}
void  S287C2 ::v158(){vfunc_called(this, "_ZN6S287C24v158Ev");}
void  S287C2 ::v159(){vfunc_called(this, "_ZN6S287C24v159Ev");}
void  S287C2 ::v160(){vfunc_called(this, "_ZN6S287C24v160Ev");}
S287C2 ::S287C2(){ note_ctor("S287C2", this);} // tgen

static void Test_S287C2()
{
  extern Class_Descriptor cd_S287C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(51,74)];
    init_test(&cd_S287C2, buf);
    S287C2 *dp, &lv = *(dp=new (buf) S287C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(400,292), "sizeof(S287C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S287C2)");
    check_base_class_offset(lv, (S287C6*)(S287C5*)(S287C4*)(S287C3*), 0, "S287C2");
    check_base_class_offset(lv, (S287C5*)(S287C4*)(S287C3*), 0, "S287C2");
    check_base_class_offset(lv, (S287C4*)(S287C3*), 0, "S287C2");
    check_base_class_offset(lv, (S287C3*), 0, "S287C2");
    check_base_class_offset(lv, (S287C31_nt*), ABISELECT(376,276), "S287C2");
    check_field_offset(lv, s287c2f0, ABISELECT(384,280), "S287C2.s287c2f0");
    test_class_info(&lv, &cd_S287C2);
    dp->~S287C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS287C2(Test_S287C2, "S287C2", ABISELECT(400,292));

#else // __cplusplus

extern void _ZN6S287C2C1Ev();
extern void _ZN6S287C2D1Ev();
Name_Map name_map_S287C2[] = {
  NSPAIR(_ZN6S287C2C1Ev),
  NSPAIR(_ZN6S287C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S287C6;
extern VTBL_ENTRY _ZTI6S287C6[];
extern  VTBL_ENTRY _ZTV6S287C6[];
extern Class_Descriptor cd_S287C5;
extern VTBL_ENTRY _ZTI6S287C5[];
extern  VTBL_ENTRY _ZTV6S287C5[];
extern Class_Descriptor cd_S287C4;
extern VTBL_ENTRY _ZTI6S287C4[];
extern  VTBL_ENTRY _ZTV6S287C4[];
extern Class_Descriptor cd_S287C3;
extern VTBL_ENTRY _ZTI6S287C3[];
extern  VTBL_ENTRY _ZTV6S287C3[];
extern Class_Descriptor cd_S287C31_nt;
extern VTBL_ENTRY _ZTI10S287C31_nt[];
extern  VTBL_ENTRY _ZTV10S287C31_nt[];
static Base_Class bases_S287C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S287C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S287C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S287C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S287C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S287C31_nt,    ABISELECT(376,276), //bcp->offset
    151, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S287C2[];
extern void _ZN6S287C2D1Ev();
extern void _ZN6S287C2D0Ev();
extern void _ZN6S287C62v9Ev();
extern void _ZN6S287C63v10Ev();
extern void _ZN6S287C63v11Ev();
extern void _ZN6S287C63v12Ev();
extern void _ZN6S287C63v13Ev();
extern void _ZN6S287C63v14Ev();
extern void _ZN6S287C63v15Ev();
extern void _ZN6S287C63v16Ev();
extern void _ZN6S287C63v17Ev();
extern void _ZN6S287C63v18Ev();
extern void _ZN6S287C63v19Ev();
extern void _ZN6S287C63v20Ev();
extern void _ZN6S287C63v21Ev();
extern void _ZN6S287C63v22Ev();
extern void _ZN6S287C63v23Ev();
extern void _ZN6S287C63v24Ev();
extern void _ZN6S287C63v25Ev();
extern void _ZN6S287C63v26Ev();
extern void _ZN6S287C63v27Ev();
extern void _ZN6S287C63v28Ev();
extern void _ZN6S287C63v29Ev();
extern void _ZN6S287C63v30Ev();
extern void _ZN6S287C63v31Ev();
extern void _ZN6S287C63v32Ev();
extern void _ZN6S287C63v33Ev();
extern void _ZN6S287C63v34Ev();
extern void _ZN6S287C63v35Ev();
extern void _ZN6S287C63v36Ev();
extern void _ZN6S287C63v37Ev();
extern void _ZN6S287C63v38Ev();
extern void _ZN6S287C63v39Ev();
extern void _ZN6S287C63v40Ev();
extern void _ZN6S287C63v41Ev();
extern void _ZN6S287C63v42Ev();
extern void _ZN6S287C63v43Ev();
extern void _ZN6S287C63v44Ev();
extern void _ZN6S287C63v45Ev();
extern void _ZN6S287C63v46Ev();
extern void _ZN6S287C63v47Ev();
extern void _ZN6S287C63v48Ev();
extern void _ZN6S287C63v49Ev();
extern void _ZN6S287C63v50Ev();
extern void _ZN6S287C63v51Ev();
extern void _ZN6S287C63v52Ev();
extern void _ZN6S287C63v53Ev();
extern void _ZN6S287C63v54Ev();
extern void _ZN6S287C63v55Ev();
extern void _ZN6S287C63v56Ev();
extern void _ZN6S287C63v57Ev();
extern void _ZN6S287C63v58Ev();
extern void _ZN6S287C63v59Ev();
extern void _ZN6S287C63v60Ev();
extern void _ZN6S287C63v61Ev();
extern void _ZN6S287C63v62Ev();
extern void _ZN6S287C63v63Ev();
extern void _ZN6S287C63v64Ev();
extern void _ZN6S287C63v65Ev();
extern void _ZN6S287C63v66Ev();
extern void _ZN6S287C63v67Ev();
extern void _ZN6S287C63v68Ev();
extern void _ZN6S287C63v69Ev();
extern void _ZN6S287C63v70Ev();
extern void _ZN6S287C63v71Ev();
extern void _ZN6S287C63v72Ev();
extern void _ZN6S287C53v73Ev();
extern void _ZN6S287C53v74Ev();
extern void _ZN6S287C53v75Ev();
extern void _ZN6S287C53v76Ev();
extern void _ZN6S287C53v77Ev();
extern void _ZN6S287C53v78Ev();
extern void _ZN6S287C53v79Ev();
extern void _ZN6S287C53v80Ev();
extern void _ZN6S287C53v81Ev();
extern void _ZN6S287C53v82Ev();
extern void _ZN6S287C53v83Ev();
extern void _ZN6S287C53v84Ev();
extern void _ZN6S287C53v85Ev();
extern void _ZN6S287C53v86Ev();
extern void _ZN6S287C53v87Ev();
extern void _ZN6S287C53v88Ev();
extern void _ZN6S287C53v89Ev();
extern void _ZN6S287C53v90Ev();
extern void _ZN6S287C53v91Ev();
extern void _ZN6S287C53v92Ev();
extern void _ZN6S287C53v93Ev();
extern void _ZN6S287C53v94Ev();
extern void _ZN6S287C43v95Ev();
extern void _ZN6S287C43v96Ev();
extern void _ZN6S287C43v97Ev();
extern void _ZN6S287C43v98Ev();
extern void _ZN6S287C43v99Ev();
extern void _ZN6S287C44v100Ev();
extern void _ZN6S287C44v101Ev();
extern void _ZN6S287C44v102Ev();
extern void _ZN6S287C44v103Ev();
extern void _ZN6S287C44v104Ev();
extern void _ZN6S287C44v105Ev();
extern void _ZN6S287C44v106Ev();
extern void _ZN6S287C44v107Ev();
extern void _ZN6S287C44v108Ev();
extern void _ZN6S287C44v109Ev();
extern void _ZN6S287C44v110Ev();
extern void _ZN6S287C44v111Ev();
extern void _ZN6S287C44v112Ev();
extern void _ZN6S287C44v113Ev();
extern void _ZN6S287C44v114Ev();
extern void _ZN6S287C34v115Ev();
extern void _ZN6S287C34v116Ev();
extern void _ZN6S287C34v117Ev();
extern void _ZN6S287C34v118Ev();
extern void _ZN6S287C34v119Ev();
extern void _ZN6S287C34v120Ev();
extern void _ZN6S287C34v121Ev();
extern void _ZN6S287C34v122Ev();
extern void _ZN6S287C34v123Ev();
extern void _ZN6S287C34v124Ev();
extern void _ZN6S287C34v125Ev();
extern void _ZN6S287C34v126Ev();
extern void _ZN6S287C34v127Ev();
extern void _ZN6S287C34v128Ev();
extern void _ZN6S287C34v129Ev();
extern void _ZN6S287C34v130Ev();
extern void _ZN6S287C34v131Ev();
extern void _ZN6S287C34v132Ev();
extern void _ZN6S287C34v133Ev();
extern void _ZN6S287C34v134Ev();
extern void _ZN6S287C34v135Ev();
extern void _ZN6S287C34v136Ev();
extern void _ZN6S287C24v142Ev();
extern void _ZN6S287C24v143Ev();
extern void _ZN6S287C24v144Ev();
extern void _ZN6S287C24v145Ev();
extern void _ZN6S287C24v146Ev();
extern void _ZN6S287C24v147Ev();
extern void _ZN6S287C24v148Ev();
extern void _ZN6S287C24v149Ev();
extern void _ZN6S287C24v150Ev();
extern void _ZN6S287C24v151Ev();
extern void _ZN6S287C24v152Ev();
extern void _ZN6S287C24v153Ev();
extern void _ZN6S287C24v154Ev();
extern void _ZN6S287C24v155Ev();
extern void _ZN6S287C24v156Ev();
extern void _ZN6S287C24v157Ev();
extern void _ZN6S287C24v158Ev();
extern void _ZN6S287C24v159Ev();
extern void _ZN6S287C24v160Ev();
extern void ABISELECT(_ZThn376_N6S287C2D1Ev,_ZThn276_N6S287C2D1Ev)();
extern void ABISELECT(_ZThn376_N6S287C2D0Ev,_ZThn276_N6S287C2D0Ev)();
extern void _ZN10S287C31_nt4v137Ev();
extern void _ZN10S287C31_nt4v138Ev();
extern void _ZN10S287C31_nt4v139Ev();
extern void _ZN10S287C31_nt4v140Ev();
extern void _ZN10S287C31_nt4v141Ev();
static  VTBL_ENTRY vtc_S287C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S287C2[0]),
  (VTBL_ENTRY)&_ZN6S287C2D1Ev,
  (VTBL_ENTRY)&_ZN6S287C2D0Ev,
  (VTBL_ENTRY)&_ZN6S287C62v9Ev,
  (VTBL_ENTRY)&_ZN6S287C63v10Ev,
  (VTBL_ENTRY)&_ZN6S287C63v11Ev,
  (VTBL_ENTRY)&_ZN6S287C63v12Ev,
  (VTBL_ENTRY)&_ZN6S287C63v13Ev,
  (VTBL_ENTRY)&_ZN6S287C63v14Ev,
  (VTBL_ENTRY)&_ZN6S287C63v15Ev,
  (VTBL_ENTRY)&_ZN6S287C63v16Ev,
  (VTBL_ENTRY)&_ZN6S287C63v17Ev,
  (VTBL_ENTRY)&_ZN6S287C63v18Ev,
  (VTBL_ENTRY)&_ZN6S287C63v19Ev,
  (VTBL_ENTRY)&_ZN6S287C63v20Ev,
  (VTBL_ENTRY)&_ZN6S287C63v21Ev,
  (VTBL_ENTRY)&_ZN6S287C63v22Ev,
  (VTBL_ENTRY)&_ZN6S287C63v23Ev,
  (VTBL_ENTRY)&_ZN6S287C63v24Ev,
  (VTBL_ENTRY)&_ZN6S287C63v25Ev,
  (VTBL_ENTRY)&_ZN6S287C63v26Ev,
  (VTBL_ENTRY)&_ZN6S287C63v27Ev,
  (VTBL_ENTRY)&_ZN6S287C63v28Ev,
  (VTBL_ENTRY)&_ZN6S287C63v29Ev,
  (VTBL_ENTRY)&_ZN6S287C63v30Ev,
  (VTBL_ENTRY)&_ZN6S287C63v31Ev,
  (VTBL_ENTRY)&_ZN6S287C63v32Ev,
  (VTBL_ENTRY)&_ZN6S287C63v33Ev,
  (VTBL_ENTRY)&_ZN6S287C63v34Ev,
  (VTBL_ENTRY)&_ZN6S287C63v35Ev,
  (VTBL_ENTRY)&_ZN6S287C63v36Ev,
  (VTBL_ENTRY)&_ZN6S287C63v37Ev,
  (VTBL_ENTRY)&_ZN6S287C63v38Ev,
  (VTBL_ENTRY)&_ZN6S287C63v39Ev,
  (VTBL_ENTRY)&_ZN6S287C63v40Ev,
  (VTBL_ENTRY)&_ZN6S287C63v41Ev,
  (VTBL_ENTRY)&_ZN6S287C63v42Ev,
  (VTBL_ENTRY)&_ZN6S287C63v43Ev,
  (VTBL_ENTRY)&_ZN6S287C63v44Ev,
  (VTBL_ENTRY)&_ZN6S287C63v45Ev,
  (VTBL_ENTRY)&_ZN6S287C63v46Ev,
  (VTBL_ENTRY)&_ZN6S287C63v47Ev,
  (VTBL_ENTRY)&_ZN6S287C63v48Ev,
  (VTBL_ENTRY)&_ZN6S287C63v49Ev,
  (VTBL_ENTRY)&_ZN6S287C63v50Ev,
  (VTBL_ENTRY)&_ZN6S287C63v51Ev,
  (VTBL_ENTRY)&_ZN6S287C63v52Ev,
  (VTBL_ENTRY)&_ZN6S287C63v53Ev,
  (VTBL_ENTRY)&_ZN6S287C63v54Ev,
  (VTBL_ENTRY)&_ZN6S287C63v55Ev,
  (VTBL_ENTRY)&_ZN6S287C63v56Ev,
  (VTBL_ENTRY)&_ZN6S287C63v57Ev,
  (VTBL_ENTRY)&_ZN6S287C63v58Ev,
  (VTBL_ENTRY)&_ZN6S287C63v59Ev,
  (VTBL_ENTRY)&_ZN6S287C63v60Ev,
  (VTBL_ENTRY)&_ZN6S287C63v61Ev,
  (VTBL_ENTRY)&_ZN6S287C63v62Ev,
  (VTBL_ENTRY)&_ZN6S287C63v63Ev,
  (VTBL_ENTRY)&_ZN6S287C63v64Ev,
  (VTBL_ENTRY)&_ZN6S287C63v65Ev,
  (VTBL_ENTRY)&_ZN6S287C63v66Ev,
  (VTBL_ENTRY)&_ZN6S287C63v67Ev,
  (VTBL_ENTRY)&_ZN6S287C63v68Ev,
  (VTBL_ENTRY)&_ZN6S287C63v69Ev,
  (VTBL_ENTRY)&_ZN6S287C63v70Ev,
  (VTBL_ENTRY)&_ZN6S287C63v71Ev,
  (VTBL_ENTRY)&_ZN6S287C63v72Ev,
  (VTBL_ENTRY)&_ZN6S287C53v73Ev,
  (VTBL_ENTRY)&_ZN6S287C53v74Ev,
  (VTBL_ENTRY)&_ZN6S287C53v75Ev,
  (VTBL_ENTRY)&_ZN6S287C53v76Ev,
  (VTBL_ENTRY)&_ZN6S287C53v77Ev,
  (VTBL_ENTRY)&_ZN6S287C53v78Ev,
  (VTBL_ENTRY)&_ZN6S287C53v79Ev,
  (VTBL_ENTRY)&_ZN6S287C53v80Ev,
  (VTBL_ENTRY)&_ZN6S287C53v81Ev,
  (VTBL_ENTRY)&_ZN6S287C53v82Ev,
  (VTBL_ENTRY)&_ZN6S287C53v83Ev,
  (VTBL_ENTRY)&_ZN6S287C53v84Ev,
  (VTBL_ENTRY)&_ZN6S287C53v85Ev,
  (VTBL_ENTRY)&_ZN6S287C53v86Ev,
  (VTBL_ENTRY)&_ZN6S287C53v87Ev,
  (VTBL_ENTRY)&_ZN6S287C53v88Ev,
  (VTBL_ENTRY)&_ZN6S287C53v89Ev,
  (VTBL_ENTRY)&_ZN6S287C53v90Ev,
  (VTBL_ENTRY)&_ZN6S287C53v91Ev,
  (VTBL_ENTRY)&_ZN6S287C53v92Ev,
  (VTBL_ENTRY)&_ZN6S287C53v93Ev,
  (VTBL_ENTRY)&_ZN6S287C53v94Ev,
  (VTBL_ENTRY)&_ZN6S287C43v95Ev,
  (VTBL_ENTRY)&_ZN6S287C43v96Ev,
  (VTBL_ENTRY)&_ZN6S287C43v97Ev,
  (VTBL_ENTRY)&_ZN6S287C43v98Ev,
  (VTBL_ENTRY)&_ZN6S287C43v99Ev,
  (VTBL_ENTRY)&_ZN6S287C44v100Ev,
  (VTBL_ENTRY)&_ZN6S287C44v101Ev,
  (VTBL_ENTRY)&_ZN6S287C44v102Ev,
  (VTBL_ENTRY)&_ZN6S287C44v103Ev,
  (VTBL_ENTRY)&_ZN6S287C44v104Ev,
  (VTBL_ENTRY)&_ZN6S287C44v105Ev,
  (VTBL_ENTRY)&_ZN6S287C44v106Ev,
  (VTBL_ENTRY)&_ZN6S287C44v107Ev,
  (VTBL_ENTRY)&_ZN6S287C44v108Ev,
  (VTBL_ENTRY)&_ZN6S287C44v109Ev,
  (VTBL_ENTRY)&_ZN6S287C44v110Ev,
  (VTBL_ENTRY)&_ZN6S287C44v111Ev,
  (VTBL_ENTRY)&_ZN6S287C44v112Ev,
  (VTBL_ENTRY)&_ZN6S287C44v113Ev,
  (VTBL_ENTRY)&_ZN6S287C44v114Ev,
  (VTBL_ENTRY)&_ZN6S287C34v115Ev,
  (VTBL_ENTRY)&_ZN6S287C34v116Ev,
  (VTBL_ENTRY)&_ZN6S287C34v117Ev,
  (VTBL_ENTRY)&_ZN6S287C34v118Ev,
  (VTBL_ENTRY)&_ZN6S287C34v119Ev,
  (VTBL_ENTRY)&_ZN6S287C34v120Ev,
  (VTBL_ENTRY)&_ZN6S287C34v121Ev,
  (VTBL_ENTRY)&_ZN6S287C34v122Ev,
  (VTBL_ENTRY)&_ZN6S287C34v123Ev,
  (VTBL_ENTRY)&_ZN6S287C34v124Ev,
  (VTBL_ENTRY)&_ZN6S287C34v125Ev,
  (VTBL_ENTRY)&_ZN6S287C34v126Ev,
  (VTBL_ENTRY)&_ZN6S287C34v127Ev,
  (VTBL_ENTRY)&_ZN6S287C34v128Ev,
  (VTBL_ENTRY)&_ZN6S287C34v129Ev,
  (VTBL_ENTRY)&_ZN6S287C34v130Ev,
  (VTBL_ENTRY)&_ZN6S287C34v131Ev,
  (VTBL_ENTRY)&_ZN6S287C34v132Ev,
  (VTBL_ENTRY)&_ZN6S287C34v133Ev,
  (VTBL_ENTRY)&_ZN6S287C34v134Ev,
  (VTBL_ENTRY)&_ZN6S287C34v135Ev,
  (VTBL_ENTRY)&_ZN6S287C34v136Ev,
  (VTBL_ENTRY)&_ZN6S287C24v142Ev,
  (VTBL_ENTRY)&_ZN6S287C24v143Ev,
  (VTBL_ENTRY)&_ZN6S287C24v144Ev,
  (VTBL_ENTRY)&_ZN6S287C24v145Ev,
  (VTBL_ENTRY)&_ZN6S287C24v146Ev,
  (VTBL_ENTRY)&_ZN6S287C24v147Ev,
  (VTBL_ENTRY)&_ZN6S287C24v148Ev,
  (VTBL_ENTRY)&_ZN6S287C24v149Ev,
  (VTBL_ENTRY)&_ZN6S287C24v150Ev,
  (VTBL_ENTRY)&_ZN6S287C24v151Ev,
  (VTBL_ENTRY)&_ZN6S287C24v152Ev,
  (VTBL_ENTRY)&_ZN6S287C24v153Ev,
  (VTBL_ENTRY)&_ZN6S287C24v154Ev,
  (VTBL_ENTRY)&_ZN6S287C24v155Ev,
  (VTBL_ENTRY)&_ZN6S287C24v156Ev,
  (VTBL_ENTRY)&_ZN6S287C24v157Ev,
  (VTBL_ENTRY)&_ZN6S287C24v158Ev,
  (VTBL_ENTRY)&_ZN6S287C24v159Ev,
  (VTBL_ENTRY)&_ZN6S287C24v160Ev,
  ABISELECT(-376,-276),
  (VTBL_ENTRY)&(_ZTI6S287C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn376_N6S287C2D1Ev,_ZThn276_N6S287C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn376_N6S287C2D0Ev,_ZThn276_N6S287C2D0Ev),
  (VTBL_ENTRY)&_ZN10S287C31_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S287C31_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S287C31_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S287C31_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S287C31_nt4v141Ev,
};
extern VTBL_ENTRY _ZTI6S287C2[];
extern  VTBL_ENTRY _ZTV6S287C2[];
Class_Descriptor cd_S287C2 = {  "S287C2", // class name
  bases_S287C2, 5,
  &(vtc_S287C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(400,292), // object size
  NSPAIRA(_ZTI6S287C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6S287C2),160, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S287C1  : S287C2 {
  virtual  ~S287C1(); // _ZN6S287C1D1Ev
  virtual void  v1(); // _ZN6S287C12v1Ev
  virtual void  v2(); // _ZN6S287C12v2Ev
  virtual void  v3(); // _ZN6S287C12v3Ev
  virtual void  v4(); // _ZN6S287C12v4Ev
  virtual void  v5(); // _ZN6S287C12v5Ev
  virtual void  v6(); // _ZN6S287C12v6Ev
  virtual void  v7(); // _ZN6S287C12v7Ev
  virtual void  v8(); // _ZN6S287C12v8Ev
  S287C1(); // tgen
};
//SIG(1 S287C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 Fi[2] Fp Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 FC12{ m} FC8 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 Fi:1 Fi:1 Fi:1 FC13{ BC14{ BC11}} FC15{ BC16{ BC11}} FC17{ BC18{ BC11}} FC19{ BC20{ BC11}} Fi[3]} vd v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 Fp FC19 FC21{ BC22{ BC11}} FC21 FC23{ BC24{ BC11}} FC23 Fi:1 Fi[3]} BC25{ vd v137 v138 v139 v140 v141} vd v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 FC14} vd v1 v2 v3 v4 v5 v6 v7 v8}


 S287C1 ::~S287C1(){ note_dtor("S287C1", this);}
void  S287C1 ::v1(){vfunc_called(this, "_ZN6S287C12v1Ev");}
void  S287C1 ::v2(){vfunc_called(this, "_ZN6S287C12v2Ev");}
void  S287C1 ::v3(){vfunc_called(this, "_ZN6S287C12v3Ev");}
void  S287C1 ::v4(){vfunc_called(this, "_ZN6S287C12v4Ev");}
void  S287C1 ::v5(){vfunc_called(this, "_ZN6S287C12v5Ev");}
void  S287C1 ::v6(){vfunc_called(this, "_ZN6S287C12v6Ev");}
void  S287C1 ::v7(){vfunc_called(this, "_ZN6S287C12v7Ev");}
void  S287C1 ::v8(){vfunc_called(this, "_ZN6S287C12v8Ev");}
S287C1 ::S287C1(){ note_ctor("S287C1", this);} // tgen

static void Test_S287C1()
{
  extern Class_Descriptor cd_S287C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(51,74)];
    init_test(&cd_S287C1, buf);
    S287C1 *dp, &lv = *(dp=new (buf) S287C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(400,292), "sizeof(S287C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S287C1)");
    check_base_class_offset(lv, (S287C6*)(S287C5*)(S287C4*)(S287C3*)(S287C2*), 0, "S287C1");
    check_base_class_offset(lv, (S287C5*)(S287C4*)(S287C3*)(S287C2*), 0, "S287C1");
    check_base_class_offset(lv, (S287C4*)(S287C3*)(S287C2*), 0, "S287C1");
    check_base_class_offset(lv, (S287C3*)(S287C2*), 0, "S287C1");
    check_base_class_offset(lv, (S287C31_nt*)(S287C2*), ABISELECT(376,276), "S287C1");
    check_base_class_offset(lv, (S287C2*), 0, "S287C1");
    test_class_info(&lv, &cd_S287C1);
    dp->~S287C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS287C1(Test_S287C1, "S287C1", ABISELECT(400,292));

#else // __cplusplus

extern void _ZN6S287C1C1Ev();
extern void _ZN6S287C1D1Ev();
Name_Map name_map_S287C1[] = {
  NSPAIR(_ZN6S287C1C1Ev),
  NSPAIR(_ZN6S287C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S287C6;
extern VTBL_ENTRY _ZTI6S287C6[];
extern  VTBL_ENTRY _ZTV6S287C6[];
extern Class_Descriptor cd_S287C5;
extern VTBL_ENTRY _ZTI6S287C5[];
extern  VTBL_ENTRY _ZTV6S287C5[];
extern Class_Descriptor cd_S287C4;
extern VTBL_ENTRY _ZTI6S287C4[];
extern  VTBL_ENTRY _ZTV6S287C4[];
extern Class_Descriptor cd_S287C3;
extern VTBL_ENTRY _ZTI6S287C3[];
extern  VTBL_ENTRY _ZTV6S287C3[];
extern Class_Descriptor cd_S287C31_nt;
extern VTBL_ENTRY _ZTI10S287C31_nt[];
extern  VTBL_ENTRY _ZTV10S287C31_nt[];
extern Class_Descriptor cd_S287C2;
extern VTBL_ENTRY _ZTI6S287C2[];
extern  VTBL_ENTRY _ZTV6S287C2[];
static Base_Class bases_S287C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S287C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S287C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S287C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S287C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S287C31_nt,    ABISELECT(376,276), //bcp->offset
    159, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S287C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S287C1[];
extern void _ZN6S287C1D1Ev();
extern void _ZN6S287C1D0Ev();
extern void _ZN6S287C62v9Ev();
extern void _ZN6S287C63v10Ev();
extern void _ZN6S287C63v11Ev();
extern void _ZN6S287C63v12Ev();
extern void _ZN6S287C63v13Ev();
extern void _ZN6S287C63v14Ev();
extern void _ZN6S287C63v15Ev();
extern void _ZN6S287C63v16Ev();
extern void _ZN6S287C63v17Ev();
extern void _ZN6S287C63v18Ev();
extern void _ZN6S287C63v19Ev();
extern void _ZN6S287C63v20Ev();
extern void _ZN6S287C63v21Ev();
extern void _ZN6S287C63v22Ev();
extern void _ZN6S287C63v23Ev();
extern void _ZN6S287C63v24Ev();
extern void _ZN6S287C63v25Ev();
extern void _ZN6S287C63v26Ev();
extern void _ZN6S287C63v27Ev();
extern void _ZN6S287C63v28Ev();
extern void _ZN6S287C63v29Ev();
extern void _ZN6S287C63v30Ev();
extern void _ZN6S287C63v31Ev();
extern void _ZN6S287C63v32Ev();
extern void _ZN6S287C63v33Ev();
extern void _ZN6S287C63v34Ev();
extern void _ZN6S287C63v35Ev();
extern void _ZN6S287C63v36Ev();
extern void _ZN6S287C63v37Ev();
extern void _ZN6S287C63v38Ev();
extern void _ZN6S287C63v39Ev();
extern void _ZN6S287C63v40Ev();
extern void _ZN6S287C63v41Ev();
extern void _ZN6S287C63v42Ev();
extern void _ZN6S287C63v43Ev();
extern void _ZN6S287C63v44Ev();
extern void _ZN6S287C63v45Ev();
extern void _ZN6S287C63v46Ev();
extern void _ZN6S287C63v47Ev();
extern void _ZN6S287C63v48Ev();
extern void _ZN6S287C63v49Ev();
extern void _ZN6S287C63v50Ev();
extern void _ZN6S287C63v51Ev();
extern void _ZN6S287C63v52Ev();
extern void _ZN6S287C63v53Ev();
extern void _ZN6S287C63v54Ev();
extern void _ZN6S287C63v55Ev();
extern void _ZN6S287C63v56Ev();
extern void _ZN6S287C63v57Ev();
extern void _ZN6S287C63v58Ev();
extern void _ZN6S287C63v59Ev();
extern void _ZN6S287C63v60Ev();
extern void _ZN6S287C63v61Ev();
extern void _ZN6S287C63v62Ev();
extern void _ZN6S287C63v63Ev();
extern void _ZN6S287C63v64Ev();
extern void _ZN6S287C63v65Ev();
extern void _ZN6S287C63v66Ev();
extern void _ZN6S287C63v67Ev();
extern void _ZN6S287C63v68Ev();
extern void _ZN6S287C63v69Ev();
extern void _ZN6S287C63v70Ev();
extern void _ZN6S287C63v71Ev();
extern void _ZN6S287C63v72Ev();
extern void _ZN6S287C53v73Ev();
extern void _ZN6S287C53v74Ev();
extern void _ZN6S287C53v75Ev();
extern void _ZN6S287C53v76Ev();
extern void _ZN6S287C53v77Ev();
extern void _ZN6S287C53v78Ev();
extern void _ZN6S287C53v79Ev();
extern void _ZN6S287C53v80Ev();
extern void _ZN6S287C53v81Ev();
extern void _ZN6S287C53v82Ev();
extern void _ZN6S287C53v83Ev();
extern void _ZN6S287C53v84Ev();
extern void _ZN6S287C53v85Ev();
extern void _ZN6S287C53v86Ev();
extern void _ZN6S287C53v87Ev();
extern void _ZN6S287C53v88Ev();
extern void _ZN6S287C53v89Ev();
extern void _ZN6S287C53v90Ev();
extern void _ZN6S287C53v91Ev();
extern void _ZN6S287C53v92Ev();
extern void _ZN6S287C53v93Ev();
extern void _ZN6S287C53v94Ev();
extern void _ZN6S287C43v95Ev();
extern void _ZN6S287C43v96Ev();
extern void _ZN6S287C43v97Ev();
extern void _ZN6S287C43v98Ev();
extern void _ZN6S287C43v99Ev();
extern void _ZN6S287C44v100Ev();
extern void _ZN6S287C44v101Ev();
extern void _ZN6S287C44v102Ev();
extern void _ZN6S287C44v103Ev();
extern void _ZN6S287C44v104Ev();
extern void _ZN6S287C44v105Ev();
extern void _ZN6S287C44v106Ev();
extern void _ZN6S287C44v107Ev();
extern void _ZN6S287C44v108Ev();
extern void _ZN6S287C44v109Ev();
extern void _ZN6S287C44v110Ev();
extern void _ZN6S287C44v111Ev();
extern void _ZN6S287C44v112Ev();
extern void _ZN6S287C44v113Ev();
extern void _ZN6S287C44v114Ev();
extern void _ZN6S287C34v115Ev();
extern void _ZN6S287C34v116Ev();
extern void _ZN6S287C34v117Ev();
extern void _ZN6S287C34v118Ev();
extern void _ZN6S287C34v119Ev();
extern void _ZN6S287C34v120Ev();
extern void _ZN6S287C34v121Ev();
extern void _ZN6S287C34v122Ev();
extern void _ZN6S287C34v123Ev();
extern void _ZN6S287C34v124Ev();
extern void _ZN6S287C34v125Ev();
extern void _ZN6S287C34v126Ev();
extern void _ZN6S287C34v127Ev();
extern void _ZN6S287C34v128Ev();
extern void _ZN6S287C34v129Ev();
extern void _ZN6S287C34v130Ev();
extern void _ZN6S287C34v131Ev();
extern void _ZN6S287C34v132Ev();
extern void _ZN6S287C34v133Ev();
extern void _ZN6S287C34v134Ev();
extern void _ZN6S287C34v135Ev();
extern void _ZN6S287C34v136Ev();
extern void _ZN6S287C24v142Ev();
extern void _ZN6S287C24v143Ev();
extern void _ZN6S287C24v144Ev();
extern void _ZN6S287C24v145Ev();
extern void _ZN6S287C24v146Ev();
extern void _ZN6S287C24v147Ev();
extern void _ZN6S287C24v148Ev();
extern void _ZN6S287C24v149Ev();
extern void _ZN6S287C24v150Ev();
extern void _ZN6S287C24v151Ev();
extern void _ZN6S287C24v152Ev();
extern void _ZN6S287C24v153Ev();
extern void _ZN6S287C24v154Ev();
extern void _ZN6S287C24v155Ev();
extern void _ZN6S287C24v156Ev();
extern void _ZN6S287C24v157Ev();
extern void _ZN6S287C24v158Ev();
extern void _ZN6S287C24v159Ev();
extern void _ZN6S287C24v160Ev();
extern void _ZN6S287C12v1Ev();
extern void _ZN6S287C12v2Ev();
extern void _ZN6S287C12v3Ev();
extern void _ZN6S287C12v4Ev();
extern void _ZN6S287C12v5Ev();
extern void _ZN6S287C12v6Ev();
extern void _ZN6S287C12v7Ev();
extern void _ZN6S287C12v8Ev();
extern void ABISELECT(_ZThn376_N6S287C1D1Ev,_ZThn276_N6S287C1D1Ev)();
extern void ABISELECT(_ZThn376_N6S287C1D0Ev,_ZThn276_N6S287C1D0Ev)();
extern void _ZN10S287C31_nt4v137Ev();
extern void _ZN10S287C31_nt4v138Ev();
extern void _ZN10S287C31_nt4v139Ev();
extern void _ZN10S287C31_nt4v140Ev();
extern void _ZN10S287C31_nt4v141Ev();
static  VTBL_ENTRY vtc_S287C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S287C1[0]),
  (VTBL_ENTRY)&_ZN6S287C1D1Ev,
  (VTBL_ENTRY)&_ZN6S287C1D0Ev,
  (VTBL_ENTRY)&_ZN6S287C62v9Ev,
  (VTBL_ENTRY)&_ZN6S287C63v10Ev,
  (VTBL_ENTRY)&_ZN6S287C63v11Ev,
  (VTBL_ENTRY)&_ZN6S287C63v12Ev,
  (VTBL_ENTRY)&_ZN6S287C63v13Ev,
  (VTBL_ENTRY)&_ZN6S287C63v14Ev,
  (VTBL_ENTRY)&_ZN6S287C63v15Ev,
  (VTBL_ENTRY)&_ZN6S287C63v16Ev,
  (VTBL_ENTRY)&_ZN6S287C63v17Ev,
  (VTBL_ENTRY)&_ZN6S287C63v18Ev,
  (VTBL_ENTRY)&_ZN6S287C63v19Ev,
  (VTBL_ENTRY)&_ZN6S287C63v20Ev,
  (VTBL_ENTRY)&_ZN6S287C63v21Ev,
  (VTBL_ENTRY)&_ZN6S287C63v22Ev,
  (VTBL_ENTRY)&_ZN6S287C63v23Ev,
  (VTBL_ENTRY)&_ZN6S287C63v24Ev,
  (VTBL_ENTRY)&_ZN6S287C63v25Ev,
  (VTBL_ENTRY)&_ZN6S287C63v26Ev,
  (VTBL_ENTRY)&_ZN6S287C63v27Ev,
  (VTBL_ENTRY)&_ZN6S287C63v28Ev,
  (VTBL_ENTRY)&_ZN6S287C63v29Ev,
  (VTBL_ENTRY)&_ZN6S287C63v30Ev,
  (VTBL_ENTRY)&_ZN6S287C63v31Ev,
  (VTBL_ENTRY)&_ZN6S287C63v32Ev,
  (VTBL_ENTRY)&_ZN6S287C63v33Ev,
  (VTBL_ENTRY)&_ZN6S287C63v34Ev,
  (VTBL_ENTRY)&_ZN6S287C63v35Ev,
  (VTBL_ENTRY)&_ZN6S287C63v36Ev,
  (VTBL_ENTRY)&_ZN6S287C63v37Ev,
  (VTBL_ENTRY)&_ZN6S287C63v38Ev,
  (VTBL_ENTRY)&_ZN6S287C63v39Ev,
  (VTBL_ENTRY)&_ZN6S287C63v40Ev,
  (VTBL_ENTRY)&_ZN6S287C63v41Ev,
  (VTBL_ENTRY)&_ZN6S287C63v42Ev,
  (VTBL_ENTRY)&_ZN6S287C63v43Ev,
  (VTBL_ENTRY)&_ZN6S287C63v44Ev,
  (VTBL_ENTRY)&_ZN6S287C63v45Ev,
  (VTBL_ENTRY)&_ZN6S287C63v46Ev,
  (VTBL_ENTRY)&_ZN6S287C63v47Ev,
  (VTBL_ENTRY)&_ZN6S287C63v48Ev,
  (VTBL_ENTRY)&_ZN6S287C63v49Ev,
  (VTBL_ENTRY)&_ZN6S287C63v50Ev,
  (VTBL_ENTRY)&_ZN6S287C63v51Ev,
  (VTBL_ENTRY)&_ZN6S287C63v52Ev,
  (VTBL_ENTRY)&_ZN6S287C63v53Ev,
  (VTBL_ENTRY)&_ZN6S287C63v54Ev,
  (VTBL_ENTRY)&_ZN6S287C63v55Ev,
  (VTBL_ENTRY)&_ZN6S287C63v56Ev,
  (VTBL_ENTRY)&_ZN6S287C63v57Ev,
  (VTBL_ENTRY)&_ZN6S287C63v58Ev,
  (VTBL_ENTRY)&_ZN6S287C63v59Ev,
  (VTBL_ENTRY)&_ZN6S287C63v60Ev,
  (VTBL_ENTRY)&_ZN6S287C63v61Ev,
  (VTBL_ENTRY)&_ZN6S287C63v62Ev,
  (VTBL_ENTRY)&_ZN6S287C63v63Ev,
  (VTBL_ENTRY)&_ZN6S287C63v64Ev,
  (VTBL_ENTRY)&_ZN6S287C63v65Ev,
  (VTBL_ENTRY)&_ZN6S287C63v66Ev,
  (VTBL_ENTRY)&_ZN6S287C63v67Ev,
  (VTBL_ENTRY)&_ZN6S287C63v68Ev,
  (VTBL_ENTRY)&_ZN6S287C63v69Ev,
  (VTBL_ENTRY)&_ZN6S287C63v70Ev,
  (VTBL_ENTRY)&_ZN6S287C63v71Ev,
  (VTBL_ENTRY)&_ZN6S287C63v72Ev,
  (VTBL_ENTRY)&_ZN6S287C53v73Ev,
  (VTBL_ENTRY)&_ZN6S287C53v74Ev,
  (VTBL_ENTRY)&_ZN6S287C53v75Ev,
  (VTBL_ENTRY)&_ZN6S287C53v76Ev,
  (VTBL_ENTRY)&_ZN6S287C53v77Ev,
  (VTBL_ENTRY)&_ZN6S287C53v78Ev,
  (VTBL_ENTRY)&_ZN6S287C53v79Ev,
  (VTBL_ENTRY)&_ZN6S287C53v80Ev,
  (VTBL_ENTRY)&_ZN6S287C53v81Ev,
  (VTBL_ENTRY)&_ZN6S287C53v82Ev,
  (VTBL_ENTRY)&_ZN6S287C53v83Ev,
  (VTBL_ENTRY)&_ZN6S287C53v84Ev,
  (VTBL_ENTRY)&_ZN6S287C53v85Ev,
  (VTBL_ENTRY)&_ZN6S287C53v86Ev,
  (VTBL_ENTRY)&_ZN6S287C53v87Ev,
  (VTBL_ENTRY)&_ZN6S287C53v88Ev,
  (VTBL_ENTRY)&_ZN6S287C53v89Ev,
  (VTBL_ENTRY)&_ZN6S287C53v90Ev,
  (VTBL_ENTRY)&_ZN6S287C53v91Ev,
  (VTBL_ENTRY)&_ZN6S287C53v92Ev,
  (VTBL_ENTRY)&_ZN6S287C53v93Ev,
  (VTBL_ENTRY)&_ZN6S287C53v94Ev,
  (VTBL_ENTRY)&_ZN6S287C43v95Ev,
  (VTBL_ENTRY)&_ZN6S287C43v96Ev,
  (VTBL_ENTRY)&_ZN6S287C43v97Ev,
  (VTBL_ENTRY)&_ZN6S287C43v98Ev,
  (VTBL_ENTRY)&_ZN6S287C43v99Ev,
  (VTBL_ENTRY)&_ZN6S287C44v100Ev,
  (VTBL_ENTRY)&_ZN6S287C44v101Ev,
  (VTBL_ENTRY)&_ZN6S287C44v102Ev,
  (VTBL_ENTRY)&_ZN6S287C44v103Ev,
  (VTBL_ENTRY)&_ZN6S287C44v104Ev,
  (VTBL_ENTRY)&_ZN6S287C44v105Ev,
  (VTBL_ENTRY)&_ZN6S287C44v106Ev,
  (VTBL_ENTRY)&_ZN6S287C44v107Ev,
  (VTBL_ENTRY)&_ZN6S287C44v108Ev,
  (VTBL_ENTRY)&_ZN6S287C44v109Ev,
  (VTBL_ENTRY)&_ZN6S287C44v110Ev,
  (VTBL_ENTRY)&_ZN6S287C44v111Ev,
  (VTBL_ENTRY)&_ZN6S287C44v112Ev,
  (VTBL_ENTRY)&_ZN6S287C44v113Ev,
  (VTBL_ENTRY)&_ZN6S287C44v114Ev,
  (VTBL_ENTRY)&_ZN6S287C34v115Ev,
  (VTBL_ENTRY)&_ZN6S287C34v116Ev,
  (VTBL_ENTRY)&_ZN6S287C34v117Ev,
  (VTBL_ENTRY)&_ZN6S287C34v118Ev,
  (VTBL_ENTRY)&_ZN6S287C34v119Ev,
  (VTBL_ENTRY)&_ZN6S287C34v120Ev,
  (VTBL_ENTRY)&_ZN6S287C34v121Ev,
  (VTBL_ENTRY)&_ZN6S287C34v122Ev,
  (VTBL_ENTRY)&_ZN6S287C34v123Ev,
  (VTBL_ENTRY)&_ZN6S287C34v124Ev,
  (VTBL_ENTRY)&_ZN6S287C34v125Ev,
  (VTBL_ENTRY)&_ZN6S287C34v126Ev,
  (VTBL_ENTRY)&_ZN6S287C34v127Ev,
  (VTBL_ENTRY)&_ZN6S287C34v128Ev,
  (VTBL_ENTRY)&_ZN6S287C34v129Ev,
  (VTBL_ENTRY)&_ZN6S287C34v130Ev,
  (VTBL_ENTRY)&_ZN6S287C34v131Ev,
  (VTBL_ENTRY)&_ZN6S287C34v132Ev,
  (VTBL_ENTRY)&_ZN6S287C34v133Ev,
  (VTBL_ENTRY)&_ZN6S287C34v134Ev,
  (VTBL_ENTRY)&_ZN6S287C34v135Ev,
  (VTBL_ENTRY)&_ZN6S287C34v136Ev,
  (VTBL_ENTRY)&_ZN6S287C24v142Ev,
  (VTBL_ENTRY)&_ZN6S287C24v143Ev,
  (VTBL_ENTRY)&_ZN6S287C24v144Ev,
  (VTBL_ENTRY)&_ZN6S287C24v145Ev,
  (VTBL_ENTRY)&_ZN6S287C24v146Ev,
  (VTBL_ENTRY)&_ZN6S287C24v147Ev,
  (VTBL_ENTRY)&_ZN6S287C24v148Ev,
  (VTBL_ENTRY)&_ZN6S287C24v149Ev,
  (VTBL_ENTRY)&_ZN6S287C24v150Ev,
  (VTBL_ENTRY)&_ZN6S287C24v151Ev,
  (VTBL_ENTRY)&_ZN6S287C24v152Ev,
  (VTBL_ENTRY)&_ZN6S287C24v153Ev,
  (VTBL_ENTRY)&_ZN6S287C24v154Ev,
  (VTBL_ENTRY)&_ZN6S287C24v155Ev,
  (VTBL_ENTRY)&_ZN6S287C24v156Ev,
  (VTBL_ENTRY)&_ZN6S287C24v157Ev,
  (VTBL_ENTRY)&_ZN6S287C24v158Ev,
  (VTBL_ENTRY)&_ZN6S287C24v159Ev,
  (VTBL_ENTRY)&_ZN6S287C24v160Ev,
  (VTBL_ENTRY)&_ZN6S287C12v1Ev,
  (VTBL_ENTRY)&_ZN6S287C12v2Ev,
  (VTBL_ENTRY)&_ZN6S287C12v3Ev,
  (VTBL_ENTRY)&_ZN6S287C12v4Ev,
  (VTBL_ENTRY)&_ZN6S287C12v5Ev,
  (VTBL_ENTRY)&_ZN6S287C12v6Ev,
  (VTBL_ENTRY)&_ZN6S287C12v7Ev,
  (VTBL_ENTRY)&_ZN6S287C12v8Ev,
  ABISELECT(-376,-276),
  (VTBL_ENTRY)&(_ZTI6S287C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn376_N6S287C1D1Ev,_ZThn276_N6S287C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn376_N6S287C1D0Ev,_ZThn276_N6S287C1D0Ev),
  (VTBL_ENTRY)&_ZN10S287C31_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S287C31_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S287C31_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S287C31_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S287C31_nt4v141Ev,
};
extern VTBL_ENTRY _ZTI6S287C1[];
extern  VTBL_ENTRY _ZTV6S287C1[];
Class_Descriptor cd_S287C1 = {  "S287C1", // class name
  bases_S287C1, 6,
  &(vtc_S287C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(400,292), // object size
  NSPAIRA(_ZTI6S287C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S287C1),168, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S113C7  {
  int s113c7f0;
  __tsi64 s113c7f1;
  void *s113c7f2[4];
  int s113c7f3[2];
  void *s113c7f4;
  ::S3350C4_nt s113c7f5;
  void *s113c7f6[2];
  virtual  ~S113C7(); // _ZN6S113C7D1Ev
  virtual void  v7(); // _ZN6S113C72v7Ev
  virtual void  v8(); // _ZN6S113C72v8Ev
  virtual void  v9(); // _ZN6S113C72v9Ev
  virtual void  v10(); // _ZN6S113C73v10Ev
  virtual void  v11(); // _ZN6S113C73v11Ev
  virtual void  v12(); // _ZN6S113C73v12Ev
  virtual void  v13(); // _ZN6S113C73v13Ev
  virtual void  v14(); // _ZN6S113C73v14Ev
  virtual void  v15(); // _ZN6S113C73v15Ev
  virtual void  v16(); // _ZN6S113C73v16Ev
  virtual void  v17(); // _ZN6S113C73v17Ev
  virtual void  v18(); // _ZN6S113C73v18Ev
  virtual void  v19(); // _ZN6S113C73v19Ev
  virtual void  v20(); // _ZN6S113C73v20Ev
  virtual void  v21(); // _ZN6S113C73v21Ev
  virtual void  v22(); // _ZN6S113C73v22Ev
  virtual void  v23(); // _ZN6S113C73v23Ev
  virtual void  v24(); // _ZN6S113C73v24Ev
  virtual void  v25(); // _ZN6S113C73v25Ev
  virtual void  v26(); // _ZN6S113C73v26Ev
  virtual void  v27(); // _ZN6S113C73v27Ev
  virtual void  v28(); // _ZN6S113C73v28Ev
  virtual void  v29(); // _ZN6S113C73v29Ev
  virtual void  v30(); // _ZN6S113C73v30Ev
  virtual void  v31(); // _ZN6S113C73v31Ev
  virtual void  v32(); // _ZN6S113C73v32Ev
  virtual void  v33(); // _ZN6S113C73v33Ev
  virtual void  v34(); // _ZN6S113C73v34Ev
  virtual void  v35(); // _ZN6S113C73v35Ev
  virtual void  v36(); // _ZN6S113C73v36Ev
  virtual void  v37(); // _ZN6S113C73v37Ev
  virtual void  v38(); // _ZN6S113C73v38Ev
  virtual void  v39(); // _ZN6S113C73v39Ev
  virtual void  v40(); // _ZN6S113C73v40Ev
  virtual void  v41(); // _ZN6S113C73v41Ev
  virtual void  v42(); // _ZN6S113C73v42Ev
  virtual void  v43(); // _ZN6S113C73v43Ev
  virtual void  v44(); // _ZN6S113C73v44Ev
  virtual void  v45(); // _ZN6S113C73v45Ev
  virtual void  v46(); // _ZN6S113C73v46Ev
  virtual void  v47(); // _ZN6S113C73v47Ev
  virtual void  v48(); // _ZN6S113C73v48Ev
  virtual void  v49(); // _ZN6S113C73v49Ev
  virtual void  v50(); // _ZN6S113C73v50Ev
  virtual void  v51(); // _ZN6S113C73v51Ev
  virtual void  v52(); // _ZN6S113C73v52Ev
  virtual void  v53(); // _ZN6S113C73v53Ev
  virtual void  v54(); // _ZN6S113C73v54Ev
  virtual void  v55(); // _ZN6S113C73v55Ev
  virtual void  v56(); // _ZN6S113C73v56Ev
  virtual void  v57(); // _ZN6S113C73v57Ev
  virtual void  v58(); // _ZN6S113C73v58Ev
  virtual void  v59(); // _ZN6S113C73v59Ev
  virtual void  v60(); // _ZN6S113C73v60Ev
  virtual void  v61(); // _ZN6S113C73v61Ev
  virtual void  v62(); // _ZN6S113C73v62Ev
  virtual void  v63(); // _ZN6S113C73v63Ev
  virtual void  v64(); // _ZN6S113C73v64Ev
  virtual void  v65(); // _ZN6S113C73v65Ev
  virtual void  v66(); // _ZN6S113C73v66Ev
  virtual void  v67(); // _ZN6S113C73v67Ev
  virtual void  v68(); // _ZN6S113C73v68Ev
  virtual void  v69(); // _ZN6S113C73v69Ev
  virtual void  v70(); // _ZN6S113C73v70Ev
  S113C7(); // tgen
};
//SIG(-1 S113C7) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S113C7 ::~S113C7(){ note_dtor("S113C7", this);}
void  S113C7 ::v7(){vfunc_called(this, "_ZN6S113C72v7Ev");}
void  S113C7 ::v8(){vfunc_called(this, "_ZN6S113C72v8Ev");}
void  S113C7 ::v9(){vfunc_called(this, "_ZN6S113C72v9Ev");}
void  S113C7 ::v10(){vfunc_called(this, "_ZN6S113C73v10Ev");}
void  S113C7 ::v11(){vfunc_called(this, "_ZN6S113C73v11Ev");}
void  S113C7 ::v12(){vfunc_called(this, "_ZN6S113C73v12Ev");}
void  S113C7 ::v13(){vfunc_called(this, "_ZN6S113C73v13Ev");}
void  S113C7 ::v14(){vfunc_called(this, "_ZN6S113C73v14Ev");}
void  S113C7 ::v15(){vfunc_called(this, "_ZN6S113C73v15Ev");}
void  S113C7 ::v16(){vfunc_called(this, "_ZN6S113C73v16Ev");}
void  S113C7 ::v17(){vfunc_called(this, "_ZN6S113C73v17Ev");}
void  S113C7 ::v18(){vfunc_called(this, "_ZN6S113C73v18Ev");}
void  S113C7 ::v19(){vfunc_called(this, "_ZN6S113C73v19Ev");}
void  S113C7 ::v20(){vfunc_called(this, "_ZN6S113C73v20Ev");}
void  S113C7 ::v21(){vfunc_called(this, "_ZN6S113C73v21Ev");}
void  S113C7 ::v22(){vfunc_called(this, "_ZN6S113C73v22Ev");}
void  S113C7 ::v23(){vfunc_called(this, "_ZN6S113C73v23Ev");}
void  S113C7 ::v24(){vfunc_called(this, "_ZN6S113C73v24Ev");}
void  S113C7 ::v25(){vfunc_called(this, "_ZN6S113C73v25Ev");}
void  S113C7 ::v26(){vfunc_called(this, "_ZN6S113C73v26Ev");}
void  S113C7 ::v27(){vfunc_called(this, "_ZN6S113C73v27Ev");}
void  S113C7 ::v28(){vfunc_called(this, "_ZN6S113C73v28Ev");}
void  S113C7 ::v29(){vfunc_called(this, "_ZN6S113C73v29Ev");}
void  S113C7 ::v30(){vfunc_called(this, "_ZN6S113C73v30Ev");}
void  S113C7 ::v31(){vfunc_called(this, "_ZN6S113C73v31Ev");}
void  S113C7 ::v32(){vfunc_called(this, "_ZN6S113C73v32Ev");}
void  S113C7 ::v33(){vfunc_called(this, "_ZN6S113C73v33Ev");}
void  S113C7 ::v34(){vfunc_called(this, "_ZN6S113C73v34Ev");}
void  S113C7 ::v35(){vfunc_called(this, "_ZN6S113C73v35Ev");}
void  S113C7 ::v36(){vfunc_called(this, "_ZN6S113C73v36Ev");}
void  S113C7 ::v37(){vfunc_called(this, "_ZN6S113C73v37Ev");}
void  S113C7 ::v38(){vfunc_called(this, "_ZN6S113C73v38Ev");}
void  S113C7 ::v39(){vfunc_called(this, "_ZN6S113C73v39Ev");}
void  S113C7 ::v40(){vfunc_called(this, "_ZN6S113C73v40Ev");}
void  S113C7 ::v41(){vfunc_called(this, "_ZN6S113C73v41Ev");}
void  S113C7 ::v42(){vfunc_called(this, "_ZN6S113C73v42Ev");}
void  S113C7 ::v43(){vfunc_called(this, "_ZN6S113C73v43Ev");}
void  S113C7 ::v44(){vfunc_called(this, "_ZN6S113C73v44Ev");}
void  S113C7 ::v45(){vfunc_called(this, "_ZN6S113C73v45Ev");}
void  S113C7 ::v46(){vfunc_called(this, "_ZN6S113C73v46Ev");}
void  S113C7 ::v47(){vfunc_called(this, "_ZN6S113C73v47Ev");}
void  S113C7 ::v48(){vfunc_called(this, "_ZN6S113C73v48Ev");}
void  S113C7 ::v49(){vfunc_called(this, "_ZN6S113C73v49Ev");}
void  S113C7 ::v50(){vfunc_called(this, "_ZN6S113C73v50Ev");}
void  S113C7 ::v51(){vfunc_called(this, "_ZN6S113C73v51Ev");}
void  S113C7 ::v52(){vfunc_called(this, "_ZN6S113C73v52Ev");}
void  S113C7 ::v53(){vfunc_called(this, "_ZN6S113C73v53Ev");}
void  S113C7 ::v54(){vfunc_called(this, "_ZN6S113C73v54Ev");}
void  S113C7 ::v55(){vfunc_called(this, "_ZN6S113C73v55Ev");}
void  S113C7 ::v56(){vfunc_called(this, "_ZN6S113C73v56Ev");}
void  S113C7 ::v57(){vfunc_called(this, "_ZN6S113C73v57Ev");}
void  S113C7 ::v58(){vfunc_called(this, "_ZN6S113C73v58Ev");}
void  S113C7 ::v59(){vfunc_called(this, "_ZN6S113C73v59Ev");}
void  S113C7 ::v60(){vfunc_called(this, "_ZN6S113C73v60Ev");}
void  S113C7 ::v61(){vfunc_called(this, "_ZN6S113C73v61Ev");}
void  S113C7 ::v62(){vfunc_called(this, "_ZN6S113C73v62Ev");}
void  S113C7 ::v63(){vfunc_called(this, "_ZN6S113C73v63Ev");}
void  S113C7 ::v64(){vfunc_called(this, "_ZN6S113C73v64Ev");}
void  S113C7 ::v65(){vfunc_called(this, "_ZN6S113C73v65Ev");}
void  S113C7 ::v66(){vfunc_called(this, "_ZN6S113C73v66Ev");}
void  S113C7 ::v67(){vfunc_called(this, "_ZN6S113C73v67Ev");}
void  S113C7 ::v68(){vfunc_called(this, "_ZN6S113C73v68Ev");}
void  S113C7 ::v69(){vfunc_called(this, "_ZN6S113C73v69Ev");}
void  S113C7 ::v70(){vfunc_called(this, "_ZN6S113C73v70Ev");}
S113C7 ::S113C7(){ note_ctor("S113C7", this);} // tgen

static void Test_S113C7()
{
  extern Class_Descriptor cd_S113C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S113C7, buf);
    S113C7 *dp, &lv = *(dp=new (buf) S113C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S113C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S113C7)");
    check_field_offset(lv, s113c7f0, ABISELECT(8,4), "S113C7.s113c7f0");
    check_field_offset(lv, s113c7f1, ABISELECT(16,8), "S113C7.s113c7f1");
    check_field_offset(lv, s113c7f2, ABISELECT(24,16), "S113C7.s113c7f2");
    check_field_offset(lv, s113c7f3, ABISELECT(56,32), "S113C7.s113c7f3");
    check_field_offset(lv, s113c7f4, ABISELECT(64,40), "S113C7.s113c7f4");
    check_field_offset(lv, s113c7f5, ABISELECT(72,44), "S113C7.s113c7f5");
    check_field_offset(lv, s113c7f6, ABISELECT(80,52), "S113C7.s113c7f6");
    test_class_info(&lv, &cd_S113C7);
    dp->~S113C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS113C7(Test_S113C7, "S113C7", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S113C7C1Ev();
extern void _ZN6S113C7D1Ev();
Name_Map name_map_S113C7[] = {
  NSPAIR(_ZN6S113C7C1Ev),
  NSPAIR(_ZN6S113C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S113C7[];
extern void _ZN6S113C7D1Ev();
extern void _ZN6S113C7D0Ev();
extern void _ZN6S113C72v7Ev();
extern void _ZN6S113C72v8Ev();
extern void _ZN6S113C72v9Ev();
extern void _ZN6S113C73v10Ev();
extern void _ZN6S113C73v11Ev();
extern void _ZN6S113C73v12Ev();
extern void _ZN6S113C73v13Ev();
extern void _ZN6S113C73v14Ev();
extern void _ZN6S113C73v15Ev();
extern void _ZN6S113C73v16Ev();
extern void _ZN6S113C73v17Ev();
extern void _ZN6S113C73v18Ev();
extern void _ZN6S113C73v19Ev();
extern void _ZN6S113C73v20Ev();
extern void _ZN6S113C73v21Ev();
extern void _ZN6S113C73v22Ev();
extern void _ZN6S113C73v23Ev();
extern void _ZN6S113C73v24Ev();
extern void _ZN6S113C73v25Ev();
extern void _ZN6S113C73v26Ev();
extern void _ZN6S113C73v27Ev();
extern void _ZN6S113C73v28Ev();
extern void _ZN6S113C73v29Ev();
extern void _ZN6S113C73v30Ev();
extern void _ZN6S113C73v31Ev();
extern void _ZN6S113C73v32Ev();
extern void _ZN6S113C73v33Ev();
extern void _ZN6S113C73v34Ev();
extern void _ZN6S113C73v35Ev();
extern void _ZN6S113C73v36Ev();
extern void _ZN6S113C73v37Ev();
extern void _ZN6S113C73v38Ev();
extern void _ZN6S113C73v39Ev();
extern void _ZN6S113C73v40Ev();
extern void _ZN6S113C73v41Ev();
extern void _ZN6S113C73v42Ev();
extern void _ZN6S113C73v43Ev();
extern void _ZN6S113C73v44Ev();
extern void _ZN6S113C73v45Ev();
extern void _ZN6S113C73v46Ev();
extern void _ZN6S113C73v47Ev();
extern void _ZN6S113C73v48Ev();
extern void _ZN6S113C73v49Ev();
extern void _ZN6S113C73v50Ev();
extern void _ZN6S113C73v51Ev();
extern void _ZN6S113C73v52Ev();
extern void _ZN6S113C73v53Ev();
extern void _ZN6S113C73v54Ev();
extern void _ZN6S113C73v55Ev();
extern void _ZN6S113C73v56Ev();
extern void _ZN6S113C73v57Ev();
extern void _ZN6S113C73v58Ev();
extern void _ZN6S113C73v59Ev();
extern void _ZN6S113C73v60Ev();
extern void _ZN6S113C73v61Ev();
extern void _ZN6S113C73v62Ev();
extern void _ZN6S113C73v63Ev();
extern void _ZN6S113C73v64Ev();
extern void _ZN6S113C73v65Ev();
extern void _ZN6S113C73v66Ev();
extern void _ZN6S113C73v67Ev();
extern void _ZN6S113C73v68Ev();
extern void _ZN6S113C73v69Ev();
extern void _ZN6S113C73v70Ev();
static  VTBL_ENTRY vtc_S113C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S113C7[0]),
  (VTBL_ENTRY)&_ZN6S113C7D1Ev,
  (VTBL_ENTRY)&_ZN6S113C7D0Ev,
  (VTBL_ENTRY)&_ZN6S113C72v7Ev,
  (VTBL_ENTRY)&_ZN6S113C72v8Ev,
  (VTBL_ENTRY)&_ZN6S113C72v9Ev,
  (VTBL_ENTRY)&_ZN6S113C73v10Ev,
  (VTBL_ENTRY)&_ZN6S113C73v11Ev,
  (VTBL_ENTRY)&_ZN6S113C73v12Ev,
  (VTBL_ENTRY)&_ZN6S113C73v13Ev,
  (VTBL_ENTRY)&_ZN6S113C73v14Ev,
  (VTBL_ENTRY)&_ZN6S113C73v15Ev,
  (VTBL_ENTRY)&_ZN6S113C73v16Ev,
  (VTBL_ENTRY)&_ZN6S113C73v17Ev,
  (VTBL_ENTRY)&_ZN6S113C73v18Ev,
  (VTBL_ENTRY)&_ZN6S113C73v19Ev,
  (VTBL_ENTRY)&_ZN6S113C73v20Ev,
  (VTBL_ENTRY)&_ZN6S113C73v21Ev,
  (VTBL_ENTRY)&_ZN6S113C73v22Ev,
  (VTBL_ENTRY)&_ZN6S113C73v23Ev,
  (VTBL_ENTRY)&_ZN6S113C73v24Ev,
  (VTBL_ENTRY)&_ZN6S113C73v25Ev,
  (VTBL_ENTRY)&_ZN6S113C73v26Ev,
  (VTBL_ENTRY)&_ZN6S113C73v27Ev,
  (VTBL_ENTRY)&_ZN6S113C73v28Ev,
  (VTBL_ENTRY)&_ZN6S113C73v29Ev,
  (VTBL_ENTRY)&_ZN6S113C73v30Ev,
  (VTBL_ENTRY)&_ZN6S113C73v31Ev,
  (VTBL_ENTRY)&_ZN6S113C73v32Ev,
  (VTBL_ENTRY)&_ZN6S113C73v33Ev,
  (VTBL_ENTRY)&_ZN6S113C73v34Ev,
  (VTBL_ENTRY)&_ZN6S113C73v35Ev,
  (VTBL_ENTRY)&_ZN6S113C73v36Ev,
  (VTBL_ENTRY)&_ZN6S113C73v37Ev,
  (VTBL_ENTRY)&_ZN6S113C73v38Ev,
  (VTBL_ENTRY)&_ZN6S113C73v39Ev,
  (VTBL_ENTRY)&_ZN6S113C73v40Ev,
  (VTBL_ENTRY)&_ZN6S113C73v41Ev,
  (VTBL_ENTRY)&_ZN6S113C73v42Ev,
  (VTBL_ENTRY)&_ZN6S113C73v43Ev,
  (VTBL_ENTRY)&_ZN6S113C73v44Ev,
  (VTBL_ENTRY)&_ZN6S113C73v45Ev,
  (VTBL_ENTRY)&_ZN6S113C73v46Ev,
  (VTBL_ENTRY)&_ZN6S113C73v47Ev,
  (VTBL_ENTRY)&_ZN6S113C73v48Ev,
  (VTBL_ENTRY)&_ZN6S113C73v49Ev,
  (VTBL_ENTRY)&_ZN6S113C73v50Ev,
  (VTBL_ENTRY)&_ZN6S113C73v51Ev,
  (VTBL_ENTRY)&_ZN6S113C73v52Ev,
  (VTBL_ENTRY)&_ZN6S113C73v53Ev,
  (VTBL_ENTRY)&_ZN6S113C73v54Ev,
  (VTBL_ENTRY)&_ZN6S113C73v55Ev,
  (VTBL_ENTRY)&_ZN6S113C73v56Ev,
  (VTBL_ENTRY)&_ZN6S113C73v57Ev,
  (VTBL_ENTRY)&_ZN6S113C73v58Ev,
  (VTBL_ENTRY)&_ZN6S113C73v59Ev,
  (VTBL_ENTRY)&_ZN6S113C73v60Ev,
  (VTBL_ENTRY)&_ZN6S113C73v61Ev,
  (VTBL_ENTRY)&_ZN6S113C73v62Ev,
  (VTBL_ENTRY)&_ZN6S113C73v63Ev,
  (VTBL_ENTRY)&_ZN6S113C73v64Ev,
  (VTBL_ENTRY)&_ZN6S113C73v65Ev,
  (VTBL_ENTRY)&_ZN6S113C73v66Ev,
  (VTBL_ENTRY)&_ZN6S113C73v67Ev,
  (VTBL_ENTRY)&_ZN6S113C73v68Ev,
  (VTBL_ENTRY)&_ZN6S113C73v69Ev,
  (VTBL_ENTRY)&_ZN6S113C73v70Ev,
};
extern VTBL_ENTRY _ZTI6S113C7[];
extern  VTBL_ENTRY _ZTV6S113C7[];
Class_Descriptor cd_S113C7 = {  "S113C7", // class name
  0,0,//no base classes
  &(vtc_S113C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S113C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S113C7),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S113C6  : S113C7 {
  int s113c6f0[2];
  void *s113c6f1;
  int s113c6f2[2];
  ::S287C8_nt s113c6f3;
  ::S287C8_nt s113c6f4;
  ::S2121C38 s113c6f5;
  ::S287C8_nt s113c6f6;
  unsigned int s113c6f7:1;
  unsigned int s113c6f8:1;
  unsigned int s113c6f9:1;
  unsigned int s113c6f10:1;
  unsigned int s113c6f11:1;
  int s113c6f12[2];
  virtual  ~S113C6(); // _ZN6S113C6D1Ev
  virtual void  v71(); // _ZN6S113C63v71Ev
  virtual void  v72(); // _ZN6S113C63v72Ev
  virtual void  v73(); // _ZN6S113C63v73Ev
  virtual void  v74(); // _ZN6S113C63v74Ev
  virtual void  v75(); // _ZN6S113C63v75Ev
  virtual void  v76(); // _ZN6S113C63v76Ev
  virtual void  v77(); // _ZN6S113C63v77Ev
  virtual void  v78(); // _ZN6S113C63v78Ev
  virtual void  v79(); // _ZN6S113C63v79Ev
  virtual void  v80(); // _ZN6S113C63v80Ev
  virtual void  v81(); // _ZN6S113C63v81Ev
  virtual void  v82(); // _ZN6S113C63v82Ev
  virtual void  v83(); // _ZN6S113C63v83Ev
  virtual void  v84(); // _ZN6S113C63v84Ev
  virtual void  v85(); // _ZN6S113C63v85Ev
  virtual void  v86(); // _ZN6S113C63v86Ev
  virtual void  v87(); // _ZN6S113C63v87Ev
  virtual void  v88(); // _ZN6S113C63v88Ev
  virtual void  v89(); // _ZN6S113C63v89Ev
  virtual void  v90(); // _ZN6S113C63v90Ev
  virtual void  v91(); // _ZN6S113C63v91Ev
  virtual void  v92(); // _ZN6S113C63v92Ev
  S113C6(); // tgen
};
//SIG(-1 S113C6) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S113C6 ::~S113C6(){ note_dtor("S113C6", this);}
void  S113C6 ::v71(){vfunc_called(this, "_ZN6S113C63v71Ev");}
void  S113C6 ::v72(){vfunc_called(this, "_ZN6S113C63v72Ev");}
void  S113C6 ::v73(){vfunc_called(this, "_ZN6S113C63v73Ev");}
void  S113C6 ::v74(){vfunc_called(this, "_ZN6S113C63v74Ev");}
void  S113C6 ::v75(){vfunc_called(this, "_ZN6S113C63v75Ev");}
void  S113C6 ::v76(){vfunc_called(this, "_ZN6S113C63v76Ev");}
void  S113C6 ::v77(){vfunc_called(this, "_ZN6S113C63v77Ev");}
void  S113C6 ::v78(){vfunc_called(this, "_ZN6S113C63v78Ev");}
void  S113C6 ::v79(){vfunc_called(this, "_ZN6S113C63v79Ev");}
void  S113C6 ::v80(){vfunc_called(this, "_ZN6S113C63v80Ev");}
void  S113C6 ::v81(){vfunc_called(this, "_ZN6S113C63v81Ev");}
void  S113C6 ::v82(){vfunc_called(this, "_ZN6S113C63v82Ev");}
void  S113C6 ::v83(){vfunc_called(this, "_ZN6S113C63v83Ev");}
void  S113C6 ::v84(){vfunc_called(this, "_ZN6S113C63v84Ev");}
void  S113C6 ::v85(){vfunc_called(this, "_ZN6S113C63v85Ev");}
void  S113C6 ::v86(){vfunc_called(this, "_ZN6S113C63v86Ev");}
void  S113C6 ::v87(){vfunc_called(this, "_ZN6S113C63v87Ev");}
void  S113C6 ::v88(){vfunc_called(this, "_ZN6S113C63v88Ev");}
void  S113C6 ::v89(){vfunc_called(this, "_ZN6S113C63v89Ev");}
void  S113C6 ::v90(){vfunc_called(this, "_ZN6S113C63v90Ev");}
void  S113C6 ::v91(){vfunc_called(this, "_ZN6S113C63v91Ev");}
void  S113C6 ::v92(){vfunc_called(this, "_ZN6S113C63v92Ev");}
S113C6 ::S113C6(){ note_ctor("S113C6", this);} // tgen

static void Test_S113C6()
{
  extern Class_Descriptor cd_S113C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S113C6, buf);
    S113C6 *dp, &lv = *(dp=new (buf) S113C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S113C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S113C6)");
    check_base_class_offset(lv, (S113C7*), 0, "S113C6");
    check_field_offset(lv, s113c6f0, ABISELECT(96,60), "S113C6.s113c6f0");
    check_field_offset(lv, s113c6f1, ABISELECT(104,68), "S113C6.s113c6f1");
    check_field_offset(lv, s113c6f2, ABISELECT(112,72), "S113C6.s113c6f2");
    check_field_offset(lv, s113c6f3, ABISELECT(120,80), "S113C6.s113c6f3");
    check_field_offset(lv, s113c6f4, ABISELECT(136,92), "S113C6.s113c6f4");
    check_field_offset(lv, s113c6f5, ABISELECT(152,104), "S113C6.s113c6f5");
    check_field_offset(lv, s113c6f6, ABISELECT(160,108), "S113C6.s113c6f6");
    set_bf_and_test(lv, s113c6f7, ABISELECT(176,120), 0, 1, 1, "S113C6");
    set_bf_and_test(lv, s113c6f8, ABISELECT(176,120), 1, 1, 1, "S113C6");
    set_bf_and_test(lv, s113c6f9, ABISELECT(176,120), 2, 1, 1, "S113C6");
    set_bf_and_test(lv, s113c6f10, ABISELECT(176,120), 3, 1, 1, "S113C6");
    set_bf_and_test(lv, s113c6f11, ABISELECT(176,120), 4, 1, 1, "S113C6");
    check_field_offset(lv, s113c6f12, ABISELECT(180,124), "S113C6.s113c6f12");
    test_class_info(&lv, &cd_S113C6);
    dp->~S113C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS113C6(Test_S113C6, "S113C6", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN6S113C6C1Ev();
extern void _ZN6S113C6D1Ev();
Name_Map name_map_S113C6[] = {
  NSPAIR(_ZN6S113C6C1Ev),
  NSPAIR(_ZN6S113C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S113C7;
extern VTBL_ENTRY _ZTI6S113C7[];
extern  VTBL_ENTRY _ZTV6S113C7[];
static Base_Class bases_S113C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S113C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S113C6[];
extern void _ZN6S113C6D1Ev();
extern void _ZN6S113C6D0Ev();
extern void _ZN6S113C72v7Ev();
extern void _ZN6S113C72v8Ev();
extern void _ZN6S113C72v9Ev();
extern void _ZN6S113C73v10Ev();
extern void _ZN6S113C73v11Ev();
extern void _ZN6S113C73v12Ev();
extern void _ZN6S113C73v13Ev();
extern void _ZN6S113C73v14Ev();
extern void _ZN6S113C73v15Ev();
extern void _ZN6S113C73v16Ev();
extern void _ZN6S113C73v17Ev();
extern void _ZN6S113C73v18Ev();
extern void _ZN6S113C73v19Ev();
extern void _ZN6S113C73v20Ev();
extern void _ZN6S113C73v21Ev();
extern void _ZN6S113C73v22Ev();
extern void _ZN6S113C73v23Ev();
extern void _ZN6S113C73v24Ev();
extern void _ZN6S113C73v25Ev();
extern void _ZN6S113C73v26Ev();
extern void _ZN6S113C73v27Ev();
extern void _ZN6S113C73v28Ev();
extern void _ZN6S113C73v29Ev();
extern void _ZN6S113C73v30Ev();
extern void _ZN6S113C73v31Ev();
extern void _ZN6S113C73v32Ev();
extern void _ZN6S113C73v33Ev();
extern void _ZN6S113C73v34Ev();
extern void _ZN6S113C73v35Ev();
extern void _ZN6S113C73v36Ev();
extern void _ZN6S113C73v37Ev();
extern void _ZN6S113C73v38Ev();
extern void _ZN6S113C73v39Ev();
extern void _ZN6S113C73v40Ev();
extern void _ZN6S113C73v41Ev();
extern void _ZN6S113C73v42Ev();
extern void _ZN6S113C73v43Ev();
extern void _ZN6S113C73v44Ev();
extern void _ZN6S113C73v45Ev();
extern void _ZN6S113C73v46Ev();
extern void _ZN6S113C73v47Ev();
extern void _ZN6S113C73v48Ev();
extern void _ZN6S113C73v49Ev();
extern void _ZN6S113C73v50Ev();
extern void _ZN6S113C73v51Ev();
extern void _ZN6S113C73v52Ev();
extern void _ZN6S113C73v53Ev();
extern void _ZN6S113C73v54Ev();
extern void _ZN6S113C73v55Ev();
extern void _ZN6S113C73v56Ev();
extern void _ZN6S113C73v57Ev();
extern void _ZN6S113C73v58Ev();
extern void _ZN6S113C73v59Ev();
extern void _ZN6S113C73v60Ev();
extern void _ZN6S113C73v61Ev();
extern void _ZN6S113C73v62Ev();
extern void _ZN6S113C73v63Ev();
extern void _ZN6S113C73v64Ev();
extern void _ZN6S113C73v65Ev();
extern void _ZN6S113C73v66Ev();
extern void _ZN6S113C73v67Ev();
extern void _ZN6S113C73v68Ev();
extern void _ZN6S113C73v69Ev();
extern void _ZN6S113C73v70Ev();
extern void _ZN6S113C63v71Ev();
extern void _ZN6S113C63v72Ev();
extern void _ZN6S113C63v73Ev();
extern void _ZN6S113C63v74Ev();
extern void _ZN6S113C63v75Ev();
extern void _ZN6S113C63v76Ev();
extern void _ZN6S113C63v77Ev();
extern void _ZN6S113C63v78Ev();
extern void _ZN6S113C63v79Ev();
extern void _ZN6S113C63v80Ev();
extern void _ZN6S113C63v81Ev();
extern void _ZN6S113C63v82Ev();
extern void _ZN6S113C63v83Ev();
extern void _ZN6S113C63v84Ev();
extern void _ZN6S113C63v85Ev();
extern void _ZN6S113C63v86Ev();
extern void _ZN6S113C63v87Ev();
extern void _ZN6S113C63v88Ev();
extern void _ZN6S113C63v89Ev();
extern void _ZN6S113C63v90Ev();
extern void _ZN6S113C63v91Ev();
extern void _ZN6S113C63v92Ev();
static  VTBL_ENTRY vtc_S113C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S113C6[0]),
  (VTBL_ENTRY)&_ZN6S113C6D1Ev,
  (VTBL_ENTRY)&_ZN6S113C6D0Ev,
  (VTBL_ENTRY)&_ZN6S113C72v7Ev,
  (VTBL_ENTRY)&_ZN6S113C72v8Ev,
  (VTBL_ENTRY)&_ZN6S113C72v9Ev,
  (VTBL_ENTRY)&_ZN6S113C73v10Ev,
  (VTBL_ENTRY)&_ZN6S113C73v11Ev,
  (VTBL_ENTRY)&_ZN6S113C73v12Ev,
  (VTBL_ENTRY)&_ZN6S113C73v13Ev,
  (VTBL_ENTRY)&_ZN6S113C73v14Ev,
  (VTBL_ENTRY)&_ZN6S113C73v15Ev,
  (VTBL_ENTRY)&_ZN6S113C73v16Ev,
  (VTBL_ENTRY)&_ZN6S113C73v17Ev,
  (VTBL_ENTRY)&_ZN6S113C73v18Ev,
  (VTBL_ENTRY)&_ZN6S113C73v19Ev,
  (VTBL_ENTRY)&_ZN6S113C73v20Ev,
  (VTBL_ENTRY)&_ZN6S113C73v21Ev,
  (VTBL_ENTRY)&_ZN6S113C73v22Ev,
  (VTBL_ENTRY)&_ZN6S113C73v23Ev,
  (VTBL_ENTRY)&_ZN6S113C73v24Ev,
  (VTBL_ENTRY)&_ZN6S113C73v25Ev,
  (VTBL_ENTRY)&_ZN6S113C73v26Ev,
  (VTBL_ENTRY)&_ZN6S113C73v27Ev,
  (VTBL_ENTRY)&_ZN6S113C73v28Ev,
  (VTBL_ENTRY)&_ZN6S113C73v29Ev,
  (VTBL_ENTRY)&_ZN6S113C73v30Ev,
  (VTBL_ENTRY)&_ZN6S113C73v31Ev,
  (VTBL_ENTRY)&_ZN6S113C73v32Ev,
  (VTBL_ENTRY)&_ZN6S113C73v33Ev,
  (VTBL_ENTRY)&_ZN6S113C73v34Ev,
  (VTBL_ENTRY)&_ZN6S113C73v35Ev,
  (VTBL_ENTRY)&_ZN6S113C73v36Ev,
  (VTBL_ENTRY)&_ZN6S113C73v37Ev,
  (VTBL_ENTRY)&_ZN6S113C73v38Ev,
  (VTBL_ENTRY)&_ZN6S113C73v39Ev,
  (VTBL_ENTRY)&_ZN6S113C73v40Ev,
  (VTBL_ENTRY)&_ZN6S113C73v41Ev,
  (VTBL_ENTRY)&_ZN6S113C73v42Ev,
  (VTBL_ENTRY)&_ZN6S113C73v43Ev,
  (VTBL_ENTRY)&_ZN6S113C73v44Ev,
  (VTBL_ENTRY)&_ZN6S113C73v45Ev,
  (VTBL_ENTRY)&_ZN6S113C73v46Ev,
  (VTBL_ENTRY)&_ZN6S113C73v47Ev,
  (VTBL_ENTRY)&_ZN6S113C73v48Ev,
  (VTBL_ENTRY)&_ZN6S113C73v49Ev,
  (VTBL_ENTRY)&_ZN6S113C73v50Ev,
  (VTBL_ENTRY)&_ZN6S113C73v51Ev,
  (VTBL_ENTRY)&_ZN6S113C73v52Ev,
  (VTBL_ENTRY)&_ZN6S113C73v53Ev,
  (VTBL_ENTRY)&_ZN6S113C73v54Ev,
  (VTBL_ENTRY)&_ZN6S113C73v55Ev,
  (VTBL_ENTRY)&_ZN6S113C73v56Ev,
  (VTBL_ENTRY)&_ZN6S113C73v57Ev,
  (VTBL_ENTRY)&_ZN6S113C73v58Ev,
  (VTBL_ENTRY)&_ZN6S113C73v59Ev,
  (VTBL_ENTRY)&_ZN6S113C73v60Ev,
  (VTBL_ENTRY)&_ZN6S113C73v61Ev,
  (VTBL_ENTRY)&_ZN6S113C73v62Ev,
  (VTBL_ENTRY)&_ZN6S113C73v63Ev,
  (VTBL_ENTRY)&_ZN6S113C73v64Ev,
  (VTBL_ENTRY)&_ZN6S113C73v65Ev,
  (VTBL_ENTRY)&_ZN6S113C73v66Ev,
  (VTBL_ENTRY)&_ZN6S113C73v67Ev,
  (VTBL_ENTRY)&_ZN6S113C73v68Ev,
  (VTBL_ENTRY)&_ZN6S113C73v69Ev,
  (VTBL_ENTRY)&_ZN6S113C73v70Ev,
  (VTBL_ENTRY)&_ZN6S113C63v71Ev,
  (VTBL_ENTRY)&_ZN6S113C63v72Ev,
  (VTBL_ENTRY)&_ZN6S113C63v73Ev,
  (VTBL_ENTRY)&_ZN6S113C63v74Ev,
  (VTBL_ENTRY)&_ZN6S113C63v75Ev,
  (VTBL_ENTRY)&_ZN6S113C63v76Ev,
  (VTBL_ENTRY)&_ZN6S113C63v77Ev,
  (VTBL_ENTRY)&_ZN6S113C63v78Ev,
  (VTBL_ENTRY)&_ZN6S113C63v79Ev,
  (VTBL_ENTRY)&_ZN6S113C63v80Ev,
  (VTBL_ENTRY)&_ZN6S113C63v81Ev,
  (VTBL_ENTRY)&_ZN6S113C63v82Ev,
  (VTBL_ENTRY)&_ZN6S113C63v83Ev,
  (VTBL_ENTRY)&_ZN6S113C63v84Ev,
  (VTBL_ENTRY)&_ZN6S113C63v85Ev,
  (VTBL_ENTRY)&_ZN6S113C63v86Ev,
  (VTBL_ENTRY)&_ZN6S113C63v87Ev,
  (VTBL_ENTRY)&_ZN6S113C63v88Ev,
  (VTBL_ENTRY)&_ZN6S113C63v89Ev,
  (VTBL_ENTRY)&_ZN6S113C63v90Ev,
  (VTBL_ENTRY)&_ZN6S113C63v91Ev,
  (VTBL_ENTRY)&_ZN6S113C63v92Ev,
};
extern VTBL_ENTRY _ZTI6S113C6[];
extern  VTBL_ENTRY _ZTV6S113C6[];
Class_Descriptor cd_S113C6 = {  "S113C6", // class name
  bases_S113C6, 1,
  &(vtc_S113C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI6S113C6),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S113C6),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S113C5  : S113C6 {
  unsigned int s113c5f0:1;
  unsigned int s113c5f1:1;
  unsigned int s113c5f2:1;
  ::S3350C17 s113c5f3;
  ::S3350C11 s113c5f4;
  ::S3350C5_nt s113c5f5;
  ::S287C27 s113c5f6;
  int s113c5f7[3];
  virtual  ~S113C5(); // _ZN6S113C5D1Ev
  virtual void  v93(); // _ZN6S113C53v93Ev
  virtual void  v94(); // _ZN6S113C53v94Ev
  virtual void  v95(); // _ZN6S113C53v95Ev
  virtual void  v96(); // _ZN6S113C53v96Ev
  virtual void  v97(); // _ZN6S113C53v97Ev
  virtual void  v98(); // _ZN6S113C53v98Ev
  virtual void  v99(); // _ZN6S113C53v99Ev
  virtual void  v100(); // _ZN6S113C54v100Ev
  virtual void  v101(); // _ZN6S113C54v101Ev
  virtual void  v102(); // _ZN6S113C54v102Ev
  virtual void  v103(); // _ZN6S113C54v103Ev
  virtual void  v104(); // _ZN6S113C54v104Ev
  virtual void  v105(); // _ZN6S113C54v105Ev
  virtual void  v106(); // _ZN6S113C54v106Ev
  virtual void  v107(); // _ZN6S113C54v107Ev
  virtual void  v108(); // _ZN6S113C54v108Ev
  virtual void  v109(); // _ZN6S113C54v109Ev
  virtual void  v110(); // _ZN6S113C54v110Ev
  virtual void  v111(); // _ZN6S113C54v111Ev
  virtual void  v112(); // _ZN6S113C54v112Ev
  S113C5(); // tgen
};
//SIG(-1 S113C5) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} FC16{ BC17{ BC8}} Fi[3]}


 S113C5 ::~S113C5(){ note_dtor("S113C5", this);}
void  S113C5 ::v93(){vfunc_called(this, "_ZN6S113C53v93Ev");}
void  S113C5 ::v94(){vfunc_called(this, "_ZN6S113C53v94Ev");}
void  S113C5 ::v95(){vfunc_called(this, "_ZN6S113C53v95Ev");}
void  S113C5 ::v96(){vfunc_called(this, "_ZN6S113C53v96Ev");}
void  S113C5 ::v97(){vfunc_called(this, "_ZN6S113C53v97Ev");}
void  S113C5 ::v98(){vfunc_called(this, "_ZN6S113C53v98Ev");}
void  S113C5 ::v99(){vfunc_called(this, "_ZN6S113C53v99Ev");}
void  S113C5 ::v100(){vfunc_called(this, "_ZN6S113C54v100Ev");}
void  S113C5 ::v101(){vfunc_called(this, "_ZN6S113C54v101Ev");}
void  S113C5 ::v102(){vfunc_called(this, "_ZN6S113C54v102Ev");}
void  S113C5 ::v103(){vfunc_called(this, "_ZN6S113C54v103Ev");}
void  S113C5 ::v104(){vfunc_called(this, "_ZN6S113C54v104Ev");}
void  S113C5 ::v105(){vfunc_called(this, "_ZN6S113C54v105Ev");}
void  S113C5 ::v106(){vfunc_called(this, "_ZN6S113C54v106Ev");}
void  S113C5 ::v107(){vfunc_called(this, "_ZN6S113C54v107Ev");}
void  S113C5 ::v108(){vfunc_called(this, "_ZN6S113C54v108Ev");}
void  S113C5 ::v109(){vfunc_called(this, "_ZN6S113C54v109Ev");}
void  S113C5 ::v110(){vfunc_called(this, "_ZN6S113C54v110Ev");}
void  S113C5 ::v111(){vfunc_called(this, "_ZN6S113C54v111Ev");}
void  S113C5 ::v112(){vfunc_called(this, "_ZN6S113C54v112Ev");}
S113C5 ::S113C5(){ note_ctor("S113C5", this);} // tgen

static void Test_S113C5()
{
  extern Class_Descriptor cd_S113C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(35,50)];
    init_test(&cd_S113C5, buf);
    S113C5 *dp, &lv = *(dp=new (buf) S113C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,196), "sizeof(S113C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S113C5)");
    check_base_class_offset(lv, (S113C7*)(S113C6*), 0, "S113C5");
    check_base_class_offset(lv, (S113C6*), 0, "S113C5");
    set_bf_and_test(lv, s113c5f0, ABISELECT(188,132), 0, 1, 1, "S113C5");
    set_bf_and_test(lv, s113c5f1, ABISELECT(188,132), 1, 1, 1, "S113C5");
    set_bf_and_test(lv, s113c5f2, ABISELECT(188,132), 2, 1, 1, "S113C5");
    check_field_offset(lv, s113c5f3, ABISELECT(192,136), "S113C5.s113c5f3");
    check_field_offset(lv, s113c5f4, ABISELECT(208,148), "S113C5.s113c5f4");
    check_field_offset(lv, s113c5f5, ABISELECT(224,160), "S113C5.s113c5f5");
    check_field_offset(lv, s113c5f6, ABISELECT(240,172), "S113C5.s113c5f6");
    check_field_offset(lv, s113c5f7, ABISELECT(256,184), "S113C5.s113c5f7");
    test_class_info(&lv, &cd_S113C5);
    dp->~S113C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS113C5(Test_S113C5, "S113C5", ABISELECT(272,196));

#else // __cplusplus

extern void _ZN6S113C5C1Ev();
extern void _ZN6S113C5D1Ev();
Name_Map name_map_S113C5[] = {
  NSPAIR(_ZN6S113C5C1Ev),
  NSPAIR(_ZN6S113C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S113C7;
extern VTBL_ENTRY _ZTI6S113C7[];
extern  VTBL_ENTRY _ZTV6S113C7[];
extern Class_Descriptor cd_S113C6;
extern VTBL_ENTRY _ZTI6S113C6[];
extern  VTBL_ENTRY _ZTV6S113C6[];
static Base_Class bases_S113C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S113C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S113C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S113C5[];
extern void _ZN6S113C5D1Ev();
extern void _ZN6S113C5D0Ev();
extern void _ZN6S113C72v7Ev();
extern void _ZN6S113C72v8Ev();
extern void _ZN6S113C72v9Ev();
extern void _ZN6S113C73v10Ev();
extern void _ZN6S113C73v11Ev();
extern void _ZN6S113C73v12Ev();
extern void _ZN6S113C73v13Ev();
extern void _ZN6S113C73v14Ev();
extern void _ZN6S113C73v15Ev();
extern void _ZN6S113C73v16Ev();
extern void _ZN6S113C73v17Ev();
extern void _ZN6S113C73v18Ev();
extern void _ZN6S113C73v19Ev();
extern void _ZN6S113C73v20Ev();
extern void _ZN6S113C73v21Ev();
extern void _ZN6S113C73v22Ev();
extern void _ZN6S113C73v23Ev();
extern void _ZN6S113C73v24Ev();
extern void _ZN6S113C73v25Ev();
extern void _ZN6S113C73v26Ev();
extern void _ZN6S113C73v27Ev();
extern void _ZN6S113C73v28Ev();
extern void _ZN6S113C73v29Ev();
extern void _ZN6S113C73v30Ev();
extern void _ZN6S113C73v31Ev();
extern void _ZN6S113C73v32Ev();
extern void _ZN6S113C73v33Ev();
extern void _ZN6S113C73v34Ev();
extern void _ZN6S113C73v35Ev();
extern void _ZN6S113C73v36Ev();
extern void _ZN6S113C73v37Ev();
extern void _ZN6S113C73v38Ev();
extern void _ZN6S113C73v39Ev();
extern void _ZN6S113C73v40Ev();
extern void _ZN6S113C73v41Ev();
extern void _ZN6S113C73v42Ev();
extern void _ZN6S113C73v43Ev();
extern void _ZN6S113C73v44Ev();
extern void _ZN6S113C73v45Ev();
extern void _ZN6S113C73v46Ev();
extern void _ZN6S113C73v47Ev();
extern void _ZN6S113C73v48Ev();
extern void _ZN6S113C73v49Ev();
extern void _ZN6S113C73v50Ev();
extern void _ZN6S113C73v51Ev();
extern void _ZN6S113C73v52Ev();
extern void _ZN6S113C73v53Ev();
extern void _ZN6S113C73v54Ev();
extern void _ZN6S113C73v55Ev();
extern void _ZN6S113C73v56Ev();
extern void _ZN6S113C73v57Ev();
extern void _ZN6S113C73v58Ev();
extern void _ZN6S113C73v59Ev();
extern void _ZN6S113C73v60Ev();
extern void _ZN6S113C73v61Ev();
extern void _ZN6S113C73v62Ev();
extern void _ZN6S113C73v63Ev();
extern void _ZN6S113C73v64Ev();
extern void _ZN6S113C73v65Ev();
extern void _ZN6S113C73v66Ev();
extern void _ZN6S113C73v67Ev();
extern void _ZN6S113C73v68Ev();
extern void _ZN6S113C73v69Ev();
extern void _ZN6S113C73v70Ev();
extern void _ZN6S113C63v71Ev();
extern void _ZN6S113C63v72Ev();
extern void _ZN6S113C63v73Ev();
extern void _ZN6S113C63v74Ev();
extern void _ZN6S113C63v75Ev();
extern void _ZN6S113C63v76Ev();
extern void _ZN6S113C63v77Ev();
extern void _ZN6S113C63v78Ev();
extern void _ZN6S113C63v79Ev();
extern void _ZN6S113C63v80Ev();
extern void _ZN6S113C63v81Ev();
extern void _ZN6S113C63v82Ev();
extern void _ZN6S113C63v83Ev();
extern void _ZN6S113C63v84Ev();
extern void _ZN6S113C63v85Ev();
extern void _ZN6S113C63v86Ev();
extern void _ZN6S113C63v87Ev();
extern void _ZN6S113C63v88Ev();
extern void _ZN6S113C63v89Ev();
extern void _ZN6S113C63v90Ev();
extern void _ZN6S113C63v91Ev();
extern void _ZN6S113C63v92Ev();
extern void _ZN6S113C53v93Ev();
extern void _ZN6S113C53v94Ev();
extern void _ZN6S113C53v95Ev();
extern void _ZN6S113C53v96Ev();
extern void _ZN6S113C53v97Ev();
extern void _ZN6S113C53v98Ev();
extern void _ZN6S113C53v99Ev();
extern void _ZN6S113C54v100Ev();
extern void _ZN6S113C54v101Ev();
extern void _ZN6S113C54v102Ev();
extern void _ZN6S113C54v103Ev();
extern void _ZN6S113C54v104Ev();
extern void _ZN6S113C54v105Ev();
extern void _ZN6S113C54v106Ev();
extern void _ZN6S113C54v107Ev();
extern void _ZN6S113C54v108Ev();
extern void _ZN6S113C54v109Ev();
extern void _ZN6S113C54v110Ev();
extern void _ZN6S113C54v111Ev();
extern void _ZN6S113C54v112Ev();
static  VTBL_ENTRY vtc_S113C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S113C5[0]),
  (VTBL_ENTRY)&_ZN6S113C5D1Ev,
  (VTBL_ENTRY)&_ZN6S113C5D0Ev,
  (VTBL_ENTRY)&_ZN6S113C72v7Ev,
  (VTBL_ENTRY)&_ZN6S113C72v8Ev,
  (VTBL_ENTRY)&_ZN6S113C72v9Ev,
  (VTBL_ENTRY)&_ZN6S113C73v10Ev,
  (VTBL_ENTRY)&_ZN6S113C73v11Ev,
  (VTBL_ENTRY)&_ZN6S113C73v12Ev,
  (VTBL_ENTRY)&_ZN6S113C73v13Ev,
  (VTBL_ENTRY)&_ZN6S113C73v14Ev,
  (VTBL_ENTRY)&_ZN6S113C73v15Ev,
  (VTBL_ENTRY)&_ZN6S113C73v16Ev,
  (VTBL_ENTRY)&_ZN6S113C73v17Ev,
  (VTBL_ENTRY)&_ZN6S113C73v18Ev,
  (VTBL_ENTRY)&_ZN6S113C73v19Ev,
  (VTBL_ENTRY)&_ZN6S113C73v20Ev,
  (VTBL_ENTRY)&_ZN6S113C73v21Ev,
  (VTBL_ENTRY)&_ZN6S113C73v22Ev,
  (VTBL_ENTRY)&_ZN6S113C73v23Ev,
  (VTBL_ENTRY)&_ZN6S113C73v24Ev,
  (VTBL_ENTRY)&_ZN6S113C73v25Ev,
  (VTBL_ENTRY)&_ZN6S113C73v26Ev,
  (VTBL_ENTRY)&_ZN6S113C73v27Ev,
  (VTBL_ENTRY)&_ZN6S113C73v28Ev,
  (VTBL_ENTRY)&_ZN6S113C73v29Ev,
  (VTBL_ENTRY)&_ZN6S113C73v30Ev,
  (VTBL_ENTRY)&_ZN6S113C73v31Ev,
  (VTBL_ENTRY)&_ZN6S113C73v32Ev,
  (VTBL_ENTRY)&_ZN6S113C73v33Ev,
  (VTBL_ENTRY)&_ZN6S113C73v34Ev,
  (VTBL_ENTRY)&_ZN6S113C73v35Ev,
  (VTBL_ENTRY)&_ZN6S113C73v36Ev,
  (VTBL_ENTRY)&_ZN6S113C73v37Ev,
  (VTBL_ENTRY)&_ZN6S113C73v38Ev,
  (VTBL_ENTRY)&_ZN6S113C73v39Ev,
  (VTBL_ENTRY)&_ZN6S113C73v40Ev,
  (VTBL_ENTRY)&_ZN6S113C73v41Ev,
  (VTBL_ENTRY)&_ZN6S113C73v42Ev,
  (VTBL_ENTRY)&_ZN6S113C73v43Ev,
  (VTBL_ENTRY)&_ZN6S113C73v44Ev,
  (VTBL_ENTRY)&_ZN6S113C73v45Ev,
  (VTBL_ENTRY)&_ZN6S113C73v46Ev,
  (VTBL_ENTRY)&_ZN6S113C73v47Ev,
  (VTBL_ENTRY)&_ZN6S113C73v48Ev,
  (VTBL_ENTRY)&_ZN6S113C73v49Ev,
  (VTBL_ENTRY)&_ZN6S113C73v50Ev,
  (VTBL_ENTRY)&_ZN6S113C73v51Ev,
  (VTBL_ENTRY)&_ZN6S113C73v52Ev,
  (VTBL_ENTRY)&_ZN6S113C73v53Ev,
  (VTBL_ENTRY)&_ZN6S113C73v54Ev,
  (VTBL_ENTRY)&_ZN6S113C73v55Ev,
  (VTBL_ENTRY)&_ZN6S113C73v56Ev,
  (VTBL_ENTRY)&_ZN6S113C73v57Ev,
  (VTBL_ENTRY)&_ZN6S113C73v58Ev,
  (VTBL_ENTRY)&_ZN6S113C73v59Ev,
  (VTBL_ENTRY)&_ZN6S113C73v60Ev,
  (VTBL_ENTRY)&_ZN6S113C73v61Ev,
  (VTBL_ENTRY)&_ZN6S113C73v62Ev,
  (VTBL_ENTRY)&_ZN6S113C73v63Ev,
  (VTBL_ENTRY)&_ZN6S113C73v64Ev,
  (VTBL_ENTRY)&_ZN6S113C73v65Ev,
  (VTBL_ENTRY)&_ZN6S113C73v66Ev,
  (VTBL_ENTRY)&_ZN6S113C73v67Ev,
  (VTBL_ENTRY)&_ZN6S113C73v68Ev,
  (VTBL_ENTRY)&_ZN6S113C73v69Ev,
  (VTBL_ENTRY)&_ZN6S113C73v70Ev,
  (VTBL_ENTRY)&_ZN6S113C63v71Ev,
  (VTBL_ENTRY)&_ZN6S113C63v72Ev,
  (VTBL_ENTRY)&_ZN6S113C63v73Ev,
  (VTBL_ENTRY)&_ZN6S113C63v74Ev,
  (VTBL_ENTRY)&_ZN6S113C63v75Ev,
  (VTBL_ENTRY)&_ZN6S113C63v76Ev,
  (VTBL_ENTRY)&_ZN6S113C63v77Ev,
  (VTBL_ENTRY)&_ZN6S113C63v78Ev,
  (VTBL_ENTRY)&_ZN6S113C63v79Ev,
  (VTBL_ENTRY)&_ZN6S113C63v80Ev,
  (VTBL_ENTRY)&_ZN6S113C63v81Ev,
  (VTBL_ENTRY)&_ZN6S113C63v82Ev,
  (VTBL_ENTRY)&_ZN6S113C63v83Ev,
  (VTBL_ENTRY)&_ZN6S113C63v84Ev,
  (VTBL_ENTRY)&_ZN6S113C63v85Ev,
  (VTBL_ENTRY)&_ZN6S113C63v86Ev,
  (VTBL_ENTRY)&_ZN6S113C63v87Ev,
  (VTBL_ENTRY)&_ZN6S113C63v88Ev,
  (VTBL_ENTRY)&_ZN6S113C63v89Ev,
  (VTBL_ENTRY)&_ZN6S113C63v90Ev,
  (VTBL_ENTRY)&_ZN6S113C63v91Ev,
  (VTBL_ENTRY)&_ZN6S113C63v92Ev,
  (VTBL_ENTRY)&_ZN6S113C53v93Ev,
  (VTBL_ENTRY)&_ZN6S113C53v94Ev,
  (VTBL_ENTRY)&_ZN6S113C53v95Ev,
  (VTBL_ENTRY)&_ZN6S113C53v96Ev,
  (VTBL_ENTRY)&_ZN6S113C53v97Ev,
  (VTBL_ENTRY)&_ZN6S113C53v98Ev,
  (VTBL_ENTRY)&_ZN6S113C53v99Ev,
  (VTBL_ENTRY)&_ZN6S113C54v100Ev,
  (VTBL_ENTRY)&_ZN6S113C54v101Ev,
  (VTBL_ENTRY)&_ZN6S113C54v102Ev,
  (VTBL_ENTRY)&_ZN6S113C54v103Ev,
  (VTBL_ENTRY)&_ZN6S113C54v104Ev,
  (VTBL_ENTRY)&_ZN6S113C54v105Ev,
  (VTBL_ENTRY)&_ZN6S113C54v106Ev,
  (VTBL_ENTRY)&_ZN6S113C54v107Ev,
  (VTBL_ENTRY)&_ZN6S113C54v108Ev,
  (VTBL_ENTRY)&_ZN6S113C54v109Ev,
  (VTBL_ENTRY)&_ZN6S113C54v110Ev,
  (VTBL_ENTRY)&_ZN6S113C54v111Ev,
  (VTBL_ENTRY)&_ZN6S113C54v112Ev,
};
extern VTBL_ENTRY _ZTI6S113C5[];
extern  VTBL_ENTRY _ZTV6S113C5[];
Class_Descriptor cd_S113C5 = {  "S113C5", // class name
  bases_S113C5, 2,
  &(vtc_S113C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI6S113C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S113C5),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S113C4  : S113C5 {
  ::S3350C4_nt s113c4f0;
  unsigned int s113c4f1:1;
  ::S287C23 s113c4f2;
  virtual  ~S113C4(); // _ZN6S113C4D1Ev
  virtual void  v113(); // _ZN6S113C44v113Ev
  virtual void  v114(); // _ZN6S113C44v114Ev
  virtual void  v115(); // _ZN6S113C44v115Ev
  virtual void  v116(); // _ZN6S113C44v116Ev
  S113C4(); // tgen
};
//SIG(-1 S113C4) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} FC17{ BC18{ BC9}} Fi[3]} vd v1 v2 v3 v4 FC5 Fi:1 FC19{ BC20{ BC9}}}


 S113C4 ::~S113C4(){ note_dtor("S113C4", this);}
void  S113C4 ::v113(){vfunc_called(this, "_ZN6S113C44v113Ev");}
void  S113C4 ::v114(){vfunc_called(this, "_ZN6S113C44v114Ev");}
void  S113C4 ::v115(){vfunc_called(this, "_ZN6S113C44v115Ev");}
void  S113C4 ::v116(){vfunc_called(this, "_ZN6S113C44v116Ev");}
S113C4 ::S113C4(){ note_ctor("S113C4", this);} // tgen

static void Test_S113C4()
{
  extern Class_Descriptor cd_S113C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(38,56)];
    init_test(&cd_S113C4, buf);
    S113C4 *dp, &lv = *(dp=new (buf) S113C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(296,220), "sizeof(S113C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S113C4)");
    check_base_class_offset(lv, (S113C7*)(S113C6*)(S113C5*), 0, "S113C4");
    check_base_class_offset(lv, (S113C6*)(S113C5*), 0, "S113C4");
    check_base_class_offset(lv, (S113C5*), 0, "S113C4");
    check_field_offset(lv, s113c4f0, ABISELECT(268,196), "S113C4.s113c4f0");
    set_bf_and_test(lv, s113c4f1, ABISELECT(276,204), 0, 1, 1, "S113C4");
    check_field_offset(lv, s113c4f2, ABISELECT(280,208), "S113C4.s113c4f2");
    test_class_info(&lv, &cd_S113C4);
    dp->~S113C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS113C4(Test_S113C4, "S113C4", ABISELECT(296,220));

#else // __cplusplus

extern void _ZN6S113C4C1Ev();
extern void _ZN6S113C4D1Ev();
Name_Map name_map_S113C4[] = {
  NSPAIR(_ZN6S113C4C1Ev),
  NSPAIR(_ZN6S113C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S113C7;
extern VTBL_ENTRY _ZTI6S113C7[];
extern  VTBL_ENTRY _ZTV6S113C7[];
extern Class_Descriptor cd_S113C6;
extern VTBL_ENTRY _ZTI6S113C6[];
extern  VTBL_ENTRY _ZTV6S113C6[];
extern Class_Descriptor cd_S113C5;
extern VTBL_ENTRY _ZTI6S113C5[];
extern  VTBL_ENTRY _ZTV6S113C5[];
static Base_Class bases_S113C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S113C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S113C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S113C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S113C4[];
extern void _ZN6S113C4D1Ev();
extern void _ZN6S113C4D0Ev();
extern void _ZN6S113C72v7Ev();
extern void _ZN6S113C72v8Ev();
extern void _ZN6S113C72v9Ev();
extern void _ZN6S113C73v10Ev();
extern void _ZN6S113C73v11Ev();
extern void _ZN6S113C73v12Ev();
extern void _ZN6S113C73v13Ev();
extern void _ZN6S113C73v14Ev();
extern void _ZN6S113C73v15Ev();
extern void _ZN6S113C73v16Ev();
extern void _ZN6S113C73v17Ev();
extern void _ZN6S113C73v18Ev();
extern void _ZN6S113C73v19Ev();
extern void _ZN6S113C73v20Ev();
extern void _ZN6S113C73v21Ev();
extern void _ZN6S113C73v22Ev();
extern void _ZN6S113C73v23Ev();
extern void _ZN6S113C73v24Ev();
extern void _ZN6S113C73v25Ev();
extern void _ZN6S113C73v26Ev();
extern void _ZN6S113C73v27Ev();
extern void _ZN6S113C73v28Ev();
extern void _ZN6S113C73v29Ev();
extern void _ZN6S113C73v30Ev();
extern void _ZN6S113C73v31Ev();
extern void _ZN6S113C73v32Ev();
extern void _ZN6S113C73v33Ev();
extern void _ZN6S113C73v34Ev();
extern void _ZN6S113C73v35Ev();
extern void _ZN6S113C73v36Ev();
extern void _ZN6S113C73v37Ev();
extern void _ZN6S113C73v38Ev();
extern void _ZN6S113C73v39Ev();
extern void _ZN6S113C73v40Ev();
extern void _ZN6S113C73v41Ev();
extern void _ZN6S113C73v42Ev();
extern void _ZN6S113C73v43Ev();
extern void _ZN6S113C73v44Ev();
extern void _ZN6S113C73v45Ev();
extern void _ZN6S113C73v46Ev();
extern void _ZN6S113C73v47Ev();
extern void _ZN6S113C73v48Ev();
extern void _ZN6S113C73v49Ev();
extern void _ZN6S113C73v50Ev();
extern void _ZN6S113C73v51Ev();
extern void _ZN6S113C73v52Ev();
extern void _ZN6S113C73v53Ev();
extern void _ZN6S113C73v54Ev();
extern void _ZN6S113C73v55Ev();
extern void _ZN6S113C73v56Ev();
extern void _ZN6S113C73v57Ev();
extern void _ZN6S113C73v58Ev();
extern void _ZN6S113C73v59Ev();
extern void _ZN6S113C73v60Ev();
extern void _ZN6S113C73v61Ev();
extern void _ZN6S113C73v62Ev();
extern void _ZN6S113C73v63Ev();
extern void _ZN6S113C73v64Ev();
extern void _ZN6S113C73v65Ev();
extern void _ZN6S113C73v66Ev();
extern void _ZN6S113C73v67Ev();
extern void _ZN6S113C73v68Ev();
extern void _ZN6S113C73v69Ev();
extern void _ZN6S113C73v70Ev();
extern void _ZN6S113C63v71Ev();
extern void _ZN6S113C63v72Ev();
extern void _ZN6S113C63v73Ev();
extern void _ZN6S113C63v74Ev();
extern void _ZN6S113C63v75Ev();
extern void _ZN6S113C63v76Ev();
extern void _ZN6S113C63v77Ev();
extern void _ZN6S113C63v78Ev();
extern void _ZN6S113C63v79Ev();
extern void _ZN6S113C63v80Ev();
extern void _ZN6S113C63v81Ev();
extern void _ZN6S113C63v82Ev();
extern void _ZN6S113C63v83Ev();
extern void _ZN6S113C63v84Ev();
extern void _ZN6S113C63v85Ev();
extern void _ZN6S113C63v86Ev();
extern void _ZN6S113C63v87Ev();
extern void _ZN6S113C63v88Ev();
extern void _ZN6S113C63v89Ev();
extern void _ZN6S113C63v90Ev();
extern void _ZN6S113C63v91Ev();
extern void _ZN6S113C63v92Ev();
extern void _ZN6S113C53v93Ev();
extern void _ZN6S113C53v94Ev();
extern void _ZN6S113C53v95Ev();
extern void _ZN6S113C53v96Ev();
extern void _ZN6S113C53v97Ev();
extern void _ZN6S113C53v98Ev();
extern void _ZN6S113C53v99Ev();
extern void _ZN6S113C54v100Ev();
extern void _ZN6S113C54v101Ev();
extern void _ZN6S113C54v102Ev();
extern void _ZN6S113C54v103Ev();
extern void _ZN6S113C54v104Ev();
extern void _ZN6S113C54v105Ev();
extern void _ZN6S113C54v106Ev();
extern void _ZN6S113C54v107Ev();
extern void _ZN6S113C54v108Ev();
extern void _ZN6S113C54v109Ev();
extern void _ZN6S113C54v110Ev();
extern void _ZN6S113C54v111Ev();
extern void _ZN6S113C54v112Ev();
extern void _ZN6S113C44v113Ev();
extern void _ZN6S113C44v114Ev();
extern void _ZN6S113C44v115Ev();
extern void _ZN6S113C44v116Ev();
static  VTBL_ENTRY vtc_S113C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S113C4[0]),
  (VTBL_ENTRY)&_ZN6S113C4D1Ev,
  (VTBL_ENTRY)&_ZN6S113C4D0Ev,
  (VTBL_ENTRY)&_ZN6S113C72v7Ev,
  (VTBL_ENTRY)&_ZN6S113C72v8Ev,
  (VTBL_ENTRY)&_ZN6S113C72v9Ev,
  (VTBL_ENTRY)&_ZN6S113C73v10Ev,
  (VTBL_ENTRY)&_ZN6S113C73v11Ev,
  (VTBL_ENTRY)&_ZN6S113C73v12Ev,
  (VTBL_ENTRY)&_ZN6S113C73v13Ev,
  (VTBL_ENTRY)&_ZN6S113C73v14Ev,
  (VTBL_ENTRY)&_ZN6S113C73v15Ev,
  (VTBL_ENTRY)&_ZN6S113C73v16Ev,
  (VTBL_ENTRY)&_ZN6S113C73v17Ev,
  (VTBL_ENTRY)&_ZN6S113C73v18Ev,
  (VTBL_ENTRY)&_ZN6S113C73v19Ev,
  (VTBL_ENTRY)&_ZN6S113C73v20Ev,
  (VTBL_ENTRY)&_ZN6S113C73v21Ev,
  (VTBL_ENTRY)&_ZN6S113C73v22Ev,
  (VTBL_ENTRY)&_ZN6S113C73v23Ev,
  (VTBL_ENTRY)&_ZN6S113C73v24Ev,
  (VTBL_ENTRY)&_ZN6S113C73v25Ev,
  (VTBL_ENTRY)&_ZN6S113C73v26Ev,
  (VTBL_ENTRY)&_ZN6S113C73v27Ev,
  (VTBL_ENTRY)&_ZN6S113C73v28Ev,
  (VTBL_ENTRY)&_ZN6S113C73v29Ev,
  (VTBL_ENTRY)&_ZN6S113C73v30Ev,
  (VTBL_ENTRY)&_ZN6S113C73v31Ev,
  (VTBL_ENTRY)&_ZN6S113C73v32Ev,
  (VTBL_ENTRY)&_ZN6S113C73v33Ev,
  (VTBL_ENTRY)&_ZN6S113C73v34Ev,
  (VTBL_ENTRY)&_ZN6S113C73v35Ev,
  (VTBL_ENTRY)&_ZN6S113C73v36Ev,
  (VTBL_ENTRY)&_ZN6S113C73v37Ev,
  (VTBL_ENTRY)&_ZN6S113C73v38Ev,
  (VTBL_ENTRY)&_ZN6S113C73v39Ev,
  (VTBL_ENTRY)&_ZN6S113C73v40Ev,
  (VTBL_ENTRY)&_ZN6S113C73v41Ev,
  (VTBL_ENTRY)&_ZN6S113C73v42Ev,
  (VTBL_ENTRY)&_ZN6S113C73v43Ev,
  (VTBL_ENTRY)&_ZN6S113C73v44Ev,
  (VTBL_ENTRY)&_ZN6S113C73v45Ev,
  (VTBL_ENTRY)&_ZN6S113C73v46Ev,
  (VTBL_ENTRY)&_ZN6S113C73v47Ev,
  (VTBL_ENTRY)&_ZN6S113C73v48Ev,
  (VTBL_ENTRY)&_ZN6S113C73v49Ev,
  (VTBL_ENTRY)&_ZN6S113C73v50Ev,
  (VTBL_ENTRY)&_ZN6S113C73v51Ev,
  (VTBL_ENTRY)&_ZN6S113C73v52Ev,
  (VTBL_ENTRY)&_ZN6S113C73v53Ev,
  (VTBL_ENTRY)&_ZN6S113C73v54Ev,
  (VTBL_ENTRY)&_ZN6S113C73v55Ev,
  (VTBL_ENTRY)&_ZN6S113C73v56Ev,
  (VTBL_ENTRY)&_ZN6S113C73v57Ev,
  (VTBL_ENTRY)&_ZN6S113C73v58Ev,
  (VTBL_ENTRY)&_ZN6S113C73v59Ev,
  (VTBL_ENTRY)&_ZN6S113C73v60Ev,
  (VTBL_ENTRY)&_ZN6S113C73v61Ev,
  (VTBL_ENTRY)&_ZN6S113C73v62Ev,
  (VTBL_ENTRY)&_ZN6S113C73v63Ev,
  (VTBL_ENTRY)&_ZN6S113C73v64Ev,
  (VTBL_ENTRY)&_ZN6S113C73v65Ev,
  (VTBL_ENTRY)&_ZN6S113C73v66Ev,
  (VTBL_ENTRY)&_ZN6S113C73v67Ev,
  (VTBL_ENTRY)&_ZN6S113C73v68Ev,
  (VTBL_ENTRY)&_ZN6S113C73v69Ev,
  (VTBL_ENTRY)&_ZN6S113C73v70Ev,
  (VTBL_ENTRY)&_ZN6S113C63v71Ev,
  (VTBL_ENTRY)&_ZN6S113C63v72Ev,
  (VTBL_ENTRY)&_ZN6S113C63v73Ev,
  (VTBL_ENTRY)&_ZN6S113C63v74Ev,
  (VTBL_ENTRY)&_ZN6S113C63v75Ev,
  (VTBL_ENTRY)&_ZN6S113C63v76Ev,
  (VTBL_ENTRY)&_ZN6S113C63v77Ev,
  (VTBL_ENTRY)&_ZN6S113C63v78Ev,
  (VTBL_ENTRY)&_ZN6S113C63v79Ev,
  (VTBL_ENTRY)&_ZN6S113C63v80Ev,
  (VTBL_ENTRY)&_ZN6S113C63v81Ev,
  (VTBL_ENTRY)&_ZN6S113C63v82Ev,
  (VTBL_ENTRY)&_ZN6S113C63v83Ev,
  (VTBL_ENTRY)&_ZN6S113C63v84Ev,
  (VTBL_ENTRY)&_ZN6S113C63v85Ev,
  (VTBL_ENTRY)&_ZN6S113C63v86Ev,
  (VTBL_ENTRY)&_ZN6S113C63v87Ev,
  (VTBL_ENTRY)&_ZN6S113C63v88Ev,
  (VTBL_ENTRY)&_ZN6S113C63v89Ev,
  (VTBL_ENTRY)&_ZN6S113C63v90Ev,
  (VTBL_ENTRY)&_ZN6S113C63v91Ev,
  (VTBL_ENTRY)&_ZN6S113C63v92Ev,
  (VTBL_ENTRY)&_ZN6S113C53v93Ev,
  (VTBL_ENTRY)&_ZN6S113C53v94Ev,
  (VTBL_ENTRY)&_ZN6S113C53v95Ev,
  (VTBL_ENTRY)&_ZN6S113C53v96Ev,
  (VTBL_ENTRY)&_ZN6S113C53v97Ev,
  (VTBL_ENTRY)&_ZN6S113C53v98Ev,
  (VTBL_ENTRY)&_ZN6S113C53v99Ev,
  (VTBL_ENTRY)&_ZN6S113C54v100Ev,
  (VTBL_ENTRY)&_ZN6S113C54v101Ev,
  (VTBL_ENTRY)&_ZN6S113C54v102Ev,
  (VTBL_ENTRY)&_ZN6S113C54v103Ev,
  (VTBL_ENTRY)&_ZN6S113C54v104Ev,
  (VTBL_ENTRY)&_ZN6S113C54v105Ev,
  (VTBL_ENTRY)&_ZN6S113C54v106Ev,
  (VTBL_ENTRY)&_ZN6S113C54v107Ev,
  (VTBL_ENTRY)&_ZN6S113C54v108Ev,
  (VTBL_ENTRY)&_ZN6S113C54v109Ev,
  (VTBL_ENTRY)&_ZN6S113C54v110Ev,
  (VTBL_ENTRY)&_ZN6S113C54v111Ev,
  (VTBL_ENTRY)&_ZN6S113C54v112Ev,
  (VTBL_ENTRY)&_ZN6S113C44v113Ev,
  (VTBL_ENTRY)&_ZN6S113C44v114Ev,
  (VTBL_ENTRY)&_ZN6S113C44v115Ev,
  (VTBL_ENTRY)&_ZN6S113C44v116Ev,
};
extern VTBL_ENTRY _ZTI6S113C4[];
extern  VTBL_ENTRY _ZTV6S113C4[];
Class_Descriptor cd_S113C4 = {  "S113C4", // class name
  bases_S113C4, 3,
  &(vtc_S113C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,220), // object size
  NSPAIRA(_ZTI6S113C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S113C4),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S113C3  : S113C4 {
  ::S287C19 s113c3f0;
  unsigned int s113c3f1:1;
  virtual  ~S113C3(); // _ZN6S113C3D1Ev
  virtual void  v117(); // _ZN6S113C34v117Ev
  virtual void  v118(); // _ZN6S113C34v118Ev
  virtual void  v119(); // _ZN6S113C34v119Ev
  virtual void  v120(); // _ZN6S113C34v120Ev
  virtual void  v121(); // _ZN6S113C34v121Ev
  virtual void  v122(); // _ZN6S113C34v122Ev
  virtual void  v123(); // _ZN6S113C34v123Ev
  S113C3(); // tgen
};
//SIG(-1 S113C3) C1{ BC2{ BC3{ BC4{ BC5{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} FC18{ BC19{ BC10}} Fi[3]} vd v114 v115 v116 v117 FC6 Fi:1 FC20{ BC21{ BC10}}} vd v1 v2 v3 v4 v5 v6 v7 FC22{ BC23{ BC10}} Fi:1}


 S113C3 ::~S113C3(){ note_dtor("S113C3", this);}
void  S113C3 ::v117(){vfunc_called(this, "_ZN6S113C34v117Ev");}
void  S113C3 ::v118(){vfunc_called(this, "_ZN6S113C34v118Ev");}
void  S113C3 ::v119(){vfunc_called(this, "_ZN6S113C34v119Ev");}
void  S113C3 ::v120(){vfunc_called(this, "_ZN6S113C34v120Ev");}
void  S113C3 ::v121(){vfunc_called(this, "_ZN6S113C34v121Ev");}
void  S113C3 ::v122(){vfunc_called(this, "_ZN6S113C34v122Ev");}
void  S113C3 ::v123(){vfunc_called(this, "_ZN6S113C34v123Ev");}
S113C3 ::S113C3(){ note_ctor("S113C3", this);} // tgen

static void Test_S113C3()
{
  extern Class_Descriptor cd_S113C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(41,60)];
    init_test(&cd_S113C3, buf);
    S113C3 *dp, &lv = *(dp=new (buf) S113C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(320,236), "sizeof(S113C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S113C3)");
    check_base_class_offset(lv, (S113C7*)(S113C6*)(S113C5*)(S113C4*), 0, "S113C3");
    check_base_class_offset(lv, (S113C6*)(S113C5*)(S113C4*), 0, "S113C3");
    check_base_class_offset(lv, (S113C5*)(S113C4*), 0, "S113C3");
    check_base_class_offset(lv, (S113C4*), 0, "S113C3");
    check_field_offset(lv, s113c3f0, ABISELECT(296,220), "S113C3.s113c3f0");
    set_bf_and_test(lv, s113c3f1, ABISELECT(312,232), 0, 1, 1, "S113C3");
    test_class_info(&lv, &cd_S113C3);
    dp->~S113C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS113C3(Test_S113C3, "S113C3", ABISELECT(320,236));

#else // __cplusplus

extern void _ZN6S113C3C1Ev();
extern void _ZN6S113C3D1Ev();
Name_Map name_map_S113C3[] = {
  NSPAIR(_ZN6S113C3C1Ev),
  NSPAIR(_ZN6S113C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S113C7;
extern VTBL_ENTRY _ZTI6S113C7[];
extern  VTBL_ENTRY _ZTV6S113C7[];
extern Class_Descriptor cd_S113C6;
extern VTBL_ENTRY _ZTI6S113C6[];
extern  VTBL_ENTRY _ZTV6S113C6[];
extern Class_Descriptor cd_S113C5;
extern VTBL_ENTRY _ZTI6S113C5[];
extern  VTBL_ENTRY _ZTV6S113C5[];
extern Class_Descriptor cd_S113C4;
extern VTBL_ENTRY _ZTI6S113C4[];
extern  VTBL_ENTRY _ZTV6S113C4[];
static Base_Class bases_S113C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S113C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S113C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S113C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S113C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S113C3[];
extern void _ZN6S113C3D1Ev();
extern void _ZN6S113C3D0Ev();
extern void _ZN6S113C72v7Ev();
extern void _ZN6S113C72v8Ev();
extern void _ZN6S113C72v9Ev();
extern void _ZN6S113C73v10Ev();
extern void _ZN6S113C73v11Ev();
extern void _ZN6S113C73v12Ev();
extern void _ZN6S113C73v13Ev();
extern void _ZN6S113C73v14Ev();
extern void _ZN6S113C73v15Ev();
extern void _ZN6S113C73v16Ev();
extern void _ZN6S113C73v17Ev();
extern void _ZN6S113C73v18Ev();
extern void _ZN6S113C73v19Ev();
extern void _ZN6S113C73v20Ev();
extern void _ZN6S113C73v21Ev();
extern void _ZN6S113C73v22Ev();
extern void _ZN6S113C73v23Ev();
extern void _ZN6S113C73v24Ev();
extern void _ZN6S113C73v25Ev();
extern void _ZN6S113C73v26Ev();
extern void _ZN6S113C73v27Ev();
extern void _ZN6S113C73v28Ev();
extern void _ZN6S113C73v29Ev();
extern void _ZN6S113C73v30Ev();
extern void _ZN6S113C73v31Ev();
extern void _ZN6S113C73v32Ev();
extern void _ZN6S113C73v33Ev();
extern void _ZN6S113C73v34Ev();
extern void _ZN6S113C73v35Ev();
extern void _ZN6S113C73v36Ev();
extern void _ZN6S113C73v37Ev();
extern void _ZN6S113C73v38Ev();
extern void _ZN6S113C73v39Ev();
extern void _ZN6S113C73v40Ev();
extern void _ZN6S113C73v41Ev();
extern void _ZN6S113C73v42Ev();
extern void _ZN6S113C73v43Ev();
extern void _ZN6S113C73v44Ev();
extern void _ZN6S113C73v45Ev();
extern void _ZN6S113C73v46Ev();
extern void _ZN6S113C73v47Ev();
extern void _ZN6S113C73v48Ev();
extern void _ZN6S113C73v49Ev();
extern void _ZN6S113C73v50Ev();
extern void _ZN6S113C73v51Ev();
extern void _ZN6S113C73v52Ev();
extern void _ZN6S113C73v53Ev();
extern void _ZN6S113C73v54Ev();
extern void _ZN6S113C73v55Ev();
extern void _ZN6S113C73v56Ev();
extern void _ZN6S113C73v57Ev();
extern void _ZN6S113C73v58Ev();
extern void _ZN6S113C73v59Ev();
extern void _ZN6S113C73v60Ev();
extern void _ZN6S113C73v61Ev();
extern void _ZN6S113C73v62Ev();
extern void _ZN6S113C73v63Ev();
extern void _ZN6S113C73v64Ev();
extern void _ZN6S113C73v65Ev();
extern void _ZN6S113C73v66Ev();
extern void _ZN6S113C73v67Ev();
extern void _ZN6S113C73v68Ev();
extern void _ZN6S113C73v69Ev();
extern void _ZN6S113C73v70Ev();
extern void _ZN6S113C63v71Ev();
extern void _ZN6S113C63v72Ev();
extern void _ZN6S113C63v73Ev();
extern void _ZN6S113C63v74Ev();
extern void _ZN6S113C63v75Ev();
extern void _ZN6S113C63v76Ev();
extern void _ZN6S113C63v77Ev();
extern void _ZN6S113C63v78Ev();
extern void _ZN6S113C63v79Ev();
extern void _ZN6S113C63v80Ev();
extern void _ZN6S113C63v81Ev();
extern void _ZN6S113C63v82Ev();
extern void _ZN6S113C63v83Ev();
extern void _ZN6S113C63v84Ev();
extern void _ZN6S113C63v85Ev();
extern void _ZN6S113C63v86Ev();
extern void _ZN6S113C63v87Ev();
extern void _ZN6S113C63v88Ev();
extern void _ZN6S113C63v89Ev();
extern void _ZN6S113C63v90Ev();
extern void _ZN6S113C63v91Ev();
extern void _ZN6S113C63v92Ev();
extern void _ZN6S113C53v93Ev();
extern void _ZN6S113C53v94Ev();
extern void _ZN6S113C53v95Ev();
extern void _ZN6S113C53v96Ev();
extern void _ZN6S113C53v97Ev();
extern void _ZN6S113C53v98Ev();
extern void _ZN6S113C53v99Ev();
extern void _ZN6S113C54v100Ev();
extern void _ZN6S113C54v101Ev();
extern void _ZN6S113C54v102Ev();
extern void _ZN6S113C54v103Ev();
extern void _ZN6S113C54v104Ev();
extern void _ZN6S113C54v105Ev();
extern void _ZN6S113C54v106Ev();
extern void _ZN6S113C54v107Ev();
extern void _ZN6S113C54v108Ev();
extern void _ZN6S113C54v109Ev();
extern void _ZN6S113C54v110Ev();
extern void _ZN6S113C54v111Ev();
extern void _ZN6S113C54v112Ev();
extern void _ZN6S113C44v113Ev();
extern void _ZN6S113C44v114Ev();
extern void _ZN6S113C44v115Ev();
extern void _ZN6S113C44v116Ev();
extern void _ZN6S113C34v117Ev();
extern void _ZN6S113C34v118Ev();
extern void _ZN6S113C34v119Ev();
extern void _ZN6S113C34v120Ev();
extern void _ZN6S113C34v121Ev();
extern void _ZN6S113C34v122Ev();
extern void _ZN6S113C34v123Ev();
static  VTBL_ENTRY vtc_S113C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S113C3[0]),
  (VTBL_ENTRY)&_ZN6S113C3D1Ev,
  (VTBL_ENTRY)&_ZN6S113C3D0Ev,
  (VTBL_ENTRY)&_ZN6S113C72v7Ev,
  (VTBL_ENTRY)&_ZN6S113C72v8Ev,
  (VTBL_ENTRY)&_ZN6S113C72v9Ev,
  (VTBL_ENTRY)&_ZN6S113C73v10Ev,
  (VTBL_ENTRY)&_ZN6S113C73v11Ev,
  (VTBL_ENTRY)&_ZN6S113C73v12Ev,
  (VTBL_ENTRY)&_ZN6S113C73v13Ev,
  (VTBL_ENTRY)&_ZN6S113C73v14Ev,
  (VTBL_ENTRY)&_ZN6S113C73v15Ev,
  (VTBL_ENTRY)&_ZN6S113C73v16Ev,
  (VTBL_ENTRY)&_ZN6S113C73v17Ev,
  (VTBL_ENTRY)&_ZN6S113C73v18Ev,
  (VTBL_ENTRY)&_ZN6S113C73v19Ev,
  (VTBL_ENTRY)&_ZN6S113C73v20Ev,
  (VTBL_ENTRY)&_ZN6S113C73v21Ev,
  (VTBL_ENTRY)&_ZN6S113C73v22Ev,
  (VTBL_ENTRY)&_ZN6S113C73v23Ev,
  (VTBL_ENTRY)&_ZN6S113C73v24Ev,
  (VTBL_ENTRY)&_ZN6S113C73v25Ev,
  (VTBL_ENTRY)&_ZN6S113C73v26Ev,
  (VTBL_ENTRY)&_ZN6S113C73v27Ev,
  (VTBL_ENTRY)&_ZN6S113C73v28Ev,
  (VTBL_ENTRY)&_ZN6S113C73v29Ev,
  (VTBL_ENTRY)&_ZN6S113C73v30Ev,
  (VTBL_ENTRY)&_ZN6S113C73v31Ev,
  (VTBL_ENTRY)&_ZN6S113C73v32Ev,
  (VTBL_ENTRY)&_ZN6S113C73v33Ev,
  (VTBL_ENTRY)&_ZN6S113C73v34Ev,
  (VTBL_ENTRY)&_ZN6S113C73v35Ev,
  (VTBL_ENTRY)&_ZN6S113C73v36Ev,
  (VTBL_ENTRY)&_ZN6S113C73v37Ev,
  (VTBL_ENTRY)&_ZN6S113C73v38Ev,
  (VTBL_ENTRY)&_ZN6S113C73v39Ev,
  (VTBL_ENTRY)&_ZN6S113C73v40Ev,
  (VTBL_ENTRY)&_ZN6S113C73v41Ev,
  (VTBL_ENTRY)&_ZN6S113C73v42Ev,
  (VTBL_ENTRY)&_ZN6S113C73v43Ev,
  (VTBL_ENTRY)&_ZN6S113C73v44Ev,
  (VTBL_ENTRY)&_ZN6S113C73v45Ev,
  (VTBL_ENTRY)&_ZN6S113C73v46Ev,
  (VTBL_ENTRY)&_ZN6S113C73v47Ev,
  (VTBL_ENTRY)&_ZN6S113C73v48Ev,
  (VTBL_ENTRY)&_ZN6S113C73v49Ev,
  (VTBL_ENTRY)&_ZN6S113C73v50Ev,
  (VTBL_ENTRY)&_ZN6S113C73v51Ev,
  (VTBL_ENTRY)&_ZN6S113C73v52Ev,
  (VTBL_ENTRY)&_ZN6S113C73v53Ev,
  (VTBL_ENTRY)&_ZN6S113C73v54Ev,
  (VTBL_ENTRY)&_ZN6S113C73v55Ev,
  (VTBL_ENTRY)&_ZN6S113C73v56Ev,
  (VTBL_ENTRY)&_ZN6S113C73v57Ev,
  (VTBL_ENTRY)&_ZN6S113C73v58Ev,
  (VTBL_ENTRY)&_ZN6S113C73v59Ev,
  (VTBL_ENTRY)&_ZN6S113C73v60Ev,
  (VTBL_ENTRY)&_ZN6S113C73v61Ev,
  (VTBL_ENTRY)&_ZN6S113C73v62Ev,
  (VTBL_ENTRY)&_ZN6S113C73v63Ev,
  (VTBL_ENTRY)&_ZN6S113C73v64Ev,
  (VTBL_ENTRY)&_ZN6S113C73v65Ev,
  (VTBL_ENTRY)&_ZN6S113C73v66Ev,
  (VTBL_ENTRY)&_ZN6S113C73v67Ev,
  (VTBL_ENTRY)&_ZN6S113C73v68Ev,
  (VTBL_ENTRY)&_ZN6S113C73v69Ev,
  (VTBL_ENTRY)&_ZN6S113C73v70Ev,
  (VTBL_ENTRY)&_ZN6S113C63v71Ev,
  (VTBL_ENTRY)&_ZN6S113C63v72Ev,
  (VTBL_ENTRY)&_ZN6S113C63v73Ev,
  (VTBL_ENTRY)&_ZN6S113C63v74Ev,
  (VTBL_ENTRY)&_ZN6S113C63v75Ev,
  (VTBL_ENTRY)&_ZN6S113C63v76Ev,
  (VTBL_ENTRY)&_ZN6S113C63v77Ev,
  (VTBL_ENTRY)&_ZN6S113C63v78Ev,
  (VTBL_ENTRY)&_ZN6S113C63v79Ev,
  (VTBL_ENTRY)&_ZN6S113C63v80Ev,
  (VTBL_ENTRY)&_ZN6S113C63v81Ev,
  (VTBL_ENTRY)&_ZN6S113C63v82Ev,
  (VTBL_ENTRY)&_ZN6S113C63v83Ev,
  (VTBL_ENTRY)&_ZN6S113C63v84Ev,
  (VTBL_ENTRY)&_ZN6S113C63v85Ev,
  (VTBL_ENTRY)&_ZN6S113C63v86Ev,
  (VTBL_ENTRY)&_ZN6S113C63v87Ev,
  (VTBL_ENTRY)&_ZN6S113C63v88Ev,
  (VTBL_ENTRY)&_ZN6S113C63v89Ev,
  (VTBL_ENTRY)&_ZN6S113C63v90Ev,
  (VTBL_ENTRY)&_ZN6S113C63v91Ev,
  (VTBL_ENTRY)&_ZN6S113C63v92Ev,
  (VTBL_ENTRY)&_ZN6S113C53v93Ev,
  (VTBL_ENTRY)&_ZN6S113C53v94Ev,
  (VTBL_ENTRY)&_ZN6S113C53v95Ev,
  (VTBL_ENTRY)&_ZN6S113C53v96Ev,
  (VTBL_ENTRY)&_ZN6S113C53v97Ev,
  (VTBL_ENTRY)&_ZN6S113C53v98Ev,
  (VTBL_ENTRY)&_ZN6S113C53v99Ev,
  (VTBL_ENTRY)&_ZN6S113C54v100Ev,
  (VTBL_ENTRY)&_ZN6S113C54v101Ev,
  (VTBL_ENTRY)&_ZN6S113C54v102Ev,
  (VTBL_ENTRY)&_ZN6S113C54v103Ev,
  (VTBL_ENTRY)&_ZN6S113C54v104Ev,
  (VTBL_ENTRY)&_ZN6S113C54v105Ev,
  (VTBL_ENTRY)&_ZN6S113C54v106Ev,
  (VTBL_ENTRY)&_ZN6S113C54v107Ev,
  (VTBL_ENTRY)&_ZN6S113C54v108Ev,
  (VTBL_ENTRY)&_ZN6S113C54v109Ev,
  (VTBL_ENTRY)&_ZN6S113C54v110Ev,
  (VTBL_ENTRY)&_ZN6S113C54v111Ev,
  (VTBL_ENTRY)&_ZN6S113C54v112Ev,
  (VTBL_ENTRY)&_ZN6S113C44v113Ev,
  (VTBL_ENTRY)&_ZN6S113C44v114Ev,
  (VTBL_ENTRY)&_ZN6S113C44v115Ev,
  (VTBL_ENTRY)&_ZN6S113C44v116Ev,
  (VTBL_ENTRY)&_ZN6S113C34v117Ev,
  (VTBL_ENTRY)&_ZN6S113C34v118Ev,
  (VTBL_ENTRY)&_ZN6S113C34v119Ev,
  (VTBL_ENTRY)&_ZN6S113C34v120Ev,
  (VTBL_ENTRY)&_ZN6S113C34v121Ev,
  (VTBL_ENTRY)&_ZN6S113C34v122Ev,
  (VTBL_ENTRY)&_ZN6S113C34v123Ev,
};
extern VTBL_ENTRY _ZTI6S113C3[];
extern  VTBL_ENTRY _ZTV6S113C3[];
Class_Descriptor cd_S113C3 = {  "S113C3", // class name
  bases_S113C3, 4,
  &(vtc_S113C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(320,236), // object size
  NSPAIRA(_ZTI6S113C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S113C3),121, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S113C27_nt  {
  ::S3350C18 s113c27f0;
  void *s113c27f1;
  int s113c27f2;
  void  mf113c27(); // _ZN10S113C27_nt8mf113c27Ev
};
//SIG(-1 S113C27_nt) C1{ m FC2{ BC3{ m Fp Fi[2]}} Fp Fi}


void  S113C27_nt ::mf113c27(){}

//skip512 S113C27_nt

#else // __cplusplus

Class_Descriptor cd_S113C27_nt = {  "S113C27_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S113C26_nt  : S113C27_nt {
};
//SIG(-1 S113C26_nt) C1{ BC2{ m FC3{ BC4{ m Fp Fi[2]}} Fp Fi}}



//skip512 S113C26_nt

#else // __cplusplus

extern Class_Descriptor cd_S113C27_nt;
static Base_Class bases_S113C26_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S113C27_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S113C32  : S3350C7_nt {
};
//SIG(-1 S113C32) C1{ BC2{ m Fp Fi[2]}}



static void Test_S113C32()
{
  extern Class_Descriptor cd_S113C32;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S113C32, buf);
    S113C32 &lv = *(new (buf) S113C32());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S113C32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S113C32)");
    check_base_class_offset(lv, (S3350C7_nt*), 0, "S113C32");
    test_class_info(&lv, &cd_S113C32);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS113C32(Test_S113C32, "S113C32", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3350C7_nt;
static Base_Class bases_S113C32[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3350C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S113C32 = {  "S113C32", // class name
  bases_S113C32, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S113C31  : S113C32 {
};
//SIG(-1 S113C31) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S113C31()
{
  extern Class_Descriptor cd_S113C31;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S113C31, buf);
    S113C31 &lv = *(new (buf) S113C31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S113C31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S113C31)");
    check_base_class_offset(lv, (S3350C7_nt*)(S113C32*), 0, "S113C31");
    check_base_class_offset(lv, (S113C32*), 0, "S113C31");
    test_class_info(&lv, &cd_S113C31);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS113C31(Test_S113C31, "S113C31", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3350C7_nt;
extern Class_Descriptor cd_S113C32;
static Base_Class bases_S113C31[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3350C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S113C32,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S113C31 = {  "S113C31", // class name
  bases_S113C31, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S113C2  : S113C3 {
  ::S113C26_nt s113c2f0;
  int s113c2f1[3];
  unsigned int s113c2f2:1;
  unsigned int s113c2f3:1;
  unsigned int s113c2f4:1;
  unsigned int s113c2f5:1;
  unsigned int s113c2f6:1;
  unsigned int s113c2f7:1;
  unsigned int s113c2f8:1;
  unsigned int s113c2f9:1;
  unsigned int s113c2f10:1;
  unsigned int s113c2f11:1;
  unsigned int s113c2f12:1;
  unsigned int s113c2f13:1;
  unsigned int s113c2f14:1;
  ::S287C9 s113c2f15;
  void *s113c2f16;
  ::S113C31 s113c2f17;
  void *s113c2f18[2];
  virtual  ~S113C2(); // _ZN6S113C2D1Ev
  virtual void  v124(); // _ZN6S113C24v124Ev
  virtual void  v125(); // _ZN6S113C24v125Ev
  virtual void  v126(); // _ZN6S113C24v126Ev
  virtual void  v127(); // _ZN6S113C24v127Ev
  virtual void  v128(); // _ZN6S113C24v128Ev
  virtual void  v129(); // _ZN6S113C24v129Ev
  virtual void  v130(); // _ZN6S113C24v130Ev
  virtual void  v131(); // _ZN6S113C24v131Ev
  virtual void  v132(); // _ZN6S113C24v132Ev
  virtual void  v133(); // _ZN6S113C24v133Ev
  S113C2(); // tgen
};
//SIG(-1 S113C2) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 Fi[2] Fp Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 FC12{ m} FC8 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 Fi:1 Fi:1 Fi:1 FC13{ BC14{ BC11}} FC15{ BC16{ BC11}} FC17{ BC18{ BC11}} FC19{ BC20{ BC11}} Fi[3]} vd v117 v118 v119 v120 FC7 Fi:1 FC21{ BC22{ BC11}}} vd v121 v122 v123 v124 v125 v126 v127 FC23{ BC24{ BC11}} Fi:1} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 FC25{ BC26{ m FC14 Fp Fi}} Fi[3] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC9 Fp FC27{ BC28{ BC11}} Fp[2]}


 S113C2 ::~S113C2(){ note_dtor("S113C2", this);}
void  S113C2 ::v124(){vfunc_called(this, "_ZN6S113C24v124Ev");}
void  S113C2 ::v125(){vfunc_called(this, "_ZN6S113C24v125Ev");}
void  S113C2 ::v126(){vfunc_called(this, "_ZN6S113C24v126Ev");}
void  S113C2 ::v127(){vfunc_called(this, "_ZN6S113C24v127Ev");}
void  S113C2 ::v128(){vfunc_called(this, "_ZN6S113C24v128Ev");}
void  S113C2 ::v129(){vfunc_called(this, "_ZN6S113C24v129Ev");}
void  S113C2 ::v130(){vfunc_called(this, "_ZN6S113C24v130Ev");}
void  S113C2 ::v131(){vfunc_called(this, "_ZN6S113C24v131Ev");}
void  S113C2 ::v132(){vfunc_called(this, "_ZN6S113C24v132Ev");}
void  S113C2 ::v133(){vfunc_called(this, "_ZN6S113C24v133Ev");}
S113C2 ::S113C2(){ note_ctor("S113C2", this);} // tgen

static void Test_S113C2()
{
  extern Class_Descriptor cd_S113C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(54,78)];
    init_test(&cd_S113C2, buf);
    S113C2 *dp, &lv = *(dp=new (buf) S113C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(424,308), "sizeof(S113C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S113C2)");
    check_base_class_offset(lv, (S113C7*)(S113C6*)(S113C5*)(S113C4*)(S113C3*), 0, "S113C2");
    check_base_class_offset(lv, (S113C6*)(S113C5*)(S113C4*)(S113C3*), 0, "S113C2");
    check_base_class_offset(lv, (S113C5*)(S113C4*)(S113C3*), 0, "S113C2");
    check_base_class_offset(lv, (S113C4*)(S113C3*), 0, "S113C2");
    check_base_class_offset(lv, (S113C3*), 0, "S113C2");
    check_field_offset(lv, s113c2f0, ABISELECT(320,236), "S113C2.s113c2f0");
    check_field_offset(lv, s113c2f1, ABISELECT(352,256), "S113C2.s113c2f1");
    set_bf_and_test(lv, s113c2f2, ABISELECT(364,268), 0, 1, 1, "S113C2");
    set_bf_and_test(lv, s113c2f3, ABISELECT(364,268), 1, 1, 1, "S113C2");
    set_bf_and_test(lv, s113c2f4, ABISELECT(364,268), 2, 1, 1, "S113C2");
    set_bf_and_test(lv, s113c2f5, ABISELECT(364,268), 3, 1, 1, "S113C2");
    set_bf_and_test(lv, s113c2f6, ABISELECT(364,268), 4, 1, 1, "S113C2");
    set_bf_and_test(lv, s113c2f7, ABISELECT(364,268), 5, 1, 1, "S113C2");
    set_bf_and_test(lv, s113c2f8, ABISELECT(364,268), 6, 1, 1, "S113C2");
    set_bf_and_test(lv, s113c2f9, ABISELECT(364,268), 7, 1, 1, "S113C2");
    set_bf_and_test(lv, s113c2f10, ABISELECT(365,269), 0, 1, 1, "S113C2");
    set_bf_and_test(lv, s113c2f11, ABISELECT(365,269), 1, 1, 1, "S113C2");
    set_bf_and_test(lv, s113c2f12, ABISELECT(365,269), 2, 1, 1, "S113C2");
    set_bf_and_test(lv, s113c2f13, ABISELECT(365,269), 3, 1, 1, "S113C2");
    set_bf_and_test(lv, s113c2f14, ABISELECT(365,269), 4, 1, 1, "S113C2");
    check_field_offset(lv, s113c2f15, ABISELECT(368,272), "S113C2.s113c2f15");
    check_field_offset(lv, s113c2f16, ABISELECT(384,284), "S113C2.s113c2f16");
    check_field_offset(lv, s113c2f17, ABISELECT(392,288), "S113C2.s113c2f17");
    check_field_offset(lv, s113c2f18, ABISELECT(408,300), "S113C2.s113c2f18");
    test_class_info(&lv, &cd_S113C2);
    dp->~S113C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS113C2(Test_S113C2, "S113C2", ABISELECT(424,308));

#else // __cplusplus

extern void _ZN6S113C2C1Ev();
extern void _ZN6S113C2D1Ev();
Name_Map name_map_S113C2[] = {
  NSPAIR(_ZN6S113C2C1Ev),
  NSPAIR(_ZN6S113C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S113C7;
extern VTBL_ENTRY _ZTI6S113C7[];
extern  VTBL_ENTRY _ZTV6S113C7[];
extern Class_Descriptor cd_S113C6;
extern VTBL_ENTRY _ZTI6S113C6[];
extern  VTBL_ENTRY _ZTV6S113C6[];
extern Class_Descriptor cd_S113C5;
extern VTBL_ENTRY _ZTI6S113C5[];
extern  VTBL_ENTRY _ZTV6S113C5[];
extern Class_Descriptor cd_S113C4;
extern VTBL_ENTRY _ZTI6S113C4[];
extern  VTBL_ENTRY _ZTV6S113C4[];
extern Class_Descriptor cd_S113C3;
extern VTBL_ENTRY _ZTI6S113C3[];
extern  VTBL_ENTRY _ZTV6S113C3[];
static Base_Class bases_S113C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S113C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S113C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S113C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S113C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S113C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S113C2[];
extern void _ZN6S113C2D1Ev();
extern void _ZN6S113C2D0Ev();
extern void _ZN6S113C72v7Ev();
extern void _ZN6S113C72v8Ev();
extern void _ZN6S113C72v9Ev();
extern void _ZN6S113C73v10Ev();
extern void _ZN6S113C73v11Ev();
extern void _ZN6S113C73v12Ev();
extern void _ZN6S113C73v13Ev();
extern void _ZN6S113C73v14Ev();
extern void _ZN6S113C73v15Ev();
extern void _ZN6S113C73v16Ev();
extern void _ZN6S113C73v17Ev();
extern void _ZN6S113C73v18Ev();
extern void _ZN6S113C73v19Ev();
extern void _ZN6S113C73v20Ev();
extern void _ZN6S113C73v21Ev();
extern void _ZN6S113C73v22Ev();
extern void _ZN6S113C73v23Ev();
extern void _ZN6S113C73v24Ev();
extern void _ZN6S113C73v25Ev();
extern void _ZN6S113C73v26Ev();
extern void _ZN6S113C73v27Ev();
extern void _ZN6S113C73v28Ev();
extern void _ZN6S113C73v29Ev();
extern void _ZN6S113C73v30Ev();
extern void _ZN6S113C73v31Ev();
extern void _ZN6S113C73v32Ev();
extern void _ZN6S113C73v33Ev();
extern void _ZN6S113C73v34Ev();
extern void _ZN6S113C73v35Ev();
extern void _ZN6S113C73v36Ev();
extern void _ZN6S113C73v37Ev();
extern void _ZN6S113C73v38Ev();
extern void _ZN6S113C73v39Ev();
extern void _ZN6S113C73v40Ev();
extern void _ZN6S113C73v41Ev();
extern void _ZN6S113C73v42Ev();
extern void _ZN6S113C73v43Ev();
extern void _ZN6S113C73v44Ev();
extern void _ZN6S113C73v45Ev();
extern void _ZN6S113C73v46Ev();
extern void _ZN6S113C73v47Ev();
extern void _ZN6S113C73v48Ev();
extern void _ZN6S113C73v49Ev();
extern void _ZN6S113C73v50Ev();
extern void _ZN6S113C73v51Ev();
extern void _ZN6S113C73v52Ev();
extern void _ZN6S113C73v53Ev();
extern void _ZN6S113C73v54Ev();
extern void _ZN6S113C73v55Ev();
extern void _ZN6S113C73v56Ev();
extern void _ZN6S113C73v57Ev();
extern void _ZN6S113C73v58Ev();
extern void _ZN6S113C73v59Ev();
extern void _ZN6S113C73v60Ev();
extern void _ZN6S113C73v61Ev();
extern void _ZN6S113C73v62Ev();
extern void _ZN6S113C73v63Ev();
extern void _ZN6S113C73v64Ev();
extern void _ZN6S113C73v65Ev();
extern void _ZN6S113C73v66Ev();
extern void _ZN6S113C73v67Ev();
extern void _ZN6S113C73v68Ev();
extern void _ZN6S113C73v69Ev();
extern void _ZN6S113C73v70Ev();
extern void _ZN6S113C63v71Ev();
extern void _ZN6S113C63v72Ev();
extern void _ZN6S113C63v73Ev();
extern void _ZN6S113C63v74Ev();
extern void _ZN6S113C63v75Ev();
extern void _ZN6S113C63v76Ev();
extern void _ZN6S113C63v77Ev();
extern void _ZN6S113C63v78Ev();
extern void _ZN6S113C63v79Ev();
extern void _ZN6S113C63v80Ev();
extern void _ZN6S113C63v81Ev();
extern void _ZN6S113C63v82Ev();
extern void _ZN6S113C63v83Ev();
extern void _ZN6S113C63v84Ev();
extern void _ZN6S113C63v85Ev();
extern void _ZN6S113C63v86Ev();
extern void _ZN6S113C63v87Ev();
extern void _ZN6S113C63v88Ev();
extern void _ZN6S113C63v89Ev();
extern void _ZN6S113C63v90Ev();
extern void _ZN6S113C63v91Ev();
extern void _ZN6S113C63v92Ev();
extern void _ZN6S113C53v93Ev();
extern void _ZN6S113C53v94Ev();
extern void _ZN6S113C53v95Ev();
extern void _ZN6S113C53v96Ev();
extern void _ZN6S113C53v97Ev();
extern void _ZN6S113C53v98Ev();
extern void _ZN6S113C53v99Ev();
extern void _ZN6S113C54v100Ev();
extern void _ZN6S113C54v101Ev();
extern void _ZN6S113C54v102Ev();
extern void _ZN6S113C54v103Ev();
extern void _ZN6S113C54v104Ev();
extern void _ZN6S113C54v105Ev();
extern void _ZN6S113C54v106Ev();
extern void _ZN6S113C54v107Ev();
extern void _ZN6S113C54v108Ev();
extern void _ZN6S113C54v109Ev();
extern void _ZN6S113C54v110Ev();
extern void _ZN6S113C54v111Ev();
extern void _ZN6S113C54v112Ev();
extern void _ZN6S113C44v113Ev();
extern void _ZN6S113C44v114Ev();
extern void _ZN6S113C44v115Ev();
extern void _ZN6S113C44v116Ev();
extern void _ZN6S113C34v117Ev();
extern void _ZN6S113C34v118Ev();
extern void _ZN6S113C34v119Ev();
extern void _ZN6S113C34v120Ev();
extern void _ZN6S113C34v121Ev();
extern void _ZN6S113C34v122Ev();
extern void _ZN6S113C34v123Ev();
extern void _ZN6S113C24v124Ev();
extern void _ZN6S113C24v125Ev();
extern void _ZN6S113C24v126Ev();
extern void _ZN6S113C24v127Ev();
extern void _ZN6S113C24v128Ev();
extern void _ZN6S113C24v129Ev();
extern void _ZN6S113C24v130Ev();
extern void _ZN6S113C24v131Ev();
extern void _ZN6S113C24v132Ev();
extern void _ZN6S113C24v133Ev();
static  VTBL_ENTRY vtc_S113C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S113C2[0]),
  (VTBL_ENTRY)&_ZN6S113C2D1Ev,
  (VTBL_ENTRY)&_ZN6S113C2D0Ev,
  (VTBL_ENTRY)&_ZN6S113C72v7Ev,
  (VTBL_ENTRY)&_ZN6S113C72v8Ev,
  (VTBL_ENTRY)&_ZN6S113C72v9Ev,
  (VTBL_ENTRY)&_ZN6S113C73v10Ev,
  (VTBL_ENTRY)&_ZN6S113C73v11Ev,
  (VTBL_ENTRY)&_ZN6S113C73v12Ev,
  (VTBL_ENTRY)&_ZN6S113C73v13Ev,
  (VTBL_ENTRY)&_ZN6S113C73v14Ev,
  (VTBL_ENTRY)&_ZN6S113C73v15Ev,
  (VTBL_ENTRY)&_ZN6S113C73v16Ev,
  (VTBL_ENTRY)&_ZN6S113C73v17Ev,
  (VTBL_ENTRY)&_ZN6S113C73v18Ev,
  (VTBL_ENTRY)&_ZN6S113C73v19Ev,
  (VTBL_ENTRY)&_ZN6S113C73v20Ev,
  (VTBL_ENTRY)&_ZN6S113C73v21Ev,
  (VTBL_ENTRY)&_ZN6S113C73v22Ev,
  (VTBL_ENTRY)&_ZN6S113C73v23Ev,
  (VTBL_ENTRY)&_ZN6S113C73v24Ev,
  (VTBL_ENTRY)&_ZN6S113C73v25Ev,
  (VTBL_ENTRY)&_ZN6S113C73v26Ev,
  (VTBL_ENTRY)&_ZN6S113C73v27Ev,
  (VTBL_ENTRY)&_ZN6S113C73v28Ev,
  (VTBL_ENTRY)&_ZN6S113C73v29Ev,
  (VTBL_ENTRY)&_ZN6S113C73v30Ev,
  (VTBL_ENTRY)&_ZN6S113C73v31Ev,
  (VTBL_ENTRY)&_ZN6S113C73v32Ev,
  (VTBL_ENTRY)&_ZN6S113C73v33Ev,
  (VTBL_ENTRY)&_ZN6S113C73v34Ev,
  (VTBL_ENTRY)&_ZN6S113C73v35Ev,
  (VTBL_ENTRY)&_ZN6S113C73v36Ev,
  (VTBL_ENTRY)&_ZN6S113C73v37Ev,
  (VTBL_ENTRY)&_ZN6S113C73v38Ev,
  (VTBL_ENTRY)&_ZN6S113C73v39Ev,
  (VTBL_ENTRY)&_ZN6S113C73v40Ev,
  (VTBL_ENTRY)&_ZN6S113C73v41Ev,
  (VTBL_ENTRY)&_ZN6S113C73v42Ev,
  (VTBL_ENTRY)&_ZN6S113C73v43Ev,
  (VTBL_ENTRY)&_ZN6S113C73v44Ev,
  (VTBL_ENTRY)&_ZN6S113C73v45Ev,
  (VTBL_ENTRY)&_ZN6S113C73v46Ev,
  (VTBL_ENTRY)&_ZN6S113C73v47Ev,
  (VTBL_ENTRY)&_ZN6S113C73v48Ev,
  (VTBL_ENTRY)&_ZN6S113C73v49Ev,
  (VTBL_ENTRY)&_ZN6S113C73v50Ev,
  (VTBL_ENTRY)&_ZN6S113C73v51Ev,
  (VTBL_ENTRY)&_ZN6S113C73v52Ev,
  (VTBL_ENTRY)&_ZN6S113C73v53Ev,
  (VTBL_ENTRY)&_ZN6S113C73v54Ev,
  (VTBL_ENTRY)&_ZN6S113C73v55Ev,
  (VTBL_ENTRY)&_ZN6S113C73v56Ev,
  (VTBL_ENTRY)&_ZN6S113C73v57Ev,
  (VTBL_ENTRY)&_ZN6S113C73v58Ev,
  (VTBL_ENTRY)&_ZN6S113C73v59Ev,
  (VTBL_ENTRY)&_ZN6S113C73v60Ev,
  (VTBL_ENTRY)&_ZN6S113C73v61Ev,
  (VTBL_ENTRY)&_ZN6S113C73v62Ev,
  (VTBL_ENTRY)&_ZN6S113C73v63Ev,
  (VTBL_ENTRY)&_ZN6S113C73v64Ev,
  (VTBL_ENTRY)&_ZN6S113C73v65Ev,
  (VTBL_ENTRY)&_ZN6S113C73v66Ev,
  (VTBL_ENTRY)&_ZN6S113C73v67Ev,
  (VTBL_ENTRY)&_ZN6S113C73v68Ev,
  (VTBL_ENTRY)&_ZN6S113C73v69Ev,
  (VTBL_ENTRY)&_ZN6S113C73v70Ev,
  (VTBL_ENTRY)&_ZN6S113C63v71Ev,
  (VTBL_ENTRY)&_ZN6S113C63v72Ev,
  (VTBL_ENTRY)&_ZN6S113C63v73Ev,
  (VTBL_ENTRY)&_ZN6S113C63v74Ev,
  (VTBL_ENTRY)&_ZN6S113C63v75Ev,
  (VTBL_ENTRY)&_ZN6S113C63v76Ev,
  (VTBL_ENTRY)&_ZN6S113C63v77Ev,
  (VTBL_ENTRY)&_ZN6S113C63v78Ev,
  (VTBL_ENTRY)&_ZN6S113C63v79Ev,
  (VTBL_ENTRY)&_ZN6S113C63v80Ev,
  (VTBL_ENTRY)&_ZN6S113C63v81Ev,
  (VTBL_ENTRY)&_ZN6S113C63v82Ev,
  (VTBL_ENTRY)&_ZN6S113C63v83Ev,
  (VTBL_ENTRY)&_ZN6S113C63v84Ev,
  (VTBL_ENTRY)&_ZN6S113C63v85Ev,
  (VTBL_ENTRY)&_ZN6S113C63v86Ev,
  (VTBL_ENTRY)&_ZN6S113C63v87Ev,
  (VTBL_ENTRY)&_ZN6S113C63v88Ev,
  (VTBL_ENTRY)&_ZN6S113C63v89Ev,
  (VTBL_ENTRY)&_ZN6S113C63v90Ev,
  (VTBL_ENTRY)&_ZN6S113C63v91Ev,
  (VTBL_ENTRY)&_ZN6S113C63v92Ev,
  (VTBL_ENTRY)&_ZN6S113C53v93Ev,
  (VTBL_ENTRY)&_ZN6S113C53v94Ev,
  (VTBL_ENTRY)&_ZN6S113C53v95Ev,
  (VTBL_ENTRY)&_ZN6S113C53v96Ev,
  (VTBL_ENTRY)&_ZN6S113C53v97Ev,
  (VTBL_ENTRY)&_ZN6S113C53v98Ev,
  (VTBL_ENTRY)&_ZN6S113C53v99Ev,
  (VTBL_ENTRY)&_ZN6S113C54v100Ev,
  (VTBL_ENTRY)&_ZN6S113C54v101Ev,
  (VTBL_ENTRY)&_ZN6S113C54v102Ev,
  (VTBL_ENTRY)&_ZN6S113C54v103Ev,
  (VTBL_ENTRY)&_ZN6S113C54v104Ev,
  (VTBL_ENTRY)&_ZN6S113C54v105Ev,
  (VTBL_ENTRY)&_ZN6S113C54v106Ev,
  (VTBL_ENTRY)&_ZN6S113C54v107Ev,
  (VTBL_ENTRY)&_ZN6S113C54v108Ev,
  (VTBL_ENTRY)&_ZN6S113C54v109Ev,
  (VTBL_ENTRY)&_ZN6S113C54v110Ev,
  (VTBL_ENTRY)&_ZN6S113C54v111Ev,
  (VTBL_ENTRY)&_ZN6S113C54v112Ev,
  (VTBL_ENTRY)&_ZN6S113C44v113Ev,
  (VTBL_ENTRY)&_ZN6S113C44v114Ev,
  (VTBL_ENTRY)&_ZN6S113C44v115Ev,
  (VTBL_ENTRY)&_ZN6S113C44v116Ev,
  (VTBL_ENTRY)&_ZN6S113C34v117Ev,
  (VTBL_ENTRY)&_ZN6S113C34v118Ev,
  (VTBL_ENTRY)&_ZN6S113C34v119Ev,
  (VTBL_ENTRY)&_ZN6S113C34v120Ev,
  (VTBL_ENTRY)&_ZN6S113C34v121Ev,
  (VTBL_ENTRY)&_ZN6S113C34v122Ev,
  (VTBL_ENTRY)&_ZN6S113C34v123Ev,
  (VTBL_ENTRY)&_ZN6S113C24v124Ev,
  (VTBL_ENTRY)&_ZN6S113C24v125Ev,
  (VTBL_ENTRY)&_ZN6S113C24v126Ev,
  (VTBL_ENTRY)&_ZN6S113C24v127Ev,
  (VTBL_ENTRY)&_ZN6S113C24v128Ev,
  (VTBL_ENTRY)&_ZN6S113C24v129Ev,
  (VTBL_ENTRY)&_ZN6S113C24v130Ev,
  (VTBL_ENTRY)&_ZN6S113C24v131Ev,
  (VTBL_ENTRY)&_ZN6S113C24v132Ev,
  (VTBL_ENTRY)&_ZN6S113C24v133Ev,
};
extern VTBL_ENTRY _ZTI6S113C2[];
extern  VTBL_ENTRY _ZTV6S113C2[];
Class_Descriptor cd_S113C2 = {  "S113C2", // class name
  bases_S113C2, 5,
  &(vtc_S113C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(424,308), // object size
  NSPAIRA(_ZTI6S113C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S113C2),131, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S113C1  : S113C2 {
  virtual  ~S113C1(); // _ZN6S113C1D1Ev
  virtual void  v1(); // _ZN6S113C12v1Ev
  virtual void  v2(); // _ZN6S113C12v2Ev
  virtual void  v3(); // _ZN6S113C12v3Ev
  virtual void  v4(); // _ZN6S113C12v4Ev
  virtual void  v5(); // _ZN6S113C12v5Ev
  virtual void  v6(); // _ZN6S113C12v6Ev
  S113C1(); // tgen
};
//SIG(1 S113C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{ vd v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 Fi FL Fp[4] Fi[2] Fp FC8{ m Fi[2]} Fp[2]} vd v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 Fi[2] Fp Fi[2] FC9{ BC10{ BC11{ BC12{ m Fp Fi[2]}}}} FC9 FC13{ m} FC9 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 Fi:1 Fi:1 Fi:1 FC14{ BC15{ BC12}} FC16{ BC17{ BC12}} FC18{ BC19{ BC12}} FC20{ BC21{ BC12}} Fi[3]} vd v113 v114 v115 v116 FC8 Fi:1 FC22{ BC23{ BC12}}} vd v117 v118 v119 v120 v121 v122 v123 FC24{ BC25{ BC12}} Fi:1} vd v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 FC26{ BC27{ m FC15 Fp Fi}} Fi[3] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC10 Fp FC28{ BC29{ BC12}} Fp[2]} vd v1 v2 v3 v4 v5 v6}


 S113C1 ::~S113C1(){ note_dtor("S113C1", this);}
void  S113C1 ::v1(){vfunc_called(this, "_ZN6S113C12v1Ev");}
void  S113C1 ::v2(){vfunc_called(this, "_ZN6S113C12v2Ev");}
void  S113C1 ::v3(){vfunc_called(this, "_ZN6S113C12v3Ev");}
void  S113C1 ::v4(){vfunc_called(this, "_ZN6S113C12v4Ev");}
void  S113C1 ::v5(){vfunc_called(this, "_ZN6S113C12v5Ev");}
void  S113C1 ::v6(){vfunc_called(this, "_ZN6S113C12v6Ev");}
S113C1 ::S113C1(){ note_ctor("S113C1", this);} // tgen

static void Test_S113C1()
{
  extern Class_Descriptor cd_S113C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(54,78)];
    init_test(&cd_S113C1, buf);
    S113C1 *dp, &lv = *(dp=new (buf) S113C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(424,308), "sizeof(S113C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S113C1)");
    check_base_class_offset(lv, (S113C7*)(S113C6*)(S113C5*)(S113C4*)(S113C3*)(S113C2*), 0, "S113C1");
    check_base_class_offset(lv, (S113C6*)(S113C5*)(S113C4*)(S113C3*)(S113C2*), 0, "S113C1");
    check_base_class_offset(lv, (S113C5*)(S113C4*)(S113C3*)(S113C2*), 0, "S113C1");
    check_base_class_offset(lv, (S113C4*)(S113C3*)(S113C2*), 0, "S113C1");
    check_base_class_offset(lv, (S113C3*)(S113C2*), 0, "S113C1");
    check_base_class_offset(lv, (S113C2*), 0, "S113C1");
    test_class_info(&lv, &cd_S113C1);
    dp->~S113C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS113C1(Test_S113C1, "S113C1", ABISELECT(424,308));

#else // __cplusplus

extern void _ZN6S113C1C1Ev();
extern void _ZN6S113C1D1Ev();
Name_Map name_map_S113C1[] = {
  NSPAIR(_ZN6S113C1C1Ev),
  NSPAIR(_ZN6S113C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S113C7;
extern VTBL_ENTRY _ZTI6S113C7[];
extern  VTBL_ENTRY _ZTV6S113C7[];
extern Class_Descriptor cd_S113C6;
extern VTBL_ENTRY _ZTI6S113C6[];
extern  VTBL_ENTRY _ZTV6S113C6[];
extern Class_Descriptor cd_S113C5;
extern VTBL_ENTRY _ZTI6S113C5[];
extern  VTBL_ENTRY _ZTV6S113C5[];
extern Class_Descriptor cd_S113C4;
extern VTBL_ENTRY _ZTI6S113C4[];
extern  VTBL_ENTRY _ZTV6S113C4[];
extern Class_Descriptor cd_S113C3;
extern VTBL_ENTRY _ZTI6S113C3[];
extern  VTBL_ENTRY _ZTV6S113C3[];
extern Class_Descriptor cd_S113C2;
extern VTBL_ENTRY _ZTI6S113C2[];
extern  VTBL_ENTRY _ZTV6S113C2[];
static Base_Class bases_S113C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S113C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S113C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S113C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S113C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S113C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S113C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S113C1[];
extern void _ZN6S113C1D1Ev();
extern void _ZN6S113C1D0Ev();
extern void _ZN6S113C72v7Ev();
extern void _ZN6S113C72v8Ev();
extern void _ZN6S113C72v9Ev();
extern void _ZN6S113C73v10Ev();
extern void _ZN6S113C73v11Ev();
extern void _ZN6S113C73v12Ev();
extern void _ZN6S113C73v13Ev();
extern void _ZN6S113C73v14Ev();
extern void _ZN6S113C73v15Ev();
extern void _ZN6S113C73v16Ev();
extern void _ZN6S113C73v17Ev();
extern void _ZN6S113C73v18Ev();
extern void _ZN6S113C73v19Ev();
extern void _ZN6S113C73v20Ev();
extern void _ZN6S113C73v21Ev();
extern void _ZN6S113C73v22Ev();
extern void _ZN6S113C73v23Ev();
extern void _ZN6S113C73v24Ev();
extern void _ZN6S113C73v25Ev();
extern void _ZN6S113C73v26Ev();
extern void _ZN6S113C73v27Ev();
extern void _ZN6S113C73v28Ev();
extern void _ZN6S113C73v29Ev();
extern void _ZN6S113C73v30Ev();
extern void _ZN6S113C73v31Ev();
extern void _ZN6S113C73v32Ev();
extern void _ZN6S113C73v33Ev();
extern void _ZN6S113C73v34Ev();
extern void _ZN6S113C73v35Ev();
extern void _ZN6S113C73v36Ev();
extern void _ZN6S113C73v37Ev();
extern void _ZN6S113C73v38Ev();
extern void _ZN6S113C73v39Ev();
extern void _ZN6S113C73v40Ev();
extern void _ZN6S113C73v41Ev();
extern void _ZN6S113C73v42Ev();
extern void _ZN6S113C73v43Ev();
extern void _ZN6S113C73v44Ev();
extern void _ZN6S113C73v45Ev();
extern void _ZN6S113C73v46Ev();
extern void _ZN6S113C73v47Ev();
extern void _ZN6S113C73v48Ev();
extern void _ZN6S113C73v49Ev();
extern void _ZN6S113C73v50Ev();
extern void _ZN6S113C73v51Ev();
extern void _ZN6S113C73v52Ev();
extern void _ZN6S113C73v53Ev();
extern void _ZN6S113C73v54Ev();
extern void _ZN6S113C73v55Ev();
extern void _ZN6S113C73v56Ev();
extern void _ZN6S113C73v57Ev();
extern void _ZN6S113C73v58Ev();
extern void _ZN6S113C73v59Ev();
extern void _ZN6S113C73v60Ev();
extern void _ZN6S113C73v61Ev();
extern void _ZN6S113C73v62Ev();
extern void _ZN6S113C73v63Ev();
extern void _ZN6S113C73v64Ev();
extern void _ZN6S113C73v65Ev();
extern void _ZN6S113C73v66Ev();
extern void _ZN6S113C73v67Ev();
extern void _ZN6S113C73v68Ev();
extern void _ZN6S113C73v69Ev();
extern void _ZN6S113C73v70Ev();
extern void _ZN6S113C63v71Ev();
extern void _ZN6S113C63v72Ev();
extern void _ZN6S113C63v73Ev();
extern void _ZN6S113C63v74Ev();
extern void _ZN6S113C63v75Ev();
extern void _ZN6S113C63v76Ev();
extern void _ZN6S113C63v77Ev();
extern void _ZN6S113C63v78Ev();
extern void _ZN6S113C63v79Ev();
extern void _ZN6S113C63v80Ev();
extern void _ZN6S113C63v81Ev();
extern void _ZN6S113C63v82Ev();
extern void _ZN6S113C63v83Ev();
extern void _ZN6S113C63v84Ev();
extern void _ZN6S113C63v85Ev();
extern void _ZN6S113C63v86Ev();
extern void _ZN6S113C63v87Ev();
extern void _ZN6S113C63v88Ev();
extern void _ZN6S113C63v89Ev();
extern void _ZN6S113C63v90Ev();
extern void _ZN6S113C63v91Ev();
extern void _ZN6S113C63v92Ev();
extern void _ZN6S113C53v93Ev();
extern void _ZN6S113C53v94Ev();
extern void _ZN6S113C53v95Ev();
extern void _ZN6S113C53v96Ev();
extern void _ZN6S113C53v97Ev();
extern void _ZN6S113C53v98Ev();
extern void _ZN6S113C53v99Ev();
extern void _ZN6S113C54v100Ev();
extern void _ZN6S113C54v101Ev();
extern void _ZN6S113C54v102Ev();
extern void _ZN6S113C54v103Ev();
extern void _ZN6S113C54v104Ev();
extern void _ZN6S113C54v105Ev();
extern void _ZN6S113C54v106Ev();
extern void _ZN6S113C54v107Ev();
extern void _ZN6S113C54v108Ev();
extern void _ZN6S113C54v109Ev();
extern void _ZN6S113C54v110Ev();
extern void _ZN6S113C54v111Ev();
extern void _ZN6S113C54v112Ev();
extern void _ZN6S113C44v113Ev();
extern void _ZN6S113C44v114Ev();
extern void _ZN6S113C44v115Ev();
extern void _ZN6S113C44v116Ev();
extern void _ZN6S113C34v117Ev();
extern void _ZN6S113C34v118Ev();
extern void _ZN6S113C34v119Ev();
extern void _ZN6S113C34v120Ev();
extern void _ZN6S113C34v121Ev();
extern void _ZN6S113C34v122Ev();
extern void _ZN6S113C34v123Ev();
extern void _ZN6S113C24v124Ev();
extern void _ZN6S113C24v125Ev();
extern void _ZN6S113C24v126Ev();
extern void _ZN6S113C24v127Ev();
extern void _ZN6S113C24v128Ev();
extern void _ZN6S113C24v129Ev();
extern void _ZN6S113C24v130Ev();
extern void _ZN6S113C24v131Ev();
extern void _ZN6S113C24v132Ev();
extern void _ZN6S113C24v133Ev();
extern void _ZN6S113C12v1Ev();
extern void _ZN6S113C12v2Ev();
extern void _ZN6S113C12v3Ev();
extern void _ZN6S113C12v4Ev();
extern void _ZN6S113C12v5Ev();
extern void _ZN6S113C12v6Ev();
static  VTBL_ENTRY vtc_S113C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S113C1[0]),
  (VTBL_ENTRY)&_ZN6S113C1D1Ev,
  (VTBL_ENTRY)&_ZN6S113C1D0Ev,
  (VTBL_ENTRY)&_ZN6S113C72v7Ev,
  (VTBL_ENTRY)&_ZN6S113C72v8Ev,
  (VTBL_ENTRY)&_ZN6S113C72v9Ev,
  (VTBL_ENTRY)&_ZN6S113C73v10Ev,
  (VTBL_ENTRY)&_ZN6S113C73v11Ev,
  (VTBL_ENTRY)&_ZN6S113C73v12Ev,
  (VTBL_ENTRY)&_ZN6S113C73v13Ev,
  (VTBL_ENTRY)&_ZN6S113C73v14Ev,
  (VTBL_ENTRY)&_ZN6S113C73v15Ev,
  (VTBL_ENTRY)&_ZN6S113C73v16Ev,
  (VTBL_ENTRY)&_ZN6S113C73v17Ev,
  (VTBL_ENTRY)&_ZN6S113C73v18Ev,
  (VTBL_ENTRY)&_ZN6S113C73v19Ev,
  (VTBL_ENTRY)&_ZN6S113C73v20Ev,
  (VTBL_ENTRY)&_ZN6S113C73v21Ev,
  (VTBL_ENTRY)&_ZN6S113C73v22Ev,
  (VTBL_ENTRY)&_ZN6S113C73v23Ev,
  (VTBL_ENTRY)&_ZN6S113C73v24Ev,
  (VTBL_ENTRY)&_ZN6S113C73v25Ev,
  (VTBL_ENTRY)&_ZN6S113C73v26Ev,
  (VTBL_ENTRY)&_ZN6S113C73v27Ev,
  (VTBL_ENTRY)&_ZN6S113C73v28Ev,
  (VTBL_ENTRY)&_ZN6S113C73v29Ev,
  (VTBL_ENTRY)&_ZN6S113C73v30Ev,
  (VTBL_ENTRY)&_ZN6S113C73v31Ev,
  (VTBL_ENTRY)&_ZN6S113C73v32Ev,
  (VTBL_ENTRY)&_ZN6S113C73v33Ev,
  (VTBL_ENTRY)&_ZN6S113C73v34Ev,
  (VTBL_ENTRY)&_ZN6S113C73v35Ev,
  (VTBL_ENTRY)&_ZN6S113C73v36Ev,
  (VTBL_ENTRY)&_ZN6S113C73v37Ev,
  (VTBL_ENTRY)&_ZN6S113C73v38Ev,
  (VTBL_ENTRY)&_ZN6S113C73v39Ev,
  (VTBL_ENTRY)&_ZN6S113C73v40Ev,
  (VTBL_ENTRY)&_ZN6S113C73v41Ev,
  (VTBL_ENTRY)&_ZN6S113C73v42Ev,
  (VTBL_ENTRY)&_ZN6S113C73v43Ev,
  (VTBL_ENTRY)&_ZN6S113C73v44Ev,
  (VTBL_ENTRY)&_ZN6S113C73v45Ev,
  (VTBL_ENTRY)&_ZN6S113C73v46Ev,
  (VTBL_ENTRY)&_ZN6S113C73v47Ev,
  (VTBL_ENTRY)&_ZN6S113C73v48Ev,
  (VTBL_ENTRY)&_ZN6S113C73v49Ev,
  (VTBL_ENTRY)&_ZN6S113C73v50Ev,
  (VTBL_ENTRY)&_ZN6S113C73v51Ev,
  (VTBL_ENTRY)&_ZN6S113C73v52Ev,
  (VTBL_ENTRY)&_ZN6S113C73v53Ev,
  (VTBL_ENTRY)&_ZN6S113C73v54Ev,
  (VTBL_ENTRY)&_ZN6S113C73v55Ev,
  (VTBL_ENTRY)&_ZN6S113C73v56Ev,
  (VTBL_ENTRY)&_ZN6S113C73v57Ev,
  (VTBL_ENTRY)&_ZN6S113C73v58Ev,
  (VTBL_ENTRY)&_ZN6S113C73v59Ev,
  (VTBL_ENTRY)&_ZN6S113C73v60Ev,
  (VTBL_ENTRY)&_ZN6S113C73v61Ev,
  (VTBL_ENTRY)&_ZN6S113C73v62Ev,
  (VTBL_ENTRY)&_ZN6S113C73v63Ev,
  (VTBL_ENTRY)&_ZN6S113C73v64Ev,
  (VTBL_ENTRY)&_ZN6S113C73v65Ev,
  (VTBL_ENTRY)&_ZN6S113C73v66Ev,
  (VTBL_ENTRY)&_ZN6S113C73v67Ev,
  (VTBL_ENTRY)&_ZN6S113C73v68Ev,
  (VTBL_ENTRY)&_ZN6S113C73v69Ev,
  (VTBL_ENTRY)&_ZN6S113C73v70Ev,
  (VTBL_ENTRY)&_ZN6S113C63v71Ev,
  (VTBL_ENTRY)&_ZN6S113C63v72Ev,
  (VTBL_ENTRY)&_ZN6S113C63v73Ev,
  (VTBL_ENTRY)&_ZN6S113C63v74Ev,
  (VTBL_ENTRY)&_ZN6S113C63v75Ev,
  (VTBL_ENTRY)&_ZN6S113C63v76Ev,
  (VTBL_ENTRY)&_ZN6S113C63v77Ev,
  (VTBL_ENTRY)&_ZN6S113C63v78Ev,
  (VTBL_ENTRY)&_ZN6S113C63v79Ev,
  (VTBL_ENTRY)&_ZN6S113C63v80Ev,
  (VTBL_ENTRY)&_ZN6S113C63v81Ev,
  (VTBL_ENTRY)&_ZN6S113C63v82Ev,
  (VTBL_ENTRY)&_ZN6S113C63v83Ev,
  (VTBL_ENTRY)&_ZN6S113C63v84Ev,
  (VTBL_ENTRY)&_ZN6S113C63v85Ev,
  (VTBL_ENTRY)&_ZN6S113C63v86Ev,
  (VTBL_ENTRY)&_ZN6S113C63v87Ev,
  (VTBL_ENTRY)&_ZN6S113C63v88Ev,
  (VTBL_ENTRY)&_ZN6S113C63v89Ev,
  (VTBL_ENTRY)&_ZN6S113C63v90Ev,
  (VTBL_ENTRY)&_ZN6S113C63v91Ev,
  (VTBL_ENTRY)&_ZN6S113C63v92Ev,
  (VTBL_ENTRY)&_ZN6S113C53v93Ev,
  (VTBL_ENTRY)&_ZN6S113C53v94Ev,
  (VTBL_ENTRY)&_ZN6S113C53v95Ev,
  (VTBL_ENTRY)&_ZN6S113C53v96Ev,
  (VTBL_ENTRY)&_ZN6S113C53v97Ev,
  (VTBL_ENTRY)&_ZN6S113C53v98Ev,
  (VTBL_ENTRY)&_ZN6S113C53v99Ev,
  (VTBL_ENTRY)&_ZN6S113C54v100Ev,
  (VTBL_ENTRY)&_ZN6S113C54v101Ev,
  (VTBL_ENTRY)&_ZN6S113C54v102Ev,
  (VTBL_ENTRY)&_ZN6S113C54v103Ev,
  (VTBL_ENTRY)&_ZN6S113C54v104Ev,
  (VTBL_ENTRY)&_ZN6S113C54v105Ev,
  (VTBL_ENTRY)&_ZN6S113C54v106Ev,
  (VTBL_ENTRY)&_ZN6S113C54v107Ev,
  (VTBL_ENTRY)&_ZN6S113C54v108Ev,
  (VTBL_ENTRY)&_ZN6S113C54v109Ev,
  (VTBL_ENTRY)&_ZN6S113C54v110Ev,
  (VTBL_ENTRY)&_ZN6S113C54v111Ev,
  (VTBL_ENTRY)&_ZN6S113C54v112Ev,
  (VTBL_ENTRY)&_ZN6S113C44v113Ev,
  (VTBL_ENTRY)&_ZN6S113C44v114Ev,
  (VTBL_ENTRY)&_ZN6S113C44v115Ev,
  (VTBL_ENTRY)&_ZN6S113C44v116Ev,
  (VTBL_ENTRY)&_ZN6S113C34v117Ev,
  (VTBL_ENTRY)&_ZN6S113C34v118Ev,
  (VTBL_ENTRY)&_ZN6S113C34v119Ev,
  (VTBL_ENTRY)&_ZN6S113C34v120Ev,
  (VTBL_ENTRY)&_ZN6S113C34v121Ev,
  (VTBL_ENTRY)&_ZN6S113C34v122Ev,
  (VTBL_ENTRY)&_ZN6S113C34v123Ev,
  (VTBL_ENTRY)&_ZN6S113C24v124Ev,
  (VTBL_ENTRY)&_ZN6S113C24v125Ev,
  (VTBL_ENTRY)&_ZN6S113C24v126Ev,
  (VTBL_ENTRY)&_ZN6S113C24v127Ev,
  (VTBL_ENTRY)&_ZN6S113C24v128Ev,
  (VTBL_ENTRY)&_ZN6S113C24v129Ev,
  (VTBL_ENTRY)&_ZN6S113C24v130Ev,
  (VTBL_ENTRY)&_ZN6S113C24v131Ev,
  (VTBL_ENTRY)&_ZN6S113C24v132Ev,
  (VTBL_ENTRY)&_ZN6S113C24v133Ev,
  (VTBL_ENTRY)&_ZN6S113C12v1Ev,
  (VTBL_ENTRY)&_ZN6S113C12v2Ev,
  (VTBL_ENTRY)&_ZN6S113C12v3Ev,
  (VTBL_ENTRY)&_ZN6S113C12v4Ev,
  (VTBL_ENTRY)&_ZN6S113C12v5Ev,
  (VTBL_ENTRY)&_ZN6S113C12v6Ev,
};
extern VTBL_ENTRY _ZTI6S113C1[];
extern  VTBL_ENTRY _ZTV6S113C1[];
Class_Descriptor cd_S113C1 = {  "S113C1", // class name
  bases_S113C1, 6,
  &(vtc_S113C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(424,308), // object size
  NSPAIRA(_ZTI6S113C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S113C1),137, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S266C6  {
  int s266c6f0;
  __tsi64 s266c6f1;
  void *s266c6f2[4];
  int s266c6f3[2];
  void *s266c6f4;
  ::S3350C4_nt s266c6f5;
  void *s266c6f6[2];
  virtual  ~S266C6(); // _ZN6S266C6D1Ev
  virtual void  v6(); // _ZN6S266C62v6Ev
  virtual void  v7(); // _ZN6S266C62v7Ev
  virtual void  v8(); // _ZN6S266C62v8Ev
  virtual void  v9(); // _ZN6S266C62v9Ev
  virtual void  v10(); // _ZN6S266C63v10Ev
  virtual void  v11(); // _ZN6S266C63v11Ev
  virtual void  v12(); // _ZN6S266C63v12Ev
  virtual void  v13(); // _ZN6S266C63v13Ev
  virtual void  v14(); // _ZN6S266C63v14Ev
  virtual void  v15(); // _ZN6S266C63v15Ev
  virtual void  v16(); // _ZN6S266C63v16Ev
  virtual void  v17(); // _ZN6S266C63v17Ev
  virtual void  v18(); // _ZN6S266C63v18Ev
  virtual void  v19(); // _ZN6S266C63v19Ev
  virtual void  v20(); // _ZN6S266C63v20Ev
  virtual void  v21(); // _ZN6S266C63v21Ev
  virtual void  v22(); // _ZN6S266C63v22Ev
  virtual void  v23(); // _ZN6S266C63v23Ev
  virtual void  v24(); // _ZN6S266C63v24Ev
  virtual void  v25(); // _ZN6S266C63v25Ev
  virtual void  v26(); // _ZN6S266C63v26Ev
  virtual void  v27(); // _ZN6S266C63v27Ev
  virtual void  v28(); // _ZN6S266C63v28Ev
  virtual void  v29(); // _ZN6S266C63v29Ev
  virtual void  v30(); // _ZN6S266C63v30Ev
  virtual void  v31(); // _ZN6S266C63v31Ev
  virtual void  v32(); // _ZN6S266C63v32Ev
  virtual void  v33(); // _ZN6S266C63v33Ev
  virtual void  v34(); // _ZN6S266C63v34Ev
  virtual void  v35(); // _ZN6S266C63v35Ev
  virtual void  v36(); // _ZN6S266C63v36Ev
  virtual void  v37(); // _ZN6S266C63v37Ev
  virtual void  v38(); // _ZN6S266C63v38Ev
  virtual void  v39(); // _ZN6S266C63v39Ev
  virtual void  v40(); // _ZN6S266C63v40Ev
  virtual void  v41(); // _ZN6S266C63v41Ev
  virtual void  v42(); // _ZN6S266C63v42Ev
  virtual void  v43(); // _ZN6S266C63v43Ev
  virtual void  v44(); // _ZN6S266C63v44Ev
  virtual void  v45(); // _ZN6S266C63v45Ev
  virtual void  v46(); // _ZN6S266C63v46Ev
  virtual void  v47(); // _ZN6S266C63v47Ev
  virtual void  v48(); // _ZN6S266C63v48Ev
  virtual void  v49(); // _ZN6S266C63v49Ev
  virtual void  v50(); // _ZN6S266C63v50Ev
  virtual void  v51(); // _ZN6S266C63v51Ev
  virtual void  v52(); // _ZN6S266C63v52Ev
  virtual void  v53(); // _ZN6S266C63v53Ev
  virtual void  v54(); // _ZN6S266C63v54Ev
  virtual void  v55(); // _ZN6S266C63v55Ev
  virtual void  v56(); // _ZN6S266C63v56Ev
  virtual void  v57(); // _ZN6S266C63v57Ev
  virtual void  v58(); // _ZN6S266C63v58Ev
  virtual void  v59(); // _ZN6S266C63v59Ev
  virtual void  v60(); // _ZN6S266C63v60Ev
  virtual void  v61(); // _ZN6S266C63v61Ev
  virtual void  v62(); // _ZN6S266C63v62Ev
  virtual void  v63(); // _ZN6S266C63v63Ev
  virtual void  v64(); // _ZN6S266C63v64Ev
  virtual void  v65(); // _ZN6S266C63v65Ev
  virtual void  v66(); // _ZN6S266C63v66Ev
  virtual void  v67(); // _ZN6S266C63v67Ev
  virtual void  v68(); // _ZN6S266C63v68Ev
  virtual void  v69(); // _ZN6S266C63v69Ev
  S266C6(); // tgen
};
//SIG(-1 S266C6) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S266C6 ::~S266C6(){ note_dtor("S266C6", this);}
void  S266C6 ::v6(){vfunc_called(this, "_ZN6S266C62v6Ev");}
void  S266C6 ::v7(){vfunc_called(this, "_ZN6S266C62v7Ev");}
void  S266C6 ::v8(){vfunc_called(this, "_ZN6S266C62v8Ev");}
void  S266C6 ::v9(){vfunc_called(this, "_ZN6S266C62v9Ev");}
void  S266C6 ::v10(){vfunc_called(this, "_ZN6S266C63v10Ev");}
void  S266C6 ::v11(){vfunc_called(this, "_ZN6S266C63v11Ev");}
void  S266C6 ::v12(){vfunc_called(this, "_ZN6S266C63v12Ev");}
void  S266C6 ::v13(){vfunc_called(this, "_ZN6S266C63v13Ev");}
void  S266C6 ::v14(){vfunc_called(this, "_ZN6S266C63v14Ev");}
void  S266C6 ::v15(){vfunc_called(this, "_ZN6S266C63v15Ev");}
void  S266C6 ::v16(){vfunc_called(this, "_ZN6S266C63v16Ev");}
void  S266C6 ::v17(){vfunc_called(this, "_ZN6S266C63v17Ev");}
void  S266C6 ::v18(){vfunc_called(this, "_ZN6S266C63v18Ev");}
void  S266C6 ::v19(){vfunc_called(this, "_ZN6S266C63v19Ev");}
void  S266C6 ::v20(){vfunc_called(this, "_ZN6S266C63v20Ev");}
void  S266C6 ::v21(){vfunc_called(this, "_ZN6S266C63v21Ev");}
void  S266C6 ::v22(){vfunc_called(this, "_ZN6S266C63v22Ev");}
void  S266C6 ::v23(){vfunc_called(this, "_ZN6S266C63v23Ev");}
void  S266C6 ::v24(){vfunc_called(this, "_ZN6S266C63v24Ev");}
void  S266C6 ::v25(){vfunc_called(this, "_ZN6S266C63v25Ev");}
void  S266C6 ::v26(){vfunc_called(this, "_ZN6S266C63v26Ev");}
void  S266C6 ::v27(){vfunc_called(this, "_ZN6S266C63v27Ev");}
void  S266C6 ::v28(){vfunc_called(this, "_ZN6S266C63v28Ev");}
void  S266C6 ::v29(){vfunc_called(this, "_ZN6S266C63v29Ev");}
void  S266C6 ::v30(){vfunc_called(this, "_ZN6S266C63v30Ev");}
void  S266C6 ::v31(){vfunc_called(this, "_ZN6S266C63v31Ev");}
void  S266C6 ::v32(){vfunc_called(this, "_ZN6S266C63v32Ev");}
void  S266C6 ::v33(){vfunc_called(this, "_ZN6S266C63v33Ev");}
void  S266C6 ::v34(){vfunc_called(this, "_ZN6S266C63v34Ev");}
void  S266C6 ::v35(){vfunc_called(this, "_ZN6S266C63v35Ev");}
void  S266C6 ::v36(){vfunc_called(this, "_ZN6S266C63v36Ev");}
void  S266C6 ::v37(){vfunc_called(this, "_ZN6S266C63v37Ev");}
void  S266C6 ::v38(){vfunc_called(this, "_ZN6S266C63v38Ev");}
void  S266C6 ::v39(){vfunc_called(this, "_ZN6S266C63v39Ev");}
void  S266C6 ::v40(){vfunc_called(this, "_ZN6S266C63v40Ev");}
void  S266C6 ::v41(){vfunc_called(this, "_ZN6S266C63v41Ev");}
void  S266C6 ::v42(){vfunc_called(this, "_ZN6S266C63v42Ev");}
void  S266C6 ::v43(){vfunc_called(this, "_ZN6S266C63v43Ev");}
void  S266C6 ::v44(){vfunc_called(this, "_ZN6S266C63v44Ev");}
void  S266C6 ::v45(){vfunc_called(this, "_ZN6S266C63v45Ev");}
void  S266C6 ::v46(){vfunc_called(this, "_ZN6S266C63v46Ev");}
void  S266C6 ::v47(){vfunc_called(this, "_ZN6S266C63v47Ev");}
void  S266C6 ::v48(){vfunc_called(this, "_ZN6S266C63v48Ev");}
void  S266C6 ::v49(){vfunc_called(this, "_ZN6S266C63v49Ev");}
void  S266C6 ::v50(){vfunc_called(this, "_ZN6S266C63v50Ev");}
void  S266C6 ::v51(){vfunc_called(this, "_ZN6S266C63v51Ev");}
void  S266C6 ::v52(){vfunc_called(this, "_ZN6S266C63v52Ev");}
void  S266C6 ::v53(){vfunc_called(this, "_ZN6S266C63v53Ev");}
void  S266C6 ::v54(){vfunc_called(this, "_ZN6S266C63v54Ev");}
void  S266C6 ::v55(){vfunc_called(this, "_ZN6S266C63v55Ev");}
void  S266C6 ::v56(){vfunc_called(this, "_ZN6S266C63v56Ev");}
void  S266C6 ::v57(){vfunc_called(this, "_ZN6S266C63v57Ev");}
void  S266C6 ::v58(){vfunc_called(this, "_ZN6S266C63v58Ev");}
void  S266C6 ::v59(){vfunc_called(this, "_ZN6S266C63v59Ev");}
void  S266C6 ::v60(){vfunc_called(this, "_ZN6S266C63v60Ev");}
void  S266C6 ::v61(){vfunc_called(this, "_ZN6S266C63v61Ev");}
void  S266C6 ::v62(){vfunc_called(this, "_ZN6S266C63v62Ev");}
void  S266C6 ::v63(){vfunc_called(this, "_ZN6S266C63v63Ev");}
void  S266C6 ::v64(){vfunc_called(this, "_ZN6S266C63v64Ev");}
void  S266C6 ::v65(){vfunc_called(this, "_ZN6S266C63v65Ev");}
void  S266C6 ::v66(){vfunc_called(this, "_ZN6S266C63v66Ev");}
void  S266C6 ::v67(){vfunc_called(this, "_ZN6S266C63v67Ev");}
void  S266C6 ::v68(){vfunc_called(this, "_ZN6S266C63v68Ev");}
void  S266C6 ::v69(){vfunc_called(this, "_ZN6S266C63v69Ev");}
S266C6 ::S266C6(){ note_ctor("S266C6", this);} // tgen

static void Test_S266C6()
{
  extern Class_Descriptor cd_S266C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S266C6, buf);
    S266C6 *dp, &lv = *(dp=new (buf) S266C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S266C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S266C6)");
    check_field_offset(lv, s266c6f0, ABISELECT(8,4), "S266C6.s266c6f0");
    check_field_offset(lv, s266c6f1, ABISELECT(16,8), "S266C6.s266c6f1");
    check_field_offset(lv, s266c6f2, ABISELECT(24,16), "S266C6.s266c6f2");
    check_field_offset(lv, s266c6f3, ABISELECT(56,32), "S266C6.s266c6f3");
    check_field_offset(lv, s266c6f4, ABISELECT(64,40), "S266C6.s266c6f4");
    check_field_offset(lv, s266c6f5, ABISELECT(72,44), "S266C6.s266c6f5");
    check_field_offset(lv, s266c6f6, ABISELECT(80,52), "S266C6.s266c6f6");
    test_class_info(&lv, &cd_S266C6);
    dp->~S266C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS266C6(Test_S266C6, "S266C6", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S266C6C1Ev();
extern void _ZN6S266C6D1Ev();
Name_Map name_map_S266C6[] = {
  NSPAIR(_ZN6S266C6C1Ev),
  NSPAIR(_ZN6S266C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S266C6[];
extern void _ZN6S266C6D1Ev();
extern void _ZN6S266C6D0Ev();
extern void _ZN6S266C62v6Ev();
extern void _ZN6S266C62v7Ev();
extern void _ZN6S266C62v8Ev();
extern void _ZN6S266C62v9Ev();
extern void _ZN6S266C63v10Ev();
extern void _ZN6S266C63v11Ev();
extern void _ZN6S266C63v12Ev();
extern void _ZN6S266C63v13Ev();
extern void _ZN6S266C63v14Ev();
extern void _ZN6S266C63v15Ev();
extern void _ZN6S266C63v16Ev();
extern void _ZN6S266C63v17Ev();
extern void _ZN6S266C63v18Ev();
extern void _ZN6S266C63v19Ev();
extern void _ZN6S266C63v20Ev();
extern void _ZN6S266C63v21Ev();
extern void _ZN6S266C63v22Ev();
extern void _ZN6S266C63v23Ev();
extern void _ZN6S266C63v24Ev();
extern void _ZN6S266C63v25Ev();
extern void _ZN6S266C63v26Ev();
extern void _ZN6S266C63v27Ev();
extern void _ZN6S266C63v28Ev();
extern void _ZN6S266C63v29Ev();
extern void _ZN6S266C63v30Ev();
extern void _ZN6S266C63v31Ev();
extern void _ZN6S266C63v32Ev();
extern void _ZN6S266C63v33Ev();
extern void _ZN6S266C63v34Ev();
extern void _ZN6S266C63v35Ev();
extern void _ZN6S266C63v36Ev();
extern void _ZN6S266C63v37Ev();
extern void _ZN6S266C63v38Ev();
extern void _ZN6S266C63v39Ev();
extern void _ZN6S266C63v40Ev();
extern void _ZN6S266C63v41Ev();
extern void _ZN6S266C63v42Ev();
extern void _ZN6S266C63v43Ev();
extern void _ZN6S266C63v44Ev();
extern void _ZN6S266C63v45Ev();
extern void _ZN6S266C63v46Ev();
extern void _ZN6S266C63v47Ev();
extern void _ZN6S266C63v48Ev();
extern void _ZN6S266C63v49Ev();
extern void _ZN6S266C63v50Ev();
extern void _ZN6S266C63v51Ev();
extern void _ZN6S266C63v52Ev();
extern void _ZN6S266C63v53Ev();
extern void _ZN6S266C63v54Ev();
extern void _ZN6S266C63v55Ev();
extern void _ZN6S266C63v56Ev();
extern void _ZN6S266C63v57Ev();
extern void _ZN6S266C63v58Ev();
extern void _ZN6S266C63v59Ev();
extern void _ZN6S266C63v60Ev();
extern void _ZN6S266C63v61Ev();
extern void _ZN6S266C63v62Ev();
extern void _ZN6S266C63v63Ev();
extern void _ZN6S266C63v64Ev();
extern void _ZN6S266C63v65Ev();
extern void _ZN6S266C63v66Ev();
extern void _ZN6S266C63v67Ev();
extern void _ZN6S266C63v68Ev();
extern void _ZN6S266C63v69Ev();
static  VTBL_ENTRY vtc_S266C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S266C6[0]),
  (VTBL_ENTRY)&_ZN6S266C6D1Ev,
  (VTBL_ENTRY)&_ZN6S266C6D0Ev,
  (VTBL_ENTRY)&_ZN6S266C62v6Ev,
  (VTBL_ENTRY)&_ZN6S266C62v7Ev,
  (VTBL_ENTRY)&_ZN6S266C62v8Ev,
  (VTBL_ENTRY)&_ZN6S266C62v9Ev,
  (VTBL_ENTRY)&_ZN6S266C63v10Ev,
  (VTBL_ENTRY)&_ZN6S266C63v11Ev,
  (VTBL_ENTRY)&_ZN6S266C63v12Ev,
  (VTBL_ENTRY)&_ZN6S266C63v13Ev,
  (VTBL_ENTRY)&_ZN6S266C63v14Ev,
  (VTBL_ENTRY)&_ZN6S266C63v15Ev,
  (VTBL_ENTRY)&_ZN6S266C63v16Ev,
  (VTBL_ENTRY)&_ZN6S266C63v17Ev,
  (VTBL_ENTRY)&_ZN6S266C63v18Ev,
  (VTBL_ENTRY)&_ZN6S266C63v19Ev,
  (VTBL_ENTRY)&_ZN6S266C63v20Ev,
  (VTBL_ENTRY)&_ZN6S266C63v21Ev,
  (VTBL_ENTRY)&_ZN6S266C63v22Ev,
  (VTBL_ENTRY)&_ZN6S266C63v23Ev,
  (VTBL_ENTRY)&_ZN6S266C63v24Ev,
  (VTBL_ENTRY)&_ZN6S266C63v25Ev,
  (VTBL_ENTRY)&_ZN6S266C63v26Ev,
  (VTBL_ENTRY)&_ZN6S266C63v27Ev,
  (VTBL_ENTRY)&_ZN6S266C63v28Ev,
  (VTBL_ENTRY)&_ZN6S266C63v29Ev,
  (VTBL_ENTRY)&_ZN6S266C63v30Ev,
  (VTBL_ENTRY)&_ZN6S266C63v31Ev,
  (VTBL_ENTRY)&_ZN6S266C63v32Ev,
  (VTBL_ENTRY)&_ZN6S266C63v33Ev,
  (VTBL_ENTRY)&_ZN6S266C63v34Ev,
  (VTBL_ENTRY)&_ZN6S266C63v35Ev,
  (VTBL_ENTRY)&_ZN6S266C63v36Ev,
  (VTBL_ENTRY)&_ZN6S266C63v37Ev,
  (VTBL_ENTRY)&_ZN6S266C63v38Ev,
  (VTBL_ENTRY)&_ZN6S266C63v39Ev,
  (VTBL_ENTRY)&_ZN6S266C63v40Ev,
  (VTBL_ENTRY)&_ZN6S266C63v41Ev,
  (VTBL_ENTRY)&_ZN6S266C63v42Ev,
  (VTBL_ENTRY)&_ZN6S266C63v43Ev,
  (VTBL_ENTRY)&_ZN6S266C63v44Ev,
  (VTBL_ENTRY)&_ZN6S266C63v45Ev,
  (VTBL_ENTRY)&_ZN6S266C63v46Ev,
  (VTBL_ENTRY)&_ZN6S266C63v47Ev,
  (VTBL_ENTRY)&_ZN6S266C63v48Ev,
  (VTBL_ENTRY)&_ZN6S266C63v49Ev,
  (VTBL_ENTRY)&_ZN6S266C63v50Ev,
  (VTBL_ENTRY)&_ZN6S266C63v51Ev,
  (VTBL_ENTRY)&_ZN6S266C63v52Ev,
  (VTBL_ENTRY)&_ZN6S266C63v53Ev,
  (VTBL_ENTRY)&_ZN6S266C63v54Ev,
  (VTBL_ENTRY)&_ZN6S266C63v55Ev,
  (VTBL_ENTRY)&_ZN6S266C63v56Ev,
  (VTBL_ENTRY)&_ZN6S266C63v57Ev,
  (VTBL_ENTRY)&_ZN6S266C63v58Ev,
  (VTBL_ENTRY)&_ZN6S266C63v59Ev,
  (VTBL_ENTRY)&_ZN6S266C63v60Ev,
  (VTBL_ENTRY)&_ZN6S266C63v61Ev,
  (VTBL_ENTRY)&_ZN6S266C63v62Ev,
  (VTBL_ENTRY)&_ZN6S266C63v63Ev,
  (VTBL_ENTRY)&_ZN6S266C63v64Ev,
  (VTBL_ENTRY)&_ZN6S266C63v65Ev,
  (VTBL_ENTRY)&_ZN6S266C63v66Ev,
  (VTBL_ENTRY)&_ZN6S266C63v67Ev,
  (VTBL_ENTRY)&_ZN6S266C63v68Ev,
  (VTBL_ENTRY)&_ZN6S266C63v69Ev,
};
extern VTBL_ENTRY _ZTI6S266C6[];
extern  VTBL_ENTRY _ZTV6S266C6[];
Class_Descriptor cd_S266C6 = {  "S266C6", // class name
  0,0,//no base classes
  &(vtc_S266C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S266C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S266C6),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S266C5  : S266C6 {
  int s266c5f0[2];
  void *s266c5f1;
  int s266c5f2[2];
  ::S287C8_nt s266c5f3;
  ::S287C8_nt s266c5f4;
  ::S2121C38 s266c5f5;
  ::S287C8_nt s266c5f6;
  unsigned int s266c5f7:1;
  unsigned int s266c5f8:1;
  unsigned int s266c5f9:1;
  unsigned int s266c5f10:1;
  unsigned int s266c5f11:1;
  int s266c5f12[2];
  virtual  ~S266C5(); // _ZN6S266C5D1Ev
  virtual void  v70(); // _ZN6S266C53v70Ev
  virtual void  v71(); // _ZN6S266C53v71Ev
  virtual void  v72(); // _ZN6S266C53v72Ev
  virtual void  v73(); // _ZN6S266C53v73Ev
  virtual void  v74(); // _ZN6S266C53v74Ev
  virtual void  v75(); // _ZN6S266C53v75Ev
  virtual void  v76(); // _ZN6S266C53v76Ev
  virtual void  v77(); // _ZN6S266C53v77Ev
  virtual void  v78(); // _ZN6S266C53v78Ev
  virtual void  v79(); // _ZN6S266C53v79Ev
  virtual void  v80(); // _ZN6S266C53v80Ev
  virtual void  v81(); // _ZN6S266C53v81Ev
  virtual void  v82(); // _ZN6S266C53v82Ev
  virtual void  v83(); // _ZN6S266C53v83Ev
  virtual void  v84(); // _ZN6S266C53v84Ev
  virtual void  v85(); // _ZN6S266C53v85Ev
  virtual void  v86(); // _ZN6S266C53v86Ev
  virtual void  v87(); // _ZN6S266C53v87Ev
  virtual void  v88(); // _ZN6S266C53v88Ev
  virtual void  v89(); // _ZN6S266C53v89Ev
  virtual void  v90(); // _ZN6S266C53v90Ev
  virtual void  v91(); // _ZN6S266C53v91Ev
  S266C5(); // tgen
};
//SIG(-1 S266C5) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S266C5 ::~S266C5(){ note_dtor("S266C5", this);}
void  S266C5 ::v70(){vfunc_called(this, "_ZN6S266C53v70Ev");}
void  S266C5 ::v71(){vfunc_called(this, "_ZN6S266C53v71Ev");}
void  S266C5 ::v72(){vfunc_called(this, "_ZN6S266C53v72Ev");}
void  S266C5 ::v73(){vfunc_called(this, "_ZN6S266C53v73Ev");}
void  S266C5 ::v74(){vfunc_called(this, "_ZN6S266C53v74Ev");}
void  S266C5 ::v75(){vfunc_called(this, "_ZN6S266C53v75Ev");}
void  S266C5 ::v76(){vfunc_called(this, "_ZN6S266C53v76Ev");}
void  S266C5 ::v77(){vfunc_called(this, "_ZN6S266C53v77Ev");}
void  S266C5 ::v78(){vfunc_called(this, "_ZN6S266C53v78Ev");}
void  S266C5 ::v79(){vfunc_called(this, "_ZN6S266C53v79Ev");}
void  S266C5 ::v80(){vfunc_called(this, "_ZN6S266C53v80Ev");}
void  S266C5 ::v81(){vfunc_called(this, "_ZN6S266C53v81Ev");}
void  S266C5 ::v82(){vfunc_called(this, "_ZN6S266C53v82Ev");}
void  S266C5 ::v83(){vfunc_called(this, "_ZN6S266C53v83Ev");}
void  S266C5 ::v84(){vfunc_called(this, "_ZN6S266C53v84Ev");}
void  S266C5 ::v85(){vfunc_called(this, "_ZN6S266C53v85Ev");}
void  S266C5 ::v86(){vfunc_called(this, "_ZN6S266C53v86Ev");}
void  S266C5 ::v87(){vfunc_called(this, "_ZN6S266C53v87Ev");}
void  S266C5 ::v88(){vfunc_called(this, "_ZN6S266C53v88Ev");}
void  S266C5 ::v89(){vfunc_called(this, "_ZN6S266C53v89Ev");}
void  S266C5 ::v90(){vfunc_called(this, "_ZN6S266C53v90Ev");}
void  S266C5 ::v91(){vfunc_called(this, "_ZN6S266C53v91Ev");}
S266C5 ::S266C5(){ note_ctor("S266C5", this);} // tgen

static void Test_S266C5()
{
  extern Class_Descriptor cd_S266C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S266C5, buf);
    S266C5 *dp, &lv = *(dp=new (buf) S266C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S266C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S266C5)");
    check_base_class_offset(lv, (S266C6*), 0, "S266C5");
    check_field_offset(lv, s266c5f0, ABISELECT(96,60), "S266C5.s266c5f0");
    check_field_offset(lv, s266c5f1, ABISELECT(104,68), "S266C5.s266c5f1");
    check_field_offset(lv, s266c5f2, ABISELECT(112,72), "S266C5.s266c5f2");
    check_field_offset(lv, s266c5f3, ABISELECT(120,80), "S266C5.s266c5f3");
    check_field_offset(lv, s266c5f4, ABISELECT(136,92), "S266C5.s266c5f4");
    check_field_offset(lv, s266c5f5, ABISELECT(152,104), "S266C5.s266c5f5");
    check_field_offset(lv, s266c5f6, ABISELECT(160,108), "S266C5.s266c5f6");
    set_bf_and_test(lv, s266c5f7, ABISELECT(176,120), 0, 1, 1, "S266C5");
    set_bf_and_test(lv, s266c5f8, ABISELECT(176,120), 1, 1, 1, "S266C5");
    set_bf_and_test(lv, s266c5f9, ABISELECT(176,120), 2, 1, 1, "S266C5");
    set_bf_and_test(lv, s266c5f10, ABISELECT(176,120), 3, 1, 1, "S266C5");
    set_bf_and_test(lv, s266c5f11, ABISELECT(176,120), 4, 1, 1, "S266C5");
    check_field_offset(lv, s266c5f12, ABISELECT(180,124), "S266C5.s266c5f12");
    test_class_info(&lv, &cd_S266C5);
    dp->~S266C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS266C5(Test_S266C5, "S266C5", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN6S266C5C1Ev();
extern void _ZN6S266C5D1Ev();
Name_Map name_map_S266C5[] = {
  NSPAIR(_ZN6S266C5C1Ev),
  NSPAIR(_ZN6S266C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S266C6;
extern VTBL_ENTRY _ZTI6S266C6[];
extern  VTBL_ENTRY _ZTV6S266C6[];
static Base_Class bases_S266C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S266C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S266C5[];
extern void _ZN6S266C5D1Ev();
extern void _ZN6S266C5D0Ev();
extern void _ZN6S266C62v6Ev();
extern void _ZN6S266C62v7Ev();
extern void _ZN6S266C62v8Ev();
extern void _ZN6S266C62v9Ev();
extern void _ZN6S266C63v10Ev();
extern void _ZN6S266C63v11Ev();
extern void _ZN6S266C63v12Ev();
extern void _ZN6S266C63v13Ev();
extern void _ZN6S266C63v14Ev();
extern void _ZN6S266C63v15Ev();
extern void _ZN6S266C63v16Ev();
extern void _ZN6S266C63v17Ev();
extern void _ZN6S266C63v18Ev();
extern void _ZN6S266C63v19Ev();
extern void _ZN6S266C63v20Ev();
extern void _ZN6S266C63v21Ev();
extern void _ZN6S266C63v22Ev();
extern void _ZN6S266C63v23Ev();
extern void _ZN6S266C63v24Ev();
extern void _ZN6S266C63v25Ev();
extern void _ZN6S266C63v26Ev();
extern void _ZN6S266C63v27Ev();
extern void _ZN6S266C63v28Ev();
extern void _ZN6S266C63v29Ev();
extern void _ZN6S266C63v30Ev();
extern void _ZN6S266C63v31Ev();
extern void _ZN6S266C63v32Ev();
extern void _ZN6S266C63v33Ev();
extern void _ZN6S266C63v34Ev();
extern void _ZN6S266C63v35Ev();
extern void _ZN6S266C63v36Ev();
extern void _ZN6S266C63v37Ev();
extern void _ZN6S266C63v38Ev();
extern void _ZN6S266C63v39Ev();
extern void _ZN6S266C63v40Ev();
extern void _ZN6S266C63v41Ev();
extern void _ZN6S266C63v42Ev();
extern void _ZN6S266C63v43Ev();
extern void _ZN6S266C63v44Ev();
extern void _ZN6S266C63v45Ev();
extern void _ZN6S266C63v46Ev();
extern void _ZN6S266C63v47Ev();
extern void _ZN6S266C63v48Ev();
extern void _ZN6S266C63v49Ev();
extern void _ZN6S266C63v50Ev();
extern void _ZN6S266C63v51Ev();
extern void _ZN6S266C63v52Ev();
extern void _ZN6S266C63v53Ev();
extern void _ZN6S266C63v54Ev();
extern void _ZN6S266C63v55Ev();
extern void _ZN6S266C63v56Ev();
extern void _ZN6S266C63v57Ev();
extern void _ZN6S266C63v58Ev();
extern void _ZN6S266C63v59Ev();
extern void _ZN6S266C63v60Ev();
extern void _ZN6S266C63v61Ev();
extern void _ZN6S266C63v62Ev();
extern void _ZN6S266C63v63Ev();
extern void _ZN6S266C63v64Ev();
extern void _ZN6S266C63v65Ev();
extern void _ZN6S266C63v66Ev();
extern void _ZN6S266C63v67Ev();
extern void _ZN6S266C63v68Ev();
extern void _ZN6S266C63v69Ev();
extern void _ZN6S266C53v70Ev();
extern void _ZN6S266C53v71Ev();
extern void _ZN6S266C53v72Ev();
extern void _ZN6S266C53v73Ev();
extern void _ZN6S266C53v74Ev();
extern void _ZN6S266C53v75Ev();
extern void _ZN6S266C53v76Ev();
extern void _ZN6S266C53v77Ev();
extern void _ZN6S266C53v78Ev();
extern void _ZN6S266C53v79Ev();
extern void _ZN6S266C53v80Ev();
extern void _ZN6S266C53v81Ev();
extern void _ZN6S266C53v82Ev();
extern void _ZN6S266C53v83Ev();
extern void _ZN6S266C53v84Ev();
extern void _ZN6S266C53v85Ev();
extern void _ZN6S266C53v86Ev();
extern void _ZN6S266C53v87Ev();
extern void _ZN6S266C53v88Ev();
extern void _ZN6S266C53v89Ev();
extern void _ZN6S266C53v90Ev();
extern void _ZN6S266C53v91Ev();
static  VTBL_ENTRY vtc_S266C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S266C5[0]),
  (VTBL_ENTRY)&_ZN6S266C5D1Ev,
  (VTBL_ENTRY)&_ZN6S266C5D0Ev,
  (VTBL_ENTRY)&_ZN6S266C62v6Ev,
  (VTBL_ENTRY)&_ZN6S266C62v7Ev,
  (VTBL_ENTRY)&_ZN6S266C62v8Ev,
  (VTBL_ENTRY)&_ZN6S266C62v9Ev,
  (VTBL_ENTRY)&_ZN6S266C63v10Ev,
  (VTBL_ENTRY)&_ZN6S266C63v11Ev,
  (VTBL_ENTRY)&_ZN6S266C63v12Ev,
  (VTBL_ENTRY)&_ZN6S266C63v13Ev,
  (VTBL_ENTRY)&_ZN6S266C63v14Ev,
  (VTBL_ENTRY)&_ZN6S266C63v15Ev,
  (VTBL_ENTRY)&_ZN6S266C63v16Ev,
  (VTBL_ENTRY)&_ZN6S266C63v17Ev,
  (VTBL_ENTRY)&_ZN6S266C63v18Ev,
  (VTBL_ENTRY)&_ZN6S266C63v19Ev,
  (VTBL_ENTRY)&_ZN6S266C63v20Ev,
  (VTBL_ENTRY)&_ZN6S266C63v21Ev,
  (VTBL_ENTRY)&_ZN6S266C63v22Ev,
  (VTBL_ENTRY)&_ZN6S266C63v23Ev,
  (VTBL_ENTRY)&_ZN6S266C63v24Ev,
  (VTBL_ENTRY)&_ZN6S266C63v25Ev,
  (VTBL_ENTRY)&_ZN6S266C63v26Ev,
  (VTBL_ENTRY)&_ZN6S266C63v27Ev,
  (VTBL_ENTRY)&_ZN6S266C63v28Ev,
  (VTBL_ENTRY)&_ZN6S266C63v29Ev,
  (VTBL_ENTRY)&_ZN6S266C63v30Ev,
  (VTBL_ENTRY)&_ZN6S266C63v31Ev,
  (VTBL_ENTRY)&_ZN6S266C63v32Ev,
  (VTBL_ENTRY)&_ZN6S266C63v33Ev,
  (VTBL_ENTRY)&_ZN6S266C63v34Ev,
  (VTBL_ENTRY)&_ZN6S266C63v35Ev,
  (VTBL_ENTRY)&_ZN6S266C63v36Ev,
  (VTBL_ENTRY)&_ZN6S266C63v37Ev,
  (VTBL_ENTRY)&_ZN6S266C63v38Ev,
  (VTBL_ENTRY)&_ZN6S266C63v39Ev,
  (VTBL_ENTRY)&_ZN6S266C63v40Ev,
  (VTBL_ENTRY)&_ZN6S266C63v41Ev,
  (VTBL_ENTRY)&_ZN6S266C63v42Ev,
  (VTBL_ENTRY)&_ZN6S266C63v43Ev,
  (VTBL_ENTRY)&_ZN6S266C63v44Ev,
  (VTBL_ENTRY)&_ZN6S266C63v45Ev,
  (VTBL_ENTRY)&_ZN6S266C63v46Ev,
  (VTBL_ENTRY)&_ZN6S266C63v47Ev,
  (VTBL_ENTRY)&_ZN6S266C63v48Ev,
  (VTBL_ENTRY)&_ZN6S266C63v49Ev,
  (VTBL_ENTRY)&_ZN6S266C63v50Ev,
  (VTBL_ENTRY)&_ZN6S266C63v51Ev,
  (VTBL_ENTRY)&_ZN6S266C63v52Ev,
  (VTBL_ENTRY)&_ZN6S266C63v53Ev,
  (VTBL_ENTRY)&_ZN6S266C63v54Ev,
  (VTBL_ENTRY)&_ZN6S266C63v55Ev,
  (VTBL_ENTRY)&_ZN6S266C63v56Ev,
  (VTBL_ENTRY)&_ZN6S266C63v57Ev,
  (VTBL_ENTRY)&_ZN6S266C63v58Ev,
  (VTBL_ENTRY)&_ZN6S266C63v59Ev,
  (VTBL_ENTRY)&_ZN6S266C63v60Ev,
  (VTBL_ENTRY)&_ZN6S266C63v61Ev,
  (VTBL_ENTRY)&_ZN6S266C63v62Ev,
  (VTBL_ENTRY)&_ZN6S266C63v63Ev,
  (VTBL_ENTRY)&_ZN6S266C63v64Ev,
  (VTBL_ENTRY)&_ZN6S266C63v65Ev,
  (VTBL_ENTRY)&_ZN6S266C63v66Ev,
  (VTBL_ENTRY)&_ZN6S266C63v67Ev,
  (VTBL_ENTRY)&_ZN6S266C63v68Ev,
  (VTBL_ENTRY)&_ZN6S266C63v69Ev,
  (VTBL_ENTRY)&_ZN6S266C53v70Ev,
  (VTBL_ENTRY)&_ZN6S266C53v71Ev,
  (VTBL_ENTRY)&_ZN6S266C53v72Ev,
  (VTBL_ENTRY)&_ZN6S266C53v73Ev,
  (VTBL_ENTRY)&_ZN6S266C53v74Ev,
  (VTBL_ENTRY)&_ZN6S266C53v75Ev,
  (VTBL_ENTRY)&_ZN6S266C53v76Ev,
  (VTBL_ENTRY)&_ZN6S266C53v77Ev,
  (VTBL_ENTRY)&_ZN6S266C53v78Ev,
  (VTBL_ENTRY)&_ZN6S266C53v79Ev,
  (VTBL_ENTRY)&_ZN6S266C53v80Ev,
  (VTBL_ENTRY)&_ZN6S266C53v81Ev,
  (VTBL_ENTRY)&_ZN6S266C53v82Ev,
  (VTBL_ENTRY)&_ZN6S266C53v83Ev,
  (VTBL_ENTRY)&_ZN6S266C53v84Ev,
  (VTBL_ENTRY)&_ZN6S266C53v85Ev,
  (VTBL_ENTRY)&_ZN6S266C53v86Ev,
  (VTBL_ENTRY)&_ZN6S266C53v87Ev,
  (VTBL_ENTRY)&_ZN6S266C53v88Ev,
  (VTBL_ENTRY)&_ZN6S266C53v89Ev,
  (VTBL_ENTRY)&_ZN6S266C53v90Ev,
  (VTBL_ENTRY)&_ZN6S266C53v91Ev,
};
extern VTBL_ENTRY _ZTI6S266C5[];
extern  VTBL_ENTRY _ZTV6S266C5[];
Class_Descriptor cd_S266C5 = {  "S266C5", // class name
  bases_S266C5, 1,
  &(vtc_S266C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI6S266C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S266C5),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S266C4  : S266C5 {
  unsigned int s266c4f0:1;
  unsigned int s266c4f1:1;
  unsigned int s266c4f2:1;
  ::S3350C17 s266c4f3;
  ::S3350C11 s266c4f4;
  ::S3350C5_nt s266c4f5;
  ::S287C27 s266c4f6;
  int s266c4f7[3];
  virtual  ~S266C4(); // _ZN6S266C4D1Ev
  virtual void  v92(); // _ZN6S266C43v92Ev
  virtual void  v93(); // _ZN6S266C43v93Ev
  virtual void  v94(); // _ZN6S266C43v94Ev
  virtual void  v95(); // _ZN6S266C43v95Ev
  virtual void  v96(); // _ZN6S266C43v96Ev
  virtual void  v97(); // _ZN6S266C43v97Ev
  virtual void  v98(); // _ZN6S266C43v98Ev
  virtual void  v99(); // _ZN6S266C43v99Ev
  virtual void  v100(); // _ZN6S266C44v100Ev
  virtual void  v101(); // _ZN6S266C44v101Ev
  virtual void  v102(); // _ZN6S266C44v102Ev
  virtual void  v103(); // _ZN6S266C44v103Ev
  virtual void  v104(); // _ZN6S266C44v104Ev
  virtual void  v105(); // _ZN6S266C44v105Ev
  virtual void  v106(); // _ZN6S266C44v106Ev
  virtual void  v107(); // _ZN6S266C44v107Ev
  virtual void  v108(); // _ZN6S266C44v108Ev
  virtual void  v109(); // _ZN6S266C44v109Ev
  virtual void  v110(); // _ZN6S266C44v110Ev
  virtual void  v111(); // _ZN6S266C44v111Ev
  S266C4(); // tgen
};
//SIG(-1 S266C4) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} FC16{ BC17{ BC8}} Fi[3]}


 S266C4 ::~S266C4(){ note_dtor("S266C4", this);}
void  S266C4 ::v92(){vfunc_called(this, "_ZN6S266C43v92Ev");}
void  S266C4 ::v93(){vfunc_called(this, "_ZN6S266C43v93Ev");}
void  S266C4 ::v94(){vfunc_called(this, "_ZN6S266C43v94Ev");}
void  S266C4 ::v95(){vfunc_called(this, "_ZN6S266C43v95Ev");}
void  S266C4 ::v96(){vfunc_called(this, "_ZN6S266C43v96Ev");}
void  S266C4 ::v97(){vfunc_called(this, "_ZN6S266C43v97Ev");}
void  S266C4 ::v98(){vfunc_called(this, "_ZN6S266C43v98Ev");}
void  S266C4 ::v99(){vfunc_called(this, "_ZN6S266C43v99Ev");}
void  S266C4 ::v100(){vfunc_called(this, "_ZN6S266C44v100Ev");}
void  S266C4 ::v101(){vfunc_called(this, "_ZN6S266C44v101Ev");}
void  S266C4 ::v102(){vfunc_called(this, "_ZN6S266C44v102Ev");}
void  S266C4 ::v103(){vfunc_called(this, "_ZN6S266C44v103Ev");}
void  S266C4 ::v104(){vfunc_called(this, "_ZN6S266C44v104Ev");}
void  S266C4 ::v105(){vfunc_called(this, "_ZN6S266C44v105Ev");}
void  S266C4 ::v106(){vfunc_called(this, "_ZN6S266C44v106Ev");}
void  S266C4 ::v107(){vfunc_called(this, "_ZN6S266C44v107Ev");}
void  S266C4 ::v108(){vfunc_called(this, "_ZN6S266C44v108Ev");}
void  S266C4 ::v109(){vfunc_called(this, "_ZN6S266C44v109Ev");}
void  S266C4 ::v110(){vfunc_called(this, "_ZN6S266C44v110Ev");}
void  S266C4 ::v111(){vfunc_called(this, "_ZN6S266C44v111Ev");}
S266C4 ::S266C4(){ note_ctor("S266C4", this);} // tgen

static void Test_S266C4()
{
  extern Class_Descriptor cd_S266C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(35,50)];
    init_test(&cd_S266C4, buf);
    S266C4 *dp, &lv = *(dp=new (buf) S266C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,196), "sizeof(S266C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S266C4)");
    check_base_class_offset(lv, (S266C6*)(S266C5*), 0, "S266C4");
    check_base_class_offset(lv, (S266C5*), 0, "S266C4");
    set_bf_and_test(lv, s266c4f0, ABISELECT(188,132), 0, 1, 1, "S266C4");
    set_bf_and_test(lv, s266c4f1, ABISELECT(188,132), 1, 1, 1, "S266C4");
    set_bf_and_test(lv, s266c4f2, ABISELECT(188,132), 2, 1, 1, "S266C4");
    check_field_offset(lv, s266c4f3, ABISELECT(192,136), "S266C4.s266c4f3");
    check_field_offset(lv, s266c4f4, ABISELECT(208,148), "S266C4.s266c4f4");
    check_field_offset(lv, s266c4f5, ABISELECT(224,160), "S266C4.s266c4f5");
    check_field_offset(lv, s266c4f6, ABISELECT(240,172), "S266C4.s266c4f6");
    check_field_offset(lv, s266c4f7, ABISELECT(256,184), "S266C4.s266c4f7");
    test_class_info(&lv, &cd_S266C4);
    dp->~S266C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS266C4(Test_S266C4, "S266C4", ABISELECT(272,196));

#else // __cplusplus

extern void _ZN6S266C4C1Ev();
extern void _ZN6S266C4D1Ev();
Name_Map name_map_S266C4[] = {
  NSPAIR(_ZN6S266C4C1Ev),
  NSPAIR(_ZN6S266C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S266C6;
extern VTBL_ENTRY _ZTI6S266C6[];
extern  VTBL_ENTRY _ZTV6S266C6[];
extern Class_Descriptor cd_S266C5;
extern VTBL_ENTRY _ZTI6S266C5[];
extern  VTBL_ENTRY _ZTV6S266C5[];
static Base_Class bases_S266C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S266C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S266C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S266C4[];
extern void _ZN6S266C4D1Ev();
extern void _ZN6S266C4D0Ev();
extern void _ZN6S266C62v6Ev();
extern void _ZN6S266C62v7Ev();
extern void _ZN6S266C62v8Ev();
extern void _ZN6S266C62v9Ev();
extern void _ZN6S266C63v10Ev();
extern void _ZN6S266C63v11Ev();
extern void _ZN6S266C63v12Ev();
extern void _ZN6S266C63v13Ev();
extern void _ZN6S266C63v14Ev();
extern void _ZN6S266C63v15Ev();
extern void _ZN6S266C63v16Ev();
extern void _ZN6S266C63v17Ev();
extern void _ZN6S266C63v18Ev();
extern void _ZN6S266C63v19Ev();
extern void _ZN6S266C63v20Ev();
extern void _ZN6S266C63v21Ev();
extern void _ZN6S266C63v22Ev();
extern void _ZN6S266C63v23Ev();
extern void _ZN6S266C63v24Ev();
extern void _ZN6S266C63v25Ev();
extern void _ZN6S266C63v26Ev();
extern void _ZN6S266C63v27Ev();
extern void _ZN6S266C63v28Ev();
extern void _ZN6S266C63v29Ev();
extern void _ZN6S266C63v30Ev();
extern void _ZN6S266C63v31Ev();
extern void _ZN6S266C63v32Ev();
extern void _ZN6S266C63v33Ev();
extern void _ZN6S266C63v34Ev();
extern void _ZN6S266C63v35Ev();
extern void _ZN6S266C63v36Ev();
extern void _ZN6S266C63v37Ev();
extern void _ZN6S266C63v38Ev();
extern void _ZN6S266C63v39Ev();
extern void _ZN6S266C63v40Ev();
extern void _ZN6S266C63v41Ev();
extern void _ZN6S266C63v42Ev();
extern void _ZN6S266C63v43Ev();
extern void _ZN6S266C63v44Ev();
extern void _ZN6S266C63v45Ev();
extern void _ZN6S266C63v46Ev();
extern void _ZN6S266C63v47Ev();
extern void _ZN6S266C63v48Ev();
extern void _ZN6S266C63v49Ev();
extern void _ZN6S266C63v50Ev();
extern void _ZN6S266C63v51Ev();
extern void _ZN6S266C63v52Ev();
extern void _ZN6S266C63v53Ev();
extern void _ZN6S266C63v54Ev();
extern void _ZN6S266C63v55Ev();
extern void _ZN6S266C63v56Ev();
extern void _ZN6S266C63v57Ev();
extern void _ZN6S266C63v58Ev();
extern void _ZN6S266C63v59Ev();
extern void _ZN6S266C63v60Ev();
extern void _ZN6S266C63v61Ev();
extern void _ZN6S266C63v62Ev();
extern void _ZN6S266C63v63Ev();
extern void _ZN6S266C63v64Ev();
extern void _ZN6S266C63v65Ev();
extern void _ZN6S266C63v66Ev();
extern void _ZN6S266C63v67Ev();
extern void _ZN6S266C63v68Ev();
extern void _ZN6S266C63v69Ev();
extern void _ZN6S266C53v70Ev();
extern void _ZN6S266C53v71Ev();
extern void _ZN6S266C53v72Ev();
extern void _ZN6S266C53v73Ev();
extern void _ZN6S266C53v74Ev();
extern void _ZN6S266C53v75Ev();
extern void _ZN6S266C53v76Ev();
extern void _ZN6S266C53v77Ev();
extern void _ZN6S266C53v78Ev();
extern void _ZN6S266C53v79Ev();
extern void _ZN6S266C53v80Ev();
extern void _ZN6S266C53v81Ev();
extern void _ZN6S266C53v82Ev();
extern void _ZN6S266C53v83Ev();
extern void _ZN6S266C53v84Ev();
extern void _ZN6S266C53v85Ev();
extern void _ZN6S266C53v86Ev();
extern void _ZN6S266C53v87Ev();
extern void _ZN6S266C53v88Ev();
extern void _ZN6S266C53v89Ev();
extern void _ZN6S266C53v90Ev();
extern void _ZN6S266C53v91Ev();
extern void _ZN6S266C43v92Ev();
extern void _ZN6S266C43v93Ev();
extern void _ZN6S266C43v94Ev();
extern void _ZN6S266C43v95Ev();
extern void _ZN6S266C43v96Ev();
extern void _ZN6S266C43v97Ev();
extern void _ZN6S266C43v98Ev();
extern void _ZN6S266C43v99Ev();
extern void _ZN6S266C44v100Ev();
extern void _ZN6S266C44v101Ev();
extern void _ZN6S266C44v102Ev();
extern void _ZN6S266C44v103Ev();
extern void _ZN6S266C44v104Ev();
extern void _ZN6S266C44v105Ev();
extern void _ZN6S266C44v106Ev();
extern void _ZN6S266C44v107Ev();
extern void _ZN6S266C44v108Ev();
extern void _ZN6S266C44v109Ev();
extern void _ZN6S266C44v110Ev();
extern void _ZN6S266C44v111Ev();
static  VTBL_ENTRY vtc_S266C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S266C4[0]),
  (VTBL_ENTRY)&_ZN6S266C4D1Ev,
  (VTBL_ENTRY)&_ZN6S266C4D0Ev,
  (VTBL_ENTRY)&_ZN6S266C62v6Ev,
  (VTBL_ENTRY)&_ZN6S266C62v7Ev,
  (VTBL_ENTRY)&_ZN6S266C62v8Ev,
  (VTBL_ENTRY)&_ZN6S266C62v9Ev,
  (VTBL_ENTRY)&_ZN6S266C63v10Ev,
  (VTBL_ENTRY)&_ZN6S266C63v11Ev,
  (VTBL_ENTRY)&_ZN6S266C63v12Ev,
  (VTBL_ENTRY)&_ZN6S266C63v13Ev,
  (VTBL_ENTRY)&_ZN6S266C63v14Ev,
  (VTBL_ENTRY)&_ZN6S266C63v15Ev,
  (VTBL_ENTRY)&_ZN6S266C63v16Ev,
  (VTBL_ENTRY)&_ZN6S266C63v17Ev,
  (VTBL_ENTRY)&_ZN6S266C63v18Ev,
  (VTBL_ENTRY)&_ZN6S266C63v19Ev,
  (VTBL_ENTRY)&_ZN6S266C63v20Ev,
  (VTBL_ENTRY)&_ZN6S266C63v21Ev,
  (VTBL_ENTRY)&_ZN6S266C63v22Ev,
  (VTBL_ENTRY)&_ZN6S266C63v23Ev,
  (VTBL_ENTRY)&_ZN6S266C63v24Ev,
  (VTBL_ENTRY)&_ZN6S266C63v25Ev,
  (VTBL_ENTRY)&_ZN6S266C63v26Ev,
  (VTBL_ENTRY)&_ZN6S266C63v27Ev,
  (VTBL_ENTRY)&_ZN6S266C63v28Ev,
  (VTBL_ENTRY)&_ZN6S266C63v29Ev,
  (VTBL_ENTRY)&_ZN6S266C63v30Ev,
  (VTBL_ENTRY)&_ZN6S266C63v31Ev,
  (VTBL_ENTRY)&_ZN6S266C63v32Ev,
  (VTBL_ENTRY)&_ZN6S266C63v33Ev,
  (VTBL_ENTRY)&_ZN6S266C63v34Ev,
  (VTBL_ENTRY)&_ZN6S266C63v35Ev,
  (VTBL_ENTRY)&_ZN6S266C63v36Ev,
  (VTBL_ENTRY)&_ZN6S266C63v37Ev,
  (VTBL_ENTRY)&_ZN6S266C63v38Ev,
  (VTBL_ENTRY)&_ZN6S266C63v39Ev,
  (VTBL_ENTRY)&_ZN6S266C63v40Ev,
  (VTBL_ENTRY)&_ZN6S266C63v41Ev,
  (VTBL_ENTRY)&_ZN6S266C63v42Ev,
  (VTBL_ENTRY)&_ZN6S266C63v43Ev,
  (VTBL_ENTRY)&_ZN6S266C63v44Ev,
  (VTBL_ENTRY)&_ZN6S266C63v45Ev,
  (VTBL_ENTRY)&_ZN6S266C63v46Ev,
  (VTBL_ENTRY)&_ZN6S266C63v47Ev,
  (VTBL_ENTRY)&_ZN6S266C63v48Ev,
  (VTBL_ENTRY)&_ZN6S266C63v49Ev,
  (VTBL_ENTRY)&_ZN6S266C63v50Ev,
  (VTBL_ENTRY)&_ZN6S266C63v51Ev,
  (VTBL_ENTRY)&_ZN6S266C63v52Ev,
  (VTBL_ENTRY)&_ZN6S266C63v53Ev,
  (VTBL_ENTRY)&_ZN6S266C63v54Ev,
  (VTBL_ENTRY)&_ZN6S266C63v55Ev,
  (VTBL_ENTRY)&_ZN6S266C63v56Ev,
  (VTBL_ENTRY)&_ZN6S266C63v57Ev,
  (VTBL_ENTRY)&_ZN6S266C63v58Ev,
  (VTBL_ENTRY)&_ZN6S266C63v59Ev,
  (VTBL_ENTRY)&_ZN6S266C63v60Ev,
  (VTBL_ENTRY)&_ZN6S266C63v61Ev,
  (VTBL_ENTRY)&_ZN6S266C63v62Ev,
  (VTBL_ENTRY)&_ZN6S266C63v63Ev,
  (VTBL_ENTRY)&_ZN6S266C63v64Ev,
  (VTBL_ENTRY)&_ZN6S266C63v65Ev,
  (VTBL_ENTRY)&_ZN6S266C63v66Ev,
  (VTBL_ENTRY)&_ZN6S266C63v67Ev,
  (VTBL_ENTRY)&_ZN6S266C63v68Ev,
  (VTBL_ENTRY)&_ZN6S266C63v69Ev,
  (VTBL_ENTRY)&_ZN6S266C53v70Ev,
  (VTBL_ENTRY)&_ZN6S266C53v71Ev,
  (VTBL_ENTRY)&_ZN6S266C53v72Ev,
  (VTBL_ENTRY)&_ZN6S266C53v73Ev,
  (VTBL_ENTRY)&_ZN6S266C53v74Ev,
  (VTBL_ENTRY)&_ZN6S266C53v75Ev,
  (VTBL_ENTRY)&_ZN6S266C53v76Ev,
  (VTBL_ENTRY)&_ZN6S266C53v77Ev,
  (VTBL_ENTRY)&_ZN6S266C53v78Ev,
  (VTBL_ENTRY)&_ZN6S266C53v79Ev,
  (VTBL_ENTRY)&_ZN6S266C53v80Ev,
  (VTBL_ENTRY)&_ZN6S266C53v81Ev,
  (VTBL_ENTRY)&_ZN6S266C53v82Ev,
  (VTBL_ENTRY)&_ZN6S266C53v83Ev,
  (VTBL_ENTRY)&_ZN6S266C53v84Ev,
  (VTBL_ENTRY)&_ZN6S266C53v85Ev,
  (VTBL_ENTRY)&_ZN6S266C53v86Ev,
  (VTBL_ENTRY)&_ZN6S266C53v87Ev,
  (VTBL_ENTRY)&_ZN6S266C53v88Ev,
  (VTBL_ENTRY)&_ZN6S266C53v89Ev,
  (VTBL_ENTRY)&_ZN6S266C53v90Ev,
  (VTBL_ENTRY)&_ZN6S266C53v91Ev,
  (VTBL_ENTRY)&_ZN6S266C43v92Ev,
  (VTBL_ENTRY)&_ZN6S266C43v93Ev,
  (VTBL_ENTRY)&_ZN6S266C43v94Ev,
  (VTBL_ENTRY)&_ZN6S266C43v95Ev,
  (VTBL_ENTRY)&_ZN6S266C43v96Ev,
  (VTBL_ENTRY)&_ZN6S266C43v97Ev,
  (VTBL_ENTRY)&_ZN6S266C43v98Ev,
  (VTBL_ENTRY)&_ZN6S266C43v99Ev,
  (VTBL_ENTRY)&_ZN6S266C44v100Ev,
  (VTBL_ENTRY)&_ZN6S266C44v101Ev,
  (VTBL_ENTRY)&_ZN6S266C44v102Ev,
  (VTBL_ENTRY)&_ZN6S266C44v103Ev,
  (VTBL_ENTRY)&_ZN6S266C44v104Ev,
  (VTBL_ENTRY)&_ZN6S266C44v105Ev,
  (VTBL_ENTRY)&_ZN6S266C44v106Ev,
  (VTBL_ENTRY)&_ZN6S266C44v107Ev,
  (VTBL_ENTRY)&_ZN6S266C44v108Ev,
  (VTBL_ENTRY)&_ZN6S266C44v109Ev,
  (VTBL_ENTRY)&_ZN6S266C44v110Ev,
  (VTBL_ENTRY)&_ZN6S266C44v111Ev,
};
extern VTBL_ENTRY _ZTI6S266C4[];
extern  VTBL_ENTRY _ZTV6S266C4[];
Class_Descriptor cd_S266C4 = {  "S266C4", // class name
  bases_S266C4, 2,
  &(vtc_S266C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI6S266C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S266C4),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S266C3  : S266C4 {
  void *s266c3f0[2];
  int s266c3f1[4];
  unsigned int s266c3f2:1;
  unsigned int s266c3f3:1;
  unsigned int s266c3f4:1;
  char s266c3f5;
  int s266c3f6;
  unsigned int s266c3f7:1;
  ::S287C23 s266c3f8;
  virtual  ~S266C3(); // _ZN6S266C3D1Ev
  virtual void  v112(); // _ZN6S266C34v112Ev
  virtual void  v113(); // _ZN6S266C34v113Ev
  virtual void  v114(); // _ZN6S266C34v114Ev
  virtual void  v115(); // _ZN6S266C34v115Ev
  virtual void  v116(); // _ZN6S266C34v116Ev
  virtual void  v117(); // _ZN6S266C34v117Ev
  virtual void  v118(); // _ZN6S266C34v118Ev
  virtual void  v119(); // _ZN6S266C34v119Ev
  virtual void  v120(); // _ZN6S266C34v120Ev
  virtual void  v121(); // _ZN6S266C34v121Ev
  virtual void  v122(); // _ZN6S266C34v122Ev
  virtual void  v123(); // _ZN6S266C34v123Ev
  virtual void  v124(); // _ZN6S266C34v124Ev
  virtual void  v125(); // _ZN6S266C34v125Ev
  S266C3(); // tgen
};
//SIG(-1 S266C3) C1{ BC2{ BC3{ BC4{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} FC17{ BC18{ BC9}} Fi[3]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] Fi[4] Fi:1 Fi:1 Fi:1 Fc Fi Fi:1 FC19{ BC20{ BC9}}}


 S266C3 ::~S266C3(){ note_dtor("S266C3", this);}
void  S266C3 ::v112(){vfunc_called(this, "_ZN6S266C34v112Ev");}
void  S266C3 ::v113(){vfunc_called(this, "_ZN6S266C34v113Ev");}
void  S266C3 ::v114(){vfunc_called(this, "_ZN6S266C34v114Ev");}
void  S266C3 ::v115(){vfunc_called(this, "_ZN6S266C34v115Ev");}
void  S266C3 ::v116(){vfunc_called(this, "_ZN6S266C34v116Ev");}
void  S266C3 ::v117(){vfunc_called(this, "_ZN6S266C34v117Ev");}
void  S266C3 ::v118(){vfunc_called(this, "_ZN6S266C34v118Ev");}
void  S266C3 ::v119(){vfunc_called(this, "_ZN6S266C34v119Ev");}
void  S266C3 ::v120(){vfunc_called(this, "_ZN6S266C34v120Ev");}
void  S266C3 ::v121(){vfunc_called(this, "_ZN6S266C34v121Ev");}
void  S266C3 ::v122(){vfunc_called(this, "_ZN6S266C34v122Ev");}
void  S266C3 ::v123(){vfunc_called(this, "_ZN6S266C34v123Ev");}
void  S266C3 ::v124(){vfunc_called(this, "_ZN6S266C34v124Ev");}
void  S266C3 ::v125(){vfunc_called(this, "_ZN6S266C34v125Ev");}
S266C3 ::S266C3(){ note_ctor("S266C3", this);} // tgen

static void Test_S266C3()
{
  extern Class_Descriptor cd_S266C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(43,62)];
    init_test(&cd_S266C3, buf);
    S266C3 *dp, &lv = *(dp=new (buf) S266C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(336,244), "sizeof(S266C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S266C3)");
    check_base_class_offset(lv, (S266C6*)(S266C5*)(S266C4*), 0, "S266C3");
    check_base_class_offset(lv, (S266C5*)(S266C4*), 0, "S266C3");
    check_base_class_offset(lv, (S266C4*), 0, "S266C3");
    check_field_offset(lv, s266c3f0, ABISELECT(272,196), "S266C3.s266c3f0");
    check_field_offset(lv, s266c3f1, ABISELECT(288,204), "S266C3.s266c3f1");
    set_bf_and_test(lv, s266c3f2, ABISELECT(304,220), 0, 1, 1, "S266C3");
    set_bf_and_test(lv, s266c3f3, ABISELECT(304,220), 1, 1, 1, "S266C3");
    set_bf_and_test(lv, s266c3f4, ABISELECT(304,220), 2, 1, 1, "S266C3");
    check_field_offset(lv, s266c3f5, ABISELECT(305,221), "S266C3.s266c3f5");
    check_field_offset(lv, s266c3f6, ABISELECT(308,224), "S266C3.s266c3f6");
    set_bf_and_test(lv, s266c3f7, ABISELECT(312,228), 0, 1, 1, "S266C3");
    check_field_offset(lv, s266c3f8, ABISELECT(320,232), "S266C3.s266c3f8");
    test_class_info(&lv, &cd_S266C3);
    dp->~S266C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS266C3(Test_S266C3, "S266C3", ABISELECT(336,244));

#else // __cplusplus

extern void _ZN6S266C3C1Ev();
extern void _ZN6S266C3D1Ev();
Name_Map name_map_S266C3[] = {
  NSPAIR(_ZN6S266C3C1Ev),
  NSPAIR(_ZN6S266C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S266C6;
extern VTBL_ENTRY _ZTI6S266C6[];
extern  VTBL_ENTRY _ZTV6S266C6[];
extern Class_Descriptor cd_S266C5;
extern VTBL_ENTRY _ZTI6S266C5[];
extern  VTBL_ENTRY _ZTV6S266C5[];
extern Class_Descriptor cd_S266C4;
extern VTBL_ENTRY _ZTI6S266C4[];
extern  VTBL_ENTRY _ZTV6S266C4[];
static Base_Class bases_S266C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S266C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S266C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S266C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S266C3[];
extern void _ZN6S266C3D1Ev();
extern void _ZN6S266C3D0Ev();
extern void _ZN6S266C62v6Ev();
extern void _ZN6S266C62v7Ev();
extern void _ZN6S266C62v8Ev();
extern void _ZN6S266C62v9Ev();
extern void _ZN6S266C63v10Ev();
extern void _ZN6S266C63v11Ev();
extern void _ZN6S266C63v12Ev();
extern void _ZN6S266C63v13Ev();
extern void _ZN6S266C63v14Ev();
extern void _ZN6S266C63v15Ev();
extern void _ZN6S266C63v16Ev();
extern void _ZN6S266C63v17Ev();
extern void _ZN6S266C63v18Ev();
extern void _ZN6S266C63v19Ev();
extern void _ZN6S266C63v20Ev();
extern void _ZN6S266C63v21Ev();
extern void _ZN6S266C63v22Ev();
extern void _ZN6S266C63v23Ev();
extern void _ZN6S266C63v24Ev();
extern void _ZN6S266C63v25Ev();
extern void _ZN6S266C63v26Ev();
extern void _ZN6S266C63v27Ev();
extern void _ZN6S266C63v28Ev();
extern void _ZN6S266C63v29Ev();
extern void _ZN6S266C63v30Ev();
extern void _ZN6S266C63v31Ev();
extern void _ZN6S266C63v32Ev();
extern void _ZN6S266C63v33Ev();
extern void _ZN6S266C63v34Ev();
extern void _ZN6S266C63v35Ev();
extern void _ZN6S266C63v36Ev();
extern void _ZN6S266C63v37Ev();
extern void _ZN6S266C63v38Ev();
extern void _ZN6S266C63v39Ev();
extern void _ZN6S266C63v40Ev();
extern void _ZN6S266C63v41Ev();
extern void _ZN6S266C63v42Ev();
extern void _ZN6S266C63v43Ev();
extern void _ZN6S266C63v44Ev();
extern void _ZN6S266C63v45Ev();
extern void _ZN6S266C63v46Ev();
extern void _ZN6S266C63v47Ev();
extern void _ZN6S266C63v48Ev();
extern void _ZN6S266C63v49Ev();
extern void _ZN6S266C63v50Ev();
extern void _ZN6S266C63v51Ev();
extern void _ZN6S266C63v52Ev();
extern void _ZN6S266C63v53Ev();
extern void _ZN6S266C63v54Ev();
extern void _ZN6S266C63v55Ev();
extern void _ZN6S266C63v56Ev();
extern void _ZN6S266C63v57Ev();
extern void _ZN6S266C63v58Ev();
extern void _ZN6S266C63v59Ev();
extern void _ZN6S266C63v60Ev();
extern void _ZN6S266C63v61Ev();
extern void _ZN6S266C63v62Ev();
extern void _ZN6S266C63v63Ev();
extern void _ZN6S266C63v64Ev();
extern void _ZN6S266C63v65Ev();
extern void _ZN6S266C63v66Ev();
extern void _ZN6S266C63v67Ev();
extern void _ZN6S266C63v68Ev();
extern void _ZN6S266C63v69Ev();
extern void _ZN6S266C53v70Ev();
extern void _ZN6S266C53v71Ev();
extern void _ZN6S266C53v72Ev();
extern void _ZN6S266C53v73Ev();
extern void _ZN6S266C53v74Ev();
extern void _ZN6S266C53v75Ev();
extern void _ZN6S266C53v76Ev();
extern void _ZN6S266C53v77Ev();
extern void _ZN6S266C53v78Ev();
extern void _ZN6S266C53v79Ev();
extern void _ZN6S266C53v80Ev();
extern void _ZN6S266C53v81Ev();
extern void _ZN6S266C53v82Ev();
extern void _ZN6S266C53v83Ev();
extern void _ZN6S266C53v84Ev();
extern void _ZN6S266C53v85Ev();
extern void _ZN6S266C53v86Ev();
extern void _ZN6S266C53v87Ev();
extern void _ZN6S266C53v88Ev();
extern void _ZN6S266C53v89Ev();
extern void _ZN6S266C53v90Ev();
extern void _ZN6S266C53v91Ev();
extern void _ZN6S266C43v92Ev();
extern void _ZN6S266C43v93Ev();
extern void _ZN6S266C43v94Ev();
extern void _ZN6S266C43v95Ev();
extern void _ZN6S266C43v96Ev();
extern void _ZN6S266C43v97Ev();
extern void _ZN6S266C43v98Ev();
extern void _ZN6S266C43v99Ev();
extern void _ZN6S266C44v100Ev();
extern void _ZN6S266C44v101Ev();
extern void _ZN6S266C44v102Ev();
extern void _ZN6S266C44v103Ev();
extern void _ZN6S266C44v104Ev();
extern void _ZN6S266C44v105Ev();
extern void _ZN6S266C44v106Ev();
extern void _ZN6S266C44v107Ev();
extern void _ZN6S266C44v108Ev();
extern void _ZN6S266C44v109Ev();
extern void _ZN6S266C44v110Ev();
extern void _ZN6S266C44v111Ev();
extern void _ZN6S266C34v112Ev();
extern void _ZN6S266C34v113Ev();
extern void _ZN6S266C34v114Ev();
extern void _ZN6S266C34v115Ev();
extern void _ZN6S266C34v116Ev();
extern void _ZN6S266C34v117Ev();
extern void _ZN6S266C34v118Ev();
extern void _ZN6S266C34v119Ev();
extern void _ZN6S266C34v120Ev();
extern void _ZN6S266C34v121Ev();
extern void _ZN6S266C34v122Ev();
extern void _ZN6S266C34v123Ev();
extern void _ZN6S266C34v124Ev();
extern void _ZN6S266C34v125Ev();
static  VTBL_ENTRY vtc_S266C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S266C3[0]),
  (VTBL_ENTRY)&_ZN6S266C3D1Ev,
  (VTBL_ENTRY)&_ZN6S266C3D0Ev,
  (VTBL_ENTRY)&_ZN6S266C62v6Ev,
  (VTBL_ENTRY)&_ZN6S266C62v7Ev,
  (VTBL_ENTRY)&_ZN6S266C62v8Ev,
  (VTBL_ENTRY)&_ZN6S266C62v9Ev,
  (VTBL_ENTRY)&_ZN6S266C63v10Ev,
  (VTBL_ENTRY)&_ZN6S266C63v11Ev,
  (VTBL_ENTRY)&_ZN6S266C63v12Ev,
  (VTBL_ENTRY)&_ZN6S266C63v13Ev,
  (VTBL_ENTRY)&_ZN6S266C63v14Ev,
  (VTBL_ENTRY)&_ZN6S266C63v15Ev,
  (VTBL_ENTRY)&_ZN6S266C63v16Ev,
  (VTBL_ENTRY)&_ZN6S266C63v17Ev,
  (VTBL_ENTRY)&_ZN6S266C63v18Ev,
  (VTBL_ENTRY)&_ZN6S266C63v19Ev,
  (VTBL_ENTRY)&_ZN6S266C63v20Ev,
  (VTBL_ENTRY)&_ZN6S266C63v21Ev,
  (VTBL_ENTRY)&_ZN6S266C63v22Ev,
  (VTBL_ENTRY)&_ZN6S266C63v23Ev,
  (VTBL_ENTRY)&_ZN6S266C63v24Ev,
  (VTBL_ENTRY)&_ZN6S266C63v25Ev,
  (VTBL_ENTRY)&_ZN6S266C63v26Ev,
  (VTBL_ENTRY)&_ZN6S266C63v27Ev,
  (VTBL_ENTRY)&_ZN6S266C63v28Ev,
  (VTBL_ENTRY)&_ZN6S266C63v29Ev,
  (VTBL_ENTRY)&_ZN6S266C63v30Ev,
  (VTBL_ENTRY)&_ZN6S266C63v31Ev,
  (VTBL_ENTRY)&_ZN6S266C63v32Ev,
  (VTBL_ENTRY)&_ZN6S266C63v33Ev,
  (VTBL_ENTRY)&_ZN6S266C63v34Ev,
  (VTBL_ENTRY)&_ZN6S266C63v35Ev,
  (VTBL_ENTRY)&_ZN6S266C63v36Ev,
  (VTBL_ENTRY)&_ZN6S266C63v37Ev,
  (VTBL_ENTRY)&_ZN6S266C63v38Ev,
  (VTBL_ENTRY)&_ZN6S266C63v39Ev,
  (VTBL_ENTRY)&_ZN6S266C63v40Ev,
  (VTBL_ENTRY)&_ZN6S266C63v41Ev,
  (VTBL_ENTRY)&_ZN6S266C63v42Ev,
  (VTBL_ENTRY)&_ZN6S266C63v43Ev,
  (VTBL_ENTRY)&_ZN6S266C63v44Ev,
  (VTBL_ENTRY)&_ZN6S266C63v45Ev,
  (VTBL_ENTRY)&_ZN6S266C63v46Ev,
  (VTBL_ENTRY)&_ZN6S266C63v47Ev,
  (VTBL_ENTRY)&_ZN6S266C63v48Ev,
  (VTBL_ENTRY)&_ZN6S266C63v49Ev,
  (VTBL_ENTRY)&_ZN6S266C63v50Ev,
  (VTBL_ENTRY)&_ZN6S266C63v51Ev,
  (VTBL_ENTRY)&_ZN6S266C63v52Ev,
  (VTBL_ENTRY)&_ZN6S266C63v53Ev,
  (VTBL_ENTRY)&_ZN6S266C63v54Ev,
  (VTBL_ENTRY)&_ZN6S266C63v55Ev,
  (VTBL_ENTRY)&_ZN6S266C63v56Ev,
  (VTBL_ENTRY)&_ZN6S266C63v57Ev,
  (VTBL_ENTRY)&_ZN6S266C63v58Ev,
  (VTBL_ENTRY)&_ZN6S266C63v59Ev,
  (VTBL_ENTRY)&_ZN6S266C63v60Ev,
  (VTBL_ENTRY)&_ZN6S266C63v61Ev,
  (VTBL_ENTRY)&_ZN6S266C63v62Ev,
  (VTBL_ENTRY)&_ZN6S266C63v63Ev,
  (VTBL_ENTRY)&_ZN6S266C63v64Ev,
  (VTBL_ENTRY)&_ZN6S266C63v65Ev,
  (VTBL_ENTRY)&_ZN6S266C63v66Ev,
  (VTBL_ENTRY)&_ZN6S266C63v67Ev,
  (VTBL_ENTRY)&_ZN6S266C63v68Ev,
  (VTBL_ENTRY)&_ZN6S266C63v69Ev,
  (VTBL_ENTRY)&_ZN6S266C53v70Ev,
  (VTBL_ENTRY)&_ZN6S266C53v71Ev,
  (VTBL_ENTRY)&_ZN6S266C53v72Ev,
  (VTBL_ENTRY)&_ZN6S266C53v73Ev,
  (VTBL_ENTRY)&_ZN6S266C53v74Ev,
  (VTBL_ENTRY)&_ZN6S266C53v75Ev,
  (VTBL_ENTRY)&_ZN6S266C53v76Ev,
  (VTBL_ENTRY)&_ZN6S266C53v77Ev,
  (VTBL_ENTRY)&_ZN6S266C53v78Ev,
  (VTBL_ENTRY)&_ZN6S266C53v79Ev,
  (VTBL_ENTRY)&_ZN6S266C53v80Ev,
  (VTBL_ENTRY)&_ZN6S266C53v81Ev,
  (VTBL_ENTRY)&_ZN6S266C53v82Ev,
  (VTBL_ENTRY)&_ZN6S266C53v83Ev,
  (VTBL_ENTRY)&_ZN6S266C53v84Ev,
  (VTBL_ENTRY)&_ZN6S266C53v85Ev,
  (VTBL_ENTRY)&_ZN6S266C53v86Ev,
  (VTBL_ENTRY)&_ZN6S266C53v87Ev,
  (VTBL_ENTRY)&_ZN6S266C53v88Ev,
  (VTBL_ENTRY)&_ZN6S266C53v89Ev,
  (VTBL_ENTRY)&_ZN6S266C53v90Ev,
  (VTBL_ENTRY)&_ZN6S266C53v91Ev,
  (VTBL_ENTRY)&_ZN6S266C43v92Ev,
  (VTBL_ENTRY)&_ZN6S266C43v93Ev,
  (VTBL_ENTRY)&_ZN6S266C43v94Ev,
  (VTBL_ENTRY)&_ZN6S266C43v95Ev,
  (VTBL_ENTRY)&_ZN6S266C43v96Ev,
  (VTBL_ENTRY)&_ZN6S266C43v97Ev,
  (VTBL_ENTRY)&_ZN6S266C43v98Ev,
  (VTBL_ENTRY)&_ZN6S266C43v99Ev,
  (VTBL_ENTRY)&_ZN6S266C44v100Ev,
  (VTBL_ENTRY)&_ZN6S266C44v101Ev,
  (VTBL_ENTRY)&_ZN6S266C44v102Ev,
  (VTBL_ENTRY)&_ZN6S266C44v103Ev,
  (VTBL_ENTRY)&_ZN6S266C44v104Ev,
  (VTBL_ENTRY)&_ZN6S266C44v105Ev,
  (VTBL_ENTRY)&_ZN6S266C44v106Ev,
  (VTBL_ENTRY)&_ZN6S266C44v107Ev,
  (VTBL_ENTRY)&_ZN6S266C44v108Ev,
  (VTBL_ENTRY)&_ZN6S266C44v109Ev,
  (VTBL_ENTRY)&_ZN6S266C44v110Ev,
  (VTBL_ENTRY)&_ZN6S266C44v111Ev,
  (VTBL_ENTRY)&_ZN6S266C34v112Ev,
  (VTBL_ENTRY)&_ZN6S266C34v113Ev,
  (VTBL_ENTRY)&_ZN6S266C34v114Ev,
  (VTBL_ENTRY)&_ZN6S266C34v115Ev,
  (VTBL_ENTRY)&_ZN6S266C34v116Ev,
  (VTBL_ENTRY)&_ZN6S266C34v117Ev,
  (VTBL_ENTRY)&_ZN6S266C34v118Ev,
  (VTBL_ENTRY)&_ZN6S266C34v119Ev,
  (VTBL_ENTRY)&_ZN6S266C34v120Ev,
  (VTBL_ENTRY)&_ZN6S266C34v121Ev,
  (VTBL_ENTRY)&_ZN6S266C34v122Ev,
  (VTBL_ENTRY)&_ZN6S266C34v123Ev,
  (VTBL_ENTRY)&_ZN6S266C34v124Ev,
  (VTBL_ENTRY)&_ZN6S266C34v125Ev,
};
extern VTBL_ENTRY _ZTI6S266C3[];
extern  VTBL_ENTRY _ZTV6S266C3[];
Class_Descriptor cd_S266C3 = {  "S266C3", // class name
  bases_S266C3, 3,
  &(vtc_S266C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(336,244), // object size
  NSPAIRA(_ZTI6S266C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S266C3),124, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S266C2  : S266C3 {
  void *s266c2f0[2];
  ::S287C8_nt s266c2f1;
  unsigned int s266c2f2:1;
  unsigned int s266c2f3:1;
  ::S3350C21_nt s266c2f4;
  virtual  ~S266C2(); // _ZN6S266C2D1Ev
  virtual void  v126(); // _ZN6S266C24v126Ev
  virtual void  v127(); // _ZN6S266C24v127Ev
  virtual void  v128(); // _ZN6S266C24v128Ev
  virtual void  v129(); // _ZN6S266C24v129Ev
  virtual void  v130(); // _ZN6S266C24v130Ev
  virtual void  v131(); // _ZN6S266C24v131Ev
  virtual void  v132(); // _ZN6S266C24v132Ev
  virtual void  v133(); // _ZN6S266C24v133Ev
  virtual void  v134(); // _ZN6S266C24v134Ev
  virtual void  v135(); // _ZN6S266C24v135Ev
  virtual void  v136(); // _ZN6S266C24v136Ev
  S266C2(); // tgen
};
//SIG(-1 S266C2) C1{ BC2{ BC3{ BC4{ BC5{ vd v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} FC18{ BC19{ BC10}} Fi[3]} vd v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 Fp[2] Fi[4] Fi:1 Fi:1 Fi:1 Fc Fi Fi:1 FC20{ BC21{ BC10}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 Fp[2] FC7 Fi:1 Fi:1 FC22{ m Fp FC6}}


 S266C2 ::~S266C2(){ note_dtor("S266C2", this);}
void  S266C2 ::v126(){vfunc_called(this, "_ZN6S266C24v126Ev");}
void  S266C2 ::v127(){vfunc_called(this, "_ZN6S266C24v127Ev");}
void  S266C2 ::v128(){vfunc_called(this, "_ZN6S266C24v128Ev");}
void  S266C2 ::v129(){vfunc_called(this, "_ZN6S266C24v129Ev");}
void  S266C2 ::v130(){vfunc_called(this, "_ZN6S266C24v130Ev");}
void  S266C2 ::v131(){vfunc_called(this, "_ZN6S266C24v131Ev");}
void  S266C2 ::v132(){vfunc_called(this, "_ZN6S266C24v132Ev");}
void  S266C2 ::v133(){vfunc_called(this, "_ZN6S266C24v133Ev");}
void  S266C2 ::v134(){vfunc_called(this, "_ZN6S266C24v134Ev");}
void  S266C2 ::v135(){vfunc_called(this, "_ZN6S266C24v135Ev");}
void  S266C2 ::v136(){vfunc_called(this, "_ZN6S266C24v136Ev");}
S266C2 ::S266C2(){ note_ctor("S266C2", this);} // tgen

static void Test_S266C2()
{
  extern Class_Descriptor cd_S266C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(50,71)];
    init_test(&cd_S266C2, buf);
    S266C2 *dp, &lv = *(dp=new (buf) S266C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(392,280), "sizeof(S266C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S266C2)");
    check_base_class_offset(lv, (S266C6*)(S266C5*)(S266C4*)(S266C3*), 0, "S266C2");
    check_base_class_offset(lv, (S266C5*)(S266C4*)(S266C3*), 0, "S266C2");
    check_base_class_offset(lv, (S266C4*)(S266C3*), 0, "S266C2");
    check_base_class_offset(lv, (S266C3*), 0, "S266C2");
    check_field_offset(lv, s266c2f0, ABISELECT(336,244), "S266C2.s266c2f0");
    check_field_offset(lv, s266c2f1, ABISELECT(352,252), "S266C2.s266c2f1");
    set_bf_and_test(lv, s266c2f2, ABISELECT(368,264), 0, 1, 1, "S266C2");
    set_bf_and_test(lv, s266c2f3, ABISELECT(368,264), 1, 1, 1, "S266C2");
    check_field_offset(lv, s266c2f4, ABISELECT(376,268), "S266C2.s266c2f4");
    test_class_info(&lv, &cd_S266C2);
    dp->~S266C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS266C2(Test_S266C2, "S266C2", ABISELECT(392,280));

#else // __cplusplus

extern void _ZN6S266C2C1Ev();
extern void _ZN6S266C2D1Ev();
Name_Map name_map_S266C2[] = {
  NSPAIR(_ZN6S266C2C1Ev),
  NSPAIR(_ZN6S266C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S266C6;
extern VTBL_ENTRY _ZTI6S266C6[];
extern  VTBL_ENTRY _ZTV6S266C6[];
extern Class_Descriptor cd_S266C5;
extern VTBL_ENTRY _ZTI6S266C5[];
extern  VTBL_ENTRY _ZTV6S266C5[];
extern Class_Descriptor cd_S266C4;
extern VTBL_ENTRY _ZTI6S266C4[];
extern  VTBL_ENTRY _ZTV6S266C4[];
extern Class_Descriptor cd_S266C3;
extern VTBL_ENTRY _ZTI6S266C3[];
extern  VTBL_ENTRY _ZTV6S266C3[];
static Base_Class bases_S266C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S266C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S266C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S266C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S266C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S266C2[];
extern void _ZN6S266C2D1Ev();
extern void _ZN6S266C2D0Ev();
extern void _ZN6S266C62v6Ev();
extern void _ZN6S266C62v7Ev();
extern void _ZN6S266C62v8Ev();
extern void _ZN6S266C62v9Ev();
extern void _ZN6S266C63v10Ev();
extern void _ZN6S266C63v11Ev();
extern void _ZN6S266C63v12Ev();
extern void _ZN6S266C63v13Ev();
extern void _ZN6S266C63v14Ev();
extern void _ZN6S266C63v15Ev();
extern void _ZN6S266C63v16Ev();
extern void _ZN6S266C63v17Ev();
extern void _ZN6S266C63v18Ev();
extern void _ZN6S266C63v19Ev();
extern void _ZN6S266C63v20Ev();
extern void _ZN6S266C63v21Ev();
extern void _ZN6S266C63v22Ev();
extern void _ZN6S266C63v23Ev();
extern void _ZN6S266C63v24Ev();
extern void _ZN6S266C63v25Ev();
extern void _ZN6S266C63v26Ev();
extern void _ZN6S266C63v27Ev();
extern void _ZN6S266C63v28Ev();
extern void _ZN6S266C63v29Ev();
extern void _ZN6S266C63v30Ev();
extern void _ZN6S266C63v31Ev();
extern void _ZN6S266C63v32Ev();
extern void _ZN6S266C63v33Ev();
extern void _ZN6S266C63v34Ev();
extern void _ZN6S266C63v35Ev();
extern void _ZN6S266C63v36Ev();
extern void _ZN6S266C63v37Ev();
extern void _ZN6S266C63v38Ev();
extern void _ZN6S266C63v39Ev();
extern void _ZN6S266C63v40Ev();
extern void _ZN6S266C63v41Ev();
extern void _ZN6S266C63v42Ev();
extern void _ZN6S266C63v43Ev();
extern void _ZN6S266C63v44Ev();
extern void _ZN6S266C63v45Ev();
extern void _ZN6S266C63v46Ev();
extern void _ZN6S266C63v47Ev();
extern void _ZN6S266C63v48Ev();
extern void _ZN6S266C63v49Ev();
extern void _ZN6S266C63v50Ev();
extern void _ZN6S266C63v51Ev();
extern void _ZN6S266C63v52Ev();
extern void _ZN6S266C63v53Ev();
extern void _ZN6S266C63v54Ev();
extern void _ZN6S266C63v55Ev();
extern void _ZN6S266C63v56Ev();
extern void _ZN6S266C63v57Ev();
extern void _ZN6S266C63v58Ev();
extern void _ZN6S266C63v59Ev();
extern void _ZN6S266C63v60Ev();
extern void _ZN6S266C63v61Ev();
extern void _ZN6S266C63v62Ev();
extern void _ZN6S266C63v63Ev();
extern void _ZN6S266C63v64Ev();
extern void _ZN6S266C63v65Ev();
extern void _ZN6S266C63v66Ev();
extern void _ZN6S266C63v67Ev();
extern void _ZN6S266C63v68Ev();
extern void _ZN6S266C63v69Ev();
extern void _ZN6S266C53v70Ev();
extern void _ZN6S266C53v71Ev();
extern void _ZN6S266C53v72Ev();
extern void _ZN6S266C53v73Ev();
extern void _ZN6S266C53v74Ev();
extern void _ZN6S266C53v75Ev();
extern void _ZN6S266C53v76Ev();
extern void _ZN6S266C53v77Ev();
extern void _ZN6S266C53v78Ev();
extern void _ZN6S266C53v79Ev();
extern void _ZN6S266C53v80Ev();
extern void _ZN6S266C53v81Ev();
extern void _ZN6S266C53v82Ev();
extern void _ZN6S266C53v83Ev();
extern void _ZN6S266C53v84Ev();
extern void _ZN6S266C53v85Ev();
extern void _ZN6S266C53v86Ev();
extern void _ZN6S266C53v87Ev();
extern void _ZN6S266C53v88Ev();
extern void _ZN6S266C53v89Ev();
extern void _ZN6S266C53v90Ev();
extern void _ZN6S266C53v91Ev();
extern void _ZN6S266C43v92Ev();
extern void _ZN6S266C43v93Ev();
extern void _ZN6S266C43v94Ev();
extern void _ZN6S266C43v95Ev();
extern void _ZN6S266C43v96Ev();
extern void _ZN6S266C43v97Ev();
extern void _ZN6S266C43v98Ev();
extern void _ZN6S266C43v99Ev();
extern void _ZN6S266C44v100Ev();
extern void _ZN6S266C44v101Ev();
extern void _ZN6S266C44v102Ev();
extern void _ZN6S266C44v103Ev();
extern void _ZN6S266C44v104Ev();
extern void _ZN6S266C44v105Ev();
extern void _ZN6S266C44v106Ev();
extern void _ZN6S266C44v107Ev();
extern void _ZN6S266C44v108Ev();
extern void _ZN6S266C44v109Ev();
extern void _ZN6S266C44v110Ev();
extern void _ZN6S266C44v111Ev();
extern void _ZN6S266C34v112Ev();
extern void _ZN6S266C34v113Ev();
extern void _ZN6S266C34v114Ev();
extern void _ZN6S266C34v115Ev();
extern void _ZN6S266C34v116Ev();
extern void _ZN6S266C34v117Ev();
extern void _ZN6S266C34v118Ev();
extern void _ZN6S266C34v119Ev();
extern void _ZN6S266C34v120Ev();
extern void _ZN6S266C34v121Ev();
extern void _ZN6S266C34v122Ev();
extern void _ZN6S266C34v123Ev();
extern void _ZN6S266C34v124Ev();
extern void _ZN6S266C34v125Ev();
extern void _ZN6S266C24v126Ev();
extern void _ZN6S266C24v127Ev();
extern void _ZN6S266C24v128Ev();
extern void _ZN6S266C24v129Ev();
extern void _ZN6S266C24v130Ev();
extern void _ZN6S266C24v131Ev();
extern void _ZN6S266C24v132Ev();
extern void _ZN6S266C24v133Ev();
extern void _ZN6S266C24v134Ev();
extern void _ZN6S266C24v135Ev();
extern void _ZN6S266C24v136Ev();
static  VTBL_ENTRY vtc_S266C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S266C2[0]),
  (VTBL_ENTRY)&_ZN6S266C2D1Ev,
  (VTBL_ENTRY)&_ZN6S266C2D0Ev,
  (VTBL_ENTRY)&_ZN6S266C62v6Ev,
  (VTBL_ENTRY)&_ZN6S266C62v7Ev,
  (VTBL_ENTRY)&_ZN6S266C62v8Ev,
  (VTBL_ENTRY)&_ZN6S266C62v9Ev,
  (VTBL_ENTRY)&_ZN6S266C63v10Ev,
  (VTBL_ENTRY)&_ZN6S266C63v11Ev,
  (VTBL_ENTRY)&_ZN6S266C63v12Ev,
  (VTBL_ENTRY)&_ZN6S266C63v13Ev,
  (VTBL_ENTRY)&_ZN6S266C63v14Ev,
  (VTBL_ENTRY)&_ZN6S266C63v15Ev,
  (VTBL_ENTRY)&_ZN6S266C63v16Ev,
  (VTBL_ENTRY)&_ZN6S266C63v17Ev,
  (VTBL_ENTRY)&_ZN6S266C63v18Ev,
  (VTBL_ENTRY)&_ZN6S266C63v19Ev,
  (VTBL_ENTRY)&_ZN6S266C63v20Ev,
  (VTBL_ENTRY)&_ZN6S266C63v21Ev,
  (VTBL_ENTRY)&_ZN6S266C63v22Ev,
  (VTBL_ENTRY)&_ZN6S266C63v23Ev,
  (VTBL_ENTRY)&_ZN6S266C63v24Ev,
  (VTBL_ENTRY)&_ZN6S266C63v25Ev,
  (VTBL_ENTRY)&_ZN6S266C63v26Ev,
  (VTBL_ENTRY)&_ZN6S266C63v27Ev,
  (VTBL_ENTRY)&_ZN6S266C63v28Ev,
  (VTBL_ENTRY)&_ZN6S266C63v29Ev,
  (VTBL_ENTRY)&_ZN6S266C63v30Ev,
  (VTBL_ENTRY)&_ZN6S266C63v31Ev,
  (VTBL_ENTRY)&_ZN6S266C63v32Ev,
  (VTBL_ENTRY)&_ZN6S266C63v33Ev,
  (VTBL_ENTRY)&_ZN6S266C63v34Ev,
  (VTBL_ENTRY)&_ZN6S266C63v35Ev,
  (VTBL_ENTRY)&_ZN6S266C63v36Ev,
  (VTBL_ENTRY)&_ZN6S266C63v37Ev,
  (VTBL_ENTRY)&_ZN6S266C63v38Ev,
  (VTBL_ENTRY)&_ZN6S266C63v39Ev,
  (VTBL_ENTRY)&_ZN6S266C63v40Ev,
  (VTBL_ENTRY)&_ZN6S266C63v41Ev,
  (VTBL_ENTRY)&_ZN6S266C63v42Ev,
  (VTBL_ENTRY)&_ZN6S266C63v43Ev,
  (VTBL_ENTRY)&_ZN6S266C63v44Ev,
  (VTBL_ENTRY)&_ZN6S266C63v45Ev,
  (VTBL_ENTRY)&_ZN6S266C63v46Ev,
  (VTBL_ENTRY)&_ZN6S266C63v47Ev,
  (VTBL_ENTRY)&_ZN6S266C63v48Ev,
  (VTBL_ENTRY)&_ZN6S266C63v49Ev,
  (VTBL_ENTRY)&_ZN6S266C63v50Ev,
  (VTBL_ENTRY)&_ZN6S266C63v51Ev,
  (VTBL_ENTRY)&_ZN6S266C63v52Ev,
  (VTBL_ENTRY)&_ZN6S266C63v53Ev,
  (VTBL_ENTRY)&_ZN6S266C63v54Ev,
  (VTBL_ENTRY)&_ZN6S266C63v55Ev,
  (VTBL_ENTRY)&_ZN6S266C63v56Ev,
  (VTBL_ENTRY)&_ZN6S266C63v57Ev,
  (VTBL_ENTRY)&_ZN6S266C63v58Ev,
  (VTBL_ENTRY)&_ZN6S266C63v59Ev,
  (VTBL_ENTRY)&_ZN6S266C63v60Ev,
  (VTBL_ENTRY)&_ZN6S266C63v61Ev,
  (VTBL_ENTRY)&_ZN6S266C63v62Ev,
  (VTBL_ENTRY)&_ZN6S266C63v63Ev,
  (VTBL_ENTRY)&_ZN6S266C63v64Ev,
  (VTBL_ENTRY)&_ZN6S266C63v65Ev,
  (VTBL_ENTRY)&_ZN6S266C63v66Ev,
  (VTBL_ENTRY)&_ZN6S266C63v67Ev,
  (VTBL_ENTRY)&_ZN6S266C63v68Ev,
  (VTBL_ENTRY)&_ZN6S266C63v69Ev,
  (VTBL_ENTRY)&_ZN6S266C53v70Ev,
  (VTBL_ENTRY)&_ZN6S266C53v71Ev,
  (VTBL_ENTRY)&_ZN6S266C53v72Ev,
  (VTBL_ENTRY)&_ZN6S266C53v73Ev,
  (VTBL_ENTRY)&_ZN6S266C53v74Ev,
  (VTBL_ENTRY)&_ZN6S266C53v75Ev,
  (VTBL_ENTRY)&_ZN6S266C53v76Ev,
  (VTBL_ENTRY)&_ZN6S266C53v77Ev,
  (VTBL_ENTRY)&_ZN6S266C53v78Ev,
  (VTBL_ENTRY)&_ZN6S266C53v79Ev,
  (VTBL_ENTRY)&_ZN6S266C53v80Ev,
  (VTBL_ENTRY)&_ZN6S266C53v81Ev,
  (VTBL_ENTRY)&_ZN6S266C53v82Ev,
  (VTBL_ENTRY)&_ZN6S266C53v83Ev,
  (VTBL_ENTRY)&_ZN6S266C53v84Ev,
  (VTBL_ENTRY)&_ZN6S266C53v85Ev,
  (VTBL_ENTRY)&_ZN6S266C53v86Ev,
  (VTBL_ENTRY)&_ZN6S266C53v87Ev,
  (VTBL_ENTRY)&_ZN6S266C53v88Ev,
  (VTBL_ENTRY)&_ZN6S266C53v89Ev,
  (VTBL_ENTRY)&_ZN6S266C53v90Ev,
  (VTBL_ENTRY)&_ZN6S266C53v91Ev,
  (VTBL_ENTRY)&_ZN6S266C43v92Ev,
  (VTBL_ENTRY)&_ZN6S266C43v93Ev,
  (VTBL_ENTRY)&_ZN6S266C43v94Ev,
  (VTBL_ENTRY)&_ZN6S266C43v95Ev,
  (VTBL_ENTRY)&_ZN6S266C43v96Ev,
  (VTBL_ENTRY)&_ZN6S266C43v97Ev,
  (VTBL_ENTRY)&_ZN6S266C43v98Ev,
  (VTBL_ENTRY)&_ZN6S266C43v99Ev,
  (VTBL_ENTRY)&_ZN6S266C44v100Ev,
  (VTBL_ENTRY)&_ZN6S266C44v101Ev,
  (VTBL_ENTRY)&_ZN6S266C44v102Ev,
  (VTBL_ENTRY)&_ZN6S266C44v103Ev,
  (VTBL_ENTRY)&_ZN6S266C44v104Ev,
  (VTBL_ENTRY)&_ZN6S266C44v105Ev,
  (VTBL_ENTRY)&_ZN6S266C44v106Ev,
  (VTBL_ENTRY)&_ZN6S266C44v107Ev,
  (VTBL_ENTRY)&_ZN6S266C44v108Ev,
  (VTBL_ENTRY)&_ZN6S266C44v109Ev,
  (VTBL_ENTRY)&_ZN6S266C44v110Ev,
  (VTBL_ENTRY)&_ZN6S266C44v111Ev,
  (VTBL_ENTRY)&_ZN6S266C34v112Ev,
  (VTBL_ENTRY)&_ZN6S266C34v113Ev,
  (VTBL_ENTRY)&_ZN6S266C34v114Ev,
  (VTBL_ENTRY)&_ZN6S266C34v115Ev,
  (VTBL_ENTRY)&_ZN6S266C34v116Ev,
  (VTBL_ENTRY)&_ZN6S266C34v117Ev,
  (VTBL_ENTRY)&_ZN6S266C34v118Ev,
  (VTBL_ENTRY)&_ZN6S266C34v119Ev,
  (VTBL_ENTRY)&_ZN6S266C34v120Ev,
  (VTBL_ENTRY)&_ZN6S266C34v121Ev,
  (VTBL_ENTRY)&_ZN6S266C34v122Ev,
  (VTBL_ENTRY)&_ZN6S266C34v123Ev,
  (VTBL_ENTRY)&_ZN6S266C34v124Ev,
  (VTBL_ENTRY)&_ZN6S266C34v125Ev,
  (VTBL_ENTRY)&_ZN6S266C24v126Ev,
  (VTBL_ENTRY)&_ZN6S266C24v127Ev,
  (VTBL_ENTRY)&_ZN6S266C24v128Ev,
  (VTBL_ENTRY)&_ZN6S266C24v129Ev,
  (VTBL_ENTRY)&_ZN6S266C24v130Ev,
  (VTBL_ENTRY)&_ZN6S266C24v131Ev,
  (VTBL_ENTRY)&_ZN6S266C24v132Ev,
  (VTBL_ENTRY)&_ZN6S266C24v133Ev,
  (VTBL_ENTRY)&_ZN6S266C24v134Ev,
  (VTBL_ENTRY)&_ZN6S266C24v135Ev,
  (VTBL_ENTRY)&_ZN6S266C24v136Ev,
};
extern VTBL_ENTRY _ZTI6S266C2[];
extern  VTBL_ENTRY _ZTV6S266C2[];
Class_Descriptor cd_S266C2 = {  "S266C2", // class name
  bases_S266C2, 4,
  &(vtc_S266C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(392,280), // object size
  NSPAIRA(_ZTI6S266C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S266C2),135, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S266C24_nt  {
  virtual  ~S266C24_nt(); // _ZN10S266C24_ntD1Ev
  virtual void  v137(); // _ZN10S266C24_nt4v137Ev
  virtual void  v138(); // _ZN10S266C24_nt4v138Ev
  virtual void  v139(); // _ZN10S266C24_nt4v139Ev
  virtual void  v140(); // _ZN10S266C24_nt4v140Ev
  virtual void  v141(); // _ZN10S266C24_nt4v141Ev
  virtual void  v142(); // _ZN10S266C24_nt4v142Ev
  virtual void  v143(); // _ZN10S266C24_nt4v143Ev
  S266C24_nt(); // tgen
};
//SIG(-1 S266C24_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7}


 S266C24_nt ::~S266C24_nt(){ note_dtor("S266C24_nt", this);}
void  S266C24_nt ::v137(){vfunc_called(this, "_ZN10S266C24_nt4v137Ev");}
void  S266C24_nt ::v138(){vfunc_called(this, "_ZN10S266C24_nt4v138Ev");}
void  S266C24_nt ::v139(){vfunc_called(this, "_ZN10S266C24_nt4v139Ev");}
void  S266C24_nt ::v140(){vfunc_called(this, "_ZN10S266C24_nt4v140Ev");}
void  S266C24_nt ::v141(){vfunc_called(this, "_ZN10S266C24_nt4v141Ev");}
void  S266C24_nt ::v142(){vfunc_called(this, "_ZN10S266C24_nt4v142Ev");}
void  S266C24_nt ::v143(){vfunc_called(this, "_ZN10S266C24_nt4v143Ev");}
S266C24_nt ::S266C24_nt(){ note_ctor("S266C24_nt", this);} // tgen

//skip512 S266C24_nt

#else // __cplusplus

extern void _ZN10S266C24_ntC1Ev();
extern void _ZN10S266C24_ntD1Ev();
Name_Map name_map_S266C24_nt[] = {
  NSPAIR(_ZN10S266C24_ntC1Ev),
  NSPAIR(_ZN10S266C24_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S266C24_nt[];
extern void _ZN10S266C24_ntD1Ev();
extern void _ZN10S266C24_ntD0Ev();
extern void _ZN10S266C24_nt4v137Ev();
extern void _ZN10S266C24_nt4v138Ev();
extern void _ZN10S266C24_nt4v139Ev();
extern void _ZN10S266C24_nt4v140Ev();
extern void _ZN10S266C24_nt4v141Ev();
extern void _ZN10S266C24_nt4v142Ev();
extern void _ZN10S266C24_nt4v143Ev();
static  VTBL_ENTRY vtc_S266C24_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S266C24_nt[0]),
  (VTBL_ENTRY)&_ZN10S266C24_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S266C24_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S266C24_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S266C24_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S266C24_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S266C24_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S266C24_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S266C24_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S266C24_nt4v143Ev,
};
extern VTBL_ENTRY _ZTI10S266C24_nt[];
VTBL_ENTRY *P__ZTI10S266C24_nt = _ZTI10S266C24_nt; 
extern  VTBL_ENTRY _ZTV10S266C24_nt[];
Class_Descriptor cd_S266C24_nt = {  "S266C24_nt", // class name
  0,0,//no base classes
  &(vtc_S266C24_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S266C24_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S266C24_nt),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S266C1  : S266C2 , S266C24_nt {
  virtual  ~S266C1(); // _ZN6S266C1D1Ev
  virtual void  v1(); // _ZN6S266C12v1Ev
  virtual void  v2(); // _ZN6S266C12v2Ev
  virtual void  v3(); // _ZN6S266C12v3Ev
  virtual void  v4(); // _ZN6S266C12v4Ev
  virtual void  v5(); // _ZN6S266C12v5Ev
  S266C1(); // tgen
};
//SIG(1 S266C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 Fi[2] Fp Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 FC12{ m} FC8 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 Fi:1 Fi:1 Fi:1 FC13{ BC14{ BC11}} FC15{ BC16{ BC11}} FC17{ BC18{ BC11}} FC19{ BC20{ BC11}} Fi[3]} vd v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 Fp[2] Fi[4] Fi:1 Fi:1 Fi:1 Fc Fi Fi:1 FC21{ BC22{ BC11}}} vd v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 Fp[2] FC8 Fi:1 Fi:1 FC23{ m Fp FC7}} BC24{ vd v137 v138 v139 v140 v141 v142 v143} vd v1 v2 v3 v4 v5}


 S266C1 ::~S266C1(){ note_dtor("S266C1", this);}
void  S266C1 ::v1(){vfunc_called(this, "_ZN6S266C12v1Ev");}
void  S266C1 ::v2(){vfunc_called(this, "_ZN6S266C12v2Ev");}
void  S266C1 ::v3(){vfunc_called(this, "_ZN6S266C12v3Ev");}
void  S266C1 ::v4(){vfunc_called(this, "_ZN6S266C12v4Ev");}
void  S266C1 ::v5(){vfunc_called(this, "_ZN6S266C12v5Ev");}
S266C1 ::S266C1(){ note_ctor("S266C1", this);} // tgen

static void Test_S266C1()
{
  extern Class_Descriptor cd_S266C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(51,72)];
    init_test(&cd_S266C1, buf);
    S266C1 *dp, &lv = *(dp=new (buf) S266C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(400,284), "sizeof(S266C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S266C1)");
    check_base_class_offset(lv, (S266C6*)(S266C5*)(S266C4*)(S266C3*)(S266C2*), 0, "S266C1");
    check_base_class_offset(lv, (S266C5*)(S266C4*)(S266C3*)(S266C2*), 0, "S266C1");
    check_base_class_offset(lv, (S266C4*)(S266C3*)(S266C2*), 0, "S266C1");
    check_base_class_offset(lv, (S266C3*)(S266C2*), 0, "S266C1");
    check_base_class_offset(lv, (S266C2*), 0, "S266C1");
    check_base_class_offset(lv, (S266C24_nt*), ABISELECT(392,280), "S266C1");
    test_class_info(&lv, &cd_S266C1);
    dp->~S266C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS266C1(Test_S266C1, "S266C1", ABISELECT(400,284));

#else // __cplusplus

extern void _ZN6S266C1C1Ev();
extern void _ZN6S266C1D1Ev();
Name_Map name_map_S266C1[] = {
  NSPAIR(_ZN6S266C1C1Ev),
  NSPAIR(_ZN6S266C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S266C6;
extern VTBL_ENTRY _ZTI6S266C6[];
extern  VTBL_ENTRY _ZTV6S266C6[];
extern Class_Descriptor cd_S266C5;
extern VTBL_ENTRY _ZTI6S266C5[];
extern  VTBL_ENTRY _ZTV6S266C5[];
extern Class_Descriptor cd_S266C4;
extern VTBL_ENTRY _ZTI6S266C4[];
extern  VTBL_ENTRY _ZTV6S266C4[];
extern Class_Descriptor cd_S266C3;
extern VTBL_ENTRY _ZTI6S266C3[];
extern  VTBL_ENTRY _ZTV6S266C3[];
extern Class_Descriptor cd_S266C2;
extern VTBL_ENTRY _ZTI6S266C2[];
extern  VTBL_ENTRY _ZTV6S266C2[];
extern Class_Descriptor cd_S266C24_nt;
extern VTBL_ENTRY _ZTI10S266C24_nt[];
extern  VTBL_ENTRY _ZTV10S266C24_nt[];
static Base_Class bases_S266C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S266C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S266C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S266C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S266C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S266C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S266C24_nt,    ABISELECT(392,280), //bcp->offset
    140, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S266C1[];
extern void _ZN6S266C1D1Ev();
extern void _ZN6S266C1D0Ev();
extern void _ZN6S266C62v6Ev();
extern void _ZN6S266C62v7Ev();
extern void _ZN6S266C62v8Ev();
extern void _ZN6S266C62v9Ev();
extern void _ZN6S266C63v10Ev();
extern void _ZN6S266C63v11Ev();
extern void _ZN6S266C63v12Ev();
extern void _ZN6S266C63v13Ev();
extern void _ZN6S266C63v14Ev();
extern void _ZN6S266C63v15Ev();
extern void _ZN6S266C63v16Ev();
extern void _ZN6S266C63v17Ev();
extern void _ZN6S266C63v18Ev();
extern void _ZN6S266C63v19Ev();
extern void _ZN6S266C63v20Ev();
extern void _ZN6S266C63v21Ev();
extern void _ZN6S266C63v22Ev();
extern void _ZN6S266C63v23Ev();
extern void _ZN6S266C63v24Ev();
extern void _ZN6S266C63v25Ev();
extern void _ZN6S266C63v26Ev();
extern void _ZN6S266C63v27Ev();
extern void _ZN6S266C63v28Ev();
extern void _ZN6S266C63v29Ev();
extern void _ZN6S266C63v30Ev();
extern void _ZN6S266C63v31Ev();
extern void _ZN6S266C63v32Ev();
extern void _ZN6S266C63v33Ev();
extern void _ZN6S266C63v34Ev();
extern void _ZN6S266C63v35Ev();
extern void _ZN6S266C63v36Ev();
extern void _ZN6S266C63v37Ev();
extern void _ZN6S266C63v38Ev();
extern void _ZN6S266C63v39Ev();
extern void _ZN6S266C63v40Ev();
extern void _ZN6S266C63v41Ev();
extern void _ZN6S266C63v42Ev();
extern void _ZN6S266C63v43Ev();
extern void _ZN6S266C63v44Ev();
extern void _ZN6S266C63v45Ev();
extern void _ZN6S266C63v46Ev();
extern void _ZN6S266C63v47Ev();
extern void _ZN6S266C63v48Ev();
extern void _ZN6S266C63v49Ev();
extern void _ZN6S266C63v50Ev();
extern void _ZN6S266C63v51Ev();
extern void _ZN6S266C63v52Ev();
extern void _ZN6S266C63v53Ev();
extern void _ZN6S266C63v54Ev();
extern void _ZN6S266C63v55Ev();
extern void _ZN6S266C63v56Ev();
extern void _ZN6S266C63v57Ev();
extern void _ZN6S266C63v58Ev();
extern void _ZN6S266C63v59Ev();
extern void _ZN6S266C63v60Ev();
extern void _ZN6S266C63v61Ev();
extern void _ZN6S266C63v62Ev();
extern void _ZN6S266C63v63Ev();
extern void _ZN6S266C63v64Ev();
extern void _ZN6S266C63v65Ev();
extern void _ZN6S266C63v66Ev();
extern void _ZN6S266C63v67Ev();
extern void _ZN6S266C63v68Ev();
extern void _ZN6S266C63v69Ev();
extern void _ZN6S266C53v70Ev();
extern void _ZN6S266C53v71Ev();
extern void _ZN6S266C53v72Ev();
extern void _ZN6S266C53v73Ev();
extern void _ZN6S266C53v74Ev();
extern void _ZN6S266C53v75Ev();
extern void _ZN6S266C53v76Ev();
extern void _ZN6S266C53v77Ev();
extern void _ZN6S266C53v78Ev();
extern void _ZN6S266C53v79Ev();
extern void _ZN6S266C53v80Ev();
extern void _ZN6S266C53v81Ev();
extern void _ZN6S266C53v82Ev();
extern void _ZN6S266C53v83Ev();
extern void _ZN6S266C53v84Ev();
extern void _ZN6S266C53v85Ev();
extern void _ZN6S266C53v86Ev();
extern void _ZN6S266C53v87Ev();
extern void _ZN6S266C53v88Ev();
extern void _ZN6S266C53v89Ev();
extern void _ZN6S266C53v90Ev();
extern void _ZN6S266C53v91Ev();
extern void _ZN6S266C43v92Ev();
extern void _ZN6S266C43v93Ev();
extern void _ZN6S266C43v94Ev();
extern void _ZN6S266C43v95Ev();
extern void _ZN6S266C43v96Ev();
extern void _ZN6S266C43v97Ev();
extern void _ZN6S266C43v98Ev();
extern void _ZN6S266C43v99Ev();
extern void _ZN6S266C44v100Ev();
extern void _ZN6S266C44v101Ev();
extern void _ZN6S266C44v102Ev();
extern void _ZN6S266C44v103Ev();
extern void _ZN6S266C44v104Ev();
extern void _ZN6S266C44v105Ev();
extern void _ZN6S266C44v106Ev();
extern void _ZN6S266C44v107Ev();
extern void _ZN6S266C44v108Ev();
extern void _ZN6S266C44v109Ev();
extern void _ZN6S266C44v110Ev();
extern void _ZN6S266C44v111Ev();
extern void _ZN6S266C34v112Ev();
extern void _ZN6S266C34v113Ev();
extern void _ZN6S266C34v114Ev();
extern void _ZN6S266C34v115Ev();
extern void _ZN6S266C34v116Ev();
extern void _ZN6S266C34v117Ev();
extern void _ZN6S266C34v118Ev();
extern void _ZN6S266C34v119Ev();
extern void _ZN6S266C34v120Ev();
extern void _ZN6S266C34v121Ev();
extern void _ZN6S266C34v122Ev();
extern void _ZN6S266C34v123Ev();
extern void _ZN6S266C34v124Ev();
extern void _ZN6S266C34v125Ev();
extern void _ZN6S266C24v126Ev();
extern void _ZN6S266C24v127Ev();
extern void _ZN6S266C24v128Ev();
extern void _ZN6S266C24v129Ev();
extern void _ZN6S266C24v130Ev();
extern void _ZN6S266C24v131Ev();
extern void _ZN6S266C24v132Ev();
extern void _ZN6S266C24v133Ev();
extern void _ZN6S266C24v134Ev();
extern void _ZN6S266C24v135Ev();
extern void _ZN6S266C24v136Ev();
extern void _ZN6S266C12v1Ev();
extern void _ZN6S266C12v2Ev();
extern void _ZN6S266C12v3Ev();
extern void _ZN6S266C12v4Ev();
extern void _ZN6S266C12v5Ev();
extern void ABISELECT(_ZThn392_N6S266C1D1Ev,_ZThn280_N6S266C1D1Ev)();
extern void ABISELECT(_ZThn392_N6S266C1D0Ev,_ZThn280_N6S266C1D0Ev)();
extern void _ZN10S266C24_nt4v137Ev();
extern void _ZN10S266C24_nt4v138Ev();
extern void _ZN10S266C24_nt4v139Ev();
extern void _ZN10S266C24_nt4v140Ev();
extern void _ZN10S266C24_nt4v141Ev();
extern void _ZN10S266C24_nt4v142Ev();
extern void _ZN10S266C24_nt4v143Ev();
static  VTBL_ENTRY vtc_S266C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S266C1[0]),
  (VTBL_ENTRY)&_ZN6S266C1D1Ev,
  (VTBL_ENTRY)&_ZN6S266C1D0Ev,
  (VTBL_ENTRY)&_ZN6S266C62v6Ev,
  (VTBL_ENTRY)&_ZN6S266C62v7Ev,
  (VTBL_ENTRY)&_ZN6S266C62v8Ev,
  (VTBL_ENTRY)&_ZN6S266C62v9Ev,
  (VTBL_ENTRY)&_ZN6S266C63v10Ev,
  (VTBL_ENTRY)&_ZN6S266C63v11Ev,
  (VTBL_ENTRY)&_ZN6S266C63v12Ev,
  (VTBL_ENTRY)&_ZN6S266C63v13Ev,
  (VTBL_ENTRY)&_ZN6S266C63v14Ev,
  (VTBL_ENTRY)&_ZN6S266C63v15Ev,
  (VTBL_ENTRY)&_ZN6S266C63v16Ev,
  (VTBL_ENTRY)&_ZN6S266C63v17Ev,
  (VTBL_ENTRY)&_ZN6S266C63v18Ev,
  (VTBL_ENTRY)&_ZN6S266C63v19Ev,
  (VTBL_ENTRY)&_ZN6S266C63v20Ev,
  (VTBL_ENTRY)&_ZN6S266C63v21Ev,
  (VTBL_ENTRY)&_ZN6S266C63v22Ev,
  (VTBL_ENTRY)&_ZN6S266C63v23Ev,
  (VTBL_ENTRY)&_ZN6S266C63v24Ev,
  (VTBL_ENTRY)&_ZN6S266C63v25Ev,
  (VTBL_ENTRY)&_ZN6S266C63v26Ev,
  (VTBL_ENTRY)&_ZN6S266C63v27Ev,
  (VTBL_ENTRY)&_ZN6S266C63v28Ev,
  (VTBL_ENTRY)&_ZN6S266C63v29Ev,
  (VTBL_ENTRY)&_ZN6S266C63v30Ev,
  (VTBL_ENTRY)&_ZN6S266C63v31Ev,
  (VTBL_ENTRY)&_ZN6S266C63v32Ev,
  (VTBL_ENTRY)&_ZN6S266C63v33Ev,
  (VTBL_ENTRY)&_ZN6S266C63v34Ev,
  (VTBL_ENTRY)&_ZN6S266C63v35Ev,
  (VTBL_ENTRY)&_ZN6S266C63v36Ev,
  (VTBL_ENTRY)&_ZN6S266C63v37Ev,
  (VTBL_ENTRY)&_ZN6S266C63v38Ev,
  (VTBL_ENTRY)&_ZN6S266C63v39Ev,
  (VTBL_ENTRY)&_ZN6S266C63v40Ev,
  (VTBL_ENTRY)&_ZN6S266C63v41Ev,
  (VTBL_ENTRY)&_ZN6S266C63v42Ev,
  (VTBL_ENTRY)&_ZN6S266C63v43Ev,
  (VTBL_ENTRY)&_ZN6S266C63v44Ev,
  (VTBL_ENTRY)&_ZN6S266C63v45Ev,
  (VTBL_ENTRY)&_ZN6S266C63v46Ev,
  (VTBL_ENTRY)&_ZN6S266C63v47Ev,
  (VTBL_ENTRY)&_ZN6S266C63v48Ev,
  (VTBL_ENTRY)&_ZN6S266C63v49Ev,
  (VTBL_ENTRY)&_ZN6S266C63v50Ev,
  (VTBL_ENTRY)&_ZN6S266C63v51Ev,
  (VTBL_ENTRY)&_ZN6S266C63v52Ev,
  (VTBL_ENTRY)&_ZN6S266C63v53Ev,
  (VTBL_ENTRY)&_ZN6S266C63v54Ev,
  (VTBL_ENTRY)&_ZN6S266C63v55Ev,
  (VTBL_ENTRY)&_ZN6S266C63v56Ev,
  (VTBL_ENTRY)&_ZN6S266C63v57Ev,
  (VTBL_ENTRY)&_ZN6S266C63v58Ev,
  (VTBL_ENTRY)&_ZN6S266C63v59Ev,
  (VTBL_ENTRY)&_ZN6S266C63v60Ev,
  (VTBL_ENTRY)&_ZN6S266C63v61Ev,
  (VTBL_ENTRY)&_ZN6S266C63v62Ev,
  (VTBL_ENTRY)&_ZN6S266C63v63Ev,
  (VTBL_ENTRY)&_ZN6S266C63v64Ev,
  (VTBL_ENTRY)&_ZN6S266C63v65Ev,
  (VTBL_ENTRY)&_ZN6S266C63v66Ev,
  (VTBL_ENTRY)&_ZN6S266C63v67Ev,
  (VTBL_ENTRY)&_ZN6S266C63v68Ev,
  (VTBL_ENTRY)&_ZN6S266C63v69Ev,
  (VTBL_ENTRY)&_ZN6S266C53v70Ev,
  (VTBL_ENTRY)&_ZN6S266C53v71Ev,
  (VTBL_ENTRY)&_ZN6S266C53v72Ev,
  (VTBL_ENTRY)&_ZN6S266C53v73Ev,
  (VTBL_ENTRY)&_ZN6S266C53v74Ev,
  (VTBL_ENTRY)&_ZN6S266C53v75Ev,
  (VTBL_ENTRY)&_ZN6S266C53v76Ev,
  (VTBL_ENTRY)&_ZN6S266C53v77Ev,
  (VTBL_ENTRY)&_ZN6S266C53v78Ev,
  (VTBL_ENTRY)&_ZN6S266C53v79Ev,
  (VTBL_ENTRY)&_ZN6S266C53v80Ev,
  (VTBL_ENTRY)&_ZN6S266C53v81Ev,
  (VTBL_ENTRY)&_ZN6S266C53v82Ev,
  (VTBL_ENTRY)&_ZN6S266C53v83Ev,
  (VTBL_ENTRY)&_ZN6S266C53v84Ev,
  (VTBL_ENTRY)&_ZN6S266C53v85Ev,
  (VTBL_ENTRY)&_ZN6S266C53v86Ev,
  (VTBL_ENTRY)&_ZN6S266C53v87Ev,
  (VTBL_ENTRY)&_ZN6S266C53v88Ev,
  (VTBL_ENTRY)&_ZN6S266C53v89Ev,
  (VTBL_ENTRY)&_ZN6S266C53v90Ev,
  (VTBL_ENTRY)&_ZN6S266C53v91Ev,
  (VTBL_ENTRY)&_ZN6S266C43v92Ev,
  (VTBL_ENTRY)&_ZN6S266C43v93Ev,
  (VTBL_ENTRY)&_ZN6S266C43v94Ev,
  (VTBL_ENTRY)&_ZN6S266C43v95Ev,
  (VTBL_ENTRY)&_ZN6S266C43v96Ev,
  (VTBL_ENTRY)&_ZN6S266C43v97Ev,
  (VTBL_ENTRY)&_ZN6S266C43v98Ev,
  (VTBL_ENTRY)&_ZN6S266C43v99Ev,
  (VTBL_ENTRY)&_ZN6S266C44v100Ev,
  (VTBL_ENTRY)&_ZN6S266C44v101Ev,
  (VTBL_ENTRY)&_ZN6S266C44v102Ev,
  (VTBL_ENTRY)&_ZN6S266C44v103Ev,
  (VTBL_ENTRY)&_ZN6S266C44v104Ev,
  (VTBL_ENTRY)&_ZN6S266C44v105Ev,
  (VTBL_ENTRY)&_ZN6S266C44v106Ev,
  (VTBL_ENTRY)&_ZN6S266C44v107Ev,
  (VTBL_ENTRY)&_ZN6S266C44v108Ev,
  (VTBL_ENTRY)&_ZN6S266C44v109Ev,
  (VTBL_ENTRY)&_ZN6S266C44v110Ev,
  (VTBL_ENTRY)&_ZN6S266C44v111Ev,
  (VTBL_ENTRY)&_ZN6S266C34v112Ev,
  (VTBL_ENTRY)&_ZN6S266C34v113Ev,
  (VTBL_ENTRY)&_ZN6S266C34v114Ev,
  (VTBL_ENTRY)&_ZN6S266C34v115Ev,
  (VTBL_ENTRY)&_ZN6S266C34v116Ev,
  (VTBL_ENTRY)&_ZN6S266C34v117Ev,
  (VTBL_ENTRY)&_ZN6S266C34v118Ev,
  (VTBL_ENTRY)&_ZN6S266C34v119Ev,
  (VTBL_ENTRY)&_ZN6S266C34v120Ev,
  (VTBL_ENTRY)&_ZN6S266C34v121Ev,
  (VTBL_ENTRY)&_ZN6S266C34v122Ev,
  (VTBL_ENTRY)&_ZN6S266C34v123Ev,
  (VTBL_ENTRY)&_ZN6S266C34v124Ev,
  (VTBL_ENTRY)&_ZN6S266C34v125Ev,
  (VTBL_ENTRY)&_ZN6S266C24v126Ev,
  (VTBL_ENTRY)&_ZN6S266C24v127Ev,
  (VTBL_ENTRY)&_ZN6S266C24v128Ev,
  (VTBL_ENTRY)&_ZN6S266C24v129Ev,
  (VTBL_ENTRY)&_ZN6S266C24v130Ev,
  (VTBL_ENTRY)&_ZN6S266C24v131Ev,
  (VTBL_ENTRY)&_ZN6S266C24v132Ev,
  (VTBL_ENTRY)&_ZN6S266C24v133Ev,
  (VTBL_ENTRY)&_ZN6S266C24v134Ev,
  (VTBL_ENTRY)&_ZN6S266C24v135Ev,
  (VTBL_ENTRY)&_ZN6S266C24v136Ev,
  (VTBL_ENTRY)&_ZN6S266C12v1Ev,
  (VTBL_ENTRY)&_ZN6S266C12v2Ev,
  (VTBL_ENTRY)&_ZN6S266C12v3Ev,
  (VTBL_ENTRY)&_ZN6S266C12v4Ev,
  (VTBL_ENTRY)&_ZN6S266C12v5Ev,
  ABISELECT(-392,-280),
  (VTBL_ENTRY)&(_ZTI6S266C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn392_N6S266C1D1Ev,_ZThn280_N6S266C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn392_N6S266C1D0Ev,_ZThn280_N6S266C1D0Ev),
  (VTBL_ENTRY)&_ZN10S266C24_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S266C24_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S266C24_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S266C24_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S266C24_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S266C24_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S266C24_nt4v143Ev,
};
extern VTBL_ENTRY _ZTI6S266C1[];
extern  VTBL_ENTRY _ZTV6S266C1[];
Class_Descriptor cd_S266C1 = {  "S266C1", // class name
  bases_S266C1, 6,
  &(vtc_S266C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(400,284), // object size
  NSPAIRA(_ZTI6S266C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6S266C1),151, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S267C6  {
  int s267c6f0;
  __tsi64 s267c6f1;
  void *s267c6f2[4];
  int s267c6f3[2];
  void *s267c6f4;
  ::S3350C4_nt s267c6f5;
  void *s267c6f6[2];
  virtual  ~S267C6(); // _ZN6S267C6D1Ev
  virtual void  v6(); // _ZN6S267C62v6Ev
  virtual void  v7(); // _ZN6S267C62v7Ev
  virtual void  v8(); // _ZN6S267C62v8Ev
  virtual void  v9(); // _ZN6S267C62v9Ev
  virtual void  v10(); // _ZN6S267C63v10Ev
  virtual void  v11(); // _ZN6S267C63v11Ev
  virtual void  v12(); // _ZN6S267C63v12Ev
  virtual void  v13(); // _ZN6S267C63v13Ev
  virtual void  v14(); // _ZN6S267C63v14Ev
  virtual void  v15(); // _ZN6S267C63v15Ev
  virtual void  v16(); // _ZN6S267C63v16Ev
  virtual void  v17(); // _ZN6S267C63v17Ev
  virtual void  v18(); // _ZN6S267C63v18Ev
  virtual void  v19(); // _ZN6S267C63v19Ev
  virtual void  v20(); // _ZN6S267C63v20Ev
  virtual void  v21(); // _ZN6S267C63v21Ev
  virtual void  v22(); // _ZN6S267C63v22Ev
  virtual void  v23(); // _ZN6S267C63v23Ev
  virtual void  v24(); // _ZN6S267C63v24Ev
  virtual void  v25(); // _ZN6S267C63v25Ev
  virtual void  v26(); // _ZN6S267C63v26Ev
  virtual void  v27(); // _ZN6S267C63v27Ev
  virtual void  v28(); // _ZN6S267C63v28Ev
  virtual void  v29(); // _ZN6S267C63v29Ev
  virtual void  v30(); // _ZN6S267C63v30Ev
  virtual void  v31(); // _ZN6S267C63v31Ev
  virtual void  v32(); // _ZN6S267C63v32Ev
  virtual void  v33(); // _ZN6S267C63v33Ev
  virtual void  v34(); // _ZN6S267C63v34Ev
  virtual void  v35(); // _ZN6S267C63v35Ev
  virtual void  v36(); // _ZN6S267C63v36Ev
  virtual void  v37(); // _ZN6S267C63v37Ev
  virtual void  v38(); // _ZN6S267C63v38Ev
  virtual void  v39(); // _ZN6S267C63v39Ev
  virtual void  v40(); // _ZN6S267C63v40Ev
  virtual void  v41(); // _ZN6S267C63v41Ev
  virtual void  v42(); // _ZN6S267C63v42Ev
  virtual void  v43(); // _ZN6S267C63v43Ev
  virtual void  v44(); // _ZN6S267C63v44Ev
  virtual void  v45(); // _ZN6S267C63v45Ev
  virtual void  v46(); // _ZN6S267C63v46Ev
  virtual void  v47(); // _ZN6S267C63v47Ev
  virtual void  v48(); // _ZN6S267C63v48Ev
  virtual void  v49(); // _ZN6S267C63v49Ev
  virtual void  v50(); // _ZN6S267C63v50Ev
  virtual void  v51(); // _ZN6S267C63v51Ev
  virtual void  v52(); // _ZN6S267C63v52Ev
  virtual void  v53(); // _ZN6S267C63v53Ev
  virtual void  v54(); // _ZN6S267C63v54Ev
  virtual void  v55(); // _ZN6S267C63v55Ev
  virtual void  v56(); // _ZN6S267C63v56Ev
  virtual void  v57(); // _ZN6S267C63v57Ev
  virtual void  v58(); // _ZN6S267C63v58Ev
  virtual void  v59(); // _ZN6S267C63v59Ev
  virtual void  v60(); // _ZN6S267C63v60Ev
  virtual void  v61(); // _ZN6S267C63v61Ev
  virtual void  v62(); // _ZN6S267C63v62Ev
  virtual void  v63(); // _ZN6S267C63v63Ev
  virtual void  v64(); // _ZN6S267C63v64Ev
  virtual void  v65(); // _ZN6S267C63v65Ev
  virtual void  v66(); // _ZN6S267C63v66Ev
  virtual void  v67(); // _ZN6S267C63v67Ev
  virtual void  v68(); // _ZN6S267C63v68Ev
  virtual void  v69(); // _ZN6S267C63v69Ev
  S267C6(); // tgen
};
//SIG(-1 S267C6) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S267C6 ::~S267C6(){ note_dtor("S267C6", this);}
void  S267C6 ::v6(){vfunc_called(this, "_ZN6S267C62v6Ev");}
void  S267C6 ::v7(){vfunc_called(this, "_ZN6S267C62v7Ev");}
void  S267C6 ::v8(){vfunc_called(this, "_ZN6S267C62v8Ev");}
void  S267C6 ::v9(){vfunc_called(this, "_ZN6S267C62v9Ev");}
void  S267C6 ::v10(){vfunc_called(this, "_ZN6S267C63v10Ev");}
void  S267C6 ::v11(){vfunc_called(this, "_ZN6S267C63v11Ev");}
void  S267C6 ::v12(){vfunc_called(this, "_ZN6S267C63v12Ev");}
void  S267C6 ::v13(){vfunc_called(this, "_ZN6S267C63v13Ev");}
void  S267C6 ::v14(){vfunc_called(this, "_ZN6S267C63v14Ev");}
void  S267C6 ::v15(){vfunc_called(this, "_ZN6S267C63v15Ev");}
void  S267C6 ::v16(){vfunc_called(this, "_ZN6S267C63v16Ev");}
void  S267C6 ::v17(){vfunc_called(this, "_ZN6S267C63v17Ev");}
void  S267C6 ::v18(){vfunc_called(this, "_ZN6S267C63v18Ev");}
void  S267C6 ::v19(){vfunc_called(this, "_ZN6S267C63v19Ev");}
void  S267C6 ::v20(){vfunc_called(this, "_ZN6S267C63v20Ev");}
void  S267C6 ::v21(){vfunc_called(this, "_ZN6S267C63v21Ev");}
void  S267C6 ::v22(){vfunc_called(this, "_ZN6S267C63v22Ev");}
void  S267C6 ::v23(){vfunc_called(this, "_ZN6S267C63v23Ev");}
void  S267C6 ::v24(){vfunc_called(this, "_ZN6S267C63v24Ev");}
void  S267C6 ::v25(){vfunc_called(this, "_ZN6S267C63v25Ev");}
void  S267C6 ::v26(){vfunc_called(this, "_ZN6S267C63v26Ev");}
void  S267C6 ::v27(){vfunc_called(this, "_ZN6S267C63v27Ev");}
void  S267C6 ::v28(){vfunc_called(this, "_ZN6S267C63v28Ev");}
void  S267C6 ::v29(){vfunc_called(this, "_ZN6S267C63v29Ev");}
void  S267C6 ::v30(){vfunc_called(this, "_ZN6S267C63v30Ev");}
void  S267C6 ::v31(){vfunc_called(this, "_ZN6S267C63v31Ev");}
void  S267C6 ::v32(){vfunc_called(this, "_ZN6S267C63v32Ev");}
void  S267C6 ::v33(){vfunc_called(this, "_ZN6S267C63v33Ev");}
void  S267C6 ::v34(){vfunc_called(this, "_ZN6S267C63v34Ev");}
void  S267C6 ::v35(){vfunc_called(this, "_ZN6S267C63v35Ev");}
void  S267C6 ::v36(){vfunc_called(this, "_ZN6S267C63v36Ev");}
void  S267C6 ::v37(){vfunc_called(this, "_ZN6S267C63v37Ev");}
void  S267C6 ::v38(){vfunc_called(this, "_ZN6S267C63v38Ev");}
void  S267C6 ::v39(){vfunc_called(this, "_ZN6S267C63v39Ev");}
void  S267C6 ::v40(){vfunc_called(this, "_ZN6S267C63v40Ev");}
void  S267C6 ::v41(){vfunc_called(this, "_ZN6S267C63v41Ev");}
void  S267C6 ::v42(){vfunc_called(this, "_ZN6S267C63v42Ev");}
void  S267C6 ::v43(){vfunc_called(this, "_ZN6S267C63v43Ev");}
void  S267C6 ::v44(){vfunc_called(this, "_ZN6S267C63v44Ev");}
void  S267C6 ::v45(){vfunc_called(this, "_ZN6S267C63v45Ev");}
void  S267C6 ::v46(){vfunc_called(this, "_ZN6S267C63v46Ev");}
void  S267C6 ::v47(){vfunc_called(this, "_ZN6S267C63v47Ev");}
void  S267C6 ::v48(){vfunc_called(this, "_ZN6S267C63v48Ev");}
void  S267C6 ::v49(){vfunc_called(this, "_ZN6S267C63v49Ev");}
void  S267C6 ::v50(){vfunc_called(this, "_ZN6S267C63v50Ev");}
void  S267C6 ::v51(){vfunc_called(this, "_ZN6S267C63v51Ev");}
void  S267C6 ::v52(){vfunc_called(this, "_ZN6S267C63v52Ev");}
void  S267C6 ::v53(){vfunc_called(this, "_ZN6S267C63v53Ev");}
void  S267C6 ::v54(){vfunc_called(this, "_ZN6S267C63v54Ev");}
void  S267C6 ::v55(){vfunc_called(this, "_ZN6S267C63v55Ev");}
void  S267C6 ::v56(){vfunc_called(this, "_ZN6S267C63v56Ev");}
void  S267C6 ::v57(){vfunc_called(this, "_ZN6S267C63v57Ev");}
void  S267C6 ::v58(){vfunc_called(this, "_ZN6S267C63v58Ev");}
void  S267C6 ::v59(){vfunc_called(this, "_ZN6S267C63v59Ev");}
void  S267C6 ::v60(){vfunc_called(this, "_ZN6S267C63v60Ev");}
void  S267C6 ::v61(){vfunc_called(this, "_ZN6S267C63v61Ev");}
void  S267C6 ::v62(){vfunc_called(this, "_ZN6S267C63v62Ev");}
void  S267C6 ::v63(){vfunc_called(this, "_ZN6S267C63v63Ev");}
void  S267C6 ::v64(){vfunc_called(this, "_ZN6S267C63v64Ev");}
void  S267C6 ::v65(){vfunc_called(this, "_ZN6S267C63v65Ev");}
void  S267C6 ::v66(){vfunc_called(this, "_ZN6S267C63v66Ev");}
void  S267C6 ::v67(){vfunc_called(this, "_ZN6S267C63v67Ev");}
void  S267C6 ::v68(){vfunc_called(this, "_ZN6S267C63v68Ev");}
void  S267C6 ::v69(){vfunc_called(this, "_ZN6S267C63v69Ev");}
S267C6 ::S267C6(){ note_ctor("S267C6", this);} // tgen

static void Test_S267C6()
{
  extern Class_Descriptor cd_S267C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S267C6, buf);
    S267C6 *dp, &lv = *(dp=new (buf) S267C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S267C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S267C6)");
    check_field_offset(lv, s267c6f0, ABISELECT(8,4), "S267C6.s267c6f0");
    check_field_offset(lv, s267c6f1, ABISELECT(16,8), "S267C6.s267c6f1");
    check_field_offset(lv, s267c6f2, ABISELECT(24,16), "S267C6.s267c6f2");
    check_field_offset(lv, s267c6f3, ABISELECT(56,32), "S267C6.s267c6f3");
    check_field_offset(lv, s267c6f4, ABISELECT(64,40), "S267C6.s267c6f4");
    check_field_offset(lv, s267c6f5, ABISELECT(72,44), "S267C6.s267c6f5");
    check_field_offset(lv, s267c6f6, ABISELECT(80,52), "S267C6.s267c6f6");
    test_class_info(&lv, &cd_S267C6);
    dp->~S267C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS267C6(Test_S267C6, "S267C6", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S267C6C1Ev();
extern void _ZN6S267C6D1Ev();
Name_Map name_map_S267C6[] = {
  NSPAIR(_ZN6S267C6C1Ev),
  NSPAIR(_ZN6S267C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S267C6[];
extern void _ZN6S267C6D1Ev();
extern void _ZN6S267C6D0Ev();
extern void _ZN6S267C62v6Ev();
extern void _ZN6S267C62v7Ev();
extern void _ZN6S267C62v8Ev();
extern void _ZN6S267C62v9Ev();
extern void _ZN6S267C63v10Ev();
extern void _ZN6S267C63v11Ev();
extern void _ZN6S267C63v12Ev();
extern void _ZN6S267C63v13Ev();
extern void _ZN6S267C63v14Ev();
extern void _ZN6S267C63v15Ev();
extern void _ZN6S267C63v16Ev();
extern void _ZN6S267C63v17Ev();
extern void _ZN6S267C63v18Ev();
extern void _ZN6S267C63v19Ev();
extern void _ZN6S267C63v20Ev();
extern void _ZN6S267C63v21Ev();
extern void _ZN6S267C63v22Ev();
extern void _ZN6S267C63v23Ev();
extern void _ZN6S267C63v24Ev();
extern void _ZN6S267C63v25Ev();
extern void _ZN6S267C63v26Ev();
extern void _ZN6S267C63v27Ev();
extern void _ZN6S267C63v28Ev();
extern void _ZN6S267C63v29Ev();
extern void _ZN6S267C63v30Ev();
extern void _ZN6S267C63v31Ev();
extern void _ZN6S267C63v32Ev();
extern void _ZN6S267C63v33Ev();
extern void _ZN6S267C63v34Ev();
extern void _ZN6S267C63v35Ev();
extern void _ZN6S267C63v36Ev();
extern void _ZN6S267C63v37Ev();
extern void _ZN6S267C63v38Ev();
extern void _ZN6S267C63v39Ev();
extern void _ZN6S267C63v40Ev();
extern void _ZN6S267C63v41Ev();
extern void _ZN6S267C63v42Ev();
extern void _ZN6S267C63v43Ev();
extern void _ZN6S267C63v44Ev();
extern void _ZN6S267C63v45Ev();
extern void _ZN6S267C63v46Ev();
extern void _ZN6S267C63v47Ev();
extern void _ZN6S267C63v48Ev();
extern void _ZN6S267C63v49Ev();
extern void _ZN6S267C63v50Ev();
extern void _ZN6S267C63v51Ev();
extern void _ZN6S267C63v52Ev();
extern void _ZN6S267C63v53Ev();
extern void _ZN6S267C63v54Ev();
extern void _ZN6S267C63v55Ev();
extern void _ZN6S267C63v56Ev();
extern void _ZN6S267C63v57Ev();
extern void _ZN6S267C63v58Ev();
extern void _ZN6S267C63v59Ev();
extern void _ZN6S267C63v60Ev();
extern void _ZN6S267C63v61Ev();
extern void _ZN6S267C63v62Ev();
extern void _ZN6S267C63v63Ev();
extern void _ZN6S267C63v64Ev();
extern void _ZN6S267C63v65Ev();
extern void _ZN6S267C63v66Ev();
extern void _ZN6S267C63v67Ev();
extern void _ZN6S267C63v68Ev();
extern void _ZN6S267C63v69Ev();
static  VTBL_ENTRY vtc_S267C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S267C6[0]),
  (VTBL_ENTRY)&_ZN6S267C6D1Ev,
  (VTBL_ENTRY)&_ZN6S267C6D0Ev,
  (VTBL_ENTRY)&_ZN6S267C62v6Ev,
  (VTBL_ENTRY)&_ZN6S267C62v7Ev,
  (VTBL_ENTRY)&_ZN6S267C62v8Ev,
  (VTBL_ENTRY)&_ZN6S267C62v9Ev,
  (VTBL_ENTRY)&_ZN6S267C63v10Ev,
  (VTBL_ENTRY)&_ZN6S267C63v11Ev,
  (VTBL_ENTRY)&_ZN6S267C63v12Ev,
  (VTBL_ENTRY)&_ZN6S267C63v13Ev,
  (VTBL_ENTRY)&_ZN6S267C63v14Ev,
  (VTBL_ENTRY)&_ZN6S267C63v15Ev,
  (VTBL_ENTRY)&_ZN6S267C63v16Ev,
  (VTBL_ENTRY)&_ZN6S267C63v17Ev,
  (VTBL_ENTRY)&_ZN6S267C63v18Ev,
  (VTBL_ENTRY)&_ZN6S267C63v19Ev,
  (VTBL_ENTRY)&_ZN6S267C63v20Ev,
  (VTBL_ENTRY)&_ZN6S267C63v21Ev,
  (VTBL_ENTRY)&_ZN6S267C63v22Ev,
  (VTBL_ENTRY)&_ZN6S267C63v23Ev,
  (VTBL_ENTRY)&_ZN6S267C63v24Ev,
  (VTBL_ENTRY)&_ZN6S267C63v25Ev,
  (VTBL_ENTRY)&_ZN6S267C63v26Ev,
  (VTBL_ENTRY)&_ZN6S267C63v27Ev,
  (VTBL_ENTRY)&_ZN6S267C63v28Ev,
  (VTBL_ENTRY)&_ZN6S267C63v29Ev,
  (VTBL_ENTRY)&_ZN6S267C63v30Ev,
  (VTBL_ENTRY)&_ZN6S267C63v31Ev,
  (VTBL_ENTRY)&_ZN6S267C63v32Ev,
  (VTBL_ENTRY)&_ZN6S267C63v33Ev,
  (VTBL_ENTRY)&_ZN6S267C63v34Ev,
  (VTBL_ENTRY)&_ZN6S267C63v35Ev,
  (VTBL_ENTRY)&_ZN6S267C63v36Ev,
  (VTBL_ENTRY)&_ZN6S267C63v37Ev,
  (VTBL_ENTRY)&_ZN6S267C63v38Ev,
  (VTBL_ENTRY)&_ZN6S267C63v39Ev,
  (VTBL_ENTRY)&_ZN6S267C63v40Ev,
  (VTBL_ENTRY)&_ZN6S267C63v41Ev,
  (VTBL_ENTRY)&_ZN6S267C63v42Ev,
  (VTBL_ENTRY)&_ZN6S267C63v43Ev,
  (VTBL_ENTRY)&_ZN6S267C63v44Ev,
  (VTBL_ENTRY)&_ZN6S267C63v45Ev,
  (VTBL_ENTRY)&_ZN6S267C63v46Ev,
  (VTBL_ENTRY)&_ZN6S267C63v47Ev,
  (VTBL_ENTRY)&_ZN6S267C63v48Ev,
  (VTBL_ENTRY)&_ZN6S267C63v49Ev,
  (VTBL_ENTRY)&_ZN6S267C63v50Ev,
  (VTBL_ENTRY)&_ZN6S267C63v51Ev,
  (VTBL_ENTRY)&_ZN6S267C63v52Ev,
  (VTBL_ENTRY)&_ZN6S267C63v53Ev,
  (VTBL_ENTRY)&_ZN6S267C63v54Ev,
  (VTBL_ENTRY)&_ZN6S267C63v55Ev,
  (VTBL_ENTRY)&_ZN6S267C63v56Ev,
  (VTBL_ENTRY)&_ZN6S267C63v57Ev,
  (VTBL_ENTRY)&_ZN6S267C63v58Ev,
  (VTBL_ENTRY)&_ZN6S267C63v59Ev,
  (VTBL_ENTRY)&_ZN6S267C63v60Ev,
  (VTBL_ENTRY)&_ZN6S267C63v61Ev,
  (VTBL_ENTRY)&_ZN6S267C63v62Ev,
  (VTBL_ENTRY)&_ZN6S267C63v63Ev,
  (VTBL_ENTRY)&_ZN6S267C63v64Ev,
  (VTBL_ENTRY)&_ZN6S267C63v65Ev,
  (VTBL_ENTRY)&_ZN6S267C63v66Ev,
  (VTBL_ENTRY)&_ZN6S267C63v67Ev,
  (VTBL_ENTRY)&_ZN6S267C63v68Ev,
  (VTBL_ENTRY)&_ZN6S267C63v69Ev,
};
extern VTBL_ENTRY _ZTI6S267C6[];
extern  VTBL_ENTRY _ZTV6S267C6[];
Class_Descriptor cd_S267C6 = {  "S267C6", // class name
  0,0,//no base classes
  &(vtc_S267C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S267C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S267C6),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S267C5  : S267C6 {
  int s267c5f0[2];
  void *s267c5f1;
  int s267c5f2[2];
  ::S287C8_nt s267c5f3;
  ::S287C8_nt s267c5f4;
  ::S2121C38 s267c5f5;
  ::S287C8_nt s267c5f6;
  unsigned int s267c5f7:1;
  unsigned int s267c5f8:1;
  unsigned int s267c5f9:1;
  unsigned int s267c5f10:1;
  unsigned int s267c5f11:1;
  int s267c5f12[2];
  virtual  ~S267C5(); // _ZN6S267C5D1Ev
  virtual void  v70(); // _ZN6S267C53v70Ev
  virtual void  v71(); // _ZN6S267C53v71Ev
  virtual void  v72(); // _ZN6S267C53v72Ev
  virtual void  v73(); // _ZN6S267C53v73Ev
  virtual void  v74(); // _ZN6S267C53v74Ev
  virtual void  v75(); // _ZN6S267C53v75Ev
  virtual void  v76(); // _ZN6S267C53v76Ev
  virtual void  v77(); // _ZN6S267C53v77Ev
  virtual void  v78(); // _ZN6S267C53v78Ev
  virtual void  v79(); // _ZN6S267C53v79Ev
  virtual void  v80(); // _ZN6S267C53v80Ev
  virtual void  v81(); // _ZN6S267C53v81Ev
  virtual void  v82(); // _ZN6S267C53v82Ev
  virtual void  v83(); // _ZN6S267C53v83Ev
  virtual void  v84(); // _ZN6S267C53v84Ev
  virtual void  v85(); // _ZN6S267C53v85Ev
  virtual void  v86(); // _ZN6S267C53v86Ev
  virtual void  v87(); // _ZN6S267C53v87Ev
  virtual void  v88(); // _ZN6S267C53v88Ev
  virtual void  v89(); // _ZN6S267C53v89Ev
  virtual void  v90(); // _ZN6S267C53v90Ev
  virtual void  v91(); // _ZN6S267C53v91Ev
  S267C5(); // tgen
};
//SIG(-1 S267C5) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S267C5 ::~S267C5(){ note_dtor("S267C5", this);}
void  S267C5 ::v70(){vfunc_called(this, "_ZN6S267C53v70Ev");}
void  S267C5 ::v71(){vfunc_called(this, "_ZN6S267C53v71Ev");}
void  S267C5 ::v72(){vfunc_called(this, "_ZN6S267C53v72Ev");}
void  S267C5 ::v73(){vfunc_called(this, "_ZN6S267C53v73Ev");}
void  S267C5 ::v74(){vfunc_called(this, "_ZN6S267C53v74Ev");}
void  S267C5 ::v75(){vfunc_called(this, "_ZN6S267C53v75Ev");}
void  S267C5 ::v76(){vfunc_called(this, "_ZN6S267C53v76Ev");}
void  S267C5 ::v77(){vfunc_called(this, "_ZN6S267C53v77Ev");}
void  S267C5 ::v78(){vfunc_called(this, "_ZN6S267C53v78Ev");}
void  S267C5 ::v79(){vfunc_called(this, "_ZN6S267C53v79Ev");}
void  S267C5 ::v80(){vfunc_called(this, "_ZN6S267C53v80Ev");}
void  S267C5 ::v81(){vfunc_called(this, "_ZN6S267C53v81Ev");}
void  S267C5 ::v82(){vfunc_called(this, "_ZN6S267C53v82Ev");}
void  S267C5 ::v83(){vfunc_called(this, "_ZN6S267C53v83Ev");}
void  S267C5 ::v84(){vfunc_called(this, "_ZN6S267C53v84Ev");}
void  S267C5 ::v85(){vfunc_called(this, "_ZN6S267C53v85Ev");}
void  S267C5 ::v86(){vfunc_called(this, "_ZN6S267C53v86Ev");}
void  S267C5 ::v87(){vfunc_called(this, "_ZN6S267C53v87Ev");}
void  S267C5 ::v88(){vfunc_called(this, "_ZN6S267C53v88Ev");}
void  S267C5 ::v89(){vfunc_called(this, "_ZN6S267C53v89Ev");}
void  S267C5 ::v90(){vfunc_called(this, "_ZN6S267C53v90Ev");}
void  S267C5 ::v91(){vfunc_called(this, "_ZN6S267C53v91Ev");}
S267C5 ::S267C5(){ note_ctor("S267C5", this);} // tgen

static void Test_S267C5()
{
  extern Class_Descriptor cd_S267C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S267C5, buf);
    S267C5 *dp, &lv = *(dp=new (buf) S267C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S267C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S267C5)");
    check_base_class_offset(lv, (S267C6*), 0, "S267C5");
    check_field_offset(lv, s267c5f0, ABISELECT(96,60), "S267C5.s267c5f0");
    check_field_offset(lv, s267c5f1, ABISELECT(104,68), "S267C5.s267c5f1");
    check_field_offset(lv, s267c5f2, ABISELECT(112,72), "S267C5.s267c5f2");
    check_field_offset(lv, s267c5f3, ABISELECT(120,80), "S267C5.s267c5f3");
    check_field_offset(lv, s267c5f4, ABISELECT(136,92), "S267C5.s267c5f4");
    check_field_offset(lv, s267c5f5, ABISELECT(152,104), "S267C5.s267c5f5");
    check_field_offset(lv, s267c5f6, ABISELECT(160,108), "S267C5.s267c5f6");
    set_bf_and_test(lv, s267c5f7, ABISELECT(176,120), 0, 1, 1, "S267C5");
    set_bf_and_test(lv, s267c5f8, ABISELECT(176,120), 1, 1, 1, "S267C5");
    set_bf_and_test(lv, s267c5f9, ABISELECT(176,120), 2, 1, 1, "S267C5");
    set_bf_and_test(lv, s267c5f10, ABISELECT(176,120), 3, 1, 1, "S267C5");
    set_bf_and_test(lv, s267c5f11, ABISELECT(176,120), 4, 1, 1, "S267C5");
    check_field_offset(lv, s267c5f12, ABISELECT(180,124), "S267C5.s267c5f12");
    test_class_info(&lv, &cd_S267C5);
    dp->~S267C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS267C5(Test_S267C5, "S267C5", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN6S267C5C1Ev();
extern void _ZN6S267C5D1Ev();
Name_Map name_map_S267C5[] = {
  NSPAIR(_ZN6S267C5C1Ev),
  NSPAIR(_ZN6S267C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S267C6;
extern VTBL_ENTRY _ZTI6S267C6[];
extern  VTBL_ENTRY _ZTV6S267C6[];
static Base_Class bases_S267C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S267C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S267C5[];
extern void _ZN6S267C5D1Ev();
extern void _ZN6S267C5D0Ev();
extern void _ZN6S267C62v6Ev();
extern void _ZN6S267C62v7Ev();
extern void _ZN6S267C62v8Ev();
extern void _ZN6S267C62v9Ev();
extern void _ZN6S267C63v10Ev();
extern void _ZN6S267C63v11Ev();
extern void _ZN6S267C63v12Ev();
extern void _ZN6S267C63v13Ev();
extern void _ZN6S267C63v14Ev();
extern void _ZN6S267C63v15Ev();
extern void _ZN6S267C63v16Ev();
extern void _ZN6S267C63v17Ev();
extern void _ZN6S267C63v18Ev();
extern void _ZN6S267C63v19Ev();
extern void _ZN6S267C63v20Ev();
extern void _ZN6S267C63v21Ev();
extern void _ZN6S267C63v22Ev();
extern void _ZN6S267C63v23Ev();
extern void _ZN6S267C63v24Ev();
extern void _ZN6S267C63v25Ev();
extern void _ZN6S267C63v26Ev();
extern void _ZN6S267C63v27Ev();
extern void _ZN6S267C63v28Ev();
extern void _ZN6S267C63v29Ev();
extern void _ZN6S267C63v30Ev();
extern void _ZN6S267C63v31Ev();
extern void _ZN6S267C63v32Ev();
extern void _ZN6S267C63v33Ev();
extern void _ZN6S267C63v34Ev();
extern void _ZN6S267C63v35Ev();
extern void _ZN6S267C63v36Ev();
extern void _ZN6S267C63v37Ev();
extern void _ZN6S267C63v38Ev();
extern void _ZN6S267C63v39Ev();
extern void _ZN6S267C63v40Ev();
extern void _ZN6S267C63v41Ev();
extern void _ZN6S267C63v42Ev();
extern void _ZN6S267C63v43Ev();
extern void _ZN6S267C63v44Ev();
extern void _ZN6S267C63v45Ev();
extern void _ZN6S267C63v46Ev();
extern void _ZN6S267C63v47Ev();
extern void _ZN6S267C63v48Ev();
extern void _ZN6S267C63v49Ev();
extern void _ZN6S267C63v50Ev();
extern void _ZN6S267C63v51Ev();
extern void _ZN6S267C63v52Ev();
extern void _ZN6S267C63v53Ev();
extern void _ZN6S267C63v54Ev();
extern void _ZN6S267C63v55Ev();
extern void _ZN6S267C63v56Ev();
extern void _ZN6S267C63v57Ev();
extern void _ZN6S267C63v58Ev();
extern void _ZN6S267C63v59Ev();
extern void _ZN6S267C63v60Ev();
extern void _ZN6S267C63v61Ev();
extern void _ZN6S267C63v62Ev();
extern void _ZN6S267C63v63Ev();
extern void _ZN6S267C63v64Ev();
extern void _ZN6S267C63v65Ev();
extern void _ZN6S267C63v66Ev();
extern void _ZN6S267C63v67Ev();
extern void _ZN6S267C63v68Ev();
extern void _ZN6S267C63v69Ev();
extern void _ZN6S267C53v70Ev();
extern void _ZN6S267C53v71Ev();
extern void _ZN6S267C53v72Ev();
extern void _ZN6S267C53v73Ev();
extern void _ZN6S267C53v74Ev();
extern void _ZN6S267C53v75Ev();
extern void _ZN6S267C53v76Ev();
extern void _ZN6S267C53v77Ev();
extern void _ZN6S267C53v78Ev();
extern void _ZN6S267C53v79Ev();
extern void _ZN6S267C53v80Ev();
extern void _ZN6S267C53v81Ev();
extern void _ZN6S267C53v82Ev();
extern void _ZN6S267C53v83Ev();
extern void _ZN6S267C53v84Ev();
extern void _ZN6S267C53v85Ev();
extern void _ZN6S267C53v86Ev();
extern void _ZN6S267C53v87Ev();
extern void _ZN6S267C53v88Ev();
extern void _ZN6S267C53v89Ev();
extern void _ZN6S267C53v90Ev();
extern void _ZN6S267C53v91Ev();
static  VTBL_ENTRY vtc_S267C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S267C5[0]),
  (VTBL_ENTRY)&_ZN6S267C5D1Ev,
  (VTBL_ENTRY)&_ZN6S267C5D0Ev,
  (VTBL_ENTRY)&_ZN6S267C62v6Ev,
  (VTBL_ENTRY)&_ZN6S267C62v7Ev,
  (VTBL_ENTRY)&_ZN6S267C62v8Ev,
  (VTBL_ENTRY)&_ZN6S267C62v9Ev,
  (VTBL_ENTRY)&_ZN6S267C63v10Ev,
  (VTBL_ENTRY)&_ZN6S267C63v11Ev,
  (VTBL_ENTRY)&_ZN6S267C63v12Ev,
  (VTBL_ENTRY)&_ZN6S267C63v13Ev,
  (VTBL_ENTRY)&_ZN6S267C63v14Ev,
  (VTBL_ENTRY)&_ZN6S267C63v15Ev,
  (VTBL_ENTRY)&_ZN6S267C63v16Ev,
  (VTBL_ENTRY)&_ZN6S267C63v17Ev,
  (VTBL_ENTRY)&_ZN6S267C63v18Ev,
  (VTBL_ENTRY)&_ZN6S267C63v19Ev,
  (VTBL_ENTRY)&_ZN6S267C63v20Ev,
  (VTBL_ENTRY)&_ZN6S267C63v21Ev,
  (VTBL_ENTRY)&_ZN6S267C63v22Ev,
  (VTBL_ENTRY)&_ZN6S267C63v23Ev,
  (VTBL_ENTRY)&_ZN6S267C63v24Ev,
  (VTBL_ENTRY)&_ZN6S267C63v25Ev,
  (VTBL_ENTRY)&_ZN6S267C63v26Ev,
  (VTBL_ENTRY)&_ZN6S267C63v27Ev,
  (VTBL_ENTRY)&_ZN6S267C63v28Ev,
  (VTBL_ENTRY)&_ZN6S267C63v29Ev,
  (VTBL_ENTRY)&_ZN6S267C63v30Ev,
  (VTBL_ENTRY)&_ZN6S267C63v31Ev,
  (VTBL_ENTRY)&_ZN6S267C63v32Ev,
  (VTBL_ENTRY)&_ZN6S267C63v33Ev,
  (VTBL_ENTRY)&_ZN6S267C63v34Ev,
  (VTBL_ENTRY)&_ZN6S267C63v35Ev,
  (VTBL_ENTRY)&_ZN6S267C63v36Ev,
  (VTBL_ENTRY)&_ZN6S267C63v37Ev,
  (VTBL_ENTRY)&_ZN6S267C63v38Ev,
  (VTBL_ENTRY)&_ZN6S267C63v39Ev,
  (VTBL_ENTRY)&_ZN6S267C63v40Ev,
  (VTBL_ENTRY)&_ZN6S267C63v41Ev,
  (VTBL_ENTRY)&_ZN6S267C63v42Ev,
  (VTBL_ENTRY)&_ZN6S267C63v43Ev,
  (VTBL_ENTRY)&_ZN6S267C63v44Ev,
  (VTBL_ENTRY)&_ZN6S267C63v45Ev,
  (VTBL_ENTRY)&_ZN6S267C63v46Ev,
  (VTBL_ENTRY)&_ZN6S267C63v47Ev,
  (VTBL_ENTRY)&_ZN6S267C63v48Ev,
  (VTBL_ENTRY)&_ZN6S267C63v49Ev,
  (VTBL_ENTRY)&_ZN6S267C63v50Ev,
  (VTBL_ENTRY)&_ZN6S267C63v51Ev,
  (VTBL_ENTRY)&_ZN6S267C63v52Ev,
  (VTBL_ENTRY)&_ZN6S267C63v53Ev,
  (VTBL_ENTRY)&_ZN6S267C63v54Ev,
  (VTBL_ENTRY)&_ZN6S267C63v55Ev,
  (VTBL_ENTRY)&_ZN6S267C63v56Ev,
  (VTBL_ENTRY)&_ZN6S267C63v57Ev,
  (VTBL_ENTRY)&_ZN6S267C63v58Ev,
  (VTBL_ENTRY)&_ZN6S267C63v59Ev,
  (VTBL_ENTRY)&_ZN6S267C63v60Ev,
  (VTBL_ENTRY)&_ZN6S267C63v61Ev,
  (VTBL_ENTRY)&_ZN6S267C63v62Ev,
  (VTBL_ENTRY)&_ZN6S267C63v63Ev,
  (VTBL_ENTRY)&_ZN6S267C63v64Ev,
  (VTBL_ENTRY)&_ZN6S267C63v65Ev,
  (VTBL_ENTRY)&_ZN6S267C63v66Ev,
  (VTBL_ENTRY)&_ZN6S267C63v67Ev,
  (VTBL_ENTRY)&_ZN6S267C63v68Ev,
  (VTBL_ENTRY)&_ZN6S267C63v69Ev,
  (VTBL_ENTRY)&_ZN6S267C53v70Ev,
  (VTBL_ENTRY)&_ZN6S267C53v71Ev,
  (VTBL_ENTRY)&_ZN6S267C53v72Ev,
  (VTBL_ENTRY)&_ZN6S267C53v73Ev,
  (VTBL_ENTRY)&_ZN6S267C53v74Ev,
  (VTBL_ENTRY)&_ZN6S267C53v75Ev,
  (VTBL_ENTRY)&_ZN6S267C53v76Ev,
  (VTBL_ENTRY)&_ZN6S267C53v77Ev,
  (VTBL_ENTRY)&_ZN6S267C53v78Ev,
  (VTBL_ENTRY)&_ZN6S267C53v79Ev,
  (VTBL_ENTRY)&_ZN6S267C53v80Ev,
  (VTBL_ENTRY)&_ZN6S267C53v81Ev,
  (VTBL_ENTRY)&_ZN6S267C53v82Ev,
  (VTBL_ENTRY)&_ZN6S267C53v83Ev,
  (VTBL_ENTRY)&_ZN6S267C53v84Ev,
  (VTBL_ENTRY)&_ZN6S267C53v85Ev,
  (VTBL_ENTRY)&_ZN6S267C53v86Ev,
  (VTBL_ENTRY)&_ZN6S267C53v87Ev,
  (VTBL_ENTRY)&_ZN6S267C53v88Ev,
  (VTBL_ENTRY)&_ZN6S267C53v89Ev,
  (VTBL_ENTRY)&_ZN6S267C53v90Ev,
  (VTBL_ENTRY)&_ZN6S267C53v91Ev,
};
extern VTBL_ENTRY _ZTI6S267C5[];
extern  VTBL_ENTRY _ZTV6S267C5[];
Class_Descriptor cd_S267C5 = {  "S267C5", // class name
  bases_S267C5, 1,
  &(vtc_S267C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI6S267C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S267C5),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S267C4  : S267C5 {
  unsigned int s267c4f0:1;
  unsigned int s267c4f1:1;
  unsigned int s267c4f2:1;
  ::S3350C17 s267c4f3;
  ::S3350C11 s267c4f4;
  ::S3350C5_nt s267c4f5;
  ::S287C27 s267c4f6;
  int s267c4f7[3];
  virtual  ~S267C4(); // _ZN6S267C4D1Ev
  virtual void  v92(); // _ZN6S267C43v92Ev
  virtual void  v93(); // _ZN6S267C43v93Ev
  virtual void  v94(); // _ZN6S267C43v94Ev
  virtual void  v95(); // _ZN6S267C43v95Ev
  virtual void  v96(); // _ZN6S267C43v96Ev
  virtual void  v97(); // _ZN6S267C43v97Ev
  virtual void  v98(); // _ZN6S267C43v98Ev
  virtual void  v99(); // _ZN6S267C43v99Ev
  virtual void  v100(); // _ZN6S267C44v100Ev
  virtual void  v101(); // _ZN6S267C44v101Ev
  virtual void  v102(); // _ZN6S267C44v102Ev
  virtual void  v103(); // _ZN6S267C44v103Ev
  virtual void  v104(); // _ZN6S267C44v104Ev
  virtual void  v105(); // _ZN6S267C44v105Ev
  virtual void  v106(); // _ZN6S267C44v106Ev
  virtual void  v107(); // _ZN6S267C44v107Ev
  virtual void  v108(); // _ZN6S267C44v108Ev
  virtual void  v109(); // _ZN6S267C44v109Ev
  virtual void  v110(); // _ZN6S267C44v110Ev
  virtual void  v111(); // _ZN6S267C44v111Ev
  S267C4(); // tgen
};
//SIG(-1 S267C4) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} FC16{ BC17{ BC8}} Fi[3]}


 S267C4 ::~S267C4(){ note_dtor("S267C4", this);}
void  S267C4 ::v92(){vfunc_called(this, "_ZN6S267C43v92Ev");}
void  S267C4 ::v93(){vfunc_called(this, "_ZN6S267C43v93Ev");}
void  S267C4 ::v94(){vfunc_called(this, "_ZN6S267C43v94Ev");}
void  S267C4 ::v95(){vfunc_called(this, "_ZN6S267C43v95Ev");}
void  S267C4 ::v96(){vfunc_called(this, "_ZN6S267C43v96Ev");}
void  S267C4 ::v97(){vfunc_called(this, "_ZN6S267C43v97Ev");}
void  S267C4 ::v98(){vfunc_called(this, "_ZN6S267C43v98Ev");}
void  S267C4 ::v99(){vfunc_called(this, "_ZN6S267C43v99Ev");}
void  S267C4 ::v100(){vfunc_called(this, "_ZN6S267C44v100Ev");}
void  S267C4 ::v101(){vfunc_called(this, "_ZN6S267C44v101Ev");}
void  S267C4 ::v102(){vfunc_called(this, "_ZN6S267C44v102Ev");}
void  S267C4 ::v103(){vfunc_called(this, "_ZN6S267C44v103Ev");}
void  S267C4 ::v104(){vfunc_called(this, "_ZN6S267C44v104Ev");}
void  S267C4 ::v105(){vfunc_called(this, "_ZN6S267C44v105Ev");}
void  S267C4 ::v106(){vfunc_called(this, "_ZN6S267C44v106Ev");}
void  S267C4 ::v107(){vfunc_called(this, "_ZN6S267C44v107Ev");}
void  S267C4 ::v108(){vfunc_called(this, "_ZN6S267C44v108Ev");}
void  S267C4 ::v109(){vfunc_called(this, "_ZN6S267C44v109Ev");}
void  S267C4 ::v110(){vfunc_called(this, "_ZN6S267C44v110Ev");}
void  S267C4 ::v111(){vfunc_called(this, "_ZN6S267C44v111Ev");}
S267C4 ::S267C4(){ note_ctor("S267C4", this);} // tgen

static void Test_S267C4()
{
  extern Class_Descriptor cd_S267C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(35,50)];
    init_test(&cd_S267C4, buf);
    S267C4 *dp, &lv = *(dp=new (buf) S267C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,196), "sizeof(S267C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S267C4)");
    check_base_class_offset(lv, (S267C6*)(S267C5*), 0, "S267C4");
    check_base_class_offset(lv, (S267C5*), 0, "S267C4");
    set_bf_and_test(lv, s267c4f0, ABISELECT(188,132), 0, 1, 1, "S267C4");
    set_bf_and_test(lv, s267c4f1, ABISELECT(188,132), 1, 1, 1, "S267C4");
    set_bf_and_test(lv, s267c4f2, ABISELECT(188,132), 2, 1, 1, "S267C4");
    check_field_offset(lv, s267c4f3, ABISELECT(192,136), "S267C4.s267c4f3");
    check_field_offset(lv, s267c4f4, ABISELECT(208,148), "S267C4.s267c4f4");
    check_field_offset(lv, s267c4f5, ABISELECT(224,160), "S267C4.s267c4f5");
    check_field_offset(lv, s267c4f6, ABISELECT(240,172), "S267C4.s267c4f6");
    check_field_offset(lv, s267c4f7, ABISELECT(256,184), "S267C4.s267c4f7");
    test_class_info(&lv, &cd_S267C4);
    dp->~S267C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS267C4(Test_S267C4, "S267C4", ABISELECT(272,196));

#else // __cplusplus

extern void _ZN6S267C4C1Ev();
extern void _ZN6S267C4D1Ev();
Name_Map name_map_S267C4[] = {
  NSPAIR(_ZN6S267C4C1Ev),
  NSPAIR(_ZN6S267C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S267C6;
extern VTBL_ENTRY _ZTI6S267C6[];
extern  VTBL_ENTRY _ZTV6S267C6[];
extern Class_Descriptor cd_S267C5;
extern VTBL_ENTRY _ZTI6S267C5[];
extern  VTBL_ENTRY _ZTV6S267C5[];
static Base_Class bases_S267C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S267C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S267C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S267C4[];
extern void _ZN6S267C4D1Ev();
extern void _ZN6S267C4D0Ev();
extern void _ZN6S267C62v6Ev();
extern void _ZN6S267C62v7Ev();
extern void _ZN6S267C62v8Ev();
extern void _ZN6S267C62v9Ev();
extern void _ZN6S267C63v10Ev();
extern void _ZN6S267C63v11Ev();
extern void _ZN6S267C63v12Ev();
extern void _ZN6S267C63v13Ev();
extern void _ZN6S267C63v14Ev();
extern void _ZN6S267C63v15Ev();
extern void _ZN6S267C63v16Ev();
extern void _ZN6S267C63v17Ev();
extern void _ZN6S267C63v18Ev();
extern void _ZN6S267C63v19Ev();
extern void _ZN6S267C63v20Ev();
extern void _ZN6S267C63v21Ev();
extern void _ZN6S267C63v22Ev();
extern void _ZN6S267C63v23Ev();
extern void _ZN6S267C63v24Ev();
extern void _ZN6S267C63v25Ev();
extern void _ZN6S267C63v26Ev();
extern void _ZN6S267C63v27Ev();
extern void _ZN6S267C63v28Ev();
extern void _ZN6S267C63v29Ev();
extern void _ZN6S267C63v30Ev();
extern void _ZN6S267C63v31Ev();
extern void _ZN6S267C63v32Ev();
extern void _ZN6S267C63v33Ev();
extern void _ZN6S267C63v34Ev();
extern void _ZN6S267C63v35Ev();
extern void _ZN6S267C63v36Ev();
extern void _ZN6S267C63v37Ev();
extern void _ZN6S267C63v38Ev();
extern void _ZN6S267C63v39Ev();
extern void _ZN6S267C63v40Ev();
extern void _ZN6S267C63v41Ev();
extern void _ZN6S267C63v42Ev();
extern void _ZN6S267C63v43Ev();
extern void _ZN6S267C63v44Ev();
extern void _ZN6S267C63v45Ev();
extern void _ZN6S267C63v46Ev();
extern void _ZN6S267C63v47Ev();
extern void _ZN6S267C63v48Ev();
extern void _ZN6S267C63v49Ev();
extern void _ZN6S267C63v50Ev();
extern void _ZN6S267C63v51Ev();
extern void _ZN6S267C63v52Ev();
extern void _ZN6S267C63v53Ev();
extern void _ZN6S267C63v54Ev();
extern void _ZN6S267C63v55Ev();
extern void _ZN6S267C63v56Ev();
extern void _ZN6S267C63v57Ev();
extern void _ZN6S267C63v58Ev();
extern void _ZN6S267C63v59Ev();
extern void _ZN6S267C63v60Ev();
extern void _ZN6S267C63v61Ev();
extern void _ZN6S267C63v62Ev();
extern void _ZN6S267C63v63Ev();
extern void _ZN6S267C63v64Ev();
extern void _ZN6S267C63v65Ev();
extern void _ZN6S267C63v66Ev();
extern void _ZN6S267C63v67Ev();
extern void _ZN6S267C63v68Ev();
extern void _ZN6S267C63v69Ev();
extern void _ZN6S267C53v70Ev();
extern void _ZN6S267C53v71Ev();
extern void _ZN6S267C53v72Ev();
extern void _ZN6S267C53v73Ev();
extern void _ZN6S267C53v74Ev();
extern void _ZN6S267C53v75Ev();
extern void _ZN6S267C53v76Ev();
extern void _ZN6S267C53v77Ev();
extern void _ZN6S267C53v78Ev();
extern void _ZN6S267C53v79Ev();
extern void _ZN6S267C53v80Ev();
extern void _ZN6S267C53v81Ev();
extern void _ZN6S267C53v82Ev();
extern void _ZN6S267C53v83Ev();
extern void _ZN6S267C53v84Ev();
extern void _ZN6S267C53v85Ev();
extern void _ZN6S267C53v86Ev();
extern void _ZN6S267C53v87Ev();
extern void _ZN6S267C53v88Ev();
extern void _ZN6S267C53v89Ev();
extern void _ZN6S267C53v90Ev();
extern void _ZN6S267C53v91Ev();
extern void _ZN6S267C43v92Ev();
extern void _ZN6S267C43v93Ev();
extern void _ZN6S267C43v94Ev();
extern void _ZN6S267C43v95Ev();
extern void _ZN6S267C43v96Ev();
extern void _ZN6S267C43v97Ev();
extern void _ZN6S267C43v98Ev();
extern void _ZN6S267C43v99Ev();
extern void _ZN6S267C44v100Ev();
extern void _ZN6S267C44v101Ev();
extern void _ZN6S267C44v102Ev();
extern void _ZN6S267C44v103Ev();
extern void _ZN6S267C44v104Ev();
extern void _ZN6S267C44v105Ev();
extern void _ZN6S267C44v106Ev();
extern void _ZN6S267C44v107Ev();
extern void _ZN6S267C44v108Ev();
extern void _ZN6S267C44v109Ev();
extern void _ZN6S267C44v110Ev();
extern void _ZN6S267C44v111Ev();
static  VTBL_ENTRY vtc_S267C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S267C4[0]),
  (VTBL_ENTRY)&_ZN6S267C4D1Ev,
  (VTBL_ENTRY)&_ZN6S267C4D0Ev,
  (VTBL_ENTRY)&_ZN6S267C62v6Ev,
  (VTBL_ENTRY)&_ZN6S267C62v7Ev,
  (VTBL_ENTRY)&_ZN6S267C62v8Ev,
  (VTBL_ENTRY)&_ZN6S267C62v9Ev,
  (VTBL_ENTRY)&_ZN6S267C63v10Ev,
  (VTBL_ENTRY)&_ZN6S267C63v11Ev,
  (VTBL_ENTRY)&_ZN6S267C63v12Ev,
  (VTBL_ENTRY)&_ZN6S267C63v13Ev,
  (VTBL_ENTRY)&_ZN6S267C63v14Ev,
  (VTBL_ENTRY)&_ZN6S267C63v15Ev,
  (VTBL_ENTRY)&_ZN6S267C63v16Ev,
  (VTBL_ENTRY)&_ZN6S267C63v17Ev,
  (VTBL_ENTRY)&_ZN6S267C63v18Ev,
  (VTBL_ENTRY)&_ZN6S267C63v19Ev,
  (VTBL_ENTRY)&_ZN6S267C63v20Ev,
  (VTBL_ENTRY)&_ZN6S267C63v21Ev,
  (VTBL_ENTRY)&_ZN6S267C63v22Ev,
  (VTBL_ENTRY)&_ZN6S267C63v23Ev,
  (VTBL_ENTRY)&_ZN6S267C63v24Ev,
  (VTBL_ENTRY)&_ZN6S267C63v25Ev,
  (VTBL_ENTRY)&_ZN6S267C63v26Ev,
  (VTBL_ENTRY)&_ZN6S267C63v27Ev,
  (VTBL_ENTRY)&_ZN6S267C63v28Ev,
  (VTBL_ENTRY)&_ZN6S267C63v29Ev,
  (VTBL_ENTRY)&_ZN6S267C63v30Ev,
  (VTBL_ENTRY)&_ZN6S267C63v31Ev,
  (VTBL_ENTRY)&_ZN6S267C63v32Ev,
  (VTBL_ENTRY)&_ZN6S267C63v33Ev,
  (VTBL_ENTRY)&_ZN6S267C63v34Ev,
  (VTBL_ENTRY)&_ZN6S267C63v35Ev,
  (VTBL_ENTRY)&_ZN6S267C63v36Ev,
  (VTBL_ENTRY)&_ZN6S267C63v37Ev,
  (VTBL_ENTRY)&_ZN6S267C63v38Ev,
  (VTBL_ENTRY)&_ZN6S267C63v39Ev,
  (VTBL_ENTRY)&_ZN6S267C63v40Ev,
  (VTBL_ENTRY)&_ZN6S267C63v41Ev,
  (VTBL_ENTRY)&_ZN6S267C63v42Ev,
  (VTBL_ENTRY)&_ZN6S267C63v43Ev,
  (VTBL_ENTRY)&_ZN6S267C63v44Ev,
  (VTBL_ENTRY)&_ZN6S267C63v45Ev,
  (VTBL_ENTRY)&_ZN6S267C63v46Ev,
  (VTBL_ENTRY)&_ZN6S267C63v47Ev,
  (VTBL_ENTRY)&_ZN6S267C63v48Ev,
  (VTBL_ENTRY)&_ZN6S267C63v49Ev,
  (VTBL_ENTRY)&_ZN6S267C63v50Ev,
  (VTBL_ENTRY)&_ZN6S267C63v51Ev,
  (VTBL_ENTRY)&_ZN6S267C63v52Ev,
  (VTBL_ENTRY)&_ZN6S267C63v53Ev,
  (VTBL_ENTRY)&_ZN6S267C63v54Ev,
  (VTBL_ENTRY)&_ZN6S267C63v55Ev,
  (VTBL_ENTRY)&_ZN6S267C63v56Ev,
  (VTBL_ENTRY)&_ZN6S267C63v57Ev,
  (VTBL_ENTRY)&_ZN6S267C63v58Ev,
  (VTBL_ENTRY)&_ZN6S267C63v59Ev,
  (VTBL_ENTRY)&_ZN6S267C63v60Ev,
  (VTBL_ENTRY)&_ZN6S267C63v61Ev,
  (VTBL_ENTRY)&_ZN6S267C63v62Ev,
  (VTBL_ENTRY)&_ZN6S267C63v63Ev,
  (VTBL_ENTRY)&_ZN6S267C63v64Ev,
  (VTBL_ENTRY)&_ZN6S267C63v65Ev,
  (VTBL_ENTRY)&_ZN6S267C63v66Ev,
  (VTBL_ENTRY)&_ZN6S267C63v67Ev,
  (VTBL_ENTRY)&_ZN6S267C63v68Ev,
  (VTBL_ENTRY)&_ZN6S267C63v69Ev,
  (VTBL_ENTRY)&_ZN6S267C53v70Ev,
  (VTBL_ENTRY)&_ZN6S267C53v71Ev,
  (VTBL_ENTRY)&_ZN6S267C53v72Ev,
  (VTBL_ENTRY)&_ZN6S267C53v73Ev,
  (VTBL_ENTRY)&_ZN6S267C53v74Ev,
  (VTBL_ENTRY)&_ZN6S267C53v75Ev,
  (VTBL_ENTRY)&_ZN6S267C53v76Ev,
  (VTBL_ENTRY)&_ZN6S267C53v77Ev,
  (VTBL_ENTRY)&_ZN6S267C53v78Ev,
  (VTBL_ENTRY)&_ZN6S267C53v79Ev,
  (VTBL_ENTRY)&_ZN6S267C53v80Ev,
  (VTBL_ENTRY)&_ZN6S267C53v81Ev,
  (VTBL_ENTRY)&_ZN6S267C53v82Ev,
  (VTBL_ENTRY)&_ZN6S267C53v83Ev,
  (VTBL_ENTRY)&_ZN6S267C53v84Ev,
  (VTBL_ENTRY)&_ZN6S267C53v85Ev,
  (VTBL_ENTRY)&_ZN6S267C53v86Ev,
  (VTBL_ENTRY)&_ZN6S267C53v87Ev,
  (VTBL_ENTRY)&_ZN6S267C53v88Ev,
  (VTBL_ENTRY)&_ZN6S267C53v89Ev,
  (VTBL_ENTRY)&_ZN6S267C53v90Ev,
  (VTBL_ENTRY)&_ZN6S267C53v91Ev,
  (VTBL_ENTRY)&_ZN6S267C43v92Ev,
  (VTBL_ENTRY)&_ZN6S267C43v93Ev,
  (VTBL_ENTRY)&_ZN6S267C43v94Ev,
  (VTBL_ENTRY)&_ZN6S267C43v95Ev,
  (VTBL_ENTRY)&_ZN6S267C43v96Ev,
  (VTBL_ENTRY)&_ZN6S267C43v97Ev,
  (VTBL_ENTRY)&_ZN6S267C43v98Ev,
  (VTBL_ENTRY)&_ZN6S267C43v99Ev,
  (VTBL_ENTRY)&_ZN6S267C44v100Ev,
  (VTBL_ENTRY)&_ZN6S267C44v101Ev,
  (VTBL_ENTRY)&_ZN6S267C44v102Ev,
  (VTBL_ENTRY)&_ZN6S267C44v103Ev,
  (VTBL_ENTRY)&_ZN6S267C44v104Ev,
  (VTBL_ENTRY)&_ZN6S267C44v105Ev,
  (VTBL_ENTRY)&_ZN6S267C44v106Ev,
  (VTBL_ENTRY)&_ZN6S267C44v107Ev,
  (VTBL_ENTRY)&_ZN6S267C44v108Ev,
  (VTBL_ENTRY)&_ZN6S267C44v109Ev,
  (VTBL_ENTRY)&_ZN6S267C44v110Ev,
  (VTBL_ENTRY)&_ZN6S267C44v111Ev,
};
extern VTBL_ENTRY _ZTI6S267C4[];
extern  VTBL_ENTRY _ZTV6S267C4[];
Class_Descriptor cd_S267C4 = {  "S267C4", // class name
  bases_S267C4, 2,
  &(vtc_S267C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI6S267C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S267C4),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S267C3  : S267C4 {
  void *s267c3f0[2];
  int s267c3f1[4];
  unsigned int s267c3f2:1;
  unsigned int s267c3f3:1;
  unsigned int s267c3f4:1;
  char s267c3f5;
  int s267c3f6;
  unsigned int s267c3f7:1;
  ::S287C23 s267c3f8;
  virtual  ~S267C3(); // _ZN6S267C3D1Ev
  virtual void  v112(); // _ZN6S267C34v112Ev
  virtual void  v113(); // _ZN6S267C34v113Ev
  virtual void  v114(); // _ZN6S267C34v114Ev
  virtual void  v115(); // _ZN6S267C34v115Ev
  virtual void  v116(); // _ZN6S267C34v116Ev
  virtual void  v117(); // _ZN6S267C34v117Ev
  virtual void  v118(); // _ZN6S267C34v118Ev
  virtual void  v119(); // _ZN6S267C34v119Ev
  virtual void  v120(); // _ZN6S267C34v120Ev
  virtual void  v121(); // _ZN6S267C34v121Ev
  virtual void  v122(); // _ZN6S267C34v122Ev
  virtual void  v123(); // _ZN6S267C34v123Ev
  virtual void  v124(); // _ZN6S267C34v124Ev
  virtual void  v125(); // _ZN6S267C34v125Ev
  S267C3(); // tgen
};
//SIG(-1 S267C3) C1{ BC2{ BC3{ BC4{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} FC17{ BC18{ BC9}} Fi[3]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] Fi[4] Fi:1 Fi:1 Fi:1 Fc Fi Fi:1 FC19{ BC20{ BC9}}}


 S267C3 ::~S267C3(){ note_dtor("S267C3", this);}
void  S267C3 ::v112(){vfunc_called(this, "_ZN6S267C34v112Ev");}
void  S267C3 ::v113(){vfunc_called(this, "_ZN6S267C34v113Ev");}
void  S267C3 ::v114(){vfunc_called(this, "_ZN6S267C34v114Ev");}
void  S267C3 ::v115(){vfunc_called(this, "_ZN6S267C34v115Ev");}
void  S267C3 ::v116(){vfunc_called(this, "_ZN6S267C34v116Ev");}
void  S267C3 ::v117(){vfunc_called(this, "_ZN6S267C34v117Ev");}
void  S267C3 ::v118(){vfunc_called(this, "_ZN6S267C34v118Ev");}
void  S267C3 ::v119(){vfunc_called(this, "_ZN6S267C34v119Ev");}
void  S267C3 ::v120(){vfunc_called(this, "_ZN6S267C34v120Ev");}
void  S267C3 ::v121(){vfunc_called(this, "_ZN6S267C34v121Ev");}
void  S267C3 ::v122(){vfunc_called(this, "_ZN6S267C34v122Ev");}
void  S267C3 ::v123(){vfunc_called(this, "_ZN6S267C34v123Ev");}
void  S267C3 ::v124(){vfunc_called(this, "_ZN6S267C34v124Ev");}
void  S267C3 ::v125(){vfunc_called(this, "_ZN6S267C34v125Ev");}
S267C3 ::S267C3(){ note_ctor("S267C3", this);} // tgen

static void Test_S267C3()
{
  extern Class_Descriptor cd_S267C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(43,62)];
    init_test(&cd_S267C3, buf);
    S267C3 *dp, &lv = *(dp=new (buf) S267C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(336,244), "sizeof(S267C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S267C3)");
    check_base_class_offset(lv, (S267C6*)(S267C5*)(S267C4*), 0, "S267C3");
    check_base_class_offset(lv, (S267C5*)(S267C4*), 0, "S267C3");
    check_base_class_offset(lv, (S267C4*), 0, "S267C3");
    check_field_offset(lv, s267c3f0, ABISELECT(272,196), "S267C3.s267c3f0");
    check_field_offset(lv, s267c3f1, ABISELECT(288,204), "S267C3.s267c3f1");
    set_bf_and_test(lv, s267c3f2, ABISELECT(304,220), 0, 1, 1, "S267C3");
    set_bf_and_test(lv, s267c3f3, ABISELECT(304,220), 1, 1, 1, "S267C3");
    set_bf_and_test(lv, s267c3f4, ABISELECT(304,220), 2, 1, 1, "S267C3");
    check_field_offset(lv, s267c3f5, ABISELECT(305,221), "S267C3.s267c3f5");
    check_field_offset(lv, s267c3f6, ABISELECT(308,224), "S267C3.s267c3f6");
    set_bf_and_test(lv, s267c3f7, ABISELECT(312,228), 0, 1, 1, "S267C3");
    check_field_offset(lv, s267c3f8, ABISELECT(320,232), "S267C3.s267c3f8");
    test_class_info(&lv, &cd_S267C3);
    dp->~S267C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS267C3(Test_S267C3, "S267C3", ABISELECT(336,244));

#else // __cplusplus

extern void _ZN6S267C3C1Ev();
extern void _ZN6S267C3D1Ev();
Name_Map name_map_S267C3[] = {
  NSPAIR(_ZN6S267C3C1Ev),
  NSPAIR(_ZN6S267C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S267C6;
extern VTBL_ENTRY _ZTI6S267C6[];
extern  VTBL_ENTRY _ZTV6S267C6[];
extern Class_Descriptor cd_S267C5;
extern VTBL_ENTRY _ZTI6S267C5[];
extern  VTBL_ENTRY _ZTV6S267C5[];
extern Class_Descriptor cd_S267C4;
extern VTBL_ENTRY _ZTI6S267C4[];
extern  VTBL_ENTRY _ZTV6S267C4[];
static Base_Class bases_S267C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S267C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S267C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S267C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S267C3[];
extern void _ZN6S267C3D1Ev();
extern void _ZN6S267C3D0Ev();
extern void _ZN6S267C62v6Ev();
extern void _ZN6S267C62v7Ev();
extern void _ZN6S267C62v8Ev();
extern void _ZN6S267C62v9Ev();
extern void _ZN6S267C63v10Ev();
extern void _ZN6S267C63v11Ev();
extern void _ZN6S267C63v12Ev();
extern void _ZN6S267C63v13Ev();
extern void _ZN6S267C63v14Ev();
extern void _ZN6S267C63v15Ev();
extern void _ZN6S267C63v16Ev();
extern void _ZN6S267C63v17Ev();
extern void _ZN6S267C63v18Ev();
extern void _ZN6S267C63v19Ev();
extern void _ZN6S267C63v20Ev();
extern void _ZN6S267C63v21Ev();
extern void _ZN6S267C63v22Ev();
extern void _ZN6S267C63v23Ev();
extern void _ZN6S267C63v24Ev();
extern void _ZN6S267C63v25Ev();
extern void _ZN6S267C63v26Ev();
extern void _ZN6S267C63v27Ev();
extern void _ZN6S267C63v28Ev();
extern void _ZN6S267C63v29Ev();
extern void _ZN6S267C63v30Ev();
extern void _ZN6S267C63v31Ev();
extern void _ZN6S267C63v32Ev();
extern void _ZN6S267C63v33Ev();
extern void _ZN6S267C63v34Ev();
extern void _ZN6S267C63v35Ev();
extern void _ZN6S267C63v36Ev();
extern void _ZN6S267C63v37Ev();
extern void _ZN6S267C63v38Ev();
extern void _ZN6S267C63v39Ev();
extern void _ZN6S267C63v40Ev();
extern void _ZN6S267C63v41Ev();
extern void _ZN6S267C63v42Ev();
extern void _ZN6S267C63v43Ev();
extern void _ZN6S267C63v44Ev();
extern void _ZN6S267C63v45Ev();
extern void _ZN6S267C63v46Ev();
extern void _ZN6S267C63v47Ev();
extern void _ZN6S267C63v48Ev();
extern void _ZN6S267C63v49Ev();
extern void _ZN6S267C63v50Ev();
extern void _ZN6S267C63v51Ev();
extern void _ZN6S267C63v52Ev();
extern void _ZN6S267C63v53Ev();
extern void _ZN6S267C63v54Ev();
extern void _ZN6S267C63v55Ev();
extern void _ZN6S267C63v56Ev();
extern void _ZN6S267C63v57Ev();
extern void _ZN6S267C63v58Ev();
extern void _ZN6S267C63v59Ev();
extern void _ZN6S267C63v60Ev();
extern void _ZN6S267C63v61Ev();
extern void _ZN6S267C63v62Ev();
extern void _ZN6S267C63v63Ev();
extern void _ZN6S267C63v64Ev();
extern void _ZN6S267C63v65Ev();
extern void _ZN6S267C63v66Ev();
extern void _ZN6S267C63v67Ev();
extern void _ZN6S267C63v68Ev();
extern void _ZN6S267C63v69Ev();
extern void _ZN6S267C53v70Ev();
extern void _ZN6S267C53v71Ev();
extern void _ZN6S267C53v72Ev();
extern void _ZN6S267C53v73Ev();
extern void _ZN6S267C53v74Ev();
extern void _ZN6S267C53v75Ev();
extern void _ZN6S267C53v76Ev();
extern void _ZN6S267C53v77Ev();
extern void _ZN6S267C53v78Ev();
extern void _ZN6S267C53v79Ev();
extern void _ZN6S267C53v80Ev();
extern void _ZN6S267C53v81Ev();
extern void _ZN6S267C53v82Ev();
extern void _ZN6S267C53v83Ev();
extern void _ZN6S267C53v84Ev();
extern void _ZN6S267C53v85Ev();
extern void _ZN6S267C53v86Ev();
extern void _ZN6S267C53v87Ev();
extern void _ZN6S267C53v88Ev();
extern void _ZN6S267C53v89Ev();
extern void _ZN6S267C53v90Ev();
extern void _ZN6S267C53v91Ev();
extern void _ZN6S267C43v92Ev();
extern void _ZN6S267C43v93Ev();
extern void _ZN6S267C43v94Ev();
extern void _ZN6S267C43v95Ev();
extern void _ZN6S267C43v96Ev();
extern void _ZN6S267C43v97Ev();
extern void _ZN6S267C43v98Ev();
extern void _ZN6S267C43v99Ev();
extern void _ZN6S267C44v100Ev();
extern void _ZN6S267C44v101Ev();
extern void _ZN6S267C44v102Ev();
extern void _ZN6S267C44v103Ev();
extern void _ZN6S267C44v104Ev();
extern void _ZN6S267C44v105Ev();
extern void _ZN6S267C44v106Ev();
extern void _ZN6S267C44v107Ev();
extern void _ZN6S267C44v108Ev();
extern void _ZN6S267C44v109Ev();
extern void _ZN6S267C44v110Ev();
extern void _ZN6S267C44v111Ev();
extern void _ZN6S267C34v112Ev();
extern void _ZN6S267C34v113Ev();
extern void _ZN6S267C34v114Ev();
extern void _ZN6S267C34v115Ev();
extern void _ZN6S267C34v116Ev();
extern void _ZN6S267C34v117Ev();
extern void _ZN6S267C34v118Ev();
extern void _ZN6S267C34v119Ev();
extern void _ZN6S267C34v120Ev();
extern void _ZN6S267C34v121Ev();
extern void _ZN6S267C34v122Ev();
extern void _ZN6S267C34v123Ev();
extern void _ZN6S267C34v124Ev();
extern void _ZN6S267C34v125Ev();
static  VTBL_ENTRY vtc_S267C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S267C3[0]),
  (VTBL_ENTRY)&_ZN6S267C3D1Ev,
  (VTBL_ENTRY)&_ZN6S267C3D0Ev,
  (VTBL_ENTRY)&_ZN6S267C62v6Ev,
  (VTBL_ENTRY)&_ZN6S267C62v7Ev,
  (VTBL_ENTRY)&_ZN6S267C62v8Ev,
  (VTBL_ENTRY)&_ZN6S267C62v9Ev,
  (VTBL_ENTRY)&_ZN6S267C63v10Ev,
  (VTBL_ENTRY)&_ZN6S267C63v11Ev,
  (VTBL_ENTRY)&_ZN6S267C63v12Ev,
  (VTBL_ENTRY)&_ZN6S267C63v13Ev,
  (VTBL_ENTRY)&_ZN6S267C63v14Ev,
  (VTBL_ENTRY)&_ZN6S267C63v15Ev,
  (VTBL_ENTRY)&_ZN6S267C63v16Ev,
  (VTBL_ENTRY)&_ZN6S267C63v17Ev,
  (VTBL_ENTRY)&_ZN6S267C63v18Ev,
  (VTBL_ENTRY)&_ZN6S267C63v19Ev,
  (VTBL_ENTRY)&_ZN6S267C63v20Ev,
  (VTBL_ENTRY)&_ZN6S267C63v21Ev,
  (VTBL_ENTRY)&_ZN6S267C63v22Ev,
  (VTBL_ENTRY)&_ZN6S267C63v23Ev,
  (VTBL_ENTRY)&_ZN6S267C63v24Ev,
  (VTBL_ENTRY)&_ZN6S267C63v25Ev,
  (VTBL_ENTRY)&_ZN6S267C63v26Ev,
  (VTBL_ENTRY)&_ZN6S267C63v27Ev,
  (VTBL_ENTRY)&_ZN6S267C63v28Ev,
  (VTBL_ENTRY)&_ZN6S267C63v29Ev,
  (VTBL_ENTRY)&_ZN6S267C63v30Ev,
  (VTBL_ENTRY)&_ZN6S267C63v31Ev,
  (VTBL_ENTRY)&_ZN6S267C63v32Ev,
  (VTBL_ENTRY)&_ZN6S267C63v33Ev,
  (VTBL_ENTRY)&_ZN6S267C63v34Ev,
  (VTBL_ENTRY)&_ZN6S267C63v35Ev,
  (VTBL_ENTRY)&_ZN6S267C63v36Ev,
  (VTBL_ENTRY)&_ZN6S267C63v37Ev,
  (VTBL_ENTRY)&_ZN6S267C63v38Ev,
  (VTBL_ENTRY)&_ZN6S267C63v39Ev,
  (VTBL_ENTRY)&_ZN6S267C63v40Ev,
  (VTBL_ENTRY)&_ZN6S267C63v41Ev,
  (VTBL_ENTRY)&_ZN6S267C63v42Ev,
  (VTBL_ENTRY)&_ZN6S267C63v43Ev,
  (VTBL_ENTRY)&_ZN6S267C63v44Ev,
  (VTBL_ENTRY)&_ZN6S267C63v45Ev,
  (VTBL_ENTRY)&_ZN6S267C63v46Ev,
  (VTBL_ENTRY)&_ZN6S267C63v47Ev,
  (VTBL_ENTRY)&_ZN6S267C63v48Ev,
  (VTBL_ENTRY)&_ZN6S267C63v49Ev,
  (VTBL_ENTRY)&_ZN6S267C63v50Ev,
  (VTBL_ENTRY)&_ZN6S267C63v51Ev,
  (VTBL_ENTRY)&_ZN6S267C63v52Ev,
  (VTBL_ENTRY)&_ZN6S267C63v53Ev,
  (VTBL_ENTRY)&_ZN6S267C63v54Ev,
  (VTBL_ENTRY)&_ZN6S267C63v55Ev,
  (VTBL_ENTRY)&_ZN6S267C63v56Ev,
  (VTBL_ENTRY)&_ZN6S267C63v57Ev,
  (VTBL_ENTRY)&_ZN6S267C63v58Ev,
  (VTBL_ENTRY)&_ZN6S267C63v59Ev,
  (VTBL_ENTRY)&_ZN6S267C63v60Ev,
  (VTBL_ENTRY)&_ZN6S267C63v61Ev,
  (VTBL_ENTRY)&_ZN6S267C63v62Ev,
  (VTBL_ENTRY)&_ZN6S267C63v63Ev,
  (VTBL_ENTRY)&_ZN6S267C63v64Ev,
  (VTBL_ENTRY)&_ZN6S267C63v65Ev,
  (VTBL_ENTRY)&_ZN6S267C63v66Ev,
  (VTBL_ENTRY)&_ZN6S267C63v67Ev,
  (VTBL_ENTRY)&_ZN6S267C63v68Ev,
  (VTBL_ENTRY)&_ZN6S267C63v69Ev,
  (VTBL_ENTRY)&_ZN6S267C53v70Ev,
  (VTBL_ENTRY)&_ZN6S267C53v71Ev,
  (VTBL_ENTRY)&_ZN6S267C53v72Ev,
  (VTBL_ENTRY)&_ZN6S267C53v73Ev,
  (VTBL_ENTRY)&_ZN6S267C53v74Ev,
  (VTBL_ENTRY)&_ZN6S267C53v75Ev,
  (VTBL_ENTRY)&_ZN6S267C53v76Ev,
  (VTBL_ENTRY)&_ZN6S267C53v77Ev,
  (VTBL_ENTRY)&_ZN6S267C53v78Ev,
  (VTBL_ENTRY)&_ZN6S267C53v79Ev,
  (VTBL_ENTRY)&_ZN6S267C53v80Ev,
  (VTBL_ENTRY)&_ZN6S267C53v81Ev,
  (VTBL_ENTRY)&_ZN6S267C53v82Ev,
  (VTBL_ENTRY)&_ZN6S267C53v83Ev,
  (VTBL_ENTRY)&_ZN6S267C53v84Ev,
  (VTBL_ENTRY)&_ZN6S267C53v85Ev,
  (VTBL_ENTRY)&_ZN6S267C53v86Ev,
  (VTBL_ENTRY)&_ZN6S267C53v87Ev,
  (VTBL_ENTRY)&_ZN6S267C53v88Ev,
  (VTBL_ENTRY)&_ZN6S267C53v89Ev,
  (VTBL_ENTRY)&_ZN6S267C53v90Ev,
  (VTBL_ENTRY)&_ZN6S267C53v91Ev,
  (VTBL_ENTRY)&_ZN6S267C43v92Ev,
  (VTBL_ENTRY)&_ZN6S267C43v93Ev,
  (VTBL_ENTRY)&_ZN6S267C43v94Ev,
  (VTBL_ENTRY)&_ZN6S267C43v95Ev,
  (VTBL_ENTRY)&_ZN6S267C43v96Ev,
  (VTBL_ENTRY)&_ZN6S267C43v97Ev,
  (VTBL_ENTRY)&_ZN6S267C43v98Ev,
  (VTBL_ENTRY)&_ZN6S267C43v99Ev,
  (VTBL_ENTRY)&_ZN6S267C44v100Ev,
  (VTBL_ENTRY)&_ZN6S267C44v101Ev,
  (VTBL_ENTRY)&_ZN6S267C44v102Ev,
  (VTBL_ENTRY)&_ZN6S267C44v103Ev,
  (VTBL_ENTRY)&_ZN6S267C44v104Ev,
  (VTBL_ENTRY)&_ZN6S267C44v105Ev,
  (VTBL_ENTRY)&_ZN6S267C44v106Ev,
  (VTBL_ENTRY)&_ZN6S267C44v107Ev,
  (VTBL_ENTRY)&_ZN6S267C44v108Ev,
  (VTBL_ENTRY)&_ZN6S267C44v109Ev,
  (VTBL_ENTRY)&_ZN6S267C44v110Ev,
  (VTBL_ENTRY)&_ZN6S267C44v111Ev,
  (VTBL_ENTRY)&_ZN6S267C34v112Ev,
  (VTBL_ENTRY)&_ZN6S267C34v113Ev,
  (VTBL_ENTRY)&_ZN6S267C34v114Ev,
  (VTBL_ENTRY)&_ZN6S267C34v115Ev,
  (VTBL_ENTRY)&_ZN6S267C34v116Ev,
  (VTBL_ENTRY)&_ZN6S267C34v117Ev,
  (VTBL_ENTRY)&_ZN6S267C34v118Ev,
  (VTBL_ENTRY)&_ZN6S267C34v119Ev,
  (VTBL_ENTRY)&_ZN6S267C34v120Ev,
  (VTBL_ENTRY)&_ZN6S267C34v121Ev,
  (VTBL_ENTRY)&_ZN6S267C34v122Ev,
  (VTBL_ENTRY)&_ZN6S267C34v123Ev,
  (VTBL_ENTRY)&_ZN6S267C34v124Ev,
  (VTBL_ENTRY)&_ZN6S267C34v125Ev,
};
extern VTBL_ENTRY _ZTI6S267C3[];
extern  VTBL_ENTRY _ZTV6S267C3[];
Class_Descriptor cd_S267C3 = {  "S267C3", // class name
  bases_S267C3, 3,
  &(vtc_S267C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(336,244), // object size
  NSPAIRA(_ZTI6S267C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S267C3),124, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S267C2  : S267C3 {
  void *s267c2f0[2];
  ::S287C8_nt s267c2f1;
  unsigned int s267c2f2:1;
  unsigned int s267c2f3:1;
  ::S3350C21_nt s267c2f4;
  virtual  ~S267C2(); // _ZN6S267C2D1Ev
  virtual void  v126(); // _ZN6S267C24v126Ev
  virtual void  v127(); // _ZN6S267C24v127Ev
  virtual void  v128(); // _ZN6S267C24v128Ev
  virtual void  v129(); // _ZN6S267C24v129Ev
  virtual void  v130(); // _ZN6S267C24v130Ev
  virtual void  v131(); // _ZN6S267C24v131Ev
  virtual void  v132(); // _ZN6S267C24v132Ev
  virtual void  v133(); // _ZN6S267C24v133Ev
  virtual void  v134(); // _ZN6S267C24v134Ev
  virtual void  v135(); // _ZN6S267C24v135Ev
  virtual void  v136(); // _ZN6S267C24v136Ev
  S267C2(); // tgen
};
//SIG(-1 S267C2) C1{ BC2{ BC3{ BC4{ BC5{ vd v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} FC18{ BC19{ BC10}} Fi[3]} vd v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 Fp[2] Fi[4] Fi:1 Fi:1 Fi:1 Fc Fi Fi:1 FC20{ BC21{ BC10}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 Fp[2] FC7 Fi:1 Fi:1 FC22{ m Fp FC6}}


 S267C2 ::~S267C2(){ note_dtor("S267C2", this);}
void  S267C2 ::v126(){vfunc_called(this, "_ZN6S267C24v126Ev");}
void  S267C2 ::v127(){vfunc_called(this, "_ZN6S267C24v127Ev");}
void  S267C2 ::v128(){vfunc_called(this, "_ZN6S267C24v128Ev");}
void  S267C2 ::v129(){vfunc_called(this, "_ZN6S267C24v129Ev");}
void  S267C2 ::v130(){vfunc_called(this, "_ZN6S267C24v130Ev");}
void  S267C2 ::v131(){vfunc_called(this, "_ZN6S267C24v131Ev");}
void  S267C2 ::v132(){vfunc_called(this, "_ZN6S267C24v132Ev");}
void  S267C2 ::v133(){vfunc_called(this, "_ZN6S267C24v133Ev");}
void  S267C2 ::v134(){vfunc_called(this, "_ZN6S267C24v134Ev");}
void  S267C2 ::v135(){vfunc_called(this, "_ZN6S267C24v135Ev");}
void  S267C2 ::v136(){vfunc_called(this, "_ZN6S267C24v136Ev");}
S267C2 ::S267C2(){ note_ctor("S267C2", this);} // tgen

static void Test_S267C2()
{
  extern Class_Descriptor cd_S267C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(50,71)];
    init_test(&cd_S267C2, buf);
    S267C2 *dp, &lv = *(dp=new (buf) S267C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(392,280), "sizeof(S267C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S267C2)");
    check_base_class_offset(lv, (S267C6*)(S267C5*)(S267C4*)(S267C3*), 0, "S267C2");
    check_base_class_offset(lv, (S267C5*)(S267C4*)(S267C3*), 0, "S267C2");
    check_base_class_offset(lv, (S267C4*)(S267C3*), 0, "S267C2");
    check_base_class_offset(lv, (S267C3*), 0, "S267C2");
    check_field_offset(lv, s267c2f0, ABISELECT(336,244), "S267C2.s267c2f0");
    check_field_offset(lv, s267c2f1, ABISELECT(352,252), "S267C2.s267c2f1");
    set_bf_and_test(lv, s267c2f2, ABISELECT(368,264), 0, 1, 1, "S267C2");
    set_bf_and_test(lv, s267c2f3, ABISELECT(368,264), 1, 1, 1, "S267C2");
    check_field_offset(lv, s267c2f4, ABISELECT(376,268), "S267C2.s267c2f4");
    test_class_info(&lv, &cd_S267C2);
    dp->~S267C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS267C2(Test_S267C2, "S267C2", ABISELECT(392,280));

#else // __cplusplus

extern void _ZN6S267C2C1Ev();
extern void _ZN6S267C2D1Ev();
Name_Map name_map_S267C2[] = {
  NSPAIR(_ZN6S267C2C1Ev),
  NSPAIR(_ZN6S267C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S267C6;
extern VTBL_ENTRY _ZTI6S267C6[];
extern  VTBL_ENTRY _ZTV6S267C6[];
extern Class_Descriptor cd_S267C5;
extern VTBL_ENTRY _ZTI6S267C5[];
extern  VTBL_ENTRY _ZTV6S267C5[];
extern Class_Descriptor cd_S267C4;
extern VTBL_ENTRY _ZTI6S267C4[];
extern  VTBL_ENTRY _ZTV6S267C4[];
extern Class_Descriptor cd_S267C3;
extern VTBL_ENTRY _ZTI6S267C3[];
extern  VTBL_ENTRY _ZTV6S267C3[];
static Base_Class bases_S267C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S267C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S267C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S267C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S267C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S267C2[];
extern void _ZN6S267C2D1Ev();
extern void _ZN6S267C2D0Ev();
extern void _ZN6S267C62v6Ev();
extern void _ZN6S267C62v7Ev();
extern void _ZN6S267C62v8Ev();
extern void _ZN6S267C62v9Ev();
extern void _ZN6S267C63v10Ev();
extern void _ZN6S267C63v11Ev();
extern void _ZN6S267C63v12Ev();
extern void _ZN6S267C63v13Ev();
extern void _ZN6S267C63v14Ev();
extern void _ZN6S267C63v15Ev();
extern void _ZN6S267C63v16Ev();
extern void _ZN6S267C63v17Ev();
extern void _ZN6S267C63v18Ev();
extern void _ZN6S267C63v19Ev();
extern void _ZN6S267C63v20Ev();
extern void _ZN6S267C63v21Ev();
extern void _ZN6S267C63v22Ev();
extern void _ZN6S267C63v23Ev();
extern void _ZN6S267C63v24Ev();
extern void _ZN6S267C63v25Ev();
extern void _ZN6S267C63v26Ev();
extern void _ZN6S267C63v27Ev();
extern void _ZN6S267C63v28Ev();
extern void _ZN6S267C63v29Ev();
extern void _ZN6S267C63v30Ev();
extern void _ZN6S267C63v31Ev();
extern void _ZN6S267C63v32Ev();
extern void _ZN6S267C63v33Ev();
extern void _ZN6S267C63v34Ev();
extern void _ZN6S267C63v35Ev();
extern void _ZN6S267C63v36Ev();
extern void _ZN6S267C63v37Ev();
extern void _ZN6S267C63v38Ev();
extern void _ZN6S267C63v39Ev();
extern void _ZN6S267C63v40Ev();
extern void _ZN6S267C63v41Ev();
extern void _ZN6S267C63v42Ev();
extern void _ZN6S267C63v43Ev();
extern void _ZN6S267C63v44Ev();
extern void _ZN6S267C63v45Ev();
extern void _ZN6S267C63v46Ev();
extern void _ZN6S267C63v47Ev();
extern void _ZN6S267C63v48Ev();
extern void _ZN6S267C63v49Ev();
extern void _ZN6S267C63v50Ev();
extern void _ZN6S267C63v51Ev();
extern void _ZN6S267C63v52Ev();
extern void _ZN6S267C63v53Ev();
extern void _ZN6S267C63v54Ev();
extern void _ZN6S267C63v55Ev();
extern void _ZN6S267C63v56Ev();
extern void _ZN6S267C63v57Ev();
extern void _ZN6S267C63v58Ev();
extern void _ZN6S267C63v59Ev();
extern void _ZN6S267C63v60Ev();
extern void _ZN6S267C63v61Ev();
extern void _ZN6S267C63v62Ev();
extern void _ZN6S267C63v63Ev();
extern void _ZN6S267C63v64Ev();
extern void _ZN6S267C63v65Ev();
extern void _ZN6S267C63v66Ev();
extern void _ZN6S267C63v67Ev();
extern void _ZN6S267C63v68Ev();
extern void _ZN6S267C63v69Ev();
extern void _ZN6S267C53v70Ev();
extern void _ZN6S267C53v71Ev();
extern void _ZN6S267C53v72Ev();
extern void _ZN6S267C53v73Ev();
extern void _ZN6S267C53v74Ev();
extern void _ZN6S267C53v75Ev();
extern void _ZN6S267C53v76Ev();
extern void _ZN6S267C53v77Ev();
extern void _ZN6S267C53v78Ev();
extern void _ZN6S267C53v79Ev();
extern void _ZN6S267C53v80Ev();
extern void _ZN6S267C53v81Ev();
extern void _ZN6S267C53v82Ev();
extern void _ZN6S267C53v83Ev();
extern void _ZN6S267C53v84Ev();
extern void _ZN6S267C53v85Ev();
extern void _ZN6S267C53v86Ev();
extern void _ZN6S267C53v87Ev();
extern void _ZN6S267C53v88Ev();
extern void _ZN6S267C53v89Ev();
extern void _ZN6S267C53v90Ev();
extern void _ZN6S267C53v91Ev();
extern void _ZN6S267C43v92Ev();
extern void _ZN6S267C43v93Ev();
extern void _ZN6S267C43v94Ev();
extern void _ZN6S267C43v95Ev();
extern void _ZN6S267C43v96Ev();
extern void _ZN6S267C43v97Ev();
extern void _ZN6S267C43v98Ev();
extern void _ZN6S267C43v99Ev();
extern void _ZN6S267C44v100Ev();
extern void _ZN6S267C44v101Ev();
extern void _ZN6S267C44v102Ev();
extern void _ZN6S267C44v103Ev();
extern void _ZN6S267C44v104Ev();
extern void _ZN6S267C44v105Ev();
extern void _ZN6S267C44v106Ev();
extern void _ZN6S267C44v107Ev();
extern void _ZN6S267C44v108Ev();
extern void _ZN6S267C44v109Ev();
extern void _ZN6S267C44v110Ev();
extern void _ZN6S267C44v111Ev();
extern void _ZN6S267C34v112Ev();
extern void _ZN6S267C34v113Ev();
extern void _ZN6S267C34v114Ev();
extern void _ZN6S267C34v115Ev();
extern void _ZN6S267C34v116Ev();
extern void _ZN6S267C34v117Ev();
extern void _ZN6S267C34v118Ev();
extern void _ZN6S267C34v119Ev();
extern void _ZN6S267C34v120Ev();
extern void _ZN6S267C34v121Ev();
extern void _ZN6S267C34v122Ev();
extern void _ZN6S267C34v123Ev();
extern void _ZN6S267C34v124Ev();
extern void _ZN6S267C34v125Ev();
extern void _ZN6S267C24v126Ev();
extern void _ZN6S267C24v127Ev();
extern void _ZN6S267C24v128Ev();
extern void _ZN6S267C24v129Ev();
extern void _ZN6S267C24v130Ev();
extern void _ZN6S267C24v131Ev();
extern void _ZN6S267C24v132Ev();
extern void _ZN6S267C24v133Ev();
extern void _ZN6S267C24v134Ev();
extern void _ZN6S267C24v135Ev();
extern void _ZN6S267C24v136Ev();
static  VTBL_ENTRY vtc_S267C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S267C2[0]),
  (VTBL_ENTRY)&_ZN6S267C2D1Ev,
  (VTBL_ENTRY)&_ZN6S267C2D0Ev,
  (VTBL_ENTRY)&_ZN6S267C62v6Ev,
  (VTBL_ENTRY)&_ZN6S267C62v7Ev,
  (VTBL_ENTRY)&_ZN6S267C62v8Ev,
  (VTBL_ENTRY)&_ZN6S267C62v9Ev,
  (VTBL_ENTRY)&_ZN6S267C63v10Ev,
  (VTBL_ENTRY)&_ZN6S267C63v11Ev,
  (VTBL_ENTRY)&_ZN6S267C63v12Ev,
  (VTBL_ENTRY)&_ZN6S267C63v13Ev,
  (VTBL_ENTRY)&_ZN6S267C63v14Ev,
  (VTBL_ENTRY)&_ZN6S267C63v15Ev,
  (VTBL_ENTRY)&_ZN6S267C63v16Ev,
  (VTBL_ENTRY)&_ZN6S267C63v17Ev,
  (VTBL_ENTRY)&_ZN6S267C63v18Ev,
  (VTBL_ENTRY)&_ZN6S267C63v19Ev,
  (VTBL_ENTRY)&_ZN6S267C63v20Ev,
  (VTBL_ENTRY)&_ZN6S267C63v21Ev,
  (VTBL_ENTRY)&_ZN6S267C63v22Ev,
  (VTBL_ENTRY)&_ZN6S267C63v23Ev,
  (VTBL_ENTRY)&_ZN6S267C63v24Ev,
  (VTBL_ENTRY)&_ZN6S267C63v25Ev,
  (VTBL_ENTRY)&_ZN6S267C63v26Ev,
  (VTBL_ENTRY)&_ZN6S267C63v27Ev,
  (VTBL_ENTRY)&_ZN6S267C63v28Ev,
  (VTBL_ENTRY)&_ZN6S267C63v29Ev,
  (VTBL_ENTRY)&_ZN6S267C63v30Ev,
  (VTBL_ENTRY)&_ZN6S267C63v31Ev,
  (VTBL_ENTRY)&_ZN6S267C63v32Ev,
  (VTBL_ENTRY)&_ZN6S267C63v33Ev,
  (VTBL_ENTRY)&_ZN6S267C63v34Ev,
  (VTBL_ENTRY)&_ZN6S267C63v35Ev,
  (VTBL_ENTRY)&_ZN6S267C63v36Ev,
  (VTBL_ENTRY)&_ZN6S267C63v37Ev,
  (VTBL_ENTRY)&_ZN6S267C63v38Ev,
  (VTBL_ENTRY)&_ZN6S267C63v39Ev,
  (VTBL_ENTRY)&_ZN6S267C63v40Ev,
  (VTBL_ENTRY)&_ZN6S267C63v41Ev,
  (VTBL_ENTRY)&_ZN6S267C63v42Ev,
  (VTBL_ENTRY)&_ZN6S267C63v43Ev,
  (VTBL_ENTRY)&_ZN6S267C63v44Ev,
  (VTBL_ENTRY)&_ZN6S267C63v45Ev,
  (VTBL_ENTRY)&_ZN6S267C63v46Ev,
  (VTBL_ENTRY)&_ZN6S267C63v47Ev,
  (VTBL_ENTRY)&_ZN6S267C63v48Ev,
  (VTBL_ENTRY)&_ZN6S267C63v49Ev,
  (VTBL_ENTRY)&_ZN6S267C63v50Ev,
  (VTBL_ENTRY)&_ZN6S267C63v51Ev,
  (VTBL_ENTRY)&_ZN6S267C63v52Ev,
  (VTBL_ENTRY)&_ZN6S267C63v53Ev,
  (VTBL_ENTRY)&_ZN6S267C63v54Ev,
  (VTBL_ENTRY)&_ZN6S267C63v55Ev,
  (VTBL_ENTRY)&_ZN6S267C63v56Ev,
  (VTBL_ENTRY)&_ZN6S267C63v57Ev,
  (VTBL_ENTRY)&_ZN6S267C63v58Ev,
  (VTBL_ENTRY)&_ZN6S267C63v59Ev,
  (VTBL_ENTRY)&_ZN6S267C63v60Ev,
  (VTBL_ENTRY)&_ZN6S267C63v61Ev,
  (VTBL_ENTRY)&_ZN6S267C63v62Ev,
  (VTBL_ENTRY)&_ZN6S267C63v63Ev,
  (VTBL_ENTRY)&_ZN6S267C63v64Ev,
  (VTBL_ENTRY)&_ZN6S267C63v65Ev,
  (VTBL_ENTRY)&_ZN6S267C63v66Ev,
  (VTBL_ENTRY)&_ZN6S267C63v67Ev,
  (VTBL_ENTRY)&_ZN6S267C63v68Ev,
  (VTBL_ENTRY)&_ZN6S267C63v69Ev,
  (VTBL_ENTRY)&_ZN6S267C53v70Ev,
  (VTBL_ENTRY)&_ZN6S267C53v71Ev,
  (VTBL_ENTRY)&_ZN6S267C53v72Ev,
  (VTBL_ENTRY)&_ZN6S267C53v73Ev,
  (VTBL_ENTRY)&_ZN6S267C53v74Ev,
  (VTBL_ENTRY)&_ZN6S267C53v75Ev,
  (VTBL_ENTRY)&_ZN6S267C53v76Ev,
  (VTBL_ENTRY)&_ZN6S267C53v77Ev,
  (VTBL_ENTRY)&_ZN6S267C53v78Ev,
  (VTBL_ENTRY)&_ZN6S267C53v79Ev,
  (VTBL_ENTRY)&_ZN6S267C53v80Ev,
  (VTBL_ENTRY)&_ZN6S267C53v81Ev,
  (VTBL_ENTRY)&_ZN6S267C53v82Ev,
  (VTBL_ENTRY)&_ZN6S267C53v83Ev,
  (VTBL_ENTRY)&_ZN6S267C53v84Ev,
  (VTBL_ENTRY)&_ZN6S267C53v85Ev,
  (VTBL_ENTRY)&_ZN6S267C53v86Ev,
  (VTBL_ENTRY)&_ZN6S267C53v87Ev,
  (VTBL_ENTRY)&_ZN6S267C53v88Ev,
  (VTBL_ENTRY)&_ZN6S267C53v89Ev,
  (VTBL_ENTRY)&_ZN6S267C53v90Ev,
  (VTBL_ENTRY)&_ZN6S267C53v91Ev,
  (VTBL_ENTRY)&_ZN6S267C43v92Ev,
  (VTBL_ENTRY)&_ZN6S267C43v93Ev,
  (VTBL_ENTRY)&_ZN6S267C43v94Ev,
  (VTBL_ENTRY)&_ZN6S267C43v95Ev,
  (VTBL_ENTRY)&_ZN6S267C43v96Ev,
  (VTBL_ENTRY)&_ZN6S267C43v97Ev,
  (VTBL_ENTRY)&_ZN6S267C43v98Ev,
  (VTBL_ENTRY)&_ZN6S267C43v99Ev,
  (VTBL_ENTRY)&_ZN6S267C44v100Ev,
  (VTBL_ENTRY)&_ZN6S267C44v101Ev,
  (VTBL_ENTRY)&_ZN6S267C44v102Ev,
  (VTBL_ENTRY)&_ZN6S267C44v103Ev,
  (VTBL_ENTRY)&_ZN6S267C44v104Ev,
  (VTBL_ENTRY)&_ZN6S267C44v105Ev,
  (VTBL_ENTRY)&_ZN6S267C44v106Ev,
  (VTBL_ENTRY)&_ZN6S267C44v107Ev,
  (VTBL_ENTRY)&_ZN6S267C44v108Ev,
  (VTBL_ENTRY)&_ZN6S267C44v109Ev,
  (VTBL_ENTRY)&_ZN6S267C44v110Ev,
  (VTBL_ENTRY)&_ZN6S267C44v111Ev,
  (VTBL_ENTRY)&_ZN6S267C34v112Ev,
  (VTBL_ENTRY)&_ZN6S267C34v113Ev,
  (VTBL_ENTRY)&_ZN6S267C34v114Ev,
  (VTBL_ENTRY)&_ZN6S267C34v115Ev,
  (VTBL_ENTRY)&_ZN6S267C34v116Ev,
  (VTBL_ENTRY)&_ZN6S267C34v117Ev,
  (VTBL_ENTRY)&_ZN6S267C34v118Ev,
  (VTBL_ENTRY)&_ZN6S267C34v119Ev,
  (VTBL_ENTRY)&_ZN6S267C34v120Ev,
  (VTBL_ENTRY)&_ZN6S267C34v121Ev,
  (VTBL_ENTRY)&_ZN6S267C34v122Ev,
  (VTBL_ENTRY)&_ZN6S267C34v123Ev,
  (VTBL_ENTRY)&_ZN6S267C34v124Ev,
  (VTBL_ENTRY)&_ZN6S267C34v125Ev,
  (VTBL_ENTRY)&_ZN6S267C24v126Ev,
  (VTBL_ENTRY)&_ZN6S267C24v127Ev,
  (VTBL_ENTRY)&_ZN6S267C24v128Ev,
  (VTBL_ENTRY)&_ZN6S267C24v129Ev,
  (VTBL_ENTRY)&_ZN6S267C24v130Ev,
  (VTBL_ENTRY)&_ZN6S267C24v131Ev,
  (VTBL_ENTRY)&_ZN6S267C24v132Ev,
  (VTBL_ENTRY)&_ZN6S267C24v133Ev,
  (VTBL_ENTRY)&_ZN6S267C24v134Ev,
  (VTBL_ENTRY)&_ZN6S267C24v135Ev,
  (VTBL_ENTRY)&_ZN6S267C24v136Ev,
};
extern VTBL_ENTRY _ZTI6S267C2[];
extern  VTBL_ENTRY _ZTV6S267C2[];
Class_Descriptor cd_S267C2 = {  "S267C2", // class name
  bases_S267C2, 4,
  &(vtc_S267C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(392,280), // object size
  NSPAIRA(_ZTI6S267C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S267C2),135, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S267C1  : S267C2 {
  ::S113C26_nt s267c1f0;
  virtual  ~S267C1(); // _ZN6S267C1D1Ev
  virtual void  v1(); // _ZN6S267C12v1Ev
  virtual void  v2(); // _ZN6S267C12v2Ev
  virtual void  v3(); // _ZN6S267C12v3Ev
  virtual void  v4(); // _ZN6S267C12v4Ev
  virtual void  v5(); // _ZN6S267C12v5Ev
  S267C1(); // tgen
};
//SIG(1 S267C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 Fi[2] Fp Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 FC12{ m} FC8 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 Fi:1 Fi:1 Fi:1 FC13{ BC14{ BC11}} FC15{ BC16{ BC11}} FC17{ BC18{ BC11}} FC19{ BC20{ BC11}} Fi[3]} vd v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 Fp[2] Fi[4] Fi:1 Fi:1 Fi:1 Fc Fi Fi:1 FC21{ BC22{ BC11}}} vd v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 Fp[2] FC8 Fi:1 Fi:1 FC23{ m Fp FC7}} vd v1 v2 v3 v4 v5 FC24{ BC25{ m FC14 Fp Fi}}}


 S267C1 ::~S267C1(){ note_dtor("S267C1", this);}
void  S267C1 ::v1(){vfunc_called(this, "_ZN6S267C12v1Ev");}
void  S267C1 ::v2(){vfunc_called(this, "_ZN6S267C12v2Ev");}
void  S267C1 ::v3(){vfunc_called(this, "_ZN6S267C12v3Ev");}
void  S267C1 ::v4(){vfunc_called(this, "_ZN6S267C12v4Ev");}
void  S267C1 ::v5(){vfunc_called(this, "_ZN6S267C12v5Ev");}
S267C1 ::S267C1(){ note_ctor("S267C1", this);} // tgen

static void Test_S267C1()
{
  extern Class_Descriptor cd_S267C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(54,76)];
    init_test(&cd_S267C1, buf);
    S267C1 *dp, &lv = *(dp=new (buf) S267C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(424,300), "sizeof(S267C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S267C1)");
    check_base_class_offset(lv, (S267C6*)(S267C5*)(S267C4*)(S267C3*)(S267C2*), 0, "S267C1");
    check_base_class_offset(lv, (S267C5*)(S267C4*)(S267C3*)(S267C2*), 0, "S267C1");
    check_base_class_offset(lv, (S267C4*)(S267C3*)(S267C2*), 0, "S267C1");
    check_base_class_offset(lv, (S267C3*)(S267C2*), 0, "S267C1");
    check_base_class_offset(lv, (S267C2*), 0, "S267C1");
    check_field_offset(lv, s267c1f0, ABISELECT(392,280), "S267C1.s267c1f0");
    test_class_info(&lv, &cd_S267C1);
    dp->~S267C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS267C1(Test_S267C1, "S267C1", ABISELECT(424,300));

#else // __cplusplus

extern void _ZN6S267C1C1Ev();
extern void _ZN6S267C1D1Ev();
Name_Map name_map_S267C1[] = {
  NSPAIR(_ZN6S267C1C1Ev),
  NSPAIR(_ZN6S267C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S267C6;
extern VTBL_ENTRY _ZTI6S267C6[];
extern  VTBL_ENTRY _ZTV6S267C6[];
extern Class_Descriptor cd_S267C5;
extern VTBL_ENTRY _ZTI6S267C5[];
extern  VTBL_ENTRY _ZTV6S267C5[];
extern Class_Descriptor cd_S267C4;
extern VTBL_ENTRY _ZTI6S267C4[];
extern  VTBL_ENTRY _ZTV6S267C4[];
extern Class_Descriptor cd_S267C3;
extern VTBL_ENTRY _ZTI6S267C3[];
extern  VTBL_ENTRY _ZTV6S267C3[];
extern Class_Descriptor cd_S267C2;
extern VTBL_ENTRY _ZTI6S267C2[];
extern  VTBL_ENTRY _ZTV6S267C2[];
static Base_Class bases_S267C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S267C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S267C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S267C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S267C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S267C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S267C1[];
extern void _ZN6S267C1D1Ev();
extern void _ZN6S267C1D0Ev();
extern void _ZN6S267C62v6Ev();
extern void _ZN6S267C62v7Ev();
extern void _ZN6S267C62v8Ev();
extern void _ZN6S267C62v9Ev();
extern void _ZN6S267C63v10Ev();
extern void _ZN6S267C63v11Ev();
extern void _ZN6S267C63v12Ev();
extern void _ZN6S267C63v13Ev();
extern void _ZN6S267C63v14Ev();
extern void _ZN6S267C63v15Ev();
extern void _ZN6S267C63v16Ev();
extern void _ZN6S267C63v17Ev();
extern void _ZN6S267C63v18Ev();
extern void _ZN6S267C63v19Ev();
extern void _ZN6S267C63v20Ev();
extern void _ZN6S267C63v21Ev();
extern void _ZN6S267C63v22Ev();
extern void _ZN6S267C63v23Ev();
extern void _ZN6S267C63v24Ev();
extern void _ZN6S267C63v25Ev();
extern void _ZN6S267C63v26Ev();
extern void _ZN6S267C63v27Ev();
extern void _ZN6S267C63v28Ev();
extern void _ZN6S267C63v29Ev();
extern void _ZN6S267C63v30Ev();
extern void _ZN6S267C63v31Ev();
extern void _ZN6S267C63v32Ev();
extern void _ZN6S267C63v33Ev();
extern void _ZN6S267C63v34Ev();
extern void _ZN6S267C63v35Ev();
extern void _ZN6S267C63v36Ev();
extern void _ZN6S267C63v37Ev();
extern void _ZN6S267C63v38Ev();
extern void _ZN6S267C63v39Ev();
extern void _ZN6S267C63v40Ev();
extern void _ZN6S267C63v41Ev();
extern void _ZN6S267C63v42Ev();
extern void _ZN6S267C63v43Ev();
extern void _ZN6S267C63v44Ev();
extern void _ZN6S267C63v45Ev();
extern void _ZN6S267C63v46Ev();
extern void _ZN6S267C63v47Ev();
extern void _ZN6S267C63v48Ev();
extern void _ZN6S267C63v49Ev();
extern void _ZN6S267C63v50Ev();
extern void _ZN6S267C63v51Ev();
extern void _ZN6S267C63v52Ev();
extern void _ZN6S267C63v53Ev();
extern void _ZN6S267C63v54Ev();
extern void _ZN6S267C63v55Ev();
extern void _ZN6S267C63v56Ev();
extern void _ZN6S267C63v57Ev();
extern void _ZN6S267C63v58Ev();
extern void _ZN6S267C63v59Ev();
extern void _ZN6S267C63v60Ev();
extern void _ZN6S267C63v61Ev();
extern void _ZN6S267C63v62Ev();
extern void _ZN6S267C63v63Ev();
extern void _ZN6S267C63v64Ev();
extern void _ZN6S267C63v65Ev();
extern void _ZN6S267C63v66Ev();
extern void _ZN6S267C63v67Ev();
extern void _ZN6S267C63v68Ev();
extern void _ZN6S267C63v69Ev();
extern void _ZN6S267C53v70Ev();
extern void _ZN6S267C53v71Ev();
extern void _ZN6S267C53v72Ev();
extern void _ZN6S267C53v73Ev();
extern void _ZN6S267C53v74Ev();
extern void _ZN6S267C53v75Ev();
extern void _ZN6S267C53v76Ev();
extern void _ZN6S267C53v77Ev();
extern void _ZN6S267C53v78Ev();
extern void _ZN6S267C53v79Ev();
extern void _ZN6S267C53v80Ev();
extern void _ZN6S267C53v81Ev();
extern void _ZN6S267C53v82Ev();
extern void _ZN6S267C53v83Ev();
extern void _ZN6S267C53v84Ev();
extern void _ZN6S267C53v85Ev();
extern void _ZN6S267C53v86Ev();
extern void _ZN6S267C53v87Ev();
extern void _ZN6S267C53v88Ev();
extern void _ZN6S267C53v89Ev();
extern void _ZN6S267C53v90Ev();
extern void _ZN6S267C53v91Ev();
extern void _ZN6S267C43v92Ev();
extern void _ZN6S267C43v93Ev();
extern void _ZN6S267C43v94Ev();
extern void _ZN6S267C43v95Ev();
extern void _ZN6S267C43v96Ev();
extern void _ZN6S267C43v97Ev();
extern void _ZN6S267C43v98Ev();
extern void _ZN6S267C43v99Ev();
extern void _ZN6S267C44v100Ev();
extern void _ZN6S267C44v101Ev();
extern void _ZN6S267C44v102Ev();
extern void _ZN6S267C44v103Ev();
extern void _ZN6S267C44v104Ev();
extern void _ZN6S267C44v105Ev();
extern void _ZN6S267C44v106Ev();
extern void _ZN6S267C44v107Ev();
extern void _ZN6S267C44v108Ev();
extern void _ZN6S267C44v109Ev();
extern void _ZN6S267C44v110Ev();
extern void _ZN6S267C44v111Ev();
extern void _ZN6S267C34v112Ev();
extern void _ZN6S267C34v113Ev();
extern void _ZN6S267C34v114Ev();
extern void _ZN6S267C34v115Ev();
extern void _ZN6S267C34v116Ev();
extern void _ZN6S267C34v117Ev();
extern void _ZN6S267C34v118Ev();
extern void _ZN6S267C34v119Ev();
extern void _ZN6S267C34v120Ev();
extern void _ZN6S267C34v121Ev();
extern void _ZN6S267C34v122Ev();
extern void _ZN6S267C34v123Ev();
extern void _ZN6S267C34v124Ev();
extern void _ZN6S267C34v125Ev();
extern void _ZN6S267C24v126Ev();
extern void _ZN6S267C24v127Ev();
extern void _ZN6S267C24v128Ev();
extern void _ZN6S267C24v129Ev();
extern void _ZN6S267C24v130Ev();
extern void _ZN6S267C24v131Ev();
extern void _ZN6S267C24v132Ev();
extern void _ZN6S267C24v133Ev();
extern void _ZN6S267C24v134Ev();
extern void _ZN6S267C24v135Ev();
extern void _ZN6S267C24v136Ev();
extern void _ZN6S267C12v1Ev();
extern void _ZN6S267C12v2Ev();
extern void _ZN6S267C12v3Ev();
extern void _ZN6S267C12v4Ev();
extern void _ZN6S267C12v5Ev();
static  VTBL_ENTRY vtc_S267C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S267C1[0]),
  (VTBL_ENTRY)&_ZN6S267C1D1Ev,
  (VTBL_ENTRY)&_ZN6S267C1D0Ev,
  (VTBL_ENTRY)&_ZN6S267C62v6Ev,
  (VTBL_ENTRY)&_ZN6S267C62v7Ev,
  (VTBL_ENTRY)&_ZN6S267C62v8Ev,
  (VTBL_ENTRY)&_ZN6S267C62v9Ev,
  (VTBL_ENTRY)&_ZN6S267C63v10Ev,
  (VTBL_ENTRY)&_ZN6S267C63v11Ev,
  (VTBL_ENTRY)&_ZN6S267C63v12Ev,
  (VTBL_ENTRY)&_ZN6S267C63v13Ev,
  (VTBL_ENTRY)&_ZN6S267C63v14Ev,
  (VTBL_ENTRY)&_ZN6S267C63v15Ev,
  (VTBL_ENTRY)&_ZN6S267C63v16Ev,
  (VTBL_ENTRY)&_ZN6S267C63v17Ev,
  (VTBL_ENTRY)&_ZN6S267C63v18Ev,
  (VTBL_ENTRY)&_ZN6S267C63v19Ev,
  (VTBL_ENTRY)&_ZN6S267C63v20Ev,
  (VTBL_ENTRY)&_ZN6S267C63v21Ev,
  (VTBL_ENTRY)&_ZN6S267C63v22Ev,
  (VTBL_ENTRY)&_ZN6S267C63v23Ev,
  (VTBL_ENTRY)&_ZN6S267C63v24Ev,
  (VTBL_ENTRY)&_ZN6S267C63v25Ev,
  (VTBL_ENTRY)&_ZN6S267C63v26Ev,
  (VTBL_ENTRY)&_ZN6S267C63v27Ev,
  (VTBL_ENTRY)&_ZN6S267C63v28Ev,
  (VTBL_ENTRY)&_ZN6S267C63v29Ev,
  (VTBL_ENTRY)&_ZN6S267C63v30Ev,
  (VTBL_ENTRY)&_ZN6S267C63v31Ev,
  (VTBL_ENTRY)&_ZN6S267C63v32Ev,
  (VTBL_ENTRY)&_ZN6S267C63v33Ev,
  (VTBL_ENTRY)&_ZN6S267C63v34Ev,
  (VTBL_ENTRY)&_ZN6S267C63v35Ev,
  (VTBL_ENTRY)&_ZN6S267C63v36Ev,
  (VTBL_ENTRY)&_ZN6S267C63v37Ev,
  (VTBL_ENTRY)&_ZN6S267C63v38Ev,
  (VTBL_ENTRY)&_ZN6S267C63v39Ev,
  (VTBL_ENTRY)&_ZN6S267C63v40Ev,
  (VTBL_ENTRY)&_ZN6S267C63v41Ev,
  (VTBL_ENTRY)&_ZN6S267C63v42Ev,
  (VTBL_ENTRY)&_ZN6S267C63v43Ev,
  (VTBL_ENTRY)&_ZN6S267C63v44Ev,
  (VTBL_ENTRY)&_ZN6S267C63v45Ev,
  (VTBL_ENTRY)&_ZN6S267C63v46Ev,
  (VTBL_ENTRY)&_ZN6S267C63v47Ev,
  (VTBL_ENTRY)&_ZN6S267C63v48Ev,
  (VTBL_ENTRY)&_ZN6S267C63v49Ev,
  (VTBL_ENTRY)&_ZN6S267C63v50Ev,
  (VTBL_ENTRY)&_ZN6S267C63v51Ev,
  (VTBL_ENTRY)&_ZN6S267C63v52Ev,
  (VTBL_ENTRY)&_ZN6S267C63v53Ev,
  (VTBL_ENTRY)&_ZN6S267C63v54Ev,
  (VTBL_ENTRY)&_ZN6S267C63v55Ev,
  (VTBL_ENTRY)&_ZN6S267C63v56Ev,
  (VTBL_ENTRY)&_ZN6S267C63v57Ev,
  (VTBL_ENTRY)&_ZN6S267C63v58Ev,
  (VTBL_ENTRY)&_ZN6S267C63v59Ev,
  (VTBL_ENTRY)&_ZN6S267C63v60Ev,
  (VTBL_ENTRY)&_ZN6S267C63v61Ev,
  (VTBL_ENTRY)&_ZN6S267C63v62Ev,
  (VTBL_ENTRY)&_ZN6S267C63v63Ev,
  (VTBL_ENTRY)&_ZN6S267C63v64Ev,
  (VTBL_ENTRY)&_ZN6S267C63v65Ev,
  (VTBL_ENTRY)&_ZN6S267C63v66Ev,
  (VTBL_ENTRY)&_ZN6S267C63v67Ev,
  (VTBL_ENTRY)&_ZN6S267C63v68Ev,
  (VTBL_ENTRY)&_ZN6S267C63v69Ev,
  (VTBL_ENTRY)&_ZN6S267C53v70Ev,
  (VTBL_ENTRY)&_ZN6S267C53v71Ev,
  (VTBL_ENTRY)&_ZN6S267C53v72Ev,
  (VTBL_ENTRY)&_ZN6S267C53v73Ev,
  (VTBL_ENTRY)&_ZN6S267C53v74Ev,
  (VTBL_ENTRY)&_ZN6S267C53v75Ev,
  (VTBL_ENTRY)&_ZN6S267C53v76Ev,
  (VTBL_ENTRY)&_ZN6S267C53v77Ev,
  (VTBL_ENTRY)&_ZN6S267C53v78Ev,
  (VTBL_ENTRY)&_ZN6S267C53v79Ev,
  (VTBL_ENTRY)&_ZN6S267C53v80Ev,
  (VTBL_ENTRY)&_ZN6S267C53v81Ev,
  (VTBL_ENTRY)&_ZN6S267C53v82Ev,
  (VTBL_ENTRY)&_ZN6S267C53v83Ev,
  (VTBL_ENTRY)&_ZN6S267C53v84Ev,
  (VTBL_ENTRY)&_ZN6S267C53v85Ev,
  (VTBL_ENTRY)&_ZN6S267C53v86Ev,
  (VTBL_ENTRY)&_ZN6S267C53v87Ev,
  (VTBL_ENTRY)&_ZN6S267C53v88Ev,
  (VTBL_ENTRY)&_ZN6S267C53v89Ev,
  (VTBL_ENTRY)&_ZN6S267C53v90Ev,
  (VTBL_ENTRY)&_ZN6S267C53v91Ev,
  (VTBL_ENTRY)&_ZN6S267C43v92Ev,
  (VTBL_ENTRY)&_ZN6S267C43v93Ev,
  (VTBL_ENTRY)&_ZN6S267C43v94Ev,
  (VTBL_ENTRY)&_ZN6S267C43v95Ev,
  (VTBL_ENTRY)&_ZN6S267C43v96Ev,
  (VTBL_ENTRY)&_ZN6S267C43v97Ev,
  (VTBL_ENTRY)&_ZN6S267C43v98Ev,
  (VTBL_ENTRY)&_ZN6S267C43v99Ev,
  (VTBL_ENTRY)&_ZN6S267C44v100Ev,
  (VTBL_ENTRY)&_ZN6S267C44v101Ev,
  (VTBL_ENTRY)&_ZN6S267C44v102Ev,
  (VTBL_ENTRY)&_ZN6S267C44v103Ev,
  (VTBL_ENTRY)&_ZN6S267C44v104Ev,
  (VTBL_ENTRY)&_ZN6S267C44v105Ev,
  (VTBL_ENTRY)&_ZN6S267C44v106Ev,
  (VTBL_ENTRY)&_ZN6S267C44v107Ev,
  (VTBL_ENTRY)&_ZN6S267C44v108Ev,
  (VTBL_ENTRY)&_ZN6S267C44v109Ev,
  (VTBL_ENTRY)&_ZN6S267C44v110Ev,
  (VTBL_ENTRY)&_ZN6S267C44v111Ev,
  (VTBL_ENTRY)&_ZN6S267C34v112Ev,
  (VTBL_ENTRY)&_ZN6S267C34v113Ev,
  (VTBL_ENTRY)&_ZN6S267C34v114Ev,
  (VTBL_ENTRY)&_ZN6S267C34v115Ev,
  (VTBL_ENTRY)&_ZN6S267C34v116Ev,
  (VTBL_ENTRY)&_ZN6S267C34v117Ev,
  (VTBL_ENTRY)&_ZN6S267C34v118Ev,
  (VTBL_ENTRY)&_ZN6S267C34v119Ev,
  (VTBL_ENTRY)&_ZN6S267C34v120Ev,
  (VTBL_ENTRY)&_ZN6S267C34v121Ev,
  (VTBL_ENTRY)&_ZN6S267C34v122Ev,
  (VTBL_ENTRY)&_ZN6S267C34v123Ev,
  (VTBL_ENTRY)&_ZN6S267C34v124Ev,
  (VTBL_ENTRY)&_ZN6S267C34v125Ev,
  (VTBL_ENTRY)&_ZN6S267C24v126Ev,
  (VTBL_ENTRY)&_ZN6S267C24v127Ev,
  (VTBL_ENTRY)&_ZN6S267C24v128Ev,
  (VTBL_ENTRY)&_ZN6S267C24v129Ev,
  (VTBL_ENTRY)&_ZN6S267C24v130Ev,
  (VTBL_ENTRY)&_ZN6S267C24v131Ev,
  (VTBL_ENTRY)&_ZN6S267C24v132Ev,
  (VTBL_ENTRY)&_ZN6S267C24v133Ev,
  (VTBL_ENTRY)&_ZN6S267C24v134Ev,
  (VTBL_ENTRY)&_ZN6S267C24v135Ev,
  (VTBL_ENTRY)&_ZN6S267C24v136Ev,
  (VTBL_ENTRY)&_ZN6S267C12v1Ev,
  (VTBL_ENTRY)&_ZN6S267C12v2Ev,
  (VTBL_ENTRY)&_ZN6S267C12v3Ev,
  (VTBL_ENTRY)&_ZN6S267C12v4Ev,
  (VTBL_ENTRY)&_ZN6S267C12v5Ev,
};
extern VTBL_ENTRY _ZTI6S267C1[];
extern  VTBL_ENTRY _ZTV6S267C1[];
Class_Descriptor cd_S267C1 = {  "S267C1", // class name
  bases_S267C1, 5,
  &(vtc_S267C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(424,300), // object size
  NSPAIRA(_ZTI6S267C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S267C1),140, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S56C7  {
  int s56c7f0;
  __tsi64 s56c7f1;
  void *s56c7f2[4];
  int s56c7f3[2];
  void *s56c7f4;
  ::S3350C4_nt s56c7f5;
  void *s56c7f6[2];
  virtual  ~S56C7(); // _ZN5S56C7D1Ev
  virtual void  v3(); // _ZN5S56C72v3Ev
  virtual void  v4(); // _ZN5S56C72v4Ev
  virtual void  v5(); // _ZN5S56C72v5Ev
  virtual void  v6(); // _ZN5S56C72v6Ev
  virtual void  v7(); // _ZN5S56C72v7Ev
  virtual void  v8(); // _ZN5S56C72v8Ev
  virtual void  v9(); // _ZN5S56C72v9Ev
  virtual void  v10(); // _ZN5S56C73v10Ev
  virtual void  v11(); // _ZN5S56C73v11Ev
  virtual void  v12(); // _ZN5S56C73v12Ev
  virtual void  v13(); // _ZN5S56C73v13Ev
  virtual void  v14(); // _ZN5S56C73v14Ev
  virtual void  v15(); // _ZN5S56C73v15Ev
  virtual void  v16(); // _ZN5S56C73v16Ev
  virtual void  v17(); // _ZN5S56C73v17Ev
  virtual void  v18(); // _ZN5S56C73v18Ev
  virtual void  v19(); // _ZN5S56C73v19Ev
  virtual void  v20(); // _ZN5S56C73v20Ev
  virtual void  v21(); // _ZN5S56C73v21Ev
  virtual void  v22(); // _ZN5S56C73v22Ev
  virtual void  v23(); // _ZN5S56C73v23Ev
  virtual void  v24(); // _ZN5S56C73v24Ev
  virtual void  v25(); // _ZN5S56C73v25Ev
  virtual void  v26(); // _ZN5S56C73v26Ev
  virtual void  v27(); // _ZN5S56C73v27Ev
  virtual void  v28(); // _ZN5S56C73v28Ev
  virtual void  v29(); // _ZN5S56C73v29Ev
  virtual void  v30(); // _ZN5S56C73v30Ev
  virtual void  v31(); // _ZN5S56C73v31Ev
  virtual void  v32(); // _ZN5S56C73v32Ev
  virtual void  v33(); // _ZN5S56C73v33Ev
  virtual void  v34(); // _ZN5S56C73v34Ev
  virtual void  v35(); // _ZN5S56C73v35Ev
  virtual void  v36(); // _ZN5S56C73v36Ev
  virtual void  v37(); // _ZN5S56C73v37Ev
  virtual void  v38(); // _ZN5S56C73v38Ev
  virtual void  v39(); // _ZN5S56C73v39Ev
  virtual void  v40(); // _ZN5S56C73v40Ev
  virtual void  v41(); // _ZN5S56C73v41Ev
  virtual void  v42(); // _ZN5S56C73v42Ev
  virtual void  v43(); // _ZN5S56C73v43Ev
  virtual void  v44(); // _ZN5S56C73v44Ev
  virtual void  v45(); // _ZN5S56C73v45Ev
  virtual void  v46(); // _ZN5S56C73v46Ev
  virtual void  v47(); // _ZN5S56C73v47Ev
  virtual void  v48(); // _ZN5S56C73v48Ev
  virtual void  v49(); // _ZN5S56C73v49Ev
  virtual void  v50(); // _ZN5S56C73v50Ev
  virtual void  v51(); // _ZN5S56C73v51Ev
  virtual void  v52(); // _ZN5S56C73v52Ev
  virtual void  v53(); // _ZN5S56C73v53Ev
  virtual void  v54(); // _ZN5S56C73v54Ev
  virtual void  v55(); // _ZN5S56C73v55Ev
  virtual void  v56(); // _ZN5S56C73v56Ev
  virtual void  v57(); // _ZN5S56C73v57Ev
  virtual void  v58(); // _ZN5S56C73v58Ev
  virtual void  v59(); // _ZN5S56C73v59Ev
  virtual void  v60(); // _ZN5S56C73v60Ev
  virtual void  v61(); // _ZN5S56C73v61Ev
  virtual void  v62(); // _ZN5S56C73v62Ev
  virtual void  v63(); // _ZN5S56C73v63Ev
  virtual void  v64(); // _ZN5S56C73v64Ev
  virtual void  v65(); // _ZN5S56C73v65Ev
  virtual void  v66(); // _ZN5S56C73v66Ev
  S56C7(); // tgen
};
//SIG(-1 S56C7) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S56C7 ::~S56C7(){ note_dtor("S56C7", this);}
void  S56C7 ::v3(){vfunc_called(this, "_ZN5S56C72v3Ev");}
void  S56C7 ::v4(){vfunc_called(this, "_ZN5S56C72v4Ev");}
void  S56C7 ::v5(){vfunc_called(this, "_ZN5S56C72v5Ev");}
void  S56C7 ::v6(){vfunc_called(this, "_ZN5S56C72v6Ev");}
void  S56C7 ::v7(){vfunc_called(this, "_ZN5S56C72v7Ev");}
void  S56C7 ::v8(){vfunc_called(this, "_ZN5S56C72v8Ev");}
void  S56C7 ::v9(){vfunc_called(this, "_ZN5S56C72v9Ev");}
void  S56C7 ::v10(){vfunc_called(this, "_ZN5S56C73v10Ev");}
void  S56C7 ::v11(){vfunc_called(this, "_ZN5S56C73v11Ev");}
void  S56C7 ::v12(){vfunc_called(this, "_ZN5S56C73v12Ev");}
void  S56C7 ::v13(){vfunc_called(this, "_ZN5S56C73v13Ev");}
void  S56C7 ::v14(){vfunc_called(this, "_ZN5S56C73v14Ev");}
void  S56C7 ::v15(){vfunc_called(this, "_ZN5S56C73v15Ev");}
void  S56C7 ::v16(){vfunc_called(this, "_ZN5S56C73v16Ev");}
void  S56C7 ::v17(){vfunc_called(this, "_ZN5S56C73v17Ev");}
void  S56C7 ::v18(){vfunc_called(this, "_ZN5S56C73v18Ev");}
void  S56C7 ::v19(){vfunc_called(this, "_ZN5S56C73v19Ev");}
void  S56C7 ::v20(){vfunc_called(this, "_ZN5S56C73v20Ev");}
void  S56C7 ::v21(){vfunc_called(this, "_ZN5S56C73v21Ev");}
void  S56C7 ::v22(){vfunc_called(this, "_ZN5S56C73v22Ev");}
void  S56C7 ::v23(){vfunc_called(this, "_ZN5S56C73v23Ev");}
void  S56C7 ::v24(){vfunc_called(this, "_ZN5S56C73v24Ev");}
void  S56C7 ::v25(){vfunc_called(this, "_ZN5S56C73v25Ev");}
void  S56C7 ::v26(){vfunc_called(this, "_ZN5S56C73v26Ev");}
void  S56C7 ::v27(){vfunc_called(this, "_ZN5S56C73v27Ev");}
void  S56C7 ::v28(){vfunc_called(this, "_ZN5S56C73v28Ev");}
void  S56C7 ::v29(){vfunc_called(this, "_ZN5S56C73v29Ev");}
void  S56C7 ::v30(){vfunc_called(this, "_ZN5S56C73v30Ev");}
void  S56C7 ::v31(){vfunc_called(this, "_ZN5S56C73v31Ev");}
void  S56C7 ::v32(){vfunc_called(this, "_ZN5S56C73v32Ev");}
void  S56C7 ::v33(){vfunc_called(this, "_ZN5S56C73v33Ev");}
void  S56C7 ::v34(){vfunc_called(this, "_ZN5S56C73v34Ev");}
void  S56C7 ::v35(){vfunc_called(this, "_ZN5S56C73v35Ev");}
void  S56C7 ::v36(){vfunc_called(this, "_ZN5S56C73v36Ev");}
void  S56C7 ::v37(){vfunc_called(this, "_ZN5S56C73v37Ev");}
void  S56C7 ::v38(){vfunc_called(this, "_ZN5S56C73v38Ev");}
void  S56C7 ::v39(){vfunc_called(this, "_ZN5S56C73v39Ev");}
void  S56C7 ::v40(){vfunc_called(this, "_ZN5S56C73v40Ev");}
void  S56C7 ::v41(){vfunc_called(this, "_ZN5S56C73v41Ev");}
void  S56C7 ::v42(){vfunc_called(this, "_ZN5S56C73v42Ev");}
void  S56C7 ::v43(){vfunc_called(this, "_ZN5S56C73v43Ev");}
void  S56C7 ::v44(){vfunc_called(this, "_ZN5S56C73v44Ev");}
void  S56C7 ::v45(){vfunc_called(this, "_ZN5S56C73v45Ev");}
void  S56C7 ::v46(){vfunc_called(this, "_ZN5S56C73v46Ev");}
void  S56C7 ::v47(){vfunc_called(this, "_ZN5S56C73v47Ev");}
void  S56C7 ::v48(){vfunc_called(this, "_ZN5S56C73v48Ev");}
void  S56C7 ::v49(){vfunc_called(this, "_ZN5S56C73v49Ev");}
void  S56C7 ::v50(){vfunc_called(this, "_ZN5S56C73v50Ev");}
void  S56C7 ::v51(){vfunc_called(this, "_ZN5S56C73v51Ev");}
void  S56C7 ::v52(){vfunc_called(this, "_ZN5S56C73v52Ev");}
void  S56C7 ::v53(){vfunc_called(this, "_ZN5S56C73v53Ev");}
void  S56C7 ::v54(){vfunc_called(this, "_ZN5S56C73v54Ev");}
void  S56C7 ::v55(){vfunc_called(this, "_ZN5S56C73v55Ev");}
void  S56C7 ::v56(){vfunc_called(this, "_ZN5S56C73v56Ev");}
void  S56C7 ::v57(){vfunc_called(this, "_ZN5S56C73v57Ev");}
void  S56C7 ::v58(){vfunc_called(this, "_ZN5S56C73v58Ev");}
void  S56C7 ::v59(){vfunc_called(this, "_ZN5S56C73v59Ev");}
void  S56C7 ::v60(){vfunc_called(this, "_ZN5S56C73v60Ev");}
void  S56C7 ::v61(){vfunc_called(this, "_ZN5S56C73v61Ev");}
void  S56C7 ::v62(){vfunc_called(this, "_ZN5S56C73v62Ev");}
void  S56C7 ::v63(){vfunc_called(this, "_ZN5S56C73v63Ev");}
void  S56C7 ::v64(){vfunc_called(this, "_ZN5S56C73v64Ev");}
void  S56C7 ::v65(){vfunc_called(this, "_ZN5S56C73v65Ev");}
void  S56C7 ::v66(){vfunc_called(this, "_ZN5S56C73v66Ev");}
S56C7 ::S56C7(){ note_ctor("S56C7", this);} // tgen

static void Test_S56C7()
{
  extern Class_Descriptor cd_S56C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S56C7, buf);
    S56C7 *dp, &lv = *(dp=new (buf) S56C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S56C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S56C7)");
    check_field_offset(lv, s56c7f0, ABISELECT(8,4), "S56C7.s56c7f0");
    check_field_offset(lv, s56c7f1, ABISELECT(16,8), "S56C7.s56c7f1");
    check_field_offset(lv, s56c7f2, ABISELECT(24,16), "S56C7.s56c7f2");
    check_field_offset(lv, s56c7f3, ABISELECT(56,32), "S56C7.s56c7f3");
    check_field_offset(lv, s56c7f4, ABISELECT(64,40), "S56C7.s56c7f4");
    check_field_offset(lv, s56c7f5, ABISELECT(72,44), "S56C7.s56c7f5");
    check_field_offset(lv, s56c7f6, ABISELECT(80,52), "S56C7.s56c7f6");
    test_class_info(&lv, &cd_S56C7);
    dp->~S56C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS56C7(Test_S56C7, "S56C7", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN5S56C7C1Ev();
extern void _ZN5S56C7D1Ev();
Name_Map name_map_S56C7[] = {
  NSPAIR(_ZN5S56C7C1Ev),
  NSPAIR(_ZN5S56C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI5S56C7[];
extern void _ZN5S56C7D1Ev();
extern void _ZN5S56C7D0Ev();
extern void _ZN5S56C72v3Ev();
extern void _ZN5S56C72v4Ev();
extern void _ZN5S56C72v5Ev();
extern void _ZN5S56C72v6Ev();
extern void _ZN5S56C72v7Ev();
extern void _ZN5S56C72v8Ev();
extern void _ZN5S56C72v9Ev();
extern void _ZN5S56C73v10Ev();
extern void _ZN5S56C73v11Ev();
extern void _ZN5S56C73v12Ev();
extern void _ZN5S56C73v13Ev();
extern void _ZN5S56C73v14Ev();
extern void _ZN5S56C73v15Ev();
extern void _ZN5S56C73v16Ev();
extern void _ZN5S56C73v17Ev();
extern void _ZN5S56C73v18Ev();
extern void _ZN5S56C73v19Ev();
extern void _ZN5S56C73v20Ev();
extern void _ZN5S56C73v21Ev();
extern void _ZN5S56C73v22Ev();
extern void _ZN5S56C73v23Ev();
extern void _ZN5S56C73v24Ev();
extern void _ZN5S56C73v25Ev();
extern void _ZN5S56C73v26Ev();
extern void _ZN5S56C73v27Ev();
extern void _ZN5S56C73v28Ev();
extern void _ZN5S56C73v29Ev();
extern void _ZN5S56C73v30Ev();
extern void _ZN5S56C73v31Ev();
extern void _ZN5S56C73v32Ev();
extern void _ZN5S56C73v33Ev();
extern void _ZN5S56C73v34Ev();
extern void _ZN5S56C73v35Ev();
extern void _ZN5S56C73v36Ev();
extern void _ZN5S56C73v37Ev();
extern void _ZN5S56C73v38Ev();
extern void _ZN5S56C73v39Ev();
extern void _ZN5S56C73v40Ev();
extern void _ZN5S56C73v41Ev();
extern void _ZN5S56C73v42Ev();
extern void _ZN5S56C73v43Ev();
extern void _ZN5S56C73v44Ev();
extern void _ZN5S56C73v45Ev();
extern void _ZN5S56C73v46Ev();
extern void _ZN5S56C73v47Ev();
extern void _ZN5S56C73v48Ev();
extern void _ZN5S56C73v49Ev();
extern void _ZN5S56C73v50Ev();
extern void _ZN5S56C73v51Ev();
extern void _ZN5S56C73v52Ev();
extern void _ZN5S56C73v53Ev();
extern void _ZN5S56C73v54Ev();
extern void _ZN5S56C73v55Ev();
extern void _ZN5S56C73v56Ev();
extern void _ZN5S56C73v57Ev();
extern void _ZN5S56C73v58Ev();
extern void _ZN5S56C73v59Ev();
extern void _ZN5S56C73v60Ev();
extern void _ZN5S56C73v61Ev();
extern void _ZN5S56C73v62Ev();
extern void _ZN5S56C73v63Ev();
extern void _ZN5S56C73v64Ev();
extern void _ZN5S56C73v65Ev();
extern void _ZN5S56C73v66Ev();
static  VTBL_ENTRY vtc_S56C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S56C7[0]),
  (VTBL_ENTRY)&_ZN5S56C7D1Ev,
  (VTBL_ENTRY)&_ZN5S56C7D0Ev,
  (VTBL_ENTRY)&_ZN5S56C72v3Ev,
  (VTBL_ENTRY)&_ZN5S56C72v4Ev,
  (VTBL_ENTRY)&_ZN5S56C72v5Ev,
  (VTBL_ENTRY)&_ZN5S56C72v6Ev,
  (VTBL_ENTRY)&_ZN5S56C72v7Ev,
  (VTBL_ENTRY)&_ZN5S56C72v8Ev,
  (VTBL_ENTRY)&_ZN5S56C72v9Ev,
  (VTBL_ENTRY)&_ZN5S56C73v10Ev,
  (VTBL_ENTRY)&_ZN5S56C73v11Ev,
  (VTBL_ENTRY)&_ZN5S56C73v12Ev,
  (VTBL_ENTRY)&_ZN5S56C73v13Ev,
  (VTBL_ENTRY)&_ZN5S56C73v14Ev,
  (VTBL_ENTRY)&_ZN5S56C73v15Ev,
  (VTBL_ENTRY)&_ZN5S56C73v16Ev,
  (VTBL_ENTRY)&_ZN5S56C73v17Ev,
  (VTBL_ENTRY)&_ZN5S56C73v18Ev,
  (VTBL_ENTRY)&_ZN5S56C73v19Ev,
  (VTBL_ENTRY)&_ZN5S56C73v20Ev,
  (VTBL_ENTRY)&_ZN5S56C73v21Ev,
  (VTBL_ENTRY)&_ZN5S56C73v22Ev,
  (VTBL_ENTRY)&_ZN5S56C73v23Ev,
  (VTBL_ENTRY)&_ZN5S56C73v24Ev,
  (VTBL_ENTRY)&_ZN5S56C73v25Ev,
  (VTBL_ENTRY)&_ZN5S56C73v26Ev,
  (VTBL_ENTRY)&_ZN5S56C73v27Ev,
  (VTBL_ENTRY)&_ZN5S56C73v28Ev,
  (VTBL_ENTRY)&_ZN5S56C73v29Ev,
  (VTBL_ENTRY)&_ZN5S56C73v30Ev,
  (VTBL_ENTRY)&_ZN5S56C73v31Ev,
  (VTBL_ENTRY)&_ZN5S56C73v32Ev,
  (VTBL_ENTRY)&_ZN5S56C73v33Ev,
  (VTBL_ENTRY)&_ZN5S56C73v34Ev,
  (VTBL_ENTRY)&_ZN5S56C73v35Ev,
  (VTBL_ENTRY)&_ZN5S56C73v36Ev,
  (VTBL_ENTRY)&_ZN5S56C73v37Ev,
  (VTBL_ENTRY)&_ZN5S56C73v38Ev,
  (VTBL_ENTRY)&_ZN5S56C73v39Ev,
  (VTBL_ENTRY)&_ZN5S56C73v40Ev,
  (VTBL_ENTRY)&_ZN5S56C73v41Ev,
  (VTBL_ENTRY)&_ZN5S56C73v42Ev,
  (VTBL_ENTRY)&_ZN5S56C73v43Ev,
  (VTBL_ENTRY)&_ZN5S56C73v44Ev,
  (VTBL_ENTRY)&_ZN5S56C73v45Ev,
  (VTBL_ENTRY)&_ZN5S56C73v46Ev,
  (VTBL_ENTRY)&_ZN5S56C73v47Ev,
  (VTBL_ENTRY)&_ZN5S56C73v48Ev,
  (VTBL_ENTRY)&_ZN5S56C73v49Ev,
  (VTBL_ENTRY)&_ZN5S56C73v50Ev,
  (VTBL_ENTRY)&_ZN5S56C73v51Ev,
  (VTBL_ENTRY)&_ZN5S56C73v52Ev,
  (VTBL_ENTRY)&_ZN5S56C73v53Ev,
  (VTBL_ENTRY)&_ZN5S56C73v54Ev,
  (VTBL_ENTRY)&_ZN5S56C73v55Ev,
  (VTBL_ENTRY)&_ZN5S56C73v56Ev,
  (VTBL_ENTRY)&_ZN5S56C73v57Ev,
  (VTBL_ENTRY)&_ZN5S56C73v58Ev,
  (VTBL_ENTRY)&_ZN5S56C73v59Ev,
  (VTBL_ENTRY)&_ZN5S56C73v60Ev,
  (VTBL_ENTRY)&_ZN5S56C73v61Ev,
  (VTBL_ENTRY)&_ZN5S56C73v62Ev,
  (VTBL_ENTRY)&_ZN5S56C73v63Ev,
  (VTBL_ENTRY)&_ZN5S56C73v64Ev,
  (VTBL_ENTRY)&_ZN5S56C73v65Ev,
  (VTBL_ENTRY)&_ZN5S56C73v66Ev,
};
extern VTBL_ENTRY _ZTI5S56C7[];
extern  VTBL_ENTRY _ZTV5S56C7[];
Class_Descriptor cd_S56C7 = {  "S56C7", // class name
  0,0,//no base classes
  &(vtc_S56C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI5S56C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV5S56C7),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S56C6  : S56C7 {
  int s56c6f0[2];
  void *s56c6f1;
  int s56c6f2[2];
  ::S287C8_nt s56c6f3;
  ::S287C8_nt s56c6f4;
  ::S2121C38 s56c6f5;
  ::S287C8_nt s56c6f6;
  unsigned int s56c6f7:1;
  unsigned int s56c6f8:1;
  unsigned int s56c6f9:1;
  unsigned int s56c6f10:1;
  unsigned int s56c6f11:1;
  int s56c6f12[2];
  virtual  ~S56C6(); // _ZN5S56C6D1Ev
  virtual void  v67(); // _ZN5S56C63v67Ev
  virtual void  v68(); // _ZN5S56C63v68Ev
  virtual void  v69(); // _ZN5S56C63v69Ev
  virtual void  v70(); // _ZN5S56C63v70Ev
  virtual void  v71(); // _ZN5S56C63v71Ev
  virtual void  v72(); // _ZN5S56C63v72Ev
  virtual void  v73(); // _ZN5S56C63v73Ev
  virtual void  v74(); // _ZN5S56C63v74Ev
  virtual void  v75(); // _ZN5S56C63v75Ev
  virtual void  v76(); // _ZN5S56C63v76Ev
  virtual void  v77(); // _ZN5S56C63v77Ev
  virtual void  v78(); // _ZN5S56C63v78Ev
  virtual void  v79(); // _ZN5S56C63v79Ev
  virtual void  v80(); // _ZN5S56C63v80Ev
  virtual void  v81(); // _ZN5S56C63v81Ev
  virtual void  v82(); // _ZN5S56C63v82Ev
  virtual void  v83(); // _ZN5S56C63v83Ev
  virtual void  v84(); // _ZN5S56C63v84Ev
  virtual void  v85(); // _ZN5S56C63v85Ev
  virtual void  v86(); // _ZN5S56C63v86Ev
  virtual void  v87(); // _ZN5S56C63v87Ev
  virtual void  v88(); // _ZN5S56C63v88Ev
  S56C6(); // tgen
};
//SIG(-1 S56C6) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S56C6 ::~S56C6(){ note_dtor("S56C6", this);}
void  S56C6 ::v67(){vfunc_called(this, "_ZN5S56C63v67Ev");}
void  S56C6 ::v68(){vfunc_called(this, "_ZN5S56C63v68Ev");}
void  S56C6 ::v69(){vfunc_called(this, "_ZN5S56C63v69Ev");}
void  S56C6 ::v70(){vfunc_called(this, "_ZN5S56C63v70Ev");}
void  S56C6 ::v71(){vfunc_called(this, "_ZN5S56C63v71Ev");}
void  S56C6 ::v72(){vfunc_called(this, "_ZN5S56C63v72Ev");}
void  S56C6 ::v73(){vfunc_called(this, "_ZN5S56C63v73Ev");}
void  S56C6 ::v74(){vfunc_called(this, "_ZN5S56C63v74Ev");}
void  S56C6 ::v75(){vfunc_called(this, "_ZN5S56C63v75Ev");}
void  S56C6 ::v76(){vfunc_called(this, "_ZN5S56C63v76Ev");}
void  S56C6 ::v77(){vfunc_called(this, "_ZN5S56C63v77Ev");}
void  S56C6 ::v78(){vfunc_called(this, "_ZN5S56C63v78Ev");}
void  S56C6 ::v79(){vfunc_called(this, "_ZN5S56C63v79Ev");}
void  S56C6 ::v80(){vfunc_called(this, "_ZN5S56C63v80Ev");}
void  S56C6 ::v81(){vfunc_called(this, "_ZN5S56C63v81Ev");}
void  S56C6 ::v82(){vfunc_called(this, "_ZN5S56C63v82Ev");}
void  S56C6 ::v83(){vfunc_called(this, "_ZN5S56C63v83Ev");}
void  S56C6 ::v84(){vfunc_called(this, "_ZN5S56C63v84Ev");}
void  S56C6 ::v85(){vfunc_called(this, "_ZN5S56C63v85Ev");}
void  S56C6 ::v86(){vfunc_called(this, "_ZN5S56C63v86Ev");}
void  S56C6 ::v87(){vfunc_called(this, "_ZN5S56C63v87Ev");}
void  S56C6 ::v88(){vfunc_called(this, "_ZN5S56C63v88Ev");}
S56C6 ::S56C6(){ note_ctor("S56C6", this);} // tgen

static void Test_S56C6()
{
  extern Class_Descriptor cd_S56C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S56C6, buf);
    S56C6 *dp, &lv = *(dp=new (buf) S56C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S56C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S56C6)");
    check_base_class_offset(lv, (S56C7*), 0, "S56C6");
    check_field_offset(lv, s56c6f0, ABISELECT(96,60), "S56C6.s56c6f0");
    check_field_offset(lv, s56c6f1, ABISELECT(104,68), "S56C6.s56c6f1");
    check_field_offset(lv, s56c6f2, ABISELECT(112,72), "S56C6.s56c6f2");
    check_field_offset(lv, s56c6f3, ABISELECT(120,80), "S56C6.s56c6f3");
    check_field_offset(lv, s56c6f4, ABISELECT(136,92), "S56C6.s56c6f4");
    check_field_offset(lv, s56c6f5, ABISELECT(152,104), "S56C6.s56c6f5");
    check_field_offset(lv, s56c6f6, ABISELECT(160,108), "S56C6.s56c6f6");
    set_bf_and_test(lv, s56c6f7, ABISELECT(176,120), 0, 1, 1, "S56C6");
    set_bf_and_test(lv, s56c6f8, ABISELECT(176,120), 1, 1, 1, "S56C6");
    set_bf_and_test(lv, s56c6f9, ABISELECT(176,120), 2, 1, 1, "S56C6");
    set_bf_and_test(lv, s56c6f10, ABISELECT(176,120), 3, 1, 1, "S56C6");
    set_bf_and_test(lv, s56c6f11, ABISELECT(176,120), 4, 1, 1, "S56C6");
    check_field_offset(lv, s56c6f12, ABISELECT(180,124), "S56C6.s56c6f12");
    test_class_info(&lv, &cd_S56C6);
    dp->~S56C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS56C6(Test_S56C6, "S56C6", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN5S56C6C1Ev();
extern void _ZN5S56C6D1Ev();
Name_Map name_map_S56C6[] = {
  NSPAIR(_ZN5S56C6C1Ev),
  NSPAIR(_ZN5S56C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S56C7;
extern VTBL_ENTRY _ZTI5S56C7[];
extern  VTBL_ENTRY _ZTV5S56C7[];
static Base_Class bases_S56C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S56C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S56C6[];
extern void _ZN5S56C6D1Ev();
extern void _ZN5S56C6D0Ev();
extern void _ZN5S56C72v3Ev();
extern void _ZN5S56C72v4Ev();
extern void _ZN5S56C72v5Ev();
extern void _ZN5S56C72v6Ev();
extern void _ZN5S56C72v7Ev();
extern void _ZN5S56C72v8Ev();
extern void _ZN5S56C72v9Ev();
extern void _ZN5S56C73v10Ev();
extern void _ZN5S56C73v11Ev();
extern void _ZN5S56C73v12Ev();
extern void _ZN5S56C73v13Ev();
extern void _ZN5S56C73v14Ev();
extern void _ZN5S56C73v15Ev();
extern void _ZN5S56C73v16Ev();
extern void _ZN5S56C73v17Ev();
extern void _ZN5S56C73v18Ev();
extern void _ZN5S56C73v19Ev();
extern void _ZN5S56C73v20Ev();
extern void _ZN5S56C73v21Ev();
extern void _ZN5S56C73v22Ev();
extern void _ZN5S56C73v23Ev();
extern void _ZN5S56C73v24Ev();
extern void _ZN5S56C73v25Ev();
extern void _ZN5S56C73v26Ev();
extern void _ZN5S56C73v27Ev();
extern void _ZN5S56C73v28Ev();
extern void _ZN5S56C73v29Ev();
extern void _ZN5S56C73v30Ev();
extern void _ZN5S56C73v31Ev();
extern void _ZN5S56C73v32Ev();
extern void _ZN5S56C73v33Ev();
extern void _ZN5S56C73v34Ev();
extern void _ZN5S56C73v35Ev();
extern void _ZN5S56C73v36Ev();
extern void _ZN5S56C73v37Ev();
extern void _ZN5S56C73v38Ev();
extern void _ZN5S56C73v39Ev();
extern void _ZN5S56C73v40Ev();
extern void _ZN5S56C73v41Ev();
extern void _ZN5S56C73v42Ev();
extern void _ZN5S56C73v43Ev();
extern void _ZN5S56C73v44Ev();
extern void _ZN5S56C73v45Ev();
extern void _ZN5S56C73v46Ev();
extern void _ZN5S56C73v47Ev();
extern void _ZN5S56C73v48Ev();
extern void _ZN5S56C73v49Ev();
extern void _ZN5S56C73v50Ev();
extern void _ZN5S56C73v51Ev();
extern void _ZN5S56C73v52Ev();
extern void _ZN5S56C73v53Ev();
extern void _ZN5S56C73v54Ev();
extern void _ZN5S56C73v55Ev();
extern void _ZN5S56C73v56Ev();
extern void _ZN5S56C73v57Ev();
extern void _ZN5S56C73v58Ev();
extern void _ZN5S56C73v59Ev();
extern void _ZN5S56C73v60Ev();
extern void _ZN5S56C73v61Ev();
extern void _ZN5S56C73v62Ev();
extern void _ZN5S56C73v63Ev();
extern void _ZN5S56C73v64Ev();
extern void _ZN5S56C73v65Ev();
extern void _ZN5S56C73v66Ev();
extern void _ZN5S56C63v67Ev();
extern void _ZN5S56C63v68Ev();
extern void _ZN5S56C63v69Ev();
extern void _ZN5S56C63v70Ev();
extern void _ZN5S56C63v71Ev();
extern void _ZN5S56C63v72Ev();
extern void _ZN5S56C63v73Ev();
extern void _ZN5S56C63v74Ev();
extern void _ZN5S56C63v75Ev();
extern void _ZN5S56C63v76Ev();
extern void _ZN5S56C63v77Ev();
extern void _ZN5S56C63v78Ev();
extern void _ZN5S56C63v79Ev();
extern void _ZN5S56C63v80Ev();
extern void _ZN5S56C63v81Ev();
extern void _ZN5S56C63v82Ev();
extern void _ZN5S56C63v83Ev();
extern void _ZN5S56C63v84Ev();
extern void _ZN5S56C63v85Ev();
extern void _ZN5S56C63v86Ev();
extern void _ZN5S56C63v87Ev();
extern void _ZN5S56C63v88Ev();
static  VTBL_ENTRY vtc_S56C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S56C6[0]),
  (VTBL_ENTRY)&_ZN5S56C6D1Ev,
  (VTBL_ENTRY)&_ZN5S56C6D0Ev,
  (VTBL_ENTRY)&_ZN5S56C72v3Ev,
  (VTBL_ENTRY)&_ZN5S56C72v4Ev,
  (VTBL_ENTRY)&_ZN5S56C72v5Ev,
  (VTBL_ENTRY)&_ZN5S56C72v6Ev,
  (VTBL_ENTRY)&_ZN5S56C72v7Ev,
  (VTBL_ENTRY)&_ZN5S56C72v8Ev,
  (VTBL_ENTRY)&_ZN5S56C72v9Ev,
  (VTBL_ENTRY)&_ZN5S56C73v10Ev,
  (VTBL_ENTRY)&_ZN5S56C73v11Ev,
  (VTBL_ENTRY)&_ZN5S56C73v12Ev,
  (VTBL_ENTRY)&_ZN5S56C73v13Ev,
  (VTBL_ENTRY)&_ZN5S56C73v14Ev,
  (VTBL_ENTRY)&_ZN5S56C73v15Ev,
  (VTBL_ENTRY)&_ZN5S56C73v16Ev,
  (VTBL_ENTRY)&_ZN5S56C73v17Ev,
  (VTBL_ENTRY)&_ZN5S56C73v18Ev,
  (VTBL_ENTRY)&_ZN5S56C73v19Ev,
  (VTBL_ENTRY)&_ZN5S56C73v20Ev,
  (VTBL_ENTRY)&_ZN5S56C73v21Ev,
  (VTBL_ENTRY)&_ZN5S56C73v22Ev,
  (VTBL_ENTRY)&_ZN5S56C73v23Ev,
  (VTBL_ENTRY)&_ZN5S56C73v24Ev,
  (VTBL_ENTRY)&_ZN5S56C73v25Ev,
  (VTBL_ENTRY)&_ZN5S56C73v26Ev,
  (VTBL_ENTRY)&_ZN5S56C73v27Ev,
  (VTBL_ENTRY)&_ZN5S56C73v28Ev,
  (VTBL_ENTRY)&_ZN5S56C73v29Ev,
  (VTBL_ENTRY)&_ZN5S56C73v30Ev,
  (VTBL_ENTRY)&_ZN5S56C73v31Ev,
  (VTBL_ENTRY)&_ZN5S56C73v32Ev,
  (VTBL_ENTRY)&_ZN5S56C73v33Ev,
  (VTBL_ENTRY)&_ZN5S56C73v34Ev,
  (VTBL_ENTRY)&_ZN5S56C73v35Ev,
  (VTBL_ENTRY)&_ZN5S56C73v36Ev,
  (VTBL_ENTRY)&_ZN5S56C73v37Ev,
  (VTBL_ENTRY)&_ZN5S56C73v38Ev,
  (VTBL_ENTRY)&_ZN5S56C73v39Ev,
  (VTBL_ENTRY)&_ZN5S56C73v40Ev,
  (VTBL_ENTRY)&_ZN5S56C73v41Ev,
  (VTBL_ENTRY)&_ZN5S56C73v42Ev,
  (VTBL_ENTRY)&_ZN5S56C73v43Ev,
  (VTBL_ENTRY)&_ZN5S56C73v44Ev,
  (VTBL_ENTRY)&_ZN5S56C73v45Ev,
  (VTBL_ENTRY)&_ZN5S56C73v46Ev,
  (VTBL_ENTRY)&_ZN5S56C73v47Ev,
  (VTBL_ENTRY)&_ZN5S56C73v48Ev,
  (VTBL_ENTRY)&_ZN5S56C73v49Ev,
  (VTBL_ENTRY)&_ZN5S56C73v50Ev,
  (VTBL_ENTRY)&_ZN5S56C73v51Ev,
  (VTBL_ENTRY)&_ZN5S56C73v52Ev,
  (VTBL_ENTRY)&_ZN5S56C73v53Ev,
  (VTBL_ENTRY)&_ZN5S56C73v54Ev,
  (VTBL_ENTRY)&_ZN5S56C73v55Ev,
  (VTBL_ENTRY)&_ZN5S56C73v56Ev,
  (VTBL_ENTRY)&_ZN5S56C73v57Ev,
  (VTBL_ENTRY)&_ZN5S56C73v58Ev,
  (VTBL_ENTRY)&_ZN5S56C73v59Ev,
  (VTBL_ENTRY)&_ZN5S56C73v60Ev,
  (VTBL_ENTRY)&_ZN5S56C73v61Ev,
  (VTBL_ENTRY)&_ZN5S56C73v62Ev,
  (VTBL_ENTRY)&_ZN5S56C73v63Ev,
  (VTBL_ENTRY)&_ZN5S56C73v64Ev,
  (VTBL_ENTRY)&_ZN5S56C73v65Ev,
  (VTBL_ENTRY)&_ZN5S56C73v66Ev,
  (VTBL_ENTRY)&_ZN5S56C63v67Ev,
  (VTBL_ENTRY)&_ZN5S56C63v68Ev,
  (VTBL_ENTRY)&_ZN5S56C63v69Ev,
  (VTBL_ENTRY)&_ZN5S56C63v70Ev,
  (VTBL_ENTRY)&_ZN5S56C63v71Ev,
  (VTBL_ENTRY)&_ZN5S56C63v72Ev,
  (VTBL_ENTRY)&_ZN5S56C63v73Ev,
  (VTBL_ENTRY)&_ZN5S56C63v74Ev,
  (VTBL_ENTRY)&_ZN5S56C63v75Ev,
  (VTBL_ENTRY)&_ZN5S56C63v76Ev,
  (VTBL_ENTRY)&_ZN5S56C63v77Ev,
  (VTBL_ENTRY)&_ZN5S56C63v78Ev,
  (VTBL_ENTRY)&_ZN5S56C63v79Ev,
  (VTBL_ENTRY)&_ZN5S56C63v80Ev,
  (VTBL_ENTRY)&_ZN5S56C63v81Ev,
  (VTBL_ENTRY)&_ZN5S56C63v82Ev,
  (VTBL_ENTRY)&_ZN5S56C63v83Ev,
  (VTBL_ENTRY)&_ZN5S56C63v84Ev,
  (VTBL_ENTRY)&_ZN5S56C63v85Ev,
  (VTBL_ENTRY)&_ZN5S56C63v86Ev,
  (VTBL_ENTRY)&_ZN5S56C63v87Ev,
  (VTBL_ENTRY)&_ZN5S56C63v88Ev,
};
extern VTBL_ENTRY _ZTI5S56C6[];
extern  VTBL_ENTRY _ZTV5S56C6[];
Class_Descriptor cd_S56C6 = {  "S56C6", // class name
  bases_S56C6, 1,
  &(vtc_S56C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI5S56C6),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S56C6),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S56C5  : S56C6 {
  unsigned int s56c5f0:1;
  unsigned int s56c5f1:1;
  unsigned int s56c5f2:1;
  ::S3350C17 s56c5f3;
  ::S3350C11 s56c5f4;
  ::S3350C5_nt s56c5f5;
  ::S287C27 s56c5f6;
  int s56c5f7[3];
  virtual  ~S56C5(); // _ZN5S56C5D1Ev
  virtual void  v89(); // _ZN5S56C53v89Ev
  virtual void  v90(); // _ZN5S56C53v90Ev
  virtual void  v91(); // _ZN5S56C53v91Ev
  virtual void  v92(); // _ZN5S56C53v92Ev
  virtual void  v93(); // _ZN5S56C53v93Ev
  virtual void  v94(); // _ZN5S56C53v94Ev
  virtual void  v95(); // _ZN5S56C53v95Ev
  virtual void  v96(); // _ZN5S56C53v96Ev
  virtual void  v97(); // _ZN5S56C53v97Ev
  virtual void  v98(); // _ZN5S56C53v98Ev
  virtual void  v99(); // _ZN5S56C53v99Ev
  virtual void  v100(); // _ZN5S56C54v100Ev
  virtual void  v101(); // _ZN5S56C54v101Ev
  virtual void  v102(); // _ZN5S56C54v102Ev
  virtual void  v103(); // _ZN5S56C54v103Ev
  virtual void  v104(); // _ZN5S56C54v104Ev
  virtual void  v105(); // _ZN5S56C54v105Ev
  virtual void  v106(); // _ZN5S56C54v106Ev
  virtual void  v107(); // _ZN5S56C54v107Ev
  virtual void  v108(); // _ZN5S56C54v108Ev
  S56C5(); // tgen
};
//SIG(-1 S56C5) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} FC16{ BC17{ BC8}} Fi[3]}


 S56C5 ::~S56C5(){ note_dtor("S56C5", this);}
void  S56C5 ::v89(){vfunc_called(this, "_ZN5S56C53v89Ev");}
void  S56C5 ::v90(){vfunc_called(this, "_ZN5S56C53v90Ev");}
void  S56C5 ::v91(){vfunc_called(this, "_ZN5S56C53v91Ev");}
void  S56C5 ::v92(){vfunc_called(this, "_ZN5S56C53v92Ev");}
void  S56C5 ::v93(){vfunc_called(this, "_ZN5S56C53v93Ev");}
void  S56C5 ::v94(){vfunc_called(this, "_ZN5S56C53v94Ev");}
void  S56C5 ::v95(){vfunc_called(this, "_ZN5S56C53v95Ev");}
void  S56C5 ::v96(){vfunc_called(this, "_ZN5S56C53v96Ev");}
void  S56C5 ::v97(){vfunc_called(this, "_ZN5S56C53v97Ev");}
void  S56C5 ::v98(){vfunc_called(this, "_ZN5S56C53v98Ev");}
void  S56C5 ::v99(){vfunc_called(this, "_ZN5S56C53v99Ev");}
void  S56C5 ::v100(){vfunc_called(this, "_ZN5S56C54v100Ev");}
void  S56C5 ::v101(){vfunc_called(this, "_ZN5S56C54v101Ev");}
void  S56C5 ::v102(){vfunc_called(this, "_ZN5S56C54v102Ev");}
void  S56C5 ::v103(){vfunc_called(this, "_ZN5S56C54v103Ev");}
void  S56C5 ::v104(){vfunc_called(this, "_ZN5S56C54v104Ev");}
void  S56C5 ::v105(){vfunc_called(this, "_ZN5S56C54v105Ev");}
void  S56C5 ::v106(){vfunc_called(this, "_ZN5S56C54v106Ev");}
void  S56C5 ::v107(){vfunc_called(this, "_ZN5S56C54v107Ev");}
void  S56C5 ::v108(){vfunc_called(this, "_ZN5S56C54v108Ev");}
S56C5 ::S56C5(){ note_ctor("S56C5", this);} // tgen

static void Test_S56C5()
{
  extern Class_Descriptor cd_S56C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(35,50)];
    init_test(&cd_S56C5, buf);
    S56C5 *dp, &lv = *(dp=new (buf) S56C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,196), "sizeof(S56C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S56C5)");
    check_base_class_offset(lv, (S56C7*)(S56C6*), 0, "S56C5");
    check_base_class_offset(lv, (S56C6*), 0, "S56C5");
    set_bf_and_test(lv, s56c5f0, ABISELECT(188,132), 0, 1, 1, "S56C5");
    set_bf_and_test(lv, s56c5f1, ABISELECT(188,132), 1, 1, 1, "S56C5");
    set_bf_and_test(lv, s56c5f2, ABISELECT(188,132), 2, 1, 1, "S56C5");
    check_field_offset(lv, s56c5f3, ABISELECT(192,136), "S56C5.s56c5f3");
    check_field_offset(lv, s56c5f4, ABISELECT(208,148), "S56C5.s56c5f4");
    check_field_offset(lv, s56c5f5, ABISELECT(224,160), "S56C5.s56c5f5");
    check_field_offset(lv, s56c5f6, ABISELECT(240,172), "S56C5.s56c5f6");
    check_field_offset(lv, s56c5f7, ABISELECT(256,184), "S56C5.s56c5f7");
    test_class_info(&lv, &cd_S56C5);
    dp->~S56C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS56C5(Test_S56C5, "S56C5", ABISELECT(272,196));

#else // __cplusplus

extern void _ZN5S56C5C1Ev();
extern void _ZN5S56C5D1Ev();
Name_Map name_map_S56C5[] = {
  NSPAIR(_ZN5S56C5C1Ev),
  NSPAIR(_ZN5S56C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S56C7;
extern VTBL_ENTRY _ZTI5S56C7[];
extern  VTBL_ENTRY _ZTV5S56C7[];
extern Class_Descriptor cd_S56C6;
extern VTBL_ENTRY _ZTI5S56C6[];
extern  VTBL_ENTRY _ZTV5S56C6[];
static Base_Class bases_S56C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S56C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S56C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S56C5[];
extern void _ZN5S56C5D1Ev();
extern void _ZN5S56C5D0Ev();
extern void _ZN5S56C72v3Ev();
extern void _ZN5S56C72v4Ev();
extern void _ZN5S56C72v5Ev();
extern void _ZN5S56C72v6Ev();
extern void _ZN5S56C72v7Ev();
extern void _ZN5S56C72v8Ev();
extern void _ZN5S56C72v9Ev();
extern void _ZN5S56C73v10Ev();
extern void _ZN5S56C73v11Ev();
extern void _ZN5S56C73v12Ev();
extern void _ZN5S56C73v13Ev();
extern void _ZN5S56C73v14Ev();
extern void _ZN5S56C73v15Ev();
extern void _ZN5S56C73v16Ev();
extern void _ZN5S56C73v17Ev();
extern void _ZN5S56C73v18Ev();
extern void _ZN5S56C73v19Ev();
extern void _ZN5S56C73v20Ev();
extern void _ZN5S56C73v21Ev();
extern void _ZN5S56C73v22Ev();
extern void _ZN5S56C73v23Ev();
extern void _ZN5S56C73v24Ev();
extern void _ZN5S56C73v25Ev();
extern void _ZN5S56C73v26Ev();
extern void _ZN5S56C73v27Ev();
extern void _ZN5S56C73v28Ev();
extern void _ZN5S56C73v29Ev();
extern void _ZN5S56C73v30Ev();
extern void _ZN5S56C73v31Ev();
extern void _ZN5S56C73v32Ev();
extern void _ZN5S56C73v33Ev();
extern void _ZN5S56C73v34Ev();
extern void _ZN5S56C73v35Ev();
extern void _ZN5S56C73v36Ev();
extern void _ZN5S56C73v37Ev();
extern void _ZN5S56C73v38Ev();
extern void _ZN5S56C73v39Ev();
extern void _ZN5S56C73v40Ev();
extern void _ZN5S56C73v41Ev();
extern void _ZN5S56C73v42Ev();
extern void _ZN5S56C73v43Ev();
extern void _ZN5S56C73v44Ev();
extern void _ZN5S56C73v45Ev();
extern void _ZN5S56C73v46Ev();
extern void _ZN5S56C73v47Ev();
extern void _ZN5S56C73v48Ev();
extern void _ZN5S56C73v49Ev();
extern void _ZN5S56C73v50Ev();
extern void _ZN5S56C73v51Ev();
extern void _ZN5S56C73v52Ev();
extern void _ZN5S56C73v53Ev();
extern void _ZN5S56C73v54Ev();
extern void _ZN5S56C73v55Ev();
extern void _ZN5S56C73v56Ev();
extern void _ZN5S56C73v57Ev();
extern void _ZN5S56C73v58Ev();
extern void _ZN5S56C73v59Ev();
extern void _ZN5S56C73v60Ev();
extern void _ZN5S56C73v61Ev();
extern void _ZN5S56C73v62Ev();
extern void _ZN5S56C73v63Ev();
extern void _ZN5S56C73v64Ev();
extern void _ZN5S56C73v65Ev();
extern void _ZN5S56C73v66Ev();
extern void _ZN5S56C63v67Ev();
extern void _ZN5S56C63v68Ev();
extern void _ZN5S56C63v69Ev();
extern void _ZN5S56C63v70Ev();
extern void _ZN5S56C63v71Ev();
extern void _ZN5S56C63v72Ev();
extern void _ZN5S56C63v73Ev();
extern void _ZN5S56C63v74Ev();
extern void _ZN5S56C63v75Ev();
extern void _ZN5S56C63v76Ev();
extern void _ZN5S56C63v77Ev();
extern void _ZN5S56C63v78Ev();
extern void _ZN5S56C63v79Ev();
extern void _ZN5S56C63v80Ev();
extern void _ZN5S56C63v81Ev();
extern void _ZN5S56C63v82Ev();
extern void _ZN5S56C63v83Ev();
extern void _ZN5S56C63v84Ev();
extern void _ZN5S56C63v85Ev();
extern void _ZN5S56C63v86Ev();
extern void _ZN5S56C63v87Ev();
extern void _ZN5S56C63v88Ev();
extern void _ZN5S56C53v89Ev();
extern void _ZN5S56C53v90Ev();
extern void _ZN5S56C53v91Ev();
extern void _ZN5S56C53v92Ev();
extern void _ZN5S56C53v93Ev();
extern void _ZN5S56C53v94Ev();
extern void _ZN5S56C53v95Ev();
extern void _ZN5S56C53v96Ev();
extern void _ZN5S56C53v97Ev();
extern void _ZN5S56C53v98Ev();
extern void _ZN5S56C53v99Ev();
extern void _ZN5S56C54v100Ev();
extern void _ZN5S56C54v101Ev();
extern void _ZN5S56C54v102Ev();
extern void _ZN5S56C54v103Ev();
extern void _ZN5S56C54v104Ev();
extern void _ZN5S56C54v105Ev();
extern void _ZN5S56C54v106Ev();
extern void _ZN5S56C54v107Ev();
extern void _ZN5S56C54v108Ev();
static  VTBL_ENTRY vtc_S56C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S56C5[0]),
  (VTBL_ENTRY)&_ZN5S56C5D1Ev,
  (VTBL_ENTRY)&_ZN5S56C5D0Ev,
  (VTBL_ENTRY)&_ZN5S56C72v3Ev,
  (VTBL_ENTRY)&_ZN5S56C72v4Ev,
  (VTBL_ENTRY)&_ZN5S56C72v5Ev,
  (VTBL_ENTRY)&_ZN5S56C72v6Ev,
  (VTBL_ENTRY)&_ZN5S56C72v7Ev,
  (VTBL_ENTRY)&_ZN5S56C72v8Ev,
  (VTBL_ENTRY)&_ZN5S56C72v9Ev,
  (VTBL_ENTRY)&_ZN5S56C73v10Ev,
  (VTBL_ENTRY)&_ZN5S56C73v11Ev,
  (VTBL_ENTRY)&_ZN5S56C73v12Ev,
  (VTBL_ENTRY)&_ZN5S56C73v13Ev,
  (VTBL_ENTRY)&_ZN5S56C73v14Ev,
  (VTBL_ENTRY)&_ZN5S56C73v15Ev,
  (VTBL_ENTRY)&_ZN5S56C73v16Ev,
  (VTBL_ENTRY)&_ZN5S56C73v17Ev,
  (VTBL_ENTRY)&_ZN5S56C73v18Ev,
  (VTBL_ENTRY)&_ZN5S56C73v19Ev,
  (VTBL_ENTRY)&_ZN5S56C73v20Ev,
  (VTBL_ENTRY)&_ZN5S56C73v21Ev,
  (VTBL_ENTRY)&_ZN5S56C73v22Ev,
  (VTBL_ENTRY)&_ZN5S56C73v23Ev,
  (VTBL_ENTRY)&_ZN5S56C73v24Ev,
  (VTBL_ENTRY)&_ZN5S56C73v25Ev,
  (VTBL_ENTRY)&_ZN5S56C73v26Ev,
  (VTBL_ENTRY)&_ZN5S56C73v27Ev,
  (VTBL_ENTRY)&_ZN5S56C73v28Ev,
  (VTBL_ENTRY)&_ZN5S56C73v29Ev,
  (VTBL_ENTRY)&_ZN5S56C73v30Ev,
  (VTBL_ENTRY)&_ZN5S56C73v31Ev,
  (VTBL_ENTRY)&_ZN5S56C73v32Ev,
  (VTBL_ENTRY)&_ZN5S56C73v33Ev,
  (VTBL_ENTRY)&_ZN5S56C73v34Ev,
  (VTBL_ENTRY)&_ZN5S56C73v35Ev,
  (VTBL_ENTRY)&_ZN5S56C73v36Ev,
  (VTBL_ENTRY)&_ZN5S56C73v37Ev,
  (VTBL_ENTRY)&_ZN5S56C73v38Ev,
  (VTBL_ENTRY)&_ZN5S56C73v39Ev,
  (VTBL_ENTRY)&_ZN5S56C73v40Ev,
  (VTBL_ENTRY)&_ZN5S56C73v41Ev,
  (VTBL_ENTRY)&_ZN5S56C73v42Ev,
  (VTBL_ENTRY)&_ZN5S56C73v43Ev,
  (VTBL_ENTRY)&_ZN5S56C73v44Ev,
  (VTBL_ENTRY)&_ZN5S56C73v45Ev,
  (VTBL_ENTRY)&_ZN5S56C73v46Ev,
  (VTBL_ENTRY)&_ZN5S56C73v47Ev,
  (VTBL_ENTRY)&_ZN5S56C73v48Ev,
  (VTBL_ENTRY)&_ZN5S56C73v49Ev,
  (VTBL_ENTRY)&_ZN5S56C73v50Ev,
  (VTBL_ENTRY)&_ZN5S56C73v51Ev,
  (VTBL_ENTRY)&_ZN5S56C73v52Ev,
  (VTBL_ENTRY)&_ZN5S56C73v53Ev,
  (VTBL_ENTRY)&_ZN5S56C73v54Ev,
  (VTBL_ENTRY)&_ZN5S56C73v55Ev,
  (VTBL_ENTRY)&_ZN5S56C73v56Ev,
  (VTBL_ENTRY)&_ZN5S56C73v57Ev,
  (VTBL_ENTRY)&_ZN5S56C73v58Ev,
  (VTBL_ENTRY)&_ZN5S56C73v59Ev,
  (VTBL_ENTRY)&_ZN5S56C73v60Ev,
  (VTBL_ENTRY)&_ZN5S56C73v61Ev,
  (VTBL_ENTRY)&_ZN5S56C73v62Ev,
  (VTBL_ENTRY)&_ZN5S56C73v63Ev,
  (VTBL_ENTRY)&_ZN5S56C73v64Ev,
  (VTBL_ENTRY)&_ZN5S56C73v65Ev,
  (VTBL_ENTRY)&_ZN5S56C73v66Ev,
  (VTBL_ENTRY)&_ZN5S56C63v67Ev,
  (VTBL_ENTRY)&_ZN5S56C63v68Ev,
  (VTBL_ENTRY)&_ZN5S56C63v69Ev,
  (VTBL_ENTRY)&_ZN5S56C63v70Ev,
  (VTBL_ENTRY)&_ZN5S56C63v71Ev,
  (VTBL_ENTRY)&_ZN5S56C63v72Ev,
  (VTBL_ENTRY)&_ZN5S56C63v73Ev,
  (VTBL_ENTRY)&_ZN5S56C63v74Ev,
  (VTBL_ENTRY)&_ZN5S56C63v75Ev,
  (VTBL_ENTRY)&_ZN5S56C63v76Ev,
  (VTBL_ENTRY)&_ZN5S56C63v77Ev,
  (VTBL_ENTRY)&_ZN5S56C63v78Ev,
  (VTBL_ENTRY)&_ZN5S56C63v79Ev,
  (VTBL_ENTRY)&_ZN5S56C63v80Ev,
  (VTBL_ENTRY)&_ZN5S56C63v81Ev,
  (VTBL_ENTRY)&_ZN5S56C63v82Ev,
  (VTBL_ENTRY)&_ZN5S56C63v83Ev,
  (VTBL_ENTRY)&_ZN5S56C63v84Ev,
  (VTBL_ENTRY)&_ZN5S56C63v85Ev,
  (VTBL_ENTRY)&_ZN5S56C63v86Ev,
  (VTBL_ENTRY)&_ZN5S56C63v87Ev,
  (VTBL_ENTRY)&_ZN5S56C63v88Ev,
  (VTBL_ENTRY)&_ZN5S56C53v89Ev,
  (VTBL_ENTRY)&_ZN5S56C53v90Ev,
  (VTBL_ENTRY)&_ZN5S56C53v91Ev,
  (VTBL_ENTRY)&_ZN5S56C53v92Ev,
  (VTBL_ENTRY)&_ZN5S56C53v93Ev,
  (VTBL_ENTRY)&_ZN5S56C53v94Ev,
  (VTBL_ENTRY)&_ZN5S56C53v95Ev,
  (VTBL_ENTRY)&_ZN5S56C53v96Ev,
  (VTBL_ENTRY)&_ZN5S56C53v97Ev,
  (VTBL_ENTRY)&_ZN5S56C53v98Ev,
  (VTBL_ENTRY)&_ZN5S56C53v99Ev,
  (VTBL_ENTRY)&_ZN5S56C54v100Ev,
  (VTBL_ENTRY)&_ZN5S56C54v101Ev,
  (VTBL_ENTRY)&_ZN5S56C54v102Ev,
  (VTBL_ENTRY)&_ZN5S56C54v103Ev,
  (VTBL_ENTRY)&_ZN5S56C54v104Ev,
  (VTBL_ENTRY)&_ZN5S56C54v105Ev,
  (VTBL_ENTRY)&_ZN5S56C54v106Ev,
  (VTBL_ENTRY)&_ZN5S56C54v107Ev,
  (VTBL_ENTRY)&_ZN5S56C54v108Ev,
};
extern VTBL_ENTRY _ZTI5S56C5[];
extern  VTBL_ENTRY _ZTV5S56C5[];
Class_Descriptor cd_S56C5 = {  "S56C5", // class name
  bases_S56C5, 2,
  &(vtc_S56C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI5S56C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S56C5),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S56C4  : S56C5 {
  void *s56c4f0[2];
  int s56c4f1[4];
  unsigned int s56c4f2:1;
  unsigned int s56c4f3:1;
  unsigned int s56c4f4:1;
  char s56c4f5;
  int s56c4f6;
  unsigned int s56c4f7:1;
  ::S287C23 s56c4f8;
  virtual  ~S56C4(); // _ZN5S56C4D1Ev
  virtual void  v109(); // _ZN5S56C44v109Ev
  virtual void  v110(); // _ZN5S56C44v110Ev
  virtual void  v111(); // _ZN5S56C44v111Ev
  virtual void  v112(); // _ZN5S56C44v112Ev
  virtual void  v113(); // _ZN5S56C44v113Ev
  virtual void  v114(); // _ZN5S56C44v114Ev
  virtual void  v115(); // _ZN5S56C44v115Ev
  virtual void  v116(); // _ZN5S56C44v116Ev
  virtual void  v117(); // _ZN5S56C44v117Ev
  virtual void  v118(); // _ZN5S56C44v118Ev
  virtual void  v119(); // _ZN5S56C44v119Ev
  virtual void  v120(); // _ZN5S56C44v120Ev
  virtual void  v121(); // _ZN5S56C44v121Ev
  virtual void  v122(); // _ZN5S56C44v122Ev
  S56C4(); // tgen
};
//SIG(-1 S56C4) C1{ BC2{ BC3{ BC4{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} FC17{ BC18{ BC9}} Fi[3]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] Fi[4] Fi:1 Fi:1 Fi:1 Fc Fi Fi:1 FC19{ BC20{ BC9}}}


 S56C4 ::~S56C4(){ note_dtor("S56C4", this);}
void  S56C4 ::v109(){vfunc_called(this, "_ZN5S56C44v109Ev");}
void  S56C4 ::v110(){vfunc_called(this, "_ZN5S56C44v110Ev");}
void  S56C4 ::v111(){vfunc_called(this, "_ZN5S56C44v111Ev");}
void  S56C4 ::v112(){vfunc_called(this, "_ZN5S56C44v112Ev");}
void  S56C4 ::v113(){vfunc_called(this, "_ZN5S56C44v113Ev");}
void  S56C4 ::v114(){vfunc_called(this, "_ZN5S56C44v114Ev");}
void  S56C4 ::v115(){vfunc_called(this, "_ZN5S56C44v115Ev");}
void  S56C4 ::v116(){vfunc_called(this, "_ZN5S56C44v116Ev");}
void  S56C4 ::v117(){vfunc_called(this, "_ZN5S56C44v117Ev");}
void  S56C4 ::v118(){vfunc_called(this, "_ZN5S56C44v118Ev");}
void  S56C4 ::v119(){vfunc_called(this, "_ZN5S56C44v119Ev");}
void  S56C4 ::v120(){vfunc_called(this, "_ZN5S56C44v120Ev");}
void  S56C4 ::v121(){vfunc_called(this, "_ZN5S56C44v121Ev");}
void  S56C4 ::v122(){vfunc_called(this, "_ZN5S56C44v122Ev");}
S56C4 ::S56C4(){ note_ctor("S56C4", this);} // tgen

static void Test_S56C4()
{
  extern Class_Descriptor cd_S56C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(43,62)];
    init_test(&cd_S56C4, buf);
    S56C4 *dp, &lv = *(dp=new (buf) S56C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(336,244), "sizeof(S56C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S56C4)");
    check_base_class_offset(lv, (S56C7*)(S56C6*)(S56C5*), 0, "S56C4");
    check_base_class_offset(lv, (S56C6*)(S56C5*), 0, "S56C4");
    check_base_class_offset(lv, (S56C5*), 0, "S56C4");
    check_field_offset(lv, s56c4f0, ABISELECT(272,196), "S56C4.s56c4f0");
    check_field_offset(lv, s56c4f1, ABISELECT(288,204), "S56C4.s56c4f1");
    set_bf_and_test(lv, s56c4f2, ABISELECT(304,220), 0, 1, 1, "S56C4");
    set_bf_and_test(lv, s56c4f3, ABISELECT(304,220), 1, 1, 1, "S56C4");
    set_bf_and_test(lv, s56c4f4, ABISELECT(304,220), 2, 1, 1, "S56C4");
    check_field_offset(lv, s56c4f5, ABISELECT(305,221), "S56C4.s56c4f5");
    check_field_offset(lv, s56c4f6, ABISELECT(308,224), "S56C4.s56c4f6");
    set_bf_and_test(lv, s56c4f7, ABISELECT(312,228), 0, 1, 1, "S56C4");
    check_field_offset(lv, s56c4f8, ABISELECT(320,232), "S56C4.s56c4f8");
    test_class_info(&lv, &cd_S56C4);
    dp->~S56C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS56C4(Test_S56C4, "S56C4", ABISELECT(336,244));

#else // __cplusplus

extern void _ZN5S56C4C1Ev();
extern void _ZN5S56C4D1Ev();
Name_Map name_map_S56C4[] = {
  NSPAIR(_ZN5S56C4C1Ev),
  NSPAIR(_ZN5S56C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S56C7;
extern VTBL_ENTRY _ZTI5S56C7[];
extern  VTBL_ENTRY _ZTV5S56C7[];
extern Class_Descriptor cd_S56C6;
extern VTBL_ENTRY _ZTI5S56C6[];
extern  VTBL_ENTRY _ZTV5S56C6[];
extern Class_Descriptor cd_S56C5;
extern VTBL_ENTRY _ZTI5S56C5[];
extern  VTBL_ENTRY _ZTV5S56C5[];
static Base_Class bases_S56C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S56C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S56C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S56C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S56C4[];
extern void _ZN5S56C4D1Ev();
extern void _ZN5S56C4D0Ev();
extern void _ZN5S56C72v3Ev();
extern void _ZN5S56C72v4Ev();
extern void _ZN5S56C72v5Ev();
extern void _ZN5S56C72v6Ev();
extern void _ZN5S56C72v7Ev();
extern void _ZN5S56C72v8Ev();
extern void _ZN5S56C72v9Ev();
extern void _ZN5S56C73v10Ev();
extern void _ZN5S56C73v11Ev();
extern void _ZN5S56C73v12Ev();
extern void _ZN5S56C73v13Ev();
extern void _ZN5S56C73v14Ev();
extern void _ZN5S56C73v15Ev();
extern void _ZN5S56C73v16Ev();
extern void _ZN5S56C73v17Ev();
extern void _ZN5S56C73v18Ev();
extern void _ZN5S56C73v19Ev();
extern void _ZN5S56C73v20Ev();
extern void _ZN5S56C73v21Ev();
extern void _ZN5S56C73v22Ev();
extern void _ZN5S56C73v23Ev();
extern void _ZN5S56C73v24Ev();
extern void _ZN5S56C73v25Ev();
extern void _ZN5S56C73v26Ev();
extern void _ZN5S56C73v27Ev();
extern void _ZN5S56C73v28Ev();
extern void _ZN5S56C73v29Ev();
extern void _ZN5S56C73v30Ev();
extern void _ZN5S56C73v31Ev();
extern void _ZN5S56C73v32Ev();
extern void _ZN5S56C73v33Ev();
extern void _ZN5S56C73v34Ev();
extern void _ZN5S56C73v35Ev();
extern void _ZN5S56C73v36Ev();
extern void _ZN5S56C73v37Ev();
extern void _ZN5S56C73v38Ev();
extern void _ZN5S56C73v39Ev();
extern void _ZN5S56C73v40Ev();
extern void _ZN5S56C73v41Ev();
extern void _ZN5S56C73v42Ev();
extern void _ZN5S56C73v43Ev();
extern void _ZN5S56C73v44Ev();
extern void _ZN5S56C73v45Ev();
extern void _ZN5S56C73v46Ev();
extern void _ZN5S56C73v47Ev();
extern void _ZN5S56C73v48Ev();
extern void _ZN5S56C73v49Ev();
extern void _ZN5S56C73v50Ev();
extern void _ZN5S56C73v51Ev();
extern void _ZN5S56C73v52Ev();
extern void _ZN5S56C73v53Ev();
extern void _ZN5S56C73v54Ev();
extern void _ZN5S56C73v55Ev();
extern void _ZN5S56C73v56Ev();
extern void _ZN5S56C73v57Ev();
extern void _ZN5S56C73v58Ev();
extern void _ZN5S56C73v59Ev();
extern void _ZN5S56C73v60Ev();
extern void _ZN5S56C73v61Ev();
extern void _ZN5S56C73v62Ev();
extern void _ZN5S56C73v63Ev();
extern void _ZN5S56C73v64Ev();
extern void _ZN5S56C73v65Ev();
extern void _ZN5S56C73v66Ev();
extern void _ZN5S56C63v67Ev();
extern void _ZN5S56C63v68Ev();
extern void _ZN5S56C63v69Ev();
extern void _ZN5S56C63v70Ev();
extern void _ZN5S56C63v71Ev();
extern void _ZN5S56C63v72Ev();
extern void _ZN5S56C63v73Ev();
extern void _ZN5S56C63v74Ev();
extern void _ZN5S56C63v75Ev();
extern void _ZN5S56C63v76Ev();
extern void _ZN5S56C63v77Ev();
extern void _ZN5S56C63v78Ev();
extern void _ZN5S56C63v79Ev();
extern void _ZN5S56C63v80Ev();
extern void _ZN5S56C63v81Ev();
extern void _ZN5S56C63v82Ev();
extern void _ZN5S56C63v83Ev();
extern void _ZN5S56C63v84Ev();
extern void _ZN5S56C63v85Ev();
extern void _ZN5S56C63v86Ev();
extern void _ZN5S56C63v87Ev();
extern void _ZN5S56C63v88Ev();
extern void _ZN5S56C53v89Ev();
extern void _ZN5S56C53v90Ev();
extern void _ZN5S56C53v91Ev();
extern void _ZN5S56C53v92Ev();
extern void _ZN5S56C53v93Ev();
extern void _ZN5S56C53v94Ev();
extern void _ZN5S56C53v95Ev();
extern void _ZN5S56C53v96Ev();
extern void _ZN5S56C53v97Ev();
extern void _ZN5S56C53v98Ev();
extern void _ZN5S56C53v99Ev();
extern void _ZN5S56C54v100Ev();
extern void _ZN5S56C54v101Ev();
extern void _ZN5S56C54v102Ev();
extern void _ZN5S56C54v103Ev();
extern void _ZN5S56C54v104Ev();
extern void _ZN5S56C54v105Ev();
extern void _ZN5S56C54v106Ev();
extern void _ZN5S56C54v107Ev();
extern void _ZN5S56C54v108Ev();
extern void _ZN5S56C44v109Ev();
extern void _ZN5S56C44v110Ev();
extern void _ZN5S56C44v111Ev();
extern void _ZN5S56C44v112Ev();
extern void _ZN5S56C44v113Ev();
extern void _ZN5S56C44v114Ev();
extern void _ZN5S56C44v115Ev();
extern void _ZN5S56C44v116Ev();
extern void _ZN5S56C44v117Ev();
extern void _ZN5S56C44v118Ev();
extern void _ZN5S56C44v119Ev();
extern void _ZN5S56C44v120Ev();
extern void _ZN5S56C44v121Ev();
extern void _ZN5S56C44v122Ev();
static  VTBL_ENTRY vtc_S56C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S56C4[0]),
  (VTBL_ENTRY)&_ZN5S56C4D1Ev,
  (VTBL_ENTRY)&_ZN5S56C4D0Ev,
  (VTBL_ENTRY)&_ZN5S56C72v3Ev,
  (VTBL_ENTRY)&_ZN5S56C72v4Ev,
  (VTBL_ENTRY)&_ZN5S56C72v5Ev,
  (VTBL_ENTRY)&_ZN5S56C72v6Ev,
  (VTBL_ENTRY)&_ZN5S56C72v7Ev,
  (VTBL_ENTRY)&_ZN5S56C72v8Ev,
  (VTBL_ENTRY)&_ZN5S56C72v9Ev,
  (VTBL_ENTRY)&_ZN5S56C73v10Ev,
  (VTBL_ENTRY)&_ZN5S56C73v11Ev,
  (VTBL_ENTRY)&_ZN5S56C73v12Ev,
  (VTBL_ENTRY)&_ZN5S56C73v13Ev,
  (VTBL_ENTRY)&_ZN5S56C73v14Ev,
  (VTBL_ENTRY)&_ZN5S56C73v15Ev,
  (VTBL_ENTRY)&_ZN5S56C73v16Ev,
  (VTBL_ENTRY)&_ZN5S56C73v17Ev,
  (VTBL_ENTRY)&_ZN5S56C73v18Ev,
  (VTBL_ENTRY)&_ZN5S56C73v19Ev,
  (VTBL_ENTRY)&_ZN5S56C73v20Ev,
  (VTBL_ENTRY)&_ZN5S56C73v21Ev,
  (VTBL_ENTRY)&_ZN5S56C73v22Ev,
  (VTBL_ENTRY)&_ZN5S56C73v23Ev,
  (VTBL_ENTRY)&_ZN5S56C73v24Ev,
  (VTBL_ENTRY)&_ZN5S56C73v25Ev,
  (VTBL_ENTRY)&_ZN5S56C73v26Ev,
  (VTBL_ENTRY)&_ZN5S56C73v27Ev,
  (VTBL_ENTRY)&_ZN5S56C73v28Ev,
  (VTBL_ENTRY)&_ZN5S56C73v29Ev,
  (VTBL_ENTRY)&_ZN5S56C73v30Ev,
  (VTBL_ENTRY)&_ZN5S56C73v31Ev,
  (VTBL_ENTRY)&_ZN5S56C73v32Ev,
  (VTBL_ENTRY)&_ZN5S56C73v33Ev,
  (VTBL_ENTRY)&_ZN5S56C73v34Ev,
  (VTBL_ENTRY)&_ZN5S56C73v35Ev,
  (VTBL_ENTRY)&_ZN5S56C73v36Ev,
  (VTBL_ENTRY)&_ZN5S56C73v37Ev,
  (VTBL_ENTRY)&_ZN5S56C73v38Ev,
  (VTBL_ENTRY)&_ZN5S56C73v39Ev,
  (VTBL_ENTRY)&_ZN5S56C73v40Ev,
  (VTBL_ENTRY)&_ZN5S56C73v41Ev,
  (VTBL_ENTRY)&_ZN5S56C73v42Ev,
  (VTBL_ENTRY)&_ZN5S56C73v43Ev,
  (VTBL_ENTRY)&_ZN5S56C73v44Ev,
  (VTBL_ENTRY)&_ZN5S56C73v45Ev,
  (VTBL_ENTRY)&_ZN5S56C73v46Ev,
  (VTBL_ENTRY)&_ZN5S56C73v47Ev,
  (VTBL_ENTRY)&_ZN5S56C73v48Ev,
  (VTBL_ENTRY)&_ZN5S56C73v49Ev,
  (VTBL_ENTRY)&_ZN5S56C73v50Ev,
  (VTBL_ENTRY)&_ZN5S56C73v51Ev,
  (VTBL_ENTRY)&_ZN5S56C73v52Ev,
  (VTBL_ENTRY)&_ZN5S56C73v53Ev,
  (VTBL_ENTRY)&_ZN5S56C73v54Ev,
  (VTBL_ENTRY)&_ZN5S56C73v55Ev,
  (VTBL_ENTRY)&_ZN5S56C73v56Ev,
  (VTBL_ENTRY)&_ZN5S56C73v57Ev,
  (VTBL_ENTRY)&_ZN5S56C73v58Ev,
  (VTBL_ENTRY)&_ZN5S56C73v59Ev,
  (VTBL_ENTRY)&_ZN5S56C73v60Ev,
  (VTBL_ENTRY)&_ZN5S56C73v61Ev,
  (VTBL_ENTRY)&_ZN5S56C73v62Ev,
  (VTBL_ENTRY)&_ZN5S56C73v63Ev,
  (VTBL_ENTRY)&_ZN5S56C73v64Ev,
  (VTBL_ENTRY)&_ZN5S56C73v65Ev,
  (VTBL_ENTRY)&_ZN5S56C73v66Ev,
  (VTBL_ENTRY)&_ZN5S56C63v67Ev,
  (VTBL_ENTRY)&_ZN5S56C63v68Ev,
  (VTBL_ENTRY)&_ZN5S56C63v69Ev,
  (VTBL_ENTRY)&_ZN5S56C63v70Ev,
  (VTBL_ENTRY)&_ZN5S56C63v71Ev,
  (VTBL_ENTRY)&_ZN5S56C63v72Ev,
  (VTBL_ENTRY)&_ZN5S56C63v73Ev,
  (VTBL_ENTRY)&_ZN5S56C63v74Ev,
  (VTBL_ENTRY)&_ZN5S56C63v75Ev,
  (VTBL_ENTRY)&_ZN5S56C63v76Ev,
  (VTBL_ENTRY)&_ZN5S56C63v77Ev,
  (VTBL_ENTRY)&_ZN5S56C63v78Ev,
  (VTBL_ENTRY)&_ZN5S56C63v79Ev,
  (VTBL_ENTRY)&_ZN5S56C63v80Ev,
  (VTBL_ENTRY)&_ZN5S56C63v81Ev,
  (VTBL_ENTRY)&_ZN5S56C63v82Ev,
  (VTBL_ENTRY)&_ZN5S56C63v83Ev,
  (VTBL_ENTRY)&_ZN5S56C63v84Ev,
  (VTBL_ENTRY)&_ZN5S56C63v85Ev,
  (VTBL_ENTRY)&_ZN5S56C63v86Ev,
  (VTBL_ENTRY)&_ZN5S56C63v87Ev,
  (VTBL_ENTRY)&_ZN5S56C63v88Ev,
  (VTBL_ENTRY)&_ZN5S56C53v89Ev,
  (VTBL_ENTRY)&_ZN5S56C53v90Ev,
  (VTBL_ENTRY)&_ZN5S56C53v91Ev,
  (VTBL_ENTRY)&_ZN5S56C53v92Ev,
  (VTBL_ENTRY)&_ZN5S56C53v93Ev,
  (VTBL_ENTRY)&_ZN5S56C53v94Ev,
  (VTBL_ENTRY)&_ZN5S56C53v95Ev,
  (VTBL_ENTRY)&_ZN5S56C53v96Ev,
  (VTBL_ENTRY)&_ZN5S56C53v97Ev,
  (VTBL_ENTRY)&_ZN5S56C53v98Ev,
  (VTBL_ENTRY)&_ZN5S56C53v99Ev,
  (VTBL_ENTRY)&_ZN5S56C54v100Ev,
  (VTBL_ENTRY)&_ZN5S56C54v101Ev,
  (VTBL_ENTRY)&_ZN5S56C54v102Ev,
  (VTBL_ENTRY)&_ZN5S56C54v103Ev,
  (VTBL_ENTRY)&_ZN5S56C54v104Ev,
  (VTBL_ENTRY)&_ZN5S56C54v105Ev,
  (VTBL_ENTRY)&_ZN5S56C54v106Ev,
  (VTBL_ENTRY)&_ZN5S56C54v107Ev,
  (VTBL_ENTRY)&_ZN5S56C54v108Ev,
  (VTBL_ENTRY)&_ZN5S56C44v109Ev,
  (VTBL_ENTRY)&_ZN5S56C44v110Ev,
  (VTBL_ENTRY)&_ZN5S56C44v111Ev,
  (VTBL_ENTRY)&_ZN5S56C44v112Ev,
  (VTBL_ENTRY)&_ZN5S56C44v113Ev,
  (VTBL_ENTRY)&_ZN5S56C44v114Ev,
  (VTBL_ENTRY)&_ZN5S56C44v115Ev,
  (VTBL_ENTRY)&_ZN5S56C44v116Ev,
  (VTBL_ENTRY)&_ZN5S56C44v117Ev,
  (VTBL_ENTRY)&_ZN5S56C44v118Ev,
  (VTBL_ENTRY)&_ZN5S56C44v119Ev,
  (VTBL_ENTRY)&_ZN5S56C44v120Ev,
  (VTBL_ENTRY)&_ZN5S56C44v121Ev,
  (VTBL_ENTRY)&_ZN5S56C44v122Ev,
};
extern VTBL_ENTRY _ZTI5S56C4[];
extern  VTBL_ENTRY _ZTV5S56C4[];
Class_Descriptor cd_S56C4 = {  "S56C4", // class name
  bases_S56C4, 3,
  &(vtc_S56C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(336,244), // object size
  NSPAIRA(_ZTI5S56C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S56C4),124, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S56C3  : S56C4 {
  void *s56c3f0[2];
  ::S287C8_nt s56c3f1;
  unsigned int s56c3f2:1;
  unsigned int s56c3f3:1;
  ::S3350C21_nt s56c3f4;
  virtual  ~S56C3(); // _ZN5S56C3D1Ev
  virtual void  v123(); // _ZN5S56C34v123Ev
  virtual void  v124(); // _ZN5S56C34v124Ev
  virtual void  v125(); // _ZN5S56C34v125Ev
  virtual void  v126(); // _ZN5S56C34v126Ev
  virtual void  v127(); // _ZN5S56C34v127Ev
  virtual void  v128(); // _ZN5S56C34v128Ev
  virtual void  v129(); // _ZN5S56C34v129Ev
  virtual void  v130(); // _ZN5S56C34v130Ev
  virtual void  v131(); // _ZN5S56C34v131Ev
  virtual void  v132(); // _ZN5S56C34v132Ev
  virtual void  v133(); // _ZN5S56C34v133Ev
  S56C3(); // tgen
};
//SIG(-1 S56C3) C1{ BC2{ BC3{ BC4{ BC5{ vd v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} FC18{ BC19{ BC10}} Fi[3]} vd v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 Fp[2] Fi[4] Fi:1 Fi:1 Fi:1 Fc Fi Fi:1 FC20{ BC21{ BC10}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 Fp[2] FC7 Fi:1 Fi:1 FC22{ m Fp FC6}}


 S56C3 ::~S56C3(){ note_dtor("S56C3", this);}
void  S56C3 ::v123(){vfunc_called(this, "_ZN5S56C34v123Ev");}
void  S56C3 ::v124(){vfunc_called(this, "_ZN5S56C34v124Ev");}
void  S56C3 ::v125(){vfunc_called(this, "_ZN5S56C34v125Ev");}
void  S56C3 ::v126(){vfunc_called(this, "_ZN5S56C34v126Ev");}
void  S56C3 ::v127(){vfunc_called(this, "_ZN5S56C34v127Ev");}
void  S56C3 ::v128(){vfunc_called(this, "_ZN5S56C34v128Ev");}
void  S56C3 ::v129(){vfunc_called(this, "_ZN5S56C34v129Ev");}
void  S56C3 ::v130(){vfunc_called(this, "_ZN5S56C34v130Ev");}
void  S56C3 ::v131(){vfunc_called(this, "_ZN5S56C34v131Ev");}
void  S56C3 ::v132(){vfunc_called(this, "_ZN5S56C34v132Ev");}
void  S56C3 ::v133(){vfunc_called(this, "_ZN5S56C34v133Ev");}
S56C3 ::S56C3(){ note_ctor("S56C3", this);} // tgen

static void Test_S56C3()
{
  extern Class_Descriptor cd_S56C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(50,71)];
    init_test(&cd_S56C3, buf);
    S56C3 *dp, &lv = *(dp=new (buf) S56C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(392,280), "sizeof(S56C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S56C3)");
    check_base_class_offset(lv, (S56C7*)(S56C6*)(S56C5*)(S56C4*), 0, "S56C3");
    check_base_class_offset(lv, (S56C6*)(S56C5*)(S56C4*), 0, "S56C3");
    check_base_class_offset(lv, (S56C5*)(S56C4*), 0, "S56C3");
    check_base_class_offset(lv, (S56C4*), 0, "S56C3");
    check_field_offset(lv, s56c3f0, ABISELECT(336,244), "S56C3.s56c3f0");
    check_field_offset(lv, s56c3f1, ABISELECT(352,252), "S56C3.s56c3f1");
    set_bf_and_test(lv, s56c3f2, ABISELECT(368,264), 0, 1, 1, "S56C3");
    set_bf_and_test(lv, s56c3f3, ABISELECT(368,264), 1, 1, 1, "S56C3");
    check_field_offset(lv, s56c3f4, ABISELECT(376,268), "S56C3.s56c3f4");
    test_class_info(&lv, &cd_S56C3);
    dp->~S56C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS56C3(Test_S56C3, "S56C3", ABISELECT(392,280));

#else // __cplusplus

extern void _ZN5S56C3C1Ev();
extern void _ZN5S56C3D1Ev();
Name_Map name_map_S56C3[] = {
  NSPAIR(_ZN5S56C3C1Ev),
  NSPAIR(_ZN5S56C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S56C7;
extern VTBL_ENTRY _ZTI5S56C7[];
extern  VTBL_ENTRY _ZTV5S56C7[];
extern Class_Descriptor cd_S56C6;
extern VTBL_ENTRY _ZTI5S56C6[];
extern  VTBL_ENTRY _ZTV5S56C6[];
extern Class_Descriptor cd_S56C5;
extern VTBL_ENTRY _ZTI5S56C5[];
extern  VTBL_ENTRY _ZTV5S56C5[];
extern Class_Descriptor cd_S56C4;
extern VTBL_ENTRY _ZTI5S56C4[];
extern  VTBL_ENTRY _ZTV5S56C4[];
static Base_Class bases_S56C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S56C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S56C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S56C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S56C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S56C3[];
extern void _ZN5S56C3D1Ev();
extern void _ZN5S56C3D0Ev();
extern void _ZN5S56C72v3Ev();
extern void _ZN5S56C72v4Ev();
extern void _ZN5S56C72v5Ev();
extern void _ZN5S56C72v6Ev();
extern void _ZN5S56C72v7Ev();
extern void _ZN5S56C72v8Ev();
extern void _ZN5S56C72v9Ev();
extern void _ZN5S56C73v10Ev();
extern void _ZN5S56C73v11Ev();
extern void _ZN5S56C73v12Ev();
extern void _ZN5S56C73v13Ev();
extern void _ZN5S56C73v14Ev();
extern void _ZN5S56C73v15Ev();
extern void _ZN5S56C73v16Ev();
extern void _ZN5S56C73v17Ev();
extern void _ZN5S56C73v18Ev();
extern void _ZN5S56C73v19Ev();
extern void _ZN5S56C73v20Ev();
extern void _ZN5S56C73v21Ev();
extern void _ZN5S56C73v22Ev();
extern void _ZN5S56C73v23Ev();
extern void _ZN5S56C73v24Ev();
extern void _ZN5S56C73v25Ev();
extern void _ZN5S56C73v26Ev();
extern void _ZN5S56C73v27Ev();
extern void _ZN5S56C73v28Ev();
extern void _ZN5S56C73v29Ev();
extern void _ZN5S56C73v30Ev();
extern void _ZN5S56C73v31Ev();
extern void _ZN5S56C73v32Ev();
extern void _ZN5S56C73v33Ev();
extern void _ZN5S56C73v34Ev();
extern void _ZN5S56C73v35Ev();
extern void _ZN5S56C73v36Ev();
extern void _ZN5S56C73v37Ev();
extern void _ZN5S56C73v38Ev();
extern void _ZN5S56C73v39Ev();
extern void _ZN5S56C73v40Ev();
extern void _ZN5S56C73v41Ev();
extern void _ZN5S56C73v42Ev();
extern void _ZN5S56C73v43Ev();
extern void _ZN5S56C73v44Ev();
extern void _ZN5S56C73v45Ev();
extern void _ZN5S56C73v46Ev();
extern void _ZN5S56C73v47Ev();
extern void _ZN5S56C73v48Ev();
extern void _ZN5S56C73v49Ev();
extern void _ZN5S56C73v50Ev();
extern void _ZN5S56C73v51Ev();
extern void _ZN5S56C73v52Ev();
extern void _ZN5S56C73v53Ev();
extern void _ZN5S56C73v54Ev();
extern void _ZN5S56C73v55Ev();
extern void _ZN5S56C73v56Ev();
extern void _ZN5S56C73v57Ev();
extern void _ZN5S56C73v58Ev();
extern void _ZN5S56C73v59Ev();
extern void _ZN5S56C73v60Ev();
extern void _ZN5S56C73v61Ev();
extern void _ZN5S56C73v62Ev();
extern void _ZN5S56C73v63Ev();
extern void _ZN5S56C73v64Ev();
extern void _ZN5S56C73v65Ev();
extern void _ZN5S56C73v66Ev();
extern void _ZN5S56C63v67Ev();
extern void _ZN5S56C63v68Ev();
extern void _ZN5S56C63v69Ev();
extern void _ZN5S56C63v70Ev();
extern void _ZN5S56C63v71Ev();
extern void _ZN5S56C63v72Ev();
extern void _ZN5S56C63v73Ev();
extern void _ZN5S56C63v74Ev();
extern void _ZN5S56C63v75Ev();
extern void _ZN5S56C63v76Ev();
extern void _ZN5S56C63v77Ev();
extern void _ZN5S56C63v78Ev();
extern void _ZN5S56C63v79Ev();
extern void _ZN5S56C63v80Ev();
extern void _ZN5S56C63v81Ev();
extern void _ZN5S56C63v82Ev();
extern void _ZN5S56C63v83Ev();
extern void _ZN5S56C63v84Ev();
extern void _ZN5S56C63v85Ev();
extern void _ZN5S56C63v86Ev();
extern void _ZN5S56C63v87Ev();
extern void _ZN5S56C63v88Ev();
extern void _ZN5S56C53v89Ev();
extern void _ZN5S56C53v90Ev();
extern void _ZN5S56C53v91Ev();
extern void _ZN5S56C53v92Ev();
extern void _ZN5S56C53v93Ev();
extern void _ZN5S56C53v94Ev();
extern void _ZN5S56C53v95Ev();
extern void _ZN5S56C53v96Ev();
extern void _ZN5S56C53v97Ev();
extern void _ZN5S56C53v98Ev();
extern void _ZN5S56C53v99Ev();
extern void _ZN5S56C54v100Ev();
extern void _ZN5S56C54v101Ev();
extern void _ZN5S56C54v102Ev();
extern void _ZN5S56C54v103Ev();
extern void _ZN5S56C54v104Ev();
extern void _ZN5S56C54v105Ev();
extern void _ZN5S56C54v106Ev();
extern void _ZN5S56C54v107Ev();
extern void _ZN5S56C54v108Ev();
extern void _ZN5S56C44v109Ev();
extern void _ZN5S56C44v110Ev();
extern void _ZN5S56C44v111Ev();
extern void _ZN5S56C44v112Ev();
extern void _ZN5S56C44v113Ev();
extern void _ZN5S56C44v114Ev();
extern void _ZN5S56C44v115Ev();
extern void _ZN5S56C44v116Ev();
extern void _ZN5S56C44v117Ev();
extern void _ZN5S56C44v118Ev();
extern void _ZN5S56C44v119Ev();
extern void _ZN5S56C44v120Ev();
extern void _ZN5S56C44v121Ev();
extern void _ZN5S56C44v122Ev();
extern void _ZN5S56C34v123Ev();
extern void _ZN5S56C34v124Ev();
extern void _ZN5S56C34v125Ev();
extern void _ZN5S56C34v126Ev();
extern void _ZN5S56C34v127Ev();
extern void _ZN5S56C34v128Ev();
extern void _ZN5S56C34v129Ev();
extern void _ZN5S56C34v130Ev();
extern void _ZN5S56C34v131Ev();
extern void _ZN5S56C34v132Ev();
extern void _ZN5S56C34v133Ev();
static  VTBL_ENTRY vtc_S56C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S56C3[0]),
  (VTBL_ENTRY)&_ZN5S56C3D1Ev,
  (VTBL_ENTRY)&_ZN5S56C3D0Ev,
  (VTBL_ENTRY)&_ZN5S56C72v3Ev,
  (VTBL_ENTRY)&_ZN5S56C72v4Ev,
  (VTBL_ENTRY)&_ZN5S56C72v5Ev,
  (VTBL_ENTRY)&_ZN5S56C72v6Ev,
  (VTBL_ENTRY)&_ZN5S56C72v7Ev,
  (VTBL_ENTRY)&_ZN5S56C72v8Ev,
  (VTBL_ENTRY)&_ZN5S56C72v9Ev,
  (VTBL_ENTRY)&_ZN5S56C73v10Ev,
  (VTBL_ENTRY)&_ZN5S56C73v11Ev,
  (VTBL_ENTRY)&_ZN5S56C73v12Ev,
  (VTBL_ENTRY)&_ZN5S56C73v13Ev,
  (VTBL_ENTRY)&_ZN5S56C73v14Ev,
  (VTBL_ENTRY)&_ZN5S56C73v15Ev,
  (VTBL_ENTRY)&_ZN5S56C73v16Ev,
  (VTBL_ENTRY)&_ZN5S56C73v17Ev,
  (VTBL_ENTRY)&_ZN5S56C73v18Ev,
  (VTBL_ENTRY)&_ZN5S56C73v19Ev,
  (VTBL_ENTRY)&_ZN5S56C73v20Ev,
  (VTBL_ENTRY)&_ZN5S56C73v21Ev,
  (VTBL_ENTRY)&_ZN5S56C73v22Ev,
  (VTBL_ENTRY)&_ZN5S56C73v23Ev,
  (VTBL_ENTRY)&_ZN5S56C73v24Ev,
  (VTBL_ENTRY)&_ZN5S56C73v25Ev,
  (VTBL_ENTRY)&_ZN5S56C73v26Ev,
  (VTBL_ENTRY)&_ZN5S56C73v27Ev,
  (VTBL_ENTRY)&_ZN5S56C73v28Ev,
  (VTBL_ENTRY)&_ZN5S56C73v29Ev,
  (VTBL_ENTRY)&_ZN5S56C73v30Ev,
  (VTBL_ENTRY)&_ZN5S56C73v31Ev,
  (VTBL_ENTRY)&_ZN5S56C73v32Ev,
  (VTBL_ENTRY)&_ZN5S56C73v33Ev,
  (VTBL_ENTRY)&_ZN5S56C73v34Ev,
  (VTBL_ENTRY)&_ZN5S56C73v35Ev,
  (VTBL_ENTRY)&_ZN5S56C73v36Ev,
  (VTBL_ENTRY)&_ZN5S56C73v37Ev,
  (VTBL_ENTRY)&_ZN5S56C73v38Ev,
  (VTBL_ENTRY)&_ZN5S56C73v39Ev,
  (VTBL_ENTRY)&_ZN5S56C73v40Ev,
  (VTBL_ENTRY)&_ZN5S56C73v41Ev,
  (VTBL_ENTRY)&_ZN5S56C73v42Ev,
  (VTBL_ENTRY)&_ZN5S56C73v43Ev,
  (VTBL_ENTRY)&_ZN5S56C73v44Ev,
  (VTBL_ENTRY)&_ZN5S56C73v45Ev,
  (VTBL_ENTRY)&_ZN5S56C73v46Ev,
  (VTBL_ENTRY)&_ZN5S56C73v47Ev,
  (VTBL_ENTRY)&_ZN5S56C73v48Ev,
  (VTBL_ENTRY)&_ZN5S56C73v49Ev,
  (VTBL_ENTRY)&_ZN5S56C73v50Ev,
  (VTBL_ENTRY)&_ZN5S56C73v51Ev,
  (VTBL_ENTRY)&_ZN5S56C73v52Ev,
  (VTBL_ENTRY)&_ZN5S56C73v53Ev,
  (VTBL_ENTRY)&_ZN5S56C73v54Ev,
  (VTBL_ENTRY)&_ZN5S56C73v55Ev,
  (VTBL_ENTRY)&_ZN5S56C73v56Ev,
  (VTBL_ENTRY)&_ZN5S56C73v57Ev,
  (VTBL_ENTRY)&_ZN5S56C73v58Ev,
  (VTBL_ENTRY)&_ZN5S56C73v59Ev,
  (VTBL_ENTRY)&_ZN5S56C73v60Ev,
  (VTBL_ENTRY)&_ZN5S56C73v61Ev,
  (VTBL_ENTRY)&_ZN5S56C73v62Ev,
  (VTBL_ENTRY)&_ZN5S56C73v63Ev,
  (VTBL_ENTRY)&_ZN5S56C73v64Ev,
  (VTBL_ENTRY)&_ZN5S56C73v65Ev,
  (VTBL_ENTRY)&_ZN5S56C73v66Ev,
  (VTBL_ENTRY)&_ZN5S56C63v67Ev,
  (VTBL_ENTRY)&_ZN5S56C63v68Ev,
  (VTBL_ENTRY)&_ZN5S56C63v69Ev,
  (VTBL_ENTRY)&_ZN5S56C63v70Ev,
  (VTBL_ENTRY)&_ZN5S56C63v71Ev,
  (VTBL_ENTRY)&_ZN5S56C63v72Ev,
  (VTBL_ENTRY)&_ZN5S56C63v73Ev,
  (VTBL_ENTRY)&_ZN5S56C63v74Ev,
  (VTBL_ENTRY)&_ZN5S56C63v75Ev,
  (VTBL_ENTRY)&_ZN5S56C63v76Ev,
  (VTBL_ENTRY)&_ZN5S56C63v77Ev,
  (VTBL_ENTRY)&_ZN5S56C63v78Ev,
  (VTBL_ENTRY)&_ZN5S56C63v79Ev,
  (VTBL_ENTRY)&_ZN5S56C63v80Ev,
  (VTBL_ENTRY)&_ZN5S56C63v81Ev,
  (VTBL_ENTRY)&_ZN5S56C63v82Ev,
  (VTBL_ENTRY)&_ZN5S56C63v83Ev,
  (VTBL_ENTRY)&_ZN5S56C63v84Ev,
  (VTBL_ENTRY)&_ZN5S56C63v85Ev,
  (VTBL_ENTRY)&_ZN5S56C63v86Ev,
  (VTBL_ENTRY)&_ZN5S56C63v87Ev,
  (VTBL_ENTRY)&_ZN5S56C63v88Ev,
  (VTBL_ENTRY)&_ZN5S56C53v89Ev,
  (VTBL_ENTRY)&_ZN5S56C53v90Ev,
  (VTBL_ENTRY)&_ZN5S56C53v91Ev,
  (VTBL_ENTRY)&_ZN5S56C53v92Ev,
  (VTBL_ENTRY)&_ZN5S56C53v93Ev,
  (VTBL_ENTRY)&_ZN5S56C53v94Ev,
  (VTBL_ENTRY)&_ZN5S56C53v95Ev,
  (VTBL_ENTRY)&_ZN5S56C53v96Ev,
  (VTBL_ENTRY)&_ZN5S56C53v97Ev,
  (VTBL_ENTRY)&_ZN5S56C53v98Ev,
  (VTBL_ENTRY)&_ZN5S56C53v99Ev,
  (VTBL_ENTRY)&_ZN5S56C54v100Ev,
  (VTBL_ENTRY)&_ZN5S56C54v101Ev,
  (VTBL_ENTRY)&_ZN5S56C54v102Ev,
  (VTBL_ENTRY)&_ZN5S56C54v103Ev,
  (VTBL_ENTRY)&_ZN5S56C54v104Ev,
  (VTBL_ENTRY)&_ZN5S56C54v105Ev,
  (VTBL_ENTRY)&_ZN5S56C54v106Ev,
  (VTBL_ENTRY)&_ZN5S56C54v107Ev,
  (VTBL_ENTRY)&_ZN5S56C54v108Ev,
  (VTBL_ENTRY)&_ZN5S56C44v109Ev,
  (VTBL_ENTRY)&_ZN5S56C44v110Ev,
  (VTBL_ENTRY)&_ZN5S56C44v111Ev,
  (VTBL_ENTRY)&_ZN5S56C44v112Ev,
  (VTBL_ENTRY)&_ZN5S56C44v113Ev,
  (VTBL_ENTRY)&_ZN5S56C44v114Ev,
  (VTBL_ENTRY)&_ZN5S56C44v115Ev,
  (VTBL_ENTRY)&_ZN5S56C44v116Ev,
  (VTBL_ENTRY)&_ZN5S56C44v117Ev,
  (VTBL_ENTRY)&_ZN5S56C44v118Ev,
  (VTBL_ENTRY)&_ZN5S56C44v119Ev,
  (VTBL_ENTRY)&_ZN5S56C44v120Ev,
  (VTBL_ENTRY)&_ZN5S56C44v121Ev,
  (VTBL_ENTRY)&_ZN5S56C44v122Ev,
  (VTBL_ENTRY)&_ZN5S56C34v123Ev,
  (VTBL_ENTRY)&_ZN5S56C34v124Ev,
  (VTBL_ENTRY)&_ZN5S56C34v125Ev,
  (VTBL_ENTRY)&_ZN5S56C34v126Ev,
  (VTBL_ENTRY)&_ZN5S56C34v127Ev,
  (VTBL_ENTRY)&_ZN5S56C34v128Ev,
  (VTBL_ENTRY)&_ZN5S56C34v129Ev,
  (VTBL_ENTRY)&_ZN5S56C34v130Ev,
  (VTBL_ENTRY)&_ZN5S56C34v131Ev,
  (VTBL_ENTRY)&_ZN5S56C34v132Ev,
  (VTBL_ENTRY)&_ZN5S56C34v133Ev,
};
extern VTBL_ENTRY _ZTI5S56C3[];
extern  VTBL_ENTRY _ZTV5S56C3[];
Class_Descriptor cd_S56C3 = {  "S56C3", // class name
  bases_S56C3, 4,
  &(vtc_S56C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(392,280), // object size
  NSPAIRA(_ZTI5S56C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S56C3),135, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S56C2  : S56C3 {
  virtual  ~S56C2(); // _ZN5S56C2D1Ev
  virtual void  v134(); // _ZN5S56C24v134Ev
  virtual void  v135(); // _ZN5S56C24v135Ev
  S56C2(); // tgen
};
//SIG(-1 S56C2) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi[2] Fp Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 FC12{ m} FC8 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 Fi:1 Fi:1 Fi:1 FC13{ BC14{ BC11}} FC15{ BC16{ BC11}} FC17{ BC18{ BC11}} FC19{ BC20{ BC11}} Fi[3]} vd v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 Fp[2] Fi[4] Fi:1 Fi:1 Fi:1 Fc Fi Fi:1 FC21{ BC22{ BC11}}} vd v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 Fp[2] FC8 Fi:1 Fi:1 FC23{ m Fp FC7}} vd v1 v2}


 S56C2 ::~S56C2(){ note_dtor("S56C2", this);}
void  S56C2 ::v134(){vfunc_called(this, "_ZN5S56C24v134Ev");}
void  S56C2 ::v135(){vfunc_called(this, "_ZN5S56C24v135Ev");}
S56C2 ::S56C2(){ note_ctor("S56C2", this);} // tgen

static void Test_S56C2()
{
  extern Class_Descriptor cd_S56C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(50,71)];
    init_test(&cd_S56C2, buf);
    S56C2 *dp, &lv = *(dp=new (buf) S56C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(392,280), "sizeof(S56C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S56C2)");
    check_base_class_offset(lv, (S56C7*)(S56C6*)(S56C5*)(S56C4*)(S56C3*), 0, "S56C2");
    check_base_class_offset(lv, (S56C6*)(S56C5*)(S56C4*)(S56C3*), 0, "S56C2");
    check_base_class_offset(lv, (S56C5*)(S56C4*)(S56C3*), 0, "S56C2");
    check_base_class_offset(lv, (S56C4*)(S56C3*), 0, "S56C2");
    check_base_class_offset(lv, (S56C3*), 0, "S56C2");
    test_class_info(&lv, &cd_S56C2);
    dp->~S56C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS56C2(Test_S56C2, "S56C2", ABISELECT(392,280));

#else // __cplusplus

extern void _ZN5S56C2C1Ev();
extern void _ZN5S56C2D1Ev();
Name_Map name_map_S56C2[] = {
  NSPAIR(_ZN5S56C2C1Ev),
  NSPAIR(_ZN5S56C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S56C7;
extern VTBL_ENTRY _ZTI5S56C7[];
extern  VTBL_ENTRY _ZTV5S56C7[];
extern Class_Descriptor cd_S56C6;
extern VTBL_ENTRY _ZTI5S56C6[];
extern  VTBL_ENTRY _ZTV5S56C6[];
extern Class_Descriptor cd_S56C5;
extern VTBL_ENTRY _ZTI5S56C5[];
extern  VTBL_ENTRY _ZTV5S56C5[];
extern Class_Descriptor cd_S56C4;
extern VTBL_ENTRY _ZTI5S56C4[];
extern  VTBL_ENTRY _ZTV5S56C4[];
extern Class_Descriptor cd_S56C3;
extern VTBL_ENTRY _ZTI5S56C3[];
extern  VTBL_ENTRY _ZTV5S56C3[];
static Base_Class bases_S56C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S56C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S56C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S56C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S56C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S56C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S56C2[];
extern void _ZN5S56C2D1Ev();
extern void _ZN5S56C2D0Ev();
extern void _ZN5S56C72v3Ev();
extern void _ZN5S56C72v4Ev();
extern void _ZN5S56C72v5Ev();
extern void _ZN5S56C72v6Ev();
extern void _ZN5S56C72v7Ev();
extern void _ZN5S56C72v8Ev();
extern void _ZN5S56C72v9Ev();
extern void _ZN5S56C73v10Ev();
extern void _ZN5S56C73v11Ev();
extern void _ZN5S56C73v12Ev();
extern void _ZN5S56C73v13Ev();
extern void _ZN5S56C73v14Ev();
extern void _ZN5S56C73v15Ev();
extern void _ZN5S56C73v16Ev();
extern void _ZN5S56C73v17Ev();
extern void _ZN5S56C73v18Ev();
extern void _ZN5S56C73v19Ev();
extern void _ZN5S56C73v20Ev();
extern void _ZN5S56C73v21Ev();
extern void _ZN5S56C73v22Ev();
extern void _ZN5S56C73v23Ev();
extern void _ZN5S56C73v24Ev();
extern void _ZN5S56C73v25Ev();
extern void _ZN5S56C73v26Ev();
extern void _ZN5S56C73v27Ev();
extern void _ZN5S56C73v28Ev();
extern void _ZN5S56C73v29Ev();
extern void _ZN5S56C73v30Ev();
extern void _ZN5S56C73v31Ev();
extern void _ZN5S56C73v32Ev();
extern void _ZN5S56C73v33Ev();
extern void _ZN5S56C73v34Ev();
extern void _ZN5S56C73v35Ev();
extern void _ZN5S56C73v36Ev();
extern void _ZN5S56C73v37Ev();
extern void _ZN5S56C73v38Ev();
extern void _ZN5S56C73v39Ev();
extern void _ZN5S56C73v40Ev();
extern void _ZN5S56C73v41Ev();
extern void _ZN5S56C73v42Ev();
extern void _ZN5S56C73v43Ev();
extern void _ZN5S56C73v44Ev();
extern void _ZN5S56C73v45Ev();
extern void _ZN5S56C73v46Ev();
extern void _ZN5S56C73v47Ev();
extern void _ZN5S56C73v48Ev();
extern void _ZN5S56C73v49Ev();
extern void _ZN5S56C73v50Ev();
extern void _ZN5S56C73v51Ev();
extern void _ZN5S56C73v52Ev();
extern void _ZN5S56C73v53Ev();
extern void _ZN5S56C73v54Ev();
extern void _ZN5S56C73v55Ev();
extern void _ZN5S56C73v56Ev();
extern void _ZN5S56C73v57Ev();
extern void _ZN5S56C73v58Ev();
extern void _ZN5S56C73v59Ev();
extern void _ZN5S56C73v60Ev();
extern void _ZN5S56C73v61Ev();
extern void _ZN5S56C73v62Ev();
extern void _ZN5S56C73v63Ev();
extern void _ZN5S56C73v64Ev();
extern void _ZN5S56C73v65Ev();
extern void _ZN5S56C73v66Ev();
extern void _ZN5S56C63v67Ev();
extern void _ZN5S56C63v68Ev();
extern void _ZN5S56C63v69Ev();
extern void _ZN5S56C63v70Ev();
extern void _ZN5S56C63v71Ev();
extern void _ZN5S56C63v72Ev();
extern void _ZN5S56C63v73Ev();
extern void _ZN5S56C63v74Ev();
extern void _ZN5S56C63v75Ev();
extern void _ZN5S56C63v76Ev();
extern void _ZN5S56C63v77Ev();
extern void _ZN5S56C63v78Ev();
extern void _ZN5S56C63v79Ev();
extern void _ZN5S56C63v80Ev();
extern void _ZN5S56C63v81Ev();
extern void _ZN5S56C63v82Ev();
extern void _ZN5S56C63v83Ev();
extern void _ZN5S56C63v84Ev();
extern void _ZN5S56C63v85Ev();
extern void _ZN5S56C63v86Ev();
extern void _ZN5S56C63v87Ev();
extern void _ZN5S56C63v88Ev();
extern void _ZN5S56C53v89Ev();
extern void _ZN5S56C53v90Ev();
extern void _ZN5S56C53v91Ev();
extern void _ZN5S56C53v92Ev();
extern void _ZN5S56C53v93Ev();
extern void _ZN5S56C53v94Ev();
extern void _ZN5S56C53v95Ev();
extern void _ZN5S56C53v96Ev();
extern void _ZN5S56C53v97Ev();
extern void _ZN5S56C53v98Ev();
extern void _ZN5S56C53v99Ev();
extern void _ZN5S56C54v100Ev();
extern void _ZN5S56C54v101Ev();
extern void _ZN5S56C54v102Ev();
extern void _ZN5S56C54v103Ev();
extern void _ZN5S56C54v104Ev();
extern void _ZN5S56C54v105Ev();
extern void _ZN5S56C54v106Ev();
extern void _ZN5S56C54v107Ev();
extern void _ZN5S56C54v108Ev();
extern void _ZN5S56C44v109Ev();
extern void _ZN5S56C44v110Ev();
extern void _ZN5S56C44v111Ev();
extern void _ZN5S56C44v112Ev();
extern void _ZN5S56C44v113Ev();
extern void _ZN5S56C44v114Ev();
extern void _ZN5S56C44v115Ev();
extern void _ZN5S56C44v116Ev();
extern void _ZN5S56C44v117Ev();
extern void _ZN5S56C44v118Ev();
extern void _ZN5S56C44v119Ev();
extern void _ZN5S56C44v120Ev();
extern void _ZN5S56C44v121Ev();
extern void _ZN5S56C44v122Ev();
extern void _ZN5S56C34v123Ev();
extern void _ZN5S56C34v124Ev();
extern void _ZN5S56C34v125Ev();
extern void _ZN5S56C34v126Ev();
extern void _ZN5S56C34v127Ev();
extern void _ZN5S56C34v128Ev();
extern void _ZN5S56C34v129Ev();
extern void _ZN5S56C34v130Ev();
extern void _ZN5S56C34v131Ev();
extern void _ZN5S56C34v132Ev();
extern void _ZN5S56C34v133Ev();
extern void _ZN5S56C24v134Ev();
extern void _ZN5S56C24v135Ev();
static  VTBL_ENTRY vtc_S56C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S56C2[0]),
  (VTBL_ENTRY)&_ZN5S56C2D1Ev,
  (VTBL_ENTRY)&_ZN5S56C2D0Ev,
  (VTBL_ENTRY)&_ZN5S56C72v3Ev,
  (VTBL_ENTRY)&_ZN5S56C72v4Ev,
  (VTBL_ENTRY)&_ZN5S56C72v5Ev,
  (VTBL_ENTRY)&_ZN5S56C72v6Ev,
  (VTBL_ENTRY)&_ZN5S56C72v7Ev,
  (VTBL_ENTRY)&_ZN5S56C72v8Ev,
  (VTBL_ENTRY)&_ZN5S56C72v9Ev,
  (VTBL_ENTRY)&_ZN5S56C73v10Ev,
  (VTBL_ENTRY)&_ZN5S56C73v11Ev,
  (VTBL_ENTRY)&_ZN5S56C73v12Ev,
  (VTBL_ENTRY)&_ZN5S56C73v13Ev,
  (VTBL_ENTRY)&_ZN5S56C73v14Ev,
  (VTBL_ENTRY)&_ZN5S56C73v15Ev,
  (VTBL_ENTRY)&_ZN5S56C73v16Ev,
  (VTBL_ENTRY)&_ZN5S56C73v17Ev,
  (VTBL_ENTRY)&_ZN5S56C73v18Ev,
  (VTBL_ENTRY)&_ZN5S56C73v19Ev,
  (VTBL_ENTRY)&_ZN5S56C73v20Ev,
  (VTBL_ENTRY)&_ZN5S56C73v21Ev,
  (VTBL_ENTRY)&_ZN5S56C73v22Ev,
  (VTBL_ENTRY)&_ZN5S56C73v23Ev,
  (VTBL_ENTRY)&_ZN5S56C73v24Ev,
  (VTBL_ENTRY)&_ZN5S56C73v25Ev,
  (VTBL_ENTRY)&_ZN5S56C73v26Ev,
  (VTBL_ENTRY)&_ZN5S56C73v27Ev,
  (VTBL_ENTRY)&_ZN5S56C73v28Ev,
  (VTBL_ENTRY)&_ZN5S56C73v29Ev,
  (VTBL_ENTRY)&_ZN5S56C73v30Ev,
  (VTBL_ENTRY)&_ZN5S56C73v31Ev,
  (VTBL_ENTRY)&_ZN5S56C73v32Ev,
  (VTBL_ENTRY)&_ZN5S56C73v33Ev,
  (VTBL_ENTRY)&_ZN5S56C73v34Ev,
  (VTBL_ENTRY)&_ZN5S56C73v35Ev,
  (VTBL_ENTRY)&_ZN5S56C73v36Ev,
  (VTBL_ENTRY)&_ZN5S56C73v37Ev,
  (VTBL_ENTRY)&_ZN5S56C73v38Ev,
  (VTBL_ENTRY)&_ZN5S56C73v39Ev,
  (VTBL_ENTRY)&_ZN5S56C73v40Ev,
  (VTBL_ENTRY)&_ZN5S56C73v41Ev,
  (VTBL_ENTRY)&_ZN5S56C73v42Ev,
  (VTBL_ENTRY)&_ZN5S56C73v43Ev,
  (VTBL_ENTRY)&_ZN5S56C73v44Ev,
  (VTBL_ENTRY)&_ZN5S56C73v45Ev,
  (VTBL_ENTRY)&_ZN5S56C73v46Ev,
  (VTBL_ENTRY)&_ZN5S56C73v47Ev,
  (VTBL_ENTRY)&_ZN5S56C73v48Ev,
  (VTBL_ENTRY)&_ZN5S56C73v49Ev,
  (VTBL_ENTRY)&_ZN5S56C73v50Ev,
  (VTBL_ENTRY)&_ZN5S56C73v51Ev,
  (VTBL_ENTRY)&_ZN5S56C73v52Ev,
  (VTBL_ENTRY)&_ZN5S56C73v53Ev,
  (VTBL_ENTRY)&_ZN5S56C73v54Ev,
  (VTBL_ENTRY)&_ZN5S56C73v55Ev,
  (VTBL_ENTRY)&_ZN5S56C73v56Ev,
  (VTBL_ENTRY)&_ZN5S56C73v57Ev,
  (VTBL_ENTRY)&_ZN5S56C73v58Ev,
  (VTBL_ENTRY)&_ZN5S56C73v59Ev,
  (VTBL_ENTRY)&_ZN5S56C73v60Ev,
  (VTBL_ENTRY)&_ZN5S56C73v61Ev,
  (VTBL_ENTRY)&_ZN5S56C73v62Ev,
  (VTBL_ENTRY)&_ZN5S56C73v63Ev,
  (VTBL_ENTRY)&_ZN5S56C73v64Ev,
  (VTBL_ENTRY)&_ZN5S56C73v65Ev,
  (VTBL_ENTRY)&_ZN5S56C73v66Ev,
  (VTBL_ENTRY)&_ZN5S56C63v67Ev,
  (VTBL_ENTRY)&_ZN5S56C63v68Ev,
  (VTBL_ENTRY)&_ZN5S56C63v69Ev,
  (VTBL_ENTRY)&_ZN5S56C63v70Ev,
  (VTBL_ENTRY)&_ZN5S56C63v71Ev,
  (VTBL_ENTRY)&_ZN5S56C63v72Ev,
  (VTBL_ENTRY)&_ZN5S56C63v73Ev,
  (VTBL_ENTRY)&_ZN5S56C63v74Ev,
  (VTBL_ENTRY)&_ZN5S56C63v75Ev,
  (VTBL_ENTRY)&_ZN5S56C63v76Ev,
  (VTBL_ENTRY)&_ZN5S56C63v77Ev,
  (VTBL_ENTRY)&_ZN5S56C63v78Ev,
  (VTBL_ENTRY)&_ZN5S56C63v79Ev,
  (VTBL_ENTRY)&_ZN5S56C63v80Ev,
  (VTBL_ENTRY)&_ZN5S56C63v81Ev,
  (VTBL_ENTRY)&_ZN5S56C63v82Ev,
  (VTBL_ENTRY)&_ZN5S56C63v83Ev,
  (VTBL_ENTRY)&_ZN5S56C63v84Ev,
  (VTBL_ENTRY)&_ZN5S56C63v85Ev,
  (VTBL_ENTRY)&_ZN5S56C63v86Ev,
  (VTBL_ENTRY)&_ZN5S56C63v87Ev,
  (VTBL_ENTRY)&_ZN5S56C63v88Ev,
  (VTBL_ENTRY)&_ZN5S56C53v89Ev,
  (VTBL_ENTRY)&_ZN5S56C53v90Ev,
  (VTBL_ENTRY)&_ZN5S56C53v91Ev,
  (VTBL_ENTRY)&_ZN5S56C53v92Ev,
  (VTBL_ENTRY)&_ZN5S56C53v93Ev,
  (VTBL_ENTRY)&_ZN5S56C53v94Ev,
  (VTBL_ENTRY)&_ZN5S56C53v95Ev,
  (VTBL_ENTRY)&_ZN5S56C53v96Ev,
  (VTBL_ENTRY)&_ZN5S56C53v97Ev,
  (VTBL_ENTRY)&_ZN5S56C53v98Ev,
  (VTBL_ENTRY)&_ZN5S56C53v99Ev,
  (VTBL_ENTRY)&_ZN5S56C54v100Ev,
  (VTBL_ENTRY)&_ZN5S56C54v101Ev,
  (VTBL_ENTRY)&_ZN5S56C54v102Ev,
  (VTBL_ENTRY)&_ZN5S56C54v103Ev,
  (VTBL_ENTRY)&_ZN5S56C54v104Ev,
  (VTBL_ENTRY)&_ZN5S56C54v105Ev,
  (VTBL_ENTRY)&_ZN5S56C54v106Ev,
  (VTBL_ENTRY)&_ZN5S56C54v107Ev,
  (VTBL_ENTRY)&_ZN5S56C54v108Ev,
  (VTBL_ENTRY)&_ZN5S56C44v109Ev,
  (VTBL_ENTRY)&_ZN5S56C44v110Ev,
  (VTBL_ENTRY)&_ZN5S56C44v111Ev,
  (VTBL_ENTRY)&_ZN5S56C44v112Ev,
  (VTBL_ENTRY)&_ZN5S56C44v113Ev,
  (VTBL_ENTRY)&_ZN5S56C44v114Ev,
  (VTBL_ENTRY)&_ZN5S56C44v115Ev,
  (VTBL_ENTRY)&_ZN5S56C44v116Ev,
  (VTBL_ENTRY)&_ZN5S56C44v117Ev,
  (VTBL_ENTRY)&_ZN5S56C44v118Ev,
  (VTBL_ENTRY)&_ZN5S56C44v119Ev,
  (VTBL_ENTRY)&_ZN5S56C44v120Ev,
  (VTBL_ENTRY)&_ZN5S56C44v121Ev,
  (VTBL_ENTRY)&_ZN5S56C44v122Ev,
  (VTBL_ENTRY)&_ZN5S56C34v123Ev,
  (VTBL_ENTRY)&_ZN5S56C34v124Ev,
  (VTBL_ENTRY)&_ZN5S56C34v125Ev,
  (VTBL_ENTRY)&_ZN5S56C34v126Ev,
  (VTBL_ENTRY)&_ZN5S56C34v127Ev,
  (VTBL_ENTRY)&_ZN5S56C34v128Ev,
  (VTBL_ENTRY)&_ZN5S56C34v129Ev,
  (VTBL_ENTRY)&_ZN5S56C34v130Ev,
  (VTBL_ENTRY)&_ZN5S56C34v131Ev,
  (VTBL_ENTRY)&_ZN5S56C34v132Ev,
  (VTBL_ENTRY)&_ZN5S56C34v133Ev,
  (VTBL_ENTRY)&_ZN5S56C24v134Ev,
  (VTBL_ENTRY)&_ZN5S56C24v135Ev,
};
extern VTBL_ENTRY _ZTI5S56C2[];
extern  VTBL_ENTRY _ZTV5S56C2[];
Class_Descriptor cd_S56C2 = {  "S56C2", // class name
  bases_S56C2, 5,
  &(vtc_S56C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(392,280), // object size
  NSPAIRA(_ZTI5S56C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S56C2),137, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S56C1  : S56C2 {
  ::S287C8_nt s56c1f0;
  unsigned int s56c1f1:1;
  virtual  ~S56C1(); // _ZN5S56C1D1Ev
  virtual void  v1(); // _ZN5S56C12v1Ev
  virtual void  v2(); // _ZN5S56C12v2Ev
  S56C1(); // tgen
};
//SIG(1 S56C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC8{ m Fi[2]} Fp[2]} vd v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi[2] Fp Fi[2] FC9{ BC10{ BC11{ BC12{ m Fp Fi[2]}}}} FC9 FC13{ m} FC9 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 Fi:1 Fi:1 Fi:1 FC14{ BC15{ BC12}} FC16{ BC17{ BC12}} FC18{ BC19{ BC12}} FC20{ BC21{ BC12}} Fi[3]} vd v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 Fp[2] Fi[4] Fi:1 Fi:1 Fi:1 Fc Fi Fi:1 FC22{ BC23{ BC12}}} vd v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 Fp[2] FC9 Fi:1 Fi:1 FC24{ m Fp FC8}} vd v134 v135} vd v1 v2 FC9 Fi:1}


 S56C1 ::~S56C1(){ note_dtor("S56C1", this);}
void  S56C1 ::v1(){vfunc_called(this, "_ZN5S56C12v1Ev");}
void  S56C1 ::v2(){vfunc_called(this, "_ZN5S56C12v2Ev");}
S56C1 ::S56C1(){ note_ctor("S56C1", this);} // tgen

static void Test_S56C1()
{
  extern Class_Descriptor cd_S56C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(53,75)];
    init_test(&cd_S56C1, buf);
    S56C1 *dp, &lv = *(dp=new (buf) S56C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(416,296), "sizeof(S56C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S56C1)");
    check_base_class_offset(lv, (S56C7*)(S56C6*)(S56C5*)(S56C4*)(S56C3*)(S56C2*), 0, "S56C1");
    check_base_class_offset(lv, (S56C6*)(S56C5*)(S56C4*)(S56C3*)(S56C2*), 0, "S56C1");
    check_base_class_offset(lv, (S56C5*)(S56C4*)(S56C3*)(S56C2*), 0, "S56C1");
    check_base_class_offset(lv, (S56C4*)(S56C3*)(S56C2*), 0, "S56C1");
    check_base_class_offset(lv, (S56C3*)(S56C2*), 0, "S56C1");
    check_base_class_offset(lv, (S56C2*), 0, "S56C1");
    check_field_offset(lv, s56c1f0, ABISELECT(392,280), "S56C1.s56c1f0");
    set_bf_and_test(lv, s56c1f1, ABISELECT(408,292), 0, 1, 1, "S56C1");
    test_class_info(&lv, &cd_S56C1);
    dp->~S56C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS56C1(Test_S56C1, "S56C1", ABISELECT(416,296));

#else // __cplusplus

extern void _ZN5S56C1C1Ev();
extern void _ZN5S56C1D1Ev();
Name_Map name_map_S56C1[] = {
  NSPAIR(_ZN5S56C1C1Ev),
  NSPAIR(_ZN5S56C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S56C7;
extern VTBL_ENTRY _ZTI5S56C7[];
extern  VTBL_ENTRY _ZTV5S56C7[];
extern Class_Descriptor cd_S56C6;
extern VTBL_ENTRY _ZTI5S56C6[];
extern  VTBL_ENTRY _ZTV5S56C6[];
extern Class_Descriptor cd_S56C5;
extern VTBL_ENTRY _ZTI5S56C5[];
extern  VTBL_ENTRY _ZTV5S56C5[];
extern Class_Descriptor cd_S56C4;
extern VTBL_ENTRY _ZTI5S56C4[];
extern  VTBL_ENTRY _ZTV5S56C4[];
extern Class_Descriptor cd_S56C3;
extern VTBL_ENTRY _ZTI5S56C3[];
extern  VTBL_ENTRY _ZTV5S56C3[];
extern Class_Descriptor cd_S56C2;
extern VTBL_ENTRY _ZTI5S56C2[];
extern  VTBL_ENTRY _ZTV5S56C2[];
static Base_Class bases_S56C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S56C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S56C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S56C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S56C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S56C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S56C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S56C1[];
extern void _ZN5S56C1D1Ev();
extern void _ZN5S56C1D0Ev();
extern void _ZN5S56C72v3Ev();
extern void _ZN5S56C72v4Ev();
extern void _ZN5S56C72v5Ev();
extern void _ZN5S56C72v6Ev();
extern void _ZN5S56C72v7Ev();
extern void _ZN5S56C72v8Ev();
extern void _ZN5S56C72v9Ev();
extern void _ZN5S56C73v10Ev();
extern void _ZN5S56C73v11Ev();
extern void _ZN5S56C73v12Ev();
extern void _ZN5S56C73v13Ev();
extern void _ZN5S56C73v14Ev();
extern void _ZN5S56C73v15Ev();
extern void _ZN5S56C73v16Ev();
extern void _ZN5S56C73v17Ev();
extern void _ZN5S56C73v18Ev();
extern void _ZN5S56C73v19Ev();
extern void _ZN5S56C73v20Ev();
extern void _ZN5S56C73v21Ev();
extern void _ZN5S56C73v22Ev();
extern void _ZN5S56C73v23Ev();
extern void _ZN5S56C73v24Ev();
extern void _ZN5S56C73v25Ev();
extern void _ZN5S56C73v26Ev();
extern void _ZN5S56C73v27Ev();
extern void _ZN5S56C73v28Ev();
extern void _ZN5S56C73v29Ev();
extern void _ZN5S56C73v30Ev();
extern void _ZN5S56C73v31Ev();
extern void _ZN5S56C73v32Ev();
extern void _ZN5S56C73v33Ev();
extern void _ZN5S56C73v34Ev();
extern void _ZN5S56C73v35Ev();
extern void _ZN5S56C73v36Ev();
extern void _ZN5S56C73v37Ev();
extern void _ZN5S56C73v38Ev();
extern void _ZN5S56C73v39Ev();
extern void _ZN5S56C73v40Ev();
extern void _ZN5S56C73v41Ev();
extern void _ZN5S56C73v42Ev();
extern void _ZN5S56C73v43Ev();
extern void _ZN5S56C73v44Ev();
extern void _ZN5S56C73v45Ev();
extern void _ZN5S56C73v46Ev();
extern void _ZN5S56C73v47Ev();
extern void _ZN5S56C73v48Ev();
extern void _ZN5S56C73v49Ev();
extern void _ZN5S56C73v50Ev();
extern void _ZN5S56C73v51Ev();
extern void _ZN5S56C73v52Ev();
extern void _ZN5S56C73v53Ev();
extern void _ZN5S56C73v54Ev();
extern void _ZN5S56C73v55Ev();
extern void _ZN5S56C73v56Ev();
extern void _ZN5S56C73v57Ev();
extern void _ZN5S56C73v58Ev();
extern void _ZN5S56C73v59Ev();
extern void _ZN5S56C73v60Ev();
extern void _ZN5S56C73v61Ev();
extern void _ZN5S56C73v62Ev();
extern void _ZN5S56C73v63Ev();
extern void _ZN5S56C73v64Ev();
extern void _ZN5S56C73v65Ev();
extern void _ZN5S56C73v66Ev();
extern void _ZN5S56C63v67Ev();
extern void _ZN5S56C63v68Ev();
extern void _ZN5S56C63v69Ev();
extern void _ZN5S56C63v70Ev();
extern void _ZN5S56C63v71Ev();
extern void _ZN5S56C63v72Ev();
extern void _ZN5S56C63v73Ev();
extern void _ZN5S56C63v74Ev();
extern void _ZN5S56C63v75Ev();
extern void _ZN5S56C63v76Ev();
extern void _ZN5S56C63v77Ev();
extern void _ZN5S56C63v78Ev();
extern void _ZN5S56C63v79Ev();
extern void _ZN5S56C63v80Ev();
extern void _ZN5S56C63v81Ev();
extern void _ZN5S56C63v82Ev();
extern void _ZN5S56C63v83Ev();
extern void _ZN5S56C63v84Ev();
extern void _ZN5S56C63v85Ev();
extern void _ZN5S56C63v86Ev();
extern void _ZN5S56C63v87Ev();
extern void _ZN5S56C63v88Ev();
extern void _ZN5S56C53v89Ev();
extern void _ZN5S56C53v90Ev();
extern void _ZN5S56C53v91Ev();
extern void _ZN5S56C53v92Ev();
extern void _ZN5S56C53v93Ev();
extern void _ZN5S56C53v94Ev();
extern void _ZN5S56C53v95Ev();
extern void _ZN5S56C53v96Ev();
extern void _ZN5S56C53v97Ev();
extern void _ZN5S56C53v98Ev();
extern void _ZN5S56C53v99Ev();
extern void _ZN5S56C54v100Ev();
extern void _ZN5S56C54v101Ev();
extern void _ZN5S56C54v102Ev();
extern void _ZN5S56C54v103Ev();
extern void _ZN5S56C54v104Ev();
extern void _ZN5S56C54v105Ev();
extern void _ZN5S56C54v106Ev();
extern void _ZN5S56C54v107Ev();
extern void _ZN5S56C54v108Ev();
extern void _ZN5S56C44v109Ev();
extern void _ZN5S56C44v110Ev();
extern void _ZN5S56C44v111Ev();
extern void _ZN5S56C44v112Ev();
extern void _ZN5S56C44v113Ev();
extern void _ZN5S56C44v114Ev();
extern void _ZN5S56C44v115Ev();
extern void _ZN5S56C44v116Ev();
extern void _ZN5S56C44v117Ev();
extern void _ZN5S56C44v118Ev();
extern void _ZN5S56C44v119Ev();
extern void _ZN5S56C44v120Ev();
extern void _ZN5S56C44v121Ev();
extern void _ZN5S56C44v122Ev();
extern void _ZN5S56C34v123Ev();
extern void _ZN5S56C34v124Ev();
extern void _ZN5S56C34v125Ev();
extern void _ZN5S56C34v126Ev();
extern void _ZN5S56C34v127Ev();
extern void _ZN5S56C34v128Ev();
extern void _ZN5S56C34v129Ev();
extern void _ZN5S56C34v130Ev();
extern void _ZN5S56C34v131Ev();
extern void _ZN5S56C34v132Ev();
extern void _ZN5S56C34v133Ev();
extern void _ZN5S56C24v134Ev();
extern void _ZN5S56C24v135Ev();
extern void _ZN5S56C12v1Ev();
extern void _ZN5S56C12v2Ev();
static  VTBL_ENTRY vtc_S56C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S56C1[0]),
  (VTBL_ENTRY)&_ZN5S56C1D1Ev,
  (VTBL_ENTRY)&_ZN5S56C1D0Ev,
  (VTBL_ENTRY)&_ZN5S56C72v3Ev,
  (VTBL_ENTRY)&_ZN5S56C72v4Ev,
  (VTBL_ENTRY)&_ZN5S56C72v5Ev,
  (VTBL_ENTRY)&_ZN5S56C72v6Ev,
  (VTBL_ENTRY)&_ZN5S56C72v7Ev,
  (VTBL_ENTRY)&_ZN5S56C72v8Ev,
  (VTBL_ENTRY)&_ZN5S56C72v9Ev,
  (VTBL_ENTRY)&_ZN5S56C73v10Ev,
  (VTBL_ENTRY)&_ZN5S56C73v11Ev,
  (VTBL_ENTRY)&_ZN5S56C73v12Ev,
  (VTBL_ENTRY)&_ZN5S56C73v13Ev,
  (VTBL_ENTRY)&_ZN5S56C73v14Ev,
  (VTBL_ENTRY)&_ZN5S56C73v15Ev,
  (VTBL_ENTRY)&_ZN5S56C73v16Ev,
  (VTBL_ENTRY)&_ZN5S56C73v17Ev,
  (VTBL_ENTRY)&_ZN5S56C73v18Ev,
  (VTBL_ENTRY)&_ZN5S56C73v19Ev,
  (VTBL_ENTRY)&_ZN5S56C73v20Ev,
  (VTBL_ENTRY)&_ZN5S56C73v21Ev,
  (VTBL_ENTRY)&_ZN5S56C73v22Ev,
  (VTBL_ENTRY)&_ZN5S56C73v23Ev,
  (VTBL_ENTRY)&_ZN5S56C73v24Ev,
  (VTBL_ENTRY)&_ZN5S56C73v25Ev,
  (VTBL_ENTRY)&_ZN5S56C73v26Ev,
  (VTBL_ENTRY)&_ZN5S56C73v27Ev,
  (VTBL_ENTRY)&_ZN5S56C73v28Ev,
  (VTBL_ENTRY)&_ZN5S56C73v29Ev,
  (VTBL_ENTRY)&_ZN5S56C73v30Ev,
  (VTBL_ENTRY)&_ZN5S56C73v31Ev,
  (VTBL_ENTRY)&_ZN5S56C73v32Ev,
  (VTBL_ENTRY)&_ZN5S56C73v33Ev,
  (VTBL_ENTRY)&_ZN5S56C73v34Ev,
  (VTBL_ENTRY)&_ZN5S56C73v35Ev,
  (VTBL_ENTRY)&_ZN5S56C73v36Ev,
  (VTBL_ENTRY)&_ZN5S56C73v37Ev,
  (VTBL_ENTRY)&_ZN5S56C73v38Ev,
  (VTBL_ENTRY)&_ZN5S56C73v39Ev,
  (VTBL_ENTRY)&_ZN5S56C73v40Ev,
  (VTBL_ENTRY)&_ZN5S56C73v41Ev,
  (VTBL_ENTRY)&_ZN5S56C73v42Ev,
  (VTBL_ENTRY)&_ZN5S56C73v43Ev,
  (VTBL_ENTRY)&_ZN5S56C73v44Ev,
  (VTBL_ENTRY)&_ZN5S56C73v45Ev,
  (VTBL_ENTRY)&_ZN5S56C73v46Ev,
  (VTBL_ENTRY)&_ZN5S56C73v47Ev,
  (VTBL_ENTRY)&_ZN5S56C73v48Ev,
  (VTBL_ENTRY)&_ZN5S56C73v49Ev,
  (VTBL_ENTRY)&_ZN5S56C73v50Ev,
  (VTBL_ENTRY)&_ZN5S56C73v51Ev,
  (VTBL_ENTRY)&_ZN5S56C73v52Ev,
  (VTBL_ENTRY)&_ZN5S56C73v53Ev,
  (VTBL_ENTRY)&_ZN5S56C73v54Ev,
  (VTBL_ENTRY)&_ZN5S56C73v55Ev,
  (VTBL_ENTRY)&_ZN5S56C73v56Ev,
  (VTBL_ENTRY)&_ZN5S56C73v57Ev,
  (VTBL_ENTRY)&_ZN5S56C73v58Ev,
  (VTBL_ENTRY)&_ZN5S56C73v59Ev,
  (VTBL_ENTRY)&_ZN5S56C73v60Ev,
  (VTBL_ENTRY)&_ZN5S56C73v61Ev,
  (VTBL_ENTRY)&_ZN5S56C73v62Ev,
  (VTBL_ENTRY)&_ZN5S56C73v63Ev,
  (VTBL_ENTRY)&_ZN5S56C73v64Ev,
  (VTBL_ENTRY)&_ZN5S56C73v65Ev,
  (VTBL_ENTRY)&_ZN5S56C73v66Ev,
  (VTBL_ENTRY)&_ZN5S56C63v67Ev,
  (VTBL_ENTRY)&_ZN5S56C63v68Ev,
  (VTBL_ENTRY)&_ZN5S56C63v69Ev,
  (VTBL_ENTRY)&_ZN5S56C63v70Ev,
  (VTBL_ENTRY)&_ZN5S56C63v71Ev,
  (VTBL_ENTRY)&_ZN5S56C63v72Ev,
  (VTBL_ENTRY)&_ZN5S56C63v73Ev,
  (VTBL_ENTRY)&_ZN5S56C63v74Ev,
  (VTBL_ENTRY)&_ZN5S56C63v75Ev,
  (VTBL_ENTRY)&_ZN5S56C63v76Ev,
  (VTBL_ENTRY)&_ZN5S56C63v77Ev,
  (VTBL_ENTRY)&_ZN5S56C63v78Ev,
  (VTBL_ENTRY)&_ZN5S56C63v79Ev,
  (VTBL_ENTRY)&_ZN5S56C63v80Ev,
  (VTBL_ENTRY)&_ZN5S56C63v81Ev,
  (VTBL_ENTRY)&_ZN5S56C63v82Ev,
  (VTBL_ENTRY)&_ZN5S56C63v83Ev,
  (VTBL_ENTRY)&_ZN5S56C63v84Ev,
  (VTBL_ENTRY)&_ZN5S56C63v85Ev,
  (VTBL_ENTRY)&_ZN5S56C63v86Ev,
  (VTBL_ENTRY)&_ZN5S56C63v87Ev,
  (VTBL_ENTRY)&_ZN5S56C63v88Ev,
  (VTBL_ENTRY)&_ZN5S56C53v89Ev,
  (VTBL_ENTRY)&_ZN5S56C53v90Ev,
  (VTBL_ENTRY)&_ZN5S56C53v91Ev,
  (VTBL_ENTRY)&_ZN5S56C53v92Ev,
  (VTBL_ENTRY)&_ZN5S56C53v93Ev,
  (VTBL_ENTRY)&_ZN5S56C53v94Ev,
  (VTBL_ENTRY)&_ZN5S56C53v95Ev,
  (VTBL_ENTRY)&_ZN5S56C53v96Ev,
  (VTBL_ENTRY)&_ZN5S56C53v97Ev,
  (VTBL_ENTRY)&_ZN5S56C53v98Ev,
  (VTBL_ENTRY)&_ZN5S56C53v99Ev,
  (VTBL_ENTRY)&_ZN5S56C54v100Ev,
  (VTBL_ENTRY)&_ZN5S56C54v101Ev,
  (VTBL_ENTRY)&_ZN5S56C54v102Ev,
  (VTBL_ENTRY)&_ZN5S56C54v103Ev,
  (VTBL_ENTRY)&_ZN5S56C54v104Ev,
  (VTBL_ENTRY)&_ZN5S56C54v105Ev,
  (VTBL_ENTRY)&_ZN5S56C54v106Ev,
  (VTBL_ENTRY)&_ZN5S56C54v107Ev,
  (VTBL_ENTRY)&_ZN5S56C54v108Ev,
  (VTBL_ENTRY)&_ZN5S56C44v109Ev,
  (VTBL_ENTRY)&_ZN5S56C44v110Ev,
  (VTBL_ENTRY)&_ZN5S56C44v111Ev,
  (VTBL_ENTRY)&_ZN5S56C44v112Ev,
  (VTBL_ENTRY)&_ZN5S56C44v113Ev,
  (VTBL_ENTRY)&_ZN5S56C44v114Ev,
  (VTBL_ENTRY)&_ZN5S56C44v115Ev,
  (VTBL_ENTRY)&_ZN5S56C44v116Ev,
  (VTBL_ENTRY)&_ZN5S56C44v117Ev,
  (VTBL_ENTRY)&_ZN5S56C44v118Ev,
  (VTBL_ENTRY)&_ZN5S56C44v119Ev,
  (VTBL_ENTRY)&_ZN5S56C44v120Ev,
  (VTBL_ENTRY)&_ZN5S56C44v121Ev,
  (VTBL_ENTRY)&_ZN5S56C44v122Ev,
  (VTBL_ENTRY)&_ZN5S56C34v123Ev,
  (VTBL_ENTRY)&_ZN5S56C34v124Ev,
  (VTBL_ENTRY)&_ZN5S56C34v125Ev,
  (VTBL_ENTRY)&_ZN5S56C34v126Ev,
  (VTBL_ENTRY)&_ZN5S56C34v127Ev,
  (VTBL_ENTRY)&_ZN5S56C34v128Ev,
  (VTBL_ENTRY)&_ZN5S56C34v129Ev,
  (VTBL_ENTRY)&_ZN5S56C34v130Ev,
  (VTBL_ENTRY)&_ZN5S56C34v131Ev,
  (VTBL_ENTRY)&_ZN5S56C34v132Ev,
  (VTBL_ENTRY)&_ZN5S56C34v133Ev,
  (VTBL_ENTRY)&_ZN5S56C24v134Ev,
  (VTBL_ENTRY)&_ZN5S56C24v135Ev,
  (VTBL_ENTRY)&_ZN5S56C12v1Ev,
  (VTBL_ENTRY)&_ZN5S56C12v2Ev,
};
extern VTBL_ENTRY _ZTI5S56C1[];
extern  VTBL_ENTRY _ZTV5S56C1[];
Class_Descriptor cd_S56C1 = {  "S56C1", // class name
  bases_S56C1, 6,
  &(vtc_S56C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(416,296), // object size
  NSPAIRA(_ZTI5S56C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S56C1),139, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S57C7  {
  int s57c7f0;
  __tsi64 s57c7f1;
  void *s57c7f2[4];
  int s57c7f3[2];
  void *s57c7f4;
  ::S3350C4_nt s57c7f5;
  void *s57c7f6[2];
  virtual  ~S57C7(); // _ZN5S57C7D1Ev
  virtual void  v3(); // _ZN5S57C72v3Ev
  virtual void  v4(); // _ZN5S57C72v4Ev
  virtual void  v5(); // _ZN5S57C72v5Ev
  virtual void  v6(); // _ZN5S57C72v6Ev
  virtual void  v7(); // _ZN5S57C72v7Ev
  virtual void  v8(); // _ZN5S57C72v8Ev
  virtual void  v9(); // _ZN5S57C72v9Ev
  virtual void  v10(); // _ZN5S57C73v10Ev
  virtual void  v11(); // _ZN5S57C73v11Ev
  virtual void  v12(); // _ZN5S57C73v12Ev
  virtual void  v13(); // _ZN5S57C73v13Ev
  virtual void  v14(); // _ZN5S57C73v14Ev
  virtual void  v15(); // _ZN5S57C73v15Ev
  virtual void  v16(); // _ZN5S57C73v16Ev
  virtual void  v17(); // _ZN5S57C73v17Ev
  virtual void  v18(); // _ZN5S57C73v18Ev
  virtual void  v19(); // _ZN5S57C73v19Ev
  virtual void  v20(); // _ZN5S57C73v20Ev
  virtual void  v21(); // _ZN5S57C73v21Ev
  virtual void  v22(); // _ZN5S57C73v22Ev
  virtual void  v23(); // _ZN5S57C73v23Ev
  virtual void  v24(); // _ZN5S57C73v24Ev
  virtual void  v25(); // _ZN5S57C73v25Ev
  virtual void  v26(); // _ZN5S57C73v26Ev
  virtual void  v27(); // _ZN5S57C73v27Ev
  virtual void  v28(); // _ZN5S57C73v28Ev
  virtual void  v29(); // _ZN5S57C73v29Ev
  virtual void  v30(); // _ZN5S57C73v30Ev
  virtual void  v31(); // _ZN5S57C73v31Ev
  virtual void  v32(); // _ZN5S57C73v32Ev
  virtual void  v33(); // _ZN5S57C73v33Ev
  virtual void  v34(); // _ZN5S57C73v34Ev
  virtual void  v35(); // _ZN5S57C73v35Ev
  virtual void  v36(); // _ZN5S57C73v36Ev
  virtual void  v37(); // _ZN5S57C73v37Ev
  virtual void  v38(); // _ZN5S57C73v38Ev
  virtual void  v39(); // _ZN5S57C73v39Ev
  virtual void  v40(); // _ZN5S57C73v40Ev
  virtual void  v41(); // _ZN5S57C73v41Ev
  virtual void  v42(); // _ZN5S57C73v42Ev
  virtual void  v43(); // _ZN5S57C73v43Ev
  virtual void  v44(); // _ZN5S57C73v44Ev
  virtual void  v45(); // _ZN5S57C73v45Ev
  virtual void  v46(); // _ZN5S57C73v46Ev
  virtual void  v47(); // _ZN5S57C73v47Ev
  virtual void  v48(); // _ZN5S57C73v48Ev
  virtual void  v49(); // _ZN5S57C73v49Ev
  virtual void  v50(); // _ZN5S57C73v50Ev
  virtual void  v51(); // _ZN5S57C73v51Ev
  virtual void  v52(); // _ZN5S57C73v52Ev
  virtual void  v53(); // _ZN5S57C73v53Ev
  virtual void  v54(); // _ZN5S57C73v54Ev
  virtual void  v55(); // _ZN5S57C73v55Ev
  virtual void  v56(); // _ZN5S57C73v56Ev
  virtual void  v57(); // _ZN5S57C73v57Ev
  virtual void  v58(); // _ZN5S57C73v58Ev
  virtual void  v59(); // _ZN5S57C73v59Ev
  virtual void  v60(); // _ZN5S57C73v60Ev
  virtual void  v61(); // _ZN5S57C73v61Ev
  virtual void  v62(); // _ZN5S57C73v62Ev
  virtual void  v63(); // _ZN5S57C73v63Ev
  virtual void  v64(); // _ZN5S57C73v64Ev
  virtual void  v65(); // _ZN5S57C73v65Ev
  virtual void  v66(); // _ZN5S57C73v66Ev
  S57C7(); // tgen
};
//SIG(-1 S57C7) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S57C7 ::~S57C7(){ note_dtor("S57C7", this);}
void  S57C7 ::v3(){vfunc_called(this, "_ZN5S57C72v3Ev");}
void  S57C7 ::v4(){vfunc_called(this, "_ZN5S57C72v4Ev");}
void  S57C7 ::v5(){vfunc_called(this, "_ZN5S57C72v5Ev");}
void  S57C7 ::v6(){vfunc_called(this, "_ZN5S57C72v6Ev");}
void  S57C7 ::v7(){vfunc_called(this, "_ZN5S57C72v7Ev");}
void  S57C7 ::v8(){vfunc_called(this, "_ZN5S57C72v8Ev");}
void  S57C7 ::v9(){vfunc_called(this, "_ZN5S57C72v9Ev");}
void  S57C7 ::v10(){vfunc_called(this, "_ZN5S57C73v10Ev");}
void  S57C7 ::v11(){vfunc_called(this, "_ZN5S57C73v11Ev");}
void  S57C7 ::v12(){vfunc_called(this, "_ZN5S57C73v12Ev");}
void  S57C7 ::v13(){vfunc_called(this, "_ZN5S57C73v13Ev");}
void  S57C7 ::v14(){vfunc_called(this, "_ZN5S57C73v14Ev");}
void  S57C7 ::v15(){vfunc_called(this, "_ZN5S57C73v15Ev");}
void  S57C7 ::v16(){vfunc_called(this, "_ZN5S57C73v16Ev");}
void  S57C7 ::v17(){vfunc_called(this, "_ZN5S57C73v17Ev");}
void  S57C7 ::v18(){vfunc_called(this, "_ZN5S57C73v18Ev");}
void  S57C7 ::v19(){vfunc_called(this, "_ZN5S57C73v19Ev");}
void  S57C7 ::v20(){vfunc_called(this, "_ZN5S57C73v20Ev");}
void  S57C7 ::v21(){vfunc_called(this, "_ZN5S57C73v21Ev");}
void  S57C7 ::v22(){vfunc_called(this, "_ZN5S57C73v22Ev");}
void  S57C7 ::v23(){vfunc_called(this, "_ZN5S57C73v23Ev");}
void  S57C7 ::v24(){vfunc_called(this, "_ZN5S57C73v24Ev");}
void  S57C7 ::v25(){vfunc_called(this, "_ZN5S57C73v25Ev");}
void  S57C7 ::v26(){vfunc_called(this, "_ZN5S57C73v26Ev");}
void  S57C7 ::v27(){vfunc_called(this, "_ZN5S57C73v27Ev");}
void  S57C7 ::v28(){vfunc_called(this, "_ZN5S57C73v28Ev");}
void  S57C7 ::v29(){vfunc_called(this, "_ZN5S57C73v29Ev");}
void  S57C7 ::v30(){vfunc_called(this, "_ZN5S57C73v30Ev");}
void  S57C7 ::v31(){vfunc_called(this, "_ZN5S57C73v31Ev");}
void  S57C7 ::v32(){vfunc_called(this, "_ZN5S57C73v32Ev");}
void  S57C7 ::v33(){vfunc_called(this, "_ZN5S57C73v33Ev");}
void  S57C7 ::v34(){vfunc_called(this, "_ZN5S57C73v34Ev");}
void  S57C7 ::v35(){vfunc_called(this, "_ZN5S57C73v35Ev");}
void  S57C7 ::v36(){vfunc_called(this, "_ZN5S57C73v36Ev");}
void  S57C7 ::v37(){vfunc_called(this, "_ZN5S57C73v37Ev");}
void  S57C7 ::v38(){vfunc_called(this, "_ZN5S57C73v38Ev");}
void  S57C7 ::v39(){vfunc_called(this, "_ZN5S57C73v39Ev");}
void  S57C7 ::v40(){vfunc_called(this, "_ZN5S57C73v40Ev");}
void  S57C7 ::v41(){vfunc_called(this, "_ZN5S57C73v41Ev");}
void  S57C7 ::v42(){vfunc_called(this, "_ZN5S57C73v42Ev");}
void  S57C7 ::v43(){vfunc_called(this, "_ZN5S57C73v43Ev");}
void  S57C7 ::v44(){vfunc_called(this, "_ZN5S57C73v44Ev");}
void  S57C7 ::v45(){vfunc_called(this, "_ZN5S57C73v45Ev");}
void  S57C7 ::v46(){vfunc_called(this, "_ZN5S57C73v46Ev");}
void  S57C7 ::v47(){vfunc_called(this, "_ZN5S57C73v47Ev");}
void  S57C7 ::v48(){vfunc_called(this, "_ZN5S57C73v48Ev");}
void  S57C7 ::v49(){vfunc_called(this, "_ZN5S57C73v49Ev");}
void  S57C7 ::v50(){vfunc_called(this, "_ZN5S57C73v50Ev");}
void  S57C7 ::v51(){vfunc_called(this, "_ZN5S57C73v51Ev");}
void  S57C7 ::v52(){vfunc_called(this, "_ZN5S57C73v52Ev");}
void  S57C7 ::v53(){vfunc_called(this, "_ZN5S57C73v53Ev");}
void  S57C7 ::v54(){vfunc_called(this, "_ZN5S57C73v54Ev");}
void  S57C7 ::v55(){vfunc_called(this, "_ZN5S57C73v55Ev");}
void  S57C7 ::v56(){vfunc_called(this, "_ZN5S57C73v56Ev");}
void  S57C7 ::v57(){vfunc_called(this, "_ZN5S57C73v57Ev");}
void  S57C7 ::v58(){vfunc_called(this, "_ZN5S57C73v58Ev");}
void  S57C7 ::v59(){vfunc_called(this, "_ZN5S57C73v59Ev");}
void  S57C7 ::v60(){vfunc_called(this, "_ZN5S57C73v60Ev");}
void  S57C7 ::v61(){vfunc_called(this, "_ZN5S57C73v61Ev");}
void  S57C7 ::v62(){vfunc_called(this, "_ZN5S57C73v62Ev");}
void  S57C7 ::v63(){vfunc_called(this, "_ZN5S57C73v63Ev");}
void  S57C7 ::v64(){vfunc_called(this, "_ZN5S57C73v64Ev");}
void  S57C7 ::v65(){vfunc_called(this, "_ZN5S57C73v65Ev");}
void  S57C7 ::v66(){vfunc_called(this, "_ZN5S57C73v66Ev");}
S57C7 ::S57C7(){ note_ctor("S57C7", this);} // tgen

static void Test_S57C7()
{
  extern Class_Descriptor cd_S57C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S57C7, buf);
    S57C7 *dp, &lv = *(dp=new (buf) S57C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S57C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S57C7)");
    check_field_offset(lv, s57c7f0, ABISELECT(8,4), "S57C7.s57c7f0");
    check_field_offset(lv, s57c7f1, ABISELECT(16,8), "S57C7.s57c7f1");
    check_field_offset(lv, s57c7f2, ABISELECT(24,16), "S57C7.s57c7f2");
    check_field_offset(lv, s57c7f3, ABISELECT(56,32), "S57C7.s57c7f3");
    check_field_offset(lv, s57c7f4, ABISELECT(64,40), "S57C7.s57c7f4");
    check_field_offset(lv, s57c7f5, ABISELECT(72,44), "S57C7.s57c7f5");
    check_field_offset(lv, s57c7f6, ABISELECT(80,52), "S57C7.s57c7f6");
    test_class_info(&lv, &cd_S57C7);
    dp->~S57C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS57C7(Test_S57C7, "S57C7", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN5S57C7C1Ev();
extern void _ZN5S57C7D1Ev();
Name_Map name_map_S57C7[] = {
  NSPAIR(_ZN5S57C7C1Ev),
  NSPAIR(_ZN5S57C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI5S57C7[];
extern void _ZN5S57C7D1Ev();
extern void _ZN5S57C7D0Ev();
extern void _ZN5S57C72v3Ev();
extern void _ZN5S57C72v4Ev();
extern void _ZN5S57C72v5Ev();
extern void _ZN5S57C72v6Ev();
extern void _ZN5S57C72v7Ev();
extern void _ZN5S57C72v8Ev();
extern void _ZN5S57C72v9Ev();
extern void _ZN5S57C73v10Ev();
extern void _ZN5S57C73v11Ev();
extern void _ZN5S57C73v12Ev();
extern void _ZN5S57C73v13Ev();
extern void _ZN5S57C73v14Ev();
extern void _ZN5S57C73v15Ev();
extern void _ZN5S57C73v16Ev();
extern void _ZN5S57C73v17Ev();
extern void _ZN5S57C73v18Ev();
extern void _ZN5S57C73v19Ev();
extern void _ZN5S57C73v20Ev();
extern void _ZN5S57C73v21Ev();
extern void _ZN5S57C73v22Ev();
extern void _ZN5S57C73v23Ev();
extern void _ZN5S57C73v24Ev();
extern void _ZN5S57C73v25Ev();
extern void _ZN5S57C73v26Ev();
extern void _ZN5S57C73v27Ev();
extern void _ZN5S57C73v28Ev();
extern void _ZN5S57C73v29Ev();
extern void _ZN5S57C73v30Ev();
extern void _ZN5S57C73v31Ev();
extern void _ZN5S57C73v32Ev();
extern void _ZN5S57C73v33Ev();
extern void _ZN5S57C73v34Ev();
extern void _ZN5S57C73v35Ev();
extern void _ZN5S57C73v36Ev();
extern void _ZN5S57C73v37Ev();
extern void _ZN5S57C73v38Ev();
extern void _ZN5S57C73v39Ev();
extern void _ZN5S57C73v40Ev();
extern void _ZN5S57C73v41Ev();
extern void _ZN5S57C73v42Ev();
extern void _ZN5S57C73v43Ev();
extern void _ZN5S57C73v44Ev();
extern void _ZN5S57C73v45Ev();
extern void _ZN5S57C73v46Ev();
extern void _ZN5S57C73v47Ev();
extern void _ZN5S57C73v48Ev();
extern void _ZN5S57C73v49Ev();
extern void _ZN5S57C73v50Ev();
extern void _ZN5S57C73v51Ev();
extern void _ZN5S57C73v52Ev();
extern void _ZN5S57C73v53Ev();
extern void _ZN5S57C73v54Ev();
extern void _ZN5S57C73v55Ev();
extern void _ZN5S57C73v56Ev();
extern void _ZN5S57C73v57Ev();
extern void _ZN5S57C73v58Ev();
extern void _ZN5S57C73v59Ev();
extern void _ZN5S57C73v60Ev();
extern void _ZN5S57C73v61Ev();
extern void _ZN5S57C73v62Ev();
extern void _ZN5S57C73v63Ev();
extern void _ZN5S57C73v64Ev();
extern void _ZN5S57C73v65Ev();
extern void _ZN5S57C73v66Ev();
static  VTBL_ENTRY vtc_S57C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S57C7[0]),
  (VTBL_ENTRY)&_ZN5S57C7D1Ev,
  (VTBL_ENTRY)&_ZN5S57C7D0Ev,
  (VTBL_ENTRY)&_ZN5S57C72v3Ev,
  (VTBL_ENTRY)&_ZN5S57C72v4Ev,
  (VTBL_ENTRY)&_ZN5S57C72v5Ev,
  (VTBL_ENTRY)&_ZN5S57C72v6Ev,
  (VTBL_ENTRY)&_ZN5S57C72v7Ev,
  (VTBL_ENTRY)&_ZN5S57C72v8Ev,
  (VTBL_ENTRY)&_ZN5S57C72v9Ev,
  (VTBL_ENTRY)&_ZN5S57C73v10Ev,
  (VTBL_ENTRY)&_ZN5S57C73v11Ev,
  (VTBL_ENTRY)&_ZN5S57C73v12Ev,
  (VTBL_ENTRY)&_ZN5S57C73v13Ev,
  (VTBL_ENTRY)&_ZN5S57C73v14Ev,
  (VTBL_ENTRY)&_ZN5S57C73v15Ev,
  (VTBL_ENTRY)&_ZN5S57C73v16Ev,
  (VTBL_ENTRY)&_ZN5S57C73v17Ev,
  (VTBL_ENTRY)&_ZN5S57C73v18Ev,
  (VTBL_ENTRY)&_ZN5S57C73v19Ev,
  (VTBL_ENTRY)&_ZN5S57C73v20Ev,
  (VTBL_ENTRY)&_ZN5S57C73v21Ev,
  (VTBL_ENTRY)&_ZN5S57C73v22Ev,
  (VTBL_ENTRY)&_ZN5S57C73v23Ev,
  (VTBL_ENTRY)&_ZN5S57C73v24Ev,
  (VTBL_ENTRY)&_ZN5S57C73v25Ev,
  (VTBL_ENTRY)&_ZN5S57C73v26Ev,
  (VTBL_ENTRY)&_ZN5S57C73v27Ev,
  (VTBL_ENTRY)&_ZN5S57C73v28Ev,
  (VTBL_ENTRY)&_ZN5S57C73v29Ev,
  (VTBL_ENTRY)&_ZN5S57C73v30Ev,
  (VTBL_ENTRY)&_ZN5S57C73v31Ev,
  (VTBL_ENTRY)&_ZN5S57C73v32Ev,
  (VTBL_ENTRY)&_ZN5S57C73v33Ev,
  (VTBL_ENTRY)&_ZN5S57C73v34Ev,
  (VTBL_ENTRY)&_ZN5S57C73v35Ev,
  (VTBL_ENTRY)&_ZN5S57C73v36Ev,
  (VTBL_ENTRY)&_ZN5S57C73v37Ev,
  (VTBL_ENTRY)&_ZN5S57C73v38Ev,
  (VTBL_ENTRY)&_ZN5S57C73v39Ev,
  (VTBL_ENTRY)&_ZN5S57C73v40Ev,
  (VTBL_ENTRY)&_ZN5S57C73v41Ev,
  (VTBL_ENTRY)&_ZN5S57C73v42Ev,
  (VTBL_ENTRY)&_ZN5S57C73v43Ev,
  (VTBL_ENTRY)&_ZN5S57C73v44Ev,
  (VTBL_ENTRY)&_ZN5S57C73v45Ev,
  (VTBL_ENTRY)&_ZN5S57C73v46Ev,
  (VTBL_ENTRY)&_ZN5S57C73v47Ev,
  (VTBL_ENTRY)&_ZN5S57C73v48Ev,
  (VTBL_ENTRY)&_ZN5S57C73v49Ev,
  (VTBL_ENTRY)&_ZN5S57C73v50Ev,
  (VTBL_ENTRY)&_ZN5S57C73v51Ev,
  (VTBL_ENTRY)&_ZN5S57C73v52Ev,
  (VTBL_ENTRY)&_ZN5S57C73v53Ev,
  (VTBL_ENTRY)&_ZN5S57C73v54Ev,
  (VTBL_ENTRY)&_ZN5S57C73v55Ev,
  (VTBL_ENTRY)&_ZN5S57C73v56Ev,
  (VTBL_ENTRY)&_ZN5S57C73v57Ev,
  (VTBL_ENTRY)&_ZN5S57C73v58Ev,
  (VTBL_ENTRY)&_ZN5S57C73v59Ev,
  (VTBL_ENTRY)&_ZN5S57C73v60Ev,
  (VTBL_ENTRY)&_ZN5S57C73v61Ev,
  (VTBL_ENTRY)&_ZN5S57C73v62Ev,
  (VTBL_ENTRY)&_ZN5S57C73v63Ev,
  (VTBL_ENTRY)&_ZN5S57C73v64Ev,
  (VTBL_ENTRY)&_ZN5S57C73v65Ev,
  (VTBL_ENTRY)&_ZN5S57C73v66Ev,
};
extern VTBL_ENTRY _ZTI5S57C7[];
extern  VTBL_ENTRY _ZTV5S57C7[];
Class_Descriptor cd_S57C7 = {  "S57C7", // class name
  0,0,//no base classes
  &(vtc_S57C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI5S57C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV5S57C7),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S57C6  : S57C7 {
  int s57c6f0[2];
  void *s57c6f1;
  int s57c6f2[2];
  ::S287C8_nt s57c6f3;
  ::S287C8_nt s57c6f4;
  ::S2121C38 s57c6f5;
  ::S287C8_nt s57c6f6;
  unsigned int s57c6f7:1;
  unsigned int s57c6f8:1;
  unsigned int s57c6f9:1;
  unsigned int s57c6f10:1;
  unsigned int s57c6f11:1;
  int s57c6f12[2];
  virtual  ~S57C6(); // _ZN5S57C6D1Ev
  virtual void  v67(); // _ZN5S57C63v67Ev
  virtual void  v68(); // _ZN5S57C63v68Ev
  virtual void  v69(); // _ZN5S57C63v69Ev
  virtual void  v70(); // _ZN5S57C63v70Ev
  virtual void  v71(); // _ZN5S57C63v71Ev
  virtual void  v72(); // _ZN5S57C63v72Ev
  virtual void  v73(); // _ZN5S57C63v73Ev
  virtual void  v74(); // _ZN5S57C63v74Ev
  virtual void  v75(); // _ZN5S57C63v75Ev
  virtual void  v76(); // _ZN5S57C63v76Ev
  virtual void  v77(); // _ZN5S57C63v77Ev
  virtual void  v78(); // _ZN5S57C63v78Ev
  virtual void  v79(); // _ZN5S57C63v79Ev
  virtual void  v80(); // _ZN5S57C63v80Ev
  virtual void  v81(); // _ZN5S57C63v81Ev
  virtual void  v82(); // _ZN5S57C63v82Ev
  virtual void  v83(); // _ZN5S57C63v83Ev
  virtual void  v84(); // _ZN5S57C63v84Ev
  virtual void  v85(); // _ZN5S57C63v85Ev
  virtual void  v86(); // _ZN5S57C63v86Ev
  virtual void  v87(); // _ZN5S57C63v87Ev
  virtual void  v88(); // _ZN5S57C63v88Ev
  S57C6(); // tgen
};
//SIG(-1 S57C6) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S57C6 ::~S57C6(){ note_dtor("S57C6", this);}
void  S57C6 ::v67(){vfunc_called(this, "_ZN5S57C63v67Ev");}
void  S57C6 ::v68(){vfunc_called(this, "_ZN5S57C63v68Ev");}
void  S57C6 ::v69(){vfunc_called(this, "_ZN5S57C63v69Ev");}
void  S57C6 ::v70(){vfunc_called(this, "_ZN5S57C63v70Ev");}
void  S57C6 ::v71(){vfunc_called(this, "_ZN5S57C63v71Ev");}
void  S57C6 ::v72(){vfunc_called(this, "_ZN5S57C63v72Ev");}
void  S57C6 ::v73(){vfunc_called(this, "_ZN5S57C63v73Ev");}
void  S57C6 ::v74(){vfunc_called(this, "_ZN5S57C63v74Ev");}
void  S57C6 ::v75(){vfunc_called(this, "_ZN5S57C63v75Ev");}
void  S57C6 ::v76(){vfunc_called(this, "_ZN5S57C63v76Ev");}
void  S57C6 ::v77(){vfunc_called(this, "_ZN5S57C63v77Ev");}
void  S57C6 ::v78(){vfunc_called(this, "_ZN5S57C63v78Ev");}
void  S57C6 ::v79(){vfunc_called(this, "_ZN5S57C63v79Ev");}
void  S57C6 ::v80(){vfunc_called(this, "_ZN5S57C63v80Ev");}
void  S57C6 ::v81(){vfunc_called(this, "_ZN5S57C63v81Ev");}
void  S57C6 ::v82(){vfunc_called(this, "_ZN5S57C63v82Ev");}
void  S57C6 ::v83(){vfunc_called(this, "_ZN5S57C63v83Ev");}
void  S57C6 ::v84(){vfunc_called(this, "_ZN5S57C63v84Ev");}
void  S57C6 ::v85(){vfunc_called(this, "_ZN5S57C63v85Ev");}
void  S57C6 ::v86(){vfunc_called(this, "_ZN5S57C63v86Ev");}
void  S57C6 ::v87(){vfunc_called(this, "_ZN5S57C63v87Ev");}
void  S57C6 ::v88(){vfunc_called(this, "_ZN5S57C63v88Ev");}
S57C6 ::S57C6(){ note_ctor("S57C6", this);} // tgen

static void Test_S57C6()
{
  extern Class_Descriptor cd_S57C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S57C6, buf);
    S57C6 *dp, &lv = *(dp=new (buf) S57C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S57C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S57C6)");
    check_base_class_offset(lv, (S57C7*), 0, "S57C6");
    check_field_offset(lv, s57c6f0, ABISELECT(96,60), "S57C6.s57c6f0");
    check_field_offset(lv, s57c6f1, ABISELECT(104,68), "S57C6.s57c6f1");
    check_field_offset(lv, s57c6f2, ABISELECT(112,72), "S57C6.s57c6f2");
    check_field_offset(lv, s57c6f3, ABISELECT(120,80), "S57C6.s57c6f3");
    check_field_offset(lv, s57c6f4, ABISELECT(136,92), "S57C6.s57c6f4");
    check_field_offset(lv, s57c6f5, ABISELECT(152,104), "S57C6.s57c6f5");
    check_field_offset(lv, s57c6f6, ABISELECT(160,108), "S57C6.s57c6f6");
    set_bf_and_test(lv, s57c6f7, ABISELECT(176,120), 0, 1, 1, "S57C6");
    set_bf_and_test(lv, s57c6f8, ABISELECT(176,120), 1, 1, 1, "S57C6");
    set_bf_and_test(lv, s57c6f9, ABISELECT(176,120), 2, 1, 1, "S57C6");
    set_bf_and_test(lv, s57c6f10, ABISELECT(176,120), 3, 1, 1, "S57C6");
    set_bf_and_test(lv, s57c6f11, ABISELECT(176,120), 4, 1, 1, "S57C6");
    check_field_offset(lv, s57c6f12, ABISELECT(180,124), "S57C6.s57c6f12");
    test_class_info(&lv, &cd_S57C6);
    dp->~S57C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS57C6(Test_S57C6, "S57C6", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN5S57C6C1Ev();
extern void _ZN5S57C6D1Ev();
Name_Map name_map_S57C6[] = {
  NSPAIR(_ZN5S57C6C1Ev),
  NSPAIR(_ZN5S57C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S57C7;
extern VTBL_ENTRY _ZTI5S57C7[];
extern  VTBL_ENTRY _ZTV5S57C7[];
static Base_Class bases_S57C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S57C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S57C6[];
extern void _ZN5S57C6D1Ev();
extern void _ZN5S57C6D0Ev();
extern void _ZN5S57C72v3Ev();
extern void _ZN5S57C72v4Ev();
extern void _ZN5S57C72v5Ev();
extern void _ZN5S57C72v6Ev();
extern void _ZN5S57C72v7Ev();
extern void _ZN5S57C72v8Ev();
extern void _ZN5S57C72v9Ev();
extern void _ZN5S57C73v10Ev();
extern void _ZN5S57C73v11Ev();
extern void _ZN5S57C73v12Ev();
extern void _ZN5S57C73v13Ev();
extern void _ZN5S57C73v14Ev();
extern void _ZN5S57C73v15Ev();
extern void _ZN5S57C73v16Ev();
extern void _ZN5S57C73v17Ev();
extern void _ZN5S57C73v18Ev();
extern void _ZN5S57C73v19Ev();
extern void _ZN5S57C73v20Ev();
extern void _ZN5S57C73v21Ev();
extern void _ZN5S57C73v22Ev();
extern void _ZN5S57C73v23Ev();
extern void _ZN5S57C73v24Ev();
extern void _ZN5S57C73v25Ev();
extern void _ZN5S57C73v26Ev();
extern void _ZN5S57C73v27Ev();
extern void _ZN5S57C73v28Ev();
extern void _ZN5S57C73v29Ev();
extern void _ZN5S57C73v30Ev();
extern void _ZN5S57C73v31Ev();
extern void _ZN5S57C73v32Ev();
extern void _ZN5S57C73v33Ev();
extern void _ZN5S57C73v34Ev();
extern void _ZN5S57C73v35Ev();
extern void _ZN5S57C73v36Ev();
extern void _ZN5S57C73v37Ev();
extern void _ZN5S57C73v38Ev();
extern void _ZN5S57C73v39Ev();
extern void _ZN5S57C73v40Ev();
extern void _ZN5S57C73v41Ev();
extern void _ZN5S57C73v42Ev();
extern void _ZN5S57C73v43Ev();
extern void _ZN5S57C73v44Ev();
extern void _ZN5S57C73v45Ev();
extern void _ZN5S57C73v46Ev();
extern void _ZN5S57C73v47Ev();
extern void _ZN5S57C73v48Ev();
extern void _ZN5S57C73v49Ev();
extern void _ZN5S57C73v50Ev();
extern void _ZN5S57C73v51Ev();
extern void _ZN5S57C73v52Ev();
extern void _ZN5S57C73v53Ev();
extern void _ZN5S57C73v54Ev();
extern void _ZN5S57C73v55Ev();
extern void _ZN5S57C73v56Ev();
extern void _ZN5S57C73v57Ev();
extern void _ZN5S57C73v58Ev();
extern void _ZN5S57C73v59Ev();
extern void _ZN5S57C73v60Ev();
extern void _ZN5S57C73v61Ev();
extern void _ZN5S57C73v62Ev();
extern void _ZN5S57C73v63Ev();
extern void _ZN5S57C73v64Ev();
extern void _ZN5S57C73v65Ev();
extern void _ZN5S57C73v66Ev();
extern void _ZN5S57C63v67Ev();
extern void _ZN5S57C63v68Ev();
extern void _ZN5S57C63v69Ev();
extern void _ZN5S57C63v70Ev();
extern void _ZN5S57C63v71Ev();
extern void _ZN5S57C63v72Ev();
extern void _ZN5S57C63v73Ev();
extern void _ZN5S57C63v74Ev();
extern void _ZN5S57C63v75Ev();
extern void _ZN5S57C63v76Ev();
extern void _ZN5S57C63v77Ev();
extern void _ZN5S57C63v78Ev();
extern void _ZN5S57C63v79Ev();
extern void _ZN5S57C63v80Ev();
extern void _ZN5S57C63v81Ev();
extern void _ZN5S57C63v82Ev();
extern void _ZN5S57C63v83Ev();
extern void _ZN5S57C63v84Ev();
extern void _ZN5S57C63v85Ev();
extern void _ZN5S57C63v86Ev();
extern void _ZN5S57C63v87Ev();
extern void _ZN5S57C63v88Ev();
static  VTBL_ENTRY vtc_S57C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S57C6[0]),
  (VTBL_ENTRY)&_ZN5S57C6D1Ev,
  (VTBL_ENTRY)&_ZN5S57C6D0Ev,
  (VTBL_ENTRY)&_ZN5S57C72v3Ev,
  (VTBL_ENTRY)&_ZN5S57C72v4Ev,
  (VTBL_ENTRY)&_ZN5S57C72v5Ev,
  (VTBL_ENTRY)&_ZN5S57C72v6Ev,
  (VTBL_ENTRY)&_ZN5S57C72v7Ev,
  (VTBL_ENTRY)&_ZN5S57C72v8Ev,
  (VTBL_ENTRY)&_ZN5S57C72v9Ev,
  (VTBL_ENTRY)&_ZN5S57C73v10Ev,
  (VTBL_ENTRY)&_ZN5S57C73v11Ev,
  (VTBL_ENTRY)&_ZN5S57C73v12Ev,
  (VTBL_ENTRY)&_ZN5S57C73v13Ev,
  (VTBL_ENTRY)&_ZN5S57C73v14Ev,
  (VTBL_ENTRY)&_ZN5S57C73v15Ev,
  (VTBL_ENTRY)&_ZN5S57C73v16Ev,
  (VTBL_ENTRY)&_ZN5S57C73v17Ev,
  (VTBL_ENTRY)&_ZN5S57C73v18Ev,
  (VTBL_ENTRY)&_ZN5S57C73v19Ev,
  (VTBL_ENTRY)&_ZN5S57C73v20Ev,
  (VTBL_ENTRY)&_ZN5S57C73v21Ev,
  (VTBL_ENTRY)&_ZN5S57C73v22Ev,
  (VTBL_ENTRY)&_ZN5S57C73v23Ev,
  (VTBL_ENTRY)&_ZN5S57C73v24Ev,
  (VTBL_ENTRY)&_ZN5S57C73v25Ev,
  (VTBL_ENTRY)&_ZN5S57C73v26Ev,
  (VTBL_ENTRY)&_ZN5S57C73v27Ev,
  (VTBL_ENTRY)&_ZN5S57C73v28Ev,
  (VTBL_ENTRY)&_ZN5S57C73v29Ev,
  (VTBL_ENTRY)&_ZN5S57C73v30Ev,
  (VTBL_ENTRY)&_ZN5S57C73v31Ev,
  (VTBL_ENTRY)&_ZN5S57C73v32Ev,
  (VTBL_ENTRY)&_ZN5S57C73v33Ev,
  (VTBL_ENTRY)&_ZN5S57C73v34Ev,
  (VTBL_ENTRY)&_ZN5S57C73v35Ev,
  (VTBL_ENTRY)&_ZN5S57C73v36Ev,
  (VTBL_ENTRY)&_ZN5S57C73v37Ev,
  (VTBL_ENTRY)&_ZN5S57C73v38Ev,
  (VTBL_ENTRY)&_ZN5S57C73v39Ev,
  (VTBL_ENTRY)&_ZN5S57C73v40Ev,
  (VTBL_ENTRY)&_ZN5S57C73v41Ev,
  (VTBL_ENTRY)&_ZN5S57C73v42Ev,
  (VTBL_ENTRY)&_ZN5S57C73v43Ev,
  (VTBL_ENTRY)&_ZN5S57C73v44Ev,
  (VTBL_ENTRY)&_ZN5S57C73v45Ev,
  (VTBL_ENTRY)&_ZN5S57C73v46Ev,
  (VTBL_ENTRY)&_ZN5S57C73v47Ev,
  (VTBL_ENTRY)&_ZN5S57C73v48Ev,
  (VTBL_ENTRY)&_ZN5S57C73v49Ev,
  (VTBL_ENTRY)&_ZN5S57C73v50Ev,
  (VTBL_ENTRY)&_ZN5S57C73v51Ev,
  (VTBL_ENTRY)&_ZN5S57C73v52Ev,
  (VTBL_ENTRY)&_ZN5S57C73v53Ev,
  (VTBL_ENTRY)&_ZN5S57C73v54Ev,
  (VTBL_ENTRY)&_ZN5S57C73v55Ev,
  (VTBL_ENTRY)&_ZN5S57C73v56Ev,
  (VTBL_ENTRY)&_ZN5S57C73v57Ev,
  (VTBL_ENTRY)&_ZN5S57C73v58Ev,
  (VTBL_ENTRY)&_ZN5S57C73v59Ev,
  (VTBL_ENTRY)&_ZN5S57C73v60Ev,
  (VTBL_ENTRY)&_ZN5S57C73v61Ev,
  (VTBL_ENTRY)&_ZN5S57C73v62Ev,
  (VTBL_ENTRY)&_ZN5S57C73v63Ev,
  (VTBL_ENTRY)&_ZN5S57C73v64Ev,
  (VTBL_ENTRY)&_ZN5S57C73v65Ev,
  (VTBL_ENTRY)&_ZN5S57C73v66Ev,
  (VTBL_ENTRY)&_ZN5S57C63v67Ev,
  (VTBL_ENTRY)&_ZN5S57C63v68Ev,
  (VTBL_ENTRY)&_ZN5S57C63v69Ev,
  (VTBL_ENTRY)&_ZN5S57C63v70Ev,
  (VTBL_ENTRY)&_ZN5S57C63v71Ev,
  (VTBL_ENTRY)&_ZN5S57C63v72Ev,
  (VTBL_ENTRY)&_ZN5S57C63v73Ev,
  (VTBL_ENTRY)&_ZN5S57C63v74Ev,
  (VTBL_ENTRY)&_ZN5S57C63v75Ev,
  (VTBL_ENTRY)&_ZN5S57C63v76Ev,
  (VTBL_ENTRY)&_ZN5S57C63v77Ev,
  (VTBL_ENTRY)&_ZN5S57C63v78Ev,
  (VTBL_ENTRY)&_ZN5S57C63v79Ev,
  (VTBL_ENTRY)&_ZN5S57C63v80Ev,
  (VTBL_ENTRY)&_ZN5S57C63v81Ev,
  (VTBL_ENTRY)&_ZN5S57C63v82Ev,
  (VTBL_ENTRY)&_ZN5S57C63v83Ev,
  (VTBL_ENTRY)&_ZN5S57C63v84Ev,
  (VTBL_ENTRY)&_ZN5S57C63v85Ev,
  (VTBL_ENTRY)&_ZN5S57C63v86Ev,
  (VTBL_ENTRY)&_ZN5S57C63v87Ev,
  (VTBL_ENTRY)&_ZN5S57C63v88Ev,
};
extern VTBL_ENTRY _ZTI5S57C6[];
extern  VTBL_ENTRY _ZTV5S57C6[];
Class_Descriptor cd_S57C6 = {  "S57C6", // class name
  bases_S57C6, 1,
  &(vtc_S57C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI5S57C6),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S57C6),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S57C5  : S57C6 {
  unsigned int s57c5f0:1;
  unsigned int s57c5f1:1;
  unsigned int s57c5f2:1;
  ::S3350C17 s57c5f3;
  ::S3350C11 s57c5f4;
  ::S3350C5_nt s57c5f5;
  ::S287C27 s57c5f6;
  int s57c5f7[3];
  virtual  ~S57C5(); // _ZN5S57C5D1Ev
  virtual void  v89(); // _ZN5S57C53v89Ev
  virtual void  v90(); // _ZN5S57C53v90Ev
  virtual void  v91(); // _ZN5S57C53v91Ev
  virtual void  v92(); // _ZN5S57C53v92Ev
  virtual void  v93(); // _ZN5S57C53v93Ev
  virtual void  v94(); // _ZN5S57C53v94Ev
  virtual void  v95(); // _ZN5S57C53v95Ev
  virtual void  v96(); // _ZN5S57C53v96Ev
  virtual void  v97(); // _ZN5S57C53v97Ev
  virtual void  v98(); // _ZN5S57C53v98Ev
  virtual void  v99(); // _ZN5S57C53v99Ev
  virtual void  v100(); // _ZN5S57C54v100Ev
  virtual void  v101(); // _ZN5S57C54v101Ev
  virtual void  v102(); // _ZN5S57C54v102Ev
  virtual void  v103(); // _ZN5S57C54v103Ev
  virtual void  v104(); // _ZN5S57C54v104Ev
  virtual void  v105(); // _ZN5S57C54v105Ev
  virtual void  v106(); // _ZN5S57C54v106Ev
  virtual void  v107(); // _ZN5S57C54v107Ev
  virtual void  v108(); // _ZN5S57C54v108Ev
  S57C5(); // tgen
};
//SIG(-1 S57C5) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} FC16{ BC17{ BC8}} Fi[3]}


 S57C5 ::~S57C5(){ note_dtor("S57C5", this);}
void  S57C5 ::v89(){vfunc_called(this, "_ZN5S57C53v89Ev");}
void  S57C5 ::v90(){vfunc_called(this, "_ZN5S57C53v90Ev");}
void  S57C5 ::v91(){vfunc_called(this, "_ZN5S57C53v91Ev");}
void  S57C5 ::v92(){vfunc_called(this, "_ZN5S57C53v92Ev");}
void  S57C5 ::v93(){vfunc_called(this, "_ZN5S57C53v93Ev");}
void  S57C5 ::v94(){vfunc_called(this, "_ZN5S57C53v94Ev");}
void  S57C5 ::v95(){vfunc_called(this, "_ZN5S57C53v95Ev");}
void  S57C5 ::v96(){vfunc_called(this, "_ZN5S57C53v96Ev");}
void  S57C5 ::v97(){vfunc_called(this, "_ZN5S57C53v97Ev");}
void  S57C5 ::v98(){vfunc_called(this, "_ZN5S57C53v98Ev");}
void  S57C5 ::v99(){vfunc_called(this, "_ZN5S57C53v99Ev");}
void  S57C5 ::v100(){vfunc_called(this, "_ZN5S57C54v100Ev");}
void  S57C5 ::v101(){vfunc_called(this, "_ZN5S57C54v101Ev");}
void  S57C5 ::v102(){vfunc_called(this, "_ZN5S57C54v102Ev");}
void  S57C5 ::v103(){vfunc_called(this, "_ZN5S57C54v103Ev");}
void  S57C5 ::v104(){vfunc_called(this, "_ZN5S57C54v104Ev");}
void  S57C5 ::v105(){vfunc_called(this, "_ZN5S57C54v105Ev");}
void  S57C5 ::v106(){vfunc_called(this, "_ZN5S57C54v106Ev");}
void  S57C5 ::v107(){vfunc_called(this, "_ZN5S57C54v107Ev");}
void  S57C5 ::v108(){vfunc_called(this, "_ZN5S57C54v108Ev");}
S57C5 ::S57C5(){ note_ctor("S57C5", this);} // tgen

static void Test_S57C5()
{
  extern Class_Descriptor cd_S57C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(35,50)];
    init_test(&cd_S57C5, buf);
    S57C5 *dp, &lv = *(dp=new (buf) S57C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,196), "sizeof(S57C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S57C5)");
    check_base_class_offset(lv, (S57C7*)(S57C6*), 0, "S57C5");
    check_base_class_offset(lv, (S57C6*), 0, "S57C5");
    set_bf_and_test(lv, s57c5f0, ABISELECT(188,132), 0, 1, 1, "S57C5");
    set_bf_and_test(lv, s57c5f1, ABISELECT(188,132), 1, 1, 1, "S57C5");
    set_bf_and_test(lv, s57c5f2, ABISELECT(188,132), 2, 1, 1, "S57C5");
    check_field_offset(lv, s57c5f3, ABISELECT(192,136), "S57C5.s57c5f3");
    check_field_offset(lv, s57c5f4, ABISELECT(208,148), "S57C5.s57c5f4");
    check_field_offset(lv, s57c5f5, ABISELECT(224,160), "S57C5.s57c5f5");
    check_field_offset(lv, s57c5f6, ABISELECT(240,172), "S57C5.s57c5f6");
    check_field_offset(lv, s57c5f7, ABISELECT(256,184), "S57C5.s57c5f7");
    test_class_info(&lv, &cd_S57C5);
    dp->~S57C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS57C5(Test_S57C5, "S57C5", ABISELECT(272,196));

#else // __cplusplus

extern void _ZN5S57C5C1Ev();
extern void _ZN5S57C5D1Ev();
Name_Map name_map_S57C5[] = {
  NSPAIR(_ZN5S57C5C1Ev),
  NSPAIR(_ZN5S57C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S57C7;
extern VTBL_ENTRY _ZTI5S57C7[];
extern  VTBL_ENTRY _ZTV5S57C7[];
extern Class_Descriptor cd_S57C6;
extern VTBL_ENTRY _ZTI5S57C6[];
extern  VTBL_ENTRY _ZTV5S57C6[];
static Base_Class bases_S57C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S57C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S57C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S57C5[];
extern void _ZN5S57C5D1Ev();
extern void _ZN5S57C5D0Ev();
extern void _ZN5S57C72v3Ev();
extern void _ZN5S57C72v4Ev();
extern void _ZN5S57C72v5Ev();
extern void _ZN5S57C72v6Ev();
extern void _ZN5S57C72v7Ev();
extern void _ZN5S57C72v8Ev();
extern void _ZN5S57C72v9Ev();
extern void _ZN5S57C73v10Ev();
extern void _ZN5S57C73v11Ev();
extern void _ZN5S57C73v12Ev();
extern void _ZN5S57C73v13Ev();
extern void _ZN5S57C73v14Ev();
extern void _ZN5S57C73v15Ev();
extern void _ZN5S57C73v16Ev();
extern void _ZN5S57C73v17Ev();
extern void _ZN5S57C73v18Ev();
extern void _ZN5S57C73v19Ev();
extern void _ZN5S57C73v20Ev();
extern void _ZN5S57C73v21Ev();
extern void _ZN5S57C73v22Ev();
extern void _ZN5S57C73v23Ev();
extern void _ZN5S57C73v24Ev();
extern void _ZN5S57C73v25Ev();
extern void _ZN5S57C73v26Ev();
extern void _ZN5S57C73v27Ev();
extern void _ZN5S57C73v28Ev();
extern void _ZN5S57C73v29Ev();
extern void _ZN5S57C73v30Ev();
extern void _ZN5S57C73v31Ev();
extern void _ZN5S57C73v32Ev();
extern void _ZN5S57C73v33Ev();
extern void _ZN5S57C73v34Ev();
extern void _ZN5S57C73v35Ev();
extern void _ZN5S57C73v36Ev();
extern void _ZN5S57C73v37Ev();
extern void _ZN5S57C73v38Ev();
extern void _ZN5S57C73v39Ev();
extern void _ZN5S57C73v40Ev();
extern void _ZN5S57C73v41Ev();
extern void _ZN5S57C73v42Ev();
extern void _ZN5S57C73v43Ev();
extern void _ZN5S57C73v44Ev();
extern void _ZN5S57C73v45Ev();
extern void _ZN5S57C73v46Ev();
extern void _ZN5S57C73v47Ev();
extern void _ZN5S57C73v48Ev();
extern void _ZN5S57C73v49Ev();
extern void _ZN5S57C73v50Ev();
extern void _ZN5S57C73v51Ev();
extern void _ZN5S57C73v52Ev();
extern void _ZN5S57C73v53Ev();
extern void _ZN5S57C73v54Ev();
extern void _ZN5S57C73v55Ev();
extern void _ZN5S57C73v56Ev();
extern void _ZN5S57C73v57Ev();
extern void _ZN5S57C73v58Ev();
extern void _ZN5S57C73v59Ev();
extern void _ZN5S57C73v60Ev();
extern void _ZN5S57C73v61Ev();
extern void _ZN5S57C73v62Ev();
extern void _ZN5S57C73v63Ev();
extern void _ZN5S57C73v64Ev();
extern void _ZN5S57C73v65Ev();
extern void _ZN5S57C73v66Ev();
extern void _ZN5S57C63v67Ev();
extern void _ZN5S57C63v68Ev();
extern void _ZN5S57C63v69Ev();
extern void _ZN5S57C63v70Ev();
extern void _ZN5S57C63v71Ev();
extern void _ZN5S57C63v72Ev();
extern void _ZN5S57C63v73Ev();
extern void _ZN5S57C63v74Ev();
extern void _ZN5S57C63v75Ev();
extern void _ZN5S57C63v76Ev();
extern void _ZN5S57C63v77Ev();
extern void _ZN5S57C63v78Ev();
extern void _ZN5S57C63v79Ev();
extern void _ZN5S57C63v80Ev();
extern void _ZN5S57C63v81Ev();
extern void _ZN5S57C63v82Ev();
extern void _ZN5S57C63v83Ev();
extern void _ZN5S57C63v84Ev();
extern void _ZN5S57C63v85Ev();
extern void _ZN5S57C63v86Ev();
extern void _ZN5S57C63v87Ev();
extern void _ZN5S57C63v88Ev();
extern void _ZN5S57C53v89Ev();
extern void _ZN5S57C53v90Ev();
extern void _ZN5S57C53v91Ev();
extern void _ZN5S57C53v92Ev();
extern void _ZN5S57C53v93Ev();
extern void _ZN5S57C53v94Ev();
extern void _ZN5S57C53v95Ev();
extern void _ZN5S57C53v96Ev();
extern void _ZN5S57C53v97Ev();
extern void _ZN5S57C53v98Ev();
extern void _ZN5S57C53v99Ev();
extern void _ZN5S57C54v100Ev();
extern void _ZN5S57C54v101Ev();
extern void _ZN5S57C54v102Ev();
extern void _ZN5S57C54v103Ev();
extern void _ZN5S57C54v104Ev();
extern void _ZN5S57C54v105Ev();
extern void _ZN5S57C54v106Ev();
extern void _ZN5S57C54v107Ev();
extern void _ZN5S57C54v108Ev();
static  VTBL_ENTRY vtc_S57C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S57C5[0]),
  (VTBL_ENTRY)&_ZN5S57C5D1Ev,
  (VTBL_ENTRY)&_ZN5S57C5D0Ev,
  (VTBL_ENTRY)&_ZN5S57C72v3Ev,
  (VTBL_ENTRY)&_ZN5S57C72v4Ev,
  (VTBL_ENTRY)&_ZN5S57C72v5Ev,
  (VTBL_ENTRY)&_ZN5S57C72v6Ev,
  (VTBL_ENTRY)&_ZN5S57C72v7Ev,
  (VTBL_ENTRY)&_ZN5S57C72v8Ev,
  (VTBL_ENTRY)&_ZN5S57C72v9Ev,
  (VTBL_ENTRY)&_ZN5S57C73v10Ev,
  (VTBL_ENTRY)&_ZN5S57C73v11Ev,
  (VTBL_ENTRY)&_ZN5S57C73v12Ev,
  (VTBL_ENTRY)&_ZN5S57C73v13Ev,
  (VTBL_ENTRY)&_ZN5S57C73v14Ev,
  (VTBL_ENTRY)&_ZN5S57C73v15Ev,
  (VTBL_ENTRY)&_ZN5S57C73v16Ev,
  (VTBL_ENTRY)&_ZN5S57C73v17Ev,
  (VTBL_ENTRY)&_ZN5S57C73v18Ev,
  (VTBL_ENTRY)&_ZN5S57C73v19Ev,
  (VTBL_ENTRY)&_ZN5S57C73v20Ev,
  (VTBL_ENTRY)&_ZN5S57C73v21Ev,
  (VTBL_ENTRY)&_ZN5S57C73v22Ev,
  (VTBL_ENTRY)&_ZN5S57C73v23Ev,
  (VTBL_ENTRY)&_ZN5S57C73v24Ev,
  (VTBL_ENTRY)&_ZN5S57C73v25Ev,
  (VTBL_ENTRY)&_ZN5S57C73v26Ev,
  (VTBL_ENTRY)&_ZN5S57C73v27Ev,
  (VTBL_ENTRY)&_ZN5S57C73v28Ev,
  (VTBL_ENTRY)&_ZN5S57C73v29Ev,
  (VTBL_ENTRY)&_ZN5S57C73v30Ev,
  (VTBL_ENTRY)&_ZN5S57C73v31Ev,
  (VTBL_ENTRY)&_ZN5S57C73v32Ev,
  (VTBL_ENTRY)&_ZN5S57C73v33Ev,
  (VTBL_ENTRY)&_ZN5S57C73v34Ev,
  (VTBL_ENTRY)&_ZN5S57C73v35Ev,
  (VTBL_ENTRY)&_ZN5S57C73v36Ev,
  (VTBL_ENTRY)&_ZN5S57C73v37Ev,
  (VTBL_ENTRY)&_ZN5S57C73v38Ev,
  (VTBL_ENTRY)&_ZN5S57C73v39Ev,
  (VTBL_ENTRY)&_ZN5S57C73v40Ev,
  (VTBL_ENTRY)&_ZN5S57C73v41Ev,
  (VTBL_ENTRY)&_ZN5S57C73v42Ev,
  (VTBL_ENTRY)&_ZN5S57C73v43Ev,
  (VTBL_ENTRY)&_ZN5S57C73v44Ev,
  (VTBL_ENTRY)&_ZN5S57C73v45Ev,
  (VTBL_ENTRY)&_ZN5S57C73v46Ev,
  (VTBL_ENTRY)&_ZN5S57C73v47Ev,
  (VTBL_ENTRY)&_ZN5S57C73v48Ev,
  (VTBL_ENTRY)&_ZN5S57C73v49Ev,
  (VTBL_ENTRY)&_ZN5S57C73v50Ev,
  (VTBL_ENTRY)&_ZN5S57C73v51Ev,
  (VTBL_ENTRY)&_ZN5S57C73v52Ev,
  (VTBL_ENTRY)&_ZN5S57C73v53Ev,
  (VTBL_ENTRY)&_ZN5S57C73v54Ev,
  (VTBL_ENTRY)&_ZN5S57C73v55Ev,
  (VTBL_ENTRY)&_ZN5S57C73v56Ev,
  (VTBL_ENTRY)&_ZN5S57C73v57Ev,
  (VTBL_ENTRY)&_ZN5S57C73v58Ev,
  (VTBL_ENTRY)&_ZN5S57C73v59Ev,
  (VTBL_ENTRY)&_ZN5S57C73v60Ev,
  (VTBL_ENTRY)&_ZN5S57C73v61Ev,
  (VTBL_ENTRY)&_ZN5S57C73v62Ev,
  (VTBL_ENTRY)&_ZN5S57C73v63Ev,
  (VTBL_ENTRY)&_ZN5S57C73v64Ev,
  (VTBL_ENTRY)&_ZN5S57C73v65Ev,
  (VTBL_ENTRY)&_ZN5S57C73v66Ev,
  (VTBL_ENTRY)&_ZN5S57C63v67Ev,
  (VTBL_ENTRY)&_ZN5S57C63v68Ev,
  (VTBL_ENTRY)&_ZN5S57C63v69Ev,
  (VTBL_ENTRY)&_ZN5S57C63v70Ev,
  (VTBL_ENTRY)&_ZN5S57C63v71Ev,
  (VTBL_ENTRY)&_ZN5S57C63v72Ev,
  (VTBL_ENTRY)&_ZN5S57C63v73Ev,
  (VTBL_ENTRY)&_ZN5S57C63v74Ev,
  (VTBL_ENTRY)&_ZN5S57C63v75Ev,
  (VTBL_ENTRY)&_ZN5S57C63v76Ev,
  (VTBL_ENTRY)&_ZN5S57C63v77Ev,
  (VTBL_ENTRY)&_ZN5S57C63v78Ev,
  (VTBL_ENTRY)&_ZN5S57C63v79Ev,
  (VTBL_ENTRY)&_ZN5S57C63v80Ev,
  (VTBL_ENTRY)&_ZN5S57C63v81Ev,
  (VTBL_ENTRY)&_ZN5S57C63v82Ev,
  (VTBL_ENTRY)&_ZN5S57C63v83Ev,
  (VTBL_ENTRY)&_ZN5S57C63v84Ev,
  (VTBL_ENTRY)&_ZN5S57C63v85Ev,
  (VTBL_ENTRY)&_ZN5S57C63v86Ev,
  (VTBL_ENTRY)&_ZN5S57C63v87Ev,
  (VTBL_ENTRY)&_ZN5S57C63v88Ev,
  (VTBL_ENTRY)&_ZN5S57C53v89Ev,
  (VTBL_ENTRY)&_ZN5S57C53v90Ev,
  (VTBL_ENTRY)&_ZN5S57C53v91Ev,
  (VTBL_ENTRY)&_ZN5S57C53v92Ev,
  (VTBL_ENTRY)&_ZN5S57C53v93Ev,
  (VTBL_ENTRY)&_ZN5S57C53v94Ev,
  (VTBL_ENTRY)&_ZN5S57C53v95Ev,
  (VTBL_ENTRY)&_ZN5S57C53v96Ev,
  (VTBL_ENTRY)&_ZN5S57C53v97Ev,
  (VTBL_ENTRY)&_ZN5S57C53v98Ev,
  (VTBL_ENTRY)&_ZN5S57C53v99Ev,
  (VTBL_ENTRY)&_ZN5S57C54v100Ev,
  (VTBL_ENTRY)&_ZN5S57C54v101Ev,
  (VTBL_ENTRY)&_ZN5S57C54v102Ev,
  (VTBL_ENTRY)&_ZN5S57C54v103Ev,
  (VTBL_ENTRY)&_ZN5S57C54v104Ev,
  (VTBL_ENTRY)&_ZN5S57C54v105Ev,
  (VTBL_ENTRY)&_ZN5S57C54v106Ev,
  (VTBL_ENTRY)&_ZN5S57C54v107Ev,
  (VTBL_ENTRY)&_ZN5S57C54v108Ev,
};
extern VTBL_ENTRY _ZTI5S57C5[];
extern  VTBL_ENTRY _ZTV5S57C5[];
Class_Descriptor cd_S57C5 = {  "S57C5", // class name
  bases_S57C5, 2,
  &(vtc_S57C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI5S57C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S57C5),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S57C4  : S57C5 {
  void *s57c4f0[2];
  int s57c4f1[4];
  unsigned int s57c4f2:1;
  unsigned int s57c4f3:1;
  unsigned int s57c4f4:1;
  char s57c4f5;
  int s57c4f6;
  unsigned int s57c4f7:1;
  ::S287C23 s57c4f8;
  virtual  ~S57C4(); // _ZN5S57C4D1Ev
  virtual void  v109(); // _ZN5S57C44v109Ev
  virtual void  v110(); // _ZN5S57C44v110Ev
  virtual void  v111(); // _ZN5S57C44v111Ev
  virtual void  v112(); // _ZN5S57C44v112Ev
  virtual void  v113(); // _ZN5S57C44v113Ev
  virtual void  v114(); // _ZN5S57C44v114Ev
  virtual void  v115(); // _ZN5S57C44v115Ev
  virtual void  v116(); // _ZN5S57C44v116Ev
  virtual void  v117(); // _ZN5S57C44v117Ev
  virtual void  v118(); // _ZN5S57C44v118Ev
  virtual void  v119(); // _ZN5S57C44v119Ev
  virtual void  v120(); // _ZN5S57C44v120Ev
  virtual void  v121(); // _ZN5S57C44v121Ev
  virtual void  v122(); // _ZN5S57C44v122Ev
  S57C4(); // tgen
};
//SIG(-1 S57C4) C1{ BC2{ BC3{ BC4{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} FC17{ BC18{ BC9}} Fi[3]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] Fi[4] Fi:1 Fi:1 Fi:1 Fc Fi Fi:1 FC19{ BC20{ BC9}}}


 S57C4 ::~S57C4(){ note_dtor("S57C4", this);}
void  S57C4 ::v109(){vfunc_called(this, "_ZN5S57C44v109Ev");}
void  S57C4 ::v110(){vfunc_called(this, "_ZN5S57C44v110Ev");}
void  S57C4 ::v111(){vfunc_called(this, "_ZN5S57C44v111Ev");}
void  S57C4 ::v112(){vfunc_called(this, "_ZN5S57C44v112Ev");}
void  S57C4 ::v113(){vfunc_called(this, "_ZN5S57C44v113Ev");}
void  S57C4 ::v114(){vfunc_called(this, "_ZN5S57C44v114Ev");}
void  S57C4 ::v115(){vfunc_called(this, "_ZN5S57C44v115Ev");}
void  S57C4 ::v116(){vfunc_called(this, "_ZN5S57C44v116Ev");}
void  S57C4 ::v117(){vfunc_called(this, "_ZN5S57C44v117Ev");}
void  S57C4 ::v118(){vfunc_called(this, "_ZN5S57C44v118Ev");}
void  S57C4 ::v119(){vfunc_called(this, "_ZN5S57C44v119Ev");}
void  S57C4 ::v120(){vfunc_called(this, "_ZN5S57C44v120Ev");}
void  S57C4 ::v121(){vfunc_called(this, "_ZN5S57C44v121Ev");}
void  S57C4 ::v122(){vfunc_called(this, "_ZN5S57C44v122Ev");}
S57C4 ::S57C4(){ note_ctor("S57C4", this);} // tgen

static void Test_S57C4()
{
  extern Class_Descriptor cd_S57C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(43,62)];
    init_test(&cd_S57C4, buf);
    S57C4 *dp, &lv = *(dp=new (buf) S57C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(336,244), "sizeof(S57C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S57C4)");
    check_base_class_offset(lv, (S57C7*)(S57C6*)(S57C5*), 0, "S57C4");
    check_base_class_offset(lv, (S57C6*)(S57C5*), 0, "S57C4");
    check_base_class_offset(lv, (S57C5*), 0, "S57C4");
    check_field_offset(lv, s57c4f0, ABISELECT(272,196), "S57C4.s57c4f0");
    check_field_offset(lv, s57c4f1, ABISELECT(288,204), "S57C4.s57c4f1");
    set_bf_and_test(lv, s57c4f2, ABISELECT(304,220), 0, 1, 1, "S57C4");
    set_bf_and_test(lv, s57c4f3, ABISELECT(304,220), 1, 1, 1, "S57C4");
    set_bf_and_test(lv, s57c4f4, ABISELECT(304,220), 2, 1, 1, "S57C4");
    check_field_offset(lv, s57c4f5, ABISELECT(305,221), "S57C4.s57c4f5");
    check_field_offset(lv, s57c4f6, ABISELECT(308,224), "S57C4.s57c4f6");
    set_bf_and_test(lv, s57c4f7, ABISELECT(312,228), 0, 1, 1, "S57C4");
    check_field_offset(lv, s57c4f8, ABISELECT(320,232), "S57C4.s57c4f8");
    test_class_info(&lv, &cd_S57C4);
    dp->~S57C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS57C4(Test_S57C4, "S57C4", ABISELECT(336,244));

#else // __cplusplus

extern void _ZN5S57C4C1Ev();
extern void _ZN5S57C4D1Ev();
Name_Map name_map_S57C4[] = {
  NSPAIR(_ZN5S57C4C1Ev),
  NSPAIR(_ZN5S57C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S57C7;
extern VTBL_ENTRY _ZTI5S57C7[];
extern  VTBL_ENTRY _ZTV5S57C7[];
extern Class_Descriptor cd_S57C6;
extern VTBL_ENTRY _ZTI5S57C6[];
extern  VTBL_ENTRY _ZTV5S57C6[];
extern Class_Descriptor cd_S57C5;
extern VTBL_ENTRY _ZTI5S57C5[];
extern  VTBL_ENTRY _ZTV5S57C5[];
static Base_Class bases_S57C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S57C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S57C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S57C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S57C4[];
extern void _ZN5S57C4D1Ev();
extern void _ZN5S57C4D0Ev();
extern void _ZN5S57C72v3Ev();
extern void _ZN5S57C72v4Ev();
extern void _ZN5S57C72v5Ev();
extern void _ZN5S57C72v6Ev();
extern void _ZN5S57C72v7Ev();
extern void _ZN5S57C72v8Ev();
extern void _ZN5S57C72v9Ev();
extern void _ZN5S57C73v10Ev();
extern void _ZN5S57C73v11Ev();
extern void _ZN5S57C73v12Ev();
extern void _ZN5S57C73v13Ev();
extern void _ZN5S57C73v14Ev();
extern void _ZN5S57C73v15Ev();
extern void _ZN5S57C73v16Ev();
extern void _ZN5S57C73v17Ev();
extern void _ZN5S57C73v18Ev();
extern void _ZN5S57C73v19Ev();
extern void _ZN5S57C73v20Ev();
extern void _ZN5S57C73v21Ev();
extern void _ZN5S57C73v22Ev();
extern void _ZN5S57C73v23Ev();
extern void _ZN5S57C73v24Ev();
extern void _ZN5S57C73v25Ev();
extern void _ZN5S57C73v26Ev();
extern void _ZN5S57C73v27Ev();
extern void _ZN5S57C73v28Ev();
extern void _ZN5S57C73v29Ev();
extern void _ZN5S57C73v30Ev();
extern void _ZN5S57C73v31Ev();
extern void _ZN5S57C73v32Ev();
extern void _ZN5S57C73v33Ev();
extern void _ZN5S57C73v34Ev();
extern void _ZN5S57C73v35Ev();
extern void _ZN5S57C73v36Ev();
extern void _ZN5S57C73v37Ev();
extern void _ZN5S57C73v38Ev();
extern void _ZN5S57C73v39Ev();
extern void _ZN5S57C73v40Ev();
extern void _ZN5S57C73v41Ev();
extern void _ZN5S57C73v42Ev();
extern void _ZN5S57C73v43Ev();
extern void _ZN5S57C73v44Ev();
extern void _ZN5S57C73v45Ev();
extern void _ZN5S57C73v46Ev();
extern void _ZN5S57C73v47Ev();
extern void _ZN5S57C73v48Ev();
extern void _ZN5S57C73v49Ev();
extern void _ZN5S57C73v50Ev();
extern void _ZN5S57C73v51Ev();
extern void _ZN5S57C73v52Ev();
extern void _ZN5S57C73v53Ev();
extern void _ZN5S57C73v54Ev();
extern void _ZN5S57C73v55Ev();
extern void _ZN5S57C73v56Ev();
extern void _ZN5S57C73v57Ev();
extern void _ZN5S57C73v58Ev();
extern void _ZN5S57C73v59Ev();
extern void _ZN5S57C73v60Ev();
extern void _ZN5S57C73v61Ev();
extern void _ZN5S57C73v62Ev();
extern void _ZN5S57C73v63Ev();
extern void _ZN5S57C73v64Ev();
extern void _ZN5S57C73v65Ev();
extern void _ZN5S57C73v66Ev();
extern void _ZN5S57C63v67Ev();
extern void _ZN5S57C63v68Ev();
extern void _ZN5S57C63v69Ev();
extern void _ZN5S57C63v70Ev();
extern void _ZN5S57C63v71Ev();
extern void _ZN5S57C63v72Ev();
extern void _ZN5S57C63v73Ev();
extern void _ZN5S57C63v74Ev();
extern void _ZN5S57C63v75Ev();
extern void _ZN5S57C63v76Ev();
extern void _ZN5S57C63v77Ev();
extern void _ZN5S57C63v78Ev();
extern void _ZN5S57C63v79Ev();
extern void _ZN5S57C63v80Ev();
extern void _ZN5S57C63v81Ev();
extern void _ZN5S57C63v82Ev();
extern void _ZN5S57C63v83Ev();
extern void _ZN5S57C63v84Ev();
extern void _ZN5S57C63v85Ev();
extern void _ZN5S57C63v86Ev();
extern void _ZN5S57C63v87Ev();
extern void _ZN5S57C63v88Ev();
extern void _ZN5S57C53v89Ev();
extern void _ZN5S57C53v90Ev();
extern void _ZN5S57C53v91Ev();
extern void _ZN5S57C53v92Ev();
extern void _ZN5S57C53v93Ev();
extern void _ZN5S57C53v94Ev();
extern void _ZN5S57C53v95Ev();
extern void _ZN5S57C53v96Ev();
extern void _ZN5S57C53v97Ev();
extern void _ZN5S57C53v98Ev();
extern void _ZN5S57C53v99Ev();
extern void _ZN5S57C54v100Ev();
extern void _ZN5S57C54v101Ev();
extern void _ZN5S57C54v102Ev();
extern void _ZN5S57C54v103Ev();
extern void _ZN5S57C54v104Ev();
extern void _ZN5S57C54v105Ev();
extern void _ZN5S57C54v106Ev();
extern void _ZN5S57C54v107Ev();
extern void _ZN5S57C54v108Ev();
extern void _ZN5S57C44v109Ev();
extern void _ZN5S57C44v110Ev();
extern void _ZN5S57C44v111Ev();
extern void _ZN5S57C44v112Ev();
extern void _ZN5S57C44v113Ev();
extern void _ZN5S57C44v114Ev();
extern void _ZN5S57C44v115Ev();
extern void _ZN5S57C44v116Ev();
extern void _ZN5S57C44v117Ev();
extern void _ZN5S57C44v118Ev();
extern void _ZN5S57C44v119Ev();
extern void _ZN5S57C44v120Ev();
extern void _ZN5S57C44v121Ev();
extern void _ZN5S57C44v122Ev();
static  VTBL_ENTRY vtc_S57C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S57C4[0]),
  (VTBL_ENTRY)&_ZN5S57C4D1Ev,
  (VTBL_ENTRY)&_ZN5S57C4D0Ev,
  (VTBL_ENTRY)&_ZN5S57C72v3Ev,
  (VTBL_ENTRY)&_ZN5S57C72v4Ev,
  (VTBL_ENTRY)&_ZN5S57C72v5Ev,
  (VTBL_ENTRY)&_ZN5S57C72v6Ev,
  (VTBL_ENTRY)&_ZN5S57C72v7Ev,
  (VTBL_ENTRY)&_ZN5S57C72v8Ev,
  (VTBL_ENTRY)&_ZN5S57C72v9Ev,
  (VTBL_ENTRY)&_ZN5S57C73v10Ev,
  (VTBL_ENTRY)&_ZN5S57C73v11Ev,
  (VTBL_ENTRY)&_ZN5S57C73v12Ev,
  (VTBL_ENTRY)&_ZN5S57C73v13Ev,
  (VTBL_ENTRY)&_ZN5S57C73v14Ev,
  (VTBL_ENTRY)&_ZN5S57C73v15Ev,
  (VTBL_ENTRY)&_ZN5S57C73v16Ev,
  (VTBL_ENTRY)&_ZN5S57C73v17Ev,
  (VTBL_ENTRY)&_ZN5S57C73v18Ev,
  (VTBL_ENTRY)&_ZN5S57C73v19Ev,
  (VTBL_ENTRY)&_ZN5S57C73v20Ev,
  (VTBL_ENTRY)&_ZN5S57C73v21Ev,
  (VTBL_ENTRY)&_ZN5S57C73v22Ev,
  (VTBL_ENTRY)&_ZN5S57C73v23Ev,
  (VTBL_ENTRY)&_ZN5S57C73v24Ev,
  (VTBL_ENTRY)&_ZN5S57C73v25Ev,
  (VTBL_ENTRY)&_ZN5S57C73v26Ev,
  (VTBL_ENTRY)&_ZN5S57C73v27Ev,
  (VTBL_ENTRY)&_ZN5S57C73v28Ev,
  (VTBL_ENTRY)&_ZN5S57C73v29Ev,
  (VTBL_ENTRY)&_ZN5S57C73v30Ev,
  (VTBL_ENTRY)&_ZN5S57C73v31Ev,
  (VTBL_ENTRY)&_ZN5S57C73v32Ev,
  (VTBL_ENTRY)&_ZN5S57C73v33Ev,
  (VTBL_ENTRY)&_ZN5S57C73v34Ev,
  (VTBL_ENTRY)&_ZN5S57C73v35Ev,
  (VTBL_ENTRY)&_ZN5S57C73v36Ev,
  (VTBL_ENTRY)&_ZN5S57C73v37Ev,
  (VTBL_ENTRY)&_ZN5S57C73v38Ev,
  (VTBL_ENTRY)&_ZN5S57C73v39Ev,
  (VTBL_ENTRY)&_ZN5S57C73v40Ev,
  (VTBL_ENTRY)&_ZN5S57C73v41Ev,
  (VTBL_ENTRY)&_ZN5S57C73v42Ev,
  (VTBL_ENTRY)&_ZN5S57C73v43Ev,
  (VTBL_ENTRY)&_ZN5S57C73v44Ev,
  (VTBL_ENTRY)&_ZN5S57C73v45Ev,
  (VTBL_ENTRY)&_ZN5S57C73v46Ev,
  (VTBL_ENTRY)&_ZN5S57C73v47Ev,
  (VTBL_ENTRY)&_ZN5S57C73v48Ev,
  (VTBL_ENTRY)&_ZN5S57C73v49Ev,
  (VTBL_ENTRY)&_ZN5S57C73v50Ev,
  (VTBL_ENTRY)&_ZN5S57C73v51Ev,
  (VTBL_ENTRY)&_ZN5S57C73v52Ev,
  (VTBL_ENTRY)&_ZN5S57C73v53Ev,
  (VTBL_ENTRY)&_ZN5S57C73v54Ev,
  (VTBL_ENTRY)&_ZN5S57C73v55Ev,
  (VTBL_ENTRY)&_ZN5S57C73v56Ev,
  (VTBL_ENTRY)&_ZN5S57C73v57Ev,
  (VTBL_ENTRY)&_ZN5S57C73v58Ev,
  (VTBL_ENTRY)&_ZN5S57C73v59Ev,
  (VTBL_ENTRY)&_ZN5S57C73v60Ev,
  (VTBL_ENTRY)&_ZN5S57C73v61Ev,
  (VTBL_ENTRY)&_ZN5S57C73v62Ev,
  (VTBL_ENTRY)&_ZN5S57C73v63Ev,
  (VTBL_ENTRY)&_ZN5S57C73v64Ev,
  (VTBL_ENTRY)&_ZN5S57C73v65Ev,
  (VTBL_ENTRY)&_ZN5S57C73v66Ev,
  (VTBL_ENTRY)&_ZN5S57C63v67Ev,
  (VTBL_ENTRY)&_ZN5S57C63v68Ev,
  (VTBL_ENTRY)&_ZN5S57C63v69Ev,
  (VTBL_ENTRY)&_ZN5S57C63v70Ev,
  (VTBL_ENTRY)&_ZN5S57C63v71Ev,
  (VTBL_ENTRY)&_ZN5S57C63v72Ev,
  (VTBL_ENTRY)&_ZN5S57C63v73Ev,
  (VTBL_ENTRY)&_ZN5S57C63v74Ev,
  (VTBL_ENTRY)&_ZN5S57C63v75Ev,
  (VTBL_ENTRY)&_ZN5S57C63v76Ev,
  (VTBL_ENTRY)&_ZN5S57C63v77Ev,
  (VTBL_ENTRY)&_ZN5S57C63v78Ev,
  (VTBL_ENTRY)&_ZN5S57C63v79Ev,
  (VTBL_ENTRY)&_ZN5S57C63v80Ev,
  (VTBL_ENTRY)&_ZN5S57C63v81Ev,
  (VTBL_ENTRY)&_ZN5S57C63v82Ev,
  (VTBL_ENTRY)&_ZN5S57C63v83Ev,
  (VTBL_ENTRY)&_ZN5S57C63v84Ev,
  (VTBL_ENTRY)&_ZN5S57C63v85Ev,
  (VTBL_ENTRY)&_ZN5S57C63v86Ev,
  (VTBL_ENTRY)&_ZN5S57C63v87Ev,
  (VTBL_ENTRY)&_ZN5S57C63v88Ev,
  (VTBL_ENTRY)&_ZN5S57C53v89Ev,
  (VTBL_ENTRY)&_ZN5S57C53v90Ev,
  (VTBL_ENTRY)&_ZN5S57C53v91Ev,
  (VTBL_ENTRY)&_ZN5S57C53v92Ev,
  (VTBL_ENTRY)&_ZN5S57C53v93Ev,
  (VTBL_ENTRY)&_ZN5S57C53v94Ev,
  (VTBL_ENTRY)&_ZN5S57C53v95Ev,
  (VTBL_ENTRY)&_ZN5S57C53v96Ev,
  (VTBL_ENTRY)&_ZN5S57C53v97Ev,
  (VTBL_ENTRY)&_ZN5S57C53v98Ev,
  (VTBL_ENTRY)&_ZN5S57C53v99Ev,
  (VTBL_ENTRY)&_ZN5S57C54v100Ev,
  (VTBL_ENTRY)&_ZN5S57C54v101Ev,
  (VTBL_ENTRY)&_ZN5S57C54v102Ev,
  (VTBL_ENTRY)&_ZN5S57C54v103Ev,
  (VTBL_ENTRY)&_ZN5S57C54v104Ev,
  (VTBL_ENTRY)&_ZN5S57C54v105Ev,
  (VTBL_ENTRY)&_ZN5S57C54v106Ev,
  (VTBL_ENTRY)&_ZN5S57C54v107Ev,
  (VTBL_ENTRY)&_ZN5S57C54v108Ev,
  (VTBL_ENTRY)&_ZN5S57C44v109Ev,
  (VTBL_ENTRY)&_ZN5S57C44v110Ev,
  (VTBL_ENTRY)&_ZN5S57C44v111Ev,
  (VTBL_ENTRY)&_ZN5S57C44v112Ev,
  (VTBL_ENTRY)&_ZN5S57C44v113Ev,
  (VTBL_ENTRY)&_ZN5S57C44v114Ev,
  (VTBL_ENTRY)&_ZN5S57C44v115Ev,
  (VTBL_ENTRY)&_ZN5S57C44v116Ev,
  (VTBL_ENTRY)&_ZN5S57C44v117Ev,
  (VTBL_ENTRY)&_ZN5S57C44v118Ev,
  (VTBL_ENTRY)&_ZN5S57C44v119Ev,
  (VTBL_ENTRY)&_ZN5S57C44v120Ev,
  (VTBL_ENTRY)&_ZN5S57C44v121Ev,
  (VTBL_ENTRY)&_ZN5S57C44v122Ev,
};
extern VTBL_ENTRY _ZTI5S57C4[];
extern  VTBL_ENTRY _ZTV5S57C4[];
Class_Descriptor cd_S57C4 = {  "S57C4", // class name
  bases_S57C4, 3,
  &(vtc_S57C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(336,244), // object size
  NSPAIRA(_ZTI5S57C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S57C4),124, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S57C3  : S57C4 {
  void *s57c3f0[2];
  ::S287C8_nt s57c3f1;
  unsigned int s57c3f2:1;
  unsigned int s57c3f3:1;
  ::S3350C21_nt s57c3f4;
  virtual  ~S57C3(); // _ZN5S57C3D1Ev
  virtual void  v123(); // _ZN5S57C34v123Ev
  virtual void  v124(); // _ZN5S57C34v124Ev
  virtual void  v125(); // _ZN5S57C34v125Ev
  virtual void  v126(); // _ZN5S57C34v126Ev
  virtual void  v127(); // _ZN5S57C34v127Ev
  virtual void  v128(); // _ZN5S57C34v128Ev
  virtual void  v129(); // _ZN5S57C34v129Ev
  virtual void  v130(); // _ZN5S57C34v130Ev
  virtual void  v131(); // _ZN5S57C34v131Ev
  virtual void  v132(); // _ZN5S57C34v132Ev
  virtual void  v133(); // _ZN5S57C34v133Ev
  S57C3(); // tgen
};
//SIG(-1 S57C3) C1{ BC2{ BC3{ BC4{ BC5{ vd v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} FC18{ BC19{ BC10}} Fi[3]} vd v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 Fp[2] Fi[4] Fi:1 Fi:1 Fi:1 Fc Fi Fi:1 FC20{ BC21{ BC10}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 Fp[2] FC7 Fi:1 Fi:1 FC22{ m Fp FC6}}


 S57C3 ::~S57C3(){ note_dtor("S57C3", this);}
void  S57C3 ::v123(){vfunc_called(this, "_ZN5S57C34v123Ev");}
void  S57C3 ::v124(){vfunc_called(this, "_ZN5S57C34v124Ev");}
void  S57C3 ::v125(){vfunc_called(this, "_ZN5S57C34v125Ev");}
void  S57C3 ::v126(){vfunc_called(this, "_ZN5S57C34v126Ev");}
void  S57C3 ::v127(){vfunc_called(this, "_ZN5S57C34v127Ev");}
void  S57C3 ::v128(){vfunc_called(this, "_ZN5S57C34v128Ev");}
void  S57C3 ::v129(){vfunc_called(this, "_ZN5S57C34v129Ev");}
void  S57C3 ::v130(){vfunc_called(this, "_ZN5S57C34v130Ev");}
void  S57C3 ::v131(){vfunc_called(this, "_ZN5S57C34v131Ev");}
void  S57C3 ::v132(){vfunc_called(this, "_ZN5S57C34v132Ev");}
void  S57C3 ::v133(){vfunc_called(this, "_ZN5S57C34v133Ev");}
S57C3 ::S57C3(){ note_ctor("S57C3", this);} // tgen

static void Test_S57C3()
{
  extern Class_Descriptor cd_S57C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(50,71)];
    init_test(&cd_S57C3, buf);
    S57C3 *dp, &lv = *(dp=new (buf) S57C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(392,280), "sizeof(S57C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S57C3)");
    check_base_class_offset(lv, (S57C7*)(S57C6*)(S57C5*)(S57C4*), 0, "S57C3");
    check_base_class_offset(lv, (S57C6*)(S57C5*)(S57C4*), 0, "S57C3");
    check_base_class_offset(lv, (S57C5*)(S57C4*), 0, "S57C3");
    check_base_class_offset(lv, (S57C4*), 0, "S57C3");
    check_field_offset(lv, s57c3f0, ABISELECT(336,244), "S57C3.s57c3f0");
    check_field_offset(lv, s57c3f1, ABISELECT(352,252), "S57C3.s57c3f1");
    set_bf_and_test(lv, s57c3f2, ABISELECT(368,264), 0, 1, 1, "S57C3");
    set_bf_and_test(lv, s57c3f3, ABISELECT(368,264), 1, 1, 1, "S57C3");
    check_field_offset(lv, s57c3f4, ABISELECT(376,268), "S57C3.s57c3f4");
    test_class_info(&lv, &cd_S57C3);
    dp->~S57C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS57C3(Test_S57C3, "S57C3", ABISELECT(392,280));

#else // __cplusplus

extern void _ZN5S57C3C1Ev();
extern void _ZN5S57C3D1Ev();
Name_Map name_map_S57C3[] = {
  NSPAIR(_ZN5S57C3C1Ev),
  NSPAIR(_ZN5S57C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S57C7;
extern VTBL_ENTRY _ZTI5S57C7[];
extern  VTBL_ENTRY _ZTV5S57C7[];
extern Class_Descriptor cd_S57C6;
extern VTBL_ENTRY _ZTI5S57C6[];
extern  VTBL_ENTRY _ZTV5S57C6[];
extern Class_Descriptor cd_S57C5;
extern VTBL_ENTRY _ZTI5S57C5[];
extern  VTBL_ENTRY _ZTV5S57C5[];
extern Class_Descriptor cd_S57C4;
extern VTBL_ENTRY _ZTI5S57C4[];
extern  VTBL_ENTRY _ZTV5S57C4[];
static Base_Class bases_S57C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S57C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S57C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S57C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S57C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S57C3[];
extern void _ZN5S57C3D1Ev();
extern void _ZN5S57C3D0Ev();
extern void _ZN5S57C72v3Ev();
extern void _ZN5S57C72v4Ev();
extern void _ZN5S57C72v5Ev();
extern void _ZN5S57C72v6Ev();
extern void _ZN5S57C72v7Ev();
extern void _ZN5S57C72v8Ev();
extern void _ZN5S57C72v9Ev();
extern void _ZN5S57C73v10Ev();
extern void _ZN5S57C73v11Ev();
extern void _ZN5S57C73v12Ev();
extern void _ZN5S57C73v13Ev();
extern void _ZN5S57C73v14Ev();
extern void _ZN5S57C73v15Ev();
extern void _ZN5S57C73v16Ev();
extern void _ZN5S57C73v17Ev();
extern void _ZN5S57C73v18Ev();
extern void _ZN5S57C73v19Ev();
extern void _ZN5S57C73v20Ev();
extern void _ZN5S57C73v21Ev();
extern void _ZN5S57C73v22Ev();
extern void _ZN5S57C73v23Ev();
extern void _ZN5S57C73v24Ev();
extern void _ZN5S57C73v25Ev();
extern void _ZN5S57C73v26Ev();
extern void _ZN5S57C73v27Ev();
extern void _ZN5S57C73v28Ev();
extern void _ZN5S57C73v29Ev();
extern void _ZN5S57C73v30Ev();
extern void _ZN5S57C73v31Ev();
extern void _ZN5S57C73v32Ev();
extern void _ZN5S57C73v33Ev();
extern void _ZN5S57C73v34Ev();
extern void _ZN5S57C73v35Ev();
extern void _ZN5S57C73v36Ev();
extern void _ZN5S57C73v37Ev();
extern void _ZN5S57C73v38Ev();
extern void _ZN5S57C73v39Ev();
extern void _ZN5S57C73v40Ev();
extern void _ZN5S57C73v41Ev();
extern void _ZN5S57C73v42Ev();
extern void _ZN5S57C73v43Ev();
extern void _ZN5S57C73v44Ev();
extern void _ZN5S57C73v45Ev();
extern void _ZN5S57C73v46Ev();
extern void _ZN5S57C73v47Ev();
extern void _ZN5S57C73v48Ev();
extern void _ZN5S57C73v49Ev();
extern void _ZN5S57C73v50Ev();
extern void _ZN5S57C73v51Ev();
extern void _ZN5S57C73v52Ev();
extern void _ZN5S57C73v53Ev();
extern void _ZN5S57C73v54Ev();
extern void _ZN5S57C73v55Ev();
extern void _ZN5S57C73v56Ev();
extern void _ZN5S57C73v57Ev();
extern void _ZN5S57C73v58Ev();
extern void _ZN5S57C73v59Ev();
extern void _ZN5S57C73v60Ev();
extern void _ZN5S57C73v61Ev();
extern void _ZN5S57C73v62Ev();
extern void _ZN5S57C73v63Ev();
extern void _ZN5S57C73v64Ev();
extern void _ZN5S57C73v65Ev();
extern void _ZN5S57C73v66Ev();
extern void _ZN5S57C63v67Ev();
extern void _ZN5S57C63v68Ev();
extern void _ZN5S57C63v69Ev();
extern void _ZN5S57C63v70Ev();
extern void _ZN5S57C63v71Ev();
extern void _ZN5S57C63v72Ev();
extern void _ZN5S57C63v73Ev();
extern void _ZN5S57C63v74Ev();
extern void _ZN5S57C63v75Ev();
extern void _ZN5S57C63v76Ev();
extern void _ZN5S57C63v77Ev();
extern void _ZN5S57C63v78Ev();
extern void _ZN5S57C63v79Ev();
extern void _ZN5S57C63v80Ev();
extern void _ZN5S57C63v81Ev();
extern void _ZN5S57C63v82Ev();
extern void _ZN5S57C63v83Ev();
extern void _ZN5S57C63v84Ev();
extern void _ZN5S57C63v85Ev();
extern void _ZN5S57C63v86Ev();
extern void _ZN5S57C63v87Ev();
extern void _ZN5S57C63v88Ev();
extern void _ZN5S57C53v89Ev();
extern void _ZN5S57C53v90Ev();
extern void _ZN5S57C53v91Ev();
extern void _ZN5S57C53v92Ev();
extern void _ZN5S57C53v93Ev();
extern void _ZN5S57C53v94Ev();
extern void _ZN5S57C53v95Ev();
extern void _ZN5S57C53v96Ev();
extern void _ZN5S57C53v97Ev();
extern void _ZN5S57C53v98Ev();
extern void _ZN5S57C53v99Ev();
extern void _ZN5S57C54v100Ev();
extern void _ZN5S57C54v101Ev();
extern void _ZN5S57C54v102Ev();
extern void _ZN5S57C54v103Ev();
extern void _ZN5S57C54v104Ev();
extern void _ZN5S57C54v105Ev();
extern void _ZN5S57C54v106Ev();
extern void _ZN5S57C54v107Ev();
extern void _ZN5S57C54v108Ev();
extern void _ZN5S57C44v109Ev();
extern void _ZN5S57C44v110Ev();
extern void _ZN5S57C44v111Ev();
extern void _ZN5S57C44v112Ev();
extern void _ZN5S57C44v113Ev();
extern void _ZN5S57C44v114Ev();
extern void _ZN5S57C44v115Ev();
extern void _ZN5S57C44v116Ev();
extern void _ZN5S57C44v117Ev();
extern void _ZN5S57C44v118Ev();
extern void _ZN5S57C44v119Ev();
extern void _ZN5S57C44v120Ev();
extern void _ZN5S57C44v121Ev();
extern void _ZN5S57C44v122Ev();
extern void _ZN5S57C34v123Ev();
extern void _ZN5S57C34v124Ev();
extern void _ZN5S57C34v125Ev();
extern void _ZN5S57C34v126Ev();
extern void _ZN5S57C34v127Ev();
extern void _ZN5S57C34v128Ev();
extern void _ZN5S57C34v129Ev();
extern void _ZN5S57C34v130Ev();
extern void _ZN5S57C34v131Ev();
extern void _ZN5S57C34v132Ev();
extern void _ZN5S57C34v133Ev();
static  VTBL_ENTRY vtc_S57C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S57C3[0]),
  (VTBL_ENTRY)&_ZN5S57C3D1Ev,
  (VTBL_ENTRY)&_ZN5S57C3D0Ev,
  (VTBL_ENTRY)&_ZN5S57C72v3Ev,
  (VTBL_ENTRY)&_ZN5S57C72v4Ev,
  (VTBL_ENTRY)&_ZN5S57C72v5Ev,
  (VTBL_ENTRY)&_ZN5S57C72v6Ev,
  (VTBL_ENTRY)&_ZN5S57C72v7Ev,
  (VTBL_ENTRY)&_ZN5S57C72v8Ev,
  (VTBL_ENTRY)&_ZN5S57C72v9Ev,
  (VTBL_ENTRY)&_ZN5S57C73v10Ev,
  (VTBL_ENTRY)&_ZN5S57C73v11Ev,
  (VTBL_ENTRY)&_ZN5S57C73v12Ev,
  (VTBL_ENTRY)&_ZN5S57C73v13Ev,
  (VTBL_ENTRY)&_ZN5S57C73v14Ev,
  (VTBL_ENTRY)&_ZN5S57C73v15Ev,
  (VTBL_ENTRY)&_ZN5S57C73v16Ev,
  (VTBL_ENTRY)&_ZN5S57C73v17Ev,
  (VTBL_ENTRY)&_ZN5S57C73v18Ev,
  (VTBL_ENTRY)&_ZN5S57C73v19Ev,
  (VTBL_ENTRY)&_ZN5S57C73v20Ev,
  (VTBL_ENTRY)&_ZN5S57C73v21Ev,
  (VTBL_ENTRY)&_ZN5S57C73v22Ev,
  (VTBL_ENTRY)&_ZN5S57C73v23Ev,
  (VTBL_ENTRY)&_ZN5S57C73v24Ev,
  (VTBL_ENTRY)&_ZN5S57C73v25Ev,
  (VTBL_ENTRY)&_ZN5S57C73v26Ev,
  (VTBL_ENTRY)&_ZN5S57C73v27Ev,
  (VTBL_ENTRY)&_ZN5S57C73v28Ev,
  (VTBL_ENTRY)&_ZN5S57C73v29Ev,
  (VTBL_ENTRY)&_ZN5S57C73v30Ev,
  (VTBL_ENTRY)&_ZN5S57C73v31Ev,
  (VTBL_ENTRY)&_ZN5S57C73v32Ev,
  (VTBL_ENTRY)&_ZN5S57C73v33Ev,
  (VTBL_ENTRY)&_ZN5S57C73v34Ev,
  (VTBL_ENTRY)&_ZN5S57C73v35Ev,
  (VTBL_ENTRY)&_ZN5S57C73v36Ev,
  (VTBL_ENTRY)&_ZN5S57C73v37Ev,
  (VTBL_ENTRY)&_ZN5S57C73v38Ev,
  (VTBL_ENTRY)&_ZN5S57C73v39Ev,
  (VTBL_ENTRY)&_ZN5S57C73v40Ev,
  (VTBL_ENTRY)&_ZN5S57C73v41Ev,
  (VTBL_ENTRY)&_ZN5S57C73v42Ev,
  (VTBL_ENTRY)&_ZN5S57C73v43Ev,
  (VTBL_ENTRY)&_ZN5S57C73v44Ev,
  (VTBL_ENTRY)&_ZN5S57C73v45Ev,
  (VTBL_ENTRY)&_ZN5S57C73v46Ev,
  (VTBL_ENTRY)&_ZN5S57C73v47Ev,
  (VTBL_ENTRY)&_ZN5S57C73v48Ev,
  (VTBL_ENTRY)&_ZN5S57C73v49Ev,
  (VTBL_ENTRY)&_ZN5S57C73v50Ev,
  (VTBL_ENTRY)&_ZN5S57C73v51Ev,
  (VTBL_ENTRY)&_ZN5S57C73v52Ev,
  (VTBL_ENTRY)&_ZN5S57C73v53Ev,
  (VTBL_ENTRY)&_ZN5S57C73v54Ev,
  (VTBL_ENTRY)&_ZN5S57C73v55Ev,
  (VTBL_ENTRY)&_ZN5S57C73v56Ev,
  (VTBL_ENTRY)&_ZN5S57C73v57Ev,
  (VTBL_ENTRY)&_ZN5S57C73v58Ev,
  (VTBL_ENTRY)&_ZN5S57C73v59Ev,
  (VTBL_ENTRY)&_ZN5S57C73v60Ev,
  (VTBL_ENTRY)&_ZN5S57C73v61Ev,
  (VTBL_ENTRY)&_ZN5S57C73v62Ev,
  (VTBL_ENTRY)&_ZN5S57C73v63Ev,
  (VTBL_ENTRY)&_ZN5S57C73v64Ev,
  (VTBL_ENTRY)&_ZN5S57C73v65Ev,
  (VTBL_ENTRY)&_ZN5S57C73v66Ev,
  (VTBL_ENTRY)&_ZN5S57C63v67Ev,
  (VTBL_ENTRY)&_ZN5S57C63v68Ev,
  (VTBL_ENTRY)&_ZN5S57C63v69Ev,
  (VTBL_ENTRY)&_ZN5S57C63v70Ev,
  (VTBL_ENTRY)&_ZN5S57C63v71Ev,
  (VTBL_ENTRY)&_ZN5S57C63v72Ev,
  (VTBL_ENTRY)&_ZN5S57C63v73Ev,
  (VTBL_ENTRY)&_ZN5S57C63v74Ev,
  (VTBL_ENTRY)&_ZN5S57C63v75Ev,
  (VTBL_ENTRY)&_ZN5S57C63v76Ev,
  (VTBL_ENTRY)&_ZN5S57C63v77Ev,
  (VTBL_ENTRY)&_ZN5S57C63v78Ev,
  (VTBL_ENTRY)&_ZN5S57C63v79Ev,
  (VTBL_ENTRY)&_ZN5S57C63v80Ev,
  (VTBL_ENTRY)&_ZN5S57C63v81Ev,
  (VTBL_ENTRY)&_ZN5S57C63v82Ev,
  (VTBL_ENTRY)&_ZN5S57C63v83Ev,
  (VTBL_ENTRY)&_ZN5S57C63v84Ev,
  (VTBL_ENTRY)&_ZN5S57C63v85Ev,
  (VTBL_ENTRY)&_ZN5S57C63v86Ev,
  (VTBL_ENTRY)&_ZN5S57C63v87Ev,
  (VTBL_ENTRY)&_ZN5S57C63v88Ev,
  (VTBL_ENTRY)&_ZN5S57C53v89Ev,
  (VTBL_ENTRY)&_ZN5S57C53v90Ev,
  (VTBL_ENTRY)&_ZN5S57C53v91Ev,
  (VTBL_ENTRY)&_ZN5S57C53v92Ev,
  (VTBL_ENTRY)&_ZN5S57C53v93Ev,
  (VTBL_ENTRY)&_ZN5S57C53v94Ev,
  (VTBL_ENTRY)&_ZN5S57C53v95Ev,
  (VTBL_ENTRY)&_ZN5S57C53v96Ev,
  (VTBL_ENTRY)&_ZN5S57C53v97Ev,
  (VTBL_ENTRY)&_ZN5S57C53v98Ev,
  (VTBL_ENTRY)&_ZN5S57C53v99Ev,
  (VTBL_ENTRY)&_ZN5S57C54v100Ev,
  (VTBL_ENTRY)&_ZN5S57C54v101Ev,
  (VTBL_ENTRY)&_ZN5S57C54v102Ev,
  (VTBL_ENTRY)&_ZN5S57C54v103Ev,
  (VTBL_ENTRY)&_ZN5S57C54v104Ev,
  (VTBL_ENTRY)&_ZN5S57C54v105Ev,
  (VTBL_ENTRY)&_ZN5S57C54v106Ev,
  (VTBL_ENTRY)&_ZN5S57C54v107Ev,
  (VTBL_ENTRY)&_ZN5S57C54v108Ev,
  (VTBL_ENTRY)&_ZN5S57C44v109Ev,
  (VTBL_ENTRY)&_ZN5S57C44v110Ev,
  (VTBL_ENTRY)&_ZN5S57C44v111Ev,
  (VTBL_ENTRY)&_ZN5S57C44v112Ev,
  (VTBL_ENTRY)&_ZN5S57C44v113Ev,
  (VTBL_ENTRY)&_ZN5S57C44v114Ev,
  (VTBL_ENTRY)&_ZN5S57C44v115Ev,
  (VTBL_ENTRY)&_ZN5S57C44v116Ev,
  (VTBL_ENTRY)&_ZN5S57C44v117Ev,
  (VTBL_ENTRY)&_ZN5S57C44v118Ev,
  (VTBL_ENTRY)&_ZN5S57C44v119Ev,
  (VTBL_ENTRY)&_ZN5S57C44v120Ev,
  (VTBL_ENTRY)&_ZN5S57C44v121Ev,
  (VTBL_ENTRY)&_ZN5S57C44v122Ev,
  (VTBL_ENTRY)&_ZN5S57C34v123Ev,
  (VTBL_ENTRY)&_ZN5S57C34v124Ev,
  (VTBL_ENTRY)&_ZN5S57C34v125Ev,
  (VTBL_ENTRY)&_ZN5S57C34v126Ev,
  (VTBL_ENTRY)&_ZN5S57C34v127Ev,
  (VTBL_ENTRY)&_ZN5S57C34v128Ev,
  (VTBL_ENTRY)&_ZN5S57C34v129Ev,
  (VTBL_ENTRY)&_ZN5S57C34v130Ev,
  (VTBL_ENTRY)&_ZN5S57C34v131Ev,
  (VTBL_ENTRY)&_ZN5S57C34v132Ev,
  (VTBL_ENTRY)&_ZN5S57C34v133Ev,
};
extern VTBL_ENTRY _ZTI5S57C3[];
extern  VTBL_ENTRY _ZTV5S57C3[];
Class_Descriptor cd_S57C3 = {  "S57C3", // class name
  bases_S57C3, 4,
  &(vtc_S57C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(392,280), // object size
  NSPAIRA(_ZTI5S57C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S57C3),135, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S57C2  : S57C3 {
  virtual  ~S57C2(); // _ZN5S57C2D1Ev
  virtual void  v134(); // _ZN5S57C24v134Ev
  virtual void  v135(); // _ZN5S57C24v135Ev
  S57C2(); // tgen
};
//SIG(-1 S57C2) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi[2] Fp Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 FC12{ m} FC8 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 Fi:1 Fi:1 Fi:1 FC13{ BC14{ BC11}} FC15{ BC16{ BC11}} FC17{ BC18{ BC11}} FC19{ BC20{ BC11}} Fi[3]} vd v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 Fp[2] Fi[4] Fi:1 Fi:1 Fi:1 Fc Fi Fi:1 FC21{ BC22{ BC11}}} vd v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 Fp[2] FC8 Fi:1 Fi:1 FC23{ m Fp FC7}} vd v1 v2}


 S57C2 ::~S57C2(){ note_dtor("S57C2", this);}
void  S57C2 ::v134(){vfunc_called(this, "_ZN5S57C24v134Ev");}
void  S57C2 ::v135(){vfunc_called(this, "_ZN5S57C24v135Ev");}
S57C2 ::S57C2(){ note_ctor("S57C2", this);} // tgen

static void Test_S57C2()
{
  extern Class_Descriptor cd_S57C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(50,71)];
    init_test(&cd_S57C2, buf);
    S57C2 *dp, &lv = *(dp=new (buf) S57C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(392,280), "sizeof(S57C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S57C2)");
    check_base_class_offset(lv, (S57C7*)(S57C6*)(S57C5*)(S57C4*)(S57C3*), 0, "S57C2");
    check_base_class_offset(lv, (S57C6*)(S57C5*)(S57C4*)(S57C3*), 0, "S57C2");
    check_base_class_offset(lv, (S57C5*)(S57C4*)(S57C3*), 0, "S57C2");
    check_base_class_offset(lv, (S57C4*)(S57C3*), 0, "S57C2");
    check_base_class_offset(lv, (S57C3*), 0, "S57C2");
    test_class_info(&lv, &cd_S57C2);
    dp->~S57C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS57C2(Test_S57C2, "S57C2", ABISELECT(392,280));

#else // __cplusplus

extern void _ZN5S57C2C1Ev();
extern void _ZN5S57C2D1Ev();
Name_Map name_map_S57C2[] = {
  NSPAIR(_ZN5S57C2C1Ev),
  NSPAIR(_ZN5S57C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S57C7;
extern VTBL_ENTRY _ZTI5S57C7[];
extern  VTBL_ENTRY _ZTV5S57C7[];
extern Class_Descriptor cd_S57C6;
extern VTBL_ENTRY _ZTI5S57C6[];
extern  VTBL_ENTRY _ZTV5S57C6[];
extern Class_Descriptor cd_S57C5;
extern VTBL_ENTRY _ZTI5S57C5[];
extern  VTBL_ENTRY _ZTV5S57C5[];
extern Class_Descriptor cd_S57C4;
extern VTBL_ENTRY _ZTI5S57C4[];
extern  VTBL_ENTRY _ZTV5S57C4[];
extern Class_Descriptor cd_S57C3;
extern VTBL_ENTRY _ZTI5S57C3[];
extern  VTBL_ENTRY _ZTV5S57C3[];
static Base_Class bases_S57C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S57C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S57C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S57C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S57C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S57C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S57C2[];
extern void _ZN5S57C2D1Ev();
extern void _ZN5S57C2D0Ev();
extern void _ZN5S57C72v3Ev();
extern void _ZN5S57C72v4Ev();
extern void _ZN5S57C72v5Ev();
extern void _ZN5S57C72v6Ev();
extern void _ZN5S57C72v7Ev();
extern void _ZN5S57C72v8Ev();
extern void _ZN5S57C72v9Ev();
extern void _ZN5S57C73v10Ev();
extern void _ZN5S57C73v11Ev();
extern void _ZN5S57C73v12Ev();
extern void _ZN5S57C73v13Ev();
extern void _ZN5S57C73v14Ev();
extern void _ZN5S57C73v15Ev();
extern void _ZN5S57C73v16Ev();
extern void _ZN5S57C73v17Ev();
extern void _ZN5S57C73v18Ev();
extern void _ZN5S57C73v19Ev();
extern void _ZN5S57C73v20Ev();
extern void _ZN5S57C73v21Ev();
extern void _ZN5S57C73v22Ev();
extern void _ZN5S57C73v23Ev();
extern void _ZN5S57C73v24Ev();
extern void _ZN5S57C73v25Ev();
extern void _ZN5S57C73v26Ev();
extern void _ZN5S57C73v27Ev();
extern void _ZN5S57C73v28Ev();
extern void _ZN5S57C73v29Ev();
extern void _ZN5S57C73v30Ev();
extern void _ZN5S57C73v31Ev();
extern void _ZN5S57C73v32Ev();
extern void _ZN5S57C73v33Ev();
extern void _ZN5S57C73v34Ev();
extern void _ZN5S57C73v35Ev();
extern void _ZN5S57C73v36Ev();
extern void _ZN5S57C73v37Ev();
extern void _ZN5S57C73v38Ev();
extern void _ZN5S57C73v39Ev();
extern void _ZN5S57C73v40Ev();
extern void _ZN5S57C73v41Ev();
extern void _ZN5S57C73v42Ev();
extern void _ZN5S57C73v43Ev();
extern void _ZN5S57C73v44Ev();
extern void _ZN5S57C73v45Ev();
extern void _ZN5S57C73v46Ev();
extern void _ZN5S57C73v47Ev();
extern void _ZN5S57C73v48Ev();
extern void _ZN5S57C73v49Ev();
extern void _ZN5S57C73v50Ev();
extern void _ZN5S57C73v51Ev();
extern void _ZN5S57C73v52Ev();
extern void _ZN5S57C73v53Ev();
extern void _ZN5S57C73v54Ev();
extern void _ZN5S57C73v55Ev();
extern void _ZN5S57C73v56Ev();
extern void _ZN5S57C73v57Ev();
extern void _ZN5S57C73v58Ev();
extern void _ZN5S57C73v59Ev();
extern void _ZN5S57C73v60Ev();
extern void _ZN5S57C73v61Ev();
extern void _ZN5S57C73v62Ev();
extern void _ZN5S57C73v63Ev();
extern void _ZN5S57C73v64Ev();
extern void _ZN5S57C73v65Ev();
extern void _ZN5S57C73v66Ev();
extern void _ZN5S57C63v67Ev();
extern void _ZN5S57C63v68Ev();
extern void _ZN5S57C63v69Ev();
extern void _ZN5S57C63v70Ev();
extern void _ZN5S57C63v71Ev();
extern void _ZN5S57C63v72Ev();
extern void _ZN5S57C63v73Ev();
extern void _ZN5S57C63v74Ev();
extern void _ZN5S57C63v75Ev();
extern void _ZN5S57C63v76Ev();
extern void _ZN5S57C63v77Ev();
extern void _ZN5S57C63v78Ev();
extern void _ZN5S57C63v79Ev();
extern void _ZN5S57C63v80Ev();
extern void _ZN5S57C63v81Ev();
extern void _ZN5S57C63v82Ev();
extern void _ZN5S57C63v83Ev();
extern void _ZN5S57C63v84Ev();
extern void _ZN5S57C63v85Ev();
extern void _ZN5S57C63v86Ev();
extern void _ZN5S57C63v87Ev();
extern void _ZN5S57C63v88Ev();
extern void _ZN5S57C53v89Ev();
extern void _ZN5S57C53v90Ev();
extern void _ZN5S57C53v91Ev();
extern void _ZN5S57C53v92Ev();
extern void _ZN5S57C53v93Ev();
extern void _ZN5S57C53v94Ev();
extern void _ZN5S57C53v95Ev();
extern void _ZN5S57C53v96Ev();
extern void _ZN5S57C53v97Ev();
extern void _ZN5S57C53v98Ev();
extern void _ZN5S57C53v99Ev();
extern void _ZN5S57C54v100Ev();
extern void _ZN5S57C54v101Ev();
extern void _ZN5S57C54v102Ev();
extern void _ZN5S57C54v103Ev();
extern void _ZN5S57C54v104Ev();
extern void _ZN5S57C54v105Ev();
extern void _ZN5S57C54v106Ev();
extern void _ZN5S57C54v107Ev();
extern void _ZN5S57C54v108Ev();
extern void _ZN5S57C44v109Ev();
extern void _ZN5S57C44v110Ev();
extern void _ZN5S57C44v111Ev();
extern void _ZN5S57C44v112Ev();
extern void _ZN5S57C44v113Ev();
extern void _ZN5S57C44v114Ev();
extern void _ZN5S57C44v115Ev();
extern void _ZN5S57C44v116Ev();
extern void _ZN5S57C44v117Ev();
extern void _ZN5S57C44v118Ev();
extern void _ZN5S57C44v119Ev();
extern void _ZN5S57C44v120Ev();
extern void _ZN5S57C44v121Ev();
extern void _ZN5S57C44v122Ev();
extern void _ZN5S57C34v123Ev();
extern void _ZN5S57C34v124Ev();
extern void _ZN5S57C34v125Ev();
extern void _ZN5S57C34v126Ev();
extern void _ZN5S57C34v127Ev();
extern void _ZN5S57C34v128Ev();
extern void _ZN5S57C34v129Ev();
extern void _ZN5S57C34v130Ev();
extern void _ZN5S57C34v131Ev();
extern void _ZN5S57C34v132Ev();
extern void _ZN5S57C34v133Ev();
extern void _ZN5S57C24v134Ev();
extern void _ZN5S57C24v135Ev();
static  VTBL_ENTRY vtc_S57C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S57C2[0]),
  (VTBL_ENTRY)&_ZN5S57C2D1Ev,
  (VTBL_ENTRY)&_ZN5S57C2D0Ev,
  (VTBL_ENTRY)&_ZN5S57C72v3Ev,
  (VTBL_ENTRY)&_ZN5S57C72v4Ev,
  (VTBL_ENTRY)&_ZN5S57C72v5Ev,
  (VTBL_ENTRY)&_ZN5S57C72v6Ev,
  (VTBL_ENTRY)&_ZN5S57C72v7Ev,
  (VTBL_ENTRY)&_ZN5S57C72v8Ev,
  (VTBL_ENTRY)&_ZN5S57C72v9Ev,
  (VTBL_ENTRY)&_ZN5S57C73v10Ev,
  (VTBL_ENTRY)&_ZN5S57C73v11Ev,
  (VTBL_ENTRY)&_ZN5S57C73v12Ev,
  (VTBL_ENTRY)&_ZN5S57C73v13Ev,
  (VTBL_ENTRY)&_ZN5S57C73v14Ev,
  (VTBL_ENTRY)&_ZN5S57C73v15Ev,
  (VTBL_ENTRY)&_ZN5S57C73v16Ev,
  (VTBL_ENTRY)&_ZN5S57C73v17Ev,
  (VTBL_ENTRY)&_ZN5S57C73v18Ev,
  (VTBL_ENTRY)&_ZN5S57C73v19Ev,
  (VTBL_ENTRY)&_ZN5S57C73v20Ev,
  (VTBL_ENTRY)&_ZN5S57C73v21Ev,
  (VTBL_ENTRY)&_ZN5S57C73v22Ev,
  (VTBL_ENTRY)&_ZN5S57C73v23Ev,
  (VTBL_ENTRY)&_ZN5S57C73v24Ev,
  (VTBL_ENTRY)&_ZN5S57C73v25Ev,
  (VTBL_ENTRY)&_ZN5S57C73v26Ev,
  (VTBL_ENTRY)&_ZN5S57C73v27Ev,
  (VTBL_ENTRY)&_ZN5S57C73v28Ev,
  (VTBL_ENTRY)&_ZN5S57C73v29Ev,
  (VTBL_ENTRY)&_ZN5S57C73v30Ev,
  (VTBL_ENTRY)&_ZN5S57C73v31Ev,
  (VTBL_ENTRY)&_ZN5S57C73v32Ev,
  (VTBL_ENTRY)&_ZN5S57C73v33Ev,
  (VTBL_ENTRY)&_ZN5S57C73v34Ev,
  (VTBL_ENTRY)&_ZN5S57C73v35Ev,
  (VTBL_ENTRY)&_ZN5S57C73v36Ev,
  (VTBL_ENTRY)&_ZN5S57C73v37Ev,
  (VTBL_ENTRY)&_ZN5S57C73v38Ev,
  (VTBL_ENTRY)&_ZN5S57C73v39Ev,
  (VTBL_ENTRY)&_ZN5S57C73v40Ev,
  (VTBL_ENTRY)&_ZN5S57C73v41Ev,
  (VTBL_ENTRY)&_ZN5S57C73v42Ev,
  (VTBL_ENTRY)&_ZN5S57C73v43Ev,
  (VTBL_ENTRY)&_ZN5S57C73v44Ev,
  (VTBL_ENTRY)&_ZN5S57C73v45Ev,
  (VTBL_ENTRY)&_ZN5S57C73v46Ev,
  (VTBL_ENTRY)&_ZN5S57C73v47Ev,
  (VTBL_ENTRY)&_ZN5S57C73v48Ev,
  (VTBL_ENTRY)&_ZN5S57C73v49Ev,
  (VTBL_ENTRY)&_ZN5S57C73v50Ev,
  (VTBL_ENTRY)&_ZN5S57C73v51Ev,
  (VTBL_ENTRY)&_ZN5S57C73v52Ev,
  (VTBL_ENTRY)&_ZN5S57C73v53Ev,
  (VTBL_ENTRY)&_ZN5S57C73v54Ev,
  (VTBL_ENTRY)&_ZN5S57C73v55Ev,
  (VTBL_ENTRY)&_ZN5S57C73v56Ev,
  (VTBL_ENTRY)&_ZN5S57C73v57Ev,
  (VTBL_ENTRY)&_ZN5S57C73v58Ev,
  (VTBL_ENTRY)&_ZN5S57C73v59Ev,
  (VTBL_ENTRY)&_ZN5S57C73v60Ev,
  (VTBL_ENTRY)&_ZN5S57C73v61Ev,
  (VTBL_ENTRY)&_ZN5S57C73v62Ev,
  (VTBL_ENTRY)&_ZN5S57C73v63Ev,
  (VTBL_ENTRY)&_ZN5S57C73v64Ev,
  (VTBL_ENTRY)&_ZN5S57C73v65Ev,
  (VTBL_ENTRY)&_ZN5S57C73v66Ev,
  (VTBL_ENTRY)&_ZN5S57C63v67Ev,
  (VTBL_ENTRY)&_ZN5S57C63v68Ev,
  (VTBL_ENTRY)&_ZN5S57C63v69Ev,
  (VTBL_ENTRY)&_ZN5S57C63v70Ev,
  (VTBL_ENTRY)&_ZN5S57C63v71Ev,
  (VTBL_ENTRY)&_ZN5S57C63v72Ev,
  (VTBL_ENTRY)&_ZN5S57C63v73Ev,
  (VTBL_ENTRY)&_ZN5S57C63v74Ev,
  (VTBL_ENTRY)&_ZN5S57C63v75Ev,
  (VTBL_ENTRY)&_ZN5S57C63v76Ev,
  (VTBL_ENTRY)&_ZN5S57C63v77Ev,
  (VTBL_ENTRY)&_ZN5S57C63v78Ev,
  (VTBL_ENTRY)&_ZN5S57C63v79Ev,
  (VTBL_ENTRY)&_ZN5S57C63v80Ev,
  (VTBL_ENTRY)&_ZN5S57C63v81Ev,
  (VTBL_ENTRY)&_ZN5S57C63v82Ev,
  (VTBL_ENTRY)&_ZN5S57C63v83Ev,
  (VTBL_ENTRY)&_ZN5S57C63v84Ev,
  (VTBL_ENTRY)&_ZN5S57C63v85Ev,
  (VTBL_ENTRY)&_ZN5S57C63v86Ev,
  (VTBL_ENTRY)&_ZN5S57C63v87Ev,
  (VTBL_ENTRY)&_ZN5S57C63v88Ev,
  (VTBL_ENTRY)&_ZN5S57C53v89Ev,
  (VTBL_ENTRY)&_ZN5S57C53v90Ev,
  (VTBL_ENTRY)&_ZN5S57C53v91Ev,
  (VTBL_ENTRY)&_ZN5S57C53v92Ev,
  (VTBL_ENTRY)&_ZN5S57C53v93Ev,
  (VTBL_ENTRY)&_ZN5S57C53v94Ev,
  (VTBL_ENTRY)&_ZN5S57C53v95Ev,
  (VTBL_ENTRY)&_ZN5S57C53v96Ev,
  (VTBL_ENTRY)&_ZN5S57C53v97Ev,
  (VTBL_ENTRY)&_ZN5S57C53v98Ev,
  (VTBL_ENTRY)&_ZN5S57C53v99Ev,
  (VTBL_ENTRY)&_ZN5S57C54v100Ev,
  (VTBL_ENTRY)&_ZN5S57C54v101Ev,
  (VTBL_ENTRY)&_ZN5S57C54v102Ev,
  (VTBL_ENTRY)&_ZN5S57C54v103Ev,
  (VTBL_ENTRY)&_ZN5S57C54v104Ev,
  (VTBL_ENTRY)&_ZN5S57C54v105Ev,
  (VTBL_ENTRY)&_ZN5S57C54v106Ev,
  (VTBL_ENTRY)&_ZN5S57C54v107Ev,
  (VTBL_ENTRY)&_ZN5S57C54v108Ev,
  (VTBL_ENTRY)&_ZN5S57C44v109Ev,
  (VTBL_ENTRY)&_ZN5S57C44v110Ev,
  (VTBL_ENTRY)&_ZN5S57C44v111Ev,
  (VTBL_ENTRY)&_ZN5S57C44v112Ev,
  (VTBL_ENTRY)&_ZN5S57C44v113Ev,
  (VTBL_ENTRY)&_ZN5S57C44v114Ev,
  (VTBL_ENTRY)&_ZN5S57C44v115Ev,
  (VTBL_ENTRY)&_ZN5S57C44v116Ev,
  (VTBL_ENTRY)&_ZN5S57C44v117Ev,
  (VTBL_ENTRY)&_ZN5S57C44v118Ev,
  (VTBL_ENTRY)&_ZN5S57C44v119Ev,
  (VTBL_ENTRY)&_ZN5S57C44v120Ev,
  (VTBL_ENTRY)&_ZN5S57C44v121Ev,
  (VTBL_ENTRY)&_ZN5S57C44v122Ev,
  (VTBL_ENTRY)&_ZN5S57C34v123Ev,
  (VTBL_ENTRY)&_ZN5S57C34v124Ev,
  (VTBL_ENTRY)&_ZN5S57C34v125Ev,
  (VTBL_ENTRY)&_ZN5S57C34v126Ev,
  (VTBL_ENTRY)&_ZN5S57C34v127Ev,
  (VTBL_ENTRY)&_ZN5S57C34v128Ev,
  (VTBL_ENTRY)&_ZN5S57C34v129Ev,
  (VTBL_ENTRY)&_ZN5S57C34v130Ev,
  (VTBL_ENTRY)&_ZN5S57C34v131Ev,
  (VTBL_ENTRY)&_ZN5S57C34v132Ev,
  (VTBL_ENTRY)&_ZN5S57C34v133Ev,
  (VTBL_ENTRY)&_ZN5S57C24v134Ev,
  (VTBL_ENTRY)&_ZN5S57C24v135Ev,
};
extern VTBL_ENTRY _ZTI5S57C2[];
extern  VTBL_ENTRY _ZTV5S57C2[];
Class_Descriptor cd_S57C2 = {  "S57C2", // class name
  bases_S57C2, 5,
  &(vtc_S57C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(392,280), // object size
  NSPAIRA(_ZTI5S57C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S57C2),137, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S57C1  : S57C2 {
  int s57c1f0[2];
  virtual  ~S57C1(); // _ZN5S57C1D1Ev
  virtual void  v1(); // _ZN5S57C12v1Ev
  virtual void  v2(); // _ZN5S57C12v2Ev
  S57C1(); // tgen
};
//SIG(1 S57C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC8{ m Fi[2]} Fp[2]} vd v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi[2] Fp Fi[2] FC9{ BC10{ BC11{ BC12{ m Fp Fi[2]}}}} FC9 FC13{ m} FC9 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 Fi:1 Fi:1 Fi:1 FC14{ BC15{ BC12}} FC16{ BC17{ BC12}} FC18{ BC19{ BC12}} FC20{ BC21{ BC12}} Fi[3]} vd v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 Fp[2] Fi[4] Fi:1 Fi:1 Fi:1 Fc Fi Fi:1 FC22{ BC23{ BC12}}} vd v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 Fp[2] FC9 Fi:1 Fi:1 FC24{ m Fp FC8}} vd v134 v135} vd v1 v2 Fi[2]}


 S57C1 ::~S57C1(){ note_dtor("S57C1", this);}
void  S57C1 ::v1(){vfunc_called(this, "_ZN5S57C12v1Ev");}
void  S57C1 ::v2(){vfunc_called(this, "_ZN5S57C12v2Ev");}
S57C1 ::S57C1(){ note_ctor("S57C1", this);} // tgen

static void Test_S57C1()
{
  extern Class_Descriptor cd_S57C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(51,73)];
    init_test(&cd_S57C1, buf);
    S57C1 *dp, &lv = *(dp=new (buf) S57C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(400,288), "sizeof(S57C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S57C1)");
    check_base_class_offset(lv, (S57C7*)(S57C6*)(S57C5*)(S57C4*)(S57C3*)(S57C2*), 0, "S57C1");
    check_base_class_offset(lv, (S57C6*)(S57C5*)(S57C4*)(S57C3*)(S57C2*), 0, "S57C1");
    check_base_class_offset(lv, (S57C5*)(S57C4*)(S57C3*)(S57C2*), 0, "S57C1");
    check_base_class_offset(lv, (S57C4*)(S57C3*)(S57C2*), 0, "S57C1");
    check_base_class_offset(lv, (S57C3*)(S57C2*), 0, "S57C1");
    check_base_class_offset(lv, (S57C2*), 0, "S57C1");
    check_field_offset(lv, s57c1f0, ABISELECT(392,280), "S57C1.s57c1f0");
    test_class_info(&lv, &cd_S57C1);
    dp->~S57C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS57C1(Test_S57C1, "S57C1", ABISELECT(400,288));

#else // __cplusplus

extern void _ZN5S57C1C1Ev();
extern void _ZN5S57C1D1Ev();
Name_Map name_map_S57C1[] = {
  NSPAIR(_ZN5S57C1C1Ev),
  NSPAIR(_ZN5S57C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S57C7;
extern VTBL_ENTRY _ZTI5S57C7[];
extern  VTBL_ENTRY _ZTV5S57C7[];
extern Class_Descriptor cd_S57C6;
extern VTBL_ENTRY _ZTI5S57C6[];
extern  VTBL_ENTRY _ZTV5S57C6[];
extern Class_Descriptor cd_S57C5;
extern VTBL_ENTRY _ZTI5S57C5[];
extern  VTBL_ENTRY _ZTV5S57C5[];
extern Class_Descriptor cd_S57C4;
extern VTBL_ENTRY _ZTI5S57C4[];
extern  VTBL_ENTRY _ZTV5S57C4[];
extern Class_Descriptor cd_S57C3;
extern VTBL_ENTRY _ZTI5S57C3[];
extern  VTBL_ENTRY _ZTV5S57C3[];
extern Class_Descriptor cd_S57C2;
extern VTBL_ENTRY _ZTI5S57C2[];
extern  VTBL_ENTRY _ZTV5S57C2[];
static Base_Class bases_S57C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S57C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S57C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S57C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S57C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S57C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S57C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S57C1[];
extern void _ZN5S57C1D1Ev();
extern void _ZN5S57C1D0Ev();
extern void _ZN5S57C72v3Ev();
extern void _ZN5S57C72v4Ev();
extern void _ZN5S57C72v5Ev();
extern void _ZN5S57C72v6Ev();
extern void _ZN5S57C72v7Ev();
extern void _ZN5S57C72v8Ev();
extern void _ZN5S57C72v9Ev();
extern void _ZN5S57C73v10Ev();
extern void _ZN5S57C73v11Ev();
extern void _ZN5S57C73v12Ev();
extern void _ZN5S57C73v13Ev();
extern void _ZN5S57C73v14Ev();
extern void _ZN5S57C73v15Ev();
extern void _ZN5S57C73v16Ev();
extern void _ZN5S57C73v17Ev();
extern void _ZN5S57C73v18Ev();
extern void _ZN5S57C73v19Ev();
extern void _ZN5S57C73v20Ev();
extern void _ZN5S57C73v21Ev();
extern void _ZN5S57C73v22Ev();
extern void _ZN5S57C73v23Ev();
extern void _ZN5S57C73v24Ev();
extern void _ZN5S57C73v25Ev();
extern void _ZN5S57C73v26Ev();
extern void _ZN5S57C73v27Ev();
extern void _ZN5S57C73v28Ev();
extern void _ZN5S57C73v29Ev();
extern void _ZN5S57C73v30Ev();
extern void _ZN5S57C73v31Ev();
extern void _ZN5S57C73v32Ev();
extern void _ZN5S57C73v33Ev();
extern void _ZN5S57C73v34Ev();
extern void _ZN5S57C73v35Ev();
extern void _ZN5S57C73v36Ev();
extern void _ZN5S57C73v37Ev();
extern void _ZN5S57C73v38Ev();
extern void _ZN5S57C73v39Ev();
extern void _ZN5S57C73v40Ev();
extern void _ZN5S57C73v41Ev();
extern void _ZN5S57C73v42Ev();
extern void _ZN5S57C73v43Ev();
extern void _ZN5S57C73v44Ev();
extern void _ZN5S57C73v45Ev();
extern void _ZN5S57C73v46Ev();
extern void _ZN5S57C73v47Ev();
extern void _ZN5S57C73v48Ev();
extern void _ZN5S57C73v49Ev();
extern void _ZN5S57C73v50Ev();
extern void _ZN5S57C73v51Ev();
extern void _ZN5S57C73v52Ev();
extern void _ZN5S57C73v53Ev();
extern void _ZN5S57C73v54Ev();
extern void _ZN5S57C73v55Ev();
extern void _ZN5S57C73v56Ev();
extern void _ZN5S57C73v57Ev();
extern void _ZN5S57C73v58Ev();
extern void _ZN5S57C73v59Ev();
extern void _ZN5S57C73v60Ev();
extern void _ZN5S57C73v61Ev();
extern void _ZN5S57C73v62Ev();
extern void _ZN5S57C73v63Ev();
extern void _ZN5S57C73v64Ev();
extern void _ZN5S57C73v65Ev();
extern void _ZN5S57C73v66Ev();
extern void _ZN5S57C63v67Ev();
extern void _ZN5S57C63v68Ev();
extern void _ZN5S57C63v69Ev();
extern void _ZN5S57C63v70Ev();
extern void _ZN5S57C63v71Ev();
extern void _ZN5S57C63v72Ev();
extern void _ZN5S57C63v73Ev();
extern void _ZN5S57C63v74Ev();
extern void _ZN5S57C63v75Ev();
extern void _ZN5S57C63v76Ev();
extern void _ZN5S57C63v77Ev();
extern void _ZN5S57C63v78Ev();
extern void _ZN5S57C63v79Ev();
extern void _ZN5S57C63v80Ev();
extern void _ZN5S57C63v81Ev();
extern void _ZN5S57C63v82Ev();
extern void _ZN5S57C63v83Ev();
extern void _ZN5S57C63v84Ev();
extern void _ZN5S57C63v85Ev();
extern void _ZN5S57C63v86Ev();
extern void _ZN5S57C63v87Ev();
extern void _ZN5S57C63v88Ev();
extern void _ZN5S57C53v89Ev();
extern void _ZN5S57C53v90Ev();
extern void _ZN5S57C53v91Ev();
extern void _ZN5S57C53v92Ev();
extern void _ZN5S57C53v93Ev();
extern void _ZN5S57C53v94Ev();
extern void _ZN5S57C53v95Ev();
extern void _ZN5S57C53v96Ev();
extern void _ZN5S57C53v97Ev();
extern void _ZN5S57C53v98Ev();
extern void _ZN5S57C53v99Ev();
extern void _ZN5S57C54v100Ev();
extern void _ZN5S57C54v101Ev();
extern void _ZN5S57C54v102Ev();
extern void _ZN5S57C54v103Ev();
extern void _ZN5S57C54v104Ev();
extern void _ZN5S57C54v105Ev();
extern void _ZN5S57C54v106Ev();
extern void _ZN5S57C54v107Ev();
extern void _ZN5S57C54v108Ev();
extern void _ZN5S57C44v109Ev();
extern void _ZN5S57C44v110Ev();
extern void _ZN5S57C44v111Ev();
extern void _ZN5S57C44v112Ev();
extern void _ZN5S57C44v113Ev();
extern void _ZN5S57C44v114Ev();
extern void _ZN5S57C44v115Ev();
extern void _ZN5S57C44v116Ev();
extern void _ZN5S57C44v117Ev();
extern void _ZN5S57C44v118Ev();
extern void _ZN5S57C44v119Ev();
extern void _ZN5S57C44v120Ev();
extern void _ZN5S57C44v121Ev();
extern void _ZN5S57C44v122Ev();
extern void _ZN5S57C34v123Ev();
extern void _ZN5S57C34v124Ev();
extern void _ZN5S57C34v125Ev();
extern void _ZN5S57C34v126Ev();
extern void _ZN5S57C34v127Ev();
extern void _ZN5S57C34v128Ev();
extern void _ZN5S57C34v129Ev();
extern void _ZN5S57C34v130Ev();
extern void _ZN5S57C34v131Ev();
extern void _ZN5S57C34v132Ev();
extern void _ZN5S57C34v133Ev();
extern void _ZN5S57C24v134Ev();
extern void _ZN5S57C24v135Ev();
extern void _ZN5S57C12v1Ev();
extern void _ZN5S57C12v2Ev();
static  VTBL_ENTRY vtc_S57C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S57C1[0]),
  (VTBL_ENTRY)&_ZN5S57C1D1Ev,
  (VTBL_ENTRY)&_ZN5S57C1D0Ev,
  (VTBL_ENTRY)&_ZN5S57C72v3Ev,
  (VTBL_ENTRY)&_ZN5S57C72v4Ev,
  (VTBL_ENTRY)&_ZN5S57C72v5Ev,
  (VTBL_ENTRY)&_ZN5S57C72v6Ev,
  (VTBL_ENTRY)&_ZN5S57C72v7Ev,
  (VTBL_ENTRY)&_ZN5S57C72v8Ev,
  (VTBL_ENTRY)&_ZN5S57C72v9Ev,
  (VTBL_ENTRY)&_ZN5S57C73v10Ev,
  (VTBL_ENTRY)&_ZN5S57C73v11Ev,
  (VTBL_ENTRY)&_ZN5S57C73v12Ev,
  (VTBL_ENTRY)&_ZN5S57C73v13Ev,
  (VTBL_ENTRY)&_ZN5S57C73v14Ev,
  (VTBL_ENTRY)&_ZN5S57C73v15Ev,
  (VTBL_ENTRY)&_ZN5S57C73v16Ev,
  (VTBL_ENTRY)&_ZN5S57C73v17Ev,
  (VTBL_ENTRY)&_ZN5S57C73v18Ev,
  (VTBL_ENTRY)&_ZN5S57C73v19Ev,
  (VTBL_ENTRY)&_ZN5S57C73v20Ev,
  (VTBL_ENTRY)&_ZN5S57C73v21Ev,
  (VTBL_ENTRY)&_ZN5S57C73v22Ev,
  (VTBL_ENTRY)&_ZN5S57C73v23Ev,
  (VTBL_ENTRY)&_ZN5S57C73v24Ev,
  (VTBL_ENTRY)&_ZN5S57C73v25Ev,
  (VTBL_ENTRY)&_ZN5S57C73v26Ev,
  (VTBL_ENTRY)&_ZN5S57C73v27Ev,
  (VTBL_ENTRY)&_ZN5S57C73v28Ev,
  (VTBL_ENTRY)&_ZN5S57C73v29Ev,
  (VTBL_ENTRY)&_ZN5S57C73v30Ev,
  (VTBL_ENTRY)&_ZN5S57C73v31Ev,
  (VTBL_ENTRY)&_ZN5S57C73v32Ev,
  (VTBL_ENTRY)&_ZN5S57C73v33Ev,
  (VTBL_ENTRY)&_ZN5S57C73v34Ev,
  (VTBL_ENTRY)&_ZN5S57C73v35Ev,
  (VTBL_ENTRY)&_ZN5S57C73v36Ev,
  (VTBL_ENTRY)&_ZN5S57C73v37Ev,
  (VTBL_ENTRY)&_ZN5S57C73v38Ev,
  (VTBL_ENTRY)&_ZN5S57C73v39Ev,
  (VTBL_ENTRY)&_ZN5S57C73v40Ev,
  (VTBL_ENTRY)&_ZN5S57C73v41Ev,
  (VTBL_ENTRY)&_ZN5S57C73v42Ev,
  (VTBL_ENTRY)&_ZN5S57C73v43Ev,
  (VTBL_ENTRY)&_ZN5S57C73v44Ev,
  (VTBL_ENTRY)&_ZN5S57C73v45Ev,
  (VTBL_ENTRY)&_ZN5S57C73v46Ev,
  (VTBL_ENTRY)&_ZN5S57C73v47Ev,
  (VTBL_ENTRY)&_ZN5S57C73v48Ev,
  (VTBL_ENTRY)&_ZN5S57C73v49Ev,
  (VTBL_ENTRY)&_ZN5S57C73v50Ev,
  (VTBL_ENTRY)&_ZN5S57C73v51Ev,
  (VTBL_ENTRY)&_ZN5S57C73v52Ev,
  (VTBL_ENTRY)&_ZN5S57C73v53Ev,
  (VTBL_ENTRY)&_ZN5S57C73v54Ev,
  (VTBL_ENTRY)&_ZN5S57C73v55Ev,
  (VTBL_ENTRY)&_ZN5S57C73v56Ev,
  (VTBL_ENTRY)&_ZN5S57C73v57Ev,
  (VTBL_ENTRY)&_ZN5S57C73v58Ev,
  (VTBL_ENTRY)&_ZN5S57C73v59Ev,
  (VTBL_ENTRY)&_ZN5S57C73v60Ev,
  (VTBL_ENTRY)&_ZN5S57C73v61Ev,
  (VTBL_ENTRY)&_ZN5S57C73v62Ev,
  (VTBL_ENTRY)&_ZN5S57C73v63Ev,
  (VTBL_ENTRY)&_ZN5S57C73v64Ev,
  (VTBL_ENTRY)&_ZN5S57C73v65Ev,
  (VTBL_ENTRY)&_ZN5S57C73v66Ev,
  (VTBL_ENTRY)&_ZN5S57C63v67Ev,
  (VTBL_ENTRY)&_ZN5S57C63v68Ev,
  (VTBL_ENTRY)&_ZN5S57C63v69Ev,
  (VTBL_ENTRY)&_ZN5S57C63v70Ev,
  (VTBL_ENTRY)&_ZN5S57C63v71Ev,
  (VTBL_ENTRY)&_ZN5S57C63v72Ev,
  (VTBL_ENTRY)&_ZN5S57C63v73Ev,
  (VTBL_ENTRY)&_ZN5S57C63v74Ev,
  (VTBL_ENTRY)&_ZN5S57C63v75Ev,
  (VTBL_ENTRY)&_ZN5S57C63v76Ev,
  (VTBL_ENTRY)&_ZN5S57C63v77Ev,
  (VTBL_ENTRY)&_ZN5S57C63v78Ev,
  (VTBL_ENTRY)&_ZN5S57C63v79Ev,
  (VTBL_ENTRY)&_ZN5S57C63v80Ev,
  (VTBL_ENTRY)&_ZN5S57C63v81Ev,
  (VTBL_ENTRY)&_ZN5S57C63v82Ev,
  (VTBL_ENTRY)&_ZN5S57C63v83Ev,
  (VTBL_ENTRY)&_ZN5S57C63v84Ev,
  (VTBL_ENTRY)&_ZN5S57C63v85Ev,
  (VTBL_ENTRY)&_ZN5S57C63v86Ev,
  (VTBL_ENTRY)&_ZN5S57C63v87Ev,
  (VTBL_ENTRY)&_ZN5S57C63v88Ev,
  (VTBL_ENTRY)&_ZN5S57C53v89Ev,
  (VTBL_ENTRY)&_ZN5S57C53v90Ev,
  (VTBL_ENTRY)&_ZN5S57C53v91Ev,
  (VTBL_ENTRY)&_ZN5S57C53v92Ev,
  (VTBL_ENTRY)&_ZN5S57C53v93Ev,
  (VTBL_ENTRY)&_ZN5S57C53v94Ev,
  (VTBL_ENTRY)&_ZN5S57C53v95Ev,
  (VTBL_ENTRY)&_ZN5S57C53v96Ev,
  (VTBL_ENTRY)&_ZN5S57C53v97Ev,
  (VTBL_ENTRY)&_ZN5S57C53v98Ev,
  (VTBL_ENTRY)&_ZN5S57C53v99Ev,
  (VTBL_ENTRY)&_ZN5S57C54v100Ev,
  (VTBL_ENTRY)&_ZN5S57C54v101Ev,
  (VTBL_ENTRY)&_ZN5S57C54v102Ev,
  (VTBL_ENTRY)&_ZN5S57C54v103Ev,
  (VTBL_ENTRY)&_ZN5S57C54v104Ev,
  (VTBL_ENTRY)&_ZN5S57C54v105Ev,
  (VTBL_ENTRY)&_ZN5S57C54v106Ev,
  (VTBL_ENTRY)&_ZN5S57C54v107Ev,
  (VTBL_ENTRY)&_ZN5S57C54v108Ev,
  (VTBL_ENTRY)&_ZN5S57C44v109Ev,
  (VTBL_ENTRY)&_ZN5S57C44v110Ev,
  (VTBL_ENTRY)&_ZN5S57C44v111Ev,
  (VTBL_ENTRY)&_ZN5S57C44v112Ev,
  (VTBL_ENTRY)&_ZN5S57C44v113Ev,
  (VTBL_ENTRY)&_ZN5S57C44v114Ev,
  (VTBL_ENTRY)&_ZN5S57C44v115Ev,
  (VTBL_ENTRY)&_ZN5S57C44v116Ev,
  (VTBL_ENTRY)&_ZN5S57C44v117Ev,
  (VTBL_ENTRY)&_ZN5S57C44v118Ev,
  (VTBL_ENTRY)&_ZN5S57C44v119Ev,
  (VTBL_ENTRY)&_ZN5S57C44v120Ev,
  (VTBL_ENTRY)&_ZN5S57C44v121Ev,
  (VTBL_ENTRY)&_ZN5S57C44v122Ev,
  (VTBL_ENTRY)&_ZN5S57C34v123Ev,
  (VTBL_ENTRY)&_ZN5S57C34v124Ev,
  (VTBL_ENTRY)&_ZN5S57C34v125Ev,
  (VTBL_ENTRY)&_ZN5S57C34v126Ev,
  (VTBL_ENTRY)&_ZN5S57C34v127Ev,
  (VTBL_ENTRY)&_ZN5S57C34v128Ev,
  (VTBL_ENTRY)&_ZN5S57C34v129Ev,
  (VTBL_ENTRY)&_ZN5S57C34v130Ev,
  (VTBL_ENTRY)&_ZN5S57C34v131Ev,
  (VTBL_ENTRY)&_ZN5S57C34v132Ev,
  (VTBL_ENTRY)&_ZN5S57C34v133Ev,
  (VTBL_ENTRY)&_ZN5S57C24v134Ev,
  (VTBL_ENTRY)&_ZN5S57C24v135Ev,
  (VTBL_ENTRY)&_ZN5S57C12v1Ev,
  (VTBL_ENTRY)&_ZN5S57C12v2Ev,
};
extern VTBL_ENTRY _ZTI5S57C1[];
extern  VTBL_ENTRY _ZTV5S57C1[];
Class_Descriptor cd_S57C1 = {  "S57C1", // class name
  bases_S57C1, 6,
  &(vtc_S57C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(400,288), // object size
  NSPAIRA(_ZTI5S57C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S57C1),139, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S55C7  {
  int s55c7f0;
  __tsi64 s55c7f1;
  void *s55c7f2[4];
  int s55c7f3[2];
  void *s55c7f4;
  ::S3350C4_nt s55c7f5;
  void *s55c7f6[2];
  virtual  ~S55C7(); // _ZN5S55C7D1Ev
  virtual void  v3(); // _ZN5S55C72v3Ev
  virtual void  v4(); // _ZN5S55C72v4Ev
  virtual void  v5(); // _ZN5S55C72v5Ev
  virtual void  v6(); // _ZN5S55C72v6Ev
  virtual void  v7(); // _ZN5S55C72v7Ev
  virtual void  v8(); // _ZN5S55C72v8Ev
  virtual void  v9(); // _ZN5S55C72v9Ev
  virtual void  v10(); // _ZN5S55C73v10Ev
  virtual void  v11(); // _ZN5S55C73v11Ev
  virtual void  v12(); // _ZN5S55C73v12Ev
  virtual void  v13(); // _ZN5S55C73v13Ev
  virtual void  v14(); // _ZN5S55C73v14Ev
  virtual void  v15(); // _ZN5S55C73v15Ev
  virtual void  v16(); // _ZN5S55C73v16Ev
  virtual void  v17(); // _ZN5S55C73v17Ev
  virtual void  v18(); // _ZN5S55C73v18Ev
  virtual void  v19(); // _ZN5S55C73v19Ev
  virtual void  v20(); // _ZN5S55C73v20Ev
  virtual void  v21(); // _ZN5S55C73v21Ev
  virtual void  v22(); // _ZN5S55C73v22Ev
  virtual void  v23(); // _ZN5S55C73v23Ev
  virtual void  v24(); // _ZN5S55C73v24Ev
  virtual void  v25(); // _ZN5S55C73v25Ev
  virtual void  v26(); // _ZN5S55C73v26Ev
  virtual void  v27(); // _ZN5S55C73v27Ev
  virtual void  v28(); // _ZN5S55C73v28Ev
  virtual void  v29(); // _ZN5S55C73v29Ev
  virtual void  v30(); // _ZN5S55C73v30Ev
  virtual void  v31(); // _ZN5S55C73v31Ev
  virtual void  v32(); // _ZN5S55C73v32Ev
  virtual void  v33(); // _ZN5S55C73v33Ev
  virtual void  v34(); // _ZN5S55C73v34Ev
  virtual void  v35(); // _ZN5S55C73v35Ev
  virtual void  v36(); // _ZN5S55C73v36Ev
  virtual void  v37(); // _ZN5S55C73v37Ev
  virtual void  v38(); // _ZN5S55C73v38Ev
  virtual void  v39(); // _ZN5S55C73v39Ev
  virtual void  v40(); // _ZN5S55C73v40Ev
  virtual void  v41(); // _ZN5S55C73v41Ev
  virtual void  v42(); // _ZN5S55C73v42Ev
  virtual void  v43(); // _ZN5S55C73v43Ev
  virtual void  v44(); // _ZN5S55C73v44Ev
  virtual void  v45(); // _ZN5S55C73v45Ev
  virtual void  v46(); // _ZN5S55C73v46Ev
  virtual void  v47(); // _ZN5S55C73v47Ev
  virtual void  v48(); // _ZN5S55C73v48Ev
  virtual void  v49(); // _ZN5S55C73v49Ev
  virtual void  v50(); // _ZN5S55C73v50Ev
  virtual void  v51(); // _ZN5S55C73v51Ev
  virtual void  v52(); // _ZN5S55C73v52Ev
  virtual void  v53(); // _ZN5S55C73v53Ev
  virtual void  v54(); // _ZN5S55C73v54Ev
  virtual void  v55(); // _ZN5S55C73v55Ev
  virtual void  v56(); // _ZN5S55C73v56Ev
  virtual void  v57(); // _ZN5S55C73v57Ev
  virtual void  v58(); // _ZN5S55C73v58Ev
  virtual void  v59(); // _ZN5S55C73v59Ev
  virtual void  v60(); // _ZN5S55C73v60Ev
  virtual void  v61(); // _ZN5S55C73v61Ev
  virtual void  v62(); // _ZN5S55C73v62Ev
  virtual void  v63(); // _ZN5S55C73v63Ev
  virtual void  v64(); // _ZN5S55C73v64Ev
  virtual void  v65(); // _ZN5S55C73v65Ev
  virtual void  v66(); // _ZN5S55C73v66Ev
  S55C7(); // tgen
};
//SIG(-1 S55C7) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S55C7 ::~S55C7(){ note_dtor("S55C7", this);}
void  S55C7 ::v3(){vfunc_called(this, "_ZN5S55C72v3Ev");}
void  S55C7 ::v4(){vfunc_called(this, "_ZN5S55C72v4Ev");}
void  S55C7 ::v5(){vfunc_called(this, "_ZN5S55C72v5Ev");}
void  S55C7 ::v6(){vfunc_called(this, "_ZN5S55C72v6Ev");}
void  S55C7 ::v7(){vfunc_called(this, "_ZN5S55C72v7Ev");}
void  S55C7 ::v8(){vfunc_called(this, "_ZN5S55C72v8Ev");}
void  S55C7 ::v9(){vfunc_called(this, "_ZN5S55C72v9Ev");}
void  S55C7 ::v10(){vfunc_called(this, "_ZN5S55C73v10Ev");}
void  S55C7 ::v11(){vfunc_called(this, "_ZN5S55C73v11Ev");}
void  S55C7 ::v12(){vfunc_called(this, "_ZN5S55C73v12Ev");}
void  S55C7 ::v13(){vfunc_called(this, "_ZN5S55C73v13Ev");}
void  S55C7 ::v14(){vfunc_called(this, "_ZN5S55C73v14Ev");}
void  S55C7 ::v15(){vfunc_called(this, "_ZN5S55C73v15Ev");}
void  S55C7 ::v16(){vfunc_called(this, "_ZN5S55C73v16Ev");}
void  S55C7 ::v17(){vfunc_called(this, "_ZN5S55C73v17Ev");}
void  S55C7 ::v18(){vfunc_called(this, "_ZN5S55C73v18Ev");}
void  S55C7 ::v19(){vfunc_called(this, "_ZN5S55C73v19Ev");}
void  S55C7 ::v20(){vfunc_called(this, "_ZN5S55C73v20Ev");}
void  S55C7 ::v21(){vfunc_called(this, "_ZN5S55C73v21Ev");}
void  S55C7 ::v22(){vfunc_called(this, "_ZN5S55C73v22Ev");}
void  S55C7 ::v23(){vfunc_called(this, "_ZN5S55C73v23Ev");}
void  S55C7 ::v24(){vfunc_called(this, "_ZN5S55C73v24Ev");}
void  S55C7 ::v25(){vfunc_called(this, "_ZN5S55C73v25Ev");}
void  S55C7 ::v26(){vfunc_called(this, "_ZN5S55C73v26Ev");}
void  S55C7 ::v27(){vfunc_called(this, "_ZN5S55C73v27Ev");}
void  S55C7 ::v28(){vfunc_called(this, "_ZN5S55C73v28Ev");}
void  S55C7 ::v29(){vfunc_called(this, "_ZN5S55C73v29Ev");}
void  S55C7 ::v30(){vfunc_called(this, "_ZN5S55C73v30Ev");}
void  S55C7 ::v31(){vfunc_called(this, "_ZN5S55C73v31Ev");}
void  S55C7 ::v32(){vfunc_called(this, "_ZN5S55C73v32Ev");}
void  S55C7 ::v33(){vfunc_called(this, "_ZN5S55C73v33Ev");}
void  S55C7 ::v34(){vfunc_called(this, "_ZN5S55C73v34Ev");}
void  S55C7 ::v35(){vfunc_called(this, "_ZN5S55C73v35Ev");}
void  S55C7 ::v36(){vfunc_called(this, "_ZN5S55C73v36Ev");}
void  S55C7 ::v37(){vfunc_called(this, "_ZN5S55C73v37Ev");}
void  S55C7 ::v38(){vfunc_called(this, "_ZN5S55C73v38Ev");}
void  S55C7 ::v39(){vfunc_called(this, "_ZN5S55C73v39Ev");}
void  S55C7 ::v40(){vfunc_called(this, "_ZN5S55C73v40Ev");}
void  S55C7 ::v41(){vfunc_called(this, "_ZN5S55C73v41Ev");}
void  S55C7 ::v42(){vfunc_called(this, "_ZN5S55C73v42Ev");}
void  S55C7 ::v43(){vfunc_called(this, "_ZN5S55C73v43Ev");}
void  S55C7 ::v44(){vfunc_called(this, "_ZN5S55C73v44Ev");}
void  S55C7 ::v45(){vfunc_called(this, "_ZN5S55C73v45Ev");}
void  S55C7 ::v46(){vfunc_called(this, "_ZN5S55C73v46Ev");}
void  S55C7 ::v47(){vfunc_called(this, "_ZN5S55C73v47Ev");}
void  S55C7 ::v48(){vfunc_called(this, "_ZN5S55C73v48Ev");}
void  S55C7 ::v49(){vfunc_called(this, "_ZN5S55C73v49Ev");}
void  S55C7 ::v50(){vfunc_called(this, "_ZN5S55C73v50Ev");}
void  S55C7 ::v51(){vfunc_called(this, "_ZN5S55C73v51Ev");}
void  S55C7 ::v52(){vfunc_called(this, "_ZN5S55C73v52Ev");}
void  S55C7 ::v53(){vfunc_called(this, "_ZN5S55C73v53Ev");}
void  S55C7 ::v54(){vfunc_called(this, "_ZN5S55C73v54Ev");}
void  S55C7 ::v55(){vfunc_called(this, "_ZN5S55C73v55Ev");}
void  S55C7 ::v56(){vfunc_called(this, "_ZN5S55C73v56Ev");}
void  S55C7 ::v57(){vfunc_called(this, "_ZN5S55C73v57Ev");}
void  S55C7 ::v58(){vfunc_called(this, "_ZN5S55C73v58Ev");}
void  S55C7 ::v59(){vfunc_called(this, "_ZN5S55C73v59Ev");}
void  S55C7 ::v60(){vfunc_called(this, "_ZN5S55C73v60Ev");}
void  S55C7 ::v61(){vfunc_called(this, "_ZN5S55C73v61Ev");}
void  S55C7 ::v62(){vfunc_called(this, "_ZN5S55C73v62Ev");}
void  S55C7 ::v63(){vfunc_called(this, "_ZN5S55C73v63Ev");}
void  S55C7 ::v64(){vfunc_called(this, "_ZN5S55C73v64Ev");}
void  S55C7 ::v65(){vfunc_called(this, "_ZN5S55C73v65Ev");}
void  S55C7 ::v66(){vfunc_called(this, "_ZN5S55C73v66Ev");}
S55C7 ::S55C7(){ note_ctor("S55C7", this);} // tgen

static void Test_S55C7()
{
  extern Class_Descriptor cd_S55C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S55C7, buf);
    S55C7 *dp, &lv = *(dp=new (buf) S55C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S55C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S55C7)");
    check_field_offset(lv, s55c7f0, ABISELECT(8,4), "S55C7.s55c7f0");
    check_field_offset(lv, s55c7f1, ABISELECT(16,8), "S55C7.s55c7f1");
    check_field_offset(lv, s55c7f2, ABISELECT(24,16), "S55C7.s55c7f2");
    check_field_offset(lv, s55c7f3, ABISELECT(56,32), "S55C7.s55c7f3");
    check_field_offset(lv, s55c7f4, ABISELECT(64,40), "S55C7.s55c7f4");
    check_field_offset(lv, s55c7f5, ABISELECT(72,44), "S55C7.s55c7f5");
    check_field_offset(lv, s55c7f6, ABISELECT(80,52), "S55C7.s55c7f6");
    test_class_info(&lv, &cd_S55C7);
    dp->~S55C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS55C7(Test_S55C7, "S55C7", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN5S55C7C1Ev();
extern void _ZN5S55C7D1Ev();
Name_Map name_map_S55C7[] = {
  NSPAIR(_ZN5S55C7C1Ev),
  NSPAIR(_ZN5S55C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI5S55C7[];
extern void _ZN5S55C7D1Ev();
extern void _ZN5S55C7D0Ev();
extern void _ZN5S55C72v3Ev();
extern void _ZN5S55C72v4Ev();
extern void _ZN5S55C72v5Ev();
extern void _ZN5S55C72v6Ev();
extern void _ZN5S55C72v7Ev();
extern void _ZN5S55C72v8Ev();
extern void _ZN5S55C72v9Ev();
extern void _ZN5S55C73v10Ev();
extern void _ZN5S55C73v11Ev();
extern void _ZN5S55C73v12Ev();
extern void _ZN5S55C73v13Ev();
extern void _ZN5S55C73v14Ev();
extern void _ZN5S55C73v15Ev();
extern void _ZN5S55C73v16Ev();
extern void _ZN5S55C73v17Ev();
extern void _ZN5S55C73v18Ev();
extern void _ZN5S55C73v19Ev();
extern void _ZN5S55C73v20Ev();
extern void _ZN5S55C73v21Ev();
extern void _ZN5S55C73v22Ev();
extern void _ZN5S55C73v23Ev();
extern void _ZN5S55C73v24Ev();
extern void _ZN5S55C73v25Ev();
extern void _ZN5S55C73v26Ev();
extern void _ZN5S55C73v27Ev();
extern void _ZN5S55C73v28Ev();
extern void _ZN5S55C73v29Ev();
extern void _ZN5S55C73v30Ev();
extern void _ZN5S55C73v31Ev();
extern void _ZN5S55C73v32Ev();
extern void _ZN5S55C73v33Ev();
extern void _ZN5S55C73v34Ev();
extern void _ZN5S55C73v35Ev();
extern void _ZN5S55C73v36Ev();
extern void _ZN5S55C73v37Ev();
extern void _ZN5S55C73v38Ev();
extern void _ZN5S55C73v39Ev();
extern void _ZN5S55C73v40Ev();
extern void _ZN5S55C73v41Ev();
extern void _ZN5S55C73v42Ev();
extern void _ZN5S55C73v43Ev();
extern void _ZN5S55C73v44Ev();
extern void _ZN5S55C73v45Ev();
extern void _ZN5S55C73v46Ev();
extern void _ZN5S55C73v47Ev();
extern void _ZN5S55C73v48Ev();
extern void _ZN5S55C73v49Ev();
extern void _ZN5S55C73v50Ev();
extern void _ZN5S55C73v51Ev();
extern void _ZN5S55C73v52Ev();
extern void _ZN5S55C73v53Ev();
extern void _ZN5S55C73v54Ev();
extern void _ZN5S55C73v55Ev();
extern void _ZN5S55C73v56Ev();
extern void _ZN5S55C73v57Ev();
extern void _ZN5S55C73v58Ev();
extern void _ZN5S55C73v59Ev();
extern void _ZN5S55C73v60Ev();
extern void _ZN5S55C73v61Ev();
extern void _ZN5S55C73v62Ev();
extern void _ZN5S55C73v63Ev();
extern void _ZN5S55C73v64Ev();
extern void _ZN5S55C73v65Ev();
extern void _ZN5S55C73v66Ev();
static  VTBL_ENTRY vtc_S55C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S55C7[0]),
  (VTBL_ENTRY)&_ZN5S55C7D1Ev,
  (VTBL_ENTRY)&_ZN5S55C7D0Ev,
  (VTBL_ENTRY)&_ZN5S55C72v3Ev,
  (VTBL_ENTRY)&_ZN5S55C72v4Ev,
  (VTBL_ENTRY)&_ZN5S55C72v5Ev,
  (VTBL_ENTRY)&_ZN5S55C72v6Ev,
  (VTBL_ENTRY)&_ZN5S55C72v7Ev,
  (VTBL_ENTRY)&_ZN5S55C72v8Ev,
  (VTBL_ENTRY)&_ZN5S55C72v9Ev,
  (VTBL_ENTRY)&_ZN5S55C73v10Ev,
  (VTBL_ENTRY)&_ZN5S55C73v11Ev,
  (VTBL_ENTRY)&_ZN5S55C73v12Ev,
  (VTBL_ENTRY)&_ZN5S55C73v13Ev,
  (VTBL_ENTRY)&_ZN5S55C73v14Ev,
  (VTBL_ENTRY)&_ZN5S55C73v15Ev,
  (VTBL_ENTRY)&_ZN5S55C73v16Ev,
  (VTBL_ENTRY)&_ZN5S55C73v17Ev,
  (VTBL_ENTRY)&_ZN5S55C73v18Ev,
  (VTBL_ENTRY)&_ZN5S55C73v19Ev,
  (VTBL_ENTRY)&_ZN5S55C73v20Ev,
  (VTBL_ENTRY)&_ZN5S55C73v21Ev,
  (VTBL_ENTRY)&_ZN5S55C73v22Ev,
  (VTBL_ENTRY)&_ZN5S55C73v23Ev,
  (VTBL_ENTRY)&_ZN5S55C73v24Ev,
  (VTBL_ENTRY)&_ZN5S55C73v25Ev,
  (VTBL_ENTRY)&_ZN5S55C73v26Ev,
  (VTBL_ENTRY)&_ZN5S55C73v27Ev,
  (VTBL_ENTRY)&_ZN5S55C73v28Ev,
  (VTBL_ENTRY)&_ZN5S55C73v29Ev,
  (VTBL_ENTRY)&_ZN5S55C73v30Ev,
  (VTBL_ENTRY)&_ZN5S55C73v31Ev,
  (VTBL_ENTRY)&_ZN5S55C73v32Ev,
  (VTBL_ENTRY)&_ZN5S55C73v33Ev,
  (VTBL_ENTRY)&_ZN5S55C73v34Ev,
  (VTBL_ENTRY)&_ZN5S55C73v35Ev,
  (VTBL_ENTRY)&_ZN5S55C73v36Ev,
  (VTBL_ENTRY)&_ZN5S55C73v37Ev,
  (VTBL_ENTRY)&_ZN5S55C73v38Ev,
  (VTBL_ENTRY)&_ZN5S55C73v39Ev,
  (VTBL_ENTRY)&_ZN5S55C73v40Ev,
  (VTBL_ENTRY)&_ZN5S55C73v41Ev,
  (VTBL_ENTRY)&_ZN5S55C73v42Ev,
  (VTBL_ENTRY)&_ZN5S55C73v43Ev,
  (VTBL_ENTRY)&_ZN5S55C73v44Ev,
  (VTBL_ENTRY)&_ZN5S55C73v45Ev,
  (VTBL_ENTRY)&_ZN5S55C73v46Ev,
  (VTBL_ENTRY)&_ZN5S55C73v47Ev,
  (VTBL_ENTRY)&_ZN5S55C73v48Ev,
  (VTBL_ENTRY)&_ZN5S55C73v49Ev,
  (VTBL_ENTRY)&_ZN5S55C73v50Ev,
  (VTBL_ENTRY)&_ZN5S55C73v51Ev,
  (VTBL_ENTRY)&_ZN5S55C73v52Ev,
  (VTBL_ENTRY)&_ZN5S55C73v53Ev,
  (VTBL_ENTRY)&_ZN5S55C73v54Ev,
  (VTBL_ENTRY)&_ZN5S55C73v55Ev,
  (VTBL_ENTRY)&_ZN5S55C73v56Ev,
  (VTBL_ENTRY)&_ZN5S55C73v57Ev,
  (VTBL_ENTRY)&_ZN5S55C73v58Ev,
  (VTBL_ENTRY)&_ZN5S55C73v59Ev,
  (VTBL_ENTRY)&_ZN5S55C73v60Ev,
  (VTBL_ENTRY)&_ZN5S55C73v61Ev,
  (VTBL_ENTRY)&_ZN5S55C73v62Ev,
  (VTBL_ENTRY)&_ZN5S55C73v63Ev,
  (VTBL_ENTRY)&_ZN5S55C73v64Ev,
  (VTBL_ENTRY)&_ZN5S55C73v65Ev,
  (VTBL_ENTRY)&_ZN5S55C73v66Ev,
};
extern VTBL_ENTRY _ZTI5S55C7[];
extern  VTBL_ENTRY _ZTV5S55C7[];
Class_Descriptor cd_S55C7 = {  "S55C7", // class name
  0,0,//no base classes
  &(vtc_S55C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI5S55C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV5S55C7),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S55C6  : S55C7 {
  int s55c6f0[2];
  void *s55c6f1;
  int s55c6f2[2];
  ::S287C8_nt s55c6f3;
  ::S287C8_nt s55c6f4;
  ::S2121C38 s55c6f5;
  ::S287C8_nt s55c6f6;
  unsigned int s55c6f7:1;
  unsigned int s55c6f8:1;
  unsigned int s55c6f9:1;
  unsigned int s55c6f10:1;
  unsigned int s55c6f11:1;
  int s55c6f12[2];
  virtual  ~S55C6(); // _ZN5S55C6D1Ev
  virtual void  v67(); // _ZN5S55C63v67Ev
  virtual void  v68(); // _ZN5S55C63v68Ev
  virtual void  v69(); // _ZN5S55C63v69Ev
  virtual void  v70(); // _ZN5S55C63v70Ev
  virtual void  v71(); // _ZN5S55C63v71Ev
  virtual void  v72(); // _ZN5S55C63v72Ev
  virtual void  v73(); // _ZN5S55C63v73Ev
  virtual void  v74(); // _ZN5S55C63v74Ev
  virtual void  v75(); // _ZN5S55C63v75Ev
  virtual void  v76(); // _ZN5S55C63v76Ev
  virtual void  v77(); // _ZN5S55C63v77Ev
  virtual void  v78(); // _ZN5S55C63v78Ev
  virtual void  v79(); // _ZN5S55C63v79Ev
  virtual void  v80(); // _ZN5S55C63v80Ev
  virtual void  v81(); // _ZN5S55C63v81Ev
  virtual void  v82(); // _ZN5S55C63v82Ev
  virtual void  v83(); // _ZN5S55C63v83Ev
  virtual void  v84(); // _ZN5S55C63v84Ev
  virtual void  v85(); // _ZN5S55C63v85Ev
  virtual void  v86(); // _ZN5S55C63v86Ev
  virtual void  v87(); // _ZN5S55C63v87Ev
  virtual void  v88(); // _ZN5S55C63v88Ev
  S55C6(); // tgen
};
//SIG(-1 S55C6) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S55C6 ::~S55C6(){ note_dtor("S55C6", this);}
void  S55C6 ::v67(){vfunc_called(this, "_ZN5S55C63v67Ev");}
void  S55C6 ::v68(){vfunc_called(this, "_ZN5S55C63v68Ev");}
void  S55C6 ::v69(){vfunc_called(this, "_ZN5S55C63v69Ev");}
void  S55C6 ::v70(){vfunc_called(this, "_ZN5S55C63v70Ev");}
void  S55C6 ::v71(){vfunc_called(this, "_ZN5S55C63v71Ev");}
void  S55C6 ::v72(){vfunc_called(this, "_ZN5S55C63v72Ev");}
void  S55C6 ::v73(){vfunc_called(this, "_ZN5S55C63v73Ev");}
void  S55C6 ::v74(){vfunc_called(this, "_ZN5S55C63v74Ev");}
void  S55C6 ::v75(){vfunc_called(this, "_ZN5S55C63v75Ev");}
void  S55C6 ::v76(){vfunc_called(this, "_ZN5S55C63v76Ev");}
void  S55C6 ::v77(){vfunc_called(this, "_ZN5S55C63v77Ev");}
void  S55C6 ::v78(){vfunc_called(this, "_ZN5S55C63v78Ev");}
void  S55C6 ::v79(){vfunc_called(this, "_ZN5S55C63v79Ev");}
void  S55C6 ::v80(){vfunc_called(this, "_ZN5S55C63v80Ev");}
void  S55C6 ::v81(){vfunc_called(this, "_ZN5S55C63v81Ev");}
void  S55C6 ::v82(){vfunc_called(this, "_ZN5S55C63v82Ev");}
void  S55C6 ::v83(){vfunc_called(this, "_ZN5S55C63v83Ev");}
void  S55C6 ::v84(){vfunc_called(this, "_ZN5S55C63v84Ev");}
void  S55C6 ::v85(){vfunc_called(this, "_ZN5S55C63v85Ev");}
void  S55C6 ::v86(){vfunc_called(this, "_ZN5S55C63v86Ev");}
void  S55C6 ::v87(){vfunc_called(this, "_ZN5S55C63v87Ev");}
void  S55C6 ::v88(){vfunc_called(this, "_ZN5S55C63v88Ev");}
S55C6 ::S55C6(){ note_ctor("S55C6", this);} // tgen

static void Test_S55C6()
{
  extern Class_Descriptor cd_S55C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S55C6, buf);
    S55C6 *dp, &lv = *(dp=new (buf) S55C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S55C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S55C6)");
    check_base_class_offset(lv, (S55C7*), 0, "S55C6");
    check_field_offset(lv, s55c6f0, ABISELECT(96,60), "S55C6.s55c6f0");
    check_field_offset(lv, s55c6f1, ABISELECT(104,68), "S55C6.s55c6f1");
    check_field_offset(lv, s55c6f2, ABISELECT(112,72), "S55C6.s55c6f2");
    check_field_offset(lv, s55c6f3, ABISELECT(120,80), "S55C6.s55c6f3");
    check_field_offset(lv, s55c6f4, ABISELECT(136,92), "S55C6.s55c6f4");
    check_field_offset(lv, s55c6f5, ABISELECT(152,104), "S55C6.s55c6f5");
    check_field_offset(lv, s55c6f6, ABISELECT(160,108), "S55C6.s55c6f6");
    set_bf_and_test(lv, s55c6f7, ABISELECT(176,120), 0, 1, 1, "S55C6");
    set_bf_and_test(lv, s55c6f8, ABISELECT(176,120), 1, 1, 1, "S55C6");
    set_bf_and_test(lv, s55c6f9, ABISELECT(176,120), 2, 1, 1, "S55C6");
    set_bf_and_test(lv, s55c6f10, ABISELECT(176,120), 3, 1, 1, "S55C6");
    set_bf_and_test(lv, s55c6f11, ABISELECT(176,120), 4, 1, 1, "S55C6");
    check_field_offset(lv, s55c6f12, ABISELECT(180,124), "S55C6.s55c6f12");
    test_class_info(&lv, &cd_S55C6);
    dp->~S55C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS55C6(Test_S55C6, "S55C6", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN5S55C6C1Ev();
extern void _ZN5S55C6D1Ev();
Name_Map name_map_S55C6[] = {
  NSPAIR(_ZN5S55C6C1Ev),
  NSPAIR(_ZN5S55C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S55C7;
extern VTBL_ENTRY _ZTI5S55C7[];
extern  VTBL_ENTRY _ZTV5S55C7[];
static Base_Class bases_S55C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S55C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S55C6[];
extern void _ZN5S55C6D1Ev();
extern void _ZN5S55C6D0Ev();
extern void _ZN5S55C72v3Ev();
extern void _ZN5S55C72v4Ev();
extern void _ZN5S55C72v5Ev();
extern void _ZN5S55C72v6Ev();
extern void _ZN5S55C72v7Ev();
extern void _ZN5S55C72v8Ev();
extern void _ZN5S55C72v9Ev();
extern void _ZN5S55C73v10Ev();
extern void _ZN5S55C73v11Ev();
extern void _ZN5S55C73v12Ev();
extern void _ZN5S55C73v13Ev();
extern void _ZN5S55C73v14Ev();
extern void _ZN5S55C73v15Ev();
extern void _ZN5S55C73v16Ev();
extern void _ZN5S55C73v17Ev();
extern void _ZN5S55C73v18Ev();
extern void _ZN5S55C73v19Ev();
extern void _ZN5S55C73v20Ev();
extern void _ZN5S55C73v21Ev();
extern void _ZN5S55C73v22Ev();
extern void _ZN5S55C73v23Ev();
extern void _ZN5S55C73v24Ev();
extern void _ZN5S55C73v25Ev();
extern void _ZN5S55C73v26Ev();
extern void _ZN5S55C73v27Ev();
extern void _ZN5S55C73v28Ev();
extern void _ZN5S55C73v29Ev();
extern void _ZN5S55C73v30Ev();
extern void _ZN5S55C73v31Ev();
extern void _ZN5S55C73v32Ev();
extern void _ZN5S55C73v33Ev();
extern void _ZN5S55C73v34Ev();
extern void _ZN5S55C73v35Ev();
extern void _ZN5S55C73v36Ev();
extern void _ZN5S55C73v37Ev();
extern void _ZN5S55C73v38Ev();
extern void _ZN5S55C73v39Ev();
extern void _ZN5S55C73v40Ev();
extern void _ZN5S55C73v41Ev();
extern void _ZN5S55C73v42Ev();
extern void _ZN5S55C73v43Ev();
extern void _ZN5S55C73v44Ev();
extern void _ZN5S55C73v45Ev();
extern void _ZN5S55C73v46Ev();
extern void _ZN5S55C73v47Ev();
extern void _ZN5S55C73v48Ev();
extern void _ZN5S55C73v49Ev();
extern void _ZN5S55C73v50Ev();
extern void _ZN5S55C73v51Ev();
extern void _ZN5S55C73v52Ev();
extern void _ZN5S55C73v53Ev();
extern void _ZN5S55C73v54Ev();
extern void _ZN5S55C73v55Ev();
extern void _ZN5S55C73v56Ev();
extern void _ZN5S55C73v57Ev();
extern void _ZN5S55C73v58Ev();
extern void _ZN5S55C73v59Ev();
extern void _ZN5S55C73v60Ev();
extern void _ZN5S55C73v61Ev();
extern void _ZN5S55C73v62Ev();
extern void _ZN5S55C73v63Ev();
extern void _ZN5S55C73v64Ev();
extern void _ZN5S55C73v65Ev();
extern void _ZN5S55C73v66Ev();
extern void _ZN5S55C63v67Ev();
extern void _ZN5S55C63v68Ev();
extern void _ZN5S55C63v69Ev();
extern void _ZN5S55C63v70Ev();
extern void _ZN5S55C63v71Ev();
extern void _ZN5S55C63v72Ev();
extern void _ZN5S55C63v73Ev();
extern void _ZN5S55C63v74Ev();
extern void _ZN5S55C63v75Ev();
extern void _ZN5S55C63v76Ev();
extern void _ZN5S55C63v77Ev();
extern void _ZN5S55C63v78Ev();
extern void _ZN5S55C63v79Ev();
extern void _ZN5S55C63v80Ev();
extern void _ZN5S55C63v81Ev();
extern void _ZN5S55C63v82Ev();
extern void _ZN5S55C63v83Ev();
extern void _ZN5S55C63v84Ev();
extern void _ZN5S55C63v85Ev();
extern void _ZN5S55C63v86Ev();
extern void _ZN5S55C63v87Ev();
extern void _ZN5S55C63v88Ev();
static  VTBL_ENTRY vtc_S55C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S55C6[0]),
  (VTBL_ENTRY)&_ZN5S55C6D1Ev,
  (VTBL_ENTRY)&_ZN5S55C6D0Ev,
  (VTBL_ENTRY)&_ZN5S55C72v3Ev,
  (VTBL_ENTRY)&_ZN5S55C72v4Ev,
  (VTBL_ENTRY)&_ZN5S55C72v5Ev,
  (VTBL_ENTRY)&_ZN5S55C72v6Ev,
  (VTBL_ENTRY)&_ZN5S55C72v7Ev,
  (VTBL_ENTRY)&_ZN5S55C72v8Ev,
  (VTBL_ENTRY)&_ZN5S55C72v9Ev,
  (VTBL_ENTRY)&_ZN5S55C73v10Ev,
  (VTBL_ENTRY)&_ZN5S55C73v11Ev,
  (VTBL_ENTRY)&_ZN5S55C73v12Ev,
  (VTBL_ENTRY)&_ZN5S55C73v13Ev,
  (VTBL_ENTRY)&_ZN5S55C73v14Ev,
  (VTBL_ENTRY)&_ZN5S55C73v15Ev,
  (VTBL_ENTRY)&_ZN5S55C73v16Ev,
  (VTBL_ENTRY)&_ZN5S55C73v17Ev,
  (VTBL_ENTRY)&_ZN5S55C73v18Ev,
  (VTBL_ENTRY)&_ZN5S55C73v19Ev,
  (VTBL_ENTRY)&_ZN5S55C73v20Ev,
  (VTBL_ENTRY)&_ZN5S55C73v21Ev,
  (VTBL_ENTRY)&_ZN5S55C73v22Ev,
  (VTBL_ENTRY)&_ZN5S55C73v23Ev,
  (VTBL_ENTRY)&_ZN5S55C73v24Ev,
  (VTBL_ENTRY)&_ZN5S55C73v25Ev,
  (VTBL_ENTRY)&_ZN5S55C73v26Ev,
  (VTBL_ENTRY)&_ZN5S55C73v27Ev,
  (VTBL_ENTRY)&_ZN5S55C73v28Ev,
  (VTBL_ENTRY)&_ZN5S55C73v29Ev,
  (VTBL_ENTRY)&_ZN5S55C73v30Ev,
  (VTBL_ENTRY)&_ZN5S55C73v31Ev,
  (VTBL_ENTRY)&_ZN5S55C73v32Ev,
  (VTBL_ENTRY)&_ZN5S55C73v33Ev,
  (VTBL_ENTRY)&_ZN5S55C73v34Ev,
  (VTBL_ENTRY)&_ZN5S55C73v35Ev,
  (VTBL_ENTRY)&_ZN5S55C73v36Ev,
  (VTBL_ENTRY)&_ZN5S55C73v37Ev,
  (VTBL_ENTRY)&_ZN5S55C73v38Ev,
  (VTBL_ENTRY)&_ZN5S55C73v39Ev,
  (VTBL_ENTRY)&_ZN5S55C73v40Ev,
  (VTBL_ENTRY)&_ZN5S55C73v41Ev,
  (VTBL_ENTRY)&_ZN5S55C73v42Ev,
  (VTBL_ENTRY)&_ZN5S55C73v43Ev,
  (VTBL_ENTRY)&_ZN5S55C73v44Ev,
  (VTBL_ENTRY)&_ZN5S55C73v45Ev,
  (VTBL_ENTRY)&_ZN5S55C73v46Ev,
  (VTBL_ENTRY)&_ZN5S55C73v47Ev,
  (VTBL_ENTRY)&_ZN5S55C73v48Ev,
  (VTBL_ENTRY)&_ZN5S55C73v49Ev,
  (VTBL_ENTRY)&_ZN5S55C73v50Ev,
  (VTBL_ENTRY)&_ZN5S55C73v51Ev,
  (VTBL_ENTRY)&_ZN5S55C73v52Ev,
  (VTBL_ENTRY)&_ZN5S55C73v53Ev,
  (VTBL_ENTRY)&_ZN5S55C73v54Ev,
  (VTBL_ENTRY)&_ZN5S55C73v55Ev,
  (VTBL_ENTRY)&_ZN5S55C73v56Ev,
  (VTBL_ENTRY)&_ZN5S55C73v57Ev,
  (VTBL_ENTRY)&_ZN5S55C73v58Ev,
  (VTBL_ENTRY)&_ZN5S55C73v59Ev,
  (VTBL_ENTRY)&_ZN5S55C73v60Ev,
  (VTBL_ENTRY)&_ZN5S55C73v61Ev,
  (VTBL_ENTRY)&_ZN5S55C73v62Ev,
  (VTBL_ENTRY)&_ZN5S55C73v63Ev,
  (VTBL_ENTRY)&_ZN5S55C73v64Ev,
  (VTBL_ENTRY)&_ZN5S55C73v65Ev,
  (VTBL_ENTRY)&_ZN5S55C73v66Ev,
  (VTBL_ENTRY)&_ZN5S55C63v67Ev,
  (VTBL_ENTRY)&_ZN5S55C63v68Ev,
  (VTBL_ENTRY)&_ZN5S55C63v69Ev,
  (VTBL_ENTRY)&_ZN5S55C63v70Ev,
  (VTBL_ENTRY)&_ZN5S55C63v71Ev,
  (VTBL_ENTRY)&_ZN5S55C63v72Ev,
  (VTBL_ENTRY)&_ZN5S55C63v73Ev,
  (VTBL_ENTRY)&_ZN5S55C63v74Ev,
  (VTBL_ENTRY)&_ZN5S55C63v75Ev,
  (VTBL_ENTRY)&_ZN5S55C63v76Ev,
  (VTBL_ENTRY)&_ZN5S55C63v77Ev,
  (VTBL_ENTRY)&_ZN5S55C63v78Ev,
  (VTBL_ENTRY)&_ZN5S55C63v79Ev,
  (VTBL_ENTRY)&_ZN5S55C63v80Ev,
  (VTBL_ENTRY)&_ZN5S55C63v81Ev,
  (VTBL_ENTRY)&_ZN5S55C63v82Ev,
  (VTBL_ENTRY)&_ZN5S55C63v83Ev,
  (VTBL_ENTRY)&_ZN5S55C63v84Ev,
  (VTBL_ENTRY)&_ZN5S55C63v85Ev,
  (VTBL_ENTRY)&_ZN5S55C63v86Ev,
  (VTBL_ENTRY)&_ZN5S55C63v87Ev,
  (VTBL_ENTRY)&_ZN5S55C63v88Ev,
};
extern VTBL_ENTRY _ZTI5S55C6[];
extern  VTBL_ENTRY _ZTV5S55C6[];
Class_Descriptor cd_S55C6 = {  "S55C6", // class name
  bases_S55C6, 1,
  &(vtc_S55C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI5S55C6),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S55C6),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S55C5  : S55C6 {
  unsigned int s55c5f0:1;
  unsigned int s55c5f1:1;
  unsigned int s55c5f2:1;
  ::S3350C17 s55c5f3;
  ::S3350C11 s55c5f4;
  ::S3350C5_nt s55c5f5;
  ::S287C27 s55c5f6;
  int s55c5f7[3];
  virtual  ~S55C5(); // _ZN5S55C5D1Ev
  virtual void  v89(); // _ZN5S55C53v89Ev
  virtual void  v90(); // _ZN5S55C53v90Ev
  virtual void  v91(); // _ZN5S55C53v91Ev
  virtual void  v92(); // _ZN5S55C53v92Ev
  virtual void  v93(); // _ZN5S55C53v93Ev
  virtual void  v94(); // _ZN5S55C53v94Ev
  virtual void  v95(); // _ZN5S55C53v95Ev
  virtual void  v96(); // _ZN5S55C53v96Ev
  virtual void  v97(); // _ZN5S55C53v97Ev
  virtual void  v98(); // _ZN5S55C53v98Ev
  virtual void  v99(); // _ZN5S55C53v99Ev
  virtual void  v100(); // _ZN5S55C54v100Ev
  virtual void  v101(); // _ZN5S55C54v101Ev
  virtual void  v102(); // _ZN5S55C54v102Ev
  virtual void  v103(); // _ZN5S55C54v103Ev
  virtual void  v104(); // _ZN5S55C54v104Ev
  virtual void  v105(); // _ZN5S55C54v105Ev
  virtual void  v106(); // _ZN5S55C54v106Ev
  virtual void  v107(); // _ZN5S55C54v107Ev
  virtual void  v108(); // _ZN5S55C54v108Ev
  S55C5(); // tgen
};
//SIG(-1 S55C5) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} FC16{ BC17{ BC8}} Fi[3]}


 S55C5 ::~S55C5(){ note_dtor("S55C5", this);}
void  S55C5 ::v89(){vfunc_called(this, "_ZN5S55C53v89Ev");}
void  S55C5 ::v90(){vfunc_called(this, "_ZN5S55C53v90Ev");}
void  S55C5 ::v91(){vfunc_called(this, "_ZN5S55C53v91Ev");}
void  S55C5 ::v92(){vfunc_called(this, "_ZN5S55C53v92Ev");}
void  S55C5 ::v93(){vfunc_called(this, "_ZN5S55C53v93Ev");}
void  S55C5 ::v94(){vfunc_called(this, "_ZN5S55C53v94Ev");}
void  S55C5 ::v95(){vfunc_called(this, "_ZN5S55C53v95Ev");}
void  S55C5 ::v96(){vfunc_called(this, "_ZN5S55C53v96Ev");}
void  S55C5 ::v97(){vfunc_called(this, "_ZN5S55C53v97Ev");}
void  S55C5 ::v98(){vfunc_called(this, "_ZN5S55C53v98Ev");}
void  S55C5 ::v99(){vfunc_called(this, "_ZN5S55C53v99Ev");}
void  S55C5 ::v100(){vfunc_called(this, "_ZN5S55C54v100Ev");}
void  S55C5 ::v101(){vfunc_called(this, "_ZN5S55C54v101Ev");}
void  S55C5 ::v102(){vfunc_called(this, "_ZN5S55C54v102Ev");}
void  S55C5 ::v103(){vfunc_called(this, "_ZN5S55C54v103Ev");}
void  S55C5 ::v104(){vfunc_called(this, "_ZN5S55C54v104Ev");}
void  S55C5 ::v105(){vfunc_called(this, "_ZN5S55C54v105Ev");}
void  S55C5 ::v106(){vfunc_called(this, "_ZN5S55C54v106Ev");}
void  S55C5 ::v107(){vfunc_called(this, "_ZN5S55C54v107Ev");}
void  S55C5 ::v108(){vfunc_called(this, "_ZN5S55C54v108Ev");}
S55C5 ::S55C5(){ note_ctor("S55C5", this);} // tgen

static void Test_S55C5()
{
  extern Class_Descriptor cd_S55C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(35,50)];
    init_test(&cd_S55C5, buf);
    S55C5 *dp, &lv = *(dp=new (buf) S55C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,196), "sizeof(S55C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S55C5)");
    check_base_class_offset(lv, (S55C7*)(S55C6*), 0, "S55C5");
    check_base_class_offset(lv, (S55C6*), 0, "S55C5");
    set_bf_and_test(lv, s55c5f0, ABISELECT(188,132), 0, 1, 1, "S55C5");
    set_bf_and_test(lv, s55c5f1, ABISELECT(188,132), 1, 1, 1, "S55C5");
    set_bf_and_test(lv, s55c5f2, ABISELECT(188,132), 2, 1, 1, "S55C5");
    check_field_offset(lv, s55c5f3, ABISELECT(192,136), "S55C5.s55c5f3");
    check_field_offset(lv, s55c5f4, ABISELECT(208,148), "S55C5.s55c5f4");
    check_field_offset(lv, s55c5f5, ABISELECT(224,160), "S55C5.s55c5f5");
    check_field_offset(lv, s55c5f6, ABISELECT(240,172), "S55C5.s55c5f6");
    check_field_offset(lv, s55c5f7, ABISELECT(256,184), "S55C5.s55c5f7");
    test_class_info(&lv, &cd_S55C5);
    dp->~S55C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS55C5(Test_S55C5, "S55C5", ABISELECT(272,196));

#else // __cplusplus

extern void _ZN5S55C5C1Ev();
extern void _ZN5S55C5D1Ev();
Name_Map name_map_S55C5[] = {
  NSPAIR(_ZN5S55C5C1Ev),
  NSPAIR(_ZN5S55C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S55C7;
extern VTBL_ENTRY _ZTI5S55C7[];
extern  VTBL_ENTRY _ZTV5S55C7[];
extern Class_Descriptor cd_S55C6;
extern VTBL_ENTRY _ZTI5S55C6[];
extern  VTBL_ENTRY _ZTV5S55C6[];
static Base_Class bases_S55C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S55C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S55C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S55C5[];
extern void _ZN5S55C5D1Ev();
extern void _ZN5S55C5D0Ev();
extern void _ZN5S55C72v3Ev();
extern void _ZN5S55C72v4Ev();
extern void _ZN5S55C72v5Ev();
extern void _ZN5S55C72v6Ev();
extern void _ZN5S55C72v7Ev();
extern void _ZN5S55C72v8Ev();
extern void _ZN5S55C72v9Ev();
extern void _ZN5S55C73v10Ev();
extern void _ZN5S55C73v11Ev();
extern void _ZN5S55C73v12Ev();
extern void _ZN5S55C73v13Ev();
extern void _ZN5S55C73v14Ev();
extern void _ZN5S55C73v15Ev();
extern void _ZN5S55C73v16Ev();
extern void _ZN5S55C73v17Ev();
extern void _ZN5S55C73v18Ev();
extern void _ZN5S55C73v19Ev();
extern void _ZN5S55C73v20Ev();
extern void _ZN5S55C73v21Ev();
extern void _ZN5S55C73v22Ev();
extern void _ZN5S55C73v23Ev();
extern void _ZN5S55C73v24Ev();
extern void _ZN5S55C73v25Ev();
extern void _ZN5S55C73v26Ev();
extern void _ZN5S55C73v27Ev();
extern void _ZN5S55C73v28Ev();
extern void _ZN5S55C73v29Ev();
extern void _ZN5S55C73v30Ev();
extern void _ZN5S55C73v31Ev();
extern void _ZN5S55C73v32Ev();
extern void _ZN5S55C73v33Ev();
extern void _ZN5S55C73v34Ev();
extern void _ZN5S55C73v35Ev();
extern void _ZN5S55C73v36Ev();
extern void _ZN5S55C73v37Ev();
extern void _ZN5S55C73v38Ev();
extern void _ZN5S55C73v39Ev();
extern void _ZN5S55C73v40Ev();
extern void _ZN5S55C73v41Ev();
extern void _ZN5S55C73v42Ev();
extern void _ZN5S55C73v43Ev();
extern void _ZN5S55C73v44Ev();
extern void _ZN5S55C73v45Ev();
extern void _ZN5S55C73v46Ev();
extern void _ZN5S55C73v47Ev();
extern void _ZN5S55C73v48Ev();
extern void _ZN5S55C73v49Ev();
extern void _ZN5S55C73v50Ev();
extern void _ZN5S55C73v51Ev();
extern void _ZN5S55C73v52Ev();
extern void _ZN5S55C73v53Ev();
extern void _ZN5S55C73v54Ev();
extern void _ZN5S55C73v55Ev();
extern void _ZN5S55C73v56Ev();
extern void _ZN5S55C73v57Ev();
extern void _ZN5S55C73v58Ev();
extern void _ZN5S55C73v59Ev();
extern void _ZN5S55C73v60Ev();
extern void _ZN5S55C73v61Ev();
extern void _ZN5S55C73v62Ev();
extern void _ZN5S55C73v63Ev();
extern void _ZN5S55C73v64Ev();
extern void _ZN5S55C73v65Ev();
extern void _ZN5S55C73v66Ev();
extern void _ZN5S55C63v67Ev();
extern void _ZN5S55C63v68Ev();
extern void _ZN5S55C63v69Ev();
extern void _ZN5S55C63v70Ev();
extern void _ZN5S55C63v71Ev();
extern void _ZN5S55C63v72Ev();
extern void _ZN5S55C63v73Ev();
extern void _ZN5S55C63v74Ev();
extern void _ZN5S55C63v75Ev();
extern void _ZN5S55C63v76Ev();
extern void _ZN5S55C63v77Ev();
extern void _ZN5S55C63v78Ev();
extern void _ZN5S55C63v79Ev();
extern void _ZN5S55C63v80Ev();
extern void _ZN5S55C63v81Ev();
extern void _ZN5S55C63v82Ev();
extern void _ZN5S55C63v83Ev();
extern void _ZN5S55C63v84Ev();
extern void _ZN5S55C63v85Ev();
extern void _ZN5S55C63v86Ev();
extern void _ZN5S55C63v87Ev();
extern void _ZN5S55C63v88Ev();
extern void _ZN5S55C53v89Ev();
extern void _ZN5S55C53v90Ev();
extern void _ZN5S55C53v91Ev();
extern void _ZN5S55C53v92Ev();
extern void _ZN5S55C53v93Ev();
extern void _ZN5S55C53v94Ev();
extern void _ZN5S55C53v95Ev();
extern void _ZN5S55C53v96Ev();
extern void _ZN5S55C53v97Ev();
extern void _ZN5S55C53v98Ev();
extern void _ZN5S55C53v99Ev();
extern void _ZN5S55C54v100Ev();
extern void _ZN5S55C54v101Ev();
extern void _ZN5S55C54v102Ev();
extern void _ZN5S55C54v103Ev();
extern void _ZN5S55C54v104Ev();
extern void _ZN5S55C54v105Ev();
extern void _ZN5S55C54v106Ev();
extern void _ZN5S55C54v107Ev();
extern void _ZN5S55C54v108Ev();
static  VTBL_ENTRY vtc_S55C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S55C5[0]),
  (VTBL_ENTRY)&_ZN5S55C5D1Ev,
  (VTBL_ENTRY)&_ZN5S55C5D0Ev,
  (VTBL_ENTRY)&_ZN5S55C72v3Ev,
  (VTBL_ENTRY)&_ZN5S55C72v4Ev,
  (VTBL_ENTRY)&_ZN5S55C72v5Ev,
  (VTBL_ENTRY)&_ZN5S55C72v6Ev,
  (VTBL_ENTRY)&_ZN5S55C72v7Ev,
  (VTBL_ENTRY)&_ZN5S55C72v8Ev,
  (VTBL_ENTRY)&_ZN5S55C72v9Ev,
  (VTBL_ENTRY)&_ZN5S55C73v10Ev,
  (VTBL_ENTRY)&_ZN5S55C73v11Ev,
  (VTBL_ENTRY)&_ZN5S55C73v12Ev,
  (VTBL_ENTRY)&_ZN5S55C73v13Ev,
  (VTBL_ENTRY)&_ZN5S55C73v14Ev,
  (VTBL_ENTRY)&_ZN5S55C73v15Ev,
  (VTBL_ENTRY)&_ZN5S55C73v16Ev,
  (VTBL_ENTRY)&_ZN5S55C73v17Ev,
  (VTBL_ENTRY)&_ZN5S55C73v18Ev,
  (VTBL_ENTRY)&_ZN5S55C73v19Ev,
  (VTBL_ENTRY)&_ZN5S55C73v20Ev,
  (VTBL_ENTRY)&_ZN5S55C73v21Ev,
  (VTBL_ENTRY)&_ZN5S55C73v22Ev,
  (VTBL_ENTRY)&_ZN5S55C73v23Ev,
  (VTBL_ENTRY)&_ZN5S55C73v24Ev,
  (VTBL_ENTRY)&_ZN5S55C73v25Ev,
  (VTBL_ENTRY)&_ZN5S55C73v26Ev,
  (VTBL_ENTRY)&_ZN5S55C73v27Ev,
  (VTBL_ENTRY)&_ZN5S55C73v28Ev,
  (VTBL_ENTRY)&_ZN5S55C73v29Ev,
  (VTBL_ENTRY)&_ZN5S55C73v30Ev,
  (VTBL_ENTRY)&_ZN5S55C73v31Ev,
  (VTBL_ENTRY)&_ZN5S55C73v32Ev,
  (VTBL_ENTRY)&_ZN5S55C73v33Ev,
  (VTBL_ENTRY)&_ZN5S55C73v34Ev,
  (VTBL_ENTRY)&_ZN5S55C73v35Ev,
  (VTBL_ENTRY)&_ZN5S55C73v36Ev,
  (VTBL_ENTRY)&_ZN5S55C73v37Ev,
  (VTBL_ENTRY)&_ZN5S55C73v38Ev,
  (VTBL_ENTRY)&_ZN5S55C73v39Ev,
  (VTBL_ENTRY)&_ZN5S55C73v40Ev,
  (VTBL_ENTRY)&_ZN5S55C73v41Ev,
  (VTBL_ENTRY)&_ZN5S55C73v42Ev,
  (VTBL_ENTRY)&_ZN5S55C73v43Ev,
  (VTBL_ENTRY)&_ZN5S55C73v44Ev,
  (VTBL_ENTRY)&_ZN5S55C73v45Ev,
  (VTBL_ENTRY)&_ZN5S55C73v46Ev,
  (VTBL_ENTRY)&_ZN5S55C73v47Ev,
  (VTBL_ENTRY)&_ZN5S55C73v48Ev,
  (VTBL_ENTRY)&_ZN5S55C73v49Ev,
  (VTBL_ENTRY)&_ZN5S55C73v50Ev,
  (VTBL_ENTRY)&_ZN5S55C73v51Ev,
  (VTBL_ENTRY)&_ZN5S55C73v52Ev,
  (VTBL_ENTRY)&_ZN5S55C73v53Ev,
  (VTBL_ENTRY)&_ZN5S55C73v54Ev,
  (VTBL_ENTRY)&_ZN5S55C73v55Ev,
  (VTBL_ENTRY)&_ZN5S55C73v56Ev,
  (VTBL_ENTRY)&_ZN5S55C73v57Ev,
  (VTBL_ENTRY)&_ZN5S55C73v58Ev,
  (VTBL_ENTRY)&_ZN5S55C73v59Ev,
  (VTBL_ENTRY)&_ZN5S55C73v60Ev,
  (VTBL_ENTRY)&_ZN5S55C73v61Ev,
  (VTBL_ENTRY)&_ZN5S55C73v62Ev,
  (VTBL_ENTRY)&_ZN5S55C73v63Ev,
  (VTBL_ENTRY)&_ZN5S55C73v64Ev,
  (VTBL_ENTRY)&_ZN5S55C73v65Ev,
  (VTBL_ENTRY)&_ZN5S55C73v66Ev,
  (VTBL_ENTRY)&_ZN5S55C63v67Ev,
  (VTBL_ENTRY)&_ZN5S55C63v68Ev,
  (VTBL_ENTRY)&_ZN5S55C63v69Ev,
  (VTBL_ENTRY)&_ZN5S55C63v70Ev,
  (VTBL_ENTRY)&_ZN5S55C63v71Ev,
  (VTBL_ENTRY)&_ZN5S55C63v72Ev,
  (VTBL_ENTRY)&_ZN5S55C63v73Ev,
  (VTBL_ENTRY)&_ZN5S55C63v74Ev,
  (VTBL_ENTRY)&_ZN5S55C63v75Ev,
  (VTBL_ENTRY)&_ZN5S55C63v76Ev,
  (VTBL_ENTRY)&_ZN5S55C63v77Ev,
  (VTBL_ENTRY)&_ZN5S55C63v78Ev,
  (VTBL_ENTRY)&_ZN5S55C63v79Ev,
  (VTBL_ENTRY)&_ZN5S55C63v80Ev,
  (VTBL_ENTRY)&_ZN5S55C63v81Ev,
  (VTBL_ENTRY)&_ZN5S55C63v82Ev,
  (VTBL_ENTRY)&_ZN5S55C63v83Ev,
  (VTBL_ENTRY)&_ZN5S55C63v84Ev,
  (VTBL_ENTRY)&_ZN5S55C63v85Ev,
  (VTBL_ENTRY)&_ZN5S55C63v86Ev,
  (VTBL_ENTRY)&_ZN5S55C63v87Ev,
  (VTBL_ENTRY)&_ZN5S55C63v88Ev,
  (VTBL_ENTRY)&_ZN5S55C53v89Ev,
  (VTBL_ENTRY)&_ZN5S55C53v90Ev,
  (VTBL_ENTRY)&_ZN5S55C53v91Ev,
  (VTBL_ENTRY)&_ZN5S55C53v92Ev,
  (VTBL_ENTRY)&_ZN5S55C53v93Ev,
  (VTBL_ENTRY)&_ZN5S55C53v94Ev,
  (VTBL_ENTRY)&_ZN5S55C53v95Ev,
  (VTBL_ENTRY)&_ZN5S55C53v96Ev,
  (VTBL_ENTRY)&_ZN5S55C53v97Ev,
  (VTBL_ENTRY)&_ZN5S55C53v98Ev,
  (VTBL_ENTRY)&_ZN5S55C53v99Ev,
  (VTBL_ENTRY)&_ZN5S55C54v100Ev,
  (VTBL_ENTRY)&_ZN5S55C54v101Ev,
  (VTBL_ENTRY)&_ZN5S55C54v102Ev,
  (VTBL_ENTRY)&_ZN5S55C54v103Ev,
  (VTBL_ENTRY)&_ZN5S55C54v104Ev,
  (VTBL_ENTRY)&_ZN5S55C54v105Ev,
  (VTBL_ENTRY)&_ZN5S55C54v106Ev,
  (VTBL_ENTRY)&_ZN5S55C54v107Ev,
  (VTBL_ENTRY)&_ZN5S55C54v108Ev,
};
extern VTBL_ENTRY _ZTI5S55C5[];
extern  VTBL_ENTRY _ZTV5S55C5[];
Class_Descriptor cd_S55C5 = {  "S55C5", // class name
  bases_S55C5, 2,
  &(vtc_S55C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI5S55C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S55C5),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S55C4  : S55C5 {
  void *s55c4f0[2];
  int s55c4f1[4];
  unsigned int s55c4f2:1;
  unsigned int s55c4f3:1;
  unsigned int s55c4f4:1;
  char s55c4f5;
  int s55c4f6;
  unsigned int s55c4f7:1;
  ::S287C23 s55c4f8;
  virtual  ~S55C4(); // _ZN5S55C4D1Ev
  virtual void  v109(); // _ZN5S55C44v109Ev
  virtual void  v110(); // _ZN5S55C44v110Ev
  virtual void  v111(); // _ZN5S55C44v111Ev
  virtual void  v112(); // _ZN5S55C44v112Ev
  virtual void  v113(); // _ZN5S55C44v113Ev
  virtual void  v114(); // _ZN5S55C44v114Ev
  virtual void  v115(); // _ZN5S55C44v115Ev
  virtual void  v116(); // _ZN5S55C44v116Ev
  virtual void  v117(); // _ZN5S55C44v117Ev
  virtual void  v118(); // _ZN5S55C44v118Ev
  virtual void  v119(); // _ZN5S55C44v119Ev
  virtual void  v120(); // _ZN5S55C44v120Ev
  virtual void  v121(); // _ZN5S55C44v121Ev
  virtual void  v122(); // _ZN5S55C44v122Ev
  S55C4(); // tgen
};
//SIG(-1 S55C4) C1{ BC2{ BC3{ BC4{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} FC17{ BC18{ BC9}} Fi[3]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] Fi[4] Fi:1 Fi:1 Fi:1 Fc Fi Fi:1 FC19{ BC20{ BC9}}}


 S55C4 ::~S55C4(){ note_dtor("S55C4", this);}
void  S55C4 ::v109(){vfunc_called(this, "_ZN5S55C44v109Ev");}
void  S55C4 ::v110(){vfunc_called(this, "_ZN5S55C44v110Ev");}
void  S55C4 ::v111(){vfunc_called(this, "_ZN5S55C44v111Ev");}
void  S55C4 ::v112(){vfunc_called(this, "_ZN5S55C44v112Ev");}
void  S55C4 ::v113(){vfunc_called(this, "_ZN5S55C44v113Ev");}
void  S55C4 ::v114(){vfunc_called(this, "_ZN5S55C44v114Ev");}
void  S55C4 ::v115(){vfunc_called(this, "_ZN5S55C44v115Ev");}
void  S55C4 ::v116(){vfunc_called(this, "_ZN5S55C44v116Ev");}
void  S55C4 ::v117(){vfunc_called(this, "_ZN5S55C44v117Ev");}
void  S55C4 ::v118(){vfunc_called(this, "_ZN5S55C44v118Ev");}
void  S55C4 ::v119(){vfunc_called(this, "_ZN5S55C44v119Ev");}
void  S55C4 ::v120(){vfunc_called(this, "_ZN5S55C44v120Ev");}
void  S55C4 ::v121(){vfunc_called(this, "_ZN5S55C44v121Ev");}
void  S55C4 ::v122(){vfunc_called(this, "_ZN5S55C44v122Ev");}
S55C4 ::S55C4(){ note_ctor("S55C4", this);} // tgen

static void Test_S55C4()
{
  extern Class_Descriptor cd_S55C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(43,62)];
    init_test(&cd_S55C4, buf);
    S55C4 *dp, &lv = *(dp=new (buf) S55C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(336,244), "sizeof(S55C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S55C4)");
    check_base_class_offset(lv, (S55C7*)(S55C6*)(S55C5*), 0, "S55C4");
    check_base_class_offset(lv, (S55C6*)(S55C5*), 0, "S55C4");
    check_base_class_offset(lv, (S55C5*), 0, "S55C4");
    check_field_offset(lv, s55c4f0, ABISELECT(272,196), "S55C4.s55c4f0");
    check_field_offset(lv, s55c4f1, ABISELECT(288,204), "S55C4.s55c4f1");
    set_bf_and_test(lv, s55c4f2, ABISELECT(304,220), 0, 1, 1, "S55C4");
    set_bf_and_test(lv, s55c4f3, ABISELECT(304,220), 1, 1, 1, "S55C4");
    set_bf_and_test(lv, s55c4f4, ABISELECT(304,220), 2, 1, 1, "S55C4");
    check_field_offset(lv, s55c4f5, ABISELECT(305,221), "S55C4.s55c4f5");
    check_field_offset(lv, s55c4f6, ABISELECT(308,224), "S55C4.s55c4f6");
    set_bf_and_test(lv, s55c4f7, ABISELECT(312,228), 0, 1, 1, "S55C4");
    check_field_offset(lv, s55c4f8, ABISELECT(320,232), "S55C4.s55c4f8");
    test_class_info(&lv, &cd_S55C4);
    dp->~S55C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS55C4(Test_S55C4, "S55C4", ABISELECT(336,244));

#else // __cplusplus

extern void _ZN5S55C4C1Ev();
extern void _ZN5S55C4D1Ev();
Name_Map name_map_S55C4[] = {
  NSPAIR(_ZN5S55C4C1Ev),
  NSPAIR(_ZN5S55C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S55C7;
extern VTBL_ENTRY _ZTI5S55C7[];
extern  VTBL_ENTRY _ZTV5S55C7[];
extern Class_Descriptor cd_S55C6;
extern VTBL_ENTRY _ZTI5S55C6[];
extern  VTBL_ENTRY _ZTV5S55C6[];
extern Class_Descriptor cd_S55C5;
extern VTBL_ENTRY _ZTI5S55C5[];
extern  VTBL_ENTRY _ZTV5S55C5[];
static Base_Class bases_S55C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S55C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S55C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S55C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S55C4[];
extern void _ZN5S55C4D1Ev();
extern void _ZN5S55C4D0Ev();
extern void _ZN5S55C72v3Ev();
extern void _ZN5S55C72v4Ev();
extern void _ZN5S55C72v5Ev();
extern void _ZN5S55C72v6Ev();
extern void _ZN5S55C72v7Ev();
extern void _ZN5S55C72v8Ev();
extern void _ZN5S55C72v9Ev();
extern void _ZN5S55C73v10Ev();
extern void _ZN5S55C73v11Ev();
extern void _ZN5S55C73v12Ev();
extern void _ZN5S55C73v13Ev();
extern void _ZN5S55C73v14Ev();
extern void _ZN5S55C73v15Ev();
extern void _ZN5S55C73v16Ev();
extern void _ZN5S55C73v17Ev();
extern void _ZN5S55C73v18Ev();
extern void _ZN5S55C73v19Ev();
extern void _ZN5S55C73v20Ev();
extern void _ZN5S55C73v21Ev();
extern void _ZN5S55C73v22Ev();
extern void _ZN5S55C73v23Ev();
extern void _ZN5S55C73v24Ev();
extern void _ZN5S55C73v25Ev();
extern void _ZN5S55C73v26Ev();
extern void _ZN5S55C73v27Ev();
extern void _ZN5S55C73v28Ev();
extern void _ZN5S55C73v29Ev();
extern void _ZN5S55C73v30Ev();
extern void _ZN5S55C73v31Ev();
extern void _ZN5S55C73v32Ev();
extern void _ZN5S55C73v33Ev();
extern void _ZN5S55C73v34Ev();
extern void _ZN5S55C73v35Ev();
extern void _ZN5S55C73v36Ev();
extern void _ZN5S55C73v37Ev();
extern void _ZN5S55C73v38Ev();
extern void _ZN5S55C73v39Ev();
extern void _ZN5S55C73v40Ev();
extern void _ZN5S55C73v41Ev();
extern void _ZN5S55C73v42Ev();
extern void _ZN5S55C73v43Ev();
extern void _ZN5S55C73v44Ev();
extern void _ZN5S55C73v45Ev();
extern void _ZN5S55C73v46Ev();
extern void _ZN5S55C73v47Ev();
extern void _ZN5S55C73v48Ev();
extern void _ZN5S55C73v49Ev();
extern void _ZN5S55C73v50Ev();
extern void _ZN5S55C73v51Ev();
extern void _ZN5S55C73v52Ev();
extern void _ZN5S55C73v53Ev();
extern void _ZN5S55C73v54Ev();
extern void _ZN5S55C73v55Ev();
extern void _ZN5S55C73v56Ev();
extern void _ZN5S55C73v57Ev();
extern void _ZN5S55C73v58Ev();
extern void _ZN5S55C73v59Ev();
extern void _ZN5S55C73v60Ev();
extern void _ZN5S55C73v61Ev();
extern void _ZN5S55C73v62Ev();
extern void _ZN5S55C73v63Ev();
extern void _ZN5S55C73v64Ev();
extern void _ZN5S55C73v65Ev();
extern void _ZN5S55C73v66Ev();
extern void _ZN5S55C63v67Ev();
extern void _ZN5S55C63v68Ev();
extern void _ZN5S55C63v69Ev();
extern void _ZN5S55C63v70Ev();
extern void _ZN5S55C63v71Ev();
extern void _ZN5S55C63v72Ev();
extern void _ZN5S55C63v73Ev();
extern void _ZN5S55C63v74Ev();
extern void _ZN5S55C63v75Ev();
extern void _ZN5S55C63v76Ev();
extern void _ZN5S55C63v77Ev();
extern void _ZN5S55C63v78Ev();
extern void _ZN5S55C63v79Ev();
extern void _ZN5S55C63v80Ev();
extern void _ZN5S55C63v81Ev();
extern void _ZN5S55C63v82Ev();
extern void _ZN5S55C63v83Ev();
extern void _ZN5S55C63v84Ev();
extern void _ZN5S55C63v85Ev();
extern void _ZN5S55C63v86Ev();
extern void _ZN5S55C63v87Ev();
extern void _ZN5S55C63v88Ev();
extern void _ZN5S55C53v89Ev();
extern void _ZN5S55C53v90Ev();
extern void _ZN5S55C53v91Ev();
extern void _ZN5S55C53v92Ev();
extern void _ZN5S55C53v93Ev();
extern void _ZN5S55C53v94Ev();
extern void _ZN5S55C53v95Ev();
extern void _ZN5S55C53v96Ev();
extern void _ZN5S55C53v97Ev();
extern void _ZN5S55C53v98Ev();
extern void _ZN5S55C53v99Ev();
extern void _ZN5S55C54v100Ev();
extern void _ZN5S55C54v101Ev();
extern void _ZN5S55C54v102Ev();
extern void _ZN5S55C54v103Ev();
extern void _ZN5S55C54v104Ev();
extern void _ZN5S55C54v105Ev();
extern void _ZN5S55C54v106Ev();
extern void _ZN5S55C54v107Ev();
extern void _ZN5S55C54v108Ev();
extern void _ZN5S55C44v109Ev();
extern void _ZN5S55C44v110Ev();
extern void _ZN5S55C44v111Ev();
extern void _ZN5S55C44v112Ev();
extern void _ZN5S55C44v113Ev();
extern void _ZN5S55C44v114Ev();
extern void _ZN5S55C44v115Ev();
extern void _ZN5S55C44v116Ev();
extern void _ZN5S55C44v117Ev();
extern void _ZN5S55C44v118Ev();
extern void _ZN5S55C44v119Ev();
extern void _ZN5S55C44v120Ev();
extern void _ZN5S55C44v121Ev();
extern void _ZN5S55C44v122Ev();
static  VTBL_ENTRY vtc_S55C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S55C4[0]),
  (VTBL_ENTRY)&_ZN5S55C4D1Ev,
  (VTBL_ENTRY)&_ZN5S55C4D0Ev,
  (VTBL_ENTRY)&_ZN5S55C72v3Ev,
  (VTBL_ENTRY)&_ZN5S55C72v4Ev,
  (VTBL_ENTRY)&_ZN5S55C72v5Ev,
  (VTBL_ENTRY)&_ZN5S55C72v6Ev,
  (VTBL_ENTRY)&_ZN5S55C72v7Ev,
  (VTBL_ENTRY)&_ZN5S55C72v8Ev,
  (VTBL_ENTRY)&_ZN5S55C72v9Ev,
  (VTBL_ENTRY)&_ZN5S55C73v10Ev,
  (VTBL_ENTRY)&_ZN5S55C73v11Ev,
  (VTBL_ENTRY)&_ZN5S55C73v12Ev,
  (VTBL_ENTRY)&_ZN5S55C73v13Ev,
  (VTBL_ENTRY)&_ZN5S55C73v14Ev,
  (VTBL_ENTRY)&_ZN5S55C73v15Ev,
  (VTBL_ENTRY)&_ZN5S55C73v16Ev,
  (VTBL_ENTRY)&_ZN5S55C73v17Ev,
  (VTBL_ENTRY)&_ZN5S55C73v18Ev,
  (VTBL_ENTRY)&_ZN5S55C73v19Ev,
  (VTBL_ENTRY)&_ZN5S55C73v20Ev,
  (VTBL_ENTRY)&_ZN5S55C73v21Ev,
  (VTBL_ENTRY)&_ZN5S55C73v22Ev,
  (VTBL_ENTRY)&_ZN5S55C73v23Ev,
  (VTBL_ENTRY)&_ZN5S55C73v24Ev,
  (VTBL_ENTRY)&_ZN5S55C73v25Ev,
  (VTBL_ENTRY)&_ZN5S55C73v26Ev,
  (VTBL_ENTRY)&_ZN5S55C73v27Ev,
  (VTBL_ENTRY)&_ZN5S55C73v28Ev,
  (VTBL_ENTRY)&_ZN5S55C73v29Ev,
  (VTBL_ENTRY)&_ZN5S55C73v30Ev,
  (VTBL_ENTRY)&_ZN5S55C73v31Ev,
  (VTBL_ENTRY)&_ZN5S55C73v32Ev,
  (VTBL_ENTRY)&_ZN5S55C73v33Ev,
  (VTBL_ENTRY)&_ZN5S55C73v34Ev,
  (VTBL_ENTRY)&_ZN5S55C73v35Ev,
  (VTBL_ENTRY)&_ZN5S55C73v36Ev,
  (VTBL_ENTRY)&_ZN5S55C73v37Ev,
  (VTBL_ENTRY)&_ZN5S55C73v38Ev,
  (VTBL_ENTRY)&_ZN5S55C73v39Ev,
  (VTBL_ENTRY)&_ZN5S55C73v40Ev,
  (VTBL_ENTRY)&_ZN5S55C73v41Ev,
  (VTBL_ENTRY)&_ZN5S55C73v42Ev,
  (VTBL_ENTRY)&_ZN5S55C73v43Ev,
  (VTBL_ENTRY)&_ZN5S55C73v44Ev,
  (VTBL_ENTRY)&_ZN5S55C73v45Ev,
  (VTBL_ENTRY)&_ZN5S55C73v46Ev,
  (VTBL_ENTRY)&_ZN5S55C73v47Ev,
  (VTBL_ENTRY)&_ZN5S55C73v48Ev,
  (VTBL_ENTRY)&_ZN5S55C73v49Ev,
  (VTBL_ENTRY)&_ZN5S55C73v50Ev,
  (VTBL_ENTRY)&_ZN5S55C73v51Ev,
  (VTBL_ENTRY)&_ZN5S55C73v52Ev,
  (VTBL_ENTRY)&_ZN5S55C73v53Ev,
  (VTBL_ENTRY)&_ZN5S55C73v54Ev,
  (VTBL_ENTRY)&_ZN5S55C73v55Ev,
  (VTBL_ENTRY)&_ZN5S55C73v56Ev,
  (VTBL_ENTRY)&_ZN5S55C73v57Ev,
  (VTBL_ENTRY)&_ZN5S55C73v58Ev,
  (VTBL_ENTRY)&_ZN5S55C73v59Ev,
  (VTBL_ENTRY)&_ZN5S55C73v60Ev,
  (VTBL_ENTRY)&_ZN5S55C73v61Ev,
  (VTBL_ENTRY)&_ZN5S55C73v62Ev,
  (VTBL_ENTRY)&_ZN5S55C73v63Ev,
  (VTBL_ENTRY)&_ZN5S55C73v64Ev,
  (VTBL_ENTRY)&_ZN5S55C73v65Ev,
  (VTBL_ENTRY)&_ZN5S55C73v66Ev,
  (VTBL_ENTRY)&_ZN5S55C63v67Ev,
  (VTBL_ENTRY)&_ZN5S55C63v68Ev,
  (VTBL_ENTRY)&_ZN5S55C63v69Ev,
  (VTBL_ENTRY)&_ZN5S55C63v70Ev,
  (VTBL_ENTRY)&_ZN5S55C63v71Ev,
  (VTBL_ENTRY)&_ZN5S55C63v72Ev,
  (VTBL_ENTRY)&_ZN5S55C63v73Ev,
  (VTBL_ENTRY)&_ZN5S55C63v74Ev,
  (VTBL_ENTRY)&_ZN5S55C63v75Ev,
  (VTBL_ENTRY)&_ZN5S55C63v76Ev,
  (VTBL_ENTRY)&_ZN5S55C63v77Ev,
  (VTBL_ENTRY)&_ZN5S55C63v78Ev,
  (VTBL_ENTRY)&_ZN5S55C63v79Ev,
  (VTBL_ENTRY)&_ZN5S55C63v80Ev,
  (VTBL_ENTRY)&_ZN5S55C63v81Ev,
  (VTBL_ENTRY)&_ZN5S55C63v82Ev,
  (VTBL_ENTRY)&_ZN5S55C63v83Ev,
  (VTBL_ENTRY)&_ZN5S55C63v84Ev,
  (VTBL_ENTRY)&_ZN5S55C63v85Ev,
  (VTBL_ENTRY)&_ZN5S55C63v86Ev,
  (VTBL_ENTRY)&_ZN5S55C63v87Ev,
  (VTBL_ENTRY)&_ZN5S55C63v88Ev,
  (VTBL_ENTRY)&_ZN5S55C53v89Ev,
  (VTBL_ENTRY)&_ZN5S55C53v90Ev,
  (VTBL_ENTRY)&_ZN5S55C53v91Ev,
  (VTBL_ENTRY)&_ZN5S55C53v92Ev,
  (VTBL_ENTRY)&_ZN5S55C53v93Ev,
  (VTBL_ENTRY)&_ZN5S55C53v94Ev,
  (VTBL_ENTRY)&_ZN5S55C53v95Ev,
  (VTBL_ENTRY)&_ZN5S55C53v96Ev,
  (VTBL_ENTRY)&_ZN5S55C53v97Ev,
  (VTBL_ENTRY)&_ZN5S55C53v98Ev,
  (VTBL_ENTRY)&_ZN5S55C53v99Ev,
  (VTBL_ENTRY)&_ZN5S55C54v100Ev,
  (VTBL_ENTRY)&_ZN5S55C54v101Ev,
  (VTBL_ENTRY)&_ZN5S55C54v102Ev,
  (VTBL_ENTRY)&_ZN5S55C54v103Ev,
  (VTBL_ENTRY)&_ZN5S55C54v104Ev,
  (VTBL_ENTRY)&_ZN5S55C54v105Ev,
  (VTBL_ENTRY)&_ZN5S55C54v106Ev,
  (VTBL_ENTRY)&_ZN5S55C54v107Ev,
  (VTBL_ENTRY)&_ZN5S55C54v108Ev,
  (VTBL_ENTRY)&_ZN5S55C44v109Ev,
  (VTBL_ENTRY)&_ZN5S55C44v110Ev,
  (VTBL_ENTRY)&_ZN5S55C44v111Ev,
  (VTBL_ENTRY)&_ZN5S55C44v112Ev,
  (VTBL_ENTRY)&_ZN5S55C44v113Ev,
  (VTBL_ENTRY)&_ZN5S55C44v114Ev,
  (VTBL_ENTRY)&_ZN5S55C44v115Ev,
  (VTBL_ENTRY)&_ZN5S55C44v116Ev,
  (VTBL_ENTRY)&_ZN5S55C44v117Ev,
  (VTBL_ENTRY)&_ZN5S55C44v118Ev,
  (VTBL_ENTRY)&_ZN5S55C44v119Ev,
  (VTBL_ENTRY)&_ZN5S55C44v120Ev,
  (VTBL_ENTRY)&_ZN5S55C44v121Ev,
  (VTBL_ENTRY)&_ZN5S55C44v122Ev,
};
extern VTBL_ENTRY _ZTI5S55C4[];
extern  VTBL_ENTRY _ZTV5S55C4[];
Class_Descriptor cd_S55C4 = {  "S55C4", // class name
  bases_S55C4, 3,
  &(vtc_S55C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(336,244), // object size
  NSPAIRA(_ZTI5S55C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S55C4),124, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S55C3  : S55C4 {
  void *s55c3f0[2];
  ::S287C8_nt s55c3f1;
  unsigned int s55c3f2:1;
  unsigned int s55c3f3:1;
  ::S3350C21_nt s55c3f4;
  virtual  ~S55C3(); // _ZN5S55C3D1Ev
  virtual void  v123(); // _ZN5S55C34v123Ev
  virtual void  v124(); // _ZN5S55C34v124Ev
  virtual void  v125(); // _ZN5S55C34v125Ev
  virtual void  v126(); // _ZN5S55C34v126Ev
  virtual void  v127(); // _ZN5S55C34v127Ev
  virtual void  v128(); // _ZN5S55C34v128Ev
  virtual void  v129(); // _ZN5S55C34v129Ev
  virtual void  v130(); // _ZN5S55C34v130Ev
  virtual void  v131(); // _ZN5S55C34v131Ev
  virtual void  v132(); // _ZN5S55C34v132Ev
  virtual void  v133(); // _ZN5S55C34v133Ev
  S55C3(); // tgen
};
//SIG(-1 S55C3) C1{ BC2{ BC3{ BC4{ BC5{ vd v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} FC18{ BC19{ BC10}} Fi[3]} vd v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 Fp[2] Fi[4] Fi:1 Fi:1 Fi:1 Fc Fi Fi:1 FC20{ BC21{ BC10}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 Fp[2] FC7 Fi:1 Fi:1 FC22{ m Fp FC6}}


 S55C3 ::~S55C3(){ note_dtor("S55C3", this);}
void  S55C3 ::v123(){vfunc_called(this, "_ZN5S55C34v123Ev");}
void  S55C3 ::v124(){vfunc_called(this, "_ZN5S55C34v124Ev");}
void  S55C3 ::v125(){vfunc_called(this, "_ZN5S55C34v125Ev");}
void  S55C3 ::v126(){vfunc_called(this, "_ZN5S55C34v126Ev");}
void  S55C3 ::v127(){vfunc_called(this, "_ZN5S55C34v127Ev");}
void  S55C3 ::v128(){vfunc_called(this, "_ZN5S55C34v128Ev");}
void  S55C3 ::v129(){vfunc_called(this, "_ZN5S55C34v129Ev");}
void  S55C3 ::v130(){vfunc_called(this, "_ZN5S55C34v130Ev");}
void  S55C3 ::v131(){vfunc_called(this, "_ZN5S55C34v131Ev");}
void  S55C3 ::v132(){vfunc_called(this, "_ZN5S55C34v132Ev");}
void  S55C3 ::v133(){vfunc_called(this, "_ZN5S55C34v133Ev");}
S55C3 ::S55C3(){ note_ctor("S55C3", this);} // tgen

static void Test_S55C3()
{
  extern Class_Descriptor cd_S55C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(50,71)];
    init_test(&cd_S55C3, buf);
    S55C3 *dp, &lv = *(dp=new (buf) S55C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(392,280), "sizeof(S55C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S55C3)");
    check_base_class_offset(lv, (S55C7*)(S55C6*)(S55C5*)(S55C4*), 0, "S55C3");
    check_base_class_offset(lv, (S55C6*)(S55C5*)(S55C4*), 0, "S55C3");
    check_base_class_offset(lv, (S55C5*)(S55C4*), 0, "S55C3");
    check_base_class_offset(lv, (S55C4*), 0, "S55C3");
    check_field_offset(lv, s55c3f0, ABISELECT(336,244), "S55C3.s55c3f0");
    check_field_offset(lv, s55c3f1, ABISELECT(352,252), "S55C3.s55c3f1");
    set_bf_and_test(lv, s55c3f2, ABISELECT(368,264), 0, 1, 1, "S55C3");
    set_bf_and_test(lv, s55c3f3, ABISELECT(368,264), 1, 1, 1, "S55C3");
    check_field_offset(lv, s55c3f4, ABISELECT(376,268), "S55C3.s55c3f4");
    test_class_info(&lv, &cd_S55C3);
    dp->~S55C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS55C3(Test_S55C3, "S55C3", ABISELECT(392,280));

#else // __cplusplus

extern void _ZN5S55C3C1Ev();
extern void _ZN5S55C3D1Ev();
Name_Map name_map_S55C3[] = {
  NSPAIR(_ZN5S55C3C1Ev),
  NSPAIR(_ZN5S55C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S55C7;
extern VTBL_ENTRY _ZTI5S55C7[];
extern  VTBL_ENTRY _ZTV5S55C7[];
extern Class_Descriptor cd_S55C6;
extern VTBL_ENTRY _ZTI5S55C6[];
extern  VTBL_ENTRY _ZTV5S55C6[];
extern Class_Descriptor cd_S55C5;
extern VTBL_ENTRY _ZTI5S55C5[];
extern  VTBL_ENTRY _ZTV5S55C5[];
extern Class_Descriptor cd_S55C4;
extern VTBL_ENTRY _ZTI5S55C4[];
extern  VTBL_ENTRY _ZTV5S55C4[];
static Base_Class bases_S55C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S55C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S55C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S55C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S55C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S55C3[];
extern void _ZN5S55C3D1Ev();
extern void _ZN5S55C3D0Ev();
extern void _ZN5S55C72v3Ev();
extern void _ZN5S55C72v4Ev();
extern void _ZN5S55C72v5Ev();
extern void _ZN5S55C72v6Ev();
extern void _ZN5S55C72v7Ev();
extern void _ZN5S55C72v8Ev();
extern void _ZN5S55C72v9Ev();
extern void _ZN5S55C73v10Ev();
extern void _ZN5S55C73v11Ev();
extern void _ZN5S55C73v12Ev();
extern void _ZN5S55C73v13Ev();
extern void _ZN5S55C73v14Ev();
extern void _ZN5S55C73v15Ev();
extern void _ZN5S55C73v16Ev();
extern void _ZN5S55C73v17Ev();
extern void _ZN5S55C73v18Ev();
extern void _ZN5S55C73v19Ev();
extern void _ZN5S55C73v20Ev();
extern void _ZN5S55C73v21Ev();
extern void _ZN5S55C73v22Ev();
extern void _ZN5S55C73v23Ev();
extern void _ZN5S55C73v24Ev();
extern void _ZN5S55C73v25Ev();
extern void _ZN5S55C73v26Ev();
extern void _ZN5S55C73v27Ev();
extern void _ZN5S55C73v28Ev();
extern void _ZN5S55C73v29Ev();
extern void _ZN5S55C73v30Ev();
extern void _ZN5S55C73v31Ev();
extern void _ZN5S55C73v32Ev();
extern void _ZN5S55C73v33Ev();
extern void _ZN5S55C73v34Ev();
extern void _ZN5S55C73v35Ev();
extern void _ZN5S55C73v36Ev();
extern void _ZN5S55C73v37Ev();
extern void _ZN5S55C73v38Ev();
extern void _ZN5S55C73v39Ev();
extern void _ZN5S55C73v40Ev();
extern void _ZN5S55C73v41Ev();
extern void _ZN5S55C73v42Ev();
extern void _ZN5S55C73v43Ev();
extern void _ZN5S55C73v44Ev();
extern void _ZN5S55C73v45Ev();
extern void _ZN5S55C73v46Ev();
extern void _ZN5S55C73v47Ev();
extern void _ZN5S55C73v48Ev();
extern void _ZN5S55C73v49Ev();
extern void _ZN5S55C73v50Ev();
extern void _ZN5S55C73v51Ev();
extern void _ZN5S55C73v52Ev();
extern void _ZN5S55C73v53Ev();
extern void _ZN5S55C73v54Ev();
extern void _ZN5S55C73v55Ev();
extern void _ZN5S55C73v56Ev();
extern void _ZN5S55C73v57Ev();
extern void _ZN5S55C73v58Ev();
extern void _ZN5S55C73v59Ev();
extern void _ZN5S55C73v60Ev();
extern void _ZN5S55C73v61Ev();
extern void _ZN5S55C73v62Ev();
extern void _ZN5S55C73v63Ev();
extern void _ZN5S55C73v64Ev();
extern void _ZN5S55C73v65Ev();
extern void _ZN5S55C73v66Ev();
extern void _ZN5S55C63v67Ev();
extern void _ZN5S55C63v68Ev();
extern void _ZN5S55C63v69Ev();
extern void _ZN5S55C63v70Ev();
extern void _ZN5S55C63v71Ev();
extern void _ZN5S55C63v72Ev();
extern void _ZN5S55C63v73Ev();
extern void _ZN5S55C63v74Ev();
extern void _ZN5S55C63v75Ev();
extern void _ZN5S55C63v76Ev();
extern void _ZN5S55C63v77Ev();
extern void _ZN5S55C63v78Ev();
extern void _ZN5S55C63v79Ev();
extern void _ZN5S55C63v80Ev();
extern void _ZN5S55C63v81Ev();
extern void _ZN5S55C63v82Ev();
extern void _ZN5S55C63v83Ev();
extern void _ZN5S55C63v84Ev();
extern void _ZN5S55C63v85Ev();
extern void _ZN5S55C63v86Ev();
extern void _ZN5S55C63v87Ev();
extern void _ZN5S55C63v88Ev();
extern void _ZN5S55C53v89Ev();
extern void _ZN5S55C53v90Ev();
extern void _ZN5S55C53v91Ev();
extern void _ZN5S55C53v92Ev();
extern void _ZN5S55C53v93Ev();
extern void _ZN5S55C53v94Ev();
extern void _ZN5S55C53v95Ev();
extern void _ZN5S55C53v96Ev();
extern void _ZN5S55C53v97Ev();
extern void _ZN5S55C53v98Ev();
extern void _ZN5S55C53v99Ev();
extern void _ZN5S55C54v100Ev();
extern void _ZN5S55C54v101Ev();
extern void _ZN5S55C54v102Ev();
extern void _ZN5S55C54v103Ev();
extern void _ZN5S55C54v104Ev();
extern void _ZN5S55C54v105Ev();
extern void _ZN5S55C54v106Ev();
extern void _ZN5S55C54v107Ev();
extern void _ZN5S55C54v108Ev();
extern void _ZN5S55C44v109Ev();
extern void _ZN5S55C44v110Ev();
extern void _ZN5S55C44v111Ev();
extern void _ZN5S55C44v112Ev();
extern void _ZN5S55C44v113Ev();
extern void _ZN5S55C44v114Ev();
extern void _ZN5S55C44v115Ev();
extern void _ZN5S55C44v116Ev();
extern void _ZN5S55C44v117Ev();
extern void _ZN5S55C44v118Ev();
extern void _ZN5S55C44v119Ev();
extern void _ZN5S55C44v120Ev();
extern void _ZN5S55C44v121Ev();
extern void _ZN5S55C44v122Ev();
extern void _ZN5S55C34v123Ev();
extern void _ZN5S55C34v124Ev();
extern void _ZN5S55C34v125Ev();
extern void _ZN5S55C34v126Ev();
extern void _ZN5S55C34v127Ev();
extern void _ZN5S55C34v128Ev();
extern void _ZN5S55C34v129Ev();
extern void _ZN5S55C34v130Ev();
extern void _ZN5S55C34v131Ev();
extern void _ZN5S55C34v132Ev();
extern void _ZN5S55C34v133Ev();
static  VTBL_ENTRY vtc_S55C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S55C3[0]),
  (VTBL_ENTRY)&_ZN5S55C3D1Ev,
  (VTBL_ENTRY)&_ZN5S55C3D0Ev,
  (VTBL_ENTRY)&_ZN5S55C72v3Ev,
  (VTBL_ENTRY)&_ZN5S55C72v4Ev,
  (VTBL_ENTRY)&_ZN5S55C72v5Ev,
  (VTBL_ENTRY)&_ZN5S55C72v6Ev,
  (VTBL_ENTRY)&_ZN5S55C72v7Ev,
  (VTBL_ENTRY)&_ZN5S55C72v8Ev,
  (VTBL_ENTRY)&_ZN5S55C72v9Ev,
  (VTBL_ENTRY)&_ZN5S55C73v10Ev,
  (VTBL_ENTRY)&_ZN5S55C73v11Ev,
  (VTBL_ENTRY)&_ZN5S55C73v12Ev,
  (VTBL_ENTRY)&_ZN5S55C73v13Ev,
  (VTBL_ENTRY)&_ZN5S55C73v14Ev,
  (VTBL_ENTRY)&_ZN5S55C73v15Ev,
  (VTBL_ENTRY)&_ZN5S55C73v16Ev,
  (VTBL_ENTRY)&_ZN5S55C73v17Ev,
  (VTBL_ENTRY)&_ZN5S55C73v18Ev,
  (VTBL_ENTRY)&_ZN5S55C73v19Ev,
  (VTBL_ENTRY)&_ZN5S55C73v20Ev,
  (VTBL_ENTRY)&_ZN5S55C73v21Ev,
  (VTBL_ENTRY)&_ZN5S55C73v22Ev,
  (VTBL_ENTRY)&_ZN5S55C73v23Ev,
  (VTBL_ENTRY)&_ZN5S55C73v24Ev,
  (VTBL_ENTRY)&_ZN5S55C73v25Ev,
  (VTBL_ENTRY)&_ZN5S55C73v26Ev,
  (VTBL_ENTRY)&_ZN5S55C73v27Ev,
  (VTBL_ENTRY)&_ZN5S55C73v28Ev,
  (VTBL_ENTRY)&_ZN5S55C73v29Ev,
  (VTBL_ENTRY)&_ZN5S55C73v30Ev,
  (VTBL_ENTRY)&_ZN5S55C73v31Ev,
  (VTBL_ENTRY)&_ZN5S55C73v32Ev,
  (VTBL_ENTRY)&_ZN5S55C73v33Ev,
  (VTBL_ENTRY)&_ZN5S55C73v34Ev,
  (VTBL_ENTRY)&_ZN5S55C73v35Ev,
  (VTBL_ENTRY)&_ZN5S55C73v36Ev,
  (VTBL_ENTRY)&_ZN5S55C73v37Ev,
  (VTBL_ENTRY)&_ZN5S55C73v38Ev,
  (VTBL_ENTRY)&_ZN5S55C73v39Ev,
  (VTBL_ENTRY)&_ZN5S55C73v40Ev,
  (VTBL_ENTRY)&_ZN5S55C73v41Ev,
  (VTBL_ENTRY)&_ZN5S55C73v42Ev,
  (VTBL_ENTRY)&_ZN5S55C73v43Ev,
  (VTBL_ENTRY)&_ZN5S55C73v44Ev,
  (VTBL_ENTRY)&_ZN5S55C73v45Ev,
  (VTBL_ENTRY)&_ZN5S55C73v46Ev,
  (VTBL_ENTRY)&_ZN5S55C73v47Ev,
  (VTBL_ENTRY)&_ZN5S55C73v48Ev,
  (VTBL_ENTRY)&_ZN5S55C73v49Ev,
  (VTBL_ENTRY)&_ZN5S55C73v50Ev,
  (VTBL_ENTRY)&_ZN5S55C73v51Ev,
  (VTBL_ENTRY)&_ZN5S55C73v52Ev,
  (VTBL_ENTRY)&_ZN5S55C73v53Ev,
  (VTBL_ENTRY)&_ZN5S55C73v54Ev,
  (VTBL_ENTRY)&_ZN5S55C73v55Ev,
  (VTBL_ENTRY)&_ZN5S55C73v56Ev,
  (VTBL_ENTRY)&_ZN5S55C73v57Ev,
  (VTBL_ENTRY)&_ZN5S55C73v58Ev,
  (VTBL_ENTRY)&_ZN5S55C73v59Ev,
  (VTBL_ENTRY)&_ZN5S55C73v60Ev,
  (VTBL_ENTRY)&_ZN5S55C73v61Ev,
  (VTBL_ENTRY)&_ZN5S55C73v62Ev,
  (VTBL_ENTRY)&_ZN5S55C73v63Ev,
  (VTBL_ENTRY)&_ZN5S55C73v64Ev,
  (VTBL_ENTRY)&_ZN5S55C73v65Ev,
  (VTBL_ENTRY)&_ZN5S55C73v66Ev,
  (VTBL_ENTRY)&_ZN5S55C63v67Ev,
  (VTBL_ENTRY)&_ZN5S55C63v68Ev,
  (VTBL_ENTRY)&_ZN5S55C63v69Ev,
  (VTBL_ENTRY)&_ZN5S55C63v70Ev,
  (VTBL_ENTRY)&_ZN5S55C63v71Ev,
  (VTBL_ENTRY)&_ZN5S55C63v72Ev,
  (VTBL_ENTRY)&_ZN5S55C63v73Ev,
  (VTBL_ENTRY)&_ZN5S55C63v74Ev,
  (VTBL_ENTRY)&_ZN5S55C63v75Ev,
  (VTBL_ENTRY)&_ZN5S55C63v76Ev,
  (VTBL_ENTRY)&_ZN5S55C63v77Ev,
  (VTBL_ENTRY)&_ZN5S55C63v78Ev,
  (VTBL_ENTRY)&_ZN5S55C63v79Ev,
  (VTBL_ENTRY)&_ZN5S55C63v80Ev,
  (VTBL_ENTRY)&_ZN5S55C63v81Ev,
  (VTBL_ENTRY)&_ZN5S55C63v82Ev,
  (VTBL_ENTRY)&_ZN5S55C63v83Ev,
  (VTBL_ENTRY)&_ZN5S55C63v84Ev,
  (VTBL_ENTRY)&_ZN5S55C63v85Ev,
  (VTBL_ENTRY)&_ZN5S55C63v86Ev,
  (VTBL_ENTRY)&_ZN5S55C63v87Ev,
  (VTBL_ENTRY)&_ZN5S55C63v88Ev,
  (VTBL_ENTRY)&_ZN5S55C53v89Ev,
  (VTBL_ENTRY)&_ZN5S55C53v90Ev,
  (VTBL_ENTRY)&_ZN5S55C53v91Ev,
  (VTBL_ENTRY)&_ZN5S55C53v92Ev,
  (VTBL_ENTRY)&_ZN5S55C53v93Ev,
  (VTBL_ENTRY)&_ZN5S55C53v94Ev,
  (VTBL_ENTRY)&_ZN5S55C53v95Ev,
  (VTBL_ENTRY)&_ZN5S55C53v96Ev,
  (VTBL_ENTRY)&_ZN5S55C53v97Ev,
  (VTBL_ENTRY)&_ZN5S55C53v98Ev,
  (VTBL_ENTRY)&_ZN5S55C53v99Ev,
  (VTBL_ENTRY)&_ZN5S55C54v100Ev,
  (VTBL_ENTRY)&_ZN5S55C54v101Ev,
  (VTBL_ENTRY)&_ZN5S55C54v102Ev,
  (VTBL_ENTRY)&_ZN5S55C54v103Ev,
  (VTBL_ENTRY)&_ZN5S55C54v104Ev,
  (VTBL_ENTRY)&_ZN5S55C54v105Ev,
  (VTBL_ENTRY)&_ZN5S55C54v106Ev,
  (VTBL_ENTRY)&_ZN5S55C54v107Ev,
  (VTBL_ENTRY)&_ZN5S55C54v108Ev,
  (VTBL_ENTRY)&_ZN5S55C44v109Ev,
  (VTBL_ENTRY)&_ZN5S55C44v110Ev,
  (VTBL_ENTRY)&_ZN5S55C44v111Ev,
  (VTBL_ENTRY)&_ZN5S55C44v112Ev,
  (VTBL_ENTRY)&_ZN5S55C44v113Ev,
  (VTBL_ENTRY)&_ZN5S55C44v114Ev,
  (VTBL_ENTRY)&_ZN5S55C44v115Ev,
  (VTBL_ENTRY)&_ZN5S55C44v116Ev,
  (VTBL_ENTRY)&_ZN5S55C44v117Ev,
  (VTBL_ENTRY)&_ZN5S55C44v118Ev,
  (VTBL_ENTRY)&_ZN5S55C44v119Ev,
  (VTBL_ENTRY)&_ZN5S55C44v120Ev,
  (VTBL_ENTRY)&_ZN5S55C44v121Ev,
  (VTBL_ENTRY)&_ZN5S55C44v122Ev,
  (VTBL_ENTRY)&_ZN5S55C34v123Ev,
  (VTBL_ENTRY)&_ZN5S55C34v124Ev,
  (VTBL_ENTRY)&_ZN5S55C34v125Ev,
  (VTBL_ENTRY)&_ZN5S55C34v126Ev,
  (VTBL_ENTRY)&_ZN5S55C34v127Ev,
  (VTBL_ENTRY)&_ZN5S55C34v128Ev,
  (VTBL_ENTRY)&_ZN5S55C34v129Ev,
  (VTBL_ENTRY)&_ZN5S55C34v130Ev,
  (VTBL_ENTRY)&_ZN5S55C34v131Ev,
  (VTBL_ENTRY)&_ZN5S55C34v132Ev,
  (VTBL_ENTRY)&_ZN5S55C34v133Ev,
};
extern VTBL_ENTRY _ZTI5S55C3[];
extern  VTBL_ENTRY _ZTV5S55C3[];
Class_Descriptor cd_S55C3 = {  "S55C3", // class name
  bases_S55C3, 4,
  &(vtc_S55C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(392,280), // object size
  NSPAIRA(_ZTI5S55C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S55C3),135, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S55C2  : S55C3 {
  virtual  ~S55C2(); // _ZN5S55C2D1Ev
  virtual void  v134(); // _ZN5S55C24v134Ev
  virtual void  v135(); // _ZN5S55C24v135Ev
  virtual void  v136(); // _ZN5S55C24v136Ev
  S55C2(); // tgen
};
//SIG(-1 S55C2) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 Fi[2] Fp Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 FC12{ m} FC8 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 Fi:1 Fi:1 Fi:1 FC13{ BC14{ BC11}} FC15{ BC16{ BC11}} FC17{ BC18{ BC11}} FC19{ BC20{ BC11}} Fi[3]} vd v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 Fp[2] Fi[4] Fi:1 Fi:1 Fi:1 Fc Fi Fi:1 FC21{ BC22{ BC11}}} vd v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 Fp[2] FC8 Fi:1 Fi:1 FC23{ m Fp FC7}} vd v1 v2 v3}


 S55C2 ::~S55C2(){ note_dtor("S55C2", this);}
void  S55C2 ::v134(){vfunc_called(this, "_ZN5S55C24v134Ev");}
void  S55C2 ::v135(){vfunc_called(this, "_ZN5S55C24v135Ev");}
void  S55C2 ::v136(){vfunc_called(this, "_ZN5S55C24v136Ev");}
S55C2 ::S55C2(){ note_ctor("S55C2", this);} // tgen

static void Test_S55C2()
{
  extern Class_Descriptor cd_S55C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(50,71)];
    init_test(&cd_S55C2, buf);
    S55C2 *dp, &lv = *(dp=new (buf) S55C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(392,280), "sizeof(S55C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S55C2)");
    check_base_class_offset(lv, (S55C7*)(S55C6*)(S55C5*)(S55C4*)(S55C3*), 0, "S55C2");
    check_base_class_offset(lv, (S55C6*)(S55C5*)(S55C4*)(S55C3*), 0, "S55C2");
    check_base_class_offset(lv, (S55C5*)(S55C4*)(S55C3*), 0, "S55C2");
    check_base_class_offset(lv, (S55C4*)(S55C3*), 0, "S55C2");
    check_base_class_offset(lv, (S55C3*), 0, "S55C2");
    test_class_info(&lv, &cd_S55C2);
    dp->~S55C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS55C2(Test_S55C2, "S55C2", ABISELECT(392,280));

#else // __cplusplus

extern void _ZN5S55C2C1Ev();
extern void _ZN5S55C2D1Ev();
Name_Map name_map_S55C2[] = {
  NSPAIR(_ZN5S55C2C1Ev),
  NSPAIR(_ZN5S55C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S55C7;
extern VTBL_ENTRY _ZTI5S55C7[];
extern  VTBL_ENTRY _ZTV5S55C7[];
extern Class_Descriptor cd_S55C6;
extern VTBL_ENTRY _ZTI5S55C6[];
extern  VTBL_ENTRY _ZTV5S55C6[];
extern Class_Descriptor cd_S55C5;
extern VTBL_ENTRY _ZTI5S55C5[];
extern  VTBL_ENTRY _ZTV5S55C5[];
extern Class_Descriptor cd_S55C4;
extern VTBL_ENTRY _ZTI5S55C4[];
extern  VTBL_ENTRY _ZTV5S55C4[];
extern Class_Descriptor cd_S55C3;
extern VTBL_ENTRY _ZTI5S55C3[];
extern  VTBL_ENTRY _ZTV5S55C3[];
static Base_Class bases_S55C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S55C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S55C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S55C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S55C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S55C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S55C2[];
extern void _ZN5S55C2D1Ev();
extern void _ZN5S55C2D0Ev();
extern void _ZN5S55C72v3Ev();
extern void _ZN5S55C72v4Ev();
extern void _ZN5S55C72v5Ev();
extern void _ZN5S55C72v6Ev();
extern void _ZN5S55C72v7Ev();
extern void _ZN5S55C72v8Ev();
extern void _ZN5S55C72v9Ev();
extern void _ZN5S55C73v10Ev();
extern void _ZN5S55C73v11Ev();
extern void _ZN5S55C73v12Ev();
extern void _ZN5S55C73v13Ev();
extern void _ZN5S55C73v14Ev();
extern void _ZN5S55C73v15Ev();
extern void _ZN5S55C73v16Ev();
extern void _ZN5S55C73v17Ev();
extern void _ZN5S55C73v18Ev();
extern void _ZN5S55C73v19Ev();
extern void _ZN5S55C73v20Ev();
extern void _ZN5S55C73v21Ev();
extern void _ZN5S55C73v22Ev();
extern void _ZN5S55C73v23Ev();
extern void _ZN5S55C73v24Ev();
extern void _ZN5S55C73v25Ev();
extern void _ZN5S55C73v26Ev();
extern void _ZN5S55C73v27Ev();
extern void _ZN5S55C73v28Ev();
extern void _ZN5S55C73v29Ev();
extern void _ZN5S55C73v30Ev();
extern void _ZN5S55C73v31Ev();
extern void _ZN5S55C73v32Ev();
extern void _ZN5S55C73v33Ev();
extern void _ZN5S55C73v34Ev();
extern void _ZN5S55C73v35Ev();
extern void _ZN5S55C73v36Ev();
extern void _ZN5S55C73v37Ev();
extern void _ZN5S55C73v38Ev();
extern void _ZN5S55C73v39Ev();
extern void _ZN5S55C73v40Ev();
extern void _ZN5S55C73v41Ev();
extern void _ZN5S55C73v42Ev();
extern void _ZN5S55C73v43Ev();
extern void _ZN5S55C73v44Ev();
extern void _ZN5S55C73v45Ev();
extern void _ZN5S55C73v46Ev();
extern void _ZN5S55C73v47Ev();
extern void _ZN5S55C73v48Ev();
extern void _ZN5S55C73v49Ev();
extern void _ZN5S55C73v50Ev();
extern void _ZN5S55C73v51Ev();
extern void _ZN5S55C73v52Ev();
extern void _ZN5S55C73v53Ev();
extern void _ZN5S55C73v54Ev();
extern void _ZN5S55C73v55Ev();
extern void _ZN5S55C73v56Ev();
extern void _ZN5S55C73v57Ev();
extern void _ZN5S55C73v58Ev();
extern void _ZN5S55C73v59Ev();
extern void _ZN5S55C73v60Ev();
extern void _ZN5S55C73v61Ev();
extern void _ZN5S55C73v62Ev();
extern void _ZN5S55C73v63Ev();
extern void _ZN5S55C73v64Ev();
extern void _ZN5S55C73v65Ev();
extern void _ZN5S55C73v66Ev();
extern void _ZN5S55C63v67Ev();
extern void _ZN5S55C63v68Ev();
extern void _ZN5S55C63v69Ev();
extern void _ZN5S55C63v70Ev();
extern void _ZN5S55C63v71Ev();
extern void _ZN5S55C63v72Ev();
extern void _ZN5S55C63v73Ev();
extern void _ZN5S55C63v74Ev();
extern void _ZN5S55C63v75Ev();
extern void _ZN5S55C63v76Ev();
extern void _ZN5S55C63v77Ev();
extern void _ZN5S55C63v78Ev();
extern void _ZN5S55C63v79Ev();
extern void _ZN5S55C63v80Ev();
extern void _ZN5S55C63v81Ev();
extern void _ZN5S55C63v82Ev();
extern void _ZN5S55C63v83Ev();
extern void _ZN5S55C63v84Ev();
extern void _ZN5S55C63v85Ev();
extern void _ZN5S55C63v86Ev();
extern void _ZN5S55C63v87Ev();
extern void _ZN5S55C63v88Ev();
extern void _ZN5S55C53v89Ev();
extern void _ZN5S55C53v90Ev();
extern void _ZN5S55C53v91Ev();
extern void _ZN5S55C53v92Ev();
extern void _ZN5S55C53v93Ev();
extern void _ZN5S55C53v94Ev();
extern void _ZN5S55C53v95Ev();
extern void _ZN5S55C53v96Ev();
extern void _ZN5S55C53v97Ev();
extern void _ZN5S55C53v98Ev();
extern void _ZN5S55C53v99Ev();
extern void _ZN5S55C54v100Ev();
extern void _ZN5S55C54v101Ev();
extern void _ZN5S55C54v102Ev();
extern void _ZN5S55C54v103Ev();
extern void _ZN5S55C54v104Ev();
extern void _ZN5S55C54v105Ev();
extern void _ZN5S55C54v106Ev();
extern void _ZN5S55C54v107Ev();
extern void _ZN5S55C54v108Ev();
extern void _ZN5S55C44v109Ev();
extern void _ZN5S55C44v110Ev();
extern void _ZN5S55C44v111Ev();
extern void _ZN5S55C44v112Ev();
extern void _ZN5S55C44v113Ev();
extern void _ZN5S55C44v114Ev();
extern void _ZN5S55C44v115Ev();
extern void _ZN5S55C44v116Ev();
extern void _ZN5S55C44v117Ev();
extern void _ZN5S55C44v118Ev();
extern void _ZN5S55C44v119Ev();
extern void _ZN5S55C44v120Ev();
extern void _ZN5S55C44v121Ev();
extern void _ZN5S55C44v122Ev();
extern void _ZN5S55C34v123Ev();
extern void _ZN5S55C34v124Ev();
extern void _ZN5S55C34v125Ev();
extern void _ZN5S55C34v126Ev();
extern void _ZN5S55C34v127Ev();
extern void _ZN5S55C34v128Ev();
extern void _ZN5S55C34v129Ev();
extern void _ZN5S55C34v130Ev();
extern void _ZN5S55C34v131Ev();
extern void _ZN5S55C34v132Ev();
extern void _ZN5S55C34v133Ev();
extern void _ZN5S55C24v134Ev();
extern void _ZN5S55C24v135Ev();
extern void _ZN5S55C24v136Ev();
static  VTBL_ENTRY vtc_S55C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S55C2[0]),
  (VTBL_ENTRY)&_ZN5S55C2D1Ev,
  (VTBL_ENTRY)&_ZN5S55C2D0Ev,
  (VTBL_ENTRY)&_ZN5S55C72v3Ev,
  (VTBL_ENTRY)&_ZN5S55C72v4Ev,
  (VTBL_ENTRY)&_ZN5S55C72v5Ev,
  (VTBL_ENTRY)&_ZN5S55C72v6Ev,
  (VTBL_ENTRY)&_ZN5S55C72v7Ev,
  (VTBL_ENTRY)&_ZN5S55C72v8Ev,
  (VTBL_ENTRY)&_ZN5S55C72v9Ev,
  (VTBL_ENTRY)&_ZN5S55C73v10Ev,
  (VTBL_ENTRY)&_ZN5S55C73v11Ev,
  (VTBL_ENTRY)&_ZN5S55C73v12Ev,
  (VTBL_ENTRY)&_ZN5S55C73v13Ev,
  (VTBL_ENTRY)&_ZN5S55C73v14Ev,
  (VTBL_ENTRY)&_ZN5S55C73v15Ev,
  (VTBL_ENTRY)&_ZN5S55C73v16Ev,
  (VTBL_ENTRY)&_ZN5S55C73v17Ev,
  (VTBL_ENTRY)&_ZN5S55C73v18Ev,
  (VTBL_ENTRY)&_ZN5S55C73v19Ev,
  (VTBL_ENTRY)&_ZN5S55C73v20Ev,
  (VTBL_ENTRY)&_ZN5S55C73v21Ev,
  (VTBL_ENTRY)&_ZN5S55C73v22Ev,
  (VTBL_ENTRY)&_ZN5S55C73v23Ev,
  (VTBL_ENTRY)&_ZN5S55C73v24Ev,
  (VTBL_ENTRY)&_ZN5S55C73v25Ev,
  (VTBL_ENTRY)&_ZN5S55C73v26Ev,
  (VTBL_ENTRY)&_ZN5S55C73v27Ev,
  (VTBL_ENTRY)&_ZN5S55C73v28Ev,
  (VTBL_ENTRY)&_ZN5S55C73v29Ev,
  (VTBL_ENTRY)&_ZN5S55C73v30Ev,
  (VTBL_ENTRY)&_ZN5S55C73v31Ev,
  (VTBL_ENTRY)&_ZN5S55C73v32Ev,
  (VTBL_ENTRY)&_ZN5S55C73v33Ev,
  (VTBL_ENTRY)&_ZN5S55C73v34Ev,
  (VTBL_ENTRY)&_ZN5S55C73v35Ev,
  (VTBL_ENTRY)&_ZN5S55C73v36Ev,
  (VTBL_ENTRY)&_ZN5S55C73v37Ev,
  (VTBL_ENTRY)&_ZN5S55C73v38Ev,
  (VTBL_ENTRY)&_ZN5S55C73v39Ev,
  (VTBL_ENTRY)&_ZN5S55C73v40Ev,
  (VTBL_ENTRY)&_ZN5S55C73v41Ev,
  (VTBL_ENTRY)&_ZN5S55C73v42Ev,
  (VTBL_ENTRY)&_ZN5S55C73v43Ev,
  (VTBL_ENTRY)&_ZN5S55C73v44Ev,
  (VTBL_ENTRY)&_ZN5S55C73v45Ev,
  (VTBL_ENTRY)&_ZN5S55C73v46Ev,
  (VTBL_ENTRY)&_ZN5S55C73v47Ev,
  (VTBL_ENTRY)&_ZN5S55C73v48Ev,
  (VTBL_ENTRY)&_ZN5S55C73v49Ev,
  (VTBL_ENTRY)&_ZN5S55C73v50Ev,
  (VTBL_ENTRY)&_ZN5S55C73v51Ev,
  (VTBL_ENTRY)&_ZN5S55C73v52Ev,
  (VTBL_ENTRY)&_ZN5S55C73v53Ev,
  (VTBL_ENTRY)&_ZN5S55C73v54Ev,
  (VTBL_ENTRY)&_ZN5S55C73v55Ev,
  (VTBL_ENTRY)&_ZN5S55C73v56Ev,
  (VTBL_ENTRY)&_ZN5S55C73v57Ev,
  (VTBL_ENTRY)&_ZN5S55C73v58Ev,
  (VTBL_ENTRY)&_ZN5S55C73v59Ev,
  (VTBL_ENTRY)&_ZN5S55C73v60Ev,
  (VTBL_ENTRY)&_ZN5S55C73v61Ev,
  (VTBL_ENTRY)&_ZN5S55C73v62Ev,
  (VTBL_ENTRY)&_ZN5S55C73v63Ev,
  (VTBL_ENTRY)&_ZN5S55C73v64Ev,
  (VTBL_ENTRY)&_ZN5S55C73v65Ev,
  (VTBL_ENTRY)&_ZN5S55C73v66Ev,
  (VTBL_ENTRY)&_ZN5S55C63v67Ev,
  (VTBL_ENTRY)&_ZN5S55C63v68Ev,
  (VTBL_ENTRY)&_ZN5S55C63v69Ev,
  (VTBL_ENTRY)&_ZN5S55C63v70Ev,
  (VTBL_ENTRY)&_ZN5S55C63v71Ev,
  (VTBL_ENTRY)&_ZN5S55C63v72Ev,
  (VTBL_ENTRY)&_ZN5S55C63v73Ev,
  (VTBL_ENTRY)&_ZN5S55C63v74Ev,
  (VTBL_ENTRY)&_ZN5S55C63v75Ev,
  (VTBL_ENTRY)&_ZN5S55C63v76Ev,
  (VTBL_ENTRY)&_ZN5S55C63v77Ev,
  (VTBL_ENTRY)&_ZN5S55C63v78Ev,
  (VTBL_ENTRY)&_ZN5S55C63v79Ev,
  (VTBL_ENTRY)&_ZN5S55C63v80Ev,
  (VTBL_ENTRY)&_ZN5S55C63v81Ev,
  (VTBL_ENTRY)&_ZN5S55C63v82Ev,
  (VTBL_ENTRY)&_ZN5S55C63v83Ev,
  (VTBL_ENTRY)&_ZN5S55C63v84Ev,
  (VTBL_ENTRY)&_ZN5S55C63v85Ev,
  (VTBL_ENTRY)&_ZN5S55C63v86Ev,
  (VTBL_ENTRY)&_ZN5S55C63v87Ev,
  (VTBL_ENTRY)&_ZN5S55C63v88Ev,
  (VTBL_ENTRY)&_ZN5S55C53v89Ev,
  (VTBL_ENTRY)&_ZN5S55C53v90Ev,
  (VTBL_ENTRY)&_ZN5S55C53v91Ev,
  (VTBL_ENTRY)&_ZN5S55C53v92Ev,
  (VTBL_ENTRY)&_ZN5S55C53v93Ev,
  (VTBL_ENTRY)&_ZN5S55C53v94Ev,
  (VTBL_ENTRY)&_ZN5S55C53v95Ev,
  (VTBL_ENTRY)&_ZN5S55C53v96Ev,
  (VTBL_ENTRY)&_ZN5S55C53v97Ev,
  (VTBL_ENTRY)&_ZN5S55C53v98Ev,
  (VTBL_ENTRY)&_ZN5S55C53v99Ev,
  (VTBL_ENTRY)&_ZN5S55C54v100Ev,
  (VTBL_ENTRY)&_ZN5S55C54v101Ev,
  (VTBL_ENTRY)&_ZN5S55C54v102Ev,
  (VTBL_ENTRY)&_ZN5S55C54v103Ev,
  (VTBL_ENTRY)&_ZN5S55C54v104Ev,
  (VTBL_ENTRY)&_ZN5S55C54v105Ev,
  (VTBL_ENTRY)&_ZN5S55C54v106Ev,
  (VTBL_ENTRY)&_ZN5S55C54v107Ev,
  (VTBL_ENTRY)&_ZN5S55C54v108Ev,
  (VTBL_ENTRY)&_ZN5S55C44v109Ev,
  (VTBL_ENTRY)&_ZN5S55C44v110Ev,
  (VTBL_ENTRY)&_ZN5S55C44v111Ev,
  (VTBL_ENTRY)&_ZN5S55C44v112Ev,
  (VTBL_ENTRY)&_ZN5S55C44v113Ev,
  (VTBL_ENTRY)&_ZN5S55C44v114Ev,
  (VTBL_ENTRY)&_ZN5S55C44v115Ev,
  (VTBL_ENTRY)&_ZN5S55C44v116Ev,
  (VTBL_ENTRY)&_ZN5S55C44v117Ev,
  (VTBL_ENTRY)&_ZN5S55C44v118Ev,
  (VTBL_ENTRY)&_ZN5S55C44v119Ev,
  (VTBL_ENTRY)&_ZN5S55C44v120Ev,
  (VTBL_ENTRY)&_ZN5S55C44v121Ev,
  (VTBL_ENTRY)&_ZN5S55C44v122Ev,
  (VTBL_ENTRY)&_ZN5S55C34v123Ev,
  (VTBL_ENTRY)&_ZN5S55C34v124Ev,
  (VTBL_ENTRY)&_ZN5S55C34v125Ev,
  (VTBL_ENTRY)&_ZN5S55C34v126Ev,
  (VTBL_ENTRY)&_ZN5S55C34v127Ev,
  (VTBL_ENTRY)&_ZN5S55C34v128Ev,
  (VTBL_ENTRY)&_ZN5S55C34v129Ev,
  (VTBL_ENTRY)&_ZN5S55C34v130Ev,
  (VTBL_ENTRY)&_ZN5S55C34v131Ev,
  (VTBL_ENTRY)&_ZN5S55C34v132Ev,
  (VTBL_ENTRY)&_ZN5S55C34v133Ev,
  (VTBL_ENTRY)&_ZN5S55C24v134Ev,
  (VTBL_ENTRY)&_ZN5S55C24v135Ev,
  (VTBL_ENTRY)&_ZN5S55C24v136Ev,
};
extern VTBL_ENTRY _ZTI5S55C2[];
extern  VTBL_ENTRY _ZTV5S55C2[];
Class_Descriptor cd_S55C2 = {  "S55C2", // class name
  bases_S55C2, 5,
  &(vtc_S55C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(392,280), // object size
  NSPAIRA(_ZTI5S55C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S55C2),138, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S55C1  : S55C2 {
  virtual  ~S55C1(); // _ZN5S55C1D1Ev
  virtual void  v1(); // _ZN5S55C12v1Ev
  virtual void  v2(); // _ZN5S55C12v2Ev
  S55C1(); // tgen
};
//SIG(1 S55C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC8{ m Fi[2]} Fp[2]} vd v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi[2] Fp Fi[2] FC9{ BC10{ BC11{ BC12{ m Fp Fi[2]}}}} FC9 FC13{ m} FC9 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 Fi:1 Fi:1 Fi:1 FC14{ BC15{ BC12}} FC16{ BC17{ BC12}} FC18{ BC19{ BC12}} FC20{ BC21{ BC12}} Fi[3]} vd v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 Fp[2] Fi[4] Fi:1 Fi:1 Fi:1 Fc Fi Fi:1 FC22{ BC23{ BC12}}} vd v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 Fp[2] FC9 Fi:1 Fi:1 FC24{ m Fp FC8}} vd v134 v135 v136} vd v1 v2}


 S55C1 ::~S55C1(){ note_dtor("S55C1", this);}
void  S55C1 ::v1(){vfunc_called(this, "_ZN5S55C12v1Ev");}
void  S55C1 ::v2(){vfunc_called(this, "_ZN5S55C12v2Ev");}
S55C1 ::S55C1(){ note_ctor("S55C1", this);} // tgen

static void Test_S55C1()
{
  extern Class_Descriptor cd_S55C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(50,71)];
    init_test(&cd_S55C1, buf);
    S55C1 *dp, &lv = *(dp=new (buf) S55C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(392,280), "sizeof(S55C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S55C1)");
    check_base_class_offset(lv, (S55C7*)(S55C6*)(S55C5*)(S55C4*)(S55C3*)(S55C2*), 0, "S55C1");
    check_base_class_offset(lv, (S55C6*)(S55C5*)(S55C4*)(S55C3*)(S55C2*), 0, "S55C1");
    check_base_class_offset(lv, (S55C5*)(S55C4*)(S55C3*)(S55C2*), 0, "S55C1");
    check_base_class_offset(lv, (S55C4*)(S55C3*)(S55C2*), 0, "S55C1");
    check_base_class_offset(lv, (S55C3*)(S55C2*), 0, "S55C1");
    check_base_class_offset(lv, (S55C2*), 0, "S55C1");
    test_class_info(&lv, &cd_S55C1);
    dp->~S55C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS55C1(Test_S55C1, "S55C1", ABISELECT(392,280));

#else // __cplusplus

extern void _ZN5S55C1C1Ev();
extern void _ZN5S55C1D1Ev();
Name_Map name_map_S55C1[] = {
  NSPAIR(_ZN5S55C1C1Ev),
  NSPAIR(_ZN5S55C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S55C7;
extern VTBL_ENTRY _ZTI5S55C7[];
extern  VTBL_ENTRY _ZTV5S55C7[];
extern Class_Descriptor cd_S55C6;
extern VTBL_ENTRY _ZTI5S55C6[];
extern  VTBL_ENTRY _ZTV5S55C6[];
extern Class_Descriptor cd_S55C5;
extern VTBL_ENTRY _ZTI5S55C5[];
extern  VTBL_ENTRY _ZTV5S55C5[];
extern Class_Descriptor cd_S55C4;
extern VTBL_ENTRY _ZTI5S55C4[];
extern  VTBL_ENTRY _ZTV5S55C4[];
extern Class_Descriptor cd_S55C3;
extern VTBL_ENTRY _ZTI5S55C3[];
extern  VTBL_ENTRY _ZTV5S55C3[];
extern Class_Descriptor cd_S55C2;
extern VTBL_ENTRY _ZTI5S55C2[];
extern  VTBL_ENTRY _ZTV5S55C2[];
static Base_Class bases_S55C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S55C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S55C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S55C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S55C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S55C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S55C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S55C1[];
extern void _ZN5S55C1D1Ev();
extern void _ZN5S55C1D0Ev();
extern void _ZN5S55C72v3Ev();
extern void _ZN5S55C72v4Ev();
extern void _ZN5S55C72v5Ev();
extern void _ZN5S55C72v6Ev();
extern void _ZN5S55C72v7Ev();
extern void _ZN5S55C72v8Ev();
extern void _ZN5S55C72v9Ev();
extern void _ZN5S55C73v10Ev();
extern void _ZN5S55C73v11Ev();
extern void _ZN5S55C73v12Ev();
extern void _ZN5S55C73v13Ev();
extern void _ZN5S55C73v14Ev();
extern void _ZN5S55C73v15Ev();
extern void _ZN5S55C73v16Ev();
extern void _ZN5S55C73v17Ev();
extern void _ZN5S55C73v18Ev();
extern void _ZN5S55C73v19Ev();
extern void _ZN5S55C73v20Ev();
extern void _ZN5S55C73v21Ev();
extern void _ZN5S55C73v22Ev();
extern void _ZN5S55C73v23Ev();
extern void _ZN5S55C73v24Ev();
extern void _ZN5S55C73v25Ev();
extern void _ZN5S55C73v26Ev();
extern void _ZN5S55C73v27Ev();
extern void _ZN5S55C73v28Ev();
extern void _ZN5S55C73v29Ev();
extern void _ZN5S55C73v30Ev();
extern void _ZN5S55C73v31Ev();
extern void _ZN5S55C73v32Ev();
extern void _ZN5S55C73v33Ev();
extern void _ZN5S55C73v34Ev();
extern void _ZN5S55C73v35Ev();
extern void _ZN5S55C73v36Ev();
extern void _ZN5S55C73v37Ev();
extern void _ZN5S55C73v38Ev();
extern void _ZN5S55C73v39Ev();
extern void _ZN5S55C73v40Ev();
extern void _ZN5S55C73v41Ev();
extern void _ZN5S55C73v42Ev();
extern void _ZN5S55C73v43Ev();
extern void _ZN5S55C73v44Ev();
extern void _ZN5S55C73v45Ev();
extern void _ZN5S55C73v46Ev();
extern void _ZN5S55C73v47Ev();
extern void _ZN5S55C73v48Ev();
extern void _ZN5S55C73v49Ev();
extern void _ZN5S55C73v50Ev();
extern void _ZN5S55C73v51Ev();
extern void _ZN5S55C73v52Ev();
extern void _ZN5S55C73v53Ev();
extern void _ZN5S55C73v54Ev();
extern void _ZN5S55C73v55Ev();
extern void _ZN5S55C73v56Ev();
extern void _ZN5S55C73v57Ev();
extern void _ZN5S55C73v58Ev();
extern void _ZN5S55C73v59Ev();
extern void _ZN5S55C73v60Ev();
extern void _ZN5S55C73v61Ev();
extern void _ZN5S55C73v62Ev();
extern void _ZN5S55C73v63Ev();
extern void _ZN5S55C73v64Ev();
extern void _ZN5S55C73v65Ev();
extern void _ZN5S55C73v66Ev();
extern void _ZN5S55C63v67Ev();
extern void _ZN5S55C63v68Ev();
extern void _ZN5S55C63v69Ev();
extern void _ZN5S55C63v70Ev();
extern void _ZN5S55C63v71Ev();
extern void _ZN5S55C63v72Ev();
extern void _ZN5S55C63v73Ev();
extern void _ZN5S55C63v74Ev();
extern void _ZN5S55C63v75Ev();
extern void _ZN5S55C63v76Ev();
extern void _ZN5S55C63v77Ev();
extern void _ZN5S55C63v78Ev();
extern void _ZN5S55C63v79Ev();
extern void _ZN5S55C63v80Ev();
extern void _ZN5S55C63v81Ev();
extern void _ZN5S55C63v82Ev();
extern void _ZN5S55C63v83Ev();
extern void _ZN5S55C63v84Ev();
extern void _ZN5S55C63v85Ev();
extern void _ZN5S55C63v86Ev();
extern void _ZN5S55C63v87Ev();
extern void _ZN5S55C63v88Ev();
extern void _ZN5S55C53v89Ev();
extern void _ZN5S55C53v90Ev();
extern void _ZN5S55C53v91Ev();
extern void _ZN5S55C53v92Ev();
extern void _ZN5S55C53v93Ev();
extern void _ZN5S55C53v94Ev();
extern void _ZN5S55C53v95Ev();
extern void _ZN5S55C53v96Ev();
extern void _ZN5S55C53v97Ev();
extern void _ZN5S55C53v98Ev();
extern void _ZN5S55C53v99Ev();
extern void _ZN5S55C54v100Ev();
extern void _ZN5S55C54v101Ev();
extern void _ZN5S55C54v102Ev();
extern void _ZN5S55C54v103Ev();
extern void _ZN5S55C54v104Ev();
extern void _ZN5S55C54v105Ev();
extern void _ZN5S55C54v106Ev();
extern void _ZN5S55C54v107Ev();
extern void _ZN5S55C54v108Ev();
extern void _ZN5S55C44v109Ev();
extern void _ZN5S55C44v110Ev();
extern void _ZN5S55C44v111Ev();
extern void _ZN5S55C44v112Ev();
extern void _ZN5S55C44v113Ev();
extern void _ZN5S55C44v114Ev();
extern void _ZN5S55C44v115Ev();
extern void _ZN5S55C44v116Ev();
extern void _ZN5S55C44v117Ev();
extern void _ZN5S55C44v118Ev();
extern void _ZN5S55C44v119Ev();
extern void _ZN5S55C44v120Ev();
extern void _ZN5S55C44v121Ev();
extern void _ZN5S55C44v122Ev();
extern void _ZN5S55C34v123Ev();
extern void _ZN5S55C34v124Ev();
extern void _ZN5S55C34v125Ev();
extern void _ZN5S55C34v126Ev();
extern void _ZN5S55C34v127Ev();
extern void _ZN5S55C34v128Ev();
extern void _ZN5S55C34v129Ev();
extern void _ZN5S55C34v130Ev();
extern void _ZN5S55C34v131Ev();
extern void _ZN5S55C34v132Ev();
extern void _ZN5S55C34v133Ev();
extern void _ZN5S55C24v134Ev();
extern void _ZN5S55C24v135Ev();
extern void _ZN5S55C24v136Ev();
extern void _ZN5S55C12v1Ev();
extern void _ZN5S55C12v2Ev();
static  VTBL_ENTRY vtc_S55C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S55C1[0]),
  (VTBL_ENTRY)&_ZN5S55C1D1Ev,
  (VTBL_ENTRY)&_ZN5S55C1D0Ev,
  (VTBL_ENTRY)&_ZN5S55C72v3Ev,
  (VTBL_ENTRY)&_ZN5S55C72v4Ev,
  (VTBL_ENTRY)&_ZN5S55C72v5Ev,
  (VTBL_ENTRY)&_ZN5S55C72v6Ev,
  (VTBL_ENTRY)&_ZN5S55C72v7Ev,
  (VTBL_ENTRY)&_ZN5S55C72v8Ev,
  (VTBL_ENTRY)&_ZN5S55C72v9Ev,
  (VTBL_ENTRY)&_ZN5S55C73v10Ev,
  (VTBL_ENTRY)&_ZN5S55C73v11Ev,
  (VTBL_ENTRY)&_ZN5S55C73v12Ev,
  (VTBL_ENTRY)&_ZN5S55C73v13Ev,
  (VTBL_ENTRY)&_ZN5S55C73v14Ev,
  (VTBL_ENTRY)&_ZN5S55C73v15Ev,
  (VTBL_ENTRY)&_ZN5S55C73v16Ev,
  (VTBL_ENTRY)&_ZN5S55C73v17Ev,
  (VTBL_ENTRY)&_ZN5S55C73v18Ev,
  (VTBL_ENTRY)&_ZN5S55C73v19Ev,
  (VTBL_ENTRY)&_ZN5S55C73v20Ev,
  (VTBL_ENTRY)&_ZN5S55C73v21Ev,
  (VTBL_ENTRY)&_ZN5S55C73v22Ev,
  (VTBL_ENTRY)&_ZN5S55C73v23Ev,
  (VTBL_ENTRY)&_ZN5S55C73v24Ev,
  (VTBL_ENTRY)&_ZN5S55C73v25Ev,
  (VTBL_ENTRY)&_ZN5S55C73v26Ev,
  (VTBL_ENTRY)&_ZN5S55C73v27Ev,
  (VTBL_ENTRY)&_ZN5S55C73v28Ev,
  (VTBL_ENTRY)&_ZN5S55C73v29Ev,
  (VTBL_ENTRY)&_ZN5S55C73v30Ev,
  (VTBL_ENTRY)&_ZN5S55C73v31Ev,
  (VTBL_ENTRY)&_ZN5S55C73v32Ev,
  (VTBL_ENTRY)&_ZN5S55C73v33Ev,
  (VTBL_ENTRY)&_ZN5S55C73v34Ev,
  (VTBL_ENTRY)&_ZN5S55C73v35Ev,
  (VTBL_ENTRY)&_ZN5S55C73v36Ev,
  (VTBL_ENTRY)&_ZN5S55C73v37Ev,
  (VTBL_ENTRY)&_ZN5S55C73v38Ev,
  (VTBL_ENTRY)&_ZN5S55C73v39Ev,
  (VTBL_ENTRY)&_ZN5S55C73v40Ev,
  (VTBL_ENTRY)&_ZN5S55C73v41Ev,
  (VTBL_ENTRY)&_ZN5S55C73v42Ev,
  (VTBL_ENTRY)&_ZN5S55C73v43Ev,
  (VTBL_ENTRY)&_ZN5S55C73v44Ev,
  (VTBL_ENTRY)&_ZN5S55C73v45Ev,
  (VTBL_ENTRY)&_ZN5S55C73v46Ev,
  (VTBL_ENTRY)&_ZN5S55C73v47Ev,
  (VTBL_ENTRY)&_ZN5S55C73v48Ev,
  (VTBL_ENTRY)&_ZN5S55C73v49Ev,
  (VTBL_ENTRY)&_ZN5S55C73v50Ev,
  (VTBL_ENTRY)&_ZN5S55C73v51Ev,
  (VTBL_ENTRY)&_ZN5S55C73v52Ev,
  (VTBL_ENTRY)&_ZN5S55C73v53Ev,
  (VTBL_ENTRY)&_ZN5S55C73v54Ev,
  (VTBL_ENTRY)&_ZN5S55C73v55Ev,
  (VTBL_ENTRY)&_ZN5S55C73v56Ev,
  (VTBL_ENTRY)&_ZN5S55C73v57Ev,
  (VTBL_ENTRY)&_ZN5S55C73v58Ev,
  (VTBL_ENTRY)&_ZN5S55C73v59Ev,
  (VTBL_ENTRY)&_ZN5S55C73v60Ev,
  (VTBL_ENTRY)&_ZN5S55C73v61Ev,
  (VTBL_ENTRY)&_ZN5S55C73v62Ev,
  (VTBL_ENTRY)&_ZN5S55C73v63Ev,
  (VTBL_ENTRY)&_ZN5S55C73v64Ev,
  (VTBL_ENTRY)&_ZN5S55C73v65Ev,
  (VTBL_ENTRY)&_ZN5S55C73v66Ev,
  (VTBL_ENTRY)&_ZN5S55C63v67Ev,
  (VTBL_ENTRY)&_ZN5S55C63v68Ev,
  (VTBL_ENTRY)&_ZN5S55C63v69Ev,
  (VTBL_ENTRY)&_ZN5S55C63v70Ev,
  (VTBL_ENTRY)&_ZN5S55C63v71Ev,
  (VTBL_ENTRY)&_ZN5S55C63v72Ev,
  (VTBL_ENTRY)&_ZN5S55C63v73Ev,
  (VTBL_ENTRY)&_ZN5S55C63v74Ev,
  (VTBL_ENTRY)&_ZN5S55C63v75Ev,
  (VTBL_ENTRY)&_ZN5S55C63v76Ev,
  (VTBL_ENTRY)&_ZN5S55C63v77Ev,
  (VTBL_ENTRY)&_ZN5S55C63v78Ev,
  (VTBL_ENTRY)&_ZN5S55C63v79Ev,
  (VTBL_ENTRY)&_ZN5S55C63v80Ev,
  (VTBL_ENTRY)&_ZN5S55C63v81Ev,
  (VTBL_ENTRY)&_ZN5S55C63v82Ev,
  (VTBL_ENTRY)&_ZN5S55C63v83Ev,
  (VTBL_ENTRY)&_ZN5S55C63v84Ev,
  (VTBL_ENTRY)&_ZN5S55C63v85Ev,
  (VTBL_ENTRY)&_ZN5S55C63v86Ev,
  (VTBL_ENTRY)&_ZN5S55C63v87Ev,
  (VTBL_ENTRY)&_ZN5S55C63v88Ev,
  (VTBL_ENTRY)&_ZN5S55C53v89Ev,
  (VTBL_ENTRY)&_ZN5S55C53v90Ev,
  (VTBL_ENTRY)&_ZN5S55C53v91Ev,
  (VTBL_ENTRY)&_ZN5S55C53v92Ev,
  (VTBL_ENTRY)&_ZN5S55C53v93Ev,
  (VTBL_ENTRY)&_ZN5S55C53v94Ev,
  (VTBL_ENTRY)&_ZN5S55C53v95Ev,
  (VTBL_ENTRY)&_ZN5S55C53v96Ev,
  (VTBL_ENTRY)&_ZN5S55C53v97Ev,
  (VTBL_ENTRY)&_ZN5S55C53v98Ev,
  (VTBL_ENTRY)&_ZN5S55C53v99Ev,
  (VTBL_ENTRY)&_ZN5S55C54v100Ev,
  (VTBL_ENTRY)&_ZN5S55C54v101Ev,
  (VTBL_ENTRY)&_ZN5S55C54v102Ev,
  (VTBL_ENTRY)&_ZN5S55C54v103Ev,
  (VTBL_ENTRY)&_ZN5S55C54v104Ev,
  (VTBL_ENTRY)&_ZN5S55C54v105Ev,
  (VTBL_ENTRY)&_ZN5S55C54v106Ev,
  (VTBL_ENTRY)&_ZN5S55C54v107Ev,
  (VTBL_ENTRY)&_ZN5S55C54v108Ev,
  (VTBL_ENTRY)&_ZN5S55C44v109Ev,
  (VTBL_ENTRY)&_ZN5S55C44v110Ev,
  (VTBL_ENTRY)&_ZN5S55C44v111Ev,
  (VTBL_ENTRY)&_ZN5S55C44v112Ev,
  (VTBL_ENTRY)&_ZN5S55C44v113Ev,
  (VTBL_ENTRY)&_ZN5S55C44v114Ev,
  (VTBL_ENTRY)&_ZN5S55C44v115Ev,
  (VTBL_ENTRY)&_ZN5S55C44v116Ev,
  (VTBL_ENTRY)&_ZN5S55C44v117Ev,
  (VTBL_ENTRY)&_ZN5S55C44v118Ev,
  (VTBL_ENTRY)&_ZN5S55C44v119Ev,
  (VTBL_ENTRY)&_ZN5S55C44v120Ev,
  (VTBL_ENTRY)&_ZN5S55C44v121Ev,
  (VTBL_ENTRY)&_ZN5S55C44v122Ev,
  (VTBL_ENTRY)&_ZN5S55C34v123Ev,
  (VTBL_ENTRY)&_ZN5S55C34v124Ev,
  (VTBL_ENTRY)&_ZN5S55C34v125Ev,
  (VTBL_ENTRY)&_ZN5S55C34v126Ev,
  (VTBL_ENTRY)&_ZN5S55C34v127Ev,
  (VTBL_ENTRY)&_ZN5S55C34v128Ev,
  (VTBL_ENTRY)&_ZN5S55C34v129Ev,
  (VTBL_ENTRY)&_ZN5S55C34v130Ev,
  (VTBL_ENTRY)&_ZN5S55C34v131Ev,
  (VTBL_ENTRY)&_ZN5S55C34v132Ev,
  (VTBL_ENTRY)&_ZN5S55C34v133Ev,
  (VTBL_ENTRY)&_ZN5S55C24v134Ev,
  (VTBL_ENTRY)&_ZN5S55C24v135Ev,
  (VTBL_ENTRY)&_ZN5S55C24v136Ev,
  (VTBL_ENTRY)&_ZN5S55C12v1Ev,
  (VTBL_ENTRY)&_ZN5S55C12v2Ev,
};
extern VTBL_ENTRY _ZTI5S55C1[];
extern  VTBL_ENTRY _ZTV5S55C1[];
Class_Descriptor cd_S55C1 = {  "S55C1", // class name
  bases_S55C1, 6,
  &(vtc_S55C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(392,280), // object size
  NSPAIRA(_ZTI5S55C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S55C1),140, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S58C7  {
  int s58c7f0;
  __tsi64 s58c7f1;
  void *s58c7f2[4];
  int s58c7f3[2];
  void *s58c7f4;
  ::S3350C4_nt s58c7f5;
  void *s58c7f6[2];
  virtual  ~S58C7(); // _ZN5S58C7D1Ev
  virtual void  v3(); // _ZN5S58C72v3Ev
  virtual void  v4(); // _ZN5S58C72v4Ev
  virtual void  v5(); // _ZN5S58C72v5Ev
  virtual void  v6(); // _ZN5S58C72v6Ev
  virtual void  v7(); // _ZN5S58C72v7Ev
  virtual void  v8(); // _ZN5S58C72v8Ev
  virtual void  v9(); // _ZN5S58C72v9Ev
  virtual void  v10(); // _ZN5S58C73v10Ev
  virtual void  v11(); // _ZN5S58C73v11Ev
  virtual void  v12(); // _ZN5S58C73v12Ev
  virtual void  v13(); // _ZN5S58C73v13Ev
  virtual void  v14(); // _ZN5S58C73v14Ev
  virtual void  v15(); // _ZN5S58C73v15Ev
  virtual void  v16(); // _ZN5S58C73v16Ev
  virtual void  v17(); // _ZN5S58C73v17Ev
  virtual void  v18(); // _ZN5S58C73v18Ev
  virtual void  v19(); // _ZN5S58C73v19Ev
  virtual void  v20(); // _ZN5S58C73v20Ev
  virtual void  v21(); // _ZN5S58C73v21Ev
  virtual void  v22(); // _ZN5S58C73v22Ev
  virtual void  v23(); // _ZN5S58C73v23Ev
  virtual void  v24(); // _ZN5S58C73v24Ev
  virtual void  v25(); // _ZN5S58C73v25Ev
  virtual void  v26(); // _ZN5S58C73v26Ev
  virtual void  v27(); // _ZN5S58C73v27Ev
  virtual void  v28(); // _ZN5S58C73v28Ev
  virtual void  v29(); // _ZN5S58C73v29Ev
  virtual void  v30(); // _ZN5S58C73v30Ev
  virtual void  v31(); // _ZN5S58C73v31Ev
  virtual void  v32(); // _ZN5S58C73v32Ev
  virtual void  v33(); // _ZN5S58C73v33Ev
  virtual void  v34(); // _ZN5S58C73v34Ev
  virtual void  v35(); // _ZN5S58C73v35Ev
  virtual void  v36(); // _ZN5S58C73v36Ev
  virtual void  v37(); // _ZN5S58C73v37Ev
  virtual void  v38(); // _ZN5S58C73v38Ev
  virtual void  v39(); // _ZN5S58C73v39Ev
  virtual void  v40(); // _ZN5S58C73v40Ev
  virtual void  v41(); // _ZN5S58C73v41Ev
  virtual void  v42(); // _ZN5S58C73v42Ev
  virtual void  v43(); // _ZN5S58C73v43Ev
  virtual void  v44(); // _ZN5S58C73v44Ev
  virtual void  v45(); // _ZN5S58C73v45Ev
  virtual void  v46(); // _ZN5S58C73v46Ev
  virtual void  v47(); // _ZN5S58C73v47Ev
  virtual void  v48(); // _ZN5S58C73v48Ev
  virtual void  v49(); // _ZN5S58C73v49Ev
  virtual void  v50(); // _ZN5S58C73v50Ev
  virtual void  v51(); // _ZN5S58C73v51Ev
  virtual void  v52(); // _ZN5S58C73v52Ev
  virtual void  v53(); // _ZN5S58C73v53Ev
  virtual void  v54(); // _ZN5S58C73v54Ev
  virtual void  v55(); // _ZN5S58C73v55Ev
  virtual void  v56(); // _ZN5S58C73v56Ev
  virtual void  v57(); // _ZN5S58C73v57Ev
  virtual void  v58(); // _ZN5S58C73v58Ev
  virtual void  v59(); // _ZN5S58C73v59Ev
  virtual void  v60(); // _ZN5S58C73v60Ev
  virtual void  v61(); // _ZN5S58C73v61Ev
  virtual void  v62(); // _ZN5S58C73v62Ev
  virtual void  v63(); // _ZN5S58C73v63Ev
  virtual void  v64(); // _ZN5S58C73v64Ev
  virtual void  v65(); // _ZN5S58C73v65Ev
  virtual void  v66(); // _ZN5S58C73v66Ev
  S58C7(); // tgen
};
//SIG(-1 S58C7) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S58C7 ::~S58C7(){ note_dtor("S58C7", this);}
void  S58C7 ::v3(){vfunc_called(this, "_ZN5S58C72v3Ev");}
void  S58C7 ::v4(){vfunc_called(this, "_ZN5S58C72v4Ev");}
void  S58C7 ::v5(){vfunc_called(this, "_ZN5S58C72v5Ev");}
void  S58C7 ::v6(){vfunc_called(this, "_ZN5S58C72v6Ev");}
void  S58C7 ::v7(){vfunc_called(this, "_ZN5S58C72v7Ev");}
void  S58C7 ::v8(){vfunc_called(this, "_ZN5S58C72v8Ev");}
void  S58C7 ::v9(){vfunc_called(this, "_ZN5S58C72v9Ev");}
void  S58C7 ::v10(){vfunc_called(this, "_ZN5S58C73v10Ev");}
void  S58C7 ::v11(){vfunc_called(this, "_ZN5S58C73v11Ev");}
void  S58C7 ::v12(){vfunc_called(this, "_ZN5S58C73v12Ev");}
void  S58C7 ::v13(){vfunc_called(this, "_ZN5S58C73v13Ev");}
void  S58C7 ::v14(){vfunc_called(this, "_ZN5S58C73v14Ev");}
void  S58C7 ::v15(){vfunc_called(this, "_ZN5S58C73v15Ev");}
void  S58C7 ::v16(){vfunc_called(this, "_ZN5S58C73v16Ev");}
void  S58C7 ::v17(){vfunc_called(this, "_ZN5S58C73v17Ev");}
void  S58C7 ::v18(){vfunc_called(this, "_ZN5S58C73v18Ev");}
void  S58C7 ::v19(){vfunc_called(this, "_ZN5S58C73v19Ev");}
void  S58C7 ::v20(){vfunc_called(this, "_ZN5S58C73v20Ev");}
void  S58C7 ::v21(){vfunc_called(this, "_ZN5S58C73v21Ev");}
void  S58C7 ::v22(){vfunc_called(this, "_ZN5S58C73v22Ev");}
void  S58C7 ::v23(){vfunc_called(this, "_ZN5S58C73v23Ev");}
void  S58C7 ::v24(){vfunc_called(this, "_ZN5S58C73v24Ev");}
void  S58C7 ::v25(){vfunc_called(this, "_ZN5S58C73v25Ev");}
void  S58C7 ::v26(){vfunc_called(this, "_ZN5S58C73v26Ev");}
void  S58C7 ::v27(){vfunc_called(this, "_ZN5S58C73v27Ev");}
void  S58C7 ::v28(){vfunc_called(this, "_ZN5S58C73v28Ev");}
void  S58C7 ::v29(){vfunc_called(this, "_ZN5S58C73v29Ev");}
void  S58C7 ::v30(){vfunc_called(this, "_ZN5S58C73v30Ev");}
void  S58C7 ::v31(){vfunc_called(this, "_ZN5S58C73v31Ev");}
void  S58C7 ::v32(){vfunc_called(this, "_ZN5S58C73v32Ev");}
void  S58C7 ::v33(){vfunc_called(this, "_ZN5S58C73v33Ev");}
void  S58C7 ::v34(){vfunc_called(this, "_ZN5S58C73v34Ev");}
void  S58C7 ::v35(){vfunc_called(this, "_ZN5S58C73v35Ev");}
void  S58C7 ::v36(){vfunc_called(this, "_ZN5S58C73v36Ev");}
void  S58C7 ::v37(){vfunc_called(this, "_ZN5S58C73v37Ev");}
void  S58C7 ::v38(){vfunc_called(this, "_ZN5S58C73v38Ev");}
void  S58C7 ::v39(){vfunc_called(this, "_ZN5S58C73v39Ev");}
void  S58C7 ::v40(){vfunc_called(this, "_ZN5S58C73v40Ev");}
void  S58C7 ::v41(){vfunc_called(this, "_ZN5S58C73v41Ev");}
void  S58C7 ::v42(){vfunc_called(this, "_ZN5S58C73v42Ev");}
void  S58C7 ::v43(){vfunc_called(this, "_ZN5S58C73v43Ev");}
void  S58C7 ::v44(){vfunc_called(this, "_ZN5S58C73v44Ev");}
void  S58C7 ::v45(){vfunc_called(this, "_ZN5S58C73v45Ev");}
void  S58C7 ::v46(){vfunc_called(this, "_ZN5S58C73v46Ev");}
void  S58C7 ::v47(){vfunc_called(this, "_ZN5S58C73v47Ev");}
void  S58C7 ::v48(){vfunc_called(this, "_ZN5S58C73v48Ev");}
void  S58C7 ::v49(){vfunc_called(this, "_ZN5S58C73v49Ev");}
void  S58C7 ::v50(){vfunc_called(this, "_ZN5S58C73v50Ev");}
void  S58C7 ::v51(){vfunc_called(this, "_ZN5S58C73v51Ev");}
void  S58C7 ::v52(){vfunc_called(this, "_ZN5S58C73v52Ev");}
void  S58C7 ::v53(){vfunc_called(this, "_ZN5S58C73v53Ev");}
void  S58C7 ::v54(){vfunc_called(this, "_ZN5S58C73v54Ev");}
void  S58C7 ::v55(){vfunc_called(this, "_ZN5S58C73v55Ev");}
void  S58C7 ::v56(){vfunc_called(this, "_ZN5S58C73v56Ev");}
void  S58C7 ::v57(){vfunc_called(this, "_ZN5S58C73v57Ev");}
void  S58C7 ::v58(){vfunc_called(this, "_ZN5S58C73v58Ev");}
void  S58C7 ::v59(){vfunc_called(this, "_ZN5S58C73v59Ev");}
void  S58C7 ::v60(){vfunc_called(this, "_ZN5S58C73v60Ev");}
void  S58C7 ::v61(){vfunc_called(this, "_ZN5S58C73v61Ev");}
void  S58C7 ::v62(){vfunc_called(this, "_ZN5S58C73v62Ev");}
void  S58C7 ::v63(){vfunc_called(this, "_ZN5S58C73v63Ev");}
void  S58C7 ::v64(){vfunc_called(this, "_ZN5S58C73v64Ev");}
void  S58C7 ::v65(){vfunc_called(this, "_ZN5S58C73v65Ev");}
void  S58C7 ::v66(){vfunc_called(this, "_ZN5S58C73v66Ev");}
S58C7 ::S58C7(){ note_ctor("S58C7", this);} // tgen

static void Test_S58C7()
{
  extern Class_Descriptor cd_S58C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S58C7, buf);
    S58C7 *dp, &lv = *(dp=new (buf) S58C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S58C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S58C7)");
    check_field_offset(lv, s58c7f0, ABISELECT(8,4), "S58C7.s58c7f0");
    check_field_offset(lv, s58c7f1, ABISELECT(16,8), "S58C7.s58c7f1");
    check_field_offset(lv, s58c7f2, ABISELECT(24,16), "S58C7.s58c7f2");
    check_field_offset(lv, s58c7f3, ABISELECT(56,32), "S58C7.s58c7f3");
    check_field_offset(lv, s58c7f4, ABISELECT(64,40), "S58C7.s58c7f4");
    check_field_offset(lv, s58c7f5, ABISELECT(72,44), "S58C7.s58c7f5");
    check_field_offset(lv, s58c7f6, ABISELECT(80,52), "S58C7.s58c7f6");
    test_class_info(&lv, &cd_S58C7);
    dp->~S58C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS58C7(Test_S58C7, "S58C7", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN5S58C7C1Ev();
extern void _ZN5S58C7D1Ev();
Name_Map name_map_S58C7[] = {
  NSPAIR(_ZN5S58C7C1Ev),
  NSPAIR(_ZN5S58C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI5S58C7[];
extern void _ZN5S58C7D1Ev();
extern void _ZN5S58C7D0Ev();
extern void _ZN5S58C72v3Ev();
extern void _ZN5S58C72v4Ev();
extern void _ZN5S58C72v5Ev();
extern void _ZN5S58C72v6Ev();
extern void _ZN5S58C72v7Ev();
extern void _ZN5S58C72v8Ev();
extern void _ZN5S58C72v9Ev();
extern void _ZN5S58C73v10Ev();
extern void _ZN5S58C73v11Ev();
extern void _ZN5S58C73v12Ev();
extern void _ZN5S58C73v13Ev();
extern void _ZN5S58C73v14Ev();
extern void _ZN5S58C73v15Ev();
extern void _ZN5S58C73v16Ev();
extern void _ZN5S58C73v17Ev();
extern void _ZN5S58C73v18Ev();
extern void _ZN5S58C73v19Ev();
extern void _ZN5S58C73v20Ev();
extern void _ZN5S58C73v21Ev();
extern void _ZN5S58C73v22Ev();
extern void _ZN5S58C73v23Ev();
extern void _ZN5S58C73v24Ev();
extern void _ZN5S58C73v25Ev();
extern void _ZN5S58C73v26Ev();
extern void _ZN5S58C73v27Ev();
extern void _ZN5S58C73v28Ev();
extern void _ZN5S58C73v29Ev();
extern void _ZN5S58C73v30Ev();
extern void _ZN5S58C73v31Ev();
extern void _ZN5S58C73v32Ev();
extern void _ZN5S58C73v33Ev();
extern void _ZN5S58C73v34Ev();
extern void _ZN5S58C73v35Ev();
extern void _ZN5S58C73v36Ev();
extern void _ZN5S58C73v37Ev();
extern void _ZN5S58C73v38Ev();
extern void _ZN5S58C73v39Ev();
extern void _ZN5S58C73v40Ev();
extern void _ZN5S58C73v41Ev();
extern void _ZN5S58C73v42Ev();
extern void _ZN5S58C73v43Ev();
extern void _ZN5S58C73v44Ev();
extern void _ZN5S58C73v45Ev();
extern void _ZN5S58C73v46Ev();
extern void _ZN5S58C73v47Ev();
extern void _ZN5S58C73v48Ev();
extern void _ZN5S58C73v49Ev();
extern void _ZN5S58C73v50Ev();
extern void _ZN5S58C73v51Ev();
extern void _ZN5S58C73v52Ev();
extern void _ZN5S58C73v53Ev();
extern void _ZN5S58C73v54Ev();
extern void _ZN5S58C73v55Ev();
extern void _ZN5S58C73v56Ev();
extern void _ZN5S58C73v57Ev();
extern void _ZN5S58C73v58Ev();
extern void _ZN5S58C73v59Ev();
extern void _ZN5S58C73v60Ev();
extern void _ZN5S58C73v61Ev();
extern void _ZN5S58C73v62Ev();
extern void _ZN5S58C73v63Ev();
extern void _ZN5S58C73v64Ev();
extern void _ZN5S58C73v65Ev();
extern void _ZN5S58C73v66Ev();
static  VTBL_ENTRY vtc_S58C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S58C7[0]),
  (VTBL_ENTRY)&_ZN5S58C7D1Ev,
  (VTBL_ENTRY)&_ZN5S58C7D0Ev,
  (VTBL_ENTRY)&_ZN5S58C72v3Ev,
  (VTBL_ENTRY)&_ZN5S58C72v4Ev,
  (VTBL_ENTRY)&_ZN5S58C72v5Ev,
  (VTBL_ENTRY)&_ZN5S58C72v6Ev,
  (VTBL_ENTRY)&_ZN5S58C72v7Ev,
  (VTBL_ENTRY)&_ZN5S58C72v8Ev,
  (VTBL_ENTRY)&_ZN5S58C72v9Ev,
  (VTBL_ENTRY)&_ZN5S58C73v10Ev,
  (VTBL_ENTRY)&_ZN5S58C73v11Ev,
  (VTBL_ENTRY)&_ZN5S58C73v12Ev,
  (VTBL_ENTRY)&_ZN5S58C73v13Ev,
  (VTBL_ENTRY)&_ZN5S58C73v14Ev,
  (VTBL_ENTRY)&_ZN5S58C73v15Ev,
  (VTBL_ENTRY)&_ZN5S58C73v16Ev,
  (VTBL_ENTRY)&_ZN5S58C73v17Ev,
  (VTBL_ENTRY)&_ZN5S58C73v18Ev,
  (VTBL_ENTRY)&_ZN5S58C73v19Ev,
  (VTBL_ENTRY)&_ZN5S58C73v20Ev,
  (VTBL_ENTRY)&_ZN5S58C73v21Ev,
  (VTBL_ENTRY)&_ZN5S58C73v22Ev,
  (VTBL_ENTRY)&_ZN5S58C73v23Ev,
  (VTBL_ENTRY)&_ZN5S58C73v24Ev,
  (VTBL_ENTRY)&_ZN5S58C73v25Ev,
  (VTBL_ENTRY)&_ZN5S58C73v26Ev,
  (VTBL_ENTRY)&_ZN5S58C73v27Ev,
  (VTBL_ENTRY)&_ZN5S58C73v28Ev,
  (VTBL_ENTRY)&_ZN5S58C73v29Ev,
  (VTBL_ENTRY)&_ZN5S58C73v30Ev,
  (VTBL_ENTRY)&_ZN5S58C73v31Ev,
  (VTBL_ENTRY)&_ZN5S58C73v32Ev,
  (VTBL_ENTRY)&_ZN5S58C73v33Ev,
  (VTBL_ENTRY)&_ZN5S58C73v34Ev,
  (VTBL_ENTRY)&_ZN5S58C73v35Ev,
  (VTBL_ENTRY)&_ZN5S58C73v36Ev,
  (VTBL_ENTRY)&_ZN5S58C73v37Ev,
  (VTBL_ENTRY)&_ZN5S58C73v38Ev,
  (VTBL_ENTRY)&_ZN5S58C73v39Ev,
  (VTBL_ENTRY)&_ZN5S58C73v40Ev,
  (VTBL_ENTRY)&_ZN5S58C73v41Ev,
  (VTBL_ENTRY)&_ZN5S58C73v42Ev,
  (VTBL_ENTRY)&_ZN5S58C73v43Ev,
  (VTBL_ENTRY)&_ZN5S58C73v44Ev,
  (VTBL_ENTRY)&_ZN5S58C73v45Ev,
  (VTBL_ENTRY)&_ZN5S58C73v46Ev,
  (VTBL_ENTRY)&_ZN5S58C73v47Ev,
  (VTBL_ENTRY)&_ZN5S58C73v48Ev,
  (VTBL_ENTRY)&_ZN5S58C73v49Ev,
  (VTBL_ENTRY)&_ZN5S58C73v50Ev,
  (VTBL_ENTRY)&_ZN5S58C73v51Ev,
  (VTBL_ENTRY)&_ZN5S58C73v52Ev,
  (VTBL_ENTRY)&_ZN5S58C73v53Ev,
  (VTBL_ENTRY)&_ZN5S58C73v54Ev,
  (VTBL_ENTRY)&_ZN5S58C73v55Ev,
  (VTBL_ENTRY)&_ZN5S58C73v56Ev,
  (VTBL_ENTRY)&_ZN5S58C73v57Ev,
  (VTBL_ENTRY)&_ZN5S58C73v58Ev,
  (VTBL_ENTRY)&_ZN5S58C73v59Ev,
  (VTBL_ENTRY)&_ZN5S58C73v60Ev,
  (VTBL_ENTRY)&_ZN5S58C73v61Ev,
  (VTBL_ENTRY)&_ZN5S58C73v62Ev,
  (VTBL_ENTRY)&_ZN5S58C73v63Ev,
  (VTBL_ENTRY)&_ZN5S58C73v64Ev,
  (VTBL_ENTRY)&_ZN5S58C73v65Ev,
  (VTBL_ENTRY)&_ZN5S58C73v66Ev,
};
extern VTBL_ENTRY _ZTI5S58C7[];
extern  VTBL_ENTRY _ZTV5S58C7[];
Class_Descriptor cd_S58C7 = {  "S58C7", // class name
  0,0,//no base classes
  &(vtc_S58C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI5S58C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV5S58C7),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S58C6  : S58C7 {
  int s58c6f0[2];
  void *s58c6f1;
  int s58c6f2[2];
  ::S287C8_nt s58c6f3;
  ::S287C8_nt s58c6f4;
  ::S2121C38 s58c6f5;
  ::S287C8_nt s58c6f6;
  unsigned int s58c6f7:1;
  unsigned int s58c6f8:1;
  unsigned int s58c6f9:1;
  unsigned int s58c6f10:1;
  unsigned int s58c6f11:1;
  int s58c6f12[2];
  virtual  ~S58C6(); // _ZN5S58C6D1Ev
  virtual void  v67(); // _ZN5S58C63v67Ev
  virtual void  v68(); // _ZN5S58C63v68Ev
  virtual void  v69(); // _ZN5S58C63v69Ev
  virtual void  v70(); // _ZN5S58C63v70Ev
  virtual void  v71(); // _ZN5S58C63v71Ev
  virtual void  v72(); // _ZN5S58C63v72Ev
  virtual void  v73(); // _ZN5S58C63v73Ev
  virtual void  v74(); // _ZN5S58C63v74Ev
  virtual void  v75(); // _ZN5S58C63v75Ev
  virtual void  v76(); // _ZN5S58C63v76Ev
  virtual void  v77(); // _ZN5S58C63v77Ev
  virtual void  v78(); // _ZN5S58C63v78Ev
  virtual void  v79(); // _ZN5S58C63v79Ev
  virtual void  v80(); // _ZN5S58C63v80Ev
  virtual void  v81(); // _ZN5S58C63v81Ev
  virtual void  v82(); // _ZN5S58C63v82Ev
  virtual void  v83(); // _ZN5S58C63v83Ev
  virtual void  v84(); // _ZN5S58C63v84Ev
  virtual void  v85(); // _ZN5S58C63v85Ev
  virtual void  v86(); // _ZN5S58C63v86Ev
  virtual void  v87(); // _ZN5S58C63v87Ev
  virtual void  v88(); // _ZN5S58C63v88Ev
  S58C6(); // tgen
};
//SIG(-1 S58C6) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S58C6 ::~S58C6(){ note_dtor("S58C6", this);}
void  S58C6 ::v67(){vfunc_called(this, "_ZN5S58C63v67Ev");}
void  S58C6 ::v68(){vfunc_called(this, "_ZN5S58C63v68Ev");}
void  S58C6 ::v69(){vfunc_called(this, "_ZN5S58C63v69Ev");}
void  S58C6 ::v70(){vfunc_called(this, "_ZN5S58C63v70Ev");}
void  S58C6 ::v71(){vfunc_called(this, "_ZN5S58C63v71Ev");}
void  S58C6 ::v72(){vfunc_called(this, "_ZN5S58C63v72Ev");}
void  S58C6 ::v73(){vfunc_called(this, "_ZN5S58C63v73Ev");}
void  S58C6 ::v74(){vfunc_called(this, "_ZN5S58C63v74Ev");}
void  S58C6 ::v75(){vfunc_called(this, "_ZN5S58C63v75Ev");}
void  S58C6 ::v76(){vfunc_called(this, "_ZN5S58C63v76Ev");}
void  S58C6 ::v77(){vfunc_called(this, "_ZN5S58C63v77Ev");}
void  S58C6 ::v78(){vfunc_called(this, "_ZN5S58C63v78Ev");}
void  S58C6 ::v79(){vfunc_called(this, "_ZN5S58C63v79Ev");}
void  S58C6 ::v80(){vfunc_called(this, "_ZN5S58C63v80Ev");}
void  S58C6 ::v81(){vfunc_called(this, "_ZN5S58C63v81Ev");}
void  S58C6 ::v82(){vfunc_called(this, "_ZN5S58C63v82Ev");}
void  S58C6 ::v83(){vfunc_called(this, "_ZN5S58C63v83Ev");}
void  S58C6 ::v84(){vfunc_called(this, "_ZN5S58C63v84Ev");}
void  S58C6 ::v85(){vfunc_called(this, "_ZN5S58C63v85Ev");}
void  S58C6 ::v86(){vfunc_called(this, "_ZN5S58C63v86Ev");}
void  S58C6 ::v87(){vfunc_called(this, "_ZN5S58C63v87Ev");}
void  S58C6 ::v88(){vfunc_called(this, "_ZN5S58C63v88Ev");}
S58C6 ::S58C6(){ note_ctor("S58C6", this);} // tgen

static void Test_S58C6()
{
  extern Class_Descriptor cd_S58C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S58C6, buf);
    S58C6 *dp, &lv = *(dp=new (buf) S58C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S58C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S58C6)");
    check_base_class_offset(lv, (S58C7*), 0, "S58C6");
    check_field_offset(lv, s58c6f0, ABISELECT(96,60), "S58C6.s58c6f0");
    check_field_offset(lv, s58c6f1, ABISELECT(104,68), "S58C6.s58c6f1");
    check_field_offset(lv, s58c6f2, ABISELECT(112,72), "S58C6.s58c6f2");
    check_field_offset(lv, s58c6f3, ABISELECT(120,80), "S58C6.s58c6f3");
    check_field_offset(lv, s58c6f4, ABISELECT(136,92), "S58C6.s58c6f4");
    check_field_offset(lv, s58c6f5, ABISELECT(152,104), "S58C6.s58c6f5");
    check_field_offset(lv, s58c6f6, ABISELECT(160,108), "S58C6.s58c6f6");
    set_bf_and_test(lv, s58c6f7, ABISELECT(176,120), 0, 1, 1, "S58C6");
    set_bf_and_test(lv, s58c6f8, ABISELECT(176,120), 1, 1, 1, "S58C6");
    set_bf_and_test(lv, s58c6f9, ABISELECT(176,120), 2, 1, 1, "S58C6");
    set_bf_and_test(lv, s58c6f10, ABISELECT(176,120), 3, 1, 1, "S58C6");
    set_bf_and_test(lv, s58c6f11, ABISELECT(176,120), 4, 1, 1, "S58C6");
    check_field_offset(lv, s58c6f12, ABISELECT(180,124), "S58C6.s58c6f12");
    test_class_info(&lv, &cd_S58C6);
    dp->~S58C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS58C6(Test_S58C6, "S58C6", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN5S58C6C1Ev();
extern void _ZN5S58C6D1Ev();
Name_Map name_map_S58C6[] = {
  NSPAIR(_ZN5S58C6C1Ev),
  NSPAIR(_ZN5S58C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S58C7;
extern VTBL_ENTRY _ZTI5S58C7[];
extern  VTBL_ENTRY _ZTV5S58C7[];
static Base_Class bases_S58C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S58C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S58C6[];
extern void _ZN5S58C6D1Ev();
extern void _ZN5S58C6D0Ev();
extern void _ZN5S58C72v3Ev();
extern void _ZN5S58C72v4Ev();
extern void _ZN5S58C72v5Ev();
extern void _ZN5S58C72v6Ev();
extern void _ZN5S58C72v7Ev();
extern void _ZN5S58C72v8Ev();
extern void _ZN5S58C72v9Ev();
extern void _ZN5S58C73v10Ev();
extern void _ZN5S58C73v11Ev();
extern void _ZN5S58C73v12Ev();
extern void _ZN5S58C73v13Ev();
extern void _ZN5S58C73v14Ev();
extern void _ZN5S58C73v15Ev();
extern void _ZN5S58C73v16Ev();
extern void _ZN5S58C73v17Ev();
extern void _ZN5S58C73v18Ev();
extern void _ZN5S58C73v19Ev();
extern void _ZN5S58C73v20Ev();
extern void _ZN5S58C73v21Ev();
extern void _ZN5S58C73v22Ev();
extern void _ZN5S58C73v23Ev();
extern void _ZN5S58C73v24Ev();
extern void _ZN5S58C73v25Ev();
extern void _ZN5S58C73v26Ev();
extern void _ZN5S58C73v27Ev();
extern void _ZN5S58C73v28Ev();
extern void _ZN5S58C73v29Ev();
extern void _ZN5S58C73v30Ev();
extern void _ZN5S58C73v31Ev();
extern void _ZN5S58C73v32Ev();
extern void _ZN5S58C73v33Ev();
extern void _ZN5S58C73v34Ev();
extern void _ZN5S58C73v35Ev();
extern void _ZN5S58C73v36Ev();
extern void _ZN5S58C73v37Ev();
extern void _ZN5S58C73v38Ev();
extern void _ZN5S58C73v39Ev();
extern void _ZN5S58C73v40Ev();
extern void _ZN5S58C73v41Ev();
extern void _ZN5S58C73v42Ev();
extern void _ZN5S58C73v43Ev();
extern void _ZN5S58C73v44Ev();
extern void _ZN5S58C73v45Ev();
extern void _ZN5S58C73v46Ev();
extern void _ZN5S58C73v47Ev();
extern void _ZN5S58C73v48Ev();
extern void _ZN5S58C73v49Ev();
extern void _ZN5S58C73v50Ev();
extern void _ZN5S58C73v51Ev();
extern void _ZN5S58C73v52Ev();
extern void _ZN5S58C73v53Ev();
extern void _ZN5S58C73v54Ev();
extern void _ZN5S58C73v55Ev();
extern void _ZN5S58C73v56Ev();
extern void _ZN5S58C73v57Ev();
extern void _ZN5S58C73v58Ev();
extern void _ZN5S58C73v59Ev();
extern void _ZN5S58C73v60Ev();
extern void _ZN5S58C73v61Ev();
extern void _ZN5S58C73v62Ev();
extern void _ZN5S58C73v63Ev();
extern void _ZN5S58C73v64Ev();
extern void _ZN5S58C73v65Ev();
extern void _ZN5S58C73v66Ev();
extern void _ZN5S58C63v67Ev();
extern void _ZN5S58C63v68Ev();
extern void _ZN5S58C63v69Ev();
extern void _ZN5S58C63v70Ev();
extern void _ZN5S58C63v71Ev();
extern void _ZN5S58C63v72Ev();
extern void _ZN5S58C63v73Ev();
extern void _ZN5S58C63v74Ev();
extern void _ZN5S58C63v75Ev();
extern void _ZN5S58C63v76Ev();
extern void _ZN5S58C63v77Ev();
extern void _ZN5S58C63v78Ev();
extern void _ZN5S58C63v79Ev();
extern void _ZN5S58C63v80Ev();
extern void _ZN5S58C63v81Ev();
extern void _ZN5S58C63v82Ev();
extern void _ZN5S58C63v83Ev();
extern void _ZN5S58C63v84Ev();
extern void _ZN5S58C63v85Ev();
extern void _ZN5S58C63v86Ev();
extern void _ZN5S58C63v87Ev();
extern void _ZN5S58C63v88Ev();
static  VTBL_ENTRY vtc_S58C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S58C6[0]),
  (VTBL_ENTRY)&_ZN5S58C6D1Ev,
  (VTBL_ENTRY)&_ZN5S58C6D0Ev,
  (VTBL_ENTRY)&_ZN5S58C72v3Ev,
  (VTBL_ENTRY)&_ZN5S58C72v4Ev,
  (VTBL_ENTRY)&_ZN5S58C72v5Ev,
  (VTBL_ENTRY)&_ZN5S58C72v6Ev,
  (VTBL_ENTRY)&_ZN5S58C72v7Ev,
  (VTBL_ENTRY)&_ZN5S58C72v8Ev,
  (VTBL_ENTRY)&_ZN5S58C72v9Ev,
  (VTBL_ENTRY)&_ZN5S58C73v10Ev,
  (VTBL_ENTRY)&_ZN5S58C73v11Ev,
  (VTBL_ENTRY)&_ZN5S58C73v12Ev,
  (VTBL_ENTRY)&_ZN5S58C73v13Ev,
  (VTBL_ENTRY)&_ZN5S58C73v14Ev,
  (VTBL_ENTRY)&_ZN5S58C73v15Ev,
  (VTBL_ENTRY)&_ZN5S58C73v16Ev,
  (VTBL_ENTRY)&_ZN5S58C73v17Ev,
  (VTBL_ENTRY)&_ZN5S58C73v18Ev,
  (VTBL_ENTRY)&_ZN5S58C73v19Ev,
  (VTBL_ENTRY)&_ZN5S58C73v20Ev,
  (VTBL_ENTRY)&_ZN5S58C73v21Ev,
  (VTBL_ENTRY)&_ZN5S58C73v22Ev,
  (VTBL_ENTRY)&_ZN5S58C73v23Ev,
  (VTBL_ENTRY)&_ZN5S58C73v24Ev,
  (VTBL_ENTRY)&_ZN5S58C73v25Ev,
  (VTBL_ENTRY)&_ZN5S58C73v26Ev,
  (VTBL_ENTRY)&_ZN5S58C73v27Ev,
  (VTBL_ENTRY)&_ZN5S58C73v28Ev,
  (VTBL_ENTRY)&_ZN5S58C73v29Ev,
  (VTBL_ENTRY)&_ZN5S58C73v30Ev,
  (VTBL_ENTRY)&_ZN5S58C73v31Ev,
  (VTBL_ENTRY)&_ZN5S58C73v32Ev,
  (VTBL_ENTRY)&_ZN5S58C73v33Ev,
  (VTBL_ENTRY)&_ZN5S58C73v34Ev,
  (VTBL_ENTRY)&_ZN5S58C73v35Ev,
  (VTBL_ENTRY)&_ZN5S58C73v36Ev,
  (VTBL_ENTRY)&_ZN5S58C73v37Ev,
  (VTBL_ENTRY)&_ZN5S58C73v38Ev,
  (VTBL_ENTRY)&_ZN5S58C73v39Ev,
  (VTBL_ENTRY)&_ZN5S58C73v40Ev,
  (VTBL_ENTRY)&_ZN5S58C73v41Ev,
  (VTBL_ENTRY)&_ZN5S58C73v42Ev,
  (VTBL_ENTRY)&_ZN5S58C73v43Ev,
  (VTBL_ENTRY)&_ZN5S58C73v44Ev,
  (VTBL_ENTRY)&_ZN5S58C73v45Ev,
  (VTBL_ENTRY)&_ZN5S58C73v46Ev,
  (VTBL_ENTRY)&_ZN5S58C73v47Ev,
  (VTBL_ENTRY)&_ZN5S58C73v48Ev,
  (VTBL_ENTRY)&_ZN5S58C73v49Ev,
  (VTBL_ENTRY)&_ZN5S58C73v50Ev,
  (VTBL_ENTRY)&_ZN5S58C73v51Ev,
  (VTBL_ENTRY)&_ZN5S58C73v52Ev,
  (VTBL_ENTRY)&_ZN5S58C73v53Ev,
  (VTBL_ENTRY)&_ZN5S58C73v54Ev,
  (VTBL_ENTRY)&_ZN5S58C73v55Ev,
  (VTBL_ENTRY)&_ZN5S58C73v56Ev,
  (VTBL_ENTRY)&_ZN5S58C73v57Ev,
  (VTBL_ENTRY)&_ZN5S58C73v58Ev,
  (VTBL_ENTRY)&_ZN5S58C73v59Ev,
  (VTBL_ENTRY)&_ZN5S58C73v60Ev,
  (VTBL_ENTRY)&_ZN5S58C73v61Ev,
  (VTBL_ENTRY)&_ZN5S58C73v62Ev,
  (VTBL_ENTRY)&_ZN5S58C73v63Ev,
  (VTBL_ENTRY)&_ZN5S58C73v64Ev,
  (VTBL_ENTRY)&_ZN5S58C73v65Ev,
  (VTBL_ENTRY)&_ZN5S58C73v66Ev,
  (VTBL_ENTRY)&_ZN5S58C63v67Ev,
  (VTBL_ENTRY)&_ZN5S58C63v68Ev,
  (VTBL_ENTRY)&_ZN5S58C63v69Ev,
  (VTBL_ENTRY)&_ZN5S58C63v70Ev,
  (VTBL_ENTRY)&_ZN5S58C63v71Ev,
  (VTBL_ENTRY)&_ZN5S58C63v72Ev,
  (VTBL_ENTRY)&_ZN5S58C63v73Ev,
  (VTBL_ENTRY)&_ZN5S58C63v74Ev,
  (VTBL_ENTRY)&_ZN5S58C63v75Ev,
  (VTBL_ENTRY)&_ZN5S58C63v76Ev,
  (VTBL_ENTRY)&_ZN5S58C63v77Ev,
  (VTBL_ENTRY)&_ZN5S58C63v78Ev,
  (VTBL_ENTRY)&_ZN5S58C63v79Ev,
  (VTBL_ENTRY)&_ZN5S58C63v80Ev,
  (VTBL_ENTRY)&_ZN5S58C63v81Ev,
  (VTBL_ENTRY)&_ZN5S58C63v82Ev,
  (VTBL_ENTRY)&_ZN5S58C63v83Ev,
  (VTBL_ENTRY)&_ZN5S58C63v84Ev,
  (VTBL_ENTRY)&_ZN5S58C63v85Ev,
  (VTBL_ENTRY)&_ZN5S58C63v86Ev,
  (VTBL_ENTRY)&_ZN5S58C63v87Ev,
  (VTBL_ENTRY)&_ZN5S58C63v88Ev,
};
extern VTBL_ENTRY _ZTI5S58C6[];
extern  VTBL_ENTRY _ZTV5S58C6[];
Class_Descriptor cd_S58C6 = {  "S58C6", // class name
  bases_S58C6, 1,
  &(vtc_S58C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI5S58C6),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S58C6),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S58C5  : S58C6 {
  unsigned int s58c5f0:1;
  unsigned int s58c5f1:1;
  unsigned int s58c5f2:1;
  ::S3350C17 s58c5f3;
  ::S3350C11 s58c5f4;
  ::S3350C5_nt s58c5f5;
  ::S287C27 s58c5f6;
  int s58c5f7[3];
  virtual  ~S58C5(); // _ZN5S58C5D1Ev
  virtual void  v89(); // _ZN5S58C53v89Ev
  virtual void  v90(); // _ZN5S58C53v90Ev
  virtual void  v91(); // _ZN5S58C53v91Ev
  virtual void  v92(); // _ZN5S58C53v92Ev
  virtual void  v93(); // _ZN5S58C53v93Ev
  virtual void  v94(); // _ZN5S58C53v94Ev
  virtual void  v95(); // _ZN5S58C53v95Ev
  virtual void  v96(); // _ZN5S58C53v96Ev
  virtual void  v97(); // _ZN5S58C53v97Ev
  virtual void  v98(); // _ZN5S58C53v98Ev
  virtual void  v99(); // _ZN5S58C53v99Ev
  virtual void  v100(); // _ZN5S58C54v100Ev
  virtual void  v101(); // _ZN5S58C54v101Ev
  virtual void  v102(); // _ZN5S58C54v102Ev
  virtual void  v103(); // _ZN5S58C54v103Ev
  virtual void  v104(); // _ZN5S58C54v104Ev
  virtual void  v105(); // _ZN5S58C54v105Ev
  virtual void  v106(); // _ZN5S58C54v106Ev
  virtual void  v107(); // _ZN5S58C54v107Ev
  virtual void  v108(); // _ZN5S58C54v108Ev
  S58C5(); // tgen
};
//SIG(-1 S58C5) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} FC16{ BC17{ BC8}} Fi[3]}


 S58C5 ::~S58C5(){ note_dtor("S58C5", this);}
void  S58C5 ::v89(){vfunc_called(this, "_ZN5S58C53v89Ev");}
void  S58C5 ::v90(){vfunc_called(this, "_ZN5S58C53v90Ev");}
void  S58C5 ::v91(){vfunc_called(this, "_ZN5S58C53v91Ev");}
void  S58C5 ::v92(){vfunc_called(this, "_ZN5S58C53v92Ev");}
void  S58C5 ::v93(){vfunc_called(this, "_ZN5S58C53v93Ev");}
void  S58C5 ::v94(){vfunc_called(this, "_ZN5S58C53v94Ev");}
void  S58C5 ::v95(){vfunc_called(this, "_ZN5S58C53v95Ev");}
void  S58C5 ::v96(){vfunc_called(this, "_ZN5S58C53v96Ev");}
void  S58C5 ::v97(){vfunc_called(this, "_ZN5S58C53v97Ev");}
void  S58C5 ::v98(){vfunc_called(this, "_ZN5S58C53v98Ev");}
void  S58C5 ::v99(){vfunc_called(this, "_ZN5S58C53v99Ev");}
void  S58C5 ::v100(){vfunc_called(this, "_ZN5S58C54v100Ev");}
void  S58C5 ::v101(){vfunc_called(this, "_ZN5S58C54v101Ev");}
void  S58C5 ::v102(){vfunc_called(this, "_ZN5S58C54v102Ev");}
void  S58C5 ::v103(){vfunc_called(this, "_ZN5S58C54v103Ev");}
void  S58C5 ::v104(){vfunc_called(this, "_ZN5S58C54v104Ev");}
void  S58C5 ::v105(){vfunc_called(this, "_ZN5S58C54v105Ev");}
void  S58C5 ::v106(){vfunc_called(this, "_ZN5S58C54v106Ev");}
void  S58C5 ::v107(){vfunc_called(this, "_ZN5S58C54v107Ev");}
void  S58C5 ::v108(){vfunc_called(this, "_ZN5S58C54v108Ev");}
S58C5 ::S58C5(){ note_ctor("S58C5", this);} // tgen

static void Test_S58C5()
{
  extern Class_Descriptor cd_S58C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(35,50)];
    init_test(&cd_S58C5, buf);
    S58C5 *dp, &lv = *(dp=new (buf) S58C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,196), "sizeof(S58C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S58C5)");
    check_base_class_offset(lv, (S58C7*)(S58C6*), 0, "S58C5");
    check_base_class_offset(lv, (S58C6*), 0, "S58C5");
    set_bf_and_test(lv, s58c5f0, ABISELECT(188,132), 0, 1, 1, "S58C5");
    set_bf_and_test(lv, s58c5f1, ABISELECT(188,132), 1, 1, 1, "S58C5");
    set_bf_and_test(lv, s58c5f2, ABISELECT(188,132), 2, 1, 1, "S58C5");
    check_field_offset(lv, s58c5f3, ABISELECT(192,136), "S58C5.s58c5f3");
    check_field_offset(lv, s58c5f4, ABISELECT(208,148), "S58C5.s58c5f4");
    check_field_offset(lv, s58c5f5, ABISELECT(224,160), "S58C5.s58c5f5");
    check_field_offset(lv, s58c5f6, ABISELECT(240,172), "S58C5.s58c5f6");
    check_field_offset(lv, s58c5f7, ABISELECT(256,184), "S58C5.s58c5f7");
    test_class_info(&lv, &cd_S58C5);
    dp->~S58C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS58C5(Test_S58C5, "S58C5", ABISELECT(272,196));

#else // __cplusplus

extern void _ZN5S58C5C1Ev();
extern void _ZN5S58C5D1Ev();
Name_Map name_map_S58C5[] = {
  NSPAIR(_ZN5S58C5C1Ev),
  NSPAIR(_ZN5S58C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S58C7;
extern VTBL_ENTRY _ZTI5S58C7[];
extern  VTBL_ENTRY _ZTV5S58C7[];
extern Class_Descriptor cd_S58C6;
extern VTBL_ENTRY _ZTI5S58C6[];
extern  VTBL_ENTRY _ZTV5S58C6[];
static Base_Class bases_S58C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S58C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S58C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S58C5[];
extern void _ZN5S58C5D1Ev();
extern void _ZN5S58C5D0Ev();
extern void _ZN5S58C72v3Ev();
extern void _ZN5S58C72v4Ev();
extern void _ZN5S58C72v5Ev();
extern void _ZN5S58C72v6Ev();
extern void _ZN5S58C72v7Ev();
extern void _ZN5S58C72v8Ev();
extern void _ZN5S58C72v9Ev();
extern void _ZN5S58C73v10Ev();
extern void _ZN5S58C73v11Ev();
extern void _ZN5S58C73v12Ev();
extern void _ZN5S58C73v13Ev();
extern void _ZN5S58C73v14Ev();
extern void _ZN5S58C73v15Ev();
extern void _ZN5S58C73v16Ev();
extern void _ZN5S58C73v17Ev();
extern void _ZN5S58C73v18Ev();
extern void _ZN5S58C73v19Ev();
extern void _ZN5S58C73v20Ev();
extern void _ZN5S58C73v21Ev();
extern void _ZN5S58C73v22Ev();
extern void _ZN5S58C73v23Ev();
extern void _ZN5S58C73v24Ev();
extern void _ZN5S58C73v25Ev();
extern void _ZN5S58C73v26Ev();
extern void _ZN5S58C73v27Ev();
extern void _ZN5S58C73v28Ev();
extern void _ZN5S58C73v29Ev();
extern void _ZN5S58C73v30Ev();
extern void _ZN5S58C73v31Ev();
extern void _ZN5S58C73v32Ev();
extern void _ZN5S58C73v33Ev();
extern void _ZN5S58C73v34Ev();
extern void _ZN5S58C73v35Ev();
extern void _ZN5S58C73v36Ev();
extern void _ZN5S58C73v37Ev();
extern void _ZN5S58C73v38Ev();
extern void _ZN5S58C73v39Ev();
extern void _ZN5S58C73v40Ev();
extern void _ZN5S58C73v41Ev();
extern void _ZN5S58C73v42Ev();
extern void _ZN5S58C73v43Ev();
extern void _ZN5S58C73v44Ev();
extern void _ZN5S58C73v45Ev();
extern void _ZN5S58C73v46Ev();
extern void _ZN5S58C73v47Ev();
extern void _ZN5S58C73v48Ev();
extern void _ZN5S58C73v49Ev();
extern void _ZN5S58C73v50Ev();
extern void _ZN5S58C73v51Ev();
extern void _ZN5S58C73v52Ev();
extern void _ZN5S58C73v53Ev();
extern void _ZN5S58C73v54Ev();
extern void _ZN5S58C73v55Ev();
extern void _ZN5S58C73v56Ev();
extern void _ZN5S58C73v57Ev();
extern void _ZN5S58C73v58Ev();
extern void _ZN5S58C73v59Ev();
extern void _ZN5S58C73v60Ev();
extern void _ZN5S58C73v61Ev();
extern void _ZN5S58C73v62Ev();
extern void _ZN5S58C73v63Ev();
extern void _ZN5S58C73v64Ev();
extern void _ZN5S58C73v65Ev();
extern void _ZN5S58C73v66Ev();
extern void _ZN5S58C63v67Ev();
extern void _ZN5S58C63v68Ev();
extern void _ZN5S58C63v69Ev();
extern void _ZN5S58C63v70Ev();
extern void _ZN5S58C63v71Ev();
extern void _ZN5S58C63v72Ev();
extern void _ZN5S58C63v73Ev();
extern void _ZN5S58C63v74Ev();
extern void _ZN5S58C63v75Ev();
extern void _ZN5S58C63v76Ev();
extern void _ZN5S58C63v77Ev();
extern void _ZN5S58C63v78Ev();
extern void _ZN5S58C63v79Ev();
extern void _ZN5S58C63v80Ev();
extern void _ZN5S58C63v81Ev();
extern void _ZN5S58C63v82Ev();
extern void _ZN5S58C63v83Ev();
extern void _ZN5S58C63v84Ev();
extern void _ZN5S58C63v85Ev();
extern void _ZN5S58C63v86Ev();
extern void _ZN5S58C63v87Ev();
extern void _ZN5S58C63v88Ev();
extern void _ZN5S58C53v89Ev();
extern void _ZN5S58C53v90Ev();
extern void _ZN5S58C53v91Ev();
extern void _ZN5S58C53v92Ev();
extern void _ZN5S58C53v93Ev();
extern void _ZN5S58C53v94Ev();
extern void _ZN5S58C53v95Ev();
extern void _ZN5S58C53v96Ev();
extern void _ZN5S58C53v97Ev();
extern void _ZN5S58C53v98Ev();
extern void _ZN5S58C53v99Ev();
extern void _ZN5S58C54v100Ev();
extern void _ZN5S58C54v101Ev();
extern void _ZN5S58C54v102Ev();
extern void _ZN5S58C54v103Ev();
extern void _ZN5S58C54v104Ev();
extern void _ZN5S58C54v105Ev();
extern void _ZN5S58C54v106Ev();
extern void _ZN5S58C54v107Ev();
extern void _ZN5S58C54v108Ev();
static  VTBL_ENTRY vtc_S58C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S58C5[0]),
  (VTBL_ENTRY)&_ZN5S58C5D1Ev,
  (VTBL_ENTRY)&_ZN5S58C5D0Ev,
  (VTBL_ENTRY)&_ZN5S58C72v3Ev,
  (VTBL_ENTRY)&_ZN5S58C72v4Ev,
  (VTBL_ENTRY)&_ZN5S58C72v5Ev,
  (VTBL_ENTRY)&_ZN5S58C72v6Ev,
  (VTBL_ENTRY)&_ZN5S58C72v7Ev,
  (VTBL_ENTRY)&_ZN5S58C72v8Ev,
  (VTBL_ENTRY)&_ZN5S58C72v9Ev,
  (VTBL_ENTRY)&_ZN5S58C73v10Ev,
  (VTBL_ENTRY)&_ZN5S58C73v11Ev,
  (VTBL_ENTRY)&_ZN5S58C73v12Ev,
  (VTBL_ENTRY)&_ZN5S58C73v13Ev,
  (VTBL_ENTRY)&_ZN5S58C73v14Ev,
  (VTBL_ENTRY)&_ZN5S58C73v15Ev,
  (VTBL_ENTRY)&_ZN5S58C73v16Ev,
  (VTBL_ENTRY)&_ZN5S58C73v17Ev,
  (VTBL_ENTRY)&_ZN5S58C73v18Ev,
  (VTBL_ENTRY)&_ZN5S58C73v19Ev,
  (VTBL_ENTRY)&_ZN5S58C73v20Ev,
  (VTBL_ENTRY)&_ZN5S58C73v21Ev,
  (VTBL_ENTRY)&_ZN5S58C73v22Ev,
  (VTBL_ENTRY)&_ZN5S58C73v23Ev,
  (VTBL_ENTRY)&_ZN5S58C73v24Ev,
  (VTBL_ENTRY)&_ZN5S58C73v25Ev,
  (VTBL_ENTRY)&_ZN5S58C73v26Ev,
  (VTBL_ENTRY)&_ZN5S58C73v27Ev,
  (VTBL_ENTRY)&_ZN5S58C73v28Ev,
  (VTBL_ENTRY)&_ZN5S58C73v29Ev,
  (VTBL_ENTRY)&_ZN5S58C73v30Ev,
  (VTBL_ENTRY)&_ZN5S58C73v31Ev,
  (VTBL_ENTRY)&_ZN5S58C73v32Ev,
  (VTBL_ENTRY)&_ZN5S58C73v33Ev,
  (VTBL_ENTRY)&_ZN5S58C73v34Ev,
  (VTBL_ENTRY)&_ZN5S58C73v35Ev,
  (VTBL_ENTRY)&_ZN5S58C73v36Ev,
  (VTBL_ENTRY)&_ZN5S58C73v37Ev,
  (VTBL_ENTRY)&_ZN5S58C73v38Ev,
  (VTBL_ENTRY)&_ZN5S58C73v39Ev,
  (VTBL_ENTRY)&_ZN5S58C73v40Ev,
  (VTBL_ENTRY)&_ZN5S58C73v41Ev,
  (VTBL_ENTRY)&_ZN5S58C73v42Ev,
  (VTBL_ENTRY)&_ZN5S58C73v43Ev,
  (VTBL_ENTRY)&_ZN5S58C73v44Ev,
  (VTBL_ENTRY)&_ZN5S58C73v45Ev,
  (VTBL_ENTRY)&_ZN5S58C73v46Ev,
  (VTBL_ENTRY)&_ZN5S58C73v47Ev,
  (VTBL_ENTRY)&_ZN5S58C73v48Ev,
  (VTBL_ENTRY)&_ZN5S58C73v49Ev,
  (VTBL_ENTRY)&_ZN5S58C73v50Ev,
  (VTBL_ENTRY)&_ZN5S58C73v51Ev,
  (VTBL_ENTRY)&_ZN5S58C73v52Ev,
  (VTBL_ENTRY)&_ZN5S58C73v53Ev,
  (VTBL_ENTRY)&_ZN5S58C73v54Ev,
  (VTBL_ENTRY)&_ZN5S58C73v55Ev,
  (VTBL_ENTRY)&_ZN5S58C73v56Ev,
  (VTBL_ENTRY)&_ZN5S58C73v57Ev,
  (VTBL_ENTRY)&_ZN5S58C73v58Ev,
  (VTBL_ENTRY)&_ZN5S58C73v59Ev,
  (VTBL_ENTRY)&_ZN5S58C73v60Ev,
  (VTBL_ENTRY)&_ZN5S58C73v61Ev,
  (VTBL_ENTRY)&_ZN5S58C73v62Ev,
  (VTBL_ENTRY)&_ZN5S58C73v63Ev,
  (VTBL_ENTRY)&_ZN5S58C73v64Ev,
  (VTBL_ENTRY)&_ZN5S58C73v65Ev,
  (VTBL_ENTRY)&_ZN5S58C73v66Ev,
  (VTBL_ENTRY)&_ZN5S58C63v67Ev,
  (VTBL_ENTRY)&_ZN5S58C63v68Ev,
  (VTBL_ENTRY)&_ZN5S58C63v69Ev,
  (VTBL_ENTRY)&_ZN5S58C63v70Ev,
  (VTBL_ENTRY)&_ZN5S58C63v71Ev,
  (VTBL_ENTRY)&_ZN5S58C63v72Ev,
  (VTBL_ENTRY)&_ZN5S58C63v73Ev,
  (VTBL_ENTRY)&_ZN5S58C63v74Ev,
  (VTBL_ENTRY)&_ZN5S58C63v75Ev,
  (VTBL_ENTRY)&_ZN5S58C63v76Ev,
  (VTBL_ENTRY)&_ZN5S58C63v77Ev,
  (VTBL_ENTRY)&_ZN5S58C63v78Ev,
  (VTBL_ENTRY)&_ZN5S58C63v79Ev,
  (VTBL_ENTRY)&_ZN5S58C63v80Ev,
  (VTBL_ENTRY)&_ZN5S58C63v81Ev,
  (VTBL_ENTRY)&_ZN5S58C63v82Ev,
  (VTBL_ENTRY)&_ZN5S58C63v83Ev,
  (VTBL_ENTRY)&_ZN5S58C63v84Ev,
  (VTBL_ENTRY)&_ZN5S58C63v85Ev,
  (VTBL_ENTRY)&_ZN5S58C63v86Ev,
  (VTBL_ENTRY)&_ZN5S58C63v87Ev,
  (VTBL_ENTRY)&_ZN5S58C63v88Ev,
  (VTBL_ENTRY)&_ZN5S58C53v89Ev,
  (VTBL_ENTRY)&_ZN5S58C53v90Ev,
  (VTBL_ENTRY)&_ZN5S58C53v91Ev,
  (VTBL_ENTRY)&_ZN5S58C53v92Ev,
  (VTBL_ENTRY)&_ZN5S58C53v93Ev,
  (VTBL_ENTRY)&_ZN5S58C53v94Ev,
  (VTBL_ENTRY)&_ZN5S58C53v95Ev,
  (VTBL_ENTRY)&_ZN5S58C53v96Ev,
  (VTBL_ENTRY)&_ZN5S58C53v97Ev,
  (VTBL_ENTRY)&_ZN5S58C53v98Ev,
  (VTBL_ENTRY)&_ZN5S58C53v99Ev,
  (VTBL_ENTRY)&_ZN5S58C54v100Ev,
  (VTBL_ENTRY)&_ZN5S58C54v101Ev,
  (VTBL_ENTRY)&_ZN5S58C54v102Ev,
  (VTBL_ENTRY)&_ZN5S58C54v103Ev,
  (VTBL_ENTRY)&_ZN5S58C54v104Ev,
  (VTBL_ENTRY)&_ZN5S58C54v105Ev,
  (VTBL_ENTRY)&_ZN5S58C54v106Ev,
  (VTBL_ENTRY)&_ZN5S58C54v107Ev,
  (VTBL_ENTRY)&_ZN5S58C54v108Ev,
};
extern VTBL_ENTRY _ZTI5S58C5[];
extern  VTBL_ENTRY _ZTV5S58C5[];
Class_Descriptor cd_S58C5 = {  "S58C5", // class name
  bases_S58C5, 2,
  &(vtc_S58C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI5S58C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S58C5),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S58C4  : S58C5 {
  void *s58c4f0[2];
  int s58c4f1[4];
  unsigned int s58c4f2:1;
  unsigned int s58c4f3:1;
  unsigned int s58c4f4:1;
  char s58c4f5;
  int s58c4f6;
  unsigned int s58c4f7:1;
  ::S287C23 s58c4f8;
  virtual  ~S58C4(); // _ZN5S58C4D1Ev
  virtual void  v109(); // _ZN5S58C44v109Ev
  virtual void  v110(); // _ZN5S58C44v110Ev
  virtual void  v111(); // _ZN5S58C44v111Ev
  virtual void  v112(); // _ZN5S58C44v112Ev
  virtual void  v113(); // _ZN5S58C44v113Ev
  virtual void  v114(); // _ZN5S58C44v114Ev
  virtual void  v115(); // _ZN5S58C44v115Ev
  virtual void  v116(); // _ZN5S58C44v116Ev
  virtual void  v117(); // _ZN5S58C44v117Ev
  virtual void  v118(); // _ZN5S58C44v118Ev
  virtual void  v119(); // _ZN5S58C44v119Ev
  virtual void  v120(); // _ZN5S58C44v120Ev
  virtual void  v121(); // _ZN5S58C44v121Ev
  virtual void  v122(); // _ZN5S58C44v122Ev
  S58C4(); // tgen
};
//SIG(-1 S58C4) C1{ BC2{ BC3{ BC4{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} FC17{ BC18{ BC9}} Fi[3]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] Fi[4] Fi:1 Fi:1 Fi:1 Fc Fi Fi:1 FC19{ BC20{ BC9}}}


 S58C4 ::~S58C4(){ note_dtor("S58C4", this);}
void  S58C4 ::v109(){vfunc_called(this, "_ZN5S58C44v109Ev");}
void  S58C4 ::v110(){vfunc_called(this, "_ZN5S58C44v110Ev");}
void  S58C4 ::v111(){vfunc_called(this, "_ZN5S58C44v111Ev");}
void  S58C4 ::v112(){vfunc_called(this, "_ZN5S58C44v112Ev");}
void  S58C4 ::v113(){vfunc_called(this, "_ZN5S58C44v113Ev");}
void  S58C4 ::v114(){vfunc_called(this, "_ZN5S58C44v114Ev");}
void  S58C4 ::v115(){vfunc_called(this, "_ZN5S58C44v115Ev");}
void  S58C4 ::v116(){vfunc_called(this, "_ZN5S58C44v116Ev");}
void  S58C4 ::v117(){vfunc_called(this, "_ZN5S58C44v117Ev");}
void  S58C4 ::v118(){vfunc_called(this, "_ZN5S58C44v118Ev");}
void  S58C4 ::v119(){vfunc_called(this, "_ZN5S58C44v119Ev");}
void  S58C4 ::v120(){vfunc_called(this, "_ZN5S58C44v120Ev");}
void  S58C4 ::v121(){vfunc_called(this, "_ZN5S58C44v121Ev");}
void  S58C4 ::v122(){vfunc_called(this, "_ZN5S58C44v122Ev");}
S58C4 ::S58C4(){ note_ctor("S58C4", this);} // tgen

static void Test_S58C4()
{
  extern Class_Descriptor cd_S58C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(43,62)];
    init_test(&cd_S58C4, buf);
    S58C4 *dp, &lv = *(dp=new (buf) S58C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(336,244), "sizeof(S58C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S58C4)");
    check_base_class_offset(lv, (S58C7*)(S58C6*)(S58C5*), 0, "S58C4");
    check_base_class_offset(lv, (S58C6*)(S58C5*), 0, "S58C4");
    check_base_class_offset(lv, (S58C5*), 0, "S58C4");
    check_field_offset(lv, s58c4f0, ABISELECT(272,196), "S58C4.s58c4f0");
    check_field_offset(lv, s58c4f1, ABISELECT(288,204), "S58C4.s58c4f1");
    set_bf_and_test(lv, s58c4f2, ABISELECT(304,220), 0, 1, 1, "S58C4");
    set_bf_and_test(lv, s58c4f3, ABISELECT(304,220), 1, 1, 1, "S58C4");
    set_bf_and_test(lv, s58c4f4, ABISELECT(304,220), 2, 1, 1, "S58C4");
    check_field_offset(lv, s58c4f5, ABISELECT(305,221), "S58C4.s58c4f5");
    check_field_offset(lv, s58c4f6, ABISELECT(308,224), "S58C4.s58c4f6");
    set_bf_and_test(lv, s58c4f7, ABISELECT(312,228), 0, 1, 1, "S58C4");
    check_field_offset(lv, s58c4f8, ABISELECT(320,232), "S58C4.s58c4f8");
    test_class_info(&lv, &cd_S58C4);
    dp->~S58C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS58C4(Test_S58C4, "S58C4", ABISELECT(336,244));

#else // __cplusplus

extern void _ZN5S58C4C1Ev();
extern void _ZN5S58C4D1Ev();
Name_Map name_map_S58C4[] = {
  NSPAIR(_ZN5S58C4C1Ev),
  NSPAIR(_ZN5S58C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S58C7;
extern VTBL_ENTRY _ZTI5S58C7[];
extern  VTBL_ENTRY _ZTV5S58C7[];
extern Class_Descriptor cd_S58C6;
extern VTBL_ENTRY _ZTI5S58C6[];
extern  VTBL_ENTRY _ZTV5S58C6[];
extern Class_Descriptor cd_S58C5;
extern VTBL_ENTRY _ZTI5S58C5[];
extern  VTBL_ENTRY _ZTV5S58C5[];
static Base_Class bases_S58C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S58C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S58C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S58C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S58C4[];
extern void _ZN5S58C4D1Ev();
extern void _ZN5S58C4D0Ev();
extern void _ZN5S58C72v3Ev();
extern void _ZN5S58C72v4Ev();
extern void _ZN5S58C72v5Ev();
extern void _ZN5S58C72v6Ev();
extern void _ZN5S58C72v7Ev();
extern void _ZN5S58C72v8Ev();
extern void _ZN5S58C72v9Ev();
extern void _ZN5S58C73v10Ev();
extern void _ZN5S58C73v11Ev();
extern void _ZN5S58C73v12Ev();
extern void _ZN5S58C73v13Ev();
extern void _ZN5S58C73v14Ev();
extern void _ZN5S58C73v15Ev();
extern void _ZN5S58C73v16Ev();
extern void _ZN5S58C73v17Ev();
extern void _ZN5S58C73v18Ev();
extern void _ZN5S58C73v19Ev();
extern void _ZN5S58C73v20Ev();
extern void _ZN5S58C73v21Ev();
extern void _ZN5S58C73v22Ev();
extern void _ZN5S58C73v23Ev();
extern void _ZN5S58C73v24Ev();
extern void _ZN5S58C73v25Ev();
extern void _ZN5S58C73v26Ev();
extern void _ZN5S58C73v27Ev();
extern void _ZN5S58C73v28Ev();
extern void _ZN5S58C73v29Ev();
extern void _ZN5S58C73v30Ev();
extern void _ZN5S58C73v31Ev();
extern void _ZN5S58C73v32Ev();
extern void _ZN5S58C73v33Ev();
extern void _ZN5S58C73v34Ev();
extern void _ZN5S58C73v35Ev();
extern void _ZN5S58C73v36Ev();
extern void _ZN5S58C73v37Ev();
extern void _ZN5S58C73v38Ev();
extern void _ZN5S58C73v39Ev();
extern void _ZN5S58C73v40Ev();
extern void _ZN5S58C73v41Ev();
extern void _ZN5S58C73v42Ev();
extern void _ZN5S58C73v43Ev();
extern void _ZN5S58C73v44Ev();
extern void _ZN5S58C73v45Ev();
extern void _ZN5S58C73v46Ev();
extern void _ZN5S58C73v47Ev();
extern void _ZN5S58C73v48Ev();
extern void _ZN5S58C73v49Ev();
extern void _ZN5S58C73v50Ev();
extern void _ZN5S58C73v51Ev();
extern void _ZN5S58C73v52Ev();
extern void _ZN5S58C73v53Ev();
extern void _ZN5S58C73v54Ev();
extern void _ZN5S58C73v55Ev();
extern void _ZN5S58C73v56Ev();
extern void _ZN5S58C73v57Ev();
extern void _ZN5S58C73v58Ev();
extern void _ZN5S58C73v59Ev();
extern void _ZN5S58C73v60Ev();
extern void _ZN5S58C73v61Ev();
extern void _ZN5S58C73v62Ev();
extern void _ZN5S58C73v63Ev();
extern void _ZN5S58C73v64Ev();
extern void _ZN5S58C73v65Ev();
extern void _ZN5S58C73v66Ev();
extern void _ZN5S58C63v67Ev();
extern void _ZN5S58C63v68Ev();
extern void _ZN5S58C63v69Ev();
extern void _ZN5S58C63v70Ev();
extern void _ZN5S58C63v71Ev();
extern void _ZN5S58C63v72Ev();
extern void _ZN5S58C63v73Ev();
extern void _ZN5S58C63v74Ev();
extern void _ZN5S58C63v75Ev();
extern void _ZN5S58C63v76Ev();
extern void _ZN5S58C63v77Ev();
extern void _ZN5S58C63v78Ev();
extern void _ZN5S58C63v79Ev();
extern void _ZN5S58C63v80Ev();
extern void _ZN5S58C63v81Ev();
extern void _ZN5S58C63v82Ev();
extern void _ZN5S58C63v83Ev();
extern void _ZN5S58C63v84Ev();
extern void _ZN5S58C63v85Ev();
extern void _ZN5S58C63v86Ev();
extern void _ZN5S58C63v87Ev();
extern void _ZN5S58C63v88Ev();
extern void _ZN5S58C53v89Ev();
extern void _ZN5S58C53v90Ev();
extern void _ZN5S58C53v91Ev();
extern void _ZN5S58C53v92Ev();
extern void _ZN5S58C53v93Ev();
extern void _ZN5S58C53v94Ev();
extern void _ZN5S58C53v95Ev();
extern void _ZN5S58C53v96Ev();
extern void _ZN5S58C53v97Ev();
extern void _ZN5S58C53v98Ev();
extern void _ZN5S58C53v99Ev();
extern void _ZN5S58C54v100Ev();
extern void _ZN5S58C54v101Ev();
extern void _ZN5S58C54v102Ev();
extern void _ZN5S58C54v103Ev();
extern void _ZN5S58C54v104Ev();
extern void _ZN5S58C54v105Ev();
extern void _ZN5S58C54v106Ev();
extern void _ZN5S58C54v107Ev();
extern void _ZN5S58C54v108Ev();
extern void _ZN5S58C44v109Ev();
extern void _ZN5S58C44v110Ev();
extern void _ZN5S58C44v111Ev();
extern void _ZN5S58C44v112Ev();
extern void _ZN5S58C44v113Ev();
extern void _ZN5S58C44v114Ev();
extern void _ZN5S58C44v115Ev();
extern void _ZN5S58C44v116Ev();
extern void _ZN5S58C44v117Ev();
extern void _ZN5S58C44v118Ev();
extern void _ZN5S58C44v119Ev();
extern void _ZN5S58C44v120Ev();
extern void _ZN5S58C44v121Ev();
extern void _ZN5S58C44v122Ev();
static  VTBL_ENTRY vtc_S58C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S58C4[0]),
  (VTBL_ENTRY)&_ZN5S58C4D1Ev,
  (VTBL_ENTRY)&_ZN5S58C4D0Ev,
  (VTBL_ENTRY)&_ZN5S58C72v3Ev,
  (VTBL_ENTRY)&_ZN5S58C72v4Ev,
  (VTBL_ENTRY)&_ZN5S58C72v5Ev,
  (VTBL_ENTRY)&_ZN5S58C72v6Ev,
  (VTBL_ENTRY)&_ZN5S58C72v7Ev,
  (VTBL_ENTRY)&_ZN5S58C72v8Ev,
  (VTBL_ENTRY)&_ZN5S58C72v9Ev,
  (VTBL_ENTRY)&_ZN5S58C73v10Ev,
  (VTBL_ENTRY)&_ZN5S58C73v11Ev,
  (VTBL_ENTRY)&_ZN5S58C73v12Ev,
  (VTBL_ENTRY)&_ZN5S58C73v13Ev,
  (VTBL_ENTRY)&_ZN5S58C73v14Ev,
  (VTBL_ENTRY)&_ZN5S58C73v15Ev,
  (VTBL_ENTRY)&_ZN5S58C73v16Ev,
  (VTBL_ENTRY)&_ZN5S58C73v17Ev,
  (VTBL_ENTRY)&_ZN5S58C73v18Ev,
  (VTBL_ENTRY)&_ZN5S58C73v19Ev,
  (VTBL_ENTRY)&_ZN5S58C73v20Ev,
  (VTBL_ENTRY)&_ZN5S58C73v21Ev,
  (VTBL_ENTRY)&_ZN5S58C73v22Ev,
  (VTBL_ENTRY)&_ZN5S58C73v23Ev,
  (VTBL_ENTRY)&_ZN5S58C73v24Ev,
  (VTBL_ENTRY)&_ZN5S58C73v25Ev,
  (VTBL_ENTRY)&_ZN5S58C73v26Ev,
  (VTBL_ENTRY)&_ZN5S58C73v27Ev,
  (VTBL_ENTRY)&_ZN5S58C73v28Ev,
  (VTBL_ENTRY)&_ZN5S58C73v29Ev,
  (VTBL_ENTRY)&_ZN5S58C73v30Ev,
  (VTBL_ENTRY)&_ZN5S58C73v31Ev,
  (VTBL_ENTRY)&_ZN5S58C73v32Ev,
  (VTBL_ENTRY)&_ZN5S58C73v33Ev,
  (VTBL_ENTRY)&_ZN5S58C73v34Ev,
  (VTBL_ENTRY)&_ZN5S58C73v35Ev,
  (VTBL_ENTRY)&_ZN5S58C73v36Ev,
  (VTBL_ENTRY)&_ZN5S58C73v37Ev,
  (VTBL_ENTRY)&_ZN5S58C73v38Ev,
  (VTBL_ENTRY)&_ZN5S58C73v39Ev,
  (VTBL_ENTRY)&_ZN5S58C73v40Ev,
  (VTBL_ENTRY)&_ZN5S58C73v41Ev,
  (VTBL_ENTRY)&_ZN5S58C73v42Ev,
  (VTBL_ENTRY)&_ZN5S58C73v43Ev,
  (VTBL_ENTRY)&_ZN5S58C73v44Ev,
  (VTBL_ENTRY)&_ZN5S58C73v45Ev,
  (VTBL_ENTRY)&_ZN5S58C73v46Ev,
  (VTBL_ENTRY)&_ZN5S58C73v47Ev,
  (VTBL_ENTRY)&_ZN5S58C73v48Ev,
  (VTBL_ENTRY)&_ZN5S58C73v49Ev,
  (VTBL_ENTRY)&_ZN5S58C73v50Ev,
  (VTBL_ENTRY)&_ZN5S58C73v51Ev,
  (VTBL_ENTRY)&_ZN5S58C73v52Ev,
  (VTBL_ENTRY)&_ZN5S58C73v53Ev,
  (VTBL_ENTRY)&_ZN5S58C73v54Ev,
  (VTBL_ENTRY)&_ZN5S58C73v55Ev,
  (VTBL_ENTRY)&_ZN5S58C73v56Ev,
  (VTBL_ENTRY)&_ZN5S58C73v57Ev,
  (VTBL_ENTRY)&_ZN5S58C73v58Ev,
  (VTBL_ENTRY)&_ZN5S58C73v59Ev,
  (VTBL_ENTRY)&_ZN5S58C73v60Ev,
  (VTBL_ENTRY)&_ZN5S58C73v61Ev,
  (VTBL_ENTRY)&_ZN5S58C73v62Ev,
  (VTBL_ENTRY)&_ZN5S58C73v63Ev,
  (VTBL_ENTRY)&_ZN5S58C73v64Ev,
  (VTBL_ENTRY)&_ZN5S58C73v65Ev,
  (VTBL_ENTRY)&_ZN5S58C73v66Ev,
  (VTBL_ENTRY)&_ZN5S58C63v67Ev,
  (VTBL_ENTRY)&_ZN5S58C63v68Ev,
  (VTBL_ENTRY)&_ZN5S58C63v69Ev,
  (VTBL_ENTRY)&_ZN5S58C63v70Ev,
  (VTBL_ENTRY)&_ZN5S58C63v71Ev,
  (VTBL_ENTRY)&_ZN5S58C63v72Ev,
  (VTBL_ENTRY)&_ZN5S58C63v73Ev,
  (VTBL_ENTRY)&_ZN5S58C63v74Ev,
  (VTBL_ENTRY)&_ZN5S58C63v75Ev,
  (VTBL_ENTRY)&_ZN5S58C63v76Ev,
  (VTBL_ENTRY)&_ZN5S58C63v77Ev,
  (VTBL_ENTRY)&_ZN5S58C63v78Ev,
  (VTBL_ENTRY)&_ZN5S58C63v79Ev,
  (VTBL_ENTRY)&_ZN5S58C63v80Ev,
  (VTBL_ENTRY)&_ZN5S58C63v81Ev,
  (VTBL_ENTRY)&_ZN5S58C63v82Ev,
  (VTBL_ENTRY)&_ZN5S58C63v83Ev,
  (VTBL_ENTRY)&_ZN5S58C63v84Ev,
  (VTBL_ENTRY)&_ZN5S58C63v85Ev,
  (VTBL_ENTRY)&_ZN5S58C63v86Ev,
  (VTBL_ENTRY)&_ZN5S58C63v87Ev,
  (VTBL_ENTRY)&_ZN5S58C63v88Ev,
  (VTBL_ENTRY)&_ZN5S58C53v89Ev,
  (VTBL_ENTRY)&_ZN5S58C53v90Ev,
  (VTBL_ENTRY)&_ZN5S58C53v91Ev,
  (VTBL_ENTRY)&_ZN5S58C53v92Ev,
  (VTBL_ENTRY)&_ZN5S58C53v93Ev,
  (VTBL_ENTRY)&_ZN5S58C53v94Ev,
  (VTBL_ENTRY)&_ZN5S58C53v95Ev,
  (VTBL_ENTRY)&_ZN5S58C53v96Ev,
  (VTBL_ENTRY)&_ZN5S58C53v97Ev,
  (VTBL_ENTRY)&_ZN5S58C53v98Ev,
  (VTBL_ENTRY)&_ZN5S58C53v99Ev,
  (VTBL_ENTRY)&_ZN5S58C54v100Ev,
  (VTBL_ENTRY)&_ZN5S58C54v101Ev,
  (VTBL_ENTRY)&_ZN5S58C54v102Ev,
  (VTBL_ENTRY)&_ZN5S58C54v103Ev,
  (VTBL_ENTRY)&_ZN5S58C54v104Ev,
  (VTBL_ENTRY)&_ZN5S58C54v105Ev,
  (VTBL_ENTRY)&_ZN5S58C54v106Ev,
  (VTBL_ENTRY)&_ZN5S58C54v107Ev,
  (VTBL_ENTRY)&_ZN5S58C54v108Ev,
  (VTBL_ENTRY)&_ZN5S58C44v109Ev,
  (VTBL_ENTRY)&_ZN5S58C44v110Ev,
  (VTBL_ENTRY)&_ZN5S58C44v111Ev,
  (VTBL_ENTRY)&_ZN5S58C44v112Ev,
  (VTBL_ENTRY)&_ZN5S58C44v113Ev,
  (VTBL_ENTRY)&_ZN5S58C44v114Ev,
  (VTBL_ENTRY)&_ZN5S58C44v115Ev,
  (VTBL_ENTRY)&_ZN5S58C44v116Ev,
  (VTBL_ENTRY)&_ZN5S58C44v117Ev,
  (VTBL_ENTRY)&_ZN5S58C44v118Ev,
  (VTBL_ENTRY)&_ZN5S58C44v119Ev,
  (VTBL_ENTRY)&_ZN5S58C44v120Ev,
  (VTBL_ENTRY)&_ZN5S58C44v121Ev,
  (VTBL_ENTRY)&_ZN5S58C44v122Ev,
};
extern VTBL_ENTRY _ZTI5S58C4[];
extern  VTBL_ENTRY _ZTV5S58C4[];
Class_Descriptor cd_S58C4 = {  "S58C4", // class name
  bases_S58C4, 3,
  &(vtc_S58C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(336,244), // object size
  NSPAIRA(_ZTI5S58C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S58C4),124, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S58C3  : S58C4 {
  void *s58c3f0[2];
  ::S287C8_nt s58c3f1;
  unsigned int s58c3f2:1;
  unsigned int s58c3f3:1;
  ::S3350C21_nt s58c3f4;
  virtual  ~S58C3(); // _ZN5S58C3D1Ev
  virtual void  v123(); // _ZN5S58C34v123Ev
  virtual void  v124(); // _ZN5S58C34v124Ev
  virtual void  v125(); // _ZN5S58C34v125Ev
  virtual void  v126(); // _ZN5S58C34v126Ev
  virtual void  v127(); // _ZN5S58C34v127Ev
  virtual void  v128(); // _ZN5S58C34v128Ev
  virtual void  v129(); // _ZN5S58C34v129Ev
  virtual void  v130(); // _ZN5S58C34v130Ev
  virtual void  v131(); // _ZN5S58C34v131Ev
  virtual void  v132(); // _ZN5S58C34v132Ev
  virtual void  v133(); // _ZN5S58C34v133Ev
  S58C3(); // tgen
};
//SIG(-1 S58C3) C1{ BC2{ BC3{ BC4{ BC5{ vd v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} FC18{ BC19{ BC10}} Fi[3]} vd v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 Fp[2] Fi[4] Fi:1 Fi:1 Fi:1 Fc Fi Fi:1 FC20{ BC21{ BC10}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 Fp[2] FC7 Fi:1 Fi:1 FC22{ m Fp FC6}}


 S58C3 ::~S58C3(){ note_dtor("S58C3", this);}
void  S58C3 ::v123(){vfunc_called(this, "_ZN5S58C34v123Ev");}
void  S58C3 ::v124(){vfunc_called(this, "_ZN5S58C34v124Ev");}
void  S58C3 ::v125(){vfunc_called(this, "_ZN5S58C34v125Ev");}
void  S58C3 ::v126(){vfunc_called(this, "_ZN5S58C34v126Ev");}
void  S58C3 ::v127(){vfunc_called(this, "_ZN5S58C34v127Ev");}
void  S58C3 ::v128(){vfunc_called(this, "_ZN5S58C34v128Ev");}
void  S58C3 ::v129(){vfunc_called(this, "_ZN5S58C34v129Ev");}
void  S58C3 ::v130(){vfunc_called(this, "_ZN5S58C34v130Ev");}
void  S58C3 ::v131(){vfunc_called(this, "_ZN5S58C34v131Ev");}
void  S58C3 ::v132(){vfunc_called(this, "_ZN5S58C34v132Ev");}
void  S58C3 ::v133(){vfunc_called(this, "_ZN5S58C34v133Ev");}
S58C3 ::S58C3(){ note_ctor("S58C3", this);} // tgen

static void Test_S58C3()
{
  extern Class_Descriptor cd_S58C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(50,71)];
    init_test(&cd_S58C3, buf);
    S58C3 *dp, &lv = *(dp=new (buf) S58C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(392,280), "sizeof(S58C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S58C3)");
    check_base_class_offset(lv, (S58C7*)(S58C6*)(S58C5*)(S58C4*), 0, "S58C3");
    check_base_class_offset(lv, (S58C6*)(S58C5*)(S58C4*), 0, "S58C3");
    check_base_class_offset(lv, (S58C5*)(S58C4*), 0, "S58C3");
    check_base_class_offset(lv, (S58C4*), 0, "S58C3");
    check_field_offset(lv, s58c3f0, ABISELECT(336,244), "S58C3.s58c3f0");
    check_field_offset(lv, s58c3f1, ABISELECT(352,252), "S58C3.s58c3f1");
    set_bf_and_test(lv, s58c3f2, ABISELECT(368,264), 0, 1, 1, "S58C3");
    set_bf_and_test(lv, s58c3f3, ABISELECT(368,264), 1, 1, 1, "S58C3");
    check_field_offset(lv, s58c3f4, ABISELECT(376,268), "S58C3.s58c3f4");
    test_class_info(&lv, &cd_S58C3);
    dp->~S58C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS58C3(Test_S58C3, "S58C3", ABISELECT(392,280));

#else // __cplusplus

extern void _ZN5S58C3C1Ev();
extern void _ZN5S58C3D1Ev();
Name_Map name_map_S58C3[] = {
  NSPAIR(_ZN5S58C3C1Ev),
  NSPAIR(_ZN5S58C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S58C7;
extern VTBL_ENTRY _ZTI5S58C7[];
extern  VTBL_ENTRY _ZTV5S58C7[];
extern Class_Descriptor cd_S58C6;
extern VTBL_ENTRY _ZTI5S58C6[];
extern  VTBL_ENTRY _ZTV5S58C6[];
extern Class_Descriptor cd_S58C5;
extern VTBL_ENTRY _ZTI5S58C5[];
extern  VTBL_ENTRY _ZTV5S58C5[];
extern Class_Descriptor cd_S58C4;
extern VTBL_ENTRY _ZTI5S58C4[];
extern  VTBL_ENTRY _ZTV5S58C4[];
static Base_Class bases_S58C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S58C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S58C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S58C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S58C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S58C3[];
extern void _ZN5S58C3D1Ev();
extern void _ZN5S58C3D0Ev();
extern void _ZN5S58C72v3Ev();
extern void _ZN5S58C72v4Ev();
extern void _ZN5S58C72v5Ev();
extern void _ZN5S58C72v6Ev();
extern void _ZN5S58C72v7Ev();
extern void _ZN5S58C72v8Ev();
extern void _ZN5S58C72v9Ev();
extern void _ZN5S58C73v10Ev();
extern void _ZN5S58C73v11Ev();
extern void _ZN5S58C73v12Ev();
extern void _ZN5S58C73v13Ev();
extern void _ZN5S58C73v14Ev();
extern void _ZN5S58C73v15Ev();
extern void _ZN5S58C73v16Ev();
extern void _ZN5S58C73v17Ev();
extern void _ZN5S58C73v18Ev();
extern void _ZN5S58C73v19Ev();
extern void _ZN5S58C73v20Ev();
extern void _ZN5S58C73v21Ev();
extern void _ZN5S58C73v22Ev();
extern void _ZN5S58C73v23Ev();
extern void _ZN5S58C73v24Ev();
extern void _ZN5S58C73v25Ev();
extern void _ZN5S58C73v26Ev();
extern void _ZN5S58C73v27Ev();
extern void _ZN5S58C73v28Ev();
extern void _ZN5S58C73v29Ev();
extern void _ZN5S58C73v30Ev();
extern void _ZN5S58C73v31Ev();
extern void _ZN5S58C73v32Ev();
extern void _ZN5S58C73v33Ev();
extern void _ZN5S58C73v34Ev();
extern void _ZN5S58C73v35Ev();
extern void _ZN5S58C73v36Ev();
extern void _ZN5S58C73v37Ev();
extern void _ZN5S58C73v38Ev();
extern void _ZN5S58C73v39Ev();
extern void _ZN5S58C73v40Ev();
extern void _ZN5S58C73v41Ev();
extern void _ZN5S58C73v42Ev();
extern void _ZN5S58C73v43Ev();
extern void _ZN5S58C73v44Ev();
extern void _ZN5S58C73v45Ev();
extern void _ZN5S58C73v46Ev();
extern void _ZN5S58C73v47Ev();
extern void _ZN5S58C73v48Ev();
extern void _ZN5S58C73v49Ev();
extern void _ZN5S58C73v50Ev();
extern void _ZN5S58C73v51Ev();
extern void _ZN5S58C73v52Ev();
extern void _ZN5S58C73v53Ev();
extern void _ZN5S58C73v54Ev();
extern void _ZN5S58C73v55Ev();
extern void _ZN5S58C73v56Ev();
extern void _ZN5S58C73v57Ev();
extern void _ZN5S58C73v58Ev();
extern void _ZN5S58C73v59Ev();
extern void _ZN5S58C73v60Ev();
extern void _ZN5S58C73v61Ev();
extern void _ZN5S58C73v62Ev();
extern void _ZN5S58C73v63Ev();
extern void _ZN5S58C73v64Ev();
extern void _ZN5S58C73v65Ev();
extern void _ZN5S58C73v66Ev();
extern void _ZN5S58C63v67Ev();
extern void _ZN5S58C63v68Ev();
extern void _ZN5S58C63v69Ev();
extern void _ZN5S58C63v70Ev();
extern void _ZN5S58C63v71Ev();
extern void _ZN5S58C63v72Ev();
extern void _ZN5S58C63v73Ev();
extern void _ZN5S58C63v74Ev();
extern void _ZN5S58C63v75Ev();
extern void _ZN5S58C63v76Ev();
extern void _ZN5S58C63v77Ev();
extern void _ZN5S58C63v78Ev();
extern void _ZN5S58C63v79Ev();
extern void _ZN5S58C63v80Ev();
extern void _ZN5S58C63v81Ev();
extern void _ZN5S58C63v82Ev();
extern void _ZN5S58C63v83Ev();
extern void _ZN5S58C63v84Ev();
extern void _ZN5S58C63v85Ev();
extern void _ZN5S58C63v86Ev();
extern void _ZN5S58C63v87Ev();
extern void _ZN5S58C63v88Ev();
extern void _ZN5S58C53v89Ev();
extern void _ZN5S58C53v90Ev();
extern void _ZN5S58C53v91Ev();
extern void _ZN5S58C53v92Ev();
extern void _ZN5S58C53v93Ev();
extern void _ZN5S58C53v94Ev();
extern void _ZN5S58C53v95Ev();
extern void _ZN5S58C53v96Ev();
extern void _ZN5S58C53v97Ev();
extern void _ZN5S58C53v98Ev();
extern void _ZN5S58C53v99Ev();
extern void _ZN5S58C54v100Ev();
extern void _ZN5S58C54v101Ev();
extern void _ZN5S58C54v102Ev();
extern void _ZN5S58C54v103Ev();
extern void _ZN5S58C54v104Ev();
extern void _ZN5S58C54v105Ev();
extern void _ZN5S58C54v106Ev();
extern void _ZN5S58C54v107Ev();
extern void _ZN5S58C54v108Ev();
extern void _ZN5S58C44v109Ev();
extern void _ZN5S58C44v110Ev();
extern void _ZN5S58C44v111Ev();
extern void _ZN5S58C44v112Ev();
extern void _ZN5S58C44v113Ev();
extern void _ZN5S58C44v114Ev();
extern void _ZN5S58C44v115Ev();
extern void _ZN5S58C44v116Ev();
extern void _ZN5S58C44v117Ev();
extern void _ZN5S58C44v118Ev();
extern void _ZN5S58C44v119Ev();
extern void _ZN5S58C44v120Ev();
extern void _ZN5S58C44v121Ev();
extern void _ZN5S58C44v122Ev();
extern void _ZN5S58C34v123Ev();
extern void _ZN5S58C34v124Ev();
extern void _ZN5S58C34v125Ev();
extern void _ZN5S58C34v126Ev();
extern void _ZN5S58C34v127Ev();
extern void _ZN5S58C34v128Ev();
extern void _ZN5S58C34v129Ev();
extern void _ZN5S58C34v130Ev();
extern void _ZN5S58C34v131Ev();
extern void _ZN5S58C34v132Ev();
extern void _ZN5S58C34v133Ev();
static  VTBL_ENTRY vtc_S58C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S58C3[0]),
  (VTBL_ENTRY)&_ZN5S58C3D1Ev,
  (VTBL_ENTRY)&_ZN5S58C3D0Ev,
  (VTBL_ENTRY)&_ZN5S58C72v3Ev,
  (VTBL_ENTRY)&_ZN5S58C72v4Ev,
  (VTBL_ENTRY)&_ZN5S58C72v5Ev,
  (VTBL_ENTRY)&_ZN5S58C72v6Ev,
  (VTBL_ENTRY)&_ZN5S58C72v7Ev,
  (VTBL_ENTRY)&_ZN5S58C72v8Ev,
  (VTBL_ENTRY)&_ZN5S58C72v9Ev,
  (VTBL_ENTRY)&_ZN5S58C73v10Ev,
  (VTBL_ENTRY)&_ZN5S58C73v11Ev,
  (VTBL_ENTRY)&_ZN5S58C73v12Ev,
  (VTBL_ENTRY)&_ZN5S58C73v13Ev,
  (VTBL_ENTRY)&_ZN5S58C73v14Ev,
  (VTBL_ENTRY)&_ZN5S58C73v15Ev,
  (VTBL_ENTRY)&_ZN5S58C73v16Ev,
  (VTBL_ENTRY)&_ZN5S58C73v17Ev,
  (VTBL_ENTRY)&_ZN5S58C73v18Ev,
  (VTBL_ENTRY)&_ZN5S58C73v19Ev,
  (VTBL_ENTRY)&_ZN5S58C73v20Ev,
  (VTBL_ENTRY)&_ZN5S58C73v21Ev,
  (VTBL_ENTRY)&_ZN5S58C73v22Ev,
  (VTBL_ENTRY)&_ZN5S58C73v23Ev,
  (VTBL_ENTRY)&_ZN5S58C73v24Ev,
  (VTBL_ENTRY)&_ZN5S58C73v25Ev,
  (VTBL_ENTRY)&_ZN5S58C73v26Ev,
  (VTBL_ENTRY)&_ZN5S58C73v27Ev,
  (VTBL_ENTRY)&_ZN5S58C73v28Ev,
  (VTBL_ENTRY)&_ZN5S58C73v29Ev,
  (VTBL_ENTRY)&_ZN5S58C73v30Ev,
  (VTBL_ENTRY)&_ZN5S58C73v31Ev,
  (VTBL_ENTRY)&_ZN5S58C73v32Ev,
  (VTBL_ENTRY)&_ZN5S58C73v33Ev,
  (VTBL_ENTRY)&_ZN5S58C73v34Ev,
  (VTBL_ENTRY)&_ZN5S58C73v35Ev,
  (VTBL_ENTRY)&_ZN5S58C73v36Ev,
  (VTBL_ENTRY)&_ZN5S58C73v37Ev,
  (VTBL_ENTRY)&_ZN5S58C73v38Ev,
  (VTBL_ENTRY)&_ZN5S58C73v39Ev,
  (VTBL_ENTRY)&_ZN5S58C73v40Ev,
  (VTBL_ENTRY)&_ZN5S58C73v41Ev,
  (VTBL_ENTRY)&_ZN5S58C73v42Ev,
  (VTBL_ENTRY)&_ZN5S58C73v43Ev,
  (VTBL_ENTRY)&_ZN5S58C73v44Ev,
  (VTBL_ENTRY)&_ZN5S58C73v45Ev,
  (VTBL_ENTRY)&_ZN5S58C73v46Ev,
  (VTBL_ENTRY)&_ZN5S58C73v47Ev,
  (VTBL_ENTRY)&_ZN5S58C73v48Ev,
  (VTBL_ENTRY)&_ZN5S58C73v49Ev,
  (VTBL_ENTRY)&_ZN5S58C73v50Ev,
  (VTBL_ENTRY)&_ZN5S58C73v51Ev,
  (VTBL_ENTRY)&_ZN5S58C73v52Ev,
  (VTBL_ENTRY)&_ZN5S58C73v53Ev,
  (VTBL_ENTRY)&_ZN5S58C73v54Ev,
  (VTBL_ENTRY)&_ZN5S58C73v55Ev,
  (VTBL_ENTRY)&_ZN5S58C73v56Ev,
  (VTBL_ENTRY)&_ZN5S58C73v57Ev,
  (VTBL_ENTRY)&_ZN5S58C73v58Ev,
  (VTBL_ENTRY)&_ZN5S58C73v59Ev,
  (VTBL_ENTRY)&_ZN5S58C73v60Ev,
  (VTBL_ENTRY)&_ZN5S58C73v61Ev,
  (VTBL_ENTRY)&_ZN5S58C73v62Ev,
  (VTBL_ENTRY)&_ZN5S58C73v63Ev,
  (VTBL_ENTRY)&_ZN5S58C73v64Ev,
  (VTBL_ENTRY)&_ZN5S58C73v65Ev,
  (VTBL_ENTRY)&_ZN5S58C73v66Ev,
  (VTBL_ENTRY)&_ZN5S58C63v67Ev,
  (VTBL_ENTRY)&_ZN5S58C63v68Ev,
  (VTBL_ENTRY)&_ZN5S58C63v69Ev,
  (VTBL_ENTRY)&_ZN5S58C63v70Ev,
  (VTBL_ENTRY)&_ZN5S58C63v71Ev,
  (VTBL_ENTRY)&_ZN5S58C63v72Ev,
  (VTBL_ENTRY)&_ZN5S58C63v73Ev,
  (VTBL_ENTRY)&_ZN5S58C63v74Ev,
  (VTBL_ENTRY)&_ZN5S58C63v75Ev,
  (VTBL_ENTRY)&_ZN5S58C63v76Ev,
  (VTBL_ENTRY)&_ZN5S58C63v77Ev,
  (VTBL_ENTRY)&_ZN5S58C63v78Ev,
  (VTBL_ENTRY)&_ZN5S58C63v79Ev,
  (VTBL_ENTRY)&_ZN5S58C63v80Ev,
  (VTBL_ENTRY)&_ZN5S58C63v81Ev,
  (VTBL_ENTRY)&_ZN5S58C63v82Ev,
  (VTBL_ENTRY)&_ZN5S58C63v83Ev,
  (VTBL_ENTRY)&_ZN5S58C63v84Ev,
  (VTBL_ENTRY)&_ZN5S58C63v85Ev,
  (VTBL_ENTRY)&_ZN5S58C63v86Ev,
  (VTBL_ENTRY)&_ZN5S58C63v87Ev,
  (VTBL_ENTRY)&_ZN5S58C63v88Ev,
  (VTBL_ENTRY)&_ZN5S58C53v89Ev,
  (VTBL_ENTRY)&_ZN5S58C53v90Ev,
  (VTBL_ENTRY)&_ZN5S58C53v91Ev,
  (VTBL_ENTRY)&_ZN5S58C53v92Ev,
  (VTBL_ENTRY)&_ZN5S58C53v93Ev,
  (VTBL_ENTRY)&_ZN5S58C53v94Ev,
  (VTBL_ENTRY)&_ZN5S58C53v95Ev,
  (VTBL_ENTRY)&_ZN5S58C53v96Ev,
  (VTBL_ENTRY)&_ZN5S58C53v97Ev,
  (VTBL_ENTRY)&_ZN5S58C53v98Ev,
  (VTBL_ENTRY)&_ZN5S58C53v99Ev,
  (VTBL_ENTRY)&_ZN5S58C54v100Ev,
  (VTBL_ENTRY)&_ZN5S58C54v101Ev,
  (VTBL_ENTRY)&_ZN5S58C54v102Ev,
  (VTBL_ENTRY)&_ZN5S58C54v103Ev,
  (VTBL_ENTRY)&_ZN5S58C54v104Ev,
  (VTBL_ENTRY)&_ZN5S58C54v105Ev,
  (VTBL_ENTRY)&_ZN5S58C54v106Ev,
  (VTBL_ENTRY)&_ZN5S58C54v107Ev,
  (VTBL_ENTRY)&_ZN5S58C54v108Ev,
  (VTBL_ENTRY)&_ZN5S58C44v109Ev,
  (VTBL_ENTRY)&_ZN5S58C44v110Ev,
  (VTBL_ENTRY)&_ZN5S58C44v111Ev,
  (VTBL_ENTRY)&_ZN5S58C44v112Ev,
  (VTBL_ENTRY)&_ZN5S58C44v113Ev,
  (VTBL_ENTRY)&_ZN5S58C44v114Ev,
  (VTBL_ENTRY)&_ZN5S58C44v115Ev,
  (VTBL_ENTRY)&_ZN5S58C44v116Ev,
  (VTBL_ENTRY)&_ZN5S58C44v117Ev,
  (VTBL_ENTRY)&_ZN5S58C44v118Ev,
  (VTBL_ENTRY)&_ZN5S58C44v119Ev,
  (VTBL_ENTRY)&_ZN5S58C44v120Ev,
  (VTBL_ENTRY)&_ZN5S58C44v121Ev,
  (VTBL_ENTRY)&_ZN5S58C44v122Ev,
  (VTBL_ENTRY)&_ZN5S58C34v123Ev,
  (VTBL_ENTRY)&_ZN5S58C34v124Ev,
  (VTBL_ENTRY)&_ZN5S58C34v125Ev,
  (VTBL_ENTRY)&_ZN5S58C34v126Ev,
  (VTBL_ENTRY)&_ZN5S58C34v127Ev,
  (VTBL_ENTRY)&_ZN5S58C34v128Ev,
  (VTBL_ENTRY)&_ZN5S58C34v129Ev,
  (VTBL_ENTRY)&_ZN5S58C34v130Ev,
  (VTBL_ENTRY)&_ZN5S58C34v131Ev,
  (VTBL_ENTRY)&_ZN5S58C34v132Ev,
  (VTBL_ENTRY)&_ZN5S58C34v133Ev,
};
extern VTBL_ENTRY _ZTI5S58C3[];
extern  VTBL_ENTRY _ZTV5S58C3[];
Class_Descriptor cd_S58C3 = {  "S58C3", // class name
  bases_S58C3, 4,
  &(vtc_S58C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(392,280), // object size
  NSPAIRA(_ZTI5S58C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S58C3),135, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S58C2  : S58C3 {
  virtual  ~S58C2(); // _ZN5S58C2D1Ev
  virtual void  v134(); // _ZN5S58C24v134Ev
  virtual void  v135(); // _ZN5S58C24v135Ev
  S58C2(); // tgen
};
//SIG(-1 S58C2) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi[2] Fp Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 FC12{ m} FC8 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 Fi:1 Fi:1 Fi:1 FC13{ BC14{ BC11}} FC15{ BC16{ BC11}} FC17{ BC18{ BC11}} FC19{ BC20{ BC11}} Fi[3]} vd v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 Fp[2] Fi[4] Fi:1 Fi:1 Fi:1 Fc Fi Fi:1 FC21{ BC22{ BC11}}} vd v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 Fp[2] FC8 Fi:1 Fi:1 FC23{ m Fp FC7}} vd v1 v2}


 S58C2 ::~S58C2(){ note_dtor("S58C2", this);}
void  S58C2 ::v134(){vfunc_called(this, "_ZN5S58C24v134Ev");}
void  S58C2 ::v135(){vfunc_called(this, "_ZN5S58C24v135Ev");}
S58C2 ::S58C2(){ note_ctor("S58C2", this);} // tgen

static void Test_S58C2()
{
  extern Class_Descriptor cd_S58C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(50,71)];
    init_test(&cd_S58C2, buf);
    S58C2 *dp, &lv = *(dp=new (buf) S58C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(392,280), "sizeof(S58C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S58C2)");
    check_base_class_offset(lv, (S58C7*)(S58C6*)(S58C5*)(S58C4*)(S58C3*), 0, "S58C2");
    check_base_class_offset(lv, (S58C6*)(S58C5*)(S58C4*)(S58C3*), 0, "S58C2");
    check_base_class_offset(lv, (S58C5*)(S58C4*)(S58C3*), 0, "S58C2");
    check_base_class_offset(lv, (S58C4*)(S58C3*), 0, "S58C2");
    check_base_class_offset(lv, (S58C3*), 0, "S58C2");
    test_class_info(&lv, &cd_S58C2);
    dp->~S58C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS58C2(Test_S58C2, "S58C2", ABISELECT(392,280));

#else // __cplusplus

extern void _ZN5S58C2C1Ev();
extern void _ZN5S58C2D1Ev();
Name_Map name_map_S58C2[] = {
  NSPAIR(_ZN5S58C2C1Ev),
  NSPAIR(_ZN5S58C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S58C7;
extern VTBL_ENTRY _ZTI5S58C7[];
extern  VTBL_ENTRY _ZTV5S58C7[];
extern Class_Descriptor cd_S58C6;
extern VTBL_ENTRY _ZTI5S58C6[];
extern  VTBL_ENTRY _ZTV5S58C6[];
extern Class_Descriptor cd_S58C5;
extern VTBL_ENTRY _ZTI5S58C5[];
extern  VTBL_ENTRY _ZTV5S58C5[];
extern Class_Descriptor cd_S58C4;
extern VTBL_ENTRY _ZTI5S58C4[];
extern  VTBL_ENTRY _ZTV5S58C4[];
extern Class_Descriptor cd_S58C3;
extern VTBL_ENTRY _ZTI5S58C3[];
extern  VTBL_ENTRY _ZTV5S58C3[];
static Base_Class bases_S58C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S58C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S58C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S58C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S58C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S58C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S58C2[];
extern void _ZN5S58C2D1Ev();
extern void _ZN5S58C2D0Ev();
extern void _ZN5S58C72v3Ev();
extern void _ZN5S58C72v4Ev();
extern void _ZN5S58C72v5Ev();
extern void _ZN5S58C72v6Ev();
extern void _ZN5S58C72v7Ev();
extern void _ZN5S58C72v8Ev();
extern void _ZN5S58C72v9Ev();
extern void _ZN5S58C73v10Ev();
extern void _ZN5S58C73v11Ev();
extern void _ZN5S58C73v12Ev();
extern void _ZN5S58C73v13Ev();
extern void _ZN5S58C73v14Ev();
extern void _ZN5S58C73v15Ev();
extern void _ZN5S58C73v16Ev();
extern void _ZN5S58C73v17Ev();
extern void _ZN5S58C73v18Ev();
extern void _ZN5S58C73v19Ev();
extern void _ZN5S58C73v20Ev();
extern void _ZN5S58C73v21Ev();
extern void _ZN5S58C73v22Ev();
extern void _ZN5S58C73v23Ev();
extern void _ZN5S58C73v24Ev();
extern void _ZN5S58C73v25Ev();
extern void _ZN5S58C73v26Ev();
extern void _ZN5S58C73v27Ev();
extern void _ZN5S58C73v28Ev();
extern void _ZN5S58C73v29Ev();
extern void _ZN5S58C73v30Ev();
extern void _ZN5S58C73v31Ev();
extern void _ZN5S58C73v32Ev();
extern void _ZN5S58C73v33Ev();
extern void _ZN5S58C73v34Ev();
extern void _ZN5S58C73v35Ev();
extern void _ZN5S58C73v36Ev();
extern void _ZN5S58C73v37Ev();
extern void _ZN5S58C73v38Ev();
extern void _ZN5S58C73v39Ev();
extern void _ZN5S58C73v40Ev();
extern void _ZN5S58C73v41Ev();
extern void _ZN5S58C73v42Ev();
extern void _ZN5S58C73v43Ev();
extern void _ZN5S58C73v44Ev();
extern void _ZN5S58C73v45Ev();
extern void _ZN5S58C73v46Ev();
extern void _ZN5S58C73v47Ev();
extern void _ZN5S58C73v48Ev();
extern void _ZN5S58C73v49Ev();
extern void _ZN5S58C73v50Ev();
extern void _ZN5S58C73v51Ev();
extern void _ZN5S58C73v52Ev();
extern void _ZN5S58C73v53Ev();
extern void _ZN5S58C73v54Ev();
extern void _ZN5S58C73v55Ev();
extern void _ZN5S58C73v56Ev();
extern void _ZN5S58C73v57Ev();
extern void _ZN5S58C73v58Ev();
extern void _ZN5S58C73v59Ev();
extern void _ZN5S58C73v60Ev();
extern void _ZN5S58C73v61Ev();
extern void _ZN5S58C73v62Ev();
extern void _ZN5S58C73v63Ev();
extern void _ZN5S58C73v64Ev();
extern void _ZN5S58C73v65Ev();
extern void _ZN5S58C73v66Ev();
extern void _ZN5S58C63v67Ev();
extern void _ZN5S58C63v68Ev();
extern void _ZN5S58C63v69Ev();
extern void _ZN5S58C63v70Ev();
extern void _ZN5S58C63v71Ev();
extern void _ZN5S58C63v72Ev();
extern void _ZN5S58C63v73Ev();
extern void _ZN5S58C63v74Ev();
extern void _ZN5S58C63v75Ev();
extern void _ZN5S58C63v76Ev();
extern void _ZN5S58C63v77Ev();
extern void _ZN5S58C63v78Ev();
extern void _ZN5S58C63v79Ev();
extern void _ZN5S58C63v80Ev();
extern void _ZN5S58C63v81Ev();
extern void _ZN5S58C63v82Ev();
extern void _ZN5S58C63v83Ev();
extern void _ZN5S58C63v84Ev();
extern void _ZN5S58C63v85Ev();
extern void _ZN5S58C63v86Ev();
extern void _ZN5S58C63v87Ev();
extern void _ZN5S58C63v88Ev();
extern void _ZN5S58C53v89Ev();
extern void _ZN5S58C53v90Ev();
extern void _ZN5S58C53v91Ev();
extern void _ZN5S58C53v92Ev();
extern void _ZN5S58C53v93Ev();
extern void _ZN5S58C53v94Ev();
extern void _ZN5S58C53v95Ev();
extern void _ZN5S58C53v96Ev();
extern void _ZN5S58C53v97Ev();
extern void _ZN5S58C53v98Ev();
extern void _ZN5S58C53v99Ev();
extern void _ZN5S58C54v100Ev();
extern void _ZN5S58C54v101Ev();
extern void _ZN5S58C54v102Ev();
extern void _ZN5S58C54v103Ev();
extern void _ZN5S58C54v104Ev();
extern void _ZN5S58C54v105Ev();
extern void _ZN5S58C54v106Ev();
extern void _ZN5S58C54v107Ev();
extern void _ZN5S58C54v108Ev();
extern void _ZN5S58C44v109Ev();
extern void _ZN5S58C44v110Ev();
extern void _ZN5S58C44v111Ev();
extern void _ZN5S58C44v112Ev();
extern void _ZN5S58C44v113Ev();
extern void _ZN5S58C44v114Ev();
extern void _ZN5S58C44v115Ev();
extern void _ZN5S58C44v116Ev();
extern void _ZN5S58C44v117Ev();
extern void _ZN5S58C44v118Ev();
extern void _ZN5S58C44v119Ev();
extern void _ZN5S58C44v120Ev();
extern void _ZN5S58C44v121Ev();
extern void _ZN5S58C44v122Ev();
extern void _ZN5S58C34v123Ev();
extern void _ZN5S58C34v124Ev();
extern void _ZN5S58C34v125Ev();
extern void _ZN5S58C34v126Ev();
extern void _ZN5S58C34v127Ev();
extern void _ZN5S58C34v128Ev();
extern void _ZN5S58C34v129Ev();
extern void _ZN5S58C34v130Ev();
extern void _ZN5S58C34v131Ev();
extern void _ZN5S58C34v132Ev();
extern void _ZN5S58C34v133Ev();
extern void _ZN5S58C24v134Ev();
extern void _ZN5S58C24v135Ev();
static  VTBL_ENTRY vtc_S58C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S58C2[0]),
  (VTBL_ENTRY)&_ZN5S58C2D1Ev,
  (VTBL_ENTRY)&_ZN5S58C2D0Ev,
  (VTBL_ENTRY)&_ZN5S58C72v3Ev,
  (VTBL_ENTRY)&_ZN5S58C72v4Ev,
  (VTBL_ENTRY)&_ZN5S58C72v5Ev,
  (VTBL_ENTRY)&_ZN5S58C72v6Ev,
  (VTBL_ENTRY)&_ZN5S58C72v7Ev,
  (VTBL_ENTRY)&_ZN5S58C72v8Ev,
  (VTBL_ENTRY)&_ZN5S58C72v9Ev,
  (VTBL_ENTRY)&_ZN5S58C73v10Ev,
  (VTBL_ENTRY)&_ZN5S58C73v11Ev,
  (VTBL_ENTRY)&_ZN5S58C73v12Ev,
  (VTBL_ENTRY)&_ZN5S58C73v13Ev,
  (VTBL_ENTRY)&_ZN5S58C73v14Ev,
  (VTBL_ENTRY)&_ZN5S58C73v15Ev,
  (VTBL_ENTRY)&_ZN5S58C73v16Ev,
  (VTBL_ENTRY)&_ZN5S58C73v17Ev,
  (VTBL_ENTRY)&_ZN5S58C73v18Ev,
  (VTBL_ENTRY)&_ZN5S58C73v19Ev,
  (VTBL_ENTRY)&_ZN5S58C73v20Ev,
  (VTBL_ENTRY)&_ZN5S58C73v21Ev,
  (VTBL_ENTRY)&_ZN5S58C73v22Ev,
  (VTBL_ENTRY)&_ZN5S58C73v23Ev,
  (VTBL_ENTRY)&_ZN5S58C73v24Ev,
  (VTBL_ENTRY)&_ZN5S58C73v25Ev,
  (VTBL_ENTRY)&_ZN5S58C73v26Ev,
  (VTBL_ENTRY)&_ZN5S58C73v27Ev,
  (VTBL_ENTRY)&_ZN5S58C73v28Ev,
  (VTBL_ENTRY)&_ZN5S58C73v29Ev,
  (VTBL_ENTRY)&_ZN5S58C73v30Ev,
  (VTBL_ENTRY)&_ZN5S58C73v31Ev,
  (VTBL_ENTRY)&_ZN5S58C73v32Ev,
  (VTBL_ENTRY)&_ZN5S58C73v33Ev,
  (VTBL_ENTRY)&_ZN5S58C73v34Ev,
  (VTBL_ENTRY)&_ZN5S58C73v35Ev,
  (VTBL_ENTRY)&_ZN5S58C73v36Ev,
  (VTBL_ENTRY)&_ZN5S58C73v37Ev,
  (VTBL_ENTRY)&_ZN5S58C73v38Ev,
  (VTBL_ENTRY)&_ZN5S58C73v39Ev,
  (VTBL_ENTRY)&_ZN5S58C73v40Ev,
  (VTBL_ENTRY)&_ZN5S58C73v41Ev,
  (VTBL_ENTRY)&_ZN5S58C73v42Ev,
  (VTBL_ENTRY)&_ZN5S58C73v43Ev,
  (VTBL_ENTRY)&_ZN5S58C73v44Ev,
  (VTBL_ENTRY)&_ZN5S58C73v45Ev,
  (VTBL_ENTRY)&_ZN5S58C73v46Ev,
  (VTBL_ENTRY)&_ZN5S58C73v47Ev,
  (VTBL_ENTRY)&_ZN5S58C73v48Ev,
  (VTBL_ENTRY)&_ZN5S58C73v49Ev,
  (VTBL_ENTRY)&_ZN5S58C73v50Ev,
  (VTBL_ENTRY)&_ZN5S58C73v51Ev,
  (VTBL_ENTRY)&_ZN5S58C73v52Ev,
  (VTBL_ENTRY)&_ZN5S58C73v53Ev,
  (VTBL_ENTRY)&_ZN5S58C73v54Ev,
  (VTBL_ENTRY)&_ZN5S58C73v55Ev,
  (VTBL_ENTRY)&_ZN5S58C73v56Ev,
  (VTBL_ENTRY)&_ZN5S58C73v57Ev,
  (VTBL_ENTRY)&_ZN5S58C73v58Ev,
  (VTBL_ENTRY)&_ZN5S58C73v59Ev,
  (VTBL_ENTRY)&_ZN5S58C73v60Ev,
  (VTBL_ENTRY)&_ZN5S58C73v61Ev,
  (VTBL_ENTRY)&_ZN5S58C73v62Ev,
  (VTBL_ENTRY)&_ZN5S58C73v63Ev,
  (VTBL_ENTRY)&_ZN5S58C73v64Ev,
  (VTBL_ENTRY)&_ZN5S58C73v65Ev,
  (VTBL_ENTRY)&_ZN5S58C73v66Ev,
  (VTBL_ENTRY)&_ZN5S58C63v67Ev,
  (VTBL_ENTRY)&_ZN5S58C63v68Ev,
  (VTBL_ENTRY)&_ZN5S58C63v69Ev,
  (VTBL_ENTRY)&_ZN5S58C63v70Ev,
  (VTBL_ENTRY)&_ZN5S58C63v71Ev,
  (VTBL_ENTRY)&_ZN5S58C63v72Ev,
  (VTBL_ENTRY)&_ZN5S58C63v73Ev,
  (VTBL_ENTRY)&_ZN5S58C63v74Ev,
  (VTBL_ENTRY)&_ZN5S58C63v75Ev,
  (VTBL_ENTRY)&_ZN5S58C63v76Ev,
  (VTBL_ENTRY)&_ZN5S58C63v77Ev,
  (VTBL_ENTRY)&_ZN5S58C63v78Ev,
  (VTBL_ENTRY)&_ZN5S58C63v79Ev,
  (VTBL_ENTRY)&_ZN5S58C63v80Ev,
  (VTBL_ENTRY)&_ZN5S58C63v81Ev,
  (VTBL_ENTRY)&_ZN5S58C63v82Ev,
  (VTBL_ENTRY)&_ZN5S58C63v83Ev,
  (VTBL_ENTRY)&_ZN5S58C63v84Ev,
  (VTBL_ENTRY)&_ZN5S58C63v85Ev,
  (VTBL_ENTRY)&_ZN5S58C63v86Ev,
  (VTBL_ENTRY)&_ZN5S58C63v87Ev,
  (VTBL_ENTRY)&_ZN5S58C63v88Ev,
  (VTBL_ENTRY)&_ZN5S58C53v89Ev,
  (VTBL_ENTRY)&_ZN5S58C53v90Ev,
  (VTBL_ENTRY)&_ZN5S58C53v91Ev,
  (VTBL_ENTRY)&_ZN5S58C53v92Ev,
  (VTBL_ENTRY)&_ZN5S58C53v93Ev,
  (VTBL_ENTRY)&_ZN5S58C53v94Ev,
  (VTBL_ENTRY)&_ZN5S58C53v95Ev,
  (VTBL_ENTRY)&_ZN5S58C53v96Ev,
  (VTBL_ENTRY)&_ZN5S58C53v97Ev,
  (VTBL_ENTRY)&_ZN5S58C53v98Ev,
  (VTBL_ENTRY)&_ZN5S58C53v99Ev,
  (VTBL_ENTRY)&_ZN5S58C54v100Ev,
  (VTBL_ENTRY)&_ZN5S58C54v101Ev,
  (VTBL_ENTRY)&_ZN5S58C54v102Ev,
  (VTBL_ENTRY)&_ZN5S58C54v103Ev,
  (VTBL_ENTRY)&_ZN5S58C54v104Ev,
  (VTBL_ENTRY)&_ZN5S58C54v105Ev,
  (VTBL_ENTRY)&_ZN5S58C54v106Ev,
  (VTBL_ENTRY)&_ZN5S58C54v107Ev,
  (VTBL_ENTRY)&_ZN5S58C54v108Ev,
  (VTBL_ENTRY)&_ZN5S58C44v109Ev,
  (VTBL_ENTRY)&_ZN5S58C44v110Ev,
  (VTBL_ENTRY)&_ZN5S58C44v111Ev,
  (VTBL_ENTRY)&_ZN5S58C44v112Ev,
  (VTBL_ENTRY)&_ZN5S58C44v113Ev,
  (VTBL_ENTRY)&_ZN5S58C44v114Ev,
  (VTBL_ENTRY)&_ZN5S58C44v115Ev,
  (VTBL_ENTRY)&_ZN5S58C44v116Ev,
  (VTBL_ENTRY)&_ZN5S58C44v117Ev,
  (VTBL_ENTRY)&_ZN5S58C44v118Ev,
  (VTBL_ENTRY)&_ZN5S58C44v119Ev,
  (VTBL_ENTRY)&_ZN5S58C44v120Ev,
  (VTBL_ENTRY)&_ZN5S58C44v121Ev,
  (VTBL_ENTRY)&_ZN5S58C44v122Ev,
  (VTBL_ENTRY)&_ZN5S58C34v123Ev,
  (VTBL_ENTRY)&_ZN5S58C34v124Ev,
  (VTBL_ENTRY)&_ZN5S58C34v125Ev,
  (VTBL_ENTRY)&_ZN5S58C34v126Ev,
  (VTBL_ENTRY)&_ZN5S58C34v127Ev,
  (VTBL_ENTRY)&_ZN5S58C34v128Ev,
  (VTBL_ENTRY)&_ZN5S58C34v129Ev,
  (VTBL_ENTRY)&_ZN5S58C34v130Ev,
  (VTBL_ENTRY)&_ZN5S58C34v131Ev,
  (VTBL_ENTRY)&_ZN5S58C34v132Ev,
  (VTBL_ENTRY)&_ZN5S58C34v133Ev,
  (VTBL_ENTRY)&_ZN5S58C24v134Ev,
  (VTBL_ENTRY)&_ZN5S58C24v135Ev,
};
extern VTBL_ENTRY _ZTI5S58C2[];
extern  VTBL_ENTRY _ZTV5S58C2[];
Class_Descriptor cd_S58C2 = {  "S58C2", // class name
  bases_S58C2, 5,
  &(vtc_S58C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(392,280), // object size
  NSPAIRA(_ZTI5S58C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S58C2),137, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S58C1  : S58C2 {
  int s58c1f0;
  virtual  ~S58C1(); // _ZN5S58C1D1Ev
  virtual void  v1(); // _ZN5S58C12v1Ev
  virtual void  v2(); // _ZN5S58C12v2Ev
  S58C1(); // tgen
};
//SIG(1 S58C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC8{ m Fi[2]} Fp[2]} vd v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi[2] Fp Fi[2] FC9{ BC10{ BC11{ BC12{ m Fp Fi[2]}}}} FC9 FC13{ m} FC9 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 Fi:1 Fi:1 Fi:1 FC14{ BC15{ BC12}} FC16{ BC17{ BC12}} FC18{ BC19{ BC12}} FC20{ BC21{ BC12}} Fi[3]} vd v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 Fp[2] Fi[4] Fi:1 Fi:1 Fi:1 Fc Fi Fi:1 FC22{ BC23{ BC12}}} vd v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 Fp[2] FC9 Fi:1 Fi:1 FC24{ m Fp FC8}} vd v134 v135} vd v1 v2 Fi}


 S58C1 ::~S58C1(){ note_dtor("S58C1", this);}
void  S58C1 ::v1(){vfunc_called(this, "_ZN5S58C12v1Ev");}
void  S58C1 ::v2(){vfunc_called(this, "_ZN5S58C12v2Ev");}
S58C1 ::S58C1(){ note_ctor("S58C1", this);} // tgen

static void Test_S58C1()
{
  extern Class_Descriptor cd_S58C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(51,72)];
    init_test(&cd_S58C1, buf);
    S58C1 *dp, &lv = *(dp=new (buf) S58C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(400,284), "sizeof(S58C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S58C1)");
    check_base_class_offset(lv, (S58C7*)(S58C6*)(S58C5*)(S58C4*)(S58C3*)(S58C2*), 0, "S58C1");
    check_base_class_offset(lv, (S58C6*)(S58C5*)(S58C4*)(S58C3*)(S58C2*), 0, "S58C1");
    check_base_class_offset(lv, (S58C5*)(S58C4*)(S58C3*)(S58C2*), 0, "S58C1");
    check_base_class_offset(lv, (S58C4*)(S58C3*)(S58C2*), 0, "S58C1");
    check_base_class_offset(lv, (S58C3*)(S58C2*), 0, "S58C1");
    check_base_class_offset(lv, (S58C2*), 0, "S58C1");
    check_field_offset(lv, s58c1f0, ABISELECT(392,280), "S58C1.s58c1f0");
    test_class_info(&lv, &cd_S58C1);
    dp->~S58C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS58C1(Test_S58C1, "S58C1", ABISELECT(400,284));

#else // __cplusplus

extern void _ZN5S58C1C1Ev();
extern void _ZN5S58C1D1Ev();
Name_Map name_map_S58C1[] = {
  NSPAIR(_ZN5S58C1C1Ev),
  NSPAIR(_ZN5S58C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S58C7;
extern VTBL_ENTRY _ZTI5S58C7[];
extern  VTBL_ENTRY _ZTV5S58C7[];
extern Class_Descriptor cd_S58C6;
extern VTBL_ENTRY _ZTI5S58C6[];
extern  VTBL_ENTRY _ZTV5S58C6[];
extern Class_Descriptor cd_S58C5;
extern VTBL_ENTRY _ZTI5S58C5[];
extern  VTBL_ENTRY _ZTV5S58C5[];
extern Class_Descriptor cd_S58C4;
extern VTBL_ENTRY _ZTI5S58C4[];
extern  VTBL_ENTRY _ZTV5S58C4[];
extern Class_Descriptor cd_S58C3;
extern VTBL_ENTRY _ZTI5S58C3[];
extern  VTBL_ENTRY _ZTV5S58C3[];
extern Class_Descriptor cd_S58C2;
extern VTBL_ENTRY _ZTI5S58C2[];
extern  VTBL_ENTRY _ZTV5S58C2[];
static Base_Class bases_S58C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S58C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S58C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S58C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S58C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S58C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S58C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S58C1[];
extern void _ZN5S58C1D1Ev();
extern void _ZN5S58C1D0Ev();
extern void _ZN5S58C72v3Ev();
extern void _ZN5S58C72v4Ev();
extern void _ZN5S58C72v5Ev();
extern void _ZN5S58C72v6Ev();
extern void _ZN5S58C72v7Ev();
extern void _ZN5S58C72v8Ev();
extern void _ZN5S58C72v9Ev();
extern void _ZN5S58C73v10Ev();
extern void _ZN5S58C73v11Ev();
extern void _ZN5S58C73v12Ev();
extern void _ZN5S58C73v13Ev();
extern void _ZN5S58C73v14Ev();
extern void _ZN5S58C73v15Ev();
extern void _ZN5S58C73v16Ev();
extern void _ZN5S58C73v17Ev();
extern void _ZN5S58C73v18Ev();
extern void _ZN5S58C73v19Ev();
extern void _ZN5S58C73v20Ev();
extern void _ZN5S58C73v21Ev();
extern void _ZN5S58C73v22Ev();
extern void _ZN5S58C73v23Ev();
extern void _ZN5S58C73v24Ev();
extern void _ZN5S58C73v25Ev();
extern void _ZN5S58C73v26Ev();
extern void _ZN5S58C73v27Ev();
extern void _ZN5S58C73v28Ev();
extern void _ZN5S58C73v29Ev();
extern void _ZN5S58C73v30Ev();
extern void _ZN5S58C73v31Ev();
extern void _ZN5S58C73v32Ev();
extern void _ZN5S58C73v33Ev();
extern void _ZN5S58C73v34Ev();
extern void _ZN5S58C73v35Ev();
extern void _ZN5S58C73v36Ev();
extern void _ZN5S58C73v37Ev();
extern void _ZN5S58C73v38Ev();
extern void _ZN5S58C73v39Ev();
extern void _ZN5S58C73v40Ev();
extern void _ZN5S58C73v41Ev();
extern void _ZN5S58C73v42Ev();
extern void _ZN5S58C73v43Ev();
extern void _ZN5S58C73v44Ev();
extern void _ZN5S58C73v45Ev();
extern void _ZN5S58C73v46Ev();
extern void _ZN5S58C73v47Ev();
extern void _ZN5S58C73v48Ev();
extern void _ZN5S58C73v49Ev();
extern void _ZN5S58C73v50Ev();
extern void _ZN5S58C73v51Ev();
extern void _ZN5S58C73v52Ev();
extern void _ZN5S58C73v53Ev();
extern void _ZN5S58C73v54Ev();
extern void _ZN5S58C73v55Ev();
extern void _ZN5S58C73v56Ev();
extern void _ZN5S58C73v57Ev();
extern void _ZN5S58C73v58Ev();
extern void _ZN5S58C73v59Ev();
extern void _ZN5S58C73v60Ev();
extern void _ZN5S58C73v61Ev();
extern void _ZN5S58C73v62Ev();
extern void _ZN5S58C73v63Ev();
extern void _ZN5S58C73v64Ev();
extern void _ZN5S58C73v65Ev();
extern void _ZN5S58C73v66Ev();
extern void _ZN5S58C63v67Ev();
extern void _ZN5S58C63v68Ev();
extern void _ZN5S58C63v69Ev();
extern void _ZN5S58C63v70Ev();
extern void _ZN5S58C63v71Ev();
extern void _ZN5S58C63v72Ev();
extern void _ZN5S58C63v73Ev();
extern void _ZN5S58C63v74Ev();
extern void _ZN5S58C63v75Ev();
extern void _ZN5S58C63v76Ev();
extern void _ZN5S58C63v77Ev();
extern void _ZN5S58C63v78Ev();
extern void _ZN5S58C63v79Ev();
extern void _ZN5S58C63v80Ev();
extern void _ZN5S58C63v81Ev();
extern void _ZN5S58C63v82Ev();
extern void _ZN5S58C63v83Ev();
extern void _ZN5S58C63v84Ev();
extern void _ZN5S58C63v85Ev();
extern void _ZN5S58C63v86Ev();
extern void _ZN5S58C63v87Ev();
extern void _ZN5S58C63v88Ev();
extern void _ZN5S58C53v89Ev();
extern void _ZN5S58C53v90Ev();
extern void _ZN5S58C53v91Ev();
extern void _ZN5S58C53v92Ev();
extern void _ZN5S58C53v93Ev();
extern void _ZN5S58C53v94Ev();
extern void _ZN5S58C53v95Ev();
extern void _ZN5S58C53v96Ev();
extern void _ZN5S58C53v97Ev();
extern void _ZN5S58C53v98Ev();
extern void _ZN5S58C53v99Ev();
extern void _ZN5S58C54v100Ev();
extern void _ZN5S58C54v101Ev();
extern void _ZN5S58C54v102Ev();
extern void _ZN5S58C54v103Ev();
extern void _ZN5S58C54v104Ev();
extern void _ZN5S58C54v105Ev();
extern void _ZN5S58C54v106Ev();
extern void _ZN5S58C54v107Ev();
extern void _ZN5S58C54v108Ev();
extern void _ZN5S58C44v109Ev();
extern void _ZN5S58C44v110Ev();
extern void _ZN5S58C44v111Ev();
extern void _ZN5S58C44v112Ev();
extern void _ZN5S58C44v113Ev();
extern void _ZN5S58C44v114Ev();
extern void _ZN5S58C44v115Ev();
extern void _ZN5S58C44v116Ev();
extern void _ZN5S58C44v117Ev();
extern void _ZN5S58C44v118Ev();
extern void _ZN5S58C44v119Ev();
extern void _ZN5S58C44v120Ev();
extern void _ZN5S58C44v121Ev();
extern void _ZN5S58C44v122Ev();
extern void _ZN5S58C34v123Ev();
extern void _ZN5S58C34v124Ev();
extern void _ZN5S58C34v125Ev();
extern void _ZN5S58C34v126Ev();
extern void _ZN5S58C34v127Ev();
extern void _ZN5S58C34v128Ev();
extern void _ZN5S58C34v129Ev();
extern void _ZN5S58C34v130Ev();
extern void _ZN5S58C34v131Ev();
extern void _ZN5S58C34v132Ev();
extern void _ZN5S58C34v133Ev();
extern void _ZN5S58C24v134Ev();
extern void _ZN5S58C24v135Ev();
extern void _ZN5S58C12v1Ev();
extern void _ZN5S58C12v2Ev();
static  VTBL_ENTRY vtc_S58C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S58C1[0]),
  (VTBL_ENTRY)&_ZN5S58C1D1Ev,
  (VTBL_ENTRY)&_ZN5S58C1D0Ev,
  (VTBL_ENTRY)&_ZN5S58C72v3Ev,
  (VTBL_ENTRY)&_ZN5S58C72v4Ev,
  (VTBL_ENTRY)&_ZN5S58C72v5Ev,
  (VTBL_ENTRY)&_ZN5S58C72v6Ev,
  (VTBL_ENTRY)&_ZN5S58C72v7Ev,
  (VTBL_ENTRY)&_ZN5S58C72v8Ev,
  (VTBL_ENTRY)&_ZN5S58C72v9Ev,
  (VTBL_ENTRY)&_ZN5S58C73v10Ev,
  (VTBL_ENTRY)&_ZN5S58C73v11Ev,
  (VTBL_ENTRY)&_ZN5S58C73v12Ev,
  (VTBL_ENTRY)&_ZN5S58C73v13Ev,
  (VTBL_ENTRY)&_ZN5S58C73v14Ev,
  (VTBL_ENTRY)&_ZN5S58C73v15Ev,
  (VTBL_ENTRY)&_ZN5S58C73v16Ev,
  (VTBL_ENTRY)&_ZN5S58C73v17Ev,
  (VTBL_ENTRY)&_ZN5S58C73v18Ev,
  (VTBL_ENTRY)&_ZN5S58C73v19Ev,
  (VTBL_ENTRY)&_ZN5S58C73v20Ev,
  (VTBL_ENTRY)&_ZN5S58C73v21Ev,
  (VTBL_ENTRY)&_ZN5S58C73v22Ev,
  (VTBL_ENTRY)&_ZN5S58C73v23Ev,
  (VTBL_ENTRY)&_ZN5S58C73v24Ev,
  (VTBL_ENTRY)&_ZN5S58C73v25Ev,
  (VTBL_ENTRY)&_ZN5S58C73v26Ev,
  (VTBL_ENTRY)&_ZN5S58C73v27Ev,
  (VTBL_ENTRY)&_ZN5S58C73v28Ev,
  (VTBL_ENTRY)&_ZN5S58C73v29Ev,
  (VTBL_ENTRY)&_ZN5S58C73v30Ev,
  (VTBL_ENTRY)&_ZN5S58C73v31Ev,
  (VTBL_ENTRY)&_ZN5S58C73v32Ev,
  (VTBL_ENTRY)&_ZN5S58C73v33Ev,
  (VTBL_ENTRY)&_ZN5S58C73v34Ev,
  (VTBL_ENTRY)&_ZN5S58C73v35Ev,
  (VTBL_ENTRY)&_ZN5S58C73v36Ev,
  (VTBL_ENTRY)&_ZN5S58C73v37Ev,
  (VTBL_ENTRY)&_ZN5S58C73v38Ev,
  (VTBL_ENTRY)&_ZN5S58C73v39Ev,
  (VTBL_ENTRY)&_ZN5S58C73v40Ev,
  (VTBL_ENTRY)&_ZN5S58C73v41Ev,
  (VTBL_ENTRY)&_ZN5S58C73v42Ev,
  (VTBL_ENTRY)&_ZN5S58C73v43Ev,
  (VTBL_ENTRY)&_ZN5S58C73v44Ev,
  (VTBL_ENTRY)&_ZN5S58C73v45Ev,
  (VTBL_ENTRY)&_ZN5S58C73v46Ev,
  (VTBL_ENTRY)&_ZN5S58C73v47Ev,
  (VTBL_ENTRY)&_ZN5S58C73v48Ev,
  (VTBL_ENTRY)&_ZN5S58C73v49Ev,
  (VTBL_ENTRY)&_ZN5S58C73v50Ev,
  (VTBL_ENTRY)&_ZN5S58C73v51Ev,
  (VTBL_ENTRY)&_ZN5S58C73v52Ev,
  (VTBL_ENTRY)&_ZN5S58C73v53Ev,
  (VTBL_ENTRY)&_ZN5S58C73v54Ev,
  (VTBL_ENTRY)&_ZN5S58C73v55Ev,
  (VTBL_ENTRY)&_ZN5S58C73v56Ev,
  (VTBL_ENTRY)&_ZN5S58C73v57Ev,
  (VTBL_ENTRY)&_ZN5S58C73v58Ev,
  (VTBL_ENTRY)&_ZN5S58C73v59Ev,
  (VTBL_ENTRY)&_ZN5S58C73v60Ev,
  (VTBL_ENTRY)&_ZN5S58C73v61Ev,
  (VTBL_ENTRY)&_ZN5S58C73v62Ev,
  (VTBL_ENTRY)&_ZN5S58C73v63Ev,
  (VTBL_ENTRY)&_ZN5S58C73v64Ev,
  (VTBL_ENTRY)&_ZN5S58C73v65Ev,
  (VTBL_ENTRY)&_ZN5S58C73v66Ev,
  (VTBL_ENTRY)&_ZN5S58C63v67Ev,
  (VTBL_ENTRY)&_ZN5S58C63v68Ev,
  (VTBL_ENTRY)&_ZN5S58C63v69Ev,
  (VTBL_ENTRY)&_ZN5S58C63v70Ev,
  (VTBL_ENTRY)&_ZN5S58C63v71Ev,
  (VTBL_ENTRY)&_ZN5S58C63v72Ev,
  (VTBL_ENTRY)&_ZN5S58C63v73Ev,
  (VTBL_ENTRY)&_ZN5S58C63v74Ev,
  (VTBL_ENTRY)&_ZN5S58C63v75Ev,
  (VTBL_ENTRY)&_ZN5S58C63v76Ev,
  (VTBL_ENTRY)&_ZN5S58C63v77Ev,
  (VTBL_ENTRY)&_ZN5S58C63v78Ev,
  (VTBL_ENTRY)&_ZN5S58C63v79Ev,
  (VTBL_ENTRY)&_ZN5S58C63v80Ev,
  (VTBL_ENTRY)&_ZN5S58C63v81Ev,
  (VTBL_ENTRY)&_ZN5S58C63v82Ev,
  (VTBL_ENTRY)&_ZN5S58C63v83Ev,
  (VTBL_ENTRY)&_ZN5S58C63v84Ev,
  (VTBL_ENTRY)&_ZN5S58C63v85Ev,
  (VTBL_ENTRY)&_ZN5S58C63v86Ev,
  (VTBL_ENTRY)&_ZN5S58C63v87Ev,
  (VTBL_ENTRY)&_ZN5S58C63v88Ev,
  (VTBL_ENTRY)&_ZN5S58C53v89Ev,
  (VTBL_ENTRY)&_ZN5S58C53v90Ev,
  (VTBL_ENTRY)&_ZN5S58C53v91Ev,
  (VTBL_ENTRY)&_ZN5S58C53v92Ev,
  (VTBL_ENTRY)&_ZN5S58C53v93Ev,
  (VTBL_ENTRY)&_ZN5S58C53v94Ev,
  (VTBL_ENTRY)&_ZN5S58C53v95Ev,
  (VTBL_ENTRY)&_ZN5S58C53v96Ev,
  (VTBL_ENTRY)&_ZN5S58C53v97Ev,
  (VTBL_ENTRY)&_ZN5S58C53v98Ev,
  (VTBL_ENTRY)&_ZN5S58C53v99Ev,
  (VTBL_ENTRY)&_ZN5S58C54v100Ev,
  (VTBL_ENTRY)&_ZN5S58C54v101Ev,
  (VTBL_ENTRY)&_ZN5S58C54v102Ev,
  (VTBL_ENTRY)&_ZN5S58C54v103Ev,
  (VTBL_ENTRY)&_ZN5S58C54v104Ev,
  (VTBL_ENTRY)&_ZN5S58C54v105Ev,
  (VTBL_ENTRY)&_ZN5S58C54v106Ev,
  (VTBL_ENTRY)&_ZN5S58C54v107Ev,
  (VTBL_ENTRY)&_ZN5S58C54v108Ev,
  (VTBL_ENTRY)&_ZN5S58C44v109Ev,
  (VTBL_ENTRY)&_ZN5S58C44v110Ev,
  (VTBL_ENTRY)&_ZN5S58C44v111Ev,
  (VTBL_ENTRY)&_ZN5S58C44v112Ev,
  (VTBL_ENTRY)&_ZN5S58C44v113Ev,
  (VTBL_ENTRY)&_ZN5S58C44v114Ev,
  (VTBL_ENTRY)&_ZN5S58C44v115Ev,
  (VTBL_ENTRY)&_ZN5S58C44v116Ev,
  (VTBL_ENTRY)&_ZN5S58C44v117Ev,
  (VTBL_ENTRY)&_ZN5S58C44v118Ev,
  (VTBL_ENTRY)&_ZN5S58C44v119Ev,
  (VTBL_ENTRY)&_ZN5S58C44v120Ev,
  (VTBL_ENTRY)&_ZN5S58C44v121Ev,
  (VTBL_ENTRY)&_ZN5S58C44v122Ev,
  (VTBL_ENTRY)&_ZN5S58C34v123Ev,
  (VTBL_ENTRY)&_ZN5S58C34v124Ev,
  (VTBL_ENTRY)&_ZN5S58C34v125Ev,
  (VTBL_ENTRY)&_ZN5S58C34v126Ev,
  (VTBL_ENTRY)&_ZN5S58C34v127Ev,
  (VTBL_ENTRY)&_ZN5S58C34v128Ev,
  (VTBL_ENTRY)&_ZN5S58C34v129Ev,
  (VTBL_ENTRY)&_ZN5S58C34v130Ev,
  (VTBL_ENTRY)&_ZN5S58C34v131Ev,
  (VTBL_ENTRY)&_ZN5S58C34v132Ev,
  (VTBL_ENTRY)&_ZN5S58C34v133Ev,
  (VTBL_ENTRY)&_ZN5S58C24v134Ev,
  (VTBL_ENTRY)&_ZN5S58C24v135Ev,
  (VTBL_ENTRY)&_ZN5S58C12v1Ev,
  (VTBL_ENTRY)&_ZN5S58C12v2Ev,
};
extern VTBL_ENTRY _ZTI5S58C1[];
extern  VTBL_ENTRY _ZTV5S58C1[];
Class_Descriptor cd_S58C1 = {  "S58C1", // class name
  bases_S58C1, 6,
  &(vtc_S58C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(400,284), // object size
  NSPAIRA(_ZTI5S58C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S58C1),139, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S59C7  {
  int s59c7f0;
  __tsi64 s59c7f1;
  void *s59c7f2[4];
  int s59c7f3[2];
  void *s59c7f4;
  ::S3350C4_nt s59c7f5;
  void *s59c7f6[2];
  virtual  ~S59C7(); // _ZN5S59C7D1Ev
  virtual void  v3(); // _ZN5S59C72v3Ev
  virtual void  v4(); // _ZN5S59C72v4Ev
  virtual void  v5(); // _ZN5S59C72v5Ev
  virtual void  v6(); // _ZN5S59C72v6Ev
  virtual void  v7(); // _ZN5S59C72v7Ev
  virtual void  v8(); // _ZN5S59C72v8Ev
  virtual void  v9(); // _ZN5S59C72v9Ev
  virtual void  v10(); // _ZN5S59C73v10Ev
  virtual void  v11(); // _ZN5S59C73v11Ev
  virtual void  v12(); // _ZN5S59C73v12Ev
  virtual void  v13(); // _ZN5S59C73v13Ev
  virtual void  v14(); // _ZN5S59C73v14Ev
  virtual void  v15(); // _ZN5S59C73v15Ev
  virtual void  v16(); // _ZN5S59C73v16Ev
  virtual void  v17(); // _ZN5S59C73v17Ev
  virtual void  v18(); // _ZN5S59C73v18Ev
  virtual void  v19(); // _ZN5S59C73v19Ev
  virtual void  v20(); // _ZN5S59C73v20Ev
  virtual void  v21(); // _ZN5S59C73v21Ev
  virtual void  v22(); // _ZN5S59C73v22Ev
  virtual void  v23(); // _ZN5S59C73v23Ev
  virtual void  v24(); // _ZN5S59C73v24Ev
  virtual void  v25(); // _ZN5S59C73v25Ev
  virtual void  v26(); // _ZN5S59C73v26Ev
  virtual void  v27(); // _ZN5S59C73v27Ev
  virtual void  v28(); // _ZN5S59C73v28Ev
  virtual void  v29(); // _ZN5S59C73v29Ev
  virtual void  v30(); // _ZN5S59C73v30Ev
  virtual void  v31(); // _ZN5S59C73v31Ev
  virtual void  v32(); // _ZN5S59C73v32Ev
  virtual void  v33(); // _ZN5S59C73v33Ev
  virtual void  v34(); // _ZN5S59C73v34Ev
  virtual void  v35(); // _ZN5S59C73v35Ev
  virtual void  v36(); // _ZN5S59C73v36Ev
  virtual void  v37(); // _ZN5S59C73v37Ev
  virtual void  v38(); // _ZN5S59C73v38Ev
  virtual void  v39(); // _ZN5S59C73v39Ev
  virtual void  v40(); // _ZN5S59C73v40Ev
  virtual void  v41(); // _ZN5S59C73v41Ev
  virtual void  v42(); // _ZN5S59C73v42Ev
  virtual void  v43(); // _ZN5S59C73v43Ev
  virtual void  v44(); // _ZN5S59C73v44Ev
  virtual void  v45(); // _ZN5S59C73v45Ev
  virtual void  v46(); // _ZN5S59C73v46Ev
  virtual void  v47(); // _ZN5S59C73v47Ev
  virtual void  v48(); // _ZN5S59C73v48Ev
  virtual void  v49(); // _ZN5S59C73v49Ev
  virtual void  v50(); // _ZN5S59C73v50Ev
  virtual void  v51(); // _ZN5S59C73v51Ev
  virtual void  v52(); // _ZN5S59C73v52Ev
  virtual void  v53(); // _ZN5S59C73v53Ev
  virtual void  v54(); // _ZN5S59C73v54Ev
  virtual void  v55(); // _ZN5S59C73v55Ev
  virtual void  v56(); // _ZN5S59C73v56Ev
  virtual void  v57(); // _ZN5S59C73v57Ev
  virtual void  v58(); // _ZN5S59C73v58Ev
  virtual void  v59(); // _ZN5S59C73v59Ev
  virtual void  v60(); // _ZN5S59C73v60Ev
  virtual void  v61(); // _ZN5S59C73v61Ev
  virtual void  v62(); // _ZN5S59C73v62Ev
  virtual void  v63(); // _ZN5S59C73v63Ev
  virtual void  v64(); // _ZN5S59C73v64Ev
  virtual void  v65(); // _ZN5S59C73v65Ev
  virtual void  v66(); // _ZN5S59C73v66Ev
  S59C7(); // tgen
};
//SIG(-1 S59C7) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S59C7 ::~S59C7(){ note_dtor("S59C7", this);}
void  S59C7 ::v3(){vfunc_called(this, "_ZN5S59C72v3Ev");}
void  S59C7 ::v4(){vfunc_called(this, "_ZN5S59C72v4Ev");}
void  S59C7 ::v5(){vfunc_called(this, "_ZN5S59C72v5Ev");}
void  S59C7 ::v6(){vfunc_called(this, "_ZN5S59C72v6Ev");}
void  S59C7 ::v7(){vfunc_called(this, "_ZN5S59C72v7Ev");}
void  S59C7 ::v8(){vfunc_called(this, "_ZN5S59C72v8Ev");}
void  S59C7 ::v9(){vfunc_called(this, "_ZN5S59C72v9Ev");}
void  S59C7 ::v10(){vfunc_called(this, "_ZN5S59C73v10Ev");}
void  S59C7 ::v11(){vfunc_called(this, "_ZN5S59C73v11Ev");}
void  S59C7 ::v12(){vfunc_called(this, "_ZN5S59C73v12Ev");}
void  S59C7 ::v13(){vfunc_called(this, "_ZN5S59C73v13Ev");}
void  S59C7 ::v14(){vfunc_called(this, "_ZN5S59C73v14Ev");}
void  S59C7 ::v15(){vfunc_called(this, "_ZN5S59C73v15Ev");}
void  S59C7 ::v16(){vfunc_called(this, "_ZN5S59C73v16Ev");}
void  S59C7 ::v17(){vfunc_called(this, "_ZN5S59C73v17Ev");}
void  S59C7 ::v18(){vfunc_called(this, "_ZN5S59C73v18Ev");}
void  S59C7 ::v19(){vfunc_called(this, "_ZN5S59C73v19Ev");}
void  S59C7 ::v20(){vfunc_called(this, "_ZN5S59C73v20Ev");}
void  S59C7 ::v21(){vfunc_called(this, "_ZN5S59C73v21Ev");}
void  S59C7 ::v22(){vfunc_called(this, "_ZN5S59C73v22Ev");}
void  S59C7 ::v23(){vfunc_called(this, "_ZN5S59C73v23Ev");}
void  S59C7 ::v24(){vfunc_called(this, "_ZN5S59C73v24Ev");}
void  S59C7 ::v25(){vfunc_called(this, "_ZN5S59C73v25Ev");}
void  S59C7 ::v26(){vfunc_called(this, "_ZN5S59C73v26Ev");}
void  S59C7 ::v27(){vfunc_called(this, "_ZN5S59C73v27Ev");}
void  S59C7 ::v28(){vfunc_called(this, "_ZN5S59C73v28Ev");}
void  S59C7 ::v29(){vfunc_called(this, "_ZN5S59C73v29Ev");}
void  S59C7 ::v30(){vfunc_called(this, "_ZN5S59C73v30Ev");}
void  S59C7 ::v31(){vfunc_called(this, "_ZN5S59C73v31Ev");}
void  S59C7 ::v32(){vfunc_called(this, "_ZN5S59C73v32Ev");}
void  S59C7 ::v33(){vfunc_called(this, "_ZN5S59C73v33Ev");}
void  S59C7 ::v34(){vfunc_called(this, "_ZN5S59C73v34Ev");}
void  S59C7 ::v35(){vfunc_called(this, "_ZN5S59C73v35Ev");}
void  S59C7 ::v36(){vfunc_called(this, "_ZN5S59C73v36Ev");}
void  S59C7 ::v37(){vfunc_called(this, "_ZN5S59C73v37Ev");}
void  S59C7 ::v38(){vfunc_called(this, "_ZN5S59C73v38Ev");}
void  S59C7 ::v39(){vfunc_called(this, "_ZN5S59C73v39Ev");}
void  S59C7 ::v40(){vfunc_called(this, "_ZN5S59C73v40Ev");}
void  S59C7 ::v41(){vfunc_called(this, "_ZN5S59C73v41Ev");}
void  S59C7 ::v42(){vfunc_called(this, "_ZN5S59C73v42Ev");}
void  S59C7 ::v43(){vfunc_called(this, "_ZN5S59C73v43Ev");}
void  S59C7 ::v44(){vfunc_called(this, "_ZN5S59C73v44Ev");}
void  S59C7 ::v45(){vfunc_called(this, "_ZN5S59C73v45Ev");}
void  S59C7 ::v46(){vfunc_called(this, "_ZN5S59C73v46Ev");}
void  S59C7 ::v47(){vfunc_called(this, "_ZN5S59C73v47Ev");}
void  S59C7 ::v48(){vfunc_called(this, "_ZN5S59C73v48Ev");}
void  S59C7 ::v49(){vfunc_called(this, "_ZN5S59C73v49Ev");}
void  S59C7 ::v50(){vfunc_called(this, "_ZN5S59C73v50Ev");}
void  S59C7 ::v51(){vfunc_called(this, "_ZN5S59C73v51Ev");}
void  S59C7 ::v52(){vfunc_called(this, "_ZN5S59C73v52Ev");}
void  S59C7 ::v53(){vfunc_called(this, "_ZN5S59C73v53Ev");}
void  S59C7 ::v54(){vfunc_called(this, "_ZN5S59C73v54Ev");}
void  S59C7 ::v55(){vfunc_called(this, "_ZN5S59C73v55Ev");}
void  S59C7 ::v56(){vfunc_called(this, "_ZN5S59C73v56Ev");}
void  S59C7 ::v57(){vfunc_called(this, "_ZN5S59C73v57Ev");}
void  S59C7 ::v58(){vfunc_called(this, "_ZN5S59C73v58Ev");}
void  S59C7 ::v59(){vfunc_called(this, "_ZN5S59C73v59Ev");}
void  S59C7 ::v60(){vfunc_called(this, "_ZN5S59C73v60Ev");}
void  S59C7 ::v61(){vfunc_called(this, "_ZN5S59C73v61Ev");}
void  S59C7 ::v62(){vfunc_called(this, "_ZN5S59C73v62Ev");}
void  S59C7 ::v63(){vfunc_called(this, "_ZN5S59C73v63Ev");}
void  S59C7 ::v64(){vfunc_called(this, "_ZN5S59C73v64Ev");}
void  S59C7 ::v65(){vfunc_called(this, "_ZN5S59C73v65Ev");}
void  S59C7 ::v66(){vfunc_called(this, "_ZN5S59C73v66Ev");}
S59C7 ::S59C7(){ note_ctor("S59C7", this);} // tgen

static void Test_S59C7()
{
  extern Class_Descriptor cd_S59C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S59C7, buf);
    S59C7 *dp, &lv = *(dp=new (buf) S59C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S59C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S59C7)");
    check_field_offset(lv, s59c7f0, ABISELECT(8,4), "S59C7.s59c7f0");
    check_field_offset(lv, s59c7f1, ABISELECT(16,8), "S59C7.s59c7f1");
    check_field_offset(lv, s59c7f2, ABISELECT(24,16), "S59C7.s59c7f2");
    check_field_offset(lv, s59c7f3, ABISELECT(56,32), "S59C7.s59c7f3");
    check_field_offset(lv, s59c7f4, ABISELECT(64,40), "S59C7.s59c7f4");
    check_field_offset(lv, s59c7f5, ABISELECT(72,44), "S59C7.s59c7f5");
    check_field_offset(lv, s59c7f6, ABISELECT(80,52), "S59C7.s59c7f6");
    test_class_info(&lv, &cd_S59C7);
    dp->~S59C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS59C7(Test_S59C7, "S59C7", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN5S59C7C1Ev();
extern void _ZN5S59C7D1Ev();
Name_Map name_map_S59C7[] = {
  NSPAIR(_ZN5S59C7C1Ev),
  NSPAIR(_ZN5S59C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI5S59C7[];
extern void _ZN5S59C7D1Ev();
extern void _ZN5S59C7D0Ev();
extern void _ZN5S59C72v3Ev();
extern void _ZN5S59C72v4Ev();
extern void _ZN5S59C72v5Ev();
extern void _ZN5S59C72v6Ev();
extern void _ZN5S59C72v7Ev();
extern void _ZN5S59C72v8Ev();
extern void _ZN5S59C72v9Ev();
extern void _ZN5S59C73v10Ev();
extern void _ZN5S59C73v11Ev();
extern void _ZN5S59C73v12Ev();
extern void _ZN5S59C73v13Ev();
extern void _ZN5S59C73v14Ev();
extern void _ZN5S59C73v15Ev();
extern void _ZN5S59C73v16Ev();
extern void _ZN5S59C73v17Ev();
extern void _ZN5S59C73v18Ev();
extern void _ZN5S59C73v19Ev();
extern void _ZN5S59C73v20Ev();
extern void _ZN5S59C73v21Ev();
extern void _ZN5S59C73v22Ev();
extern void _ZN5S59C73v23Ev();
extern void _ZN5S59C73v24Ev();
extern void _ZN5S59C73v25Ev();
extern void _ZN5S59C73v26Ev();
extern void _ZN5S59C73v27Ev();
extern void _ZN5S59C73v28Ev();
extern void _ZN5S59C73v29Ev();
extern void _ZN5S59C73v30Ev();
extern void _ZN5S59C73v31Ev();
extern void _ZN5S59C73v32Ev();
extern void _ZN5S59C73v33Ev();
extern void _ZN5S59C73v34Ev();
extern void _ZN5S59C73v35Ev();
extern void _ZN5S59C73v36Ev();
extern void _ZN5S59C73v37Ev();
extern void _ZN5S59C73v38Ev();
extern void _ZN5S59C73v39Ev();
extern void _ZN5S59C73v40Ev();
extern void _ZN5S59C73v41Ev();
extern void _ZN5S59C73v42Ev();
extern void _ZN5S59C73v43Ev();
extern void _ZN5S59C73v44Ev();
extern void _ZN5S59C73v45Ev();
extern void _ZN5S59C73v46Ev();
extern void _ZN5S59C73v47Ev();
extern void _ZN5S59C73v48Ev();
extern void _ZN5S59C73v49Ev();
extern void _ZN5S59C73v50Ev();
extern void _ZN5S59C73v51Ev();
extern void _ZN5S59C73v52Ev();
extern void _ZN5S59C73v53Ev();
extern void _ZN5S59C73v54Ev();
extern void _ZN5S59C73v55Ev();
extern void _ZN5S59C73v56Ev();
extern void _ZN5S59C73v57Ev();
extern void _ZN5S59C73v58Ev();
extern void _ZN5S59C73v59Ev();
extern void _ZN5S59C73v60Ev();
extern void _ZN5S59C73v61Ev();
extern void _ZN5S59C73v62Ev();
extern void _ZN5S59C73v63Ev();
extern void _ZN5S59C73v64Ev();
extern void _ZN5S59C73v65Ev();
extern void _ZN5S59C73v66Ev();
static  VTBL_ENTRY vtc_S59C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S59C7[0]),
  (VTBL_ENTRY)&_ZN5S59C7D1Ev,
  (VTBL_ENTRY)&_ZN5S59C7D0Ev,
  (VTBL_ENTRY)&_ZN5S59C72v3Ev,
  (VTBL_ENTRY)&_ZN5S59C72v4Ev,
  (VTBL_ENTRY)&_ZN5S59C72v5Ev,
  (VTBL_ENTRY)&_ZN5S59C72v6Ev,
  (VTBL_ENTRY)&_ZN5S59C72v7Ev,
  (VTBL_ENTRY)&_ZN5S59C72v8Ev,
  (VTBL_ENTRY)&_ZN5S59C72v9Ev,
  (VTBL_ENTRY)&_ZN5S59C73v10Ev,
  (VTBL_ENTRY)&_ZN5S59C73v11Ev,
  (VTBL_ENTRY)&_ZN5S59C73v12Ev,
  (VTBL_ENTRY)&_ZN5S59C73v13Ev,
  (VTBL_ENTRY)&_ZN5S59C73v14Ev,
  (VTBL_ENTRY)&_ZN5S59C73v15Ev,
  (VTBL_ENTRY)&_ZN5S59C73v16Ev,
  (VTBL_ENTRY)&_ZN5S59C73v17Ev,
  (VTBL_ENTRY)&_ZN5S59C73v18Ev,
  (VTBL_ENTRY)&_ZN5S59C73v19Ev,
  (VTBL_ENTRY)&_ZN5S59C73v20Ev,
  (VTBL_ENTRY)&_ZN5S59C73v21Ev,
  (VTBL_ENTRY)&_ZN5S59C73v22Ev,
  (VTBL_ENTRY)&_ZN5S59C73v23Ev,
  (VTBL_ENTRY)&_ZN5S59C73v24Ev,
  (VTBL_ENTRY)&_ZN5S59C73v25Ev,
  (VTBL_ENTRY)&_ZN5S59C73v26Ev,
  (VTBL_ENTRY)&_ZN5S59C73v27Ev,
  (VTBL_ENTRY)&_ZN5S59C73v28Ev,
  (VTBL_ENTRY)&_ZN5S59C73v29Ev,
  (VTBL_ENTRY)&_ZN5S59C73v30Ev,
  (VTBL_ENTRY)&_ZN5S59C73v31Ev,
  (VTBL_ENTRY)&_ZN5S59C73v32Ev,
  (VTBL_ENTRY)&_ZN5S59C73v33Ev,
  (VTBL_ENTRY)&_ZN5S59C73v34Ev,
  (VTBL_ENTRY)&_ZN5S59C73v35Ev,
  (VTBL_ENTRY)&_ZN5S59C73v36Ev,
  (VTBL_ENTRY)&_ZN5S59C73v37Ev,
  (VTBL_ENTRY)&_ZN5S59C73v38Ev,
  (VTBL_ENTRY)&_ZN5S59C73v39Ev,
  (VTBL_ENTRY)&_ZN5S59C73v40Ev,
  (VTBL_ENTRY)&_ZN5S59C73v41Ev,
  (VTBL_ENTRY)&_ZN5S59C73v42Ev,
  (VTBL_ENTRY)&_ZN5S59C73v43Ev,
  (VTBL_ENTRY)&_ZN5S59C73v44Ev,
  (VTBL_ENTRY)&_ZN5S59C73v45Ev,
  (VTBL_ENTRY)&_ZN5S59C73v46Ev,
  (VTBL_ENTRY)&_ZN5S59C73v47Ev,
  (VTBL_ENTRY)&_ZN5S59C73v48Ev,
  (VTBL_ENTRY)&_ZN5S59C73v49Ev,
  (VTBL_ENTRY)&_ZN5S59C73v50Ev,
  (VTBL_ENTRY)&_ZN5S59C73v51Ev,
  (VTBL_ENTRY)&_ZN5S59C73v52Ev,
  (VTBL_ENTRY)&_ZN5S59C73v53Ev,
  (VTBL_ENTRY)&_ZN5S59C73v54Ev,
  (VTBL_ENTRY)&_ZN5S59C73v55Ev,
  (VTBL_ENTRY)&_ZN5S59C73v56Ev,
  (VTBL_ENTRY)&_ZN5S59C73v57Ev,
  (VTBL_ENTRY)&_ZN5S59C73v58Ev,
  (VTBL_ENTRY)&_ZN5S59C73v59Ev,
  (VTBL_ENTRY)&_ZN5S59C73v60Ev,
  (VTBL_ENTRY)&_ZN5S59C73v61Ev,
  (VTBL_ENTRY)&_ZN5S59C73v62Ev,
  (VTBL_ENTRY)&_ZN5S59C73v63Ev,
  (VTBL_ENTRY)&_ZN5S59C73v64Ev,
  (VTBL_ENTRY)&_ZN5S59C73v65Ev,
  (VTBL_ENTRY)&_ZN5S59C73v66Ev,
};
extern VTBL_ENTRY _ZTI5S59C7[];
extern  VTBL_ENTRY _ZTV5S59C7[];
Class_Descriptor cd_S59C7 = {  "S59C7", // class name
  0,0,//no base classes
  &(vtc_S59C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI5S59C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV5S59C7),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S59C6  : S59C7 {
  int s59c6f0[2];
  void *s59c6f1;
  int s59c6f2[2];
  ::S287C8_nt s59c6f3;
  ::S287C8_nt s59c6f4;
  ::S2121C38 s59c6f5;
  ::S287C8_nt s59c6f6;
  unsigned int s59c6f7:1;
  unsigned int s59c6f8:1;
  unsigned int s59c6f9:1;
  unsigned int s59c6f10:1;
  unsigned int s59c6f11:1;
  int s59c6f12[2];
  virtual  ~S59C6(); // _ZN5S59C6D1Ev
  virtual void  v67(); // _ZN5S59C63v67Ev
  virtual void  v68(); // _ZN5S59C63v68Ev
  virtual void  v69(); // _ZN5S59C63v69Ev
  virtual void  v70(); // _ZN5S59C63v70Ev
  virtual void  v71(); // _ZN5S59C63v71Ev
  virtual void  v72(); // _ZN5S59C63v72Ev
  virtual void  v73(); // _ZN5S59C63v73Ev
  virtual void  v74(); // _ZN5S59C63v74Ev
  virtual void  v75(); // _ZN5S59C63v75Ev
  virtual void  v76(); // _ZN5S59C63v76Ev
  virtual void  v77(); // _ZN5S59C63v77Ev
  virtual void  v78(); // _ZN5S59C63v78Ev
  virtual void  v79(); // _ZN5S59C63v79Ev
  virtual void  v80(); // _ZN5S59C63v80Ev
  virtual void  v81(); // _ZN5S59C63v81Ev
  virtual void  v82(); // _ZN5S59C63v82Ev
  virtual void  v83(); // _ZN5S59C63v83Ev
  virtual void  v84(); // _ZN5S59C63v84Ev
  virtual void  v85(); // _ZN5S59C63v85Ev
  virtual void  v86(); // _ZN5S59C63v86Ev
  virtual void  v87(); // _ZN5S59C63v87Ev
  virtual void  v88(); // _ZN5S59C63v88Ev
  S59C6(); // tgen
};
//SIG(-1 S59C6) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S59C6 ::~S59C6(){ note_dtor("S59C6", this);}
void  S59C6 ::v67(){vfunc_called(this, "_ZN5S59C63v67Ev");}
void  S59C6 ::v68(){vfunc_called(this, "_ZN5S59C63v68Ev");}
void  S59C6 ::v69(){vfunc_called(this, "_ZN5S59C63v69Ev");}
void  S59C6 ::v70(){vfunc_called(this, "_ZN5S59C63v70Ev");}
void  S59C6 ::v71(){vfunc_called(this, "_ZN5S59C63v71Ev");}
void  S59C6 ::v72(){vfunc_called(this, "_ZN5S59C63v72Ev");}
void  S59C6 ::v73(){vfunc_called(this, "_ZN5S59C63v73Ev");}
void  S59C6 ::v74(){vfunc_called(this, "_ZN5S59C63v74Ev");}
void  S59C6 ::v75(){vfunc_called(this, "_ZN5S59C63v75Ev");}
void  S59C6 ::v76(){vfunc_called(this, "_ZN5S59C63v76Ev");}
void  S59C6 ::v77(){vfunc_called(this, "_ZN5S59C63v77Ev");}
void  S59C6 ::v78(){vfunc_called(this, "_ZN5S59C63v78Ev");}
void  S59C6 ::v79(){vfunc_called(this, "_ZN5S59C63v79Ev");}
void  S59C6 ::v80(){vfunc_called(this, "_ZN5S59C63v80Ev");}
void  S59C6 ::v81(){vfunc_called(this, "_ZN5S59C63v81Ev");}
void  S59C6 ::v82(){vfunc_called(this, "_ZN5S59C63v82Ev");}
void  S59C6 ::v83(){vfunc_called(this, "_ZN5S59C63v83Ev");}
void  S59C6 ::v84(){vfunc_called(this, "_ZN5S59C63v84Ev");}
void  S59C6 ::v85(){vfunc_called(this, "_ZN5S59C63v85Ev");}
void  S59C6 ::v86(){vfunc_called(this, "_ZN5S59C63v86Ev");}
void  S59C6 ::v87(){vfunc_called(this, "_ZN5S59C63v87Ev");}
void  S59C6 ::v88(){vfunc_called(this, "_ZN5S59C63v88Ev");}
S59C6 ::S59C6(){ note_ctor("S59C6", this);} // tgen

static void Test_S59C6()
{
  extern Class_Descriptor cd_S59C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S59C6, buf);
    S59C6 *dp, &lv = *(dp=new (buf) S59C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S59C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S59C6)");
    check_base_class_offset(lv, (S59C7*), 0, "S59C6");
    check_field_offset(lv, s59c6f0, ABISELECT(96,60), "S59C6.s59c6f0");
    check_field_offset(lv, s59c6f1, ABISELECT(104,68), "S59C6.s59c6f1");
    check_field_offset(lv, s59c6f2, ABISELECT(112,72), "S59C6.s59c6f2");
    check_field_offset(lv, s59c6f3, ABISELECT(120,80), "S59C6.s59c6f3");
    check_field_offset(lv, s59c6f4, ABISELECT(136,92), "S59C6.s59c6f4");
    check_field_offset(lv, s59c6f5, ABISELECT(152,104), "S59C6.s59c6f5");
    check_field_offset(lv, s59c6f6, ABISELECT(160,108), "S59C6.s59c6f6");
    set_bf_and_test(lv, s59c6f7, ABISELECT(176,120), 0, 1, 1, "S59C6");
    set_bf_and_test(lv, s59c6f8, ABISELECT(176,120), 1, 1, 1, "S59C6");
    set_bf_and_test(lv, s59c6f9, ABISELECT(176,120), 2, 1, 1, "S59C6");
    set_bf_and_test(lv, s59c6f10, ABISELECT(176,120), 3, 1, 1, "S59C6");
    set_bf_and_test(lv, s59c6f11, ABISELECT(176,120), 4, 1, 1, "S59C6");
    check_field_offset(lv, s59c6f12, ABISELECT(180,124), "S59C6.s59c6f12");
    test_class_info(&lv, &cd_S59C6);
    dp->~S59C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS59C6(Test_S59C6, "S59C6", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN5S59C6C1Ev();
extern void _ZN5S59C6D1Ev();
Name_Map name_map_S59C6[] = {
  NSPAIR(_ZN5S59C6C1Ev),
  NSPAIR(_ZN5S59C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S59C7;
extern VTBL_ENTRY _ZTI5S59C7[];
extern  VTBL_ENTRY _ZTV5S59C7[];
static Base_Class bases_S59C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S59C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S59C6[];
extern void _ZN5S59C6D1Ev();
extern void _ZN5S59C6D0Ev();
extern void _ZN5S59C72v3Ev();
extern void _ZN5S59C72v4Ev();
extern void _ZN5S59C72v5Ev();
extern void _ZN5S59C72v6Ev();
extern void _ZN5S59C72v7Ev();
extern void _ZN5S59C72v8Ev();
extern void _ZN5S59C72v9Ev();
extern void _ZN5S59C73v10Ev();
extern void _ZN5S59C73v11Ev();
extern void _ZN5S59C73v12Ev();
extern void _ZN5S59C73v13Ev();
extern void _ZN5S59C73v14Ev();
extern void _ZN5S59C73v15Ev();
extern void _ZN5S59C73v16Ev();
extern void _ZN5S59C73v17Ev();
extern void _ZN5S59C73v18Ev();
extern void _ZN5S59C73v19Ev();
extern void _ZN5S59C73v20Ev();
extern void _ZN5S59C73v21Ev();
extern void _ZN5S59C73v22Ev();
extern void _ZN5S59C73v23Ev();
extern void _ZN5S59C73v24Ev();
extern void _ZN5S59C73v25Ev();
extern void _ZN5S59C73v26Ev();
extern void _ZN5S59C73v27Ev();
extern void _ZN5S59C73v28Ev();
extern void _ZN5S59C73v29Ev();
extern void _ZN5S59C73v30Ev();
extern void _ZN5S59C73v31Ev();
extern void _ZN5S59C73v32Ev();
extern void _ZN5S59C73v33Ev();
extern void _ZN5S59C73v34Ev();
extern void _ZN5S59C73v35Ev();
extern void _ZN5S59C73v36Ev();
extern void _ZN5S59C73v37Ev();
extern void _ZN5S59C73v38Ev();
extern void _ZN5S59C73v39Ev();
extern void _ZN5S59C73v40Ev();
extern void _ZN5S59C73v41Ev();
extern void _ZN5S59C73v42Ev();
extern void _ZN5S59C73v43Ev();
extern void _ZN5S59C73v44Ev();
extern void _ZN5S59C73v45Ev();
extern void _ZN5S59C73v46Ev();
extern void _ZN5S59C73v47Ev();
extern void _ZN5S59C73v48Ev();
extern void _ZN5S59C73v49Ev();
extern void _ZN5S59C73v50Ev();
extern void _ZN5S59C73v51Ev();
extern void _ZN5S59C73v52Ev();
extern void _ZN5S59C73v53Ev();
extern void _ZN5S59C73v54Ev();
extern void _ZN5S59C73v55Ev();
extern void _ZN5S59C73v56Ev();
extern void _ZN5S59C73v57Ev();
extern void _ZN5S59C73v58Ev();
extern void _ZN5S59C73v59Ev();
extern void _ZN5S59C73v60Ev();
extern void _ZN5S59C73v61Ev();
extern void _ZN5S59C73v62Ev();
extern void _ZN5S59C73v63Ev();
extern void _ZN5S59C73v64Ev();
extern void _ZN5S59C73v65Ev();
extern void _ZN5S59C73v66Ev();
extern void _ZN5S59C63v67Ev();
extern void _ZN5S59C63v68Ev();
extern void _ZN5S59C63v69Ev();
extern void _ZN5S59C63v70Ev();
extern void _ZN5S59C63v71Ev();
extern void _ZN5S59C63v72Ev();
extern void _ZN5S59C63v73Ev();
extern void _ZN5S59C63v74Ev();
extern void _ZN5S59C63v75Ev();
extern void _ZN5S59C63v76Ev();
extern void _ZN5S59C63v77Ev();
extern void _ZN5S59C63v78Ev();
extern void _ZN5S59C63v79Ev();
extern void _ZN5S59C63v80Ev();
extern void _ZN5S59C63v81Ev();
extern void _ZN5S59C63v82Ev();
extern void _ZN5S59C63v83Ev();
extern void _ZN5S59C63v84Ev();
extern void _ZN5S59C63v85Ev();
extern void _ZN5S59C63v86Ev();
extern void _ZN5S59C63v87Ev();
extern void _ZN5S59C63v88Ev();
static  VTBL_ENTRY vtc_S59C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S59C6[0]),
  (VTBL_ENTRY)&_ZN5S59C6D1Ev,
  (VTBL_ENTRY)&_ZN5S59C6D0Ev,
  (VTBL_ENTRY)&_ZN5S59C72v3Ev,
  (VTBL_ENTRY)&_ZN5S59C72v4Ev,
  (VTBL_ENTRY)&_ZN5S59C72v5Ev,
  (VTBL_ENTRY)&_ZN5S59C72v6Ev,
  (VTBL_ENTRY)&_ZN5S59C72v7Ev,
  (VTBL_ENTRY)&_ZN5S59C72v8Ev,
  (VTBL_ENTRY)&_ZN5S59C72v9Ev,
  (VTBL_ENTRY)&_ZN5S59C73v10Ev,
  (VTBL_ENTRY)&_ZN5S59C73v11Ev,
  (VTBL_ENTRY)&_ZN5S59C73v12Ev,
  (VTBL_ENTRY)&_ZN5S59C73v13Ev,
  (VTBL_ENTRY)&_ZN5S59C73v14Ev,
  (VTBL_ENTRY)&_ZN5S59C73v15Ev,
  (VTBL_ENTRY)&_ZN5S59C73v16Ev,
  (VTBL_ENTRY)&_ZN5S59C73v17Ev,
  (VTBL_ENTRY)&_ZN5S59C73v18Ev,
  (VTBL_ENTRY)&_ZN5S59C73v19Ev,
  (VTBL_ENTRY)&_ZN5S59C73v20Ev,
  (VTBL_ENTRY)&_ZN5S59C73v21Ev,
  (VTBL_ENTRY)&_ZN5S59C73v22Ev,
  (VTBL_ENTRY)&_ZN5S59C73v23Ev,
  (VTBL_ENTRY)&_ZN5S59C73v24Ev,
  (VTBL_ENTRY)&_ZN5S59C73v25Ev,
  (VTBL_ENTRY)&_ZN5S59C73v26Ev,
  (VTBL_ENTRY)&_ZN5S59C73v27Ev,
  (VTBL_ENTRY)&_ZN5S59C73v28Ev,
  (VTBL_ENTRY)&_ZN5S59C73v29Ev,
  (VTBL_ENTRY)&_ZN5S59C73v30Ev,
  (VTBL_ENTRY)&_ZN5S59C73v31Ev,
  (VTBL_ENTRY)&_ZN5S59C73v32Ev,
  (VTBL_ENTRY)&_ZN5S59C73v33Ev,
  (VTBL_ENTRY)&_ZN5S59C73v34Ev,
  (VTBL_ENTRY)&_ZN5S59C73v35Ev,
  (VTBL_ENTRY)&_ZN5S59C73v36Ev,
  (VTBL_ENTRY)&_ZN5S59C73v37Ev,
  (VTBL_ENTRY)&_ZN5S59C73v38Ev,
  (VTBL_ENTRY)&_ZN5S59C73v39Ev,
  (VTBL_ENTRY)&_ZN5S59C73v40Ev,
  (VTBL_ENTRY)&_ZN5S59C73v41Ev,
  (VTBL_ENTRY)&_ZN5S59C73v42Ev,
  (VTBL_ENTRY)&_ZN5S59C73v43Ev,
  (VTBL_ENTRY)&_ZN5S59C73v44Ev,
  (VTBL_ENTRY)&_ZN5S59C73v45Ev,
  (VTBL_ENTRY)&_ZN5S59C73v46Ev,
  (VTBL_ENTRY)&_ZN5S59C73v47Ev,
  (VTBL_ENTRY)&_ZN5S59C73v48Ev,
  (VTBL_ENTRY)&_ZN5S59C73v49Ev,
  (VTBL_ENTRY)&_ZN5S59C73v50Ev,
  (VTBL_ENTRY)&_ZN5S59C73v51Ev,
  (VTBL_ENTRY)&_ZN5S59C73v52Ev,
  (VTBL_ENTRY)&_ZN5S59C73v53Ev,
  (VTBL_ENTRY)&_ZN5S59C73v54Ev,
  (VTBL_ENTRY)&_ZN5S59C73v55Ev,
  (VTBL_ENTRY)&_ZN5S59C73v56Ev,
  (VTBL_ENTRY)&_ZN5S59C73v57Ev,
  (VTBL_ENTRY)&_ZN5S59C73v58Ev,
  (VTBL_ENTRY)&_ZN5S59C73v59Ev,
  (VTBL_ENTRY)&_ZN5S59C73v60Ev,
  (VTBL_ENTRY)&_ZN5S59C73v61Ev,
  (VTBL_ENTRY)&_ZN5S59C73v62Ev,
  (VTBL_ENTRY)&_ZN5S59C73v63Ev,
  (VTBL_ENTRY)&_ZN5S59C73v64Ev,
  (VTBL_ENTRY)&_ZN5S59C73v65Ev,
  (VTBL_ENTRY)&_ZN5S59C73v66Ev,
  (VTBL_ENTRY)&_ZN5S59C63v67Ev,
  (VTBL_ENTRY)&_ZN5S59C63v68Ev,
  (VTBL_ENTRY)&_ZN5S59C63v69Ev,
  (VTBL_ENTRY)&_ZN5S59C63v70Ev,
  (VTBL_ENTRY)&_ZN5S59C63v71Ev,
  (VTBL_ENTRY)&_ZN5S59C63v72Ev,
  (VTBL_ENTRY)&_ZN5S59C63v73Ev,
  (VTBL_ENTRY)&_ZN5S59C63v74Ev,
  (VTBL_ENTRY)&_ZN5S59C63v75Ev,
  (VTBL_ENTRY)&_ZN5S59C63v76Ev,
  (VTBL_ENTRY)&_ZN5S59C63v77Ev,
  (VTBL_ENTRY)&_ZN5S59C63v78Ev,
  (VTBL_ENTRY)&_ZN5S59C63v79Ev,
  (VTBL_ENTRY)&_ZN5S59C63v80Ev,
  (VTBL_ENTRY)&_ZN5S59C63v81Ev,
  (VTBL_ENTRY)&_ZN5S59C63v82Ev,
  (VTBL_ENTRY)&_ZN5S59C63v83Ev,
  (VTBL_ENTRY)&_ZN5S59C63v84Ev,
  (VTBL_ENTRY)&_ZN5S59C63v85Ev,
  (VTBL_ENTRY)&_ZN5S59C63v86Ev,
  (VTBL_ENTRY)&_ZN5S59C63v87Ev,
  (VTBL_ENTRY)&_ZN5S59C63v88Ev,
};
extern VTBL_ENTRY _ZTI5S59C6[];
extern  VTBL_ENTRY _ZTV5S59C6[];
Class_Descriptor cd_S59C6 = {  "S59C6", // class name
  bases_S59C6, 1,
  &(vtc_S59C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI5S59C6),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S59C6),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S59C5  : S59C6 {
  unsigned int s59c5f0:1;
  unsigned int s59c5f1:1;
  unsigned int s59c5f2:1;
  ::S3350C17 s59c5f3;
  ::S3350C11 s59c5f4;
  ::S3350C5_nt s59c5f5;
  ::S287C27 s59c5f6;
  int s59c5f7[3];
  virtual  ~S59C5(); // _ZN5S59C5D1Ev
  virtual void  v89(); // _ZN5S59C53v89Ev
  virtual void  v90(); // _ZN5S59C53v90Ev
  virtual void  v91(); // _ZN5S59C53v91Ev
  virtual void  v92(); // _ZN5S59C53v92Ev
  virtual void  v93(); // _ZN5S59C53v93Ev
  virtual void  v94(); // _ZN5S59C53v94Ev
  virtual void  v95(); // _ZN5S59C53v95Ev
  virtual void  v96(); // _ZN5S59C53v96Ev
  virtual void  v97(); // _ZN5S59C53v97Ev
  virtual void  v98(); // _ZN5S59C53v98Ev
  virtual void  v99(); // _ZN5S59C53v99Ev
  virtual void  v100(); // _ZN5S59C54v100Ev
  virtual void  v101(); // _ZN5S59C54v101Ev
  virtual void  v102(); // _ZN5S59C54v102Ev
  virtual void  v103(); // _ZN5S59C54v103Ev
  virtual void  v104(); // _ZN5S59C54v104Ev
  virtual void  v105(); // _ZN5S59C54v105Ev
  virtual void  v106(); // _ZN5S59C54v106Ev
  virtual void  v107(); // _ZN5S59C54v107Ev
  virtual void  v108(); // _ZN5S59C54v108Ev
  S59C5(); // tgen
};
//SIG(-1 S59C5) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} FC16{ BC17{ BC8}} Fi[3]}


 S59C5 ::~S59C5(){ note_dtor("S59C5", this);}
void  S59C5 ::v89(){vfunc_called(this, "_ZN5S59C53v89Ev");}
void  S59C5 ::v90(){vfunc_called(this, "_ZN5S59C53v90Ev");}
void  S59C5 ::v91(){vfunc_called(this, "_ZN5S59C53v91Ev");}
void  S59C5 ::v92(){vfunc_called(this, "_ZN5S59C53v92Ev");}
void  S59C5 ::v93(){vfunc_called(this, "_ZN5S59C53v93Ev");}
void  S59C5 ::v94(){vfunc_called(this, "_ZN5S59C53v94Ev");}
void  S59C5 ::v95(){vfunc_called(this, "_ZN5S59C53v95Ev");}
void  S59C5 ::v96(){vfunc_called(this, "_ZN5S59C53v96Ev");}
void  S59C5 ::v97(){vfunc_called(this, "_ZN5S59C53v97Ev");}
void  S59C5 ::v98(){vfunc_called(this, "_ZN5S59C53v98Ev");}
void  S59C5 ::v99(){vfunc_called(this, "_ZN5S59C53v99Ev");}
void  S59C5 ::v100(){vfunc_called(this, "_ZN5S59C54v100Ev");}
void  S59C5 ::v101(){vfunc_called(this, "_ZN5S59C54v101Ev");}
void  S59C5 ::v102(){vfunc_called(this, "_ZN5S59C54v102Ev");}
void  S59C5 ::v103(){vfunc_called(this, "_ZN5S59C54v103Ev");}
void  S59C5 ::v104(){vfunc_called(this, "_ZN5S59C54v104Ev");}
void  S59C5 ::v105(){vfunc_called(this, "_ZN5S59C54v105Ev");}
void  S59C5 ::v106(){vfunc_called(this, "_ZN5S59C54v106Ev");}
void  S59C5 ::v107(){vfunc_called(this, "_ZN5S59C54v107Ev");}
void  S59C5 ::v108(){vfunc_called(this, "_ZN5S59C54v108Ev");}
S59C5 ::S59C5(){ note_ctor("S59C5", this);} // tgen

static void Test_S59C5()
{
  extern Class_Descriptor cd_S59C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(35,50)];
    init_test(&cd_S59C5, buf);
    S59C5 *dp, &lv = *(dp=new (buf) S59C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,196), "sizeof(S59C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S59C5)");
    check_base_class_offset(lv, (S59C7*)(S59C6*), 0, "S59C5");
    check_base_class_offset(lv, (S59C6*), 0, "S59C5");
    set_bf_and_test(lv, s59c5f0, ABISELECT(188,132), 0, 1, 1, "S59C5");
    set_bf_and_test(lv, s59c5f1, ABISELECT(188,132), 1, 1, 1, "S59C5");
    set_bf_and_test(lv, s59c5f2, ABISELECT(188,132), 2, 1, 1, "S59C5");
    check_field_offset(lv, s59c5f3, ABISELECT(192,136), "S59C5.s59c5f3");
    check_field_offset(lv, s59c5f4, ABISELECT(208,148), "S59C5.s59c5f4");
    check_field_offset(lv, s59c5f5, ABISELECT(224,160), "S59C5.s59c5f5");
    check_field_offset(lv, s59c5f6, ABISELECT(240,172), "S59C5.s59c5f6");
    check_field_offset(lv, s59c5f7, ABISELECT(256,184), "S59C5.s59c5f7");
    test_class_info(&lv, &cd_S59C5);
    dp->~S59C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS59C5(Test_S59C5, "S59C5", ABISELECT(272,196));

#else // __cplusplus

extern void _ZN5S59C5C1Ev();
extern void _ZN5S59C5D1Ev();
Name_Map name_map_S59C5[] = {
  NSPAIR(_ZN5S59C5C1Ev),
  NSPAIR(_ZN5S59C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S59C7;
extern VTBL_ENTRY _ZTI5S59C7[];
extern  VTBL_ENTRY _ZTV5S59C7[];
extern Class_Descriptor cd_S59C6;
extern VTBL_ENTRY _ZTI5S59C6[];
extern  VTBL_ENTRY _ZTV5S59C6[];
static Base_Class bases_S59C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S59C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S59C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S59C5[];
extern void _ZN5S59C5D1Ev();
extern void _ZN5S59C5D0Ev();
extern void _ZN5S59C72v3Ev();
extern void _ZN5S59C72v4Ev();
extern void _ZN5S59C72v5Ev();
extern void _ZN5S59C72v6Ev();
extern void _ZN5S59C72v7Ev();
extern void _ZN5S59C72v8Ev();
extern void _ZN5S59C72v9Ev();
extern void _ZN5S59C73v10Ev();
extern void _ZN5S59C73v11Ev();
extern void _ZN5S59C73v12Ev();
extern void _ZN5S59C73v13Ev();
extern void _ZN5S59C73v14Ev();
extern void _ZN5S59C73v15Ev();
extern void _ZN5S59C73v16Ev();
extern void _ZN5S59C73v17Ev();
extern void _ZN5S59C73v18Ev();
extern void _ZN5S59C73v19Ev();
extern void _ZN5S59C73v20Ev();
extern void _ZN5S59C73v21Ev();
extern void _ZN5S59C73v22Ev();
extern void _ZN5S59C73v23Ev();
extern void _ZN5S59C73v24Ev();
extern void _ZN5S59C73v25Ev();
extern void _ZN5S59C73v26Ev();
extern void _ZN5S59C73v27Ev();
extern void _ZN5S59C73v28Ev();
extern void _ZN5S59C73v29Ev();
extern void _ZN5S59C73v30Ev();
extern void _ZN5S59C73v31Ev();
extern void _ZN5S59C73v32Ev();
extern void _ZN5S59C73v33Ev();
extern void _ZN5S59C73v34Ev();
extern void _ZN5S59C73v35Ev();
extern void _ZN5S59C73v36Ev();
extern void _ZN5S59C73v37Ev();
extern void _ZN5S59C73v38Ev();
extern void _ZN5S59C73v39Ev();
extern void _ZN5S59C73v40Ev();
extern void _ZN5S59C73v41Ev();
extern void _ZN5S59C73v42Ev();
extern void _ZN5S59C73v43Ev();
extern void _ZN5S59C73v44Ev();
extern void _ZN5S59C73v45Ev();
extern void _ZN5S59C73v46Ev();
extern void _ZN5S59C73v47Ev();
extern void _ZN5S59C73v48Ev();
extern void _ZN5S59C73v49Ev();
extern void _ZN5S59C73v50Ev();
extern void _ZN5S59C73v51Ev();
extern void _ZN5S59C73v52Ev();
extern void _ZN5S59C73v53Ev();
extern void _ZN5S59C73v54Ev();
extern void _ZN5S59C73v55Ev();
extern void _ZN5S59C73v56Ev();
extern void _ZN5S59C73v57Ev();
extern void _ZN5S59C73v58Ev();
extern void _ZN5S59C73v59Ev();
extern void _ZN5S59C73v60Ev();
extern void _ZN5S59C73v61Ev();
extern void _ZN5S59C73v62Ev();
extern void _ZN5S59C73v63Ev();
extern void _ZN5S59C73v64Ev();
extern void _ZN5S59C73v65Ev();
extern void _ZN5S59C73v66Ev();
extern void _ZN5S59C63v67Ev();
extern void _ZN5S59C63v68Ev();
extern void _ZN5S59C63v69Ev();
extern void _ZN5S59C63v70Ev();
extern void _ZN5S59C63v71Ev();
extern void _ZN5S59C63v72Ev();
extern void _ZN5S59C63v73Ev();
extern void _ZN5S59C63v74Ev();
extern void _ZN5S59C63v75Ev();
extern void _ZN5S59C63v76Ev();
extern void _ZN5S59C63v77Ev();
extern void _ZN5S59C63v78Ev();
extern void _ZN5S59C63v79Ev();
extern void _ZN5S59C63v80Ev();
extern void _ZN5S59C63v81Ev();
extern void _ZN5S59C63v82Ev();
extern void _ZN5S59C63v83Ev();
extern void _ZN5S59C63v84Ev();
extern void _ZN5S59C63v85Ev();
extern void _ZN5S59C63v86Ev();
extern void _ZN5S59C63v87Ev();
extern void _ZN5S59C63v88Ev();
extern void _ZN5S59C53v89Ev();
extern void _ZN5S59C53v90Ev();
extern void _ZN5S59C53v91Ev();
extern void _ZN5S59C53v92Ev();
extern void _ZN5S59C53v93Ev();
extern void _ZN5S59C53v94Ev();
extern void _ZN5S59C53v95Ev();
extern void _ZN5S59C53v96Ev();
extern void _ZN5S59C53v97Ev();
extern void _ZN5S59C53v98Ev();
extern void _ZN5S59C53v99Ev();
extern void _ZN5S59C54v100Ev();
extern void _ZN5S59C54v101Ev();
extern void _ZN5S59C54v102Ev();
extern void _ZN5S59C54v103Ev();
extern void _ZN5S59C54v104Ev();
extern void _ZN5S59C54v105Ev();
extern void _ZN5S59C54v106Ev();
extern void _ZN5S59C54v107Ev();
extern void _ZN5S59C54v108Ev();
static  VTBL_ENTRY vtc_S59C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S59C5[0]),
  (VTBL_ENTRY)&_ZN5S59C5D1Ev,
  (VTBL_ENTRY)&_ZN5S59C5D0Ev,
  (VTBL_ENTRY)&_ZN5S59C72v3Ev,
  (VTBL_ENTRY)&_ZN5S59C72v4Ev,
  (VTBL_ENTRY)&_ZN5S59C72v5Ev,
  (VTBL_ENTRY)&_ZN5S59C72v6Ev,
  (VTBL_ENTRY)&_ZN5S59C72v7Ev,
  (VTBL_ENTRY)&_ZN5S59C72v8Ev,
  (VTBL_ENTRY)&_ZN5S59C72v9Ev,
  (VTBL_ENTRY)&_ZN5S59C73v10Ev,
  (VTBL_ENTRY)&_ZN5S59C73v11Ev,
  (VTBL_ENTRY)&_ZN5S59C73v12Ev,
  (VTBL_ENTRY)&_ZN5S59C73v13Ev,
  (VTBL_ENTRY)&_ZN5S59C73v14Ev,
  (VTBL_ENTRY)&_ZN5S59C73v15Ev,
  (VTBL_ENTRY)&_ZN5S59C73v16Ev,
  (VTBL_ENTRY)&_ZN5S59C73v17Ev,
  (VTBL_ENTRY)&_ZN5S59C73v18Ev,
  (VTBL_ENTRY)&_ZN5S59C73v19Ev,
  (VTBL_ENTRY)&_ZN5S59C73v20Ev,
  (VTBL_ENTRY)&_ZN5S59C73v21Ev,
  (VTBL_ENTRY)&_ZN5S59C73v22Ev,
  (VTBL_ENTRY)&_ZN5S59C73v23Ev,
  (VTBL_ENTRY)&_ZN5S59C73v24Ev,
  (VTBL_ENTRY)&_ZN5S59C73v25Ev,
  (VTBL_ENTRY)&_ZN5S59C73v26Ev,
  (VTBL_ENTRY)&_ZN5S59C73v27Ev,
  (VTBL_ENTRY)&_ZN5S59C73v28Ev,
  (VTBL_ENTRY)&_ZN5S59C73v29Ev,
  (VTBL_ENTRY)&_ZN5S59C73v30Ev,
  (VTBL_ENTRY)&_ZN5S59C73v31Ev,
  (VTBL_ENTRY)&_ZN5S59C73v32Ev,
  (VTBL_ENTRY)&_ZN5S59C73v33Ev,
  (VTBL_ENTRY)&_ZN5S59C73v34Ev,
  (VTBL_ENTRY)&_ZN5S59C73v35Ev,
  (VTBL_ENTRY)&_ZN5S59C73v36Ev,
  (VTBL_ENTRY)&_ZN5S59C73v37Ev,
  (VTBL_ENTRY)&_ZN5S59C73v38Ev,
  (VTBL_ENTRY)&_ZN5S59C73v39Ev,
  (VTBL_ENTRY)&_ZN5S59C73v40Ev,
  (VTBL_ENTRY)&_ZN5S59C73v41Ev,
  (VTBL_ENTRY)&_ZN5S59C73v42Ev,
  (VTBL_ENTRY)&_ZN5S59C73v43Ev,
  (VTBL_ENTRY)&_ZN5S59C73v44Ev,
  (VTBL_ENTRY)&_ZN5S59C73v45Ev,
  (VTBL_ENTRY)&_ZN5S59C73v46Ev,
  (VTBL_ENTRY)&_ZN5S59C73v47Ev,
  (VTBL_ENTRY)&_ZN5S59C73v48Ev,
  (VTBL_ENTRY)&_ZN5S59C73v49Ev,
  (VTBL_ENTRY)&_ZN5S59C73v50Ev,
  (VTBL_ENTRY)&_ZN5S59C73v51Ev,
  (VTBL_ENTRY)&_ZN5S59C73v52Ev,
  (VTBL_ENTRY)&_ZN5S59C73v53Ev,
  (VTBL_ENTRY)&_ZN5S59C73v54Ev,
  (VTBL_ENTRY)&_ZN5S59C73v55Ev,
  (VTBL_ENTRY)&_ZN5S59C73v56Ev,
  (VTBL_ENTRY)&_ZN5S59C73v57Ev,
  (VTBL_ENTRY)&_ZN5S59C73v58Ev,
  (VTBL_ENTRY)&_ZN5S59C73v59Ev,
  (VTBL_ENTRY)&_ZN5S59C73v60Ev,
  (VTBL_ENTRY)&_ZN5S59C73v61Ev,
  (VTBL_ENTRY)&_ZN5S59C73v62Ev,
  (VTBL_ENTRY)&_ZN5S59C73v63Ev,
  (VTBL_ENTRY)&_ZN5S59C73v64Ev,
  (VTBL_ENTRY)&_ZN5S59C73v65Ev,
  (VTBL_ENTRY)&_ZN5S59C73v66Ev,
  (VTBL_ENTRY)&_ZN5S59C63v67Ev,
  (VTBL_ENTRY)&_ZN5S59C63v68Ev,
  (VTBL_ENTRY)&_ZN5S59C63v69Ev,
  (VTBL_ENTRY)&_ZN5S59C63v70Ev,
  (VTBL_ENTRY)&_ZN5S59C63v71Ev,
  (VTBL_ENTRY)&_ZN5S59C63v72Ev,
  (VTBL_ENTRY)&_ZN5S59C63v73Ev,
  (VTBL_ENTRY)&_ZN5S59C63v74Ev,
  (VTBL_ENTRY)&_ZN5S59C63v75Ev,
  (VTBL_ENTRY)&_ZN5S59C63v76Ev,
  (VTBL_ENTRY)&_ZN5S59C63v77Ev,
  (VTBL_ENTRY)&_ZN5S59C63v78Ev,
  (VTBL_ENTRY)&_ZN5S59C63v79Ev,
  (VTBL_ENTRY)&_ZN5S59C63v80Ev,
  (VTBL_ENTRY)&_ZN5S59C63v81Ev,
  (VTBL_ENTRY)&_ZN5S59C63v82Ev,
  (VTBL_ENTRY)&_ZN5S59C63v83Ev,
  (VTBL_ENTRY)&_ZN5S59C63v84Ev,
  (VTBL_ENTRY)&_ZN5S59C63v85Ev,
  (VTBL_ENTRY)&_ZN5S59C63v86Ev,
  (VTBL_ENTRY)&_ZN5S59C63v87Ev,
  (VTBL_ENTRY)&_ZN5S59C63v88Ev,
  (VTBL_ENTRY)&_ZN5S59C53v89Ev,
  (VTBL_ENTRY)&_ZN5S59C53v90Ev,
  (VTBL_ENTRY)&_ZN5S59C53v91Ev,
  (VTBL_ENTRY)&_ZN5S59C53v92Ev,
  (VTBL_ENTRY)&_ZN5S59C53v93Ev,
  (VTBL_ENTRY)&_ZN5S59C53v94Ev,
  (VTBL_ENTRY)&_ZN5S59C53v95Ev,
  (VTBL_ENTRY)&_ZN5S59C53v96Ev,
  (VTBL_ENTRY)&_ZN5S59C53v97Ev,
  (VTBL_ENTRY)&_ZN5S59C53v98Ev,
  (VTBL_ENTRY)&_ZN5S59C53v99Ev,
  (VTBL_ENTRY)&_ZN5S59C54v100Ev,
  (VTBL_ENTRY)&_ZN5S59C54v101Ev,
  (VTBL_ENTRY)&_ZN5S59C54v102Ev,
  (VTBL_ENTRY)&_ZN5S59C54v103Ev,
  (VTBL_ENTRY)&_ZN5S59C54v104Ev,
  (VTBL_ENTRY)&_ZN5S59C54v105Ev,
  (VTBL_ENTRY)&_ZN5S59C54v106Ev,
  (VTBL_ENTRY)&_ZN5S59C54v107Ev,
  (VTBL_ENTRY)&_ZN5S59C54v108Ev,
};
extern VTBL_ENTRY _ZTI5S59C5[];
extern  VTBL_ENTRY _ZTV5S59C5[];
Class_Descriptor cd_S59C5 = {  "S59C5", // class name
  bases_S59C5, 2,
  &(vtc_S59C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI5S59C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S59C5),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S59C4  : S59C5 {
  void *s59c4f0[2];
  int s59c4f1[4];
  unsigned int s59c4f2:1;
  unsigned int s59c4f3:1;
  unsigned int s59c4f4:1;
  char s59c4f5;
  int s59c4f6;
  unsigned int s59c4f7:1;
  ::S287C23 s59c4f8;
  virtual  ~S59C4(); // _ZN5S59C4D1Ev
  virtual void  v109(); // _ZN5S59C44v109Ev
  virtual void  v110(); // _ZN5S59C44v110Ev
  virtual void  v111(); // _ZN5S59C44v111Ev
  virtual void  v112(); // _ZN5S59C44v112Ev
  virtual void  v113(); // _ZN5S59C44v113Ev
  virtual void  v114(); // _ZN5S59C44v114Ev
  virtual void  v115(); // _ZN5S59C44v115Ev
  virtual void  v116(); // _ZN5S59C44v116Ev
  virtual void  v117(); // _ZN5S59C44v117Ev
  virtual void  v118(); // _ZN5S59C44v118Ev
  virtual void  v119(); // _ZN5S59C44v119Ev
  virtual void  v120(); // _ZN5S59C44v120Ev
  virtual void  v121(); // _ZN5S59C44v121Ev
  virtual void  v122(); // _ZN5S59C44v122Ev
  S59C4(); // tgen
};
//SIG(-1 S59C4) C1{ BC2{ BC3{ BC4{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} FC17{ BC18{ BC9}} Fi[3]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] Fi[4] Fi:1 Fi:1 Fi:1 Fc Fi Fi:1 FC19{ BC20{ BC9}}}


 S59C4 ::~S59C4(){ note_dtor("S59C4", this);}
void  S59C4 ::v109(){vfunc_called(this, "_ZN5S59C44v109Ev");}
void  S59C4 ::v110(){vfunc_called(this, "_ZN5S59C44v110Ev");}
void  S59C4 ::v111(){vfunc_called(this, "_ZN5S59C44v111Ev");}
void  S59C4 ::v112(){vfunc_called(this, "_ZN5S59C44v112Ev");}
void  S59C4 ::v113(){vfunc_called(this, "_ZN5S59C44v113Ev");}
void  S59C4 ::v114(){vfunc_called(this, "_ZN5S59C44v114Ev");}
void  S59C4 ::v115(){vfunc_called(this, "_ZN5S59C44v115Ev");}
void  S59C4 ::v116(){vfunc_called(this, "_ZN5S59C44v116Ev");}
void  S59C4 ::v117(){vfunc_called(this, "_ZN5S59C44v117Ev");}
void  S59C4 ::v118(){vfunc_called(this, "_ZN5S59C44v118Ev");}
void  S59C4 ::v119(){vfunc_called(this, "_ZN5S59C44v119Ev");}
void  S59C4 ::v120(){vfunc_called(this, "_ZN5S59C44v120Ev");}
void  S59C4 ::v121(){vfunc_called(this, "_ZN5S59C44v121Ev");}
void  S59C4 ::v122(){vfunc_called(this, "_ZN5S59C44v122Ev");}
S59C4 ::S59C4(){ note_ctor("S59C4", this);} // tgen

static void Test_S59C4()
{
  extern Class_Descriptor cd_S59C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(43,62)];
    init_test(&cd_S59C4, buf);
    S59C4 *dp, &lv = *(dp=new (buf) S59C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(336,244), "sizeof(S59C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S59C4)");
    check_base_class_offset(lv, (S59C7*)(S59C6*)(S59C5*), 0, "S59C4");
    check_base_class_offset(lv, (S59C6*)(S59C5*), 0, "S59C4");
    check_base_class_offset(lv, (S59C5*), 0, "S59C4");
    check_field_offset(lv, s59c4f0, ABISELECT(272,196), "S59C4.s59c4f0");
    check_field_offset(lv, s59c4f1, ABISELECT(288,204), "S59C4.s59c4f1");
    set_bf_and_test(lv, s59c4f2, ABISELECT(304,220), 0, 1, 1, "S59C4");
    set_bf_and_test(lv, s59c4f3, ABISELECT(304,220), 1, 1, 1, "S59C4");
    set_bf_and_test(lv, s59c4f4, ABISELECT(304,220), 2, 1, 1, "S59C4");
    check_field_offset(lv, s59c4f5, ABISELECT(305,221), "S59C4.s59c4f5");
    check_field_offset(lv, s59c4f6, ABISELECT(308,224), "S59C4.s59c4f6");
    set_bf_and_test(lv, s59c4f7, ABISELECT(312,228), 0, 1, 1, "S59C4");
    check_field_offset(lv, s59c4f8, ABISELECT(320,232), "S59C4.s59c4f8");
    test_class_info(&lv, &cd_S59C4);
    dp->~S59C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS59C4(Test_S59C4, "S59C4", ABISELECT(336,244));

#else // __cplusplus

extern void _ZN5S59C4C1Ev();
extern void _ZN5S59C4D1Ev();
Name_Map name_map_S59C4[] = {
  NSPAIR(_ZN5S59C4C1Ev),
  NSPAIR(_ZN5S59C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S59C7;
extern VTBL_ENTRY _ZTI5S59C7[];
extern  VTBL_ENTRY _ZTV5S59C7[];
extern Class_Descriptor cd_S59C6;
extern VTBL_ENTRY _ZTI5S59C6[];
extern  VTBL_ENTRY _ZTV5S59C6[];
extern Class_Descriptor cd_S59C5;
extern VTBL_ENTRY _ZTI5S59C5[];
extern  VTBL_ENTRY _ZTV5S59C5[];
static Base_Class bases_S59C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S59C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S59C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S59C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S59C4[];
extern void _ZN5S59C4D1Ev();
extern void _ZN5S59C4D0Ev();
extern void _ZN5S59C72v3Ev();
extern void _ZN5S59C72v4Ev();
extern void _ZN5S59C72v5Ev();
extern void _ZN5S59C72v6Ev();
extern void _ZN5S59C72v7Ev();
extern void _ZN5S59C72v8Ev();
extern void _ZN5S59C72v9Ev();
extern void _ZN5S59C73v10Ev();
extern void _ZN5S59C73v11Ev();
extern void _ZN5S59C73v12Ev();
extern void _ZN5S59C73v13Ev();
extern void _ZN5S59C73v14Ev();
extern void _ZN5S59C73v15Ev();
extern void _ZN5S59C73v16Ev();
extern void _ZN5S59C73v17Ev();
extern void _ZN5S59C73v18Ev();
extern void _ZN5S59C73v19Ev();
extern void _ZN5S59C73v20Ev();
extern void _ZN5S59C73v21Ev();
extern void _ZN5S59C73v22Ev();
extern void _ZN5S59C73v23Ev();
extern void _ZN5S59C73v24Ev();
extern void _ZN5S59C73v25Ev();
extern void _ZN5S59C73v26Ev();
extern void _ZN5S59C73v27Ev();
extern void _ZN5S59C73v28Ev();
extern void _ZN5S59C73v29Ev();
extern void _ZN5S59C73v30Ev();
extern void _ZN5S59C73v31Ev();
extern void _ZN5S59C73v32Ev();
extern void _ZN5S59C73v33Ev();
extern void _ZN5S59C73v34Ev();
extern void _ZN5S59C73v35Ev();
extern void _ZN5S59C73v36Ev();
extern void _ZN5S59C73v37Ev();
extern void _ZN5S59C73v38Ev();
extern void _ZN5S59C73v39Ev();
extern void _ZN5S59C73v40Ev();
extern void _ZN5S59C73v41Ev();
extern void _ZN5S59C73v42Ev();
extern void _ZN5S59C73v43Ev();
extern void _ZN5S59C73v44Ev();
extern void _ZN5S59C73v45Ev();
extern void _ZN5S59C73v46Ev();
extern void _ZN5S59C73v47Ev();
extern void _ZN5S59C73v48Ev();
extern void _ZN5S59C73v49Ev();
extern void _ZN5S59C73v50Ev();
extern void _ZN5S59C73v51Ev();
extern void _ZN5S59C73v52Ev();
extern void _ZN5S59C73v53Ev();
extern void _ZN5S59C73v54Ev();
extern void _ZN5S59C73v55Ev();
extern void _ZN5S59C73v56Ev();
extern void _ZN5S59C73v57Ev();
extern void _ZN5S59C73v58Ev();
extern void _ZN5S59C73v59Ev();
extern void _ZN5S59C73v60Ev();
extern void _ZN5S59C73v61Ev();
extern void _ZN5S59C73v62Ev();
extern void _ZN5S59C73v63Ev();
extern void _ZN5S59C73v64Ev();
extern void _ZN5S59C73v65Ev();
extern void _ZN5S59C73v66Ev();
extern void _ZN5S59C63v67Ev();
extern void _ZN5S59C63v68Ev();
extern void _ZN5S59C63v69Ev();
extern void _ZN5S59C63v70Ev();
extern void _ZN5S59C63v71Ev();
extern void _ZN5S59C63v72Ev();
extern void _ZN5S59C63v73Ev();
extern void _ZN5S59C63v74Ev();
extern void _ZN5S59C63v75Ev();
extern void _ZN5S59C63v76Ev();
extern void _ZN5S59C63v77Ev();
extern void _ZN5S59C63v78Ev();
extern void _ZN5S59C63v79Ev();
extern void _ZN5S59C63v80Ev();
extern void _ZN5S59C63v81Ev();
extern void _ZN5S59C63v82Ev();
extern void _ZN5S59C63v83Ev();
extern void _ZN5S59C63v84Ev();
extern void _ZN5S59C63v85Ev();
extern void _ZN5S59C63v86Ev();
extern void _ZN5S59C63v87Ev();
extern void _ZN5S59C63v88Ev();
extern void _ZN5S59C53v89Ev();
extern void _ZN5S59C53v90Ev();
extern void _ZN5S59C53v91Ev();
extern void _ZN5S59C53v92Ev();
extern void _ZN5S59C53v93Ev();
extern void _ZN5S59C53v94Ev();
extern void _ZN5S59C53v95Ev();
extern void _ZN5S59C53v96Ev();
extern void _ZN5S59C53v97Ev();
extern void _ZN5S59C53v98Ev();
extern void _ZN5S59C53v99Ev();
extern void _ZN5S59C54v100Ev();
extern void _ZN5S59C54v101Ev();
extern void _ZN5S59C54v102Ev();
extern void _ZN5S59C54v103Ev();
extern void _ZN5S59C54v104Ev();
extern void _ZN5S59C54v105Ev();
extern void _ZN5S59C54v106Ev();
extern void _ZN5S59C54v107Ev();
extern void _ZN5S59C54v108Ev();
extern void _ZN5S59C44v109Ev();
extern void _ZN5S59C44v110Ev();
extern void _ZN5S59C44v111Ev();
extern void _ZN5S59C44v112Ev();
extern void _ZN5S59C44v113Ev();
extern void _ZN5S59C44v114Ev();
extern void _ZN5S59C44v115Ev();
extern void _ZN5S59C44v116Ev();
extern void _ZN5S59C44v117Ev();
extern void _ZN5S59C44v118Ev();
extern void _ZN5S59C44v119Ev();
extern void _ZN5S59C44v120Ev();
extern void _ZN5S59C44v121Ev();
extern void _ZN5S59C44v122Ev();
static  VTBL_ENTRY vtc_S59C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S59C4[0]),
  (VTBL_ENTRY)&_ZN5S59C4D1Ev,
  (VTBL_ENTRY)&_ZN5S59C4D0Ev,
  (VTBL_ENTRY)&_ZN5S59C72v3Ev,
  (VTBL_ENTRY)&_ZN5S59C72v4Ev,
  (VTBL_ENTRY)&_ZN5S59C72v5Ev,
  (VTBL_ENTRY)&_ZN5S59C72v6Ev,
  (VTBL_ENTRY)&_ZN5S59C72v7Ev,
  (VTBL_ENTRY)&_ZN5S59C72v8Ev,
  (VTBL_ENTRY)&_ZN5S59C72v9Ev,
  (VTBL_ENTRY)&_ZN5S59C73v10Ev,
  (VTBL_ENTRY)&_ZN5S59C73v11Ev,
  (VTBL_ENTRY)&_ZN5S59C73v12Ev,
  (VTBL_ENTRY)&_ZN5S59C73v13Ev,
  (VTBL_ENTRY)&_ZN5S59C73v14Ev,
  (VTBL_ENTRY)&_ZN5S59C73v15Ev,
  (VTBL_ENTRY)&_ZN5S59C73v16Ev,
  (VTBL_ENTRY)&_ZN5S59C73v17Ev,
  (VTBL_ENTRY)&_ZN5S59C73v18Ev,
  (VTBL_ENTRY)&_ZN5S59C73v19Ev,
  (VTBL_ENTRY)&_ZN5S59C73v20Ev,
  (VTBL_ENTRY)&_ZN5S59C73v21Ev,
  (VTBL_ENTRY)&_ZN5S59C73v22Ev,
  (VTBL_ENTRY)&_ZN5S59C73v23Ev,
  (VTBL_ENTRY)&_ZN5S59C73v24Ev,
  (VTBL_ENTRY)&_ZN5S59C73v25Ev,
  (VTBL_ENTRY)&_ZN5S59C73v26Ev,
  (VTBL_ENTRY)&_ZN5S59C73v27Ev,
  (VTBL_ENTRY)&_ZN5S59C73v28Ev,
  (VTBL_ENTRY)&_ZN5S59C73v29Ev,
  (VTBL_ENTRY)&_ZN5S59C73v30Ev,
  (VTBL_ENTRY)&_ZN5S59C73v31Ev,
  (VTBL_ENTRY)&_ZN5S59C73v32Ev,
  (VTBL_ENTRY)&_ZN5S59C73v33Ev,
  (VTBL_ENTRY)&_ZN5S59C73v34Ev,
  (VTBL_ENTRY)&_ZN5S59C73v35Ev,
  (VTBL_ENTRY)&_ZN5S59C73v36Ev,
  (VTBL_ENTRY)&_ZN5S59C73v37Ev,
  (VTBL_ENTRY)&_ZN5S59C73v38Ev,
  (VTBL_ENTRY)&_ZN5S59C73v39Ev,
  (VTBL_ENTRY)&_ZN5S59C73v40Ev,
  (VTBL_ENTRY)&_ZN5S59C73v41Ev,
  (VTBL_ENTRY)&_ZN5S59C73v42Ev,
  (VTBL_ENTRY)&_ZN5S59C73v43Ev,
  (VTBL_ENTRY)&_ZN5S59C73v44Ev,
  (VTBL_ENTRY)&_ZN5S59C73v45Ev,
  (VTBL_ENTRY)&_ZN5S59C73v46Ev,
  (VTBL_ENTRY)&_ZN5S59C73v47Ev,
  (VTBL_ENTRY)&_ZN5S59C73v48Ev,
  (VTBL_ENTRY)&_ZN5S59C73v49Ev,
  (VTBL_ENTRY)&_ZN5S59C73v50Ev,
  (VTBL_ENTRY)&_ZN5S59C73v51Ev,
  (VTBL_ENTRY)&_ZN5S59C73v52Ev,
  (VTBL_ENTRY)&_ZN5S59C73v53Ev,
  (VTBL_ENTRY)&_ZN5S59C73v54Ev,
  (VTBL_ENTRY)&_ZN5S59C73v55Ev,
  (VTBL_ENTRY)&_ZN5S59C73v56Ev,
  (VTBL_ENTRY)&_ZN5S59C73v57Ev,
  (VTBL_ENTRY)&_ZN5S59C73v58Ev,
  (VTBL_ENTRY)&_ZN5S59C73v59Ev,
  (VTBL_ENTRY)&_ZN5S59C73v60Ev,
  (VTBL_ENTRY)&_ZN5S59C73v61Ev,
  (VTBL_ENTRY)&_ZN5S59C73v62Ev,
  (VTBL_ENTRY)&_ZN5S59C73v63Ev,
  (VTBL_ENTRY)&_ZN5S59C73v64Ev,
  (VTBL_ENTRY)&_ZN5S59C73v65Ev,
  (VTBL_ENTRY)&_ZN5S59C73v66Ev,
  (VTBL_ENTRY)&_ZN5S59C63v67Ev,
  (VTBL_ENTRY)&_ZN5S59C63v68Ev,
  (VTBL_ENTRY)&_ZN5S59C63v69Ev,
  (VTBL_ENTRY)&_ZN5S59C63v70Ev,
  (VTBL_ENTRY)&_ZN5S59C63v71Ev,
  (VTBL_ENTRY)&_ZN5S59C63v72Ev,
  (VTBL_ENTRY)&_ZN5S59C63v73Ev,
  (VTBL_ENTRY)&_ZN5S59C63v74Ev,
  (VTBL_ENTRY)&_ZN5S59C63v75Ev,
  (VTBL_ENTRY)&_ZN5S59C63v76Ev,
  (VTBL_ENTRY)&_ZN5S59C63v77Ev,
  (VTBL_ENTRY)&_ZN5S59C63v78Ev,
  (VTBL_ENTRY)&_ZN5S59C63v79Ev,
  (VTBL_ENTRY)&_ZN5S59C63v80Ev,
  (VTBL_ENTRY)&_ZN5S59C63v81Ev,
  (VTBL_ENTRY)&_ZN5S59C63v82Ev,
  (VTBL_ENTRY)&_ZN5S59C63v83Ev,
  (VTBL_ENTRY)&_ZN5S59C63v84Ev,
  (VTBL_ENTRY)&_ZN5S59C63v85Ev,
  (VTBL_ENTRY)&_ZN5S59C63v86Ev,
  (VTBL_ENTRY)&_ZN5S59C63v87Ev,
  (VTBL_ENTRY)&_ZN5S59C63v88Ev,
  (VTBL_ENTRY)&_ZN5S59C53v89Ev,
  (VTBL_ENTRY)&_ZN5S59C53v90Ev,
  (VTBL_ENTRY)&_ZN5S59C53v91Ev,
  (VTBL_ENTRY)&_ZN5S59C53v92Ev,
  (VTBL_ENTRY)&_ZN5S59C53v93Ev,
  (VTBL_ENTRY)&_ZN5S59C53v94Ev,
  (VTBL_ENTRY)&_ZN5S59C53v95Ev,
  (VTBL_ENTRY)&_ZN5S59C53v96Ev,
  (VTBL_ENTRY)&_ZN5S59C53v97Ev,
  (VTBL_ENTRY)&_ZN5S59C53v98Ev,
  (VTBL_ENTRY)&_ZN5S59C53v99Ev,
  (VTBL_ENTRY)&_ZN5S59C54v100Ev,
  (VTBL_ENTRY)&_ZN5S59C54v101Ev,
  (VTBL_ENTRY)&_ZN5S59C54v102Ev,
  (VTBL_ENTRY)&_ZN5S59C54v103Ev,
  (VTBL_ENTRY)&_ZN5S59C54v104Ev,
  (VTBL_ENTRY)&_ZN5S59C54v105Ev,
  (VTBL_ENTRY)&_ZN5S59C54v106Ev,
  (VTBL_ENTRY)&_ZN5S59C54v107Ev,
  (VTBL_ENTRY)&_ZN5S59C54v108Ev,
  (VTBL_ENTRY)&_ZN5S59C44v109Ev,
  (VTBL_ENTRY)&_ZN5S59C44v110Ev,
  (VTBL_ENTRY)&_ZN5S59C44v111Ev,
  (VTBL_ENTRY)&_ZN5S59C44v112Ev,
  (VTBL_ENTRY)&_ZN5S59C44v113Ev,
  (VTBL_ENTRY)&_ZN5S59C44v114Ev,
  (VTBL_ENTRY)&_ZN5S59C44v115Ev,
  (VTBL_ENTRY)&_ZN5S59C44v116Ev,
  (VTBL_ENTRY)&_ZN5S59C44v117Ev,
  (VTBL_ENTRY)&_ZN5S59C44v118Ev,
  (VTBL_ENTRY)&_ZN5S59C44v119Ev,
  (VTBL_ENTRY)&_ZN5S59C44v120Ev,
  (VTBL_ENTRY)&_ZN5S59C44v121Ev,
  (VTBL_ENTRY)&_ZN5S59C44v122Ev,
};
extern VTBL_ENTRY _ZTI5S59C4[];
extern  VTBL_ENTRY _ZTV5S59C4[];
Class_Descriptor cd_S59C4 = {  "S59C4", // class name
  bases_S59C4, 3,
  &(vtc_S59C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(336,244), // object size
  NSPAIRA(_ZTI5S59C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S59C4),124, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S59C3  : S59C4 {
  void *s59c3f0[2];
  ::S287C8_nt s59c3f1;
  unsigned int s59c3f2:1;
  unsigned int s59c3f3:1;
  ::S3350C21_nt s59c3f4;
  virtual  ~S59C3(); // _ZN5S59C3D1Ev
  virtual void  v123(); // _ZN5S59C34v123Ev
  virtual void  v124(); // _ZN5S59C34v124Ev
  virtual void  v125(); // _ZN5S59C34v125Ev
  virtual void  v126(); // _ZN5S59C34v126Ev
  virtual void  v127(); // _ZN5S59C34v127Ev
  virtual void  v128(); // _ZN5S59C34v128Ev
  virtual void  v129(); // _ZN5S59C34v129Ev
  virtual void  v130(); // _ZN5S59C34v130Ev
  virtual void  v131(); // _ZN5S59C34v131Ev
  virtual void  v132(); // _ZN5S59C34v132Ev
  virtual void  v133(); // _ZN5S59C34v133Ev
  S59C3(); // tgen
};
//SIG(-1 S59C3) C1{ BC2{ BC3{ BC4{ BC5{ vd v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} FC18{ BC19{ BC10}} Fi[3]} vd v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 Fp[2] Fi[4] Fi:1 Fi:1 Fi:1 Fc Fi Fi:1 FC20{ BC21{ BC10}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 Fp[2] FC7 Fi:1 Fi:1 FC22{ m Fp FC6}}


 S59C3 ::~S59C3(){ note_dtor("S59C3", this);}
void  S59C3 ::v123(){vfunc_called(this, "_ZN5S59C34v123Ev");}
void  S59C3 ::v124(){vfunc_called(this, "_ZN5S59C34v124Ev");}
void  S59C3 ::v125(){vfunc_called(this, "_ZN5S59C34v125Ev");}
void  S59C3 ::v126(){vfunc_called(this, "_ZN5S59C34v126Ev");}
void  S59C3 ::v127(){vfunc_called(this, "_ZN5S59C34v127Ev");}
void  S59C3 ::v128(){vfunc_called(this, "_ZN5S59C34v128Ev");}
void  S59C3 ::v129(){vfunc_called(this, "_ZN5S59C34v129Ev");}
void  S59C3 ::v130(){vfunc_called(this, "_ZN5S59C34v130Ev");}
void  S59C3 ::v131(){vfunc_called(this, "_ZN5S59C34v131Ev");}
void  S59C3 ::v132(){vfunc_called(this, "_ZN5S59C34v132Ev");}
void  S59C3 ::v133(){vfunc_called(this, "_ZN5S59C34v133Ev");}
S59C3 ::S59C3(){ note_ctor("S59C3", this);} // tgen

static void Test_S59C3()
{
  extern Class_Descriptor cd_S59C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(50,71)];
    init_test(&cd_S59C3, buf);
    S59C3 *dp, &lv = *(dp=new (buf) S59C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(392,280), "sizeof(S59C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S59C3)");
    check_base_class_offset(lv, (S59C7*)(S59C6*)(S59C5*)(S59C4*), 0, "S59C3");
    check_base_class_offset(lv, (S59C6*)(S59C5*)(S59C4*), 0, "S59C3");
    check_base_class_offset(lv, (S59C5*)(S59C4*), 0, "S59C3");
    check_base_class_offset(lv, (S59C4*), 0, "S59C3");
    check_field_offset(lv, s59c3f0, ABISELECT(336,244), "S59C3.s59c3f0");
    check_field_offset(lv, s59c3f1, ABISELECT(352,252), "S59C3.s59c3f1");
    set_bf_and_test(lv, s59c3f2, ABISELECT(368,264), 0, 1, 1, "S59C3");
    set_bf_and_test(lv, s59c3f3, ABISELECT(368,264), 1, 1, 1, "S59C3");
    check_field_offset(lv, s59c3f4, ABISELECT(376,268), "S59C3.s59c3f4");
    test_class_info(&lv, &cd_S59C3);
    dp->~S59C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS59C3(Test_S59C3, "S59C3", ABISELECT(392,280));

#else // __cplusplus

extern void _ZN5S59C3C1Ev();
extern void _ZN5S59C3D1Ev();
Name_Map name_map_S59C3[] = {
  NSPAIR(_ZN5S59C3C1Ev),
  NSPAIR(_ZN5S59C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S59C7;
extern VTBL_ENTRY _ZTI5S59C7[];
extern  VTBL_ENTRY _ZTV5S59C7[];
extern Class_Descriptor cd_S59C6;
extern VTBL_ENTRY _ZTI5S59C6[];
extern  VTBL_ENTRY _ZTV5S59C6[];
extern Class_Descriptor cd_S59C5;
extern VTBL_ENTRY _ZTI5S59C5[];
extern  VTBL_ENTRY _ZTV5S59C5[];
extern Class_Descriptor cd_S59C4;
extern VTBL_ENTRY _ZTI5S59C4[];
extern  VTBL_ENTRY _ZTV5S59C4[];
static Base_Class bases_S59C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S59C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S59C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S59C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S59C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S59C3[];
extern void _ZN5S59C3D1Ev();
extern void _ZN5S59C3D0Ev();
extern void _ZN5S59C72v3Ev();
extern void _ZN5S59C72v4Ev();
extern void _ZN5S59C72v5Ev();
extern void _ZN5S59C72v6Ev();
extern void _ZN5S59C72v7Ev();
extern void _ZN5S59C72v8Ev();
extern void _ZN5S59C72v9Ev();
extern void _ZN5S59C73v10Ev();
extern void _ZN5S59C73v11Ev();
extern void _ZN5S59C73v12Ev();
extern void _ZN5S59C73v13Ev();
extern void _ZN5S59C73v14Ev();
extern void _ZN5S59C73v15Ev();
extern void _ZN5S59C73v16Ev();
extern void _ZN5S59C73v17Ev();
extern void _ZN5S59C73v18Ev();
extern void _ZN5S59C73v19Ev();
extern void _ZN5S59C73v20Ev();
extern void _ZN5S59C73v21Ev();
extern void _ZN5S59C73v22Ev();
extern void _ZN5S59C73v23Ev();
extern void _ZN5S59C73v24Ev();
extern void _ZN5S59C73v25Ev();
extern void _ZN5S59C73v26Ev();
extern void _ZN5S59C73v27Ev();
extern void _ZN5S59C73v28Ev();
extern void _ZN5S59C73v29Ev();
extern void _ZN5S59C73v30Ev();
extern void _ZN5S59C73v31Ev();
extern void _ZN5S59C73v32Ev();
extern void _ZN5S59C73v33Ev();
extern void _ZN5S59C73v34Ev();
extern void _ZN5S59C73v35Ev();
extern void _ZN5S59C73v36Ev();
extern void _ZN5S59C73v37Ev();
extern void _ZN5S59C73v38Ev();
extern void _ZN5S59C73v39Ev();
extern void _ZN5S59C73v40Ev();
extern void _ZN5S59C73v41Ev();
extern void _ZN5S59C73v42Ev();
extern void _ZN5S59C73v43Ev();
extern void _ZN5S59C73v44Ev();
extern void _ZN5S59C73v45Ev();
extern void _ZN5S59C73v46Ev();
extern void _ZN5S59C73v47Ev();
extern void _ZN5S59C73v48Ev();
extern void _ZN5S59C73v49Ev();
extern void _ZN5S59C73v50Ev();
extern void _ZN5S59C73v51Ev();
extern void _ZN5S59C73v52Ev();
extern void _ZN5S59C73v53Ev();
extern void _ZN5S59C73v54Ev();
extern void _ZN5S59C73v55Ev();
extern void _ZN5S59C73v56Ev();
extern void _ZN5S59C73v57Ev();
extern void _ZN5S59C73v58Ev();
extern void _ZN5S59C73v59Ev();
extern void _ZN5S59C73v60Ev();
extern void _ZN5S59C73v61Ev();
extern void _ZN5S59C73v62Ev();
extern void _ZN5S59C73v63Ev();
extern void _ZN5S59C73v64Ev();
extern void _ZN5S59C73v65Ev();
extern void _ZN5S59C73v66Ev();
extern void _ZN5S59C63v67Ev();
extern void _ZN5S59C63v68Ev();
extern void _ZN5S59C63v69Ev();
extern void _ZN5S59C63v70Ev();
extern void _ZN5S59C63v71Ev();
extern void _ZN5S59C63v72Ev();
extern void _ZN5S59C63v73Ev();
extern void _ZN5S59C63v74Ev();
extern void _ZN5S59C63v75Ev();
extern void _ZN5S59C63v76Ev();
extern void _ZN5S59C63v77Ev();
extern void _ZN5S59C63v78Ev();
extern void _ZN5S59C63v79Ev();
extern void _ZN5S59C63v80Ev();
extern void _ZN5S59C63v81Ev();
extern void _ZN5S59C63v82Ev();
extern void _ZN5S59C63v83Ev();
extern void _ZN5S59C63v84Ev();
extern void _ZN5S59C63v85Ev();
extern void _ZN5S59C63v86Ev();
extern void _ZN5S59C63v87Ev();
extern void _ZN5S59C63v88Ev();
extern void _ZN5S59C53v89Ev();
extern void _ZN5S59C53v90Ev();
extern void _ZN5S59C53v91Ev();
extern void _ZN5S59C53v92Ev();
extern void _ZN5S59C53v93Ev();
extern void _ZN5S59C53v94Ev();
extern void _ZN5S59C53v95Ev();
extern void _ZN5S59C53v96Ev();
extern void _ZN5S59C53v97Ev();
extern void _ZN5S59C53v98Ev();
extern void _ZN5S59C53v99Ev();
extern void _ZN5S59C54v100Ev();
extern void _ZN5S59C54v101Ev();
extern void _ZN5S59C54v102Ev();
extern void _ZN5S59C54v103Ev();
extern void _ZN5S59C54v104Ev();
extern void _ZN5S59C54v105Ev();
extern void _ZN5S59C54v106Ev();
extern void _ZN5S59C54v107Ev();
extern void _ZN5S59C54v108Ev();
extern void _ZN5S59C44v109Ev();
extern void _ZN5S59C44v110Ev();
extern void _ZN5S59C44v111Ev();
extern void _ZN5S59C44v112Ev();
extern void _ZN5S59C44v113Ev();
extern void _ZN5S59C44v114Ev();
extern void _ZN5S59C44v115Ev();
extern void _ZN5S59C44v116Ev();
extern void _ZN5S59C44v117Ev();
extern void _ZN5S59C44v118Ev();
extern void _ZN5S59C44v119Ev();
extern void _ZN5S59C44v120Ev();
extern void _ZN5S59C44v121Ev();
extern void _ZN5S59C44v122Ev();
extern void _ZN5S59C34v123Ev();
extern void _ZN5S59C34v124Ev();
extern void _ZN5S59C34v125Ev();
extern void _ZN5S59C34v126Ev();
extern void _ZN5S59C34v127Ev();
extern void _ZN5S59C34v128Ev();
extern void _ZN5S59C34v129Ev();
extern void _ZN5S59C34v130Ev();
extern void _ZN5S59C34v131Ev();
extern void _ZN5S59C34v132Ev();
extern void _ZN5S59C34v133Ev();
static  VTBL_ENTRY vtc_S59C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S59C3[0]),
  (VTBL_ENTRY)&_ZN5S59C3D1Ev,
  (VTBL_ENTRY)&_ZN5S59C3D0Ev,
  (VTBL_ENTRY)&_ZN5S59C72v3Ev,
  (VTBL_ENTRY)&_ZN5S59C72v4Ev,
  (VTBL_ENTRY)&_ZN5S59C72v5Ev,
  (VTBL_ENTRY)&_ZN5S59C72v6Ev,
  (VTBL_ENTRY)&_ZN5S59C72v7Ev,
  (VTBL_ENTRY)&_ZN5S59C72v8Ev,
  (VTBL_ENTRY)&_ZN5S59C72v9Ev,
  (VTBL_ENTRY)&_ZN5S59C73v10Ev,
  (VTBL_ENTRY)&_ZN5S59C73v11Ev,
  (VTBL_ENTRY)&_ZN5S59C73v12Ev,
  (VTBL_ENTRY)&_ZN5S59C73v13Ev,
  (VTBL_ENTRY)&_ZN5S59C73v14Ev,
  (VTBL_ENTRY)&_ZN5S59C73v15Ev,
  (VTBL_ENTRY)&_ZN5S59C73v16Ev,
  (VTBL_ENTRY)&_ZN5S59C73v17Ev,
  (VTBL_ENTRY)&_ZN5S59C73v18Ev,
  (VTBL_ENTRY)&_ZN5S59C73v19Ev,
  (VTBL_ENTRY)&_ZN5S59C73v20Ev,
  (VTBL_ENTRY)&_ZN5S59C73v21Ev,
  (VTBL_ENTRY)&_ZN5S59C73v22Ev,
  (VTBL_ENTRY)&_ZN5S59C73v23Ev,
  (VTBL_ENTRY)&_ZN5S59C73v24Ev,
  (VTBL_ENTRY)&_ZN5S59C73v25Ev,
  (VTBL_ENTRY)&_ZN5S59C73v26Ev,
  (VTBL_ENTRY)&_ZN5S59C73v27Ev,
  (VTBL_ENTRY)&_ZN5S59C73v28Ev,
  (VTBL_ENTRY)&_ZN5S59C73v29Ev,
  (VTBL_ENTRY)&_ZN5S59C73v30Ev,
  (VTBL_ENTRY)&_ZN5S59C73v31Ev,
  (VTBL_ENTRY)&_ZN5S59C73v32Ev,
  (VTBL_ENTRY)&_ZN5S59C73v33Ev,
  (VTBL_ENTRY)&_ZN5S59C73v34Ev,
  (VTBL_ENTRY)&_ZN5S59C73v35Ev,
  (VTBL_ENTRY)&_ZN5S59C73v36Ev,
  (VTBL_ENTRY)&_ZN5S59C73v37Ev,
  (VTBL_ENTRY)&_ZN5S59C73v38Ev,
  (VTBL_ENTRY)&_ZN5S59C73v39Ev,
  (VTBL_ENTRY)&_ZN5S59C73v40Ev,
  (VTBL_ENTRY)&_ZN5S59C73v41Ev,
  (VTBL_ENTRY)&_ZN5S59C73v42Ev,
  (VTBL_ENTRY)&_ZN5S59C73v43Ev,
  (VTBL_ENTRY)&_ZN5S59C73v44Ev,
  (VTBL_ENTRY)&_ZN5S59C73v45Ev,
  (VTBL_ENTRY)&_ZN5S59C73v46Ev,
  (VTBL_ENTRY)&_ZN5S59C73v47Ev,
  (VTBL_ENTRY)&_ZN5S59C73v48Ev,
  (VTBL_ENTRY)&_ZN5S59C73v49Ev,
  (VTBL_ENTRY)&_ZN5S59C73v50Ev,
  (VTBL_ENTRY)&_ZN5S59C73v51Ev,
  (VTBL_ENTRY)&_ZN5S59C73v52Ev,
  (VTBL_ENTRY)&_ZN5S59C73v53Ev,
  (VTBL_ENTRY)&_ZN5S59C73v54Ev,
  (VTBL_ENTRY)&_ZN5S59C73v55Ev,
  (VTBL_ENTRY)&_ZN5S59C73v56Ev,
  (VTBL_ENTRY)&_ZN5S59C73v57Ev,
  (VTBL_ENTRY)&_ZN5S59C73v58Ev,
  (VTBL_ENTRY)&_ZN5S59C73v59Ev,
  (VTBL_ENTRY)&_ZN5S59C73v60Ev,
  (VTBL_ENTRY)&_ZN5S59C73v61Ev,
  (VTBL_ENTRY)&_ZN5S59C73v62Ev,
  (VTBL_ENTRY)&_ZN5S59C73v63Ev,
  (VTBL_ENTRY)&_ZN5S59C73v64Ev,
  (VTBL_ENTRY)&_ZN5S59C73v65Ev,
  (VTBL_ENTRY)&_ZN5S59C73v66Ev,
  (VTBL_ENTRY)&_ZN5S59C63v67Ev,
  (VTBL_ENTRY)&_ZN5S59C63v68Ev,
  (VTBL_ENTRY)&_ZN5S59C63v69Ev,
  (VTBL_ENTRY)&_ZN5S59C63v70Ev,
  (VTBL_ENTRY)&_ZN5S59C63v71Ev,
  (VTBL_ENTRY)&_ZN5S59C63v72Ev,
  (VTBL_ENTRY)&_ZN5S59C63v73Ev,
  (VTBL_ENTRY)&_ZN5S59C63v74Ev,
  (VTBL_ENTRY)&_ZN5S59C63v75Ev,
  (VTBL_ENTRY)&_ZN5S59C63v76Ev,
  (VTBL_ENTRY)&_ZN5S59C63v77Ev,
  (VTBL_ENTRY)&_ZN5S59C63v78Ev,
  (VTBL_ENTRY)&_ZN5S59C63v79Ev,
  (VTBL_ENTRY)&_ZN5S59C63v80Ev,
  (VTBL_ENTRY)&_ZN5S59C63v81Ev,
  (VTBL_ENTRY)&_ZN5S59C63v82Ev,
  (VTBL_ENTRY)&_ZN5S59C63v83Ev,
  (VTBL_ENTRY)&_ZN5S59C63v84Ev,
  (VTBL_ENTRY)&_ZN5S59C63v85Ev,
  (VTBL_ENTRY)&_ZN5S59C63v86Ev,
  (VTBL_ENTRY)&_ZN5S59C63v87Ev,
  (VTBL_ENTRY)&_ZN5S59C63v88Ev,
  (VTBL_ENTRY)&_ZN5S59C53v89Ev,
  (VTBL_ENTRY)&_ZN5S59C53v90Ev,
  (VTBL_ENTRY)&_ZN5S59C53v91Ev,
  (VTBL_ENTRY)&_ZN5S59C53v92Ev,
  (VTBL_ENTRY)&_ZN5S59C53v93Ev,
  (VTBL_ENTRY)&_ZN5S59C53v94Ev,
  (VTBL_ENTRY)&_ZN5S59C53v95Ev,
  (VTBL_ENTRY)&_ZN5S59C53v96Ev,
  (VTBL_ENTRY)&_ZN5S59C53v97Ev,
  (VTBL_ENTRY)&_ZN5S59C53v98Ev,
  (VTBL_ENTRY)&_ZN5S59C53v99Ev,
  (VTBL_ENTRY)&_ZN5S59C54v100Ev,
  (VTBL_ENTRY)&_ZN5S59C54v101Ev,
  (VTBL_ENTRY)&_ZN5S59C54v102Ev,
  (VTBL_ENTRY)&_ZN5S59C54v103Ev,
  (VTBL_ENTRY)&_ZN5S59C54v104Ev,
  (VTBL_ENTRY)&_ZN5S59C54v105Ev,
  (VTBL_ENTRY)&_ZN5S59C54v106Ev,
  (VTBL_ENTRY)&_ZN5S59C54v107Ev,
  (VTBL_ENTRY)&_ZN5S59C54v108Ev,
  (VTBL_ENTRY)&_ZN5S59C44v109Ev,
  (VTBL_ENTRY)&_ZN5S59C44v110Ev,
  (VTBL_ENTRY)&_ZN5S59C44v111Ev,
  (VTBL_ENTRY)&_ZN5S59C44v112Ev,
  (VTBL_ENTRY)&_ZN5S59C44v113Ev,
  (VTBL_ENTRY)&_ZN5S59C44v114Ev,
  (VTBL_ENTRY)&_ZN5S59C44v115Ev,
  (VTBL_ENTRY)&_ZN5S59C44v116Ev,
  (VTBL_ENTRY)&_ZN5S59C44v117Ev,
  (VTBL_ENTRY)&_ZN5S59C44v118Ev,
  (VTBL_ENTRY)&_ZN5S59C44v119Ev,
  (VTBL_ENTRY)&_ZN5S59C44v120Ev,
  (VTBL_ENTRY)&_ZN5S59C44v121Ev,
  (VTBL_ENTRY)&_ZN5S59C44v122Ev,
  (VTBL_ENTRY)&_ZN5S59C34v123Ev,
  (VTBL_ENTRY)&_ZN5S59C34v124Ev,
  (VTBL_ENTRY)&_ZN5S59C34v125Ev,
  (VTBL_ENTRY)&_ZN5S59C34v126Ev,
  (VTBL_ENTRY)&_ZN5S59C34v127Ev,
  (VTBL_ENTRY)&_ZN5S59C34v128Ev,
  (VTBL_ENTRY)&_ZN5S59C34v129Ev,
  (VTBL_ENTRY)&_ZN5S59C34v130Ev,
  (VTBL_ENTRY)&_ZN5S59C34v131Ev,
  (VTBL_ENTRY)&_ZN5S59C34v132Ev,
  (VTBL_ENTRY)&_ZN5S59C34v133Ev,
};
extern VTBL_ENTRY _ZTI5S59C3[];
extern  VTBL_ENTRY _ZTV5S59C3[];
Class_Descriptor cd_S59C3 = {  "S59C3", // class name
  bases_S59C3, 4,
  &(vtc_S59C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(392,280), // object size
  NSPAIRA(_ZTI5S59C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S59C3),135, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S59C2  : S59C3 {
  virtual  ~S59C2(); // _ZN5S59C2D1Ev
  virtual void  v134(); // _ZN5S59C24v134Ev
  virtual void  v135(); // _ZN5S59C24v135Ev
  S59C2(); // tgen
};
//SIG(-1 S59C2) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi[2] Fp Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 FC12{ m} FC8 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 Fi:1 Fi:1 Fi:1 FC13{ BC14{ BC11}} FC15{ BC16{ BC11}} FC17{ BC18{ BC11}} FC19{ BC20{ BC11}} Fi[3]} vd v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 Fp[2] Fi[4] Fi:1 Fi:1 Fi:1 Fc Fi Fi:1 FC21{ BC22{ BC11}}} vd v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 Fp[2] FC8 Fi:1 Fi:1 FC23{ m Fp FC7}} vd v1 v2}


 S59C2 ::~S59C2(){ note_dtor("S59C2", this);}
void  S59C2 ::v134(){vfunc_called(this, "_ZN5S59C24v134Ev");}
void  S59C2 ::v135(){vfunc_called(this, "_ZN5S59C24v135Ev");}
S59C2 ::S59C2(){ note_ctor("S59C2", this);} // tgen

static void Test_S59C2()
{
  extern Class_Descriptor cd_S59C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(50,71)];
    init_test(&cd_S59C2, buf);
    S59C2 *dp, &lv = *(dp=new (buf) S59C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(392,280), "sizeof(S59C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S59C2)");
    check_base_class_offset(lv, (S59C7*)(S59C6*)(S59C5*)(S59C4*)(S59C3*), 0, "S59C2");
    check_base_class_offset(lv, (S59C6*)(S59C5*)(S59C4*)(S59C3*), 0, "S59C2");
    check_base_class_offset(lv, (S59C5*)(S59C4*)(S59C3*), 0, "S59C2");
    check_base_class_offset(lv, (S59C4*)(S59C3*), 0, "S59C2");
    check_base_class_offset(lv, (S59C3*), 0, "S59C2");
    test_class_info(&lv, &cd_S59C2);
    dp->~S59C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS59C2(Test_S59C2, "S59C2", ABISELECT(392,280));

#else // __cplusplus

extern void _ZN5S59C2C1Ev();
extern void _ZN5S59C2D1Ev();
Name_Map name_map_S59C2[] = {
  NSPAIR(_ZN5S59C2C1Ev),
  NSPAIR(_ZN5S59C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S59C7;
extern VTBL_ENTRY _ZTI5S59C7[];
extern  VTBL_ENTRY _ZTV5S59C7[];
extern Class_Descriptor cd_S59C6;
extern VTBL_ENTRY _ZTI5S59C6[];
extern  VTBL_ENTRY _ZTV5S59C6[];
extern Class_Descriptor cd_S59C5;
extern VTBL_ENTRY _ZTI5S59C5[];
extern  VTBL_ENTRY _ZTV5S59C5[];
extern Class_Descriptor cd_S59C4;
extern VTBL_ENTRY _ZTI5S59C4[];
extern  VTBL_ENTRY _ZTV5S59C4[];
extern Class_Descriptor cd_S59C3;
extern VTBL_ENTRY _ZTI5S59C3[];
extern  VTBL_ENTRY _ZTV5S59C3[];
static Base_Class bases_S59C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S59C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S59C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S59C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S59C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S59C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S59C2[];
extern void _ZN5S59C2D1Ev();
extern void _ZN5S59C2D0Ev();
extern void _ZN5S59C72v3Ev();
extern void _ZN5S59C72v4Ev();
extern void _ZN5S59C72v5Ev();
extern void _ZN5S59C72v6Ev();
extern void _ZN5S59C72v7Ev();
extern void _ZN5S59C72v8Ev();
extern void _ZN5S59C72v9Ev();
extern void _ZN5S59C73v10Ev();
extern void _ZN5S59C73v11Ev();
extern void _ZN5S59C73v12Ev();
extern void _ZN5S59C73v13Ev();
extern void _ZN5S59C73v14Ev();
extern void _ZN5S59C73v15Ev();
extern void _ZN5S59C73v16Ev();
extern void _ZN5S59C73v17Ev();
extern void _ZN5S59C73v18Ev();
extern void _ZN5S59C73v19Ev();
extern void _ZN5S59C73v20Ev();
extern void _ZN5S59C73v21Ev();
extern void _ZN5S59C73v22Ev();
extern void _ZN5S59C73v23Ev();
extern void _ZN5S59C73v24Ev();
extern void _ZN5S59C73v25Ev();
extern void _ZN5S59C73v26Ev();
extern void _ZN5S59C73v27Ev();
extern void _ZN5S59C73v28Ev();
extern void _ZN5S59C73v29Ev();
extern void _ZN5S59C73v30Ev();
extern void _ZN5S59C73v31Ev();
extern void _ZN5S59C73v32Ev();
extern void _ZN5S59C73v33Ev();
extern void _ZN5S59C73v34Ev();
extern void _ZN5S59C73v35Ev();
extern void _ZN5S59C73v36Ev();
extern void _ZN5S59C73v37Ev();
extern void _ZN5S59C73v38Ev();
extern void _ZN5S59C73v39Ev();
extern void _ZN5S59C73v40Ev();
extern void _ZN5S59C73v41Ev();
extern void _ZN5S59C73v42Ev();
extern void _ZN5S59C73v43Ev();
extern void _ZN5S59C73v44Ev();
extern void _ZN5S59C73v45Ev();
extern void _ZN5S59C73v46Ev();
extern void _ZN5S59C73v47Ev();
extern void _ZN5S59C73v48Ev();
extern void _ZN5S59C73v49Ev();
extern void _ZN5S59C73v50Ev();
extern void _ZN5S59C73v51Ev();
extern void _ZN5S59C73v52Ev();
extern void _ZN5S59C73v53Ev();
extern void _ZN5S59C73v54Ev();
extern void _ZN5S59C73v55Ev();
extern void _ZN5S59C73v56Ev();
extern void _ZN5S59C73v57Ev();
extern void _ZN5S59C73v58Ev();
extern void _ZN5S59C73v59Ev();
extern void _ZN5S59C73v60Ev();
extern void _ZN5S59C73v61Ev();
extern void _ZN5S59C73v62Ev();
extern void _ZN5S59C73v63Ev();
extern void _ZN5S59C73v64Ev();
extern void _ZN5S59C73v65Ev();
extern void _ZN5S59C73v66Ev();
extern void _ZN5S59C63v67Ev();
extern void _ZN5S59C63v68Ev();
extern void _ZN5S59C63v69Ev();
extern void _ZN5S59C63v70Ev();
extern void _ZN5S59C63v71Ev();
extern void _ZN5S59C63v72Ev();
extern void _ZN5S59C63v73Ev();
extern void _ZN5S59C63v74Ev();
extern void _ZN5S59C63v75Ev();
extern void _ZN5S59C63v76Ev();
extern void _ZN5S59C63v77Ev();
extern void _ZN5S59C63v78Ev();
extern void _ZN5S59C63v79Ev();
extern void _ZN5S59C63v80Ev();
extern void _ZN5S59C63v81Ev();
extern void _ZN5S59C63v82Ev();
extern void _ZN5S59C63v83Ev();
extern void _ZN5S59C63v84Ev();
extern void _ZN5S59C63v85Ev();
extern void _ZN5S59C63v86Ev();
extern void _ZN5S59C63v87Ev();
extern void _ZN5S59C63v88Ev();
extern void _ZN5S59C53v89Ev();
extern void _ZN5S59C53v90Ev();
extern void _ZN5S59C53v91Ev();
extern void _ZN5S59C53v92Ev();
extern void _ZN5S59C53v93Ev();
extern void _ZN5S59C53v94Ev();
extern void _ZN5S59C53v95Ev();
extern void _ZN5S59C53v96Ev();
extern void _ZN5S59C53v97Ev();
extern void _ZN5S59C53v98Ev();
extern void _ZN5S59C53v99Ev();
extern void _ZN5S59C54v100Ev();
extern void _ZN5S59C54v101Ev();
extern void _ZN5S59C54v102Ev();
extern void _ZN5S59C54v103Ev();
extern void _ZN5S59C54v104Ev();
extern void _ZN5S59C54v105Ev();
extern void _ZN5S59C54v106Ev();
extern void _ZN5S59C54v107Ev();
extern void _ZN5S59C54v108Ev();
extern void _ZN5S59C44v109Ev();
extern void _ZN5S59C44v110Ev();
extern void _ZN5S59C44v111Ev();
extern void _ZN5S59C44v112Ev();
extern void _ZN5S59C44v113Ev();
extern void _ZN5S59C44v114Ev();
extern void _ZN5S59C44v115Ev();
extern void _ZN5S59C44v116Ev();
extern void _ZN5S59C44v117Ev();
extern void _ZN5S59C44v118Ev();
extern void _ZN5S59C44v119Ev();
extern void _ZN5S59C44v120Ev();
extern void _ZN5S59C44v121Ev();
extern void _ZN5S59C44v122Ev();
extern void _ZN5S59C34v123Ev();
extern void _ZN5S59C34v124Ev();
extern void _ZN5S59C34v125Ev();
extern void _ZN5S59C34v126Ev();
extern void _ZN5S59C34v127Ev();
extern void _ZN5S59C34v128Ev();
extern void _ZN5S59C34v129Ev();
extern void _ZN5S59C34v130Ev();
extern void _ZN5S59C34v131Ev();
extern void _ZN5S59C34v132Ev();
extern void _ZN5S59C34v133Ev();
extern void _ZN5S59C24v134Ev();
extern void _ZN5S59C24v135Ev();
static  VTBL_ENTRY vtc_S59C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S59C2[0]),
  (VTBL_ENTRY)&_ZN5S59C2D1Ev,
  (VTBL_ENTRY)&_ZN5S59C2D0Ev,
  (VTBL_ENTRY)&_ZN5S59C72v3Ev,
  (VTBL_ENTRY)&_ZN5S59C72v4Ev,
  (VTBL_ENTRY)&_ZN5S59C72v5Ev,
  (VTBL_ENTRY)&_ZN5S59C72v6Ev,
  (VTBL_ENTRY)&_ZN5S59C72v7Ev,
  (VTBL_ENTRY)&_ZN5S59C72v8Ev,
  (VTBL_ENTRY)&_ZN5S59C72v9Ev,
  (VTBL_ENTRY)&_ZN5S59C73v10Ev,
  (VTBL_ENTRY)&_ZN5S59C73v11Ev,
  (VTBL_ENTRY)&_ZN5S59C73v12Ev,
  (VTBL_ENTRY)&_ZN5S59C73v13Ev,
  (VTBL_ENTRY)&_ZN5S59C73v14Ev,
  (VTBL_ENTRY)&_ZN5S59C73v15Ev,
  (VTBL_ENTRY)&_ZN5S59C73v16Ev,
  (VTBL_ENTRY)&_ZN5S59C73v17Ev,
  (VTBL_ENTRY)&_ZN5S59C73v18Ev,
  (VTBL_ENTRY)&_ZN5S59C73v19Ev,
  (VTBL_ENTRY)&_ZN5S59C73v20Ev,
  (VTBL_ENTRY)&_ZN5S59C73v21Ev,
  (VTBL_ENTRY)&_ZN5S59C73v22Ev,
  (VTBL_ENTRY)&_ZN5S59C73v23Ev,
  (VTBL_ENTRY)&_ZN5S59C73v24Ev,
  (VTBL_ENTRY)&_ZN5S59C73v25Ev,
  (VTBL_ENTRY)&_ZN5S59C73v26Ev,
  (VTBL_ENTRY)&_ZN5S59C73v27Ev,
  (VTBL_ENTRY)&_ZN5S59C73v28Ev,
  (VTBL_ENTRY)&_ZN5S59C73v29Ev,
  (VTBL_ENTRY)&_ZN5S59C73v30Ev,
  (VTBL_ENTRY)&_ZN5S59C73v31Ev,
  (VTBL_ENTRY)&_ZN5S59C73v32Ev,
  (VTBL_ENTRY)&_ZN5S59C73v33Ev,
  (VTBL_ENTRY)&_ZN5S59C73v34Ev,
  (VTBL_ENTRY)&_ZN5S59C73v35Ev,
  (VTBL_ENTRY)&_ZN5S59C73v36Ev,
  (VTBL_ENTRY)&_ZN5S59C73v37Ev,
  (VTBL_ENTRY)&_ZN5S59C73v38Ev,
  (VTBL_ENTRY)&_ZN5S59C73v39Ev,
  (VTBL_ENTRY)&_ZN5S59C73v40Ev,
  (VTBL_ENTRY)&_ZN5S59C73v41Ev,
  (VTBL_ENTRY)&_ZN5S59C73v42Ev,
  (VTBL_ENTRY)&_ZN5S59C73v43Ev,
  (VTBL_ENTRY)&_ZN5S59C73v44Ev,
  (VTBL_ENTRY)&_ZN5S59C73v45Ev,
  (VTBL_ENTRY)&_ZN5S59C73v46Ev,
  (VTBL_ENTRY)&_ZN5S59C73v47Ev,
  (VTBL_ENTRY)&_ZN5S59C73v48Ev,
  (VTBL_ENTRY)&_ZN5S59C73v49Ev,
  (VTBL_ENTRY)&_ZN5S59C73v50Ev,
  (VTBL_ENTRY)&_ZN5S59C73v51Ev,
  (VTBL_ENTRY)&_ZN5S59C73v52Ev,
  (VTBL_ENTRY)&_ZN5S59C73v53Ev,
  (VTBL_ENTRY)&_ZN5S59C73v54Ev,
  (VTBL_ENTRY)&_ZN5S59C73v55Ev,
  (VTBL_ENTRY)&_ZN5S59C73v56Ev,
  (VTBL_ENTRY)&_ZN5S59C73v57Ev,
  (VTBL_ENTRY)&_ZN5S59C73v58Ev,
  (VTBL_ENTRY)&_ZN5S59C73v59Ev,
  (VTBL_ENTRY)&_ZN5S59C73v60Ev,
  (VTBL_ENTRY)&_ZN5S59C73v61Ev,
  (VTBL_ENTRY)&_ZN5S59C73v62Ev,
  (VTBL_ENTRY)&_ZN5S59C73v63Ev,
  (VTBL_ENTRY)&_ZN5S59C73v64Ev,
  (VTBL_ENTRY)&_ZN5S59C73v65Ev,
  (VTBL_ENTRY)&_ZN5S59C73v66Ev,
  (VTBL_ENTRY)&_ZN5S59C63v67Ev,
  (VTBL_ENTRY)&_ZN5S59C63v68Ev,
  (VTBL_ENTRY)&_ZN5S59C63v69Ev,
  (VTBL_ENTRY)&_ZN5S59C63v70Ev,
  (VTBL_ENTRY)&_ZN5S59C63v71Ev,
  (VTBL_ENTRY)&_ZN5S59C63v72Ev,
  (VTBL_ENTRY)&_ZN5S59C63v73Ev,
  (VTBL_ENTRY)&_ZN5S59C63v74Ev,
  (VTBL_ENTRY)&_ZN5S59C63v75Ev,
  (VTBL_ENTRY)&_ZN5S59C63v76Ev,
  (VTBL_ENTRY)&_ZN5S59C63v77Ev,
  (VTBL_ENTRY)&_ZN5S59C63v78Ev,
  (VTBL_ENTRY)&_ZN5S59C63v79Ev,
  (VTBL_ENTRY)&_ZN5S59C63v80Ev,
  (VTBL_ENTRY)&_ZN5S59C63v81Ev,
  (VTBL_ENTRY)&_ZN5S59C63v82Ev,
  (VTBL_ENTRY)&_ZN5S59C63v83Ev,
  (VTBL_ENTRY)&_ZN5S59C63v84Ev,
  (VTBL_ENTRY)&_ZN5S59C63v85Ev,
  (VTBL_ENTRY)&_ZN5S59C63v86Ev,
  (VTBL_ENTRY)&_ZN5S59C63v87Ev,
  (VTBL_ENTRY)&_ZN5S59C63v88Ev,
  (VTBL_ENTRY)&_ZN5S59C53v89Ev,
  (VTBL_ENTRY)&_ZN5S59C53v90Ev,
  (VTBL_ENTRY)&_ZN5S59C53v91Ev,
  (VTBL_ENTRY)&_ZN5S59C53v92Ev,
  (VTBL_ENTRY)&_ZN5S59C53v93Ev,
  (VTBL_ENTRY)&_ZN5S59C53v94Ev,
  (VTBL_ENTRY)&_ZN5S59C53v95Ev,
  (VTBL_ENTRY)&_ZN5S59C53v96Ev,
  (VTBL_ENTRY)&_ZN5S59C53v97Ev,
  (VTBL_ENTRY)&_ZN5S59C53v98Ev,
  (VTBL_ENTRY)&_ZN5S59C53v99Ev,
  (VTBL_ENTRY)&_ZN5S59C54v100Ev,
  (VTBL_ENTRY)&_ZN5S59C54v101Ev,
  (VTBL_ENTRY)&_ZN5S59C54v102Ev,
  (VTBL_ENTRY)&_ZN5S59C54v103Ev,
  (VTBL_ENTRY)&_ZN5S59C54v104Ev,
  (VTBL_ENTRY)&_ZN5S59C54v105Ev,
  (VTBL_ENTRY)&_ZN5S59C54v106Ev,
 