// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S3443C4_nt  {
  int s3443c4f0[2];
  void  mf3443c4(); // _ZN10S3443C4_nt8mf3443c4Ev
};
//SIG(-1 S3443C4_nt) C1{ m Fi[2]}


void  S3443C4_nt ::mf3443c4(){}

//skip512 S3443C4_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3443C3_nt  {
  int s3443c3f0;
  __tsi64 s3443c3f1;
  void *s3443c3f2[4];
  int s3443c3f3[2];
  void *s3443c3f4;
  ::S3443C4_nt s3443c3f5;
  void *s3443c3f6[2];
  virtual  ~S3443C3_nt(); // _ZN10S3443C3_ntD1Ev
  virtual void  v9(); // _ZN10S3443C3_nt2v9Ev
  virtual void  v10(); // _ZN10S3443C3_nt3v10Ev
  virtual void  v11(); // _ZN10S3443C3_nt3v11Ev
  virtual void  v12(); // _ZN10S3443C3_nt3v12Ev
  virtual void  v13(); // _ZN10S3443C3_nt3v13Ev
  virtual void  v14(); // _ZN10S3443C3_nt3v14Ev
  virtual void  v15(); // _ZN10S3443C3_nt3v15Ev
  virtual void  v16(); // _ZN10S3443C3_nt3v16Ev
  virtual void  v17(); // _ZN10S3443C3_nt3v17Ev
  virtual void  v18(); // _ZN10S3443C3_nt3v18Ev
  virtual void  v19(); // _ZN10S3443C3_nt3v19Ev
  virtual void  v20(); // _ZN10S3443C3_nt3v20Ev
  virtual void  v21(); // _ZN10S3443C3_nt3v21Ev
  virtual void  v22(); // _ZN10S3443C3_nt3v22Ev
  virtual void  v23(); // _ZN10S3443C3_nt3v23Ev
  virtual void  v24(); // _ZN10S3443C3_nt3v24Ev
  virtual void  v25(); // _ZN10S3443C3_nt3v25Ev
  virtual void  v26(); // _ZN10S3443C3_nt3v26Ev
  virtual void  v27(); // _ZN10S3443C3_nt3v27Ev
  virtual void  v28(); // _ZN10S3443C3_nt3v28Ev
  virtual void  v29(); // _ZN10S3443C3_nt3v29Ev
  virtual void  v30(); // _ZN10S3443C3_nt3v30Ev
  virtual void  v31(); // _ZN10S3443C3_nt3v31Ev
  virtual void  v32(); // _ZN10S3443C3_nt3v32Ev
  virtual void  v33(); // _ZN10S3443C3_nt3v33Ev
  virtual void  v34(); // _ZN10S3443C3_nt3v34Ev
  virtual void  v35(); // _ZN10S3443C3_nt3v35Ev
  virtual void  v36(); // _ZN10S3443C3_nt3v36Ev
  virtual void  v37(); // _ZN10S3443C3_nt3v37Ev
  virtual void  v38(); // _ZN10S3443C3_nt3v38Ev
  virtual void  v39(); // _ZN10S3443C3_nt3v39Ev
  virtual void  v40(); // _ZN10S3443C3_nt3v40Ev
  virtual void  v41(); // _ZN10S3443C3_nt3v41Ev
  virtual void  v42(); // _ZN10S3443C3_nt3v42Ev
  virtual void  v43(); // _ZN10S3443C3_nt3v43Ev
  virtual void  v44(); // _ZN10S3443C3_nt3v44Ev
  virtual void  v45(); // _ZN10S3443C3_nt3v45Ev
  virtual void  v46(); // _ZN10S3443C3_nt3v46Ev
  virtual void  v47(); // _ZN10S3443C3_nt3v47Ev
  virtual void  v48(); // _ZN10S3443C3_nt3v48Ev
  virtual void  v49(); // _ZN10S3443C3_nt3v49Ev
  virtual void  v50(); // _ZN10S3443C3_nt3v50Ev
  virtual void  v51(); // _ZN10S3443C3_nt3v51Ev
  virtual void  v52(); // _ZN10S3443C3_nt3v52Ev
  virtual void  v53(); // _ZN10S3443C3_nt3v53Ev
  virtual void  v54(); // _ZN10S3443C3_nt3v54Ev
  virtual void  v55(); // _ZN10S3443C3_nt3v55Ev
  virtual void  v56(); // _ZN10S3443C3_nt3v56Ev
  virtual void  v57(); // _ZN10S3443C3_nt3v57Ev
  virtual void  v58(); // _ZN10S3443C3_nt3v58Ev
  virtual void  v59(); // _ZN10S3443C3_nt3v59Ev
  virtual void  v60(); // _ZN10S3443C3_nt3v60Ev
  virtual void  v61(); // _ZN10S3443C3_nt3v61Ev
  virtual void  v62(); // _ZN10S3443C3_nt3v62Ev
  virtual void  v63(); // _ZN10S3443C3_nt3v63Ev
  virtual void  v64(); // _ZN10S3443C3_nt3v64Ev
  virtual void  v65(); // _ZN10S3443C3_nt3v65Ev
  virtual void  v66(); // _ZN10S3443C3_nt3v66Ev
  virtual void  v67(); // _ZN10S3443C3_nt3v67Ev
  virtual void  v68(); // _ZN10S3443C3_nt3v68Ev
  virtual void  v69(); // _ZN10S3443C3_nt3v69Ev
  virtual void  v70(); // _ZN10S3443C3_nt3v70Ev
  virtual void  v71(); // _ZN10S3443C3_nt3v71Ev
  virtual void  v72(); // _ZN10S3443C3_nt3v72Ev
  S3443C3_nt(); // tgen
};
//SIG(-1 S3443C3_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S3443C3_nt ::~S3443C3_nt(){ note_dtor("S3443C3_nt", this);}
void  S3443C3_nt ::v9(){vfunc_called(this, "_ZN10S3443C3_nt2v9Ev");}
void  S3443C3_nt ::v10(){vfunc_called(this, "_ZN10S3443C3_nt3v10Ev");}
void  S3443C3_nt ::v11(){vfunc_called(this, "_ZN10S3443C3_nt3v11Ev");}
void  S3443C3_nt ::v12(){vfunc_called(this, "_ZN10S3443C3_nt3v12Ev");}
void  S3443C3_nt ::v13(){vfunc_called(this, "_ZN10S3443C3_nt3v13Ev");}
void  S3443C3_nt ::v14(){vfunc_called(this, "_ZN10S3443C3_nt3v14Ev");}
void  S3443C3_nt ::v15(){vfunc_called(this, "_ZN10S3443C3_nt3v15Ev");}
void  S3443C3_nt ::v16(){vfunc_called(this, "_ZN10S3443C3_nt3v16Ev");}
void  S3443C3_nt ::v17(){vfunc_called(this, "_ZN10S3443C3_nt3v17Ev");}
void  S3443C3_nt ::v18(){vfunc_called(this, "_ZN10S3443C3_nt3v18Ev");}
void  S3443C3_nt ::v19(){vfunc_called(this, "_ZN10S3443C3_nt3v19Ev");}
void  S3443C3_nt ::v20(){vfunc_called(this, "_ZN10S3443C3_nt3v20Ev");}
void  S3443C3_nt ::v21(){vfunc_called(this, "_ZN10S3443C3_nt3v21Ev");}
void  S3443C3_nt ::v22(){vfunc_called(this, "_ZN10S3443C3_nt3v22Ev");}
void  S3443C3_nt ::v23(){vfunc_called(this, "_ZN10S3443C3_nt3v23Ev");}
void  S3443C3_nt ::v24(){vfunc_called(this, "_ZN10S3443C3_nt3v24Ev");}
void  S3443C3_nt ::v25(){vfunc_called(this, "_ZN10S3443C3_nt3v25Ev");}
void  S3443C3_nt ::v26(){vfunc_called(this, "_ZN10S3443C3_nt3v26Ev");}
void  S3443C3_nt ::v27(){vfunc_called(this, "_ZN10S3443C3_nt3v27Ev");}
void  S3443C3_nt ::v28(){vfunc_called(this, "_ZN10S3443C3_nt3v28Ev");}
void  S3443C3_nt ::v29(){vfunc_called(this, "_ZN10S3443C3_nt3v29Ev");}
void  S3443C3_nt ::v30(){vfunc_called(this, "_ZN10S3443C3_nt3v30Ev");}
void  S3443C3_nt ::v31(){vfunc_called(this, "_ZN10S3443C3_nt3v31Ev");}
void  S3443C3_nt ::v32(){vfunc_called(this, "_ZN10S3443C3_nt3v32Ev");}
void  S3443C3_nt ::v33(){vfunc_called(this, "_ZN10S3443C3_nt3v33Ev");}
void  S3443C3_nt ::v34(){vfunc_called(this, "_ZN10S3443C3_nt3v34Ev");}
void  S3443C3_nt ::v35(){vfunc_called(this, "_ZN10S3443C3_nt3v35Ev");}
void  S3443C3_nt ::v36(){vfunc_called(this, "_ZN10S3443C3_nt3v36Ev");}
void  S3443C3_nt ::v37(){vfunc_called(this, "_ZN10S3443C3_nt3v37Ev");}
void  S3443C3_nt ::v38(){vfunc_called(this, "_ZN10S3443C3_nt3v38Ev");}
void  S3443C3_nt ::v39(){vfunc_called(this, "_ZN10S3443C3_nt3v39Ev");}
void  S3443C3_nt ::v40(){vfunc_called(this, "_ZN10S3443C3_nt3v40Ev");}
void  S3443C3_nt ::v41(){vfunc_called(this, "_ZN10S3443C3_nt3v41Ev");}
void  S3443C3_nt ::v42(){vfunc_called(this, "_ZN10S3443C3_nt3v42Ev");}
void  S3443C3_nt ::v43(){vfunc_called(this, "_ZN10S3443C3_nt3v43Ev");}
void  S3443C3_nt ::v44(){vfunc_called(this, "_ZN10S3443C3_nt3v44Ev");}
void  S3443C3_nt ::v45(){vfunc_called(this, "_ZN10S3443C3_nt3v45Ev");}
void  S3443C3_nt ::v46(){vfunc_called(this, "_ZN10S3443C3_nt3v46Ev");}
void  S3443C3_nt ::v47(){vfunc_called(this, "_ZN10S3443C3_nt3v47Ev");}
void  S3443C3_nt ::v48(){vfunc_called(this, "_ZN10S3443C3_nt3v48Ev");}
void  S3443C3_nt ::v49(){vfunc_called(this, "_ZN10S3443C3_nt3v49Ev");}
void  S3443C3_nt ::v50(){vfunc_called(this, "_ZN10S3443C3_nt3v50Ev");}
void  S3443C3_nt ::v51(){vfunc_called(this, "_ZN10S3443C3_nt3v51Ev");}
void  S3443C3_nt ::v52(){vfunc_called(this, "_ZN10S3443C3_nt3v52Ev");}
void  S3443C3_nt ::v53(){vfunc_called(this, "_ZN10S3443C3_nt3v53Ev");}
void  S3443C3_nt ::v54(){vfunc_called(this, "_ZN10S3443C3_nt3v54Ev");}
void  S3443C3_nt ::v55(){vfunc_called(this, "_ZN10S3443C3_nt3v55Ev");}
void  S3443C3_nt ::v56(){vfunc_called(this, "_ZN10S3443C3_nt3v56Ev");}
void  S3443C3_nt ::v57(){vfunc_called(this, "_ZN10S3443C3_nt3v57Ev");}
void  S3443C3_nt ::v58(){vfunc_called(this, "_ZN10S3443C3_nt3v58Ev");}
void  S3443C3_nt ::v59(){vfunc_called(this, "_ZN10S3443C3_nt3v59Ev");}
void  S3443C3_nt ::v60(){vfunc_called(this, "_ZN10S3443C3_nt3v60Ev");}
void  S3443C3_nt ::v61(){vfunc_called(this, "_ZN10S3443C3_nt3v61Ev");}
void  S3443C3_nt ::v62(){vfunc_called(this, "_ZN10S3443C3_nt3v62Ev");}
void  S3443C3_nt ::v63(){vfunc_called(this, "_ZN10S3443C3_nt3v63Ev");}
void  S3443C3_nt ::v64(){vfunc_called(this, "_ZN10S3443C3_nt3v64Ev");}
void  S3443C3_nt ::v65(){vfunc_called(this, "_ZN10S3443C3_nt3v65Ev");}
void  S3443C3_nt ::v66(){vfunc_called(this, "_ZN10S3443C3_nt3v66Ev");}
void  S3443C3_nt ::v67(){vfunc_called(this, "_ZN10S3443C3_nt3v67Ev");}
void  S3443C3_nt ::v68(){vfunc_called(this, "_ZN10S3443C3_nt3v68Ev");}
void  S3443C3_nt ::v69(){vfunc_called(this, "_ZN10S3443C3_nt3v69Ev");}
void  S3443C3_nt ::v70(){vfunc_called(this, "_ZN10S3443C3_nt3v70Ev");}
void  S3443C3_nt ::v71(){vfunc_called(this, "_ZN10S3443C3_nt3v71Ev");}
void  S3443C3_nt ::v72(){vfunc_called(this, "_ZN10S3443C3_nt3v72Ev");}
S3443C3_nt ::S3443C3_nt(){ note_ctor("S3443C3_nt", this);} // tgen

//skip512 S3443C3_nt

#else // __cplusplus

extern void _ZN10S3443C3_ntC1Ev();
extern void _ZN10S3443C3_ntD1Ev();
Name_Map name_map_S3443C3_nt[] = {
  NSPAIR(_ZN10S3443C3_ntC1Ev),
  NSPAIR(_ZN10S3443C3_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S3443C3_nt[];
extern void _ZN10S3443C3_ntD1Ev();
extern void _ZN10S3443C3_ntD0Ev();
extern void _ZN10S3443C3_nt2v9Ev();
extern void _ZN10S3443C3_nt3v10Ev();
extern void _ZN10S3443C3_nt3v11Ev();
extern void _ZN10S3443C3_nt3v12Ev();
extern void _ZN10S3443C3_nt3v13Ev();
extern void _ZN10S3443C3_nt3v14Ev();
extern void _ZN10S3443C3_nt3v15Ev();
extern void _ZN10S3443C3_nt3v16Ev();
extern void _ZN10S3443C3_nt3v17Ev();
extern void _ZN10S3443C3_nt3v18Ev();
extern void _ZN10S3443C3_nt3v19Ev();
extern void _ZN10S3443C3_nt3v20Ev();
extern void _ZN10S3443C3_nt3v21Ev();
extern void _ZN10S3443C3_nt3v22Ev();
extern void _ZN10S3443C3_nt3v23Ev();
extern void _ZN10S3443C3_nt3v24Ev();
extern void _ZN10S3443C3_nt3v25Ev();
extern void _ZN10S3443C3_nt3v26Ev();
extern void _ZN10S3443C3_nt3v27Ev();
extern void _ZN10S3443C3_nt3v28Ev();
extern void _ZN10S3443C3_nt3v29Ev();
extern void _ZN10S3443C3_nt3v30Ev();
extern void _ZN10S3443C3_nt3v31Ev();
extern void _ZN10S3443C3_nt3v32Ev();
extern void _ZN10S3443C3_nt3v33Ev();
extern void _ZN10S3443C3_nt3v34Ev();
extern void _ZN10S3443C3_nt3v35Ev();
extern void _ZN10S3443C3_nt3v36Ev();
extern void _ZN10S3443C3_nt3v37Ev();
extern void _ZN10S3443C3_nt3v38Ev();
extern void _ZN10S3443C3_nt3v39Ev();
extern void _ZN10S3443C3_nt3v40Ev();
extern void _ZN10S3443C3_nt3v41Ev();
extern void _ZN10S3443C3_nt3v42Ev();
extern void _ZN10S3443C3_nt3v43Ev();
extern void _ZN10S3443C3_nt3v44Ev();
extern void _ZN10S3443C3_nt3v45Ev();
extern void _ZN10S3443C3_nt3v46Ev();
extern void _ZN10S3443C3_nt3v47Ev();
extern void _ZN10S3443C3_nt3v48Ev();
extern void _ZN10S3443C3_nt3v49Ev();
extern void _ZN10S3443C3_nt3v50Ev();
extern void _ZN10S3443C3_nt3v51Ev();
extern void _ZN10S3443C3_nt3v52Ev();
extern void _ZN10S3443C3_nt3v53Ev();
extern void _ZN10S3443C3_nt3v54Ev();
extern void _ZN10S3443C3_nt3v55Ev();
extern void _ZN10S3443C3_nt3v56Ev();
extern void _ZN10S3443C3_nt3v57Ev();
extern void _ZN10S3443C3_nt3v58Ev();
extern void _ZN10S3443C3_nt3v59Ev();
extern void _ZN10S3443C3_nt3v60Ev();
extern void _ZN10S3443C3_nt3v61Ev();
extern void _ZN10S3443C3_nt3v62Ev();
extern void _ZN10S3443C3_nt3v63Ev();
extern void _ZN10S3443C3_nt3v64Ev();
extern void _ZN10S3443C3_nt3v65Ev();
extern void _ZN10S3443C3_nt3v66Ev();
extern void _ZN10S3443C3_nt3v67Ev();
extern void _ZN10S3443C3_nt3v68Ev();
extern void _ZN10S3443C3_nt3v69Ev();
extern void _ZN10S3443C3_nt3v70Ev();
extern void _ZN10S3443C3_nt3v71Ev();
extern void _ZN10S3443C3_nt3v72Ev();
static  VTBL_ENTRY vtc_S3443C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S3443C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S3443C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v72Ev,
};
extern VTBL_ENTRY _ZTI10S3443C3_nt[];
VTBL_ENTRY *P__ZTI10S3443C3_nt = _ZTI10S3443C3_nt; 
extern  VTBL_ENTRY _ZTV10S3443C3_nt[];
Class_Descriptor cd_S3443C3_nt = {  "S3443C3_nt", // class name
  0,0,//no base classes
  &(vtc_S3443C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI10S3443C3_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S3443C3_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3443C7_nt  {
  void *s3443c7f0;
  int s3443c7f1[2];
  void  mf3443c7(); // _ZN10S3443C7_nt8mf3443c7Ev
};
//SIG(-1 S3443C7_nt) C1{ m Fp Fi[2]}


void  S3443C7_nt ::mf3443c7(){}

//skip512 S3443C7_nt

#else // __cplusplus

Class_Descriptor cd_S3443C7_nt = {  "S3443C7_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3443C6_nt  : S3443C7_nt {
};
//SIG(-1 S3443C6_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S3443C6_nt

#else // __cplusplus

extern Class_Descriptor cd_S3443C7_nt;
static Base_Class bases_S3443C6_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3443C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3443C6_nt = {  "S3443C6_nt", // class name
  bases_S3443C6_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3443C5_nt  : S3443C6_nt {
};
//SIG(-1 S3443C5_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S3443C5_nt

#else // __cplusplus

extern Class_Descriptor cd_S3443C7_nt;
extern Class_Descriptor cd_S3443C6_nt;
static Base_Class bases_S3443C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3443C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3443C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3443C8_nt  {
  int s3443c8f0;
  void  mf3443c8(); // _ZN10S3443C8_nt8mf3443c8Ev
};
//SIG(-1 S3443C8_nt) C1{ m Fi}


void  S3443C8_nt ::mf3443c8(){}

//skip512 S3443C8_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S3443C8_nt[];
VTBL_ENTRY *P__ZTI10S3443C8_nt = _ZTI10S3443C8_nt; 
Class_Descriptor cd_S3443C8_nt = {  "S3443C8_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI10S3443C8_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3443C12  : S3443C7_nt {
};
//SIG(-1 S3443C12) C1{ BC2{ m Fp Fi[2]}}



static void Test_S3443C12()
{
  extern Class_Descriptor cd_S3443C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3443C12, buf);
    S3443C12 &lv = *(new (buf) S3443C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3443C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3443C12)");
    check_base_class_offset(lv, (S3443C7_nt*), 0, "S3443C12");
    test_class_info(&lv, &cd_S3443C12);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3443C12(Test_S3443C12, "S3443C12", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3443C7_nt;
static Base_Class bases_S3443C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3443C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3443C12 = {  "S3443C12", // class name
  bases_S3443C12, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3443C11  : S3443C12 {
};
//SIG(-1 S3443C11) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S3443C11()
{
  extern Class_Descriptor cd_S3443C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3443C11, buf);
    S3443C11 &lv = *(new (buf) S3443C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3443C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3443C11)");
    check_base_class_offset(lv, (S3443C7_nt*)(S3443C12*), 0, "S3443C11");
    check_base_class_offset(lv, (S3443C12*), 0, "S3443C11");
    test_class_info(&lv, &cd_S3443C11);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3443C11(Test_S3443C11, "S3443C11", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3443C7_nt;
extern Class_Descriptor cd_S3443C12;
static Base_Class bases_S3443C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3443C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3443C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3443C11 = {  "S3443C11", // class name
  bases_S3443C11, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3443C13_nt  {
  int s3443c13f0[3];
  void  mf3443c13(); // _ZN11S3443C13_nt9mf3443c13Ev
};
//SIG(-1 S3443C13_nt) C1{ m Fi[3]}


void  S3443C13_nt ::mf3443c13(){}

//skip512 S3443C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3443C18  : S3443C7_nt {
};
//SIG(-1 S3443C18) C1{ BC2{ m Fp Fi[2]}}



static void Test_S3443C18()
{
  extern Class_Descriptor cd_S3443C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3443C18, buf);
    S3443C18 &lv = *(new (buf) S3443C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3443C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3443C18)");
    check_base_class_offset(lv, (S3443C7_nt*), 0, "S3443C18");
    test_class_info(&lv, &cd_S3443C18);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3443C18(Test_S3443C18, "S3443C18", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3443C7_nt;
static Base_Class bases_S3443C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3443C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3443C18 = {  "S3443C18", // class name
  bases_S3443C18, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3443C17  : S3443C18 {
};
//SIG(-1 S3443C17) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S3443C17()
{
  extern Class_Descriptor cd_S3443C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3443C17, buf);
    S3443C17 &lv = *(new (buf) S3443C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3443C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3443C17)");
    check_base_class_offset(lv, (S3443C7_nt*)(S3443C18*), 0, "S3443C17");
    check_base_class_offset(lv, (S3443C18*), 0, "S3443C17");
    test_class_info(&lv, &cd_S3443C17);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3443C17(Test_S3443C17, "S3443C17", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3443C7_nt;
extern Class_Descriptor cd_S3443C18;
static Base_Class bases_S3443C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3443C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3443C18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3443C17 = {  "S3443C17", // class name
  bases_S3443C17, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3443C2_nt  : S3443C3_nt {
  ::S3443C5_nt s3443c2f0;
  ::S3443C5_nt s3443c2f1;
  ::S3443C8_nt s3443c2f2;
  int s3443c2f3;
  char s3443c2f4[4];
  void *s3443c2f5[2];
  ::S3443C5_nt s3443c2f6;
  unsigned int s3443c2f7:1;
  unsigned int s3443c2f8:1;
  unsigned int s3443c2f9:1;
  unsigned int s3443c2f10:1;
  unsigned int s3443c2f11:1;
  unsigned int s3443c2f12:1;
  unsigned int s3443c2f13:1;
  unsigned int s3443c2f14:1;
  unsigned int s3443c2f15:1;
  unsigned int s3443c2f16:1;
  unsigned int s3443c2f17:1;
  unsigned int s3443c2f18:1;
  unsigned int s3443c2f19:1;
  unsigned int s3443c2f20:1;
  unsigned int s3443c2f21:1;
  unsigned int s3443c2f22:1;
  unsigned int s3443c2f23:1;
  unsigned int s3443c2f24:1;
  unsigned int s3443c2f25:1;
  unsigned int s3443c2f26:1;
  unsigned int s3443c2f27:1;
  unsigned int s3443c2f28:1;
  unsigned int s3443c2f29:1;
  unsigned int s3443c2f30:1;
  unsigned int s3443c2f31:1;
  unsigned int s3443c2f32:1;
  unsigned int s3443c2f33:1;
  unsigned int s3443c2f34:1;
  unsigned int s3443c2f35:1;
  unsigned int s3443c2f36:1;
  unsigned int s3443c2f37:1;
  unsigned int s3443c2f38:1;
  unsigned int s3443c2f39:1;
  unsigned int s3443c2f40:1;
  unsigned int s3443c2f41:1;
  unsigned int s3443c2f42:1;
  unsigned int s3443c2f43:1;
  unsigned int s3443c2f44:1;
  unsigned int s3443c2f45:1;
  unsigned int s3443c2f46:1;
  unsigned int s3443c2f47:1;
  unsigned int s3443c2f48:1;
  unsigned int s3443c2f49:1;
  unsigned int s3443c2f50:1;
  unsigned int s3443c2f51:1;
  unsigned int s3443c2f52:1;
  unsigned int s3443c2f53:1;
  unsigned int s3443c2f54:1;
  unsigned int s3443c2f55:1;
  unsigned int s3443c2f56:1;
  unsigned int s3443c2f57:1;
  unsigned int s3443c2f58:1;
  unsigned int s3443c2f59:1;
  unsigned int s3443c2f60:1;
  unsigned int s3443c2f61:1;
  unsigned int s3443c2f62:1;
  unsigned int s3443c2f63:1;
  unsigned int s3443c2f64:1;
  unsigned int s3443c2f65:1;
  unsigned int s3443c2f66:1;
  unsigned int s3443c2f67:1;
  unsigned int s3443c2f68:1;
  unsigned int s3443c2f69:1;
  unsigned int s3443c2f70:1;
  unsigned int s3443c2f71:1;
  unsigned int s3443c2f72:1;
  unsigned int s3443c2f73:1;
  unsigned int s3443c2f74:1;
  unsigned int s3443c2f75:1;
  unsigned int s3443c2f76:1;
  unsigned int s3443c2f77:1;
  unsigned int s3443c2f78:1;
  unsigned int s3443c2f79:1;
  unsigned int s3443c2f80:1;
  unsigned int s3443c2f81:1;
  unsigned int s3443c2f82:1;
  unsigned int s3443c2f83:1;
  int s3443c2f84[5];
  void *s3443c2f85[2];
  int s3443c2f86[3];
  ::S3443C4_nt s3443c2f87;
  ::S3443C4_nt s3443c2f88;
  ::S3443C4_nt s3443c2f89;
  ::S3443C11 s3443c2f90;
  ::S3443C11 s3443c2f91;
  int s3443c2f92;
  void *s3443c2f93[2];
  ::S3443C13_nt s3443c2f94;
  ::S3443C13_nt s3443c2f95;
  ::S3443C13_nt s3443c2f96;
  ::S3443C13_nt s3443c2f97;
  void *s3443c2f98;
  ::S3443C4_nt s3443c2f99;
  ::S3443C11 s3443c2f100;
  ::S3443C13_nt s3443c2f101;
  ::S3443C13_nt s3443c2f102;
  int s3443c2f103;
  ::S3443C13_nt s3443c2f104;
  ::S3443C13_nt s3443c2f105;
  void *s3443c2f106;
  int s3443c2f107;
  char s3443c2f108;
  ::S3443C13_nt s3443c2f109;
  ::S3443C13_nt s3443c2f110;
  void *s3443c2f111;
  int s3443c2f112;
  void *s3443c2f113;
  ::S3443C11 s3443c2f114;
  ::S3443C17 s3443c2f115;
  ::S3443C17 s3443c2f116;
  virtual  ~S3443C2_nt(); // _ZN10S3443C2_ntD1Ev
  virtual void  v73(); // _ZN10S3443C2_nt3v73Ev
  virtual void  v74(); // _ZN10S3443C2_nt3v74Ev
  virtual void  v75(); // _ZN10S3443C2_nt3v75Ev
  virtual void  v76(); // _ZN10S3443C2_nt3v76Ev
  virtual void  v77(); // _ZN10S3443C2_nt3v77Ev
  virtual void  v78(); // _ZN10S3443C2_nt3v78Ev
  virtual void  v79(); // _ZN10S3443C2_nt3v79Ev
  virtual void  v80(); // _ZN10S3443C2_nt3v80Ev
  virtual void  v81(); // _ZN10S3443C2_nt3v81Ev
  virtual void  v82(); // _ZN10S3443C2_nt3v82Ev
  virtual void  v83(); // _ZN10S3443C2_nt3v83Ev
  virtual void  v84(); // _ZN10S3443C2_nt3v84Ev
  virtual void  v85(); // _ZN10S3443C2_nt3v85Ev
  virtual void  v86(); // _ZN10S3443C2_nt3v86Ev
  virtual void  v87(); // _ZN10S3443C2_nt3v87Ev
  virtual void  v88(); // _ZN10S3443C2_nt3v88Ev
  virtual void  v89(); // _ZN10S3443C2_nt3v89Ev
  virtual void  v90(); // _ZN10S3443C2_nt3v90Ev
  virtual void  v91(); // _ZN10S3443C2_nt3v91Ev
  virtual void  v92(); // _ZN10S3443C2_nt3v92Ev
  virtual void  v93(); // _ZN10S3443C2_nt3v93Ev
  virtual void  v94(); // _ZN10S3443C2_nt3v94Ev
  virtual void  v95(); // _ZN10S3443C2_nt3v95Ev
  virtual void  v96(); // _ZN10S3443C2_nt3v96Ev
  virtual void  v97(); // _ZN10S3443C2_nt3v97Ev
  virtual void  v98(); // _ZN10S3443C2_nt3v98Ev
  virtual void  v99(); // _ZN10S3443C2_nt3v99Ev
  virtual void  v100(); // _ZN10S3443C2_nt4v100Ev
  virtual void  v101(); // _ZN10S3443C2_nt4v101Ev
  virtual void  v102(); // _ZN10S3443C2_nt4v102Ev
  virtual void  v103(); // _ZN10S3443C2_nt4v103Ev
  virtual void  v104(); // _ZN10S3443C2_nt4v104Ev
  virtual void  v105(); // _ZN10S3443C2_nt4v105Ev
  virtual void  v106(); // _ZN10S3443C2_nt4v106Ev
  virtual void  v107(); // _ZN10S3443C2_nt4v107Ev
  virtual void  v108(); // _ZN10S3443C2_nt4v108Ev
  virtual void  v109(); // _ZN10S3443C2_nt4v109Ev
  virtual void  v110(); // _ZN10S3443C2_nt4v110Ev
  virtual void  v111(); // _ZN10S3443C2_nt4v111Ev
  virtual void  v112(); // _ZN10S3443C2_nt4v112Ev
  virtual void  v113(); // _ZN10S3443C2_nt4v113Ev
  virtual void  v114(); // _ZN10S3443C2_nt4v114Ev
  virtual void  v115(); // _ZN10S3443C2_nt4v115Ev
  virtual void  v116(); // _ZN10S3443C2_nt4v116Ev
  virtual void  v117(); // _ZN10S3443C2_nt4v117Ev
  virtual void  v118(); // _ZN10S3443C2_nt4v118Ev
  virtual void  v119(); // _ZN10S3443C2_nt4v119Ev
  virtual void  v120(); // _ZN10S3443C2_nt4v120Ev
  virtual void  v121(); // _ZN10S3443C2_nt4v121Ev
  virtual void  v122(); // _ZN10S3443C2_nt4v122Ev
  virtual void  v123(); // _ZN10S3443C2_nt4v123Ev
  virtual void  v124(); // _ZN10S3443C2_nt4v124Ev
  virtual void  v125(); // _ZN10S3443C2_nt4v125Ev
  virtual void  v126(); // _ZN10S3443C2_nt4v126Ev
  virtual void  v127(); // _ZN10S3443C2_nt4v127Ev
  virtual void  v128(); // _ZN10S3443C2_nt4v128Ev
  virtual void  v129(); // _ZN10S3443C2_nt4v129Ev
  virtual void  v130(); // _ZN10S3443C2_nt4v130Ev
  virtual void  v131(); // _ZN10S3443C2_nt4v131Ev
  virtual void  v132(); // _ZN10S3443C2_nt4v132Ev
  virtual void  v133(); // _ZN10S3443C2_nt4v133Ev
  virtual void  v134(); // _ZN10S3443C2_nt4v134Ev
  virtual void  v135(); // _ZN10S3443C2_nt4v135Ev
  virtual void  v136(); // _ZN10S3443C2_nt4v136Ev
  virtual void  v137(); // _ZN10S3443C2_nt4v137Ev
  virtual void  v138(); // _ZN10S3443C2_nt4v138Ev
  virtual void  v139(); // _ZN10S3443C2_nt4v139Ev
  virtual void  v140(); // _ZN10S3443C2_nt4v140Ev
  virtual void  v141(); // _ZN10S3443C2_nt4v141Ev
  virtual void  v142(); // _ZN10S3443C2_nt4v142Ev
  virtual void  v143(); // _ZN10S3443C2_nt4v143Ev
  virtual void  v144(); // _ZN10S3443C2_nt4v144Ev
  virtual void  v145(); // _ZN10S3443C2_nt4v145Ev
  virtual void  v146(); // _ZN10S3443C2_nt4v146Ev
  virtual void  v147(); // _ZN10S3443C2_nt4v147Ev
  virtual void  v148(); // _ZN10S3443C2_nt4v148Ev
  virtual void  v149(); // _ZN10S3443C2_nt4v149Ev
  virtual void  v150(); // _ZN10S3443C2_nt4v150Ev
  virtual void  v151(); // _ZN10S3443C2_nt4v151Ev
  virtual void  v152(); // _ZN10S3443C2_nt4v152Ev
  virtual void  v153(); // _ZN10S3443C2_nt4v153Ev
  virtual void  v154(); // _ZN10S3443C2_nt4v154Ev
  virtual void  v155(); // _ZN10S3443C2_nt4v155Ev
  virtual void  v156(); // _ZN10S3443C2_nt4v156Ev
  virtual void  v157(); // _ZN10S3443C2_nt4v157Ev
  virtual void  v158(); // _ZN10S3443C2_nt4v158Ev
  virtual void  v159(); // _ZN10S3443C2_nt4v159Ev
  virtual void  v160(); // _ZN10S3443C2_nt4v160Ev
  virtual void  v161(); // _ZN10S3443C2_nt4v161Ev
  virtual void  v162(); // _ZN10S3443C2_nt4v162Ev
  virtual void  v163(); // _ZN10S3443C2_nt4v163Ev
  virtual void  v164(); // _ZN10S3443C2_nt4v164Ev
  virtual void  v165(); // _ZN10S3443C2_nt4v165Ev
  virtual void  v166(); // _ZN10S3443C2_nt4v166Ev
  virtual void  v167(); // _ZN10S3443C2_nt4v167Ev
  virtual void  v168(); // _ZN10S3443C2_nt4v168Ev
  virtual void  v169(); // _ZN10S3443C2_nt4v169Ev
  virtual void  v170(); // _ZN10S3443C2_nt4v170Ev
  virtual void  v171(); // _ZN10S3443C2_nt4v171Ev
  virtual void  v172(); // _ZN10S3443C2_nt4v172Ev
  virtual void  v173(); // _ZN10S3443C2_nt4v173Ev
  virtual void  v174(); // _ZN10S3443C2_nt4v174Ev
  virtual void  v175(); // _ZN10S3443C2_nt4v175Ev
  virtual void  v176(); // _ZN10S3443C2_nt4v176Ev
  virtual void  v177(); // _ZN10S3443C2_nt4v177Ev
  virtual void  v178(); // _ZN10S3443C2_nt4v178Ev
  virtual void  v179(); // _ZN10S3443C2_nt4v179Ev
  virtual void  v180(); // _ZN10S3443C2_nt4v180Ev
  virtual void  v181(); // _ZN10S3443C2_nt4v181Ev
  virtual void  v182(); // _ZN10S3443C2_nt4v182Ev
  virtual void  v183(); // _ZN10S3443C2_nt4v183Ev
  virtual void  v184(); // _ZN10S3443C2_nt4v184Ev
  virtual void  v185(); // _ZN10S3443C2_nt4v185Ev
  virtual void  v186(); // _ZN10S3443C2_nt4v186Ev
  virtual void  v187(); // _ZN10S3443C2_nt4v187Ev
  virtual void  v188(); // _ZN10S3443C2_nt4v188Ev
  virtual void  v189(); // _ZN10S3443C2_nt4v189Ev
  virtual void  v190(); // _ZN10S3443C2_nt4v190Ev
  virtual void  v191(); // _ZN10S3443C2_nt4v191Ev
  virtual void  v192(); // _ZN10S3443C2_nt4v192Ev
  virtual void  v193(); // _ZN10S3443C2_nt4v193Ev
  virtual void  v194(); // _ZN10S3443C2_nt4v194Ev
  virtual void  v195(); // _ZN10S3443C2_nt4v195Ev
  virtual void  v196(); // _ZN10S3443C2_nt4v196Ev
  virtual void  v197(); // _ZN10S3443C2_nt4v197Ev
  virtual void  v198(); // _ZN10S3443C2_nt4v198Ev
  virtual void  v199(); // _ZN10S3443C2_nt4v199Ev
  virtual void  v200(); // _ZN10S3443C2_nt4v200Ev
  virtual void  v201(); // _ZN10S3443C2_nt4v201Ev
  virtual void  v202(); // _ZN10S3443C2_nt4v202Ev
  virtual void  v203(); // _ZN10S3443C2_nt4v203Ev
  virtual void  v204(); // _ZN10S3443C2_nt4v204Ev
  virtual void  v205(); // _ZN10S3443C2_nt4v205Ev
  virtual void  v206(); // _ZN10S3443C2_nt4v206Ev
  virtual void  v207(); // _ZN10S3443C2_nt4v207Ev
  virtual void  v208(); // _ZN10S3443C2_nt4v208Ev
  virtual void  v209(); // _ZN10S3443C2_nt4v209Ev
  virtual void  v210(); // _ZN10S3443C2_nt4v210Ev
  virtual void  v211(); // _ZN10S3443C2_nt4v211Ev
  virtual void  v212(); // _ZN10S3443C2_nt4v212Ev
  virtual void  v213(); // _ZN10S3443C2_nt4v213Ev
  virtual void  v214(); // _ZN10S3443C2_nt4v214Ev
  virtual void  v215(); // _ZN10S3443C2_nt4v215Ev
  S3443C2_nt(); // tgen
};
//SIG(-1 S3443C2_nt) C1{ BC2{ vd v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 FC4{ BC5{ BC6{ m Fp Fi[2]}}} FC4 FC7{ m Fi} Fi Fc[4] Fp[2] FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC3 FC3 FC3 FC8{ BC9{ BC6}} FC8 Fi Fp[2] FC10{ m Fi[3]} FC10 FC10 FC10 Fp FC3 FC8 FC10 FC10 Fi FC10 FC10 Fp Fi Fc FC10 FC10 Fp Fi Fp FC8 FC11{ BC12{ BC6}} FC11}


 S3443C2_nt ::~S3443C2_nt(){ note_dtor("S3443C2_nt", this);}
void  S3443C2_nt ::v73(){vfunc_called(this, "_ZN10S3443C2_nt3v73Ev");}
void  S3443C2_nt ::v74(){vfunc_called(this, "_ZN10S3443C2_nt3v74Ev");}
void  S3443C2_nt ::v75(){vfunc_called(this, "_ZN10S3443C2_nt3v75Ev");}
void  S3443C2_nt ::v76(){vfunc_called(this, "_ZN10S3443C2_nt3v76Ev");}
void  S3443C2_nt ::v77(){vfunc_called(this, "_ZN10S3443C2_nt3v77Ev");}
void  S3443C2_nt ::v78(){vfunc_called(this, "_ZN10S3443C2_nt3v78Ev");}
void  S3443C2_nt ::v79(){vfunc_called(this, "_ZN10S3443C2_nt3v79Ev");}
void  S3443C2_nt ::v80(){vfunc_called(this, "_ZN10S3443C2_nt3v80Ev");}
void  S3443C2_nt ::v81(){vfunc_called(this, "_ZN10S3443C2_nt3v81Ev");}
void  S3443C2_nt ::v82(){vfunc_called(this, "_ZN10S3443C2_nt3v82Ev");}
void  S3443C2_nt ::v83(){vfunc_called(this, "_ZN10S3443C2_nt3v83Ev");}
void  S3443C2_nt ::v84(){vfunc_called(this, "_ZN10S3443C2_nt3v84Ev");}
void  S3443C2_nt ::v85(){vfunc_called(this, "_ZN10S3443C2_nt3v85Ev");}
void  S3443C2_nt ::v86(){vfunc_called(this, "_ZN10S3443C2_nt3v86Ev");}
void  S3443C2_nt ::v87(){vfunc_called(this, "_ZN10S3443C2_nt3v87Ev");}
void  S3443C2_nt ::v88(){vfunc_called(this, "_ZN10S3443C2_nt3v88Ev");}
void  S3443C2_nt ::v89(){vfunc_called(this, "_ZN10S3443C2_nt3v89Ev");}
void  S3443C2_nt ::v90(){vfunc_called(this, "_ZN10S3443C2_nt3v90Ev");}
void  S3443C2_nt ::v91(){vfunc_called(this, "_ZN10S3443C2_nt3v91Ev");}
void  S3443C2_nt ::v92(){vfunc_called(this, "_ZN10S3443C2_nt3v92Ev");}
void  S3443C2_nt ::v93(){vfunc_called(this, "_ZN10S3443C2_nt3v93Ev");}
void  S3443C2_nt ::v94(){vfunc_called(this, "_ZN10S3443C2_nt3v94Ev");}
void  S3443C2_nt ::v95(){vfunc_called(this, "_ZN10S3443C2_nt3v95Ev");}
void  S3443C2_nt ::v96(){vfunc_called(this, "_ZN10S3443C2_nt3v96Ev");}
void  S3443C2_nt ::v97(){vfunc_called(this, "_ZN10S3443C2_nt3v97Ev");}
void  S3443C2_nt ::v98(){vfunc_called(this, "_ZN10S3443C2_nt3v98Ev");}
void  S3443C2_nt ::v99(){vfunc_called(this, "_ZN10S3443C2_nt3v99Ev");}
void  S3443C2_nt ::v100(){vfunc_called(this, "_ZN10S3443C2_nt4v100Ev");}
void  S3443C2_nt ::v101(){vfunc_called(this, "_ZN10S3443C2_nt4v101Ev");}
void  S3443C2_nt ::v102(){vfunc_called(this, "_ZN10S3443C2_nt4v102Ev");}
void  S3443C2_nt ::v103(){vfunc_called(this, "_ZN10S3443C2_nt4v103Ev");}
void  S3443C2_nt ::v104(){vfunc_called(this, "_ZN10S3443C2_nt4v104Ev");}
void  S3443C2_nt ::v105(){vfunc_called(this, "_ZN10S3443C2_nt4v105Ev");}
void  S3443C2_nt ::v106(){vfunc_called(this, "_ZN10S3443C2_nt4v106Ev");}
void  S3443C2_nt ::v107(){vfunc_called(this, "_ZN10S3443C2_nt4v107Ev");}
void  S3443C2_nt ::v108(){vfunc_called(this, "_ZN10S3443C2_nt4v108Ev");}
void  S3443C2_nt ::v109(){vfunc_called(this, "_ZN10S3443C2_nt4v109Ev");}
void  S3443C2_nt ::v110(){vfunc_called(this, "_ZN10S3443C2_nt4v110Ev");}
void  S3443C2_nt ::v111(){vfunc_called(this, "_ZN10S3443C2_nt4v111Ev");}
void  S3443C2_nt ::v112(){vfunc_called(this, "_ZN10S3443C2_nt4v112Ev");}
void  S3443C2_nt ::v113(){vfunc_called(this, "_ZN10S3443C2_nt4v113Ev");}
void  S3443C2_nt ::v114(){vfunc_called(this, "_ZN10S3443C2_nt4v114Ev");}
void  S3443C2_nt ::v115(){vfunc_called(this, "_ZN10S3443C2_nt4v115Ev");}
void  S3443C2_nt ::v116(){vfunc_called(this, "_ZN10S3443C2_nt4v116Ev");}
void  S3443C2_nt ::v117(){vfunc_called(this, "_ZN10S3443C2_nt4v117Ev");}
void  S3443C2_nt ::v118(){vfunc_called(this, "_ZN10S3443C2_nt4v118Ev");}
void  S3443C2_nt ::v119(){vfunc_called(this, "_ZN10S3443C2_nt4v119Ev");}
void  S3443C2_nt ::v120(){vfunc_called(this, "_ZN10S3443C2_nt4v120Ev");}
void  S3443C2_nt ::v121(){vfunc_called(this, "_ZN10S3443C2_nt4v121Ev");}
void  S3443C2_nt ::v122(){vfunc_called(this, "_ZN10S3443C2_nt4v122Ev");}
void  S3443C2_nt ::v123(){vfunc_called(this, "_ZN10S3443C2_nt4v123Ev");}
void  S3443C2_nt ::v124(){vfunc_called(this, "_ZN10S3443C2_nt4v124Ev");}
void  S3443C2_nt ::v125(){vfunc_called(this, "_ZN10S3443C2_nt4v125Ev");}
void  S3443C2_nt ::v126(){vfunc_called(this, "_ZN10S3443C2_nt4v126Ev");}
void  S3443C2_nt ::v127(){vfunc_called(this, "_ZN10S3443C2_nt4v127Ev");}
void  S3443C2_nt ::v128(){vfunc_called(this, "_ZN10S3443C2_nt4v128Ev");}
void  S3443C2_nt ::v129(){vfunc_called(this, "_ZN10S3443C2_nt4v129Ev");}
void  S3443C2_nt ::v130(){vfunc_called(this, "_ZN10S3443C2_nt4v130Ev");}
void  S3443C2_nt ::v131(){vfunc_called(this, "_ZN10S3443C2_nt4v131Ev");}
void  S3443C2_nt ::v132(){vfunc_called(this, "_ZN10S3443C2_nt4v132Ev");}
void  S3443C2_nt ::v133(){vfunc_called(this, "_ZN10S3443C2_nt4v133Ev");}
void  S3443C2_nt ::v134(){vfunc_called(this, "_ZN10S3443C2_nt4v134Ev");}
void  S3443C2_nt ::v135(){vfunc_called(this, "_ZN10S3443C2_nt4v135Ev");}
void  S3443C2_nt ::v136(){vfunc_called(this, "_ZN10S3443C2_nt4v136Ev");}
void  S3443C2_nt ::v137(){vfunc_called(this, "_ZN10S3443C2_nt4v137Ev");}
void  S3443C2_nt ::v138(){vfunc_called(this, "_ZN10S3443C2_nt4v138Ev");}
void  S3443C2_nt ::v139(){vfunc_called(this, "_ZN10S3443C2_nt4v139Ev");}
void  S3443C2_nt ::v140(){vfunc_called(this, "_ZN10S3443C2_nt4v140Ev");}
void  S3443C2_nt ::v141(){vfunc_called(this, "_ZN10S3443C2_nt4v141Ev");}
void  S3443C2_nt ::v142(){vfunc_called(this, "_ZN10S3443C2_nt4v142Ev");}
void  S3443C2_nt ::v143(){vfunc_called(this, "_ZN10S3443C2_nt4v143Ev");}
void  S3443C2_nt ::v144(){vfunc_called(this, "_ZN10S3443C2_nt4v144Ev");}
void  S3443C2_nt ::v145(){vfunc_called(this, "_ZN10S3443C2_nt4v145Ev");}
void  S3443C2_nt ::v146(){vfunc_called(this, "_ZN10S3443C2_nt4v146Ev");}
void  S3443C2_nt ::v147(){vfunc_called(this, "_ZN10S3443C2_nt4v147Ev");}
void  S3443C2_nt ::v148(){vfunc_called(this, "_ZN10S3443C2_nt4v148Ev");}
void  S3443C2_nt ::v149(){vfunc_called(this, "_ZN10S3443C2_nt4v149Ev");}
void  S3443C2_nt ::v150(){vfunc_called(this, "_ZN10S3443C2_nt4v150Ev");}
void  S3443C2_nt ::v151(){vfunc_called(this, "_ZN10S3443C2_nt4v151Ev");}
void  S3443C2_nt ::v152(){vfunc_called(this, "_ZN10S3443C2_nt4v152Ev");}
void  S3443C2_nt ::v153(){vfunc_called(this, "_ZN10S3443C2_nt4v153Ev");}
void  S3443C2_nt ::v154(){vfunc_called(this, "_ZN10S3443C2_nt4v154Ev");}
void  S3443C2_nt ::v155(){vfunc_called(this, "_ZN10S3443C2_nt4v155Ev");}
void  S3443C2_nt ::v156(){vfunc_called(this, "_ZN10S3443C2_nt4v156Ev");}
void  S3443C2_nt ::v157(){vfunc_called(this, "_ZN10S3443C2_nt4v157Ev");}
void  S3443C2_nt ::v158(){vfunc_called(this, "_ZN10S3443C2_nt4v158Ev");}
void  S3443C2_nt ::v159(){vfunc_called(this, "_ZN10S3443C2_nt4v159Ev");}
void  S3443C2_nt ::v160(){vfunc_called(this, "_ZN10S3443C2_nt4v160Ev");}
void  S3443C2_nt ::v161(){vfunc_called(this, "_ZN10S3443C2_nt4v161Ev");}
void  S3443C2_nt ::v162(){vfunc_called(this, "_ZN10S3443C2_nt4v162Ev");}
void  S3443C2_nt ::v163(){vfunc_called(this, "_ZN10S3443C2_nt4v163Ev");}
void  S3443C2_nt ::v164(){vfunc_called(this, "_ZN10S3443C2_nt4v164Ev");}
void  S3443C2_nt ::v165(){vfunc_called(this, "_ZN10S3443C2_nt4v165Ev");}
void  S3443C2_nt ::v166(){vfunc_called(this, "_ZN10S3443C2_nt4v166Ev");}
void  S3443C2_nt ::v167(){vfunc_called(this, "_ZN10S3443C2_nt4v167Ev");}
void  S3443C2_nt ::v168(){vfunc_called(this, "_ZN10S3443C2_nt4v168Ev");}
void  S3443C2_nt ::v169(){vfunc_called(this, "_ZN10S3443C2_nt4v169Ev");}
void  S3443C2_nt ::v170(){vfunc_called(this, "_ZN10S3443C2_nt4v170Ev");}
void  S3443C2_nt ::v171(){vfunc_called(this, "_ZN10S3443C2_nt4v171Ev");}
void  S3443C2_nt ::v172(){vfunc_called(this, "_ZN10S3443C2_nt4v172Ev");}
void  S3443C2_nt ::v173(){vfunc_called(this, "_ZN10S3443C2_nt4v173Ev");}
void  S3443C2_nt ::v174(){vfunc_called(this, "_ZN10S3443C2_nt4v174Ev");}
void  S3443C2_nt ::v175(){vfunc_called(this, "_ZN10S3443C2_nt4v175Ev");}
void  S3443C2_nt ::v176(){vfunc_called(this, "_ZN10S3443C2_nt4v176Ev");}
void  S3443C2_nt ::v177(){vfunc_called(this, "_ZN10S3443C2_nt4v177Ev");}
void  S3443C2_nt ::v178(){vfunc_called(this, "_ZN10S3443C2_nt4v178Ev");}
void  S3443C2_nt ::v179(){vfunc_called(this, "_ZN10S3443C2_nt4v179Ev");}
void  S3443C2_nt ::v180(){vfunc_called(this, "_ZN10S3443C2_nt4v180Ev");}
void  S3443C2_nt ::v181(){vfunc_called(this, "_ZN10S3443C2_nt4v181Ev");}
void  S3443C2_nt ::v182(){vfunc_called(this, "_ZN10S3443C2_nt4v182Ev");}
void  S3443C2_nt ::v183(){vfunc_called(this, "_ZN10S3443C2_nt4v183Ev");}
void  S3443C2_nt ::v184(){vfunc_called(this, "_ZN10S3443C2_nt4v184Ev");}
void  S3443C2_nt ::v185(){vfunc_called(this, "_ZN10S3443C2_nt4v185Ev");}
void  S3443C2_nt ::v186(){vfunc_called(this, "_ZN10S3443C2_nt4v186Ev");}
void  S3443C2_nt ::v187(){vfunc_called(this, "_ZN10S3443C2_nt4v187Ev");}
void  S3443C2_nt ::v188(){vfunc_called(this, "_ZN10S3443C2_nt4v188Ev");}
void  S3443C2_nt ::v189(){vfunc_called(this, "_ZN10S3443C2_nt4v189Ev");}
void  S3443C2_nt ::v190(){vfunc_called(this, "_ZN10S3443C2_nt4v190Ev");}
void  S3443C2_nt ::v191(){vfunc_called(this, "_ZN10S3443C2_nt4v191Ev");}
void  S3443C2_nt ::v192(){vfunc_called(this, "_ZN10S3443C2_nt4v192Ev");}
void  S3443C2_nt ::v193(){vfunc_called(this, "_ZN10S3443C2_nt4v193Ev");}
void  S3443C2_nt ::v194(){vfunc_called(this, "_ZN10S3443C2_nt4v194Ev");}
void  S3443C2_nt ::v195(){vfunc_called(this, "_ZN10S3443C2_nt4v195Ev");}
void  S3443C2_nt ::v196(){vfunc_called(this, "_ZN10S3443C2_nt4v196Ev");}
void  S3443C2_nt ::v197(){vfunc_called(this, "_ZN10S3443C2_nt4v197Ev");}
void  S3443C2_nt ::v198(){vfunc_called(this, "_ZN10S3443C2_nt4v198Ev");}
void  S3443C2_nt ::v199(){vfunc_called(this, "_ZN10S3443C2_nt4v199Ev");}
void  S3443C2_nt ::v200(){vfunc_called(this, "_ZN10S3443C2_nt4v200Ev");}
void  S3443C2_nt ::v201(){vfunc_called(this, "_ZN10S3443C2_nt4v201Ev");}
void  S3443C2_nt ::v202(){vfunc_called(this, "_ZN10S3443C2_nt4v202Ev");}
void  S3443C2_nt ::v203(){vfunc_called(this, "_ZN10S3443C2_nt4v203Ev");}
void  S3443C2_nt ::v204(){vfunc_called(this, "_ZN10S3443C2_nt4v204Ev");}
void  S3443C2_nt ::v205(){vfunc_called(this, "_ZN10S3443C2_nt4v205Ev");}
void  S3443C2_nt ::v206(){vfunc_called(this, "_ZN10S3443C2_nt4v206Ev");}
void  S3443C2_nt ::v207(){vfunc_called(this, "_ZN10S3443C2_nt4v207Ev");}
void  S3443C2_nt ::v208(){vfunc_called(this, "_ZN10S3443C2_nt4v208Ev");}
void  S3443C2_nt ::v209(){vfunc_called(this, "_ZN10S3443C2_nt4v209Ev");}
void  S3443C2_nt ::v210(){vfunc_called(this, "_ZN10S3443C2_nt4v210Ev");}
void  S3443C2_nt ::v211(){vfunc_called(this, "_ZN10S3443C2_nt4v211Ev");}
void  S3443C2_nt ::v212(){vfunc_called(this, "_ZN10S3443C2_nt4v212Ev");}
void  S3443C2_nt ::v213(){vfunc_called(this, "_ZN10S3443C2_nt4v213Ev");}
void  S3443C2_nt ::v214(){vfunc_called(this, "_ZN10S3443C2_nt4v214Ev");}
void  S3443C2_nt ::v215(){vfunc_called(this, "_ZN10S3443C2_nt4v215Ev");}
S3443C2_nt ::S3443C2_nt(){ note_ctor("S3443C2_nt", this);} // tgen

//skip512 S3443C2_nt

#else // __cplusplus

extern void _ZN10S3443C2_ntC1Ev();
extern void _ZN10S3443C2_ntD1Ev();
Name_Map name_map_S3443C2_nt[] = {
  NSPAIR(_ZN10S3443C2_ntC1Ev),
  NSPAIR(_ZN10S3443C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3443C3_nt;
extern VTBL_ENTRY _ZTI10S3443C3_nt[];
extern  VTBL_ENTRY _ZTV10S3443C3_nt[];
static Base_Class bases_S3443C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3443C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S3443C2_nt[];
extern void _ZN10S3443C2_ntD1Ev();
extern void _ZN10S3443C2_ntD0Ev();
extern void _ZN10S3443C3_nt2v9Ev();
extern void _ZN10S3443C3_nt3v10Ev();
extern void _ZN10S3443C3_nt3v11Ev();
extern void _ZN10S3443C3_nt3v12Ev();
extern void _ZN10S3443C3_nt3v13Ev();
extern void _ZN10S3443C3_nt3v14Ev();
extern void _ZN10S3443C3_nt3v15Ev();
extern void _ZN10S3443C3_nt3v16Ev();
extern void _ZN10S3443C3_nt3v17Ev();
extern void _ZN10S3443C3_nt3v18Ev();
extern void _ZN10S3443C3_nt3v19Ev();
extern void _ZN10S3443C3_nt3v20Ev();
extern void _ZN10S3443C3_nt3v21Ev();
extern void _ZN10S3443C3_nt3v22Ev();
extern void _ZN10S3443C3_nt3v23Ev();
extern void _ZN10S3443C3_nt3v24Ev();
extern void _ZN10S3443C3_nt3v25Ev();
extern void _ZN10S3443C3_nt3v26Ev();
extern void _ZN10S3443C3_nt3v27Ev();
extern void _ZN10S3443C3_nt3v28Ev();
extern void _ZN10S3443C3_nt3v29Ev();
extern void _ZN10S3443C3_nt3v30Ev();
extern void _ZN10S3443C3_nt3v31Ev();
extern void _ZN10S3443C3_nt3v32Ev();
extern void _ZN10S3443C3_nt3v33Ev();
extern void _ZN10S3443C3_nt3v34Ev();
extern void _ZN10S3443C3_nt3v35Ev();
extern void _ZN10S3443C3_nt3v36Ev();
extern void _ZN10S3443C3_nt3v37Ev();
extern void _ZN10S3443C3_nt3v38Ev();
extern void _ZN10S3443C3_nt3v39Ev();
extern void _ZN10S3443C3_nt3v40Ev();
extern void _ZN10S3443C3_nt3v41Ev();
extern void _ZN10S3443C3_nt3v42Ev();
extern void _ZN10S3443C3_nt3v43Ev();
extern void _ZN10S3443C3_nt3v44Ev();
extern void _ZN10S3443C3_nt3v45Ev();
extern void _ZN10S3443C3_nt3v46Ev();
extern void _ZN10S3443C3_nt3v47Ev();
extern void _ZN10S3443C3_nt3v48Ev();
extern void _ZN10S3443C3_nt3v49Ev();
extern void _ZN10S3443C3_nt3v50Ev();
extern void _ZN10S3443C3_nt3v51Ev();
extern void _ZN10S3443C3_nt3v52Ev();
extern void _ZN10S3443C3_nt3v53Ev();
extern void _ZN10S3443C3_nt3v54Ev();
extern void _ZN10S3443C3_nt3v55Ev();
extern void _ZN10S3443C3_nt3v56Ev();
extern void _ZN10S3443C3_nt3v57Ev();
extern void _ZN10S3443C3_nt3v58Ev();
extern void _ZN10S3443C3_nt3v59Ev();
extern void _ZN10S3443C3_nt3v60Ev();
extern void _ZN10S3443C3_nt3v61Ev();
extern void _ZN10S3443C3_nt3v62Ev();
extern void _ZN10S3443C3_nt3v63Ev();
extern void _ZN10S3443C3_nt3v64Ev();
extern void _ZN10S3443C3_nt3v65Ev();
extern void _ZN10S3443C3_nt3v66Ev();
extern void _ZN10S3443C3_nt3v67Ev();
extern void _ZN10S3443C3_nt3v68Ev();
extern void _ZN10S3443C3_nt3v69Ev();
extern void _ZN10S3443C3_nt3v70Ev();
extern void _ZN10S3443C3_nt3v71Ev();
extern void _ZN10S3443C3_nt3v72Ev();
extern void _ZN10S3443C2_nt3v73Ev();
extern void _ZN10S3443C2_nt3v74Ev();
extern void _ZN10S3443C2_nt3v75Ev();
extern void _ZN10S3443C2_nt3v76Ev();
extern void _ZN10S3443C2_nt3v77Ev();
extern void _ZN10S3443C2_nt3v78Ev();
extern void _ZN10S3443C2_nt3v79Ev();
extern void _ZN10S3443C2_nt3v80Ev();
extern void _ZN10S3443C2_nt3v81Ev();
extern void _ZN10S3443C2_nt3v82Ev();
extern void _ZN10S3443C2_nt3v83Ev();
extern void _ZN10S3443C2_nt3v84Ev();
extern void _ZN10S3443C2_nt3v85Ev();
extern void _ZN10S3443C2_nt3v86Ev();
extern void _ZN10S3443C2_nt3v87Ev();
extern void _ZN10S3443C2_nt3v88Ev();
extern void _ZN10S3443C2_nt3v89Ev();
extern void _ZN10S3443C2_nt3v90Ev();
extern void _ZN10S3443C2_nt3v91Ev();
extern void _ZN10S3443C2_nt3v92Ev();
extern void _ZN10S3443C2_nt3v93Ev();
extern void _ZN10S3443C2_nt3v94Ev();
extern void _ZN10S3443C2_nt3v95Ev();
extern void _ZN10S3443C2_nt3v96Ev();
extern void _ZN10S3443C2_nt3v97Ev();
extern void _ZN10S3443C2_nt3v98Ev();
extern void _ZN10S3443C2_nt3v99Ev();
extern void _ZN10S3443C2_nt4v100Ev();
extern void _ZN10S3443C2_nt4v101Ev();
extern void _ZN10S3443C2_nt4v102Ev();
extern void _ZN10S3443C2_nt4v103Ev();
extern void _ZN10S3443C2_nt4v104Ev();
extern void _ZN10S3443C2_nt4v105Ev();
extern void _ZN10S3443C2_nt4v106Ev();
extern void _ZN10S3443C2_nt4v107Ev();
extern void _ZN10S3443C2_nt4v108Ev();
extern void _ZN10S3443C2_nt4v109Ev();
extern void _ZN10S3443C2_nt4v110Ev();
extern void _ZN10S3443C2_nt4v111Ev();
extern void _ZN10S3443C2_nt4v112Ev();
extern void _ZN10S3443C2_nt4v113Ev();
extern void _ZN10S3443C2_nt4v114Ev();
extern void _ZN10S3443C2_nt4v115Ev();
extern void _ZN10S3443C2_nt4v116Ev();
extern void _ZN10S3443C2_nt4v117Ev();
extern void _ZN10S3443C2_nt4v118Ev();
extern void _ZN10S3443C2_nt4v119Ev();
extern void _ZN10S3443C2_nt4v120Ev();
extern void _ZN10S3443C2_nt4v121Ev();
extern void _ZN10S3443C2_nt4v122Ev();
extern void _ZN10S3443C2_nt4v123Ev();
extern void _ZN10S3443C2_nt4v124Ev();
extern void _ZN10S3443C2_nt4v125Ev();
extern void _ZN10S3443C2_nt4v126Ev();
extern void _ZN10S3443C2_nt4v127Ev();
extern void _ZN10S3443C2_nt4v128Ev();
extern void _ZN10S3443C2_nt4v129Ev();
extern void _ZN10S3443C2_nt4v130Ev();
extern void _ZN10S3443C2_nt4v131Ev();
extern void _ZN10S3443C2_nt4v132Ev();
extern void _ZN10S3443C2_nt4v133Ev();
extern void _ZN10S3443C2_nt4v134Ev();
extern void _ZN10S3443C2_nt4v135Ev();
extern void _ZN10S3443C2_nt4v136Ev();
extern void _ZN10S3443C2_nt4v137Ev();
extern void _ZN10S3443C2_nt4v138Ev();
extern void _ZN10S3443C2_nt4v139Ev();
extern void _ZN10S3443C2_nt4v140Ev();
extern void _ZN10S3443C2_nt4v141Ev();
extern void _ZN10S3443C2_nt4v142Ev();
extern void _ZN10S3443C2_nt4v143Ev();
extern void _ZN10S3443C2_nt4v144Ev();
extern void _ZN10S3443C2_nt4v145Ev();
extern void _ZN10S3443C2_nt4v146Ev();
extern void _ZN10S3443C2_nt4v147Ev();
extern void _ZN10S3443C2_nt4v148Ev();
extern void _ZN10S3443C2_nt4v149Ev();
extern void _ZN10S3443C2_nt4v150Ev();
extern void _ZN10S3443C2_nt4v151Ev();
extern void _ZN10S3443C2_nt4v152Ev();
extern void _ZN10S3443C2_nt4v153Ev();
extern void _ZN10S3443C2_nt4v154Ev();
extern void _ZN10S3443C2_nt4v155Ev();
extern void _ZN10S3443C2_nt4v156Ev();
extern void _ZN10S3443C2_nt4v157Ev();
extern void _ZN10S3443C2_nt4v158Ev();
extern void _ZN10S3443C2_nt4v159Ev();
extern void _ZN10S3443C2_nt4v160Ev();
extern void _ZN10S3443C2_nt4v161Ev();
extern void _ZN10S3443C2_nt4v162Ev();
extern void _ZN10S3443C2_nt4v163Ev();
extern void _ZN10S3443C2_nt4v164Ev();
extern void _ZN10S3443C2_nt4v165Ev();
extern void _ZN10S3443C2_nt4v166Ev();
extern void _ZN10S3443C2_nt4v167Ev();
extern void _ZN10S3443C2_nt4v168Ev();
extern void _ZN10S3443C2_nt4v169Ev();
extern void _ZN10S3443C2_nt4v170Ev();
extern void _ZN10S3443C2_nt4v171Ev();
extern void _ZN10S3443C2_nt4v172Ev();
extern void _ZN10S3443C2_nt4v173Ev();
extern void _ZN10S3443C2_nt4v174Ev();
extern void _ZN10S3443C2_nt4v175Ev();
extern void _ZN10S3443C2_nt4v176Ev();
extern void _ZN10S3443C2_nt4v177Ev();
extern void _ZN10S3443C2_nt4v178Ev();
extern void _ZN10S3443C2_nt4v179Ev();
extern void _ZN10S3443C2_nt4v180Ev();
extern void _ZN10S3443C2_nt4v181Ev();
extern void _ZN10S3443C2_nt4v182Ev();
extern void _ZN10S3443C2_nt4v183Ev();
extern void _ZN10S3443C2_nt4v184Ev();
extern void _ZN10S3443C2_nt4v185Ev();
extern void _ZN10S3443C2_nt4v186Ev();
extern void _ZN10S3443C2_nt4v187Ev();
extern void _ZN10S3443C2_nt4v188Ev();
extern void _ZN10S3443C2_nt4v189Ev();
extern void _ZN10S3443C2_nt4v190Ev();
extern void _ZN10S3443C2_nt4v191Ev();
extern void _ZN10S3443C2_nt4v192Ev();
extern void _ZN10S3443C2_nt4v193Ev();
extern void _ZN10S3443C2_nt4v194Ev();
extern void _ZN10S3443C2_nt4v195Ev();
extern void _ZN10S3443C2_nt4v196Ev();
extern void _ZN10S3443C2_nt4v197Ev();
extern void _ZN10S3443C2_nt4v198Ev();
extern void _ZN10S3443C2_nt4v199Ev();
extern void _ZN10S3443C2_nt4v200Ev();
extern void _ZN10S3443C2_nt4v201Ev();
extern void _ZN10S3443C2_nt4v202Ev();
extern void _ZN10S3443C2_nt4v203Ev();
extern void _ZN10S3443C2_nt4v204Ev();
extern void _ZN10S3443C2_nt4v205Ev();
extern void _ZN10S3443C2_nt4v206Ev();
extern void _ZN10S3443C2_nt4v207Ev();
extern void _ZN10S3443C2_nt4v208Ev();
extern void _ZN10S3443C2_nt4v209Ev();
extern void _ZN10S3443C2_nt4v210Ev();
extern void _ZN10S3443C2_nt4v211Ev();
extern void _ZN10S3443C2_nt4v212Ev();
extern void _ZN10S3443C2_nt4v213Ev();
extern void _ZN10S3443C2_nt4v214Ev();
extern void _ZN10S3443C2_nt4v215Ev();
static  VTBL_ENTRY vtc_S3443C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S3443C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S3443C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v211Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v212Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v213Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v214Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v215Ev,
};
extern VTBL_ENTRY _ZTI10S3443C2_nt[];
VTBL_ENTRY *P__ZTI10S3443C2_nt = _ZTI10S3443C2_nt; 
extern  VTBL_ENTRY _ZTV10S3443C2_nt[];
Class_Descriptor cd_S3443C2_nt = {  "S3443C2_nt", // class name
  bases_S3443C2_nt, 1,
  &(vtc_S3443C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(568,436), // object size
  NSPAIRA(_ZTI10S3443C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S3443C2_nt),211, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3443C1  : S3443C2_nt {
  void *s3443c1f0[4];
  unsigned int s3443c1f1:1;
  unsigned int s3443c1f2:1;
  unsigned int s3443c1f3:1;
  void *s3443c1f4[2];
  virtual  ~S3443C1(); // _ZN7S3443C1D1Ev
  virtual void  v1(); // _ZN7S3443C12v1Ev
  virtual void  v2(); // _ZN7S3443C12v2Ev
  virtual void  v3(); // _ZN7S3443C12v3Ev
  virtual void  v4(); // _ZN7S3443C12v4Ev
  virtual void  v5(); // _ZN7S3443C12v5Ev
  virtual void  v6(); // _ZN7S3443C12v6Ev
  virtual void  v7(); // _ZN7S3443C12v7Ev
  virtual void  v8(); // _ZN7S3443C12v8Ev
  S3443C1(); // tgen
};
//SIG(1 S3443C1) C1{ BC2{ BC3{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC5 FC8{ m Fi} Fi Fc[4] Fp[2] FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC4 FC4 FC4 FC9{ BC10{ BC7}} FC9 Fi Fp[2] FC11{ m Fi[3]} FC11 FC11 FC11 Fp FC4 FC9 FC11 FC11 Fi FC11 FC11 Fp Fi Fc FC11 FC11 Fp Fi Fp FC9 FC12{ BC13{ BC7}} FC12} vd v1 v2 v3 v4 v5 v6 v7 v8 Fp[4] Fi:1 Fi:1 Fi:1 Fp[2]}


 S3443C1 ::~S3443C1(){ note_dtor("S3443C1", this);}
void  S3443C1 ::v1(){vfunc_called(this, "_ZN7S3443C12v1Ev");}
void  S3443C1 ::v2(){vfunc_called(this, "_ZN7S3443C12v2Ev");}
void  S3443C1 ::v3(){vfunc_called(this, "_ZN7S3443C12v3Ev");}
void  S3443C1 ::v4(){vfunc_called(this, "_ZN7S3443C12v4Ev");}
void  S3443C1 ::v5(){vfunc_called(this, "_ZN7S3443C12v5Ev");}
void  S3443C1 ::v6(){vfunc_called(this, "_ZN7S3443C12v6Ev");}
void  S3443C1 ::v7(){vfunc_called(this, "_ZN7S3443C12v7Ev");}
void  S3443C1 ::v8(){vfunc_called(this, "_ZN7S3443C12v8Ev");}
S3443C1 ::S3443C1(){ note_ctor("S3443C1", this);} // tgen

static void Test_S3443C1()
{
  extern Class_Descriptor cd_S3443C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(79,117)];
    init_test(&cd_S3443C1, buf);
    S3443C1 *dp, &lv = *(dp=new (buf) S3443C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(624,464), "sizeof(S3443C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3443C1)");
    check_base_class_offset(lv, (S3443C3_nt*)(S3443C2_nt*), 0, "S3443C1");
    check_base_class_offset(lv, (S3443C2_nt*), 0, "S3443C1");
    check_field_offset(lv, s3443c1f0, ABISELECT(568,436), "S3443C1.s3443c1f0");
    set_bf_and_test(lv, s3443c1f1, ABISELECT(600,452), 0, 1, 1, "S3443C1");
    set_bf_and_test(lv, s3443c1f2, ABISELECT(600,452), 1, 1, 1, "S3443C1");
    set_bf_and_test(lv, s3443c1f3, ABISELECT(600,452), 2, 1, 1, "S3443C1");
    check_field_offset(lv, s3443c1f4, ABISELECT(608,456), "S3443C1.s3443c1f4");
    test_class_info(&lv, &cd_S3443C1);
    dp->~S3443C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3443C1(Test_S3443C1, "S3443C1", ABISELECT(624,464));

#else // __cplusplus

extern void _ZN7S3443C1C1Ev();
extern void _ZN7S3443C1D1Ev();
Name_Map name_map_S3443C1[] = {
  NSPAIR(_ZN7S3443C1C1Ev),
  NSPAIR(_ZN7S3443C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3443C3_nt;
extern VTBL_ENTRY _ZTI10S3443C3_nt[];
extern  VTBL_ENTRY _ZTV10S3443C3_nt[];
extern Class_Descriptor cd_S3443C2_nt;
extern VTBL_ENTRY _ZTI10S3443C2_nt[];
extern  VTBL_ENTRY _ZTV10S3443C2_nt[];
static Base_Class bases_S3443C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3443C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3443C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3443C1[];
extern void _ZN7S3443C1D1Ev();
extern void _ZN7S3443C1D0Ev();
extern void _ZN10S3443C3_nt2v9Ev();
extern void _ZN10S3443C3_nt3v10Ev();
extern void _ZN10S3443C3_nt3v11Ev();
extern void _ZN10S3443C3_nt3v12Ev();
extern void _ZN10S3443C3_nt3v13Ev();
extern void _ZN10S3443C3_nt3v14Ev();
extern void _ZN10S3443C3_nt3v15Ev();
extern void _ZN10S3443C3_nt3v16Ev();
extern void _ZN10S3443C3_nt3v17Ev();
extern void _ZN10S3443C3_nt3v18Ev();
extern void _ZN10S3443C3_nt3v19Ev();
extern void _ZN10S3443C3_nt3v20Ev();
extern void _ZN10S3443C3_nt3v21Ev();
extern void _ZN10S3443C3_nt3v22Ev();
extern void _ZN10S3443C3_nt3v23Ev();
extern void _ZN10S3443C3_nt3v24Ev();
extern void _ZN10S3443C3_nt3v25Ev();
extern void _ZN10S3443C3_nt3v26Ev();
extern void _ZN10S3443C3_nt3v27Ev();
extern void _ZN10S3443C3_nt3v28Ev();
extern void _ZN10S3443C3_nt3v29Ev();
extern void _ZN10S3443C3_nt3v30Ev();
extern void _ZN10S3443C3_nt3v31Ev();
extern void _ZN10S3443C3_nt3v32Ev();
extern void _ZN10S3443C3_nt3v33Ev();
extern void _ZN10S3443C3_nt3v34Ev();
extern void _ZN10S3443C3_nt3v35Ev();
extern void _ZN10S3443C3_nt3v36Ev();
extern void _ZN10S3443C3_nt3v37Ev();
extern void _ZN10S3443C3_nt3v38Ev();
extern void _ZN10S3443C3_nt3v39Ev();
extern void _ZN10S3443C3_nt3v40Ev();
extern void _ZN10S3443C3_nt3v41Ev();
extern void _ZN10S3443C3_nt3v42Ev();
extern void _ZN10S3443C3_nt3v43Ev();
extern void _ZN10S3443C3_nt3v44Ev();
extern void _ZN10S3443C3_nt3v45Ev();
extern void _ZN10S3443C3_nt3v46Ev();
extern void _ZN10S3443C3_nt3v47Ev();
extern void _ZN10S3443C3_nt3v48Ev();
extern void _ZN10S3443C3_nt3v49Ev();
extern void _ZN10S3443C3_nt3v50Ev();
extern void _ZN10S3443C3_nt3v51Ev();
extern void _ZN10S3443C3_nt3v52Ev();
extern void _ZN10S3443C3_nt3v53Ev();
extern void _ZN10S3443C3_nt3v54Ev();
extern void _ZN10S3443C3_nt3v55Ev();
extern void _ZN10S3443C3_nt3v56Ev();
extern void _ZN10S3443C3_nt3v57Ev();
extern void _ZN10S3443C3_nt3v58Ev();
extern void _ZN10S3443C3_nt3v59Ev();
extern void _ZN10S3443C3_nt3v60Ev();
extern void _ZN10S3443C3_nt3v61Ev();
extern void _ZN10S3443C3_nt3v62Ev();
extern void _ZN10S3443C3_nt3v63Ev();
extern void _ZN10S3443C3_nt3v64Ev();
extern void _ZN10S3443C3_nt3v65Ev();
extern void _ZN10S3443C3_nt3v66Ev();
extern void _ZN10S3443C3_nt3v67Ev();
extern void _ZN10S3443C3_nt3v68Ev();
extern void _ZN10S3443C3_nt3v69Ev();
extern void _ZN10S3443C3_nt3v70Ev();
extern void _ZN10S3443C3_nt3v71Ev();
extern void _ZN10S3443C3_nt3v72Ev();
extern void _ZN10S3443C2_nt3v73Ev();
extern void _ZN10S3443C2_nt3v74Ev();
extern void _ZN10S3443C2_nt3v75Ev();
extern void _ZN10S3443C2_nt3v76Ev();
extern void _ZN10S3443C2_nt3v77Ev();
extern void _ZN10S3443C2_nt3v78Ev();
extern void _ZN10S3443C2_nt3v79Ev();
extern void _ZN10S3443C2_nt3v80Ev();
extern void _ZN10S3443C2_nt3v81Ev();
extern void _ZN10S3443C2_nt3v82Ev();
extern void _ZN10S3443C2_nt3v83Ev();
extern void _ZN10S3443C2_nt3v84Ev();
extern void _ZN10S3443C2_nt3v85Ev();
extern void _ZN10S3443C2_nt3v86Ev();
extern void _ZN10S3443C2_nt3v87Ev();
extern void _ZN10S3443C2_nt3v88Ev();
extern void _ZN10S3443C2_nt3v89Ev();
extern void _ZN10S3443C2_nt3v90Ev();
extern void _ZN10S3443C2_nt3v91Ev();
extern void _ZN10S3443C2_nt3v92Ev();
extern void _ZN10S3443C2_nt3v93Ev();
extern void _ZN10S3443C2_nt3v94Ev();
extern void _ZN10S3443C2_nt3v95Ev();
extern void _ZN10S3443C2_nt3v96Ev();
extern void _ZN10S3443C2_nt3v97Ev();
extern void _ZN10S3443C2_nt3v98Ev();
extern void _ZN10S3443C2_nt3v99Ev();
extern void _ZN10S3443C2_nt4v100Ev();
extern void _ZN10S3443C2_nt4v101Ev();
extern void _ZN10S3443C2_nt4v102Ev();
extern void _ZN10S3443C2_nt4v103Ev();
extern void _ZN10S3443C2_nt4v104Ev();
extern void _ZN10S3443C2_nt4v105Ev();
extern void _ZN10S3443C2_nt4v106Ev();
extern void _ZN10S3443C2_nt4v107Ev();
extern void _ZN10S3443C2_nt4v108Ev();
extern void _ZN10S3443C2_nt4v109Ev();
extern void _ZN10S3443C2_nt4v110Ev();
extern void _ZN10S3443C2_nt4v111Ev();
extern void _ZN10S3443C2_nt4v112Ev();
extern void _ZN10S3443C2_nt4v113Ev();
extern void _ZN10S3443C2_nt4v114Ev();
extern void _ZN10S3443C2_nt4v115Ev();
extern void _ZN10S3443C2_nt4v116Ev();
extern void _ZN10S3443C2_nt4v117Ev();
extern void _ZN10S3443C2_nt4v118Ev();
extern void _ZN10S3443C2_nt4v119Ev();
extern void _ZN10S3443C2_nt4v120Ev();
extern void _ZN10S3443C2_nt4v121Ev();
extern void _ZN10S3443C2_nt4v122Ev();
extern void _ZN10S3443C2_nt4v123Ev();
extern void _ZN10S3443C2_nt4v124Ev();
extern void _ZN10S3443C2_nt4v125Ev();
extern void _ZN10S3443C2_nt4v126Ev();
extern void _ZN10S3443C2_nt4v127Ev();
extern void _ZN10S3443C2_nt4v128Ev();
extern void _ZN10S3443C2_nt4v129Ev();
extern void _ZN10S3443C2_nt4v130Ev();
extern void _ZN10S3443C2_nt4v131Ev();
extern void _ZN10S3443C2_nt4v132Ev();
extern void _ZN10S3443C2_nt4v133Ev();
extern void _ZN10S3443C2_nt4v134Ev();
extern void _ZN10S3443C2_nt4v135Ev();
extern void _ZN10S3443C2_nt4v136Ev();
extern void _ZN10S3443C2_nt4v137Ev();
extern void _ZN10S3443C2_nt4v138Ev();
extern void _ZN10S3443C2_nt4v139Ev();
extern void _ZN10S3443C2_nt4v140Ev();
extern void _ZN10S3443C2_nt4v141Ev();
extern void _ZN10S3443C2_nt4v142Ev();
extern void _ZN10S3443C2_nt4v143Ev();
extern void _ZN10S3443C2_nt4v144Ev();
extern void _ZN10S3443C2_nt4v145Ev();
extern void _ZN10S3443C2_nt4v146Ev();
extern void _ZN10S3443C2_nt4v147Ev();
extern void _ZN10S3443C2_nt4v148Ev();
extern void _ZN10S3443C2_nt4v149Ev();
extern void _ZN10S3443C2_nt4v150Ev();
extern void _ZN10S3443C2_nt4v151Ev();
extern void _ZN10S3443C2_nt4v152Ev();
extern void _ZN10S3443C2_nt4v153Ev();
extern void _ZN10S3443C2_nt4v154Ev();
extern void _ZN10S3443C2_nt4v155Ev();
extern void _ZN10S3443C2_nt4v156Ev();
extern void _ZN10S3443C2_nt4v157Ev();
extern void _ZN10S3443C2_nt4v158Ev();
extern void _ZN10S3443C2_nt4v159Ev();
extern void _ZN10S3443C2_nt4v160Ev();
extern void _ZN10S3443C2_nt4v161Ev();
extern void _ZN10S3443C2_nt4v162Ev();
extern void _ZN10S3443C2_nt4v163Ev();
extern void _ZN10S3443C2_nt4v164Ev();
extern void _ZN10S3443C2_nt4v165Ev();
extern void _ZN10S3443C2_nt4v166Ev();
extern void _ZN10S3443C2_nt4v167Ev();
extern void _ZN10S3443C2_nt4v168Ev();
extern void _ZN10S3443C2_nt4v169Ev();
extern void _ZN10S3443C2_nt4v170Ev();
extern void _ZN10S3443C2_nt4v171Ev();
extern void _ZN10S3443C2_nt4v172Ev();
extern void _ZN10S3443C2_nt4v173Ev();
extern void _ZN10S3443C2_nt4v174Ev();
extern void _ZN10S3443C2_nt4v175Ev();
extern void _ZN10S3443C2_nt4v176Ev();
extern void _ZN10S3443C2_nt4v177Ev();
extern void _ZN10S3443C2_nt4v178Ev();
extern void _ZN10S3443C2_nt4v179Ev();
extern void _ZN10S3443C2_nt4v180Ev();
extern void _ZN10S3443C2_nt4v181Ev();
extern void _ZN10S3443C2_nt4v182Ev();
extern void _ZN10S3443C2_nt4v183Ev();
extern void _ZN10S3443C2_nt4v184Ev();
extern void _ZN10S3443C2_nt4v185Ev();
extern void _ZN10S3443C2_nt4v186Ev();
extern void _ZN10S3443C2_nt4v187Ev();
extern void _ZN10S3443C2_nt4v188Ev();
extern void _ZN10S3443C2_nt4v189Ev();
extern void _ZN10S3443C2_nt4v190Ev();
extern void _ZN10S3443C2_nt4v191Ev();
extern void _ZN10S3443C2_nt4v192Ev();
extern void _ZN10S3443C2_nt4v193Ev();
extern void _ZN10S3443C2_nt4v194Ev();
extern void _ZN10S3443C2_nt4v195Ev();
extern void _ZN10S3443C2_nt4v196Ev();
extern void _ZN10S3443C2_nt4v197Ev();
extern void _ZN10S3443C2_nt4v198Ev();
extern void _ZN10S3443C2_nt4v199Ev();
extern void _ZN10S3443C2_nt4v200Ev();
extern void _ZN10S3443C2_nt4v201Ev();
extern void _ZN10S3443C2_nt4v202Ev();
extern void _ZN10S3443C2_nt4v203Ev();
extern void _ZN10S3443C2_nt4v204Ev();
extern void _ZN10S3443C2_nt4v205Ev();
extern void _ZN10S3443C2_nt4v206Ev();
extern void _ZN10S3443C2_nt4v207Ev();
extern void _ZN10S3443C2_nt4v208Ev();
extern void _ZN10S3443C2_nt4v209Ev();
extern void _ZN10S3443C2_nt4v210Ev();
extern void _ZN10S3443C2_nt4v211Ev();
extern void _ZN10S3443C2_nt4v212Ev();
extern void _ZN10S3443C2_nt4v213Ev();
extern void _ZN10S3443C2_nt4v214Ev();
extern void _ZN10S3443C2_nt4v215Ev();
extern void _ZN7S3443C12v1Ev();
extern void _ZN7S3443C12v2Ev();
extern void _ZN7S3443C12v3Ev();
extern void _ZN7S3443C12v4Ev();
extern void _ZN7S3443C12v5Ev();
extern void _ZN7S3443C12v6Ev();
extern void _ZN7S3443C12v7Ev();
extern void _ZN7S3443C12v8Ev();
static  VTBL_ENTRY vtc_S3443C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3443C1[0]),
  (VTBL_ENTRY)&_ZN7S3443C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3443C1D0Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S3443C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v211Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v212Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v213Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v214Ev,
  (VTBL_ENTRY)&_ZN10S3443C2_nt4v215Ev,
  (VTBL_ENTRY)&_ZN7S3443C12v1Ev,
  (VTBL_ENTRY)&_ZN7S3443C12v2Ev,
  (VTBL_ENTRY)&_ZN7S3443C12v3Ev,
  (VTBL_ENTRY)&_ZN7S3443C12v4Ev,
  (VTBL_ENTRY)&_ZN7S3443C12v5Ev,
  (VTBL_ENTRY)&_ZN7S3443C12v6Ev,
  (VTBL_ENTRY)&_ZN7S3443C12v7Ev,
  (VTBL_ENTRY)&_ZN7S3443C12v8Ev,
};
extern VTBL_ENTRY _ZTI7S3443C1[];
extern  VTBL_ENTRY _ZTV7S3443C1[];
Class_Descriptor cd_S3443C1 = {  "S3443C1", // class name
  bases_S3443C1, 2,
  &(vtc_S3443C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(624,464), // object size
  NSPAIRA(_ZTI7S3443C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3443C1),219, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2122C7_nt  {
  void  mf2122c7(); // _ZN10S2122C7_nt8mf2122c7Ev
};
//SIG(-1 S2122C7_nt) C1{ m}


void  S2122C7_nt ::mf2122c7(){}

//skip512 S2122C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2122C6_nt  {
  void *s2122c6f0;
  int s2122c6f1;
  ::S2122C7_nt s2122c6f2;
  ::S2122C7_nt s2122c6f3;
  void  mf2122c6(); // _ZN10S2122C6_nt8mf2122c6Ev
};
//SIG(-1 S2122C6_nt) C1{ m Fp Fi FC2{ m} FC2}


void  S2122C6_nt ::mf2122c6(){}

//skip512 S2122C6_nt

#else // __cplusplus

Class_Descriptor cd_S2122C6_nt = {  "S2122C6_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2122C5_nt  : S2122C6_nt {
};
//SIG(-1 S2122C5_nt) C1{ BC2{ m Fp Fi FC3{ m} FC3}}



//skip512 S2122C5_nt

#else // __cplusplus

extern Class_Descriptor cd_S2122C6_nt;
static Base_Class bases_S2122C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2122C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2122C4_nt  {
  void *s2122c4f0;
  int s2122c4f1;
  ::S2122C5_nt s2122c4f2;
  ::S2122C5_nt s2122c4f3;
  int s2122c4f4;
  virtual  ~S2122C4_nt(); // _ZN10S2122C4_ntD1Ev
  virtual void  v2(); // _ZN10S2122C4_nt2v2Ev
  virtual void  v3(); // _ZN10S2122C4_nt2v3Ev
  virtual void  v4(); // _ZN10S2122C4_nt2v4Ev
  virtual void  v5(); // _ZN10S2122C4_nt2v5Ev
  virtual void  v6(); // _ZN10S2122C4_nt2v6Ev
  virtual void  v7(); // _ZN10S2122C4_nt2v7Ev
  virtual void  v8(); // _ZN10S2122C4_nt2v8Ev
  virtual void  v9(); // _ZN10S2122C4_nt2v9Ev
  virtual void  v10(); // _ZN10S2122C4_nt3v10Ev
  virtual void  v11(); // _ZN10S2122C4_nt3v11Ev
  virtual void  v12(); // _ZN10S2122C4_nt3v12Ev
  virtual void  v13(); // _ZN10S2122C4_nt3v13Ev
  virtual void  v14(); // _ZN10S2122C4_nt3v14Ev
  virtual void  v15(); // _ZN10S2122C4_nt3v15Ev
  virtual void  v16(); // _ZN10S2122C4_nt3v16Ev
  virtual void  v17(); // _ZN10S2122C4_nt3v17Ev
  virtual void  v18(); // _ZN10S2122C4_nt3v18Ev
  virtual void  v19(); // _ZN10S2122C4_nt3v19Ev
  virtual void  v20(); // _ZN10S2122C4_nt3v20Ev
  virtual void  v21(); // _ZN10S2122C4_nt3v21Ev
  virtual void  v22(); // _ZN10S2122C4_nt3v22Ev
  virtual void  v23(); // _ZN10S2122C4_nt3v23Ev
  virtual void  v24(); // _ZN10S2122C4_nt3v24Ev
  S2122C4_nt(); // tgen
};
//SIG(-1 S2122C4_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC2{ BC3{ m Fp Fi FC4{ m} FC4}} FC2 Fi}


 S2122C4_nt ::~S2122C4_nt(){ note_dtor("S2122C4_nt", this);}
void  S2122C4_nt ::v2(){vfunc_called(this, "_ZN10S2122C4_nt2v2Ev");}
void  S2122C4_nt ::v3(){vfunc_called(this, "_ZN10S2122C4_nt2v3Ev");}
void  S2122C4_nt ::v4(){vfunc_called(this, "_ZN10S2122C4_nt2v4Ev");}
void  S2122C4_nt ::v5(){vfunc_called(this, "_ZN10S2122C4_nt2v5Ev");}
void  S2122C4_nt ::v6(){vfunc_called(this, "_ZN10S2122C4_nt2v6Ev");}
void  S2122C4_nt ::v7(){vfunc_called(this, "_ZN10S2122C4_nt2v7Ev");}
void  S2122C4_nt ::v8(){vfunc_called(this, "_ZN10S2122C4_nt2v8Ev");}
void  S2122C4_nt ::v9(){vfunc_called(this, "_ZN10S2122C4_nt2v9Ev");}
void  S2122C4_nt ::v10(){vfunc_called(this, "_ZN10S2122C4_nt3v10Ev");}
void  S2122C4_nt ::v11(){vfunc_called(this, "_ZN10S2122C4_nt3v11Ev");}
void  S2122C4_nt ::v12(){vfunc_called(this, "_ZN10S2122C4_nt3v12Ev");}
void  S2122C4_nt ::v13(){vfunc_called(this, "_ZN10S2122C4_nt3v13Ev");}
void  S2122C4_nt ::v14(){vfunc_called(this, "_ZN10S2122C4_nt3v14Ev");}
void  S2122C4_nt ::v15(){vfunc_called(this, "_ZN10S2122C4_nt3v15Ev");}
void  S2122C4_nt ::v16(){vfunc_called(this, "_ZN10S2122C4_nt3v16Ev");}
void  S2122C4_nt ::v17(){vfunc_called(this, "_ZN10S2122C4_nt3v17Ev");}
void  S2122C4_nt ::v18(){vfunc_called(this, "_ZN10S2122C4_nt3v18Ev");}
void  S2122C4_nt ::v19(){vfunc_called(this, "_ZN10S2122C4_nt3v19Ev");}
void  S2122C4_nt ::v20(){vfunc_called(this, "_ZN10S2122C4_nt3v20Ev");}
void  S2122C4_nt ::v21(){vfunc_called(this, "_ZN10S2122C4_nt3v21Ev");}
void  S2122C4_nt ::v22(){vfunc_called(this, "_ZN10S2122C4_nt3v22Ev");}
void  S2122C4_nt ::v23(){vfunc_called(this, "_ZN10S2122C4_nt3v23Ev");}
void  S2122C4_nt ::v24(){vfunc_called(this, "_ZN10S2122C4_nt3v24Ev");}
S2122C4_nt ::S2122C4_nt(){ note_ctor("S2122C4_nt", this);} // tgen

//skip512 S2122C4_nt

#else // __cplusplus

extern void _ZN10S2122C4_ntC1Ev();
extern void _ZN10S2122C4_ntD1Ev();
Name_Map name_map_S2122C4_nt[] = {
  NSPAIR(_ZN10S2122C4_ntC1Ev),
  NSPAIR(_ZN10S2122C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S2122C4_nt[];
extern void _ZN10S2122C4_ntD1Ev();
extern void _ZN10S2122C4_ntD0Ev();
extern void _ZN10S2122C4_nt2v2Ev();
extern void _ZN10S2122C4_nt2v3Ev();
extern void _ZN10S2122C4_nt2v4Ev();
extern void _ZN10S2122C4_nt2v5Ev();
extern void _ZN10S2122C4_nt2v6Ev();
extern void _ZN10S2122C4_nt2v7Ev();
extern void _ZN10S2122C4_nt2v8Ev();
extern void _ZN10S2122C4_nt2v9Ev();
extern void _ZN10S2122C4_nt3v10Ev();
extern void _ZN10S2122C4_nt3v11Ev();
extern void _ZN10S2122C4_nt3v12Ev();
extern void _ZN10S2122C4_nt3v13Ev();
extern void _ZN10S2122C4_nt3v14Ev();
extern void _ZN10S2122C4_nt3v15Ev();
extern void _ZN10S2122C4_nt3v16Ev();
extern void _ZN10S2122C4_nt3v17Ev();
extern void _ZN10S2122C4_nt3v18Ev();
extern void _ZN10S2122C4_nt3v19Ev();
extern void _ZN10S2122C4_nt3v20Ev();
extern void _ZN10S2122C4_nt3v21Ev();
extern void _ZN10S2122C4_nt3v22Ev();
extern void _ZN10S2122C4_nt3v23Ev();
extern void _ZN10S2122C4_nt3v24Ev();
static  VTBL_ENTRY vtc_S2122C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2122C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S2122C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v2Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v24Ev,
};
extern VTBL_ENTRY _ZTI10S2122C4_nt[];
VTBL_ENTRY *P__ZTI10S2122C4_nt = _ZTI10S2122C4_nt; 
extern  VTBL_ENTRY _ZTV10S2122C4_nt[];
Class_Descriptor cd_S2122C4_nt = {  "S2122C4_nt", // class name
  0,0,//no base classes
  &(vtc_S2122C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI10S2122C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S2122C4_nt),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2122C14_nt  {
  __tsi64 s2122c14f0[2];
  void  mf2122c14(); // _ZN11S2122C14_nt9mf2122c14Ev
};
//SIG(-1 S2122C14_nt) C1{ m FL[2]}


void  S2122C14_nt ::mf2122c14(){}

//skip512 S2122C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2122C13_nt  {
  ::S2122C14_nt s2122c13f0;
  void  mf2122c13(); // _ZN11S2122C13_nt9mf2122c13Ev
};
//SIG(-1 S2122C13_nt) C1{ m FC2{ m FL[2]}}


void  S2122C13_nt ::mf2122c13(){}

//skip512 S2122C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2122C17_nt  {
  ::S2122C13_nt s2122c17f0;
  void  mf2122c17(); // _ZN11S2122C17_nt9mf2122c17Ev
};
//SIG(-1 S2122C17_nt) C1{ m FC2{ m FC3{ m FL[2]}}}


void  S2122C17_nt ::mf2122c17(){}

//skip512 S2122C17_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2122C18_nt  {
  ::S2122C13_nt s2122c18f0;
  ::S2122C13_nt s2122c18f1;
  ::S2122C13_nt s2122c18f2;
  ::S2122C13_nt s2122c18f3;
  void  mf2122c18(); // _ZN11S2122C18_nt9mf2122c18Ev
};
//SIG(-1 S2122C18_nt) C1{ m FC2{ m FC3{ m FL[2]}} FC2 FC2 FC2}


void  S2122C18_nt ::mf2122c18(){}

//skip512 S2122C18_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2122C21  {
  void  mf2122c21(); // _ZN8S2122C219mf2122c21Ev
};
//SIG(-1 S2122C21) C1{ m}


void  S2122C21 ::mf2122c21(){}

static void Test_S2122C21()
{
  {
    init_simple_test("S2122C21");
    S2122C21 lv;
    check2(sizeof(lv), 1, "sizeof(S2122C21)");
    check2(__alignof__(lv), 1, "__alignof__(S2122C21)");
  }
}
static Arrange_To_Call_Me vS2122C21(Test_S2122C21, "S2122C21", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2122C20_nt  {
  void *s2122c20f0;
  int s2122c20f1;
  ::S2122C21 s2122c20f2;
  void  mf2122c20(); // _ZN11S2122C20_nt9mf2122c20Ev
};
//SIG(-1 S2122C20_nt) C1{ m Fp Fi FC2{ m}}


void  S2122C20_nt ::mf2122c20(){}

//skip512 S2122C20_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2122C19_nt  {
  ::S2122C20_nt s2122c19f0;
  int s2122c19f1;
  void  mf2122c19(); // _ZN11S2122C19_nt9mf2122c19Ev
};
//SIG(-1 S2122C19_nt) C1{ m FC2{ m Fp Fi FC3{ m}} Fi}


void  S2122C19_nt ::mf2122c19(){}

//skip512 S2122C19_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2122C24  {
  void  mf2122c24(); // _ZN8S2122C249mf2122c24Ev
};
//SIG(-1 S2122C24) C1{ m}


void  S2122C24 ::mf2122c24(){}

static void Test_S2122C24()
{
  {
    init_simple_test("S2122C24");
    S2122C24 lv;
    check2(sizeof(lv), 1, "sizeof(S2122C24)");
    check2(__alignof__(lv), 1, "__alignof__(S2122C24)");
  }
}
static Arrange_To_Call_Me vS2122C24(Test_S2122C24, "S2122C24", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S2122C24[];
VTBL_ENTRY *P__ZTI8S2122C24 = _ZTI8S2122C24; 
Class_Descriptor cd_S2122C24 = {  "S2122C24", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S2122C24),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2122C22  {
  void *s2122c22f0;
  int s2122c22f1;
  ::S2122C21 s2122c22f2;
  ::S2122C24 s2122c22f3;
  void  mf2122c22(); // _ZN8S2122C229mf2122c22Ev
};
//SIG(-1 S2122C22) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S2122C22 ::mf2122c22(){}

static void Test_S2122C22()
{
  {
    init_simple_test("S2122C22");
    S2122C22 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2122C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2122C22)");
    check_field_offset(lv, s2122c22f0, 0, "S2122C22.s2122c22f0");
    check_field_offset(lv, s2122c22f1, ABISELECT(8,4), "S2122C22.s2122c22f1");
    check_field_offset(lv, s2122c22f2, ABISELECT(12,8), "S2122C22.s2122c22f2");
    check_field_offset(lv, s2122c22f3, ABISELECT(13,9), "S2122C22.s2122c22f3");
  }
}
static Arrange_To_Call_Me vS2122C22(Test_S2122C22, "S2122C22", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2122C28  {
  void  mf2122c28(); // _ZN8S2122C289mf2122c28Ev
};
//SIG(-1 S2122C28) C1{ m}


void  S2122C28 ::mf2122c28(){}

static void Test_S2122C28()
{
  {
    init_simple_test("S2122C28");
    S2122C28 lv;
    check2(sizeof(lv), 1, "sizeof(S2122C28)");
    check2(__alignof__(lv), 1, "__alignof__(S2122C28)");
  }
}
static Arrange_To_Call_Me vS2122C28(Test_S2122C28, "S2122C28", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S2122C28[];
VTBL_ENTRY *P__ZTI8S2122C28 = _ZTI8S2122C28; 
Class_Descriptor cd_S2122C28 = {  "S2122C28", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S2122C28),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2122C26  {
  void *s2122c26f0;
  int s2122c26f1;
  ::S2122C24 s2122c26f2;
  ::S2122C28 s2122c26f3;
  void  mf2122c26(); // _ZN8S2122C269mf2122c26Ev
};
//SIG(-1 S2122C26) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S2122C26 ::mf2122c26(){}

static void Test_S2122C26()
{
  {
    init_simple_test("S2122C26");
    S2122C26 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2122C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2122C26)");
    check_field_offset(lv, s2122c26f0, 0, "S2122C26.s2122c26f0");
    check_field_offset(lv, s2122c26f1, ABISELECT(8,4), "S2122C26.s2122c26f1");
    check_field_offset(lv, s2122c26f2, ABISELECT(12,8), "S2122C26.s2122c26f2");
    check_field_offset(lv, s2122c26f3, ABISELECT(13,9), "S2122C26.s2122c26f3");
  }
}
static Arrange_To_Call_Me vS2122C26(Test_S2122C26, "S2122C26", ABISELECT(16,12));

#else // __cplusplus

Class_Descriptor cd_S2122C26 = {  "S2122C26", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2122C25  : S2122C26 {
};
//SIG(-1 S2122C25) C1{ BC2{ m Fp Fi FC3{ m} FC4{ m}}}



static void Test_S2122C25()
{
  extern Class_Descriptor cd_S2122C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S2122C25, buf);
    S2122C25 &lv = *(new (buf) S2122C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2122C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2122C25)");
    check_base_class_offset(lv, (S2122C26*), 0, "S2122C25");
    test_class_info(&lv, &cd_S2122C25);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2122C25(Test_S2122C25, "S2122C25", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S2122C26;
static Base_Class bases_S2122C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2122C26,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S2122C25 = {  "S2122C25", // class name
  bases_S2122C25, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2122C29_nt  {
  void *s2122c29f0;
  int s2122c29f1[2];
  ::S2122C28 s2122c29f2;
  void  mf2122c29(); // _ZN11S2122C29_nt9mf2122c29Ev
};
//SIG(-1 S2122C29_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S2122C29_nt ::mf2122c29(){}

//skip512 S2122C29_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2122C38  {
  void  mf2122c38(); // _ZN8S2122C389mf2122c38Ev
};
//SIG(-1 S2122C38) C1{ m}


void  S2122C38 ::mf2122c38(){}

static void Test_S2122C38()
{
  {
    init_simple_test("S2122C38");
    S2122C38 lv;
    check2(sizeof(lv), 1, "sizeof(S2122C38)");
    check2(__alignof__(lv), 1, "__alignof__(S2122C38)");
  }
}
static Arrange_To_Call_Me vS2122C38(Test_S2122C38, "S2122C38", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S2122C38[];
VTBL_ENTRY *P__ZTI8S2122C38 = _ZTI8S2122C38; 
Class_Descriptor cd_S2122C38 = {  "S2122C38", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S2122C38),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2122C37  {
  void *s2122c37f0;
  int s2122c37f1[2];
  ::S2122C38 s2122c37f2;
  void  mf2122c37(); // _ZN8S2122C379mf2122c37Ev
};
//SIG(-1 S2122C37) C1{ m Fp Fi[2] FC2{ m}}


void  S2122C37 ::mf2122c37(){}

static void Test_S2122C37()
{
  {
    init_simple_test("S2122C37");
    S2122C37 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S2122C37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2122C37)");
    check_field_offset(lv, s2122c37f0, 0, "S2122C37.s2122c37f0");
    check_field_offset(lv, s2122c37f1, ABISELECT(8,4), "S2122C37.s2122c37f1");
    check_field_offset(lv, s2122c37f2, ABISELECT(16,12), "S2122C37.s2122c37f2");
  }
}
static Arrange_To_Call_Me vS2122C37(Test_S2122C37, "S2122C37", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2122C3_nt  : S2122C4_nt {
  ::S2122C13_nt s2122c3f0;
  ::S2122C13_nt s2122c3f1;
  ::S2122C13_nt s2122c3f2;
  ::S2122C13_nt s2122c3f3;
  ::S2122C17_nt s2122c3f4;
  ::S2122C18_nt s2122c3f5;
  ::S2122C18_nt s2122c3f6;
  ::S2122C13_nt s2122c3f7;
  ::S2122C13_nt s2122c3f8;
  ::S2122C13_nt s2122c3f9;
  void *s2122c3f10;
  ::S2122C17_nt s2122c3f11;
  ::S2122C19_nt s2122c3f12;
  int s2122c3f13;
  void *s2122c3f14[7];
  ::S2122C22 s2122c3f15;
  int s2122c3f16:8;
  int s2122c3f17:8;
  int s2122c3f18:16;
  int s2122c3f19:16;
  int s2122c3f20:8;
  int s2122c3f21:8;
  int s2122c3f22:8;
  int s2122c3f23:32;
  int s2122c3f24:8;
  int s2122c3f25:4;
  int s2122c3f26:4;
  int s2122c3f27:4;
  int s2122c3f28:4;
  int s2122c3f29:4;
  int s2122c3f30:4;
  int s2122c3f31:4;
  int s2122c3f32:4;
  int s2122c3f33:4;
  int s2122c3f34:4;
  unsigned char s2122c3f35:1;
  unsigned char s2122c3f36:1;
  unsigned char s2122c3f37:1;
  unsigned char s2122c3f38:1;
  unsigned char s2122c3f39:1;
  unsigned char s2122c3f40:1;
  unsigned char s2122c3f41:1;
  unsigned char s2122c3f42:1;
  unsigned char s2122c3f43:1;
  unsigned char s2122c3f44:1;
  unsigned char s2122c3f45:1;
  unsigned char s2122c3f46:1;
  unsigned char s2122c3f47:1;
  unsigned char s2122c3f48:1;
  unsigned char s2122c3f49:1;
  unsigned char s2122c3f50:1;
  unsigned char s2122c3f51:1;
  unsigned char s2122c3f52:1;
  unsigned char s2122c3f53:1;
  unsigned char s2122c3f54:1;
  unsigned char s2122c3f55:1;
  unsigned char s2122c3f56:1;
  unsigned char s2122c3f57:1;
  unsigned char s2122c3f58:1;
  unsigned char s2122c3f59:1;
  unsigned char s2122c3f60:1;
  unsigned char s2122c3f61:1;
  unsigned char s2122c3f62:1;
  unsigned char s2122c3f63:1;
  unsigned char s2122c3f64:1;
  unsigned char s2122c3f65:1;
  unsigned char s2122c3f66:1;
  unsigned char s2122c3f67:1;
  unsigned char s2122c3f68:1;
  unsigned char s2122c3f69:1;
  unsigned char s2122c3f70:1;
  unsigned char s2122c3f71:1;
  unsigned char s2122c3f72:1;
  unsigned char s2122c3f73:1;
  unsigned char s2122c3f74:1;
  unsigned char s2122c3f75:1;
  int s2122c3f76[7];
  void *s2122c3f77[6];
  int s2122c3f78:8;
  int s2122c3f79:8;
  int s2122c3f80:8;
  int s2122c3f81:8;
  int s2122c3f82:8;
  int s2122c3f83:8;
  ::S2122C25 s2122c3f84;
  void *s2122c3f85[4];
  int s2122c3f86:8;
  int s2122c3f87:8;
  int s2122c3f88:8;
  int s2122c3f89:8;
  int s2122c3f90:8;
  int s2122c3f91:16;
  int s2122c3f92:16;
  int s2122c3f93:16;
  int s2122c3f94:4;
  int s2122c3f95:4;
  int s2122c3f96:4;
  int s2122c3f97:4;
  int s2122c3f98:4;
  int s2122c3f99:4;
  int s2122c3f100:4;
  int s2122c3f101:4;
  int s2122c3f102:4;
  int s2122c3f103:4;
  int s2122c3f104:4;
  int s2122c3f105:4;
  int s2122c3f106:8;
  int s2122c3f107:8;
  int s2122c3f108:8;
  void *s2122c3f109[7];
  ::S2122C29_nt s2122c3f110;
  void *s2122c3f111[2];
  int s2122c3f112:16;
  int s2122c3f113:16;
  ::S2122C25 s2122c3f114;
  ::S2122C29_nt s2122c3f115;
  ::S2122C37 s2122c3f116;
  void *s2122c3f117[2];
  int s2122c3f118:24;
  int s2122c3f119:8;
  void *s2122c3f120;
  virtual  ~S2122C3_nt(); // _ZN10S2122C3_ntD1Ev
  virtual void  v25(); // _ZN10S2122C3_nt3v25Ev
  virtual void  v26(); // _ZN10S2122C3_nt3v26Ev
  virtual void  v27(); // _ZN10S2122C3_nt3v27Ev
  virtual void  v28(); // _ZN10S2122C3_nt3v28Ev
  virtual void  v29(); // _ZN10S2122C3_nt3v29Ev
  virtual void  v30(); // _ZN10S2122C3_nt3v30Ev
  virtual void  v31(); // _ZN10S2122C3_nt3v31Ev
  virtual void  v32(); // _ZN10S2122C3_nt3v32Ev
  virtual void  v33(); // _ZN10S2122C3_nt3v33Ev
  virtual void  v34(); // _ZN10S2122C3_nt3v34Ev
  virtual void  v35(); // _ZN10S2122C3_nt3v35Ev
  virtual void  v36(); // _ZN10S2122C3_nt3v36Ev
  virtual void  v37(); // _ZN10S2122C3_nt3v37Ev
  virtual void  v38(); // _ZN10S2122C3_nt3v38Ev
  virtual void  v39(); // _ZN10S2122C3_nt3v39Ev
  virtual void  v40(); // _ZN10S2122C3_nt3v40Ev
  virtual void  v41(); // _ZN10S2122C3_nt3v41Ev
  virtual void  v42(); // _ZN10S2122C3_nt3v42Ev
  virtual void  v43(); // _ZN10S2122C3_nt3v43Ev
  virtual void  v44(); // _ZN10S2122C3_nt3v44Ev
  virtual void  v45(); // _ZN10S2122C3_nt3v45Ev
  virtual void  v46(); // _ZN10S2122C3_nt3v46Ev
  virtual void  v47(); // _ZN10S2122C3_nt3v47Ev
  virtual void  v48(); // _ZN10S2122C3_nt3v48Ev
  virtual void  v49(); // _ZN10S2122C3_nt3v49Ev
  virtual void  v50(); // _ZN10S2122C3_nt3v50Ev
  virtual void  v51(); // _ZN10S2122C3_nt3v51Ev
  virtual void  v52(); // _ZN10S2122C3_nt3v52Ev
  virtual void  v53(); // _ZN10S2122C3_nt3v53Ev
  virtual void  v54(); // _ZN10S2122C3_nt3v54Ev
  virtual void  v55(); // _ZN10S2122C3_nt3v55Ev
  virtual void  v56(); // _ZN10S2122C3_nt3v56Ev
  virtual void  v57(); // _ZN10S2122C3_nt3v57Ev
  virtual void  v58(); // _ZN10S2122C3_nt3v58Ev
  virtual void  v59(); // _ZN10S2122C3_nt3v59Ev
  virtual void  v60(); // _ZN10S2122C3_nt3v60Ev
  virtual void  v61(); // _ZN10S2122C3_nt3v61Ev
  virtual void  v62(); // _ZN10S2122C3_nt3v62Ev
  virtual void  v63(); // _ZN10S2122C3_nt3v63Ev
  virtual void  v64(); // _ZN10S2122C3_nt3v64Ev
  virtual void  v65(); // _ZN10S2122C3_nt3v65Ev
  virtual void  v66(); // _ZN10S2122C3_nt3v66Ev
  virtual void  v67(); // _ZN10S2122C3_nt3v67Ev
  virtual void  v68(); // _ZN10S2122C3_nt3v68Ev
  virtual void  v69(); // _ZN10S2122C3_nt3v69Ev
  virtual void  v70(); // _ZN10S2122C3_nt3v70Ev
  virtual void  v71(); // _ZN10S2122C3_nt3v71Ev
  virtual void  v72(); // _ZN10S2122C3_nt3v72Ev
  virtual void  v73(); // _ZN10S2122C3_nt3v73Ev
  virtual void  v74(); // _ZN10S2122C3_nt3v74Ev
  virtual void  v75(); // _ZN10S2122C3_nt3v75Ev
  virtual void  v76(); // _ZN10S2122C3_nt3v76Ev
  virtual void  v77(); // _ZN10S2122C3_nt3v77Ev
  virtual void  v78(); // _ZN10S2122C3_nt3v78Ev
  virtual void  v79(); // _ZN10S2122C3_nt3v79Ev
  virtual void  v80(); // _ZN10S2122C3_nt3v80Ev
  virtual void  v81(); // _ZN10S2122C3_nt3v81Ev
  virtual void  v82(); // _ZN10S2122C3_nt3v82Ev
  virtual void  v83(); // _ZN10S2122C3_nt3v83Ev
  virtual void  v84(); // _ZN10S2122C3_nt3v84Ev
  virtual void  v85(); // _ZN10S2122C3_nt3v85Ev
  virtual void  v86(); // _ZN10S2122C3_nt3v86Ev
  virtual void  v87(); // _ZN10S2122C3_nt3v87Ev
  virtual void  v88(); // _ZN10S2122C3_nt3v88Ev
  virtual void  v89(); // _ZN10S2122C3_nt3v89Ev
  virtual void  v90(); // _ZN10S2122C3_nt3v90Ev
  virtual void  v91(); // _ZN10S2122C3_nt3v91Ev
  virtual void  v92(); // _ZN10S2122C3_nt3v92Ev
  virtual void  v93(); // _ZN10S2122C3_nt3v93Ev
  virtual void  v94(); // _ZN10S2122C3_nt3v94Ev
  virtual void  v95(); // _ZN10S2122C3_nt3v95Ev
  virtual void  v96(); // _ZN10S2122C3_nt3v96Ev
  virtual void  v97(); // _ZN10S2122C3_nt3v97Ev
  virtual void  v98(); // _ZN10S2122C3_nt3v98Ev
  virtual void  v99(); // _ZN10S2122C3_nt3v99Ev
  virtual void  v100(); // _ZN10S2122C3_nt4v100Ev
  virtual void  v101(); // _ZN10S2122C3_nt4v101Ev
  virtual void  v102(); // _ZN10S2122C3_nt4v102Ev
  S2122C3_nt(); // tgen
};
//SIG(-1 S2122C3_nt) C1{ BC2{ vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fp Fi FC3{ BC4{ m Fp Fi FC5{ m} FC5}} FC3 Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 FC6{ m FC7{ m FL[2]}} FC6 FC6 FC6 FC8{ m FC6} FC9{ m FC6 FC6 FC6 FC6} FC9 FC6 FC6 FC6 Fp FC8 FC10{ m FC11{ m Fp Fi FC12{ m}} Fi} Fi Fp[7] FC13{ m Fp Fi FC12 FC14{ m}} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC15{ BC16{ m Fp Fi FC14 FC17{ m}}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC18{ m Fp Fi[2] FC17} Fp[2] Fi:16 Fi:16 FC15 FC18 FC19{ m Fp Fi[2] FC20{ m}} Fp[2] Fi:24 Fi:8 Fp}


 S2122C3_nt ::~S2122C3_nt(){ note_dtor("S2122C3_nt", this);}
void  S2122C3_nt ::v25(){vfunc_called(this, "_ZN10S2122C3_nt3v25Ev");}
void  S2122C3_nt ::v26(){vfunc_called(this, "_ZN10S2122C3_nt3v26Ev");}
void  S2122C3_nt ::v27(){vfunc_called(this, "_ZN10S2122C3_nt3v27Ev");}
void  S2122C3_nt ::v28(){vfunc_called(this, "_ZN10S2122C3_nt3v28Ev");}
void  S2122C3_nt ::v29(){vfunc_called(this, "_ZN10S2122C3_nt3v29Ev");}
void  S2122C3_nt ::v30(){vfunc_called(this, "_ZN10S2122C3_nt3v30Ev");}
void  S2122C3_nt ::v31(){vfunc_called(this, "_ZN10S2122C3_nt3v31Ev");}
void  S2122C3_nt ::v32(){vfunc_called(this, "_ZN10S2122C3_nt3v32Ev");}
void  S2122C3_nt ::v33(){vfunc_called(this, "_ZN10S2122C3_nt3v33Ev");}
void  S2122C3_nt ::v34(){vfunc_called(this, "_ZN10S2122C3_nt3v34Ev");}
void  S2122C3_nt ::v35(){vfunc_called(this, "_ZN10S2122C3_nt3v35Ev");}
void  S2122C3_nt ::v36(){vfunc_called(this, "_ZN10S2122C3_nt3v36Ev");}
void  S2122C3_nt ::v37(){vfunc_called(this, "_ZN10S2122C3_nt3v37Ev");}
void  S2122C3_nt ::v38(){vfunc_called(this, "_ZN10S2122C3_nt3v38Ev");}
void  S2122C3_nt ::v39(){vfunc_called(this, "_ZN10S2122C3_nt3v39Ev");}
void  S2122C3_nt ::v40(){vfunc_called(this, "_ZN10S2122C3_nt3v40Ev");}
void  S2122C3_nt ::v41(){vfunc_called(this, "_ZN10S2122C3_nt3v41Ev");}
void  S2122C3_nt ::v42(){vfunc_called(this, "_ZN10S2122C3_nt3v42Ev");}
void  S2122C3_nt ::v43(){vfunc_called(this, "_ZN10S2122C3_nt3v43Ev");}
void  S2122C3_nt ::v44(){vfunc_called(this, "_ZN10S2122C3_nt3v44Ev");}
void  S2122C3_nt ::v45(){vfunc_called(this, "_ZN10S2122C3_nt3v45Ev");}
void  S2122C3_nt ::v46(){vfunc_called(this, "_ZN10S2122C3_nt3v46Ev");}
void  S2122C3_nt ::v47(){vfunc_called(this, "_ZN10S2122C3_nt3v47Ev");}
void  S2122C3_nt ::v48(){vfunc_called(this, "_ZN10S2122C3_nt3v48Ev");}
void  S2122C3_nt ::v49(){vfunc_called(this, "_ZN10S2122C3_nt3v49Ev");}
void  S2122C3_nt ::v50(){vfunc_called(this, "_ZN10S2122C3_nt3v50Ev");}
void  S2122C3_nt ::v51(){vfunc_called(this, "_ZN10S2122C3_nt3v51Ev");}
void  S2122C3_nt ::v52(){vfunc_called(this, "_ZN10S2122C3_nt3v52Ev");}
void  S2122C3_nt ::v53(){vfunc_called(this, "_ZN10S2122C3_nt3v53Ev");}
void  S2122C3_nt ::v54(){vfunc_called(this, "_ZN10S2122C3_nt3v54Ev");}
void  S2122C3_nt ::v55(){vfunc_called(this, "_ZN10S2122C3_nt3v55Ev");}
void  S2122C3_nt ::v56(){vfunc_called(this, "_ZN10S2122C3_nt3v56Ev");}
void  S2122C3_nt ::v57(){vfunc_called(this, "_ZN10S2122C3_nt3v57Ev");}
void  S2122C3_nt ::v58(){vfunc_called(this, "_ZN10S2122C3_nt3v58Ev");}
void  S2122C3_nt ::v59(){vfunc_called(this, "_ZN10S2122C3_nt3v59Ev");}
void  S2122C3_nt ::v60(){vfunc_called(this, "_ZN10S2122C3_nt3v60Ev");}
void  S2122C3_nt ::v61(){vfunc_called(this, "_ZN10S2122C3_nt3v61Ev");}
void  S2122C3_nt ::v62(){vfunc_called(this, "_ZN10S2122C3_nt3v62Ev");}
void  S2122C3_nt ::v63(){vfunc_called(this, "_ZN10S2122C3_nt3v63Ev");}
void  S2122C3_nt ::v64(){vfunc_called(this, "_ZN10S2122C3_nt3v64Ev");}
void  S2122C3_nt ::v65(){vfunc_called(this, "_ZN10S2122C3_nt3v65Ev");}
void  S2122C3_nt ::v66(){vfunc_called(this, "_ZN10S2122C3_nt3v66Ev");}
void  S2122C3_nt ::v67(){vfunc_called(this, "_ZN10S2122C3_nt3v67Ev");}
void  S2122C3_nt ::v68(){vfunc_called(this, "_ZN10S2122C3_nt3v68Ev");}
void  S2122C3_nt ::v69(){vfunc_called(this, "_ZN10S2122C3_nt3v69Ev");}
void  S2122C3_nt ::v70(){vfunc_called(this, "_ZN10S2122C3_nt3v70Ev");}
void  S2122C3_nt ::v71(){vfunc_called(this, "_ZN10S2122C3_nt3v71Ev");}
void  S2122C3_nt ::v72(){vfunc_called(this, "_ZN10S2122C3_nt3v72Ev");}
void  S2122C3_nt ::v73(){vfunc_called(this, "_ZN10S2122C3_nt3v73Ev");}
void  S2122C3_nt ::v74(){vfunc_called(this, "_ZN10S2122C3_nt3v74Ev");}
void  S2122C3_nt ::v75(){vfunc_called(this, "_ZN10S2122C3_nt3v75Ev");}
void  S2122C3_nt ::v76(){vfunc_called(this, "_ZN10S2122C3_nt3v76Ev");}
void  S2122C3_nt ::v77(){vfunc_called(this, "_ZN10S2122C3_nt3v77Ev");}
void  S2122C3_nt ::v78(){vfunc_called(this, "_ZN10S2122C3_nt3v78Ev");}
void  S2122C3_nt ::v79(){vfunc_called(this, "_ZN10S2122C3_nt3v79Ev");}
void  S2122C3_nt ::v80(){vfunc_called(this, "_ZN10S2122C3_nt3v80Ev");}
void  S2122C3_nt ::v81(){vfunc_called(this, "_ZN10S2122C3_nt3v81Ev");}
void  S2122C3_nt ::v82(){vfunc_called(this, "_ZN10S2122C3_nt3v82Ev");}
void  S2122C3_nt ::v83(){vfunc_called(this, "_ZN10S2122C3_nt3v83Ev");}
void  S2122C3_nt ::v84(){vfunc_called(this, "_ZN10S2122C3_nt3v84Ev");}
void  S2122C3_nt ::v85(){vfunc_called(this, "_ZN10S2122C3_nt3v85Ev");}
void  S2122C3_nt ::v86(){vfunc_called(this, "_ZN10S2122C3_nt3v86Ev");}
void  S2122C3_nt ::v87(){vfunc_called(this, "_ZN10S2122C3_nt3v87Ev");}
void  S2122C3_nt ::v88(){vfunc_called(this, "_ZN10S2122C3_nt3v88Ev");}
void  S2122C3_nt ::v89(){vfunc_called(this, "_ZN10S2122C3_nt3v89Ev");}
void  S2122C3_nt ::v90(){vfunc_called(this, "_ZN10S2122C3_nt3v90Ev");}
void  S2122C3_nt ::v91(){vfunc_called(this, "_ZN10S2122C3_nt3v91Ev");}
void  S2122C3_nt ::v92(){vfunc_called(this, "_ZN10S2122C3_nt3v92Ev");}
void  S2122C3_nt ::v93(){vfunc_called(this, "_ZN10S2122C3_nt3v93Ev");}
void  S2122C3_nt ::v94(){vfunc_called(this, "_ZN10S2122C3_nt3v94Ev");}
void  S2122C3_nt ::v95(){vfunc_called(this, "_ZN10S2122C3_nt3v95Ev");}
void  S2122C3_nt ::v96(){vfunc_called(this, "_ZN10S2122C3_nt3v96Ev");}
void  S2122C3_nt ::v97(){vfunc_called(this, "_ZN10S2122C3_nt3v97Ev");}
void  S2122C3_nt ::v98(){vfunc_called(this, "_ZN10S2122C3_nt3v98Ev");}
void  S2122C3_nt ::v99(){vfunc_called(this, "_ZN10S2122C3_nt3v99Ev");}
void  S2122C3_nt ::v100(){vfunc_called(this, "_ZN10S2122C3_nt4v100Ev");}
void  S2122C3_nt ::v101(){vfunc_called(this, "_ZN10S2122C3_nt4v101Ev");}
void  S2122C3_nt ::v102(){vfunc_called(this, "_ZN10S2122C3_nt4v102Ev");}
S2122C3_nt ::S2122C3_nt(){ note_ctor("S2122C3_nt", this);} // tgen

//skip512 S2122C3_nt

#else // __cplusplus

extern void _ZN10S2122C3_ntC1Ev();
extern void _ZN10S2122C3_ntD1Ev();
Name_Map name_map_S2122C3_nt[] = {
  NSPAIR(_ZN10S2122C3_ntC1Ev),
  NSPAIR(_ZN10S2122C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2122C4_nt;
extern VTBL_ENTRY _ZTI10S2122C4_nt[];
extern  VTBL_ENTRY _ZTV10S2122C4_nt[];
static Base_Class bases_S2122C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2122C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S2122C3_nt[];
extern void _ZN10S2122C3_ntD1Ev();
extern void _ZN10S2122C3_ntD0Ev();
extern void _ZN10S2122C4_nt2v2Ev();
extern void _ZN10S2122C4_nt2v3Ev();
extern void _ZN10S2122C4_nt2v4Ev();
extern void _ZN10S2122C4_nt2v5Ev();
extern void _ZN10S2122C4_nt2v6Ev();
extern void _ZN10S2122C4_nt2v7Ev();
extern void _ZN10S2122C4_nt2v8Ev();
extern void _ZN10S2122C4_nt2v9Ev();
extern void _ZN10S2122C4_nt3v10Ev();
extern void _ZN10S2122C4_nt3v11Ev();
extern void _ZN10S2122C4_nt3v12Ev();
extern void _ZN10S2122C4_nt3v13Ev();
extern void _ZN10S2122C4_nt3v14Ev();
extern void _ZN10S2122C4_nt3v15Ev();
extern void _ZN10S2122C4_nt3v16Ev();
extern void _ZN10S2122C4_nt3v17Ev();
extern void _ZN10S2122C4_nt3v18Ev();
extern void _ZN10S2122C4_nt3v19Ev();
extern void _ZN10S2122C4_nt3v20Ev();
extern void _ZN10S2122C4_nt3v21Ev();
extern void _ZN10S2122C4_nt3v22Ev();
extern void _ZN10S2122C4_nt3v23Ev();
extern void _ZN10S2122C4_nt3v24Ev();
extern void _ZN10S2122C3_nt3v25Ev();
extern void _ZN10S2122C3_nt3v26Ev();
extern void _ZN10S2122C3_nt3v27Ev();
extern void _ZN10S2122C3_nt3v28Ev();
extern void _ZN10S2122C3_nt3v29Ev();
extern void _ZN10S2122C3_nt3v30Ev();
extern void _ZN10S2122C3_nt3v31Ev();
extern void _ZN10S2122C3_nt3v32Ev();
extern void _ZN10S2122C3_nt3v33Ev();
extern void _ZN10S2122C3_nt3v34Ev();
extern void _ZN10S2122C3_nt3v35Ev();
extern void _ZN10S2122C3_nt3v36Ev();
extern void _ZN10S2122C3_nt3v37Ev();
extern void _ZN10S2122C3_nt3v38Ev();
extern void _ZN10S2122C3_nt3v39Ev();
extern void _ZN10S2122C3_nt3v40Ev();
extern void _ZN10S2122C3_nt3v41Ev();
extern void _ZN10S2122C3_nt3v42Ev();
extern void _ZN10S2122C3_nt3v43Ev();
extern void _ZN10S2122C3_nt3v44Ev();
extern void _ZN10S2122C3_nt3v45Ev();
extern void _ZN10S2122C3_nt3v46Ev();
extern void _ZN10S2122C3_nt3v47Ev();
extern void _ZN10S2122C3_nt3v48Ev();
extern void _ZN10S2122C3_nt3v49Ev();
extern void _ZN10S2122C3_nt3v50Ev();
extern void _ZN10S2122C3_nt3v51Ev();
extern void _ZN10S2122C3_nt3v52Ev();
extern void _ZN10S2122C3_nt3v53Ev();
extern void _ZN10S2122C3_nt3v54Ev();
extern void _ZN10S2122C3_nt3v55Ev();
extern void _ZN10S2122C3_nt3v56Ev();
extern void _ZN10S2122C3_nt3v57Ev();
extern void _ZN10S2122C3_nt3v58Ev();
extern void _ZN10S2122C3_nt3v59Ev();
extern void _ZN10S2122C3_nt3v60Ev();
extern void _ZN10S2122C3_nt3v61Ev();
extern void _ZN10S2122C3_nt3v62Ev();
extern void _ZN10S2122C3_nt3v63Ev();
extern void _ZN10S2122C3_nt3v64Ev();
extern void _ZN10S2122C3_nt3v65Ev();
extern void _ZN10S2122C3_nt3v66Ev();
extern void _ZN10S2122C3_nt3v67Ev();
extern void _ZN10S2122C3_nt3v68Ev();
extern void _ZN10S2122C3_nt3v69Ev();
extern void _ZN10S2122C3_nt3v70Ev();
extern void _ZN10S2122C3_nt3v71Ev();
extern void _ZN10S2122C3_nt3v72Ev();
extern void _ZN10S2122C3_nt3v73Ev();
extern void _ZN10S2122C3_nt3v74Ev();
extern void _ZN10S2122C3_nt3v75Ev();
extern void _ZN10S2122C3_nt3v76Ev();
extern void _ZN10S2122C3_nt3v77Ev();
extern void _ZN10S2122C3_nt3v78Ev();
extern void _ZN10S2122C3_nt3v79Ev();
extern void _ZN10S2122C3_nt3v80Ev();
extern void _ZN10S2122C3_nt3v81Ev();
extern void _ZN10S2122C3_nt3v82Ev();
extern void _ZN10S2122C3_nt3v83Ev();
extern void _ZN10S2122C3_nt3v84Ev();
extern void _ZN10S2122C3_nt3v85Ev();
extern void _ZN10S2122C3_nt3v86Ev();
extern void _ZN10S2122C3_nt3v87Ev();
extern void _ZN10S2122C3_nt3v88Ev();
extern void _ZN10S2122C3_nt3v89Ev();
extern void _ZN10S2122C3_nt3v90Ev();
extern void _ZN10S2122C3_nt3v91Ev();
extern void _ZN10S2122C3_nt3v92Ev();
extern void _ZN10S2122C3_nt3v93Ev();
extern void _ZN10S2122C3_nt3v94Ev();
extern void _ZN10S2122C3_nt3v95Ev();
extern void _ZN10S2122C3_nt3v96Ev();
extern void _ZN10S2122C3_nt3v97Ev();
extern void _ZN10S2122C3_nt3v98Ev();
extern void _ZN10S2122C3_nt3v99Ev();
extern void _ZN10S2122C3_nt4v100Ev();
extern void _ZN10S2122C3_nt4v101Ev();
extern void _ZN10S2122C3_nt4v102Ev();
static  VTBL_ENTRY vtc_S2122C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2122C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S2122C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v2Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt4v102Ev,
};
extern VTBL_ENTRY _ZTI10S2122C3_nt[];
VTBL_ENTRY *P__ZTI10S2122C3_nt = _ZTI10S2122C3_nt; 
extern  VTBL_ENTRY _ZTV10S2122C3_nt[];
Class_Descriptor cd_S2122C3_nt = {  "S2122C3_nt", // class name
  bases_S2122C3_nt, 1,
  &(vtc_S2122C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(832,632), // object size
  NSPAIRA(_ZTI10S2122C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S2122C3_nt),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2122C2_nt  : S2122C3_nt {
  void *s2122c2f0;
  virtual  ~S2122C2_nt(); // _ZN10S2122C2_ntD1Ev
  virtual void  v103(); // _ZN10S2122C2_nt4v103Ev
  virtual void  v104(); // _ZN10S2122C2_nt4v104Ev
  virtual void  v105(); // _ZN10S2122C2_nt4v105Ev
  virtual void  v106(); // _ZN10S2122C2_nt4v106Ev
  virtual void  v107(); // _ZN10S2122C2_nt4v107Ev
  virtual void  v108(); // _ZN10S2122C2_nt4v108Ev
  virtual void  v109(); // _ZN10S2122C2_nt4v109Ev
  virtual void  v110(); // _ZN10S2122C2_nt4v110Ev
  virtual void  v111(); // _ZN10S2122C2_nt4v111Ev
  virtual void  v112(); // _ZN10S2122C2_nt4v112Ev
  S2122C2_nt(); // tgen
};
//SIG(-1 S2122C2_nt) C1{ BC2{ BC3{ vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 Fp Fi FC4{ BC5{ m Fp Fi FC6{ m} FC6}} FC4 Fi} vd v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 FC7{ m FC8{ m FL[2]}} FC7 FC7 FC7 FC9{ m FC7} FC10{ m FC7 FC7 FC7 FC7} FC10 FC7 FC7 FC7 Fp FC9 FC11{ m FC12{ m Fp Fi FC13{ m}} Fi} Fi Fp[7] FC14{ m Fp Fi FC13 FC15{ m}} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC16{ BC17{ m Fp Fi FC15 FC18{ m}}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC19{ m Fp Fi[2] FC18} Fp[2] Fi:16 Fi:16 FC16 FC19 FC20{ m Fp Fi[2] FC21{ m}} Fp[2] Fi:24 Fi:8 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp}


 S2122C2_nt ::~S2122C2_nt(){ note_dtor("S2122C2_nt", this);}
void  S2122C2_nt ::v103(){vfunc_called(this, "_ZN10S2122C2_nt4v103Ev");}
void  S2122C2_nt ::v104(){vfunc_called(this, "_ZN10S2122C2_nt4v104Ev");}
void  S2122C2_nt ::v105(){vfunc_called(this, "_ZN10S2122C2_nt4v105Ev");}
void  S2122C2_nt ::v106(){vfunc_called(this, "_ZN10S2122C2_nt4v106Ev");}
void  S2122C2_nt ::v107(){vfunc_called(this, "_ZN10S2122C2_nt4v107Ev");}
void  S2122C2_nt ::v108(){vfunc_called(this, "_ZN10S2122C2_nt4v108Ev");}
void  S2122C2_nt ::v109(){vfunc_called(this, "_ZN10S2122C2_nt4v109Ev");}
void  S2122C2_nt ::v110(){vfunc_called(this, "_ZN10S2122C2_nt4v110Ev");}
void  S2122C2_nt ::v111(){vfunc_called(this, "_ZN10S2122C2_nt4v111Ev");}
void  S2122C2_nt ::v112(){vfunc_called(this, "_ZN10S2122C2_nt4v112Ev");}
S2122C2_nt ::S2122C2_nt(){ note_ctor("S2122C2_nt", this);} // tgen

//skip512 S2122C2_nt

#else // __cplusplus

extern void _ZN10S2122C2_ntC1Ev();
extern void _ZN10S2122C2_ntD1Ev();
Name_Map name_map_S2122C2_nt[] = {
  NSPAIR(_ZN10S2122C2_ntC1Ev),
  NSPAIR(_ZN10S2122C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2122C4_nt;
extern VTBL_ENTRY _ZTI10S2122C4_nt[];
extern  VTBL_ENTRY _ZTV10S2122C4_nt[];
extern Class_Descriptor cd_S2122C3_nt;
extern VTBL_ENTRY _ZTI10S2122C3_nt[];
extern  VTBL_ENTRY _ZTV10S2122C3_nt[];
static Base_Class bases_S2122C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2122C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2122C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S2122C2_nt[];
extern void _ZN10S2122C2_ntD1Ev();
extern void _ZN10S2122C2_ntD0Ev();
extern void _ZN10S2122C4_nt2v2Ev();
extern void _ZN10S2122C4_nt2v3Ev();
extern void _ZN10S2122C4_nt2v4Ev();
extern void _ZN10S2122C4_nt2v5Ev();
extern void _ZN10S2122C4_nt2v6Ev();
extern void _ZN10S2122C4_nt2v7Ev();
extern void _ZN10S2122C4_nt2v8Ev();
extern void _ZN10S2122C4_nt2v9Ev();
extern void _ZN10S2122C4_nt3v10Ev();
extern void _ZN10S2122C4_nt3v11Ev();
extern void _ZN10S2122C4_nt3v12Ev();
extern void _ZN10S2122C4_nt3v13Ev();
extern void _ZN10S2122C4_nt3v14Ev();
extern void _ZN10S2122C4_nt3v15Ev();
extern void _ZN10S2122C4_nt3v16Ev();
extern void _ZN10S2122C4_nt3v17Ev();
extern void _ZN10S2122C4_nt3v18Ev();
extern void _ZN10S2122C4_nt3v19Ev();
extern void _ZN10S2122C4_nt3v20Ev();
extern void _ZN10S2122C4_nt3v21Ev();
extern void _ZN10S2122C4_nt3v22Ev();
extern void _ZN10S2122C4_nt3v23Ev();
extern void _ZN10S2122C4_nt3v24Ev();
extern void _ZN10S2122C3_nt3v25Ev();
extern void _ZN10S2122C3_nt3v26Ev();
extern void _ZN10S2122C3_nt3v27Ev();
extern void _ZN10S2122C3_nt3v28Ev();
extern void _ZN10S2122C3_nt3v29Ev();
extern void _ZN10S2122C3_nt3v30Ev();
extern void _ZN10S2122C3_nt3v31Ev();
extern void _ZN10S2122C3_nt3v32Ev();
extern void _ZN10S2122C3_nt3v33Ev();
extern void _ZN10S2122C3_nt3v34Ev();
extern void _ZN10S2122C3_nt3v35Ev();
extern void _ZN10S2122C3_nt3v36Ev();
extern void _ZN10S2122C3_nt3v37Ev();
extern void _ZN10S2122C3_nt3v38Ev();
extern void _ZN10S2122C3_nt3v39Ev();
extern void _ZN10S2122C3_nt3v40Ev();
extern void _ZN10S2122C3_nt3v41Ev();
extern void _ZN10S2122C3_nt3v42Ev();
extern void _ZN10S2122C3_nt3v43Ev();
extern void _ZN10S2122C3_nt3v44Ev();
extern void _ZN10S2122C3_nt3v45Ev();
extern void _ZN10S2122C3_nt3v46Ev();
extern void _ZN10S2122C3_nt3v47Ev();
extern void _ZN10S2122C3_nt3v48Ev();
extern void _ZN10S2122C3_nt3v49Ev();
extern void _ZN10S2122C3_nt3v50Ev();
extern void _ZN10S2122C3_nt3v51Ev();
extern void _ZN10S2122C3_nt3v52Ev();
extern void _ZN10S2122C3_nt3v53Ev();
extern void _ZN10S2122C3_nt3v54Ev();
extern void _ZN10S2122C3_nt3v55Ev();
extern void _ZN10S2122C3_nt3v56Ev();
extern void _ZN10S2122C3_nt3v57Ev();
extern void _ZN10S2122C3_nt3v58Ev();
extern void _ZN10S2122C3_nt3v59Ev();
extern void _ZN10S2122C3_nt3v60Ev();
extern void _ZN10S2122C3_nt3v61Ev();
extern void _ZN10S2122C3_nt3v62Ev();
extern void _ZN10S2122C3_nt3v63Ev();
extern void _ZN10S2122C3_nt3v64Ev();
extern void _ZN10S2122C3_nt3v65Ev();
extern void _ZN10S2122C3_nt3v66Ev();
extern void _ZN10S2122C3_nt3v67Ev();
extern void _ZN10S2122C3_nt3v68Ev();
extern void _ZN10S2122C3_nt3v69Ev();
extern void _ZN10S2122C3_nt3v70Ev();
extern void _ZN10S2122C3_nt3v71Ev();
extern void _ZN10S2122C3_nt3v72Ev();
extern void _ZN10S2122C3_nt3v73Ev();
extern void _ZN10S2122C3_nt3v74Ev();
extern void _ZN10S2122C3_nt3v75Ev();
extern void _ZN10S2122C3_nt3v76Ev();
extern void _ZN10S2122C3_nt3v77Ev();
extern void _ZN10S2122C3_nt3v78Ev();
extern void _ZN10S2122C3_nt3v79Ev();
extern void _ZN10S2122C3_nt3v80Ev();
extern void _ZN10S2122C3_nt3v81Ev();
extern void _ZN10S2122C3_nt3v82Ev();
extern void _ZN10S2122C3_nt3v83Ev();
extern void _ZN10S2122C3_nt3v84Ev();
extern void _ZN10S2122C3_nt3v85Ev();
extern void _ZN10S2122C3_nt3v86Ev();
extern void _ZN10S2122C3_nt3v87Ev();
extern void _ZN10S2122C3_nt3v88Ev();
extern void _ZN10S2122C3_nt3v89Ev();
extern void _ZN10S2122C3_nt3v90Ev();
extern void _ZN10S2122C3_nt3v91Ev();
extern void _ZN10S2122C3_nt3v92Ev();
extern void _ZN10S2122C3_nt3v93Ev();
extern void _ZN10S2122C3_nt3v94Ev();
extern void _ZN10S2122C3_nt3v95Ev();
extern void _ZN10S2122C3_nt3v96Ev();
extern void _ZN10S2122C3_nt3v97Ev();
extern void _ZN10S2122C3_nt3v98Ev();
extern void _ZN10S2122C3_nt3v99Ev();
extern void _ZN10S2122C3_nt4v100Ev();
extern void _ZN10S2122C3_nt4v101Ev();
extern void _ZN10S2122C3_nt4v102Ev();
extern void _ZN10S2122C2_nt4v103Ev();
extern void _ZN10S2122C2_nt4v104Ev();
extern void _ZN10S2122C2_nt4v105Ev();
extern void _ZN10S2122C2_nt4v106Ev();
extern void _ZN10S2122C2_nt4v107Ev();
extern void _ZN10S2122C2_nt4v108Ev();
extern void _ZN10S2122C2_nt4v109Ev();
extern void _ZN10S2122C2_nt4v110Ev();
extern void _ZN10S2122C2_nt4v111Ev();
extern void _ZN10S2122C2_nt4v112Ev();
static  VTBL_ENTRY vtc_S2122C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2122C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S2122C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2122C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v2Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S2122C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S2122C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S2122C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S2122C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S2122C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S2122C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S2122C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S2122C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S2122C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S2122C2_nt4v112Ev,
};
extern VTBL_ENTRY _ZTI10S2122C2_nt[];
VTBL_ENTRY *P__ZTI10S2122C2_nt = _ZTI10S2122C2_nt; 
extern  VTBL_ENTRY _ZTV10S2122C2_nt[];
Class_Descriptor cd_S2122C2_nt = {  "S2122C2_nt", // class name
  bases_S2122C2_nt, 2,
  &(vtc_S2122C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(840,636), // object size
  NSPAIRA(_ZTI10S2122C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S2122C2_nt),115, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2122C39_nt  {
  __tsi64 s2122c39f0;
  void  mf2122c39(); // _ZN11S2122C39_nt9mf2122c39Ev
};
//SIG(-1 S2122C39_nt) C1{ m FL}


void  S2122C39_nt ::mf2122c39(){}

//skip512 S2122C39_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2122C1  : S2122C2_nt {
  int s2122c1f0[3];
  ::S2122C39_nt s2122c1f1;
  int s2122c1f2[4];
  char s2122c1f3;
  int s2122c1f4[38];
  char s2122c1f5[12];
  void *s2122c1f6[3];
  ::S2122C13_nt s2122c1f7;
  ::S2122C13_nt s2122c1f8;
  ::S2122C13_nt s2122c1f9;
  virtual  ~S2122C1(); // _ZN7S2122C1D1Ev
  virtual void  v1(); // _ZN7S2122C12v1Ev
  S2122C1(); // tgen
};
//SIG(1 S2122C1) C1{ BC2{ BC3{ BC4{ vd v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp Fi FC5{ BC6{ m Fp Fi FC7{ m} FC7}} FC5 Fi} vd v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8 FC10{ m FC8} FC11{ m FC8 FC8 FC8 FC8} FC11 FC8 FC8 FC8 Fp FC10 FC12{ m FC13{ m Fp Fi FC14{ m}} Fi} Fi Fp[7] FC15{ m Fp Fi FC14 FC16{ m}} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC17{ BC18{ m Fp Fi FC16 FC19{ m}}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC20{ m Fp Fi[2] FC19} Fp[2] Fi:16 Fi:16 FC17 FC20 FC21{ m Fp Fi[2] FC22{ m}} Fp[2] Fi:24 Fi:8 Fp} vd v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 Fp} vd v1 Fi[3] FC23{ m FL} Fi[4] Fc Fi[38] Fc[12] Fp[3] FC8 FC8 FC8}


 S2122C1 ::~S2122C1(){ note_dtor("S2122C1", this);}
void  S2122C1 ::v1(){vfunc_called(this, "_ZN7S2122C12v1Ev");}
S2122C1 ::S2122C1(){ note_ctor("S2122C1", this);} // tgen

static void Test_S2122C1()
{
  extern Class_Descriptor cd_S2122C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(141,226)];
    init_test(&cd_S2122C1, buf);
    S2122C1 *dp, &lv = *(dp=new (buf) S2122C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1120,900), "sizeof(S2122C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2122C1)");
    check_base_class_offset(lv, (S2122C4_nt*)(S2122C3_nt*)(S2122C2_nt*), 0, "S2122C1");
    check_base_class_offset(lv, (S2122C3_nt*)(S2122C2_nt*), 0, "S2122C1");
    check_base_class_offset(lv, (S2122C2_nt*), 0, "S2122C1");
    check_field_offset(lv, s2122c1f0, ABISELECT(840,636), "S2122C1.s2122c1f0");
    check_field_offset(lv, s2122c1f1, ABISELECT(856,648), "S2122C1.s2122c1f1");
    check_field_offset(lv, s2122c1f2, ABISELECT(864,656), "S2122C1.s2122c1f2");
    check_field_offset(lv, s2122c1f3, ABISELECT(880,672), "S2122C1.s2122c1f3");
    check_field_offset(lv, s2122c1f4, ABISELECT(884,676), "S2122C1.s2122c1f4");
    check_field_offset(lv, s2122c1f5, ABISELECT(1036,828), "S2122C1.s2122c1f5");
    check_field_offset(lv, s2122c1f6, ABISELECT(1048,840), "S2122C1.s2122c1f6");
    check_field_offset(lv, s2122c1f7, ABISELECT(1072,852), "S2122C1.s2122c1f7");
    check_field_offset(lv, s2122c1f8, ABISELECT(1088,868), "S2122C1.s2122c1f8");
    check_field_offset(lv, s2122c1f9, ABISELECT(1104,884), "S2122C1.s2122c1f9");
    test_class_info(&lv, &cd_S2122C1);
    dp->~S2122C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2122C1(Test_S2122C1, "S2122C1", ABISELECT(1120,900));

#else // __cplusplus

extern void _ZN7S2122C1C1Ev();
extern void _ZN7S2122C1D1Ev();
Name_Map name_map_S2122C1[] = {
  NSPAIR(_ZN7S2122C1C1Ev),
  NSPAIR(_ZN7S2122C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2122C4_nt;
extern VTBL_ENTRY _ZTI10S2122C4_nt[];
extern  VTBL_ENTRY _ZTV10S2122C4_nt[];
extern Class_Descriptor cd_S2122C3_nt;
extern VTBL_ENTRY _ZTI10S2122C3_nt[];
extern  VTBL_ENTRY _ZTV10S2122C3_nt[];
extern Class_Descriptor cd_S2122C2_nt;
extern VTBL_ENTRY _ZTI10S2122C2_nt[];
extern  VTBL_ENTRY _ZTV10S2122C2_nt[];
static Base_Class bases_S2122C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2122C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2122C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2122C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2122C1[];
extern void _ZN7S2122C1D1Ev();
extern void _ZN7S2122C1D0Ev();
extern void _ZN10S2122C4_nt2v2Ev();
extern void _ZN10S2122C4_nt2v3Ev();
extern void _ZN10S2122C4_nt2v4Ev();
extern void _ZN10S2122C4_nt2v5Ev();
extern void _ZN10S2122C4_nt2v6Ev();
extern void _ZN10S2122C4_nt2v7Ev();
extern void _ZN10S2122C4_nt2v8Ev();
extern void _ZN10S2122C4_nt2v9Ev();
extern void _ZN10S2122C4_nt3v10Ev();
extern void _ZN10S2122C4_nt3v11Ev();
extern void _ZN10S2122C4_nt3v12Ev();
extern void _ZN10S2122C4_nt3v13Ev();
extern void _ZN10S2122C4_nt3v14Ev();
extern void _ZN10S2122C4_nt3v15Ev();
extern void _ZN10S2122C4_nt3v16Ev();
extern void _ZN10S2122C4_nt3v17Ev();
extern void _ZN10S2122C4_nt3v18Ev();
extern void _ZN10S2122C4_nt3v19Ev();
extern void _ZN10S2122C4_nt3v20Ev();
extern void _ZN10S2122C4_nt3v21Ev();
extern void _ZN10S2122C4_nt3v22Ev();
extern void _ZN10S2122C4_nt3v23Ev();
extern void _ZN10S2122C4_nt3v24Ev();
extern void _ZN10S2122C3_nt3v25Ev();
extern void _ZN10S2122C3_nt3v26Ev();
extern void _ZN10S2122C3_nt3v27Ev();
extern void _ZN10S2122C3_nt3v28Ev();
extern void _ZN10S2122C3_nt3v29Ev();
extern void _ZN10S2122C3_nt3v30Ev();
extern void _ZN10S2122C3_nt3v31Ev();
extern void _ZN10S2122C3_nt3v32Ev();
extern void _ZN10S2122C3_nt3v33Ev();
extern void _ZN10S2122C3_nt3v34Ev();
extern void _ZN10S2122C3_nt3v35Ev();
extern void _ZN10S2122C3_nt3v36Ev();
extern void _ZN10S2122C3_nt3v37Ev();
extern void _ZN10S2122C3_nt3v38Ev();
extern void _ZN10S2122C3_nt3v39Ev();
extern void _ZN10S2122C3_nt3v40Ev();
extern void _ZN10S2122C3_nt3v41Ev();
extern void _ZN10S2122C3_nt3v42Ev();
extern void _ZN10S2122C3_nt3v43Ev();
extern void _ZN10S2122C3_nt3v44Ev();
extern void _ZN10S2122C3_nt3v45Ev();
extern void _ZN10S2122C3_nt3v46Ev();
extern void _ZN10S2122C3_nt3v47Ev();
extern void _ZN10S2122C3_nt3v48Ev();
extern void _ZN10S2122C3_nt3v49Ev();
extern void _ZN10S2122C3_nt3v50Ev();
extern void _ZN10S2122C3_nt3v51Ev();
extern void _ZN10S2122C3_nt3v52Ev();
extern void _ZN10S2122C3_nt3v53Ev();
extern void _ZN10S2122C3_nt3v54Ev();
extern void _ZN10S2122C3_nt3v55Ev();
extern void _ZN10S2122C3_nt3v56Ev();
extern void _ZN10S2122C3_nt3v57Ev();
extern void _ZN10S2122C3_nt3v58Ev();
extern void _ZN10S2122C3_nt3v59Ev();
extern void _ZN10S2122C3_nt3v60Ev();
extern void _ZN10S2122C3_nt3v61Ev();
extern void _ZN10S2122C3_nt3v62Ev();
extern void _ZN10S2122C3_nt3v63Ev();
extern void _ZN10S2122C3_nt3v64Ev();
extern void _ZN10S2122C3_nt3v65Ev();
extern void _ZN10S2122C3_nt3v66Ev();
extern void _ZN10S2122C3_nt3v67Ev();
extern void _ZN10S2122C3_nt3v68Ev();
extern void _ZN10S2122C3_nt3v69Ev();
extern void _ZN10S2122C3_nt3v70Ev();
extern void _ZN10S2122C3_nt3v71Ev();
extern void _ZN10S2122C3_nt3v72Ev();
extern void _ZN10S2122C3_nt3v73Ev();
extern void _ZN10S2122C3_nt3v74Ev();
extern void _ZN10S2122C3_nt3v75Ev();
extern void _ZN10S2122C3_nt3v76Ev();
extern void _ZN10S2122C3_nt3v77Ev();
extern void _ZN10S2122C3_nt3v78Ev();
extern void _ZN10S2122C3_nt3v79Ev();
extern void _ZN10S2122C3_nt3v80Ev();
extern void _ZN10S2122C3_nt3v81Ev();
extern void _ZN10S2122C3_nt3v82Ev();
extern void _ZN10S2122C3_nt3v83Ev();
extern void _ZN10S2122C3_nt3v84Ev();
extern void _ZN10S2122C3_nt3v85Ev();
extern void _ZN10S2122C3_nt3v86Ev();
extern void _ZN10S2122C3_nt3v87Ev();
extern void _ZN10S2122C3_nt3v88Ev();
extern void _ZN10S2122C3_nt3v89Ev();
extern void _ZN10S2122C3_nt3v90Ev();
extern void _ZN10S2122C3_nt3v91Ev();
extern void _ZN10S2122C3_nt3v92Ev();
extern void _ZN10S2122C3_nt3v93Ev();
extern void _ZN10S2122C3_nt3v94Ev();
extern void _ZN10S2122C3_nt3v95Ev();
extern void _ZN10S2122C3_nt3v96Ev();
extern void _ZN10S2122C3_nt3v97Ev();
extern void _ZN10S2122C3_nt3v98Ev();
extern void _ZN10S2122C3_nt3v99Ev();
extern void _ZN10S2122C3_nt4v100Ev();
extern void _ZN10S2122C3_nt4v101Ev();
extern void _ZN10S2122C3_nt4v102Ev();
extern void _ZN10S2122C2_nt4v103Ev();
extern void _ZN10S2122C2_nt4v104Ev();
extern void _ZN10S2122C2_nt4v105Ev();
extern void _ZN10S2122C2_nt4v106Ev();
extern void _ZN10S2122C2_nt4v107Ev();
extern void _ZN10S2122C2_nt4v108Ev();
extern void _ZN10S2122C2_nt4v109Ev();
extern void _ZN10S2122C2_nt4v110Ev();
extern void _ZN10S2122C2_nt4v111Ev();
extern void _ZN10S2122C2_nt4v112Ev();
extern void _ZN7S2122C12v1Ev();
static  VTBL_ENTRY vtc_S2122C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2122C1[0]),
  (VTBL_ENTRY)&_ZN7S2122C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2122C1D0Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v2Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2122C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S2122C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S2122C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S2122C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S2122C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S2122C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S2122C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S2122C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S2122C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S2122C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S2122C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S2122C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN7S2122C12v1Ev,
};
extern VTBL_ENTRY _ZTI7S2122C1[];
extern  VTBL_ENTRY _ZTV7S2122C1[];
Class_Descriptor cd_S2122C1 = {  "S2122C1", // class name
  bases_S2122C1, 3,
  &(vtc_S2122C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1120,900), // object size
  NSPAIRA(_ZTI7S2122C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2122C1),116, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C4  {
  int s12863c4f0;
  long s12863c4f1;
  char s12863c4f2;
};
//SIG(-1 S12863C4) C1{ Fi Fl Fc}



static void Test_S12863C4()
{
  {
    init_simple_test("S12863C4");
    S12863C4 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S12863C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S12863C4)");
    check_field_offset(lv, s12863c4f0, 0, "S12863C4.s12863c4f0");
    check_field_offset(lv, s12863c4f1, ABISELECT(8,4), "S12863C4.s12863c4f1");
    check_field_offset(lv, s12863c4f2, ABISELECT(16,8), "S12863C4.s12863c4f2");
  }
}
static Arrange_To_Call_Me vS12863C4(Test_S12863C4, "S12863C4", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C8  {
  char s12863c8f0;
  char s12863c8f1;
  char s12863c8f2;
};
//SIG(-1 S12863C8) C1{ Fc[3]}



static void Test_S12863C8()
{
  {
    init_simple_test("S12863C8");
    S12863C8 lv;
    check2(sizeof(lv), 3, "sizeof(S12863C8)");
    check2(__alignof__(lv), 1, "__alignof__(S12863C8)");
    check_field_offset(lv, s12863c8f0, 0, "S12863C8.s12863c8f0");
    check_field_offset(lv, s12863c8f1, 1, "S12863C8.s12863c8f1");
    check_field_offset(lv, s12863c8f2, 2, "S12863C8.s12863c8f2");
  }
}
static Arrange_To_Call_Me vS12863C8(Test_S12863C8, "S12863C8", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C9  {
  int s12863c9f0;
  int s12863c9f1;
  char s12863c9f2;
};
//SIG(1 S12863C9) C1{ Fi[2] Fc}



static void Test_S12863C9()
{
  {
    init_simple_test("S12863C9");
    S12863C9 lv;
    check2(sizeof(lv), 12, "sizeof(S12863C9)");
    check2(__alignof__(lv), 4, "__alignof__(S12863C9)");
    check_field_offset(lv, s12863c9f0, 0, "S12863C9.s12863c9f0");
    check_field_offset(lv, s12863c9f1, 4, "S12863C9.s12863c9f1");
    check_field_offset(lv, s12863c9f2, 8, "S12863C9.s12863c9f2");
  }
}
static Arrange_To_Call_Me vS12863C9(Test_S12863C9, "S12863C9", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C10_nt  {
  char s12863c10f0;
  char s12863c10f1;
};
//SIG(1 S12863C10_nt) C1{ Fc[2]}



//skip512 S12863C10_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C11_nt  {
  short s12863c11f0;
  short s12863c11f1;
};
//SIG(1 S12863C11_nt) C1{ Fs[2]}



//skip512 S12863C11_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C12  {
  short s12863c12f0;
  char s12863c12f1;
  char s12863c12f2;
};
//SIG(1 S12863C12) C1{ Fs Fc[2]}



static void Test_S12863C12()
{
  {
    init_simple_test("S12863C12");
    S12863C12 lv;
    check2(sizeof(lv), 4, "sizeof(S12863C12)");
    check2(__alignof__(lv), 2, "__alignof__(S12863C12)");
    check_field_offset(lv, s12863c12f0, 0, "S12863C12.s12863c12f0");
    check_field_offset(lv, s12863c12f1, 2, "S12863C12.s12863c12f1");
    check_field_offset(lv, s12863c12f2, 3, "S12863C12.s12863c12f2");
  }
}
static Arrange_To_Call_Me vS12863C12(Test_S12863C12, "S12863C12", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C13  {
  char s12863c13f0;
  char s12863c13f1;
  int s12863c13f2;
  int s12863c13f3;
  char s12863c13f4;
  char s12863c13f5;
  char s12863c13f6;
  char s12863c13f7;
  char s12863c13f8;
  int s12863c13f9;
  int s12863c13f10;
};
//SIG(1 S12863C13) C1{ Fc[2] Fi[2] Fc[5] Fi[2]}



static void Test_S12863C13()
{
  {
    init_simple_test("S12863C13");
    S12863C13 lv;
    check2(sizeof(lv), 28, "sizeof(S12863C13)");
    check2(__alignof__(lv), 4, "__alignof__(S12863C13)");
    check_field_offset(lv, s12863c13f0, 0, "S12863C13.s12863c13f0");
    check_field_offset(lv, s12863c13f1, 1, "S12863C13.s12863c13f1");
    check_field_offset(lv, s12863c13f2, 4, "S12863C13.s12863c13f2");
    check_field_offset(lv, s12863c13f3, 8, "S12863C13.s12863c13f3");
    check_field_offset(lv, s12863c13f4, 12, "S12863C13.s12863c13f4");
    check_field_offset(lv, s12863c13f5, 13, "S12863C13.s12863c13f5");
    check_field_offset(lv, s12863c13f6, 14, "S12863C13.s12863c13f6");
    check_field_offset(lv, s12863c13f7, 15, "S12863C13.s12863c13f7");
    check_field_offset(lv, s12863c13f8, 16, "S12863C13.s12863c13f8");
    check_field_offset(lv, s12863c13f9, 20, "S12863C13.s12863c13f9");
    check_field_offset(lv, s12863c13f10, 24, "S12863C13.s12863c13f10");
  }
}
static Arrange_To_Call_Me vS12863C13(Test_S12863C13, "S12863C13", 28);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C15  {
  char s12863c15f0;
  char s12863c15f1;
  char s12863c15f2[128];
};
//SIG(1 S12863C15) C1{ Fc[130]}



static void Test_S12863C15()
{
  {
    init_simple_test("S12863C15");
    S12863C15 lv;
    check2(sizeof(lv), 130, "sizeof(S12863C15)");
    check2(__alignof__(lv), 1, "__alignof__(S12863C15)");
    check_field_offset(lv, s12863c15f0, 0, "S12863C15.s12863c15f0");
    check_field_offset(lv, s12863c15f1, 1, "S12863C15.s12863c15f1");
    check_field_offset(lv, s12863c15f2, 2, "S12863C15.s12863c15f2");
  }
}
static Arrange_To_Call_Me vS12863C15(Test_S12863C15, "S12863C15", 130);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C16  {
  char s12863c16f0;
  char s12863c16f1;
};
//SIG(1 S12863C16) C1{ Fc[2]}



static void Test_S12863C16()
{
  {
    init_simple_test("S12863C16");
    S12863C16 lv;
    check2(sizeof(lv), 2, "sizeof(S12863C16)");
    check2(__alignof__(lv), 1, "__alignof__(S12863C16)");
    check_field_offset(lv, s12863c16f0, 0, "S12863C16.s12863c16f0");
    check_field_offset(lv, s12863c16f1, 1, "S12863C16.s12863c16f1");
  }
}
static Arrange_To_Call_Me vS12863C16(Test_S12863C16, "S12863C16", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C17  {
  char s12863c17f0;
  char s12863c17f1[128];
};
//SIG(1 S12863C17) C1{ Fc[129]}



static void Test_S12863C17()
{
  {
    init_simple_test("S12863C17");
    S12863C17 lv;
    check2(sizeof(lv), 129, "sizeof(S12863C17)");
    check2(__alignof__(lv), 1, "__alignof__(S12863C17)");
    check_field_offset(lv, s12863c17f0, 0, "S12863C17.s12863c17f0");
    check_field_offset(lv, s12863c17f1, 1, "S12863C17.s12863c17f1");
  }
}
static Arrange_To_Call_Me vS12863C17(Test_S12863C17, "S12863C17", 129);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C18  {
  char s12863c18f0;
  char s12863c18f1[32];
};
//SIG(1 S12863C18) C1{ Fc[33]}



static void Test_S12863C18()
{
  {
    init_simple_test("S12863C18");
    S12863C18 lv;
    check2(sizeof(lv), 33, "sizeof(S12863C18)");
    check2(__alignof__(lv), 1, "__alignof__(S12863C18)");
    check_field_offset(lv, s12863c18f0, 0, "S12863C18.s12863c18f0");
    check_field_offset(lv, s12863c18f1, 1, "S12863C18.s12863c18f1");
  }
}
static Arrange_To_Call_Me vS12863C18(Test_S12863C18, "S12863C18", 33);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C21  {
  char s12863c21f0;
  char s12863c21f1;
  char s12863c21f2;
  char s12863c21f3[134];
};
//SIG(1 S12863C21) C1{ Fc[137]}



static void Test_S12863C21()
{
  {
    init_simple_test("S12863C21");
    S12863C21 lv;
    check2(sizeof(lv), 137, "sizeof(S12863C21)");
    check2(__alignof__(lv), 1, "__alignof__(S12863C21)");
    check_field_offset(lv, s12863c21f0, 0, "S12863C21.s12863c21f0");
    check_field_offset(lv, s12863c21f1, 1, "S12863C21.s12863c21f1");
    check_field_offset(lv, s12863c21f2, 2, "S12863C21.s12863c21f2");
    check_field_offset(lv, s12863c21f3, 3, "S12863C21.s12863c21f3");
  }
}
static Arrange_To_Call_Me vS12863C21(Test_S12863C21, "S12863C21", 137);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C22  {
  char s12863c22f0;
};
//SIG(1 S12863C22) C1{ Fc}



static void Test_S12863C22()
{
  {
    init_simple_test("S12863C22");
    S12863C22 lv;
    check2(sizeof(lv), 1, "sizeof(S12863C22)");
    check2(__alignof__(lv), 1, "__alignof__(S12863C22)");
    check_field_offset(lv, s12863c22f0, 0, "S12863C22.s12863c22f0");
  }
}
static Arrange_To_Call_Me vS12863C22(Test_S12863C22, "S12863C22", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C24  {
  char s12863c24f0;
  char s12863c24f1[131];
};
//SIG(-1 S12863C24) C1{ Fc[132]}



static void Test_S12863C24()
{
  {
    init_simple_test("S12863C24");
    S12863C24 lv;
    check2(sizeof(lv), 132, "sizeof(S12863C24)");
    check2(__alignof__(lv), 1, "__alignof__(S12863C24)");
    check_field_offset(lv, s12863c24f0, 0, "S12863C24.s12863c24f0");
    check_field_offset(lv, s12863c24f1, 1, "S12863C24.s12863c24f1");
  }
}
static Arrange_To_Call_Me vS12863C24(Test_S12863C24, "S12863C24", 132);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C23  {
  ::S12863C24 s12863c23f0;
  char s12863c23f1;
  char s12863c23f2;
  short s12863c23f3;
  char s12863c23f4;
  int s12863c23f5;
  short s12863c23f6;
};
//SIG(1 S12863C23) C1{ FC2{ Fc[132]} Fc[2] Fs Fc Fi Fs}



static void Test_S12863C23()
{
  {
    init_simple_test("S12863C23");
    S12863C23 lv;
    check2(sizeof(lv), 148, "sizeof(S12863C23)");
    check2(__alignof__(lv), 4, "__alignof__(S12863C23)");
    check_field_offset(lv, s12863c23f0, 0, "S12863C23.s12863c23f0");
    check_field_offset(lv, s12863c23f1, 132, "S12863C23.s12863c23f1");
    check_field_offset(lv, s12863c23f2, 133, "S12863C23.s12863c23f2");
    check_field_offset(lv, s12863c23f3, 134, "S12863C23.s12863c23f3");
    check_field_offset(lv, s12863c23f4, 136, "S12863C23.s12863c23f4");
    check_field_offset(lv, s12863c23f5, 140, "S12863C23.s12863c23f5");
    check_field_offset(lv, s12863c23f6, 144, "S12863C23.s12863c23f6");
  }
}
static Arrange_To_Call_Me vS12863C23(Test_S12863C23, "S12863C23", 148);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C26_nt  {
  int s12863c26f0;
};
//SIG(-1 S12863C26_nt) C1{ Fi}



//skip512 S12863C26_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C28  {
  int s12863c28f0;
  char s12863c28f1;
  char s12863c28f2[226];
};
//SIG(1 S12863C28) C1{ Fi Fc[227]}



static void Test_S12863C28()
{
  {
    init_simple_test("S12863C28");
    S12863C28 lv;
    check2(sizeof(lv), 232, "sizeof(S12863C28)");
    check2(__alignof__(lv), 4, "__alignof__(S12863C28)");
    check_field_offset(lv, s12863c28f0, 0, "S12863C28.s12863c28f0");
    check_field_offset(lv, s12863c28f1, 4, "S12863C28.s12863c28f1");
    check_field_offset(lv, s12863c28f2, 5, "S12863C28.s12863c28f2");
  }
}
static Arrange_To_Call_Me vS12863C28(Test_S12863C28, "S12863C28", 232);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S12863C7  {
  ::S12863C8 s12863c7f0;
  ::S12863C9 s12863c7f1;
  ::S12863C10_nt s12863c7f2;
  ::S12863C11_nt s12863c7f3;
  ::S12863C12 s12863c7f4;
  ::S12863C13 s12863c7f5;
  ::S12863C10_nt s12863c7f6;
  ::S12863C15 s12863c7f7;
  ::S12863C16 s12863c7f8;
  ::S12863C17 s12863c7f9;
  ::S12863C18 s12863c7f10;
  ::S12863C17 s12863c7f11;
  ::S12863C18 s12863c7f12;
  ::S12863C21 s12863c7f13;
  ::S12863C22 s12863c7f14;
  ::S12863C23 s12863c7f15;
  ::S12863C22 s12863c7f16;
  ::S12863C26_nt s12863c7f17;
  ::S12863C26_nt s12863c7f18;
  ::S12863C28 s12863c7f19;
};
//SIG(1 S12863C7) U1{ FC2{ Fc Fc Fc} FC3{ Fi Fi Fc} FC4{ Fc Fc} FC5{ Fs Fs} FC6{ Fs Fc Fc} FC7{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC4 FC8{ Fc Fc Fc[128]} FC9{ Fc Fc} FC10{ Fc Fc[128]} FC11{ Fc Fc[32]} FC10 FC11 FC12{ Fc Fc Fc Fc[134]} FC13{ Fc} FC14{ FC15{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC13 FC16{ Fi} FC16 FC17{ Fi Fc Fc[226]}}

#endif // __cplusplus
#ifdef __cplusplus

struct  S12863C6  {
  int s12863c6f0;
  ::S12863C7 s12863c6f1;
};
//SIG(1 S12863C6) C1{ Fi FU2{ FC3{ Fc Fc Fc} FC4{ Fi Fi Fc} FC5{ Fc Fc} FC6{ Fs Fs} FC7{ Fs Fc Fc} FC8{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC5 FC9{ Fc Fc Fc[128]} FC10{ Fc Fc} FC11{ Fc Fc[128]} FC12{ Fc Fc[32]} FC11 FC12 FC13{ Fc Fc Fc Fc[134]} FC14{ Fc} FC15{ FC16{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC14 FC17{ Fi} FC17 FC18{ Fi Fc Fc[226]}}}



static void Test_S12863C6()
{
  {
    init_simple_test("S12863C6");
    S12863C6 lv;
    check2(sizeof(lv), 236, "sizeof(S12863C6)");
    check2(__alignof__(lv), 4, "__alignof__(S12863C6)");
    check_field_offset(lv, s12863c6f0, 0, "S12863C6.s12863c6f0");
    check_field_offset(lv, s12863c6f1, 4, "S12863C6.s12863c6f1");
  }
}
static Arrange_To_Call_Me vS12863C6(Test_S12863C6, "S12863C6", 236);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C5  {
  char s12863c5f0;
  ::S12863C6 s12863c5f1[7];
  int s12863c5f2;
  int s12863c5f3;
  char s12863c5f4;
  char s12863c5f5;
  char s12863c5f6[229];
  char s12863c5f7;
};
//SIG(-1 S12863C5) C1{ Fc FC2{ Fi FU3{ FC4{ Fc Fc Fc} FC5{ Fi Fi Fc} FC6{ Fc Fc} FC7{ Fs Fs} FC8{ Fs Fc Fc} FC9{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC6 FC10{ Fc Fc Fc[128]} FC11{ Fc Fc} FC12{ Fc Fc[128]} FC13{ Fc Fc[32]} FC12 FC13 FC14{ Fc Fc Fc Fc[134]} FC15{ Fc} FC16{ FC17{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC15 FC18{ Fi} FC18 FC19{ Fi Fc Fc[226]}}}[7] Fi Fi Fc Fc Fc[229] Fc}



static void Test_S12863C5()
{
  {
    init_simple_test("S12863C5");
    S12863C5 lv;
    check2(sizeof(lv), 1896, "sizeof(S12863C5)");
    check2(__alignof__(lv), 4, "__alignof__(S12863C5)");
    check_field_offset(lv, s12863c5f0, 0, "S12863C5.s12863c5f0");
    check_field_offset(lv, s12863c5f1, 4, "S12863C5.s12863c5f1");
    check_field_offset(lv, s12863c5f2, 1656, "S12863C5.s12863c5f2");
    check_field_offset(lv, s12863c5f3, 1660, "S12863C5.s12863c5f3");
    check_field_offset(lv, s12863c5f4, 1664, "S12863C5.s12863c5f4");
    check_field_offset(lv, s12863c5f5, 1665, "S12863C5.s12863c5f5");
    check_field_offset(lv, s12863c5f6, 1666, "S12863C5.s12863c5f6");
    check_field_offset(lv, s12863c5f7, 1895, "S12863C5.s12863c5f7");
  }
}
static Arrange_To_Call_Me vS12863C5(Test_S12863C5, "S12863C5", 1896);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C29  {
  char s12863c29f0;
  char s12863c29f1;
  char s12863c29f2;
  char s12863c29f3;
  char s12863c29f4;
  char s12863c29f5;
  char s12863c29f6;
};
//SIG(-1 S12863C29) C1{ Fc[7]}



static void Test_S12863C29()
{
  {
    init_simple_test("S12863C29");
    S12863C29 lv;
    check2(sizeof(lv), 7, "sizeof(S12863C29)");
    check2(__alignof__(lv), 1, "__alignof__(S12863C29)");
    check_field_offset(lv, s12863c29f0, 0, "S12863C29.s12863c29f0");
    check_field_offset(lv, s12863c29f1, 1, "S12863C29.s12863c29f1");
    check_field_offset(lv, s12863c29f2, 2, "S12863C29.s12863c29f2");
    check_field_offset(lv, s12863c29f3, 3, "S12863C29.s12863c29f3");
    check_field_offset(lv, s12863c29f4, 4, "S12863C29.s12863c29f4");
    check_field_offset(lv, s12863c29f5, 5, "S12863C29.s12863c29f5");
    check_field_offset(lv, s12863c29f6, 6, "S12863C29.s12863c29f6");
  }
}
static Arrange_To_Call_Me vS12863C29(Test_S12863C29, "S12863C29", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C31  {
  int s12863c31f0;
  int s12863c31f1;
  int s12863c31f2;
  int s12863c31f3;
  char s12863c31f4;
  char s12863c31f5[48];
};
//SIG(-1 S12863C31) C1{ Fi[4] Fc[49]}



static void Test_S12863C31()
{
  {
    init_simple_test("S12863C31");
    S12863C31 lv;
    check2(sizeof(lv), 68, "sizeof(S12863C31)");
    check2(__alignof__(lv), 4, "__alignof__(S12863C31)");
    check_field_offset(lv, s12863c31f0, 0, "S12863C31.s12863c31f0");
    check_field_offset(lv, s12863c31f1, 4, "S12863C31.s12863c31f1");
    check_field_offset(lv, s12863c31f2, 8, "S12863C31.s12863c31f2");
    check_field_offset(lv, s12863c31f3, 12, "S12863C31.s12863c31f3");
    check_field_offset(lv, s12863c31f4, 16, "S12863C31.s12863c31f4");
    check_field_offset(lv, s12863c31f5, 17, "S12863C31.s12863c31f5");
  }
}
static Arrange_To_Call_Me vS12863C31(Test_S12863C31, "S12863C31", 68);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C32  {
  int s12863c32f0;
  int s12863c32f1;
};
//SIG(-1 S12863C32) C1{ Fi[2]}



static void Test_S12863C32()
{
  {
    init_simple_test("S12863C32");
    S12863C32 lv;
    check2(sizeof(lv), 8, "sizeof(S12863C32)");
    check2(__alignof__(lv), 4, "__alignof__(S12863C32)");
    check_field_offset(lv, s12863c32f0, 0, "S12863C32.s12863c32f0");
    check_field_offset(lv, s12863c32f1, 4, "S12863C32.s12863c32f1");
  }
}
static Arrange_To_Call_Me vS12863C32(Test_S12863C32, "S12863C32", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C33  {
  char s12863c33f0[4];
  char s12863c33f1;
};
//SIG(-1 S12863C33) C1{ Fc[5]}



static void Test_S12863C33()
{
  {
    init_simple_test("S12863C33");
    S12863C33 lv;
    check2(sizeof(lv), 5, "sizeof(S12863C33)");
    check2(__alignof__(lv), 1, "__alignof__(S12863C33)");
    check_field_offset(lv, s12863c33f0, 0, "S12863C33.s12863c33f0");
    check_field_offset(lv, s12863c33f1, 4, "S12863C33.s12863c33f1");
  }
}
static Arrange_To_Call_Me vS12863C33(Test_S12863C33, "S12863C33", 5);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C34  {
  char s12863c34f0;
  char s12863c34f1;
  void *s12863c34f2;
};
//SIG(-1 S12863C34) C1{ Fc[2] Fp}



static void Test_S12863C34()
{
  {
    init_simple_test("S12863C34");
    S12863C34 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S12863C34)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S12863C34)");
    check_field_offset(lv, s12863c34f0, 0, "S12863C34.s12863c34f0");
    check_field_offset(lv, s12863c34f1, 1, "S12863C34.s12863c34f1");
    check_field_offset(lv, s12863c34f2, ABISELECT(8,4), "S12863C34.s12863c34f2");
  }
}
static Arrange_To_Call_Me vS12863C34(Test_S12863C34, "S12863C34", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C3  {
  long s12863c3f0;
  ::S12863C4 s12863c3f1;
  ::S12863C5 s12863c3f2;
  char s12863c3f3;
  ::S12863C29 s12863c3f4;
  ::S12863C29 s12863c3f5;
  ::S12863C29 s12863c3f6;
  ::S12863C29 s12863c3f7;
  ::S12863C29 s12863c3f8;
  int s12863c3f9;
  int s12863c3f10;
  ::S12863C8 s12863c3f11;
  char s12863c3f12;
  int s12863c3f13;
  int s12863c3f14;
  ::S12863C31 s12863c3f15;
  int s12863c3f16;
  int s12863c3f17;
  ::S12863C32 s12863c3f18;
  long s12863c3f19;
  void *s12863c3f20;
  void *s12863c3f21;
  ::S12863C33 s12863c3f22;
  char s12863c3f23;
  ::S12863C34 s12863c3f24;
};
//SIG(-1 S12863C3) C1{ Fl FC2{ Fi Fl Fc} FC3{ Fc FC4{ Fi FU5{ FC6{ Fc Fc Fc} FC7{ Fi Fi Fc} FC8{ Fc Fc} FC9{ Fs Fs} FC10{ Fs Fc Fc} FC11{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC8 FC12{ Fc Fc Fc[128]} FC13{ Fc Fc} FC14{ Fc Fc[128]} FC15{ Fc Fc[32]} FC14 FC15 FC16{ Fc Fc Fc Fc[134]} FC17{ Fc} FC18{ FC19{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC17 FC20{ Fi} FC20 FC21{ Fi Fc Fc[226]}}}[7] Fi Fi Fc Fc Fc[229] Fc} Fc FC22{ Fc Fc Fc Fc Fc Fc Fc} FC22 FC22 FC22 FC22 Fi Fi FC6 Fc Fi Fi FC23{ Fi Fi Fi Fi Fc Fc[48]} Fi Fi FC24{ Fi Fi} Fl Fp Fp FC25{ Fc[4] Fc} Fc FC26{ Fc Fc Fp}}



static void Test_S12863C3()
{
  {
    init_simple_test("S12863C3");
    S12863C3 lv;
    check2(sizeof(lv), ABISELECT(2120,2080), "sizeof(S12863C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S12863C3)");
    check_field_offset(lv, s12863c3f0, 0, "S12863C3.s12863c3f0");
    check_field_offset(lv, s12863c3f1, ABISELECT(8,4), "S12863C3.s12863c3f1");
    check_field_offset(lv, s12863c3f2, ABISELECT(32,16), "S12863C3.s12863c3f2");
    check_field_offset(lv, s12863c3f3, ABISELECT(1928,1912), "S12863C3.s12863c3f3");
    check_field_offset(lv, s12863c3f4, ABISELECT(1929,1913), "S12863C3.s12863c3f4");
    check_field_offset(lv, s12863c3f5, ABISELECT(1936,1920), "S12863C3.s12863c3f5");
    check_field_offset(lv, s12863c3f6, ABISELECT(1943,1927), "S12863C3.s12863c3f6");
    check_field_offset(lv, s12863c3f7, ABISELECT(1950,1934), "S12863C3.s12863c3f7");
    check_field_offset(lv, s12863c3f8, ABISELECT(1957,1941), "S12863C3.s12863c3f8");
    check_field_offset(lv, s12863c3f9, ABISELECT(1964,1948), "S12863C3.s12863c3f9");
    check_field_offset(lv, s12863c3f10, ABISELECT(1968,1952), "S12863C3.s12863c3f10");
    check_field_offset(lv, s12863c3f11, ABISELECT(1972,1956), "S12863C3.s12863c3f11");
    check_field_offset(lv, s12863c3f12, ABISELECT(1975,1959), "S12863C3.s12863c3f12");
    check_field_offset(lv, s12863c3f13, ABISELECT(1976,1960), "S12863C3.s12863c3f13");
    check_field_offset(lv, s12863c3f14, ABISELECT(1980,1964), "S12863C3.s12863c3f14");
    check_field_offset(lv, s12863c3f15, ABISELECT(1984,1968), "S12863C3.s12863c3f15");
    check_field_offset(lv, s12863c3f16, ABISELECT(2052,2036), "S12863C3.s12863c3f16");
    check_field_offset(lv, s12863c3f17, ABISELECT(2056,2040), "S12863C3.s12863c3f17");
    check_field_offset(lv, s12863c3f18, ABISELECT(2060,2044), "S12863C3.s12863c3f18");
    check_field_offset(lv, s12863c3f19, ABISELECT(2072,2052), "S12863C3.s12863c3f19");
    check_field_offset(lv, s12863c3f20, ABISELECT(2080,2056), "S12863C3.s12863c3f20");
    check_field_offset(lv, s12863c3f21, ABISELECT(2088,2060), "S12863C3.s12863c3f21");
    check_field_offset(lv, s12863c3f22, ABISELECT(2096,2064), "S12863C3.s12863c3f22");
    check_field_offset(lv, s12863c3f23, ABISELECT(2101,2069), "S12863C3.s12863c3f23");
    check_field_offset(lv, s12863c3f24, ABISELECT(2104,2072), "S12863C3.s12863c3f24");
  }
}
static Arrange_To_Call_Me vS12863C3(Test_S12863C3, "S12863C3", ABISELECT(2120,2080));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C38  {
  int s12863c38f0;
  char s12863c38f1;
  int s12863c38f2;
  int s12863c38f3;
  char s12863c38f4;
  int s12863c38f5;
  char s12863c38f6;
};
//SIG(-1 S12863C38) C1{ Fi Fc Fi[2] Fc Fi Fc}



static void Test_S12863C38()
{
  {
    init_simple_test("S12863C38");
    S12863C38 lv;
    check2(sizeof(lv), 28, "sizeof(S12863C38)");
    check2(__alignof__(lv), 4, "__alignof__(S12863C38)");
    check_field_offset(lv, s12863c38f0, 0, "S12863C38.s12863c38f0");
    check_field_offset(lv, s12863c38f1, 4, "S12863C38.s12863c38f1");
    check_field_offset(lv, s12863c38f2, 8, "S12863C38.s12863c38f2");
    check_field_offset(lv, s12863c38f3, 12, "S12863C38.s12863c38f3");
    check_field_offset(lv, s12863c38f4, 16, "S12863C38.s12863c38f4");
    check_field_offset(lv, s12863c38f5, 20, "S12863C38.s12863c38f5");
    check_field_offset(lv, s12863c38f6, 24, "S12863C38.s12863c38f6");
  }
}
static Arrange_To_Call_Me vS12863C38(Test_S12863C38, "S12863C38", 28);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C39  {
  char s12863c39f0;
  ::S12863C6 s12863c39f1[7];
  short s12863c39f2;
  char s12863c39f3[255];
};
//SIG(-1 S12863C39) C1{ Fc FC2{ Fi FU3{ FC4{ Fc Fc Fc} FC5{ Fi Fi Fc} FC6{ Fc Fc} FC7{ Fs Fs} FC8{ Fs Fc Fc} FC9{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC6 FC10{ Fc Fc Fc[128]} FC11{ Fc Fc} FC12{ Fc Fc[128]} FC13{ Fc Fc[32]} FC12 FC13 FC14{ Fc Fc Fc Fc[134]} FC15{ Fc} FC16{ FC17{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC15 FC18{ Fi} FC18 FC19{ Fi Fc Fc[226]}}}[7] Fs Fc[255]}



static void Test_S12863C39()
{
  {
    init_simple_test("S12863C39");
    S12863C39 lv;
    check2(sizeof(lv), 1916, "sizeof(S12863C39)");
    check2(__alignof__(lv), 4, "__alignof__(S12863C39)");
    check_field_offset(lv, s12863c39f0, 0, "S12863C39.s12863c39f0");
    check_field_offset(lv, s12863c39f1, 4, "S12863C39.s12863c39f1");
    check_field_offset(lv, s12863c39f2, 1656, "S12863C39.s12863c39f2");
    check_field_offset(lv, s12863c39f3, 1658, "S12863C39.s12863c39f3");
  }
}
static Arrange_To_Call_Me vS12863C39(Test_S12863C39, "S12863C39", 1916);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C37  {
  char s12863c37f0;
  char s12863c37f1;
  char s12863c37f2;
  char s12863c37f3;
  ::S12863C31 s12863c37f4;
  int s12863c37f5;
  ::S12863C38 s12863c37f6;
  ::S12863C29 s12863c37f7;
  ::S12863C39 s12863c37f8;
};
//SIG(1 S12863C37) C1{ Fc[4] FC2{ Fi[4] Fc[49]} Fi FC3{ Fi Fc Fi[2] Fc Fi Fc} FC4{ Fc[7]} FC5{ Fc FC6{ Fi FU7{ FC8{ Fc Fc Fc} FC9{ Fi Fi Fc} FC10{ Fc Fc} FC11{ Fs Fs} FC12{ Fs Fc Fc} FC13{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC10 FC14{ Fc Fc Fc[128]} FC15{ Fc Fc} FC16{ Fc Fc[128]} FC17{ Fc Fc[32]} FC16 FC17 FC18{ Fc Fc Fc Fc[134]} FC19{ Fc} FC20{ FC21{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC19 FC22{ Fi} FC22 FC23{ Fi Fc Fc[226]}}}[7] Fs Fc[255]}}



static void Test_S12863C37()
{
  {
    init_simple_test("S12863C37");
    S12863C37 lv;
    check2(sizeof(lv), 2028, "sizeof(S12863C37)");
    check2(__alignof__(lv), 4, "__alignof__(S12863C37)");
    check_field_offset(lv, s12863c37f0, 0, "S12863C37.s12863c37f0");
    check_field_offset(lv, s12863c37f1, 1, "S12863C37.s12863c37f1");
    check_field_offset(lv, s12863c37f2, 2, "S12863C37.s12863c37f2");
    check_field_offset(lv, s12863c37f3, 3, "S12863C37.s12863c37f3");
    check_field_offset(lv, s12863c37f4, 4, "S12863C37.s12863c37f4");
    check_field_offset(lv, s12863c37f5, 72, "S12863C37.s12863c37f5");
    check_field_offset(lv, s12863c37f6, 76, "S12863C37.s12863c37f6");
    check_field_offset(lv, s12863c37f7, 104, "S12863C37.s12863c37f7");
    check_field_offset(lv, s12863c37f8, 112, "S12863C37.s12863c37f8");
  }
}
static Arrange_To_Call_Me vS12863C37(Test_S12863C37, "S12863C37", 2028);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C40  {
  char s12863c40f0;
  long s12863c40f1;
  int s12863c40f2;
  ::S12863C38 s12863c40f3;
  ::S12863C39 s12863c40f4;
};
//SIG(1 S12863C40) C1{ Fc Fl Fi FC2{ Fi Fc Fi[2] Fc Fi Fc} FC3{ Fc FC4{ Fi FU5{ FC6{ Fc Fc Fc} FC7{ Fi Fi Fc} FC8{ Fc Fc} FC9{ Fs Fs} FC10{ Fs Fc Fc} FC11{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC8 FC12{ Fc Fc Fc[128]} FC13{ Fc Fc} FC14{ Fc Fc[128]} FC15{ Fc Fc[32]} FC14 FC15 FC16{ Fc Fc Fc Fc[134]} FC17{ Fc} FC18{ FC19{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC17 FC20{ Fi} FC20 FC21{ Fi Fc Fc[226]}}}[7] Fs Fc[255]}}



static void Test_S12863C40()
{
  {
    init_simple_test("S12863C40");
    S12863C40 lv;
    check2(sizeof(lv), ABISELECT(1968,1956), "sizeof(S12863C40)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S12863C40)");
    check_field_offset(lv, s12863c40f0, 0, "S12863C40.s12863c40f0");
    check_field_offset(lv, s12863c40f1, ABISELECT(8,4), "S12863C40.s12863c40f1");
    check_field_offset(lv, s12863c40f2, ABISELECT(16,8), "S12863C40.s12863c40f2");
    check_field_offset(lv, s12863c40f3, ABISELECT(20,12), "S12863C40.s12863c40f3");
    check_field_offset(lv, s12863c40f4, ABISELECT(48,40), "S12863C40.s12863c40f4");
  }
}
static Arrange_To_Call_Me vS12863C40(Test_S12863C40, "S12863C40", ABISELECT(1968,1956));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C41  {
  char s12863c41f0;
  int s12863c41f1;
  long s12863c41f2;
  int s12863c41f3;
  ::S12863C38 s12863c41f4;
  ::S12863C39 s12863c41f5;
};
//SIG(1 S12863C41) C1{ Fc Fi Fl Fi FC2{ Fi Fc Fi[2] Fc Fi Fc} FC3{ Fc FC4{ Fi FU5{ FC6{ Fc Fc Fc} FC7{ Fi Fi Fc} FC8{ Fc Fc} FC9{ Fs Fs} FC10{ Fs Fc Fc} FC11{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC8 FC12{ Fc Fc Fc[128]} FC13{ Fc Fc} FC14{ Fc Fc[128]} FC15{ Fc Fc[32]} FC14 FC15 FC16{ Fc Fc Fc Fc[134]} FC17{ Fc} FC18{ FC19{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC17 FC20{ Fi} FC20 FC21{ Fi Fc Fc[226]}}}[7] Fs Fc[255]}}



static void Test_S12863C41()
{
  {
    init_simple_test("S12863C41");
    S12863C41 lv;
    check2(sizeof(lv), ABISELECT(1968,1960), "sizeof(S12863C41)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S12863C41)");
    check_field_offset(lv, s12863c41f0, 0, "S12863C41.s12863c41f0");
    check_field_offset(lv, s12863c41f1, 4, "S12863C41.s12863c41f1");
    check_field_offset(lv, s12863c41f2, 8, "S12863C41.s12863c41f2");
    check_field_offset(lv, s12863c41f3, ABISELECT(16,12), "S12863C41.s12863c41f3");
    check_field_offset(lv, s12863c41f4, ABISELECT(20,16), "S12863C41.s12863c41f4");
    check_field_offset(lv, s12863c41f5, ABISELECT(48,44), "S12863C41.s12863c41f5");
  }
}
static Arrange_To_Call_Me vS12863C41(Test_S12863C41, "S12863C41", ABISELECT(1968,1960));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S12863C44  {
  ::S12863C29 s12863c44f0;
};
//SIG(1 S12863C44) U1{ FC2{ Fc Fc Fc Fc Fc Fc Fc}}

#endif // __cplusplus
#ifdef __cplusplus

struct  S12863C43  {
  int s12863c43f0;
  ::S12863C44 s12863c43f1;
};
//SIG(-1 S12863C43) C1{ Fi FU2{ FC3{ Fc Fc Fc Fc Fc Fc Fc}}}



static void Test_S12863C43()
{
  {
    init_simple_test("S12863C43");
    S12863C43 lv;
    check2(sizeof(lv), 12, "sizeof(S12863C43)");
    check2(__alignof__(lv), 4, "__alignof__(S12863C43)");
    check_field_offset(lv, s12863c43f0, 0, "S12863C43.s12863c43f0");
    check_field_offset(lv, s12863c43f1, 4, "S12863C43.s12863c43f1");
  }
}
static Arrange_To_Call_Me vS12863C43(Test_S12863C43, "S12863C43", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C42  {
  char s12863c42f0;
  char s12863c42f1;
  char s12863c42f2;
  char s12863c42f3;
  long s12863c42f4;
  ::S12863C31 s12863c42f5;
  int s12863c42f6;
  ::S12863C38 s12863c42f7;
  ::S12863C43 s12863c42f8;
  ::S12863C39 s12863c42f9;
};
//SIG(1 S12863C42) C1{ Fc[4] Fl FC2{ Fi[4] Fc[49]} Fi FC3{ Fi Fc Fi[2] Fc Fi Fc} FC4{ Fi FU5{ FC6{ Fc Fc Fc Fc Fc Fc Fc}}} FC7{ Fc FC8{ Fi FU9{ FC10{ Fc Fc Fc} FC11{ Fi Fi Fc} FC12{ Fc Fc} FC13{ Fs Fs} FC14{ Fs Fc Fc} FC15{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC12 FC16{ Fc Fc Fc[128]} FC17{ Fc Fc} FC18{ Fc Fc[128]} FC19{ Fc Fc[32]} FC18 FC19 FC20{ Fc Fc Fc Fc[134]} FC21{ Fc} FC22{ FC23{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC21 FC24{ Fi} FC24 FC25{ Fi Fc Fc[226]}}}[7] Fs Fc[255]}}



static void Test_S12863C42()
{
  {
    init_simple_test("S12863C42");
    S12863C42 lv;
    check2(sizeof(lv), ABISELECT(2048,2036), "sizeof(S12863C42)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S12863C42)");
    check_field_offset(lv, s12863c42f0, 0, "S12863C42.s12863c42f0");
    check_field_offset(lv, s12863c42f1, 1, "S12863C42.s12863c42f1");
    check_field_offset(lv, s12863c42f2, 2, "S12863C42.s12863c42f2");
    check_field_offset(lv, s12863c42f3, 3, "S12863C42.s12863c42f3");
    check_field_offset(lv, s12863c42f4, ABISELECT(8,4), "S12863C42.s12863c42f4");
    check_field_offset(lv, s12863c42f5, ABISELECT(16,8), "S12863C42.s12863c42f5");
    check_field_offset(lv, s12863c42f6, ABISELECT(84,76), "S12863C42.s12863c42f6");
    check_field_offset(lv, s12863c42f7, ABISELECT(88,80), "S12863C42.s12863c42f7");
    check_field_offset(lv, s12863c42f8, ABISELECT(116,108), "S12863C42.s12863c42f8");
    check_field_offset(lv, s12863c42f9, ABISELECT(128,120), "S12863C42.s12863c42f9");
  }
}
static Arrange_To_Call_Me vS12863C42(Test_S12863C42, "S12863C42", ABISELECT(2048,2036));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C45  {
  char s12863c45f0;
  ::S12863C29 s12863c45f1;
  long s12863c45f2;
  int s12863c45f3;
  ::S12863C38 s12863c45f4;
  ::S12863C39 s12863c45f5;
};
//SIG(1 S12863C45) C1{ Fc FC2{ Fc[7]} Fl Fi FC3{ Fi Fc Fi[2] Fc Fi Fc} FC4{ Fc FC5{ Fi FU6{ FC7{ Fc Fc Fc} FC8{ Fi Fi Fc} FC9{ Fc Fc} FC10{ Fs Fs} FC11{ Fs Fc Fc} FC12{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC9 FC13{ Fc Fc Fc[128]} FC14{ Fc Fc} FC15{ Fc Fc[128]} FC16{ Fc Fc[32]} FC15 FC16 FC17{ Fc Fc Fc Fc[134]} FC18{ Fc} FC19{ FC20{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC18 FC21{ Fi} FC21 FC22{ Fi Fc Fc[226]}}}[7] Fs Fc[255]}}



static void Test_S12863C45()
{
  {
    init_simple_test("S12863C45");
    S12863C45 lv;
    check2(sizeof(lv), ABISELECT(1968,1960), "sizeof(S12863C45)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S12863C45)");
    check_field_offset(lv, s12863c45f0, 0, "S12863C45.s12863c45f0");
    check_field_offset(lv, s12863c45f1, 1, "S12863C45.s12863c45f1");
    check_field_offset(lv, s12863c45f2, 8, "S12863C45.s12863c45f2");
    check_field_offset(lv, s12863c45f3, ABISELECT(16,12), "S12863C45.s12863c45f3");
    check_field_offset(lv, s12863c45f4, ABISELECT(20,16), "S12863C45.s12863c45f4");
    check_field_offset(lv, s12863c45f5, ABISELECT(48,44), "S12863C45.s12863c45f5");
  }
}
static Arrange_To_Call_Me vS12863C45(Test_S12863C45, "S12863C45", ABISELECT(1968,1960));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C46  {
  char s12863c46f0;
  int s12863c46f1;
  ::S12863C29 s12863c46f2;
  long s12863c46f3;
  int s12863c46f4;
  ::S12863C38 s12863c46f5;
  ::S12863C39 s12863c46f6;
};
//SIG(1 S12863C46) C1{ Fc Fi FC2{ Fc[7]} Fl Fi FC3{ Fi Fc Fi[2] Fc Fi Fc} FC4{ Fc FC5{ Fi FU6{ FC7{ Fc Fc Fc} FC8{ Fi Fi Fc} FC9{ Fc Fc} FC10{ Fs Fs} FC11{ Fs Fc Fc} FC12{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC9 FC13{ Fc Fc Fc[128]} FC14{ Fc Fc} FC15{ Fc Fc[128]} FC16{ Fc Fc[32]} FC15 FC16 FC17{ Fc Fc Fc Fc[134]} FC18{ Fc} FC19{ FC20{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC18 FC21{ Fi} FC21 FC22{ Fi Fc Fc[226]}}}[7] Fs Fc[255]}}



static void Test_S12863C46()
{
  {
    init_simple_test("S12863C46");
    S12863C46 lv;
    check2(sizeof(lv), ABISELECT(1976,1968), "sizeof(S12863C46)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S12863C46)");
    check_field_offset(lv, s12863c46f0, 0, "S12863C46.s12863c46f0");
    check_field_offset(lv, s12863c46f1, 4, "S12863C46.s12863c46f1");
    check_field_offset(lv, s12863c46f2, 8, "S12863C46.s12863c46f2");
    check_field_offset(lv, s12863c46f3, 16, "S12863C46.s12863c46f3");
    check_field_offset(lv, s12863c46f4, ABISELECT(24,20), "S12863C46.s12863c46f4");
    check_field_offset(lv, s12863c46f5, ABISELECT(28,24), "S12863C46.s12863c46f5");
    check_field_offset(lv, s12863c46f6, ABISELECT(56,52), "S12863C46.s12863c46f6");
  }
}
static Arrange_To_Call_Me vS12863C46(Test_S12863C46, "S12863C46", ABISELECT(1976,1968));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C47  {
  char s12863c47f0;
  char s12863c47f1;
  char s12863c47f2;
  long s12863c47f3;
  ::S12863C31 s12863c47f4;
  ::S12863C29 s12863c47f5;
  ::S12863C29 s12863c47f6;
  int s12863c47f7;
  long s12863c47f8;
  int s12863c47f9;
  ::S12863C38 s12863c47f10;
  ::S12863C39 s12863c47f11;
};
//SIG(1 S12863C47) C1{ Fc[3] Fl FC2{ Fi[4] Fc[49]} FC3{ Fc[7]} FC3 Fi Fl Fi FC4{ Fi Fc Fi[2] Fc Fi Fc} FC5{ Fc FC6{ Fi FU7{ FC8{ Fc Fc Fc} FC9{ Fi Fi Fc} FC10{ Fc Fc} FC11{ Fs Fs} FC12{ Fs Fc Fc} FC13{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC10 FC14{ Fc Fc Fc[128]} FC15{ Fc Fc} FC16{ Fc Fc[128]} FC17{ Fc Fc[32]} FC16 FC17 FC18{ Fc Fc Fc Fc[134]} FC19{ Fc} FC20{ FC21{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC19 FC22{ Fi} FC22 FC23{ Fi Fc Fc[226]}}}[7] Fs Fc[255]}}



static void Test_S12863C47()
{
  {
    init_simple_test("S12863C47");
    S12863C47 lv;
    check2(sizeof(lv), ABISELECT(2064,2048), "sizeof(S12863C47)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S12863C47)");
    check_field_offset(lv, s12863c47f0, 0, "S12863C47.s12863c47f0");
    check_field_offset(lv, s12863c47f1, 1, "S12863C47.s12863c47f1");
    check_field_offset(lv, s12863c47f2, 2, "S12863C47.s12863c47f2");
    check_field_offset(lv, s12863c47f3, ABISELECT(8,4), "S12863C47.s12863c47f3");
    check_field_offset(lv, s12863c47f4, ABISELECT(16,8), "S12863C47.s12863c47f4");
    check_field_offset(lv, s12863c47f5, ABISELECT(84,76), "S12863C47.s12863c47f5");
    check_field_offset(lv, s12863c47f6, ABISELECT(91,83), "S12863C47.s12863c47f6");
    check_field_offset(lv, s12863c47f7, ABISELECT(100,92), "S12863C47.s12863c47f7");
    check_field_offset(lv, s12863c47f8, ABISELECT(104,96), "S12863C47.s12863c47f8");
    check_field_offset(lv, s12863c47f9, ABISELECT(112,100), "S12863C47.s12863c47f9");
    check_field_offset(lv, s12863c47f10, ABISELECT(116,104), "S12863C47.s12863c47f10");
    check_field_offset(lv, s12863c47f11, ABISELECT(144,132), "S12863C47.s12863c47f11");
  }
}
static Arrange_To_Call_Me vS12863C47(Test_S12863C47, "S12863C47", ABISELECT(2064,2048));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C48  {
  char s12863c48f0;
  char s12863c48f1;
  long s12863c48f2;
  int s12863c48f3;
  int s12863c48f4;
  long s12863c48f5;
  ::S12863C31 s12863c48f6;
  char s12863c48f7;
  char s12863c48f8[157];
};
//SIG(1 S12863C48) C1{ Fc[2] Fl Fi[2] Fl FC2{ Fi[4] Fc[49]} Fc[158]}



static void Test_S12863C48()
{
  {
    init_simple_test("S12863C48");
    S12863C48 lv;
    check2(sizeof(lv), ABISELECT(264,248), "sizeof(S12863C48)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S12863C48)");
    check_field_offset(lv, s12863c48f0, 0, "S12863C48.s12863c48f0");
    check_field_offset(lv, s12863c48f1, 1, "S12863C48.s12863c48f1");
    check_field_offset(lv, s12863c48f2, ABISELECT(8,4), "S12863C48.s12863c48f2");
    check_field_offset(lv, s12863c48f3, ABISELECT(16,8), "S12863C48.s12863c48f3");
    check_field_offset(lv, s12863c48f4, ABISELECT(20,12), "S12863C48.s12863c48f4");
    check_field_offset(lv, s12863c48f5, ABISELECT(24,16), "S12863C48.s12863c48f5");
    check_field_offset(lv, s12863c48f6, ABISELECT(32,20), "S12863C48.s12863c48f6");
    check_field_offset(lv, s12863c48f7, ABISELECT(100,88), "S12863C48.s12863c48f7");
    check_field_offset(lv, s12863c48f8, ABISELECT(101,89), "S12863C48.s12863c48f8");
  }
}
static Arrange_To_Call_Me vS12863C48(Test_S12863C48, "S12863C48", ABISELECT(264,248));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S12863C36  {
  ::S12863C37 s12863c36f0;
  ::S12863C40 s12863c36f1;
  ::S12863C41 s12863c36f2;
  ::S12863C42 s12863c36f3;
  ::S12863C45 s12863c36f4;
  ::S12863C46 s12863c36f5;
  ::S12863C47 s12863c36f6;
  ::S12863C48 s12863c36f7;
};
//SIG(1 S12863C36) U1{ FC2{ Fc Fc Fc Fc FC3{ Fi Fi Fi Fi Fc Fc[48]} Fi FC4{ Fi Fc Fi Fi Fc Fi Fc} FC5{ Fc Fc Fc Fc Fc Fc Fc} FC6{ Fc FC7{ Fi FU8{ FC9{ Fc Fc Fc} FC10{ Fi Fi Fc} FC11{ Fc Fc} FC12{ Fs Fs} FC13{ Fs Fc Fc} FC14{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC11 FC15{ Fc Fc Fc[128]} FC16{ Fc Fc} FC17{ Fc Fc[128]} FC18{ Fc Fc[32]} FC17 FC18 FC19{ Fc Fc Fc Fc[134]} FC20{ Fc} FC21{ FC22{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC20 FC23{ Fi} FC23 FC24{ Fi Fc Fc[226]}}}[7] Fs Fc[255]}} FC25{ Fc Fl Fi FC4 FC6} FC26{ Fc Fi Fl Fi FC4 FC6} FC27{ Fc Fc Fc Fc Fl FC3 Fi FC4 FC28{ Fi FU29{ FC5}} FC6} FC30{ Fc FC5 Fl Fi FC4 FC6} FC31{ Fc Fi FC5 Fl Fi FC4 FC6} FC32{ Fc Fc Fc Fl FC3 FC5 FC5 Fi Fl Fi FC4 FC6} FC33{ Fc Fc Fl Fi Fi Fl FC3 Fc Fc[157]}}

#endif // __cplusplus
#ifdef __cplusplus

struct  S12863C35  {
  int s12863c35f0;
  ::S12863C36 s12863c35f1;
};
//SIG(1 S12863C35) C1{ Fi FU2{ FC3{ Fc Fc Fc Fc FC4{ Fi Fi Fi Fi Fc Fc[48]} Fi FC5{ Fi Fc Fi Fi Fc Fi Fc} FC6{ Fc Fc Fc Fc Fc Fc Fc} FC7{ Fc FC8{ Fi FU9{ FC10{ Fc Fc Fc} FC11{ Fi Fi Fc} FC12{ Fc Fc} FC13{ Fs Fs} FC14{ Fs Fc Fc} FC15{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC12 FC16{ Fc Fc Fc[128]} FC17{ Fc Fc} FC18{ Fc Fc[128]} FC19{ Fc Fc[32]} FC18 FC19 FC20{ Fc Fc Fc Fc[134]} FC21{ Fc} FC22{ FC23{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC21 FC24{ Fi} FC24 FC25{ Fi Fc Fc[226]}}}[7] Fs Fc[255]}} FC26{ Fc Fl Fi FC5 FC7} FC27{ Fc Fi Fl Fi FC5 FC7} FC28{ Fc Fc Fc Fc Fl FC4 Fi FC5 FC29{ Fi FU30{ FC6}} FC7} FC31{ Fc FC6 Fl Fi FC5 FC7} FC32{ Fc Fi FC6 Fl Fi FC5 FC7} FC33{ Fc Fc Fc Fl FC4 FC6 FC6 Fi Fl Fi FC5 FC7} FC34{ Fc Fc Fl Fi Fi Fl FC4 Fc Fc[157]}}}



static void Test_S12863C35()
{
  {
    init_simple_test("S12863C35");
    S12863C35 lv;
    check2(sizeof(lv), ABISELECT(2072,2052), "sizeof(S12863C35)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S12863C35)");
    check_field_offset(lv, s12863c35f0, 0, "S12863C35.s12863c35f0");
    check_field_offset(lv, s12863c35f1, ABISELECT(8,4), "S12863C35.s12863c35f1");
  }
}
static Arrange_To_Call_Me vS12863C35(Test_S12863C35, "S12863C35", ABISELECT(2072,2052));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C51  {
  int s12863c51f0;
  int s12863c51f1;
  char s12863c51f2;
  int s12863c51f3;
  int s12863c51f4;
  char s12863c51f5[3];
  char s12863c51f6;
  char s12863c51f7;
};
//SIG(-1 S12863C51) C1{ Fi[2] Fc Fi[2] Fc[5]}



static void Test_S12863C51()
{
  {
    init_simple_test("S12863C51");
    S12863C51 lv;
    check2(sizeof(lv), 28, "sizeof(S12863C51)");
    check2(__alignof__(lv), 4, "__alignof__(S12863C51)");
    check_field_offset(lv, s12863c51f0, 0, "S12863C51.s12863c51f0");
    check_field_offset(lv, s12863c51f1, 4, "S12863C51.s12863c51f1");
    check_field_offset(lv, s12863c51f2, 8, "S12863C51.s12863c51f2");
    check_field_offset(lv, s12863c51f3, 12, "S12863C51.s12863c51f3");
    check_field_offset(lv, s12863c51f4, 16, "S12863C51.s12863c51f4");
    check_field_offset(lv, s12863c51f5, 20, "S12863C51.s12863c51f5");
    check_field_offset(lv, s12863c51f6, 23, "S12863C51.s12863c51f6");
    check_field_offset(lv, s12863c51f7, 24, "S12863C51.s12863c51f7");
  }
}
static Arrange_To_Call_Me vS12863C51(Test_S12863C51, "S12863C51", 28);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C50  {
  short s12863c50f0;
  ::S12863C51 s12863c50f1;
  char s12863c50f2;
  char s12863c50f3;
  int s12863c50f4;
  short s12863c50f5;
  char s12863c50f6;
  short s12863c50f7;
};
//SIG(-1 S12863C50) C1{ Fs FC2{ Fi[2] Fc Fi[2] Fc[5]} Fc[2] Fi Fs Fc Fs}



static void Test_S12863C50()
{
  {
    init_simple_test("S12863C50");
    S12863C50 lv;
    check2(sizeof(lv), 48, "sizeof(S12863C50)");
    check2(__alignof__(lv), 4, "__alignof__(S12863C50)");
    check_field_offset(lv, s12863c50f0, 0, "S12863C50.s12863c50f0");
    check_field_offset(lv, s12863c50f1, 4, "S12863C50.s12863c50f1");
    check_field_offset(lv, s12863c50f2, 32, "S12863C50.s12863c50f2");
    check_field_offset(lv, s12863c50f3, 33, "S12863C50.s12863c50f3");
    check_field_offset(lv, s12863c50f4, 36, "S12863C50.s12863c50f4");
    check_field_offset(lv, s12863c50f5, 40, "S12863C50.s12863c50f5");
    check_field_offset(lv, s12863c50f6, 42, "S12863C50.s12863c50f6");
    check_field_offset(lv, s12863c50f7, 44, "S12863C50.s12863c50f7");
  }
}
static Arrange_To_Call_Me vS12863C50(Test_S12863C50, "S12863C50", 48);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12863C49  {
  ::S12863C50 s12863c49f0;
  ::S12863C39 s12863c49f1;
};
//SIG(1 S12863C49) C1{ FC2{ Fs FC3{ Fi[2] Fc Fi[2] Fc[5]} Fc[2] Fi Fs Fc Fs} FC4{ Fc FC5{ Fi FU6{ FC7{ Fc Fc Fc} FC8{ Fi Fi Fc} FC9{ Fc Fc} FC10{ Fs Fs} FC11{ Fs Fc Fc} FC12{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC9 FC13{ Fc Fc Fc[128]} FC14{ Fc Fc} FC15{ Fc Fc[128]} FC16{ Fc Fc[32]} FC15 FC16 FC17{ Fc Fc Fc Fc[134]} FC18{ Fc} FC19{ FC20{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC18 FC21{ Fi} FC21 FC22{ Fi Fc Fc[226]}}}[7] Fs Fc[255]}}



static void Test_S12863C49()
{
  {
    init_simple_test("S12863C49");
    S12863C49 lv;
    check2(sizeof(lv), 1964, "sizeof(S12863C49)");
    check2(__alignof__(lv), 4, "__alignof__(S12863C49)");
    check_field_offset(lv, s12863c49f0, 0, "S12863C49.s12863c49f0");
    check_field_offset(lv, s12863c49f1, 48, "S12863C49.s12863c49f1");
  }
}
static Arrange_To_Call_Me vS12863C49(Test_S12863C49, "S12863C49", 1964);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S12863C2  {
  ::S12863C3 s12863c2f0;
  ::S12863C35 s12863c2f1;
  ::S12863C49 s12863c2f2;
};
//SIG(1 S12863C2) U1{ FC2{ Fl FC3{ Fi Fl Fc} FC4{ Fc FC5{ Fi FU6{ FC7{ Fc Fc Fc} FC8{ Fi Fi Fc} FC9{ Fc Fc} FC10{ Fs Fs} FC11{ Fs Fc Fc} FC12{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC9 FC13{ Fc Fc Fc[128]} FC14{ Fc Fc} FC15{ Fc Fc[128]} FC16{ Fc Fc[32]} FC15 FC16 FC17{ Fc Fc Fc Fc[134]} FC18{ Fc} FC19{ FC20{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC18 FC21{ Fi} FC21 FC22{ Fi Fc Fc[226]}}}[7] Fi Fi Fc Fc Fc[229] Fc} Fc FC23{ Fc Fc Fc Fc Fc Fc Fc} FC23 FC23 FC23 FC23 Fi Fi FC7 Fc Fi Fi FC24{ Fi Fi Fi Fi Fc Fc[48]} Fi Fi FC25{ Fi Fi} Fl Fp Fp FC26{ Fc[4] Fc} Fc FC27{ Fc Fc Fp}} FC28{ Fi FU29{ FC30{ Fc Fc Fc Fc FC24 Fi FC31{ Fi Fc Fi Fi Fc Fi Fc} FC23 FC32{ Fc FC5[7] Fs Fc[255]}} FC33{ Fc Fl Fi FC31 FC32} FC34{ Fc Fi Fl Fi FC31 FC32} FC35{ Fc Fc Fc Fc Fl FC24 Fi FC31 FC36{ Fi FU37{ FC23}} FC32} FC38{ Fc FC23 Fl Fi FC31 FC32} FC39{ Fc Fi FC23 Fl Fi FC31 FC32} FC40{ Fc Fc Fc Fl FC24 FC23 FC23 Fi Fl Fi FC31 FC32} FC41{ Fc Fc Fl Fi Fi Fl FC24 Fc Fc[157]}}} FC42{ FC43{ Fs FC44{ Fi Fi Fc Fi Fi Fc[3] Fc Fc} Fc Fc Fi Fs Fc Fs} FC32}}

#endif // __cplusplus
#ifdef __cplusplus

struct  S12863C1  {
  int s12863c1f0;
  ::S12863C2 s12863c1f1;
};
//SIG(1 S12863C1) C1{ Fi FU2{ FC3{ Fl FC4{ Fi Fl Fc} FC5{ Fc FC6{ Fi FU7{ FC8{ Fc Fc Fc} FC9{ Fi Fi Fc} FC10{ Fc Fc} FC11{ Fs Fs} FC12{ Fs Fc Fc} FC13{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC10 FC14{ Fc Fc Fc[128]} FC15{ Fc Fc} FC16{ Fc Fc[128]} FC17{ Fc Fc[32]} FC16 FC17 FC18{ Fc Fc Fc Fc[134]} FC19{ Fc} FC20{ FC21{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC19 FC22{ Fi} FC22 FC23{ Fi Fc Fc[226]}}}[7] Fi Fi Fc Fc Fc[229] Fc} Fc FC24{ Fc Fc Fc Fc Fc Fc Fc} FC24 FC24 FC24 FC24 Fi Fi FC8 Fc Fi Fi FC25{ Fi Fi Fi Fi Fc Fc[48]} Fi Fi FC26{ Fi Fi} Fl Fp Fp FC27{ Fc[4] Fc} Fc FC28{ Fc Fc Fp}} FC29{ Fi FU30{ FC31{ Fc Fc Fc Fc FC25 Fi FC32{ Fi Fc Fi Fi Fc Fi Fc} FC24 FC33{ Fc FC6[7] Fs Fc[255]}} FC34{ Fc Fl Fi FC32 FC33} FC35{ Fc Fi Fl Fi FC32 FC33} FC36{ Fc Fc Fc Fc Fl FC25 Fi FC32 FC37{ Fi FU38{ FC24}} FC33} FC39{ Fc FC24 Fl Fi FC32 FC33} FC40{ Fc Fi FC24 Fl Fi FC32 FC33} FC41{ Fc Fc Fc Fl FC25 FC24 FC24 Fi Fl Fi FC32 FC33} FC42{ Fc Fc Fl Fi Fi Fl FC25 Fc Fc[157]}}} FC43{ FC44{ Fs FC45{ Fi Fi Fc Fi Fi Fc[3] Fc Fc} Fc Fc Fi Fs Fc Fs} FC33}}}



static void Test_S12863C1()
{
  {
    init_simple_test("S12863C1");
    S12863C1 lv;
    check2(sizeof(lv), ABISELECT(2128,2084), "sizeof(S12863C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S12863C1)");
    check_field_offset(lv, s12863c1f0, 0, "S12863C1.s12863c1f0");
    check_field_offset(lv, s12863c1f1, ABISELECT(8,4), "S12863C1.s12863c1f1");
  }
}
static Arrange_To_Call_Me vS12863C1(Test_S12863C1, "S12863C1", ABISELECT(2128,2084));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S244C6  {
  int s244c6f0;
  __tsi64 s244c6f1;
  void *s244c6f2[4];
  int s244c6f3[2];
  void *s244c6f4;
  ::S3443C4_nt s244c6f5;
  void *s244c6f6[2];
  virtual  ~S244C6(); // _ZN6S244C6D1Ev
  virtual void  v5(); // _ZN6S244C62v5Ev
  virtual void  v6(); // _ZN6S244C62v6Ev
  virtual void  v7(); // _ZN6S244C62v7Ev
  virtual void  v8(); // _ZN6S244C62v8Ev
  virtual void  v9(); // _ZN6S244C62v9Ev
  virtual void  v10(); // _ZN6S244C63v10Ev
  virtual void  v11(); // _ZN6S244C63v11Ev
  virtual void  v12(); // _ZN6S244C63v12Ev
  virtual void  v13(); // _ZN6S244C63v13Ev
  virtual void  v14(); // _ZN6S244C63v14Ev
  virtual void  v15(); // _ZN6S244C63v15Ev
  virtual void  v16(); // _ZN6S244C63v16Ev
  virtual void  v17(); // _ZN6S244C63v17Ev
  virtual void  v18(); // _ZN6S244C63v18Ev
  virtual void  v19(); // _ZN6S244C63v19Ev
  virtual void  v20(); // _ZN6S244C63v20Ev
  virtual void  v21(); // _ZN6S244C63v21Ev
  virtual void  v22(); // _ZN6S244C63v22Ev
  virtual void  v23(); // _ZN6S244C63v23Ev
  virtual void  v24(); // _ZN6S244C63v24Ev
  virtual void  v25(); // _ZN6S244C63v25Ev
  virtual void  v26(); // _ZN6S244C63v26Ev
  virtual void  v27(); // _ZN6S244C63v27Ev
  virtual void  v28(); // _ZN6S244C63v28Ev
  virtual void  v29(); // _ZN6S244C63v29Ev
  virtual void  v30(); // _ZN6S244C63v30Ev
  virtual void  v31(); // _ZN6S244C63v31Ev
  virtual void  v32(); // _ZN6S244C63v32Ev
  virtual void  v33(); // _ZN6S244C63v33Ev
  virtual void  v34(); // _ZN6S244C63v34Ev
  virtual void  v35(); // _ZN6S244C63v35Ev
  virtual void  v36(); // _ZN6S244C63v36Ev
  virtual void  v37(); // _ZN6S244C63v37Ev
  virtual void  v38(); // _ZN6S244C63v38Ev
  virtual void  v39(); // _ZN6S244C63v39Ev
  virtual void  v40(); // _ZN6S244C63v40Ev
  virtual void  v41(); // _ZN6S244C63v41Ev
  virtual void  v42(); // _ZN6S244C63v42Ev
  virtual void  v43(); // _ZN6S244C63v43Ev
  virtual void  v44(); // _ZN6S244C63v44Ev
  virtual void  v45(); // _ZN6S244C63v45Ev
  virtual void  v46(); // _ZN6S244C63v46Ev
  virtual void  v47(); // _ZN6S244C63v47Ev
  virtual void  v48(); // _ZN6S244C63v48Ev
  virtual void  v49(); // _ZN6S244C63v49Ev
  virtual void  v50(); // _ZN6S244C63v50Ev
  virtual void  v51(); // _ZN6S244C63v51Ev
  virtual void  v52(); // _ZN6S244C63v52Ev
  virtual void  v53(); // _ZN6S244C63v53Ev
  virtual void  v54(); // _ZN6S244C63v54Ev
  virtual void  v55(); // _ZN6S244C63v55Ev
  virtual void  v56(); // _ZN6S244C63v56Ev
  virtual void  v57(); // _ZN6S244C63v57Ev
  virtual void  v58(); // _ZN6S244C63v58Ev
  virtual void  v59(); // _ZN6S244C63v59Ev
  virtual void  v60(); // _ZN6S244C63v60Ev
  virtual void  v61(); // _ZN6S244C63v61Ev
  virtual void  v62(); // _ZN6S244C63v62Ev
  virtual void  v63(); // _ZN6S244C63v63Ev
  virtual void  v64(); // _ZN6S244C63v64Ev
  virtual void  v65(); // _ZN6S244C63v65Ev
  virtual void  v66(); // _ZN6S244C63v66Ev
  virtual void  v67(); // _ZN6S244C63v67Ev
  virtual void  v68(); // _ZN6S244C63v68Ev
  S244C6(); // tgen
};
//SIG(-1 S244C6) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S244C6 ::~S244C6(){ note_dtor("S244C6", this);}
void  S244C6 ::v5(){vfunc_called(this, "_ZN6S244C62v5Ev");}
void  S244C6 ::v6(){vfunc_called(this, "_ZN6S244C62v6Ev");}
void  S244C6 ::v7(){vfunc_called(this, "_ZN6S244C62v7Ev");}
void  S244C6 ::v8(){vfunc_called(this, "_ZN6S244C62v8Ev");}
void  S244C6 ::v9(){vfunc_called(this, "_ZN6S244C62v9Ev");}
void  S244C6 ::v10(){vfunc_called(this, "_ZN6S244C63v10Ev");}
void  S244C6 ::v11(){vfunc_called(this, "_ZN6S244C63v11Ev");}
void  S244C6 ::v12(){vfunc_called(this, "_ZN6S244C63v12Ev");}
void  S244C6 ::v13(){vfunc_called(this, "_ZN6S244C63v13Ev");}
void  S244C6 ::v14(){vfunc_called(this, "_ZN6S244C63v14Ev");}
void  S244C6 ::v15(){vfunc_called(this, "_ZN6S244C63v15Ev");}
void  S244C6 ::v16(){vfunc_called(this, "_ZN6S244C63v16Ev");}
void  S244C6 ::v17(){vfunc_called(this, "_ZN6S244C63v17Ev");}
void  S244C6 ::v18(){vfunc_called(this, "_ZN6S244C63v18Ev");}
void  S244C6 ::v19(){vfunc_called(this, "_ZN6S244C63v19Ev");}
void  S244C6 ::v20(){vfunc_called(this, "_ZN6S244C63v20Ev");}
void  S244C6 ::v21(){vfunc_called(this, "_ZN6S244C63v21Ev");}
void  S244C6 ::v22(){vfunc_called(this, "_ZN6S244C63v22Ev");}
void  S244C6 ::v23(){vfunc_called(this, "_ZN6S244C63v23Ev");}
void  S244C6 ::v24(){vfunc_called(this, "_ZN6S244C63v24Ev");}
void  S244C6 ::v25(){vfunc_called(this, "_ZN6S244C63v25Ev");}
void  S244C6 ::v26(){vfunc_called(this, "_ZN6S244C63v26Ev");}
void  S244C6 ::v27(){vfunc_called(this, "_ZN6S244C63v27Ev");}
void  S244C6 ::v28(){vfunc_called(this, "_ZN6S244C63v28Ev");}
void  S244C6 ::v29(){vfunc_called(this, "_ZN6S244C63v29Ev");}
void  S244C6 ::v30(){vfunc_called(this, "_ZN6S244C63v30Ev");}
void  S244C6 ::v31(){vfunc_called(this, "_ZN6S244C63v31Ev");}
void  S244C6 ::v32(){vfunc_called(this, "_ZN6S244C63v32Ev");}
void  S244C6 ::v33(){vfunc_called(this, "_ZN6S244C63v33Ev");}
void  S244C6 ::v34(){vfunc_called(this, "_ZN6S244C63v34Ev");}
void  S244C6 ::v35(){vfunc_called(this, "_ZN6S244C63v35Ev");}
void  S244C6 ::v36(){vfunc_called(this, "_ZN6S244C63v36Ev");}
void  S244C6 ::v37(){vfunc_called(this, "_ZN6S244C63v37Ev");}
void  S244C6 ::v38(){vfunc_called(this, "_ZN6S244C63v38Ev");}
void  S244C6 ::v39(){vfunc_called(this, "_ZN6S244C63v39Ev");}
void  S244C6 ::v40(){vfunc_called(this, "_ZN6S244C63v40Ev");}
void  S244C6 ::v41(){vfunc_called(this, "_ZN6S244C63v41Ev");}
void  S244C6 ::v42(){vfunc_called(this, "_ZN6S244C63v42Ev");}
void  S244C6 ::v43(){vfunc_called(this, "_ZN6S244C63v43Ev");}
void  S244C6 ::v44(){vfunc_called(this, "_ZN6S244C63v44Ev");}
void  S244C6 ::v45(){vfunc_called(this, "_ZN6S244C63v45Ev");}
void  S244C6 ::v46(){vfunc_called(this, "_ZN6S244C63v46Ev");}
void  S244C6 ::v47(){vfunc_called(this, "_ZN6S244C63v47Ev");}
void  S244C6 ::v48(){vfunc_called(this, "_ZN6S244C63v48Ev");}
void  S244C6 ::v49(){vfunc_called(this, "_ZN6S244C63v49Ev");}
void  S244C6 ::v50(){vfunc_called(this, "_ZN6S244C63v50Ev");}
void  S244C6 ::v51(){vfunc_called(this, "_ZN6S244C63v51Ev");}
void  S244C6 ::v52(){vfunc_called(this, "_ZN6S244C63v52Ev");}
void  S244C6 ::v53(){vfunc_called(this, "_ZN6S244C63v53Ev");}
void  S244C6 ::v54(){vfunc_called(this, "_ZN6S244C63v54Ev");}
void  S244C6 ::v55(){vfunc_called(this, "_ZN6S244C63v55Ev");}
void  S244C6 ::v56(){vfunc_called(this, "_ZN6S244C63v56Ev");}
void  S244C6 ::v57(){vfunc_called(this, "_ZN6S244C63v57Ev");}
void  S244C6 ::v58(){vfunc_called(this, "_ZN6S244C63v58Ev");}
void  S244C6 ::v59(){vfunc_called(this, "_ZN6S244C63v59Ev");}
void  S244C6 ::v60(){vfunc_called(this, "_ZN6S244C63v60Ev");}
void  S244C6 ::v61(){vfunc_called(this, "_ZN6S244C63v61Ev");}
void  S244C6 ::v62(){vfunc_called(this, "_ZN6S244C63v62Ev");}
void  S244C6 ::v63(){vfunc_called(this, "_ZN6S244C63v63Ev");}
void  S244C6 ::v64(){vfunc_called(this, "_ZN6S244C63v64Ev");}
void  S244C6 ::v65(){vfunc_called(this, "_ZN6S244C63v65Ev");}
void  S244C6 ::v66(){vfunc_called(this, "_ZN6S244C63v66Ev");}
void  S244C6 ::v67(){vfunc_called(this, "_ZN6S244C63v67Ev");}
void  S244C6 ::v68(){vfunc_called(this, "_ZN6S244C63v68Ev");}
S244C6 ::S244C6(){ note_ctor("S244C6", this);} // tgen

static void Test_S244C6()
{
  extern Class_Descriptor cd_S244C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S244C6, buf);
    S244C6 *dp, &lv = *(dp=new (buf) S244C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S244C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S244C6)");
    check_field_offset(lv, s244c6f0, ABISELECT(8,4), "S244C6.s244c6f0");
    check_field_offset(lv, s244c6f1, ABISELECT(16,8), "S244C6.s244c6f1");
    check_field_offset(lv, s244c6f2, ABISELECT(24,16), "S244C6.s244c6f2");
    check_field_offset(lv, s244c6f3, ABISELECT(56,32), "S244C6.s244c6f3");
    check_field_offset(lv, s244c6f4, ABISELECT(64,40), "S244C6.s244c6f4");
    check_field_offset(lv, s244c6f5, ABISELECT(72,44), "S244C6.s244c6f5");
    check_field_offset(lv, s244c6f6, ABISELECT(80,52), "S244C6.s244c6f6");
    test_class_info(&lv, &cd_S244C6);
    dp->~S244C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS244C6(Test_S244C6, "S244C6", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S244C6C1Ev();
extern void _ZN6S244C6D1Ev();
Name_Map name_map_S244C6[] = {
  NSPAIR(_ZN6S244C6C1Ev),
  NSPAIR(_ZN6S244C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S244C6[];
extern void _ZN6S244C6D1Ev();
extern void _ZN6S244C6D0Ev();
extern void _ZN6S244C62v5Ev();
extern void _ZN6S244C62v6Ev();
extern void _ZN6S244C62v7Ev();
extern void _ZN6S244C62v8Ev();
extern void _ZN6S244C62v9Ev();
extern void _ZN6S244C63v10Ev();
extern void _ZN6S244C63v11Ev();
extern void _ZN6S244C63v12Ev();
extern void _ZN6S244C63v13Ev();
extern void _ZN6S244C63v14Ev();
extern void _ZN6S244C63v15Ev();
extern void _ZN6S244C63v16Ev();
extern void _ZN6S244C63v17Ev();
extern void _ZN6S244C63v18Ev();
extern void _ZN6S244C63v19Ev();
extern void _ZN6S244C63v20Ev();
extern void _ZN6S244C63v21Ev();
extern void _ZN6S244C63v22Ev();
extern void _ZN6S244C63v23Ev();
extern void _ZN6S244C63v24Ev();
extern void _ZN6S244C63v25Ev();
extern void _ZN6S244C63v26Ev();
extern void _ZN6S244C63v27Ev();
extern void _ZN6S244C63v28Ev();
extern void _ZN6S244C63v29Ev();
extern void _ZN6S244C63v30Ev();
extern void _ZN6S244C63v31Ev();
extern void _ZN6S244C63v32Ev();
extern void _ZN6S244C63v33Ev();
extern void _ZN6S244C63v34Ev();
extern void _ZN6S244C63v35Ev();
extern void _ZN6S244C63v36Ev();
extern void _ZN6S244C63v37Ev();
extern void _ZN6S244C63v38Ev();
extern void _ZN6S244C63v39Ev();
extern void _ZN6S244C63v40Ev();
extern void _ZN6S244C63v41Ev();
extern void _ZN6S244C63v42Ev();
extern void _ZN6S244C63v43Ev();
extern void _ZN6S244C63v44Ev();
extern void _ZN6S244C63v45Ev();
extern void _ZN6S244C63v46Ev();
extern void _ZN6S244C63v47Ev();
extern void _ZN6S244C63v48Ev();
extern void _ZN6S244C63v49Ev();
extern void _ZN6S244C63v50Ev();
extern void _ZN6S244C63v51Ev();
extern void _ZN6S244C63v52Ev();
extern void _ZN6S244C63v53Ev();
extern void _ZN6S244C63v54Ev();
extern void _ZN6S244C63v55Ev();
extern void _ZN6S244C63v56Ev();
extern void _ZN6S244C63v57Ev();
extern void _ZN6S244C63v58Ev();
extern void _ZN6S244C63v59Ev();
extern void _ZN6S244C63v60Ev();
extern void _ZN6S244C63v61Ev();
extern void _ZN6S244C63v62Ev();
extern void _ZN6S244C63v63Ev();
extern void _ZN6S244C63v64Ev();
extern void _ZN6S244C63v65Ev();
extern void _ZN6S244C63v66Ev();
extern void _ZN6S244C63v67Ev();
extern void _ZN6S244C63v68Ev();
static  VTBL_ENTRY vtc_S244C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S244C6[0]),
  (VTBL_ENTRY)&_ZN6S244C6D1Ev,
  (VTBL_ENTRY)&_ZN6S244C6D0Ev,
  (VTBL_ENTRY)&_ZN6S244C62v5Ev,
  (VTBL_ENTRY)&_ZN6S244C62v6Ev,
  (VTBL_ENTRY)&_ZN6S244C62v7Ev,
  (VTBL_ENTRY)&_ZN6S244C62v8Ev,
  (VTBL_ENTRY)&_ZN6S244C62v9Ev,
  (VTBL_ENTRY)&_ZN6S244C63v10Ev,
  (VTBL_ENTRY)&_ZN6S244C63v11Ev,
  (VTBL_ENTRY)&_ZN6S244C63v12Ev,
  (VTBL_ENTRY)&_ZN6S244C63v13Ev,
  (VTBL_ENTRY)&_ZN6S244C63v14Ev,
  (VTBL_ENTRY)&_ZN6S244C63v15Ev,
  (VTBL_ENTRY)&_ZN6S244C63v16Ev,
  (VTBL_ENTRY)&_ZN6S244C63v17Ev,
  (VTBL_ENTRY)&_ZN6S244C63v18Ev,
  (VTBL_ENTRY)&_ZN6S244C63v19Ev,
  (VTBL_ENTRY)&_ZN6S244C63v20Ev,
  (VTBL_ENTRY)&_ZN6S244C63v21Ev,
  (VTBL_ENTRY)&_ZN6S244C63v22Ev,
  (VTBL_ENTRY)&_ZN6S244C63v23Ev,
  (VTBL_ENTRY)&_ZN6S244C63v24Ev,
  (VTBL_ENTRY)&_ZN6S244C63v25Ev,
  (VTBL_ENTRY)&_ZN6S244C63v26Ev,
  (VTBL_ENTRY)&_ZN6S244C63v27Ev,
  (VTBL_ENTRY)&_ZN6S244C63v28Ev,
  (VTBL_ENTRY)&_ZN6S244C63v29Ev,
  (VTBL_ENTRY)&_ZN6S244C63v30Ev,
  (VTBL_ENTRY)&_ZN6S244C63v31Ev,
  (VTBL_ENTRY)&_ZN6S244C63v32Ev,
  (VTBL_ENTRY)&_ZN6S244C63v33Ev,
  (VTBL_ENTRY)&_ZN6S244C63v34Ev,
  (VTBL_ENTRY)&_ZN6S244C63v35Ev,
  (VTBL_ENTRY)&_ZN6S244C63v36Ev,
  (VTBL_ENTRY)&_ZN6S244C63v37Ev,
  (VTBL_ENTRY)&_ZN6S244C63v38Ev,
  (VTBL_ENTRY)&_ZN6S244C63v39Ev,
  (VTBL_ENTRY)&_ZN6S244C63v40Ev,
  (VTBL_ENTRY)&_ZN6S244C63v41Ev,
  (VTBL_ENTRY)&_ZN6S244C63v42Ev,
  (VTBL_ENTRY)&_ZN6S244C63v43Ev,
  (VTBL_ENTRY)&_ZN6S244C63v44Ev,
  (VTBL_ENTRY)&_ZN6S244C63v45Ev,
  (VTBL_ENTRY)&_ZN6S244C63v46Ev,
  (VTBL_ENTRY)&_ZN6S244C63v47Ev,
  (VTBL_ENTRY)&_ZN6S244C63v48Ev,
  (VTBL_ENTRY)&_ZN6S244C63v49Ev,
  (VTBL_ENTRY)&_ZN6S244C63v50Ev,
  (VTBL_ENTRY)&_ZN6S244C63v51Ev,
  (VTBL_ENTRY)&_ZN6S244C63v52Ev,
  (VTBL_ENTRY)&_ZN6S244C63v53Ev,
  (VTBL_ENTRY)&_ZN6S244C63v54Ev,
  (VTBL_ENTRY)&_ZN6S244C63v55Ev,
  (VTBL_ENTRY)&_ZN6S244C63v56Ev,
  (VTBL_ENTRY)&_ZN6S244C63v57Ev,
  (VTBL_ENTRY)&_ZN6S244C63v58Ev,
  (VTBL_ENTRY)&_ZN6S244C63v59Ev,
  (VTBL_ENTRY)&_ZN6S244C63v60Ev,
  (VTBL_ENTRY)&_ZN6S244C63v61Ev,
  (VTBL_ENTRY)&_ZN6S244C63v62Ev,
  (VTBL_ENTRY)&_ZN6S244C63v63Ev,
  (VTBL_ENTRY)&_ZN6S244C63v64Ev,
  (VTBL_ENTRY)&_ZN6S244C63v65Ev,
  (VTBL_ENTRY)&_ZN6S244C63v66Ev,
  (VTBL_ENTRY)&_ZN6S244C63v67Ev,
  (VTBL_ENTRY)&_ZN6S244C63v68Ev,
};
extern VTBL_ENTRY _ZTI6S244C6[];
extern  VTBL_ENTRY _ZTV6S244C6[];
Class_Descriptor cd_S244C6 = {  "S244C6", // class name
  0,0,//no base classes
  &(vtc_S244C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S244C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S244C6),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S244C10  : S3443C7_nt {
};
//SIG(-1 S244C10) C1{ BC2{ m Fp Fi[2]}}



static void Test_S244C10()
{
  extern Class_Descriptor cd_S244C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S244C10, buf);
    S244C10 &lv = *(new (buf) S244C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S244C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S244C10)");
    check_base_class_offset(lv, (S3443C7_nt*), 0, "S244C10");
    test_class_info(&lv, &cd_S244C10);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS244C10(Test_S244C10, "S244C10", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3443C7_nt;
static Base_Class bases_S244C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3443C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S244C10 = {  "S244C10", // class name
  bases_S244C10, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S244C9  : S244C10 {
};
//SIG(-1 S244C9) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S244C9()
{
  extern Class_Descriptor cd_S244C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S244C9, buf);
    S244C9 &lv = *(new (buf) S244C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S244C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S244C9)");
    check_base_class_offset(lv, (S3443C7_nt*)(S244C10*), 0, "S244C9");
    check_base_class_offset(lv, (S244C10*), 0, "S244C9");
    test_class_info(&lv, &cd_S244C9);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS244C9(Test_S244C9, "S244C9", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3443C7_nt;
extern Class_Descriptor cd_S244C10;
static Base_Class bases_S244C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3443C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S244C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S244C9 = {  "S244C9", // class name
  bases_S244C9, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S244C8_nt  : S244C9 {
};
//SIG(-1 S244C8_nt) C1{ BC2{ BC3{ BC4{ m Fp Fi[2]}}}}



//skip512 S244C8_nt

#else // __cplusplus

extern Class_Descriptor cd_S3443C7_nt;
extern Class_Descriptor cd_S244C10;
extern Class_Descriptor cd_S244C9;
static Base_Class bases_S244C8_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3443C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S244C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S244C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S244C5_nt  : S244C6 {
  int s244c5f0[2];
  void *s244c5f1;
  int s244c5f2[2];
  ::S244C8_nt s244c5f3;
  ::S244C8_nt s244c5f4;
  ::S2122C38 s244c5f5;
  ::S244C8_nt s244c5f6;
  unsigned int s244c5f7:1;
  unsigned int s244c5f8:1;
  unsigned int s244c5f9:1;
  unsigned int s244c5f10:1;
  unsigned int s244c5f11:1;
  int s244c5f12[2];
  virtual  ~S244C5_nt(); // _ZN9S244C5_ntD1Ev
  virtual void  v69(); // _ZN9S244C5_nt3v69Ev
  virtual void  v70(); // _ZN9S244C5_nt3v70Ev
  virtual void  v71(); // _ZN9S244C5_nt3v71Ev
  virtual void  v72(); // _ZN9S244C5_nt3v72Ev
  virtual void  v73(); // _ZN9S244C5_nt3v73Ev
  virtual void  v74(); // _ZN9S244C5_nt3v74Ev
  virtual void  v75(); // _ZN9S244C5_nt3v75Ev
  virtual void  v76(); // _ZN9S244C5_nt3v76Ev
  virtual void  v77(); // _ZN9S244C5_nt3v77Ev
  virtual void  v78(); // _ZN9S244C5_nt3v78Ev
  virtual void  v79(); // _ZN9S244C5_nt3v79Ev
  virtual void  v80(); // _ZN9S244C5_nt3v80Ev
  virtual void  v81(); // _ZN9S244C5_nt3v81Ev
  virtual void  v82(); // _ZN9S244C5_nt3v82Ev
  virtual void  v83(); // _ZN9S244C5_nt3v83Ev
  virtual void  v84(); // _ZN9S244C5_nt3v84Ev
  virtual void  v85(); // _ZN9S244C5_nt3v85Ev
  virtual void  v86(); // _ZN9S244C5_nt3v86Ev
  virtual void  v87(); // _ZN9S244C5_nt3v87Ev
  virtual void  v88(); // _ZN9S244C5_nt3v88Ev
  virtual void  v89(); // _ZN9S244C5_nt3v89Ev
  virtual void  v90(); // _ZN9S244C5_nt3v90Ev
  S244C5_nt(); // tgen
};
//SIG(-1 S244C5_nt) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S244C5_nt ::~S244C5_nt(){ note_dtor("S244C5_nt", this);}
void  S244C5_nt ::v69(){vfunc_called(this, "_ZN9S244C5_nt3v69Ev");}
void  S244C5_nt ::v70(){vfunc_called(this, "_ZN9S244C5_nt3v70Ev");}
void  S244C5_nt ::v71(){vfunc_called(this, "_ZN9S244C5_nt3v71Ev");}
void  S244C5_nt ::v72(){vfunc_called(this, "_ZN9S244C5_nt3v72Ev");}
void  S244C5_nt ::v73(){vfunc_called(this, "_ZN9S244C5_nt3v73Ev");}
void  S244C5_nt ::v74(){vfunc_called(this, "_ZN9S244C5_nt3v74Ev");}
void  S244C5_nt ::v75(){vfunc_called(this, "_ZN9S244C5_nt3v75Ev");}
void  S244C5_nt ::v76(){vfunc_called(this, "_ZN9S244C5_nt3v76Ev");}
void  S244C5_nt ::v77(){vfunc_called(this, "_ZN9S244C5_nt3v77Ev");}
void  S244C5_nt ::v78(){vfunc_called(this, "_ZN9S244C5_nt3v78Ev");}
void  S244C5_nt ::v79(){vfunc_called(this, "_ZN9S244C5_nt3v79Ev");}
void  S244C5_nt ::v80(){vfunc_called(this, "_ZN9S244C5_nt3v80Ev");}
void  S244C5_nt ::v81(){vfunc_called(this, "_ZN9S244C5_nt3v81Ev");}
void  S244C5_nt ::v82(){vfunc_called(this, "_ZN9S244C5_nt3v82Ev");}
void  S244C5_nt ::v83(){vfunc_called(this, "_ZN9S244C5_nt3v83Ev");}
void  S244C5_nt ::v84(){vfunc_called(this, "_ZN9S244C5_nt3v84Ev");}
void  S244C5_nt ::v85(){vfunc_called(this, "_ZN9S244C5_nt3v85Ev");}
void  S244C5_nt ::v86(){vfunc_called(this, "_ZN9S244C5_nt3v86Ev");}
void  S244C5_nt ::v87(){vfunc_called(this, "_ZN9S244C5_nt3v87Ev");}
void  S244C5_nt ::v88(){vfunc_called(this, "_ZN9S244C5_nt3v88Ev");}
void  S244C5_nt ::v89(){vfunc_called(this, "_ZN9S244C5_nt3v89Ev");}
void  S244C5_nt ::v90(){vfunc_called(this, "_ZN9S244C5_nt3v90Ev");}
S244C5_nt ::S244C5_nt(){ note_ctor("S244C5_nt", this);} // tgen

//skip512 S244C5_nt

#else // __cplusplus

extern void _ZN9S244C5_ntC1Ev();
extern void _ZN9S244C5_ntD1Ev();
Name_Map name_map_S244C5_nt[] = {
  NSPAIR(_ZN9S244C5_ntC1Ev),
  NSPAIR(_ZN9S244C5_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S244C6;
extern VTBL_ENTRY _ZTI6S244C6[];
extern  VTBL_ENTRY _ZTV6S244C6[];
static Base_Class bases_S244C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S244C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S244C5_nt[];
extern void _ZN9S244C5_ntD1Ev();
extern void _ZN9S244C5_ntD0Ev();
extern void _ZN6S244C62v5Ev();
extern void _ZN6S244C62v6Ev();
extern void _ZN6S244C62v7Ev();
extern void _ZN6S244C62v8Ev();
extern void _ZN6S244C62v9Ev();
extern void _ZN6S244C63v10Ev();
extern void _ZN6S244C63v11Ev();
extern void _ZN6S244C63v12Ev();
extern void _ZN6S244C63v13Ev();
extern void _ZN6S244C63v14Ev();
extern void _ZN6S244C63v15Ev();
extern void _ZN6S244C63v16Ev();
extern void _ZN6S244C63v17Ev();
extern void _ZN6S244C63v18Ev();
extern void _ZN6S244C63v19Ev();
extern void _ZN6S244C63v20Ev();
extern void _ZN6S244C63v21Ev();
extern void _ZN6S244C63v22Ev();
extern void _ZN6S244C63v23Ev();
extern void _ZN6S244C63v24Ev();
extern void _ZN6S244C63v25Ev();
extern void _ZN6S244C63v26Ev();
extern void _ZN6S244C63v27Ev();
extern void _ZN6S244C63v28Ev();
extern void _ZN6S244C63v29Ev();
extern void _ZN6S244C63v30Ev();
extern void _ZN6S244C63v31Ev();
extern void _ZN6S244C63v32Ev();
extern void _ZN6S244C63v33Ev();
extern void _ZN6S244C63v34Ev();
extern void _ZN6S244C63v35Ev();
extern void _ZN6S244C63v36Ev();
extern void _ZN6S244C63v37Ev();
extern void _ZN6S244C63v38Ev();
extern void _ZN6S244C63v39Ev();
extern void _ZN6S244C63v40Ev();
extern void _ZN6S244C63v41Ev();
extern void _ZN6S244C63v42Ev();
extern void _ZN6S244C63v43Ev();
extern void _ZN6S244C63v44Ev();
extern void _ZN6S244C63v45Ev();
extern void _ZN6S244C63v46Ev();
extern void _ZN6S244C63v47Ev();
extern void _ZN6S244C63v48Ev();
extern void _ZN6S244C63v49Ev();
extern void _ZN6S244C63v50Ev();
extern void _ZN6S244C63v51Ev();
extern void _ZN6S244C63v52Ev();
extern void _ZN6S244C63v53Ev();
extern void _ZN6S244C63v54Ev();
extern void _ZN6S244C63v55Ev();
extern void _ZN6S244C63v56Ev();
extern void _ZN6S244C63v57Ev();
extern void _ZN6S244C63v58Ev();
extern void _ZN6S244C63v59Ev();
extern void _ZN6S244C63v60Ev();
extern void _ZN6S244C63v61Ev();
extern void _ZN6S244C63v62Ev();
extern void _ZN6S244C63v63Ev();
extern void _ZN6S244C63v64Ev();
extern void _ZN6S244C63v65Ev();
extern void _ZN6S244C63v66Ev();
extern void _ZN6S244C63v67Ev();
extern void _ZN6S244C63v68Ev();
extern void _ZN9S244C5_nt3v69Ev();
extern void _ZN9S244C5_nt3v70Ev();
extern void _ZN9S244C5_nt3v71Ev();
extern void _ZN9S244C5_nt3v72Ev();
extern void _ZN9S244C5_nt3v73Ev();
extern void _ZN9S244C5_nt3v74Ev();
extern void _ZN9S244C5_nt3v75Ev();
extern void _ZN9S244C5_nt3v76Ev();
extern void _ZN9S244C5_nt3v77Ev();
extern void _ZN9S244C5_nt3v78Ev();
extern void _ZN9S244C5_nt3v79Ev();
extern void _ZN9S244C5_nt3v80Ev();
extern void _ZN9S244C5_nt3v81Ev();
extern void _ZN9S244C5_nt3v82Ev();
extern void _ZN9S244C5_nt3v83Ev();
extern void _ZN9S244C5_nt3v84Ev();
extern void _ZN9S244C5_nt3v85Ev();
extern void _ZN9S244C5_nt3v86Ev();
extern void _ZN9S244C5_nt3v87Ev();
extern void _ZN9S244C5_nt3v88Ev();
extern void _ZN9S244C5_nt3v89Ev();
extern void _ZN9S244C5_nt3v90Ev();
static  VTBL_ENTRY vtc_S244C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S244C5_nt[0]),
  (VTBL_ENTRY)&_ZN9S244C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S244C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S244C62v5Ev,
  (VTBL_ENTRY)&_ZN6S244C62v6Ev,
  (VTBL_ENTRY)&_ZN6S244C62v7Ev,
  (VTBL_ENTRY)&_ZN6S244C62v8Ev,
  (VTBL_ENTRY)&_ZN6S244C62v9Ev,
  (VTBL_ENTRY)&_ZN6S244C63v10Ev,
  (VTBL_ENTRY)&_ZN6S244C63v11Ev,
  (VTBL_ENTRY)&_ZN6S244C63v12Ev,
  (VTBL_ENTRY)&_ZN6S244C63v13Ev,
  (VTBL_ENTRY)&_ZN6S244C63v14Ev,
  (VTBL_ENTRY)&_ZN6S244C63v15Ev,
  (VTBL_ENTRY)&_ZN6S244C63v16Ev,
  (VTBL_ENTRY)&_ZN6S244C63v17Ev,
  (VTBL_ENTRY)&_ZN6S244C63v18Ev,
  (VTBL_ENTRY)&_ZN6S244C63v19Ev,
  (VTBL_ENTRY)&_ZN6S244C63v20Ev,
  (VTBL_ENTRY)&_ZN6S244C63v21Ev,
  (VTBL_ENTRY)&_ZN6S244C63v22Ev,
  (VTBL_ENTRY)&_ZN6S244C63v23Ev,
  (VTBL_ENTRY)&_ZN6S244C63v24Ev,
  (VTBL_ENTRY)&_ZN6S244C63v25Ev,
  (VTBL_ENTRY)&_ZN6S244C63v26Ev,
  (VTBL_ENTRY)&_ZN6S244C63v27Ev,
  (VTBL_ENTRY)&_ZN6S244C63v28Ev,
  (VTBL_ENTRY)&_ZN6S244C63v29Ev,
  (VTBL_ENTRY)&_ZN6S244C63v30Ev,
  (VTBL_ENTRY)&_ZN6S244C63v31Ev,
  (VTBL_ENTRY)&_ZN6S244C63v32Ev,
  (VTBL_ENTRY)&_ZN6S244C63v33Ev,
  (VTBL_ENTRY)&_ZN6S244C63v34Ev,
  (VTBL_ENTRY)&_ZN6S244C63v35Ev,
  (VTBL_ENTRY)&_ZN6S244C63v36Ev,
  (VTBL_ENTRY)&_ZN6S244C63v37Ev,
  (VTBL_ENTRY)&_ZN6S244C63v38Ev,
  (VTBL_ENTRY)&_ZN6S244C63v39Ev,
  (VTBL_ENTRY)&_ZN6S244C63v40Ev,
  (VTBL_ENTRY)&_ZN6S244C63v41Ev,
  (VTBL_ENTRY)&_ZN6S244C63v42Ev,
  (VTBL_ENTRY)&_ZN6S244C63v43Ev,
  (VTBL_ENTRY)&_ZN6S244C63v44Ev,
  (VTBL_ENTRY)&_ZN6S244C63v45Ev,
  (VTBL_ENTRY)&_ZN6S244C63v46Ev,
  (VTBL_ENTRY)&_ZN6S244C63v47Ev,
  (VTBL_ENTRY)&_ZN6S244C63v48Ev,
  (VTBL_ENTRY)&_ZN6S244C63v49Ev,
  (VTBL_ENTRY)&_ZN6S244C63v50Ev,
  (VTBL_ENTRY)&_ZN6S244C63v51Ev,
  (VTBL_ENTRY)&_ZN6S244C63v52Ev,
  (VTBL_ENTRY)&_ZN6S244C63v53Ev,
  (VTBL_ENTRY)&_ZN6S244C63v54Ev,
  (VTBL_ENTRY)&_ZN6S244C63v55Ev,
  (VTBL_ENTRY)&_ZN6S244C63v56Ev,
  (VTBL_ENTRY)&_ZN6S244C63v57Ev,
  (VTBL_ENTRY)&_ZN6S244C63v58Ev,
  (VTBL_ENTRY)&_ZN6S244C63v59Ev,
  (VTBL_ENTRY)&_ZN6S244C63v60Ev,
  (VTBL_ENTRY)&_ZN6S244C63v61Ev,
  (VTBL_ENTRY)&_ZN6S244C63v62Ev,
  (VTBL_ENTRY)&_ZN6S244C63v63Ev,
  (VTBL_ENTRY)&_ZN6S244C63v64Ev,
  (VTBL_ENTRY)&_ZN6S244C63v65Ev,
  (VTBL_ENTRY)&_ZN6S244C63v66Ev,
  (VTBL_ENTRY)&_ZN6S244C63v67Ev,
  (VTBL_ENTRY)&_ZN6S244C63v68Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v90Ev,
};
extern VTBL_ENTRY _ZTI9S244C5_nt[];
VTBL_ENTRY *P__ZTI9S244C5_nt = _ZTI9S244C5_nt; 
extern  VTBL_ENTRY _ZTV9S244C5_nt[];
Class_Descriptor cd_S244C5_nt = {  "S244C5_nt", // class name
  bases_S244C5_nt, 1,
  &(vtc_S244C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI9S244C5_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S244C5_nt),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S244C20  : S3443C7_nt {
};
//SIG(-1 S244C20) C1{ BC2{ m Fp Fi[2]}}



static void Test_S244C20()
{
  extern Class_Descriptor cd_S244C20;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S244C20, buf);
    S244C20 &lv = *(new (buf) S244C20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S244C20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S244C20)");
    check_base_class_offset(lv, (S3443C7_nt*), 0, "S244C20");
    test_class_info(&lv, &cd_S244C20);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS244C20(Test_S244C20, "S244C20", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3443C7_nt;
static Base_Class bases_S244C20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3443C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S244C20 = {  "S244C20", // class name
  bases_S244C20, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S244C19  : S244C20 {
};
//SIG(-1 S244C19) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S244C19()
{
  extern Class_Descriptor cd_S244C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S244C19, buf);
    S244C19 &lv = *(new (buf) S244C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S244C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S244C19)");
    check_base_class_offset(lv, (S3443C7_nt*)(S244C20*), 0, "S244C19");
    check_base_class_offset(lv, (S244C20*), 0, "S244C19");
    test_class_info(&lv, &cd_S244C19);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS244C19(Test_S244C19, "S244C19", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3443C7_nt;
extern Class_Descriptor cd_S244C20;
static Base_Class bases_S244C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3443C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S244C20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S244C19 = {  "S244C19", // class name
  bases_S244C19, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S244C4_nt  : S244C5_nt {
  unsigned int s244c4f0:1;
  unsigned int s244c4f1:1;
  unsigned int s244c4f2:1;
  ::S3443C17 s244c4f3;
  ::S3443C11 s244c4f4;
  ::S3443C5_nt s244c4f5;
  ::S244C19 s244c4f6;
  int s244c4f7[3];
  virtual  ~S244C4_nt(); // _ZN9S244C4_ntD1Ev
  virtual void  v91(); // _ZN9S244C4_nt3v91Ev
  virtual void  v92(); // _ZN9S244C4_nt3v92Ev
  virtual void  v93(); // _ZN9S244C4_nt3v93Ev
  virtual void  v94(); // _ZN9S244C4_nt3v94Ev
  virtual void  v95(); // _ZN9S244C4_nt3v95Ev
  virtual void  v96(); // _ZN9S244C4_nt3v96Ev
  virtual void  v97(); // _ZN9S244C4_nt3v97Ev
  virtual void  v98(); // _ZN9S244C4_nt3v98Ev
  virtual void  v99(); // _ZN9S244C4_nt3v99Ev
  virtual void  v100(); // _ZN9S244C4_nt4v100Ev
  virtual void  v101(); // _ZN9S244C4_nt4v101Ev
  virtual void  v102(); // _ZN9S244C4_nt4v102Ev
  virtual void  v103(); // _ZN9S244C4_nt4v103Ev
  virtual void  v104(); // _ZN9S244C4_nt4v104Ev
  virtual void  v105(); // _ZN9S244C4_nt4v105Ev
  virtual void  v106(); // _ZN9S244C4_nt4v106Ev
  virtual void  v107(); // _ZN9S244C4_nt4v107Ev
  virtual void  v108(); // _ZN9S244C4_nt4v108Ev
  virtual void  v109(); // _ZN9S244C4_nt4v109Ev
  virtual void  v110(); // _ZN9S244C4_nt4v110Ev
  S244C4_nt(); // tgen
};
//SIG(-1 S244C4_nt) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} FC16{ BC17{ BC8}} Fi[3]}


 S244C4_nt ::~S244C4_nt(){ note_dtor("S244C4_nt", this);}
void  S244C4_nt ::v91(){vfunc_called(this, "_ZN9S244C4_nt3v91Ev");}
void  S244C4_nt ::v92(){vfunc_called(this, "_ZN9S244C4_nt3v92Ev");}
void  S244C4_nt ::v93(){vfunc_called(this, "_ZN9S244C4_nt3v93Ev");}
void  S244C4_nt ::v94(){vfunc_called(this, "_ZN9S244C4_nt3v94Ev");}
void  S244C4_nt ::v95(){vfunc_called(this, "_ZN9S244C4_nt3v95Ev");}
void  S244C4_nt ::v96(){vfunc_called(this, "_ZN9S244C4_nt3v96Ev");}
void  S244C4_nt ::v97(){vfunc_called(this, "_ZN9S244C4_nt3v97Ev");}
void  S244C4_nt ::v98(){vfunc_called(this, "_ZN9S244C4_nt3v98Ev");}
void  S244C4_nt ::v99(){vfunc_called(this, "_ZN9S244C4_nt3v99Ev");}
void  S244C4_nt ::v100(){vfunc_called(this, "_ZN9S244C4_nt4v100Ev");}
void  S244C4_nt ::v101(){vfunc_called(this, "_ZN9S244C4_nt4v101Ev");}
void  S244C4_nt ::v102(){vfunc_called(this, "_ZN9S244C4_nt4v102Ev");}
void  S244C4_nt ::v103(){vfunc_called(this, "_ZN9S244C4_nt4v103Ev");}
void  S244C4_nt ::v104(){vfunc_called(this, "_ZN9S244C4_nt4v104Ev");}
void  S244C4_nt ::v105(){vfunc_called(this, "_ZN9S244C4_nt4v105Ev");}
void  S244C4_nt ::v106(){vfunc_called(this, "_ZN9S244C4_nt4v106Ev");}
void  S244C4_nt ::v107(){vfunc_called(this, "_ZN9S244C4_nt4v107Ev");}
void  S244C4_nt ::v108(){vfunc_called(this, "_ZN9S244C4_nt4v108Ev");}
void  S244C4_nt ::v109(){vfunc_called(this, "_ZN9S244C4_nt4v109Ev");}
void  S244C4_nt ::v110(){vfunc_called(this, "_ZN9S244C4_nt4v110Ev");}
S244C4_nt ::S244C4_nt(){ note_ctor("S244C4_nt", this);} // tgen

//skip512 S244C4_nt

#else // __cplusplus

extern void _ZN9S244C4_ntC1Ev();
extern void _ZN9S244C4_ntD1Ev();
Name_Map name_map_S244C4_nt[] = {
  NSPAIR(_ZN9S244C4_ntC1Ev),
  NSPAIR(_ZN9S244C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S244C6;
extern VTBL_ENTRY _ZTI6S244C6[];
extern  VTBL_ENTRY _ZTV6S244C6[];
extern Class_Descriptor cd_S244C5_nt;
extern VTBL_ENTRY _ZTI9S244C5_nt[];
extern  VTBL_ENTRY _ZTV9S244C5_nt[];
static Base_Class bases_S244C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S244C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S244C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S244C4_nt[];
extern void _ZN9S244C4_ntD1Ev();
extern void _ZN9S244C4_ntD0Ev();
extern void _ZN6S244C62v5Ev();
extern void _ZN6S244C62v6Ev();
extern void _ZN6S244C62v7Ev();
extern void _ZN6S244C62v8Ev();
extern void _ZN6S244C62v9Ev();
extern void _ZN6S244C63v10Ev();
extern void _ZN6S244C63v11Ev();
extern void _ZN6S244C63v12Ev();
extern void _ZN6S244C63v13Ev();
extern void _ZN6S244C63v14Ev();
extern void _ZN6S244C63v15Ev();
extern void _ZN6S244C63v16Ev();
extern void _ZN6S244C63v17Ev();
extern void _ZN6S244C63v18Ev();
extern void _ZN6S244C63v19Ev();
extern void _ZN6S244C63v20Ev();
extern void _ZN6S244C63v21Ev();
extern void _ZN6S244C63v22Ev();
extern void _ZN6S244C63v23Ev();
extern void _ZN6S244C63v24Ev();
extern void _ZN6S244C63v25Ev();
extern void _ZN6S244C63v26Ev();
extern void _ZN6S244C63v27Ev();
extern void _ZN6S244C63v28Ev();
extern void _ZN6S244C63v29Ev();
extern void _ZN6S244C63v30Ev();
extern void _ZN6S244C63v31Ev();
extern void _ZN6S244C63v32Ev();
extern void _ZN6S244C63v33Ev();
extern void _ZN6S244C63v34Ev();
extern void _ZN6S244C63v35Ev();
extern void _ZN6S244C63v36Ev();
extern void _ZN6S244C63v37Ev();
extern void _ZN6S244C63v38Ev();
extern void _ZN6S244C63v39Ev();
extern void _ZN6S244C63v40Ev();
extern void _ZN6S244C63v41Ev();
extern void _ZN6S244C63v42Ev();
extern void _ZN6S244C63v43Ev();
extern void _ZN6S244C63v44Ev();
extern void _ZN6S244C63v45Ev();
extern void _ZN6S244C63v46Ev();
extern void _ZN6S244C63v47Ev();
extern void _ZN6S244C63v48Ev();
extern void _ZN6S244C63v49Ev();
extern void _ZN6S244C63v50Ev();
extern void _ZN6S244C63v51Ev();
extern void _ZN6S244C63v52Ev();
extern void _ZN6S244C63v53Ev();
extern void _ZN6S244C63v54Ev();
extern void _ZN6S244C63v55Ev();
extern void _ZN6S244C63v56Ev();
extern void _ZN6S244C63v57Ev();
extern void _ZN6S244C63v58Ev();
extern void _ZN6S244C63v59Ev();
extern void _ZN6S244C63v60Ev();
extern void _ZN6S244C63v61Ev();
extern void _ZN6S244C63v62Ev();
extern void _ZN6S244C63v63Ev();
extern void _ZN6S244C63v64Ev();
extern void _ZN6S244C63v65Ev();
extern void _ZN6S244C63v66Ev();
extern void _ZN6S244C63v67Ev();
extern void _ZN6S244C63v68Ev();
extern void _ZN9S244C5_nt3v69Ev();
extern void _ZN9S244C5_nt3v70Ev();
extern void _ZN9S244C5_nt3v71Ev();
extern void _ZN9S244C5_nt3v72Ev();
extern void _ZN9S244C5_nt3v73Ev();
extern void _ZN9S244C5_nt3v74Ev();
extern void _ZN9S244C5_nt3v75Ev();
extern void _ZN9S244C5_nt3v76Ev();
extern void _ZN9S244C5_nt3v77Ev();
extern void _ZN9S244C5_nt3v78Ev();
extern void _ZN9S244C5_nt3v79Ev();
extern void _ZN9S244C5_nt3v80Ev();
extern void _ZN9S244C5_nt3v81Ev();
extern void _ZN9S244C5_nt3v82Ev();
extern void _ZN9S244C5_nt3v83Ev();
extern void _ZN9S244C5_nt3v84Ev();
extern void _ZN9S244C5_nt3v85Ev();
extern void _ZN9S244C5_nt3v86Ev();
extern void _ZN9S244C5_nt3v87Ev();
extern void _ZN9S244C5_nt3v88Ev();
extern void _ZN9S244C5_nt3v89Ev();
extern void _ZN9S244C5_nt3v90Ev();
extern void _ZN9S244C4_nt3v91Ev();
extern void _ZN9S244C4_nt3v92Ev();
extern void _ZN9S244C4_nt3v93Ev();
extern void _ZN9S244C4_nt3v94Ev();
extern void _ZN9S244C4_nt3v95Ev();
extern void _ZN9S244C4_nt3v96Ev();
extern void _ZN9S244C4_nt3v97Ev();
extern void _ZN9S244C4_nt3v98Ev();
extern void _ZN9S244C4_nt3v99Ev();
extern void _ZN9S244C4_nt4v100Ev();
extern void _ZN9S244C4_nt4v101Ev();
extern void _ZN9S244C4_nt4v102Ev();
extern void _ZN9S244C4_nt4v103Ev();
extern void _ZN9S244C4_nt4v104Ev();
extern void _ZN9S244C4_nt4v105Ev();
extern void _ZN9S244C4_nt4v106Ev();
extern void _ZN9S244C4_nt4v107Ev();
extern void _ZN9S244C4_nt4v108Ev();
extern void _ZN9S244C4_nt4v109Ev();
extern void _ZN9S244C4_nt4v110Ev();
static  VTBL_ENTRY vtc_S244C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S244C4_nt[0]),
  (VTBL_ENTRY)&_ZN9S244C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S244C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S244C62v5Ev,
  (VTBL_ENTRY)&_ZN6S244C62v6Ev,
  (VTBL_ENTRY)&_ZN6S244C62v7Ev,
  (VTBL_ENTRY)&_ZN6S244C62v8Ev,
  (VTBL_ENTRY)&_ZN6S244C62v9Ev,
  (VTBL_ENTRY)&_ZN6S244C63v10Ev,
  (VTBL_ENTRY)&_ZN6S244C63v11Ev,
  (VTBL_ENTRY)&_ZN6S244C63v12Ev,
  (VTBL_ENTRY)&_ZN6S244C63v13Ev,
  (VTBL_ENTRY)&_ZN6S244C63v14Ev,
  (VTBL_ENTRY)&_ZN6S244C63v15Ev,
  (VTBL_ENTRY)&_ZN6S244C63v16Ev,
  (VTBL_ENTRY)&_ZN6S244C63v17Ev,
  (VTBL_ENTRY)&_ZN6S244C63v18Ev,
  (VTBL_ENTRY)&_ZN6S244C63v19Ev,
  (VTBL_ENTRY)&_ZN6S244C63v20Ev,
  (VTBL_ENTRY)&_ZN6S244C63v21Ev,
  (VTBL_ENTRY)&_ZN6S244C63v22Ev,
  (VTBL_ENTRY)&_ZN6S244C63v23Ev,
  (VTBL_ENTRY)&_ZN6S244C63v24Ev,
  (VTBL_ENTRY)&_ZN6S244C63v25Ev,
  (VTBL_ENTRY)&_ZN6S244C63v26Ev,
  (VTBL_ENTRY)&_ZN6S244C63v27Ev,
  (VTBL_ENTRY)&_ZN6S244C63v28Ev,
  (VTBL_ENTRY)&_ZN6S244C63v29Ev,
  (VTBL_ENTRY)&_ZN6S244C63v30Ev,
  (VTBL_ENTRY)&_ZN6S244C63v31Ev,
  (VTBL_ENTRY)&_ZN6S244C63v32Ev,
  (VTBL_ENTRY)&_ZN6S244C63v33Ev,
  (VTBL_ENTRY)&_ZN6S244C63v34Ev,
  (VTBL_ENTRY)&_ZN6S244C63v35Ev,
  (VTBL_ENTRY)&_ZN6S244C63v36Ev,
  (VTBL_ENTRY)&_ZN6S244C63v37Ev,
  (VTBL_ENTRY)&_ZN6S244C63v38Ev,
  (VTBL_ENTRY)&_ZN6S244C63v39Ev,
  (VTBL_ENTRY)&_ZN6S244C63v40Ev,
  (VTBL_ENTRY)&_ZN6S244C63v41Ev,
  (VTBL_ENTRY)&_ZN6S244C63v42Ev,
  (VTBL_ENTRY)&_ZN6S244C63v43Ev,
  (VTBL_ENTRY)&_ZN6S244C63v44Ev,
  (VTBL_ENTRY)&_ZN6S244C63v45Ev,
  (VTBL_ENTRY)&_ZN6S244C63v46Ev,
  (VTBL_ENTRY)&_ZN6S244C63v47Ev,
  (VTBL_ENTRY)&_ZN6S244C63v48Ev,
  (VTBL_ENTRY)&_ZN6S244C63v49Ev,
  (VTBL_ENTRY)&_ZN6S244C63v50Ev,
  (VTBL_ENTRY)&_ZN6S244C63v51Ev,
  (VTBL_ENTRY)&_ZN6S244C63v52Ev,
  (VTBL_ENTRY)&_ZN6S244C63v53Ev,
  (VTBL_ENTRY)&_ZN6S244C63v54Ev,
  (VTBL_ENTRY)&_ZN6S244C63v55Ev,
  (VTBL_ENTRY)&_ZN6S244C63v56Ev,
  (VTBL_ENTRY)&_ZN6S244C63v57Ev,
  (VTBL_ENTRY)&_ZN6S244C63v58Ev,
  (VTBL_ENTRY)&_ZN6S244C63v59Ev,
  (VTBL_ENTRY)&_ZN6S244C63v60Ev,
  (VTBL_ENTRY)&_ZN6S244C63v61Ev,
  (VTBL_ENTRY)&_ZN6S244C63v62Ev,
  (VTBL_ENTRY)&_ZN6S244C63v63Ev,
  (VTBL_ENTRY)&_ZN6S244C63v64Ev,
  (VTBL_ENTRY)&_ZN6S244C63v65Ev,
  (VTBL_ENTRY)&_ZN6S244C63v66Ev,
  (VTBL_ENTRY)&_ZN6S244C63v67Ev,
  (VTBL_ENTRY)&_ZN6S244C63v68Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v110Ev,
};
extern VTBL_ENTRY _ZTI9S244C4_nt[];
VTBL_ENTRY *P__ZTI9S244C4_nt = _ZTI9S244C4_nt; 
extern  VTBL_ENTRY _ZTV9S244C4_nt[];
Class_Descriptor cd_S244C4_nt = {  "S244C4_nt", // class name
  bases_S244C4_nt, 2,
  &(vtc_S244C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI9S244C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S244C4_nt),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S244C3_nt  : S244C4_nt {
  ::S3443C4_nt s244c3f0;
  unsigned int s244c3f1:1;
  ::S244C19 s244c3f2;
  virtual  ~S244C3_nt(); // _ZN9S244C3_ntD1Ev
  virtual void  v111(); // _ZN9S244C3_nt4v111Ev
  virtual void  v112(); // _ZN9S244C3_nt4v112Ev
  virtual void  v113(); // _ZN9S244C3_nt4v113Ev
  virtual void  v114(); // _ZN9S244C3_nt4v114Ev
  S244C3_nt(); // tgen
};
//SIG(-1 S244C3_nt) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} FC17{ BC18{ BC9}} Fi[3]} vd v1 v2 v3 v4 FC5 Fi:1 FC17}


 S244C3_nt ::~S244C3_nt(){ note_dtor("S244C3_nt", this);}
void  S244C3_nt ::v111(){vfunc_called(this, "_ZN9S244C3_nt4v111Ev");}
void  S244C3_nt ::v112(){vfunc_called(this, "_ZN9S244C3_nt4v112Ev");}
void  S244C3_nt ::v113(){vfunc_called(this, "_ZN9S244C3_nt4v113Ev");}
void  S244C3_nt ::v114(){vfunc_called(this, "_ZN9S244C3_nt4v114Ev");}
S244C3_nt ::S244C3_nt(){ note_ctor("S244C3_nt", this);} // tgen

//skip512 S244C3_nt

#else // __cplusplus

extern void _ZN9S244C3_ntC1Ev();
extern void _ZN9S244C3_ntD1Ev();
Name_Map name_map_S244C3_nt[] = {
  NSPAIR(_ZN9S244C3_ntC1Ev),
  NSPAIR(_ZN9S244C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S244C6;
extern VTBL_ENTRY _ZTI6S244C6[];
extern  VTBL_ENTRY _ZTV6S244C6[];
extern Class_Descriptor cd_S244C5_nt;
extern VTBL_ENTRY _ZTI9S244C5_nt[];
extern  VTBL_ENTRY _ZTV9S244C5_nt[];
extern Class_Descriptor cd_S244C4_nt;
extern VTBL_ENTRY _ZTI9S244C4_nt[];
extern  VTBL_ENTRY _ZTV9S244C4_nt[];
static Base_Class bases_S244C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S244C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S244C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S244C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S244C3_nt[];
extern void _ZN9S244C3_ntD1Ev();
extern void _ZN9S244C3_ntD0Ev();
extern void _ZN6S244C62v5Ev();
extern void _ZN6S244C62v6Ev();
extern void _ZN6S244C62v7Ev();
extern void _ZN6S244C62v8Ev();
extern void _ZN6S244C62v9Ev();
extern void _ZN6S244C63v10Ev();
extern void _ZN6S244C63v11Ev();
extern void _ZN6S244C63v12Ev();
extern void _ZN6S244C63v13Ev();
extern void _ZN6S244C63v14Ev();
extern void _ZN6S244C63v15Ev();
extern void _ZN6S244C63v16Ev();
extern void _ZN6S244C63v17Ev();
extern void _ZN6S244C63v18Ev();
extern void _ZN6S244C63v19Ev();
extern void _ZN6S244C63v20Ev();
extern void _ZN6S244C63v21Ev();
extern void _ZN6S244C63v22Ev();
extern void _ZN6S244C63v23Ev();
extern void _ZN6S244C63v24Ev();
extern void _ZN6S244C63v25Ev();
extern void _ZN6S244C63v26Ev();
extern void _ZN6S244C63v27Ev();
extern void _ZN6S244C63v28Ev();
extern void _ZN6S244C63v29Ev();
extern void _ZN6S244C63v30Ev();
extern void _ZN6S244C63v31Ev();
extern void _ZN6S244C63v32Ev();
extern void _ZN6S244C63v33Ev();
extern void _ZN6S244C63v34Ev();
extern void _ZN6S244C63v35Ev();
extern void _ZN6S244C63v36Ev();
extern void _ZN6S244C63v37Ev();
extern void _ZN6S244C63v38Ev();
extern void _ZN6S244C63v39Ev();
extern void _ZN6S244C63v40Ev();
extern void _ZN6S244C63v41Ev();
extern void _ZN6S244C63v42Ev();
extern void _ZN6S244C63v43Ev();
extern void _ZN6S244C63v44Ev();
extern void _ZN6S244C63v45Ev();
extern void _ZN6S244C63v46Ev();
extern void _ZN6S244C63v47Ev();
extern void _ZN6S244C63v48Ev();
extern void _ZN6S244C63v49Ev();
extern void _ZN6S244C63v50Ev();
extern void _ZN6S244C63v51Ev();
extern void _ZN6S244C63v52Ev();
extern void _ZN6S244C63v53Ev();
extern void _ZN6S244C63v54Ev();
extern void _ZN6S244C63v55Ev();
extern void _ZN6S244C63v56Ev();
extern void _ZN6S244C63v57Ev();
extern void _ZN6S244C63v58Ev();
extern void _ZN6S244C63v59Ev();
extern void _ZN6S244C63v60Ev();
extern void _ZN6S244C63v61Ev();
extern void _ZN6S244C63v62Ev();
extern void _ZN6S244C63v63Ev();
extern void _ZN6S244C63v64Ev();
extern void _ZN6S244C63v65Ev();
extern void _ZN6S244C63v66Ev();
extern void _ZN6S244C63v67Ev();
extern void _ZN6S244C63v68Ev();
extern void _ZN9S244C5_nt3v69Ev();
extern void _ZN9S244C5_nt3v70Ev();
extern void _ZN9S244C5_nt3v71Ev();
extern void _ZN9S244C5_nt3v72Ev();
extern void _ZN9S244C5_nt3v73Ev();
extern void _ZN9S244C5_nt3v74Ev();
extern void _ZN9S244C5_nt3v75Ev();
extern void _ZN9S244C5_nt3v76Ev();
extern void _ZN9S244C5_nt3v77Ev();
extern void _ZN9S244C5_nt3v78Ev();
extern void _ZN9S244C5_nt3v79Ev();
extern void _ZN9S244C5_nt3v80Ev();
extern void _ZN9S244C5_nt3v81Ev();
extern void _ZN9S244C5_nt3v82Ev();
extern void _ZN9S244C5_nt3v83Ev();
extern void _ZN9S244C5_nt3v84Ev();
extern void _ZN9S244C5_nt3v85Ev();
extern void _ZN9S244C5_nt3v86Ev();
extern void _ZN9S244C5_nt3v87Ev();
extern void _ZN9S244C5_nt3v88Ev();
extern void _ZN9S244C5_nt3v89Ev();
extern void _ZN9S244C5_nt3v90Ev();
extern void _ZN9S244C4_nt3v91Ev();
extern void _ZN9S244C4_nt3v92Ev();
extern void _ZN9S244C4_nt3v93Ev();
extern void _ZN9S244C4_nt3v94Ev();
extern void _ZN9S244C4_nt3v95Ev();
extern void _ZN9S244C4_nt3v96Ev();
extern void _ZN9S244C4_nt3v97Ev();
extern void _ZN9S244C4_nt3v98Ev();
extern void _ZN9S244C4_nt3v99Ev();
extern void _ZN9S244C4_nt4v100Ev();
extern void _ZN9S244C4_nt4v101Ev();
extern void _ZN9S244C4_nt4v102Ev();
extern void _ZN9S244C4_nt4v103Ev();
extern void _ZN9S244C4_nt4v104Ev();
extern void _ZN9S244C4_nt4v105Ev();
extern void _ZN9S244C4_nt4v106Ev();
extern void _ZN9S244C4_nt4v107Ev();
extern void _ZN9S244C4_nt4v108Ev();
extern void _ZN9S244C4_nt4v109Ev();
extern void _ZN9S244C4_nt4v110Ev();
extern void _ZN9S244C3_nt4v111Ev();
extern void _ZN9S244C3_nt4v112Ev();
extern void _ZN9S244C3_nt4v113Ev();
extern void _ZN9S244C3_nt4v114Ev();
static  VTBL_ENTRY vtc_S244C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S244C3_nt[0]),
  (VTBL_ENTRY)&_ZN9S244C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S244C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S244C62v5Ev,
  (VTBL_ENTRY)&_ZN6S244C62v6Ev,
  (VTBL_ENTRY)&_ZN6S244C62v7Ev,
  (VTBL_ENTRY)&_ZN6S244C62v8Ev,
  (VTBL_ENTRY)&_ZN6S244C62v9Ev,
  (VTBL_ENTRY)&_ZN6S244C63v10Ev,
  (VTBL_ENTRY)&_ZN6S244C63v11Ev,
  (VTBL_ENTRY)&_ZN6S244C63v12Ev,
  (VTBL_ENTRY)&_ZN6S244C63v13Ev,
  (VTBL_ENTRY)&_ZN6S244C63v14Ev,
  (VTBL_ENTRY)&_ZN6S244C63v15Ev,
  (VTBL_ENTRY)&_ZN6S244C63v16Ev,
  (VTBL_ENTRY)&_ZN6S244C63v17Ev,
  (VTBL_ENTRY)&_ZN6S244C63v18Ev,
  (VTBL_ENTRY)&_ZN6S244C63v19Ev,
  (VTBL_ENTRY)&_ZN6S244C63v20Ev,
  (VTBL_ENTRY)&_ZN6S244C63v21Ev,
  (VTBL_ENTRY)&_ZN6S244C63v22Ev,
  (VTBL_ENTRY)&_ZN6S244C63v23Ev,
  (VTBL_ENTRY)&_ZN6S244C63v24Ev,
  (VTBL_ENTRY)&_ZN6S244C63v25Ev,
  (VTBL_ENTRY)&_ZN6S244C63v26Ev,
  (VTBL_ENTRY)&_ZN6S244C63v27Ev,
  (VTBL_ENTRY)&_ZN6S244C63v28Ev,
  (VTBL_ENTRY)&_ZN6S244C63v29Ev,
  (VTBL_ENTRY)&_ZN6S244C63v30Ev,
  (VTBL_ENTRY)&_ZN6S244C63v31Ev,
  (VTBL_ENTRY)&_ZN6S244C63v32Ev,
  (VTBL_ENTRY)&_ZN6S244C63v33Ev,
  (VTBL_ENTRY)&_ZN6S244C63v34Ev,
  (VTBL_ENTRY)&_ZN6S244C63v35Ev,
  (VTBL_ENTRY)&_ZN6S244C63v36Ev,
  (VTBL_ENTRY)&_ZN6S244C63v37Ev,
  (VTBL_ENTRY)&_ZN6S244C63v38Ev,
  (VTBL_ENTRY)&_ZN6S244C63v39Ev,
  (VTBL_ENTRY)&_ZN6S244C63v40Ev,
  (VTBL_ENTRY)&_ZN6S244C63v41Ev,
  (VTBL_ENTRY)&_ZN6S244C63v42Ev,
  (VTBL_ENTRY)&_ZN6S244C63v43Ev,
  (VTBL_ENTRY)&_ZN6S244C63v44Ev,
  (VTBL_ENTRY)&_ZN6S244C63v45Ev,
  (VTBL_ENTRY)&_ZN6S244C63v46Ev,
  (VTBL_ENTRY)&_ZN6S244C63v47Ev,
  (VTBL_ENTRY)&_ZN6S244C63v48Ev,
  (VTBL_ENTRY)&_ZN6S244C63v49Ev,
  (VTBL_ENTRY)&_ZN6S244C63v50Ev,
  (VTBL_ENTRY)&_ZN6S244C63v51Ev,
  (VTBL_ENTRY)&_ZN6S244C63v52Ev,
  (VTBL_ENTRY)&_ZN6S244C63v53Ev,
  (VTBL_ENTRY)&_ZN6S244C63v54Ev,
  (VTBL_ENTRY)&_ZN6S244C63v55Ev,
  (VTBL_ENTRY)&_ZN6S244C63v56Ev,
  (VTBL_ENTRY)&_ZN6S244C63v57Ev,
  (VTBL_ENTRY)&_ZN6S244C63v58Ev,
  (VTBL_ENTRY)&_ZN6S244C63v59Ev,
  (VTBL_ENTRY)&_ZN6S244C63v60Ev,
  (VTBL_ENTRY)&_ZN6S244C63v61Ev,
  (VTBL_ENTRY)&_ZN6S244C63v62Ev,
  (VTBL_ENTRY)&_ZN6S244C63v63Ev,
  (VTBL_ENTRY)&_ZN6S244C63v64Ev,
  (VTBL_ENTRY)&_ZN6S244C63v65Ev,
  (VTBL_ENTRY)&_ZN6S244C63v66Ev,
  (VTBL_ENTRY)&_ZN6S244C63v67Ev,
  (VTBL_ENTRY)&_ZN6S244C63v68Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S244C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S244C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S244C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S244C3_nt4v114Ev,
};
extern VTBL_ENTRY _ZTI9S244C3_nt[];
VTBL_ENTRY *P__ZTI9S244C3_nt = _ZTI9S244C3_nt; 
extern  VTBL_ENTRY _ZTV9S244C3_nt[];
Class_Descriptor cd_S244C3_nt = {  "S244C3_nt", // class name
  bases_S244C3_nt, 3,
  &(vtc_S244C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,220), // object size
  NSPAIRA(_ZTI9S244C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S244C3_nt),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S244C2_nt  : S244C3_nt {
  int s244c2f0;
  unsigned int s244c2f1:1;
  virtual  ~S244C2_nt(); // _ZN9S244C2_ntD1Ev
  virtual void  v115(); // _ZN9S244C2_nt4v115Ev
  virtual void  v116(); // _ZN9S244C2_nt4v116Ev
  virtual void  v117(); // _ZN9S244C2_nt4v117Ev
  virtual void  v118(); // _ZN9S244C2_nt4v118Ev
  virtual void  v119(); // _ZN9S244C2_nt4v119Ev
  virtual void  v120(); // _ZN9S244C2_nt4v120Ev
  virtual void  v121(); // _ZN9S244C2_nt4v121Ev
  virtual void  v122(); // _ZN9S244C2_nt4v122Ev
  S244C2_nt(); // tgen
};
//SIG(-1 S244C2_nt) C1{ BC2{ BC3{ BC4{ BC5{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} FC18{ BC19{ BC10}} Fi[3]} vd v115 v116 v117 v118 FC6 Fi:1 FC18} vd v1 v2 v3 v4 v5 v6 v7 v8 Fi Fi:1}


 S244C2_nt ::~S244C2_nt(){ note_dtor("S244C2_nt", this);}
void  S244C2_nt ::v115(){vfunc_called(this, "_ZN9S244C2_nt4v115Ev");}
void  S244C2_nt ::v116(){vfunc_called(this, "_ZN9S244C2_nt4v116Ev");}
void  S244C2_nt ::v117(){vfunc_called(this, "_ZN9S244C2_nt4v117Ev");}
void  S244C2_nt ::v118(){vfunc_called(this, "_ZN9S244C2_nt4v118Ev");}
void  S244C2_nt ::v119(){vfunc_called(this, "_ZN9S244C2_nt4v119Ev");}
void  S244C2_nt ::v120(){vfunc_called(this, "_ZN9S244C2_nt4v120Ev");}
void  S244C2_nt ::v121(){vfunc_called(this, "_ZN9S244C2_nt4v121Ev");}
void  S244C2_nt ::v122(){vfunc_called(this, "_ZN9S244C2_nt4v122Ev");}
S244C2_nt ::S244C2_nt(){ note_ctor("S244C2_nt", this);} // tgen

//skip512 S244C2_nt

#else // __cplusplus

extern void _ZN9S244C2_ntC1Ev();
extern void _ZN9S244C2_ntD1Ev();
Name_Map name_map_S244C2_nt[] = {
  NSPAIR(_ZN9S244C2_ntC1Ev),
  NSPAIR(_ZN9S244C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S244C6;
extern VTBL_ENTRY _ZTI6S244C6[];
extern  VTBL_ENTRY _ZTV6S244C6[];
extern Class_Descriptor cd_S244C5_nt;
extern VTBL_ENTRY _ZTI9S244C5_nt[];
extern  VTBL_ENTRY _ZTV9S244C5_nt[];
extern Class_Descriptor cd_S244C4_nt;
extern VTBL_ENTRY _ZTI9S244C4_nt[];
extern  VTBL_ENTRY _ZTV9S244C4_nt[];
extern Class_Descriptor cd_S244C3_nt;
extern VTBL_ENTRY _ZTI9S244C3_nt[];
extern  VTBL_ENTRY _ZTV9S244C3_nt[];
static Base_Class bases_S244C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S244C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S244C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S244C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S244C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S244C2_nt[];
extern void _ZN9S244C2_ntD1Ev();
extern void _ZN9S244C2_ntD0Ev();
extern void _ZN6S244C62v5Ev();
extern void _ZN6S244C62v6Ev();
extern void _ZN6S244C62v7Ev();
extern void _ZN6S244C62v8Ev();
extern void _ZN6S244C62v9Ev();
extern void _ZN6S244C63v10Ev();
extern void _ZN6S244C63v11Ev();
extern void _ZN6S244C63v12Ev();
extern void _ZN6S244C63v13Ev();
extern void _ZN6S244C63v14Ev();
extern void _ZN6S244C63v15Ev();
extern void _ZN6S244C63v16Ev();
extern void _ZN6S244C63v17Ev();
extern void _ZN6S244C63v18Ev();
extern void _ZN6S244C63v19Ev();
extern void _ZN6S244C63v20Ev();
extern void _ZN6S244C63v21Ev();
extern void _ZN6S244C63v22Ev();
extern void _ZN6S244C63v23Ev();
extern void _ZN6S244C63v24Ev();
extern void _ZN6S244C63v25Ev();
extern void _ZN6S244C63v26Ev();
extern void _ZN6S244C63v27Ev();
extern void _ZN6S244C63v28Ev();
extern void _ZN6S244C63v29Ev();
extern void _ZN6S244C63v30Ev();
extern void _ZN6S244C63v31Ev();
extern void _ZN6S244C63v32Ev();
extern void _ZN6S244C63v33Ev();
extern void _ZN6S244C63v34Ev();
extern void _ZN6S244C63v35Ev();
extern void _ZN6S244C63v36Ev();
extern void _ZN6S244C63v37Ev();
extern void _ZN6S244C63v38Ev();
extern void _ZN6S244C63v39Ev();
extern void _ZN6S244C63v40Ev();
extern void _ZN6S244C63v41Ev();
extern void _ZN6S244C63v42Ev();
extern void _ZN6S244C63v43Ev();
extern void _ZN6S244C63v44Ev();
extern void _ZN6S244C63v45Ev();
extern void _ZN6S244C63v46Ev();
extern void _ZN6S244C63v47Ev();
extern void _ZN6S244C63v48Ev();
extern void _ZN6S244C63v49Ev();
extern void _ZN6S244C63v50Ev();
extern void _ZN6S244C63v51Ev();
extern void _ZN6S244C63v52Ev();
extern void _ZN6S244C63v53Ev();
extern void _ZN6S244C63v54Ev();
extern void _ZN6S244C63v55Ev();
extern void _ZN6S244C63v56Ev();
extern void _ZN6S244C63v57Ev();
extern void _ZN6S244C63v58Ev();
extern void _ZN6S244C63v59Ev();
extern void _ZN6S244C63v60Ev();
extern void _ZN6S244C63v61Ev();
extern void _ZN6S244C63v62Ev();
extern void _ZN6S244C63v63Ev();
extern void _ZN6S244C63v64Ev();
extern void _ZN6S244C63v65Ev();
extern void _ZN6S244C63v66Ev();
extern void _ZN6S244C63v67Ev();
extern void _ZN6S244C63v68Ev();
extern void _ZN9S244C5_nt3v69Ev();
extern void _ZN9S244C5_nt3v70Ev();
extern void _ZN9S244C5_nt3v71Ev();
extern void _ZN9S244C5_nt3v72Ev();
extern void _ZN9S244C5_nt3v73Ev();
extern void _ZN9S244C5_nt3v74Ev();
extern void _ZN9S244C5_nt3v75Ev();
extern void _ZN9S244C5_nt3v76Ev();
extern void _ZN9S244C5_nt3v77Ev();
extern void _ZN9S244C5_nt3v78Ev();
extern void _ZN9S244C5_nt3v79Ev();
extern void _ZN9S244C5_nt3v80Ev();
extern void _ZN9S244C5_nt3v81Ev();
extern void _ZN9S244C5_nt3v82Ev();
extern void _ZN9S244C5_nt3v83Ev();
extern void _ZN9S244C5_nt3v84Ev();
extern void _ZN9S244C5_nt3v85Ev();
extern void _ZN9S244C5_nt3v86Ev();
extern void _ZN9S244C5_nt3v87Ev();
extern void _ZN9S244C5_nt3v88Ev();
extern void _ZN9S244C5_nt3v89Ev();
extern void _ZN9S244C5_nt3v90Ev();
extern void _ZN9S244C4_nt3v91Ev();
extern void _ZN9S244C4_nt3v92Ev();
extern void _ZN9S244C4_nt3v93Ev();
extern void _ZN9S244C4_nt3v94Ev();
extern void _ZN9S244C4_nt3v95Ev();
extern void _ZN9S244C4_nt3v96Ev();
extern void _ZN9S244C4_nt3v97Ev();
extern void _ZN9S244C4_nt3v98Ev();
extern void _ZN9S244C4_nt3v99Ev();
extern void _ZN9S244C4_nt4v100Ev();
extern void _ZN9S244C4_nt4v101Ev();
extern void _ZN9S244C4_nt4v102Ev();
extern void _ZN9S244C4_nt4v103Ev();
extern void _ZN9S244C4_nt4v104Ev();
extern void _ZN9S244C4_nt4v105Ev();
extern void _ZN9S244C4_nt4v106Ev();
extern void _ZN9S244C4_nt4v107Ev();
extern void _ZN9S244C4_nt4v108Ev();
extern void _ZN9S244C4_nt4v109Ev();
extern void _ZN9S244C4_nt4v110Ev();
extern void _ZN9S244C3_nt4v111Ev();
extern void _ZN9S244C3_nt4v112Ev();
extern void _ZN9S244C3_nt4v113Ev();
extern void _ZN9S244C3_nt4v114Ev();
extern void _ZN9S244C2_nt4v115Ev();
extern void _ZN9S244C2_nt4v116Ev();
extern void _ZN9S244C2_nt4v117Ev();
extern void _ZN9S244C2_nt4v118Ev();
extern void _ZN9S244C2_nt4v119Ev();
extern void _ZN9S244C2_nt4v120Ev();
extern void _ZN9S244C2_nt4v121Ev();
extern void _ZN9S244C2_nt4v122Ev();
static  VTBL_ENTRY vtc_S244C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S244C2_nt[0]),
  (VTBL_ENTRY)&_ZN9S244C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S244C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S244C62v5Ev,
  (VTBL_ENTRY)&_ZN6S244C62v6Ev,
  (VTBL_ENTRY)&_ZN6S244C62v7Ev,
  (VTBL_ENTRY)&_ZN6S244C62v8Ev,
  (VTBL_ENTRY)&_ZN6S244C62v9Ev,
  (VTBL_ENTRY)&_ZN6S244C63v10Ev,
  (VTBL_ENTRY)&_ZN6S244C63v11Ev,
  (VTBL_ENTRY)&_ZN6S244C63v12Ev,
  (VTBL_ENTRY)&_ZN6S244C63v13Ev,
  (VTBL_ENTRY)&_ZN6S244C63v14Ev,
  (VTBL_ENTRY)&_ZN6S244C63v15Ev,
  (VTBL_ENTRY)&_ZN6S244C63v16Ev,
  (VTBL_ENTRY)&_ZN6S244C63v17Ev,
  (VTBL_ENTRY)&_ZN6S244C63v18Ev,
  (VTBL_ENTRY)&_ZN6S244C63v19Ev,
  (VTBL_ENTRY)&_ZN6S244C63v20Ev,
  (VTBL_ENTRY)&_ZN6S244C63v21Ev,
  (VTBL_ENTRY)&_ZN6S244C63v22Ev,
  (VTBL_ENTRY)&_ZN6S244C63v23Ev,
  (VTBL_ENTRY)&_ZN6S244C63v24Ev,
  (VTBL_ENTRY)&_ZN6S244C63v25Ev,
  (VTBL_ENTRY)&_ZN6S244C63v26Ev,
  (VTBL_ENTRY)&_ZN6S244C63v27Ev,
  (VTBL_ENTRY)&_ZN6S244C63v28Ev,
  (VTBL_ENTRY)&_ZN6S244C63v29Ev,
  (VTBL_ENTRY)&_ZN6S244C63v30Ev,
  (VTBL_ENTRY)&_ZN6S244C63v31Ev,
  (VTBL_ENTRY)&_ZN6S244C63v32Ev,
  (VTBL_ENTRY)&_ZN6S244C63v33Ev,
  (VTBL_ENTRY)&_ZN6S244C63v34Ev,
  (VTBL_ENTRY)&_ZN6S244C63v35Ev,
  (VTBL_ENTRY)&_ZN6S244C63v36Ev,
  (VTBL_ENTRY)&_ZN6S244C63v37Ev,
  (VTBL_ENTRY)&_ZN6S244C63v38Ev,
  (VTBL_ENTRY)&_ZN6S244C63v39Ev,
  (VTBL_ENTRY)&_ZN6S244C63v40Ev,
  (VTBL_ENTRY)&_ZN6S244C63v41Ev,
  (VTBL_ENTRY)&_ZN6S244C63v42Ev,
  (VTBL_ENTRY)&_ZN6S244C63v43Ev,
  (VTBL_ENTRY)&_ZN6S244C63v44Ev,
  (VTBL_ENTRY)&_ZN6S244C63v45Ev,
  (VTBL_ENTRY)&_ZN6S244C63v46Ev,
  (VTBL_ENTRY)&_ZN6S244C63v47Ev,
  (VTBL_ENTRY)&_ZN6S244C63v48Ev,
  (VTBL_ENTRY)&_ZN6S244C63v49Ev,
  (VTBL_ENTRY)&_ZN6S244C63v50Ev,
  (VTBL_ENTRY)&_ZN6S244C63v51Ev,
  (VTBL_ENTRY)&_ZN6S244C63v52Ev,
  (VTBL_ENTRY)&_ZN6S244C63v53Ev,
  (VTBL_ENTRY)&_ZN6S244C63v54Ev,
  (VTBL_ENTRY)&_ZN6S244C63v55Ev,
  (VTBL_ENTRY)&_ZN6S244C63v56Ev,
  (VTBL_ENTRY)&_ZN6S244C63v57Ev,
  (VTBL_ENTRY)&_ZN6S244C63v58Ev,
  (VTBL_ENTRY)&_ZN6S244C63v59Ev,
  (VTBL_ENTRY)&_ZN6S244C63v60Ev,
  (VTBL_ENTRY)&_ZN6S244C63v61Ev,
  (VTBL_ENTRY)&_ZN6S244C63v62Ev,
  (VTBL_ENTRY)&_ZN6S244C63v63Ev,
  (VTBL_ENTRY)&_ZN6S244C63v64Ev,
  (VTBL_ENTRY)&_ZN6S244C63v65Ev,
  (VTBL_ENTRY)&_ZN6S244C63v66Ev,
  (VTBL_ENTRY)&_ZN6S244C63v67Ev,
  (VTBL_ENTRY)&_ZN6S244C63v68Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S244C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S244C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S244C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S244C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S244C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S244C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S244C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S244C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S244C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S244C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S244C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S244C2_nt4v122Ev,
};
extern VTBL_ENTRY _ZTI9S244C2_nt[];
VTBL_ENTRY *P__ZTI9S244C2_nt = _ZTI9S244C2_nt; 
extern  VTBL_ENTRY _ZTV9S244C2_nt[];
Class_Descriptor cd_S244C2_nt = {  "S244C2_nt", // class name
  bases_S244C2_nt, 4,
  &(vtc_S244C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,228), // object size
  NSPAIRA(_ZTI9S244C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S244C2_nt),122, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S244C23_nt  {
  void *s244c23f0[2];
  void  mf244c23(); // _ZN10S244C23_nt8mf244c23Ev
};
//SIG(-1 S244C23_nt) C1{ m Fp[2]}


void  S244C23_nt ::mf244c23(){}

//skip512 S244C23_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S244C1  : S244C2_nt {
  ::S244C23_nt s244c1f0;
  void *s244c1f1;
  unsigned int s244c1f2:1;
  unsigned int s244c1f3:1;
  virtual  ~S244C1(); // _ZN6S244C1D1Ev
  virtual void  v1(); // _ZN6S244C12v1Ev
  virtual void  v2(); // _ZN6S244C12v2Ev
  virtual void  v3(); // _ZN6S244C12v3Ev
  virtual void  v4(); // _ZN6S244C12v4Ev
  S244C1(); // tgen
};
//SIG(1 S244C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 FC12{ m} FC8 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC13{ BC14{ BC11}} FC15{ BC16{ BC11}} FC17{ BC18{ BC11}} FC19{ BC20{ BC11}} Fi[3]} vd v111 v112 v113 v114 FC7 Fi:1 FC19} vd v115 v116 v117 v118 v119 v120 v121 v122 Fi Fi:1} vd v1 v2 v3 v4 FC21{ m Fp[2]} Fp Fi:1 Fi:1}


 S244C1 ::~S244C1(){ note_dtor("S244C1", this);}
void  S244C1 ::v1(){vfunc_called(this, "_ZN6S244C12v1Ev");}
void  S244C1 ::v2(){vfunc_called(this, "_ZN6S244C12v2Ev");}
void  S244C1 ::v3(){vfunc_called(this, "_ZN6S244C12v3Ev");}
void  S244C1 ::v4(){vfunc_called(this, "_ZN6S244C12v4Ev");}
S244C1 ::S244C1(){ note_ctor("S244C1", this);} // tgen

static void Test_S244C1()
{
  extern Class_Descriptor cd_S244C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(43,62)];
    init_test(&cd_S244C1, buf);
    S244C1 *dp, &lv = *(dp=new (buf) S244C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(336,244), "sizeof(S244C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S244C1)");
    check_base_class_offset(lv, (S244C6*)(S244C5_nt*)(S244C4_nt*)(S244C3_nt*)(S244C2_nt*), 0, "S244C1");
    check_base_class_offset(lv, (S244C5_nt*)(S244C4_nt*)(S244C3_nt*)(S244C2_nt*), 0, "S244C1");
    check_base_class_offset(lv, (S244C4_nt*)(S244C3_nt*)(S244C2_nt*), 0, "S244C1");
    check_base_class_offset(lv, (S244C3_nt*)(S244C2_nt*), 0, "S244C1");
    check_base_class_offset(lv, (S244C2_nt*), 0, "S244C1");
    check_field_offset(lv, s244c1f0, ABISELECT(304,228), "S244C1.s244c1f0");
    check_field_offset(lv, s244c1f1, ABISELECT(320,236), "S244C1.s244c1f1");
    set_bf_and_test(lv, s244c1f2, ABISELECT(328,240), 0, 1, 1, "S244C1");
    set_bf_and_test(lv, s244c1f3, ABISELECT(328,240), 1, 1, 1, "S244C1");
    test_class_info(&lv, &cd_S244C1);
    dp->~S244C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS244C1(Test_S244C1, "S244C1", ABISELECT(336,244));

#else // __cplusplus

extern void _ZN6S244C1C1Ev();
extern void _ZN6S244C1D1Ev();
Name_Map name_map_S244C1[] = {
  NSPAIR(_ZN6S244C1C1Ev),
  NSPAIR(_ZN6S244C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S244C6;
extern VTBL_ENTRY _ZTI6S244C6[];
extern  VTBL_ENTRY _ZTV6S244C6[];
extern Class_Descriptor cd_S244C5_nt;
extern VTBL_ENTRY _ZTI9S244C5_nt[];
extern  VTBL_ENTRY _ZTV9S244C5_nt[];
extern Class_Descriptor cd_S244C4_nt;
extern VTBL_ENTRY _ZTI9S244C4_nt[];
extern  VTBL_ENTRY _ZTV9S244C4_nt[];
extern Class_Descriptor cd_S244C3_nt;
extern VTBL_ENTRY _ZTI9S244C3_nt[];
extern  VTBL_ENTRY _ZTV9S244C3_nt[];
extern Class_Descriptor cd_S244C2_nt;
extern VTBL_ENTRY _ZTI9S244C2_nt[];
extern  VTBL_ENTRY _ZTV9S244C2_nt[];
static Base_Class bases_S244C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S244C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S244C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S244C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S244C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S244C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S244C1[];
extern void _ZN6S244C1D1Ev();
extern void _ZN6S244C1D0Ev();
extern void _ZN6S244C62v5Ev();
extern void _ZN6S244C62v6Ev();
extern void _ZN6S244C62v7Ev();
extern void _ZN6S244C62v8Ev();
extern void _ZN6S244C62v9Ev();
extern void _ZN6S244C63v10Ev();
extern void _ZN6S244C63v11Ev();
extern void _ZN6S244C63v12Ev();
extern void _ZN6S244C63v13Ev();
extern void _ZN6S244C63v14Ev();
extern void _ZN6S244C63v15Ev();
extern void _ZN6S244C63v16Ev();
extern void _ZN6S244C63v17Ev();
extern void _ZN6S244C63v18Ev();
extern void _ZN6S244C63v19Ev();
extern void _ZN6S244C63v20Ev();
extern void _ZN6S244C63v21Ev();
extern void _ZN6S244C63v22Ev();
extern void _ZN6S244C63v23Ev();
extern void _ZN6S244C63v24Ev();
extern void _ZN6S244C63v25Ev();
extern void _ZN6S244C63v26Ev();
extern void _ZN6S244C63v27Ev();
extern void _ZN6S244C63v28Ev();
extern void _ZN6S244C63v29Ev();
extern void _ZN6S244C63v30Ev();
extern void _ZN6S244C63v31Ev();
extern void _ZN6S244C63v32Ev();
extern void _ZN6S244C63v33Ev();
extern void _ZN6S244C63v34Ev();
extern void _ZN6S244C63v35Ev();
extern void _ZN6S244C63v36Ev();
extern void _ZN6S244C63v37Ev();
extern void _ZN6S244C63v38Ev();
extern void _ZN6S244C63v39Ev();
extern void _ZN6S244C63v40Ev();
extern void _ZN6S244C63v41Ev();
extern void _ZN6S244C63v42Ev();
extern void _ZN6S244C63v43Ev();
extern void _ZN6S244C63v44Ev();
extern void _ZN6S244C63v45Ev();
extern void _ZN6S244C63v46Ev();
extern void _ZN6S244C63v47Ev();
extern void _ZN6S244C63v48Ev();
extern void _ZN6S244C63v49Ev();
extern void _ZN6S244C63v50Ev();
extern void _ZN6S244C63v51Ev();
extern void _ZN6S244C63v52Ev();
extern void _ZN6S244C63v53Ev();
extern void _ZN6S244C63v54Ev();
extern void _ZN6S244C63v55Ev();
extern void _ZN6S244C63v56Ev();
extern void _ZN6S244C63v57Ev();
extern void _ZN6S244C63v58Ev();
extern void _ZN6S244C63v59Ev();
extern void _ZN6S244C63v60Ev();
extern void _ZN6S244C63v61Ev();
extern void _ZN6S244C63v62Ev();
extern void _ZN6S244C63v63Ev();
extern void _ZN6S244C63v64Ev();
extern void _ZN6S244C63v65Ev();
extern void _ZN6S244C63v66Ev();
extern void _ZN6S244C63v67Ev();
extern void _ZN6S244C63v68Ev();
extern void _ZN9S244C5_nt3v69Ev();
extern void _ZN9S244C5_nt3v70Ev();
extern void _ZN9S244C5_nt3v71Ev();
extern void _ZN9S244C5_nt3v72Ev();
extern void _ZN9S244C5_nt3v73Ev();
extern void _ZN9S244C5_nt3v74Ev();
extern void _ZN9S244C5_nt3v75Ev();
extern void _ZN9S244C5_nt3v76Ev();
extern void _ZN9S244C5_nt3v77Ev();
extern void _ZN9S244C5_nt3v78Ev();
extern void _ZN9S244C5_nt3v79Ev();
extern void _ZN9S244C5_nt3v80Ev();
extern void _ZN9S244C5_nt3v81Ev();
extern void _ZN9S244C5_nt3v82Ev();
extern void _ZN9S244C5_nt3v83Ev();
extern void _ZN9S244C5_nt3v84Ev();
extern void _ZN9S244C5_nt3v85Ev();
extern void _ZN9S244C5_nt3v86Ev();
extern void _ZN9S244C5_nt3v87Ev();
extern void _ZN9S244C5_nt3v88Ev();
extern void _ZN9S244C5_nt3v89Ev();
extern void _ZN9S244C5_nt3v90Ev();
extern void _ZN9S244C4_nt3v91Ev();
extern void _ZN9S244C4_nt3v92Ev();
extern void _ZN9S244C4_nt3v93Ev();
extern void _ZN9S244C4_nt3v94Ev();
extern void _ZN9S244C4_nt3v95Ev();
extern void _ZN9S244C4_nt3v96Ev();
extern void _ZN9S244C4_nt3v97Ev();
extern void _ZN9S244C4_nt3v98Ev();
extern void _ZN9S244C4_nt3v99Ev();
extern void _ZN9S244C4_nt4v100Ev();
extern void _ZN9S244C4_nt4v101Ev();
extern void _ZN9S244C4_nt4v102Ev();
extern void _ZN9S244C4_nt4v103Ev();
extern void _ZN9S244C4_nt4v104Ev();
extern void _ZN9S244C4_nt4v105Ev();
extern void _ZN9S244C4_nt4v106Ev();
extern void _ZN9S244C4_nt4v107Ev();
extern void _ZN9S244C4_nt4v108Ev();
extern void _ZN9S244C4_nt4v109Ev();
extern void _ZN9S244C4_nt4v110Ev();
extern void _ZN9S244C3_nt4v111Ev();
extern void _ZN9S244C3_nt4v112Ev();
extern void _ZN9S244C3_nt4v113Ev();
extern void _ZN9S244C3_nt4v114Ev();
extern void _ZN9S244C2_nt4v115Ev();
extern void _ZN9S244C2_nt4v116Ev();
extern void _ZN9S244C2_nt4v117Ev();
extern void _ZN9S244C2_nt4v118Ev();
extern void _ZN9S244C2_nt4v119Ev();
extern void _ZN9S244C2_nt4v120Ev();
extern void _ZN9S244C2_nt4v121Ev();
extern void _ZN9S244C2_nt4v122Ev();
extern void _ZN6S244C12v1Ev();
extern void _ZN6S244C12v2Ev();
extern void _ZN6S244C12v3Ev();
extern void _ZN6S244C12v4Ev();
static  VTBL_ENTRY vtc_S244C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S244C1[0]),
  (VTBL_ENTRY)&_ZN6S244C1D1Ev,
  (VTBL_ENTRY)&_ZN6S244C1D0Ev,
  (VTBL_ENTRY)&_ZN6S244C62v5Ev,
  (VTBL_ENTRY)&_ZN6S244C62v6Ev,
  (VTBL_ENTRY)&_ZN6S244C62v7Ev,
  (VTBL_ENTRY)&_ZN6S244C62v8Ev,
  (VTBL_ENTRY)&_ZN6S244C62v9Ev,
  (VTBL_ENTRY)&_ZN6S244C63v10Ev,
  (VTBL_ENTRY)&_ZN6S244C63v11Ev,
  (VTBL_ENTRY)&_ZN6S244C63v12Ev,
  (VTBL_ENTRY)&_ZN6S244C63v13Ev,
  (VTBL_ENTRY)&_ZN6S244C63v14Ev,
  (VTBL_ENTRY)&_ZN6S244C63v15Ev,
  (VTBL_ENTRY)&_ZN6S244C63v16Ev,
  (VTBL_ENTRY)&_ZN6S244C63v17Ev,
  (VTBL_ENTRY)&_ZN6S244C63v18Ev,
  (VTBL_ENTRY)&_ZN6S244C63v19Ev,
  (VTBL_ENTRY)&_ZN6S244C63v20Ev,
  (VTBL_ENTRY)&_ZN6S244C63v21Ev,
  (VTBL_ENTRY)&_ZN6S244C63v22Ev,
  (VTBL_ENTRY)&_ZN6S244C63v23Ev,
  (VTBL_ENTRY)&_ZN6S244C63v24Ev,
  (VTBL_ENTRY)&_ZN6S244C63v25Ev,
  (VTBL_ENTRY)&_ZN6S244C63v26Ev,
  (VTBL_ENTRY)&_ZN6S244C63v27Ev,
  (VTBL_ENTRY)&_ZN6S244C63v28Ev,
  (VTBL_ENTRY)&_ZN6S244C63v29Ev,
  (VTBL_ENTRY)&_ZN6S244C63v30Ev,
  (VTBL_ENTRY)&_ZN6S244C63v31Ev,
  (VTBL_ENTRY)&_ZN6S244C63v32Ev,
  (VTBL_ENTRY)&_ZN6S244C63v33Ev,
  (VTBL_ENTRY)&_ZN6S244C63v34Ev,
  (VTBL_ENTRY)&_ZN6S244C63v35Ev,
  (VTBL_ENTRY)&_ZN6S244C63v36Ev,
  (VTBL_ENTRY)&_ZN6S244C63v37Ev,
  (VTBL_ENTRY)&_ZN6S244C63v38Ev,
  (VTBL_ENTRY)&_ZN6S244C63v39Ev,
  (VTBL_ENTRY)&_ZN6S244C63v40Ev,
  (VTBL_ENTRY)&_ZN6S244C63v41Ev,
  (VTBL_ENTRY)&_ZN6S244C63v42Ev,
  (VTBL_ENTRY)&_ZN6S244C63v43Ev,
  (VTBL_ENTRY)&_ZN6S244C63v44Ev,
  (VTBL_ENTRY)&_ZN6S244C63v45Ev,
  (VTBL_ENTRY)&_ZN6S244C63v46Ev,
  (VTBL_ENTRY)&_ZN6S244C63v47Ev,
  (VTBL_ENTRY)&_ZN6S244C63v48Ev,
  (VTBL_ENTRY)&_ZN6S244C63v49Ev,
  (VTBL_ENTRY)&_ZN6S244C63v50Ev,
  (VTBL_ENTRY)&_ZN6S244C63v51Ev,
  (VTBL_ENTRY)&_ZN6S244C63v52Ev,
  (VTBL_ENTRY)&_ZN6S244C63v53Ev,
  (VTBL_ENTRY)&_ZN6S244C63v54Ev,
  (VTBL_ENTRY)&_ZN6S244C63v55Ev,
  (VTBL_ENTRY)&_ZN6S244C63v56Ev,
  (VTBL_ENTRY)&_ZN6S244C63v57Ev,
  (VTBL_ENTRY)&_ZN6S244C63v58Ev,
  (VTBL_ENTRY)&_ZN6S244C63v59Ev,
  (VTBL_ENTRY)&_ZN6S244C63v60Ev,
  (VTBL_ENTRY)&_ZN6S244C63v61Ev,
  (VTBL_ENTRY)&_ZN6S244C63v62Ev,
  (VTBL_ENTRY)&_ZN6S244C63v63Ev,
  (VTBL_ENTRY)&_ZN6S244C63v64Ev,
  (VTBL_ENTRY)&_ZN6S244C63v65Ev,
  (VTBL_ENTRY)&_ZN6S244C63v66Ev,
  (VTBL_ENTRY)&_ZN6S244C63v67Ev,
  (VTBL_ENTRY)&_ZN6S244C63v68Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S244C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S244C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S244C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S244C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S244C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S244C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S244C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S244C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S244C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S244C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S244C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S244C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S244C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S244C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN6S244C12v1Ev,
  (VTBL_ENTRY)&_ZN6S244C12v2Ev,
  (VTBL_ENTRY)&_ZN6S244C12v3Ev,
  (VTBL_ENTRY)&_ZN6S244C12v4Ev,
};
extern VTBL_ENTRY _ZTI6S244C1[];
extern  VTBL_ENTRY _ZTV6S244C1[];
Class_Descriptor cd_S244C1 = {  "S244C1", // class name
  bases_S244C1, 5,
  &(vtc_S244C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(336,244), // object size
  NSPAIRA(_ZTI6S244C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S244C1),126, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S200C6  {
  int s200c6f0;
  __tsi64 s200c6f1;
  void *s200c6f2[4];
  int s200c6f3[2];
  void *s200c6f4;
  ::S3443C4_nt s200c6f5;
  void *s200c6f6[2];
  virtual  ~S200C6(); // _ZN6S200C6D1Ev
  virtual void  v4(); // _ZN6S200C62v4Ev
  virtual void  v5(); // _ZN6S200C62v5Ev
  virtual void  v6(); // _ZN6S200C62v6Ev
  virtual void  v7(); // _ZN6S200C62v7Ev
  virtual void  v8(); // _ZN6S200C62v8Ev
  virtual void  v9(); // _ZN6S200C62v9Ev
  virtual void  v10(); // _ZN6S200C63v10Ev
  virtual void  v11(); // _ZN6S200C63v11Ev
  virtual void  v12(); // _ZN6S200C63v12Ev
  virtual void  v13(); // _ZN6S200C63v13Ev
  virtual void  v14(); // _ZN6S200C63v14Ev
  virtual void  v15(); // _ZN6S200C63v15Ev
  virtual void  v16(); // _ZN6S200C63v16Ev
  virtual void  v17(); // _ZN6S200C63v17Ev
  virtual void  v18(); // _ZN6S200C63v18Ev
  virtual void  v19(); // _ZN6S200C63v19Ev
  virtual void  v20(); // _ZN6S200C63v20Ev
  virtual void  v21(); // _ZN6S200C63v21Ev
  virtual void  v22(); // _ZN6S200C63v22Ev
  virtual void  v23(); // _ZN6S200C63v23Ev
  virtual void  v24(); // _ZN6S200C63v24Ev
  virtual void  v25(); // _ZN6S200C63v25Ev
  virtual void  v26(); // _ZN6S200C63v26Ev
  virtual void  v27(); // _ZN6S200C63v27Ev
  virtual void  v28(); // _ZN6S200C63v28Ev
  virtual void  v29(); // _ZN6S200C63v29Ev
  virtual void  v30(); // _ZN6S200C63v30Ev
  virtual void  v31(); // _ZN6S200C63v31Ev
  virtual void  v32(); // _ZN6S200C63v32Ev
  virtual void  v33(); // _ZN6S200C63v33Ev
  virtual void  v34(); // _ZN6S200C63v34Ev
  virtual void  v35(); // _ZN6S200C63v35Ev
  virtual void  v36(); // _ZN6S200C63v36Ev
  virtual void  v37(); // _ZN6S200C63v37Ev
  virtual void  v38(); // _ZN6S200C63v38Ev
  virtual void  v39(); // _ZN6S200C63v39Ev
  virtual void  v40(); // _ZN6S200C63v40Ev
  virtual void  v41(); // _ZN6S200C63v41Ev
  virtual void  v42(); // _ZN6S200C63v42Ev
  virtual void  v43(); // _ZN6S200C63v43Ev
  virtual void  v44(); // _ZN6S200C63v44Ev
  virtual void  v45(); // _ZN6S200C63v45Ev
  virtual void  v46(); // _ZN6S200C63v46Ev
  virtual void  v47(); // _ZN6S200C63v47Ev
  virtual void  v48(); // _ZN6S200C63v48Ev
  virtual void  v49(); // _ZN6S200C63v49Ev
  virtual void  v50(); // _ZN6S200C63v50Ev
  virtual void  v51(); // _ZN6S200C63v51Ev
  virtual void  v52(); // _ZN6S200C63v52Ev
  virtual void  v53(); // _ZN6S200C63v53Ev
  virtual void  v54(); // _ZN6S200C63v54Ev
  virtual void  v55(); // _ZN6S200C63v55Ev
  virtual void  v56(); // _ZN6S200C63v56Ev
  virtual void  v57(); // _ZN6S200C63v57Ev
  virtual void  v58(); // _ZN6S200C63v58Ev
  virtual void  v59(); // _ZN6S200C63v59Ev
  virtual void  v60(); // _ZN6S200C63v60Ev
  virtual void  v61(); // _ZN6S200C63v61Ev
  virtual void  v62(); // _ZN6S200C63v62Ev
  virtual void  v63(); // _ZN6S200C63v63Ev
  virtual void  v64(); // _ZN6S200C63v64Ev
  virtual void  v65(); // _ZN6S200C63v65Ev
  virtual void  v66(); // _ZN6S200C63v66Ev
  virtual void  v67(); // _ZN6S200C63v67Ev
  S200C6(); // tgen
};
//SIG(-1 S200C6) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S200C6 ::~S200C6(){ note_dtor("S200C6", this);}
void  S200C6 ::v4(){vfunc_called(this, "_ZN6S200C62v4Ev");}
void  S200C6 ::v5(){vfunc_called(this, "_ZN6S200C62v5Ev");}
void  S200C6 ::v6(){vfunc_called(this, "_ZN6S200C62v6Ev");}
void  S200C6 ::v7(){vfunc_called(this, "_ZN6S200C62v7Ev");}
void  S200C6 ::v8(){vfunc_called(this, "_ZN6S200C62v8Ev");}
void  S200C6 ::v9(){vfunc_called(this, "_ZN6S200C62v9Ev");}
void  S200C6 ::v10(){vfunc_called(this, "_ZN6S200C63v10Ev");}
void  S200C6 ::v11(){vfunc_called(this, "_ZN6S200C63v11Ev");}
void  S200C6 ::v12(){vfunc_called(this, "_ZN6S200C63v12Ev");}
void  S200C6 ::v13(){vfunc_called(this, "_ZN6S200C63v13Ev");}
void  S200C6 ::v14(){vfunc_called(this, "_ZN6S200C63v14Ev");}
void  S200C6 ::v15(){vfunc_called(this, "_ZN6S200C63v15Ev");}
void  S200C6 ::v16(){vfunc_called(this, "_ZN6S200C63v16Ev");}
void  S200C6 ::v17(){vfunc_called(this, "_ZN6S200C63v17Ev");}
void  S200C6 ::v18(){vfunc_called(this, "_ZN6S200C63v18Ev");}
void  S200C6 ::v19(){vfunc_called(this, "_ZN6S200C63v19Ev");}
void  S200C6 ::v20(){vfunc_called(this, "_ZN6S200C63v20Ev");}
void  S200C6 ::v21(){vfunc_called(this, "_ZN6S200C63v21Ev");}
void  S200C6 ::v22(){vfunc_called(this, "_ZN6S200C63v22Ev");}
void  S200C6 ::v23(){vfunc_called(this, "_ZN6S200C63v23Ev");}
void  S200C6 ::v24(){vfunc_called(this, "_ZN6S200C63v24Ev");}
void  S200C6 ::v25(){vfunc_called(this, "_ZN6S200C63v25Ev");}
void  S200C6 ::v26(){vfunc_called(this, "_ZN6S200C63v26Ev");}
void  S200C6 ::v27(){vfunc_called(this, "_ZN6S200C63v27Ev");}
void  S200C6 ::v28(){vfunc_called(this, "_ZN6S200C63v28Ev");}
void  S200C6 ::v29(){vfunc_called(this, "_ZN6S200C63v29Ev");}
void  S200C6 ::v30(){vfunc_called(this, "_ZN6S200C63v30Ev");}
void  S200C6 ::v31(){vfunc_called(this, "_ZN6S200C63v31Ev");}
void  S200C6 ::v32(){vfunc_called(this, "_ZN6S200C63v32Ev");}
void  S200C6 ::v33(){vfunc_called(this, "_ZN6S200C63v33Ev");}
void  S200C6 ::v34(){vfunc_called(this, "_ZN6S200C63v34Ev");}
void  S200C6 ::v35(){vfunc_called(this, "_ZN6S200C63v35Ev");}
void  S200C6 ::v36(){vfunc_called(this, "_ZN6S200C63v36Ev");}
void  S200C6 ::v37(){vfunc_called(this, "_ZN6S200C63v37Ev");}
void  S200C6 ::v38(){vfunc_called(this, "_ZN6S200C63v38Ev");}
void  S200C6 ::v39(){vfunc_called(this, "_ZN6S200C63v39Ev");}
void  S200C6 ::v40(){vfunc_called(this, "_ZN6S200C63v40Ev");}
void  S200C6 ::v41(){vfunc_called(this, "_ZN6S200C63v41Ev");}
void  S200C6 ::v42(){vfunc_called(this, "_ZN6S200C63v42Ev");}
void  S200C6 ::v43(){vfunc_called(this, "_ZN6S200C63v43Ev");}
void  S200C6 ::v44(){vfunc_called(this, "_ZN6S200C63v44Ev");}
void  S200C6 ::v45(){vfunc_called(this, "_ZN6S200C63v45Ev");}
void  S200C6 ::v46(){vfunc_called(this, "_ZN6S200C63v46Ev");}
void  S200C6 ::v47(){vfunc_called(this, "_ZN6S200C63v47Ev");}
void  S200C6 ::v48(){vfunc_called(this, "_ZN6S200C63v48Ev");}
void  S200C6 ::v49(){vfunc_called(this, "_ZN6S200C63v49Ev");}
void  S200C6 ::v50(){vfunc_called(this, "_ZN6S200C63v50Ev");}
void  S200C6 ::v51(){vfunc_called(this, "_ZN6S200C63v51Ev");}
void  S200C6 ::v52(){vfunc_called(this, "_ZN6S200C63v52Ev");}
void  S200C6 ::v53(){vfunc_called(this, "_ZN6S200C63v53Ev");}
void  S200C6 ::v54(){vfunc_called(this, "_ZN6S200C63v54Ev");}
void  S200C6 ::v55(){vfunc_called(this, "_ZN6S200C63v55Ev");}
void  S200C6 ::v56(){vfunc_called(this, "_ZN6S200C63v56Ev");}
void  S200C6 ::v57(){vfunc_called(this, "_ZN6S200C63v57Ev");}
void  S200C6 ::v58(){vfunc_called(this, "_ZN6S200C63v58Ev");}
void  S200C6 ::v59(){vfunc_called(this, "_ZN6S200C63v59Ev");}
void  S200C6 ::v60(){vfunc_called(this, "_ZN6S200C63v60Ev");}
void  S200C6 ::v61(){vfunc_called(this, "_ZN6S200C63v61Ev");}
void  S200C6 ::v62(){vfunc_called(this, "_ZN6S200C63v62Ev");}
void  S200C6 ::v63(){vfunc_called(this, "_ZN6S200C63v63Ev");}
void  S200C6 ::v64(){vfunc_called(this, "_ZN6S200C63v64Ev");}
void  S200C6 ::v65(){vfunc_called(this, "_ZN6S200C63v65Ev");}
void  S200C6 ::v66(){vfunc_called(this, "_ZN6S200C63v66Ev");}
void  S200C6 ::v67(){vfunc_called(this, "_ZN6S200C63v67Ev");}
S200C6 ::S200C6(){ note_ctor("S200C6", this);} // tgen

static void Test_S200C6()
{
  extern Class_Descriptor cd_S200C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S200C6, buf);
    S200C6 *dp, &lv = *(dp=new (buf) S200C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S200C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S200C6)");
    check_field_offset(lv, s200c6f0, ABISELECT(8,4), "S200C6.s200c6f0");
    check_field_offset(lv, s200c6f1, ABISELECT(16,8), "S200C6.s200c6f1");
    check_field_offset(lv, s200c6f2, ABISELECT(24,16), "S200C6.s200c6f2");
    check_field_offset(lv, s200c6f3, ABISELECT(56,32), "S200C6.s200c6f3");
    check_field_offset(lv, s200c6f4, ABISELECT(64,40), "S200C6.s200c6f4");
    check_field_offset(lv, s200c6f5, ABISELECT(72,44), "S200C6.s200c6f5");
    check_field_offset(lv, s200c6f6, ABISELECT(80,52), "S200C6.s200c6f6");
    test_class_info(&lv, &cd_S200C6);
    dp->~S200C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS200C6(Test_S200C6, "S200C6", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S200C6C1Ev();
extern void _ZN6S200C6D1Ev();
Name_Map name_map_S200C6[] = {
  NSPAIR(_ZN6S200C6C1Ev),
  NSPAIR(_ZN6S200C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S200C6[];
extern void _ZN6S200C6D1Ev();
extern void _ZN6S200C6D0Ev();
extern void _ZN6S200C62v4Ev();
extern void _ZN6S200C62v5Ev();
extern void _ZN6S200C62v6Ev();
extern void _ZN6S200C62v7Ev();
extern void _ZN6S200C62v8Ev();
extern void _ZN6S200C62v9Ev();
extern void _ZN6S200C63v10Ev();
extern void _ZN6S200C63v11Ev();
extern void _ZN6S200C63v12Ev();
extern void _ZN6S200C63v13Ev();
extern void _ZN6S200C63v14Ev();
extern void _ZN6S200C63v15Ev();
extern void _ZN6S200C63v16Ev();
extern void _ZN6S200C63v17Ev();
extern void _ZN6S200C63v18Ev();
extern void _ZN6S200C63v19Ev();
extern void _ZN6S200C63v20Ev();
extern void _ZN6S200C63v21Ev();
extern void _ZN6S200C63v22Ev();
extern void _ZN6S200C63v23Ev();
extern void _ZN6S200C63v24Ev();
extern void _ZN6S200C63v25Ev();
extern void _ZN6S200C63v26Ev();
extern void _ZN6S200C63v27Ev();
extern void _ZN6S200C63v28Ev();
extern void _ZN6S200C63v29Ev();
extern void _ZN6S200C63v30Ev();
extern void _ZN6S200C63v31Ev();
extern void _ZN6S200C63v32Ev();
extern void _ZN6S200C63v33Ev();
extern void _ZN6S200C63v34Ev();
extern void _ZN6S200C63v35Ev();
extern void _ZN6S200C63v36Ev();
extern void _ZN6S200C63v37Ev();
extern void _ZN6S200C63v38Ev();
extern void _ZN6S200C63v39Ev();
extern void _ZN6S200C63v40Ev();
extern void _ZN6S200C63v41Ev();
extern void _ZN6S200C63v42Ev();
extern void _ZN6S200C63v43Ev();
extern void _ZN6S200C63v44Ev();
extern void _ZN6S200C63v45Ev();
extern void _ZN6S200C63v46Ev();
extern void _ZN6S200C63v47Ev();
extern void _ZN6S200C63v48Ev();
extern void _ZN6S200C63v49Ev();
extern void _ZN6S200C63v50Ev();
extern void _ZN6S200C63v51Ev();
extern void _ZN6S200C63v52Ev();
extern void _ZN6S200C63v53Ev();
extern void _ZN6S200C63v54Ev();
extern void _ZN6S200C63v55Ev();
extern void _ZN6S200C63v56Ev();
extern void _ZN6S200C63v57Ev();
extern void _ZN6S200C63v58Ev();
extern void _ZN6S200C63v59Ev();
extern void _ZN6S200C63v60Ev();
extern void _ZN6S200C63v61Ev();
extern void _ZN6S200C63v62Ev();
extern void _ZN6S200C63v63Ev();
extern void _ZN6S200C63v64Ev();
extern void _ZN6S200C63v65Ev();
extern void _ZN6S200C63v66Ev();
extern void _ZN6S200C63v67Ev();
static  VTBL_ENTRY vtc_S200C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S200C6[0]),
  (VTBL_ENTRY)&_ZN6S200C6D1Ev,
  (VTBL_ENTRY)&_ZN6S200C6D0Ev,
  (VTBL_ENTRY)&_ZN6S200C62v4Ev,
  (VTBL_ENTRY)&_ZN6S200C62v5Ev,
  (VTBL_ENTRY)&_ZN6S200C62v6Ev,
  (VTBL_ENTRY)&_ZN6S200C62v7Ev,
  (VTBL_ENTRY)&_ZN6S200C62v8Ev,
  (VTBL_ENTRY)&_ZN6S200C62v9Ev,
  (VTBL_ENTRY)&_ZN6S200C63v10Ev,
  (VTBL_ENTRY)&_ZN6S200C63v11Ev,
  (VTBL_ENTRY)&_ZN6S200C63v12Ev,
  (VTBL_ENTRY)&_ZN6S200C63v13Ev,
  (VTBL_ENTRY)&_ZN6S200C63v14Ev,
  (VTBL_ENTRY)&_ZN6S200C63v15Ev,
  (VTBL_ENTRY)&_ZN6S200C63v16Ev,
  (VTBL_ENTRY)&_ZN6S200C63v17Ev,
  (VTBL_ENTRY)&_ZN6S200C63v18Ev,
  (VTBL_ENTRY)&_ZN6S200C63v19Ev,
  (VTBL_ENTRY)&_ZN6S200C63v20Ev,
  (VTBL_ENTRY)&_ZN6S200C63v21Ev,
  (VTBL_ENTRY)&_ZN6S200C63v22Ev,
  (VTBL_ENTRY)&_ZN6S200C63v23Ev,
  (VTBL_ENTRY)&_ZN6S200C63v24Ev,
  (VTBL_ENTRY)&_ZN6S200C63v25Ev,
  (VTBL_ENTRY)&_ZN6S200C63v26Ev,
  (VTBL_ENTRY)&_ZN6S200C63v27Ev,
  (VTBL_ENTRY)&_ZN6S200C63v28Ev,
  (VTBL_ENTRY)&_ZN6S200C63v29Ev,
  (VTBL_ENTRY)&_ZN6S200C63v30Ev,
  (VTBL_ENTRY)&_ZN6S200C63v31Ev,
  (VTBL_ENTRY)&_ZN6S200C63v32Ev,
  (VTBL_ENTRY)&_ZN6S200C63v33Ev,
  (VTBL_ENTRY)&_ZN6S200C63v34Ev,
  (VTBL_ENTRY)&_ZN6S200C63v35Ev,
  (VTBL_ENTRY)&_ZN6S200C63v36Ev,
  (VTBL_ENTRY)&_ZN6S200C63v37Ev,
  (VTBL_ENTRY)&_ZN6S200C63v38Ev,
  (VTBL_ENTRY)&_ZN6S200C63v39Ev,
  (VTBL_ENTRY)&_ZN6S200C63v40Ev,
  (VTBL_ENTRY)&_ZN6S200C63v41Ev,
  (VTBL_ENTRY)&_ZN6S200C63v42Ev,
  (VTBL_ENTRY)&_ZN6S200C63v43Ev,
  (VTBL_ENTRY)&_ZN6S200C63v44Ev,
  (VTBL_ENTRY)&_ZN6S200C63v45Ev,
  (VTBL_ENTRY)&_ZN6S200C63v46Ev,
  (VTBL_ENTRY)&_ZN6S200C63v47Ev,
  (VTBL_ENTRY)&_ZN6S200C63v48Ev,
  (VTBL_ENTRY)&_ZN6S200C63v49Ev,
  (VTBL_ENTRY)&_ZN6S200C63v50Ev,
  (VTBL_ENTRY)&_ZN6S200C63v51Ev,
  (VTBL_ENTRY)&_ZN6S200C63v52Ev,
  (VTBL_ENTRY)&_ZN6S200C63v53Ev,
  (VTBL_ENTRY)&_ZN6S200C63v54Ev,
  (VTBL_ENTRY)&_ZN6S200C63v55Ev,
  (VTBL_ENTRY)&_ZN6S200C63v56Ev,
  (VTBL_ENTRY)&_ZN6S200C63v57Ev,
  (VTBL_ENTRY)&_ZN6S200C63v58Ev,
  (VTBL_ENTRY)&_ZN6S200C63v59Ev,
  (VTBL_ENTRY)&_ZN6S200C63v60Ev,
  (VTBL_ENTRY)&_ZN6S200C63v61Ev,
  (VTBL_ENTRY)&_ZN6S200C63v62Ev,
  (VTBL_ENTRY)&_ZN6S200C63v63Ev,
  (VTBL_ENTRY)&_ZN6S200C63v64Ev,
  (VTBL_ENTRY)&_ZN6S200C63v65Ev,
  (VTBL_ENTRY)&_ZN6S200C63v66Ev,
  (VTBL_ENTRY)&_ZN6S200C63v67Ev,
};
extern VTBL_ENTRY _ZTI6S200C6[];
extern  VTBL_ENTRY _ZTV6S200C6[];
Class_Descriptor cd_S200C6 = {  "S200C6", // class name
  0,0,//no base classes
  &(vtc_S200C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S200C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S200C6),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S200C5  : S200C6 {
  int s200c5f0[2];
  void *s200c5f1;
  int s200c5f2[2];
  ::S244C8_nt s200c5f3;
  ::S244C8_nt s200c5f4;
  ::S2122C38 s200c5f5;
  ::S244C8_nt s200c5f6;
  unsigned int s200c5f7:1;
  unsigned int s200c5f8:1;
  unsigned int s200c5f9:1;
  unsigned int s200c5f10:1;
  unsigned int s200c5f11:1;
  int s200c5f12[2];
  virtual  ~S200C5(); // _ZN6S200C5D1Ev
  virtual void  v68(); // _ZN6S200C53v68Ev
  virtual void  v69(); // _ZN6S200C53v69Ev
  virtual void  v70(); // _ZN6S200C53v70Ev
  virtual void  v71(); // _ZN6S200C53v71Ev
  virtual void  v72(); // _ZN6S200C53v72Ev
  virtual void  v73(); // _ZN6S200C53v73Ev
  virtual void  v74(); // _ZN6S200C53v74Ev
  virtual void  v75(); // _ZN6S200C53v75Ev
  virtual void  v76(); // _ZN6S200C53v76Ev
  virtual void  v77(); // _ZN6S200C53v77Ev
  virtual void  v78(); // _ZN6S200C53v78Ev
  virtual void  v79(); // _ZN6S200C53v79Ev
  virtual void  v80(); // _ZN6S200C53v80Ev
  virtual void  v81(); // _ZN6S200C53v81Ev
  virtual void  v82(); // _ZN6S200C53v82Ev
  virtual void  v83(); // _ZN6S200C53v83Ev
  virtual void  v84(); // _ZN6S200C53v84Ev
  virtual void  v85(); // _ZN6S200C53v85Ev
  virtual void  v86(); // _ZN6S200C53v86Ev
  virtual void  v87(); // _ZN6S200C53v87Ev
  virtual void  v88(); // _ZN6S200C53v88Ev
  virtual void  v89(); // _ZN6S200C53v89Ev
  S200C5(); // tgen
};
//SIG(-1 S200C5) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S200C5 ::~S200C5(){ note_dtor("S200C5", this);}
void  S200C5 ::v68(){vfunc_called(this, "_ZN6S200C53v68Ev");}
void  S200C5 ::v69(){vfunc_called(this, "_ZN6S200C53v69Ev");}
void  S200C5 ::v70(){vfunc_called(this, "_ZN6S200C53v70Ev");}
void  S200C5 ::v71(){vfunc_called(this, "_ZN6S200C53v71Ev");}
void  S200C5 ::v72(){vfunc_called(this, "_ZN6S200C53v72Ev");}
void  S200C5 ::v73(){vfunc_called(this, "_ZN6S200C53v73Ev");}
void  S200C5 ::v74(){vfunc_called(this, "_ZN6S200C53v74Ev");}
void  S200C5 ::v75(){vfunc_called(this, "_ZN6S200C53v75Ev");}
void  S200C5 ::v76(){vfunc_called(this, "_ZN6S200C53v76Ev");}
void  S200C5 ::v77(){vfunc_called(this, "_ZN6S200C53v77Ev");}
void  S200C5 ::v78(){vfunc_called(this, "_ZN6S200C53v78Ev");}
void  S200C5 ::v79(){vfunc_called(this, "_ZN6S200C53v79Ev");}
void  S200C5 ::v80(){vfunc_called(this, "_ZN6S200C53v80Ev");}
void  S200C5 ::v81(){vfunc_called(this, "_ZN6S200C53v81Ev");}
void  S200C5 ::v82(){vfunc_called(this, "_ZN6S200C53v82Ev");}
void  S200C5 ::v83(){vfunc_called(this, "_ZN6S200C53v83Ev");}
void  S200C5 ::v84(){vfunc_called(this, "_ZN6S200C53v84Ev");}
void  S200C5 ::v85(){vfunc_called(this, "_ZN6S200C53v85Ev");}
void  S200C5 ::v86(){vfunc_called(this, "_ZN6S200C53v86Ev");}
void  S200C5 ::v87(){vfunc_called(this, "_ZN6S200C53v87Ev");}
void  S200C5 ::v88(){vfunc_called(this, "_ZN6S200C53v88Ev");}
void  S200C5 ::v89(){vfunc_called(this, "_ZN6S200C53v89Ev");}
S200C5 ::S200C5(){ note_ctor("S200C5", this);} // tgen

static void Test_S200C5()
{
  extern Class_Descriptor cd_S200C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S200C5, buf);
    S200C5 *dp, &lv = *(dp=new (buf) S200C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S200C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S200C5)");
    check_base_class_offset(lv, (S200C6*), 0, "S200C5");
    check_field_offset(lv, s200c5f0, ABISELECT(96,60), "S200C5.s200c5f0");
    check_field_offset(lv, s200c5f1, ABISELECT(104,68), "S200C5.s200c5f1");
    check_field_offset(lv, s200c5f2, ABISELECT(112,72), "S200C5.s200c5f2");
    check_field_offset(lv, s200c5f3, ABISELECT(120,80), "S200C5.s200c5f3");
    check_field_offset(lv, s200c5f4, ABISELECT(136,92), "S200C5.s200c5f4");
    check_field_offset(lv, s200c5f5, ABISELECT(152,104), "S200C5.s200c5f5");
    check_field_offset(lv, s200c5f6, ABISELECT(160,108), "S200C5.s200c5f6");
    set_bf_and_test(lv, s200c5f7, ABISELECT(176,120), 0, 1, 1, "S200C5");
    set_bf_and_test(lv, s200c5f8, ABISELECT(176,120), 1, 1, 1, "S200C5");
    set_bf_and_test(lv, s200c5f9, ABISELECT(176,120), 2, 1, 1, "S200C5");
    set_bf_and_test(lv, s200c5f10, ABISELECT(176,120), 3, 1, 1, "S200C5");
    set_bf_and_test(lv, s200c5f11, ABISELECT(176,120), 4, 1, 1, "S200C5");
    check_field_offset(lv, s200c5f12, ABISELECT(180,124), "S200C5.s200c5f12");
    test_class_info(&lv, &cd_S200C5);
    dp->~S200C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS200C5(Test_S200C5, "S200C5", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN6S200C5C1Ev();
extern void _ZN6S200C5D1Ev();
Name_Map name_map_S200C5[] = {
  NSPAIR(_ZN6S200C5C1Ev),
  NSPAIR(_ZN6S200C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S200C6;
extern VTBL_ENTRY _ZTI6S200C6[];
extern  VTBL_ENTRY _ZTV6S200C6[];
static Base_Class bases_S200C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S200C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S200C5[];
extern void _ZN6S200C5D1Ev();
extern void _ZN6S200C5D0Ev();
extern void _ZN6S200C62v4Ev();
extern void _ZN6S200C62v5Ev();
extern void _ZN6S200C62v6Ev();
extern void _ZN6S200C62v7Ev();
extern void _ZN6S200C62v8Ev();
extern void _ZN6S200C62v9Ev();
extern void _ZN6S200C63v10Ev();
extern void _ZN6S200C63v11Ev();
extern void _ZN6S200C63v12Ev();
extern void _ZN6S200C63v13Ev();
extern void _ZN6S200C63v14Ev();
extern void _ZN6S200C63v15Ev();
extern void _ZN6S200C63v16Ev();
extern void _ZN6S200C63v17Ev();
extern void _ZN6S200C63v18Ev();
extern void _ZN6S200C63v19Ev();
extern void _ZN6S200C63v20Ev();
extern void _ZN6S200C63v21Ev();
extern void _ZN6S200C63v22Ev();
extern void _ZN6S200C63v23Ev();
extern void _ZN6S200C63v24Ev();
extern void _ZN6S200C63v25Ev();
extern void _ZN6S200C63v26Ev();
extern void _ZN6S200C63v27Ev();
extern void _ZN6S200C63v28Ev();
extern void _ZN6S200C63v29Ev();
extern void _ZN6S200C63v30Ev();
extern void _ZN6S200C63v31Ev();
extern void _ZN6S200C63v32Ev();
extern void _ZN6S200C63v33Ev();
extern void _ZN6S200C63v34Ev();
extern void _ZN6S200C63v35Ev();
extern void _ZN6S200C63v36Ev();
extern void _ZN6S200C63v37Ev();
extern void _ZN6S200C63v38Ev();
extern void _ZN6S200C63v39Ev();
extern void _ZN6S200C63v40Ev();
extern void _ZN6S200C63v41Ev();
extern void _ZN6S200C63v42Ev();
extern void _ZN6S200C63v43Ev();
extern void _ZN6S200C63v44Ev();
extern void _ZN6S200C63v45Ev();
extern void _ZN6S200C63v46Ev();
extern void _ZN6S200C63v47Ev();
extern void _ZN6S200C63v48Ev();
extern void _ZN6S200C63v49Ev();
extern void _ZN6S200C63v50Ev();
extern void _ZN6S200C63v51Ev();
extern void _ZN6S200C63v52Ev();
extern void _ZN6S200C63v53Ev();
extern void _ZN6S200C63v54Ev();
extern void _ZN6S200C63v55Ev();
extern void _ZN6S200C63v56Ev();
extern void _ZN6S200C63v57Ev();
extern void _ZN6S200C63v58Ev();
extern void _ZN6S200C63v59Ev();
extern void _ZN6S200C63v60Ev();
extern void _ZN6S200C63v61Ev();
extern void _ZN6S200C63v62Ev();
extern void _ZN6S200C63v63Ev();
extern void _ZN6S200C63v64Ev();
extern void _ZN6S200C63v65Ev();
extern void _ZN6S200C63v66Ev();
extern void _ZN6S200C63v67Ev();
extern void _ZN6S200C53v68Ev();
extern void _ZN6S200C53v69Ev();
extern void _ZN6S200C53v70Ev();
extern void _ZN6S200C53v71Ev();
extern void _ZN6S200C53v72Ev();
extern void _ZN6S200C53v73Ev();
extern void _ZN6S200C53v74Ev();
extern void _ZN6S200C53v75Ev();
extern void _ZN6S200C53v76Ev();
extern void _ZN6S200C53v77Ev();
extern void _ZN6S200C53v78Ev();
extern void _ZN6S200C53v79Ev();
extern void _ZN6S200C53v80Ev();
extern void _ZN6S200C53v81Ev();
extern void _ZN6S200C53v82Ev();
extern void _ZN6S200C53v83Ev();
extern void _ZN6S200C53v84Ev();
extern void _ZN6S200C53v85Ev();
extern void _ZN6S200C53v86Ev();
extern void _ZN6S200C53v87Ev();
extern void _ZN6S200C53v88Ev();
extern void _ZN6S200C53v89Ev();
static  VTBL_ENTRY vtc_S200C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S200C5[0]),
  (VTBL_ENTRY)&_ZN6S200C5D1Ev,
  (VTBL_ENTRY)&_ZN6S200C5D0Ev,
  (VTBL_ENTRY)&_ZN6S200C62v4Ev,
  (VTBL_ENTRY)&_ZN6S200C62v5Ev,
  (VTBL_ENTRY)&_ZN6S200C62v6Ev,
  (VTBL_ENTRY)&_ZN6S200C62v7Ev,
  (VTBL_ENTRY)&_ZN6S200C62v8Ev,
  (VTBL_ENTRY)&_ZN6S200C62v9Ev,
  (VTBL_ENTRY)&_ZN6S200C63v10Ev,
  (VTBL_ENTRY)&_ZN6S200C63v11Ev,
  (VTBL_ENTRY)&_ZN6S200C63v12Ev,
  (VTBL_ENTRY)&_ZN6S200C63v13Ev,
  (VTBL_ENTRY)&_ZN6S200C63v14Ev,
  (VTBL_ENTRY)&_ZN6S200C63v15Ev,
  (VTBL_ENTRY)&_ZN6S200C63v16Ev,
  (VTBL_ENTRY)&_ZN6S200C63v17Ev,
  (VTBL_ENTRY)&_ZN6S200C63v18Ev,
  (VTBL_ENTRY)&_ZN6S200C63v19Ev,
  (VTBL_ENTRY)&_ZN6S200C63v20Ev,
  (VTBL_ENTRY)&_ZN6S200C63v21Ev,
  (VTBL_ENTRY)&_ZN6S200C63v22Ev,
  (VTBL_ENTRY)&_ZN6S200C63v23Ev,
  (VTBL_ENTRY)&_ZN6S200C63v24Ev,
  (VTBL_ENTRY)&_ZN6S200C63v25Ev,
  (VTBL_ENTRY)&_ZN6S200C63v26Ev,
  (VTBL_ENTRY)&_ZN6S200C63v27Ev,
  (VTBL_ENTRY)&_ZN6S200C63v28Ev,
  (VTBL_ENTRY)&_ZN6S200C63v29Ev,
  (VTBL_ENTRY)&_ZN6S200C63v30Ev,
  (VTBL_ENTRY)&_ZN6S200C63v31Ev,
  (VTBL_ENTRY)&_ZN6S200C63v32Ev,
  (VTBL_ENTRY)&_ZN6S200C63v33Ev,
  (VTBL_ENTRY)&_ZN6S200C63v34Ev,
  (VTBL_ENTRY)&_ZN6S200C63v35Ev,
  (VTBL_ENTRY)&_ZN6S200C63v36Ev,
  (VTBL_ENTRY)&_ZN6S200C63v37Ev,
  (VTBL_ENTRY)&_ZN6S200C63v38Ev,
  (VTBL_ENTRY)&_ZN6S200C63v39Ev,
  (VTBL_ENTRY)&_ZN6S200C63v40Ev,
  (VTBL_ENTRY)&_ZN6S200C63v41Ev,
  (VTBL_ENTRY)&_ZN6S200C63v42Ev,
  (VTBL_ENTRY)&_ZN6S200C63v43Ev,
  (VTBL_ENTRY)&_ZN6S200C63v44Ev,
  (VTBL_ENTRY)&_ZN6S200C63v45Ev,
  (VTBL_ENTRY)&_ZN6S200C63v46Ev,
  (VTBL_ENTRY)&_ZN6S200C63v47Ev,
  (VTBL_ENTRY)&_ZN6S200C63v48Ev,
  (VTBL_ENTRY)&_ZN6S200C63v49Ev,
  (VTBL_ENTRY)&_ZN6S200C63v50Ev,
  (VTBL_ENTRY)&_ZN6S200C63v51Ev,
  (VTBL_ENTRY)&_ZN6S200C63v52Ev,
  (VTBL_ENTRY)&_ZN6S200C63v53Ev,
  (VTBL_ENTRY)&_ZN6S200C63v54Ev,
  (VTBL_ENTRY)&_ZN6S200C63v55Ev,
  (VTBL_ENTRY)&_ZN6S200C63v56Ev,
  (VTBL_ENTRY)&_ZN6S200C63v57Ev,
  (VTBL_ENTRY)&_ZN6S200C63v58Ev,
  (VTBL_ENTRY)&_ZN6S200C63v59Ev,
  (VTBL_ENTRY)&_ZN6S200C63v60Ev,
  (VTBL_ENTRY)&_ZN6S200C63v61Ev,
  (VTBL_ENTRY)&_ZN6S200C63v62Ev,
  (VTBL_ENTRY)&_ZN6S200C63v63Ev,
  (VTBL_ENTRY)&_ZN6S200C63v64Ev,
  (VTBL_ENTRY)&_ZN6S200C63v65Ev,
  (VTBL_ENTRY)&_ZN6S200C63v66Ev,
  (VTBL_ENTRY)&_ZN6S200C63v67Ev,
  (VTBL_ENTRY)&_ZN6S200C53v68Ev,
  (VTBL_ENTRY)&_ZN6S200C53v69Ev,
  (VTBL_ENTRY)&_ZN6S200C53v70Ev,
  (VTBL_ENTRY)&_ZN6S200C53v71Ev,
  (VTBL_ENTRY)&_ZN6S200C53v72Ev,
  (VTBL_ENTRY)&_ZN6S200C53v73Ev,
  (VTBL_ENTRY)&_ZN6S200C53v74Ev,
  (VTBL_ENTRY)&_ZN6S200C53v75Ev,
  (VTBL_ENTRY)&_ZN6S200C53v76Ev,
  (VTBL_ENTRY)&_ZN6S200C53v77Ev,
  (VTBL_ENTRY)&_ZN6S200C53v78Ev,
  (VTBL_ENTRY)&_ZN6S200C53v79Ev,
  (VTBL_ENTRY)&_ZN6S200C53v80Ev,
  (VTBL_ENTRY)&_ZN6S200C53v81Ev,
  (VTBL_ENTRY)&_ZN6S200C53v82Ev,
  (VTBL_ENTRY)&_ZN6S200C53v83Ev,
  (VTBL_ENTRY)&_ZN6S200C53v84Ev,
  (VTBL_ENTRY)&_ZN6S200C53v85Ev,
  (VTBL_ENTRY)&_ZN6S200C53v86Ev,
  (VTBL_ENTRY)&_ZN6S200C53v87Ev,
  (VTBL_ENTRY)&_ZN6S200C53v88Ev,
  (VTBL_ENTRY)&_ZN6S200C53v89Ev,
};
extern VTBL_ENTRY _ZTI6S200C5[];
extern  VTBL_ENTRY _ZTV6S200C5[];
Class_Descriptor cd_S200C5 = {  "S200C5", // class name
  bases_S200C5, 1,
  &(vtc_S200C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI6S200C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S200C5),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S200C4  : S200C5 {
  unsigned int s200c4f0:1;
  unsigned int s200c4f1:1;
  unsigned int s200c4f2:1;
  ::S3443C17 s200c4f3;
  ::S3443C11 s200c4f4;
  ::S3443C5_nt s200c4f5;
  ::S244C19 s200c4f6;
  int s200c4f7[3];
  virtual  ~S200C4(); // _ZN6S200C4D1Ev
  virtual void  v90(); // _ZN6S200C43v90Ev
  virtual void  v91(); // _ZN6S200C43v91Ev
  virtual void  v92(); // _ZN6S200C43v92Ev
  virtual void  v93(); // _ZN6S200C43v93Ev
  virtual void  v94(); // _ZN6S200C43v94Ev
  virtual void  v95(); // _ZN6S200C43v95Ev
  virtual void  v96(); // _ZN6S200C43v96Ev
  virtual void  v97(); // _ZN6S200C43v97Ev
  virtual void  v98(); // _ZN6S200C43v98Ev
  virtual void  v99(); // _ZN6S200C43v99Ev
  virtual void  v100(); // _ZN6S200C44v100Ev
  virtual void  v101(); // _ZN6S200C44v101Ev
  virtual void  v102(); // _ZN6S200C44v102Ev
  virtual void  v103(); // _ZN6S200C44v103Ev
  virtual void  v104(); // _ZN6S200C44v104Ev
  virtual void  v105(); // _ZN6S200C44v105Ev
  virtual void  v106(); // _ZN6S200C44v106Ev
  virtual void  v107(); // _ZN6S200C44v107Ev
  virtual void  v108(); // _ZN6S200C44v108Ev
  virtual void  v109(); // _ZN6S200C44v109Ev
  S200C4(); // tgen
};
//SIG(-1 S200C4) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} FC16{ BC17{ BC8}} Fi[3]}


 S200C4 ::~S200C4(){ note_dtor("S200C4", this);}
void  S200C4 ::v90(){vfunc_called(this, "_ZN6S200C43v90Ev");}
void  S200C4 ::v91(){vfunc_called(this, "_ZN6S200C43v91Ev");}
void  S200C4 ::v92(){vfunc_called(this, "_ZN6S200C43v92Ev");}
void  S200C4 ::v93(){vfunc_called(this, "_ZN6S200C43v93Ev");}
void  S200C4 ::v94(){vfunc_called(this, "_ZN6S200C43v94Ev");}
void  S200C4 ::v95(){vfunc_called(this, "_ZN6S200C43v95Ev");}
void  S200C4 ::v96(){vfunc_called(this, "_ZN6S200C43v96Ev");}
void  S200C4 ::v97(){vfunc_called(this, "_ZN6S200C43v97Ev");}
void  S200C4 ::v98(){vfunc_called(this, "_ZN6S200C43v98Ev");}
void  S200C4 ::v99(){vfunc_called(this, "_ZN6S200C43v99Ev");}
void  S200C4 ::v100(){vfunc_called(this, "_ZN6S200C44v100Ev");}
void  S200C4 ::v101(){vfunc_called(this, "_ZN6S200C44v101Ev");}
void  S200C4 ::v102(){vfunc_called(this, "_ZN6S200C44v102Ev");}
void  S200C4 ::v103(){vfunc_called(this, "_ZN6S200C44v103Ev");}
void  S200C4 ::v104(){vfunc_called(this, "_ZN6S200C44v104Ev");}
void  S200C4 ::v105(){vfunc_called(this, "_ZN6S200C44v105Ev");}
void  S200C4 ::v106(){vfunc_called(this, "_ZN6S200C44v106Ev");}
void  S200C4 ::v107(){vfunc_called(this, "_ZN6S200C44v107Ev");}
void  S200C4 ::v108(){vfunc_called(this, "_ZN6S200C44v108Ev");}
void  S200C4 ::v109(){vfunc_called(this, "_ZN6S200C44v109Ev");}
S200C4 ::S200C4(){ note_ctor("S200C4", this);} // tgen

static void Test_S200C4()
{
  extern Class_Descriptor cd_S200C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(35,50)];
    init_test(&cd_S200C4, buf);
    S200C4 *dp, &lv = *(dp=new (buf) S200C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,196), "sizeof(S200C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S200C4)");
    check_base_class_offset(lv, (S200C6*)(S200C5*), 0, "S200C4");
    check_base_class_offset(lv, (S200C5*), 0, "S200C4");
    set_bf_and_test(lv, s200c4f0, ABISELECT(188,132), 0, 1, 1, "S200C4");
    set_bf_and_test(lv, s200c4f1, ABISELECT(188,132), 1, 1, 1, "S200C4");
    set_bf_and_test(lv, s200c4f2, ABISELECT(188,132), 2, 1, 1, "S200C4");
    check_field_offset(lv, s200c4f3, ABISELECT(192,136), "S200C4.s200c4f3");
    check_field_offset(lv, s200c4f4, ABISELECT(208,148), "S200C4.s200c4f4");
    check_field_offset(lv, s200c4f5, ABISELECT(224,160), "S200C4.s200c4f5");
    check_field_offset(lv, s200c4f6, ABISELECT(240,172), "S200C4.s200c4f6");
    check_field_offset(lv, s200c4f7, ABISELECT(256,184), "S200C4.s200c4f7");
    test_class_info(&lv, &cd_S200C4);
    dp->~S200C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS200C4(Test_S200C4, "S200C4", ABISELECT(272,196));

#else // __cplusplus

extern void _ZN6S200C4C1Ev();
extern void _ZN6S200C4D1Ev();
Name_Map name_map_S200C4[] = {
  NSPAIR(_ZN6S200C4C1Ev),
  NSPAIR(_ZN6S200C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S200C6;
extern VTBL_ENTRY _ZTI6S200C6[];
extern  VTBL_ENTRY _ZTV6S200C6[];
extern Class_Descriptor cd_S200C5;
extern VTBL_ENTRY _ZTI6S200C5[];
extern  VTBL_ENTRY _ZTV6S200C5[];
static Base_Class bases_S200C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S200C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S200C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S200C4[];
extern void _ZN6S200C4D1Ev();
extern void _ZN6S200C4D0Ev();
extern void _ZN6S200C62v4Ev();
extern void _ZN6S200C62v5Ev();
extern void _ZN6S200C62v6Ev();
extern void _ZN6S200C62v7Ev();
extern void _ZN6S200C62v8Ev();
extern void _ZN6S200C62v9Ev();
extern void _ZN6S200C63v10Ev();
extern void _ZN6S200C63v11Ev();
extern void _ZN6S200C63v12Ev();
extern void _ZN6S200C63v13Ev();
extern void _ZN6S200C63v14Ev();
extern void _ZN6S200C63v15Ev();
extern void _ZN6S200C63v16Ev();
extern void _ZN6S200C63v17Ev();
extern void _ZN6S200C63v18Ev();
extern void _ZN6S200C63v19Ev();
extern void _ZN6S200C63v20Ev();
extern void _ZN6S200C63v21Ev();
extern void _ZN6S200C63v22Ev();
extern void _ZN6S200C63v23Ev();
extern void _ZN6S200C63v24Ev();
extern void _ZN6S200C63v25Ev();
extern void _ZN6S200C63v26Ev();
extern void _ZN6S200C63v27Ev();
extern void _ZN6S200C63v28Ev();
extern void _ZN6S200C63v29Ev();
extern void _ZN6S200C63v30Ev();
extern void _ZN6S200C63v31Ev();
extern void _ZN6S200C63v32Ev();
extern void _ZN6S200C63v33Ev();
extern void _ZN6S200C63v34Ev();
extern void _ZN6S200C63v35Ev();
extern void _ZN6S200C63v36Ev();
extern void _ZN6S200C63v37Ev();
extern void _ZN6S200C63v38Ev();
extern void _ZN6S200C63v39Ev();
extern void _ZN6S200C63v40Ev();
extern void _ZN6S200C63v41Ev();
extern void _ZN6S200C63v42Ev();
extern void _ZN6S200C63v43Ev();
extern void _ZN6S200C63v44Ev();
extern void _ZN6S200C63v45Ev();
extern void _ZN6S200C63v46Ev();
extern void _ZN6S200C63v47Ev();
extern void _ZN6S200C63v48Ev();
extern void _ZN6S200C63v49Ev();
extern void _ZN6S200C63v50Ev();
extern void _ZN6S200C63v51Ev();
extern void _ZN6S200C63v52Ev();
extern void _ZN6S200C63v53Ev();
extern void _ZN6S200C63v54Ev();
extern void _ZN6S200C63v55Ev();
extern void _ZN6S200C63v56Ev();
extern void _ZN6S200C63v57Ev();
extern void _ZN6S200C63v58Ev();
extern void _ZN6S200C63v59Ev();
extern void _ZN6S200C63v60Ev();
extern void _ZN6S200C63v61Ev();
extern void _ZN6S200C63v62Ev();
extern void _ZN6S200C63v63Ev();
extern void _ZN6S200C63v64Ev();
extern void _ZN6S200C63v65Ev();
extern void _ZN6S200C63v66Ev();
extern void _ZN6S200C63v67Ev();
extern void _ZN6S200C53v68Ev();
extern void _ZN6S200C53v69Ev();
extern void _ZN6S200C53v70Ev();
extern void _ZN6S200C53v71Ev();
extern void _ZN6S200C53v72Ev();
extern void _ZN6S200C53v73Ev();
extern void _ZN6S200C53v74Ev();
extern void _ZN6S200C53v75Ev();
extern void _ZN6S200C53v76Ev();
extern void _ZN6S200C53v77Ev();
extern void _ZN6S200C53v78Ev();
extern void _ZN6S200C53v79Ev();
extern void _ZN6S200C53v80Ev();
extern void _ZN6S200C53v81Ev();
extern void _ZN6S200C53v82Ev();
extern void _ZN6S200C53v83Ev();
extern void _ZN6S200C53v84Ev();
extern void _ZN6S200C53v85Ev();
extern void _ZN6S200C53v86Ev();
extern void _ZN6S200C53v87Ev();
extern void _ZN6S200C53v88Ev();
extern void _ZN6S200C53v89Ev();
extern void _ZN6S200C43v90Ev();
extern void _ZN6S200C43v91Ev();
extern void _ZN6S200C43v92Ev();
extern void _ZN6S200C43v93Ev();
extern void _ZN6S200C43v94Ev();
extern void _ZN6S200C43v95Ev();
extern void _ZN6S200C43v96Ev();
extern void _ZN6S200C43v97Ev();
extern void _ZN6S200C43v98Ev();
extern void _ZN6S200C43v99Ev();
extern void _ZN6S200C44v100Ev();
extern void _ZN6S200C44v101Ev();
extern void _ZN6S200C44v102Ev();
extern void _ZN6S200C44v103Ev();
extern void _ZN6S200C44v104Ev();
extern void _ZN6S200C44v105Ev();
extern void _ZN6S200C44v106Ev();
extern void _ZN6S200C44v107Ev();
extern void _ZN6S200C44v108Ev();
extern void _ZN6S200C44v109Ev();
static  VTBL_ENTRY vtc_S200C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S200C4[0]),
  (VTBL_ENTRY)&_ZN6S200C4D1Ev,
  (VTBL_ENTRY)&_ZN6S200C4D0Ev,
  (VTBL_ENTRY)&_ZN6S200C62v4Ev,
  (VTBL_ENTRY)&_ZN6S200C62v5Ev,
  (VTBL_ENTRY)&_ZN6S200C62v6Ev,
  (VTBL_ENTRY)&_ZN6S200C62v7Ev,
  (VTBL_ENTRY)&_ZN6S200C62v8Ev,
  (VTBL_ENTRY)&_ZN6S200C62v9Ev,
  (VTBL_ENTRY)&_ZN6S200C63v10Ev,
  (VTBL_ENTRY)&_ZN6S200C63v11Ev,
  (VTBL_ENTRY)&_ZN6S200C63v12Ev,
  (VTBL_ENTRY)&_ZN6S200C63v13Ev,
  (VTBL_ENTRY)&_ZN6S200C63v14Ev,
  (VTBL_ENTRY)&_ZN6S200C63v15Ev,
  (VTBL_ENTRY)&_ZN6S200C63v16Ev,
  (VTBL_ENTRY)&_ZN6S200C63v17Ev,
  (VTBL_ENTRY)&_ZN6S200C63v18Ev,
  (VTBL_ENTRY)&_ZN6S200C63v19Ev,
  (VTBL_ENTRY)&_ZN6S200C63v20Ev,
  (VTBL_ENTRY)&_ZN6S200C63v21Ev,
  (VTBL_ENTRY)&_ZN6S200C63v22Ev,
  (VTBL_ENTRY)&_ZN6S200C63v23Ev,
  (VTBL_ENTRY)&_ZN6S200C63v24Ev,
  (VTBL_ENTRY)&_ZN6S200C63v25Ev,
  (VTBL_ENTRY)&_ZN6S200C63v26Ev,
  (VTBL_ENTRY)&_ZN6S200C63v27Ev,
  (VTBL_ENTRY)&_ZN6S200C63v28Ev,
  (VTBL_ENTRY)&_ZN6S200C63v29Ev,
  (VTBL_ENTRY)&_ZN6S200C63v30Ev,
  (VTBL_ENTRY)&_ZN6S200C63v31Ev,
  (VTBL_ENTRY)&_ZN6S200C63v32Ev,
  (VTBL_ENTRY)&_ZN6S200C63v33Ev,
  (VTBL_ENTRY)&_ZN6S200C63v34Ev,
  (VTBL_ENTRY)&_ZN6S200C63v35Ev,
  (VTBL_ENTRY)&_ZN6S200C63v36Ev,
  (VTBL_ENTRY)&_ZN6S200C63v37Ev,
  (VTBL_ENTRY)&_ZN6S200C63v38Ev,
  (VTBL_ENTRY)&_ZN6S200C63v39Ev,
  (VTBL_ENTRY)&_ZN6S200C63v40Ev,
  (VTBL_ENTRY)&_ZN6S200C63v41Ev,
  (VTBL_ENTRY)&_ZN6S200C63v42Ev,
  (VTBL_ENTRY)&_ZN6S200C63v43Ev,
  (VTBL_ENTRY)&_ZN6S200C63v44Ev,
  (VTBL_ENTRY)&_ZN6S200C63v45Ev,
  (VTBL_ENTRY)&_ZN6S200C63v46Ev,
  (VTBL_ENTRY)&_ZN6S200C63v47Ev,
  (VTBL_ENTRY)&_ZN6S200C63v48Ev,
  (VTBL_ENTRY)&_ZN6S200C63v49Ev,
  (VTBL_ENTRY)&_ZN6S200C63v50Ev,
  (VTBL_ENTRY)&_ZN6S200C63v51Ev,
  (VTBL_ENTRY)&_ZN6S200C63v52Ev,
  (VTBL_ENTRY)&_ZN6S200C63v53Ev,
  (VTBL_ENTRY)&_ZN6S200C63v54Ev,
  (VTBL_ENTRY)&_ZN6S200C63v55Ev,
  (VTBL_ENTRY)&_ZN6S200C63v56Ev,
  (VTBL_ENTRY)&_ZN6S200C63v57Ev,
  (VTBL_ENTRY)&_ZN6S200C63v58Ev,
  (VTBL_ENTRY)&_ZN6S200C63v59Ev,
  (VTBL_ENTRY)&_ZN6S200C63v60Ev,
  (VTBL_ENTRY)&_ZN6S200C63v61Ev,
  (VTBL_ENTRY)&_ZN6S200C63v62Ev,
  (VTBL_ENTRY)&_ZN6S200C63v63Ev,
  (VTBL_ENTRY)&_ZN6S200C63v64Ev,
  (VTBL_ENTRY)&_ZN6S200C63v65Ev,
  (VTBL_ENTRY)&_ZN6S200C63v66Ev,
  (VTBL_ENTRY)&_ZN6S200C63v67Ev,
  (VTBL_ENTRY)&_ZN6S200C53v68Ev,
  (VTBL_ENTRY)&_ZN6S200C53v69Ev,
  (VTBL_ENTRY)&_ZN6S200C53v70Ev,
  (VTBL_ENTRY)&_ZN6S200C53v71Ev,
  (VTBL_ENTRY)&_ZN6S200C53v72Ev,
  (VTBL_ENTRY)&_ZN6S200C53v73Ev,
  (VTBL_ENTRY)&_ZN6S200C53v74Ev,
  (VTBL_ENTRY)&_ZN6S200C53v75Ev,
  (VTBL_ENTRY)&_ZN6S200C53v76Ev,
  (VTBL_ENTRY)&_ZN6S200C53v77Ev,
  (VTBL_ENTRY)&_ZN6S200C53v78Ev,
  (VTBL_ENTRY)&_ZN6S200C53v79Ev,
  (VTBL_ENTRY)&_ZN6S200C53v80Ev,
  (VTBL_ENTRY)&_ZN6S200C53v81Ev,
  (VTBL_ENTRY)&_ZN6S200C53v82Ev,
  (VTBL_ENTRY)&_ZN6S200C53v83Ev,
  (VTBL_ENTRY)&_ZN6S200C53v84Ev,
  (VTBL_ENTRY)&_ZN6S200C53v85Ev,
  (VTBL_ENTRY)&_ZN6S200C53v86Ev,
  (VTBL_ENTRY)&_ZN6S200C53v87Ev,
  (VTBL_ENTRY)&_ZN6S200C53v88Ev,
  (VTBL_ENTRY)&_ZN6S200C53v89Ev,
  (VTBL_ENTRY)&_ZN6S200C43v90Ev,
  (VTBL_ENTRY)&_ZN6S200C43v91Ev,
  (VTBL_ENTRY)&_ZN6S200C43v92Ev,
  (VTBL_ENTRY)&_ZN6S200C43v93Ev,
  (VTBL_ENTRY)&_ZN6S200C43v94Ev,
  (VTBL_ENTRY)&_ZN6S200C43v95Ev,
  (VTBL_ENTRY)&_ZN6S200C43v96Ev,
  (VTBL_ENTRY)&_ZN6S200C43v97Ev,
  (VTBL_ENTRY)&_ZN6S200C43v98Ev,
  (VTBL_ENTRY)&_ZN6S200C43v99Ev,
  (VTBL_ENTRY)&_ZN6S200C44v100Ev,
  (VTBL_ENTRY)&_ZN6S200C44v101Ev,
  (VTBL_ENTRY)&_ZN6S200C44v102Ev,
  (VTBL_ENTRY)&_ZN6S200C44v103Ev,
  (VTBL_ENTRY)&_ZN6S200C44v104Ev,
  (VTBL_ENTRY)&_ZN6S200C44v105Ev,
  (VTBL_ENTRY)&_ZN6S200C44v106Ev,
  (VTBL_ENTRY)&_ZN6S200C44v107Ev,
  (VTBL_ENTRY)&_ZN6S200C44v108Ev,
  (VTBL_ENTRY)&_ZN6S200C44v109Ev,
};
extern VTBL_ENTRY _ZTI6S200C4[];
extern  VTBL_ENTRY _ZTV6S200C4[];
Class_Descriptor cd_S200C4 = {  "S200C4", // class name
  bases_S200C4, 2,
  &(vtc_S200C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI6S200C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S200C4),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S200C3  : S200C4 {
  ::S3443C4_nt s200c3f0;
  unsigned int s200c3f1:1;
  ::S244C9 s200c3f2;
  virtual  ~S200C3(); // _ZN6S200C3D1Ev
  virtual void  v110(); // _ZN6S200C34v110Ev
  virtual void  v111(); // _ZN6S200C34v111Ev
  virtual void  v112(); // _ZN6S200C34v112Ev
  virtual void  v113(); // _ZN6S200C34v113Ev
  S200C3(); // tgen
};
//SIG(-1 S200C3) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} FC17{ BC18{ BC9}} Fi[3]} vd v1 v2 v3 v4 FC5 Fi:1 FC7}


 S200C3 ::~S200C3(){ note_dtor("S200C3", this);}
void  S200C3 ::v110(){vfunc_called(this, "_ZN6S200C34v110Ev");}
void  S200C3 ::v111(){vfunc_called(this, "_ZN6S200C34v111Ev");}
void  S200C3 ::v112(){vfunc_called(this, "_ZN6S200C34v112Ev");}
void  S200C3 ::v113(){vfunc_called(this, "_ZN6S200C34v113Ev");}
S200C3 ::S200C3(){ note_ctor("S200C3", this);} // tgen

static void Test_S200C3()
{
  extern Class_Descriptor cd_S200C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(38,56)];
    init_test(&cd_S200C3, buf);
    S200C3 *dp, &lv = *(dp=new (buf) S200C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(296,220), "sizeof(S200C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S200C3)");
    check_base_class_offset(lv, (S200C6*)(S200C5*)(S200C4*), 0, "S200C3");
    check_base_class_offset(lv, (S200C5*)(S200C4*), 0, "S200C3");
    check_base_class_offset(lv, (S200C4*), 0, "S200C3");
    check_field_offset(lv, s200c3f0, ABISELECT(268,196), "S200C3.s200c3f0");
    set_bf_and_test(lv, s200c3f1, ABISELECT(276,204), 0, 1, 1, "S200C3");
    check_field_offset(lv, s200c3f2, ABISELECT(280,208), "S200C3.s200c3f2");
    test_class_info(&lv, &cd_S200C3);
    dp->~S200C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS200C3(Test_S200C3, "S200C3", ABISELECT(296,220));

#else // __cplusplus

extern void _ZN6S200C3C1Ev();
extern void _ZN6S200C3D1Ev();
Name_Map name_map_S200C3[] = {
  NSPAIR(_ZN6S200C3C1Ev),
  NSPAIR(_ZN6S200C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S200C6;
extern VTBL_ENTRY _ZTI6S200C6[];
extern  VTBL_ENTRY _ZTV6S200C6[];
extern Class_Descriptor cd_S200C5;
extern VTBL_ENTRY _ZTI6S200C5[];
extern  VTBL_ENTRY _ZTV6S200C5[];
extern Class_Descriptor cd_S200C4;
extern VTBL_ENTRY _ZTI6S200C4[];
extern  VTBL_ENTRY _ZTV6S200C4[];
static Base_Class bases_S200C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S200C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S200C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S200C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S200C3[];
extern void _ZN6S200C3D1Ev();
extern void _ZN6S200C3D0Ev();
extern void _ZN6S200C62v4Ev();
extern void _ZN6S200C62v5Ev();
extern void _ZN6S200C62v6Ev();
extern void _ZN6S200C62v7Ev();
extern void _ZN6S200C62v8Ev();
extern void _ZN6S200C62v9Ev();
extern void _ZN6S200C63v10Ev();
extern void _ZN6S200C63v11Ev();
extern void _ZN6S200C63v12Ev();
extern void _ZN6S200C63v13Ev();
extern void _ZN6S200C63v14Ev();
extern void _ZN6S200C63v15Ev();
extern void _ZN6S200C63v16Ev();
extern void _ZN6S200C63v17Ev();
extern void _ZN6S200C63v18Ev();
extern void _ZN6S200C63v19Ev();
extern void _ZN6S200C63v20Ev();
extern void _ZN6S200C63v21Ev();
extern void _ZN6S200C63v22Ev();
extern void _ZN6S200C63v23Ev();
extern void _ZN6S200C63v24Ev();
extern void _ZN6S200C63v25Ev();
extern void _ZN6S200C63v26Ev();
extern void _ZN6S200C63v27Ev();
extern void _ZN6S200C63v28Ev();
extern void _ZN6S200C63v29Ev();
extern void _ZN6S200C63v30Ev();
extern void _ZN6S200C63v31Ev();
extern void _ZN6S200C63v32Ev();
extern void _ZN6S200C63v33Ev();
extern void _ZN6S200C63v34Ev();
extern void _ZN6S200C63v35Ev();
extern void _ZN6S200C63v36Ev();
extern void _ZN6S200C63v37Ev();
extern void _ZN6S200C63v38Ev();
extern void _ZN6S200C63v39Ev();
extern void _ZN6S200C63v40Ev();
extern void _ZN6S200C63v41Ev();
extern void _ZN6S200C63v42Ev();
extern void _ZN6S200C63v43Ev();
extern void _ZN6S200C63v44Ev();
extern void _ZN6S200C63v45Ev();
extern void _ZN6S200C63v46Ev();
extern void _ZN6S200C63v47Ev();
extern void _ZN6S200C63v48Ev();
extern void _ZN6S200C63v49Ev();
extern void _ZN6S200C63v50Ev();
extern void _ZN6S200C63v51Ev();
extern void _ZN6S200C63v52Ev();
extern void _ZN6S200C63v53Ev();
extern void _ZN6S200C63v54Ev();
extern void _ZN6S200C63v55Ev();
extern void _ZN6S200C63v56Ev();
extern void _ZN6S200C63v57Ev();
extern void _ZN6S200C63v58Ev();
extern void _ZN6S200C63v59Ev();
extern void _ZN6S200C63v60Ev();
extern void _ZN6S200C63v61Ev();
extern void _ZN6S200C63v62Ev();
extern void _ZN6S200C63v63Ev();
extern void _ZN6S200C63v64Ev();
extern void _ZN6S200C63v65Ev();
extern void _ZN6S200C63v66Ev();
extern void _ZN6S200C63v67Ev();
extern void _ZN6S200C53v68Ev();
extern void _ZN6S200C53v69Ev();
extern void _ZN6S200C53v70Ev();
extern void _ZN6S200C53v71Ev();
extern void _ZN6S200C53v72Ev();
extern void _ZN6S200C53v73Ev();
extern void _ZN6S200C53v74Ev();
extern void _ZN6S200C53v75Ev();
extern void _ZN6S200C53v76Ev();
extern void _ZN6S200C53v77Ev();
extern void _ZN6S200C53v78Ev();
extern void _ZN6S200C53v79Ev();
extern void _ZN6S200C53v80Ev();
extern void _ZN6S200C53v81Ev();
extern void _ZN6S200C53v82Ev();
extern void _ZN6S200C53v83Ev();
extern void _ZN6S200C53v84Ev();
extern void _ZN6S200C53v85Ev();
extern void _ZN6S200C53v86Ev();
extern void _ZN6S200C53v87Ev();
extern void _ZN6S200C53v88Ev();
extern void _ZN6S200C53v89Ev();
extern void _ZN6S200C43v90Ev();
extern void _ZN6S200C43v91Ev();
extern void _ZN6S200C43v92Ev();
extern void _ZN6S200C43v93Ev();
extern void _ZN6S200C43v94Ev();
extern void _ZN6S200C43v95Ev();
extern void _ZN6S200C43v96Ev();
extern void _ZN6S200C43v97Ev();
extern void _ZN6S200C43v98Ev();
extern void _ZN6S200C43v99Ev();
extern void _ZN6S200C44v100Ev();
extern void _ZN6S200C44v101Ev();
extern void _ZN6S200C44v102Ev();
extern void _ZN6S200C44v103Ev();
extern void _ZN6S200C44v104Ev();
extern void _ZN6S200C44v105Ev();
extern void _ZN6S200C44v106Ev();
extern void _ZN6S200C44v107Ev();
extern void _ZN6S200C44v108Ev();
extern void _ZN6S200C44v109Ev();
extern void _ZN6S200C34v110Ev();
extern void _ZN6S200C34v111Ev();
extern void _ZN6S200C34v112Ev();
extern void _ZN6S200C34v113Ev();
static  VTBL_ENTRY vtc_S200C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S200C3[0]),
  (VTBL_ENTRY)&_ZN6S200C3D1Ev,
  (VTBL_ENTRY)&_ZN6S200C3D0Ev,
  (VTBL_ENTRY)&_ZN6S200C62v4Ev,
  (VTBL_ENTRY)&_ZN6S200C62v5Ev,
  (VTBL_ENTRY)&_ZN6S200C62v6Ev,
  (VTBL_ENTRY)&_ZN6S200C62v7Ev,
  (VTBL_ENTRY)&_ZN6S200C62v8Ev,
  (VTBL_ENTRY)&_ZN6S200C62v9Ev,
  (VTBL_ENTRY)&_ZN6S200C63v10Ev,
  (VTBL_ENTRY)&_ZN6S200C63v11Ev,
  (VTBL_ENTRY)&_ZN6S200C63v12Ev,
  (VTBL_ENTRY)&_ZN6S200C63v13Ev,
  (VTBL_ENTRY)&_ZN6S200C63v14Ev,
  (VTBL_ENTRY)&_ZN6S200C63v15Ev,
  (VTBL_ENTRY)&_ZN6S200C63v16Ev,
  (VTBL_ENTRY)&_ZN6S200C63v17Ev,
  (VTBL_ENTRY)&_ZN6S200C63v18Ev,
  (VTBL_ENTRY)&_ZN6S200C63v19Ev,
  (VTBL_ENTRY)&_ZN6S200C63v20Ev,
  (VTBL_ENTRY)&_ZN6S200C63v21Ev,
  (VTBL_ENTRY)&_ZN6S200C63v22Ev,
  (VTBL_ENTRY)&_ZN6S200C63v23Ev,
  (VTBL_ENTRY)&_ZN6S200C63v24Ev,
  (VTBL_ENTRY)&_ZN6S200C63v25Ev,
  (VTBL_ENTRY)&_ZN6S200C63v26Ev,
  (VTBL_ENTRY)&_ZN6S200C63v27Ev,
  (VTBL_ENTRY)&_ZN6S200C63v28Ev,
  (VTBL_ENTRY)&_ZN6S200C63v29Ev,
  (VTBL_ENTRY)&_ZN6S200C63v30Ev,
  (VTBL_ENTRY)&_ZN6S200C63v31Ev,
  (VTBL_ENTRY)&_ZN6S200C63v32Ev,
  (VTBL_ENTRY)&_ZN6S200C63v33Ev,
  (VTBL_ENTRY)&_ZN6S200C63v34Ev,
  (VTBL_ENTRY)&_ZN6S200C63v35Ev,
  (VTBL_ENTRY)&_ZN6S200C63v36Ev,
  (VTBL_ENTRY)&_ZN6S200C63v37Ev,
  (VTBL_ENTRY)&_ZN6S200C63v38Ev,
  (VTBL_ENTRY)&_ZN6S200C63v39Ev,
  (VTBL_ENTRY)&_ZN6S200C63v40Ev,
  (VTBL_ENTRY)&_ZN6S200C63v41Ev,
  (VTBL_ENTRY)&_ZN6S200C63v42Ev,
  (VTBL_ENTRY)&_ZN6S200C63v43Ev,
  (VTBL_ENTRY)&_ZN6S200C63v44Ev,
  (VTBL_ENTRY)&_ZN6S200C63v45Ev,
  (VTBL_ENTRY)&_ZN6S200C63v46Ev,
  (VTBL_ENTRY)&_ZN6S200C63v47Ev,
  (VTBL_ENTRY)&_ZN6S200C63v48Ev,
  (VTBL_ENTRY)&_ZN6S200C63v49Ev,
  (VTBL_ENTRY)&_ZN6S200C63v50Ev,
  (VTBL_ENTRY)&_ZN6S200C63v51Ev,
  (VTBL_ENTRY)&_ZN6S200C63v52Ev,
  (VTBL_ENTRY)&_ZN6S200C63v53Ev,
  (VTBL_ENTRY)&_ZN6S200C63v54Ev,
  (VTBL_ENTRY)&_ZN6S200C63v55Ev,
  (VTBL_ENTRY)&_ZN6S200C63v56Ev,
  (VTBL_ENTRY)&_ZN6S200C63v57Ev,
  (VTBL_ENTRY)&_ZN6S200C63v58Ev,
  (VTBL_ENTRY)&_ZN6S200C63v59Ev,
  (VTBL_ENTRY)&_ZN6S200C63v60Ev,
  (VTBL_ENTRY)&_ZN6S200C63v61Ev,
  (VTBL_ENTRY)&_ZN6S200C63v62Ev,
  (VTBL_ENTRY)&_ZN6S200C63v63Ev,
  (VTBL_ENTRY)&_ZN6S200C63v64Ev,
  (VTBL_ENTRY)&_ZN6S200C63v65Ev,
  (VTBL_ENTRY)&_ZN6S200C63v66Ev,
  (VTBL_ENTRY)&_ZN6S200C63v67Ev,
  (VTBL_ENTRY)&_ZN6S200C53v68Ev,
  (VTBL_ENTRY)&_ZN6S200C53v69Ev,
  (VTBL_ENTRY)&_ZN6S200C53v70Ev,
  (VTBL_ENTRY)&_ZN6S200C53v71Ev,
  (VTBL_ENTRY)&_ZN6S200C53v72Ev,
  (VTBL_ENTRY)&_ZN6S200C53v73Ev,
  (VTBL_ENTRY)&_ZN6S200C53v74Ev,
  (VTBL_ENTRY)&_ZN6S200C53v75Ev,
  (VTBL_ENTRY)&_ZN6S200C53v76Ev,
  (VTBL_ENTRY)&_ZN6S200C53v77Ev,
  (VTBL_ENTRY)&_ZN6S200C53v78Ev,
  (VTBL_ENTRY)&_ZN6S200C53v79Ev,
  (VTBL_ENTRY)&_ZN6S200C53v80Ev,
  (VTBL_ENTRY)&_ZN6S200C53v81Ev,
  (VTBL_ENTRY)&_ZN6S200C53v82Ev,
  (VTBL_ENTRY)&_ZN6S200C53v83Ev,
  (VTBL_ENTRY)&_ZN6S200C53v84Ev,
  (VTBL_ENTRY)&_ZN6S200C53v85Ev,
  (VTBL_ENTRY)&_ZN6S200C53v86Ev,
  (VTBL_ENTRY)&_ZN6S200C53v87Ev,
  (VTBL_ENTRY)&_ZN6S200C53v88Ev,
  (VTBL_ENTRY)&_ZN6S200C53v89Ev,
  (VTBL_ENTRY)&_ZN6S200C43v90Ev,
  (VTBL_ENTRY)&_ZN6S200C43v91Ev,
  (VTBL_ENTRY)&_ZN6S200C43v92Ev,
  (VTBL_ENTRY)&_ZN6S200C43v93Ev,
  (VTBL_ENTRY)&_ZN6S200C43v94Ev,
  (VTBL_ENTRY)&_ZN6S200C43v95Ev,
  (VTBL_ENTRY)&_ZN6S200C43v96Ev,
  (VTBL_ENTRY)&_ZN6S200C43v97Ev,
  (VTBL_ENTRY)&_ZN6S200C43v98Ev,
  (VTBL_ENTRY)&_ZN6S200C43v99Ev,
  (VTBL_ENTRY)&_ZN6S200C44v100Ev,
  (VTBL_ENTRY)&_ZN6S200C44v101Ev,
  (VTBL_ENTRY)&_ZN6S200C44v102Ev,
  (VTBL_ENTRY)&_ZN6S200C44v103Ev,
  (VTBL_ENTRY)&_ZN6S200C44v104Ev,
  (VTBL_ENTRY)&_ZN6S200C44v105Ev,
  (VTBL_ENTRY)&_ZN6S200C44v106Ev,
  (VTBL_ENTRY)&_ZN6S200C44v107Ev,
  (VTBL_ENTRY)&_ZN6S200C44v108Ev,
  (VTBL_ENTRY)&_ZN6S200C44v109Ev,
  (VTBL_ENTRY)&_ZN6S200C34v110Ev,
  (VTBL_ENTRY)&_ZN6S200C34v111Ev,
  (VTBL_ENTRY)&_ZN6S200C34v112Ev,
  (VTBL_ENTRY)&_ZN6S200C34v113Ev,
};
extern VTBL_ENTRY _ZTI6S200C3[];
extern  VTBL_ENTRY _ZTV6S200C3[];
Class_Descriptor cd_S200C3 = {  "S200C3", // class name
  bases_S200C3, 3,
  &(vtc_S200C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,220), // object size
  NSPAIRA(_ZTI6S200C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S200C3),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S200C2  : S200C3 {
  int s200c2f0;
  unsigned int s200c2f1:1;
  virtual  ~S200C2(); // _ZN6S200C2D1Ev
  virtual void  v114(); // _ZN6S200C24v114Ev
  virtual void  v115(); // _ZN6S200C24v115Ev
  virtual void  v116(); // _ZN6S200C24v116Ev
  virtual void  v117(); // _ZN6S200C24v117Ev
  virtual void  v118(); // _ZN6S200C24v118Ev
  virtual void  v119(); // _ZN6S200C24v119Ev
  virtual void  v120(); // _ZN6S200C24v120Ev
  virtual void  v121(); // _ZN6S200C24v121Ev
  S200C2(); // tgen
};
//SIG(-1 S200C2) C1{ BC2{ BC3{ BC4{ BC5{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} FC18{ BC19{ BC10}} Fi[3]} vd v115 v116 v117 v118 FC6 Fi:1 FC8} vd v1 v2 v3 v4 v5 v6 v7 v8 Fi Fi:1}


 S200C2 ::~S200C2(){ note_dtor("S200C2", this);}
void  S200C2 ::v114(){vfunc_called(this, "_ZN6S200C24v114Ev");}
void  S200C2 ::v115(){vfunc_called(this, "_ZN6S200C24v115Ev");}
void  S200C2 ::v116(){vfunc_called(this, "_ZN6S200C24v116Ev");}
void  S200C2 ::v117(){vfunc_called(this, "_ZN6S200C24v117Ev");}
void  S200C2 ::v118(){vfunc_called(this, "_ZN6S200C24v118Ev");}
void  S200C2 ::v119(){vfunc_called(this, "_ZN6S200C24v119Ev");}
void  S200C2 ::v120(){vfunc_called(this, "_ZN6S200C24v120Ev");}
void  S200C2 ::v121(){vfunc_called(this, "_ZN6S200C24v121Ev");}
S200C2 ::S200C2(){ note_ctor("S200C2", this);} // tgen

static void Test_S200C2()
{
  extern Class_Descriptor cd_S200C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(39,58)];
    init_test(&cd_S200C2, buf);
    S200C2 *dp, &lv = *(dp=new (buf) S200C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,228), "sizeof(S200C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S200C2)");
    check_base_class_offset(lv, (S200C6*)(S200C5*)(S200C4*)(S200C3*), 0, "S200C2");
    check_base_class_offset(lv, (S200C5*)(S200C4*)(S200C3*), 0, "S200C2");
    check_base_class_offset(lv, (S200C4*)(S200C3*), 0, "S200C2");
    check_base_class_offset(lv, (S200C3*), 0, "S200C2");
    check_field_offset(lv, s200c2f0, ABISELECT(296,220), "S200C2.s200c2f0");
    set_bf_and_test(lv, s200c2f1, ABISELECT(300,224), 0, 1, 1, "S200C2");
    test_class_info(&lv, &cd_S200C2);
    dp->~S200C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS200C2(Test_S200C2, "S200C2", ABISELECT(304,228));

#else // __cplusplus

extern void _ZN6S200C2C1Ev();
extern void _ZN6S200C2D1Ev();
Name_Map name_map_S200C2[] = {
  NSPAIR(_ZN6S200C2C1Ev),
  NSPAIR(_ZN6S200C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S200C6;
extern VTBL_ENTRY _ZTI6S200C6[];
extern  VTBL_ENTRY _ZTV6S200C6[];
extern Class_Descriptor cd_S200C5;
extern VTBL_ENTRY _ZTI6S200C5[];
extern  VTBL_ENTRY _ZTV6S200C5[];
extern Class_Descriptor cd_S200C4;
extern VTBL_ENTRY _ZTI6S200C4[];
extern  VTBL_ENTRY _ZTV6S200C4[];
extern Class_Descriptor cd_S200C3;
extern VTBL_ENTRY _ZTI6S200C3[];
extern  VTBL_ENTRY _ZTV6S200C3[];
static Base_Class bases_S200C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S200C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S200C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S200C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S200C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S200C2[];
extern void _ZN6S200C2D1Ev();
extern void _ZN6S200C2D0Ev();
extern void _ZN6S200C62v4Ev();
extern void _ZN6S200C62v5Ev();
extern void _ZN6S200C62v6Ev();
extern void _ZN6S200C62v7Ev();
extern void _ZN6S200C62v8Ev();
extern void _ZN6S200C62v9Ev();
extern void _ZN6S200C63v10Ev();
extern void _ZN6S200C63v11Ev();
extern void _ZN6S200C63v12Ev();
extern void _ZN6S200C63v13Ev();
extern void _ZN6S200C63v14Ev();
extern void _ZN6S200C63v15Ev();
extern void _ZN6S200C63v16Ev();
extern void _ZN6S200C63v17Ev();
extern void _ZN6S200C63v18Ev();
extern void _ZN6S200C63v19Ev();
extern void _ZN6S200C63v20Ev();
extern void _ZN6S200C63v21Ev();
extern void _ZN6S200C63v22Ev();
extern void _ZN6S200C63v23Ev();
extern void _ZN6S200C63v24Ev();
extern void _ZN6S200C63v25Ev();
extern void _ZN6S200C63v26Ev();
extern void _ZN6S200C63v27Ev();
extern void _ZN6S200C63v28Ev();
extern void _ZN6S200C63v29Ev();
extern void _ZN6S200C63v30Ev();
extern void _ZN6S200C63v31Ev();
extern void _ZN6S200C63v32Ev();
extern void _ZN6S200C63v33Ev();
extern void _ZN6S200C63v34Ev();
extern void _ZN6S200C63v35Ev();
extern void _ZN6S200C63v36Ev();
extern void _ZN6S200C63v37Ev();
extern void _ZN6S200C63v38Ev();
extern void _ZN6S200C63v39Ev();
extern void _ZN6S200C63v40Ev();
extern void _ZN6S200C63v41Ev();
extern void _ZN6S200C63v42Ev();
extern void _ZN6S200C63v43Ev();
extern void _ZN6S200C63v44Ev();
extern void _ZN6S200C63v45Ev();
extern void _ZN6S200C63v46Ev();
extern void _ZN6S200C63v47Ev();
extern void _ZN6S200C63v48Ev();
extern void _ZN6S200C63v49Ev();
extern void _ZN6S200C63v50Ev();
extern void _ZN6S200C63v51Ev();
extern void _ZN6S200C63v52Ev();
extern void _ZN6S200C63v53Ev();
extern void _ZN6S200C63v54Ev();
extern void _ZN6S200C63v55Ev();
extern void _ZN6S200C63v56Ev();
extern void _ZN6S200C63v57Ev();
extern void _ZN6S200C63v58Ev();
extern void _ZN6S200C63v59Ev();
extern void _ZN6S200C63v60Ev();
extern void _ZN6S200C63v61Ev();
extern void _ZN6S200C63v62Ev();
extern void _ZN6S200C63v63Ev();
extern void _ZN6S200C63v64Ev();
extern void _ZN6S200C63v65Ev();
extern void _ZN6S200C63v66Ev();
extern void _ZN6S200C63v67Ev();
extern void _ZN6S200C53v68Ev();
extern void _ZN6S200C53v69Ev();
extern void _ZN6S200C53v70Ev();
extern void _ZN6S200C53v71Ev();
extern void _ZN6S200C53v72Ev();
extern void _ZN6S200C53v73Ev();
extern void _ZN6S200C53v74Ev();
extern void _ZN6S200C53v75Ev();
extern void _ZN6S200C53v76Ev();
extern void _ZN6S200C53v77Ev();
extern void _ZN6S200C53v78Ev();
extern void _ZN6S200C53v79Ev();
extern void _ZN6S200C53v80Ev();
extern void _ZN6S200C53v81Ev();
extern void _ZN6S200C53v82Ev();
extern void _ZN6S200C53v83Ev();
extern void _ZN6S200C53v84Ev();
extern void _ZN6S200C53v85Ev();
extern void _ZN6S200C53v86Ev();
extern void _ZN6S200C53v87Ev();
extern void _ZN6S200C53v88Ev();
extern void _ZN6S200C53v89Ev();
extern void _ZN6S200C43v90Ev();
extern void _ZN6S200C43v91Ev();
extern void _ZN6S200C43v92Ev();
extern void _ZN6S200C43v93Ev();
extern void _ZN6S200C43v94Ev();
extern void _ZN6S200C43v95Ev();
extern void _ZN6S200C43v96Ev();
extern void _ZN6S200C43v97Ev();
extern void _ZN6S200C43v98Ev();
extern void _ZN6S200C43v99Ev();
extern void _ZN6S200C44v100Ev();
extern void _ZN6S200C44v101Ev();
extern void _ZN6S200C44v102Ev();
extern void _ZN6S200C44v103Ev();
extern void _ZN6S200C44v104Ev();
extern void _ZN6S200C44v105Ev();
extern void _ZN6S200C44v106Ev();
extern void _ZN6S200C44v107Ev();
extern void _ZN6S200C44v108Ev();
extern void _ZN6S200C44v109Ev();
extern void _ZN6S200C34v110Ev();
extern void _ZN6S200C34v111Ev();
extern void _ZN6S200C34v112Ev();
extern void _ZN6S200C34v113Ev();
extern void _ZN6S200C24v114Ev();
extern void _ZN6S200C24v115Ev();
extern void _ZN6S200C24v116Ev();
extern void _ZN6S200C24v117Ev();
extern void _ZN6S200C24v118Ev();
extern void _ZN6S200C24v119Ev();
extern void _ZN6S200C24v120Ev();
extern void _ZN6S200C24v121Ev();
static  VTBL_ENTRY vtc_S200C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S200C2[0]),
  (VTBL_ENTRY)&_ZN6S200C2D1Ev,
  (VTBL_ENTRY)&_ZN6S200C2D0Ev,
  (VTBL_ENTRY)&_ZN6S200C62v4Ev,
  (VTBL_ENTRY)&_ZN6S200C62v5Ev,
  (VTBL_ENTRY)&_ZN6S200C62v6Ev,
  (VTBL_ENTRY)&_ZN6S200C62v7Ev,
  (VTBL_ENTRY)&_ZN6S200C62v8Ev,
  (VTBL_ENTRY)&_ZN6S200C62v9Ev,
  (VTBL_ENTRY)&_ZN6S200C63v10Ev,
  (VTBL_ENTRY)&_ZN6S200C63v11Ev,
  (VTBL_ENTRY)&_ZN6S200C63v12Ev,
  (VTBL_ENTRY)&_ZN6S200C63v13Ev,
  (VTBL_ENTRY)&_ZN6S200C63v14Ev,
  (VTBL_ENTRY)&_ZN6S200C63v15Ev,
  (VTBL_ENTRY)&_ZN6S200C63v16Ev,
  (VTBL_ENTRY)&_ZN6S200C63v17Ev,
  (VTBL_ENTRY)&_ZN6S200C63v18Ev,
  (VTBL_ENTRY)&_ZN6S200C63v19Ev,
  (VTBL_ENTRY)&_ZN6S200C63v20Ev,
  (VTBL_ENTRY)&_ZN6S200C63v21Ev,
  (VTBL_ENTRY)&_ZN6S200C63v22Ev,
  (VTBL_ENTRY)&_ZN6S200C63v23Ev,
  (VTBL_ENTRY)&_ZN6S200C63v24Ev,
  (VTBL_ENTRY)&_ZN6S200C63v25Ev,
  (VTBL_ENTRY)&_ZN6S200C63v26Ev,
  (VTBL_ENTRY)&_ZN6S200C63v27Ev,
  (VTBL_ENTRY)&_ZN6S200C63v28Ev,
  (VTBL_ENTRY)&_ZN6S200C63v29Ev,
  (VTBL_ENTRY)&_ZN6S200C63v30Ev,
  (VTBL_ENTRY)&_ZN6S200C63v31Ev,
  (VTBL_ENTRY)&_ZN6S200C63v32Ev,
  (VTBL_ENTRY)&_ZN6S200C63v33Ev,
  (VTBL_ENTRY)&_ZN6S200C63v34Ev,
  (VTBL_ENTRY)&_ZN6S200C63v35Ev,
  (VTBL_ENTRY)&_ZN6S200C63v36Ev,
  (VTBL_ENTRY)&_ZN6S200C63v37Ev,
  (VTBL_ENTRY)&_ZN6S200C63v38Ev,
  (VTBL_ENTRY)&_ZN6S200C63v39Ev,
  (VTBL_ENTRY)&_ZN6S200C63v40Ev,
  (VTBL_ENTRY)&_ZN6S200C63v41Ev,
  (VTBL_ENTRY)&_ZN6S200C63v42Ev,
  (VTBL_ENTRY)&_ZN6S200C63v43Ev,
  (VTBL_ENTRY)&_ZN6S200C63v44Ev,
  (VTBL_ENTRY)&_ZN6S200C63v45Ev,
  (VTBL_ENTRY)&_ZN6S200C63v46Ev,
  (VTBL_ENTRY)&_ZN6S200C63v47Ev,
  (VTBL_ENTRY)&_ZN6S200C63v48Ev,
  (VTBL_ENTRY)&_ZN6S200C63v49Ev,
  (VTBL_ENTRY)&_ZN6S200C63v50Ev,
  (VTBL_ENTRY)&_ZN6S200C63v51Ev,
  (VTBL_ENTRY)&_ZN6S200C63v52Ev,
  (VTBL_ENTRY)&_ZN6S200C63v53Ev,
  (VTBL_ENTRY)&_ZN6S200C63v54Ev,
  (VTBL_ENTRY)&_ZN6S200C63v55Ev,
  (VTBL_ENTRY)&_ZN6S200C63v56Ev,
  (VTBL_ENTRY)&_ZN6S200C63v57Ev,
  (VTBL_ENTRY)&_ZN6S200C63v58Ev,
  (VTBL_ENTRY)&_ZN6S200C63v59Ev,
  (VTBL_ENTRY)&_ZN6S200C63v60Ev,
  (VTBL_ENTRY)&_ZN6S200C63v61Ev,
  (VTBL_ENTRY)&_ZN6S200C63v62Ev,
  (VTBL_ENTRY)&_ZN6S200C63v63Ev,
  (VTBL_ENTRY)&_ZN6S200C63v64Ev,
  (VTBL_ENTRY)&_ZN6S200C63v65Ev,
  (VTBL_ENTRY)&_ZN6S200C63v66Ev,
  (VTBL_ENTRY)&_ZN6S200C63v67Ev,
  (VTBL_ENTRY)&_ZN6S200C53v68Ev,
  (VTBL_ENTRY)&_ZN6S200C53v69Ev,
  (VTBL_ENTRY)&_ZN6S200C53v70Ev,
  (VTBL_ENTRY)&_ZN6S200C53v71Ev,
  (VTBL_ENTRY)&_ZN6S200C53v72Ev,
  (VTBL_ENTRY)&_ZN6S200C53v73Ev,
  (VTBL_ENTRY)&_ZN6S200C53v74Ev,
  (VTBL_ENTRY)&_ZN6S200C53v75Ev,
  (VTBL_ENTRY)&_ZN6S200C53v76Ev,
  (VTBL_ENTRY)&_ZN6S200C53v77Ev,
  (VTBL_ENTRY)&_ZN6S200C53v78Ev,
  (VTBL_ENTRY)&_ZN6S200C53v79Ev,
  (VTBL_ENTRY)&_ZN6S200C53v80Ev,
  (VTBL_ENTRY)&_ZN6S200C53v81Ev,
  (VTBL_ENTRY)&_ZN6S200C53v82Ev,
  (VTBL_ENTRY)&_ZN6S200C53v83Ev,
  (VTBL_ENTRY)&_ZN6S200C53v84Ev,
  (VTBL_ENTRY)&_ZN6S200C53v85Ev,
  (VTBL_ENTRY)&_ZN6S200C53v86Ev,
  (VTBL_ENTRY)&_ZN6S200C53v87Ev,
  (VTBL_ENTRY)&_ZN6S200C53v88Ev,
  (VTBL_ENTRY)&_ZN6S200C53v89Ev,
  (VTBL_ENTRY)&_ZN6S200C43v90Ev,
  (VTBL_ENTRY)&_ZN6S200C43v91Ev,
  (VTBL_ENTRY)&_ZN6S200C43v92Ev,
  (VTBL_ENTRY)&_ZN6S200C43v93Ev,
  (VTBL_ENTRY)&_ZN6S200C43v94Ev,
  (VTBL_ENTRY)&_ZN6S200C43v95Ev,
  (VTBL_ENTRY)&_ZN6S200C43v96Ev,
  (VTBL_ENTRY)&_ZN6S200C43v97Ev,
  (VTBL_ENTRY)&_ZN6S200C43v98Ev,
  (VTBL_ENTRY)&_ZN6S200C43v99Ev,
  (VTBL_ENTRY)&_ZN6S200C44v100Ev,
  (VTBL_ENTRY)&_ZN6S200C44v101Ev,
  (VTBL_ENTRY)&_ZN6S200C44v102Ev,
  (VTBL_ENTRY)&_ZN6S200C44v103Ev,
  (VTBL_ENTRY)&_ZN6S200C44v104Ev,
  (VTBL_ENTRY)&_ZN6S200C44v105Ev,
  (VTBL_ENTRY)&_ZN6S200C44v106Ev,
  (VTBL_ENTRY)&_ZN6S200C44v107Ev,
  (VTBL_ENTRY)&_ZN6S200C44v108Ev,
  (VTBL_ENTRY)&_ZN6S200C44v109Ev,
  (VTBL_ENTRY)&_ZN6S200C34v110Ev,
  (VTBL_ENTRY)&_ZN6S200C34v111Ev,
  (VTBL_ENTRY)&_ZN6S200C34v112Ev,
  (VTBL_ENTRY)&_ZN6S200C34v113Ev,
  (VTBL_ENTRY)&_ZN6S200C24v114Ev,
  (VTBL_ENTRY)&_ZN6S200C24v115Ev,
  (VTBL_ENTRY)&_ZN6S200C24v116Ev,
  (VTBL_ENTRY)&_ZN6S200C24v117Ev,
  (VTBL_ENTRY)&_ZN6S200C24v118Ev,
  (VTBL_ENTRY)&_ZN6S200C24v119Ev,
  (VTBL_ENTRY)&_ZN6S200C24v120Ev,
  (VTBL_ENTRY)&_ZN6S200C24v121Ev,
};
extern VTBL_ENTRY _ZTI6S200C2[];
extern  VTBL_ENTRY _ZTV6S200C2[];
Class_Descriptor cd_S200C2 = {  "S200C2", // class name
  bases_S200C2, 4,
  &(vtc_S200C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,228), // object size
  NSPAIRA(_ZTI6S200C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S200C2),122, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S200C1  : S200C2 {
  ::S3443C4_nt s200c1f0;
  virtual  ~S200C1(); // _ZN6S200C1D1Ev
  virtual void  v1(); // _ZN6S200C12v1Ev
  virtual void  v2(); // _ZN6S200C12v2Ev
  virtual void  v3(); // _ZN6S200C12v3Ev
  S200C1(); // tgen
};
//SIG(1 S200C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 Fi[2] Fp Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 FC12{ m} FC8 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 Fi:1 Fi:1 Fi:1 FC13{ BC14{ BC11}} FC15{ BC16{ BC11}} FC17{ BC18{ BC11}} FC19{ BC20{ BC11}} Fi[3]} vd v110 v111 v112 v113 FC7 Fi:1 FC9} vd v114 v115 v116 v117 v118 v119 v120 v121 Fi Fi:1} vd v1 v2 v3 FC7}


 S200C1 ::~S200C1(){ note_dtor("S200C1", this);}
void  S200C1 ::v1(){vfunc_called(this, "_ZN6S200C12v1Ev");}
void  S200C1 ::v2(){vfunc_called(this, "_ZN6S200C12v2Ev");}
void  S200C1 ::v3(){vfunc_called(this, "_ZN6S200C12v3Ev");}
S200C1 ::S200C1(){ note_ctor("S200C1", this);} // tgen

static void Test_S200C1()
{
  extern Class_Descriptor cd_S200C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(40,60)];
    init_test(&cd_S200C1, buf);
    S200C1 *dp, &lv = *(dp=new (buf) S200C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(312,236), "sizeof(S200C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S200C1)");
    check_base_class_offset(lv, (S200C6*)(S200C5*)(S200C4*)(S200C3*)(S200C2*), 0, "S200C1");
    check_base_class_offset(lv, (S200C5*)(S200C4*)(S200C3*)(S200C2*), 0, "S200C1");
    check_base_class_offset(lv, (S200C4*)(S200C3*)(S200C2*), 0, "S200C1");
    check_base_class_offset(lv, (S200C3*)(S200C2*), 0, "S200C1");
    check_base_class_offset(lv, (S200C2*), 0, "S200C1");
    check_field_offset(lv, s200c1f0, ABISELECT(304,228), "S200C1.s200c1f0");
    test_class_info(&lv, &cd_S200C1);
    dp->~S200C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS200C1(Test_S200C1, "S200C1", ABISELECT(312,236));

#else // __cplusplus

extern void _ZN6S200C1C1Ev();
extern void _ZN6S200C1D1Ev();
Name_Map name_map_S200C1[] = {
  NSPAIR(_ZN6S200C1C1Ev),
  NSPAIR(_ZN6S200C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S200C6;
extern VTBL_ENTRY _ZTI6S200C6[];
extern  VTBL_ENTRY _ZTV6S200C6[];
extern Class_Descriptor cd_S200C5;
extern VTBL_ENTRY _ZTI6S200C5[];
extern  VTBL_ENTRY _ZTV6S200C5[];
extern Class_Descriptor cd_S200C4;
extern VTBL_ENTRY _ZTI6S200C4[];
extern  VTBL_ENTRY _ZTV6S200C4[];
extern Class_Descriptor cd_S200C3;
extern VTBL_ENTRY _ZTI6S200C3[];
extern  VTBL_ENTRY _ZTV6S200C3[];
extern Class_Descriptor cd_S200C2;
extern VTBL_ENTRY _ZTI6S200C2[];
extern  VTBL_ENTRY _ZTV6S200C2[];
static Base_Class bases_S200C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S200C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S200C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S200C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S200C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S200C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S200C1[];
extern void _ZN6S200C1D1Ev();
extern void _ZN6S200C1D0Ev();
extern void _ZN6S200C62v4Ev();
extern void _ZN6S200C62v5Ev();
extern void _ZN6S200C62v6Ev();
extern void _ZN6S200C62v7Ev();
extern void _ZN6S200C62v8Ev();
extern void _ZN6S200C62v9Ev();
extern void _ZN6S200C63v10Ev();
extern void _ZN6S200C63v11Ev();
extern void _ZN6S200C63v12Ev();
extern void _ZN6S200C63v13Ev();
extern void _ZN6S200C63v14Ev();
extern void _ZN6S200C63v15Ev();
extern void _ZN6S200C63v16Ev();
extern void _ZN6S200C63v17Ev();
extern void _ZN6S200C63v18Ev();
extern void _ZN6S200C63v19Ev();
extern void _ZN6S200C63v20Ev();
extern void _ZN6S200C63v21Ev();
extern void _ZN6S200C63v22Ev();
extern void _ZN6S200C63v23Ev();
extern void _ZN6S200C63v24Ev();
extern void _ZN6S200C63v25Ev();
extern void _ZN6S200C63v26Ev();
extern void _ZN6S200C63v27Ev();
extern void _ZN6S200C63v28Ev();
extern void _ZN6S200C63v29Ev();
extern void _ZN6S200C63v30Ev();
extern void _ZN6S200C63v31Ev();
extern void _ZN6S200C63v32Ev();
extern void _ZN6S200C63v33Ev();
extern void _ZN6S200C63v34Ev();
extern void _ZN6S200C63v35Ev();
extern void _ZN6S200C63v36Ev();
extern void _ZN6S200C63v37Ev();
extern void _ZN6S200C63v38Ev();
extern void _ZN6S200C63v39Ev();
extern void _ZN6S200C63v40Ev();
extern void _ZN6S200C63v41Ev();
extern void _ZN6S200C63v42Ev();
extern void _ZN6S200C63v43Ev();
extern void _ZN6S200C63v44Ev();
extern void _ZN6S200C63v45Ev();
extern void _ZN6S200C63v46Ev();
extern void _ZN6S200C63v47Ev();
extern void _ZN6S200C63v48Ev();
extern void _ZN6S200C63v49Ev();
extern void _ZN6S200C63v50Ev();
extern void _ZN6S200C63v51Ev();
extern void _ZN6S200C63v52Ev();
extern void _ZN6S200C63v53Ev();
extern void _ZN6S200C63v54Ev();
extern void _ZN6S200C63v55Ev();
extern void _ZN6S200C63v56Ev();
extern void _ZN6S200C63v57Ev();
extern void _ZN6S200C63v58Ev();
extern void _ZN6S200C63v59Ev();
extern void _ZN6S200C63v60Ev();
extern void _ZN6S200C63v61Ev();
extern void _ZN6S200C63v62Ev();
extern void _ZN6S200C63v63Ev();
extern void _ZN6S200C63v64Ev();
extern void _ZN6S200C63v65Ev();
extern void _ZN6S200C63v66Ev();
extern void _ZN6S200C63v67Ev();
extern void _ZN6S200C53v68Ev();
extern void _ZN6S200C53v69Ev();
extern void _ZN6S200C53v70Ev();
extern void _ZN6S200C53v71Ev();
extern void _ZN6S200C53v72Ev();
extern void _ZN6S200C53v73Ev();
extern void _ZN6S200C53v74Ev();
extern void _ZN6S200C53v75Ev();
extern void _ZN6S200C53v76Ev();
extern void _ZN6S200C53v77Ev();
extern void _ZN6S200C53v78Ev();
extern void _ZN6S200C53v79Ev();
extern void _ZN6S200C53v80Ev();
extern void _ZN6S200C53v81Ev();
extern void _ZN6S200C53v82Ev();
extern void _ZN6S200C53v83Ev();
extern void _ZN6S200C53v84Ev();
extern void _ZN6S200C53v85Ev();
extern void _ZN6S200C53v86Ev();
extern void _ZN6S200C53v87Ev();
extern void _ZN6S200C53v88Ev();
extern void _ZN6S200C53v89Ev();
extern void _ZN6S200C43v90Ev();
extern void _ZN6S200C43v91Ev();
extern void _ZN6S200C43v92Ev();
extern void _ZN6S200C43v93Ev();
extern void _ZN6S200C43v94Ev();
extern void _ZN6S200C43v95Ev();
extern void _ZN6S200C43v96Ev();
extern void _ZN6S200C43v97Ev();
extern void _ZN6S200C43v98Ev();
extern void _ZN6S200C43v99Ev();
extern void _ZN6S200C44v100Ev();
extern void _ZN6S200C44v101Ev();
extern void _ZN6S200C44v102Ev();
extern void _ZN6S200C44v103Ev();
extern void _ZN6S200C44v104Ev();
extern void _ZN6S200C44v105Ev();
extern void _ZN6S200C44v106Ev();
extern void _ZN6S200C44v107Ev();
extern void _ZN6S200C44v108Ev();
extern void _ZN6S200C44v109Ev();
extern void _ZN6S200C34v110Ev();
extern void _ZN6S200C34v111Ev();
extern void _ZN6S200C34v112Ev();
extern void _ZN6S200C34v113Ev();
extern void _ZN6S200C24v114Ev();
extern void _ZN6S200C24v115Ev();
extern void _ZN6S200C24v116Ev();
extern void _ZN6S200C24v117Ev();
extern void _ZN6S200C24v118Ev();
extern void _ZN6S200C24v119Ev();
extern void _ZN6S200C24v120Ev();
extern void _ZN6S200C24v121Ev();
extern void _ZN6S200C12v1Ev();
extern void _ZN6S200C12v2Ev();
extern void _ZN6S200C12v3Ev();
static  VTBL_ENTRY vtc_S200C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S200C1[0]),
  (VTBL_ENTRY)&_ZN6S200C1D1Ev,
  (VTBL_ENTRY)&_ZN6S200C1D0Ev,
  (VTBL_ENTRY)&_ZN6S200C62v4Ev,
  (VTBL_ENTRY)&_ZN6S200C62v5Ev,
  (VTBL_ENTRY)&_ZN6S200C62v6Ev,
  (VTBL_ENTRY)&_ZN6S200C62v7Ev,
  (VTBL_ENTRY)&_ZN6S200C62v8Ev,
  (VTBL_ENTRY)&_ZN6S200C62v9Ev,
  (VTBL_ENTRY)&_ZN6S200C63v10Ev,
  (VTBL_ENTRY)&_ZN6S200C63v11Ev,
  (VTBL_ENTRY)&_ZN6S200C63v12Ev,
  (VTBL_ENTRY)&_ZN6S200C63v13Ev,
  (VTBL_ENTRY)&_ZN6S200C63v14Ev,
  (VTBL_ENTRY)&_ZN6S200C63v15Ev,
  (VTBL_ENTRY)&_ZN6S200C63v16Ev,
  (VTBL_ENTRY)&_ZN6S200C63v17Ev,
  (VTBL_ENTRY)&_ZN6S200C63v18Ev,
  (VTBL_ENTRY)&_ZN6S200C63v19Ev,
  (VTBL_ENTRY)&_ZN6S200C63v20Ev,
  (VTBL_ENTRY)&_ZN6S200C63v21Ev,
  (VTBL_ENTRY)&_ZN6S200C63v22Ev,
  (VTBL_ENTRY)&_ZN6S200C63v23Ev,
  (VTBL_ENTRY)&_ZN6S200C63v24Ev,
  (VTBL_ENTRY)&_ZN6S200C63v25Ev,
  (VTBL_ENTRY)&_ZN6S200C63v26Ev,
  (VTBL_ENTRY)&_ZN6S200C63v27Ev,
  (VTBL_ENTRY)&_ZN6S200C63v28Ev,
  (VTBL_ENTRY)&_ZN6S200C63v29Ev,
  (VTBL_ENTRY)&_ZN6S200C63v30Ev,
  (VTBL_ENTRY)&_ZN6S200C63v31Ev,
  (VTBL_ENTRY)&_ZN6S200C63v32Ev,
  (VTBL_ENTRY)&_ZN6S200C63v33Ev,
  (VTBL_ENTRY)&_ZN6S200C63v34Ev,
  (VTBL_ENTRY)&_ZN6S200C63v35Ev,
  (VTBL_ENTRY)&_ZN6S200C63v36Ev,
  (VTBL_ENTRY)&_ZN6S200C63v37Ev,
  (VTBL_ENTRY)&_ZN6S200C63v38Ev,
  (VTBL_ENTRY)&_ZN6S200C63v39Ev,
  (VTBL_ENTRY)&_ZN6S200C63v40Ev,
  (VTBL_ENTRY)&_ZN6S200C63v41Ev,
  (VTBL_ENTRY)&_ZN6S200C63v42Ev,
  (VTBL_ENTRY)&_ZN6S200C63v43Ev,
  (VTBL_ENTRY)&_ZN6S200C63v44Ev,
  (VTBL_ENTRY)&_ZN6S200C63v45Ev,
  (VTBL_ENTRY)&_ZN6S200C63v46Ev,
  (VTBL_ENTRY)&_ZN6S200C63v47Ev,
  (VTBL_ENTRY)&_ZN6S200C63v48Ev,
  (VTBL_ENTRY)&_ZN6S200C63v49Ev,
  (VTBL_ENTRY)&_ZN6S200C63v50Ev,
  (VTBL_ENTRY)&_ZN6S200C63v51Ev,
  (VTBL_ENTRY)&_ZN6S200C63v52Ev,
  (VTBL_ENTRY)&_ZN6S200C63v53Ev,
  (VTBL_ENTRY)&_ZN6S200C63v54Ev,
  (VTBL_ENTRY)&_ZN6S200C63v55Ev,
  (VTBL_ENTRY)&_ZN6S200C63v56Ev,
  (VTBL_ENTRY)&_ZN6S200C63v57Ev,
  (VTBL_ENTRY)&_ZN6S200C63v58Ev,
  (VTBL_ENTRY)&_ZN6S200C63v59Ev,
  (VTBL_ENTRY)&_ZN6S200C63v60Ev,
  (VTBL_ENTRY)&_ZN6S200C63v61Ev,
  (VTBL_ENTRY)&_ZN6S200C63v62Ev,
  (VTBL_ENTRY)&_ZN6S200C63v63Ev,
  (VTBL_ENTRY)&_ZN6S200C63v64Ev,
  (VTBL_ENTRY)&_ZN6S200C63v65Ev,
  (VTBL_ENTRY)&_ZN6S200C63v66Ev,
  (VTBL_ENTRY)&_ZN6S200C63v67Ev,
  (VTBL_ENTRY)&_ZN6S200C53v68Ev,
  (VTBL_ENTRY)&_ZN6S200C53v69Ev,
  (VTBL_ENTRY)&_ZN6S200C53v70Ev,
  (VTBL_ENTRY)&_ZN6S200C53v71Ev,
  (VTBL_ENTRY)&_ZN6S200C53v72Ev,
  (VTBL_ENTRY)&_ZN6S200C53v73Ev,
  (VTBL_ENTRY)&_ZN6S200C53v74Ev,
  (VTBL_ENTRY)&_ZN6S200C53v75Ev,
  (VTBL_ENTRY)&_ZN6S200C53v76Ev,
  (VTBL_ENTRY)&_ZN6S200C53v77Ev,
  (VTBL_ENTRY)&_ZN6S200C53v78Ev,
  (VTBL_ENTRY)&_ZN6S200C53v79Ev,
  (VTBL_ENTRY)&_ZN6S200C53v80Ev,
  (VTBL_ENTRY)&_ZN6S200C53v81Ev,
  (VTBL_ENTRY)&_ZN6S200C53v82Ev,
  (VTBL_ENTRY)&_ZN6S200C53v83Ev,
  (VTBL_ENTRY)&_ZN6S200C53v84Ev,
  (VTBL_ENTRY)&_ZN6S200C53v85Ev,
  (VTBL_ENTRY)&_ZN6S200C53v86Ev,
  (VTBL_ENTRY)&_ZN6S200C53v87Ev,
  (VTBL_ENTRY)&_ZN6S200C53v88Ev,
  (VTBL_ENTRY)&_ZN6S200C53v89Ev,
  (VTBL_ENTRY)&_ZN6S200C43v90Ev,
  (VTBL_ENTRY)&_ZN6S200C43v91Ev,
  (VTBL_ENTRY)&_ZN6S200C43v92Ev,
  (VTBL_ENTRY)&_ZN6S200C43v93Ev,
  (VTBL_ENTRY)&_ZN6S200C43v94Ev,
  (VTBL_ENTRY)&_ZN6S200C43v95Ev,
  (VTBL_ENTRY)&_ZN6S200C43v96Ev,
  (VTBL_ENTRY)&_ZN6S200C43v97Ev,
  (VTBL_ENTRY)&_ZN6S200C43v98Ev,
  (VTBL_ENTRY)&_ZN6S200C43v99Ev,
  (VTBL_ENTRY)&_ZN6S200C44v100Ev,
  (VTBL_ENTRY)&_ZN6S200C44v101Ev,
  (VTBL_ENTRY)&_ZN6S200C44v102Ev,
  (VTBL_ENTRY)&_ZN6S200C44v103Ev,
  (VTBL_ENTRY)&_ZN6S200C44v104Ev,
  (VTBL_ENTRY)&_ZN6S200C44v105Ev,
  (VTBL_ENTRY)&_ZN6S200C44v106Ev,
  (VTBL_ENTRY)&_ZN6S200C44v107Ev,
  (VTBL_ENTRY)&_ZN6S200C44v108Ev,
  (VTBL_ENTRY)&_ZN6S200C44v109Ev,
  (VTBL_ENTRY)&_ZN6S200C34v110Ev,
  (VTBL_ENTRY)&_ZN6S200C34v111Ev,
  (VTBL_ENTRY)&_ZN6S200C34v112Ev,
  (VTBL_ENTRY)&_ZN6S200C34v113Ev,
  (VTBL_ENTRY)&_ZN6S200C24v114Ev,
  (VTBL_ENTRY)&_ZN6S200C24v115Ev,
  (VTBL_ENTRY)&_ZN6S200C24v116Ev,
  (VTBL_ENTRY)&_ZN6S200C24v117Ev,
  (VTBL_ENTRY)&_ZN6S200C24v118Ev,
  (VTBL_ENTRY)&_ZN6S200C24v119Ev,
  (VTBL_ENTRY)&_ZN6S200C24v120Ev,
  (VTBL_ENTRY)&_ZN6S200C24v121Ev,
  (VTBL_ENTRY)&_ZN6S200C12v1Ev,
  (VTBL_ENTRY)&_ZN6S200C12v2Ev,
  (VTBL_ENTRY)&_ZN6S200C12v3Ev,
};
extern VTBL_ENTRY _ZTI6S200C1[];
extern  VTBL_ENTRY _ZTV6S200C1[];
Class_Descriptor cd_S200C1 = {  "S200C1", // class name
  bases_S200C1, 5,
  &(vtc_S200C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(312,236), // object size
  NSPAIRA(_ZTI6S200C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S200C1),125, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S14325C3  {
  int s14325c3f0[3];
  long s14325c3f1;
};
//SIG(-1 S14325C3) C1{ Fi[3] Fl}



static void Test_S14325C3()
{
  {
    init_simple_test("S14325C3");
    S14325C3 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S14325C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S14325C3)");
    check_field_offset(lv, s14325c3f0, 0, "S14325C3.s14325c3f0");
    check_field_offset(lv, s14325c3f1, ABISELECT(16,12), "S14325C3.s14325c3f1");
  }
}
static Arrange_To_Call_Me vS14325C3(Test_S14325C3, "S14325C3", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S14325C7  {
  int s14325c7f0;
  char s14325c7f1;
  char s14325c7f2;
  char s14325c7f3[48];
};
//SIG(-1 S14325C7) C1{ Fi Fc[50]}



static void Test_S14325C7()
{
  {
    init_simple_test("S14325C7");
    S14325C7 lv;
    check2(sizeof(lv), 56, "sizeof(S14325C7)");
    check2(__alignof__(lv), 4, "__alignof__(S14325C7)");
    check_field_offset(lv, s14325c7f0, 0, "S14325C7.s14325c7f0");
    check_field_offset(lv, s14325c7f1, 4, "S14325C7.s14325c7f1");
    check_field_offset(lv, s14325c7f2, 5, "S14325C7.s14325c7f2");
    check_field_offset(lv, s14325c7f3, 6, "S14325C7.s14325c7f3");
  }
}
static Arrange_To_Call_Me vS14325C7(Test_S14325C7, "S14325C7", 56);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S14325C8  {
  int s14325c8f0;
  int s14325c8f1;
  long s14325c8f2;
  char s14325c8f3[255];
};
//SIG(-1 S14325C8) C1{ Fi[2] Fl Fc[255]}



static void Test_S14325C8()
{
  {
    init_simple_test("S14325C8");
    S14325C8 lv;
    check2(sizeof(lv), ABISELECT(272,268), "sizeof(S14325C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S14325C8)");
    check_field_offset(lv, s14325c8f0, 0, "S14325C8.s14325c8f0");
    check_field_offset(lv, s14325c8f1, 4, "S14325C8.s14325c8f1");
    check_field_offset(lv, s14325c8f2, 8, "S14325C8.s14325c8f2");
    check_field_offset(lv, s14325c8f3, ABISELECT(16,12), "S14325C8.s14325c8f3");
  }
}
static Arrange_To_Call_Me vS14325C8(Test_S14325C8, "S14325C8", ABISELECT(272,268));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S14325C5  {
  char s14325c5f0;
  int s14325c5f1;
  ::S12863C31 s14325c5f2;
  ::S14325C7 s14325c5f3;
  char s14325c5f4;
  char s14325c5f5;
  int s14325c5f6;
  ::S14325C8 s14325c5f7;
};
//SIG(1 S14325C5) C1{ Fc Fi FC2{ Fi[4] Fc[49]} FC3{ Fi Fc[50]} Fc[2] Fi FC4{ Fi[2] Fl Fc[255]}}



static void Test_S14325C5()
{
  {
    init_simple_test("S14325C5");
    S14325C5 lv;
    check2(sizeof(lv), ABISELECT(416,408), "sizeof(S14325C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S14325C5)");
    check_field_offset(lv, s14325c5f0, 0, "S14325C5.s14325c5f0");
    check_field_offset(lv, s14325c5f1, 4, "S14325C5.s14325c5f1");
    check_field_offset(lv, s14325c5f2, 8, "S14325C5.s14325c5f2");
    check_field_offset(lv, s14325c5f3, 76, "S14325C5.s14325c5f3");
    check_field_offset(lv, s14325c5f4, 132, "S14325C5.s14325c5f4");
    check_field_offset(lv, s14325c5f5, 133, "S14325C5.s14325c5f5");
    check_field_offset(lv, s14325c5f6, 136, "S14325C5.s14325c5f6");
    check_field_offset(lv, s14325c5f7, ABISELECT(144,140), "S14325C5.s14325c5f7");
  }
}
static Arrange_To_Call_Me vS14325C5(Test_S14325C5, "S14325C5", ABISELECT(416,408));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S14325C9  {
  int s14325c9f0;
  short s14325c9f1;
  ::S12863C31 s14325c9f2;
  ::S14325C7 s14325c9f3;
  int s14325c9f4;
  ::S12863C29 s14325c9f5;
  int s14325c9f6;
  ::S12863C3 s14325c9f7;
};
//SIG(1 S14325C9) C1{ Fi Fs FC2{ Fi[4] Fc[49]} FC3{ Fi Fc[50]} Fi FC4{ Fc[7]} Fi FC5{ Fl FC6{ Fi Fl Fc} FC7{ Fc FC8{ Fi FU9{ FC10{ Fc Fc Fc} FC11{ Fi Fi Fc} FC12{ Fc Fc} FC13{ Fs Fs} FC14{ Fs Fc Fc} FC15{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC12 FC16{ Fc Fc Fc[128]} FC17{ Fc Fc} FC18{ Fc Fc[128]} FC19{ Fc Fc[32]} FC18 FC19 FC20{ Fc Fc Fc Fc[134]} FC21{ Fc} FC22{ FC23{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC21 FC24{ Fi} FC24 FC25{ Fi Fc Fc[226]}}}[7] Fi Fi Fc Fc Fc[229] Fc} Fc FC4 FC4 FC4 FC4 FC4 Fi Fi FC10 Fc Fi Fi FC2 Fi Fi FC26{ Fi Fi} Fl Fp Fp FC27{ Fc[4] Fc} Fc FC28{ Fc Fc Fp}}}



static void Test_S14325C9()
{
  {
    init_simple_test("S14325C9");
    S14325C9 lv;
    check2(sizeof(lv), ABISELECT(2272,2228), "sizeof(S14325C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S14325C9)");
    check_field_offset(lv, s14325c9f0, 0, "S14325C9.s14325c9f0");
    check_field_offset(lv, s14325c9f1, 4, "S14325C9.s14325c9f1");
    check_field_offset(lv, s14325c9f2, 8, "S14325C9.s14325c9f2");
    check_field_offset(lv, s14325c9f3, 76, "S14325C9.s14325c9f3");
    check_field_offset(lv, s14325c9f4, 132, "S14325C9.s14325c9f4");
    check_field_offset(lv, s14325c9f5, 136, "S14325C9.s14325c9f5");
    check_field_offset(lv, s14325c9f6, 144, "S14325C9.s14325c9f6");
    check_field_offset(lv, s14325c9f7, ABISELECT(152,148), "S14325C9.s14325c9f7");
  }
}
static Arrange_To_Call_Me vS14325C9(Test_S14325C9, "S14325C9", ABISELECT(2272,2228));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S14325C41  {
  char s14325c41f0;
  ::S12863C31 s14325c41f1;
  ::S14325C8 s14325c41f2;
};
//SIG(1 S14325C41) C1{ Fc FC2{ Fi[4] Fc[49]} FC3{ Fi[2] Fl Fc[255]}}



static void Test_S14325C41()
{
  {
    init_simple_test("S14325C41");
    S14325C41 lv;
    check2(sizeof(lv), ABISELECT(344,340), "sizeof(S14325C41)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S14325C41)");
    check_field_offset(lv, s14325c41f0, 0, "S14325C41.s14325c41f0");
    check_field_offset(lv, s14325c41f1, 4, "S14325C41.s14325c41f1");
    check_field_offset(lv, s14325c41f2, 72, "S14325C41.s14325c41f2");
  }
}
static Arrange_To_Call_Me vS14325C41(Test_S14325C41, "S14325C41", ABISELECT(344,340));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S14325C43  {
  char s14325c43f0;
  void *s14325c43f1;
};
//SIG(-1 S14325C43) C1{ Fc Fp}



static void Test_S14325C43()
{
  {
    init_simple_test("S14325C43");
    S14325C43 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S14325C43)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S14325C43)");
    check_field_offset(lv, s14325c43f0, 0, "S14325C43.s14325c43f0");
    check_field_offset(lv, s14325c43f1, ABISELECT(8,4), "S14325C43.s14325c43f1");
  }
}
static Arrange_To_Call_Me vS14325C43(Test_S14325C43, "S14325C43", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S14325C42  {
  ::S14325C43 s14325c42f0;
  char s14325c42f1;
  ::S12863C31 s14325c42f2;
  ::S12863C31 s14325c42f3;
  int s14325c42f4;
  ::S12863C38 s14325c42f5;
  ::S12863C29 s14325c42f6;
};
//SIG(1 S14325C42) C1{ FC2{ Fc Fp} Fc FC3{ Fi[4] Fc[49]} FC3 Fi FC4{ Fi Fc Fi[2] Fc Fi Fc} FC5{ Fc[7]}}



static void Test_S14325C42()
{
  {
    init_simple_test("S14325C42");
    S14325C42 lv;
    check2(sizeof(lv), ABISELECT(200,188), "sizeof(S14325C42)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S14325C42)");
    check_field_offset(lv, s14325c42f0, 0, "S14325C42.s14325c42f0");
    check_field_offset(lv, s14325c42f1, ABISELECT(16,8), "S14325C42.s14325c42f1");
    check_field_offset(lv, s14325c42f2, ABISELECT(20,12), "S14325C42.s14325c42f2");
    check_field_offset(lv, s14325c42f3, ABISELECT(88,80), "S14325C42.s14325c42f3");
    check_field_offset(lv, s14325c42f4, ABISELECT(156,148), "S14325C42.s14325c42f4");
    check_field_offset(lv, s14325c42f5, ABISELECT(160,152), "S14325C42.s14325c42f5");
    check_field_offset(lv, s14325c42f6, ABISELECT(188,180), "S14325C42.s14325c42f6");
  }
}
static Arrange_To_Call_Me vS14325C42(Test_S14325C42, "S14325C42", ABISELECT(200,188));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S14325C4  {
  ::S14325C5 s14325c4f0;
  ::S14325C9 s14325c4f1;
  ::S14325C41 s14325c4f2;
  ::S14325C42 s14325c4f3;
};
//SIG(1 S14325C4) U1{ FC2{ Fc Fi FC3{ Fi Fi Fi Fi Fc Fc[48]} FC4{ Fi Fc Fc Fc[48]} Fc Fc Fi FC5{ Fi Fi Fl Fc[255]}} FC6{ Fi Fs FC3 FC4 Fi FC7{ Fc Fc Fc Fc Fc Fc Fc} Fi FC8{ Fl FC9{ Fi Fl Fc} FC10{ Fc FC11{ Fi FU12{ FC13{ Fc Fc Fc} FC14{ Fi Fi Fc} FC15{ Fc Fc} FC16{ Fs Fs} FC17{ Fs Fc Fc} FC18{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC15 FC19{ Fc Fc Fc[128]} FC20{ Fc Fc} FC21{ Fc Fc[128]} FC22{ Fc Fc[32]} FC21 FC22 FC23{ Fc Fc Fc Fc[134]} FC24{ Fc} FC25{ FC26{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC24 FC27{ Fi} FC27 FC28{ Fi Fc Fc[226]}}}[7] Fi Fi Fc Fc Fc[229] Fc} Fc FC7 FC7 FC7 FC7 FC7 Fi Fi FC13 Fc Fi Fi FC3 Fi Fi FC29{ Fi Fi} Fl Fp Fp FC30{ Fc[4] Fc} Fc FC31{ Fc Fc Fp}}} FC32{ Fc FC3 FC5} FC33{ FC34{ Fc Fp} Fc FC3 FC3 Fi FC35{ Fi Fc Fi Fi Fc Fi Fc} FC7}}

#endif // __cplusplus
#ifdef __cplusplus

struct  S14325C2  {
  ::S14325C3 s14325c2f0;
  ::S14325C4 s14325c2f1;
};
//SIG(-1 S14325C2) C1{ FC2{ Fi[3] Fl} FU3{ FC4{ Fc Fi FC5{ Fi Fi Fi Fi Fc Fc[48]} FC6{ Fi Fc Fc Fc[48]} Fc Fc Fi FC7{ Fi Fi Fl Fc[255]}} FC8{ Fi Fs FC5 FC6 Fi FC9{ Fc Fc Fc Fc Fc Fc Fc} Fi FC10{ Fl FC11{ Fi Fl Fc} FC12{ Fc FC13{ Fi FU14{ FC15{ Fc Fc Fc} FC16{ Fi Fi Fc} FC17{ Fc Fc} FC18{ Fs Fs} FC19{ Fs Fc Fc} FC20{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC17 FC21{ Fc Fc Fc[128]} FC22{ Fc Fc} FC23{ Fc Fc[128]} FC24{ Fc Fc[32]} FC23 FC24 FC25{ Fc Fc Fc Fc[134]} FC26{ Fc} FC27{ FC28{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC26 FC29{ Fi} FC29 FC30{ Fi Fc Fc[226]}}}[7] Fi Fi Fc Fc Fc[229] Fc} Fc FC9 FC9 FC9 FC9 FC9 Fi Fi FC15 Fc Fi Fi FC5 Fi Fi FC31{ Fi Fi} Fl Fp Fp FC32{ Fc[4] Fc} Fc FC33{ Fc Fc Fp}}} FC34{ Fc FC5 FC7} FC35{ FC36{ Fc Fp} Fc FC5 FC5 Fi FC37{ Fi Fc Fi Fi Fc Fi Fc} FC9}}}



static void Test_S14325C2()
{
  {
    init_simple_test("S14325C2");
    S14325C2 lv;
    check2(sizeof(lv), ABISELECT(2296,2244), "sizeof(S14325C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S14325C2)");
    check_field_offset(lv, s14325c2f0, 0, "S14325C2.s14325c2f0");
    check_field_offset(lv, s14325c2f1, ABISELECT(24,16), "S14325C2.s14325c2f1");
  }
}
static Arrange_To_Call_Me vS14325C2(Test_S14325C2, "S14325C2", ABISELECT(2296,2244));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S14325C1  {
  void *s14325c1f0;
  int s14325c1f1[3];
  ::S14325C2 s14325c1f2;
  ::S14325C43 s14325c1f3;
};
//SIG(1 S14325C1) C1{ Fp Fi[3] FC2{ FC3{ Fi[3] Fl} FU4{ FC5{ Fc Fi FC6{ Fi Fi Fi Fi Fc Fc[48]} FC7{ Fi Fc Fc Fc[48]} Fc Fc Fi FC8{ Fi Fi Fl Fc[255]}} FC9{ Fi Fs FC6 FC7 Fi FC10{ Fc Fc Fc Fc Fc Fc Fc} Fi FC11{ Fl FC12{ Fi Fl Fc} FC13{ Fc FC14{ Fi FU15{ FC16{ Fc Fc Fc} FC17{ Fi Fi Fc} FC18{ Fc Fc} FC19{ Fs Fs} FC20{ Fs Fc Fc} FC21{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC18 FC22{ Fc Fc Fc[128]} FC23{ Fc Fc} FC24{ Fc Fc[128]} FC25{ Fc Fc[32]} FC24 FC25 FC26{ Fc Fc Fc Fc[134]} FC27{ Fc} FC28{ FC29{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC27 FC30{ Fi} FC30 FC31{ Fi Fc Fc[226]}}}[7] Fi Fi Fc Fc Fc[229] Fc} Fc FC10 FC10 FC10 FC10 FC10 Fi Fi FC16 Fc Fi Fi FC6 Fi Fi FC32{ Fi Fi} Fl Fp Fp FC33{ Fc[4] Fc} Fc FC34{ Fc Fc Fp}}} FC35{ Fc FC6 FC8} FC36{ FC37{ Fc Fp} Fc FC6 FC6 Fi FC38{ Fi Fc Fi Fi Fc Fi Fc} FC10}}} FC37}



static void Test_S14325C1()
{
  {
    init_simple_test("S14325C1");
    S14325C1 lv;
    check2(sizeof(lv), ABISELECT(2336,2268), "sizeof(S14325C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S14325C1)");
    check_field_offset(lv, s14325c1f0, 0, "S14325C1.s14325c1f0");
    check_field_offset(lv, s14325c1f1, ABISELECT(8,4), "S14325C1.s14325c1f1");
    check_field_offset(lv, s14325c1f2, ABISELECT(24,16), "S14325C1.s14325c1f2");
    check_field_offset(lv, s14325c1f3, ABISELECT(2320,2260), "S14325C1.s14325c1f3");
  }
}
static Arrange_To_Call_Me vS14325C1(Test_S14325C1, "S14325C1", ABISELECT(2336,2268));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S13146C1  {
  int s13146c1f0[2];
  long s13146c1f1;
  ::S14325C2 s13146c1f2;
};
//SIG(1 S13146C1) C1{ Fi[2] Fl FC2{ FC3{ Fi[3] Fl} FU4{ FC5{ Fc Fi FC6{ Fi Fi Fi Fi Fc Fc[48]} FC7{ Fi Fc Fc Fc[48]} Fc Fc Fi FC8{ Fi Fi Fl Fc[255]}} FC9{ Fi Fs FC6 FC7 Fi FC10{ Fc Fc Fc Fc Fc Fc Fc} Fi FC11{ Fl FC12{ Fi Fl Fc} FC13{ Fc FC14{ Fi FU15{ FC16{ Fc Fc Fc} FC17{ Fi Fi Fc} FC18{ Fc Fc} FC19{ Fs Fs} FC20{ Fs Fc Fc} FC21{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC18 FC22{ Fc Fc Fc[128]} FC23{ Fc Fc} FC24{ Fc Fc[128]} FC25{ Fc Fc[32]} FC24 FC25 FC26{ Fc Fc Fc Fc[134]} FC27{ Fc} FC28{ FC29{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC27 FC30{ Fi} FC30 FC31{ Fi Fc Fc[226]}}}[7] Fi Fi Fc Fc Fc[229] Fc} Fc FC10 FC10 FC10 FC10 FC10 Fi Fi FC16 Fc Fi Fi FC6 Fi Fi FC32{ Fi Fi} Fl Fp Fp FC33{ Fc[4] Fc} Fc FC34{ Fc Fc Fp}}} FC35{ Fc FC6 FC8} FC36{ FC37{ Fc Fp} Fc FC6 FC6 Fi FC38{ Fi Fc Fi Fi Fc Fi Fc} FC10}}}}



static void Test_S13146C1()
{
  {
    init_simple_test("S13146C1");
    S13146C1 lv;
    check2(sizeof(lv), ABISELECT(2312,2256), "sizeof(S13146C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S13146C1)");
    check_field_offset(lv, s13146c1f0, 0, "S13146C1.s13146c1f0");
    check_field_offset(lv, s13146c1f1, 8, "S13146C1.s13146c1f1");
    check_field_offset(lv, s13146c1f2, ABISELECT(16,12), "S13146C1.s13146c1f2");
  }
}
static Arrange_To_Call_Me vS13146C1(Test_S13146C1, "S13146C1", ABISELECT(2312,2256));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3799C3_nt  {
  int s3799c3f0;
  void  mf3799c3(); // _ZN10S3799C3_nt8mf3799c3Ev
  virtual  ~S3799C3_nt(); // _ZN10S3799C3_ntD1Ev
  S3799C3_nt(); // tgen
};
//SIG(-1 S3799C3_nt) C1{ vd m Fi}


void  S3799C3_nt ::mf3799c3(){}
 S3799C3_nt ::~S3799C3_nt(){ note_dtor("S3799C3_nt", this);}
S3799C3_nt ::S3799C3_nt(){ note_ctor("S3799C3_nt", this);} // tgen

//skip512 S3799C3_nt

#else // __cplusplus

extern void _ZN10S3799C3_ntC1Ev();
extern void _ZN10S3799C3_ntD1Ev();
Name_Map name_map_S3799C3_nt[] = {
  NSPAIR(_ZN10S3799C3_ntC1Ev),
  NSPAIR(_ZN10S3799C3_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S3799C3_nt[];
extern void _ZN10S3799C3_ntD1Ev();
extern void _ZN10S3799C3_ntD0Ev();
static  VTBL_ENTRY vtc_S3799C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S3799C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S3799C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S3799C3_ntD0Ev,
};
extern VTBL_ENTRY _ZTI10S3799C3_nt[];
VTBL_ENTRY *P__ZTI10S3799C3_nt = _ZTI10S3799C3_nt; 
extern  VTBL_ENTRY _ZTV10S3799C3_nt[];
Class_Descriptor cd_S3799C3_nt = {  "S3799C3_nt", // class name
  0,0,//no base classes
  &(vtc_S3799C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI10S3799C3_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S3799C3_nt),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3799C6_nt  {
  void *s3799c6f0;
  void  mf3799c6(); // _ZN10S3799C6_nt8mf3799c6Ev
};
//SIG(-1 S3799C6_nt) C1{ m Fp}


void  S3799C6_nt ::mf3799c6(){}

//skip512 S3799C6_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3799C8_nt  {
  short s3799c8f0[6];
  int s3799c8f1[2];
  char s3799c8f2;
  short s3799c8f3;
  void  mf3799c8(); // _ZN10S3799C8_nt8mf3799c8Ev
};
//SIG(-1 S3799C8_nt) C1{ m Fs[6] Fi[2] Fc Fs}


void  S3799C8_nt ::mf3799c8(){}

//skip512 S3799C8_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3799C2  : S3799C3_nt {
  void *s3799c2f0;
  __tsi64 s3799c2f1;
  ::S2122C20_nt s3799c2f2;
  ::S2122C20_nt s3799c2f3;
  ::S2122C20_nt s3799c2f4;
  ::S2122C20_nt s3799c2f5;
  ::S2122C20_nt s3799c2f6;
  ::S3799C6_nt s3799c2f7;
  ::S2122C38 s3799c2f8;
  ::S2122C20_nt s3799c2f9;
  ::S3799C8_nt s3799c2f10;
  ::S2122C20_nt s3799c2f11;
  ::S3799C8_nt s3799c2f12;
  ::S3799C8_nt s3799c2f13;
  virtual  ~S3799C2(); // _ZN7S3799C2D1Ev
  virtual void  v1(); // _ZN7S3799C22v1Ev
  S3799C2(); // tgen
};
//SIG(-1 S3799C2) C1{ BC2{ vd m Fi} vd v1 Fp FL FC3{ m Fp Fi FC4{ m}} FC3 FC3 FC3 FC3 FC5{ m Fp} FC6{ m} FC3 FC7{ m Fs[6] Fi[2] Fc Fs} FC3 FC7 FC7}


 S3799C2 ::~S3799C2(){ note_dtor("S3799C2", this);}
void  S3799C2 ::v1(){vfunc_called(this, "_ZN7S3799C22v1Ev");}
S3799C2 ::S3799C2(){ note_ctor("S3799C2", this);} // tgen

static void Test_S3799C2()
{
  extern Class_Descriptor cd_S3799C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(30,47)];
    init_test(&cd_S3799C2, buf);
    S3799C2 *dp, &lv = *(dp=new (buf) S3799C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(232,184), "sizeof(S3799C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3799C2)");
    check_base_class_offset(lv, (S3799C3_nt*), 0, "S3799C2");
    check_field_offset(lv, s3799c2f0, ABISELECT(16,8), "S3799C2.s3799c2f0");
    check_field_offset(lv, s3799c2f1, ABISELECT(24,12), "S3799C2.s3799c2f1");
    check_field_offset(lv, s3799c2f2, ABISELECT(32,20), "S3799C2.s3799c2f2");
    check_field_offset(lv, s3799c2f3, ABISELECT(48,32), "S3799C2.s3799c2f3");
    check_field_offset(lv, s3799c2f4, ABISELECT(64,44), "S3799C2.s3799c2f4");
    check_field_offset(lv, s3799c2f5, ABISELECT(80,56), "S3799C2.s3799c2f5");
    check_field_offset(lv, s3799c2f6, ABISELECT(96,68), "S3799C2.s3799c2f6");
    check_field_offset(lv, s3799c2f7, ABISELECT(112,80), "S3799C2.s3799c2f7");
    check_field_offset(lv, s3799c2f8, ABISELECT(120,84), "S3799C2.s3799c2f8");
    check_field_offset(lv, s3799c2f9, ABISELECT(128,88), "S3799C2.s3799c2f9");
    check_field_offset(lv, s3799c2f10, ABISELECT(144,100), "S3799C2.s3799c2f10");
    check_field_offset(lv, s3799c2f11, ABISELECT(168,124), "S3799C2.s3799c2f11");
    check_field_offset(lv, s3799c2f12, ABISELECT(184,136), "S3799C2.s3799c2f12");
    check_field_offset(lv, s3799c2f13, ABISELECT(208,160), "S3799C2.s3799c2f13");
    test_class_info(&lv, &cd_S3799C2);
    dp->~S3799C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3799C2(Test_S3799C2, "S3799C2", ABISELECT(232,184));

#else // __cplusplus

extern void _ZN7S3799C2C1Ev();
extern void _ZN7S3799C2D1Ev();
Name_Map name_map_S3799C2[] = {
  NSPAIR(_ZN7S3799C2C1Ev),
  NSPAIR(_ZN7S3799C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3799C3_nt;
extern VTBL_ENTRY _ZTI10S3799C3_nt[];
extern  VTBL_ENTRY _ZTV10S3799C3_nt[];
static Base_Class bases_S3799C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3799C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3799C2[];
extern void _ZN7S3799C2D1Ev();
extern void _ZN7S3799C2D0Ev();
extern void _ZN7S3799C22v1Ev();
static  VTBL_ENTRY vtc_S3799C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3799C2[0]),
  (VTBL_ENTRY)&_ZN7S3799C2D1Ev,
  (VTBL_ENTRY)&_ZN7S3799C2D0Ev,
  (VTBL_ENTRY)&_ZN7S3799C22v1Ev,
};
extern VTBL_ENTRY _ZTI7S3799C2[];
extern  VTBL_ENTRY _ZTV7S3799C2[];
Class_Descriptor cd_S3799C2 = {  "S3799C2", // class name
  bases_S3799C2, 1,
  &(vtc_S3799C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(232,184), // object size
  NSPAIRA(_ZTI7S3799C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3799C2),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3799C15_nt  {
  virtual  ~S3799C15_nt(); // _ZN11S3799C15_ntD1Ev
  virtual void  v6(); // _ZN11S3799C15_nt2v6Ev
  virtual void  v7(); // _ZN11S3799C15_nt2v7Ev
  virtual void  v8(); // _ZN11S3799C15_nt2v8Ev
  virtual void  v9(); // _ZN11S3799C15_nt2v9Ev
  S3799C15_nt(); // tgen
};
//SIG(-1 S3799C15_nt) C1{ vd v1 v2 v3 v4}


 S3799C15_nt ::~S3799C15_nt(){ note_dtor("S3799C15_nt", this);}
void  S3799C15_nt ::v6(){vfunc_called(this, "_ZN11S3799C15_nt2v6Ev");}
void  S3799C15_nt ::v7(){vfunc_called(this, "_ZN11S3799C15_nt2v7Ev");}
void  S3799C15_nt ::v8(){vfunc_called(this, "_ZN11S3799C15_nt2v8Ev");}
void  S3799C15_nt ::v9(){vfunc_called(this, "_ZN11S3799C15_nt2v9Ev");}
S3799C15_nt ::S3799C15_nt(){ note_ctor("S3799C15_nt", this);} // tgen

//skip512 S3799C15_nt

#else // __cplusplus

extern void _ZN11S3799C15_ntC1Ev();
extern void _ZN11S3799C15_ntD1Ev();
Name_Map name_map_S3799C15_nt[] = {
  NSPAIR(_ZN11S3799C15_ntC1Ev),
  NSPAIR(_ZN11S3799C15_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S3799C15_nt[];
extern void _ZN11S3799C15_ntD1Ev();
extern void _ZN11S3799C15_ntD0Ev();
extern void _ZN11S3799C15_nt2v6Ev();
extern void _ZN11S3799C15_nt2v7Ev();
extern void _ZN11S3799C15_nt2v8Ev();
extern void _ZN11S3799C15_nt2v9Ev();
static  VTBL_ENTRY vtc_S3799C15_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S3799C15_nt[0]),
  (VTBL_ENTRY)&_ZN11S3799C15_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S3799C15_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S3799C15_nt2v6Ev,
  (VTBL_ENTRY)&_ZN11S3799C15_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S3799C15_nt2v8Ev,
  (VTBL_ENTRY)&_ZN11S3799C15_nt2v9Ev,
};
extern VTBL_ENTRY _ZTI11S3799C15_nt[];
VTBL_ENTRY *P__ZTI11S3799C15_nt = _ZTI11S3799C15_nt; 
extern  VTBL_ENTRY _ZTV11S3799C15_nt[];
Class_Descriptor cd_S3799C15_nt = {  "S3799C15_nt", // class name
  0,0,//no base classes
  &(vtc_S3799C15_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S3799C15_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S3799C15_nt),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3799C16  {
  ::S2122C5_nt s3799c16f0;
  ::S2122C26 s3799c16f1;
  void  mf3799c16(); // _ZN8S3799C169mf3799c16Ev
  virtual  ~S3799C16(); // _ZN8S3799C16D1Ev
  S3799C16(); // tgen
};
//SIG(-1 S3799C16) C1{ vd m FC2{ BC3{ m Fp Fi FC4{ m} FC4}} FC5{ m Fp Fi FC6{ m} FC7{ m}}}


void  S3799C16 ::mf3799c16(){}
 S3799C16 ::~S3799C16(){ note_dtor("S3799C16", this);}
S3799C16 ::S3799C16(){ note_ctor("S3799C16", this);} // tgen

static void Test_S3799C16()
{
  extern Class_Descriptor cd_S3799C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_S3799C16, buf);
    S3799C16 *dp, &lv = *(dp=new (buf) S3799C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S3799C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3799C16)");
    check_field_offset(lv, s3799c16f0, ABISELECT(8,4), "S3799C16.s3799c16f0");
    check_field_offset(lv, s3799c16f1, ABISELECT(24,16), "S3799C16.s3799c16f1");
    test_class_info(&lv, &cd_S3799C16);
    dp->~S3799C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3799C16(Test_S3799C16, "S3799C16", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN8S3799C16C1Ev();
extern void _ZN8S3799C16D1Ev();
Name_Map name_map_S3799C16[] = {
  NSPAIR(_ZN8S3799C16C1Ev),
  NSPAIR(_ZN8S3799C16D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S3799C16[];
extern void _ZN8S3799C16D1Ev();
extern void _ZN8S3799C16D0Ev();
static  VTBL_ENTRY vtc_S3799C16[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S3799C16[0]),
  (VTBL_ENTRY)&_ZN8S3799C16D1Ev,
  (VTBL_ENTRY)&_ZN8S3799C16D0Ev,
};
extern VTBL_ENTRY _ZTI8S3799C16[];
extern  VTBL_ENTRY _ZTV8S3799C16[];
Class_Descriptor cd_S3799C16 = {  "S3799C16", // class name
  0,0,//no base classes
  &(vtc_S3799C16[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI8S3799C16),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S3799C16),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3799C14  : S3799C15_nt {
  __tsi64 s3799c14f0;
  ::S3799C16 s3799c14f1;
  void *s3799c14f2;
  virtual  ~S3799C14(); // _ZN8S3799C14D1Ev
  S3799C14(); // tgen
};
//SIG(-1 S3799C14) C1{ BC2{ vd v1 v2 v3 v4} vd FL FC3{ vd m FC4{ BC5{ m Fp Fi FC6{ m} FC6}} FC7{ m Fp Fi FC8{ m} FC9{ m}}} Fp}


 S3799C14 ::~S3799C14(){ note_dtor("S3799C14", this);}
S3799C14 ::S3799C14(){ note_ctor("S3799C14", this);} // tgen

static void Test_S3799C14()
{
  extern Class_Descriptor cd_S3799C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,12)];
    init_test(&cd_S3799C14, buf);
    S3799C14 *dp, &lv = *(dp=new (buf) S3799C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,44), "sizeof(S3799C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3799C14)");
    check_base_class_offset(lv, (S3799C15_nt*), 0, "S3799C14");
    check_field_offset(lv, s3799c14f0, ABISELECT(8,4), "S3799C14.s3799c14f0");
    check_field_offset(lv, s3799c14f1, ABISELECT(16,12), "S3799C14.s3799c14f1");
    check_field_offset(lv, s3799c14f2, ABISELECT(56,40), "S3799C14.s3799c14f2");
    test_class_info(&lv, &cd_S3799C14);
    dp->~S3799C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3799C14(Test_S3799C14, "S3799C14", ABISELECT(64,44));

#else // __cplusplus

extern void _ZN8S3799C14C1Ev();
extern void _ZN8S3799C14D1Ev();
Name_Map name_map_S3799C14[] = {
  NSPAIR(_ZN8S3799C14C1Ev),
  NSPAIR(_ZN8S3799C14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3799C15_nt;
extern VTBL_ENTRY _ZTI11S3799C15_nt[];
extern  VTBL_ENTRY _ZTV11S3799C15_nt[];
static Base_Class bases_S3799C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3799C15_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S3799C14[];
extern void _ZN8S3799C14D1Ev();
extern void _ZN8S3799C14D0Ev();
extern void _ZN11S3799C15_nt2v6Ev();
extern void _ZN11S3799C15_nt2v7Ev();
extern void _ZN11S3799C15_nt2v8Ev();
extern void _ZN11S3799C15_nt2v9Ev();
static  VTBL_ENTRY vtc_S3799C14[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S3799C14[0]),
  (VTBL_ENTRY)&_ZN8S3799C14D1Ev,
  (VTBL_ENTRY)&_ZN8S3799C14D0Ev,
  (VTBL_ENTRY)&_ZN11S3799C15_nt2v6Ev,
  (VTBL_ENTRY)&_ZN11S3799C15_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S3799C15_nt2v8Ev,
  (VTBL_ENTRY)&_ZN11S3799C15_nt2v9Ev,
};
extern VTBL_ENTRY _ZTI8S3799C14[];
extern  VTBL_ENTRY _ZTV8S3799C14[];
Class_Descriptor cd_S3799C14 = {  "S3799C14", // class name
  bases_S3799C14, 1,
  &(vtc_S3799C14[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,44), // object size
  NSPAIRA(_ZTI8S3799C14),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S3799C14),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3799C13  : S3799C14 {
  virtual  ~S3799C13(); // _ZN8S3799C13D1Ev
  virtual void  v2(); // _ZN8S3799C132v2Ev
  virtual void  v3(); // _ZN8S3799C132v3Ev
  virtual void  v4(); // _ZN8S3799C132v4Ev
  virtual void  v5(); // _ZN8S3799C132v5Ev
  S3799C13(); // tgen
};
//SIG(-1 S3799C13) C1{ BC2{ BC3{ vd v5 v6 v7 v8} vd FL FC4{ vd m FC5{ BC6{ m Fp Fi FC7{ m} FC7}} FC8{ m Fp Fi FC9{ m} FC10{ m}}} Fp} vd v1 v2 v3 v4}


 S3799C13 ::~S3799C13(){ note_dtor("S3799C13", this);}
void  S3799C13 ::v2(){vfunc_called(this, "_ZN8S3799C132v2Ev");}
void  S3799C13 ::v3(){vfunc_called(this, "_ZN8S3799C132v3Ev");}
void  S3799C13 ::v4(){vfunc_called(this, "_ZN8S3799C132v4Ev");}
void  S3799C13 ::v5(){vfunc_called(this, "_ZN8S3799C132v5Ev");}
S3799C13 ::S3799C13(){ note_ctor("S3799C13", this);} // tgen

static void Test_S3799C13()
{
  extern Class_Descriptor cd_S3799C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,12)];
    init_test(&cd_S3799C13, buf);
    S3799C13 *dp, &lv = *(dp=new (buf) S3799C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,44), "sizeof(S3799C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3799C13)");
    check_base_class_offset(lv, (S3799C15_nt*)(S3799C14*), 0, "S3799C13");
    check_base_class_offset(lv, (S3799C14*), 0, "S3799C13");
    test_class_info(&lv, &cd_S3799C13);
    dp->~S3799C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3799C13(Test_S3799C13, "S3799C13", ABISELECT(64,44));

#else // __cplusplus

extern void _ZN8S3799C13C1Ev();
extern void _ZN8S3799C13D1Ev();
Name_Map name_map_S3799C13[] = {
  NSPAIR(_ZN8S3799C13C1Ev),
  NSPAIR(_ZN8S3799C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3799C15_nt;
extern VTBL_ENTRY _ZTI11S3799C15_nt[];
extern  VTBL_ENTRY _ZTV11S3799C15_nt[];
extern Class_Descriptor cd_S3799C14;
extern VTBL_ENTRY _ZTI8S3799C14[];
extern  VTBL_ENTRY _ZTV8S3799C14[];
static Base_Class bases_S3799C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3799C15_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3799C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S3799C13[];
extern void _ZN8S3799C13D1Ev();
extern void _ZN8S3799C13D0Ev();
extern void _ZN11S3799C15_nt2v6Ev();
extern void _ZN11S3799C15_nt2v7Ev();
extern void _ZN11S3799C15_nt2v8Ev();
extern void _ZN11S3799C15_nt2v9Ev();
extern void _ZN8S3799C132v2Ev();
extern void _ZN8S3799C132v3Ev();
extern void _ZN8S3799C132v4Ev();
extern void _ZN8S3799C132v5Ev();
static  VTBL_ENTRY vtc_S3799C13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S3799C13[0]),
  (VTBL_ENTRY)&_ZN8S3799C13D1Ev,
  (VTBL_ENTRY)&_ZN8S3799C13D0Ev,
  (VTBL_ENTRY)&_ZN11S3799C15_nt2v6Ev,
  (VTBL_ENTRY)&_ZN11S3799C15_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S3799C15_nt2v8Ev,
  (VTBL_ENTRY)&_ZN11S3799C15_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S3799C132v2Ev,
  (VTBL_ENTRY)&_ZN8S3799C132v3Ev,
  (VTBL_ENTRY)&_ZN8S3799C132v4Ev,
  (VTBL_ENTRY)&_ZN8S3799C132v5Ev,
};
extern VTBL_ENTRY _ZTI8S3799C13[];
extern  VTBL_ENTRY _ZTV8S3799C13[];
Class_Descriptor cd_S3799C13 = {  "S3799C13", // class name
  bases_S3799C13, 2,
  &(vtc_S3799C13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,44), // object size
  NSPAIRA(_ZTI8S3799C13),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S3799C13),12, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3799C25_nt  {
  long s3799c25f0[4];
};
//SIG(-1 S3799C25_nt) C1{ Fl[4]}



//skip512 S3799C25_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3799C24_nt  {
  ::S3799C25_nt s3799c24f0;
  void  mf3799c24(); // _ZN11S3799C24_nt9mf3799c24Ev
};
//SIG(-1 S3799C24_nt) C1{ m FC2{ Fl[4]}}


void  S3799C24_nt ::mf3799c24(){}

//skip512 S3799C24_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3799C29_nt  {
  virtual  ~S3799C29_nt(); // _ZN11S3799C29_ntD1Ev
  virtual void  v11(); // _ZN11S3799C29_nt3v11Ev
  virtual void  v12(); // _ZN11S3799C29_nt3v12Ev
  virtual void  v13(); // _ZN11S3799C29_nt3v13Ev
  virtual void  v14(); // _ZN11S3799C29_nt3v14Ev
  virtual void  v15(); // _ZN11S3799C29_nt3v15Ev
  virtual void  v16(); // _ZN11S3799C29_nt3v16Ev
  S3799C29_nt(); // tgen
};
//SIG(-1 S3799C29_nt) C1{ vd v1 v2 v3 v4 v5 v6}


 S3799C29_nt ::~S3799C29_nt(){ note_dtor("S3799C29_nt", this);}
void  S3799C29_nt ::v11(){vfunc_called(this, "_ZN11S3799C29_nt3v11Ev");}
void  S3799C29_nt ::v12(){vfunc_called(this, "_ZN11S3799C29_nt3v12Ev");}
void  S3799C29_nt ::v13(){vfunc_called(this, "_ZN11S3799C29_nt3v13Ev");}
void  S3799C29_nt ::v14(){vfunc_called(this, "_ZN11S3799C29_nt3v14Ev");}
void  S3799C29_nt ::v15(){vfunc_called(this, "_ZN11S3799C29_nt3v15Ev");}
void  S3799C29_nt ::v16(){vfunc_called(this, "_ZN11S3799C29_nt3v16Ev");}
S3799C29_nt ::S3799C29_nt(){ note_ctor("S3799C29_nt", this);} // tgen

//skip512 S3799C29_nt

#else // __cplusplus

extern void _ZN11S3799C29_ntC1Ev();
extern void _ZN11S3799C29_ntD1Ev();
Name_Map name_map_S3799C29_nt[] = {
  NSPAIR(_ZN11S3799C29_ntC1Ev),
  NSPAIR(_ZN11S3799C29_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S3799C29_nt[];
extern void _ZN11S3799C29_ntD1Ev();
extern void _ZN11S3799C29_ntD0Ev();
extern void _ZN11S3799C29_nt3v11Ev();
extern void _ZN11S3799C29_nt3v12Ev();
extern void _ZN11S3799C29_nt3v13Ev();
extern void _ZN11S3799C29_nt3v14Ev();
extern void _ZN11S3799C29_nt3v15Ev();
extern void _ZN11S3799C29_nt3v16Ev();
static  VTBL_ENTRY vtc_S3799C29_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S3799C29_nt[0]),
  (VTBL_ENTRY)&_ZN11S3799C29_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S3799C29_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S3799C29_nt3v11Ev,
  (VTBL_ENTRY)&_ZN11S3799C29_nt3v12Ev,
  (VTBL_ENTRY)&_ZN11S3799C29_nt3v13Ev,
  (VTBL_ENTRY)&_ZN11S3799C29_nt3v14Ev,
  (VTBL_ENTRY)&_ZN11S3799C29_nt3v15Ev,
  (VTBL_ENTRY)&_ZN11S3799C29_nt3v16Ev,
};
extern VTBL_ENTRY _ZTI11S3799C29_nt[];
VTBL_ENTRY *P__ZTI11S3799C29_nt = _ZTI11S3799C29_nt; 
extern  VTBL_ENTRY _ZTV11S3799C29_nt[];
Class_Descriptor cd_S3799C29_nt = {  "S3799C29_nt", // class name
  0,0,//no base classes
  &(vtc_S3799C29_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S3799C29_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S3799C29_nt),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3799C30  {
  void *s3799c30f0;
  void  mf3799c30(); // _ZN8S3799C309mf3799c30Ev
};
//SIG(-1 S3799C30) C1{ m Fp}


void  S3799C30 ::mf3799c30(){}

static void Test_S3799C30()
{
  {
    init_simple_test("S3799C30");
    S3799C30 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S3799C30)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3799C30)");
    check_field_offset(lv, s3799c30f0, 0, "S3799C30.s3799c30f0");
  }
}
static Arrange_To_Call_Me vS3799C30(Test_S3799C30, "S3799C30", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3799C28  : S3799C29_nt {
  void *s3799c28f0;
  ::S3799C30 s3799c28f1;
  ::S3799C24_nt s3799c28f2;
  char s3799c28f3;
  int s3799c28f4;
  virtual  ~S3799C28(); // _ZN8S3799C28D1Ev
  virtual void  v17(); // _ZN8S3799C283v17Ev
  virtual void  v18(); // _ZN8S3799C283v18Ev
  virtual void  v19(); // _ZN8S3799C283v19Ev
  virtual void  v20(); // _ZN8S3799C283v20Ev
  S3799C28(); // tgen
};
//SIG(-1 S3799C28) C1{ BC2{ vd v5 v6 v7 v8 v9 v10} vd v1 v2 v3 v4 Fp FC3{ m Fp} FC4{ m FC5{ Fl[4]}} Fc Fi}


 S3799C28 ::~S3799C28(){ note_dtor("S3799C28", this);}
void  S3799C28 ::v17(){vfunc_called(this, "_ZN8S3799C283v17Ev");}
void  S3799C28 ::v18(){vfunc_called(this, "_ZN8S3799C283v18Ev");}
void  S3799C28 ::v19(){vfunc_called(this, "_ZN8S3799C283v19Ev");}
void  S3799C28 ::v20(){vfunc_called(this, "_ZN8S3799C283v20Ev");}
S3799C28 ::S3799C28(){ note_ctor("S3799C28", this);} // tgen

static void Test_S3799C28()
{
  extern Class_Descriptor cd_S3799C28;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_S3799C28, buf);
    S3799C28 *dp, &lv = *(dp=new (buf) S3799C28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(S3799C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3799C28)");
    check_base_class_offset(lv, (S3799C29_nt*), 0, "S3799C28");
    check_field_offset(lv, s3799c28f0, ABISELECT(8,4), "S3799C28.s3799c28f0");
    check_field_offset(lv, s3799c28f1, ABISELECT(16,8), "S3799C28.s3799c28f1");
    check_field_offset(lv, s3799c28f2, ABISELECT(24,12), "S3799C28.s3799c28f2");
    check_field_offset(lv, s3799c28f3, ABISELECT(56,28), "S3799C28.s3799c28f3");
    check_field_offset(lv, s3799c28f4, ABISELECT(60,32), "S3799C28.s3799c28f4");
    test_class_info(&lv, &cd_S3799C28);
    dp->~S3799C28();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3799C28(Test_S3799C28, "S3799C28", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN8S3799C28C1Ev();
extern void _ZN8S3799C28D1Ev();
Name_Map name_map_S3799C28[] = {
  NSPAIR(_ZN8S3799C28C1Ev),
  NSPAIR(_ZN8S3799C28D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3799C29_nt;
extern VTBL_ENTRY _ZTI11S3799C29_nt[];
extern  VTBL_ENTRY _ZTV11S3799C29_nt[];
static Base_Class bases_S3799C28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3799C29_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S3799C28[];
extern void _ZN8S3799C28D1Ev();
extern void _ZN8S3799C28D0Ev();
extern void _ZN11S3799C29_nt3v11Ev();
extern void _ZN11S3799C29_nt3v12Ev();
extern void _ZN11S3799C29_nt3v13Ev();
extern void _ZN11S3799C29_nt3v14Ev();
extern void _ZN11S3799C29_nt3v15Ev();
extern void _ZN11S3799C29_nt3v16Ev();
extern void _ZN8S3799C283v17Ev();
extern void _ZN8S3799C283v18Ev();
extern void _ZN8S3799C283v19Ev();
extern void _ZN8S3799C283v20Ev();
static  VTBL_ENTRY vtc_S3799C28[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S3799C28[0]),
  (VTBL_ENTRY)&_ZN8S3799C28D1Ev,
  (VTBL_ENTRY)&_ZN8S3799C28D0Ev,
  (VTBL_ENTRY)&_ZN11S3799C29_nt3v11Ev,
  (VTBL_ENTRY)&_ZN11S3799C29_nt3v12Ev,
  (VTBL_ENTRY)&_ZN11S3799C29_nt3v13Ev,
  (VTBL_ENTRY)&_ZN11S3799C29_nt3v14Ev,
  (VTBL_ENTRY)&_ZN11S3799C29_nt3v15Ev,
  (VTBL_ENTRY)&_ZN11S3799C29_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S3799C283v17Ev,
  (VTBL_ENTRY)&_ZN8S3799C283v18Ev,
  (VTBL_ENTRY)&_ZN8S3799C283v19Ev,
  (VTBL_ENTRY)&_ZN8S3799C283v20Ev,
};
extern VTBL_ENTRY _ZTI8S3799C28[];
extern  VTBL_ENTRY _ZTV8S3799C28[];
Class_Descriptor cd_S3799C28 = {  "S3799C28", // class name
  bases_S3799C28, 1,
  &(vtc_S3799C28[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI8S3799C28),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S3799C28),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3799C31  {
  void *s3799c31f0;
  int s3799c31f1[2];
  ::S3799C30 s3799c31f2;
  void  mf3799c31(); // _ZN8S3799C319mf3799c31Ev
};
//SIG(-1 S3799C31) C1{ m Fp Fi[2] FC2{ m Fp}}


void  S3799C31 ::mf3799c31(){}

static void Test_S3799C31()
{
  {
    init_simple_test("S3799C31");
    S3799C31 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S3799C31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3799C31)");
    check_field_offset(lv, s3799c31f0, 0, "S3799C31.s3799c31f0");
    check_field_offset(lv, s3799c31f1, ABISELECT(8,4), "S3799C31.s3799c31f1");
    check_field_offset(lv, s3799c31f2, ABISELECT(16,12), "S3799C31.s3799c31f2");
  }
}
static Arrange_To_Call_Me vS3799C31(Test_S3799C31, "S3799C31", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3799C27  : S3799C28 {
  int s3799c27f0;
  ::S3799C31 s3799c27f1;
  ::S2122C20_nt s3799c27f2;
  ::S2122C20_nt s3799c27f3;
  virtual  ~S3799C27(); // _ZN8S3799C27D1Ev
  virtual void  v10(); // _ZN8S3799C273v10Ev
  S3799C27(); // tgen
};
//SIG(-1 S3799C27) C1{ BC2{ BC3{ vd v2 v3 v4 v5 v6 v7} vd v8 v9 v10 v11 Fp FC4{ m Fp} FC5{ m FC6{ Fl[4]}} Fc Fi} vd v1 Fi FC7{ m Fp Fi[2] FC4} FC8{ m Fp Fi FC9{ m}} FC8}


 S3799C27 ::~S3799C27(){ note_dtor("S3799C27", this);}
void  S3799C27 ::v10(){vfunc_called(this, "_ZN8S3799C273v10Ev");}
S3799C27 ::S3799C27(){ note_ctor("S3799C27", this);} // tgen

static void Test_S3799C27()
{
  extern Class_Descriptor cd_S3799C27;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(17,21)];
    init_test(&cd_S3799C27, buf);
    S3799C27 *dp, &lv = *(dp=new (buf) S3799C27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,80), "sizeof(S3799C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3799C27)");
    check_base_class_offset(lv, (S3799C29_nt*)(S3799C28*), 0, "S3799C27");
    check_base_class_offset(lv, (S3799C28*), 0, "S3799C27");
    check_field_offset(lv, s3799c27f0, ABISELECT(64,36), "S3799C27.s3799c27f0");
    check_field_offset(lv, s3799c27f1, ABISELECT(72,40), "S3799C27.s3799c27f1");
    check_field_offset(lv, s3799c27f2, ABISELECT(96,56), "S3799C27.s3799c27f2");
    check_field_offset(lv, s3799c27f3, ABISELECT(112,68), "S3799C27.s3799c27f3");
    test_class_info(&lv, &cd_S3799C27);
    dp->~S3799C27();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3799C27(Test_S3799C27, "S3799C27", ABISELECT(128,80));

#else // __cplusplus

extern void _ZN8S3799C27C1Ev();
extern void _ZN8S3799C27D1Ev();
Name_Map name_map_S3799C27[] = {
  NSPAIR(_ZN8S3799C27C1Ev),
  NSPAIR(_ZN8S3799C27D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3799C29_nt;
extern VTBL_ENTRY _ZTI11S3799C29_nt[];
extern  VTBL_ENTRY _ZTV11S3799C29_nt[];
extern Class_Descriptor cd_S3799C28;
extern VTBL_ENTRY _ZTI8S3799C28[];
extern  VTBL_ENTRY _ZTV8S3799C28[];
static Base_Class bases_S3799C27[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3799C29_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3799C28,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S3799C27[];
extern void _ZN8S3799C27D1Ev();
extern void _ZN8S3799C27D0Ev();
extern void _ZN11S3799C29_nt3v11Ev();
extern void _ZN11S3799C29_nt3v12Ev();
extern void _ZN11S3799C29_nt3v13Ev();
extern void _ZN11S3799C29_nt3v14Ev();
extern void _ZN11S3799C29_nt3v15Ev();
extern void _ZN11S3799C29_nt3v16Ev();
extern void _ZN8S3799C283v17Ev();
extern void _ZN8S3799C283v18Ev();
extern void _ZN8S3799C283v19Ev();
extern void _ZN8S3799C283v20Ev();
extern void _ZN8S3799C273v10Ev();
static  VTBL_ENTRY vtc_S3799C27[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S3799C27[0]),
  (VTBL_ENTRY)&_ZN8S3799C27D1Ev,
  (VTBL_ENTRY)&_ZN8S3799C27D0Ev,
  (VTBL_ENTRY)&_ZN11S3799C29_nt3v11Ev,
  (VTBL_ENTRY)&_ZN11S3799C29_nt3v12Ev,
  (VTBL_ENTRY)&_ZN11S3799C29_nt3v13Ev,
  (VTBL_ENTRY)&_ZN11S3799C29_nt3v14Ev,
  (VTBL_ENTRY)&_ZN11S3799C29_nt3v15Ev,
  (VTBL_ENTRY)&_ZN11S3799C29_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S3799C283v17Ev,
  (VTBL_ENTRY)&_ZN8S3799C283v18Ev,
  (VTBL_ENTRY)&_ZN8S3799C283v19Ev,
  (VTBL_ENTRY)&_ZN8S3799C283v20Ev,
  (VTBL_ENTRY)&_ZN8S3799C273v10Ev,
};
extern VTBL_ENTRY _ZTI8S3799C27[];
extern  VTBL_ENTRY _ZTV8S3799C27[];
Class_Descriptor cd_S3799C27 = {  "S3799C27", // class name
  bases_S3799C27, 2,
  &(vtc_S3799C27[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(128,80), // object size
  NSPAIRA(_ZTI8S3799C27),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S3799C27),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3799C34_nt  {
  char s3799c34f0[20];
};
//SIG(-1 S3799C34_nt) C1{ Fc[20]}



//skip512 S3799C34_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3799C33_nt  {
  ::S3799C34_nt s3799c33f0;
  char s3799c33f1[16];
};
//SIG(-1 S3799C33_nt) C1{ FC2{ Fc[20]} Fc[16]}



//skip512 S3799C33_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3799C36_nt  {
  char s3799c36f0[12];
};
//SIG(-1 S3799C36_nt) C1{ Fc[12]}



//skip512 S3799C36_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3799C37  {
  void *s3799c37f0;
  void  mf3799c37(); // _ZN8S3799C379mf3799c37Ev
};
//SIG(-1 S3799C37) C1{ m Fp}


void  S3799C37 ::mf3799c37(){}

static void Test_S3799C37()
{
  {
    init_simple_test("S3799C37");
    S3799C37 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S3799C37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3799C37)");
    check_field_offset(lv, s3799c37f0, 0, "S3799C37.s3799c37f0");
  }
}
static Arrange_To_Call_Me vS3799C37(Test_S3799C37, "S3799C37", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3799C23  : S3799C3_nt {
  ::S3799C24_nt s3799c23f0;
  ::S3799C6_nt s3799c23f1;
  ::S3799C6_nt s3799c23f2;
  ::S3799C27 s3799c23f3;
  ::S3799C27 s3799c23f4;
  void *s3799c23f5;
  ::S3799C27 s3799c23f6;
  ::S3799C27 s3799c23f7;
  ::S3799C27 s3799c23f8;
  char s3799c23f9;
  ::S3799C33_nt s3799c23f10;
  ::S2122C20_nt s3799c23f11;
  ::S2122C20_nt s3799c23f12;
  int s3799c23f13;
  __tsi64 s3799c23f14;
  ::S2122C20_nt s3799c23f15;
  ::S2122C28 s3799c23f16;
  ::S2122C20_nt s3799c23f17;
  int s3799c23f18[4];
  ::S2122C20_nt s3799c23f19;
  char s3799c23f20;
  int s3799c23f21[2];
  ::S2122C20_nt s3799c23f22;
  ::S3799C36_nt s3799c23f23;
  ::S3799C36_nt s3799c23f24;
  ::S2122C20_nt s3799c23f25;
  char s3799c23f26;
  ::S2122C20_nt s3799c23f27;
  ::S2122C20_nt s3799c23f28;
  ::S2122C20_nt s3799c23f29;
  int s3799c23f30[2];
  ::S3799C6_nt s3799c23f31;
  ::S3799C6_nt s3799c23f32;
  ::S3799C6_nt s3799c23f33;
  ::S3799C37 s3799c23f34;
  virtual  ~S3799C23(); // _ZN8S3799C23D1Ev
  S3799C23(); // tgen
};
//SIG(-1 S3799C23) C1{ BC2{ vd m Fi} vd FC3{ m FC4{ Fl[4]}} FC5{ m Fp} FC5 FC6{ BC7{ BC8{ vd v2 v3 v4 v5 v6 v7} vd v8 v9 v10 v11 Fp FC9{ m Fp} FC3 Fc Fi} vd v1 Fi FC10{ m Fp Fi[2] FC9} FC11{ m Fp Fi FC12{ m}} FC11} FC6 Fp FC6 FC6 FC6 Fc FC13{ FC14{ Fc[20]} Fc[16]} FC11 FC11 Fi FL FC11 FC15{ m} FC11 Fi[4] FC11 Fc Fi[2] FC11 FC16{ Fc[12]} FC16 FC11 Fc FC11 FC11 FC11 Fi[2] FC5 FC5 FC5 FC17{ m Fp}}


 S3799C23 ::~S3799C23(){ note_dtor("S3799C23", this);}
S3799C23 ::S3799C23(){ note_ctor("S3799C23", this);} // tgen

static void Test_S3799C23()
{
  extern Class_Descriptor cd_S3799C23;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(131,174)];
    init_test(&cd_S3799C23, buf);
    S3799C23 *dp, &lv = *(dp=new (buf) S3799C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1040,692), "sizeof(S3799C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3799C23)");
    check_base_class_offset(lv, (S3799C3_nt*), 0, "S3799C23");
    check_field_offset(lv, s3799c23f0, ABISELECT(16,8), "S3799C23.s3799c23f0");
    check_field_offset(lv, s3799c23f1, ABISELECT(48,24), "S3799C23.s3799c23f1");
    check_field_offset(lv, s3799c23f2, ABISELECT(56,28), "S3799C23.s3799c23f2");
    check_field_offset(lv, s3799c23f3, ABISELECT(64,32), "S3799C23.s3799c23f3");
    check_field_offset(lv, s3799c23f4, ABISELECT(192,112), "S3799C23.s3799c23f4");
    check_field_offset(lv, s3799c23f5, ABISELECT(320,192), "S3799C23.s3799c23f5");
    check_field_offset(lv, s3799c23f6, ABISELECT(328,196), "S3799C23.s3799c23f6");
    check_field_offset(lv, s3799c23f7, ABISELECT(456,276), "S3799C23.s3799c23f7");
    check_field_offset(lv, s3799c23f8, ABISELECT(584,356), "S3799C23.s3799c23f8");
    check_field_offset(lv, s3799c23f9, ABISELECT(712,436), "S3799C23.s3799c23f9");
    check_field_offset(lv, s3799c23f10, ABISELECT(713,437), "S3799C23.s3799c23f10");
    check_field_offset(lv, s3799c23f11, ABISELECT(752,476), "S3799C23.s3799c23f11");
    check_field_offset(lv, s3799c23f12, ABISELECT(768,488), "S3799C23.s3799c23f12");
    check_field_offset(lv, s3799c23f13, ABISELECT(784,500), "S3799C23.s3799c23f13");
    check_field_offset(lv, s3799c23f14, ABISELECT(792,504), "S3799C23.s3799c23f14");
    check_field_offset(lv, s3799c23f15, ABISELECT(800,512), "S3799C23.s3799c23f15");
    check_field_offset(lv, s3799c23f16, ABISELECT(816,524), "S3799C23.s3799c23f16");
    check_field_offset(lv, s3799c23f17, ABISELECT(824,528), "S3799C23.s3799c23f17");
    check_field_offset(lv, s3799c23f18, ABISELECT(840,540), "S3799C23.s3799c23f18");
    check_field_offset(lv, s3799c23f19, ABISELECT(856,556), "S3799C23.s3799c23f19");
    check_field_offset(lv, s3799c23f20, ABISELECT(872,568), "S3799C23.s3799c23f20");
    check_field_offset(lv, s3799c23f21, ABISELECT(876,572), "S3799C23.s3799c23f21");
    check_field_offset(lv, s3799c23f22, ABISELECT(888,580), "S3799C23.s3799c23f22");
    check_field_offset(lv, s3799c23f23, ABISELECT(904,592), "S3799C23.s3799c23f23");
    check_field_offset(lv, s3799c23f24, ABISELECT(916,604), "S3799C23.s3799c23f24");
    check_field_offset(lv, s3799c23f25, ABISELECT(928,616), "S3799C23.s3799c23f25");
    check_field_offset(lv, s3799c23f26, ABISELECT(944,628), "S3799C23.s3799c23f26");
    check_field_offset(lv, s3799c23f27, ABISELECT(952,632), "S3799C23.s3799c23f27");
    check_field_offset(lv, s3799c23f28, ABISELECT(968,644), "S3799C23.s3799c23f28");
    check_field_offset(lv, s3799c23f29, ABISELECT(984,656), "S3799C23.s3799c23f29");
    check_field_offset(lv, s3799c23f30, ABISELECT(1000,668), "S3799C23.s3799c23f30");
    check_field_offset(lv, s3799c23f31, ABISELECT(1008,676), "S3799C23.s3799c23f31");
    check_field_offset(lv, s3799c23f32, ABISELECT(1016,680), "S3799C23.s3799c23f32");
    check_field_offset(lv, s3799c23f33, ABISELECT(1024,684), "S3799C23.s3799c23f33");
    check_field_offset(lv, s3799c23f34, ABISELECT(1032,688), "S3799C23.s3799c23f34");
    test_class_info(&lv, &cd_S3799C23);
    dp->~S3799C23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3799C23(Test_S3799C23, "S3799C23", ABISELECT(1040,692));

#else // __cplusplus

extern void _ZN8S3799C23C1Ev();
extern void _ZN8S3799C23D1Ev();
Name_Map name_map_S3799C23[] = {
  NSPAIR(_ZN8S3799C23C1Ev),
  NSPAIR(_ZN8S3799C23D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3799C3_nt;
extern VTBL_ENTRY _ZTI10S3799C3_nt[];
extern  VTBL_ENTRY _ZTV10S3799C3_nt[];
static Base_Class bases_S3799C23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3799C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S3799C23[];
extern void _ZN8S3799C23D1Ev();
extern void _ZN8S3799C23D0Ev();
static  VTBL_ENTRY vtc_S3799C23[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S3799C23[0]),
  (VTBL_ENTRY)&_ZN8S3799C23D1Ev,
  (VTBL_ENTRY)&_ZN8S3799C23D0Ev,
};
extern VTBL_ENTRY _ZTI8S3799C23[];
extern  VTBL_ENTRY _ZTV8S3799C23[];
Class_Descriptor cd_S3799C23 = {  "S3799C23", // class name
  bases_S3799C23, 1,
  &(vtc_S3799C23[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1040,692), // object size
  NSPAIRA(_ZTI8S3799C23),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S3799C23),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3799C1  : S3799C2 {
  void *s3799c1f0;
  ::S2122C25 s3799c1f1;
  ::S3799C13 s3799c1f2;
  ::S3799C23 s3799c1f3;
  virtual  ~S3799C1(); // _ZN7S3799C1D1Ev
  S3799C1(); // tgen
};
//SIG(1 S3799C1) C1{ BC2{ BC3{ vd m Fi} vd v1 Fp FL FC4{ m Fp Fi FC5{ m}} FC4 FC4 FC4 FC4 FC6{ m Fp} FC7{ m} FC4 FC8{ m Fs[6] Fi[2] Fc Fs} FC4 FC8 FC8} vd Fp FC9{ BC10{ m Fp Fi FC11{ m} FC12{ m}}} FC13{ BC14{ BC15{ vd v6 v7 v8 v9} vd FL FC16{ vd m FC17{ BC18{ m Fp Fi FC19{ m} FC19}} FC10} Fp} vd v2 v3 v4 v5} FC20{ BC3 vd FC21{ m FC22{ Fl[4]}} FC6 FC6 FC23{ BC24{ BC25{ vd v11 v12 v13 v14 v15 v16} vd v17 v18 v19 v20 Fp FC26{ m Fp} FC21 Fc Fi} vd v10 Fi FC27{ m Fp Fi[2] FC26} FC4 FC4} FC23 Fp FC23 FC23 FC23 Fc FC28{ FC29{ Fc[20]} Fc[16]} FC4 FC4 Fi FL FC4 FC12 FC4 Fi[4] FC4 Fc Fi[2] FC4 FC30{ Fc[12]} FC30 FC4 Fc FC4 FC4 FC4 Fi[2] FC6 FC6 FC6 FC31{ m Fp}}}


 S3799C1 ::~S3799C1(){ note_dtor("S3799C1", this);}
S3799C1 ::S3799C1(){ note_ctor("S3799C1", this);} // tgen

static void Test_S3799C1()
{
  extern Class_Descriptor cd_S3799C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(171,235)];
    init_test(&cd_S3799C1, buf);
    S3799C1 *dp, &lv = *(dp=new (buf) S3799C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1360,936), "sizeof(S3799C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3799C1)");
    check_base_class_offset(lv, (S3799C3_nt*)(S3799C2*), 0, "S3799C1");
    check_base_class_offset(lv, (S3799C2*), 0, "S3799C1");
    check_field_offset(lv, s3799c1f0, ABISELECT(232,184), "S3799C1.s3799c1f0");
    check_field_offset(lv, s3799c1f1, ABISELECT(240,188), "S3799C1.s3799c1f1");
    check_field_offset(lv, s3799c1f2, ABISELECT(256,200), "S3799C1.s3799c1f2");
    check_field_offset(lv, s3799c1f3, ABISELECT(320,244), "S3799C1.s3799c1f3");
    test_class_info(&lv, &cd_S3799C1);
    dp->~S3799C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3799C1(Test_S3799C1, "S3799C1", ABISELECT(1360,936));

#else // __cplusplus

extern void _ZN7S3799C1C1Ev();
extern void _ZN7S3799C1D1Ev();
Name_Map name_map_S3799C1[] = {
  NSPAIR(_ZN7S3799C1C1Ev),
  NSPAIR(_ZN7S3799C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3799C3_nt;
extern VTBL_ENTRY _ZTI10S3799C3_nt[];
extern  VTBL_ENTRY _ZTV10S3799C3_nt[];
extern Class_Descriptor cd_S3799C2;
extern VTBL_ENTRY _ZTI7S3799C2[];
extern  VTBL_ENTRY _ZTV7S3799C2[];
static Base_Class bases_S3799C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3799C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3799C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3799C1[];
extern void _ZN7S3799C1D1Ev();
extern void _ZN7S3799C1D0Ev();
extern void _ZN7S3799C22v1Ev();
static  VTBL_ENTRY vtc_S3799C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3799C1[0]),
  (VTBL_ENTRY)&_ZN7S3799C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3799C1D0Ev,
  (VTBL_ENTRY)&_ZN7S3799C22v1Ev,
};
extern VTBL_ENTRY _ZTI7S3799C1[];
extern  VTBL_ENTRY _ZTV7S3799C1[];
Class_Descriptor cd_S3799C1 = {  "S3799C1", // class name
  bases_S3799C1, 2,
  &(vtc_S3799C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1360,936), // object size
  NSPAIRA(_ZTI7S3799C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3799C1),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3802C2  : S3799C3_nt {
  void *s3802c2f0;
  __tsi64 s3802c2f1;
  ::S2122C20_nt s3802c2f2;
  ::S2122C20_nt s3802c2f3;
  ::S2122C20_nt s3802c2f4;
  ::S2122C20_nt s3802c2f5;
  ::S2122C20_nt s3802c2f6;
  ::S3799C37 s3802c2f7;
  ::S2122C38 s3802c2f8;
  ::S2122C20_nt s3802c2f9;
  ::S3799C8_nt s3802c2f10;
  ::S2122C20_nt s3802c2f11;
  ::S3799C8_nt s3802c2f12;
  ::S3799C8_nt s3802c2f13;
  virtual  ~S3802C2(); // _ZN7S3802C2D1Ev
  virtual void  v1(); // _ZN7S3802C22v1Ev
  S3802C2(); // tgen
};
//SIG(-1 S3802C2) C1{ BC2{ vd m Fi} vd v1 Fp FL FC3{ m Fp Fi FC4{ m}} FC3 FC3 FC3 FC3 FC5{ m Fp} FC6{ m} FC3 FC7{ m Fs[6] Fi[2] Fc Fs} FC3 FC7 FC7}


 S3802C2 ::~S3802C2(){ note_dtor("S3802C2", this);}
void  S3802C2 ::v1(){vfunc_called(this, "_ZN7S3802C22v1Ev");}
S3802C2 ::S3802C2(){ note_ctor("S3802C2", this);} // tgen

static void Test_S3802C2()
{
  extern Class_Descriptor cd_S3802C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(30,47)];
    init_test(&cd_S3802C2, buf);
    S3802C2 *dp, &lv = *(dp=new (buf) S3802C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(232,184), "sizeof(S3802C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3802C2)");
    check_base_class_offset(lv, (S3799C3_nt*), 0, "S3802C2");
    check_field_offset(lv, s3802c2f0, ABISELECT(16,8), "S3802C2.s3802c2f0");
    check_field_offset(lv, s3802c2f1, ABISELECT(24,12), "S3802C2.s3802c2f1");
    check_field_offset(lv, s3802c2f2, ABISELECT(32,20), "S3802C2.s3802c2f2");
    check_field_offset(lv, s3802c2f3, ABISELECT(48,32), "S3802C2.s3802c2f3");
    check_field_offset(lv, s3802c2f4, ABISELECT(64,44), "S3802C2.s3802c2f4");
    check_field_offset(lv, s3802c2f5, ABISELECT(80,56), "S3802C2.s3802c2f5");
    check_field_offset(lv, s3802c2f6, ABISELECT(96,68), "S3802C2.s3802c2f6");
    check_field_offset(lv, s3802c2f7, ABISELECT(112,80), "S3802C2.s3802c2f7");
    check_field_offset(lv, s3802c2f8, ABISELECT(120,84), "S3802C2.s3802c2f8");
    check_field_offset(lv, s3802c2f9, ABISELECT(128,88), "S3802C2.s3802c2f9");
    check_field_offset(lv, s3802c2f10, ABISELECT(144,100), "S3802C2.s3802c2f10");
    check_field_offset(lv, s3802c2f11, ABISELECT(168,124), "S3802C2.s3802c2f11");
    check_field_offset(lv, s3802c2f12, ABISELECT(184,136), "S3802C2.s3802c2f12");
    check_field_offset(lv, s3802c2f13, ABISELECT(208,160), "S3802C2.s3802c2f13");
    test_class_info(&lv, &cd_S3802C2);
    dp->~S3802C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3802C2(Test_S3802C2, "S3802C2", ABISELECT(232,184));

#else // __cplusplus

extern void _ZN7S3802C2C1Ev();
extern void _ZN7S3802C2D1Ev();
Name_Map name_map_S3802C2[] = {
  NSPAIR(_ZN7S3802C2C1Ev),
  NSPAIR(_ZN7S3802C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3799C3_nt;
extern VTBL_ENTRY _ZTI10S3799C3_nt[];
extern  VTBL_ENTRY _ZTV10S3799C3_nt[];
static Base_Class bases_S3802C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3799C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3802C2[];
extern void _ZN7S3802C2D1Ev();
extern void _ZN7S3802C2D0Ev();
extern void _ZN7S3802C22v1Ev();
static  VTBL_ENTRY vtc_S3802C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3802C2[0]),
  (VTBL_ENTRY)&_ZN7S3802C2D1Ev,
  (VTBL_ENTRY)&_ZN7S3802C2D0Ev,
  (VTBL_ENTRY)&_ZN7S3802C22v1Ev,
};
extern VTBL_ENTRY _ZTI7S3802C2[];
extern  VTBL_ENTRY _ZTV7S3802C2[];
Class_Descriptor cd_S3802C2 = {  "S3802C2", // class name
  bases_S3802C2, 1,
  &(vtc_S3802C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(232,184), // object size
  NSPAIRA(_ZTI7S3802C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3802C2),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3802C25_nt  {
  __tsi64 s3802c25f0[4];
};
//SIG(-1 S3802C25_nt) C1{ FL[4]}



//skip512 S3802C25_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3802C24_nt  {
  ::S3802C25_nt s3802c24f0;
  void  mf3802c24(); // _ZN11S3802C24_nt9mf3802c24Ev
};
//SIG(-1 S3802C24_nt) C1{ m FC2{ FL[4]}}


void  S3802C24_nt ::mf3802c24(){}

//skip512 S3802C24_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3802C29  {
  virtual  ~S3802C29(); // _ZN8S3802C29D1Ev
  virtual void  v11(); // _ZN8S3802C293v11Ev
  virtual void  v12(); // _ZN8S3802C293v12Ev
  virtual void  v13(); // _ZN8S3802C293v13Ev
  virtual void  v14(); // _ZN8S3802C293v14Ev
  virtual void  v15(); // _ZN8S3802C293v15Ev
  virtual void  v16(); // _ZN8S3802C293v16Ev
  S3802C29(); // tgen
};
//SIG(-1 S3802C29) C1{ vd v1 v2 v3 v4 v5 v6}


 S3802C29 ::~S3802C29(){ note_dtor("S3802C29", this);}
void  S3802C29 ::v11(){vfunc_called(this, "_ZN8S3802C293v11Ev");}
void  S3802C29 ::v12(){vfunc_called(this, "_ZN8S3802C293v12Ev");}
void  S3802C29 ::v13(){vfunc_called(this, "_ZN8S3802C293v13Ev");}
void  S3802C29 ::v14(){vfunc_called(this, "_ZN8S3802C293v14Ev");}
void  S3802C29 ::v15(){vfunc_called(this, "_ZN8S3802C293v15Ev");}
void  S3802C29 ::v16(){vfunc_called(this, "_ZN8S3802C293v16Ev");}
S3802C29 ::S3802C29(){ note_ctor("S3802C29", this);} // tgen

static void Test_S3802C29()
{
  extern Class_Descriptor cd_S3802C29;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S3802C29, buf);
    S3802C29 *dp, &lv = *(dp=new (buf) S3802C29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S3802C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3802C29)");
    test_class_info(&lv, &cd_S3802C29);
    dp->~S3802C29();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3802C29(Test_S3802C29, "S3802C29", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S3802C29C1Ev();
extern void _ZN8S3802C29D1Ev();
Name_Map name_map_S3802C29[] = {
  NSPAIR(_ZN8S3802C29C1Ev),
  NSPAIR(_ZN8S3802C29D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S3802C29[];
extern void _ZN8S3802C29D1Ev();
extern void _ZN8S3802C29D0Ev();
extern void _ZN8S3802C293v11Ev();
extern void _ZN8S3802C293v12Ev();
extern void _ZN8S3802C293v13Ev();
extern void _ZN8S3802C293v14Ev();
extern void _ZN8S3802C293v15Ev();
extern void _ZN8S3802C293v16Ev();
static  VTBL_ENTRY vtc_S3802C29[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S3802C29[0]),
  (VTBL_ENTRY)&_ZN8S3802C29D1Ev,
  (VTBL_ENTRY)&_ZN8S3802C29D0Ev,
  (VTBL_ENTRY)&_ZN8S3802C293v11Ev,
  (VTBL_ENTRY)&_ZN8S3802C293v12Ev,
  (VTBL_ENTRY)&_ZN8S3802C293v13Ev,
  (VTBL_ENTRY)&_ZN8S3802C293v14Ev,
  (VTBL_ENTRY)&_ZN8S3802C293v15Ev,
  (VTBL_ENTRY)&_ZN8S3802C293v16Ev,
};
extern VTBL_ENTRY _ZTI8S3802C29[];
extern  VTBL_ENTRY _ZTV8S3802C29[];
Class_Descriptor cd_S3802C29 = {  "S3802C29", // class name
  0,0,//no base classes
  &(vtc_S3802C29[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S3802C29),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S3802C29),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3802C28  : S3802C29 {
  void *s3802c28f0;
  ::S3799C6_nt s3802c28f1;
  ::S3802C24_nt s3802c28f2;
  char s3802c28f3;
  int s3802c28f4;
  virtual  ~S3802C28(); // _ZN8S3802C28D1Ev
  virtual void  v17(); // _ZN8S3802C283v17Ev
  virtual void  v18(); // _ZN8S3802C283v18Ev
  virtual void  v19(); // _ZN8S3802C283v19Ev
  virtual void  v20(); // _ZN8S3802C283v20Ev
  S3802C28(); // tgen
};
//SIG(-1 S3802C28) C1{ BC2{ vd v5 v6 v7 v8 v9 v10} vd v1 v2 v3 v4 Fp FC3{ m Fp} FC4{ m FC5{ FL[4]}} Fc Fi}


 S3802C28 ::~S3802C28(){ note_dtor("S3802C28", this);}
void  S3802C28 ::v17(){vfunc_called(this, "_ZN8S3802C283v17Ev");}
void  S3802C28 ::v18(){vfunc_called(this, "_ZN8S3802C283v18Ev");}
void  S3802C28 ::v19(){vfunc_called(this, "_ZN8S3802C283v19Ev");}
void  S3802C28 ::v20(){vfunc_called(this, "_ZN8S3802C283v20Ev");}
S3802C28 ::S3802C28(){ note_ctor("S3802C28", this);} // tgen

static void Test_S3802C28()
{
  extern Class_Descriptor cd_S3802C28;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,14)];
    init_test(&cd_S3802C28, buf);
    S3802C28 *dp, &lv = *(dp=new (buf) S3802C28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,52), "sizeof(S3802C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3802C28)");
    check_base_class_offset(lv, (S3802C29*), 0, "S3802C28");
    check_field_offset(lv, s3802c28f0, ABISELECT(8,4), "S3802C28.s3802c28f0");
    check_field_offset(lv, s3802c28f1, ABISELECT(16,8), "S3802C28.s3802c28f1");
    check_field_offset(lv, s3802c28f2, ABISELECT(24,12), "S3802C28.s3802c28f2");
    check_field_offset(lv, s3802c28f3, ABISELECT(56,44), "S3802C28.s3802c28f3");
    check_field_offset(lv, s3802c28f4, ABISELECT(60,48), "S3802C28.s3802c28f4");
    test_class_info(&lv, &cd_S3802C28);
    dp->~S3802C28();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3802C28(Test_S3802C28, "S3802C28", ABISELECT(64,52));

#else // __cplusplus

extern void _ZN8S3802C28C1Ev();
extern void _ZN8S3802C28D1Ev();
Name_Map name_map_S3802C28[] = {
  NSPAIR(_ZN8S3802C28C1Ev),
  NSPAIR(_ZN8S3802C28D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3802C29;
extern VTBL_ENTRY _ZTI8S3802C29[];
extern  VTBL_ENTRY _ZTV8S3802C29[];
static Base_Class bases_S3802C28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3802C29,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S3802C28[];
extern void _ZN8S3802C28D1Ev();
extern void _ZN8S3802C28D0Ev();
extern void _ZN8S3802C293v11Ev();
extern void _ZN8S3802C293v12Ev();
extern void _ZN8S3802C293v13Ev();
extern void _ZN8S3802C293v14Ev();
extern void _ZN8S3802C293v15Ev();
extern void _ZN8S3802C293v16Ev();
extern void _ZN8S3802C283v17Ev();
extern void _ZN8S3802C283v18Ev();
extern void _ZN8S3802C283v19Ev();
extern void _ZN8S3802C283v20Ev();
static  VTBL_ENTRY vtc_S3802C28[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S3802C28[0]),
  (VTBL_ENTRY)&_ZN8S3802C28D1Ev,
  (VTBL_ENTRY)&_ZN8S3802C28D0Ev,
  (VTBL_ENTRY)&_ZN8S3802C293v11Ev,
  (VTBL_ENTRY)&_ZN8S3802C293v12Ev,
  (VTBL_ENTRY)&_ZN8S3802C293v13Ev,
  (VTBL_ENTRY)&_ZN8S3802C293v14Ev,
  (VTBL_ENTRY)&_ZN8S3802C293v15Ev,
  (VTBL_ENTRY)&_ZN8S3802C293v16Ev,
  (VTBL_ENTRY)&_ZN8S3802C283v17Ev,
  (VTBL_ENTRY)&_ZN8S3802C283v18Ev,
  (VTBL_ENTRY)&_ZN8S3802C283v19Ev,
  (VTBL_ENTRY)&_ZN8S3802C283v20Ev,
};
extern VTBL_ENTRY _ZTI8S3802C28[];
extern  VTBL_ENTRY _ZTV8S3802C28[];
Class_Descriptor cd_S3802C28 = {  "S3802C28", // class name
  bases_S3802C28, 1,
  &(vtc_S3802C28[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,52), // object size
  NSPAIRA(_ZTI8S3802C28),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S3802C28),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3802C27  : S3802C28 {
  int s3802c27f0;
  ::S3799C31 s3802c27f1;
  ::S2122C20_nt s3802c27f2;
  ::S2122C20_nt s3802c27f3;
  virtual  ~S3802C27(); // _ZN8S3802C27D1Ev
  virtual void  v10(); // _ZN8S3802C273v10Ev
  S3802C27(); // tgen
};
//SIG(-1 S3802C27) C1{ BC2{ BC3{ vd v2 v3 v4 v5 v6 v7} vd v8 v9 v10 v11 Fp FC4{ m Fp} FC5{ m FC6{ FL[4]}} Fc Fi} vd v1 Fi FC7{ m Fp Fi[2] FC8{ m Fp}} FC9{ m Fp Fi FC10{ m}} FC9}


 S3802C27 ::~S3802C27(){ note_dtor("S3802C27", this);}
void  S3802C27 ::v10(){vfunc_called(this, "_ZN8S3802C273v10Ev");}
S3802C27 ::S3802C27(){ note_ctor("S3802C27", this);} // tgen

static void Test_S3802C27()
{
  extern Class_Descriptor cd_S3802C27;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(17,25)];
    init_test(&cd_S3802C27, buf);
    S3802C27 *dp, &lv = *(dp=new (buf) S3802C27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,96), "sizeof(S3802C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3802C27)");
    check_base_class_offset(lv, (S3802C29*)(S3802C28*), 0, "S3802C27");
    check_base_class_offset(lv, (S3802C28*), 0, "S3802C27");
    check_field_offset(lv, s3802c27f0, ABISELECT(64,52), "S3802C27.s3802c27f0");
    check_field_offset(lv, s3802c27f1, ABISELECT(72,56), "S3802C27.s3802c27f1");
    check_field_offset(lv, s3802c27f2, ABISELECT(96,72), "S3802C27.s3802c27f2");
    check_field_offset(lv, s3802c27f3, ABISELECT(112,84), "S3802C27.s3802c27f3");
    test_class_info(&lv, &cd_S3802C27);
    dp->~S3802C27();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3802C27(Test_S3802C27, "S3802C27", ABISELECT(128,96));

#else // __cplusplus

extern void _ZN8S3802C27C1Ev();
extern void _ZN8S3802C27D1Ev();
Name_Map name_map_S3802C27[] = {
  NSPAIR(_ZN8S3802C27C1Ev),
  NSPAIR(_ZN8S3802C27D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3802C29;
extern VTBL_ENTRY _ZTI8S3802C29[];
extern  VTBL_ENTRY _ZTV8S3802C29[];
extern Class_Descriptor cd_S3802C28;
extern VTBL_ENTRY _ZTI8S3802C28[];
extern  VTBL_ENTRY _ZTV8S3802C28[];
static Base_Class bases_S3802C27[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3802C29,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3802C28,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S3802C27[];
extern void _ZN8S3802C27D1Ev();
extern void _ZN8S3802C27D0Ev();
extern void _ZN8S3802C293v11Ev();
extern void _ZN8S3802C293v12Ev();
extern void _ZN8S3802C293v13Ev();
extern void _ZN8S3802C293v14Ev();
extern void _ZN8S3802C293v15Ev();
extern void _ZN8S3802C293v16Ev();
extern void _ZN8S3802C283v17Ev();
extern void _ZN8S3802C283v18Ev();
extern void _ZN8S3802C283v19Ev();
extern void _ZN8S3802C283v20Ev();
extern void _ZN8S3802C273v10Ev();
static  VTBL_ENTRY vtc_S3802C27[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S3802C27[0]),
  (VTBL_ENTRY)&_ZN8S3802C27D1Ev,
  (VTBL_ENTRY)&_ZN8S3802C27D0Ev,
  (VTBL_ENTRY)&_ZN8S3802C293v11Ev,
  (VTBL_ENTRY)&_ZN8S3802C293v12Ev,
  (VTBL_ENTRY)&_ZN8S3802C293v13Ev,
  (VTBL_ENTRY)&_ZN8S3802C293v14Ev,
  (VTBL_ENTRY)&_ZN8S3802C293v15Ev,
  (VTBL_ENTRY)&_ZN8S3802C293v16Ev,
  (VTBL_ENTRY)&_ZN8S3802C283v17Ev,
  (VTBL_ENTRY)&_ZN8S3802C283v18Ev,
  (VTBL_ENTRY)&_ZN8S3802C283v19Ev,
  (VTBL_ENTRY)&_ZN8S3802C283v20Ev,
  (VTBL_ENTRY)&_ZN8S3802C273v10Ev,
};
extern VTBL_ENTRY _ZTI8S3802C27[];
extern  VTBL_ENTRY _ZTV8S3802C27[];
Class_Descriptor cd_S3802C27 = {  "S3802C27", // class name
  bases_S3802C27, 2,
  &(vtc_S3802C27[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(128,96), // object size
  NSPAIRA(_ZTI8S3802C27),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S3802C27),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3802C37  {
  void *s3802c37f0;
  void  mf3802c37(); // _ZN8S3802C379mf3802c37Ev
};
//SIG(-1 S3802C37) C1{ m Fp}


void  S3802C37 ::mf3802c37(){}

static void Test_S3802C37()
{
  {
    init_simple_test("S3802C37");
    S3802C37 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S3802C37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3802C37)");
    check_field_offset(lv, s3802c37f0, 0, "S3802C37.s3802c37f0");
  }
}
static Arrange_To_Call_Me vS3802C37(Test_S3802C37, "S3802C37", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3802C23  : S3799C3_nt {
  ::S3802C24_nt s3802c23f0;
  ::S3799C30 s3802c23f1;
  ::S3799C30 s3802c23f2;
  ::S3802C27 s3802c23f3;
  ::S3802C27 s3802c23f4;
  void *s3802c23f5;
  ::S3802C27 s3802c23f6;
  ::S3802C27 s3802c23f7;
  ::S3802C27 s3802c23f8;
  char s3802c23f9;
  ::S3799C33_nt s3802c23f10;
  ::S2122C20_nt s3802c23f11;
  ::S2122C20_nt s3802c23f12;
  int s3802c23f13;
  __tsi64 s3802c23f14;
  ::S2122C20_nt s3802c23f15;
  ::S2122C28 s3802c23f16;
  ::S2122C20_nt s3802c23f17;
  int s3802c23f18[4];
  ::S2122C20_nt s3802c23f19;
  char s3802c23f20;
  int s3802c23f21[2];
  ::S2122C20_nt s3802c23f22;
  ::S3799C36_nt s3802c23f23;
  ::S3799C36_nt s3802c23f24;
  ::S2122C20_nt s3802c23f25;
  int s3802c23f26;
  ::S2122C20_nt s3802c23f27;
  ::S2122C20_nt s3802c23f28;
  ::S2122C20_nt s3802c23f29;
  int s3802c23f30[2];
  ::S3799C30 s3802c23f31;
  ::S3799C30 s3802c23f32;
  ::S3799C30 s3802c23f33;
  ::S3802C37 s3802c23f34;
  virtual  ~S3802C23(); // _ZN8S3802C23D1Ev
  S3802C23(); // tgen
};
//SIG(-1 S3802C23) C1{ BC2{ vd m Fi} vd FC3{ m FC4{ FL[4]}} FC5{ m Fp} FC5 FC6{ BC7{ BC8{ vd v2 v3 v4 v5 v6 v7} vd v8 v9 v10 v11 Fp FC9{ m Fp} FC3 Fc Fi} vd v1 Fi FC10{ m Fp Fi[2] FC5} FC11{ m Fp Fi FC12{ m}} FC11} FC6 Fp FC6 FC6 FC6 Fc FC13{ FC14{ Fc[20]} Fc[16]} FC11 FC11 Fi FL FC11 FC15{ m} FC11 Fi[4] FC11 Fc Fi[2] FC11 FC16{ Fc[12]} FC16 FC11 Fi FC11 FC11 FC11 Fi[2] FC5 FC5 FC5 FC17{ m Fp}}


 S3802C23 ::~S3802C23(){ note_dtor("S3802C23", this);}
S3802C23 ::S3802C23(){ note_ctor("S3802C23", this);} // tgen

static void Test_S3802C23()
{
  extern Class_Descriptor cd_S3802C23;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(131,198)];
    init_test(&cd_S3802C23, buf);
    S3802C23 *dp, &lv = *(dp=new (buf) S3802C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1040,788), "sizeof(S3802C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3802C23)");
    check_base_class_offset(lv, (S3799C3_nt*), 0, "S3802C23");
    check_field_offset(lv, s3802c23f0, ABISELECT(16,8), "S3802C23.s3802c23f0");
    check_field_offset(lv, s3802c23f1, ABISELECT(48,40), "S3802C23.s3802c23f1");
    check_field_offset(lv, s3802c23f2, ABISELECT(56,44), "S3802C23.s3802c23f2");
    check_field_offset(lv, s3802c23f3, ABISELECT(64,48), "S3802C23.s3802c23f3");
    check_field_offset(lv, s3802c23f4, ABISELECT(192,144), "S3802C23.s3802c23f4");
    check_field_offset(lv, s3802c23f5, ABISELECT(320,240), "S3802C23.s3802c23f5");
    check_field_offset(lv, s3802c23f6, ABISELECT(328,244), "S3802C23.s3802c23f6");
    check_field_offset(lv, s3802c23f7, ABISELECT(456,340), "S3802C23.s3802c23f7");
    check_field_offset(lv, s3802c23f8, ABISELECT(584,436), "S3802C23.s3802c23f8");
    check_field_offset(lv, s3802c23f9, ABISELECT(712,532), "S3802C23.s3802c23f9");
    check_field_offset(lv, s3802c23f10, ABISELECT(713,533), "S3802C23.s3802c23f10");
    check_field_offset(lv, s3802c23f11, ABISELECT(752,572), "S3802C23.s3802c23f11");
    check_field_offset(lv, s3802c23f12, ABISELECT(768,584), "S3802C23.s3802c23f12");
    check_field_offset(lv, s3802c23f13, ABISELECT(784,596), "S3802C23.s3802c23f13");
    check_field_offset(lv, s3802c23f14, ABISELECT(792,600), "S3802C23.s3802c23f14");
    check_field_offset(lv, s3802c23f15, ABISELECT(800,608), "S3802C23.s3802c23f15");
    check_field_offset(lv, s3802c23f16, ABISELECT(816,620), "S3802C23.s3802c23f16");
    check_field_offset(lv, s3802c23f17, ABISELECT(824,624), "S3802C23.s3802c23f17");
    check_field_offset(lv, s3802c23f18, ABISELECT(840,636), "S3802C23.s3802c23f18");
    check_field_offset(lv, s3802c23f19, ABISELECT(856,652), "S3802C23.s3802c23f19");
    check_field_offset(lv, s3802c23f20, ABISELECT(872,664), "S3802C23.s3802c23f20");
    check_field_offset(lv, s3802c23f21, ABISELECT(876,668), "S3802C23.s3802c23f21");
    check_field_offset(lv, s3802c23f22, ABISELECT(888,676), "S3802C23.s3802c23f22");
    check_field_offset(lv, s3802c23f23, ABISELECT(904,688), "S3802C23.s3802c23f23");
    check_field_offset(lv, s3802c23f24, ABISELECT(916,700), "S3802C23.s3802c23f24");
    check_field_offset(lv, s3802c23f25, ABISELECT(928,712), "S3802C23.s3802c23f25");
    check_field_offset(lv, s3802c23f26, ABISELECT(944,724), "S3802C23.s3802c23f26");
    check_field_offset(lv, s3802c23f27, ABISELECT(952,728), "S3802C23.s3802c23f27");
    check_field_offset(lv, s3802c23f28, ABISELECT(968,740), "S3802C23.s3802c23f28");
    check_field_offset(lv, s3802c23f29, ABISELECT(984,752), "S3802C23.s3802c23f29");
    check_field_offset(lv, s3802c23f30, ABISELECT(1000,764), "S3802C23.s3802c23f30");
    check_field_offset(lv, s3802c23f31, ABISELECT(1008,772), "S3802C23.s3802c23f31");
    check_field_offset(lv, s3802c23f32, ABISELECT(1016,776), "S3802C23.s3802c23f32");
    check_field_offset(lv, s3802c23f33, ABISELECT(1024,780), "S3802C23.s3802c23f33");
    check_field_offset(lv, s3802c23f34, ABISELECT(1032,784), "S3802C23.s3802c23f34");
    test_class_info(&lv, &cd_S3802C23);
    dp->~S3802C23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3802C23(Test_S3802C23, "S3802C23", ABISELECT(1040,788));

#else // __cplusplus

extern void _ZN8S3802C23C1Ev();
extern void _ZN8S3802C23D1Ev();
Name_Map name_map_S3802C23[] = {
  NSPAIR(_ZN8S3802C23C1Ev),
  NSPAIR(_ZN8S3802C23D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3799C3_nt;
extern VTBL_ENTRY _ZTI10S3799C3_nt[];
extern  VTBL_ENTRY _ZTV10S3799C3_nt[];
static Base_Class bases_S3802C23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3799C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S3802C23[];
extern void _ZN8S3802C23D1Ev();
extern void _ZN8S3802C23D0Ev();
static  VTBL_ENTRY vtc_S3802C23[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S3802C23[0]),
  (VTBL_ENTRY)&_ZN8S3802C23D1Ev,
  (VTBL_ENTRY)&_ZN8S3802C23D0Ev,
};
extern VTBL_ENTRY _ZTI8S3802C23[];
extern  VTBL_ENTRY _ZTV8S3802C23[];
Class_Descriptor cd_S3802C23 = {  "S3802C23", // class name
  bases_S3802C23, 1,
  &(vtc_S3802C23[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1040,788), // object size
  NSPAIRA(_ZTI8S3802C23),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S3802C23),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3802C1  : S3802C2 {
  void *s3802c1f0;
  ::S2122C25 s3802c1f1;
  ::S3799C13 s3802c1f2;
  ::S3802C23 s3802c1f3;
  virtual  ~S3802C1(); // _ZN7S3802C1D1Ev
  S3802C1(); // tgen
};
//SIG(1 S3802C1) C1{ BC2{ BC3{ vd m Fi} vd v1 Fp FL FC4{ m Fp Fi FC5{ m}} FC4 FC4 FC4 FC4 FC6{ m Fp} FC7{ m} FC4 FC8{ m Fs[6] Fi[2] Fc Fs} FC4 FC8 FC8} vd Fp FC9{ BC10{ m Fp Fi FC11{ m} FC12{ m}}} FC13{ BC14{ BC15{ vd v6 v7 v8 v9} vd FL FC16{ vd m FC17{ BC18{ m Fp Fi FC19{ m} FC19}} FC10} Fp} vd v2 v3 v4 v5} FC20{ BC3 vd FC21{ m FC22{ FL[4]}} FC23{ m Fp} FC23 FC24{ BC25{ BC26{ vd v11 v12 v13 v14 v15 v16} vd v17 v18 v19 v20 Fp FC27{ m Fp} FC21 Fc Fi} vd v10 Fi FC28{ m Fp Fi[2] FC23} FC4 FC4} FC24 Fp FC24 FC24 FC24 Fc FC29{ FC30{ Fc[20]} Fc[16]} FC4 FC4 Fi FL FC4 FC12 FC4 Fi[4] FC4 Fc Fi[2] FC4 FC31{ Fc[12]} FC31 FC4 Fi FC4 FC4 FC4 Fi[2] FC23 FC23 FC23 FC32{ m Fp}}}


 S3802C1 ::~S3802C1(){ note_dtor("S3802C1", this);}
S3802C1 ::S3802C1(){ note_ctor("S3802C1", this);} // tgen

static void Test_S3802C1()
{
  extern Class_Descriptor cd_S3802C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(171,259)];
    init_test(&cd_S3802C1, buf);
    S3802C1 *dp, &lv = *(dp=new (buf) S3802C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1360,1032), "sizeof(S3802C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3802C1)");
    check_base_class_offset(lv, (S3799C3_nt*)(S3802C2*), 0, "S3802C1");
    check_base_class_offset(lv, (S3802C2*), 0, "S3802C1");
    check_field_offset(lv, s3802c1f0, ABISELECT(232,184), "S3802C1.s3802c1f0");
    check_field_offset(lv, s3802c1f1, ABISELECT(240,188), "S3802C1.s3802c1f1");
    check_field_offset(lv, s3802c1f2, ABISELECT(256,200), "S3802C1.s3802c1f2");
    check_field_offset(lv, s3802c1f3, ABISELECT(320,244), "S3802C1.s3802c1f3");
    test_class_info(&lv, &cd_S3802C1);
    dp->~S3802C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3802C1(Test_S3802C1, "S3802C1", ABISELECT(1360,1032));

#else // __cplusplus

extern void _ZN7S3802C1C1Ev();
extern void _ZN7S3802C1D1Ev();
Name_Map name_map_S3802C1[] = {
  NSPAIR(_ZN7S3802C1C1Ev),
  NSPAIR(_ZN7S3802C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3799C3_nt;
extern VTBL_ENTRY _ZTI10S3799C3_nt[];
extern  VTBL_ENTRY _ZTV10S3799C3_nt[];
extern Class_Descriptor cd_S3802C2;
extern VTBL_ENTRY _ZTI7S3802C2[];
extern  VTBL_ENTRY _ZTV7S3802C2[];
static Base_Class bases_S3802C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3799C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3802C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3802C1[];
extern void _ZN7S3802C1D1Ev();
extern void _ZN7S3802C1D0Ev();
extern void _ZN7S3802C22v1Ev();
static  VTBL_ENTRY vtc_S3802C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3802C1[0]),
  (VTBL_ENTRY)&_ZN7S3802C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3802C1D0Ev,
  (VTBL_ENTRY)&_ZN7S3802C22v1Ev,
};
extern VTBL_ENTRY _ZTI7S3802C1[];
extern  VTBL_ENTRY _ZTV7S3802C1[];
Class_Descriptor cd_S3802C1 = {  "S3802C1", // class name
  bases_S3802C1, 2,
  &(vtc_S3802C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1360,1032), // object size
  NSPAIRA(_ZTI7S3802C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3802C1),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3801C2  : S3799C3_nt {
  void *s3801c2f0;
  __tsi64 s3801c2f1;
  ::S2122C20_nt s3801c2f2;
  ::S2122C20_nt s3801c2f3;
  ::S2122C20_nt s3801c2f4;
  ::S2122C20_nt s3801c2f5;
  ::S2122C20_nt s3801c2f6;
  ::S3802C37 s3801c2f7;
  ::S2122C38 s3801c2f8;
  ::S2122C20_nt s3801c2f9;
  ::S3799C8_nt s3801c2f10;
  ::S2122C20_nt s3801c2f11;
  ::S3799C8_nt s3801c2f12;
  ::S3799C8_nt s3801c2f13;
  virtual  ~S3801C2(); // _ZN7S3801C2D1Ev
  virtual void  v1(); // _ZN7S3801C22v1Ev
  S3801C2(); // tgen
};
//SIG(-1 S3801C2) C1{ BC2{ vd m Fi} vd v1 Fp FL FC3{ m Fp Fi FC4{ m}} FC3 FC3 FC3 FC3 FC5{ m Fp} FC6{ m} FC3 FC7{ m Fs[6] Fi[2] Fc Fs} FC3 FC7 FC7}


 S3801C2 ::~S3801C2(){ note_dtor("S3801C2", this);}
void  S3801C2 ::v1(){vfunc_called(this, "_ZN7S3801C22v1Ev");}
S3801C2 ::S3801C2(){ note_ctor("S3801C2", this);} // tgen

static void Test_S3801C2()
{
  extern Class_Descriptor cd_S3801C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(30,47)];
    init_test(&cd_S3801C2, buf);
    S3801C2 *dp, &lv = *(dp=new (buf) S3801C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(232,184), "sizeof(S3801C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3801C2)");
    check_base_class_offset(lv, (S3799C3_nt*), 0, "S3801C2");
    check_field_offset(lv, s3801c2f0, ABISELECT(16,8), "S3801C2.s3801c2f0");
    check_field_offset(lv, s3801c2f1, ABISELECT(24,12), "S3801C2.s3801c2f1");
    check_field_offset(lv, s3801c2f2, ABISELECT(32,20), "S3801C2.s3801c2f2");
    check_field_offset(lv, s3801c2f3, ABISELECT(48,32), "S3801C2.s3801c2f3");
    check_field_offset(lv, s3801c2f4, ABISELECT(64,44), "S3801C2.s3801c2f4");
    check_field_offset(lv, s3801c2f5, ABISELECT(80,56), "S3801C2.s3801c2f5");
    check_field_offset(lv, s3801c2f6, ABISELECT(96,68), "S3801C2.s3801c2f6");
    check_field_offset(lv, s3801c2f7, ABISELECT(112,80), "S3801C2.s3801c2f7");
    check_field_offset(lv, s3801c2f8, ABISELECT(120,84), "S3801C2.s3801c2f8");
    check_field_offset(lv, s3801c2f9, ABISELECT(128,88), "S3801C2.s3801c2f9");
    check_field_offset(lv, s3801c2f10, ABISELECT(144,100), "S3801C2.s3801c2f10");
    check_field_offset(lv, s3801c2f11, ABISELECT(168,124), "S3801C2.s3801c2f11");
    check_field_offset(lv, s3801c2f12, ABISELECT(184,136), "S3801C2.s3801c2f12");
    check_field_offset(lv, s3801c2f13, ABISELECT(208,160), "S3801C2.s3801c2f13");
    test_class_info(&lv, &cd_S3801C2);
    dp->~S3801C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3801C2(Test_S3801C2, "S3801C2", ABISELECT(232,184));

#else // __cplusplus

extern void _ZN7S3801C2C1Ev();
extern void _ZN7S3801C2D1Ev();
Name_Map name_map_S3801C2[] = {
  NSPAIR(_ZN7S3801C2C1Ev),
  NSPAIR(_ZN7S3801C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3799C3_nt;
extern VTBL_ENTRY _ZTI10S3799C3_nt[];
extern  VTBL_ENTRY _ZTV10S3799C3_nt[];
static Base_Class bases_S3801C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3799C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3801C2[];
extern void _ZN7S3801C2D1Ev();
extern void _ZN7S3801C2D0Ev();
extern void _ZN7S3801C22v1Ev();
static  VTBL_ENTRY vtc_S3801C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3801C2[0]),
  (VTBL_ENTRY)&_ZN7S3801C2D1Ev,
  (VTBL_ENTRY)&_ZN7S3801C2D0Ev,
  (VTBL_ENTRY)&_ZN7S3801C22v1Ev,
};
extern VTBL_ENTRY _ZTI7S3801C2[];
extern  VTBL_ENTRY _ZTV7S3801C2[];
Class_Descriptor cd_S3801C2 = {  "S3801C2", // class name
  bases_S3801C2, 1,
  &(vtc_S3801C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(232,184), // object size
  NSPAIRA(_ZTI7S3801C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3801C2),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3801C23  : S3799C3_nt {
  ::S3799C24_nt s3801c23f0;
  ::S3799C37 s3801c23f1;
  ::S3799C37 s3801c23f2;
  ::S3799C27 s3801c23f3;
  ::S3799C27 s3801c23f4;
  void *s3801c23f5;
  ::S3799C27 s3801c23f6;
  ::S3799C27 s3801c23f7;
  ::S3799C27 s3801c23f8;
  char s3801c23f9;
  ::S3799C33_nt s3801c23f10;
  ::S2122C20_nt s3801c23f11;
  ::S2122C20_nt s3801c23f12;
  int s3801c23f13;
  __tsi64 s3801c23f14;
  ::S2122C20_nt s3801c23f15;
  ::S2122C28 s3801c23f16;
  ::S2122C20_nt s3801c23f17;
  int s3801c23f18[4];
  ::S2122C20_nt s3801c23f19;
  char s3801c23f20;
  int s3801c23f21[2];
  ::S2122C20_nt s3801c23f22;
  ::S3799C36_nt s3801c23f23;
  ::S3799C36_nt s3801c23f24;
  ::S2122C20_nt s3801c23f25;
  int s3801c23f26;
  ::S2122C20_nt s3801c23f27;
  ::S2122C20_nt s3801c23f28;
  ::S2122C20_nt s3801c23f29;
  int s3801c23f30[2];
  ::S3799C37 s3801c23f31;
  ::S3799C37 s3801c23f32;
  ::S3799C37 s3801c23f33;
  ::S3799C30 s3801c23f34;
  virtual  ~S3801C23(); // _ZN8S3801C23D1Ev
  S3801C23(); // tgen
};
//SIG(-1 S3801C23) C1{ BC2{ vd m Fi} vd FC3{ m FC4{ Fl[4]}} FC5{ m Fp} FC5 FC6{ BC7{ BC8{ vd v2 v3 v4 v5 v6 v7} vd v8 v9 v10 v11 Fp FC9{ m Fp} FC3 Fc Fi} vd v1 Fi FC10{ m Fp Fi[2] FC9} FC11{ m Fp Fi FC12{ m}} FC11} FC6 Fp FC6 FC6 FC6 Fc FC13{ FC14{ Fc[20]} Fc[16]} FC11 FC11 Fi FL FC11 FC15{ m} FC11 Fi[4] FC11 Fc Fi[2] FC11 FC16{ Fc[12]} FC16 FC11 Fi FC11 FC11 FC11 Fi[2] FC5 FC5 FC5 FC9}


 S3801C23 ::~S3801C23(){ note_dtor("S3801C23", this);}
S3801C23 ::S3801C23(){ note_ctor("S3801C23", this);} // tgen

static void Test_S3801C23()
{
  extern Class_Descriptor cd_S3801C23;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(131,174)];
    init_test(&cd_S3801C23, buf);
    S3801C23 *dp, &lv = *(dp=new (buf) S3801C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1040,692), "sizeof(S3801C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3801C23)");
    check_base_class_offset(lv, (S3799C3_nt*), 0, "S3801C23");
    check_field_offset(lv, s3801c23f0, ABISELECT(16,8), "S3801C23.s3801c23f0");
    check_field_offset(lv, s3801c23f1, ABISELECT(48,24), "S3801C23.s3801c23f1");
    check_field_offset(lv, s3801c23f2, ABISELECT(56,28), "S3801C23.s3801c23f2");
    check_field_offset(lv, s3801c23f3, ABISELECT(64,32), "S3801C23.s3801c23f3");
    check_field_offset(lv, s3801c23f4, ABISELECT(192,112), "S3801C23.s3801c23f4");
    check_field_offset(lv, s3801c23f5, ABISELECT(320,192), "S3801C23.s3801c23f5");
    check_field_offset(lv, s3801c23f6, ABISELECT(328,196), "S3801C23.s3801c23f6");
    check_field_offset(lv, s3801c23f7, ABISELECT(456,276), "S3801C23.s3801c23f7");
    check_field_offset(lv, s3801c23f8, ABISELECT(584,356), "S3801C23.s3801c23f8");
    check_field_offset(lv, s3801c23f9, ABISELECT(712,436), "S3801C23.s3801c23f9");
    check_field_offset(lv, s3801c23f10, ABISELECT(713,437), "S3801C23.s3801c23f10");
    check_field_offset(lv, s3801c23f11, ABISELECT(752,476), "S3801C23.s3801c23f11");
    check_field_offset(lv, s3801c23f12, ABISELECT(768,488), "S3801C23.s3801c23f12");
    check_field_offset(lv, s3801c23f13, ABISELECT(784,500), "S3801C23.s3801c23f13");
    check_field_offset(lv, s3801c23f14, ABISELECT(792,504), "S3801C23.s3801c23f14");
    check_field_offset(lv, s3801c23f15, ABISELECT(800,512), "S3801C23.s3801c23f15");
    check_field_offset(lv, s3801c23f16, ABISELECT(816,524), "S3801C23.s3801c23f16");
    check_field_offset(lv, s3801c23f17, ABISELECT(824,528), "S3801C23.s3801c23f17");
    check_field_offset(lv, s3801c23f18, ABISELECT(840,540), "S3801C23.s3801c23f18");
    check_field_offset(lv, s3801c23f19, ABISELECT(856,556), "S3801C23.s3801c23f19");
    check_field_offset(lv, s3801c23f20, ABISELECT(872,568), "S3801C23.s3801c23f20");
    check_field_offset(lv, s3801c23f21, ABISELECT(876,572), "S3801C23.s3801c23f21");
    check_field_offset(lv, s3801c23f22, ABISELECT(888,580), "S3801C23.s3801c23f22");
    check_field_offset(lv, s3801c23f23, ABISELECT(904,592), "S3801C23.s3801c23f23");
    check_field_offset(lv, s3801c23f24, ABISELECT(916,604), "S3801C23.s3801c23f24");
    check_field_offset(lv, s3801c23f25, ABISELECT(928,616), "S3801C23.s3801c23f25");
    check_field_offset(lv, s3801c23f26, ABISELECT(944,628), "S3801C23.s3801c23f26");
    check_field_offset(lv, s3801c23f27, ABISELECT(952,632), "S3801C23.s3801c23f27");
    check_field_offset(lv, s3801c23f28, ABISELECT(968,644), "S3801C23.s3801c23f28");
    check_field_offset(lv, s3801c23f29, ABISELECT(984,656), "S3801C23.s3801c23f29");
    check_field_offset(lv, s3801c23f30, ABISELECT(1000,668), "S3801C23.s3801c23f30");
    check_field_offset(lv, s3801c23f31, ABISELECT(1008,676), "S3801C23.s3801c23f31");
    check_field_offset(lv, s3801c23f32, ABISELECT(1016,680), "S3801C23.s3801c23f32");
    check_field_offset(lv, s3801c23f33, ABISELECT(1024,684), "S3801C23.s3801c23f33");
    check_field_offset(lv, s3801c23f34, ABISELECT(1032,688), "S3801C23.s3801c23f34");
    test_class_info(&lv, &cd_S3801C23);
    dp->~S3801C23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3801C23(Test_S3801C23, "S3801C23", ABISELECT(1040,692));

#else // __cplusplus

extern void _ZN8S3801C23C1Ev();
extern void _ZN8S3801C23D1Ev();
Name_Map name_map_S3801C23[] = {
  NSPAIR(_ZN8S3801C23C1Ev),
  NSPAIR(_ZN8S3801C23D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3799C3_nt;
extern VTBL_ENTRY _ZTI10S3799C3_nt[];
extern  VTBL_ENTRY _ZTV10S3799C3_nt[];
static Base_Class bases_S3801C23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3799C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S3801C23[];
extern void _ZN8S3801C23D1Ev();
extern void _ZN8S3801C23D0Ev();
static  VTBL_ENTRY vtc_S3801C23[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S3801C23[0]),
  (VTBL_ENTRY)&_ZN8S3801C23D1Ev,
  (VTBL_ENTRY)&_ZN8S3801C23D0Ev,
};
extern VTBL_ENTRY _ZTI8S3801C23[];
extern  VTBL_ENTRY _ZTV8S3801C23[];
Class_Descriptor cd_S3801C23 = {  "S3801C23", // class name
  bases_S3801C23, 1,
  &(vtc_S3801C23[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1040,692), // object size
  NSPAIRA(_ZTI8S3801C23),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S3801C23),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3801C1  : S3801C2 {
  void *s3801c1f0;
  ::S2122C25 s3801c1f1;
  ::S3799C13 s3801c1f2;
  ::S3801C23 s3801c1f3;
  virtual  ~S3801C1(); // _ZN7S3801C1D1Ev
  S3801C1(); // tgen
};
//SIG(1 S3801C1) C1{ BC2{ BC3{ vd m Fi} vd v1 Fp FL FC4{ m Fp Fi FC5{ m}} FC4 FC4 FC4 FC4 FC6{ m Fp} FC7{ m} FC4 FC8{ m Fs[6] Fi[2] Fc Fs} FC4 FC8 FC8} vd Fp FC9{ BC10{ m Fp Fi FC11{ m} FC12{ m}}} FC13{ BC14{ BC15{ vd v6 v7 v8 v9} vd FL FC16{ vd m FC17{ BC18{ m Fp Fi FC19{ m} FC19}} FC10} Fp} vd v2 v3 v4 v5} FC20{ BC3 vd FC21{ m FC22{ Fl[4]}} FC23{ m Fp} FC23 FC24{ BC25{ BC26{ vd v11 v12 v13 v14 v15 v16} vd v17 v18 v19 v20 Fp FC27{ m Fp} FC21 Fc Fi} vd v10 Fi FC28{ m Fp Fi[2] FC27} FC4 FC4} FC24 Fp FC24 FC24 FC24 Fc FC29{ FC30{ Fc[20]} Fc[16]} FC4 FC4 Fi FL FC4 FC12 FC4 Fi[4] FC4 Fc Fi[2] FC4 FC31{ Fc[12]} FC31 FC4 Fi FC4 FC4 FC4 Fi[2] FC23 FC23 FC23 FC27}}


 S3801C1 ::~S3801C1(){ note_dtor("S3801C1", this);}
S3801C1 ::S3801C1(){ note_ctor("S3801C1", this);} // tgen

static void Test_S3801C1()
{
  extern Class_Descriptor cd_S3801C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(171,235)];
    init_test(&cd_S3801C1, buf);
    S3801C1 *dp, &lv = *(dp=new (buf) S3801C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1360,936), "sizeof(S3801C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3801C1)");
    check_base_class_offset(lv, (S3799C3_nt*)(S3801C2*), 0, "S3801C1");
    check_base_class_offset(lv, (S3801C2*), 0, "S3801C1");
    check_field_offset(lv, s3801c1f0, ABISELECT(232,184), "S3801C1.s3801c1f0");
    check_field_offset(lv, s3801c1f1, ABISELECT(240,188), "S3801C1.s3801c1f1");
    check_field_offset(lv, s3801c1f2, ABISELECT(256,200), "S3801C1.s3801c1f2");
    check_field_offset(lv, s3801c1f3, ABISELECT(320,244), "S3801C1.s3801c1f3");
    test_class_info(&lv, &cd_S3801C1);
    dp->~S3801C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3801C1(Test_S3801C1, "S3801C1", ABISELECT(1360,936));

#else // __cplusplus

extern void _ZN7S3801C1C1Ev();
extern void _ZN7S3801C1D1Ev();
Name_Map name_map_S3801C1[] = {
  NSPAIR(_ZN7S3801C1C1Ev),
  NSPAIR(_ZN7S3801C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3799C3_nt;
extern VTBL_ENTRY _ZTI10S3799C3_nt[];
extern  VTBL_ENTRY _ZTV10S3799C3_nt[];
extern Class_Descriptor cd_S3801C2;
extern VTBL_ENTRY _ZTI7S3801C2[];
extern  VTBL_ENTRY _ZTV7S3801C2[];
static Base_Class bases_S3801C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3799C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3801C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3801C1[];
extern void _ZN7S3801C1D1Ev();
extern void _ZN7S3801C1D0Ev();
extern void _ZN7S3801C22v1Ev();
static  VTBL_ENTRY vtc_S3801C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3801C1[0]),
  (VTBL_ENTRY)&_ZN7S3801C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3801C1D0Ev,
  (VTBL_ENTRY)&_ZN7S3801C22v1Ev,
};
extern VTBL_ENTRY _ZTI7S3801C1[];
extern  VTBL_ENTRY _ZTV7S3801C1[];
Class_Descriptor cd_S3801C1 = {  "S3801C1", // class name
  bases_S3801C1, 2,
  &(vtc_S3801C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1360,936), // object size
  NSPAIRA(_ZTI7S3801C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3801C1),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3800C2  : S3799C3_nt {
  void *s3800c2f0;
  __tsi64 s3800c2f1;
  ::S2122C20_nt s3800c2f2;
  ::S2122C20_nt s3800c2f3;
  ::S2122C20_nt s3800c2f4;
  ::S2122C20_nt s3800c2f5;
  ::S2122C20_nt s3800c2f6;
  ::S3802C37 s3800c2f7;
  ::S2122C38 s3800c2f8;
  ::S2122C20_nt s3800c2f9;
  ::S3799C8_nt s3800c2f10;
  ::S2122C20_nt s3800c2f11;
  ::S3799C8_nt s3800c2f12;
  ::S3799C8_nt s3800c2f13;
  virtual  ~S3800C2(); // _ZN7S3800C2D1Ev
  virtual void  v1(); // _ZN7S3800C22v1Ev
  S3800C2(); // tgen
};
//SIG(-1 S3800C2) C1{ BC2{ vd m Fi} vd v1 Fp FL FC3{ m Fp Fi FC4{ m}} FC3 FC3 FC3 FC3 FC5{ m Fp} FC6{ m} FC3 FC7{ m Fs[6] Fi[2] Fc Fs} FC3 FC7 FC7}


 S3800C2 ::~S3800C2(){ note_dtor("S3800C2", this);}
void  S3800C2 ::v1(){vfunc_called(this, "_ZN7S3800C22v1Ev");}
S3800C2 ::S3800C2(){ note_ctor("S3800C2", this);} // tgen

static void Test_S3800C2()
{
  extern Class_Descriptor cd_S3800C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(30,47)];
    init_test(&cd_S3800C2, buf);
    S3800C2 *dp, &lv = *(dp=new (buf) S3800C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(232,184), "sizeof(S3800C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3800C2)");
    check_base_class_offset(lv, (S3799C3_nt*), 0, "S3800C2");
    check_field_offset(lv, s3800c2f0, ABISELECT(16,8), "S3800C2.s3800c2f0");
    check_field_offset(lv, s3800c2f1, ABISELECT(24,12), "S3800C2.s3800c2f1");
    check_field_offset(lv, s3800c2f2, ABISELECT(32,20), "S3800C2.s3800c2f2");
    check_field_offset(lv, s3800c2f3, ABISELECT(48,32), "S3800C2.s3800c2f3");
    check_field_offset(lv, s3800c2f4, ABISELECT(64,44), "S3800C2.s3800c2f4");
    check_field_offset(lv, s3800c2f5, ABISELECT(80,56), "S3800C2.s3800c2f5");
    check_field_offset(lv, s3800c2f6, ABISELECT(96,68), "S3800C2.s3800c2f6");
    check_field_offset(lv, s3800c2f7, ABISELECT(112,80), "S3800C2.s3800c2f7");
    check_field_offset(lv, s3800c2f8, ABISELECT(120,84), "S3800C2.s3800c2f8");
    check_field_offset(lv, s3800c2f9, ABISELECT(128,88), "S3800C2.s3800c2f9");
    check_field_offset(lv, s3800c2f10, ABISELECT(144,100), "S3800C2.s3800c2f10");
    check_field_offset(lv, s3800c2f11, ABISELECT(168,124), "S3800C2.s3800c2f11");
    check_field_offset(lv, s3800c2f12, ABISELECT(184,136), "S3800C2.s3800c2f12");
    check_field_offset(lv, s3800c2f13, ABISELECT(208,160), "S3800C2.s3800c2f13");
    test_class_info(&lv, &cd_S3800C2);
    dp->~S3800C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3800C2(Test_S3800C2, "S3800C2", ABISELECT(232,184));

#else // __cplusplus

extern void _ZN7S3800C2C1Ev();
extern void _ZN7S3800C2D1Ev();
Name_Map name_map_S3800C2[] = {
  NSPAIR(_ZN7S3800C2C1Ev),
  NSPAIR(_ZN7S3800C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3799C3_nt;
extern VTBL_ENTRY _ZTI10S3799C3_nt[];
extern  VTBL_ENTRY _ZTV10S3799C3_nt[];
static Base_Class bases_S3800C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3799C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3800C2[];
extern void _ZN7S3800C2D1Ev();
extern void _ZN7S3800C2D0Ev();
extern void _ZN7S3800C22v1Ev();
static  VTBL_ENTRY vtc_S3800C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3800C2[0]),
  (VTBL_ENTRY)&_ZN7S3800C2D1Ev,
  (VTBL_ENTRY)&_ZN7S3800C2D0Ev,
  (VTBL_ENTRY)&_ZN7S3800C22v1Ev,
};
extern VTBL_ENTRY _ZTI7S3800C2[];
extern  VTBL_ENTRY _ZTV7S3800C2[];
Class_Descriptor cd_S3800C2 = {  "S3800C2", // class name
  bases_S3800C2, 1,
  &(vtc_S3800C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(232,184), // object size
  NSPAIRA(_ZTI7S3800C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3800C2),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3800C23  : S3799C3_nt {
  ::S3802C24_nt s3800c23f0;
  ::S3799C37 s3800c23f1;
  ::S3799C37 s3800c23f2;
  ::S3802C27 s3800c23f3;
  ::S3802C27 s3800c23f4;
  void *s3800c23f5;
  ::S3802C27 s3800c23f6;
  ::S3802C27 s3800c23f7;
  ::S3802C27 s3800c23f8;
  char s3800c23f9;
  ::S3799C33_nt s3800c23f10;
  ::S2122C20_nt s3800c23f11;
  ::S2122C20_nt s3800c23f12;
  int s3800c23f13;
  __tsi64 s3800c23f14;
  ::S2122C20_nt s3800c23f15;
  ::S2122C28 s3800c23f16;
  ::S2122C20_nt s3800c23f17;
  int s3800c23f18[4];
  ::S2122C20_nt s3800c23f19;
  char s3800c23f20;
  int s3800c23f21[2];
  ::S2122C20_nt s3800c23f22;
  ::S3799C36_nt s3800c23f23;
  ::S3799C36_nt s3800c23f24;
  ::S2122C20_nt s3800c23f25;
  char s3800c23f26;
  ::S2122C20_nt s3800c23f27;
  ::S2122C20_nt s3800c23f28;
  ::S2122C20_nt s3800c23f29;
  int s3800c23f30[2];
  ::S3799C37 s3800c23f31;
  ::S3799C37 s3800c23f32;
  ::S3799C37 s3800c23f33;
  ::S3799C30 s3800c23f34;
  virtual  ~S3800C23(); // _ZN8S3800C23D1Ev
  S3800C23(); // tgen
};
//SIG(-1 S3800C23) C1{ BC2{ vd m Fi} vd FC3{ m FC4{ FL[4]}} FC5{ m Fp} FC5 FC6{ BC7{ BC8{ vd v2 v3 v4 v5 v6 v7} vd v8 v9 v10 v11 Fp FC9{ m Fp} FC3 Fc Fi} vd v1 Fi FC10{ m Fp Fi[2] FC11{ m Fp}} FC12{ m Fp Fi FC13{ m}} FC12} FC6 Fp FC6 FC6 FC6 Fc FC14{ FC15{ Fc[20]} Fc[16]} FC12 FC12 Fi FL FC12 FC16{ m} FC12 Fi[4] FC12 Fc Fi[2] FC12 FC17{ Fc[12]} FC17 FC12 Fc FC12 FC12 FC12 Fi[2] FC5 FC5 FC5 FC11}


 S3800C23 ::~S3800C23(){ note_dtor("S3800C23", this);}
S3800C23 ::S3800C23(){ note_ctor("S3800C23", this);} // tgen

static void Test_S3800C23()
{
  extern Class_Descriptor cd_S3800C23;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(131,198)];
    init_test(&cd_S3800C23, buf);
    S3800C23 *dp, &lv = *(dp=new (buf) S3800C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1040,788), "sizeof(S3800C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3800C23)");
    check_base_class_offset(lv, (S3799C3_nt*), 0, "S3800C23");
    check_field_offset(lv, s3800c23f0, ABISELECT(16,8), "S3800C23.s3800c23f0");
    check_field_offset(lv, s3800c23f1, ABISELECT(48,40), "S3800C23.s3800c23f1");
    check_field_offset(lv, s3800c23f2, ABISELECT(56,44), "S3800C23.s3800c23f2");
    check_field_offset(lv, s3800c23f3, ABISELECT(64,48), "S3800C23.s3800c23f3");
    check_field_offset(lv, s3800c23f4, ABISELECT(192,144), "S3800C23.s3800c23f4");
    check_field_offset(lv, s3800c23f5, ABISELECT(320,240), "S3800C23.s3800c23f5");
    check_field_offset(lv, s3800c23f6, ABISELECT(328,244), "S3800C23.s3800c23f6");
    check_field_offset(lv, s3800c23f7, ABISELECT(456,340), "S3800C23.s3800c23f7");
    check_field_offset(lv, s3800c23f8, ABISELECT(584,436), "S3800C23.s3800c23f8");
    check_field_offset(lv, s3800c23f9, ABISELECT(712,532), "S3800C23.s3800c23f9");
    check_field_offset(lv, s3800c23f10, ABISELECT(713,533), "S3800C23.s3800c23f10");
    check_field_offset(lv, s3800c23f11, ABISELECT(752,572), "S3800C23.s3800c23f11");
    check_field_offset(lv, s3800c23f12, ABISELECT(768,584), "S3800C23.s3800c23f12");
    check_field_offset(lv, s3800c23f13, ABISELECT(784,596), "S3800C23.s3800c23f13");
    check_field_offset(lv, s3800c23f14, ABISELECT(792,600), "S3800C23.s3800c23f14");
    check_field_offset(lv, s3800c23f15, ABISELECT(800,608), "S3800C23.s3800c23f15");
    check_field_offset(lv, s3800c23f16, ABISELECT(816,620), "S3800C23.s3800c23f16");
    check_field_offset(lv, s3800c23f17, ABISELECT(824,624), "S3800C23.s3800c23f17");
    check_field_offset(lv, s3800c23f18, ABISELECT(840,636), "S3800C23.s3800c23f18");
    check_field_offset(lv, s3800c23f19, ABISELECT(856,652), "S3800C23.s3800c23f19");
    check_field_offset(lv, s3800c23f20, ABISELECT(872,664), "S3800C23.s3800c23f20");
    check_field_offset(lv, s3800c23f21, ABISELECT(876,668), "S3800C23.s3800c23f21");
    check_field_offset(lv, s3800c23f22, ABISELECT(888,676), "S3800C23.s3800c23f22");
    check_field_offset(lv, s3800c23f23, ABISELECT(904,688), "S3800C23.s3800c23f23");
    check_field_offset(lv, s3800c23f24, ABISELECT(916,700), "S3800C23.s3800c23f24");
    check_field_offset(lv, s3800c23f25, ABISELECT(928,712), "S3800C23.s3800c23f25");
    check_field_offset(lv, s3800c23f26, ABISELECT(944,724), "S3800C23.s3800c23f26");
    check_field_offset(lv, s3800c23f27, ABISELECT(952,728), "S3800C23.s3800c23f27");
    check_field_offset(lv, s3800c23f28, ABISELECT(968,740), "S3800C23.s3800c23f28");
    check_field_offset(lv, s3800c23f29, ABISELECT(984,752), "S3800C23.s3800c23f29");
    check_field_offset(lv, s3800c23f30, ABISELECT(1000,764), "S3800C23.s3800c23f30");
    check_field_offset(lv, s3800c23f31, ABISELECT(1008,772), "S3800C23.s3800c23f31");
    check_field_offset(lv, s3800c23f32, ABISELECT(1016,776), "S3800C23.s3800c23f32");
    check_field_offset(lv, s3800c23f33, ABISELECT(1024,780), "S3800C23.s3800c23f33");
    check_field_offset(lv, s3800c23f34, ABISELECT(1032,784), "S3800C23.s3800c23f34");
    test_class_info(&lv, &cd_S3800C23);
    dp->~S3800C23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3800C23(Test_S3800C23, "S3800C23", ABISELECT(1040,788));

#else // __cplusplus

extern void _ZN8S3800C23C1Ev();
extern void _ZN8S3800C23D1Ev();
Name_Map name_map_S3800C23[] = {
  NSPAIR(_ZN8S3800C23C1Ev),
  NSPAIR(_ZN8S3800C23D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3799C3_nt;
extern VTBL_ENTRY _ZTI10S3799C3_nt[];
extern  VTBL_ENTRY _ZTV10S3799C3_nt[];
static Base_Class bases_S3800C23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3799C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S3800C23[];
extern void _ZN8S3800C23D1Ev();
extern void _ZN8S3800C23D0Ev();
static  VTBL_ENTRY vtc_S3800C23[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S3800C23[0]),
  (VTBL_ENTRY)&_ZN8S3800C23D1Ev,
  (VTBL_ENTRY)&_ZN8S3800C23D0Ev,
};
extern VTBL_ENTRY _ZTI8S3800C23[];
extern  VTBL_ENTRY _ZTV8S3800C23[];
Class_Descriptor cd_S3800C23 = {  "S3800C23", // class name
  bases_S3800C23, 1,
  &(vtc_S3800C23[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1040,788), // object size
  NSPAIRA(_ZTI8S3800C23),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S3800C23),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3800C1  : S3800C2 {
  void *s3800c1f0;
  ::S2122C25 s3800c1f1;
  ::S3799C13 s3800c1f2;
  ::S3800C23 s3800c1f3;
  virtual  ~S3800C1(); // _ZN7S3800C1D1Ev
  S3800C1(); // tgen
};
//SIG(1 S3800C1) C1{ BC2{ BC3{ vd m Fi} vd v1 Fp FL FC4{ m Fp Fi FC5{ m}} FC4 FC4 FC4 FC4 FC6{ m Fp} FC7{ m} FC4 FC8{ m Fs[6] Fi[2] Fc Fs} FC4 FC8 FC8} vd Fp FC9{ BC10{ m Fp Fi FC11{ m} FC12{ m}}} FC13{ BC14{ BC15{ vd v6 v7 v8 v9} vd FL FC16{ vd m FC17{ BC18{ m Fp Fi FC19{ m} FC19}} FC10} Fp} vd v2 v3 v4 v5} FC20{ BC3 vd FC21{ m FC22{ FL[4]}} FC23{ m Fp} FC23 FC24{ BC25{ BC26{ vd v11 v12 v13 v14 v15 v16} vd v17 v18 v19 v20 Fp FC27{ m Fp} FC21 Fc Fi} vd v10 Fi FC28{ m Fp Fi[2] FC29{ m Fp}} FC4 FC4} FC24 Fp FC24 FC24 FC24 Fc FC30{ FC31{ Fc[20]} Fc[16]} FC4 FC4 Fi FL FC4 FC12 FC4 Fi[4] FC4 Fc Fi[2] FC4 FC32{ Fc[12]} FC32 FC4 Fc FC4 FC4 FC4 Fi[2] FC23 FC23 FC23 FC29}}


 S3800C1 ::~S3800C1(){ note_dtor("S3800C1", this);}
S3800C1 ::S3800C1(){ note_ctor("S3800C1", this);} // tgen

static void Test_S3800C1()
{
  extern Class_Descriptor cd_S3800C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(171,259)];
    init_test(&cd_S3800C1, buf);
    S3800C1 *dp, &lv = *(dp=new (buf) S3800C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1360,1032), "sizeof(S3800C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3800C1)");
    check_base_class_offset(lv, (S3799C3_nt*)(S3800C2*), 0, "S3800C1");
    check_base_class_offset(lv, (S3800C2*), 0, "S3800C1");
    check_field_offset(lv, s3800c1f0, ABISELECT(232,184), "S3800C1.s3800c1f0");
    check_field_offset(lv, s3800c1f1, ABISELECT(240,188), "S3800C1.s3800c1f1");
    check_field_offset(lv, s3800c1f2, ABISELECT(256,200), "S3800C1.s3800c1f2");
    check_field_offset(lv, s3800c1f3, ABISELECT(320,244), "S3800C1.s3800c1f3");
    test_class_info(&lv, &cd_S3800C1);
    dp->~S3800C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3800C1(Test_S3800C1, "S3800C1", ABISELECT(1360,1032));

#else // __cplusplus

extern void _ZN7S3800C1C1Ev();
extern void _ZN7S3800C1D1Ev();
Name_Map name_map_S3800C1[] = {
  NSPAIR(_ZN7S3800C1C1Ev),
  NSPAIR(_ZN7S3800C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3799C3_nt;
extern VTBL_ENTRY _ZTI10S3799C3_nt[];
extern  VTBL_ENTRY _ZTV10S3799C3_nt[];
extern Class_Descriptor cd_S3800C2;
extern VTBL_ENTRY _ZTI7S3800C2[];
extern  VTBL_ENTRY _ZTV7S3800C2[];
static Base_Class bases_S3800C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3799C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3800C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3800C1[];
extern void _ZN7S3800C1D1Ev();
extern void _ZN7S3800C1D0Ev();
extern void _ZN7S3800C22v1Ev();
static  VTBL_ENTRY vtc_S3800C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3800C1[0]),
  (VTBL_ENTRY)&_ZN7S3800C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3800C1D0Ev,
  (VTBL_ENTRY)&_ZN7S3800C22v1Ev,
};
extern VTBL_ENTRY _ZTI7S3800C1[];
extern  VTBL_ENTRY _ZTV7S3800C1[];
Class_Descriptor cd_S3800C1 = {  "S3800C1", // class name
  bases_S3800C1, 2,
  &(vtc_S3800C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1360,1032), // object size
  NSPAIRA(_ZTI7S3800C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3800C1),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3803C2  : S3799C3_nt {
  void *s3803c2f0;
  __tsi64 s3803c2f1;
  ::S2122C20_nt s3803c2f2;
  ::S2122C20_nt s3803c2f3;
  ::S2122C20_nt s3803c2f4;
  ::S2122C20_nt s3803c2f5;
  ::S2122C20_nt s3803c2f6;
  ::S3802C37 s3803c2f7;
  ::S2122C38 s3803c2f8;
  ::S2122C20_nt s3803c2f9;
  ::S3799C8_nt s3803c2f10;
  ::S2122C20_nt s3803c2f11;
  ::S3799C8_nt s3803c2f12;
  ::S3799C8_nt s3803c2f13;
  virtual  ~S3803C2(); // _ZN7S3803C2D1Ev
  virtual void  v1(); // _ZN7S3803C22v1Ev
  S3803C2(); // tgen
};
//SIG(-1 S3803C2) C1{ BC2{ vd m Fi} vd v1 Fp FL FC3{ m Fp Fi FC4{ m}} FC3 FC3 FC3 FC3 FC5{ m Fp} FC6{ m} FC3 FC7{ m Fs[6] Fi[2] Fc Fs} FC3 FC7 FC7}


 S3803C2 ::~S3803C2(){ note_dtor("S3803C2", this);}
void  S3803C2 ::v1(){vfunc_called(this, "_ZN7S3803C22v1Ev");}
S3803C2 ::S3803C2(){ note_ctor("S3803C2", this);} // tgen

static void Test_S3803C2()
{
  extern Class_Descriptor cd_S3803C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(30,47)];
    init_test(&cd_S3803C2, buf);
    S3803C2 *dp, &lv = *(dp=new (buf) S3803C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(232,184), "sizeof(S3803C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3803C2)");
    check_base_class_offset(lv, (S3799C3_nt*), 0, "S3803C2");
    check_field_offset(lv, s3803c2f0, ABISELECT(16,8), "S3803C2.s3803c2f0");
    check_field_offset(lv, s3803c2f1, ABISELECT(24,12), "S3803C2.s3803c2f1");
    check_field_offset(lv, s3803c2f2, ABISELECT(32,20), "S3803C2.s3803c2f2");
    check_field_offset(lv, s3803c2f3, ABISELECT(48,32), "S3803C2.s3803c2f3");
    check_field_offset(lv, s3803c2f4, ABISELECT(64,44), "S3803C2.s3803c2f4");
    check_field_offset(lv, s3803c2f5, ABISELECT(80,56), "S3803C2.s3803c2f5");
    check_field_offset(lv, s3803c2f6, ABISELECT(96,68), "S3803C2.s3803c2f6");
    check_field_offset(lv, s3803c2f7, ABISELECT(112,80), "S3803C2.s3803c2f7");
    check_field_offset(lv, s3803c2f8, ABISELECT(120,84), "S3803C2.s3803c2f8");
    check_field_offset(lv, s3803c2f9, ABISELECT(128,88), "S3803C2.s3803c2f9");
    check_field_offset(lv, s3803c2f10, ABISELECT(144,100), "S3803C2.s3803c2f10");
    check_field_offset(lv, s3803c2f11, ABISELECT(168,124), "S3803C2.s3803c2f11");
    check_field_offset(lv, s3803c2f12, ABISELECT(184,136), "S3803C2.s3803c2f12");
    check_field_offset(lv, s3803c2f13, ABISELECT(208,160), "S3803C2.s3803c2f13");
    test_class_info(&lv, &cd_S3803C2);
    dp->~S3803C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3803C2(Test_S3803C2, "S3803C2", ABISELECT(232,184));

#else // __cplusplus

extern void _ZN7S3803C2C1Ev();
extern void _ZN7S3803C2D1Ev();
Name_Map name_map_S3803C2[] = {
  NSPAIR(_ZN7S3803C2C1Ev),
  NSPAIR(_ZN7S3803C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3799C3_nt;
extern VTBL_ENTRY _ZTI10S3799C3_nt[];
extern  VTBL_ENTRY _ZTV10S3799C3_nt[];
static Base_Class bases_S3803C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3799C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3803C2[];
extern void _ZN7S3803C2D1Ev();
extern void _ZN7S3803C2D0Ev();
extern void _ZN7S3803C22v1Ev();
static  VTBL_ENTRY vtc_S3803C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3803C2[0]),
  (VTBL_ENTRY)&_ZN7S3803C2D1Ev,
  (VTBL_ENTRY)&_ZN7S3803C2D0Ev,
  (VTBL_ENTRY)&_ZN7S3803C22v1Ev,
};
extern VTBL_ENTRY _ZTI7S3803C2[];
extern  VTBL_ENTRY _ZTV7S3803C2[];
Class_Descriptor cd_S3803C2 = {  "S3803C2", // class name
  bases_S3803C2, 1,
  &(vtc_S3803C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(232,184), // object size
  NSPAIRA(_ZTI7S3803C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3803C2),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3803C24_nt  {
  __tsi64 s3803c24f0[4];
  void  mf3803c24(); // _ZN11S3803C24_nt9mf3803c24Ev
};
//SIG(-1 S3803C24_nt) C1{ m FL[4]}


void  S3803C24_nt ::mf3803c24(){}

//skip512 S3803C24_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3803C28  {
  virtual  ~S3803C28(); // _ZN8S3803C28D1Ev
  virtual void  v11(); // _ZN8S3803C283v11Ev
  virtual void  v12(); // _ZN8S3803C283v12Ev
  virtual void  v13(); // _ZN8S3803C283v13Ev
  virtual void  v14(); // _ZN8S3803C283v14Ev
  virtual void  v15(); // _ZN8S3803C283v15Ev
  virtual void  v16(); // _ZN8S3803C283v16Ev
  S3803C28(); // tgen
};
//SIG(-1 S3803C28) C1{ vd v1 v2 v3 v4 v5 v6}


 S3803C28 ::~S3803C28(){ note_dtor("S3803C28", this);}
void  S3803C28 ::v11(){vfunc_called(this, "_ZN8S3803C283v11Ev");}
void  S3803C28 ::v12(){vfunc_called(this, "_ZN8S3803C283v12Ev");}
void  S3803C28 ::v13(){vfunc_called(this, "_ZN8S3803C283v13Ev");}
void  S3803C28 ::v14(){vfunc_called(this, "_ZN8S3803C283v14Ev");}
void  S3803C28 ::v15(){vfunc_called(this, "_ZN8S3803C283v15Ev");}
void  S3803C28 ::v16(){vfunc_called(this, "_ZN8S3803C283v16Ev");}
S3803C28 ::S3803C28(){ note_ctor("S3803C28", this);} // tgen

static void Test_S3803C28()
{
  extern Class_Descriptor cd_S3803C28;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S3803C28, buf);
    S3803C28 *dp, &lv = *(dp=new (buf) S3803C28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S3803C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3803C28)");
    test_class_info(&lv, &cd_S3803C28);
    dp->~S3803C28();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3803C28(Test_S3803C28, "S3803C28", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S3803C28C1Ev();
extern void _ZN8S3803C28D1Ev();
Name_Map name_map_S3803C28[] = {
  NSPAIR(_ZN8S3803C28C1Ev),
  NSPAIR(_ZN8S3803C28D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S3803C28[];
extern void _ZN8S3803C28D1Ev();
extern void _ZN8S3803C28D0Ev();
extern void _ZN8S3803C283v11Ev();
extern void _ZN8S3803C283v12Ev();
extern void _ZN8S3803C283v13Ev();
extern void _ZN8S3803C283v14Ev();
extern void _ZN8S3803C283v15Ev();
extern void _ZN8S3803C283v16Ev();
static  VTBL_ENTRY vtc_S3803C28[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S3803C28[0]),
  (VTBL_ENTRY)&_ZN8S3803C28D1Ev,
  (VTBL_ENTRY)&_ZN8S3803C28D0Ev,
  (VTBL_ENTRY)&_ZN8S3803C283v11Ev,
  (VTBL_ENTRY)&_ZN8S3803C283v12Ev,
  (VTBL_ENTRY)&_ZN8S3803C283v13Ev,
  (VTBL_ENTRY)&_ZN8S3803C283v14Ev,
  (VTBL_ENTRY)&_ZN8S3803C283v15Ev,
  (VTBL_ENTRY)&_ZN8S3803C283v16Ev,
};
extern VTBL_ENTRY _ZTI8S3803C28[];
extern  VTBL_ENTRY _ZTV8S3803C28[];
Class_Descriptor cd_S3803C28 = {  "S3803C28", // class name
  0,0,//no base classes
  &(vtc_S3803C28[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S3803C28),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S3803C28),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3803C27  : S3803C28 {
  void *s3803c27f0;
  ::S3799C30 s3803c27f1;
  ::S3803C24_nt s3803c27f2;
  char s3803c27f3;
  int s3803c27f4;
  virtual  ~S3803C27(); // _ZN8S3803C27D1Ev
  virtual void  v17(); // _ZN8S3803C273v17Ev
  virtual void  v18(); // _ZN8S3803C273v18Ev
  virtual void  v19(); // _ZN8S3803C273v19Ev
  virtual void  v20(); // _ZN8S3803C273v20Ev
  S3803C27(); // tgen
};
//SIG(-1 S3803C27) C1{ BC2{ vd v5 v6 v7 v8 v9 v10} vd v1 v2 v3 v4 Fp FC3{ m Fp} FC4{ m FL[4]} Fc Fi}


 S3803C27 ::~S3803C27(){ note_dtor("S3803C27", this);}
void  S3803C27 ::v17(){vfunc_called(this, "_ZN8S3803C273v17Ev");}
void  S3803C27 ::v18(){vfunc_called(this, "_ZN8S3803C273v18Ev");}
void  S3803C27 ::v19(){vfunc_called(this, "_ZN8S3803C273v19Ev");}
void  S3803C27 ::v20(){vfunc_called(this, "_ZN8S3803C273v20Ev");}
S3803C27 ::S3803C27(){ note_ctor("S3803C27", this);} // tgen

static void Test_S3803C27()
{
  extern Class_Descriptor cd_S3803C27;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,14)];
    init_test(&cd_S3803C27, buf);
    S3803C27 *dp, &lv = *(dp=new (buf) S3803C27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,52), "sizeof(S3803C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3803C27)");
    check_base_class_offset(lv, (S3803C28*), 0, "S3803C27");
    check_field_offset(lv, s3803c27f0, ABISELECT(8,4), "S3803C27.s3803c27f0");
    check_field_offset(lv, s3803c27f1, ABISELECT(16,8), "S3803C27.s3803c27f1");
    check_field_offset(lv, s3803c27f2, ABISELECT(24,12), "S3803C27.s3803c27f2");
    check_field_offset(lv, s3803c27f3, ABISELECT(56,44), "S3803C27.s3803c27f3");
    check_field_offset(lv, s3803c27f4, ABISELECT(60,48), "S3803C27.s3803c27f4");
    test_class_info(&lv, &cd_S3803C27);
    dp->~S3803C27();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3803C27(Test_S3803C27, "S3803C27", ABISELECT(64,52));

#else // __cplusplus

extern void _ZN8S3803C27C1Ev();
extern void _ZN8S3803C27D1Ev();
Name_Map name_map_S3803C27[] = {
  NSPAIR(_ZN8S3803C27C1Ev),
  NSPAIR(_ZN8S3803C27D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3803C28;
extern VTBL_ENTRY _ZTI8S3803C28[];
extern  VTBL_ENTRY _ZTV8S3803C28[];
static Base_Class bases_S3803C27[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3803C28,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S3803C27[];
extern void _ZN8S3803C27D1Ev();
extern void _ZN8S3803C27D0Ev();
extern void _ZN8S3803C283v11Ev();
extern void _ZN8S3803C283v12Ev();
extern void _ZN8S3803C283v13Ev();
extern void _ZN8S3803C283v14Ev();
extern void _ZN8S3803C283v15Ev();
extern void _ZN8S3803C283v16Ev();
extern void _ZN8S3803C273v17Ev();
extern void _ZN8S3803C273v18Ev();
extern void _ZN8S3803C273v19Ev();
extern void _ZN8S3803C273v20Ev();
static  VTBL_ENTRY vtc_S3803C27[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S3803C27[0]),
  (VTBL_ENTRY)&_ZN8S3803C27D1Ev,
  (VTBL_ENTRY)&_ZN8S3803C27D0Ev,
  (VTBL_ENTRY)&_ZN8S3803C283v11Ev,
  (VTBL_ENTRY)&_ZN8S3803C283v12Ev,
  (VTBL_ENTRY)&_ZN8S3803C283v13Ev,
  (VTBL_ENTRY)&_ZN8S3803C283v14Ev,
  (VTBL_ENTRY)&_ZN8S3803C283v15Ev,
  (VTBL_ENTRY)&_ZN8S3803C283v16Ev,
  (VTBL_ENTRY)&_ZN8S3803C273v17Ev,
  (VTBL_ENTRY)&_ZN8S3803C273v18Ev,
  (VTBL_ENTRY)&_ZN8S3803C273v19Ev,
  (VTBL_ENTRY)&_ZN8S3803C273v20Ev,
};
extern VTBL_ENTRY _ZTI8S3803C27[];
extern  VTBL_ENTRY _ZTV8S3803C27[];
Class_Descriptor cd_S3803C27 = {  "S3803C27", // class name
  bases_S3803C27, 1,
  &(vtc_S3803C27[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,52), // object size
  NSPAIRA(_ZTI8S3803C27),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S3803C27),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3803C26  : S3803C27 {
  int s3803c26f0;
  ::S3799C31 s3803c26f1;
  ::S2122C20_nt s3803c26f2;
  ::S2122C20_nt s3803c26f3;
  virtual  ~S3803C26(); // _ZN8S3803C26D1Ev
  virtual void  v10(); // _ZN8S3803C263v10Ev
  S3803C26(); // tgen
};
//SIG(-1 S3803C26) C1{ BC2{ BC3{ vd v2 v3 v4 v5 v6 v7} vd v8 v9 v10 v11 Fp FC4{ m Fp} FC5{ m FL[4]} Fc Fi} vd v1 Fi FC6{ m Fp Fi[2] FC4} FC7{ m Fp Fi FC8{ m}} FC7}


 S3803C26 ::~S3803C26(){ note_dtor("S3803C26", this);}
void  S3803C26 ::v10(){vfunc_called(this, "_ZN8S3803C263v10Ev");}
S3803C26 ::S3803C26(){ note_ctor("S3803C26", this);} // tgen

static void Test_S3803C26()
{
  extern Class_Descriptor cd_S3803C26;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(17,25)];
    init_test(&cd_S3803C26, buf);
    S3803C26 *dp, &lv = *(dp=new (buf) S3803C26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,96), "sizeof(S3803C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3803C26)");
    check_base_class_offset(lv, (S3803C28*)(S3803C27*), 0, "S3803C26");
    check_base_class_offset(lv, (S3803C27*), 0, "S3803C26");
    check_field_offset(lv, s3803c26f0, ABISELECT(64,52), "S3803C26.s3803c26f0");
    check_field_offset(lv, s3803c26f1, ABISELECT(72,56), "S3803C26.s3803c26f1");
    check_field_offset(lv, s3803c26f2, ABISELECT(96,72), "S3803C26.s3803c26f2");
    check_field_offset(lv, s3803c26f3, ABISELECT(112,84), "S3803C26.s3803c26f3");
    test_class_info(&lv, &cd_S3803C26);
    dp->~S3803C26();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3803C26(Test_S3803C26, "S3803C26", ABISELECT(128,96));

#else // __cplusplus

extern void _ZN8S3803C26C1Ev();
extern void _ZN8S3803C26D1Ev();
Name_Map name_map_S3803C26[] = {
  NSPAIR(_ZN8S3803C26C1Ev),
  NSPAIR(_ZN8S3803C26D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3803C28;
extern VTBL_ENTRY _ZTI8S3803C28[];
extern  VTBL_ENTRY _ZTV8S3803C28[];
extern Class_Descriptor cd_S3803C27;
extern VTBL_ENTRY _ZTI8S3803C27[];
extern  VTBL_ENTRY _ZTV8S3803C27[];
static Base_Class bases_S3803C26[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3803C28,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3803C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S3803C26[];
extern void _ZN8S3803C26D1Ev();
extern void _ZN8S3803C26D0Ev();
extern void _ZN8S3803C283v11Ev();
extern void _ZN8S3803C283v12Ev();
extern void _ZN8S3803C283v13Ev();
extern void _ZN8S3803C283v14Ev();
extern void _ZN8S3803C283v15Ev();
extern void _ZN8S3803C283v16Ev();
extern void _ZN8S3803C273v17Ev();
extern void _ZN8S3803C273v18Ev();
extern void _ZN8S3803C273v19Ev();
extern void _ZN8S3803C273v20Ev();
extern void _ZN8S3803C263v10Ev();
static  VTBL_ENTRY vtc_S3803C26[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S3803C26[0]),
  (VTBL_ENTRY)&_ZN8S3803C26D1Ev,
  (VTBL_ENTRY)&_ZN8S3803C26D0Ev,
  (VTBL_ENTRY)&_ZN8S3803C283v11Ev,
  (VTBL_ENTRY)&_ZN8S3803C283v12Ev,
  (VTBL_ENTRY)&_ZN8S3803C283v13Ev,
  (VTBL_ENTRY)&_ZN8S3803C283v14Ev,
  (VTBL_ENTRY)&_ZN8S3803C283v15Ev,
  (VTBL_ENTRY)&_ZN8S3803C283v16Ev,
  (VTBL_ENTRY)&_ZN8S3803C273v17Ev,
  (VTBL_ENTRY)&_ZN8S3803C273v18Ev,
  (VTBL_ENTRY)&_ZN8S3803C273v19Ev,
  (VTBL_ENTRY)&_ZN8S3803C273v20Ev,
  (VTBL_ENTRY)&_ZN8S3803C263v10Ev,
};
extern VTBL_ENTRY _ZTI8S3803C26[];
extern  VTBL_ENTRY _ZTV8S3803C26[];
Class_Descriptor cd_S3803C26 = {  "S3803C26", // class name
  bases_S3803C26, 2,
  &(vtc_S3803C26[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(128,96), // object size
  NSPAIRA(_ZTI8S3803C26),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S3803C26),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3803C23  : S3799C3_nt {
  ::S3803C24_nt s3803c23f0;
  ::S3799C37 s3803c23f1;
  ::S3799C37 s3803c23f2;
  ::S3803C26 s3803c23f3;
  ::S3803C26 s3803c23f4;
  void *s3803c23f5;
  ::S3803C26 s3803c23f6;
  ::S3803C26 s3803c23f7;
  ::S3803C26 s3803c23f8;
  char s3803c23f9;
  ::S3799C33_nt s3803c23f10;
  ::S2122C20_nt s3803c23f11;
  ::S2122C20_nt s3803c23f12;
  int s3803c23f13;
  __tsi64 s3803c23f14;
  ::S2122C20_nt s3803c23f15;
  ::S2122C28 s3803c23f16;
  ::S2122C20_nt s3803c23f17;
  int s3803c23f18[4];
  ::S2122C20_nt s3803c23f19;
  char s3803c23f20;
  int s3803c23f21[2];
  ::S2122C20_nt s3803c23f22;
  ::S3799C36_nt s3803c23f23;
  ::S3799C36_nt s3803c23f24;
  ::S2122C20_nt s3803c23f25;
  char s3803c23f26;
  ::S2122C20_nt s3803c23f27;
  ::S2122C20_nt s3803c23f28;
  ::S2122C20_nt s3803c23f29;
  int s3803c23f30[2];
  ::S3799C37 s3803c23f31;
  ::S3799C37 s3803c23f32;
  ::S3799C37 s3803c23f33;
  ::S3799C6_nt s3803c23f34;
  virtual  ~S3803C23(); // _ZN8S3803C23D1Ev
  S3803C23(); // tgen
};
//SIG(-1 S3803C23) C1{ BC2{ vd m Fi} vd FC3{ m FL[4]} FC4{ m Fp} FC4 FC5{ BC6{ BC7{ vd v2 v3 v4 v5 v6 v7} vd v8 v9 v10 v11 Fp FC8{ m Fp} FC3 Fc Fi} vd v1 Fi FC9{ m Fp Fi[2] FC8} FC10{ m Fp Fi FC11{ m}} FC10} FC5 Fp FC5 FC5 FC5 Fc FC12{ FC13{ Fc[20]} Fc[16]} FC10 FC10 Fi FL FC10 FC14{ m} FC10 Fi[4] FC10 Fc Fi[2] FC10 FC15{ Fc[12]} FC15 FC10 Fc FC10 FC10 FC10 Fi[2] FC4 FC4 FC4 FC16{ m Fp}}


 S3803C23 ::~S3803C23(){ note_dtor("S3803C23", this);}
S3803C23 ::S3803C23(){ note_ctor("S3803C23", this);} // tgen

static void Test_S3803C23()
{
  extern Class_Descriptor cd_S3803C23;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(131,198)];
    init_test(&cd_S3803C23, buf);
    S3803C23 *dp, &lv = *(dp=new (buf) S3803C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1040,788), "sizeof(S3803C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3803C23)");
    check_base_class_offset(lv, (S3799C3_nt*), 0, "S3803C23");
    check_field_offset(lv, s3803c23f0, ABISELECT(16,8), "S3803C23.s3803c23f0");
    check_field_offset(lv, s3803c23f1, ABISELECT(48,40), "S3803C23.s3803c23f1");
    check_field_offset(lv, s3803c23f2, ABISELECT(56,44), "S3803C23.s3803c23f2");
    check_field_offset(lv, s3803c23f3, ABISELECT(64,48), "S3803C23.s3803c23f3");
    check_field_offset(lv, s3803c23f4, ABISELECT(192,144), "S3803C23.s3803c23f4");
    check_field_offset(lv, s3803c23f5, ABISELECT(320,240), "S3803C23.s3803c23f5");
    check_field_offset(lv, s3803c23f6, ABISELECT(328,244), "S3803C23.s3803c23f6");
    check_field_offset(lv, s3803c23f7, ABISELECT(456,340), "S3803C23.s3803c23f7");
    check_field_offset(lv, s3803c23f8, ABISELECT(584,436), "S3803C23.s3803c23f8");
    check_field_offset(lv, s3803c23f9, ABISELECT(712,532), "S3803C23.s3803c23f9");
    check_field_offset(lv, s3803c23f10, ABISELECT(713,533), "S3803C23.s3803c23f10");
    check_field_offset(lv, s3803c23f11, ABISELECT(752,572), "S3803C23.s3803c23f11");
    check_field_offset(lv, s3803c23f12, ABISELECT(768,584), "S3803C23.s3803c23f12");
    check_field_offset(lv, s3803c23f13, ABISELECT(784,596), "S3803C23.s3803c23f13");
    check_field_offset(lv, s3803c23f14, ABISELECT(792,600), "S3803C23.s3803c23f14");
    check_field_offset(lv, s3803c23f15, ABISELECT(800,608), "S3803C23.s3803c23f15");
    check_field_offset(lv, s3803c23f16, ABISELECT(816,620), "S3803C23.s3803c23f16");
    check_field_offset(lv, s3803c23f17, ABISELECT(824,624), "S3803C23.s3803c23f17");
    check_field_offset(lv, s3803c23f18, ABISELECT(840,636), "S3803C23.s3803c23f18");
    check_field_offset(lv, s3803c23f19, ABISELECT(856,652), "S3803C23.s3803c23f19");
    check_field_offset(lv, s3803c23f20, ABISELECT(872,664), "S3803C23.s3803c23f20");
    check_field_offset(lv, s3803c23f21, ABISELECT(876,668), "S3803C23.s3803c23f21");
    check_field_offset(lv, s3803c23f22, ABISELECT(888,676), "S3803C23.s3803c23f22");
    check_field_offset(lv, s3803c23f23, ABISELECT(904,688), "S3803C23.s3803c23f23");
    check_field_offset(lv, s3803c23f24, ABISELECT(916,700), "S3803C23.s3803c23f24");
    check_field_offset(lv, s3803c23f25, ABISELECT(928,712), "S3803C23.s3803c23f25");
    check_field_offset(lv, s3803c23f26, ABISELECT(944,724), "S3803C23.s3803c23f26");
    check_field_offset(lv, s3803c23f27, ABISELECT(952,728), "S3803C23.s3803c23f27");
    check_field_offset(lv, s3803c23f28, ABISELECT(968,740), "S3803C23.s3803c23f28");
    check_field_offset(lv, s3803c23f29, ABISELECT(984,752), "S3803C23.s3803c23f29");
    check_field_offset(lv, s3803c23f30, ABISELECT(1000,764), "S3803C23.s3803c23f30");
    check_field_offset(lv, s3803c23f31, ABISELECT(1008,772), "S3803C23.s3803c23f31");
    check_field_offset(lv, s3803c23f32, ABISELECT(1016,776), "S3803C23.s3803c23f32");
    check_field_offset(lv, s3803c23f33, ABISELECT(1024,780), "S3803C23.s3803c23f33");
    check_field_offset(lv, s3803c23f34, ABISELECT(1032,784), "S3803C23.s3803c23f34");
    test_class_info(&lv, &cd_S3803C23);
    dp->~S3803C23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3803C23(Test_S3803C23, "S3803C23", ABISELECT(1040,788));

#else // __cplusplus

extern void _ZN8S3803C23C1Ev();
extern void _ZN8S3803C23D1Ev();
Name_Map name_map_S3803C23[] = {
  NSPAIR(_ZN8S3803C23C1Ev),
  NSPAIR(_ZN8S3803C23D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3799C3_nt;
extern VTBL_ENTRY _ZTI10S3799C3_nt[];
extern  VTBL_ENTRY _ZTV10S3799C3_nt[];
static Base_Class bases_S3803C23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3799C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S3803C23[];
extern void _ZN8S3803C23D1Ev();
extern void _ZN8S3803C23D0Ev();
static  VTBL_ENTRY vtc_S3803C23[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S3803C23[0]),
  (VTBL_ENTRY)&_ZN8S3803C23D1Ev,
  (VTBL_ENTRY)&_ZN8S3803C23D0Ev,
};
extern VTBL_ENTRY _ZTI8S3803C23[];
extern  VTBL_ENTRY _ZTV8S3803C23[];
Class_Descriptor cd_S3803C23 = {  "S3803C23", // class name
  bases_S3803C23, 1,
  &(vtc_S3803C23[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1040,788), // object size
  NSPAIRA(_ZTI8S3803C23),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S3803C23),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3803C1  : S3803C2 {
  void *s3803c1f0;
  ::S2122C25 s3803c1f1;
  ::S3799C13 s3803c1f2;
  ::S3803C23 s3803c1f3;
  virtual  ~S3803C1(); // _ZN7S3803C1D1Ev
  S3803C1(); // tgen
};
//SIG(1 S3803C1) C1{ BC2{ BC3{ vd m Fi} vd v1 Fp FL FC4{ m Fp Fi FC5{ m}} FC4 FC4 FC4 FC4 FC6{ m Fp} FC7{ m} FC4 FC8{ m Fs[6] Fi[2] Fc Fs} FC4 FC8 FC8} vd Fp FC9{ BC10{ m Fp Fi FC11{ m} FC12{ m}}} FC13{ BC14{ BC15{ vd v6 v7 v8 v9} vd FL FC16{ vd m FC17{ BC18{ m Fp Fi FC19{ m} FC19}} FC10} Fp} vd v2 v3 v4 v5} FC20{ BC3 vd FC21{ m FL[4]} FC22{ m Fp} FC22 FC23{ BC24{ BC25{ vd v11 v12 v13 v14 v15 v16} vd v17 v18 v19 v20 Fp FC26{ m Fp} FC21 Fc Fi} vd v10 Fi FC27{ m Fp Fi[2] FC26} FC4 FC4} FC23 Fp FC23 FC23 FC23 Fc FC28{ FC29{ Fc[20]} Fc[16]} FC4 FC4 Fi FL FC4 FC12 FC4 Fi[4] FC4 Fc Fi[2] FC4 FC30{ Fc[12]} FC30 FC4 Fc FC4 FC4 FC4 Fi[2] FC22 FC22 FC22 FC31{ m Fp}}}


 S3803C1 ::~S3803C1(){ note_dtor("S3803C1", this);}
S3803C1 ::S3803C1(){ note_ctor("S3803C1", this);} // tgen

static void Test_S3803C1()
{
  extern Class_Descriptor cd_S3803C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(171,259)];
    init_test(&cd_S3803C1, buf);
    S3803C1 *dp, &lv = *(dp=new (buf) S3803C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1360,1032), "sizeof(S3803C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3803C1)");
    check_base_class_offset(lv, (S3799C3_nt*)(S3803C2*), 0, "S3803C1");
    check_base_class_offset(lv, (S3803C2*), 0, "S3803C1");
    check_field_offset(lv, s3803c1f0, ABISELECT(232,184), "S3803C1.s3803c1f0");
    check_field_offset(lv, s3803c1f1, ABISELECT(240,188), "S3803C1.s3803c1f1");
    check_field_offset(lv, s3803c1f2, ABISELECT(256,200), "S3803C1.s3803c1f2");
    check_field_offset(lv, s3803c1f3, ABISELECT(320,244), "S3803C1.s3803c1f3");
    test_class_info(&lv, &cd_S3803C1);
    dp->~S3803C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3803C1(Test_S3803C1, "S3803C1", ABISELECT(1360,1032));

#else // __cplusplus

extern void _ZN7S3803C1C1Ev();
extern void _ZN7S3803C1D1Ev();
Name_Map name_map_S3803C1[] = {
  NSPAIR(_ZN7S3803C1C1Ev),
  NSPAIR(_ZN7S3803C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3799C3_nt;
extern VTBL_ENTRY _ZTI10S3799C3_nt[];
extern  VTBL_ENTRY _ZTV10S3799C3_nt[];
extern Class_Descriptor cd_S3803C2;
extern VTBL_ENTRY _ZTI7S3803C2[];
extern  VTBL_ENTRY _ZTV7S3803C2[];
static Base_Class bases_S3803C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3799C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3803C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3803C1[];
extern void _ZN7S3803C1D1Ev();
extern void _ZN7S3803C1D0Ev();
extern void _ZN7S3803C22v1Ev();
static  VTBL_ENTRY vtc_S3803C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3803C1[0]),
  (VTBL_ENTRY)&_ZN7S3803C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3803C1D0Ev,
  (VTBL_ENTRY)&_ZN7S3803C22v1Ev,
};
extern VTBL_ENTRY _ZTI7S3803C1[];
extern  VTBL_ENTRY _ZTV7S3803C1[];
Class_Descriptor cd_S3803C1 = {  "S3803C1", // class name
  bases_S3803C1, 2,
  &(vtc_S3803C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1360,1032), // object size
  NSPAIRA(_ZTI7S3803C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3803C1),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10466C2  {
  int s10466c2f0[4];
  char s10466c2f1[49];
};
//SIG(-1 S10466C2) C1{ Fi[4] Fc[49]}



static void Test_S10466C2()
{
  {
    init_simple_test("S10466C2");
    S10466C2 lv;
    check2(sizeof(lv), 68, "sizeof(S10466C2)");
    check2(__alignof__(lv), 4, "__alignof__(S10466C2)");
    check_field_offset(lv, s10466c2f0, 0, "S10466C2.s10466c2f0");
    check_field_offset(lv, s10466c2f1, 16, "S10466C2.s10466c2f1");
  }
}
static Arrange_To_Call_Me vS10466C2(Test_S10466C2, "S10466C2", 68);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10466C3  {
  int s10466c3f0;
  char s10466c3f1[50];
};
//SIG(-1 S10466C3) C1{ Fi Fc[50]}



static void Test_S10466C3()
{
  {
    init_simple_test("S10466C3");
    S10466C3 lv;
    check2(sizeof(lv), 56, "sizeof(S10466C3)");
    check2(__alignof__(lv), 4, "__alignof__(S10466C3)");
    check_field_offset(lv, s10466c3f0, 0, "S10466C3.s10466c3f0");
    check_field_offset(lv, s10466c3f1, 4, "S10466C3.s10466c3f1");
  }
}
static Arrange_To_Call_Me vS10466C3(Test_S10466C3, "S10466C3", 56);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10466C4_nt  {
  char s10466c4f0;
  int s10466c4f1[2];
};
//SIG(-1 S10466C4_nt) C1{ Fc Fi[2]}



//skip512 S10466C4_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10466C5  {
  long s10466c5f0;
  ::S12863C4 s10466c5f1;
  ::S12863C5 s10466c5f2;
  char s10466c5f3;
  ::S12863C29 s10466c5f4;
  ::S12863C29 s10466c5f5;
  ::S12863C29 s10466c5f6;
  ::S12863C29 s10466c5f7;
  ::S12863C29 s10466c5f8;
  int s10466c5f9;
  int s10466c5f10;
  ::S12863C8 s10466c5f11;
  char s10466c5f12;
  int s10466c5f13;
  int s10466c5f14;
  ::S10466C2 s10466c5f15;
  int s10466c5f16;
  int s10466c5f17;
  ::S12863C32 s10466c5f18;
  long s10466c5f19;
  void *s10466c5f20;
  void *s10466c5f21;
  ::S12863C33 s10466c5f22;
  char s10466c5f23;
  ::S12863C34 s10466c5f24;
};
//SIG(-1 S10466C5) C1{ Fl FC2{ Fi Fl Fc} FC3{ Fc FC4{ Fi FU5{ FC6{ Fc Fc Fc} FC7{ Fi Fi Fc} FC8{ Fc Fc} FC9{ Fs Fs} FC10{ Fs Fc Fc} FC11{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC8 FC12{ Fc Fc Fc[128]} FC13{ Fc Fc} FC14{ Fc Fc[128]} FC15{ Fc Fc[32]} FC14 FC15 FC16{ Fc Fc Fc Fc[134]} FC17{ Fc} FC18{ FC19{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC17 FC20{ Fi} FC20 FC21{ Fi Fc Fc[226]}}}[7] Fi Fi Fc Fc Fc[229] Fc} Fc FC22{ Fc Fc Fc Fc Fc Fc Fc} FC22 FC22 FC22 FC22 Fi Fi FC6 Fc Fi Fi FC23{ Fi[4] Fc[49]} Fi Fi FC24{ Fi Fi} Fl Fp Fp FC25{ Fc[4] Fc} Fc FC26{ Fc Fc Fp}}



static void Test_S10466C5()
{
  {
    init_simple_test("S10466C5");
    S10466C5 lv;
    check2(sizeof(lv), ABISELECT(2120,2080), "sizeof(S10466C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10466C5)");
    check_field_offset(lv, s10466c5f0, 0, "S10466C5.s10466c5f0");
    check_field_offset(lv, s10466c5f1, ABISELECT(8,4), "S10466C5.s10466c5f1");
    check_field_offset(lv, s10466c5f2, ABISELECT(32,16), "S10466C5.s10466c5f2");
    check_field_offset(lv, s10466c5f3, ABISELECT(1928,1912), "S10466C5.s10466c5f3");
    check_field_offset(lv, s10466c5f4, ABISELECT(1929,1913), "S10466C5.s10466c5f4");
    check_field_offset(lv, s10466c5f5, ABISELECT(1936,1920), "S10466C5.s10466c5f5");
    check_field_offset(lv, s10466c5f6, ABISELECT(1943,1927), "S10466C5.s10466c5f6");
    check_field_offset(lv, s10466c5f7, ABISELECT(1950,1934), "S10466C5.s10466c5f7");
    check_field_offset(lv, s10466c5f8, ABISELECT(1957,1941), "S10466C5.s10466c5f8");
    check_field_offset(lv, s10466c5f9, ABISELECT(1964,1948), "S10466C5.s10466c5f9");
    check_field_offset(lv, s10466c5f10, ABISELECT(1968,1952), "S10466C5.s10466c5f10");
    check_field_offset(lv, s10466c5f11, ABISELECT(1972,1956), "S10466C5.s10466c5f11");
    check_field_offset(lv, s10466c5f12, ABISELECT(1975,1959), "S10466C5.s10466c5f12");
    check_field_offset(lv, s10466c5f13, ABISELECT(1976,1960), "S10466C5.s10466c5f13");
    check_field_offset(lv, s10466c5f14, ABISELECT(1980,1964), "S10466C5.s10466c5f14");
    check_field_offset(lv, s10466c5f15, ABISELECT(1984,1968), "S10466C5.s10466c5f15");
    check_field_offset(lv, s10466c5f16, ABISELECT(2052,2036), "S10466C5.s10466c5f16");
    check_field_offset(lv, s10466c5f17, ABISELECT(2056,2040), "S10466C5.s10466c5f17");
    check_field_offset(lv, s10466c5f18, ABISELECT(2060,2044), "S10466C5.s10466c5f18");
    check_field_offset(lv, s10466c5f19, ABISELECT(2072,2052), "S10466C5.s10466c5f19");
    check_field_offset(lv, s10466c5f20, ABISELECT(2080,2056), "S10466C5.s10466c5f20");
    check_field_offset(lv, s10466c5f21, ABISELECT(2088,2060), "S10466C5.s10466c5f21");
    check_field_offset(lv, s10466c5f22, ABISELECT(2096,2064), "S10466C5.s10466c5f22");
    check_field_offset(lv, s10466c5f23, ABISELECT(2101,2069), "S10466C5.s10466c5f23");
    check_field_offset(lv, s10466c5f24, ABISELECT(2104,2072), "S10466C5.s10466c5f24");
  }
}
static Arrange_To_Call_Me vS10466C5(Test_S10466C5, "S10466C5", ABISELECT(2120,2080));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10466C1  {
  char s10466c1f0;
  int s10466c1f1;
  short s10466c1f2;
  int s10466c1f3;
  ::S10466C2 s10466c1f4;
  ::S10466C3 s10466c1f5;
  char s10466c1f6;
  int s10466c1f7;
  ::S10466C4_nt s10466c1f8;
  ::S10466C5 s10466c1f9;
};
//SIG(1 S10466C1) C1{ Fc Fi Fs Fi FC2{ Fi[4] Fc[49]} FC3{ Fi Fc[50]} Fc Fi FC4{ Fc Fi[2]} FC5{ Fl FC6{ Fi Fl Fc} FC7{ Fc FC8{ Fi FU9{ FC10{ Fc Fc Fc} FC11{ Fi Fi Fc} FC12{ Fc Fc} FC13{ Fs Fs} FC14{ Fs Fc Fc} FC15{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC12 FC16{ Fc Fc Fc[128]} FC17{ Fc Fc} FC18{ Fc Fc[128]} FC19{ Fc Fc[32]} FC18 FC19 FC20{ Fc Fc Fc Fc[134]} FC21{ Fc} FC22{ FC23{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC21 FC24{ Fi} FC24 FC25{ Fi Fc Fc[226]}}}[7] Fi Fi Fc Fc Fc[229] Fc} Fc FC26{ Fc Fc Fc Fc Fc Fc Fc} FC26 FC26 FC26 FC26 Fi Fi FC10 Fc Fi Fi FC2 Fi Fi FC27{ Fi Fi} Fl Fp Fp FC28{ Fc[4] Fc} Fc FC29{ Fc Fc Fp}}}



static void Test_S10466C1()
{
  {
    init_simple_test("S10466C1");
    S10466C1 lv;
    check2(sizeof(lv), ABISELECT(2280,2240), "sizeof(S10466C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10466C1)");
    check_field_offset(lv, s10466c1f0, 0, "S10466C1.s10466c1f0");
    check_field_offset(lv, s10466c1f1, 4, "S10466C1.s10466c1f1");
    check_field_offset(lv, s10466c1f2, 8, "S10466C1.s10466c1f2");
    check_field_offset(lv, s10466c1f3, 12, "S10466C1.s10466c1f3");
    check_field_offset(lv, s10466c1f4, 16, "S10466C1.s10466c1f4");
    check_field_offset(lv, s10466c1f5, 84, "S10466C1.s10466c1f5");
    check_field_offset(lv, s10466c1f6, 140, "S10466C1.s10466c1f6");
    check_field_offset(lv, s10466c1f7, 144, "S10466C1.s10466c1f7");
    check_field_offset(lv, s10466c1f8, 148, "S10466C1.s10466c1f8");
    check_field_offset(lv, s10466c1f9, 160, "S10466C1.s10466c1f9");
  }
}
static Arrange_To_Call_Me vS10466C1(Test_S10466C1, "S10466C1", ABISELECT(2280,2240));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12816C4  {
  char s12816c4f0[7];
};
//SIG(-1 S12816C4) C1{ Fc[7]}



static void Test_S12816C4()
{
  {
    init_simple_test("S12816C4");
    S12816C4 lv;
    check2(sizeof(lv), 7, "sizeof(S12816C4)");
    check2(__alignof__(lv), 1, "__alignof__(S12816C4)");
    check_field_offset(lv, s12816c4f0, 0, "S12816C4.s12816c4f0");
  }
}
static Arrange_To_Call_Me vS12816C4(Test_S12816C4, "S12816C4", 7);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12816C5  {
  long s12816c5f0;
  ::S12863C4 s12816c5f1;
  ::S12863C5 s12816c5f2;
  char s12816c5f3;
  ::S12816C4 s12816c5f4;
  ::S12816C4 s12816c5f5;
  ::S12816C4 s12816c5f6;
  ::S12816C4 s12816c5f7;
  ::S12816C4 s12816c5f8;
  int s12816c5f9;
  int s12816c5f10;
  ::S12863C8 s12816c5f11;
  char s12816c5f12;
  int s12816c5f13;
  int s12816c5f14;
  ::S10466C2 s12816c5f15;
  int s12816c5f16;
  int s12816c5f17;
  ::S12863C32 s12816c5f18;
  long s12816c5f19;
  void *s12816c5f20;
  void *s12816c5f21;
  ::S12863C33 s12816c5f22;
  char s12816c5f23;
  ::S12863C34 s12816c5f24;
};
//SIG(-1 S12816C5) C1{ Fl FC2{ Fi Fl Fc} FC3{ Fc FC4{ Fi FU5{ FC6{ Fc Fc Fc} FC7{ Fi Fi Fc} FC8{ Fc Fc} FC9{ Fs Fs} FC10{ Fs Fc Fc} FC11{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC8 FC12{ Fc Fc Fc[128]} FC13{ Fc Fc} FC14{ Fc Fc[128]} FC15{ Fc Fc[32]} FC14 FC15 FC16{ Fc Fc Fc Fc[134]} FC17{ Fc} FC18{ FC19{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC17 FC20{ Fi} FC20 FC21{ Fi Fc Fc[226]}}}[7] Fi Fi Fc Fc Fc[229] Fc} Fc FC22{ Fc[7]} FC22 FC22 FC22 FC22 Fi Fi FC6 Fc Fi Fi FC23{ Fi[4] Fc[49]} Fi Fi FC24{ Fi Fi} Fl Fp Fp FC25{ Fc[4] Fc} Fc FC26{ Fc Fc Fp}}



static void Test_S12816C5()
{
  {
    init_simple_test("S12816C5");
    S12816C5 lv;
    check2(sizeof(lv), ABISELECT(2120,2080), "sizeof(S12816C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S12816C5)");
    check_field_offset(lv, s12816c5f0, 0, "S12816C5.s12816c5f0");
    check_field_offset(lv, s12816c5f1, ABISELECT(8,4), "S12816C5.s12816c5f1");
    check_field_offset(lv, s12816c5f2, ABISELECT(32,16), "S12816C5.s12816c5f2");
    check_field_offset(lv, s12816c5f3, ABISELECT(1928,1912), "S12816C5.s12816c5f3");
    check_field_offset(lv, s12816c5f4, ABISELECT(1929,1913), "S12816C5.s12816c5f4");
    check_field_offset(lv, s12816c5f5, ABISELECT(1936,1920), "S12816C5.s12816c5f5");
    check_field_offset(lv, s12816c5f6, ABISELECT(1943,1927), "S12816C5.s12816c5f6");
    check_field_offset(lv, s12816c5f7, ABISELECT(1950,1934), "S12816C5.s12816c5f7");
    check_field_offset(lv, s12816c5f8, ABISELECT(1957,1941), "S12816C5.s12816c5f8");
    check_field_offset(lv, s12816c5f9, ABISELECT(1964,1948), "S12816C5.s12816c5f9");
    check_field_offset(lv, s12816c5f10, ABISELECT(1968,1952), "S12816C5.s12816c5f10");
    check_field_offset(lv, s12816c5f11, ABISELECT(1972,1956), "S12816C5.s12816c5f11");
    check_field_offset(lv, s12816c5f12, ABISELECT(1975,1959), "S12816C5.s12816c5f12");
    check_field_offset(lv, s12816c5f13, ABISELECT(1976,1960), "S12816C5.s12816c5f13");
    check_field_offset(lv, s12816c5f14, ABISELECT(1980,1964), "S12816C5.s12816c5f14");
    check_field_offset(lv, s12816c5f15, ABISELECT(1984,1968), "S12816C5.s12816c5f15");
    check_field_offset(lv, s12816c5f16, ABISELECT(2052,2036), "S12816C5.s12816c5f16");
    check_field_offset(lv, s12816c5f17, ABISELECT(2056,2040), "S12816C5.s12816c5f17");
    check_field_offset(lv, s12816c5f18, ABISELECT(2060,2044), "S12816C5.s12816c5f18");
    check_field_offset(lv, s12816c5f19, ABISELECT(2072,2052), "S12816C5.s12816c5f19");
    check_field_offset(lv, s12816c5f20, ABISELECT(2080,2056), "S12816C5.s12816c5f20");
    check_field_offset(lv, s12816c5f21, ABISELECT(2088,2060), "S12816C5.s12816c5f21");
    check_field_offset(lv, s12816c5f22, ABISELECT(2096,2064), "S12816C5.s12816c5f22");
    check_field_offset(lv, s12816c5f23, ABISELECT(2101,2069), "S12816C5.s12816c5f23");
    check_field_offset(lv, s12816c5f24, ABISELECT(2104,2072), "S12816C5.s12816c5f24");
  }
}
static Arrange_To_Call_Me vS12816C5(Test_S12816C5, "S12816C5", ABISELECT(2120,2080));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S12816C1  {
  int s12816c1f0;
  short s12816c1f1;
  ::S10466C2 s12816c1f2;
  ::S10466C3 s12816c1f3;
  int s12816c1f4;
  ::S12816C4 s12816c1f5;
  int s12816c1f6;
  ::S12816C5 s12816c1f7;
};
//SIG(1 S12816C1) C1{ Fi Fs FC2{ Fi[4] Fc[49]} FC3{ Fi Fc[50]} Fi FC4{ Fc[7]} Fi FC5{ Fl FC6{ Fi Fl Fc} FC7{ Fc FC8{ Fi FU9{ FC10{ Fc Fc Fc} FC11{ Fi Fi Fc} FC12{ Fc Fc} FC13{ Fs Fs} FC14{ Fs Fc Fc} FC15{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC12 FC16{ Fc Fc Fc[128]} FC17{ Fc Fc} FC18{ Fc Fc[128]} FC19{ Fc Fc[32]} FC18 FC19 FC20{ Fc Fc Fc Fc[134]} FC21{ Fc} FC22{ FC23{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC21 FC24{ Fi} FC24 FC25{ Fi Fc Fc[226]}}}[7] Fi Fi Fc Fc Fc[229] Fc} Fc FC4 FC4 FC4 FC4 FC4 Fi Fi FC10 Fc Fi Fi FC2 Fi Fi FC26{ Fi Fi} Fl Fp Fp FC27{ Fc[4] Fc} Fc FC28{ Fc Fc Fp}}}



static void Test_S12816C1()
{
  {
    init_simple_test("S12816C1");
    S12816C1 lv;
    check2(sizeof(lv), ABISELECT(2272,2228), "sizeof(S12816C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S12816C1)");
    check_field_offset(lv, s12816c1f0, 0, "S12816C1.s12816c1f0");
    check_field_offset(lv, s12816c1f1, 4, "S12816C1.s12816c1f1");
    check_field_offset(lv, s12816c1f2, 8, "S12816C1.s12816c1f2");
    check_field_offset(lv, s12816c1f3, 76, "S12816C1.s12816c1f3");
    check_field_offset(lv, s12816c1f4, 132, "S12816C1.s12816c1f4");
    check_field_offset(lv, s12816c1f5, 136, "S12816C1.s12816c1f5");
    check_field_offset(lv, s12816c1f6, 144, "S12816C1.s12816c1f6");
    check_field_offset(lv, s12816c1f7, ABISELECT(152,148), "S12816C1.s12816c1f7");
  }
}
static Arrange_To_Call_Me vS12816C1(Test_S12816C1, "S12816C1", ABISELECT(2272,2228));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S14326C2  {
  int s14326c2f0[3];
  char s14326c2f1[2];
};
//SIG(-1 S14326C2) C1{ Fi[3] Fc[2]}



static void Test_S14326C2()
{
  {
    init_simple_test("S14326C2");
    S14326C2 lv;
    check2(sizeof(lv), 16, "sizeof(S14326C2)");
    check2(__alignof__(lv), 4, "__alignof__(S14326C2)");
    check_field_offset(lv, s14326c2f0, 0, "S14326C2.s14326c2f0");
    check_field_offset(lv, s14326c2f1, 12, "S14326C2.s14326c2f1");
  }
}
static Arrange_To_Call_Me vS14326C2(Test_S14326C2, "S14326C2", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S14326C4  {
  ::S12863C45 s14326c4f0;
  ::S12863C46 s14326c4f1;
};
//SIG(1 S14326C4) U1{ FC2{ Fc FC3{ Fc Fc Fc Fc Fc Fc Fc} Fl Fi FC4{ Fi Fc Fi Fi Fc Fi Fc} FC5{ Fc FC6{ Fi FU7{ FC8{ Fc Fc Fc} FC9{ Fi Fi Fc} FC10{ Fc Fc} FC11{ Fs Fs} FC12{ Fs Fc Fc} FC13{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC10 FC14{ Fc Fc Fc[128]} FC15{ Fc Fc} FC16{ Fc Fc[128]} FC17{ Fc Fc[32]} FC16 FC17 FC18{ Fc Fc Fc Fc[134]} FC19{ Fc} FC20{ FC21{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC19 FC22{ Fi} FC22 FC23{ Fi Fc Fc[226]}}}[7] Fs Fc[255]}} FC24{ Fc Fi FC3 Fl Fi FC4 FC5}}

#endif // __cplusplus
#ifdef __cplusplus

struct  S14326C1  {
  void *s14326c1f0;
  int s14326c1f1[3];
  ::S14326C2 s14326c1f2;
  int s14326c1f3;
  ::S14325C43 s14326c1f4;
  ::S14326C4 s14326c1f5;
};
//SIG(1 S14326C1) C1{ Fp Fi[3] FC2{ Fi[3] Fc[2]} Fi FC3{ Fc Fp} FU4{ FC5{ Fc FC6{ Fc Fc Fc Fc Fc Fc Fc} Fl Fi FC7{ Fi Fc Fi Fi Fc Fi Fc} FC8{ Fc FC9{ Fi FU10{ FC11{ Fc Fc Fc} FC12{ Fi Fi Fc} FC13{ Fc Fc} FC14{ Fs Fs} FC15{ Fs Fc Fc} FC16{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC13 FC17{ Fc Fc Fc[128]} FC18{ Fc Fc} FC19{ Fc Fc[128]} FC20{ Fc Fc[32]} FC19 FC20 FC21{ Fc Fc Fc Fc[134]} FC22{ Fc} FC23{ FC24{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC22 FC25{ Fi} FC25 FC26{ Fi Fc Fc[226]}}}[7] Fs Fc[255]}} FC27{ Fc Fi FC6 Fl Fi FC7 FC8}}}



static void Test_S14326C1()
{
  {
    init_simple_test("S14326C1");
    S14326C1 lv;
    check2(sizeof(lv), ABISELECT(2032,2012), "sizeof(S14326C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S14326C1)");
    check_field_offset(lv, s14326c1f0, 0, "S14326C1.s14326c1f0");
    check_field_offset(lv, s14326c1f1, ABISELECT(8,4), "S14326C1.s14326c1f1");
    check_field_offset(lv, s14326c1f2, ABISELECT(20,16), "S14326C1.s14326c1f2");
    check_field_offset(lv, s14326c1f3, ABISELECT(36,32), "S14326C1.s14326c1f3");
    check_field_offset(lv, s14326c1f4, ABISELECT(40,36), "S14326C1.s14326c1f4");
    check_field_offset(lv, s14326c1f5, ABISELECT(56,44), "S14326C1.s14326c1f5");
  }
}
static Arrange_To_Call_Me vS14326C1(Test_S14326C1, "S14326C1", ABISELECT(2032,2012));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8547C3_nt  {
  int s8547c3f0[2];
  __tsi64 s8547c3f1;
  int s8547c3f2[4];
  void  mf8547c3(); // _ZN10S8547C3_nt8mf8547c3Ev
  virtual  ~S8547C3_nt(); // _ZN10S8547C3_ntD1Ev
  S8547C3_nt(); // tgen
};
//SIG(-1 S8547C3_nt) C1{ vd m Fi[2] FL Fi[4]}


void  S8547C3_nt ::mf8547c3(){}
 S8547C3_nt ::~S8547C3_nt(){ note_dtor("S8547C3_nt", this);}
S8547C3_nt ::S8547C3_nt(){ note_ctor("S8547C3_nt", this);} // tgen

//skip512 S8547C3_nt

#else // __cplusplus

extern void _ZN10S8547C3_ntC1Ev();
extern void _ZN10S8547C3_ntD1Ev();
Name_Map name_map_S8547C3_nt[] = {
  NSPAIR(_ZN10S8547C3_ntC1Ev),
  NSPAIR(_ZN10S8547C3_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S8547C3_nt[];
extern void _ZN10S8547C3_ntD1Ev();
extern void _ZN10S8547C3_ntD0Ev();
static  VTBL_ENTRY vtc_S8547C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S8547C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S8547C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S8547C3_ntD0Ev,
};
extern VTBL_ENTRY _ZTI10S8547C3_nt[];
VTBL_ENTRY *P__ZTI10S8547C3_nt = _ZTI10S8547C3_nt; 
extern  VTBL_ENTRY _ZTV10S8547C3_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8547C4_nt  {
  int s8547c4f0[2];
  __tsi64 s8547c4f1[3];
  char s8547c4f2[2048];
  int s8547c4f3[6];
  __tsi64 s8547c4f4;
  int s8547c4f5[4];
  void *s8547c4f6[2];
  char s8547c4f7;
  void  mf8547c4(); // _ZN10S8547C4_nt8mf8547c4Ev
  virtual  ~S8547C4_nt(); // _ZN10S8547C4_ntD1Ev
  S8547C4_nt(); // tgen
};
//SIG(1 S8547C4_nt) C1{ vd m Fi[2] FL[3] Fc[2048] Fi[6] FL Fi[4] Fp[2] Fc}


void  S8547C4_nt ::mf8547c4(){}
 S8547C4_nt ::~S8547C4_nt(){ note_dtor("S8547C4_nt", this);}
S8547C4_nt ::S8547C4_nt(){ note_ctor("S8547C4_nt", this);} // tgen

//skip512 S8547C4_nt

#else // __cplusplus

extern void _ZN10S8547C4_ntC1Ev();
extern void _ZN10S8547C4_ntD1Ev();
Name_Map name_map_S8547C4_nt[] = {
  NSPAIR(_ZN10S8547C4_ntC1Ev),
  NSPAIR(_ZN10S8547C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S8547C4_nt[];
extern void _ZN10S8547C4_ntD1Ev();
extern void _ZN10S8547C4_ntD0Ev();
static  VTBL_ENTRY vtc_S8547C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S8547C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S8547C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S8547C4_ntD0Ev,
};
extern VTBL_ENTRY _ZTI10S8547C4_nt[];
VTBL_ENTRY *P__ZTI10S8547C4_nt = _ZTI10S8547C4_nt; 
extern  VTBL_ENTRY _ZTV10S8547C4_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8547C2  {
  void *s8547c2f0;
  ::S8547C3_nt s8547c2f1;
  ::S8547C4_nt s8547c2f2[4];
  char s8547c2f3;
  ::S3802C24_nt s8547c2f4;
  void *s8547c2f5;
  int s8547c2f6;
  void *s8547c2f7;
  int s8547c2f8;
  virtual  ~S8547C2(); // _ZN7S8547C2D1Ev
  virtual void  v11(); // _ZN7S8547C23v11Ev
  virtual void  v12(); // _ZN7S8547C23v12Ev
  virtual void  v13(); // _ZN7S8547C23v13Ev
  virtual void  v14(); // _ZN7S8547C23v14Ev
  virtual void  v15(); // _ZN7S8547C23v15Ev
  virtual void  v16(); // _ZN7S8547C23v16Ev
  virtual void  v17(); // _ZN7S8547C23v17Ev
  virtual void  v18(); // _ZN7S8547C23v18Ev
  virtual void  v19(); // _ZN7S8547C23v19Ev
  virtual void  v20(); // _ZN7S8547C23v20Ev
  virtual void  v21(); // _ZN7S8547C23v21Ev
  virtual void  v22(); // _ZN7S8547C23v22Ev
  virtual void  v23(); // _ZN7S8547C23v23Ev
  virtual void  v24(); // _ZN7S8547C23v24Ev
  virtual void  v25(); // _ZN7S8547C23v25Ev
  virtual void  v26(); // _ZN7S8547C23v26Ev
  virtual void  v27(); // _ZN7S8547C23v27Ev
  virtual void  v28(); // _ZN7S8547C23v28Ev
  virtual void  v29(); // _ZN7S8547C23v29Ev
  virtual void  v30(); // _ZN7S8547C23v30Ev
  virtual void  v31(); // _ZN7S8547C23v31Ev
  virtual void  v32(); // _ZN7S8547C23v32Ev
  virtual void  v33(); // _ZN7S8547C23v33Ev
  S8547C2(); // tgen
};
//SIG(-1 S8547C2) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp FC2{ vd m Fi[2] FL Fi[4]} FC3{ vd m Fi[2] FL[3] Fc[2048] Fi[6] FL Fi[4] Fp[2] Fc}[4] Fc FC4{ m FC5{ FL[4]}} Fp Fi Fp Fi}


 S8547C2 ::~S8547C2(){ note_dtor("S8547C2", this);}
void  S8547C2 ::v11(){vfunc_called(this, "_ZN7S8547C23v11Ev");}
void  S8547C2 ::v12(){vfunc_called(this, "_ZN7S8547C23v12Ev");}
void  S8547C2 ::v13(){vfunc_called(this, "_ZN7S8547C23v13Ev");}
void  S8547C2 ::v14(){vfunc_called(this, "_ZN7S8547C23v14Ev");}
void  S8547C2 ::v15(){vfunc_called(this, "_ZN7S8547C23v15Ev");}
void  S8547C2 ::v16(){vfunc_called(this, "_ZN7S8547C23v16Ev");}
void  S8547C2 ::v17(){vfunc_called(this, "_ZN7S8547C23v17Ev");}
void  S8547C2 ::v18(){vfunc_called(this, "_ZN7S8547C23v18Ev");}
void  S8547C2 ::v19(){vfunc_called(this, "_ZN7S8547C23v19Ev");}
void  S8547C2 ::v20(){vfunc_called(this, "_ZN7S8547C23v20Ev");}
void  S8547C2 ::v21(){vfunc_called(this, "_ZN7S8547C23v21Ev");}
void  S8547C2 ::v22(){vfunc_called(this, "_ZN7S8547C23v22Ev");}
void  S8547C2 ::v23(){vfunc_called(this, "_ZN7S8547C23v23Ev");}
void  S8547C2 ::v24(){vfunc_called(this, "_ZN7S8547C23v24Ev");}
void  S8547C2 ::v25(){vfunc_called(this, "_ZN7S8547C23v25Ev");}
void  S8547C2 ::v26(){vfunc_called(this, "_ZN7S8547C23v26Ev");}
void  S8547C2 ::v27(){vfunc_called(this, "_ZN7S8547C23v27Ev");}
void  S8547C2 ::v28(){vfunc_called(this, "_ZN7S8547C23v28Ev");}
void  S8547C2 ::v29(){vfunc_called(this, "_ZN7S8547C23v29Ev");}
void  S8547C2 ::v30(){vfunc_called(this, "_ZN7S8547C23v30Ev");}
void  S8547C2 ::v31(){vfunc_called(this, "_ZN7S8547C23v31Ev");}
void  S8547C2 ::v32(){vfunc_called(this, "_ZN7S8547C23v32Ev");}
void  S8547C2 ::v33(){vfunc_called(this, "_ZN7S8547C23v33Ev");}
S8547C2 ::S8547C2(){ note_ctor("S8547C2", this);} // tgen

static void Test_S8547C2()
{
  extern Class_Descriptor cd_S8547C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(1097,2169)];
    init_test(&cd_S8547C2, buf);
    S8547C2 *dp, &lv = *(dp=new (buf) S8547C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8768,8672), "sizeof(S8547C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8547C2)");
    check_field_offset(lv, s8547c2f0, ABISELECT(8,4), "S8547C2.s8547c2f0");
    check_field_offset(lv, s8547c2f1, ABISELECT(16,8), "S8547C2.s8547c2f1");
    check_field_offset(lv, s8547c2f2, ABISELECT(56,44), "S8547C2.s8547c2f2");
    check_field_offset(lv, s8547c2f3, ABISELECT(8696,8620), "S8547C2.s8547c2f3");
    check_field_offset(lv, s8547c2f4, ABISELECT(8704,8624), "S8547C2.s8547c2f4");
    check_field_offset(lv, s8547c2f5, ABISELECT(8736,8656), "S8547C2.s8547c2f5");
    check_field_offset(lv, s8547c2f6, ABISELECT(8744,8660), "S8547C2.s8547c2f6");
    check_field_offset(lv, s8547c2f7, ABISELECT(8752,8664), "S8547C2.s8547c2f7");
    check_field_offset(lv, s8547c2f8, ABISELECT(8760,8668), "S8547C2.s8547c2f8");
    test_class_info(&lv, &cd_S8547C2);
    dp->~S8547C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8547C2(Test_S8547C2, "S8547C2", ABISELECT(8768,8672));

#else // __cplusplus

extern void _ZN7S8547C2C1Ev();
extern void _ZN7S8547C2D1Ev();
Name_Map name_map_S8547C2[] = {
  NSPAIR(_ZN7S8547C2C1Ev),
  NSPAIR(_ZN7S8547C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S8547C2[];
extern void _ZN7S8547C2D1Ev();
extern void _ZN7S8547C2D0Ev();
extern void _ZN7S8547C23v11Ev();
extern void _ZN7S8547C23v12Ev();
extern void _ZN7S8547C23v13Ev();
extern void _ZN7S8547C23v14Ev();
extern void _ZN7S8547C23v15Ev();
extern void _ZN7S8547C23v16Ev();
extern void _ZN7S8547C23v17Ev();
extern void _ZN7S8547C23v18Ev();
extern void _ZN7S8547C23v19Ev();
extern void _ZN7S8547C23v20Ev();
extern void _ZN7S8547C23v21Ev();
extern void _ZN7S8547C23v22Ev();
extern void _ZN7S8547C23v23Ev();
extern void _ZN7S8547C23v24Ev();
extern void _ZN7S8547C23v25Ev();
extern void _ZN7S8547C23v26Ev();
extern void _ZN7S8547C23v27Ev();
extern void _ZN7S8547C23v28Ev();
extern void _ZN7S8547C23v29Ev();
extern void _ZN7S8547C23v30Ev();
extern void _ZN7S8547C23v31Ev();
extern void _ZN7S8547C23v32Ev();
extern void _ZN7S8547C23v33Ev();
static  VTBL_ENTRY vtc_S8547C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S8547C2[0]),
  (VTBL_ENTRY)&_ZN7S8547C2D1Ev,
  (VTBL_ENTRY)&_ZN7S8547C2D0Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v11Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v12Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v13Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v14Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v15Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v16Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v17Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v18Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v19Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v20Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v21Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v22Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v23Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v24Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v25Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v26Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v27Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v28Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v29Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v30Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v31Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v32Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v33Ev,
};
extern VTBL_ENTRY _ZTI7S8547C2[];
extern  VTBL_ENTRY _ZTV7S8547C2[];
Class_Descriptor cd_S8547C2 = {  "S8547C2", // class name
  0,0,//no base classes
  &(vtc_S8547C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8768,8672), // object size
  NSPAIRA(_ZTI7S8547C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S8547C2),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8547C10  {
  virtual  ~S8547C10(); // _ZN8S8547C10D1Ev
  virtual void  v34(); // _ZN8S8547C103v34Ev
  virtual void  v35(); // _ZN8S8547C103v35Ev
  virtual void  v36(); // _ZN8S8547C103v36Ev
  virtual void  v37(); // _ZN8S8547C103v37Ev
  virtual void  v38(); // _ZN8S8547C103v38Ev
  virtual void  v39(); // _ZN8S8547C103v39Ev
  S8547C10(); // tgen
};
//SIG(-1 S8547C10) C1{ vd v1 v2 v3 v4 v5 v6}


 S8547C10 ::~S8547C10(){ note_dtor("S8547C10", this);}
void  S8547C10 ::v34(){vfunc_called(this, "_ZN8S8547C103v34Ev");}
void  S8547C10 ::v35(){vfunc_called(this, "_ZN8S8547C103v35Ev");}
void  S8547C10 ::v36(){vfunc_called(this, "_ZN8S8547C103v36Ev");}
void  S8547C10 ::v37(){vfunc_called(this, "_ZN8S8547C103v37Ev");}
void  S8547C10 ::v38(){vfunc_called(this, "_ZN8S8547C103v38Ev");}
void  S8547C10 ::v39(){vfunc_called(this, "_ZN8S8547C103v39Ev");}
S8547C10 ::S8547C10(){ note_ctor("S8547C10", this);} // tgen

static void Test_S8547C10()
{
  extern Class_Descriptor cd_S8547C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S8547C10, buf);
    S8547C10 *dp, &lv = *(dp=new (buf) S8547C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S8547C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8547C10)");
    test_class_info(&lv, &cd_S8547C10);
    dp->~S8547C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8547C10(Test_S8547C10, "S8547C10", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S8547C10C1Ev();
extern void _ZN8S8547C10D1Ev();
Name_Map name_map_S8547C10[] = {
  NSPAIR(_ZN8S8547C10C1Ev),
  NSPAIR(_ZN8S8547C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S8547C10[];
extern void _ZN8S8547C10D1Ev();
extern void _ZN8S8547C10D0Ev();
extern void _ZN8S8547C103v34Ev();
extern void _ZN8S8547C103v35Ev();
extern void _ZN8S8547C103v36Ev();
extern void _ZN8S8547C103v37Ev();
extern void _ZN8S8547C103v38Ev();
extern void _ZN8S8547C103v39Ev();
static  VTBL_ENTRY vtc_S8547C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S8547C10[0]),
  (VTBL_ENTRY)&_ZN8S8547C10D1Ev,
  (VTBL_ENTRY)&_ZN8S8547C10D0Ev,
  (VTBL_ENTRY)&_ZN8S8547C103v34Ev,
  (VTBL_ENTRY)&_ZN8S8547C103v35Ev,
  (VTBL_ENTRY)&_ZN8S8547C103v36Ev,
  (VTBL_ENTRY)&_ZN8S8547C103v37Ev,
  (VTBL_ENTRY)&_ZN8S8547C103v38Ev,
  (VTBL_ENTRY)&_ZN8S8547C103v39Ev,
};
extern VTBL_ENTRY _ZTI8S8547C10[];
extern  VTBL_ENTRY _ZTV8S8547C10[];
Class_Descriptor cd_S8547C10 = {  "S8547C10", // class name
  0,0,//no base classes
  &(vtc_S8547C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S8547C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S8547C10),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8547C12_nt  {
  ::S3802C25_nt s8547c12f0;
  void  mf8547c12(); // _ZN11S8547C12_nt9mf8547c12Ev
};
//SIG(-1 S8547C12_nt) C1{ m FC2{ FL[4]}}


void  S8547C12_nt ::mf8547c12(){}

//skip512 S8547C12_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8547C9  : S8547C10 {
  void *s8547c9f0;
  ::S3802C37 s8547c9f1;
  ::S8547C12_nt s8547c9f2;
  char s8547c9f3;
  int s8547c9f4;
  virtual  ~S8547C9(); // _ZN7S8547C9D1Ev
  virtual void  v40(); // _ZN7S8547C93v40Ev
  virtual void  v41(); // _ZN7S8547C93v41Ev
  virtual void  v42(); // _ZN7S8547C93v42Ev
  virtual void  v43(); // _ZN7S8547C93v43Ev
  S8547C9(); // tgen
};
//SIG(-1 S8547C9) C1{ BC2{ vd v5 v6 v7 v8 v9 v10} vd v1 v2 v3 v4 Fp FC3{ m Fp} FC4{ m FC5{ FL[4]}} Fc Fi}


 S8547C9 ::~S8547C9(){ note_dtor("S8547C9", this);}
void  S8547C9 ::v40(){vfunc_called(this, "_ZN7S8547C93v40Ev");}
void  S8547C9 ::v41(){vfunc_called(this, "_ZN7S8547C93v41Ev");}
void  S8547C9 ::v42(){vfunc_called(this, "_ZN7S8547C93v42Ev");}
void  S8547C9 ::v43(){vfunc_called(this, "_ZN7S8547C93v43Ev");}
S8547C9 ::S8547C9(){ note_ctor("S8547C9", this);} // tgen

static void Test_S8547C9()
{
  extern Class_Descriptor cd_S8547C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,14)];
    init_test(&cd_S8547C9, buf);
    S8547C9 *dp, &lv = *(dp=new (buf) S8547C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,52), "sizeof(S8547C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8547C9)");
    check_base_class_offset(lv, (S8547C10*), 0, "S8547C9");
    check_field_offset(lv, s8547c9f0, ABISELECT(8,4), "S8547C9.s8547c9f0");
    check_field_offset(lv, s8547c9f1, ABISELECT(16,8), "S8547C9.s8547c9f1");
    check_field_offset(lv, s8547c9f2, ABISELECT(24,12), "S8547C9.s8547c9f2");
    check_field_offset(lv, s8547c9f3, ABISELECT(56,44), "S8547C9.s8547c9f3");
    check_field_offset(lv, s8547c9f4, ABISELECT(60,48), "S8547C9.s8547c9f4");
    test_class_info(&lv, &cd_S8547C9);
    dp->~S8547C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8547C9(Test_S8547C9, "S8547C9", ABISELECT(64,52));

#else // __cplusplus

extern void _ZN7S8547C9C1Ev();
extern void _ZN7S8547C9D1Ev();
Name_Map name_map_S8547C9[] = {
  NSPAIR(_ZN7S8547C9C1Ev),
  NSPAIR(_ZN7S8547C9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S8547C10;
extern VTBL_ENTRY _ZTI8S8547C10[];
extern  VTBL_ENTRY _ZTV8S8547C10[];
static Base_Class bases_S8547C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S8547C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S8547C9[];
extern void _ZN7S8547C9D1Ev();
extern void _ZN7S8547C9D0Ev();
extern void _ZN8S8547C103v34Ev();
extern void _ZN8S8547C103v35Ev();
extern void _ZN8S8547C103v36Ev();
extern void _ZN8S8547C103v37Ev();
extern void _ZN8S8547C103v38Ev();
extern void _ZN8S8547C103v39Ev();
extern void _ZN7S8547C93v40Ev();
extern void _ZN7S8547C93v41Ev();
extern void _ZN7S8547C93v42Ev();
extern void _ZN7S8547C93v43Ev();
static  VTBL_ENTRY vtc_S8547C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S8547C9[0]),
  (VTBL_ENTRY)&_ZN7S8547C9D1Ev,
  (VTBL_ENTRY)&_ZN7S8547C9D0Ev,
  (VTBL_ENTRY)&_ZN8S8547C103v34Ev,
  (VTBL_ENTRY)&_ZN8S8547C103v35Ev,
  (VTBL_ENTRY)&_ZN8S8547C103v36Ev,
  (VTBL_ENTRY)&_ZN8S8547C103v37Ev,
  (VTBL_ENTRY)&_ZN8S8547C103v38Ev,
  (VTBL_ENTRY)&_ZN8S8547C103v39Ev,
  (VTBL_ENTRY)&_ZN7S8547C93v40Ev,
  (VTBL_ENTRY)&_ZN7S8547C93v41Ev,
  (VTBL_ENTRY)&_ZN7S8547C93v42Ev,
  (VTBL_ENTRY)&_ZN7S8547C93v43Ev,
};
extern VTBL_ENTRY _ZTI7S8547C9[];
extern  VTBL_ENTRY _ZTV7S8547C9[];
Class_Descriptor cd_S8547C9 = {  "S8547C9", // class name
  bases_S8547C9, 1,
  &(vtc_S8547C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,52), // object size
  NSPAIRA(_ZTI7S8547C9),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S8547C9),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8547C8  : S8547C9 {
  int s8547c8f0;
  ::S3799C31 s8547c8f1;
  ::S2122C20_nt s8547c8f2;
  ::S2122C20_nt s8547c8f3;
  virtual  ~S8547C8(); // _ZN7S8547C8D1Ev
  virtual void  v44(); // _ZN7S8547C83v44Ev
  S8547C8(); // tgen
};
//SIG(-1 S8547C8) C1{ BC2{ BC3{ vd v2 v3 v4 v5 v6 v7} vd v8 v9 v10 v11 Fp FC4{ m Fp} FC5{ m FC6{ FL[4]}} Fc Fi} vd v1 Fi FC7{ m Fp Fi[2] FC8{ m Fp}} FC9{ m Fp Fi FC10{ m}} FC9}


 S8547C8 ::~S8547C8(){ note_dtor("S8547C8", this);}
void  S8547C8 ::v44(){vfunc_called(this, "_ZN7S8547C83v44Ev");}
S8547C8 ::S8547C8(){ note_ctor("S8547C8", this);} // tgen

static void Test_S8547C8()
{
  extern Class_Descriptor cd_S8547C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(17,25)];
    init_test(&cd_S8547C8, buf);
    S8547C8 *dp, &lv = *(dp=new (buf) S8547C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,96), "sizeof(S8547C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8547C8)");
    check_base_class_offset(lv, (S8547C10*)(S8547C9*), 0, "S8547C8");
    check_base_class_offset(lv, (S8547C9*), 0, "S8547C8");
    check_field_offset(lv, s8547c8f0, ABISELECT(64,52), "S8547C8.s8547c8f0");
    check_field_offset(lv, s8547c8f1, ABISELECT(72,56), "S8547C8.s8547c8f1");
    check_field_offset(lv, s8547c8f2, ABISELECT(96,72), "S8547C8.s8547c8f2");
    check_field_offset(lv, s8547c8f3, ABISELECT(112,84), "S8547C8.s8547c8f3");
    test_class_info(&lv, &cd_S8547C8);
    dp->~S8547C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8547C8(Test_S8547C8, "S8547C8", ABISELECT(128,96));

#else // __cplusplus

extern void _ZN7S8547C8C1Ev();
extern void _ZN7S8547C8D1Ev();
Name_Map name_map_S8547C8[] = {
  NSPAIR(_ZN7S8547C8C1Ev),
  NSPAIR(_ZN7S8547C8D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S8547C10;
extern VTBL_ENTRY _ZTI8S8547C10[];
extern  VTBL_ENTRY _ZTV8S8547C10[];
extern Class_Descriptor cd_S8547C9;
extern VTBL_ENTRY _ZTI7S8547C9[];
extern  VTBL_ENTRY _ZTV7S8547C9[];
static Base_Class bases_S8547C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S8547C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S8547C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S8547C8[];
extern void _ZN7S8547C8D1Ev();
extern void _ZN7S8547C8D0Ev();
extern void _ZN8S8547C103v34Ev();
extern void _ZN8S8547C103v35Ev();
extern void _ZN8S8547C103v36Ev();
extern void _ZN8S8547C103v37Ev();
extern void _ZN8S8547C103v38Ev();
extern void _ZN8S8547C103v39Ev();
extern void _ZN7S8547C93v40Ev();
extern void _ZN7S8547C93v41Ev();
extern void _ZN7S8547C93v42Ev();
extern void _ZN7S8547C93v43Ev();
extern void _ZN7S8547C83v44Ev();
static  VTBL_ENTRY vtc_S8547C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S8547C8[0]),
  (VTBL_ENTRY)&_ZN7S8547C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8547C8D0Ev,
  (VTBL_ENTRY)&_ZN8S8547C103v34Ev,
  (VTBL_ENTRY)&_ZN8S8547C103v35Ev,
  (VTBL_ENTRY)&_ZN8S8547C103v36Ev,
  (VTBL_ENTRY)&_ZN8S8547C103v37Ev,
  (VTBL_ENTRY)&_ZN8S8547C103v38Ev,
  (VTBL_ENTRY)&_ZN8S8547C103v39Ev,
  (VTBL_ENTRY)&_ZN7S8547C93v40Ev,
  (VTBL_ENTRY)&_ZN7S8547C93v41Ev,
  (VTBL_ENTRY)&_ZN7S8547C93v42Ev,
  (VTBL_ENTRY)&_ZN7S8547C93v43Ev,
  (VTBL_ENTRY)&_ZN7S8547C83v44Ev,
};
extern VTBL_ENTRY _ZTI7S8547C8[];
extern  VTBL_ENTRY _ZTV7S8547C8[];
Class_Descriptor cd_S8547C8 = {  "S8547C8", // class name
  bases_S8547C8, 2,
  &(vtc_S8547C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(128,96), // object size
  NSPAIRA(_ZTI7S8547C8),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S8547C8),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8547C7  : S8547C8 {
  int s8547c7f0;
  virtual  ~S8547C7(); // _ZN7S8547C7D1Ev
  S8547C7(); // tgen
};
//SIG(-1 S8547C7) C1{ BC2{ BC3{ BC4{ vd v1 v2 v3 v4 v5 v6} vd v7 v8 v9 v10 Fp FC5{ m Fp} FC6{ m FC7{ FL[4]}} Fc Fi} vd v11 Fi FC8{ m Fp Fi[2] FC9{ m Fp}} FC10{ m Fp Fi FC11{ m}} FC10} vd Fi}


 S8547C7 ::~S8547C7(){ note_dtor("S8547C7", this);}
S8547C7 ::S8547C7(){ note_ctor("S8547C7", this);} // tgen

static void Test_S8547C7()
{
  extern Class_Descriptor cd_S8547C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,26)];
    init_test(&cd_S8547C7, buf);
    S8547C7 *dp, &lv = *(dp=new (buf) S8547C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,100), "sizeof(S8547C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8547C7)");
    check_base_class_offset(lv, (S8547C10*)(S8547C9*)(S8547C8*), 0, "S8547C7");
    check_base_class_offset(lv, (S8547C9*)(S8547C8*), 0, "S8547C7");
    check_base_class_offset(lv, (S8547C8*), 0, "S8547C7");
    check_field_offset(lv, s8547c7f0, ABISELECT(128,96), "S8547C7.s8547c7f0");
    test_class_info(&lv, &cd_S8547C7);
    dp->~S8547C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8547C7(Test_S8547C7, "S8547C7", ABISELECT(136,100));

#else // __cplusplus

extern void _ZN7S8547C7C1Ev();
extern void _ZN7S8547C7D1Ev();
Name_Map name_map_S8547C7[] = {
  NSPAIR(_ZN7S8547C7C1Ev),
  NSPAIR(_ZN7S8547C7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S8547C10;
extern VTBL_ENTRY _ZTI8S8547C10[];
extern  VTBL_ENTRY _ZTV8S8547C10[];
extern Class_Descriptor cd_S8547C9;
extern VTBL_ENTRY _ZTI7S8547C9[];
extern  VTBL_ENTRY _ZTV7S8547C9[];
extern Class_Descriptor cd_S8547C8;
extern VTBL_ENTRY _ZTI7S8547C8[];
extern  VTBL_ENTRY _ZTV7S8547C8[];
static Base_Class bases_S8547C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S8547C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S8547C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S8547C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S8547C7[];
extern void _ZN7S8547C7D1Ev();
extern void _ZN7S8547C7D0Ev();
extern void _ZN8S8547C103v34Ev();
extern void _ZN8S8547C103v35Ev();
extern void _ZN8S8547C103v36Ev();
extern void _ZN8S8547C103v37Ev();
extern void _ZN8S8547C103v38Ev();
extern void _ZN8S8547C103v39Ev();
extern void _ZN7S8547C93v40Ev();
extern void _ZN7S8547C93v41Ev();
extern void _ZN7S8547C93v42Ev();
extern void _ZN7S8547C93v43Ev();
extern void _ZN7S8547C83v44Ev();
static  VTBL_ENTRY vtc_S8547C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S8547C7[0]),
  (VTBL_ENTRY)&_ZN7S8547C7D1Ev,
  (VTBL_ENTRY)&_ZN7S8547C7D0Ev,
  (VTBL_ENTRY)&_ZN8S8547C103v34Ev,
  (VTBL_ENTRY)&_ZN8S8547C103v35Ev,
  (VTBL_ENTRY)&_ZN8S8547C103v36Ev,
  (VTBL_ENTRY)&_ZN8S8547C103v37Ev,
  (VTBL_ENTRY)&_ZN8S8547C103v38Ev,
  (VTBL_ENTRY)&_ZN8S8547C103v39Ev,
  (VTBL_ENTRY)&_ZN7S8547C93v40Ev,
  (VTBL_ENTRY)&_ZN7S8547C93v41Ev,
  (VTBL_ENTRY)&_ZN7S8547C93v42Ev,
  (VTBL_ENTRY)&_ZN7S8547C93v43Ev,
  (VTBL_ENTRY)&_ZN7S8547C83v44Ev,
};
extern VTBL_ENTRY _ZTI7S8547C7[];
extern  VTBL_ENTRY _ZTV7S8547C7[];
Class_Descriptor cd_S8547C7 = {  "S8547C7", // class name
  bases_S8547C7, 3,
  &(vtc_S8547C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,100), // object size
  NSPAIRA(_ZTI7S8547C7),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S8547C7),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8547C19_nt  {
  __tsi64 s8547c19f0;
};
//SIG(-1 S8547C19_nt) C1{ FL}



//skip512 S8547C19_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8547C17  {
  __tsi64 s8547c17f0;
  ::S3799C37 s8547c17f1;
  ::S3802C24_nt s8547c17f2;
  ::S8547C19_nt s8547c17f3;
  ::S8547C19_nt s8547c17f4;
  void  mf8547c17(); // _ZN8S8547C179mf8547c17Ev
};
//SIG(-1 S8547C17) C1{ m FL FC2{ m Fp} FC3{ m FC4{ FL[4]}} FC5{ FL} FC5}


void  S8547C17 ::mf8547c17(){}

static void Test_S8547C17()
{
  {
    init_simple_test("S8547C17");
    S8547C17 lv;
    check2(sizeof(lv), ABISELECT(64,60), "sizeof(S8547C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8547C17)");
    check_field_offset(lv, s8547c17f0, 0, "S8547C17.s8547c17f0");
    check_field_offset(lv, s8547c17f1, 8, "S8547C17.s8547c17f1");
    check_field_offset(lv, s8547c17f2, ABISELECT(16,12), "S8547C17.s8547c17f2");
    check_field_offset(lv, s8547c17f3, ABISELECT(48,44), "S8547C17.s8547c17f3");
    check_field_offset(lv, s8547c17f4, ABISELECT(56,52), "S8547C17.s8547c17f4");
  }
}
static Arrange_To_Call_Me vS8547C17(Test_S8547C17, "S8547C17", ABISELECT(64,60));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8547C1  : S8547C2 {
  ::S8547C7 s8547c1f0;
  ::S8547C8 s8547c1f1;
  void *s8547c1f2;
  char s8547c1f3;
  ::S8547C17 s8547c1f4;
  virtual  ~S8547C1(); // _ZN7S8547C1D1Ev
  virtual void  v1(); // _ZN7S8547C12v1Ev
  virtual void  v2(); // _ZN7S8547C12v2Ev
  virtual void  v3(); // _ZN7S8547C12v3Ev
  virtual void  v4(); // _ZN7S8547C12v4Ev
  virtual void  v5(); // _ZN7S8547C12v5Ev
  virtual void  v6(); // _ZN7S8547C12v6Ev
  virtual void  v7(); // _ZN7S8547C12v7Ev
  virtual void  v8(); // _ZN7S8547C12v8Ev
  virtual void  v9(); // _ZN7S8547C12v9Ev
  virtual void  v10(); // _ZN7S8547C13v10Ev
  S8547C1(); // tgen
};
//SIG(1 S8547C1) C1{ BC2{ vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 Fp FC3{ vd m Fi[2] FL Fi[4]} FC4{ vd m Fi[2] FL[3] Fc[2048] Fi[6] FL Fi[4] Fp[2] Fc}[4] Fc FC5{ m FC6{ FL[4]}} Fp Fi Fp Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 FC7{ BC8{ BC9{ BC10{ vd v34 v35 v36 v37 v38 v39} vd v40 v41 v42 v43 Fp FC11{ m Fp} FC12{ m FC6} Fc Fi} vd v44 Fi FC13{ m Fp Fi[2] FC14{ m Fp}} FC15{ m Fp Fi FC16{ m}} FC15} vd Fi} FC8 Fp Fc FC17{ m FL FC18{ m Fp} FC5 FC19{ FL} FC19}}


 S8547C1 ::~S8547C1(){ note_dtor("S8547C1", this);}
void  S8547C1 ::v1(){vfunc_called(this, "_ZN7S8547C12v1Ev");}
void  S8547C1 ::v2(){vfunc_called(this, "_ZN7S8547C12v2Ev");}
void  S8547C1 ::v3(){vfunc_called(this, "_ZN7S8547C12v3Ev");}
void  S8547C1 ::v4(){vfunc_called(this, "_ZN7S8547C12v4Ev");}
void  S8547C1 ::v5(){vfunc_called(this, "_ZN7S8547C12v5Ev");}
void  S8547C1 ::v6(){vfunc_called(this, "_ZN7S8547C12v6Ev");}
void  S8547C1 ::v7(){vfunc_called(this, "_ZN7S8547C12v7Ev");}
void  S8547C1 ::v8(){vfunc_called(this, "_ZN7S8547C12v8Ev");}
void  S8547C1 ::v9(){vfunc_called(this, "_ZN7S8547C12v9Ev");}
void  S8547C1 ::v10(){vfunc_called(this, "_ZN7S8547C13v10Ev");}
S8547C1 ::S8547C1(){ note_ctor("S8547C1", this);} // tgen

static void Test_S8547C1()
{
  extern Class_Descriptor cd_S8547C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(1140,2235)];
    init_test(&cd_S8547C1, buf);
    S8547C1 *dp, &lv = *(dp=new (buf) S8547C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(9112,8936), "sizeof(S8547C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8547C1)");
    check_base_class_offset(lv, (S8547C2*), 0, "S8547C1");
    check_field_offset(lv, s8547c1f0, ABISELECT(8768,8672), "S8547C1.s8547c1f0");
    check_field_offset(lv, s8547c1f1, ABISELECT(8904,8772), "S8547C1.s8547c1f1");
    check_field_offset(lv, s8547c1f2, ABISELECT(9032,8868), "S8547C1.s8547c1f2");
    check_field_offset(lv, s8547c1f3, ABISELECT(9040,8872), "S8547C1.s8547c1f3");
    check_field_offset(lv, s8547c1f4, ABISELECT(9048,8876), "S8547C1.s8547c1f4");
    test_class_info(&lv, &cd_S8547C1);
    dp->~S8547C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8547C1(Test_S8547C1, "S8547C1", ABISELECT(9112,8936));

#else // __cplusplus

extern void _ZN7S8547C1C1Ev();
extern void _ZN7S8547C1D1Ev();
Name_Map name_map_S8547C1[] = {
  NSPAIR(_ZN7S8547C1C1Ev),
  NSPAIR(_ZN7S8547C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S8547C2;
extern VTBL_ENTRY _ZTI7S8547C2[];
extern  VTBL_ENTRY _ZTV7S8547C2[];
static Base_Class bases_S8547C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S8547C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S8547C1[];
extern void _ZN7S8547C1D1Ev();
extern void _ZN7S8547C1D0Ev();
extern void _ZN7S8547C23v11Ev();
extern void _ZN7S8547C23v12Ev();
extern void _ZN7S8547C23v13Ev();
extern void _ZN7S8547C23v14Ev();
extern void _ZN7S8547C23v15Ev();
extern void _ZN7S8547C23v16Ev();
extern void _ZN7S8547C23v17Ev();
extern void _ZN7S8547C23v18Ev();
extern void _ZN7S8547C23v19Ev();
extern void _ZN7S8547C23v20Ev();
extern void _ZN7S8547C23v21Ev();
extern void _ZN7S8547C23v22Ev();
extern void _ZN7S8547C23v23Ev();
extern void _ZN7S8547C23v24Ev();
extern void _ZN7S8547C23v25Ev();
extern void _ZN7S8547C23v26Ev();
extern void _ZN7S8547C23v27Ev();
extern void _ZN7S8547C23v28Ev();
extern void _ZN7S8547C23v29Ev();
extern void _ZN7S8547C23v30Ev();
extern void _ZN7S8547C23v31Ev();
extern void _ZN7S8547C23v32Ev();
extern void _ZN7S8547C23v33Ev();
extern void _ZN7S8547C12v1Ev();
extern void _ZN7S8547C12v2Ev();
extern void _ZN7S8547C12v3Ev();
extern void _ZN7S8547C12v4Ev();
extern void _ZN7S8547C12v5Ev();
extern void _ZN7S8547C12v6Ev();
extern void _ZN7S8547C12v7Ev();
extern void _ZN7S8547C12v8Ev();
extern void _ZN7S8547C12v9Ev();
extern void _ZN7S8547C13v10Ev();
static  VTBL_ENTRY vtc_S8547C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S8547C1[0]),
  (VTBL_ENTRY)&_ZN7S8547C1D1Ev,
  (VTBL_ENTRY)&_ZN7S8547C1D0Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v11Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v12Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v13Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v14Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v15Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v16Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v17Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v18Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v19Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v20Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v21Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v22Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v23Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v24Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v25Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v26Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v27Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v28Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v29Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v30Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v31Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v32Ev,
  (VTBL_ENTRY)&_ZN7S8547C23v33Ev,
  (VTBL_ENTRY)&_ZN7S8547C12v1Ev,
  (VTBL_ENTRY)&_ZN7S8547C12v2Ev,
  (VTBL_ENTRY)&_ZN7S8547C12v3Ev,
  (VTBL_ENTRY)&_ZN7S8547C12v4Ev,
  (VTBL_ENTRY)&_ZN7S8547C12v5Ev,
  (VTBL_ENTRY)&_ZN7S8547C12v6Ev,
  (VTBL_ENTRY)&_ZN7S8547C12v7Ev,
  (VTBL_ENTRY)&_ZN7S8547C12v8Ev,
  (VTBL_ENTRY)&_ZN7S8547C12v9Ev,
  (VTBL_ENTRY)&_ZN7S8547C13v10Ev,
};
extern VTBL_ENTRY _ZTI7S8547C1[];
extern  VTBL_ENTRY _ZTV7S8547C1[];
Class_Descriptor cd_S8547C1 = {  "S8547C1", // class name
  bases_S8547C1, 1,
  &(vtc_S8547C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(9112,8936), // object size
  NSPAIRA(_ZTI7S8547C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S8547C1),37, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8546C2  {
  void *s8546c2f0;
  ::S8547C3_nt s8546c2f1;
  ::S8547C4_nt s8546c2f2[4];
  char s8546c2f3;
  ::S3799C24_nt s8546c2f4;
  void *s8546c2f5;
  int s8546c2f6;
  void *s8546c2f7;
  int s8546c2f8;
  virtual  ~S8546C2(); // _ZN7S8546C2D1Ev
  virtual void  v11(); // _ZN7S8546C23v11Ev
  virtual void  v12(); // _ZN7S8546C23v12Ev
  virtual void  v13(); // _ZN7S8546C23v13Ev
  virtual void  v14(); // _ZN7S8546C23v14Ev
  virtual void  v15(); // _ZN7S8546C23v15Ev
  virtual void  v16(); // _ZN7S8546C23v16Ev
  virtual void  v17(); // _ZN7S8546C23v17Ev
  virtual void  v18(); // _ZN7S8546C23v18Ev
  virtual void  v19(); // _ZN7S8546C23v19Ev
  virtual void  v20(); // _ZN7S8546C23v20Ev
  virtual void  v21(); // _ZN7S8546C23v21Ev
  virtual void  v22(); // _ZN7S8546C23v22Ev
  virtual void  v23(); // _ZN7S8546C23v23Ev
  virtual void  v24(); // _ZN7S8546C23v24Ev
  virtual void  v25(); // _ZN7S8546C23v25Ev
  virtual void  v26(); // _ZN7S8546C23v26Ev
  virtual void  v27(); // _ZN7S8546C23v27Ev
  virtual void  v28(); // _ZN7S8546C23v28Ev
  virtual void  v29(); // _ZN7S8546C23v29Ev
  virtual void  v30(); // _ZN7S8546C23v30Ev
  virtual void  v31(); // _ZN7S8546C23v31Ev
  virtual void  v32(); // _ZN7S8546C23v32Ev
  virtual void  v33(); // _ZN7S8546C23v33Ev
  S8546C2(); // tgen
};
//SIG(-1 S8546C2) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp FC2{ vd m Fi[2] FL Fi[4]} FC3{ vd m Fi[2] FL[3] Fc[2048] Fi[6] FL Fi[4] Fp[2] Fc}[4] Fc FC4{ m FC5{ Fl[4]}} Fp Fi Fp Fi}


 S8546C2 ::~S8546C2(){ note_dtor("S8546C2", this);}
void  S8546C2 ::v11(){vfunc_called(this, "_ZN7S8546C23v11Ev");}
void  S8546C2 ::v12(){vfunc_called(this, "_ZN7S8546C23v12Ev");}
void  S8546C2 ::v13(){vfunc_called(this, "_ZN7S8546C23v13Ev");}
void  S8546C2 ::v14(){vfunc_called(this, "_ZN7S8546C23v14Ev");}
void  S8546C2 ::v15(){vfunc_called(this, "_ZN7S8546C23v15Ev");}
void  S8546C2 ::v16(){vfunc_called(this, "_ZN7S8546C23v16Ev");}
void  S8546C2 ::v17(){vfunc_called(this, "_ZN7S8546C23v17Ev");}
void  S8546C2 ::v18(){vfunc_called(this, "_ZN7S8546C23v18Ev");}
void  S8546C2 ::v19(){vfunc_called(this, "_ZN7S8546C23v19Ev");}
void  S8546C2 ::v20(){vfunc_called(this, "_ZN7S8546C23v20Ev");}
void  S8546C2 ::v21(){vfunc_called(this, "_ZN7S8546C23v21Ev");}
void  S8546C2 ::v22(){vfunc_called(this, "_ZN7S8546C23v22Ev");}
void  S8546C2 ::v23(){vfunc_called(this, "_ZN7S8546C23v23Ev");}
void  S8546C2 ::v24(){vfunc_called(this, "_ZN7S8546C23v24Ev");}
void  S8546C2 ::v25(){vfunc_called(this, "_ZN7S8546C23v25Ev");}
void  S8546C2 ::v26(){vfunc_called(this, "_ZN7S8546C23v26Ev");}
void  S8546C2 ::v27(){vfunc_called(this, "_ZN7S8546C23v27Ev");}
void  S8546C2 ::v28(){vfunc_called(this, "_ZN7S8546C23v28Ev");}
void  S8546C2 ::v29(){vfunc_called(this, "_ZN7S8546C23v29Ev");}
void  S8546C2 ::v30(){vfunc_called(this, "_ZN7S8546C23v30Ev");}
void  S8546C2 ::v31(){vfunc_called(this, "_ZN7S8546C23v31Ev");}
void  S8546C2 ::v32(){vfunc_called(this, "_ZN7S8546C23v32Ev");}
void  S8546C2 ::v33(){vfunc_called(this, "_ZN7S8546C23v33Ev");}
S8546C2 ::S8546C2(){ note_ctor("S8546C2", this);} // tgen

static void Test_S8546C2()
{
  extern Class_Descriptor cd_S8546C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(1097,2165)];
    init_test(&cd_S8546C2, buf);
    S8546C2 *dp, &lv = *(dp=new (buf) S8546C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8768,8656), "sizeof(S8546C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8546C2)");
    check_field_offset(lv, s8546c2f0, ABISELECT(8,4), "S8546C2.s8546c2f0");
    check_field_offset(lv, s8546c2f1, ABISELECT(16,8), "S8546C2.s8546c2f1");
    check_field_offset(lv, s8546c2f2, ABISELECT(56,44), "S8546C2.s8546c2f2");
    check_field_offset(lv, s8546c2f3, ABISELECT(8696,8620), "S8546C2.s8546c2f3");
    check_field_offset(lv, s8546c2f4, ABISELECT(8704,8624), "S8546C2.s8546c2f4");
    check_field_offset(lv, s8546c2f5, ABISELECT(8736,8640), "S8546C2.s8546c2f5");
    check_field_offset(lv, s8546c2f6, ABISELECT(8744,8644), "S8546C2.s8546c2f6");
    check_field_offset(lv, s8546c2f7, ABISELECT(8752,8648), "S8546C2.s8546c2f7");
    check_field_offset(lv, s8546c2f8, ABISELECT(8760,8652), "S8546C2.s8546c2f8");
    test_class_info(&lv, &cd_S8546C2);
    dp->~S8546C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8546C2(Test_S8546C2, "S8546C2", ABISELECT(8768,8656));

#else // __cplusplus

extern void _ZN7S8546C2C1Ev();
extern void _ZN7S8546C2D1Ev();
Name_Map name_map_S8546C2[] = {
  NSPAIR(_ZN7S8546C2C1Ev),
  NSPAIR(_ZN7S8546C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S8546C2[];
extern void _ZN7S8546C2D1Ev();
extern void _ZN7S8546C2D0Ev();
extern void _ZN7S8546C23v11Ev();
extern void _ZN7S8546C23v12Ev();
extern void _ZN7S8546C23v13Ev();
extern void _ZN7S8546C23v14Ev();
extern void _ZN7S8546C23v15Ev();
extern void _ZN7S8546C23v16Ev();
extern void _ZN7S8546C23v17Ev();
extern void _ZN7S8546C23v18Ev();
extern void _ZN7S8546C23v19Ev();
extern void _ZN7S8546C23v20Ev();
extern void _ZN7S8546C23v21Ev();
extern void _ZN7S8546C23v22Ev();
extern void _ZN7S8546C23v23Ev();
extern void _ZN7S8546C23v24Ev();
extern void _ZN7S8546C23v25Ev();
extern void _ZN7S8546C23v26Ev();
extern void _ZN7S8546C23v27Ev();
extern void _ZN7S8546C23v28Ev();
extern void _ZN7S8546C23v29Ev();
extern void _ZN7S8546C23v30Ev();
extern void _ZN7S8546C23v31Ev();
extern void _ZN7S8546C23v32Ev();
extern void _ZN7S8546C23v33Ev();
static  VTBL_ENTRY vtc_S8546C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S8546C2[0]),
  (VTBL_ENTRY)&_ZN7S8546C2D1Ev,
  (VTBL_ENTRY)&_ZN7S8546C2D0Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v11Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v12Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v13Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v14Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v15Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v16Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v17Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v18Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v19Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v20Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v21Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v22Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v23Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v24Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v25Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v26Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v27Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v28Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v29Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v30Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v31Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v32Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v33Ev,
};
extern VTBL_ENTRY _ZTI7S8546C2[];
extern  VTBL_ENTRY _ZTV7S8546C2[];
Class_Descriptor cd_S8546C2 = {  "S8546C2", // class name
  0,0,//no base classes
  &(vtc_S8546C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8768,8656), // object size
  NSPAIRA(_ZTI7S8546C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S8546C2),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8546C10  {
  virtual  ~S8546C10(); // _ZN8S8546C10D1Ev
  virtual void  v34(); // _ZN8S8546C103v34Ev
  virtual void  v35(); // _ZN8S8546C103v35Ev
  virtual void  v36(); // _ZN8S8546C103v36Ev
  virtual void  v37(); // _ZN8S8546C103v37Ev
  virtual void  v38(); // _ZN8S8546C103v38Ev
  virtual void  v39(); // _ZN8S8546C103v39Ev
  S8546C10(); // tgen
};
//SIG(-1 S8546C10) C1{ vd v1 v2 v3 v4 v5 v6}


 S8546C10 ::~S8546C10(){ note_dtor("S8546C10", this);}
void  S8546C10 ::v34(){vfunc_called(this, "_ZN8S8546C103v34Ev");}
void  S8546C10 ::v35(){vfunc_called(this, "_ZN8S8546C103v35Ev");}
void  S8546C10 ::v36(){vfunc_called(this, "_ZN8S8546C103v36Ev");}
void  S8546C10 ::v37(){vfunc_called(this, "_ZN8S8546C103v37Ev");}
void  S8546C10 ::v38(){vfunc_called(this, "_ZN8S8546C103v38Ev");}
void  S8546C10 ::v39(){vfunc_called(this, "_ZN8S8546C103v39Ev");}
S8546C10 ::S8546C10(){ note_ctor("S8546C10", this);} // tgen

static void Test_S8546C10()
{
  extern Class_Descriptor cd_S8546C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S8546C10, buf);
    S8546C10 *dp, &lv = *(dp=new (buf) S8546C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S8546C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8546C10)");
    test_class_info(&lv, &cd_S8546C10);
    dp->~S8546C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8546C10(Test_S8546C10, "S8546C10", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S8546C10C1Ev();
extern void _ZN8S8546C10D1Ev();
Name_Map name_map_S8546C10[] = {
  NSPAIR(_ZN8S8546C10C1Ev),
  NSPAIR(_ZN8S8546C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S8546C10[];
extern void _ZN8S8546C10D1Ev();
extern void _ZN8S8546C10D0Ev();
extern void _ZN8S8546C103v34Ev();
extern void _ZN8S8546C103v35Ev();
extern void _ZN8S8546C103v36Ev();
extern void _ZN8S8546C103v37Ev();
extern void _ZN8S8546C103v38Ev();
extern void _ZN8S8546C103v39Ev();
static  VTBL_ENTRY vtc_S8546C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S8546C10[0]),
  (VTBL_ENTRY)&_ZN8S8546C10D1Ev,
  (VTBL_ENTRY)&_ZN8S8546C10D0Ev,
  (VTBL_ENTRY)&_ZN8S8546C103v34Ev,
  (VTBL_ENTRY)&_ZN8S8546C103v35Ev,
  (VTBL_ENTRY)&_ZN8S8546C103v36Ev,
  (VTBL_ENTRY)&_ZN8S8546C103v37Ev,
  (VTBL_ENTRY)&_ZN8S8546C103v38Ev,
  (VTBL_ENTRY)&_ZN8S8546C103v39Ev,
};
extern VTBL_ENTRY _ZTI8S8546C10[];
extern  VTBL_ENTRY _ZTV8S8546C10[];
Class_Descriptor cd_S8546C10 = {  "S8546C10", // class name
  0,0,//no base classes
  &(vtc_S8546C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S8546C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S8546C10),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8546C12_nt  {
  ::S3799C25_nt s8546c12f0;
  void  mf8546c12(); // _ZN11S8546C12_nt9mf8546c12Ev
};
//SIG(-1 S8546C12_nt) C1{ m FC2{ Fl[4]}}


void  S8546C12_nt ::mf8546c12(){}

//skip512 S8546C12_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8546C9  : S8546C10 {
  void *s8546c9f0;
  ::S3802C37 s8546c9f1;
  ::S8546C12_nt s8546c9f2;
  char s8546c9f3;
  int s8546c9f4;
  virtual  ~S8546C9(); // _ZN7S8546C9D1Ev
  virtual void  v40(); // _ZN7S8546C93v40Ev
  virtual void  v41(); // _ZN7S8546C93v41Ev
  virtual void  v42(); // _ZN7S8546C93v42Ev
  virtual void  v43(); // _ZN7S8546C93v43Ev
  S8546C9(); // tgen
};
//SIG(-1 S8546C9) C1{ BC2{ vd v5 v6 v7 v8 v9 v10} vd v1 v2 v3 v4 Fp FC3{ m Fp} FC4{ m FC5{ Fl[4]}} Fc Fi}


 S8546C9 ::~S8546C9(){ note_dtor("S8546C9", this);}
void  S8546C9 ::v40(){vfunc_called(this, "_ZN7S8546C93v40Ev");}
void  S8546C9 ::v41(){vfunc_called(this, "_ZN7S8546C93v41Ev");}
void  S8546C9 ::v42(){vfunc_called(this, "_ZN7S8546C93v42Ev");}
void  S8546C9 ::v43(){vfunc_called(this, "_ZN7S8546C93v43Ev");}
S8546C9 ::S8546C9(){ note_ctor("S8546C9", this);} // tgen

static void Test_S8546C9()
{
  extern Class_Descriptor cd_S8546C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_S8546C9, buf);
    S8546C9 *dp, &lv = *(dp=new (buf) S8546C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(S8546C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8546C9)");
    check_base_class_offset(lv, (S8546C10*), 0, "S8546C9");
    check_field_offset(lv, s8546c9f0, ABISELECT(8,4), "S8546C9.s8546c9f0");
    check_field_offset(lv, s8546c9f1, ABISELECT(16,8), "S8546C9.s8546c9f1");
    check_field_offset(lv, s8546c9f2, ABISELECT(24,12), "S8546C9.s8546c9f2");
    check_field_offset(lv, s8546c9f3, ABISELECT(56,28), "S8546C9.s8546c9f3");
    check_field_offset(lv, s8546c9f4, ABISELECT(60,32), "S8546C9.s8546c9f4");
    test_class_info(&lv, &cd_S8546C9);
    dp->~S8546C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8546C9(Test_S8546C9, "S8546C9", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7S8546C9C1Ev();
extern void _ZN7S8546C9D1Ev();
Name_Map name_map_S8546C9[] = {
  NSPAIR(_ZN7S8546C9C1Ev),
  NSPAIR(_ZN7S8546C9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S8546C10;
extern VTBL_ENTRY _ZTI8S8546C10[];
extern  VTBL_ENTRY _ZTV8S8546C10[];
static Base_Class bases_S8546C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S8546C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S8546C9[];
extern void _ZN7S8546C9D1Ev();
extern void _ZN7S8546C9D0Ev();
extern void _ZN8S8546C103v34Ev();
extern void _ZN8S8546C103v35Ev();
extern void _ZN8S8546C103v36Ev();
extern void _ZN8S8546C103v37Ev();
extern void _ZN8S8546C103v38Ev();
extern void _ZN8S8546C103v39Ev();
extern void _ZN7S8546C93v40Ev();
extern void _ZN7S8546C93v41Ev();
extern void _ZN7S8546C93v42Ev();
extern void _ZN7S8546C93v43Ev();
static  VTBL_ENTRY vtc_S8546C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S8546C9[0]),
  (VTBL_ENTRY)&_ZN7S8546C9D1Ev,
  (VTBL_ENTRY)&_ZN7S8546C9D0Ev,
  (VTBL_ENTRY)&_ZN8S8546C103v34Ev,
  (VTBL_ENTRY)&_ZN8S8546C103v35Ev,
  (VTBL_ENTRY)&_ZN8S8546C103v36Ev,
  (VTBL_ENTRY)&_ZN8S8546C103v37Ev,
  (VTBL_ENTRY)&_ZN8S8546C103v38Ev,
  (VTBL_ENTRY)&_ZN8S8546C103v39Ev,
  (VTBL_ENTRY)&_ZN7S8546C93v40Ev,
  (VTBL_ENTRY)&_ZN7S8546C93v41Ev,
  (VTBL_ENTRY)&_ZN7S8546C93v42Ev,
  (VTBL_ENTRY)&_ZN7S8546C93v43Ev,
};
extern VTBL_ENTRY _ZTI7S8546C9[];
extern  VTBL_ENTRY _ZTV7S8546C9[];
Class_Descriptor cd_S8546C9 = {  "S8546C9", // class name
  bases_S8546C9, 1,
  &(vtc_S8546C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7S8546C9),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S8546C9),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8546C8  : S8546C9 {
  int s8546c8f0;
  ::S3799C31 s8546c8f1;
  ::S2122C20_nt s8546c8f2;
  ::S2122C20_nt s8546c8f3;
  virtual  ~S8546C8(); // _ZN7S8546C8D1Ev
  virtual void  v44(); // _ZN7S8546C83v44Ev
  S8546C8(); // tgen
};
//SIG(-1 S8546C8) C1{ BC2{ BC3{ vd v2 v3 v4 v5 v6 v7} vd v8 v9 v10 v11 Fp FC4{ m Fp} FC5{ m FC6{ Fl[4]}} Fc Fi} vd v1 Fi FC7{ m Fp Fi[2] FC8{ m Fp}} FC9{ m Fp Fi FC10{ m}} FC9}


 S8546C8 ::~S8546C8(){ note_dtor("S8546C8", this);}
void  S8546C8 ::v44(){vfunc_called(this, "_ZN7S8546C83v44Ev");}
S8546C8 ::S8546C8(){ note_ctor("S8546C8", this);} // tgen

static void Test_S8546C8()
{
  extern Class_Descriptor cd_S8546C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(17,21)];
    init_test(&cd_S8546C8, buf);
    S8546C8 *dp, &lv = *(dp=new (buf) S8546C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,80), "sizeof(S8546C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8546C8)");
    check_base_class_offset(lv, (S8546C10*)(S8546C9*), 0, "S8546C8");
    check_base_class_offset(lv, (S8546C9*), 0, "S8546C8");
    check_field_offset(lv, s8546c8f0, ABISELECT(64,36), "S8546C8.s8546c8f0");
    check_field_offset(lv, s8546c8f1, ABISELECT(72,40), "S8546C8.s8546c8f1");
    check_field_offset(lv, s8546c8f2, ABISELECT(96,56), "S8546C8.s8546c8f2");
    check_field_offset(lv, s8546c8f3, ABISELECT(112,68), "S8546C8.s8546c8f3");
    test_class_info(&lv, &cd_S8546C8);
    dp->~S8546C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8546C8(Test_S8546C8, "S8546C8", ABISELECT(128,80));

#else // __cplusplus

extern void _ZN7S8546C8C1Ev();
extern void _ZN7S8546C8D1Ev();
Name_Map name_map_S8546C8[] = {
  NSPAIR(_ZN7S8546C8C1Ev),
  NSPAIR(_ZN7S8546C8D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S8546C10;
extern VTBL_ENTRY _ZTI8S8546C10[];
extern  VTBL_ENTRY _ZTV8S8546C10[];
extern Class_Descriptor cd_S8546C9;
extern VTBL_ENTRY _ZTI7S8546C9[];
extern  VTBL_ENTRY _ZTV7S8546C9[];
static Base_Class bases_S8546C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S8546C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S8546C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S8546C8[];
extern void _ZN7S8546C8D1Ev();
extern void _ZN7S8546C8D0Ev();
extern void _ZN8S8546C103v34Ev();
extern void _ZN8S8546C103v35Ev();
extern void _ZN8S8546C103v36Ev();
extern void _ZN8S8546C103v37Ev();
extern void _ZN8S8546C103v38Ev();
extern void _ZN8S8546C103v39Ev();
extern void _ZN7S8546C93v40Ev();
extern void _ZN7S8546C93v41Ev();
extern void _ZN7S8546C93v42Ev();
extern void _ZN7S8546C93v43Ev();
extern void _ZN7S8546C83v44Ev();
static  VTBL_ENTRY vtc_S8546C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S8546C8[0]),
  (VTBL_ENTRY)&_ZN7S8546C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8546C8D0Ev,
  (VTBL_ENTRY)&_ZN8S8546C103v34Ev,
  (VTBL_ENTRY)&_ZN8S8546C103v35Ev,
  (VTBL_ENTRY)&_ZN8S8546C103v36Ev,
  (VTBL_ENTRY)&_ZN8S8546C103v37Ev,
  (VTBL_ENTRY)&_ZN8S8546C103v38Ev,
  (VTBL_ENTRY)&_ZN8S8546C103v39Ev,
  (VTBL_ENTRY)&_ZN7S8546C93v40Ev,
  (VTBL_ENTRY)&_ZN7S8546C93v41Ev,
  (VTBL_ENTRY)&_ZN7S8546C93v42Ev,
  (VTBL_ENTRY)&_ZN7S8546C93v43Ev,
  (VTBL_ENTRY)&_ZN7S8546C83v44Ev,
};
extern VTBL_ENTRY _ZTI7S8546C8[];
extern  VTBL_ENTRY _ZTV7S8546C8[];
Class_Descriptor cd_S8546C8 = {  "S8546C8", // class name
  bases_S8546C8, 2,
  &(vtc_S8546C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(128,80), // object size
  NSPAIRA(_ZTI7S8546C8),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S8546C8),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8546C7  : S8546C8 {
  int s8546c7f0;
  virtual  ~S8546C7(); // _ZN7S8546C7D1Ev
  S8546C7(); // tgen
};
//SIG(-1 S8546C7) C1{ BC2{ BC3{ BC4{ vd v1 v2 v3 v4 v5 v6} vd v7 v8 v9 v10 Fp FC5{ m Fp} FC6{ m FC7{ Fl[4]}} Fc Fi} vd v11 Fi FC8{ m Fp Fi[2] FC9{ m Fp}} FC10{ m Fp Fi FC11{ m}} FC10} vd Fi}


 S8546C7 ::~S8546C7(){ note_dtor("S8546C7", this);}
S8546C7 ::S8546C7(){ note_ctor("S8546C7", this);} // tgen

static void Test_S8546C7()
{
  extern Class_Descriptor cd_S8546C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,22)];
    init_test(&cd_S8546C7, buf);
    S8546C7 *dp, &lv = *(dp=new (buf) S8546C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,84), "sizeof(S8546C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8546C7)");
    check_base_class_offset(lv, (S8546C10*)(S8546C9*)(S8546C8*), 0, "S8546C7");
    check_base_class_offset(lv, (S8546C9*)(S8546C8*), 0, "S8546C7");
    check_base_class_offset(lv, (S8546C8*), 0, "S8546C7");
    check_field_offset(lv, s8546c7f0, ABISELECT(128,80), "S8546C7.s8546c7f0");
    test_class_info(&lv, &cd_S8546C7);
    dp->~S8546C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8546C7(Test_S8546C7, "S8546C7", ABISELECT(136,84));

#else // __cplusplus

extern void _ZN7S8546C7C1Ev();
extern void _ZN7S8546C7D1Ev();
Name_Map name_map_S8546C7[] = {
  NSPAIR(_ZN7S8546C7C1Ev),
  NSPAIR(_ZN7S8546C7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S8546C10;
extern VTBL_ENTRY _ZTI8S8546C10[];
extern  VTBL_ENTRY _ZTV8S8546C10[];
extern Class_Descriptor cd_S8546C9;
extern VTBL_ENTRY _ZTI7S8546C9[];
extern  VTBL_ENTRY _ZTV7S8546C9[];
extern Class_Descriptor cd_S8546C8;
extern VTBL_ENTRY _ZTI7S8546C8[];
extern  VTBL_ENTRY _ZTV7S8546C8[];
static Base_Class bases_S8546C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S8546C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S8546C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S8546C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S8546C7[];
extern void _ZN7S8546C7D1Ev();
extern void _ZN7S8546C7D0Ev();
extern void _ZN8S8546C103v34Ev();
extern void _ZN8S8546C103v35Ev();
extern void _ZN8S8546C103v36Ev();
extern void _ZN8S8546C103v37Ev();
extern void _ZN8S8546C103v38Ev();
extern void _ZN8S8546C103v39Ev();
extern void _ZN7S8546C93v40Ev();
extern void _ZN7S8546C93v41Ev();
extern void _ZN7S8546C93v42Ev();
extern void _ZN7S8546C93v43Ev();
extern void _ZN7S8546C83v44Ev();
static  VTBL_ENTRY vtc_S8546C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S8546C7[0]),
  (VTBL_ENTRY)&_ZN7S8546C7D1Ev,
  (VTBL_ENTRY)&_ZN7S8546C7D0Ev,
  (VTBL_ENTRY)&_ZN8S8546C103v34Ev,
  (VTBL_ENTRY)&_ZN8S8546C103v35Ev,
  (VTBL_ENTRY)&_ZN8S8546C103v36Ev,
  (VTBL_ENTRY)&_ZN8S8546C103v37Ev,
  (VTBL_ENTRY)&_ZN8S8546C103v38Ev,
  (VTBL_ENTRY)&_ZN8S8546C103v39Ev,
  (VTBL_ENTRY)&_ZN7S8546C93v40Ev,
  (VTBL_ENTRY)&_ZN7S8546C93v41Ev,
  (VTBL_ENTRY)&_ZN7S8546C93v42Ev,
  (VTBL_ENTRY)&_ZN7S8546C93v43Ev,
  (VTBL_ENTRY)&_ZN7S8546C83v44Ev,
};
extern VTBL_ENTRY _ZTI7S8546C7[];
extern  VTBL_ENTRY _ZTV7S8546C7[];
Class_Descriptor cd_S8546C7 = {  "S8546C7", // class name
  bases_S8546C7, 3,
  &(vtc_S8546C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,84), // object size
  NSPAIRA(_ZTI7S8546C7),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S8546C7),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8546C19_nt  {
  long s8546c19f0;
};
//SIG(-1 S8546C19_nt) C1{ Fl}



//skip512 S8546C19_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8546C17  {
  __tsi64 s8546c17f0;
  ::S3799C37 s8546c17f1;
  ::S3799C24_nt s8546c17f2;
  ::S8546C19_nt s8546c17f3;
  ::S8546C19_nt s8546c17f4;
  void  mf8546c17(); // _ZN8S8546C179mf8546c17Ev
};
//SIG(-1 S8546C17) C1{ m FL FC2{ m Fp} FC3{ m FC4{ Fl[4]}} FC5{ Fl} FC5}


void  S8546C17 ::mf8546c17(){}

static void Test_S8546C17()
{
  {
    init_simple_test("S8546C17");
    S8546C17 lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(S8546C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8546C17)");
    check_field_offset(lv, s8546c17f0, 0, "S8546C17.s8546c17f0");
    check_field_offset(lv, s8546c17f1, 8, "S8546C17.s8546c17f1");
    check_field_offset(lv, s8546c17f2, ABISELECT(16,12), "S8546C17.s8546c17f2");
    check_field_offset(lv, s8546c17f3, ABISELECT(48,28), "S8546C17.s8546c17f3");
    check_field_offset(lv, s8546c17f4, ABISELECT(56,32), "S8546C17.s8546c17f4");
  }
}
static Arrange_To_Call_Me vS8546C17(Test_S8546C17, "S8546C17", ABISELECT(64,36));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8546C1  : S8546C2 {
  ::S8546C7 s8546c1f0;
  ::S8546C8 s8546c1f1;
  void *s8546c1f2;
  char s8546c1f3;
  ::S8546C17 s8546c1f4;
  virtual  ~S8546C1(); // _ZN7S8546C1D1Ev
  virtual void  v1(); // _ZN7S8546C12v1Ev
  virtual void  v2(); // _ZN7S8546C12v2Ev
  virtual void  v3(); // _ZN7S8546C12v3Ev
  virtual void  v4(); // _ZN7S8546C12v4Ev
  virtual void  v5(); // _ZN7S8546C12v5Ev
  virtual void  v6(); // _ZN7S8546C12v6Ev
  virtual void  v7(); // _ZN7S8546C12v7Ev
  virtual void  v8(); // _ZN7S8546C12v8Ev
  virtual void  v9(); // _ZN7S8546C12v9Ev
  virtual void  v10(); // _ZN7S8546C13v10Ev
  S8546C1(); // tgen
};
//SIG(1 S8546C1) C1{ BC2{ vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 Fp FC3{ vd m Fi[2] FL Fi[4]} FC4{ vd m Fi[2] FL[3] Fc[2048] Fi[6] FL Fi[4] Fp[2] Fc}[4] Fc FC5{ m FC6{ Fl[4]}} Fp Fi Fp Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 FC7{ BC8{ BC9{ BC10{ vd v34 v35 v36 v37 v38 v39} vd v40 v41 v42 v43 Fp FC11{ m Fp} FC12{ m FC6} Fc Fi} vd v44 Fi FC13{ m Fp Fi[2] FC14{ m Fp}} FC15{ m Fp Fi FC16{ m}} FC15} vd Fi} FC8 Fp Fc FC17{ m FL FC18{ m Fp} FC5 FC19{ Fl} FC19}}


 S8546C1 ::~S8546C1(){ note_dtor("S8546C1", this);}
void  S8546C1 ::v1(){vfunc_called(this, "_ZN7S8546C12v1Ev");}
void  S8546C1 ::v2(){vfunc_called(this, "_ZN7S8546C12v2Ev");}
void  S8546C1 ::v3(){vfunc_called(this, "_ZN7S8546C12v3Ev");}
void  S8546C1 ::v4(){vfunc_called(this, "_ZN7S8546C12v4Ev");}
void  S8546C1 ::v5(){vfunc_called(this, "_ZN7S8546C12v5Ev");}
void  S8546C1 ::v6(){vfunc_called(this, "_ZN7S8546C12v6Ev");}
void  S8546C1 ::v7(){vfunc_called(this, "_ZN7S8546C12v7Ev");}
void  S8546C1 ::v8(){vfunc_called(this, "_ZN7S8546C12v8Ev");}
void  S8546C1 ::v9(){vfunc_called(this, "_ZN7S8546C12v9Ev");}
void  S8546C1 ::v10(){vfunc_called(this, "_ZN7S8546C13v10Ev");}
S8546C1 ::S8546C1(){ note_ctor("S8546C1", this);} // tgen

static void Test_S8546C1()
{
  extern Class_Descriptor cd_S8546C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(1140,2217)];
    init_test(&cd_S8546C1, buf);
    S8546C1 *dp, &lv = *(dp=new (buf) S8546C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(9112,8864), "sizeof(S8546C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8546C1)");
    check_base_class_offset(lv, (S8546C2*), 0, "S8546C1");
    check_field_offset(lv, s8546c1f0, ABISELECT(8768,8656), "S8546C1.s8546c1f0");
    check_field_offset(lv, s8546c1f1, ABISELECT(8904,8740), "S8546C1.s8546c1f1");
    check_field_offset(lv, s8546c1f2, ABISELECT(9032,8820), "S8546C1.s8546c1f2");
    check_field_offset(lv, s8546c1f3, ABISELECT(9040,8824), "S8546C1.s8546c1f3");
    check_field_offset(lv, s8546c1f4, ABISELECT(9048,8828), "S8546C1.s8546c1f4");
    test_class_info(&lv, &cd_S8546C1);
    dp->~S8546C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8546C1(Test_S8546C1, "S8546C1", ABISELECT(9112,8864));

#else // __cplusplus

extern void _ZN7S8546C1C1Ev();
extern void _ZN7S8546C1D1Ev();
Name_Map name_map_S8546C1[] = {
  NSPAIR(_ZN7S8546C1C1Ev),
  NSPAIR(_ZN7S8546C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S8546C2;
extern VTBL_ENTRY _ZTI7S8546C2[];
extern  VTBL_ENTRY _ZTV7S8546C2[];
static Base_Class bases_S8546C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S8546C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S8546C1[];
extern void _ZN7S8546C1D1Ev();
extern void _ZN7S8546C1D0Ev();
extern void _ZN7S8546C23v11Ev();
extern void _ZN7S8546C23v12Ev();
extern void _ZN7S8546C23v13Ev();
extern void _ZN7S8546C23v14Ev();
extern void _ZN7S8546C23v15Ev();
extern void _ZN7S8546C23v16Ev();
extern void _ZN7S8546C23v17Ev();
extern void _ZN7S8546C23v18Ev();
extern void _ZN7S8546C23v19Ev();
extern void _ZN7S8546C23v20Ev();
extern void _ZN7S8546C23v21Ev();
extern void _ZN7S8546C23v22Ev();
extern void _ZN7S8546C23v23Ev();
extern void _ZN7S8546C23v24Ev();
extern void _ZN7S8546C23v25Ev();
extern void _ZN7S8546C23v26Ev();
extern void _ZN7S8546C23v27Ev();
extern void _ZN7S8546C23v28Ev();
extern void _ZN7S8546C23v29Ev();
extern void _ZN7S8546C23v30Ev();
extern void _ZN7S8546C23v31Ev();
extern void _ZN7S8546C23v32Ev();
extern void _ZN7S8546C23v33Ev();
extern void _ZN7S8546C12v1Ev();
extern void _ZN7S8546C12v2Ev();
extern void _ZN7S8546C12v3Ev();
extern void _ZN7S8546C12v4Ev();
extern void _ZN7S8546C12v5Ev();
extern void _ZN7S8546C12v6Ev();
extern void _ZN7S8546C12v7Ev();
extern void _ZN7S8546C12v8Ev();
extern void _ZN7S8546C12v9Ev();
extern void _ZN7S8546C13v10Ev();
static  VTBL_ENTRY vtc_S8546C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S8546C1[0]),
  (VTBL_ENTRY)&_ZN7S8546C1D1Ev,
  (VTBL_ENTRY)&_ZN7S8546C1D0Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v11Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v12Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v13Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v14Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v15Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v16Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v17Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v18Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v19Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v20Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v21Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v22Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v23Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v24Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v25Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v26Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v27Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v28Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v29Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v30Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v31Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v32Ev,
  (VTBL_ENTRY)&_ZN7S8546C23v33Ev,
  (VTBL_ENTRY)&_ZN7S8546C12v1Ev,
  (VTBL_ENTRY)&_ZN7S8546C12v2Ev,
  (VTBL_ENTRY)&_ZN7S8546C12v3Ev,
  (VTBL_ENTRY)&_ZN7S8546C12v4Ev,
  (VTBL_ENTRY)&_ZN7S8546C12v5Ev,
  (VTBL_ENTRY)&_ZN7S8546C12v6Ev,
  (VTBL_ENTRY)&_ZN7S8546C12v7Ev,
  (VTBL_ENTRY)&_ZN7S8546C12v8Ev,
  (VTBL_ENTRY)&_ZN7S8546C12v9Ev,
  (VTBL_ENTRY)&_ZN7S8546C13v10Ev,
};
extern VTBL_ENTRY _ZTI7S8546C1[];
extern  VTBL_ENTRY _ZTV7S8546C1[];
Class_Descriptor cd_S8546C1 = {  "S8546C1", // class name
  bases_S8546C1, 1,
  &(vtc_S8546C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(9112,8864), // object size
  NSPAIRA(_ZTI7S8546C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S8546C1),37, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S13767C5  {
  ::S12863C40 s13767c5f0;
  ::S12863C41 s13767c5f1;
};
//SIG(1 S13767C5) U1{ FC2{ Fc Fl Fi FC3{ Fi Fc Fi Fi Fc Fi Fc} FC4{ Fc FC5{ Fi FU6{ FC7{ Fc Fc Fc} FC8{ Fi Fi Fc} FC9{ Fc Fc} FC10{ Fs Fs} FC11{ Fs Fc Fc} FC12{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC9 FC13{ Fc Fc Fc[128]} FC14{ Fc Fc} FC15{ Fc Fc[128]} FC16{ Fc Fc[32]} FC15 FC16 FC17{ Fc Fc Fc Fc[134]} FC18{ Fc} FC19{ FC20{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC18 FC21{ Fi} FC21 FC22{ Fi Fc Fc[226]}}}[7] Fs Fc[255]}} FC23{ Fc Fi Fl Fi FC3 FC4}}

#endif // __cplusplus
#ifdef __cplusplus

struct  S13767C4  {
  char s13767c4f0;
  int s13767c4f1;
  int s13767c4f2;
  ::S13767C5 s13767c4f3;
};
//SIG(1 S13767C4) C1{ Fc Fi[2] FU2{ FC3{ Fc Fl Fi FC4{ Fi Fc Fi Fi Fc Fi Fc} FC5{ Fc FC6{ Fi FU7{ FC8{ Fc Fc Fc} FC9{ Fi Fi Fc} FC10{ Fc Fc} FC11{ Fs Fs} FC12{ Fs Fc Fc} FC13{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC10 FC14{ Fc Fc Fc[128]} FC15{ Fc Fc} FC16{ Fc Fc[128]} FC17{ Fc Fc[32]} FC16 FC17 FC18{ Fc Fc Fc Fc[134]} FC19{ Fc} FC20{ FC21{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC19 FC22{ Fi} FC22 FC23{ Fi Fc Fc[226]}}}[7] Fs Fc[255]}} FC24{ Fc Fi Fl Fi FC4 FC5}}}



static void Test_S13767C4()
{
  {
    init_simple_test("S13767C4");
    S13767C4 lv;
    check2(sizeof(lv), ABISELECT(1984,1972), "sizeof(S13767C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S13767C4)");
    check_field_offset(lv, s13767c4f0, 0, "S13767C4.s13767c4f0");
    check_field_offset(lv, s13767c4f1, 4, "S13767C4.s13767c4f1");
    check_field_offset(lv, s13767c4f2, 8, "S13767C4.s13767c4f2");
    check_field_offset(lv, s13767c4f3, ABISELECT(16,12), "S13767C4.s13767c4f3");
  }
}
static Arrange_To_Call_Me vS13767C4(Test_S13767C4, "S13767C4", ABISELECT(1984,1972));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S13767C2  {
  ::S12863C32 s13767c2f0;
  ::S13767C4 s13767c2f1;
};
//SIG(1 S13767C2) U1{ FC2{ Fi Fi} FC3{ Fc Fi Fi FU4{ FC5{ Fc Fl Fi FC6{ Fi Fc Fi Fi Fc Fi Fc} FC7{ Fc FC8{ Fi FU9{ FC10{ Fc Fc Fc} FC11{ Fi Fi Fc} FC12{ Fc Fc} FC13{ Fs Fs} FC14{ Fs Fc Fc} FC15{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC12 FC16{ Fc Fc Fc[128]} FC17{ Fc Fc} FC18{ Fc Fc[128]} FC19{ Fc Fc[32]} FC18 FC19 FC20{ Fc Fc Fc Fc[134]} FC21{ Fc} FC22{ FC23{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC21 FC24{ Fi} FC24 FC25{ Fi Fc Fc[226]}}}[7] Fs Fc[255]}} FC26{ Fc Fi Fl Fi FC6 FC7}}}}

#endif // __cplusplus
#ifdef __cplusplus

struct  S13767C1  {
  long s13767c1f0;
  int s13767c1f1;
  ::S13767C2 s13767c1f2;
};
//SIG(1 S13767C1) C1{ Fl Fi FU2{ FC3{ Fi Fi} FC4{ Fc Fi Fi FU5{ FC6{ Fc Fl Fi FC7{ Fi Fc Fi Fi Fc Fi Fc} FC8{ Fc FC9{ Fi FU10{ FC11{ Fc Fc Fc} FC12{ Fi Fi Fc} FC13{ Fc Fc} FC14{ Fs Fs} FC15{ Fs Fc Fc} FC16{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC13 FC17{ Fc Fc Fc[128]} FC18{ Fc Fc} FC19{ Fc Fc[128]} FC20{ Fc Fc[32]} FC19 FC20 FC21{ Fc Fc Fc Fc[134]} FC22{ Fc} FC23{ FC24{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC22 FC25{ Fi} FC25 FC26{ Fi Fc Fc[226]}}}[7] Fs Fc[255]}} FC27{ Fc Fi Fl Fi FC7 FC8}}}}}



static void Test_S13767C1()
{
  {
    init_simple_test("S13767C1");
    S13767C1 lv;
    check2(sizeof(lv), ABISELECT(2000,1980), "sizeof(S13767C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S13767C1)");
    check_field_offset(lv, s13767c1f0, 0, "S13767C1.s13767c1f0");
    check_field_offset(lv, s13767c1f1, ABISELECT(8,4), "S13767C1.s13767c1f1");
    check_field_offset(lv, s13767c1f2, ABISELECT(16,8), "S13767C1.s13767c1f2");
  }
}
static Arrange_To_Call_Me vS13767C1(Test_S13767C1, "S13767C1", ABISELECT(2000,1980));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8548C2  {
  void *s8548c2f0;
  ::S8547C3_nt s8548c2f1;
  ::S8547C4_nt s8548c2f2[4];
  char s8548c2f3;
  ::S3803C24_nt s8548c2f4;
  void *s8548c2f5;
  int s8548c2f6;
  void *s8548c2f7;
  int s8548c2f8;
  virtual  ~S8548C2(); // _ZN7S8548C2D1Ev
  virtual void  v11(); // _ZN7S8548C23v11Ev
  virtual void  v12(); // _ZN7S8548C23v12Ev
  virtual void  v13(); // _ZN7S8548C23v13Ev
  virtual void  v14(); // _ZN7S8548C23v14Ev
  virtual void  v15(); // _ZN7S8548C23v15Ev
  virtual void  v16(); // _ZN7S8548C23v16Ev
  virtual void  v17(); // _ZN7S8548C23v17Ev
  virtual void  v18(); // _ZN7S8548C23v18Ev
  virtual void  v19(); // _ZN7S8548C23v19Ev
  virtual void  v20(); // _ZN7S8548C23v20Ev
  virtual void  v21(); // _ZN7S8548C23v21Ev
  virtual void  v22(); // _ZN7S8548C23v22Ev
  virtual void  v23(); // _ZN7S8548C23v23Ev
  virtual void  v24(); // _ZN7S8548C23v24Ev
  virtual void  v25(); // _ZN7S8548C23v25Ev
  virtual void  v26(); // _ZN7S8548C23v26Ev
  virtual void  v27(); // _ZN7S8548C23v27Ev
  virtual void  v28(); // _ZN7S8548C23v28Ev
  virtual void  v29(); // _ZN7S8548C23v29Ev
  virtual void  v30(); // _ZN7S8548C23v30Ev
  virtual void  v31(); // _ZN7S8548C23v31Ev
  virtual void  v32(); // _ZN7S8548C23v32Ev
  virtual void  v33(); // _ZN7S8548C23v33Ev
  S8548C2(); // tgen
};
//SIG(-1 S8548C2) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp FC2{ vd m Fi[2] FL Fi[4]} FC3{ vd m Fi[2] FL[3] Fc[2048] Fi[6] FL Fi[4] Fp[2] Fc}[4] Fc FC4{ m FL[4]} Fp Fi Fp Fi}


 S8548C2 ::~S8548C2(){ note_dtor("S8548C2", this);}
void  S8548C2 ::v11(){vfunc_called(this, "_ZN7S8548C23v11Ev");}
void  S8548C2 ::v12(){vfunc_called(this, "_ZN7S8548C23v12Ev");}
void  S8548C2 ::v13(){vfunc_called(this, "_ZN7S8548C23v13Ev");}
void  S8548C2 ::v14(){vfunc_called(this, "_ZN7S8548C23v14Ev");}
void  S8548C2 ::v15(){vfunc_called(this, "_ZN7S8548C23v15Ev");}
void  S8548C2 ::v16(){vfunc_called(this, "_ZN7S8548C23v16Ev");}
void  S8548C2 ::v17(){vfunc_called(this, "_ZN7S8548C23v17Ev");}
void  S8548C2 ::v18(){vfunc_called(this, "_ZN7S8548C23v18Ev");}
void  S8548C2 ::v19(){vfunc_called(this, "_ZN7S8548C23v19Ev");}
void  S8548C2 ::v20(){vfunc_called(this, "_ZN7S8548C23v20Ev");}
void  S8548C2 ::v21(){vfunc_called(this, "_ZN7S8548C23v21Ev");}
void  S8548C2 ::v22(){vfunc_called(this, "_ZN7S8548C23v22Ev");}
void  S8548C2 ::v23(){vfunc_called(this, "_ZN7S8548C23v23Ev");}
void  S8548C2 ::v24(){vfunc_called(this, "_ZN7S8548C23v24Ev");}
void  S8548C2 ::v25(){vfunc_called(this, "_ZN7S8548C23v25Ev");}
void  S8548C2 ::v26(){vfunc_called(this, "_ZN7S8548C23v26Ev");}
void  S8548C2 ::v27(){vfunc_called(this, "_ZN7S8548C23v27Ev");}
void  S8548C2 ::v28(){vfunc_called(this, "_ZN7S8548C23v28Ev");}
void  S8548C2 ::v29(){vfunc_called(this, "_ZN7S8548C23v29Ev");}
void  S8548C2 ::v30(){vfunc_called(this, "_ZN7S8548C23v30Ev");}
void  S8548C2 ::v31(){vfunc_called(this, "_ZN7S8548C23v31Ev");}
void  S8548C2 ::v32(){vfunc_called(this, "_ZN7S8548C23v32Ev");}
void  S8548C2 ::v33(){vfunc_called(this, "_ZN7S8548C23v33Ev");}
S8548C2 ::S8548C2(){ note_ctor("S8548C2", this);} // tgen

static void Test_S8548C2()
{
  extern Class_Descriptor cd_S8548C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(1097,2169)];
    init_test(&cd_S8548C2, buf);
    S8548C2 *dp, &lv = *(dp=new (buf) S8548C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8768,8672), "sizeof(S8548C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8548C2)");
    check_field_offset(lv, s8548c2f0, ABISELECT(8,4), "S8548C2.s8548c2f0");
    check_field_offset(lv, s8548c2f1, ABISELECT(16,8), "S8548C2.s8548c2f1");
    check_field_offset(lv, s8548c2f2, ABISELECT(56,44), "S8548C2.s8548c2f2");
    check_field_offset(lv, s8548c2f3, ABISELECT(8696,8620), "S8548C2.s8548c2f3");
    check_field_offset(lv, s8548c2f4, ABISELECT(8704,8624), "S8548C2.s8548c2f4");
    check_field_offset(lv, s8548c2f5, ABISELECT(8736,8656), "S8548C2.s8548c2f5");
    check_field_offset(lv, s8548c2f6, ABISELECT(8744,8660), "S8548C2.s8548c2f6");
    check_field_offset(lv, s8548c2f7, ABISELECT(8752,8664), "S8548C2.s8548c2f7");
    check_field_offset(lv, s8548c2f8, ABISELECT(8760,8668), "S8548C2.s8548c2f8");
    test_class_info(&lv, &cd_S8548C2);
    dp->~S8548C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8548C2(Test_S8548C2, "S8548C2", ABISELECT(8768,8672));

#else // __cplusplus

extern void _ZN7S8548C2C1Ev();
extern void _ZN7S8548C2D1Ev();
Name_Map name_map_S8548C2[] = {
  NSPAIR(_ZN7S8548C2C1Ev),
  NSPAIR(_ZN7S8548C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S8548C2[];
extern void _ZN7S8548C2D1Ev();
extern void _ZN7S8548C2D0Ev();
extern void _ZN7S8548C23v11Ev();
extern void _ZN7S8548C23v12Ev();
extern void _ZN7S8548C23v13Ev();
extern void _ZN7S8548C23v14Ev();
extern void _ZN7S8548C23v15Ev();
extern void _ZN7S8548C23v16Ev();
extern void _ZN7S8548C23v17Ev();
extern void _ZN7S8548C23v18Ev();
extern void _ZN7S8548C23v19Ev();
extern void _ZN7S8548C23v20Ev();
extern void _ZN7S8548C23v21Ev();
extern void _ZN7S8548C23v22Ev();
extern void _ZN7S8548C23v23Ev();
extern void _ZN7S8548C23v24Ev();
extern void _ZN7S8548C23v25Ev();
extern void _ZN7S8548C23v26Ev();
extern void _ZN7S8548C23v27Ev();
extern void _ZN7S8548C23v28Ev();
extern void _ZN7S8548C23v29Ev();
extern void _ZN7S8548C23v30Ev();
extern void _ZN7S8548C23v31Ev();
extern void _ZN7S8548C23v32Ev();
extern void _ZN7S8548C23v33Ev();
static  VTBL_ENTRY vtc_S8548C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S8548C2[0]),
  (VTBL_ENTRY)&_ZN7S8548C2D1Ev,
  (VTBL_ENTRY)&_ZN7S8548C2D0Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v11Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v12Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v13Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v14Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v15Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v16Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v17Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v18Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v19Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v20Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v21Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v22Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v23Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v24Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v25Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v26Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v27Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v28Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v29Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v30Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v31Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v32Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v33Ev,
};
extern VTBL_ENTRY _ZTI7S8548C2[];
extern  VTBL_ENTRY _ZTV7S8548C2[];
Class_Descriptor cd_S8548C2 = {  "S8548C2", // class name
  0,0,//no base classes
  &(vtc_S8548C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8768,8672), // object size
  NSPAIRA(_ZTI7S8548C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S8548C2),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8548C9  {
  virtual  ~S8548C9(); // _ZN7S8548C9D1Ev
  virtual void  v34(); // _ZN7S8548C93v34Ev
  virtual void  v35(); // _ZN7S8548C93v35Ev
  virtual void  v36(); // _ZN7S8548C93v36Ev
  virtual void  v37(); // _ZN7S8548C93v37Ev
  virtual void  v38(); // _ZN7S8548C93v38Ev
  virtual void  v39(); // _ZN7S8548C93v39Ev
  S8548C9(); // tgen
};
//SIG(-1 S8548C9) C1{ vd v1 v2 v3 v4 v5 v6}


 S8548C9 ::~S8548C9(){ note_dtor("S8548C9", this);}
void  S8548C9 ::v34(){vfunc_called(this, "_ZN7S8548C93v34Ev");}
void  S8548C9 ::v35(){vfunc_called(this, "_ZN7S8548C93v35Ev");}
void  S8548C9 ::v36(){vfunc_called(this, "_ZN7S8548C93v36Ev");}
void  S8548C9 ::v37(){vfunc_called(this, "_ZN7S8548C93v37Ev");}
void  S8548C9 ::v38(){vfunc_called(this, "_ZN7S8548C93v38Ev");}
void  S8548C9 ::v39(){vfunc_called(this, "_ZN7S8548C93v39Ev");}
S8548C9 ::S8548C9(){ note_ctor("S8548C9", this);} // tgen

static void Test_S8548C9()
{
  extern Class_Descriptor cd_S8548C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S8548C9, buf);
    S8548C9 *dp, &lv = *(dp=new (buf) S8548C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S8548C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8548C9)");
    test_class_info(&lv, &cd_S8548C9);
    dp->~S8548C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8548C9(Test_S8548C9, "S8548C9", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S8548C9C1Ev();
extern void _ZN7S8548C9D1Ev();
Name_Map name_map_S8548C9[] = {
  NSPAIR(_ZN7S8548C9C1Ev),
  NSPAIR(_ZN7S8548C9D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S8548C9[];
extern void _ZN7S8548C9D1Ev();
extern void _ZN7S8548C9D0Ev();
extern void _ZN7S8548C93v34Ev();
extern void _ZN7S8548C93v35Ev();
extern void _ZN7S8548C93v36Ev();
extern void _ZN7S8548C93v37Ev();
extern void _ZN7S8548C93v38Ev();
extern void _ZN7S8548C93v39Ev();
static  VTBL_ENTRY vtc_S8548C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S8548C9[0]),
  (VTBL_ENTRY)&_ZN7S8548C9D1Ev,
  (VTBL_ENTRY)&_ZN7S8548C9D0Ev,
  (VTBL_ENTRY)&_ZN7S8548C93v34Ev,
  (VTBL_ENTRY)&_ZN7S8548C93v35Ev,
  (VTBL_ENTRY)&_ZN7S8548C93v36Ev,
  (VTBL_ENTRY)&_ZN7S8548C93v37Ev,
  (VTBL_ENTRY)&_ZN7S8548C93v38Ev,
  (VTBL_ENTRY)&_ZN7S8548C93v39Ev,
};
extern VTBL_ENTRY _ZTI7S8548C9[];
extern  VTBL_ENTRY _ZTV7S8548C9[];
Class_Descriptor cd_S8548C9 = {  "S8548C9", // class name
  0,0,//no base classes
  &(vtc_S8548C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S8548C9),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S8548C9),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8548C11_nt  {
  __tsi64 s8548c11f0[4];
  void  mf8548c11(); // _ZN11S8548C11_nt9mf8548c11Ev
};
//SIG(-1 S8548C11_nt) C1{ m FL[4]}


void  S8548C11_nt ::mf8548c11(){}

//skip512 S8548C11_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8548C8  : S8548C9 {
  void *s8548c8f0;
  ::S3802C37 s8548c8f1;
  ::S8548C11_nt s8548c8f2;
  char s8548c8f3;
  int s8548c8f4;
  virtual  ~S8548C8(); // _ZN7S8548C8D1Ev
  virtual void  v40(); // _ZN7S8548C83v40Ev
  virtual void  v41(); // _ZN7S8548C83v41Ev
  virtual void  v42(); // _ZN7S8548C83v42Ev
  virtual void  v43(); // _ZN7S8548C83v43Ev
  S8548C8(); // tgen
};
//SIG(-1 S8548C8) C1{ BC2{ vd v5 v6 v7 v8 v9 v10} vd v1 v2 v3 v4 Fp FC3{ m Fp} FC4{ m FL[4]} Fc Fi}


 S8548C8 ::~S8548C8(){ note_dtor("S8548C8", this);}
void  S8548C8 ::v40(){vfunc_called(this, "_ZN7S8548C83v40Ev");}
void  S8548C8 ::v41(){vfunc_called(this, "_ZN7S8548C83v41Ev");}
void  S8548C8 ::v42(){vfunc_called(this, "_ZN7S8548C83v42Ev");}
void  S8548C8 ::v43(){vfunc_called(this, "_ZN7S8548C83v43Ev");}
S8548C8 ::S8548C8(){ note_ctor("S8548C8", this);} // tgen

static void Test_S8548C8()
{
  extern Class_Descriptor cd_S8548C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,14)];
    init_test(&cd_S8548C8, buf);
    S8548C8 *dp, &lv = *(dp=new (buf) S8548C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,52), "sizeof(S8548C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8548C8)");
    check_base_class_offset(lv, (S8548C9*), 0, "S8548C8");
    check_field_offset(lv, s8548c8f0, ABISELECT(8,4), "S8548C8.s8548c8f0");
    check_field_offset(lv, s8548c8f1, ABISELECT(16,8), "S8548C8.s8548c8f1");
    check_field_offset(lv, s8548c8f2, ABISELECT(24,12), "S8548C8.s8548c8f2");
    check_field_offset(lv, s8548c8f3, ABISELECT(56,44), "S8548C8.s8548c8f3");
    check_field_offset(lv, s8548c8f4, ABISELECT(60,48), "S8548C8.s8548c8f4");
    test_class_info(&lv, &cd_S8548C8);
    dp->~S8548C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8548C8(Test_S8548C8, "S8548C8", ABISELECT(64,52));

#else // __cplusplus

extern void _ZN7S8548C8C1Ev();
extern void _ZN7S8548C8D1Ev();
Name_Map name_map_S8548C8[] = {
  NSPAIR(_ZN7S8548C8C1Ev),
  NSPAIR(_ZN7S8548C8D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S8548C9;
extern VTBL_ENTRY _ZTI7S8548C9[];
extern  VTBL_ENTRY _ZTV7S8548C9[];
static Base_Class bases_S8548C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S8548C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S8548C8[];
extern void _ZN7S8548C8D1Ev();
extern void _ZN7S8548C8D0Ev();
extern void _ZN7S8548C93v34Ev();
extern void _ZN7S8548C93v35Ev();
extern void _ZN7S8548C93v36Ev();
extern void _ZN7S8548C93v37Ev();
extern void _ZN7S8548C93v38Ev();
extern void _ZN7S8548C93v39Ev();
extern void _ZN7S8548C83v40Ev();
extern void _ZN7S8548C83v41Ev();
extern void _ZN7S8548C83v42Ev();
extern void _ZN7S8548C83v43Ev();
static  VTBL_ENTRY vtc_S8548C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S8548C8[0]),
  (VTBL_ENTRY)&_ZN7S8548C8D1Ev,
  (VTBL_ENTRY)&_ZN7S8548C8D0Ev,
  (VTBL_ENTRY)&_ZN7S8548C93v34Ev,
  (VTBL_ENTRY)&_ZN7S8548C93v35Ev,
  (VTBL_ENTRY)&_ZN7S8548C93v36Ev,
  (VTBL_ENTRY)&_ZN7S8548C93v37Ev,
  (VTBL_ENTRY)&_ZN7S8548C93v38Ev,
  (VTBL_ENTRY)&_ZN7S8548C93v39Ev,
  (VTBL_ENTRY)&_ZN7S8548C83v40Ev,
  (VTBL_ENTRY)&_ZN7S8548C83v41Ev,
  (VTBL_ENTRY)&_ZN7S8548C83v42Ev,
  (VTBL_ENTRY)&_ZN7S8548C83v43Ev,
};
extern VTBL_ENTRY _ZTI7S8548C8[];
extern  VTBL_ENTRY _ZTV7S8548C8[];
Class_Descriptor cd_S8548C8 = {  "S8548C8", // class name
  bases_S8548C8, 1,
  &(vtc_S8548C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,52), // object size
  NSPAIRA(_ZTI7S8548C8),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S8548C8),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8548C7  : S8548C8 {
  int s8548c7f0;
  ::S3799C31 s8548c7f1;
  ::S2122C20_nt s8548c7f2;
  ::S2122C20_nt s8548c7f3;
  virtual  ~S8548C7(); // _ZN7S8548C7D1Ev
  virtual void  v44(); // _ZN7S8548C73v44Ev
  S8548C7(); // tgen
};
//SIG(-1 S8548C7) C1{ BC2{ BC3{ vd v2 v3 v4 v5 v6 v7} vd v8 v9 v10 v11 Fp FC4{ m Fp} FC5{ m FL[4]} Fc Fi} vd v1 Fi FC6{ m Fp Fi[2] FC7{ m Fp}} FC8{ m Fp Fi FC9{ m}} FC8}


 S8548C7 ::~S8548C7(){ note_dtor("S8548C7", this);}
void  S8548C7 ::v44(){vfunc_called(this, "_ZN7S8548C73v44Ev");}
S8548C7 ::S8548C7(){ note_ctor("S8548C7", this);} // tgen

static void Test_S8548C7()
{
  extern Class_Descriptor cd_S8548C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(17,25)];
    init_test(&cd_S8548C7, buf);
    S8548C7 *dp, &lv = *(dp=new (buf) S8548C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,96), "sizeof(S8548C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8548C7)");
    check_base_class_offset(lv, (S8548C9*)(S8548C8*), 0, "S8548C7");
    check_base_class_offset(lv, (S8548C8*), 0, "S8548C7");
    check_field_offset(lv, s8548c7f0, ABISELECT(64,52), "S8548C7.s8548c7f0");
    check_field_offset(lv, s8548c7f1, ABISELECT(72,56), "S8548C7.s8548c7f1");
    check_field_offset(lv, s8548c7f2, ABISELECT(96,72), "S8548C7.s8548c7f2");
    check_field_offset(lv, s8548c7f3, ABISELECT(112,84), "S8548C7.s8548c7f3");
    test_class_info(&lv, &cd_S8548C7);
    dp->~S8548C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8548C7(Test_S8548C7, "S8548C7", ABISELECT(128,96));

#else // __cplusplus

extern void _ZN7S8548C7C1Ev();
extern void _ZN7S8548C7D1Ev();
Name_Map name_map_S8548C7[] = {
  NSPAIR(_ZN7S8548C7C1Ev),
  NSPAIR(_ZN7S8548C7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S8548C9;
extern VTBL_ENTRY _ZTI7S8548C9[];
extern  VTBL_ENTRY _ZTV7S8548C9[];
extern Class_Descriptor cd_S8548C8;
extern VTBL_ENTRY _ZTI7S8548C8[];
extern  VTBL_ENTRY _ZTV7S8548C8[];
static Base_Class bases_S8548C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S8548C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S8548C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S8548C7[];
extern void _ZN7S8548C7D1Ev();
extern void _ZN7S8548C7D0Ev();
extern void _ZN7S8548C93v34Ev();
extern void _ZN7S8548C93v35Ev();
extern void _ZN7S8548C93v36Ev();
extern void _ZN7S8548C93v37Ev();
extern void _ZN7S8548C93v38Ev();
extern void _ZN7S8548C93v39Ev();
extern void _ZN7S8548C83v40Ev();
extern void _ZN7S8548C83v41Ev();
extern void _ZN7S8548C83v42Ev();
extern void _ZN7S8548C83v43Ev();
extern void _ZN7S8548C73v44Ev();
static  VTBL_ENTRY vtc_S8548C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S8548C7[0]),
  (VTBL_ENTRY)&_ZN7S8548C7D1Ev,
  (VTBL_ENTRY)&_ZN7S8548C7D0Ev,
  (VTBL_ENTRY)&_ZN7S8548C93v34Ev,
  (VTBL_ENTRY)&_ZN7S8548C93v35Ev,
  (VTBL_ENTRY)&_ZN7S8548C93v36Ev,
  (VTBL_ENTRY)&_ZN7S8548C93v37Ev,
  (VTBL_ENTRY)&_ZN7S8548C93v38Ev,
  (VTBL_ENTRY)&_ZN7S8548C93v39Ev,
  (VTBL_ENTRY)&_ZN7S8548C83v40Ev,
  (VTBL_ENTRY)&_ZN7S8548C83v41Ev,
  (VTBL_ENTRY)&_ZN7S8548C83v42Ev,
  (VTBL_ENTRY)&_ZN7S8548C83v43Ev,
  (VTBL_ENTRY)&_ZN7S8548C73v44Ev,
};
extern VTBL_ENTRY _ZTI7S8548C7[];
extern  VTBL_ENTRY _ZTV7S8548C7[];
Class_Descriptor cd_S8548C7 = {  "S8548C7", // class name
  bases_S8548C7, 2,
  &(vtc_S8548C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(128,96), // object size
  NSPAIRA(_ZTI7S8548C7),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S8548C7),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8548C6  : S8548C7 {
  int s8548c6f0;
  virtual  ~S8548C6(); // _ZN7S8548C6D1Ev
  S8548C6(); // tgen
};
//SIG(-1 S8548C6) C1{ BC2{ BC3{ BC4{ vd v1 v2 v3 v4 v5 v6} vd v7 v8 v9 v10 Fp FC5{ m Fp} FC6{ m FL[4]} Fc Fi} vd v11 Fi FC7{ m Fp Fi[2] FC8{ m Fp}} FC9{ m Fp Fi FC10{ m}} FC9} vd Fi}


 S8548C6 ::~S8548C6(){ note_dtor("S8548C6", this);}
S8548C6 ::S8548C6(){ note_ctor("S8548C6", this);} // tgen

static void Test_S8548C6()
{
  extern Class_Descriptor cd_S8548C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,26)];
    init_test(&cd_S8548C6, buf);
    S8548C6 *dp, &lv = *(dp=new (buf) S8548C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,100), "sizeof(S8548C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8548C6)");
    check_base_class_offset(lv, (S8548C9*)(S8548C8*)(S8548C7*), 0, "S8548C6");
    check_base_class_offset(lv, (S8548C8*)(S8548C7*), 0, "S8548C6");
    check_base_class_offset(lv, (S8548C7*), 0, "S8548C6");
    check_field_offset(lv, s8548c6f0, ABISELECT(128,96), "S8548C6.s8548c6f0");
    test_class_info(&lv, &cd_S8548C6);
    dp->~S8548C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8548C6(Test_S8548C6, "S8548C6", ABISELECT(136,100));

#else // __cplusplus

extern void _ZN7S8548C6C1Ev();
extern void _ZN7S8548C6D1Ev();
Name_Map name_map_S8548C6[] = {
  NSPAIR(_ZN7S8548C6C1Ev),
  NSPAIR(_ZN7S8548C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S8548C9;
extern VTBL_ENTRY _ZTI7S8548C9[];
extern  VTBL_ENTRY _ZTV7S8548C9[];
extern Class_Descriptor cd_S8548C8;
extern VTBL_ENTRY _ZTI7S8548C8[];
extern  VTBL_ENTRY _ZTV7S8548C8[];
extern Class_Descriptor cd_S8548C7;
extern VTBL_ENTRY _ZTI7S8548C7[];
extern  VTBL_ENTRY _ZTV7S8548C7[];
static Base_Class bases_S8548C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S8548C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S8548C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S8548C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S8548C6[];
extern void _ZN7S8548C6D1Ev();
extern void _ZN7S8548C6D0Ev();
extern void _ZN7S8548C93v34Ev();
extern void _ZN7S8548C93v35Ev();
extern void _ZN7S8548C93v36Ev();
extern void _ZN7S8548C93v37Ev();
extern void _ZN7S8548C93v38Ev();
extern void _ZN7S8548C93v39Ev();
extern void _ZN7S8548C83v40Ev();
extern void _ZN7S8548C83v41Ev();
extern void _ZN7S8548C83v42Ev();
extern void _ZN7S8548C83v43Ev();
extern void _ZN7S8548C73v44Ev();
static  VTBL_ENTRY vtc_S8548C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S8548C6[0]),
  (VTBL_ENTRY)&_ZN7S8548C6D1Ev,
  (VTBL_ENTRY)&_ZN7S8548C6D0Ev,
  (VTBL_ENTRY)&_ZN7S8548C93v34Ev,
  (VTBL_ENTRY)&_ZN7S8548C93v35Ev,
  (VTBL_ENTRY)&_ZN7S8548C93v36Ev,
  (VTBL_ENTRY)&_ZN7S8548C93v37Ev,
  (VTBL_ENTRY)&_ZN7S8548C93v38Ev,
  (VTBL_ENTRY)&_ZN7S8548C93v39Ev,
  (VTBL_ENTRY)&_ZN7S8548C83v40Ev,
  (VTBL_ENTRY)&_ZN7S8548C83v41Ev,
  (VTBL_ENTRY)&_ZN7S8548C83v42Ev,
  (VTBL_ENTRY)&_ZN7S8548C83v43Ev,
  (VTBL_ENTRY)&_ZN7S8548C73v44Ev,
};
extern VTBL_ENTRY _ZTI7S8548C6[];
extern  VTBL_ENTRY _ZTV7S8548C6[];
Class_Descriptor cd_S8548C6 = {  "S8548C6", // class name
  bases_S8548C6, 3,
  &(vtc_S8548C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,100), // object size
  NSPAIRA(_ZTI7S8548C6),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S8548C6),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8548C16  {
  __tsi64 s8548c16f0;
  ::S3799C37 s8548c16f1;
  ::S3803C24_nt s8548c16f2;
  ::S8547C19_nt s8548c16f3;
  ::S8547C19_nt s8548c16f4;
  void  mf8548c16(); // _ZN8S8548C169mf8548c16Ev
};
//SIG(-1 S8548C16) C1{ m FL FC2{ m Fp} FC3{ m FL[4]} FC4{ FL} FC4}


void  S8548C16 ::mf8548c16(){}

static void Test_S8548C16()
{
  {
    init_simple_test("S8548C16");
    S8548C16 lv;
    check2(sizeof(lv), ABISELECT(64,60), "sizeof(S8548C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8548C16)");
    check_field_offset(lv, s8548c16f0, 0, "S8548C16.s8548c16f0");
    check_field_offset(lv, s8548c16f1, 8, "S8548C16.s8548c16f1");
    check_field_offset(lv, s8548c16f2, ABISELECT(16,12), "S8548C16.s8548c16f2");
    check_field_offset(lv, s8548c16f3, ABISELECT(48,44), "S8548C16.s8548c16f3");
    check_field_offset(lv, s8548c16f4, ABISELECT(56,52), "S8548C16.s8548c16f4");
  }
}
static Arrange_To_Call_Me vS8548C16(Test_S8548C16, "S8548C16", ABISELECT(64,60));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8548C1  : S8548C2 {
  ::S8548C6 s8548c1f0;
  ::S8548C7 s8548c1f1;
  void *s8548c1f2;
  char s8548c1f3;
  ::S8548C16 s8548c1f4;
  virtual  ~S8548C1(); // _ZN7S8548C1D1Ev
  virtual void  v1(); // _ZN7S8548C12v1Ev
  virtual void  v2(); // _ZN7S8548C12v2Ev
  virtual void  v3(); // _ZN7S8548C12v3Ev
  virtual void  v4(); // _ZN7S8548C12v4Ev
  virtual void  v5(); // _ZN7S8548C12v5Ev
  virtual void  v6(); // _ZN7S8548C12v6Ev
  virtual void  v7(); // _ZN7S8548C12v7Ev
  virtual void  v8(); // _ZN7S8548C12v8Ev
  virtual void  v9(); // _ZN7S8548C12v9Ev
  virtual void  v10(); // _ZN7S8548C13v10Ev
  S8548C1(); // tgen
};
//SIG(1 S8548C1) C1{ BC2{ vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 Fp FC3{ vd m Fi[2] FL Fi[4]} FC4{ vd m Fi[2] FL[3] Fc[2048] Fi[6] FL Fi[4] Fp[2] Fc}[4] Fc FC5{ m FL[4]} Fp Fi Fp Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 FC6{ BC7{ BC8{ BC9{ vd v34 v35 v36 v37 v38 v39} vd v40 v41 v42 v43 Fp FC10{ m Fp} FC11{ m FL[4]} Fc Fi} vd v44 Fi FC12{ m Fp Fi[2] FC13{ m Fp}} FC14{ m Fp Fi FC15{ m}} FC14} vd Fi} FC7 Fp Fc FC16{ m FL FC17{ m Fp} FC5 FC18{ FL} FC18}}


 S8548C1 ::~S8548C1(){ note_dtor("S8548C1", this);}
void  S8548C1 ::v1(){vfunc_called(this, "_ZN7S8548C12v1Ev");}
void  S8548C1 ::v2(){vfunc_called(this, "_ZN7S8548C12v2Ev");}
void  S8548C1 ::v3(){vfunc_called(this, "_ZN7S8548C12v3Ev");}
void  S8548C1 ::v4(){vfunc_called(this, "_ZN7S8548C12v4Ev");}
void  S8548C1 ::v5(){vfunc_called(this, "_ZN7S8548C12v5Ev");}
void  S8548C1 ::v6(){vfunc_called(this, "_ZN7S8548C12v6Ev");}
void  S8548C1 ::v7(){vfunc_called(this, "_ZN7S8548C12v7Ev");}
void  S8548C1 ::v8(){vfunc_called(this, "_ZN7S8548C12v8Ev");}
void  S8548C1 ::v9(){vfunc_called(this, "_ZN7S8548C12v9Ev");}
void  S8548C1 ::v10(){vfunc_called(this, "_ZN7S8548C13v10Ev");}
S8548C1 ::S8548C1(){ note_ctor("S8548C1", this);} // tgen

static void Test_S8548C1()
{
  extern Class_Descriptor cd_S8548C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(1140,2235)];
    init_test(&cd_S8548C1, buf);
    S8548C1 *dp, &lv = *(dp=new (buf) S8548C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(9112,8936), "sizeof(S8548C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8548C1)");
    check_base_class_offset(lv, (S8548C2*), 0, "S8548C1");
    check_field_offset(lv, s8548c1f0, ABISELECT(8768,8672), "S8548C1.s8548c1f0");
    check_field_offset(lv, s8548c1f1, ABISELECT(8904,8772), "S8548C1.s8548c1f1");
    check_field_offset(lv, s8548c1f2, ABISELECT(9032,8868), "S8548C1.s8548c1f2");
    check_field_offset(lv, s8548c1f3, ABISELECT(9040,8872), "S8548C1.s8548c1f3");
    check_field_offset(lv, s8548c1f4, ABISELECT(9048,8876), "S8548C1.s8548c1f4");
    test_class_info(&lv, &cd_S8548C1);
    dp->~S8548C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8548C1(Test_S8548C1, "S8548C1", ABISELECT(9112,8936));

#else // __cplusplus

extern void _ZN7S8548C1C1Ev();
extern void _ZN7S8548C1D1Ev();
Name_Map name_map_S8548C1[] = {
  NSPAIR(_ZN7S8548C1C1Ev),
  NSPAIR(_ZN7S8548C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S8548C2;
extern VTBL_ENTRY _ZTI7S8548C2[];
extern  VTBL_ENTRY _ZTV7S8548C2[];
static Base_Class bases_S8548C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S8548C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S8548C1[];
extern void _ZN7S8548C1D1Ev();
extern void _ZN7S8548C1D0Ev();
extern void _ZN7S8548C23v11Ev();
extern void _ZN7S8548C23v12Ev();
extern void _ZN7S8548C23v13Ev();
extern void _ZN7S8548C23v14Ev();
extern void _ZN7S8548C23v15Ev();
extern void _ZN7S8548C23v16Ev();
extern void _ZN7S8548C23v17Ev();
extern void _ZN7S8548C23v18Ev();
extern void _ZN7S8548C23v19Ev();
extern void _ZN7S8548C23v20Ev();
extern void _ZN7S8548C23v21Ev();
extern void _ZN7S8548C23v22Ev();
extern void _ZN7S8548C23v23Ev();
extern void _ZN7S8548C23v24Ev();
extern void _ZN7S8548C23v25Ev();
extern void _ZN7S8548C23v26Ev();
extern void _ZN7S8548C23v27Ev();
extern void _ZN7S8548C23v28Ev();
extern void _ZN7S8548C23v29Ev();
extern void _ZN7S8548C23v30Ev();
extern void _ZN7S8548C23v31Ev();
extern void _ZN7S8548C23v32Ev();
extern void _ZN7S8548C23v33Ev();
extern void _ZN7S8548C12v1Ev();
extern void _ZN7S8548C12v2Ev();
extern void _ZN7S8548C12v3Ev();
extern void _ZN7S8548C12v4Ev();
extern void _ZN7S8548C12v5Ev();
extern void _ZN7S8548C12v6Ev();
extern void _ZN7S8548C12v7Ev();
extern void _ZN7S8548C12v8Ev();
extern void _ZN7S8548C12v9Ev();
extern void _ZN7S8548C13v10Ev();
static  VTBL_ENTRY vtc_S8548C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S8548C1[0]),
  (VTBL_ENTRY)&_ZN7S8548C1D1Ev,
  (VTBL_ENTRY)&_ZN7S8548C1D0Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v11Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v12Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v13Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v14Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v15Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v16Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v17Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v18Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v19Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v20Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v21Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v22Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v23Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v24Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v25Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v26Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v27Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v28Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v29Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v30Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v31Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v32Ev,
  (VTBL_ENTRY)&_ZN7S8548C23v33Ev,
  (VTBL_ENTRY)&_ZN7S8548C12v1Ev,
  (VTBL_ENTRY)&_ZN7S8548C12v2Ev,
  (VTBL_ENTRY)&_ZN7S8548C12v3Ev,
  (VTBL_ENTRY)&_ZN7S8548C12v4Ev,
  (VTBL_ENTRY)&_ZN7S8548C12v5Ev,
  (VTBL_ENTRY)&_ZN7S8548C12v6Ev,
  (VTBL_ENTRY)&_ZN7S8548C12v7Ev,
  (VTBL_ENTRY)&_ZN7S8548C12v8Ev,
  (VTBL_ENTRY)&_ZN7S8548C12v9Ev,
  (VTBL_ENTRY)&_ZN7S8548C13v10Ev,
};
extern VTBL_ENTRY _ZTI7S8548C1[];
extern  VTBL_ENTRY _ZTV7S8548C1[];
Class_Descriptor cd_S8548C1 = {  "S8548C1", // class name
  bases_S8548C1, 1,
  &(vtc_S8548C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(9112,8936), // object size
  NSPAIRA(_ZTI7S8548C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S8548C1),37, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10917C3  {
  int s10917c3f0;
  char s10917c3f1;
  int s10917c3f2[2];
  char s10917c3f3;
  int s10917c3f4;
  char s10917c3f5;
};
//SIG(-1 S10917C3) C1{ Fi Fc Fi[2] Fc Fi Fc}



static void Test_S10917C3()
{
  {
    init_simple_test("S10917C3");
    S10917C3 lv;
    check2(sizeof(lv), 28, "sizeof(S10917C3)");
    check2(__alignof__(lv), 4, "__alignof__(S10917C3)");
    check_field_offset(lv, s10917c3f0, 0, "S10917C3.s10917c3f0");
    check_field_offset(lv, s10917c3f1, 4, "S10917C3.s10917c3f1");
    check_field_offset(lv, s10917c3f2, 8, "S10917C3.s10917c3f2");
    check_field_offset(lv, s10917c3f3, 16, "S10917C3.s10917c3f3");
    check_field_offset(lv, s10917c3f4, 20, "S10917C3.s10917c3f4");
    check_field_offset(lv, s10917c3f5, 24, "S10917C3.s10917c3f5");
  }
}
static Arrange_To_Call_Me vS10917C3(Test_S10917C3, "S10917C3", 28);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10917C1  {
  char s10917c1f0[4];
  long s10917c1f1;
  ::S10466C2 s10917c1f2;
  int s10917c1f3;
  ::S10917C3 s10917c1f4;
  ::S12863C43 s10917c1f5;
  ::S12863C39 s10917c1f6;
};
//SIG(1 S10917C1) C1{ Fc[4] Fl FC2{ Fi[4] Fc[49]} Fi FC3{ Fi Fc Fi[2] Fc Fi Fc} FC4{ Fi FU5{ FC6{ Fc Fc Fc Fc Fc Fc Fc}}} FC7{ Fc FC8{ Fi FU9{ FC10{ Fc Fc Fc} FC11{ Fi Fi Fc} FC12{ Fc Fc} FC13{ Fs Fs} FC14{ Fs Fc Fc} FC15{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC12 FC16{ Fc Fc Fc[128]} FC17{ Fc Fc} FC18{ Fc Fc[128]} FC19{ Fc Fc[32]} FC18 FC19 FC20{ Fc Fc Fc Fc[134]} FC21{ Fc} FC22{ FC23{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC21 FC24{ Fi} FC24 FC25{ Fi Fc Fc[226]}}}[7] Fs Fc[255]}}



static void Test_S10917C1()
{
  {
    init_simple_test("S10917C1");
    S10917C1 lv;
    check2(sizeof(lv), ABISELECT(2048,2036), "sizeof(S10917C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10917C1)");
    check_field_offset(lv, s10917c1f0, 0, "S10917C1.s10917c1f0");
    check_field_offset(lv, s10917c1f1, ABISELECT(8,4), "S10917C1.s10917c1f1");
    check_field_offset(lv, s10917c1f2, ABISELECT(16,8), "S10917C1.s10917c1f2");
    check_field_offset(lv, s10917c1f3, ABISELECT(84,76), "S10917C1.s10917c1f3");
    check_field_offset(lv, s10917c1f4, ABISELECT(88,80), "S10917C1.s10917c1f4");
    check_field_offset(lv, s10917c1f5, ABISELECT(116,108), "S10917C1.s10917c1f5");
    check_field_offset(lv, s10917c1f6, ABISELECT(128,120), "S10917C1.s10917c1f6");
  }
}
static Arrange_To_Call_Me vS10917C1(Test_S10917C1, "S10917C1", ABISELECT(2048,2036));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10474C1  {
  char s10474c1f0;
  int s10474c1f1[2];
  ::S13767C5 s10474c1f2;
};
//SIG(1 S10474C1) C1{ Fc Fi[2] FU2{ FC3{ Fc Fl Fi FC4{ Fi Fc Fi Fi Fc Fi Fc} FC5{ Fc FC6{ Fi FU7{ FC8{ Fc Fc Fc} FC9{ Fi Fi Fc} FC10{ Fc Fc} FC11{ Fs Fs} FC12{ Fs Fc Fc} FC13{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC10 FC14{ Fc Fc Fc[128]} FC15{ Fc Fc} FC16{ Fc Fc[128]} FC17{ Fc Fc[32]} FC16 FC17 FC18{ Fc Fc Fc Fc[134]} FC19{ Fc} FC20{ FC21{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC19 FC22{ Fi} FC22 FC23{ Fi Fc Fc[226]}}}[7] Fs Fc[255]}} FC24{ Fc Fi Fl Fi FC4 FC5}}}



static void Test_S10474C1()
{
  {
    init_simple_test("S10474C1");
    S10474C1 lv;
    check2(sizeof(lv), ABISELECT(1984,1972), "sizeof(S10474C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10474C1)");
    check_field_offset(lv, s10474c1f0, 0, "S10474C1.s10474c1f0");
    check_field_offset(lv, s10474c1f1, 4, "S10474C1.s10474c1f1");
    check_field_offset(lv, s10474c1f2, ABISELECT(16,12), "S10474C1.s10474c1f2");
  }
}
static Arrange_To_Call_Me vS10474C1(Test_S10474C1, "S10474C1", ABISELECT(1984,1972));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10805C1  {
  char s10805c1f0[3];
  long s10805c1f1;
  ::S10466C2 s10805c1f2;
  ::S12816C4 s10805c1f3;
  ::S12816C4 s10805c1f4;
  int s10805c1f5;
  long s10805c1f6;
  int s10805c1f7;
  ::S10917C3 s10805c1f8;
  ::S12863C39 s10805c1f9;
};
//SIG(1 S10805C1) C1{ Fc[3] Fl FC2{ Fi[4] Fc[49]} FC3{ Fc[7]} FC3 Fi Fl Fi FC4{ Fi Fc Fi[2] Fc Fi Fc} FC5{ Fc FC6{ Fi FU7{ FC8{ Fc Fc Fc} FC9{ Fi Fi Fc} FC10{ Fc Fc} FC11{ Fs Fs} FC12{ Fs Fc Fc} FC13{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC10 FC14{ Fc Fc Fc[128]} FC15{ Fc Fc} FC16{ Fc Fc[128]} FC17{ Fc Fc[32]} FC16 FC17 FC18{ Fc Fc Fc Fc[134]} FC19{ Fc} FC20{ FC21{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC19 FC22{ Fi} FC22 FC23{ Fi Fc Fc[226]}}}[7] Fs Fc[255]}}



static void Test_S10805C1()
{
  {
    init_simple_test("S10805C1");
    S10805C1 lv;
    check2(sizeof(lv), ABISELECT(2064,2048), "sizeof(S10805C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10805C1)");
    check_field_offset(lv, s10805c1f0, 0, "S10805C1.s10805c1f0");
    check_field_offset(lv, s10805c1f1, ABISELECT(8,4), "S10805C1.s10805c1f1");
    check_field_offset(lv, s10805c1f2, ABISELECT(16,8), "S10805C1.s10805c1f2");
    check_field_offset(lv, s10805c1f3, ABISELECT(84,76), "S10805C1.s10805c1f3");
    check_field_offset(lv, s10805c1f4, ABISELECT(91,83), "S10805C1.s10805c1f4");
    check_field_offset(lv, s10805c1f5, ABISELECT(100,92), "S10805C1.s10805c1f5");
    check_field_offset(lv, s10805c1f6, ABISELECT(104,96), "S10805C1.s10805c1f6");
    check_field_offset(lv, s10805c1f7, ABISELECT(112,100), "S10805C1.s10805c1f7");
    check_field_offset(lv, s10805c1f8, ABISELECT(116,104), "S10805C1.s10805c1f8");
    check_field_offset(lv, s10805c1f9, ABISELECT(144,132), "S10805C1.s10805c1f9");
  }
}
static Arrange_To_Call_Me vS10805C1(Test_S10805C1, "S10805C1", ABISELECT(2064,2048));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10879C1  {
  char s10879c1f0[4];
  ::S10466C2 s10879c1f1;
  int s10879c1f2;
  ::S10917C3 s10879c1f3;
  ::S12816C4 s10879c1f4;
  ::S12863C39 s10879c1f5;
};
//SIG(1 S10879C1) C1{ Fc[4] FC2{ Fi[4] Fc[49]} Fi FC3{ Fi Fc Fi[2] Fc Fi Fc} FC4{ Fc[7]} FC5{ Fc FC6{ Fi FU7{ FC8{ Fc Fc Fc} FC9{ Fi Fi Fc} FC10{ Fc Fc} FC11{ Fs Fs} FC12{ Fs Fc Fc} FC13{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC10 FC14{ Fc Fc Fc[128]} FC15{ Fc Fc} FC16{ Fc Fc[128]} FC17{ Fc Fc[32]} FC16 FC17 FC18{ Fc Fc Fc Fc[134]} FC19{ Fc} FC20{ FC21{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC19 FC22{ Fi} FC22 FC23{ Fi Fc Fc[226]}}}[7] Fs Fc[255]}}



static void Test_S10879C1()
{
  {
    init_simple_test("S10879C1");
    S10879C1 lv;
    check2(sizeof(lv), 2028, "sizeof(S10879C1)");
    check2(__alignof__(lv), 4, "__alignof__(S10879C1)");
    check_field_offset(lv, s10879c1f0, 0, "S10879C1.s10879c1f0");
    check_field_offset(lv, s10879c1f1, 4, "S10879C1.s10879c1f1");
    check_field_offset(lv, s10879c1f2, 72, "S10879C1.s10879c1f2");
    check_field_offset(lv, s10879c1f3, 76, "S10879C1.s10879c1f3");
    check_field_offset(lv, s10879c1f4, 104, "S10879C1.s10879c1f4");
    check_field_offset(lv, s10879c1f5, 112, "S10879C1.s10879c1f5");
  }
}
static Arrange_To_Call_Me vS10879C1(Test_S10879C1, "S10879C1", 2028);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11925C3  {
  int s11925c3f0[2];
  char s11925c3f1;
  int s11925c3f2[2];
  char s11925c3f3[5];
};
//SIG(-1 S11925C3) C1{ Fi[2] Fc Fi[2] Fc[5]}



static void Test_S11925C3()
{
  {
    init_simple_test("S11925C3");
    S11925C3 lv;
    check2(sizeof(lv), 28, "sizeof(S11925C3)");
    check2(__alignof__(lv), 4, "__alignof__(S11925C3)");
    check_field_offset(lv, s11925c3f0, 0, "S11925C3.s11925c3f0");
    check_field_offset(lv, s11925c3f1, 8, "S11925C3.s11925c3f1");
    check_field_offset(lv, s11925c3f2, 12, "S11925C3.s11925c3f2");
    check_field_offset(lv, s11925c3f3, 20, "S11925C3.s11925c3f3");
  }
}
static Arrange_To_Call_Me vS11925C3(Test_S11925C3, "S11925C3", 28);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11925C2  {
  short s11925c2f0;
  ::S11925C3 s11925c2f1;
  char s11925c2f2[2];
  int s11925c2f3;
  short s11925c2f4;
  char s11925c2f5;
  short s11925c2f6;
};
//SIG(-1 S11925C2) C1{ Fs FC2{ Fi[2] Fc Fi[2] Fc[5]} Fc[2] Fi Fs Fc Fs}



static void Test_S11925C2()
{
  {
    init_simple_test("S11925C2");
    S11925C2 lv;
    check2(sizeof(lv), 48, "sizeof(S11925C2)");
    check2(__alignof__(lv), 4, "__alignof__(S11925C2)");
    check_field_offset(lv, s11925c2f0, 0, "S11925C2.s11925c2f0");
    check_field_offset(lv, s11925c2f1, 4, "S11925C2.s11925c2f1");
    check_field_offset(lv, s11925c2f2, 32, "S11925C2.s11925c2f2");
    check_field_offset(lv, s11925c2f3, 36, "S11925C2.s11925c2f3");
    check_field_offset(lv, s11925c2f4, 40, "S11925C2.s11925c2f4");
    check_field_offset(lv, s11925c2f5, 42, "S11925C2.s11925c2f5");
    check_field_offset(lv, s11925c2f6, 44, "S11925C2.s11925c2f6");
  }
}
static Arrange_To_Call_Me vS11925C2(Test_S11925C2, "S11925C2", 48);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S11925C1  {
  ::S11925C2 s11925c1f0;
  ::S12863C39 s11925c1f1;
};
//SIG(1 S11925C1) C1{ FC2{ Fs FC3{ Fi[2] Fc Fi[2] Fc[5]} Fc[2] Fi Fs Fc Fs} FC4{ Fc FC5{ Fi FU6{ FC7{ Fc Fc Fc} FC8{ Fi Fi Fc} FC9{ Fc Fc} FC10{ Fs Fs} FC11{ Fs Fc Fc} FC12{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC9 FC13{ Fc Fc Fc[128]} FC14{ Fc Fc} FC15{ Fc Fc[128]} FC16{ Fc Fc[32]} FC15 FC16 FC17{ Fc Fc Fc Fc[134]} FC18{ Fc} FC19{ FC20{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC18 FC21{ Fi} FC21 FC22{ Fi Fc Fc[226]}}}[7] Fs Fc[255]}}



static void Test_S11925C1()
{
  {
    init_simple_test("S11925C1");
    S11925C1 lv;
    check2(sizeof(lv), 1964, "sizeof(S11925C1)");
    check2(__alignof__(lv), 4, "__alignof__(S11925C1)");
    check_field_offset(lv, s11925c1f0, 0, "S11925C1.s11925c1f0");
    check_field_offset(lv, s11925c1f1, 48, "S11925C1.s11925c1f1");
  }
}
static Arrange_To_Call_Me vS11925C1(Test_S11925C1, "S11925C1", 1964);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10455C1  {
  char s10455c1f0;
  int s10455c1f1;
  ::S12816C4 s10455c1f2;
  long s10455c1f3;
  int s10455c1f4;
  ::S10917C3 s10455c1f5;
  ::S12863C39 s10455c1f6;
};
//SIG(1 S10455C1) C1{ Fc Fi FC2{ Fc[7]} Fl Fi FC3{ Fi Fc Fi[2] Fc Fi Fc} FC4{ Fc FC5{ Fi FU6{ FC7{ Fc Fc Fc} FC8{ Fi Fi Fc} FC9{ Fc Fc} FC10{ Fs Fs} FC11{ Fs Fc Fc} FC12{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC9 FC13{ Fc Fc Fc[128]} FC14{ Fc Fc} FC15{ Fc Fc[128]} FC16{ Fc Fc[32]} FC15 FC16 FC17{ Fc Fc Fc Fc[134]} FC18{ Fc} FC19{ FC20{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC18 FC21{ Fi} FC21 FC22{ Fi Fc Fc[226]}}}[7] Fs Fc[255]}}



static void Test_S10455C1()
{
  {
    init_simple_test("S10455C1");
    S10455C1 lv;
    check2(sizeof(lv), ABISELECT(1976,1968), "sizeof(S10455C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10455C1)");
    check_field_offset(lv, s10455c1f0, 0, "S10455C1.s10455c1f0");
    check_field_offset(lv, s10455c1f1, 4, "S10455C1.s10455c1f1");
    check_field_offset(lv, s10455c1f2, 8, "S10455C1.s10455c1f2");
    check_field_offset(lv, s10455c1f3, 16, "S10455C1.s10455c1f3");
    check_field_offset(lv, s10455c1f4, ABISELECT(24,20), "S10455C1.s10455c1f4");
    check_field_offset(lv, s10455c1f5, ABISELECT(28,24), "S10455C1.s10455c1f5");
    check_field_offset(lv, s10455c1f6, ABISELECT(56,52), "S10455C1.s10455c1f6");
  }
}
static Arrange_To_Call_Me vS10455C1(Test_S10455C1, "S10455C1", ABISELECT(1976,1968));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10434C1  {
  char s10434c1f0;
  ::S12816C4 s10434c1f1;
  long s10434c1f2;
  int s10434c1f3;
  ::S10917C3 s10434c1f4;
  ::S12863C39 s10434c1f5;
};
//SIG(1 S10434C1) C1{ Fc FC2{ Fc[7]} Fl Fi FC3{ Fi Fc Fi[2] Fc Fi Fc} FC4{ Fc FC5{ Fi FU6{ FC7{ Fc Fc Fc} FC8{ Fi Fi Fc} FC9{ Fc Fc} FC10{ Fs Fs} FC11{ Fs Fc Fc} FC12{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC9 FC13{ Fc Fc Fc[128]} FC14{ Fc Fc} FC15{ Fc Fc[128]} FC16{ Fc Fc[32]} FC15 FC16 FC17{ Fc Fc Fc Fc[134]} FC18{ Fc} FC19{ FC20{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC18 FC21{ Fi} FC21 FC22{ Fi Fc Fc[226]}}}[7] Fs Fc[255]}}



static void Test_S10434C1()
{
  {
    init_simple_test("S10434C1");
    S10434C1 lv;
    check2(sizeof(lv), ABISELECT(1968,1960), "sizeof(S10434C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10434C1)");
    check_field_offset(lv, s10434c1f0, 0, "S10434C1.s10434c1f0");
    check_field_offset(lv, s10434c1f1, 1, "S10434C1.s10434c1f1");
    check_field_offset(lv, s10434c1f2, 8, "S10434C1.s10434c1f2");
    check_field_offset(lv, s10434c1f3, ABISELECT(16,12), "S10434C1.s10434c1f3");
    check_field_offset(lv, s10434c1f4, ABISELECT(20,16), "S10434C1.s10434c1f4");
    check_field_offset(lv, s10434c1f5, ABISELECT(48,44), "S10434C1.s10434c1f5");
  }
}
static Arrange_To_Call_Me vS10434C1(Test_S10434C1, "S10434C1", ABISELECT(1968,1960));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10464C1  {
  char s10464c1f0;
  int s10464c1f1;
  long s10464c1f2;
  int s10464c1f3;
  ::S10917C3 s10464c1f4;
  ::S12863C39 s10464c1f5;
};
//SIG(1 S10464C1) C1{ Fc Fi Fl Fi FC2{ Fi Fc Fi[2] Fc Fi Fc} FC3{ Fc FC4{ Fi FU5{ FC6{ Fc Fc Fc} FC7{ Fi Fi Fc} FC8{ Fc Fc} FC9{ Fs Fs} FC10{ Fs Fc Fc} FC11{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC8 FC12{ Fc Fc Fc[128]} FC13{ Fc Fc} FC14{ Fc Fc[128]} FC15{ Fc Fc[32]} FC14 FC15 FC16{ Fc Fc Fc Fc[134]} FC17{ Fc} FC18{ FC19{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC17 FC20{ Fi} FC20 FC21{ Fi Fc Fc[226]}}}[7] Fs Fc[255]}}



static void Test_S10464C1()
{
  {
    init_simple_test("S10464C1");
    S10464C1 lv;
    check2(sizeof(lv), ABISELECT(1968,1960), "sizeof(S10464C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10464C1)");
    check_field_offset(lv, s10464c1f0, 0, "S10464C1.s10464c1f0");
    check_field_offset(lv, s10464c1f1, 4, "S10464C1.s10464c1f1");
    check_field_offset(lv, s10464c1f2, 8, "S10464C1.s10464c1f2");
    check_field_offset(lv, s10464c1f3, ABISELECT(16,12), "S10464C1.s10464c1f3");
    check_field_offset(lv, s10464c1f4, ABISELECT(20,16), "S10464C1.s10464c1f4");
    check_field_offset(lv, s10464c1f5, ABISELECT(48,44), "S10464C1.s10464c1f5");
  }
}
static Arrange_To_Call_Me vS10464C1(Test_S10464C1, "S10464C1", ABISELECT(1968,1960));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10490C1  {
  char s10490c1f0;
  long s10490c1f1;
  int s10490c1f2;
  ::S10917C3 s10490c1f3;
  ::S12863C39 s10490c1f4;
};
//SIG(1 S10490C1) C1{ Fc Fl Fi FC2{ Fi Fc Fi[2] Fc Fi Fc} FC3{ Fc FC4{ Fi FU5{ FC6{ Fc Fc Fc} FC7{ Fi Fi Fc} FC8{ Fc Fc} FC9{ Fs Fs} FC10{ Fs Fc Fc} FC11{ Fc Fc Fi Fi Fc Fc Fc Fc Fc Fi Fi} FC8 FC12{ Fc Fc Fc[128]} FC13{ Fc Fc} FC14{ Fc Fc[128]} FC15{ Fc Fc[32]} FC14 FC15 FC16{ Fc Fc Fc Fc[134]} FC17{ Fc} FC18{ FC19{ Fc Fc[131]} Fc Fc Fs Fc Fi Fs} FC17 FC20{ Fi} FC20 FC21{ Fi Fc Fc[226]}}}[7] Fs Fc[255]}}



static void Test_S10490C1()
{
  {
    init_simple_test("S10490C1");
    S10490C1 lv;
    check2(sizeof(lv), ABISELECT(1968,1956), "sizeof(S10490C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10490C1)");
    check_field_offset(lv, s10490c1f0, 0, "S10490C1.s10490c1f0");
    check_field_offset(lv, s10490c1f1, ABISELECT(8,4), "S10490C1.s10490c1f1");
    check_field_offset(lv, s10490c1f2, ABISELECT(16,8), "S10490C1.s10490c1f2");
    check_field_offset(lv, s10490c1f3, ABISELECT(20,12), "S10490C1.s10490c1f3");
    check_field_offset(lv, s10490c1f4, ABISELECT(48,40), "S10490C1.s10490c1f4");
  }
}
static Arrange_To_Call_Me vS10490C1(Test_S10490C1, "S10490C1", ABISELECT(1968,1956));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S18290C14_nt  {
  __tsi64 s18290c14f0[2];
  char s18290c14f1;
  int s18290c14f2;
  ::S2122C20_nt s18290c14f3;
  ::S2122C20_nt s18290c14f4;
  ::S2122C20_nt s18290c14f5;
  ::S2122C20_nt s18290c14f6;
  ::S2122C20_nt s18290c14f7;
  ::S2122C20_nt s18290c14f8;
  ::S2122C20_nt s18290c14f9;
  ::S2122C20_nt s18290c14f10;
  ::S2122C20_nt s18290c14f11;
  ::S2122C20_nt s18290c14f12;
  ::S2122C20_nt s18290c14f13;
  ::S2122C20_nt s18290c14f14;
  int s18290c14f15[3];
  ::S2122C20_nt s18290c14f16;
  ::S2122C20_nt s18290c14f17;
  ::S2122C20_nt s18290c14f18;
  __tsi64 s18290c14f19[2];
  int s18290c14f20[4];
  ::S2122C20_nt s18290c14f21;
  ::S2122C20_nt s18290c14f22;
  int s18290c14f23[2];
  __tsi64 s18290c14f24;
  int s18290c14f25[5];
  __tsi64 s18290c14f26;
  char s18290c14f27;
  void  mf18290c14(); // _ZN12S18290C14_nt10mf18290c14Ev
};
//SIG(-1 S18290C14_nt) C1{ m FL[2] Fc Fi FC2{ m Fp Fi FC3{ m}} FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 Fi[3] FC2 FC2 FC2 FL[2] Fi[4] FC2 FC2 Fi[2] FL Fi[5] FL Fc}


void  S18290C14_nt ::mf18290c14(){}

//skip512 S18290C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S18290C1  {
  void *s18290c1f0[3];
  ::S2122C20_nt s18290c1f1;
  int s18290c1f2[2];
  ::S2122C37 s18290c1f3;
  ::S8547C8 s18290c1f4;
  void *s18290c1f5[3];
  ::S18290C14_nt s18290c1f6;
  ::S2122C20_nt s18290c1f7;
  void  mf18290c1(); // _ZN8S18290C19mf18290c1Ev
};
//SIG(1 S18290C1) C1{ m Fp[3] FC2{ m Fp Fi FC3{ m}} Fi[2] FC4{ m Fp Fi[2] FC5{ m}} FC6{ BC7{ BC8{ vd v2 v3 v4 v5 v6 v7} vd v8 v9 v10 v11 Fp FC9{ m Fp} FC10{ m FC11{ FL[4]}} Fc Fi} vd v1 Fi FC12{ m Fp Fi[2] FC13{ m Fp}} FC2 FC2} Fp[3] FC14{ m FL[2] Fc Fi FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 Fi[3] FC2 FC2 FC2 FL[2] Fi[4] FC2 FC2 Fi[2] FL Fi[5] FL Fc} FC2}


void  S18290C1 ::mf18290c1(){}

static void Test_S18290C1()
{
  {
    init_simple_test("S18290C1");
    S18290C1 lv;
    check2(sizeof(lv), ABISELECT(640,488), "sizeof(S18290C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S18290C1)");
    check_field_offset(lv, s18290c1f0, 0, "S18290C1.s18290c1f0");
    check_field_offset(lv, s18290c1f1, ABISELECT(24,12), "S18290C1.s18290c1f1");
    check_field_offset(lv, s18290c1f2, ABISELECT(40,24), "S18290C1.s18290c1f2");
    check_field_offset(lv, s18290c1f3, ABISELECT(48,32), "S18290C1.s18290c1f3");
    check_field_offset(lv, s18290c1f4, ABISELECT(72,48), "S18290C1.s18290c1f4");
    check_field_offset(lv, s18290c1f5, ABISELECT(200,144), "S18290C1.s18290c1f5");
    check_field_offset(lv, s18290c1f6, ABISELECT(224,156), "S18290C1.s18290c1f6");
    check_field_offset(lv, s18290c1f7, ABISELECT(624,476), "S18290C1.s18290c1f7");
  }
}
static Arrange_To_Call_Me vS18290C1(Test_S18290C1, "S18290C1", ABISELECT(640,488));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S18289C1  {
  void *s18289c1f0[3];
  ::S2122C20_nt s18289c1f1;
  int s18289c1f2[2];
  ::S2122C37 s18289c1f3;
  ::S8546C8 s18289c1f4;
  void *s18289c1f5[3];
  ::S18290C14_nt s18289c1f6;
  ::S2122C20_nt s18289c1f7;
  void  mf18289c1(); // _ZN8S18289C19mf18289c1Ev
};
//SIG(1 S18289C1) C1{ m Fp[3] FC2{ m Fp Fi FC3{ m}} Fi[2] FC4{ m Fp Fi[2] FC5{ m}} FC6{ BC7{ BC8{ vd v2 v3 v4 v5 v6 v7} vd v8 v9 v10 v11 Fp FC9{ m Fp} FC10{ m FC11{ Fl[4]}} Fc Fi} vd v1 Fi FC12{ m Fp Fi[2] FC13{ m Fp}} FC2 FC2} Fp[3] FC14{ m FL[2] Fc Fi FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 Fi[3] FC2 FC2 FC2 FL[2] Fi[4] FC2 FC2 Fi[2] FL Fi[5] FL Fc} FC2}


void  S18289C1 ::mf18289c1(){}

static void Test_S18289C1()
{
  {
    init_simple_test("S18289C1");
    S18289C1 lv;
    check2(sizeof(lv), ABISELECT(640,472), "sizeof(S18289C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S18289C1)");
    check_field_offset(lv, s18289c1f0, 0, "S18289C1.s18289c1f0");
    check_field_offset(lv, s18289c1f1, ABISELECT(24,12), "S18289C1.s18289c1f1");
    check_field_offset(lv, s18289c1f2, ABISELECT(40,24), "S18289C1.s18289c1f2");
    check_field_offset(lv, s18289c1f3, ABISELECT(48,32), "S18289C1.s18289c1f3");
    check_field_offset(lv, s18289c1f4, ABISELECT(72,48), "S18289C1.s18289c1f4");
    check_field_offset(lv, s18289c1f5, ABISELECT(200,128), "S18289C1.s18289c1f5");
    check_field_offset(lv, s18289c1f6, ABISELECT(224,140), "S18289C1.s18289c1f6");
    check_field_offset(lv, s18289c1f7, ABISELECT(624,460), "S18289C1.s18289c1f7");
  }
}
static Arrange_To_Call_Me vS18289C1(Test_S18289C1, "S18289C1", ABISELECT(640,472));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S18291C1  {
  void *s18291c1f0[3];
  ::S2122C20_nt s18291c1f1;
  int s18291c1f2[2];
  ::S2122C37 s18291c1f3;
  ::S8548C7 s18291c1f4;
  void *s18291c1f5[3];
  ::S18290C14_nt s18291c1f6;
  ::S2122C20_nt s18291c1f7;
  void  mf18291c1(); // _ZN8S18291C19mf18291c1Ev
};
//SIG(1 S18291C1) C1{ m Fp[3] FC2{ m Fp Fi FC3{ m}} Fi[2] FC4{ m Fp Fi[2] FC5{ m}} FC6{ BC7{ BC8{ vd v2 v3 v4 v5 v6 v7} vd v8 v9 v10 v11 Fp FC9{ m Fp} FC10{ m FL[4]} Fc Fi} vd v1 Fi FC11{ m Fp Fi[2] FC12{ m Fp}} FC2 FC2} Fp[3] FC13{ m FL[2] Fc Fi FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 Fi[3] FC2 FC2 FC2 FL[2] Fi[4] FC2 FC2 Fi[2] FL Fi[5] FL Fc} FC2}


void  S18291C1 ::mf18291c1(){}

static void Test_S18291C1()
{
  {
    init_simple_test("S18291C1");
    S18291C1 lv;
    check2(sizeof(lv), ABISELECT(640,488), "sizeof(S18291C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S18291C1)");
    check_field_offset(lv, s18291c1f0, 0, "S18291C1.s18291c1f0");
    check_field_offset(lv, s18291c1f1, ABISELECT(24,12), "S18291C1.s18291c1f1");
    check_field_offset(lv, s18291c1f2, ABISELECT(40,24), "S18291C1.s18291c1f2");
    check_field_offset(lv, s18291c1f3, ABISELECT(48,32), "S18291C1.s18291c1f3");
    check_field_offset(lv, s18291c1f4, ABISELECT(72,48), "S18291C1.s18291c1f4");
    check_field_offset(lv, s18291c1f5, ABISELECT(200,144), "S18291C1.s18291c1f5");
    check_field_offset(lv, s18291c1f6, ABISELECT(224,156), "S18291C1.s18291c1f6");
    check_field_offset(lv, s18291c1f7, ABISELECT(624,476), "S18291C1.s18291c1f7");
  }
}
static Arrange_To_Call_Me vS18291C1(Test_S18291C1, "S18291C1", ABISELECT(640,488));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2427C6_nt  {
  ::S2122C20_nt s2427c6f0;
  ::S2122C20_nt s2427c6f1;
  __tsi64 s2427c6f2;
  void  mf2427c6(); // _ZN10S2427C6_nt8mf2427c6Ev
};
//SIG(-1 S2427C6_nt) C1{ m FC2{ m Fp Fi FC3{ m}} FC2 FL}


void  S2427C6_nt ::mf2427c6(){}

//skip512 S2427C6_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2427C5  {
  ::S2427C6_nt s2427c5f0;
  long s2427c5f1;
  int s2427c5f2;
  char s2427c5f3[2];
  ::S2122C20_nt s2427c5f4;
  void *s2427c5f5;
  int s2427c5f6;
  ::S2122C20_nt s2427c5f7[9];
  ::S2122C20_nt s2427c5f8;
  ::S2122C20_nt s2427c5f9;
  int s2427c5f10;
  ::S2122C20_nt s2427c5f11;
  ::S2122C20_nt s2427c5f12;
  ::S2122C20_nt s2427c5f13;
  int s2427c5f14[4];
  void  mf2427c5(); // _ZN7S2427C58mf2427c5Ev
};
//SIG(-1 S2427C5) C1{ m FC2{ m FC3{ m Fp Fi FC4{ m}} FC3 FL} Fl Fi Fc[2] FC3 Fp Fi FC3[9] FC3 FC3 Fi FC3 FC3 FC3 Fi[4]}


void  S2427C5 ::mf2427c5(){}

static void Test_S2427C5()
{
  {
    init_simple_test("S2427C5");
    S2427C5 lv;
    check2(sizeof(lv), ABISELECT(336,252), "sizeof(S2427C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2427C5)");
    check_field_offset(lv, s2427c5f0, 0, "S2427C5.s2427c5f0");
    check_field_offset(lv, s2427c5f1, ABISELECT(40,32), "S2427C5.s2427c5f1");
    check_field_offset(lv, s2427c5f2, ABISELECT(48,36), "S2427C5.s2427c5f2");
    check_field_offset(lv, s2427c5f3, ABISELECT(52,40), "S2427C5.s2427c5f3");
    check_field_offset(lv, s2427c5f4, ABISELECT(56,44), "S2427C5.s2427c5f4");
    check_field_offset(lv, s2427c5f5, ABISELECT(72,56), "S2427C5.s2427c5f5");
    check_field_offset(lv, s2427c5f6, ABISELECT(80,60), "S2427C5.s2427c5f6");
    check_field_offset(lv, s2427c5f7, ABISELECT(88,64), "S2427C5.s2427c5f7");
    check_field_offset(lv, s2427c5f8, ABISELECT(232,172), "S2427C5.s2427c5f8");
    check_field_offset(lv, s2427c5f9, ABISELECT(248,184), "S2427C5.s2427c5f9");
    check_field_offset(lv, s2427c5f10, ABISELECT(264,196), "S2427C5.s2427c5f10");
    check_field_offset(lv, s2427c5f11, ABISELECT(272,200), "S2427C5.s2427c5f11");
    check_field_offset(lv, s2427c5f12, ABISELECT(288,212), "S2427C5.s2427c5f12");
    check_field_offset(lv, s2427c5f13, ABISELECT(304,224), "S2427C5.s2427c5f13");
    check_field_offset(lv, s2427c5f14, ABISELECT(320,236), "S2427C5.s2427c5f14");
  }
}
static Arrange_To_Call_Me vS2427C5(Test_S2427C5, "S2427C5", ABISELECT(336,252));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2427C4  {
  ::S2427C5 s2427c4f0;
  void *s2427c4f1;
  __tsi64 s2427c4f2;
  int s2427c4f3;
  void *s2427c4f4;
  virtual  ~S2427C4(); // _ZN7S2427C4D1Ev
  virtual void  v8(); // _ZN7S2427C42v8Ev
  virtual void  v9(); // _ZN7S2427C42v9Ev
  virtual void  v10(); // _ZN7S2427C43v10Ev
  virtual void  v11(); // _ZN7S2427C43v11Ev
  S2427C4(); // tgen
};
//SIG(-1 S2427C4) C1{ vd v1 v2 v3 v4 FC2{ m FC3{ m FC4{ m Fp Fi FC5{ m}} FC4 FL} Fl Fi Fc[2] FC4 Fp Fi FC4[9] FC4 FC4 Fi FC4 FC4 FC4 Fi[4]} Fp FL Fi Fp}


 S2427C4 ::~S2427C4(){ note_dtor("S2427C4", this);}
void  S2427C4 ::v8(){vfunc_called(this, "_ZN7S2427C42v8Ev");}
void  S2427C4 ::v9(){vfunc_called(this, "_ZN7S2427C42v9Ev");}
void  S2427C4 ::v10(){vfunc_called(this, "_ZN7S2427C43v10Ev");}
void  S2427C4 ::v11(){vfunc_called(this, "_ZN7S2427C43v11Ev");}
S2427C4 ::S2427C4(){ note_ctor("S2427C4", this);} // tgen

static void Test_S2427C4()
{
  extern Class_Descriptor cd_S2427C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(48,70)];
    init_test(&cd_S2427C4, buf);
    S2427C4 *dp, &lv = *(dp=new (buf) S2427C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(376,276), "sizeof(S2427C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2427C4)");
    check_field_offset(lv, s2427c4f0, ABISELECT(8,4), "S2427C4.s2427c4f0");
    check_field_offset(lv, s2427c4f1, ABISELECT(344,256), "S2427C4.s2427c4f1");
    check_field_offset(lv, s2427c4f2, ABISELECT(352,260), "S2427C4.s2427c4f2");
    check_field_offset(lv, s2427c4f3, ABISELECT(360,268), "S2427C4.s2427c4f3");
    check_field_offset(lv, s2427c4f4, ABISELECT(368,272), "S2427C4.s2427c4f4");
    test_class_info(&lv, &cd_S2427C4);
    dp->~S2427C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2427C4(Test_S2427C4, "S2427C4", ABISELECT(376,276));

#else // __cplusplus

extern void _ZN7S2427C4C1Ev();
extern void _ZN7S2427C4D1Ev();
Name_Map name_map_S2427C4[] = {
  NSPAIR(_ZN7S2427C4C1Ev),
  NSPAIR(_ZN7S2427C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2427C4[];
extern void _ZN7S2427C4D1Ev();
extern void _ZN7S2427C4D0Ev();
extern void _ZN7S2427C42v8Ev();
extern void _ZN7S2427C42v9Ev();
extern void _ZN7S2427C43v10Ev();
extern void _ZN7S2427C43v11Ev();
static  VTBL_ENTRY vtc_S2427C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2427C4[0]),
  (VTBL_ENTRY)&_ZN7S2427C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2427C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2427C42v8Ev,
  (VTBL_ENTRY)&_ZN7S2427C42v9Ev,
  (VTBL_ENTRY)&_ZN7S2427C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2427C43v11Ev,
};
extern VTBL_ENTRY _ZTI7S2427C4[];
extern  VTBL_ENTRY _ZTV7S2427C4[];
Class_Descriptor cd_S2427C4 = {  "S2427C4", // class name
  0,0,//no base classes
  &(vtc_S2427C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(376,276), // object size
  NSPAIRA(_ZTI7S2427C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2427C4),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2427C3  : S2427C4 {
  void *s2427c3f0;
  virtual  ~S2427C3(); // _ZN7S2427C3D1Ev
  virtual void  v12(); // _ZN7S2427C33v12Ev
  virtual void  v13(); // _ZN7S2427C33v13Ev
  virtual void  v14(); // _ZN7S2427C33v14Ev
  virtual void  v15(); // _ZN7S2427C33v15Ev
  virtual void  v16(); // _ZN7S2427C33v16Ev
  virtual void  v17(); // _ZN7S2427C33v17Ev
  virtual void  v18(); // _ZN7S2427C33v18Ev
  virtual void  v19(); // _ZN7S2427C33v19Ev
  virtual void  v20(); // _ZN7S2427C33v20Ev
  S2427C3(); // tgen
};
//SIG(-1 S2427C3) C1{ BC2{ vd v10 v11 v12 v13 FC3{ m FC4{ m FC5{ m Fp Fi FC6{ m}} FC5 FL} Fl Fi Fc[2] FC5 Fp Fi FC5[9] FC5 FC5 Fi FC5 FC5 FC5 Fi[4]} Fp FL Fi Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fp}


 S2427C3 ::~S2427C3(){ note_dtor("S2427C3", this);}
void  S2427C3 ::v12(){vfunc_called(this, "_ZN7S2427C33v12Ev");}
void  S2427C3 ::v13(){vfunc_called(this, "_ZN7S2427C33v13Ev");}
void  S2427C3 ::v14(){vfunc_called(this, "_ZN7S2427C33v14Ev");}
void  S2427C3 ::v15(){vfunc_called(this, "_ZN7S2427C33v15Ev");}
void  S2427C3 ::v16(){vfunc_called(this, "_ZN7S2427C33v16Ev");}
void  S2427C3 ::v17(){vfunc_called(this, "_ZN7S2427C33v17Ev");}
void  S2427C3 ::v18(){vfunc_called(this, "_ZN7S2427C33v18Ev");}
void  S2427C3 ::v19(){vfunc_called(this, "_ZN7S2427C33v19Ev");}
void  S2427C3 ::v20(){vfunc_called(this, "_ZN7S2427C33v20Ev");}
S2427C3 ::S2427C3(){ note_ctor("S2427C3", this);} // tgen

static void Test_S2427C3()
{
  extern Class_Descriptor cd_S2427C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(49,71)];
    init_test(&cd_S2427C3, buf);
    S2427C3 *dp, &lv = *(dp=new (buf) S2427C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(384,280), "sizeof(S2427C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2427C3)");
    check_base_class_offset(lv, (S2427C4*), 0, "S2427C3");
    check_field_offset(lv, s2427c3f0, ABISELECT(376,276), "S2427C3.s2427c3f0");
    test_class_info(&lv, &cd_S2427C3);
    dp->~S2427C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2427C3(Test_S2427C3, "S2427C3", ABISELECT(384,280));

#else // __cplusplus

extern void _ZN7S2427C3C1Ev();
extern void _ZN7S2427C3D1Ev();
Name_Map name_map_S2427C3[] = {
  NSPAIR(_ZN7S2427C3C1Ev),
  NSPAIR(_ZN7S2427C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2427C4;
extern VTBL_ENTRY _ZTI7S2427C4[];
extern  VTBL_ENTRY _ZTV7S2427C4[];
static Base_Class bases_S2427C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2427C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2427C3[];
extern void _ZN7S2427C3D1Ev();
extern void _ZN7S2427C3D0Ev();
extern void _ZN7S2427C42v8Ev();
extern void _ZN7S2427C42v9Ev();
extern void _ZN7S2427C43v10Ev();
extern void _ZN7S2427C43v11Ev();
extern void _ZN7S2427C33v12Ev();
extern void _ZN7S2427C33v13Ev();
extern void _ZN7S2427C33v14Ev();
extern void _ZN7S2427C33v15Ev();
extern void _ZN7S2427C33v16Ev();
extern void _ZN7S2427C33v17Ev();
extern void _ZN7S2427C33v18Ev();
extern void _ZN7S2427C33v19Ev();
extern void _ZN7S2427C33v20Ev();
static  VTBL_ENTRY vtc_S2427C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2427C3[0]),
  (VTBL_ENTRY)&_ZN7S2427C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2427C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2427C42v8Ev,
  (VTBL_ENTRY)&_ZN7S2427C42v9Ev,
  (VTBL_ENTRY)&_ZN7S2427C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2427C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2427C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2427C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2427C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2427C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2427C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2427C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2427C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2427C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2427C33v20Ev,
};
extern VTBL_ENTRY _ZTI7S2427C3[];
extern  VTBL_ENTRY _ZTV7S2427C3[];
Class_Descriptor cd_S2427C3 = {  "S2427C3", // class name
  bases_S2427C3, 1,
  &(vtc_S2427C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(384,280), // object size
  NSPAIRA(_ZTI7S2427C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2427C3),17, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2427C9_nt  {
  ::S2122C37 s2427c9f0;
  void *s2427c9f1[2];
  void  mf2427c9(); // _ZN10S2427C9_nt8mf2427c9Ev
};
//SIG(-1 S2427C9_nt) C1{ m FC2{ m Fp Fi[2] FC3{ m}} Fp[2]}


void  S2427C9_nt ::mf2427c9(){}

//skip512 S2427C9_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2427C2  : S2427C3 {
  ::S2427C9_nt s2427c2f0;
  void *s2427c2f1[2];
  virtual  ~S2427C2(); // _ZN7S2427C2D1Ev
  virtual void  v21(); // _ZN7S2427C23v21Ev
  virtual void  v22(); // _ZN7S2427C23v22Ev
  virtual void  v23(); // _ZN7S2427C23v23Ev
  virtual void  v24(); // _ZN7S2427C23v24Ev
  virtual void  v25(); // _ZN7S2427C23v25Ev
  virtual void  v26(); // _ZN7S2427C23v26Ev
  virtual void  v27(); // _ZN7S2427C23v27Ev
  virtual void  v28(); // _ZN7S2427C23v28Ev
  virtual void  v29(); // _ZN7S2427C23v29Ev
  S2427C2(); // tgen
};
//SIG(-1 S2427C2) C1{ BC2{ BC3{ vd v10 v11 v12 v13 FC4{ m FC5{ m FC6{ m Fp Fi FC7{ m}} FC6 FL} Fl Fi Fc[2] FC6 Fp Fi FC6[9] FC6 FC6 Fi FC6 FC6 FC6 Fi[4]} Fp FL Fi Fp} vd v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 FC8{ m FC9{ m Fp Fi[2] FC10{ m}} Fp[2]} Fp[2]}


 S2427C2 ::~S2427C2(){ note_dtor("S2427C2", this);}
void  S2427C2 ::v21(){vfunc_called(this, "_ZN7S2427C23v21Ev");}
void  S2427C2 ::v22(){vfunc_called(this, "_ZN7S2427C23v22Ev");}
void  S2427C2 ::v23(){vfunc_called(this, "_ZN7S2427C23v23Ev");}
void  S2427C2 ::v24(){vfunc_called(this, "_ZN7S2427C23v24Ev");}
void  S2427C2 ::v25(){vfunc_called(this, "_ZN7S2427C23v25Ev");}
void  S2427C2 ::v26(){vfunc_called(this, "_ZN7S2427C23v26Ev");}
void  S2427C2 ::v27(){vfunc_called(this, "_ZN7S2427C23v27Ev");}
void  S2427C2 ::v28(){vfunc_called(this, "_ZN7S2427C23v28Ev");}
void  S2427C2 ::v29(){vfunc_called(this, "_ZN7S2427C23v29Ev");}
S2427C2 ::S2427C2(){ note_ctor("S2427C2", this);} // tgen

static void Test_S2427C2()
{
  extern Class_Descriptor cd_S2427C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(56,79)];
    init_test(&cd_S2427C2, buf);
    S2427C2 *dp, &lv = *(dp=new (buf) S2427C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(440,312), "sizeof(S2427C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2427C2)");
    check_base_class_offset(lv, (S2427C4*)(S2427C3*), 0, "S2427C2");
    check_base_class_offset(lv, (S2427C3*), 0, "S2427C2");
    check_field_offset(lv, s2427c2f0, ABISELECT(384,280), "S2427C2.s2427c2f0");
    check_field_offset(lv, s2427c2f1, ABISELECT(424,304), "S2427C2.s2427c2f1");
    test_class_info(&lv, &cd_S2427C2);
    dp->~S2427C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2427C2(Test_S2427C2, "S2427C2", ABISELECT(440,312));

#else // __cplusplus

extern void _ZN7S2427C2C1Ev();
extern void _ZN7S2427C2D1Ev();
Name_Map name_map_S2427C2[] = {
  NSPAIR(_ZN7S2427C2C1Ev),
  NSPAIR(_ZN7S2427C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2427C4;
extern VTBL_ENTRY _ZTI7S2427C4[];
extern  VTBL_ENTRY _ZTV7S2427C4[];
extern Class_Descriptor cd_S2427C3;
extern VTBL_ENTRY _ZTI7S2427C3[];
extern  VTBL_ENTRY _ZTV7S2427C3[];
static Base_Class bases_S2427C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2427C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2427C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2427C2[];
extern void _ZN7S2427C2D1Ev();
extern void _ZN7S2427C2D0Ev();
extern void _ZN7S2427C42v8Ev();
extern void _ZN7S2427C42v9Ev();
extern void _ZN7S2427C43v10Ev();
extern void _ZN7S2427C43v11Ev();
extern void _ZN7S2427C33v12Ev();
extern void _ZN7S2427C33v13Ev();
extern void _ZN7S2427C33v14Ev();
extern void _ZN7S2427C33v15Ev();
extern void _ZN7S2427C33v16Ev();
extern void _ZN7S2427C33v17Ev();
extern void _ZN7S2427C33v18Ev();
extern void _ZN7S2427C33v19Ev();
extern void _ZN7S2427C33v20Ev();
extern void _ZN7S2427C23v21Ev();
extern void _ZN7S2427C23v22Ev();
extern void _ZN7S2427C23v23Ev();
extern void _ZN7S2427C23v24Ev();
extern void _ZN7S2427C23v25Ev();
extern void _ZN7S2427C23v26Ev();
extern void _ZN7S2427C23v27Ev();
extern void _ZN7S2427C23v28Ev();
extern void _ZN7S2427C23v29Ev();
static  VTBL_ENTRY vtc_S2427C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2427C2[0]),
  (VTBL_ENTRY)&_ZN7S2427C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2427C2D0Ev,
  (VTBL_ENTRY)&_ZN7S2427C42v8Ev,
  (VTBL_ENTRY)&_ZN7S2427C42v9Ev,
  (VTBL_ENTRY)&_ZN7S2427C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2427C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2427C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2427C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2427C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2427C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2427C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2427C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2427C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2427C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2427C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2427C23v21Ev,
  (VTBL_ENTRY)&_ZN7S2427C23v22Ev,
  (VTBL_ENTRY)&_ZN7S2427C23v23Ev,
  (VTBL_ENTRY)&_ZN7S2427C23v24Ev,
  (VTBL_ENTRY)&_ZN7S2427C23v25Ev,
  (VTBL_ENTRY)&_ZN7S2427C23v26Ev,
  (VTBL_ENTRY)&_ZN7S2427C23v27Ev,
  (VTBL_ENTRY)&_ZN7S2427C23v28Ev,
  (VTBL_ENTRY)&_ZN7S2427C23v29Ev,
};
extern VTBL_ENTRY _ZTI7S2427C2[];
extern  VTBL_ENTRY _ZTV7S2427C2[];
Class_Descriptor cd_S2427C2 = {  "S2427C2", // class name
  bases_S2427C2, 2,
  &(vtc_S2427C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(440,312), // object size
  NSPAIRA(_ZTI7S2427C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2427C2),26, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2427C1  : S2427C2 {
  void *s2427c1f0[2];
  ::S2427C9_nt s2427c1f1;
  virtual void  v1(); // _ZN7S2427C12v1Ev
  virtual void  v2(); // _ZN7S2427C12v2Ev
  virtual void  v3(); // _ZN7S2427C12v3Ev
  virtual void  v4(); // _ZN7S2427C12v4Ev
  virtual void  v5(); // _ZN7S2427C12v5Ev
  virtual void  v6(); // _ZN7S2427C12v6Ev
  virtual void  v7(); // _ZN7S2427C12v7Ev
  ~S2427C1(); // tgen
  S2427C1(); // tgen
};
//SIG(1 S2427C1) C1{ BC2{ BC3{ BC4{ vd v8 v9 v10 v11 FC5{ m FC6{ m FC7{ m Fp Fi FC8{ m}} FC7 FL} Fl Fi Fc[2] FC7 Fp Fi FC7[9] FC7 FC7 Fi FC7 FC7 FC7 Fi[4]} Fp FL Fi Fp} vd v12 v13 v14 v15 v16 v17 v18 v19 v20 Fp} vd v21 v22 v23 v24 v25 v26 v27 v28 v29 FC9{ m FC10{ m Fp Fi[2] FC11{ m}} Fp[2]} Fp[2]} v1 v2 v3 v4 v5 v6 v7 Fp[2] FC9}


void  S2427C1 ::v1(){vfunc_called(this, "_ZN7S2427C12v1Ev");}
void  S2427C1 ::v2(){vfunc_called(this, "_ZN7S2427C12v2Ev");}
void  S2427C1 ::v3(){vfunc_called(this, "_ZN7S2427C12v3Ev");}
void  S2427C1 ::v4(){vfunc_called(this, "_ZN7S2427C12v4Ev");}
void  S2427C1 ::v5(){vfunc_called(this, "_ZN7S2427C12v5Ev");}
void  S2427C1 ::v6(){vfunc_called(this, "_ZN7S2427C12v6Ev");}
void  S2427C1 ::v7(){vfunc_called(this, "_ZN7S2427C12v7Ev");}
S2427C1 ::~S2427C1(){ note_dtor("S2427C1", this);} // tgen
S2427C1 ::S2427C1(){ note_ctor("S2427C1", this);} // tgen

static void Test_S2427C1()
{
  extern Class_Descriptor cd_S2427C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(63,87)];
    init_test(&cd_S2427C1, buf);
    S2427C1 *dp, &lv = *(dp=new (buf) S2427C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(496,344), "sizeof(S2427C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2427C1)");
    check_base_class_offset(lv, (S2427C4*)(S2427C3*)(S2427C2*), 0, "S2427C1");
    check_base_class_offset(lv, (S2427C3*)(S2427C2*), 0, "S2427C1");
    check_base_class_offset(lv, (S2427C2*), 0, "S2427C1");
    check_field_offset(lv, s2427c1f0, ABISELECT(440,312), "S2427C1.s2427c1f0");
    check_field_offset(lv, s2427c1f1, ABISELECT(456,320), "S2427C1.s2427c1f1");
    test_class_info(&lv, &cd_S2427C1);
    dp->~S2427C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2427C1(Test_S2427C1, "S2427C1", ABISELECT(496,344));

#else // __cplusplus

extern void _ZN7S2427C1C1Ev();
extern void _ZN7S2427C1D1Ev();
Name_Map name_map_S2427C1[] = {
  NSPAIR(_ZN7S2427C1C1Ev),
  NSPAIR(_ZN7S2427C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2427C4;
extern VTBL_ENTRY _ZTI7S2427C4[];
extern  VTBL_ENTRY _ZTV7S2427C4[];
extern Class_Descriptor cd_S2427C3;
extern VTBL_ENTRY _ZTI7S2427C3[];
extern  VTBL_ENTRY _ZTV7S2427C3[];
extern Class_Descriptor cd_S2427C2;
extern VTBL_ENTRY _ZTI7S2427C2[];
extern  VTBL_ENTRY _ZTV7S2427C2[];
static Base_Class bases_S2427C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2427C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2427C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2427C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2427C1[];
extern void _ZN7S2427C1D1Ev();
extern void _ZN7S2427C1D0Ev();
extern void _ZN7S2427C42v8Ev();
extern void _ZN7S2427C42v9Ev();
extern void _ZN7S2427C43v10Ev();
extern void _ZN7S2427C43v11Ev();
extern void _ZN7S2427C33v12Ev();
extern void _ZN7S2427C33v13Ev();
extern void _ZN7S2427C33v14Ev();
extern void _ZN7S2427C33v15Ev();
extern void _ZN7S2427C33v16Ev();
extern void _ZN7S2427C33v17Ev();
extern void _ZN7S2427C33v18Ev();
extern void _ZN7S2427C33v19Ev();
extern void _ZN7S2427C33v20Ev();
extern void _ZN7S2427C23v21Ev();
extern void _ZN7S2427C23v22Ev();
extern void _ZN7S2427C23v23Ev();
extern void _ZN7S2427C23v24Ev();
extern void _ZN7S2427C23v25Ev();
extern void _ZN7S2427C23v26Ev();
extern void _ZN7S2427C23v27Ev();
extern void _ZN7S2427C23v28Ev();
extern void _ZN7S2427C23v29Ev();
extern void _ZN7S2427C12v1Ev();
extern void _ZN7S2427C12v2Ev();
extern void _ZN7S2427C12v3Ev();
extern void _ZN7S2427C12v4Ev();
extern void _ZN7S2427C12v5Ev();
extern void _ZN7S2427C12v6Ev();
extern void _ZN7S2427C12v7Ev();
static  VTBL_ENTRY vtc_S2427C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2427C1[0]),
  (VTBL_ENTRY)&_ZN7S2427C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2427C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2427C42v8Ev,
  (VTBL_ENTRY)&_ZN7S2427C42v9Ev,
  (VTBL_ENTRY)&_ZN7S2427C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2427C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2427C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2427C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2427C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2427C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2427C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2427C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2427C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2427C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2427C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2427C23v21Ev,
  (VTBL_ENTRY)&_ZN7S2427C23v22Ev,
  (VTBL_ENTRY)&_ZN7S2427C23v23Ev,
  (VTBL_ENTRY)&_ZN7S2427C23v24Ev,
  (VTBL_ENTRY)&_ZN7S2427C23v25Ev,
  (VTBL_ENTRY)&_ZN7S2427C23v26Ev,
  (VTBL_ENTRY)&_ZN7S2427C23v27Ev,
  (VTBL_ENTRY)&_ZN7S2427C23v28Ev,
  (VTBL_ENTRY)&_ZN7S2427C23v29Ev,
  (VTBL_ENTRY)&_ZN7S2427C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2427C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2427C12v3Ev,
  (VTBL_ENTRY)&_ZN7S2427C12v4Ev,
  (VTBL_ENTRY)&_ZN7S2427C12v5Ev,
  (VTBL_ENTRY)&_ZN7S2427C12v6Ev,
  (VTBL_ENTRY)&_ZN7S2427C12v7Ev,
};
extern VTBL_ENTRY _ZTI7S2427C1[];
extern  VTBL_ENTRY _ZTV7S2427C1[];
Class_Descriptor cd_S2427C1 = {  "S2427C1", // class name
  bases_S2427C1, 3,
  &(vtc_S2427C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(496,344), // object size
  NSPAIRA(_ZTI7S2427C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2427C1),33, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7167C2_nt  {
  void *s7167c2f0;
  ::S2122C25 s7167c2f1;
  virtual  ~S7167C2_nt(); // _ZN10S7167C2_ntD1Ev
  virtual void  v8(); // _ZN10S7167C2_nt2v8Ev
  virtual void  v9(); // _ZN10S7167C2_nt2v9Ev
  virtual void  v10(); // _ZN10S7167C2_nt3v10Ev
  virtual void  v11(); // _ZN10S7167C2_nt3v11Ev
  virtual void  v12(); // _ZN10S7167C2_nt3v12Ev
  virtual void  v13(); // _ZN10S7167C2_nt3v13Ev
  virtual void  v14(); // _ZN10S7167C2_nt3v14Ev
  virtual void  v15(); // _ZN10S7167C2_nt3v15Ev
  virtual void  v16(); // _ZN10S7167C2_nt3v16Ev
  virtual void  v17(); // _ZN10S7167C2_nt3v17Ev
  virtual void  v18(); // _ZN10S7167C2_nt3v18Ev
  virtual void  v19(); // _ZN10S7167C2_nt3v19Ev
  virtual void  v20(); // _ZN10S7167C2_nt3v20Ev
  virtual void  v21(); // _ZN10S7167C2_nt3v21Ev
  virtual void  v22(); // _ZN10S7167C2_nt3v22Ev
  S7167C2_nt(); // tgen
};
//SIG(-1 S7167C2_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 Fp FC2{ BC3{ m Fp Fi FC4{ m} FC5{ m}}}}


 S7167C2_nt ::~S7167C2_nt(){ note_dtor("S7167C2_nt", this);}
void  S7167C2_nt ::v8(){vfunc_called(this, "_ZN10S7167C2_nt2v8Ev");}
void  S7167C2_nt ::v9(){vfunc_called(this, "_ZN10S7167C2_nt2v9Ev");}
void  S7167C2_nt ::v10(){vfunc_called(this, "_ZN10S7167C2_nt3v10Ev");}
void  S7167C2_nt ::v11(){vfunc_called(this, "_ZN10S7167C2_nt3v11Ev");}
void  S7167C2_nt ::v12(){vfunc_called(this, "_ZN10S7167C2_nt3v12Ev");}
void  S7167C2_nt ::v13(){vfunc_called(this, "_ZN10S7167C2_nt3v13Ev");}
void  S7167C2_nt ::v14(){vfunc_called(this, "_ZN10S7167C2_nt3v14Ev");}
void  S7167C2_nt ::v15(){vfunc_called(this, "_ZN10S7167C2_nt3v15Ev");}
void  S7167C2_nt ::v16(){vfunc_called(this, "_ZN10S7167C2_nt3v16Ev");}
void  S7167C2_nt ::v17(){vfunc_called(this, "_ZN10S7167C2_nt3v17Ev");}
void  S7167C2_nt ::v18(){vfunc_called(this, "_ZN10S7167C2_nt3v18Ev");}
void  S7167C2_nt ::v19(){vfunc_called(this, "_ZN10S7167C2_nt3v19Ev");}
void  S7167C2_nt ::v20(){vfunc_called(this, "_ZN10S7167C2_nt3v20Ev");}
void  S7167C2_nt ::v21(){vfunc_called(this, "_ZN10S7167C2_nt3v21Ev");}
void  S7167C2_nt ::v22(){vfunc_called(this, "_ZN10S7167C2_nt3v22Ev");}
S7167C2_nt ::S7167C2_nt(){ note_ctor("S7167C2_nt", this);} // tgen

//skip512 S7167C2_nt

#else // __cplusplus

extern void _ZN10S7167C2_ntC1Ev();
extern void _ZN10S7167C2_ntD1Ev();
Name_Map name_map_S7167C2_nt[] = {
  NSPAIR(_ZN10S7167C2_ntC1Ev),
  NSPAIR(_ZN10S7167C2_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S7167C2_nt[];
extern void _ZN10S7167C2_ntD1Ev();
extern void _ZN10S7167C2_ntD0Ev();
extern void _ZN10S7167C2_nt2v8Ev();
extern void _ZN10S7167C2_nt2v9Ev();
extern void _ZN10S7167C2_nt3v10Ev();
extern void _ZN10S7167C2_nt3v11Ev();
extern void _ZN10S7167C2_nt3v12Ev();
extern void _ZN10S7167C2_nt3v13Ev();
extern void _ZN10S7167C2_nt3v14Ev();
extern void _ZN10S7167C2_nt3v15Ev();
extern void _ZN10S7167C2_nt3v16Ev();
extern void _ZN10S7167C2_nt3v17Ev();
extern void _ZN10S7167C2_nt3v18Ev();
extern void _ZN10S7167C2_nt3v19Ev();
extern void _ZN10S7167C2_nt3v20Ev();
extern void _ZN10S7167C2_nt3v21Ev();
extern void _ZN10S7167C2_nt3v22Ev();
static  VTBL_ENTRY vtc_S7167C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S7167C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S7167C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S7167C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S7167C2_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S7167C2_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S7167C2_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S7167C2_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S7167C2_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S7167C2_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S7167C2_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S7167C2_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S7167C2_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S7167C2_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S7167C2_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S7167C2_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S7167C2_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S7167C2_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S7167C2_nt3v22Ev,
};
extern VTBL_ENTRY _ZTI10S7167C2_nt[];
VTBL_ENTRY *P__ZTI10S7167C2_nt = _ZTI10S7167C2_nt; 
extern  VTBL_ENTRY _ZTV10S7167C2_nt[];
Class_Descriptor cd_S7167C2_nt = {  "S7167C2_nt", // class name
  0,0,//no base classes
  &(vtc_S7167C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI10S7167C2_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S7167C2_nt),19, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7167C9_nt  {
  virtual  ~S7167C9_nt(); // _ZN10S7167C9_ntD1Ev
  virtual void  v23(); // _ZN10S7167C9_nt3v23Ev
  virtual void  v24(); // _ZN10S7167C9_nt3v24Ev
  virtual void  v25(); // _ZN10S7167C9_nt3v25Ev
  S7167C9_nt(); // tgen
};
//SIG(-1 S7167C9_nt) C1{ vd v1 v2 v3}


 S7167C9_nt ::~S7167C9_nt(){ note_dtor("S7167C9_nt", this);}
void  S7167C9_nt ::v23(){vfunc_called(this, "_ZN10S7167C9_nt3v23Ev");}
void  S7167C9_nt ::v24(){vfunc_called(this, "_ZN10S7167C9_nt3v24Ev");}
void  S7167C9_nt ::v25(){vfunc_called(this, "_ZN10S7167C9_nt3v25Ev");}
S7167C9_nt ::S7167C9_nt(){ note_ctor("S7167C9_nt", this);} // tgen

//skip512 S7167C9_nt

#else // __cplusplus

extern void _ZN10S7167C9_ntC1Ev();
extern void _ZN10S7167C9_ntD1Ev();
Name_Map name_map_S7167C9_nt[] = {
  NSPAIR(_ZN10S7167C9_ntC1Ev),
  NSPAIR(_ZN10S7167C9_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S7167C9_nt[];
extern void _ZN10S7167C9_ntD1Ev();
extern void _ZN10S7167C9_ntD0Ev();
extern void _ZN10S7167C9_nt3v23Ev();
extern void _ZN10S7167C9_nt3v24Ev();
extern void _ZN10S7167C9_nt3v25Ev();
static  VTBL_ENTRY vtc_S7167C9_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S7167C9_nt[0]),
  (VTBL_ENTRY)&_ZN10S7167C9_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S7167C9_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S7167C9_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S7167C9_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S7167C9_nt3v25Ev,
};
extern VTBL_ENTRY _ZTI10S7167C9_nt[];
VTBL_ENTRY *P__ZTI10S7167C9_nt = _ZTI10S7167C9_nt; 
extern  VTBL_ENTRY _ZTV10S7167C9_nt[];
Class_Descriptor cd_S7167C9_nt = {  "S7167C9_nt", // class name
  0,0,//no base classes
  &(vtc_S7167C9_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S7167C9_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S7167C9_nt),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7167C8_nt  : S7167C9_nt {
  virtual  ~S7167C8_nt(); // _ZN10S7167C8_ntD1Ev
  virtual void  v26(); // _ZN10S7167C8_nt3v26Ev
  virtual void  v27(); // _ZN10S7167C8_nt3v27Ev
  virtual void  v28(); // _ZN10S7167C8_nt3v28Ev
  virtual void  v29(); // _ZN10S7167C8_nt3v29Ev
  virtual void  v30(); // _ZN10S7167C8_nt3v30Ev
  virtual void  v31(); // _ZN10S7167C8_nt3v31Ev
  S7167C8_nt(); // tgen
};
//SIG(-1 S7167C8_nt) C1{ BC2{ vd v7 v8 v9} vd v1 v2 v3 v4 v5 v6}


 S7167C8_nt ::~S7167C8_nt(){ note_dtor("S7167C8_nt", this);}
void  S7167C8_nt ::v26(){vfunc_called(this, "_ZN10S7167C8_nt3v26Ev");}
void  S7167C8_nt ::v27(){vfunc_called(this, "_ZN10S7167C8_nt3v27Ev");}
void  S7167C8_nt ::v28(){vfunc_called(this, "_ZN10S7167C8_nt3v28Ev");}
void  S7167C8_nt ::v29(){vfunc_called(this, "_ZN10S7167C8_nt3v29Ev");}
void  S7167C8_nt ::v30(){vfunc_called(this, "_ZN10S7167C8_nt3v30Ev");}
void  S7167C8_nt ::v31(){vfunc_called(this, "_ZN10S7167C8_nt3v31Ev");}
S7167C8_nt ::S7167C8_nt(){ note_ctor("S7167C8_nt", this);} // tgen

//skip512 S7167C8_nt

#else // __cplusplus

extern void _ZN10S7167C8_ntC1Ev();
extern void _ZN10S7167C8_ntD1Ev();
Name_Map name_map_S7167C8_nt[] = {
  NSPAIR(_ZN10S7167C8_ntC1Ev),
  NSPAIR(_ZN10S7167C8_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7167C9_nt;
extern VTBL_ENTRY _ZTI10S7167C9_nt[];
extern  VTBL_ENTRY _ZTV10S7167C9_nt[];
static Base_Class bases_S7167C8_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7167C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S7167C8_nt[];
extern void _ZN10S7167C8_ntD1Ev();
extern void _ZN10S7167C8_ntD0Ev();
extern void _ZN10S7167C9_nt3v23Ev();
extern void _ZN10S7167C9_nt3v24Ev();
extern void _ZN10S7167C9_nt3v25Ev();
extern void _ZN10S7167C8_nt3v26Ev();
extern void _ZN10S7167C8_nt3v27Ev();
extern void _ZN10S7167C8_nt3v28Ev();
extern void _ZN10S7167C8_nt3v29Ev();
extern void _ZN10S7167C8_nt3v30Ev();
extern void _ZN10S7167C8_nt3v31Ev();
static  VTBL_ENTRY vtc_S7167C8_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S7167C8_nt[0]),
  (VTBL_ENTRY)&_ZN10S7167C8_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S7167C8_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S7167C9_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S7167C9_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S7167C9_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S7167C8_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S7167C8_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S7167C8_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S7167C8_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S7167C8_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S7167C8_nt3v31Ev,
};
extern VTBL_ENTRY _ZTI10S7167C8_nt[];
VTBL_ENTRY *P__ZTI10S7167C8_nt = _ZTI10S7167C8_nt; 
extern  VTBL_ENTRY _ZTV10S7167C8_nt[];
Class_Descriptor cd_S7167C8_nt = {  "S7167C8_nt", // class name
  bases_S7167C8_nt, 1,
  &(vtc_S7167C8_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S7167C8_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S7167C8_nt),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7167C7_nt  : S7167C8_nt {
  ::S2122C37 s7167c7f0;
  ::S8547C12_nt s7167c7f1;
  char s7167c7f2;
  virtual  ~S7167C7_nt(); // _ZN10S7167C7_ntD1Ev
  virtual void  v32(); // _ZN10S7167C7_nt3v32Ev
  virtual void  v33(); // _ZN10S7167C7_nt3v33Ev
  virtual void  v34(); // _ZN10S7167C7_nt3v34Ev
  S7167C7_nt(); // tgen
};
//SIG(-1 S7167C7_nt) C1{ BC2{ BC3{ vd v4 v5 v6} vd v7 v8 v9 v10 v11 v12} vd v1 v2 v3 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FC7{ FL[4]}} Fc}


 S7167C7_nt ::~S7167C7_nt(){ note_dtor("S7167C7_nt", this);}
void  S7167C7_nt ::v32(){vfunc_called(this, "_ZN10S7167C7_nt3v32Ev");}
void  S7167C7_nt ::v33(){vfunc_called(this, "_ZN10S7167C7_nt3v33Ev");}
void  S7167C7_nt ::v34(){vfunc_called(this, "_ZN10S7167C7_nt3v34Ev");}
S7167C7_nt ::S7167C7_nt(){ note_ctor("S7167C7_nt", this);} // tgen

//skip512 S7167C7_nt

#else // __cplusplus

extern void _ZN10S7167C7_ntC1Ev();
extern void _ZN10S7167C7_ntD1Ev();
Name_Map name_map_S7167C7_nt[] = {
  NSPAIR(_ZN10S7167C7_ntC1Ev),
  NSPAIR(_ZN10S7167C7_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7167C9_nt;
extern VTBL_ENTRY _ZTI10S7167C9_nt[];
extern  VTBL_ENTRY _ZTV10S7167C9_nt[];
extern Class_Descriptor cd_S7167C8_nt;
extern VTBL_ENTRY _ZTI10S7167C8_nt[];
extern  VTBL_ENTRY _ZTV10S7167C8_nt[];
static Base_Class bases_S7167C7_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7167C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S7167C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S7167C7_nt[];
extern void _ZN10S7167C7_ntD1Ev();
extern void _ZN10S7167C7_ntD0Ev();
extern void _ZN10S7167C9_nt3v23Ev();
extern void _ZN10S7167C9_nt3v24Ev();
extern void _ZN10S7167C9_nt3v25Ev();
extern void _ZN10S7167C8_nt3v26Ev();
extern void _ZN10S7167C8_nt3v27Ev();
extern void _ZN10S7167C8_nt3v28Ev();
extern void _ZN10S7167C8_nt3v29Ev();
extern void _ZN10S7167C8_nt3v30Ev();
extern void _ZN10S7167C8_nt3v31Ev();
extern void _ZN10S7167C7_nt3v32Ev();
extern void _ZN10S7167C7_nt3v33Ev();
extern void _ZN10S7167C7_nt3v34Ev();
static  VTBL_ENTRY vtc_S7167C7_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S7167C7_nt[0]),
  (VTBL_ENTRY)&_ZN10S7167C7_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S7167C7_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S7167C9_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S7167C9_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S7167C9_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S7167C8_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S7167C8_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S7167C8_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S7167C8_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S7167C8_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S7167C8_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S7167C7_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S7167C7_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S7167C7_nt3v34Ev,
};
extern VTBL_ENTRY _ZTI10S7167C7_nt[];
VTBL_ENTRY *P__ZTI10S7167C7_nt = _ZTI10S7167C7_nt; 
extern  VTBL_ENTRY _ZTV10S7167C7_nt[];
Class_Descriptor cd_S7167C7_nt = {  "S7167C7_nt", // class name
  bases_S7167C7_nt, 2,
  &(vtc_S7167C7_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI10S7167C7_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S7167C7_nt),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7167C14_nt  {
  virtual  ~S7167C14_nt(); // _ZN11S7167C14_ntD1Ev
  virtual void  v35(); // _ZN11S7167C14_nt3v35Ev
  S7167C14_nt(); // tgen
};
//SIG(-1 S7167C14_nt) C1{ vd v1}


 S7167C14_nt ::~S7167C14_nt(){ note_dtor("S7167C14_nt", this);}
void  S7167C14_nt ::v35(){vfunc_called(this, "_ZN11S7167C14_nt3v35Ev");}
S7167C14_nt ::S7167C14_nt(){ note_ctor("S7167C14_nt", this);} // tgen

//skip512 S7167C14_nt

#else // __cplusplus

extern void _ZN11S7167C14_ntC1Ev();
extern void _ZN11S7167C14_ntD1Ev();
Name_Map name_map_S7167C14_nt[] = {
  NSPAIR(_ZN11S7167C14_ntC1Ev),
  NSPAIR(_ZN11S7167C14_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S7167C14_nt[];
extern void _ZN11S7167C14_ntD1Ev();
extern void _ZN11S7167C14_ntD0Ev();
extern void _ZN11S7167C14_nt3v35Ev();
static  VTBL_ENTRY vtc_S7167C14_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S7167C14_nt[0]),
  (VTBL_ENTRY)&_ZN11S7167C14_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S7167C14_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S7167C14_nt3v35Ev,
};
extern VTBL_ENTRY _ZTI11S7167C14_nt[];
VTBL_ENTRY *P__ZTI11S7167C14_nt = _ZTI11S7167C14_nt; 
extern  VTBL_ENTRY _ZTV11S7167C14_nt[];
Class_Descriptor cd_S7167C14_nt = {  "S7167C14_nt", // class name
  0,0,//no base classes
  &(vtc_S7167C14_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S7167C14_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S7167C14_nt),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7167C16_nt  {
};
//SIG(-1 S7167C16_nt) C1{}



//skip512 S7167C16_nt

#else // __cplusplus

Class_Descriptor cd_S7167C16_nt = {  "S7167C16_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7167C18_nt  {
  int s7167c18f0;
};
//SIG(-1 S7167C18_nt) C1{ Fi}



//skip512 S7167C18_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7167C15  : S7167C16_nt {
  ::S12863C26_nt s7167c15f0;
  ::S7167C18_nt s7167c15f1;
};
//SIG(-1 S7167C15) C1{ BC2{} FC3{ Fi} FC4{ Fi}}



static void Test_S7167C15()
{
  extern Class_Descriptor cd_S7167C15;
  void *lvp;
  {
    int buf[3];
    init_test(&cd_S7167C15, buf);
    S7167C15 &lv = *(new (buf) S7167C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(S7167C15)");
    check2(__alignof__(lv), 4, "__alignof__(S7167C15)");
    check_base_class_offset(lv, (S7167C16_nt*), 0, "S7167C15");
    check_field_offset(lv, s7167c15f0, 0, "S7167C15.s7167c15f0");
    check_field_offset(lv, s7167c15f1, 4, "S7167C15.s7167c15f1");
    test_class_info(&lv, &cd_S7167C15);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7167C15(Test_S7167C15, "S7167C15", 8);

#else // __cplusplus

extern Class_Descriptor cd_S7167C16_nt;
static Base_Class bases_S7167C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7167C16_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S7167C15 = {  "S7167C15", // class name
  bases_S7167C15, 1,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7167C1  : S7167C2_nt , S7167C7_nt , S7167C14_nt {
  ::S7167C15 s7167c1f0;
  int s7167c1f1;
  void *s7167c1f2;
  virtual  ~S7167C1(); // _ZN7S7167C1D1Ev
  virtual void  v1(); // _ZN7S7167C12v1Ev
  virtual void  v2(); // _ZN7S7167C12v2Ev
  virtual void  v3(); // _ZN7S7167C12v3Ev
  virtual void  v4(); // _ZN7S7167C12v4Ev
  virtual void  v5(); // _ZN7S7167C12v5Ev
  virtual void  v6(); // _ZN7S7167C12v6Ev
  virtual void  v7(); // _ZN7S7167C12v7Ev
  S7167C1(); // tgen
};
//SIG(1 S7167C1) C1{ BC2{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp FC3{ BC4{ m Fp Fi FC5{ m} FC6{ m}}}} BC7{ BC8{ BC9{ vd v23 v24 v25} vd v26 v27 v28 v29 v30 v31} vd v32 v33 v34 FC10{ m Fp Fi[2] FC11{ m}} FC12{ m FC13{ FL[4]}} Fc} BC14{ vd v35} vd v1 v2 v3 v4 v5 v6 v7 FC15{ BC16{} FC17{ Fi} FC18{ Fi}} Fi Fp}


 S7167C1 ::~S7167C1(){ note_dtor("S7167C1", this);}
void  S7167C1 ::v1(){vfunc_called(this, "_ZN7S7167C12v1Ev");}
void  S7167C1 ::v2(){vfunc_called(this, "_ZN7S7167C12v2Ev");}
void  S7167C1 ::v3(){vfunc_called(this, "_ZN7S7167C12v3Ev");}
void  S7167C1 ::v4(){vfunc_called(this, "_ZN7S7167C12v4Ev");}
void  S7167C1 ::v5(){vfunc_called(this, "_ZN7S7167C12v5Ev");}
void  S7167C1 ::v6(){vfunc_called(this, "_ZN7S7167C12v6Ev");}
void  S7167C1 ::v7(){vfunc_called(this, "_ZN7S7167C12v7Ev");}
S7167C1 ::S7167C1(){ note_ctor("S7167C1", this);} // tgen

static void Test_S7167C1()
{
  extern Class_Descriptor cd_S7167C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,25)];
    init_test(&cd_S7167C1, buf);
    S7167C1 *dp, &lv = *(dp=new (buf) S7167C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,96), "sizeof(S7167C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7167C1)");
    check_base_class_offset(lv, (S7167C2_nt*), 0, "S7167C1");
    check_base_class_offset(lv, (S7167C9_nt*)(S7167C8_nt*)(S7167C7_nt*), ABISELECT(32,20), "S7167C1");
    check_base_class_offset(lv, (S7167C8_nt*)(S7167C7_nt*), ABISELECT(32,20), "S7167C1");
    check_base_class_offset(lv, (S7167C7_nt*), ABISELECT(32,20), "S7167C1");
    check_base_class_offset(lv, (S7167C14_nt*), ABISELECT(104,76), "S7167C1");
    check_field_offset(lv, s7167c1f0, ABISELECT(112,80), "S7167C1.s7167c1f0");
    check_field_offset(lv, s7167c1f1, ABISELECT(120,88), "S7167C1.s7167c1f1");
    check_field_offset(lv, s7167c1f2, ABISELECT(128,92), "S7167C1.s7167c1f2");
    test_class_info(&lv, &cd_S7167C1);
    dp->~S7167C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7167C1(Test_S7167C1, "S7167C1", ABISELECT(136,96));

#else // __cplusplus

extern void _ZN7S7167C1C1Ev();
extern void _ZN7S7167C1D1Ev();
Name_Map name_map_S7167C1[] = {
  NSPAIR(_ZN7S7167C1C1Ev),
  NSPAIR(_ZN7S7167C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7167C2_nt;
extern VTBL_ENTRY _ZTI10S7167C2_nt[];
extern  VTBL_ENTRY _ZTV10S7167C2_nt[];
extern Class_Descriptor cd_S7167C9_nt;
extern VTBL_ENTRY _ZTI10S7167C9_nt[];
extern  VTBL_ENTRY _ZTV10S7167C9_nt[];
extern Class_Descriptor cd_S7167C8_nt;
extern VTBL_ENTRY _ZTI10S7167C8_nt[];
extern  VTBL_ENTRY _ZTV10S7167C8_nt[];
extern Class_Descriptor cd_S7167C7_nt;
extern VTBL_ENTRY _ZTI10S7167C7_nt[];
extern  VTBL_ENTRY _ZTV10S7167C7_nt[];
extern Class_Descriptor cd_S7167C14_nt;
extern VTBL_ENTRY _ZTI11S7167C14_nt[];
extern  VTBL_ENTRY _ZTV11S7167C14_nt[];
static Base_Class bases_S7167C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7167C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7167C9_nt,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S7167C8_nt,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S7167C7_nt,    ABISELECT(32,20), //bcp->offset
    26, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7167C14_nt,    ABISELECT(104,76), //bcp->offset
    42, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S7167C1[];
extern void _ZN7S7167C1D1Ev();
extern void _ZN7S7167C1D0Ev();
extern void _ZN10S7167C2_nt2v8Ev();
extern void _ZN10S7167C2_nt2v9Ev();
extern void _ZN10S7167C2_nt3v10Ev();
extern void _ZN10S7167C2_nt3v11Ev();
extern void _ZN10S7167C2_nt3v12Ev();
extern void _ZN10S7167C2_nt3v13Ev();
extern void _ZN10S7167C2_nt3v14Ev();
extern void _ZN10S7167C2_nt3v15Ev();
extern void _ZN10S7167C2_nt3v16Ev();
extern void _ZN10S7167C2_nt3v17Ev();
extern void _ZN10S7167C2_nt3v18Ev();
extern void _ZN10S7167C2_nt3v19Ev();
extern void _ZN10S7167C2_nt3v20Ev();
extern void _ZN10S7167C2_nt3v21Ev();
extern void _ZN10S7167C2_nt3v22Ev();
extern void _ZN7S7167C12v1Ev();
extern void _ZN7S7167C12v2Ev();
extern void _ZN7S7167C12v3Ev();
extern void _ZN7S7167C12v4Ev();
extern void _ZN7S7167C12v5Ev();
extern void _ZN7S7167C12v6Ev();
extern void _ZN7S7167C12v7Ev();
extern void ABISELECT(_ZThn32_N7S7167C1D1Ev,_ZThn20_N7S7167C1D1Ev)();
extern void ABISELECT(_ZThn32_N7S7167C1D0Ev,_ZThn20_N7S7167C1D0Ev)();
extern void _ZN10S7167C9_nt3v23Ev();
extern void _ZN10S7167C9_nt3v24Ev();
extern void _ZN10S7167C9_nt3v25Ev();
extern void _ZN10S7167C8_nt3v26Ev();
extern void _ZN10S7167C8_nt3v27Ev();
extern void _ZN10S7167C8_nt3v28Ev();
extern void _ZN10S7167C8_nt3v29Ev();
extern void _ZN10S7167C8_nt3v30Ev();
extern void _ZN10S7167C8_nt3v31Ev();
extern void _ZN10S7167C7_nt3v32Ev();
extern void _ZN10S7167C7_nt3v33Ev();
extern void _ZN10S7167C7_nt3v34Ev();
extern void ABISELECT(_ZThn104_N7S7167C1D1Ev,_ZThn76_N7S7167C1D1Ev)();
extern void ABISELECT(_ZThn104_N7S7167C1D0Ev,_ZThn76_N7S7167C1D0Ev)();
extern void _ZN11S7167C14_nt3v35Ev();
static  VTBL_ENTRY vtc_S7167C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S7167C1[0]),
  (VTBL_ENTRY)&_ZN7S7167C1D1Ev,
  (VTBL_ENTRY)&_ZN7S7167C1D0Ev,
  (VTBL_ENTRY)&_ZN10S7167C2_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S7167C2_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S7167C2_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S7167C2_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S7167C2_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S7167C2_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S7167C2_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S7167C2_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S7167C2_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S7167C2_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S7167C2_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S7167C2_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S7167C2_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S7167C2_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S7167C2_nt3v22Ev,
  (VTBL_ENTRY)&_ZN7S7167C12v1Ev,
  (VTBL_ENTRY)&_ZN7S7167C12v2Ev,
  (VTBL_ENTRY)&_ZN7S7167C12v3Ev,
  (VTBL_ENTRY)&_ZN7S7167C12v4Ev,
  (VTBL_ENTRY)&_ZN7S7167C12v5Ev,
  (VTBL_ENTRY)&_ZN7S7167C12v6Ev,
  (VTBL_ENTRY)&_ZN7S7167C12v7Ev,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7S7167C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N7S7167C1D1Ev,_ZThn20_N7S7167C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N7S7167C1D0Ev,_ZThn20_N7S7167C1D0Ev),
  (VTBL_ENTRY)&_ZN10S7167C9_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S7167C9_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S7167C9_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S7167C8_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S7167C8_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S7167C8_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S7167C8_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S7167C8_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S7167C8_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S7167C7_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S7167C7_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S7167C7_nt3v34Ev,
  ABISELECT(-104,-76),
  (VTBL_ENTRY)&(_ZTI7S7167C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N7S7167C1D1Ev,_ZThn76_N7S7167C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N7S7167C1D0Ev,_ZThn76_N7S7167C1D0Ev),
  (VTBL_ENTRY)&_ZN11S7167C14_nt3v35Ev,
};
extern VTBL_ENTRY _ZTI7S7167C1[];
extern  VTBL_ENTRY _ZTV7S7167C1[];
Class_Descriptor cd_S7167C1 = {  "S7167C1", // class name
  bases_S7167C1, 5,
  &(vtc_S7167C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,96), // object size
  NSPAIRA(_ZTI7S7167C1),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S7167C1),47, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19718C4  : S3443C8_nt , S2122C38 {
  virtual  ~S19718C4(); // _ZN8S19718C4D1Ev
  S19718C4(); // tgen
};
//SIG(-1 S19718C4) C1{ BC2{ m Fi} BC3{ m} vd}


 S19718C4 ::~S19718C4(){ note_dtor("S19718C4", this);}
S19718C4 ::S19718C4(){ note_ctor("S19718C4", this);} // tgen

static void Test_S19718C4()
{
  extern Class_Descriptor cd_S19718C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S19718C4, buf);
    S19718C4 *dp, &lv = *(dp=new (buf) S19718C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S19718C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19718C4)");
    check_base_class_offset(lv, (S3443C8_nt*), ABISELECT(8,4), "S19718C4");
    check_base_class_offset(lv, (S2122C38*), 0, "S19718C4");
    test_class_info(&lv, &cd_S19718C4);
    dp->~S19718C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19718C4(Test_S19718C4, "S19718C4", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN8S19718C4C1Ev();
extern void _ZN8S19718C4D1Ev();
Name_Map name_map_S19718C4[] = {
  NSPAIR(_ZN8S19718C4C1Ev),
  NSPAIR(_ZN8S19718C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3443C8_nt;
extern VTBL_ENTRY _ZTI10S3443C8_nt[];
extern Class_Descriptor cd_S2122C38;
extern VTBL_ENTRY _ZTI8S2122C38[];
static Base_Class bases_S19718C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3443C8_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2122C38,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19718C4[];
extern void _ZN8S19718C4D1Ev();
extern void _ZN8S19718C4D0Ev();
static  VTBL_ENTRY vtc_S19718C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S19718C4[0]),
  (VTBL_ENTRY)&_ZN8S19718C4D1Ev,
  (VTBL_ENTRY)&_ZN8S19718C4D0Ev,
};
extern VTBL_ENTRY _ZTI8S19718C4[];
extern  VTBL_ENTRY _ZTV8S19718C4[];
Class_Descriptor cd_S19718C4 = {  "S19718C4", // class name
  bases_S19718C4, 2,
  &(vtc_S19718C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI8S19718C4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S19718C4),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19718C8_nt  {
  long double s19718c8f0;
  void  mf19718c8(); // _ZN11S19718C8_nt9mf19718c8Ev
};
//SIG(-1 S19718C8_nt) C1{ m FD}


void  S19718C8_nt ::mf19718c8(){}

//skip512 S19718C8_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI11S19718C8_nt[];
VTBL_ENTRY *P__ZTI11S19718C8_nt = _ZTI11S19718C8_nt; 
Class_Descriptor cd_S19718C8_nt = {  "S19718C8_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  NSPAIRA(_ZTI11S19718C8_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19718C9_nt  {
  int s19718c9f0;
  void  mf19718c9(); // _ZN11S19718C9_nt9mf19718c9Ev
};
//SIG(-1 S19718C9_nt) C1{ m Fi}


void  S19718C9_nt ::mf19718c9(){}

//skip512 S19718C9_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI11S19718C9_nt[];
VTBL_ENTRY *P__ZTI11S19718C9_nt = _ZTI11S19718C9_nt; 
Class_Descriptor cd_S19718C9_nt = {  "S19718C9_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI11S19718C9_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19718C7  : S19718C8_nt , S19718C9_nt {
  ::S19718C9_nt s19718c7f0;
};
//SIG(-1 S19718C7) C1{ BC2{ m FD} BC3{ m Fi} FC3}



static void Test_S19718C7()
{
  extern Class_Descriptor cd_S19718C7;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(3,6)];
    init_test(&cd_S19718C7, buf);
    S19718C7 &lv = *(new (buf) S19718C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S19718C7)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19718C7)");
    check_base_class_offset(lv, (S19718C8_nt*), 0, "S19718C7");
    check_base_class_offset(lv, (S19718C9_nt*), ABISELECT(16,12), "S19718C7");
    check_field_offset(lv, s19718c7f0, ABISELECT(20,16), "S19718C7.s19718c7f0");
    test_class_info(&lv, &cd_S19718C7);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19718C7(Test_S19718C7, "S19718C7", ABISELECT(32,20));

#else // __cplusplus

extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
extern Class_Descriptor cd_S19718C9_nt;
extern VTBL_ENTRY _ZTI11S19718C9_nt[];
static Base_Class bases_S19718C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19718C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19718C9_nt,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19718C7[];
Class_Descriptor cd_S19718C7 = {  "S19718C7", // class name
  bases_S19718C7, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI8S19718C7),ABISELECT(56,32), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19718C6  : S19718C7 , S3443C8_nt , S2122C28 {
  virtual  ~S19718C6(); // _ZN8S19718C6D1Ev
  S19718C6(); // tgen
};
//SIG(-1 S19718C6) C1{ BC2{ BC3{ m FD} BC4{ m Fi} FC4} BC5{ m Fi} BC6{ m} vd}


 S19718C6 ::~S19718C6(){ note_dtor("S19718C6", this);}
S19718C6 ::S19718C6(){ note_ctor("S19718C6", this);} // tgen

static void Test_S19718C6()
{
  extern Class_Descriptor cd_S19718C6;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(4,8)];
    init_test(&cd_S19718C6, buf);
    S19718C6 *dp, &lv = *(dp=new (buf) S19718C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(S19718C6)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19718C6)");
    check_base_class_offset(lv, (S19718C8_nt*)(S19718C7*), ABISELECT(16,4), "S19718C6");
    check_base_class_offset(lv, (S19718C9_nt*)(S19718C7*), ABISELECT(32,16), "S19718C6");
    check_base_class_offset(lv, (S19718C7*), ABISELECT(16,4), "S19718C6");
    check_base_class_offset(lv, (S3443C8_nt*), ABISELECT(40,24), "S19718C6");
    check_base_class_offset(lv, (S2122C28*), 0, "S19718C6");
    test_class_info(&lv, &cd_S19718C6);
    dp->~S19718C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19718C6(Test_S19718C6, "S19718C6", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN8S19718C6C1Ev();
extern void _ZN8S19718C6D1Ev();
Name_Map name_map_S19718C6[] = {
  NSPAIR(_ZN8S19718C6C1Ev),
  NSPAIR(_ZN8S19718C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
extern Class_Descriptor cd_S19718C9_nt;
extern VTBL_ENTRY _ZTI11S19718C9_nt[];
extern Class_Descriptor cd_S19718C7;
extern VTBL_ENTRY _ZTI8S19718C7[];
extern Class_Descriptor cd_S3443C8_nt;
extern VTBL_ENTRY _ZTI10S3443C8_nt[];
extern Class_Descriptor cd_S2122C28;
extern VTBL_ENTRY _ZTI8S2122C28[];
static Base_Class bases_S19718C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19718C8_nt,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19718C9_nt,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19718C7,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3443C8_nt,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2122C28,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19718C6[];
extern void _ZN8S19718C6D1Ev();
extern void _ZN8S19718C6D0Ev();
static  VTBL_ENTRY vtc_S19718C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S19718C6[0]),
  (VTBL_ENTRY)&_ZN8S19718C6D1Ev,
  (VTBL_ENTRY)&_ZN8S19718C6D0Ev,
};
extern VTBL_ENTRY _ZTI8S19718C6[];
extern  VTBL_ENTRY _ZTV8S19718C6[];
Class_Descriptor cd_S19718C6 = {  "S19718C6", // class name
  bases_S19718C6, 5,
  &(vtc_S19718C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI8S19718C6),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S19718C6),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19718C13  : virtual S19718C9_nt , virtual S19718C8_nt {
  int s19718c13f0;
  ~S19718C13(); // tgen
  S19718C13(); // tgen
};
//SIG(-1 S19718C13) C1{ VBC2{ m Fi} VBC3{ m FD} Fi}


S19718C13 ::~S19718C13(){ note_dtor("S19718C13", this);} // tgen
S19718C13 ::S19718C13(){ note_ctor("S19718C13", this);} // tgen

static void Test_S19718C13()
{
  extern Class_Descriptor cd_S19718C13;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(3,7)];
    init_test(&cd_S19718C13, buf);
    S19718C13 *dp, &lv = *(dp=new (buf) S19718C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(S19718C13)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19718C13)");
    check_base_class_offset(lv, (S19718C9_nt*), ABISELECT(12,8), "S19718C13");
    check_base_class_offset(lv, (S19718C8_nt*), ABISELECT(16,12), "S19718C13");
    check_field_offset(lv, s19718c13f0, ABISELECT(8,4), "S19718C13.s19718c13f0");
    test_class_info(&lv, &cd_S19718C13);
    dp->~S19718C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19718C13(Test_S19718C13, "S19718C13", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN9S19718C13C1Ev();
extern void _ZN9S19718C13D1Ev();
Name_Map name_map_S19718C13[] = {
  NSPAIR(_ZN9S19718C13C1Ev),
  NSPAIR(_ZN9S19718C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19718C9_nt;
extern VTBL_ENTRY _ZTI11S19718C9_nt[];
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
static Base_Class bases_S19718C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19718C9_nt,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19718C8_nt,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19718C13[];
static  VTBL_ENTRY vtc_S19718C13[] = {
  ABISELECT(16,12),
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C13[0]),
};
extern VTBL_ENTRY _ZTV9S19718C13[];
static  VTT_ENTRY vtt_S19718C13[] = {
  {&(_ZTV9S19718C13[4]),  4,4},
};
extern VTBL_ENTRY _ZTI9S19718C13[];
extern  VTBL_ENTRY _ZTV9S19718C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C13[];
Class_Descriptor cd_S19718C13 = {  "S19718C13", // class name
  bases_S19718C13, 2,
  &(vtc_S19718C13[0]), // expected_vtbl_contents
  &(vtt_S19718C13[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI9S19718C13),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S19718C13),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19718C13),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19718C12  : S19718C13 {
  ::S19718C13 s19718c12f0;
  ~S19718C12(); // tgen
  S19718C12(); // tgen
};
//SIG(-1 S19718C12) C1{ BC2{ VBC3{ m Fi} VBC4{ m FD} Fi} FC2}


S19718C12 ::~S19718C12(){ note_dtor("S19718C12", this);} // tgen
S19718C12 ::S19718C12(){ note_ctor("S19718C12", this);} // tgen

static void Test_S19718C12()
{
  extern Class_Descriptor cd_S19718C12;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(6,13)];
    init_test(&cd_S19718C12, buf);
    S19718C12 *dp, &lv = *(dp=new (buf) S19718C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,48), "sizeof(S19718C12)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19718C12)");
    check_base_class_offset(lv, (S19718C9_nt*)(S19718C13*), ABISELECT(48,32), "S19718C12");
    check_base_class_offset(lv, (S19718C8_nt*)(S19718C13*), ABISELECT(64,36), "S19718C12");
    check_base_class_offset(lv, (S19718C13*), 0, "S19718C12");
    check_field_offset(lv, s19718c12f0, ABISELECT(16,8), "S19718C12.s19718c12f0");
    test_class_info(&lv, &cd_S19718C12);
    dp->~S19718C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19718C12(Test_S19718C12, "S19718C12", ABISELECT(80,48));

#else // __cplusplus

extern void _ZN9S19718C12C1Ev();
extern void _ZN9S19718C12D1Ev();
Name_Map name_map_S19718C12[] = {
  NSPAIR(_ZN9S19718C12C1Ev),
  NSPAIR(_ZN9S19718C12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19718C9_nt;
extern VTBL_ENTRY _ZTI11S19718C9_nt[];
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
extern Class_Descriptor cd_S19718C13;
extern VTBL_ENTRY _ZTI9S19718C13[];
extern  VTBL_ENTRY _ZTV9S19718C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C13[];
static Base_Class bases_S19718C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19718C9_nt,    ABISELECT(48,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S19718C8_nt,    ABISELECT(64,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S19718C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19718C12[];
static  VTBL_ENTRY vtc_S19718C12[] = {
  ABISELECT(64,36),
  ABISELECT(48,32),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C12[0]),
};
extern VTBL_ENTRY _ZTV9S19718C12[];
static  VTBL_ENTRY _tg__ZTV9S19718C13__9S19718C12[] = {
  ABISELECT(64,36),
  ABISELECT(48,32),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C13[0]),
};
static  VTT_ENTRY vtt_S19718C12[] = {
  {&(_ZTV9S19718C12[4]),  4,4},
  {&(_tg__ZTV9S19718C13__9S19718C12[4]),  4,4},
};
extern VTBL_ENTRY _ZTI9S19718C12[];
extern  VTBL_ENTRY _ZTV9S19718C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C12[];
Class_Descriptor cd_S19718C12 = {  "S19718C12", // class name
  bases_S19718C12, 3,
  &(vtc_S19718C12[0]), // expected_vtbl_contents
  &(vtt_S19718C12[0]), // expected_vtt_contents
  ABISELECT(80,48), // object size
  NSPAIRA(_ZTI9S19718C12),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S19718C12),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19718C12),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19718C16_nt  {
  char s19718c16f0;
  void  mf19718c16(); // _ZN12S19718C16_nt10mf19718c16Ev
};
//SIG(-1 S19718C16_nt) C1{ m Fc}


void  S19718C16_nt ::mf19718c16(){}

//skip512 S19718C16_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI12S19718C16_nt[];
VTBL_ENTRY *P__ZTI12S19718C16_nt = _ZTI12S19718C16_nt; 
Class_Descriptor cd_S19718C16_nt = {  "S19718C16_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI12S19718C16_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19718C17  : S19718C12 {
  virtual  ~S19718C17(); // _ZN9S19718C17D2Ev
  S19718C17(); // tgen
};
//SIG(-1 S19718C17) C1{ BC2{ BC3{ VBC4{ m Fi} VBC5{ m FD} Fi} FC3} vd}


 S19718C17 ::~S19718C17(){ note_dtor("S19718C17", this);}
S19718C17 ::S19718C17(){ note_ctor("S19718C17", this);} // tgen

static void Test_S19718C17()
{
  extern Class_Descriptor cd_S19718C17;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(6,13)];
    init_test(&cd_S19718C17, buf);
    S19718C17 *dp, &lv = *(dp=new (buf) S19718C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,48), "sizeof(S19718C17)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19718C17)");
    check_base_class_offset(lv, (S19718C9_nt*)(S19718C13*)(S19718C12*), ABISELECT(48,32), "S19718C17");
    check_base_class_offset(lv, (S19718C8_nt*)(S19718C13*)(S19718C12*), ABISELECT(64,36), "S19718C17");
    check_base_class_offset(lv, (S19718C13*)(S19718C12*), 0, "S19718C17");
    check_base_class_offset(lv, (S19718C12*), 0, "S19718C17");
    test_class_info(&lv, &cd_S19718C17);
    dp->~S19718C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19718C17(Test_S19718C17, "S19718C17", ABISELECT(80,48));

#else // __cplusplus

extern void _ZN9S19718C17C1Ev();
extern void _ZN9S19718C17D2Ev();
Name_Map name_map_S19718C17[] = {
  NSPAIR(_ZN9S19718C17C1Ev),
  NSPAIR(_ZN9S19718C17D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19718C9_nt;
extern VTBL_ENTRY _ZTI11S19718C9_nt[];
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
extern Class_Descriptor cd_S19718C13;
extern VTBL_ENTRY _ZTI9S19718C13[];
extern  VTBL_ENTRY _ZTV9S19718C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C13[];
extern Class_Descriptor cd_S19718C12;
extern VTBL_ENTRY _ZTI9S19718C12[];
extern  VTBL_ENTRY _ZTV9S19718C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C12[];
static Base_Class bases_S19718C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19718C9_nt,    ABISELECT(48,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S19718C8_nt,    ABISELECT(64,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S19718C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19718C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19718C17[];
extern void _ZN9S19718C17D1Ev();
extern void _ZN9S19718C17D0Ev();
static  VTBL_ENTRY vtc_S19718C17[] = {
  ABISELECT(64,36),
  ABISELECT(48,32),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C17[0]),
  (VTBL_ENTRY)&_ZN9S19718C17D1Ev,
  (VTBL_ENTRY)&_ZN9S19718C17D0Ev,
};
extern VTBL_ENTRY _ZTV9S19718C17[];
static  VTBL_ENTRY _tg__ZTV9S19718C12__9S19718C17[] = {
  ABISELECT(64,36),
  ABISELECT(48,32),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C12[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19718C139S19718C12__9S19718C17[] = {
  ABISELECT(64,36),
  ABISELECT(48,32),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C13[0]),
};
static  VTT_ENTRY vtt_S19718C17[] = {
  {&(_ZTV9S19718C17[4]),  4,6},
  {&(_tg__ZTV9S19718C12__9S19718C17[4]),  4,4},
  {&(_tg__ZTV9S19718C139S19718C12__9S19718C17[4]),  4,4},
};
extern VTBL_ENTRY _ZTI9S19718C17[];
extern  VTBL_ENTRY _ZTV9S19718C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C17[];
Class_Descriptor cd_S19718C17 = {  "S19718C17", // class name
  bases_S19718C17, 4,
  &(vtc_S19718C17[0]), // expected_vtbl_contents
  &(vtt_S19718C17[0]), // expected_vtt_contents
  ABISELECT(80,48), // object size
  NSPAIRA(_ZTI9S19718C17),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S19718C17),6, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19718C17),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19718C18  {
  int s19718c18f0;
  void  mf19718c18(); // _ZN9S19718C1810mf19718c18Ev
};
//SIG(-1 S19718C18) C1{ m Fi}


void  S19718C18 ::mf19718c18(){}

static void Test_S19718C18()
{
  {
    init_simple_test("S19718C18");
    S19718C18 lv;
    check2(sizeof(lv), 4, "sizeof(S19718C18)");
    check2(__alignof__(lv), 4, "__alignof__(S19718C18)");
    check_field_offset(lv, s19718c18f0, 0, "S19718C18.s19718c18f0");
  }
}
static Arrange_To_Call_Me vS19718C18(Test_S19718C18, "S19718C18", 4);

#else // __cplusplus

extern VTBL_ENTRY _ZTI9S19718C18[];
VTBL_ENTRY *P__ZTI9S19718C18 = _ZTI9S19718C18; 
Class_Descriptor cd_S19718C18 = {  "S19718C18", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI9S19718C18),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19718C15  : S19718C8_nt , virtual S19718C16_nt , virtual S19718C17 , S19718C7 , S19718C18 {
  int s19718c15f0;
  virtual  ~S19718C15(); // _ZN9S19718C15D2Ev
  S19718C15(); // tgen
};
//SIG(-1 S19718C15) C1{ BC2{ m FD} VBC3{ m Fc} VBC4{ BC5{ BC6{ VBC7{ m Fi} VBC2 Fi} FC6} vd} BC8{ BC2 BC7 FC7} BC9{ m Fi} vd Fi}


 S19718C15 ::~S19718C15(){ note_dtor("S19718C15", this);}
S19718C15 ::S19718C15(){ note_ctor("S19718C15", this);} // tgen

static void Test_S19718C15()
{
  extern Class_Descriptor cd_S19718C15;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(11,25)];
    init_test(&cd_S19718C15, buf);
    S19718C15 *dp, &lv = *(dp=new (buf) S19718C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(160,96), "sizeof(S19718C15)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19718C15)");
    /*is_ambiguous_... S19718C15::S19718C8_nt */ AMB_check_base_class_offset(lv, (S19718C8_nt*), ABISELECT(16,4), "S19718C15");
    check_base_class_offset(lv, (S19718C16_nt*), ABISELECT(64,44), "S19718C15");
    check_base_class_offset(lv, (S19718C9_nt*)(S19718C13*)(S19718C12*)(S19718C17*), ABISELECT(128,80), "S19718C15");
    check_base_class_offset(lv, (S19718C8_nt*)(S19718C13*)(S19718C12*)(S19718C17*), ABISELECT(144,84), "S19718C15");
    check_base_class_offset(lv, (S19718C13*)(S19718C12*)(S19718C17*), ABISELECT(80,48), "S19718C15");
    check_base_class_offset(lv, (S19718C12*)(S19718C17*), ABISELECT(80,48), "S19718C15");
    check_base_class_offset(lv, (S19718C17*), ABISELECT(80,48), "S19718C15");
    check_base_class_offset(lv, (S19718C8_nt*)(S19718C7*), ABISELECT(32,16), "S19718C15");
    check_base_class_offset(lv, (S19718C9_nt*)(S19718C7*), ABISELECT(48,28), "S19718C15");
    check_base_class_offset(lv, (S19718C7*), ABISELECT(32,16), "S19718C15");
    check_base_class_offset(lv, (S19718C18*), ABISELECT(56,36), "S19718C15");
    check_field_offset(lv, s19718c15f0, ABISELECT(60,40), "S19718C15.s19718c15f0");
    test_class_info(&lv, &cd_S19718C15);
    dp->~S19718C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19718C15(Test_S19718C15, "S19718C15", ABISELECT(160,96));

#else // __cplusplus

extern void _ZN9S19718C15C1Ev();
extern void _ZN9S19718C15D2Ev();
Name_Map name_map_S19718C15[] = {
  NSPAIR(_ZN9S19718C15C1Ev),
  NSPAIR(_ZN9S19718C15D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
extern Class_Descriptor cd_S19718C16_nt;
extern VTBL_ENTRY _ZTI12S19718C16_nt[];
extern Class_Descriptor cd_S19718C9_nt;
extern VTBL_ENTRY _ZTI11S19718C9_nt[];
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
extern Class_Descriptor cd_S19718C13;
extern VTBL_ENTRY _ZTI9S19718C13[];
extern  VTBL_ENTRY _ZTV9S19718C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C13[];
extern Class_Descriptor cd_S19718C12;
extern VTBL_ENTRY _ZTI9S19718C12[];
extern  VTBL_ENTRY _ZTV9S19718C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C12[];
extern Class_Descriptor cd_S19718C17;
extern VTBL_ENTRY _ZTI9S19718C17[];
extern  VTBL_ENTRY _ZTV9S19718C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C17[];
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
extern Class_Descriptor cd_S19718C9_nt;
extern VTBL_ENTRY _ZTI11S19718C9_nt[];
extern Class_Descriptor cd_S19718C7;
extern VTBL_ENTRY _ZTI8S19718C7[];
extern Class_Descriptor cd_S19718C18;
extern VTBL_ENTRY _ZTI9S19718C18[];
static Base_Class bases_S19718C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19718C8_nt,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19718C16_nt,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19718C9_nt,    ABISELECT(128,80), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S19718C8_nt,    ABISELECT(144,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S19718C13,    ABISELECT(80,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19718C12,    ABISELECT(80,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19718C17,    ABISELECT(80,48), //bcp->offset
    8, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19718C8_nt,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19718C9_nt,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19718C7,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19718C18,    ABISELECT(56,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19718C15[];
extern void _ZN9S19718C15D1Ev();
extern void _ZN9S19718C15D0Ev();
extern void ABISELECT(_ZTv0_n40_N9S19718C15D1Ev,_ZTv0_n20_N9S19718C15D1Ev)();
extern void ABISELECT(_ZThn80_N9S19718C15D1Ev,_ZThn48_N9S19718C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19718C15D0Ev,_ZTv0_n20_N9S19718C15D0Ev)();
extern void ABISELECT(_ZThn80_N9S19718C15D0Ev,_ZThn48_N9S19718C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19718C15[] = {
  ABISELECT(144,84),
  ABISELECT(128,80),
  ABISELECT(80,48),
  ABISELECT(64,44),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C15[0]),
  (VTBL_ENTRY)&_ZN9S19718C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19718C15D0Ev,
  ABISELECT(-80,-48),
  ABISELECT(64,36),
  ABISELECT(48,32),
  ABISELECT(-80,-48),
  (VTBL_ENTRY)&(_ZTI9S19718C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19718C15D1Ev,_ZTv0_n20_N9S19718C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19718C15D0Ev,_ZTv0_n20_N9S19718C15D0Ev),
};
extern VTBL_ENTRY _ZTV9S19718C15[];
extern void _ZN9S19718C17D1Ev();
extern void _ZN9S19718C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19718C17__9S19718C15[] = {
  ABISELECT(64,36),
  ABISELECT(48,32),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C17[0]),
  (VTBL_ENTRY)&_ZN9S19718C17D1Ev,
  (VTBL_ENTRY)&_ZN9S19718C17D0Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19718C129S19718C17__9S19718C15[] = {
  ABISELECT(64,36),
  ABISELECT(48,32),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C12[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19718C139S19718C129S19718C17__9S19718C15[] = {
  ABISELECT(64,36),
  ABISELECT(48,32),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C13[0]),
};
static  VTT_ENTRY vtt_S19718C15[] = {
  {&(_ZTV9S19718C15[6]),  6,15},
  {&(_ZTV9S19718C15[13]),  13,15},
  {&(_tg__ZTV9S19718C17__9S19718C15[4]),  4,6},
  {&(_tg__ZTV9S19718C129S19718C17__9S19718C15[4]),  4,4},
  {&(_tg__ZTV9S19718C139S19718C129S19718C17__9S19718C15[4]),  4,4},
};
extern VTBL_ENTRY _ZTI9S19718C15[];
extern  VTBL_ENTRY _ZTV9S19718C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C15[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19718C15D0Ev,_ZTv0_n20_N9S19718C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S19718C15D0Ev,_ZThn48_N9S19718C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19718C15D1Ev,_ZTv0_n20_N9S19718C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S19718C15D1Ev,_ZThn48_N9S19718C15D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19718C15 = {  "S19718C15", // class name
  bases_S19718C15, 11,
  &(vtc_S19718C15[0]), // expected_vtbl_contents
  &(vtt_S19718C15[0]), // expected_vtt_contents
  ABISELECT(160,96), // object size
  NSPAIRA(_ZTI9S19718C15),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S19718C15),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19718C15),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19718C14  : virtual S19718C15 , S19718C9_nt {
  virtual  ~S19718C14(); // _ZN9S19718C14D2Ev
  S19718C14(); // tgen
};
//SIG(-1 S19718C14) C1{ VBC2{ BC3{ m FD} VBC4{ m Fc} VBC5{ BC6{ BC7{ VBC8{ m Fi} VBC3 Fi} FC7} vd} BC9{ BC3 BC8 FC8} BC10{ m Fi} vd Fi} BC8 vd}


 S19718C14 ::~S19718C14(){ note_dtor("S19718C14", this);}
S19718C14 ::S19718C14(){ note_ctor("S19718C14", this);} // tgen

static void Test_S19718C14()
{
  extern Class_Descriptor cd_S19718C14;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(12,27)];
    init_test(&cd_S19718C14, buf);
    S19718C14 *dp, &lv = *(dp=new (buf) S19718C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(176,104), "sizeof(S19718C14)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19718C14)");
    /*is_ambiguous_... S19718C15::S19718C8_nt */ AMB_check_base_class_offset(lv, (S19718C8_nt*)(S19718C15*), ABISELECT(32,12), "S19718C14");
    check_base_class_offset(lv, (S19718C16_nt*)(S19718C15*), ABISELECT(80,52), "S19718C14");
    check_base_class_offset(lv, (S19718C9_nt*)(S19718C13*)(S19718C12*)(S19718C17*), ABISELECT(144,88), "S19718C14");
    check_base_class_offset(lv, (S19718C8_nt*)(S19718C13*)(S19718C12*)(S19718C17*), ABISELECT(160,92), "S19718C14");
    check_base_class_offset(lv, (S19718C13*)(S19718C12*)(S19718C17*), ABISELECT(96,56), "S19718C14");
    check_base_class_offset(lv, (S19718C12*)(S19718C17*), ABISELECT(96,56), "S19718C14");
    check_base_class_offset(lv, (S19718C17*)(S19718C15*), ABISELECT(96,56), "S19718C14");
    check_base_class_offset(lv, (S19718C8_nt*)(S19718C7*)(S19718C15*), ABISELECT(48,24), "S19718C14");
    check_base_class_offset(lv, (S19718C9_nt*)(S19718C7*)(S19718C15*), ABISELECT(64,36), "S19718C14");
    check_base_class_offset(lv, (S19718C7*)(S19718C15*), ABISELECT(48,24), "S19718C14");
    check_base_class_offset(lv, (S19718C18*)(S19718C15*), ABISELECT(72,44), "S19718C14");
    check_base_class_offset(lv, (S19718C15*), ABISELECT(16,8), "S19718C14");
    /*is_ambiguous_... S19718C14::S19718C9_nt */ AMB_check_base_class_offset(lv, (S19718C9_nt*), ABISELECT(8,4), "S19718C14");
    test_class_info(&lv, &cd_S19718C14);
    dp->~S19718C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19718C14(Test_S19718C14, "S19718C14", ABISELECT(176,104));

#else // __cplusplus

extern void _ZN9S19718C14C1Ev();
extern void _ZN9S19718C14D2Ev();
Name_Map name_map_S19718C14[] = {
  NSPAIR(_ZN9S19718C14C1Ev),
  NSPAIR(_ZN9S19718C14D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
extern Class_Descriptor cd_S19718C16_nt;
extern VTBL_ENTRY _ZTI12S19718C16_nt[];
extern Class_Descriptor cd_S19718C9_nt;
extern VTBL_ENTRY _ZTI11S19718C9_nt[];
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
extern Class_Descriptor cd_S19718C13;
extern VTBL_ENTRY _ZTI9S19718C13[];
extern  VTBL_ENTRY _ZTV9S19718C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C13[];
extern Class_Descriptor cd_S19718C12;
extern VTBL_ENTRY _ZTI9S19718C12[];
extern  VTBL_ENTRY _ZTV9S19718C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C12[];
extern Class_Descriptor cd_S19718C17;
extern VTBL_ENTRY _ZTI9S19718C17[];
extern  VTBL_ENTRY _ZTV9S19718C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C17[];
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
extern Class_Descriptor cd_S19718C9_nt;
extern VTBL_ENTRY _ZTI11S19718C9_nt[];
extern Class_Descriptor cd_S19718C7;
extern VTBL_ENTRY _ZTI8S19718C7[];
extern Class_Descriptor cd_S19718C18;
extern VTBL_ENTRY _ZTI9S19718C18[];
extern Class_Descriptor cd_S19718C15;
extern VTBL_ENTRY _ZTI9S19718C15[];
extern  VTBL_ENTRY _ZTV9S19718C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C15[];
extern Class_Descriptor cd_S19718C9_nt;
extern VTBL_ENTRY _ZTI11S19718C9_nt[];
static Base_Class bases_S19718C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19718C8_nt,    ABISELECT(32,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19718C16_nt,    ABISELECT(80,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S19718C9_nt,    ABISELECT(144,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S19718C8_nt,    ABISELECT(160,92), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S19718C13,    ABISELECT(96,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19718C12,    ABISELECT(96,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19718C17,    ABISELECT(96,56), //bcp->offset
    18, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S19718C8_nt,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19718C9_nt,    ABISELECT(64,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19718C7,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19718C18,    ABISELECT(72,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19718C15,    ABISELECT(16,8), //bcp->offset
    9, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19718C9_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19718C14[];
extern void _ZN9S19718C14D1Ev();
extern void _ZN9S19718C14D0Ev();
extern void ABISELECT(_ZTv0_n56_N9S19718C14D1Ev,_ZTv0_n28_N9S19718C14D1Ev)();
extern void ABISELECT(_ZThn16_N9S19718C14D1Ev,_ZThn8_N9S19718C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S19718C14D0Ev,_ZTv0_n28_N9S19718C14D0Ev)();
extern void ABISELECT(_ZThn16_N9S19718C14D0Ev,_ZThn8_N9S19718C14D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19718C14D1Ev,_ZTv0_n20_N9S19718C14D1Ev)();
extern void ABISELECT(_ZThn96_N9S19718C14D1Ev,_ZThn56_N9S19718C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19718C14D0Ev,_ZTv0_n20_N9S19718C14D0Ev)();
extern void ABISELECT(_ZThn96_N9S19718C14D0Ev,_ZThn56_N9S19718C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19718C14[] = {
  ABISELECT(160,92),
  ABISELECT(144,88),
  ABISELECT(96,56),
  ABISELECT(80,52),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C14[0]),
  (VTBL_ENTRY)&_ZN9S19718C14D1Ev,
  (VTBL_ENTRY)&_ZN9S19718C14D0Ev,
  ABISELECT(-16,-8),
  ABISELECT(144,84),
  ABISELECT(128,80),
  ABISELECT(80,48),
  ABISELECT(64,44),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S19718C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19718C14D1Ev,_ZTv0_n28_N9S19718C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19718C14D0Ev,_ZTv0_n28_N9S19718C14D0Ev),
  ABISELECT(-96,-56),
  ABISELECT(64,36),
  ABISELECT(48,32),
  ABISELECT(-96,-56),
  (VTBL_ENTRY)&(_ZTI9S19718C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19718C14D1Ev,_ZTv0_n20_N9S19718C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19718C14D0Ev,_ZTv0_n20_N9S19718C14D0Ev),
};
extern VTBL_ENTRY _ZTV9S19718C14[];
extern void _ZN9S19718C15D1Ev();
extern void _ZN9S19718C15D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19718C15__9S19718C14[] = {
  ABISELECT(144,84),
  ABISELECT(128,80),
  ABISELECT(80,48),
  ABISELECT(64,44),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C15[0]),
  (VTBL_ENTRY)&_ZN9S19718C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19718C15D0Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19718C15D1Ev,_ZTv0_n20_N9S19718C15D1Ev)();
extern void ABISELECT(_ZThn80_N9S19718C15D1Ev,_ZThn48_N9S19718C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19718C15D0Ev,_ZTv0_n20_N9S19718C15D0Ev)();
extern void ABISELECT(_ZThn80_N9S19718C15D0Ev,_ZThn48_N9S19718C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19718C17__9S19718C15__9S19718C14[] = {
  ABISELECT(-80,-48),
  ABISELECT(64,36),
  ABISELECT(48,32),
  ABISELECT(-80,-48),
  (VTBL_ENTRY)&(_ZTI9S19718C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19718C15D1Ev,_ZTv0_n20_N9S19718C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19718C15D0Ev,_ZTv0_n20_N9S19718C15D0Ev),
};
extern void _ZN9S19718C17D1Ev();
extern void _ZN9S19718C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19718C17__9S19718C14[] = {
  ABISELECT(64,36),
  ABISELECT(48,32),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C17[0]),
  (VTBL_ENTRY)&_ZN9S19718C17D1Ev,
  (VTBL_ENTRY)&_ZN9S19718C17D0Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19718C129S19718C17__9S19718C14[] = {
  ABISELECT(64,36),
  ABISELECT(48,32),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C12[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19718C139S19718C129S19718C17__9S19718C14[] = {
  ABISELECT(64,36),
  ABISELECT(48,32),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C13[0]),
};
static  VTT_ENTRY vtt_S19718C14[] = {
  {&(_ZTV9S19718C14[7]),  7,25},
  {&(_ZTV9S19718C14[16]),  16,25},
  {&(_ZTV9S19718C14[23]),  23,25},
  {&(_tg__ZTV9S19718C15__9S19718C14[6]),  6,8},
  {&(_tg__ZTV9S19718C17__9S19718C15__9S19718C14[5]),  5,7},
  {&(_tg__ZTV9S19718C17__9S19718C14[4]),  4,6},
  {&(_tg__ZTV9S19718C129S19718C17__9S19718C14[4]),  4,4},
  {&(_tg__ZTV9S19718C139S19718C129S19718C17__9S19718C14[4]),  4,4},
};
extern VTBL_ENTRY _ZTI9S19718C14[];
extern  VTBL_ENTRY _ZTV9S19718C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C14[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19718C15D0Ev,_ZTv0_n20_N9S19718C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S19718C15D0Ev,_ZThn48_N9S19718C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19718C15D1Ev,_ZTv0_n20_N9S19718C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S19718C15D1Ev,_ZThn48_N9S19718C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19718C14D0Ev,_ZTv0_n20_N9S19718C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N9S19718C14D0Ev,_ZThn56_N9S19718C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19718C14D1Ev,_ZTv0_n20_N9S19718C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N9S19718C14D1Ev,_ZThn56_N9S19718C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19718C14D0Ev,_ZTv0_n28_N9S19718C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19718C14D0Ev,_ZThn8_N9S19718C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19718C14D1Ev,_ZTv0_n28_N9S19718C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19718C14D1Ev,_ZThn8_N9S19718C14D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19718C14 = {  "S19718C14", // class name
  bases_S19718C14, 13,
  &(vtc_S19718C14[0]), // expected_vtbl_contents
  &(vtt_S19718C14[0]), // expected_vtt_contents
  ABISELECT(176,104), // object size
  NSPAIRA(_ZTI9S19718C14),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S19718C14),25, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19718C14),8, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19718C19  : virtual S19718C9_nt , S19718C8_nt {
  virtual  ~S19718C19(); // _ZN9S19718C19D2Ev
  S19718C19(); // tgen
};
//SIG(-1 S19718C19) C1{ VBC2{ m Fi} BC3{ m FD} vd}


 S19718C19 ::~S19718C19(){ note_dtor("S19718C19", this);}
S19718C19 ::S19718C19(){ note_ctor("S19718C19", this);} // tgen

static void Test_S19718C19()
{
  extern Class_Descriptor cd_S19718C19;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(4,6)];
    init_test(&cd_S19718C19, buf);
    S19718C19 *dp, &lv = *(dp=new (buf) S19718C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,20), "sizeof(S19718C19)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19718C19)");
    check_base_class_offset(lv, (S19718C9_nt*), ABISELECT(32,16), "S19718C19");
    check_base_class_offset(lv, (S19718C8_nt*), ABISELECT(16,4), "S19718C19");
    test_class_info(&lv, &cd_S19718C19);
    dp->~S19718C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19718C19(Test_S19718C19, "S19718C19", ABISELECT(48,20));

#else // __cplusplus

extern void _ZN9S19718C19C1Ev();
extern void _ZN9S19718C19D2Ev();
Name_Map name_map_S19718C19[] = {
  NSPAIR(_ZN9S19718C19C1Ev),
  NSPAIR(_ZN9S19718C19D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19718C9_nt;
extern VTBL_ENTRY _ZTI11S19718C9_nt[];
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
static Base_Class bases_S19718C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19718C9_nt,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19718C8_nt,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19718C19[];
extern void _ZN9S19718C19D1Ev();
extern void _ZN9S19718C19D0Ev();
static  VTBL_ENTRY vtc_S19718C19[] = {
  ABISELECT(32,16),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C19[0]),
  (VTBL_ENTRY)&_ZN9S19718C19D1Ev,
  (VTBL_ENTRY)&_ZN9S19718C19D0Ev,
};
extern VTBL_ENTRY _ZTV9S19718C19[];
static  VTT_ENTRY vtt_S19718C19[] = {
  {&(_ZTV9S19718C19[3]),  3,5},
};
extern VTBL_ENTRY _ZTI9S19718C19[];
extern  VTBL_ENTRY _ZTV9S19718C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C19[];
Class_Descriptor cd_S19718C19 = {  "S19718C19", // class name
  bases_S19718C19, 2,
  &(vtc_S19718C19[0]), // expected_vtbl_contents
  &(vtt_S19718C19[0]), // expected_vtt_contents
  ABISELECT(48,20), // object size
  NSPAIRA(_ZTI9S19718C19),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S19718C19),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19718C19),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19718C20  {
  ::S19718C13 s19718c20f0;
  void  mf19718c20(); // _ZN9S19718C2010mf19718c20Ev
};
//SIG(-1 S19718C20) C1{ m FC2{ VBC3{ m Fi} VBC4{ m FD} Fi}}


void  S19718C20 ::mf19718c20(){}

static void Test_S19718C20()
{
  {
    init_simple_test("S19718C20");
    S19718C20 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(S19718C20)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19718C20)");
    check_field_offset(lv, s19718c20f0, 0, "S19718C20.s19718c20f0");
  }
}
static Arrange_To_Call_Me vS19718C20(Test_S19718C20, "S19718C20", ABISELECT(32,24));

#else // __cplusplus

extern VTBL_ENTRY _ZTI9S19718C20[];
VTBL_ENTRY *P__ZTI9S19718C20 = _ZTI9S19718C20; 
Class_Descriptor cd_S19718C20 = {  "S19718C20", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI9S19718C20),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19718C11  : S19718C12 , virtual S3443C8_nt , S19718C14 , S19718C19 , S19718C20 {
  int s19718c11f0[2];
  ~S19718C11(); // tgen
  S19718C11(); // tgen
};
//SIG(-1 S19718C11) C1{ BC2{ BC3{ VBC4{ m Fi} VBC5{ m FD} Fi} FC3} VBC6{ m Fi} BC7{ VBC8{ BC5 VBC9{ m Fc} VBC10{ BC2 vd} BC11{ BC5 BC4 FC4} BC12{ m Fi} vd Fi} BC4 vd} BC13{ VBC4 BC5 vd} BC14{ m FC3} Fi[2]}


S19718C11 ::~S19718C11(){ note_dtor("S19718C11", this);} // tgen
S19718C11 ::S19718C11(){ note_ctor("S19718C11", this);} // tgen

static void Test_S19718C11()
{
  extern Class_Descriptor cd_S19718C11;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(20,48)];
    init_test(&cd_S19718C11, buf);
    S19718C11 *dp, &lv = *(dp=new (buf) S19718C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,188), "sizeof(S19718C11)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19718C11)");
    /*is_ambiguous_... S19718C11::S19718C12 */ AMB_check_base_class_offset(lv, (S19718C9_nt*)(S19718C13*)(S19718C12*), ABISELECT(136,88), "S19718C11");
    check_base_class_offset(lv, (S19718C9_nt*)(S19718C13*)(S19718C12*)(S19718C17*), ABISELECT(136,88), "S19718C11");
    check_base_class_offset(lv, (S19718C9_nt*)(S19718C19*), ABISELECT(136,88), "S19718C11");
    /*is_ambiguous_... S19718C11::S19718C12 */ AMB_check_base_class_offset(lv, (S19718C8_nt*)(S19718C13*)(S19718C12*), ABISELECT(144,92), "S19718C11");
    check_base_class_offset(lv, (S19718C8_nt*)(S19718C13*)(S19718C12*)(S19718C17*), ABISELECT(144,92), "S19718C11");
    /*is_ambiguous_... S19718C11::S19718C12 */ AMB_check_base_class_offset(lv, (S19718C13*)(S19718C12*), 0, "S19718C11");
    /*is_ambiguous_... S19718C11::S19718C12 */ AMB_check_base_class_offset(lv, (S19718C12*), 0, "S19718C11");
    check_base_class_offset(lv, (S3443C8_nt*), ABISELECT(160,104), "S19718C11");
    /*is_ambiguous_... S19718C15::S19718C8_nt */ AMB_check_base_class_offset(lv, (S19718C8_nt*)(S19718C15*), ABISELECT(192,112), "S19718C11");
    check_base_class_offset(lv, (S19718C16_nt*)(S19718C15*), ABISELECT(240,152), "S19718C11");
    check_base_class_offset(lv, (S19718C13*)(S19718C12*)(S19718C17*), ABISELECT(256,156), "S19718C11");
    check_base_class_offset(lv, (S19718C12*)(S19718C17*), ABISELECT(256,156), "S19718C11");
    check_base_class_offset(lv, (S19718C17*)(S19718C15*), ABISELECT(256,156), "S19718C11");
    check_base_class_offset(lv, (S19718C8_nt*)(S19718C7*)(S19718C15*), ABISELECT(208,124), "S19718C11");
    check_base_class_offset(lv, (S19718C9_nt*)(S19718C7*)(S19718C15*), ABISELECT(224,136), "S19718C11");
    check_base_class_offset(lv, (S19718C7*)(S19718C15*), ABISELECT(208,124), "S19718C11");
    check_base_class_offset(lv, (S19718C18*)(S19718C15*), ABISELECT(232,144), "S19718C11");
    check_base_class_offset(lv, (S19718C15*)(S19718C14*), ABISELECT(176,108), "S19718C11");
    /*is_ambiguous_... S19718C14::S19718C9_nt */ AMB_check_base_class_offset(lv, (S19718C9_nt*)(S19718C14*), ABISELECT(56,36), "S19718C11");
    check_base_class_offset(lv, (S19718C14*), ABISELECT(48,32), "S19718C11");
    check_base_class_offset(lv, (S19718C8_nt*)(S19718C19*), ABISELECT(80,44), "S19718C11");
    check_base_class_offset(lv, (S19718C19*), ABISELECT(64,40), "S19718C11");
    check_base_class_offset(lv, (S19718C20*), ABISELECT(96,56), "S19718C11");
    check_field_offset(lv, s19718c11f0, ABISELECT(128,80), "S19718C11.s19718c11f0");
    test_class_info(&lv, &cd_S19718C11);
    dp->~S19718C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19718C11(Test_S19718C11, "S19718C11", ABISELECT(304,188));

#else // __cplusplus

extern void _ZN9S19718C11C1Ev();
extern void _ZN9S19718C11D1Ev();
Name_Map name_map_S19718C11[] = {
  NSPAIR(_ZN9S19718C11C1Ev),
  NSPAIR(_ZN9S19718C11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19718C9_nt;
extern VTBL_ENTRY _ZTI11S19718C9_nt[];
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
extern Class_Descriptor cd_S19718C13;
extern VTBL_ENTRY _ZTI9S19718C13[];
extern  VTBL_ENTRY _ZTV9S19718C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C13[];
extern Class_Descriptor cd_S19718C12;
extern VTBL_ENTRY _ZTI9S19718C12[];
extern  VTBL_ENTRY _ZTV9S19718C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C12[];
extern Class_Descriptor cd_S3443C8_nt;
extern VTBL_ENTRY _ZTI10S3443C8_nt[];
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
extern Class_Descriptor cd_S19718C16_nt;
extern VTBL_ENTRY _ZTI12S19718C16_nt[];
extern Class_Descriptor cd_S19718C13;
extern VTBL_ENTRY _ZTI9S19718C13[];
extern  VTBL_ENTRY _ZTV9S19718C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C13[];
extern Class_Descriptor cd_S19718C12;
extern VTBL_ENTRY _ZTI9S19718C12[];
extern  VTBL_ENTRY _ZTV9S19718C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C12[];
extern Class_Descriptor cd_S19718C17;
extern VTBL_ENTRY _ZTI9S19718C17[];
extern  VTBL_ENTRY _ZTV9S19718C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C17[];
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
extern Class_Descriptor cd_S19718C9_nt;
extern VTBL_ENTRY _ZTI11S19718C9_nt[];
extern Class_Descriptor cd_S19718C7;
extern VTBL_ENTRY _ZTI8S19718C7[];
extern Class_Descriptor cd_S19718C18;
extern VTBL_ENTRY _ZTI9S19718C18[];
extern Class_Descriptor cd_S19718C15;
extern VTBL_ENTRY _ZTI9S19718C15[];
extern  VTBL_ENTRY _ZTV9S19718C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C15[];
extern Class_Descriptor cd_S19718C9_nt;
extern VTBL_ENTRY _ZTI11S19718C9_nt[];
extern Class_Descriptor cd_S19718C14;
extern VTBL_ENTRY _ZTI9S19718C14[];
extern  VTBL_ENTRY _ZTV9S19718C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C14[];
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
extern Class_Descriptor cd_S19718C19;
extern VTBL_ENTRY _ZTI9S19718C19[];
extern  VTBL_ENTRY _ZTV9S19718C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C19[];
extern Class_Descriptor cd_S19718C20;
extern VTBL_ENTRY _ZTI9S19718C20[];
static Base_Class bases_S19718C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19718C9_nt,    ABISELECT(136,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S19718C8_nt,    ABISELECT(144,92), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S19718C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19718C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3443C8_nt,    ABISELECT(160,104), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19718C8_nt,    ABISELECT(192,112), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19718C16_nt,    ABISELECT(240,152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S19718C13,    ABISELECT(256,156), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19718C12,    ABISELECT(256,156), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19718C17,    ABISELECT(256,156), //bcp->offset
    33, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S19718C8_nt,    ABISELECT(208,124), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19718C9_nt,    ABISELECT(224,136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19718C7,    ABISELECT(208,124), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19718C18,    ABISELECT(232,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19718C15,    ABISELECT(176,108), //bcp->offset
    24, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S19718C9_nt,    ABISELECT(56,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19718C14,    ABISELECT(48,32), //bcp->offset
    10, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19718C8_nt,    ABISELECT(80,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S19718C19,    ABISELECT(64,40), //bcp->offset
    19, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19718C20,    ABISELECT(96,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19718C11[];
extern void _ZN9S19718C11D1Ev();
extern void _ZN9S19718C11D0Ev();
extern void ABISELECT(_ZThn48_N9S19718C11D1Ev,_ZThn32_N9S19718C11D1Ev)();
extern void ABISELECT(_ZThn48_N9S19718C11D0Ev,_ZThn32_N9S19718C11D0Ev)();
extern void ABISELECT(_ZThn64_N9S19718C11D1Ev,_ZThn40_N9S19718C11D1Ev)();
extern void ABISELECT(_ZThn64_N9S19718C11D0Ev,_ZThn40_N9S19718C11D0Ev)();
extern void ABISELECT(_ZTv0_n56_N9S19718C11D1Ev,_ZTv0_n28_N9S19718C11D1Ev)();
extern void ABISELECT(_ZThn176_N9S19718C11D1Ev,_ZThn108_N9S19718C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S19718C11D0Ev,_ZTv0_n28_N9S19718C11D0Ev)();
extern void ABISELECT(_ZThn176_N9S19718C11D0Ev,_ZThn108_N9S19718C11D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19718C11D1Ev,_ZTv0_n20_N9S19718C11D1Ev)();
extern void ABISELECT(_ZThn256_N9S19718C11D1Ev,_ZThn156_N9S19718C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19718C11D0Ev,_ZTv0_n20_N9S19718C11D0Ev)();
extern void ABISELECT(_ZThn256_N9S19718C11D0Ev,_ZThn156_N9S19718C11D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19718C11[] = {
  ABISELECT(256,156),
  ABISELECT(240,152),
  ABISELECT(176,108),
  ABISELECT(160,104),
  ABISELECT(144,92),
  ABISELECT(136,88),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C11[0]),
  (VTBL_ENTRY)&_ZN9S19718C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19718C11D0Ev,
  ABISELECT(96,60),
  ABISELECT(88,56),
  ABISELECT(208,124),
  ABISELECT(192,120),
  ABISELECT(128,76),
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S19718C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S19718C11D1Ev,_ZThn32_N9S19718C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S19718C11D0Ev,_ZThn32_N9S19718C11D0Ev),
  ABISELECT(72,48),
  ABISELECT(-64,-40),
  (VTBL_ENTRY)&(_ZTI9S19718C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S19718C11D1Ev,_ZThn40_N9S19718C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S19718C11D0Ev,_ZThn40_N9S19718C11D0Ev),
  ABISELECT(-176,-108),
  ABISELECT(-32,-16),
  ABISELECT(-40,-20),
  ABISELECT(80,48),
  ABISELECT(64,44),
  ABISELECT(-176,-108),
  (VTBL_ENTRY)&(_ZTI9S19718C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19718C11D1Ev,_ZTv0_n28_N9S19718C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19718C11D0Ev,_ZTv0_n28_N9S19718C11D0Ev),
  ABISELECT(-256,-156),
  ABISELECT(-112,-64),
  ABISELECT(-120,-68),
  ABISELECT(-256,-156),
  (VTBL_ENTRY)&(_ZTI9S19718C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19718C11D1Ev,_ZTv0_n20_N9S19718C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19718C11D0Ev,_ZTv0_n20_N9S19718C11D0Ev),
};
extern VTBL_ENTRY _ZTV9S19718C11[];
static  VTBL_ENTRY _tg__ZTV9S19718C12__9S19718C11[] = {
  ABISELECT(144,92),
  ABISELECT(136,88),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C12[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19718C139S19718C12__9S19718C11[] = {
  ABISELECT(144,92),
  ABISELECT(136,88),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C13[0]),
};
extern void _ZN9S19718C14D1Ev();
extern void _ZN9S19718C14D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19718C14__9S19718C11[] = {
  ABISELECT(96,60),
  ABISELECT(88,56),
  ABISELECT(208,124),
  ABISELECT(192,120),
  ABISELECT(128,76),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C14[0]),
  (VTBL_ENTRY)&_ZN9S19718C14D1Ev,
  (VTBL_ENTRY)&_ZN9S19718C14D0Ev,
};
extern void ABISELECT(_ZTv0_n56_N9S19718C14D1Ev,_ZTv0_n28_N9S19718C14D1Ev)();
extern void ABISELECT(_ZThn128_N9S19718C14D1Ev,_ZThn76_N9S19718C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S19718C14D0Ev,_ZTv0_n28_N9S19718C14D0Ev)();
extern void ABISELECT(_ZThn128_N9S19718C14D0Ev,_ZThn76_N9S19718C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19718C15__9S19718C14__9S19718C11[] = {
  ABISELECT(-128,-76),
  ABISELECT(-32,-16),
  ABISELECT(-40,-20),
  ABISELECT(80,48),
  ABISELECT(64,44),
  ABISELECT(-128,-76),
  (VTBL_ENTRY)&(_ZTI9S19718C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19718C14D1Ev,_ZTv0_n28_N9S19718C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19718C14D0Ev,_ZTv0_n28_N9S19718C14D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N9S19718C14D1Ev,_ZTv0_n20_N9S19718C14D1Ev)();
extern void ABISELECT(_ZThn208_N9S19718C14D1Ev,_ZThn124_N9S19718C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19718C14D0Ev,_ZTv0_n20_N9S19718C14D0Ev)();
extern void ABISELECT(_ZThn208_N9S19718C14D0Ev,_ZThn124_N9S19718C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19718C17__9S19718C14__9S19718C11[] = {
  ABISELECT(-208,-124),
  ABISELECT(-112,-64),
  ABISELECT(-120,-68),
  ABISELECT(-208,-124),
  (VTBL_ENTRY)&(_ZTI9S19718C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19718C14D1Ev,_ZTv0_n20_N9S19718C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19718C14D0Ev,_ZTv0_n20_N9S19718C14D0Ev),
};
extern void _ZN9S19718C19D1Ev();
extern void _ZN9S19718C19D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19718C19__9S19718C11[] = {
  ABISELECT(72,48),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C19[0]),
  (VTBL_ENTRY)&_ZN9S19718C19D1Ev,
  (VTBL_ENTRY)&_ZN9S19718C19D0Ev,
};
extern void _ZN9S19718C15D1Ev();
extern void _ZN9S19718C15D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19718C15__9S19718C11[] = {
  ABISELECT(-32,-16),
  ABISELECT(-40,-20),
  ABISELECT(80,48),
  ABISELECT(64,44),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C15[0]),
  (VTBL_ENTRY)&_ZN9S19718C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19718C15D0Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19718C15D1Ev,_ZTv0_n20_N9S19718C15D1Ev)();
extern void ABISELECT(_ZThn80_N9S19718C15D1Ev,_ZThn48_N9S19718C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19718C15D0Ev,_ZTv0_n20_N9S19718C15D0Ev)();
extern void ABISELECT(_ZThn80_N9S19718C15D0Ev,_ZThn48_N9S19718C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19718C17__9S19718C15__9S19718C11[] = {
  ABISELECT(-80,-48),
  ABISELECT(-112,-64),
  ABISELECT(-120,-68),
  ABISELECT(-80,-48),
  (VTBL_ENTRY)&(_ZTI9S19718C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19718C15D1Ev,_ZTv0_n20_N9S19718C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19718C15D0Ev,_ZTv0_n20_N9S19718C15D0Ev),
};
extern void _ZN9S19718C17D1Ev();
extern void _ZN9S19718C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19718C17__9S19718C11[] = {
  ABISELECT(-112,-64),
  ABISELECT(-120,-68),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C17[0]),
  (VTBL_ENTRY)&_ZN9S19718C17D1Ev,
  (VTBL_ENTRY)&_ZN9S19718C17D0Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19718C129S19718C17__A1__9S19718C11[] = {
  ABISELECT(-112,-64),
  ABISELECT(-120,-68),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C12[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19718C139S19718C129S19718C17__A1__9S19718C11[] = {
  ABISELECT(-112,-64),
  ABISELECT(-120,-68),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C13[0]),
};
static  VTT_ENTRY vtt_S19718C11[] = {
  {&(_ZTV9S19718C11[8]),  8,40},
  {&(_tg__ZTV9S19718C12__9S19718C11[4]),  4,4},
  {&(_tg__ZTV9S19718C139S19718C12__9S19718C11[4]),  4,4},
  {&(_tg__ZTV9S19718C14__9S19718C11[7]),  7,9},
  {&(_tg__ZTV9S19718C15__9S19718C14__9S19718C11[7]),  7,9},
  {&(_tg__ZTV9S19718C17__9S19718C14__9S19718C11[5]),  5,7},
  {&(_tg__ZTV9S19718C19__9S19718C11[3]),  3,5},
  {&(_ZTV9S19718C11[17]),  17,40},
  {&(_ZTV9S19718C11[31]),  31,40},
  {&(_ZTV9S19718C11[38]),  38,40},
  {&(_ZTV9S19718C11[22]),  22,40},
  {&(_tg__ZTV9S19718C15__9S19718C11[6]),  6,8},
  {&(_tg__ZTV9S19718C17__9S19718C15__9S19718C11[5]),  5,7},
  {&(_tg__ZTV9S19718C17__9S19718C11[4]),  4,6},
  {&(_tg__ZTV9S19718C129S19718C17__A1__9S19718C11[4]),  4,4},
  {&(_tg__ZTV9S19718C139S19718C129S19718C17__A1__9S19718C11[4]),  4,4},
};
extern VTBL_ENTRY _ZTI9S19718C11[];
extern  VTBL_ENTRY _ZTV9S19718C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C11[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19718C15D0Ev,_ZTv0_n20_N9S19718C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S19718C15D0Ev,_ZThn48_N9S19718C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19718C15D1Ev,_ZTv0_n20_N9S19718C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S19718C15D1Ev,_ZThn48_N9S19718C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19718C14D0Ev,_ZTv0_n20_N9S19718C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn208_N9S19718C14D0Ev,_ZThn124_N9S19718C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19718C14D1Ev,_ZTv0_n20_N9S19718C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn208_N9S19718C14D1Ev,_ZThn124_N9S19718C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19718C14D0Ev,_ZTv0_n28_N9S19718C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn128_N9S19718C14D0Ev,_ZThn76_N9S19718C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19718C14D1Ev,_ZTv0_n28_N9S19718C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn128_N9S19718C14D1Ev,_ZThn76_N9S19718C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19718C11D0Ev,_ZTv0_n20_N9S19718C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn256_N9S19718C11D0Ev,_ZThn156_N9S19718C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19718C11D1Ev,_ZTv0_n20_N9S19718C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn256_N9S19718C11D1Ev,_ZThn156_N9S19718C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19718C11D0Ev,_ZTv0_n28_N9S19718C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N9S19718C11D0Ev,_ZThn108_N9S19718C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19718C11D1Ev,_ZTv0_n28_N9S19718C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N9S19718C11D1Ev,_ZThn108_N9S19718C11D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19718C11 = {  "S19718C11", // class name
  bases_S19718C11, 20,
  &(vtc_S19718C11[0]), // expected_vtbl_contents
  &(vtt_S19718C11[0]), // expected_vtt_contents
  ABISELECT(304,188), // object size
  NSPAIRA(_ZTI9S19718C11),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S19718C11),40, //virtual function table var
  8, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19718C11),16, //virtual table table var
  8, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19718C22  : virtual S19718C7 {
  ~S19718C22(); // tgen
  S19718C22(); // tgen
};
//SIG(-1 S19718C22) C1{ VBC2{ BC3{ m FD} BC4{ m Fi} FC4}}


S19718C22 ::~S19718C22(){ note_dtor("S19718C22", this);} // tgen
S19718C22 ::S19718C22(){ note_ctor("S19718C22", this);} // tgen

static void Test_S19718C22()
{
  extern Class_Descriptor cd_S19718C22;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(4,7)];
    init_test(&cd_S19718C22, buf);
    S19718C22 *dp, &lv = *(dp=new (buf) S19718C22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(S19718C22)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19718C22)");
    check_base_class_offset(lv, (S19718C8_nt*)(S19718C7*), ABISELECT(16,4), "S19718C22");
    check_base_class_offset(lv, (S19718C9_nt*)(S19718C7*), ABISELECT(32,16), "S19718C22");
    check_base_class_offset(lv, (S19718C7*), ABISELECT(16,4), "S19718C22");
    test_class_info(&lv, &cd_S19718C22);
    dp->~S19718C22();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19718C22(Test_S19718C22, "S19718C22", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN9S19718C22C1Ev();
extern void _ZN9S19718C22D1Ev();
Name_Map name_map_S19718C22[] = {
  NSPAIR(_ZN9S19718C22C1Ev),
  NSPAIR(_ZN9S19718C22D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
extern Class_Descriptor cd_S19718C9_nt;
extern VTBL_ENTRY _ZTI11S19718C9_nt[];
extern Class_Descriptor cd_S19718C7;
extern VTBL_ENTRY _ZTI8S19718C7[];
static Base_Class bases_S19718C22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19718C8_nt,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19718C9_nt,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19718C7,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19718C22[];
static  VTBL_ENTRY vtc_S19718C22[] = {
  ABISELECT(16,4),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C22[0]),
};
extern VTBL_ENTRY _ZTV9S19718C22[];
static  VTT_ENTRY vtt_S19718C22[] = {
  {&(_ZTV9S19718C22[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S19718C22[];
extern  VTBL_ENTRY _ZTV9S19718C22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C22[];
Class_Descriptor cd_S19718C22 = {  "S19718C22", // class name
  bases_S19718C22, 3,
  &(vtc_S19718C22[0]), // expected_vtbl_contents
  &(vtt_S19718C22[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI9S19718C22),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV9S19718C22),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19718C22),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19718C21  : S19718C22 , virtual S2122C28 {
  virtual  ~S19718C21(); // _ZN9S19718C21D2Ev
  S19718C21(); // tgen
};
//SIG(-1 S19718C21) C1{ BC2{ VBC3{ BC4{ m FD} BC5{ m Fi} FC5}} VBC6{ m} vd}


 S19718C21 ::~S19718C21(){ note_dtor("S19718C21", this);}
S19718C21 ::S19718C21(){ note_ctor("S19718C21", this);} // tgen

static void Test_S19718C21()
{
  extern Class_Descriptor cd_S19718C21;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(4,7)];
    init_test(&cd_S19718C21, buf);
    S19718C21 *dp, &lv = *(dp=new (buf) S19718C21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(S19718C21)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19718C21)");
    check_base_class_offset(lv, (S19718C8_nt*)(S19718C7*), ABISELECT(16,4), "S19718C21");
    check_base_class_offset(lv, (S19718C9_nt*)(S19718C7*), ABISELECT(32,16), "S19718C21");
    check_base_class_offset(lv, (S19718C7*)(S19718C22*), ABISELECT(16,4), "S19718C21");
    check_base_class_offset(lv, (S19718C22*), 0, "S19718C21");
    check_base_class_offset(lv, (S2122C28*), 0, "S19718C21");
    test_class_info(&lv, &cd_S19718C21);
    dp->~S19718C21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19718C21(Test_S19718C21, "S19718C21", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN9S19718C21C1Ev();
extern void _ZN9S19718C21D2Ev();
Name_Map name_map_S19718C21[] = {
  NSPAIR(_ZN9S19718C21C1Ev),
  NSPAIR(_ZN9S19718C21D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
extern Class_Descriptor cd_S19718C9_nt;
extern VTBL_ENTRY _ZTI11S19718C9_nt[];
extern Class_Descriptor cd_S19718C7;
extern VTBL_ENTRY _ZTI8S19718C7[];
extern Class_Descriptor cd_S19718C22;
extern VTBL_ENTRY _ZTI9S19718C22[];
extern  VTBL_ENTRY _ZTV9S19718C22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C22[];
extern Class_Descriptor cd_S2122C28;
extern VTBL_ENTRY _ZTI8S2122C28[];
static Base_Class bases_S19718C21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19718C8_nt,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19718C9_nt,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19718C7,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S19718C22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2122C28,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19718C21[];
extern void _ZN9S19718C21D1Ev();
extern void _ZN9S19718C21D0Ev();
static  VTBL_ENTRY vtc_S19718C21[] = {
  0,
  ABISELECT(16,4),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C21[0]),
  (VTBL_ENTRY)&_ZN9S19718C21D1Ev,
  (VTBL_ENTRY)&_ZN9S19718C21D0Ev,
};
extern VTBL_ENTRY _ZTV9S19718C21[];
static  VTBL_ENTRY _tg__ZTV9S19718C22__9S19718C21[] = {
  ABISELECT(16,4),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C22[0]),
};
static  VTT_ENTRY vtt_S19718C21[] = {
  {&(_ZTV9S19718C21[4]),  4,6},
  {&(_tg__ZTV9S19718C22__9S19718C21[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S19718C21[];
extern  VTBL_ENTRY _ZTV9S19718C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C21[];
Class_Descriptor cd_S19718C21 = {  "S19718C21", // class name
  bases_S19718C21, 5,
  &(vtc_S19718C21[0]), // expected_vtbl_contents
  &(vtt_S19718C21[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI9S19718C21),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S19718C21),6, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19718C21),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19718C3  : S19718C4 , virtual S19718C6 , virtual S19718C11 , virtual S19718C21 , virtual S19718C13 {
  int s19718c3f0;
  virtual  ~S19718C3(); // _ZN8S19718C3D2Ev
  S19718C3(); // tgen
};
//SIG(-1 S19718C3) C1{ BC2{ BC3{ m Fi} BC4{ m} vd} VBC5{ BC6{ BC7{ m FD} BC8{ m Fi} FC8} BC3 BC9{ m} vd} VBC10{ BC11{ BC12{ VBC8 VBC7 Fi} FC12} VBC3 BC13{ VBC14{ BC7 VBC15{ m Fc} VBC16{ BC11 vd} BC6 BC17{ m Fi} vd Fi} BC8 vd} BC18{ VBC8 BC7 vd} BC19{ m FC12} Fi[2]} VBC20{ BC21{ VBC6} VBC9 vd} VBC12 vd Fi}


 S19718C3 ::~S19718C3(){ note_dtor("S19718C3", this);}
S19718C3 ::S19718C3(){ note_ctor("S19718C3", this);} // tgen

static void Test_S19718C3()
{
  extern Class_Descriptor cd_S19718C3;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(28,66)];
    init_test(&cd_S19718C3, buf);
    S19718C3 *dp, &lv = *(dp=new (buf) S19718C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(432,260), "sizeof(S19718C3)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19718C3)");
    check_base_class_offset(lv, (S3443C8_nt*)(S19718C4*), ABISELECT(8,4), "S19718C3");
    check_base_class_offset(lv, (S2122C38*)(S19718C4*), 0, "S19718C3");
    check_base_class_offset(lv, (S19718C4*), 0, "S19718C3");
    check_base_class_offset(lv, (S19718C8_nt*)(S19718C7*)(S19718C6*), ABISELECT(32,16), "S19718C3");
    check_base_class_offset(lv, (S19718C9_nt*)(S19718C7*)(S19718C6*), ABISELECT(48,28), "S19718C3");
    check_base_class_offset(lv, (S19718C7*)(S19718C6*), ABISELECT(32,16), "S19718C3");
    check_base_class_offset(lv, (S3443C8_nt*)(S19718C6*), ABISELECT(56,36), "S19718C3");
    check_base_class_offset(lv, (S2122C28*)(S19718C6*), ABISELECT(16,12), "S19718C3");
    check_base_class_offset(lv, (S19718C6*), ABISELECT(16,12), "S19718C3");
    /*is_ambiguous_... S19718C11::S19718C12 */ AMB_check_base_class_offset(lv, (S19718C9_nt*)(S19718C13*)(S19718C12*)(S19718C11*), ABISELECT(200,128), "S19718C3");
    check_base_class_offset(lv, (S19718C9_nt*)(S19718C13*)(S19718C12*)(S19718C17*), ABISELECT(200,128), "S19718C3");
    check_base_class_offset(lv, (S19718C9_nt*)(S19718C19*)(S19718C11*), ABISELECT(200,128), "S19718C3");
    /*is_ambiguous_... S19718C3::S19718C13 */ AMB_check_base_class_offset(lv, (S19718C9_nt*)(S19718C13*), ABISELECT(200,128), "S19718C3");
    /*is_ambiguous_... S19718C11::S19718C12 */ AMB_check_base_class_offset(lv, (S19718C8_nt*)(S19718C13*)(S19718C12*)(S19718C11*), ABISELECT(208,132), "S19718C3");
    check_base_class_offset(lv, (S19718C8_nt*)(S19718C13*)(S19718C12*)(S19718C17*), ABISELECT(208,132), "S19718C3");
    /*is_ambiguous_... S19718C3::S19718C13 */ AMB_check_base_class_offset(lv, (S19718C8_nt*)(S19718C13*), ABISELECT(208,132), "S19718C3");
    /*is_ambiguous_... S19718C11::S19718C12 */ AMB_check_base_class_offset(lv, (S19718C13*)(S19718C12*)(S19718C11*), ABISELECT(64,40), "S19718C3");
    /*is_ambiguous_... S19718C11::S19718C12 */ AMB_check_base_class_offset(lv, (S19718C12*)(S19718C11*), ABISELECT(64,40), "S19718C3");
    check_base_class_offset(lv, (S3443C8_nt*)(S19718C11*), ABISELECT(224,144), "S19718C3");
    /*is_ambiguous_... S19718C15::S19718C8_nt */ AMB_check_base_class_offset(lv, (S19718C8_nt*)(S19718C15*), ABISELECT(256,152), "S19718C3");
    check_base_class_offset(lv, (S19718C16_nt*)(S19718C15*), ABISELECT(304,192), "S19718C3");
    check_base_class_offset(lv, (S19718C13*)(S19718C12*)(S19718C17*), ABISELECT(320,196), "S19718C3");
    check_base_class_offset(lv, (S19718C12*)(S19718C17*), ABISELECT(320,196), "S19718C3");
    check_base_class_offset(lv, (S19718C17*)(S19718C15*), ABISELECT(320,196), "S19718C3");
    check_base_class_offset(lv, (S19718C8_nt*)(S19718C7*)(S19718C15*), ABISELECT(272,164), "S19718C3");
    check_base_class_offset(lv, (S19718C9_nt*)(S19718C7*)(S19718C15*), ABISELECT(288,176), "S19718C3");
    check_base_class_offset(lv, (S19718C7*)(S19718C15*), ABISELECT(272,164), "S19718C3");
    check_base_class_offset(lv, (S19718C18*)(S19718C15*), ABISELECT(296,184), "S19718C3");
    check_base_class_offset(lv, (S19718C15*)(S19718C14*)(S19718C11*), ABISELECT(240,148), "S19718C3");
    /*is_ambiguous_... S19718C14::S19718C9_nt */ AMB_check_base_class_offset(lv, (S19718C9_nt*)(S19718C14*)(S19718C11*), ABISELECT(120,76), "S19718C3");
    check_base_class_offset(lv, (S19718C14*)(S19718C11*), ABISELECT(112,72), "S19718C3");
    check_base_class_offset(lv, (S19718C8_nt*)(S19718C19*)(S19718C11*), ABISELECT(144,84), "S19718C3");
    check_base_class_offset(lv, (S19718C19*)(S19718C11*), ABISELECT(128,80), "S19718C3");
    check_base_class_offset(lv, (S19718C20*)(S19718C11*), ABISELECT(160,96), "S19718C3");
    check_base_class_offset(lv, (S19718C11*), ABISELECT(64,40), "S19718C3");
    /*is_ambiguous_... S19718C3::S19718C7 */ AMB_check_base_class_offset(lv, (S19718C8_nt*)(S19718C7*), ABISELECT(384,232), "S19718C3");
    /*is_ambiguous_... S19718C3::S19718C7 */ AMB_check_base_class_offset(lv, (S19718C9_nt*)(S19718C7*), ABISELECT(400,244), "S19718C3");
    check_base_class_offset(lv, (S19718C7*)(S19718C22*)(S19718C21*), ABISELECT(384,232), "S19718C3");
    check_base_class_offset(lv, (S19718C22*)(S19718C21*), ABISELECT(368,228), "S19718C3");
    check_base_class_offset(lv, (S2122C28*)(S19718C21*), 0, "S19718C3");
    check_base_class_offset(lv, (S19718C21*), ABISELECT(368,228), "S19718C3");
    /*is_ambiguous_... S19718C3::S19718C13 */ AMB_check_base_class_offset(lv, (S19718C13*), ABISELECT(408,252), "S19718C3");
    check_field_offset(lv, s19718c3f0, ABISELECT(12,8), "S19718C3.s19718c3f0");
    test_class_info(&lv, &cd_S19718C3);
    dp->~S19718C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19718C3(Test_S19718C3, "S19718C3", ABISELECT(432,260));

#else // __cplusplus

extern void _ZN8S19718C3C1Ev();
extern void _ZN8S19718C3D2Ev();
Name_Map name_map_S19718C3[] = {
  NSPAIR(_ZN8S19718C3C1Ev),
  NSPAIR(_ZN8S19718C3D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S3443C8_nt;
extern VTBL_ENTRY _ZTI10S3443C8_nt[];
extern Class_Descriptor cd_S2122C38;
extern VTBL_ENTRY _ZTI8S2122C38[];
extern Class_Descriptor cd_S19718C4;
extern VTBL_ENTRY _ZTI8S19718C4[];
extern  VTBL_ENTRY _ZTV8S19718C4[];
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
extern Class_Descriptor cd_S19718C9_nt;
extern VTBL_ENTRY _ZTI11S19718C9_nt[];
extern Class_Descriptor cd_S19718C7;
extern VTBL_ENTRY _ZTI8S19718C7[];
extern Class_Descriptor cd_S3443C8_nt;
extern VTBL_ENTRY _ZTI10S3443C8_nt[];
extern Class_Descriptor cd_S2122C28;
extern VTBL_ENTRY _ZTI8S2122C28[];
extern Class_Descriptor cd_S19718C6;
extern VTBL_ENTRY _ZTI8S19718C6[];
extern  VTBL_ENTRY _ZTV8S19718C6[];
extern Class_Descriptor cd_S19718C9_nt;
extern VTBL_ENTRY _ZTI11S19718C9_nt[];
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
extern Class_Descriptor cd_S19718C13;
extern VTBL_ENTRY _ZTI9S19718C13[];
extern  VTBL_ENTRY _ZTV9S19718C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C13[];
extern Class_Descriptor cd_S19718C12;
extern VTBL_ENTRY _ZTI9S19718C12[];
extern  VTBL_ENTRY _ZTV9S19718C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C12[];
extern Class_Descriptor cd_S3443C8_nt;
extern VTBL_ENTRY _ZTI10S3443C8_nt[];
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
extern Class_Descriptor cd_S19718C16_nt;
extern VTBL_ENTRY _ZTI12S19718C16_nt[];
extern Class_Descriptor cd_S19718C13;
extern VTBL_ENTRY _ZTI9S19718C13[];
extern  VTBL_ENTRY _ZTV9S19718C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C13[];
extern Class_Descriptor cd_S19718C12;
extern VTBL_ENTRY _ZTI9S19718C12[];
extern  VTBL_ENTRY _ZTV9S19718C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C12[];
extern Class_Descriptor cd_S19718C17;
extern VTBL_ENTRY _ZTI9S19718C17[];
extern  VTBL_ENTRY _ZTV9S19718C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C17[];
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
extern Class_Descriptor cd_S19718C9_nt;
extern VTBL_ENTRY _ZTI11S19718C9_nt[];
extern Class_Descriptor cd_S19718C7;
extern VTBL_ENTRY _ZTI8S19718C7[];
extern Class_Descriptor cd_S19718C18;
extern VTBL_ENTRY _ZTI9S19718C18[];
extern Class_Descriptor cd_S19718C15;
extern VTBL_ENTRY _ZTI9S19718C15[];
extern  VTBL_ENTRY _ZTV9S19718C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C15[];
extern Class_Descriptor cd_S19718C9_nt;
extern VTBL_ENTRY _ZTI11S19718C9_nt[];
extern Class_Descriptor cd_S19718C14;
extern VTBL_ENTRY _ZTI9S19718C14[];
extern  VTBL_ENTRY _ZTV9S19718C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C14[];
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
extern Class_Descriptor cd_S19718C19;
extern VTBL_ENTRY _ZTI9S19718C19[];
extern  VTBL_ENTRY _ZTV9S19718C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C19[];
extern Class_Descriptor cd_S19718C20;
extern VTBL_ENTRY _ZTI9S19718C20[];
extern Class_Descriptor cd_S19718C11;
extern VTBL_ENTRY _ZTI9S19718C11[];
extern  VTBL_ENTRY _ZTV9S19718C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C11[];
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
extern Class_Descriptor cd_S19718C9_nt;
extern VTBL_ENTRY _ZTI11S19718C9_nt[];
extern Class_Descriptor cd_S19718C7;
extern VTBL_ENTRY _ZTI8S19718C7[];
extern Class_Descriptor cd_S19718C22;
extern VTBL_ENTRY _ZTI9S19718C22[];
extern  VTBL_ENTRY _ZTV9S19718C22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C22[];
extern Class_Descriptor cd_S2122C28;
extern VTBL_ENTRY _ZTI8S2122C28[];
extern Class_Descriptor cd_S19718C21;
extern VTBL_ENTRY _ZTI9S19718C21[];
extern  VTBL_ENTRY _ZTV9S19718C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C21[];
extern Class_Descriptor cd_S19718C13;
extern VTBL_ENTRY _ZTI9S19718C13[];
extern  VTBL_ENTRY _ZTV9S19718C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C13[];
static Base_Class bases_S19718C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3443C8_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2122C38,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19718C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19718C8_nt,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19718C9_nt,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19718C7,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S3443C8_nt,    ABISELECT(56,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S2122C28,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19718C6,    ABISELECT(16,12), //bcp->offset
    16, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19718C9_nt,    ABISELECT(200,128), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S19718C8_nt,    ABISELECT(208,132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S19718C13,    ABISELECT(64,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19718C12,    ABISELECT(64,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S3443C8_nt,    ABISELECT(224,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    29, //immediately_derived
  0, 1},
  {&cd_S19718C8_nt,    ABISELECT(256,152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S19718C16_nt,    ABISELECT(304,192), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 1},
  {&cd_S19718C13,    ABISELECT(320,196), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19718C12,    ABISELECT(320,196), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S19718C17,    ABISELECT(320,196), //bcp->offset
    55, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    23, //immediately_derived
  0, 1},
  {&cd_S19718C8_nt,    ABISELECT(272,164), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19718C9_nt,    ABISELECT(288,176), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19718C7,    ABISELECT(272,164), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S19718C18,    ABISELECT(296,184), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S19718C15,    ABISELECT(240,148), //bcp->offset
    46, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    25, //immediately_derived
  0, 1},
  {&cd_S19718C9_nt,    ABISELECT(120,76), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S19718C14,    ABISELECT(112,72), //bcp->offset
    32, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19718C8_nt,    ABISELECT(144,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S19718C19,    ABISELECT(128,80), //bcp->offset
    41, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19718C20,    ABISELECT(160,96), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19718C11,    ABISELECT(64,40), //bcp->offset
    21, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19718C8_nt,    ABISELECT(384,232), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S19718C9_nt,    ABISELECT(400,244), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S19718C7,    ABISELECT(384,232), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    33, //immediately_derived
  0, 1},
  {&cd_S19718C22,    ABISELECT(368,228), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    27, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S2122C28,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    35, //immediately_derived
  0, 1},
  {&cd_S19718C21,    ABISELECT(368,228), //bcp->offset
    62, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19718C13,    ABISELECT(408,252), //bcp->offset
    69, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S19718C3[];
extern void _ZN8S19718C3D1Ev();
extern void _ZN8S19718C3D0Ev();
extern void ABISELECT(_ZTv0_n24_N8S19718C3D1Ev,_ZTv0_n12_N8S19718C3D1Ev)();
extern void ABISELECT(_ZThn16_N8S19718C3D1Ev,_ZThn12_N8S19718C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19718C3D0Ev,_ZTv0_n12_N8S19718C3D0Ev)();
extern void ABISELECT(_ZThn16_N8S19718C3D0Ev,_ZThn12_N8S19718C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S19718C3D1Ev,_ZTv0_n36_N8S19718C3D1Ev)();
extern void ABISELECT(_ZThn64_N8S19718C3D1Ev,_ZThn40_N8S19718C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S19718C3D0Ev,_ZTv0_n36_N8S19718C3D0Ev)();
extern void ABISELECT(_ZThn64_N8S19718C3D0Ev,_ZThn40_N8S19718C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn48_n72_N8S19718C3D1Ev,_ZTvn32_n36_N8S19718C3D1Ev)();
extern void ABISELECT(_ZTvn48_n72_N8S19718C3D0Ev,_ZTvn32_n36_N8S19718C3D0Ev)();
extern void ABISELECT(_ZTvn64_n72_N8S19718C3D1Ev,_ZTvn40_n36_N8S19718C3D1Ev)();
extern void ABISELECT(_ZTvn64_n72_N8S19718C3D0Ev,_ZTvn40_n36_N8S19718C3D0Ev)();
extern void ABISELECT(_ZTv0_n56_N8S19718C3D1Ev,_ZTv0_n28_N8S19718C3D1Ev)();
extern void ABISELECT(_ZThn240_N8S19718C3D1Ev,_ZThn148_N8S19718C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S19718C3D0Ev,_ZTv0_n28_N8S19718C3D0Ev)();
extern void ABISELECT(_ZThn240_N8S19718C3D0Ev,_ZThn148_N8S19718C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19718C3D1Ev,_ZTv0_n20_N8S19718C3D1Ev)();
extern void ABISELECT(_ZThn320_N8S19718C3D1Ev,_ZThn196_N8S19718C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19718C3D0Ev,_ZTv0_n20_N8S19718C3D0Ev)();
extern void ABISELECT(_ZThn320_N8S19718C3D0Ev,_ZThn196_N8S19718C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19718C3D1Ev,_ZTv0_n20_N8S19718C3D1Ev)();
extern void ABISELECT(_ZThn368_N8S19718C3D1Ev,_ZThn228_N8S19718C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19718C3D0Ev,_ZTv0_n20_N8S19718C3D0Ev)();
extern void ABISELECT(_ZThn368_N8S19718C3D0Ev,_ZThn228_N8S19718C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19718C3[] = {
  ABISELECT(408,252),
  0,
  ABISELECT(384,232),
  ABISELECT(368,228),
  ABISELECT(320,196),
  ABISELECT(304,192),
  ABISELECT(240,148),
  ABISELECT(224,144),
  ABISELECT(208,132),
  ABISELECT(200,128),
  ABISELECT(64,40),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI8S19718C3[0]),
  (VTBL_ENTRY)&_ZN8S19718C3D1Ev,
  (VTBL_ENTRY)&_ZN8S19718C3D0Ev,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8S19718C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19718C3D1Ev,_ZTv0_n12_N8S19718C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19718C3D0Ev,_ZTv0_n12_N8S19718C3D0Ev),
  ABISELECT(-64,-40),
  ABISELECT(256,156),
  ABISELECT(240,152),
  ABISELECT(176,108),
  ABISELECT(160,104),
  ABISELECT(144,92),
  ABISELECT(136,88),
  ABISELECT(-64,-40),
  (VTBL_ENTRY)&(_ZTI8S19718C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S19718C3D1Ev,_ZTv0_n36_N8S19718C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S19718C3D0Ev,_ZTv0_n36_N8S19718C3D0Ev),
  ABISELECT(96,60),
  ABISELECT(88,56),
  ABISELECT(208,124),
  ABISELECT(192,120),
  ABISELECT(128,76),
  ABISELECT(-112,-72),
  (VTBL_ENTRY)&(_ZTI8S19718C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn48_n72_N8S19718C3D1Ev,_ZTvn32_n36_N8S19718C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn48_n72_N8S19718C3D0Ev,_ZTvn32_n36_N8S19718C3D0Ev),
  ABISELECT(72,48),
  ABISELECT(-128,-80),
  (VTBL_ENTRY)&(_ZTI8S19718C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn64_n72_N8S19718C3D1Ev,_ZTvn40_n36_N8S19718C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn64_n72_N8S19718C3D0Ev,_ZTvn40_n36_N8S19718C3D0Ev),
  ABISELECT(-240,-148),
  ABISELECT(-32,-16),
  ABISELECT(-40,-20),
  ABISELECT(80,48),
  ABISELECT(64,44),
  ABISELECT(-240,-148),
  (VTBL_ENTRY)&(_ZTI8S19718C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S19718C3D1Ev,_ZTv0_n28_N8S19718C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S19718C3D0Ev,_ZTv0_n28_N8S19718C3D0Ev),
  ABISELECT(-320,-196),
  ABISELECT(-112,-64),
  ABISELECT(-120,-68),
  ABISELECT(-320,-196),
  (VTBL_ENTRY)&(_ZTI8S19718C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19718C3D1Ev,_ZTv0_n20_N8S19718C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19718C3D0Ev,_ZTv0_n20_N8S19718C3D0Ev),
  ABISELECT(-368,-228),
  ABISELECT(-368,-228),
  ABISELECT(16,4),
  ABISELECT(-368,-228),
  (VTBL_ENTRY)&(_ZTI8S19718C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19718C3D1Ev,_ZTv0_n20_N8S19718C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19718C3D0Ev,_ZTv0_n20_N8S19718C3D0Ev),
  ABISELECT(-200,-120),
  ABISELECT(-208,-124),
  ABISELECT(-408,-252),
  (VTBL_ENTRY)&(_ZTI8S19718C3[0]),
};
extern VTBL_ENTRY _ZTV8S19718C3[];
extern void _ZN9S19718C11D1Ev();
extern void _ZN9S19718C11D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19718C11__8S19718C3[] = {
  ABISELECT(256,156),
  ABISELECT(240,152),
  ABISELECT(176,108),
  ABISELECT(160,104),
  ABISELECT(144,92),
  ABISELECT(136,88),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C11[0]),
  (VTBL_ENTRY)&_ZN9S19718C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19718C11D0Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19718C129S19718C11__8S19718C3[] = {
  ABISELECT(144,92),
  ABISELECT(136,88),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C12[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19718C139S19718C129S19718C11__8S19718C3[] = {
  ABISELECT(144,92),
  ABISELECT(136,88),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C13[0]),
};
extern void _ZN9S19718C14D1Ev();
extern void _ZN9S19718C14D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19718C149S19718C11__8S19718C3[] = {
  ABISELECT(96,60),
  ABISELECT(88,56),
  ABISELECT(208,124),
  ABISELECT(192,120),
  ABISELECT(128,76),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C14[0]),
  (VTBL_ENTRY)&_ZN9S19718C14D1Ev,
  (VTBL_ENTRY)&_ZN9S19718C14D0Ev,
};
extern void ABISELECT(_ZTv0_n56_N9S19718C14D1Ev,_ZTv0_n28_N9S19718C14D1Ev)();
extern void ABISELECT(_ZThn128_N9S19718C14D1Ev,_ZThn76_N9S19718C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S19718C14D0Ev,_ZTv0_n28_N9S19718C14D0Ev)();
extern void ABISELECT(_ZThn128_N9S19718C14D0Ev,_ZThn76_N9S19718C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19718C15__9S19718C149S19718C11__8S19718C3[] = {
  ABISELECT(-128,-76),
  ABISELECT(-32,-16),
  ABISELECT(-40,-20),
  ABISELECT(80,48),
  ABISELECT(64,44),
  ABISELECT(-128,-76),
  (VTBL_ENTRY)&(_ZTI9S19718C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19718C14D1Ev,_ZTv0_n28_N9S19718C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19718C14D0Ev,_ZTv0_n28_N9S19718C14D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N9S19718C14D1Ev,_ZTv0_n20_N9S19718C14D1Ev)();
extern void ABISELECT(_ZThn208_N9S19718C14D1Ev,_ZThn124_N9S19718C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19718C14D0Ev,_ZTv0_n20_N9S19718C14D0Ev)();
extern void ABISELECT(_ZThn208_N9S19718C14D0Ev,_ZThn124_N9S19718C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19718C17__9S19718C149S19718C11__8S19718C3[] = {
  ABISELECT(-208,-124),
  ABISELECT(-112,-64),
  ABISELECT(-120,-68),
  ABISELECT(-208,-124),
  (VTBL_ENTRY)&(_ZTI9S19718C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19718C14D1Ev,_ZTv0_n20_N9S19718C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19718C14D0Ev,_ZTv0_n20_N9S19718C14D0Ev),
};
extern void _ZN9S19718C19D1Ev();
extern void _ZN9S19718C19D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19718C199S19718C11__8S19718C3[] = {
  ABISELECT(72,48),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C19[0]),
  (VTBL_ENTRY)&_ZN9S19718C19D1Ev,
  (VTBL_ENTRY)&_ZN9S19718C19D0Ev,
};
extern void ABISELECT(_ZThn48_N9S19718C11D1Ev,_ZThn32_N9S19718C11D1Ev)();
extern void ABISELECT(_ZThn48_N9S19718C11D0Ev,_ZThn32_N9S19718C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19718C14__9S19718C11__8S19718C3[] = {
  ABISELECT(96,60),
  ABISELECT(88,56),
  ABISELECT(208,124),
  ABISELECT(192,120),
  ABISELECT(128,76),
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S19718C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S19718C11D1Ev,_ZThn32_N9S19718C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S19718C11D0Ev,_ZThn32_N9S19718C11D0Ev),
};
extern void ABISELECT(_ZTv0_n56_N9S19718C11D1Ev,_ZTv0_n28_N9S19718C11D1Ev)();
extern void ABISELECT(_ZThn176_N9S19718C11D1Ev,_ZThn108_N9S19718C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S19718C11D0Ev,_ZTv0_n28_N9S19718C11D0Ev)();
extern void ABISELECT(_ZThn176_N9S19718C11D0Ev,_ZThn108_N9S19718C11D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19718C15__9S19718C11__8S19718C3[] = {
  ABISELECT(-176,-108),
  ABISELECT(-32,-16),
  ABISELECT(-40,-20),
  ABISELECT(80,48),
  ABISELECT(64,44),
  ABISELECT(-176,-108),
  (VTBL_ENTRY)&(_ZTI9S19718C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19718C11D1Ev,_ZTv0_n28_N9S19718C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19718C11D0Ev,_ZTv0_n28_N9S19718C11D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N9S19718C11D1Ev,_ZTv0_n20_N9S19718C11D1Ev)();
extern void ABISELECT(_ZThn256_N9S19718C11D1Ev,_ZThn156_N9S19718C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19718C11D0Ev,_ZTv0_n20_N9S19718C11D0Ev)();
extern void ABISELECT(_ZThn256_N9S19718C11D0Ev,_ZThn156_N9S19718C11D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19718C17__9S19718C11__8S19718C3[] = {
  ABISELECT(-256,-156),
  ABISELECT(-112,-64),
  ABISELECT(-120,-68),
  ABISELECT(-256,-156),
  (VTBL_ENTRY)&(_ZTI9S19718C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19718C11D1Ev,_ZTv0_n20_N9S19718C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19718C11D0Ev,_ZTv0_n20_N9S19718C11D0Ev),
};
extern void ABISELECT(_ZThn64_N9S19718C11D1Ev,_ZThn40_N9S19718C11D1Ev)();
extern void ABISELECT(_ZThn64_N9S19718C11D0Ev,_ZThn40_N9S19718C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19718C19__9S19718C11__8S19718C3[] = {
  ABISELECT(72,48),
  ABISELECT(-64,-40),
  (VTBL_ENTRY)&(_ZTI9S19718C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S19718C11D1Ev,_ZThn40_N9S19718C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S19718C11D0Ev,_ZThn40_N9S19718C11D0Ev),
};
extern void _ZN9S19718C15D1Ev();
extern void _ZN9S19718C15D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19718C15__8S19718C3[] = {
  ABISELECT(-32,-16),
  ABISELECT(-40,-20),
  ABISELECT(80,48),
  ABISELECT(64,44),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C15[0]),
  (VTBL_ENTRY)&_ZN9S19718C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19718C15D0Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19718C15D1Ev,_ZTv0_n20_N9S19718C15D1Ev)();
extern void ABISELECT(_ZThn80_N9S19718C15D1Ev,_ZThn48_N9S19718C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19718C15D0Ev,_ZTv0_n20_N9S19718C15D0Ev)();
extern void ABISELECT(_ZThn80_N9S19718C15D0Ev,_ZThn48_N9S19718C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19718C17__9S19718C15__8S19718C3[] = {
  ABISELECT(-80,-48),
  ABISELECT(-112,-64),
  ABISELECT(-120,-68),
  ABISELECT(-80,-48),
  (VTBL_ENTRY)&(_ZTI9S19718C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19718C15D1Ev,_ZTv0_n20_N9S19718C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19718C15D0Ev,_ZTv0_n20_N9S19718C15D0Ev),
};
extern void _ZN9S19718C17D1Ev();
extern void _ZN9S19718C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19718C17__8S19718C3[] = {
  ABISELECT(-112,-64),
  ABISELECT(-120,-68),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C17[0]),
  (VTBL_ENTRY)&_ZN9S19718C17D1Ev,
  (VTBL_ENTRY)&_ZN9S19718C17D0Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19718C129S19718C17__A1__8S19718C3[] = {
  ABISELECT(-112,-64),
  ABISELECT(-120,-68),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C12[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19718C139S19718C129S19718C17__A1__8S19718C3[] = {
  ABISELECT(-112,-64),
  ABISELECT(-120,-68),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C13[0]),
};
extern void _ZN9S19718C21D1Ev();
extern void _ZN9S19718C21D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19718C21__8S19718C3[] = {
  ABISELECT(-368,-228),
  ABISELECT(16,4),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C21[0]),
  (VTBL_ENTRY)&_ZN9S19718C21D1Ev,
  (VTBL_ENTRY)&_ZN9S19718C21D0Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19718C229S19718C21__8S19718C3[] = {
  ABISELECT(16,4),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C22[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19718C13__A2__8S19718C3[] = {
  ABISELECT(-200,-120),
  ABISELECT(-208,-124),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C13[0]),
};
static  VTT_ENTRY vtt_S19718C3[] = {
  {&(_ZTV8S19718C3[14]),  14,73},
  {&(_ZTV8S19718C3[19]),  19,73},
  {&(_ZTV8S19718C3[30]),  30,73},
  {&(_ZTV8S19718C3[39]),  39,73},
  {&(_ZTV8S19718C3[53]),  53,73},
  {&(_ZTV8S19718C3[60]),  60,73},
  {&(_ZTV8S19718C3[44]),  44,73},
  {&(_ZTV8S19718C3[67]),  67,73},
  {&(_ZTV8S19718C3[73]),  73,73},
  {&(_tg__ZTV9S19718C11__8S19718C3[8]),  8,10},
  {&(_tg__ZTV9S19718C129S19718C11__8S19718C3[4]),  4,4},
  {&(_tg__ZTV9S19718C139S19718C129S19718C11__8S19718C3[4]),  4,4},
  {&(_tg__ZTV9S19718C149S19718C11__8S19718C3[7]),  7,9},
  {&(_tg__ZTV9S19718C15__9S19718C149S19718C11__8S19718C3[7]),  7,9},
  {&(_tg__ZTV9S19718C17__9S19718C149S19718C11__8S19718C3[5]),  5,7},
  {&(_tg__ZTV9S19718C199S19718C11__8S19718C3[3]),  3,5},
  {&(_tg__ZTV9S19718C14__9S19718C11__8S19718C3[7]),  7,9},
  {&(_tg__ZTV9S19718C15__9S19718C11__8S19718C3[7]),  7,9},
  {&(_tg__ZTV9S19718C17__9S19718C11__8S19718C3[5]),  5,7},
  {&(_tg__ZTV9S19718C19__9S19718C11__8S19718C3[3]),  3,5},
  {&(_tg__ZTV9S19718C15__8S19718C3[6]),  6,8},
  {&(_tg__ZTV9S19718C17__9S19718C15__8S19718C3[5]),  5,7},
  {&(_tg__ZTV9S19718C17__8S19718C3[4]),  4,6},
  {&(_tg__ZTV9S19718C129S19718C17__A1__8S19718C3[4]),  4,4},
  {&(_tg__ZTV9S19718C139S19718C129S19718C17__A1__8S19718C3[4]),  4,4},
  {&(_tg__ZTV9S19718C21__8S19718C3[4]),  4,6},
  {&(_tg__ZTV9S19718C229S19718C21__8S19718C3[3]),  3,3},
  {&(_tg__ZTV9S19718C13__A2__8S19718C3[4]),  4,4},
};
extern VTBL_ENTRY _ZTI8S19718C3[];
extern  VTBL_ENTRY _ZTV8S19718C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19718C3[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19718C15D0Ev,_ZTv0_n20_N9S19718C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S19718C15D0Ev,_ZThn48_N9S19718C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19718C15D1Ev,_ZTv0_n20_N9S19718C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S19718C15D1Ev,_ZThn48_N9S19718C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19718C11D0Ev,_ZTv0_n20_N9S19718C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn256_N9S19718C11D0Ev,_ZThn156_N9S19718C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19718C11D1Ev,_ZTv0_n20_N9S19718C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn256_N9S19718C11D1Ev,_ZThn156_N9S19718C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19718C11D0Ev,_ZTv0_n28_N9S19718C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N9S19718C11D0Ev,_ZThn108_N9S19718C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19718C11D1Ev,_ZTv0_n28_N9S19718C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N9S19718C11D1Ev,_ZThn108_N9S19718C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19718C14D0Ev,_ZTv0_n20_N9S19718C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn208_N9S19718C14D0Ev,_ZThn124_N9S19718C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19718C14D1Ev,_ZTv0_n20_N9S19718C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn208_N9S19718C14D1Ev,_ZThn124_N9S19718C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19718C14D0Ev,_ZTv0_n28_N9S19718C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn128_N9S19718C14D0Ev,_ZThn76_N9S19718C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19718C14D1Ev,_ZTv0_n28_N9S19718C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn128_N9S19718C14D1Ev,_ZThn76_N9S19718C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19718C3D0Ev,_ZTv0_n20_N8S19718C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn368_N8S19718C3D0Ev,_ZThn228_N8S19718C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn320_N8S19718C3D0Ev,_ZThn196_N8S19718C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19718C3D1Ev,_ZTv0_n20_N8S19718C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn368_N8S19718C3D1Ev,_ZThn228_N8S19718C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn320_N8S19718C3D1Ev,_ZThn196_N8S19718C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S19718C3D0Ev,_ZTv0_n28_N8S19718C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn240_N8S19718C3D0Ev,_ZThn148_N8S19718C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S19718C3D1Ev,_ZTv0_n28_N8S19718C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn240_N8S19718C3D1Ev,_ZThn148_N8S19718C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S19718C3D0Ev,_ZTv0_n36_N8S19718C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N8S19718C3D0Ev,_ZThn40_N8S19718C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S19718C3D1Ev,_ZTv0_n36_N8S19718C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N8S19718C3D1Ev,_ZThn40_N8S19718C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19718C3D0Ev,_ZTv0_n12_N8S19718C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S19718C3D0Ev,_ZThn12_N8S19718C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19718C3D1Ev,_ZTv0_n12_N8S19718C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S19718C3D1Ev,_ZThn12_N8S19718C3D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19718C3 = {  "S19718C3", // class name
  bases_S19718C3, 37,
  &(vtc_S19718C3[0]), // expected_vtbl_contents
  &(vtt_S19718C3[0]), // expected_vtt_contents
  ABISELECT(432,260), // object size
  NSPAIRA(_ZTI8S19718C3),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S19718C3),73, //virtual function table var
  14, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19718C3),28, //virtual table table var
  14, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19718C23  : virtual S19718C15 {
  void *s19718c23f0;
  virtual  ~S19718C23(); // _ZN9S19718C23D2Ev
  S19718C23(); // tgen
};
//SIG(-1 S19718C23) C1{ VBC2{ BC3{ m FD} VBC4{ m Fc} VBC5{ BC6{ BC7{ VBC8{ m Fi} VBC3 Fi} FC7} vd} BC9{ BC3 BC8 FC8} BC10{ m Fi} vd Fi} vd Fp}


 S19718C23 ::~S19718C23(){ note_dtor("S19718C23", this);}
S19718C23 ::S19718C23(){ note_ctor("S19718C23", this);} // tgen

static void Test_S19718C23()
{
  extern Class_Descriptor cd_S19718C23;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(12,27)];
    init_test(&cd_S19718C23, buf);
    S19718C23 *dp, &lv = *(dp=new (buf) S19718C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(176,104), "sizeof(S19718C23)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19718C23)");
    /*is_ambiguous_... S19718C15::S19718C8_nt */ AMB_check_base_class_offset(lv, (S19718C8_nt*)(S19718C15*), ABISELECT(32,12), "S19718C23");
    check_base_class_offset(lv, (S19718C16_nt*)(S19718C15*), ABISELECT(80,52), "S19718C23");
    check_base_class_offset(lv, (S19718C9_nt*)(S19718C13*)(S19718C12*)(S19718C17*), ABISELECT(144,88), "S19718C23");
    check_base_class_offset(lv, (S19718C8_nt*)(S19718C13*)(S19718C12*)(S19718C17*), ABISELECT(160,92), "S19718C23");
    check_base_class_offset(lv, (S19718C13*)(S19718C12*)(S19718C17*), ABISELECT(96,56), "S19718C23");
    check_base_class_offset(lv, (S19718C12*)(S19718C17*), ABISELECT(96,56), "S19718C23");
    check_base_class_offset(lv, (S19718C17*)(S19718C15*), ABISELECT(96,56), "S19718C23");
    check_base_class_offset(lv, (S19718C8_nt*)(S19718C7*)(S19718C15*), ABISELECT(48,24), "S19718C23");
    check_base_class_offset(lv, (S19718C9_nt*)(S19718C7*)(S19718C15*), ABISELECT(64,36), "S19718C23");
    check_base_class_offset(lv, (S19718C7*)(S19718C15*), ABISELECT(48,24), "S19718C23");
    check_base_class_offset(lv, (S19718C18*)(S19718C15*), ABISELECT(72,44), "S19718C23");
    check_base_class_offset(lv, (S19718C15*), ABISELECT(16,8), "S19718C23");
    check_field_offset(lv, s19718c23f0, ABISELECT(8,4), "S19718C23.s19718c23f0");
    test_class_info(&lv, &cd_S19718C23);
    dp->~S19718C23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19718C23(Test_S19718C23, "S19718C23", ABISELECT(176,104));

#else // __cplusplus

extern void _ZN9S19718C23C1Ev();
extern void _ZN9S19718C23D2Ev();
Name_Map name_map_S19718C23[] = {
  NSPAIR(_ZN9S19718C23C1Ev),
  NSPAIR(_ZN9S19718C23D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
extern Class_Descriptor cd_S19718C16_nt;
extern VTBL_ENTRY _ZTI12S19718C16_nt[];
extern Class_Descriptor cd_S19718C9_nt;
extern VTBL_ENTRY _ZTI11S19718C9_nt[];
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
extern Class_Descriptor cd_S19718C13;
extern VTBL_ENTRY _ZTI9S19718C13[];
extern  VTBL_ENTRY _ZTV9S19718C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C13[];
extern Class_Descriptor cd_S19718C12;
extern VTBL_ENTRY _ZTI9S19718C12[];
extern  VTBL_ENTRY _ZTV9S19718C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C12[];
extern Class_Descriptor cd_S19718C17;
extern VTBL_ENTRY _ZTI9S19718C17[];
extern  VTBL_ENTRY _ZTV9S19718C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C17[];
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
extern Class_Descriptor cd_S19718C9_nt;
extern VTBL_ENTRY _ZTI11S19718C9_nt[];
extern Class_Descriptor cd_S19718C7;
extern VTBL_ENTRY _ZTI8S19718C7[];
extern Class_Descriptor cd_S19718C18;
extern VTBL_ENTRY _ZTI9S19718C18[];
extern Class_Descriptor cd_S19718C15;
extern VTBL_ENTRY _ZTI9S19718C15[];
extern  VTBL_ENTRY _ZTV9S19718C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C15[];
static Base_Class bases_S19718C23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19718C8_nt,    ABISELECT(32,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19718C16_nt,    ABISELECT(80,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S19718C9_nt,    ABISELECT(144,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S19718C8_nt,    ABISELECT(160,92), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S19718C13,    ABISELECT(96,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19718C12,    ABISELECT(96,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19718C17,    ABISELECT(96,56), //bcp->offset
    18, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S19718C8_nt,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19718C9_nt,    ABISELECT(64,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19718C7,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19718C18,    ABISELECT(72,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19718C15,    ABISELECT(16,8), //bcp->offset
    9, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19718C23[];
extern void _ZN9S19718C23D1Ev();
extern void _ZN9S19718C23D0Ev();
extern void ABISELECT(_ZTv0_n56_N9S19718C23D1Ev,_ZTv0_n28_N9S19718C23D1Ev)();
extern void ABISELECT(_ZThn16_N9S19718C23D1Ev,_ZThn8_N9S19718C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S19718C23D0Ev,_ZTv0_n28_N9S19718C23D0Ev)();
extern void ABISELECT(_ZThn16_N9S19718C23D0Ev,_ZThn8_N9S19718C23D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19718C23D1Ev,_ZTv0_n20_N9S19718C23D1Ev)();
extern void ABISELECT(_ZThn96_N9S19718C23D1Ev,_ZThn56_N9S19718C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19718C23D0Ev,_ZTv0_n20_N9S19718C23D0Ev)();
extern void ABISELECT(_ZThn96_N9S19718C23D0Ev,_ZThn56_N9S19718C23D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19718C23[] = {
  ABISELECT(160,92),
  ABISELECT(144,88),
  ABISELECT(96,56),
  ABISELECT(80,52),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C23[0]),
  (VTBL_ENTRY)&_ZN9S19718C23D1Ev,
  (VTBL_ENTRY)&_ZN9S19718C23D0Ev,
  ABISELECT(-16,-8),
  ABISELECT(144,84),
  ABISELECT(128,80),
  ABISELECT(80,48),
  ABISELECT(64,44),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S19718C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19718C23D1Ev,_ZTv0_n28_N9S19718C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19718C23D0Ev,_ZTv0_n28_N9S19718C23D0Ev),
  ABISELECT(-96,-56),
  ABISELECT(64,36),
  ABISELECT(48,32),
  ABISELECT(-96,-56),
  (VTBL_ENTRY)&(_ZTI9S19718C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19718C23D1Ev,_ZTv0_n20_N9S19718C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19718C23D0Ev,_ZTv0_n20_N9S19718C23D0Ev),
};
extern VTBL_ENTRY _ZTV9S19718C23[];
extern void _ZN9S19718C15D1Ev();
extern void _ZN9S19718C15D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19718C15__9S19718C23[] = {
  ABISELECT(144,84),
  ABISELECT(128,80),
  ABISELECT(80,48),
  ABISELECT(64,44),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C15[0]),
  (VTBL_ENTRY)&_ZN9S19718C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19718C15D0Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19718C15D1Ev,_ZTv0_n20_N9S19718C15D1Ev)();
extern void ABISELECT(_ZThn80_N9S19718C15D1Ev,_ZThn48_N9S19718C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19718C15D0Ev,_ZTv0_n20_N9S19718C15D0Ev)();
extern void ABISELECT(_ZThn80_N9S19718C15D0Ev,_ZThn48_N9S19718C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19718C17__9S19718C15__9S19718C23[] = {
  ABISELECT(-80,-48),
  ABISELECT(64,36),
  ABISELECT(48,32),
  ABISELECT(-80,-48),
  (VTBL_ENTRY)&(_ZTI9S19718C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19718C15D1Ev,_ZTv0_n20_N9S19718C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19718C15D0Ev,_ZTv0_n20_N9S19718C15D0Ev),
};
extern void _ZN9S19718C17D1Ev();
extern void _ZN9S19718C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19718C17__9S19718C23[] = {
  ABISELECT(64,36),
  ABISELECT(48,32),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C17[0]),
  (VTBL_ENTRY)&_ZN9S19718C17D1Ev,
  (VTBL_ENTRY)&_ZN9S19718C17D0Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19718C129S19718C17__9S19718C23[] = {
  ABISELECT(64,36),
  ABISELECT(48,32),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C12[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19718C139S19718C129S19718C17__9S19718C23[] = {
  ABISELECT(64,36),
  ABISELECT(48,32),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C13[0]),
};
static  VTT_ENTRY vtt_S19718C23[] = {
  {&(_ZTV9S19718C23[7]),  7,25},
  {&(_ZTV9S19718C23[16]),  16,25},
  {&(_ZTV9S19718C23[23]),  23,25},
  {&(_tg__ZTV9S19718C15__9S19718C23[6]),  6,8},
  {&(_tg__ZTV9S19718C17__9S19718C15__9S19718C23[5]),  5,7},
  {&(_tg__ZTV9S19718C17__9S19718C23[4]),  4,6},
  {&(_tg__ZTV9S19718C129S19718C17__9S19718C23[4]),  4,4},
  {&(_tg__ZTV9S19718C139S19718C129S19718C17__9S19718C23[4]),  4,4},
};
extern VTBL_ENTRY _ZTI9S19718C23[];
extern  VTBL_ENTRY _ZTV9S19718C23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C23[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19718C15D0Ev,_ZTv0_n20_N9S19718C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S19718C15D0Ev,_ZThn48_N9S19718C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19718C15D1Ev,_ZTv0_n20_N9S19718C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S19718C15D1Ev,_ZThn48_N9S19718C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19718C23D0Ev,_ZTv0_n20_N9S19718C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N9S19718C23D0Ev,_ZThn56_N9S19718C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19718C23D1Ev,_ZTv0_n20_N9S19718C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N9S19718C23D1Ev,_ZThn56_N9S19718C23D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19718C23D0Ev,_ZTv0_n28_N9S19718C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19718C23D0Ev,_ZThn8_N9S19718C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19718C23D1Ev,_ZTv0_n28_N9S19718C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19718C23D1Ev,_ZThn8_N9S19718C23D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19718C23 = {  "S19718C23", // class name
  bases_S19718C23, 12,
  &(vtc_S19718C23[0]), // expected_vtbl_contents
  &(vtt_S19718C23[0]), // expected_vtt_contents
  ABISELECT(176,104), // object size
  NSPAIRA(_ZTI9S19718C23),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV9S19718C23),25, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19718C23),8, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19718C1  : virtual S3443C8_nt , S19718C3 , S19718C18 , S19718C23 {
  virtual  ~S19718C1(); // _ZN8S19718C1D2Ev
  S19718C1(); // tgen
};
//SIG(1 S19718C1) C1{ VBC2{ m Fi} BC3{ BC4{ BC2 BC5{ m} vd} VBC6{ BC7{ BC8{ m FD} BC9{ m Fi} FC9} BC2 BC10{ m} vd} VBC11{ BC12{ BC13{ VBC9 VBC8 Fi} FC13} VBC2 BC14{ VBC15{ BC8 VBC16{ m Fc} VBC17{ BC12 vd} BC7 BC18{ m Fi} vd Fi} BC9 vd} BC19{ VBC9 BC8 vd} BC20{ m FC13} Fi[2]} VBC21{ BC22{ VBC7} VBC10 vd} VBC13 vd Fi} BC18 BC23{ VBC15 vd Fp} vd}


 S19718C1 ::~S19718C1(){ note_dtor("S19718C1", this);}
S19718C1 ::S19718C1(){ note_ctor("S19718C1", this);} // tgen

static void Test_S19718C1()
{
  extern Class_Descriptor cd_S19718C1;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(29,69)];
    init_test(&cd_S19718C1, buf);
    S19718C1 *dp, &lv = *(dp=new (buf) S19718C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(448,272), "sizeof(S19718C1)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19718C1)");
    /*is_ambiguous_... S19718C1::S3443C8_nt */ AMB_check_base_class_offset(lv, (S3443C8_nt*), ABISELECT(40,24), "S19718C1");
    check_base_class_offset(lv, (S3443C8_nt*)(S19718C11*), ABISELECT(40,24), "S19718C1");
    check_base_class_offset(lv, (S3443C8_nt*)(S19718C4*)(S19718C3*), ABISELECT(8,4), "S19718C1");
    check_base_class_offset(lv, (S2122C38*)(S19718C4*)(S19718C3*), 0, "S19718C1");
    check_base_class_offset(lv, (S19718C4*)(S19718C3*), 0, "S19718C1");
    check_base_class_offset(lv, (S19718C8_nt*)(S19718C7*)(S19718C6*), ABISELECT(64,32), "S19718C1");
    check_base_class_offset(lv, (S19718C9_nt*)(S19718C7*)(S19718C6*), ABISELECT(80,44), "S19718C1");
    check_base_class_offset(lv, (S19718C7*)(S19718C6*), ABISELECT(64,32), "S19718C1");
    check_base_class_offset(lv, (S3443C8_nt*)(S19718C6*), ABISELECT(88,52), "S19718C1");
    check_base_class_offset(lv, (S2122C28*)(S19718C6*), ABISELECT(48,28), "S19718C1");
    check_base_class_offset(lv, (S19718C6*)(S19718C3*), ABISELECT(48,28), "S19718C1");
    /*is_ambiguous_... S19718C11::S19718C12 */ AMB_check_base_class_offset(lv, (S19718C9_nt*)(S19718C13*)(S19718C12*)(S19718C11*), ABISELECT(232,144), "S19718C1");
    check_base_class_offset(lv, (S19718C9_nt*)(S19718C13*)(S19718C12*)(S19718C17*), ABISELECT(232,144), "S19718C1");
    check_base_class_offset(lv, (S19718C9_nt*)(S19718C19*)(S19718C11*), ABISELECT(232,144), "S19718C1");
    /*is_ambiguous_... S19718C1::S19718C13 */ AMB_check_base_class_offset(lv, (S19718C9_nt*)(S19718C13*), ABISELECT(232,144), "S19718C1");
    /*is_ambiguous_... S19718C11::S19718C12 */ AMB_check_base_class_offset(lv, (S19718C8_nt*)(S19718C13*)(S19718C12*)(S19718C11*), ABISELECT(240,148), "S19718C1");
    check_base_class_offset(lv, (S19718C8_nt*)(S19718C13*)(S19718C12*)(S19718C17*), ABISELECT(240,148), "S19718C1");
    /*is_ambiguous_... S19718C1::S19718C13 */ AMB_check_base_class_offset(lv, (S19718C8_nt*)(S19718C13*), ABISELECT(240,148), "S19718C1");
    /*is_ambiguous_... S19718C11::S19718C12 */ AMB_check_base_class_offset(lv, (S19718C13*)(S19718C12*)(S19718C11*), ABISELECT(96,56), "S19718C1");
    /*is_ambiguous_... S19718C11::S19718C12 */ AMB_check_base_class_offset(lv, (S19718C12*)(S19718C11*), ABISELECT(96,56), "S19718C1");
    /*is_ambiguous_... S19718C15::S19718C8_nt */ AMB_check_base_class_offset(lv, (S19718C8_nt*)(S19718C15*), ABISELECT(272,164), "S19718C1");
    check_base_class_offset(lv, (S19718C16_nt*)(S19718C15*), ABISELECT(320,204), "S19718C1");
    check_base_class_offset(lv, (S19718C13*)(S19718C12*)(S19718C17*), ABISELECT(336,208), "S19718C1");
    check_base_class_offset(lv, (S19718C12*)(S19718C17*), ABISELECT(336,208), "S19718C1");
    check_base_class_offset(lv, (S19718C17*)(S19718C15*), ABISELECT(336,208), "S19718C1");
    check_base_class_offset(lv, (S19718C8_nt*)(S19718C7*)(S19718C15*), ABISELECT(288,176), "S19718C1");
    check_base_class_offset(lv, (S19718C9_nt*)(S19718C7*)(S19718C15*), ABISELECT(304,188), "S19718C1");
    check_base_class_offset(lv, (S19718C7*)(S19718C15*), ABISELECT(288,176), "S19718C1");
    check_base_class_offset(lv, (S19718C18*)(S19718C15*), ABISELECT(312,196), "S19718C1");
    check_base_class_offset(lv, (S19718C15*)(S19718C14*)(S19718C11*), ABISELECT(256,160), "S19718C1");
    check_base_class_offset(lv, (S19718C15*)(S19718C23*), ABISELECT(256,160), "S19718C1");
    /*is_ambiguous_... S19718C14::S19718C9_nt */ AMB_check_base_class_offset(lv, (S19718C9_nt*)(S19718C14*)(S19718C11*), ABISELECT(152,92), "S19718C1");
    check_base_class_offset(lv, (S19718C14*)(S19718C11*), ABISELECT(144,88), "S19718C1");
    check_base_class_offset(lv, (S19718C8_nt*)(S19718C19*)(S19718C11*), ABISELECT(176,100), "S19718C1");
    check_base_class_offset(lv, (S19718C19*)(S19718C11*), ABISELECT(160,96), "S19718C1");
    check_base_class_offset(lv, (S19718C20*)(S19718C11*), ABISELECT(192,112), "S19718C1");
    check_base_class_offset(lv, (S19718C11*)(S19718C3*), ABISELECT(96,56), "S19718C1");
    /*is_ambiguous_... S19718C1::S19718C7 */ AMB_check_base_class_offset(lv, (S19718C8_nt*)(S19718C7*), ABISELECT(400,244), "S19718C1");
    /*is_ambiguous_... S19718C1::S19718C7 */ AMB_check_base_class_offset(lv, (S19718C9_nt*)(S19718C7*), ABISELECT(416,256), "S19718C1");
    check_base_class_offset(lv, (S19718C7*)(S19718C22*)(S19718C21*), ABISELECT(400,244), "S19718C1");
    check_base_class_offset(lv, (S19718C22*)(S19718C21*), ABISELECT(384,240), "S19718C1");
    check_base_class_offset(lv, (S2122C28*)(S19718C21*), 0, "S19718C1");
    check_base_class_offset(lv, (S19718C21*)(S19718C3*), ABISELECT(384,240), "S19718C1");
    /*is_ambiguous_... S19718C3::S19718C13 */ AMB_check_base_class_offset(lv, (S19718C13*)(S19718C3*), ABISELECT(424,264), "S19718C1");
    check_base_class_offset(lv, (S19718C3*), 0, "S19718C1");
    /*is_ambiguous_... S19718C1::S19718C18 */ AMB_check_base_class_offset(lv, (S19718C18*), ABISELECT(16,12), "S19718C1");
    check_base_class_offset(lv, (S19718C23*), ABISELECT(24,16), "S19718C1");
    test_class_info(&lv, &cd_S19718C1);
    dp->~S19718C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19718C1(Test_S19718C1, "S19718C1", ABISELECT(448,272));

#else // __cplusplus

extern void _ZN8S19718C1C1Ev();
extern void _ZN8S19718C1D2Ev();
Name_Map name_map_S19718C1[] = {
  NSPAIR(_ZN8S19718C1C1Ev),
  NSPAIR(_ZN8S19718C1D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S3443C8_nt;
extern VTBL_ENTRY _ZTI10S3443C8_nt[];
extern Class_Descriptor cd_S3443C8_nt;
extern VTBL_ENTRY _ZTI10S3443C8_nt[];
extern Class_Descriptor cd_S2122C38;
extern VTBL_ENTRY _ZTI8S2122C38[];
extern Class_Descriptor cd_S19718C4;
extern VTBL_ENTRY _ZTI8S19718C4[];
extern  VTBL_ENTRY _ZTV8S19718C4[];
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
extern Class_Descriptor cd_S19718C9_nt;
extern VTBL_ENTRY _ZTI11S19718C9_nt[];
extern Class_Descriptor cd_S19718C7;
extern VTBL_ENTRY _ZTI8S19718C7[];
extern Class_Descriptor cd_S3443C8_nt;
extern VTBL_ENTRY _ZTI10S3443C8_nt[];
extern Class_Descriptor cd_S2122C28;
extern VTBL_ENTRY _ZTI8S2122C28[];
extern Class_Descriptor cd_S19718C6;
extern VTBL_ENTRY _ZTI8S19718C6[];
extern  VTBL_ENTRY _ZTV8S19718C6[];
extern Class_Descriptor cd_S19718C9_nt;
extern VTBL_ENTRY _ZTI11S19718C9_nt[];
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
extern Class_Descriptor cd_S19718C13;
extern VTBL_ENTRY _ZTI9S19718C13[];
extern  VTBL_ENTRY _ZTV9S19718C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C13[];
extern Class_Descriptor cd_S19718C12;
extern VTBL_ENTRY _ZTI9S19718C12[];
extern  VTBL_ENTRY _ZTV9S19718C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C12[];
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
extern Class_Descriptor cd_S19718C16_nt;
extern VTBL_ENTRY _ZTI12S19718C16_nt[];
extern Class_Descriptor cd_S19718C13;
extern VTBL_ENTRY _ZTI9S19718C13[];
extern  VTBL_ENTRY _ZTV9S19718C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C13[];
extern Class_Descriptor cd_S19718C12;
extern VTBL_ENTRY _ZTI9S19718C12[];
extern  VTBL_ENTRY _ZTV9S19718C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C12[];
extern Class_Descriptor cd_S19718C17;
extern VTBL_ENTRY _ZTI9S19718C17[];
extern  VTBL_ENTRY _ZTV9S19718C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C17[];
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
extern Class_Descriptor cd_S19718C9_nt;
extern VTBL_ENTRY _ZTI11S19718C9_nt[];
extern Class_Descriptor cd_S19718C7;
extern VTBL_ENTRY _ZTI8S19718C7[];
extern Class_Descriptor cd_S19718C18;
extern VTBL_ENTRY _ZTI9S19718C18[];
extern Class_Descriptor cd_S19718C15;
extern VTBL_ENTRY _ZTI9S19718C15[];
extern  VTBL_ENTRY _ZTV9S19718C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C15[];
extern Class_Descriptor cd_S19718C9_nt;
extern VTBL_ENTRY _ZTI11S19718C9_nt[];
extern Class_Descriptor cd_S19718C14;
extern VTBL_ENTRY _ZTI9S19718C14[];
extern  VTBL_ENTRY _ZTV9S19718C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C14[];
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
extern Class_Descriptor cd_S19718C19;
extern VTBL_ENTRY _ZTI9S19718C19[];
extern  VTBL_ENTRY _ZTV9S19718C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C19[];
extern Class_Descriptor cd_S19718C20;
extern VTBL_ENTRY _ZTI9S19718C20[];
extern Class_Descriptor cd_S19718C11;
extern VTBL_ENTRY _ZTI9S19718C11[];
extern  VTBL_ENTRY _ZTV9S19718C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C11[];
extern Class_Descriptor cd_S19718C8_nt;
extern VTBL_ENTRY _ZTI11S19718C8_nt[];
extern Class_Descriptor cd_S19718C9_nt;
extern VTBL_ENTRY _ZTI11S19718C9_nt[];
extern Class_Descriptor cd_S19718C7;
extern VTBL_ENTRY _ZTI8S19718C7[];
extern Class_Descriptor cd_S19718C22;
extern VTBL_ENTRY _ZTI9S19718C22[];
extern  VTBL_ENTRY _ZTV9S19718C22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C22[];
extern Class_Descriptor cd_S2122C28;
extern VTBL_ENTRY _ZTI8S2122C28[];
extern Class_Descriptor cd_S19718C21;
extern VTBL_ENTRY _ZTI9S19718C21[];
extern  VTBL_ENTRY _ZTV9S19718C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C21[];
extern Class_Descriptor cd_S19718C13;
extern VTBL_ENTRY _ZTI9S19718C13[];
extern  VTBL_ENTRY _ZTV9S19718C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C13[];
extern Class_Descriptor cd_S19718C3;
extern VTBL_ENTRY _ZTI8S19718C3[];
extern  VTBL_ENTRY _ZTV8S19718C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19718C3[];
extern Class_Descriptor cd_S19718C18;
extern VTBL_ENTRY _ZTI9S19718C18[];
extern Class_Descriptor cd_S19718C23;
extern VTBL_ENTRY _ZTI9S19718C23[];
extern  VTBL_ENTRY _ZTV9S19718C23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19718C23[];
static Base_Class bases_S19718C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3443C8_nt,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3443C8_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2122C38,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19718C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S19718C8_nt,    ABISELECT(64,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19718C9_nt,    ABISELECT(80,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19718C7,    ABISELECT(64,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S3443C8_nt,    ABISELECT(88,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S2122C28,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19718C6,    ABISELECT(48,28), //bcp->offset
    25, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    37, //immediately_derived
  0, 1},
  {&cd_S19718C9_nt,    ABISELECT(232,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S19718C8_nt,    ABISELECT(240,148), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S19718C13,    ABISELECT(96,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19718C12,    ABISELECT(96,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19718C8_nt,    ABISELECT(272,164), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S19718C16_nt,    ABISELECT(320,204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 1},
  {&cd_S19718C13,    ABISELECT(336,208), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    38, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19718C12,    ABISELECT(336,208), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    37, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S19718C17,    ABISELECT(336,208), //bcp->offset
    64, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    36, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    23, //immediately_derived
  0, 1},
  {&cd_S19718C8_nt,    ABISELECT(288,176), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19718C9_nt,    ABISELECT(304,188), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19718C7,    ABISELECT(288,176), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S19718C18,    ABISELECT(312,196), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S19718C15,    ABISELECT(256,160), //bcp->offset
    55, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    25, //immediately_derived
  0, 1},
  {&cd_S19718C9_nt,    ABISELECT(152,92), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S19718C14,    ABISELECT(144,88), //bcp->offset
    41, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19718C8_nt,    ABISELECT(176,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S19718C19,    ABISELECT(160,96), //bcp->offset
    50, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    29, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19718C20,    ABISELECT(192,112), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19718C11,    ABISELECT(96,56), //bcp->offset
    30, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    37, //immediately_derived
  0, 1},
  {&cd_S19718C8_nt,    ABISELECT(400,244), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S19718C9_nt,    ABISELECT(416,256), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S19718C7,    ABISELECT(400,244), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    33, //immediately_derived
  0, 1},
  {&cd_S19718C22,    ABISELECT(384,240), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    40, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S2122C28,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    35, //immediately_derived
  0, 1},
  {&cd_S19718C21,    ABISELECT(384,240), //bcp->offset
    71, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    39, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    37, //immediately_derived
  0, 1},
  {&cd_S19718C13,    ABISELECT(424,264), //bcp->offset
    78, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    41, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    37, //immediately_derived
  0, 1},
  {&cd_S19718C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    14, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19718C18,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19718C23,    ABISELECT(24,16), //bcp->offset
    16, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19718C1[];
extern void _ZN8S19718C1D1Ev();
extern void _ZN8S19718C1D0Ev();
extern void ABISELECT(_ZThn24_N8S19718C1D1Ev,_ZThn16_N8S19718C1D1Ev)();
extern void ABISELECT(_ZThn24_N8S19718C1D0Ev,_ZThn16_N8S19718C1D0Ev)();
extern void ABISELECT(_ZTv0_n24_N8S19718C1D1Ev,_ZTv0_n12_N8S19718C1D1Ev)();
extern void ABISELECT(_ZThn48_N8S19718C1D1Ev,_ZThn28_N8S19718C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19718C1D0Ev,_ZTv0_n12_N8S19718C1D0Ev)();
extern void ABISELECT(_ZThn48_N8S19718C1D0Ev,_ZThn28_N8S19718C1D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S19718C1D1Ev,_ZTv0_n36_N8S19718C1D1Ev)();
extern void ABISELECT(_ZThn96_N8S19718C1D1Ev,_ZThn56_N8S19718C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S19718C1D0Ev,_ZTv0_n36_N8S19718C1D0Ev)();
extern void ABISELECT(_ZThn96_N8S19718C1D0Ev,_ZThn56_N8S19718C1D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn48_n72_N8S19718C1D1Ev,_ZTvn32_n36_N8S19718C1D1Ev)();
extern void ABISELECT(_ZTvn48_n72_N8S19718C1D0Ev,_ZTvn32_n36_N8S19718C1D0Ev)();
extern void ABISELECT(_ZTvn64_n72_N8S19718C1D1Ev,_ZTvn40_n36_N8S19718C1D1Ev)();
extern void ABISELECT(_ZTvn64_n72_N8S19718C1D0Ev,_ZTvn40_n36_N8S19718C1D0Ev)();
extern void ABISELECT(_ZTv0_n56_N8S19718C1D1Ev,_ZTv0_n28_N8S19718C1D1Ev)();
extern void ABISELECT(_ZThn256_N8S19718C1D1Ev,_ZThn160_N8S19718C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S19718C1D0Ev,_ZTv0_n28_N8S19718C1D0Ev)();
extern void ABISELECT(_ZThn256_N8S19718C1D0Ev,_ZThn160_N8S19718C1D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19718C1D1Ev,_ZTv0_n20_N8S19718C1D1Ev)();
extern void ABISELECT(_ZThn336_N8S19718C1D1Ev,_ZThn208_N8S19718C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19718C1D0Ev,_ZTv0_n20_N8S19718C1D0Ev)();
extern void ABISELECT(_ZThn336_N8S19718C1D0Ev,_ZThn208_N8S19718C1D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19718C1D1Ev,_ZTv0_n20_N8S19718C1D1Ev)();
extern void ABISELECT(_ZThn384_N8S19718C1D1Ev,_ZThn240_N8S19718C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19718C1D0Ev,_ZTv0_n20_N8S19718C1D0Ev)();
extern void ABISELECT(_ZThn384_N8S19718C1D0Ev,_ZThn240_N8S19718C1D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19718C1[] = {
  ABISELECT(424,264),
  0,
  ABISELECT(400,244),
  ABISELECT(384,240),
  ABISELECT(336,208),
  ABISELECT(320,204),
  ABISELECT(256,160),
  ABISELECT(40,24),
  ABISELECT(240,148),
  ABISELECT(232,144),
  ABISELECT(96,56),
  ABISELECT(48,28),
  0,
  (VTBL_ENTRY)&(_ZTI8S19718C1[0]),
  (VTBL_ENTRY)&_ZN8S19718C1D1Ev,
  (VTBL_ENTRY)&_ZN8S19718C1D0Ev,
  ABISELECT(216,132),
  ABISELECT(208,128),
  ABISELECT(312,192),
  ABISELECT(296,188),
  ABISELECT(232,144),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI8S19718C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N8S19718C1D1Ev,_ZThn16_N8S19718C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N8S19718C1D0Ev,_ZThn16_N8S19718C1D0Ev),
  ABISELECT(-48,-28),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI8S19718C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19718C1D1Ev,_ZTv0_n12_N8S19718C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19718C1D0Ev,_ZTv0_n12_N8S19718C1D0Ev),
  ABISELECT(-96,-56),
  ABISELECT(240,152),
  ABISELECT(224,148),
  ABISELECT(160,104),
  ABISELECT(-56,-32),
  ABISELECT(144,92),
  ABISELECT(136,88),
  ABISELECT(-96,-56),
  (VTBL_ENTRY)&(_ZTI8S19718C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S19718C1D1Ev,_ZTv0_n36_N8S19718C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S19718C1D0Ev,_ZTv0_n36_N8S19718C1D0Ev),
  ABISELECT(96,60),
  ABISELECT(88,56),
  ABISELECT(192,120),
  ABISELECT(176,116),
  ABISELECT(112,72),
  ABISELECT(-144,-88),
  (VTBL_ENTRY)&(_ZTI8S19718C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn48_n72_N8S19718C1D1Ev,_ZTvn32_n36_N8S19718C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn48_n72_N8S19718C1D0Ev,_ZTvn32_n36_N8S19718C1D0Ev),
  ABISELECT(72,48),
  ABISELECT(-160,-96),
  (VTBL_ENTRY)&(_ZTI8S19718C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn64_n72_N8S19718C1D1Ev,_ZTvn40_n36_N8S19718C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn64_n72_N8S19718C1D0Ev,_ZTvn40_n36_N8S19718C1D0Ev),
  ABISELECT(-256,-160),
  ABISELECT(-16,-12),
  ABISELECT(-24,-16),
  ABISELECT(80,48),
  ABISELECT(64,44),
  ABISELECT(-256,-160),
  (VTBL_ENTRY)&(_ZTI8S19718C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S19718C1D1Ev,_ZTv0_n28_N8S19718C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S19718C1D0Ev,_ZTv0_n28_N8S19718C1D0Ev),
  ABISELECT(-336,-208),
  ABISELECT(-96,-60),
  ABISELECT(-104,-64),
  ABISELECT(-336,-208),
  (VTBL_ENTRY)&(_ZTI8S19718C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19718C1D1Ev,_ZTv0_n20_N8S19718C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19718C1D0Ev,_ZTv0_n20_N8S19718C1D0Ev),
  ABISELECT(-384,-240),
  ABISELECT(-384,-240),
  ABISELECT(16,4),
  ABISELECT(-384,-240),
  (VTBL_ENTRY)&(_ZTI8S19718C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19718C1D1Ev,_ZTv0_n20_N8S19718C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19718C1D0Ev,_ZTv0_n20_N8S19718C1D0Ev),
  ABISELECT(-184,-116),
  ABISELECT(-192,-120),
  ABISELECT(-424,-264),
  (VTBL_ENTRY)&(_ZTI8S19718C1[0]),
};
extern VTBL_ENTRY _ZTV8S19718C1[];
extern void _ZN8S19718C3D1Ev();
extern void _ZN8S19718C3D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19718C3__8S19718C1[] = {
  ABISELECT(424,264),
  0,
  ABISELECT(400,244),
  ABISELECT(384,240),
  ABISELECT(336,208),
  ABISELECT(320,204),
  ABISELECT(256,160),
  ABISELECT(40,24),
  ABISELECT(240,148),
  ABISELECT(232,144),
  ABISELECT(96,56),
  ABISELECT(48,28),
  0,
  (VTBL_ENTRY)&(_ZTI8S19718C3[0]),
  (VTBL_ENTRY)&_ZN8S19718C3D1Ev,
  (VTBL_ENTRY)&_ZN8S19718C3D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19718C3D1Ev,_ZTv0_n12_N8S19718C3D1Ev)();
extern void ABISELECT(_ZThn48_N8S19718C3D1Ev,_ZThn28_N8S19718C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19718C3D0Ev,_ZTv0_n12_N8S19718C3D0Ev)();
extern void ABISELECT(_ZThn48_N8S19718C3D0Ev,_ZThn28_N8S19718C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19718C6__8S19718C3__8S19718C1[] = {
  ABISELECT(-48,-28),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI8S19718C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19718C3D1Ev,_ZTv0_n12_N8S19718C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19718C3D0Ev,_ZTv0_n12_N8S19718C3D0Ev),
};
extern void ABISELECT(_ZTv0_n72_N8S19718C3D1Ev,_ZTv0_n36_N8S19718C3D1Ev)();
extern void ABISELECT(_ZThn96_N8S19718C3D1Ev,_ZThn56_N8S19718C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S19718C3D0Ev,_ZTv0_n36_N8S19718C3D0Ev)();
extern void ABISELECT(_ZThn96_N8S19718C3D0Ev,_ZThn56_N8S19718C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19718C11__8S19718C3__8S19718C1[] = {
  ABISELECT(-96,-56),
  ABISELECT(240,152),
  ABISELECT(224,148),
  ABISELECT(160,104),
  ABISELECT(-56,-32),
  ABISELECT(144,92),
  ABISELECT(136,88),
  ABISELECT(-96,-56),
  (VTBL_ENTRY)&(_ZTI8S19718C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S19718C3D1Ev,_ZTv0_n36_N8S19718C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S19718C3D0Ev,_ZTv0_n36_N8S19718C3D0Ev),
};
extern void ABISELECT(_ZTvn48_n72_N8S19718C3D1Ev,_ZTvn32_n36_N8S19718C3D1Ev)();
extern void ABISELECT(_ZTvn48_n72_N8S19718C3D0Ev,_ZTvn32_n36_N8S19718C3D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19718C149S19718C11__8S19718C3__8S19718C1[] = {
  ABISELECT(96,60),
  ABISELECT(88,56),
  ABISELECT(192,120),
  ABISELECT(176,116),
  ABISELECT(112,72),
  ABISELECT(-144,-88),
  (VTBL_ENTRY)&(_ZTI8S19718C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn48_n72_N8S19718C3D1Ev,_ZTvn32_n36_N8S19718C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn48_n72_N8S19718C3D0Ev,_ZTvn32_n36_N8S19718C3D0Ev),
};
extern void ABISELECT(_ZTv0_n56_N8S19718C3D1Ev,_ZTv0_n28_N8S19718C3D1Ev)();
extern void ABISELECT(_ZThn256_N8S19718C3D1Ev,_ZThn160_N8S19718C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S19718C3D0Ev,_ZTv0_n28_N8S19718C3D0Ev)();
extern void ABISELECT(_ZThn256_N8S19718C3D0Ev,_ZThn160_N8S19718C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19718C15__8S19718C3__8S19718C1[] = {
  ABISELECT(-256,-160),
  ABISELECT(-16,-12),
  ABISELECT(-24,-16),
  ABISELECT(80,48),
  ABISELECT(64,44),
  ABISELECT(-256,-160),
  (VTBL_ENTRY)&(_ZTI8S19718C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S19718C3D1Ev,_ZTv0_n28_N8S19718C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S19718C3D0Ev,_ZTv0_n28_N8S19718C3D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N8S19718C3D1Ev,_ZTv0_n20_N8S19718C3D1Ev)();
extern void ABISELECT(_ZThn336_N8S19718C3D1Ev,_ZThn208_N8S19718C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19718C3D0Ev,_ZTv0_n20_N8S19718C3D0Ev)();
extern void ABISELECT(_ZThn336_N8S19718C3D0Ev,_ZThn208_N8S19718C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19718C17__8S19718C3__8S19718C1[] = {
  ABISELECT(-336,-208),
  ABISELECT(-96,-60),
  ABISELECT(-104,-64),
  ABISELECT(-336,-208),
  (VTBL_ENTRY)&(_ZTI8S19718C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19718C3D1Ev,_ZTv0_n20_N8S19718C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19718C3D0Ev,_ZTv0_n20_N8S19718C3D0Ev),
};
extern void ABISELECT(_ZTvn64_n72_N8S19718C3D1Ev,_ZTvn40_n36_N8S19718C3D1Ev)();
extern void ABISELECT(_ZTvn64_n72_N8S19718C3D0Ev,_ZTvn40_n36_N8S19718C3D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19718C199S19718C11__8S19718C3__8S19718C1[] = {
  ABISELECT(72,48),
  ABISELECT(-160,-96),
  (VTBL_ENTRY)&(_ZTI8S19718C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn64_n72_N8S19718C3D1Ev,_ZTvn40_n36_N8S19718C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn64_n72_N8S19718C3D0Ev,_ZTvn40_n36_N8S19718C3D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N8S19718C3D1Ev,_ZTv0_n20_N8S19718C3D1Ev)();
extern void ABISELECT(_ZThn384_N8S19718C3D1Ev,_ZThn240_N8S19718C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19718C3D0Ev,_ZTv0_n20_N8S19718C3D0Ev)();
extern void ABISELECT(_ZThn384_N8S19718C3D0Ev,_ZThn240_N8S19718C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19718C21__8S19718C3__8S19718C1[] = {
  ABISELECT(-384,-240),
  ABISELECT(-384,-240),
  ABISELECT(16,4),
  ABISELECT(-384,-240),
  (VTBL_ENTRY)&(_ZTI8S19718C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19718C3D1Ev,_ZTv0_n20_N8S19718C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19718C3D0Ev,_ZTv0_n20_N8S19718C3D0Ev),
};
static  VTBL_ENTRY _tg__ZTV9S19718C13__A2__8S19718C3__8S19718C1[] = {
  ABISELECT(-184,-116),
  ABISELECT(-192,-120),
  ABISELECT(-424,-264),
  (VTBL_ENTRY)&(_ZTI8S19718C3[0]),
};
extern void _ZN9S19718C23D1Ev();
extern void _ZN9S19718C23D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19718C23__8S19718C1[] = {
  ABISELECT(216,132),
  ABISELECT(208,128),
  ABISELECT(312,192),
  ABISELECT(296,188),
  ABISELECT(232,144),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C23[0]),
  (VTBL_ENTRY)&_ZN9S19718C23D1Ev,
  (VTBL_ENTRY)&_ZN9S19718C23D0Ev,
};
extern void ABISELECT(_ZTv0_n56_N9S19718C23D1Ev,_ZTv0_n28_N9S19718C23D1Ev)();
extern void ABISELECT(_ZThn232_N9S19718C23D1Ev,_ZThn144_N9S19718C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S19718C23D0Ev,_ZTv0_n28_N9S19718C23D0Ev)();
extern void ABISELECT(_ZThn232_N9S19718C23D0Ev,_ZThn144_N9S19718C23D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19718C15__9S19718C23__8S19718C1[] = {
  ABISELECT(-232,-144),
  ABISELECT(-16,-12),
  ABISELECT(-24,-16),
  ABISELECT(80,48),
  ABISELECT(64,44),
  ABISELECT(-232,-144),
  (VTBL_ENTRY)&(_ZTI9S19718C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19718C23D1Ev,_ZTv0_n28_N9S19718C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19718C23D0Ev,_ZTv0_n28_N9S19718C23D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N9S19718C23D1Ev,_ZTv0_n20_N9S19718C23D1Ev)();
extern void ABISELECT(_ZThn312_N9S19718C23D1Ev,_ZThn192_N9S19718C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19718C23D0Ev,_ZTv0_n20_N9S19718C23D0Ev)();
extern void ABISELECT(_ZThn312_N9S19718C23D0Ev,_ZThn192_N9S19718C23D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19718C17__9S19718C23__8S19718C1[] = {
  ABISELECT(-312,-192),
  ABISELECT(-96,-60),
  ABISELECT(-104,-64),
  ABISELECT(-312,-192),
  (VTBL_ENTRY)&(_ZTI9S19718C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19718C23D1Ev,_ZTv0_n20_N9S19718C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19718C23D0Ev,_ZTv0_n20_N9S19718C23D0Ev),
};
extern void _ZN9S19718C11D1Ev();
extern void _ZN9S19718C11D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19718C11__8S19718C1[] = {
  ABISELECT(240,152),
  ABISELECT(224,148),
  ABISELECT(160,104),
  ABISELECT(-56,-32),
  ABISELECT(144,92),
  ABISELECT(136,88),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C11[0]),
  (VTBL_ENTRY)&_ZN9S19718C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19718C11D0Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19718C129S19718C11__8S19718C1[] = {
  ABISELECT(144,92),
  ABISELECT(136,88),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C12[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19718C139S19718C129S19718C11__8S19718C1[] = {
  ABISELECT(144,92),
  ABISELECT(136,88),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C13[0]),
};
extern void _ZN9S19718C14D1Ev();
extern void _ZN9S19718C14D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19718C149S19718C11__8S19718C1[] = {
  ABISELECT(96,60),
  ABISELECT(88,56),
  ABISELECT(192,120),
  ABISELECT(176,116),
  ABISELECT(112,72),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C14[0]),
  (VTBL_ENTRY)&_ZN9S19718C14D1Ev,
  (VTBL_ENTRY)&_ZN9S19718C14D0Ev,
};
extern void ABISELECT(_ZTv0_n56_N9S19718C14D1Ev,_ZTv0_n28_N9S19718C14D1Ev)();
extern void ABISELECT(_ZThn112_N9S19718C14D1Ev,_ZThn72_N9S19718C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S19718C14D0Ev,_ZTv0_n28_N9S19718C14D0Ev)();
extern void ABISELECT(_ZThn112_N9S19718C14D0Ev,_ZThn72_N9S19718C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19718C15__9S19718C149S19718C11__8S19718C1[] = {
  ABISELECT(-112,-72),
  ABISELECT(-16,-12),
  ABISELECT(-24,-16),
  ABISELECT(80,48),
  ABISELECT(64,44),
  ABISELECT(-112,-72),
  (VTBL_ENTRY)&(_ZTI9S19718C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19718C14D1Ev,_ZTv0_n28_N9S19718C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19718C14D0Ev,_ZTv0_n28_N9S19718C14D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N9S19718C14D1Ev,_ZTv0_n20_N9S19718C14D1Ev)();
extern void ABISELECT(_ZThn192_N9S19718C14D1Ev,_ZThn120_N9S19718C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19718C14D0Ev,_ZTv0_n20_N9S19718C14D0Ev)();
extern void ABISELECT(_ZThn192_N9S19718C14D0Ev,_ZThn120_N9S19718C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19718C17__9S19718C149S19718C11__8S19718C1[] = {
  ABISELECT(-192,-120),
  ABISELECT(-96,-60),
  ABISELECT(-104,-64),
  ABISELECT(-192,-120),
  (VTBL_ENTRY)&(_ZTI9S19718C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19718C14D1Ev,_ZTv0_n20_N9S19718C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19718C14D0Ev,_ZTv0_n20_N9S19718C14D0Ev),
};
extern void _ZN9S19718C19D1Ev();
extern void _ZN9S19718C19D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19718C199S19718C11__8S19718C1[] = {
  ABISELECT(72,48),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C19[0]),
  (VTBL_ENTRY)&_ZN9S19718C19D1Ev,
  (VTBL_ENTRY)&_ZN9S19718C19D0Ev,
};
extern void ABISELECT(_ZThn48_N9S19718C11D1Ev,_ZThn32_N9S19718C11D1Ev)();
extern void ABISELECT(_ZThn48_N9S19718C11D0Ev,_ZThn32_N9S19718C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19718C14__9S19718C11__8S19718C1[] = {
  ABISELECT(96,60),
  ABISELECT(88,56),
  ABISELECT(192,120),
  ABISELECT(176,116),
  ABISELECT(112,72),
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S19718C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S19718C11D1Ev,_ZThn32_N9S19718C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S19718C11D0Ev,_ZThn32_N9S19718C11D0Ev),
};
extern void ABISELECT(_ZTv0_n56_N9S19718C11D1Ev,_ZTv0_n28_N9S19718C11D1Ev)();
extern void ABISELECT(_ZThn160_N9S19718C11D1Ev,_ZThn104_N9S19718C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S19718C11D0Ev,_ZTv0_n28_N9S19718C11D0Ev)();
extern void ABISELECT(_ZThn160_N9S19718C11D0Ev,_ZThn104_N9S19718C11D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19718C15__9S19718C11__8S19718C1[] = {
  ABISELECT(-160,-104),
  ABISELECT(-16,-12),
  ABISELECT(-24,-16),
  ABISELECT(80,48),
  ABISELECT(64,44),
  ABISELECT(-160,-104),
  (VTBL_ENTRY)&(_ZTI9S19718C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19718C11D1Ev,_ZTv0_n28_N9S19718C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19718C11D0Ev,_ZTv0_n28_N9S19718C11D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N9S19718C11D1Ev,_ZTv0_n20_N9S19718C11D1Ev)();
extern void ABISELECT(_ZThn240_N9S19718C11D1Ev,_ZThn152_N9S19718C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19718C11D0Ev,_ZTv0_n20_N9S19718C11D0Ev)();
extern void ABISELECT(_ZThn240_N9S19718C11D0Ev,_ZThn152_N9S19718C11D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19718C17__9S19718C11__8S19718C1[] = {
  ABISELECT(-240,-152),
  ABISELECT(-96,-60),
  ABISELECT(-104,-64),
  ABISELECT(-240,-152),
  (VTBL_ENTRY)&(_ZTI9S19718C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19718C11D1Ev,_ZTv0_n20_N9S19718C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19718C11D0Ev,_ZTv0_n20_N9S19718C11D0Ev),
};
extern void ABISELECT(_ZThn64_N9S19718C11D1Ev,_ZThn40_N9S19718C11D1Ev)();
extern void ABISELECT(_ZThn64_N9S19718C11D0Ev,_ZThn40_N9S19718C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19718C19__9S19718C11__8S19718C1[] = {
  ABISELECT(72,48),
  ABISELECT(-64,-40),
  (VTBL_ENTRY)&(_ZTI9S19718C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S19718C11D1Ev,_ZThn40_N9S19718C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S19718C11D0Ev,_ZThn40_N9S19718C11D0Ev),
};
extern void _ZN9S19718C15D1Ev();
extern void _ZN9S19718C15D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19718C15__8S19718C1[] = {
  ABISELECT(-16,-12),
  ABISELECT(-24,-16),
  ABISELECT(80,48),
  ABISELECT(64,44),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C15[0]),
  (VTBL_ENTRY)&_ZN9S19718C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19718C15D0Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19718C15D1Ev,_ZTv0_n20_N9S19718C15D1Ev)();
extern void ABISELECT(_ZThn80_N9S19718C15D1Ev,_ZThn48_N9S19718C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19718C15D0Ev,_ZTv0_n20_N9S19718C15D0Ev)();
extern void ABISELECT(_ZThn80_N9S19718C15D0Ev,_ZThn48_N9S19718C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19718C17__9S19718C15__8S19718C1[] = {
  ABISELECT(-80,-48),
  ABISELECT(-96,-60),
  ABISELECT(-104,-64),
  ABISELECT(-80,-48),
  (VTBL_ENTRY)&(_ZTI9S19718C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19718C15D1Ev,_ZTv0_n20_N9S19718C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19718C15D0Ev,_ZTv0_n20_N9S19718C15D0Ev),
};
extern void _ZN9S19718C17D1Ev();
extern void _ZN9S19718C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19718C17__8S19718C1[] = {
  ABISELECT(-96,-60),
  ABISELECT(-104,-64),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C17[0]),
  (VTBL_ENTRY)&_ZN9S19718C17D1Ev,
  (VTBL_ENTRY)&_ZN9S19718C17D0Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19718C129S19718C17__A1__8S19718C1[] = {
  ABISELECT(-96,-60),
  ABISELECT(-104,-64),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C12[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19718C139S19718C129S19718C17__A1__8S19718C1[] = {
  ABISELECT(-96,-60),
  ABISELECT(-104,-64),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C13[0]),
};
extern void _ZN9S19718C21D1Ev();
extern void _ZN9S19718C21D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19718C21__8S19718C1[] = {
  ABISELECT(-384,-240),
  ABISELECT(16,4),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C21[0]),
  (VTBL_ENTRY)&_ZN9S19718C21D1Ev,
  (VTBL_ENTRY)&_ZN9S19718C21D0Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19718C229S19718C21__8S19718C1[] = {
  ABISELECT(16,4),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C22[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19718C13__A2__8S19718C1[] = {
  ABISELECT(-184,-116),
  ABISELECT(-192,-120),
  0,
  (VTBL_ENTRY)&(_ZTI9S19718C13[0]),
};
static  VTT_ENTRY vtt_S19718C1[] = {
  {&(_ZTV8S19718C1[14]),  14,82},
  {&(_tg__ZTV8S19718C3__8S19718C1[14]),  14,16},
  {&(_tg__ZTV8S19718C6__8S19718C3__8S19718C1[3]),  3,5},
  {&(_tg__ZTV9S19718C11__8S19718C3__8S19718C1[9]),  9,11},
  {&(_tg__ZTV9S19718C149S19718C11__8S19718C3__8S19718C1[7]),  7,9},
  {&(_tg__ZTV9S19718C15__8S19718C3__8S19718C1[7]),  7,9},
  {&(_tg__ZTV9S19718C17__8S19718C3__8S19718C1[5]),  5,7},
  {&(_tg__ZTV9S19718C199S19718C11__8S19718C3__8S19718C1[3]),  3,5},
  {&(_tg__ZTV9S19718C21__8S19718C3__8S19718C1[5]),  5,7},
  {&(_tg__ZTV9S19718C13__A2__8S19718C3__8S19718C1[4]),  4,4},
  {&(_tg__ZTV9S19718C23__8S19718C1[7]),  7,9},
  {&(_tg__ZTV9S19718C15__9S19718C23__8S19718C1[7]),  7,9},
  {&(_tg__ZTV9S19718C17__9S19718C23__8S19718C1[5]),  5,7},
  {&(_ZTV8S19718C1[28]),  28,82},
  {&(_ZTV8S19718C1[39]),  39,82},
  {&(_ZTV8S19718C1[48]),  48,82},
  {&(_ZTV8S19718C1[62]),  62,82},
  {&(_ZTV8S19718C1[69]),  69,82},
  {&(_ZTV8S19718C1[53]),  53,82},
  {&(_ZTV8S19718C1[76]),  76,82},
  {&(_ZTV8S19718C1[82]),  82,82},
  {&(_ZTV8S19718C1[23]),  23,82},
  {&(_tg__ZTV9S19718C11__8S19718C1[8]),  8,10},
  {&(_tg__ZTV9S19718C129S19718C11__8S19718C1[4]),  4,4},
  {&(_tg__ZTV9S19718C139S19718C129S19718C11__8S19718C1[4]),  4,4},
  {&(_tg__ZTV9S19718C149S19718C11__8S19718C1[7]),  7,9},
  {&(_tg__ZTV9S19718C15__9S19718C149S19718C11__8S19718C1[7]),  7,9},
  {&(_tg__ZTV9S19718C17__9S19718C149S19718C11__8S19718C1[5]),  5,7},
  {&(_tg__ZTV9S19718C199S19718C11__8S19718C1[3]),  3,5},
  {&(_tg__ZTV9S19718C14__9S19718C11__8S19718C1[7]),  7,9},
  {&(_tg__ZTV9S19718C15__9S19718C11__8S19718C1[7]),  7,9},
  {&(_tg__ZTV9S19718C17__9S19718C11__8S19718C1[5]),  5,7},
  {&(_tg__ZTV9S19718C19__9S19718C11__8S19718C1[3]),  3,5},
  {&(_tg__ZTV9S19718C15__8S19718C1[6]),  6,8},
  {&(_tg__ZTV9S19718C17__9S19718C15__8S19718C1[5]),  5,7},
  {&(_tg__ZTV9S19718C17__8S19718C1[4]),  4,6},
  {&(_tg__ZTV9S19718C129S19718C17__A1__8S19718C1[4]),  4,4},
  {&(_tg__ZTV9S19718C139S19718C129S19718C17__A1__8S19718C1[4]),  4,4},
  {&(_tg__ZTV9S19718C21__8S19718C1[4]),  4,6},
  {&(_tg__ZTV9S19718C229S19718C21__8S19718C1[3]),  3,3},
  {&(_tg__ZTV9S19718C13__A2__8S19718C1[4]),  4,4},
};
extern VTBL_ENTRY _ZTI8S19718C1[];
extern  VTBL_ENTRY _ZTV8S19718C1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19718C1[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19718C15D0Ev,_ZTv0_n20_N9S19718C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S19718C15D0Ev,_ZThn48_N9S19718C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19718C15D1Ev,_ZTv0_n20_N9S19718C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S19718C15D1Ev,_ZThn48_N9S19718C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19718C11D0Ev,_ZTv0_n20_N9S19718C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn240_N9S19718C11D0Ev,_ZThn152_N9S19718C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19718C11D1Ev,_ZTv0_n20_N9S19718C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn240_N9S19718C11D1Ev,_ZThn152_N9S19718C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19718C11D0Ev,_ZTv0_n28_N9S19718C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn160_N9S19718C11D0Ev,_ZThn104_N9S19718C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19718C11D1Ev,_ZTv0_n28_N9S19718C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn160_N9S19718C11D1Ev,_ZThn104_N9S19718C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19718C14D0Ev,_ZTv0_n20_N9S19718C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn192_N9S19718C14D0Ev,_ZThn120_N9S19718C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19718C14D1Ev,_ZTv0_n20_N9S19718C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn192_N9S19718C14D1Ev,_ZThn120_N9S19718C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19718C14D0Ev,_ZTv0_n28_N9S19718C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N9S19718C14D0Ev,_ZThn72_N9S19718C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19718C14D1Ev,_ZTv0_n28_N9S19718C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N9S19718C14D1Ev,_ZThn72_N9S19718C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19718C23D0Ev,_ZTv0_n20_N9S19718C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N9S19718C23D0Ev,_ZThn192_N9S19718C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19718C23D1Ev,_ZTv0_n20_N9S19718C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N9S19718C23D1Ev,_ZThn192_N9S19718C23D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19718C23D0Ev,_ZTv0_n28_N9S19718C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn232_N9S19718C23D0Ev,_ZThn144_N9S19718C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19718C23D1Ev,_ZTv0_n28_N9S19718C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn232_N9S19718C23D1Ev,_ZThn144_N9S19718C23D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19718C3D0Ev,_ZTv0_n20_N8S19718C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn384_N8S19718C3D0Ev,_ZThn240_N8S19718C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn336_N8S19718C3D0Ev,_ZThn208_N8S19718C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19718C3D1Ev,_ZTv0_n20_N8S19718C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn384_N8S19718C3D1Ev,_ZThn240_N8S19718C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn336_N8S19718C3D1Ev,_ZThn208_N8S19718C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S19718C3D0Ev,_ZTv0_n28_N8S19718C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn256_N8S19718C3D0Ev,_ZThn160_N8S19718C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S19718C3D1Ev,_ZTv0_n28_N8S19718C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn256_N8S19718C3D1Ev,_ZThn160_N8S19718C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S19718C3D0Ev,_ZTv0_n36_N8S19718C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N8S19718C3D0Ev,_ZThn56_N8S19718C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S19718C3D1Ev,_ZTv0_n36_N8S19718C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N8S19718C3D1Ev,_ZThn56_N8S19718C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19718C3D0Ev,_ZTv0_n12_N8S19718C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S19718C3D0Ev,_ZThn28_N8S19718C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19718C3D1Ev,_ZTv0_n12_N8S19718C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S19718C3D1Ev,_ZThn28_N8S19718C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19718C1D0Ev,_ZTv0_n20_N8S19718C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn384_N8S19718C1D0Ev,_ZThn240_N8S19718C1D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn336_N8S19718C1D0Ev,_ZThn208_N8S19718C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19718C1D1Ev,_ZTv0_n20_N8S19718C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn384_N8S19718C1D1Ev,_ZThn240_N8S19718C1D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn336_N8S19718C1D1Ev,_ZThn208_N8S19718C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S19718C1D0Ev,_ZTv0_n28_N8S19718C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn256_N8S19718C1D0Ev,_ZThn160_N8S19718C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S19718C1D1Ev,_ZTv0_n28_N8S19718C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn256_N8S19718C1D1Ev,_ZThn160_N8S19718C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S19718C1D0Ev,_ZTv0_n36_N8S19718C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N8S19718C1D0Ev,_ZThn56_N8S19718C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S19718C1D1Ev,_ZTv0_n36_N8S19718C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N8S19718C1D1Ev,_ZThn56_N8S19718C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19718C1D0Ev,_ZTv0_n12_N8S19718C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S19718C1D0Ev,_ZThn28_N8S19718C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19718C1D1Ev,_ZTv0_n12_N8S19718C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S19718C1D1Ev,_ZThn28_N8S19718C1D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19718C1 = {  "S19718C1", // class name
  bases_S19718C1, 40,
  &(vtc_S19718C1[0]), // expected_vtbl_contents
  &(vtt_S19718C1[0]), // expected_vtt_contents
  ABISELECT(448,272), // object size
  NSPAIRA(_ZTI8S19718C1),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S19718C1),82, //virtual function table var
  14, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19718C1),41, //virtual table table var
  16, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S14471C2_nt  {
  int s14471c2f0[2];
};
//SIG(-1 S14471C2_nt) C1{ Fi[2]}



//skip512 S14471C2_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S14471C5  {
  __tsi64 s14471c5f0[2];
};
//SIG(-1 S14471C5) C1{ FL[2]}



static void Test_S14471C5()
{
  {
    init_simple_test("S14471C5");
    S14471C5 lv;
    check2(sizeof(lv), 16, "sizeof(S14471C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S14471C5)");
    check_field_offset(lv, s14471c5f0, 0, "S14471C5.s14471c5f0");
  }
}
static Arrange_To_Call_Me vS14471C5(Test_S14471C5, "S14471C5", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S14471C4  {
  ::S14471C5 s14471c4f0;
};
//SIG(-1 S14471C4) C1{ FC2{ FL[2]}}



static void Test_S14471C4()
{
  {
    init_simple_test("S14471C4");
    S14471C4 lv;
    check2(sizeof(lv), 16, "sizeof(S14471C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S14471C4)");
    check_field_offset(lv, s14471c4f0, 0, "S14471C4.s14471c4f0");
  }
}
static Arrange_To_Call_Me vS14471C4(Test_S14471C4, "S14471C4", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S14471C6  {
  ::S14471C5 s14471c6f0;
  ::S14471C5 s14471c6f1;
};
//SIG(-1 S14471C6) C1{ FC2{ FL[2]} FC2}



static void Test_S14471C6()
{
  {
    init_simple_test("S14471C6");
    S14471C6 lv;
    check2(sizeof(lv), 32, "sizeof(S14471C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S14471C6)");
    check_field_offset(lv, s14471c6f0, 0, "S14471C6.s14471c6f0");
    check_field_offset(lv, s14471c6f1, 16, "S14471C6.s14471c6f1");
  }
}
static Arrange_To_Call_Me vS14471C6(Test_S14471C6, "S14471C6", 32);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S14471C8  {
  ::S14471C5 s14471c8f0;
  ::S14471C5 s14471c8f1;
  void *s14471c8f2[2];
};
//SIG(-1 S14471C8) C1{ FC2{ FL[2]} FC2 Fp[2]}



static void Test_S14471C8()
{
  {
    init_simple_test("S14471C8");
    S14471C8 lv;
    check2(sizeof(lv), ABISELECT(48,40), "sizeof(S14471C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S14471C8)");
    check_field_offset(lv, s14471c8f0, 0, "S14471C8.s14471c8f0");
    check_field_offset(lv, s14471c8f1, 16, "S14471C8.s14471c8f1");
    check_field_offset(lv, s14471c8f2, 32, "S14471C8.s14471c8f2");
  }
}
static Arrange_To_Call_Me vS14471C8(Test_S14471C8, "S14471C8", ABISELECT(48,40));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S14471C10  {
  ::S14471C5 s14471c10f0;
  long s14471c10f1;
};
//SIG(-1 S14471C10) C1{ FC2{ FL[2]} Fl}



static void Test_S14471C10()
{
  {
    init_simple_test("S14471C10");
    S14471C10 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(S14471C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S14471C10)");
    check_field_offset(lv, s14471c10f0, 0, "S14471C10.s14471c10f0");
    check_field_offset(lv, s14471c10f1, 16, "S14471C10.s14471c10f1");
  }
}
static Arrange_To_Call_Me vS14471C10(Test_S14471C10, "S14471C10", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S14471C11  {
  ::S14471C5 s14471c11f0;
  long s14471c11f1;
  ::S14471C5 s14471c11f2;
};
//SIG(-1 S14471C11) C1{ FC2{ FL[2]} Fl FC2}



static void Test_S14471C11()
{
  {
    init_simple_test("S14471C11");
    S14471C11 lv;
    check2(sizeof(lv), ABISELECT(40,36), "sizeof(S14471C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S14471C11)");
    check_field_offset(lv, s14471c11f0, 0, "S14471C11.s14471c11f0");
    check_field_offset(lv, s14471c11f1, 16, "S14471C11.s14471c11f1");
    check_field_offset(lv, s14471c11f2, ABISELECT(24,20), "S14471C11.s14471c11f2");
  }
}
static Arrange_To_Call_Me vS14471C11(Test_S14471C11, "S14471C11", ABISELECT(40,36));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S14471C13  {
  ::S14471C5 s14471c13f0;
  ::S14471C5 s14471c13f1;
};
//SIG(-1 S14471C13) C1{ FC2{ FL[2]} FC2}



static void Test_S14471C13()
{
  {
    init_simple_test("S14471C13");
    S14471C13 lv;
    check2(sizeof(lv), 32, "sizeof(S14471C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S14471C13)");
    check_field_offset(lv, s14471c13f0, 0, "S14471C13.s14471c13f0");
    check_field_offset(lv, s14471c13f1, 16, "S14471C13.s14471c13f1");
  }
}
static Arrange_To_Call_Me vS14471C13(Test_S14471C13, "S14471C13", 32);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S14471C14  {
  ::S14471C5 s14471c14f0;
  __tsi64 s14471c14f1;
};
//SIG(-1 S14471C14) C1{ FC2{ FL[2]} FL}



static void Test_S14471C14()
{
  {
    init_simple_test("S14471C14");
    S14471C14 lv;
    check2(sizeof(lv), 24, "sizeof(S14471C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S14471C14)");
    check_field_offset(lv, s14471c14f0, 0, "S14471C14.s14471c14f0");
    check_field_offset(lv, s14471c14f1, 16, "S14471C14.s14471c14f1");
  }
}
static Arrange_To_Call_Me vS14471C14(Test_S14471C14, "S14471C14", 24);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S14471C9  {
  ::S14471C5 s14471c9f0;
  ::S14471C5 s14471c9f1;
  ::S14471C10 s14471c9f2;
  ::S14471C11 s14471c9f3;
  ::S14471C6 s14471c9f4;
  ::S14471C13 s14471c9f5;
  void *s14471c9f6[2];
  ::S14471C8 s14471c9f7;
  ::S14471C14 s14471c9f8;
  void *s14471c9f9[4];
  ::S14471C13 s14471c9f10;
};
//SIG(-1 S14471C9) C1{ FC2{ FL[2]} FC2 FC3{ FC2 Fl} FC4{ FC2 Fl FC2} FC5{ FC2 FC2} FC6{ FC2 FC2} Fp[2] FC7{ FC2 FC2 Fp[2]} FC8{ FC2 FL} Fp[4] FC6}



static void Test_S14471C9()
{
  {
    init_simple_test("S14471C9");
    S14471C9 lv;
    check2(sizeof(lv), ABISELECT(312,272), "sizeof(S14471C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S14471C9)");
    check_field_offset(lv, s14471c9f0, 0, "S14471C9.s14471c9f0");
    check_field_offset(lv, s14471c9f1, 16, "S14471C9.s14471c9f1");
    check_field_offset(lv, s14471c9f2, 32, "S14471C9.s14471c9f2");
    check_field_offset(lv, s14471c9f3, ABISELECT(56,52), "S14471C9.s14471c9f3");
    check_field_offset(lv, s14471c9f4, ABISELECT(96,88), "S14471C9.s14471c9f4");
    check_field_offset(lv, s14471c9f5, ABISELECT(128,120), "S14471C9.s14471c9f5");
    check_field_offset(lv, s14471c9f6, ABISELECT(160,152), "S14471C9.s14471c9f6");
    check_field_offset(lv, s14471c9f7, ABISELECT(176,160), "S14471C9.s14471c9f7");
    check_field_offset(lv, s14471c9f8, ABISELECT(224,200), "S14471C9.s14471c9f8");
    check_field_offset(lv, s14471c9f9, ABISELECT(248,224), "S14471C9.s14471c9f9");
    check_field_offset(lv, s14471c9f10, ABISELECT(280,240), "S14471C9.s14471c9f10");
  }
}
static Arrange_To_Call_Me vS14471C9(Test_S14471C9, "S14471C9", ABISELECT(312,272));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S14471C17  {
  ::S14471C5 s14471c17f0;
  ::S14471C5 s14471c17f1;
};
//SIG(-1 S14471C17) C1{ FC2{ FL[2]} FC2}



static void Test_S14471C17()
{
  {
    init_simple_test("S14471C17");
    S14471C17 lv;
    check2(sizeof(lv), 32, "sizeof(S14471C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S14471C17)");
    check_field_offset(lv, s14471c17f0, 0, "S14471C17.s14471c17f0");
    check_field_offset(lv, s14471c17f1, 16, "S14471C17.s14471c17f1");
  }
}
static Arrange_To_Call_Me vS14471C17(Test_S14471C17, "S14471C17", 32);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S14471C3  {
  ::S14471C4 s14471c3f0;
  ::S14471C6 s14471c3f1;
  ::S14471C4 s14471c3f2;
  ::S14471C8 s14471c3f3;
  ::S14471C9 s14471c3f4;
  void *s14471c3f5[2];
  ::S14471C13 s14471c3f6;
  ::S14471C8 s14471c3f7;
  void *s14471c3f8[2];
  ::S14471C8 s14471c3f9;
  ::S14471C8 s14471c3f10;
  ::S14471C8 s14471c3f11;
  ::S14471C17 s14471c3f12;
};
//SIG(-1 S14471C3) C1{ FC2{ FC3{ FL[2]}} FC4{ FC3 FC3} FC2 FC5{ FC3 FC3 Fp[2]} FC6{ FC3 FC3 FC7{ FC3 Fl} FC8{ FC3 Fl FC3} FC4 FC9{ FC3 FC3} Fp[2] FC5 FC10{ FC3 FL} Fp[4] FC9} Fp[2] FC9 FC5 Fp[2] FC5 FC5 FC5 FC11{ FC3 FC3}}



static void Test_S14471C3()
{
  {
    init_simple_test("S14471C3");
    S14471C3 lv;
    check2(sizeof(lv), ABISELECT(712,616), "sizeof(S14471C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S14471C3)");
    check_field_offset(lv, s14471c3f0, 0, "S14471C3.s14471c3f0");
    check_field_offset(lv, s14471c3f1, 16, "S14471C3.s14471c3f1");
    check_field_offset(lv, s14471c3f2, 48, "S14471C3.s14471c3f2");
    check_field_offset(lv, s14471c3f3, 64, "S14471C3.s14471c3f3");
    check_field_offset(lv, s14471c3f4, ABISELECT(112,104), "S14471C3.s14471c3f4");
    check_field_offset(lv, s14471c3f5, ABISELECT(424,376), "S14471C3.s14471c3f5");
    check_field_offset(lv, s14471c3f6, ABISELECT(440,384), "S14471C3.s14471c3f6");
    check_field_offset(lv, s14471c3f7, ABISELECT(472,416), "S14471C3.s14471c3f7");
    check_field_offset(lv, s14471c3f8, ABISELECT(520,456), "S14471C3.s14471c3f8");
    check_field_offset(lv, s14471c3f9, ABISELECT(536,464), "S14471C3.s14471c3f9");
    check_field_offset(lv, s14471c3f10, ABISELECT(584,504), "S14471C3.s14471c3f10");
    check_field_offset(lv, s14471c3f11, ABISELECT(632,544), "S14471C3.s14471c3f11");
    check_field_offset(lv, s14471c3f12, ABISELECT(680,584), "S14471C3.s14471c3f12");
  }
}
static Arrange_To_Call_Me vS14471C3(Test_S14471C3, "S14471C3", ABISELECT(712,616));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S14471C19  {
  __tsi64 s14471c19f0[4];
  void *s14471c19f1[2];
};
//SIG(-1 S14471C19) C1{ FL[4] Fp[2]}



static void Test_S14471C19()
{
  {
    init_simple_test("S14471C19");
    S14471C19 lv;
    check2(sizeof(lv), ABISELECT(48,40), "sizeof(S14471C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S14471C19)");
    check_field_offset(lv, s14471c19f0, 0, "S14471C19.s14471c19f0");
    check_field_offset(lv, s14471c19f1, 32, "S14471C19.s14471c19f1");
  }
}
static Arrange_To_Call_Me vS14471C19(Test_S14471C19, "S14471C19", ABISELECT(48,40));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S14471C18  {
  int s14471c18f0;
  ::S14471C19 s14471c18f1;
  void *s14471c18f2[3];
};
//SIG(-1 S14471C18) C1{ Fi FC2{ FL[4] Fp[2]} Fp[3]}



static void Test_S14471C18()
{
  {
    init_simple_test("S14471C18");
    S14471C18 lv;
    check2(sizeof(lv), ABISELECT(80,56), "sizeof(S14471C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S14471C18)");
    check_field_offset(lv, s14471c18f0, 0, "S14471C18.s14471c18f0");
    check_field_offset(lv, s14471c18f1, ABISELECT(8,4), "S14471C18.s14471c18f1");
    check_field_offset(lv, s14471c18f2, ABISELECT(56,44), "S14471C18.s14471c18f2");
  }
}
static Arrange_To_Call_Me vS14471C18(Test_S14471C18, "S14471C18", ABISELECT(80,56));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S14471C1  {
  void *s14471c1f0[2];
  ::S14471C2_nt s14471c1f1;
  ::S14471C3 s14471c1f2;
  ::S14471C18 s14471c1f3;
};
//SIG(1 S14471C1) C1{ Fp[2] FC2{ Fi[2]} FC3{ FC4{ FC5{ FL[2]}} FC6{ FC5 FC5} FC4 FC7{ FC5 FC5 Fp[2]} FC8{ FC5 FC5 FC9{ FC5 Fl} FC10{ FC5 Fl FC5} FC6 FC11{ FC5 FC5} Fp[2] FC7 FC12{ FC5 FL} Fp[4] FC11} Fp[2] FC11 FC7 Fp[2] FC7 FC7 FC7 FC13{ FC5 FC5}} FC14{ Fi FC15{ FL[4] Fp[2]} Fp[3]}}



static void Test_S14471C1()
{
  {
    init_simple_test("S14471C1");
    S14471C1 lv;
    check2(sizeof(lv), ABISELECT(816,688), "sizeof(S14471C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S14471C1)");
    check_field_offset(lv, s14471c1f0, 0, "S14471C1.s14471c1f0");
    check_field_offset(lv, s14471c1f1, ABISELECT(16,8), "S14471C1.s14471c1f1");
    check_field_offset(lv, s14471c1f2, ABISELECT(24,16), "S14471C1.s14471c1f2");
    check_field_offset(lv, s14471c1f3, ABISELECT(736,632), "S14471C1.s14471c1f3");
  }
}
static Arrange_To_Call_Me vS14471C1(Test_S14471C1, "S14471C1", ABISELECT(816,688));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2397C4_nt  {
  void *s2397c4f0;
  virtual  ~S2397C4_nt(); // _ZN10S2397C4_ntD1Ev
  virtual void  v6(); // _ZN10S2397C4_nt2v6Ev
  virtual void  v7(); // _ZN10S2397C4_nt2v7Ev
  S2397C4_nt(); // tgen
};
//SIG(-1 S2397C4_nt) C1{ vd v1 v2 Fp}


 S2397C4_nt ::~S2397C4_nt(){ note_dtor("S2397C4_nt", this);}
void  S2397C4_nt ::v6(){vfunc_called(this, "_ZN10S2397C4_nt2v6Ev");}
void  S2397C4_nt ::v7(){vfunc_called(this, "_ZN10S2397C4_nt2v7Ev");}
S2397C4_nt ::S2397C4_nt(){ note_ctor("S2397C4_nt", this);} // tgen

//skip512 S2397C4_nt

#else // __cplusplus

extern void _ZN10S2397C4_ntC1Ev();
extern void _ZN10S2397C4_ntD1Ev();
Name_Map name_map_S2397C4_nt[] = {
  NSPAIR(_ZN10S2397C4_ntC1Ev),
  NSPAIR(_ZN10S2397C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S2397C4_nt[];
extern void _ZN10S2397C4_ntD1Ev();
extern void _ZN10S2397C4_ntD0Ev();
extern void _ZN10S2397C4_nt2v6Ev();
extern void _ZN10S2397C4_nt2v7Ev();
static  VTBL_ENTRY vtc_S2397C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2397C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S2397C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2397C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2397C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2397C4_nt2v7Ev,
};
extern VTBL_ENTRY _ZTI10S2397C4_nt[];
VTBL_ENTRY *P__ZTI10S2397C4_nt = _ZTI10S2397C4_nt; 
extern  VTBL_ENTRY _ZTV10S2397C4_nt[];
Class_Descriptor cd_S2397C4_nt = {  "S2397C4_nt", // class name
  0,0,//no base classes
  &(vtc_S2397C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI10S2397C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S2397C4_nt),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2397C3  : S2397C4_nt {
  void *s2397c3f0[2];
  int s2397c3f1;
  ::S2122C19_nt s2397c3f2;
  virtual  ~S2397C3(); // _ZN7S2397C3D1Ev
  virtual void  v8(); // _ZN7S2397C32v8Ev
  virtual void  v9(); // _ZN7S2397C32v9Ev
  virtual void  v10(); // _ZN7S2397C33v10Ev
  virtual void  v11(); // _ZN7S2397C33v11Ev
  virtual void  v12(); // _ZN7S2397C33v12Ev
  virtual void  v13(); // _ZN7S2397C33v13Ev
  virtual void  v14(); // _ZN7S2397C33v14Ev
  virtual void  v15(); // _ZN7S2397C33v15Ev
  virtual void  v16(); // _ZN7S2397C33v16Ev
  virtual void  v17(); // _ZN7S2397C33v17Ev
  virtual void  v18(); // _ZN7S2397C33v18Ev
  virtual void  v19(); // _ZN7S2397C33v19Ev
  virtual void  v20(); // _ZN7S2397C33v20Ev
  virtual void  v21(); // _ZN7S2397C33v21Ev
  virtual void  v22(); // _ZN7S2397C33v22Ev
  virtual void  v23(); // _ZN7S2397C33v23Ev
  S2397C3(); // tgen
};
//SIG(-1 S2397C3) C1{ BC2{ vd v17 v18 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 Fp[2] Fi FC3{ m FC4{ m Fp Fi FC5{ m}} Fi}}


 S2397C3 ::~S2397C3(){ note_dtor("S2397C3", this);}
void  S2397C3 ::v8(){vfunc_called(this, "_ZN7S2397C32v8Ev");}
void  S2397C3 ::v9(){vfunc_called(this, "_ZN7S2397C32v9Ev");}
void  S2397C3 ::v10(){vfunc_called(this, "_ZN7S2397C33v10Ev");}
void  S2397C3 ::v11(){vfunc_called(this, "_ZN7S2397C33v11Ev");}
void  S2397C3 ::v12(){vfunc_called(this, "_ZN7S2397C33v12Ev");}
void  S2397C3 ::v13(){vfunc_called(this, "_ZN7S2397C33v13Ev");}
void  S2397C3 ::v14(){vfunc_called(this, "_ZN7S2397C33v14Ev");}
void  S2397C3 ::v15(){vfunc_called(this, "_ZN7S2397C33v15Ev");}
void  S2397C3 ::v16(){vfunc_called(this, "_ZN7S2397C33v16Ev");}
void  S2397C3 ::v17(){vfunc_called(this, "_ZN7S2397C33v17Ev");}
void  S2397C3 ::v18(){vfunc_called(this, "_ZN7S2397C33v18Ev");}
void  S2397C3 ::v19(){vfunc_called(this, "_ZN7S2397C33v19Ev");}
void  S2397C3 ::v20(){vfunc_called(this, "_ZN7S2397C33v20Ev");}
void  S2397C3 ::v21(){vfunc_called(this, "_ZN7S2397C33v21Ev");}
void  S2397C3 ::v22(){vfunc_called(this, "_ZN7S2397C33v22Ev");}
void  S2397C3 ::v23(){vfunc_called(this, "_ZN7S2397C33v23Ev");}
S2397C3 ::S2397C3(){ note_ctor("S2397C3", this);} // tgen

static void Test_S2397C3()
{
  extern Class_Descriptor cd_S2397C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_S2397C3, buf);
    S2397C3 *dp, &lv = *(dp=new (buf) S2397C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(S2397C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2397C3)");
    check_base_class_offset(lv, (S2397C4_nt*), 0, "S2397C3");
    check_field_offset(lv, s2397c3f0, ABISELECT(16,8), "S2397C3.s2397c3f0");
    check_field_offset(lv, s2397c3f1, ABISELECT(32,16), "S2397C3.s2397c3f1");
    check_field_offset(lv, s2397c3f2, ABISELECT(40,20), "S2397C3.s2397c3f2");
    test_class_info(&lv, &cd_S2397C3);
    dp->~S2397C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2397C3(Test_S2397C3, "S2397C3", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7S2397C3C1Ev();
extern void _ZN7S2397C3D1Ev();
Name_Map name_map_S2397C3[] = {
  NSPAIR(_ZN7S2397C3C1Ev),
  NSPAIR(_ZN7S2397C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2397C4_nt;
extern VTBL_ENTRY _ZTI10S2397C4_nt[];
extern  VTBL_ENTRY _ZTV10S2397C4_nt[];
static Base_Class bases_S2397C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2397C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2397C3[];
extern void _ZN7S2397C3D1Ev();
extern void _ZN7S2397C3D0Ev();
extern void _ZN10S2397C4_nt2v6Ev();
extern void _ZN10S2397C4_nt2v7Ev();
extern void _ZN7S2397C32v8Ev();
extern void _ZN7S2397C32v9Ev();
extern void _ZN7S2397C33v10Ev();
extern void _ZN7S2397C33v11Ev();
extern void _ZN7S2397C33v12Ev();
extern void _ZN7S2397C33v13Ev();
extern void _ZN7S2397C33v14Ev();
extern void _ZN7S2397C33v15Ev();
extern void _ZN7S2397C33v16Ev();
extern void _ZN7S2397C33v17Ev();
extern void _ZN7S2397C33v18Ev();
extern void _ZN7S2397C33v19Ev();
extern void _ZN7S2397C33v20Ev();
extern void _ZN7S2397C33v21Ev();
extern void _ZN7S2397C33v22Ev();
extern void _ZN7S2397C33v23Ev();
static  VTBL_ENTRY vtc_S2397C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2397C3[0]),
  (VTBL_ENTRY)&_ZN7S2397C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2397C3D0Ev,
  (VTBL_ENTRY)&_ZN10S2397C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2397C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN7S2397C32v8Ev,
  (VTBL_ENTRY)&_ZN7S2397C32v9Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v10Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v11Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v21Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v22Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v23Ev,
};
extern VTBL_ENTRY _ZTI7S2397C3[];
extern  VTBL_ENTRY _ZTV7S2397C3[];
Class_Descriptor cd_S2397C3 = {  "S2397C3", // class name
  bases_S2397C3, 1,
  &(vtc_S2397C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7S2397C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2397C3),22, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2397C8_nt  {
  int s2397c8f0;
  char s2397c8f1[320];
};
//SIG(-1 S2397C8_nt) C1{ Fi Fc[320]}



//skip512 S2397C8_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2397C9_nt  {
  char s2397c9f0[256];
};
//SIG(-1 S2397C9_nt) C1{ Fc[256]}



//skip512 S2397C9_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2397C2  : S2397C3 {
  ::S2122C19_nt s2397c2f0;
  int s2397c2f1;
  ::S2122C19_nt s2397c2f2;
  ::S2122C19_nt s2397c2f3;
  ::S2122C19_nt s2397c2f4;
  ::S2122C19_nt s2397c2f5;
  ::S2397C8_nt s2397c2f6;
  ::S2397C9_nt s2397c2f7;
  void *s2397c2f8[2];
  virtual  ~S2397C2(); // _ZN7S2397C2D1Ev
  virtual void  v24(); // _ZN7S2397C23v24Ev
  virtual void  v25(); // _ZN7S2397C23v25Ev
  virtual void  v26(); // _ZN7S2397C23v26Ev
  virtual void  v27(); // _ZN7S2397C23v27Ev
  virtual void  v28(); // _ZN7S2397C23v28Ev
  virtual void  v29(); // _ZN7S2397C23v29Ev
  virtual void  v30(); // _ZN7S2397C23v30Ev
  virtual void  v31(); // _ZN7S2397C23v31Ev
  virtual void  v32(); // _ZN7S2397C23v32Ev
  virtual void  v33(); // _ZN7S2397C23v33Ev
  virtual void  v34(); // _ZN7S2397C23v34Ev
  virtual void  v35(); // _ZN7S2397C23v35Ev
  virtual void  v36(); // _ZN7S2397C23v36Ev
  virtual void  v37(); // _ZN7S2397C23v37Ev
  S2397C2(); // tgen
};
//SIG(-1 S2397C2) C1{ BC2{ BC3{ vd v15 v16 Fp} vd v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 Fp[2] Fi FC4{ m FC5{ m Fp Fi FC6{ m}} Fi}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 FC4 Fi FC4 FC4 FC4 FC4 FC7{ Fi Fc[320]} FC8{ Fc[256]} Fp[2]}


 S2397C2 ::~S2397C2(){ note_dtor("S2397C2", this);}
void  S2397C2 ::v24(){vfunc_called(this, "_ZN7S2397C23v24Ev");}
void  S2397C2 ::v25(){vfunc_called(this, "_ZN7S2397C23v25Ev");}
void  S2397C2 ::v26(){vfunc_called(this, "_ZN7S2397C23v26Ev");}
void  S2397C2 ::v27(){vfunc_called(this, "_ZN7S2397C23v27Ev");}
void  S2397C2 ::v28(){vfunc_called(this, "_ZN7S2397C23v28Ev");}
void  S2397C2 ::v29(){vfunc_called(this, "_ZN7S2397C23v29Ev");}
void  S2397C2 ::v30(){vfunc_called(this, "_ZN7S2397C23v30Ev");}
void  S2397C2 ::v31(){vfunc_called(this, "_ZN7S2397C23v31Ev");}
void  S2397C2 ::v32(){vfunc_called(this, "_ZN7S2397C23v32Ev");}
void  S2397C2 ::v33(){vfunc_called(this, "_ZN7S2397C23v33Ev");}
void  S2397C2 ::v34(){vfunc_called(this, "_ZN7S2397C23v34Ev");}
void  S2397C2 ::v35(){vfunc_called(this, "_ZN7S2397C23v35Ev");}
void  S2397C2 ::v36(){vfunc_called(this, "_ZN7S2397C23v36Ev");}
void  S2397C2 ::v37(){vfunc_called(this, "_ZN7S2397C23v37Ev");}
S2397C2 ::S2397C2(){ note_ctor("S2397C2", this);} // tgen

static void Test_S2397C2()
{
  extern Class_Descriptor cd_S2397C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(100,178)];
    init_test(&cd_S2397C2, buf);
    S2397C2 *dp, &lv = *(dp=new (buf) S2397C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(792,708), "sizeof(S2397C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2397C2)");
    check_base_class_offset(lv, (S2397C4_nt*)(S2397C3*), 0, "S2397C2");
    check_base_class_offset(lv, (S2397C3*), 0, "S2397C2");
    check_field_offset(lv, s2397c2f0, ABISELECT(64,36), "S2397C2.s2397c2f0");
    check_field_offset(lv, s2397c2f1, ABISELECT(88,52), "S2397C2.s2397c2f1");
    check_field_offset(lv, s2397c2f2, ABISELECT(96,56), "S2397C2.s2397c2f2");
    check_field_offset(lv, s2397c2f3, ABISELECT(120,72), "S2397C2.s2397c2f3");
    check_field_offset(lv, s2397c2f4, ABISELECT(144,88), "S2397C2.s2397c2f4");
    check_field_offset(lv, s2397c2f5, ABISELECT(168,104), "S2397C2.s2397c2f5");
    check_field_offset(lv, s2397c2f6, ABISELECT(192,120), "S2397C2.s2397c2f6");
    check_field_offset(lv, s2397c2f7, ABISELECT(516,444), "S2397C2.s2397c2f7");
    check_field_offset(lv, s2397c2f8, ABISELECT(776,700), "S2397C2.s2397c2f8");
    test_class_info(&lv, &cd_S2397C2);
    dp->~S2397C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2397C2(Test_S2397C2, "S2397C2", ABISELECT(792,708));

#else // __cplusplus

extern void _ZN7S2397C2C1Ev();
extern void _ZN7S2397C2D1Ev();
Name_Map name_map_S2397C2[] = {
  NSPAIR(_ZN7S2397C2C1Ev),
  NSPAIR(_ZN7S2397C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2397C4_nt;
extern VTBL_ENTRY _ZTI10S2397C4_nt[];
extern  VTBL_ENTRY _ZTV10S2397C4_nt[];
extern Class_Descriptor cd_S2397C3;
extern VTBL_ENTRY _ZTI7S2397C3[];
extern  VTBL_ENTRY _ZTV7S2397C3[];
static Base_Class bases_S2397C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2397C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2397C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2397C2[];
extern void _ZN7S2397C2D1Ev();
extern void _ZN7S2397C2D0Ev();
extern void _ZN10S2397C4_nt2v6Ev();
extern void _ZN10S2397C4_nt2v7Ev();
extern void _ZN7S2397C32v8Ev();
extern void _ZN7S2397C32v9Ev();
extern void _ZN7S2397C33v10Ev();
extern void _ZN7S2397C33v11Ev();
extern void _ZN7S2397C33v12Ev();
extern void _ZN7S2397C33v13Ev();
extern void _ZN7S2397C33v14Ev();
extern void _ZN7S2397C33v15Ev();
extern void _ZN7S2397C33v16Ev();
extern void _ZN7S2397C33v17Ev();
extern void _ZN7S2397C33v18Ev();
extern void _ZN7S2397C33v19Ev();
extern void _ZN7S2397C33v20Ev();
extern void _ZN7S2397C33v21Ev();
extern void _ZN7S2397C33v22Ev();
extern void _ZN7S2397C33v23Ev();
extern void _ZN7S2397C23v24Ev();
extern void _ZN7S2397C23v25Ev();
extern void _ZN7S2397C23v26Ev();
extern void _ZN7S2397C23v27Ev();
extern void _ZN7S2397C23v28Ev();
extern void _ZN7S2397C23v29Ev();
extern void _ZN7S2397C23v30Ev();
extern void _ZN7S2397C23v31Ev();
extern void _ZN7S2397C23v32Ev();
extern void _ZN7S2397C23v33Ev();
extern void _ZN7S2397C23v34Ev();
extern void _ZN7S2397C23v35Ev();
extern void _ZN7S2397C23v36Ev();
extern void _ZN7S2397C23v37Ev();
static  VTBL_ENTRY vtc_S2397C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2397C2[0]),
  (VTBL_ENTRY)&_ZN7S2397C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2397C2D0Ev,
  (VTBL_ENTRY)&_ZN10S2397C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2397C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN7S2397C32v8Ev,
  (VTBL_ENTRY)&_ZN7S2397C32v9Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v10Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v11Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v21Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v22Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v23Ev,
  (VTBL_ENTRY)&_ZN7S2397C23v24Ev,
  (VTBL_ENTRY)&_ZN7S2397C23v25Ev,
  (VTBL_ENTRY)&_ZN7S2397C23v26Ev,
  (VTBL_ENTRY)&_ZN7S2397C23v27Ev,
  (VTBL_ENTRY)&_ZN7S2397C23v28Ev,
  (VTBL_ENTRY)&_ZN7S2397C23v29Ev,
  (VTBL_ENTRY)&_ZN7S2397C23v30Ev,
  (VTBL_ENTRY)&_ZN7S2397C23v31Ev,
  (VTBL_ENTRY)&_ZN7S2397C23v32Ev,
  (VTBL_ENTRY)&_ZN7S2397C23v33Ev,
  (VTBL_ENTRY)&_ZN7S2397C23v34Ev,
  (VTBL_ENTRY)&_ZN7S2397C23v35Ev,
  (VTBL_ENTRY)&_ZN7S2397C23v36Ev,
  (VTBL_ENTRY)&_ZN7S2397C23v37Ev,
};
extern VTBL_ENTRY _ZTI7S2397C2[];
extern  VTBL_ENTRY _ZTV7S2397C2[];
Class_Descriptor cd_S2397C2 = {  "S2397C2", // class name
  bases_S2397C2, 2,
  &(vtc_S2397C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(792,708), // object size
  NSPAIRA(_ZTI7S2397C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2397C2),36, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2397C1  : S2397C2 {
  char s2397c1f0[128];
  virtual  ~S2397C1(); // _ZN7S2397C1D1Ev
  virtual void  v1(); // _ZN7S2397C12v1Ev
  virtual void  v2(); // _ZN7S2397C12v2Ev
  virtual void  v3(); // _ZN7S2397C12v3Ev
  virtual void  v4(); // _ZN7S2397C12v4Ev
  virtual void  v5(); // _ZN7S2397C12v5Ev
  S2397C1(); // tgen
};
//SIG(1 S2397C1) C1{ BC2{ BC3{ BC4{ vd v6 v7 Fp} vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp[2] Fi FC5{ m FC6{ m Fp Fi FC7{ m}} Fi}} vd v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 FC5 Fi FC5 FC5 FC5 FC5 FC8{ Fi Fc[320]} FC9{ Fc[256]} Fp[2]} vd v1 v2 v3 v4 v5 Fc[128]}


 S2397C1 ::~S2397C1(){ note_dtor("S2397C1", this);}
void  S2397C1 ::v1(){vfunc_called(this, "_ZN7S2397C12v1Ev");}
void  S2397C1 ::v2(){vfunc_called(this, "_ZN7S2397C12v2Ev");}
void  S2397C1 ::v3(){vfunc_called(this, "_ZN7S2397C12v3Ev");}
void  S2397C1 ::v4(){vfunc_called(this, "_ZN7S2397C12v4Ev");}
void  S2397C1 ::v5(){vfunc_called(this, "_ZN7S2397C12v5Ev");}
S2397C1 ::S2397C1(){ note_ctor("S2397C1", this);} // tgen

static void Test_S2397C1()
{
  extern Class_Descriptor cd_S2397C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(116,210)];
    init_test(&cd_S2397C1, buf);
    S2397C1 *dp, &lv = *(dp=new (buf) S2397C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(920,836), "sizeof(S2397C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2397C1)");
    check_base_class_offset(lv, (S2397C4_nt*)(S2397C3*)(S2397C2*), 0, "S2397C1");
    check_base_class_offset(lv, (S2397C3*)(S2397C2*), 0, "S2397C1");
    check_base_class_offset(lv, (S2397C2*), 0, "S2397C1");
    check_field_offset(lv, s2397c1f0, ABISELECT(792,708), "S2397C1.s2397c1f0");
    test_class_info(&lv, &cd_S2397C1);
    dp->~S2397C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2397C1(Test_S2397C1, "S2397C1", ABISELECT(920,836));

#else // __cplusplus

extern void _ZN7S2397C1C1Ev();
extern void _ZN7S2397C1D1Ev();
Name_Map name_map_S2397C1[] = {
  NSPAIR(_ZN7S2397C1C1Ev),
  NSPAIR(_ZN7S2397C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2397C4_nt;
extern VTBL_ENTRY _ZTI10S2397C4_nt[];
extern  VTBL_ENTRY _ZTV10S2397C4_nt[];
extern Class_Descriptor cd_S2397C3;
extern VTBL_ENTRY _ZTI7S2397C3[];
extern  VTBL_ENTRY _ZTV7S2397C3[];
extern Class_Descriptor cd_S2397C2;
extern VTBL_ENTRY _ZTI7S2397C2[];
extern  VTBL_ENTRY _ZTV7S2397C2[];
static Base_Class bases_S2397C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2397C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2397C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2397C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2397C1[];
extern void _ZN7S2397C1D1Ev();
extern void _ZN7S2397C1D0Ev();
extern void _ZN10S2397C4_nt2v6Ev();
extern void _ZN10S2397C4_nt2v7Ev();
extern void _ZN7S2397C32v8Ev();
extern void _ZN7S2397C32v9Ev();
extern void _ZN7S2397C33v10Ev();
extern void _ZN7S2397C33v11Ev();
extern void _ZN7S2397C33v12Ev();
extern void _ZN7S2397C33v13Ev();
extern void _ZN7S2397C33v14Ev();
extern void _ZN7S2397C33v15Ev();
extern void _ZN7S2397C33v16Ev();
extern void _ZN7S2397C33v17Ev();
extern void _ZN7S2397C33v18Ev();
extern void _ZN7S2397C33v19Ev();
extern void _ZN7S2397C33v20Ev();
extern void _ZN7S2397C33v21Ev();
extern void _ZN7S2397C33v22Ev();
extern void _ZN7S2397C33v23Ev();
extern void _ZN7S2397C23v24Ev();
extern void _ZN7S2397C23v25Ev();
extern void _ZN7S2397C23v26Ev();
extern void _ZN7S2397C23v27Ev();
extern void _ZN7S2397C23v28Ev();
extern void _ZN7S2397C23v29Ev();
extern void _ZN7S2397C23v30Ev();
extern void _ZN7S2397C23v31Ev();
extern void _ZN7S2397C23v32Ev();
extern void _ZN7S2397C23v33Ev();
extern void _ZN7S2397C23v34Ev();
extern void _ZN7S2397C23v35Ev();
extern void _ZN7S2397C23v36Ev();
extern void _ZN7S2397C23v37Ev();
extern void _ZN7S2397C12v1Ev();
extern void _ZN7S2397C12v2Ev();
extern void _ZN7S2397C12v3Ev();
extern void _ZN7S2397C12v4Ev();
extern void _ZN7S2397C12v5Ev();
static  VTBL_ENTRY vtc_S2397C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2397C1[0]),
  (VTBL_ENTRY)&_ZN7S2397C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2397C1D0Ev,
  (VTBL_ENTRY)&_ZN10S2397C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2397C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN7S2397C32v8Ev,
  (VTBL_ENTRY)&_ZN7S2397C32v9Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v10Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v11Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v21Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v22Ev,
  (VTBL_ENTRY)&_ZN7S2397C33v23Ev,
  (VTBL_ENTRY)&_ZN7S2397C23v24Ev,
  (VTBL_ENTRY)&_ZN7S2397C23v25Ev,
  (VTBL_ENTRY)&_ZN7S2397C23v26Ev,
  (VTBL_ENTRY)&_ZN7S2397C23v27Ev,
  (VTBL_ENTRY)&_ZN7S2397C23v28Ev,
  (VTBL_ENTRY)&_ZN7S2397C23v29Ev,
  (VTBL_ENTRY)&_ZN7S2397C23v30Ev,
  (VTBL_ENTRY)&_ZN7S2397C23v31Ev,
  (VTBL_ENTRY)&_ZN7S2397C23v32Ev,
  (VTBL_ENTRY)&_ZN7S2397C23v33Ev,
  (VTBL_ENTRY)&_ZN7S2397C23v34Ev,
  (VTBL_ENTRY)&_ZN7S2397C23v35Ev,
  (VTBL_ENTRY)&_ZN7S2397C23v36Ev,
  (VTBL_ENTRY)&_ZN7S2397C23v37Ev,
  (VTBL_ENTRY)&_ZN7S2397C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2397C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2397C12v3Ev,
  (VTBL_ENTRY)&_ZN7S2397C12v4Ev,
  (VTBL_ENTRY)&_ZN7S2397C12v5Ev,
};
extern VTBL_ENTRY _ZTI7S2397C1[];
extern  VTBL_ENTRY _ZTV7S2397C1[];
Class_Descriptor cd_S2397C1 = {  "S2397C1", // class name
  bases_S2397C1, 3,
  &(vtc_S2397C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(920,836), // object size
  NSPAIRA(_ZTI7S2397C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2397C1),41, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3806C2  : S3799C3_nt {
  virtual  ~S3806C2(); // _ZN7S3806C2D1Ev
  virtual void  v13(); // _ZN7S3806C23v13Ev
  virtual void  v14(); // _ZN7S3806C23v14Ev
  virtual void  v15(); // _ZN7S3806C23v15Ev
  virtual void  v16(); // _ZN7S3806C23v16Ev
  virtual void  v17(); // _ZN7S3806C23v17Ev
  virtual void  v18(); // _ZN7S3806C23v18Ev
  virtual void  v19(); // _ZN7S3806C23v19Ev
  virtual void  v20(); // _ZN7S3806C23v20Ev
  virtual void  v21(); // _ZN7S3806C23v21Ev
  virtual void  v22(); // _ZN7S3806C23v22Ev
  virtual void  v23(); // _ZN7S3806C23v23Ev
  virtual void  v24(); // _ZN7S3806C23v24Ev
  S3806C2(); // tgen
};
//SIG(-1 S3806C2) C1{ BC2{ vd m Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12}


 S3806C2 ::~S3806C2(){ note_dtor("S3806C2", this);}
void  S3806C2 ::v13(){vfunc_called(this, "_ZN7S3806C23v13Ev");}
void  S3806C2 ::v14(){vfunc_called(this, "_ZN7S3806C23v14Ev");}
void  S3806C2 ::v15(){vfunc_called(this, "_ZN7S3806C23v15Ev");}
void  S3806C2 ::v16(){vfunc_called(this, "_ZN7S3806C23v16Ev");}
void  S3806C2 ::v17(){vfunc_called(this, "_ZN7S3806C23v17Ev");}
void  S3806C2 ::v18(){vfunc_called(this, "_ZN7S3806C23v18Ev");}
void  S3806C2 ::v19(){vfunc_called(this, "_ZN7S3806C23v19Ev");}
void  S3806C2 ::v20(){vfunc_called(this, "_ZN7S3806C23v20Ev");}
void  S3806C2 ::v21(){vfunc_called(this, "_ZN7S3806C23v21Ev");}
void  S3806C2 ::v22(){vfunc_called(this, "_ZN7S3806C23v22Ev");}
void  S3806C2 ::v23(){vfunc_called(this, "_ZN7S3806C23v23Ev");}
void  S3806C2 ::v24(){vfunc_called(this, "_ZN7S3806C23v24Ev");}
S3806C2 ::S3806C2(){ note_ctor("S3806C2", this);} // tgen

static void Test_S3806C2()
{
  extern Class_Descriptor cd_S3806C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S3806C2, buf);
    S3806C2 *dp, &lv = *(dp=new (buf) S3806C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S3806C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3806C2)");
    check_base_class_offset(lv, (S3799C3_nt*), 0, "S3806C2");
    test_class_info(&lv, &cd_S3806C2);
    dp->~S3806C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3806C2(Test_S3806C2, "S3806C2", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN7S3806C2C1Ev();
extern void _ZN7S3806C2D1Ev();
Name_Map name_map_S3806C2[] = {
  NSPAIR(_ZN7S3806C2C1Ev),
  NSPAIR(_ZN7S3806C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3799C3_nt;
extern VTBL_ENTRY _ZTI10S3799C3_nt[];
extern  VTBL_ENTRY _ZTV10S3799C3_nt[];
static Base_Class bases_S3806C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3799C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3806C2[];
extern void _ZN7S3806C2D1Ev();
extern void _ZN7S3806C2D0Ev();
extern void _ZN7S3806C23v13Ev();
extern void _ZN7S3806C23v14Ev();
extern void _ZN7S3806C23v15Ev();
extern void _ZN7S3806C23v16Ev();
extern void _ZN7S3806C23v17Ev();
extern void _ZN7S3806C23v18Ev();
extern void _ZN7S3806C23v19Ev();
extern void _ZN7S3806C23v20Ev();
extern void _ZN7S3806C23v21Ev();
extern void _ZN7S3806C23v22Ev();
extern void _ZN7S3806C23v23Ev();
extern void _ZN7S3806C23v24Ev();
static  VTBL_ENTRY vtc_S3806C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3806C2[0]),
  (VTBL_ENTRY)&_ZN7S3806C2D1Ev,
  (VTBL_ENTRY)&_ZN7S3806C2D0Ev,
  (VTBL_ENTRY)&_ZN7S3806C23v13Ev,
  (VTBL_ENTRY)&_ZN7S3806C23v14Ev,
  (VTBL_ENTRY)&_ZN7S3806C23v15Ev,
  (VTBL_ENTRY)&_ZN7S3806C23v16Ev,
  (VTBL_ENTRY)&_ZN7S3806C23v17Ev,
  (VTBL_ENTRY)&_ZN7S3806C23v18Ev,
  (VTBL_ENTRY)&_ZN7S3806C23v19Ev,
  (VTBL_ENTRY)&_ZN7S3806C23v20Ev,
  (VTBL_ENTRY)&_ZN7S3806C23v21Ev,
  (VTBL_ENTRY)&_ZN7S3806C23v22Ev,
  (VTBL_ENTRY)&_ZN7S3806C23v23Ev,
  (VTBL_ENTRY)&_ZN7S3806C23v24Ev,
};
extern VTBL_ENTRY _ZTI7S3806C2[];
extern  VTBL_ENTRY _ZTV7S3806C2[];
Class_Descriptor cd_S3806C2 = {  "S3806C2", // class name
  bases_S3806C2, 1,
  &(vtc_S3806C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI7S3806C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3806C2),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3806C6_nt  {
  short s3806c6f0[6];
  int s3806c6f1;
};
//SIG(-1 S3806C6_nt) C1{ Fs[6] Fi}



//skip512 S3806C6_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3806C5  {
  int s3806c5f0[2];
  __tsi64 s3806c5f1;
  ::S3806C6_nt s3806c5f2;
  ::S3806C6_nt s3806c5f3;
  ::S3806C6_nt s3806c5f4;
  int s3806c5f5[6];
};
//SIG(-1 S3806C5) C1{ Fi[2] FL FC2{ Fs[6] Fi} FC2 FC2 Fi[6]}



static void Test_S3806C5()
{
  {
    init_simple_test("S3806C5");
    S3806C5 lv;
    check2(sizeof(lv), 88, "sizeof(S3806C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3806C5)");
    check_field_offset(lv, s3806c5f0, 0, "S3806C5.s3806c5f0");
    check_field_offset(lv, s3806c5f1, 8, "S3806C5.s3806c5f1");
    check_field_offset(lv, s3806c5f2, 16, "S3806C5.s3806c5f2");
    check_field_offset(lv, s3806c5f3, 32, "S3806C5.s3806c5f3");
    check_field_offset(lv, s3806c5f4, 48, "S3806C5.s3806c5f4");
    check_field_offset(lv, s3806c5f5, 64, "S3806C5.s3806c5f5");
  }
}
static Arrange_To_Call_Me vS3806C5(Test_S3806C5, "S3806C5", 88);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3806C4  {
  ::S3806C5 s3806c4f0;
  char s3806c4f1[256];
  void *s3806c4f2;
  int s3806c4f3;
};
//SIG(-1 S3806C4) C1{ FC2{ Fi[2] FL FC3{ Fs[6] Fi} FC3 FC3 Fi[6]} Fc[256] Fp Fi}



static void Test_S3806C4()
{
  {
    init_simple_test("S3806C4");
    S3806C4 lv;
    check2(sizeof(lv), ABISELECT(360,352), "sizeof(S3806C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3806C4)");
    check_field_offset(lv, s3806c4f0, 0, "S3806C4.s3806c4f0");
    check_field_offset(lv, s3806c4f1, 88, "S3806C4.s3806c4f1");
    check_field_offset(lv, s3806c4f2, 344, "S3806C4.s3806c4f2");
    check_field_offset(lv, s3806c4f3, ABISELECT(352,348), "S3806C4.s3806c4f3");
  }
}
static Arrange_To_Call_Me vS3806C4(Test_S3806C4, "S3806C4", ABISELECT(360,352));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3806C13  : S3799C3_nt {
  void *s3806c13f0;
  int s3806c13f1;
  virtual  ~S3806C13(); // _ZN8S3806C13D1Ev
  S3806C13(); // tgen
};
//SIG(-1 S3806C13) C1{ BC2{ vd m Fi} vd Fp Fi}


 S3806C13 ::~S3806C13(){ note_dtor("S3806C13", this);}
S3806C13 ::S3806C13(){ note_ctor("S3806C13", this);} // tgen

static void Test_S3806C13()
{
  extern Class_Descriptor cd_S3806C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S3806C13, buf);
    S3806C13 *dp, &lv = *(dp=new (buf) S3806C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S3806C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3806C13)");
    check_base_class_offset(lv, (S3799C3_nt*), 0, "S3806C13");
    check_field_offset(lv, s3806c13f0, ABISELECT(16,8), "S3806C13.s3806c13f0");
    check_field_offset(lv, s3806c13f1, ABISELECT(24,12), "S3806C13.s3806c13f1");
    test_class_info(&lv, &cd_S3806C13);
    dp->~S3806C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3806C13(Test_S3806C13, "S3806C13", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN8S3806C13C1Ev();
extern void _ZN8S3806C13D1Ev();
Name_Map name_map_S3806C13[] = {
  NSPAIR(_ZN8S3806C13C1Ev),
  NSPAIR(_ZN8S3806C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3799C3_nt;
extern VTBL_ENTRY _ZTI10S3799C3_nt[];
extern  VTBL_ENTRY _ZTV10S3799C3_nt[];
static Base_Class bases_S3806C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3799C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S3806C13[];
extern void _ZN8S3806C13D1Ev();
extern void _ZN8S3806C13D0Ev();
static  VTBL_ENTRY vtc_S3806C13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S3806C13[0]),
  (VTBL_ENTRY)&_ZN8S3806C13D1Ev,
  (VTBL_ENTRY)&_ZN8S3806C13D0Ev,
};
extern VTBL_ENTRY _ZTI8S3806C13[];
extern  VTBL_ENTRY _ZTV8S3806C13[];
Class_Descriptor cd_S3806C13 = {  "S3806C13", // class name
  bases_S3806C13, 1,
  &(vtc_S3806C13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI8S3806C13),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S3806C13),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3806C1  : S3806C2 {
  int s3806c1f0;
  ::S3806C4 s3806c1f1;
  ::S2122C25 s3806c1f2;
  char s3806c1f3[2318];
  ::S2122C20_nt s3806c1f4;
  void *s3806c1f5;
  __tsi64 s3806c1f6;
  int s3806c1f7[2];
  ::S3806C13 s3806c1f8;
  virtual  ~S3806C1(); // _ZN7S3806C1D1Ev
  virtual void  v1(); // _ZN7S3806C12v1Ev
  virtual void  v2(); // _ZN7S3806C12v2Ev
  virtual void  v3(); // _ZN7S3806C12v3Ev
  virtual void  v4(); // _ZN7S3806C12v4Ev
  virtual void  v5(); // _ZN7S3806C12v5Ev
  virtual void  v6(); // _ZN7S3806C12v6Ev
  virtual void  v7(); // _ZN7S3806C12v7Ev
  virtual void  v8(); // _ZN7S3806C12v8Ev
  virtual void  v9(); // _ZN7S3806C12v9Ev
  virtual void  v10(); // _ZN7S3806C13v10Ev
  virtual void  v11(); // _ZN7S3806C13v11Ev
  virtual void  v12(); // _ZN7S3806C13v12Ev
  S3806C1(); // tgen
};
//SIG(1 S3806C1) C1{ BC2{ BC3{ vd m Fi} vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fi FC4{ FC5{ Fi[2] FL FC6{ Fs[6] Fi} FC6 FC6 Fi[6]} Fc[256] Fp Fi} FC7{ BC8{ m Fp Fi FC9{ m} FC10{ m}}} Fc[2318] FC11{ m Fp Fi FC12{ m}} Fp FL Fi[2] FC13{ BC3 vd Fp Fi}}


 S3806C1 ::~S3806C1(){ note_dtor("S3806C1", this);}
void  S3806C1 ::v1(){vfunc_called(this, "_ZN7S3806C12v1Ev");}
void  S3806C1 ::v2(){vfunc_called(this, "_ZN7S3806C12v2Ev");}
void  S3806C1 ::v3(){vfunc_called(this, "_ZN7S3806C12v3Ev");}
void  S3806C1 ::v4(){vfunc_called(this, "_ZN7S3806C12v4Ev");}
void  S3806C1 ::v5(){vfunc_called(this, "_ZN7S3806C12v5Ev");}
void  S3806C1 ::v6(){vfunc_called(this, "_ZN7S3806C12v6Ev");}
void  S3806C1 ::v7(){vfunc_called(this, "_ZN7S3806C12v7Ev");}
void  S3806C1 ::v8(){vfunc_called(this, "_ZN7S3806C12v8Ev");}
void  S3806C1 ::v9(){vfunc_called(this, "_ZN7S3806C12v9Ev");}
void  S3806C1 ::v10(){vfunc_called(this, "_ZN7S3806C13v10Ev");}
void  S3806C1 ::v11(){vfunc_called(this, "_ZN7S3806C13v11Ev");}
void  S3806C1 ::v12(){vfunc_called(this, "_ZN7S3806C13v12Ev");}
S3806C1 ::S3806C1(){ note_ctor("S3806C1", this);} // tgen

static void Test_S3806C1()
{
  extern Class_Descriptor cd_S3806C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(349,687)];
    init_test(&cd_S3806C1, buf);
    S3806C1 *dp, &lv = *(dp=new (buf) S3806C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2784,2744), "sizeof(S3806C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3806C1)");
    check_base_class_offset(lv, (S3799C3_nt*)(S3806C2*), 0, "S3806C1");
    check_base_class_offset(lv, (S3806C2*), 0, "S3806C1");
    check_field_offset(lv, s3806c1f0, ABISELECT(12,8), "S3806C1.s3806c1f0");
    check_field_offset(lv, s3806c1f1, ABISELECT(16,12), "S3806C1.s3806c1f1");
    check_field_offset(lv, s3806c1f2, ABISELECT(376,364), "S3806C1.s3806c1f2");
    check_field_offset(lv, s3806c1f3, ABISELECT(392,376), "S3806C1.s3806c1f3");
    check_field_offset(lv, s3806c1f4, ABISELECT(2712,2696), "S3806C1.s3806c1f4");
    check_field_offset(lv, s3806c1f5, ABISELECT(2728,2708), "S3806C1.s3806c1f5");
    check_field_offset(lv, s3806c1f6, ABISELECT(2736,2712), "S3806C1.s3806c1f6");
    check_field_offset(lv, s3806c1f7, ABISELECT(2744,2720), "S3806C1.s3806c1f7");
    check_field_offset(lv, s3806c1f8, ABISELECT(2752,2728), "S3806C1.s3806c1f8");
    test_class_info(&lv, &cd_S3806C1);
    dp->~S3806C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3806C1(Test_S3806C1, "S3806C1", ABISELECT(2784,2744));

#else // __cplusplus

extern void _ZN7S3806C1C1Ev();
extern void _ZN7S3806C1D1Ev();
Name_Map name_map_S3806C1[] = {
  NSPAIR(_ZN7S3806C1C1Ev),
  NSPAIR(_ZN7S3806C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3799C3_nt;
extern VTBL_ENTRY _ZTI10S3799C3_nt[];
extern  VTBL_ENTRY _ZTV10S3799C3_nt[];
extern Class_Descriptor cd_S3806C2;
extern VTBL_ENTRY _ZTI7S3806C2[];
extern  VTBL_ENTRY _ZTV7S3806C2[];
static Base_Class bases_S3806C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3799C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3806C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3806C1[];
extern void _ZN7S3806C1D1Ev();
extern void _ZN7S3806C1D0Ev();
extern void _ZN7S3806C23v13Ev();
extern void _ZN7S3806C23v14Ev();
extern void _ZN7S3806C23v15Ev();
extern void _ZN7S3806C23v16Ev();
extern void _ZN7S3806C23v17Ev();
extern void _ZN7S3806C23v18Ev();
extern void _ZN7S3806C23v19Ev();
extern void _ZN7S3806C23v20Ev();
extern void _ZN7S3806C23v21Ev();
extern void _ZN7S3806C23v22Ev();
extern void _ZN7S3806C23v23Ev();
extern void _ZN7S3806C23v24Ev();
extern void _ZN7S3806C12v1Ev();
extern void _ZN7S3806C12v2Ev();
extern void _ZN7S3806C12v3Ev();
extern void _ZN7S3806C12v4Ev();
extern void _ZN7S3806C12v5Ev();
extern void _ZN7S3806C12v6Ev();
extern void _ZN7S3806C12v7Ev();
extern void _ZN7S3806C12v8Ev();
extern void _ZN7S3806C12v9Ev();
extern void _ZN7S3806C13v10Ev();
extern void _ZN7S3806C13v11Ev();
extern void _ZN7S3806C13v12Ev();
static  VTBL_ENTRY vtc_S3806C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3806C1[0]),
  (VTBL_ENTRY)&_ZN7S3806C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3806C1D0Ev,
  (VTBL_ENTRY)&_ZN7S3806C23v13Ev,
  (VTBL_ENTRY)&_ZN7S3806C23v14Ev,
  (VTBL_ENTRY)&_ZN7S3806C23v15Ev,
  (VTBL_ENTRY)&_ZN7S3806C23v16Ev,
  (VTBL_ENTRY)&_ZN7S3806C23v17Ev,
  (VTBL_ENTRY)&_ZN7S3806C23v18Ev,
  (VTBL_ENTRY)&_ZN7S3806C23v19Ev,
  (VTBL_ENTRY)&_ZN7S3806C23v20Ev,
  (VTBL_ENTRY)&_ZN7S3806C23v21Ev,
  (VTBL_ENTRY)&_ZN7S3806C23v22Ev,
  (VTBL_ENTRY)&_ZN7S3806C23v23Ev,
  (VTBL_ENTRY)&_ZN7S3806C23v24Ev,
  (VTBL_ENTRY)&_ZN7S3806C12v1Ev,
  (VTBL_ENTRY)&_ZN7S3806C12v2Ev,
  (VTBL_ENTRY)&_ZN7S3806C12v3Ev,
  (VTBL_ENTRY)&_ZN7S3806C12v4Ev,
  (VTBL_ENTRY)&_ZN7S3806C12v5Ev,
  (VTBL_ENTRY)&_ZN7S3806C12v6Ev,
  (VTBL_ENTRY)&_ZN7S3806C12v7Ev,
  (VTBL_ENTRY)&_ZN7S3806C12v8Ev,
  (VTBL_ENTRY)&_ZN7S3806C12v9Ev,
  (VTBL_ENTRY)&_ZN7S3806C13v10Ev,
  (VTBL_ENTRY)&_ZN7S3806C13v11Ev,
  (VTBL_ENTRY)&_ZN7S3806C13v12Ev,
};
extern VTBL_ENTRY _ZTI7S3806C1[];
extern  VTBL_ENTRY _ZTV7S3806C1[];
Class_Descriptor cd_S3806C1 = {  "S3806C1", // class name
  bases_S3806C1, 2,
  &(vtc_S3806C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2784,2744), // object size
  NSPAIRA(_ZTI7S3806C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3806C1),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3805C2  : S3799C3_nt {
  virtual  ~S3805C2(); // _ZN7S3805C2D1Ev
  virtual void  v13(); // _ZN7S3805C23v13Ev
  virtual void  v14(); // _ZN7S3805C23v14Ev
  virtual void  v15(); // _ZN7S3805C23v15Ev
  virtual void  v16(); // _ZN7S3805C23v16Ev
  virtual void  v17(); // _ZN7S3805C23v17Ev
  virtual void  v18(); // _ZN7S3805C23v18Ev
  virtual void  v19(); // _ZN7S3805C23v19Ev
  virtual void  v20(); // _ZN7S3805C23v20Ev
  virtual void  v21(); // _ZN7S3805C23v21Ev
  virtual void  v22(); // _ZN7S3805C23v22Ev
  virtual void  v23(); // _ZN7S3805C23v23Ev
  virtual void  v24(); // _ZN7S3805C23v24Ev
  S3805C2(); // tgen
};
//SIG(-1 S3805C2) C1{ BC2{ vd m Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12}


 S3805C2 ::~S3805C2(){ note_dtor("S3805C2", this);}
void  S3805C2 ::v13(){vfunc_called(this, "_ZN7S3805C23v13Ev");}
void  S3805C2 ::v14(){vfunc_called(this, "_ZN7S3805C23v14Ev");}
void  S3805C2 ::v15(){vfunc_called(this, "_ZN7S3805C23v15Ev");}
void  S3805C2 ::v16(){vfunc_called(this, "_ZN7S3805C23v16Ev");}
void  S3805C2 ::v17(){vfunc_called(this, "_ZN7S3805C23v17Ev");}
void  S3805C2 ::v18(){vfunc_called(this, "_ZN7S3805C23v18Ev");}
void  S3805C2 ::v19(){vfunc_called(this, "_ZN7S3805C23v19Ev");}
void  S3805C2 ::v20(){vfunc_called(this, "_ZN7S3805C23v20Ev");}
void  S3805C2 ::v21(){vfunc_called(this, "_ZN7S3805C23v21Ev");}
void  S3805C2 ::v22(){vfunc_called(this, "_ZN7S3805C23v22Ev");}
void  S3805C2 ::v23(){vfunc_called(this, "_ZN7S3805C23v23Ev");}
void  S3805C2 ::v24(){vfunc_called(this, "_ZN7S3805C23v24Ev");}
S3805C2 ::S3805C2(){ note_ctor("S3805C2", this);} // tgen

static void Test_S3805C2()
{
  extern Class_Descriptor cd_S3805C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S3805C2, buf);
    S3805C2 *dp, &lv = *(dp=new (buf) S3805C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S3805C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3805C2)");
    check_base_class_offset(lv, (S3799C3_nt*), 0, "S3805C2");
    test_class_info(&lv, &cd_S3805C2);
    dp->~S3805C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3805C2(Test_S3805C2, "S3805C2", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN7S3805C2C1Ev();
extern void _ZN7S3805C2D1Ev();
Name_Map name_map_S3805C2[] = {
  NSPAIR(_ZN7S3805C2C1Ev),
  NSPAIR(_ZN7S3805C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3799C3_nt;
extern VTBL_ENTRY _ZTI10S3799C3_nt[];
extern  VTBL_ENTRY _ZTV10S3799C3_nt[];
static Base_Class bases_S3805C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3799C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3805C2[];
extern void _ZN7S3805C2D1Ev();
extern void _ZN7S3805C2D0Ev();
extern void _ZN7S3805C23v13Ev();
extern void _ZN7S3805C23v14Ev();
extern void _ZN7S3805C23v15Ev();
extern void _ZN7S3805C23v16Ev();
extern void _ZN7S3805C23v17Ev();
extern void _ZN7S3805C23v18Ev();
extern void _ZN7S3805C23v19Ev();
extern void _ZN7S3805C23v20Ev();
extern void _ZN7S3805C23v21Ev();
extern void _ZN7S3805C23v22Ev();
extern void _ZN7S3805C23v23Ev();
extern void _ZN7S3805C23v24Ev();
static  VTBL_ENTRY vtc_S3805C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3805C2[0]),
  (VTBL_ENTRY)&_ZN7S3805C2D1Ev,
  (VTBL_ENTRY)&_ZN7S3805C2D0Ev,
  (VTBL_ENTRY)&_ZN7S3805C23v13Ev,
  (VTBL_ENTRY)&_ZN7S3805C23v14Ev,
  (VTBL_ENTRY)&_ZN7S3805C23v15Ev,
  (VTBL_ENTRY)&_ZN7S3805C23v16Ev,
  (VTBL_ENTRY)&_ZN7S3805C23v17Ev,
  (VTBL_ENTRY)&_ZN7S3805C23v18Ev,
  (VTBL_ENTRY)&_ZN7S3805C23v19Ev,
  (VTBL_ENTRY)&_ZN7S3805C23v20Ev,
  (VTBL_ENTRY)&_ZN7S3805C23v21Ev,
  (VTBL_ENTRY)&_ZN7S3805C23v22Ev,
  (VTBL_ENTRY)&_ZN7S3805C23v23Ev,
  (VTBL_ENTRY)&_ZN7S3805C23v24Ev,
};
extern VTBL_ENTRY _ZTI7S3805C2[];
extern  VTBL_ENTRY _ZTV7S3805C2[];
Class_Descriptor cd_S3805C2 = {  "S3805C2", // class name
  bases_S3805C2, 1,
  &(vtc_S3805C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI7S3805C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3805C2),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3805C5  {
  int s3805c5f0[2];
  long s3805c5f1;
  ::S3806C6_nt s3805c5f2;
  ::S3806C6_nt s3805c5f3;
  ::S3806C6_nt s3805c5f4;
  int s3805c5f5[6];
};
//SIG(-1 S3805C5) C1{ Fi[2] Fl FC2{ Fs[6] Fi} FC2 FC2 Fi[6]}



static void Test_S3805C5()
{
  {
    init_simple_test("S3805C5");
    S3805C5 lv;
    check2(sizeof(lv), ABISELECT(88,84), "sizeof(S3805C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3805C5)");
    check_field_offset(lv, s3805c5f0, 0, "S3805C5.s3805c5f0");
    check_field_offset(lv, s3805c5f1, 8, "S3805C5.s3805c5f1");
    check_field_offset(lv, s3805c5f2, ABISELECT(16,12), "S3805C5.s3805c5f2");
    check_field_offset(lv, s3805c5f3, ABISELECT(32,28), "S3805C5.s3805c5f3");
    check_field_offset(lv, s3805c5f4, ABISELECT(48,44), "S3805C5.s3805c5f4");
    check_field_offset(lv, s3805c5f5, ABISELECT(64,60), "S3805C5.s3805c5f5");
  }
}
static Arrange_To_Call_Me vS3805C5(Test_S3805C5, "S3805C5", ABISELECT(88,84));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3805C4  {
  ::S3805C5 s3805c4f0;
  char s3805c4f1[256];
  void *s3805c4f2;
  int s3805c4f3;
};
//SIG(-1 S3805C4) C1{ FC2{ Fi[2] Fl FC3{ Fs[6] Fi} FC3 FC3 Fi[6]} Fc[256] Fp Fi}



static void Test_S3805C4()
{
  {
    init_simple_test("S3805C4");
    S3805C4 lv;
    check2(sizeof(lv), ABISELECT(360,348), "sizeof(S3805C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3805C4)");
    check_field_offset(lv, s3805c4f0, 0, "S3805C4.s3805c4f0");
    check_field_offset(lv, s3805c4f1, ABISELECT(88,84), "S3805C4.s3805c4f1");
    check_field_offset(lv, s3805c4f2, ABISELECT(344,340), "S3805C4.s3805c4f2");
    check_field_offset(lv, s3805c4f3, ABISELECT(352,344), "S3805C4.s3805c4f3");
  }
}
static Arrange_To_Call_Me vS3805C4(Test_S3805C4, "S3805C4", ABISELECT(360,348));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3805C1  : S3805C2 {
  int s3805c1f0;
  ::S3805C4 s3805c1f1;
  ::S2122C25 s3805c1f2;
  char s3805c1f3[2318];
  ::S2122C20_nt s3805c1f4;
  void *s3805c1f5;
  __tsi64 s3805c1f6;
  int s3805c1f7[2];
  ::S3806C13 s3805c1f8;
  virtual  ~S3805C1(); // _ZN7S3805C1D1Ev
  virtual void  v1(); // _ZN7S3805C12v1Ev
  virtual void  v2(); // _ZN7S3805C12v2Ev
  virtual void  v3(); // _ZN7S3805C12v3Ev
  virtual void  v4(); // _ZN7S3805C12v4Ev
  virtual void  v5(); // _ZN7S3805C12v5Ev
  virtual void  v6(); // _ZN7S3805C12v6Ev
  virtual void  v7(); // _ZN7S3805C12v7Ev
  virtual void  v8(); // _ZN7S3805C12v8Ev
  virtual void  v9(); // _ZN7S3805C12v9Ev
  virtual void  v10(); // _ZN7S3805C13v10Ev
  virtual void  v11(); // _ZN7S3805C13v11Ev
  virtual void  v12(); // _ZN7S3805C13v12Ev
  S3805C1(); // tgen
};
//SIG(1 S3805C1) C1{ BC2{ BC3{ vd m Fi} vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fi FC4{ FC5{ Fi[2] Fl FC6{ Fs[6] Fi} FC6 FC6 Fi[6]} Fc[256] Fp Fi} FC7{ BC8{ m Fp Fi FC9{ m} FC10{ m}}} Fc[2318] FC11{ m Fp Fi FC12{ m}} Fp FL Fi[2] FC13{ BC3 vd Fp Fi}}


 S3805C1 ::~S3805C1(){ note_dtor("S3805C1", this);}
void  S3805C1 ::v1(){vfunc_called(this, "_ZN7S3805C12v1Ev");}
void  S3805C1 ::v2(){vfunc_called(this, "_ZN7S3805C12v2Ev");}
void  S3805C1 ::v3(){vfunc_called(this, "_ZN7S3805C12v3Ev");}
void  S3805C1 ::v4(){vfunc_called(this, "_ZN7S3805C12v4Ev");}
void  S3805C1 ::v5(){vfunc_called(this, "_ZN7S3805C12v5Ev");}
void  S3805C1 ::v6(){vfunc_called(this, "_ZN7S3805C12v6Ev");}
void  S3805C1 ::v7(){vfunc_called(this, "_ZN7S3805C12v7Ev");}
void  S3805C1 ::v8(){vfunc_called(this, "_ZN7S3805C12v8Ev");}
void  S3805C1 ::v9(){vfunc_called(this, "_ZN7S3805C12v9Ev");}
void  S3805C1 ::v10(){vfunc_called(this, "_ZN7S3805C13v10Ev");}
void  S3805C1 ::v11(){vfunc_called(this, "_ZN7S3805C13v11Ev");}
void  S3805C1 ::v12(){vfunc_called(this, "_ZN7S3805C13v12Ev");}
S3805C1 ::S3805C1(){ note_ctor("S3805C1", this);} // tgen

static void Test_S3805C1()
{
  extern Class_Descriptor cd_S3805C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(349,686)];
    init_test(&cd_S3805C1, buf);
    S3805C1 *dp, &lv = *(dp=new (buf) S3805C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2784,2740), "sizeof(S3805C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3805C1)");
    check_base_class_offset(lv, (S3799C3_nt*)(S3805C2*), 0, "S3805C1");
    check_base_class_offset(lv, (S3805C2*), 0, "S3805C1");
    check_field_offset(lv, s3805c1f0, ABISELECT(12,8), "S3805C1.s3805c1f0");
    check_field_offset(lv, s3805c1f1, ABISELECT(16,12), "S3805C1.s3805c1f1");
    check_field_offset(lv, s3805c1f2, ABISELECT(376,360), "S3805C1.s3805c1f2");
    check_field_offset(lv, s3805c1f3, ABISELECT(392,372), "S3805C1.s3805c1f3");
    check_field_offset(lv, s3805c1f4, ABISELECT(2712,2692), "S3805C1.s3805c1f4");
    check_field_offset(lv, s3805c1f5, ABISELECT(2728,2704), "S3805C1.s3805c1f5");
    check_field_offset(lv, s3805c1f6, ABISELECT(2736,2708), "S3805C1.s3805c1f6");
    check_field_offset(lv, s3805c1f7, ABISELECT(2744,2716), "S3805C1.s3805c1f7");
    check_field_offset(lv, s3805c1f8, ABISELECT(2752,2724), "S3805C1.s3805c1f8");
    test_class_info(&lv, &cd_S3805C1);
    dp->~S3805C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3805C1(Test_S3805C1, "S3805C1", ABISELECT(2784,2740));

#else // __cplusplus

extern void _ZN7S3805C1C1Ev();
extern void _ZN7S3805C1D1Ev();
Name_Map name_map_S3805C1[] = {
  NSPAIR(_ZN7S3805C1C1Ev),
  NSPAIR(_ZN7S3805C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3799C3_nt;
extern VTBL_ENTRY _ZTI10S3799C3_nt[];
extern  VTBL_ENTRY _ZTV10S3799C3_nt[];
extern Class_Descriptor cd_S3805C2;
extern VTBL_ENTRY _ZTI7S3805C2[];
extern  VTBL_ENTRY _ZTV7S3805C2[];
static Base_Class bases_S3805C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3799C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3805C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3805C1[];
extern void _ZN7S3805C1D1Ev();
extern void _ZN7S3805C1D0Ev();
extern void _ZN7S3805C23v13Ev();
extern void _ZN7S3805C23v14Ev();
extern void _ZN7S3805C23v15Ev();
extern void _ZN7S3805C23v16Ev();
extern void _ZN7S3805C23v17Ev();
extern void _ZN7S3805C23v18Ev();
extern void _ZN7S3805C23v19Ev();
extern void _ZN7S3805C23v20Ev();
extern void _ZN7S3805C23v21Ev();
extern void _ZN7S3805C23v22Ev();
extern void _ZN7S3805C23v23Ev();
extern void _ZN7S3805C23v24Ev();
extern void _ZN7S3805C12v1Ev();
extern void _ZN7S3805C12v2Ev();
extern void _ZN7S3805C12v3Ev();
extern void _ZN7S3805C12v4Ev();
extern void _ZN7S3805C12v5Ev();
extern void _ZN7S3805C12v6Ev();
extern void _ZN7S3805C12v7Ev();
extern void _ZN7S3805C12v8Ev();
extern void _ZN7S3805C12v9Ev();
extern void _ZN7S3805C13v10Ev();
extern void _ZN7S3805C13v11Ev();
extern void _ZN7S3805C13v12Ev();
static  VTBL_ENTRY vtc_S3805C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3805C1[0]),
  (VTBL_ENTRY)&_ZN7S3805C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3805C1D0Ev,
  (VTBL_ENTRY)&_ZN7S3805C23v13Ev,
  (VTBL_ENTRY)&_ZN7S3805C23v14Ev,
  (VTBL_ENTRY)&_ZN7S3805C23v15Ev,
  (VTBL_ENTRY)&_ZN7S3805C23v16Ev,
  (VTBL_ENTRY)&_ZN7S3805C23v17Ev,
  (VTBL_ENTRY)&_ZN7S3805C23v18Ev,
  (VTBL_ENTRY)&_ZN7S3805C23v19Ev,
  (VTBL_ENTRY)&_ZN7S3805C23v20Ev,
  (VTBL_ENTRY)&_ZN7S3805C23v21Ev,
  (VTBL_ENTRY)&_ZN7S3805C23v22Ev,
  (VTBL_ENTRY)&_ZN7S3805C23v23Ev,
  (VTBL_ENTRY)&_ZN7S3805C23v24Ev,
  (VTBL_ENTRY)&_ZN7S3805C12v1Ev,
  (VTBL_ENTRY)&_ZN7S3805C12v2Ev,
  (VTBL_ENTRY)&_ZN7S3805C12v3Ev,
  (VTBL_ENTRY)&_ZN7S3805C12v4Ev,
  (VTBL_ENTRY)&_ZN7S3805C12v5Ev,
  (VTBL_ENTRY)&_ZN7S3805C12v6Ev,
  (VTBL_ENTRY)&_ZN7S3805C12v7Ev,
  (VTBL_ENTRY)&_ZN7S3805C12v8Ev,
  (VTBL_ENTRY)&_ZN7S3805C12v9Ev,
  (VTBL_ENTRY)&_ZN7S3805C13v10Ev,
  (VTBL_ENTRY)&_ZN7S3805C13v11Ev,
  (VTBL_ENTRY)&_ZN7S3805C13v12Ev,
};
extern VTBL_ENTRY _ZTI7S3805C1[];
extern  VTBL_ENTRY _ZTV7S3805C1[];
Class_Descriptor cd_S3805C1 = {  "S3805C1", // class name
  bases_S3805C1, 2,
  &(vtc_S3805C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2784,2740), // object size
  NSPAIRA(_ZTI7S3805C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3805C1),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20993C4_nt  {
  ::S7167C16_nt s20993c4f0;
  void  mf20993c4(); // _ZN11S20993C4_nt9mf20993c4Ev
};
//SIG(-1 S20993C4_nt) C1{ m FC2{}}


void  S20993C4_nt ::mf20993c4(){}

//skip512 S20993C4_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI11S20993C4_nt[];
VTBL_ENTRY *P__ZTI11S20993C4_nt = _ZTI11S20993C4_nt; 
Class_Descriptor cd_S20993C4_nt = {  "S20993C4_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI11S20993C4_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20993C7_nt  : virtual S2122C38 {
  ~S20993C7_nt(); // tgen
  S20993C7_nt(); // tgen
};
//SIG(-1 S20993C7_nt) C1{ VBC2{ m}}


S20993C7_nt ::~S20993C7_nt(){ note_dtor("S20993C7_nt", this);} // tgen
S20993C7_nt ::S20993C7_nt(){ note_ctor("S20993C7_nt", this);} // tgen

//skip512 S20993C7_nt

#else // __cplusplus

extern void _ZN11S20993C7_ntC1Ev();
extern void _ZN11S20993C7_ntD1Ev();
Name_Map name_map_S20993C7_nt[] = {
  NSPAIR(_ZN11S20993C7_ntC1Ev),
  NSPAIR(_ZN11S20993C7_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2122C38;
extern VTBL_ENTRY _ZTI8S2122C38[];
static Base_Class bases_S20993C7_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2122C38,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI11S20993C7_nt[];
static  VTBL_ENTRY vtc_S20993C7_nt[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI11S20993C7_nt[0]),
};
extern VTBL_ENTRY _ZTV11S20993C7_nt[];
static  VTT_ENTRY vtt_S20993C7_nt[] = {
  {&(_ZTV11S20993C7_nt[3]),  3,3},
};
extern VTBL_ENTRY _ZTI11S20993C7_nt[];
VTBL_ENTRY *P__ZTI11S20993C7_nt = _ZTI11S20993C7_nt; 
extern  VTBL_ENTRY _ZTV11S20993C7_nt[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT11S20993C7_nt[];
Class_Descriptor cd_S20993C7_nt = {  "S20993C7_nt", // class name
  bases_S20993C7_nt, 1,
  &(vtc_S20993C7_nt[0]), // expected_vtbl_contents
  &(vtt_S20993C7_nt[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S20993C7_nt),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV11S20993C7_nt),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT11S20993C7_nt),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20993C3  : virtual S20993C4_nt , S2122C38 , virtual S20993C7_nt {
  ::S7167C16_nt s20993c3f0;
  ~S20993C3(); // tgen
  S20993C3(); // tgen
};
//SIG(-1 S20993C3) C1{ VBC2{ m FC3{}} BC4{ m} VBC5{ VBC4} FC3}


S20993C3 ::~S20993C3(){ note_dtor("S20993C3", this);} // tgen
S20993C3 ::S20993C3(){ note_ctor("S20993C3", this);} // tgen

static void Test_S20993C3()
{
  extern Class_Descriptor cd_S20993C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S20993C3, buf);
    S20993C3 *dp, &lv = *(dp=new (buf) S20993C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S20993C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20993C3)");
    check_base_class_offset(lv, (S20993C4_nt*), ABISELECT(9,5), "S20993C3");
    /*is_ambiguous_... S20993C3::S2122C38 */ AMB_check_base_class_offset(lv, (S2122C38*), 0, "S20993C3");
    check_base_class_offset(lv, (S2122C38*)(S20993C7_nt*), ABISELECT(10,6), "S20993C3");
    check_base_class_offset(lv, (S20993C7_nt*), 0, "S20993C3");
    check_field_offset(lv, s20993c3f0, ABISELECT(8,4), "S20993C3.s20993c3f0");
    test_class_info(&lv, &cd_S20993C3);
    dp->~S20993C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20993C3(Test_S20993C3, "S20993C3", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN8S20993C3C1Ev();
extern void _ZN8S20993C3D1Ev();
Name_Map name_map_S20993C3[] = {
  NSPAIR(_ZN8S20993C3C1Ev),
  NSPAIR(_ZN8S20993C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20993C4_nt;
extern VTBL_ENTRY _ZTI11S20993C4_nt[];
extern Class_Descriptor cd_S2122C38;
extern VTBL_ENTRY _ZTI8S2122C38[];
extern Class_Descriptor cd_S2122C38;
extern VTBL_ENTRY _ZTI8S2122C38[];
extern Class_Descriptor cd_S20993C7_nt;
extern VTBL_ENTRY _ZTI11S20993C7_nt[];
extern  VTBL_ENTRY _ZTV11S20993C7_nt[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT11S20993C7_nt[];
static Base_Class bases_S20993C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20993C4_nt,    ABISELECT(9,5), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2122C38,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2122C38,    ABISELECT(10,6), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20993C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20993C3[];
static  VTBL_ENTRY vtc_S20993C3[] = {
  0,
  ABISELECT(9,5),
  ABISELECT(10,6),
  0,
  (VTBL_ENTRY)&(_ZTI8S20993C3[0]),
};
extern VTBL_ENTRY _ZTV8S20993C3[];
static  VTBL_ENTRY _tg__ZTV11S20993C7_nt__8S20993C3[] = {
  ABISELECT(10,6),
  0,
  (VTBL_ENTRY)&(_ZTI11S20993C7_nt[0]),
};
static  VTT_ENTRY vtt_S20993C3[] = {
  {&(_ZTV8S20993C3[5]),  5,5},
  {&(_ZTV8S20993C3[5]),  5,5},
  {&(_tg__ZTV11S20993C7_nt__8S20993C3[3]),  3,3},
};
extern VTBL_ENTRY _ZTI8S20993C3[];
extern  VTBL_ENTRY _ZTV8S20993C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20993C3[];
Class_Descriptor cd_S20993C3 = {  "S20993C3", // class name
  bases_S20993C3, 4,
  &(vtc_S20993C3[0]), // expected_vtbl_contents
  &(vtt_S20993C3[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI8S20993C3),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S20993C3),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20993C3),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20993C9  : S2122C38 , S20993C7_nt {
  char s20993c9f0;
  long double s20993c9f1;
  ::S20993C7_nt s20993c9f2[3];
  char s20993c9f3;
  ~S20993C9(); // tgen
  S20993C9(); // tgen
};
//SIG(-1 S20993C9) C1{ BC2{ m} BC3{ VBC2} Fc FD FC3[3] Fc}


S20993C9 ::~S20993C9(){ note_dtor("S20993C9", this);} // tgen
S20993C9 ::S20993C9(){ note_ctor("S20993C9", this);} // tgen

static void Test_S20993C9()
{
  extern Class_Descriptor cd_S20993C9;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(5,10)];
    init_test(&cd_S20993C9, buf);
    S20993C9 *dp, &lv = *(dp=new (buf) S20993C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(S20993C9)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20993C9)");
    /*is_ambiguous_... S20993C9::S2122C38 */ AMB_check_base_class_offset(lv, (S2122C38*), 0, "S20993C9");
    check_base_class_offset(lv, (S2122C38*)(S20993C7_nt*), ABISELECT(57,33), "S20993C9");
    check_base_class_offset(lv, (S20993C7_nt*), 0, "S20993C9");
    check_field_offset(lv, s20993c9f0, ABISELECT(8,4), "S20993C9.s20993c9f0");
    check_field_offset(lv, s20993c9f1, ABISELECT(16,8), "S20993C9.s20993c9f1");
    check_field_offset(lv, s20993c9f2, ABISELECT(32,20), "S20993C9.s20993c9f2");
    check_field_offset(lv, s20993c9f3, ABISELECT(56,32), "S20993C9.s20993c9f3");
    test_class_info(&lv, &cd_S20993C9);
    dp->~S20993C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20993C9(Test_S20993C9, "S20993C9", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN8S20993C9C1Ev();
extern void _ZN8S20993C9D1Ev();
Name_Map name_map_S20993C9[] = {
  NSPAIR(_ZN8S20993C9C1Ev),
  NSPAIR(_ZN8S20993C9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2122C38;
extern VTBL_ENTRY _ZTI8S2122C38[];
extern Class_Descriptor cd_S2122C38;
extern VTBL_ENTRY _ZTI8S2122C38[];
extern Class_Descriptor cd_S20993C7_nt;
extern VTBL_ENTRY _ZTI11S20993C7_nt[];
extern  VTBL_ENTRY _ZTV11S20993C7_nt[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT11S20993C7_nt[];
static Base_Class bases_S20993C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2122C38,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2122C38,    ABISELECT(57,33), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S20993C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20993C9[];
static  VTBL_ENTRY vtc_S20993C9[] = {
  ABISELECT(57,33),
  0,
  (VTBL_ENTRY)&(_ZTI8S20993C9[0]),
};
extern VTBL_ENTRY _ZTV8S20993C9[];
static  VTBL_ENTRY _tg__ZTV11S20993C7_nt__8S20993C9[] = {
  ABISELECT(57,33),
  0,
  (VTBL_ENTRY)&(_ZTI11S20993C7_nt[0]),
};
static  VTT_ENTRY vtt_S20993C9[] = {
  {&(_ZTV8S20993C9[3]),  3,3},
  {&(_tg__ZTV11S20993C7_nt__8S20993C9[3]),  3,3},
};
extern VTBL_ENTRY _ZTI8S20993C9[];
extern  VTBL_ENTRY _ZTV8S20993C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20993C9[];
Class_Descriptor cd_S20993C9 = {  "S20993C9", // class name
  bases_S20993C9, 3,
  &(vtc_S20993C9[0]), // expected_vtbl_contents
  &(vtt_S20993C9[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI8S20993C9),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S20993C9),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20993C9),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20993C10_nt  {
  ::S7167C16_nt s20993c10f0;
  void  mf20993c10(); // _ZN12S20993C10_nt10mf20993c10Ev
  virtual  ~S20993C10_nt(); // _ZN12S20993C10_ntD1Ev
  S20993C10_nt(); // tgen
};
//SIG(-1 S20993C10_nt) C1{ vd m FC2{}}


void  S20993C10_nt ::mf20993c10(){}
 S20993C10_nt ::~S20993C10_nt(){ note_dtor("S20993C10_nt", this);}
S20993C10_nt ::S20993C10_nt(){ note_ctor("S20993C10_nt", this);} // tgen

//skip512 S20993C10_nt

#else // __cplusplus

extern void _ZN12S20993C10_ntC1Ev();
extern void _ZN12S20993C10_ntD1Ev();
Name_Map name_map_S20993C10_nt[] = {
  NSPAIR(_ZN12S20993C10_ntC1Ev),
  NSPAIR(_ZN12S20993C10_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI12S20993C10_nt[];
extern void _ZN12S20993C10_ntD1Ev();
extern void _ZN12S20993C10_ntD0Ev();
static  VTBL_ENTRY vtc_S20993C10_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S20993C10_nt[0]),
  (VTBL_ENTRY)&_ZN12S20993C10_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S20993C10_ntD0Ev,
};
extern VTBL_ENTRY _ZTI12S20993C10_nt[];
VTBL_ENTRY *P__ZTI12S20993C10_nt = _ZTI12S20993C10_nt; 
extern  VTBL_ENTRY _ZTV12S20993C10_nt[];
Class_Descriptor cd_S20993C10_nt = {  "S20993C10_nt", // class name
  0,0,//no base classes
  &(vtc_S20993C10_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI12S20993C10_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV12S20993C10_nt),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20993C8  : virtual S2122C38 , virtual S20993C9 , virtual S20993C10_nt {
  virtual  ~S20993C8(); // _ZN8S20993C8D2Ev
  S20993C8(); // tgen
};
//SIG(-1 S20993C8) C1{ VBC2{ m} VBC3{ BC2 BC4{ VBC2} Fc FD FC4[3] Fc} VBC5{ vd m FC6{}} vd}


 S20993C8 ::~S20993C8(){ note_dtor("S20993C8", this);}
S20993C8 ::S20993C8(){ note_ctor("S20993C8", this);} // tgen

static void Test_S20993C8()
{
  extern Class_Descriptor cd_S20993C8;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(7,13)];
    init_test(&cd_S20993C8, buf);
    S20993C8 *dp, &lv = *(dp=new (buf) S20993C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,48), "sizeof(S20993C8)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20993C8)");
    /*is_ambiguous_... S20993C8::S2122C38 */ AMB_check_base_class_offset(lv, (S2122C38*), 0, "S20993C8");
    check_base_class_offset(lv, (S2122C38*)(S20993C7_nt*)(S20993C9*), 0, "S20993C8");
    /*is_ambiguous_... S20993C9::S2122C38 */ AMB_check_base_class_offset(lv, (S2122C38*)(S20993C9*), ABISELECT(16,4), "S20993C8");
    check_base_class_offset(lv, (S20993C7_nt*)(S20993C9*), ABISELECT(16,4), "S20993C8");
    check_base_class_offset(lv, (S20993C9*), ABISELECT(16,4), "S20993C8");
    check_base_class_offset(lv, (S20993C10_nt*), ABISELECT(80,40), "S20993C8");
    test_class_info(&lv, &cd_S20993C8);
    dp->~S20993C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20993C8(Test_S20993C8, "S20993C8", ABISELECT(96,48));

#else // __cplusplus

extern void _ZN8S20993C8C1Ev();
extern void _ZN8S20993C8D2Ev();
Name_Map name_map_S20993C8[] = {
  NSPAIR(_ZN8S20993C8C1Ev),
  NSPAIR(_ZN8S20993C8D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2122C38;
extern VTBL_ENTRY _ZTI8S2122C38[];
extern Class_Descriptor cd_S2122C38;
extern VTBL_ENTRY _ZTI8S2122C38[];
extern Class_Descriptor cd_S20993C7_nt;
extern VTBL_ENTRY _ZTI11S20993C7_nt[];
extern  VTBL_ENTRY _ZTV11S20993C7_nt[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT11S20993C7_nt[];
extern Class_Descriptor cd_S20993C9;
extern VTBL_ENTRY _ZTI8S20993C9[];
extern  VTBL_ENTRY _ZTV8S20993C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20993C9[];
extern Class_Descriptor cd_S20993C10_nt;
extern VTBL_ENTRY _ZTI12S20993C10_nt[];
extern  VTBL_ENTRY _ZTV12S20993C10_nt[];
static Base_Class bases_S20993C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2122C38,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2122C38,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20993C7_nt,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20993C9,    ABISELECT(16,4), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20993C10_nt,    ABISELECT(80,40), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20993C8[];
extern void _ZN8S20993C8D1Ev();
extern void _ZN8S20993C8D0Ev();
extern void ABISELECT(_ZTv0_n24_N8S20993C8D1Ev,_ZTv0_n12_N8S20993C8D1Ev)();
extern void ABISELECT(_ZThn80_N8S20993C8D1Ev,_ZThn40_N8S20993C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20993C8D0Ev,_ZTv0_n12_N8S20993C8D0Ev)();
extern void ABISELECT(_ZThn80_N8S20993C8D0Ev,_ZThn40_N8S20993C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S20993C8[] = {
  ABISELECT(80,40),
  ABISELECT(16,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S20993C8[0]),
  (VTBL_ENTRY)&_ZN8S20993C8D1Ev,
  (VTBL_ENTRY)&_ZN8S20993C8D0Ev,
  ABISELECT(-16,-4),
  ABISELECT(-16,-4),
  (VTBL_ENTRY)&(_ZTI8S20993C8[0]),
  ABISELECT(-80,-40),
  ABISELECT(-80,-40),
  (VTBL_ENTRY)&(_ZTI8S20993C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20993C8D1Ev,_ZTv0_n12_N8S20993C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20993C8D0Ev,_ZTv0_n12_N8S20993C8D0Ev),
};
extern VTBL_ENTRY _ZTV8S20993C8[];
static  VTBL_ENTRY _tg__ZTV8S20993C9__8S20993C8[] = {
  ABISELECT(-16,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S20993C9[0]),
};
static  VTBL_ENTRY _tg__ZTV11S20993C7_nt8S20993C9__8S20993C8[] = {
  ABISELECT(-16,-4),
  0,
  (VTBL_ENTRY)&(_ZTI11S20993C7_nt[0]),
};
static  VTT_ENTRY vtt_S20993C8[] = {
  {&(_ZTV8S20993C8[5]),  5,15},
  {&(_ZTV8S20993C8[10]),  10,15},
  {&(_ZTV8S20993C8[13]),  13,15},
  {&(_tg__ZTV8S20993C9__8S20993C8[3]),  3,3},
  {&(_tg__ZTV11S20993C7_nt8S20993C9__8S20993C8[3]),  3,3},
};
extern VTBL_ENTRY _ZTI8S20993C8[];
extern  VTBL_ENTRY _ZTV8S20993C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20993C8[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20993C8D0Ev,_ZTv0_n12_N8S20993C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N8S20993C8D0Ev,_ZThn40_N8S20993C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20993C8D1Ev,_ZTv0_n12_N8S20993C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N8S20993C8D1Ev,_ZThn40_N8S20993C8D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20993C8 = {  "S20993C8", // class name
  bases_S20993C8, 5,
  &(vtc_S20993C8[0]), // expected_vtbl_contents
  &(vtt_S20993C8[0]), // expected_vtt_contents
  ABISELECT(96,48), // object size
  NSPAIRA(_ZTI8S20993C8),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S20993C8),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20993C8),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20993C13  : S20993C7_nt , S20993C10_nt , S2122C38 {
  ~S20993C13(); // tgen
  S20993C13(); // tgen
};
//SIG(-1 S20993C13) C1{ BC2{ VBC3{ m}} BC4{ vd m FC5{}} BC3}


S20993C13 ::~S20993C13(){ note_dtor("S20993C13", this);} // tgen
S20993C13 ::S20993C13(){ note_ctor("S20993C13", this);} // tgen

static void Test_S20993C13()
{
  extern Class_Descriptor cd_S20993C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S20993C13, buf);
    S20993C13 *dp, &lv = *(dp=new (buf) S20993C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S20993C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20993C13)");
    check_base_class_offset(lv, (S2122C38*)(S20993C7_nt*), ABISELECT(17,9), "S20993C13");
    check_base_class_offset(lv, (S20993C7_nt*), 0, "S20993C13");
    check_base_class_offset(lv, (S20993C10_nt*), ABISELECT(8,4), "S20993C13");
    /*is_ambiguous_... S20993C13::S2122C38 */ AMB_check_base_class_offset(lv, (S2122C38*), 0, "S20993C13");
    test_class_info(&lv, &cd_S20993C13);
    dp->~S20993C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20993C13(Test_S20993C13, "S20993C13", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN9S20993C13C1Ev();
extern void _ZN9S20993C13D1Ev();
Name_Map name_map_S20993C13[] = {
  NSPAIR(_ZN9S20993C13C1Ev),
  NSPAIR(_ZN9S20993C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2122C38;
extern VTBL_ENTRY _ZTI8S2122C38[];
extern Class_Descriptor cd_S20993C7_nt;
extern VTBL_ENTRY _ZTI11S20993C7_nt[];
extern  VTBL_ENTRY _ZTV11S20993C7_nt[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT11S20993C7_nt[];
extern Class_Descriptor cd_S20993C10_nt;
extern VTBL_ENTRY _ZTI12S20993C10_nt[];
extern  VTBL_ENTRY _ZTV12S20993C10_nt[];
extern Class_Descriptor cd_S2122C38;
extern VTBL_ENTRY _ZTI8S2122C38[];
static Base_Class bases_S20993C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2122C38,    ABISELECT(17,9), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20993C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20993C10_nt,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2122C38,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20993C13[];
extern void _ZN9S20993C13D1Ev();
extern void _ZN9S20993C13D0Ev();
extern void ABISELECT(_ZThn8_N9S20993C13D1Ev,_ZThn4_N9S20993C13D1Ev)();
extern void ABISELECT(_ZThn8_N9S20993C13D0Ev,_ZThn4_N9S20993C13D0Ev)();
static  VTBL_ENTRY vtc_S20993C13[] = {
  ABISELECT(17,9),
  0,
  (VTBL_ENTRY)&(_ZTI9S20993C13[0]),
  (VTBL_ENTRY)&_ZN9S20993C13D1Ev,
  (VTBL_ENTRY)&_ZN9S20993C13D0Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S20993C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S20993C13D1Ev,_ZThn4_N9S20993C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S20993C13D0Ev,_ZThn4_N9S20993C13D0Ev),
};
extern VTBL_ENTRY _ZTV9S20993C13[];
static  VTBL_ENTRY _tg__ZTV11S20993C7_nt__9S20993C13[] = {
  ABISELECT(17,9),
  0,
  (VTBL_ENTRY)&(_ZTI11S20993C7_nt[0]),
};
static  VTT_ENTRY vtt_S20993C13[] = {
  {&(_ZTV9S20993C13[3]),  3,9},
  {&(_tg__ZTV11S20993C7_nt__9S20993C13[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20993C13[];
extern  VTBL_ENTRY _ZTV9S20993C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20993C13[];
Class_Descriptor cd_S20993C13 = {  "S20993C13", // class name
  bases_S20993C13, 4,
  &(vtc_S20993C13[0]), // expected_vtbl_contents
  &(vtt_S20993C13[0]), // expected_vtt_contents
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI9S20993C13),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S20993C13),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20993C13),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20993C14  : virtual S20993C13 , S20993C9 , S20993C10_nt , S2122C38 {
  void *s20993c14f0;
  long s20993c14f1;
  virtual  ~S20993C14(); // _ZN9S20993C14D2Ev
  S20993C14(); // tgen
};
//SIG(-1 S20993C14) C1{ VBC2{ BC3{ VBC4{ m}} BC5{ vd m FC6{}} BC4} BC7{ BC4 BC3 Fc FD FC3[3] Fc} BC5 BC4 vd Fp Fl}


 S20993C14 ::~S20993C14(){ note_dtor("S20993C14", this);}
S20993C14 ::S20993C14(){ note_ctor("S20993C14", this);} // tgen

static void Test_S20993C14()
{
  extern Class_Descriptor cd_S20993C14;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(9,17)];
    init_test(&cd_S20993C14, buf);
    S20993C14 *dp, &lv = *(dp=new (buf) S20993C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,64), "sizeof(S20993C14)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20993C14)");
    check_base_class_offset(lv, (S2122C38*)(S20993C7_nt*)(S20993C13*), ABISELECT(113,61), "S20993C14");
    check_base_class_offset(lv, (S2122C38*)(S20993C7_nt*)(S20993C9*), ABISELECT(113,61), "S20993C14");
    check_base_class_offset(lv, (S20993C7_nt*)(S20993C13*), ABISELECT(96,52), "S20993C14");
    check_base_class_offset(lv, (S20993C10_nt*)(S20993C13*), ABISELECT(104,56), "S20993C14");
    /*is_ambiguous_... S20993C13::S2122C38 */ AMB_check_base_class_offset(lv, (S2122C38*)(S20993C13*), ABISELECT(96,52), "S20993C14");
    check_base_class_offset(lv, (S20993C13*), ABISELECT(96,52), "S20993C14");
    /*is_ambiguous_... S20993C9::S2122C38 */ AMB_check_base_class_offset(lv, (S2122C38*)(S20993C9*), 0, "S20993C14");
    check_base_class_offset(lv, (S20993C7_nt*)(S20993C9*), 0, "S20993C14");
    check_base_class_offset(lv, (S20993C9*), 0, "S20993C14");
    /*is_ambiguous_... S20993C14::S20993C10_nt */ AMB_check_base_class_offset(lv, (S20993C10_nt*), ABISELECT(64,36), "S20993C14");
    /*is_ambiguous_... S20993C14::S2122C38 */ AMB_check_base_class_offset(lv, (S2122C38*), ABISELECT(73,41), "S20993C14");
    check_field_offset(lv, s20993c14f0, ABISELECT(80,44), "S20993C14.s20993c14f0");
    check_field_offset(lv, s20993c14f1, ABISELECT(88,48), "S20993C14.s20993c14f1");
    test_class_info(&lv, &cd_S20993C14);
    dp->~S20993C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20993C14(Test_S20993C14, "S20993C14", ABISELECT(128,64));

#else // __cplusplus

extern void _ZN9S20993C14C1Ev();
extern void _ZN9S20993C14D2Ev();
Name_Map name_map_S20993C14[] = {
  NSPAIR(_ZN9S20993C14C1Ev),
  NSPAIR(_ZN9S20993C14D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2122C38;
extern VTBL_ENTRY _ZTI8S2122C38[];
extern Class_Descriptor cd_S20993C7_nt;
extern VTBL_ENTRY _ZTI11S20993C7_nt[];
extern  VTBL_ENTRY _ZTV11S20993C7_nt[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT11S20993C7_nt[];
extern Class_Descriptor cd_S20993C10_nt;
extern VTBL_ENTRY _ZTI12S20993C10_nt[];
extern  VTBL_ENTRY _ZTV12S20993C10_nt[];
extern Class_Descriptor cd_S2122C38;
extern VTBL_ENTRY _ZTI8S2122C38[];
extern Class_Descriptor cd_S20993C13;
extern VTBL_ENTRY _ZTI9S20993C13[];
extern  VTBL_ENTRY _ZTV9S20993C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20993C13[];
extern Class_Descriptor cd_S2122C38;
extern VTBL_ENTRY _ZTI8S2122C38[];
extern Class_Descriptor cd_S20993C7_nt;
extern VTBL_ENTRY _ZTI11S20993C7_nt[];
extern  VTBL_ENTRY _ZTV11S20993C7_nt[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT11S20993C7_nt[];
extern Class_Descriptor cd_S20993C9;
extern VTBL_ENTRY _ZTI8S20993C9[];
extern  VTBL_ENTRY _ZTV8S20993C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20993C9[];
extern Class_Descriptor cd_S20993C10_nt;
extern VTBL_ENTRY _ZTI12S20993C10_nt[];
extern  VTBL_ENTRY _ZTV12S20993C10_nt[];
extern Class_Descriptor cd_S2122C38;
extern VTBL_ENTRY _ZTI8S2122C38[];
static Base_Class bases_S20993C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2122C38,    ABISELECT(113,61), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20993C7_nt,    ABISELECT(96,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20993C10_nt,    ABISELECT(104,56), //bcp->offset
    16, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2122C38,    ABISELECT(96,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20993C13,    ABISELECT(96,52), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2122C38,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20993C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20993C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20993C10_nt,    ABISELECT(64,36), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2122C38,    ABISELECT(73,41), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20993C14[];
extern void _ZN9S20993C14D1Ev();
extern void _ZN9S20993C14D0Ev();
extern void ABISELECT(_ZThn64_N9S20993C14D1Ev,_ZThn36_N9S20993C14D1Ev)();
extern void ABISELECT(_ZThn64_N9S20993C14D0Ev,_ZThn36_N9S20993C14D0Ev)();
extern void ABISELECT(_ZTv0_n32_N9S20993C14D1Ev,_ZTv0_n16_N9S20993C14D1Ev)();
extern void ABISELECT(_ZThn96_N9S20993C14D1Ev,_ZThn52_N9S20993C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20993C14D0Ev,_ZTv0_n16_N9S20993C14D0Ev)();
extern void ABISELECT(_ZThn96_N9S20993C14D0Ev,_ZThn52_N9S20993C14D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn8_n32_N9S20993C14D1Ev,_ZTvn4_n16_N9S20993C14D1Ev)();
extern void ABISELECT(_ZTvn8_n32_N9S20993C14D0Ev,_ZTvn4_n16_N9S20993C14D0Ev)();
static  VTBL_ENTRY vtc_S20993C14[] = {
  ABISELECT(96,52),
  ABISELECT(113,61),
  0,
  (VTBL_ENTRY)&(_ZTI9S20993C14[0]),
  (VTBL_ENTRY)&_ZN9S20993C14D1Ev,
  (VTBL_ENTRY)&_ZN9S20993C14D0Ev,
  ABISELECT(-64,-36),
  (VTBL_ENTRY)&(_ZTI9S20993C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S20993C14D1Ev,_ZThn36_N9S20993C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S20993C14D0Ev,_ZThn36_N9S20993C14D0Ev),
  ABISELECT(-96,-52),
  ABISELECT(17,9),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI9S20993C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20993C14D1Ev,_ZTv0_n16_N9S20993C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20993C14D0Ev,_ZTv0_n16_N9S20993C14D0Ev),
  ABISELECT(-104,-56),
  (VTBL_ENTRY)&(_ZTI9S20993C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S20993C14D1Ev,_ZTvn4_n16_N9S20993C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n32_N9S20993C14D0Ev,_ZTvn4_n16_N9S20993C14D0Ev),
};
extern VTBL_ENTRY _ZTV9S20993C14[];
static  VTBL_ENTRY _tg__ZTV8S20993C9__9S20993C14[] = {
  ABISELECT(113,61),
  0,
  (VTBL_ENTRY)&(_ZTI8S20993C9[0]),
};
static  VTBL_ENTRY _tg__ZTV11S20993C7_nt8S20993C9__A1__9S20993C14[] = {
  ABISELECT(113,61),
  0,
  (VTBL_ENTRY)&(_ZTI11S20993C7_nt[0]),
};
extern void _ZN9S20993C13D1Ev();
extern void _ZN9S20993C13D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20993C13__9S20993C14[] = {
  ABISELECT(17,9),
  0,
  (VTBL_ENTRY)&(_ZTI9S20993C13[0]),
  (VTBL_ENTRY)&_ZN9S20993C13D1Ev,
  (VTBL_ENTRY)&_ZN9S20993C13D0Ev,
};
static  VTBL_ENTRY _tg__ZTV11S20993C7_nt9S20993C13__9S20993C14[] = {
  ABISELECT(17,9),
  0,
  (VTBL_ENTRY)&(_ZTI11S20993C7_nt[0]),
};
static  VTT_ENTRY vtt_S20993C14[] = {
  {&(_ZTV9S20993C14[4]),  4,20},
  {&(_tg__ZTV8S20993C9__9S20993C14[3]),  3,3},
  {&(_tg__ZTV11S20993C7_nt8S20993C9__A1__9S20993C14[3]),  3,3},
  {&(_ZTV9S20993C14[14]),  14,20},
  {&(_ZTV9S20993C14[18]),  18,20},
  {&(_tg__ZTV9S20993C13__9S20993C14[3]),  3,5},
  {&(_tg__ZTV11S20993C7_nt9S20993C13__9S20993C14[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20993C14[];
extern  VTBL_ENTRY _ZTV9S20993C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20993C14[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20993C14D0Ev,_ZTv0_n16_N9S20993C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N9S20993C14D0Ev,_ZThn52_N9S20993C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20993C14D1Ev,_ZTv0_n16_N9S20993C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N9S20993C14D1Ev,_ZThn52_N9S20993C14D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20993C14 = {  "S20993C14", // class name
  bases_S20993C14, 10,
  &(vtc_S20993C14[0]), // expected_vtbl_contents
  &(vtt_S20993C14[0]), // expected_vtt_contents
  ABISELECT(128,64), // object size
  NSPAIRA(_ZTI9S20993C14),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S20993C14),20, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20993C14),7, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20993C12  : S2122C38 , S20993C13 , virtual S20993C14 , virtual S20993C10_nt , S20993C9 {
  long double s20993c12f0;
  void *s20993c12f1;
  virtual  ~S20993C12(); // _ZN9S20993C12D2Ev
  S20993C12(); // tgen
};
//SIG(-1 S20993C12) C1{ BC2{ m} BC3{ BC4{ VBC2} BC5{ vd m FC6{}} BC2} VBC7{ VBC3 BC8{ BC2 BC4 Fc FD FC4[3] Fc} BC5 BC2 vd Fp Fl} VBC5 BC8 vd FD Fp}


 S20993C12 ::~S20993C12(){ note_dtor("S20993C12", this);}
S20993C12 ::S20993C12(){ note_ctor("S20993C12", this);} // tgen

static void Test_S20993C12()
{
  extern Class_Descriptor cd_S20993C12;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(18,36)];
    init_test(&cd_S20993C12, buf);
    S20993C12 *dp, &lv = *(dp=new (buf) S20993C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,140), "sizeof(S20993C12)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20993C12)");
    /*is_ambiguous_... S20993C12::S2122C38 */ AMB_check_base_class_offset(lv, (S2122C38*), ABISELECT(17,9), "S20993C12");
    /*is_ambiguous_... S20993C12::S20993C13 */ AMB_check_base_class_offset(lv, (S2122C38*)(S20993C7_nt*)(S20993C13*), ABISELECT(120,64), "S20993C12");
    /*is_ambiguous_... S20993C12::S20993C13 */ AMB_check_base_class_offset(lv, (S2122C38*)(S20993C7_nt*)(S20993C13*), ABISELECT(120,64), "S20993C12");
    check_base_class_offset(lv, (S2122C38*)(S20993C7_nt*)(S20993C9*)(S20993C14*), ABISELECT(120,64), "S20993C12");
    /*is_ambiguous_... S20993C12::S20993C9 */ AMB_check_base_class_offset(lv, (S2122C38*)(S20993C7_nt*)(S20993C9*), ABISELECT(120,64), "S20993C12");
    /*is_ambiguous_... S20993C12::S20993C13 */ AMB_check_base_class_offset(lv, (S20993C7_nt*)(S20993C13*), 0, "S20993C12");
    /*is_ambiguous_... S20993C12::S20993C13 */ AMB_check_base_class_offset(lv, (S20993C10_nt*)(S20993C13*), ABISELECT(8,4), "S20993C12");
    /*is_ambiguous_... S20993C12::S20993C13 */ AMB_check_base_class_offset(lv, (S2122C38*)(S20993C13*), 0, "S20993C12");
    /*is_ambiguous_... S20993C12::S20993C13 */ AMB_check_base_class_offset(lv, (S20993C13*), 0, "S20993C12");
    /*is_ambiguous_... S20993C12::S20993C13 */ AMB_check_base_class_offset(lv, (S20993C7_nt*)(S20993C13*), ABISELECT(224,120), "S20993C12");
    /*is_ambiguous_... S20993C12::S20993C13 */ AMB_check_base_class_offset(lv, (S20993C10_nt*)(S20993C13*), ABISELECT(232,124), "S20993C12");
    /*is_ambiguous_... S20993C12::S20993C13 */ AMB_check_base_class_offset(lv, (S2122C38*)(S20993C13*), ABISELECT(224,120), "S20993C12");
    check_base_class_offset(lv, (S20993C13*)(S20993C14*), ABISELECT(224,120), "S20993C12");
    /*is_ambiguous_... S20993C9::S2122C38 */ AMB_check_base_class_offset(lv, (S2122C38*)(S20993C9*)(S20993C14*), ABISELECT(128,68), "S20993C12");
    check_base_class_offset(lv, (S20993C7_nt*)(S20993C9*)(S20993C14*), ABISELECT(128,68), "S20993C12");
    check_base_class_offset(lv, (S20993C9*)(S20993C14*), ABISELECT(128,68), "S20993C12");
    /*is_ambiguous_... S20993C14::S20993C10_nt */ AMB_check_base_class_offset(lv, (S20993C10_nt*)(S20993C14*), ABISELECT(192,104), "S20993C12");
    /*is_ambiguous_... S20993C14::S2122C38 */ AMB_check_base_class_offset(lv, (S2122C38*)(S20993C14*), ABISELECT(201,109), "S20993C12");
    check_base_class_offset(lv, (S20993C14*), ABISELECT(128,68), "S20993C12");
    /*is_ambiguous_... S20993C12::S20993C10_nt */ AMB_check_base_class_offset(lv, (S20993C10_nt*), ABISELECT(248,132), "S20993C12");
    /*is_ambiguous_... S20993C12::S20993C9 */ AMB_check_base_class_offset(lv, (S2122C38*)(S20993C9*), ABISELECT(32,12), "S20993C12");
    /*is_ambiguous_... S20993C12::S20993C9 */ AMB_check_base_class_offset(lv, (S20993C7_nt*)(S20993C9*), ABISELECT(32,12), "S20993C12");
    /*is_ambiguous_... S20993C12::S20993C9 */ AMB_check_base_class_offset(lv, (S20993C9*), ABISELECT(32,12), "S20993C12");
    check_field_offset(lv, s20993c12f0, ABISELECT(96,48), "S20993C12.s20993c12f0");
    check_field_offset(lv, s20993c12f1, ABISELECT(112,60), "S20993C12.s20993c12f1");
    test_class_info(&lv, &cd_S20993C12);
    dp->~S20993C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20993C12(Test_S20993C12, "S20993C12", ABISELECT(272,140));

#else // __cplusplus

extern void _ZN9S20993C12C1Ev();
extern void _ZN9S20993C12D2Ev();
Name_Map name_map_S20993C12[] = {
  NSPAIR(_ZN9S20993C12C1Ev),
  NSPAIR(_ZN9S20993C12D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2122C38;
extern VTBL_ENTRY _ZTI8S2122C38[];
extern Class_Descriptor cd_S2122C38;
extern VTBL_ENTRY _ZTI8S2122C38[];
extern Class_Descriptor cd_S20