// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S2005C7_nt  {
  void  mf2005c7(); // _ZN10S2005C7_nt8mf2005c7Ev
};
//SIG(-1 S2005C7_nt) C1{ m}


void  S2005C7_nt ::mf2005c7(){}

//skip512 S2005C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2005C6_nt  {
  void *s2005c6f0;
  int s2005c6f1;
  ::S2005C7_nt s2005c6f2;
  ::S2005C7_nt s2005c6f3;
  void  mf2005c6(); // _ZN10S2005C6_nt8mf2005c6Ev
};
//SIG(-1 S2005C6_nt) C1{ m Fp Fi FC2{ m} FC2}


void  S2005C6_nt ::mf2005c6(){}

//skip512 S2005C6_nt

#else // __cplusplus

Class_Descriptor cd_S2005C6_nt = {  "S2005C6_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2005C5_nt  : S2005C6_nt {
};
//SIG(-1 S2005C5_nt) C1{ BC2{ m Fp Fi FC3{ m} FC3}}



//skip512 S2005C5_nt

#else // __cplusplus

extern Class_Descriptor cd_S2005C6_nt;
static Base_Class bases_S2005C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2005C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2005C4_nt  {
  void *s2005c4f0;
  int s2005c4f1;
  ::S2005C5_nt s2005c4f2;
  ::S2005C5_nt s2005c4f3;
  int s2005c4f4;
  virtual  ~S2005C4_nt(); // _ZN10S2005C4_ntD1Ev
  virtual void  v10(); // _ZN10S2005C4_nt3v10Ev
  virtual void  v11(); // _ZN10S2005C4_nt3v11Ev
  virtual void  v12(); // _ZN10S2005C4_nt3v12Ev
  virtual void  v13(); // _ZN10S2005C4_nt3v13Ev
  virtual void  v14(); // _ZN10S2005C4_nt3v14Ev
  virtual void  v15(); // _ZN10S2005C4_nt3v15Ev
  virtual void  v16(); // _ZN10S2005C4_nt3v16Ev
  virtual void  v17(); // _ZN10S2005C4_nt3v17Ev
  virtual void  v18(); // _ZN10S2005C4_nt3v18Ev
  virtual void  v19(); // _ZN10S2005C4_nt3v19Ev
  virtual void  v20(); // _ZN10S2005C4_nt3v20Ev
  virtual void  v21(); // _ZN10S2005C4_nt3v21Ev
  virtual void  v22(); // _ZN10S2005C4_nt3v22Ev
  virtual void  v23(); // _ZN10S2005C4_nt3v23Ev
  virtual void  v24(); // _ZN10S2005C4_nt3v24Ev
  virtual void  v25(); // _ZN10S2005C4_nt3v25Ev
  virtual void  v26(); // _ZN10S2005C4_nt3v26Ev
  virtual void  v27(); // _ZN10S2005C4_nt3v27Ev
  virtual void  v28(); // _ZN10S2005C4_nt3v28Ev
  virtual void  v29(); // _ZN10S2005C4_nt3v29Ev
  virtual void  v30(); // _ZN10S2005C4_nt3v30Ev
  virtual void  v31(); // _ZN10S2005C4_nt3v31Ev
  virtual void  v32(); // _ZN10S2005C4_nt3v32Ev
  S2005C4_nt(); // tgen
};
//SIG(-1 S2005C4_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC2{ BC3{ m Fp Fi FC4{ m} FC4}} FC2 Fi}


 S2005C4_nt ::~S2005C4_nt(){ note_dtor("S2005C4_nt", this);}
void  S2005C4_nt ::v10(){vfunc_called(this, "_ZN10S2005C4_nt3v10Ev");}
void  S2005C4_nt ::v11(){vfunc_called(this, "_ZN10S2005C4_nt3v11Ev");}
void  S2005C4_nt ::v12(){vfunc_called(this, "_ZN10S2005C4_nt3v12Ev");}
void  S2005C4_nt ::v13(){vfunc_called(this, "_ZN10S2005C4_nt3v13Ev");}
void  S2005C4_nt ::v14(){vfunc_called(this, "_ZN10S2005C4_nt3v14Ev");}
void  S2005C4_nt ::v15(){vfunc_called(this, "_ZN10S2005C4_nt3v15Ev");}
void  S2005C4_nt ::v16(){vfunc_called(this, "_ZN10S2005C4_nt3v16Ev");}
void  S2005C4_nt ::v17(){vfunc_called(this, "_ZN10S2005C4_nt3v17Ev");}
void  S2005C4_nt ::v18(){vfunc_called(this, "_ZN10S2005C4_nt3v18Ev");}
void  S2005C4_nt ::v19(){vfunc_called(this, "_ZN10S2005C4_nt3v19Ev");}
void  S2005C4_nt ::v20(){vfunc_called(this, "_ZN10S2005C4_nt3v20Ev");}
void  S2005C4_nt ::v21(){vfunc_called(this, "_ZN10S2005C4_nt3v21Ev");}
void  S2005C4_nt ::v22(){vfunc_called(this, "_ZN10S2005C4_nt3v22Ev");}
void  S2005C4_nt ::v23(){vfunc_called(this, "_ZN10S2005C4_nt3v23Ev");}
void  S2005C4_nt ::v24(){vfunc_called(this, "_ZN10S2005C4_nt3v24Ev");}
void  S2005C4_nt ::v25(){vfunc_called(this, "_ZN10S2005C4_nt3v25Ev");}
void  S2005C4_nt ::v26(){vfunc_called(this, "_ZN10S2005C4_nt3v26Ev");}
void  S2005C4_nt ::v27(){vfunc_called(this, "_ZN10S2005C4_nt3v27Ev");}
void  S2005C4_nt ::v28(){vfunc_called(this, "_ZN10S2005C4_nt3v28Ev");}
void  S2005C4_nt ::v29(){vfunc_called(this, "_ZN10S2005C4_nt3v29Ev");}
void  S2005C4_nt ::v30(){vfunc_called(this, "_ZN10S2005C4_nt3v30Ev");}
void  S2005C4_nt ::v31(){vfunc_called(this, "_ZN10S2005C4_nt3v31Ev");}
void  S2005C4_nt ::v32(){vfunc_called(this, "_ZN10S2005C4_nt3v32Ev");}
S2005C4_nt ::S2005C4_nt(){ note_ctor("S2005C4_nt", this);} // tgen

//skip512 S2005C4_nt

#else // __cplusplus

extern void _ZN10S2005C4_ntC1Ev();
extern void _ZN10S2005C4_ntD1Ev();
Name_Map name_map_S2005C4_nt[] = {
  NSPAIR(_ZN10S2005C4_ntC1Ev),
  NSPAIR(_ZN10S2005C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S2005C4_nt[];
extern void _ZN10S2005C4_ntD1Ev();
extern void _ZN10S2005C4_ntD0Ev();
extern void _ZN10S2005C4_nt3v10Ev();
extern void _ZN10S2005C4_nt3v11Ev();
extern void _ZN10S2005C4_nt3v12Ev();
extern void _ZN10S2005C4_nt3v13Ev();
extern void _ZN10S2005C4_nt3v14Ev();
extern void _ZN10S2005C4_nt3v15Ev();
extern void _ZN10S2005C4_nt3v16Ev();
extern void _ZN10S2005C4_nt3v17Ev();
extern void _ZN10S2005C4_nt3v18Ev();
extern void _ZN10S2005C4_nt3v19Ev();
extern void _ZN10S2005C4_nt3v20Ev();
extern void _ZN10S2005C4_nt3v21Ev();
extern void _ZN10S2005C4_nt3v22Ev();
extern void _ZN10S2005C4_nt3v23Ev();
extern void _ZN10S2005C4_nt3v24Ev();
extern void _ZN10S2005C4_nt3v25Ev();
extern void _ZN10S2005C4_nt3v26Ev();
extern void _ZN10S2005C4_nt3v27Ev();
extern void _ZN10S2005C4_nt3v28Ev();
extern void _ZN10S2005C4_nt3v29Ev();
extern void _ZN10S2005C4_nt3v30Ev();
extern void _ZN10S2005C4_nt3v31Ev();
extern void _ZN10S2005C4_nt3v32Ev();
static  VTBL_ENTRY vtc_S2005C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2005C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S2005C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v32Ev,
};
extern VTBL_ENTRY _ZTI10S2005C4_nt[];
VTBL_ENTRY *P__ZTI10S2005C4_nt = _ZTI10S2005C4_nt; 
extern  VTBL_ENTRY _ZTV10S2005C4_nt[];
Class_Descriptor cd_S2005C4_nt = {  "S2005C4_nt", // class name
  0,0,//no base classes
  &(vtc_S2005C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI10S2005C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S2005C4_nt),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2005C14_nt  {
  __tsi64 s2005c14f0[2];
  void  mf2005c14(); // _ZN11S2005C14_nt9mf2005c14Ev
};
//SIG(-1 S2005C14_nt) C1{ m FL[2]}


void  S2005C14_nt ::mf2005c14(){}

//skip512 S2005C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2005C13_nt  {
  ::S2005C14_nt s2005c13f0;
  void  mf2005c13(); // _ZN11S2005C13_nt9mf2005c13Ev
};
//SIG(-1 S2005C13_nt) C1{ m FC2{ m FL[2]}}


void  S2005C13_nt ::mf2005c13(){}

//skip512 S2005C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2005C17_nt  {
  ::S2005C13_nt s2005c17f0;
  void  mf2005c17(); // _ZN11S2005C17_nt9mf2005c17Ev
};
//SIG(-1 S2005C17_nt) C1{ m FC2{ m FC3{ m FL[2]}}}


void  S2005C17_nt ::mf2005c17(){}

//skip512 S2005C17_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2005C18_nt  {
  ::S2005C13_nt s2005c18f0;
  ::S2005C13_nt s2005c18f1;
  ::S2005C13_nt s2005c18f2;
  ::S2005C13_nt s2005c18f3;
  void  mf2005c18(); // _ZN11S2005C18_nt9mf2005c18Ev
};
//SIG(-1 S2005C18_nt) C1{ m FC2{ m FC3{ m FL[2]}} FC2 FC2 FC2}


void  S2005C18_nt ::mf2005c18(){}

//skip512 S2005C18_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2005C21  {
  void  mf2005c21(); // _ZN8S2005C219mf2005c21Ev
};
//SIG(-1 S2005C21) C1{ m}


void  S2005C21 ::mf2005c21(){}

static void Test_S2005C21()
{
  {
    init_simple_test("S2005C21");
    S2005C21 lv;
    check2(sizeof(lv), 1, "sizeof(S2005C21)");
    check2(__alignof__(lv), 1, "__alignof__(S2005C21)");
  }
}
static Arrange_To_Call_Me vS2005C21(Test_S2005C21, "S2005C21", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2005C20_nt  {
  void *s2005c20f0;
  int s2005c20f1;
  ::S2005C21 s2005c20f2;
  void  mf2005c20(); // _ZN11S2005C20_nt9mf2005c20Ev
};
//SIG(-1 S2005C20_nt) C1{ m Fp Fi FC2{ m}}


void  S2005C20_nt ::mf2005c20(){}

//skip512 S2005C20_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2005C19_nt  {
  ::S2005C20_nt s2005c19f0;
  int s2005c19f1;
  void  mf2005c19(); // _ZN11S2005C19_nt9mf2005c19Ev
};
//SIG(-1 S2005C19_nt) C1{ m FC2{ m Fp Fi FC3{ m}} Fi}


void  S2005C19_nt ::mf2005c19(){}

//skip512 S2005C19_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2005C24  {
  void  mf2005c24(); // _ZN8S2005C249mf2005c24Ev
};
//SIG(-1 S2005C24) C1{ m}


void  S2005C24 ::mf2005c24(){}

static void Test_S2005C24()
{
  {
    init_simple_test("S2005C24");
    S2005C24 lv;
    check2(sizeof(lv), 1, "sizeof(S2005C24)");
    check2(__alignof__(lv), 1, "__alignof__(S2005C24)");
  }
}
static Arrange_To_Call_Me vS2005C24(Test_S2005C24, "S2005C24", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2005C22  {
  void *s2005c22f0;
  int s2005c22f1;
  ::S2005C21 s2005c22f2;
  ::S2005C24 s2005c22f3;
  void  mf2005c22(); // _ZN8S2005C229mf2005c22Ev
};
//SIG(-1 S2005C22) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S2005C22 ::mf2005c22(){}

static void Test_S2005C22()
{
  {
    init_simple_test("S2005C22");
    S2005C22 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2005C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2005C22)");
    check_field_offset(lv, s2005c22f0, 0, "S2005C22.s2005c22f0");
    check_field_offset(lv, s2005c22f1, ABISELECT(8,4), "S2005C22.s2005c22f1");
    check_field_offset(lv, s2005c22f2, ABISELECT(12,8), "S2005C22.s2005c22f2");
    check_field_offset(lv, s2005c22f3, ABISELECT(13,9), "S2005C22.s2005c22f3");
  }
}
static Arrange_To_Call_Me vS2005C22(Test_S2005C22, "S2005C22", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2005C28  {
  void  mf2005c28(); // _ZN8S2005C289mf2005c28Ev
};
//SIG(-1 S2005C28) C1{ m}


void  S2005C28 ::mf2005c28(){}

static void Test_S2005C28()
{
  {
    init_simple_test("S2005C28");
    S2005C28 lv;
    check2(sizeof(lv), 1, "sizeof(S2005C28)");
    check2(__alignof__(lv), 1, "__alignof__(S2005C28)");
  }
}
static Arrange_To_Call_Me vS2005C28(Test_S2005C28, "S2005C28", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S2005C28[];
VTBL_ENTRY *P__ZTI8S2005C28 = _ZTI8S2005C28; 
Class_Descriptor cd_S2005C28 = {  "S2005C28", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S2005C28),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2005C26  {
  void *s2005c26f0;
  int s2005c26f1;
  ::S2005C24 s2005c26f2;
  ::S2005C28 s2005c26f3;
  void  mf2005c26(); // _ZN8S2005C269mf2005c26Ev
};
//SIG(-1 S2005C26) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S2005C26 ::mf2005c26(){}

static void Test_S2005C26()
{
  {
    init_simple_test("S2005C26");
    S2005C26 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2005C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2005C26)");
    check_field_offset(lv, s2005c26f0, 0, "S2005C26.s2005c26f0");
    check_field_offset(lv, s2005c26f1, ABISELECT(8,4), "S2005C26.s2005c26f1");
    check_field_offset(lv, s2005c26f2, ABISELECT(12,8), "S2005C26.s2005c26f2");
    check_field_offset(lv, s2005c26f3, ABISELECT(13,9), "S2005C26.s2005c26f3");
  }
}
static Arrange_To_Call_Me vS2005C26(Test_S2005C26, "S2005C26", ABISELECT(16,12));

#else // __cplusplus

Class_Descriptor cd_S2005C26 = {  "S2005C26", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2005C25  : S2005C26 {
};
//SIG(-1 S2005C25) C1{ BC2{ m Fp Fi FC3{ m} FC4{ m}}}



static void Test_S2005C25()
{
  extern Class_Descriptor cd_S2005C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S2005C25, buf);
    S2005C25 &lv = *(new (buf) S2005C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2005C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2005C25)");
    check_base_class_offset(lv, (S2005C26*), 0, "S2005C25");
    test_class_info(&lv, &cd_S2005C25);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2005C25(Test_S2005C25, "S2005C25", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S2005C26;
static Base_Class bases_S2005C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2005C26,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S2005C25 = {  "S2005C25", // class name
  bases_S2005C25, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2005C29_nt  {
  void *s2005c29f0;
  int s2005c29f1[2];
  ::S2005C28 s2005c29f2;
  void  mf2005c29(); // _ZN11S2005C29_nt9mf2005c29Ev
};
//SIG(-1 S2005C29_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S2005C29_nt ::mf2005c29(){}

//skip512 S2005C29_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2005C38  {
  void  mf2005c38(); // _ZN8S2005C389mf2005c38Ev
};
//SIG(-1 S2005C38) C1{ m}


void  S2005C38 ::mf2005c38(){}

static void Test_S2005C38()
{
  {
    init_simple_test("S2005C38");
    S2005C38 lv;
    check2(sizeof(lv), 1, "sizeof(S2005C38)");
    check2(__alignof__(lv), 1, "__alignof__(S2005C38)");
  }
}
static Arrange_To_Call_Me vS2005C38(Test_S2005C38, "S2005C38", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S2005C38[];
VTBL_ENTRY *P__ZTI8S2005C38 = _ZTI8S2005C38; 
Class_Descriptor cd_S2005C38 = {  "S2005C38", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S2005C38),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2005C37  {
  void *s2005c37f0;
  int s2005c37f1[2];
  ::S2005C38 s2005c37f2;
  void  mf2005c37(); // _ZN8S2005C379mf2005c37Ev
};
//SIG(-1 S2005C37) C1{ m Fp Fi[2] FC2{ m}}


void  S2005C37 ::mf2005c37(){}

static void Test_S2005C37()
{
  {
    init_simple_test("S2005C37");
    S2005C37 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S2005C37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2005C37)");
    check_field_offset(lv, s2005c37f0, 0, "S2005C37.s2005c37f0");
    check_field_offset(lv, s2005c37f1, ABISELECT(8,4), "S2005C37.s2005c37f1");
    check_field_offset(lv, s2005c37f2, ABISELECT(16,12), "S2005C37.s2005c37f2");
  }
}
static Arrange_To_Call_Me vS2005C37(Test_S2005C37, "S2005C37", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2005C3_nt  : S2005C4_nt {
  ::S2005C13_nt s2005c3f0;
  ::S2005C13_nt s2005c3f1;
  ::S2005C13_nt s2005c3f2;
  ::S2005C13_nt s2005c3f3;
  ::S2005C17_nt s2005c3f4;
  ::S2005C18_nt s2005c3f5;
  ::S2005C18_nt s2005c3f6;
  ::S2005C13_nt s2005c3f7;
  ::S2005C13_nt s2005c3f8;
  ::S2005C13_nt s2005c3f9;
  void *s2005c3f10;
  ::S2005C17_nt s2005c3f11;
  ::S2005C19_nt s2005c3f12;
  int s2005c3f13;
  void *s2005c3f14[7];
  ::S2005C22 s2005c3f15;
  int s2005c3f16:8;
  int s2005c3f17:8;
  int s2005c3f18:16;
  int s2005c3f19:16;
  int s2005c3f20:8;
  int s2005c3f21:8;
  int s2005c3f22:8;
  int s2005c3f23:32;
  int s2005c3f24:8;
  int s2005c3f25:4;
  int s2005c3f26:4;
  int s2005c3f27:4;
  int s2005c3f28:4;
  int s2005c3f29:4;
  int s2005c3f30:4;
  int s2005c3f31:4;
  int s2005c3f32:4;
  int s2005c3f33:4;
  int s2005c3f34:4;
  unsigned char s2005c3f35:1;
  unsigned char s2005c3f36:1;
  unsigned char s2005c3f37:1;
  unsigned char s2005c3f38:1;
  unsigned char s2005c3f39:1;
  unsigned char s2005c3f40:1;
  unsigned char s2005c3f41:1;
  unsigned char s2005c3f42:1;
  unsigned char s2005c3f43:1;
  unsigned char s2005c3f44:1;
  unsigned char s2005c3f45:1;
  unsigned char s2005c3f46:1;
  unsigned char s2005c3f47:1;
  unsigned char s2005c3f48:1;
  unsigned char s2005c3f49:1;
  unsigned char s2005c3f50:1;
  unsigned char s2005c3f51:1;
  unsigned char s2005c3f52:1;
  unsigned char s2005c3f53:1;
  unsigned char s2005c3f54:1;
  unsigned char s2005c3f55:1;
  unsigned char s2005c3f56:1;
  unsigned char s2005c3f57:1;
  unsigned char s2005c3f58:1;
  unsigned char s2005c3f59:1;
  unsigned char s2005c3f60:1;
  unsigned char s2005c3f61:1;
  unsigned char s2005c3f62:1;
  unsigned char s2005c3f63:1;
  unsigned char s2005c3f64:1;
  unsigned char s2005c3f65:1;
  unsigned char s2005c3f66:1;
  unsigned char s2005c3f67:1;
  unsigned char s2005c3f68:1;
  unsigned char s2005c3f69:1;
  unsigned char s2005c3f70:1;
  unsigned char s2005c3f71:1;
  unsigned char s2005c3f72:1;
  unsigned char s2005c3f73:1;
  unsigned char s2005c3f74:1;
  unsigned char s2005c3f75:1;
  int s2005c3f76[7];
  void *s2005c3f77[6];
  int s2005c3f78:8;
  int s2005c3f79:8;
  int s2005c3f80:8;
  int s2005c3f81:8;
  int s2005c3f82:8;
  int s2005c3f83:8;
  ::S2005C25 s2005c3f84;
  void *s2005c3f85[4];
  int s2005c3f86:8;
  int s2005c3f87:8;
  int s2005c3f88:8;
  int s2005c3f89:8;
  int s2005c3f90:8;
  int s2005c3f91:16;
  int s2005c3f92:16;
  int s2005c3f93:16;
  int s2005c3f94:4;
  int s2005c3f95:4;
  int s2005c3f96:4;
  int s2005c3f97:4;
  int s2005c3f98:4;
  int s2005c3f99:4;
  int s2005c3f100:4;
  int s2005c3f101:4;
  int s2005c3f102:4;
  int s2005c3f103:4;
  int s2005c3f104:4;
  int s2005c3f105:4;
  int s2005c3f106:8;
  int s2005c3f107:8;
  int s2005c3f108:8;
  void *s2005c3f109[7];
  ::S2005C29_nt s2005c3f110;
  void *s2005c3f111[2];
  int s2005c3f112:16;
  int s2005c3f113:16;
  ::S2005C25 s2005c3f114;
  ::S2005C29_nt s2005c3f115;
  ::S2005C37 s2005c3f116;
  void *s2005c3f117[2];
  int s2005c3f118:24;
  int s2005c3f119:8;
  void *s2005c3f120;
  virtual  ~S2005C3_nt(); // _ZN10S2005C3_ntD1Ev
  virtual void  v33(); // _ZN10S2005C3_nt3v33Ev
  virtual void  v34(); // _ZN10S2005C3_nt3v34Ev
  virtual void  v35(); // _ZN10S2005C3_nt3v35Ev
  virtual void  v36(); // _ZN10S2005C3_nt3v36Ev
  virtual void  v37(); // _ZN10S2005C3_nt3v37Ev
  virtual void  v38(); // _ZN10S2005C3_nt3v38Ev
  virtual void  v39(); // _ZN10S2005C3_nt3v39Ev
  virtual void  v40(); // _ZN10S2005C3_nt3v40Ev
  virtual void  v41(); // _ZN10S2005C3_nt3v41Ev
  virtual void  v42(); // _ZN10S2005C3_nt3v42Ev
  virtual void  v43(); // _ZN10S2005C3_nt3v43Ev
  virtual void  v44(); // _ZN10S2005C3_nt3v44Ev
  virtual void  v45(); // _ZN10S2005C3_nt3v45Ev
  virtual void  v46(); // _ZN10S2005C3_nt3v46Ev
  virtual void  v47(); // _ZN10S2005C3_nt3v47Ev
  virtual void  v48(); // _ZN10S2005C3_nt3v48Ev
  virtual void  v49(); // _ZN10S2005C3_nt3v49Ev
  virtual void  v50(); // _ZN10S2005C3_nt3v50Ev
  virtual void  v51(); // _ZN10S2005C3_nt3v51Ev
  virtual void  v52(); // _ZN10S2005C3_nt3v52Ev
  virtual void  v53(); // _ZN10S2005C3_nt3v53Ev
  virtual void  v54(); // _ZN10S2005C3_nt3v54Ev
  virtual void  v55(); // _ZN10S2005C3_nt3v55Ev
  virtual void  v56(); // _ZN10S2005C3_nt3v56Ev
  virtual void  v57(); // _ZN10S2005C3_nt3v57Ev
  virtual void  v58(); // _ZN10S2005C3_nt3v58Ev
  virtual void  v59(); // _ZN10S2005C3_nt3v59Ev
  virtual void  v60(); // _ZN10S2005C3_nt3v60Ev
  virtual void  v61(); // _ZN10S2005C3_nt3v61Ev
  virtual void  v62(); // _ZN10S2005C3_nt3v62Ev
  virtual void  v63(); // _ZN10S2005C3_nt3v63Ev
  virtual void  v64(); // _ZN10S2005C3_nt3v64Ev
  virtual void  v65(); // _ZN10S2005C3_nt3v65Ev
  virtual void  v66(); // _ZN10S2005C3_nt3v66Ev
  virtual void  v67(); // _ZN10S2005C3_nt3v67Ev
  virtual void  v68(); // _ZN10S2005C3_nt3v68Ev
  virtual void  v69(); // _ZN10S2005C3_nt3v69Ev
  virtual void  v70(); // _ZN10S2005C3_nt3v70Ev
  virtual void  v71(); // _ZN10S2005C3_nt3v71Ev
  virtual void  v72(); // _ZN10S2005C3_nt3v72Ev
  virtual void  v73(); // _ZN10S2005C3_nt3v73Ev
  virtual void  v74(); // _ZN10S2005C3_nt3v74Ev
  virtual void  v75(); // _ZN10S2005C3_nt3v75Ev
  virtual void  v76(); // _ZN10S2005C3_nt3v76Ev
  virtual void  v77(); // _ZN10S2005C3_nt3v77Ev
  virtual void  v78(); // _ZN10S2005C3_nt3v78Ev
  virtual void  v79(); // _ZN10S2005C3_nt3v79Ev
  virtual void  v80(); // _ZN10S2005C3_nt3v80Ev
  virtual void  v81(); // _ZN10S2005C3_nt3v81Ev
  virtual void  v82(); // _ZN10S2005C3_nt3v82Ev
  virtual void  v83(); // _ZN10S2005C3_nt3v83Ev
  virtual void  v84(); // _ZN10S2005C3_nt3v84Ev
  virtual void  v85(); // _ZN10S2005C3_nt3v85Ev
  virtual void  v86(); // _ZN10S2005C3_nt3v86Ev
  virtual void  v87(); // _ZN10S2005C3_nt3v87Ev
  virtual void  v88(); // _ZN10S2005C3_nt3v88Ev
  virtual void  v89(); // _ZN10S2005C3_nt3v89Ev
  virtual void  v90(); // _ZN10S2005C3_nt3v90Ev
  virtual void  v91(); // _ZN10S2005C3_nt3v91Ev
  virtual void  v92(); // _ZN10S2005C3_nt3v92Ev
  virtual void  v93(); // _ZN10S2005C3_nt3v93Ev
  virtual void  v94(); // _ZN10S2005C3_nt3v94Ev
  virtual void  v95(); // _ZN10S2005C3_nt3v95Ev
  virtual void  v96(); // _ZN10S2005C3_nt3v96Ev
  virtual void  v97(); // _ZN10S2005C3_nt3v97Ev
  virtual void  v98(); // _ZN10S2005C3_nt3v98Ev
  virtual void  v99(); // _ZN10S2005C3_nt3v99Ev
  virtual void  v100(); // _ZN10S2005C3_nt4v100Ev
  virtual void  v101(); // _ZN10S2005C3_nt4v101Ev
  virtual void  v102(); // _ZN10S2005C3_nt4v102Ev
  virtual void  v103(); // _ZN10S2005C3_nt4v103Ev
  virtual void  v104(); // _ZN10S2005C3_nt4v104Ev
  virtual void  v105(); // _ZN10S2005C3_nt4v105Ev
  virtual void  v106(); // _ZN10S2005C3_nt4v106Ev
  virtual void  v107(); // _ZN10S2005C3_nt4v107Ev
  virtual void  v108(); // _ZN10S2005C3_nt4v108Ev
  virtual void  v109(); // _ZN10S2005C3_nt4v109Ev
  virtual void  v110(); // _ZN10S2005C3_nt4v110Ev
  S2005C3_nt(); // tgen
};
//SIG(-1 S2005C3_nt) C1{ BC2{ vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fp Fi FC3{ BC4{ m Fp Fi FC5{ m} FC5}} FC3 Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 FC6{ m FC7{ m FL[2]}} FC6 FC6 FC6 FC8{ m FC6} FC9{ m FC6 FC6 FC6 FC6} FC9 FC6 FC6 FC6 Fp FC8 FC10{ m FC11{ m Fp Fi FC12{ m}} Fi} Fi Fp[7] FC13{ m Fp Fi FC12 FC14{ m}} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC15{ BC16{ m Fp Fi FC14 FC17{ m}}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC18{ m Fp Fi[2] FC17} Fp[2] Fi:16 Fi:16 FC15 FC18 FC19{ m Fp Fi[2] FC20{ m}} Fp[2] Fi:24 Fi:8 Fp}


 S2005C3_nt ::~S2005C3_nt(){ note_dtor("S2005C3_nt", this);}
void  S2005C3_nt ::v33(){vfunc_called(this, "_ZN10S2005C3_nt3v33Ev");}
void  S2005C3_nt ::v34(){vfunc_called(this, "_ZN10S2005C3_nt3v34Ev");}
void  S2005C3_nt ::v35(){vfunc_called(this, "_ZN10S2005C3_nt3v35Ev");}
void  S2005C3_nt ::v36(){vfunc_called(this, "_ZN10S2005C3_nt3v36Ev");}
void  S2005C3_nt ::v37(){vfunc_called(this, "_ZN10S2005C3_nt3v37Ev");}
void  S2005C3_nt ::v38(){vfunc_called(this, "_ZN10S2005C3_nt3v38Ev");}
void  S2005C3_nt ::v39(){vfunc_called(this, "_ZN10S2005C3_nt3v39Ev");}
void  S2005C3_nt ::v40(){vfunc_called(this, "_ZN10S2005C3_nt3v40Ev");}
void  S2005C3_nt ::v41(){vfunc_called(this, "_ZN10S2005C3_nt3v41Ev");}
void  S2005C3_nt ::v42(){vfunc_called(this, "_ZN10S2005C3_nt3v42Ev");}
void  S2005C3_nt ::v43(){vfunc_called(this, "_ZN10S2005C3_nt3v43Ev");}
void  S2005C3_nt ::v44(){vfunc_called(this, "_ZN10S2005C3_nt3v44Ev");}
void  S2005C3_nt ::v45(){vfunc_called(this, "_ZN10S2005C3_nt3v45Ev");}
void  S2005C3_nt ::v46(){vfunc_called(this, "_ZN10S2005C3_nt3v46Ev");}
void  S2005C3_nt ::v47(){vfunc_called(this, "_ZN10S2005C3_nt3v47Ev");}
void  S2005C3_nt ::v48(){vfunc_called(this, "_ZN10S2005C3_nt3v48Ev");}
void  S2005C3_nt ::v49(){vfunc_called(this, "_ZN10S2005C3_nt3v49Ev");}
void  S2005C3_nt ::v50(){vfunc_called(this, "_ZN10S2005C3_nt3v50Ev");}
void  S2005C3_nt ::v51(){vfunc_called(this, "_ZN10S2005C3_nt3v51Ev");}
void  S2005C3_nt ::v52(){vfunc_called(this, "_ZN10S2005C3_nt3v52Ev");}
void  S2005C3_nt ::v53(){vfunc_called(this, "_ZN10S2005C3_nt3v53Ev");}
void  S2005C3_nt ::v54(){vfunc_called(this, "_ZN10S2005C3_nt3v54Ev");}
void  S2005C3_nt ::v55(){vfunc_called(this, "_ZN10S2005C3_nt3v55Ev");}
void  S2005C3_nt ::v56(){vfunc_called(this, "_ZN10S2005C3_nt3v56Ev");}
void  S2005C3_nt ::v57(){vfunc_called(this, "_ZN10S2005C3_nt3v57Ev");}
void  S2005C3_nt ::v58(){vfunc_called(this, "_ZN10S2005C3_nt3v58Ev");}
void  S2005C3_nt ::v59(){vfunc_called(this, "_ZN10S2005C3_nt3v59Ev");}
void  S2005C3_nt ::v60(){vfunc_called(this, "_ZN10S2005C3_nt3v60Ev");}
void  S2005C3_nt ::v61(){vfunc_called(this, "_ZN10S2005C3_nt3v61Ev");}
void  S2005C3_nt ::v62(){vfunc_called(this, "_ZN10S2005C3_nt3v62Ev");}
void  S2005C3_nt ::v63(){vfunc_called(this, "_ZN10S2005C3_nt3v63Ev");}
void  S2005C3_nt ::v64(){vfunc_called(this, "_ZN10S2005C3_nt3v64Ev");}
void  S2005C3_nt ::v65(){vfunc_called(this, "_ZN10S2005C3_nt3v65Ev");}
void  S2005C3_nt ::v66(){vfunc_called(this, "_ZN10S2005C3_nt3v66Ev");}
void  S2005C3_nt ::v67(){vfunc_called(this, "_ZN10S2005C3_nt3v67Ev");}
void  S2005C3_nt ::v68(){vfunc_called(this, "_ZN10S2005C3_nt3v68Ev");}
void  S2005C3_nt ::v69(){vfunc_called(this, "_ZN10S2005C3_nt3v69Ev");}
void  S2005C3_nt ::v70(){vfunc_called(this, "_ZN10S2005C3_nt3v70Ev");}
void  S2005C3_nt ::v71(){vfunc_called(this, "_ZN10S2005C3_nt3v71Ev");}
void  S2005C3_nt ::v72(){vfunc_called(this, "_ZN10S2005C3_nt3v72Ev");}
void  S2005C3_nt ::v73(){vfunc_called(this, "_ZN10S2005C3_nt3v73Ev");}
void  S2005C3_nt ::v74(){vfunc_called(this, "_ZN10S2005C3_nt3v74Ev");}
void  S2005C3_nt ::v75(){vfunc_called(this, "_ZN10S2005C3_nt3v75Ev");}
void  S2005C3_nt ::v76(){vfunc_called(this, "_ZN10S2005C3_nt3v76Ev");}
void  S2005C3_nt ::v77(){vfunc_called(this, "_ZN10S2005C3_nt3v77Ev");}
void  S2005C3_nt ::v78(){vfunc_called(this, "_ZN10S2005C3_nt3v78Ev");}
void  S2005C3_nt ::v79(){vfunc_called(this, "_ZN10S2005C3_nt3v79Ev");}
void  S2005C3_nt ::v80(){vfunc_called(this, "_ZN10S2005C3_nt3v80Ev");}
void  S2005C3_nt ::v81(){vfunc_called(this, "_ZN10S2005C3_nt3v81Ev");}
void  S2005C3_nt ::v82(){vfunc_called(this, "_ZN10S2005C3_nt3v82Ev");}
void  S2005C3_nt ::v83(){vfunc_called(this, "_ZN10S2005C3_nt3v83Ev");}
void  S2005C3_nt ::v84(){vfunc_called(this, "_ZN10S2005C3_nt3v84Ev");}
void  S2005C3_nt ::v85(){vfunc_called(this, "_ZN10S2005C3_nt3v85Ev");}
void  S2005C3_nt ::v86(){vfunc_called(this, "_ZN10S2005C3_nt3v86Ev");}
void  S2005C3_nt ::v87(){vfunc_called(this, "_ZN10S2005C3_nt3v87Ev");}
void  S2005C3_nt ::v88(){vfunc_called(this, "_ZN10S2005C3_nt3v88Ev");}
void  S2005C3_nt ::v89(){vfunc_called(this, "_ZN10S2005C3_nt3v89Ev");}
void  S2005C3_nt ::v90(){vfunc_called(this, "_ZN10S2005C3_nt3v90Ev");}
void  S2005C3_nt ::v91(){vfunc_called(this, "_ZN10S2005C3_nt3v91Ev");}
void  S2005C3_nt ::v92(){vfunc_called(this, "_ZN10S2005C3_nt3v92Ev");}
void  S2005C3_nt ::v93(){vfunc_called(this, "_ZN10S2005C3_nt3v93Ev");}
void  S2005C3_nt ::v94(){vfunc_called(this, "_ZN10S2005C3_nt3v94Ev");}
void  S2005C3_nt ::v95(){vfunc_called(this, "_ZN10S2005C3_nt3v95Ev");}
void  S2005C3_nt ::v96(){vfunc_called(this, "_ZN10S2005C3_nt3v96Ev");}
void  S2005C3_nt ::v97(){vfunc_called(this, "_ZN10S2005C3_nt3v97Ev");}
void  S2005C3_nt ::v98(){vfunc_called(this, "_ZN10S2005C3_nt3v98Ev");}
void  S2005C3_nt ::v99(){vfunc_called(this, "_ZN10S2005C3_nt3v99Ev");}
void  S2005C3_nt ::v100(){vfunc_called(this, "_ZN10S2005C3_nt4v100Ev");}
void  S2005C3_nt ::v101(){vfunc_called(this, "_ZN10S2005C3_nt4v101Ev");}
void  S2005C3_nt ::v102(){vfunc_called(this, "_ZN10S2005C3_nt4v102Ev");}
void  S2005C3_nt ::v103(){vfunc_called(this, "_ZN10S2005C3_nt4v103Ev");}
void  S2005C3_nt ::v104(){vfunc_called(this, "_ZN10S2005C3_nt4v104Ev");}
void  S2005C3_nt ::v105(){vfunc_called(this, "_ZN10S2005C3_nt4v105Ev");}
void  S2005C3_nt ::v106(){vfunc_called(this, "_ZN10S2005C3_nt4v106Ev");}
void  S2005C3_nt ::v107(){vfunc_called(this, "_ZN10S2005C3_nt4v107Ev");}
void  S2005C3_nt ::v108(){vfunc_called(this, "_ZN10S2005C3_nt4v108Ev");}
void  S2005C3_nt ::v109(){vfunc_called(this, "_ZN10S2005C3_nt4v109Ev");}
void  S2005C3_nt ::v110(){vfunc_called(this, "_ZN10S2005C3_nt4v110Ev");}
S2005C3_nt ::S2005C3_nt(){ note_ctor("S2005C3_nt", this);} // tgen

//skip512 S2005C3_nt

#else // __cplusplus

extern void _ZN10S2005C3_ntC1Ev();
extern void _ZN10S2005C3_ntD1Ev();
Name_Map name_map_S2005C3_nt[] = {
  NSPAIR(_ZN10S2005C3_ntC1Ev),
  NSPAIR(_ZN10S2005C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2005C4_nt;
extern VTBL_ENTRY _ZTI10S2005C4_nt[];
extern  VTBL_ENTRY _ZTV10S2005C4_nt[];
static Base_Class bases_S2005C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2005C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S2005C3_nt[];
extern void _ZN10S2005C3_ntD1Ev();
extern void _ZN10S2005C3_ntD0Ev();
extern void _ZN10S2005C4_nt3v10Ev();
extern void _ZN10S2005C4_nt3v11Ev();
extern void _ZN10S2005C4_nt3v12Ev();
extern void _ZN10S2005C4_nt3v13Ev();
extern void _ZN10S2005C4_nt3v14Ev();
extern void _ZN10S2005C4_nt3v15Ev();
extern void _ZN10S2005C4_nt3v16Ev();
extern void _ZN10S2005C4_nt3v17Ev();
extern void _ZN10S2005C4_nt3v18Ev();
extern void _ZN10S2005C4_nt3v19Ev();
extern void _ZN10S2005C4_nt3v20Ev();
extern void _ZN10S2005C4_nt3v21Ev();
extern void _ZN10S2005C4_nt3v22Ev();
extern void _ZN10S2005C4_nt3v23Ev();
extern void _ZN10S2005C4_nt3v24Ev();
extern void _ZN10S2005C4_nt3v25Ev();
extern void _ZN10S2005C4_nt3v26Ev();
extern void _ZN10S2005C4_nt3v27Ev();
extern void _ZN10S2005C4_nt3v28Ev();
extern void _ZN10S2005C4_nt3v29Ev();
extern void _ZN10S2005C4_nt3v30Ev();
extern void _ZN10S2005C4_nt3v31Ev();
extern void _ZN10S2005C4_nt3v32Ev();
extern void _ZN10S2005C3_nt3v33Ev();
extern void _ZN10S2005C3_nt3v34Ev();
extern void _ZN10S2005C3_nt3v35Ev();
extern void _ZN10S2005C3_nt3v36Ev();
extern void _ZN10S2005C3_nt3v37Ev();
extern void _ZN10S2005C3_nt3v38Ev();
extern void _ZN10S2005C3_nt3v39Ev();
extern void _ZN10S2005C3_nt3v40Ev();
extern void _ZN10S2005C3_nt3v41Ev();
extern void _ZN10S2005C3_nt3v42Ev();
extern void _ZN10S2005C3_nt3v43Ev();
extern void _ZN10S2005C3_nt3v44Ev();
extern void _ZN10S2005C3_nt3v45Ev();
extern void _ZN10S2005C3_nt3v46Ev();
extern void _ZN10S2005C3_nt3v47Ev();
extern void _ZN10S2005C3_nt3v48Ev();
extern void _ZN10S2005C3_nt3v49Ev();
extern void _ZN10S2005C3_nt3v50Ev();
extern void _ZN10S2005C3_nt3v51Ev();
extern void _ZN10S2005C3_nt3v52Ev();
extern void _ZN10S2005C3_nt3v53Ev();
extern void _ZN10S2005C3_nt3v54Ev();
extern void _ZN10S2005C3_nt3v55Ev();
extern void _ZN10S2005C3_nt3v56Ev();
extern void _ZN10S2005C3_nt3v57Ev();
extern void _ZN10S2005C3_nt3v58Ev();
extern void _ZN10S2005C3_nt3v59Ev();
extern void _ZN10S2005C3_nt3v60Ev();
extern void _ZN10S2005C3_nt3v61Ev();
extern void _ZN10S2005C3_nt3v62Ev();
extern void _ZN10S2005C3_nt3v63Ev();
extern void _ZN10S2005C3_nt3v64Ev();
extern void _ZN10S2005C3_nt3v65Ev();
extern void _ZN10S2005C3_nt3v66Ev();
extern void _ZN10S2005C3_nt3v67Ev();
extern void _ZN10S2005C3_nt3v68Ev();
extern void _ZN10S2005C3_nt3v69Ev();
extern void _ZN10S2005C3_nt3v70Ev();
extern void _ZN10S2005C3_nt3v71Ev();
extern void _ZN10S2005C3_nt3v72Ev();
extern void _ZN10S2005C3_nt3v73Ev();
extern void _ZN10S2005C3_nt3v74Ev();
extern void _ZN10S2005C3_nt3v75Ev();
extern void _ZN10S2005C3_nt3v76Ev();
extern void _ZN10S2005C3_nt3v77Ev();
extern void _ZN10S2005C3_nt3v78Ev();
extern void _ZN10S2005C3_nt3v79Ev();
extern void _ZN10S2005C3_nt3v80Ev();
extern void _ZN10S2005C3_nt3v81Ev();
extern void _ZN10S2005C3_nt3v82Ev();
extern void _ZN10S2005C3_nt3v83Ev();
extern void _ZN10S2005C3_nt3v84Ev();
extern void _ZN10S2005C3_nt3v85Ev();
extern void _ZN10S2005C3_nt3v86Ev();
extern void _ZN10S2005C3_nt3v87Ev();
extern void _ZN10S2005C3_nt3v88Ev();
extern void _ZN10S2005C3_nt3v89Ev();
extern void _ZN10S2005C3_nt3v90Ev();
extern void _ZN10S2005C3_nt3v91Ev();
extern void _ZN10S2005C3_nt3v92Ev();
extern void _ZN10S2005C3_nt3v93Ev();
extern void _ZN10S2005C3_nt3v94Ev();
extern void _ZN10S2005C3_nt3v95Ev();
extern void _ZN10S2005C3_nt3v96Ev();
extern void _ZN10S2005C3_nt3v97Ev();
extern void _ZN10S2005C3_nt3v98Ev();
extern void _ZN10S2005C3_nt3v99Ev();
extern void _ZN10S2005C3_nt4v100Ev();
extern void _ZN10S2005C3_nt4v101Ev();
extern void _ZN10S2005C3_nt4v102Ev();
extern void _ZN10S2005C3_nt4v103Ev();
extern void _ZN10S2005C3_nt4v104Ev();
extern void _ZN10S2005C3_nt4v105Ev();
extern void _ZN10S2005C3_nt4v106Ev();
extern void _ZN10S2005C3_nt4v107Ev();
extern void _ZN10S2005C3_nt4v108Ev();
extern void _ZN10S2005C3_nt4v109Ev();
extern void _ZN10S2005C3_nt4v110Ev();
static  VTBL_ENTRY vtc_S2005C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2005C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S2005C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v110Ev,
};
extern VTBL_ENTRY _ZTI10S2005C3_nt[];
VTBL_ENTRY *P__ZTI10S2005C3_nt = _ZTI10S2005C3_nt; 
extern  VTBL_ENTRY _ZTV10S2005C3_nt[];
Class_Descriptor cd_S2005C3_nt = {  "S2005C3_nt", // class name
  bases_S2005C3_nt, 1,
  &(vtc_S2005C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(832,632), // object size
  NSPAIRA(_ZTI10S2005C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S2005C3_nt),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2005C2_nt  : S2005C3_nt {
  int s2005c2f0[4];
  void *s2005c2f1;
  unsigned char s2005c2f2:1;
  unsigned char s2005c2f3:1;
  unsigned char s2005c2f4:1;
  unsigned char s2005c2f5:1;
  unsigned char s2005c2f6:1;
  unsigned char s2005c2f7:1;
  int s2005c2f8:8;
  int s2005c2f9:16;
  int s2005c2f10:16;
  int s2005c2f11:16;
  int s2005c2f12:16;
  int s2005c2f13:16;
  int s2005c2f14;
  ::S2005C22 s2005c2f15;
  unsigned char s2005c2f16:1;
  unsigned char s2005c2f17:1;
  virtual  ~S2005C2_nt(); // _ZN10S2005C2_ntD1Ev
  virtual void  v111(); // _ZN10S2005C2_nt4v111Ev
  virtual void  v112(); // _ZN10S2005C2_nt4v112Ev
  virtual void  v113(); // _ZN10S2005C2_nt4v113Ev
  virtual void  v114(); // _ZN10S2005C2_nt4v114Ev
  virtual void  v115(); // _ZN10S2005C2_nt4v115Ev
  virtual void  v116(); // _ZN10S2005C2_nt4v116Ev
  virtual void  v117(); // _ZN10S2005C2_nt4v117Ev
  virtual void  v118(); // _ZN10S2005C2_nt4v118Ev
  virtual void  v119(); // _ZN10S2005C2_nt4v119Ev
  virtual void  v120(); // _ZN10S2005C2_nt4v120Ev
  virtual void  v121(); // _ZN10S2005C2_nt4v121Ev
  virtual void  v122(); // _ZN10S2005C2_nt4v122Ev
  virtual void  v123(); // _ZN10S2005C2_nt4v123Ev
  virtual void  v124(); // _ZN10S2005C2_nt4v124Ev
  virtual void  v125(); // _ZN10S2005C2_nt4v125Ev
  virtual void  v126(); // _ZN10S2005C2_nt4v126Ev
  virtual void  v127(); // _ZN10S2005C2_nt4v127Ev
  virtual void  v128(); // _ZN10S2005C2_nt4v128Ev
  virtual void  v129(); // _ZN10S2005C2_nt4v129Ev
  virtual void  v130(); // _ZN10S2005C2_nt4v130Ev
  virtual void  v131(); // _ZN10S2005C2_nt4v131Ev
  virtual void  v132(); // _ZN10S2005C2_nt4v132Ev
  virtual void  v133(); // _ZN10S2005C2_nt4v133Ev
  virtual void  v134(); // _ZN10S2005C2_nt4v134Ev
  virtual void  v135(); // _ZN10S2005C2_nt4v135Ev
  virtual void  v136(); // _ZN10S2005C2_nt4v136Ev
  virtual void  v137(); // _ZN10S2005C2_nt4v137Ev
  virtual void  v138(); // _ZN10S2005C2_nt4v138Ev
  virtual void  v139(); // _ZN10S2005C2_nt4v139Ev
  virtual void  v140(); // _ZN10S2005C2_nt4v140Ev
  virtual void  v141(); // _ZN10S2005C2_nt4v141Ev
  virtual void  v142(); // _ZN10S2005C2_nt4v142Ev
  virtual void  v143(); // _ZN10S2005C2_nt4v143Ev
  virtual void  v144(); // _ZN10S2005C2_nt4v144Ev
  virtual void  v145(); // _ZN10S2005C2_nt4v145Ev
  virtual void  v146(); // _ZN10S2005C2_nt4v146Ev
  virtual void  v147(); // _ZN10S2005C2_nt4v147Ev
  virtual void  v148(); // _ZN10S2005C2_nt4v148Ev
  virtual void  v149(); // _ZN10S2005C2_nt4v149Ev
  S2005C2_nt(); // tgen
};
//SIG(-1 S2005C2_nt) C1{ BC2{ BC3{ vd v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 Fp Fi FC4{ BC5{ m Fp Fi FC6{ m} FC6}} FC4 Fi} vd v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 FC7{ m FC8{ m FL[2]}} FC7 FC7 FC7 FC9{ m FC7} FC10{ m FC7 FC7 FC7 FC7} FC10 FC7 FC7 FC7 Fp FC9 FC11{ m FC12{ m Fp Fi FC13{ m}} Fi} Fi Fp[7] FC14{ m Fp Fi FC13 FC15{ m}} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC16{ BC17{ m Fp Fi FC15 FC18{ m}}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC19{ m Fp Fi[2] FC18} Fp[2] Fi:16 Fi:16 FC16 FC19 FC20{ m Fp Fi[2] FC21{ m}} Fp[2] Fi:24 Fi:8 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 Fi[4] Fp Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi:8 Fi:16 Fi:16 Fi:16 Fi:16 Fi:16 Fi FC14 Fc:1 Fc:1}


 S2005C2_nt ::~S2005C2_nt(){ note_dtor("S2005C2_nt", this);}
void  S2005C2_nt ::v111(){vfunc_called(this, "_ZN10S2005C2_nt4v111Ev");}
void  S2005C2_nt ::v112(){vfunc_called(this, "_ZN10S2005C2_nt4v112Ev");}
void  S2005C2_nt ::v113(){vfunc_called(this, "_ZN10S2005C2_nt4v113Ev");}
void  S2005C2_nt ::v114(){vfunc_called(this, "_ZN10S2005C2_nt4v114Ev");}
void  S2005C2_nt ::v115(){vfunc_called(this, "_ZN10S2005C2_nt4v115Ev");}
void  S2005C2_nt ::v116(){vfunc_called(this, "_ZN10S2005C2_nt4v116Ev");}
void  S2005C2_nt ::v117(){vfunc_called(this, "_ZN10S2005C2_nt4v117Ev");}
void  S2005C2_nt ::v118(){vfunc_called(this, "_ZN10S2005C2_nt4v118Ev");}
void  S2005C2_nt ::v119(){vfunc_called(this, "_ZN10S2005C2_nt4v119Ev");}
void  S2005C2_nt ::v120(){vfunc_called(this, "_ZN10S2005C2_nt4v120Ev");}
void  S2005C2_nt ::v121(){vfunc_called(this, "_ZN10S2005C2_nt4v121Ev");}
void  S2005C2_nt ::v122(){vfunc_called(this, "_ZN10S2005C2_nt4v122Ev");}
void  S2005C2_nt ::v123(){vfunc_called(this, "_ZN10S2005C2_nt4v123Ev");}
void  S2005C2_nt ::v124(){vfunc_called(this, "_ZN10S2005C2_nt4v124Ev");}
void  S2005C2_nt ::v125(){vfunc_called(this, "_ZN10S2005C2_nt4v125Ev");}
void  S2005C2_nt ::v126(){vfunc_called(this, "_ZN10S2005C2_nt4v126Ev");}
void  S2005C2_nt ::v127(){vfunc_called(this, "_ZN10S2005C2_nt4v127Ev");}
void  S2005C2_nt ::v128(){vfunc_called(this, "_ZN10S2005C2_nt4v128Ev");}
void  S2005C2_nt ::v129(){vfunc_called(this, "_ZN10S2005C2_nt4v129Ev");}
void  S2005C2_nt ::v130(){vfunc_called(this, "_ZN10S2005C2_nt4v130Ev");}
void  S2005C2_nt ::v131(){vfunc_called(this, "_ZN10S2005C2_nt4v131Ev");}
void  S2005C2_nt ::v132(){vfunc_called(this, "_ZN10S2005C2_nt4v132Ev");}
void  S2005C2_nt ::v133(){vfunc_called(this, "_ZN10S2005C2_nt4v133Ev");}
void  S2005C2_nt ::v134(){vfunc_called(this, "_ZN10S2005C2_nt4v134Ev");}
void  S2005C2_nt ::v135(){vfunc_called(this, "_ZN10S2005C2_nt4v135Ev");}
void  S2005C2_nt ::v136(){vfunc_called(this, "_ZN10S2005C2_nt4v136Ev");}
void  S2005C2_nt ::v137(){vfunc_called(this, "_ZN10S2005C2_nt4v137Ev");}
void  S2005C2_nt ::v138(){vfunc_called(this, "_ZN10S2005C2_nt4v138Ev");}
void  S2005C2_nt ::v139(){vfunc_called(this, "_ZN10S2005C2_nt4v139Ev");}
void  S2005C2_nt ::v140(){vfunc_called(this, "_ZN10S2005C2_nt4v140Ev");}
void  S2005C2_nt ::v141(){vfunc_called(this, "_ZN10S2005C2_nt4v141Ev");}
void  S2005C2_nt ::v142(){vfunc_called(this, "_ZN10S2005C2_nt4v142Ev");}
void  S2005C2_nt ::v143(){vfunc_called(this, "_ZN10S2005C2_nt4v143Ev");}
void  S2005C2_nt ::v144(){vfunc_called(this, "_ZN10S2005C2_nt4v144Ev");}
void  S2005C2_nt ::v145(){vfunc_called(this, "_ZN10S2005C2_nt4v145Ev");}
void  S2005C2_nt ::v146(){vfunc_called(this, "_ZN10S2005C2_nt4v146Ev");}
void  S2005C2_nt ::v147(){vfunc_called(this, "_ZN10S2005C2_nt4v147Ev");}
void  S2005C2_nt ::v148(){vfunc_called(this, "_ZN10S2005C2_nt4v148Ev");}
void  S2005C2_nt ::v149(){vfunc_called(this, "_ZN10S2005C2_nt4v149Ev");}
S2005C2_nt ::S2005C2_nt(){ note_ctor("S2005C2_nt", this);} // tgen

//skip512 S2005C2_nt

#else // __cplusplus

extern void _ZN10S2005C2_ntC1Ev();
extern void _ZN10S2005C2_ntD1Ev();
Name_Map name_map_S2005C2_nt[] = {
  NSPAIR(_ZN10S2005C2_ntC1Ev),
  NSPAIR(_ZN10S2005C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2005C4_nt;
extern VTBL_ENTRY _ZTI10S2005C4_nt[];
extern  VTBL_ENTRY _ZTV10S2005C4_nt[];
extern Class_Descriptor cd_S2005C3_nt;
extern VTBL_ENTRY _ZTI10S2005C3_nt[];
extern  VTBL_ENTRY _ZTV10S2005C3_nt[];
static Base_Class bases_S2005C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2005C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2005C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S2005C2_nt[];
extern void _ZN10S2005C2_ntD1Ev();
extern void _ZN10S2005C2_ntD0Ev();
extern void _ZN10S2005C4_nt3v10Ev();
extern void _ZN10S2005C4_nt3v11Ev();
extern void _ZN10S2005C4_nt3v12Ev();
extern void _ZN10S2005C4_nt3v13Ev();
extern void _ZN10S2005C4_nt3v14Ev();
extern void _ZN10S2005C4_nt3v15Ev();
extern void _ZN10S2005C4_nt3v16Ev();
extern void _ZN10S2005C4_nt3v17Ev();
extern void _ZN10S2005C4_nt3v18Ev();
extern void _ZN10S2005C4_nt3v19Ev();
extern void _ZN10S2005C4_nt3v20Ev();
extern void _ZN10S2005C4_nt3v21Ev();
extern void _ZN10S2005C4_nt3v22Ev();
extern void _ZN10S2005C4_nt3v23Ev();
extern void _ZN10S2005C4_nt3v24Ev();
extern void _ZN10S2005C4_nt3v25Ev();
extern void _ZN10S2005C4_nt3v26Ev();
extern void _ZN10S2005C4_nt3v27Ev();
extern void _ZN10S2005C4_nt3v28Ev();
extern void _ZN10S2005C4_nt3v29Ev();
extern void _ZN10S2005C4_nt3v30Ev();
extern void _ZN10S2005C4_nt3v31Ev();
extern void _ZN10S2005C4_nt3v32Ev();
extern void _ZN10S2005C3_nt3v33Ev();
extern void _ZN10S2005C3_nt3v34Ev();
extern void _ZN10S2005C3_nt3v35Ev();
extern void _ZN10S2005C3_nt3v36Ev();
extern void _ZN10S2005C3_nt3v37Ev();
extern void _ZN10S2005C3_nt3v38Ev();
extern void _ZN10S2005C3_nt3v39Ev();
extern void _ZN10S2005C3_nt3v40Ev();
extern void _ZN10S2005C3_nt3v41Ev();
extern void _ZN10S2005C3_nt3v42Ev();
extern void _ZN10S2005C3_nt3v43Ev();
extern void _ZN10S2005C3_nt3v44Ev();
extern void _ZN10S2005C3_nt3v45Ev();
extern void _ZN10S2005C3_nt3v46Ev();
extern void _ZN10S2005C3_nt3v47Ev();
extern void _ZN10S2005C3_nt3v48Ev();
extern void _ZN10S2005C3_nt3v49Ev();
extern void _ZN10S2005C3_nt3v50Ev();
extern void _ZN10S2005C3_nt3v51Ev();
extern void _ZN10S2005C3_nt3v52Ev();
extern void _ZN10S2005C3_nt3v53Ev();
extern void _ZN10S2005C3_nt3v54Ev();
extern void _ZN10S2005C3_nt3v55Ev();
extern void _ZN10S2005C3_nt3v56Ev();
extern void _ZN10S2005C3_nt3v57Ev();
extern void _ZN10S2005C3_nt3v58Ev();
extern void _ZN10S2005C3_nt3v59Ev();
extern void _ZN10S2005C3_nt3v60Ev();
extern void _ZN10S2005C3_nt3v61Ev();
extern void _ZN10S2005C3_nt3v62Ev();
extern void _ZN10S2005C3_nt3v63Ev();
extern void _ZN10S2005C3_nt3v64Ev();
extern void _ZN10S2005C3_nt3v65Ev();
extern void _ZN10S2005C3_nt3v66Ev();
extern void _ZN10S2005C3_nt3v67Ev();
extern void _ZN10S2005C3_nt3v68Ev();
extern void _ZN10S2005C3_nt3v69Ev();
extern void _ZN10S2005C3_nt3v70Ev();
extern void _ZN10S2005C3_nt3v71Ev();
extern void _ZN10S2005C3_nt3v72Ev();
extern void _ZN10S2005C3_nt3v73Ev();
extern void _ZN10S2005C3_nt3v74Ev();
extern void _ZN10S2005C3_nt3v75Ev();
extern void _ZN10S2005C3_nt3v76Ev();
extern void _ZN10S2005C3_nt3v77Ev();
extern void _ZN10S2005C3_nt3v78Ev();
extern void _ZN10S2005C3_nt3v79Ev();
extern void _ZN10S2005C3_nt3v80Ev();
extern void _ZN10S2005C3_nt3v81Ev();
extern void _ZN10S2005C3_nt3v82Ev();
extern void _ZN10S2005C3_nt3v83Ev();
extern void _ZN10S2005C3_nt3v84Ev();
extern void _ZN10S2005C3_nt3v85Ev();
extern void _ZN10S2005C3_nt3v86Ev();
extern void _ZN10S2005C3_nt3v87Ev();
extern void _ZN10S2005C3_nt3v88Ev();
extern void _ZN10S2005C3_nt3v89Ev();
extern void _ZN10S2005C3_nt3v90Ev();
extern void _ZN10S2005C3_nt3v91Ev();
extern void _ZN10S2005C3_nt3v92Ev();
extern void _ZN10S2005C3_nt3v93Ev();
extern void _ZN10S2005C3_nt3v94Ev();
extern void _ZN10S2005C3_nt3v95Ev();
extern void _ZN10S2005C3_nt3v96Ev();
extern void _ZN10S2005C3_nt3v97Ev();
extern void _ZN10S2005C3_nt3v98Ev();
extern void _ZN10S2005C3_nt3v99Ev();
extern void _ZN10S2005C3_nt4v100Ev();
extern void _ZN10S2005C3_nt4v101Ev();
extern void _ZN10S2005C3_nt4v102Ev();
extern void _ZN10S2005C3_nt4v103Ev();
extern void _ZN10S2005C3_nt4v104Ev();
extern void _ZN10S2005C3_nt4v105Ev();
extern void _ZN10S2005C3_nt4v106Ev();
extern void _ZN10S2005C3_nt4v107Ev();
extern void _ZN10S2005C3_nt4v108Ev();
extern void _ZN10S2005C3_nt4v109Ev();
extern void _ZN10S2005C3_nt4v110Ev();
extern void _ZN10S2005C2_nt4v111Ev();
extern void _ZN10S2005C2_nt4v112Ev();
extern void _ZN10S2005C2_nt4v113Ev();
extern void _ZN10S2005C2_nt4v114Ev();
extern void _ZN10S2005C2_nt4v115Ev();
extern void _ZN10S2005C2_nt4v116Ev();
extern void _ZN10S2005C2_nt4v117Ev();
extern void _ZN10S2005C2_nt4v118Ev();
extern void _ZN10S2005C2_nt4v119Ev();
extern void _ZN10S2005C2_nt4v120Ev();
extern void _ZN10S2005C2_nt4v121Ev();
extern void _ZN10S2005C2_nt4v122Ev();
extern void _ZN10S2005C2_nt4v123Ev();
extern void _ZN10S2005C2_nt4v124Ev();
extern void _ZN10S2005C2_nt4v125Ev();
extern void _ZN10S2005C2_nt4v126Ev();
extern void _ZN10S2005C2_nt4v127Ev();
extern void _ZN10S2005C2_nt4v128Ev();
extern void _ZN10S2005C2_nt4v129Ev();
extern void _ZN10S2005C2_nt4v130Ev();
extern void _ZN10S2005C2_nt4v131Ev();
extern void _ZN10S2005C2_nt4v132Ev();
extern void _ZN10S2005C2_nt4v133Ev();
extern void _ZN10S2005C2_nt4v134Ev();
extern void _ZN10S2005C2_nt4v135Ev();
extern void _ZN10S2005C2_nt4v136Ev();
extern void _ZN10S2005C2_nt4v137Ev();
extern void _ZN10S2005C2_nt4v138Ev();
extern void _ZN10S2005C2_nt4v139Ev();
extern void _ZN10S2005C2_nt4v140Ev();
extern void _ZN10S2005C2_nt4v141Ev();
extern void _ZN10S2005C2_nt4v142Ev();
extern void _ZN10S2005C2_nt4v143Ev();
extern void _ZN10S2005C2_nt4v144Ev();
extern void _ZN10S2005C2_nt4v145Ev();
extern void _ZN10S2005C2_nt4v146Ev();
extern void _ZN10S2005C2_nt4v147Ev();
extern void _ZN10S2005C2_nt4v148Ev();
extern void _ZN10S2005C2_nt4v149Ev();
static  VTBL_ENTRY vtc_S2005C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2005C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S2005C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v149Ev,
};
extern VTBL_ENTRY _ZTI10S2005C2_nt[];
VTBL_ENTRY *P__ZTI10S2005C2_nt = _ZTI10S2005C2_nt; 
extern  VTBL_ENTRY _ZTV10S2005C2_nt[];
Class_Descriptor cd_S2005C2_nt = {  "S2005C2_nt", // class name
  bases_S2005C2_nt, 2,
  &(vtc_S2005C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(896,684), // object size
  NSPAIRA(_ZTI10S2005C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S2005C2_nt),144, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2005C1  : S2005C2_nt {
  int s2005c1f0:4;
  int s2005c1f1:4;
  int s2005c1f2:4;
  int s2005c1f3[3];
  virtual  ~S2005C1(); // _ZN7S2005C1D1Ev
  virtual void  v1(); // _ZN7S2005C12v1Ev
  virtual void  v2(); // _ZN7S2005C12v2Ev
  virtual void  v3(); // _ZN7S2005C12v3Ev
  virtual void  v4(); // _ZN7S2005C12v4Ev
  virtual void  v5(); // _ZN7S2005C12v5Ev
  virtual void  v6(); // _ZN7S2005C12v6Ev
  virtual void  v7(); // _ZN7S2005C12v7Ev
  virtual void  v8(); // _ZN7S2005C12v8Ev
  virtual void  v9(); // _ZN7S2005C12v9Ev
  S2005C1(); // tgen
};
//SIG(1 S2005C1) C1{ BC2{ BC3{ BC4{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 Fp Fi FC5{ BC6{ m Fp Fi FC7{ m} FC7}} FC5 Fi} vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8 FC10{ m FC8} FC11{ m FC8 FC8 FC8 FC8} FC11 FC8 FC8 FC8 Fp FC10 FC12{ m FC13{ m Fp Fi FC14{ m}} Fi} Fi Fp[7] FC15{ m Fp Fi FC14 FC16{ m}} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC17{ BC18{ m Fp Fi FC16 FC19{ m}}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC20{ m Fp Fi[2] FC19} Fp[2] Fi:16 Fi:16 FC17 FC20 FC21{ m Fp Fi[2] FC22{ m}} Fp[2] Fi:24 Fi:8 Fp} vd v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 Fi[4] Fp Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi:8 Fi:16 Fi:16 Fi:16 Fi:16 Fi:16 Fi FC15 Fc:1 Fc:1} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fi:4 Fi:4 Fi:4 Fi[3]}


 S2005C1 ::~S2005C1(){ note_dtor("S2005C1", this);}
void  S2005C1 ::v1(){vfunc_called(this, "_ZN7S2005C12v1Ev");}
void  S2005C1 ::v2(){vfunc_called(this, "_ZN7S2005C12v2Ev");}
void  S2005C1 ::v3(){vfunc_called(this, "_ZN7S2005C12v3Ev");}
void  S2005C1 ::v4(){vfunc_called(this, "_ZN7S2005C12v4Ev");}
void  S2005C1 ::v5(){vfunc_called(this, "_ZN7S2005C12v5Ev");}
void  S2005C1 ::v6(){vfunc_called(this, "_ZN7S2005C12v6Ev");}
void  S2005C1 ::v7(){vfunc_called(this, "_ZN7S2005C12v7Ev");}
void  S2005C1 ::v8(){vfunc_called(this, "_ZN7S2005C12v8Ev");}
void  S2005C1 ::v9(){vfunc_called(this, "_ZN7S2005C12v9Ev");}
S2005C1 ::S2005C1(){ note_ctor("S2005C1", this);} // tgen

static void Test_S2005C1()
{
  extern Class_Descriptor cd_S2005C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(114,175)];
    init_test(&cd_S2005C1, buf);
    S2005C1 *dp, &lv = *(dp=new (buf) S2005C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(904,696), "sizeof(S2005C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2005C1)");
    check_base_class_offset(lv, (S2005C4_nt*)(S2005C3_nt*)(S2005C2_nt*), 0, "S2005C1");
    check_base_class_offset(lv, (S2005C3_nt*)(S2005C2_nt*), 0, "S2005C1");
    check_base_class_offset(lv, (S2005C2_nt*), 0, "S2005C1");
    set_bf_and_test(lv, s2005c1f0, ABISELECT(889,681), 0, 4, 1, "S2005C1");
    set_bf_and_test(lv, s2005c1f0, ABISELECT(889,681), 0, 4, hide_sll(1LL<<3), "S2005C1");
    set_bf_and_test(lv, s2005c1f1, ABISELECT(889,681), 4, 4, 1, "S2005C1");
    set_bf_and_test(lv, s2005c1f1, ABISELECT(889,681), 4, 4, hide_sll(1LL<<3), "S2005C1");
    set_bf_and_test(lv, s2005c1f2, ABISELECT(890,682), 0, 4, 1, "S2005C1");
    set_bf_and_test(lv, s2005c1f2, ABISELECT(890,682), 0, 4, hide_sll(1LL<<3), "S2005C1");
    check_field_offset(lv, s2005c1f3, ABISELECT(892,684), "S2005C1.s2005c1f3");
    test_class_info(&lv, &cd_S2005C1);
    dp->~S2005C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2005C1(Test_S2005C1, "S2005C1", ABISELECT(904,696));

#else // __cplusplus

extern void _ZN7S2005C1C1Ev();
extern void _ZN7S2005C1D1Ev();
Name_Map name_map_S2005C1[] = {
  NSPAIR(_ZN7S2005C1C1Ev),
  NSPAIR(_ZN7S2005C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2005C4_nt;
extern VTBL_ENTRY _ZTI10S2005C4_nt[];
extern  VTBL_ENTRY _ZTV10S2005C4_nt[];
extern Class_Descriptor cd_S2005C3_nt;
extern VTBL_ENTRY _ZTI10S2005C3_nt[];
extern  VTBL_ENTRY _ZTV10S2005C3_nt[];
extern Class_Descriptor cd_S2005C2_nt;
extern VTBL_ENTRY _ZTI10S2005C2_nt[];
extern  VTBL_ENTRY _ZTV10S2005C2_nt[];
static Base_Class bases_S2005C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2005C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2005C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2005C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2005C1[];
extern void _ZN7S2005C1D1Ev();
extern void _ZN7S2005C1D0Ev();
extern void _ZN10S2005C4_nt3v10Ev();
extern void _ZN10S2005C4_nt3v11Ev();
extern void _ZN10S2005C4_nt3v12Ev();
extern void _ZN10S2005C4_nt3v13Ev();
extern void _ZN10S2005C4_nt3v14Ev();
extern void _ZN10S2005C4_nt3v15Ev();
extern void _ZN10S2005C4_nt3v16Ev();
extern void _ZN10S2005C4_nt3v17Ev();
extern void _ZN10S2005C4_nt3v18Ev();
extern void _ZN10S2005C4_nt3v19Ev();
extern void _ZN10S2005C4_nt3v20Ev();
extern void _ZN10S2005C4_nt3v21Ev();
extern void _ZN10S2005C4_nt3v22Ev();
extern void _ZN10S2005C4_nt3v23Ev();
extern void _ZN10S2005C4_nt3v24Ev();
extern void _ZN10S2005C4_nt3v25Ev();
extern void _ZN10S2005C4_nt3v26Ev();
extern void _ZN10S2005C4_nt3v27Ev();
extern void _ZN10S2005C4_nt3v28Ev();
extern void _ZN10S2005C4_nt3v29Ev();
extern void _ZN10S2005C4_nt3v30Ev();
extern void _ZN10S2005C4_nt3v31Ev();
extern void _ZN10S2005C4_nt3v32Ev();
extern void _ZN10S2005C3_nt3v33Ev();
extern void _ZN10S2005C3_nt3v34Ev();
extern void _ZN10S2005C3_nt3v35Ev();
extern void _ZN10S2005C3_nt3v36Ev();
extern void _ZN10S2005C3_nt3v37Ev();
extern void _ZN10S2005C3_nt3v38Ev();
extern void _ZN10S2005C3_nt3v39Ev();
extern void _ZN10S2005C3_nt3v40Ev();
extern void _ZN10S2005C3_nt3v41Ev();
extern void _ZN10S2005C3_nt3v42Ev();
extern void _ZN10S2005C3_nt3v43Ev();
extern void _ZN10S2005C3_nt3v44Ev();
extern void _ZN10S2005C3_nt3v45Ev();
extern void _ZN10S2005C3_nt3v46Ev();
extern void _ZN10S2005C3_nt3v47Ev();
extern void _ZN10S2005C3_nt3v48Ev();
extern void _ZN10S2005C3_nt3v49Ev();
extern void _ZN10S2005C3_nt3v50Ev();
extern void _ZN10S2005C3_nt3v51Ev();
extern void _ZN10S2005C3_nt3v52Ev();
extern void _ZN10S2005C3_nt3v53Ev();
extern void _ZN10S2005C3_nt3v54Ev();
extern void _ZN10S2005C3_nt3v55Ev();
extern void _ZN10S2005C3_nt3v56Ev();
extern void _ZN10S2005C3_nt3v57Ev();
extern void _ZN10S2005C3_nt3v58Ev();
extern void _ZN10S2005C3_nt3v59Ev();
extern void _ZN10S2005C3_nt3v60Ev();
extern void _ZN10S2005C3_nt3v61Ev();
extern void _ZN10S2005C3_nt3v62Ev();
extern void _ZN10S2005C3_nt3v63Ev();
extern void _ZN10S2005C3_nt3v64Ev();
extern void _ZN10S2005C3_nt3v65Ev();
extern void _ZN10S2005C3_nt3v66Ev();
extern void _ZN10S2005C3_nt3v67Ev();
extern void _ZN10S2005C3_nt3v68Ev();
extern void _ZN10S2005C3_nt3v69Ev();
extern void _ZN10S2005C3_nt3v70Ev();
extern void _ZN10S2005C3_nt3v71Ev();
extern void _ZN10S2005C3_nt3v72Ev();
extern void _ZN10S2005C3_nt3v73Ev();
extern void _ZN10S2005C3_nt3v74Ev();
extern void _ZN10S2005C3_nt3v75Ev();
extern void _ZN10S2005C3_nt3v76Ev();
extern void _ZN10S2005C3_nt3v77Ev();
extern void _ZN10S2005C3_nt3v78Ev();
extern void _ZN10S2005C3_nt3v79Ev();
extern void _ZN10S2005C3_nt3v80Ev();
extern void _ZN10S2005C3_nt3v81Ev();
extern void _ZN10S2005C3_nt3v82Ev();
extern void _ZN10S2005C3_nt3v83Ev();
extern void _ZN10S2005C3_nt3v84Ev();
extern void _ZN10S2005C3_nt3v85Ev();
extern void _ZN10S2005C3_nt3v86Ev();
extern void _ZN10S2005C3_nt3v87Ev();
extern void _ZN10S2005C3_nt3v88Ev();
extern void _ZN10S2005C3_nt3v89Ev();
extern void _ZN10S2005C3_nt3v90Ev();
extern void _ZN10S2005C3_nt3v91Ev();
extern void _ZN10S2005C3_nt3v92Ev();
extern void _ZN10S2005C3_nt3v93Ev();
extern void _ZN10S2005C3_nt3v94Ev();
extern void _ZN10S2005C3_nt3v95Ev();
extern void _ZN10S2005C3_nt3v96Ev();
extern void _ZN10S2005C3_nt3v97Ev();
extern void _ZN10S2005C3_nt3v98Ev();
extern void _ZN10S2005C3_nt3v99Ev();
extern void _ZN10S2005C3_nt4v100Ev();
extern void _ZN10S2005C3_nt4v101Ev();
extern void _ZN10S2005C3_nt4v102Ev();
extern void _ZN10S2005C3_nt4v103Ev();
extern void _ZN10S2005C3_nt4v104Ev();
extern void _ZN10S2005C3_nt4v105Ev();
extern void _ZN10S2005C3_nt4v106Ev();
extern void _ZN10S2005C3_nt4v107Ev();
extern void _ZN10S2005C3_nt4v108Ev();
extern void _ZN10S2005C3_nt4v109Ev();
extern void _ZN10S2005C3_nt4v110Ev();
extern void _ZN10S2005C2_nt4v111Ev();
extern void _ZN10S2005C2_nt4v112Ev();
extern void _ZN10S2005C2_nt4v113Ev();
extern void _ZN10S2005C2_nt4v114Ev();
extern void _ZN10S2005C2_nt4v115Ev();
extern void _ZN10S2005C2_nt4v116Ev();
extern void _ZN10S2005C2_nt4v117Ev();
extern void _ZN10S2005C2_nt4v118Ev();
extern void _ZN10S2005C2_nt4v119Ev();
extern void _ZN10S2005C2_nt4v120Ev();
extern void _ZN10S2005C2_nt4v121Ev();
extern void _ZN10S2005C2_nt4v122Ev();
extern void _ZN10S2005C2_nt4v123Ev();
extern void _ZN10S2005C2_nt4v124Ev();
extern void _ZN10S2005C2_nt4v125Ev();
extern void _ZN10S2005C2_nt4v126Ev();
extern void _ZN10S2005C2_nt4v127Ev();
extern void _ZN10S2005C2_nt4v128Ev();
extern void _ZN10S2005C2_nt4v129Ev();
extern void _ZN10S2005C2_nt4v130Ev();
extern void _ZN10S2005C2_nt4v131Ev();
extern void _ZN10S2005C2_nt4v132Ev();
extern void _ZN10S2005C2_nt4v133Ev();
extern void _ZN10S2005C2_nt4v134Ev();
extern void _ZN10S2005C2_nt4v135Ev();
extern void _ZN10S2005C2_nt4v136Ev();
extern void _ZN10S2005C2_nt4v137Ev();
extern void _ZN10S2005C2_nt4v138Ev();
extern void _ZN10S2005C2_nt4v139Ev();
extern void _ZN10S2005C2_nt4v140Ev();
extern void _ZN10S2005C2_nt4v141Ev();
extern void _ZN10S2005C2_nt4v142Ev();
extern void _ZN10S2005C2_nt4v143Ev();
extern void _ZN10S2005C2_nt4v144Ev();
extern void _ZN10S2005C2_nt4v145Ev();
extern void _ZN10S2005C2_nt4v146Ev();
extern void _ZN10S2005C2_nt4v147Ev();
extern void _ZN10S2005C2_nt4v148Ev();
extern void _ZN10S2005C2_nt4v149Ev();
extern void _ZN7S2005C12v1Ev();
extern void _ZN7S2005C12v2Ev();
extern void _ZN7S2005C12v3Ev();
extern void _ZN7S2005C12v4Ev();
extern void _ZN7S2005C12v5Ev();
extern void _ZN7S2005C12v6Ev();
extern void _ZN7S2005C12v7Ev();
extern void _ZN7S2005C12v8Ev();
extern void _ZN7S2005C12v9Ev();
static  VTBL_ENTRY vtc_S2005C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2005C1[0]),
  (VTBL_ENTRY)&_ZN7S2005C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2005C1D0Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2005C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S2005C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S2005C2_nt4v149Ev,
  (VTBL_ENTRY)&_ZN7S2005C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2005C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2005C12v3Ev,
  (VTBL_ENTRY)&_ZN7S2005C12v4Ev,
  (VTBL_ENTRY)&_ZN7S2005C12v5Ev,
  (VTBL_ENTRY)&_ZN7S2005C12v6Ev,
  (VTBL_ENTRY)&_ZN7S2005C12v7Ev,
  (VTBL_ENTRY)&_ZN7S2005C12v8Ev,
  (VTBL_ENTRY)&_ZN7S2005C12v9Ev,
};
extern VTBL_ENTRY _ZTI7S2005C1[];
extern  VTBL_ENTRY _ZTV7S2005C1[];
Class_Descriptor cd_S2005C1 = {  "S2005C1", // class name
  bases_S2005C1, 3,
  &(vtc_S2005C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(904,696), // object size
  NSPAIRA(_ZTI7S2005C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2005C1),153, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3624C3_nt  {
  ::S2005C26 s3624c3f0;
  ::S2005C22 s3624c3f1;
  char s3624c3f2;
  void  mf3624c3(); // _ZN10S3624C3_nt8mf3624c3Ev
  virtual  ~S3624C3_nt(); // _ZN10S3624C3_ntD1Ev
  S3624C3_nt(); // tgen
};
//SIG(-1 S3624C3_nt) C1{ vd m FC2{ m Fp Fi FC3{ m} FC4{ m}} FC5{ m Fp Fi FC6{ m} FC3} Fc}


void  S3624C3_nt ::mf3624c3(){}
 S3624C3_nt ::~S3624C3_nt(){ note_dtor("S3624C3_nt", this);}
S3624C3_nt ::S3624C3_nt(){ note_ctor("S3624C3_nt", this);} // tgen

//skip512 S3624C3_nt

#else // __cplusplus

extern void _ZN10S3624C3_ntC1Ev();
extern void _ZN10S3624C3_ntD1Ev();
Name_Map name_map_S3624C3_nt[] = {
  NSPAIR(_ZN10S3624C3_ntC1Ev),
  NSPAIR(_ZN10S3624C3_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S3624C3_nt[];
extern void _ZN10S3624C3_ntD1Ev();
extern void _ZN10S3624C3_ntD0Ev();
static  VTBL_ENTRY vtc_S3624C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S3624C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S3624C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S3624C3_ntD0Ev,
};
extern VTBL_ENTRY _ZTI10S3624C3_nt[];
VTBL_ENTRY *P__ZTI10S3624C3_nt = _ZTI10S3624C3_nt; 
extern  VTBL_ENTRY _ZTV10S3624C3_nt[];
Class_Descriptor cd_S3624C3_nt = {  "S3624C3_nt", // class name
  0,0,//no base classes
  &(vtc_S3624C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI10S3624C3_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S3624C3_nt),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3624C10_nt  {
  char s3624c10f0;
  long s3624c10f1[2];
  short s3624c10f2[12];
  char s3624c10f3[5];
  void  mf3624c10(); // _ZN11S3624C10_nt9mf3624c10Ev
};
//SIG(-1 S3624C10_nt) C1{ m Fc Fl[2] Fs[12] Fc[5]}


void  S3624C10_nt ::mf3624c10(){}

//skip512 S3624C10_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3624C11_nt  {
  char s3624c11f0;
  long s3624c11f1[4];
  int s3624c11f2[4];
  void  mf3624c11(); // _ZN11S3624C11_nt9mf3624c11Ev
};
//SIG(-1 S3624C11_nt) C1{ m Fc Fl[4] Fi[4]}


void  S3624C11_nt ::mf3624c11(){}

//skip512 S3624C11_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3624C14_nt  {
  long s3624c14f0[4];
};
//SIG(-1 S3624C14_nt) C1{ Fl[4]}



//skip512 S3624C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3624C13_nt  {
  ::S3624C14_nt s3624c13f0;
  void  mf3624c13(); // _ZN11S3624C13_nt9mf3624c13Ev
};
//SIG(-1 S3624C13_nt) C1{ m FC2{ Fl[4]}}


void  S3624C13_nt ::mf3624c13(){}

//skip512 S3624C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3624C12_nt  {
  ::S3624C13_nt s3624c12f0;
  char s3624c12f1;
  void *s3624c12f2;
  int s3624c12f3[3];
  void  mf3624c12(); // _ZN11S3624C12_nt9mf3624c12Ev
};
//SIG(-1 S3624C12_nt) C1{ m FC2{ m FC3{ Fl[4]}} Fc Fp Fi[3]}


void  S3624C12_nt ::mf3624c12(){}

//skip512 S3624C12_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3624C24_nt  {
  char s3624c24f0[11];
  void  mf3624c24(); // _ZN11S3624C24_nt9mf3624c24Ev
};
//SIG(-1 S3624C24_nt) C1{ m Fc[11]}


void  S3624C24_nt ::mf3624c24(){}

//skip512 S3624C24_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3624C23_nt  {
  ::S3624C24_nt s3624c23f0;
  int s3624c23f1[7];
  __tsi64 s3624c23f2;
  void  mf3624c23(); // _ZN11S3624C23_nt9mf3624c23Ev
};
//SIG(-1 S3624C23_nt) C1{ m FC2{ m Fc[11]} Fi[7] FL}


void  S3624C23_nt ::mf3624c23(){}

//skip512 S3624C23_nt

#else // __cplusplus

Class_Descriptor cd_S3624C23_nt = {  "S3624C23_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  48, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3624C25_nt  {
  void *s3624c25f0;
  int s3624c25f1[2];
  ::S2005C38 s3624c25f2;
  void  mf3624c25(); // _ZN11S3624C25_nt9mf3624c25Ev
};
//SIG(-1 S3624C25_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S3624C25_nt ::mf3624c25(){}

//skip512 S3624C25_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3624C22_nt  : S3624C23_nt {
  int s3624c22f0;
  ::S3624C25_nt s3624c22f1;
  ::S3624C24_nt s3624c22f2;
  int s3624c22f3;
};
//SIG(-1 S3624C22_nt) C1{ BC2{ m FC3{ m Fc[11]} Fi[7] FL} Fi FC4{ m Fp Fi[2] FC5{ m}} FC3 Fi}



//skip512 S3624C22_nt

#else // __cplusplus

extern Class_Descriptor cd_S3624C23_nt;
static Base_Class bases_S3624C22_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3624C23_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3624C31  {
  void *s3624c31f0;
  int s3624c31f1[2];
  ::S2005C28 s3624c31f2;
  void  mf3624c31(); // _ZN8S3624C319mf3624c31Ev
};
//SIG(-1 S3624C31) C1{ m Fp Fi[2] FC2{ m}}


void  S3624C31 ::mf3624c31(){}

static void Test_S3624C31()
{
  {
    init_simple_test("S3624C31");
    S3624C31 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S3624C31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3624C31)");
    check_field_offset(lv, s3624c31f0, 0, "S3624C31.s3624c31f0");
    check_field_offset(lv, s3624c31f1, ABISELECT(8,4), "S3624C31.s3624c31f1");
    check_field_offset(lv, s3624c31f2, ABISELECT(16,12), "S3624C31.s3624c31f2");
  }
}
static Arrange_To_Call_Me vS3624C31(Test_S3624C31, "S3624C31", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3624C28_nt  {
  void *s3624c28f0;
  ::S3624C13_nt s3624c28f1;
  __tsi64 s3624c28f2[2];
  int s3624c28f3;
  __tsi64 s3624c28f4;
  int s3624c28f5[2];
  char s3624c28f6;
  ::S2005C20_nt s3624c28f7;
  ::S2005C20_nt s3624c28f8;
  __tsi64 s3624c28f9[5];
  char s3624c28f10;
  int s3624c28f11;
  ::S3624C25_nt s3624c28f12;
  ::S3624C25_nt s3624c28f13;
  ::S3624C25_nt s3624c28f14;
  ::S3624C25_nt s3624c28f15;
  ::S3624C31 s3624c28f16;
  int s3624c28f17[2];
  void  mf3624c28(); // _ZN11S3624C28_nt9mf3624c28Ev
};
//SIG(-1 S3624C28_nt) C1{ m Fp FC2{ m FC3{ Fl[4]}} FL[2] Fi FL Fi[2] Fc FC4{ m Fp Fi FC5{ m}} FC4 FL[5] Fc Fi FC6{ m Fp Fi[2] FC7{ m}} FC6 FC6 FC6 FC8{ m Fp Fi[2] FC9{ m}} Fi[2]}


void  S3624C28_nt ::mf3624c28(){}

//skip512 S3624C28_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3624C2  : S3624C3_nt {
  int s3624c2f0[3];
  ::S3624C10_nt s3624c2f1;
  ::S3624C11_nt s3624c2f2;
  int s3624c2f3[3];
  void *s3624c2f4;
  char s3624c2f5[3];
  ::S3624C12_nt s3624c2f6;
  int s3624c2f7;
  ::S2005C37 s3624c2f8;
  void *s3624c2f9;
  int s3624c2f10[2];
  ::S3624C13_nt s3624c2f11;
  ::S3624C13_nt s3624c2f12;
  int s3624c2f13[3];
  char s3624c2f14[6144];
  ::S2005C20_nt s3624c2f15;
  ::S2005C29_nt s3624c2f16;
  char s3624c2f17;
  int s3624c2f18;
  char s3624c2f19;
  int s3624c2f20[5];
  __tsi64 s3624c2f21[7];
  char s3624c2f22;
  __tsi64 s3624c2f23[9];
  int s3624c2f24[2];
  ::S3624C22_nt s3624c2f25;
  ::S3624C28_nt s3624c2f26;
  void *s3624c2f27[3];
  __tsi64 s3624c2f28[2];
  ::S2005C20_nt s3624c2f29;
  int s3624c2f30;
  char s3624c2f31;
  __tsi64 s3624c2f32;
  char s3624c2f33;
  __tsi64 s3624c2f34;
  virtual  ~S3624C2(); // _ZN7S3624C2D1Ev
  virtual void  v93(); // _ZN7S3624C23v93Ev
  virtual void  v94(); // _ZN7S3624C23v94Ev
  virtual void  v95(); // _ZN7S3624C23v95Ev
  virtual void  v96(); // _ZN7S3624C23v96Ev
  virtual void  v97(); // _ZN7S3624C23v97Ev
  virtual void  v98(); // _ZN7S3624C23v98Ev
  virtual void  v99(); // _ZN7S3624C23v99Ev
  virtual void  v100(); // _ZN7S3624C24v100Ev
  virtual void  v101(); // _ZN7S3624C24v101Ev
  virtual void  v102(); // _ZN7S3624C24v102Ev
  virtual void  v103(); // _ZN7S3624C24v103Ev
  virtual void  v104(); // _ZN7S3624C24v104Ev
  virtual void  v105(); // _ZN7S3624C24v105Ev
  virtual void  v106(); // _ZN7S3624C24v106Ev
  virtual void  v107(); // _ZN7S3624C24v107Ev
  virtual void  v108(); // _ZN7S3624C24v108Ev
  virtual void  v109(); // _ZN7S3624C24v109Ev
  virtual void  v110(); // _ZN7S3624C24v110Ev
  virtual void  v111(); // _ZN7S3624C24v111Ev
  virtual void  v112(); // _ZN7S3624C24v112Ev
  virtual void  v113(); // _ZN7S3624C24v113Ev
  virtual void  v114(); // _ZN7S3624C24v114Ev
  virtual void  v115(); // _ZN7S3624C24v115Ev
  virtual void  v116(); // _ZN7S3624C24v116Ev
  virtual void  v117(); // _ZN7S3624C24v117Ev
  virtual void  v118(); // _ZN7S3624C24v118Ev
  virtual void  v119(); // _ZN7S3624C24v119Ev
  virtual void  v120(); // _ZN7S3624C24v120Ev
  virtual void  v121(); // _ZN7S3624C24v121Ev
  virtual void  v122(); // _ZN7S3624C24v122Ev
  virtual void  v123(); // _ZN7S3624C24v123Ev
  virtual void  v124(); // _ZN7S3624C24v124Ev
  virtual void  v125(); // _ZN7S3624C24v125Ev
  virtual void  v126(); // _ZN7S3624C24v126Ev
  virtual void  v127(); // _ZN7S3624C24v127Ev
  virtual void  v128(); // _ZN7S3624C24v128Ev
  virtual void  v129(); // _ZN7S3624C24v129Ev
  virtual void  v130(); // _ZN7S3624C24v130Ev
  virtual void  v131(); // _ZN7S3624C24v131Ev
  virtual void  v132(); // _ZN7S3624C24v132Ev
  virtual void  v133(); // _ZN7S3624C24v133Ev
  virtual void  v134(); // _ZN7S3624C24v134Ev
  virtual void  v135(); // _ZN7S3624C24v135Ev
  virtual void  v136(); // _ZN7S3624C24v136Ev
  virtual void  v137(); // _ZN7S3624C24v137Ev
  virtual void  v138(); // _ZN7S3624C24v138Ev
  virtual void  v139(); // _ZN7S3624C24v139Ev
  virtual void  v140(); // _ZN7S3624C24v140Ev
  virtual void  v141(); // _ZN7S3624C24v141Ev
  virtual void  v142(); // _ZN7S3624C24v142Ev
  virtual void  v143(); // _ZN7S3624C24v143Ev
  virtual void  v144(); // _ZN7S3624C24v144Ev
  virtual void  v145(); // _ZN7S3624C24v145Ev
  virtual void  v146(); // _ZN7S3624C24v146Ev
  virtual void  v147(); // _ZN7S3624C24v147Ev
  virtual void  v148(); // _ZN7S3624C24v148Ev
  virtual void  v149(); // _ZN7S3624C24v149Ev
  virtual void  v150(); // _ZN7S3624C24v150Ev
  virtual void  v151(); // _ZN7S3624C24v151Ev
  virtual void  v152(); // _ZN7S3624C24v152Ev
  virtual void  v153(); // _ZN7S3624C24v153Ev
  virtual void  v154(); // _ZN7S3624C24v154Ev
  virtual void  v155(); // _ZN7S3624C24v155Ev
  virtual void  v156(); // _ZN7S3624C24v156Ev
  virtual void  v157(); // _ZN7S3624C24v157Ev
  virtual void  v158(); // _ZN7S3624C24v158Ev
  virtual void  v159(); // _ZN7S3624C24v159Ev
  virtual void  v160(); // _ZN7S3624C24v160Ev
  virtual void  v161(); // _ZN7S3624C24v161Ev
  virtual void  v162(); // _ZN7S3624C24v162Ev
  virtual void  v163(); // _ZN7S3624C24v163Ev
  virtual void  v164(); // _ZN7S3624C24v164Ev
  virtual void  v165(); // _ZN7S3624C24v165Ev
  virtual void  v166(); // _ZN7S3624C24v166Ev
  virtual void  v167(); // _ZN7S3624C24v167Ev
  virtual void  v168(); // _ZN7S3624C24v168Ev
  virtual void  v169(); // _ZN7S3624C24v169Ev
  virtual void  v170(); // _ZN7S3624C24v170Ev
  virtual void  v171(); // _ZN7S3624C24v171Ev
  virtual void  v172(); // _ZN7S3624C24v172Ev
  virtual void  v173(); // _ZN7S3624C24v173Ev
  virtual void  v174(); // _ZN7S3624C24v174Ev
  virtual void  v175(); // _ZN7S3624C24v175Ev
  virtual void  v176(); // _ZN7S3624C24v176Ev
  virtual void  v177(); // _ZN7S3624C24v177Ev
  virtual void  v178(); // _ZN7S3624C24v178Ev
  virtual void  v179(); // _ZN7S3624C24v179Ev
  virtual void  v180(); // _ZN7S3624C24v180Ev
  virtual void  v181(); // _ZN7S3624C24v181Ev
  virtual void  v182(); // _ZN7S3624C24v182Ev
  virtual void  v183(); // _ZN7S3624C24v183Ev
  virtual void  v184(); // _ZN7S3624C24v184Ev
  virtual void  v185(); // _ZN7S3624C24v185Ev
  virtual void  v186(); // _ZN7S3624C24v186Ev
  virtual void  v187(); // _ZN7S3624C24v187Ev
  virtual void  v188(); // _ZN7S3624C24v188Ev
  virtual void  v189(); // _ZN7S3624C24v189Ev
  S3624C2(); // tgen
};
//SIG(-1 S3624C2) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC6{ m Fp Fi FC7{ m} FC4} Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 Fi[3] FC8{ m Fc Fl[2] Fs[12] Fc[5]} FC9{ m Fc Fl[4] Fi[4]} Fi[3] Fp Fc[3] FC10{ m FC11{ m FC12{ Fl[4]}} Fc Fp Fi[3]} Fi FC13{ m Fp Fi[2] FC14{ m}} Fp Fi[2] FC11 FC11 Fi[3] Fc[6144] FC15{ m Fp Fi FC7} FC16{ m Fp Fi[2] FC5} Fc Fi Fc Fi[5] FL[7] Fc FL[9] Fi[2] FC17{ BC18{ m FC19{ m Fc[11]} Fi[7] FL} Fi FC20{ m Fp Fi[2] FC14} FC19 Fi} FC21{ m Fp FC11 FL[2] Fi FL Fi[2] Fc FC15 FC15 FL[5] Fc Fi FC20 FC20 FC20 FC20 FC22{ m Fp Fi[2] FC5} Fi[2]} Fp[3] FL[2] FC15 Fi Fc FL Fc FL}


 S3624C2 ::~S3624C2(){ note_dtor("S3624C2", this);}
void  S3624C2 ::v93(){vfunc_called(this, "_ZN7S3624C23v93Ev");}
void  S3624C2 ::v94(){vfunc_called(this, "_ZN7S3624C23v94Ev");}
void  S3624C2 ::v95(){vfunc_called(this, "_ZN7S3624C23v95Ev");}
void  S3624C2 ::v96(){vfunc_called(this, "_ZN7S3624C23v96Ev");}
void  S3624C2 ::v97(){vfunc_called(this, "_ZN7S3624C23v97Ev");}
void  S3624C2 ::v98(){vfunc_called(this, "_ZN7S3624C23v98Ev");}
void  S3624C2 ::v99(){vfunc_called(this, "_ZN7S3624C23v99Ev");}
void  S3624C2 ::v100(){vfunc_called(this, "_ZN7S3624C24v100Ev");}
void  S3624C2 ::v101(){vfunc_called(this, "_ZN7S3624C24v101Ev");}
void  S3624C2 ::v102(){vfunc_called(this, "_ZN7S3624C24v102Ev");}
void  S3624C2 ::v103(){vfunc_called(this, "_ZN7S3624C24v103Ev");}
void  S3624C2 ::v104(){vfunc_called(this, "_ZN7S3624C24v104Ev");}
void  S3624C2 ::v105(){vfunc_called(this, "_ZN7S3624C24v105Ev");}
void  S3624C2 ::v106(){vfunc_called(this, "_ZN7S3624C24v106Ev");}
void  S3624C2 ::v107(){vfunc_called(this, "_ZN7S3624C24v107Ev");}
void  S3624C2 ::v108(){vfunc_called(this, "_ZN7S3624C24v108Ev");}
void  S3624C2 ::v109(){vfunc_called(this, "_ZN7S3624C24v109Ev");}
void  S3624C2 ::v110(){vfunc_called(this, "_ZN7S3624C24v110Ev");}
void  S3624C2 ::v111(){vfunc_called(this, "_ZN7S3624C24v111Ev");}
void  S3624C2 ::v112(){vfunc_called(this, "_ZN7S3624C24v112Ev");}
void  S3624C2 ::v113(){vfunc_called(this, "_ZN7S3624C24v113Ev");}
void  S3624C2 ::v114(){vfunc_called(this, "_ZN7S3624C24v114Ev");}
void  S3624C2 ::v115(){vfunc_called(this, "_ZN7S3624C24v115Ev");}
void  S3624C2 ::v116(){vfunc_called(this, "_ZN7S3624C24v116Ev");}
void  S3624C2 ::v117(){vfunc_called(this, "_ZN7S3624C24v117Ev");}
void  S3624C2 ::v118(){vfunc_called(this, "_ZN7S3624C24v118Ev");}
void  S3624C2 ::v119(){vfunc_called(this, "_ZN7S3624C24v119Ev");}
void  S3624C2 ::v120(){vfunc_called(this, "_ZN7S3624C24v120Ev");}
void  S3624C2 ::v121(){vfunc_called(this, "_ZN7S3624C24v121Ev");}
void  S3624C2 ::v122(){vfunc_called(this, "_ZN7S3624C24v122Ev");}
void  S3624C2 ::v123(){vfunc_called(this, "_ZN7S3624C24v123Ev");}
void  S3624C2 ::v124(){vfunc_called(this, "_ZN7S3624C24v124Ev");}
void  S3624C2 ::v125(){vfunc_called(this, "_ZN7S3624C24v125Ev");}
void  S3624C2 ::v126(){vfunc_called(this, "_ZN7S3624C24v126Ev");}
void  S3624C2 ::v127(){vfunc_called(this, "_ZN7S3624C24v127Ev");}
void  S3624C2 ::v128(){vfunc_called(this, "_ZN7S3624C24v128Ev");}
void  S3624C2 ::v129(){vfunc_called(this, "_ZN7S3624C24v129Ev");}
void  S3624C2 ::v130(){vfunc_called(this, "_ZN7S3624C24v130Ev");}
void  S3624C2 ::v131(){vfunc_called(this, "_ZN7S3624C24v131Ev");}
void  S3624C2 ::v132(){vfunc_called(this, "_ZN7S3624C24v132Ev");}
void  S3624C2 ::v133(){vfunc_called(this, "_ZN7S3624C24v133Ev");}
void  S3624C2 ::v134(){vfunc_called(this, "_ZN7S3624C24v134Ev");}
void  S3624C2 ::v135(){vfunc_called(this, "_ZN7S3624C24v135Ev");}
void  S3624C2 ::v136(){vfunc_called(this, "_ZN7S3624C24v136Ev");}
void  S3624C2 ::v137(){vfunc_called(this, "_ZN7S3624C24v137Ev");}
void  S3624C2 ::v138(){vfunc_called(this, "_ZN7S3624C24v138Ev");}
void  S3624C2 ::v139(){vfunc_called(this, "_ZN7S3624C24v139Ev");}
void  S3624C2 ::v140(){vfunc_called(this, "_ZN7S3624C24v140Ev");}
void  S3624C2 ::v141(){vfunc_called(this, "_ZN7S3624C24v141Ev");}
void  S3624C2 ::v142(){vfunc_called(this, "_ZN7S3624C24v142Ev");}
void  S3624C2 ::v143(){vfunc_called(this, "_ZN7S3624C24v143Ev");}
void  S3624C2 ::v144(){vfunc_called(this, "_ZN7S3624C24v144Ev");}
void  S3624C2 ::v145(){vfunc_called(this, "_ZN7S3624C24v145Ev");}
void  S3624C2 ::v146(){vfunc_called(this, "_ZN7S3624C24v146Ev");}
void  S3624C2 ::v147(){vfunc_called(this, "_ZN7S3624C24v147Ev");}
void  S3624C2 ::v148(){vfunc_called(this, "_ZN7S3624C24v148Ev");}
void  S3624C2 ::v149(){vfunc_called(this, "_ZN7S3624C24v149Ev");}
void  S3624C2 ::v150(){vfunc_called(this, "_ZN7S3624C24v150Ev");}
void  S3624C2 ::v151(){vfunc_called(this, "_ZN7S3624C24v151Ev");}
void  S3624C2 ::v152(){vfunc_called(this, "_ZN7S3624C24v152Ev");}
void  S3624C2 ::v153(){vfunc_called(this, "_ZN7S3624C24v153Ev");}
void  S3624C2 ::v154(){vfunc_called(this, "_ZN7S3624C24v154Ev");}
void  S3624C2 ::v155(){vfunc_called(this, "_ZN7S3624C24v155Ev");}
void  S3624C2 ::v156(){vfunc_called(this, "_ZN7S3624C24v156Ev");}
void  S3624C2 ::v157(){vfunc_called(this, "_ZN7S3624C24v157Ev");}
void  S3624C2 ::v158(){vfunc_called(this, "_ZN7S3624C24v158Ev");}
void  S3624C2 ::v159(){vfunc_called(this, "_ZN7S3624C24v159Ev");}
void  S3624C2 ::v160(){vfunc_called(this, "_ZN7S3624C24v160Ev");}
void  S3624C2 ::v161(){vfunc_called(this, "_ZN7S3624C24v161Ev");}
void  S3624C2 ::v162(){vfunc_called(this, "_ZN7S3624C24v162Ev");}
void  S3624C2 ::v163(){vfunc_called(this, "_ZN7S3624C24v163Ev");}
void  S3624C2 ::v164(){vfunc_called(this, "_ZN7S3624C24v164Ev");}
void  S3624C2 ::v165(){vfunc_called(this, "_ZN7S3624C24v165Ev");}
void  S3624C2 ::v166(){vfunc_called(this, "_ZN7S3624C24v166Ev");}
void  S3624C2 ::v167(){vfunc_called(this, "_ZN7S3624C24v167Ev");}
void  S3624C2 ::v168(){vfunc_called(this, "_ZN7S3624C24v168Ev");}
void  S3624C2 ::v169(){vfunc_called(this, "_ZN7S3624C24v169Ev");}
void  S3624C2 ::v170(){vfunc_called(this, "_ZN7S3624C24v170Ev");}
void  S3624C2 ::v171(){vfunc_called(this, "_ZN7S3624C24v171Ev");}
void  S3624C2 ::v172(){vfunc_called(this, "_ZN7S3624C24v172Ev");}
void  S3624C2 ::v173(){vfunc_called(this, "_ZN7S3624C24v173Ev");}
void  S3624C2 ::v174(){vfunc_called(this, "_ZN7S3624C24v174Ev");}
void  S3624C2 ::v175(){vfunc_called(this, "_ZN7S3624C24v175Ev");}
void  S3624C2 ::v176(){vfunc_called(this, "_ZN7S3624C24v176Ev");}
void  S3624C2 ::v177(){vfunc_called(this, "_ZN7S3624C24v177Ev");}
void  S3624C2 ::v178(){vfunc_called(this, "_ZN7S3624C24v178Ev");}
void  S3624C2 ::v179(){vfunc_called(this, "_ZN7S3624C24v179Ev");}
void  S3624C2 ::v180(){vfunc_called(this, "_ZN7S3624C24v180Ev");}
void  S3624C2 ::v181(){vfunc_called(this, "_ZN7S3624C24v181Ev");}
void  S3624C2 ::v182(){vfunc_called(this, "_ZN7S3624C24v182Ev");}
void  S3624C2 ::v183(){vfunc_called(this, "_ZN7S3624C24v183Ev");}
void  S3624C2 ::v184(){vfunc_called(this, "_ZN7S3624C24v184Ev");}
void  S3624C2 ::v185(){vfunc_called(this, "_ZN7S3624C24v185Ev");}
void  S3624C2 ::v186(){vfunc_called(this, "_ZN7S3624C24v186Ev");}
void  S3624C2 ::v187(){vfunc_called(this, "_ZN7S3624C24v187Ev");}
void  S3624C2 ::v188(){vfunc_called(this, "_ZN7S3624C24v188Ev");}
void  S3624C2 ::v189(){vfunc_called(this, "_ZN7S3624C24v189Ev");}
S3624C2 ::S3624C2(){ note_ctor("S3624C2", this);} // tgen

static void Test_S3624C2()
{
  extern Class_Descriptor cd_S3624C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(905,1744)];
    init_test(&cd_S3624C2, buf);
    S3624C2 *dp, &lv = *(dp=new (buf) S3624C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(7232,6972), "sizeof(S3624C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3624C2)");
    check_base_class_offset(lv, (S3624C3_nt*), 0, "S3624C2");
    check_field_offset(lv, s3624c2f0, ABISELECT(44,32), "S3624C2.s3624c2f0");
    check_field_offset(lv, s3624c2f1, ABISELECT(56,44), "S3624C2.s3624c2f1");
    check_field_offset(lv, s3624c2f2, ABISELECT(112,88), "S3624C2.s3624c2f2");
    check_field_offset(lv, s3624c2f3, ABISELECT(168,124), "S3624C2.s3624c2f3");
    check_field_offset(lv, s3624c2f4, ABISELECT(184,136), "S3624C2.s3624c2f4");
    check_field_offset(lv, s3624c2f5, ABISELECT(192,140), "S3624C2.s3624c2f5");
    check_field_offset(lv, s3624c2f6, ABISELECT(200,144), "S3624C2.s3624c2f6");
    check_field_offset(lv, s3624c2f7, ABISELECT(264,180), "S3624C2.s3624c2f7");
    check_field_offset(lv, s3624c2f8, ABISELECT(272,184), "S3624C2.s3624c2f8");
    check_field_offset(lv, s3624c2f9, ABISELECT(296,200), "S3624C2.s3624c2f9");
    check_field_offset(lv, s3624c2f10, ABISELECT(304,204), "S3624C2.s3624c2f10");
    check_field_offset(lv, s3624c2f11, ABISELECT(312,212), "S3624C2.s3624c2f11");
    check_field_offset(lv, s3624c2f12, ABISELECT(344,228), "S3624C2.s3624c2f12");
    check_field_offset(lv, s3624c2f13, ABISELECT(376,244), "S3624C2.s3624c2f13");
    check_field_offset(lv, s3624c2f14, ABISELECT(388,256), "S3624C2.s3624c2f14");
    check_field_offset(lv, s3624c2f15, ABISELECT(6536,6400), "S3624C2.s3624c2f15");
    check_field_offset(lv, s3624c2f16, ABISELECT(6552,6412), "S3624C2.s3624c2f16");
    check_field_offset(lv, s3624c2f17, ABISELECT(6576,6428), "S3624C2.s3624c2f17");
    check_field_offset(lv, s3624c2f18, ABISELECT(6580,6432), "S3624C2.s3624c2f18");
    check_field_offset(lv, s3624c2f19, ABISELECT(6584,6436), "S3624C2.s3624c2f19");
    check_field_offset(lv, s3624c2f20, ABISELECT(6588,6440), "S3624C2.s3624c2f20");
    check_field_offset(lv, s3624c2f21, ABISELECT(6608,6460), "S3624C2.s3624c2f21");
    check_field_offset(lv, s3624c2f22, ABISELECT(6664,6516), "S3624C2.s3624c2f22");
    check_field_offset(lv, s3624c2f23, ABISELECT(6672,6520), "S3624C2.s3624c2f23");
    check_field_offset(lv, s3624c2f24, ABISELECT(6744,6592), "S3624C2.s3624c2f24");
    check_field_offset(lv, s3624c2f25, ABISELECT(6752,6600), "S3624C2.s3624c2f25");
    check_field_offset(lv, s3624c2f26, ABISELECT(6848,6684), "S3624C2.s3624c2f26");
    check_field_offset(lv, s3624c2f27, ABISELECT(7144,6904), "S3624C2.s3624c2f27");
    check_field_offset(lv, s3624c2f28, ABISELECT(7168,6916), "S3624C2.s3624c2f28");
    check_field_offset(lv, s3624c2f29, ABISELECT(7184,6932), "S3624C2.s3624c2f29");
    check_field_offset(lv, s3624c2f30, ABISELECT(7200,6944), "S3624C2.s3624c2f30");
    check_field_offset(lv, s3624c2f31, ABISELECT(7204,6948), "S3624C2.s3624c2f31");
    check_field_offset(lv, s3624c2f32, ABISELECT(7208,6952), "S3624C2.s3624c2f32");
    check_field_offset(lv, s3624c2f33, ABISELECT(7216,6960), "S3624C2.s3624c2f33");
    check_field_offset(lv, s3624c2f34, ABISELECT(7224,6964), "S3624C2.s3624c2f34");
    test_class_info(&lv, &cd_S3624C2);
    dp->~S3624C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3624C2(Test_S3624C2, "S3624C2", ABISELECT(7232,6972));

#else // __cplusplus

extern void _ZN7S3624C2C1Ev();
extern void _ZN7S3624C2D1Ev();
Name_Map name_map_S3624C2[] = {
  NSPAIR(_ZN7S3624C2C1Ev),
  NSPAIR(_ZN7S3624C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3624C3_nt;
extern VTBL_ENTRY _ZTI10S3624C3_nt[];
extern  VTBL_ENTRY _ZTV10S3624C3_nt[];
static Base_Class bases_S3624C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3624C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3624C2[];
extern void _ZN7S3624C2D1Ev();
extern void _ZN7S3624C2D0Ev();
extern void _ZN7S3624C23v93Ev();
extern void _ZN7S3624C23v94Ev();
extern void _ZN7S3624C23v95Ev();
extern void _ZN7S3624C23v96Ev();
extern void _ZN7S3624C23v97Ev();
extern void _ZN7S3624C23v98Ev();
extern void _ZN7S3624C23v99Ev();
extern void _ZN7S3624C24v100Ev();
extern void _ZN7S3624C24v101Ev();
extern void _ZN7S3624C24v102Ev();
extern void _ZN7S3624C24v103Ev();
extern void _ZN7S3624C24v104Ev();
extern void _ZN7S3624C24v105Ev();
extern void _ZN7S3624C24v106Ev();
extern void _ZN7S3624C24v107Ev();
extern void _ZN7S3624C24v108Ev();
extern void _ZN7S3624C24v109Ev();
extern void _ZN7S3624C24v110Ev();
extern void _ZN7S3624C24v111Ev();
extern void _ZN7S3624C24v112Ev();
extern void _ZN7S3624C24v113Ev();
extern void _ZN7S3624C24v114Ev();
extern void _ZN7S3624C24v115Ev();
extern void _ZN7S3624C24v116Ev();
extern void _ZN7S3624C24v117Ev();
extern void _ZN7S3624C24v118Ev();
extern void _ZN7S3624C24v119Ev();
extern void _ZN7S3624C24v120Ev();
extern void _ZN7S3624C24v121Ev();
extern void _ZN7S3624C24v122Ev();
extern void _ZN7S3624C24v123Ev();
extern void _ZN7S3624C24v124Ev();
extern void _ZN7S3624C24v125Ev();
extern void _ZN7S3624C24v126Ev();
extern void _ZN7S3624C24v127Ev();
extern void _ZN7S3624C24v128Ev();
extern void _ZN7S3624C24v129Ev();
extern void _ZN7S3624C24v130Ev();
extern void _ZN7S3624C24v131Ev();
extern void _ZN7S3624C24v132Ev();
extern void _ZN7S3624C24v133Ev();
extern void _ZN7S3624C24v134Ev();
extern void _ZN7S3624C24v135Ev();
extern void _ZN7S3624C24v136Ev();
extern void _ZN7S3624C24v137Ev();
extern void _ZN7S3624C24v138Ev();
extern void _ZN7S3624C24v139Ev();
extern void _ZN7S3624C24v140Ev();
extern void _ZN7S3624C24v141Ev();
extern void _ZN7S3624C24v142Ev();
extern void _ZN7S3624C24v143Ev();
extern void _ZN7S3624C24v144Ev();
extern void _ZN7S3624C24v145Ev();
extern void _ZN7S3624C24v146Ev();
extern void _ZN7S3624C24v147Ev();
extern void _ZN7S3624C24v148Ev();
extern void _ZN7S3624C24v149Ev();
extern void _ZN7S3624C24v150Ev();
extern void _ZN7S3624C24v151Ev();
extern void _ZN7S3624C24v152Ev();
extern void _ZN7S3624C24v153Ev();
extern void _ZN7S3624C24v154Ev();
extern void _ZN7S3624C24v155Ev();
extern void _ZN7S3624C24v156Ev();
extern void _ZN7S3624C24v157Ev();
extern void _ZN7S3624C24v158Ev();
extern void _ZN7S3624C24v159Ev();
extern void _ZN7S3624C24v160Ev();
extern void _ZN7S3624C24v161Ev();
extern void _ZN7S3624C24v162Ev();
extern void _ZN7S3624C24v163Ev();
extern void _ZN7S3624C24v164Ev();
extern void _ZN7S3624C24v165Ev();
extern void _ZN7S3624C24v166Ev();
extern void _ZN7S3624C24v167Ev();
extern void _ZN7S3624C24v168Ev();
extern void _ZN7S3624C24v169Ev();
extern void _ZN7S3624C24v170Ev();
extern void _ZN7S3624C24v171Ev();
extern void _ZN7S3624C24v172Ev();
extern void _ZN7S3624C24v173Ev();
extern void _ZN7S3624C24v174Ev();
extern void _ZN7S3624C24v175Ev();
extern void _ZN7S3624C24v176Ev();
extern void _ZN7S3624C24v177Ev();
extern void _ZN7S3624C24v178Ev();
extern void _ZN7S3624C24v179Ev();
extern void _ZN7S3624C24v180Ev();
extern void _ZN7S3624C24v181Ev();
extern void _ZN7S3624C24v182Ev();
extern void _ZN7S3624C24v183Ev();
extern void _ZN7S3624C24v184Ev();
extern void _ZN7S3624C24v185Ev();
extern void _ZN7S3624C24v186Ev();
extern void _ZN7S3624C24v187Ev();
extern void _ZN7S3624C24v188Ev();
extern void _ZN7S3624C24v189Ev();
static  VTBL_ENTRY vtc_S3624C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3624C2[0]),
  (VTBL_ENTRY)&_ZN7S3624C2D1Ev,
  (VTBL_ENTRY)&_ZN7S3624C2D0Ev,
  (VTBL_ENTRY)&_ZN7S3624C23v93Ev,
  (VTBL_ENTRY)&_ZN7S3624C23v94Ev,
  (VTBL_ENTRY)&_ZN7S3624C23v95Ev,
  (VTBL_ENTRY)&_ZN7S3624C23v96Ev,
  (VTBL_ENTRY)&_ZN7S3624C23v97Ev,
  (VTBL_ENTRY)&_ZN7S3624C23v98Ev,
  (VTBL_ENTRY)&_ZN7S3624C23v99Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v100Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v101Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v102Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v103Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v104Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v105Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v106Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v107Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v108Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v109Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v110Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v111Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v112Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v113Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v114Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v115Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v116Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v117Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v118Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v119Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v120Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v121Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v122Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v123Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v124Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v125Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v126Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v127Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v128Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v129Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v130Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v131Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v132Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v133Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v134Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v135Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v136Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v137Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v138Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v139Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v140Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v141Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v142Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v143Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v144Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v145Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v146Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v147Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v148Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v149Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v150Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v151Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v152Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v153Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v154Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v155Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v156Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v157Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v158Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v159Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v160Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v161Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v162Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v163Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v164Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v165Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v166Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v167Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v168Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v169Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v170Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v171Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v172Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v173Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v174Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v175Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v176Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v177Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v178Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v179Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v180Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v181Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v182Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v183Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v184Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v185Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v186Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v187Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v188Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v189Ev,
};
extern VTBL_ENTRY _ZTI7S3624C2[];
extern  VTBL_ENTRY _ZTV7S3624C2[];
Class_Descriptor cd_S3624C2 = {  "S3624C2", // class name
  bases_S3624C2, 1,
  &(vtc_S3624C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(7232,6972), // object size
  NSPAIRA(_ZTI7S3624C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3624C2),101, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3624C33_nt  {
  void *s3624c33f0;
  void  mf3624c33(); // _ZN11S3624C33_nt9mf3624c33Ev
};
//SIG(-1 S3624C33_nt) C1{ m Fp}


void  S3624C33_nt ::mf3624c33(){}

//skip512 S3624C33_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI11S3624C33_nt[];
VTBL_ENTRY *P__ZTI11S3624C33_nt = _ZTI11S3624C33_nt; 
Class_Descriptor cd_S3624C33_nt = {  "S3624C33_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S3624C33_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3624C1  : S3624C2 {
  void *s3624c1f0;
  ::S3624C33_nt s3624c1f1;
  __tsi64 s3624c1f2;
  ::S2005C20_nt s3624c1f3;
  int s3624c1f4;
  virtual  ~S3624C1(); // _ZN7S3624C1D1Ev
  virtual void  v1(); // _ZN7S3624C12v1Ev
  virtual void  v2(); // _ZN7S3624C12v2Ev
  virtual void  v3(); // _ZN7S3624C12v3Ev
  virtual void  v4(); // _ZN7S3624C12v4Ev
  virtual void  v5(); // _ZN7S3624C12v5Ev
  virtual void  v6(); // _ZN7S3624C12v6Ev
  virtual void  v7(); // _ZN7S3624C12v7Ev
  virtual void  v8(); // _ZN7S3624C12v8Ev
  virtual void  v9(); // _ZN7S3624C12v9Ev
  virtual void  v10(); // _ZN7S3624C13v10Ev
  virtual void  v11(); // _ZN7S3624C13v11Ev
  virtual void  v12(); // _ZN7S3624C13v12Ev
  virtual void  v13(); // _ZN7S3624C13v13Ev
  virtual void  v14(); // _ZN7S3624C13v14Ev
  virtual void  v15(); // _ZN7S3624C13v15Ev
  virtual void  v16(); // _ZN7S3624C13v16Ev
  virtual void  v17(); // _ZN7S3624C13v17Ev
  virtual void  v18(); // _ZN7S3624C13v18Ev
  virtual void  v19(); // _ZN7S3624C13v19Ev
  virtual void  v20(); // _ZN7S3624C13v20Ev
  virtual void  v21(); // _ZN7S3624C13v21Ev
  virtual void  v22(); // _ZN7S3624C13v22Ev
  virtual void  v23(); // _ZN7S3624C13v23Ev
  virtual void  v24(); // _ZN7S3624C13v24Ev
  virtual void  v25(); // _ZN7S3624C13v25Ev
  virtual void  v26(); // _ZN7S3624C13v26Ev
  virtual void  v27(); // _ZN7S3624C13v27Ev
  virtual void  v28(); // _ZN7S3624C13v28Ev
  virtual void  v29(); // _ZN7S3624C13v29Ev
  virtual void  v30(); // _ZN7S3624C13v30Ev
  virtual void  v31(); // _ZN7S3624C13v31Ev
  virtual void  v32(); // _ZN7S3624C13v32Ev
  virtual void  v33(); // _ZN7S3624C13v33Ev
  virtual void  v34(); // _ZN7S3624C13v34Ev
  virtual void  v35(); // _ZN7S3624C13v35Ev
  virtual void  v36(); // _ZN7S3624C13v36Ev
  virtual void  v37(); // _ZN7S3624C13v37Ev
  virtual void  v38(); // _ZN7S3624C13v38Ev
  virtual void  v39(); // _ZN7S3624C13v39Ev
  virtual void  v40(); // _ZN7S3624C13v40Ev
  virtual void  v41(); // _ZN7S3624C13v41Ev
  virtual void  v42(); // _ZN7S3624C13v42Ev
  virtual void  v43(); // _ZN7S3624C13v43Ev
  virtual void  v44(); // _ZN7S3624C13v44Ev
  virtual void  v45(); // _ZN7S3624C13v45Ev
  virtual void  v46(); // _ZN7S3624C13v46Ev
  virtual void  v47(); // _ZN7S3624C13v47Ev
  virtual void  v48(); // _ZN7S3624C13v48Ev
  virtual void  v49(); // _ZN7S3624C13v49Ev
  virtual void  v50(); // _ZN7S3624C13v50Ev
  virtual void  v51(); // _ZN7S3624C13v51Ev
  virtual void  v52(); // _ZN7S3624C13v52Ev
  virtual void  v53(); // _ZN7S3624C13v53Ev
  virtual void  v54(); // _ZN7S3624C13v54Ev
  virtual void  v55(); // _ZN7S3624C13v55Ev
  virtual void  v56(); // _ZN7S3624C13v56Ev
  virtual void  v57(); // _ZN7S3624C13v57Ev
  virtual void  v58(); // _ZN7S3624C13v58Ev
  virtual void  v59(); // _ZN7S3624C13v59Ev
  virtual void  v60(); // _ZN7S3624C13v60Ev
  virtual void  v61(); // _ZN7S3624C13v61Ev
  virtual void  v62(); // _ZN7S3624C13v62Ev
  virtual void  v63(); // _ZN7S3624C13v63Ev
  virtual void  v64(); // _ZN7S3624C13v64Ev
  virtual void  v65(); // _ZN7S3624C13v65Ev
  virtual void  v66(); // _ZN7S3624C13v66Ev
  virtual void  v67(); // _ZN7S3624C13v67Ev
  virtual void  v68(); // _ZN7S3624C13v68Ev
  virtual void  v69(); // _ZN7S3624C13v69Ev
  virtual void  v70(); // _ZN7S3624C13v70Ev
  virtual void  v71(); // _ZN7S3624C13v71Ev
  virtual void  v72(); // _ZN7S3624C13v72Ev
  virtual void  v73(); // _ZN7S3624C13v73Ev
  virtual void  v74(); // _ZN7S3624C13v74Ev
  virtual void  v75(); // _ZN7S3624C13v75Ev
  virtual void  v76(); // _ZN7S3624C13v76Ev
  virtual void  v77(); // _ZN7S3624C13v77Ev
  virtual void  v78(); // _ZN7S3624C13v78Ev
  virtual void  v79(); // _ZN7S3624C13v79Ev
  virtual void  v80(); // _ZN7S3624C13v80Ev
  virtual void  v81(); // _ZN7S3624C13v81Ev
  virtual void  v82(); // _ZN7S3624C13v82Ev
  virtual void  v83(); // _ZN7S3624C13v83Ev
  virtual void  v84(); // _ZN7S3624C13v84Ev
  virtual void  v85(); // _ZN7S3624C13v85Ev
  virtual void  v86(); // _ZN7S3624C13v86Ev
  virtual void  v87(); // _ZN7S3624C13v87Ev
  virtual void  v88(); // _ZN7S3624C13v88Ev
  virtual void  v89(); // _ZN7S3624C13v89Ev
  virtual void  v90(); // _ZN7S3624C13v90Ev
  virtual void  v91(); // _ZN7S3624C13v91Ev
  virtual void  v92(); // _ZN7S3624C13v92Ev
  S3624C1(); // tgen
};
//SIG(1 S3624C1) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC6{ m}} FC7{ m Fp Fi FC8{ m} FC5} Fc} vd v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 Fi[3] FC9{ m Fc Fl[2] Fs[12] Fc[5]} FC10{ m Fc Fl[4] Fi[4]} Fi[3] Fp Fc[3] FC11{ m FC12{ m FC13{ Fl[4]}} Fc Fp Fi[3]} Fi FC14{ m Fp Fi[2] FC15{ m}} Fp Fi[2] FC12 FC12 Fi[3] Fc[6144] FC16{ m Fp Fi FC8} FC17{ m Fp Fi[2] FC6} Fc Fi Fc Fi[5] FL[7] Fc FL[9] Fi[2] FC18{ BC19{ m FC20{ m Fc[11]} Fi[7] FL} Fi FC21{ m Fp Fi[2] FC15} FC20 Fi} FC22{ m Fp FC12 FL[2] Fi FL Fi[2] Fc FC16 FC16 FL[5] Fc Fi FC21 FC21 FC21 FC21 FC23{ m Fp Fi[2] FC6} Fi[2]} Fp[3] FL[2] FC16 Fi Fc FL Fc FL} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 Fp FC24{ m Fp} FL FC16 Fi}


 S3624C1 ::~S3624C1(){ note_dtor("S3624C1", this);}
void  S3624C1 ::v1(){vfunc_called(this, "_ZN7S3624C12v1Ev");}
void  S3624C1 ::v2(){vfunc_called(this, "_ZN7S3624C12v2Ev");}
void  S3624C1 ::v3(){vfunc_called(this, "_ZN7S3624C12v3Ev");}
void  S3624C1 ::v4(){vfunc_called(this, "_ZN7S3624C12v4Ev");}
void  S3624C1 ::v5(){vfunc_called(this, "_ZN7S3624C12v5Ev");}
void  S3624C1 ::v6(){vfunc_called(this, "_ZN7S3624C12v6Ev");}
void  S3624C1 ::v7(){vfunc_called(this, "_ZN7S3624C12v7Ev");}
void  S3624C1 ::v8(){vfunc_called(this, "_ZN7S3624C12v8Ev");}
void  S3624C1 ::v9(){vfunc_called(this, "_ZN7S3624C12v9Ev");}
void  S3624C1 ::v10(){vfunc_called(this, "_ZN7S3624C13v10Ev");}
void  S3624C1 ::v11(){vfunc_called(this, "_ZN7S3624C13v11Ev");}
void  S3624C1 ::v12(){vfunc_called(this, "_ZN7S3624C13v12Ev");}
void  S3624C1 ::v13(){vfunc_called(this, "_ZN7S3624C13v13Ev");}
void  S3624C1 ::v14(){vfunc_called(this, "_ZN7S3624C13v14Ev");}
void  S3624C1 ::v15(){vfunc_called(this, "_ZN7S3624C13v15Ev");}
void  S3624C1 ::v16(){vfunc_called(this, "_ZN7S3624C13v16Ev");}
void  S3624C1 ::v17(){vfunc_called(this, "_ZN7S3624C13v17Ev");}
void  S3624C1 ::v18(){vfunc_called(this, "_ZN7S3624C13v18Ev");}
void  S3624C1 ::v19(){vfunc_called(this, "_ZN7S3624C13v19Ev");}
void  S3624C1 ::v20(){vfunc_called(this, "_ZN7S3624C13v20Ev");}
void  S3624C1 ::v21(){vfunc_called(this, "_ZN7S3624C13v21Ev");}
void  S3624C1 ::v22(){vfunc_called(this, "_ZN7S3624C13v22Ev");}
void  S3624C1 ::v23(){vfunc_called(this, "_ZN7S3624C13v23Ev");}
void  S3624C1 ::v24(){vfunc_called(this, "_ZN7S3624C13v24Ev");}
void  S3624C1 ::v25(){vfunc_called(this, "_ZN7S3624C13v25Ev");}
void  S3624C1 ::v26(){vfunc_called(this, "_ZN7S3624C13v26Ev");}
void  S3624C1 ::v27(){vfunc_called(this, "_ZN7S3624C13v27Ev");}
void  S3624C1 ::v28(){vfunc_called(this, "_ZN7S3624C13v28Ev");}
void  S3624C1 ::v29(){vfunc_called(this, "_ZN7S3624C13v29Ev");}
void  S3624C1 ::v30(){vfunc_called(this, "_ZN7S3624C13v30Ev");}
void  S3624C1 ::v31(){vfunc_called(this, "_ZN7S3624C13v31Ev");}
void  S3624C1 ::v32(){vfunc_called(this, "_ZN7S3624C13v32Ev");}
void  S3624C1 ::v33(){vfunc_called(this, "_ZN7S3624C13v33Ev");}
void  S3624C1 ::v34(){vfunc_called(this, "_ZN7S3624C13v34Ev");}
void  S3624C1 ::v35(){vfunc_called(this, "_ZN7S3624C13v35Ev");}
void  S3624C1 ::v36(){vfunc_called(this, "_ZN7S3624C13v36Ev");}
void  S3624C1 ::v37(){vfunc_called(this, "_ZN7S3624C13v37Ev");}
void  S3624C1 ::v38(){vfunc_called(this, "_ZN7S3624C13v38Ev");}
void  S3624C1 ::v39(){vfunc_called(this, "_ZN7S3624C13v39Ev");}
void  S3624C1 ::v40(){vfunc_called(this, "_ZN7S3624C13v40Ev");}
void  S3624C1 ::v41(){vfunc_called(this, "_ZN7S3624C13v41Ev");}
void  S3624C1 ::v42(){vfunc_called(this, "_ZN7S3624C13v42Ev");}
void  S3624C1 ::v43(){vfunc_called(this, "_ZN7S3624C13v43Ev");}
void  S3624C1 ::v44(){vfunc_called(this, "_ZN7S3624C13v44Ev");}
void  S3624C1 ::v45(){vfunc_called(this, "_ZN7S3624C13v45Ev");}
void  S3624C1 ::v46(){vfunc_called(this, "_ZN7S3624C13v46Ev");}
void  S3624C1 ::v47(){vfunc_called(this, "_ZN7S3624C13v47Ev");}
void  S3624C1 ::v48(){vfunc_called(this, "_ZN7S3624C13v48Ev");}
void  S3624C1 ::v49(){vfunc_called(this, "_ZN7S3624C13v49Ev");}
void  S3624C1 ::v50(){vfunc_called(this, "_ZN7S3624C13v50Ev");}
void  S3624C1 ::v51(){vfunc_called(this, "_ZN7S3624C13v51Ev");}
void  S3624C1 ::v52(){vfunc_called(this, "_ZN7S3624C13v52Ev");}
void  S3624C1 ::v53(){vfunc_called(this, "_ZN7S3624C13v53Ev");}
void  S3624C1 ::v54(){vfunc_called(this, "_ZN7S3624C13v54Ev");}
void  S3624C1 ::v55(){vfunc_called(this, "_ZN7S3624C13v55Ev");}
void  S3624C1 ::v56(){vfunc_called(this, "_ZN7S3624C13v56Ev");}
void  S3624C1 ::v57(){vfunc_called(this, "_ZN7S3624C13v57Ev");}
void  S3624C1 ::v58(){vfunc_called(this, "_ZN7S3624C13v58Ev");}
void  S3624C1 ::v59(){vfunc_called(this, "_ZN7S3624C13v59Ev");}
void  S3624C1 ::v60(){vfunc_called(this, "_ZN7S3624C13v60Ev");}
void  S3624C1 ::v61(){vfunc_called(this, "_ZN7S3624C13v61Ev");}
void  S3624C1 ::v62(){vfunc_called(this, "_ZN7S3624C13v62Ev");}
void  S3624C1 ::v63(){vfunc_called(this, "_ZN7S3624C13v63Ev");}
void  S3624C1 ::v64(){vfunc_called(this, "_ZN7S3624C13v64Ev");}
void  S3624C1 ::v65(){vfunc_called(this, "_ZN7S3624C13v65Ev");}
void  S3624C1 ::v66(){vfunc_called(this, "_ZN7S3624C13v66Ev");}
void  S3624C1 ::v67(){vfunc_called(this, "_ZN7S3624C13v67Ev");}
void  S3624C1 ::v68(){vfunc_called(this, "_ZN7S3624C13v68Ev");}
void  S3624C1 ::v69(){vfunc_called(this, "_ZN7S3624C13v69Ev");}
void  S3624C1 ::v70(){vfunc_called(this, "_ZN7S3624C13v70Ev");}
void  S3624C1 ::v71(){vfunc_called(this, "_ZN7S3624C13v71Ev");}
void  S3624C1 ::v72(){vfunc_called(this, "_ZN7S3624C13v72Ev");}
void  S3624C1 ::v73(){vfunc_called(this, "_ZN7S3624C13v73Ev");}
void  S3624C1 ::v74(){vfunc_called(this, "_ZN7S3624C13v74Ev");}
void  S3624C1 ::v75(){vfunc_called(this, "_ZN7S3624C13v75Ev");}
void  S3624C1 ::v76(){vfunc_called(this, "_ZN7S3624C13v76Ev");}
void  S3624C1 ::v77(){vfunc_called(this, "_ZN7S3624C13v77Ev");}
void  S3624C1 ::v78(){vfunc_called(this, "_ZN7S3624C13v78Ev");}
void  S3624C1 ::v79(){vfunc_called(this, "_ZN7S3624C13v79Ev");}
void  S3624C1 ::v80(){vfunc_called(this, "_ZN7S3624C13v80Ev");}
void  S3624C1 ::v81(){vfunc_called(this, "_ZN7S3624C13v81Ev");}
void  S3624C1 ::v82(){vfunc_called(this, "_ZN7S3624C13v82Ev");}
void  S3624C1 ::v83(){vfunc_called(this, "_ZN7S3624C13v83Ev");}
void  S3624C1 ::v84(){vfunc_called(this, "_ZN7S3624C13v84Ev");}
void  S3624C1 ::v85(){vfunc_called(this, "_ZN7S3624C13v85Ev");}
void  S3624C1 ::v86(){vfunc_called(this, "_ZN7S3624C13v86Ev");}
void  S3624C1 ::v87(){vfunc_called(this, "_ZN7S3624C13v87Ev");}
void  S3624C1 ::v88(){vfunc_called(this, "_ZN7S3624C13v88Ev");}
void  S3624C1 ::v89(){vfunc_called(this, "_ZN7S3624C13v89Ev");}
void  S3624C1 ::v90(){vfunc_called(this, "_ZN7S3624C13v90Ev");}
void  S3624C1 ::v91(){vfunc_called(this, "_ZN7S3624C13v91Ev");}
void  S3624C1 ::v92(){vfunc_called(this, "_ZN7S3624C13v92Ev");}
S3624C1 ::S3624C1(){ note_ctor("S3624C1", this);} // tgen

static void Test_S3624C1()
{
  extern Class_Descriptor cd_S3624C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(911,1752)];
    init_test(&cd_S3624C1, buf);
    S3624C1 *dp, &lv = *(dp=new (buf) S3624C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(7280,7004), "sizeof(S3624C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3624C1)");
    check_base_class_offset(lv, (S3624C3_nt*)(S3624C2*), 0, "S3624C1");
    check_base_class_offset(lv, (S3624C2*), 0, "S3624C1");
    check_field_offset(lv, s3624c1f0, ABISELECT(7232,6972), "S3624C1.s3624c1f0");
    check_field_offset(lv, s3624c1f1, ABISELECT(7240,6976), "S3624C1.s3624c1f1");
    check_field_offset(lv, s3624c1f2, ABISELECT(7248,6980), "S3624C1.s3624c1f2");
    check_field_offset(lv, s3624c1f3, ABISELECT(7256,6988), "S3624C1.s3624c1f3");
    check_field_offset(lv, s3624c1f4, ABISELECT(7272,7000), "S3624C1.s3624c1f4");
    test_class_info(&lv, &cd_S3624C1);
    dp->~S3624C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3624C1(Test_S3624C1, "S3624C1", ABISELECT(7280,7004));

#else // __cplusplus

extern void _ZN7S3624C1C1Ev();
extern void _ZN7S3624C1D1Ev();
Name_Map name_map_S3624C1[] = {
  NSPAIR(_ZN7S3624C1C1Ev),
  NSPAIR(_ZN7S3624C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3624C3_nt;
extern VTBL_ENTRY _ZTI10S3624C3_nt[];
extern  VTBL_ENTRY _ZTV10S3624C3_nt[];
extern Class_Descriptor cd_S3624C2;
extern VTBL_ENTRY _ZTI7S3624C2[];
extern  VTBL_ENTRY _ZTV7S3624C2[];
static Base_Class bases_S3624C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3624C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3624C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3624C1[];
extern void _ZN7S3624C1D1Ev();
extern void _ZN7S3624C1D0Ev();
extern void _ZN7S3624C23v93Ev();
extern void _ZN7S3624C23v94Ev();
extern void _ZN7S3624C23v95Ev();
extern void _ZN7S3624C23v96Ev();
extern void _ZN7S3624C23v97Ev();
extern void _ZN7S3624C23v98Ev();
extern void _ZN7S3624C23v99Ev();
extern void _ZN7S3624C24v100Ev();
extern void _ZN7S3624C24v101Ev();
extern void _ZN7S3624C24v102Ev();
extern void _ZN7S3624C24v103Ev();
extern void _ZN7S3624C24v104Ev();
extern void _ZN7S3624C24v105Ev();
extern void _ZN7S3624C24v106Ev();
extern void _ZN7S3624C24v107Ev();
extern void _ZN7S3624C24v108Ev();
extern void _ZN7S3624C24v109Ev();
extern void _ZN7S3624C24v110Ev();
extern void _ZN7S3624C24v111Ev();
extern void _ZN7S3624C24v112Ev();
extern void _ZN7S3624C24v113Ev();
extern void _ZN7S3624C24v114Ev();
extern void _ZN7S3624C24v115Ev();
extern void _ZN7S3624C24v116Ev();
extern void _ZN7S3624C24v117Ev();
extern void _ZN7S3624C24v118Ev();
extern void _ZN7S3624C24v119Ev();
extern void _ZN7S3624C24v120Ev();
extern void _ZN7S3624C24v121Ev();
extern void _ZN7S3624C24v122Ev();
extern void _ZN7S3624C24v123Ev();
extern void _ZN7S3624C24v124Ev();
extern void _ZN7S3624C24v125Ev();
extern void _ZN7S3624C24v126Ev();
extern void _ZN7S3624C24v127Ev();
extern void _ZN7S3624C24v128Ev();
extern void _ZN7S3624C24v129Ev();
extern void _ZN7S3624C24v130Ev();
extern void _ZN7S3624C24v131Ev();
extern void _ZN7S3624C24v132Ev();
extern void _ZN7S3624C24v133Ev();
extern void _ZN7S3624C24v134Ev();
extern void _ZN7S3624C24v135Ev();
extern void _ZN7S3624C24v136Ev();
extern void _ZN7S3624C24v137Ev();
extern void _ZN7S3624C24v138Ev();
extern void _ZN7S3624C24v139Ev();
extern void _ZN7S3624C24v140Ev();
extern void _ZN7S3624C24v141Ev();
extern void _ZN7S3624C24v142Ev();
extern void _ZN7S3624C24v143Ev();
extern void _ZN7S3624C24v144Ev();
extern void _ZN7S3624C24v145Ev();
extern void _ZN7S3624C24v146Ev();
extern void _ZN7S3624C24v147Ev();
extern void _ZN7S3624C24v148Ev();
extern void _ZN7S3624C24v149Ev();
extern void _ZN7S3624C24v150Ev();
extern void _ZN7S3624C24v151Ev();
extern void _ZN7S3624C24v152Ev();
extern void _ZN7S3624C24v153Ev();
extern void _ZN7S3624C24v154Ev();
extern void _ZN7S3624C24v155Ev();
extern void _ZN7S3624C24v156Ev();
extern void _ZN7S3624C24v157Ev();
extern void _ZN7S3624C24v158Ev();
extern void _ZN7S3624C24v159Ev();
extern void _ZN7S3624C24v160Ev();
extern void _ZN7S3624C24v161Ev();
extern void _ZN7S3624C24v162Ev();
extern void _ZN7S3624C24v163Ev();
extern void _ZN7S3624C24v164Ev();
extern void _ZN7S3624C24v165Ev();
extern void _ZN7S3624C24v166Ev();
extern void _ZN7S3624C24v167Ev();
extern void _ZN7S3624C24v168Ev();
extern void _ZN7S3624C24v169Ev();
extern void _ZN7S3624C24v170Ev();
extern void _ZN7S3624C24v171Ev();
extern void _ZN7S3624C24v172Ev();
extern void _ZN7S3624C24v173Ev();
extern void _ZN7S3624C24v174Ev();
extern void _ZN7S3624C24v175Ev();
extern void _ZN7S3624C24v176Ev();
extern void _ZN7S3624C24v177Ev();
extern void _ZN7S3624C24v178Ev();
extern void _ZN7S3624C24v179Ev();
extern void _ZN7S3624C24v180Ev();
extern void _ZN7S3624C24v181Ev();
extern void _ZN7S3624C24v182Ev();
extern void _ZN7S3624C24v183Ev();
extern void _ZN7S3624C24v184Ev();
extern void _ZN7S3624C24v185Ev();
extern void _ZN7S3624C24v186Ev();
extern void _ZN7S3624C24v187Ev();
extern void _ZN7S3624C24v188Ev();
extern void _ZN7S3624C24v189Ev();
extern void _ZN7S3624C12v1Ev();
extern void _ZN7S3624C12v2Ev();
extern void _ZN7S3624C12v3Ev();
extern void _ZN7S3624C12v4Ev();
extern void _ZN7S3624C12v5Ev();
extern void _ZN7S3624C12v6Ev();
extern void _ZN7S3624C12v7Ev();
extern void _ZN7S3624C12v8Ev();
extern void _ZN7S3624C12v9Ev();
extern void _ZN7S3624C13v10Ev();
extern void _ZN7S3624C13v11Ev();
extern void _ZN7S3624C13v12Ev();
extern void _ZN7S3624C13v13Ev();
extern void _ZN7S3624C13v14Ev();
extern void _ZN7S3624C13v15Ev();
extern void _ZN7S3624C13v16Ev();
extern void _ZN7S3624C13v17Ev();
extern void _ZN7S3624C13v18Ev();
extern void _ZN7S3624C13v19Ev();
extern void _ZN7S3624C13v20Ev();
extern void _ZN7S3624C13v21Ev();
extern void _ZN7S3624C13v22Ev();
extern void _ZN7S3624C13v23Ev();
extern void _ZN7S3624C13v24Ev();
extern void _ZN7S3624C13v25Ev();
extern void _ZN7S3624C13v26Ev();
extern void _ZN7S3624C13v27Ev();
extern void _ZN7S3624C13v28Ev();
extern void _ZN7S3624C13v29Ev();
extern void _ZN7S3624C13v30Ev();
extern void _ZN7S3624C13v31Ev();
extern void _ZN7S3624C13v32Ev();
extern void _ZN7S3624C13v33Ev();
extern void _ZN7S3624C13v34Ev();
extern void _ZN7S3624C13v35Ev();
extern void _ZN7S3624C13v36Ev();
extern void _ZN7S3624C13v37Ev();
extern void _ZN7S3624C13v38Ev();
extern void _ZN7S3624C13v39Ev();
extern void _ZN7S3624C13v40Ev();
extern void _ZN7S3624C13v41Ev();
extern void _ZN7S3624C13v42Ev();
extern void _ZN7S3624C13v43Ev();
extern void _ZN7S3624C13v44Ev();
extern void _ZN7S3624C13v45Ev();
extern void _ZN7S3624C13v46Ev();
extern void _ZN7S3624C13v47Ev();
extern void _ZN7S3624C13v48Ev();
extern void _ZN7S3624C13v49Ev();
extern void _ZN7S3624C13v50Ev();
extern void _ZN7S3624C13v51Ev();
extern void _ZN7S3624C13v52Ev();
extern void _ZN7S3624C13v53Ev();
extern void _ZN7S3624C13v54Ev();
extern void _ZN7S3624C13v55Ev();
extern void _ZN7S3624C13v56Ev();
extern void _ZN7S3624C13v57Ev();
extern void _ZN7S3624C13v58Ev();
extern void _ZN7S3624C13v59Ev();
extern void _ZN7S3624C13v60Ev();
extern void _ZN7S3624C13v61Ev();
extern void _ZN7S3624C13v62Ev();
extern void _ZN7S3624C13v63Ev();
extern void _ZN7S3624C13v64Ev();
extern void _ZN7S3624C13v65Ev();
extern void _ZN7S3624C13v66Ev();
extern void _ZN7S3624C13v67Ev();
extern void _ZN7S3624C13v68Ev();
extern void _ZN7S3624C13v69Ev();
extern void _ZN7S3624C13v70Ev();
extern void _ZN7S3624C13v71Ev();
extern void _ZN7S3624C13v72Ev();
extern void _ZN7S3624C13v73Ev();
extern void _ZN7S3624C13v74Ev();
extern void _ZN7S3624C13v75Ev();
extern void _ZN7S3624C13v76Ev();
extern void _ZN7S3624C13v77Ev();
extern void _ZN7S3624C13v78Ev();
extern void _ZN7S3624C13v79Ev();
extern void _ZN7S3624C13v80Ev();
extern void _ZN7S3624C13v81Ev();
extern void _ZN7S3624C13v82Ev();
extern void _ZN7S3624C13v83Ev();
extern void _ZN7S3624C13v84Ev();
extern void _ZN7S3624C13v85Ev();
extern void _ZN7S3624C13v86Ev();
extern void _ZN7S3624C13v87Ev();
extern void _ZN7S3624C13v88Ev();
extern void _ZN7S3624C13v89Ev();
extern void _ZN7S3624C13v90Ev();
extern void _ZN7S3624C13v91Ev();
extern void _ZN7S3624C13v92Ev();
static  VTBL_ENTRY vtc_S3624C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3624C1[0]),
  (VTBL_ENTRY)&_ZN7S3624C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3624C1D0Ev,
  (VTBL_ENTRY)&_ZN7S3624C23v93Ev,
  (VTBL_ENTRY)&_ZN7S3624C23v94Ev,
  (VTBL_ENTRY)&_ZN7S3624C23v95Ev,
  (VTBL_ENTRY)&_ZN7S3624C23v96Ev,
  (VTBL_ENTRY)&_ZN7S3624C23v97Ev,
  (VTBL_ENTRY)&_ZN7S3624C23v98Ev,
  (VTBL_ENTRY)&_ZN7S3624C23v99Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v100Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v101Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v102Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v103Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v104Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v105Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v106Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v107Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v108Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v109Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v110Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v111Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v112Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v113Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v114Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v115Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v116Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v117Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v118Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v119Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v120Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v121Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v122Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v123Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v124Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v125Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v126Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v127Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v128Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v129Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v130Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v131Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v132Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v133Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v134Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v135Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v136Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v137Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v138Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v139Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v140Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v141Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v142Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v143Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v144Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v145Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v146Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v147Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v148Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v149Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v150Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v151Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v152Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v153Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v154Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v155Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v156Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v157Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v158Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v159Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v160Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v161Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v162Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v163Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v164Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v165Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v166Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v167Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v168Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v169Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v170Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v171Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v172Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v173Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v174Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v175Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v176Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v177Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v178Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v179Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v180Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v181Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v182Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v183Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v184Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v185Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v186Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v187Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v188Ev,
  (VTBL_ENTRY)&_ZN7S3624C24v189Ev,
  (VTBL_ENTRY)&_ZN7S3624C12v1Ev,
  (VTBL_ENTRY)&_ZN7S3624C12v2Ev,
  (VTBL_ENTRY)&_ZN7S3624C12v3Ev,
  (VTBL_ENTRY)&_ZN7S3624C12v4Ev,
  (VTBL_ENTRY)&_ZN7S3624C12v5Ev,
  (VTBL_ENTRY)&_ZN7S3624C12v6Ev,
  (VTBL_ENTRY)&_ZN7S3624C12v7Ev,
  (VTBL_ENTRY)&_ZN7S3624C12v8Ev,
  (VTBL_ENTRY)&_ZN7S3624C12v9Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v10Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v11Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v12Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v13Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v14Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v15Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v16Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v17Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v18Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v19Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v20Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v21Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v22Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v23Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v24Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v25Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v26Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v27Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v28Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v29Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v30Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v31Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v32Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v33Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v34Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v35Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v36Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v37Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v38Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v39Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v40Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v41Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v42Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v43Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v44Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v45Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v46Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v47Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v48Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v49Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v50Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v51Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v52Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v53Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v54Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v55Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v56Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v57Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v58Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v59Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v60Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v61Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v62Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v63Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v64Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v65Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v66Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v67Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v68Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v69Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v70Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v71Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v72Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v73Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v74Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v75Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v76Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v77Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v78Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v79Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v80Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v81Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v82Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v83Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v84Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v85Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v86Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v87Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v88Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v89Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v90Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v91Ev,
  (VTBL_ENTRY)&_ZN7S3624C13v92Ev,
};
extern VTBL_ENTRY _ZTI7S3624C1[];
extern  VTBL_ENTRY _ZTV7S3624C1[];
Class_Descriptor cd_S3624C1 = {  "S3624C1", // class name
  bases_S3624C1, 2,
  &(vtc_S3624C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(7280,7004), // object size
  NSPAIRA(_ZTI7S3624C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3624C1),193, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3621C2  : S3624C3_nt {
  int s3621c2f0[3];
  ::S3624C10_nt s3621c2f1;
  ::S3624C11_nt s3621c2f2;
  int s3621c2f3[3];
  void *s3621c2f4;
  char s3621c2f5[3];
  ::S3624C12_nt s3621c2f6;
  int s3621c2f7;
  ::S3624C31 s3621c2f8;
  void *s3621c2f9;
  int s3621c2f10[2];
  ::S3624C13_nt s3621c2f11;
  ::S3624C13_nt s3621c2f12;
  int s3621c2f13[3];
  char s3621c2f14[6144];
  ::S2005C20_nt s3621c2f15;
  ::S3624C25_nt s3621c2f16;
  char s3621c2f17;
  int s3621c2f18;
  char s3621c2f19;
  int s3621c2f20[5];
  __tsi64 s3621c2f21[7];
  char s3621c2f22;
  __tsi64 s3621c2f23[9];
  int s3621c2f24[2];
  ::S3624C22_nt s3621c2f25;
  ::S3624C28_nt s3621c2f26;
  void *s3621c2f27[3];
  __tsi64 s3621c2f28[2];
  ::S2005C20_nt s3621c2f29;
  int s3621c2f30;
  char s3621c2f31;
  __tsi64 s3621c2f32;
  char s3621c2f33;
  __tsi64 s3621c2f34;
  virtual  ~S3621C2(); // _ZN7S3621C2D1Ev
  virtual void  v49(); // _ZN7S3621C23v49Ev
  virtual void  v50(); // _ZN7S3621C23v50Ev
  virtual void  v51(); // _ZN7S3621C23v51Ev
  virtual void  v52(); // _ZN7S3621C23v52Ev
  virtual void  v53(); // _ZN7S3621C23v53Ev
  virtual void  v54(); // _ZN7S3621C23v54Ev
  virtual void  v55(); // _ZN7S3621C23v55Ev
  virtual void  v56(); // _ZN7S3621C23v56Ev
  virtual void  v57(); // _ZN7S3621C23v57Ev
  virtual void  v58(); // _ZN7S3621C23v58Ev
  virtual void  v59(); // _ZN7S3621C23v59Ev
  virtual void  v60(); // _ZN7S3621C23v60Ev
  virtual void  v61(); // _ZN7S3621C23v61Ev
  virtual void  v62(); // _ZN7S3621C23v62Ev
  virtual void  v63(); // _ZN7S3621C23v63Ev
  virtual void  v64(); // _ZN7S3621C23v64Ev
  virtual void  v65(); // _ZN7S3621C23v65Ev
  virtual void  v66(); // _ZN7S3621C23v66Ev
  virtual void  v67(); // _ZN7S3621C23v67Ev
  virtual void  v68(); // _ZN7S3621C23v68Ev
  virtual void  v69(); // _ZN7S3621C23v69Ev
  virtual void  v70(); // _ZN7S3621C23v70Ev
  virtual void  v71(); // _ZN7S3621C23v71Ev
  virtual void  v72(); // _ZN7S3621C23v72Ev
  virtual void  v73(); // _ZN7S3621C23v73Ev
  virtual void  v74(); // _ZN7S3621C23v74Ev
  virtual void  v75(); // _ZN7S3621C23v75Ev
  virtual void  v76(); // _ZN7S3621C23v76Ev
  virtual void  v77(); // _ZN7S3621C23v77Ev
  virtual void  v78(); // _ZN7S3621C23v78Ev
  virtual void  v79(); // _ZN7S3621C23v79Ev
  virtual void  v80(); // _ZN7S3621C23v80Ev
  virtual void  v81(); // _ZN7S3621C23v81Ev
  virtual void  v82(); // _ZN7S3621C23v82Ev
  virtual void  v83(); // _ZN7S3621C23v83Ev
  virtual void  v84(); // _ZN7S3621C23v84Ev
  virtual void  v85(); // _ZN7S3621C23v85Ev
  virtual void  v86(); // _ZN7S3621C23v86Ev
  virtual void  v87(); // _ZN7S3621C23v87Ev
  virtual void  v88(); // _ZN7S3621C23v88Ev
  virtual void  v89(); // _ZN7S3621C23v89Ev
  virtual void  v90(); // _ZN7S3621C23v90Ev
  virtual void  v91(); // _ZN7S3621C23v91Ev
  virtual void  v92(); // _ZN7S3621C23v92Ev
  virtual void  v93(); // _ZN7S3621C23v93Ev
  virtual void  v94(); // _ZN7S3621C23v94Ev
  virtual void  v95(); // _ZN7S3621C23v95Ev
  virtual void  v96(); // _ZN7S3621C23v96Ev
  virtual void  v97(); // _ZN7S3621C23v97Ev
  virtual void  v98(); // _ZN7S3621C23v98Ev
  virtual void  v99(); // _ZN7S3621C23v99Ev
  virtual void  v100(); // _ZN7S3621C24v100Ev
  virtual void  v101(); // _ZN7S3621C24v101Ev
  virtual void  v102(); // _ZN7S3621C24v102Ev
  virtual void  v103(); // _ZN7S3621C24v103Ev
  virtual void  v104(); // _ZN7S3621C24v104Ev
  virtual void  v105(); // _ZN7S3621C24v105Ev
  virtual void  v106(); // _ZN7S3621C24v106Ev
  virtual void  v107(); // _ZN7S3621C24v107Ev
  virtual void  v108(); // _ZN7S3621C24v108Ev
  virtual void  v109(); // _ZN7S3621C24v109Ev
  virtual void  v110(); // _ZN7S3621C24v110Ev
  virtual void  v111(); // _ZN7S3621C24v111Ev
  virtual void  v112(); // _ZN7S3621C24v112Ev
  virtual void  v113(); // _ZN7S3621C24v113Ev
  virtual void  v114(); // _ZN7S3621C24v114Ev
  virtual void  v115(); // _ZN7S3621C24v115Ev
  virtual void  v116(); // _ZN7S3621C24v116Ev
  virtual void  v117(); // _ZN7S3621C24v117Ev
  virtual void  v118(); // _ZN7S3621C24v118Ev
  virtual void  v119(); // _ZN7S3621C24v119Ev
  virtual void  v120(); // _ZN7S3621C24v120Ev
  virtual void  v121(); // _ZN7S3621C24v121Ev
  virtual void  v122(); // _ZN7S3621C24v122Ev
  virtual void  v123(); // _ZN7S3621C24v123Ev
  virtual void  v124(); // _ZN7S3621C24v124Ev
  virtual void  v125(); // _ZN7S3621C24v125Ev
  virtual void  v126(); // _ZN7S3621C24v126Ev
  virtual void  v127(); // _ZN7S3621C24v127Ev
  virtual void  v128(); // _ZN7S3621C24v128Ev
  virtual void  v129(); // _ZN7S3621C24v129Ev
  virtual void  v130(); // _ZN7S3621C24v130Ev
  virtual void  v131(); // _ZN7S3621C24v131Ev
  virtual void  v132(); // _ZN7S3621C24v132Ev
  virtual void  v133(); // _ZN7S3621C24v133Ev
  virtual void  v134(); // _ZN7S3621C24v134Ev
  virtual void  v135(); // _ZN7S3621C24v135Ev
  virtual void  v136(); // _ZN7S3621C24v136Ev
  virtual void  v137(); // _ZN7S3621C24v137Ev
  virtual void  v138(); // _ZN7S3621C24v138Ev
  virtual void  v139(); // _ZN7S3621C24v139Ev
  virtual void  v140(); // _ZN7S3621C24v140Ev
  virtual void  v141(); // _ZN7S3621C24v141Ev
  virtual void  v142(); // _ZN7S3621C24v142Ev
  virtual void  v143(); // _ZN7S3621C24v143Ev
  virtual void  v144(); // _ZN7S3621C24v144Ev
  virtual void  v145(); // _ZN7S3621C24v145Ev
  S3621C2(); // tgen
};
//SIG(-1 S3621C2) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC6{ m Fp Fi FC7{ m} FC4} Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 Fi[3] FC8{ m Fc Fl[2] Fs[12] Fc[5]} FC9{ m Fc Fl[4] Fi[4]} Fi[3] Fp Fc[3] FC10{ m FC11{ m FC12{ Fl[4]}} Fc Fp Fi[3]} Fi FC13{ m Fp Fi[2] FC5} Fp Fi[2] FC11 FC11 Fi[3] Fc[6144] FC14{ m Fp Fi FC7} FC15{ m Fp Fi[2] FC16{ m}} Fc Fi Fc Fi[5] FL[7] Fc FL[9] Fi[2] FC17{ BC18{ m FC19{ m Fc[11]} Fi[7] FL} Fi FC15 FC19 Fi} FC20{ m Fp FC11 FL[2] Fi FL Fi[2] Fc FC14 FC14 FL[5] Fc Fi FC15 FC15 FC15 FC15 FC13 Fi[2]} Fp[3] FL[2] FC14 Fi Fc FL Fc FL}


 S3621C2 ::~S3621C2(){ note_dtor("S3621C2", this);}
void  S3621C2 ::v49(){vfunc_called(this, "_ZN7S3621C23v49Ev");}
void  S3621C2 ::v50(){vfunc_called(this, "_ZN7S3621C23v50Ev");}
void  S3621C2 ::v51(){vfunc_called(this, "_ZN7S3621C23v51Ev");}
void  S3621C2 ::v52(){vfunc_called(this, "_ZN7S3621C23v52Ev");}
void  S3621C2 ::v53(){vfunc_called(this, "_ZN7S3621C23v53Ev");}
void  S3621C2 ::v54(){vfunc_called(this, "_ZN7S3621C23v54Ev");}
void  S3621C2 ::v55(){vfunc_called(this, "_ZN7S3621C23v55Ev");}
void  S3621C2 ::v56(){vfunc_called(this, "_ZN7S3621C23v56Ev");}
void  S3621C2 ::v57(){vfunc_called(this, "_ZN7S3621C23v57Ev");}
void  S3621C2 ::v58(){vfunc_called(this, "_ZN7S3621C23v58Ev");}
void  S3621C2 ::v59(){vfunc_called(this, "_ZN7S3621C23v59Ev");}
void  S3621C2 ::v60(){vfunc_called(this, "_ZN7S3621C23v60Ev");}
void  S3621C2 ::v61(){vfunc_called(this, "_ZN7S3621C23v61Ev");}
void  S3621C2 ::v62(){vfunc_called(this, "_ZN7S3621C23v62Ev");}
void  S3621C2 ::v63(){vfunc_called(this, "_ZN7S3621C23v63Ev");}
void  S3621C2 ::v64(){vfunc_called(this, "_ZN7S3621C23v64Ev");}
void  S3621C2 ::v65(){vfunc_called(this, "_ZN7S3621C23v65Ev");}
void  S3621C2 ::v66(){vfunc_called(this, "_ZN7S3621C23v66Ev");}
void  S3621C2 ::v67(){vfunc_called(this, "_ZN7S3621C23v67Ev");}
void  S3621C2 ::v68(){vfunc_called(this, "_ZN7S3621C23v68Ev");}
void  S3621C2 ::v69(){vfunc_called(this, "_ZN7S3621C23v69Ev");}
void  S3621C2 ::v70(){vfunc_called(this, "_ZN7S3621C23v70Ev");}
void  S3621C2 ::v71(){vfunc_called(this, "_ZN7S3621C23v71Ev");}
void  S3621C2 ::v72(){vfunc_called(this, "_ZN7S3621C23v72Ev");}
void  S3621C2 ::v73(){vfunc_called(this, "_ZN7S3621C23v73Ev");}
void  S3621C2 ::v74(){vfunc_called(this, "_ZN7S3621C23v74Ev");}
void  S3621C2 ::v75(){vfunc_called(this, "_ZN7S3621C23v75Ev");}
void  S3621C2 ::v76(){vfunc_called(this, "_ZN7S3621C23v76Ev");}
void  S3621C2 ::v77(){vfunc_called(this, "_ZN7S3621C23v77Ev");}
void  S3621C2 ::v78(){vfunc_called(this, "_ZN7S3621C23v78Ev");}
void  S3621C2 ::v79(){vfunc_called(this, "_ZN7S3621C23v79Ev");}
void  S3621C2 ::v80(){vfunc_called(this, "_ZN7S3621C23v80Ev");}
void  S3621C2 ::v81(){vfunc_called(this, "_ZN7S3621C23v81Ev");}
void  S3621C2 ::v82(){vfunc_called(this, "_ZN7S3621C23v82Ev");}
void  S3621C2 ::v83(){vfunc_called(this, "_ZN7S3621C23v83Ev");}
void  S3621C2 ::v84(){vfunc_called(this, "_ZN7S3621C23v84Ev");}
void  S3621C2 ::v85(){vfunc_called(this, "_ZN7S3621C23v85Ev");}
void  S3621C2 ::v86(){vfunc_called(this, "_ZN7S3621C23v86Ev");}
void  S3621C2 ::v87(){vfunc_called(this, "_ZN7S3621C23v87Ev");}
void  S3621C2 ::v88(){vfunc_called(this, "_ZN7S3621C23v88Ev");}
void  S3621C2 ::v89(){vfunc_called(this, "_ZN7S3621C23v89Ev");}
void  S3621C2 ::v90(){vfunc_called(this, "_ZN7S3621C23v90Ev");}
void  S3621C2 ::v91(){vfunc_called(this, "_ZN7S3621C23v91Ev");}
void  S3621C2 ::v92(){vfunc_called(this, "_ZN7S3621C23v92Ev");}
void  S3621C2 ::v93(){vfunc_called(this, "_ZN7S3621C23v93Ev");}
void  S3621C2 ::v94(){vfunc_called(this, "_ZN7S3621C23v94Ev");}
void  S3621C2 ::v95(){vfunc_called(this, "_ZN7S3621C23v95Ev");}
void  S3621C2 ::v96(){vfunc_called(this, "_ZN7S3621C23v96Ev");}
void  S3621C2 ::v97(){vfunc_called(this, "_ZN7S3621C23v97Ev");}
void  S3621C2 ::v98(){vfunc_called(this, "_ZN7S3621C23v98Ev");}
void  S3621C2 ::v99(){vfunc_called(this, "_ZN7S3621C23v99Ev");}
void  S3621C2 ::v100(){vfunc_called(this, "_ZN7S3621C24v100Ev");}
void  S3621C2 ::v101(){vfunc_called(this, "_ZN7S3621C24v101Ev");}
void  S3621C2 ::v102(){vfunc_called(this, "_ZN7S3621C24v102Ev");}
void  S3621C2 ::v103(){vfunc_called(this, "_ZN7S3621C24v103Ev");}
void  S3621C2 ::v104(){vfunc_called(this, "_ZN7S3621C24v104Ev");}
void  S3621C2 ::v105(){vfunc_called(this, "_ZN7S3621C24v105Ev");}
void  S3621C2 ::v106(){vfunc_called(this, "_ZN7S3621C24v106Ev");}
void  S3621C2 ::v107(){vfunc_called(this, "_ZN7S3621C24v107Ev");}
void  S3621C2 ::v108(){vfunc_called(this, "_ZN7S3621C24v108Ev");}
void  S3621C2 ::v109(){vfunc_called(this, "_ZN7S3621C24v109Ev");}
void  S3621C2 ::v110(){vfunc_called(this, "_ZN7S3621C24v110Ev");}
void  S3621C2 ::v111(){vfunc_called(this, "_ZN7S3621C24v111Ev");}
void  S3621C2 ::v112(){vfunc_called(this, "_ZN7S3621C24v112Ev");}
void  S3621C2 ::v113(){vfunc_called(this, "_ZN7S3621C24v113Ev");}
void  S3621C2 ::v114(){vfunc_called(this, "_ZN7S3621C24v114Ev");}
void  S3621C2 ::v115(){vfunc_called(this, "_ZN7S3621C24v115Ev");}
void  S3621C2 ::v116(){vfunc_called(this, "_ZN7S3621C24v116Ev");}
void  S3621C2 ::v117(){vfunc_called(this, "_ZN7S3621C24v117Ev");}
void  S3621C2 ::v118(){vfunc_called(this, "_ZN7S3621C24v118Ev");}
void  S3621C2 ::v119(){vfunc_called(this, "_ZN7S3621C24v119Ev");}
void  S3621C2 ::v120(){vfunc_called(this, "_ZN7S3621C24v120Ev");}
void  S3621C2 ::v121(){vfunc_called(this, "_ZN7S3621C24v121Ev");}
void  S3621C2 ::v122(){vfunc_called(this, "_ZN7S3621C24v122Ev");}
void  S3621C2 ::v123(){vfunc_called(this, "_ZN7S3621C24v123Ev");}
void  S3621C2 ::v124(){vfunc_called(this, "_ZN7S3621C24v124Ev");}
void  S3621C2 ::v125(){vfunc_called(this, "_ZN7S3621C24v125Ev");}
void  S3621C2 ::v126(){vfunc_called(this, "_ZN7S3621C24v126Ev");}
void  S3621C2 ::v127(){vfunc_called(this, "_ZN7S3621C24v127Ev");}
void  S3621C2 ::v128(){vfunc_called(this, "_ZN7S3621C24v128Ev");}
void  S3621C2 ::v129(){vfunc_called(this, "_ZN7S3621C24v129Ev");}
void  S3621C2 ::v130(){vfunc_called(this, "_ZN7S3621C24v130Ev");}
void  S3621C2 ::v131(){vfunc_called(this, "_ZN7S3621C24v131Ev");}
void  S3621C2 ::v132(){vfunc_called(this, "_ZN7S3621C24v132Ev");}
void  S3621C2 ::v133(){vfunc_called(this, "_ZN7S3621C24v133Ev");}
void  S3621C2 ::v134(){vfunc_called(this, "_ZN7S3621C24v134Ev");}
void  S3621C2 ::v135(){vfunc_called(this, "_ZN7S3621C24v135Ev");}
void  S3621C2 ::v136(){vfunc_called(this, "_ZN7S3621C24v136Ev");}
void  S3621C2 ::v137(){vfunc_called(this, "_ZN7S3621C24v137Ev");}
void  S3621C2 ::v138(){vfunc_called(this, "_ZN7S3621C24v138Ev");}
void  S3621C2 ::v139(){vfunc_called(this, "_ZN7S3621C24v139Ev");}
void  S3621C2 ::v140(){vfunc_called(this, "_ZN7S3621C24v140Ev");}
void  S3621C2 ::v141(){vfunc_called(this, "_ZN7S3621C24v141Ev");}
void  S3621C2 ::v142(){vfunc_called(this, "_ZN7S3621C24v142Ev");}
void  S3621C2 ::v143(){vfunc_called(this, "_ZN7S3621C24v143Ev");}
void  S3621C2 ::v144(){vfunc_called(this, "_ZN7S3621C24v144Ev");}
void  S3621C2 ::v145(){vfunc_called(this, "_ZN7S3621C24v145Ev");}
S3621C2 ::S3621C2(){ note_ctor("S3621C2", this);} // tgen

static void Test_S3621C2()
{
  extern Class_Descriptor cd_S3621C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(905,1744)];
    init_test(&cd_S3621C2, buf);
    S3621C2 *dp, &lv = *(dp=new (buf) S3621C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(7232,6972), "sizeof(S3621C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3621C2)");
    check_base_class_offset(lv, (S3624C3_nt*), 0, "S3621C2");
    check_field_offset(lv, s3621c2f0, ABISELECT(44,32), "S3621C2.s3621c2f0");
    check_field_offset(lv, s3621c2f1, ABISELECT(56,44), "S3621C2.s3621c2f1");
    check_field_offset(lv, s3621c2f2, ABISELECT(112,88), "S3621C2.s3621c2f2");
    check_field_offset(lv, s3621c2f3, ABISELECT(168,124), "S3621C2.s3621c2f3");
    check_field_offset(lv, s3621c2f4, ABISELECT(184,136), "S3621C2.s3621c2f4");
    check_field_offset(lv, s3621c2f5, ABISELECT(192,140), "S3621C2.s3621c2f5");
    check_field_offset(lv, s3621c2f6, ABISELECT(200,144), "S3621C2.s3621c2f6");
    check_field_offset(lv, s3621c2f7, ABISELECT(264,180), "S3621C2.s3621c2f7");
    check_field_offset(lv, s3621c2f8, ABISELECT(272,184), "S3621C2.s3621c2f8");
    check_field_offset(lv, s3621c2f9, ABISELECT(296,200), "S3621C2.s3621c2f9");
    check_field_offset(lv, s3621c2f10, ABISELECT(304,204), "S3621C2.s3621c2f10");
    check_field_offset(lv, s3621c2f11, ABISELECT(312,212), "S3621C2.s3621c2f11");
    check_field_offset(lv, s3621c2f12, ABISELECT(344,228), "S3621C2.s3621c2f12");
    check_field_offset(lv, s3621c2f13, ABISELECT(376,244), "S3621C2.s3621c2f13");
    check_field_offset(lv, s3621c2f14, ABISELECT(388,256), "S3621C2.s3621c2f14");
    check_field_offset(lv, s3621c2f15, ABISELECT(6536,6400), "S3621C2.s3621c2f15");
    check_field_offset(lv, s3621c2f16, ABISELECT(6552,6412), "S3621C2.s3621c2f16");
    check_field_offset(lv, s3621c2f17, ABISELECT(6576,6428), "S3621C2.s3621c2f17");
    check_field_offset(lv, s3621c2f18, ABISELECT(6580,6432), "S3621C2.s3621c2f18");
    check_field_offset(lv, s3621c2f19, ABISELECT(6584,6436), "S3621C2.s3621c2f19");
    check_field_offset(lv, s3621c2f20, ABISELECT(6588,6440), "S3621C2.s3621c2f20");
    check_field_offset(lv, s3621c2f21, ABISELECT(6608,6460), "S3621C2.s3621c2f21");
    check_field_offset(lv, s3621c2f22, ABISELECT(6664,6516), "S3621C2.s3621c2f22");
    check_field_offset(lv, s3621c2f23, ABISELECT(6672,6520), "S3621C2.s3621c2f23");
    check_field_offset(lv, s3621c2f24, ABISELECT(6744,6592), "S3621C2.s3621c2f24");
    check_field_offset(lv, s3621c2f25, ABISELECT(6752,6600), "S3621C2.s3621c2f25");
    check_field_offset(lv, s3621c2f26, ABISELECT(6848,6684), "S3621C2.s3621c2f26");
    check_field_offset(lv, s3621c2f27, ABISELECT(7144,6904), "S3621C2.s3621c2f27");
    check_field_offset(lv, s3621c2f28, ABISELECT(7168,6916), "S3621C2.s3621c2f28");
    check_field_offset(lv, s3621c2f29, ABISELECT(7184,6932), "S3621C2.s3621c2f29");
    check_field_offset(lv, s3621c2f30, ABISELECT(7200,6944), "S3621C2.s3621c2f30");
    check_field_offset(lv, s3621c2f31, ABISELECT(7204,6948), "S3621C2.s3621c2f31");
    check_field_offset(lv, s3621c2f32, ABISELECT(7208,6952), "S3621C2.s3621c2f32");
    check_field_offset(lv, s3621c2f33, ABISELECT(7216,6960), "S3621C2.s3621c2f33");
    check_field_offset(lv, s3621c2f34, ABISELECT(7224,6964), "S3621C2.s3621c2f34");
    test_class_info(&lv, &cd_S3621C2);
    dp->~S3621C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3621C2(Test_S3621C2, "S3621C2", ABISELECT(7232,6972));

#else // __cplusplus

extern void _ZN7S3621C2C1Ev();
extern void _ZN7S3621C2D1Ev();
Name_Map name_map_S3621C2[] = {
  NSPAIR(_ZN7S3621C2C1Ev),
  NSPAIR(_ZN7S3621C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3624C3_nt;
extern VTBL_ENTRY _ZTI10S3624C3_nt[];
extern  VTBL_ENTRY _ZTV10S3624C3_nt[];
static Base_Class bases_S3621C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3624C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3621C2[];
extern void _ZN7S3621C2D1Ev();
extern void _ZN7S3621C2D0Ev();
extern void _ZN7S3621C23v49Ev();
extern void _ZN7S3621C23v50Ev();
extern void _ZN7S3621C23v51Ev();
extern void _ZN7S3621C23v52Ev();
extern void _ZN7S3621C23v53Ev();
extern void _ZN7S3621C23v54Ev();
extern void _ZN7S3621C23v55Ev();
extern void _ZN7S3621C23v56Ev();
extern void _ZN7S3621C23v57Ev();
extern void _ZN7S3621C23v58Ev();
extern void _ZN7S3621C23v59Ev();
extern void _ZN7S3621C23v60Ev();
extern void _ZN7S3621C23v61Ev();
extern void _ZN7S3621C23v62Ev();
extern void _ZN7S3621C23v63Ev();
extern void _ZN7S3621C23v64Ev();
extern void _ZN7S3621C23v65Ev();
extern void _ZN7S3621C23v66Ev();
extern void _ZN7S3621C23v67Ev();
extern void _ZN7S3621C23v68Ev();
extern void _ZN7S3621C23v69Ev();
extern void _ZN7S3621C23v70Ev();
extern void _ZN7S3621C23v71Ev();
extern void _ZN7S3621C23v72Ev();
extern void _ZN7S3621C23v73Ev();
extern void _ZN7S3621C23v74Ev();
extern void _ZN7S3621C23v75Ev();
extern void _ZN7S3621C23v76Ev();
extern void _ZN7S3621C23v77Ev();
extern void _ZN7S3621C23v78Ev();
extern void _ZN7S3621C23v79Ev();
extern void _ZN7S3621C23v80Ev();
extern void _ZN7S3621C23v81Ev();
extern void _ZN7S3621C23v82Ev();
extern void _ZN7S3621C23v83Ev();
extern void _ZN7S3621C23v84Ev();
extern void _ZN7S3621C23v85Ev();
extern void _ZN7S3621C23v86Ev();
extern void _ZN7S3621C23v87Ev();
extern void _ZN7S3621C23v88Ev();
extern void _ZN7S3621C23v89Ev();
extern void _ZN7S3621C23v90Ev();
extern void _ZN7S3621C23v91Ev();
extern void _ZN7S3621C23v92Ev();
extern void _ZN7S3621C23v93Ev();
extern void _ZN7S3621C23v94Ev();
extern void _ZN7S3621C23v95Ev();
extern void _ZN7S3621C23v96Ev();
extern void _ZN7S3621C23v97Ev();
extern void _ZN7S3621C23v98Ev();
extern void _ZN7S3621C23v99Ev();
extern void _ZN7S3621C24v100Ev();
extern void _ZN7S3621C24v101Ev();
extern void _ZN7S3621C24v102Ev();
extern void _ZN7S3621C24v103Ev();
extern void _ZN7S3621C24v104Ev();
extern void _ZN7S3621C24v105Ev();
extern void _ZN7S3621C24v106Ev();
extern void _ZN7S3621C24v107Ev();
extern void _ZN7S3621C24v108Ev();
extern void _ZN7S3621C24v109Ev();
extern void _ZN7S3621C24v110Ev();
extern void _ZN7S3621C24v111Ev();
extern void _ZN7S3621C24v112Ev();
extern void _ZN7S3621C24v113Ev();
extern void _ZN7S3621C24v114Ev();
extern void _ZN7S3621C24v115Ev();
extern void _ZN7S3621C24v116Ev();
extern void _ZN7S3621C24v117Ev();
extern void _ZN7S3621C24v118Ev();
extern void _ZN7S3621C24v119Ev();
extern void _ZN7S3621C24v120Ev();
extern void _ZN7S3621C24v121Ev();
extern void _ZN7S3621C24v122Ev();
extern void _ZN7S3621C24v123Ev();
extern void _ZN7S3621C24v124Ev();
extern void _ZN7S3621C24v125Ev();
extern void _ZN7S3621C24v126Ev();
extern void _ZN7S3621C24v127Ev();
extern void _ZN7S3621C24v128Ev();
extern void _ZN7S3621C24v129Ev();
extern void _ZN7S3621C24v130Ev();
extern void _ZN7S3621C24v131Ev();
extern void _ZN7S3621C24v132Ev();
extern void _ZN7S3621C24v133Ev();
extern void _ZN7S3621C24v134Ev();
extern void _ZN7S3621C24v135Ev();
extern void _ZN7S3621C24v136Ev();
extern void _ZN7S3621C24v137Ev();
extern void _ZN7S3621C24v138Ev();
extern void _ZN7S3621C24v139Ev();
extern void _ZN7S3621C24v140Ev();
extern void _ZN7S3621C24v141Ev();
extern void _ZN7S3621C24v142Ev();
extern void _ZN7S3621C24v143Ev();
extern void _ZN7S3621C24v144Ev();
extern void _ZN7S3621C24v145Ev();
static  VTBL_ENTRY vtc_S3621C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3621C2[0]),
  (VTBL_ENTRY)&_ZN7S3621C2D1Ev,
  (VTBL_ENTRY)&_ZN7S3621C2D0Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v49Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v50Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v51Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v52Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v53Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v54Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v55Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v56Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v57Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v58Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v59Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v60Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v61Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v62Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v63Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v64Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v65Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v66Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v67Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v68Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v69Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v70Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v71Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v72Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v73Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v74Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v75Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v76Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v77Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v78Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v79Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v80Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v81Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v82Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v83Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v84Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v85Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v86Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v87Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v88Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v89Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v90Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v91Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v92Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v93Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v94Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v95Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v96Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v97Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v98Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v99Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v100Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v101Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v102Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v103Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v104Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v105Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v106Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v107Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v108Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v109Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v110Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v111Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v112Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v113Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v114Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v115Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v116Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v117Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v118Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v119Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v120Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v121Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v122Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v123Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v124Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v125Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v126Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v127Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v128Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v129Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v130Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v131Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v132Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v133Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v134Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v135Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v136Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v137Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v138Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v139Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v140Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v141Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v142Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v143Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v144Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v145Ev,
};
extern VTBL_ENTRY _ZTI7S3621C2[];
extern  VTBL_ENTRY _ZTV7S3621C2[];
Class_Descriptor cd_S3621C2 = {  "S3621C2", // class name
  bases_S3621C2, 1,
  &(vtc_S3621C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(7232,6972), // object size
  NSPAIRA(_ZTI7S3621C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3621C2),101, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3621C33_nt  {
  char s3621c33f0;
  ::S2005C13_nt s3621c33f1;
  ::S2005C13_nt s3621c33f2;
  ::S2005C13_nt s3621c33f3;
  int s3621c33f4[3];
  char s3621c33f5;
  int s3621c33f6;
};
//SIG(-1 S3621C33_nt) C1{ Fc FC2{ m FC3{ m FL[2]}} FC2 FC2 Fi[3] Fc Fi}



//skip512 S3621C33_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3621C1  : S3621C2 {
  void *s3621c1f0[6];
  int s3621c1f1;
  ::S3624C13_nt s3621c1f2;
  char s3621c1f3[4];
  ::S2005C20_nt s3621c1f4[4];
  __tsi64 s3621c1f5[4];
  ::S3621C33_nt s3621c1f6[4];
  ::S2005C26 s3621c1f7[4];
  char s3621c1f8;
  void *s3621c1f9[2];
  int s3621c1f10;
  char s3621c1f11;
  int s3621c1f12;
  void *s3621c1f13[2];
  int s3621c1f14;
  __tsi64 s3621c1f15[4];
  char s3621c1f16;
  virtual  ~S3621C1(); // _ZN7S3621C1D1Ev
  virtual void  v1(); // _ZN7S3621C12v1Ev
  virtual void  v2(); // _ZN7S3621C12v2Ev
  virtual void  v3(); // _ZN7S3621C12v3Ev
  virtual void  v4(); // _ZN7S3621C12v4Ev
  virtual void  v5(); // _ZN7S3621C12v5Ev
  virtual void  v6(); // _ZN7S3621C12v6Ev
  virtual void  v7(); // _ZN7S3621C12v7Ev
  virtual void  v8(); // _ZN7S3621C12v8Ev
  virtual void  v9(); // _ZN7S3621C12v9Ev
  virtual void  v10(); // _ZN7S3621C13v10Ev
  virtual void  v11(); // _ZN7S3621C13v11Ev
  virtual void  v12(); // _ZN7S3621C13v12Ev
  virtual void  v13(); // _ZN7S3621C13v13Ev
  virtual void  v14(); // _ZN7S3621C13v14Ev
  virtual void  v15(); // _ZN7S3621C13v15Ev
  virtual void  v16(); // _ZN7S3621C13v16Ev
  virtual void  v17(); // _ZN7S3621C13v17Ev
  virtual void  v18(); // _ZN7S3621C13v18Ev
  virtual void  v19(); // _ZN7S3621C13v19Ev
  virtual void  v20(); // _ZN7S3621C13v20Ev
  virtual void  v21(); // _ZN7S3621C13v21Ev
  virtual void  v22(); // _ZN7S3621C13v22Ev
  virtual void  v23(); // _ZN7S3621C13v23Ev
  virtual void  v24(); // _ZN7S3621C13v24Ev
  virtual void  v25(); // _ZN7S3621C13v25Ev
  virtual void  v26(); // _ZN7S3621C13v26Ev
  virtual void  v27(); // _ZN7S3621C13v27Ev
  virtual void  v28(); // _ZN7S3621C13v28Ev
  virtual void  v29(); // _ZN7S3621C13v29Ev
  virtual void  v30(); // _ZN7S3621C13v30Ev
  virtual void  v31(); // _ZN7S3621C13v31Ev
  virtual void  v32(); // _ZN7S3621C13v32Ev
  virtual void  v33(); // _ZN7S3621C13v33Ev
  virtual void  v34(); // _ZN7S3621C13v34Ev
  virtual void  v35(); // _ZN7S3621C13v35Ev
  virtual void  v36(); // _ZN7S3621C13v36Ev
  virtual void  v37(); // _ZN7S3621C13v37Ev
  virtual void  v38(); // _ZN7S3621C13v38Ev
  virtual void  v39(); // _ZN7S3621C13v39Ev
  virtual void  v40(); // _ZN7S3621C13v40Ev
  virtual void  v41(); // _ZN7S3621C13v41Ev
  virtual void  v42(); // _ZN7S3621C13v42Ev
  virtual void  v43(); // _ZN7S3621C13v43Ev
  virtual void  v44(); // _ZN7S3621C13v44Ev
  virtual void  v45(); // _ZN7S3621C13v45Ev
  virtual void  v46(); // _ZN7S3621C13v46Ev
  virtual void  v47(); // _ZN7S3621C13v47Ev
  virtual void  v48(); // _ZN7S3621C13v48Ev
  S3621C1(); // tgen
};
//SIG(1 S3621C1) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC6{ m}} FC7{ m Fp Fi FC8{ m} FC5} Fc} vd v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 Fi[3] FC9{ m Fc Fl[2] Fs[12] Fc[5]} FC10{ m Fc Fl[4] Fi[4]} Fi[3] Fp Fc[3] FC11{ m FC12{ m FC13{ Fl[4]}} Fc Fp Fi[3]} Fi FC14{ m Fp Fi[2] FC6} Fp Fi[2] FC12 FC12 Fi[3] Fc[6144] FC15{ m Fp Fi FC8} FC16{ m Fp Fi[2] FC17{ m}} Fc Fi Fc Fi[5] FL[7] Fc FL[9] Fi[2] FC18{ BC19{ m FC20{ m Fc[11]} Fi[7] FL} Fi FC16 FC20 Fi} FC21{ m Fp FC12 FL[2] Fi FL Fi[2] Fc FC15 FC15 FL[5] Fc Fi FC16 FC16 FC16 FC16 FC14 Fi[2]} Fp[3] FL[2] FC15 Fi Fc FL Fc FL} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 Fp[6] Fi FC12 Fc[4] FC15[4] FL[4] FC22{ Fc FC23{ m FC24{ m FL[2]}} FC23 FC23 Fi[3] Fc Fi}[4] FC4[4] Fc Fp[2] Fi Fc Fi Fp[2] Fi FL[4] Fc}


 S3621C1 ::~S3621C1(){ note_dtor("S3621C1", this);}
void  S3621C1 ::v1(){vfunc_called(this, "_ZN7S3621C12v1Ev");}
void  S3621C1 ::v2(){vfunc_called(this, "_ZN7S3621C12v2Ev");}
void  S3621C1 ::v3(){vfunc_called(this, "_ZN7S3621C12v3Ev");}
void  S3621C1 ::v4(){vfunc_called(this, "_ZN7S3621C12v4Ev");}
void  S3621C1 ::v5(){vfunc_called(this, "_ZN7S3621C12v5Ev");}
void  S3621C1 ::v6(){vfunc_called(this, "_ZN7S3621C12v6Ev");}
void  S3621C1 ::v7(){vfunc_called(this, "_ZN7S3621C12v7Ev");}
void  S3621C1 ::v8(){vfunc_called(this, "_ZN7S3621C12v8Ev");}
void  S3621C1 ::v9(){vfunc_called(this, "_ZN7S3621C12v9Ev");}
void  S3621C1 ::v10(){vfunc_called(this, "_ZN7S3621C13v10Ev");}
void  S3621C1 ::v11(){vfunc_called(this, "_ZN7S3621C13v11Ev");}
void  S3621C1 ::v12(){vfunc_called(this, "_ZN7S3621C13v12Ev");}
void  S3621C1 ::v13(){vfunc_called(this, "_ZN7S3621C13v13Ev");}
void  S3621C1 ::v14(){vfunc_called(this, "_ZN7S3621C13v14Ev");}
void  S3621C1 ::v15(){vfunc_called(this, "_ZN7S3621C13v15Ev");}
void  S3621C1 ::v16(){vfunc_called(this, "_ZN7S3621C13v16Ev");}
void  S3621C1 ::v17(){vfunc_called(this, "_ZN7S3621C13v17Ev");}
void  S3621C1 ::v18(){vfunc_called(this, "_ZN7S3621C13v18Ev");}
void  S3621C1 ::v19(){vfunc_called(this, "_ZN7S3621C13v19Ev");}
void  S3621C1 ::v20(){vfunc_called(this, "_ZN7S3621C13v20Ev");}
void  S3621C1 ::v21(){vfunc_called(this, "_ZN7S3621C13v21Ev");}
void  S3621C1 ::v22(){vfunc_called(this, "_ZN7S3621C13v22Ev");}
void  S3621C1 ::v23(){vfunc_called(this, "_ZN7S3621C13v23Ev");}
void  S3621C1 ::v24(){vfunc_called(this, "_ZN7S3621C13v24Ev");}
void  S3621C1 ::v25(){vfunc_called(this, "_ZN7S3621C13v25Ev");}
void  S3621C1 ::v26(){vfunc_called(this, "_ZN7S3621C13v26Ev");}
void  S3621C1 ::v27(){vfunc_called(this, "_ZN7S3621C13v27Ev");}
void  S3621C1 ::v28(){vfunc_called(this, "_ZN7S3621C13v28Ev");}
void  S3621C1 ::v29(){vfunc_called(this, "_ZN7S3621C13v29Ev");}
void  S3621C1 ::v30(){vfunc_called(this, "_ZN7S3621C13v30Ev");}
void  S3621C1 ::v31(){vfunc_called(this, "_ZN7S3621C13v31Ev");}
void  S3621C1 ::v32(){vfunc_called(this, "_ZN7S3621C13v32Ev");}
void  S3621C1 ::v33(){vfunc_called(this, "_ZN7S3621C13v33Ev");}
void  S3621C1 ::v34(){vfunc_called(this, "_ZN7S3621C13v34Ev");}
void  S3621C1 ::v35(){vfunc_called(this, "_ZN7S3621C13v35Ev");}
void  S3621C1 ::v36(){vfunc_called(this, "_ZN7S3621C13v36Ev");}
void  S3621C1 ::v37(){vfunc_called(this, "_ZN7S3621C13v37Ev");}
void  S3621C1 ::v38(){vfunc_called(this, "_ZN7S3621C13v38Ev");}
void  S3621C1 ::v39(){vfunc_called(this, "_ZN7S3621C13v39Ev");}
void  S3621C1 ::v40(){vfunc_called(this, "_ZN7S3621C13v40Ev");}
void  S3621C1 ::v41(){vfunc_called(this, "_ZN7S3621C13v41Ev");}
void  S3621C1 ::v42(){vfunc_called(this, "_ZN7S3621C13v42Ev");}
void  S3621C1 ::v43(){vfunc_called(this, "_ZN7S3621C13v43Ev");}
void  S3621C1 ::v44(){vfunc_called(this, "_ZN7S3621C13v44Ev");}
void  S3621C1 ::v45(){vfunc_called(this, "_ZN7S3621C13v45Ev");}
void  S3621C1 ::v46(){vfunc_called(this, "_ZN7S3621C13v46Ev");}
void  S3621C1 ::v47(){vfunc_called(this, "_ZN7S3621C13v47Ev");}
void  S3621C1 ::v48(){vfunc_called(this, "_ZN7S3621C13v48Ev");}
S3621C1 ::S3621C1(){ note_ctor("S3621C1", this);} // tgen

static void Test_S3621C1()
{
  extern Class_Descriptor cd_S3621C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(990,1878)];
    init_test(&cd_S3621C1, buf);
    S3621C1 *dp, &lv = *(dp=new (buf) S3621C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(7912,7508), "sizeof(S3621C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3621C1)");
    check_base_class_offset(lv, (S3624C3_nt*)(S3621C2*), 0, "S3621C1");
    check_base_class_offset(lv, (S3621C2*), 0, "S3621C1");
    check_field_offset(lv, s3621c1f0, ABISELECT(7232,6972), "S3621C1.s3621c1f0");
    check_field_offset(lv, s3621c1f1, ABISELECT(7280,6996), "S3621C1.s3621c1f1");
    check_field_offset(lv, s3621c1f2, ABISELECT(7288,7000), "S3621C1.s3621c1f2");
    check_field_offset(lv, s3621c1f3, ABISELECT(7320,7016), "S3621C1.s3621c1f3");
    check_field_offset(lv, s3621c1f4, ABISELECT(7328,7020), "S3621C1.s3621c1f4");
    check_field_offset(lv, s3621c1f5, ABISELECT(7392,7068), "S3621C1.s3621c1f5");
    check_field_offset(lv, s3621c1f6, ABISELECT(7424,7100), "S3621C1.s3621c1f6");
    check_field_offset(lv, s3621c1f7, ABISELECT(7744,7388), "S3621C1.s3621c1f7");
    check_field_offset(lv, s3621c1f8, ABISELECT(7808,7436), "S3621C1.s3621c1f8");
    check_field_offset(lv, s3621c1f9, ABISELECT(7816,7440), "S3621C1.s3621c1f9");
    check_field_offset(lv, s3621c1f10, ABISELECT(7832,7448), "S3621C1.s3621c1f10");
    check_field_offset(lv, s3621c1f11, ABISELECT(7836,7452), "S3621C1.s3621c1f11");
    check_field_offset(lv, s3621c1f12, ABISELECT(7840,7456), "S3621C1.s3621c1f12");
    check_field_offset(lv, s3621c1f13, ABISELECT(7848,7460), "S3621C1.s3621c1f13");
    check_field_offset(lv, s3621c1f14, ABISELECT(7864,7468), "S3621C1.s3621c1f14");
    check_field_offset(lv, s3621c1f15, ABISELECT(7872,7472), "S3621C1.s3621c1f15");
    check_field_offset(lv, s3621c1f16, ABISELECT(7904,7504), "S3621C1.s3621c1f16");
    test_class_info(&lv, &cd_S3621C1);
    dp->~S3621C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3621C1(Test_S3621C1, "S3621C1", ABISELECT(7912,7508));

#else // __cplusplus

extern void _ZN7S3621C1C1Ev();
extern void _ZN7S3621C1D1Ev();
Name_Map name_map_S3621C1[] = {
  NSPAIR(_ZN7S3621C1C1Ev),
  NSPAIR(_ZN7S3621C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3624C3_nt;
extern VTBL_ENTRY _ZTI10S3624C3_nt[];
extern  VTBL_ENTRY _ZTV10S3624C3_nt[];
extern Class_Descriptor cd_S3621C2;
extern VTBL_ENTRY _ZTI7S3621C2[];
extern  VTBL_ENTRY _ZTV7S3621C2[];
static Base_Class bases_S3621C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3624C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3621C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3621C1[];
extern void _ZN7S3621C1D1Ev();
extern void _ZN7S3621C1D0Ev();
extern void _ZN7S3621C23v49Ev();
extern void _ZN7S3621C23v50Ev();
extern void _ZN7S3621C23v51Ev();
extern void _ZN7S3621C23v52Ev();
extern void _ZN7S3621C23v53Ev();
extern void _ZN7S3621C23v54Ev();
extern void _ZN7S3621C23v55Ev();
extern void _ZN7S3621C23v56Ev();
extern void _ZN7S3621C23v57Ev();
extern void _ZN7S3621C23v58Ev();
extern void _ZN7S3621C23v59Ev();
extern void _ZN7S3621C23v60Ev();
extern void _ZN7S3621C23v61Ev();
extern void _ZN7S3621C23v62Ev();
extern void _ZN7S3621C23v63Ev();
extern void _ZN7S3621C23v64Ev();
extern void _ZN7S3621C23v65Ev();
extern void _ZN7S3621C23v66Ev();
extern void _ZN7S3621C23v67Ev();
extern void _ZN7S3621C23v68Ev();
extern void _ZN7S3621C23v69Ev();
extern void _ZN7S3621C23v70Ev();
extern void _ZN7S3621C23v71Ev();
extern void _ZN7S3621C23v72Ev();
extern void _ZN7S3621C23v73Ev();
extern void _ZN7S3621C23v74Ev();
extern void _ZN7S3621C23v75Ev();
extern void _ZN7S3621C23v76Ev();
extern void _ZN7S3621C23v77Ev();
extern void _ZN7S3621C23v78Ev();
extern void _ZN7S3621C23v79Ev();
extern void _ZN7S3621C23v80Ev();
extern void _ZN7S3621C23v81Ev();
extern void _ZN7S3621C23v82Ev();
extern void _ZN7S3621C23v83Ev();
extern void _ZN7S3621C23v84Ev();
extern void _ZN7S3621C23v85Ev();
extern void _ZN7S3621C23v86Ev();
extern void _ZN7S3621C23v87Ev();
extern void _ZN7S3621C23v88Ev();
extern void _ZN7S3621C23v89Ev();
extern void _ZN7S3621C23v90Ev();
extern void _ZN7S3621C23v91Ev();
extern void _ZN7S3621C23v92Ev();
extern void _ZN7S3621C23v93Ev();
extern void _ZN7S3621C23v94Ev();
extern void _ZN7S3621C23v95Ev();
extern void _ZN7S3621C23v96Ev();
extern void _ZN7S3621C23v97Ev();
extern void _ZN7S3621C23v98Ev();
extern void _ZN7S3621C23v99Ev();
extern void _ZN7S3621C24v100Ev();
extern void _ZN7S3621C24v101Ev();
extern void _ZN7S3621C24v102Ev();
extern void _ZN7S3621C24v103Ev();
extern void _ZN7S3621C24v104Ev();
extern void _ZN7S3621C24v105Ev();
extern void _ZN7S3621C24v106Ev();
extern void _ZN7S3621C24v107Ev();
extern void _ZN7S3621C24v108Ev();
extern void _ZN7S3621C24v109Ev();
extern void _ZN7S3621C24v110Ev();
extern void _ZN7S3621C24v111Ev();
extern void _ZN7S3621C24v112Ev();
extern void _ZN7S3621C24v113Ev();
extern void _ZN7S3621C24v114Ev();
extern void _ZN7S3621C24v115Ev();
extern void _ZN7S3621C24v116Ev();
extern void _ZN7S3621C24v117Ev();
extern void _ZN7S3621C24v118Ev();
extern void _ZN7S3621C24v119Ev();
extern void _ZN7S3621C24v120Ev();
extern void _ZN7S3621C24v121Ev();
extern void _ZN7S3621C24v122Ev();
extern void _ZN7S3621C24v123Ev();
extern void _ZN7S3621C24v124Ev();
extern void _ZN7S3621C24v125Ev();
extern void _ZN7S3621C24v126Ev();
extern void _ZN7S3621C24v127Ev();
extern void _ZN7S3621C24v128Ev();
extern void _ZN7S3621C24v129Ev();
extern void _ZN7S3621C24v130Ev();
extern void _ZN7S3621C24v131Ev();
extern void _ZN7S3621C24v132Ev();
extern void _ZN7S3621C24v133Ev();
extern void _ZN7S3621C24v134Ev();
extern void _ZN7S3621C24v135Ev();
extern void _ZN7S3621C24v136Ev();
extern void _ZN7S3621C24v137Ev();
extern void _ZN7S3621C24v138Ev();
extern void _ZN7S3621C24v139Ev();
extern void _ZN7S3621C24v140Ev();
extern void _ZN7S3621C24v141Ev();
extern void _ZN7S3621C24v142Ev();
extern void _ZN7S3621C24v143Ev();
extern void _ZN7S3621C24v144Ev();
extern void _ZN7S3621C24v145Ev();
extern void _ZN7S3621C12v1Ev();
extern void _ZN7S3621C12v2Ev();
extern void _ZN7S3621C12v3Ev();
extern void _ZN7S3621C12v4Ev();
extern void _ZN7S3621C12v5Ev();
extern void _ZN7S3621C12v6Ev();
extern void _ZN7S3621C12v7Ev();
extern void _ZN7S3621C12v8Ev();
extern void _ZN7S3621C12v9Ev();
extern void _ZN7S3621C13v10Ev();
extern void _ZN7S3621C13v11Ev();
extern void _ZN7S3621C13v12Ev();
extern void _ZN7S3621C13v13Ev();
extern void _ZN7S3621C13v14Ev();
extern void _ZN7S3621C13v15Ev();
extern void _ZN7S3621C13v16Ev();
extern void _ZN7S3621C13v17Ev();
extern void _ZN7S3621C13v18Ev();
extern void _ZN7S3621C13v19Ev();
extern void _ZN7S3621C13v20Ev();
extern void _ZN7S3621C13v21Ev();
extern void _ZN7S3621C13v22Ev();
extern void _ZN7S3621C13v23Ev();
extern void _ZN7S3621C13v24Ev();
extern void _ZN7S3621C13v25Ev();
extern void _ZN7S3621C13v26Ev();
extern void _ZN7S3621C13v27Ev();
extern void _ZN7S3621C13v28Ev();
extern void _ZN7S3621C13v29Ev();
extern void _ZN7S3621C13v30Ev();
extern void _ZN7S3621C13v31Ev();
extern void _ZN7S3621C13v32Ev();
extern void _ZN7S3621C13v33Ev();
extern void _ZN7S3621C13v34Ev();
extern void _ZN7S3621C13v35Ev();
extern void _ZN7S3621C13v36Ev();
extern void _ZN7S3621C13v37Ev();
extern void _ZN7S3621C13v38Ev();
extern void _ZN7S3621C13v39Ev();
extern void _ZN7S3621C13v40Ev();
extern void _ZN7S3621C13v41Ev();
extern void _ZN7S3621C13v42Ev();
extern void _ZN7S3621C13v43Ev();
extern void _ZN7S3621C13v44Ev();
extern void _ZN7S3621C13v45Ev();
extern void _ZN7S3621C13v46Ev();
extern void _ZN7S3621C13v47Ev();
extern void _ZN7S3621C13v48Ev();
static  VTBL_ENTRY vtc_S3621C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3621C1[0]),
  (VTBL_ENTRY)&_ZN7S3621C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3621C1D0Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v49Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v50Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v51Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v52Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v53Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v54Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v55Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v56Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v57Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v58Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v59Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v60Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v61Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v62Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v63Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v64Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v65Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v66Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v67Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v68Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v69Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v70Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v71Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v72Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v73Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v74Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v75Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v76Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v77Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v78Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v79Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v80Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v81Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v82Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v83Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v84Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v85Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v86Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v87Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v88Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v89Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v90Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v91Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v92Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v93Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v94Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v95Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v96Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v97Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v98Ev,
  (VTBL_ENTRY)&_ZN7S3621C23v99Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v100Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v101Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v102Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v103Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v104Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v105Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v106Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v107Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v108Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v109Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v110Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v111Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v112Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v113Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v114Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v115Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v116Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v117Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v118Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v119Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v120Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v121Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v122Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v123Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v124Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v125Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v126Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v127Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v128Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v129Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v130Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v131Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v132Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v133Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v134Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v135Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v136Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v137Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v138Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v139Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v140Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v141Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v142Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v143Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v144Ev,
  (VTBL_ENTRY)&_ZN7S3621C24v145Ev,
  (VTBL_ENTRY)&_ZN7S3621C12v1Ev,
  (VTBL_ENTRY)&_ZN7S3621C12v2Ev,
  (VTBL_ENTRY)&_ZN7S3621C12v3Ev,
  (VTBL_ENTRY)&_ZN7S3621C12v4Ev,
  (VTBL_ENTRY)&_ZN7S3621C12v5Ev,
  (VTBL_ENTRY)&_ZN7S3621C12v6Ev,
  (VTBL_ENTRY)&_ZN7S3621C12v7Ev,
  (VTBL_ENTRY)&_ZN7S3621C12v8Ev,
  (VTBL_ENTRY)&_ZN7S3621C12v9Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v10Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v11Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v12Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v13Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v14Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v15Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v16Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v17Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v18Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v19Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v20Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v21Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v22Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v23Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v24Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v25Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v26Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v27Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v28Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v29Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v30Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v31Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v32Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v33Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v34Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v35Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v36Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v37Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v38Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v39Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v40Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v41Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v42Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v43Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v44Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v45Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v46Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v47Ev,
  (VTBL_ENTRY)&_ZN7S3621C13v48Ev,
};
extern VTBL_ENTRY _ZTI7S3621C1[];
extern  VTBL_ENTRY _ZTV7S3621C1[];
Class_Descriptor cd_S3621C1 = {  "S3621C1", // class name
  bases_S3621C1, 2,
  &(vtc_S3621C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(7912,7508), // object size
  NSPAIRA(_ZTI7S3621C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3621C1),149, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S241C7_nt  {
  int s241c7f0[2];
  void  mf241c7(); // _ZN9S241C7_nt7mf241c7Ev
};
//SIG(-1 S241C7_nt) C1{ m Fi[2]}


void  S241C7_nt ::mf241c7(){}

//skip512 S241C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S241C6_nt  {
  int s241c6f0;
  __tsi64 s241c6f1;
  void *s241c6f2[4];
  int s241c6f3[2];
  void *s241c6f4;
  ::S241C7_nt s241c6f5;
  void *s241c6f6[2];
  virtual  ~S241C6_nt(); // _ZN9S241C6_ntD1Ev
  virtual void  v5(); // _ZN9S241C6_nt2v5Ev
  virtual void  v6(); // _ZN9S241C6_nt2v6Ev
  virtual void  v7(); // _ZN9S241C6_nt2v7Ev
  virtual void  v8(); // _ZN9S241C6_nt2v8Ev
  virtual void  v9(); // _ZN9S241C6_nt2v9Ev
  virtual void  v10(); // _ZN9S241C6_nt3v10Ev
  virtual void  v11(); // _ZN9S241C6_nt3v11Ev
  virtual void  v12(); // _ZN9S241C6_nt3v12Ev
  virtual void  v13(); // _ZN9S241C6_nt3v13Ev
  virtual void  v14(); // _ZN9S241C6_nt3v14Ev
  virtual void  v15(); // _ZN9S241C6_nt3v15Ev
  virtual void  v16(); // _ZN9S241C6_nt3v16Ev
  virtual void  v17(); // _ZN9S241C6_nt3v17Ev
  virtual void  v18(); // _ZN9S241C6_nt3v18Ev
  virtual void  v19(); // _ZN9S241C6_nt3v19Ev
  virtual void  v20(); // _ZN9S241C6_nt3v20Ev
  virtual void  v21(); // _ZN9S241C6_nt3v21Ev
  virtual void  v22(); // _ZN9S241C6_nt3v22Ev
  virtual void  v23(); // _ZN9S241C6_nt3v23Ev
  virtual void  v24(); // _ZN9S241C6_nt3v24Ev
  virtual void  v25(); // _ZN9S241C6_nt3v25Ev
  virtual void  v26(); // _ZN9S241C6_nt3v26Ev
  virtual void  v27(); // _ZN9S241C6_nt3v27Ev
  virtual void  v28(); // _ZN9S241C6_nt3v28Ev
  virtual void  v29(); // _ZN9S241C6_nt3v29Ev
  virtual void  v30(); // _ZN9S241C6_nt3v30Ev
  virtual void  v31(); // _ZN9S241C6_nt3v31Ev
  virtual void  v32(); // _ZN9S241C6_nt3v32Ev
  virtual void  v33(); // _ZN9S241C6_nt3v33Ev
  virtual void  v34(); // _ZN9S241C6_nt3v34Ev
  virtual void  v35(); // _ZN9S241C6_nt3v35Ev
  virtual void  v36(); // _ZN9S241C6_nt3v36Ev
  virtual void  v37(); // _ZN9S241C6_nt3v37Ev
  virtual void  v38(); // _ZN9S241C6_nt3v38Ev
  virtual void  v39(); // _ZN9S241C6_nt3v39Ev
  virtual void  v40(); // _ZN9S241C6_nt3v40Ev
  virtual void  v41(); // _ZN9S241C6_nt3v41Ev
  virtual void  v42(); // _ZN9S241C6_nt3v42Ev
  virtual void  v43(); // _ZN9S241C6_nt3v43Ev
  virtual void  v44(); // _ZN9S241C6_nt3v44Ev
  virtual void  v45(); // _ZN9S241C6_nt3v45Ev
  virtual void  v46(); // _ZN9S241C6_nt3v46Ev
  virtual void  v47(); // _ZN9S241C6_nt3v47Ev
  virtual void  v48(); // _ZN9S241C6_nt3v48Ev
  virtual void  v49(); // _ZN9S241C6_nt3v49Ev
  virtual void  v50(); // _ZN9S241C6_nt3v50Ev
  virtual void  v51(); // _ZN9S241C6_nt3v51Ev
  virtual void  v52(); // _ZN9S241C6_nt3v52Ev
  virtual void  v53(); // _ZN9S241C6_nt3v53Ev
  virtual void  v54(); // _ZN9S241C6_nt3v54Ev
  virtual void  v55(); // _ZN9S241C6_nt3v55Ev
  virtual void  v56(); // _ZN9S241C6_nt3v56Ev
  virtual void  v57(); // _ZN9S241C6_nt3v57Ev
  virtual void  v58(); // _ZN9S241C6_nt3v58Ev
  virtual void  v59(); // _ZN9S241C6_nt3v59Ev
  virtual void  v60(); // _ZN9S241C6_nt3v60Ev
  virtual void  v61(); // _ZN9S241C6_nt3v61Ev
  virtual void  v62(); // _ZN9S241C6_nt3v62Ev
  virtual void  v63(); // _ZN9S241C6_nt3v63Ev
  virtual void  v64(); // _ZN9S241C6_nt3v64Ev
  virtual void  v65(); // _ZN9S241C6_nt3v65Ev
  virtual void  v66(); // _ZN9S241C6_nt3v66Ev
  virtual void  v67(); // _ZN9S241C6_nt3v67Ev
  virtual void  v68(); // _ZN9S241C6_nt3v68Ev
  S241C6_nt(); // tgen
};
//SIG(-1 S241C6_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S241C6_nt ::~S241C6_nt(){ note_dtor("S241C6_nt", this);}
void  S241C6_nt ::v5(){vfunc_called(this, "_ZN9S241C6_nt2v5Ev");}
void  S241C6_nt ::v6(){vfunc_called(this, "_ZN9S241C6_nt2v6Ev");}
void  S241C6_nt ::v7(){vfunc_called(this, "_ZN9S241C6_nt2v7Ev");}
void  S241C6_nt ::v8(){vfunc_called(this, "_ZN9S241C6_nt2v8Ev");}
void  S241C6_nt ::v9(){vfunc_called(this, "_ZN9S241C6_nt2v9Ev");}
void  S241C6_nt ::v10(){vfunc_called(this, "_ZN9S241C6_nt3v10Ev");}
void  S241C6_nt ::v11(){vfunc_called(this, "_ZN9S241C6_nt3v11Ev");}
void  S241C6_nt ::v12(){vfunc_called(this, "_ZN9S241C6_nt3v12Ev");}
void  S241C6_nt ::v13(){vfunc_called(this, "_ZN9S241C6_nt3v13Ev");}
void  S241C6_nt ::v14(){vfunc_called(this, "_ZN9S241C6_nt3v14Ev");}
void  S241C6_nt ::v15(){vfunc_called(this, "_ZN9S241C6_nt3v15Ev");}
void  S241C6_nt ::v16(){vfunc_called(this, "_ZN9S241C6_nt3v16Ev");}
void  S241C6_nt ::v17(){vfunc_called(this, "_ZN9S241C6_nt3v17Ev");}
void  S241C6_nt ::v18(){vfunc_called(this, "_ZN9S241C6_nt3v18Ev");}
void  S241C6_nt ::v19(){vfunc_called(this, "_ZN9S241C6_nt3v19Ev");}
void  S241C6_nt ::v20(){vfunc_called(this, "_ZN9S241C6_nt3v20Ev");}
void  S241C6_nt ::v21(){vfunc_called(this, "_ZN9S241C6_nt3v21Ev");}
void  S241C6_nt ::v22(){vfunc_called(this, "_ZN9S241C6_nt3v22Ev");}
void  S241C6_nt ::v23(){vfunc_called(this, "_ZN9S241C6_nt3v23Ev");}
void  S241C6_nt ::v24(){vfunc_called(this, "_ZN9S241C6_nt3v24Ev");}
void  S241C6_nt ::v25(){vfunc_called(this, "_ZN9S241C6_nt3v25Ev");}
void  S241C6_nt ::v26(){vfunc_called(this, "_ZN9S241C6_nt3v26Ev");}
void  S241C6_nt ::v27(){vfunc_called(this, "_ZN9S241C6_nt3v27Ev");}
void  S241C6_nt ::v28(){vfunc_called(this, "_ZN9S241C6_nt3v28Ev");}
void  S241C6_nt ::v29(){vfunc_called(this, "_ZN9S241C6_nt3v29Ev");}
void  S241C6_nt ::v30(){vfunc_called(this, "_ZN9S241C6_nt3v30Ev");}
void  S241C6_nt ::v31(){vfunc_called(this, "_ZN9S241C6_nt3v31Ev");}
void  S241C6_nt ::v32(){vfunc_called(this, "_ZN9S241C6_nt3v32Ev");}
void  S241C6_nt ::v33(){vfunc_called(this, "_ZN9S241C6_nt3v33Ev");}
void  S241C6_nt ::v34(){vfunc_called(this, "_ZN9S241C6_nt3v34Ev");}
void  S241C6_nt ::v35(){vfunc_called(this, "_ZN9S241C6_nt3v35Ev");}
void  S241C6_nt ::v36(){vfunc_called(this, "_ZN9S241C6_nt3v36Ev");}
void  S241C6_nt ::v37(){vfunc_called(this, "_ZN9S241C6_nt3v37Ev");}
void  S241C6_nt ::v38(){vfunc_called(this, "_ZN9S241C6_nt3v38Ev");}
void  S241C6_nt ::v39(){vfunc_called(this, "_ZN9S241C6_nt3v39Ev");}
void  S241C6_nt ::v40(){vfunc_called(this, "_ZN9S241C6_nt3v40Ev");}
void  S241C6_nt ::v41(){vfunc_called(this, "_ZN9S241C6_nt3v41Ev");}
void  S241C6_nt ::v42(){vfunc_called(this, "_ZN9S241C6_nt3v42Ev");}
void  S241C6_nt ::v43(){vfunc_called(this, "_ZN9S241C6_nt3v43Ev");}
void  S241C6_nt ::v44(){vfunc_called(this, "_ZN9S241C6_nt3v44Ev");}
void  S241C6_nt ::v45(){vfunc_called(this, "_ZN9S241C6_nt3v45Ev");}
void  S241C6_nt ::v46(){vfunc_called(this, "_ZN9S241C6_nt3v46Ev");}
void  S241C6_nt ::v47(){vfunc_called(this, "_ZN9S241C6_nt3v47Ev");}
void  S241C6_nt ::v48(){vfunc_called(this, "_ZN9S241C6_nt3v48Ev");}
void  S241C6_nt ::v49(){vfunc_called(this, "_ZN9S241C6_nt3v49Ev");}
void  S241C6_nt ::v50(){vfunc_called(this, "_ZN9S241C6_nt3v50Ev");}
void  S241C6_nt ::v51(){vfunc_called(this, "_ZN9S241C6_nt3v51Ev");}
void  S241C6_nt ::v52(){vfunc_called(this, "_ZN9S241C6_nt3v52Ev");}
void  S241C6_nt ::v53(){vfunc_called(this, "_ZN9S241C6_nt3v53Ev");}
void  S241C6_nt ::v54(){vfunc_called(this, "_ZN9S241C6_nt3v54Ev");}
void  S241C6_nt ::v55(){vfunc_called(this, "_ZN9S241C6_nt3v55Ev");}
void  S241C6_nt ::v56(){vfunc_called(this, "_ZN9S241C6_nt3v56Ev");}
void  S241C6_nt ::v57(){vfunc_called(this, "_ZN9S241C6_nt3v57Ev");}
void  S241C6_nt ::v58(){vfunc_called(this, "_ZN9S241C6_nt3v58Ev");}
void  S241C6_nt ::v59(){vfunc_called(this, "_ZN9S241C6_nt3v59Ev");}
void  S241C6_nt ::v60(){vfunc_called(this, "_ZN9S241C6_nt3v60Ev");}
void  S241C6_nt ::v61(){vfunc_called(this, "_ZN9S241C6_nt3v61Ev");}
void  S241C6_nt ::v62(){vfunc_called(this, "_ZN9S241C6_nt3v62Ev");}
void  S241C6_nt ::v63(){vfunc_called(this, "_ZN9S241C6_nt3v63Ev");}
void  S241C6_nt ::v64(){vfunc_called(this, "_ZN9S241C6_nt3v64Ev");}
void  S241C6_nt ::v65(){vfunc_called(this, "_ZN9S241C6_nt3v65Ev");}
void  S241C6_nt ::v66(){vfunc_called(this, "_ZN9S241C6_nt3v66Ev");}
void  S241C6_nt ::v67(){vfunc_called(this, "_ZN9S241C6_nt3v67Ev");}
void  S241C6_nt ::v68(){vfunc_called(this, "_ZN9S241C6_nt3v68Ev");}
S241C6_nt ::S241C6_nt(){ note_ctor("S241C6_nt", this);} // tgen

//skip512 S241C6_nt

#else // __cplusplus

extern void _ZN9S241C6_ntC1Ev();
extern void _ZN9S241C6_ntD1Ev();
Name_Map name_map_S241C6_nt[] = {
  NSPAIR(_ZN9S241C6_ntC1Ev),
  NSPAIR(_ZN9S241C6_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S241C6_nt[];
extern void _ZN9S241C6_ntD1Ev();
extern void _ZN9S241C6_ntD0Ev();
extern void _ZN9S241C6_nt2v5Ev();
extern void _ZN9S241C6_nt2v6Ev();
extern void _ZN9S241C6_nt2v7Ev();
extern void _ZN9S241C6_nt2v8Ev();
extern void _ZN9S241C6_nt2v9Ev();
extern void _ZN9S241C6_nt3v10Ev();
extern void _ZN9S241C6_nt3v11Ev();
extern void _ZN9S241C6_nt3v12Ev();
extern void _ZN9S241C6_nt3v13Ev();
extern void _ZN9S241C6_nt3v14Ev();
extern void _ZN9S241C6_nt3v15Ev();
extern void _ZN9S241C6_nt3v16Ev();
extern void _ZN9S241C6_nt3v17Ev();
extern void _ZN9S241C6_nt3v18Ev();
extern void _ZN9S241C6_nt3v19Ev();
extern void _ZN9S241C6_nt3v20Ev();
extern void _ZN9S241C6_nt3v21Ev();
extern void _ZN9S241C6_nt3v22Ev();
extern void _ZN9S241C6_nt3v23Ev();
extern void _ZN9S241C6_nt3v24Ev();
extern void _ZN9S241C6_nt3v25Ev();
extern void _ZN9S241C6_nt3v26Ev();
extern void _ZN9S241C6_nt3v27Ev();
extern void _ZN9S241C6_nt3v28Ev();
extern void _ZN9S241C6_nt3v29Ev();
extern void _ZN9S241C6_nt3v30Ev();
extern void _ZN9S241C6_nt3v31Ev();
extern void _ZN9S241C6_nt3v32Ev();
extern void _ZN9S241C6_nt3v33Ev();
extern void _ZN9S241C6_nt3v34Ev();
extern void _ZN9S241C6_nt3v35Ev();
extern void _ZN9S241C6_nt3v36Ev();
extern void _ZN9S241C6_nt3v37Ev();
extern void _ZN9S241C6_nt3v38Ev();
extern void _ZN9S241C6_nt3v39Ev();
extern void _ZN9S241C6_nt3v40Ev();
extern void _ZN9S241C6_nt3v41Ev();
extern void _ZN9S241C6_nt3v42Ev();
extern void _ZN9S241C6_nt3v43Ev();
extern void _ZN9S241C6_nt3v44Ev();
extern void _ZN9S241C6_nt3v45Ev();
extern void _ZN9S241C6_nt3v46Ev();
extern void _ZN9S241C6_nt3v47Ev();
extern void _ZN9S241C6_nt3v48Ev();
extern void _ZN9S241C6_nt3v49Ev();
extern void _ZN9S241C6_nt3v50Ev();
extern void _ZN9S241C6_nt3v51Ev();
extern void _ZN9S241C6_nt3v52Ev();
extern void _ZN9S241C6_nt3v53Ev();
extern void _ZN9S241C6_nt3v54Ev();
extern void _ZN9S241C6_nt3v55Ev();
extern void _ZN9S241C6_nt3v56Ev();
extern void _ZN9S241C6_nt3v57Ev();
extern void _ZN9S241C6_nt3v58Ev();
extern void _ZN9S241C6_nt3v59Ev();
extern void _ZN9S241C6_nt3v60Ev();
extern void _ZN9S241C6_nt3v61Ev();
extern void _ZN9S241C6_nt3v62Ev();
extern void _ZN9S241C6_nt3v63Ev();
extern void _ZN9S241C6_nt3v64Ev();
extern void _ZN9S241C6_nt3v65Ev();
extern void _ZN9S241C6_nt3v66Ev();
extern void _ZN9S241C6_nt3v67Ev();
extern void _ZN9S241C6_nt3v68Ev();
static  VTBL_ENTRY vtc_S241C6_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S241C6_nt[0]),
  (VTBL_ENTRY)&_ZN9S241C6_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S241C6_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v68Ev,
};
extern VTBL_ENTRY _ZTI9S241C6_nt[];
VTBL_ENTRY *P__ZTI9S241C6_nt = _ZTI9S241C6_nt; 
extern  VTBL_ENTRY _ZTV9S241C6_nt[];
Class_Descriptor cd_S241C6_nt = {  "S241C6_nt", // class name
  0,0,//no base classes
  &(vtc_S241C6_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI9S241C6_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S241C6_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S241C11_nt  {
  void *s241c11f0;
  int s241c11f1[2];
  void  mf241c11(); // _ZN10S241C11_nt8mf241c11Ev
};
//SIG(-1 S241C11_nt) C1{ m Fp Fi[2]}


void  S241C11_nt ::mf241c11(){}

//skip512 S241C11_nt

#else // __cplusplus

Class_Descriptor cd_S241C11_nt = {  "S241C11_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S241C10_nt  : S241C11_nt {
};
//SIG(-1 S241C10_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S241C10_nt

#else // __cplusplus

extern Class_Descriptor cd_S241C11_nt;
static Base_Class bases_S241C10_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S241C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S241C10_nt = {  "S241C10_nt", // class name
  bases_S241C10_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S241C9_nt  : S241C10_nt {
};
//SIG(-1 S241C9_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S241C9_nt

#else // __cplusplus

extern Class_Descriptor cd_S241C11_nt;
extern Class_Descriptor cd_S241C10_nt;
static Base_Class bases_S241C9_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S241C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S241C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S241C9_nt = {  "S241C9_nt", // class name
  bases_S241C9_nt, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S241C8_nt  : S241C9_nt {
};
//SIG(-1 S241C8_nt) C1{ BC2{ BC3{ BC4{ m Fp Fi[2]}}}}



//skip512 S241C8_nt

#else // __cplusplus

extern Class_Descriptor cd_S241C11_nt;
extern Class_Descriptor cd_S241C10_nt;
extern Class_Descriptor cd_S241C9_nt;
static Base_Class bases_S241C8_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S241C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S241C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S241C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S241C5_nt  : S241C6_nt {
  int s241c5f0[2];
  void *s241c5f1;
  int s241c5f2[2];
  ::S241C8_nt s241c5f3;
  ::S241C8_nt s241c5f4;
  ::S2005C38 s241c5f5;
  ::S241C8_nt s241c5f6;
  unsigned int s241c5f7:1;
  unsigned int s241c5f8:1;
  unsigned int s241c5f9:1;
  unsigned int s241c5f10:1;
  unsigned int s241c5f11:1;
  int s241c5f12[2];
  virtual  ~S241C5_nt(); // _ZN9S241C5_ntD1Ev
  virtual void  v69(); // _ZN9S241C5_nt3v69Ev
  virtual void  v70(); // _ZN9S241C5_nt3v70Ev
  virtual void  v71(); // _ZN9S241C5_nt3v71Ev
  virtual void  v72(); // _ZN9S241C5_nt3v72Ev
  virtual void  v73(); // _ZN9S241C5_nt3v73Ev
  virtual void  v74(); // _ZN9S241C5_nt3v74Ev
  virtual void  v75(); // _ZN9S241C5_nt3v75Ev
  virtual void  v76(); // _ZN9S241C5_nt3v76Ev
  virtual void  v77(); // _ZN9S241C5_nt3v77Ev
  virtual void  v78(); // _ZN9S241C5_nt3v78Ev
  virtual void  v79(); // _ZN9S241C5_nt3v79Ev
  virtual void  v80(); // _ZN9S241C5_nt3v80Ev
  virtual void  v81(); // _ZN9S241C5_nt3v81Ev
  virtual void  v82(); // _ZN9S241C5_nt3v82Ev
  virtual void  v83(); // _ZN9S241C5_nt3v83Ev
  virtual void  v84(); // _ZN9S241C5_nt3v84Ev
  virtual void  v85(); // _ZN9S241C5_nt3v85Ev
  virtual void  v86(); // _ZN9S241C5_nt3v86Ev
  virtual void  v87(); // _ZN9S241C5_nt3v87Ev
  virtual void  v88(); // _ZN9S241C5_nt3v88Ev
  virtual void  v89(); // _ZN9S241C5_nt3v89Ev
  virtual void  v90(); // _ZN9S241C5_nt3v90Ev
  S241C5_nt(); // tgen
};
//SIG(-1 S241C5_nt) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S241C5_nt ::~S241C5_nt(){ note_dtor("S241C5_nt", this);}
void  S241C5_nt ::v69(){vfunc_called(this, "_ZN9S241C5_nt3v69Ev");}
void  S241C5_nt ::v70(){vfunc_called(this, "_ZN9S241C5_nt3v70Ev");}
void  S241C5_nt ::v71(){vfunc_called(this, "_ZN9S241C5_nt3v71Ev");}
void  S241C5_nt ::v72(){vfunc_called(this, "_ZN9S241C5_nt3v72Ev");}
void  S241C5_nt ::v73(){vfunc_called(this, "_ZN9S241C5_nt3v73Ev");}
void  S241C5_nt ::v74(){vfunc_called(this, "_ZN9S241C5_nt3v74Ev");}
void  S241C5_nt ::v75(){vfunc_called(this, "_ZN9S241C5_nt3v75Ev");}
void  S241C5_nt ::v76(){vfunc_called(this, "_ZN9S241C5_nt3v76Ev");}
void  S241C5_nt ::v77(){vfunc_called(this, "_ZN9S241C5_nt3v77Ev");}
void  S241C5_nt ::v78(){vfunc_called(this, "_ZN9S241C5_nt3v78Ev");}
void  S241C5_nt ::v79(){vfunc_called(this, "_ZN9S241C5_nt3v79Ev");}
void  S241C5_nt ::v80(){vfunc_called(this, "_ZN9S241C5_nt3v80Ev");}
void  S241C5_nt ::v81(){vfunc_called(this, "_ZN9S241C5_nt3v81Ev");}
void  S241C5_nt ::v82(){vfunc_called(this, "_ZN9S241C5_nt3v82Ev");}
void  S241C5_nt ::v83(){vfunc_called(this, "_ZN9S241C5_nt3v83Ev");}
void  S241C5_nt ::v84(){vfunc_called(this, "_ZN9S241C5_nt3v84Ev");}
void  S241C5_nt ::v85(){vfunc_called(this, "_ZN9S241C5_nt3v85Ev");}
void  S241C5_nt ::v86(){vfunc_called(this, "_ZN9S241C5_nt3v86Ev");}
void  S241C5_nt ::v87(){vfunc_called(this, "_ZN9S241C5_nt3v87Ev");}
void  S241C5_nt ::v88(){vfunc_called(this, "_ZN9S241C5_nt3v88Ev");}
void  S241C5_nt ::v89(){vfunc_called(this, "_ZN9S241C5_nt3v89Ev");}
void  S241C5_nt ::v90(){vfunc_called(this, "_ZN9S241C5_nt3v90Ev");}
S241C5_nt ::S241C5_nt(){ note_ctor("S241C5_nt", this);} // tgen

//skip512 S241C5_nt

#else // __cplusplus

extern void _ZN9S241C5_ntC1Ev();
extern void _ZN9S241C5_ntD1Ev();
Name_Map name_map_S241C5_nt[] = {
  NSPAIR(_ZN9S241C5_ntC1Ev),
  NSPAIR(_ZN9S241C5_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S241C6_nt;
extern VTBL_ENTRY _ZTI9S241C6_nt[];
extern  VTBL_ENTRY _ZTV9S241C6_nt[];
static Base_Class bases_S241C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S241C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S241C5_nt[];
extern void _ZN9S241C5_ntD1Ev();
extern void _ZN9S241C5_ntD0Ev();
extern void _ZN9S241C6_nt2v5Ev();
extern void _ZN9S241C6_nt2v6Ev();
extern void _ZN9S241C6_nt2v7Ev();
extern void _ZN9S241C6_nt2v8Ev();
extern void _ZN9S241C6_nt2v9Ev();
extern void _ZN9S241C6_nt3v10Ev();
extern void _ZN9S241C6_nt3v11Ev();
extern void _ZN9S241C6_nt3v12Ev();
extern void _ZN9S241C6_nt3v13Ev();
extern void _ZN9S241C6_nt3v14Ev();
extern void _ZN9S241C6_nt3v15Ev();
extern void _ZN9S241C6_nt3v16Ev();
extern void _ZN9S241C6_nt3v17Ev();
extern void _ZN9S241C6_nt3v18Ev();
extern void _ZN9S241C6_nt3v19Ev();
extern void _ZN9S241C6_nt3v20Ev();
extern void _ZN9S241C6_nt3v21Ev();
extern void _ZN9S241C6_nt3v22Ev();
extern void _ZN9S241C6_nt3v23Ev();
extern void _ZN9S241C6_nt3v24Ev();
extern void _ZN9S241C6_nt3v25Ev();
extern void _ZN9S241C6_nt3v26Ev();
extern void _ZN9S241C6_nt3v27Ev();
extern void _ZN9S241C6_nt3v28Ev();
extern void _ZN9S241C6_nt3v29Ev();
extern void _ZN9S241C6_nt3v30Ev();
extern void _ZN9S241C6_nt3v31Ev();
extern void _ZN9S241C6_nt3v32Ev();
extern void _ZN9S241C6_nt3v33Ev();
extern void _ZN9S241C6_nt3v34Ev();
extern void _ZN9S241C6_nt3v35Ev();
extern void _ZN9S241C6_nt3v36Ev();
extern void _ZN9S241C6_nt3v37Ev();
extern void _ZN9S241C6_nt3v38Ev();
extern void _ZN9S241C6_nt3v39Ev();
extern void _ZN9S241C6_nt3v40Ev();
extern void _ZN9S241C6_nt3v41Ev();
extern void _ZN9S241C6_nt3v42Ev();
extern void _ZN9S241C6_nt3v43Ev();
extern void _ZN9S241C6_nt3v44Ev();
extern void _ZN9S241C6_nt3v45Ev();
extern void _ZN9S241C6_nt3v46Ev();
extern void _ZN9S241C6_nt3v47Ev();
extern void _ZN9S241C6_nt3v48Ev();
extern void _ZN9S241C6_nt3v49Ev();
extern void _ZN9S241C6_nt3v50Ev();
extern void _ZN9S241C6_nt3v51Ev();
extern void _ZN9S241C6_nt3v52Ev();
extern void _ZN9S241C6_nt3v53Ev();
extern void _ZN9S241C6_nt3v54Ev();
extern void _ZN9S241C6_nt3v55Ev();
extern void _ZN9S241C6_nt3v56Ev();
extern void _ZN9S241C6_nt3v57Ev();
extern void _ZN9S241C6_nt3v58Ev();
extern void _ZN9S241C6_nt3v59Ev();
extern void _ZN9S241C6_nt3v60Ev();
extern void _ZN9S241C6_nt3v61Ev();
extern void _ZN9S241C6_nt3v62Ev();
extern void _ZN9S241C6_nt3v63Ev();
extern void _ZN9S241C6_nt3v64Ev();
extern void _ZN9S241C6_nt3v65Ev();
extern void _ZN9S241C6_nt3v66Ev();
extern void _ZN9S241C6_nt3v67Ev();
extern void _ZN9S241C6_nt3v68Ev();
extern void _ZN9S241C5_nt3v69Ev();
extern void _ZN9S241C5_nt3v70Ev();
extern void _ZN9S241C5_nt3v71Ev();
extern void _ZN9S241C5_nt3v72Ev();
extern void _ZN9S241C5_nt3v73Ev();
extern void _ZN9S241C5_nt3v74Ev();
extern void _ZN9S241C5_nt3v75Ev();
extern void _ZN9S241C5_nt3v76Ev();
extern void _ZN9S241C5_nt3v77Ev();
extern void _ZN9S241C5_nt3v78Ev();
extern void _ZN9S241C5_nt3v79Ev();
extern void _ZN9S241C5_nt3v80Ev();
extern void _ZN9S241C5_nt3v81Ev();
extern void _ZN9S241C5_nt3v82Ev();
extern void _ZN9S241C5_nt3v83Ev();
extern void _ZN9S241C5_nt3v84Ev();
extern void _ZN9S241C5_nt3v85Ev();
extern void _ZN9S241C5_nt3v86Ev();
extern void _ZN9S241C5_nt3v87Ev();
extern void _ZN9S241C5_nt3v88Ev();
extern void _ZN9S241C5_nt3v89Ev();
extern void _ZN9S241C5_nt3v90Ev();
static  VTBL_ENTRY vtc_S241C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S241C5_nt[0]),
  (VTBL_ENTRY)&_ZN9S241C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S241C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v90Ev,
};
extern VTBL_ENTRY _ZTI9S241C5_nt[];
VTBL_ENTRY *P__ZTI9S241C5_nt = _ZTI9S241C5_nt; 
extern  VTBL_ENTRY _ZTV9S241C5_nt[];
Class_Descriptor cd_S241C5_nt = {  "S241C5_nt", // class name
  bases_S241C5_nt, 1,
  &(vtc_S241C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI9S241C5_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S241C5_nt),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S241C14  : S241C11_nt {
};
//SIG(-1 S241C14) C1{ BC2{ m Fp Fi[2]}}



static void Test_S241C14()
{
  extern Class_Descriptor cd_S241C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S241C14, buf);
    S241C14 &lv = *(new (buf) S241C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S241C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S241C14)");
    check_base_class_offset(lv, (S241C11_nt*), 0, "S241C14");
    test_class_info(&lv, &cd_S241C14);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS241C14(Test_S241C14, "S241C14", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S241C11_nt;
static Base_Class bases_S241C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S241C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S241C14 = {  "S241C14", // class name
  bases_S241C14, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S241C13  : S241C14 {
};
//SIG(-1 S241C13) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S241C13()
{
  extern Class_Descriptor cd_S241C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S241C13, buf);
    S241C13 &lv = *(new (buf) S241C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S241C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S241C13)");
    check_base_class_offset(lv, (S241C11_nt*)(S241C14*), 0, "S241C13");
    check_base_class_offset(lv, (S241C14*), 0, "S241C13");
    test_class_info(&lv, &cd_S241C13);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS241C13(Test_S241C13, "S241C13", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S241C11_nt;
extern Class_Descriptor cd_S241C14;
static Base_Class bases_S241C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S241C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S241C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S241C13 = {  "S241C13", // class name
  bases_S241C13, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S241C18  : S241C11_nt {
};
//SIG(-1 S241C18) C1{ BC2{ m Fp Fi[2]}}



static void Test_S241C18()
{
  extern Class_Descriptor cd_S241C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S241C18, buf);
    S241C18 &lv = *(new (buf) S241C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S241C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S241C18)");
    check_base_class_offset(lv, (S241C11_nt*), 0, "S241C18");
    test_class_info(&lv, &cd_S241C18);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS241C18(Test_S241C18, "S241C18", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S241C11_nt;
static Base_Class bases_S241C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S241C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S241C18 = {  "S241C18", // class name
  bases_S241C18, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S241C17  : S241C18 {
};
//SIG(-1 S241C17) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S241C17()
{
  extern Class_Descriptor cd_S241C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S241C17, buf);
    S241C17 &lv = *(new (buf) S241C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S241C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S241C17)");
    check_base_class_offset(lv, (S241C11_nt*)(S241C18*), 0, "S241C17");
    check_base_class_offset(lv, (S241C18*), 0, "S241C17");
    test_class_info(&lv, &cd_S241C17);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS241C17(Test_S241C17, "S241C17", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S241C11_nt;
extern Class_Descriptor cd_S241C18;
static Base_Class bases_S241C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S241C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S241C18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S241C17 = {  "S241C17", // class name
  bases_S241C17, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S241C4_nt  : S241C5_nt {
  unsigned int s241c4f0:1;
  unsigned int s241c4f1:1;
  unsigned int s241c4f2:1;
  ::S241C13 s241c4f3;
  ::S241C13 s241c4f4;
  ::S241C17 s241c4f5;
  ::S241C17 s241c4f6;
  int s241c4f7[3];
  virtual  ~S241C4_nt(); // _ZN9S241C4_ntD1Ev
  virtual void  v91(); // _ZN9S241C4_nt3v91Ev
  virtual void  v92(); // _ZN9S241C4_nt3v92Ev
  virtual void  v93(); // _ZN9S241C4_nt3v93Ev
  virtual void  v94(); // _ZN9S241C4_nt3v94Ev
  virtual void  v95(); // _ZN9S241C4_nt3v95Ev
  virtual void  v96(); // _ZN9S241C4_nt3v96Ev
  virtual void  v97(); // _ZN9S241C4_nt3v97Ev
  virtual void  v98(); // _ZN9S241C4_nt3v98Ev
  virtual void  v99(); // _ZN9S241C4_nt3v99Ev
  virtual void  v100(); // _ZN9S241C4_nt4v100Ev
  virtual void  v101(); // _ZN9S241C4_nt4v101Ev
  virtual void  v102(); // _ZN9S241C4_nt4v102Ev
  virtual void  v103(); // _ZN9S241C4_nt4v103Ev
  virtual void  v104(); // _ZN9S241C4_nt4v104Ev
  virtual void  v105(); // _ZN9S241C4_nt4v105Ev
  virtual void  v106(); // _ZN9S241C4_nt4v106Ev
  virtual void  v107(); // _ZN9S241C4_nt4v107Ev
  virtual void  v108(); // _ZN9S241C4_nt4v108Ev
  virtual void  v109(); // _ZN9S241C4_nt4v109Ev
  virtual void  v110(); // _ZN9S241C4_nt4v110Ev
  S241C4_nt(); // tgen
};
//SIG(-1 S241C4_nt) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC10 FC12{ BC13{ BC8}} FC12 Fi[3]}


 S241C4_nt ::~S241C4_nt(){ note_dtor("S241C4_nt", this);}
void  S241C4_nt ::v91(){vfunc_called(this, "_ZN9S241C4_nt3v91Ev");}
void  S241C4_nt ::v92(){vfunc_called(this, "_ZN9S241C4_nt3v92Ev");}
void  S241C4_nt ::v93(){vfunc_called(this, "_ZN9S241C4_nt3v93Ev");}
void  S241C4_nt ::v94(){vfunc_called(this, "_ZN9S241C4_nt3v94Ev");}
void  S241C4_nt ::v95(){vfunc_called(this, "_ZN9S241C4_nt3v95Ev");}
void  S241C4_nt ::v96(){vfunc_called(this, "_ZN9S241C4_nt3v96Ev");}
void  S241C4_nt ::v97(){vfunc_called(this, "_ZN9S241C4_nt3v97Ev");}
void  S241C4_nt ::v98(){vfunc_called(this, "_ZN9S241C4_nt3v98Ev");}
void  S241C4_nt ::v99(){vfunc_called(this, "_ZN9S241C4_nt3v99Ev");}
void  S241C4_nt ::v100(){vfunc_called(this, "_ZN9S241C4_nt4v100Ev");}
void  S241C4_nt ::v101(){vfunc_called(this, "_ZN9S241C4_nt4v101Ev");}
void  S241C4_nt ::v102(){vfunc_called(this, "_ZN9S241C4_nt4v102Ev");}
void  S241C4_nt ::v103(){vfunc_called(this, "_ZN9S241C4_nt4v103Ev");}
void  S241C4_nt ::v104(){vfunc_called(this, "_ZN9S241C4_nt4v104Ev");}
void  S241C4_nt ::v105(){vfunc_called(this, "_ZN9S241C4_nt4v105Ev");}
void  S241C4_nt ::v106(){vfunc_called(this, "_ZN9S241C4_nt4v106Ev");}
void  S241C4_nt ::v107(){vfunc_called(this, "_ZN9S241C4_nt4v107Ev");}
void  S241C4_nt ::v108(){vfunc_called(this, "_ZN9S241C4_nt4v108Ev");}
void  S241C4_nt ::v109(){vfunc_called(this, "_ZN9S241C4_nt4v109Ev");}
void  S241C4_nt ::v110(){vfunc_called(this, "_ZN9S241C4_nt4v110Ev");}
S241C4_nt ::S241C4_nt(){ note_ctor("S241C4_nt", this);} // tgen

//skip512 S241C4_nt

#else // __cplusplus

extern void _ZN9S241C4_ntC1Ev();
extern void _ZN9S241C4_ntD1Ev();
Name_Map name_map_S241C4_nt[] = {
  NSPAIR(_ZN9S241C4_ntC1Ev),
  NSPAIR(_ZN9S241C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S241C6_nt;
extern VTBL_ENTRY _ZTI9S241C6_nt[];
extern  VTBL_ENTRY _ZTV9S241C6_nt[];
extern Class_Descriptor cd_S241C5_nt;
extern VTBL_ENTRY _ZTI9S241C5_nt[];
extern  VTBL_ENTRY _ZTV9S241C5_nt[];
static Base_Class bases_S241C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S241C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S241C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S241C4_nt[];
extern void _ZN9S241C4_ntD1Ev();
extern void _ZN9S241C4_ntD0Ev();
extern void _ZN9S241C6_nt2v5Ev();
extern void _ZN9S241C6_nt2v6Ev();
extern void _ZN9S241C6_nt2v7Ev();
extern void _ZN9S241C6_nt2v8Ev();
extern void _ZN9S241C6_nt2v9Ev();
extern void _ZN9S241C6_nt3v10Ev();
extern void _ZN9S241C6_nt3v11Ev();
extern void _ZN9S241C6_nt3v12Ev();
extern void _ZN9S241C6_nt3v13Ev();
extern void _ZN9S241C6_nt3v14Ev();
extern void _ZN9S241C6_nt3v15Ev();
extern void _ZN9S241C6_nt3v16Ev();
extern void _ZN9S241C6_nt3v17Ev();
extern void _ZN9S241C6_nt3v18Ev();
extern void _ZN9S241C6_nt3v19Ev();
extern void _ZN9S241C6_nt3v20Ev();
extern void _ZN9S241C6_nt3v21Ev();
extern void _ZN9S241C6_nt3v22Ev();
extern void _ZN9S241C6_nt3v23Ev();
extern void _ZN9S241C6_nt3v24Ev();
extern void _ZN9S241C6_nt3v25Ev();
extern void _ZN9S241C6_nt3v26Ev();
extern void _ZN9S241C6_nt3v27Ev();
extern void _ZN9S241C6_nt3v28Ev();
extern void _ZN9S241C6_nt3v29Ev();
extern void _ZN9S241C6_nt3v30Ev();
extern void _ZN9S241C6_nt3v31Ev();
extern void _ZN9S241C6_nt3v32Ev();
extern void _ZN9S241C6_nt3v33Ev();
extern void _ZN9S241C6_nt3v34Ev();
extern void _ZN9S241C6_nt3v35Ev();
extern void _ZN9S241C6_nt3v36Ev();
extern void _ZN9S241C6_nt3v37Ev();
extern void _ZN9S241C6_nt3v38Ev();
extern void _ZN9S241C6_nt3v39Ev();
extern void _ZN9S241C6_nt3v40Ev();
extern void _ZN9S241C6_nt3v41Ev();
extern void _ZN9S241C6_nt3v42Ev();
extern void _ZN9S241C6_nt3v43Ev();
extern void _ZN9S241C6_nt3v44Ev();
extern void _ZN9S241C6_nt3v45Ev();
extern void _ZN9S241C6_nt3v46Ev();
extern void _ZN9S241C6_nt3v47Ev();
extern void _ZN9S241C6_nt3v48Ev();
extern void _ZN9S241C6_nt3v49Ev();
extern void _ZN9S241C6_nt3v50Ev();
extern void _ZN9S241C6_nt3v51Ev();
extern void _ZN9S241C6_nt3v52Ev();
extern void _ZN9S241C6_nt3v53Ev();
extern void _ZN9S241C6_nt3v54Ev();
extern void _ZN9S241C6_nt3v55Ev();
extern void _ZN9S241C6_nt3v56Ev();
extern void _ZN9S241C6_nt3v57Ev();
extern void _ZN9S241C6_nt3v58Ev();
extern void _ZN9S241C6_nt3v59Ev();
extern void _ZN9S241C6_nt3v60Ev();
extern void _ZN9S241C6_nt3v61Ev();
extern void _ZN9S241C6_nt3v62Ev();
extern void _ZN9S241C6_nt3v63Ev();
extern void _ZN9S241C6_nt3v64Ev();
extern void _ZN9S241C6_nt3v65Ev();
extern void _ZN9S241C6_nt3v66Ev();
extern void _ZN9S241C6_nt3v67Ev();
extern void _ZN9S241C6_nt3v68Ev();
extern void _ZN9S241C5_nt3v69Ev();
extern void _ZN9S241C5_nt3v70Ev();
extern void _ZN9S241C5_nt3v71Ev();
extern void _ZN9S241C5_nt3v72Ev();
extern void _ZN9S241C5_nt3v73Ev();
extern void _ZN9S241C5_nt3v74Ev();
extern void _ZN9S241C5_nt3v75Ev();
extern void _ZN9S241C5_nt3v76Ev();
extern void _ZN9S241C5_nt3v77Ev();
extern void _ZN9S241C5_nt3v78Ev();
extern void _ZN9S241C5_nt3v79Ev();
extern void _ZN9S241C5_nt3v80Ev();
extern void _ZN9S241C5_nt3v81Ev();
extern void _ZN9S241C5_nt3v82Ev();
extern void _ZN9S241C5_nt3v83Ev();
extern void _ZN9S241C5_nt3v84Ev();
extern void _ZN9S241C5_nt3v85Ev();
extern void _ZN9S241C5_nt3v86Ev();
extern void _ZN9S241C5_nt3v87Ev();
extern void _ZN9S241C5_nt3v88Ev();
extern void _ZN9S241C5_nt3v89Ev();
extern void _ZN9S241C5_nt3v90Ev();
extern void _ZN9S241C4_nt3v91Ev();
extern void _ZN9S241C4_nt3v92Ev();
extern void _ZN9S241C4_nt3v93Ev();
extern void _ZN9S241C4_nt3v94Ev();
extern void _ZN9S241C4_nt3v95Ev();
extern void _ZN9S241C4_nt3v96Ev();
extern void _ZN9S241C4_nt3v97Ev();
extern void _ZN9S241C4_nt3v98Ev();
extern void _ZN9S241C4_nt3v99Ev();
extern void _ZN9S241C4_nt4v100Ev();
extern void _ZN9S241C4_nt4v101Ev();
extern void _ZN9S241C4_nt4v102Ev();
extern void _ZN9S241C4_nt4v103Ev();
extern void _ZN9S241C4_nt4v104Ev();
extern void _ZN9S241C4_nt4v105Ev();
extern void _ZN9S241C4_nt4v106Ev();
extern void _ZN9S241C4_nt4v107Ev();
extern void _ZN9S241C4_nt4v108Ev();
extern void _ZN9S241C4_nt4v109Ev();
extern void _ZN9S241C4_nt4v110Ev();
static  VTBL_ENTRY vtc_S241C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S241C4_nt[0]),
  (VTBL_ENTRY)&_ZN9S241C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S241C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v110Ev,
};
extern VTBL_ENTRY _ZTI9S241C4_nt[];
VTBL_ENTRY *P__ZTI9S241C4_nt = _ZTI9S241C4_nt; 
extern  VTBL_ENTRY _ZTV9S241C4_nt[];
Class_Descriptor cd_S241C4_nt = {  "S241C4_nt", // class name
  bases_S241C4_nt, 2,
  &(vtc_S241C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI9S241C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S241C4_nt),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S241C22  : S241C11_nt {
};
//SIG(-1 S241C22) C1{ BC2{ m Fp Fi[2]}}



static void Test_S241C22()
{
  extern Class_Descriptor cd_S241C22;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S241C22, buf);
    S241C22 &lv = *(new (buf) S241C22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S241C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S241C22)");
    check_base_class_offset(lv, (S241C11_nt*), 0, "S241C22");
    test_class_info(&lv, &cd_S241C22);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS241C22(Test_S241C22, "S241C22", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S241C11_nt;
static Base_Class bases_S241C22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S241C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S241C22 = {  "S241C22", // class name
  bases_S241C22, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S241C21  : S241C22 {
};
//SIG(-1 S241C21) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S241C21()
{
  extern Class_Descriptor cd_S241C21;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S241C21, buf);
    S241C21 &lv = *(new (buf) S241C21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S241C21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S241C21)");
    check_base_class_offset(lv, (S241C11_nt*)(S241C22*), 0, "S241C21");
    check_base_class_offset(lv, (S241C22*), 0, "S241C21");
    test_class_info(&lv, &cd_S241C21);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS241C21(Test_S241C21, "S241C21", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S241C11_nt;
extern Class_Descriptor cd_S241C22;
static Base_Class bases_S241C21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S241C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S241C22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S241C21 = {  "S241C21", // class name
  bases_S241C21, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S241C3_nt  : S241C4_nt {
  ::S241C7_nt s241c3f0;
  unsigned int s241c3f1:1;
  ::S241C21 s241c3f2;
  virtual  ~S241C3_nt(); // _ZN9S241C3_ntD1Ev
  virtual void  v111(); // _ZN9S241C3_nt4v111Ev
  virtual void  v112(); // _ZN9S241C3_nt4v112Ev
  virtual void  v113(); // _ZN9S241C3_nt4v113Ev
  virtual void  v114(); // _ZN9S241C3_nt4v114Ev
  S241C3_nt(); // tgen
};
//SIG(-1 S241C3_nt) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC11 FC13{ BC14{ BC9}} FC13 Fi[3]} vd v1 v2 v3 v4 FC5 Fi:1 FC15{ BC16{ BC9}}}


 S241C3_nt ::~S241C3_nt(){ note_dtor("S241C3_nt", this);}
void  S241C3_nt ::v111(){vfunc_called(this, "_ZN9S241C3_nt4v111Ev");}
void  S241C3_nt ::v112(){vfunc_called(this, "_ZN9S241C3_nt4v112Ev");}
void  S241C3_nt ::v113(){vfunc_called(this, "_ZN9S241C3_nt4v113Ev");}
void  S241C3_nt ::v114(){vfunc_called(this, "_ZN9S241C3_nt4v114Ev");}
S241C3_nt ::S241C3_nt(){ note_ctor("S241C3_nt", this);} // tgen

//skip512 S241C3_nt

#else // __cplusplus

extern void _ZN9S241C3_ntC1Ev();
extern void _ZN9S241C3_ntD1Ev();
Name_Map name_map_S241C3_nt[] = {
  NSPAIR(_ZN9S241C3_ntC1Ev),
  NSPAIR(_ZN9S241C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S241C6_nt;
extern VTBL_ENTRY _ZTI9S241C6_nt[];
extern  VTBL_ENTRY _ZTV9S241C6_nt[];
extern Class_Descriptor cd_S241C5_nt;
extern VTBL_ENTRY _ZTI9S241C5_nt[];
extern  VTBL_ENTRY _ZTV9S241C5_nt[];
extern Class_Descriptor cd_S241C4_nt;
extern VTBL_ENTRY _ZTI9S241C4_nt[];
extern  VTBL_ENTRY _ZTV9S241C4_nt[];
static Base_Class bases_S241C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S241C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S241C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S241C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S241C3_nt[];
extern void _ZN9S241C3_ntD1Ev();
extern void _ZN9S241C3_ntD0Ev();
extern void _ZN9S241C6_nt2v5Ev();
extern void _ZN9S241C6_nt2v6Ev();
extern void _ZN9S241C6_nt2v7Ev();
extern void _ZN9S241C6_nt2v8Ev();
extern void _ZN9S241C6_nt2v9Ev();
extern void _ZN9S241C6_nt3v10Ev();
extern void _ZN9S241C6_nt3v11Ev();
extern void _ZN9S241C6_nt3v12Ev();
extern void _ZN9S241C6_nt3v13Ev();
extern void _ZN9S241C6_nt3v14Ev();
extern void _ZN9S241C6_nt3v15Ev();
extern void _ZN9S241C6_nt3v16Ev();
extern void _ZN9S241C6_nt3v17Ev();
extern void _ZN9S241C6_nt3v18Ev();
extern void _ZN9S241C6_nt3v19Ev();
extern void _ZN9S241C6_nt3v20Ev();
extern void _ZN9S241C6_nt3v21Ev();
extern void _ZN9S241C6_nt3v22Ev();
extern void _ZN9S241C6_nt3v23Ev();
extern void _ZN9S241C6_nt3v24Ev();
extern void _ZN9S241C6_nt3v25Ev();
extern void _ZN9S241C6_nt3v26Ev();
extern void _ZN9S241C6_nt3v27Ev();
extern void _ZN9S241C6_nt3v28Ev();
extern void _ZN9S241C6_nt3v29Ev();
extern void _ZN9S241C6_nt3v30Ev();
extern void _ZN9S241C6_nt3v31Ev();
extern void _ZN9S241C6_nt3v32Ev();
extern void _ZN9S241C6_nt3v33Ev();
extern void _ZN9S241C6_nt3v34Ev();
extern void _ZN9S241C6_nt3v35Ev();
extern void _ZN9S241C6_nt3v36Ev();
extern void _ZN9S241C6_nt3v37Ev();
extern void _ZN9S241C6_nt3v38Ev();
extern void _ZN9S241C6_nt3v39Ev();
extern void _ZN9S241C6_nt3v40Ev();
extern void _ZN9S241C6_nt3v41Ev();
extern void _ZN9S241C6_nt3v42Ev();
extern void _ZN9S241C6_nt3v43Ev();
extern void _ZN9S241C6_nt3v44Ev();
extern void _ZN9S241C6_nt3v45Ev();
extern void _ZN9S241C6_nt3v46Ev();
extern void _ZN9S241C6_nt3v47Ev();
extern void _ZN9S241C6_nt3v48Ev();
extern void _ZN9S241C6_nt3v49Ev();
extern void _ZN9S241C6_nt3v50Ev();
extern void _ZN9S241C6_nt3v51Ev();
extern void _ZN9S241C6_nt3v52Ev();
extern void _ZN9S241C6_nt3v53Ev();
extern void _ZN9S241C6_nt3v54Ev();
extern void _ZN9S241C6_nt3v55Ev();
extern void _ZN9S241C6_nt3v56Ev();
extern void _ZN9S241C6_nt3v57Ev();
extern void _ZN9S241C6_nt3v58Ev();
extern void _ZN9S241C6_nt3v59Ev();
extern void _ZN9S241C6_nt3v60Ev();
extern void _ZN9S241C6_nt3v61Ev();
extern void _ZN9S241C6_nt3v62Ev();
extern void _ZN9S241C6_nt3v63Ev();
extern void _ZN9S241C6_nt3v64Ev();
extern void _ZN9S241C6_nt3v65Ev();
extern void _ZN9S241C6_nt3v66Ev();
extern void _ZN9S241C6_nt3v67Ev();
extern void _ZN9S241C6_nt3v68Ev();
extern void _ZN9S241C5_nt3v69Ev();
extern void _ZN9S241C5_nt3v70Ev();
extern void _ZN9S241C5_nt3v71Ev();
extern void _ZN9S241C5_nt3v72Ev();
extern void _ZN9S241C5_nt3v73Ev();
extern void _ZN9S241C5_nt3v74Ev();
extern void _ZN9S241C5_nt3v75Ev();
extern void _ZN9S241C5_nt3v76Ev();
extern void _ZN9S241C5_nt3v77Ev();
extern void _ZN9S241C5_nt3v78Ev();
extern void _ZN9S241C5_nt3v79Ev();
extern void _ZN9S241C5_nt3v80Ev();
extern void _ZN9S241C5_nt3v81Ev();
extern void _ZN9S241C5_nt3v82Ev();
extern void _ZN9S241C5_nt3v83Ev();
extern void _ZN9S241C5_nt3v84Ev();
extern void _ZN9S241C5_nt3v85Ev();
extern void _ZN9S241C5_nt3v86Ev();
extern void _ZN9S241C5_nt3v87Ev();
extern void _ZN9S241C5_nt3v88Ev();
extern void _ZN9S241C5_nt3v89Ev();
extern void _ZN9S241C5_nt3v90Ev();
extern void _ZN9S241C4_nt3v91Ev();
extern void _ZN9S241C4_nt3v92Ev();
extern void _ZN9S241C4_nt3v93Ev();
extern void _ZN9S241C4_nt3v94Ev();
extern void _ZN9S241C4_nt3v95Ev();
extern void _ZN9S241C4_nt3v96Ev();
extern void _ZN9S241C4_nt3v97Ev();
extern void _ZN9S241C4_nt3v98Ev();
extern void _ZN9S241C4_nt3v99Ev();
extern void _ZN9S241C4_nt4v100Ev();
extern void _ZN9S241C4_nt4v101Ev();
extern void _ZN9S241C4_nt4v102Ev();
extern void _ZN9S241C4_nt4v103Ev();
extern void _ZN9S241C4_nt4v104Ev();
extern void _ZN9S241C4_nt4v105Ev();
extern void _ZN9S241C4_nt4v106Ev();
extern void _ZN9S241C4_nt4v107Ev();
extern void _ZN9S241C4_nt4v108Ev();
extern void _ZN9S241C4_nt4v109Ev();
extern void _ZN9S241C4_nt4v110Ev();
extern void _ZN9S241C3_nt4v111Ev();
extern void _ZN9S241C3_nt4v112Ev();
extern void _ZN9S241C3_nt4v113Ev();
extern void _ZN9S241C3_nt4v114Ev();
static  VTBL_ENTRY vtc_S241C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S241C3_nt[0]),
  (VTBL_ENTRY)&_ZN9S241C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S241C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S241C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S241C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S241C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S241C3_nt4v114Ev,
};
extern VTBL_ENTRY _ZTI9S241C3_nt[];
VTBL_ENTRY *P__ZTI9S241C3_nt = _ZTI9S241C3_nt; 
extern  VTBL_ENTRY _ZTV9S241C3_nt[];
Class_Descriptor cd_S241C3_nt = {  "S241C3_nt", // class name
  bases_S241C3_nt, 3,
  &(vtc_S241C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,220), // object size
  NSPAIRA(_ZTI9S241C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S241C3_nt),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S241C2_nt  : S241C3_nt {
  ::S241C21 s241c2f0;
  unsigned int s241c2f1:1;
  virtual  ~S241C2_nt(); // _ZN9S241C2_ntD1Ev
  virtual void  v115(); // _ZN9S241C2_nt4v115Ev
  virtual void  v116(); // _ZN9S241C2_nt4v116Ev
  virtual void  v117(); // _ZN9S241C2_nt4v117Ev
  virtual void  v118(); // _ZN9S241C2_nt4v118Ev
  virtual void  v119(); // _ZN9S241C2_nt4v119Ev
  virtual void  v120(); // _ZN9S241C2_nt4v120Ev
  virtual void  v121(); // _ZN9S241C2_nt4v121Ev
  S241C2_nt(); // tgen
};
//SIG(-1 S241C2_nt) C1{ BC2{ BC3{ BC4{ BC5{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC12 FC14{ BC15{ BC10}} FC14 Fi[3]} vd v114 v115 v116 v117 FC6 Fi:1 FC16{ BC17{ BC10}}} vd v1 v2 v3 v4 v5 v6 v7 FC16 Fi:1}


 S241C2_nt ::~S241C2_nt(){ note_dtor("S241C2_nt", this);}
void  S241C2_nt ::v115(){vfunc_called(this, "_ZN9S241C2_nt4v115Ev");}
void  S241C2_nt ::v116(){vfunc_called(this, "_ZN9S241C2_nt4v116Ev");}
void  S241C2_nt ::v117(){vfunc_called(this, "_ZN9S241C2_nt4v117Ev");}
void  S241C2_nt ::v118(){vfunc_called(this, "_ZN9S241C2_nt4v118Ev");}
void  S241C2_nt ::v119(){vfunc_called(this, "_ZN9S241C2_nt4v119Ev");}
void  S241C2_nt ::v120(){vfunc_called(this, "_ZN9S241C2_nt4v120Ev");}
void  S241C2_nt ::v121(){vfunc_called(this, "_ZN9S241C2_nt4v121Ev");}
S241C2_nt ::S241C2_nt(){ note_ctor("S241C2_nt", this);} // tgen

//skip512 S241C2_nt

#else // __cplusplus

extern void _ZN9S241C2_ntC1Ev();
extern void _ZN9S241C2_ntD1Ev();
Name_Map name_map_S241C2_nt[] = {
  NSPAIR(_ZN9S241C2_ntC1Ev),
  NSPAIR(_ZN9S241C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S241C6_nt;
extern VTBL_ENTRY _ZTI9S241C6_nt[];
extern  VTBL_ENTRY _ZTV9S241C6_nt[];
extern Class_Descriptor cd_S241C5_nt;
extern VTBL_ENTRY _ZTI9S241C5_nt[];
extern  VTBL_ENTRY _ZTV9S241C5_nt[];
extern Class_Descriptor cd_S241C4_nt;
extern VTBL_ENTRY _ZTI9S241C4_nt[];
extern  VTBL_ENTRY _ZTV9S241C4_nt[];
extern Class_Descriptor cd_S241C3_nt;
extern VTBL_ENTRY _ZTI9S241C3_nt[];
extern  VTBL_ENTRY _ZTV9S241C3_nt[];
static Base_Class bases_S241C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S241C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S241C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S241C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S241C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S241C2_nt[];
extern void _ZN9S241C2_ntD1Ev();
extern void _ZN9S241C2_ntD0Ev();
extern void _ZN9S241C6_nt2v5Ev();
extern void _ZN9S241C6_nt2v6Ev();
extern void _ZN9S241C6_nt2v7Ev();
extern void _ZN9S241C6_nt2v8Ev();
extern void _ZN9S241C6_nt2v9Ev();
extern void _ZN9S241C6_nt3v10Ev();
extern void _ZN9S241C6_nt3v11Ev();
extern void _ZN9S241C6_nt3v12Ev();
extern void _ZN9S241C6_nt3v13Ev();
extern void _ZN9S241C6_nt3v14Ev();
extern void _ZN9S241C6_nt3v15Ev();
extern void _ZN9S241C6_nt3v16Ev();
extern void _ZN9S241C6_nt3v17Ev();
extern void _ZN9S241C6_nt3v18Ev();
extern void _ZN9S241C6_nt3v19Ev();
extern void _ZN9S241C6_nt3v20Ev();
extern void _ZN9S241C6_nt3v21Ev();
extern void _ZN9S241C6_nt3v22Ev();
extern void _ZN9S241C6_nt3v23Ev();
extern void _ZN9S241C6_nt3v24Ev();
extern void _ZN9S241C6_nt3v25Ev();
extern void _ZN9S241C6_nt3v26Ev();
extern void _ZN9S241C6_nt3v27Ev();
extern void _ZN9S241C6_nt3v28Ev();
extern void _ZN9S241C6_nt3v29Ev();
extern void _ZN9S241C6_nt3v30Ev();
extern void _ZN9S241C6_nt3v31Ev();
extern void _ZN9S241C6_nt3v32Ev();
extern void _ZN9S241C6_nt3v33Ev();
extern void _ZN9S241C6_nt3v34Ev();
extern void _ZN9S241C6_nt3v35Ev();
extern void _ZN9S241C6_nt3v36Ev();
extern void _ZN9S241C6_nt3v37Ev();
extern void _ZN9S241C6_nt3v38Ev();
extern void _ZN9S241C6_nt3v39Ev();
extern void _ZN9S241C6_nt3v40Ev();
extern void _ZN9S241C6_nt3v41Ev();
extern void _ZN9S241C6_nt3v42Ev();
extern void _ZN9S241C6_nt3v43Ev();
extern void _ZN9S241C6_nt3v44Ev();
extern void _ZN9S241C6_nt3v45Ev();
extern void _ZN9S241C6_nt3v46Ev();
extern void _ZN9S241C6_nt3v47Ev();
extern void _ZN9S241C6_nt3v48Ev();
extern void _ZN9S241C6_nt3v49Ev();
extern void _ZN9S241C6_nt3v50Ev();
extern void _ZN9S241C6_nt3v51Ev();
extern void _ZN9S241C6_nt3v52Ev();
extern void _ZN9S241C6_nt3v53Ev();
extern void _ZN9S241C6_nt3v54Ev();
extern void _ZN9S241C6_nt3v55Ev();
extern void _ZN9S241C6_nt3v56Ev();
extern void _ZN9S241C6_nt3v57Ev();
extern void _ZN9S241C6_nt3v58Ev();
extern void _ZN9S241C6_nt3v59Ev();
extern void _ZN9S241C6_nt3v60Ev();
extern void _ZN9S241C6_nt3v61Ev();
extern void _ZN9S241C6_nt3v62Ev();
extern void _ZN9S241C6_nt3v63Ev();
extern void _ZN9S241C6_nt3v64Ev();
extern void _ZN9S241C6_nt3v65Ev();
extern void _ZN9S241C6_nt3v66Ev();
extern void _ZN9S241C6_nt3v67Ev();
extern void _ZN9S241C6_nt3v68Ev();
extern void _ZN9S241C5_nt3v69Ev();
extern void _ZN9S241C5_nt3v70Ev();
extern void _ZN9S241C5_nt3v71Ev();
extern void _ZN9S241C5_nt3v72Ev();
extern void _ZN9S241C5_nt3v73Ev();
extern void _ZN9S241C5_nt3v74Ev();
extern void _ZN9S241C5_nt3v75Ev();
extern void _ZN9S241C5_nt3v76Ev();
extern void _ZN9S241C5_nt3v77Ev();
extern void _ZN9S241C5_nt3v78Ev();
extern void _ZN9S241C5_nt3v79Ev();
extern void _ZN9S241C5_nt3v80Ev();
extern void _ZN9S241C5_nt3v81Ev();
extern void _ZN9S241C5_nt3v82Ev();
extern void _ZN9S241C5_nt3v83Ev();
extern void _ZN9S241C5_nt3v84Ev();
extern void _ZN9S241C5_nt3v85Ev();
extern void _ZN9S241C5_nt3v86Ev();
extern void _ZN9S241C5_nt3v87Ev();
extern void _ZN9S241C5_nt3v88Ev();
extern void _ZN9S241C5_nt3v89Ev();
extern void _ZN9S241C5_nt3v90Ev();
extern void _ZN9S241C4_nt3v91Ev();
extern void _ZN9S241C4_nt3v92Ev();
extern void _ZN9S241C4_nt3v93Ev();
extern void _ZN9S241C4_nt3v94Ev();
extern void _ZN9S241C4_nt3v95Ev();
extern void _ZN9S241C4_nt3v96Ev();
extern void _ZN9S241C4_nt3v97Ev();
extern void _ZN9S241C4_nt3v98Ev();
extern void _ZN9S241C4_nt3v99Ev();
extern void _ZN9S241C4_nt4v100Ev();
extern void _ZN9S241C4_nt4v101Ev();
extern void _ZN9S241C4_nt4v102Ev();
extern void _ZN9S241C4_nt4v103Ev();
extern void _ZN9S241C4_nt4v104Ev();
extern void _ZN9S241C4_nt4v105Ev();
extern void _ZN9S241C4_nt4v106Ev();
extern void _ZN9S241C4_nt4v107Ev();
extern void _ZN9S241C4_nt4v108Ev();
extern void _ZN9S241C4_nt4v109Ev();
extern void _ZN9S241C4_nt4v110Ev();
extern void _ZN9S241C3_nt4v111Ev();
extern void _ZN9S241C3_nt4v112Ev();
extern void _ZN9S241C3_nt4v113Ev();
extern void _ZN9S241C3_nt4v114Ev();
extern void _ZN9S241C2_nt4v115Ev();
extern void _ZN9S241C2_nt4v116Ev();
extern void _ZN9S241C2_nt4v117Ev();
extern void _ZN9S241C2_nt4v118Ev();
extern void _ZN9S241C2_nt4v119Ev();
extern void _ZN9S241C2_nt4v120Ev();
extern void _ZN9S241C2_nt4v121Ev();
static  VTBL_ENTRY vtc_S241C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S241C2_nt[0]),
  (VTBL_ENTRY)&_ZN9S241C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S241C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S241C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S241C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S241C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S241C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S241C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S241C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S241C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S241C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S241C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S241C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S241C2_nt4v121Ev,
};
extern VTBL_ENTRY _ZTI9S241C2_nt[];
VTBL_ENTRY *P__ZTI9S241C2_nt = _ZTI9S241C2_nt; 
extern  VTBL_ENTRY _ZTV9S241C2_nt[];
Class_Descriptor cd_S241C2_nt = {  "S241C2_nt", // class name
  bases_S241C2_nt, 4,
  &(vtc_S241C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(320,236), // object size
  NSPAIRA(_ZTI9S241C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S241C2_nt),121, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S241C1  : S241C2_nt {
  void *s241c1f0;
  ::S241C7_nt s241c1f1;
  virtual  ~S241C1(); // _ZN6S241C1D1Ev
  virtual void  v1(); // _ZN6S241C12v1Ev
  virtual void  v2(); // _ZN6S241C12v2Ev
  virtual void  v3(); // _ZN6S241C12v3Ev
  virtual void  v4(); // _ZN6S241C12v4Ev
  S241C1(); // tgen
};
//SIG(1 S241C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 FC12{ m} FC8 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC13{ BC14{ BC11}} FC13 FC15{ BC16{ BC11}} FC15 Fi[3]} vd v111 v112 v113 v114 FC7 Fi:1 FC17{ BC18{ BC11}}} vd v115 v116 v117 v118 v119 v120 v121 FC17 Fi:1} vd v1 v2 v3 v4 Fp FC7}


 S241C1 ::~S241C1(){ note_dtor("S241C1", this);}
void  S241C1 ::v1(){vfunc_called(this, "_ZN6S241C12v1Ev");}
void  S241C1 ::v2(){vfunc_called(this, "_ZN6S241C12v2Ev");}
void  S241C1 ::v3(){vfunc_called(this, "_ZN6S241C12v3Ev");}
void  S241C1 ::v4(){vfunc_called(this, "_ZN6S241C12v4Ev");}
S241C1 ::S241C1(){ note_ctor("S241C1", this);} // tgen

static void Test_S241C1()
{
  extern Class_Descriptor cd_S241C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(43,63)];
    init_test(&cd_S241C1, buf);
    S241C1 *dp, &lv = *(dp=new (buf) S241C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(336,248), "sizeof(S241C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S241C1)");
    check_base_class_offset(lv, (S241C6_nt*)(S241C5_nt*)(S241C4_nt*)(S241C3_nt*)(S241C2_nt*), 0, "S241C1");
    check_base_class_offset(lv, (S241C5_nt*)(S241C4_nt*)(S241C3_nt*)(S241C2_nt*), 0, "S241C1");
    check_base_class_offset(lv, (S241C4_nt*)(S241C3_nt*)(S241C2_nt*), 0, "S241C1");
    check_base_class_offset(lv, (S241C3_nt*)(S241C2_nt*), 0, "S241C1");
    check_base_class_offset(lv, (S241C2_nt*), 0, "S241C1");
    check_field_offset(lv, s241c1f0, ABISELECT(320,236), "S241C1.s241c1f0");
    check_field_offset(lv, s241c1f1, ABISELECT(328,240), "S241C1.s241c1f1");
    test_class_info(&lv, &cd_S241C1);
    dp->~S241C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS241C1(Test_S241C1, "S241C1", ABISELECT(336,248));

#else // __cplusplus

extern void _ZN6S241C1C1Ev();
extern void _ZN6S241C1D1Ev();
Name_Map name_map_S241C1[] = {
  NSPAIR(_ZN6S241C1C1Ev),
  NSPAIR(_ZN6S241C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S241C6_nt;
extern VTBL_ENTRY _ZTI9S241C6_nt[];
extern  VTBL_ENTRY _ZTV9S241C6_nt[];
extern Class_Descriptor cd_S241C5_nt;
extern VTBL_ENTRY _ZTI9S241C5_nt[];
extern  VTBL_ENTRY _ZTV9S241C5_nt[];
extern Class_Descriptor cd_S241C4_nt;
extern VTBL_ENTRY _ZTI9S241C4_nt[];
extern  VTBL_ENTRY _ZTV9S241C4_nt[];
extern Class_Descriptor cd_S241C3_nt;
extern VTBL_ENTRY _ZTI9S241C3_nt[];
extern  VTBL_ENTRY _ZTV9S241C3_nt[];
extern Class_Descriptor cd_S241C2_nt;
extern VTBL_ENTRY _ZTI9S241C2_nt[];
extern  VTBL_ENTRY _ZTV9S241C2_nt[];
static Base_Class bases_S241C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S241C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S241C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S241C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S241C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S241C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S241C1[];
extern void _ZN6S241C1D1Ev();
extern void _ZN6S241C1D0Ev();
extern void _ZN9S241C6_nt2v5Ev();
extern void _ZN9S241C6_nt2v6Ev();
extern void _ZN9S241C6_nt2v7Ev();
extern void _ZN9S241C6_nt2v8Ev();
extern void _ZN9S241C6_nt2v9Ev();
extern void _ZN9S241C6_nt3v10Ev();
extern void _ZN9S241C6_nt3v11Ev();
extern void _ZN9S241C6_nt3v12Ev();
extern void _ZN9S241C6_nt3v13Ev();
extern void _ZN9S241C6_nt3v14Ev();
extern void _ZN9S241C6_nt3v15Ev();
extern void _ZN9S241C6_nt3v16Ev();
extern void _ZN9S241C6_nt3v17Ev();
extern void _ZN9S241C6_nt3v18Ev();
extern void _ZN9S241C6_nt3v19Ev();
extern void _ZN9S241C6_nt3v20Ev();
extern void _ZN9S241C6_nt3v21Ev();
extern void _ZN9S241C6_nt3v22Ev();
extern void _ZN9S241C6_nt3v23Ev();
extern void _ZN9S241C6_nt3v24Ev();
extern void _ZN9S241C6_nt3v25Ev();
extern void _ZN9S241C6_nt3v26Ev();
extern void _ZN9S241C6_nt3v27Ev();
extern void _ZN9S241C6_nt3v28Ev();
extern void _ZN9S241C6_nt3v29Ev();
extern void _ZN9S241C6_nt3v30Ev();
extern void _ZN9S241C6_nt3v31Ev();
extern void _ZN9S241C6_nt3v32Ev();
extern void _ZN9S241C6_nt3v33Ev();
extern void _ZN9S241C6_nt3v34Ev();
extern void _ZN9S241C6_nt3v35Ev();
extern void _ZN9S241C6_nt3v36Ev();
extern void _ZN9S241C6_nt3v37Ev();
extern void _ZN9S241C6_nt3v38Ev();
extern void _ZN9S241C6_nt3v39Ev();
extern void _ZN9S241C6_nt3v40Ev();
extern void _ZN9S241C6_nt3v41Ev();
extern void _ZN9S241C6_nt3v42Ev();
extern void _ZN9S241C6_nt3v43Ev();
extern void _ZN9S241C6_nt3v44Ev();
extern void _ZN9S241C6_nt3v45Ev();
extern void _ZN9S241C6_nt3v46Ev();
extern void _ZN9S241C6_nt3v47Ev();
extern void _ZN9S241C6_nt3v48Ev();
extern void _ZN9S241C6_nt3v49Ev();
extern void _ZN9S241C6_nt3v50Ev();
extern void _ZN9S241C6_nt3v51Ev();
extern void _ZN9S241C6_nt3v52Ev();
extern void _ZN9S241C6_nt3v53Ev();
extern void _ZN9S241C6_nt3v54Ev();
extern void _ZN9S241C6_nt3v55Ev();
extern void _ZN9S241C6_nt3v56Ev();
extern void _ZN9S241C6_nt3v57Ev();
extern void _ZN9S241C6_nt3v58Ev();
extern void _ZN9S241C6_nt3v59Ev();
extern void _ZN9S241C6_nt3v60Ev();
extern void _ZN9S241C6_nt3v61Ev();
extern void _ZN9S241C6_nt3v62Ev();
extern void _ZN9S241C6_nt3v63Ev();
extern void _ZN9S241C6_nt3v64Ev();
extern void _ZN9S241C6_nt3v65Ev();
extern void _ZN9S241C6_nt3v66Ev();
extern void _ZN9S241C6_nt3v67Ev();
extern void _ZN9S241C6_nt3v68Ev();
extern void _ZN9S241C5_nt3v69Ev();
extern void _ZN9S241C5_nt3v70Ev();
extern void _ZN9S241C5_nt3v71Ev();
extern void _ZN9S241C5_nt3v72Ev();
extern void _ZN9S241C5_nt3v73Ev();
extern void _ZN9S241C5_nt3v74Ev();
extern void _ZN9S241C5_nt3v75Ev();
extern void _ZN9S241C5_nt3v76Ev();
extern void _ZN9S241C5_nt3v77Ev();
extern void _ZN9S241C5_nt3v78Ev();
extern void _ZN9S241C5_nt3v79Ev();
extern void _ZN9S241C5_nt3v80Ev();
extern void _ZN9S241C5_nt3v81Ev();
extern void _ZN9S241C5_nt3v82Ev();
extern void _ZN9S241C5_nt3v83Ev();
extern void _ZN9S241C5_nt3v84Ev();
extern void _ZN9S241C5_nt3v85Ev();
extern void _ZN9S241C5_nt3v86Ev();
extern void _ZN9S241C5_nt3v87Ev();
extern void _ZN9S241C5_nt3v88Ev();
extern void _ZN9S241C5_nt3v89Ev();
extern void _ZN9S241C5_nt3v90Ev();
extern void _ZN9S241C4_nt3v91Ev();
extern void _ZN9S241C4_nt3v92Ev();
extern void _ZN9S241C4_nt3v93Ev();
extern void _ZN9S241C4_nt3v94Ev();
extern void _ZN9S241C4_nt3v95Ev();
extern void _ZN9S241C4_nt3v96Ev();
extern void _ZN9S241C4_nt3v97Ev();
extern void _ZN9S241C4_nt3v98Ev();
extern void _ZN9S241C4_nt3v99Ev();
extern void _ZN9S241C4_nt4v100Ev();
extern void _ZN9S241C4_nt4v101Ev();
extern void _ZN9S241C4_nt4v102Ev();
extern void _ZN9S241C4_nt4v103Ev();
extern void _ZN9S241C4_nt4v104Ev();
extern void _ZN9S241C4_nt4v105Ev();
extern void _ZN9S241C4_nt4v106Ev();
extern void _ZN9S241C4_nt4v107Ev();
extern void _ZN9S241C4_nt4v108Ev();
extern void _ZN9S241C4_nt4v109Ev();
extern void _ZN9S241C4_nt4v110Ev();
extern void _ZN9S241C3_nt4v111Ev();
extern void _ZN9S241C3_nt4v112Ev();
extern void _ZN9S241C3_nt4v113Ev();
extern void _ZN9S241C3_nt4v114Ev();
extern void _ZN9S241C2_nt4v115Ev();
extern void _ZN9S241C2_nt4v116Ev();
extern void _ZN9S241C2_nt4v117Ev();
extern void _ZN9S241C2_nt4v118Ev();
extern void _ZN9S241C2_nt4v119Ev();
extern void _ZN9S241C2_nt4v120Ev();
extern void _ZN9S241C2_nt4v121Ev();
extern void _ZN6S241C12v1Ev();
extern void _ZN6S241C12v2Ev();
extern void _ZN6S241C12v3Ev();
extern void _ZN6S241C12v4Ev();
static  VTBL_ENTRY vtc_S241C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S241C1[0]),
  (VTBL_ENTRY)&_ZN6S241C1D1Ev,
  (VTBL_ENTRY)&_ZN6S241C1D0Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S241C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S241C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S241C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S241C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S241C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S241C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S241C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S241C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S241C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S241C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S241C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S241C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S241C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S241C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN6S241C12v1Ev,
  (VTBL_ENTRY)&_ZN6S241C12v2Ev,
  (VTBL_ENTRY)&_ZN6S241C12v3Ev,
  (VTBL_ENTRY)&_ZN6S241C12v4Ev,
};
extern VTBL_ENTRY _ZTI6S241C1[];
extern  VTBL_ENTRY _ZTV6S241C1[];
Class_Descriptor cd_S241C1 = {  "S241C1", // class name
  bases_S241C1, 5,
  &(vtc_S241C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(336,248), // object size
  NSPAIRA(_ZTI6S241C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S241C1),125, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6500C2  {
  int s6500c2f0;
  __tsi64 s6500c2f1;
  void *s6500c2f2[4];
  int s6500c2f3[2];
  void *s6500c2f4;
  ::S241C7_nt s6500c2f5;
  void *s6500c2f6[2];
  virtual  ~S6500C2(); // _ZN7S6500C2D1Ev
  virtual void  v15(); // _ZN7S6500C23v15Ev
  virtual void  v16(); // _ZN7S6500C23v16Ev
  virtual void  v17(); // _ZN7S6500C23v17Ev
  virtual void  v18(); // _ZN7S6500C23v18Ev
  virtual void  v19(); // _ZN7S6500C23v19Ev
  virtual void  v20(); // _ZN7S6500C23v20Ev
  virtual void  v21(); // _ZN7S6500C23v21Ev
  virtual void  v22(); // _ZN7S6500C23v22Ev
  virtual void  v23(); // _ZN7S6500C23v23Ev
  virtual void  v24(); // _ZN7S6500C23v24Ev
  virtual void  v25(); // _ZN7S6500C23v25Ev
  virtual void  v26(); // _ZN7S6500C23v26Ev
  virtual void  v27(); // _ZN7S6500C23v27Ev
  virtual void  v28(); // _ZN7S6500C23v28Ev
  virtual void  v29(); // _ZN7S6500C23v29Ev
  virtual void  v30(); // _ZN7S6500C23v30Ev
  virtual void  v31(); // _ZN7S6500C23v31Ev
  virtual void  v32(); // _ZN7S6500C23v32Ev
  virtual void  v33(); // _ZN7S6500C23v33Ev
  virtual void  v34(); // _ZN7S6500C23v34Ev
  virtual void  v35(); // _ZN7S6500C23v35Ev
  virtual void  v36(); // _ZN7S6500C23v36Ev
  virtual void  v37(); // _ZN7S6500C23v37Ev
  virtual void  v38(); // _ZN7S6500C23v38Ev
  virtual void  v39(); // _ZN7S6500C23v39Ev
  virtual void  v40(); // _ZN7S6500C23v40Ev
  virtual void  v41(); // _ZN7S6500C23v41Ev
  virtual void  v42(); // _ZN7S6500C23v42Ev
  virtual void  v43(); // _ZN7S6500C23v43Ev
  virtual void  v44(); // _ZN7S6500C23v44Ev
  virtual void  v45(); // _ZN7S6500C23v45Ev
  virtual void  v46(); // _ZN7S6500C23v46Ev
  virtual void  v47(); // _ZN7S6500C23v47Ev
  virtual void  v48(); // _ZN7S6500C23v48Ev
  virtual void  v49(); // _ZN7S6500C23v49Ev
  virtual void  v50(); // _ZN7S6500C23v50Ev
  virtual void  v51(); // _ZN7S6500C23v51Ev
  virtual void  v52(); // _ZN7S6500C23v52Ev
  virtual void  v53(); // _ZN7S6500C23v53Ev
  virtual void  v54(); // _ZN7S6500C23v54Ev
  virtual void  v55(); // _ZN7S6500C23v55Ev
  virtual void  v56(); // _ZN7S6500C23v56Ev
  virtual void  v57(); // _ZN7S6500C23v57Ev
  virtual void  v58(); // _ZN7S6500C23v58Ev
  virtual void  v59(); // _ZN7S6500C23v59Ev
  virtual void  v60(); // _ZN7S6500C23v60Ev
  virtual void  v61(); // _ZN7S6500C23v61Ev
  virtual void  v62(); // _ZN7S6500C23v62Ev
  virtual void  v63(); // _ZN7S6500C23v63Ev
  virtual void  v64(); // _ZN7S6500C23v64Ev
  virtual void  v65(); // _ZN7S6500C23v65Ev
  virtual void  v66(); // _ZN7S6500C23v66Ev
  virtual void  v67(); // _ZN7S6500C23v67Ev
  virtual void  v68(); // _ZN7S6500C23v68Ev
  virtual void  v69(); // _ZN7S6500C23v69Ev
  virtual void  v70(); // _ZN7S6500C23v70Ev
  virtual void  v71(); // _ZN7S6500C23v71Ev
  virtual void  v72(); // _ZN7S6500C23v72Ev
  virtual void  v73(); // _ZN7S6500C23v73Ev
  virtual void  v74(); // _ZN7S6500C23v74Ev
  virtual void  v75(); // _ZN7S6500C23v75Ev
  virtual void  v76(); // _ZN7S6500C23v76Ev
  virtual void  v77(); // _ZN7S6500C23v77Ev
  virtual void  v78(); // _ZN7S6500C23v78Ev
  S6500C2(); // tgen
};
//SIG(-1 S6500C2) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S6500C2 ::~S6500C2(){ note_dtor("S6500C2", this);}
void  S6500C2 ::v15(){vfunc_called(this, "_ZN7S6500C23v15Ev");}
void  S6500C2 ::v16(){vfunc_called(this, "_ZN7S6500C23v16Ev");}
void  S6500C2 ::v17(){vfunc_called(this, "_ZN7S6500C23v17Ev");}
void  S6500C2 ::v18(){vfunc_called(this, "_ZN7S6500C23v18Ev");}
void  S6500C2 ::v19(){vfunc_called(this, "_ZN7S6500C23v19Ev");}
void  S6500C2 ::v20(){vfunc_called(this, "_ZN7S6500C23v20Ev");}
void  S6500C2 ::v21(){vfunc_called(this, "_ZN7S6500C23v21Ev");}
void  S6500C2 ::v22(){vfunc_called(this, "_ZN7S6500C23v22Ev");}
void  S6500C2 ::v23(){vfunc_called(this, "_ZN7S6500C23v23Ev");}
void  S6500C2 ::v24(){vfunc_called(this, "_ZN7S6500C23v24Ev");}
void  S6500C2 ::v25(){vfunc_called(this, "_ZN7S6500C23v25Ev");}
void  S6500C2 ::v26(){vfunc_called(this, "_ZN7S6500C23v26Ev");}
void  S6500C2 ::v27(){vfunc_called(this, "_ZN7S6500C23v27Ev");}
void  S6500C2 ::v28(){vfunc_called(this, "_ZN7S6500C23v28Ev");}
void  S6500C2 ::v29(){vfunc_called(this, "_ZN7S6500C23v29Ev");}
void  S6500C2 ::v30(){vfunc_called(this, "_ZN7S6500C23v30Ev");}
void  S6500C2 ::v31(){vfunc_called(this, "_ZN7S6500C23v31Ev");}
void  S6500C2 ::v32(){vfunc_called(this, "_ZN7S6500C23v32Ev");}
void  S6500C2 ::v33(){vfunc_called(this, "_ZN7S6500C23v33Ev");}
void  S6500C2 ::v34(){vfunc_called(this, "_ZN7S6500C23v34Ev");}
void  S6500C2 ::v35(){vfunc_called(this, "_ZN7S6500C23v35Ev");}
void  S6500C2 ::v36(){vfunc_called(this, "_ZN7S6500C23v36Ev");}
void  S6500C2 ::v37(){vfunc_called(this, "_ZN7S6500C23v37Ev");}
void  S6500C2 ::v38(){vfunc_called(this, "_ZN7S6500C23v38Ev");}
void  S6500C2 ::v39(){vfunc_called(this, "_ZN7S6500C23v39Ev");}
void  S6500C2 ::v40(){vfunc_called(this, "_ZN7S6500C23v40Ev");}
void  S6500C2 ::v41(){vfunc_called(this, "_ZN7S6500C23v41Ev");}
void  S6500C2 ::v42(){vfunc_called(this, "_ZN7S6500C23v42Ev");}
void  S6500C2 ::v43(){vfunc_called(this, "_ZN7S6500C23v43Ev");}
void  S6500C2 ::v44(){vfunc_called(this, "_ZN7S6500C23v44Ev");}
void  S6500C2 ::v45(){vfunc_called(this, "_ZN7S6500C23v45Ev");}
void  S6500C2 ::v46(){vfunc_called(this, "_ZN7S6500C23v46Ev");}
void  S6500C2 ::v47(){vfunc_called(this, "_ZN7S6500C23v47Ev");}
void  S6500C2 ::v48(){vfunc_called(this, "_ZN7S6500C23v48Ev");}
void  S6500C2 ::v49(){vfunc_called(this, "_ZN7S6500C23v49Ev");}
void  S6500C2 ::v50(){vfunc_called(this, "_ZN7S6500C23v50Ev");}
void  S6500C2 ::v51(){vfunc_called(this, "_ZN7S6500C23v51Ev");}
void  S6500C2 ::v52(){vfunc_called(this, "_ZN7S6500C23v52Ev");}
void  S6500C2 ::v53(){vfunc_called(this, "_ZN7S6500C23v53Ev");}
void  S6500C2 ::v54(){vfunc_called(this, "_ZN7S6500C23v54Ev");}
void  S6500C2 ::v55(){vfunc_called(this, "_ZN7S6500C23v55Ev");}
void  S6500C2 ::v56(){vfunc_called(this, "_ZN7S6500C23v56Ev");}
void  S6500C2 ::v57(){vfunc_called(this, "_ZN7S6500C23v57Ev");}
void  S6500C2 ::v58(){vfunc_called(this, "_ZN7S6500C23v58Ev");}
void  S6500C2 ::v59(){vfunc_called(this, "_ZN7S6500C23v59Ev");}
void  S6500C2 ::v60(){vfunc_called(this, "_ZN7S6500C23v60Ev");}
void  S6500C2 ::v61(){vfunc_called(this, "_ZN7S6500C23v61Ev");}
void  S6500C2 ::v62(){vfunc_called(this, "_ZN7S6500C23v62Ev");}
void  S6500C2 ::v63(){vfunc_called(this, "_ZN7S6500C23v63Ev");}
void  S6500C2 ::v64(){vfunc_called(this, "_ZN7S6500C23v64Ev");}
void  S6500C2 ::v65(){vfunc_called(this, "_ZN7S6500C23v65Ev");}
void  S6500C2 ::v66(){vfunc_called(this, "_ZN7S6500C23v66Ev");}
void  S6500C2 ::v67(){vfunc_called(this, "_ZN7S6500C23v67Ev");}
void  S6500C2 ::v68(){vfunc_called(this, "_ZN7S6500C23v68Ev");}
void  S6500C2 ::v69(){vfunc_called(this, "_ZN7S6500C23v69Ev");}
void  S6500C2 ::v70(){vfunc_called(this, "_ZN7S6500C23v70Ev");}
void  S6500C2 ::v71(){vfunc_called(this, "_ZN7S6500C23v71Ev");}
void  S6500C2 ::v72(){vfunc_called(this, "_ZN7S6500C23v72Ev");}
void  S6500C2 ::v73(){vfunc_called(this, "_ZN7S6500C23v73Ev");}
void  S6500C2 ::v74(){vfunc_called(this, "_ZN7S6500C23v74Ev");}
void  S6500C2 ::v75(){vfunc_called(this, "_ZN7S6500C23v75Ev");}
void  S6500C2 ::v76(){vfunc_called(this, "_ZN7S6500C23v76Ev");}
void  S6500C2 ::v77(){vfunc_called(this, "_ZN7S6500C23v77Ev");}
void  S6500C2 ::v78(){vfunc_called(this, "_ZN7S6500C23v78Ev");}
S6500C2 ::S6500C2(){ note_ctor("S6500C2", this);} // tgen

static void Test_S6500C2()
{
  extern Class_Descriptor cd_S6500C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S6500C2, buf);
    S6500C2 *dp, &lv = *(dp=new (buf) S6500C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S6500C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S6500C2)");
    check_field_offset(lv, s6500c2f0, ABISELECT(8,4), "S6500C2.s6500c2f0");
    check_field_offset(lv, s6500c2f1, ABISELECT(16,8), "S6500C2.s6500c2f1");
    check_field_offset(lv, s6500c2f2, ABISELECT(24,16), "S6500C2.s6500c2f2");
    check_field_offset(lv, s6500c2f3, ABISELECT(56,32), "S6500C2.s6500c2f3");
    check_field_offset(lv, s6500c2f4, ABISELECT(64,40), "S6500C2.s6500c2f4");
    check_field_offset(lv, s6500c2f5, ABISELECT(72,44), "S6500C2.s6500c2f5");
    check_field_offset(lv, s6500c2f6, ABISELECT(80,52), "S6500C2.s6500c2f6");
    test_class_info(&lv, &cd_S6500C2);
    dp->~S6500C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6500C2(Test_S6500C2, "S6500C2", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S6500C2C1Ev();
extern void _ZN7S6500C2D1Ev();
Name_Map name_map_S6500C2[] = {
  NSPAIR(_ZN7S6500C2C1Ev),
  NSPAIR(_ZN7S6500C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S6500C2[];
extern void _ZN7S6500C2D1Ev();
extern void _ZN7S6500C2D0Ev();
extern void _ZN7S6500C23v15Ev();
extern void _ZN7S6500C23v16Ev();
extern void _ZN7S6500C23v17Ev();
extern void _ZN7S6500C23v18Ev();
extern void _ZN7S6500C23v19Ev();
extern void _ZN7S6500C23v20Ev();
extern void _ZN7S6500C23v21Ev();
extern void _ZN7S6500C23v22Ev();
extern void _ZN7S6500C23v23Ev();
extern void _ZN7S6500C23v24Ev();
extern void _ZN7S6500C23v25Ev();
extern void _ZN7S6500C23v26Ev();
extern void _ZN7S6500C23v27Ev();
extern void _ZN7S6500C23v28Ev();
extern void _ZN7S6500C23v29Ev();
extern void _ZN7S6500C23v30Ev();
extern void _ZN7S6500C23v31Ev();
extern void _ZN7S6500C23v32Ev();
extern void _ZN7S6500C23v33Ev();
extern void _ZN7S6500C23v34Ev();
extern void _ZN7S6500C23v35Ev();
extern void _ZN7S6500C23v36Ev();
extern void _ZN7S6500C23v37Ev();
extern void _ZN7S6500C23v38Ev();
extern void _ZN7S6500C23v39Ev();
extern void _ZN7S6500C23v40Ev();
extern void _ZN7S6500C23v41Ev();
extern void _ZN7S6500C23v42Ev();
extern void _ZN7S6500C23v43Ev();
extern void _ZN7S6500C23v44Ev();
extern void _ZN7S6500C23v45Ev();
extern void _ZN7S6500C23v46Ev();
extern void _ZN7S6500C23v47Ev();
extern void _ZN7S6500C23v48Ev();
extern void _ZN7S6500C23v49Ev();
extern void _ZN7S6500C23v50Ev();
extern void _ZN7S6500C23v51Ev();
extern void _ZN7S6500C23v52Ev();
extern void _ZN7S6500C23v53Ev();
extern void _ZN7S6500C23v54Ev();
extern void _ZN7S6500C23v55Ev();
extern void _ZN7S6500C23v56Ev();
extern void _ZN7S6500C23v57Ev();
extern void _ZN7S6500C23v58Ev();
extern void _ZN7S6500C23v59Ev();
extern void _ZN7S6500C23v60Ev();
extern void _ZN7S6500C23v61Ev();
extern void _ZN7S6500C23v62Ev();
extern void _ZN7S6500C23v63Ev();
extern void _ZN7S6500C23v64Ev();
extern void _ZN7S6500C23v65Ev();
extern void _ZN7S6500C23v66Ev();
extern void _ZN7S6500C23v67Ev();
extern void _ZN7S6500C23v68Ev();
extern void _ZN7S6500C23v69Ev();
extern void _ZN7S6500C23v70Ev();
extern void _ZN7S6500C23v71Ev();
extern void _ZN7S6500C23v72Ev();
extern void _ZN7S6500C23v73Ev();
extern void _ZN7S6500C23v74Ev();
extern void _ZN7S6500C23v75Ev();
extern void _ZN7S6500C23v76Ev();
extern void _ZN7S6500C23v77Ev();
extern void _ZN7S6500C23v78Ev();
static  VTBL_ENTRY vtc_S6500C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S6500C2[0]),
  (VTBL_ENTRY)&_ZN7S6500C2D1Ev,
  (VTBL_ENTRY)&_ZN7S6500C2D0Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v15Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v16Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v17Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v18Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v19Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v20Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v21Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v22Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v23Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v24Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v25Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v26Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v27Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v28Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v29Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v30Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v31Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v32Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v33Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v34Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v35Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v36Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v37Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v38Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v39Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v40Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v41Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v42Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v43Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v44Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v45Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v46Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v47Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v48Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v49Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v50Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v51Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v52Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v53Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v54Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v55Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v56Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v57Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v58Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v59Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v60Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v61Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v62Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v63Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v64Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v65Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v66Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v67Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v68Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v69Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v70Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v71Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v72Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v73Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v74Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v75Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v76Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v77Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v78Ev,
};
extern VTBL_ENTRY _ZTI7S6500C2[];
extern  VTBL_ENTRY _ZTV7S6500C2[];
Class_Descriptor cd_S6500C2 = {  "S6500C2", // class name
  0,0,//no base classes
  &(vtc_S6500C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S6500C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S6500C2),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6500C5_nt  {
  int s6500c5f0[3];
  void  mf6500c5(); // _ZN10S6500C5_nt8mf6500c5Ev
};
//SIG(-1 S6500C5_nt) C1{ m Fi[3]}


void  S6500C5_nt ::mf6500c5(){}

//skip512 S6500C5_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6500C4_nt  {
  ::S6500C5_nt s6500c4f0;
  ::S6500C5_nt s6500c4f1;
  int s6500c4f2;
  void  mf6500c4(); // _ZN10S6500C4_nt8mf6500c4Ev
};
//SIG(-1 S6500C4_nt) C1{ m FC2{ m Fi[3]} FC2 Fi}


void  S6500C4_nt ::mf6500c4(){}

//skip512 S6500C4_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6500C11_nt  {
  ::S241C14 s6500c11f0;
  void *s6500c11f1;
  int s6500c11f2;
  void  mf6500c11(); // _ZN11S6500C11_nt9mf6500c11Ev
};
//SIG(-1 S6500C11_nt) C1{ m FC2{ BC3{ m Fp Fi[2]}} Fp Fi}


void  S6500C11_nt ::mf6500c11(){}

//skip512 S6500C11_nt

#else // __cplusplus

Class_Descriptor cd_S6500C11_nt = {  "S6500C11_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6500C10_nt  : S6500C11_nt {
};
//SIG(-1 S6500C10_nt) C1{ BC2{ m FC3{ BC4{ m Fp Fi[2]}} Fp Fi}}



//skip512 S6500C10_nt

#else // __cplusplus

extern Class_Descriptor cd_S6500C11_nt;
static Base_Class bases_S6500C10_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S6500C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6500C14_nt  : S241C11_nt {
};
//SIG(-1 S6500C14_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S6500C14_nt

#else // __cplusplus

extern Class_Descriptor cd_S241C11_nt;
static Base_Class bases_S6500C14_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S241C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6500C16  : S241C11_nt {
};
//SIG(-1 S6500C16) C1{ BC2{ m Fp Fi[2]}}



static void Test_S6500C16()
{
  extern Class_Descriptor cd_S6500C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S6500C16, buf);
    S6500C16 &lv = *(new (buf) S6500C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S6500C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S6500C16)");
    check_base_class_offset(lv, (S241C11_nt*), 0, "S6500C16");
    test_class_info(&lv, &cd_S6500C16);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6500C16(Test_S6500C16, "S6500C16", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S241C11_nt;
static Base_Class bases_S6500C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S241C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S6500C16 = {  "S6500C16", // class name
  bases_S6500C16, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6500C18  : S241C11_nt {
};
//SIG(-1 S6500C18) C1{ BC2{ m Fp Fi[2]}}



static void Test_S6500C18()
{
  extern Class_Descriptor cd_S6500C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S6500C18, buf);
    S6500C18 &lv = *(new (buf) S6500C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S6500C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S6500C18)");
    check_base_class_offset(lv, (S241C11_nt*), 0, "S6500C18");
    test_class_info(&lv, &cd_S6500C18);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6500C18(Test_S6500C18, "S6500C18", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S241C11_nt;
static Base_Class bases_S6500C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S241C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S6500C18 = {  "S6500C18", // class name
  bases_S6500C18, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6500C20  : S241C11_nt {
};
//SIG(-1 S6500C20) C1{ BC2{ m Fp Fi[2]}}



static void Test_S6500C20()
{
  extern Class_Descriptor cd_S6500C20;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S6500C20, buf);
    S6500C20 &lv = *(new (buf) S6500C20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S6500C20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S6500C20)");
    check_base_class_offset(lv, (S241C11_nt*), 0, "S6500C20");
    test_class_info(&lv, &cd_S6500C20);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6500C20(Test_S6500C20, "S6500C20", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S241C11_nt;
static Base_Class bases_S6500C20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S241C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S6500C20 = {  "S6500C20", // class name
  bases_S6500C20, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6500C22  : S241C11_nt {
};
//SIG(-1 S6500C22) C1{ BC2{ m Fp Fi[2]}}



static void Test_S6500C22()
{
  extern Class_Descriptor cd_S6500C22;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S6500C22, buf);
    S6500C22 &lv = *(new (buf) S6500C22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S6500C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S6500C22)");
    check_base_class_offset(lv, (S241C11_nt*), 0, "S6500C22");
    test_class_info(&lv, &cd_S6500C22);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6500C22(Test_S6500C22, "S6500C22", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S241C11_nt;
static Base_Class bases_S6500C22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S241C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S6500C22 = {  "S6500C22", // class name
  bases_S6500C22, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6500C27_nt  {
  int s6500c27f0;
  void  mf6500c27(); // _ZN11S6500C27_nt9mf6500c27Ev
};
//SIG(-1 S6500C27_nt) C1{ m Fi}


void  S6500C27_nt ::mf6500c27(){}

//skip512 S6500C27_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI11S6500C27_nt[];
VTBL_ENTRY *P__ZTI11S6500C27_nt = _ZTI11S6500C27_nt; 
Class_Descriptor cd_S6500C27_nt = {  "S6500C27_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI11S6500C27_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6500C28_nt  {
  int s6500c28f0[4];
  void  mf6500c28(); // _ZN11S6500C28_nt9mf6500c28Ev
};
//SIG(-1 S6500C28_nt) C1{ m Fi[4]}


void  S6500C28_nt ::mf6500c28(){}

//skip512 S6500C28_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6500C1  : S6500C2 {
  ::S6500C4_nt s6500c1f0;
  ::S241C22 s6500c1f1;
  ::S6500C5_nt s6500c1f2;
  ::S6500C5_nt s6500c1f3;
  ::S241C18 s6500c1f4;
  int s6500c1f5;
  ::S6500C10_nt s6500c1f6;
  ::S241C10_nt s6500c1f7;
  ::S6500C14_nt s6500c1f8;
  ::S6500C14_nt s6500c1f9;
  char s6500c1f10[2];
  ::S6500C16 s6500c1f11;
  ::S6500C16 s6500c1f12;
  ::S6500C18 s6500c1f13;
  ::S6500C18 s6500c1f14;
  ::S6500C18 s6500c1f15;
  unsigned int s6500c1f16:1;
  unsigned int s6500c1f17:1;
  unsigned int s6500c1f18:1;
  unsigned int s6500c1f19:1;
  unsigned int s6500c1f20:1;
  void *s6500c1f21[2];
  ::S241C7_nt s6500c1f22;
  int s6500c1f23[3];
  ::S6500C20 s6500c1f24;
  ::S6500C20 s6500c1f25;
  ::S6500C22 s6500c1f26;
  ::S6500C22 s6500c1f27;
  int s6500c1f28;
  ::S6500C22 s6500c1f29;
  unsigned int s6500c1f30:1;
  int s6500c1f31;
  ::S6500C22 s6500c1f32;
  ::S6500C18 s6500c1f33;
  unsigned int s6500c1f34:1;
  unsigned int s6500c1f35:1;
  unsigned int s6500c1f36:1;
  int s6500c1f37[13];
  unsigned int s6500c1f38:1;
  unsigned int s6500c1f39:1;
  unsigned int s6500c1f40:1;
  unsigned int s6500c1f41:1;
  ::S6500C22 s6500c1f42;
  unsigned int s6500c1f43:1;
  unsigned int s6500c1f44:1;
  int s6500c1f45[3];
  unsigned int s6500c1f46:1;
  int s6500c1f47[2];
  ::S6500C10_nt s6500c1f48;
  ::S6500C27_nt s6500c1f49;
  ::S6500C28_nt s6500c1f50;
  virtual  ~S6500C1(); // _ZN7S6500C1D1Ev
  virtual void  v1(); // _ZN7S6500C12v1Ev
  virtual void  v2(); // _ZN7S6500C12v2Ev
  virtual void  v3(); // _ZN7S6500C12v3Ev
  virtual void  v4(); // _ZN7S6500C12v4Ev
  virtual void  v5(); // _ZN7S6500C12v5Ev
  virtual void  v6(); // _ZN7S6500C12v6Ev
  virtual void  v7(); // _ZN7S6500C12v7Ev
  virtual void  v8(); // _ZN7S6500C12v8Ev
  virtual void  v9(); // _ZN7S6500C12v9Ev
  virtual void  v10(); // _ZN7S6500C13v10Ev
  virtual void  v11(); // _ZN7S6500C13v11Ev
  virtual void  v12(); // _ZN7S6500C13v12Ev
  virtual void  v13(); // _ZN7S6500C13v13Ev
  virtual void  v14(); // _ZN7S6500C13v14Ev
  S6500C1(); // tgen
};
//SIG(1 S6500C1) C1{ BC2{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 FC4{ m FC5{ m Fi[3]} FC5 Fi} FC6{ BC7{ m Fp Fi[2]}} FC5 FC5 FC8{ BC7} Fi FC9{ BC10{ m FC11{ BC7} Fp Fi}} FC12{ BC7} FC13{ BC7} FC13 Fc[2] FC14{ BC7} FC14 FC15{ BC7} FC15 FC15 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp[2] FC3 Fi[3] FC16{ BC7} FC16 FC17{ BC7} FC17 Fi FC17 Fi:1 Fi FC17 FC15 Fi:1 Fi:1 Fi:1 Fi[13] Fi:1 Fi:1 Fi:1 Fi:1 FC17 Fi:1 Fi:1 Fi[3] Fi:1 Fi[2] FC9 FC18{ m Fi} FC19{ m Fi[4]}}


 S6500C1 ::~S6500C1(){ note_dtor("S6500C1", this);}
void  S6500C1 ::v1(){vfunc_called(this, "_ZN7S6500C12v1Ev");}
void  S6500C1 ::v2(){vfunc_called(this, "_ZN7S6500C12v2Ev");}
void  S6500C1 ::v3(){vfunc_called(this, "_ZN7S6500C12v3Ev");}
void  S6500C1 ::v4(){vfunc_called(this, "_ZN7S6500C12v4Ev");}
void  S6500C1 ::v5(){vfunc_called(this, "_ZN7S6500C12v5Ev");}
void  S6500C1 ::v6(){vfunc_called(this, "_ZN7S6500C12v6Ev");}
void  S6500C1 ::v7(){vfunc_called(this, "_ZN7S6500C12v7Ev");}
void  S6500C1 ::v8(){vfunc_called(this, "_ZN7S6500C12v8Ev");}
void  S6500C1 ::v9(){vfunc_called(this, "_ZN7S6500C12v9Ev");}
void  S6500C1 ::v10(){vfunc_called(this, "_ZN7S6500C13v10Ev");}
void  S6500C1 ::v11(){vfunc_called(this, "_ZN7S6500C13v11Ev");}
void  S6500C1 ::v12(){vfunc_called(this, "_ZN7S6500C13v12Ev");}
void  S6500C1 ::v13(){vfunc_called(this, "_ZN7S6500C13v13Ev");}
void  S6500C1 ::v14(){vfunc_called(this, "_ZN7S6500C13v14Ev");}
S6500C1 ::S6500C1(){ note_ctor("S6500C1", this);} // tgen

static void Test_S6500C1()
{
  extern Class_Descriptor cd_S6500C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(89,133)];
    init_test(&cd_S6500C1, buf);
    S6500C1 *dp, &lv = *(dp=new (buf) S6500C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(704,528), "sizeof(S6500C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S6500C1)");
    check_base_class_offset(lv, (S6500C2*), 0, "S6500C1");
    check_field_offset(lv, s6500c1f0, ABISELECT(96,60), "S6500C1.s6500c1f0");
    check_field_offset(lv, s6500c1f1, ABISELECT(128,88), "S6500C1.s6500c1f1");
    check_field_offset(lv, s6500c1f2, ABISELECT(144,100), "S6500C1.s6500c1f2");
    check_field_offset(lv, s6500c1f3, ABISELECT(156,112), "S6500C1.s6500c1f3");
    check_field_offset(lv, s6500c1f4, ABISELECT(168,124), "S6500C1.s6500c1f4");
    check_field_offset(lv, s6500c1f5, ABISELECT(184,136), "S6500C1.s6500c1f5");
    check_field_offset(lv, s6500c1f6, ABISELECT(192,140), "S6500C1.s6500c1f6");
    check_field_offset(lv, s6500c1f7, ABISELECT(224,160), "S6500C1.s6500c1f7");
    check_field_offset(lv, s6500c1f8, ABISELECT(240,172), "S6500C1.s6500c1f8");
    check_field_offset(lv, s6500c1f9, ABISELECT(256,184), "S6500C1.s6500c1f9");
    check_field_offset(lv, s6500c1f10, ABISELECT(272,196), "S6500C1.s6500c1f10");
    check_field_offset(lv, s6500c1f11, ABISELECT(280,200), "S6500C1.s6500c1f11");
    check_field_offset(lv, s6500c1f12, ABISELECT(296,212), "S6500C1.s6500c1f12");
    check_field_offset(lv, s6500c1f13, ABISELECT(312,224), "S6500C1.s6500c1f13");
    check_field_offset(lv, s6500c1f14, ABISELECT(328,236), "S6500C1.s6500c1f14");
    check_field_offset(lv, s6500c1f15, ABISELECT(344,248), "S6500C1.s6500c1f15");
    set_bf_and_test(lv, s6500c1f16, ABISELECT(360,260), 0, 1, 1, "S6500C1");
    set_bf_and_test(lv, s6500c1f17, ABISELECT(360,260), 1, 1, 1, "S6500C1");
    set_bf_and_test(lv, s6500c1f18, ABISELECT(360,260), 2, 1, 1, "S6500C1");
    set_bf_and_test(lv, s6500c1f19, ABISELECT(360,260), 3, 1, 1, "S6500C1");
    set_bf_and_test(lv, s6500c1f20, ABISELECT(360,260), 4, 1, 1, "S6500C1");
    check_field_offset(lv, s6500c1f21, ABISELECT(368,264), "S6500C1.s6500c1f21");
    check_field_offset(lv, s6500c1f22, ABISELECT(384,272), "S6500C1.s6500c1f22");
    check_field_offset(lv, s6500c1f23, ABISELECT(392,280), "S6500C1.s6500c1f23");
    check_field_offset(lv, s6500c1f24, ABISELECT(408,292), "S6500C1.s6500c1f24");
    check_field_offset(lv, s6500c1f25, ABISELECT(424,304), "S6500C1.s6500c1f25");
    check_field_offset(lv, s6500c1f26, ABISELECT(440,316), "S6500C1.s6500c1f26");
    check_field_offset(lv, s6500c1f27, ABISELECT(456,328), "S6500C1.s6500c1f27");
    check_field_offset(lv, s6500c1f28, ABISELECT(472,340), "S6500C1.s6500c1f28");
    check_field_offset(lv, s6500c1f29, ABISELECT(480,344), "S6500C1.s6500c1f29");
    set_bf_and_test(lv, s6500c1f30, ABISELECT(496,356), 0, 1, 1, "S6500C1");
    check_field_offset(lv, s6500c1f31, ABISELECT(500,360), "S6500C1.s6500c1f31");
    check_field_offset(lv, s6500c1f32, ABISELECT(504,364), "S6500C1.s6500c1f32");
    check_field_offset(lv, s6500c1f33, ABISELECT(520,376), "S6500C1.s6500c1f33");
    set_bf_and_test(lv, s6500c1f34, ABISELECT(536,388), 0, 1, 1, "S6500C1");
    set_bf_and_test(lv, s6500c1f35, ABISELECT(536,388), 1, 1, 1, "S6500C1");
    set_bf_and_test(lv, s6500c1f36, ABISELECT(536,388), 2, 1, 1, "S6500C1");
    check_field_offset(lv, s6500c1f37, ABISELECT(540,392), "S6500C1.s6500c1f37");
    set_bf_and_test(lv, s6500c1f38, ABISELECT(592,444), 0, 1, 1, "S6500C1");
    set_bf_and_test(lv, s6500c1f39, ABISELECT(592,444), 1, 1, 1, "S6500C1");
    set_bf_and_test(lv, s6500c1f40, ABISELECT(592,444), 2, 1, 1, "S6500C1");
    set_bf_and_test(lv, s6500c1f41, ABISELECT(592,444), 3, 1, 1, "S6500C1");
    check_field_offset(lv, s6500c1f42, ABISELECT(600,448), "S6500C1.s6500c1f42");
    set_bf_and_test(lv, s6500c1f43, ABISELECT(616,460), 0, 1, 1, "S6500C1");
    set_bf_and_test(lv, s6500c1f44, ABISELECT(616,460), 1, 1, 1, "S6500C1");
    check_field_offset(lv, s6500c1f45, ABISELECT(620,464), "S6500C1.s6500c1f45");
    set_bf_and_test(lv, s6500c1f46, ABISELECT(632,476), 0, 1, 1, "S6500C1");
    check_field_offset(lv, s6500c1f47, ABISELECT(636,480), "S6500C1.s6500c1f47");
    check_field_offset(lv, s6500c1f48, ABISELECT(648,488), "S6500C1.s6500c1f48");
    check_field_offset(lv, s6500c1f49, ABISELECT(680,508), "S6500C1.s6500c1f49");
    check_field_offset(lv, s6500c1f50, ABISELECT(684,512), "S6500C1.s6500c1f50");
    test_class_info(&lv, &cd_S6500C1);
    dp->~S6500C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6500C1(Test_S6500C1, "S6500C1", ABISELECT(704,528));

#else // __cplusplus

extern void _ZN7S6500C1C1Ev();
extern void _ZN7S6500C1D1Ev();
Name_Map name_map_S6500C1[] = {
  NSPAIR(_ZN7S6500C1C1Ev),
  NSPAIR(_ZN7S6500C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S6500C2;
extern VTBL_ENTRY _ZTI7S6500C2[];
extern  VTBL_ENTRY _ZTV7S6500C2[];
static Base_Class bases_S6500C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S6500C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S6500C1[];
extern void _ZN7S6500C1D1Ev();
extern void _ZN7S6500C1D0Ev();
extern void _ZN7S6500C23v15Ev();
extern void _ZN7S6500C23v16Ev();
extern void _ZN7S6500C23v17Ev();
extern void _ZN7S6500C23v18Ev();
extern void _ZN7S6500C23v19Ev();
extern void _ZN7S6500C23v20Ev();
extern void _ZN7S6500C23v21Ev();
extern void _ZN7S6500C23v22Ev();
extern void _ZN7S6500C23v23Ev();
extern void _ZN7S6500C23v24Ev();
extern void _ZN7S6500C23v25Ev();
extern void _ZN7S6500C23v26Ev();
extern void _ZN7S6500C23v27Ev();
extern void _ZN7S6500C23v28Ev();
extern void _ZN7S6500C23v29Ev();
extern void _ZN7S6500C23v30Ev();
extern void _ZN7S6500C23v31Ev();
extern void _ZN7S6500C23v32Ev();
extern void _ZN7S6500C23v33Ev();
extern void _ZN7S6500C23v34Ev();
extern void _ZN7S6500C23v35Ev();
extern void _ZN7S6500C23v36Ev();
extern void _ZN7S6500C23v37Ev();
extern void _ZN7S6500C23v38Ev();
extern void _ZN7S6500C23v39Ev();
extern void _ZN7S6500C23v40Ev();
extern void _ZN7S6500C23v41Ev();
extern void _ZN7S6500C23v42Ev();
extern void _ZN7S6500C23v43Ev();
extern void _ZN7S6500C23v44Ev();
extern void _ZN7S6500C23v45Ev();
extern void _ZN7S6500C23v46Ev();
extern void _ZN7S6500C23v47Ev();
extern void _ZN7S6500C23v48Ev();
extern void _ZN7S6500C23v49Ev();
extern void _ZN7S6500C23v50Ev();
extern void _ZN7S6500C23v51Ev();
extern void _ZN7S6500C23v52Ev();
extern void _ZN7S6500C23v53Ev();
extern void _ZN7S6500C23v54Ev();
extern void _ZN7S6500C23v55Ev();
extern void _ZN7S6500C23v56Ev();
extern void _ZN7S6500C23v57Ev();
extern void _ZN7S6500C23v58Ev();
extern void _ZN7S6500C23v59Ev();
extern void _ZN7S6500C23v60Ev();
extern void _ZN7S6500C23v61Ev();
extern void _ZN7S6500C23v62Ev();
extern void _ZN7S6500C23v63Ev();
extern void _ZN7S6500C23v64Ev();
extern void _ZN7S6500C23v65Ev();
extern void _ZN7S6500C23v66Ev();
extern void _ZN7S6500C23v67Ev();
extern void _ZN7S6500C23v68Ev();
extern void _ZN7S6500C23v69Ev();
extern void _ZN7S6500C23v70Ev();
extern void _ZN7S6500C23v71Ev();
extern void _ZN7S6500C23v72Ev();
extern void _ZN7S6500C23v73Ev();
extern void _ZN7S6500C23v74Ev();
extern void _ZN7S6500C23v75Ev();
extern void _ZN7S6500C23v76Ev();
extern void _ZN7S6500C23v77Ev();
extern void _ZN7S6500C23v78Ev();
extern void _ZN7S6500C12v1Ev();
extern void _ZN7S6500C12v2Ev();
extern void _ZN7S6500C12v3Ev();
extern void _ZN7S6500C12v4Ev();
extern void _ZN7S6500C12v5Ev();
extern void _ZN7S6500C12v6Ev();
extern void _ZN7S6500C12v7Ev();
extern void _ZN7S6500C12v8Ev();
extern void _ZN7S6500C12v9Ev();
extern void _ZN7S6500C13v10Ev();
extern void _ZN7S6500C13v11Ev();
extern void _ZN7S6500C13v12Ev();
extern void _ZN7S6500C13v13Ev();
extern void _ZN7S6500C13v14Ev();
static  VTBL_ENTRY vtc_S6500C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S6500C1[0]),
  (VTBL_ENTRY)&_ZN7S6500C1D1Ev,
  (VTBL_ENTRY)&_ZN7S6500C1D0Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v15Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v16Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v17Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v18Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v19Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v20Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v21Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v22Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v23Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v24Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v25Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v26Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v27Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v28Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v29Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v30Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v31Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v32Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v33Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v34Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v35Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v36Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v37Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v38Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v39Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v40Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v41Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v42Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v43Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v44Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v45Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v46Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v47Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v48Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v49Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v50Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v51Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v52Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v53Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v54Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v55Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v56Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v57Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v58Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v59Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v60Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v61Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v62Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v63Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v64Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v65Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v66Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v67Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v68Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v69Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v70Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v71Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v72Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v73Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v74Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v75Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v76Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v77Ev,
  (VTBL_ENTRY)&_ZN7S6500C23v78Ev,
  (VTBL_ENTRY)&_ZN7S6500C12v1Ev,
  (VTBL_ENTRY)&_ZN7S6500C12v2Ev,
  (VTBL_ENTRY)&_ZN7S6500C12v3Ev,
  (VTBL_ENTRY)&_ZN7S6500C12v4Ev,
  (VTBL_ENTRY)&_ZN7S6500C12v5Ev,
  (VTBL_ENTRY)&_ZN7S6500C12v6Ev,
  (VTBL_ENTRY)&_ZN7S6500C12v7Ev,
  (VTBL_ENTRY)&_ZN7S6500C12v8Ev,
  (VTBL_ENTRY)&_ZN7S6500C12v9Ev,
  (VTBL_ENTRY)&_ZN7S6500C13v10Ev,
  (VTBL_ENTRY)&_ZN7S6500C13v11Ev,
  (VTBL_ENTRY)&_ZN7S6500C13v12Ev,
  (VTBL_ENTRY)&_ZN7S6500C13v13Ev,
  (VTBL_ENTRY)&_ZN7S6500C13v14Ev,
};
extern VTBL_ENTRY _ZTI7S6500C1[];
extern  VTBL_ENTRY _ZTV7S6500C1[];
Class_Descriptor cd_S6500C1 = {  "S6500C1", // class name
  bases_S6500C1, 1,
  &(vtc_S6500C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(704,528), // object size
  NSPAIRA(_ZTI7S6500C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S6500C1),82, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1640C3  : S3624C3_nt {
  char s1640c3f0;
  int s1640c3f1;
  ::S2005C26 s1640c3f2;
  virtual  ~S1640C3(); // _ZN7S1640C3D1Ev
  virtual void  v10(); // _ZN7S1640C33v10Ev
  virtual void  v11(); // _ZN7S1640C33v11Ev
  S1640C3(); // tgen
};
//SIG(-1 S1640C3) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC6{ m Fp Fi FC7{ m} FC4} Fc} vd v1 v2 Fc Fi FC3}


 S1640C3 ::~S1640C3(){ note_dtor("S1640C3", this);}
void  S1640C3 ::v10(){vfunc_called(this, "_ZN7S1640C33v10Ev");}
void  S1640C3 ::v11(){vfunc_called(this, "_ZN7S1640C33v11Ev");}
S1640C3 ::S1640C3(){ note_ctor("S1640C3", this);} // tgen

static void Test_S1640C3()
{
  extern Class_Descriptor cd_S1640C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,13)];
    init_test(&cd_S1640C3, buf);
    S1640C3 *dp, &lv = *(dp=new (buf) S1640C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,48), "sizeof(S1640C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1640C3)");
    check_base_class_offset(lv, (S3624C3_nt*), 0, "S1640C3");
    check_field_offset(lv, s1640c3f0, ABISELECT(41,29), "S1640C3.s1640c3f0");
    check_field_offset(lv, s1640c3f1, ABISELECT(44,32), "S1640C3.s1640c3f1");
    check_field_offset(lv, s1640c3f2, ABISELECT(48,36), "S1640C3.s1640c3f2");
    test_class_info(&lv, &cd_S1640C3);
    dp->~S1640C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1640C3(Test_S1640C3, "S1640C3", ABISELECT(64,48));

#else // __cplusplus

extern void _ZN7S1640C3C1Ev();
extern void _ZN7S1640C3D1Ev();
Name_Map name_map_S1640C3[] = {
  NSPAIR(_ZN7S1640C3C1Ev),
  NSPAIR(_ZN7S1640C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3624C3_nt;
extern VTBL_ENTRY _ZTI10S3624C3_nt[];
extern  VTBL_ENTRY _ZTV10S3624C3_nt[];
static Base_Class bases_S1640C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3624C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1640C3[];
extern void _ZN7S1640C3D1Ev();
extern void _ZN7S1640C3D0Ev();
extern void _ZN7S1640C33v10Ev();
extern void _ZN7S1640C33v11Ev();
static  VTBL_ENTRY vtc_S1640C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1640C3[0]),
  (VTBL_ENTRY)&_ZN7S1640C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1640C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1640C33v10Ev,
  (VTBL_ENTRY)&_ZN7S1640C33v11Ev,
};
extern VTBL_ENTRY _ZTI7S1640C3[];
extern  VTBL_ENTRY _ZTV7S1640C3[];
Class_Descriptor cd_S1640C3 = {  "S1640C3", // class name
  bases_S1640C3, 1,
  &(vtc_S1640C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,48), // object size
  NSPAIRA(_ZTI7S1640C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1640C3),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1640C14_nt  {
  virtual  ~S1640C14_nt(); // _ZN11S1640C14_ntD1Ev
  virtual void  v12(); // _ZN11S1640C14_nt3v12Ev
  S1640C14_nt(); // tgen
};
//SIG(-1 S1640C14_nt) C1{ vd v1}


 S1640C14_nt ::~S1640C14_nt(){ note_dtor("S1640C14_nt", this);}
void  S1640C14_nt ::v12(){vfunc_called(this, "_ZN11S1640C14_nt3v12Ev");}
S1640C14_nt ::S1640C14_nt(){ note_ctor("S1640C14_nt", this);} // tgen

//skip512 S1640C14_nt

#else // __cplusplus

extern void _ZN11S1640C14_ntC1Ev();
extern void _ZN11S1640C14_ntD1Ev();
Name_Map name_map_S1640C14_nt[] = {
  NSPAIR(_ZN11S1640C14_ntC1Ev),
  NSPAIR(_ZN11S1640C14_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S1640C14_nt[];
extern void _ZN11S1640C14_ntD1Ev();
extern void _ZN11S1640C14_ntD0Ev();
extern void _ZN11S1640C14_nt3v12Ev();
static  VTBL_ENTRY vtc_S1640C14_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S1640C14_nt[0]),
  (VTBL_ENTRY)&_ZN11S1640C14_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S1640C14_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S1640C14_nt3v12Ev,
};
extern VTBL_ENTRY _ZTI11S1640C14_nt[];
VTBL_ENTRY *P__ZTI11S1640C14_nt = _ZTI11S1640C14_nt; 
extern  VTBL_ENTRY _ZTV11S1640C14_nt[];
Class_Descriptor cd_S1640C14_nt = {  "S1640C14_nt", // class name
  0,0,//no base classes
  &(vtc_S1640C14_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S1640C14_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S1640C14_nt),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1640C15  {
  ::S2005C19_nt s1640c15f0;
  void *s1640c15f1[2];
};
//SIG(-1 S1640C15) C1{ FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} Fp[2]}



static void Test_S1640C15()
{
  {
    init_simple_test("S1640C15");
    S1640C15 lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(S1640C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1640C15)");
    check_field_offset(lv, s1640c15f0, 0, "S1640C15.s1640c15f0");
    check_field_offset(lv, s1640c15f1, ABISELECT(24,16), "S1640C15.s1640c15f1");
  }
}
static Arrange_To_Call_Me vS1640C15(Test_S1640C15, "S1640C15", ABISELECT(40,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1640C19_nt  {
  int s1640c19f0[4];
  void *s1640c19f1;
  char s1640c19f2;
  int s1640c19f3[2];
  void *s1640c19f4[2];
  void  mf1640c19(); // _ZN11S1640C19_nt9mf1640c19Ev
};
//SIG(-1 S1640C19_nt) C1{ m Fi[4] Fp Fc Fi[2] Fp[2]}


void  S1640C19_nt ::mf1640c19(){}

//skip512 S1640C19_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1640C2  : S1640C3 , S1640C14_nt {
  ::S1640C15 s1640c2f0;
  void *s1640c2f1;
  ::S2005C19_nt s1640c2f2;
  ::S1640C19_nt s1640c2f3;
  char s1640c2f4[2];
  virtual  ~S1640C2(); // _ZN7S1640C2D1Ev
  virtual void  v13(); // _ZN7S1640C23v13Ev
  virtual void  v14(); // _ZN7S1640C23v14Ev
  virtual void  v15(); // _ZN7S1640C23v15Ev
  virtual void  v16(); // _ZN7S1640C23v16Ev
  virtual void  v17(); // _ZN7S1640C23v17Ev
  virtual void  v18(); // _ZN7S1640C23v18Ev
  virtual void  v19(); // _ZN7S1640C23v19Ev
  virtual void  v20(); // _ZN7S1640C23v20Ev
  virtual void  v21(); // _ZN7S1640C23v21Ev
  S1640C2(); // tgen
};
//SIG(-1 S1640C2) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC6{ m}} FC7{ m Fp Fi FC8{ m} FC5} Fc} vd v10 v11 Fc Fi FC4} BC9{ vd v12} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 FC10{ FC11{ m FC12{ m Fp Fi FC8} Fi} Fp[2]} Fp FC11 FC13{ m Fi[4] Fp Fc Fi[2] Fp[2]} Fc[2]}


 S1640C2 ::~S1640C2(){ note_dtor("S1640C2", this);}
void  S1640C2 ::v13(){vfunc_called(this, "_ZN7S1640C23v13Ev");}
void  S1640C2 ::v14(){vfunc_called(this, "_ZN7S1640C23v14Ev");}
void  S1640C2 ::v15(){vfunc_called(this, "_ZN7S1640C23v15Ev");}
void  S1640C2 ::v16(){vfunc_called(this, "_ZN7S1640C23v16Ev");}
void  S1640C2 ::v17(){vfunc_called(this, "_ZN7S1640C23v17Ev");}
void  S1640C2 ::v18(){vfunc_called(this, "_ZN7S1640C23v18Ev");}
void  S1640C2 ::v19(){vfunc_called(this, "_ZN7S1640C23v19Ev");}
void  S1640C2 ::v20(){vfunc_called(this, "_ZN7S1640C23v20Ev");}
void  S1640C2 ::v21(){vfunc_called(this, "_ZN7S1640C23v21Ev");}
S1640C2 ::S1640C2(){ note_ctor("S1640C2", this);} // tgen

static void Test_S1640C2()
{
  extern Class_Descriptor cd_S1640C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(27,36)];
    init_test(&cd_S1640C2, buf);
    S1640C2 *dp, &lv = *(dp=new (buf) S1640C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,140), "sizeof(S1640C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1640C2)");
    check_base_class_offset(lv, (S3624C3_nt*)(S1640C3*), 0, "S1640C2");
    check_base_class_offset(lv, (S1640C3*), 0, "S1640C2");
    check_base_class_offset(lv, (S1640C14_nt*), ABISELECT(64,48), "S1640C2");
    check_field_offset(lv, s1640c2f0, ABISELECT(72,52), "S1640C2.s1640c2f0");
    check_field_offset(lv, s1640c2f1, ABISELECT(112,76), "S1640C2.s1640c2f1");
    check_field_offset(lv, s1640c2f2, ABISELECT(120,80), "S1640C2.s1640c2f2");
    check_field_offset(lv, s1640c2f3, ABISELECT(144,96), "S1640C2.s1640c2f3");
    check_field_offset(lv, s1640c2f4, ABISELECT(200,136), "S1640C2.s1640c2f4");
    test_class_info(&lv, &cd_S1640C2);
    dp->~S1640C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1640C2(Test_S1640C2, "S1640C2", ABISELECT(208,140));

#else // __cplusplus

extern void _ZN7S1640C2C1Ev();
extern void _ZN7S1640C2D1Ev();
Name_Map name_map_S1640C2[] = {
  NSPAIR(_ZN7S1640C2C1Ev),
  NSPAIR(_ZN7S1640C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3624C3_nt;
extern VTBL_ENTRY _ZTI10S3624C3_nt[];
extern  VTBL_ENTRY _ZTV10S3624C3_nt[];
extern Class_Descriptor cd_S1640C3;
extern VTBL_ENTRY _ZTI7S1640C3[];
extern  VTBL_ENTRY _ZTV7S1640C3[];
extern Class_Descriptor cd_S1640C14_nt;
extern VTBL_ENTRY _ZTI11S1640C14_nt[];
extern  VTBL_ENTRY _ZTV11S1640C14_nt[];
static Base_Class bases_S1640C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3624C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1640C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1640C14_nt,    ABISELECT(64,48), //bcp->offset
    15, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1640C2[];
extern void _ZN7S1640C2D1Ev();
extern void _ZN7S1640C2D0Ev();
extern void _ZN7S1640C33v10Ev();
extern void _ZN7S1640C33v11Ev();
extern void _ZN7S1640C23v13Ev();
extern void _ZN7S1640C23v14Ev();
extern void _ZN7S1640C23v15Ev();
extern void _ZN7S1640C23v16Ev();
extern void _ZN7S1640C23v17Ev();
extern void _ZN7S1640C23v18Ev();
extern void _ZN7S1640C23v19Ev();
extern void _ZN7S1640C23v20Ev();
extern void _ZN7S1640C23v21Ev();
extern void ABISELECT(_ZThn64_N7S1640C2D1Ev,_ZThn48_N7S1640C2D1Ev)();
extern void ABISELECT(_ZThn64_N7S1640C2D0Ev,_ZThn48_N7S1640C2D0Ev)();
extern void _ZN11S1640C14_nt3v12Ev();
static  VTBL_ENTRY vtc_S1640C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1640C2[0]),
  (VTBL_ENTRY)&_ZN7S1640C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1640C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1640C33v10Ev,
  (VTBL_ENTRY)&_ZN7S1640C33v11Ev,
  (VTBL_ENTRY)&_ZN7S1640C23v13Ev,
  (VTBL_ENTRY)&_ZN7S1640C23v14Ev,
  (VTBL_ENTRY)&_ZN7S1640C23v15Ev,
  (VTBL_ENTRY)&_ZN7S1640C23v16Ev,
  (VTBL_ENTRY)&_ZN7S1640C23v17Ev,
  (VTBL_ENTRY)&_ZN7S1640C23v18Ev,
  (VTBL_ENTRY)&_ZN7S1640C23v19Ev,
  (VTBL_ENTRY)&_ZN7S1640C23v20Ev,
  (VTBL_ENTRY)&_ZN7S1640C23v21Ev,
  ABISELECT(-64,-48),
  (VTBL_ENTRY)&(_ZTI7S1640C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S1640C2D1Ev,_ZThn48_N7S1640C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S1640C2D0Ev,_ZThn48_N7S1640C2D0Ev),
  (VTBL_ENTRY)&_ZN11S1640C14_nt3v12Ev,
};
extern VTBL_ENTRY _ZTI7S1640C2[];
extern  VTBL_ENTRY _ZTV7S1640C2[];
Class_Descriptor cd_S1640C2 = {  "S1640C2", // class name
  bases_S1640C2, 3,
  &(vtc_S1640C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(208,140), // object size
  NSPAIRA(_ZTI7S1640C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S1640C2),20, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1640C20_nt  {
  virtual  ~S1640C20_nt(); // _ZN11S1640C20_ntD1Ev
  virtual void  v22(); // _ZN11S1640C20_nt3v22Ev
  virtual void  v23(); // _ZN11S1640C20_nt3v23Ev
  S1640C20_nt(); // tgen
};
//SIG(-1 S1640C20_nt) C1{ vd v1 v2}


 S1640C20_nt ::~S1640C20_nt(){ note_dtor("S1640C20_nt", this);}
void  S1640C20_nt ::v22(){vfunc_called(this, "_ZN11S1640C20_nt3v22Ev");}
void  S1640C20_nt ::v23(){vfunc_called(this, "_ZN11S1640C20_nt3v23Ev");}
S1640C20_nt ::S1640C20_nt(){ note_ctor("S1640C20_nt", this);} // tgen

//skip512 S1640C20_nt

#else // __cplusplus

extern void _ZN11S1640C20_ntC1Ev();
extern void _ZN11S1640C20_ntD1Ev();
Name_Map name_map_S1640C20_nt[] = {
  NSPAIR(_ZN11S1640C20_ntC1Ev),
  NSPAIR(_ZN11S1640C20_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S1640C20_nt[];
extern void _ZN11S1640C20_ntD1Ev();
extern void _ZN11S1640C20_ntD0Ev();
extern void _ZN11S1640C20_nt3v22Ev();
extern void _ZN11S1640C20_nt3v23Ev();
static  VTBL_ENTRY vtc_S1640C20_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S1640C20_nt[0]),
  (VTBL_ENTRY)&_ZN11S1640C20_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S1640C20_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S1640C20_nt3v22Ev,
  (VTBL_ENTRY)&_ZN11S1640C20_nt3v23Ev,
};
extern VTBL_ENTRY _ZTI11S1640C20_nt[];
VTBL_ENTRY *P__ZTI11S1640C20_nt = _ZTI11S1640C20_nt; 
extern  VTBL_ENTRY _ZTV11S1640C20_nt[];
Class_Descriptor cd_S1640C20_nt = {  "S1640C20_nt", // class name
  0,0,//no base classes
  &(vtc_S1640C20_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S1640C20_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S1640C20_nt),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1640C30  {
  char s1640c30f0;
  int s1640c30f1[2];
  ::S2005C13_nt s1640c30f2;
  int s1640c30f3;
  ::S2005C13_nt s1640c30f4;
  ::S2005C13_nt s1640c30f5;
  ::S2005C13_nt s1640c30f6;
  void  mf1640c30(); // _ZN8S1640C309mf1640c30Ev
};
//SIG(-1 S1640C30) C1{ m Fc Fi[2] FC2{ m FC3{ m FL[2]}} Fi FC2 FC2 FC2}


void  S1640C30 ::mf1640c30(){}

static void Test_S1640C30()
{
  {
    init_simple_test("S1640C30");
    S1640C30 lv;
    check2(sizeof(lv), ABISELECT(88,80), "sizeof(S1640C30)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1640C30)");
    check_field_offset(lv, s1640c30f0, 0, "S1640C30.s1640c30f0");
    check_field_offset(lv, s1640c30f1, 4, "S1640C30.s1640c30f1");
    check_field_offset(lv, s1640c30f2, ABISELECT(16,12), "S1640C30.s1640c30f2");
    check_field_offset(lv, s1640c30f3, ABISELECT(32,28), "S1640C30.s1640c30f3");
    check_field_offset(lv, s1640c30f4, ABISELECT(40,32), "S1640C30.s1640c30f4");
    check_field_offset(lv, s1640c30f5, ABISELECT(56,48), "S1640C30.s1640c30f5");
    check_field_offset(lv, s1640c30f6, ABISELECT(72,64), "S1640C30.s1640c30f6");
  }
}
static Arrange_To_Call_Me vS1640C30(Test_S1640C30, "S1640C30", ABISELECT(88,80));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1640C31  {
  ::S2005C13_nt s1640c31f0;
  ::S2005C13_nt s1640c31f1;
  ::S2005C37 s1640c31f2;
  void  mf1640c31(); // _ZN8S1640C319mf1640c31Ev
};
//SIG(-1 S1640C31) C1{ m FC2{ m FC3{ m FL[2]}} FC2 FC4{ m Fp Fi[2] FC5{ m}}}


void  S1640C31 ::mf1640c31(){}

static void Test_S1640C31()
{
  {
    init_simple_test("S1640C31");
    S1640C31 lv;
    check2(sizeof(lv), ABISELECT(56,48), "sizeof(S1640C31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1640C31)");
    check_field_offset(lv, s1640c31f0, 0, "S1640C31.s1640c31f0");
    check_field_offset(lv, s1640c31f1, 16, "S1640C31.s1640c31f1");
    check_field_offset(lv, s1640c31f2, 32, "S1640C31.s1640c31f2");
  }
}
static Arrange_To_Call_Me vS1640C31(Test_S1640C31, "S1640C31", ABISELECT(56,48));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1640C35_nt  {
  __tsi64 s1640c35f0;
  void  mf1640c35(); // _ZN11S1640C35_nt9mf1640c35Ev
};
//SIG(-1 S1640C35_nt) C1{ m FL}


void  S1640C35_nt ::mf1640c35(){}

//skip512 S1640C35_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI11S1640C35_nt[];
VTBL_ENTRY *P__ZTI11S1640C35_nt = _ZTI11S1640C35_nt; 
Class_Descriptor cd_S1640C35_nt = {  "S1640C35_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  8, // object size
  NSPAIRA(_ZTI11S1640C35_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1640C34_nt  {
  ::S1640C35_nt s1640c34f0;
  void  mf1640c34(); // _ZN11S1640C34_nt9mf1640c34Ev
};
//SIG(-1 S1640C34_nt) C1{ m FC2{ m FL}}


void  S1640C34_nt ::mf1640c34(){}

//skip512 S1640C34_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1640C1  : S1640C2 , S1640C20_nt {
  void *s1640c1f0[5];
  int s1640c1f1;
  ::S2005C13_nt s1640c1f2;
  ::S2005C13_nt s1640c1f3;
  void *s1640c1f4;
  ::S3624C10_nt s1640c1f5;
  __tsi64 s1640c1f6;
  void *s1640c1f7;
  ::S3624C33_nt s1640c1f8;
  void *s1640c1f9[3];
  ::S3624C31 s1640c1f10;
  ::S3624C25_nt s1640c1f11;
  char s1640c1f12;
  __tsi64 s1640c1f13;
  int s1640c1f14;
  void *s1640c1f15[8];
  char s1640c1f16;
  __tsi64 s1640c1f17[4];
  ::S3621C33_nt s1640c1f18[4];
  ::S2005C20_nt s1640c1f19[4];
  char s1640c1f20;
  ::S1640C30 s1640c1f21;
  ::S1640C31 s1640c1f22;
  char s1640c1f23[4];
  int s1640c1f24[7];
  ::S1640C34_nt s1640c1f25;
  ::S1640C34_nt s1640c1f26;
  int s1640c1f27[5];
  char s1640c1f28;
  ::S2005C13_nt s1640c1f29;
  ::S2005C13_nt s1640c1f30;
  int s1640c1f31[2];
  void *s1640c1f32[2];
  char s1640c1f33[3];
  void *s1640c1f34;
  int s1640c1f35;
  char s1640c1f36[2];
  int s1640c1f37[3];
  char s1640c1f38[2];
  ::S2005C25 s1640c1f39;
  char s1640c1f40;
  virtual  ~S1640C1(); // _ZN7S1640C1D1Ev
  virtual void  v1(); // _ZN7S1640C12v1Ev
  virtual void  v2(); // _ZN7S1640C12v2Ev
  virtual void  v3(); // _ZN7S1640C12v3Ev
  virtual void  v4(); // _ZN7S1640C12v4Ev
  virtual void  v5(); // _ZN7S1640C12v5Ev
  virtual void  v6(); // _ZN7S1640C12v6Ev
  virtual void  v7(); // _ZN7S1640C12v7Ev
  virtual void  v8(); // _ZN7S1640C12v8Ev
  virtual void  v9(); // _ZN7S1640C12v9Ev
  S1640C1(); // tgen
};
//SIG(1 S1640C1) C1{ BC2{ BC3{ BC4{ vd m FC5{ m Fp Fi FC6{ m} FC7{ m}} FC8{ m Fp Fi FC9{ m} FC6} Fc} vd v10 v11 Fc Fi FC5} BC10{ vd v12} vd v13 v14 v15 v16 v17 v18 v19 v20 v21 FC11{ FC12{ m FC13{ m Fp Fi FC9} Fi} Fp[2]} Fp FC12 FC14{ m Fi[4] Fp Fc Fi[2] Fp[2]} Fc[2]} BC15{ vd v22 v23} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fp[5] Fi FC16{ m FC17{ m FL[2]}} FC16 Fp FC18{ m Fc Fl[2] Fs[12] Fc[5]} FL Fp FC19{ m Fp} Fp[3] FC20{ m Fp Fi[2] FC7} FC21{ m Fp Fi[2] FC22{ m}} Fc FL Fi Fp[8] Fc FL[4] FC23{ Fc FC16 FC16 FC16 Fi[3] Fc Fi}[4] FC13[4] Fc FC24{ m Fc Fi[2] FC16 Fi FC16 FC16 FC16} FC25{ m FC16 FC16 FC26{ m Fp Fi[2] FC22}} Fc[4] Fi[7] FC27{ m FC28{ m FL}} FC27 Fi[5] Fc FC16 FC16 Fi[2] Fp[2] Fc[3] Fp Fi Fc[2] Fi[3] Fc[2] FC29{ BC5} Fc}


 S1640C1 ::~S1640C1(){ note_dtor("S1640C1", this);}
void  S1640C1 ::v1(){vfunc_called(this, "_ZN7S1640C12v1Ev");}
void  S1640C1 ::v2(){vfunc_called(this, "_ZN7S1640C12v2Ev");}
void  S1640C1 ::v3(){vfunc_called(this, "_ZN7S1640C12v3Ev");}
void  S1640C1 ::v4(){vfunc_called(this, "_ZN7S1640C12v4Ev");}
void  S1640C1 ::v5(){vfunc_called(this, "_ZN7S1640C12v5Ev");}
void  S1640C1 ::v6(){vfunc_called(this, "_ZN7S1640C12v6Ev");}
void  S1640C1 ::v7(){vfunc_called(this, "_ZN7S1640C12v7Ev");}
void  S1640C1 ::v8(){vfunc_called(this, "_ZN7S1640C12v8Ev");}
void  S1640C1 ::v9(){vfunc_called(this, "_ZN7S1640C12v9Ev");}
S1640C1 ::S1640C1(){ note_ctor("S1640C1", this);} // tgen

static void Test_S1640C1()
{
  extern Class_Descriptor cd_S1640C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(165,258)];
    init_test(&cd_S1640C1, buf);
    S1640C1 *dp, &lv = *(dp=new (buf) S1640C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1312,1028), "sizeof(S1640C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1640C1)");
    check_base_class_offset(lv, (S3624C3_nt*)(S1640C3*)(S1640C2*), 0, "S1640C1");
    check_base_class_offset(lv, (S1640C3*)(S1640C2*), 0, "S1640C1");
    check_base_class_offset(lv, (S1640C14_nt*)(S1640C2*), ABISELECT(64,48), "S1640C1");
    check_base_class_offset(lv, (S1640C2*), 0, "S1640C1");
    check_base_class_offset(lv, (S1640C20_nt*), ABISELECT(208,140), "S1640C1");
    check_field_offset(lv, s1640c1f0, ABISELECT(216,144), "S1640C1.s1640c1f0");
    check_field_offset(lv, s1640c1f1, ABISELECT(256,164), "S1640C1.s1640c1f1");
    check_field_offset(lv, s1640c1f2, ABISELECT(264,168), "S1640C1.s1640c1f2");
    check_field_offset(lv, s1640c1f3, ABISELECT(280,184), "S1640C1.s1640c1f3");
    check_field_offset(lv, s1640c1f4, ABISELECT(296,200), "S1640C1.s1640c1f4");
    check_field_offset(lv, s1640c1f5, ABISELECT(304,204), "S1640C1.s1640c1f5");
    check_field_offset(lv, s1640c1f6, ABISELECT(360,248), "S1640C1.s1640c1f6");
    check_field_offset(lv, s1640c1f7, ABISELECT(368,256), "S1640C1.s1640c1f7");
    check_field_offset(lv, s1640c1f8, ABISELECT(376,260), "S1640C1.s1640c1f8");
    check_field_offset(lv, s1640c1f9, ABISELECT(384,264), "S1640C1.s1640c1f9");
    check_field_offset(lv, s1640c1f10, ABISELECT(408,276), "S1640C1.s1640c1f10");
    check_field_offset(lv, s1640c1f11, ABISELECT(432,292), "S1640C1.s1640c1f11");
    check_field_offset(lv, s1640c1f12, ABISELECT(456,308), "S1640C1.s1640c1f12");
    check_field_offset(lv, s1640c1f13, ABISELECT(464,312), "S1640C1.s1640c1f13");
    check_field_offset(lv, s1640c1f14, ABISELECT(472,320), "S1640C1.s1640c1f14");
    check_field_offset(lv, s1640c1f15, ABISELECT(480,324), "S1640C1.s1640c1f15");
    check_field_offset(lv, s1640c1f16, ABISELECT(544,356), "S1640C1.s1640c1f16");
    check_field_offset(lv, s1640c1f17, ABISELECT(552,360), "S1640C1.s1640c1f17");
    check_field_offset(lv, s1640c1f18, ABISELECT(584,392), "S1640C1.s1640c1f18");
    check_field_offset(lv, s1640c1f19, ABISELECT(904,680), "S1640C1.s1640c1f19");
    check_field_offset(lv, s1640c1f20, ABISELECT(968,728), "S1640C1.s1640c1f20");
    check_field_offset(lv, s1640c1f21, ABISELECT(976,732), "S1640C1.s1640c1f21");
    check_field_offset(lv, s1640c1f22, ABISELECT(1064,812), "S1640C1.s1640c1f22");
    check_field_offset(lv, s1640c1f23, ABISELECT(1120,860), "S1640C1.s1640c1f23");
    check_field_offset(lv, s1640c1f24, ABISELECT(1124,864), "S1640C1.s1640c1f24");
    check_field_offset(lv, s1640c1f25, ABISELECT(1152,892), "S1640C1.s1640c1f25");
    check_field_offset(lv, s1640c1f26, ABISELECT(1160,900), "S1640C1.s1640c1f26");
    check_field_offset(lv, s1640c1f27, ABISELECT(1168,908), "S1640C1.s1640c1f27");
    check_field_offset(lv, s1640c1f28, ABISELECT(1188,928), "S1640C1.s1640c1f28");
    check_field_offset(lv, s1640c1f29, ABISELECT(1192,932), "S1640C1.s1640c1f29");
    check_field_offset(lv, s1640c1f30, ABISELECT(1208,948), "S1640C1.s1640c1f30");
    check_field_offset(lv, s1640c1f31, ABISELECT(1224,964), "S1640C1.s1640c1f31");
    check_field_offset(lv, s1640c1f32, ABISELECT(1232,972), "S1640C1.s1640c1f32");
    check_field_offset(lv, s1640c1f33, ABISELECT(1248,980), "S1640C1.s1640c1f33");
    check_field_offset(lv, s1640c1f34, ABISELECT(1256,984), "S1640C1.s1640c1f34");
    check_field_offset(lv, s1640c1f35, ABISELECT(1264,988), "S1640C1.s1640c1f35");
    check_field_offset(lv, s1640c1f36, ABISELECT(1268,992), "S1640C1.s1640c1f36");
    check_field_offset(lv, s1640c1f37, ABISELECT(1272,996), "S1640C1.s1640c1f37");
    check_field_offset(lv, s1640c1f38, ABISELECT(1284,1008), "S1640C1.s1640c1f38");
    check_field_offset(lv, s1640c1f39, ABISELECT(1288,1012), "S1640C1.s1640c1f39");
    check_field_offset(lv, s1640c1f40, ABISELECT(1304,1024), "S1640C1.s1640c1f40");
    test_class_info(&lv, &cd_S1640C1);
    dp->~S1640C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1640C1(Test_S1640C1, "S1640C1", ABISELECT(1312,1028));

#else // __cplusplus

extern void _ZN7S1640C1C1Ev();
extern void _ZN7S1640C1D1Ev();
Name_Map name_map_S1640C1[] = {
  NSPAIR(_ZN7S1640C1C1Ev),
  NSPAIR(_ZN7S1640C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3624C3_nt;
extern VTBL_ENTRY _ZTI10S3624C3_nt[];
extern  VTBL_ENTRY _ZTV10S3624C3_nt[];
extern Class_Descriptor cd_S1640C3;
extern VTBL_ENTRY _ZTI7S1640C3[];
extern  VTBL_ENTRY _ZTV7S1640C3[];
extern Class_Descriptor cd_S1640C14_nt;
extern VTBL_ENTRY _ZTI11S1640C14_nt[];
extern  VTBL_ENTRY _ZTV11S1640C14_nt[];
extern Class_Descriptor cd_S1640C2;
extern VTBL_ENTRY _ZTI7S1640C2[];
extern  VTBL_ENTRY _ZTV7S1640C2[];
extern Class_Descriptor cd_S1640C20_nt;
extern VTBL_ENTRY _ZTI11S1640C20_nt[];
extern  VTBL_ENTRY _ZTV11S1640C20_nt[];
static Base_Class bases_S1640C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3624C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1640C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1640C14_nt,    ABISELECT(64,48), //bcp->offset
    24, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1640C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1640C20_nt,    ABISELECT(208,140), //bcp->offset
    29, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1640C1[];
extern void _ZN7S1640C1D1Ev();
extern void _ZN7S1640C1D0Ev();
extern void _ZN7S1640C33v10Ev();
extern void _ZN7S1640C33v11Ev();
extern void _ZN7S1640C23v13Ev();
extern void _ZN7S1640C23v14Ev();
extern void _ZN7S1640C23v15Ev();
extern void _ZN7S1640C23v16Ev();
extern void _ZN7S1640C23v17Ev();
extern void _ZN7S1640C23v18Ev();
extern void _ZN7S1640C23v19Ev();
extern void _ZN7S1640C23v20Ev();
extern void _ZN7S1640C23v21Ev();
extern void _ZN7S1640C12v1Ev();
extern void _ZN7S1640C12v2Ev();
extern void _ZN7S1640C12v3Ev();
extern void _ZN7S1640C12v4Ev();
extern void _ZN7S1640C12v5Ev();
extern void _ZN7S1640C12v6Ev();
extern void _ZN7S1640C12v7Ev();
extern void _ZN7S1640C12v8Ev();
extern void _ZN7S1640C12v9Ev();
extern void ABISELECT(_ZThn64_N7S1640C1D1Ev,_ZThn48_N7S1640C1D1Ev)();
extern void ABISELECT(_ZThn64_N7S1640C1D0Ev,_ZThn48_N7S1640C1D0Ev)();
extern void _ZN11S1640C14_nt3v12Ev();
extern void ABISELECT(_ZThn208_N7S1640C1D1Ev,_ZThn140_N7S1640C1D1Ev)();
extern void ABISELECT(_ZThn208_N7S1640C1D0Ev,_ZThn140_N7S1640C1D0Ev)();
extern void _ZN11S1640C20_nt3v22Ev();
extern void _ZN11S1640C20_nt3v23Ev();
static  VTBL_ENTRY vtc_S1640C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1640C1[0]),
  (VTBL_ENTRY)&_ZN7S1640C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1640C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1640C33v10Ev,
  (VTBL_ENTRY)&_ZN7S1640C33v11Ev,
  (VTBL_ENTRY)&_ZN7S1640C23v13Ev,
  (VTBL_ENTRY)&_ZN7S1640C23v14Ev,
  (VTBL_ENTRY)&_ZN7S1640C23v15Ev,
  (VTBL_ENTRY)&_ZN7S1640C23v16Ev,
  (VTBL_ENTRY)&_ZN7S1640C23v17Ev,
  (VTBL_ENTRY)&_ZN7S1640C23v18Ev,
  (VTBL_ENTRY)&_ZN7S1640C23v19Ev,
  (VTBL_ENTRY)&_ZN7S1640C23v20Ev,
  (VTBL_ENTRY)&_ZN7S1640C23v21Ev,
  (VTBL_ENTRY)&_ZN7S1640C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1640C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1640C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1640C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1640C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1640C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1640C12v7Ev,
  (VTBL_ENTRY)&_ZN7S1640C12v8Ev,
  (VTBL_ENTRY)&_ZN7S1640C12v9Ev,
  ABISELECT(-64,-48),
  (VTBL_ENTRY)&(_ZTI7S1640C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S1640C1D1Ev,_ZThn48_N7S1640C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S1640C1D0Ev,_ZThn48_N7S1640C1D0Ev),
  (VTBL_ENTRY)&_ZN11S1640C14_nt3v12Ev,
  ABISELECT(-208,-140),
  (VTBL_ENTRY)&(_ZTI7S1640C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N7S1640C1D1Ev,_ZThn140_N7S1640C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N7S1640C1D0Ev,_ZThn140_N7S1640C1D0Ev),
  (VTBL_ENTRY)&_ZN11S1640C20_nt3v22Ev,
  (VTBL_ENTRY)&_ZN11S1640C20_nt3v23Ev,
};
extern VTBL_ENTRY _ZTI7S1640C1[];
extern  VTBL_ENTRY _ZTV7S1640C1[];
Class_Descriptor cd_S1640C1 = {  "S1640C1", // class name
  bases_S1640C1, 5,
  &(vtc_S1640C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1312,1028), // object size
  NSPAIRA(_ZTI7S1640C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S1640C1),35, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1416C4  {
  int s1416c4f0;
  __tsi64 s1416c4f1;
  void *s1416c4f2[4];
  int s1416c4f3[2];
  void *s1416c4f4;
  ::S241C7_nt s1416c4f5;
  void *s1416c4f6[2];
  virtual  ~S1416C4(); // _ZN7S1416C4D1Ev
  virtual void  v4(); // _ZN7S1416C42v4Ev
  virtual void  v5(); // _ZN7S1416C42v5Ev
  virtual void  v6(); // _ZN7S1416C42v6Ev
  virtual void  v7(); // _ZN7S1416C42v7Ev
  virtual void  v8(); // _ZN7S1416C42v8Ev
  virtual void  v9(); // _ZN7S1416C42v9Ev
  virtual void  v10(); // _ZN7S1416C43v10Ev
  virtual void  v11(); // _ZN7S1416C43v11Ev
  virtual void  v12(); // _ZN7S1416C43v12Ev
  virtual void  v13(); // _ZN7S1416C43v13Ev
  virtual void  v14(); // _ZN7S1416C43v14Ev
  virtual void  v15(); // _ZN7S1416C43v15Ev
  virtual void  v16(); // _ZN7S1416C43v16Ev
  virtual void  v17(); // _ZN7S1416C43v17Ev
  virtual void  v18(); // _ZN7S1416C43v18Ev
  virtual void  v19(); // _ZN7S1416C43v19Ev
  virtual void  v20(); // _ZN7S1416C43v20Ev
  virtual void  v21(); // _ZN7S1416C43v21Ev
  virtual void  v22(); // _ZN7S1416C43v22Ev
  virtual void  v23(); // _ZN7S1416C43v23Ev
  virtual void  v24(); // _ZN7S1416C43v24Ev
  virtual void  v25(); // _ZN7S1416C43v25Ev
  virtual void  v26(); // _ZN7S1416C43v26Ev
  virtual void  v27(); // _ZN7S1416C43v27Ev
  virtual void  v28(); // _ZN7S1416C43v28Ev
  virtual void  v29(); // _ZN7S1416C43v29Ev
  virtual void  v30(); // _ZN7S1416C43v30Ev
  virtual void  v31(); // _ZN7S1416C43v31Ev
  virtual void  v32(); // _ZN7S1416C43v32Ev
  virtual void  v33(); // _ZN7S1416C43v33Ev
  virtual void  v34(); // _ZN7S1416C43v34Ev
  virtual void  v35(); // _ZN7S1416C43v35Ev
  virtual void  v36(); // _ZN7S1416C43v36Ev
  virtual void  v37(); // _ZN7S1416C43v37Ev
  virtual void  v38(); // _ZN7S1416C43v38Ev
  virtual void  v39(); // _ZN7S1416C43v39Ev
  virtual void  v40(); // _ZN7S1416C43v40Ev
  virtual void  v41(); // _ZN7S1416C43v41Ev
  virtual void  v42(); // _ZN7S1416C43v42Ev
  virtual void  v43(); // _ZN7S1416C43v43Ev
  virtual void  v44(); // _ZN7S1416C43v44Ev
  virtual void  v45(); // _ZN7S1416C43v45Ev
  virtual void  v46(); // _ZN7S1416C43v46Ev
  virtual void  v47(); // _ZN7S1416C43v47Ev
  virtual void  v48(); // _ZN7S1416C43v48Ev
  virtual void  v49(); // _ZN7S1416C43v49Ev
  virtual void  v50(); // _ZN7S1416C43v50Ev
  virtual void  v51(); // _ZN7S1416C43v51Ev
  virtual void  v52(); // _ZN7S1416C43v52Ev
  virtual void  v53(); // _ZN7S1416C43v53Ev
  virtual void  v54(); // _ZN7S1416C43v54Ev
  virtual void  v55(); // _ZN7S1416C43v55Ev
  virtual void  v56(); // _ZN7S1416C43v56Ev
  virtual void  v57(); // _ZN7S1416C43v57Ev
  virtual void  v58(); // _ZN7S1416C43v58Ev
  virtual void  v59(); // _ZN7S1416C43v59Ev
  virtual void  v60(); // _ZN7S1416C43v60Ev
  virtual void  v61(); // _ZN7S1416C43v61Ev
  virtual void  v62(); // _ZN7S1416C43v62Ev
  virtual void  v63(); // _ZN7S1416C43v63Ev
  virtual void  v64(); // _ZN7S1416C43v64Ev
  virtual void  v65(); // _ZN7S1416C43v65Ev
  virtual void  v66(); // _ZN7S1416C43v66Ev
  virtual void  v67(); // _ZN7S1416C43v67Ev
  S1416C4(); // tgen
};
//SIG(-1 S1416C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1416C4 ::~S1416C4(){ note_dtor("S1416C4", this);}
void  S1416C4 ::v4(){vfunc_called(this, "_ZN7S1416C42v4Ev");}
void  S1416C4 ::v5(){vfunc_called(this, "_ZN7S1416C42v5Ev");}
void  S1416C4 ::v6(){vfunc_called(this, "_ZN7S1416C42v6Ev");}
void  S1416C4 ::v7(){vfunc_called(this, "_ZN7S1416C42v7Ev");}
void  S1416C4 ::v8(){vfunc_called(this, "_ZN7S1416C42v8Ev");}
void  S1416C4 ::v9(){vfunc_called(this, "_ZN7S1416C42v9Ev");}
void  S1416C4 ::v10(){vfunc_called(this, "_ZN7S1416C43v10Ev");}
void  S1416C4 ::v11(){vfunc_called(this, "_ZN7S1416C43v11Ev");}
void  S1416C4 ::v12(){vfunc_called(this, "_ZN7S1416C43v12Ev");}
void  S1416C4 ::v13(){vfunc_called(this, "_ZN7S1416C43v13Ev");}
void  S1416C4 ::v14(){vfunc_called(this, "_ZN7S1416C43v14Ev");}
void  S1416C4 ::v15(){vfunc_called(this, "_ZN7S1416C43v15Ev");}
void  S1416C4 ::v16(){vfunc_called(this, "_ZN7S1416C43v16Ev");}
void  S1416C4 ::v17(){vfunc_called(this, "_ZN7S1416C43v17Ev");}
void  S1416C4 ::v18(){vfunc_called(this, "_ZN7S1416C43v18Ev");}
void  S1416C4 ::v19(){vfunc_called(this, "_ZN7S1416C43v19Ev");}
void  S1416C4 ::v20(){vfunc_called(this, "_ZN7S1416C43v20Ev");}
void  S1416C4 ::v21(){vfunc_called(this, "_ZN7S1416C43v21Ev");}
void  S1416C4 ::v22(){vfunc_called(this, "_ZN7S1416C43v22Ev");}
void  S1416C4 ::v23(){vfunc_called(this, "_ZN7S1416C43v23Ev");}
void  S1416C4 ::v24(){vfunc_called(this, "_ZN7S1416C43v24Ev");}
void  S1416C4 ::v25(){vfunc_called(this, "_ZN7S1416C43v25Ev");}
void  S1416C4 ::v26(){vfunc_called(this, "_ZN7S1416C43v26Ev");}
void  S1416C4 ::v27(){vfunc_called(this, "_ZN7S1416C43v27Ev");}
void  S1416C4 ::v28(){vfunc_called(this, "_ZN7S1416C43v28Ev");}
void  S1416C4 ::v29(){vfunc_called(this, "_ZN7S1416C43v29Ev");}
void  S1416C4 ::v30(){vfunc_called(this, "_ZN7S1416C43v30Ev");}
void  S1416C4 ::v31(){vfunc_called(this, "_ZN7S1416C43v31Ev");}
void  S1416C4 ::v32(){vfunc_called(this, "_ZN7S1416C43v32Ev");}
void  S1416C4 ::v33(){vfunc_called(this, "_ZN7S1416C43v33Ev");}
void  S1416C4 ::v34(){vfunc_called(this, "_ZN7S1416C43v34Ev");}
void  S1416C4 ::v35(){vfunc_called(this, "_ZN7S1416C43v35Ev");}
void  S1416C4 ::v36(){vfunc_called(this, "_ZN7S1416C43v36Ev");}
void  S1416C4 ::v37(){vfunc_called(this, "_ZN7S1416C43v37Ev");}
void  S1416C4 ::v38(){vfunc_called(this, "_ZN7S1416C43v38Ev");}
void  S1416C4 ::v39(){vfunc_called(this, "_ZN7S1416C43v39Ev");}
void  S1416C4 ::v40(){vfunc_called(this, "_ZN7S1416C43v40Ev");}
void  S1416C4 ::v41(){vfunc_called(this, "_ZN7S1416C43v41Ev");}
void  S1416C4 ::v42(){vfunc_called(this, "_ZN7S1416C43v42Ev");}
void  S1416C4 ::v43(){vfunc_called(this, "_ZN7S1416C43v43Ev");}
void  S1416C4 ::v44(){vfunc_called(this, "_ZN7S1416C43v44Ev");}
void  S1416C4 ::v45(){vfunc_called(this, "_ZN7S1416C43v45Ev");}
void  S1416C4 ::v46(){vfunc_called(this, "_ZN7S1416C43v46Ev");}
void  S1416C4 ::v47(){vfunc_called(this, "_ZN7S1416C43v47Ev");}
void  S1416C4 ::v48(){vfunc_called(this, "_ZN7S1416C43v48Ev");}
void  S1416C4 ::v49(){vfunc_called(this, "_ZN7S1416C43v49Ev");}
void  S1416C4 ::v50(){vfunc_called(this, "_ZN7S1416C43v50Ev");}
void  S1416C4 ::v51(){vfunc_called(this, "_ZN7S1416C43v51Ev");}
void  S1416C4 ::v52(){vfunc_called(this, "_ZN7S1416C43v52Ev");}
void  S1416C4 ::v53(){vfunc_called(this, "_ZN7S1416C43v53Ev");}
void  S1416C4 ::v54(){vfunc_called(this, "_ZN7S1416C43v54Ev");}
void  S1416C4 ::v55(){vfunc_called(this, "_ZN7S1416C43v55Ev");}
void  S1416C4 ::v56(){vfunc_called(this, "_ZN7S1416C43v56Ev");}
void  S1416C4 ::v57(){vfunc_called(this, "_ZN7S1416C43v57Ev");}
void  S1416C4 ::v58(){vfunc_called(this, "_ZN7S1416C43v58Ev");}
void  S1416C4 ::v59(){vfunc_called(this, "_ZN7S1416C43v59Ev");}
void  S1416C4 ::v60(){vfunc_called(this, "_ZN7S1416C43v60Ev");}
void  S1416C4 ::v61(){vfunc_called(this, "_ZN7S1416C43v61Ev");}
void  S1416C4 ::v62(){vfunc_called(this, "_ZN7S1416C43v62Ev");}
void  S1416C4 ::v63(){vfunc_called(this, "_ZN7S1416C43v63Ev");}
void  S1416C4 ::v64(){vfunc_called(this, "_ZN7S1416C43v64Ev");}
void  S1416C4 ::v65(){vfunc_called(this, "_ZN7S1416C43v65Ev");}
void  S1416C4 ::v66(){vfunc_called(this, "_ZN7S1416C43v66Ev");}
void  S1416C4 ::v67(){vfunc_called(this, "_ZN7S1416C43v67Ev");}
S1416C4 ::S1416C4(){ note_ctor("S1416C4", this);} // tgen

static void Test_S1416C4()
{
  extern Class_Descriptor cd_S1416C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1416C4, buf);
    S1416C4 *dp, &lv = *(dp=new (buf) S1416C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1416C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1416C4)");
    check_field_offset(lv, s1416c4f0, ABISELECT(8,4), "S1416C4.s1416c4f0");
    check_field_offset(lv, s1416c4f1, ABISELECT(16,8), "S1416C4.s1416c4f1");
    check_field_offset(lv, s1416c4f2, ABISELECT(24,16), "S1416C4.s1416c4f2");
    check_field_offset(lv, s1416c4f3, ABISELECT(56,32), "S1416C4.s1416c4f3");
    check_field_offset(lv, s1416c4f4, ABISELECT(64,40), "S1416C4.s1416c4f4");
    check_field_offset(lv, s1416c4f5, ABISELECT(72,44), "S1416C4.s1416c4f5");
    check_field_offset(lv, s1416c4f6, ABISELECT(80,52), "S1416C4.s1416c4f6");
    test_class_info(&lv, &cd_S1416C4);
    dp->~S1416C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1416C4(Test_S1416C4, "S1416C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1416C4C1Ev();
extern void _ZN7S1416C4D1Ev();
Name_Map name_map_S1416C4[] = {
  NSPAIR(_ZN7S1416C4C1Ev),
  NSPAIR(_ZN7S1416C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1416C4[];
extern void _ZN7S1416C4D1Ev();
extern void _ZN7S1416C4D0Ev();
extern void _ZN7S1416C42v4Ev();
extern void _ZN7S1416C42v5Ev();
extern void _ZN7S1416C42v6Ev();
extern void _ZN7S1416C42v7Ev();
extern void _ZN7S1416C42v8Ev();
extern void _ZN7S1416C42v9Ev();
extern void _ZN7S1416C43v10Ev();
extern void _ZN7S1416C43v11Ev();
extern void _ZN7S1416C43v12Ev();
extern void _ZN7S1416C43v13Ev();
extern void _ZN7S1416C43v14Ev();
extern void _ZN7S1416C43v15Ev();
extern void _ZN7S1416C43v16Ev();
extern void _ZN7S1416C43v17Ev();
extern void _ZN7S1416C43v18Ev();
extern void _ZN7S1416C43v19Ev();
extern void _ZN7S1416C43v20Ev();
extern void _ZN7S1416C43v21Ev();
extern void _ZN7S1416C43v22Ev();
extern void _ZN7S1416C43v23Ev();
extern void _ZN7S1416C43v24Ev();
extern void _ZN7S1416C43v25Ev();
extern void _ZN7S1416C43v26Ev();
extern void _ZN7S1416C43v27Ev();
extern void _ZN7S1416C43v28Ev();
extern void _ZN7S1416C43v29Ev();
extern void _ZN7S1416C43v30Ev();
extern void _ZN7S1416C43v31Ev();
extern void _ZN7S1416C43v32Ev();
extern void _ZN7S1416C43v33Ev();
extern void _ZN7S1416C43v34Ev();
extern void _ZN7S1416C43v35Ev();
extern void _ZN7S1416C43v36Ev();
extern void _ZN7S1416C43v37Ev();
extern void _ZN7S1416C43v38Ev();
extern void _ZN7S1416C43v39Ev();
extern void _ZN7S1416C43v40Ev();
extern void _ZN7S1416C43v41Ev();
extern void _ZN7S1416C43v42Ev();
extern void _ZN7S1416C43v43Ev();
extern void _ZN7S1416C43v44Ev();
extern void _ZN7S1416C43v45Ev();
extern void _ZN7S1416C43v46Ev();
extern void _ZN7S1416C43v47Ev();
extern void _ZN7S1416C43v48Ev();
extern void _ZN7S1416C43v49Ev();
extern void _ZN7S1416C43v50Ev();
extern void _ZN7S1416C43v51Ev();
extern void _ZN7S1416C43v52Ev();
extern void _ZN7S1416C43v53Ev();
extern void _ZN7S1416C43v54Ev();
extern void _ZN7S1416C43v55Ev();
extern void _ZN7S1416C43v56Ev();
extern void _ZN7S1416C43v57Ev();
extern void _ZN7S1416C43v58Ev();
extern void _ZN7S1416C43v59Ev();
extern void _ZN7S1416C43v60Ev();
extern void _ZN7S1416C43v61Ev();
extern void _ZN7S1416C43v62Ev();
extern void _ZN7S1416C43v63Ev();
extern void _ZN7S1416C43v64Ev();
extern void _ZN7S1416C43v65Ev();
extern void _ZN7S1416C43v66Ev();
extern void _ZN7S1416C43v67Ev();
static  VTBL_ENTRY vtc_S1416C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1416C4[0]),
  (VTBL_ENTRY)&_ZN7S1416C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1416C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1416C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1416C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1416C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1416C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1416C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1416C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v67Ev,
};
extern VTBL_ENTRY _ZTI7S1416C4[];
extern  VTBL_ENTRY _ZTV7S1416C4[];
Class_Descriptor cd_S1416C4 = {  "S1416C4", // class name
  0,0,//no base classes
  &(vtc_S1416C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1416C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1416C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1416C11_nt  {
  ::S6500C28_nt s1416c11f0;
  ::S6500C5_nt s1416c11f1;
  int s1416c11f2;
  void  mf1416c11(); // _ZN11S1416C11_nt9mf1416c11Ev
};
//SIG(-1 S1416C11_nt) C1{ m FC2{ m Fi[4]} FC3{ m Fi[3]} Fi}


void  S1416C11_nt ::mf1416c11(){}

//skip512 S1416C11_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1416C3_nt  : S1416C4 {
  void *s1416c3f0;
  ::S241C21 s1416c3f1;
  ::S241C7_nt s1416c3f2;
  ::S241C17 s1416c3f3;
  ::S1416C11_nt s1416c3f4;
  int s1416c3f5;
  unsigned int s1416c3f6:1;
  unsigned int s1416c3f7:1;
  unsigned int s1416c3f8:1;
  unsigned int s1416c3f9:1;
  int s1416c3f10[11];
  virtual  ~S1416C3_nt(); // _ZN10S1416C3_ntD1Ev
  virtual void  v68(); // _ZN10S1416C3_nt3v68Ev
  virtual void  v69(); // _ZN10S1416C3_nt3v69Ev
  virtual void  v70(); // _ZN10S1416C3_nt3v70Ev
  virtual void  v71(); // _ZN10S1416C3_nt3v71Ev
  virtual void  v72(); // _ZN10S1416C3_nt3v72Ev
  virtual void  v73(); // _ZN10S1416C3_nt3v73Ev
  virtual void  v74(); // _ZN10S1416C3_nt3v74Ev
  virtual void  v75(); // _ZN10S1416C3_nt3v75Ev
  virtual void  v76(); // _ZN10S1416C3_nt3v76Ev
  virtual void  v77(); // _ZN10S1416C3_nt3v77Ev
  virtual void  v78(); // _ZN10S1416C3_nt3v78Ev
  virtual void  v79(); // _ZN10S1416C3_nt3v79Ev
  virtual void  v80(); // _ZN10S1416C3_nt3v80Ev
  virtual void  v81(); // _ZN10S1416C3_nt3v81Ev
  virtual void  v82(); // _ZN10S1416C3_nt3v82Ev
  virtual void  v83(); // _ZN10S1416C3_nt3v83Ev
  virtual void  v84(); // _ZN10S1416C3_nt3v84Ev
  virtual void  v85(); // _ZN10S1416C3_nt3v85Ev
  virtual void  v86(); // _ZN10S1416C3_nt3v86Ev
  virtual void  v87(); // _ZN10S1416C3_nt3v87Ev
  virtual void  v88(); // _ZN10S1416C3_nt3v88Ev
  virtual void  v89(); // _ZN10S1416C3_nt3v89Ev
  virtual void  v90(); // _ZN10S1416C3_nt3v90Ev
  virtual void  v91(); // _ZN10S1416C3_nt3v91Ev
  virtual void  v92(); // _ZN10S1416C3_nt3v92Ev
  virtual void  v93(); // _ZN10S1416C3_nt3v93Ev
  virtual void  v94(); // _ZN10S1416C3_nt3v94Ev
  S1416C3_nt(); // tgen
};
//SIG(-1 S1416C3_nt) C1{ BC2{ vd v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 Fp FC4{ BC5{ BC6{ m Fp Fi[2]}}} FC3 FC7{ BC8{ BC6}} FC9{ m FC10{ m Fi[4]} FC11{ m Fi[3]} Fi} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi[11]}


 S1416C3_nt ::~S1416C3_nt(){ note_dtor("S1416C3_nt", this);}
void  S1416C3_nt ::v68(){vfunc_called(this, "_ZN10S1416C3_nt3v68Ev");}
void  S1416C3_nt ::v69(){vfunc_called(this, "_ZN10S1416C3_nt3v69Ev");}
void  S1416C3_nt ::v70(){vfunc_called(this, "_ZN10S1416C3_nt3v70Ev");}
void  S1416C3_nt ::v71(){vfunc_called(this, "_ZN10S1416C3_nt3v71Ev");}
void  S1416C3_nt ::v72(){vfunc_called(this, "_ZN10S1416C3_nt3v72Ev");}
void  S1416C3_nt ::v73(){vfunc_called(this, "_ZN10S1416C3_nt3v73Ev");}
void  S1416C3_nt ::v74(){vfunc_called(this, "_ZN10S1416C3_nt3v74Ev");}
void  S1416C3_nt ::v75(){vfunc_called(this, "_ZN10S1416C3_nt3v75Ev");}
void  S1416C3_nt ::v76(){vfunc_called(this, "_ZN10S1416C3_nt3v76Ev");}
void  S1416C3_nt ::v77(){vfunc_called(this, "_ZN10S1416C3_nt3v77Ev");}
void  S1416C3_nt ::v78(){vfunc_called(this, "_ZN10S1416C3_nt3v78Ev");}
void  S1416C3_nt ::v79(){vfunc_called(this, "_ZN10S1416C3_nt3v79Ev");}
void  S1416C3_nt ::v80(){vfunc_called(this, "_ZN10S1416C3_nt3v80Ev");}
void  S1416C3_nt ::v81(){vfunc_called(this, "_ZN10S1416C3_nt3v81Ev");}
void  S1416C3_nt ::v82(){vfunc_called(this, "_ZN10S1416C3_nt3v82Ev");}
void  S1416C3_nt ::v83(){vfunc_called(this, "_ZN10S1416C3_nt3v83Ev");}
void  S1416C3_nt ::v84(){vfunc_called(this, "_ZN10S1416C3_nt3v84Ev");}
void  S1416C3_nt ::v85(){vfunc_called(this, "_ZN10S1416C3_nt3v85Ev");}
void  S1416C3_nt ::v86(){vfunc_called(this, "_ZN10S1416C3_nt3v86Ev");}
void  S1416C3_nt ::v87(){vfunc_called(this, "_ZN10S1416C3_nt3v87Ev");}
void  S1416C3_nt ::v88(){vfunc_called(this, "_ZN10S1416C3_nt3v88Ev");}
void  S1416C3_nt ::v89(){vfunc_called(this, "_ZN10S1416C3_nt3v89Ev");}
void  S1416C3_nt ::v90(){vfunc_called(this, "_ZN10S1416C3_nt3v90Ev");}
void  S1416C3_nt ::v91(){vfunc_called(this, "_ZN10S1416C3_nt3v91Ev");}
void  S1416C3_nt ::v92(){vfunc_called(this, "_ZN10S1416C3_nt3v92Ev");}
void  S1416C3_nt ::v93(){vfunc_called(this, "_ZN10S1416C3_nt3v93Ev");}
void  S1416C3_nt ::v94(){vfunc_called(this, "_ZN10S1416C3_nt3v94Ev");}
S1416C3_nt ::S1416C3_nt(){ note_ctor("S1416C3_nt", this);} // tgen

//skip512 S1416C3_nt

#else // __cplusplus

extern void _ZN10S1416C3_ntC1Ev();
extern void _ZN10S1416C3_ntD1Ev();
Name_Map name_map_S1416C3_nt[] = {
  NSPAIR(_ZN10S1416C3_ntC1Ev),
  NSPAIR(_ZN10S1416C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1416C4;
extern VTBL_ENTRY _ZTI7S1416C4[];
extern  VTBL_ENTRY _ZTV7S1416C4[];
static Base_Class bases_S1416C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1416C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S1416C3_nt[];
extern void _ZN10S1416C3_ntD1Ev();
extern void _ZN10S1416C3_ntD0Ev();
extern void _ZN7S1416C42v4Ev();
extern void _ZN7S1416C42v5Ev();
extern void _ZN7S1416C42v6Ev();
extern void _ZN7S1416C42v7Ev();
extern void _ZN7S1416C42v8Ev();
extern void _ZN7S1416C42v9Ev();
extern void _ZN7S1416C43v10Ev();
extern void _ZN7S1416C43v11Ev();
extern void _ZN7S1416C43v12Ev();
extern void _ZN7S1416C43v13Ev();
extern void _ZN7S1416C43v14Ev();
extern void _ZN7S1416C43v15Ev();
extern void _ZN7S1416C43v16Ev();
extern void _ZN7S1416C43v17Ev();
extern void _ZN7S1416C43v18Ev();
extern void _ZN7S1416C43v19Ev();
extern void _ZN7S1416C43v20Ev();
extern void _ZN7S1416C43v21Ev();
extern void _ZN7S1416C43v22Ev();
extern void _ZN7S1416C43v23Ev();
extern void _ZN7S1416C43v24Ev();
extern void _ZN7S1416C43v25Ev();
extern void _ZN7S1416C43v26Ev();
extern void _ZN7S1416C43v27Ev();
extern void _ZN7S1416C43v28Ev();
extern void _ZN7S1416C43v29Ev();
extern void _ZN7S1416C43v30Ev();
extern void _ZN7S1416C43v31Ev();
extern void _ZN7S1416C43v32Ev();
extern void _ZN7S1416C43v33Ev();
extern void _ZN7S1416C43v34Ev();
extern void _ZN7S1416C43v35Ev();
extern void _ZN7S1416C43v36Ev();
extern void _ZN7S1416C43v37Ev();
extern void _ZN7S1416C43v38Ev();
extern void _ZN7S1416C43v39Ev();
extern void _ZN7S1416C43v40Ev();
extern void _ZN7S1416C43v41Ev();
extern void _ZN7S1416C43v42Ev();
extern void _ZN7S1416C43v43Ev();
extern void _ZN7S1416C43v44Ev();
extern void _ZN7S1416C43v45Ev();
extern void _ZN7S1416C43v46Ev();
extern void _ZN7S1416C43v47Ev();
extern void _ZN7S1416C43v48Ev();
extern void _ZN7S1416C43v49Ev();
extern void _ZN7S1416C43v50Ev();
extern void _ZN7S1416C43v51Ev();
extern void _ZN7S1416C43v52Ev();
extern void _ZN7S1416C43v53Ev();
extern void _ZN7S1416C43v54Ev();
extern void _ZN7S1416C43v55Ev();
extern void _ZN7S1416C43v56Ev();
extern void _ZN7S1416C43v57Ev();
extern void _ZN7S1416C43v58Ev();
extern void _ZN7S1416C43v59Ev();
extern void _ZN7S1416C43v60Ev();
extern void _ZN7S1416C43v61Ev();
extern void _ZN7S1416C43v62Ev();
extern void _ZN7S1416C43v63Ev();
extern void _ZN7S1416C43v64Ev();
extern void _ZN7S1416C43v65Ev();
extern void _ZN7S1416C43v66Ev();
extern void _ZN7S1416C43v67Ev();
extern void _ZN10S1416C3_nt3v68Ev();
extern void _ZN10S1416C3_nt3v69Ev();
extern void _ZN10S1416C3_nt3v70Ev();
extern void _ZN10S1416C3_nt3v71Ev();
extern void _ZN10S1416C3_nt3v72Ev();
extern void _ZN10S1416C3_nt3v73Ev();
extern void _ZN10S1416C3_nt3v74Ev();
extern void _ZN10S1416C3_nt3v75Ev();
extern void _ZN10S1416C3_nt3v76Ev();
extern void _ZN10S1416C3_nt3v77Ev();
extern void _ZN10S1416C3_nt3v78Ev();
extern void _ZN10S1416C3_nt3v79Ev();
extern void _ZN10S1416C3_nt3v80Ev();
extern void _ZN10S1416C3_nt3v81Ev();
extern void _ZN10S1416C3_nt3v82Ev();
extern void _ZN10S1416C3_nt3v83Ev();
extern void _ZN10S1416C3_nt3v84Ev();
extern void _ZN10S1416C3_nt3v85Ev();
extern void _ZN10S1416C3_nt3v86Ev();
extern void _ZN10S1416C3_nt3v87Ev();
extern void _ZN10S1416C3_nt3v88Ev();
extern void _ZN10S1416C3_nt3v89Ev();
extern void _ZN10S1416C3_nt3v90Ev();
extern void _ZN10S1416C3_nt3v91Ev();
extern void _ZN10S1416C3_nt3v92Ev();
extern void _ZN10S1416C3_nt3v93Ev();
extern void _ZN10S1416C3_nt3v94Ev();
static  VTBL_ENTRY vtc_S1416C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1416C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S1416C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN7S1416C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1416C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1416C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1416C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1416C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1416C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v67Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v94Ev,
};
extern VTBL_ENTRY _ZTI10S1416C3_nt[];
VTBL_ENTRY *P__ZTI10S1416C3_nt = _ZTI10S1416C3_nt; 
extern  VTBL_ENTRY _ZTV10S1416C3_nt[];
Class_Descriptor cd_S1416C3_nt = {  "S1416C3_nt", // class name
  bases_S1416C3_nt, 1,
  &(vtc_S1416C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(232,180), // object size
  NSPAIRA(_ZTI10S1416C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S1416C3_nt),95, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1416C2_nt  : S1416C3_nt {
  ::S241C13 s1416c2f0;
  unsigned int s1416c2f1:1;
  virtual  ~S1416C2_nt(); // _ZN10S1416C2_ntD1Ev
  virtual void  v95(); // _ZN10S1416C2_nt3v95Ev
  virtual void  v96(); // _ZN10S1416C2_nt3v96Ev
  virtual void  v97(); // _ZN10S1416C2_nt3v97Ev
  virtual void  v98(); // _ZN10S1416C2_nt3v98Ev
  virtual void  v99(); // _ZN10S1416C2_nt3v99Ev
  virtual void  v100(); // _ZN10S1416C2_nt4v100Ev
  virtual void  v101(); // _ZN10S1416C2_nt4v101Ev
  virtual void  v102(); // _ZN10S1416C2_nt4v102Ev
  virtual void  v103(); // _ZN10S1416C2_nt4v103Ev
  virtual void  v104(); // _ZN10S1416C2_nt4v104Ev
  virtual void  v105(); // _ZN10S1416C2_nt4v105Ev
  virtual void  v106(); // _ZN10S1416C2_nt4v106Ev
  virtual void  v107(); // _ZN10S1416C2_nt4v107Ev
  virtual void  v108(); // _ZN10S1416C2_nt4v108Ev
  virtual void  v109(); // _ZN10S1416C2_nt4v109Ev
  virtual void  v110(); // _ZN10S1416C2_nt4v110Ev
  virtual void  v111(); // _ZN10S1416C2_nt4v111Ev
  virtual void  v112(); // _ZN10S1416C2_nt4v112Ev
  S1416C2_nt(); // tgen
};
//SIG(-1 S1416C2_nt) C1{ BC2{ BC3{ vd v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 Fp FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC4 FC8{ BC9{ BC7}} FC10{ m FC11{ m Fi[4]} FC12{ m Fi[3]} Fi} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi[11]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 FC13{ BC14{ BC7}} Fi:1}


 S1416C2_nt ::~S1416C2_nt(){ note_dtor("S1416C2_nt", this);}
void  S1416C2_nt ::v95(){vfunc_called(this, "_ZN10S1416C2_nt3v95Ev");}
void  S1416C2_nt ::v96(){vfunc_called(this, "_ZN10S1416C2_nt3v96Ev");}
void  S1416C2_nt ::v97(){vfunc_called(this, "_ZN10S1416C2_nt3v97Ev");}
void  S1416C2_nt ::v98(){vfunc_called(this, "_ZN10S1416C2_nt3v98Ev");}
void  S1416C2_nt ::v99(){vfunc_called(this, "_ZN10S1416C2_nt3v99Ev");}
void  S1416C2_nt ::v100(){vfunc_called(this, "_ZN10S1416C2_nt4v100Ev");}
void  S1416C2_nt ::v101(){vfunc_called(this, "_ZN10S1416C2_nt4v101Ev");}
void  S1416C2_nt ::v102(){vfunc_called(this, "_ZN10S1416C2_nt4v102Ev");}
void  S1416C2_nt ::v103(){vfunc_called(this, "_ZN10S1416C2_nt4v103Ev");}
void  S1416C2_nt ::v104(){vfunc_called(this, "_ZN10S1416C2_nt4v104Ev");}
void  S1416C2_nt ::v105(){vfunc_called(this, "_ZN10S1416C2_nt4v105Ev");}
void  S1416C2_nt ::v106(){vfunc_called(this, "_ZN10S1416C2_nt4v106Ev");}
void  S1416C2_nt ::v107(){vfunc_called(this, "_ZN10S1416C2_nt4v107Ev");}
void  S1416C2_nt ::v108(){vfunc_called(this, "_ZN10S1416C2_nt4v108Ev");}
void  S1416C2_nt ::v109(){vfunc_called(this, "_ZN10S1416C2_nt4v109Ev");}
void  S1416C2_nt ::v110(){vfunc_called(this, "_ZN10S1416C2_nt4v110Ev");}
void  S1416C2_nt ::v111(){vfunc_called(this, "_ZN10S1416C2_nt4v111Ev");}
void  S1416C2_nt ::v112(){vfunc_called(this, "_ZN10S1416C2_nt4v112Ev");}
S1416C2_nt ::S1416C2_nt(){ note_ctor("S1416C2_nt", this);} // tgen

//skip512 S1416C2_nt

#else // __cplusplus

extern void _ZN10S1416C2_ntC1Ev();
extern void _ZN10S1416C2_ntD1Ev();
Name_Map name_map_S1416C2_nt[] = {
  NSPAIR(_ZN10S1416C2_ntC1Ev),
  NSPAIR(_ZN10S1416C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1416C4;
extern VTBL_ENTRY _ZTI7S1416C4[];
extern  VTBL_ENTRY _ZTV7S1416C4[];
extern Class_Descriptor cd_S1416C3_nt;
extern VTBL_ENTRY _ZTI10S1416C3_nt[];
extern  VTBL_ENTRY _ZTV10S1416C3_nt[];
static Base_Class bases_S1416C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1416C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1416C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S1416C2_nt[];
extern void _ZN10S1416C2_ntD1Ev();
extern void _ZN10S1416C2_ntD0Ev();
extern void _ZN7S1416C42v4Ev();
extern void _ZN7S1416C42v5Ev();
extern void _ZN7S1416C42v6Ev();
extern void _ZN7S1416C42v7Ev();
extern void _ZN7S1416C42v8Ev();
extern void _ZN7S1416C42v9Ev();
extern void _ZN7S1416C43v10Ev();
extern void _ZN7S1416C43v11Ev();
extern void _ZN7S1416C43v12Ev();
extern void _ZN7S1416C43v13Ev();
extern void _ZN7S1416C43v14Ev();
extern void _ZN7S1416C43v15Ev();
extern void _ZN7S1416C43v16Ev();
extern void _ZN7S1416C43v17Ev();
extern void _ZN7S1416C43v18Ev();
extern void _ZN7S1416C43v19Ev();
extern void _ZN7S1416C43v20Ev();
extern void _ZN7S1416C43v21Ev();
extern void _ZN7S1416C43v22Ev();
extern void _ZN7S1416C43v23Ev();
extern void _ZN7S1416C43v24Ev();
extern void _ZN7S1416C43v25Ev();
extern void _ZN7S1416C43v26Ev();
extern void _ZN7S1416C43v27Ev();
extern void _ZN7S1416C43v28Ev();
extern void _ZN7S1416C43v29Ev();
extern void _ZN7S1416C43v30Ev();
extern void _ZN7S1416C43v31Ev();
extern void _ZN7S1416C43v32Ev();
extern void _ZN7S1416C43v33Ev();
extern void _ZN7S1416C43v34Ev();
extern void _ZN7S1416C43v35Ev();
extern void _ZN7S1416C43v36Ev();
extern void _ZN7S1416C43v37Ev();
extern void _ZN7S1416C43v38Ev();
extern void _ZN7S1416C43v39Ev();
extern void _ZN7S1416C43v40Ev();
extern void _ZN7S1416C43v41Ev();
extern void _ZN7S1416C43v42Ev();
extern void _ZN7S1416C43v43Ev();
extern void _ZN7S1416C43v44Ev();
extern void _ZN7S1416C43v45Ev();
extern void _ZN7S1416C43v46Ev();
extern void _ZN7S1416C43v47Ev();
extern void _ZN7S1416C43v48Ev();
extern void _ZN7S1416C43v49Ev();
extern void _ZN7S1416C43v50Ev();
extern void _ZN7S1416C43v51Ev();
extern void _ZN7S1416C43v52Ev();
extern void _ZN7S1416C43v53Ev();
extern void _ZN7S1416C43v54Ev();
extern void _ZN7S1416C43v55Ev();
extern void _ZN7S1416C43v56Ev();
extern void _ZN7S1416C43v57Ev();
extern void _ZN7S1416C43v58Ev();
extern void _ZN7S1416C43v59Ev();
extern void _ZN7S1416C43v60Ev();
extern void _ZN7S1416C43v61Ev();
extern void _ZN7S1416C43v62Ev();
extern void _ZN7S1416C43v63Ev();
extern void _ZN7S1416C43v64Ev();
extern void _ZN7S1416C43v65Ev();
extern void _ZN7S1416C43v66Ev();
extern void _ZN7S1416C43v67Ev();
extern void _ZN10S1416C3_nt3v68Ev();
extern void _ZN10S1416C3_nt3v69Ev();
extern void _ZN10S1416C3_nt3v70Ev();
extern void _ZN10S1416C3_nt3v71Ev();
extern void _ZN10S1416C3_nt3v72Ev();
extern void _ZN10S1416C3_nt3v73Ev();
extern void _ZN10S1416C3_nt3v74Ev();
extern void _ZN10S1416C3_nt3v75Ev();
extern void _ZN10S1416C3_nt3v76Ev();
extern void _ZN10S1416C3_nt3v77Ev();
extern void _ZN10S1416C3_nt3v78Ev();
extern void _ZN10S1416C3_nt3v79Ev();
extern void _ZN10S1416C3_nt3v80Ev();
extern void _ZN10S1416C3_nt3v81Ev();
extern void _ZN10S1416C3_nt3v82Ev();
extern void _ZN10S1416C3_nt3v83Ev();
extern void _ZN10S1416C3_nt3v84Ev();
extern void _ZN10S1416C3_nt3v85Ev();
extern void _ZN10S1416C3_nt3v86Ev();
extern void _ZN10S1416C3_nt3v87Ev();
extern void _ZN10S1416C3_nt3v88Ev();
extern void _ZN10S1416C3_nt3v89Ev();
extern void _ZN10S1416C3_nt3v90Ev();
extern void _ZN10S1416C3_nt3v91Ev();
extern void _ZN10S1416C3_nt3v92Ev();
extern void _ZN10S1416C3_nt3v93Ev();
extern void _ZN10S1416C3_nt3v94Ev();
extern void _ZN10S1416C2_nt3v95Ev();
extern void _ZN10S1416C2_nt3v96Ev();
extern void _ZN10S1416C2_nt3v97Ev();
extern void _ZN10S1416C2_nt3v98Ev();
extern void _ZN10S1416C2_nt3v99Ev();
extern void _ZN10S1416C2_nt4v100Ev();
extern void _ZN10S1416C2_nt4v101Ev();
extern void _ZN10S1416C2_nt4v102Ev();
extern void _ZN10S1416C2_nt4v103Ev();
extern void _ZN10S1416C2_nt4v104Ev();
extern void _ZN10S1416C2_nt4v105Ev();
extern void _ZN10S1416C2_nt4v106Ev();
extern void _ZN10S1416C2_nt4v107Ev();
extern void _ZN10S1416C2_nt4v108Ev();
extern void _ZN10S1416C2_nt4v109Ev();
extern void _ZN10S1416C2_nt4v110Ev();
extern void _ZN10S1416C2_nt4v111Ev();
extern void _ZN10S1416C2_nt4v112Ev();
static  VTBL_ENTRY vtc_S1416C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1416C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S1416C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN7S1416C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1416C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1416C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1416C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1416C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1416C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v67Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt4v112Ev,
};
extern VTBL_ENTRY _ZTI10S1416C2_nt[];
VTBL_ENTRY *P__ZTI10S1416C2_nt = _ZTI10S1416C2_nt; 
extern  VTBL_ENTRY _ZTV10S1416C2_nt[];
Class_Descriptor cd_S1416C2_nt = {  "S1416C2_nt", // class name
  bases_S1416C2_nt, 2,
  &(vtc_S1416C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,196), // object size
  NSPAIRA(_ZTI10S1416C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S1416C2_nt),113, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1416C1  : S1416C2_nt {
  int s1416c1f0[3];
  virtual  ~S1416C1(); // _ZN7S1416C1D1Ev
  virtual void  v1(); // _ZN7S1416C12v1Ev
  virtual void  v2(); // _ZN7S1416C12v2Ev
  virtual void  v3(); // _ZN7S1416C12v3Ev
  S1416C1(); // tgen
};
//SIG(1 S1416C1) C1{ BC2{ BC3{ BC4{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 Fp FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC5 FC9{ BC10{ BC8}} FC11{ m FC12{ m Fi[4]} FC13{ m Fi[3]} Fi} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi[11]} vd v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 FC14{ BC15{ BC8}} Fi:1} vd v1 v2 v3 Fi[3]}


 S1416C1 ::~S1416C1(){ note_dtor("S1416C1", this);}
void  S1416C1 ::v1(){vfunc_called(this, "_ZN7S1416C12v1Ev");}
void  S1416C1 ::v2(){vfunc_called(this, "_ZN7S1416C12v2Ev");}
void  S1416C1 ::v3(){vfunc_called(this, "_ZN7S1416C12v3Ev");}
S1416C1 ::S1416C1(){ note_ctor("S1416C1", this);} // tgen

static void Test_S1416C1()
{
  extern Class_Descriptor cd_S1416C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(34,53)];
    init_test(&cd_S1416C1, buf);
    S1416C1 *dp, &lv = *(dp=new (buf) S1416C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(264,208), "sizeof(S1416C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1416C1)");
    check_base_class_offset(lv, (S1416C4*)(S1416C3_nt*)(S1416C2_nt*), 0, "S1416C1");
    check_base_class_offset(lv, (S1416C3_nt*)(S1416C2_nt*), 0, "S1416C1");
    check_base_class_offset(lv, (S1416C2_nt*), 0, "S1416C1");
    check_field_offset(lv, s1416c1f0, ABISELECT(252,196), "S1416C1.s1416c1f0");
    test_class_info(&lv, &cd_S1416C1);
    dp->~S1416C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1416C1(Test_S1416C1, "S1416C1", ABISELECT(264,208));

#else // __cplusplus

extern void _ZN7S1416C1C1Ev();
extern void _ZN7S1416C1D1Ev();
Name_Map name_map_S1416C1[] = {
  NSPAIR(_ZN7S1416C1C1Ev),
  NSPAIR(_ZN7S1416C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1416C4;
extern VTBL_ENTRY _ZTI7S1416C4[];
extern  VTBL_ENTRY _ZTV7S1416C4[];
extern Class_Descriptor cd_S1416C3_nt;
extern VTBL_ENTRY _ZTI10S1416C3_nt[];
extern  VTBL_ENTRY _ZTV10S1416C3_nt[];
extern Class_Descriptor cd_S1416C2_nt;
extern VTBL_ENTRY _ZTI10S1416C2_nt[];
extern  VTBL_ENTRY _ZTV10S1416C2_nt[];
static Base_Class bases_S1416C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1416C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1416C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1416C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1416C1[];
extern void _ZN7S1416C1D1Ev();
extern void _ZN7S1416C1D0Ev();
extern void _ZN7S1416C42v4Ev();
extern void _ZN7S1416C42v5Ev();
extern void _ZN7S1416C42v6Ev();
extern void _ZN7S1416C42v7Ev();
extern void _ZN7S1416C42v8Ev();
extern void _ZN7S1416C42v9Ev();
extern void _ZN7S1416C43v10Ev();
extern void _ZN7S1416C43v11Ev();
extern void _ZN7S1416C43v12Ev();
extern void _ZN7S1416C43v13Ev();
extern void _ZN7S1416C43v14Ev();
extern void _ZN7S1416C43v15Ev();
extern void _ZN7S1416C43v16Ev();
extern void _ZN7S1416C43v17Ev();
extern void _ZN7S1416C43v18Ev();
extern void _ZN7S1416C43v19Ev();
extern void _ZN7S1416C43v20Ev();
extern void _ZN7S1416C43v21Ev();
extern void _ZN7S1416C43v22Ev();
extern void _ZN7S1416C43v23Ev();
extern void _ZN7S1416C43v24Ev();
extern void _ZN7S1416C43v25Ev();
extern void _ZN7S1416C43v26Ev();
extern void _ZN7S1416C43v27Ev();
extern void _ZN7S1416C43v28Ev();
extern void _ZN7S1416C43v29Ev();
extern void _ZN7S1416C43v30Ev();
extern void _ZN7S1416C43v31Ev();
extern void _ZN7S1416C43v32Ev();
extern void _ZN7S1416C43v33Ev();
extern void _ZN7S1416C43v34Ev();
extern void _ZN7S1416C43v35Ev();
extern void _ZN7S1416C43v36Ev();
extern void _ZN7S1416C43v37Ev();
extern void _ZN7S1416C43v38Ev();
extern void _ZN7S1416C43v39Ev();
extern void _ZN7S1416C43v40Ev();
extern void _ZN7S1416C43v41Ev();
extern void _ZN7S1416C43v42Ev();
extern void _ZN7S1416C43v43Ev();
extern void _ZN7S1416C43v44Ev();
extern void _ZN7S1416C43v45Ev();
extern void _ZN7S1416C43v46Ev();
extern void _ZN7S1416C43v47Ev();
extern void _ZN7S1416C43v48Ev();
extern void _ZN7S1416C43v49Ev();
extern void _ZN7S1416C43v50Ev();
extern void _ZN7S1416C43v51Ev();
extern void _ZN7S1416C43v52Ev();
extern void _ZN7S1416C43v53Ev();
extern void _ZN7S1416C43v54Ev();
extern void _ZN7S1416C43v55Ev();
extern void _ZN7S1416C43v56Ev();
extern void _ZN7S1416C43v57Ev();
extern void _ZN7S1416C43v58Ev();
extern void _ZN7S1416C43v59Ev();
extern void _ZN7S1416C43v60Ev();
extern void _ZN7S1416C43v61Ev();
extern void _ZN7S1416C43v62Ev();
extern void _ZN7S1416C43v63Ev();
extern void _ZN7S1416C43v64Ev();
extern void _ZN7S1416C43v65Ev();
extern void _ZN7S1416C43v66Ev();
extern void _ZN7S1416C43v67Ev();
extern void _ZN10S1416C3_nt3v68Ev();
extern void _ZN10S1416C3_nt3v69Ev();
extern void _ZN10S1416C3_nt3v70Ev();
extern void _ZN10S1416C3_nt3v71Ev();
extern void _ZN10S1416C3_nt3v72Ev();
extern void _ZN10S1416C3_nt3v73Ev();
extern void _ZN10S1416C3_nt3v74Ev();
extern void _ZN10S1416C3_nt3v75Ev();
extern void _ZN10S1416C3_nt3v76Ev();
extern void _ZN10S1416C3_nt3v77Ev();
extern void _ZN10S1416C3_nt3v78Ev();
extern void _ZN10S1416C3_nt3v79Ev();
extern void _ZN10S1416C3_nt3v80Ev();
extern void _ZN10S1416C3_nt3v81Ev();
extern void _ZN10S1416C3_nt3v82Ev();
extern void _ZN10S1416C3_nt3v83Ev();
extern void _ZN10S1416C3_nt3v84Ev();
extern void _ZN10S1416C3_nt3v85Ev();
extern void _ZN10S1416C3_nt3v86Ev();
extern void _ZN10S1416C3_nt3v87Ev();
extern void _ZN10S1416C3_nt3v88Ev();
extern void _ZN10S1416C3_nt3v89Ev();
extern void _ZN10S1416C3_nt3v90Ev();
extern void _ZN10S1416C3_nt3v91Ev();
extern void _ZN10S1416C3_nt3v92Ev();
extern void _ZN10S1416C3_nt3v93Ev();
extern void _ZN10S1416C3_nt3v94Ev();
extern void _ZN10S1416C2_nt3v95Ev();
extern void _ZN10S1416C2_nt3v96Ev();
extern void _ZN10S1416C2_nt3v97Ev();
extern void _ZN10S1416C2_nt3v98Ev();
extern void _ZN10S1416C2_nt3v99Ev();
extern void _ZN10S1416C2_nt4v100Ev();
extern void _ZN10S1416C2_nt4v101Ev();
extern void _ZN10S1416C2_nt4v102Ev();
extern void _ZN10S1416C2_nt4v103Ev();
extern void _ZN10S1416C2_nt4v104Ev();
extern void _ZN10S1416C2_nt4v105Ev();
extern void _ZN10S1416C2_nt4v106Ev();
extern void _ZN10S1416C2_nt4v107Ev();
extern void _ZN10S1416C2_nt4v108Ev();
extern void _ZN10S1416C2_nt4v109Ev();
extern void _ZN10S1416C2_nt4v110Ev();
extern void _ZN10S1416C2_nt4v111Ev();
extern void _ZN10S1416C2_nt4v112Ev();
extern void _ZN7S1416C12v1Ev();
extern void _ZN7S1416C12v2Ev();
extern void _ZN7S1416C12v3Ev();
static  VTBL_ENTRY vtc_S1416C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1416C1[0]),
  (VTBL_ENTRY)&_ZN7S1416C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1416C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1416C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1416C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1416C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1416C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1416C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1416C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1416C43v67Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1416C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1416C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN7S1416C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1416C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1416C12v3Ev,
};
extern VTBL_ENTRY _ZTI7S1416C1[];
extern  VTBL_ENTRY _ZTV7S1416C1[];
Class_Descriptor cd_S1416C1 = {  "S1416C1", // class name
  bases_S1416C1, 3,
  &(vtc_S1416C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(264,208), // object size
  NSPAIRA(_ZTI7S1416C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1416C1),116, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7268C4  {
  short s7268c4f0[6];
  __tsi64 s7268c4f1;
  char s7268c4f2[5];
  void  mf7268c4(); // _ZN7S7268C48mf7268c4Ev
};
//SIG(-1 S7268C4) C1{ m Fs[6] FL Fc[5]}


void  S7268C4 ::mf7268c4(){}

static void Test_S7268C4()
{
  {
    init_simple_test("S7268C4");
    S7268C4 lv;
    check2(sizeof(lv), ABISELECT(32,28), "sizeof(S7268C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7268C4)");
    check_field_offset(lv, s7268c4f0, 0, "S7268C4.s7268c4f0");
    check_field_offset(lv, s7268c4f1, ABISELECT(16,12), "S7268C4.s7268c4f1");
    check_field_offset(lv, s7268c4f2, ABISELECT(24,20), "S7268C4.s7268c4f2");
  }
}
static Arrange_To_Call_Me vS7268C4(Test_S7268C4, "S7268C4", ABISELECT(32,28));

#else // __cplusplus

extern VTBL_ENTRY _ZTI7S7268C4[];
VTBL_ENTRY *P__ZTI7S7268C4 = _ZTI7S7268C4; 
Class_Descriptor cd_S7268C4 = {  "S7268C4", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(32,28), // object size
  NSPAIRA(_ZTI7S7268C4),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7268C5  : virtual S7268C4 {
  ::S7268C4 s7268c5f0;
  int s7268c5f1;
  void *s7268c5f2;
  ::S7268C4 s7268c5f3[2];
  virtual  ~S7268C5(); // _ZN7S7268C5D2Ev
  S7268C5(); // tgen
};
//SIG(-1 S7268C5) C1{ VBC2{ m Fs[6] FL Fc[5]} vd FC2 Fi Fp FC2[2]}


 S7268C5 ::~S7268C5(){ note_dtor("S7268C5", this);}
S7268C5 ::S7268C5(){ note_ctor("S7268C5", this);} // tgen

static void Test_S7268C5()
{
  extern Class_Descriptor cd_S7268C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(20,32)];
    init_test(&cd_S7268C5, buf);
    S7268C5 *dp, &lv = *(dp=new (buf) S7268C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(152,124), "sizeof(S7268C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7268C5)");
    check_base_class_offset(lv, (S7268C4*), ABISELECT(120,96), "S7268C5");
    check_field_offset(lv, s7268c5f0, ABISELECT(8,4), "S7268C5.s7268c5f0");
    check_field_offset(lv, s7268c5f1, ABISELECT(40,32), "S7268C5.s7268c5f1");
    check_field_offset(lv, s7268c5f2, ABISELECT(48,36), "S7268C5.s7268c5f2");
    check_field_offset(lv, s7268c5f3, ABISELECT(56,40), "S7268C5.s7268c5f3");
    test_class_info(&lv, &cd_S7268C5);
    dp->~S7268C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7268C5(Test_S7268C5, "S7268C5", ABISELECT(152,124));

#else // __cplusplus

extern void _ZN7S7268C5C1Ev();
extern void _ZN7S7268C5D2Ev();
Name_Map name_map_S7268C5[] = {
  NSPAIR(_ZN7S7268C5C1Ev),
  NSPAIR(_ZN7S7268C5D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
static Base_Class bases_S7268C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7268C4,    ABISELECT(120,96), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S7268C5[];
extern void _ZN7S7268C5D1Ev();
extern void _ZN7S7268C5D0Ev();
static  VTBL_ENTRY vtc_S7268C5[] = {
  ABISELECT(120,96),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C5[0]),
  (VTBL_ENTRY)&_ZN7S7268C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C5D0Ev,
};
extern VTBL_ENTRY _ZTV7S7268C5[];
static  VTT_ENTRY vtt_S7268C5[] = {
  {&(_ZTV7S7268C5[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7S7268C5[];
extern  VTBL_ENTRY _ZTV7S7268C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C5[];
Class_Descriptor cd_S7268C5 = {  "S7268C5", // class name
  bases_S7268C5, 1,
  &(vtc_S7268C5[0]), // expected_vtbl_contents
  &(vtt_S7268C5[0]), // expected_vtt_contents
  ABISELECT(152,124), // object size
  NSPAIRA(_ZTI7S7268C5),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7S7268C5),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7268C5),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S7268C9  {
  long s7268c9f0;
  void *s7268c9f1[4];
  int s7268c9f2;
  void  mf7268c9(); // _ZN7S7268C98mf7268c9Ev
};
//SIG(1 S7268C9) U1{ m Fl Fp[4] Fi}

#endif // __cplusplus
#ifdef __cplusplus

struct  S7268C8  {
  ::S7268C9 s7268c8f0;
  void *s7268c8f1;
  ::S7268C4 s7268c8f2[8];
  void *s7268c8f3;
  virtual void  v7(); // _ZN7S7268C82v7Ev
  ~S7268C8(); // tgen
  S7268C8(); // tgen
};
//SIG(-1 S7268C8) C1{ v1 FU2{ m Fl Fp[4] Fi} Fp FC3{ m Fs[6] FL Fc[5]}[8] Fp}


void  S7268C8 ::v7(){vfunc_called(this, "_ZN7S7268C82v7Ev");}
S7268C8 ::~S7268C8(){ note_dtor("S7268C8", this);} // tgen
S7268C8 ::S7268C8(){ note_ctor("S7268C8", this);} // tgen

static void Test_S7268C8()
{
  extern Class_Descriptor cd_S7268C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(40,64)];
    init_test(&cd_S7268C8, buf);
    S7268C8 *dp, &lv = *(dp=new (buf) S7268C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(312,252), "sizeof(S7268C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7268C8)");
    check_field_offset(lv, s7268c8f0, ABISELECT(8,4), "S7268C8.s7268c8f0");
    check_field_offset(lv, s7268c8f1, ABISELECT(40,20), "S7268C8.s7268c8f1");
    check_field_offset(lv, s7268c8f2, ABISELECT(48,24), "S7268C8.s7268c8f2");
    check_field_offset(lv, s7268c8f3, ABISELECT(304,248), "S7268C8.s7268c8f3");
    test_class_info(&lv, &cd_S7268C8);
    dp->~S7268C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7268C8(Test_S7268C8, "S7268C8", ABISELECT(312,252));

#else // __cplusplus

extern void _ZN7S7268C8C1Ev();
extern void _ZN7S7268C8D1Ev();
Name_Map name_map_S7268C8[] = {
  NSPAIR(_ZN7S7268C8C1Ev),
  NSPAIR(_ZN7S7268C8D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S7268C8[];
extern void _ZN7S7268C82v7Ev();
static  VTBL_ENTRY vtc_S7268C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C8[0]),
  (VTBL_ENTRY)&_ZN7S7268C82v7Ev,
};
extern VTBL_ENTRY _ZTI7S7268C8[];
extern  VTBL_ENTRY _ZTV7S7268C8[];
Class_Descriptor cd_S7268C8 = {  "S7268C8", // class name
  0,0,//no base classes
  &(vtc_S7268C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(312,252), // object size
  NSPAIRA(_ZTI7S7268C8),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S7268C8),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7268C7  : S7268C8 , virtual S7268C4 , S7268C5 {
  void *s7268c7f0[5];
  char  :0;
  int s7268c7f2;
  int s7268c7f3;
  int s7268c7f4:10;
  char s7268c7f5[8];
  short s7268c7f6;
  int s7268c7f7;
  void *s7268c7f8[10];
  ::S7268C5 s7268c7f9;
  __tsi64 s7268c7f10;
  int s7268c7f11;
  void *s7268c7f12;
  ~S7268C7(); // tgen
  S7268C7(); // tgen
};
//SIG(-1 S7268C7) C1{ BC2{ v1 FU3{ m Fl Fp[4] Fi} Fp FC4{ m Fs[6] FL Fc[5]}[8] Fp} VBC4 BC5{ VBC4 vd FC4 Fi Fp FC4[2]} Fp[5] Fc:0 Fi Fi Fi:10 Fc[8] Fs Fi Fp[10] FC5 FL Fi Fp}


S7268C7 ::~S7268C7(){ note_dtor("S7268C7", this);} // tgen
S7268C7 ::S7268C7(){ note_ctor("S7268C7", this);} // tgen

static void Test_S7268C7()
{
  extern Class_Descriptor cd_S7268C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(99,151)];
    init_test(&cd_S7268C7, buf);
    S7268C7 *dp, &lv = *(dp=new (buf) S7268C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(784,600), "sizeof(S7268C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7268C7)");
    check_base_class_offset(lv, (S7268C8*), 0, "S7268C7");
    check_base_class_offset(lv, (S7268C4*), ABISELECT(752,572), "S7268C7");
    check_base_class_offset(lv, (S7268C4*)(S7268C5*), ABISELECT(752,572), "S7268C7");
    check_base_class_offset(lv, (S7268C5*), ABISELECT(312,252), "S7268C7");
    check_field_offset(lv, s7268c7f0, ABISELECT(432,348), "S7268C7.s7268c7f0");
    check_field_offset(lv, s7268c7f2, ABISELECT(472,368), "S7268C7.s7268c7f2");
    check_field_offset(lv, s7268c7f3, ABISELECT(476,372), "S7268C7.s7268c7f3");
    set_bf_and_test(lv, s7268c7f4, ABISELECT(480,376), 0, 10, 1, "S7268C7");
    set_bf_and_test(lv, s7268c7f4, ABISELECT(480,376), 0, 10, hide_sll(1LL<<9), "S7268C7");
    check_field_offset(lv, s7268c7f5, ABISELECT(482,378), "S7268C7.s7268c7f5");
    check_field_offset(lv, s7268c7f6, ABISELECT(490,386), "S7268C7.s7268c7f6");
    check_field_offset(lv, s7268c7f7, ABISELECT(492,388), "S7268C7.s7268c7f7");
    check_field_offset(lv, s7268c7f8, ABISELECT(496,392), "S7268C7.s7268c7f8");
    check_field_offset(lv, s7268c7f9, ABISELECT(576,432), "S7268C7.s7268c7f9");
    check_field_offset(lv, s7268c7f10, ABISELECT(728,556), "S7268C7.s7268c7f10");
    check_field_offset(lv, s7268c7f11, ABISELECT(736,564), "S7268C7.s7268c7f11");
    check_field_offset(lv, s7268c7f12, ABISELECT(744,568), "S7268C7.s7268c7f12");
    test_class_info(&lv, &cd_S7268C7);
    dp->~S7268C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7268C7(Test_S7268C7, "S7268C7", ABISELECT(784,600));

#else // __cplusplus

extern void _ZN7S7268C7C1Ev();
extern void _ZN7S7268C7D1Ev();
Name_Map name_map_S7268C7[] = {
  NSPAIR(_ZN7S7268C7C1Ev),
  NSPAIR(_ZN7S7268C7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7268C8;
extern VTBL_ENTRY _ZTI7S7268C8[];
extern  VTBL_ENTRY _ZTV7S7268C8[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7268C5;
extern VTBL_ENTRY _ZTI7S7268C5[];
extern  VTBL_ENTRY _ZTV7S7268C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C5[];
static Base_Class bases_S7268C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7268C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7268C4,    ABISELECT(752,572), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7268C5,    ABISELECT(312,252), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S7268C7[];
extern void _ZN7S7268C82v7Ev();
extern void _ZN7S7268C7D1Ev();
extern void _ZN7S7268C7D0Ev();
extern void ABISELECT(_ZThn312_N7S7268C7D1Ev,_ZThn252_N7S7268C7D1Ev)();
extern void ABISELECT(_ZThn312_N7S7268C7D0Ev,_ZThn252_N7S7268C7D0Ev)();
static  VTBL_ENTRY vtc_S7268C7[] = {
  ABISELECT(752,572),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C7[0]),
  (VTBL_ENTRY)&_ZN7S7268C82v7Ev,
  (VTBL_ENTRY)&_ZN7S7268C7D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C7D0Ev,
  ABISELECT(440,320),
  ABISELECT(-312,-252),
  (VTBL_ENTRY)&(_ZTI7S7268C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn312_N7S7268C7D1Ev,_ZThn252_N7S7268C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn312_N7S7268C7D0Ev,_ZThn252_N7S7268C7D0Ev),
};
extern VTBL_ENTRY _ZTV7S7268C7[];
extern void _ZN7S7268C5D1Ev();
extern void _ZN7S7268C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C5__7S7268C7[] = {
  ABISELECT(440,320),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C5[0]),
  (VTBL_ENTRY)&_ZN7S7268C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C5D0Ev,
};
static  VTT_ENTRY vtt_S7268C7[] = {
  {&(_ZTV7S7268C7[3]),  3,11},
  {&(_tg__ZTV7S7268C5__7S7268C7[3]),  3,5},
  {&(_ZTV7S7268C7[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7S7268C7[];
extern  VTBL_ENTRY _ZTV7S7268C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C7[];
Class_Descriptor cd_S7268C7 = {  "S7268C7", // class name
  bases_S7268C7, 3,
  &(vtc_S7268C7[0]), // expected_vtbl_contents
  &(vtt_S7268C7[0]), // expected_vtt_contents
  ABISELECT(784,600), // object size
  NSPAIRA(_ZTI7S7268C7),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S7268C7),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7268C7),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7268C6  {
  ::S7268C4 s7268c6f0;
  char s7268c6f1;
  ::S7268C7 s7268c6f2;
  void *s7268c6f3;
  int s7268c6f4;
  int s7268c6f5;
  void *s7268c6f6;
  int s7268c6f7;
  int s7268c6f8:11;
  int s7268c6f9;
  virtual void  v2(); // _ZN7S7268C62v2Ev
  virtual void  v3(); // _ZN7S7268C62v3Ev
  ~S7268C6(); // tgen
  S7268C6(); // tgen
};
//SIG(-1 S7268C6) C1{ v1 v2 FC2{ m Fs[6] FL Fc[5]} Fc FC3{ BC4{ v3 FU5{ m Fl Fp[4] Fi} Fp FC2[8] Fp} VBC2 BC6{ VBC2 vd FC2 Fi Fp FC2[2]} Fp[5] Fc:0 Fi Fi Fi:10 Fc[8] Fs Fi Fp[10] FC6 FL Fi Fp} Fp Fi Fi Fp Fi Fi:11 Fi}


void  S7268C6 ::v2(){vfunc_called(this, "_ZN7S7268C62v2Ev");}
void  S7268C6 ::v3(){vfunc_called(this, "_ZN7S7268C62v3Ev");}
S7268C6 ::~S7268C6(){ note_dtor("S7268C6", this);} // tgen
S7268C6 ::S7268C6(){ note_ctor("S7268C6", this);} // tgen

static void Test_S7268C6()
{
  extern Class_Descriptor cd_S7268C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(110,167)];
    init_test(&cd_S7268C6, buf);
    S7268C6 *dp, &lv = *(dp=new (buf) S7268C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(872,664), "sizeof(S7268C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7268C6)");
    check_field_offset(lv, s7268c6f0, ABISELECT(8,4), "S7268C6.s7268c6f0");
    check_field_offset(lv, s7268c6f1, ABISELECT(40,32), "S7268C6.s7268c6f1");
    check_field_offset(lv, s7268c6f2, ABISELECT(48,36), "S7268C6.s7268c6f2");
    check_field_offset(lv, s7268c6f3, ABISELECT(832,636), "S7268C6.s7268c6f3");
    check_field_offset(lv, s7268c6f4, ABISELECT(840,640), "S7268C6.s7268c6f4");
    check_field_offset(lv, s7268c6f5, ABISELECT(844,644), "S7268C6.s7268c6f5");
    check_field_offset(lv, s7268c6f6, ABISELECT(848,648), "S7268C6.s7268c6f6");
    check_field_offset(lv, s7268c6f7, ABISELECT(856,652), "S7268C6.s7268c6f7");
    set_bf_and_test(lv, s7268c6f8, ABISELECT(860,656), 0, 11, 1, "S7268C6");
    set_bf_and_test(lv, s7268c6f8, ABISELECT(860,656), 0, 11, hide_sll(1LL<<10), "S7268C6");
    check_field_offset(lv, s7268c6f9, ABISELECT(864,660), "S7268C6.s7268c6f9");
    test_class_info(&lv, &cd_S7268C6);
    dp->~S7268C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7268C6(Test_S7268C6, "S7268C6", ABISELECT(872,664));

#else // __cplusplus

extern void _ZN7S7268C6C1Ev();
extern void _ZN7S7268C6D1Ev();
Name_Map name_map_S7268C6[] = {
  NSPAIR(_ZN7S7268C6C1Ev),
  NSPAIR(_ZN7S7268C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S7268C6[];
extern void _ZN7S7268C62v2Ev();
extern void _ZN7S7268C62v3Ev();
static  VTBL_ENTRY vtc_S7268C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C6[0]),
  (VTBL_ENTRY)&_ZN7S7268C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7268C62v3Ev,
};
extern VTBL_ENTRY _ZTI7S7268C6[];
extern  VTBL_ENTRY _ZTV7S7268C6[];
Class_Descriptor cd_S7268C6 = {  "S7268C6", // class name
  0,0,//no base classes
  &(vtc_S7268C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(872,664), // object size
  NSPAIRA(_ZTI7S7268C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S7268C6),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7268C11  {
  int s7268c11f0;
  void *s7268c11f1;
  void *s7268c11f2;
  long s7268c11f3;
  void *s7268c11f4[2];
  void *s7268c11f5;
  long s7268c11f6[6];
  ::S7268C4 s7268c11f7;
  int s7268c11f8;
  void *s7268c11f9;
  char s7268c11f10[2];
  virtual void  v4(); // _ZN8S7268C112v4Ev
  virtual void  v5(); // _ZN8S7268C112v5Ev
  ~S7268C11(); // tgen
  S7268C11(); // tgen
};
//SIG(-1 S7268C11) C1{ v1 v2 Fi Fp[2] Fl Fp[3] Fl[6] FC2{ m Fs[6] FL Fc[5]} Fi Fp Fc[2]}


void  S7268C11 ::v4(){vfunc_called(this, "_ZN8S7268C112v4Ev");}
void  S7268C11 ::v5(){vfunc_called(this, "_ZN8S7268C112v5Ev");}
S7268C11 ::~S7268C11(){ note_dtor("S7268C11", this);} // tgen
S7268C11 ::S7268C11(){ note_ctor("S7268C11", this);} // tgen

static void Test_S7268C11()
{
  extern Class_Descriptor cd_S7268C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(22,25)];
    init_test(&cd_S7268C11, buf);
    S7268C11 *dp, &lv = *(dp=new (buf) S7268C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(168,96), "sizeof(S7268C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7268C11)");
    check_field_offset(lv, s7268c11f0, ABISELECT(8,4), "S7268C11.s7268c11f0");
    check_field_offset(lv, s7268c11f1, ABISELECT(16,8), "S7268C11.s7268c11f1");
    check_field_offset(lv, s7268c11f2, ABISELECT(24,12), "S7268C11.s7268c11f2");
    check_field_offset(lv, s7268c11f3, ABISELECT(32,16), "S7268C11.s7268c11f3");
    check_field_offset(lv, s7268c11f4, ABISELECT(40,20), "S7268C11.s7268c11f4");
    check_field_offset(lv, s7268c11f5, ABISELECT(56,28), "S7268C11.s7268c11f5");
    check_field_offset(lv, s7268c11f6, ABISELECT(64,32), "S7268C11.s7268c11f6");
    check_field_offset(lv, s7268c11f7, ABISELECT(112,56), "S7268C11.s7268c11f7");
    check_field_offset(lv, s7268c11f8, ABISELECT(144,84), "S7268C11.s7268c11f8");
    check_field_offset(lv, s7268c11f9, ABISELECT(152,88), "S7268C11.s7268c11f9");
    check_field_offset(lv, s7268c11f10, ABISELECT(160,92), "S7268C11.s7268c11f10");
    test_class_info(&lv, &cd_S7268C11);
    dp->~S7268C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7268C11(Test_S7268C11, "S7268C11", ABISELECT(168,96));

#else // __cplusplus

extern void _ZN8S7268C11C1Ev();
extern void _ZN8S7268C11D1Ev();
Name_Map name_map_S7268C11[] = {
  NSPAIR(_ZN8S7268C11C1Ev),
  NSPAIR(_ZN8S7268C11D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S7268C11[];
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY vtc_S7268C11[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7268C11[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
extern VTBL_ENTRY _ZTI8S7268C11[];
extern  VTBL_ENTRY _ZTV8S7268C11[];
Class_Descriptor cd_S7268C11 = {  "S7268C11", // class name
  0,0,//no base classes
  &(vtc_S7268C11[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(168,96), // object size
  NSPAIRA(_ZTI8S7268C11),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S7268C11),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7268C10  : S7268C5 , virtual S7268C11 {
  long s7268c10f0[4];
  ::S7268C5 s7268c10f1[4];
  virtual  ~S7268C10(); // _ZN8S7268C10D2Ev
  virtual void  v6(); // _ZN8S7268C102v6Ev
  S7268C10(); // tgen
};
//SIG(-1 S7268C10) C1{ BC2{ VBC3{ m Fs[6] FL Fc[5]} vd FC3 Fi Fp FC3[2]} VBC4{ v2 v3 Fi Fp[2] Fl Fp[3] Fl[6] FC3 Fi Fp Fc[2]} vd v1 Fl[4] FC2[4]}


 S7268C10 ::~S7268C10(){ note_dtor("S7268C10", this);}
void  S7268C10 ::v6(){vfunc_called(this, "_ZN8S7268C102v6Ev");}
S7268C10 ::S7268C10(){ note_ctor("S7268C10", this);} // tgen

static void Test_S7268C10()
{
  extern Class_Descriptor cd_S7268C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(121,184)];
    init_test(&cd_S7268C10, buf);
    S7268C10 *dp, &lv = *(dp=new (buf) S7268C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(960,732), "sizeof(S7268C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7268C10)");
    check_base_class_offset(lv, (S7268C4*)(S7268C5*), ABISELECT(760,608), "S7268C10");
    check_base_class_offset(lv, (S7268C5*), 0, "S7268C10");
    check_base_class_offset(lv, (S7268C11*), ABISELECT(792,636), "S7268C10");
    check_field_offset(lv, s7268c10f0, ABISELECT(120,96), "S7268C10.s7268c10f0");
    check_field_offset(lv, s7268c10f1, ABISELECT(152,112), "S7268C10.s7268c10f1");
    test_class_info(&lv, &cd_S7268C10);
    dp->~S7268C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7268C10(Test_S7268C10, "S7268C10", ABISELECT(960,732));

#else // __cplusplus

extern void _ZN8S7268C10C1Ev();
extern void _ZN8S7268C10D2Ev();
Name_Map name_map_S7268C10[] = {
  NSPAIR(_ZN8S7268C10C1Ev),
  NSPAIR(_ZN8S7268C10D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7268C5;
extern VTBL_ENTRY _ZTI7S7268C5[];
extern  VTBL_ENTRY _ZTV7S7268C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C5[];
extern Class_Descriptor cd_S7268C11;
extern VTBL_ENTRY _ZTI8S7268C11[];
extern  VTBL_ENTRY _ZTV8S7268C11[];
static Base_Class bases_S7268C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7268C4,    ABISELECT(760,608), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S7268C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7268C11,    ABISELECT(792,636), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7268C10[];
extern void _ZN8S7268C10D1Ev();
extern void _ZN8S7268C10D0Ev();
extern void _ZN8S7268C102v6Ev();
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY vtc_S7268C10[] = {
  ABISELECT(792,636),
  ABISELECT(760,608),
  0,
  (VTBL_ENTRY)&(_ZTI8S7268C10[0]),
  (VTBL_ENTRY)&_ZN8S7268C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7268C10D0Ev,
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
  0,
  0,
  ABISELECT(-792,-636),
  (VTBL_ENTRY)&(_ZTI8S7268C10[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
extern VTBL_ENTRY _ZTV8S7268C10[];
extern void _ZN7S7268C5D1Ev();
extern void _ZN7S7268C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C5__8S7268C10[] = {
  ABISELECT(760,608),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C5[0]),
  (VTBL_ENTRY)&_ZN7S7268C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C5D0Ev,
};
static  VTT_ENTRY vtt_S7268C10[] = {
  {&(_ZTV8S7268C10[4]),  4,13},
  {&(_tg__ZTV7S7268C5__8S7268C10[3]),  3,5},
  {&(_ZTV8S7268C10[11]),  11,13},
};
extern VTBL_ENTRY _ZTI8S7268C10[];
extern  VTBL_ENTRY _ZTV8S7268C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7268C10[];
Class_Descriptor cd_S7268C10 = {  "S7268C10", // class name
  bases_S7268C10, 3,
  &(vtc_S7268C10[0]), // expected_vtbl_contents
  &(vtt_S7268C10[0]), // expected_vtt_contents
  ABISELECT(960,732), // object size
  NSPAIRA(_ZTI8S7268C10),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S7268C10),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7268C10),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7268C3  : S7268C4 , S7268C5 , virtual S7268C6 , virtual S7268C10 , S7268C8 {
  void *s7268c3f0;
  int s7268c3f1[6];
  __tsi64 s7268c3f2;
  ::S7268C5 s7268c3f3;
  char s7268c3f4;
  ~S7268C3(); // tgen
  S7268C3(); // tgen
};
//SIG(-1 S7268C3) C1{ BC2{ m Fs[6] FL Fc[5]} BC3{ VBC2 vd FC2 Fi Fp FC2[2]} VBC4{ v1 v2 FC2 Fc FC5{ BC6{ v6 FU7{ m Fl Fp[4] Fi} Fp FC2[8] Fp} VBC2 BC3 Fp[5] Fc:0 Fi Fi Fi:10 Fc[8] Fs Fi Fp[10] FC3 FL Fi Fp} Fp Fi Fi Fp Fi Fi:11 Fi} VBC8{ BC3 VBC9{ v3 v4 Fi Fp Fp Fl Fp[2] Fp Fl[6] FC2 Fi Fp Fc[2]} vd v5 Fl[4] FC3[4]} BC6 Fp Fi[6] FL FC3 Fc}


S7268C3 ::~S7268C3(){ note_dtor("S7268C3", this);} // tgen
S7268C3 ::S7268C3(){ note_ctor("S7268C3", this);} // tgen

static void Test_S7268C3()
{
  extern Class_Descriptor cd_S7268C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(313,485)];
    init_test(&cd_S7268C3, buf);
    S7268C3 *dp, &lv = *(dp=new (buf) S7268C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2496,1936), "sizeof(S7268C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7268C3)");
    /*is_ambiguous_... S7268C3::S7268C4 */ AMB_check_base_class_offset(lv, (S7268C4*), ABISELECT(120,96), "S7268C3");
    /*is_ambiguous_... S7268C3::S7268C5 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7268C5*), ABISELECT(664,540), "S7268C3");
    check_base_class_offset(lv, (S7268C4*)(S7268C5*)(S7268C10*), ABISELECT(664,540), "S7268C3");
    /*is_ambiguous_... S7268C3::S7268C5 */ AMB_check_base_class_offset(lv, (S7268C5*), 0, "S7268C3");
    check_base_class_offset(lv, (S7268C6*), ABISELECT(696,568), "S7268C3");
    check_base_class_offset(lv, (S7268C5*)(S7268C10*), ABISELECT(1568,1232), "S7268C3");
    check_base_class_offset(lv, (S7268C11*)(S7268C10*), ABISELECT(2328,1840), "S7268C3");
    check_base_class_offset(lv, (S7268C10*), ABISELECT(1568,1232), "S7268C3");
    check_base_class_offset(lv, (S7268C8*), ABISELECT(152,124), "S7268C3");
    check_field_offset(lv, s7268c3f0, ABISELECT(464,376), "S7268C3.s7268c3f0");
    check_field_offset(lv, s7268c3f1, ABISELECT(472,380), "S7268C3.s7268c3f1");
    check_field_offset(lv, s7268c3f2, ABISELECT(496,404), "S7268C3.s7268c3f2");
    check_field_offset(lv, s7268c3f3, ABISELECT(504,412), "S7268C3.s7268c3f3");
    check_field_offset(lv, s7268c3f4, ABISELECT(656,536), "S7268C3.s7268c3f4");
    test_class_info(&lv, &cd_S7268C3);
    dp->~S7268C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7268C3(Test_S7268C3, "S7268C3", ABISELECT(2496,1936));

#else // __cplusplus

extern void _ZN7S7268C3C1Ev();
extern void _ZN7S7268C3D1Ev();
Name_Map name_map_S7268C3[] = {
  NSPAIR(_ZN7S7268C3C1Ev),
  NSPAIR(_ZN7S7268C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7268C5;
extern VTBL_ENTRY _ZTI7S7268C5[];
extern  VTBL_ENTRY _ZTV7S7268C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C5[];
extern Class_Descriptor cd_S7268C6;
extern VTBL_ENTRY _ZTI7S7268C6[];
extern  VTBL_ENTRY _ZTV7S7268C6[];
extern Class_Descriptor cd_S7268C5;
extern VTBL_ENTRY _ZTI7S7268C5[];
extern  VTBL_ENTRY _ZTV7S7268C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C5[];
extern Class_Descriptor cd_S7268C11;
extern VTBL_ENTRY _ZTI8S7268C11[];
extern  VTBL_ENTRY _ZTV8S7268C11[];
extern Class_Descriptor cd_S7268C10;
extern VTBL_ENTRY _ZTI8S7268C10[];
extern  VTBL_ENTRY _ZTV8S7268C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7268C10[];
extern Class_Descriptor cd_S7268C8;
extern VTBL_ENTRY _ZTI7S7268C8[];
extern  VTBL_ENTRY _ZTV7S7268C8[];
static Base_Class bases_S7268C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7268C4,    ABISELECT(120,96), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7268C4,    ABISELECT(664,540), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S7268C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7268C6,    ABISELECT(696,568), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7268C5,    ABISELECT(1568,1232), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S7268C11,    ABISELECT(2328,1840), //bcp->offset
    26, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S7268C10,    ABISELECT(1568,1232), //bcp->offset
    17, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7268C8,    ABISELECT(152,124), //bcp->offset
    8, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S7268C3[];
extern void _ZN7S7268C3D1Ev();
extern void _ZN7S7268C3D0Ev();
extern void _ZN7S7268C82v7Ev();
extern void _ZN7S7268C62v2Ev();
extern void _ZN7S7268C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N7S7268C3D1Ev,_ZTv0_n20_N7S7268C3D1Ev)();
extern void ABISELECT(_ZThn1568_N7S7268C3D1Ev,_ZThn1232_N7S7268C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S7268C3D0Ev,_ZTv0_n20_N7S7268C3D0Ev)();
extern void ABISELECT(_ZThn1568_N7S7268C3D0Ev,_ZThn1232_N7S7268C3D0Ev)() __attribute__((weak));
extern void _ZN8S7268C102v6Ev();
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY vtc_S7268C3[] = {
  ABISELECT(2328,1840),
  ABISELECT(1568,1232),
  ABISELECT(696,568),
  ABISELECT(664,540),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&_ZN7S7268C3D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C3D0Ev,
  ABISELECT(-152,-124),
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&_ZN7S7268C82v7Ev,
  0,
  0,
  ABISELECT(-696,-568),
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&_ZN7S7268C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7268C62v3Ev,
  0,
  ABISELECT(-1568,-1232),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-1568,-1232),
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7268C3D1Ev,_ZTv0_n20_N7S7268C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7268C3D0Ev,_ZTv0_n20_N7S7268C3D0Ev),
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
  0,
  0,
  ABISELECT(-2328,-1840),
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
extern VTBL_ENTRY _ZTV7S7268C3[];
extern void _ZN7S7268C5D1Ev();
extern void _ZN7S7268C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C5__7S7268C3[] = {
  ABISELECT(664,540),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C5[0]),
  (VTBL_ENTRY)&_ZN7S7268C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C5D0Ev,
};
extern void _ZN8S7268C10D1Ev();
extern void _ZN8S7268C10D0Ev();
extern void _ZN8S7268C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C10__7S7268C3[] = {
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  0,
  (VTBL_ENTRY)&(_ZTI8S7268C10[0]),
  (VTBL_ENTRY)&_ZN8S7268C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7268C10D0Ev,
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
};
extern void _ZN7S7268C5D1Ev();
extern void _ZN7S7268C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C58S7268C10__A1__7S7268C3[] = {
  ABISELECT(-904,-692),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C5[0]),
  (VTBL_ENTRY)&_ZN7S7268C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C5D0Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C11__8S7268C10__7S7268C3[] = {
  0,
  0,
  ABISELECT(-760,-608),
  (VTBL_ENTRY)&(_ZTI8S7268C10[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
static  VTT_ENTRY vtt_S7268C3[] = {
  {&(_ZTV7S7268C3[6]),  6,32},
  {&(_tg__ZTV7S7268C5__7S7268C3[3]),  3,5},
  {&(_ZTV7S7268C3[15]),  15,32},
  {&(_ZTV7S7268C3[23]),  23,32},
  {&(_ZTV7S7268C3[30]),  30,32},
  {&(_tg__ZTV8S7268C10__7S7268C3[4]),  4,7},
  {&(_tg__ZTV7S7268C58S7268C10__A1__7S7268C3[3]),  3,5},
  {&(_tg__ZTV8S7268C11__8S7268C10__7S7268C3[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7S7268C3[];
extern  VTBL_ENTRY _ZTV7S7268C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C3[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7268C3D0Ev,_ZTv0_n20_N7S7268C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1568_N7S7268C3D0Ev,_ZThn1232_N7S7268C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7268C3D1Ev,_ZTv0_n20_N7S7268C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1568_N7S7268C3D1Ev,_ZThn1232_N7S7268C3D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7268C3 = {  "S7268C3", // class name
  bases_S7268C3, 8,
  &(vtc_S7268C3[0]), // expected_vtbl_contents
  &(vtt_S7268C3[0]), // expected_vtt_contents
  ABISELECT(2496,1936), // object size
  NSPAIRA(_ZTI7S7268C3),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV7S7268C3),32, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7268C3),8, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7268C2  : virtual S7268C3 {
  ::S7268C4 s7268c2f0;
  ::S7268C10 s7268c2f1[5];
  ::S7268C3 s7268c2f2[10];
  __tsi64 s7268c2f3[4];
  char s7268c2f4;
  ::S7268C3 s7268c2f5;
  ::S7268C3 s7268c2f6;
  virtual void  v8(); // _ZN7S7268C22v8Ev
  ~S7268C2(); // tgen
  S7268C2(); // tgen
};
//SIG(-1 S7268C2) C1{ VBC2{ BC3{ m Fs[6] FL Fc[5]} BC4{ VBC3 vd FC3 Fi Fp FC3[2]} VBC5{ v2 v3 FC3 Fc FC6{ BC7{ v7 FU8{ m Fl Fp[4] Fi} Fp FC3[8] Fp} VBC3 BC4 Fp[5] Fc:0 Fi Fi Fi:10 Fc[8] Fs Fi Fp[10] FC4 FL Fi Fp} Fp Fi Fi Fp Fi Fi:11 Fi} VBC9{ BC4 VBC10{ v4 v5 Fi Fp Fp Fl Fp[2] Fp Fl[6] FC3 Fi Fp Fc[2]} vd v6 Fl[4] FC4[4]} BC7 Fp Fi[6] FL FC4 Fc} v1 FC3 FC9[5] FC2[10] FL[4] Fc FC2 FC2}


void  S7268C2 ::v8(){vfunc_called(this, "_ZN7S7268C22v8Ev");}
S7268C2 ::~S7268C2(){ note_dtor("S7268C2", this);} // tgen
S7268C2 ::S7268C2(){ note_ctor("S7268C2", this);} // tgen

static void Test_S7268C2()
{
  extern Class_Descriptor cd_S7268C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4667,7225)];
    init_test(&cd_S7268C2, buf);
    S7268C2 *dp, &lv = *(dp=new (buf) S7268C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(37328,28896), "sizeof(S7268C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7268C2)");
    /*is_ambiguous_... S7268C3::S7268C4 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7268C3*), ABISELECT(34952,27056), "S7268C2");
    /*is_ambiguous_... S7268C3::S7268C5 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7268C5*)(S7268C3*), ABISELECT(35496,27500), "S7268C2");
    check_base_class_offset(lv, (S7268C4*)(S7268C5*)(S7268C10*), ABISELECT(35496,27500), "S7268C2");
    /*is_ambiguous_... S7268C3::S7268C5 */ AMB_check_base_class_offset(lv, (S7268C5*)(S7268C3*), ABISELECT(34832,26960), "S7268C2");
    check_base_class_offset(lv, (S7268C6*)(S7268C3*), ABISELECT(35528,27528), "S7268C2");
    check_base_class_offset(lv, (S7268C5*)(S7268C10*), ABISELECT(36400,28192), "S7268C2");
    check_base_class_offset(lv, (S7268C11*)(S7268C10*), ABISELECT(37160,28800), "S7268C2");
    check_base_class_offset(lv, (S7268C10*)(S7268C3*), ABISELECT(36400,28192), "S7268C2");
    check_base_class_offset(lv, (S7268C8*)(S7268C3*), ABISELECT(34984,27084), "S7268C2");
    check_base_class_offset(lv, (S7268C3*), ABISELECT(34832,26960), "S7268C2");
    check_field_offset(lv, s7268c2f0, ABISELECT(8,4), "S7268C2.s7268c2f0");
    check_field_offset(lv, s7268c2f1, ABISELECT(40,32), "S7268C2.s7268c2f1");
    check_field_offset(lv, s7268c2f2, ABISELECT(4840,3692), "S7268C2.s7268c2f2");
    check_field_offset(lv, s7268c2f3, ABISELECT(29800,23052), "S7268C2.s7268c2f3");
    check_field_offset(lv, s7268c2f4, ABISELECT(29832,23084), "S7268C2.s7268c2f4");
    check_field_offset(lv, s7268c2f5, ABISELECT(29840,23088), "S7268C2.s7268c2f5");
    check_field_offset(lv, s7268c2f6, ABISELECT(32336,25024), "S7268C2.s7268c2f6");
    test_class_info(&lv, &cd_S7268C2);
    dp->~S7268C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7268C2(Test_S7268C2, "S7268C2", ABISELECT(37328,28896));

#else // __cplusplus

extern void _ZN7S7268C2C1Ev();
extern void _ZN7S7268C2D1Ev();
Name_Map name_map_S7268C2[] = {
  NSPAIR(_ZN7S7268C2C1Ev),
  NSPAIR(_ZN7S7268C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7268C5;
extern VTBL_ENTRY _ZTI7S7268C5[];
extern  VTBL_ENTRY _ZTV7S7268C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C5[];
extern Class_Descriptor cd_S7268C6;
extern VTBL_ENTRY _ZTI7S7268C6[];
extern  VTBL_ENTRY _ZTV7S7268C6[];
extern Class_Descriptor cd_S7268C5;
extern VTBL_ENTRY _ZTI7S7268C5[];
extern  VTBL_ENTRY _ZTV7S7268C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C5[];
extern Class_Descriptor cd_S7268C11;
extern VTBL_ENTRY _ZTI8S7268C11[];
extern  VTBL_ENTRY _ZTV8S7268C11[];
extern Class_Descriptor cd_S7268C10;
extern VTBL_ENTRY _ZTI8S7268C10[];
extern  VTBL_ENTRY _ZTV8S7268C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7268C10[];
extern Class_Descriptor cd_S7268C8;
extern VTBL_ENTRY _ZTI7S7268C8[];
extern  VTBL_ENTRY _ZTV7S7268C8[];
extern Class_Descriptor cd_S7268C3;
extern VTBL_ENTRY _ZTI7S7268C3[];
extern  VTBL_ENTRY _ZTV7S7268C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C3[];
static Base_Class bases_S7268C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7268C4,    ABISELECT(34952,27056), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7268C4,    ABISELECT(35496,27500), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S7268C5,    ABISELECT(34832,26960), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7268C6,    ABISELECT(35528,27528), //bcp->offset
    23, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S7268C5,    ABISELECT(36400,28192), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S7268C11,    ABISELECT(37160,28800), //bcp->offset
    38, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S7268C10,    ABISELECT(36400,28192), //bcp->offset
    29, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S7268C8,    ABISELECT(34984,27084), //bcp->offset
    20, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7268C3,    ABISELECT(34832,26960), //bcp->offset
    10, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S7268C2[];
extern void _ZN7S7268C22v8Ev();
extern void _ZN7S7268C2D1Ev();
extern void _ZN7S7268C2D0Ev();
extern void ABISELECT(_ZTv0_n56_N7S7268C2D1Ev,_ZTv0_n28_N7S7268C2D1Ev)();
extern void ABISELECT(_ZThn34832_N7S7268C2D1Ev,_ZThn26960_N7S7268C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N7S7268C2D0Ev,_ZTv0_n28_N7S7268C2D0Ev)();
extern void ABISELECT(_ZThn34832_N7S7268C2D0Ev,_ZThn26960_N7S7268C2D0Ev)() __attribute__((weak));
extern void _ZN7S7268C82v7Ev();
extern void _ZN7S7268C62v2Ev();
extern void _ZN7S7268C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N7S7268C2D1Ev,_ZTv0_n20_N7S7268C2D1Ev)();
extern void ABISELECT(_ZThn36400_N7S7268C2D1Ev,_ZThn28192_N7S7268C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S7268C2D0Ev,_ZTv0_n20_N7S7268C2D0Ev)();
extern void ABISELECT(_ZThn36400_N7S7268C2D0Ev,_ZThn28192_N7S7268C2D0Ev)() __attribute__((weak));
extern void _ZN8S7268C102v6Ev();
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY vtc_S7268C2[] = {
  ABISELECT(37160,28800),
  ABISELECT(36400,28192),
  ABISELECT(35528,27528),
  ABISELECT(35496,27500),
  ABISELECT(34832,26960),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C2[0]),
  (VTBL_ENTRY)&_ZN7S7268C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7268C2D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C2D0Ev,
  ABISELECT(152,124),
  ABISELECT(-34832,-26960),
  ABISELECT(2328,1840),
  ABISELECT(1568,1232),
  ABISELECT(696,568),
  ABISELECT(664,540),
  ABISELECT(-34832,-26960),
  (VTBL_ENTRY)&(_ZTI7S7268C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7268C2D1Ev,_ZTv0_n28_N7S7268C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7268C2D0Ev,_ZTv0_n28_N7S7268C2D0Ev),
  ABISELECT(-34984,-27084),
  (VTBL_ENTRY)&(_ZTI7S7268C2[0]),
  (VTBL_ENTRY)&_ZN7S7268C82v7Ev,
  0,
  0,
  ABISELECT(-35528,-27528),
  (VTBL_ENTRY)&(_ZTI7S7268C2[0]),
  (VTBL_ENTRY)&_ZN7S7268C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7268C62v3Ev,
  0,
  ABISELECT(-36400,-28192),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-36400,-28192),
  (VTBL_ENTRY)&(_ZTI7S7268C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7268C2D1Ev,_ZTv0_n20_N7S7268C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7268C2D0Ev,_ZTv0_n20_N7S7268C2D0Ev),
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
  0,
  0,
  ABISELECT(-37160,-28800),
  (VTBL_ENTRY)&(_ZTI7S7268C2[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
extern VTBL_ENTRY _ZTV7S7268C2[];
extern void _ZN7S7268C3D1Ev();
extern void _ZN7S7268C3D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C3__7S7268C2[] = {
  ABISELECT(2328,1840),
  ABISELECT(1568,1232),
  ABISELECT(696,568),
  ABISELECT(664,540),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&_ZN7S7268C3D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C3D0Ev,
};
extern void _ZN7S7268C5D1Ev();
extern void _ZN7S7268C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C57S7268C3__7S7268C2[] = {
  ABISELECT(664,540),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C5[0]),
  (VTBL_ENTRY)&_ZN7S7268C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C5D0Ev,
};
extern void _ZN7S7268C62v2Ev();
extern void _ZN7S7268C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C6__7S7268C3__7S7268C2[] = {
  0,
  0,
  ABISELECT(-696,-568),
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&_ZN7S7268C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7268C62v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S7268C3D1Ev,_ZTv0_n20_N7S7268C3D1Ev)();
extern void ABISELECT(_ZThn1568_N7S7268C3D1Ev,_ZThn1232_N7S7268C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S7268C3D0Ev,_ZTv0_n20_N7S7268C3D0Ev)();
extern void ABISELECT(_ZThn1568_N7S7268C3D0Ev,_ZThn1232_N7S7268C3D0Ev)() __attribute__((weak));
extern void _ZN8S7268C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C10__7S7268C3__7S7268C2[] = {
  0,
  ABISELECT(-1568,-1232),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-1568,-1232),
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7268C3D1Ev,_ZTv0_n20_N7S7268C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7268C3D0Ev,_ZTv0_n20_N7S7268C3D0Ev),
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C11__7S7268C3__7S7268C2[] = {
  0,
  0,
  ABISELECT(-2328,-1840),
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
extern void _ZN8S7268C10D1Ev();
extern void _ZN8S7268C10D0Ev();
extern void _ZN8S7268C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C10__7S7268C2[] = {
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  0,
  (VTBL_ENTRY)&(_ZTI8S7268C10[0]),
  (VTBL_ENTRY)&_ZN8S7268C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7268C10D0Ev,
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
};
extern void _ZN7S7268C5D1Ev();
extern void _ZN7S7268C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C58S7268C10__A1__7S7268C2[] = {
  ABISELECT(-904,-692),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C5[0]),
  (VTBL_ENTRY)&_ZN7S7268C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C5D0Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C11__8S7268C10__7S7268C2[] = {
  0,
  0,
  ABISELECT(-760,-608),
  (VTBL_ENTRY)&(_ZTI8S7268C10[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
static  VTT_ENTRY vtt_S7268C2[] = {
  {&(_ZTV7S7268C2[7]),  7,44},
  {&(_ZTV7S7268C2[18]),  18,44},
  {&(_ZTV7S7268C2[27]),  27,44},
  {&(_ZTV7S7268C2[35]),  35,44},
  {&(_ZTV7S7268C2[42]),  42,44},
  {&(_ZTV7S7268C2[22]),  22,44},
  {&(_tg__ZTV7S7268C3__7S7268C2[6]),  6,8},
  {&(_tg__ZTV7S7268C57S7268C3__7S7268C2[3]),  3,5},
  {&(_tg__ZTV7S7268C6__7S7268C3__7S7268C2[4]),  4,6},
  {&(_tg__ZTV8S7268C10__7S7268C3__7S7268C2[6]),  6,9},
  {&(_tg__ZTV8S7268C11__7S7268C3__7S7268C2[4]),  4,6},
  {&(_tg__ZTV8S7268C10__7S7268C2[4]),  4,7},
  {&(_tg__ZTV7S7268C58S7268C10__A1__7S7268C2[3]),  3,5},
  {&(_tg__ZTV8S7268C11__8S7268C10__7S7268C2[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7S7268C2[];
extern  VTBL_ENTRY _ZTV7S7268C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C2[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7268C3D0Ev,_ZTv0_n20_N7S7268C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1568_N7S7268C3D0Ev,_ZThn1232_N7S7268C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7268C3D1Ev,_ZTv0_n20_N7S7268C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1568_N7S7268C3D1Ev,_ZThn1232_N7S7268C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7268C2D0Ev,_ZTv0_n20_N7S7268C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn36400_N7S7268C2D0Ev,_ZThn28192_N7S7268C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7268C2D1Ev,_ZTv0_n20_N7S7268C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn36400_N7S7268C2D1Ev,_ZThn28192_N7S7268C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7268C2D0Ev,_ZTv0_n28_N7S7268C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn34832_N7S7268C2D0Ev,_ZThn26960_N7S7268C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7268C2D1Ev,_ZTv0_n28_N7S7268C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn34832_N7S7268C2D1Ev,_ZThn26960_N7S7268C2D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7268C2 = {  "S7268C2", // class name
  bases_S7268C2, 9,
  &(vtc_S7268C2[0]), // expected_vtbl_contents
  &(vtt_S7268C2[0]), // expected_vtt_contents
  ABISELECT(37328,28896), // object size
  NSPAIRA(_ZTI7S7268C2),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7S7268C2),44, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7268C2),14, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7268C13  : virtual S7268C5 , S7268C11 {
  int s7268c13f0;
  void *s7268c13f1;
  virtual void  v9(); // _ZN8S7268C132v9Ev
  ~S7268C13(); // tgen
  S7268C13(); // tgen
};
//SIG(-1 S7268C13) C1{ VBC2{ VBC3{ m Fs[6] FL Fc[5]} vd FC3 Fi Fp FC3[2]} BC4{ v2 v3 Fi Fp[2] Fl Fp[3] Fl[6] FC3 Fi Fp Fc[2]} v1 Fi Fp}


void  S7268C13 ::v9(){vfunc_called(this, "_ZN8S7268C132v9Ev");}
S7268C13 ::~S7268C13(){ note_dtor("S7268C13", this);} // tgen
S7268C13 ::S7268C13(){ note_ctor("S7268C13", this);} // tgen

static void Test_S7268C13()
{
  extern Class_Descriptor cd_S7268C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(42,58)];
    init_test(&cd_S7268C13, buf);
    S7268C13 *dp, &lv = *(dp=new (buf) S7268C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(328,228), "sizeof(S7268C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7268C13)");
    check_base_class_offset(lv, (S7268C4*)(S7268C5*), ABISELECT(296,200), "S7268C13");
    check_base_class_offset(lv, (S7268C5*), ABISELECT(176,104), "S7268C13");
    check_base_class_offset(lv, (S7268C11*), 0, "S7268C13");
    check_field_offset(lv, s7268c13f0, ABISELECT(164,96), "S7268C13.s7268c13f0");
    check_field_offset(lv, s7268c13f1, ABISELECT(168,100), "S7268C13.s7268c13f1");
    test_class_info(&lv, &cd_S7268C13);
    dp->~S7268C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7268C13(Test_S7268C13, "S7268C13", ABISELECT(328,228));

#else // __cplusplus

extern void _ZN8S7268C13C1Ev();
extern void _ZN8S7268C13D1Ev();
Name_Map name_map_S7268C13[] = {
  NSPAIR(_ZN8S7268C13C1Ev),
  NSPAIR(_ZN8S7268C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7268C5;
extern VTBL_ENTRY _ZTI7S7268C5[];
extern  VTBL_ENTRY _ZTV7S7268C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C5[];
extern Class_Descriptor cd_S7268C11;
extern VTBL_ENTRY _ZTI8S7268C11[];
extern  VTBL_ENTRY _ZTV8S7268C11[];
static Base_Class bases_S7268C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7268C4,    ABISELECT(296,200), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S7268C5,    ABISELECT(176,104), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7268C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7268C13[];
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
extern void _ZN8S7268C132v9Ev();
extern void _ZN8S7268C13D1Ev();
extern void _ZN8S7268C13D0Ev();
extern void ABISELECT(_ZTv0_n32_N8S7268C13D1Ev,_ZTv0_n16_N8S7268C13D1Ev)();
extern void ABISELECT(_ZThn176_N8S7268C13D1Ev,_ZThn104_N8S7268C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7268C13D0Ev,_ZTv0_n16_N8S7268C13D0Ev)();
extern void ABISELECT(_ZThn176_N8S7268C13D0Ev,_ZThn104_N8S7268C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7268C13[] = {
  ABISELECT(296,200),
  ABISELECT(176,104),
  0,
  (VTBL_ENTRY)&(_ZTI8S7268C13[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
  (VTBL_ENTRY)&_ZN8S7268C132v9Ev,
  (VTBL_ENTRY)&_ZN8S7268C13D1Ev,
  (VTBL_ENTRY)&_ZN8S7268C13D0Ev,
  ABISELECT(-176,-104),
  ABISELECT(120,96),
  ABISELECT(-176,-104),
  (VTBL_ENTRY)&(_ZTI8S7268C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7268C13D1Ev,_ZTv0_n16_N8S7268C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7268C13D0Ev,_ZTv0_n16_N8S7268C13D0Ev),
};
extern VTBL_ENTRY _ZTV8S7268C13[];
extern void _ZN7S7268C5D1Ev();
extern void _ZN7S7268C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C5__8S7268C13[] = {
  ABISELECT(120,96),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C5[0]),
  (VTBL_ENTRY)&_ZN7S7268C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C5D0Ev,
};
static  VTT_ENTRY vtt_S7268C13[] = {
  {&(_ZTV8S7268C13[4]),  4,15},
  {&(_ZTV8S7268C13[13]),  13,15},
  {&(_tg__ZTV7S7268C5__8S7268C13[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S7268C13[];
extern  VTBL_ENTRY _ZTV8S7268C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7268C13[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7268C13D0Ev,_ZTv0_n16_N8S7268C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7268C13D0Ev,_ZThn104_N8S7268C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7268C13D1Ev,_ZTv0_n16_N8S7268C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7268C13D1Ev,_ZThn104_N8S7268C13D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7268C13 = {  "S7268C13", // class name
  bases_S7268C13, 3,
  &(vtc_S7268C13[0]), // expected_vtbl_contents
  &(vtt_S7268C13[0]), // expected_vtt_contents
  ABISELECT(328,228), // object size
  NSPAIRA(_ZTI8S7268C13),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S7268C13),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7268C13),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7268C15  : S7268C6 , virtual S7268C8 , virtual S7268C4 , S7268C10 {
  int s7268c15f0;
  int s7268c15f1;
  char s7268c15f2[4];
  void *s7268c15f3[3];
  short s7268c15f4;
  int s7268c15f5;
  int s7268c15f6;
  long double s7268c15f7;
  void *s7268c15f8;
  void *s7268c15f9;
  int s7268c15f10;
  virtual  ~S7268C15(); // _ZN8S7268C15D2Ev
  S7268C15(); // tgen
};
//SIG(-1 S7268C15) C1{ BC2{ v1 v2 FC3{ m Fs[6] FL Fc[5]} Fc FC4{ BC5{ v3 FU6{ m Fl Fp[4] Fi} Fp FC3[8] Fp} VBC3 BC7{ VBC3 vd FC3 Fi Fp FC3[2]} Fp[5] Fc:0 Fi Fi Fi:10 Fc[8] Fs Fi Fp[10] FC7 FL Fi Fp} Fp Fi Fi Fp Fi Fi:11 Fi} VBC5 VBC3 BC8{ BC7 VBC9{ v4 v5 Fi Fp Fp Fl Fp[2] Fp Fl[6] FC3 Fi Fp Fc[2]} vd v6 Fl[4] FC7[4]} vd Fi Fi Fc[4] Fp[3] Fs Fi Fi FD Fp Fp Fi}


 S7268C15 ::~S7268C15(){ note_dtor("S7268C15", this);}
S7268C15 ::S7268C15(){ note_ctor("S7268C15", this);} // tgen

static void Test_S7268C15()
{
  extern Class_Descriptor cd_S7268C15;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(142,428)];
    init_test(&cd_S7268C15, buf);
    S7268C15 *dp, &lv = *(dp=new (buf) S7268C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2256,1708), "sizeof(S7268C15)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7268C15)");
    check_base_class_offset(lv, (S7268C6*), 0, "S7268C15");
    check_base_class_offset(lv, (S7268C8*), ABISELECT(1736,1332), "S7268C15");
    check_base_class_offset(lv, (S7268C4*), ABISELECT(2048,1584), "S7268C15");
    check_base_class_offset(lv, (S7268C4*)(S7268C5*)(S7268C10*), ABISELECT(2048,1584), "S7268C15");
    check_base_class_offset(lv, (S7268C5*)(S7268C10*), ABISELECT(872,664), "S7268C15");
    check_base_class_offset(lv, (S7268C11*)(S7268C10*), ABISELECT(2080,1612), "S7268C15");
    check_base_class_offset(lv, (S7268C10*), ABISELECT(872,664), "S7268C15");
    check_field_offset(lv, s7268c15f0, ABISELECT(1632,1272), "S7268C15.s7268c15f0");
    check_field_offset(lv, s7268c15f1, ABISELECT(1636,1276), "S7268C15.s7268c15f1");
    check_field_offset(lv, s7268c15f2, ABISELECT(1640,1280), "S7268C15.s7268c15f2");
    check_field_offset(lv, s7268c15f3, ABISELECT(1648,1284), "S7268C15.s7268c15f3");
    check_field_offset(lv, s7268c15f4, ABISELECT(1672,1296), "S7268C15.s7268c15f4");
    check_field_offset(lv, s7268c15f5, ABISELECT(1676,1300), "S7268C15.s7268c15f5");
    check_field_offset(lv, s7268c15f6, ABISELECT(1680,1304), "S7268C15.s7268c15f6");
    check_field_offset(lv, s7268c15f7, ABISELECT(1696,1308), "S7268C15.s7268c15f7");
    check_field_offset(lv, s7268c15f8, ABISELECT(1712,1320), "S7268C15.s7268c15f8");
    check_field_offset(lv, s7268c15f9, ABISELECT(1720,1324), "S7268C15.s7268c15f9");
    check_field_offset(lv, s7268c15f10, ABISELECT(1728,1328), "S7268C15.s7268c15f10");
    test_class_info(&lv, &cd_S7268C15);
    dp->~S7268C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7268C15(Test_S7268C15, "S7268C15", ABISELECT(2256,1708));

#else // __cplusplus

extern void _ZN8S7268C15C1Ev();
extern void _ZN8S7268C15D2Ev();
Name_Map name_map_S7268C15[] = {
  NSPAIR(_ZN8S7268C15C1Ev),
  NSPAIR(_ZN8S7268C15D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7268C6;
extern VTBL_ENTRY _ZTI7S7268C6[];
extern  VTBL_ENTRY _ZTV7S7268C6[];
extern Class_Descriptor cd_S7268C8;
extern VTBL_ENTRY _ZTI7S7268C8[];
extern  VTBL_ENTRY _ZTV7S7268C8[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7268C5;
extern VTBL_ENTRY _ZTI7S7268C5[];
extern  VTBL_ENTRY _ZTV7S7268C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C5[];
extern Class_Descriptor cd_S7268C11;
extern VTBL_ENTRY _ZTI8S7268C11[];
extern  VTBL_ENTRY _ZTV8S7268C11[];
extern Class_Descriptor cd_S7268C10;
extern VTBL_ENTRY _ZTI8S7268C10[];
extern  VTBL_ENTRY _ZTV8S7268C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7268C10[];
static Base_Class bases_S7268C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7268C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7268C8,    ABISELECT(1736,1332), //bcp->offset
    16, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7268C4,    ABISELECT(2048,1584), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7268C5,    ABISELECT(872,664), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7268C11,    ABISELECT(2080,1612), //bcp->offset
    20, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S7268C10,    ABISELECT(872,664), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7268C15[];
extern void _ZN7S7268C62v2Ev();
extern void _ZN7S7268C62v3Ev();
extern void _ZN8S7268C15D1Ev();
extern void _ZN8S7268C15D0Ev();
extern void ABISELECT(_ZThn872_N8S7268C15D1Ev,_ZThn664_N8S7268C15D1Ev)();
extern void ABISELECT(_ZThn872_N8S7268C15D0Ev,_ZThn664_N8S7268C15D0Ev)();
extern void _ZN8S7268C102v6Ev();
extern void _ZN7S7268C82v7Ev();
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY vtc_S7268C15[] = {
  ABISELECT(2080,1612),
  ABISELECT(2048,1584),
  ABISELECT(1736,1332),
  0,
  (VTBL_ENTRY)&(_ZTI8S7268C15[0]),
  (VTBL_ENTRY)&_ZN7S7268C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7268C62v3Ev,
  (VTBL_ENTRY)&_ZN8S7268C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7268C15D0Ev,
  ABISELECT(1208,948),
  ABISELECT(1176,920),
  ABISELECT(-872,-664),
  (VTBL_ENTRY)&(_ZTI8S7268C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn872_N8S7268C15D1Ev,_ZThn664_N8S7268C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn872_N8S7268C15D0Ev,_ZThn664_N8S7268C15D0Ev),
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
  0,
  ABISELECT(-1736,-1332),
  (VTBL_ENTRY)&(_ZTI8S7268C15[0]),
  (VTBL_ENTRY)&_ZN7S7268C82v7Ev,
  0,
  0,
  ABISELECT(-2080,-1612),
  (VTBL_ENTRY)&(_ZTI8S7268C15[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
extern VTBL_ENTRY _ZTV8S7268C15[];
extern void _ZN8S7268C10D1Ev();
extern void _ZN8S7268C10D0Ev();
extern void _ZN8S7268C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C10__8S7268C15[] = {
  ABISELECT(1208,948),
  ABISELECT(1176,920),
  0,
  (VTBL_ENTRY)&(_ZTI8S7268C10[0]),
  (VTBL_ENTRY)&_ZN8S7268C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7268C10D0Ev,
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
};
extern void _ZN7S7268C5D1Ev();
extern void _ZN7S7268C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C58S7268C10__8S7268C15[] = {
  ABISELECT(1176,920),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C5[0]),
  (VTBL_ENTRY)&_ZN7S7268C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C5D0Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C11__8S7268C10__8S7268C15[] = {
  0,
  0,
  ABISELECT(-1208,-948),
  (VTBL_ENTRY)&(_ZTI8S7268C10[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
static  VTT_ENTRY vtt_S7268C15[] = {
  {&(_ZTV8S7268C15[5]),  5,26},
  {&(_tg__ZTV8S7268C10__8S7268C15[4]),  4,7},
  {&(_tg__ZTV7S7268C58S7268C10__8S7268C15[3]),  3,5},
  {&(_tg__ZTV8S7268C11__8S7268C10__8S7268C15[4]),  4,6},
  {&(_ZTV8S7268C15[19]),  19,26},
  {&(_ZTV8S7268C15[13]),  13,26},
  {&(_ZTV8S7268C15[24]),  24,26},
};
extern VTBL_ENTRY _ZTI8S7268C15[];
extern  VTBL_ENTRY _ZTV8S7268C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7268C15[];
Class_Descriptor cd_S7268C15 = {  "S7268C15", // class name
  bases_S7268C15, 6,
  &(vtc_S7268C15[0]), // expected_vtbl_contents
  &(vtt_S7268C15[0]), // expected_vtt_contents
  ABISELECT(2256,1708), // object size
  NSPAIRA(_ZTI8S7268C15),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S7268C15),26, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7268C15),7, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S7268C16  {
  int s7268c16f0;
  char s7268c16f1[7];
  int s7268c16f2[10];
  int s7268c16f3;
  long double s7268c16f4[8];
  int s7268c16f5;
  void *s7268c16f6;
  int s7268c16f7;
  void  mf7268c16(); // _ZN8S7268C169mf7268c16Ev
};
//SIG(1 S7268C16) U1{ m Fi Fc[7] Fi[10] Fi FD[8] Fi Fp Fi}

#endif // __cplusplus
#ifdef __cplusplus

struct  S7268C14  : S7268C3 , S7268C15 , virtual S7268C2 , S7268C4 , virtual S7268C13 {
  ::S7268C16 s7268c14f0;
  void *s7268c14f1;
  int s7268c14f2;
  __tsi64 s7268c14f3;
  __tsi64 s7268c14f4;
  ::S7268C15 s7268c14f5;
  __tsi64 s7268c14f6;
  int s7268c14f7[8];
  int s7268c14f8;
  virtual  ~S7268C14(); // _ZN8S7268C14D2Ev
  virtual void  v10(); // _ZN8S7268C143v10Ev
  S7268C14(); // tgen
};
//SIG(-1 S7268C14) C1{ BC2{ BC3{ m Fs[6] FL Fc[5]} BC4{ VBC3 vd FC3 Fi Fp FC3[2]} VBC5{ v2 v3 FC3 Fc FC6{ BC7{ v7 FU8{ m Fl Fp[4] Fi} Fp FC3[8] Fp} VBC3 BC4 Fp[5] Fc:0 Fi Fi Fi:10 Fc[8] Fs Fi Fp[10] FC4 FL Fi Fp} Fp Fi Fi Fp Fi Fi:11 Fi} VBC9{ BC4 VBC10{ v4 v5 Fi Fp Fp Fl Fp[2] Fp Fl[6] FC3 Fi Fp Fc[2]} vd v6 Fl[4] FC4[4]} BC7 Fp Fi[6] FL FC4 Fc} BC11{ BC5 VBC7 VBC3 BC9 vd Fi Fi Fc[4] Fp[3] Fs Fi Fi FD Fp Fp Fi} VBC12{ VBC2 v8 FC3 FC9[5] FC2[10] FL[4] Fc FC2 FC2} BC3 VBC13{ VBC4 BC10 v9 Fi Fp} vd v1 FU14{ m Fi Fc[7] Fi[10] Fi FD[8] Fi Fp Fi} Fp Fi FL FL FC11 FL Fi[8] Fi}


 S7268C14 ::~S7268C14(){ note_dtor("S7268C14", this);}
void  S7268C14 ::v10(){vfunc_called(this, "_ZN8S7268C143v10Ev");}
S7268C14 ::S7268C14(){ note_ctor("S7268C14", this);} // tgen

static void Test_S7268C14()
{
  extern Class_Descriptor cd_S7268C14;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(2679,8281)];
    init_test(&cd_S7268C14, buf);
    S7268C14 *dp, &lv = *(dp=new (buf) S7268C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(42848,33120), "sizeof(S7268C14)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7268C14)");
    /*is_ambiguous_... S7268C14::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7268C3*), ABISELECT(120,96), "S7268C14");
    /*is_ambiguous_... S7268C14::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7268C5*)(S7268C3*), ABISELECT(4912,3772), "S7268C14");
    /*is_ambiguous_... S7268C14::S7268C10 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7268C5*)(S7268C10*), ABISELECT(4912,3772), "S7268C14");
    check_base_class_offset(lv, (S7268C4*)(S7268C15*), ABISELECT(4912,3772), "S7268C14");
    check_base_class_offset(lv, (S7268C4*)(S7268C5*)(S7268C10*)(S7268C15*), ABISELECT(4912,3772), "S7268C14");
    /*is_ambiguous_... S7268C14::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7268C5*)(S7268C3*), ABISELECT(4912,3772), "S7268C14");
    /*is_ambiguous_... S7268C14::S7268C5 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7268C5*), ABISELECT(4912,3772), "S7268C14");
    /*is_ambiguous_... S7268C14::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C5*)(S7268C3*), 0, "S7268C14");
    /*is_ambiguous_... S7268C14::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C6*)(S7268C3*), ABISELECT(4944,3800), "S7268C14");
    /*is_ambiguous_... S7268C14::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C6*)(S7268C3*), ABISELECT(4944,3800), "S7268C14");
    /*is_ambiguous_... S7268C14::S7268C10 */ AMB_check_base_class_offset(lv, (S7268C5*)(S7268C10*), ABISELECT(5816,4464), "S7268C14");
    /*is_ambiguous_... S7268C14::S7268C10 */ AMB_check_base_class_offset(lv, (S7268C11*)(S7268C10*), ABISELECT(6576,5072), "S7268C14");
    check_base_class_offset(lv, (S7268C11*)(S7268C10*)(S7268C15*), ABISELECT(6576,5072), "S7268C14");
    /*is_ambiguous_... S7268C14::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C10*)(S7268C3*), ABISELECT(5816,4464), "S7268C14");
    /*is_ambiguous_... S7268C14::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C10*)(S7268C3*), ABISELECT(5816,4464), "S7268C14");
    /*is_ambiguous_... S7268C14::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C8*)(S7268C3*), ABISELECT(152,124), "S7268C14");
    /*is_ambiguous_... S7268C14::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C3*), 0, "S7268C14");
    check_base_class_offset(lv, (S7268C6*)(S7268C15*), ABISELECT(672,540), "S7268C14");
    check_base_class_offset(lv, (S7268C8*)(S7268C15*), ABISELECT(6744,5168), "S7268C14");
    check_base_class_offset(lv, (S7268C5*)(S7268C10*)(S7268C15*), ABISELECT(1544,1204), "S7268C14");
    check_base_class_offset(lv, (S7268C10*)(S7268C15*), ABISELECT(1544,1204), "S7268C14");
    check_base_class_offset(lv, (S7268C15*), ABISELECT(672,540), "S7268C14");
    /*is_ambiguous_... S7268C14::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7268C3*), ABISELECT(42008,32476), "S7268C14");
    /*is_ambiguous_... S7268C14::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C5*)(S7268C3*), ABISELECT(41888,32380), "S7268C14");
    /*is_ambiguous_... S7268C14::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C8*)(S7268C3*), ABISELECT(42040,32504), "S7268C14");
    check_base_class_offset(lv, (S7268C3*)(S7268C2*), ABISELECT(41888,32380), "S7268C14");
    check_base_class_offset(lv, (S7268C2*), ABISELECT(7056,5420), "S7268C14");
    /*is_ambiguous_... S7268C14::S7268C4 */ AMB_check_base_class_offset(lv, (S7268C4*), ABISELECT(2408,1872), "S7268C14");
    check_base_class_offset(lv, (S7268C5*)(S7268C13*), ABISELECT(42728,33024), "S7268C14");
    check_base_class_offset(lv, (S7268C11*)(S7268C13*), ABISELECT(42552,32920), "S7268C14");
    check_base_class_offset(lv, (S7268C13*), ABISELECT(42552,32920), "S7268C14");
    check_field_offset(lv, s7268c14f0, ABISELECT(2448,1900), "S7268C14.s7268c14f0");
    check_field_offset(lv, s7268c14f1, ABISELECT(2576,1996), "S7268C14.s7268c14f1");
    check_field_offset(lv, s7268c14f2, ABISELECT(2584,2000), "S7268C14.s7268c14f2");
    check_field_offset(lv, s7268c14f3, ABISELECT(2592,2004), "S7268C14.s7268c14f3");
    check_field_offset(lv, s7268c14f4, ABISELECT(2600,2012), "S7268C14.s7268c14f4");
    check_field_offset(lv, s7268c14f5, ABISELECT(2608,2020), "S7268C14.s7268c14f5");
    check_field_offset(lv, s7268c14f6, ABISELECT(4864,3728), "S7268C14.s7268c14f6");
    check_field_offset(lv, s7268c14f7, ABISELECT(4872,3736), "S7268C14.s7268c14f7");
    check_field_offset(lv, s7268c14f8, ABISELECT(4904,3768), "S7268C14.s7268c14f8");
    test_class_info(&lv, &cd_S7268C14);
    dp->~S7268C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7268C14(Test_S7268C14, "S7268C14", ABISELECT(42848,33120));

#else // __cplusplus

extern void _ZN8S7268C14C1Ev();
extern void _ZN8S7268C14D2Ev();
Name_Map name_map_S7268C14[] = {
  NSPAIR(_ZN8S7268C14C1Ev),
  NSPAIR(_ZN8S7268C14D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7268C5;
extern VTBL_ENTRY _ZTI7S7268C5[];
extern  VTBL_ENTRY _ZTV7S7268C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C5[];
extern Class_Descriptor cd_S7268C6;
extern VTBL_ENTRY _ZTI7S7268C6[];
extern  VTBL_ENTRY _ZTV7S7268C6[];
extern Class_Descriptor cd_S7268C5;
extern VTBL_ENTRY _ZTI7S7268C5[];
extern  VTBL_ENTRY _ZTV7S7268C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C5[];
extern Class_Descriptor cd_S7268C11;
extern VTBL_ENTRY _ZTI8S7268C11[];
extern  VTBL_ENTRY _ZTV8S7268C11[];
extern Class_Descriptor cd_S7268C10;
extern VTBL_ENTRY _ZTI8S7268C10[];
extern  VTBL_ENTRY _ZTV8S7268C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7268C10[];
extern Class_Descriptor cd_S7268C8;
extern VTBL_ENTRY _ZTI7S7268C8[];
extern  VTBL_ENTRY _ZTV7S7268C8[];
extern Class_Descriptor cd_S7268C3;
extern VTBL_ENTRY _ZTI7S7268C3[];
extern  VTBL_ENTRY _ZTV7S7268C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C3[];
extern Class_Descriptor cd_S7268C6;
extern VTBL_ENTRY _ZTI7S7268C6[];
extern  VTBL_ENTRY _ZTV7S7268C6[];
extern Class_Descriptor cd_S7268C8;
extern VTBL_ENTRY _ZTI7S7268C8[];
extern  VTBL_ENTRY _ZTV7S7268C8[];
extern Class_Descriptor cd_S7268C5;
extern VTBL_ENTRY _ZTI7S7268C5[];
extern  VTBL_ENTRY _ZTV7S7268C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C5[];
extern Class_Descriptor cd_S7268C10;
extern VTBL_ENTRY _ZTI8S7268C10[];
extern  VTBL_ENTRY _ZTV8S7268C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7268C10[];
extern Class_Descriptor cd_S7268C15;
extern VTBL_ENTRY _ZTI8S7268C15[];
extern  VTBL_ENTRY _ZTV8S7268C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7268C15[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7268C5;
extern VTBL_ENTRY _ZTI7S7268C5[];
extern  VTBL_ENTRY _ZTV7S7268C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C5[];
extern Class_Descriptor cd_S7268C8;
extern VTBL_ENTRY _ZTI7S7268C8[];
extern  VTBL_ENTRY _ZTV7S7268C8[];
extern Class_Descriptor cd_S7268C3;
extern VTBL_ENTRY _ZTI7S7268C3[];
extern  VTBL_ENTRY _ZTV7S7268C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C3[];
extern Class_Descriptor cd_S7268C2;
extern VTBL_ENTRY _ZTI7S7268C2[];
extern  VTBL_ENTRY _ZTV7S7268C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C2[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7268C5;
extern VTBL_ENTRY _ZTI7S7268C5[];
extern  VTBL_ENTRY _ZTV7S7268C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C5[];
extern Class_Descriptor cd_S7268C11;
extern VTBL_ENTRY _ZTI8S7268C11[];
extern  VTBL_ENTRY _ZTV8S7268C11[];
extern Class_Descriptor cd_S7268C13;
extern VTBL_ENTRY _ZTI8S7268C13[];
extern  VTBL_ENTRY _ZTV8S7268C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7268C13[];
static Base_Class bases_S7268C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7268C4,    ABISELECT(120,96), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7268C4,    ABISELECT(4912,3772), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S7268C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7268C6,    ABISELECT(4944,3800), //bcp->offset
    33, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S7268C5,    ABISELECT(5816,4464), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S7268C11,    ABISELECT(6576,5072), //bcp->offset
    48, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S7268C10,    ABISELECT(5816,4464), //bcp->offset
    39, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S7268C8,    ABISELECT(152,124), //bcp->offset
    14, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7268C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7268C6,    ABISELECT(672,540), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S7268C8,    ABISELECT(6744,5168), //bcp->offset
    54, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S7268C5,    ABISELECT(1544,1204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S7268C10,    ABISELECT(1544,1204), //bcp->offset
    26, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S7268C15,    ABISELECT(672,540), //bcp->offset
    17, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7268C4,    ABISELECT(42008,32476), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S7268C5,    ABISELECT(41888,32380), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S7268C8,    ABISELECT(42040,32504), //bcp->offset
    80, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S7268C3,    ABISELECT(41888,32380), //bcp->offset
    70, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    18, //immediately_derived
  0, 1},
  {&cd_S7268C2,    ABISELECT(7056,5420), //bcp->offset
    58, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7268C4,    ABISELECT(2408,1872), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7268C5,    ABISELECT(42728,33024), //bcp->offset
    96, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    41, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    22, //immediately_derived
  0, 1},
  {&cd_S7268C11,    ABISELECT(42552,32920), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S7268C13,    ABISELECT(42552,32920), //bcp->offset
    83, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    39, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7268C14[];
extern void _ZN8S7268C14D1Ev();
extern void _ZN8S7268C14D0Ev();
extern void _ZN8S7268C143v10Ev();
extern void _ZN7S7268C82v7Ev();
extern void _ZN7S7268C62v2Ev();
extern void _ZN7S7268C62v3Ev();
extern void ABISELECT(_ZThn672_N8S7268C14D1Ev,_ZThn540_N8S7268C14D1Ev)();
extern void ABISELECT(_ZThn672_N8S7268C14D0Ev,_ZThn540_N8S7268C14D0Ev)();
extern void ABISELECT(_ZThn1544_N8S7268C14D1Ev,_ZThn1204_N8S7268C14D1Ev)();
extern void ABISELECT(_ZThn1544_N8S7268C14D0Ev,_ZThn1204_N8S7268C14D0Ev)();
extern void _ZN8S7268C102v6Ev();
extern void _ZN7S7268C62v2Ev();
extern void _ZN7S7268C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S7268C14D1Ev,_ZTv0_n20_N8S7268C14D1Ev)();
extern void ABISELECT(_ZThn5816_N8S7268C14D1Ev,_ZThn4464_N8S7268C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7268C14D0Ev,_ZTv0_n20_N8S7268C14D0Ev)();
extern void ABISELECT(_ZThn5816_N8S7268C14D0Ev,_ZThn4464_N8S7268C14D0Ev)() __attribute__((weak));
extern void _ZN8S7268C102v6Ev();
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
extern void _ZN7S7268C82v7Ev();
extern void _ZN7S7268C22v8Ev();
extern void ABISELECT(_ZTv0_n72_N8S7268C14D1Ev,_ZTv0_n36_N8S7268C14D1Ev)();
extern void ABISELECT(_ZThn7056_N8S7268C14D1Ev,_ZThn5420_N8S7268C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S7268C14D0Ev,_ZTv0_n36_N8S7268C14D0Ev)();
extern void ABISELECT(_ZThn7056_N8S7268C14D0Ev,_ZThn5420_N8S7268C14D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7268C14D1Ev,_ZTv0_n28_N8S7268C14D1Ev)();
extern void ABISELECT(_ZThn41888_N8S7268C14D1Ev,_ZThn32380_N8S7268C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7268C14D0Ev,_ZTv0_n28_N8S7268C14D0Ev)();
extern void ABISELECT(_ZThn41888_N8S7268C14D0Ev,_ZThn32380_N8S7268C14D0Ev)() __attribute__((weak));
extern void _ZN7S7268C82v7Ev();
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
extern void _ZN8S7268C132v9Ev();
extern void ABISELECT(_ZTv0_n64_N8S7268C14D1Ev,_ZTv0_n32_N8S7268C14D1Ev)();
extern void ABISELECT(_ZThn42552_N8S7268C14D1Ev,_ZThn32920_N8S7268C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S7268C14D0Ev,_ZTv0_n32_N8S7268C14D0Ev)();
extern void ABISELECT(_ZThn42552_N8S7268C14D0Ev,_ZThn32920_N8S7268C14D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7268C14D1Ev,_ZTv0_n16_N8S7268C14D1Ev)();
extern void ABISELECT(_ZThn42728_N8S7268C14D1Ev,_ZThn33024_N8S7268C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7268C14D0Ev,_ZTv0_n16_N8S7268C14D0Ev)();
extern void ABISELECT(_ZThn42728_N8S7268C14D0Ev,_ZThn33024_N8S7268C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7268C14[] = {
  ABISELECT(42728,33024),
  ABISELECT(42552,32920),
  ABISELECT(41888,32380),
  ABISELECT(7056,5420),
  ABISELECT(6744,5168),
  ABISELECT(6576,5072),
  ABISELECT(5816,4464),
  ABISELECT(4944,3800),
  ABISELECT(4912,3772),
  0,
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&_ZN8S7268C14D1Ev,
  (VTBL_ENTRY)&_ZN8S7268C14D0Ev,
  (VTBL_ENTRY)&_ZN8S7268C143v10Ev,
  ABISELECT(-152,-124),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&_ZN7S7268C82v7Ev,
  ABISELECT(5904,4532),
  ABISELECT(4240,3232),
  ABISELECT(6072,4628),
  ABISELECT(-672,-540),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&_ZN7S7268C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7268C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S7268C14D1Ev,_ZThn540_N8S7268C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S7268C14D0Ev,_ZThn540_N8S7268C14D0Ev),
  ABISELECT(5032,3868),
  ABISELECT(3368,2568),
  ABISELECT(-1544,-1204),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1544_N8S7268C14D1Ev,_ZThn1204_N8S7268C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1544_N8S7268C14D0Ev,_ZThn1204_N8S7268C14D0Ev),
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
  0,
  0,
  ABISELECT(-4944,-3800),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&_ZN7S7268C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7268C62v3Ev,
  0,
  ABISELECT(-5816,-4464),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-5816,-4464),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7268C14D1Ev,_ZTv0_n20_N8S7268C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7268C14D0Ev,_ZTv0_n20_N8S7268C14D0Ev),
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
  0,
  0,
  ABISELECT(-6576,-5072),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
  0,
  ABISELECT(-6744,-5168),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&_ZN7S7268C82v7Ev,
  ABISELECT(-7056,-5420),
  0,
  ABISELECT(-480,-348),
  ABISELECT(-1240,-956),
  ABISELECT(-2112,-1620),
  ABISELECT(-2144,-1648),
  ABISELECT(34832,26960),
  ABISELECT(-7056,-5420),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&_ZN7S7268C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S7268C14D1Ev,_ZTv0_n36_N8S7268C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S7268C14D0Ev,_ZTv0_n36_N8S7268C14D0Ev),
  ABISELECT(152,124),
  ABISELECT(-41888,-32380),
  ABISELECT(-35312,-27308),
  ABISELECT(-36072,-27916),
  ABISELECT(-36944,-28580),
  ABISELECT(-36976,-28608),
  ABISELECT(-41888,-32380),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7268C14D1Ev,_ZTv0_n28_N8S7268C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7268C14D0Ev,_ZTv0_n28_N8S7268C14D0Ev),
  ABISELECT(-42040,-32504),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&_ZN7S7268C82v7Ev,
  ABISELECT(-42552,-32920),
  0,
  0,
  0,
  ABISELECT(-37640,-29148),
  ABISELECT(176,104),
  ABISELECT(-42552,-32920),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
  (VTBL_ENTRY)&_ZN8S7268C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7268C14D1Ev,_ZTv0_n32_N8S7268C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7268C14D0Ev,_ZTv0_n32_N8S7268C14D0Ev),
  ABISELECT(-42728,-33024),
  ABISELECT(-37816,-29252),
  ABISELECT(-42728,-33024),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7268C14D1Ev,_ZTv0_n16_N8S7268C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7268C14D0Ev,_ZTv0_n16_N8S7268C14D0Ev),
};
extern VTBL_ENTRY _ZTV8S7268C14[];
extern void _ZN7S7268C3D1Ev();
extern void _ZN7S7268C3D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C3__A__8S7268C14[] = {
  ABISELECT(6576,5072),
  ABISELECT(5816,4464),
  ABISELECT(4944,3800),
  ABISELECT(4912,3772),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&_ZN7S7268C3D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C3D0Ev,
};
extern void _ZN7S7268C5D1Ev();
extern void _ZN7S7268C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C57S7268C3__8S7268C14[] = {
  ABISELECT(4912,3772),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C5[0]),
  (VTBL_ENTRY)&_ZN7S7268C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C5D0Ev,
};
extern void _ZN7S7268C62v2Ev();
extern void _ZN7S7268C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C6__7S7268C3__A__8S7268C14[] = {
  0,
  0,
  ABISELECT(-4944,-3800),
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&_ZN7S7268C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7268C62v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S7268C3D1Ev,_ZTv0_n20_N7S7268C3D1Ev)();
extern void ABISELECT(_ZThn5816_N7S7268C3D1Ev,_ZThn4464_N7S7268C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S7268C3D0Ev,_ZTv0_n20_N7S7268C3D0Ev)();
extern void ABISELECT(_ZThn5816_N7S7268C3D0Ev,_ZThn4464_N7S7268C3D0Ev)() __attribute__((weak));
extern void _ZN8S7268C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C10__7S7268C3__A__8S7268C14[] = {
  0,
  ABISELECT(-5816,-4464),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-5816,-4464),
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7268C3D1Ev,_ZTv0_n20_N7S7268C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7268C3D0Ev,_ZTv0_n20_N7S7268C3D0Ev),
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C11__7S7268C3__A__8S7268C14[] = {
  0,
  0,
  ABISELECT(-6576,-5072),
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
extern void _ZN7S7268C62v2Ev();
extern void _ZN7S7268C62v3Ev();
extern void _ZN8S7268C15D1Ev();
extern void _ZN8S7268C15D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C15__8S7268C14[] = {
  ABISELECT(5904,4532),
  ABISELECT(4240,3232),
  ABISELECT(6072,4628),
  0,
  (VTBL_ENTRY)&(_ZTI8S7268C15[0]),
  (VTBL_ENTRY)&_ZN7S7268C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7268C62v3Ev,
  (VTBL_ENTRY)&_ZN8S7268C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7268C15D0Ev,
};
extern void _ZN8S7268C10D1Ev();
extern void _ZN8S7268C10D0Ev();
extern void _ZN8S7268C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C108S7268C15__A1__8S7268C14[] = {
  ABISELECT(5032,3868),
  ABISELECT(3368,2568),
  0,
  (VTBL_ENTRY)&(_ZTI8S7268C10[0]),
  (VTBL_ENTRY)&_ZN8S7268C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7268C10D0Ev,
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
};
extern void _ZN7S7268C5D1Ev();
extern void _ZN7S7268C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C58S7268C108S7268C15__A2__8S7268C14[] = {
  ABISELECT(3368,2568),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C5[0]),
  (VTBL_ENTRY)&_ZN7S7268C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C5D0Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C11__8S7268C108S7268C15__A1__8S7268C14[] = {
  0,
  0,
  ABISELECT(-5032,-3868),
  (VTBL_ENTRY)&(_ZTI8S7268C10[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
extern void _ZN7S7268C82v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C8__8S7268C15__8S7268C14[] = {
  0,
  ABISELECT(-6072,-4628),
  (VTBL_ENTRY)&(_ZTI8S7268C15[0]),
  (VTBL_ENTRY)&_ZN7S7268C82v7Ev,
};
extern void ABISELECT(_ZThn872_N8S7268C15D1Ev,_ZThn664_N8S7268C15D1Ev)();
extern void ABISELECT(_ZThn872_N8S7268C15D0Ev,_ZThn664_N8S7268C15D0Ev)();
extern void _ZN8S7268C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C10__8S7268C15__8S7268C14[] = {
  ABISELECT(5032,3868),
  ABISELECT(3368,2568),
  ABISELECT(-872,-664),
  (VTBL_ENTRY)&(_ZTI8S7268C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn872_N8S7268C15D1Ev,_ZThn664_N8S7268C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn872_N8S7268C15D0Ev,_ZThn664_N8S7268C15D0Ev),
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C11__8S7268C15__8S7268C14[] = {
  0,
  0,
  ABISELECT(-5904,-4532),
  (VTBL_ENTRY)&(_ZTI8S7268C15[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
extern void _ZN8S7268C10D1Ev();
extern void _ZN8S7268C10D0Ev();
extern void _ZN8S7268C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C10__8S7268C14[] = {
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  0,
  (VTBL_ENTRY)&(_ZTI8S7268C10[0]),
  (VTBL_ENTRY)&_ZN8S7268C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7268C10D0Ev,
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
};
extern void _ZN7S7268C5D1Ev();
extern void _ZN7S7268C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C58S7268C10__A1__8S7268C14[] = {
  ABISELECT(-904,-692),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C5[0]),
  (VTBL_ENTRY)&_ZN7S7268C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C5D0Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C11__8S7268C10__8S7268C14[] = {
  0,
  0,
  ABISELECT(-760,-608),
  (VTBL_ENTRY)&(_ZTI8S7268C10[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
extern void _ZN7S7268C22v8Ev();
extern void _ZN7S7268C2D1Ev();
extern void _ZN7S7268C2D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C2__8S7268C14[] = {
  ABISELECT(-480,-348),
  ABISELECT(-1240,-956),
  ABISELECT(-2112,-1620),
  ABISELECT(-2144,-1648),
  ABISELECT(34832,26960),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C2[0]),
  (VTBL_ENTRY)&_ZN7S7268C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7268C2D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C2D0Ev,
};
extern void ABISELECT(_ZTv0_n56_N7S7268C2D1Ev,_ZTv0_n28_N7S7268C2D1Ev)();
extern void ABISELECT(_ZThn34832_N7S7268C2D1Ev,_ZThn26960_N7S7268C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N7S7268C2D0Ev,_ZTv0_n28_N7S7268C2D0Ev)();
extern void ABISELECT(_ZThn34832_N7S7268C2D0Ev,_ZThn26960_N7S7268C2D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7268C3__7S7268C2__8S7268C14[] = {
  ABISELECT(152,124),
  ABISELECT(-34832,-26960),
  ABISELECT(-35312,-27308),
  ABISELECT(-36072,-27916),
  ABISELECT(-36944,-28580),
  ABISELECT(-36976,-28608),
  ABISELECT(-34832,-26960),
  (VTBL_ENTRY)&(_ZTI7S7268C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7268C2D1Ev,_ZTv0_n28_N7S7268C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7268C2D0Ev,_ZTv0_n28_N7S7268C2D0Ev),
};
extern void _ZN7S7268C62v2Ev();
extern void _ZN7S7268C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C6__7S7268C2__8S7268C14[] = {
  0,
  0,
  ABISELECT(2112,1620),
  (VTBL_ENTRY)&(_ZTI7S7268C2[0]),
  (VTBL_ENTRY)&_ZN7S7268C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7268C62v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S7268C2D1Ev,_ZTv0_n20_N7S7268C2D1Ev)();
extern void ABISELECT(_ZTv0_n40_N7S7268C2D0Ev,_ZTv0_n20_N7S7268C2D0Ev)();
extern void _ZN8S7268C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C10__7S7268C2__8S7268C14[] = {
  0,
  ABISELECT(1240,956),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(1240,956),
  (VTBL_ENTRY)&(_ZTI7S7268C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7268C2D1Ev,_ZTv0_n20_N7S7268C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7268C2D0Ev,_ZTv0_n20_N7S7268C2D0Ev),
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C11__7S7268C2__8S7268C14[] = {
  0,
  0,
  ABISELECT(480,348),
  (VTBL_ENTRY)&(_ZTI7S7268C2[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
extern void _ZN7S7268C82v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C87S7268C3__7S7268C2__8S7268C14[] = {
  ABISELECT(-34984,-27084),
  (VTBL_ENTRY)&(_ZTI7S7268C2[0]),
  (VTBL_ENTRY)&_ZN7S7268C82v7Ev,
};
extern void _ZN7S7268C3D1Ev();
extern void _ZN7S7268C3D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C3__A1__8S7268C14[] = {
  ABISELECT(-35312,-27308),
  ABISELECT(-36072,-27916),
  ABISELECT(-36944,-28580),
  ABISELECT(-36976,-28608),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&_ZN7S7268C3D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C3D0Ev,
};
extern void _ZN7S7268C5D1Ev();
extern void _ZN7S7268C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C57S7268C3__A3__8S7268C14[] = {
  ABISELECT(-36976,-28608),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C5[0]),
  (VTBL_ENTRY)&_ZN7S7268C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C5D0Ev,
};
extern void _ZN7S7268C62v2Ev();
extern void _ZN7S7268C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C6__7S7268C3__A1__8S7268C14[] = {
  0,
  0,
  ABISELECT(36944,28580),
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&_ZN7S7268C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7268C62v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S7268C3D1Ev,_ZTv0_n20_N7S7268C3D1Ev)();
extern void ABISELECT(_ZTv0_n40_N7S7268C3D0Ev,_ZTv0_n20_N7S7268C3D0Ev)();
extern void _ZN8S7268C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C10__7S7268C3__A1__8S7268C14[] = {
  0,
  ABISELECT(36072,27916),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(36072,27916),
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7268C3D1Ev,_ZTv0_n20_N7S7268C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7268C3D0Ev,_ZTv0_n20_N7S7268C3D0Ev),
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C11__7S7268C3__A1__8S7268C14[] = {
  0,
  0,
  ABISELECT(35312,27308),
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
extern void _ZN8S7268C132v9Ev();
extern void _ZN8S7268C13D1Ev();
extern void _ZN8S7268C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C13__8S7268C14[] = {
  ABISELECT(-37640,-29148),
  ABISELECT(176,104),
  0,
  (VTBL_ENTRY)&(_ZTI8S7268C13[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
  (VTBL_ENTRY)&_ZN8S7268C132v9Ev,
  (VTBL_ENTRY)&_ZN8S7268C13D1Ev,
  (VTBL_ENTRY)&_ZN8S7268C13D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S7268C13D1Ev,_ZTv0_n16_N8S7268C13D1Ev)();
extern void ABISELECT(_ZThn176_N8S7268C13D1Ev,_ZThn104_N8S7268C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7268C13D0Ev,_ZTv0_n16_N8S7268C13D0Ev)();
extern void ABISELECT(_ZThn176_N8S7268C13D0Ev,_ZThn104_N8S7268C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7268C5__8S7268C13__8S7268C14[] = {
  ABISELECT(-176,-104),
  ABISELECT(-37816,-29252),
  ABISELECT(-176,-104),
  (VTBL_ENTRY)&(_ZTI8S7268C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7268C13D1Ev,_ZTv0_n16_N8S7268C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7268C13D0Ev,_ZTv0_n16_N8S7268C13D0Ev),
};
extern void _ZN7S7268C5D1Ev();
extern void _ZN7S7268C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C5__A4__8S7268C14[] = {
  ABISELECT(-37816,-29252),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C5[0]),
  (VTBL_ENTRY)&_ZN7S7268C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C5D0Ev,
};
static  VTT_ENTRY vtt_S7268C14[] = {
  {&(_ZTV8S7268C14[11]),  11,102},
  {&(_tg__ZTV7S7268C3__A__8S7268C14[6]),  6,8},
  {&(_tg__ZTV7S7268C57S7268C3__8S7268C14[3]),  3,5},
  {&(_tg__ZTV7S7268C6__7S7268C3__A__8S7268C14[4]),  4,6},
  {&(_tg__ZTV8S7268C10__7S7268C3__A__8S7268C14[6]),  6,9},
  {&(_tg__ZTV8S7268C11__7S7268C3__A__8S7268C14[4]),  4,6},
  {&(_tg__ZTV8S7268C15__8S7268C14[5]),  5,9},
  {&(_tg__ZTV8S7268C108S7268C15__A1__8S7268C14[4]),  4,7},
  {&(_tg__ZTV7S7268C58S7268C108S7268C15__A2__8S7268C14[3]),  3,5},
  {&(_tg__ZTV8S7268C11__8S7268C108S7268C15__A1__8S7268C14[4]),  4,6},
  {&(_tg__ZTV7S7268C8__8S7268C15__8S7268C14[3]),  3,4},
  {&(_tg__ZTV8S7268C10__8S7268C15__8S7268C14[4]),  4,7},
  {&(_tg__ZTV8S7268C11__8S7268C15__8S7268C14[4]),  4,6},
  {&(_ZTV8S7268C14[37]),  37,102},
  {&(_ZTV8S7268C14[45]),  45,102},
  {&(_ZTV8S7268C14[52]),  52,102},
  {&(_ZTV8S7268C14[22]),  22,102},
  {&(_ZTV8S7268C14[57]),  57,102},
  {&(_ZTV8S7268C14[30]),  30,102},
  {&(_ZTV8S7268C14[67]),  67,102},
  {&(_ZTV8S7268C14[78]),  78,102},
  {&(_ZTV8S7268C14[82]),  82,102},
  {&(_ZTV8S7268C14[91]),  91,102},
  {&(_ZTV8S7268C14[100]),  100,102},
  {&(_tg__ZTV8S7268C10__8S7268C14[4]),  4,7},
  {&(_tg__ZTV7S7268C58S7268C10__A1__8S7268C14[3]),  3,5},
  {&(_tg__ZTV8S7268C11__8S7268C10__8S7268C14[4]),  4,6},
  {&(_tg__ZTV7S7268C2__8S7268C14[7]),  7,10},
  {&(_tg__ZTV7S7268C3__7S7268C2__8S7268C14[8]),  8,10},
  {&(_tg__ZTV7S7268C6__7S7268C2__8S7268C14[4]),  4,6},
  {&(_tg__ZTV8S7268C10__7S7268C2__8S7268C14[6]),  6,9},
  {&(_tg__ZTV8S7268C11__7S7268C2__8S7268C14[4]),  4,6},
  {&(_tg__ZTV7S7268C87S7268C3__7S7268C2__8S7268C14[2]),  2,3},
  {&(_tg__ZTV7S7268C3__A1__8S7268C14[6]),  6,8},
  {&(_tg__ZTV7S7268C57S7268C3__A3__8S7268C14[3]),  3,5},
  {&(_tg__ZTV7S7268C6__7S7268C3__A1__8S7268C14[4]),  4,6},
  {&(_tg__ZTV8S7268C10__7S7268C3__A1__8S7268C14[6]),  6,9},
  {&(_tg__ZTV8S7268C11__7S7268C3__A1__8S7268C14[4]),  4,6},
  {&(_tg__ZTV8S7268C13__8S7268C14[4]),  4,9},
  {&(_tg__ZTV7S7268C5__8S7268C13__8S7268C14[4]),  4,6},
  {&(_tg__ZTV7S7268C5__A4__8S7268C14[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S7268C14[];
extern  VTBL_ENTRY _ZTV8S7268C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7268C14[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7268C13D0Ev,_ZTv0_n16_N8S7268C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7268C13D0Ev,_ZThn104_N8S7268C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7268C13D1Ev,_ZTv0_n16_N8S7268C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7268C13D1Ev,_ZThn104_N8S7268C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7268C2D0Ev,_ZTv0_n28_N7S7268C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn34832_N7S7268C2D0Ev,_ZThn26960_N7S7268C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7268C2D1Ev,_ZTv0_n28_N7S7268C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn34832_N7S7268C2D1Ev,_ZThn26960_N7S7268C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7268C3D0Ev,_ZTv0_n20_N7S7268C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5816_N7S7268C3D0Ev,_ZThn4464_N7S7268C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7268C3D1Ev,_ZTv0_n20_N7S7268C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5816_N7S7268C3D1Ev,_ZThn4464_N7S7268C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7268C14D0Ev,_ZTv0_n16_N8S7268C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn42728_N8S7268C14D0Ev,_ZThn33024_N8S7268C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7268C14D1Ev,_ZTv0_n16_N8S7268C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn42728_N8S7268C14D1Ev,_ZThn33024_N8S7268C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S7268C14D0Ev,_ZTv0_n32_N8S7268C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn42552_N8S7268C14D0Ev,_ZThn32920_N8S7268C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S7268C14D1Ev,_ZTv0_n32_N8S7268C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn42552_N8S7268C14D1Ev,_ZThn32920_N8S7268C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7268C14D0Ev,_ZTv0_n28_N8S7268C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn41888_N8S7268C14D0Ev,_ZThn32380_N8S7268C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7268C14D1Ev,_ZTv0_n28_N8S7268C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn41888_N8S7268C14D1Ev,_ZThn32380_N8S7268C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S7268C14D0Ev,_ZTv0_n36_N8S7268C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7056_N8S7268C14D0Ev,_ZThn5420_N8S7268C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S7268C14D1Ev,_ZTv0_n36_N8S7268C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7056_N8S7268C14D1Ev,_ZThn5420_N8S7268C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7268C14D0Ev,_ZTv0_n20_N8S7268C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5816_N8S7268C14D0Ev,_ZThn4464_N8S7268C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7268C14D1Ev,_ZTv0_n20_N8S7268C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5816_N8S7268C14D1Ev,_ZThn4464_N8S7268C14D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7268C14 = {  "S7268C14", // class name
  bases_S7268C14, 23,
  &(vtc_S7268C14[0]), // expected_vtbl_contents
  &(vtt_S7268C14[0]), // expected_vtt_contents
  ABISELECT(42848,33120), // object size
  NSPAIRA(_ZTI8S7268C14),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S7268C14),102, //virtual function table var
  11, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7268C14),41, //virtual table table var
  19, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7268C17_nt  {
};
//SIG(-1 S7268C17_nt) C1{}



//skip512 S7268C17_nt

#else // __cplusplus

Class_Descriptor cd_S7268C17_nt = {  "S7268C17_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7268C12  : virtual S7268C13 , S7268C14 , S7268C11 {
  ::S7268C17_nt s7268c12f0;
  ~S7268C12(); // tgen
  S7268C12(); // tgen
};
//SIG(-1 S7268C12) C1{ VBC2{ VBC3{ VBC4{ m Fs[6] FL Fc[5]} vd FC4 Fi Fp FC4[2]} BC5{ v1 v2 Fi Fp[2] Fl Fp[3] Fl[6] FC4 Fi Fp Fc[2]} v3 Fi Fp} BC6{ BC7{ BC4 BC3 VBC8{ v4 v5 FC4 Fc FC9{ BC10{ v7 FU11{ m Fl Fp[4] Fi} Fp FC4[8] Fp} VBC4 BC3 Fp[5] Fc:0 Fi Fi Fi:10 Fc[8] Fs Fi Fp[10] FC3 FL Fi Fp} Fp Fi Fi Fp Fi Fi:11 Fi} VBC12{ BC3 VBC5 vd v6 Fl[4] FC3[4]} BC10 Fp Fi[6] FL FC3 Fc} BC13{ BC8 VBC10 VBC4 BC12 vd Fi Fi Fc[4] Fp[3] Fs Fi Fi FD Fp Fp Fi} VBC14{ VBC7 v8 FC4 FC12[5] FC7[10] FL[4] Fc FC7 FC7} BC4 VBC2 vd v9 FU15{ m Fi Fc[7] Fi[10] Fi FD[8] Fi Fp Fi} Fp Fi FL FL FC13 FL Fi[8] Fi} BC5 FC16{}}


S7268C12 ::~S7268C12(){ note_dtor("S7268C12", this);} // tgen
S7268C12 ::S7268C12(){ note_ctor("S7268C12", this);} // tgen

static void Test_S7268C12()
{
  extern Class_Descriptor cd_S7268C12;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(2690,8305)];
    init_test(&cd_S7268C12, buf);
    S7268C12 *dp, &lv = *(dp=new (buf) S7268C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(43024,33216), "sizeof(S7268C12)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7268C12)");
    /*is_ambiguous_... S7268C12::S7268C5 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7268C5*), ABISELECT(5376,4068), "S7268C12");
    /*is_ambiguous_... S7268C14::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7268C5*)(S7268C3*)(S7268C14*), ABISELECT(5376,4068), "S7268C12");
    /*is_ambiguous_... S7268C12::S7268C10 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7268C5*)(S7268C10*), ABISELECT(5376,4068), "S7268C12");
    check_base_class_offset(lv, (S7268C4*)(S7268C15*)(S7268C14*), ABISELECT(5376,4068), "S7268C12");
    check_base_class_offset(lv, (S7268C4*)(S7268C5*)(S7268C10*)(S7268C15*)(S7268C14*), ABISELECT(5376,4068), "S7268C12");
    /*is_ambiguous_... S7268C12::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7268C5*)(S7268C3*), ABISELECT(5376,4068), "S7268C12");
    check_base_class_offset(lv, (S7268C5*)(S7268C13*), ABISELECT(5256,3972), "S7268C12");
    check_base_class_offset(lv, (S7268C11*)(S7268C13*), ABISELECT(5080,3868), "S7268C12");
    check_base_class_offset(lv, (S7268C13*), ABISELECT(5080,3868), "S7268C12");
    check_base_class_offset(lv, (S7268C13*)(S7268C14*), ABISELECT(5080,3868), "S7268C12");
    /*is_ambiguous_... S7268C14::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7268C3*)(S7268C14*), ABISELECT(120,96), "S7268C12");
    /*is_ambiguous_... S7268C14::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C5*)(S7268C3*)(S7268C14*), 0, "S7268C12");
    /*is_ambiguous_... S7268C14::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C6*)(S7268C3*)(S7268C14*), ABISELECT(5408,4096), "S7268C12");
    /*is_ambiguous_... S7268C12::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C6*)(S7268C3*), ABISELECT(5408,4096), "S7268C12");
    /*is_ambiguous_... S7268C12::S7268C10 */ AMB_check_base_class_offset(lv, (S7268C5*)(S7268C10*), ABISELECT(6280,4760), "S7268C12");
    /*is_ambiguous_... S7268C12::S7268C10 */ AMB_check_base_class_offset(lv, (S7268C11*)(S7268C10*), ABISELECT(7040,5368), "S7268C12");
    check_base_class_offset(lv, (S7268C11*)(S7268C10*)(S7268C15*)(S7268C14*), ABISELECT(7040,5368), "S7268C12");
    /*is_ambiguous_... S7268C14::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C10*)(S7268C3*)(S7268C14*), ABISELECT(6280,4760), "S7268C12");
    /*is_ambiguous_... S7268C12::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C10*)(S7268C3*), ABISELECT(6280,4760), "S7268C12");
    /*is_ambiguous_... S7268C14::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C8*)(S7268C3*)(S7268C14*), ABISELECT(152,124), "S7268C12");
    /*is_ambiguous_... S7268C14::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C3*)(S7268C14*), 0, "S7268C12");
    check_base_class_offset(lv, (S7268C6*)(S7268C15*)(S7268C14*), ABISELECT(672,540), "S7268C12");
    check_base_class_offset(lv, (S7268C8*)(S7268C15*)(S7268C14*), ABISELECT(7208,5464), "S7268C12");
    check_base_class_offset(lv, (S7268C5*)(S7268C10*)(S7268C15*)(S7268C14*), ABISELECT(1544,1204), "S7268C12");
    check_base_class_offset(lv, (S7268C10*)(S7268C15*)(S7268C14*), ABISELECT(1544,1204), "S7268C12");
    check_base_class_offset(lv, (S7268C15*)(S7268C14*), ABISELECT(672,540), "S7268C12");
    /*is_ambiguous_... S7268C12::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7268C3*), ABISELECT(42472,32772), "S7268C12");
    /*is_ambiguous_... S7268C12::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C5*)(S7268C3*), ABISELECT(42352,32676), "S7268C12");
    /*is_ambiguous_... S7268C12::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C8*)(S7268C3*), ABISELECT(42504,32800), "S7268C12");
    check_base_class_offset(lv, (S7268C3*)(S7268C2*), ABISELECT(42352,32676), "S7268C12");
    check_base_class_offset(lv, (S7268C2*)(S7268C14*), ABISELECT(7520,5716), "S7268C12");
    /*is_ambiguous_... S7268C14::S7268C4 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7268C14*), ABISELECT(2408,1872), "S7268C12");
    check_base_class_offset(lv, (S7268C14*), 0, "S7268C12");
    /*is_ambiguous_... S7268C12::S7268C11 */ AMB_check_base_class_offset(lv, (S7268C11*), ABISELECT(4912,3772), "S7268C12");
    check_field_offset(lv, s7268c12f0, ABISELECT(5074,3866), "S7268C12.s7268c12f0");
    test_class_info(&lv, &cd_S7268C12);
    dp->~S7268C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7268C12(Test_S7268C12, "S7268C12", ABISELECT(43024,33216));

#else // __cplusplus

extern void _ZN8S7268C12C1Ev();
extern void _ZN8S7268C12D1Ev();
Name_Map name_map_S7268C12[] = {
  NSPAIR(_ZN8S7268C12C1Ev),
  NSPAIR(_ZN8S7268C12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7268C5;
extern VTBL_ENTRY _ZTI7S7268C5[];
extern  VTBL_ENTRY _ZTV7S7268C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C5[];
extern Class_Descriptor cd_S7268C11;
extern VTBL_ENTRY _ZTI8S7268C11[];
extern  VTBL_ENTRY _ZTV8S7268C11[];
extern Class_Descriptor cd_S7268C13;
extern VTBL_ENTRY _ZTI8S7268C13[];
extern  VTBL_ENTRY _ZTV8S7268C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7268C13[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7268C5;
extern VTBL_ENTRY _ZTI7S7268C5[];
extern  VTBL_ENTRY _ZTV7S7268C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C5[];
extern Class_Descriptor cd_S7268C6;
extern VTBL_ENTRY _ZTI7S7268C6[];
extern  VTBL_ENTRY _ZTV7S7268C6[];
extern Class_Descriptor cd_S7268C5;
extern VTBL_ENTRY _ZTI7S7268C5[];
extern  VTBL_ENTRY _ZTV7S7268C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C5[];
extern Class_Descriptor cd_S7268C11;
extern VTBL_ENTRY _ZTI8S7268C11[];
extern  VTBL_ENTRY _ZTV8S7268C11[];
extern Class_Descriptor cd_S7268C10;
extern VTBL_ENTRY _ZTI8S7268C10[];
extern  VTBL_ENTRY _ZTV8S7268C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7268C10[];
extern Class_Descriptor cd_S7268C8;
extern VTBL_ENTRY _ZTI7S7268C8[];
extern  VTBL_ENTRY _ZTV7S7268C8[];
extern Class_Descriptor cd_S7268C3;
extern VTBL_ENTRY _ZTI7S7268C3[];
extern  VTBL_ENTRY _ZTV7S7268C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C3[];
extern Class_Descriptor cd_S7268C6;
extern VTBL_ENTRY _ZTI7S7268C6[];
extern  VTBL_ENTRY _ZTV7S7268C6[];
extern Class_Descriptor cd_S7268C8;
extern VTBL_ENTRY _ZTI7S7268C8[];
extern  VTBL_ENTRY _ZTV7S7268C8[];
extern Class_Descriptor cd_S7268C5;
extern VTBL_ENTRY _ZTI7S7268C5[];
extern  VTBL_ENTRY _ZTV7S7268C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C5[];
extern Class_Descriptor cd_S7268C10;
extern VTBL_ENTRY _ZTI8S7268C10[];
extern  VTBL_ENTRY _ZTV8S7268C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7268C10[];
extern Class_Descriptor cd_S7268C15;
extern VTBL_ENTRY _ZTI8S7268C15[];
extern  VTBL_ENTRY _ZTV8S7268C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7268C15[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7268C5;
extern VTBL_ENTRY _ZTI7S7268C5[];
extern  VTBL_ENTRY _ZTV7S7268C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C5[];
extern Class_Descriptor cd_S7268C8;
extern VTBL_ENTRY _ZTI7S7268C8[];
extern  VTBL_ENTRY _ZTV7S7268C8[];
extern Class_Descriptor cd_S7268C3;
extern VTBL_ENTRY _ZTI7S7268C3[];
extern  VTBL_ENTRY _ZTV7S7268C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C3[];
extern Class_Descriptor cd_S7268C2;
extern VTBL_ENTRY _ZTI7S7268C2[];
extern  VTBL_ENTRY _ZTV7S7268C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C2[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7268C14;
extern VTBL_ENTRY _ZTI8S7268C14[];
extern  VTBL_ENTRY _ZTV8S7268C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7268C14[];
extern Class_Descriptor cd_S7268C11;
extern VTBL_ENTRY _ZTI8S7268C11[];
extern  VTBL_ENTRY _ZTV8S7268C11[];
static Base_Class bases_S7268C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7268C4,    ABISELECT(5376,4068), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S7268C5,    ABISELECT(5256,3972), //bcp->offset
    50, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    39, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S7268C11,    ABISELECT(5080,3868), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S7268C13,    ABISELECT(5080,3868), //bcp->offset
    37, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    37, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7268C4,    ABISELECT(120,96), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S7268C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S7268C6,    ABISELECT(5408,4096), //bcp->offset
    56, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S7268C5,    ABISELECT(6280,4760), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    41, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S7268C11,    ABISELECT(7040,5368), //bcp->offset
    71, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S7268C10,    ABISELECT(6280,4760), //bcp->offset
    62, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    40, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S7268C8,    ABISELECT(152,124), //bcp->offset
    14, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S7268C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S7268C6,    ABISELECT(672,540), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S7268C8,    ABISELECT(7208,5464), //bcp->offset
    77, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    32, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S7268C5,    ABISELECT(1544,1204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S7268C10,    ABISELECT(1544,1204), //bcp->offset
    26, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    33, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S7268C15,    ABISELECT(672,540), //bcp->offset
    17, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S7268C4,    ABISELECT(42472,32772), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S7268C5,    ABISELECT(42352,32676), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    50, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S7268C8,    ABISELECT(42504,32800), //bcp->offset
    103, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    36, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S7268C3,    ABISELECT(42352,32676), //bcp->offset
    93, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    35, //bcp->index_in_construction_vtbl_array
    49, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    21, //immediately_derived
  0, 1},
  {&cd_S7268C2,    ABISELECT(7520,5716), //bcp->offset
    81, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    34, //bcp->index_in_construction_vtbl_array
    43, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    23, //immediately_derived
  0, 1},
  {&cd_S7268C4,    ABISELECT(2408,1872), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S7268C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7268C11,    ABISELECT(4912,3772), //bcp->offset
    33, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7268C12[];
extern void _ZN8S7268C12D1Ev();
extern void _ZN8S7268C12D0Ev();
extern void _ZN8S7268C143v10Ev();
extern void _ZN7S7268C82v7Ev();
extern void _ZN7S7268C62v2Ev();
extern void _ZN7S7268C62v3Ev();
extern void ABISELECT(_ZThn672_N8S7268C12D1Ev,_ZThn540_N8S7268C12D1Ev)();
extern void ABISELECT(_ZThn672_N8S7268C12D0Ev,_ZThn540_N8S7268C12D0Ev)();
extern void ABISELECT(_ZThn1544_N8S7268C12D1Ev,_ZThn1204_N8S7268C12D1Ev)();
extern void ABISELECT(_ZThn1544_N8S7268C12D0Ev,_ZThn1204_N8S7268C12D0Ev)();
extern void _ZN8S7268C102v6Ev();
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
extern void _ZN8S7268C132v9Ev();
extern void ABISELECT(_ZTv0_n64_N8S7268C12D1Ev,_ZTv0_n32_N8S7268C12D1Ev)();
extern void ABISELECT(_ZThn5080_N8S7268C12D1Ev,_ZThn3868_N8S7268C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S7268C12D0Ev,_ZTv0_n32_N8S7268C12D0Ev)();
extern void ABISELECT(_ZThn5080_N8S7268C12D0Ev,_ZThn3868_N8S7268C12D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7268C12D1Ev,_ZTv0_n16_N8S7268C12D1Ev)();
extern void ABISELECT(_ZThn5256_N8S7268C12D1Ev,_ZThn3972_N8S7268C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7268C12D0Ev,_ZTv0_n16_N8S7268C12D0Ev)();
extern void ABISELECT(_ZThn5256_N8S7268C12D0Ev,_ZThn3972_N8S7268C12D0Ev)() __attribute__((weak));
extern void _ZN7S7268C62v2Ev();
extern void _ZN7S7268C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S7268C12D1Ev,_ZTv0_n20_N8S7268C12D1Ev)();
extern void ABISELECT(_ZThn6280_N8S7268C12D1Ev,_ZThn4760_N8S7268C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7268C12D0Ev,_ZTv0_n20_N8S7268C12D0Ev)();
extern void ABISELECT(_ZThn6280_N8S7268C12D0Ev,_ZThn4760_N8S7268C12D0Ev)() __attribute__((weak));
extern void _ZN8S7268C102v6Ev();
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
extern void _ZN7S7268C82v7Ev();
extern void _ZN7S7268C22v8Ev();
extern void ABISELECT(_ZTv0_n72_N8S7268C12D1Ev,_ZTv0_n36_N8S7268C12D1Ev)();
extern void ABISELECT(_ZThn7520_N8S7268C12D1Ev,_ZThn5716_N8S7268C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S7268C12D0Ev,_ZTv0_n36_N8S7268C12D0Ev)();
extern void ABISELECT(_ZThn7520_N8S7268C12D0Ev,_ZThn5716_N8S7268C12D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7268C12D1Ev,_ZTv0_n28_N8S7268C12D1Ev)();
extern void ABISELECT(_ZThn42352_N8S7268C12D1Ev,_ZThn32676_N8S7268C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7268C12D0Ev,_ZTv0_n28_N8S7268C12D0Ev)();
extern void ABISELECT(_ZThn42352_N8S7268C12D0Ev,_ZThn32676_N8S7268C12D0Ev)() __attribute__((weak));
extern void _ZN7S7268C82v7Ev();
static  VTBL_ENTRY vtc_S7268C12[] = {
  ABISELECT(5256,3972),
  ABISELECT(5080,3868),
  ABISELECT(42352,32676),
  ABISELECT(7520,5716),
  ABISELECT(7208,5464),
  ABISELECT(7040,5368),
  ABISELECT(6280,4760),
  ABISELECT(5408,4096),
  ABISELECT(5376,4068),
  0,
  (VTBL_ENTRY)&(_ZTI8S7268C12[0]),
  (VTBL_ENTRY)&_ZN8S7268C12D1Ev,
  (VTBL_ENTRY)&_ZN8S7268C12D0Ev,
  (VTBL_ENTRY)&_ZN8S7268C143v10Ev,
  ABISELECT(-152,-124),
  (VTBL_ENTRY)&(_ZTI8S7268C12[0]),
  (VTBL_ENTRY)&_ZN7S7268C82v7Ev,
  ABISELECT(6368,4828),
  ABISELECT(4704,3528),
  ABISELECT(6536,4924),
  ABISELECT(-672,-540),
  (VTBL_ENTRY)&(_ZTI8S7268C12[0]),
  (VTBL_ENTRY)&_ZN7S7268C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7268C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S7268C12D1Ev,_ZThn540_N8S7268C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S7268C12D0Ev,_ZThn540_N8S7268C12D0Ev),
  ABISELECT(5496,4164),
  ABISELECT(3832,2864),
  ABISELECT(-1544,-1204),
  (VTBL_ENTRY)&(_ZTI8S7268C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1544_N8S7268C12D1Ev,_ZThn1204_N8S7268C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1544_N8S7268C12D0Ev,_ZThn1204_N8S7268C12D0Ev),
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
  ABISELECT(-4912,-3772),
  (VTBL_ENTRY)&(_ZTI8S7268C12[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
  ABISELECT(-5080,-3868),
  0,
  0,
  0,
  ABISELECT(296,200),
  ABISELECT(176,104),
  ABISELECT(-5080,-3868),
  (VTBL_ENTRY)&(_ZTI8S7268C12[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
  (VTBL_ENTRY)&_ZN8S7268C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7268C12D1Ev,_ZTv0_n32_N8S7268C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7268C12D0Ev,_ZTv0_n32_N8S7268C12D0Ev),
  ABISELECT(-5256,-3972),
  ABISELECT(120,96),
  ABISELECT(-5256,-3972),
  (VTBL_ENTRY)&(_ZTI8S7268C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7268C12D1Ev,_ZTv0_n16_N8S7268C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7268C12D0Ev,_ZTv0_n16_N8S7268C12D0Ev),
  0,
  0,
  ABISELECT(-5408,-4096),
  (VTBL_ENTRY)&(_ZTI8S7268C12[0]),
  (VTBL_ENTRY)&_ZN7S7268C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7268C62v3Ev,
  0,
  ABISELECT(-6280,-4760),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-6280,-4760),
  (VTBL_ENTRY)&(_ZTI8S7268C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7268C12D1Ev,_ZTv0_n20_N8S7268C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7268C12D0Ev,_ZTv0_n20_N8S7268C12D0Ev),
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
  0,
  0,
  ABISELECT(-7040,-5368),
  (VTBL_ENTRY)&(_ZTI8S7268C12[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
  0,
  ABISELECT(-7208,-5464),
  (VTBL_ENTRY)&(_ZTI8S7268C12[0]),
  (VTBL_ENTRY)&_ZN7S7268C82v7Ev,
  ABISELECT(-7520,-5716),
  0,
  ABISELECT(-480,-348),
  ABISELECT(-1240,-956),
  ABISELECT(-2112,-1620),
  ABISELECT(-2144,-1648),
  ABISELECT(34832,26960),
  ABISELECT(-7520,-5716),
  (VTBL_ENTRY)&(_ZTI8S7268C12[0]),
  (VTBL_ENTRY)&_ZN7S7268C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S7268C12D1Ev,_ZTv0_n36_N8S7268C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S7268C12D0Ev,_ZTv0_n36_N8S7268C12D0Ev),
  ABISELECT(152,124),
  ABISELECT(-42352,-32676),
  ABISELECT(-35312,-27308),
  ABISELECT(-36072,-27916),
  ABISELECT(-36944,-28580),
  ABISELECT(-36976,-28608),
  ABISELECT(-42352,-32676),
  (VTBL_ENTRY)&(_ZTI8S7268C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7268C12D1Ev,_ZTv0_n28_N8S7268C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7268C12D0Ev,_ZTv0_n28_N8S7268C12D0Ev),
  ABISELECT(-42504,-32800),
  (VTBL_ENTRY)&(_ZTI8S7268C12[0]),
  (VTBL_ENTRY)&_ZN7S7268C82v7Ev,
};
extern VTBL_ENTRY _ZTV8S7268C12[];
extern void _ZN8S7268C14D1Ev();
extern void _ZN8S7268C14D0Ev();
extern void _ZN8S7268C143v10Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C14__8S7268C12[] = {
  ABISELECT(5256,3972),
  ABISELECT(5080,3868),
  ABISELECT(42352,32676),
  ABISELECT(7520,5716),
  ABISELECT(7208,5464),
  ABISELECT(7040,5368),
  ABISELECT(6280,4760),
  ABISELECT(5408,4096),
  ABISELECT(5376,4068),
  0,
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&_ZN8S7268C14D1Ev,
  (VTBL_ENTRY)&_ZN8S7268C14D0Ev,
  (VTBL_ENTRY)&_ZN8S7268C143v10Ev,
};
extern void _ZN7S7268C3D1Ev();
extern void _ZN7S7268C3D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C38S7268C14__8S7268C12[] = {
  ABISELECT(7040,5368),
  ABISELECT(6280,4760),
  ABISELECT(5408,4096),
  ABISELECT(5376,4068),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&_ZN7S7268C3D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C3D0Ev,
};
extern void _ZN7S7268C5D1Ev();
extern void _ZN7S7268C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C57S7268C38S7268C14__A1__8S7268C12[] = {
  ABISELECT(5376,4068),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C5[0]),
  (VTBL_ENTRY)&_ZN7S7268C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C5D0Ev,
};
extern void _ZN7S7268C62v2Ev();
extern void _ZN7S7268C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C6__7S7268C38S7268C14__8S7268C12[] = {
  0,
  0,
  ABISELECT(-5408,-4096),
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&_ZN7S7268C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7268C62v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S7268C3D1Ev,_ZTv0_n20_N7S7268C3D1Ev)();
extern void ABISELECT(_ZThn6280_N7S7268C3D1Ev,_ZThn4760_N7S7268C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S7268C3D0Ev,_ZTv0_n20_N7S7268C3D0Ev)();
extern void ABISELECT(_ZThn6280_N7S7268C3D0Ev,_ZThn4760_N7S7268C3D0Ev)() __attribute__((weak));
extern void _ZN8S7268C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C10__7S7268C38S7268C14__8S7268C12[] = {
  0,
  ABISELECT(-6280,-4760),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-6280,-4760),
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7268C3D1Ev,_ZTv0_n20_N7S7268C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7268C3D0Ev,_ZTv0_n20_N7S7268C3D0Ev),
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C11__7S7268C38S7268C14__8S7268C12[] = {
  0,
  0,
  ABISELECT(-7040,-5368),
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
extern void _ZN7S7268C62v2Ev();
extern void _ZN7S7268C62v3Ev();
extern void _ZN8S7268C15D1Ev();
extern void _ZN8S7268C15D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C158S7268C14__8S7268C12[] = {
  ABISELECT(6368,4828),
  ABISELECT(4704,3528),
  ABISELECT(6536,4924),
  0,
  (VTBL_ENTRY)&(_ZTI8S7268C15[0]),
  (VTBL_ENTRY)&_ZN7S7268C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7268C62v3Ev,
  (VTBL_ENTRY)&_ZN8S7268C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7268C15D0Ev,
};
extern void _ZN8S7268C10D1Ev();
extern void _ZN8S7268C10D0Ev();
extern void _ZN8S7268C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C108S7268C158S7268C14__A1__8S7268C12[] = {
  ABISELECT(5496,4164),
  ABISELECT(3832,2864),
  0,
  (VTBL_ENTRY)&(_ZTI8S7268C10[0]),
  (VTBL_ENTRY)&_ZN8S7268C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7268C10D0Ev,
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
};
extern void _ZN7S7268C5D1Ev();
extern void _ZN7S7268C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C58S7268C108S7268C158S7268C14__A3__8S7268C12[] = {
  ABISELECT(3832,2864),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C5[0]),
  (VTBL_ENTRY)&_ZN7S7268C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C5D0Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C11__8S7268C108S7268C158S7268C14__A1__8S7268C12[] = {
  0,
  0,
  ABISELECT(-5496,-4164),
  (VTBL_ENTRY)&(_ZTI8S7268C10[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
extern void _ZN7S7268C82v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C8__8S7268C158S7268C14__8S7268C12[] = {
  0,
  ABISELECT(-6536,-4924),
  (VTBL_ENTRY)&(_ZTI8S7268C15[0]),
  (VTBL_ENTRY)&_ZN7S7268C82v7Ev,
};
extern void ABISELECT(_ZThn872_N8S7268C15D1Ev,_ZThn664_N8S7268C15D1Ev)();
extern void ABISELECT(_ZThn872_N8S7268C15D0Ev,_ZThn664_N8S7268C15D0Ev)();
extern void _ZN8S7268C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C10__8S7268C158S7268C14__8S7268C12[] = {
  ABISELECT(5496,4164),
  ABISELECT(3832,2864),
  ABISELECT(-872,-664),
  (VTBL_ENTRY)&(_ZTI8S7268C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn872_N8S7268C15D1Ev,_ZThn664_N8S7268C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn872_N8S7268C15D0Ev,_ZThn664_N8S7268C15D0Ev),
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C11__8S7268C158S7268C14__8S7268C12[] = {
  0,
  0,
  ABISELECT(-6368,-4828),
  (VTBL_ENTRY)&(_ZTI8S7268C15[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
extern void _ZN7S7268C62v2Ev();
extern void _ZN7S7268C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C6__8S7268C14__8S7268C12[] = {
  0,
  0,
  ABISELECT(-5408,-4096),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&_ZN7S7268C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7268C62v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S7268C14D1Ev,_ZTv0_n20_N8S7268C14D1Ev)();
extern void ABISELECT(_ZThn6280_N8S7268C14D1Ev,_ZThn4760_N8S7268C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7268C14D0Ev,_ZTv0_n20_N8S7268C14D0Ev)();
extern void ABISELECT(_ZThn6280_N8S7268C14D0Ev,_ZThn4760_N8S7268C14D0Ev)() __attribute__((weak));
extern void _ZN8S7268C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C10__8S7268C14__8S7268C12[] = {
  0,
  ABISELECT(-6280,-4760),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-6280,-4760),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7268C14D1Ev,_ZTv0_n20_N8S7268C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7268C14D0Ev,_ZTv0_n20_N8S7268C14D0Ev),
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C11__8S7268C14__8S7268C12[] = {
  0,
  0,
  ABISELECT(-7040,-5368),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
extern void _ZN7S7268C62v2Ev();
extern void _ZN7S7268C62v3Ev();
extern void ABISELECT(_ZThn672_N8S7268C14D1Ev,_ZThn540_N8S7268C14D1Ev)();
extern void ABISELECT(_ZThn672_N8S7268C14D0Ev,_ZThn540_N8S7268C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S7268C15__8S7268C14__8S7268C12[] = {
  ABISELECT(6368,4828),
  ABISELECT(4704,3528),
  ABISELECT(6536,4924),
  ABISELECT(-672,-540),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&_ZN7S7268C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7268C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S7268C14D1Ev,_ZThn540_N8S7268C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S7268C14D0Ev,_ZThn540_N8S7268C14D0Ev),
};
extern void _ZN7S7268C82v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C8__A1__8S7268C14__8S7268C12[] = {
  0,
  ABISELECT(-7208,-5464),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&_ZN7S7268C82v7Ev,
};
extern void ABISELECT(_ZThn1544_N8S7268C14D1Ev,_ZThn1204_N8S7268C14D1Ev)();
extern void ABISELECT(_ZThn1544_N8S7268C14D0Ev,_ZThn1204_N8S7268C14D0Ev)();
extern void _ZN8S7268C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C108S7268C15__A1__8S7268C14__8S7268C12[] = {
  ABISELECT(5496,4164),
  ABISELECT(3832,2864),
  ABISELECT(-1544,-1204),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1544_N8S7268C14D1Ev,_ZThn1204_N8S7268C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1544_N8S7268C14D0Ev,_ZThn1204_N8S7268C14D0Ev),
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
};
extern void _ZN7S7268C22v8Ev();
extern void ABISELECT(_ZTv0_n72_N8S7268C14D1Ev,_ZTv0_n36_N8S7268C14D1Ev)();
extern void ABISELECT(_ZThn7520_N8S7268C14D1Ev,_ZThn5716_N8S7268C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S7268C14D0Ev,_ZTv0_n36_N8S7268C14D0Ev)();
extern void ABISELECT(_ZThn7520_N8S7268C14D0Ev,_ZThn5716_N8S7268C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7268C2__8S7268C14__8S7268C12[] = {
  ABISELECT(-7520,-5716),
  0,
  ABISELECT(-480,-348),
  ABISELECT(-1240,-956),
  ABISELECT(-2112,-1620),
  ABISELECT(-2144,-1648),
  ABISELECT(34832,26960),
  ABISELECT(-7520,-5716),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&_ZN7S7268C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S7268C14D1Ev,_ZTv0_n36_N8S7268C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S7268C14D0Ev,_ZTv0_n36_N8S7268C14D0Ev),
};
extern void ABISELECT(_ZTv0_n56_N8S7268C14D1Ev,_ZTv0_n28_N8S7268C14D1Ev)();
extern void ABISELECT(_ZThn42352_N8S7268C14D1Ev,_ZThn32676_N8S7268C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7268C14D0Ev,_ZTv0_n28_N8S7268C14D0Ev)();
extern void ABISELECT(_ZThn42352_N8S7268C14D0Ev,_ZThn32676_N8S7268C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7268C3__A1__8S7268C14__8S7268C12[] = {
  ABISELECT(152,124),
  ABISELECT(-42352,-32676),
  ABISELECT(-35312,-27308),
  ABISELECT(-36072,-27916),
  ABISELECT(-36944,-28580),
  ABISELECT(-36976,-28608),
  ABISELECT(-42352,-32676),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7268C14D1Ev,_ZTv0_n28_N8S7268C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7268C14D0Ev,_ZTv0_n28_N8S7268C14D0Ev),
};
extern void _ZN7S7268C82v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C87S7268C3__A2__8S7268C14__8S7268C12[] = {
  ABISELECT(-42504,-32800),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&_ZN7S7268C82v7Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
extern void _ZN8S7268C132v9Ev();
extern void ABISELECT(_ZTv0_n64_N8S7268C14D1Ev,_ZTv0_n32_N8S7268C14D1Ev)();
extern void ABISELECT(_ZThn5080_N8S7268C14D1Ev,_ZThn3868_N8S7268C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S7268C14D0Ev,_ZTv0_n32_N8S7268C14D0Ev)();
extern void ABISELECT(_ZThn5080_N8S7268C14D0Ev,_ZThn3868_N8S7268C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7268C13__8S7268C14__8S7268C12[] = {
  ABISELECT(-5080,-3868),
  0,
  0,
  0,
  ABISELECT(296,200),
  ABISELECT(176,104),
  ABISELECT(-5080,-3868),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
  (VTBL_ENTRY)&_ZN8S7268C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7268C14D1Ev,_ZTv0_n32_N8S7268C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7268C14D0Ev,_ZTv0_n32_N8S7268C14D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S7268C14D1Ev,_ZTv0_n16_N8S7268C14D1Ev)();
extern void ABISELECT(_ZThn5256_N8S7268C14D1Ev,_ZThn3972_N8S7268C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7268C14D0Ev,_ZTv0_n16_N8S7268C14D0Ev)();
extern void ABISELECT(_ZThn5256_N8S7268C14D0Ev,_ZThn3972_N8S7268C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7268C5__A4__8S7268C14__8S7268C12[] = {
  ABISELECT(-5256,-3972),
  ABISELECT(120,96),
  ABISELECT(-5256,-3972),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7268C14D1Ev,_ZTv0_n16_N8S7268C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7268C14D0Ev,_ZTv0_n16_N8S7268C14D0Ev),
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
extern void _ZN8S7268C132v9Ev();
extern void _ZN8S7268C13D1Ev();
extern void _ZN8S7268C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C13__8S7268C12[] = {
  ABISELECT(296,200),
  ABISELECT(176,104),
  0,
  (VTBL_ENTRY)&(_ZTI8S7268C13[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
  (VTBL_ENTRY)&_ZN8S7268C132v9Ev,
  (VTBL_ENTRY)&_ZN8S7268C13D1Ev,
  (VTBL_ENTRY)&_ZN8S7268C13D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S7268C13D1Ev,_ZTv0_n16_N8S7268C13D1Ev)();
extern void ABISELECT(_ZThn176_N8S7268C13D1Ev,_ZThn104_N8S7268C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7268C13D0Ev,_ZTv0_n16_N8S7268C13D0Ev)();
extern void ABISELECT(_ZThn176_N8S7268C13D0Ev,_ZThn104_N8S7268C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7268C5__8S7268C13__8S7268C12[] = {
  ABISELECT(-176,-104),
  ABISELECT(120,96),
  ABISELECT(-176,-104),
  (VTBL_ENTRY)&(_ZTI8S7268C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7268C13D1Ev,_ZTv0_n16_N8S7268C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7268C13D0Ev,_ZTv0_n16_N8S7268C13D0Ev),
};
extern void _ZN7S7268C5D1Ev();
extern void _ZN7S7268C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C5__8S7268C12[] = {
  ABISELECT(120,96),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C5[0]),
  (VTBL_ENTRY)&_ZN7S7268C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C5D0Ev,
};
extern void _ZN8S7268C10D1Ev();
extern void _ZN8S7268C10D0Ev();
extern void _ZN8S7268C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C10__8S7268C12[] = {
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  0,
  (VTBL_ENTRY)&(_ZTI8S7268C10[0]),
  (VTBL_ENTRY)&_ZN8S7268C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7268C10D0Ev,
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
};
extern void _ZN7S7268C5D1Ev();
extern void _ZN7S7268C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C58S7268C10__A2__8S7268C12[] = {
  ABISELECT(-904,-692),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C5[0]),
  (VTBL_ENTRY)&_ZN7S7268C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C5D0Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C11__8S7268C10__8S7268C12[] = {
  0,
  0,
  ABISELECT(-760,-608),
  (VTBL_ENTRY)&(_ZTI8S7268C10[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
extern void _ZN7S7268C22v8Ev();
extern void _ZN7S7268C2D1Ev();
extern void _ZN7S7268C2D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C2__8S7268C12[] = {
  ABISELECT(-480,-348),
  ABISELECT(-1240,-956),
  ABISELECT(-2112,-1620),
  ABISELECT(-2144,-1648),
  ABISELECT(34832,26960),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C2[0]),
  (VTBL_ENTRY)&_ZN7S7268C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7268C2D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C2D0Ev,
};
extern void ABISELECT(_ZTv0_n56_N7S7268C2D1Ev,_ZTv0_n28_N7S7268C2D1Ev)();
extern void ABISELECT(_ZThn34832_N7S7268C2D1Ev,_ZThn26960_N7S7268C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N7S7268C2D0Ev,_ZTv0_n28_N7S7268C2D0Ev)();
extern void ABISELECT(_ZThn34832_N7S7268C2D0Ev,_ZThn26960_N7S7268C2D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7268C3__7S7268C2__8S7268C12[] = {
  ABISELECT(152,124),
  ABISELECT(-34832,-26960),
  ABISELECT(-35312,-27308),
  ABISELECT(-36072,-27916),
  ABISELECT(-36944,-28580),
  ABISELECT(-36976,-28608),
  ABISELECT(-34832,-26960),
  (VTBL_ENTRY)&(_ZTI7S7268C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7268C2D1Ev,_ZTv0_n28_N7S7268C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7268C2D0Ev,_ZTv0_n28_N7S7268C2D0Ev),
};
extern void _ZN7S7268C62v2Ev();
extern void _ZN7S7268C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C6__7S7268C2__8S7268C12[] = {
  0,
  0,
  ABISELECT(2112,1620),
  (VTBL_ENTRY)&(_ZTI7S7268C2[0]),
  (VTBL_ENTRY)&_ZN7S7268C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7268C62v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S7268C2D1Ev,_ZTv0_n20_N7S7268C2D1Ev)();
extern void ABISELECT(_ZTv0_n40_N7S7268C2D0Ev,_ZTv0_n20_N7S7268C2D0Ev)();
extern void _ZN8S7268C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C10__7S7268C2__8S7268C12[] = {
  0,
  ABISELECT(1240,956),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(1240,956),
  (VTBL_ENTRY)&(_ZTI7S7268C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7268C2D1Ev,_ZTv0_n20_N7S7268C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7268C2D0Ev,_ZTv0_n20_N7S7268C2D0Ev),
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C11__7S7268C2__8S7268C12[] = {
  0,
  0,
  ABISELECT(480,348),
  (VTBL_ENTRY)&(_ZTI7S7268C2[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
extern void _ZN7S7268C82v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C87S7268C3__7S7268C2__8S7268C12[] = {
  ABISELECT(-34984,-27084),
  (VTBL_ENTRY)&(_ZTI7S7268C2[0]),
  (VTBL_ENTRY)&_ZN7S7268C82v7Ev,
};
extern void _ZN7S7268C3D1Ev();
extern void _ZN7S7268C3D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C3__A1__8S7268C12[] = {
  ABISELECT(-35312,-27308),
  ABISELECT(-36072,-27916),
  ABISELECT(-36944,-28580),
  ABISELECT(-36976,-28608),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&_ZN7S7268C3D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C3D0Ev,
};
extern void _ZN7S7268C5D1Ev();
extern void _ZN7S7268C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C57S7268C3__A4__8S7268C12[] = {
  ABISELECT(-36976,-28608),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C5[0]),
  (VTBL_ENTRY)&_ZN7S7268C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C5D0Ev,
};
extern void _ZN7S7268C62v2Ev();
extern void _ZN7S7268C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C6__7S7268C3__A1__8S7268C12[] = {
  0,
  0,
  ABISELECT(36944,28580),
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&_ZN7S7268C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7268C62v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S7268C3D1Ev,_ZTv0_n20_N7S7268C3D1Ev)();
extern void ABISELECT(_ZTv0_n40_N7S7268C3D0Ev,_ZTv0_n20_N7S7268C3D0Ev)();
extern void _ZN8S7268C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C10__7S7268C3__A1__8S7268C12[] = {
  0,
  ABISELECT(36072,27916),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(36072,27916),
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7268C3D1Ev,_ZTv0_n20_N7S7268C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7268C3D0Ev,_ZTv0_n20_N7S7268C3D0Ev),
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C11__7S7268C3__A1__8S7268C12[] = {
  0,
  0,
  ABISELECT(35312,27308),
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
static  VTT_ENTRY vtt_S7268C12[] = {
  {&(_ZTV8S7268C12[11]),  11,106},
  {&(_tg__ZTV8S7268C14__8S7268C12[11]),  11,14},
  {&(_tg__ZTV7S7268C38S7268C14__8S7268C12[6]),  6,8},
  {&(_tg__ZTV7S7268C57S7268C38S7268C14__A1__8S7268C12[3]),  3,5},
  {&(_tg__ZTV7S7268C6__7S7268C38S7268C14__8S7268C12[4]),  4,6},
  {&(_tg__ZTV8S7268C10__7S7268C38S7268C14__8S7268C12[6]),  6,9},
  {&(_tg__ZTV8S7268C11__7S7268C38S7268C14__8S7268C12[4]),  4,6},
  {&(_tg__ZTV8S7268C158S7268C14__8S7268C12[5]),  5,9},
  {&(_tg__ZTV8S7268C108S7268C158S7268C14__A1__8S7268C12[4]),  4,7},
  {&(_tg__ZTV7S7268C58S7268C108S7268C158S7268C14__A3__8S7268C12[3]),  3,5},
  {&(_tg__ZTV8S7268C11__8S7268C108S7268C158S7268C14__A1__8S7268C12[4]),  4,6},
  {&(_tg__ZTV7S7268C8__8S7268C158S7268C14__8S7268C12[3]),  3,4},
  {&(_tg__ZTV8S7268C10__8S7268C158S7268C14__8S7268C12[4]),  4,7},
  {&(_tg__ZTV8S7268C11__8S7268C158S7268C14__8S7268C12[4]),  4,6},
  {&(_tg__ZTV7S7268C6__8S7268C14__8S7268C12[4]),  4,6},
  {&(_tg__ZTV8S7268C10__8S7268C14__8S7268C12[6]),  6,9},
  {&(_tg__ZTV8S7268C11__8S7268C14__8S7268C12[4]),  4,6},
  {&(_tg__ZTV8S7268C15__8S7268C14__8S7268C12[5]),  5,9},
  {&(_tg__ZTV7S7268C8__A1__8S7268C14__8S7268C12[3]),  3,4},
  {&(_tg__ZTV8S7268C108S7268C15__A1__8S7268C14__8S7268C12[4]),  4,7},
  {&(_tg__ZTV7S7268C2__8S7268C14__8S7268C12[9]),  9,12},
  {&(_tg__ZTV7S7268C3__A1__8S7268C14__8S7268C12[8]),  8,10},
  {&(_tg__ZTV7S7268C87S7268C3__A2__8S7268C14__8S7268C12[2]),  2,3},
  {&(_tg__ZTV8S7268C13__8S7268C14__8S7268C12[8]),  8,13},
  {&(_tg__ZTV7S7268C5__A4__8S7268C14__8S7268C12[4]),  4,6},
  {&(_ZTV8S7268C12[45]),  45,106},
  {&(_ZTV8S7268C12[54]),  54,106},
  {&(_ZTV8S7268C12[60]),  60,106},
  {&(_ZTV8S7268C12[68]),  68,106},
  {&(_ZTV8S7268C12[75]),  75,106},
  {&(_ZTV8S7268C12[22]),  22,106},
  {&(_ZTV8S7268C12[80]),  80,106},
  {&(_ZTV8S7268C12[30]),  30,106},
  {&(_ZTV8S7268C12[90]),  90,106},
  {&(_ZTV8S7268C12[101]),  101,106},
  {&(_ZTV8S7268C12[105]),  105,106},
  {&(_tg__ZTV8S7268C13__8S7268C12[4]),  4,9},
  {&(_tg__ZTV7S7268C5__8S7268C13__8S7268C12[4]),  4,6},
  {&(_tg__ZTV7S7268C5__8S7268C12[3]),  3,5},
  {&(_tg__ZTV8S7268C10__8S7268C12[4]),  4,7},
  {&(_tg__ZTV7S7268C58S7268C10__A2__8S7268C12[3]),  3,5},
  {&(_tg__ZTV8S7268C11__8S7268C10__8S7268C12[4]),  4,6},
  {&(_tg__ZTV7S7268C2__8S7268C12[7]),  7,10},
  {&(_tg__ZTV7S7268C3__7S7268C2__8S7268C12[8]),  8,10},
  {&(_tg__ZTV7S7268C6__7S7268C2__8S7268C12[4]),  4,6},
  {&(_tg__ZTV8S7268C10__7S7268C2__8S7268C12[6]),  6,9},
  {&(_tg__ZTV8S7268C11__7S7268C2__8S7268C12[4]),  4,6},
  {&(_tg__ZTV7S7268C87S7268C3__7S7268C2__8S7268C12[2]),  2,3},
  {&(_tg__ZTV7S7268C3__A1__8S7268C12[6]),  6,8},
  {&(_tg__ZTV7S7268C57S7268C3__A4__8S7268C12[3]),  3,5},
  {&(_tg__ZTV7S7268C6__7S7268C3__A1__8S7268C12[4]),  4,6},
  {&(_tg__ZTV8S7268C10__7S7268C3__A1__8S7268C12[6]),  6,9},
  {&(_tg__ZTV8S7268C11__7S7268C3__A1__8S7268C12[4]),  4,6},
};
extern VTBL_ENTRY _ZTI8S7268C12[];
extern  VTBL_ENTRY _ZTV8S7268C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7268C12[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7268C2D0Ev,_ZTv0_n28_N7S7268C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn34832_N7S7268C2D0Ev,_ZThn26960_N7S7268C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7268C2D1Ev,_ZTv0_n28_N7S7268C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn34832_N7S7268C2D1Ev,_ZThn26960_N7S7268C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7268C13D0Ev,_ZTv0_n16_N8S7268C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7268C13D0Ev,_ZThn104_N8S7268C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7268C13D1Ev,_ZTv0_n16_N8S7268C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7268C13D1Ev,_ZThn104_N8S7268C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7268C14D0Ev,_ZTv0_n16_N8S7268C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5256_N8S7268C14D0Ev,_ZThn3972_N8S7268C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7268C14D1Ev,_ZTv0_n16_N8S7268C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5256_N8S7268C14D1Ev,_ZThn3972_N8S7268C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S7268C14D0Ev,_ZTv0_n32_N8S7268C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5080_N8S7268C14D0Ev,_ZThn3868_N8S7268C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S7268C14D1Ev,_ZTv0_n32_N8S7268C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5080_N8S7268C14D1Ev,_ZThn3868_N8S7268C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7268C14D0Ev,_ZTv0_n28_N8S7268C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn42352_N8S7268C14D0Ev,_ZThn32676_N8S7268C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7268C14D1Ev,_ZTv0_n28_N8S7268C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn42352_N8S7268C14D1Ev,_ZThn32676_N8S7268C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S7268C14D0Ev,_ZTv0_n36_N8S7268C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7520_N8S7268C14D0Ev,_ZThn5716_N8S7268C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S7268C14D1Ev,_ZTv0_n36_N8S7268C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7520_N8S7268C14D1Ev,_ZThn5716_N8S7268C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7268C14D0Ev,_ZTv0_n20_N8S7268C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6280_N8S7268C14D0Ev,_ZThn4760_N8S7268C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7268C14D1Ev,_ZTv0_n20_N8S7268C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6280_N8S7268C14D1Ev,_ZThn4760_N8S7268C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7268C3D0Ev,_ZTv0_n20_N7S7268C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6280_N7S7268C3D0Ev,_ZThn4760_N7S7268C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7268C3D1Ev,_ZTv0_n20_N7S7268C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6280_N7S7268C3D1Ev,_ZThn4760_N7S7268C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7268C12D0Ev,_ZTv0_n28_N8S7268C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn42352_N8S7268C12D0Ev,_ZThn32676_N8S7268C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7268C12D1Ev,_ZTv0_n28_N8S7268C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn42352_N8S7268C12D1Ev,_ZThn32676_N8S7268C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S7268C12D0Ev,_ZTv0_n36_N8S7268C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7520_N8S7268C12D0Ev,_ZThn5716_N8S7268C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S7268C12D1Ev,_ZTv0_n36_N8S7268C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7520_N8S7268C12D1Ev,_ZThn5716_N8S7268C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7268C12D0Ev,_ZTv0_n20_N8S7268C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6280_N8S7268C12D0Ev,_ZThn4760_N8S7268C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7268C12D1Ev,_ZTv0_n20_N8S7268C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6280_N8S7268C12D1Ev,_ZThn4760_N8S7268C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7268C12D0Ev,_ZTv0_n16_N8S7268C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5256_N8S7268C12D0Ev,_ZThn3972_N8S7268C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7268C12D1Ev,_ZTv0_n16_N8S7268C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5256_N8S7268C12D1Ev,_ZThn3972_N8S7268C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S7268C12D0Ev,_ZTv0_n32_N8S7268C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5080_N8S7268C12D0Ev,_ZThn3868_N8S7268C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S7268C12D1Ev,_ZTv0_n32_N8S7268C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5080_N8S7268C12D1Ev,_ZThn3868_N8S7268C12D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7268C12 = {  "S7268C12", // class name
  bases_S7268C12, 25,
  &(vtc_S7268C12[0]), // expected_vtbl_contents
  &(vtt_S7268C12[0]), // expected_vtt_contents
  ABISELECT(43024,33216), // object size
  NSPAIRA(_ZTI8S7268C12),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S7268C12),106, //virtual function table var
  11, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7268C12),53, //virtual table table var
  21, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7268C18  : S7268C8 , S7268C11 , virtual S7268C13 , S7268C10 {
  char  :0;
  ~S7268C18(); // tgen
  S7268C18(); // tgen
};
//SIG(-1 S7268C18) C1{ BC2{ v1 FU3{ m Fl Fp[4] Fi} Fp FC4{ m Fs[6] FL Fc[5]}[8] Fp} BC5{ v2 v3 Fi Fp Fp Fl Fp[2] Fp Fl[6] FC4 Fi Fp Fc[2]} VBC6{ VBC7{ VBC4 vd FC4 Fi Fp FC4[2]} BC5 v4 Fi Fp} BC8{ BC7 VBC5 vd v5 Fl[4] FC7[4]} Fc:0}


S7268C18 ::~S7268C18(){ note_dtor("S7268C18", this);} // tgen
S7268C18 ::S7268C18(){ note_ctor("S7268C18", this);} // tgen

static void Test_S7268C18()
{
  extern Class_Descriptor cd_S7268C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(218,321)];
    init_test(&cd_S7268C18, buf);
    S7268C18 *dp, &lv = *(dp=new (buf) S7268C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1736,1280), "sizeof(S7268C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7268C18)");
    check_base_class_offset(lv, (S7268C8*), 0, "S7268C18");
    /*is_ambiguous_... S7268C18::S7268C11 */ AMB_check_base_class_offset(lv, (S7268C11*), ABISELECT(312,252), "S7268C18");
    /*is_ambiguous_... S7268C18::S7268C5 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7268C5*), ABISELECT(1536,1156), "S7268C18");
    check_base_class_offset(lv, (S7268C4*)(S7268C5*)(S7268C10*), ABISELECT(1536,1156), "S7268C18");
    check_base_class_offset(lv, (S7268C5*)(S7268C13*), ABISELECT(1416,1060), "S7268C18");
    check_base_class_offset(lv, (S7268C11*)(S7268C13*), ABISELECT(1240,956), "S7268C18");
    check_base_class_offset(lv, (S7268C13*), ABISELECT(1240,956), "S7268C18");
    check_base_class_offset(lv, (S7268C5*)(S7268C10*), ABISELECT(480,348), "S7268C18");
    check_base_class_offset(lv, (S7268C11*)(S7268C10*), ABISELECT(1568,1184), "S7268C18");
    check_base_class_offset(lv, (S7268C10*), ABISELECT(480,348), "S7268C18");
    test_class_info(&lv, &cd_S7268C18);
    dp->~S7268C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7268C18(Test_S7268C18, "S7268C18", ABISELECT(1736,1280));

#else // __cplusplus

extern void _ZN8S7268C18C1Ev();
extern void _ZN8S7268C18D1Ev();
Name_Map name_map_S7268C18[] = {
  NSPAIR(_ZN8S7268C18C1Ev),
  NSPAIR(_ZN8S7268C18D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7268C8;
extern VTBL_ENTRY _ZTI7S7268C8[];
extern  VTBL_ENTRY _ZTV7S7268C8[];
extern Class_Descriptor cd_S7268C11;
extern VTBL_ENTRY _ZTI8S7268C11[];
extern  VTBL_ENTRY _ZTV8S7268C11[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7268C5;
extern VTBL_ENTRY _ZTI7S7268C5[];
extern  VTBL_ENTRY _ZTV7S7268C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C5[];
extern Class_Descriptor cd_S7268C11;
extern VTBL_ENTRY _ZTI8S7268C11[];
extern  VTBL_ENTRY _ZTV8S7268C11[];
extern Class_Descriptor cd_S7268C13;
extern VTBL_ENTRY _ZTI8S7268C13[];
extern  VTBL_ENTRY _ZTV8S7268C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7268C13[];
extern Class_Descriptor cd_S7268C5;
extern VTBL_ENTRY _ZTI7S7268C5[];
extern  VTBL_ENTRY _ZTV7S7268C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C5[];
extern Class_Descriptor cd_S7268C11;
extern VTBL_ENTRY _ZTI8S7268C11[];
extern  VTBL_ENTRY _ZTV8S7268C11[];
extern Class_Descriptor cd_S7268C10;
extern VTBL_ENTRY _ZTI8S7268C10[];
extern  VTBL_ENTRY _ZTV8S7268C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7268C10[];
static Base_Class bases_S7268C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7268C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7268C11,    ABISELECT(312,252), //bcp->offset
    9, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7268C4,    ABISELECT(1536,1156), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S7268C5,    ABISELECT(1416,1060), //bcp->offset
    33, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S7268C11,    ABISELECT(1240,956), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7268C13,    ABISELECT(1240,956), //bcp->offset
    20, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7268C5,    ABISELECT(480,348), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7268C11,    ABISELECT(1568,1184), //bcp->offset
    39, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S7268C10,    ABISELECT(480,348), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7268C18[];
extern void _ZN7S7268C82v7Ev();
extern void _ZN8S7268C18D1Ev();
extern void _ZN8S7268C18D0Ev();
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
extern void ABISELECT(_ZThn480_N8S7268C18D1Ev,_ZThn348_N8S7268C18D1Ev)();
extern void ABISELECT(_ZThn480_N8S7268C18D0Ev,_ZThn348_N8S7268C18D0Ev)();
extern void _ZN8S7268C102v6Ev();
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
extern void _ZN8S7268C132v9Ev();
extern void ABISELECT(_ZTv0_n64_N8S7268C18D1Ev,_ZTv0_n32_N8S7268C18D1Ev)();
extern void ABISELECT(_ZThn1240_N8S7268C18D1Ev,_ZThn956_N8S7268C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S7268C18D0Ev,_ZTv0_n32_N8S7268C18D0Ev)();
extern void ABISELECT(_ZThn1240_N8S7268C18D0Ev,_ZThn956_N8S7268C18D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7268C18D1Ev,_ZTv0_n16_N8S7268C18D1Ev)();
extern void ABISELECT(_ZThn1416_N8S7268C18D1Ev,_ZThn1060_N8S7268C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7268C18D0Ev,_ZTv0_n16_N8S7268C18D0Ev)();
extern void ABISELECT(_ZThn1416_N8S7268C18D0Ev,_ZThn1060_N8S7268C18D0Ev)() __attribute__((weak));
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY vtc_S7268C18[] = {
  ABISELECT(1568,1184),
  ABISELECT(1536,1156),
  ABISELECT(1416,1060),
  ABISELECT(1240,956),
  0,
  (VTBL_ENTRY)&(_ZTI8S7268C18[0]),
  (VTBL_ENTRY)&_ZN7S7268C82v7Ev,
  (VTBL_ENTRY)&_ZN8S7268C18D1Ev,
  (VTBL_ENTRY)&_ZN8S7268C18D0Ev,
  ABISELECT(-312,-252),
  (VTBL_ENTRY)&(_ZTI8S7268C18[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
  ABISELECT(1088,836),
  ABISELECT(1056,808),
  ABISELECT(-480,-348),
  (VTBL_ENTRY)&(_ZTI8S7268C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn480_N8S7268C18D1Ev,_ZThn348_N8S7268C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn480_N8S7268C18D0Ev,_ZThn348_N8S7268C18D0Ev),
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
  ABISELECT(-1240,-956),
  0,
  0,
  0,
  ABISELECT(296,200),
  ABISELECT(176,104),
  ABISELECT(-1240,-956),
  (VTBL_ENTRY)&(_ZTI8S7268C18[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
  (VTBL_ENTRY)&_ZN8S7268C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7268C18D1Ev,_ZTv0_n32_N8S7268C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7268C18D0Ev,_ZTv0_n32_N8S7268C18D0Ev),
  ABISELECT(-1416,-1060),
  ABISELECT(120,96),
  ABISELECT(-1416,-1060),
  (VTBL_ENTRY)&(_ZTI8S7268C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7268C18D1Ev,_ZTv0_n16_N8S7268C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7268C18D0Ev,_ZTv0_n16_N8S7268C18D0Ev),
  0,
  0,
  ABISELECT(-1568,-1184),
  (VTBL_ENTRY)&(_ZTI8S7268C18[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
extern VTBL_ENTRY _ZTV8S7268C18[];
extern void _ZN8S7268C10D1Ev();
extern void _ZN8S7268C10D0Ev();
extern void _ZN8S7268C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C10__8S7268C18[] = {
  ABISELECT(1088,836),
  ABISELECT(1056,808),
  0,
  (VTBL_ENTRY)&(_ZTI8S7268C10[0]),
  (VTBL_ENTRY)&_ZN8S7268C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7268C10D0Ev,
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
};
extern void _ZN7S7268C5D1Ev();
extern void _ZN7S7268C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C58S7268C10__A1__8S7268C18[] = {
  ABISELECT(1056,808),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C5[0]),
  (VTBL_ENTRY)&_ZN7S7268C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C5D0Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C11__8S7268C10__8S7268C18[] = {
  0,
  0,
  ABISELECT(-1088,-836),
  (VTBL_ENTRY)&(_ZTI8S7268C10[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
extern void _ZN8S7268C132v9Ev();
extern void _ZN8S7268C13D1Ev();
extern void _ZN8S7268C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C13__8S7268C18[] = {
  ABISELECT(296,200),
  ABISELECT(176,104),
  0,
  (VTBL_ENTRY)&(_ZTI8S7268C13[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
  (VTBL_ENTRY)&_ZN8S7268C132v9Ev,
  (VTBL_ENTRY)&_ZN8S7268C13D1Ev,
  (VTBL_ENTRY)&_ZN8S7268C13D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S7268C13D1Ev,_ZTv0_n16_N8S7268C13D1Ev)();
extern void ABISELECT(_ZThn176_N8S7268C13D1Ev,_ZThn104_N8S7268C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7268C13D0Ev,_ZTv0_n16_N8S7268C13D0Ev)();
extern void ABISELECT(_ZThn176_N8S7268C13D0Ev,_ZThn104_N8S7268C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7268C5__8S7268C13__8S7268C18[] = {
  ABISELECT(-176,-104),
  ABISELECT(120,96),
  ABISELECT(-176,-104),
  (VTBL_ENTRY)&(_ZTI8S7268C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7268C13D1Ev,_ZTv0_n16_N8S7268C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7268C13D0Ev,_ZTv0_n16_N8S7268C13D0Ev),
};
extern void _ZN7S7268C5D1Ev();
extern void _ZN7S7268C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C5__8S7268C18[] = {
  ABISELECT(120,96),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C5[0]),
  (VTBL_ENTRY)&_ZN7S7268C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C5D0Ev,
};
static  VTT_ENTRY vtt_S7268C18[] = {
  {&(_ZTV8S7268C18[6]),  6,45},
  {&(_tg__ZTV8S7268C10__8S7268C18[4]),  4,7},
  {&(_tg__ZTV7S7268C58S7268C10__A1__8S7268C18[3]),  3,5},
  {&(_tg__ZTV8S7268C11__8S7268C10__8S7268C18[4]),  4,6},
  {&(_ZTV8S7268C18[28]),  28,45},
  {&(_ZTV8S7268C18[37]),  37,45},
  {&(_ZTV8S7268C18[17]),  17,45},
  {&(_ZTV8S7268C18[43]),  43,45},
  {&(_tg__ZTV8S7268C13__8S7268C18[4]),  4,9},
  {&(_tg__ZTV7S7268C5__8S7268C13__8S7268C18[4]),  4,6},
  {&(_tg__ZTV7S7268C5__8S7268C18[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S7268C18[];
extern  VTBL_ENTRY _ZTV8S7268C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7268C18[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7268C13D0Ev,_ZTv0_n16_N8S7268C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7268C13D0Ev,_ZThn104_N8S7268C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7268C13D1Ev,_ZTv0_n16_N8S7268C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7268C13D1Ev,_ZThn104_N8S7268C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7268C18D0Ev,_ZTv0_n16_N8S7268C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1416_N8S7268C18D0Ev,_ZThn1060_N8S7268C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7268C18D1Ev,_ZTv0_n16_N8S7268C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1416_N8S7268C18D1Ev,_ZThn1060_N8S7268C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S7268C18D0Ev,_ZTv0_n32_N8S7268C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1240_N8S7268C18D0Ev,_ZThn956_N8S7268C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S7268C18D1Ev,_ZTv0_n32_N8S7268C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1240_N8S7268C18D1Ev,_ZThn956_N8S7268C18D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7268C18 = {  "S7268C18", // class name
  bases_S7268C18, 9,
  &(vtc_S7268C18[0]), // expected_vtbl_contents
  &(vtt_S7268C18[0]), // expected_vtt_contents
  ABISELECT(1736,1280), // object size
  NSPAIRA(_ZTI8S7268C18),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S7268C18),45, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7268C18),11, //virtual table table var
  8, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7268C1  : S7268C2 , S7268C12 {
  __tsi64 s7268c1f0;
  __tsi64 s7268c1f1;
  long double s7268c1f2[10];
  char s7268c1f3[5];
  ::S7268C18 s7268c1f4;
  virtual  ~S7268C1(); // _ZN7S7268C1D2Ev
  virtual void  v1(); // _ZN7S7268C12v1Ev
  S7268C1(); // tgen
};
//SIG(1 S7268C1) C1{ BC2{ VBC3{ BC4{ m Fs[6] FL Fc[5]} BC5{ VBC4 vd FC4 Fi Fp FC4[2]} VBC6{ v2 v3 FC4 Fc FC7{ BC8{ v7 FU9{ m Fl Fp[4] Fi} Fp FC4[8] Fp} VBC4 BC5 Fp[5] Fc:0 Fi Fi Fi:10 Fc[8] Fs Fi Fp[10] FC5 FL Fi Fp} Fp Fi Fi Fp Fi Fi:11 Fi} VBC10{ BC5 VBC11{ v4 v5 Fi Fp Fp Fl Fp[2] Fp Fl[6] FC4 Fi Fp Fc[2]} vd v6 Fl[4] FC5[4]} BC8 Fp Fi[6] FL FC5 Fc} v8 FC4 FC10[5] FC3[10] FL[4] Fc FC3 FC3} BC12{ VBC13{ VBC5 BC11 v9 Fi Fp} BC14{ BC3 BC15{ BC6 VBC8 VBC4 BC10 vd Fi Fi Fc[4] Fp[3] Fs Fi Fi FD Fp Fp Fi} VBC2 BC4 VBC13 vd v10 FU16{ m Fi Fc[7] Fi[10] Fi FD[8] Fi Fp Fi} Fp Fi FL FL FC15 FL Fi[8] Fi} BC11 FC17{}} vd v1 FL FL FD[10] Fc[5] FC18{ BC8 BC11 VBC13 BC10 Fc:0}}


 S7268C1 ::~S7268C1(){ note_dtor("S7268C1", this);}
void  S7268C1 ::v1(){vfunc_called(this, "_ZN7S7268C12v1Ev");}
S7268C1 ::S7268C1(){ note_ctor("S7268C1", this);} // tgen

static void Test_S7268C1()
{
  extern Class_Descriptor cd_S7268C1;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(4987,15401)];
    init_test(&cd_S7268C1, buf);
    S7268C1 *dp, &lv = *(dp=new (buf) S7268C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(79776,61600), "sizeof(S7268C1)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7268C1)");
    /*is_ambiguous_... S7268C1::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7268C3*), ABISELECT(41960,32348), "S7268C1");
    /*is_ambiguous_... S7268C1::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7268C5*)(S7268C3*), ABISELECT(42504,32792), "S7268C1");
    /*is_ambiguous_... S7268C1::S7268C10 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7268C5*)(S7268C10*), ABISELECT(42504,32792), "S7268C1");
    /*is_ambiguous_... S7268C1::S7268C5 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7268C5*), ABISELECT(42504,32792), "S7268C1");
    /*is_ambiguous_... S7268C14::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7268C5*)(S7268C3*)(S7268C14*)(S7268C12*), ABISELECT(42504,32792), "S7268C1");
    check_base_class_offset(lv, (S7268C4*)(S7268C15*)(S7268C14*)(S7268C12*), ABISELECT(42504,32792), "S7268C1");
    check_base_class_offset(lv, (S7268C4*)(S7268C5*)(S7268C10*)(S7268C15*)(S7268C14*)(S7268C12*), ABISELECT(42504,32792), "S7268C1");
    /*is_ambiguous_... S7268C1::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C5*)(S7268C3*), ABISELECT(41840,32252), "S7268C1");
    /*is_ambiguous_... S7268C1::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C6*)(S7268C3*), ABISELECT(42536,32820), "S7268C1");
    /*is_ambiguous_... S7268C14::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C6*)(S7268C3*)(S7268C14*)(S7268C12*), ABISELECT(42536,32820), "S7268C1");
    /*is_ambiguous_... S7268C1::S7268C10 */ AMB_check_base_class_offset(lv, (S7268C5*)(S7268C10*), ABISELECT(43408,33484), "S7268C1");
    /*is_ambiguous_... S7268C1::S7268C10 */ AMB_check_base_class_offset(lv, (S7268C11*)(S7268C10*), ABISELECT(44168,34092), "S7268C1");
    check_base_class_offset(lv, (S7268C11*)(S7268C10*)(S7268C15*)(S7268C14*)(S7268C12*), ABISELECT(44168,34092), "S7268C1");
    /*is_ambiguous_... S7268C1::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C10*)(S7268C3*), ABISELECT(43408,33484), "S7268C1");
    /*is_ambiguous_... S7268C14::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C10*)(S7268C3*)(S7268C14*)(S7268C12*), ABISELECT(43408,33484), "S7268C1");
    /*is_ambiguous_... S7268C1::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C8*)(S7268C3*), ABISELECT(41992,32376), "S7268C1");
    /*is_ambiguous_... S7268C1::S7268C2 */ AMB_check_base_class_offset(lv, (S7268C3*)(S7268C2*), ABISELECT(41840,32252), "S7268C1");
    /*is_ambiguous_... S7268C1::S7268C2 */ AMB_check_base_class_offset(lv, (S7268C3*)(S7268C2*), ABISELECT(41840,32252), "S7268C1");
    /*is_ambiguous_... S7268C1::S7268C2 */ AMB_check_base_class_offset(lv, (S7268C2*), 0, "S7268C1");
    check_base_class_offset(lv, (S7268C5*)(S7268C13*), ABISELECT(44512,34292), "S7268C1");
    check_base_class_offset(lv, (S7268C11*)(S7268C13*), ABISELECT(44336,34188), "S7268C1");
    check_base_class_offset(lv, (S7268C13*)(S7268C12*), ABISELECT(44336,34188), "S7268C1");
    check_base_class_offset(lv, (S7268C13*)(S7268C14*)(S7268C12*), ABISELECT(44336,34188), "S7268C1");
    /*is_ambiguous_... S7268C14::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7268C3*)(S7268C14*)(S7268C12*), ABISELECT(34952,27056), "S7268C1");
    /*is_ambiguous_... S7268C14::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C5*)(S7268C3*)(S7268C14*)(S7268C12*), ABISELECT(34832,26960), "S7268C1");
    /*is_ambiguous_... S7268C14::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C8*)(S7268C3*)(S7268C14*)(S7268C12*), ABISELECT(34984,27084), "S7268C1");
    /*is_ambiguous_... S7268C14::S7268C3 */ AMB_check_base_class_offset(lv, (S7268C3*)(S7268C14*)(S7268C12*), ABISELECT(34832,26960), "S7268C1");
    check_base_class_offset(lv, (S7268C6*)(S7268C15*)(S7268C14*)(S7268C12*), ABISELECT(35504,27500), "S7268C1");
    check_base_class_offset(lv, (S7268C8*)(S7268C15*)(S7268C14*)(S7268C12*), ABISELECT(44632,34388), "S7268C1");
    check_base_class_offset(lv, (S7268C5*)(S7268C10*)(S7268C15*)(S7268C14*)(S7268C12*), ABISELECT(36376,28164), "S7268C1");
    check_base_class_offset(lv, (S7268C10*)(S7268C15*)(S7268C14*)(S7268C12*), ABISELECT(36376,28164), "S7268C1");
    check_base_class_offset(lv, (S7268C15*)(S7268C14*)(S7268C12*), ABISELECT(35504,27500), "S7268C1");
    check_base_class_offset(lv, (S7268C2*)(S7268C14*)(S7268C12*), ABISELECT(44944,34640), "S7268C1");
    /*is_ambiguous_... S7268C14::S7268C4 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7268C14*)(S7268C12*), ABISELECT(37240,28832), "S7268C1");
    check_base_class_offset(lv, (S7268C14*)(S7268C12*), ABISELECT(34832,26960), "S7268C1");
    /*is_ambiguous_... S7268C12::S7268C11 */ AMB_check_base_class_offset(lv, (S7268C11*)(S7268C12*), ABISELECT(39744,30732), "S7268C1");
    check_base_class_offset(lv, (S7268C12*), ABISELECT(34832,26960), "S7268C1");
    check_field_offset(lv, s7268c1f0, ABISELECT(39912,30828), "S7268C1.s7268c1f0");
    check_field_offset(lv, s7268c1f1, ABISELECT(39920,30836), "S7268C1.s7268c1f1");
    check_field_offset(lv, s7268c1f2, ABISELECT(39936,30844), "S7268C1.s7268c1f2");
    check_field_offset(lv, s7268c1f3, ABISELECT(40096,30964), "S7268C1.s7268c1f3");
    check_field_offset(lv, s7268c1f4, ABISELECT(40104,30972), "S7268C1.s7268c1f4");
    test_class_info(&lv, &cd_S7268C1);
    dp->~S7268C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7268C1(Test_S7268C1, "S7268C1", ABISELECT(79776,61600));

#else // __cplusplus

extern void _ZN7S7268C1C1Ev();
extern void _ZN7S7268C1D2Ev();
Name_Map name_map_S7268C1[] = {
  NSPAIR(_ZN7S7268C1C1Ev),
  NSPAIR(_ZN7S7268C1D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7268C5;
extern VTBL_ENTRY _ZTI7S7268C5[];
extern  VTBL_ENTRY _ZTV7S7268C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C5[];
extern Class_Descriptor cd_S7268C6;
extern VTBL_ENTRY _ZTI7S7268C6[];
extern  VTBL_ENTRY _ZTV7S7268C6[];
extern Class_Descriptor cd_S7268C5;
extern VTBL_ENTRY _ZTI7S7268C5[];
extern  VTBL_ENTRY _ZTV7S7268C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C5[];
extern Class_Descriptor cd_S7268C11;
extern VTBL_ENTRY _ZTI8S7268C11[];
extern  VTBL_ENTRY _ZTV8S7268C11[];
extern Class_Descriptor cd_S7268C10;
extern VTBL_ENTRY _ZTI8S7268C10[];
extern  VTBL_ENTRY _ZTV8S7268C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7268C10[];
extern Class_Descriptor cd_S7268C8;
extern VTBL_ENTRY _ZTI7S7268C8[];
extern  VTBL_ENTRY _ZTV7S7268C8[];
extern Class_Descriptor cd_S7268C3;
extern VTBL_ENTRY _ZTI7S7268C3[];
extern  VTBL_ENTRY _ZTV7S7268C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C3[];
extern Class_Descriptor cd_S7268C2;
extern VTBL_ENTRY _ZTI7S7268C2[];
extern  VTBL_ENTRY _ZTV7S7268C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C2[];
extern Class_Descriptor cd_S7268C5;
extern VTBL_ENTRY _ZTI7S7268C5[];
extern  VTBL_ENTRY _ZTV7S7268C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C5[];
extern Class_Descriptor cd_S7268C11;
extern VTBL_ENTRY _ZTI8S7268C11[];
extern  VTBL_ENTRY _ZTV8S7268C11[];
extern Class_Descriptor cd_S7268C13;
extern VTBL_ENTRY _ZTI8S7268C13[];
extern  VTBL_ENTRY _ZTV8S7268C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7268C13[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7268C5;
extern VTBL_ENTRY _ZTI7S7268C5[];
extern  VTBL_ENTRY _ZTV7S7268C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C5[];
extern Class_Descriptor cd_S7268C8;
extern VTBL_ENTRY _ZTI7S7268C8[];
extern  VTBL_ENTRY _ZTV7S7268C8[];
extern Class_Descriptor cd_S7268C3;
extern VTBL_ENTRY _ZTI7S7268C3[];
extern  VTBL_ENTRY _ZTV7S7268C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C3[];
extern Class_Descriptor cd_S7268C6;
extern VTBL_ENTRY _ZTI7S7268C6[];
extern  VTBL_ENTRY _ZTV7S7268C6[];
extern Class_Descriptor cd_S7268C8;
extern VTBL_ENTRY _ZTI7S7268C8[];
extern  VTBL_ENTRY _ZTV7S7268C8[];
extern Class_Descriptor cd_S7268C5;
extern VTBL_ENTRY _ZTI7S7268C5[];
extern  VTBL_ENTRY _ZTV7S7268C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C5[];
extern Class_Descriptor cd_S7268C10;
extern VTBL_ENTRY _ZTI8S7268C10[];
extern  VTBL_ENTRY _ZTV8S7268C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7268C10[];
extern Class_Descriptor cd_S7268C15;
extern VTBL_ENTRY _ZTI8S7268C15[];
extern  VTBL_ENTRY _ZTV8S7268C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7268C15[];
extern Class_Descriptor cd_S7268C2;
extern VTBL_ENTRY _ZTI7S7268C2[];
extern  VTBL_ENTRY _ZTV7S7268C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C2[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7268C14;
extern VTBL_ENTRY _ZTI8S7268C14[];
extern  VTBL_ENTRY _ZTV8S7268C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7268C14[];
extern Class_Descriptor cd_S7268C11;
extern VTBL_ENTRY _ZTI8S7268C11[];
extern  VTBL_ENTRY _ZTV8S7268C11[];
extern Class_Descriptor cd_S7268C12;
extern VTBL_ENTRY _ZTI8S7268C12[];
extern  VTBL_ENTRY _ZTV8S7268C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7268C12[];
static Base_Class bases_S7268C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7268C4,    ABISELECT(41960,32348), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7268C4,    ABISELECT(42504,32792), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S7268C5,    ABISELECT(41840,32252), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    57, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7268C6,    ABISELECT(42536,32820), //bcp->offset
    65, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    45, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S7268C5,    ABISELECT(43408,33484), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    62, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S7268C11,    ABISELECT(44168,34092), //bcp->offset
    80, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    47, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S7268C10,    ABISELECT(43408,33484), //bcp->offset
    71, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    46, //bcp->index_in_construction_vtbl_array
    61, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S7268C8,    ABISELECT(41992,32376), //bcp->offset
    62, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    48, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7268C3,    ABISELECT(41840,32252), //bcp->offset
    52, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    44, //bcp->index_in_construction_vtbl_array
    56, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S7268C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7268C5,    ABISELECT(44512,34292), //bcp->offset
    99, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    51, //bcp->index_in_construction_vtbl_array
    66, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S7268C11,    ABISELECT(44336,34188), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S7268C13,    ABISELECT(44336,34188), //bcp->offset
    86, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    50, //bcp->index_in_construction_vtbl_array
    64, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    24, //immediately_derived
  0, 1},
  {&cd_S7268C4,    ABISELECT(34952,27056), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S7268C5,    ABISELECT(34832,26960), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S7268C8,    ABISELECT(34984,27084), //bcp->offset
    29, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S7268C3,    ABISELECT(34832,26960), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S7268C6,    ABISELECT(35504,27500), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S7268C8,    ABISELECT(44632,34388), //bcp->offset
    105, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    53, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    21, //immediately_derived
  0, 1},
  {&cd_S7268C5,    ABISELECT(36376,28164), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S7268C10,    ABISELECT(36376,28164), //bcp->offset
    41, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    54, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S7268C15,    ABISELECT(35504,27500), //bcp->offset
    32, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    52, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S7268C2,    ABISELECT(44944,34640), //bcp->offset
    109, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    55, //bcp->index_in_construction_vtbl_array
    67, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    24, //immediately_derived
  0, 1},
  {&cd_S7268C4,    ABISELECT(37240,28832), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S7268C14,    ABISELECT(34832,26960), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S7268C11,    ABISELECT(39744,30732), //bcp->offset
    48, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S7268C12,    ABISELECT(34832,26960), //bcp->offset
    15, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    49, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S7268C1[];
extern void _ZN7S7268C22v8Ev();
extern void _ZN7S7268C1D1Ev();
extern void _ZN7S7268C1D0Ev();
extern void _ZN7S7268C12v1Ev();
extern void ABISELECT(_ZThn34832_N7S7268C1D1Ev,_ZThn26960_N7S7268C1D1Ev)();
extern void ABISELECT(_ZThn34832_N7S7268C1D0Ev,_ZThn26960_N7S7268C1D0Ev)();
extern void _ZN8S7268C143v10Ev();
extern void _ZN7S7268C82v7Ev();
extern void _ZN7S7268C62v2Ev();
extern void _ZN7S7268C62v3Ev();
extern void ABISELECT(_ZThn35504_N7S7268C1D1Ev,_ZThn27500_N7S7268C1D1Ev)();
extern void ABISELECT(_ZThn35504_N7S7268C1D0Ev,_ZThn27500_N7S7268C1D0Ev)();
extern void ABISELECT(_ZThn36376_N7S7268C1D1Ev,_ZThn28164_N7S7268C1D1Ev)();
extern void ABISELECT(_ZThn36376_N7S7268C1D0Ev,_ZThn28164_N7S7268C1D0Ev)();
extern void _ZN8S7268C102v6Ev();
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
extern void ABISELECT(_ZTv0_n56_N7S7268C1D1Ev,_ZTv0_n28_N7S7268C1D1Ev)();
extern void ABISELECT(_ZThn41840_N7S7268C1D1Ev,_ZThn32252_N7S7268C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N7S7268C1D0Ev,_ZTv0_n28_N7S7268C1D0Ev)();
extern void ABISELECT(_ZThn41840_N7S7268C1D0Ev,_ZThn32252_N7S7268C1D0Ev)() __attribute__((weak));
extern void _ZN7S7268C82v7Ev();
extern void _ZN7S7268C62v2Ev();
extern void _ZN7S7268C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N7S7268C1D1Ev,_ZTv0_n20_N7S7268C1D1Ev)();
extern void ABISELECT(_ZThn43408_N7S7268C1D1Ev,_ZThn33484_N7S7268C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S7268C1D0Ev,_ZTv0_n20_N7S7268C1D0Ev)();
extern void ABISELECT(_ZThn43408_N7S7268C1D0Ev,_ZThn33484_N7S7268C1D0Ev)() __attribute__((weak));
extern void _ZN8S7268C102v6Ev();
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
extern void _ZN8S7268C132v9Ev();
extern void ABISELECT(_ZTv0_n64_N7S7268C1D1Ev,_ZTv0_n32_N7S7268C1D1Ev)();
extern void ABISELECT(_ZThn44336_N7S7268C1D1Ev,_ZThn34188_N7S7268C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S7268C1D0Ev,_ZTv0_n32_N7S7268C1D0Ev)();
extern void ABISELECT(_ZThn44336_N7S7268C1D0Ev,_ZThn34188_N7S7268C1D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S7268C1D1Ev,_ZTv0_n16_N7S7268C1D1Ev)();
extern void ABISELECT(_ZThn44512_N7S7268C1D1Ev,_ZThn34292_N7S7268C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S7268C1D0Ev,_ZTv0_n16_N7S7268C1D0Ev)();
extern void ABISELECT(_ZThn44512_N7S7268C1D0Ev,_ZThn34292_N7S7268C1D0Ev)() __attribute__((weak));
extern void _ZN7S7268C82v7Ev();
extern void _ZN7S7268C22v8Ev();
extern void ABISELECT(_ZTv0_n72_N7S7268C1D1Ev,_ZTv0_n36_N7S7268C1D1Ev)();
extern void ABISELECT(_ZThn44944_N7S7268C1D1Ev,_ZThn34640_N7S7268C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N7S7268C1D0Ev,_ZTv0_n36_N7S7268C1D0Ev)();
extern void ABISELECT(_ZThn44944_N7S7268C1D0Ev,_ZThn34640_N7S7268C1D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7268C1[] = {
  ABISELECT(44944,34640),
  ABISELECT(44632,34388),
  ABISELECT(44512,34292),
  ABISELECT(44336,34188),
  ABISELECT(44168,34092),
  ABISELECT(43408,33484),
  ABISELECT(42536,32820),
  ABISELECT(42504,32792),
  ABISELECT(41840,32252),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C1[0]),
  (VTBL_ENTRY)&_ZN7S7268C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7268C1D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C1D0Ev,
  (VTBL_ENTRY)&_ZN7S7268C12v1Ev,
  ABISELECT(9680,7332),
  ABISELECT(9504,7228),
  ABISELECT(7008,5292),
  ABISELECT(10112,7680),
  ABISELECT(9800,7428),
  ABISELECT(9336,7132),
  ABISELECT(8576,6524),
  ABISELECT(7704,5860),
  ABISELECT(7672,5832),
  ABISELECT(-34832,-26960),
  (VTBL_ENTRY)&(_ZTI7S7268C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn34832_N7S7268C1D1Ev,_ZThn26960_N7S7268C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn34832_N7S7268C1D0Ev,_ZThn26960_N7S7268C1D0Ev),
  (VTBL_ENTRY)&_ZN8S7268C143v10Ev,
  ABISELECT(-34984,-27084),
  (VTBL_ENTRY)&(_ZTI7S7268C1[0]),
  (VTBL_ENTRY)&_ZN7S7268C82v7Ev,
  ABISELECT(8664,6592),
  ABISELECT(7000,5292),
  ABISELECT(9128,6888),
  ABISELECT(-35504,-27500),
  (VTBL_ENTRY)&(_ZTI7S7268C1[0]),
  (VTBL_ENTRY)&_ZN7S7268C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7268C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn35504_N7S7268C1D1Ev,_ZThn27500_N7S7268C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn35504_N7S7268C1D0Ev,_ZThn27500_N7S7268C1D0Ev),
  ABISELECT(7792,5928),
  ABISELECT(6128,4628),
  ABISELECT(-36376,-28164),
  (VTBL_ENTRY)&(_ZTI7S7268C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn36376_N7S7268C1D1Ev,_ZThn28164_N7S7268C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn36376_N7S7268C1D0Ev,_ZThn28164_N7S7268C1D0Ev),
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
  ABISELECT(-39744,-30732),
  (VTBL_ENTRY)&(_ZTI7S7268C1[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
  ABISELECT(152,124),
  ABISELECT(-41840,-32252),
  ABISELECT(2328,1840),
  ABISELECT(1568,1232),
  ABISELECT(696,568),
  ABISELECT(664,540),
  ABISELECT(-41840,-32252),
  (VTBL_ENTRY)&(_ZTI7S7268C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7268C1D1Ev,_ZTv0_n28_N7S7268C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7268C1D0Ev,_ZTv0_n28_N7S7268C1D0Ev),
  ABISELECT(-41992,-32376),
  (VTBL_ENTRY)&(_ZTI7S7268C1[0]),
  (VTBL_ENTRY)&_ZN7S7268C82v7Ev,
  0,
  0,
  ABISELECT(-42536,-32820),
  (VTBL_ENTRY)&(_ZTI7S7268C1[0]),
  (VTBL_ENTRY)&_ZN7S7268C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7268C62v3Ev,
  0,
  ABISELECT(-43408,-33484),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-43408,-33484),
  (VTBL_ENTRY)&(_ZTI7S7268C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7268C1D1Ev,_ZTv0_n20_N7S7268C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7268C1D0Ev,_ZTv0_n20_N7S7268C1D0Ev),
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
  0,
  0,
  ABISELECT(-44168,-34092),
  (VTBL_ENTRY)&(_ZTI7S7268C1[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
  ABISELECT(-44336,-34188),
  0,
  0,
  0,
  ABISELECT(-1832,-1396),
  ABISELECT(176,104),
  ABISELECT(-44336,-34188),
  (VTBL_ENTRY)&(_ZTI7S7268C1[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
  (VTBL_ENTRY)&_ZN8S7268C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S7268C1D1Ev,_ZTv0_n32_N7S7268C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S7268C1D0Ev,_ZTv0_n32_N7S7268C1D0Ev),
  ABISELECT(-44512,-34292),
  ABISELECT(-2008,-1500),
  ABISELECT(-44512,-34292),
  (VTBL_ENTRY)&(_ZTI7S7268C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S7268C1D1Ev,_ZTv0_n16_N7S7268C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S7268C1D0Ev,_ZTv0_n16_N7S7268C1D0Ev),
  0,
  ABISELECT(-44632,-34388),
  (VTBL_ENTRY)&(_ZTI7S7268C1[0]),
  (VTBL_ENTRY)&_ZN7S7268C82v7Ev,
  ABISELECT(-44944,-34640),
  0,
  ABISELECT(-776,-548),
  ABISELECT(-1536,-1156),
  ABISELECT(-2408,-1820),
  ABISELECT(-2440,-1848),
  ABISELECT(-3104,-2388),
  ABISELECT(-44944,-34640),
  (VTBL_ENTRY)&(_ZTI7S7268C1[0]),
  (VTBL_ENTRY)&_ZN7S7268C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N7S7268C1D1Ev,_ZTv0_n36_N7S7268C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N7S7268C1D0Ev,_ZTv0_n36_N7S7268C1D0Ev),
};
extern VTBL_ENTRY _ZTV7S7268C1[];
extern void _ZN7S7268C22v8Ev();
extern void _ZN7S7268C2D1Ev();
extern void _ZN7S7268C2D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C2__A__7S7268C1[] = {
  ABISELECT(44168,34092),
  ABISELECT(43408,33484),
  ABISELECT(42536,32820),
  ABISELECT(42504,32792),
  ABISELECT(41840,32252),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C2[0]),
  (VTBL_ENTRY)&_ZN7S7268C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7268C2D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C2D0Ev,
};
extern void ABISELECT(_ZTv0_n56_N7S7268C2D1Ev,_ZTv0_n28_N7S7268C2D1Ev)();
extern void ABISELECT(_ZThn41840_N7S7268C2D1Ev,_ZThn32252_N7S7268C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N7S7268C2D0Ev,_ZTv0_n28_N7S7268C2D0Ev)();
extern void ABISELECT(_ZThn41840_N7S7268C2D0Ev,_ZThn32252_N7S7268C2D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7268C3__7S7268C2__A__7S7268C1[] = {
  ABISELECT(152,124),
  ABISELECT(-41840,-32252),
  ABISELECT(2328,1840),
  ABISELECT(1568,1232),
  ABISELECT(696,568),
  ABISELECT(664,540),
  ABISELECT(-41840,-32252),
  (VTBL_ENTRY)&(_ZTI7S7268C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7268C2D1Ev,_ZTv0_n28_N7S7268C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7268C2D0Ev,_ZTv0_n28_N7S7268C2D0Ev),
};
extern void _ZN7S7268C62v2Ev();
extern void _ZN7S7268C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C6__7S7268C2__A__7S7268C1[] = {
  0,
  0,
  ABISELECT(-42536,-32820),
  (VTBL_ENTRY)&(_ZTI7S7268C2[0]),
  (VTBL_ENTRY)&_ZN7S7268C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7268C62v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S7268C2D1Ev,_ZTv0_n20_N7S7268C2D1Ev)();
extern void ABISELECT(_ZThn43408_N7S7268C2D1Ev,_ZThn33484_N7S7268C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S7268C2D0Ev,_ZTv0_n20_N7S7268C2D0Ev)();
extern void ABISELECT(_ZThn43408_N7S7268C2D0Ev,_ZThn33484_N7S7268C2D0Ev)() __attribute__((weak));
extern void _ZN8S7268C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C10__7S7268C2__A__7S7268C1[] = {
  0,
  ABISELECT(-43408,-33484),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-43408,-33484),
  (VTBL_ENTRY)&(_ZTI7S7268C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7268C2D1Ev,_ZTv0_n20_N7S7268C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7268C2D0Ev,_ZTv0_n20_N7S7268C2D0Ev),
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C11__7S7268C2__A__7S7268C1[] = {
  0,
  0,
  ABISELECT(-44168,-34092),
  (VTBL_ENTRY)&(_ZTI7S7268C2[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
extern void _ZN7S7268C82v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C87S7268C3__7S7268C2__A__7S7268C1[] = {
  ABISELECT(-41992,-32376),
  (VTBL_ENTRY)&(_ZTI7S7268C2[0]),
  (VTBL_ENTRY)&_ZN7S7268C82v7Ev,
};
extern void _ZN8S7268C12D1Ev();
extern void _ZN8S7268C12D0Ev();
extern void _ZN8S7268C143v10Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C12__7S7268C1[] = {
  ABISELECT(9680,7332),
  ABISELECT(9504,7228),
  ABISELECT(7008,5292),
  ABISELECT(10112,7680),
  ABISELECT(9800,7428),
  ABISELECT(9336,7132),
  ABISELECT(8576,6524),
  ABISELECT(7704,5860),
  ABISELECT(7672,5832),
  0,
  (VTBL_ENTRY)&(_ZTI8S7268C12[0]),
  (VTBL_ENTRY)&_ZN8S7268C12D1Ev,
  (VTBL_ENTRY)&_ZN8S7268C12D0Ev,
  (VTBL_ENTRY)&_ZN8S7268C143v10Ev,
};
extern void _ZN8S7268C14D1Ev();
extern void _ZN8S7268C14D0Ev();
extern void _ZN8S7268C143v10Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C148S7268C12__7S7268C1[] = {
  ABISELECT(9680,7332),
  ABISELECT(9504,7228),
  ABISELECT(7008,5292),
  ABISELECT(10112,7680),
  ABISELECT(9800,7428),
  ABISELECT(9336,7132),
  ABISELECT(8576,6524),
  ABISELECT(7704,5860),
  ABISELECT(7672,5832),
  0,
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&_ZN8S7268C14D1Ev,
  (VTBL_ENTRY)&_ZN8S7268C14D0Ev,
  (VTBL_ENTRY)&_ZN8S7268C143v10Ev,
};
extern void _ZN7S7268C3D1Ev();
extern void _ZN7S7268C3D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C38S7268C148S7268C12__A1__7S7268C1[] = {
  ABISELECT(9336,7132),
  ABISELECT(8576,6524),
  ABISELECT(7704,5860),
  ABISELECT(7672,5832),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&_ZN7S7268C3D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C3D0Ev,
};
extern void _ZN7S7268C5D1Ev();
extern void _ZN7S7268C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C57S7268C38S7268C148S7268C12__A3__7S7268C1[] = {
  ABISELECT(7672,5832),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C5[0]),
  (VTBL_ENTRY)&_ZN7S7268C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C5D0Ev,
};
extern void _ZN7S7268C62v2Ev();
extern void _ZN7S7268C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C6__7S7268C38S7268C148S7268C12__A1__7S7268C1[] = {
  0,
  0,
  ABISELECT(-7704,-5860),
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&_ZN7S7268C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7268C62v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S7268C3D1Ev,_ZTv0_n20_N7S7268C3D1Ev)();
extern void ABISELECT(_ZThn8576_N7S7268C3D1Ev,_ZThn6524_N7S7268C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S7268C3D0Ev,_ZTv0_n20_N7S7268C3D0Ev)();
extern void ABISELECT(_ZThn8576_N7S7268C3D0Ev,_ZThn6524_N7S7268C3D0Ev)() __attribute__((weak));
extern void _ZN8S7268C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C10__7S7268C38S7268C148S7268C12__A1__7S7268C1[] = {
  0,
  ABISELECT(-8576,-6524),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-8576,-6524),
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7268C3D1Ev,_ZTv0_n20_N7S7268C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7268C3D0Ev,_ZTv0_n20_N7S7268C3D0Ev),
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C11__7S7268C38S7268C148S7268C12__A1__7S7268C1[] = {
  0,
  0,
  ABISELECT(-9336,-7132),
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
extern void _ZN7S7268C62v2Ev();
extern void _ZN7S7268C62v3Ev();
extern void _ZN8S7268C15D1Ev();
extern void _ZN8S7268C15D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C158S7268C148S7268C12__7S7268C1[] = {
  ABISELECT(8664,6592),
  ABISELECT(7000,5292),
  ABISELECT(9128,6888),
  0,
  (VTBL_ENTRY)&(_ZTI8S7268C15[0]),
  (VTBL_ENTRY)&_ZN7S7268C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7268C62v3Ev,
  (VTBL_ENTRY)&_ZN8S7268C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7268C15D0Ev,
};
extern void _ZN8S7268C10D1Ev();
extern void _ZN8S7268C10D0Ev();
extern void _ZN8S7268C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C108S7268C158S7268C148S7268C12__A1__7S7268C1[] = {
  ABISELECT(7792,5928),
  ABISELECT(6128,4628),
  0,
  (VTBL_ENTRY)&(_ZTI8S7268C10[0]),
  (VTBL_ENTRY)&_ZN8S7268C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7268C10D0Ev,
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
};
extern void _ZN7S7268C5D1Ev();
extern void _ZN7S7268C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C58S7268C108S7268C158S7268C148S7268C12__A4__7S7268C1[] = {
  ABISELECT(6128,4628),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C5[0]),
  (VTBL_ENTRY)&_ZN7S7268C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C5D0Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C11__8S7268C108S7268C158S7268C148S7268C12__A1__7S7268C1[] = {
  0,
  0,
  ABISELECT(-7792,-5928),
  (VTBL_ENTRY)&(_ZTI8S7268C10[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
extern void _ZN7S7268C82v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C8__8S7268C158S7268C148S7268C12__7S7268C1[] = {
  0,
  ABISELECT(-9128,-6888),
  (VTBL_ENTRY)&(_ZTI8S7268C15[0]),
  (VTBL_ENTRY)&_ZN7S7268C82v7Ev,
};
extern void ABISELECT(_ZThn872_N8S7268C15D1Ev,_ZThn664_N8S7268C15D1Ev)();
extern void ABISELECT(_ZThn872_N8S7268C15D0Ev,_ZThn664_N8S7268C15D0Ev)();
extern void _ZN8S7268C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C10__8S7268C158S7268C148S7268C12__7S7268C1[] = {
  ABISELECT(7792,5928),
  ABISELECT(6128,4628),
  ABISELECT(-872,-664),
  (VTBL_ENTRY)&(_ZTI8S7268C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn872_N8S7268C15D1Ev,_ZThn664_N8S7268C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn872_N8S7268C15D0Ev,_ZThn664_N8S7268C15D0Ev),
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C11__8S7268C158S7268C148S7268C12__7S7268C1[] = {
  0,
  0,
  ABISELECT(-8664,-6592),
  (VTBL_ENTRY)&(_ZTI8S7268C15[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
extern void _ZN7S7268C62v2Ev();
extern void _ZN7S7268C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C6__8S7268C148S7268C12__7S7268C1[] = {
  0,
  0,
  ABISELECT(-7704,-5860),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&_ZN7S7268C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7268C62v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S7268C14D1Ev,_ZTv0_n20_N8S7268C14D1Ev)();
extern void ABISELECT(_ZThn8576_N8S7268C14D1Ev,_ZThn6524_N8S7268C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7268C14D0Ev,_ZTv0_n20_N8S7268C14D0Ev)();
extern void ABISELECT(_ZThn8576_N8S7268C14D0Ev,_ZThn6524_N8S7268C14D0Ev)() __attribute__((weak));
extern void _ZN8S7268C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C10__8S7268C148S7268C12__7S7268C1[] = {
  0,
  ABISELECT(-8576,-6524),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-8576,-6524),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7268C14D1Ev,_ZTv0_n20_N8S7268C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7268C14D0Ev,_ZTv0_n20_N8S7268C14D0Ev),
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C11__8S7268C148S7268C12__7S7268C1[] = {
  0,
  0,
  ABISELECT(-9336,-7132),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
extern void _ZN7S7268C62v2Ev();
extern void _ZN7S7268C62v3Ev();
extern void ABISELECT(_ZThn672_N8S7268C14D1Ev,_ZThn540_N8S7268C14D1Ev)();
extern void ABISELECT(_ZThn672_N8S7268C14D0Ev,_ZThn540_N8S7268C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S7268C15__8S7268C148S7268C12__7S7268C1[] = {
  ABISELECT(8664,6592),
  ABISELECT(7000,5292),
  ABISELECT(9128,6888),
  ABISELECT(-672,-540),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&_ZN7S7268C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7268C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S7268C14D1Ev,_ZThn540_N8S7268C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S7268C14D0Ev,_ZThn540_N8S7268C14D0Ev),
};
extern void _ZN7S7268C82v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C8__A1__8S7268C148S7268C12__7S7268C1[] = {
  0,
  ABISELECT(-9800,-7428),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&_ZN7S7268C82v7Ev,
};
extern void ABISELECT(_ZThn1544_N8S7268C14D1Ev,_ZThn1204_N8S7268C14D1Ev)();
extern void ABISELECT(_ZThn1544_N8S7268C14D0Ev,_ZThn1204_N8S7268C14D0Ev)();
extern void _ZN8S7268C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C108S7268C15__A1__8S7268C148S7268C12__7S7268C1[] = {
  ABISELECT(7792,5928),
  ABISELECT(6128,4628),
  ABISELECT(-1544,-1204),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1544_N8S7268C14D1Ev,_ZThn1204_N8S7268C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1544_N8S7268C14D0Ev,_ZThn1204_N8S7268C14D0Ev),
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
};
extern void _ZN7S7268C22v8Ev();
extern void ABISELECT(_ZTv0_n72_N8S7268C14D1Ev,_ZTv0_n36_N8S7268C14D1Ev)();
extern void ABISELECT(_ZThn10112_N8S7268C14D1Ev,_ZThn7680_N8S7268C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S7268C14D0Ev,_ZTv0_n36_N8S7268C14D0Ev)();
extern void ABISELECT(_ZThn10112_N8S7268C14D0Ev,_ZThn7680_N8S7268C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7268C2__8S7268C148S7268C12__7S7268C1[] = {
  ABISELECT(-10112,-7680),
  0,
  ABISELECT(-776,-548),
  ABISELECT(-1536,-1156),
  ABISELECT(-2408,-1820),
  ABISELECT(-2440,-1848),
  ABISELECT(-3104,-2388),
  ABISELECT(-10112,-7680),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&_ZN7S7268C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S7268C14D1Ev,_ZTv0_n36_N8S7268C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S7268C14D0Ev,_ZTv0_n36_N8S7268C14D0Ev),
};
extern void ABISELECT(_ZTv0_n56_N8S7268C14D1Ev,_ZTv0_n28_N8S7268C14D1Ev)();
extern void ABISELECT(_ZThn7008_N8S7268C14D1Ev,_ZThn5292_N8S7268C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7268C14D0Ev,_ZTv0_n28_N8S7268C14D0Ev)();
extern void ABISELECT(_ZThn7008_N8S7268C14D0Ev,_ZThn5292_N8S7268C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7268C3__A1__8S7268C148S7268C12__7S7268C1[] = {
  ABISELECT(152,124),
  ABISELECT(-7008,-5292),
  ABISELECT(2328,1840),
  ABISELECT(1568,1232),
  ABISELECT(696,568),
  ABISELECT(664,540),
  ABISELECT(-7008,-5292),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7268C14D1Ev,_ZTv0_n28_N8S7268C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7268C14D0Ev,_ZTv0_n28_N8S7268C14D0Ev),
};
extern void _ZN7S7268C82v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C87S7268C3__A2__8S7268C148S7268C12__7S7268C1[] = {
  ABISELECT(-7160,-5416),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&_ZN7S7268C82v7Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
extern void _ZN8S7268C132v9Ev();
extern void ABISELECT(_ZTv0_n64_N8S7268C14D1Ev,_ZTv0_n32_N8S7268C14D1Ev)();
extern void ABISELECT(_ZThn9504_N8S7268C14D1Ev,_ZThn7228_N8S7268C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S7268C14D0Ev,_ZTv0_n32_N8S7268C14D0Ev)();
extern void ABISELECT(_ZThn9504_N8S7268C14D0Ev,_ZThn7228_N8S7268C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7268C13__8S7268C148S7268C12__7S7268C1[] = {
  ABISELECT(-9504,-7228),
  0,
  0,
  0,
  ABISELECT(-1832,-1396),
  ABISELECT(176,104),
  ABISELECT(-9504,-7228),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
  (VTBL_ENTRY)&_ZN8S7268C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7268C14D1Ev,_ZTv0_n32_N8S7268C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7268C14D0Ev,_ZTv0_n32_N8S7268C14D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S7268C14D1Ev,_ZTv0_n16_N8S7268C14D1Ev)();
extern void ABISELECT(_ZThn9680_N8S7268C14D1Ev,_ZThn7332_N8S7268C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7268C14D0Ev,_ZTv0_n16_N8S7268C14D0Ev)();
extern void ABISELECT(_ZThn9680_N8S7268C14D0Ev,_ZThn7332_N8S7268C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7268C5__A4__8S7268C148S7268C12__7S7268C1[] = {
  ABISELECT(-9680,-7332),
  ABISELECT(-2008,-1500),
  ABISELECT(-9680,-7332),
  (VTBL_ENTRY)&(_ZTI8S7268C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7268C14D1Ev,_ZTv0_n16_N8S7268C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7268C14D0Ev,_ZTv0_n16_N8S7268C14D0Ev),
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
extern void _ZN8S7268C132v9Ev();
extern void ABISELECT(_ZTv0_n64_N8S7268C12D1Ev,_ZTv0_n32_N8S7268C12D1Ev)();
extern void ABISELECT(_ZThn9504_N8S7268C12D1Ev,_ZThn7228_N8S7268C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S7268C12D0Ev,_ZTv0_n32_N8S7268C12D0Ev)();
extern void ABISELECT(_ZThn9504_N8S7268C12D0Ev,_ZThn7228_N8S7268C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7268C13__8S7268C12__7S7268C1[] = {
  ABISELECT(-9504,-7228),
  0,
  0,
  0,
  ABISELECT(-1832,-1396),
  ABISELECT(176,104),
  ABISELECT(-9504,-7228),
  (VTBL_ENTRY)&(_ZTI8S7268C12[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
  (VTBL_ENTRY)&_ZN8S7268C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7268C12D1Ev,_ZTv0_n32_N8S7268C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7268C12D0Ev,_ZTv0_n32_N8S7268C12D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S7268C12D1Ev,_ZTv0_n16_N8S7268C12D1Ev)();
extern void ABISELECT(_ZThn9680_N8S7268C12D1Ev,_ZThn7332_N8S7268C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7268C12D0Ev,_ZTv0_n16_N8S7268C12D0Ev)();
extern void ABISELECT(_ZThn9680_N8S7268C12D0Ev,_ZThn7332_N8S7268C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7268C5__8S7268C12__7S7268C1[] = {
  ABISELECT(-9680,-7332),
  ABISELECT(-2008,-1500),
  ABISELECT(-9680,-7332),
  (VTBL_ENTRY)&(_ZTI8S7268C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7268C12D1Ev,_ZTv0_n16_N8S7268C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7268C12D0Ev,_ZTv0_n16_N8S7268C12D0Ev),
};
extern void _ZN7S7268C62v2Ev();
extern void _ZN7S7268C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C6__8S7268C12__7S7268C1[] = {
  0,
  0,
  ABISELECT(-7704,-5860),
  (VTBL_ENTRY)&(_ZTI8S7268C12[0]),
  (VTBL_ENTRY)&_ZN7S7268C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7268C62v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S7268C12D1Ev,_ZTv0_n20_N8S7268C12D1Ev)();
extern void ABISELECT(_ZThn8576_N8S7268C12D1Ev,_ZThn6524_N8S7268C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7268C12D0Ev,_ZTv0_n20_N8S7268C12D0Ev)();
extern void ABISELECT(_ZThn8576_N8S7268C12D0Ev,_ZThn6524_N8S7268C12D0Ev)() __attribute__((weak));
extern void _ZN8S7268C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C10__8S7268C12__7S7268C1[] = {
  0,
  ABISELECT(-8576,-6524),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-8576,-6524),
  (VTBL_ENTRY)&(_ZTI8S7268C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7268C12D1Ev,_ZTv0_n20_N8S7268C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7268C12D0Ev,_ZTv0_n20_N8S7268C12D0Ev),
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C11__A1__8S7268C12__7S7268C1[] = {
  0,
  0,
  ABISELECT(-9336,-7132),
  (VTBL_ENTRY)&(_ZTI8S7268C12[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
extern void _ZN7S7268C62v2Ev();
extern void _ZN7S7268C62v3Ev();
extern void ABISELECT(_ZThn672_N8S7268C12D1Ev,_ZThn540_N8S7268C12D1Ev)();
extern void ABISELECT(_ZThn672_N8S7268C12D0Ev,_ZThn540_N8S7268C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S7268C158S7268C14__8S7268C12__7S7268C1[] = {
  ABISELECT(8664,6592),
  ABISELECT(7000,5292),
  ABISELECT(9128,6888),
  ABISELECT(-672,-540),
  (VTBL_ENTRY)&(_ZTI8S7268C12[0]),
  (VTBL_ENTRY)&_ZN7S7268C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7268C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S7268C12D1Ev,_ZThn540_N8S7268C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S7268C12D0Ev,_ZThn540_N8S7268C12D0Ev),
};
extern void _ZN7S7268C82v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C8__A1__8S7268C12__7S7268C1[] = {
  0,
  ABISELECT(-9800,-7428),
  (VTBL_ENTRY)&(_ZTI8S7268C12[0]),
  (VTBL_ENTRY)&_ZN7S7268C82v7Ev,
};
extern void ABISELECT(_ZThn1544_N8S7268C12D1Ev,_ZThn1204_N8S7268C12D1Ev)();
extern void ABISELECT(_ZThn1544_N8S7268C12D0Ev,_ZThn1204_N8S7268C12D0Ev)();
extern void _ZN8S7268C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C108S7268C158S7268C14__A1__8S7268C12__7S7268C1[] = {
  ABISELECT(7792,5928),
  ABISELECT(6128,4628),
  ABISELECT(-1544,-1204),
  (VTBL_ENTRY)&(_ZTI8S7268C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1544_N8S7268C12D1Ev,_ZThn1204_N8S7268C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1544_N8S7268C12D0Ev,_ZThn1204_N8S7268C12D0Ev),
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
};
extern void _ZN7S7268C22v8Ev();
extern void ABISELECT(_ZTv0_n72_N8S7268C12D1Ev,_ZTv0_n36_N8S7268C12D1Ev)();
extern void ABISELECT(_ZThn10112_N8S7268C12D1Ev,_ZThn7680_N8S7268C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S7268C12D0Ev,_ZTv0_n36_N8S7268C12D0Ev)();
extern void ABISELECT(_ZThn10112_N8S7268C12D0Ev,_ZThn7680_N8S7268C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7268C2__8S7268C12__7S7268C1[] = {
  ABISELECT(-10112,-7680),
  0,
  ABISELECT(-776,-548),
  ABISELECT(-1536,-1156),
  ABISELECT(-2408,-1820),
  ABISELECT(-2440,-1848),
  ABISELECT(-3104,-2388),
  ABISELECT(-10112,-7680),
  (VTBL_ENTRY)&(_ZTI8S7268C12[0]),
  (VTBL_ENTRY)&_ZN7S7268C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S7268C12D1Ev,_ZTv0_n36_N8S7268C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S7268C12D0Ev,_ZTv0_n36_N8S7268C12D0Ev),
};
extern void ABISELECT(_ZTv0_n56_N8S7268C12D1Ev,_ZTv0_n28_N8S7268C12D1Ev)();
extern void ABISELECT(_ZThn7008_N8S7268C12D1Ev,_ZThn5292_N8S7268C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7268C12D0Ev,_ZTv0_n28_N8S7268C12D0Ev)();
extern void ABISELECT(_ZThn7008_N8S7268C12D0Ev,_ZThn5292_N8S7268C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7268C3__A1__8S7268C12__7S7268C1[] = {
  ABISELECT(152,124),
  ABISELECT(-7008,-5292),
  ABISELECT(2328,1840),
  ABISELECT(1568,1232),
  ABISELECT(696,568),
  ABISELECT(664,540),
  ABISELECT(-7008,-5292),
  (VTBL_ENTRY)&(_ZTI8S7268C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7268C12D1Ev,_ZTv0_n28_N8S7268C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7268C12D0Ev,_ZTv0_n28_N8S7268C12D0Ev),
};
extern void _ZN7S7268C82v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C87S7268C3__A2__8S7268C12__7S7268C1[] = {
  ABISELECT(-7160,-5416),
  (VTBL_ENTRY)&(_ZTI8S7268C12[0]),
  (VTBL_ENTRY)&_ZN7S7268C82v7Ev,
};
extern void _ZN7S7268C3D1Ev();
extern void _ZN7S7268C3D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C3__7S7268C1[] = {
  ABISELECT(2328,1840),
  ABISELECT(1568,1232),
  ABISELECT(696,568),
  ABISELECT(664,540),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&_ZN7S7268C3D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C3D0Ev,
};
extern void _ZN7S7268C5D1Ev();
extern void _ZN7S7268C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C57S7268C3__7S7268C1[] = {
  ABISELECT(664,540),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C5[0]),
  (VTBL_ENTRY)&_ZN7S7268C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C5D0Ev,
};
extern void _ZN7S7268C62v2Ev();
extern void _ZN7S7268C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C6__7S7268C3__7S7268C1[] = {
  0,
  0,
  ABISELECT(-696,-568),
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&_ZN7S7268C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7268C62v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S7268C3D1Ev,_ZTv0_n20_N7S7268C3D1Ev)();
extern void ABISELECT(_ZThn1568_N7S7268C3D1Ev,_ZThn1232_N7S7268C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S7268C3D0Ev,_ZTv0_n20_N7S7268C3D0Ev)();
extern void ABISELECT(_ZThn1568_N7S7268C3D0Ev,_ZThn1232_N7S7268C3D0Ev)() __attribute__((weak));
extern void _ZN8S7268C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C10__7S7268C3__7S7268C1[] = {
  0,
  ABISELECT(-1568,-1232),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-1568,-1232),
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7268C3D1Ev,_ZTv0_n20_N7S7268C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7268C3D0Ev,_ZTv0_n20_N7S7268C3D0Ev),
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C11__7S7268C3__7S7268C1[] = {
  0,
  0,
  ABISELECT(-2328,-1840),
  (VTBL_ENTRY)&(_ZTI7S7268C3[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
extern void _ZN8S7268C10D1Ev();
extern void _ZN8S7268C10D0Ev();
extern void _ZN8S7268C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C10__7S7268C1[] = {
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  0,
  (VTBL_ENTRY)&(_ZTI8S7268C10[0]),
  (VTBL_ENTRY)&_ZN8S7268C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7268C10D0Ev,
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
};
extern void _ZN7S7268C5D1Ev();
extern void _ZN7S7268C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C58S7268C10__A1__7S7268C1[] = {
  ABISELECT(-904,-692),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C5[0]),
  (VTBL_ENTRY)&_ZN7S7268C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C5D0Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C11__8S7268C10__7S7268C1[] = {
  0,
  0,
  ABISELECT(-760,-608),
  (VTBL_ENTRY)&(_ZTI8S7268C10[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
extern void _ZN8S7268C132v9Ev();
extern void _ZN8S7268C13D1Ev();
extern void _ZN8S7268C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C13__7S7268C1[] = {
  ABISELECT(-1832,-1396),
  ABISELECT(176,104),
  0,
  (VTBL_ENTRY)&(_ZTI8S7268C13[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
  (VTBL_ENTRY)&_ZN8S7268C132v9Ev,
  (VTBL_ENTRY)&_ZN8S7268C13D1Ev,
  (VTBL_ENTRY)&_ZN8S7268C13D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S7268C13D1Ev,_ZTv0_n16_N8S7268C13D1Ev)();
extern void ABISELECT(_ZThn176_N8S7268C13D1Ev,_ZThn104_N8S7268C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7268C13D0Ev,_ZTv0_n16_N8S7268C13D0Ev)();
extern void ABISELECT(_ZThn176_N8S7268C13D0Ev,_ZThn104_N8S7268C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7268C5__8S7268C13__7S7268C1[] = {
  ABISELECT(-176,-104),
  ABISELECT(-2008,-1500),
  ABISELECT(-176,-104),
  (VTBL_ENTRY)&(_ZTI8S7268C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7268C13D1Ev,_ZTv0_n16_N8S7268C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7268C13D0Ev,_ZTv0_n16_N8S7268C13D0Ev),
};
extern void _ZN7S7268C5D1Ev();
extern void _ZN7S7268C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C5__A2__7S7268C1[] = {
  ABISELECT(-2008,-1500),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C5[0]),
  (VTBL_ENTRY)&_ZN7S7268C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C5D0Ev,
};
extern void _ZN7S7268C22v8Ev();
extern void _ZN7S7268C2D1Ev();
extern void _ZN7S7268C2D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C2__A1__7S7268C1[] = {
  ABISELECT(-776,-548),
  ABISELECT(-1536,-1156),
  ABISELECT(-2408,-1820),
  ABISELECT(-2440,-1848),
  ABISELECT(-3104,-2388),
  0,
  (VTBL_ENTRY)&(_ZTI7S7268C2[0]),
  (VTBL_ENTRY)&_ZN7S7268C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7268C2D1Ev,
  (VTBL_ENTRY)&_ZN7S7268C2D0Ev,
};
extern void ABISELECT(_ZTv0_n56_N7S7268C2D1Ev,_ZTv0_n28_N7S7268C2D1Ev)();
extern void ABISELECT(_ZTv0_n56_N7S7268C2D0Ev,_ZTv0_n28_N7S7268C2D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S7268C3__7S7268C2__A1__7S7268C1[] = {
  ABISELECT(152,124),
  ABISELECT(3104,2388),
  ABISELECT(2328,1840),
  ABISELECT(1568,1232),
  ABISELECT(696,568),
  ABISELECT(664,540),
  ABISELECT(3104,2388),
  (VTBL_ENTRY)&(_ZTI7S7268C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7268C2D1Ev,_ZTv0_n28_N7S7268C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7268C2D0Ev,_ZTv0_n28_N7S7268C2D0Ev),
};
extern void _ZN7S7268C62v2Ev();
extern void _ZN7S7268C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C6__7S7268C2__A1__7S7268C1[] = {
  0,
  0,
  ABISELECT(2408,1820),
  (VTBL_ENTRY)&(_ZTI7S7268C2[0]),
  (VTBL_ENTRY)&_ZN7S7268C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7268C62v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S7268C2D1Ev,_ZTv0_n20_N7S7268C2D1Ev)();
extern void ABISELECT(_ZTv0_n40_N7S7268C2D0Ev,_ZTv0_n20_N7S7268C2D0Ev)();
extern void _ZN8S7268C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C10__7S7268C2__A1__7S7268C1[] = {
  0,
  ABISELECT(1536,1156),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(1536,1156),
  (VTBL_ENTRY)&(_ZTI7S7268C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7268C2D1Ev,_ZTv0_n20_N7S7268C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7268C2D0Ev,_ZTv0_n20_N7S7268C2D0Ev),
  (VTBL_ENTRY)&_ZN8S7268C102v6Ev,
};
extern void _ZN8S7268C112v4Ev();
extern void _ZN8S7268C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7268C11__7S7268C2__A1__7S7268C1[] = {
  0,
  0,
  ABISELECT(776,548),
  (VTBL_ENTRY)&(_ZTI7S7268C2[0]),
  (VTBL_ENTRY)&_ZN8S7268C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7268C112v5Ev,
};
extern void _ZN7S7268C82v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7268C87S7268C3__7S7268C2__A1__7S7268C1[] = {
  ABISELECT(2952,2264),
  (VTBL_ENTRY)&(_ZTI7S7268C2[0]),
  (VTBL_ENTRY)&_ZN7S7268C82v7Ev,
};
static  VTT_ENTRY vtt_S7268C1[] = {
  {&(_ZTV7S7268C1[11]),  11,121},
  {&(_tg__ZTV7S7268C2__A__7S7268C1[7]),  7,10},
  {&(_tg__ZTV7S7268C3__7S7268C2__A__7S7268C1[8]),  8,10},
  {&(_tg__ZTV7S7268C6__7S7268C2__A__7S7268C1[4]),  4,6},
  {&(_tg__ZTV8S7268C10__7S7268C2__A__7S7268C1[6]),  6,9},
  {&(_tg__ZTV8S7268C11__7S7268C2__A__7S7268C1[4]),  4,6},
  {&(_tg__ZTV7S7268C87S7268C3__7S7268C2__A__7S7268C1[2]),  2,3},
  {&(_tg__ZTV8S7268C12__7S7268C1[11]),  11,14},
  {&(_tg__ZTV8S7268C148S7268C12__7S7268C1[11]),  11,14},
  {&(_tg__ZTV7S7268C38S7268C148S7268C12__A1__7S7268C1[6]),  6,8},
  {&(_tg__ZTV7S7268C57S7268C38S7268C148S7268C12__A3__7S7268C1[3]),  3,5},
  {&(_tg__ZTV7S7268C6__7S7268C38S7268C148S7268C12__A1__7S7268C1[4]),  4,6},
  {&(_tg__ZTV8S7268C10__7S7268C38S7268C148S7268C12__A1__7S7268C1[6]),  6,9},
  {&(_tg__ZTV8S7268C11__7S7268C38S7268C148S7268C12__A1__7S7268C1[4]),  4,6},
  {&(_tg__ZTV8S7268C158S7268C148S7268C12__7S7268C1[5]),  5,9},
  {&(_tg__ZTV8S7268C108S7268C158S7268C148S7268C12__A1__7S7268C1[4]),  4,7},
  {&(_tg__ZTV7S7268C58S7268C108S7268C158S7268C148S7268C12__A4__7S7268C1[3]),  3,5},
  {&(_tg__ZTV8S7268C11__8S7268C108S7268C158S7268C148S7268C12__A1__7S7268C1[4]),  4,6},
  {&(_tg__ZTV7S7268C8__8S7268C158S7268C148S7268C12__7S7268C1[3]),  3,4},
  {&(_tg__ZTV8S7268C10__8S7268C158S7268C148S7268C12__7S7268C1[4]),  4,7},
  {&(_tg__ZTV8S7268C11__8S7268C158S7268C148S7268C12__7S7268C1[4]),  4,6},
  {&(_tg__ZTV7S7268C6__8S7268C148S7268C12__7S7268C1[4]),  4,6},
  {&(_tg__ZTV8S7268C10__8S7268C148S7268C12__7S7268C1[6]),  6,9},
  {&(_tg__ZTV8S7268C11__8S7268C148S7268C12__7S7268C1[4]),  4,6},
  {&(_tg__ZTV8S7268C15__8S7268C148S7268C12__7S7268C1[5]),  5,9},
  {&(_tg__ZTV7S7268C8__A1__8S7268C148S7268C12__7S7268C1[3]),  3,4},
  {&(_tg__ZTV8S7268C108S7268C15__A1__8S7268C148S7268C12__7S7268C1[4]),  4,7},
  {&(_tg__ZTV7S7268C2__8S7268C148S7268C12__7S7268C1[9]),  9,12},
  {&(_tg__ZTV7S7268C3__A1__8S7268C148S7268C12__7S7268C1[8]),  8,10},
  {&(_tg__ZTV7S7268C87S7268C3__A2__8S7268C148S7268C12__7S7268C1[2]),  2,3},
  {&(_tg__ZTV8S7268C13__8S7268C148S7268C12__7S7268C1[8]),  8,13},
  {&(_tg__ZTV7S7268C5__A4__8S7268C148S7268C12__7S7268C1[4]),  4,6},
  {&(_tg__ZTV8S7268C13__8S7268C12__7S7268C1[8]),  8,13},
  {&(_tg__ZTV7S7268C5__8S7268C12__7S7268C1[4]),  4,6},
  {&(_tg__ZTV7S7268C6__8S7268C12__7S7268C1[4]),  4,6},
  {&(_tg__ZTV8S7268C10__8S7268C12__7S7268C1[6]),  6,9},
  {&(_tg__ZTV8S7268C11__A1__8S7268C12__7S7268C1[4]),  4,6},
  {&(_tg__ZTV8S7268C158S7268C14__8S7268C12__7S7268C1[5]),  5,9},
  {&(_tg__ZTV7S7268C8__A1__8S7268C12__7S7268C1[3]),  3,4},
  {&(_tg__ZTV8S7268C108S7268C158S7268C14__A1__8S7268C12__7S7268C1[4]),  4,7},
  {&(_tg__ZTV7S7268C2__8S7268C12__7S7268C1[9]),  9,12},
  {&(_tg__ZTV7S7268C3__A1__8S7268C12__7S7268C1[8]),  8,10},
  {&(_tg__ZTV7S7268C87S7268C3__A2__8S7268C12__7S7268C1[2]),  2,3},
  {&(_ZTV7S7268C1[60]),  60,121},
  {&(_ZTV7S7268C1[69]),  69,121},
  {&(_ZTV7S7268C1[77]),  77,121},
  {&(_ZTV7S7268C1[84]),  84,121},
  {&(_ZTV7S7268C1[64]),  64,121},
  {&(_ZTV7S7268C1[26]),  26,121},
  {&(_ZTV7S7268C1[94]),  94,121},
  {&(_ZTV7S7268C1[103]),  103,121},
  {&(_ZTV7S7268C1[37]),  37,121},
  {&(_ZTV7S7268C1[108]),  108,121},
  {&(_ZTV7S7268C1[45]),  45,121},
  {&(_ZTV7S7268C1[118]),  118,121},
  {&(_tg__ZTV7S7268C3__7S7268C1[6]),  6,8},
  {&(_tg__ZTV7S7268C57S7268C3__7S7268C1[3]),  3,5},
  {&(_tg__ZTV7S7268C6__7S7268C3__7S7268C1[4]),  4,6},
  {&(_tg__ZTV8S7268C10__7S7268C3__7S7268C1[6]),  6,9},
  {&(_tg__ZTV8S7268C11__7S7268C3__7S7268C1[4]),  4,6},
  {&(_tg__ZTV8S7268C10__7S7268C1[4]),  4,7},
  {&(_tg__ZTV7S7268C58S7268C10__A1__7S7268C1[3]),  3,5},
  {&(_tg__ZTV8S7268C11__8S7268C10__7S7268C1[4]),  4,6},
  {&(_tg__ZTV8S7268C13__7S7268C1[4]),  4,9},
  {&(_tg__ZTV7S7268C5__8S7268C13__7S7268C1[4]),  4,6},
  {&(_tg__ZTV7S7268C5__A2__7S7268C1[3]),  3,5},
  {&(_tg__ZTV7S7268C2__A1__7S7268C1[7]),  7,10},
  {&(_tg__ZTV7S7268C3__7S7268C2__A1__7S7268C1[8]),  8,10},
  {&(_tg__ZTV7S7268C6__7S7268C2__A1__7S7268C1[4]),  4,6},
  {&(_tg__ZTV8S7268C10__7S7268C2__A1__7S7268C1[6]),  6,9},
  {&(_tg__ZTV8S7268C11__7S7268C2__A1__7S7268C1[4]),  4,6},
  {&(_tg__ZTV7S7268C87S7268C3__7S7268C2__A1__7S7268C1[2]),  2,3},
};
extern VTBL_ENTRY _ZTI7S7268C1[];
extern  VTBL_ENTRY _ZTV7S7268C1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7268C1[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7268C13D0Ev,_ZTv0_n16_N8S7268C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7268C13D0Ev,_ZThn104_N8S7268C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7268C13D1Ev,_ZTv0_n16_N8S7268C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7268C13D1Ev,_ZThn104_N8S7268C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7268C12D0Ev,_ZTv0_n28_N8S7268C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7008_N8S7268C12D0Ev,_ZThn5292_N8S7268C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7268C12D1Ev,_ZTv0_n28_N8S7268C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7008_N8S7268C12D1Ev,_ZThn5292_N8S7268C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S7268C12D0Ev,_ZTv0_n36_N8S7268C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10112_N8S7268C12D0Ev,_ZThn7680_N8S7268C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S7268C12D1Ev,_ZTv0_n36_N8S7268C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10112_N8S7268C12D1Ev,_ZThn7680_N8S7268C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7268C12D0Ev,_ZTv0_n20_N8S7268C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8576_N8S7268C12D0Ev,_ZThn6524_N8S7268C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7268C12D1Ev,_ZTv0_n20_N8S7268C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8576_N8S7268C12D1Ev,_ZThn6524_N8S7268C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7268C12D0Ev,_ZTv0_n16_N8S7268C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9680_N8S7268C12D0Ev,_ZThn7332_N8S7268C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7268C12D1Ev,_ZTv0_n16_N8S7268C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9680_N8S7268C12D1Ev,_ZThn7332_N8S7268C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S7268C12D0Ev,_ZTv0_n32_N8S7268C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9504_N8S7268C12D0Ev,_ZThn7228_N8S7268C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S7268C12D1Ev,_ZTv0_n32_N8S7268C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9504_N8S7268C12D1Ev,_ZThn7228_N8S7268C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7268C14D0Ev,_ZTv0_n16_N8S7268C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9680_N8S7268C14D0Ev,_ZThn7332_N8S7268C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7268C14D1Ev,_ZTv0_n16_N8S7268C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9680_N8S7268C14D1Ev,_ZThn7332_N8S7268C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S7268C14D0Ev,_ZTv0_n32_N8S7268C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9504_N8S7268C14D0Ev,_ZThn7228_N8S7268C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S7268C14D1Ev,_ZTv0_n32_N8S7268C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9504_N8S7268C14D1Ev,_ZThn7228_N8S7268C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7268C14D0Ev,_ZTv0_n28_N8S7268C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7008_N8S7268C14D0Ev,_ZThn5292_N8S7268C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7268C14D1Ev,_ZTv0_n28_N8S7268C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7008_N8S7268C14D1Ev,_ZThn5292_N8S7268C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S7268C14D0Ev,_ZTv0_n36_N8S7268C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10112_N8S7268C14D0Ev,_ZThn7680_N8S7268C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S7268C14D1Ev,_ZTv0_n36_N8S7268C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10112_N8S7268C14D1Ev,_ZThn7680_N8S7268C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7268C14D0Ev,_ZTv0_n20_N8S7268C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8576_N8S7268C14D0Ev,_ZThn6524_N8S7268C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7268C14D1Ev,_ZTv0_n20_N8S7268C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8576_N8S7268C14D1Ev,_ZThn6524_N8S7268C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7268C3D0Ev,_ZTv0_n20_N7S7268C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1568_N7S7268C3D0Ev,_ZThn1232_N7S7268C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn8576_N7S7268C3D0Ev,_ZThn6524_N7S7268C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7268C3D1Ev,_ZTv0_n20_N7S7268C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1568_N7S7268C3D1Ev,_ZThn1232_N7S7268C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn8576_N7S7268C3D1Ev,_ZThn6524_N7S7268C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7268C2D0Ev,_ZTv0_n20_N7S7268C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn43408_N7S7268C2D0Ev,_ZThn33484_N7S7268C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7268C2D1Ev,_ZTv0_n20_N7S7268C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn43408_N7S7268C2D1Ev,_ZThn33484_N7S7268C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7268C2D0Ev,_ZTv0_n28_N7S7268C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn41840_N7S7268C2D0Ev,_ZThn32252_N7S7268C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7268C2D1Ev,_ZTv0_n28_N7S7268C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn41840_N7S7268C2D1Ev,_ZThn32252_N7S7268C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N7S7268C1D0Ev,_ZTv0_n36_N7S7268C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn44944_N7S7268C1D0Ev,_ZThn34640_N7S7268C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N7S7268C1D1Ev,_ZTv0_n36_N7S7268C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn44944_N7S7268C1D1Ev,_ZThn34640_N7S7268C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S7268C1D0Ev,_ZTv0_n16_N7S7268C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn44512_N7S7268C1D0Ev,_ZThn34292_N7S7268C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S7268C1D1Ev,_ZTv0_n16_N7S7268C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn44512_N7S7268C1D1Ev,_ZThn34292_N7S7268C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S7268C1D0Ev,_ZTv0_n32_N7S7268C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn44336_N7S7268C1D0Ev,_ZThn34188_N7S7268C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S7268C1D1Ev,_ZTv0_n32_N7S7268C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn44336_N7S7268C1D1Ev,_ZThn34188_N7S7268C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7268C1D0Ev,_ZTv0_n20_N7S7268C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn43408_N7S7268C1D0Ev,_ZThn33484_N7S7268C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7268C1D1Ev,_ZTv0_n20_N7S7268C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn43408_N7S7268C1D1Ev,_ZThn33484_N7S7268C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7268C1D0Ev,_ZTv0_n28_N7S7268C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn41840_N7S7268C1D0Ev,_ZThn32252_N7S7268C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7268C1D1Ev,_ZTv0_n28_N7S7268C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn41840_N7S7268C1D1Ev,_ZThn32252_N7S7268C1D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7268C1 = {  "S7268C1", // class name
  bases_S7268C1, 27,
  &(vtc_S7268C1[0]), // expected_vtbl_contents
  &(vtt_S7268C1[0]), // expected_vtt_contents
  ABISELECT(79776,61600), // object size
  NSPAIRA(_ZTI7S7268C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S7268C1),121, //virtual function table var
  11, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7268C1),72, //virtual table table var
  23, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7267C5  : virtual S7268C4 {
  ::S7268C4 s7267c5f0;
  int s7267c5f1;
  void *s7267c5f2;
  ::S7268C4 s7267c5f3[2];
  virtual  ~S7267C5(); // _ZN7S7267C5D2Ev
  S7267C5(); // tgen
};
//SIG(-1 S7267C5) C1{ VBC2{ m Fs[6] FL Fc[5]} vd FC2 Fi Fp FC2[2]}


 S7267C5 ::~S7267C5(){ note_dtor("S7267C5", this);}
S7267C5 ::S7267C5(){ note_ctor("S7267C5", this);} // tgen

static void Test_S7267C5()
{
  extern Class_Descriptor cd_S7267C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(20,32)];
    init_test(&cd_S7267C5, buf);
    S7267C5 *dp, &lv = *(dp=new (buf) S7267C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(152,124), "sizeof(S7267C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7267C5)");
    check_base_class_offset(lv, (S7268C4*), ABISELECT(120,96), "S7267C5");
    check_field_offset(lv, s7267c5f0, ABISELECT(8,4), "S7267C5.s7267c5f0");
    check_field_offset(lv, s7267c5f1, ABISELECT(40,32), "S7267C5.s7267c5f1");
    check_field_offset(lv, s7267c5f2, ABISELECT(48,36), "S7267C5.s7267c5f2");
    check_field_offset(lv, s7267c5f3, ABISELECT(56,40), "S7267C5.s7267c5f3");
    test_class_info(&lv, &cd_S7267C5);
    dp->~S7267C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7267C5(Test_S7267C5, "S7267C5", ABISELECT(152,124));

#else // __cplusplus

extern void _ZN7S7267C5C1Ev();
extern void _ZN7S7267C5D2Ev();
Name_Map name_map_S7267C5[] = {
  NSPAIR(_ZN7S7267C5C1Ev),
  NSPAIR(_ZN7S7267C5D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
static Base_Class bases_S7267C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7268C4,    ABISELECT(120,96), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S7267C5[];
extern void _ZN7S7267C5D1Ev();
extern void _ZN7S7267C5D0Ev();
static  VTBL_ENTRY vtc_S7267C5[] = {
  ABISELECT(120,96),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C5[0]),
  (VTBL_ENTRY)&_ZN7S7267C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C5D0Ev,
};
extern VTBL_ENTRY _ZTV7S7267C5[];
static  VTT_ENTRY vtt_S7267C5[] = {
  {&(_ZTV7S7267C5[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7S7267C5[];
extern  VTBL_ENTRY _ZTV7S7267C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C5[];
Class_Descriptor cd_S7267C5 = {  "S7267C5", // class name
  bases_S7267C5, 1,
  &(vtc_S7267C5[0]), // expected_vtbl_contents
  &(vtt_S7267C5[0]), // expected_vtt_contents
  ABISELECT(152,124), // object size
  NSPAIRA(_ZTI7S7267C5),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7S7267C5),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7267C5),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7267C6  {
  ::S7268C4 s7267c6f0;
  char s7267c6f1;
  ::S7268C7 s7267c6f2;
  void *s7267c6f3;
  int s7267c6f4;
  int s7267c6f5;
  void *s7267c6f6;
  int s7267c6f7;
  int s7267c6f8:11;
  int s7267c6f9;
  virtual void  v2(); // _ZN7S7267C62v2Ev
  virtual void  v3(); // _ZN7S7267C62v3Ev
  ~S7267C6(); // tgen
  S7267C6(); // tgen
};
//SIG(-1 S7267C6) C1{ v1 v2 FC2{ m Fs[6] FL Fc[5]} Fc FC3{ BC4{ v3 FU5{ m Fl Fp[4] Fi} Fp FC2[8] Fp} VBC2 BC6{ VBC2 vd FC2 Fi Fp FC2[2]} Fp[5] Fc:0 Fi Fi Fi:10 Fc[8] Fs Fi Fp[10] FC6 FL Fi Fp} Fp Fi Fi Fp Fi Fi:11 Fi}


void  S7267C6 ::v2(){vfunc_called(this, "_ZN7S7267C62v2Ev");}
void  S7267C6 ::v3(){vfunc_called(this, "_ZN7S7267C62v3Ev");}
S7267C6 ::~S7267C6(){ note_dtor("S7267C6", this);} // tgen
S7267C6 ::S7267C6(){ note_ctor("S7267C6", this);} // tgen

static void Test_S7267C6()
{
  extern Class_Descriptor cd_S7267C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(110,167)];
    init_test(&cd_S7267C6, buf);
    S7267C6 *dp, &lv = *(dp=new (buf) S7267C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(872,664), "sizeof(S7267C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7267C6)");
    check_field_offset(lv, s7267c6f0, ABISELECT(8,4), "S7267C6.s7267c6f0");
    check_field_offset(lv, s7267c6f1, ABISELECT(40,32), "S7267C6.s7267c6f1");
    check_field_offset(lv, s7267c6f2, ABISELECT(48,36), "S7267C6.s7267c6f2");
    check_field_offset(lv, s7267c6f3, ABISELECT(832,636), "S7267C6.s7267c6f3");
    check_field_offset(lv, s7267c6f4, ABISELECT(840,640), "S7267C6.s7267c6f4");
    check_field_offset(lv, s7267c6f5, ABISELECT(844,644), "S7267C6.s7267c6f5");
    check_field_offset(lv, s7267c6f6, ABISELECT(848,648), "S7267C6.s7267c6f6");
    check_field_offset(lv, s7267c6f7, ABISELECT(856,652), "S7267C6.s7267c6f7");
    set_bf_and_test(lv, s7267c6f8, ABISELECT(860,656), 0, 11, 1, "S7267C6");
    set_bf_and_test(lv, s7267c6f8, ABISELECT(860,656), 0, 11, hide_sll(1LL<<10), "S7267C6");
    check_field_offset(lv, s7267c6f9, ABISELECT(864,660), "S7267C6.s7267c6f9");
    test_class_info(&lv, &cd_S7267C6);
    dp->~S7267C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7267C6(Test_S7267C6, "S7267C6", ABISELECT(872,664));

#else // __cplusplus

extern void _ZN7S7267C6C1Ev();
extern void _ZN7S7267C6D1Ev();
Name_Map name_map_S7267C6[] = {
  NSPAIR(_ZN7S7267C6C1Ev),
  NSPAIR(_ZN7S7267C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S7267C6[];
extern void _ZN7S7267C62v2Ev();
extern void _ZN7S7267C62v3Ev();
static  VTBL_ENTRY vtc_S7267C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C6[0]),
  (VTBL_ENTRY)&_ZN7S7267C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7267C62v3Ev,
};
extern VTBL_ENTRY _ZTI7S7267C6[];
extern  VTBL_ENTRY _ZTV7S7267C6[];
Class_Descriptor cd_S7267C6 = {  "S7267C6", // class name
  0,0,//no base classes
  &(vtc_S7267C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(872,664), // object size
  NSPAIRA(_ZTI7S7267C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S7267C6),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7267C11  {
  int s7267c11f0;
  void *s7267c11f1;
  void *s7267c11f2;
  long s7267c11f3;
  void *s7267c11f4[2];
  void *s7267c11f5;
  long s7267c11f6[6];
  ::S7268C4 s7267c11f7;
  int s7267c11f8;
  void *s7267c11f9;
  char s7267c11f10[2];
  virtual void  v4(); // _ZN8S7267C112v4Ev
  virtual void  v5(); // _ZN8S7267C112v5Ev
  ~S7267C11(); // tgen
  S7267C11(); // tgen
};
//SIG(-1 S7267C11) C1{ v1 v2 Fi Fp[2] Fl Fp[3] Fl[6] FC2{ m Fs[6] FL Fc[5]} Fi Fp Fc[2]}


void  S7267C11 ::v4(){vfunc_called(this, "_ZN8S7267C112v4Ev");}
void  S7267C11 ::v5(){vfunc_called(this, "_ZN8S7267C112v5Ev");}
S7267C11 ::~S7267C11(){ note_dtor("S7267C11", this);} // tgen
S7267C11 ::S7267C11(){ note_ctor("S7267C11", this);} // tgen

static void Test_S7267C11()
{
  extern Class_Descriptor cd_S7267C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(22,25)];
    init_test(&cd_S7267C11, buf);
    S7267C11 *dp, &lv = *(dp=new (buf) S7267C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(168,96), "sizeof(S7267C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7267C11)");
    check_field_offset(lv, s7267c11f0, ABISELECT(8,4), "S7267C11.s7267c11f0");
    check_field_offset(lv, s7267c11f1, ABISELECT(16,8), "S7267C11.s7267c11f1");
    check_field_offset(lv, s7267c11f2, ABISELECT(24,12), "S7267C11.s7267c11f2");
    check_field_offset(lv, s7267c11f3, ABISELECT(32,16), "S7267C11.s7267c11f3");
    check_field_offset(lv, s7267c11f4, ABISELECT(40,20), "S7267C11.s7267c11f4");
    check_field_offset(lv, s7267c11f5, ABISELECT(56,28), "S7267C11.s7267c11f5");
    check_field_offset(lv, s7267c11f6, ABISELECT(64,32), "S7267C11.s7267c11f6");
    check_field_offset(lv, s7267c11f7, ABISELECT(112,56), "S7267C11.s7267c11f7");
    check_field_offset(lv, s7267c11f8, ABISELECT(144,84), "S7267C11.s7267c11f8");
    check_field_offset(lv, s7267c11f9, ABISELECT(152,88), "S7267C11.s7267c11f9");
    check_field_offset(lv, s7267c11f10, ABISELECT(160,92), "S7267C11.s7267c11f10");
    test_class_info(&lv, &cd_S7267C11);
    dp->~S7267C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7267C11(Test_S7267C11, "S7267C11", ABISELECT(168,96));

#else // __cplusplus

extern void _ZN8S7267C11C1Ev();
extern void _ZN8S7267C11D1Ev();
Name_Map name_map_S7267C11[] = {
  NSPAIR(_ZN8S7267C11C1Ev),
  NSPAIR(_ZN8S7267C11D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S7267C11[];
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
static  VTBL_ENTRY vtc_S7267C11[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7267C11[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
};
extern VTBL_ENTRY _ZTI8S7267C11[];
extern  VTBL_ENTRY _ZTV8S7267C11[];
Class_Descriptor cd_S7267C11 = {  "S7267C11", // class name
  0,0,//no base classes
  &(vtc_S7267C11[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(168,96), // object size
  NSPAIRA(_ZTI8S7267C11),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S7267C11),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7267C10  : S7267C5 , virtual S7267C11 {
  long s7267c10f0[4];
  ::S7267C5 s7267c10f1[4];
  virtual  ~S7267C10(); // _ZN8S7267C10D2Ev
  virtual void  v6(); // _ZN8S7267C102v6Ev
  S7267C10(); // tgen
};
//SIG(-1 S7267C10) C1{ BC2{ VBC3{ m Fs[6] FL Fc[5]} vd FC3 Fi Fp FC3[2]} VBC4{ v2 v3 Fi Fp[2] Fl Fp[3] Fl[6] FC3 Fi Fp Fc[2]} vd v1 Fl[4] FC2[4]}


 S7267C10 ::~S7267C10(){ note_dtor("S7267C10", this);}
void  S7267C10 ::v6(){vfunc_called(this, "_ZN8S7267C102v6Ev");}
S7267C10 ::S7267C10(){ note_ctor("S7267C10", this);} // tgen

static void Test_S7267C10()
{
  extern Class_Descriptor cd_S7267C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(121,184)];
    init_test(&cd_S7267C10, buf);
    S7267C10 *dp, &lv = *(dp=new (buf) S7267C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(960,732), "sizeof(S7267C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7267C10)");
    check_base_class_offset(lv, (S7268C4*)(S7267C5*), ABISELECT(760,608), "S7267C10");
    check_base_class_offset(lv, (S7267C5*), 0, "S7267C10");
    check_base_class_offset(lv, (S7267C11*), ABISELECT(792,636), "S7267C10");
    check_field_offset(lv, s7267c10f0, ABISELECT(120,96), "S7267C10.s7267c10f0");
    check_field_offset(lv, s7267c10f1, ABISELECT(152,112), "S7267C10.s7267c10f1");
    test_class_info(&lv, &cd_S7267C10);
    dp->~S7267C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7267C10(Test_S7267C10, "S7267C10", ABISELECT(960,732));

#else // __cplusplus

extern void _ZN8S7267C10C1Ev();
extern void _ZN8S7267C10D2Ev();
Name_Map name_map_S7267C10[] = {
  NSPAIR(_ZN8S7267C10C1Ev),
  NSPAIR(_ZN8S7267C10D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7267C5;
extern VTBL_ENTRY _ZTI7S7267C5[];
extern  VTBL_ENTRY _ZTV7S7267C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C5[];
extern Class_Descriptor cd_S7267C11;
extern VTBL_ENTRY _ZTI8S7267C11[];
extern  VTBL_ENTRY _ZTV8S7267C11[];
static Base_Class bases_S7267C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7268C4,    ABISELECT(760,608), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S7267C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7267C11,    ABISELECT(792,636), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7267C10[];
extern void _ZN8S7267C10D1Ev();
extern void _ZN8S7267C10D0Ev();
extern void _ZN8S7267C102v6Ev();
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
static  VTBL_ENTRY vtc_S7267C10[] = {
  ABISELECT(792,636),
  ABISELECT(760,608),
  0,
  (VTBL_ENTRY)&(_ZTI8S7267C10[0]),
  (VTBL_ENTRY)&_ZN8S7267C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7267C10D0Ev,
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
  0,
  0,
  ABISELECT(-792,-636),
  (VTBL_ENTRY)&(_ZTI8S7267C10[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
};
extern VTBL_ENTRY _ZTV8S7267C10[];
extern void _ZN7S7267C5D1Ev();
extern void _ZN7S7267C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C5__8S7267C10[] = {
  ABISELECT(760,608),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C5[0]),
  (VTBL_ENTRY)&_ZN7S7267C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C5D0Ev,
};
static  VTT_ENTRY vtt_S7267C10[] = {
  {&(_ZTV8S7267C10[4]),  4,13},
  {&(_tg__ZTV7S7267C5__8S7267C10[3]),  3,5},
  {&(_ZTV8S7267C10[11]),  11,13},
};
extern VTBL_ENTRY _ZTI8S7267C10[];
extern  VTBL_ENTRY _ZTV8S7267C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7267C10[];
Class_Descriptor cd_S7267C10 = {  "S7267C10", // class name
  bases_S7267C10, 3,
  &(vtc_S7267C10[0]), // expected_vtbl_contents
  &(vtt_S7267C10[0]), // expected_vtt_contents
  ABISELECT(960,732), // object size
  NSPAIRA(_ZTI8S7267C10),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S7267C10),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7267C10),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7267C8  {
  ::S7268C9 s7267c8f0;
  void *s7267c8f1;
  ::S7268C4 s7267c8f2[8];
  void *s7267c8f3;
  virtual void  v7(); // _ZN7S7267C82v7Ev
  ~S7267C8(); // tgen
  S7267C8(); // tgen
};
//SIG(-1 S7267C8) C1{ v1 FU2{ m Fl Fp[4] Fi} Fp FC3{ m Fs[6] FL Fc[5]}[8] Fp}


void  S7267C8 ::v7(){vfunc_called(this, "_ZN7S7267C82v7Ev");}
S7267C8 ::~S7267C8(){ note_dtor("S7267C8", this);} // tgen
S7267C8 ::S7267C8(){ note_ctor("S7267C8", this);} // tgen

static void Test_S7267C8()
{
  extern Class_Descriptor cd_S7267C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(40,64)];
    init_test(&cd_S7267C8, buf);
    S7267C8 *dp, &lv = *(dp=new (buf) S7267C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(312,252), "sizeof(S7267C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7267C8)");
    check_field_offset(lv, s7267c8f0, ABISELECT(8,4), "S7267C8.s7267c8f0");
    check_field_offset(lv, s7267c8f1, ABISELECT(40,20), "S7267C8.s7267c8f1");
    check_field_offset(lv, s7267c8f2, ABISELECT(48,24), "S7267C8.s7267c8f2");
    check_field_offset(lv, s7267c8f3, ABISELECT(304,248), "S7267C8.s7267c8f3");
    test_class_info(&lv, &cd_S7267C8);
    dp->~S7267C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7267C8(Test_S7267C8, "S7267C8", ABISELECT(312,252));

#else // __cplusplus

extern void _ZN7S7267C8C1Ev();
extern void _ZN7S7267C8D1Ev();
Name_Map name_map_S7267C8[] = {
  NSPAIR(_ZN7S7267C8C1Ev),
  NSPAIR(_ZN7S7267C8D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S7267C8[];
extern void _ZN7S7267C82v7Ev();
static  VTBL_ENTRY vtc_S7267C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C8[0]),
  (VTBL_ENTRY)&_ZN7S7267C82v7Ev,
};
extern VTBL_ENTRY _ZTI7S7267C8[];
extern  VTBL_ENTRY _ZTV7S7267C8[];
Class_Descriptor cd_S7267C8 = {  "S7267C8", // class name
  0,0,//no base classes
  &(vtc_S7267C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(312,252), // object size
  NSPAIRA(_ZTI7S7267C8),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S7267C8),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7267C3  : S7268C4 , S7267C5 , virtual S7267C6 , virtual S7267C10 , S7267C8 {
  void *s7267c3f0;
  int s7267c3f1[6];
  __tsi64 s7267c3f2;
  ::S7267C5 s7267c3f3;
  char s7267c3f4;
  ~S7267C3(); // tgen
  S7267C3(); // tgen
};
//SIG(-1 S7267C3) C1{ BC2{ m Fs[6] FL Fc[5]} BC3{ VBC2 vd FC2 Fi Fp FC2[2]} VBC4{ v1 v2 FC2 Fc FC5{ BC6{ v7 FU7{ m Fl Fp[4] Fi} Fp FC2[8] Fp} VBC2 BC8{ VBC2 vd FC2 Fi Fp FC2[2]} Fp[5] Fc:0 Fi Fi Fi:10 Fc[8] Fs Fi Fp[10] FC8 FL Fi Fp} Fp Fi Fi Fp Fi Fi:11 Fi} VBC9{ BC3 VBC10{ v3 v4 Fi Fp Fp Fl Fp[2] Fp Fl[6] FC2 Fi Fp Fc[2]} vd v5 Fl[4] FC3[4]} BC11{ v6 FU7 Fp FC2[8] Fp} Fp Fi[6] FL FC3 Fc}


S7267C3 ::~S7267C3(){ note_dtor("S7267C3", this);} // tgen
S7267C3 ::S7267C3(){ note_ctor("S7267C3", this);} // tgen

static void Test_S7267C3()
{
  extern Class_Descriptor cd_S7267C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(313,485)];
    init_test(&cd_S7267C3, buf);
    S7267C3 *dp, &lv = *(dp=new (buf) S7267C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2496,1936), "sizeof(S7267C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7267C3)");
    /*is_ambiguous_... S7267C3::S7268C4 */ AMB_check_base_class_offset(lv, (S7268C4*), ABISELECT(120,96), "S7267C3");
    /*is_ambiguous_... S7267C3::S7267C5 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7267C5*), ABISELECT(664,540), "S7267C3");
    check_base_class_offset(lv, (S7268C4*)(S7267C5*)(S7267C10*), ABISELECT(664,540), "S7267C3");
    /*is_ambiguous_... S7267C3::S7267C5 */ AMB_check_base_class_offset(lv, (S7267C5*), 0, "S7267C3");
    check_base_class_offset(lv, (S7267C6*), ABISELECT(696,568), "S7267C3");
    check_base_class_offset(lv, (S7267C5*)(S7267C10*), ABISELECT(1568,1232), "S7267C3");
    check_base_class_offset(lv, (S7267C11*)(S7267C10*), ABISELECT(2328,1840), "S7267C3");
    check_base_class_offset(lv, (S7267C10*), ABISELECT(1568,1232), "S7267C3");
    check_base_class_offset(lv, (S7267C8*), ABISELECT(152,124), "S7267C3");
    check_field_offset(lv, s7267c3f0, ABISELECT(464,376), "S7267C3.s7267c3f0");
    check_field_offset(lv, s7267c3f1, ABISELECT(472,380), "S7267C3.s7267c3f1");
    check_field_offset(lv, s7267c3f2, ABISELECT(496,404), "S7267C3.s7267c3f2");
    check_field_offset(lv, s7267c3f3, ABISELECT(504,412), "S7267C3.s7267c3f3");
    check_field_offset(lv, s7267c3f4, ABISELECT(656,536), "S7267C3.s7267c3f4");
    test_class_info(&lv, &cd_S7267C3);
    dp->~S7267C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7267C3(Test_S7267C3, "S7267C3", ABISELECT(2496,1936));

#else // __cplusplus

extern void _ZN7S7267C3C1Ev();
extern void _ZN7S7267C3D1Ev();
Name_Map name_map_S7267C3[] = {
  NSPAIR(_ZN7S7267C3C1Ev),
  NSPAIR(_ZN7S7267C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7267C5;
extern VTBL_ENTRY _ZTI7S7267C5[];
extern  VTBL_ENTRY _ZTV7S7267C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C5[];
extern Class_Descriptor cd_S7267C6;
extern VTBL_ENTRY _ZTI7S7267C6[];
extern  VTBL_ENTRY _ZTV7S7267C6[];
extern Class_Descriptor cd_S7267C5;
extern VTBL_ENTRY _ZTI7S7267C5[];
extern  VTBL_ENTRY _ZTV7S7267C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C5[];
extern Class_Descriptor cd_S7267C11;
extern VTBL_ENTRY _ZTI8S7267C11[];
extern  VTBL_ENTRY _ZTV8S7267C11[];
extern Class_Descriptor cd_S7267C10;
extern VTBL_ENTRY _ZTI8S7267C10[];
extern  VTBL_ENTRY _ZTV8S7267C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7267C10[];
extern Class_Descriptor cd_S7267C8;
extern VTBL_ENTRY _ZTI7S7267C8[];
extern  VTBL_ENTRY _ZTV7S7267C8[];
static Base_Class bases_S7267C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7268C4,    ABISELECT(120,96), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7268C4,    ABISELECT(664,540), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S7267C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7267C6,    ABISELECT(696,568), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7267C5,    ABISELECT(1568,1232), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S7267C11,    ABISELECT(2328,1840), //bcp->offset
    26, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S7267C10,    ABISELECT(1568,1232), //bcp->offset
    17, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7267C8,    ABISELECT(152,124), //bcp->offset
    8, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S7267C3[];
extern void _ZN7S7267C3D1Ev();
extern void _ZN7S7267C3D0Ev();
extern void _ZN7S7267C82v7Ev();
extern void _ZN7S7267C62v2Ev();
extern void _ZN7S7267C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N7S7267C3D1Ev,_ZTv0_n20_N7S7267C3D1Ev)();
extern void ABISELECT(_ZThn1568_N7S7267C3D1Ev,_ZThn1232_N7S7267C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S7267C3D0Ev,_ZTv0_n20_N7S7267C3D0Ev)();
extern void ABISELECT(_ZThn1568_N7S7267C3D0Ev,_ZThn1232_N7S7267C3D0Ev)() __attribute__((weak));
extern void _ZN8S7267C102v6Ev();
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
static  VTBL_ENTRY vtc_S7267C3[] = {
  ABISELECT(2328,1840),
  ABISELECT(1568,1232),
  ABISELECT(696,568),
  ABISELECT(664,540),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&_ZN7S7267C3D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C3D0Ev,
  ABISELECT(-152,-124),
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&_ZN7S7267C82v7Ev,
  0,
  0,
  ABISELECT(-696,-568),
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&_ZN7S7267C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7267C62v3Ev,
  0,
  ABISELECT(-1568,-1232),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-1568,-1232),
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7267C3D1Ev,_ZTv0_n20_N7S7267C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7267C3D0Ev,_ZTv0_n20_N7S7267C3D0Ev),
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
  0,
  0,
  ABISELECT(-2328,-1840),
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
};
extern VTBL_ENTRY _ZTV7S7267C3[];
extern void _ZN7S7267C5D1Ev();
extern void _ZN7S7267C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C5__7S7267C3[] = {
  ABISELECT(664,540),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C5[0]),
  (VTBL_ENTRY)&_ZN7S7267C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C5D0Ev,
};
extern void _ZN8S7267C10D1Ev();
extern void _ZN8S7267C10D0Ev();
extern void _ZN8S7267C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C10__7S7267C3[] = {
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  0,
  (VTBL_ENTRY)&(_ZTI8S7267C10[0]),
  (VTBL_ENTRY)&_ZN8S7267C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7267C10D0Ev,
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
};
extern void _ZN7S7267C5D1Ev();
extern void _ZN7S7267C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C58S7267C10__A1__7S7267C3[] = {
  ABISELECT(-904,-692),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C5[0]),
  (VTBL_ENTRY)&_ZN7S7267C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C5D0Ev,
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C11__8S7267C10__7S7267C3[] = {
  0,
  0,
  ABISELECT(-760,-608),
  (VTBL_ENTRY)&(_ZTI8S7267C10[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
};
static  VTT_ENTRY vtt_S7267C3[] = {
  {&(_ZTV7S7267C3[6]),  6,32},
  {&(_tg__ZTV7S7267C5__7S7267C3[3]),  3,5},
  {&(_ZTV7S7267C3[15]),  15,32},
  {&(_ZTV7S7267C3[23]),  23,32},
  {&(_ZTV7S7267C3[30]),  30,32},
  {&(_tg__ZTV8S7267C10__7S7267C3[4]),  4,7},
  {&(_tg__ZTV7S7267C58S7267C10__A1__7S7267C3[3]),  3,5},
  {&(_tg__ZTV8S7267C11__8S7267C10__7S7267C3[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7S7267C3[];
extern  VTBL_ENTRY _ZTV7S7267C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C3[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7267C3D0Ev,_ZTv0_n20_N7S7267C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1568_N7S7267C3D0Ev,_ZThn1232_N7S7267C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7267C3D1Ev,_ZTv0_n20_N7S7267C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1568_N7S7267C3D1Ev,_ZThn1232_N7S7267C3D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7267C3 = {  "S7267C3", // class name
  bases_S7267C3, 8,
  &(vtc_S7267C3[0]), // expected_vtbl_contents
  &(vtt_S7267C3[0]), // expected_vtt_contents
  ABISELECT(2496,1936), // object size
  NSPAIRA(_ZTI7S7267C3),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV7S7267C3),32, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7267C3),8, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7267C2  : virtual S7267C3 {
  ::S7268C4 s7267c2f0;
  ::S7267C10 s7267c2f1[5];
  ::S7267C3 s7267c2f2[10];
  __tsi64 s7267c2f3[4];
  char s7267c2f4;
  ::S7267C3 s7267c2f5;
  ::S7267C3 s7267c2f6;
  virtual void  v8(); // _ZN7S7267C22v8Ev
  ~S7267C2(); // tgen
  S7267C2(); // tgen
};
//SIG(-1 S7267C2) C1{ VBC2{ BC3{ m Fs[6] FL Fc[5]} BC4{ VBC3 vd FC3 Fi Fp FC3[2]} VBC5{ v2 v3 FC3 Fc FC6{ BC7{ v8 FU8{ m Fl Fp[4] Fi} Fp FC3[8] Fp} VBC3 BC9{ VBC3 vd FC3 Fi Fp FC3[2]} Fp[5] Fc:0 Fi Fi Fi:10 Fc[8] Fs Fi Fp[10] FC9 FL Fi Fp} Fp Fi Fi Fp Fi Fi:11 Fi} VBC10{ BC4 VBC11{ v4 v5 Fi Fp Fp Fl Fp[2] Fp Fl[6] FC3 Fi Fp Fc[2]} vd v6 Fl[4] FC4[4]} BC12{ v7 FU8 Fp FC3[8] Fp} Fp Fi[6] FL FC4 Fc} v1 FC3 FC10[5] FC2[10] FL[4] Fc FC2 FC2}


void  S7267C2 ::v8(){vfunc_called(this, "_ZN7S7267C22v8Ev");}
S7267C2 ::~S7267C2(){ note_dtor("S7267C2", this);} // tgen
S7267C2 ::S7267C2(){ note_ctor("S7267C2", this);} // tgen

static void Test_S7267C2()
{
  extern Class_Descriptor cd_S7267C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4667,7225)];
    init_test(&cd_S7267C2, buf);
    S7267C2 *dp, &lv = *(dp=new (buf) S7267C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(37328,28896), "sizeof(S7267C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7267C2)");
    /*is_ambiguous_... S7267C3::S7268C4 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7267C3*), ABISELECT(34952,27056), "S7267C2");
    /*is_ambiguous_... S7267C3::S7267C5 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7267C5*)(S7267C3*), ABISELECT(35496,27500), "S7267C2");
    check_base_class_offset(lv, (S7268C4*)(S7267C5*)(S7267C10*), ABISELECT(35496,27500), "S7267C2");
    /*is_ambiguous_... S7267C3::S7267C5 */ AMB_check_base_class_offset(lv, (S7267C5*)(S7267C3*), ABISELECT(34832,26960), "S7267C2");
    check_base_class_offset(lv, (S7267C6*)(S7267C3*), ABISELECT(35528,27528), "S7267C2");
    check_base_class_offset(lv, (S7267C5*)(S7267C10*), ABISELECT(36400,28192), "S7267C2");
    check_base_class_offset(lv, (S7267C11*)(S7267C10*), ABISELECT(37160,28800), "S7267C2");
    check_base_class_offset(lv, (S7267C10*)(S7267C3*), ABISELECT(36400,28192), "S7267C2");
    check_base_class_offset(lv, (S7267C8*)(S7267C3*), ABISELECT(34984,27084), "S7267C2");
    check_base_class_offset(lv, (S7267C3*), ABISELECT(34832,26960), "S7267C2");
    check_field_offset(lv, s7267c2f0, ABISELECT(8,4), "S7267C2.s7267c2f0");
    check_field_offset(lv, s7267c2f1, ABISELECT(40,32), "S7267C2.s7267c2f1");
    check_field_offset(lv, s7267c2f2, ABISELECT(4840,3692), "S7267C2.s7267c2f2");
    check_field_offset(lv, s7267c2f3, ABISELECT(29800,23052), "S7267C2.s7267c2f3");
    check_field_offset(lv, s7267c2f4, ABISELECT(29832,23084), "S7267C2.s7267c2f4");
    check_field_offset(lv, s7267c2f5, ABISELECT(29840,23088), "S7267C2.s7267c2f5");
    check_field_offset(lv, s7267c2f6, ABISELECT(32336,25024), "S7267C2.s7267c2f6");
    test_class_info(&lv, &cd_S7267C2);
    dp->~S7267C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7267C2(Test_S7267C2, "S7267C2", ABISELECT(37328,28896));

#else // __cplusplus

extern void _ZN7S7267C2C1Ev();
extern void _ZN7S7267C2D1Ev();
Name_Map name_map_S7267C2[] = {
  NSPAIR(_ZN7S7267C2C1Ev),
  NSPAIR(_ZN7S7267C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7267C5;
extern VTBL_ENTRY _ZTI7S7267C5[];
extern  VTBL_ENTRY _ZTV7S7267C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C5[];
extern Class_Descriptor cd_S7267C6;
extern VTBL_ENTRY _ZTI7S7267C6[];
extern  VTBL_ENTRY _ZTV7S7267C6[];
extern Class_Descriptor cd_S7267C5;
extern VTBL_ENTRY _ZTI7S7267C5[];
extern  VTBL_ENTRY _ZTV7S7267C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C5[];
extern Class_Descriptor cd_S7267C11;
extern VTBL_ENTRY _ZTI8S7267C11[];
extern  VTBL_ENTRY _ZTV8S7267C11[];
extern Class_Descriptor cd_S7267C10;
extern VTBL_ENTRY _ZTI8S7267C10[];
extern  VTBL_ENTRY _ZTV8S7267C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7267C10[];
extern Class_Descriptor cd_S7267C8;
extern VTBL_ENTRY _ZTI7S7267C8[];
extern  VTBL_ENTRY _ZTV7S7267C8[];
extern Class_Descriptor cd_S7267C3;
extern VTBL_ENTRY _ZTI7S7267C3[];
extern  VTBL_ENTRY _ZTV7S7267C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C3[];
static Base_Class bases_S7267C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7268C4,    ABISELECT(34952,27056), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7268C4,    ABISELECT(35496,27500), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S7267C5,    ABISELECT(34832,26960), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7267C6,    ABISELECT(35528,27528), //bcp->offset
    23, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S7267C5,    ABISELECT(36400,28192), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S7267C11,    ABISELECT(37160,28800), //bcp->offset
    38, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S7267C10,    ABISELECT(36400,28192), //bcp->offset
    29, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S7267C8,    ABISELECT(34984,27084), //bcp->offset
    20, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7267C3,    ABISELECT(34832,26960), //bcp->offset
    10, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S7267C2[];
extern void _ZN7S7267C22v8Ev();
extern void _ZN7S7267C2D1Ev();
extern void _ZN7S7267C2D0Ev();
extern void ABISELECT(_ZTv0_n56_N7S7267C2D1Ev,_ZTv0_n28_N7S7267C2D1Ev)();
extern void ABISELECT(_ZThn34832_N7S7267C2D1Ev,_ZThn26960_N7S7267C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N7S7267C2D0Ev,_ZTv0_n28_N7S7267C2D0Ev)();
extern void ABISELECT(_ZThn34832_N7S7267C2D0Ev,_ZThn26960_N7S7267C2D0Ev)() __attribute__((weak));
extern void _ZN7S7267C82v7Ev();
extern void _ZN7S7267C62v2Ev();
extern void _ZN7S7267C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N7S7267C2D1Ev,_ZTv0_n20_N7S7267C2D1Ev)();
extern void ABISELECT(_ZThn36400_N7S7267C2D1Ev,_ZThn28192_N7S7267C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S7267C2D0Ev,_ZTv0_n20_N7S7267C2D0Ev)();
extern void ABISELECT(_ZThn36400_N7S7267C2D0Ev,_ZThn28192_N7S7267C2D0Ev)() __attribute__((weak));
extern void _ZN8S7267C102v6Ev();
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
static  VTBL_ENTRY vtc_S7267C2[] = {
  ABISELECT(37160,28800),
  ABISELECT(36400,28192),
  ABISELECT(35528,27528),
  ABISELECT(35496,27500),
  ABISELECT(34832,26960),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C2[0]),
  (VTBL_ENTRY)&_ZN7S7267C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7267C2D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C2D0Ev,
  ABISELECT(152,124),
  ABISELECT(-34832,-26960),
  ABISELECT(2328,1840),
  ABISELECT(1568,1232),
  ABISELECT(696,568),
  ABISELECT(664,540),
  ABISELECT(-34832,-26960),
  (VTBL_ENTRY)&(_ZTI7S7267C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7267C2D1Ev,_ZTv0_n28_N7S7267C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7267C2D0Ev,_ZTv0_n28_N7S7267C2D0Ev),
  ABISELECT(-34984,-27084),
  (VTBL_ENTRY)&(_ZTI7S7267C2[0]),
  (VTBL_ENTRY)&_ZN7S7267C82v7Ev,
  0,
  0,
  ABISELECT(-35528,-27528),
  (VTBL_ENTRY)&(_ZTI7S7267C2[0]),
  (VTBL_ENTRY)&_ZN7S7267C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7267C62v3Ev,
  0,
  ABISELECT(-36400,-28192),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-36400,-28192),
  (VTBL_ENTRY)&(_ZTI7S7267C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7267C2D1Ev,_ZTv0_n20_N7S7267C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7267C2D0Ev,_ZTv0_n20_N7S7267C2D0Ev),
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
  0,
  0,
  ABISELECT(-37160,-28800),
  (VTBL_ENTRY)&(_ZTI7S7267C2[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
};
extern VTBL_ENTRY _ZTV7S7267C2[];
extern void _ZN7S7267C3D1Ev();
extern void _ZN7S7267C3D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C3__7S7267C2[] = {
  ABISELECT(2328,1840),
  ABISELECT(1568,1232),
  ABISELECT(696,568),
  ABISELECT(664,540),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&_ZN7S7267C3D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C3D0Ev,
};
extern void _ZN7S7267C5D1Ev();
extern void _ZN7S7267C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C57S7267C3__7S7267C2[] = {
  ABISELECT(664,540),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C5[0]),
  (VTBL_ENTRY)&_ZN7S7267C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C5D0Ev,
};
extern void _ZN7S7267C62v2Ev();
extern void _ZN7S7267C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C6__7S7267C3__7S7267C2[] = {
  0,
  0,
  ABISELECT(-696,-568),
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&_ZN7S7267C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7267C62v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S7267C3D1Ev,_ZTv0_n20_N7S7267C3D1Ev)();
extern void ABISELECT(_ZThn1568_N7S7267C3D1Ev,_ZThn1232_N7S7267C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S7267C3D0Ev,_ZTv0_n20_N7S7267C3D0Ev)();
extern void ABISELECT(_ZThn1568_N7S7267C3D0Ev,_ZThn1232_N7S7267C3D0Ev)() __attribute__((weak));
extern void _ZN8S7267C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C10__7S7267C3__7S7267C2[] = {
  0,
  ABISELECT(-1568,-1232),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-1568,-1232),
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7267C3D1Ev,_ZTv0_n20_N7S7267C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7267C3D0Ev,_ZTv0_n20_N7S7267C3D0Ev),
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C11__7S7267C3__7S7267C2[] = {
  0,
  0,
  ABISELECT(-2328,-1840),
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
};
extern void _ZN8S7267C10D1Ev();
extern void _ZN8S7267C10D0Ev();
extern void _ZN8S7267C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C10__7S7267C2[] = {
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  0,
  (VTBL_ENTRY)&(_ZTI8S7267C10[0]),
  (VTBL_ENTRY)&_ZN8S7267C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7267C10D0Ev,
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
};
extern void _ZN7S7267C5D1Ev();
extern void _ZN7S7267C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C58S7267C10__A1__7S7267C2[] = {
  ABISELECT(-904,-692),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C5[0]),
  (VTBL_ENTRY)&_ZN7S7267C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C5D0Ev,
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C11__8S7267C10__7S7267C2[] = {
  0,
  0,
  ABISELECT(-760,-608),
  (VTBL_ENTRY)&(_ZTI8S7267C10[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
};
static  VTT_ENTRY vtt_S7267C2[] = {
  {&(_ZTV7S7267C2[7]),  7,44},
  {&(_ZTV7S7267C2[18]),  18,44},
  {&(_ZTV7S7267C2[27]),  27,44},
  {&(_ZTV7S7267C2[35]),  35,44},
  {&(_ZTV7S7267C2[42]),  42,44},
  {&(_ZTV7S7267C2[22]),  22,44},
  {&(_tg__ZTV7S7267C3__7S7267C2[6]),  6,8},
  {&(_tg__ZTV7S7267C57S7267C3__7S7267C2[3]),  3,5},
  {&(_tg__ZTV7S7267C6__7S7267C3__7S7267C2[4]),  4,6},
  {&(_tg__ZTV8S7267C10__7S7267C3__7S7267C2[6]),  6,9},
  {&(_tg__ZTV8S7267C11__7S7267C3__7S7267C2[4]),  4,6},
  {&(_tg__ZTV8S7267C10__7S7267C2[4]),  4,7},
  {&(_tg__ZTV7S7267C58S7267C10__A1__7S7267C2[3]),  3,5},
  {&(_tg__ZTV8S7267C11__8S7267C10__7S7267C2[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7S7267C2[];
extern  VTBL_ENTRY _ZTV7S7267C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C2[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7267C3D0Ev,_ZTv0_n20_N7S7267C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1568_N7S7267C3D0Ev,_ZThn1232_N7S7267C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7267C3D1Ev,_ZTv0_n20_N7S7267C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1568_N7S7267C3D1Ev,_ZThn1232_N7S7267C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7267C2D0Ev,_ZTv0_n20_N7S7267C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn36400_N7S7267C2D0Ev,_ZThn28192_N7S7267C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7267C2D1Ev,_ZTv0_n20_N7S7267C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn36400_N7S7267C2D1Ev,_ZThn28192_N7S7267C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7267C2D0Ev,_ZTv0_n28_N7S7267C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn34832_N7S7267C2D0Ev,_ZThn26960_N7S7267C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7267C2D1Ev,_ZTv0_n28_N7S7267C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn34832_N7S7267C2D1Ev,_ZThn26960_N7S7267C2D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7267C2 = {  "S7267C2", // class name
  bases_S7267C2, 9,
  &(vtc_S7267C2[0]), // expected_vtbl_contents
  &(vtt_S7267C2[0]), // expected_vtt_contents
  ABISELECT(37328,28896), // object size
  NSPAIRA(_ZTI7S7267C2),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7S7267C2),44, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7267C2),14, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7267C13  : virtual S7267C5 , S7267C11 {
  int s7267c13f0;
  void *s7267c13f1;
  virtual void  v9(); // _ZN8S7267C132v9Ev
  ~S7267C13(); // tgen
  S7267C13(); // tgen
};
//SIG(-1 S7267C13) C1{ VBC2{ VBC3{ m Fs[6] FL Fc[5]} vd FC3 Fi Fp FC3[2]} BC4{ v2 v3 Fi Fp[2] Fl Fp[3] Fl[6] FC3 Fi Fp Fc[2]} v1 Fi Fp}


void  S7267C13 ::v9(){vfunc_called(this, "_ZN8S7267C132v9Ev");}
S7267C13 ::~S7267C13(){ note_dtor("S7267C13", this);} // tgen
S7267C13 ::S7267C13(){ note_ctor("S7267C13", this);} // tgen

static void Test_S7267C13()
{
  extern Class_Descriptor cd_S7267C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(42,58)];
    init_test(&cd_S7267C13, buf);
    S7267C13 *dp, &lv = *(dp=new (buf) S7267C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(328,228), "sizeof(S7267C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7267C13)");
    check_base_class_offset(lv, (S7268C4*)(S7267C5*), ABISELECT(296,200), "S7267C13");
    check_base_class_offset(lv, (S7267C5*), ABISELECT(176,104), "S7267C13");
    check_base_class_offset(lv, (S7267C11*), 0, "S7267C13");
    check_field_offset(lv, s7267c13f0, ABISELECT(164,96), "S7267C13.s7267c13f0");
    check_field_offset(lv, s7267c13f1, ABISELECT(168,100), "S7267C13.s7267c13f1");
    test_class_info(&lv, &cd_S7267C13);
    dp->~S7267C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7267C13(Test_S7267C13, "S7267C13", ABISELECT(328,228));

#else // __cplusplus

extern void _ZN8S7267C13C1Ev();
extern void _ZN8S7267C13D1Ev();
Name_Map name_map_S7267C13[] = {
  NSPAIR(_ZN8S7267C13C1Ev),
  NSPAIR(_ZN8S7267C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7267C5;
extern VTBL_ENTRY _ZTI7S7267C5[];
extern  VTBL_ENTRY _ZTV7S7267C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C5[];
extern Class_Descriptor cd_S7267C11;
extern VTBL_ENTRY _ZTI8S7267C11[];
extern  VTBL_ENTRY _ZTV8S7267C11[];
static Base_Class bases_S7267C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7268C4,    ABISELECT(296,200), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S7267C5,    ABISELECT(176,104), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7267C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7267C13[];
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
extern void _ZN8S7267C132v9Ev();
extern void _ZN8S7267C13D1Ev();
extern void _ZN8S7267C13D0Ev();
extern void ABISELECT(_ZTv0_n32_N8S7267C13D1Ev,_ZTv0_n16_N8S7267C13D1Ev)();
extern void ABISELECT(_ZThn176_N8S7267C13D1Ev,_ZThn104_N8S7267C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7267C13D0Ev,_ZTv0_n16_N8S7267C13D0Ev)();
extern void ABISELECT(_ZThn176_N8S7267C13D0Ev,_ZThn104_N8S7267C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7267C13[] = {
  ABISELECT(296,200),
  ABISELECT(176,104),
  0,
  (VTBL_ENTRY)&(_ZTI8S7267C13[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
  (VTBL_ENTRY)&_ZN8S7267C132v9Ev,
  (VTBL_ENTRY)&_ZN8S7267C13D1Ev,
  (VTBL_ENTRY)&_ZN8S7267C13D0Ev,
  ABISELECT(-176,-104),
  ABISELECT(120,96),
  ABISELECT(-176,-104),
  (VTBL_ENTRY)&(_ZTI8S7267C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7267C13D1Ev,_ZTv0_n16_N8S7267C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7267C13D0Ev,_ZTv0_n16_N8S7267C13D0Ev),
};
extern VTBL_ENTRY _ZTV8S7267C13[];
extern void _ZN7S7267C5D1Ev();
extern void _ZN7S7267C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C5__8S7267C13[] = {
  ABISELECT(120,96),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C5[0]),
  (VTBL_ENTRY)&_ZN7S7267C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C5D0Ev,
};
static  VTT_ENTRY vtt_S7267C13[] = {
  {&(_ZTV8S7267C13[4]),  4,15},
  {&(_ZTV8S7267C13[13]),  13,15},
  {&(_tg__ZTV7S7267C5__8S7267C13[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S7267C13[];
extern  VTBL_ENTRY _ZTV8S7267C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7267C13[];
static VTBL_ENTRY alt_thunk_names10[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7267C13D0Ev,_ZTv0_n16_N8S7267C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7267C13D0Ev,_ZThn104_N8S7267C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7267C13D1Ev,_ZTv0_n16_N8S7267C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7267C13D1Ev,_ZThn104_N8S7267C13D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7267C13 = {  "S7267C13", // class name
  bases_S7267C13, 3,
  &(vtc_S7267C13[0]), // expected_vtbl_contents
  &(vtt_S7267C13[0]), // expected_vtt_contents
  ABISELECT(328,228), // object size
  NSPAIRA(_ZTI8S7267C13),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S7267C13),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7267C13),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names10,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7267C15  : S7267C6 , virtual S7267C8 , virtual S7268C4 , S7267C10 {
  int s7267c15f0;
  int s7267c15f1;
  char s7267c15f2[4];
  void *s7267c15f3[3];
  short s7267c15f4;
  int s7267c15f5;
  int s7267c15f6;
  long double s7267c15f7;
  void *s7267c15f8;
  void *s7267c15f9;
  int s7267c15f10;
  virtual  ~S7267C15(); // _ZN8S7267C15D2Ev
  S7267C15(); // tgen
};
//SIG(-1 S7267C15) C1{ BC2{ v1 v2 FC3{ m Fs[6] FL Fc[5]} Fc FC4{ BC5{ v7 FU6{ m Fl Fp[4] Fi} Fp FC3[8] Fp} VBC3 BC7{ VBC3 vd FC3 Fi Fp FC3[2]} Fp[5] Fc:0 Fi Fi Fi:10 Fc[8] Fs Fi Fp[10] FC7 FL Fi Fp} Fp Fi Fi Fp Fi Fi:11 Fi} VBC8{ v3 FU6 Fp FC3[8] Fp} VBC3 BC9{ BC10{ VBC3 vd FC3 Fi Fp FC3[2]} VBC11{ v4 v5 Fi Fp Fp Fl Fp[2] Fp Fl[6] FC3 Fi Fp Fc[2]} vd v6 Fl[4] FC10[4]} vd Fi Fi Fc[4] Fp[3] Fs Fi Fi FD Fp Fp Fi}


 S7267C15 ::~S7267C15(){ note_dtor("S7267C15", this);}
S7267C15 ::S7267C15(){ note_ctor("S7267C15", this);} // tgen

static void Test_S7267C15()
{
  extern Class_Descriptor cd_S7267C15;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(142,428)];
    init_test(&cd_S7267C15, buf);
    S7267C15 *dp, &lv = *(dp=new (buf) S7267C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2256,1708), "sizeof(S7267C15)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7267C15)");
    check_base_class_offset(lv, (S7267C6*), 0, "S7267C15");
    check_base_class_offset(lv, (S7267C8*), ABISELECT(1736,1332), "S7267C15");
    check_base_class_offset(lv, (S7268C4*), ABISELECT(2048,1584), "S7267C15");
    check_base_class_offset(lv, (S7268C4*)(S7267C5*)(S7267C10*), ABISELECT(2048,1584), "S7267C15");
    check_base_class_offset(lv, (S7267C5*)(S7267C10*), ABISELECT(872,664), "S7267C15");
    check_base_class_offset(lv, (S7267C11*)(S7267C10*), ABISELECT(2080,1612), "S7267C15");
    check_base_class_offset(lv, (S7267C10*), ABISELECT(872,664), "S7267C15");
    check_field_offset(lv, s7267c15f0, ABISELECT(1632,1272), "S7267C15.s7267c15f0");
    check_field_offset(lv, s7267c15f1, ABISELECT(1636,1276), "S7267C15.s7267c15f1");
    check_field_offset(lv, s7267c15f2, ABISELECT(1640,1280), "S7267C15.s7267c15f2");
    check_field_offset(lv, s7267c15f3, ABISELECT(1648,1284), "S7267C15.s7267c15f3");
    check_field_offset(lv, s7267c15f4, ABISELECT(1672,1296), "S7267C15.s7267c15f4");
    check_field_offset(lv, s7267c15f5, ABISELECT(1676,1300), "S7267C15.s7267c15f5");
    check_field_offset(lv, s7267c15f6, ABISELECT(1680,1304), "S7267C15.s7267c15f6");
    check_field_offset(lv, s7267c15f7, ABISELECT(1696,1308), "S7267C15.s7267c15f7");
    check_field_offset(lv, s7267c15f8, ABISELECT(1712,1320), "S7267C15.s7267c15f8");
    check_field_offset(lv, s7267c15f9, ABISELECT(1720,1324), "S7267C15.s7267c15f9");
    check_field_offset(lv, s7267c15f10, ABISELECT(1728,1328), "S7267C15.s7267c15f10");
    test_class_info(&lv, &cd_S7267C15);
    dp->~S7267C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7267C15(Test_S7267C15, "S7267C15", ABISELECT(2256,1708));

#else // __cplusplus

extern void _ZN8S7267C15C1Ev();
extern void _ZN8S7267C15D2Ev();
Name_Map name_map_S7267C15[] = {
  NSPAIR(_ZN8S7267C15C1Ev),
  NSPAIR(_ZN8S7267C15D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7267C6;
extern VTBL_ENTRY _ZTI7S7267C6[];
extern  VTBL_ENTRY _ZTV7S7267C6[];
extern Class_Descriptor cd_S7267C8;
extern VTBL_ENTRY _ZTI7S7267C8[];
extern  VTBL_ENTRY _ZTV7S7267C8[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7267C5;
extern VTBL_ENTRY _ZTI7S7267C5[];
extern  VTBL_ENTRY _ZTV7S7267C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C5[];
extern Class_Descriptor cd_S7267C11;
extern VTBL_ENTRY _ZTI8S7267C11[];
extern  VTBL_ENTRY _ZTV8S7267C11[];
extern Class_Descriptor cd_S7267C10;
extern VTBL_ENTRY _ZTI8S7267C10[];
extern  VTBL_ENTRY _ZTV8S7267C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7267C10[];
static Base_Class bases_S7267C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7267C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7267C8,    ABISELECT(1736,1332), //bcp->offset
    16, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7268C4,    ABISELECT(2048,1584), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7267C5,    ABISELECT(872,664), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7267C11,    ABISELECT(2080,1612), //bcp->offset
    20, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S7267C10,    ABISELECT(872,664), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7267C15[];
extern void _ZN7S7267C62v2Ev();
extern void _ZN7S7267C62v3Ev();
extern void _ZN8S7267C15D1Ev();
extern void _ZN8S7267C15D0Ev();
extern void ABISELECT(_ZThn872_N8S7267C15D1Ev,_ZThn664_N8S7267C15D1Ev)();
extern void ABISELECT(_ZThn872_N8S7267C15D0Ev,_ZThn664_N8S7267C15D0Ev)();
extern void _ZN8S7267C102v6Ev();
extern void _ZN7S7267C82v7Ev();
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
static  VTBL_ENTRY vtc_S7267C15[] = {
  ABISELECT(2080,1612),
  ABISELECT(2048,1584),
  ABISELECT(1736,1332),
  0,
  (VTBL_ENTRY)&(_ZTI8S7267C15[0]),
  (VTBL_ENTRY)&_ZN7S7267C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7267C62v3Ev,
  (VTBL_ENTRY)&_ZN8S7267C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7267C15D0Ev,
  ABISELECT(1208,948),
  ABISELECT(1176,920),
  ABISELECT(-872,-664),
  (VTBL_ENTRY)&(_ZTI8S7267C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn872_N8S7267C15D1Ev,_ZThn664_N8S7267C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn872_N8S7267C15D0Ev,_ZThn664_N8S7267C15D0Ev),
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
  0,
  ABISELECT(-1736,-1332),
  (VTBL_ENTRY)&(_ZTI8S7267C15[0]),
  (VTBL_ENTRY)&_ZN7S7267C82v7Ev,
  0,
  0,
  ABISELECT(-2080,-1612),
  (VTBL_ENTRY)&(_ZTI8S7267C15[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
};
extern VTBL_ENTRY _ZTV8S7267C15[];
extern void _ZN8S7267C10D1Ev();
extern void _ZN8S7267C10D0Ev();
extern void _ZN8S7267C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C10__8S7267C15[] = {
  ABISELECT(1208,948),
  ABISELECT(1176,920),
  0,
  (VTBL_ENTRY)&(_ZTI8S7267C10[0]),
  (VTBL_ENTRY)&_ZN8S7267C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7267C10D0Ev,
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
};
extern void _ZN7S7267C5D1Ev();
extern void _ZN7S7267C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C58S7267C10__8S7267C15[] = {
  ABISELECT(1176,920),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C5[0]),
  (VTBL_ENTRY)&_ZN7S7267C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C5D0Ev,
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C11__8S7267C10__8S7267C15[] = {
  0,
  0,
  ABISELECT(-1208,-948),
  (VTBL_ENTRY)&(_ZTI8S7267C10[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
};
static  VTT_ENTRY vtt_S7267C15[] = {
  {&(_ZTV8S7267C15[5]),  5,26},
  {&(_tg__ZTV8S7267C10__8S7267C15[4]),  4,7},
  {&(_tg__ZTV7S7267C58S7267C10__8S7267C15[3]),  3,5},
  {&(_tg__ZTV8S7267C11__8S7267C10__8S7267C15[4]),  4,6},
  {&(_ZTV8S7267C15[19]),  19,26},
  {&(_ZTV8S7267C15[13]),  13,26},
  {&(_ZTV8S7267C15[24]),  24,26},
};
extern VTBL_ENTRY _ZTI8S7267C15[];
extern  VTBL_ENTRY _ZTV8S7267C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7267C15[];
Class_Descriptor cd_S7267C15 = {  "S7267C15", // class name
  bases_S7267C15, 6,
  &(vtc_S7267C15[0]), // expected_vtbl_contents
  &(vtt_S7267C15[0]), // expected_vtt_contents
  ABISELECT(2256,1708), // object size
  NSPAIRA(_ZTI8S7267C15),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S7267C15),26, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7267C15),7, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7267C14  : S7267C3 , S7267C15 , virtual S7267C2 , S7268C4 , virtual S7267C13 {
  ::S7268C16 s7267c14f0;
  void *s7267c14f1;
  int s7267c14f2;
  __tsi64 s7267c14f3;
  __tsi64 s7267c14f4;
  ::S7267C15 s7267c14f5;
  __tsi64 s7267c14f6;
  int s7267c14f7[8];
  int s7267c14f8;
  virtual  ~S7267C14(); // _ZN8S7267C14D2Ev
  virtual void  v10(); // _ZN8S7267C143v10Ev
  S7267C14(); // tgen
};
//SIG(-1 S7267C14) C1{ BC2{ BC3{ m Fs[6] FL Fc[5]} BC4{ VBC3 vd FC3 Fi Fp FC3[2]} VBC5{ v2 v3 FC3 Fc FC6{ BC7{ v10 FU8{ m Fl Fp[4] Fi} Fp FC3[8] Fp} VBC3 BC9{ VBC3 vd FC3 Fi Fp FC3[2]} Fp[5] Fc:0 Fi Fi Fi:10 Fc[8] Fs Fi Fp[10] FC9 FL Fi Fp} Fp Fi Fi Fp Fi Fi:11 Fi} VBC10{ BC4 VBC11{ v4 v5 Fi Fp Fp Fl Fp[2] Fp Fl[6] FC3 Fi Fp Fc[2]} vd v6 Fl[4] FC4[4]} BC12{ v7 FU8 Fp FC3[8] Fp} Fp Fi[6] FL FC4 Fc} BC13{ BC5 VBC12 VBC3 BC10 vd Fi Fi Fc[4] Fp[3] Fs Fi Fi FD Fp Fp Fi} VBC14{ VBC2 v8 FC3 FC10[5] FC2[10] FL[4] Fc FC2 FC2} BC3 VBC15{ VBC4 BC11 v9 Fi Fp} vd v1 FU16{ m Fi Fc[7] Fi[10] Fi FD[8] Fi Fp Fi} Fp Fi FL FL FC13 FL Fi[8] Fi}


 S7267C14 ::~S7267C14(){ note_dtor("S7267C14", this);}
void  S7267C14 ::v10(){vfunc_called(this, "_ZN8S7267C143v10Ev");}
S7267C14 ::S7267C14(){ note_ctor("S7267C14", this);} // tgen

static void Test_S7267C14()
{
  extern Class_Descriptor cd_S7267C14;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(2679,8281)];
    init_test(&cd_S7267C14, buf);
    S7267C14 *dp, &lv = *(dp=new (buf) S7267C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(42848,33120), "sizeof(S7267C14)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7267C14)");
    /*is_ambiguous_... S7267C14::S7267C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7267C3*), ABISELECT(120,96), "S7267C14");
    /*is_ambiguous_... S7267C14::S7267C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7267C5*)(S7267C3*), ABISELECT(4912,3772), "S7267C14");
    /*is_ambiguous_... S7267C14::S7267C10 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7267C5*)(S7267C10*), ABISELECT(4912,3772), "S7267C14");
    check_base_class_offset(lv, (S7268C4*)(S7267C15*), ABISELECT(4912,3772), "S7267C14");
    check_base_class_offset(lv, (S7268C4*)(S7267C5*)(S7267C10*)(S7267C15*), ABISELECT(4912,3772), "S7267C14");
    /*is_ambiguous_... S7267C14::S7267C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7267C5*)(S7267C3*), ABISELECT(4912,3772), "S7267C14");
    /*is_ambiguous_... S7267C14::S7267C5 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7267C5*), ABISELECT(4912,3772), "S7267C14");
    /*is_ambiguous_... S7267C14::S7267C3 */ AMB_check_base_class_offset(lv, (S7267C5*)(S7267C3*), 0, "S7267C14");
    /*is_ambiguous_... S7267C14::S7267C3 */ AMB_check_base_class_offset(lv, (S7267C6*)(S7267C3*), ABISELECT(4944,3800), "S7267C14");
    /*is_ambiguous_... S7267C14::S7267C3 */ AMB_check_base_class_offset(lv, (S7267C6*)(S7267C3*), ABISELECT(4944,3800), "S7267C14");
    /*is_ambiguous_... S7267C14::S7267C10 */ AMB_check_base_class_offset(lv, (S7267C5*)(S7267C10*), ABISELECT(5816,4464), "S7267C14");
    /*is_ambiguous_... S7267C14::S7267C10 */ AMB_check_base_class_offset(lv, (S7267C11*)(S7267C10*), ABISELECT(6576,5072), "S7267C14");
    check_base_class_offset(lv, (S7267C11*)(S7267C10*)(S7267C15*), ABISELECT(6576,5072), "S7267C14");
    /*is_ambiguous_... S7267C14::S7267C3 */ AMB_check_base_class_offset(lv, (S7267C10*)(S7267C3*), ABISELECT(5816,4464), "S7267C14");
    /*is_ambiguous_... S7267C14::S7267C3 */ AMB_check_base_class_offset(lv, (S7267C10*)(S7267C3*), ABISELECT(5816,4464), "S7267C14");
    /*is_ambiguous_... S7267C14::S7267C3 */ AMB_check_base_class_offset(lv, (S7267C8*)(S7267C3*), ABISELECT(152,124), "S7267C14");
    /*is_ambiguous_... S7267C14::S7267C3 */ AMB_check_base_class_offset(lv, (S7267C3*), 0, "S7267C14");
    check_base_class_offset(lv, (S7267C6*)(S7267C15*), ABISELECT(672,540), "S7267C14");
    check_base_class_offset(lv, (S7267C8*)(S7267C15*), ABISELECT(6744,5168), "S7267C14");
    check_base_class_offset(lv, (S7267C5*)(S7267C10*)(S7267C15*), ABISELECT(1544,1204), "S7267C14");
    check_base_class_offset(lv, (S7267C10*)(S7267C15*), ABISELECT(1544,1204), "S7267C14");
    check_base_class_offset(lv, (S7267C15*), ABISELECT(672,540), "S7267C14");
    /*is_ambiguous_... S7267C14::S7267C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7267C3*), ABISELECT(42008,32476), "S7267C14");
    /*is_ambiguous_... S7267C14::S7267C3 */ AMB_check_base_class_offset(lv, (S7267C5*)(S7267C3*), ABISELECT(41888,32380), "S7267C14");
    /*is_ambiguous_... S7267C14::S7267C3 */ AMB_check_base_class_offset(lv, (S7267C8*)(S7267C3*), ABISELECT(42040,32504), "S7267C14");
    check_base_class_offset(lv, (S7267C3*)(S7267C2*), ABISELECT(41888,32380), "S7267C14");
    check_base_class_offset(lv, (S7267C2*), ABISELECT(7056,5420), "S7267C14");
    /*is_ambiguous_... S7267C14::S7268C4 */ AMB_check_base_class_offset(lv, (S7268C4*), ABISELECT(2408,1872), "S7267C14");
    check_base_class_offset(lv, (S7267C5*)(S7267C13*), ABISELECT(42728,33024), "S7267C14");
    check_base_class_offset(lv, (S7267C11*)(S7267C13*), ABISELECT(42552,32920), "S7267C14");
    check_base_class_offset(lv, (S7267C13*), ABISELECT(42552,32920), "S7267C14");
    check_field_offset(lv, s7267c14f0, ABISELECT(2448,1900), "S7267C14.s7267c14f0");
    check_field_offset(lv, s7267c14f1, ABISELECT(2576,1996), "S7267C14.s7267c14f1");
    check_field_offset(lv, s7267c14f2, ABISELECT(2584,2000), "S7267C14.s7267c14f2");
    check_field_offset(lv, s7267c14f3, ABISELECT(2592,2004), "S7267C14.s7267c14f3");
    check_field_offset(lv, s7267c14f4, ABISELECT(2600,2012), "S7267C14.s7267c14f4");
    check_field_offset(lv, s7267c14f5, ABISELECT(2608,2020), "S7267C14.s7267c14f5");
    check_field_offset(lv, s7267c14f6, ABISELECT(4864,3728), "S7267C14.s7267c14f6");
    check_field_offset(lv, s7267c14f7, ABISELECT(4872,3736), "S7267C14.s7267c14f7");
    check_field_offset(lv, s7267c14f8, ABISELECT(4904,3768), "S7267C14.s7267c14f8");
    test_class_info(&lv, &cd_S7267C14);
    dp->~S7267C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7267C14(Test_S7267C14, "S7267C14", ABISELECT(42848,33120));

#else // __cplusplus

extern void _ZN8S7267C14C1Ev();
extern void _ZN8S7267C14D2Ev();
Name_Map name_map_S7267C14[] = {
  NSPAIR(_ZN8S7267C14C1Ev),
  NSPAIR(_ZN8S7267C14D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7267C5;
extern VTBL_ENTRY _ZTI7S7267C5[];
extern  VTBL_ENTRY _ZTV7S7267C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C5[];
extern Class_Descriptor cd_S7267C6;
extern VTBL_ENTRY _ZTI7S7267C6[];
extern  VTBL_ENTRY _ZTV7S7267C6[];
extern Class_Descriptor cd_S7267C5;
extern VTBL_ENTRY _ZTI7S7267C5[];
extern  VTBL_ENTRY _ZTV7S7267C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C5[];
extern Class_Descriptor cd_S7267C11;
extern VTBL_ENTRY _ZTI8S7267C11[];
extern  VTBL_ENTRY _ZTV8S7267C11[];
extern Class_Descriptor cd_S7267C10;
extern VTBL_ENTRY _ZTI8S7267C10[];
extern  VTBL_ENTRY _ZTV8S7267C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7267C10[];
extern Class_Descriptor cd_S7267C8;
extern VTBL_ENTRY _ZTI7S7267C8[];
extern  VTBL_ENTRY _ZTV7S7267C8[];
extern Class_Descriptor cd_S7267C3;
extern VTBL_ENTRY _ZTI7S7267C3[];
extern  VTBL_ENTRY _ZTV7S7267C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C3[];
extern Class_Descriptor cd_S7267C6;
extern VTBL_ENTRY _ZTI7S7267C6[];
extern  VTBL_ENTRY _ZTV7S7267C6[];
extern Class_Descriptor cd_S7267C8;
extern VTBL_ENTRY _ZTI7S7267C8[];
extern  VTBL_ENTRY _ZTV7S7267C8[];
extern Class_Descriptor cd_S7267C5;
extern VTBL_ENTRY _ZTI7S7267C5[];
extern  VTBL_ENTRY _ZTV7S7267C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C5[];
extern Class_Descriptor cd_S7267C10;
extern VTBL_ENTRY _ZTI8S7267C10[];
extern  VTBL_ENTRY _ZTV8S7267C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7267C10[];
extern Class_Descriptor cd_S7267C15;
extern VTBL_ENTRY _ZTI8S7267C15[];
extern  VTBL_ENTRY _ZTV8S7267C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7267C15[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7267C5;
extern VTBL_ENTRY _ZTI7S7267C5[];
extern  VTBL_ENTRY _ZTV7S7267C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C5[];
extern Class_Descriptor cd_S7267C8;
extern VTBL_ENTRY _ZTI7S7267C8[];
extern  VTBL_ENTRY _ZTV7S7267C8[];
extern Class_Descriptor cd_S7267C3;
extern VTBL_ENTRY _ZTI7S7267C3[];
extern  VTBL_ENTRY _ZTV7S7267C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C3[];
extern Class_Descriptor cd_S7267C2;
extern VTBL_ENTRY _ZTI7S7267C2[];
extern  VTBL_ENTRY _ZTV7S7267C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C2[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7267C5;
extern VTBL_ENTRY _ZTI7S7267C5[];
extern  VTBL_ENTRY _ZTV7S7267C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C5[];
extern Class_Descriptor cd_S7267C11;
extern VTBL_ENTRY _ZTI8S7267C11[];
extern  VTBL_ENTRY _ZTV8S7267C11[];
extern Class_Descriptor cd_S7267C13;
extern VTBL_ENTRY _ZTI8S7267C13[];
extern  VTBL_ENTRY _ZTV8S7267C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7267C13[];
static Base_Class bases_S7267C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7268C4,    ABISELECT(120,96), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7268C4,    ABISELECT(4912,3772), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S7267C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7267C6,    ABISELECT(4944,3800), //bcp->offset
    33, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S7267C5,    ABISELECT(5816,4464), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S7267C11,    ABISELECT(6576,5072), //bcp->offset
    48, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S7267C10,    ABISELECT(5816,4464), //bcp->offset
    39, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S7267C8,    ABISELECT(152,124), //bcp->offset
    14, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7267C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7267C6,    ABISELECT(672,540), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S7267C8,    ABISELECT(6744,5168), //bcp->offset
    54, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S7267C5,    ABISELECT(1544,1204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S7267C10,    ABISELECT(1544,1204), //bcp->offset
    26, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S7267C15,    ABISELECT(672,540), //bcp->offset
    17, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7268C4,    ABISELECT(42008,32476), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S7267C5,    ABISELECT(41888,32380), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S7267C8,    ABISELECT(42040,32504), //bcp->offset
    80, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S7267C3,    ABISELECT(41888,32380), //bcp->offset
    70, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    18, //immediately_derived
  0, 1},
  {&cd_S7267C2,    ABISELECT(7056,5420), //bcp->offset
    58, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7268C4,    ABISELECT(2408,1872), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7267C5,    ABISELECT(42728,33024), //bcp->offset
    96, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    41, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    22, //immediately_derived
  0, 1},
  {&cd_S7267C11,    ABISELECT(42552,32920), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S7267C13,    ABISELECT(42552,32920), //bcp->offset
    83, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    39, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7267C14[];
extern void _ZN8S7267C14D1Ev();
extern void _ZN8S7267C14D0Ev();
extern void _ZN8S7267C143v10Ev();
extern void _ZN7S7267C82v7Ev();
extern void _ZN7S7267C62v2Ev();
extern void _ZN7S7267C62v3Ev();
extern void ABISELECT(_ZThn672_N8S7267C14D1Ev,_ZThn540_N8S7267C14D1Ev)();
extern void ABISELECT(_ZThn672_N8S7267C14D0Ev,_ZThn540_N8S7267C14D0Ev)();
extern void ABISELECT(_ZThn1544_N8S7267C14D1Ev,_ZThn1204_N8S7267C14D1Ev)();
extern void ABISELECT(_ZThn1544_N8S7267C14D0Ev,_ZThn1204_N8S7267C14D0Ev)();
extern void _ZN8S7267C102v6Ev();
extern void _ZN7S7267C62v2Ev();
extern void _ZN7S7267C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S7267C14D1Ev,_ZTv0_n20_N8S7267C14D1Ev)();
extern void ABISELECT(_ZThn5816_N8S7267C14D1Ev,_ZThn4464_N8S7267C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7267C14D0Ev,_ZTv0_n20_N8S7267C14D0Ev)();
extern void ABISELECT(_ZThn5816_N8S7267C14D0Ev,_ZThn4464_N8S7267C14D0Ev)() __attribute__((weak));
extern void _ZN8S7267C102v6Ev();
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
extern void _ZN7S7267C82v7Ev();
extern void _ZN7S7267C22v8Ev();
extern void ABISELECT(_ZTv0_n72_N8S7267C14D1Ev,_ZTv0_n36_N8S7267C14D1Ev)();
extern void ABISELECT(_ZThn7056_N8S7267C14D1Ev,_ZThn5420_N8S7267C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S7267C14D0Ev,_ZTv0_n36_N8S7267C14D0Ev)();
extern void ABISELECT(_ZThn7056_N8S7267C14D0Ev,_ZThn5420_N8S7267C14D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7267C14D1Ev,_ZTv0_n28_N8S7267C14D1Ev)();
extern void ABISELECT(_ZThn41888_N8S7267C14D1Ev,_ZThn32380_N8S7267C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7267C14D0Ev,_ZTv0_n28_N8S7267C14D0Ev)();
extern void ABISELECT(_ZThn41888_N8S7267C14D0Ev,_ZThn32380_N8S7267C14D0Ev)() __attribute__((weak));
extern void _ZN7S7267C82v7Ev();
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
extern void _ZN8S7267C132v9Ev();
extern void ABISELECT(_ZTv0_n64_N8S7267C14D1Ev,_ZTv0_n32_N8S7267C14D1Ev)();
extern void ABISELECT(_ZThn42552_N8S7267C14D1Ev,_ZThn32920_N8S7267C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S7267C14D0Ev,_ZTv0_n32_N8S7267C14D0Ev)();
extern void ABISELECT(_ZThn42552_N8S7267C14D0Ev,_ZThn32920_N8S7267C14D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7267C14D1Ev,_ZTv0_n16_N8S7267C14D1Ev)();
extern void ABISELECT(_ZThn42728_N8S7267C14D1Ev,_ZThn33024_N8S7267C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7267C14D0Ev,_ZTv0_n16_N8S7267C14D0Ev)();
extern void ABISELECT(_ZThn42728_N8S7267C14D0Ev,_ZThn33024_N8S7267C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7267C14[] = {
  ABISELECT(42728,33024),
  ABISELECT(42552,32920),
  ABISELECT(41888,32380),
  ABISELECT(7056,5420),
  ABISELECT(6744,5168),
  ABISELECT(6576,5072),
  ABISELECT(5816,4464),
  ABISELECT(4944,3800),
  ABISELECT(4912,3772),
  0,
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&_ZN8S7267C14D1Ev,
  (VTBL_ENTRY)&_ZN8S7267C14D0Ev,
  (VTBL_ENTRY)&_ZN8S7267C143v10Ev,
  ABISELECT(-152,-124),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&_ZN7S7267C82v7Ev,
  ABISELECT(5904,4532),
  ABISELECT(4240,3232),
  ABISELECT(6072,4628),
  ABISELECT(-672,-540),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&_ZN7S7267C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7267C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S7267C14D1Ev,_ZThn540_N8S7267C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S7267C14D0Ev,_ZThn540_N8S7267C14D0Ev),
  ABISELECT(5032,3868),
  ABISELECT(3368,2568),
  ABISELECT(-1544,-1204),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1544_N8S7267C14D1Ev,_ZThn1204_N8S7267C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1544_N8S7267C14D0Ev,_ZThn1204_N8S7267C14D0Ev),
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
  0,
  0,
  ABISELECT(-4944,-3800),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&_ZN7S7267C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7267C62v3Ev,
  0,
  ABISELECT(-5816,-4464),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-5816,-4464),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7267C14D1Ev,_ZTv0_n20_N8S7267C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7267C14D0Ev,_ZTv0_n20_N8S7267C14D0Ev),
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
  0,
  0,
  ABISELECT(-6576,-5072),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
  0,
  ABISELECT(-6744,-5168),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&_ZN7S7267C82v7Ev,
  ABISELECT(-7056,-5420),
  0,
  ABISELECT(-480,-348),
  ABISELECT(-1240,-956),
  ABISELECT(-2112,-1620),
  ABISELECT(-2144,-1648),
  ABISELECT(34832,26960),
  ABISELECT(-7056,-5420),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&_ZN7S7267C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S7267C14D1Ev,_ZTv0_n36_N8S7267C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S7267C14D0Ev,_ZTv0_n36_N8S7267C14D0Ev),
  ABISELECT(152,124),
  ABISELECT(-41888,-32380),
  ABISELECT(-35312,-27308),
  ABISELECT(-36072,-27916),
  ABISELECT(-36944,-28580),
  ABISELECT(-36976,-28608),
  ABISELECT(-41888,-32380),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7267C14D1Ev,_ZTv0_n28_N8S7267C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7267C14D0Ev,_ZTv0_n28_N8S7267C14D0Ev),
  ABISELECT(-42040,-32504),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&_ZN7S7267C82v7Ev,
  ABISELECT(-42552,-32920),
  0,
  0,
  0,
  ABISELECT(-37640,-29148),
  ABISELECT(176,104),
  ABISELECT(-42552,-32920),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
  (VTBL_ENTRY)&_ZN8S7267C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7267C14D1Ev,_ZTv0_n32_N8S7267C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7267C14D0Ev,_ZTv0_n32_N8S7267C14D0Ev),
  ABISELECT(-42728,-33024),
  ABISELECT(-37816,-29252),
  ABISELECT(-42728,-33024),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7267C14D1Ev,_ZTv0_n16_N8S7267C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7267C14D0Ev,_ZTv0_n16_N8S7267C14D0Ev),
};
extern VTBL_ENTRY _ZTV8S7267C14[];
extern void _ZN7S7267C3D1Ev();
extern void _ZN7S7267C3D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C3__A__8S7267C14[] = {
  ABISELECT(6576,5072),
  ABISELECT(5816,4464),
  ABISELECT(4944,3800),
  ABISELECT(4912,3772),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&_ZN7S7267C3D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C3D0Ev,
};
extern void _ZN7S7267C5D1Ev();
extern void _ZN7S7267C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C57S7267C3__8S7267C14[] = {
  ABISELECT(4912,3772),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C5[0]),
  (VTBL_ENTRY)&_ZN7S7267C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C5D0Ev,
};
extern void _ZN7S7267C62v2Ev();
extern void _ZN7S7267C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C6__7S7267C3__A__8S7267C14[] = {
  0,
  0,
  ABISELECT(-4944,-3800),
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&_ZN7S7267C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7267C62v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S7267C3D1Ev,_ZTv0_n20_N7S7267C3D1Ev)();
extern void ABISELECT(_ZThn5816_N7S7267C3D1Ev,_ZThn4464_N7S7267C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S7267C3D0Ev,_ZTv0_n20_N7S7267C3D0Ev)();
extern void ABISELECT(_ZThn5816_N7S7267C3D0Ev,_ZThn4464_N7S7267C3D0Ev)() __attribute__((weak));
extern void _ZN8S7267C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C10__7S7267C3__A__8S7267C14[] = {
  0,
  ABISELECT(-5816,-4464),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-5816,-4464),
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7267C3D1Ev,_ZTv0_n20_N7S7267C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7267C3D0Ev,_ZTv0_n20_N7S7267C3D0Ev),
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C11__7S7267C3__A__8S7267C14[] = {
  0,
  0,
  ABISELECT(-6576,-5072),
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
};
extern void _ZN7S7267C62v2Ev();
extern void _ZN7S7267C62v3Ev();
extern void _ZN8S7267C15D1Ev();
extern void _ZN8S7267C15D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C15__8S7267C14[] = {
  ABISELECT(5904,4532),
  ABISELECT(4240,3232),
  ABISELECT(6072,4628),
  0,
  (VTBL_ENTRY)&(_ZTI8S7267C15[0]),
  (VTBL_ENTRY)&_ZN7S7267C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7267C62v3Ev,
  (VTBL_ENTRY)&_ZN8S7267C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7267C15D0Ev,
};
extern void _ZN8S7267C10D1Ev();
extern void _ZN8S7267C10D0Ev();
extern void _ZN8S7267C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C108S7267C15__A1__8S7267C14[] = {
  ABISELECT(5032,3868),
  ABISELECT(3368,2568),
  0,
  (VTBL_ENTRY)&(_ZTI8S7267C10[0]),
  (VTBL_ENTRY)&_ZN8S7267C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7267C10D0Ev,
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
};
extern void _ZN7S7267C5D1Ev();
extern void _ZN7S7267C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C58S7267C108S7267C15__A2__8S7267C14[] = {
  ABISELECT(3368,2568),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C5[0]),
  (VTBL_ENTRY)&_ZN7S7267C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C5D0Ev,
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C11__8S7267C108S7267C15__A1__8S7267C14[] = {
  0,
  0,
  ABISELECT(-5032,-3868),
  (VTBL_ENTRY)&(_ZTI8S7267C10[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
};
extern void _ZN7S7267C82v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C8__8S7267C15__8S7267C14[] = {
  0,
  ABISELECT(-6072,-4628),
  (VTBL_ENTRY)&(_ZTI8S7267C15[0]),
  (VTBL_ENTRY)&_ZN7S7267C82v7Ev,
};
extern void ABISELECT(_ZThn872_N8S7267C15D1Ev,_ZThn664_N8S7267C15D1Ev)();
extern void ABISELECT(_ZThn872_N8S7267C15D0Ev,_ZThn664_N8S7267C15D0Ev)();
extern void _ZN8S7267C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C10__8S7267C15__8S7267C14[] = {
  ABISELECT(5032,3868),
  ABISELECT(3368,2568),
  ABISELECT(-872,-664),
  (VTBL_ENTRY)&(_ZTI8S7267C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn872_N8S7267C15D1Ev,_ZThn664_N8S7267C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn872_N8S7267C15D0Ev,_ZThn664_N8S7267C15D0Ev),
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C11__8S7267C15__8S7267C14[] = {
  0,
  0,
  ABISELECT(-5904,-4532),
  (VTBL_ENTRY)&(_ZTI8S7267C15[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
};
extern void _ZN8S7267C10D1Ev();
extern void _ZN8S7267C10D0Ev();
extern void _ZN8S7267C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C10__8S7267C14[] = {
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  0,
  (VTBL_ENTRY)&(_ZTI8S7267C10[0]),
  (VTBL_ENTRY)&_ZN8S7267C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7267C10D0Ev,
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
};
extern void _ZN7S7267C5D1Ev();
extern void _ZN7S7267C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C58S7267C10__A1__8S7267C14[] = {
  ABISELECT(-904,-692),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C5[0]),
  (VTBL_ENTRY)&_ZN7S7267C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C5D0Ev,
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C11__8S7267C10__8S7267C14[] = {
  0,
  0,
  ABISELECT(-760,-608),
  (VTBL_ENTRY)&(_ZTI8S7267C10[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
};
extern void _ZN7S7267C22v8Ev();
extern void _ZN7S7267C2D1Ev();
extern void _ZN7S7267C2D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C2__8S7267C14[] = {
  ABISELECT(-480,-348),
  ABISELECT(-1240,-956),
  ABISELECT(-2112,-1620),
  ABISELECT(-2144,-1648),
  ABISELECT(34832,26960),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C2[0]),
  (VTBL_ENTRY)&_ZN7S7267C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7267C2D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C2D0Ev,
};
extern void ABISELECT(_ZTv0_n56_N7S7267C2D1Ev,_ZTv0_n28_N7S7267C2D1Ev)();
extern void ABISELECT(_ZThn34832_N7S7267C2D1Ev,_ZThn26960_N7S7267C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N7S7267C2D0Ev,_ZTv0_n28_N7S7267C2D0Ev)();
extern void ABISELECT(_ZThn34832_N7S7267C2D0Ev,_ZThn26960_N7S7267C2D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7267C3__7S7267C2__8S7267C14[] = {
  ABISELECT(152,124),
  ABISELECT(-34832,-26960),
  ABISELECT(-35312,-27308),
  ABISELECT(-36072,-27916),
  ABISELECT(-36944,-28580),
  ABISELECT(-36976,-28608),
  ABISELECT(-34832,-26960),
  (VTBL_ENTRY)&(_ZTI7S7267C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7267C2D1Ev,_ZTv0_n28_N7S7267C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7267C2D0Ev,_ZTv0_n28_N7S7267C2D0Ev),
};
extern void _ZN7S7267C62v2Ev();
extern void _ZN7S7267C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C6__7S7267C2__8S7267C14[] = {
  0,
  0,
  ABISELECT(2112,1620),
  (VTBL_ENTRY)&(_ZTI7S7267C2[0]),
  (VTBL_ENTRY)&_ZN7S7267C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7267C62v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S7267C2D1Ev,_ZTv0_n20_N7S7267C2D1Ev)();
extern void ABISELECT(_ZTv0_n40_N7S7267C2D0Ev,_ZTv0_n20_N7S7267C2D0Ev)();
extern void _ZN8S7267C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C10__7S7267C2__8S7267C14[] = {
  0,
  ABISELECT(1240,956),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(1240,956),
  (VTBL_ENTRY)&(_ZTI7S7267C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7267C2D1Ev,_ZTv0_n20_N7S7267C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7267C2D0Ev,_ZTv0_n20_N7S7267C2D0Ev),
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C11__7S7267C2__8S7267C14[] = {
  0,
  0,
  ABISELECT(480,348),
  (VTBL_ENTRY)&(_ZTI7S7267C2[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
};
extern void _ZN7S7267C82v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C87S7267C3__7S7267C2__8S7267C14[] = {
  ABISELECT(-34984,-27084),
  (VTBL_ENTRY)&(_ZTI7S7267C2[0]),
  (VTBL_ENTRY)&_ZN7S7267C82v7Ev,
};
extern void _ZN7S7267C3D1Ev();
extern void _ZN7S7267C3D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C3__A1__8S7267C14[] = {
  ABISELECT(-35312,-27308),
  ABISELECT(-36072,-27916),
  ABISELECT(-36944,-28580),
  ABISELECT(-36976,-28608),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&_ZN7S7267C3D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C3D0Ev,
};
extern void _ZN7S7267C5D1Ev();
extern void _ZN7S7267C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C57S7267C3__A3__8S7267C14[] = {
  ABISELECT(-36976,-28608),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C5[0]),
  (VTBL_ENTRY)&_ZN7S7267C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C5D0Ev,
};
extern void _ZN7S7267C62v2Ev();
extern void _ZN7S7267C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C6__7S7267C3__A1__8S7267C14[] = {
  0,
  0,
  ABISELECT(36944,28580),
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&_ZN7S7267C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7267C62v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S7267C3D1Ev,_ZTv0_n20_N7S7267C3D1Ev)();
extern void ABISELECT(_ZTv0_n40_N7S7267C3D0Ev,_ZTv0_n20_N7S7267C3D0Ev)();
extern void _ZN8S7267C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C10__7S7267C3__A1__8S7267C14[] = {
  0,
  ABISELECT(36072,27916),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(36072,27916),
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7267C3D1Ev,_ZTv0_n20_N7S7267C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7267C3D0Ev,_ZTv0_n20_N7S7267C3D0Ev),
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C11__7S7267C3__A1__8S7267C14[] = {
  0,
  0,
  ABISELECT(35312,27308),
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
extern void _ZN8S7267C132v9Ev();
extern void _ZN8S7267C13D1Ev();
extern void _ZN8S7267C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C13__8S7267C14[] = {
  ABISELECT(-37640,-29148),
  ABISELECT(176,104),
  0,
  (VTBL_ENTRY)&(_ZTI8S7267C13[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
  (VTBL_ENTRY)&_ZN8S7267C132v9Ev,
  (VTBL_ENTRY)&_ZN8S7267C13D1Ev,
  (VTBL_ENTRY)&_ZN8S7267C13D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S7267C13D1Ev,_ZTv0_n16_N8S7267C13D1Ev)();
extern void ABISELECT(_ZThn176_N8S7267C13D1Ev,_ZThn104_N8S7267C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7267C13D0Ev,_ZTv0_n16_N8S7267C13D0Ev)();
extern void ABISELECT(_ZThn176_N8S7267C13D0Ev,_ZThn104_N8S7267C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7267C5__8S7267C13__8S7267C14[] = {
  ABISELECT(-176,-104),
  ABISELECT(-37816,-29252),
  ABISELECT(-176,-104),
  (VTBL_ENTRY)&(_ZTI8S7267C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7267C13D1Ev,_ZTv0_n16_N8S7267C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7267C13D0Ev,_ZTv0_n16_N8S7267C13D0Ev),
};
extern void _ZN7S7267C5D1Ev();
extern void _ZN7S7267C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C5__A4__8S7267C14[] = {
  ABISELECT(-37816,-29252),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C5[0]),
  (VTBL_ENTRY)&_ZN7S7267C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C5D0Ev,
};
static  VTT_ENTRY vtt_S7267C14[] = {
  {&(_ZTV8S7267C14[11]),  11,102},
  {&(_tg__ZTV7S7267C3__A__8S7267C14[6]),  6,8},
  {&(_tg__ZTV7S7267C57S7267C3__8S7267C14[3]),  3,5},
  {&(_tg__ZTV7S7267C6__7S7267C3__A__8S7267C14[4]),  4,6},
  {&(_tg__ZTV8S7267C10__7S7267C3__A__8S7267C14[6]),  6,9},
  {&(_tg__ZTV8S7267C11__7S7267C3__A__8S7267C14[4]),  4,6},
  {&(_tg__ZTV8S7267C15__8S7267C14[5]),  5,9},
  {&(_tg__ZTV8S7267C108S7267C15__A1__8S7267C14[4]),  4,7},
  {&(_tg__ZTV7S7267C58S7267C108S7267C15__A2__8S7267C14[3]),  3,5},
  {&(_tg__ZTV8S7267C11__8S7267C108S7267C15__A1__8S7267C14[4]),  4,6},
  {&(_tg__ZTV7S7267C8__8S7267C15__8S7267C14[3]),  3,4},
  {&(_tg__ZTV8S7267C10__8S7267C15__8S7267C14[4]),  4,7},
  {&(_tg__ZTV8S7267C11__8S7267C15__8S7267C14[4]),  4,6},
  {&(_ZTV8S7267C14[37]),  37,102},
  {&(_ZTV8S7267C14[45]),  45,102},
  {&(_ZTV8S7267C14[52]),  52,102},
  {&(_ZTV8S7267C14[22]),  22,102},
  {&(_ZTV8S7267C14[57]),  57,102},
  {&(_ZTV8S7267C14[30]),  30,102},
  {&(_ZTV8S7267C14[67]),  67,102},
  {&(_ZTV8S7267C14[78]),  78,102},
  {&(_ZTV8S7267C14[82]),  82,102},
  {&(_ZTV8S7267C14[91]),  91,102},
  {&(_ZTV8S7267C14[100]),  100,102},
  {&(_tg__ZTV8S7267C10__8S7267C14[4]),  4,7},
  {&(_tg__ZTV7S7267C58S7267C10__A1__8S7267C14[3]),  3,5},
  {&(_tg__ZTV8S7267C11__8S7267C10__8S7267C14[4]),  4,6},
  {&(_tg__ZTV7S7267C2__8S7267C14[7]),  7,10},
  {&(_tg__ZTV7S7267C3__7S7267C2__8S7267C14[8]),  8,10},
  {&(_tg__ZTV7S7267C6__7S7267C2__8S7267C14[4]),  4,6},
  {&(_tg__ZTV8S7267C10__7S7267C2__8S7267C14[6]),  6,9},
  {&(_tg__ZTV8S7267C11__7S7267C2__8S7267C14[4]),  4,6},
  {&(_tg__ZTV7S7267C87S7267C3__7S7267C2__8S7267C14[2]),  2,3},
  {&(_tg__ZTV7S7267C3__A1__8S7267C14[6]),  6,8},
  {&(_tg__ZTV7S7267C57S7267C3__A3__8S7267C14[3]),  3,5},
  {&(_tg__ZTV7S7267C6__7S7267C3__A1__8S7267C14[4]),  4,6},
  {&(_tg__ZTV8S7267C10__7S7267C3__A1__8S7267C14[6]),  6,9},
  {&(_tg__ZTV8S7267C11__7S7267C3__A1__8S7267C14[4]),  4,6},
  {&(_tg__ZTV8S7267C13__8S7267C14[4]),  4,9},
  {&(_tg__ZTV7S7267C5__8S7267C13__8S7267C14[4]),  4,6},
  {&(_tg__ZTV7S7267C5__A4__8S7267C14[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S7267C14[];
extern  VTBL_ENTRY _ZTV8S7267C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7267C14[];
static VTBL_ENTRY alt_thunk_names11[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7267C13D0Ev,_ZTv0_n16_N8S7267C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7267C13D0Ev,_ZThn104_N8S7267C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7267C13D1Ev,_ZTv0_n16_N8S7267C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7267C13D1Ev,_ZThn104_N8S7267C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7267C2D0Ev,_ZTv0_n28_N7S7267C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn34832_N7S7267C2D0Ev,_ZThn26960_N7S7267C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7267C2D1Ev,_ZTv0_n28_N7S7267C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn34832_N7S7267C2D1Ev,_ZThn26960_N7S7267C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7267C3D0Ev,_ZTv0_n20_N7S7267C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5816_N7S7267C3D0Ev,_ZThn4464_N7S7267C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7267C3D1Ev,_ZTv0_n20_N7S7267C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5816_N7S7267C3D1Ev,_ZThn4464_N7S7267C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7267C14D0Ev,_ZTv0_n16_N8S7267C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn42728_N8S7267C14D0Ev,_ZThn33024_N8S7267C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7267C14D1Ev,_ZTv0_n16_N8S7267C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn42728_N8S7267C14D1Ev,_ZThn33024_N8S7267C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S7267C14D0Ev,_ZTv0_n32_N8S7267C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn42552_N8S7267C14D0Ev,_ZThn32920_N8S7267C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S7267C14D1Ev,_ZTv0_n32_N8S7267C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn42552_N8S7267C14D1Ev,_ZThn32920_N8S7267C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7267C14D0Ev,_ZTv0_n28_N8S7267C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn41888_N8S7267C14D0Ev,_ZThn32380_N8S7267C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7267C14D1Ev,_ZTv0_n28_N8S7267C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn41888_N8S7267C14D1Ev,_ZThn32380_N8S7267C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S7267C14D0Ev,_ZTv0_n36_N8S7267C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7056_N8S7267C14D0Ev,_ZThn5420_N8S7267C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S7267C14D1Ev,_ZTv0_n36_N8S7267C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7056_N8S7267C14D1Ev,_ZThn5420_N8S7267C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7267C14D0Ev,_ZTv0_n20_N8S7267C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5816_N8S7267C14D0Ev,_ZThn4464_N8S7267C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7267C14D1Ev,_ZTv0_n20_N8S7267C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5816_N8S7267C14D1Ev,_ZThn4464_N8S7267C14D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7267C14 = {  "S7267C14", // class name
  bases_S7267C14, 23,
  &(vtc_S7267C14[0]), // expected_vtbl_contents
  &(vtt_S7267C14[0]), // expected_vtt_contents
  ABISELECT(42848,33120), // object size
  NSPAIRA(_ZTI8S7267C14),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S7267C14),102, //virtual function table var
  11, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7267C14),41, //virtual table table var
  19, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names11,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7267C12  : virtual S7267C13 , S7267C14 , S7267C11 {
  ::S7268C17_nt s7267c12f0;
  ~S7267C12(); // tgen
  S7267C12(); // tgen
};
//SIG(-1 S7267C12) C1{ VBC2{ VBC3{ VBC4{ m Fs[6] FL Fc[5]} vd FC4 Fi Fp FC4[2]} BC5{ v1 v2 Fi Fp[2] Fl Fp[3] Fl[6] FC4 Fi Fp Fc[2]} v3 Fi Fp} BC6{ BC7{ BC4 BC3 VBC8{ v4 v5 FC4 Fc FC9{ BC10{ v10 FU11{ m Fl Fp[4] Fi} Fp FC4[8] Fp} VBC4 BC12{ VBC4 vd FC4 Fi Fp FC4[2]} Fp[5] Fc:0 Fi Fi Fi:10 Fc[8] Fs Fi Fp[10] FC12 FL Fi Fp} Fp Fi Fi Fp Fi Fi:11 Fi} VBC13{ BC3 VBC5 vd v6 Fl[4] FC3[4]} BC14{ v7 FU11 Fp FC4[8] Fp} Fp Fi[6] FL FC3 Fc} BC15{ BC8 VBC14 VBC4 BC13 vd Fi Fi Fc[4] Fp[3] Fs Fi Fi FD Fp Fp Fi} VBC16{ VBC7 v8 FC4 FC13[5] FC7[10] FL[4] Fc FC7 FC7} BC4 VBC2 vd v9 FU17{ m Fi Fc[7] Fi[10] Fi FD[8] Fi Fp Fi} Fp Fi FL FL FC15 FL Fi[8] Fi} BC5 FC18{}}


S7267C12 ::~S7267C12(){ note_dtor("S7267C12", this);} // tgen
S7267C12 ::S7267C12(){ note_ctor("S7267C12", this);} // tgen

static void Test_S7267C12()
{
  extern Class_Descriptor cd_S7267C12;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(2690,8305)];
    init_test(&cd_S7267C12, buf);
    S7267C12 *dp, &lv = *(dp=new (buf) S7267C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(43024,33216), "sizeof(S7267C12)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7267C12)");
    /*is_ambiguous_... S7267C12::S7267C5 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7267C5*), ABISELECT(5376,4068), "S7267C12");
    /*is_ambiguous_... S7267C14::S7267C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7267C5*)(S7267C3*)(S7267C14*), ABISELECT(5376,4068), "S7267C12");
    /*is_ambiguous_... S7267C12::S7267C10 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7267C5*)(S7267C10*), ABISELECT(5376,4068), "S7267C12");
    check_base_class_offset(lv, (S7268C4*)(S7267C15*)(S7267C14*), ABISELECT(5376,4068), "S7267C12");
    check_base_class_offset(lv, (S7268C4*)(S7267C5*)(S7267C10*)(S7267C15*)(S7267C14*), ABISELECT(5376,4068), "S7267C12");
    /*is_ambiguous_... S7267C12::S7267C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7267C5*)(S7267C3*), ABISELECT(5376,4068), "S7267C12");
    check_base_class_offset(lv, (S7267C5*)(S7267C13*), ABISELECT(5256,3972), "S7267C12");
    check_base_class_offset(lv, (S7267C11*)(S7267C13*), ABISELECT(5080,3868), "S7267C12");
    check_base_class_offset(lv, (S7267C13*), ABISELECT(5080,3868), "S7267C12");
    check_base_class_offset(lv, (S7267C13*)(S7267C14*), ABISELECT(5080,3868), "S7267C12");
    /*is_ambiguous_... S7267C14::S7267C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7267C3*)(S7267C14*), ABISELECT(120,96), "S7267C12");
    /*is_ambiguous_... S7267C14::S7267C3 */ AMB_check_base_class_offset(lv, (S7267C5*)(S7267C3*)(S7267C14*), 0, "S7267C12");
    /*is_ambiguous_... S7267C14::S7267C3 */ AMB_check_base_class_offset(lv, (S7267C6*)(S7267C3*)(S7267C14*), ABISELECT(5408,4096), "S7267C12");
    /*is_ambiguous_... S7267C12::S7267C3 */ AMB_check_base_class_offset(lv, (S7267C6*)(S7267C3*), ABISELECT(5408,4096), "S7267C12");
    /*is_ambiguous_... S7267C12::S7267C10 */ AMB_check_base_class_offset(lv, (S7267C5*)(S7267C10*), ABISELECT(6280,4760), "S7267C12");
    /*is_ambiguous_... S7267C12::S7267C10 */ AMB_check_base_class_offset(lv, (S7267C11*)(S7267C10*), ABISELECT(7040,5368), "S7267C12");
    check_base_class_offset(lv, (S7267C11*)(S7267C10*)(S7267C15*)(S7267C14*), ABISELECT(7040,5368), "S7267C12");
    /*is_ambiguous_... S7267C14::S7267C3 */ AMB_check_base_class_offset(lv, (S7267C10*)(S7267C3*)(S7267C14*), ABISELECT(6280,4760), "S7267C12");
    /*is_ambiguous_... S7267C12::S7267C3 */ AMB_check_base_class_offset(lv, (S7267C10*)(S7267C3*), ABISELECT(6280,4760), "S7267C12");
    /*is_ambiguous_... S7267C14::S7267C3 */ AMB_check_base_class_offset(lv, (S7267C8*)(S7267C3*)(S7267C14*), ABISELECT(152,124), "S7267C12");
    /*is_ambiguous_... S7267C14::S7267C3 */ AMB_check_base_class_offset(lv, (S7267C3*)(S7267C14*), 0, "S7267C12");
    check_base_class_offset(lv, (S7267C6*)(S7267C15*)(S7267C14*), ABISELECT(672,540), "S7267C12");
    check_base_class_offset(lv, (S7267C8*)(S7267C15*)(S7267C14*), ABISELECT(7208,5464), "S7267C12");
    check_base_class_offset(lv, (S7267C5*)(S7267C10*)(S7267C15*)(S7267C14*), ABISELECT(1544,1204), "S7267C12");
    check_base_class_offset(lv, (S7267C10*)(S7267C15*)(S7267C14*), ABISELECT(1544,1204), "S7267C12");
    check_base_class_offset(lv, (S7267C15*)(S7267C14*), ABISELECT(672,540), "S7267C12");
    /*is_ambiguous_... S7267C12::S7267C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7267C3*), ABISELECT(42472,32772), "S7267C12");
    /*is_ambiguous_... S7267C12::S7267C3 */ AMB_check_base_class_offset(lv, (S7267C5*)(S7267C3*), ABISELECT(42352,32676), "S7267C12");
    /*is_ambiguous_... S7267C12::S7267C3 */ AMB_check_base_class_offset(lv, (S7267C8*)(S7267C3*), ABISELECT(42504,32800), "S7267C12");
    check_base_class_offset(lv, (S7267C3*)(S7267C2*), ABISELECT(42352,32676), "S7267C12");
    check_base_class_offset(lv, (S7267C2*)(S7267C14*), ABISELECT(7520,5716), "S7267C12");
    /*is_ambiguous_... S7267C14::S7268C4 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7267C14*), ABISELECT(2408,1872), "S7267C12");
    check_base_class_offset(lv, (S7267C14*), 0, "S7267C12");
    /*is_ambiguous_... S7267C12::S7267C11 */ AMB_check_base_class_offset(lv, (S7267C11*), ABISELECT(4912,3772), "S7267C12");
    check_field_offset(lv, s7267c12f0, ABISELECT(5074,3866), "S7267C12.s7267c12f0");
    test_class_info(&lv, &cd_S7267C12);
    dp->~S7267C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7267C12(Test_S7267C12, "S7267C12", ABISELECT(43024,33216));

#else // __cplusplus

extern void _ZN8S7267C12C1Ev();
extern void _ZN8S7267C12D1Ev();
Name_Map name_map_S7267C12[] = {
  NSPAIR(_ZN8S7267C12C1Ev),
  NSPAIR(_ZN8S7267C12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7267C5;
extern VTBL_ENTRY _ZTI7S7267C5[];
extern  VTBL_ENTRY _ZTV7S7267C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C5[];
extern Class_Descriptor cd_S7267C11;
extern VTBL_ENTRY _ZTI8S7267C11[];
extern  VTBL_ENTRY _ZTV8S7267C11[];
extern Class_Descriptor cd_S7267C13;
extern VTBL_ENTRY _ZTI8S7267C13[];
extern  VTBL_ENTRY _ZTV8S7267C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7267C13[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7267C5;
extern VTBL_ENTRY _ZTI7S7267C5[];
extern  VTBL_ENTRY _ZTV7S7267C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C5[];
extern Class_Descriptor cd_S7267C6;
extern VTBL_ENTRY _ZTI7S7267C6[];
extern  VTBL_ENTRY _ZTV7S7267C6[];
extern Class_Descriptor cd_S7267C5;
extern VTBL_ENTRY _ZTI7S7267C5[];
extern  VTBL_ENTRY _ZTV7S7267C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C5[];
extern Class_Descriptor cd_S7267C11;
extern VTBL_ENTRY _ZTI8S7267C11[];
extern  VTBL_ENTRY _ZTV8S7267C11[];
extern Class_Descriptor cd_S7267C10;
extern VTBL_ENTRY _ZTI8S7267C10[];
extern  VTBL_ENTRY _ZTV8S7267C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7267C10[];
extern Class_Descriptor cd_S7267C8;
extern VTBL_ENTRY _ZTI7S7267C8[];
extern  VTBL_ENTRY _ZTV7S7267C8[];
extern Class_Descriptor cd_S7267C3;
extern VTBL_ENTRY _ZTI7S7267C3[];
extern  VTBL_ENTRY _ZTV7S7267C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C3[];
extern Class_Descriptor cd_S7267C6;
extern VTBL_ENTRY _ZTI7S7267C6[];
extern  VTBL_ENTRY _ZTV7S7267C6[];
extern Class_Descriptor cd_S7267C8;
extern VTBL_ENTRY _ZTI7S7267C8[];
extern  VTBL_ENTRY _ZTV7S7267C8[];
extern Class_Descriptor cd_S7267C5;
extern VTBL_ENTRY _ZTI7S7267C5[];
extern  VTBL_ENTRY _ZTV7S7267C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C5[];
extern Class_Descriptor cd_S7267C10;
extern VTBL_ENTRY _ZTI8S7267C10[];
extern  VTBL_ENTRY _ZTV8S7267C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7267C10[];
extern Class_Descriptor cd_S7267C15;
extern VTBL_ENTRY _ZTI8S7267C15[];
extern  VTBL_ENTRY _ZTV8S7267C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7267C15[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7267C5;
extern VTBL_ENTRY _ZTI7S7267C5[];
extern  VTBL_ENTRY _ZTV7S7267C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C5[];
extern Class_Descriptor cd_S7267C8;
extern VTBL_ENTRY _ZTI7S7267C8[];
extern  VTBL_ENTRY _ZTV7S7267C8[];
extern Class_Descriptor cd_S7267C3;
extern VTBL_ENTRY _ZTI7S7267C3[];
extern  VTBL_ENTRY _ZTV7S7267C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C3[];
extern Class_Descriptor cd_S7267C2;
extern VTBL_ENTRY _ZTI7S7267C2[];
extern  VTBL_ENTRY _ZTV7S7267C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C2[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7267C14;
extern VTBL_ENTRY _ZTI8S7267C14[];
extern  VTBL_ENTRY _ZTV8S7267C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7267C14[];
extern Class_Descriptor cd_S7267C11;
extern VTBL_ENTRY _ZTI8S7267C11[];
extern  VTBL_ENTRY _ZTV8S7267C11[];
static Base_Class bases_S7267C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7268C4,    ABISELECT(5376,4068), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S7267C5,    ABISELECT(5256,3972), //bcp->offset
    50, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    39, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S7267C11,    ABISELECT(5080,3868), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S7267C13,    ABISELECT(5080,3868), //bcp->offset
    37, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    37, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7268C4,    ABISELECT(120,96), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S7267C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S7267C6,    ABISELECT(5408,4096), //bcp->offset
    56, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S7267C5,    ABISELECT(6280,4760), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    41, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S7267C11,    ABISELECT(7040,5368), //bcp->offset
    71, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S7267C10,    ABISELECT(6280,4760), //bcp->offset
    62, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    40, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S7267C8,    ABISELECT(152,124), //bcp->offset
    14, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S7267C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S7267C6,    ABISELECT(672,540), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S7267C8,    ABISELECT(7208,5464), //bcp->offset
    77, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    32, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S7267C5,    ABISELECT(1544,1204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S7267C10,    ABISELECT(1544,1204), //bcp->offset
    26, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    33, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S7267C15,    ABISELECT(672,540), //bcp->offset
    17, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S7268C4,    ABISELECT(42472,32772), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S7267C5,    ABISELECT(42352,32676), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    50, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S7267C8,    ABISELECT(42504,32800), //bcp->offset
    103, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    36, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S7267C3,    ABISELECT(42352,32676), //bcp->offset
    93, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    35, //bcp->index_in_construction_vtbl_array
    49, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    21, //immediately_derived
  0, 1},
  {&cd_S7267C2,    ABISELECT(7520,5716), //bcp->offset
    81, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    34, //bcp->index_in_construction_vtbl_array
    43, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    23, //immediately_derived
  0, 1},
  {&cd_S7268C4,    ABISELECT(2408,1872), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S7267C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7267C11,    ABISELECT(4912,3772), //bcp->offset
    33, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7267C12[];
extern void _ZN8S7267C12D1Ev();
extern void _ZN8S7267C12D0Ev();
extern void _ZN8S7267C143v10Ev();
extern void _ZN7S7267C82v7Ev();
extern void _ZN7S7267C62v2Ev();
extern void _ZN7S7267C62v3Ev();
extern void ABISELECT(_ZThn672_N8S7267C12D1Ev,_ZThn540_N8S7267C12D1Ev)();
extern void ABISELECT(_ZThn672_N8S7267C12D0Ev,_ZThn540_N8S7267C12D0Ev)();
extern void ABISELECT(_ZThn1544_N8S7267C12D1Ev,_ZThn1204_N8S7267C12D1Ev)();
extern void ABISELECT(_ZThn1544_N8S7267C12D0Ev,_ZThn1204_N8S7267C12D0Ev)();
extern void _ZN8S7267C102v6Ev();
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
extern void _ZN8S7267C132v9Ev();
extern void ABISELECT(_ZTv0_n64_N8S7267C12D1Ev,_ZTv0_n32_N8S7267C12D1Ev)();
extern void ABISELECT(_ZThn5080_N8S7267C12D1Ev,_ZThn3868_N8S7267C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S7267C12D0Ev,_ZTv0_n32_N8S7267C12D0Ev)();
extern void ABISELECT(_ZThn5080_N8S7267C12D0Ev,_ZThn3868_N8S7267C12D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7267C12D1Ev,_ZTv0_n16_N8S7267C12D1Ev)();
extern void ABISELECT(_ZThn5256_N8S7267C12D1Ev,_ZThn3972_N8S7267C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7267C12D0Ev,_ZTv0_n16_N8S7267C12D0Ev)();
extern void ABISELECT(_ZThn5256_N8S7267C12D0Ev,_ZThn3972_N8S7267C12D0Ev)() __attribute__((weak));
extern void _ZN7S7267C62v2Ev();
extern void _ZN7S7267C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S7267C12D1Ev,_ZTv0_n20_N8S7267C12D1Ev)();
extern void ABISELECT(_ZThn6280_N8S7267C12D1Ev,_ZThn4760_N8S7267C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7267C12D0Ev,_ZTv0_n20_N8S7267C12D0Ev)();
extern void ABISELECT(_ZThn6280_N8S7267C12D0Ev,_ZThn4760_N8S7267C12D0Ev)() __attribute__((weak));
extern void _ZN8S7267C102v6Ev();
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
extern void _ZN7S7267C82v7Ev();
extern void _ZN7S7267C22v8Ev();
extern void ABISELECT(_ZTv0_n72_N8S7267C12D1Ev,_ZTv0_n36_N8S7267C12D1Ev)();
extern void ABISELECT(_ZThn7520_N8S7267C12D1Ev,_ZThn5716_N8S7267C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S7267C12D0Ev,_ZTv0_n36_N8S7267C12D0Ev)();
extern void ABISELECT(_ZThn7520_N8S7267C12D0Ev,_ZThn5716_N8S7267C12D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7267C12D1Ev,_ZTv0_n28_N8S7267C12D1Ev)();
extern void ABISELECT(_ZThn42352_N8S7267C12D1Ev,_ZThn32676_N8S7267C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7267C12D0Ev,_ZTv0_n28_N8S7267C12D0Ev)();
extern void ABISELECT(_ZThn42352_N8S7267C12D0Ev,_ZThn32676_N8S7267C12D0Ev)() __attribute__((weak));
extern void _ZN7S7267C82v7Ev();
static  VTBL_ENTRY vtc_S7267C12[] = {
  ABISELECT(5256,3972),
  ABISELECT(5080,3868),
  ABISELECT(42352,32676),
  ABISELECT(7520,5716),
  ABISELECT(7208,5464),
  ABISELECT(7040,5368),
  ABISELECT(6280,4760),
  ABISELECT(5408,4096),
  ABISELECT(5376,4068),
  0,
  (VTBL_ENTRY)&(_ZTI8S7267C12[0]),
  (VTBL_ENTRY)&_ZN8S7267C12D1Ev,
  (VTBL_ENTRY)&_ZN8S7267C12D0Ev,
  (VTBL_ENTRY)&_ZN8S7267C143v10Ev,
  ABISELECT(-152,-124),
  (VTBL_ENTRY)&(_ZTI8S7267C12[0]),
  (VTBL_ENTRY)&_ZN7S7267C82v7Ev,
  ABISELECT(6368,4828),
  ABISELECT(4704,3528),
  ABISELECT(6536,4924),
  ABISELECT(-672,-540),
  (VTBL_ENTRY)&(_ZTI8S7267C12[0]),
  (VTBL_ENTRY)&_ZN7S7267C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7267C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S7267C12D1Ev,_ZThn540_N8S7267C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S7267C12D0Ev,_ZThn540_N8S7267C12D0Ev),
  ABISELECT(5496,4164),
  ABISELECT(3832,2864),
  ABISELECT(-1544,-1204),
  (VTBL_ENTRY)&(_ZTI8S7267C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1544_N8S7267C12D1Ev,_ZThn1204_N8S7267C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1544_N8S7267C12D0Ev,_ZThn1204_N8S7267C12D0Ev),
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
  ABISELECT(-4912,-3772),
  (VTBL_ENTRY)&(_ZTI8S7267C12[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
  ABISELECT(-5080,-3868),
  0,
  0,
  0,
  ABISELECT(296,200),
  ABISELECT(176,104),
  ABISELECT(-5080,-3868),
  (VTBL_ENTRY)&(_ZTI8S7267C12[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
  (VTBL_ENTRY)&_ZN8S7267C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7267C12D1Ev,_ZTv0_n32_N8S7267C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7267C12D0Ev,_ZTv0_n32_N8S7267C12D0Ev),
  ABISELECT(-5256,-3972),
  ABISELECT(120,96),
  ABISELECT(-5256,-3972),
  (VTBL_ENTRY)&(_ZTI8S7267C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7267C12D1Ev,_ZTv0_n16_N8S7267C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7267C12D0Ev,_ZTv0_n16_N8S7267C12D0Ev),
  0,
  0,
  ABISELECT(-5408,-4096),
  (VTBL_ENTRY)&(_ZTI8S7267C12[0]),
  (VTBL_ENTRY)&_ZN7S7267C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7267C62v3Ev,
  0,
  ABISELECT(-6280,-4760),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-6280,-4760),
  (VTBL_ENTRY)&(_ZTI8S7267C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7267C12D1Ev,_ZTv0_n20_N8S7267C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7267C12D0Ev,_ZTv0_n20_N8S7267C12D0Ev),
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
  0,
  0,
  ABISELECT(-7040,-5368),
  (VTBL_ENTRY)&(_ZTI8S7267C12[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
  0,
  ABISELECT(-7208,-5464),
  (VTBL_ENTRY)&(_ZTI8S7267C12[0]),
  (VTBL_ENTRY)&_ZN7S7267C82v7Ev,
  ABISELECT(-7520,-5716),
  0,
  ABISELECT(-480,-348),
  ABISELECT(-1240,-956),
  ABISELECT(-2112,-1620),
  ABISELECT(-2144,-1648),
  ABISELECT(34832,26960),
  ABISELECT(-7520,-5716),
  (VTBL_ENTRY)&(_ZTI8S7267C12[0]),
  (VTBL_ENTRY)&_ZN7S7267C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S7267C12D1Ev,_ZTv0_n36_N8S7267C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S7267C12D0Ev,_ZTv0_n36_N8S7267C12D0Ev),
  ABISELECT(152,124),
  ABISELECT(-42352,-32676),
  ABISELECT(-35312,-27308),
  ABISELECT(-36072,-27916),
  ABISELECT(-36944,-28580),
  ABISELECT(-36976,-28608),
  ABISELECT(-42352,-32676),
  (VTBL_ENTRY)&(_ZTI8S7267C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7267C12D1Ev,_ZTv0_n28_N8S7267C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7267C12D0Ev,_ZTv0_n28_N8S7267C12D0Ev),
  ABISELECT(-42504,-32800),
  (VTBL_ENTRY)&(_ZTI8S7267C12[0]),
  (VTBL_ENTRY)&_ZN7S7267C82v7Ev,
};
extern VTBL_ENTRY _ZTV8S7267C12[];
extern void _ZN8S7267C14D1Ev();
extern void _ZN8S7267C14D0Ev();
extern void _ZN8S7267C143v10Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C14__8S7267C12[] = {
  ABISELECT(5256,3972),
  ABISELECT(5080,3868),
  ABISELECT(42352,32676),
  ABISELECT(7520,5716),
  ABISELECT(7208,5464),
  ABISELECT(7040,5368),
  ABISELECT(6280,4760),
  ABISELECT(5408,4096),
  ABISELECT(5376,4068),
  0,
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&_ZN8S7267C14D1Ev,
  (VTBL_ENTRY)&_ZN8S7267C14D0Ev,
  (VTBL_ENTRY)&_ZN8S7267C143v10Ev,
};
extern void _ZN7S7267C3D1Ev();
extern void _ZN7S7267C3D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C38S7267C14__8S7267C12[] = {
  ABISELECT(7040,5368),
  ABISELECT(6280,4760),
  ABISELECT(5408,4096),
  ABISELECT(5376,4068),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&_ZN7S7267C3D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C3D0Ev,
};
extern void _ZN7S7267C5D1Ev();
extern void _ZN7S7267C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C57S7267C38S7267C14__A1__8S7267C12[] = {
  ABISELECT(5376,4068),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C5[0]),
  (VTBL_ENTRY)&_ZN7S7267C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C5D0Ev,
};
extern void _ZN7S7267C62v2Ev();
extern void _ZN7S7267C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C6__7S7267C38S7267C14__8S7267C12[] = {
  0,
  0,
  ABISELECT(-5408,-4096),
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&_ZN7S7267C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7267C62v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S7267C3D1Ev,_ZTv0_n20_N7S7267C3D1Ev)();
extern void ABISELECT(_ZThn6280_N7S7267C3D1Ev,_ZThn4760_N7S7267C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S7267C3D0Ev,_ZTv0_n20_N7S7267C3D0Ev)();
extern void ABISELECT(_ZThn6280_N7S7267C3D0Ev,_ZThn4760_N7S7267C3D0Ev)() __attribute__((weak));
extern void _ZN8S7267C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C10__7S7267C38S7267C14__8S7267C12[] = {
  0,
  ABISELECT(-6280,-4760),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-6280,-4760),
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7267C3D1Ev,_ZTv0_n20_N7S7267C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7267C3D0Ev,_ZTv0_n20_N7S7267C3D0Ev),
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C11__7S7267C38S7267C14__8S7267C12[] = {
  0,
  0,
  ABISELECT(-7040,-5368),
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
};
extern void _ZN7S7267C62v2Ev();
extern void _ZN7S7267C62v3Ev();
extern void _ZN8S7267C15D1Ev();
extern void _ZN8S7267C15D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C158S7267C14__8S7267C12[] = {
  ABISELECT(6368,4828),
  ABISELECT(4704,3528),
  ABISELECT(6536,4924),
  0,
  (VTBL_ENTRY)&(_ZTI8S7267C15[0]),
  (VTBL_ENTRY)&_ZN7S7267C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7267C62v3Ev,
  (VTBL_ENTRY)&_ZN8S7267C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7267C15D0Ev,
};
extern void _ZN8S7267C10D1Ev();
extern void _ZN8S7267C10D0Ev();
extern void _ZN8S7267C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C108S7267C158S7267C14__A1__8S7267C12[] = {
  ABISELECT(5496,4164),
  ABISELECT(3832,2864),
  0,
  (VTBL_ENTRY)&(_ZTI8S7267C10[0]),
  (VTBL_ENTRY)&_ZN8S7267C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7267C10D0Ev,
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
};
extern void _ZN7S7267C5D1Ev();
extern void _ZN7S7267C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C58S7267C108S7267C158S7267C14__A3__8S7267C12[] = {
  ABISELECT(3832,2864),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C5[0]),
  (VTBL_ENTRY)&_ZN7S7267C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C5D0Ev,
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C11__8S7267C108S7267C158S7267C14__A1__8S7267C12[] = {
  0,
  0,
  ABISELECT(-5496,-4164),
  (VTBL_ENTRY)&(_ZTI8S7267C10[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
};
extern void _ZN7S7267C82v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C8__8S7267C158S7267C14__8S7267C12[] = {
  0,
  ABISELECT(-6536,-4924),
  (VTBL_ENTRY)&(_ZTI8S7267C15[0]),
  (VTBL_ENTRY)&_ZN7S7267C82v7Ev,
};
extern void ABISELECT(_ZThn872_N8S7267C15D1Ev,_ZThn664_N8S7267C15D1Ev)();
extern void ABISELECT(_ZThn872_N8S7267C15D0Ev,_ZThn664_N8S7267C15D0Ev)();
extern void _ZN8S7267C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C10__8S7267C158S7267C14__8S7267C12[] = {
  ABISELECT(5496,4164),
  ABISELECT(3832,2864),
  ABISELECT(-872,-664),
  (VTBL_ENTRY)&(_ZTI8S7267C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn872_N8S7267C15D1Ev,_ZThn664_N8S7267C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn872_N8S7267C15D0Ev,_ZThn664_N8S7267C15D0Ev),
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C11__8S7267C158S7267C14__8S7267C12[] = {
  0,
  0,
  ABISELECT(-6368,-4828),
  (VTBL_ENTRY)&(_ZTI8S7267C15[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
};
extern void _ZN7S7267C62v2Ev();
extern void _ZN7S7267C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C6__8S7267C14__8S7267C12[] = {
  0,
  0,
  ABISELECT(-5408,-4096),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&_ZN7S7267C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7267C62v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S7267C14D1Ev,_ZTv0_n20_N8S7267C14D1Ev)();
extern void ABISELECT(_ZThn6280_N8S7267C14D1Ev,_ZThn4760_N8S7267C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7267C14D0Ev,_ZTv0_n20_N8S7267C14D0Ev)();
extern void ABISELECT(_ZThn6280_N8S7267C14D0Ev,_ZThn4760_N8S7267C14D0Ev)() __attribute__((weak));
extern void _ZN8S7267C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C10__8S7267C14__8S7267C12[] = {
  0,
  ABISELECT(-6280,-4760),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-6280,-4760),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7267C14D1Ev,_ZTv0_n20_N8S7267C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7267C14D0Ev,_ZTv0_n20_N8S7267C14D0Ev),
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C11__8S7267C14__8S7267C12[] = {
  0,
  0,
  ABISELECT(-7040,-5368),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
};
extern void _ZN7S7267C62v2Ev();
extern void _ZN7S7267C62v3Ev();
extern void ABISELECT(_ZThn672_N8S7267C14D1Ev,_ZThn540_N8S7267C14D1Ev)();
extern void ABISELECT(_ZThn672_N8S7267C14D0Ev,_ZThn540_N8S7267C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S7267C15__8S7267C14__8S7267C12[] = {
  ABISELECT(6368,4828),
  ABISELECT(4704,3528),
  ABISELECT(6536,4924),
  ABISELECT(-672,-540),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&_ZN7S7267C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7267C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S7267C14D1Ev,_ZThn540_N8S7267C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S7267C14D0Ev,_ZThn540_N8S7267C14D0Ev),
};
extern void _ZN7S7267C82v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C8__A1__8S7267C14__8S7267C12[] = {
  0,
  ABISELECT(-7208,-5464),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&_ZN7S7267C82v7Ev,
};
extern void ABISELECT(_ZThn1544_N8S7267C14D1Ev,_ZThn1204_N8S7267C14D1Ev)();
extern void ABISELECT(_ZThn1544_N8S7267C14D0Ev,_ZThn1204_N8S7267C14D0Ev)();
extern void _ZN8S7267C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C108S7267C15__A1__8S7267C14__8S7267C12[] = {
  ABISELECT(5496,4164),
  ABISELECT(3832,2864),
  ABISELECT(-1544,-1204),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1544_N8S7267C14D1Ev,_ZThn1204_N8S7267C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1544_N8S7267C14D0Ev,_ZThn1204_N8S7267C14D0Ev),
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
};
extern void _ZN7S7267C22v8Ev();
extern void ABISELECT(_ZTv0_n72_N8S7267C14D1Ev,_ZTv0_n36_N8S7267C14D1Ev)();
extern void ABISELECT(_ZThn7520_N8S7267C14D1Ev,_ZThn5716_N8S7267C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S7267C14D0Ev,_ZTv0_n36_N8S7267C14D0Ev)();
extern void ABISELECT(_ZThn7520_N8S7267C14D0Ev,_ZThn5716_N8S7267C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7267C2__8S7267C14__8S7267C12[] = {
  ABISELECT(-7520,-5716),
  0,
  ABISELECT(-480,-348),
  ABISELECT(-1240,-956),
  ABISELECT(-2112,-1620),
  ABISELECT(-2144,-1648),
  ABISELECT(34832,26960),
  ABISELECT(-7520,-5716),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&_ZN7S7267C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S7267C14D1Ev,_ZTv0_n36_N8S7267C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S7267C14D0Ev,_ZTv0_n36_N8S7267C14D0Ev),
};
extern void ABISELECT(_ZTv0_n56_N8S7267C14D1Ev,_ZTv0_n28_N8S7267C14D1Ev)();
extern void ABISELECT(_ZThn42352_N8S7267C14D1Ev,_ZThn32676_N8S7267C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7267C14D0Ev,_ZTv0_n28_N8S7267C14D0Ev)();
extern void ABISELECT(_ZThn42352_N8S7267C14D0Ev,_ZThn32676_N8S7267C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7267C3__A1__8S7267C14__8S7267C12[] = {
  ABISELECT(152,124),
  ABISELECT(-42352,-32676),
  ABISELECT(-35312,-27308),
  ABISELECT(-36072,-27916),
  ABISELECT(-36944,-28580),
  ABISELECT(-36976,-28608),
  ABISELECT(-42352,-32676),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7267C14D1Ev,_ZTv0_n28_N8S7267C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7267C14D0Ev,_ZTv0_n28_N8S7267C14D0Ev),
};
extern void _ZN7S7267C82v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C87S7267C3__A2__8S7267C14__8S7267C12[] = {
  ABISELECT(-42504,-32800),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&_ZN7S7267C82v7Ev,
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
extern void _ZN8S7267C132v9Ev();
extern void ABISELECT(_ZTv0_n64_N8S7267C14D1Ev,_ZTv0_n32_N8S7267C14D1Ev)();
extern void ABISELECT(_ZThn5080_N8S7267C14D1Ev,_ZThn3868_N8S7267C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S7267C14D0Ev,_ZTv0_n32_N8S7267C14D0Ev)();
extern void ABISELECT(_ZThn5080_N8S7267C14D0Ev,_ZThn3868_N8S7267C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7267C13__8S7267C14__8S7267C12[] = {
  ABISELECT(-5080,-3868),
  0,
  0,
  0,
  ABISELECT(296,200),
  ABISELECT(176,104),
  ABISELECT(-5080,-3868),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
  (VTBL_ENTRY)&_ZN8S7267C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7267C14D1Ev,_ZTv0_n32_N8S7267C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7267C14D0Ev,_ZTv0_n32_N8S7267C14D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S7267C14D1Ev,_ZTv0_n16_N8S7267C14D1Ev)();
extern void ABISELECT(_ZThn5256_N8S7267C14D1Ev,_ZThn3972_N8S7267C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7267C14D0Ev,_ZTv0_n16_N8S7267C14D0Ev)();
extern void ABISELECT(_ZThn5256_N8S7267C14D0Ev,_ZThn3972_N8S7267C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7267C5__A4__8S7267C14__8S7267C12[] = {
  ABISELECT(-5256,-3972),
  ABISELECT(120,96),
  ABISELECT(-5256,-3972),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7267C14D1Ev,_ZTv0_n16_N8S7267C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7267C14D0Ev,_ZTv0_n16_N8S7267C14D0Ev),
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
extern void _ZN8S7267C132v9Ev();
extern void _ZN8S7267C13D1Ev();
extern void _ZN8S7267C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C13__8S7267C12[] = {
  ABISELECT(296,200),
  ABISELECT(176,104),
  0,
  (VTBL_ENTRY)&(_ZTI8S7267C13[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
  (VTBL_ENTRY)&_ZN8S7267C132v9Ev,
  (VTBL_ENTRY)&_ZN8S7267C13D1Ev,
  (VTBL_ENTRY)&_ZN8S7267C13D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S7267C13D1Ev,_ZTv0_n16_N8S7267C13D1Ev)();
extern void ABISELECT(_ZThn176_N8S7267C13D1Ev,_ZThn104_N8S7267C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7267C13D0Ev,_ZTv0_n16_N8S7267C13D0Ev)();
extern void ABISELECT(_ZThn176_N8S7267C13D0Ev,_ZThn104_N8S7267C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7267C5__8S7267C13__8S7267C12[] = {
  ABISELECT(-176,-104),
  ABISELECT(120,96),
  ABISELECT(-176,-104),
  (VTBL_ENTRY)&(_ZTI8S7267C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7267C13D1Ev,_ZTv0_n16_N8S7267C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7267C13D0Ev,_ZTv0_n16_N8S7267C13D0Ev),
};
extern void _ZN7S7267C5D1Ev();
extern void _ZN7S7267C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C5__8S7267C12[] = {
  ABISELECT(120,96),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C5[0]),
  (VTBL_ENTRY)&_ZN7S7267C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C5D0Ev,
};
extern void _ZN8S7267C10D1Ev();
extern void _ZN8S7267C10D0Ev();
extern void _ZN8S7267C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C10__8S7267C12[] = {
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  0,
  (VTBL_ENTRY)&(_ZTI8S7267C10[0]),
  (VTBL_ENTRY)&_ZN8S7267C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7267C10D0Ev,
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
};
extern void _ZN7S7267C5D1Ev();
extern void _ZN7S7267C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C58S7267C10__A2__8S7267C12[] = {
  ABISELECT(-904,-692),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C5[0]),
  (VTBL_ENTRY)&_ZN7S7267C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C5D0Ev,
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C11__8S7267C10__8S7267C12[] = {
  0,
  0,
  ABISELECT(-760,-608),
  (VTBL_ENTRY)&(_ZTI8S7267C10[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
};
extern void _ZN7S7267C22v8Ev();
extern void _ZN7S7267C2D1Ev();
extern void _ZN7S7267C2D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C2__8S7267C12[] = {
  ABISELECT(-480,-348),
  ABISELECT(-1240,-956),
  ABISELECT(-2112,-1620),
  ABISELECT(-2144,-1648),
  ABISELECT(34832,26960),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C2[0]),
  (VTBL_ENTRY)&_ZN7S7267C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7267C2D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C2D0Ev,
};
extern void ABISELECT(_ZTv0_n56_N7S7267C2D1Ev,_ZTv0_n28_N7S7267C2D1Ev)();
extern void ABISELECT(_ZThn34832_N7S7267C2D1Ev,_ZThn26960_N7S7267C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N7S7267C2D0Ev,_ZTv0_n28_N7S7267C2D0Ev)();
extern void ABISELECT(_ZThn34832_N7S7267C2D0Ev,_ZThn26960_N7S7267C2D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7267C3__7S7267C2__8S7267C12[] = {
  ABISELECT(152,124),
  ABISELECT(-34832,-26960),
  ABISELECT(-35312,-27308),
  ABISELECT(-36072,-27916),
  ABISELECT(-36944,-28580),
  ABISELECT(-36976,-28608),
  ABISELECT(-34832,-26960),
  (VTBL_ENTRY)&(_ZTI7S7267C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7267C2D1Ev,_ZTv0_n28_N7S7267C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7267C2D0Ev,_ZTv0_n28_N7S7267C2D0Ev),
};
extern void _ZN7S7267C62v2Ev();
extern void _ZN7S7267C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C6__7S7267C2__8S7267C12[] = {
  0,
  0,
  ABISELECT(2112,1620),
  (VTBL_ENTRY)&(_ZTI7S7267C2[0]),
  (VTBL_ENTRY)&_ZN7S7267C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7267C62v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S7267C2D1Ev,_ZTv0_n20_N7S7267C2D1Ev)();
extern void ABISELECT(_ZTv0_n40_N7S7267C2D0Ev,_ZTv0_n20_N7S7267C2D0Ev)();
extern void _ZN8S7267C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C10__7S7267C2__8S7267C12[] = {
  0,
  ABISELECT(1240,956),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(1240,956),
  (VTBL_ENTRY)&(_ZTI7S7267C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7267C2D1Ev,_ZTv0_n20_N7S7267C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7267C2D0Ev,_ZTv0_n20_N7S7267C2D0Ev),
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C11__7S7267C2__8S7267C12[] = {
  0,
  0,
  ABISELECT(480,348),
  (VTBL_ENTRY)&(_ZTI7S7267C2[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
};
extern void _ZN7S7267C82v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C87S7267C3__7S7267C2__8S7267C12[] = {
  ABISELECT(-34984,-27084),
  (VTBL_ENTRY)&(_ZTI7S7267C2[0]),
  (VTBL_ENTRY)&_ZN7S7267C82v7Ev,
};
extern void _ZN7S7267C3D1Ev();
extern void _ZN7S7267C3D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C3__A1__8S7267C12[] = {
  ABISELECT(-35312,-27308),
  ABISELECT(-36072,-27916),
  ABISELECT(-36944,-28580),
  ABISELECT(-36976,-28608),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&_ZN7S7267C3D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C3D0Ev,
};
extern void _ZN7S7267C5D1Ev();
extern void _ZN7S7267C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C57S7267C3__A4__8S7267C12[] = {
  ABISELECT(-36976,-28608),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C5[0]),
  (VTBL_ENTRY)&_ZN7S7267C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C5D0Ev,
};
extern void _ZN7S7267C62v2Ev();
extern void _ZN7S7267C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C6__7S7267C3__A1__8S7267C12[] = {
  0,
  0,
  ABISELECT(36944,28580),
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&_ZN7S7267C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7267C62v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S7267C3D1Ev,_ZTv0_n20_N7S7267C3D1Ev)();
extern void ABISELECT(_ZTv0_n40_N7S7267C3D0Ev,_ZTv0_n20_N7S7267C3D0Ev)();
extern void _ZN8S7267C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C10__7S7267C3__A1__8S7267C12[] = {
  0,
  ABISELECT(36072,27916),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(36072,27916),
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7267C3D1Ev,_ZTv0_n20_N7S7267C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7267C3D0Ev,_ZTv0_n20_N7S7267C3D0Ev),
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C11__7S7267C3__A1__8S7267C12[] = {
  0,
  0,
  ABISELECT(35312,27308),
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
};
static  VTT_ENTRY vtt_S7267C12[] = {
  {&(_ZTV8S7267C12[11]),  11,106},
  {&(_tg__ZTV8S7267C14__8S7267C12[11]),  11,14},
  {&(_tg__ZTV7S7267C38S7267C14__8S7267C12[6]),  6,8},
  {&(_tg__ZTV7S7267C57S7267C38S7267C14__A1__8S7267C12[3]),  3,5},
  {&(_tg__ZTV7S7267C6__7S7267C38S7267C14__8S7267C12[4]),  4,6},
  {&(_tg__ZTV8S7267C10__7S7267C38S7267C14__8S7267C12[6]),  6,9},
  {&(_tg__ZTV8S7267C11__7S7267C38S7267C14__8S7267C12[4]),  4,6},
  {&(_tg__ZTV8S7267C158S7267C14__8S7267C12[5]),  5,9},
  {&(_tg__ZTV8S7267C108S7267C158S7267C14__A1__8S7267C12[4]),  4,7},
  {&(_tg__ZTV7S7267C58S7267C108S7267C158S7267C14__A3__8S7267C12[3]),  3,5},
  {&(_tg__ZTV8S7267C11__8S7267C108S7267C158S7267C14__A1__8S7267C12[4]),  4,6},
  {&(_tg__ZTV7S7267C8__8S7267C158S7267C14__8S7267C12[3]),  3,4},
  {&(_tg__ZTV8S7267C10__8S7267C158S7267C14__8S7267C12[4]),  4,7},
  {&(_tg__ZTV8S7267C11__8S7267C158S7267C14__8S7267C12[4]),  4,6},
  {&(_tg__ZTV7S7267C6__8S7267C14__8S7267C12[4]),  4,6},
  {&(_tg__ZTV8S7267C10__8S7267C14__8S7267C12[6]),  6,9},
  {&(_tg__ZTV8S7267C11__8S7267C14__8S7267C12[4]),  4,6},
  {&(_tg__ZTV8S7267C15__8S7267C14__8S7267C12[5]),  5,9},
  {&(_tg__ZTV7S7267C8__A1__8S7267C14__8S7267C12[3]),  3,4},
  {&(_tg__ZTV8S7267C108S7267C15__A1__8S7267C14__8S7267C12[4]),  4,7},
  {&(_tg__ZTV7S7267C2__8S7267C14__8S7267C12[9]),  9,12},
  {&(_tg__ZTV7S7267C3__A1__8S7267C14__8S7267C12[8]),  8,10},
  {&(_tg__ZTV7S7267C87S7267C3__A2__8S7267C14__8S7267C12[2]),  2,3},
  {&(_tg__ZTV8S7267C13__8S7267C14__8S7267C12[8]),  8,13},
  {&(_tg__ZTV7S7267C5__A4__8S7267C14__8S7267C12[4]),  4,6},
  {&(_ZTV8S7267C12[45]),  45,106},
  {&(_ZTV8S7267C12[54]),  54,106},
  {&(_ZTV8S7267C12[60]),  60,106},
  {&(_ZTV8S7267C12[68]),  68,106},
  {&(_ZTV8S7267C12[75]),  75,106},
  {&(_ZTV8S7267C12[22]),  22,106},
  {&(_ZTV8S7267C12[80]),  80,106},
  {&(_ZTV8S7267C12[30]),  30,106},
  {&(_ZTV8S7267C12[90]),  90,106},
  {&(_ZTV8S7267C12[101]),  101,106},
  {&(_ZTV8S7267C12[105]),  105,106},
  {&(_tg__ZTV8S7267C13__8S7267C12[4]),  4,9},
  {&(_tg__ZTV7S7267C5__8S7267C13__8S7267C12[4]),  4,6},
  {&(_tg__ZTV7S7267C5__8S7267C12[3]),  3,5},
  {&(_tg__ZTV8S7267C10__8S7267C12[4]),  4,7},
  {&(_tg__ZTV7S7267C58S7267C10__A2__8S7267C12[3]),  3,5},
  {&(_tg__ZTV8S7267C11__8S7267C10__8S7267C12[4]),  4,6},
  {&(_tg__ZTV7S7267C2__8S7267C12[7]),  7,10},
  {&(_tg__ZTV7S7267C3__7S7267C2__8S7267C12[8]),  8,10},
  {&(_tg__ZTV7S7267C6__7S7267C2__8S7267C12[4]),  4,6},
  {&(_tg__ZTV8S7267C10__7S7267C2__8S7267C12[6]),  6,9},
  {&(_tg__ZTV8S7267C11__7S7267C2__8S7267C12[4]),  4,6},
  {&(_tg__ZTV7S7267C87S7267C3__7S7267C2__8S7267C12[2]),  2,3},
  {&(_tg__ZTV7S7267C3__A1__8S7267C12[6]),  6,8},
  {&(_tg__ZTV7S7267C57S7267C3__A4__8S7267C12[3]),  3,5},
  {&(_tg__ZTV7S7267C6__7S7267C3__A1__8S7267C12[4]),  4,6},
  {&(_tg__ZTV8S7267C10__7S7267C3__A1__8S7267C12[6]),  6,9},
  {&(_tg__ZTV8S7267C11__7S7267C3__A1__8S7267C12[4]),  4,6},
};
extern VTBL_ENTRY _ZTI8S7267C12[];
extern  VTBL_ENTRY _ZTV8S7267C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7267C12[];
static VTBL_ENTRY alt_thunk_names12[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7267C2D0Ev,_ZTv0_n28_N7S7267C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn34832_N7S7267C2D0Ev,_ZThn26960_N7S7267C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7267C2D1Ev,_ZTv0_n28_N7S7267C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn34832_N7S7267C2D1Ev,_ZThn26960_N7S7267C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7267C13D0Ev,_ZTv0_n16_N8S7267C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7267C13D0Ev,_ZThn104_N8S7267C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7267C13D1Ev,_ZTv0_n16_N8S7267C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7267C13D1Ev,_ZThn104_N8S7267C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7267C14D0Ev,_ZTv0_n16_N8S7267C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5256_N8S7267C14D0Ev,_ZThn3972_N8S7267C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7267C14D1Ev,_ZTv0_n16_N8S7267C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5256_N8S7267C14D1Ev,_ZThn3972_N8S7267C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S7267C14D0Ev,_ZTv0_n32_N8S7267C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5080_N8S7267C14D0Ev,_ZThn3868_N8S7267C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S7267C14D1Ev,_ZTv0_n32_N8S7267C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5080_N8S7267C14D1Ev,_ZThn3868_N8S7267C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7267C14D0Ev,_ZTv0_n28_N8S7267C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn42352_N8S7267C14D0Ev,_ZThn32676_N8S7267C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7267C14D1Ev,_ZTv0_n28_N8S7267C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn42352_N8S7267C14D1Ev,_ZThn32676_N8S7267C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S7267C14D0Ev,_ZTv0_n36_N8S7267C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7520_N8S7267C14D0Ev,_ZThn5716_N8S7267C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S7267C14D1Ev,_ZTv0_n36_N8S7267C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7520_N8S7267C14D1Ev,_ZThn5716_N8S7267C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7267C14D0Ev,_ZTv0_n20_N8S7267C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6280_N8S7267C14D0Ev,_ZThn4760_N8S7267C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7267C14D1Ev,_ZTv0_n20_N8S7267C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6280_N8S7267C14D1Ev,_ZThn4760_N8S7267C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7267C3D0Ev,_ZTv0_n20_N7S7267C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6280_N7S7267C3D0Ev,_ZThn4760_N7S7267C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7267C3D1Ev,_ZTv0_n20_N7S7267C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6280_N7S7267C3D1Ev,_ZThn4760_N7S7267C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7267C12D0Ev,_ZTv0_n28_N8S7267C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn42352_N8S7267C12D0Ev,_ZThn32676_N8S7267C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7267C12D1Ev,_ZTv0_n28_N8S7267C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn42352_N8S7267C12D1Ev,_ZThn32676_N8S7267C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S7267C12D0Ev,_ZTv0_n36_N8S7267C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7520_N8S7267C12D0Ev,_ZThn5716_N8S7267C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S7267C12D1Ev,_ZTv0_n36_N8S7267C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7520_N8S7267C12D1Ev,_ZThn5716_N8S7267C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7267C12D0Ev,_ZTv0_n20_N8S7267C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6280_N8S7267C12D0Ev,_ZThn4760_N8S7267C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7267C12D1Ev,_ZTv0_n20_N8S7267C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6280_N8S7267C12D1Ev,_ZThn4760_N8S7267C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7267C12D0Ev,_ZTv0_n16_N8S7267C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5256_N8S7267C12D0Ev,_ZThn3972_N8S7267C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7267C12D1Ev,_ZTv0_n16_N8S7267C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5256_N8S7267C12D1Ev,_ZThn3972_N8S7267C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S7267C12D0Ev,_ZTv0_n32_N8S7267C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5080_N8S7267C12D0Ev,_ZThn3868_N8S7267C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S7267C12D1Ev,_ZTv0_n32_N8S7267C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5080_N8S7267C12D1Ev,_ZThn3868_N8S7267C12D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7267C12 = {  "S7267C12", // class name
  bases_S7267C12, 25,
  &(vtc_S7267C12[0]), // expected_vtbl_contents
  &(vtt_S7267C12[0]), // expected_vtt_contents
  ABISELECT(43024,33216), // object size
  NSPAIRA(_ZTI8S7267C12),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S7267C12),106, //virtual function table var
  11, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7267C12),53, //virtual table table var
  21, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names12,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7267C1  : S7267C2 , S7267C12 {
  long s7267c1f0;
  __tsi64 s7267c1f1;
  long double s7267c1f2[10];
  char s7267c1f3[5];
  ::S7268C18 s7267c1f4;
  virtual  ~S7267C1(); // _ZN7S7267C1D2Ev
  virtual void  v1(); // _ZN7S7267C12v1Ev
  S7267C1(); // tgen
};
//SIG(1 S7267C1) C1{ BC2{ VBC3{ BC4{ m Fs[6] FL Fc[5]} BC5{ VBC4 vd FC4 Fi Fp FC4[2]} VBC6{ v2 v3 FC4 Fc FC7{ BC8{ v11 FU9{ m Fl Fp[4] Fi} Fp FC4[8] Fp} VBC4 BC10{ VBC4 vd FC4 Fi Fp FC4[2]} Fp[5] Fc:0 Fi Fi Fi:10 Fc[8] Fs Fi Fp[10] FC10 FL Fi Fp} Fp Fi Fi Fp Fi Fi:11 Fi} VBC11{ BC5 VBC12{ v4 v5 Fi Fp Fp Fl Fp[2] Fp Fl[6] FC4 Fi Fp Fc[2]} vd v6 Fl[4] FC5[4]} BC13{ v7 FU9 Fp FC4[8] Fp} Fp Fi[6] FL FC5 Fc} v8 FC4 FC11[5] FC3[10] FL[4] Fc FC3 FC3} BC14{ VBC15{ VBC5 BC12 v9 Fi Fp} BC16{ BC3 BC17{ BC6 VBC13 VBC4 BC11 vd Fi Fi Fc[4] Fp[3] Fs Fi Fi FD Fp Fp Fi} VBC2 BC4 VBC15 vd v10 FU18{ m Fi Fc[7] Fi[10] Fi FD[8] Fi Fp Fi} Fp Fi FL FL FC17 FL Fi[8] Fi} BC12 FC19{}} vd v1 Fl FL FD[10] Fc[5] FC20{ BC8 BC21{ v12 v13 Fi Fp Fp Fl Fp[2] Fp Fl[6] FC4 Fi Fp Fc[2]} VBC22{ VBC10 BC21 v14 Fi Fp} BC23{ BC10 VBC21 vd v15 Fl[4] FC10[4]} Fc:0}}


 S7267C1 ::~S7267C1(){ note_dtor("S7267C1", this);}
void  S7267C1 ::v1(){vfunc_called(this, "_ZN7S7267C12v1Ev");}
S7267C1 ::S7267C1(){ note_ctor("S7267C1", this);} // tgen

static void Test_S7267C1()
{
  extern Class_Descriptor cd_S7267C1;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(4987,15400)];
    init_test(&cd_S7267C1, buf);
    S7267C1 *dp, &lv = *(dp=new (buf) S7267C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(79776,61596), "sizeof(S7267C1)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7267C1)");
    /*is_ambiguous_... S7267C1::S7267C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7267C3*), ABISELECT(41960,32344), "S7267C1");
    /*is_ambiguous_... S7267C1::S7267C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7267C5*)(S7267C3*), ABISELECT(42504,32788), "S7267C1");
    /*is_ambiguous_... S7267C1::S7267C10 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7267C5*)(S7267C10*), ABISELECT(42504,32788), "S7267C1");
    /*is_ambiguous_... S7267C1::S7267C5 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7267C5*), ABISELECT(42504,32788), "S7267C1");
    /*is_ambiguous_... S7267C14::S7267C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7267C5*)(S7267C3*)(S7267C14*)(S7267C12*), ABISELECT(42504,32788), "S7267C1");
    check_base_class_offset(lv, (S7268C4*)(S7267C15*)(S7267C14*)(S7267C12*), ABISELECT(42504,32788), "S7267C1");
    check_base_class_offset(lv, (S7268C4*)(S7267C5*)(S7267C10*)(S7267C15*)(S7267C14*)(S7267C12*), ABISELECT(42504,32788), "S7267C1");
    /*is_ambiguous_... S7267C1::S7267C3 */ AMB_check_base_class_offset(lv, (S7267C5*)(S7267C3*), ABISELECT(41840,32248), "S7267C1");
    /*is_ambiguous_... S7267C1::S7267C3 */ AMB_check_base_class_offset(lv, (S7267C6*)(S7267C3*), ABISELECT(42536,32816), "S7267C1");
    /*is_ambiguous_... S7267C14::S7267C3 */ AMB_check_base_class_offset(lv, (S7267C6*)(S7267C3*)(S7267C14*)(S7267C12*), ABISELECT(42536,32816), "S7267C1");
    /*is_ambiguous_... S7267C1::S7267C10 */ AMB_check_base_class_offset(lv, (S7267C5*)(S7267C10*), ABISELECT(43408,33480), "S7267C1");
    /*is_ambiguous_... S7267C1::S7267C10 */ AMB_check_base_class_offset(lv, (S7267C11*)(S7267C10*), ABISELECT(44168,34088), "S7267C1");
    check_base_class_offset(lv, (S7267C11*)(S7267C10*)(S7267C15*)(S7267C14*)(S7267C12*), ABISELECT(44168,34088), "S7267C1");
    /*is_ambiguous_... S7267C1::S7267C3 */ AMB_check_base_class_offset(lv, (S7267C10*)(S7267C3*), ABISELECT(43408,33480), "S7267C1");
    /*is_ambiguous_... S7267C14::S7267C3 */ AMB_check_base_class_offset(lv, (S7267C10*)(S7267C3*)(S7267C14*)(S7267C12*), ABISELECT(43408,33480), "S7267C1");
    /*is_ambiguous_... S7267C1::S7267C3 */ AMB_check_base_class_offset(lv, (S7267C8*)(S7267C3*), ABISELECT(41992,32372), "S7267C1");
    /*is_ambiguous_... S7267C1::S7267C2 */ AMB_check_base_class_offset(lv, (S7267C3*)(S7267C2*), ABISELECT(41840,32248), "S7267C1");
    /*is_ambiguous_... S7267C1::S7267C2 */ AMB_check_base_class_offset(lv, (S7267C3*)(S7267C2*), ABISELECT(41840,32248), "S7267C1");
    /*is_ambiguous_... S7267C1::S7267C2 */ AMB_check_base_class_offset(lv, (S7267C2*), 0, "S7267C1");
    check_base_class_offset(lv, (S7267C5*)(S7267C13*), ABISELECT(44512,34288), "S7267C1");
    check_base_class_offset(lv, (S7267C11*)(S7267C13*), ABISELECT(44336,34184), "S7267C1");
    check_base_class_offset(lv, (S7267C13*)(S7267C12*), ABISELECT(44336,34184), "S7267C1");
    check_base_class_offset(lv, (S7267C13*)(S7267C14*)(S7267C12*), ABISELECT(44336,34184), "S7267C1");
    /*is_ambiguous_... S7267C14::S7267C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7267C3*)(S7267C14*)(S7267C12*), ABISELECT(34952,27056), "S7267C1");
    /*is_ambiguous_... S7267C14::S7267C3 */ AMB_check_base_class_offset(lv, (S7267C5*)(S7267C3*)(S7267C14*)(S7267C12*), ABISELECT(34832,26960), "S7267C1");
    /*is_ambiguous_... S7267C14::S7267C3 */ AMB_check_base_class_offset(lv, (S7267C8*)(S7267C3*)(S7267C14*)(S7267C12*), ABISELECT(34984,27084), "S7267C1");
    /*is_ambiguous_... S7267C14::S7267C3 */ AMB_check_base_class_offset(lv, (S7267C3*)(S7267C14*)(S7267C12*), ABISELECT(34832,26960), "S7267C1");
    check_base_class_offset(lv, (S7267C6*)(S7267C15*)(S7267C14*)(S7267C12*), ABISELECT(35504,27500), "S7267C1");
    check_base_class_offset(lv, (S7267C8*)(S7267C15*)(S7267C14*)(S7267C12*), ABISELECT(44632,34384), "S7267C1");
    check_base_class_offset(lv, (S7267C5*)(S7267C10*)(S7267C15*)(S7267C14*)(S7267C12*), ABISELECT(36376,28164), "S7267C1");
    check_base_class_offset(lv, (S7267C10*)(S7267C15*)(S7267C14*)(S7267C12*), ABISELECT(36376,28164), "S7267C1");
    check_base_class_offset(lv, (S7267C15*)(S7267C14*)(S7267C12*), ABISELECT(35504,27500), "S7267C1");
    check_base_class_offset(lv, (S7267C2*)(S7267C14*)(S7267C12*), ABISELECT(44944,34636), "S7267C1");
    /*is_ambiguous_... S7267C14::S7268C4 */ AMB_check_base_class_offset(lv, (S7268C4*)(S7267C14*)(S7267C12*), ABISELECT(37240,28832), "S7267C1");
    check_base_class_offset(lv, (S7267C14*)(S7267C12*), ABISELECT(34832,26960), "S7267C1");
    /*is_ambiguous_... S7267C12::S7267C11 */ AMB_check_base_class_offset(lv, (S7267C11*)(S7267C12*), ABISELECT(39744,30732), "S7267C1");
    check_base_class_offset(lv, (S7267C12*), ABISELECT(34832,26960), "S7267C1");
    check_field_offset(lv, s7267c1f0, ABISELECT(39912,30828), "S7267C1.s7267c1f0");
    check_field_offset(lv, s7267c1f1, ABISELECT(39920,30832), "S7267C1.s7267c1f1");
    check_field_offset(lv, s7267c1f2, ABISELECT(39936,30840), "S7267C1.s7267c1f2");
    check_field_offset(lv, s7267c1f3, ABISELECT(40096,30960), "S7267C1.s7267c1f3");
    check_field_offset(lv, s7267c1f4, ABISELECT(40104,30968), "S7267C1.s7267c1f4");
    test_class_info(&lv, &cd_S7267C1);
    dp->~S7267C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7267C1(Test_S7267C1, "S7267C1", ABISELECT(79776,61596));

#else // __cplusplus

extern void _ZN7S7267C1C1Ev();
extern void _ZN7S7267C1D2Ev();
Name_Map name_map_S7267C1[] = {
  NSPAIR(_ZN7S7267C1C1Ev),
  NSPAIR(_ZN7S7267C1D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7267C5;
extern VTBL_ENTRY _ZTI7S7267C5[];
extern  VTBL_ENTRY _ZTV7S7267C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C5[];
extern Class_Descriptor cd_S7267C6;
extern VTBL_ENTRY _ZTI7S7267C6[];
extern  VTBL_ENTRY _ZTV7S7267C6[];
extern Class_Descriptor cd_S7267C5;
extern VTBL_ENTRY _ZTI7S7267C5[];
extern  VTBL_ENTRY _ZTV7S7267C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C5[];
extern Class_Descriptor cd_S7267C11;
extern VTBL_ENTRY _ZTI8S7267C11[];
extern  VTBL_ENTRY _ZTV8S7267C11[];
extern Class_Descriptor cd_S7267C10;
extern VTBL_ENTRY _ZTI8S7267C10[];
extern  VTBL_ENTRY _ZTV8S7267C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7267C10[];
extern Class_Descriptor cd_S7267C8;
extern VTBL_ENTRY _ZTI7S7267C8[];
extern  VTBL_ENTRY _ZTV7S7267C8[];
extern Class_Descriptor cd_S7267C3;
extern VTBL_ENTRY _ZTI7S7267C3[];
extern  VTBL_ENTRY _ZTV7S7267C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C3[];
extern Class_Descriptor cd_S7267C2;
extern VTBL_ENTRY _ZTI7S7267C2[];
extern  VTBL_ENTRY _ZTV7S7267C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C2[];
extern Class_Descriptor cd_S7267C5;
extern VTBL_ENTRY _ZTI7S7267C5[];
extern  VTBL_ENTRY _ZTV7S7267C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C5[];
extern Class_Descriptor cd_S7267C11;
extern VTBL_ENTRY _ZTI8S7267C11[];
extern  VTBL_ENTRY _ZTV8S7267C11[];
extern Class_Descriptor cd_S7267C13;
extern VTBL_ENTRY _ZTI8S7267C13[];
extern  VTBL_ENTRY _ZTV8S7267C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7267C13[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7267C5;
extern VTBL_ENTRY _ZTI7S7267C5[];
extern  VTBL_ENTRY _ZTV7S7267C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C5[];
extern Class_Descriptor cd_S7267C8;
extern VTBL_ENTRY _ZTI7S7267C8[];
extern  VTBL_ENTRY _ZTV7S7267C8[];
extern Class_Descriptor cd_S7267C3;
extern VTBL_ENTRY _ZTI7S7267C3[];
extern  VTBL_ENTRY _ZTV7S7267C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C3[];
extern Class_Descriptor cd_S7267C6;
extern VTBL_ENTRY _ZTI7S7267C6[];
extern  VTBL_ENTRY _ZTV7S7267C6[];
extern Class_Descriptor cd_S7267C8;
extern VTBL_ENTRY _ZTI7S7267C8[];
extern  VTBL_ENTRY _ZTV7S7267C8[];
extern Class_Descriptor cd_S7267C5;
extern VTBL_ENTRY _ZTI7S7267C5[];
extern  VTBL_ENTRY _ZTV7S7267C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C5[];
extern Class_Descriptor cd_S7267C10;
extern VTBL_ENTRY _ZTI8S7267C10[];
extern  VTBL_ENTRY _ZTV8S7267C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7267C10[];
extern Class_Descriptor cd_S7267C15;
extern VTBL_ENTRY _ZTI8S7267C15[];
extern  VTBL_ENTRY _ZTV8S7267C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7267C15[];
extern Class_Descriptor cd_S7267C2;
extern VTBL_ENTRY _ZTI7S7267C2[];
extern  VTBL_ENTRY _ZTV7S7267C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C2[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7267C14;
extern VTBL_ENTRY _ZTI8S7267C14[];
extern  VTBL_ENTRY _ZTV8S7267C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7267C14[];
extern Class_Descriptor cd_S7267C11;
extern VTBL_ENTRY _ZTI8S7267C11[];
extern  VTBL_ENTRY _ZTV8S7267C11[];
extern Class_Descriptor cd_S7267C12;
extern VTBL_ENTRY _ZTI8S7267C12[];
extern  VTBL_ENTRY _ZTV8S7267C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7267C12[];
static Base_Class bases_S7267C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7268C4,    ABISELECT(41960,32344), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7268C4,    ABISELECT(42504,32788), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S7267C5,    ABISELECT(41840,32248), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    57, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7267C6,    ABISELECT(42536,32816), //bcp->offset
    65, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    45, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S7267C5,    ABISELECT(43408,33480), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    62, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S7267C11,    ABISELECT(44168,34088), //bcp->offset
    80, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    47, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S7267C10,    ABISELECT(43408,33480), //bcp->offset
    71, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    46, //bcp->index_in_construction_vtbl_array
    61, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S7267C8,    ABISELECT(41992,32372), //bcp->offset
    62, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    48, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7267C3,    ABISELECT(41840,32248), //bcp->offset
    52, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    44, //bcp->index_in_construction_vtbl_array
    56, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S7267C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7267C5,    ABISELECT(44512,34288), //bcp->offset
    99, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    51, //bcp->index_in_construction_vtbl_array
    66, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S7267C11,    ABISELECT(44336,34184), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S7267C13,    ABISELECT(44336,34184), //bcp->offset
    86, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    50, //bcp->index_in_construction_vtbl_array
    64, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    24, //immediately_derived
  0, 1},
  {&cd_S7268C4,    ABISELECT(34952,27056), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S7267C5,    ABISELECT(34832,26960), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S7267C8,    ABISELECT(34984,27084), //bcp->offset
    29, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S7267C3,    ABISELECT(34832,26960), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S7267C6,    ABISELECT(35504,27500), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S7267C8,    ABISELECT(44632,34384), //bcp->offset
    105, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    53, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    21, //immediately_derived
  0, 1},
  {&cd_S7267C5,    ABISELECT(36376,28164), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S7267C10,    ABISELECT(36376,28164), //bcp->offset
    41, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    54, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S7267C15,    ABISELECT(35504,27500), //bcp->offset
    32, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    52, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S7267C2,    ABISELECT(44944,34636), //bcp->offset
    109, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    55, //bcp->index_in_construction_vtbl_array
    67, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    24, //immediately_derived
  0, 1},
  {&cd_S7268C4,    ABISELECT(37240,28832), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S7267C14,    ABISELECT(34832,26960), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S7267C11,    ABISELECT(39744,30732), //bcp->offset
    48, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S7267C12,    ABISELECT(34832,26960), //bcp->offset
    15, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    49, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S7267C1[];
extern void _ZN7S7267C22v8Ev();
extern void _ZN7S7267C1D1Ev();
extern void _ZN7S7267C1D0Ev();
extern void _ZN7S7267C12v1Ev();
extern void ABISELECT(_ZThn34832_N7S7267C1D1Ev,_ZThn26960_N7S7267C1D1Ev)();
extern void ABISELECT(_ZThn34832_N7S7267C1D0Ev,_ZThn26960_N7S7267C1D0Ev)();
extern void _ZN8S7267C143v10Ev();
extern void _ZN7S7267C82v7Ev();
extern void _ZN7S7267C62v2Ev();
extern void _ZN7S7267C62v3Ev();
extern void ABISELECT(_ZThn35504_N7S7267C1D1Ev,_ZThn27500_N7S7267C1D1Ev)();
extern void ABISELECT(_ZThn35504_N7S7267C1D0Ev,_ZThn27500_N7S7267C1D0Ev)();
extern void ABISELECT(_ZThn36376_N7S7267C1D1Ev,_ZThn28164_N7S7267C1D1Ev)();
extern void ABISELECT(_ZThn36376_N7S7267C1D0Ev,_ZThn28164_N7S7267C1D0Ev)();
extern void _ZN8S7267C102v6Ev();
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
extern void ABISELECT(_ZTv0_n56_N7S7267C1D1Ev,_ZTv0_n28_N7S7267C1D1Ev)();
extern void ABISELECT(_ZThn41840_N7S7267C1D1Ev,_ZThn32248_N7S7267C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N7S7267C1D0Ev,_ZTv0_n28_N7S7267C1D0Ev)();
extern void ABISELECT(_ZThn41840_N7S7267C1D0Ev,_ZThn32248_N7S7267C1D0Ev)() __attribute__((weak));
extern void _ZN7S7267C82v7Ev();
extern void _ZN7S7267C62v2Ev();
extern void _ZN7S7267C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N7S7267C1D1Ev,_ZTv0_n20_N7S7267C1D1Ev)();
extern void ABISELECT(_ZThn43408_N7S7267C1D1Ev,_ZThn33480_N7S7267C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S7267C1D0Ev,_ZTv0_n20_N7S7267C1D0Ev)();
extern void ABISELECT(_ZThn43408_N7S7267C1D0Ev,_ZThn33480_N7S7267C1D0Ev)() __attribute__((weak));
extern void _ZN8S7267C102v6Ev();
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
extern void _ZN8S7267C132v9Ev();
extern void ABISELECT(_ZTv0_n64_N7S7267C1D1Ev,_ZTv0_n32_N7S7267C1D1Ev)();
extern void ABISELECT(_ZThn44336_N7S7267C1D1Ev,_ZThn34184_N7S7267C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S7267C1D0Ev,_ZTv0_n32_N7S7267C1D0Ev)();
extern void ABISELECT(_ZThn44336_N7S7267C1D0Ev,_ZThn34184_N7S7267C1D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S7267C1D1Ev,_ZTv0_n16_N7S7267C1D1Ev)();
extern void ABISELECT(_ZThn44512_N7S7267C1D1Ev,_ZThn34288_N7S7267C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S7267C1D0Ev,_ZTv0_n16_N7S7267C1D0Ev)();
extern void ABISELECT(_ZThn44512_N7S7267C1D0Ev,_ZThn34288_N7S7267C1D0Ev)() __attribute__((weak));
extern void _ZN7S7267C82v7Ev();
extern void _ZN7S7267C22v8Ev();
extern void ABISELECT(_ZTv0_n72_N7S7267C1D1Ev,_ZTv0_n36_N7S7267C1D1Ev)();
extern void ABISELECT(_ZThn44944_N7S7267C1D1Ev,_ZThn34636_N7S7267C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N7S7267C1D0Ev,_ZTv0_n36_N7S7267C1D0Ev)();
extern void ABISELECT(_ZThn44944_N7S7267C1D0Ev,_ZThn34636_N7S7267C1D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7267C1[] = {
  ABISELECT(44944,34636),
  ABISELECT(44632,34384),
  ABISELECT(44512,34288),
  ABISELECT(44336,34184),
  ABISELECT(44168,34088),
  ABISELECT(43408,33480),
  ABISELECT(42536,32816),
  ABISELECT(42504,32788),
  ABISELECT(41840,32248),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C1[0]),
  (VTBL_ENTRY)&_ZN7S7267C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7267C1D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C1D0Ev,
  (VTBL_ENTRY)&_ZN7S7267C12v1Ev,
  ABISELECT(9680,7328),
  ABISELECT(9504,7224),
  ABISELECT(7008,5288),
  ABISELECT(10112,7676),
  ABISELECT(9800,7424),
  ABISELECT(9336,7128),
  ABISELECT(8576,6520),
  ABISELECT(7704,5856),
  ABISELECT(7672,5828),
  ABISELECT(-34832,-26960),
  (VTBL_ENTRY)&(_ZTI7S7267C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn34832_N7S7267C1D1Ev,_ZThn26960_N7S7267C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn34832_N7S7267C1D0Ev,_ZThn26960_N7S7267C1D0Ev),
  (VTBL_ENTRY)&_ZN8S7267C143v10Ev,
  ABISELECT(-34984,-27084),
  (VTBL_ENTRY)&(_ZTI7S7267C1[0]),
  (VTBL_ENTRY)&_ZN7S7267C82v7Ev,
  ABISELECT(8664,6588),
  ABISELECT(7000,5288),
  ABISELECT(9128,6884),
  ABISELECT(-35504,-27500),
  (VTBL_ENTRY)&(_ZTI7S7267C1[0]),
  (VTBL_ENTRY)&_ZN7S7267C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7267C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn35504_N7S7267C1D1Ev,_ZThn27500_N7S7267C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn35504_N7S7267C1D0Ev,_ZThn27500_N7S7267C1D0Ev),
  ABISELECT(7792,5924),
  ABISELECT(6128,4624),
  ABISELECT(-36376,-28164),
  (VTBL_ENTRY)&(_ZTI7S7267C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn36376_N7S7267C1D1Ev,_ZThn28164_N7S7267C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn36376_N7S7267C1D0Ev,_ZThn28164_N7S7267C1D0Ev),
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
  ABISELECT(-39744,-30732),
  (VTBL_ENTRY)&(_ZTI7S7267C1[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
  ABISELECT(152,124),
  ABISELECT(-41840,-32248),
  ABISELECT(2328,1840),
  ABISELECT(1568,1232),
  ABISELECT(696,568),
  ABISELECT(664,540),
  ABISELECT(-41840,-32248),
  (VTBL_ENTRY)&(_ZTI7S7267C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7267C1D1Ev,_ZTv0_n28_N7S7267C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7267C1D0Ev,_ZTv0_n28_N7S7267C1D0Ev),
  ABISELECT(-41992,-32372),
  (VTBL_ENTRY)&(_ZTI7S7267C1[0]),
  (VTBL_ENTRY)&_ZN7S7267C82v7Ev,
  0,
  0,
  ABISELECT(-42536,-32816),
  (VTBL_ENTRY)&(_ZTI7S7267C1[0]),
  (VTBL_ENTRY)&_ZN7S7267C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7267C62v3Ev,
  0,
  ABISELECT(-43408,-33480),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-43408,-33480),
  (VTBL_ENTRY)&(_ZTI7S7267C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7267C1D1Ev,_ZTv0_n20_N7S7267C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7267C1D0Ev,_ZTv0_n20_N7S7267C1D0Ev),
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
  0,
  0,
  ABISELECT(-44168,-34088),
  (VTBL_ENTRY)&(_ZTI7S7267C1[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
  ABISELECT(-44336,-34184),
  0,
  0,
  0,
  ABISELECT(-1832,-1396),
  ABISELECT(176,104),
  ABISELECT(-44336,-34184),
  (VTBL_ENTRY)&(_ZTI7S7267C1[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
  (VTBL_ENTRY)&_ZN8S7267C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S7267C1D1Ev,_ZTv0_n32_N7S7267C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S7267C1D0Ev,_ZTv0_n32_N7S7267C1D0Ev),
  ABISELECT(-44512,-34288),
  ABISELECT(-2008,-1500),
  ABISELECT(-44512,-34288),
  (VTBL_ENTRY)&(_ZTI7S7267C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S7267C1D1Ev,_ZTv0_n16_N7S7267C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S7267C1D0Ev,_ZTv0_n16_N7S7267C1D0Ev),
  0,
  ABISELECT(-44632,-34384),
  (VTBL_ENTRY)&(_ZTI7S7267C1[0]),
  (VTBL_ENTRY)&_ZN7S7267C82v7Ev,
  ABISELECT(-44944,-34636),
  0,
  ABISELECT(-776,-548),
  ABISELECT(-1536,-1156),
  ABISELECT(-2408,-1820),
  ABISELECT(-2440,-1848),
  ABISELECT(-3104,-2388),
  ABISELECT(-44944,-34636),
  (VTBL_ENTRY)&(_ZTI7S7267C1[0]),
  (VTBL_ENTRY)&_ZN7S7267C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N7S7267C1D1Ev,_ZTv0_n36_N7S7267C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N7S7267C1D0Ev,_ZTv0_n36_N7S7267C1D0Ev),
};
extern VTBL_ENTRY _ZTV7S7267C1[];
extern void _ZN7S7267C22v8Ev();
extern void _ZN7S7267C2D1Ev();
extern void _ZN7S7267C2D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C2__A__7S7267C1[] = {
  ABISELECT(44168,34088),
  ABISELECT(43408,33480),
  ABISELECT(42536,32816),
  ABISELECT(42504,32788),
  ABISELECT(41840,32248),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C2[0]),
  (VTBL_ENTRY)&_ZN7S7267C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7267C2D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C2D0Ev,
};
extern void ABISELECT(_ZTv0_n56_N7S7267C2D1Ev,_ZTv0_n28_N7S7267C2D1Ev)();
extern void ABISELECT(_ZThn41840_N7S7267C2D1Ev,_ZThn32248_N7S7267C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N7S7267C2D0Ev,_ZTv0_n28_N7S7267C2D0Ev)();
extern void ABISELECT(_ZThn41840_N7S7267C2D0Ev,_ZThn32248_N7S7267C2D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7267C3__7S7267C2__A__7S7267C1[] = {
  ABISELECT(152,124),
  ABISELECT(-41840,-32248),
  ABISELECT(2328,1840),
  ABISELECT(1568,1232),
  ABISELECT(696,568),
  ABISELECT(664,540),
  ABISELECT(-41840,-32248),
  (VTBL_ENTRY)&(_ZTI7S7267C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7267C2D1Ev,_ZTv0_n28_N7S7267C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7267C2D0Ev,_ZTv0_n28_N7S7267C2D0Ev),
};
extern void _ZN7S7267C62v2Ev();
extern void _ZN7S7267C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C6__7S7267C2__A__7S7267C1[] = {
  0,
  0,
  ABISELECT(-42536,-32816),
  (VTBL_ENTRY)&(_ZTI7S7267C2[0]),
  (VTBL_ENTRY)&_ZN7S7267C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7267C62v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S7267C2D1Ev,_ZTv0_n20_N7S7267C2D1Ev)();
extern void ABISELECT(_ZThn43408_N7S7267C2D1Ev,_ZThn33480_N7S7267C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S7267C2D0Ev,_ZTv0_n20_N7S7267C2D0Ev)();
extern void ABISELECT(_ZThn43408_N7S7267C2D0Ev,_ZThn33480_N7S7267C2D0Ev)() __attribute__((weak));
extern void _ZN8S7267C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C10__7S7267C2__A__7S7267C1[] = {
  0,
  ABISELECT(-43408,-33480),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-43408,-33480),
  (VTBL_ENTRY)&(_ZTI7S7267C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7267C2D1Ev,_ZTv0_n20_N7S7267C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7267C2D0Ev,_ZTv0_n20_N7S7267C2D0Ev),
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C11__7S7267C2__A__7S7267C1[] = {
  0,
  0,
  ABISELECT(-44168,-34088),
  (VTBL_ENTRY)&(_ZTI7S7267C2[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
};
extern void _ZN7S7267C82v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C87S7267C3__7S7267C2__A__7S7267C1[] = {
  ABISELECT(-41992,-32372),
  (VTBL_ENTRY)&(_ZTI7S7267C2[0]),
  (VTBL_ENTRY)&_ZN7S7267C82v7Ev,
};
extern void _ZN8S7267C12D1Ev();
extern void _ZN8S7267C12D0Ev();
extern void _ZN8S7267C143v10Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C12__7S7267C1[] = {
  ABISELECT(9680,7328),
  ABISELECT(9504,7224),
  ABISELECT(7008,5288),
  ABISELECT(10112,7676),
  ABISELECT(9800,7424),
  ABISELECT(9336,7128),
  ABISELECT(8576,6520),
  ABISELECT(7704,5856),
  ABISELECT(7672,5828),
  0,
  (VTBL_ENTRY)&(_ZTI8S7267C12[0]),
  (VTBL_ENTRY)&_ZN8S7267C12D1Ev,
  (VTBL_ENTRY)&_ZN8S7267C12D0Ev,
  (VTBL_ENTRY)&_ZN8S7267C143v10Ev,
};
extern void _ZN8S7267C14D1Ev();
extern void _ZN8S7267C14D0Ev();
extern void _ZN8S7267C143v10Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C148S7267C12__7S7267C1[] = {
  ABISELECT(9680,7328),
  ABISELECT(9504,7224),
  ABISELECT(7008,5288),
  ABISELECT(10112,7676),
  ABISELECT(9800,7424),
  ABISELECT(9336,7128),
  ABISELECT(8576,6520),
  ABISELECT(7704,5856),
  ABISELECT(7672,5828),
  0,
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&_ZN8S7267C14D1Ev,
  (VTBL_ENTRY)&_ZN8S7267C14D0Ev,
  (VTBL_ENTRY)&_ZN8S7267C143v10Ev,
};
extern void _ZN7S7267C3D1Ev();
extern void _ZN7S7267C3D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C38S7267C148S7267C12__A1__7S7267C1[] = {
  ABISELECT(9336,7128),
  ABISELECT(8576,6520),
  ABISELECT(7704,5856),
  ABISELECT(7672,5828),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&_ZN7S7267C3D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C3D0Ev,
};
extern void _ZN7S7267C5D1Ev();
extern void _ZN7S7267C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C57S7267C38S7267C148S7267C12__A3__7S7267C1[] = {
  ABISELECT(7672,5828),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C5[0]),
  (VTBL_ENTRY)&_ZN7S7267C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C5D0Ev,
};
extern void _ZN7S7267C62v2Ev();
extern void _ZN7S7267C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C6__7S7267C38S7267C148S7267C12__A1__7S7267C1[] = {
  0,
  0,
  ABISELECT(-7704,-5856),
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&_ZN7S7267C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7267C62v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S7267C3D1Ev,_ZTv0_n20_N7S7267C3D1Ev)();
extern void ABISELECT(_ZThn8576_N7S7267C3D1Ev,_ZThn6520_N7S7267C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S7267C3D0Ev,_ZTv0_n20_N7S7267C3D0Ev)();
extern void ABISELECT(_ZThn8576_N7S7267C3D0Ev,_ZThn6520_N7S7267C3D0Ev)() __attribute__((weak));
extern void _ZN8S7267C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C10__7S7267C38S7267C148S7267C12__A1__7S7267C1[] = {
  0,
  ABISELECT(-8576,-6520),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-8576,-6520),
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7267C3D1Ev,_ZTv0_n20_N7S7267C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7267C3D0Ev,_ZTv0_n20_N7S7267C3D0Ev),
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C11__7S7267C38S7267C148S7267C12__A1__7S7267C1[] = {
  0,
  0,
  ABISELECT(-9336,-7128),
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
};
extern void _ZN7S7267C62v2Ev();
extern void _ZN7S7267C62v3Ev();
extern void _ZN8S7267C15D1Ev();
extern void _ZN8S7267C15D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C158S7267C148S7267C12__7S7267C1[] = {
  ABISELECT(8664,6588),
  ABISELECT(7000,5288),
  ABISELECT(9128,6884),
  0,
  (VTBL_ENTRY)&(_ZTI8S7267C15[0]),
  (VTBL_ENTRY)&_ZN7S7267C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7267C62v3Ev,
  (VTBL_ENTRY)&_ZN8S7267C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7267C15D0Ev,
};
extern void _ZN8S7267C10D1Ev();
extern void _ZN8S7267C10D0Ev();
extern void _ZN8S7267C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C108S7267C158S7267C148S7267C12__A1__7S7267C1[] = {
  ABISELECT(7792,5924),
  ABISELECT(6128,4624),
  0,
  (VTBL_ENTRY)&(_ZTI8S7267C10[0]),
  (VTBL_ENTRY)&_ZN8S7267C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7267C10D0Ev,
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
};
extern void _ZN7S7267C5D1Ev();
extern void _ZN7S7267C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C58S7267C108S7267C158S7267C148S7267C12__A4__7S7267C1[] = {
  ABISELECT(6128,4624),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C5[0]),
  (VTBL_ENTRY)&_ZN7S7267C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C5D0Ev,
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C11__8S7267C108S7267C158S7267C148S7267C12__A1__7S7267C1[] = {
  0,
  0,
  ABISELECT(-7792,-5924),
  (VTBL_ENTRY)&(_ZTI8S7267C10[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
};
extern void _ZN7S7267C82v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C8__8S7267C158S7267C148S7267C12__7S7267C1[] = {
  0,
  ABISELECT(-9128,-6884),
  (VTBL_ENTRY)&(_ZTI8S7267C15[0]),
  (VTBL_ENTRY)&_ZN7S7267C82v7Ev,
};
extern void ABISELECT(_ZThn872_N8S7267C15D1Ev,_ZThn664_N8S7267C15D1Ev)();
extern void ABISELECT(_ZThn872_N8S7267C15D0Ev,_ZThn664_N8S7267C15D0Ev)();
extern void _ZN8S7267C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C10__8S7267C158S7267C148S7267C12__7S7267C1[] = {
  ABISELECT(7792,5924),
  ABISELECT(6128,4624),
  ABISELECT(-872,-664),
  (VTBL_ENTRY)&(_ZTI8S7267C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn872_N8S7267C15D1Ev,_ZThn664_N8S7267C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn872_N8S7267C15D0Ev,_ZThn664_N8S7267C15D0Ev),
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C11__8S7267C158S7267C148S7267C12__7S7267C1[] = {
  0,
  0,
  ABISELECT(-8664,-6588),
  (VTBL_ENTRY)&(_ZTI8S7267C15[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
};
extern void _ZN7S7267C62v2Ev();
extern void _ZN7S7267C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C6__8S7267C148S7267C12__7S7267C1[] = {
  0,
  0,
  ABISELECT(-7704,-5856),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&_ZN7S7267C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7267C62v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S7267C14D1Ev,_ZTv0_n20_N8S7267C14D1Ev)();
extern void ABISELECT(_ZThn8576_N8S7267C14D1Ev,_ZThn6520_N8S7267C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7267C14D0Ev,_ZTv0_n20_N8S7267C14D0Ev)();
extern void ABISELECT(_ZThn8576_N8S7267C14D0Ev,_ZThn6520_N8S7267C14D0Ev)() __attribute__((weak));
extern void _ZN8S7267C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C10__8S7267C148S7267C12__7S7267C1[] = {
  0,
  ABISELECT(-8576,-6520),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-8576,-6520),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7267C14D1Ev,_ZTv0_n20_N8S7267C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7267C14D0Ev,_ZTv0_n20_N8S7267C14D0Ev),
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C11__8S7267C148S7267C12__7S7267C1[] = {
  0,
  0,
  ABISELECT(-9336,-7128),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
};
extern void _ZN7S7267C62v2Ev();
extern void _ZN7S7267C62v3Ev();
extern void ABISELECT(_ZThn672_N8S7267C14D1Ev,_ZThn540_N8S7267C14D1Ev)();
extern void ABISELECT(_ZThn672_N8S7267C14D0Ev,_ZThn540_N8S7267C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S7267C15__8S7267C148S7267C12__7S7267C1[] = {
  ABISELECT(8664,6588),
  ABISELECT(7000,5288),
  ABISELECT(9128,6884),
  ABISELECT(-672,-540),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&_ZN7S7267C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7267C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S7267C14D1Ev,_ZThn540_N8S7267C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S7267C14D0Ev,_ZThn540_N8S7267C14D0Ev),
};
extern void _ZN7S7267C82v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C8__A1__8S7267C148S7267C12__7S7267C1[] = {
  0,
  ABISELECT(-9800,-7424),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&_ZN7S7267C82v7Ev,
};
extern void ABISELECT(_ZThn1544_N8S7267C14D1Ev,_ZThn1204_N8S7267C14D1Ev)();
extern void ABISELECT(_ZThn1544_N8S7267C14D0Ev,_ZThn1204_N8S7267C14D0Ev)();
extern void _ZN8S7267C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C108S7267C15__A1__8S7267C148S7267C12__7S7267C1[] = {
  ABISELECT(7792,5924),
  ABISELECT(6128,4624),
  ABISELECT(-1544,-1204),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1544_N8S7267C14D1Ev,_ZThn1204_N8S7267C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1544_N8S7267C14D0Ev,_ZThn1204_N8S7267C14D0Ev),
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
};
extern void _ZN7S7267C22v8Ev();
extern void ABISELECT(_ZTv0_n72_N8S7267C14D1Ev,_ZTv0_n36_N8S7267C14D1Ev)();
extern void ABISELECT(_ZThn10112_N8S7267C14D1Ev,_ZThn7676_N8S7267C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S7267C14D0Ev,_ZTv0_n36_N8S7267C14D0Ev)();
extern void ABISELECT(_ZThn10112_N8S7267C14D0Ev,_ZThn7676_N8S7267C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7267C2__8S7267C148S7267C12__7S7267C1[] = {
  ABISELECT(-10112,-7676),
  0,
  ABISELECT(-776,-548),
  ABISELECT(-1536,-1156),
  ABISELECT(-2408,-1820),
  ABISELECT(-2440,-1848),
  ABISELECT(-3104,-2388),
  ABISELECT(-10112,-7676),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&_ZN7S7267C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S7267C14D1Ev,_ZTv0_n36_N8S7267C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S7267C14D0Ev,_ZTv0_n36_N8S7267C14D0Ev),
};
extern void ABISELECT(_ZTv0_n56_N8S7267C14D1Ev,_ZTv0_n28_N8S7267C14D1Ev)();
extern void ABISELECT(_ZThn7008_N8S7267C14D1Ev,_ZThn5288_N8S7267C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7267C14D0Ev,_ZTv0_n28_N8S7267C14D0Ev)();
extern void ABISELECT(_ZThn7008_N8S7267C14D0Ev,_ZThn5288_N8S7267C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7267C3__A1__8S7267C148S7267C12__7S7267C1[] = {
  ABISELECT(152,124),
  ABISELECT(-7008,-5288),
  ABISELECT(2328,1840),
  ABISELECT(1568,1232),
  ABISELECT(696,568),
  ABISELECT(664,540),
  ABISELECT(-7008,-5288),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7267C14D1Ev,_ZTv0_n28_N8S7267C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7267C14D0Ev,_ZTv0_n28_N8S7267C14D0Ev),
};
extern void _ZN7S7267C82v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C87S7267C3__A2__8S7267C148S7267C12__7S7267C1[] = {
  ABISELECT(-7160,-5412),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&_ZN7S7267C82v7Ev,
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
extern void _ZN8S7267C132v9Ev();
extern void ABISELECT(_ZTv0_n64_N8S7267C14D1Ev,_ZTv0_n32_N8S7267C14D1Ev)();
extern void ABISELECT(_ZThn9504_N8S7267C14D1Ev,_ZThn7224_N8S7267C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S7267C14D0Ev,_ZTv0_n32_N8S7267C14D0Ev)();
extern void ABISELECT(_ZThn9504_N8S7267C14D0Ev,_ZThn7224_N8S7267C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7267C13__8S7267C148S7267C12__7S7267C1[] = {
  ABISELECT(-9504,-7224),
  0,
  0,
  0,
  ABISELECT(-1832,-1396),
  ABISELECT(176,104),
  ABISELECT(-9504,-7224),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
  (VTBL_ENTRY)&_ZN8S7267C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7267C14D1Ev,_ZTv0_n32_N8S7267C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7267C14D0Ev,_ZTv0_n32_N8S7267C14D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S7267C14D1Ev,_ZTv0_n16_N8S7267C14D1Ev)();
extern void ABISELECT(_ZThn9680_N8S7267C14D1Ev,_ZThn7328_N8S7267C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7267C14D0Ev,_ZTv0_n16_N8S7267C14D0Ev)();
extern void ABISELECT(_ZThn9680_N8S7267C14D0Ev,_ZThn7328_N8S7267C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7267C5__A4__8S7267C148S7267C12__7S7267C1[] = {
  ABISELECT(-9680,-7328),
  ABISELECT(-2008,-1500),
  ABISELECT(-9680,-7328),
  (VTBL_ENTRY)&(_ZTI8S7267C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7267C14D1Ev,_ZTv0_n16_N8S7267C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7267C14D0Ev,_ZTv0_n16_N8S7267C14D0Ev),
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
extern void _ZN8S7267C132v9Ev();
extern void ABISELECT(_ZTv0_n64_N8S7267C12D1Ev,_ZTv0_n32_N8S7267C12D1Ev)();
extern void ABISELECT(_ZThn9504_N8S7267C12D1Ev,_ZThn7224_N8S7267C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S7267C12D0Ev,_ZTv0_n32_N8S7267C12D0Ev)();
extern void ABISELECT(_ZThn9504_N8S7267C12D0Ev,_ZThn7224_N8S7267C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7267C13__8S7267C12__7S7267C1[] = {
  ABISELECT(-9504,-7224),
  0,
  0,
  0,
  ABISELECT(-1832,-1396),
  ABISELECT(176,104),
  ABISELECT(-9504,-7224),
  (VTBL_ENTRY)&(_ZTI8S7267C12[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
  (VTBL_ENTRY)&_ZN8S7267C132v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7267C12D1Ev,_ZTv0_n32_N8S7267C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7267C12D0Ev,_ZTv0_n32_N8S7267C12D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S7267C12D1Ev,_ZTv0_n16_N8S7267C12D1Ev)();
extern void ABISELECT(_ZThn9680_N8S7267C12D1Ev,_ZThn7328_N8S7267C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7267C12D0Ev,_ZTv0_n16_N8S7267C12D0Ev)();
extern void ABISELECT(_ZThn9680_N8S7267C12D0Ev,_ZThn7328_N8S7267C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7267C5__8S7267C12__7S7267C1[] = {
  ABISELECT(-9680,-7328),
  ABISELECT(-2008,-1500),
  ABISELECT(-9680,-7328),
  (VTBL_ENTRY)&(_ZTI8S7267C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7267C12D1Ev,_ZTv0_n16_N8S7267C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7267C12D0Ev,_ZTv0_n16_N8S7267C12D0Ev),
};
extern void _ZN7S7267C62v2Ev();
extern void _ZN7S7267C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C6__8S7267C12__7S7267C1[] = {
  0,
  0,
  ABISELECT(-7704,-5856),
  (VTBL_ENTRY)&(_ZTI8S7267C12[0]),
  (VTBL_ENTRY)&_ZN7S7267C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7267C62v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S7267C12D1Ev,_ZTv0_n20_N8S7267C12D1Ev)();
extern void ABISELECT(_ZThn8576_N8S7267C12D1Ev,_ZThn6520_N8S7267C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7267C12D0Ev,_ZTv0_n20_N8S7267C12D0Ev)();
extern void ABISELECT(_ZThn8576_N8S7267C12D0Ev,_ZThn6520_N8S7267C12D0Ev)() __attribute__((weak));
extern void _ZN8S7267C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C10__8S7267C12__7S7267C1[] = {
  0,
  ABISELECT(-8576,-6520),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-8576,-6520),
  (VTBL_ENTRY)&(_ZTI8S7267C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7267C12D1Ev,_ZTv0_n20_N8S7267C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7267C12D0Ev,_ZTv0_n20_N8S7267C12D0Ev),
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C11__A1__8S7267C12__7S7267C1[] = {
  0,
  0,
  ABISELECT(-9336,-7128),
  (VTBL_ENTRY)&(_ZTI8S7267C12[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
};
extern void _ZN7S7267C62v2Ev();
extern void _ZN7S7267C62v3Ev();
extern void ABISELECT(_ZThn672_N8S7267C12D1Ev,_ZThn540_N8S7267C12D1Ev)();
extern void ABISELECT(_ZThn672_N8S7267C12D0Ev,_ZThn540_N8S7267C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S7267C158S7267C14__8S7267C12__7S7267C1[] = {
  ABISELECT(8664,6588),
  ABISELECT(7000,5288),
  ABISELECT(9128,6884),
  ABISELECT(-672,-540),
  (VTBL_ENTRY)&(_ZTI8S7267C12[0]),
  (VTBL_ENTRY)&_ZN7S7267C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7267C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S7267C12D1Ev,_ZThn540_N8S7267C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S7267C12D0Ev,_ZThn540_N8S7267C12D0Ev),
};
extern void _ZN7S7267C82v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C8__A1__8S7267C12__7S7267C1[] = {
  0,
  ABISELECT(-9800,-7424),
  (VTBL_ENTRY)&(_ZTI8S7267C12[0]),
  (VTBL_ENTRY)&_ZN7S7267C82v7Ev,
};
extern void ABISELECT(_ZThn1544_N8S7267C12D1Ev,_ZThn1204_N8S7267C12D1Ev)();
extern void ABISELECT(_ZThn1544_N8S7267C12D0Ev,_ZThn1204_N8S7267C12D0Ev)();
extern void _ZN8S7267C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C108S7267C158S7267C14__A1__8S7267C12__7S7267C1[] = {
  ABISELECT(7792,5924),
  ABISELECT(6128,4624),
  ABISELECT(-1544,-1204),
  (VTBL_ENTRY)&(_ZTI8S7267C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1544_N8S7267C12D1Ev,_ZThn1204_N8S7267C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1544_N8S7267C12D0Ev,_ZThn1204_N8S7267C12D0Ev),
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
};
extern void _ZN7S7267C22v8Ev();
extern void ABISELECT(_ZTv0_n72_N8S7267C12D1Ev,_ZTv0_n36_N8S7267C12D1Ev)();
extern void ABISELECT(_ZThn10112_N8S7267C12D1Ev,_ZThn7676_N8S7267C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S7267C12D0Ev,_ZTv0_n36_N8S7267C12D0Ev)();
extern void ABISELECT(_ZThn10112_N8S7267C12D0Ev,_ZThn7676_N8S7267C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7267C2__8S7267C12__7S7267C1[] = {
  ABISELECT(-10112,-7676),
  0,
  ABISELECT(-776,-548),
  ABISELECT(-1536,-1156),
  ABISELECT(-2408,-1820),
  ABISELECT(-2440,-1848),
  ABISELECT(-3104,-2388),
  ABISELECT(-10112,-7676),
  (VTBL_ENTRY)&(_ZTI8S7267C12[0]),
  (VTBL_ENTRY)&_ZN7S7267C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S7267C12D1Ev,_ZTv0_n36_N8S7267C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S7267C12D0Ev,_ZTv0_n36_N8S7267C12D0Ev),
};
extern void ABISELECT(_ZTv0_n56_N8S7267C12D1Ev,_ZTv0_n28_N8S7267C12D1Ev)();
extern void ABISELECT(_ZThn7008_N8S7267C12D1Ev,_ZThn5288_N8S7267C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7267C12D0Ev,_ZTv0_n28_N8S7267C12D0Ev)();
extern void ABISELECT(_ZThn7008_N8S7267C12D0Ev,_ZThn5288_N8S7267C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7267C3__A1__8S7267C12__7S7267C1[] = {
  ABISELECT(152,124),
  ABISELECT(-7008,-5288),
  ABISELECT(2328,1840),
  ABISELECT(1568,1232),
  ABISELECT(696,568),
  ABISELECT(664,540),
  ABISELECT(-7008,-5288),
  (VTBL_ENTRY)&(_ZTI8S7267C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7267C12D1Ev,_ZTv0_n28_N8S7267C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7267C12D0Ev,_ZTv0_n28_N8S7267C12D0Ev),
};
extern void _ZN7S7267C82v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C87S7267C3__A2__8S7267C12__7S7267C1[] = {
  ABISELECT(-7160,-5412),
  (VTBL_ENTRY)&(_ZTI8S7267C12[0]),
  (VTBL_ENTRY)&_ZN7S7267C82v7Ev,
};
extern void _ZN7S7267C3D1Ev();
extern void _ZN7S7267C3D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C3__7S7267C1[] = {
  ABISELECT(2328,1840),
  ABISELECT(1568,1232),
  ABISELECT(696,568),
  ABISELECT(664,540),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&_ZN7S7267C3D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C3D0Ev,
};
extern void _ZN7S7267C5D1Ev();
extern void _ZN7S7267C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C57S7267C3__7S7267C1[] = {
  ABISELECT(664,540),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C5[0]),
  (VTBL_ENTRY)&_ZN7S7267C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C5D0Ev,
};
extern void _ZN7S7267C62v2Ev();
extern void _ZN7S7267C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C6__7S7267C3__7S7267C1[] = {
  0,
  0,
  ABISELECT(-696,-568),
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&_ZN7S7267C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7267C62v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S7267C3D1Ev,_ZTv0_n20_N7S7267C3D1Ev)();
extern void ABISELECT(_ZThn1568_N7S7267C3D1Ev,_ZThn1232_N7S7267C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S7267C3D0Ev,_ZTv0_n20_N7S7267C3D0Ev)();
extern void ABISELECT(_ZThn1568_N7S7267C3D0Ev,_ZThn1232_N7S7267C3D0Ev)() __attribute__((weak));
extern void _ZN8S7267C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C10__7S7267C3__7S7267C1[] = {
  0,
  ABISELECT(-1568,-1232),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-1568,-1232),
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7267C3D1Ev,_ZTv0_n20_N7S7267C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7267C3D0Ev,_ZTv0_n20_N7S7267C3D0Ev),
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C11__7S7267C3__7S7267C1[] = {
  0,
  0,
  ABISELECT(-2328,-1840),
  (VTBL_ENTRY)&(_ZTI7S7267C3[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
};
extern void _ZN8S7267C10D1Ev();
extern void _ZN8S7267C10D0Ev();
extern void _ZN8S7267C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C10__7S7267C1[] = {
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  0,
  (VTBL_ENTRY)&(_ZTI8S7267C10[0]),
  (VTBL_ENTRY)&_ZN8S7267C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7267C10D0Ev,
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
};
extern void _ZN7S7267C5D1Ev();
extern void _ZN7S7267C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C58S7267C10__A1__7S7267C1[] = {
  ABISELECT(-904,-692),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C5[0]),
  (VTBL_ENTRY)&_ZN7S7267C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C5D0Ev,
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C11__8S7267C10__7S7267C1[] = {
  0,
  0,
  ABISELECT(-760,-608),
  (VTBL_ENTRY)&(_ZTI8S7267C10[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
extern void _ZN8S7267C132v9Ev();
extern void _ZN8S7267C13D1Ev();
extern void _ZN8S7267C13D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C13__7S7267C1[] = {
  ABISELECT(-1832,-1396),
  ABISELECT(176,104),
  0,
  (VTBL_ENTRY)&(_ZTI8S7267C13[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
  (VTBL_ENTRY)&_ZN8S7267C132v9Ev,
  (VTBL_ENTRY)&_ZN8S7267C13D1Ev,
  (VTBL_ENTRY)&_ZN8S7267C13D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S7267C13D1Ev,_ZTv0_n16_N8S7267C13D1Ev)();
extern void ABISELECT(_ZThn176_N8S7267C13D1Ev,_ZThn104_N8S7267C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7267C13D0Ev,_ZTv0_n16_N8S7267C13D0Ev)();
extern void ABISELECT(_ZThn176_N8S7267C13D0Ev,_ZThn104_N8S7267C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7267C5__8S7267C13__7S7267C1[] = {
  ABISELECT(-176,-104),
  ABISELECT(-2008,-1500),
  ABISELECT(-176,-104),
  (VTBL_ENTRY)&(_ZTI8S7267C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7267C13D1Ev,_ZTv0_n16_N8S7267C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7267C13D0Ev,_ZTv0_n16_N8S7267C13D0Ev),
};
extern void _ZN7S7267C5D1Ev();
extern void _ZN7S7267C5D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C5__A2__7S7267C1[] = {
  ABISELECT(-2008,-1500),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C5[0]),
  (VTBL_ENTRY)&_ZN7S7267C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C5D0Ev,
};
extern void _ZN7S7267C22v8Ev();
extern void _ZN7S7267C2D1Ev();
extern void _ZN7S7267C2D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C2__A1__7S7267C1[] = {
  ABISELECT(-776,-548),
  ABISELECT(-1536,-1156),
  ABISELECT(-2408,-1820),
  ABISELECT(-2440,-1848),
  ABISELECT(-3104,-2388),
  0,
  (VTBL_ENTRY)&(_ZTI7S7267C2[0]),
  (VTBL_ENTRY)&_ZN7S7267C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7267C2D1Ev,
  (VTBL_ENTRY)&_ZN7S7267C2D0Ev,
};
extern void ABISELECT(_ZTv0_n56_N7S7267C2D1Ev,_ZTv0_n28_N7S7267C2D1Ev)();
extern void ABISELECT(_ZTv0_n56_N7S7267C2D0Ev,_ZTv0_n28_N7S7267C2D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S7267C3__7S7267C2__A1__7S7267C1[] = {
  ABISELECT(152,124),
  ABISELECT(3104,2388),
  ABISELECT(2328,1840),
  ABISELECT(1568,1232),
  ABISELECT(696,568),
  ABISELECT(664,540),
  ABISELECT(3104,2388),
  (VTBL_ENTRY)&(_ZTI7S7267C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7267C2D1Ev,_ZTv0_n28_N7S7267C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7267C2D0Ev,_ZTv0_n28_N7S7267C2D0Ev),
};
extern void _ZN7S7267C62v2Ev();
extern void _ZN7S7267C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C6__7S7267C2__A1__7S7267C1[] = {
  0,
  0,
  ABISELECT(2408,1820),
  (VTBL_ENTRY)&(_ZTI7S7267C2[0]),
  (VTBL_ENTRY)&_ZN7S7267C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7267C62v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S7267C2D1Ev,_ZTv0_n20_N7S7267C2D1Ev)();
extern void ABISELECT(_ZTv0_n40_N7S7267C2D0Ev,_ZTv0_n20_N7S7267C2D0Ev)();
extern void _ZN8S7267C102v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C10__7S7267C2__A1__7S7267C1[] = {
  0,
  ABISELECT(1536,1156),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(1536,1156),
  (VTBL_ENTRY)&(_ZTI7S7267C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7267C2D1Ev,_ZTv0_n20_N7S7267C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7267C2D0Ev,_ZTv0_n20_N7S7267C2D0Ev),
  (VTBL_ENTRY)&_ZN8S7267C102v6Ev,
};
extern void _ZN8S7267C112v4Ev();
extern void _ZN8S7267C112v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7267C11__7S7267C2__A1__7S7267C1[] = {
  0,
  0,
  ABISELECT(776,548),
  (VTBL_ENTRY)&(_ZTI7S7267C2[0]),
  (VTBL_ENTRY)&_ZN8S7267C112v4Ev,
  (VTBL_ENTRY)&_ZN8S7267C112v5Ev,
};
extern void _ZN7S7267C82v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7267C87S7267C3__7S7267C2__A1__7S7267C1[] = {
  ABISELECT(2952,2264),
  (VTBL_ENTRY)&(_ZTI7S7267C2[0]),
  (VTBL_ENTRY)&_ZN7S7267C82v7Ev,
};
static  VTT_ENTRY vtt_S7267C1[] = {
  {&(_ZTV7S7267C1[11]),  11,121},
  {&(_tg__ZTV7S7267C2__A__7S7267C1[7]),  7,10},
  {&(_tg__ZTV7S7267C3__7S7267C2__A__7S7267C1[8]),  8,10},
  {&(_tg__ZTV7S7267C6__7S7267C2__A__7S7267C1[4]),  4,6},
  {&(_tg__ZTV8S7267C10__7S7267C2__A__7S7267C1[6]),  6,9},
  {&(_tg__ZTV8S7267C11__7S7267C2__A__7S7267C1[4]),  4,6},
  {&(_tg__ZTV7S7267C87S7267C3__7S7267C2__A__7S7267C1[2]),  2,3},
  {&(_tg__ZTV8S7267C12__7S7267C1[11]),  11,14},
  {&(_tg__ZTV8S7267C148S7267C12__7S7267C1[11]),  11,14},
  {&(_tg__ZTV7S7267C38S7267C148S7267C12__A1__7S7267C1[6]),  6,8},
  {&(_tg__ZTV7S7267C57S7267C38S7267C148S7267C12__A3__7S7267C1[3]),  3,5},
  {&(_tg__ZTV7S7267C6__7S7267C38S7267C148S7267C12__A1__7S7267C1[4]),  4,6},
  {&(_tg__ZTV8S7267C10__7S7267C38S7267C148S7267C12__A1__7S7267C1[6]),  6,9},
  {&(_tg__ZTV8S7267C11__7S7267C38S7267C148S7267C12__A1__7S7267C1[4]),  4,6},
  {&(_tg__ZTV8S7267C158S7267C148S7267C12__7S7267C1[5]),  5,9},
  {&(_tg__ZTV8S7267C108S7267C158S7267C148S7267C12__A1__7S7267C1[4]),  4,7},
  {&(_tg__ZTV7S7267C58S7267C108S7267C158S7267C148S7267C12__A4__7S7267C1[3]),  3,5},
  {&(_tg__ZTV8S7267C11__8S7267C108S7267C158S7267C148S7267C12__A1__7S7267C1[4]),  4,6},
  {&(_tg__ZTV7S7267C8__8S7267C158S7267C148S7267C12__7S7267C1[3]),  3,4},
  {&(_tg__ZTV8S7267C10__8S7267C158S7267C148S7267C12__7S7267C1[4]),  4,7},
  {&(_tg__ZTV8S7267C11__8S7267C158S7267C148S7267C12__7S7267C1[4]),  4,6},
  {&(_tg__ZTV7S7267C6__8S7267C148S7267C12__7S7267C1[4]),  4,6},
  {&(_tg__ZTV8S7267C10__8S7267C148S7267C12__7S7267C1[6]),  6,9},
  {&(_tg__ZTV8S7267C11__8S7267C148S7267C12__7S7267C1[4]),  4,6},
  {&(_tg__ZTV8S7267C15__8S7267C148S7267C12__7S7267C1[5]),  5,9},
  {&(_tg__ZTV7S7267C8__A1__8S7267C148S7267C12__7S7267C1[3]),  3,4},
  {&(_tg__ZTV8S7267C108S7267C15__A1__8S7267C148S7267C12__7S7267C1[4]),  4,7},
  {&(_tg__ZTV7S7267C2__8S7267C148S7267C12__7S7267C1[9]),  9,12},
  {&(_tg__ZTV7S7267C3__A1__8S7267C148S7267C12__7S7267C1[8]),  8,10},
  {&(_tg__ZTV7S7267C87S7267C3__A2__8S7267C148S7267C12__7S7267C1[2]),  2,3},
  {&(_tg__ZTV8S7267C13__8S7267C148S7267C12__7S7267C1[8]),  8,13},
  {&(_tg__ZTV7S7267C5__A4__8S7267C148S7267C12__7S7267C1[4]),  4,6},
  {&(_tg__ZTV8S7267C13__8S7267C12__7S7267C1[8]),  8,13},
  {&(_tg__ZTV7S7267C5__8S7267C12__7S7267C1[4]),  4,6},
  {&(_tg__ZTV7S7267C6__8S7267C12__7S7267C1[4]),  4,6},
  {&(_tg__ZTV8S7267C10__8S7267C12__7S7267C1[6]),  6,9},
  {&(_tg__ZTV8S7267C11__A1__8S7267C12__7S7267C1[4]),  4,6},
  {&(_tg__ZTV8S7267C158S7267C14__8S7267C12__7S7267C1[5]),  5,9},
  {&(_tg__ZTV7S7267C8__A1__8S7267C12__7S7267C1[3]),  3,4},
  {&(_tg__ZTV8S7267C108S7267C158S7267C14__A1__8S7267C12__7S7267C1[4]),  4,7},
  {&(_tg__ZTV7S7267C2__8S7267C12__7S7267C1[9]),  9,12},
  {&(_tg__ZTV7S7267C3__A1__8S7267C12__7S7267C1[8]),  8,10},
  {&(_tg__ZTV7S7267C87S7267C3__A2__8S7267C12__7S7267C1[2]),  2,3},
  {&(_ZTV7S7267C1[60]),  60,121},
  {&(_ZTV7S7267C1[69]),  69,121},
  {&(_ZTV7S7267C1[77]),  77,121},
  {&(_ZTV7S7267C1[84]),  84,121},
  {&(_ZTV7S7267C1[64]),  64,121},
  {&(_ZTV7S7267C1[26]),  26,121},
  {&(_ZTV7S7267C1[94]),  94,121},
  {&(_ZTV7S7267C1[103]),  103,121},
  {&(_ZTV7S7267C1[37]),  37,121},
  {&(_ZTV7S7267C1[108]),  108,121},
  {&(_ZTV7S7267C1[45]),  45,121},
  {&(_ZTV7S7267C1[118]),  118,121},
  {&(_tg__ZTV7S7267C3__7S7267C1[6]),  6,8},
  {&(_tg__ZTV7S7267C57S7267C3__7S7267C1[3]),  3,5},
  {&(_tg__ZTV7S7267C6__7S7267C3__7S7267C1[4]),  4,6},
  {&(_tg__ZTV8S7267C10__7S7267C3__7S7267C1[6]),  6,9},
  {&(_tg__ZTV8S7267C11__7S7267C3__7S7267C1[4]),  4,6},
  {&(_tg__ZTV8S7267C10__7S7267C1[4]),  4,7},
  {&(_tg__ZTV7S7267C58S7267C10__A1__7S7267C1[3]),  3,5},
  {&(_tg__ZTV8S7267C11__8S7267C10__7S7267C1[4]),  4,6},
  {&(_tg__ZTV8S7267C13__7S7267C1[4]),  4,9},
  {&(_tg__ZTV7S7267C5__8S7267C13__7S7267C1[4]),  4,6},
  {&(_tg__ZTV7S7267C5__A2__7S7267C1[3]),  3,5},
  {&(_tg__ZTV7S7267C2__A1__7S7267C1[7]),  7,10},
  {&(_tg__ZTV7S7267C3__7S7267C2__A1__7S7267C1[8]),  8,10},
  {&(_tg__ZTV7S7267C6__7S7267C2__A1__7S7267C1[4]),  4,6},
  {&(_tg__ZTV8S7267C10__7S7267C2__A1__7S7267C1[6]),  6,9},
  {&(_tg__ZTV8S7267C11__7S7267C2__A1__7S7267C1[4]),  4,6},
  {&(_tg__ZTV7S7267C87S7267C3__7S7267C2__A1__7S7267C1[2]),  2,3},
};
extern VTBL_ENTRY _ZTI7S7267C1[];
extern  VTBL_ENTRY _ZTV7S7267C1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7267C1[];
static VTBL_ENTRY alt_thunk_names13[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7267C13D0Ev,_ZTv0_n16_N8S7267C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7267C13D0Ev,_ZThn104_N8S7267C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7267C13D1Ev,_ZTv0_n16_N8S7267C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7267C13D1Ev,_ZThn104_N8S7267C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7267C12D0Ev,_ZTv0_n28_N8S7267C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7008_N8S7267C12D0Ev,_ZThn5288_N8S7267C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7267C12D1Ev,_ZTv0_n28_N8S7267C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7008_N8S7267C12D1Ev,_ZThn5288_N8S7267C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S7267C12D0Ev,_ZTv0_n36_N8S7267C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10112_N8S7267C12D0Ev,_ZThn7676_N8S7267C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S7267C12D1Ev,_ZTv0_n36_N8S7267C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10112_N8S7267C12D1Ev,_ZThn7676_N8S7267C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7267C12D0Ev,_ZTv0_n20_N8S7267C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8576_N8S7267C12D0Ev,_ZThn6520_N8S7267C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7267C12D1Ev,_ZTv0_n20_N8S7267C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8576_N8S7267C12D1Ev,_ZThn6520_N8S7267C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7267C12D0Ev,_ZTv0_n16_N8S7267C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9680_N8S7267C12D0Ev,_ZThn7328_N8S7267C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7267C12D1Ev,_ZTv0_n16_N8S7267C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9680_N8S7267C12D1Ev,_ZThn7328_N8S7267C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S7267C12D0Ev,_ZTv0_n32_N8S7267C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9504_N8S7267C12D0Ev,_ZThn7224_N8S7267C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S7267C12D1Ev,_ZTv0_n32_N8S7267C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9504_N8S7267C12D1Ev,_ZThn7224_N8S7267C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7267C14D0Ev,_ZTv0_n16_N8S7267C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9680_N8S7267C14D0Ev,_ZThn7328_N8S7267C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7267C14D1Ev,_ZTv0_n16_N8S7267C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9680_N8S7267C14D1Ev,_ZThn7328_N8S7267C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S7267C14D0Ev,_ZTv0_n32_N8S7267C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9504_N8S7267C14D0Ev,_ZThn7224_N8S7267C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S7267C14D1Ev,_ZTv0_n32_N8S7267C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9504_N8S7267C14D1Ev,_ZThn7224_N8S7267C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7267C14D0Ev,_ZTv0_n28_N8S7267C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7008_N8S7267C14D0Ev,_ZThn5288_N8S7267C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7267C14D1Ev,_ZTv0_n28_N8S7267C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7008_N8S7267C14D1Ev,_ZThn5288_N8S7267C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S7267C14D0Ev,_ZTv0_n36_N8S7267C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10112_N8S7267C14D0Ev,_ZThn7676_N8S7267C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S7267C14D1Ev,_ZTv0_n36_N8S7267C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10112_N8S7267C14D1Ev,_ZThn7676_N8S7267C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7267C14D0Ev,_ZTv0_n20_N8S7267C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8576_N8S7267C14D0Ev,_ZThn6520_N8S7267C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7267C14D1Ev,_ZTv0_n20_N8S7267C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8576_N8S7267C14D1Ev,_ZThn6520_N8S7267C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7267C3D0Ev,_ZTv0_n20_N7S7267C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1568_N7S7267C3D0Ev,_ZThn1232_N7S7267C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn8576_N7S7267C3D0Ev,_ZThn6520_N7S7267C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7267C3D1Ev,_ZTv0_n20_N7S7267C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1568_N7S7267C3D1Ev,_ZThn1232_N7S7267C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn8576_N7S7267C3D1Ev,_ZThn6520_N7S7267C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7267C2D0Ev,_ZTv0_n20_N7S7267C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn43408_N7S7267C2D0Ev,_ZThn33480_N7S7267C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7267C2D1Ev,_ZTv0_n20_N7S7267C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn43408_N7S7267C2D1Ev,_ZThn33480_N7S7267C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7267C2D0Ev,_ZTv0_n28_N7S7267C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn41840_N7S7267C2D0Ev,_ZThn32248_N7S7267C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7267C2D1Ev,_ZTv0_n28_N7S7267C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn41840_N7S7267C2D1Ev,_ZThn32248_N7S7267C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N7S7267C1D0Ev,_ZTv0_n36_N7S7267C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn44944_N7S7267C1D0Ev,_ZThn34636_N7S7267C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N7S7267C1D1Ev,_ZTv0_n36_N7S7267C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn44944_N7S7267C1D1Ev,_ZThn34636_N7S7267C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S7267C1D0Ev,_ZTv0_n16_N7S7267C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn44512_N7S7267C1D0Ev,_ZThn34288_N7S7267C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S7267C1D1Ev,_ZTv0_n16_N7S7267C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn44512_N7S7267C1D1Ev,_ZThn34288_N7S7267C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S7267C1D0Ev,_ZTv0_n32_N7S7267C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn44336_N7S7267C1D0Ev,_ZThn34184_N7S7267C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S7267C1D1Ev,_ZTv0_n32_N7S7267C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn44336_N7S7267C1D1Ev,_ZThn34184_N7S7267C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7267C1D0Ev,_ZTv0_n20_N7S7267C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn43408_N7S7267C1D0Ev,_ZThn33480_N7S7267C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7267C1D1Ev,_ZTv0_n20_N7S7267C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn43408_N7S7267C1D1Ev,_ZThn33480_N7S7267C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7267C1D0Ev,_ZTv0_n28_N7S7267C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn41840_N7S7267C1D0Ev,_ZThn32248_N7S7267C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7267C1D1Ev,_ZTv0_n28_N7S7267C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn41840_N7S7267C1D1Ev,_ZThn32248_N7S7267C1D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7267C1 = {  "S7267C1", // class name
  bases_S7267C1, 27,
  &(vtc_S7267C1[0]), // expected_vtbl_contents
  &(vtt_S7267C1[0]), // expected_vtt_contents
  ABISELECT(79776,61596), // object size
  NSPAIRA(_ZTI7S7267C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S7267C1),121, //virtual function table var
  11, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7267C1),72, //virtual table table var
  23, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names13,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19015C5  : virtual S7268C4 {
  ::S7268C4 s19015c5f0;
  int s19015c5f1;
  void *s19015c5f2;
  ::S7268C4 s19015c5f3[2];
  virtual  ~S19015C5(); // _ZN8S19015C5D2Ev
  S19015C5(); // tgen
};
//SIG(-1 S19015C5) C1{ VBC2{ m Fs[6] FL Fc[5]} vd FC2 Fi Fp FC2[2]}


 S19015C5 ::~S19015C5(){ note_dtor("S19015C5", this);}
S19015C5 ::S19015C5(){ note_ctor("S19015C5", this);} // tgen

static void Test_S19015C5()
{
  extern Class_Descriptor cd_S19015C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(20,32)];
    init_test(&cd_S19015C5, buf);
    S19015C5 *dp, &lv = *(dp=new (buf) S19015C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(152,124), "sizeof(S19015C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19015C5)");
    check_base_class_offset(lv, (S7268C4*), ABISELECT(120,96), "S19015C5");
    check_field_offset(lv, s19015c5f0, ABISELECT(8,4), "S19015C5.s19015c5f0");
    check_field_offset(lv, s19015c5f1, ABISELECT(40,32), "S19015C5.s19015c5f1");
    check_field_offset(lv, s19015c5f2, ABISELECT(48,36), "S19015C5.s19015c5f2");
    check_field_offset(lv, s19015c5f3, ABISELECT(56,40), "S19015C5.s19015c5f3");
    test_class_info(&lv, &cd_S19015C5);
    dp->~S19015C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19015C5(Test_S19015C5, "S19015C5", ABISELECT(152,124));

#else // __cplusplus

extern void _ZN8S19015C5C1Ev();
extern void _ZN8S19015C5D2Ev();
Name_Map name_map_S19015C5[] = {
  NSPAIR(_ZN8S19015C5C1Ev),
  NSPAIR(_ZN8S19015C5D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
static Base_Class bases_S19015C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7268C4,    ABISELECT(120,96), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S19015C5[];
extern void _ZN8S19015C5D1Ev();
extern void _ZN8S19015C5D0Ev();
static  VTBL_ENTRY vtc_S19015C5[] = {
  ABISELECT(120,96),
  0,
  (VTBL_ENTRY)&(_ZTI8S19015C5[0]),
  (VTBL_ENTRY)&_ZN8S19015C5D1Ev,
  (VTBL_ENTRY)&_ZN8S19015C5D0Ev,
};
extern VTBL_ENTRY _ZTV8S19015C5[];
static  VTT_ENTRY vtt_S19015C5[] = {
  {&(_ZTV8S19015C5[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S19015C5[];
extern  VTBL_ENTRY _ZTV8S19015C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19015C5[];
Class_Descriptor cd_S19015C5 = {  "S19015C5", // class name
  bases_S19015C5, 1,
  &(vtc_S19015C5[0]), // expected_vtbl_contents
  &(vtt_S19015C5[0]), // expected_vtt_contents
  ABISELECT(152,124), // object size
  NSPAIRA(_ZTI8S19015C5),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S19015C5),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19015C5),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19015C6  {
  ::S7268C4 s19015c6f0;
  char s19015c6f1;
  ::S7268C7 s19015c6f2;
  void *s19015c6f3;
  int s19015c6f4;
  int s19015c6f5;
  void *s19015c6f6;
  int s19015c6f7;
  int s19015c6f8:11;
  int s19015c6f9;
  virtual void  v1(); // _ZN8S19015C62v1Ev
  virtual void  v2(); // _ZN8S19015C62v2Ev
  ~S19015C6(); // tgen
  S19015C6(); // tgen
};
//SIG(-1 S19015C6) C1{ v1 v2 FC2{ m Fs[6] FL Fc[5]} Fc FC3{ BC4{ v3 FU5{ m Fl Fp[4] Fi} Fp FC2[8] Fp} VBC2 BC6{ VBC2 vd FC2 Fi Fp FC2[2]} Fp[5] Fc:0 Fi Fi Fi:10 Fc[8] Fs Fi Fp[10] FC6 FL Fi Fp} Fp Fi Fi Fp Fi Fi:11 Fi}


void  S19015C6 ::v1(){vfunc_called(this, "_ZN8S19015C62v1Ev");}
void  S19015C6 ::v2(){vfunc_called(this, "_ZN8S19015C62v2Ev");}
S19015C6 ::~S19015C6(){ note_dtor("S19015C6", this);} // tgen
S19015C6 ::S19015C6(){ note_ctor("S19015C6", this);} // tgen

static void Test_S19015C6()
{
  extern Class_Descriptor cd_S19015C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(110,167)];
    init_test(&cd_S19015C6, buf);
    S19015C6 *dp, &lv = *(dp=new (buf) S19015C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(872,664), "sizeof(S19015C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19015C6)");
    check_field_offset(lv, s19015c6f0, ABISELECT(8,4), "S19015C6.s19015c6f0");
    check_field_offset(lv, s19015c6f1, ABISELECT(40,32), "S19015C6.s19015c6f1");
    check_field_offset(lv, s19015c6f2, ABISELECT(48,36), "S19015C6.s19015c6f2");
    check_field_offset(lv, s19015c6f3, ABISELECT(832,636), "S19015C6.s19015c6f3");
    check_field_offset(lv, s19015c6f4, ABISELECT(840,640), "S19015C6.s19015c6f4");
    check_field_offset(lv, s19015c6f5, ABISELECT(844,644), "S19015C6.s19015c6f5");
    check_field_offset(lv, s19015c6f6, ABISELECT(848,648), "S19015C6.s19015c6f6");
    check_field_offset(lv, s19015c6f7, ABISELECT(856,652), "S19015C6.s19015c6f7");
    set_bf_and_test(lv, s19015c6f8, ABISELECT(860,656), 0, 11, 1, "S19015C6");
    set_bf_and_test(lv, s19015c6f8, ABISELECT(860,656), 0, 11, hide_sll(1LL<<10), "S19015C6");
    check_field_offset(lv, s19015c6f9, ABISELECT(864,660), "S19015C6.s19015c6f9");
    test_class_info(&lv, &cd_S19015C6);
    dp->~S19015C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19015C6(Test_S19015C6, "S19015C6", ABISELECT(872,664));

#else // __cplusplus

extern void _ZN8S19015C6C1Ev();
extern void _ZN8S19015C6D1Ev();
Name_Map name_map_S19015C6[] = {
  NSPAIR(_ZN8S19015C6C1Ev),
  NSPAIR(_ZN8S19015C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S19015C6[];
extern void _ZN8S19015C62v1Ev();
extern void _ZN8S19015C62v2Ev();
static  VTBL_ENTRY vtc_S19015C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S19015C6[0]),
  (VTBL_ENTRY)&_ZN8S19015C62v1Ev,
  (VTBL_ENTRY)&_ZN8S19015C62v2Ev,
};
extern VTBL_ENTRY _ZTI8S19015C6[];
extern  VTBL_ENTRY _ZTV8S19015C6[];
Class_Descriptor cd_S19015C6 = {  "S19015C6", // class name
  0,0,//no base classes
  &(vtc_S19015C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(872,664), // object size
  NSPAIRA(_ZTI8S19015C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S19015C6),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19015C11  {
  int s19015c11f0;
  void *s19015c11f1;
  void *s19015c11f2;
  long s19015c11f3;
  void *s19015c11f4[2];
  void *s19015c11f5;
  long s19015c11f6[6];
  ::S7268C4 s19015c11f7;
  int s19015c11f8;
  void *s19015c11f9;
  char s19015c11f10[2];
  virtual void  v3(); // _ZN9S19015C112v3Ev
  virtual void  v4(); // _ZN9S19015C112v4Ev
  ~S19015C11(); // tgen
  S19015C11(); // tgen
};
//SIG(-1 S19015C11) C1{ v1 v2 Fi Fp[2] Fl Fp[3] Fl[6] FC2{ m Fs[6] FL Fc[5]} Fi Fp Fc[2]}


void  S19015C11 ::v3(){vfunc_called(this, "_ZN9S19015C112v3Ev");}
void  S19015C11 ::v4(){vfunc_called(this, "_ZN9S19015C112v4Ev");}
S19015C11 ::~S19015C11(){ note_dtor("S19015C11", this);} // tgen
S19015C11 ::S19015C11(){ note_ctor("S19015C11", this);} // tgen

static void Test_S19015C11()
{
  extern Class_Descriptor cd_S19015C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(22,25)];
    init_test(&cd_S19015C11, buf);
    S19015C11 *dp, &lv = *(dp=new (buf) S19015C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(168,96), "sizeof(S19015C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19015C11)");
    check_field_offset(lv, s19015c11f0, ABISELECT(8,4), "S19015C11.s19015c11f0");
    check_field_offset(lv, s19015c11f1, ABISELECT(16,8), "S19015C11.s19015c11f1");
    check_field_offset(lv, s19015c11f2, ABISELECT(24,12), "S19015C11.s19015c11f2");
    check_field_offset(lv, s19015c11f3, ABISELECT(32,16), "S19015C11.s19015c11f3");
    check_field_offset(lv, s19015c11f4, ABISELECT(40,20), "S19015C11.s19015c11f4");
    check_field_offset(lv, s19015c11f5, ABISELECT(56,28), "S19015C11.s19015c11f5");
    check_field_offset(lv, s19015c11f6, ABISELECT(64,32), "S19015C11.s19015c11f6");
    check_field_offset(lv, s19015c11f7, ABISELECT(112,56), "S19015C11.s19015c11f7");
    check_field_offset(lv, s19015c11f8, ABISELECT(144,84), "S19015C11.s19015c11f8");
    check_field_offset(lv, s19015c11f9, ABISELECT(152,88), "S19015C11.s19015c11f9");
    check_field_offset(lv, s19015c11f10, ABISELECT(160,92), "S19015C11.s19015c11f10");
    test_class_info(&lv, &cd_S19015C11);
    dp->~S19015C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19015C11(Test_S19015C11, "S19015C11", ABISELECT(168,96));

#else // __cplusplus

extern void _ZN9S19015C11C1Ev();
extern void _ZN9S19015C11D1Ev();
Name_Map name_map_S19015C11[] = {
  NSPAIR(_ZN9S19015C11C1Ev),
  NSPAIR(_ZN9S19015C11D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S19015C11[];
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
static  VTBL_ENTRY vtc_S19015C11[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S19015C11[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
};
extern VTBL_ENTRY _ZTI9S19015C11[];
extern  VTBL_ENTRY _ZTV9S19015C11[];
Class_Descriptor cd_S19015C11 = {  "S19015C11", // class name
  0,0,//no base classes
  &(vtc_S19015C11[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(168,96), // object size
  NSPAIRA(_ZTI9S19015C11),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S19015C11),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19015C10  : S19015C5 , virtual S19015C11 {
  long s19015c10f0[4];
  ::S19015C5 s19015c10f1[4];
  virtual  ~S19015C10(); // _ZN9S19015C10D2Ev
  virtual void  v5(); // _ZN9S19015C102v5Ev
  S19015C10(); // tgen
};
//SIG(-1 S19015C10) C1{ BC2{ VBC3{ m Fs[6] FL Fc[5]} vd FC3 Fi Fp FC3[2]} VBC4{ v2 v3 Fi Fp[2] Fl Fp[3] Fl[6] FC3 Fi Fp Fc[2]} vd v1 Fl[4] FC2[4]}


 S19015C10 ::~S19015C10(){ note_dtor("S19015C10", this);}
void  S19015C10 ::v5(){vfunc_called(this, "_ZN9S19015C102v5Ev");}
S19015C10 ::S19015C10(){ note_ctor("S19015C10", this);} // tgen

static void Test_S19015C10()
{
  extern Class_Descriptor cd_S19015C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(121,184)];
    init_test(&cd_S19015C10, buf);
    S19015C10 *dp, &lv = *(dp=new (buf) S19015C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(960,732), "sizeof(S19015C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19015C10)");
    check_base_class_offset(lv, (S7268C4*)(S19015C5*), ABISELECT(760,608), "S19015C10");
    check_base_class_offset(lv, (S19015C5*), 0, "S19015C10");
    check_base_class_offset(lv, (S19015C11*), ABISELECT(792,636), "S19015C10");
    check_field_offset(lv, s19015c10f0, ABISELECT(120,96), "S19015C10.s19015c10f0");
    check_field_offset(lv, s19015c10f1, ABISELECT(152,112), "S19015C10.s19015c10f1");
    test_class_info(&lv, &cd_S19015C10);
    dp->~S19015C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19015C10(Test_S19015C10, "S19015C10", ABISELECT(960,732));

#else // __cplusplus

extern void _ZN9S19015C10C1Ev();
extern void _ZN9S19015C10D2Ev();
Name_Map name_map_S19015C10[] = {
  NSPAIR(_ZN9S19015C10C1Ev),
  NSPAIR(_ZN9S19015C10D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S19015C5;
extern VTBL_ENTRY _ZTI8S19015C5[];
extern  VTBL_ENTRY _ZTV8S19015C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19015C5[];
extern Class_Descriptor cd_S19015C11;
extern VTBL_ENTRY _ZTI9S19015C11[];
extern  VTBL_ENTRY _ZTV9S19015C11[];
static Base_Class bases_S19015C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7268C4,    ABISELECT(760,608), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S19015C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19015C11,    ABISELECT(792,636), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19015C10[];
extern void _ZN9S19015C10D1Ev();
extern void _ZN9S19015C10D0Ev();
extern void _ZN9S19015C102v5Ev();
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
static  VTBL_ENTRY vtc_S19015C10[] = {
  ABISELECT(792,636),
  ABISELECT(760,608),
  0,
  (VTBL_ENTRY)&(_ZTI9S19015C10[0]),
  (VTBL_ENTRY)&_ZN9S19015C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19015C10D0Ev,
  (VTBL_ENTRY)&_ZN9S19015C102v5Ev,
  0,
  0,
  ABISELECT(-792,-636),
  (VTBL_ENTRY)&(_ZTI9S19015C10[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
};
extern VTBL_ENTRY _ZTV9S19015C10[];
extern void _ZN8S19015C5D1Ev();
extern void _ZN8S19015C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C5__9S19015C10[] = {
  ABISELECT(760,608),
  0,
  (VTBL_ENTRY)&(_ZTI8S19015C5[0]),
  (VTBL_ENTRY)&_ZN8S19015C5D1Ev,
  (VTBL_ENTRY)&_ZN8S19015C5D0Ev,
};
static  VTT_ENTRY vtt_S19015C10[] = {
  {&(_ZTV9S19015C10[4]),  4,13},
  {&(_tg__ZTV8S19015C5__9S19015C10[3]),  3,5},
  {&(_ZTV9S19015C10[11]),  11,13},
};
extern VTBL_ENTRY _ZTI9S19015C10[];
extern  VTBL_ENTRY _ZTV9S19015C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19015C10[];
Class_Descriptor cd_S19015C10 = {  "S19015C10", // class name
  bases_S19015C10, 3,
  &(vtc_S19015C10[0]), // expected_vtbl_contents
  &(vtt_S19015C10[0]), // expected_vtt_contents
  ABISELECT(960,732), // object size
  NSPAIRA(_ZTI9S19015C10),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S19015C10),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19015C10),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19015C8  {
  ::S7268C9 s19015c8f0;
  void *s19015c8f1;
  ::S7268C4 s19015c8f2[8];
  void *s19015c8f3;
  virtual void  v6(); // _ZN8S19015C82v6Ev
  ~S19015C8(); // tgen
  S19015C8(); // tgen
};
//SIG(-1 S19015C8) C1{ v1 FU2{ m Fl Fp[4] Fi} Fp FC3{ m Fs[6] FL Fc[5]}[8] Fp}


void  S19015C8 ::v6(){vfunc_called(this, "_ZN8S19015C82v6Ev");}
S19015C8 ::~S19015C8(){ note_dtor("S19015C8", this);} // tgen
S19015C8 ::S19015C8(){ note_ctor("S19015C8", this);} // tgen

static void Test_S19015C8()
{
  extern Class_Descriptor cd_S19015C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(40,64)];
    init_test(&cd_S19015C8, buf);
    S19015C8 *dp, &lv = *(dp=new (buf) S19015C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(312,252), "sizeof(S19015C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19015C8)");
    check_field_offset(lv, s19015c8f0, ABISELECT(8,4), "S19015C8.s19015c8f0");
    check_field_offset(lv, s19015c8f1, ABISELECT(40,20), "S19015C8.s19015c8f1");
    check_field_offset(lv, s19015c8f2, ABISELECT(48,24), "S19015C8.s19015c8f2");
    check_field_offset(lv, s19015c8f3, ABISELECT(304,248), "S19015C8.s19015c8f3");
    test_class_info(&lv, &cd_S19015C8);
    dp->~S19015C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19015C8(Test_S19015C8, "S19015C8", ABISELECT(312,252));

#else // __cplusplus

extern void _ZN8S19015C8C1Ev();
extern void _ZN8S19015C8D1Ev();
Name_Map name_map_S19015C8[] = {
  NSPAIR(_ZN8S19015C8C1Ev),
  NSPAIR(_ZN8S19015C8D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S19015C8[];
extern void _ZN8S19015C82v6Ev();
static  VTBL_ENTRY vtc_S19015C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S19015C8[0]),
  (VTBL_ENTRY)&_ZN8S19015C82v6Ev,
};
extern VTBL_ENTRY _ZTI8S19015C8[];
extern  VTBL_ENTRY _ZTV8S19015C8[];
Class_Descriptor cd_S19015C8 = {  "S19015C8", // class name
  0,0,//no base classes
  &(vtc_S19015C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(312,252), // object size
  NSPAIRA(_ZTI8S19015C8),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S19015C8),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19015C3  : S7268C4 , S19015C5 , virtual S19015C6 , virtual S19015C10 , S19015C8 {
  void *s19015c3f0;
  int s19015c3f1[6];
  __tsi64 s19015c3f2;
  ::S19015C5 s19015c3f3;
  char s19015c3f4;
  ~S19015C3(); // tgen
  S19015C3(); // tgen
};
//SIG(-1 S19015C3) C1{ BC2{ m Fs[6] FL Fc[5]} BC3{ VBC2 vd FC2 Fi Fp FC2[2]} VBC4{ v1 v2 FC2 Fc FC5{ BC6{ v7 FU7{ m Fl Fp[4] Fi} Fp FC2[8] Fp} VBC2 BC8{ VBC2 vd FC2 Fi Fp FC2[2]} Fp[5] Fc:0 Fi Fi Fi:10 Fc[8] Fs Fi Fp[10] FC8 FL Fi Fp} Fp Fi Fi Fp Fi Fi:11 Fi} VBC9{ BC3 VBC10{ v3 v4 Fi Fp Fp Fl Fp[2] Fp Fl[6] FC2 Fi Fp Fc[2]} vd v5 Fl[4] FC3[4]} BC11{ v6 FU7 Fp FC2[8] Fp} Fp Fi[6] FL FC3 Fc}


S19015C3 ::~S19015C3(){ note_dtor("S19015C3", this);} // tgen
S19015C3 ::S19015C3(){ note_ctor("S19015C3", this);} // tgen

static void Test_S19015C3()
{
  extern Class_Descriptor cd_S19015C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(313,485)];
    init_test(&cd_S19015C3, buf);
    S19015C3 *dp, &lv = *(dp=new (buf) S19015C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2496,1936), "sizeof(S19015C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19015C3)");
    /*is_ambiguous_... S19015C3::S7268C4 */ AMB_check_base_class_offset(lv, (S7268C4*), ABISELECT(120,96), "S19015C3");
    /*is_ambiguous_... S19015C3::S19015C5 */ AMB_check_base_class_offset(lv, (S7268C4*)(S19015C5*), ABISELECT(664,540), "S19015C3");
    check_base_class_offset(lv, (S7268C4*)(S19015C5*)(S19015C10*), ABISELECT(664,540), "S19015C3");
    /*is_ambiguous_... S19015C3::S19015C5 */ AMB_check_base_class_offset(lv, (S19015C5*), 0, "S19015C3");
    check_base_class_offset(lv, (S19015C6*), ABISELECT(696,568), "S19015C3");
    check_base_class_offset(lv, (S19015C5*)(S19015C10*), ABISELECT(1568,1232), "S19015C3");
    check_base_class_offset(lv, (S19015C11*)(S19015C10*), ABISELECT(2328,1840), "S19015C3");
    check_base_class_offset(lv, (S19015C10*), ABISELECT(1568,1232), "S19015C3");
    check_base_class_offset(lv, (S19015C8*), ABISELECT(152,124), "S19015C3");
    check_field_offset(lv, s19015c3f0, ABISELECT(464,376), "S19015C3.s19015c3f0");
    check_field_offset(lv, s19015c3f1, ABISELECT(472,380), "S19015C3.s19015c3f1");
    check_field_offset(lv, s19015c3f2, ABISELECT(496,404), "S19015C3.s19015c3f2");
    check_field_offset(lv, s19015c3f3, ABISELECT(504,412), "S19015C3.s19015c3f3");
    check_field_offset(lv, s19015c3f4, ABISELECT(656,536), "S19015C3.s19015c3f4");
    test_class_info(&lv, &cd_S19015C3);
    dp->~S19015C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19015C3(Test_S19015C3, "S19015C3", ABISELECT(2496,1936));

#else // __cplusplus

extern void _ZN8S19015C3C1Ev();
extern void _ZN8S19015C3D1Ev();
Name_Map name_map_S19015C3[] = {
  NSPAIR(_ZN8S19015C3C1Ev),
  NSPAIR(_ZN8S19015C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S19015C5;
extern VTBL_ENTRY _ZTI8S19015C5[];
extern  VTBL_ENTRY _ZTV8S19015C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19015C5[];
extern Class_Descriptor cd_S19015C6;
extern VTBL_ENTRY _ZTI8S19015C6[];
extern  VTBL_ENTRY _ZTV8S19015C6[];
extern Class_Descriptor cd_S19015C5;
extern VTBL_ENTRY _ZTI8S19015C5[];
extern  VTBL_ENTRY _ZTV8S19015C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19015C5[];
extern Class_Descriptor cd_S19015C11;
extern VTBL_ENTRY _ZTI9S19015C11[];
extern  VTBL_ENTRY _ZTV9S19015C11[];
extern Class_Descriptor cd_S19015C10;
extern VTBL_ENTRY _ZTI9S19015C10[];
extern  VTBL_ENTRY _ZTV9S19015C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19015C10[];
extern Class_Descriptor cd_S19015C8;
extern VTBL_ENTRY _ZTI8S19015C8[];
extern  VTBL_ENTRY _ZTV8S19015C8[];
static Base_Class bases_S19015C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7268C4,    ABISELECT(120,96), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7268C4,    ABISELECT(664,540), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S19015C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19015C6,    ABISELECT(696,568), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19015C5,    ABISELECT(1568,1232), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19015C11,    ABISELECT(2328,1840), //bcp->offset
    26, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S19015C10,    ABISELECT(1568,1232), //bcp->offset
    17, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19015C8,    ABISELECT(152,124), //bcp->offset
    8, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19015C3[];
extern void _ZN8S19015C3D1Ev();
extern void _ZN8S19015C3D0Ev();
extern void _ZN8S19015C82v6Ev();
extern void _ZN8S19015C62v1Ev();
extern void _ZN8S19015C62v2Ev();
extern void ABISELECT(_ZTv0_n40_N8S19015C3D1Ev,_ZTv0_n20_N8S19015C3D1Ev)();
extern void ABISELECT(_ZThn1568_N8S19015C3D1Ev,_ZThn1232_N8S19015C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19015C3D0Ev,_ZTv0_n20_N8S19015C3D0Ev)();
extern void ABISELECT(_ZThn1568_N8S19015C3D0Ev,_ZThn1232_N8S19015C3D0Ev)() __attribute__((weak));
extern void _ZN9S19015C102v5Ev();
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
static  VTBL_ENTRY vtc_S19015C3[] = {
  ABISELECT(2328,1840),
  ABISELECT(1568,1232),
  ABISELECT(696,568),
  ABISELECT(664,540),
  0,
  (VTBL_ENTRY)&(_ZTI8S19015C3[0]),
  (VTBL_ENTRY)&_ZN8S19015C3D1Ev,
  (VTBL_ENTRY)&_ZN8S19015C3D0Ev,
  ABISELECT(-152,-124),
  (VTBL_ENTRY)&(_ZTI8S19015C3[0]),
  (VTBL_ENTRY)&_ZN8S19015C82v6Ev,
  0,
  0,
  ABISELECT(-696,-568),
  (VTBL_ENTRY)&(_ZTI8S19015C3[0]),
  (VTBL_ENTRY)&_ZN8S19015C62v1Ev,
  (VTBL_ENTRY)&_ZN8S19015C62v2Ev,
  0,
  ABISELECT(-1568,-1232),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-1568,-1232),
  (VTBL_ENTRY)&(_ZTI8S19015C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19015C3D1Ev,_ZTv0_n20_N8S19015C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19015C3D0Ev,_ZTv0_n20_N8S19015C3D0Ev),
  (VTBL_ENTRY)&_ZN9S19015C102v5Ev,
  0,
  0,
  ABISELECT(-2328,-1840),
  (VTBL_ENTRY)&(_ZTI8S19015C3[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
};
extern VTBL_ENTRY _ZTV8S19015C3[];
extern void _ZN8S19015C5D1Ev();
extern void _ZN8S19015C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C5__8S19015C3[] = {
  ABISELECT(664,540),
  0,
  (VTBL_ENTRY)&(_ZTI8S19015C5[0]),
  (VTBL_ENTRY)&_ZN8S19015C5D1Ev,
  (VTBL_ENTRY)&_ZN8S19015C5D0Ev,
};
extern void _ZN9S19015C10D1Ev();
extern void _ZN9S19015C10D0Ev();
extern void _ZN9S19015C102v5Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C10__8S19015C3[] = {
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  0,
  (VTBL_ENTRY)&(_ZTI9S19015C10[0]),
  (VTBL_ENTRY)&_ZN9S19015C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19015C10D0Ev,
  (VTBL_ENTRY)&_ZN9S19015C102v5Ev,
};
extern void _ZN8S19015C5D1Ev();
extern void _ZN8S19015C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C59S19015C10__A1__8S19015C3[] = {
  ABISELECT(-904,-692),
  0,
  (VTBL_ENTRY)&(_ZTI8S19015C5[0]),
  (VTBL_ENTRY)&_ZN8S19015C5D1Ev,
  (VTBL_ENTRY)&_ZN8S19015C5D0Ev,
};
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C11__9S19015C10__8S19015C3[] = {
  0,
  0,
  ABISELECT(-760,-608),
  (VTBL_ENTRY)&(_ZTI9S19015C10[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
};
static  VTT_ENTRY vtt_S19015C3[] = {
  {&(_ZTV8S19015C3[6]),  6,32},
  {&(_tg__ZTV8S19015C5__8S19015C3[3]),  3,5},
  {&(_ZTV8S19015C3[15]),  15,32},
  {&(_ZTV8S19015C3[23]),  23,32},
  {&(_ZTV8S19015C3[30]),  30,32},
  {&(_tg__ZTV9S19015C10__8S19015C3[4]),  4,7},
  {&(_tg__ZTV8S19015C59S19015C10__A1__8S19015C3[3]),  3,5},
  {&(_tg__ZTV9S19015C11__9S19015C10__8S19015C3[4]),  4,6},
};
extern VTBL_ENTRY _ZTI8S19015C3[];
extern  VTBL_ENTRY _ZTV8S19015C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19015C3[];
static VTBL_ENTRY alt_thunk_names14[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19015C3D0Ev,_ZTv0_n20_N8S19015C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1568_N8S19015C3D0Ev,_ZThn1232_N8S19015C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19015C3D1Ev,_ZTv0_n20_N8S19015C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1568_N8S19015C3D1Ev,_ZThn1232_N8S19015C3D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19015C3 = {  "S19015C3", // class name
  bases_S19015C3, 8,
  &(vtc_S19015C3[0]), // expected_vtbl_contents
  &(vtt_S19015C3[0]), // expected_vtt_contents
  ABISELECT(2496,1936), // object size
  NSPAIRA(_ZTI8S19015C3),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S19015C3),32, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19015C3),8, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names14,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19015C12  : S19015C6 , virtual S19015C8 , virtual S7268C4 , S19015C10 {
  int s19015c12f0;
  int s19015c12f1;
  char s19015c12f2[4];
  void *s19015c12f3[3];
  short s19015c12f4;
  int s19015c12f5;
  int s19015c12f6;
  long double s19015c12f7;
  void *s19015c12f8;
  void *s19015c12f9;
  int s19015c12f10;
  virtual  ~S19015C12(); // _ZN9S19015C12D2Ev
  S19015C12(); // tgen
};
//SIG(-1 S19015C12) C1{ BC2{ v1 v2 FC3{ m Fs[6] FL Fc[5]} Fc FC4{ BC5{ v7 FU6{ m Fl Fp[4] Fi} Fp FC3[8] Fp} VBC3 BC7{ VBC3 vd FC3 Fi Fp FC3[2]} Fp[5] Fc:0 Fi Fi Fi:10 Fc[8] Fs Fi Fp[10] FC7 FL Fi Fp} Fp Fi Fi Fp Fi Fi:11 Fi} VBC8{ v3 FU6 Fp FC3[8] Fp} VBC3 BC9{ BC10{ VBC3 vd FC3 Fi Fp FC3[2]} VBC11{ v4 v5 Fi Fp Fp Fl Fp[2] Fp Fl[6] FC3 Fi Fp Fc[2]} vd v6 Fl[4] FC10[4]} vd Fi Fi Fc[4] Fp[3] Fs Fi Fi FD Fp Fp Fi}


 S19015C12 ::~S19015C12(){ note_dtor("S19015C12", this);}
S19015C12 ::S19015C12(){ note_ctor("S19015C12", this);} // tgen

static void Test_S19015C12()
{
  extern Class_Descriptor cd_S19015C12;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(142,428)];
    init_test(&cd_S19015C12, buf);
    S19015C12 *dp, &lv = *(dp=new (buf) S19015C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2256,1708), "sizeof(S19015C12)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19015C12)");
    check_base_class_offset(lv, (S19015C6*), 0, "S19015C12");
    check_base_class_offset(lv, (S19015C8*), ABISELECT(1736,1332), "S19015C12");
    check_base_class_offset(lv, (S7268C4*), ABISELECT(2048,1584), "S19015C12");
    check_base_class_offset(lv, (S7268C4*)(S19015C5*)(S19015C10*), ABISELECT(2048,1584), "S19015C12");
    check_base_class_offset(lv, (S19015C5*)(S19015C10*), ABISELECT(872,664), "S19015C12");
    check_base_class_offset(lv, (S19015C11*)(S19015C10*), ABISELECT(2080,1612), "S19015C12");
    check_base_class_offset(lv, (S19015C10*), ABISELECT(872,664), "S19015C12");
    check_field_offset(lv, s19015c12f0, ABISELECT(1632,1272), "S19015C12.s19015c12f0");
    check_field_offset(lv, s19015c12f1, ABISELECT(1636,1276), "S19015C12.s19015c12f1");
    check_field_offset(lv, s19015c12f2, ABISELECT(1640,1280), "S19015C12.s19015c12f2");
    check_field_offset(lv, s19015c12f3, ABISELECT(1648,1284), "S19015C12.s19015c12f3");
    check_field_offset(lv, s19015c12f4, ABISELECT(1672,1296), "S19015C12.s19015c12f4");
    check_field_offset(lv, s19015c12f5, ABISELECT(1676,1300), "S19015C12.s19015c12f5");
    check_field_offset(lv, s19015c12f6, ABISELECT(1680,1304), "S19015C12.s19015c12f6");
    check_field_offset(lv, s19015c12f7, ABISELECT(1696,1308), "S19015C12.s19015c12f7");
    check_field_offset(lv, s19015c12f8, ABISELECT(1712,1320), "S19015C12.s19015c12f8");
    check_field_offset(lv, s19015c12f9, ABISELECT(1720,1324), "S19015C12.s19015c12f9");
    check_field_offset(lv, s19015c12f10, ABISELECT(1728,1328), "S19015C12.s19015c12f10");
    test_class_info(&lv, &cd_S19015C12);
    dp->~S19015C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19015C12(Test_S19015C12, "S19015C12", ABISELECT(2256,1708));

#else // __cplusplus

extern void _ZN9S19015C12C1Ev();
extern void _ZN9S19015C12D2Ev();
Name_Map name_map_S19015C12[] = {
  NSPAIR(_ZN9S19015C12C1Ev),
  NSPAIR(_ZN9S19015C12D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19015C6;
extern VTBL_ENTRY _ZTI8S19015C6[];
extern  VTBL_ENTRY _ZTV8S19015C6[];
extern Class_Descriptor cd_S19015C8;
extern VTBL_ENTRY _ZTI8S19015C8[];
extern  VTBL_ENTRY _ZTV8S19015C8[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S19015C5;
extern VTBL_ENTRY _ZTI8S19015C5[];
extern  VTBL_ENTRY _ZTV8S19015C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19015C5[];
extern Class_Descriptor cd_S19015C11;
extern VTBL_ENTRY _ZTI9S19015C11[];
extern  VTBL_ENTRY _ZTV9S19015C11[];
extern Class_Descriptor cd_S19015C10;
extern VTBL_ENTRY _ZTI9S19015C10[];
extern  VTBL_ENTRY _ZTV9S19015C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19015C10[];
static Base_Class bases_S19015C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19015C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19015C8,    ABISELECT(1736,1332), //bcp->offset
    16, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7268C4,    ABISELECT(2048,1584), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19015C5,    ABISELECT(872,664), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19015C11,    ABISELECT(2080,1612), //bcp->offset
    20, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S19015C10,    ABISELECT(872,664), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19015C12[];
extern void _ZN8S19015C62v1Ev();
extern void _ZN8S19015C62v2Ev();
extern void _ZN9S19015C12D1Ev();
extern void _ZN9S19015C12D0Ev();
extern void ABISELECT(_ZThn872_N9S19015C12D1Ev,_ZThn664_N9S19015C12D1Ev)();
extern void ABISELECT(_ZThn872_N9S19015C12D0Ev,_ZThn664_N9S19015C12D0Ev)();
extern void _ZN9S19015C102v5Ev();
extern void _ZN8S19015C82v6Ev();
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
static  VTBL_ENTRY vtc_S19015C12[] = {
  ABISELECT(2080,1612),
  ABISELECT(2048,1584),
  ABISELECT(1736,1332),
  0,
  (VTBL_ENTRY)&(_ZTI9S19015C12[0]),
  (VTBL_ENTRY)&_ZN8S19015C62v1Ev,
  (VTBL_ENTRY)&_ZN8S19015C62v2Ev,
  (VTBL_ENTRY)&_ZN9S19015C12D1Ev,
  (VTBL_ENTRY)&_ZN9S19015C12D0Ev,
  ABISELECT(1208,948),
  ABISELECT(1176,920),
  ABISELECT(-872,-664),
  (VTBL_ENTRY)&(_ZTI9S19015C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn872_N9S19015C12D1Ev,_ZThn664_N9S19015C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn872_N9S19015C12D0Ev,_ZThn664_N9S19015C12D0Ev),
  (VTBL_ENTRY)&_ZN9S19015C102v5Ev,
  0,
  ABISELECT(-1736,-1332),
  (VTBL_ENTRY)&(_ZTI9S19015C12[0]),
  (VTBL_ENTRY)&_ZN8S19015C82v6Ev,
  0,
  0,
  ABISELECT(-2080,-1612),
  (VTBL_ENTRY)&(_ZTI9S19015C12[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
};
extern VTBL_ENTRY _ZTV9S19015C12[];
extern void _ZN9S19015C10D1Ev();
extern void _ZN9S19015C10D0Ev();
extern void _ZN9S19015C102v5Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C10__9S19015C12[] = {
  ABISELECT(1208,948),
  ABISELECT(1176,920),
  0,
  (VTBL_ENTRY)&(_ZTI9S19015C10[0]),
  (VTBL_ENTRY)&_ZN9S19015C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19015C10D0Ev,
  (VTBL_ENTRY)&_ZN9S19015C102v5Ev,
};
extern void _ZN8S19015C5D1Ev();
extern void _ZN8S19015C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C59S19015C10__9S19015C12[] = {
  ABISELECT(1176,920),
  0,
  (VTBL_ENTRY)&(_ZTI8S19015C5[0]),
  (VTBL_ENTRY)&_ZN8S19015C5D1Ev,
  (VTBL_ENTRY)&_ZN8S19015C5D0Ev,
};
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C11__9S19015C10__9S19015C12[] = {
  0,
  0,
  ABISELECT(-1208,-948),
  (VTBL_ENTRY)&(_ZTI9S19015C10[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
};
static  VTT_ENTRY vtt_S19015C12[] = {
  {&(_ZTV9S19015C12[5]),  5,26},
  {&(_tg__ZTV9S19015C10__9S19015C12[4]),  4,7},
  {&(_tg__ZTV8S19015C59S19015C10__9S19015C12[3]),  3,5},
  {&(_tg__ZTV9S19015C11__9S19015C10__9S19015C12[4]),  4,6},
  {&(_ZTV9S19015C12[19]),  19,26},
  {&(_ZTV9S19015C12[13]),  13,26},
  {&(_ZTV9S19015C12[24]),  24,26},
};
extern VTBL_ENTRY _ZTI9S19015C12[];
extern  VTBL_ENTRY _ZTV9S19015C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19015C12[];
Class_Descriptor cd_S19015C12 = {  "S19015C12", // class name
  bases_S19015C12, 6,
  &(vtc_S19015C12[0]), // expected_vtbl_contents
  &(vtt_S19015C12[0]), // expected_vtt_contents
  ABISELECT(2256,1708), // object size
  NSPAIRA(_ZTI9S19015C12),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S19015C12),26, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19015C12),7, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19015C13  : virtual S19015C3 {
  ::S7268C4 s19015c13f0;
  ::S19015C10 s19015c13f1[5];
  ::S19015C3 s19015c13f2[10];
  __tsi64 s19015c13f3[4];
  char s19015c13f4;
  ::S19015C3 s19015c13f5;
  ::S19015C3 s19015c13f6;
  virtual void  v7(); // _ZN9S19015C132v7Ev
  ~S19015C13(); // tgen
  S19015C13(); // tgen
};
//SIG(-1 S19015C13) C1{ VBC2{ BC3{ m Fs[6] FL Fc[5]} BC4{ VBC3 vd FC3 Fi Fp FC3[2]} VBC5{ v2 v3 FC3 Fc FC6{ BC7{ v8 FU8{ m Fl Fp[4] Fi} Fp FC3[8] Fp} VBC3 BC9{ VBC3 vd FC3 Fi Fp FC3[2]} Fp[5] Fc:0 Fi Fi Fi:10 Fc[8] Fs Fi Fp[10] FC9 FL Fi Fp} Fp Fi Fi Fp Fi Fi:11 Fi} VBC10{ BC4 VBC11{ v4 v5 Fi Fp Fp Fl Fp[2] Fp Fl[6] FC3 Fi Fp Fc[2]} vd v6 Fl[4] FC4[4]} BC12{ v7 FU8 Fp FC3[8] Fp} Fp Fi[6] FL FC4 Fc} v1 FC3 FC10[5] FC2[10] FL[4] Fc FC2 FC2}


void  S19015C13 ::v7(){vfunc_called(this, "_ZN9S19015C132v7Ev");}
S19015C13 ::~S19015C13(){ note_dtor("S19015C13", this);} // tgen
S19015C13 ::S19015C13(){ note_ctor("S19015C13", this);} // tgen

static void Test_S19015C13()
{
  extern Class_Descriptor cd_S19015C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4667,7225)];
    init_test(&cd_S19015C13, buf);
    S19015C13 *dp, &lv = *(dp=new (buf) S19015C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(37328,28896), "sizeof(S19015C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19015C13)");
    /*is_ambiguous_... S19015C3::S7268C4 */ AMB_check_base_class_offset(lv, (S7268C4*)(S19015C3*), ABISELECT(34952,27056), "S19015C13");
    /*is_ambiguous_... S19015C3::S19015C5 */ AMB_check_base_class_offset(lv, (S7268C4*)(S19015C5*)(S19015C3*), ABISELECT(35496,27500), "S19015C13");
    check_base_class_offset(lv, (S7268C4*)(S19015C5*)(S19015C10*), ABISELECT(35496,27500), "S19015C13");
    /*is_ambiguous_... S19015C3::S19015C5 */ AMB_check_base_class_offset(lv, (S19015C5*)(S19015C3*), ABISELECT(34832,26960), "S19015C13");
    check_base_class_offset(lv, (S19015C6*)(S19015C3*), ABISELECT(35528,27528), "S19015C13");
    check_base_class_offset(lv, (S19015C5*)(S19015C10*), ABISELECT(36400,28192), "S19015C13");
    check_base_class_offset(lv, (S19015C11*)(S19015C10*), ABISELECT(37160,28800), "S19015C13");
    check_base_class_offset(lv, (S19015C10*)(S19015C3*), ABISELECT(36400,28192), "S19015C13");
    check_base_class_offset(lv, (S19015C8*)(S19015C3*), ABISELECT(34984,27084), "S19015C13");
    check_base_class_offset(lv, (S19015C3*), ABISELECT(34832,26960), "S19015C13");
    check_field_offset(lv, s19015c13f0, ABISELECT(8,4), "S19015C13.s19015c13f0");
    check_field_offset(lv, s19015c13f1, ABISELECT(40,32), "S19015C13.s19015c13f1");
    check_field_offset(lv, s19015c13f2, ABISELECT(4840,3692), "S19015C13.s19015c13f2");
    check_field_offset(lv, s19015c13f3, ABISELECT(29800,23052), "S19015C13.s19015c13f3");
    check_field_offset(lv, s19015c13f4, ABISELECT(29832,23084), "S19015C13.s19015c13f4");
    check_field_offset(lv, s19015c13f5, ABISELECT(29840,23088), "S19015C13.s19015c13f5");
    check_field_offset(lv, s19015c13f6, ABISELECT(32336,25024), "S19015C13.s19015c13f6");
    test_class_info(&lv, &cd_S19015C13);
    dp->~S19015C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19015C13(Test_S19015C13, "S19015C13", ABISELECT(37328,28896));

#else // __cplusplus

extern void _ZN9S19015C13C1Ev();
extern void _ZN9S19015C13D1Ev();
Name_Map name_map_S19015C13[] = {
  NSPAIR(_ZN9S19015C13C1Ev),
  NSPAIR(_ZN9S19015C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S19015C5;
extern VTBL_ENTRY _ZTI8S19015C5[];
extern  VTBL_ENTRY _ZTV8S19015C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19015C5[];
extern Class_Descriptor cd_S19015C6;
extern VTBL_ENTRY _ZTI8S19015C6[];
extern  VTBL_ENTRY _ZTV8S19015C6[];
extern Class_Descriptor cd_S19015C5;
extern VTBL_ENTRY _ZTI8S19015C5[];
extern  VTBL_ENTRY _ZTV8S19015C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19015C5[];
extern Class_Descriptor cd_S19015C11;
extern VTBL_ENTRY _ZTI9S19015C11[];
extern  VTBL_ENTRY _ZTV9S19015C11[];
extern Class_Descriptor cd_S19015C10;
extern VTBL_ENTRY _ZTI9S19015C10[];
extern  VTBL_ENTRY _ZTV9S19015C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19015C10[];
extern Class_Descriptor cd_S19015C8;
extern VTBL_ENTRY _ZTI8S19015C8[];
extern  VTBL_ENTRY _ZTV8S19015C8[];
extern Class_Descriptor cd_S19015C3;
extern VTBL_ENTRY _ZTI8S19015C3[];
extern  VTBL_ENTRY _ZTV8S19015C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19015C3[];
static Base_Class bases_S19015C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7268C4,    ABISELECT(34952,27056), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7268C4,    ABISELECT(35496,27500), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S19015C5,    ABISELECT(34832,26960), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19015C6,    ABISELECT(35528,27528), //bcp->offset
    23, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S19015C5,    ABISELECT(36400,28192), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19015C11,    ABISELECT(37160,28800), //bcp->offset
    38, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S19015C10,    ABISELECT(36400,28192), //bcp->offset
    29, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S19015C8,    ABISELECT(34984,27084), //bcp->offset
    20, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19015C3,    ABISELECT(34832,26960), //bcp->offset
    10, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19015C13[];
extern void _ZN9S19015C132v7Ev();
extern void _ZN9S19015C13D1Ev();
extern void _ZN9S19015C13D0Ev();
extern void ABISELECT(_ZTv0_n56_N9S19015C13D1Ev,_ZTv0_n28_N9S19015C13D1Ev)();
extern void ABISELECT(_ZThn34832_N9S19015C13D1Ev,_ZThn26960_N9S19015C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S19015C13D0Ev,_ZTv0_n28_N9S19015C13D0Ev)();
extern void ABISELECT(_ZThn34832_N9S19015C13D0Ev,_ZThn26960_N9S19015C13D0Ev)() __attribute__((weak));
extern void _ZN8S19015C82v6Ev();
extern void _ZN8S19015C62v1Ev();
extern void _ZN8S19015C62v2Ev();
extern void ABISELECT(_ZTv0_n40_N9S19015C13D1Ev,_ZTv0_n20_N9S19015C13D1Ev)();
extern void ABISELECT(_ZThn36400_N9S19015C13D1Ev,_ZThn28192_N9S19015C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19015C13D0Ev,_ZTv0_n20_N9S19015C13D0Ev)();
extern void ABISELECT(_ZThn36400_N9S19015C13D0Ev,_ZThn28192_N9S19015C13D0Ev)() __attribute__((weak));
extern void _ZN9S19015C102v5Ev();
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
static  VTBL_ENTRY vtc_S19015C13[] = {
  ABISELECT(37160,28800),
  ABISELECT(36400,28192),
  ABISELECT(35528,27528),
  ABISELECT(35496,27500),
  ABISELECT(34832,26960),
  0,
  (VTBL_ENTRY)&(_ZTI9S19015C13[0]),
  (VTBL_ENTRY)&_ZN9S19015C132v7Ev,
  (VTBL_ENTRY)&_ZN9S19015C13D1Ev,
  (VTBL_ENTRY)&_ZN9S19015C13D0Ev,
  ABISELECT(152,124),
  ABISELECT(-34832,-26960),
  ABISELECT(2328,1840),
  ABISELECT(1568,1232),
  ABISELECT(696,568),
  ABISELECT(664,540),
  ABISELECT(-34832,-26960),
  (VTBL_ENTRY)&(_ZTI9S19015C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19015C13D1Ev,_ZTv0_n28_N9S19015C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19015C13D0Ev,_ZTv0_n28_N9S19015C13D0Ev),
  ABISELECT(-34984,-27084),
  (VTBL_ENTRY)&(_ZTI9S19015C13[0]),
  (VTBL_ENTRY)&_ZN8S19015C82v6Ev,
  0,
  0,
  ABISELECT(-35528,-27528),
  (VTBL_ENTRY)&(_ZTI9S19015C13[0]),
  (VTBL_ENTRY)&_ZN8S19015C62v1Ev,
  (VTBL_ENTRY)&_ZN8S19015C62v2Ev,
  0,
  ABISELECT(-36400,-28192),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-36400,-28192),
  (VTBL_ENTRY)&(_ZTI9S19015C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19015C13D1Ev,_ZTv0_n20_N9S19015C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19015C13D0Ev,_ZTv0_n20_N9S19015C13D0Ev),
  (VTBL_ENTRY)&_ZN9S19015C102v5Ev,
  0,
  0,
  ABISELECT(-37160,-28800),
  (VTBL_ENTRY)&(_ZTI9S19015C13[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
};
extern VTBL_ENTRY _ZTV9S19015C13[];
extern void _ZN8S19015C3D1Ev();
extern void _ZN8S19015C3D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C3__9S19015C13[] = {
  ABISELECT(2328,1840),
  ABISELECT(1568,1232),
  ABISELECT(696,568),
  ABISELECT(664,540),
  0,
  (VTBL_ENTRY)&(_ZTI8S19015C3[0]),
  (VTBL_ENTRY)&_ZN8S19015C3D1Ev,
  (VTBL_ENTRY)&_ZN8S19015C3D0Ev,
};
extern void _ZN8S19015C5D1Ev();
extern void _ZN8S19015C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C58S19015C3__9S19015C13[] = {
  ABISELECT(664,540),
  0,
  (VTBL_ENTRY)&(_ZTI8S19015C5[0]),
  (VTBL_ENTRY)&_ZN8S19015C5D1Ev,
  (VTBL_ENTRY)&_ZN8S19015C5D0Ev,
};
extern void _ZN8S19015C62v1Ev();
extern void _ZN8S19015C62v2Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C6__8S19015C3__9S19015C13[] = {
  0,
  0,
  ABISELECT(-696,-568),
  (VTBL_ENTRY)&(_ZTI8S19015C3[0]),
  (VTBL_ENTRY)&_ZN8S19015C62v1Ev,
  (VTBL_ENTRY)&_ZN8S19015C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S19015C3D1Ev,_ZTv0_n20_N8S19015C3D1Ev)();
extern void ABISELECT(_ZThn1568_N8S19015C3D1Ev,_ZThn1232_N8S19015C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19015C3D0Ev,_ZTv0_n20_N8S19015C3D0Ev)();
extern void ABISELECT(_ZThn1568_N8S19015C3D0Ev,_ZThn1232_N8S19015C3D0Ev)() __attribute__((weak));
extern void _ZN9S19015C102v5Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C10__8S19015C3__9S19015C13[] = {
  0,
  ABISELECT(-1568,-1232),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-1568,-1232),
  (VTBL_ENTRY)&(_ZTI8S19015C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19015C3D1Ev,_ZTv0_n20_N8S19015C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19015C3D0Ev,_ZTv0_n20_N8S19015C3D0Ev),
  (VTBL_ENTRY)&_ZN9S19015C102v5Ev,
};
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C11__8S19015C3__9S19015C13[] = {
  0,
  0,
  ABISELECT(-2328,-1840),
  (VTBL_ENTRY)&(_ZTI8S19015C3[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
};
extern void _ZN9S19015C10D1Ev();
extern void _ZN9S19015C10D0Ev();
extern void _ZN9S19015C102v5Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C10__9S19015C13[] = {
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  0,
  (VTBL_ENTRY)&(_ZTI9S19015C10[0]),
  (VTBL_ENTRY)&_ZN9S19015C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19015C10D0Ev,
  (VTBL_ENTRY)&_ZN9S19015C102v5Ev,
};
extern void _ZN8S19015C5D1Ev();
extern void _ZN8S19015C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C59S19015C10__A1__9S19015C13[] = {
  ABISELECT(-904,-692),
  0,
  (VTBL_ENTRY)&(_ZTI8S19015C5[0]),
  (VTBL_ENTRY)&_ZN8S19015C5D1Ev,
  (VTBL_ENTRY)&_ZN8S19015C5D0Ev,
};
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C11__9S19015C10__9S19015C13[] = {
  0,
  0,
  ABISELECT(-760,-608),
  (VTBL_ENTRY)&(_ZTI9S19015C10[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
};
static  VTT_ENTRY vtt_S19015C13[] = {
  {&(_ZTV9S19015C13[7]),  7,44},
  {&(_ZTV9S19015C13[18]),  18,44},
  {&(_ZTV9S19015C13[27]),  27,44},
  {&(_ZTV9S19015C13[35]),  35,44},
  {&(_ZTV9S19015C13[42]),  42,44},
  {&(_ZTV9S19015C13[22]),  22,44},
  {&(_tg__ZTV8S19015C3__9S19015C13[6]),  6,8},
  {&(_tg__ZTV8S19015C58S19015C3__9S19015C13[3]),  3,5},
  {&(_tg__ZTV8S19015C6__8S19015C3__9S19015C13[4]),  4,6},
  {&(_tg__ZTV9S19015C10__8S19015C3__9S19015C13[6]),  6,9},
  {&(_tg__ZTV9S19015C11__8S19015C3__9S19015C13[4]),  4,6},
  {&(_tg__ZTV9S19015C10__9S19015C13[4]),  4,7},
  {&(_tg__ZTV8S19015C59S19015C10__A1__9S19015C13[3]),  3,5},
  {&(_tg__ZTV9S19015C11__9S19015C10__9S19015C13[4]),  4,6},
};
extern VTBL_ENTRY _ZTI9S19015C13[];
extern  VTBL_ENTRY _ZTV9S19015C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19015C13[];
static VTBL_ENTRY alt_thunk_names15[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19015C3D0Ev,_ZTv0_n20_N8S19015C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1568_N8S19015C3D0Ev,_ZThn1232_N8S19015C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19015C3D1Ev,_ZTv0_n20_N8S19015C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1568_N8S19015C3D1Ev,_ZThn1232_N8S19015C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19015C13D0Ev,_ZTv0_n20_N9S19015C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn36400_N9S19015C13D0Ev,_ZThn28192_N9S19015C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19015C13D1Ev,_ZTv0_n20_N9S19015C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn36400_N9S19015C13D1Ev,_ZThn28192_N9S19015C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19015C13D0Ev,_ZTv0_n28_N9S19015C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn34832_N9S19015C13D0Ev,_ZThn26960_N9S19015C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19015C13D1Ev,_ZTv0_n28_N9S19015C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn34832_N9S19015C13D1Ev,_ZThn26960_N9S19015C13D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19015C13 = {  "S19015C13", // class name
  bases_S19015C13, 9,
  &(vtc_S19015C13[0]), // expected_vtbl_contents
  &(vtt_S19015C13[0]), // expected_vtt_contents
  ABISELECT(37328,28896), // object size
  NSPAIRA(_ZTI9S19015C13),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV9S19015C13),44, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19015C13),14, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names15,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19015C14  : virtual S19015C5 , S19015C11 {
  int s19015c14f0;
  void *s19015c14f1;
  virtual void  v8(); // _ZN9S19015C142v8Ev
  ~S19015C14(); // tgen
  S19015C14(); // tgen
};
//SIG(-1 S19015C14) C1{ VBC2{ VBC3{ m Fs[6] FL Fc[5]} vd FC3 Fi Fp FC3[2]} BC4{ v2 v3 Fi Fp[2] Fl Fp[3] Fl[6] FC3 Fi Fp Fc[2]} v1 Fi Fp}


void  S19015C14 ::v8(){vfunc_called(this, "_ZN9S19015C142v8Ev");}
S19015C14 ::~S19015C14(){ note_dtor("S19015C14", this);} // tgen
S19015C14 ::S19015C14(){ note_ctor("S19015C14", this);} // tgen

static void Test_S19015C14()
{
  extern Class_Descriptor cd_S19015C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(42,58)];
    init_test(&cd_S19015C14, buf);
    S19015C14 *dp, &lv = *(dp=new (buf) S19015C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(328,228), "sizeof(S19015C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19015C14)");
    check_base_class_offset(lv, (S7268C4*)(S19015C5*), ABISELECT(296,200), "S19015C14");
    check_base_class_offset(lv, (S19015C5*), ABISELECT(176,104), "S19015C14");
    check_base_class_offset(lv, (S19015C11*), 0, "S19015C14");
    check_field_offset(lv, s19015c14f0, ABISELECT(164,96), "S19015C14.s19015c14f0");
    check_field_offset(lv, s19015c14f1, ABISELECT(168,100), "S19015C14.s19015c14f1");
    test_class_info(&lv, &cd_S19015C14);
    dp->~S19015C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19015C14(Test_S19015C14, "S19015C14", ABISELECT(328,228));

#else // __cplusplus

extern void _ZN9S19015C14C1Ev();
extern void _ZN9S19015C14D1Ev();
Name_Map name_map_S19015C14[] = {
  NSPAIR(_ZN9S19015C14C1Ev),
  NSPAIR(_ZN9S19015C14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S19015C5;
extern VTBL_ENTRY _ZTI8S19015C5[];
extern  VTBL_ENTRY _ZTV8S19015C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19015C5[];
extern Class_Descriptor cd_S19015C11;
extern VTBL_ENTRY _ZTI9S19015C11[];
extern  VTBL_ENTRY _ZTV9S19015C11[];
static Base_Class bases_S19015C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7268C4,    ABISELECT(296,200), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S19015C5,    ABISELECT(176,104), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19015C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19015C14[];
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
extern void _ZN9S19015C142v8Ev();
extern void _ZN9S19015C14D1Ev();
extern void _ZN9S19015C14D0Ev();
extern void ABISELECT(_ZTv0_n32_N9S19015C14D1Ev,_ZTv0_n16_N9S19015C14D1Ev)();
extern void ABISELECT(_ZThn176_N9S19015C14D1Ev,_ZThn104_N9S19015C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19015C14D0Ev,_ZTv0_n16_N9S19015C14D0Ev)();
extern void ABISELECT(_ZThn176_N9S19015C14D0Ev,_ZThn104_N9S19015C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19015C14[] = {
  ABISELECT(296,200),
  ABISELECT(176,104),
  0,
  (VTBL_ENTRY)&(_ZTI9S19015C14[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
  (VTBL_ENTRY)&_ZN9S19015C142v8Ev,
  (VTBL_ENTRY)&_ZN9S19015C14D1Ev,
  (VTBL_ENTRY)&_ZN9S19015C14D0Ev,
  ABISELECT(-176,-104),
  ABISELECT(120,96),
  ABISELECT(-176,-104),
  (VTBL_ENTRY)&(_ZTI9S19015C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19015C14D1Ev,_ZTv0_n16_N9S19015C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19015C14D0Ev,_ZTv0_n16_N9S19015C14D0Ev),
};
extern VTBL_ENTRY _ZTV9S19015C14[];
extern void _ZN8S19015C5D1Ev();
extern void _ZN8S19015C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C5__9S19015C14[] = {
  ABISELECT(120,96),
  0,
  (VTBL_ENTRY)&(_ZTI8S19015C5[0]),
  (VTBL_ENTRY)&_ZN8S19015C5D1Ev,
  (VTBL_ENTRY)&_ZN8S19015C5D0Ev,
};
static  VTT_ENTRY vtt_S19015C14[] = {
  {&(_ZTV9S19015C14[4]),  4,15},
  {&(_ZTV9S19015C14[13]),  13,15},
  {&(_tg__ZTV8S19015C5__9S19015C14[3]),  3,5},
};
extern VTBL_ENTRY _ZTI9S19015C14[];
extern  VTBL_ENTRY _ZTV9S19015C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19015C14[];
static VTBL_ENTRY alt_thunk_names16[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19015C14D0Ev,_ZTv0_n16_N9S19015C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N9S19015C14D0Ev,_ZThn104_N9S19015C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19015C14D1Ev,_ZTv0_n16_N9S19015C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N9S19015C14D1Ev,_ZThn104_N9S19015C14D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19015C14 = {  "S19015C14", // class name
  bases_S19015C14, 3,
  &(vtc_S19015C14[0]), // expected_vtbl_contents
  &(vtt_S19015C14[0]), // expected_vtt_contents
  ABISELECT(328,228), // object size
  NSPAIRA(_ZTI9S19015C14),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S19015C14),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19015C14),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names16,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19015C2  : S19015C3 , S19015C12 , virtual S19015C13 , S7268C4 , virtual S19015C14 {
  ::S7268C16 s19015c2f0;
  void *s19015c2f1;
  int s19015c2f2;
  __tsi64 s19015c2f3;
  __tsi64 s19015c2f4;
  ::S19015C12 s19015c2f5;
  __tsi64 s19015c2f6;
  int s19015c2f7[8];
  int s19015c2f8;
  virtual  ~S19015C2(); // _ZN8S19015C2D2Ev
  virtual void  v9(); // _ZN8S19015C22v9Ev
  S19015C2(); // tgen
};
//SIG(-1 S19015C2) C1{ BC2{ BC3{ m Fs[6] FL Fc[5]} BC4{ VBC3 vd FC3 Fi Fp FC3[2]} VBC5{ v2 v3 FC3 Fc FC6{ BC7{ v10 FU8{ m Fl Fp[4] Fi} Fp FC3[8] Fp} VBC3 BC9{ VBC3 vd FC3 Fi Fp FC3[2]} Fp[5] Fc:0 Fi Fi Fi:10 Fc[8] Fs Fi Fp[10] FC9 FL Fi Fp} Fp Fi Fi Fp Fi Fi:11 Fi} VBC10{ BC4 VBC11{ v4 v5 Fi Fp Fp Fl Fp[2] Fp Fl[6] FC3 Fi Fp Fc[2]} vd v6 Fl[4] FC4[4]} BC12{ v7 FU8 Fp FC3[8] Fp} Fp Fi[6] FL FC4 Fc} BC13{ BC5 VBC12 VBC3 BC10 vd Fi Fi Fc[4] Fp[3] Fs Fi Fi FD Fp Fp Fi} VBC14{ VBC2 v8 FC3 FC10[5] FC2[10] FL[4] Fc FC2 FC2} BC3 VBC15{ VBC4 BC11 v9 Fi Fp} vd v1 FU16{ m Fi Fc[7] Fi[10] Fi FD[8] Fi Fp Fi} Fp Fi FL FL FC13 FL Fi[8] Fi}


 S19015C2 ::~S19015C2(){ note_dtor("S19015C2", this);}
void  S19015C2 ::v9(){vfunc_called(this, "_ZN8S19015C22v9Ev");}
S19015C2 ::S19015C2(){ note_ctor("S19015C2", this);} // tgen

static void Test_S19015C2()
{
  extern Class_Descriptor cd_S19015C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(2679,8281)];
    init_test(&cd_S19015C2, buf);
    S19015C2 *dp, &lv = *(dp=new (buf) S19015C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(42848,33120), "sizeof(S19015C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19015C2)");
    /*is_ambiguous_... S19015C2::S19015C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S19015C3*), ABISELECT(120,96), "S19015C2");
    /*is_ambiguous_... S19015C2::S19015C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S19015C5*)(S19015C3*), ABISELECT(4912,3772), "S19015C2");
    /*is_ambiguous_... S19015C2::S19015C10 */ AMB_check_base_class_offset(lv, (S7268C4*)(S19015C5*)(S19015C10*), ABISELECT(4912,3772), "S19015C2");
    check_base_class_offset(lv, (S7268C4*)(S19015C12*), ABISELECT(4912,3772), "S19015C2");
    check_base_class_offset(lv, (S7268C4*)(S19015C5*)(S19015C10*)(S19015C12*), ABISELECT(4912,3772), "S19015C2");
    /*is_ambiguous_... S19015C2::S19015C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S19015C5*)(S19015C3*), ABISELECT(4912,3772), "S19015C2");
    /*is_ambiguous_... S19015C2::S19015C5 */ AMB_check_base_class_offset(lv, (S7268C4*)(S19015C5*), ABISELECT(4912,3772), "S19015C2");
    /*is_ambiguous_... S19015C2::S19015C3 */ AMB_check_base_class_offset(lv, (S19015C5*)(S19015C3*), 0, "S19015C2");
    /*is_ambiguous_... S19015C2::S19015C3 */ AMB_check_base_class_offset(lv, (S19015C6*)(S19015C3*), ABISELECT(4944,3800), "S19015C2");
    /*is_ambiguous_... S19015C2::S19015C3 */ AMB_check_base_class_offset(lv, (S19015C6*)(S19015C3*), ABISELECT(4944,3800), "S19015C2");
    /*is_ambiguous_... S19015C2::S19015C10 */ AMB_check_base_class_offset(lv, (S19015C5*)(S19015C10*), ABISELECT(5816,4464), "S19015C2");
    /*is_ambiguous_... S19015C2::S19015C10 */ AMB_check_base_class_offset(lv, (S19015C11*)(S19015C10*), ABISELECT(6576,5072), "S19015C2");
    check_base_class_offset(lv, (S19015C11*)(S19015C10*)(S19015C12*), ABISELECT(6576,5072), "S19015C2");
    /*is_ambiguous_... S19015C2::S19015C3 */ AMB_check_base_class_offset(lv, (S19015C10*)(S19015C3*), ABISELECT(5816,4464), "S19015C2");
    /*is_ambiguous_... S19015C2::S19015C3 */ AMB_check_base_class_offset(lv, (S19015C10*)(S19015C3*), ABISELECT(5816,4464), "S19015C2");
    /*is_ambiguous_... S19015C2::S19015C3 */ AMB_check_base_class_offset(lv, (S19015C8*)(S19015C3*), ABISELECT(152,124), "S19015C2");
    /*is_ambiguous_... S19015C2::S19015C3 */ AMB_check_base_class_offset(lv, (S19015C3*), 0, "S19015C2");
    check_base_class_offset(lv, (S19015C6*)(S19015C12*), ABISELECT(672,540), "S19015C2");
    check_base_class_offset(lv, (S19015C8*)(S19015C12*), ABISELECT(6744,5168), "S19015C2");
    check_base_class_offset(lv, (S19015C5*)(S19015C10*)(S19015C12*), ABISELECT(1544,1204), "S19015C2");
    check_base_class_offset(lv, (S19015C10*)(S19015C12*), ABISELECT(1544,1204), "S19015C2");
    check_base_class_offset(lv, (S19015C12*), ABISELECT(672,540), "S19015C2");
    /*is_ambiguous_... S19015C2::S19015C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S19015C3*), ABISELECT(42008,32476), "S19015C2");
    /*is_ambiguous_... S19015C2::S19015C3 */ AMB_check_base_class_offset(lv, (S19015C5*)(S19015C3*), ABISELECT(41888,32380), "S19015C2");
    /*is_ambiguous_... S19015C2::S19015C3 */ AMB_check_base_class_offset(lv, (S19015C8*)(S19015C3*), ABISELECT(42040,32504), "S19015C2");
    check_base_class_offset(lv, (S19015C3*)(S19015C13*), ABISELECT(41888,32380), "S19015C2");
    check_base_class_offset(lv, (S19015C13*), ABISELECT(7056,5420), "S19015C2");
    /*is_ambiguous_... S19015C2::S7268C4 */ AMB_check_base_class_offset(lv, (S7268C4*), ABISELECT(2408,1872), "S19015C2");
    check_base_class_offset(lv, (S19015C5*)(S19015C14*), ABISELECT(42728,33024), "S19015C2");
    check_base_class_offset(lv, (S19015C11*)(S19015C14*), ABISELECT(42552,32920), "S19015C2");
    check_base_class_offset(lv, (S19015C14*), ABISELECT(42552,32920), "S19015C2");
    check_field_offset(lv, s19015c2f0, ABISELECT(2448,1900), "S19015C2.s19015c2f0");
    check_field_offset(lv, s19015c2f1, ABISELECT(2576,1996), "S19015C2.s19015c2f1");
    check_field_offset(lv, s19015c2f2, ABISELECT(2584,2000), "S19015C2.s19015c2f2");
    check_field_offset(lv, s19015c2f3, ABISELECT(2592,2004), "S19015C2.s19015c2f3");
    check_field_offset(lv, s19015c2f4, ABISELECT(2600,2012), "S19015C2.s19015c2f4");
    check_field_offset(lv, s19015c2f5, ABISELECT(2608,2020), "S19015C2.s19015c2f5");
    check_field_offset(lv, s19015c2f6, ABISELECT(4864,3728), "S19015C2.s19015c2f6");
    check_field_offset(lv, s19015c2f7, ABISELECT(4872,3736), "S19015C2.s19015c2f7");
    check_field_offset(lv, s19015c2f8, ABISELECT(4904,3768), "S19015C2.s19015c2f8");
    test_class_info(&lv, &cd_S19015C2);
    dp->~S19015C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19015C2(Test_S19015C2, "S19015C2", ABISELECT(42848,33120));

#else // __cplusplus

extern void _ZN8S19015C2C1Ev();
extern void _ZN8S19015C2D2Ev();
Name_Map name_map_S19015C2[] = {
  NSPAIR(_ZN8S19015C2C1Ev),
  NSPAIR(_ZN8S19015C2D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S19015C5;
extern VTBL_ENTRY _ZTI8S19015C5[];
extern  VTBL_ENTRY _ZTV8S19015C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19015C5[];
extern Class_Descriptor cd_S19015C6;
extern VTBL_ENTRY _ZTI8S19015C6[];
extern  VTBL_ENTRY _ZTV8S19015C6[];
extern Class_Descriptor cd_S19015C5;
extern VTBL_ENTRY _ZTI8S19015C5[];
extern  VTBL_ENTRY _ZTV8S19015C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19015C5[];
extern Class_Descriptor cd_S19015C11;
extern VTBL_ENTRY _ZTI9S19015C11[];
extern  VTBL_ENTRY _ZTV9S19015C11[];
extern Class_Descriptor cd_S19015C10;
extern VTBL_ENTRY _ZTI9S19015C10[];
extern  VTBL_ENTRY _ZTV9S19015C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19015C10[];
extern Class_Descriptor cd_S19015C8;
extern VTBL_ENTRY _ZTI8S19015C8[];
extern  VTBL_ENTRY _ZTV8S19015C8[];
extern Class_Descriptor cd_S19015C3;
extern VTBL_ENTRY _ZTI8S19015C3[];
extern  VTBL_ENTRY _ZTV8S19015C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19015C3[];
extern Class_Descriptor cd_S19015C6;
extern VTBL_ENTRY _ZTI8S19015C6[];
extern  VTBL_ENTRY _ZTV8S19015C6[];
extern Class_Descriptor cd_S19015C8;
extern VTBL_ENTRY _ZTI8S19015C8[];
extern  VTBL_ENTRY _ZTV8S19015C8[];
extern Class_Descriptor cd_S19015C5;
extern VTBL_ENTRY _ZTI8S19015C5[];
extern  VTBL_ENTRY _ZTV8S19015C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19015C5[];
extern Class_Descriptor cd_S19015C10;
extern VTBL_ENTRY _ZTI9S19015C10[];
extern  VTBL_ENTRY _ZTV9S19015C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19015C10[];
extern Class_Descriptor cd_S19015C12;
extern VTBL_ENTRY _ZTI9S19015C12[];
extern  VTBL_ENTRY _ZTV9S19015C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19015C12[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S19015C5;
extern VTBL_ENTRY _ZTI8S19015C5[];
extern  VTBL_ENTRY _ZTV8S19015C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19015C5[];
extern Class_Descriptor cd_S19015C8;
extern VTBL_ENTRY _ZTI8S19015C8[];
extern  VTBL_ENTRY _ZTV8S19015C8[];
extern Class_Descriptor cd_S19015C3;
extern VTBL_ENTRY _ZTI8S19015C3[];
extern  VTBL_ENTRY _ZTV8S19015C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19015C3[];
extern Class_Descriptor cd_S19015C13;
extern VTBL_ENTRY _ZTI9S19015C13[];
extern  VTBL_ENTRY _ZTV9S19015C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19015C13[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S19015C5;
extern VTBL_ENTRY _ZTI8S19015C5[];
extern  VTBL_ENTRY _ZTV8S19015C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19015C5[];
extern Class_Descriptor cd_S19015C11;
extern VTBL_ENTRY _ZTI9S19015C11[];
extern  VTBL_ENTRY _ZTV9S19015C11[];
extern Class_Descriptor cd_S19015C14;
extern VTBL_ENTRY _ZTI9S19015C14[];
extern  VTBL_ENTRY _ZTV9S19015C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19015C14[];
static Base_Class bases_S19015C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7268C4,    ABISELECT(120,96), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7268C4,    ABISELECT(4912,3772), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S19015C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19015C6,    ABISELECT(4944,3800), //bcp->offset
    33, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S19015C5,    ABISELECT(5816,4464), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19015C11,    ABISELECT(6576,5072), //bcp->offset
    48, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S19015C10,    ABISELECT(5816,4464), //bcp->offset
    39, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S19015C8,    ABISELECT(152,124), //bcp->offset
    14, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19015C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19015C6,    ABISELECT(672,540), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19015C8,    ABISELECT(6744,5168), //bcp->offset
    54, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S19015C5,    ABISELECT(1544,1204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19015C10,    ABISELECT(1544,1204), //bcp->offset
    26, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19015C12,    ABISELECT(672,540), //bcp->offset
    17, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7268C4,    ABISELECT(42008,32476), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19015C5,    ABISELECT(41888,32380), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19015C8,    ABISELECT(42040,32504), //bcp->offset
    80, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19015C3,    ABISELECT(41888,32380), //bcp->offset
    70, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    18, //immediately_derived
  0, 1},
  {&cd_S19015C13,    ABISELECT(7056,5420), //bcp->offset
    58, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7268C4,    ABISELECT(2408,1872), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19015C5,    ABISELECT(42728,33024), //bcp->offset
    96, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    41, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    22, //immediately_derived
  0, 1},
  {&cd_S19015C11,    ABISELECT(42552,32920), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S19015C14,    ABISELECT(42552,32920), //bcp->offset
    83, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    39, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S19015C2[];
extern void _ZN8S19015C2D1Ev();
extern void _ZN8S19015C2D0Ev();
extern void _ZN8S19015C22v9Ev();
extern void _ZN8S19015C82v6Ev();
extern void _ZN8S19015C62v1Ev();
extern void _ZN8S19015C62v2Ev();
extern void ABISELECT(_ZThn672_N8S19015C2D1Ev,_ZThn540_N8S19015C2D1Ev)();
extern void ABISELECT(_ZThn672_N8S19015C2D0Ev,_ZThn540_N8S19015C2D0Ev)();
extern void ABISELECT(_ZThn1544_N8S19015C2D1Ev,_ZThn1204_N8S19015C2D1Ev)();
extern void ABISELECT(_ZThn1544_N8S19015C2D0Ev,_ZThn1204_N8S19015C2D0Ev)();
extern void _ZN9S19015C102v5Ev();
extern void _ZN8S19015C62v1Ev();
extern void _ZN8S19015C62v2Ev();
extern void ABISELECT(_ZTv0_n40_N8S19015C2D1Ev,_ZTv0_n20_N8S19015C2D1Ev)();
extern void ABISELECT(_ZThn5816_N8S19015C2D1Ev,_ZThn4464_N8S19015C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19015C2D0Ev,_ZTv0_n20_N8S19015C2D0Ev)();
extern void ABISELECT(_ZThn5816_N8S19015C2D0Ev,_ZThn4464_N8S19015C2D0Ev)() __attribute__((weak));
extern void _ZN9S19015C102v5Ev();
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
extern void _ZN8S19015C82v6Ev();
extern void _ZN9S19015C132v7Ev();
extern void ABISELECT(_ZTv0_n72_N8S19015C2D1Ev,_ZTv0_n36_N8S19015C2D1Ev)();
extern void ABISELECT(_ZThn7056_N8S19015C2D1Ev,_ZThn5420_N8S19015C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S19015C2D0Ev,_ZTv0_n36_N8S19015C2D0Ev)();
extern void ABISELECT(_ZThn7056_N8S19015C2D0Ev,_ZThn5420_N8S19015C2D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S19015C2D1Ev,_ZTv0_n28_N8S19015C2D1Ev)();
extern void ABISELECT(_ZThn41888_N8S19015C2D1Ev,_ZThn32380_N8S19015C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S19015C2D0Ev,_ZTv0_n28_N8S19015C2D0Ev)();
extern void ABISELECT(_ZThn41888_N8S19015C2D0Ev,_ZThn32380_N8S19015C2D0Ev)() __attribute__((weak));
extern void _ZN8S19015C82v6Ev();
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
extern void _ZN9S19015C142v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S19015C2D1Ev,_ZTv0_n32_N8S19015C2D1Ev)();
extern void ABISELECT(_ZThn42552_N8S19015C2D1Ev,_ZThn32920_N8S19015C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S19015C2D0Ev,_ZTv0_n32_N8S19015C2D0Ev)();
extern void ABISELECT(_ZThn42552_N8S19015C2D0Ev,_ZThn32920_N8S19015C2D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19015C2D1Ev,_ZTv0_n16_N8S19015C2D1Ev)();
extern void ABISELECT(_ZThn42728_N8S19015C2D1Ev,_ZThn33024_N8S19015C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19015C2D0Ev,_ZTv0_n16_N8S19015C2D0Ev)();
extern void ABISELECT(_ZThn42728_N8S19015C2D0Ev,_ZThn33024_N8S19015C2D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19015C2[] = {
  ABISELECT(42728,33024),
  ABISELECT(42552,32920),
  ABISELECT(41888,32380),
  ABISELECT(7056,5420),
  ABISELECT(6744,5168),
  ABISELECT(6576,5072),
  ABISELECT(5816,4464),
  ABISELECT(4944,3800),
  ABISELECT(4912,3772),
  0,
  (VTBL_ENTRY)&(_ZTI8S19015C2[0]),
  (VTBL_ENTRY)&_ZN8S19015C2D1Ev,
  (VTBL_ENTRY)&_ZN8S19015C2D0Ev,
  (VTBL_ENTRY)&_ZN8S19015C22v9Ev,
  ABISELECT(-152,-124),
  (VTBL_ENTRY)&(_ZTI8S19015C2[0]),
  (VTBL_ENTRY)&_ZN8S19015C82v6Ev,
  ABISELECT(5904,4532),
  ABISELECT(4240,3232),
  ABISELECT(6072,4628),
  ABISELECT(-672,-540),
  (VTBL_ENTRY)&(_ZTI8S19015C2[0]),
  (VTBL_ENTRY)&_ZN8S19015C62v1Ev,
  (VTBL_ENTRY)&_ZN8S19015C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S19015C2D1Ev,_ZThn540_N8S19015C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S19015C2D0Ev,_ZThn540_N8S19015C2D0Ev),
  ABISELECT(5032,3868),
  ABISELECT(3368,2568),
  ABISELECT(-1544,-1204),
  (VTBL_ENTRY)&(_ZTI8S19015C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1544_N8S19015C2D1Ev,_ZThn1204_N8S19015C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1544_N8S19015C2D0Ev,_ZThn1204_N8S19015C2D0Ev),
  (VTBL_ENTRY)&_ZN9S19015C102v5Ev,
  0,
  0,
  ABISELECT(-4944,-3800),
  (VTBL_ENTRY)&(_ZTI8S19015C2[0]),
  (VTBL_ENTRY)&_ZN8S19015C62v1Ev,
  (VTBL_ENTRY)&_ZN8S19015C62v2Ev,
  0,
  ABISELECT(-5816,-4464),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-5816,-4464),
  (VTBL_ENTRY)&(_ZTI8S19015C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19015C2D1Ev,_ZTv0_n20_N8S19015C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19015C2D0Ev,_ZTv0_n20_N8S19015C2D0Ev),
  (VTBL_ENTRY)&_ZN9S19015C102v5Ev,
  0,
  0,
  ABISELECT(-6576,-5072),
  (VTBL_ENTRY)&(_ZTI8S19015C2[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
  0,
  ABISELECT(-6744,-5168),
  (VTBL_ENTRY)&(_ZTI8S19015C2[0]),
  (VTBL_ENTRY)&_ZN8S19015C82v6Ev,
  ABISELECT(-7056,-5420),
  0,
  ABISELECT(-480,-348),
  ABISELECT(-1240,-956),
  ABISELECT(-2112,-1620),
  ABISELECT(-2144,-1648),
  ABISELECT(34832,26960),
  ABISELECT(-7056,-5420),
  (VTBL_ENTRY)&(_ZTI8S19015C2[0]),
  (VTBL_ENTRY)&_ZN9S19015C132v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S19015C2D1Ev,_ZTv0_n36_N8S19015C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S19015C2D0Ev,_ZTv0_n36_N8S19015C2D0Ev),
  ABISELECT(152,124),
  ABISELECT(-41888,-32380),
  ABISELECT(-35312,-27308),
  ABISELECT(-36072,-27916),
  ABISELECT(-36944,-28580),
  ABISELECT(-36976,-28608),
  ABISELECT(-41888,-32380),
  (VTBL_ENTRY)&(_ZTI8S19015C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S19015C2D1Ev,_ZTv0_n28_N8S19015C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S19015C2D0Ev,_ZTv0_n28_N8S19015C2D0Ev),
  ABISELECT(-42040,-32504),
  (VTBL_ENTRY)&(_ZTI8S19015C2[0]),
  (VTBL_ENTRY)&_ZN8S19015C82v6Ev,
  ABISELECT(-42552,-32920),
  0,
  0,
  0,
  ABISELECT(-37640,-29148),
  ABISELECT(176,104),
  ABISELECT(-42552,-32920),
  (VTBL_ENTRY)&(_ZTI8S19015C2[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
  (VTBL_ENTRY)&_ZN9S19015C142v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S19015C2D1Ev,_ZTv0_n32_N8S19015C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S19015C2D0Ev,_ZTv0_n32_N8S19015C2D0Ev),
  ABISELECT(-42728,-33024),
  ABISELECT(-37816,-29252),
  ABISELECT(-42728,-33024),
  (VTBL_ENTRY)&(_ZTI8S19015C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19015C2D1Ev,_ZTv0_n16_N8S19015C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19015C2D0Ev,_ZTv0_n16_N8S19015C2D0Ev),
};
extern VTBL_ENTRY _ZTV8S19015C2[];
extern void _ZN8S19015C3D1Ev();
extern void _ZN8S19015C3D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C3__A__8S19015C2[] = {
  ABISELECT(6576,5072),
  ABISELECT(5816,4464),
  ABISELECT(4944,3800),
  ABISELECT(4912,3772),
  0,
  (VTBL_ENTRY)&(_ZTI8S19015C3[0]),
  (VTBL_ENTRY)&_ZN8S19015C3D1Ev,
  (VTBL_ENTRY)&_ZN8S19015C3D0Ev,
};
extern void _ZN8S19015C5D1Ev();
extern void _ZN8S19015C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C58S19015C3__8S19015C2[] = {
  ABISELECT(4912,3772),
  0,
  (VTBL_ENTRY)&(_ZTI8S19015C5[0]),
  (VTBL_ENTRY)&_ZN8S19015C5D1Ev,
  (VTBL_ENTRY)&_ZN8S19015C5D0Ev,
};
extern void _ZN8S19015C62v1Ev();
extern void _ZN8S19015C62v2Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C6__8S19015C3__A__8S19015C2[] = {
  0,
  0,
  ABISELECT(-4944,-3800),
  (VTBL_ENTRY)&(_ZTI8S19015C3[0]),
  (VTBL_ENTRY)&_ZN8S19015C62v1Ev,
  (VTBL_ENTRY)&_ZN8S19015C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S19015C3D1Ev,_ZTv0_n20_N8S19015C3D1Ev)();
extern void ABISELECT(_ZThn5816_N8S19015C3D1Ev,_ZThn4464_N8S19015C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19015C3D0Ev,_ZTv0_n20_N8S19015C3D0Ev)();
extern void ABISELECT(_ZThn5816_N8S19015C3D0Ev,_ZThn4464_N8S19015C3D0Ev)() __attribute__((weak));
extern void _ZN9S19015C102v5Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C10__8S19015C3__A__8S19015C2[] = {
  0,
  ABISELECT(-5816,-4464),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-5816,-4464),
  (VTBL_ENTRY)&(_ZTI8S19015C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19015C3D1Ev,_ZTv0_n20_N8S19015C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19015C3D0Ev,_ZTv0_n20_N8S19015C3D0Ev),
  (VTBL_ENTRY)&_ZN9S19015C102v5Ev,
};
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C11__8S19015C3__A__8S19015C2[] = {
  0,
  0,
  ABISELECT(-6576,-5072),
  (VTBL_ENTRY)&(_ZTI8S19015C3[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
};
extern void _ZN8S19015C62v1Ev();
extern void _ZN8S19015C62v2Ev();
extern void _ZN9S19015C12D1Ev();
extern void _ZN9S19015C12D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C12__8S19015C2[] = {
  ABISELECT(5904,4532),
  ABISELECT(4240,3232),
  ABISELECT(6072,4628),
  0,
  (VTBL_ENTRY)&(_ZTI9S19015C12[0]),
  (VTBL_ENTRY)&_ZN8S19015C62v1Ev,
  (VTBL_ENTRY)&_ZN8S19015C62v2Ev,
  (VTBL_ENTRY)&_ZN9S19015C12D1Ev,
  (VTBL_ENTRY)&_ZN9S19015C12D0Ev,
};
extern void _ZN9S19015C10D1Ev();
extern void _ZN9S19015C10D0Ev();
extern void _ZN9S19015C102v5Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C109S19015C12__A1__8S19015C2[] = {
  ABISELECT(5032,3868),
  ABISELECT(3368,2568),
  0,
  (VTBL_ENTRY)&(_ZTI9S19015C10[0]),
  (VTBL_ENTRY)&_ZN9S19015C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19015C10D0Ev,
  (VTBL_ENTRY)&_ZN9S19015C102v5Ev,
};
extern void _ZN8S19015C5D1Ev();
extern void _ZN8S19015C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C59S19015C109S19015C12__A2__8S19015C2[] = {
  ABISELECT(3368,2568),
  0,
  (VTBL_ENTRY)&(_ZTI8S19015C5[0]),
  (VTBL_ENTRY)&_ZN8S19015C5D1Ev,
  (VTBL_ENTRY)&_ZN8S19015C5D0Ev,
};
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C11__9S19015C109S19015C12__A1__8S19015C2[] = {
  0,
  0,
  ABISELECT(-5032,-3868),
  (VTBL_ENTRY)&(_ZTI9S19015C10[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
};
extern void _ZN8S19015C82v6Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C8__9S19015C12__8S19015C2[] = {
  0,
  ABISELECT(-6072,-4628),
  (VTBL_ENTRY)&(_ZTI9S19015C12[0]),
  (VTBL_ENTRY)&_ZN8S19015C82v6Ev,
};
extern void ABISELECT(_ZThn872_N9S19015C12D1Ev,_ZThn664_N9S19015C12D1Ev)();
extern void ABISELECT(_ZThn872_N9S19015C12D0Ev,_ZThn664_N9S19015C12D0Ev)();
extern void _ZN9S19015C102v5Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C10__9S19015C12__8S19015C2[] = {
  ABISELECT(5032,3868),
  ABISELECT(3368,2568),
  ABISELECT(-872,-664),
  (VTBL_ENTRY)&(_ZTI9S19015C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn872_N9S19015C12D1Ev,_ZThn664_N9S19015C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn872_N9S19015C12D0Ev,_ZThn664_N9S19015C12D0Ev),
  (VTBL_ENTRY)&_ZN9S19015C102v5Ev,
};
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C11__9S19015C12__8S19015C2[] = {
  0,
  0,
  ABISELECT(-5904,-4532),
  (VTBL_ENTRY)&(_ZTI9S19015C12[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
};
extern void _ZN9S19015C10D1Ev();
extern void _ZN9S19015C10D0Ev();
extern void _ZN9S19015C102v5Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C10__8S19015C2[] = {
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  0,
  (VTBL_ENTRY)&(_ZTI9S19015C10[0]),
  (VTBL_ENTRY)&_ZN9S19015C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19015C10D0Ev,
  (VTBL_ENTRY)&_ZN9S19015C102v5Ev,
};
extern void _ZN8S19015C5D1Ev();
extern void _ZN8S19015C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C59S19015C10__A1__8S19015C2[] = {
  ABISELECT(-904,-692),
  0,
  (VTBL_ENTRY)&(_ZTI8S19015C5[0]),
  (VTBL_ENTRY)&_ZN8S19015C5D1Ev,
  (VTBL_ENTRY)&_ZN8S19015C5D0Ev,
};
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C11__9S19015C10__8S19015C2[] = {
  0,
  0,
  ABISELECT(-760,-608),
  (VTBL_ENTRY)&(_ZTI9S19015C10[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
};
extern void _ZN9S19015C132v7Ev();
extern void _ZN9S19015C13D1Ev();
extern void _ZN9S19015C13D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C13__8S19015C2[] = {
  ABISELECT(-480,-348),
  ABISELECT(-1240,-956),
  ABISELECT(-2112,-1620),
  ABISELECT(-2144,-1648),
  ABISELECT(34832,26960),
  0,
  (VTBL_ENTRY)&(_ZTI9S19015C13[0]),
  (VTBL_ENTRY)&_ZN9S19015C132v7Ev,
  (VTBL_ENTRY)&_ZN9S19015C13D1Ev,
  (VTBL_ENTRY)&_ZN9S19015C13D0Ev,
};
extern void ABISELECT(_ZTv0_n56_N9S19015C13D1Ev,_ZTv0_n28_N9S19015C13D1Ev)();
extern void ABISELECT(_ZThn34832_N9S19015C13D1Ev,_ZThn26960_N9S19015C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S19015C13D0Ev,_ZTv0_n28_N9S19015C13D0Ev)();
extern void ABISELECT(_ZThn34832_N9S19015C13D0Ev,_ZThn26960_N9S19015C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19015C3__9S19015C13__8S19015C2[] = {
  ABISELECT(152,124),
  ABISELECT(-34832,-26960),
  ABISELECT(-35312,-27308),
  ABISELECT(-36072,-27916),
  ABISELECT(-36944,-28580),
  ABISELECT(-36976,-28608),
  ABISELECT(-34832,-26960),
  (VTBL_ENTRY)&(_ZTI9S19015C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19015C13D1Ev,_ZTv0_n28_N9S19015C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19015C13D0Ev,_ZTv0_n28_N9S19015C13D0Ev),
};
extern void _ZN8S19015C62v1Ev();
extern void _ZN8S19015C62v2Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C6__9S19015C13__8S19015C2[] = {
  0,
  0,
  ABISELECT(2112,1620),
  (VTBL_ENTRY)&(_ZTI9S19015C13[0]),
  (VTBL_ENTRY)&_ZN8S19015C62v1Ev,
  (VTBL_ENTRY)&_ZN8S19015C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19015C13D1Ev,_ZTv0_n20_N9S19015C13D1Ev)();
extern void ABISELECT(_ZTv0_n40_N9S19015C13D0Ev,_ZTv0_n20_N9S19015C13D0Ev)();
extern void _ZN9S19015C102v5Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C10__9S19015C13__8S19015C2[] = {
  0,
  ABISELECT(1240,956),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(1240,956),
  (VTBL_ENTRY)&(_ZTI9S19015C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19015C13D1Ev,_ZTv0_n20_N9S19015C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19015C13D0Ev,_ZTv0_n20_N9S19015C13D0Ev),
  (VTBL_ENTRY)&_ZN9S19015C102v5Ev,
};
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C11__9S19015C13__8S19015C2[] = {
  0,
  0,
  ABISELECT(480,348),
  (VTBL_ENTRY)&(_ZTI9S19015C13[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
};
extern void _ZN8S19015C82v6Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C88S19015C3__9S19015C13__8S19015C2[] = {
  ABISELECT(-34984,-27084),
  (VTBL_ENTRY)&(_ZTI9S19015C13[0]),
  (VTBL_ENTRY)&_ZN8S19015C82v6Ev,
};
extern void _ZN8S19015C3D1Ev();
extern void _ZN8S19015C3D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C3__A1__8S19015C2[] = {
  ABISELECT(-35312,-27308),
  ABISELECT(-36072,-27916),
  ABISELECT(-36944,-28580),
  ABISELECT(-36976,-28608),
  0,
  (VTBL_ENTRY)&(_ZTI8S19015C3[0]),
  (VTBL_ENTRY)&_ZN8S19015C3D1Ev,
  (VTBL_ENTRY)&_ZN8S19015C3D0Ev,
};
extern void _ZN8S19015C5D1Ev();
extern void _ZN8S19015C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C58S19015C3__A3__8S19015C2[] = {
  ABISELECT(-36976,-28608),
  0,
  (VTBL_ENTRY)&(_ZTI8S19015C5[0]),
  (VTBL_ENTRY)&_ZN8S19015C5D1Ev,
  (VTBL_ENTRY)&_ZN8S19015C5D0Ev,
};
extern void _ZN8S19015C62v1Ev();
extern void _ZN8S19015C62v2Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C6__8S19015C3__A1__8S19015C2[] = {
  0,
  0,
  ABISELECT(36944,28580),
  (VTBL_ENTRY)&(_ZTI8S19015C3[0]),
  (VTBL_ENTRY)&_ZN8S19015C62v1Ev,
  (VTBL_ENTRY)&_ZN8S19015C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S19015C3D1Ev,_ZTv0_n20_N8S19015C3D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S19015C3D0Ev,_ZTv0_n20_N8S19015C3D0Ev)();
extern void _ZN9S19015C102v5Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C10__8S19015C3__A1__8S19015C2[] = {
  0,
  ABISELECT(36072,27916),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(36072,27916),
  (VTBL_ENTRY)&(_ZTI8S19015C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19015C3D1Ev,_ZTv0_n20_N8S19015C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19015C3D0Ev,_ZTv0_n20_N8S19015C3D0Ev),
  (VTBL_ENTRY)&_ZN9S19015C102v5Ev,
};
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C11__8S19015C3__A1__8S19015C2[] = {
  0,
  0,
  ABISELECT(35312,27308),
  (VTBL_ENTRY)&(_ZTI8S19015C3[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
};
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
extern void _ZN9S19015C142v8Ev();
extern void _ZN9S19015C14D1Ev();
extern void _ZN9S19015C14D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C14__8S19015C2[] = {
  ABISELECT(-37640,-29148),
  ABISELECT(176,104),
  0,
  (VTBL_ENTRY)&(_ZTI9S19015C14[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
  (VTBL_ENTRY)&_ZN9S19015C142v8Ev,
  (VTBL_ENTRY)&_ZN9S19015C14D1Ev,
  (VTBL_ENTRY)&_ZN9S19015C14D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S19015C14D1Ev,_ZTv0_n16_N9S19015C14D1Ev)();
extern void ABISELECT(_ZThn176_N9S19015C14D1Ev,_ZThn104_N9S19015C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19015C14D0Ev,_ZTv0_n16_N9S19015C14D0Ev)();
extern void ABISELECT(_ZThn176_N9S19015C14D0Ev,_ZThn104_N9S19015C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19015C5__9S19015C14__8S19015C2[] = {
  ABISELECT(-176,-104),
  ABISELECT(-37816,-29252),
  ABISELECT(-176,-104),
  (VTBL_ENTRY)&(_ZTI9S19015C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19015C14D1Ev,_ZTv0_n16_N9S19015C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19015C14D0Ev,_ZTv0_n16_N9S19015C14D0Ev),
};
extern void _ZN8S19015C5D1Ev();
extern void _ZN8S19015C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C5__A4__8S19015C2[] = {
  ABISELECT(-37816,-29252),
  0,
  (VTBL_ENTRY)&(_ZTI8S19015C5[0]),
  (VTBL_ENTRY)&_ZN8S19015C5D1Ev,
  (VTBL_ENTRY)&_ZN8S19015C5D0Ev,
};
static  VTT_ENTRY vtt_S19015C2[] = {
  {&(_ZTV8S19015C2[11]),  11,102},
  {&(_tg__ZTV8S19015C3__A__8S19015C2[6]),  6,8},
  {&(_tg__ZTV8S19015C58S19015C3__8S19015C2[3]),  3,5},
  {&(_tg__ZTV8S19015C6__8S19015C3__A__8S19015C2[4]),  4,6},
  {&(_tg__ZTV9S19015C10__8S19015C3__A__8S19015C2[6]),  6,9},
  {&(_tg__ZTV9S19015C11__8S19015C3__A__8S19015C2[4]),  4,6},
  {&(_tg__ZTV9S19015C12__8S19015C2[5]),  5,9},
  {&(_tg__ZTV9S19015C109S19015C12__A1__8S19015C2[4]),  4,7},
  {&(_tg__ZTV8S19015C59S19015C109S19015C12__A2__8S19015C2[3]),  3,5},
  {&(_tg__ZTV9S19015C11__9S19015C109S19015C12__A1__8S19015C2[4]),  4,6},
  {&(_tg__ZTV8S19015C8__9S19015C12__8S19015C2[3]),  3,4},
  {&(_tg__ZTV9S19015C10__9S19015C12__8S19015C2[4]),  4,7},
  {&(_tg__ZTV9S19015C11__9S19015C12__8S19015C2[4]),  4,6},
  {&(_ZTV8S19015C2[37]),  37,102},
  {&(_ZTV8S19015C2[45]),  45,102},
  {&(_ZTV8S19015C2[52]),  52,102},
  {&(_ZTV8S19015C2[22]),  22,102},
  {&(_ZTV8S19015C2[57]),  57,102},
  {&(_ZTV8S19015C2[30]),  30,102},
  {&(_ZTV8S19015C2[67]),  67,102},
  {&(_ZTV8S19015C2[78]),  78,102},
  {&(_ZTV8S19015C2[82]),  82,102},
  {&(_ZTV8S19015C2[91]),  91,102},
  {&(_ZTV8S19015C2[100]),  100,102},
  {&(_tg__ZTV9S19015C10__8S19015C2[4]),  4,7},
  {&(_tg__ZTV8S19015C59S19015C10__A1__8S19015C2[3]),  3,5},
  {&(_tg__ZTV9S19015C11__9S19015C10__8S19015C2[4]),  4,6},
  {&(_tg__ZTV9S19015C13__8S19015C2[7]),  7,10},
  {&(_tg__ZTV8S19015C3__9S19015C13__8S19015C2[8]),  8,10},
  {&(_tg__ZTV8S19015C6__9S19015C13__8S19015C2[4]),  4,6},
  {&(_tg__ZTV9S19015C10__9S19015C13__8S19015C2[6]),  6,9},
  {&(_tg__ZTV9S19015C11__9S19015C13__8S19015C2[4]),  4,6},
  {&(_tg__ZTV8S19015C88S19015C3__9S19015C13__8S19015C2[2]),  2,3},
  {&(_tg__ZTV8S19015C3__A1__8S19015C2[6]),  6,8},
  {&(_tg__ZTV8S19015C58S19015C3__A3__8S19015C2[3]),  3,5},
  {&(_tg__ZTV8S19015C6__8S19015C3__A1__8S19015C2[4]),  4,6},
  {&(_tg__ZTV9S19015C10__8S19015C3__A1__8S19015C2[6]),  6,9},
  {&(_tg__ZTV9S19015C11__8S19015C3__A1__8S19015C2[4]),  4,6},
  {&(_tg__ZTV9S19015C14__8S19015C2[4]),  4,9},
  {&(_tg__ZTV8S19015C5__9S19015C14__8S19015C2[4]),  4,6},
  {&(_tg__ZTV8S19015C5__A4__8S19015C2[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S19015C2[];
extern  VTBL_ENTRY _ZTV8S19015C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19015C2[];
static VTBL_ENTRY alt_thunk_names17[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19015C14D0Ev,_ZTv0_n16_N9S19015C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N9S19015C14D0Ev,_ZThn104_N9S19015C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19015C14D1Ev,_ZTv0_n16_N9S19015C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N9S19015C14D1Ev,_ZThn104_N9S19015C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19015C13D0Ev,_ZTv0_n28_N9S19015C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn34832_N9S19015C13D0Ev,_ZThn26960_N9S19015C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19015C13D1Ev,_ZTv0_n28_N9S19015C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn34832_N9S19015C13D1Ev,_ZThn26960_N9S19015C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19015C3D0Ev,_ZTv0_n20_N8S19015C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5816_N8S19015C3D0Ev,_ZThn4464_N8S19015C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19015C3D1Ev,_ZTv0_n20_N8S19015C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5816_N8S19015C3D1Ev,_ZThn4464_N8S19015C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19015C2D0Ev,_ZTv0_n16_N8S19015C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn42728_N8S19015C2D0Ev,_ZThn33024_N8S19015C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19015C2D1Ev,_ZTv0_n16_N8S19015C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn42728_N8S19015C2D1Ev,_ZThn33024_N8S19015C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S19015C2D0Ev,_ZTv0_n32_N8S19015C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn42552_N8S19015C2D0Ev,_ZThn32920_N8S19015C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S19015C2D1Ev,_ZTv0_n32_N8S19015C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn42552_N8S19015C2D1Ev,_ZThn32920_N8S19015C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S19015C2D0Ev,_ZTv0_n28_N8S19015C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn41888_N8S19015C2D0Ev,_ZThn32380_N8S19015C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S19015C2D1Ev,_ZTv0_n28_N8S19015C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn41888_N8S19015C2D1Ev,_ZThn32380_N8S19015C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S19015C2D0Ev,_ZTv0_n36_N8S19015C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7056_N8S19015C2D0Ev,_ZThn5420_N8S19015C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S19015C2D1Ev,_ZTv0_n36_N8S19015C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7056_N8S19015C2D1Ev,_ZThn5420_N8S19015C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19015C2D0Ev,_ZTv0_n20_N8S19015C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5816_N8S19015C2D0Ev,_ZThn4464_N8S19015C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19015C2D1Ev,_ZTv0_n20_N8S19015C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5816_N8S19015C2D1Ev,_ZThn4464_N8S19015C2D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19015C2 = {  "S19015C2", // class name
  bases_S19015C2, 23,
  &(vtc_S19015C2[0]), // expected_vtbl_contents
  &(vtt_S19015C2[0]), // expected_vtt_contents
  ABISELECT(42848,33120), // object size
  NSPAIRA(_ZTI8S19015C2),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S19015C2),102, //virtual function table var
  11, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19015C2),41, //virtual table table var
  19, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names17,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19015C16  : S19015C11 {
  void *s19015c16f0;
  ::S19015C12 s19015c16f1[9];
  int s19015c16f2:3;
  char s19015c16f3[7];
  virtual void  v10(); // _ZN9S19015C163v10Ev
  ~S19015C16(); // tgen
  S19015C16(); // tgen
};
//SIG(-1 S19015C16) C1{ BC2{ v2 v3 Fi Fp[2] Fl Fp[3] Fl[6] FC3{ m Fs[6] FL Fc[5]} Fi Fp Fc[2]} v1 Fp FC4{ BC5{ v4 v5 FC3 Fc FC6{ BC7{ v8 FU8{ m Fl Fp[4] Fi} Fp FC3[8] Fp} VBC3 BC9{ VBC3 vd FC3 Fi Fp FC3[2]} Fp[5] Fc:0 Fi Fi Fi:10 Fc[8] Fs Fi Fp[10] FC9 FL Fi Fp} Fp Fi Fi Fp Fi Fi:11 Fi} VBC10{ v6 FU8 Fp FC3[8] Fp} VBC3 BC11{ BC12{ VBC3 vd FC3 Fi Fp FC3[2]} VBC2 vd v7 Fl[4] FC12[4]} vd Fi Fi Fc[4] Fp[3] Fs Fi Fi FD Fp Fp Fi}[9] Fi:3 Fc[7]}


void  S19015C16 ::v10(){vfunc_called(this, "_ZN9S19015C163v10Ev");}
S19015C16 ::~S19015C16(){ note_dtor("S19015C16", this);} // tgen
S19015C16 ::S19015C16(){ note_ctor("S19015C16", this);} // tgen

static void Test_S19015C16()
{
  extern Class_Descriptor cd_S19015C16;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1282,3871)];
    init_test(&cd_S19015C16, buf);
    S19015C16 *dp, &lv = *(dp=new (buf) S19015C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(20496,15480), "sizeof(S19015C16)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19015C16)");
    check_base_class_offset(lv, (S19015C11*), 0, "S19015C16");
    check_field_offset(lv, s19015c16f0, ABISELECT(168,96), "S19015C16.s19015c16f0");
    check_field_offset(lv, s19015c16f1, ABISELECT(176,100), "S19015C16.s19015c16f1");
    set_bf_and_test(lv, s19015c16f2, ABISELECT(20480,15472), 0, 3, 1, "S19015C16");
    set_bf_and_test(lv, s19015c16f2, ABISELECT(20480,15472), 0, 3, hide_sll(1LL<<2), "S19015C16");
    check_field_offset(lv, s19015c16f3, ABISELECT(20481,15473), "S19015C16.s19015c16f3");
    test_class_info(&lv, &cd_S19015C16);
    dp->~S19015C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19015C16(Test_S19015C16, "S19015C16", ABISELECT(20496,15480));

#else // __cplusplus

extern void _ZN9S19015C16C1Ev();
extern void _ZN9S19015C16D1Ev();
Name_Map name_map_S19015C16[] = {
  NSPAIR(_ZN9S19015C16C1Ev),
  NSPAIR(_ZN9S19015C16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19015C11;
extern VTBL_ENTRY _ZTI9S19015C11[];
extern  VTBL_ENTRY _ZTV9S19015C11[];
static Base_Class bases_S19015C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19015C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19015C16[];
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
extern void _ZN9S19015C163v10Ev();
static  VTBL_ENTRY vtc_S19015C16[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S19015C16[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
  (VTBL_ENTRY)&_ZN9S19015C163v10Ev,
};
extern VTBL_ENTRY _ZTI9S19015C16[];
extern  VTBL_ENTRY _ZTV9S19015C16[];
Class_Descriptor cd_S19015C16 = {  "S19015C16", // class name
  bases_S19015C16, 1,
  &(vtc_S19015C16[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(20496,15480), // object size
  NSPAIRA(_ZTI9S19015C16),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S19015C16),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19015C17  : virtual S19015C6 {
  void *s19015c17f0;
  virtual void  v11(); // _ZN9S19015C173v11Ev
  ~S19015C17(); // tgen
  S19015C17(); // tgen
};
//SIG(-1 S19015C17) C1{ VBC2{ v2 v3 FC3{ m Fs[6] FL Fc[5]} Fc FC4{ BC5{ v4 FU6{ m Fl Fp[4] Fi} Fp FC3[8] Fp} VBC3 BC7{ VBC3 vd FC3 Fi Fp FC3[2]} Fp[5] Fc:0 Fi Fi Fi:10 Fc[8] Fs Fi Fp[10] FC7 FL Fi Fp} Fp Fi Fi Fp Fi Fi:11 Fi} v1 Fp}


void  S19015C17 ::v11(){vfunc_called(this, "_ZN9S19015C173v11Ev");}
S19015C17 ::~S19015C17(){ note_dtor("S19015C17", this);} // tgen
S19015C17 ::S19015C17(){ note_ctor("S19015C17", this);} // tgen

static void Test_S19015C17()
{
  extern Class_Descriptor cd_S19015C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(112,169)];
    init_test(&cd_S19015C17, buf);
    S19015C17 *dp, &lv = *(dp=new (buf) S19015C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(888,672), "sizeof(S19015C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19015C17)");
    check_base_class_offset(lv, (S19015C6*), ABISELECT(16,8), "S19015C17");
    check_field_offset(lv, s19015c17f0, ABISELECT(8,4), "S19015C17.s19015c17f0");
    test_class_info(&lv, &cd_S19015C17);
    dp->~S19015C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19015C17(Test_S19015C17, "S19015C17", ABISELECT(888,672));

#else // __cplusplus

extern void _ZN9S19015C17C1Ev();
extern void _ZN9S19015C17D1Ev();
Name_Map name_map_S19015C17[] = {
  NSPAIR(_ZN9S19015C17C1Ev),
  NSPAIR(_ZN9S19015C17D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19015C6;
extern VTBL_ENTRY _ZTI8S19015C6[];
extern  VTBL_ENTRY _ZTV8S19015C6[];
static Base_Class bases_S19015C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19015C6,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19015C17[];
extern void _ZN9S19015C173v11Ev();
extern void _ZN8S19015C62v1Ev();
extern void _ZN8S19015C62v2Ev();
static  VTBL_ENTRY vtc_S19015C17[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI9S19015C17[0]),
  (VTBL_ENTRY)&_ZN9S19015C173v11Ev,
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S19015C17[0]),
  (VTBL_ENTRY)&_ZN8S19015C62v1Ev,
  (VTBL_ENTRY)&_ZN8S19015C62v2Ev,
};
extern VTBL_ENTRY _ZTV9S19015C17[];
static  VTT_ENTRY vtt_S19015C17[] = {
  {&(_ZTV9S19015C17[3]),  3,10},
  {&(_ZTV9S19015C17[8]),  8,10},
};
extern VTBL_ENTRY _ZTI9S19015C17[];
extern  VTBL_ENTRY _ZTV9S19015C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19015C17[];
Class_Descriptor cd_S19015C17 = {  "S19015C17", // class name
  bases_S19015C17, 1,
  &(vtc_S19015C17[0]), // expected_vtbl_contents
  &(vtt_S19015C17[0]), // expected_vtt_contents
  ABISELECT(888,672), // object size
  NSPAIRA(_ZTI9S19015C17),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV9S19015C17),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19015C17),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19015C1  : virtual S19015C2 , S19015C16 , S19015C12 , S19015C17 , S19015C14 {
  __tsi64 s19015c1f0;
  int s19015c1f1;
  int s19015c1f2[10];
  ~S19015C1(); // tgen
  S19015C1(); // tgen
};
//SIG(1 S19015C1) C1{ VBC2{ BC3{ BC4{ m Fs[6] FL Fc[5]} BC5{ VBC4 vd FC4 Fi Fp FC4[2]} VBC6{ v1 v2 FC4 Fc FC7{ BC8{ v12 FU9{ m Fl Fp[4] Fi} Fp FC4[8] Fp} VBC4 BC10{ VBC4 vd FC4 Fi Fp FC4[2]} Fp[5] Fc:0 Fi Fi Fi:10 Fc[8] Fs Fi Fp[10] FC10 FL Fi Fp} Fp Fi Fi Fp Fi Fi:11 Fi} VBC11{ BC5 VBC12{ v3 v4 Fi Fp Fp Fl Fp[2] Fp Fl[6] FC4 Fi Fp Fc[2]} vd v5 Fl[4] FC5[4]} BC13{ v6 FU9 Fp FC4[8] Fp} Fp Fi[6] FL FC5 Fc} BC14{ BC6 VBC13 VBC4 BC11 vd Fi Fi Fc[4] Fp[3] Fs Fi Fi FD Fp Fp Fi} VBC15{ VBC3 v7 FC4 FC11[5] FC3[10] FL[4] Fc FC3 FC3} BC4 VBC16{ VBC5 BC12 v8 Fi Fp} vd v9 FU17{ m Fi Fc[7] Fi[10] Fi FD[8] Fi Fp Fi} Fp Fi FL FL FC14 FL Fi[8] Fi} BC18{ BC12 v10 Fp FC14[9] Fi:3 Fc[7]} BC14 BC19{ VBC6 v11 Fp} BC16 FL Fi Fi[10]}


S19015C1 ::~S19015C1(){ note_dtor("S19015C1", this);} // tgen
S19015C1 ::S19015C1(){ note_ctor("S19015C1", this);} // tgen

static void Test_S19015C1()
{
  extern Class_Descriptor cd_S19015C1;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(4084,12525)];
    init_test(&cd_S19015C1, buf);
    S19015C1 *dp, &lv = *(dp=new (buf) S19015C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(65328,50096), "sizeof(S19015C1)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19015C1)");
    /*is_ambiguous_... S19015C2::S19015C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S19015C3*)(S19015C2*), ABISELECT(22600,17072), "S19015C1");
    /*is_ambiguous_... S19015C2::S19015C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S19015C5*)(S19015C3*)(S19015C2*), ABISELECT(27392,20748), "S19015C1");
    /*is_ambiguous_... S19015C1::S19015C10 */ AMB_check_base_class_offset(lv, (S7268C4*)(S19015C5*)(S19015C10*), ABISELECT(27392,20748), "S19015C1");
    check_base_class_offset(lv, (S7268C4*)(S19015C12*)(S19015C2*), ABISELECT(27392,20748), "S19015C1");
    check_base_class_offset(lv, (S7268C4*)(S19015C5*)(S19015C10*)(S19015C12*)(S19015C2*), ABISELECT(27392,20748), "S19015C1");
    /*is_ambiguous_... S19015C1::S19015C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S19015C5*)(S19015C3*), ABISELECT(27392,20748), "S19015C1");
    /*is_ambiguous_... S19015C1::S19015C5 */ AMB_check_base_class_offset(lv, (S7268C4*)(S19015C5*), ABISELECT(27392,20748), "S19015C1");
    /*is_ambiguous_... S19015C1::S19015C12 */ AMB_check_base_class_offset(lv, (S7268C4*)(S19015C12*), ABISELECT(27392,20748), "S19015C1");
    /*is_ambiguous_... S19015C1::S19015C12 */ AMB_check_base_class_offset(lv, (S7268C4*)(S19015C5*)(S19015C10*)(S19015C12*), ABISELECT(27392,20748), "S19015C1");
    /*is_ambiguous_... S19015C2::S19015C3 */ AMB_check_base_class_offset(lv, (S19015C5*)(S19015C3*)(S19015C2*), ABISELECT(22480,16976), "S19015C1");
    /*is_ambiguous_... S19015C2::S19015C3 */ AMB_check_base_class_offset(lv, (S19015C6*)(S19015C3*)(S19015C2*), ABISELECT(27424,20776), "S19015C1");
    /*is_ambiguous_... S19015C1::S19015C3 */ AMB_check_base_class_offset(lv, (S19015C6*)(S19015C3*), ABISELECT(27424,20776), "S19015C1");
    check_base_class_offset(lv, (S19015C6*)(S19015C17*), ABISELECT(27424,20776), "S19015C1");
    /*is_ambiguous_... S19015C1::S19015C10 */ AMB_check_base_class_offset(lv, (S19015C5*)(S19015C10*), ABISELECT(28296,21440), "S19015C1");
    /*is_ambiguous_... S19015C1::S19015C10 */ AMB_check_base_class_offset(lv, (S19015C11*)(S19015C10*), ABISELECT(29056,22048), "S19015C1");
    check_base_class_offset(lv, (S19015C11*)(S19015C10*)(S19015C12*)(S19015C2*), ABISELECT(29056,22048), "S19015C1");
    /*is_ambiguous_... S19015C1::S19015C12 */ AMB_check_base_class_offset(lv, (S19015C11*)(S19015C10*)(S19015C12*), ABISELECT(29056,22048), "S19015C1");
    /*is_ambiguous_... S19015C2::S19015C3 */ AMB_check_base_class_offset(lv, (S19015C10*)(S19015C3*)(S19015C2*), ABISELECT(28296,21440), "S19015C1");
    /*is_ambiguous_... S19015C1::S19015C3 */ AMB_check_base_class_offset(lv, (S19015C10*)(S19015C3*), ABISELECT(28296,21440), "S19015C1");
    /*is_ambiguous_... S19015C2::S19015C3 */ AMB_check_base_class_offset(lv, (S19015C8*)(S19015C3*)(S19015C2*), ABISELECT(22632,17100), "S19015C1");
    /*is_ambiguous_... S19015C2::S19015C3 */ AMB_check_base_class_offset(lv, (S19015C3*)(S19015C2*), ABISELECT(22480,16976), "S19015C1");
    check_base_class_offset(lv, (S19015C6*)(S19015C12*)(S19015C2*), ABISELECT(23152,17516), "S19015C1");
    check_base_class_offset(lv, (S19015C8*)(S19015C12*)(S19015C2*), ABISELECT(29224,22144), "S19015C1");
    /*is_ambiguous_... S19015C1::S19015C12 */ AMB_check_base_class_offset(lv, (S19015C8*)(S19015C12*), ABISELECT(29224,22144), "S19015C1");
    check_base_class_offset(lv, (S19015C5*)(S19015C10*)(S19015C12*)(S19015C2*), ABISELECT(24024,18180), "S19015C1");
    check_base_class_offset(lv, (S19015C10*)(S19015C12*)(S19015C2*), ABISELECT(24024,18180), "S19015C1");
    check_base_class_offset(lv, (S19015C12*)(S19015C2*), ABISELECT(23152,17516), "S19015C1");
    /*is_ambiguous_... S19015C1::S19015C3 */ AMB_check_base_class_offset(lv, (S7268C4*)(S19015C3*), ABISELECT(64488,49452), "S19015C1");
    /*is_ambiguous_... S19015C1::S19015C3 */ AMB_check_base_class_offset(lv, (S19015C5*)(S19015C3*), ABISELECT(64368,49356), "S19015C1");
    /*is_ambiguous_... S19015C1::S19015C3 */ AMB_check_base_class_offset(lv, (S19015C8*)(S19015C3*), ABISELECT(64520,49480), "S19015C1");
    check_base_class_offset(lv, (S19015C3*)(S19015C13*), ABISELECT(64368,49356), "S19015C1");
    check_base_class_offset(lv, (S19015C13*)(S19015C2*), ABISELECT(29536,22396), "S19015C1");
    /*is_ambiguous_... S19015C2::S7268C4 */ AMB_check_base_class_offset(lv, (S7268C4*)(S19015C2*), ABISELECT(24888,18848), "S19015C1");
    /*is_ambiguous_... S19015C1::S19015C14 */ AMB_check_base_class_offset(lv, (S19015C5*)(S19015C14*), ABISELECT(65208,50000), "S19015C1");
    /*is_ambiguous_... S19015C1::S19015C14 */ AMB_check_base_class_offset(lv, (S19015C5*)(S19015C14*), ABISELECT(65208,50000), "S19015C1");
    /*is_ambiguous_... S19015C1::S19015C14 */ AMB_check_base_class_offset(lv, (S19015C11*)(S19015C14*), ABISELECT(65032,49896), "S19015C1");
    check_base_class_offset(lv, (S19015C14*)(S19015C2*), ABISELECT(65032,49896), "S19015C1");
    check_base_class_offset(lv, (S19015C2*), ABISELECT(22480,16976), "S19015C1");
    check_base_class_offset(lv, (S19015C11*)(S19015C16*), 0, "S19015C1");
    check_base_class_offset(lv, (S19015C16*), 0, "S19015C1");
    /*is_ambiguous_... S19015C1::S19015C12 */ AMB_check_base_class_offset(lv, (S19015C6*)(S19015C12*), ABISELECT(20496,15480), "S19015C1");
    /*is_ambiguous_... S19015C1::S19015C12 */ AMB_check_base_class_offset(lv, (S19015C5*)(S19015C10*)(S19015C12*), ABISELECT(21368,16144), "S19015C1");
    /*is_ambiguous_... S19015C1::S19015C12 */ AMB_check_base_class_offset(lv, (S19015C10*)(S19015C12*), ABISELECT(21368,16144), "S19015C1");
    /*is_ambiguous_... S19015C1::S19015C12 */ AMB_check_base_class_offset(lv, (S19015C12*), ABISELECT(20496,15480), "S19015C1");
    check_base_class_offset(lv, (S19015C17*), ABISELECT(22232,16812), "S19015C1");
    /*is_ambiguous_... S19015C1::S19015C14 */ AMB_check_base_class_offset(lv, (S19015C11*)(S19015C14*), ABISELECT(22248,16820), "S19015C1");
    /*is_ambiguous_... S19015C1::S19015C14 */ AMB_check_base_class_offset(lv, (S19015C14*), ABISELECT(22248,16820), "S19015C1");
    check_field_offset(lv, s19015c1f0, ABISELECT(22424,16924), "S19015C1.s19015c1f0");
    check_field_offset(lv, s19015c1f1, ABISELECT(22432,16932), "S19015C1.s19015c1f1");
    check_field_offset(lv, s19015c1f2, ABISELECT(22436,16936), "S19015C1.s19015c1f2");
    test_class_info(&lv, &cd_S19015C1);
    dp->~S19015C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19015C1(Test_S19015C1, "S19015C1", ABISELECT(65328,50096));

#else // __cplusplus

extern void _ZN8S19015C1C1Ev();
extern void _ZN8S19015C1D1Ev();
Name_Map name_map_S19015C1[] = {
  NSPAIR(_ZN8S19015C1C1Ev),
  NSPAIR(_ZN8S19015C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S19015C5;
extern VTBL_ENTRY _ZTI8S19015C5[];
extern  VTBL_ENTRY _ZTV8S19015C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19015C5[];
extern Class_Descriptor cd_S19015C6;
extern VTBL_ENTRY _ZTI8S19015C6[];
extern  VTBL_ENTRY _ZTV8S19015C6[];
extern Class_Descriptor cd_S19015C5;
extern VTBL_ENTRY _ZTI8S19015C5[];
extern  VTBL_ENTRY _ZTV8S19015C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19015C5[];
extern Class_Descriptor cd_S19015C11;
extern VTBL_ENTRY _ZTI9S19015C11[];
extern  VTBL_ENTRY _ZTV9S19015C11[];
extern Class_Descriptor cd_S19015C10;
extern VTBL_ENTRY _ZTI9S19015C10[];
extern  VTBL_ENTRY _ZTV9S19015C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19015C10[];
extern Class_Descriptor cd_S19015C8;
extern VTBL_ENTRY _ZTI8S19015C8[];
extern  VTBL_ENTRY _ZTV8S19015C8[];
extern Class_Descriptor cd_S19015C3;
extern VTBL_ENTRY _ZTI8S19015C3[];
extern  VTBL_ENTRY _ZTV8S19015C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19015C3[];
extern Class_Descriptor cd_S19015C6;
extern VTBL_ENTRY _ZTI8S19015C6[];
extern  VTBL_ENTRY _ZTV8S19015C6[];
extern Class_Descriptor cd_S19015C8;
extern VTBL_ENTRY _ZTI8S19015C8[];
extern  VTBL_ENTRY _ZTV8S19015C8[];
extern Class_Descriptor cd_S19015C5;
extern VTBL_ENTRY _ZTI8S19015C5[];
extern  VTBL_ENTRY _ZTV8S19015C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19015C5[];
extern Class_Descriptor cd_S19015C10;
extern VTBL_ENTRY _ZTI9S19015C10[];
extern  VTBL_ENTRY _ZTV9S19015C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19015C10[];
extern Class_Descriptor cd_S19015C12;
extern VTBL_ENTRY _ZTI9S19015C12[];
extern  VTBL_ENTRY _ZTV9S19015C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19015C12[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S19015C5;
extern VTBL_ENTRY _ZTI8S19015C5[];
extern  VTBL_ENTRY _ZTV8S19015C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19015C5[];
extern Class_Descriptor cd_S19015C8;
extern VTBL_ENTRY _ZTI8S19015C8[];
extern  VTBL_ENTRY _ZTV8S19015C8[];
extern Class_Descriptor cd_S19015C3;
extern VTBL_ENTRY _ZTI8S19015C3[];
extern  VTBL_ENTRY _ZTV8S19015C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19015C3[];
extern Class_Descriptor cd_S19015C13;
extern VTBL_ENTRY _ZTI9S19015C13[];
extern  VTBL_ENTRY _ZTV9S19015C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19015C13[];
extern Class_Descriptor cd_S7268C4;
extern VTBL_ENTRY _ZTI7S7268C4[];
extern Class_Descriptor cd_S19015C5;
extern VTBL_ENTRY _ZTI8S19015C5[];
extern  VTBL_ENTRY _ZTV8S19015C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19015C5[];
extern Class_Descriptor cd_S19015C11;
extern VTBL_ENTRY _ZTI9S19015C11[];
extern  VTBL_ENTRY _ZTV9S19015C11[];
extern Class_Descriptor cd_S19015C14;
extern VTBL_ENTRY _ZTI9S19015C14[];
extern  VTBL_ENTRY _ZTV9S19015C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19015C14[];
extern Class_Descriptor cd_S19015C2;
extern VTBL_ENTRY _ZTI8S19015C2[];
extern  VTBL_ENTRY _ZTV8S19015C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19015C2[];
extern Class_Descriptor cd_S19015C11;
extern VTBL_ENTRY _ZTI9S19015C11[];
extern  VTBL_ENTRY _ZTV9S19015C11[];
extern Class_Descriptor cd_S19015C16;
extern VTBL_ENTRY _ZTI9S19015C16[];
extern  VTBL_ENTRY _ZTV9S19015C16[];
extern Class_Descriptor cd_S19015C6;
extern VTBL_ENTRY _ZTI8S19015C6[];
extern  VTBL_ENTRY _ZTV8S19015C6[];
extern Class_Descriptor cd_S19015C5;
extern VTBL_ENTRY _ZTI8S19015C5[];
extern  VTBL_ENTRY _ZTV8S19015C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19015C5[];
extern Class_Descriptor cd_S19015C10;
extern VTBL_ENTRY _ZTI9S19015C10[];
extern  VTBL_ENTRY _ZTV9S19015C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19015C10[];
extern Class_Descriptor cd_S19015C12;
extern VTBL_ENTRY _ZTI9S19015C12[];
extern  VTBL_ENTRY _ZTV9S19015C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19015C12[];
extern Class_Descriptor cd_S19015C17;
extern VTBL_ENTRY _ZTI9S19015C17[];
extern  VTBL_ENTRY _ZTV9S19015C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19015C17[];
extern Class_Descriptor cd_S19015C11;
extern VTBL_ENTRY _ZTI9S19015C11[];
extern  VTBL_ENTRY _ZTV9S19015C11[];
extern Class_Descriptor cd_S19015C14;
extern VTBL_ENTRY _ZTI9S19015C14[];
extern  VTBL_ENTRY _ZTV9S19015C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19015C14[];
static Base_Class bases_S19015C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7268C4,    ABISELECT(22600,17072), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7268C4,    ABISELECT(27392,20748), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S19015C5,    ABISELECT(22480,16976), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19015C6,    ABISELECT(27424,20776), //bcp->offset
    85, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S19015C5,    ABISELECT(28296,21440), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    55, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19015C11,    ABISELECT(29056,22048), //bcp->offset
    100, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S19015C10,    ABISELECT(28296,21440), //bcp->offset
    91, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    54, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S19015C8,    ABISELECT(22632,17100), //bcp->offset
    66, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19015C3,    ABISELECT(22480,16976), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    31, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S19015C6,    ABISELECT(23152,17516), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19015C8,    ABISELECT(29224,22144), //bcp->offset
    106, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S19015C5,    ABISELECT(24024,18180), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    38, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19015C10,    ABISELECT(24024,18180), //bcp->offset
    78, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    37, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19015C12,    ABISELECT(23152,17516), //bcp->offset
    69, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    36, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S7268C4,    ABISELECT(64488,49452), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19015C5,    ABISELECT(64368,49356), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    64, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19015C8,    ABISELECT(64520,49480), //bcp->offset
    132, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19015C3,    ABISELECT(64368,49356), //bcp->offset
    122, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    63, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    18, //immediately_derived
  0, 1},
  {&cd_S19015C13,    ABISELECT(29536,22396), //bcp->offset
    110, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    57, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    23, //immediately_derived
  0, 1},
  {&cd_S7268C4,    ABISELECT(24888,18848), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S19015C5,    ABISELECT(65208,50000), //bcp->offset
    148, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    70, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    22, //immediately_derived
  0, 1},
  {&cd_S19015C11,    ABISELECT(65032,49896), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S19015C14,    ABISELECT(65032,49896), //bcp->offset
    135, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    68, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    23, //immediately_derived
  0, 1},
  {&cd_S19015C2,    ABISELECT(22480,16976), //bcp->offset
    46, //bcp->virtual_function_table_offset
    17, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    30, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19015C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S19015C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19015C6,    ABISELECT(20496,15480), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19015C5,    ABISELECT(21368,16144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S19015C10,    ABISELECT(21368,16144), //bcp->offset
    26, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19015C12,    ABISELECT(20496,15480), //bcp->offset
    17, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19015C17,    ABISELECT(22232,16812), //bcp->offset
    33, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19015C11,    ABISELECT(22248,16820), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S19015C14,    ABISELECT(22248,16820), //bcp->offset
    37, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19015C1[];
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
extern void _ZN9S19015C163v10Ev();
extern void _ZN8S19015C1D1Ev();
extern void _ZN8S19015C1D0Ev();
extern void _ZN8S19015C62v1Ev();
extern void _ZN8S19015C62v2Ev();
extern void ABISELECT(_ZThn20496_N8S19015C1D1Ev,_ZThn15480_N8S19015C1D1Ev)();
extern void ABISELECT(_ZThn20496_N8S19015C1D0Ev,_ZThn15480_N8S19015C1D0Ev)();
extern void ABISELECT(_ZThn21368_N8S19015C1D1Ev,_ZThn16144_N8S19015C1D1Ev)();
extern void ABISELECT(_ZThn21368_N8S19015C1D0Ev,_ZThn16144_N8S19015C1D0Ev)();
extern void _ZN9S19015C102v5Ev();
extern void _ZN9S19015C173v11Ev();
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
extern void _ZN9S19015C142v8Ev();
extern void ABISELECT(_ZThn22248_N8S19015C1D1Ev,_ZThn16820_N8S19015C1D1Ev)();
extern void ABISELECT(_ZThn22248_N8S19015C1D0Ev,_ZThn16820_N8S19015C1D0Ev)();
extern void ABISELECT(_ZTv0_n96_N8S19015C1D1Ev,_ZTv0_n48_N8S19015C1D1Ev)();
extern void ABISELECT(_ZThn22480_N8S19015C1D1Ev,_ZThn16976_N8S19015C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N8S19015C1D0Ev,_ZTv0_n48_N8S19015C1D0Ev)();
extern void ABISELECT(_ZThn22480_N8S19015C1D0Ev,_ZThn16976_N8S19015C1D0Ev)() __attribute__((weak));
extern void _ZN8S19015C22v9Ev();
extern void _ZN8S19015C82v6Ev();
extern void _ZN8S19015C62v1Ev();
extern void _ZN8S19015C62v2Ev();
extern void ABISELECT(_ZTvn672_n96_N8S19015C1D1Ev,_ZTvn540_n48_N8S19015C1D1Ev)();
extern void ABISELECT(_ZTvn672_n96_N8S19015C1D0Ev,_ZTvn540_n48_N8S19015C1D0Ev)();
extern void ABISELECT(_ZTvn1544_n96_N8S19015C1D1Ev,_ZTvn1204_n48_N8S19015C1D1Ev)();
extern void ABISELECT(_ZTvn1544_n96_N8S19015C1D0Ev,_ZTvn1204_n48_N8S19015C1D0Ev)();
extern void _ZN9S19015C102v5Ev();
extern void _ZN8S19015C62v1Ev();
extern void _ZN8S19015C62v2Ev();
extern void ABISELECT(_ZTv0_n40_N8S19015C1D1Ev,_ZTv0_n20_N8S19015C1D1Ev)();
extern void ABISELECT(_ZThn28296_N8S19015C1D1Ev,_ZThn21440_N8S19015C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19015C1D0Ev,_ZTv0_n20_N8S19015C1D0Ev)();
extern void ABISELECT(_ZThn28296_N8S19015C1D0Ev,_ZThn21440_N8S19015C1D0Ev)() __attribute__((weak));
extern void _ZN9S19015C102v5Ev();
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
extern void _ZN8S19015C82v6Ev();
extern void _ZN9S19015C132v7Ev();
extern void ABISELECT(_ZTv0_n72_N8S19015C1D1Ev,_ZTv0_n36_N8S19015C1D1Ev)();
extern void ABISELECT(_ZThn29536_N8S19015C1D1Ev,_ZThn22396_N8S19015C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S19015C1D0Ev,_ZTv0_n36_N8S19015C1D0Ev)();
extern void ABISELECT(_ZThn29536_N8S19015C1D0Ev,_ZThn22396_N8S19015C1D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S19015C1D1Ev,_ZTv0_n28_N8S19015C1D1Ev)();
extern void ABISELECT(_ZThn64368_N8S19015C1D1Ev,_ZThn49356_N8S19015C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S19015C1D0Ev,_ZTv0_n28_N8S19015C1D0Ev)();
extern void ABISELECT(_ZThn64368_N8S19015C1D0Ev,_ZThn49356_N8S19015C1D0Ev)() __attribute__((weak));
extern void _ZN8S19015C82v6Ev();
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
extern void _ZN9S19015C142v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S19015C1D1Ev,_ZTv0_n32_N8S19015C1D1Ev)();
extern void ABISELECT(_ZThn65032_N8S19015C1D1Ev,_ZThn49896_N8S19015C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S19015C1D0Ev,_ZTv0_n32_N8S19015C1D0Ev)();
extern void ABISELECT(_ZThn65032_N8S19015C1D0Ev,_ZThn49896_N8S19015C1D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19015C1D1Ev,_ZTv0_n16_N8S19015C1D1Ev)();
extern void ABISELECT(_ZThn65208_N8S19015C1D1Ev,_ZThn50000_N8S19015C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19015C1D0Ev,_ZTv0_n16_N8S19015C1D0Ev)();
extern void ABISELECT(_ZThn65208_N8S19015C1D0Ev,_ZThn50000_N8S19015C1D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19015C1[] = {
  ABISELECT(65208,50000),
  ABISELECT(65032,49896),
  ABISELECT(64368,49356),
  ABISELECT(29536,22396),
  ABISELECT(29224,22144),
  ABISELECT(29056,22048),
  ABISELECT(28296,21440),
  ABISELECT(27424,20776),
  ABISELECT(27392,20748),
  ABISELECT(22480,16976),
  0,
  (VTBL_ENTRY)&(_ZTI8S19015C1[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
  (VTBL_ENTRY)&_ZN9S19015C163v10Ev,
  (VTBL_ENTRY)&_ZN8S19015C1D1Ev,
  (VTBL_ENTRY)&_ZN8S19015C1D0Ev,
  ABISELECT(8560,6568),
  ABISELECT(6896,5268),
  ABISELECT(8728,6664),
  ABISELECT(-20496,-15480),
  (VTBL_ENTRY)&(_ZTI8S19015C1[0]),
  (VTBL_ENTRY)&_ZN8S19015C62v1Ev,
  (VTBL_ENTRY)&_ZN8S19015C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn20496_N8S19015C1D1Ev,_ZThn15480_N8S19015C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn20496_N8S19015C1D0Ev,_ZThn15480_N8S19015C1D0Ev),
  ABISELECT(7688,5904),
  ABISELECT(6024,4604),
  ABISELECT(-21368,-16144),
  (VTBL_ENTRY)&(_ZTI8S19015C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn21368_N8S19015C1D1Ev,_ZThn16144_N8S19015C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn21368_N8S19015C1D0Ev,_ZThn16144_N8S19015C1D0Ev),
  (VTBL_ENTRY)&_ZN9S19015C102v5Ev,
  ABISELECT(5192,3964),
  ABISELECT(-22232,-16812),
  (VTBL_ENTRY)&(_ZTI8S19015C1[0]),
  (VTBL_ENTRY)&_ZN9S19015C173v11Ev,
  ABISELECT(5144,3928),
  ABISELECT(42960,33180),
  ABISELECT(-22248,-16820),
  (VTBL_ENTRY)&(_ZTI8S19015C1[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
  (VTBL_ENTRY)&_ZN9S19015C142v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn22248_N8S19015C1D1Ev,_ZThn16820_N8S19015C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn22248_N8S19015C1D0Ev,_ZThn16820_N8S19015C1D0Ev),
  ABISELECT(1544,1204),
  ABISELECT(672,540),
  ABISELECT(672,540),
  0,
  ABISELECT(152,124),
  ABISELECT(-22480,-16976),
  ABISELECT(42728,33024),
  ABISELECT(42552,32920),
  ABISELECT(41888,32380),
  ABISELECT(7056,5420),
  ABISELECT(6744,5168),
  ABISELECT(6576,5072),
  ABISELECT(5816,4464),
  ABISELECT(4944,3800),
  ABISELECT(4912,3772),
  ABISELECT(-22480,-16976),
  (VTBL_ENTRY)&(_ZTI8S19015C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S19015C1D1Ev,_ZTv0_n48_N8S19015C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S19015C1D0Ev,_ZTv0_n48_N8S19015C1D0Ev),
  (VTBL_ENTRY)&_ZN8S19015C22v9Ev,
  ABISELECT(-22632,-17100),
  (VTBL_ENTRY)&(_ZTI8S19015C1[0]),
  (VTBL_ENTRY)&_ZN8S19015C82v6Ev,
  ABISELECT(5904,4532),
  ABISELECT(4240,3232),
  ABISELECT(6072,4628),
  ABISELECT(-23152,-17516),
  (VTBL_ENTRY)&(_ZTI8S19015C1[0]),
  (VTBL_ENTRY)&_ZN8S19015C62v1Ev,
  (VTBL_ENTRY)&_ZN8S19015C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn672_n96_N8S19015C1D1Ev,_ZTvn540_n48_N8S19015C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn672_n96_N8S19015C1D0Ev,_ZTvn540_n48_N8S19015C1D0Ev),
  ABISELECT(5032,3868),
  ABISELECT(3368,2568),
  ABISELECT(-24024,-18180),
  (VTBL_ENTRY)&(_ZTI8S19015C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1544_n96_N8S19015C1D1Ev,_ZTvn1204_n48_N8S19015C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1544_n96_N8S19015C1D0Ev,_ZTvn1204_n48_N8S19015C1D0Ev),
  (VTBL_ENTRY)&_ZN9S19015C102v5Ev,
  0,
  0,
  ABISELECT(-27424,-20776),
  (VTBL_ENTRY)&(_ZTI8S19015C1[0]),
  (VTBL_ENTRY)&_ZN8S19015C62v1Ev,
  (VTBL_ENTRY)&_ZN8S19015C62v2Ev,
  0,
  ABISELECT(-28296,-21440),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-28296,-21440),
  (VTBL_ENTRY)&(_ZTI8S19015C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19015C1D1Ev,_ZTv0_n20_N8S19015C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19015C1D0Ev,_ZTv0_n20_N8S19015C1D0Ev),
  (VTBL_ENTRY)&_ZN9S19015C102v5Ev,
  0,
  0,
  ABISELECT(-29056,-22048),
  (VTBL_ENTRY)&(_ZTI8S19015C1[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
  0,
  ABISELECT(-29224,-22144),
  (VTBL_ENTRY)&(_ZTI8S19015C1[0]),
  (VTBL_ENTRY)&_ZN8S19015C82v6Ev,
  ABISELECT(-29536,-22396),
  0,
  ABISELECT(-480,-348),
  ABISELECT(-1240,-956),
  ABISELECT(-2112,-1620),
  ABISELECT(-2144,-1648),
  ABISELECT(34832,26960),
  ABISELECT(-29536,-22396),
  (VTBL_ENTRY)&(_ZTI8S19015C1[0]),
  (VTBL_ENTRY)&_ZN9S19015C132v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S19015C1D1Ev,_ZTv0_n36_N8S19015C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S19015C1D0Ev,_ZTv0_n36_N8S19015C1D0Ev),
  ABISELECT(152,124),
  ABISELECT(-64368,-49356),
  ABISELECT(-35312,-27308),
  ABISELECT(-36072,-27916),
  ABISELECT(-36944,-28580),
  ABISELECT(-36976,-28608),
  ABISELECT(-64368,-49356),
  (VTBL_ENTRY)&(_ZTI8S19015C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S19015C1D1Ev,_ZTv0_n28_N8S19015C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S19015C1D0Ev,_ZTv0_n28_N8S19015C1D0Ev),
  ABISELECT(-64520,-49480),
  (VTBL_ENTRY)&(_ZTI8S19015C1[0]),
  (VTBL_ENTRY)&_ZN8S19015C82v6Ev,
  ABISELECT(-65032,-49896),
  0,
  0,
  0,
  ABISELECT(-37640,-29148),
  ABISELECT(176,104),
  ABISELECT(-65032,-49896),
  (VTBL_ENTRY)&(_ZTI8S19015C1[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
  (VTBL_ENTRY)&_ZN9S19015C142v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S19015C1D1Ev,_ZTv0_n32_N8S19015C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S19015C1D0Ev,_ZTv0_n32_N8S19015C1D0Ev),
  ABISELECT(-65208,-50000),
  ABISELECT(-37816,-29252),
  ABISELECT(-65208,-50000),
  (VTBL_ENTRY)&(_ZTI8S19015C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19015C1D1Ev,_ZTv0_n16_N8S19015C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19015C1D0Ev,_ZTv0_n16_N8S19015C1D0Ev),
};
extern VTBL_ENTRY _ZTV8S19015C1[];
extern void _ZN8S19015C62v1Ev();
extern void _ZN8S19015C62v2Ev();
extern void _ZN9S19015C12D1Ev();
extern void _ZN9S19015C12D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C12__A1__8S19015C1[] = {
  ABISELECT(8560,6568),
  ABISELECT(6896,5268),
  ABISELECT(8728,6664),
  0,
  (VTBL_ENTRY)&(_ZTI9S19015C12[0]),
  (VTBL_ENTRY)&_ZN8S19015C62v1Ev,
  (VTBL_ENTRY)&_ZN8S19015C62v2Ev,
  (VTBL_ENTRY)&_ZN9S19015C12D1Ev,
  (VTBL_ENTRY)&_ZN9S19015C12D0Ev,
};
extern void _ZN9S19015C10D1Ev();
extern void _ZN9S19015C10D0Ev();
extern void _ZN9S19015C102v5Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C109S19015C12__A2__8S19015C1[] = {
  ABISELECT(7688,5904),
  ABISELECT(6024,4604),
  0,
  (VTBL_ENTRY)&(_ZTI9S19015C10[0]),
  (VTBL_ENTRY)&_ZN9S19015C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19015C10D0Ev,
  (VTBL_ENTRY)&_ZN9S19015C102v5Ev,
};
extern void _ZN8S19015C5D1Ev();
extern void _ZN8S19015C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C59S19015C109S19015C12__A5__8S19015C1[] = {
  ABISELECT(6024,4604),
  0,
  (VTBL_ENTRY)&(_ZTI8S19015C5[0]),
  (VTBL_ENTRY)&_ZN8S19015C5D1Ev,
  (VTBL_ENTRY)&_ZN8S19015C5D0Ev,
};
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C11__9S19015C109S19015C12__A2__8S19015C1[] = {
  0,
  0,
  ABISELECT(-7688,-5904),
  (VTBL_ENTRY)&(_ZTI9S19015C10[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
};
extern void _ZN8S19015C82v6Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C8__9S19015C12__A1__8S19015C1[] = {
  0,
  ABISELECT(-8728,-6664),
  (VTBL_ENTRY)&(_ZTI9S19015C12[0]),
  (VTBL_ENTRY)&_ZN8S19015C82v6Ev,
};
extern void ABISELECT(_ZThn872_N9S19015C12D1Ev,_ZThn664_N9S19015C12D1Ev)();
extern void ABISELECT(_ZThn872_N9S19015C12D0Ev,_ZThn664_N9S19015C12D0Ev)();
extern void _ZN9S19015C102v5Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C10__9S19015C12__A1__8S19015C1[] = {
  ABISELECT(7688,5904),
  ABISELECT(6024,4604),
  ABISELECT(-872,-664),
  (VTBL_ENTRY)&(_ZTI9S19015C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn872_N9S19015C12D1Ev,_ZThn664_N9S19015C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn872_N9S19015C12D0Ev,_ZThn664_N9S19015C12D0Ev),
  (VTBL_ENTRY)&_ZN9S19015C102v5Ev,
};
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C11__9S19015C12__A1__8S19015C1[] = {
  0,
  0,
  ABISELECT(-8560,-6568),
  (VTBL_ENTRY)&(_ZTI9S19015C12[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
};
extern void _ZN9S19015C173v11Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C17__8S19015C1[] = {
  ABISELECT(5192,3964),
  0,
  (VTBL_ENTRY)&(_ZTI9S19015C17[0]),
  (VTBL_ENTRY)&_ZN9S19015C173v11Ev,
};
extern void _ZN8S19015C62v1Ev();
extern void _ZN8S19015C62v2Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C6__9S19015C17__8S19015C1[] = {
  0,
  0,
  ABISELECT(-5192,-3964),
  (VTBL_ENTRY)&(_ZTI9S19015C17[0]),
  (VTBL_ENTRY)&_ZN8S19015C62v1Ev,
  (VTBL_ENTRY)&_ZN8S19015C62v2Ev,
};
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
extern void _ZN9S19015C142v8Ev();
extern void _ZN9S19015C14D1Ev();
extern void _ZN9S19015C14D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C14__A__8S19015C1[] = {
  ABISELECT(5144,3928),
  ABISELECT(42960,33180),
  0,
  (VTBL_ENTRY)&(_ZTI9S19015C14[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
  (VTBL_ENTRY)&_ZN9S19015C142v8Ev,
  (VTBL_ENTRY)&_ZN9S19015C14D1Ev,
  (VTBL_ENTRY)&_ZN9S19015C14D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S19015C14D1Ev,_ZTv0_n16_N9S19015C14D1Ev)();
extern void ABISELECT(_ZThn42960_N9S19015C14D1Ev,_ZThn33180_N9S19015C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19015C14D0Ev,_ZTv0_n16_N9S19015C14D0Ev)();
extern void ABISELECT(_ZThn42960_N9S19015C14D0Ev,_ZThn33180_N9S19015C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19015C5__9S19015C14__A__8S19015C1[] = {
  ABISELECT(-42960,-33180),
  ABISELECT(-37816,-29252),
  ABISELECT(-42960,-33180),
  (VTBL_ENTRY)&(_ZTI9S19015C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19015C14D1Ev,_ZTv0_n16_N9S19015C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19015C14D0Ev,_ZTv0_n16_N9S19015C14D0Ev),
};
extern void _ZN8S19015C2D1Ev();
extern void _ZN8S19015C2D0Ev();
extern void _ZN8S19015C22v9Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C2__8S19015C1[] = {
  ABISELECT(42728,33024),
  ABISELECT(42552,32920),
  ABISELECT(41888,32380),
  ABISELECT(7056,5420),
  ABISELECT(6744,5168),
  ABISELECT(6576,5072),
  ABISELECT(5816,4464),
  ABISELECT(4944,3800),
  ABISELECT(4912,3772),
  0,
  (VTBL_ENTRY)&(_ZTI8S19015C2[0]),
  (VTBL_ENTRY)&_ZN8S19015C2D1Ev,
  (VTBL_ENTRY)&_ZN8S19015C2D0Ev,
  (VTBL_ENTRY)&_ZN8S19015C22v9Ev,
};
extern void _ZN8S19015C3D1Ev();
extern void _ZN8S19015C3D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C38S19015C2__8S19015C1[] = {
  ABISELECT(6576,5072),
  ABISELECT(5816,4464),
  ABISELECT(4944,3800),
  ABISELECT(4912,3772),
  0,
  (VTBL_ENTRY)&(_ZTI8S19015C3[0]),
  (VTBL_ENTRY)&_ZN8S19015C3D1Ev,
  (VTBL_ENTRY)&_ZN8S19015C3D0Ev,
};
extern void _ZN8S19015C5D1Ev();
extern void _ZN8S19015C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C58S19015C38S19015C2__8S19015C1[] = {
  ABISELECT(4912,3772),
  0,
  (VTBL_ENTRY)&(_ZTI8S19015C5[0]),
  (VTBL_ENTRY)&_ZN8S19015C5D1Ev,
  (VTBL_ENTRY)&_ZN8S19015C5D0Ev,
};
extern void _ZN8S19015C62v1Ev();
extern void _ZN8S19015C62v2Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C6__8S19015C38S19015C2__8S19015C1[] = {
  0,
  0,
  ABISELECT(-4944,-3800),
  (VTBL_ENTRY)&(_ZTI8S19015C3[0]),
  (VTBL_ENTRY)&_ZN8S19015C62v1Ev,
  (VTBL_ENTRY)&_ZN8S19015C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S19015C3D1Ev,_ZTv0_n20_N8S19015C3D1Ev)();
extern void ABISELECT(_ZThn5816_N8S19015C3D1Ev,_ZThn4464_N8S19015C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19015C3D0Ev,_ZTv0_n20_N8S19015C3D0Ev)();
extern void ABISELECT(_ZThn5816_N8S19015C3D0Ev,_ZThn4464_N8S19015C3D0Ev)() __attribute__((weak));
extern void _ZN9S19015C102v5Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C10__8S19015C38S19015C2__8S19015C1[] = {
  0,
  ABISELECT(-5816,-4464),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-5816,-4464),
  (VTBL_ENTRY)&(_ZTI8S19015C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19015C3D1Ev,_ZTv0_n20_N8S19015C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19015C3D0Ev,_ZTv0_n20_N8S19015C3D0Ev),
  (VTBL_ENTRY)&_ZN9S19015C102v5Ev,
};
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C11__8S19015C38S19015C2__8S19015C1[] = {
  0,
  0,
  ABISELECT(-6576,-5072),
  (VTBL_ENTRY)&(_ZTI8S19015C3[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
};
extern void _ZN8S19015C62v1Ev();
extern void _ZN8S19015C62v2Ev();
extern void _ZN9S19015C12D1Ev();
extern void _ZN9S19015C12D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C128S19015C2__8S19015C1[] = {
  ABISELECT(5904,4532),
  ABISELECT(4240,3232),
  ABISELECT(6072,4628),
  0,
  (VTBL_ENTRY)&(_ZTI9S19015C12[0]),
  (VTBL_ENTRY)&_ZN8S19015C62v1Ev,
  (VTBL_ENTRY)&_ZN8S19015C62v2Ev,
  (VTBL_ENTRY)&_ZN9S19015C12D1Ev,
  (VTBL_ENTRY)&_ZN9S19015C12D0Ev,
};
extern void _ZN9S19015C10D1Ev();
extern void _ZN9S19015C10D0Ev();
extern void _ZN9S19015C102v5Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C109S19015C128S19015C2__A1__8S19015C1[] = {
  ABISELECT(5032,3868),
  ABISELECT(3368,2568),
  0,
  (VTBL_ENTRY)&(_ZTI9S19015C10[0]),
  (VTBL_ENTRY)&_ZN9S19015C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19015C10D0Ev,
  (VTBL_ENTRY)&_ZN9S19015C102v5Ev,
};
extern void _ZN8S19015C5D1Ev();
extern void _ZN8S19015C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C59S19015C109S19015C128S19015C2__A2__8S19015C1[] = {
  ABISELECT(3368,2568),
  0,
  (VTBL_ENTRY)&(_ZTI8S19015C5[0]),
  (VTBL_ENTRY)&_ZN8S19015C5D1Ev,
  (VTBL_ENTRY)&_ZN8S19015C5D0Ev,
};
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C11__9S19015C109S19015C128S19015C2__A1__8S19015C1[] = {
  0,
  0,
  ABISELECT(-5032,-3868),
  (VTBL_ENTRY)&(_ZTI9S19015C10[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
};
extern void _ZN8S19015C82v6Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C8__9S19015C128S19015C2__8S19015C1[] = {
  0,
  ABISELECT(-6072,-4628),
  (VTBL_ENTRY)&(_ZTI9S19015C12[0]),
  (VTBL_ENTRY)&_ZN8S19015C82v6Ev,
};
extern void ABISELECT(_ZThn872_N9S19015C12D1Ev,_ZThn664_N9S19015C12D1Ev)();
extern void ABISELECT(_ZThn872_N9S19015C12D0Ev,_ZThn664_N9S19015C12D0Ev)();
extern void _ZN9S19015C102v5Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C10__9S19015C128S19015C2__8S19015C1[] = {
  ABISELECT(5032,3868),
  ABISELECT(3368,2568),
  ABISELECT(-872,-664),
  (VTBL_ENTRY)&(_ZTI9S19015C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn872_N9S19015C12D1Ev,_ZThn664_N9S19015C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn872_N9S19015C12D0Ev,_ZThn664_N9S19015C12D0Ev),
  (VTBL_ENTRY)&_ZN9S19015C102v5Ev,
};
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C11__9S19015C128S19015C2__8S19015C1[] = {
  0,
  0,
  ABISELECT(-5904,-4532),
  (VTBL_ENTRY)&(_ZTI9S19015C12[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
};
extern void _ZN8S19015C62v1Ev();
extern void _ZN8S19015C62v2Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C6__8S19015C2__8S19015C1[] = {
  0,
  0,
  ABISELECT(-4944,-3800),
  (VTBL_ENTRY)&(_ZTI8S19015C2[0]),
  (VTBL_ENTRY)&_ZN8S19015C62v1Ev,
  (VTBL_ENTRY)&_ZN8S19015C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S19015C2D1Ev,_ZTv0_n20_N8S19015C2D1Ev)();
extern void ABISELECT(_ZThn5816_N8S19015C2D1Ev,_ZThn4464_N8S19015C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19015C2D0Ev,_ZTv0_n20_N8S19015C2D0Ev)();
extern void ABISELECT(_ZThn5816_N8S19015C2D0Ev,_ZThn4464_N8S19015C2D0Ev)() __attribute__((weak));
extern void _ZN9S19015C102v5Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C10__8S19015C2__8S19015C1[] = {
  0,
  ABISELECT(-5816,-4464),
  ABISELECT(760,608),
  ABISELECT(-904,-692),
  ABISELECT(-5816,-4464),
  (VTBL_ENTRY)&(_ZTI8S19015C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19015C2D1Ev,_ZTv0_n20_N8S19015C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19015C2D0Ev,_ZTv0_n20_N8S19015C2D0Ev),
  (VTBL_ENTRY)&_ZN9S19015C102v5Ev,
};
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C11__8S19015C2__8S19015C1[] = {
  0,
  0,
  ABISELECT(-6576,-5072),
  (VTBL_ENTRY)&(_ZTI8S19015C2[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
};
extern void _ZN8S19015C62v1Ev();
extern void _ZN8S19015C62v2Ev();
extern void ABISELECT(_ZThn672_N8S19015C2D1Ev,_ZThn540_N8S19015C2D1Ev)();
extern void ABISELECT(_ZThn672_N8S19015C2D0Ev,_ZThn540_N8S19015C2D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19015C12__8S19015C2__8S19015C1[] = {
  ABISELECT(5904,4532),
  ABISELECT(4240,3232),
  ABISELECT(6072,4628),
  ABISELECT(-672,-540),
  (VTBL_ENTRY)&(_ZTI8S19015C2[0]),
  (VTBL_ENTRY)&_ZN8S19015C62v1Ev,
  (VTBL_ENTRY)&_ZN8S19015C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S19015C2D1Ev,_ZThn540_N8S19015C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S19015C2D0Ev,_ZThn540_N8S19015C2D0Ev),
};
extern void _ZN8S19015C82v6Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C8__A1__8S19015C2__8S19015C1[] = {
  0,
  ABISELECT(-6744,-5168),
  (VTBL_ENTRY)&(_ZTI8S19015C2[0]),
  (VTBL_ENTRY)&_ZN8S19015C82v6Ev,
};
extern void ABISELECT(_ZThn1544_N8S19015C2D1Ev,_ZThn1204_N8S19015C2D1Ev)();
extern void ABISELECT(_ZThn1544_N8S19015C2D0Ev,_ZThn1204_N8S19015C2D0Ev)();
extern void _ZN9S19015C102v5Ev();
static  VTBL_ENTRY _tg__ZTV9S19015C109S19015C12__A1__8S19015C2__8S19015C1[] = {
  ABISELECT(5032,3868),
  ABISELECT(3368,2568),
  ABISELECT(-1544,-1204),
  (VTBL_ENTRY)&(_ZTI8S19015C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1544_N8S19015C2D1Ev,_ZThn1204_N8S19015C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1544_N8S19015C2D0Ev,_ZThn1204_N8S19015C2D0Ev),
  (VTBL_ENTRY)&_ZN9S19015C102v5Ev,
};
extern void _ZN9S19015C132v7Ev();
extern void ABISELECT(_ZTv0_n72_N8S19015C2D1Ev,_ZTv0_n36_N8S19015C2D1Ev)();
extern void ABISELECT(_ZThn7056_N8S19015C2D1Ev,_ZThn5420_N8S19015C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S19015C2D0Ev,_ZTv0_n36_N8S19015C2D0Ev)();
extern void ABISELECT(_ZThn7056_N8S19015C2D0Ev,_ZThn5420_N8S19015C2D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19015C13__8S19015C2__8S19015C1[] = {
  ABISELECT(-7056,-5420),
  0,
  ABISELECT(-480,-348),
  ABISELECT(-1240,-956),
  ABISELECT(-2112,-1620),
  ABISELECT(-2144,-1648),
  ABISELECT(34832,26960),
  ABISELECT(-7056,-5420),
  (VTBL_ENTRY)&(_ZTI8S19015C2[0]),
  (VTBL_ENTRY)&_ZN9S19015C132v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S19015C2D1Ev,_ZTv0_n36_N8S19015C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S19015C2D0Ev,_ZTv0_n36_N8S19015C2D0Ev),
};
extern void ABISELECT(_ZTv0_n56_N8S19015C2D1Ev,_ZTv0_n28_N8S19015C2D1Ev)();
extern void ABISELECT(_ZThn41888_N8S19015C2D1Ev,_ZThn32380_N8S19015C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S19015C2D0Ev,_ZTv0_n28_N8S19015C2D0Ev)();
extern void ABISELECT(_ZThn41888_N8S19015C2D0Ev,_ZThn32380_N8S19015C2D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19015C3__A1__8S19015C2__8S19015C1[] = {
  ABISELECT(152,124),
  ABISELECT(-41888,-32380),
  ABISELECT(-35312,-27308),
  ABISELECT(-36072,-27916),
  ABISELECT(-36944,-28580),
  ABISELECT(-36976,-28608),
  ABISELECT(-41888,-32380),
  (VTBL_ENTRY)&(_ZTI8S19015C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S19015C2D1Ev,_ZTv0_n28_N8S19015C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S19015C2D0Ev,_ZTv0_n28_N8S19015C2D0Ev),
};
extern void _ZN8S19015C82v6Ev();
static  VTBL_ENTRY _tg__ZTV8S19015C88S19015C3__A2__8S19015C2__8S19015C1[] = {
  ABISELECT(-42040,-32504),
  (VTBL_ENTRY)&(_ZTI8S19015C2[0]),
  (VTBL_ENTRY)&_ZN8S19015C82v6Ev,
};
extern void _ZN9S19015C112v3Ev();
extern void _ZN9S19015C112v4Ev();
extern void _ZN9S19015C142v8Ev();
extern void ABISELECT(_ZTv0_n64_N8S19015C2D1Ev,_ZTv0_n32_N8S19015C2D1Ev)();
extern void ABISELECT(_ZThn42552_N8S19015C2D1Ev,_ZThn32920_N8S19015C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S19015C2D0Ev,_ZTv0_n32_N8S19015C2D0Ev)();
extern void ABISELECT(_ZThn42552_N8S19015C2D0Ev,_ZThn32920_N8S19015C2D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19015C14__8S19015C2__8S19015C1[] = {
  ABISELECT(-42552,-32920),
  0,
  0,
  0,
  ABISELECT(-37640,-29148),
  ABISELECT(176,104),
  ABISELECT(-42552,-32920),
  (VTBL_ENTRY)&(_ZTI8S19015C2[0]),
  (VTBL_ENTRY)&_ZN9S19015C112v3Ev,
  (VTBL_ENTRY)&_ZN9S19015C112v4Ev,
  (VTBL_ENTRY)&_ZN9S19015C142v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S19015C2D1Ev,_ZTv0_n32_N8S19015C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S19015C2D0Ev,_ZTv0_n32_N8S19015C2D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S19015C2D1Ev,_ZTv0_n16_N8S19015C2D1Ev)();
extern void ABISELECT(_ZThn42728_N8S19015C2D1Ev,_ZThn33024_N8S19015C2D1