// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S674C6_nt  {
  int s674c6f0[2];
  void  mf674c6(); // _ZN9S674C6_nt7mf674c6Ev
};
//SIG(-1 S674C6_nt) C1{ m Fi[2]}


void  S674C6_nt ::mf674c6(){}

//skip512 S674C6_nt

#else // __cplusplus

Class_Descriptor cd_S674C6_nt = {  "S674C6_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C5_nt  {
  int s674c5f0;
  __tsi64 s674c5f1;
  void *s674c5f2[4];
  int s674c5f3[2];
  void *s674c5f4;
  ::S674C6_nt s674c5f5;
  void *s674c5f6[2];
  virtual  ~S674C5_nt(); // _ZN9S674C5_ntD1Ev
  virtual void  v6(); // _ZN9S674C5_nt2v6Ev
  virtual void  v7(); // _ZN9S674C5_nt2v7Ev
  virtual void  v8(); // _ZN9S674C5_nt2v8Ev
  virtual void  v9(); // _ZN9S674C5_nt2v9Ev
  virtual void  v10(); // _ZN9S674C5_nt3v10Ev
  virtual void  v11(); // _ZN9S674C5_nt3v11Ev
  virtual void  v12(); // _ZN9S674C5_nt3v12Ev
  virtual void  v13(); // _ZN9S674C5_nt3v13Ev
  virtual void  v14(); // _ZN9S674C5_nt3v14Ev
  virtual void  v15(); // _ZN9S674C5_nt3v15Ev
  virtual void  v16(); // _ZN9S674C5_nt3v16Ev
  virtual void  v17(); // _ZN9S674C5_nt3v17Ev
  virtual void  v18(); // _ZN9S674C5_nt3v18Ev
  virtual void  v19(); // _ZN9S674C5_nt3v19Ev
  virtual void  v20(); // _ZN9S674C5_nt3v20Ev
  virtual void  v21(); // _ZN9S674C5_nt3v21Ev
  virtual void  v22(); // _ZN9S674C5_nt3v22Ev
  virtual void  v23(); // _ZN9S674C5_nt3v23Ev
  virtual void  v24(); // _ZN9S674C5_nt3v24Ev
  virtual void  v25(); // _ZN9S674C5_nt3v25Ev
  virtual void  v26(); // _ZN9S674C5_nt3v26Ev
  virtual void  v27(); // _ZN9S674C5_nt3v27Ev
  virtual void  v28(); // _ZN9S674C5_nt3v28Ev
  virtual void  v29(); // _ZN9S674C5_nt3v29Ev
  virtual void  v30(); // _ZN9S674C5_nt3v30Ev
  virtual void  v31(); // _ZN9S674C5_nt3v31Ev
  virtual void  v32(); // _ZN9S674C5_nt3v32Ev
  virtual void  v33(); // _ZN9S674C5_nt3v33Ev
  virtual void  v34(); // _ZN9S674C5_nt3v34Ev
  virtual void  v35(); // _ZN9S674C5_nt3v35Ev
  virtual void  v36(); // _ZN9S674C5_nt3v36Ev
  virtual void  v37(); // _ZN9S674C5_nt3v37Ev
  virtual void  v38(); // _ZN9S674C5_nt3v38Ev
  virtual void  v39(); // _ZN9S674C5_nt3v39Ev
  virtual void  v40(); // _ZN9S674C5_nt3v40Ev
  virtual void  v41(); // _ZN9S674C5_nt3v41Ev
  virtual void  v42(); // _ZN9S674C5_nt3v42Ev
  virtual void  v43(); // _ZN9S674C5_nt3v43Ev
  virtual void  v44(); // _ZN9S674C5_nt3v44Ev
  virtual void  v45(); // _ZN9S674C5_nt3v45Ev
  virtual void  v46(); // _ZN9S674C5_nt3v46Ev
  virtual void  v47(); // _ZN9S674C5_nt3v47Ev
  virtual void  v48(); // _ZN9S674C5_nt3v48Ev
  virtual void  v49(); // _ZN9S674C5_nt3v49Ev
  virtual void  v50(); // _ZN9S674C5_nt3v50Ev
  virtual void  v51(); // _ZN9S674C5_nt3v51Ev
  virtual void  v52(); // _ZN9S674C5_nt3v52Ev
  virtual void  v53(); // _ZN9S674C5_nt3v53Ev
  virtual void  v54(); // _ZN9S674C5_nt3v54Ev
  virtual void  v55(); // _ZN9S674C5_nt3v55Ev
  virtual void  v56(); // _ZN9S674C5_nt3v56Ev
  virtual void  v57(); // _ZN9S674C5_nt3v57Ev
  virtual void  v58(); // _ZN9S674C5_nt3v58Ev
  virtual void  v59(); // _ZN9S674C5_nt3v59Ev
  virtual void  v60(); // _ZN9S674C5_nt3v60Ev
  virtual void  v61(); // _ZN9S674C5_nt3v61Ev
  virtual void  v62(); // _ZN9S674C5_nt3v62Ev
  virtual void  v63(); // _ZN9S674C5_nt3v63Ev
  virtual void  v64(); // _ZN9S674C5_nt3v64Ev
  virtual void  v65(); // _ZN9S674C5_nt3v65Ev
  virtual void  v66(); // _ZN9S674C5_nt3v66Ev
  virtual void  v67(); // _ZN9S674C5_nt3v67Ev
  virtual void  v68(); // _ZN9S674C5_nt3v68Ev
  virtual void  v69(); // _ZN9S674C5_nt3v69Ev
  S674C5_nt(); // tgen
};
//SIG(-1 S674C5_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S674C5_nt ::~S674C5_nt(){ note_dtor("S674C5_nt", this);}
void  S674C5_nt ::v6(){vfunc_called(this, "_ZN9S674C5_nt2v6Ev");}
void  S674C5_nt ::v7(){vfunc_called(this, "_ZN9S674C5_nt2v7Ev");}
void  S674C5_nt ::v8(){vfunc_called(this, "_ZN9S674C5_nt2v8Ev");}
void  S674C5_nt ::v9(){vfunc_called(this, "_ZN9S674C5_nt2v9Ev");}
void  S674C5_nt ::v10(){vfunc_called(this, "_ZN9S674C5_nt3v10Ev");}
void  S674C5_nt ::v11(){vfunc_called(this, "_ZN9S674C5_nt3v11Ev");}
void  S674C5_nt ::v12(){vfunc_called(this, "_ZN9S674C5_nt3v12Ev");}
void  S674C5_nt ::v13(){vfunc_called(this, "_ZN9S674C5_nt3v13Ev");}
void  S674C5_nt ::v14(){vfunc_called(this, "_ZN9S674C5_nt3v14Ev");}
void  S674C5_nt ::v15(){vfunc_called(this, "_ZN9S674C5_nt3v15Ev");}
void  S674C5_nt ::v16(){vfunc_called(this, "_ZN9S674C5_nt3v16Ev");}
void  S674C5_nt ::v17(){vfunc_called(this, "_ZN9S674C5_nt3v17Ev");}
void  S674C5_nt ::v18(){vfunc_called(this, "_ZN9S674C5_nt3v18Ev");}
void  S674C5_nt ::v19(){vfunc_called(this, "_ZN9S674C5_nt3v19Ev");}
void  S674C5_nt ::v20(){vfunc_called(this, "_ZN9S674C5_nt3v20Ev");}
void  S674C5_nt ::v21(){vfunc_called(this, "_ZN9S674C5_nt3v21Ev");}
void  S674C5_nt ::v22(){vfunc_called(this, "_ZN9S674C5_nt3v22Ev");}
void  S674C5_nt ::v23(){vfunc_called(this, "_ZN9S674C5_nt3v23Ev");}
void  S674C5_nt ::v24(){vfunc_called(this, "_ZN9S674C5_nt3v24Ev");}
void  S674C5_nt ::v25(){vfunc_called(this, "_ZN9S674C5_nt3v25Ev");}
void  S674C5_nt ::v26(){vfunc_called(this, "_ZN9S674C5_nt3v26Ev");}
void  S674C5_nt ::v27(){vfunc_called(this, "_ZN9S674C5_nt3v27Ev");}
void  S674C5_nt ::v28(){vfunc_called(this, "_ZN9S674C5_nt3v28Ev");}
void  S674C5_nt ::v29(){vfunc_called(this, "_ZN9S674C5_nt3v29Ev");}
void  S674C5_nt ::v30(){vfunc_called(this, "_ZN9S674C5_nt3v30Ev");}
void  S674C5_nt ::v31(){vfunc_called(this, "_ZN9S674C5_nt3v31Ev");}
void  S674C5_nt ::v32(){vfunc_called(this, "_ZN9S674C5_nt3v32Ev");}
void  S674C5_nt ::v33(){vfunc_called(this, "_ZN9S674C5_nt3v33Ev");}
void  S674C5_nt ::v34(){vfunc_called(this, "_ZN9S674C5_nt3v34Ev");}
void  S674C5_nt ::v35(){vfunc_called(this, "_ZN9S674C5_nt3v35Ev");}
void  S674C5_nt ::v36(){vfunc_called(this, "_ZN9S674C5_nt3v36Ev");}
void  S674C5_nt ::v37(){vfunc_called(this, "_ZN9S674C5_nt3v37Ev");}
void  S674C5_nt ::v38(){vfunc_called(this, "_ZN9S674C5_nt3v38Ev");}
void  S674C5_nt ::v39(){vfunc_called(this, "_ZN9S674C5_nt3v39Ev");}
void  S674C5_nt ::v40(){vfunc_called(this, "_ZN9S674C5_nt3v40Ev");}
void  S674C5_nt ::v41(){vfunc_called(this, "_ZN9S674C5_nt3v41Ev");}
void  S674C5_nt ::v42(){vfunc_called(this, "_ZN9S674C5_nt3v42Ev");}
void  S674C5_nt ::v43(){vfunc_called(this, "_ZN9S674C5_nt3v43Ev");}
void  S674C5_nt ::v44(){vfunc_called(this, "_ZN9S674C5_nt3v44Ev");}
void  S674C5_nt ::v45(){vfunc_called(this, "_ZN9S674C5_nt3v45Ev");}
void  S674C5_nt ::v46(){vfunc_called(this, "_ZN9S674C5_nt3v46Ev");}
void  S674C5_nt ::v47(){vfunc_called(this, "_ZN9S674C5_nt3v47Ev");}
void  S674C5_nt ::v48(){vfunc_called(this, "_ZN9S674C5_nt3v48Ev");}
void  S674C5_nt ::v49(){vfunc_called(this, "_ZN9S674C5_nt3v49Ev");}
void  S674C5_nt ::v50(){vfunc_called(this, "_ZN9S674C5_nt3v50Ev");}
void  S674C5_nt ::v51(){vfunc_called(this, "_ZN9S674C5_nt3v51Ev");}
void  S674C5_nt ::v52(){vfunc_called(this, "_ZN9S674C5_nt3v52Ev");}
void  S674C5_nt ::v53(){vfunc_called(this, "_ZN9S674C5_nt3v53Ev");}
void  S674C5_nt ::v54(){vfunc_called(this, "_ZN9S674C5_nt3v54Ev");}
void  S674C5_nt ::v55(){vfunc_called(this, "_ZN9S674C5_nt3v55Ev");}
void  S674C5_nt ::v56(){vfunc_called(this, "_ZN9S674C5_nt3v56Ev");}
void  S674C5_nt ::v57(){vfunc_called(this, "_ZN9S674C5_nt3v57Ev");}
void  S674C5_nt ::v58(){vfunc_called(this, "_ZN9S674C5_nt3v58Ev");}
void  S674C5_nt ::v59(){vfunc_called(this, "_ZN9S674C5_nt3v59Ev");}
void  S674C5_nt ::v60(){vfunc_called(this, "_ZN9S674C5_nt3v60Ev");}
void  S674C5_nt ::v61(){vfunc_called(this, "_ZN9S674C5_nt3v61Ev");}
void  S674C5_nt ::v62(){vfunc_called(this, "_ZN9S674C5_nt3v62Ev");}
void  S674C5_nt ::v63(){vfunc_called(this, "_ZN9S674C5_nt3v63Ev");}
void  S674C5_nt ::v64(){vfunc_called(this, "_ZN9S674C5_nt3v64Ev");}
void  S674C5_nt ::v65(){vfunc_called(this, "_ZN9S674C5_nt3v65Ev");}
void  S674C5_nt ::v66(){vfunc_called(this, "_ZN9S674C5_nt3v66Ev");}
void  S674C5_nt ::v67(){vfunc_called(this, "_ZN9S674C5_nt3v67Ev");}
void  S674C5_nt ::v68(){vfunc_called(this, "_ZN9S674C5_nt3v68Ev");}
void  S674C5_nt ::v69(){vfunc_called(this, "_ZN9S674C5_nt3v69Ev");}
S674C5_nt ::S674C5_nt(){ note_ctor("S674C5_nt", this);} // tgen

//skip512 S674C5_nt

#else // __cplusplus

extern void _ZN9S674C5_ntC1Ev();
extern void _ZN9S674C5_ntD1Ev();
Name_Map name_map_S674C5_nt[] = {
  NSPAIR(_ZN9S674C5_ntC1Ev),
  NSPAIR(_ZN9S674C5_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S674C5_nt[];
extern void _ZN9S674C5_ntD1Ev();
extern void _ZN9S674C5_ntD0Ev();
extern void _ZN9S674C5_nt2v6Ev();
extern void _ZN9S674C5_nt2v7Ev();
extern void _ZN9S674C5_nt2v8Ev();
extern void _ZN9S674C5_nt2v9Ev();
extern void _ZN9S674C5_nt3v10Ev();
extern void _ZN9S674C5_nt3v11Ev();
extern void _ZN9S674C5_nt3v12Ev();
extern void _ZN9S674C5_nt3v13Ev();
extern void _ZN9S674C5_nt3v14Ev();
extern void _ZN9S674C5_nt3v15Ev();
extern void _ZN9S674C5_nt3v16Ev();
extern void _ZN9S674C5_nt3v17Ev();
extern void _ZN9S674C5_nt3v18Ev();
extern void _ZN9S674C5_nt3v19Ev();
extern void _ZN9S674C5_nt3v20Ev();
extern void _ZN9S674C5_nt3v21Ev();
extern void _ZN9S674C5_nt3v22Ev();
extern void _ZN9S674C5_nt3v23Ev();
extern void _ZN9S674C5_nt3v24Ev();
extern void _ZN9S674C5_nt3v25Ev();
extern void _ZN9S674C5_nt3v26Ev();
extern void _ZN9S674C5_nt3v27Ev();
extern void _ZN9S674C5_nt3v28Ev();
extern void _ZN9S674C5_nt3v29Ev();
extern void _ZN9S674C5_nt3v30Ev();
extern void _ZN9S674C5_nt3v31Ev();
extern void _ZN9S674C5_nt3v32Ev();
extern void _ZN9S674C5_nt3v33Ev();
extern void _ZN9S674C5_nt3v34Ev();
extern void _ZN9S674C5_nt3v35Ev();
extern void _ZN9S674C5_nt3v36Ev();
extern void _ZN9S674C5_nt3v37Ev();
extern void _ZN9S674C5_nt3v38Ev();
extern void _ZN9S674C5_nt3v39Ev();
extern void _ZN9S674C5_nt3v40Ev();
extern void _ZN9S674C5_nt3v41Ev();
extern void _ZN9S674C5_nt3v42Ev();
extern void _ZN9S674C5_nt3v43Ev();
extern void _ZN9S674C5_nt3v44Ev();
extern void _ZN9S674C5_nt3v45Ev();
extern void _ZN9S674C5_nt3v46Ev();
extern void _ZN9S674C5_nt3v47Ev();
extern void _ZN9S674C5_nt3v48Ev();
extern void _ZN9S674C5_nt3v49Ev();
extern void _ZN9S674C5_nt3v50Ev();
extern void _ZN9S674C5_nt3v51Ev();
extern void _ZN9S674C5_nt3v52Ev();
extern void _ZN9S674C5_nt3v53Ev();
extern void _ZN9S674C5_nt3v54Ev();
extern void _ZN9S674C5_nt3v55Ev();
extern void _ZN9S674C5_nt3v56Ev();
extern void _ZN9S674C5_nt3v57Ev();
extern void _ZN9S674C5_nt3v58Ev();
extern void _ZN9S674C5_nt3v59Ev();
extern void _ZN9S674C5_nt3v60Ev();
extern void _ZN9S674C5_nt3v61Ev();
extern void _ZN9S674C5_nt3v62Ev();
extern void _ZN9S674C5_nt3v63Ev();
extern void _ZN9S674C5_nt3v64Ev();
extern void _ZN9S674C5_nt3v65Ev();
extern void _ZN9S674C5_nt3v66Ev();
extern void _ZN9S674C5_nt3v67Ev();
extern void _ZN9S674C5_nt3v68Ev();
extern void _ZN9S674C5_nt3v69Ev();
static  VTBL_ENTRY vtc_S674C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S674C5_nt[0]),
  (VTBL_ENTRY)&_ZN9S674C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S674C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v69Ev,
};
extern VTBL_ENTRY _ZTI9S674C5_nt[];
VTBL_ENTRY *P__ZTI9S674C5_nt = _ZTI9S674C5_nt; 
extern  VTBL_ENTRY _ZTV9S674C5_nt[];
Class_Descriptor cd_S674C5_nt = {  "S674C5_nt", // class name
  0,0,//no base classes
  &(vtc_S674C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI9S674C5_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S674C5_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C4_nt  : S674C5_nt {
  virtual  ~S674C4_nt(); // _ZN9S674C4_ntD1Ev
  virtual void  v70(); // _ZN9S674C4_nt3v70Ev
  virtual void  v71(); // _ZN9S674C4_nt3v71Ev
  S674C4_nt(); // tgen
};
//SIG(-1 S674C4_nt) C1{ BC2{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2}


 S674C4_nt ::~S674C4_nt(){ note_dtor("S674C4_nt", this);}
void  S674C4_nt ::v70(){vfunc_called(this, "_ZN9S674C4_nt3v70Ev");}
void  S674C4_nt ::v71(){vfunc_called(this, "_ZN9S674C4_nt3v71Ev");}
S674C4_nt ::S674C4_nt(){ note_ctor("S674C4_nt", this);} // tgen

//skip512 S674C4_nt

#else // __cplusplus

extern void _ZN9S674C4_ntC1Ev();
extern void _ZN9S674C4_ntD1Ev();
Name_Map name_map_S674C4_nt[] = {
  NSPAIR(_ZN9S674C4_ntC1Ev),
  NSPAIR(_ZN9S674C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S674C5_nt;
extern VTBL_ENTRY _ZTI9S674C5_nt[];
extern  VTBL_ENTRY _ZTV9S674C5_nt[];
static Base_Class bases_S674C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S674C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S674C4_nt[];
extern void _ZN9S674C4_ntD1Ev();
extern void _ZN9S674C4_ntD0Ev();
extern void _ZN9S674C5_nt2v6Ev();
extern void _ZN9S674C5_nt2v7Ev();
extern void _ZN9S674C5_nt2v8Ev();
extern void _ZN9S674C5_nt2v9Ev();
extern void _ZN9S674C5_nt3v10Ev();
extern void _ZN9S674C5_nt3v11Ev();
extern void _ZN9S674C5_nt3v12Ev();
extern void _ZN9S674C5_nt3v13Ev();
extern void _ZN9S674C5_nt3v14Ev();
extern void _ZN9S674C5_nt3v15Ev();
extern void _ZN9S674C5_nt3v16Ev();
extern void _ZN9S674C5_nt3v17Ev();
extern void _ZN9S674C5_nt3v18Ev();
extern void _ZN9S674C5_nt3v19Ev();
extern void _ZN9S674C5_nt3v20Ev();
extern void _ZN9S674C5_nt3v21Ev();
extern void _ZN9S674C5_nt3v22Ev();
extern void _ZN9S674C5_nt3v23Ev();
extern void _ZN9S674C5_nt3v24Ev();
extern void _ZN9S674C5_nt3v25Ev();
extern void _ZN9S674C5_nt3v26Ev();
extern void _ZN9S674C5_nt3v27Ev();
extern void _ZN9S674C5_nt3v28Ev();
extern void _ZN9S674C5_nt3v29Ev();
extern void _ZN9S674C5_nt3v30Ev();
extern void _ZN9S674C5_nt3v31Ev();
extern void _ZN9S674C5_nt3v32Ev();
extern void _ZN9S674C5_nt3v33Ev();
extern void _ZN9S674C5_nt3v34Ev();
extern void _ZN9S674C5_nt3v35Ev();
extern void _ZN9S674C5_nt3v36Ev();
extern void _ZN9S674C5_nt3v37Ev();
extern void _ZN9S674C5_nt3v38Ev();
extern void _ZN9S674C5_nt3v39Ev();
extern void _ZN9S674C5_nt3v40Ev();
extern void _ZN9S674C5_nt3v41Ev();
extern void _ZN9S674C5_nt3v42Ev();
extern void _ZN9S674C5_nt3v43Ev();
extern void _ZN9S674C5_nt3v44Ev();
extern void _ZN9S674C5_nt3v45Ev();
extern void _ZN9S674C5_nt3v46Ev();
extern void _ZN9S674C5_nt3v47Ev();
extern void _ZN9S674C5_nt3v48Ev();
extern void _ZN9S674C5_nt3v49Ev();
extern void _ZN9S674C5_nt3v50Ev();
extern void _ZN9S674C5_nt3v51Ev();
extern void _ZN9S674C5_nt3v52Ev();
extern void _ZN9S674C5_nt3v53Ev();
extern void _ZN9S674C5_nt3v54Ev();
extern void _ZN9S674C5_nt3v55Ev();
extern void _ZN9S674C5_nt3v56Ev();
extern void _ZN9S674C5_nt3v57Ev();
extern void _ZN9S674C5_nt3v58Ev();
extern void _ZN9S674C5_nt3v59Ev();
extern void _ZN9S674C5_nt3v60Ev();
extern void _ZN9S674C5_nt3v61Ev();
extern void _ZN9S674C5_nt3v62Ev();
extern void _ZN9S674C5_nt3v63Ev();
extern void _ZN9S674C5_nt3v64Ev();
extern void _ZN9S674C5_nt3v65Ev();
extern void _ZN9S674C5_nt3v66Ev();
extern void _ZN9S674C5_nt3v67Ev();
extern void _ZN9S674C5_nt3v68Ev();
extern void _ZN9S674C5_nt3v69Ev();
extern void _ZN9S674C4_nt3v70Ev();
extern void _ZN9S674C4_nt3v71Ev();
static  VTBL_ENTRY vtc_S674C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S674C4_nt[0]),
  (VTBL_ENTRY)&_ZN9S674C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S674C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S674C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S674C4_nt3v71Ev,
};
extern VTBL_ENTRY _ZTI9S674C4_nt[];
VTBL_ENTRY *P__ZTI9S674C4_nt = _ZTI9S674C4_nt; 
extern  VTBL_ENTRY _ZTV9S674C4_nt[];
Class_Descriptor cd_S674C4_nt = {  "S674C4_nt", // class name
  bases_S674C4_nt, 1,
  &(vtc_S674C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI9S674C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S674C4_nt),70, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C7_nt  {
  int s674c7f0[4];
  char s674c7f1[9];
  void  mf674c7(); // _ZN9S674C7_nt7mf674c7Ev
};
//SIG(-1 S674C7_nt) C1{ m Fi[4] Fc[9]}


void  S674C7_nt ::mf674c7(){}

//skip512 S674C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C10_nt  {
  void *s674c10f0;
  int s674c10f1[2];
  void  mf674c10(); // _ZN10S674C10_nt8mf674c10Ev
};
//SIG(-1 S674C10_nt) C1{ m Fp Fi[2]}


void  S674C10_nt ::mf674c10(){}

//skip512 S674C10_nt

#else // __cplusplus

Class_Descriptor cd_S674C10_nt = {  "S674C10_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C9_nt  : S674C10_nt {
};
//SIG(-1 S674C9_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S674C9_nt

#else // __cplusplus

extern Class_Descriptor cd_S674C10_nt;
static Base_Class bases_S674C9_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S674C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S674C9_nt = {  "S674C9_nt", // class name
  bases_S674C9_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C8_nt  : S674C9_nt {
};
//SIG(-1 S674C8_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S674C8_nt

#else // __cplusplus

extern Class_Descriptor cd_S674C10_nt;
extern Class_Descriptor cd_S674C9_nt;
static Base_Class bases_S674C8_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S674C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S674C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C14  : S674C10_nt {
};
//SIG(-1 S674C14) C1{ BC2{ m Fp Fi[2]}}



static void Test_S674C14()
{
  extern Class_Descriptor cd_S674C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S674C14, buf);
    S674C14 &lv = *(new (buf) S674C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S674C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S674C14)");
    check_base_class_offset(lv, (S674C10_nt*), 0, "S674C14");
    test_class_info(&lv, &cd_S674C14);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS674C14(Test_S674C14, "S674C14", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S674C10_nt;
static Base_Class bases_S674C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S674C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S674C14 = {  "S674C14", // class name
  bases_S674C14, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C13  : S674C14 {
};
//SIG(-1 S674C13) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S674C13()
{
  extern Class_Descriptor cd_S674C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S674C13, buf);
    S674C13 &lv = *(new (buf) S674C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S674C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S674C13)");
    check_base_class_offset(lv, (S674C10_nt*)(S674C14*), 0, "S674C13");
    check_base_class_offset(lv, (S674C14*), 0, "S674C13");
    test_class_info(&lv, &cd_S674C13);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS674C13(Test_S674C13, "S674C13", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S674C10_nt;
extern Class_Descriptor cd_S674C14;
static Base_Class bases_S674C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S674C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S674C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S674C13 = {  "S674C13", // class name
  bases_S674C13, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C18  : S674C10_nt {
};
//SIG(-1 S674C18) C1{ BC2{ m Fp Fi[2]}}



static void Test_S674C18()
{
  extern Class_Descriptor cd_S674C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S674C18, buf);
    S674C18 &lv = *(new (buf) S674C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S674C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S674C18)");
    check_base_class_offset(lv, (S674C10_nt*), 0, "S674C18");
    test_class_info(&lv, &cd_S674C18);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS674C18(Test_S674C18, "S674C18", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S674C10_nt;
static Base_Class bases_S674C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S674C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S674C18 = {  "S674C18", // class name
  bases_S674C18, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C17  : S674C18 {
};
//SIG(-1 S674C17) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S674C17()
{
  extern Class_Descriptor cd_S674C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S674C17, buf);
    S674C17 &lv = *(new (buf) S674C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S674C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S674C17)");
    check_base_class_offset(lv, (S674C10_nt*)(S674C18*), 0, "S674C17");
    check_base_class_offset(lv, (S674C18*), 0, "S674C17");
    test_class_info(&lv, &cd_S674C17);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS674C17(Test_S674C17, "S674C17", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S674C10_nt;
extern Class_Descriptor cd_S674C18;
static Base_Class bases_S674C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S674C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S674C18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S674C17 = {  "S674C17", // class name
  bases_S674C17, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C19_nt  {
  void *s674c19f0;
  ::S674C6_nt s674c19f1;
  void  mf674c19(); // _ZN10S674C19_nt8mf674c19Ev
};
//SIG(-1 S674C19_nt) C1{ m Fp FC2{ m Fi[2]}}


void  S674C19_nt ::mf674c19(){}

//skip512 S674C19_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C3_nt  : S674C4_nt {
  ::S674C7_nt s674c3f0;
  int s674c3f1;
  unsigned int s674c3f2:1;
  unsigned int s674c3f3:1;
  unsigned int s674c3f4:1;
  unsigned int s674c3f5:1;
  ::S674C8_nt s674c3f6;
  ::S674C8_nt s674c3f7;
  void *s674c3f8;
  ::S674C13 s674c3f9;
  ::S674C13 s674c3f10;
  ::S674C13 s674c3f11;
  ::S674C17 s674c3f12;
  char s674c3f13;
  int s674c3f14;
  void *s674c3f15;
  ::S674C6_nt s674c3f16;
  ::S674C6_nt s674c3f17;
  ::S674C6_nt s674c3f18;
  ::S674C6_nt s674c3f19;
  ::S674C6_nt s674c3f20;
  ::S674C6_nt s674c3f21;
  ::S674C19_nt s674c3f22;
  ::S674C19_nt s674c3f23;
  ::S674C19_nt s674c3f24;
  ::S674C19_nt s674c3f25;
  ::S674C19_nt s674c3f26;
  ::S674C19_nt s674c3f27;
  ::S674C19_nt s674c3f28;
  ::S674C19_nt s674c3f29;
  ::S674C19_nt s674c3f30;
  ::S674C19_nt s674c3f31;
  virtual  ~S674C3_nt(); // _ZN9S674C3_ntD1Ev
  virtual void  v72(); // _ZN9S674C3_nt3v72Ev
  virtual void  v73(); // _ZN9S674C3_nt3v73Ev
  virtual void  v74(); // _ZN9S674C3_nt3v74Ev
  virtual void  v75(); // _ZN9S674C3_nt3v75Ev
  virtual void  v76(); // _ZN9S674C3_nt3v76Ev
  virtual void  v77(); // _ZN9S674C3_nt3v77Ev
  virtual void  v78(); // _ZN9S674C3_nt3v78Ev
  virtual void  v79(); // _ZN9S674C3_nt3v79Ev
  virtual void  v80(); // _ZN9S674C3_nt3v80Ev
  virtual void  v81(); // _ZN9S674C3_nt3v81Ev
  virtual void  v82(); // _ZN9S674C3_nt3v82Ev
  virtual void  v83(); // _ZN9S674C3_nt3v83Ev
  virtual void  v84(); // _ZN9S674C3_nt3v84Ev
  virtual void  v85(); // _ZN9S674C3_nt3v85Ev
  virtual void  v86(); // _ZN9S674C3_nt3v86Ev
  virtual void  v87(); // _ZN9S674C3_nt3v87Ev
  virtual void  v88(); // _ZN9S674C3_nt3v88Ev
  virtual void  v89(); // _ZN9S674C3_nt3v89Ev
  virtual void  v90(); // _ZN9S674C3_nt3v90Ev
  virtual void  v91(); // _ZN9S674C3_nt3v91Ev
  virtual void  v92(); // _ZN9S674C3_nt3v92Ev
  virtual void  v93(); // _ZN9S674C3_nt3v93Ev
  virtual void  v94(); // _ZN9S674C3_nt3v94Ev
  virtual void  v95(); // _ZN9S674C3_nt3v95Ev
  virtual void  v96(); // _ZN9S674C3_nt3v96Ev
  virtual void  v97(); // _ZN9S674C3_nt3v97Ev
  virtual void  v98(); // _ZN9S674C3_nt3v98Ev
  virtual void  v99(); // _ZN9S674C3_nt3v99Ev
  virtual void  v100(); // _ZN9S674C3_nt4v100Ev
  virtual void  v101(); // _ZN9S674C3_nt4v101Ev
  virtual void  v102(); // _ZN9S674C3_nt4v102Ev
  virtual void  v103(); // _ZN9S674C3_nt4v103Ev
  virtual void  v104(); // _ZN9S674C3_nt4v104Ev
  virtual void  v105(); // _ZN9S674C3_nt4v105Ev
  virtual void  v106(); // _ZN9S674C3_nt4v106Ev
  virtual void  v107(); // _ZN9S674C3_nt4v107Ev
  virtual void  v108(); // _ZN9S674C3_nt4v108Ev
  virtual void  v109(); // _ZN9S674C3_nt4v109Ev
  virtual void  v110(); // _ZN9S674C3_nt4v110Ev
  virtual void  v111(); // _ZN9S674C3_nt4v111Ev
  virtual void  v112(); // _ZN9S674C3_nt4v112Ev
  virtual void  v113(); // _ZN9S674C3_nt4v113Ev
  virtual void  v114(); // _ZN9S674C3_nt4v114Ev
  virtual void  v115(); // _ZN9S674C3_nt4v115Ev
  virtual void  v116(); // _ZN9S674C3_nt4v116Ev
  virtual void  v117(); // _ZN9S674C3_nt4v117Ev
  virtual void  v118(); // _ZN9S674C3_nt4v118Ev
  virtual void  v119(); // _ZN9S674C3_nt4v119Ev
  virtual void  v120(); // _ZN9S674C3_nt4v120Ev
  virtual void  v121(); // _ZN9S674C3_nt4v121Ev
  virtual void  v122(); // _ZN9S674C3_nt4v122Ev
  virtual void  v123(); // _ZN9S674C3_nt4v123Ev
  virtual void  v124(); // _ZN9S674C3_nt4v124Ev
  virtual void  v125(); // _ZN9S674C3_nt4v125Ev
  virtual void  v126(); // _ZN9S674C3_nt4v126Ev
  virtual void  v127(); // _ZN9S674C3_nt4v127Ev
  virtual void  v128(); // _ZN9S674C3_nt4v128Ev
  virtual void  v129(); // _ZN9S674C3_nt4v129Ev
  virtual void  v130(); // _ZN9S674C3_nt4v130Ev
  virtual void  v131(); // _ZN9S674C3_nt4v131Ev
  virtual void  v132(); // _ZN9S674C3_nt4v132Ev
  virtual void  v133(); // _ZN9S674C3_nt4v133Ev
  virtual void  v134(); // _ZN9S674C3_nt4v134Ev
  virtual void  v135(); // _ZN9S674C3_nt4v135Ev
  virtual void  v136(); // _ZN9S674C3_nt4v136Ev
  virtual void  v137(); // _ZN9S674C3_nt4v137Ev
  virtual void  v138(); // _ZN9S674C3_nt4v138Ev
  virtual void  v139(); // _ZN9S674C3_nt4v139Ev
  virtual void  v140(); // _ZN9S674C3_nt4v140Ev
  virtual void  v141(); // _ZN9S674C3_nt4v141Ev
  virtual void  v142(); // _ZN9S674C3_nt4v142Ev
  virtual void  v143(); // _ZN9S674C3_nt4v143Ev
  virtual void  v144(); // _ZN9S674C3_nt4v144Ev
  virtual void  v145(); // _ZN9S674C3_nt4v145Ev
  virtual void  v146(); // _ZN9S674C3_nt4v146Ev
  virtual void  v147(); // _ZN9S674C3_nt4v147Ev
  S674C3_nt(); // tgen
};
//SIG(-1 S674C3_nt) C1{ BC2{ BC3{ vd v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v141 v142} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 FC5{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC6 Fp FC9{ BC10{ BC8}} FC9 FC9 FC11{ BC12{ BC8}} Fc Fi Fp FC4 FC4 FC4 FC4 FC4 FC4 FC13{ m Fp FC4} FC13 FC13 FC13 FC13 FC13 FC13 FC13 FC13 FC13}


 S674C3_nt ::~S674C3_nt(){ note_dtor("S674C3_nt", this);}
void  S674C3_nt ::v72(){vfunc_called(this, "_ZN9S674C3_nt3v72Ev");}
void  S674C3_nt ::v73(){vfunc_called(this, "_ZN9S674C3_nt3v73Ev");}
void  S674C3_nt ::v74(){vfunc_called(this, "_ZN9S674C3_nt3v74Ev");}
void  S674C3_nt ::v75(){vfunc_called(this, "_ZN9S674C3_nt3v75Ev");}
void  S674C3_nt ::v76(){vfunc_called(this, "_ZN9S674C3_nt3v76Ev");}
void  S674C3_nt ::v77(){vfunc_called(this, "_ZN9S674C3_nt3v77Ev");}
void  S674C3_nt ::v78(){vfunc_called(this, "_ZN9S674C3_nt3v78Ev");}
void  S674C3_nt ::v79(){vfunc_called(this, "_ZN9S674C3_nt3v79Ev");}
void  S674C3_nt ::v80(){vfunc_called(this, "_ZN9S674C3_nt3v80Ev");}
void  S674C3_nt ::v81(){vfunc_called(this, "_ZN9S674C3_nt3v81Ev");}
void  S674C3_nt ::v82(){vfunc_called(this, "_ZN9S674C3_nt3v82Ev");}
void  S674C3_nt ::v83(){vfunc_called(this, "_ZN9S674C3_nt3v83Ev");}
void  S674C3_nt ::v84(){vfunc_called(this, "_ZN9S674C3_nt3v84Ev");}
void  S674C3_nt ::v85(){vfunc_called(this, "_ZN9S674C3_nt3v85Ev");}
void  S674C3_nt ::v86(){vfunc_called(this, "_ZN9S674C3_nt3v86Ev");}
void  S674C3_nt ::v87(){vfunc_called(this, "_ZN9S674C3_nt3v87Ev");}
void  S674C3_nt ::v88(){vfunc_called(this, "_ZN9S674C3_nt3v88Ev");}
void  S674C3_nt ::v89(){vfunc_called(this, "_ZN9S674C3_nt3v89Ev");}
void  S674C3_nt ::v90(){vfunc_called(this, "_ZN9S674C3_nt3v90Ev");}
void  S674C3_nt ::v91(){vfunc_called(this, "_ZN9S674C3_nt3v91Ev");}
void  S674C3_nt ::v92(){vfunc_called(this, "_ZN9S674C3_nt3v92Ev");}
void  S674C3_nt ::v93(){vfunc_called(this, "_ZN9S674C3_nt3v93Ev");}
void  S674C3_nt ::v94(){vfunc_called(this, "_ZN9S674C3_nt3v94Ev");}
void  S674C3_nt ::v95(){vfunc_called(this, "_ZN9S674C3_nt3v95Ev");}
void  S674C3_nt ::v96(){vfunc_called(this, "_ZN9S674C3_nt3v96Ev");}
void  S674C3_nt ::v97(){vfunc_called(this, "_ZN9S674C3_nt3v97Ev");}
void  S674C3_nt ::v98(){vfunc_called(this, "_ZN9S674C3_nt3v98Ev");}
void  S674C3_nt ::v99(){vfunc_called(this, "_ZN9S674C3_nt3v99Ev");}
void  S674C3_nt ::v100(){vfunc_called(this, "_ZN9S674C3_nt4v100Ev");}
void  S674C3_nt ::v101(){vfunc_called(this, "_ZN9S674C3_nt4v101Ev");}
void  S674C3_nt ::v102(){vfunc_called(this, "_ZN9S674C3_nt4v102Ev");}
void  S674C3_nt ::v103(){vfunc_called(this, "_ZN9S674C3_nt4v103Ev");}
void  S674C3_nt ::v104(){vfunc_called(this, "_ZN9S674C3_nt4v104Ev");}
void  S674C3_nt ::v105(){vfunc_called(this, "_ZN9S674C3_nt4v105Ev");}
void  S674C3_nt ::v106(){vfunc_called(this, "_ZN9S674C3_nt4v106Ev");}
void  S674C3_nt ::v107(){vfunc_called(this, "_ZN9S674C3_nt4v107Ev");}
void  S674C3_nt ::v108(){vfunc_called(this, "_ZN9S674C3_nt4v108Ev");}
void  S674C3_nt ::v109(){vfunc_called(this, "_ZN9S674C3_nt4v109Ev");}
void  S674C3_nt ::v110(){vfunc_called(this, "_ZN9S674C3_nt4v110Ev");}
void  S674C3_nt ::v111(){vfunc_called(this, "_ZN9S674C3_nt4v111Ev");}
void  S674C3_nt ::v112(){vfunc_called(this, "_ZN9S674C3_nt4v112Ev");}
void  S674C3_nt ::v113(){vfunc_called(this, "_ZN9S674C3_nt4v113Ev");}
void  S674C3_nt ::v114(){vfunc_called(this, "_ZN9S674C3_nt4v114Ev");}
void  S674C3_nt ::v115(){vfunc_called(this, "_ZN9S674C3_nt4v115Ev");}
void  S674C3_nt ::v116(){vfunc_called(this, "_ZN9S674C3_nt4v116Ev");}
void  S674C3_nt ::v117(){vfunc_called(this, "_ZN9S674C3_nt4v117Ev");}
void  S674C3_nt ::v118(){vfunc_called(this, "_ZN9S674C3_nt4v118Ev");}
void  S674C3_nt ::v119(){vfunc_called(this, "_ZN9S674C3_nt4v119Ev");}
void  S674C3_nt ::v120(){vfunc_called(this, "_ZN9S674C3_nt4v120Ev");}
void  S674C3_nt ::v121(){vfunc_called(this, "_ZN9S674C3_nt4v121Ev");}
void  S674C3_nt ::v122(){vfunc_called(this, "_ZN9S674C3_nt4v122Ev");}
void  S674C3_nt ::v123(){vfunc_called(this, "_ZN9S674C3_nt4v123Ev");}
void  S674C3_nt ::v124(){vfunc_called(this, "_ZN9S674C3_nt4v124Ev");}
void  S674C3_nt ::v125(){vfunc_called(this, "_ZN9S674C3_nt4v125Ev");}
void  S674C3_nt ::v126(){vfunc_called(this, "_ZN9S674C3_nt4v126Ev");}
void  S674C3_nt ::v127(){vfunc_called(this, "_ZN9S674C3_nt4v127Ev");}
void  S674C3_nt ::v128(){vfunc_called(this, "_ZN9S674C3_nt4v128Ev");}
void  S674C3_nt ::v129(){vfunc_called(this, "_ZN9S674C3_nt4v129Ev");}
void  S674C3_nt ::v130(){vfunc_called(this, "_ZN9S674C3_nt4v130Ev");}
void  S674C3_nt ::v131(){vfunc_called(this, "_ZN9S674C3_nt4v131Ev");}
void  S674C3_nt ::v132(){vfunc_called(this, "_ZN9S674C3_nt4v132Ev");}
void  S674C3_nt ::v133(){vfunc_called(this, "_ZN9S674C3_nt4v133Ev");}
void  S674C3_nt ::v134(){vfunc_called(this, "_ZN9S674C3_nt4v134Ev");}
void  S674C3_nt ::v135(){vfunc_called(this, "_ZN9S674C3_nt4v135Ev");}
void  S674C3_nt ::v136(){vfunc_called(this, "_ZN9S674C3_nt4v136Ev");}
void  S674C3_nt ::v137(){vfunc_called(this, "_ZN9S674C3_nt4v137Ev");}
void  S674C3_nt ::v138(){vfunc_called(this, "_ZN9S674C3_nt4v138Ev");}
void  S674C3_nt ::v139(){vfunc_called(this, "_ZN9S674C3_nt4v139Ev");}
void  S674C3_nt ::v140(){vfunc_called(this, "_ZN9S674C3_nt4v140Ev");}
void  S674C3_nt ::v141(){vfunc_called(this, "_ZN9S674C3_nt4v141Ev");}
void  S674C3_nt ::v142(){vfunc_called(this, "_ZN9S674C3_nt4v142Ev");}
void  S674C3_nt ::v143(){vfunc_called(this, "_ZN9S674C3_nt4v143Ev");}
void  S674C3_nt ::v144(){vfunc_called(this, "_ZN9S674C3_nt4v144Ev");}
void  S674C3_nt ::v145(){vfunc_called(this, "_ZN9S674C3_nt4v145Ev");}
void  S674C3_nt ::v146(){vfunc_called(this, "_ZN9S674C3_nt4v146Ev");}
void  S674C3_nt ::v147(){vfunc_called(this, "_ZN9S674C3_nt4v147Ev");}
S674C3_nt ::S674C3_nt(){ note_ctor("S674C3_nt", this);} // tgen

//skip512 S674C3_nt

#else // __cplusplus

extern void _ZN9S674C3_ntC1Ev();
extern void _ZN9S674C3_ntD1Ev();
Name_Map name_map_S674C3_nt[] = {
  NSPAIR(_ZN9S674C3_ntC1Ev),
  NSPAIR(_ZN9S674C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S674C5_nt;
extern VTBL_ENTRY _ZTI9S674C5_nt[];
extern  VTBL_ENTRY _ZTV9S674C5_nt[];
extern Class_Descriptor cd_S674C4_nt;
extern VTBL_ENTRY _ZTI9S674C4_nt[];
extern  VTBL_ENTRY _ZTV9S674C4_nt[];
static Base_Class bases_S674C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S674C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S674C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S674C3_nt[];
extern void _ZN9S674C3_ntD1Ev();
extern void _ZN9S674C3_ntD0Ev();
extern void _ZN9S674C5_nt2v6Ev();
extern void _ZN9S674C5_nt2v7Ev();
extern void _ZN9S674C5_nt2v8Ev();
extern void _ZN9S674C5_nt2v9Ev();
extern void _ZN9S674C5_nt3v10Ev();
extern void _ZN9S674C5_nt3v11Ev();
extern void _ZN9S674C5_nt3v12Ev();
extern void _ZN9S674C5_nt3v13Ev();
extern void _ZN9S674C5_nt3v14Ev();
extern void _ZN9S674C5_nt3v15Ev();
extern void _ZN9S674C5_nt3v16Ev();
extern void _ZN9S674C5_nt3v17Ev();
extern void _ZN9S674C5_nt3v18Ev();
extern void _ZN9S674C5_nt3v19Ev();
extern void _ZN9S674C5_nt3v20Ev();
extern void _ZN9S674C5_nt3v21Ev();
extern void _ZN9S674C5_nt3v22Ev();
extern void _ZN9S674C5_nt3v23Ev();
extern void _ZN9S674C5_nt3v24Ev();
extern void _ZN9S674C5_nt3v25Ev();
extern void _ZN9S674C5_nt3v26Ev();
extern void _ZN9S674C5_nt3v27Ev();
extern void _ZN9S674C5_nt3v28Ev();
extern void _ZN9S674C5_nt3v29Ev();
extern void _ZN9S674C5_nt3v30Ev();
extern void _ZN9S674C5_nt3v31Ev();
extern void _ZN9S674C5_nt3v32Ev();
extern void _ZN9S674C5_nt3v33Ev();
extern void _ZN9S674C5_nt3v34Ev();
extern void _ZN9S674C5_nt3v35Ev();
extern void _ZN9S674C5_nt3v36Ev();
extern void _ZN9S674C5_nt3v37Ev();
extern void _ZN9S674C5_nt3v38Ev();
extern void _ZN9S674C5_nt3v39Ev();
extern void _ZN9S674C5_nt3v40Ev();
extern void _ZN9S674C5_nt3v41Ev();
extern void _ZN9S674C5_nt3v42Ev();
extern void _ZN9S674C5_nt3v43Ev();
extern void _ZN9S674C5_nt3v44Ev();
extern void _ZN9S674C5_nt3v45Ev();
extern void _ZN9S674C5_nt3v46Ev();
extern void _ZN9S674C5_nt3v47Ev();
extern void _ZN9S674C5_nt3v48Ev();
extern void _ZN9S674C5_nt3v49Ev();
extern void _ZN9S674C5_nt3v50Ev();
extern void _ZN9S674C5_nt3v51Ev();
extern void _ZN9S674C5_nt3v52Ev();
extern void _ZN9S674C5_nt3v53Ev();
extern void _ZN9S674C5_nt3v54Ev();
extern void _ZN9S674C5_nt3v55Ev();
extern void _ZN9S674C5_nt3v56Ev();
extern void _ZN9S674C5_nt3v57Ev();
extern void _ZN9S674C5_nt3v58Ev();
extern void _ZN9S674C5_nt3v59Ev();
extern void _ZN9S674C5_nt3v60Ev();
extern void _ZN9S674C5_nt3v61Ev();
extern void _ZN9S674C5_nt3v62Ev();
extern void _ZN9S674C5_nt3v63Ev();
extern void _ZN9S674C5_nt3v64Ev();
extern void _ZN9S674C5_nt3v65Ev();
extern void _ZN9S674C5_nt3v66Ev();
extern void _ZN9S674C5_nt3v67Ev();
extern void _ZN9S674C5_nt3v68Ev();
extern void _ZN9S674C5_nt3v69Ev();
extern void _ZN9S674C4_nt3v70Ev();
extern void _ZN9S674C4_nt3v71Ev();
extern void _ZN9S674C3_nt3v72Ev();
extern void _ZN9S674C3_nt3v73Ev();
extern void _ZN9S674C3_nt3v74Ev();
extern void _ZN9S674C3_nt3v75Ev();
extern void _ZN9S674C3_nt3v76Ev();
extern void _ZN9S674C3_nt3v77Ev();
extern void _ZN9S674C3_nt3v78Ev();
extern void _ZN9S674C3_nt3v79Ev();
extern void _ZN9S674C3_nt3v80Ev();
extern void _ZN9S674C3_nt3v81Ev();
extern void _ZN9S674C3_nt3v82Ev();
extern void _ZN9S674C3_nt3v83Ev();
extern void _ZN9S674C3_nt3v84Ev();
extern void _ZN9S674C3_nt3v85Ev();
extern void _ZN9S674C3_nt3v86Ev();
extern void _ZN9S674C3_nt3v87Ev();
extern void _ZN9S674C3_nt3v88Ev();
extern void _ZN9S674C3_nt3v89Ev();
extern void _ZN9S674C3_nt3v90Ev();
extern void _ZN9S674C3_nt3v91Ev();
extern void _ZN9S674C3_nt3v92Ev();
extern void _ZN9S674C3_nt3v93Ev();
extern void _ZN9S674C3_nt3v94Ev();
extern void _ZN9S674C3_nt3v95Ev();
extern void _ZN9S674C3_nt3v96Ev();
extern void _ZN9S674C3_nt3v97Ev();
extern void _ZN9S674C3_nt3v98Ev();
extern void _ZN9S674C3_nt3v99Ev();
extern void _ZN9S674C3_nt4v100Ev();
extern void _ZN9S674C3_nt4v101Ev();
extern void _ZN9S674C3_nt4v102Ev();
extern void _ZN9S674C3_nt4v103Ev();
extern void _ZN9S674C3_nt4v104Ev();
extern void _ZN9S674C3_nt4v105Ev();
extern void _ZN9S674C3_nt4v106Ev();
extern void _ZN9S674C3_nt4v107Ev();
extern void _ZN9S674C3_nt4v108Ev();
extern void _ZN9S674C3_nt4v109Ev();
extern void _ZN9S674C3_nt4v110Ev();
extern void _ZN9S674C3_nt4v111Ev();
extern void _ZN9S674C3_nt4v112Ev();
extern void _ZN9S674C3_nt4v113Ev();
extern void _ZN9S674C3_nt4v114Ev();
extern void _ZN9S674C3_nt4v115Ev();
extern void _ZN9S674C3_nt4v116Ev();
extern void _ZN9S674C3_nt4v117Ev();
extern void _ZN9S674C3_nt4v118Ev();
extern void _ZN9S674C3_nt4v119Ev();
extern void _ZN9S674C3_nt4v120Ev();
extern void _ZN9S674C3_nt4v121Ev();
extern void _ZN9S674C3_nt4v122Ev();
extern void _ZN9S674C3_nt4v123Ev();
extern void _ZN9S674C3_nt4v124Ev();
extern void _ZN9S674C3_nt4v125Ev();
extern void _ZN9S674C3_nt4v126Ev();
extern void _ZN9S674C3_nt4v127Ev();
extern void _ZN9S674C3_nt4v128Ev();
extern void _ZN9S674C3_nt4v129Ev();
extern void _ZN9S674C3_nt4v130Ev();
extern void _ZN9S674C3_nt4v131Ev();
extern void _ZN9S674C3_nt4v132Ev();
extern void _ZN9S674C3_nt4v133Ev();
extern void _ZN9S674C3_nt4v134Ev();
extern void _ZN9S674C3_nt4v135Ev();
extern void _ZN9S674C3_nt4v136Ev();
extern void _ZN9S674C3_nt4v137Ev();
extern void _ZN9S674C3_nt4v138Ev();
extern void _ZN9S674C3_nt4v139Ev();
extern void _ZN9S674C3_nt4v140Ev();
extern void _ZN9S674C3_nt4v141Ev();
extern void _ZN9S674C3_nt4v142Ev();
extern void _ZN9S674C3_nt4v143Ev();
extern void _ZN9S674C3_nt4v144Ev();
extern void _ZN9S674C3_nt4v145Ev();
extern void _ZN9S674C3_nt4v146Ev();
extern void _ZN9S674C3_nt4v147Ev();
static  VTBL_ENTRY vtc_S674C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S674C3_nt[0]),
  (VTBL_ENTRY)&_ZN9S674C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S674C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S674C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S674C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v147Ev,
};
extern VTBL_ENTRY _ZTI9S674C3_nt[];
VTBL_ENTRY *P__ZTI9S674C3_nt = _ZTI9S674C3_nt; 
extern  VTBL_ENTRY _ZTV9S674C3_nt[];
Class_Descriptor cd_S674C3_nt = {  "S674C3_nt", // class name
  bases_S674C3_nt, 2,
  &(vtc_S674C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(464,352), // object size
  NSPAIRA(_ZTI9S674C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S674C3_nt),146, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C21_nt  {
  int s674c21f0[4];
  void  mf674c21(); // _ZN10S674C21_nt8mf674c21Ev
};
//SIG(-1 S674C21_nt) C1{ m Fi[4]}


void  S674C21_nt ::mf674c21(){}

//skip512 S674C21_nt

#else // __cplusplus

Class_Descriptor cd_S674C21_nt = {  "S674C21_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C20_nt  : S674C21_nt {
};
//SIG(-1 S674C20_nt) C1{ BC2{ m Fi[4]}}



//skip512 S674C20_nt

#else // __cplusplus

extern Class_Descriptor cd_S674C21_nt;
static Base_Class bases_S674C20_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S674C21_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C22_nt  {
  ::S674C6_nt s674c22f0;
  void *s674c22f1;
  ::S674C20_nt s674c22f2;
  void *s674c22f3;
  void  mf674c22(); // _ZN10S674C22_nt8mf674c22Ev
};
//SIG(-1 S674C22_nt) C1{ m FC2{ m Fi[2]} Fp FC3{ BC4{ m Fi[4]}} Fp}


void  S674C22_nt ::mf674c22(){}

//skip512 S674C22_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C24_nt  {
  void *s674c24f0[8];
  char s674c24f1[4];
  void  mf674c24(); // _ZN10S674C24_nt8mf674c24Ev
};
//SIG(-1 S674C24_nt) C1{ m Fp[8] Fc[4]}


void  S674C24_nt ::mf674c24(){}

//skip512 S674C24_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C26_nt  {
  int s674c26f0[4];
  char s674c26f1[4];
  void  mf674c26(); // _ZN10S674C26_nt8mf674c26Ev
};
//SIG(-1 S674C26_nt) C1{ m Fi[4] Fc[4]}


void  S674C26_nt ::mf674c26(){}

//skip512 S674C26_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C25_nt  {
  void *s674c25f0[5];
  ::S674C26_nt s674c25f1;
  unsigned int s674c25f2:1;
  unsigned int s674c25f3:1;
  int s674c25f4;
  char s674c25f5[8];
  void  mf674c25(); // _ZN10S674C25_nt8mf674c25Ev
};
//SIG(-1 S674C25_nt) C1{ m Fp[5] FC2{ m Fi[4] Fc[4]} Fi:1 Fi:1 Fi Fc[8]}


void  S674C25_nt ::mf674c25(){}

//skip512 S674C25_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C29_nt  {
  int s674c29f0[3];
  void  mf674c29(); // _ZN10S674C29_nt8mf674c29Ev
};
//SIG(-1 S674C29_nt) C1{ m Fi[3]}


void  S674C29_nt ::mf674c29(){}

//skip512 S674C29_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C30_nt  {
  void  mf674c30(); // _ZN10S674C30_nt8mf674c30Ev
};
//SIG(-1 S674C30_nt) C1{ m}


void  S674C30_nt ::mf674c30(){}

//skip512 S674C30_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C32_nt  {
  int s674c32f0[2];
  char s674c32f1[2];
  void  mf674c32(); // _ZN10S674C32_nt8mf674c32Ev
};
//SIG(-1 S674C32_nt) C1{ m Fi[2] Fc[2]}


void  S674C32_nt ::mf674c32(){}

//skip512 S674C32_nt

#else // __cplusplus

Class_Descriptor cd_S674C32_nt = {  "S674C32_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C31_nt  : S674C32_nt {
  int s674c31f0;
};
//SIG(-1 S674C31_nt) C1{ BC2{ m Fi[2] Fc[2]} Fi}



//skip512 S674C31_nt

#else // __cplusplus

extern Class_Descriptor cd_S674C32_nt;
static Base_Class bases_S674C31_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S674C32_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C28_nt  {
  ::S674C29_nt s674c28f0;
  ::S674C30_nt s674c28f1;
  ::S674C31_nt s674c28f2;
  char s674c28f3;
  void  mf674c28(); // _ZN10S674C28_nt8mf674c28Ev
};
//SIG(-1 S674C28_nt) C1{ m FC2{ m Fi[3]} FC3{ m} FC4{ BC5{ m Fi[2] Fc[2]} Fi} Fc}


void  S674C28_nt ::mf674c28(){}

//skip512 S674C28_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C36_nt  {
  void *s674c36f0[2];
  void  mf674c36(); // _ZN10S674C36_nt8mf674c36Ev
};
//SIG(-1 S674C36_nt) C1{ m Fp[2]}


void  S674C36_nt ::mf674c36(){}

//skip512 S674C36_nt

#else // __cplusplus

Class_Descriptor cd_S674C36_nt = {  "S674C36_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,8), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C35_nt  : S674C36_nt {
};
//SIG(-1 S674C35_nt) C1{ BC2{ m Fp[2]}}



//skip512 S674C35_nt

#else // __cplusplus

extern Class_Descriptor cd_S674C36_nt;
static Base_Class bases_S674C35_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S674C36_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C39  : S674C10_nt {
};
//SIG(-1 S674C39) C1{ BC2{ m Fp Fi[2]}}



static void Test_S674C39()
{
  extern Class_Descriptor cd_S674C39;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S674C39, buf);
    S674C39 &lv = *(new (buf) S674C39());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S674C39)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S674C39)");
    check_base_class_offset(lv, (S674C10_nt*), 0, "S674C39");
    test_class_info(&lv, &cd_S674C39);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS674C39(Test_S674C39, "S674C39", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S674C10_nt;
static Base_Class bases_S674C39[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S674C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S674C39 = {  "S674C39", // class name
  bases_S674C39, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C38  : S674C39 {
};
//SIG(-1 S674C38) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S674C38()
{
  extern Class_Descriptor cd_S674C38;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S674C38, buf);
    S674C38 &lv = *(new (buf) S674C38());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S674C38)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S674C38)");
    check_base_class_offset(lv, (S674C10_nt*)(S674C39*), 0, "S674C38");
    check_base_class_offset(lv, (S674C39*), 0, "S674C38");
    test_class_info(&lv, &cd_S674C38);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS674C38(Test_S674C38, "S674C38", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S674C10_nt;
extern Class_Descriptor cd_S674C39;
static Base_Class bases_S674C38[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S674C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S674C39,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S674C38 = {  "S674C38", // class name
  bases_S674C38, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C37_nt  : S674C38 {
};
//SIG(-1 S674C37_nt) C1{ BC2{ BC3{ BC4{ m Fp Fi[2]}}}}



//skip512 S674C37_nt

#else // __cplusplus

extern Class_Descriptor cd_S674C10_nt;
extern Class_Descriptor cd_S674C39;
extern Class_Descriptor cd_S674C38;
static Base_Class bases_S674C37_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S674C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S674C39,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S674C38,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C34_nt  {
  ::S674C35_nt s674c34f0;
  char s674c34f1;
  ::S674C37_nt s674c34f2;
  int s674c34f3;
  ::S674C6_nt s674c34f4;
  ::S674C6_nt s674c34f5;
  void *s674c34f6;
  void  mf674c34(); // _ZN10S674C34_nt8mf674c34Ev
};
//SIG(-1 S674C34_nt) C1{ m FC2{ BC3{ m Fp[2]}} Fc FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} Fi FC8{ m Fi[2]} FC8 Fp}


void  S674C34_nt ::mf674c34(){}

//skip512 S674C34_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C43  : S674C10_nt {
};
//SIG(-1 S674C43) C1{ BC2{ m Fp Fi[2]}}



static void Test_S674C43()
{
  extern Class_Descriptor cd_S674C43;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S674C43, buf);
    S674C43 &lv = *(new (buf) S674C43());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S674C43)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S674C43)");
    check_base_class_offset(lv, (S674C10_nt*), 0, "S674C43");
    test_class_info(&lv, &cd_S674C43);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS674C43(Test_S674C43, "S674C43", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S674C10_nt;
static Base_Class bases_S674C43[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S674C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S674C43 = {  "S674C43", // class name
  bases_S674C43, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C42  : S674C43 {
};
//SIG(-1 S674C42) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S674C42()
{
  extern Class_Descriptor cd_S674C42;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S674C42, buf);
    S674C42 &lv = *(new (buf) S674C42());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S674C42)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S674C42)");
    check_base_class_offset(lv, (S674C10_nt*)(S674C43*), 0, "S674C42");
    check_base_class_offset(lv, (S674C43*), 0, "S674C42");
    test_class_info(&lv, &cd_S674C42);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS674C42(Test_S674C42, "S674C42", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S674C10_nt;
extern Class_Descriptor cd_S674C43;
static Base_Class bases_S674C42[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S674C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S674C43,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S674C42 = {  "S674C42", // class name
  bases_S674C42, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C2_nt  : S674C3_nt {
  ::S674C20_nt s674c2f0;
  ::S674C6_nt s674c2f1;
  void *s674c2f2[2];
  ::S674C22_nt s674c2f3;
  ::S674C24_nt s674c2f4;
  int s674c2f5;
  ::S674C25_nt s674c2f6;
  int s674c2f7[4];
  ::S674C6_nt s674c2f8[4];
  ::S674C28_nt s674c2f9;
  ::S674C29_nt s674c2f10;
  int s674c2f11;
  ::S674C34_nt s674c2f12;
  ::S674C34_nt s674c2f13;
  void *s674c2f14;
  ::S674C29_nt s674c2f15;
  ::S674C17 s674c2f16;
  ::S674C42 s674c2f17;
  unsigned int s674c2f18:1;
  unsigned int s674c2f19:1;
  unsigned int s674c2f20:1;
  ::S674C30_nt s674c2f21;
  ::S674C19_nt s674c2f22;
  ::S674C19_nt s674c2f23;
  ::S674C19_nt s674c2f24;
  ::S674C19_nt s674c2f25;
  ::S674C19_nt s674c2f26;
  ::S674C19_nt s674c2f27;
  ::S674C19_nt s674c2f28;
  ::S674C19_nt s674c2f29;
  ::S674C19_nt s674c2f30;
  ::S674C19_nt s674c2f31;
  ::S674C19_nt s674c2f32;
  ::S674C19_nt s674c2f33;
  ::S674C19_nt s674c2f34;
  virtual  ~S674C2_nt(); // _ZN9S674C2_ntD1Ev
  virtual void  v148(); // _ZN9S674C2_nt4v148Ev
  virtual void  v149(); // _ZN9S674C2_nt4v149Ev
  virtual void  v150(); // _ZN9S674C2_nt4v150Ev
  virtual void  v151(); // _ZN9S674C2_nt4v151Ev
  virtual void  v152(); // _ZN9S674C2_nt4v152Ev
  virtual void  v153(); // _ZN9S674C2_nt4v153Ev
  virtual void  v154(); // _ZN9S674C2_nt4v154Ev
  virtual void  v155(); // _ZN9S674C2_nt4v155Ev
  virtual void  v156(); // _ZN9S674C2_nt4v156Ev
  virtual void  v157(); // _ZN9S674C2_nt4v157Ev
  virtual void  v158(); // _ZN9S674C2_nt4v158Ev
  virtual void  v159(); // _ZN9S674C2_nt4v159Ev
  virtual void  v160(); // _ZN9S674C2_nt4v160Ev
  virtual void  v161(); // _ZN9S674C2_nt4v161Ev
  virtual void  v162(); // _ZN9S674C2_nt4v162Ev
  virtual void  v163(); // _ZN9S674C2_nt4v163Ev
  virtual void  v164(); // _ZN9S674C2_nt4v164Ev
  virtual void  v165(); // _ZN9S674C2_nt4v165Ev
  virtual void  v166(); // _ZN9S674C2_nt4v166Ev
  virtual void  v167(); // _ZN9S674C2_nt4v167Ev
  virtual void  v168(); // _ZN9S674C2_nt4v168Ev
  virtual void  v169(); // _ZN9S674C2_nt4v169Ev
  virtual void  v170(); // _ZN9S674C2_nt4v170Ev
  virtual void  v171(); // _ZN9S674C2_nt4v171Ev
  virtual void  v172(); // _ZN9S674C2_nt4v172Ev
  virtual void  v173(); // _ZN9S674C2_nt4v173Ev
  virtual void  v174(); // _ZN9S674C2_nt4v174Ev
  virtual void  v175(); // _ZN9S674C2_nt4v175Ev
  virtual void  v176(); // _ZN9S674C2_nt4v176Ev
  virtual void  v177(); // _ZN9S674C2_nt4v177Ev
  virtual void  v178(); // _ZN9S674C2_nt4v178Ev
  virtual void  v179(); // _ZN9S674C2_nt4v179Ev
  virtual void  v180(); // _ZN9S674C2_nt4v180Ev
  virtual void  v181(); // _ZN9S674C2_nt4v181Ev
  virtual void  v182(); // _ZN9S674C2_nt4v182Ev
  virtual void  v183(); // _ZN9S674C2_nt4v183Ev
  virtual void  v184(); // _ZN9S674C2_nt4v184Ev
  virtual void  v185(); // _ZN9S674C2_nt4v185Ev
  virtual void  v186(); // _ZN9S674C2_nt4v186Ev
  virtual void  v187(); // _ZN9S674C2_nt4v187Ev
  virtual void  v188(); // _ZN9S674C2_nt4v188Ev
  virtual void  v189(); // _ZN9S674C2_nt4v189Ev
  virtual void  v190(); // _ZN9S674C2_nt4v190Ev
  virtual void  v191(); // _ZN9S674C2_nt4v191Ev
  virtual void  v192(); // _ZN9S674C2_nt4v192Ev
  virtual void  v193(); // _ZN9S674C2_nt4v193Ev
  virtual void  v194(); // _ZN9S674C2_nt4v194Ev
  virtual void  v195(); // _ZN9S674C2_nt4v195Ev
  virtual void  v196(); // _ZN9S674C2_nt4v196Ev
  virtual void  v197(); // _ZN9S674C2_nt4v197Ev
  virtual void  v198(); // _ZN9S674C2_nt4v198Ev
  virtual void  v199(); // _ZN9S674C2_nt4v199Ev
  virtual void  v200(); // _ZN9S674C2_nt4v200Ev
  virtual void  v201(); // _ZN9S674C2_nt4v201Ev
  virtual void  v202(); // _ZN9S674C2_nt4v202Ev
  virtual void  v203(); // _ZN9S674C2_nt4v203Ev
  virtual void  v204(); // _ZN9S674C2_nt4v204Ev
  virtual void  v205(); // _ZN9S674C2_nt4v205Ev
  virtual void  v206(); // _ZN9S674C2_nt4v206Ev
  virtual void  v207(); // _ZN9S674C2_nt4v207Ev
  virtual void  v208(); // _ZN9S674C2_nt4v208Ev
  virtual void  v209(); // _ZN9S674C2_nt4v209Ev
  virtual void  v210(); // _ZN9S674C2_nt4v210Ev
  virtual void  v211(); // _ZN9S674C2_nt4v211Ev
  virtual void  v212(); // _ZN9S674C2_nt4v212Ev
  virtual void  v213(); // _ZN9S674C2_nt4v213Ev
  virtual void  v214(); // _ZN9S674C2_nt4v214Ev
  virtual void  v215(); // _ZN9S674C2_nt4v215Ev
  virtual void  v216(); // _ZN9S674C2_nt4v216Ev
  S674C2_nt(); // tgen
};
//SIG(-1 S674C2_nt) C1{ BC2{ BC3{ BC4{ vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v134 v135} vd v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 FC6{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC7 Fp FC10{ BC11{ BC9}} FC10 FC10 FC12{ BC13{ BC9}} Fc Fi Fp FC5 FC5 FC5 FC5 FC5 FC5 FC14{ m Fp FC5} FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 FC15{ BC16{ m Fi[4]}} FC5 Fp[2] FC17{ m FC5 Fp FC15 Fp} FC18{ m Fp[8] Fc[4]} Fi FC19{ m Fp[5] FC20{ m Fi[4] Fc[4]} Fi:1 Fi:1 Fi Fc[8]} Fi[4] FC5[4] FC21{ m FC22{ m Fi[3]} FC23{ m} FC24{ BC25{ m Fi[2] Fc[2]} Fi} Fc} FC22 Fi FC26{ m FC27{ BC28{ m Fp[2]}} Fc FC29{ BC30{ BC31{ BC9}}} Fi FC5 FC5 Fp} FC26 Fp FC22 FC12 FC32{ BC33{ BC9}} Fi:1 Fi:1 Fi:1 FC23 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14}


 S674C2_nt ::~S674C2_nt(){ note_dtor("S674C2_nt", this);}
void  S674C2_nt ::v148(){vfunc_called(this, "_ZN9S674C2_nt4v148Ev");}
void  S674C2_nt ::v149(){vfunc_called(this, "_ZN9S674C2_nt4v149Ev");}
void  S674C2_nt ::v150(){vfunc_called(this, "_ZN9S674C2_nt4v150Ev");}
void  S674C2_nt ::v151(){vfunc_called(this, "_ZN9S674C2_nt4v151Ev");}
void  S674C2_nt ::v152(){vfunc_called(this, "_ZN9S674C2_nt4v152Ev");}
void  S674C2_nt ::v153(){vfunc_called(this, "_ZN9S674C2_nt4v153Ev");}
void  S674C2_nt ::v154(){vfunc_called(this, "_ZN9S674C2_nt4v154Ev");}
void  S674C2_nt ::v155(){vfunc_called(this, "_ZN9S674C2_nt4v155Ev");}
void  S674C2_nt ::v156(){vfunc_called(this, "_ZN9S674C2_nt4v156Ev");}
void  S674C2_nt ::v157(){vfunc_called(this, "_ZN9S674C2_nt4v157Ev");}
void  S674C2_nt ::v158(){vfunc_called(this, "_ZN9S674C2_nt4v158Ev");}
void  S674C2_nt ::v159(){vfunc_called(this, "_ZN9S674C2_nt4v159Ev");}
void  S674C2_nt ::v160(){vfunc_called(this, "_ZN9S674C2_nt4v160Ev");}
void  S674C2_nt ::v161(){vfunc_called(this, "_ZN9S674C2_nt4v161Ev");}
void  S674C2_nt ::v162(){vfunc_called(this, "_ZN9S674C2_nt4v162Ev");}
void  S674C2_nt ::v163(){vfunc_called(this, "_ZN9S674C2_nt4v163Ev");}
void  S674C2_nt ::v164(){vfunc_called(this, "_ZN9S674C2_nt4v164Ev");}
void  S674C2_nt ::v165(){vfunc_called(this, "_ZN9S674C2_nt4v165Ev");}
void  S674C2_nt ::v166(){vfunc_called(this, "_ZN9S674C2_nt4v166Ev");}
void  S674C2_nt ::v167(){vfunc_called(this, "_ZN9S674C2_nt4v167Ev");}
void  S674C2_nt ::v168(){vfunc_called(this, "_ZN9S674C2_nt4v168Ev");}
void  S674C2_nt ::v169(){vfunc_called(this, "_ZN9S674C2_nt4v169Ev");}
void  S674C2_nt ::v170(){vfunc_called(this, "_ZN9S674C2_nt4v170Ev");}
void  S674C2_nt ::v171(){vfunc_called(this, "_ZN9S674C2_nt4v171Ev");}
void  S674C2_nt ::v172(){vfunc_called(this, "_ZN9S674C2_nt4v172Ev");}
void  S674C2_nt ::v173(){vfunc_called(this, "_ZN9S674C2_nt4v173Ev");}
void  S674C2_nt ::v174(){vfunc_called(this, "_ZN9S674C2_nt4v174Ev");}
void  S674C2_nt ::v175(){vfunc_called(this, "_ZN9S674C2_nt4v175Ev");}
void  S674C2_nt ::v176(){vfunc_called(this, "_ZN9S674C2_nt4v176Ev");}
void  S674C2_nt ::v177(){vfunc_called(this, "_ZN9S674C2_nt4v177Ev");}
void  S674C2_nt ::v178(){vfunc_called(this, "_ZN9S674C2_nt4v178Ev");}
void  S674C2_nt ::v179(){vfunc_called(this, "_ZN9S674C2_nt4v179Ev");}
void  S674C2_nt ::v180(){vfunc_called(this, "_ZN9S674C2_nt4v180Ev");}
void  S674C2_nt ::v181(){vfunc_called(this, "_ZN9S674C2_nt4v181Ev");}
void  S674C2_nt ::v182(){vfunc_called(this, "_ZN9S674C2_nt4v182Ev");}
void  S674C2_nt ::v183(){vfunc_called(this, "_ZN9S674C2_nt4v183Ev");}
void  S674C2_nt ::v184(){vfunc_called(this, "_ZN9S674C2_nt4v184Ev");}
void  S674C2_nt ::v185(){vfunc_called(this, "_ZN9S674C2_nt4v185Ev");}
void  S674C2_nt ::v186(){vfunc_called(this, "_ZN9S674C2_nt4v186Ev");}
void  S674C2_nt ::v187(){vfunc_called(this, "_ZN9S674C2_nt4v187Ev");}
void  S674C2_nt ::v188(){vfunc_called(this, "_ZN9S674C2_nt4v188Ev");}
void  S674C2_nt ::v189(){vfunc_called(this, "_ZN9S674C2_nt4v189Ev");}
void  S674C2_nt ::v190(){vfunc_called(this, "_ZN9S674C2_nt4v190Ev");}
void  S674C2_nt ::v191(){vfunc_called(this, "_ZN9S674C2_nt4v191Ev");}
void  S674C2_nt ::v192(){vfunc_called(this, "_ZN9S674C2_nt4v192Ev");}
void  S674C2_nt ::v193(){vfunc_called(this, "_ZN9S674C2_nt4v193Ev");}
void  S674C2_nt ::v194(){vfunc_called(this, "_ZN9S674C2_nt4v194Ev");}
void  S674C2_nt ::v195(){vfunc_called(this, "_ZN9S674C2_nt4v195Ev");}
void  S674C2_nt ::v196(){vfunc_called(this, "_ZN9S674C2_nt4v196Ev");}
void  S674C2_nt ::v197(){vfunc_called(this, "_ZN9S674C2_nt4v197Ev");}
void  S674C2_nt ::v198(){vfunc_called(this, "_ZN9S674C2_nt4v198Ev");}
void  S674C2_nt ::v199(){vfunc_called(this, "_ZN9S674C2_nt4v199Ev");}
void  S674C2_nt ::v200(){vfunc_called(this, "_ZN9S674C2_nt4v200Ev");}
void  S674C2_nt ::v201(){vfunc_called(this, "_ZN9S674C2_nt4v201Ev");}
void  S674C2_nt ::v202(){vfunc_called(this, "_ZN9S674C2_nt4v202Ev");}
void  S674C2_nt ::v203(){vfunc_called(this, "_ZN9S674C2_nt4v203Ev");}
void  S674C2_nt ::v204(){vfunc_called(this, "_ZN9S674C2_nt4v204Ev");}
void  S674C2_nt ::v205(){vfunc_called(this, "_ZN9S674C2_nt4v205Ev");}
void  S674C2_nt ::v206(){vfunc_called(this, "_ZN9S674C2_nt4v206Ev");}
void  S674C2_nt ::v207(){vfunc_called(this, "_ZN9S674C2_nt4v207Ev");}
void  S674C2_nt ::v208(){vfunc_called(this, "_ZN9S674C2_nt4v208Ev");}
void  S674C2_nt ::v209(){vfunc_called(this, "_ZN9S674C2_nt4v209Ev");}
void  S674C2_nt ::v210(){vfunc_called(this, "_ZN9S674C2_nt4v210Ev");}
void  S674C2_nt ::v211(){vfunc_called(this, "_ZN9S674C2_nt4v211Ev");}
void  S674C2_nt ::v212(){vfunc_called(this, "_ZN9S674C2_nt4v212Ev");}
void  S674C2_nt ::v213(){vfunc_called(this, "_ZN9S674C2_nt4v213Ev");}
void  S674C2_nt ::v214(){vfunc_called(this, "_ZN9S674C2_nt4v214Ev");}
void  S674C2_nt ::v215(){vfunc_called(this, "_ZN9S674C2_nt4v215Ev");}
void  S674C2_nt ::v216(){vfunc_called(this, "_ZN9S674C2_nt4v216Ev");}
S674C2_nt ::S674C2_nt(){ note_ctor("S674C2_nt", this);} // tgen

//skip512 S674C2_nt

#else // __cplusplus

extern void _ZN9S674C2_ntC1Ev();
extern void _ZN9S674C2_ntD1Ev();
Name_Map name_map_S674C2_nt[] = {
  NSPAIR(_ZN9S674C2_ntC1Ev),
  NSPAIR(_ZN9S674C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S674C5_nt;
extern VTBL_ENTRY _ZTI9S674C5_nt[];
extern  VTBL_ENTRY _ZTV9S674C5_nt[];
extern Class_Descriptor cd_S674C4_nt;
extern VTBL_ENTRY _ZTI9S674C4_nt[];
extern  VTBL_ENTRY _ZTV9S674C4_nt[];
extern Class_Descriptor cd_S674C3_nt;
extern VTBL_ENTRY _ZTI9S674C3_nt[];
extern  VTBL_ENTRY _ZTV9S674C3_nt[];
static Base_Class bases_S674C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S674C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S674C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S674C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S674C2_nt[];
extern void _ZN9S674C2_ntD1Ev();
extern void _ZN9S674C2_ntD0Ev();
extern void _ZN9S674C5_nt2v6Ev();
extern void _ZN9S674C5_nt2v7Ev();
extern void _ZN9S674C5_nt2v8Ev();
extern void _ZN9S674C5_nt2v9Ev();
extern void _ZN9S674C5_nt3v10Ev();
extern void _ZN9S674C5_nt3v11Ev();
extern void _ZN9S674C5_nt3v12Ev();
extern void _ZN9S674C5_nt3v13Ev();
extern void _ZN9S674C5_nt3v14Ev();
extern void _ZN9S674C5_nt3v15Ev();
extern void _ZN9S674C5_nt3v16Ev();
extern void _ZN9S674C5_nt3v17Ev();
extern void _ZN9S674C5_nt3v18Ev();
extern void _ZN9S674C5_nt3v19Ev();
extern void _ZN9S674C5_nt3v20Ev();
extern void _ZN9S674C5_nt3v21Ev();
extern void _ZN9S674C5_nt3v22Ev();
extern void _ZN9S674C5_nt3v23Ev();
extern void _ZN9S674C5_nt3v24Ev();
extern void _ZN9S674C5_nt3v25Ev();
extern void _ZN9S674C5_nt3v26Ev();
extern void _ZN9S674C5_nt3v27Ev();
extern void _ZN9S674C5_nt3v28Ev();
extern void _ZN9S674C5_nt3v29Ev();
extern void _ZN9S674C5_nt3v30Ev();
extern void _ZN9S674C5_nt3v31Ev();
extern void _ZN9S674C5_nt3v32Ev();
extern void _ZN9S674C5_nt3v33Ev();
extern void _ZN9S674C5_nt3v34Ev();
extern void _ZN9S674C5_nt3v35Ev();
extern void _ZN9S674C5_nt3v36Ev();
extern void _ZN9S674C5_nt3v37Ev();
extern void _ZN9S674C5_nt3v38Ev();
extern void _ZN9S674C5_nt3v39Ev();
extern void _ZN9S674C5_nt3v40Ev();
extern void _ZN9S674C5_nt3v41Ev();
extern void _ZN9S674C5_nt3v42Ev();
extern void _ZN9S674C5_nt3v43Ev();
extern void _ZN9S674C5_nt3v44Ev();
extern void _ZN9S674C5_nt3v45Ev();
extern void _ZN9S674C5_nt3v46Ev();
extern void _ZN9S674C5_nt3v47Ev();
extern void _ZN9S674C5_nt3v48Ev();
extern void _ZN9S674C5_nt3v49Ev();
extern void _ZN9S674C5_nt3v50Ev();
extern void _ZN9S674C5_nt3v51Ev();
extern void _ZN9S674C5_nt3v52Ev();
extern void _ZN9S674C5_nt3v53Ev();
extern void _ZN9S674C5_nt3v54Ev();
extern void _ZN9S674C5_nt3v55Ev();
extern void _ZN9S674C5_nt3v56Ev();
extern void _ZN9S674C5_nt3v57Ev();
extern void _ZN9S674C5_nt3v58Ev();
extern void _ZN9S674C5_nt3v59Ev();
extern void _ZN9S674C5_nt3v60Ev();
extern void _ZN9S674C5_nt3v61Ev();
extern void _ZN9S674C5_nt3v62Ev();
extern void _ZN9S674C5_nt3v63Ev();
extern void _ZN9S674C5_nt3v64Ev();
extern void _ZN9S674C5_nt3v65Ev();
extern void _ZN9S674C5_nt3v66Ev();
extern void _ZN9S674C5_nt3v67Ev();
extern void _ZN9S674C5_nt3v68Ev();
extern void _ZN9S674C5_nt3v69Ev();
extern void _ZN9S674C4_nt3v70Ev();
extern void _ZN9S674C4_nt3v71Ev();
extern void _ZN9S674C3_nt3v72Ev();
extern void _ZN9S674C3_nt3v73Ev();
extern void _ZN9S674C3_nt3v74Ev();
extern void _ZN9S674C3_nt3v75Ev();
extern void _ZN9S674C3_nt3v76Ev();
extern void _ZN9S674C3_nt3v77Ev();
extern void _ZN9S674C3_nt3v78Ev();
extern void _ZN9S674C3_nt3v79Ev();
extern void _ZN9S674C3_nt3v80Ev();
extern void _ZN9S674C3_nt3v81Ev();
extern void _ZN9S674C3_nt3v82Ev();
extern void _ZN9S674C3_nt3v83Ev();
extern void _ZN9S674C3_nt3v84Ev();
extern void _ZN9S674C3_nt3v85Ev();
extern void _ZN9S674C3_nt3v86Ev();
extern void _ZN9S674C3_nt3v87Ev();
extern void _ZN9S674C3_nt3v88Ev();
extern void _ZN9S674C3_nt3v89Ev();
extern void _ZN9S674C3_nt3v90Ev();
extern void _ZN9S674C3_nt3v91Ev();
extern void _ZN9S674C3_nt3v92Ev();
extern void _ZN9S674C3_nt3v93Ev();
extern void _ZN9S674C3_nt3v94Ev();
extern void _ZN9S674C3_nt3v95Ev();
extern void _ZN9S674C3_nt3v96Ev();
extern void _ZN9S674C3_nt3v97Ev();
extern void _ZN9S674C3_nt3v98Ev();
extern void _ZN9S674C3_nt3v99Ev();
extern void _ZN9S674C3_nt4v100Ev();
extern void _ZN9S674C3_nt4v101Ev();
extern void _ZN9S674C3_nt4v102Ev();
extern void _ZN9S674C3_nt4v103Ev();
extern void _ZN9S674C3_nt4v104Ev();
extern void _ZN9S674C3_nt4v105Ev();
extern void _ZN9S674C3_nt4v106Ev();
extern void _ZN9S674C3_nt4v107Ev();
extern void _ZN9S674C3_nt4v108Ev();
extern void _ZN9S674C3_nt4v109Ev();
extern void _ZN9S674C3_nt4v110Ev();
extern void _ZN9S674C3_nt4v111Ev();
extern void _ZN9S674C3_nt4v112Ev();
extern void _ZN9S674C3_nt4v113Ev();
extern void _ZN9S674C3_nt4v114Ev();
extern void _ZN9S674C3_nt4v115Ev();
extern void _ZN9S674C3_nt4v116Ev();
extern void _ZN9S674C3_nt4v117Ev();
extern void _ZN9S674C3_nt4v118Ev();
extern void _ZN9S674C3_nt4v119Ev();
extern void _ZN9S674C3_nt4v120Ev();
extern void _ZN9S674C3_nt4v121Ev();
extern void _ZN9S674C3_nt4v122Ev();
extern void _ZN9S674C3_nt4v123Ev();
extern void _ZN9S674C3_nt4v124Ev();
extern void _ZN9S674C3_nt4v125Ev();
extern void _ZN9S674C3_nt4v126Ev();
extern void _ZN9S674C3_nt4v127Ev();
extern void _ZN9S674C3_nt4v128Ev();
extern void _ZN9S674C3_nt4v129Ev();
extern void _ZN9S674C3_nt4v130Ev();
extern void _ZN9S674C3_nt4v131Ev();
extern void _ZN9S674C3_nt4v132Ev();
extern void _ZN9S674C3_nt4v133Ev();
extern void _ZN9S674C3_nt4v134Ev();
extern void _ZN9S674C3_nt4v135Ev();
extern void _ZN9S674C3_nt4v136Ev();
extern void _ZN9S674C3_nt4v137Ev();
extern void _ZN9S674C3_nt4v138Ev();
extern void _ZN9S674C3_nt4v139Ev();
extern void _ZN9S674C3_nt4v140Ev();
extern void _ZN9S674C3_nt4v141Ev();
extern void _ZN9S674C3_nt4v142Ev();
extern void _ZN9S674C3_nt4v143Ev();
extern void _ZN9S674C3_nt4v144Ev();
extern void _ZN9S674C3_nt4v145Ev();
extern void _ZN9S674C3_nt4v146Ev();
extern void _ZN9S674C3_nt4v147Ev();
extern void _ZN9S674C2_nt4v148Ev();
extern void _ZN9S674C2_nt4v149Ev();
extern void _ZN9S674C2_nt4v150Ev();
extern void _ZN9S674C2_nt4v151Ev();
extern void _ZN9S674C2_nt4v152Ev();
extern void _ZN9S674C2_nt4v153Ev();
extern void _ZN9S674C2_nt4v154Ev();
extern void _ZN9S674C2_nt4v155Ev();
extern void _ZN9S674C2_nt4v156Ev();
extern void _ZN9S674C2_nt4v157Ev();
extern void _ZN9S674C2_nt4v158Ev();
extern void _ZN9S674C2_nt4v159Ev();
extern void _ZN9S674C2_nt4v160Ev();
extern void _ZN9S674C2_nt4v161Ev();
extern void _ZN9S674C2_nt4v162Ev();
extern void _ZN9S674C2_nt4v163Ev();
extern void _ZN9S674C2_nt4v164Ev();
extern void _ZN9S674C2_nt4v165Ev();
extern void _ZN9S674C2_nt4v166Ev();
extern void _ZN9S674C2_nt4v167Ev();
extern void _ZN9S674C2_nt4v168Ev();
extern void _ZN9S674C2_nt4v169Ev();
extern void _ZN9S674C2_nt4v170Ev();
extern void _ZN9S674C2_nt4v171Ev();
extern void _ZN9S674C2_nt4v172Ev();
extern void _ZN9S674C2_nt4v173Ev();
extern void _ZN9S674C2_nt4v174Ev();
extern void _ZN9S674C2_nt4v175Ev();
extern void _ZN9S674C2_nt4v176Ev();
extern void _ZN9S674C2_nt4v177Ev();
extern void _ZN9S674C2_nt4v178Ev();
extern void _ZN9S674C2_nt4v179Ev();
extern void _ZN9S674C2_nt4v180Ev();
extern void _ZN9S674C2_nt4v181Ev();
extern void _ZN9S674C2_nt4v182Ev();
extern void _ZN9S674C2_nt4v183Ev();
extern void _ZN9S674C2_nt4v184Ev();
extern void _ZN9S674C2_nt4v185Ev();
extern void _ZN9S674C2_nt4v186Ev();
extern void _ZN9S674C2_nt4v187Ev();
extern void _ZN9S674C2_nt4v188Ev();
extern void _ZN9S674C2_nt4v189Ev();
extern void _ZN9S674C2_nt4v190Ev();
extern void _ZN9S674C2_nt4v191Ev();
extern void _ZN9S674C2_nt4v192Ev();
extern void _ZN9S674C2_nt4v193Ev();
extern void _ZN9S674C2_nt4v194Ev();
extern void _ZN9S674C2_nt4v195Ev();
extern void _ZN9S674C2_nt4v196Ev();
extern void _ZN9S674C2_nt4v197Ev();
extern void _ZN9S674C2_nt4v198Ev();
extern void _ZN9S674C2_nt4v199Ev();
extern void _ZN9S674C2_nt4v200Ev();
extern void _ZN9S674C2_nt4v201Ev();
extern void _ZN9S674C2_nt4v202Ev();
extern void _ZN9S674C2_nt4v203Ev();
extern void _ZN9S674C2_nt4v204Ev();
extern void _ZN9S674C2_nt4v205Ev();
extern void _ZN9S674C2_nt4v206Ev();
extern void _ZN9S674C2_nt4v207Ev();
extern void _ZN9S674C2_nt4v208Ev();
extern void _ZN9S674C2_nt4v209Ev();
extern void _ZN9S674C2_nt4v210Ev();
extern void _ZN9S674C2_nt4v211Ev();
extern void _ZN9S674C2_nt4v212Ev();
extern void _ZN9S674C2_nt4v213Ev();
extern void _ZN9S674C2_nt4v214Ev();
extern void _ZN9S674C2_nt4v215Ev();
extern void _ZN9S674C2_nt4v216Ev();
static  VTBL_ENTRY vtc_S674C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S674C2_nt[0]),
  (VTBL_ENTRY)&_ZN9S674C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S674C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S674C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S674C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v148Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v149Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v150Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v151Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v152Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v153Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v154Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v155Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v156Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v157Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v158Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v159Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v160Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v161Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v162Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v163Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v164Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v165Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v166Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v167Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v168Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v169Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v170Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v171Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v172Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v173Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v174Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v175Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v176Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v177Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v178Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v179Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v180Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v181Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v182Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v183Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v184Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v185Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v186Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v187Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v188Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v189Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v190Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v191Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v192Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v193Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v194Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v195Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v196Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v197Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v198Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v199Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v200Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v201Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v202Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v203Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v204Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v205Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v206Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v207Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v208Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v209Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v210Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v211Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v212Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v213Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v214Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v215Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v216Ev,
};
extern VTBL_ENTRY _ZTI9S674C2_nt[];
VTBL_ENTRY *P__ZTI9S674C2_nt = _ZTI9S674C2_nt; 
extern  VTBL_ENTRY _ZTV9S674C2_nt[];
Class_Descriptor cd_S674C2_nt = {  "S674C2_nt", // class name
  bases_S674C2_nt, 3,
  &(vtc_S674C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1224,908), // object size
  NSPAIRA(_ZTI9S674C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S674C2_nt),215, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S674C1  : S674C2_nt {
  void *s674c1f0[5];
  int s674c1f1;
  unsigned int s674c1f2:1;
  virtual  ~S674C1(); // _ZN6S674C1D1Ev
  virtual void  v1(); // _ZN6S674C12v1Ev
  virtual void  v2(); // _ZN6S674C12v2Ev
  virtual void  v3(); // _ZN6S674C12v3Ev
  virtual void  v4(); // _ZN6S674C12v4Ev
  virtual void  v5(); // _ZN6S674C12v5Ev
  S674C1(); // tgen
};
//SIG(1 S674C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v70 v71} vd v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 FC7{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC8{ BC9{ BC10{ m Fp Fi[2]}}} FC8 Fp FC11{ BC12{ BC10}} FC11 FC11 FC13{ BC14{ BC10}} Fc Fi Fp FC6 FC6 FC6 FC6 FC6 FC6 FC15{ m Fp FC6} FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15} vd v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 FC16{ BC17{ m Fi[4]}} FC6 Fp[2] FC18{ m FC6 Fp FC16 Fp} FC19{ m Fp[8] Fc[4]} Fi FC20{ m Fp[5] FC21{ m Fi[4] Fc[4]} Fi:1 Fi:1 Fi Fc[8]} Fi[4] FC6[4] FC22{ m FC23{ m Fi[3]} FC24{ m} FC25{ BC26{ m Fi[2] Fc[2]} Fi} Fc} FC23 Fi FC27{ m FC28{ BC29{ m Fp[2]}} Fc FC30{ BC31{ BC32{ BC10}}} Fi FC6 FC6 Fp} FC27 Fp FC23 FC13 FC33{ BC34{ BC10}} Fi:1 Fi:1 Fi:1 FC24 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15} vd v1 v2 v3 v4 v5 Fp[5] Fi Fi:1}


 S674C1 ::~S674C1(){ note_dtor("S674C1", this);}
void  S674C1 ::v1(){vfunc_called(this, "_ZN6S674C12v1Ev");}
void  S674C1 ::v2(){vfunc_called(this, "_ZN6S674C12v2Ev");}
void  S674C1 ::v3(){vfunc_called(this, "_ZN6S674C12v3Ev");}
void  S674C1 ::v4(){vfunc_called(this, "_ZN6S674C12v4Ev");}
void  S674C1 ::v5(){vfunc_called(this, "_ZN6S674C12v5Ev");}
S674C1 ::S674C1(){ note_ctor("S674C1", this);} // tgen

static void Test_S674C1()
{
  extern Class_Descriptor cd_S674C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(160,235)];
    init_test(&cd_S674C1, buf);
    S674C1 *dp, &lv = *(dp=new (buf) S674C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1272,936), "sizeof(S674C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S674C1)");
    check_base_class_offset(lv, (S674C5_nt*)(S674C4_nt*)(S674C3_nt*)(S674C2_nt*), 0, "S674C1");
    check_base_class_offset(lv, (S674C4_nt*)(S674C3_nt*)(S674C2_nt*), 0, "S674C1");
    check_base_class_offset(lv, (S674C3_nt*)(S674C2_nt*), 0, "S674C1");
    check_base_class_offset(lv, (S674C2_nt*), 0, "S674C1");
    check_field_offset(lv, s674c1f0, ABISELECT(1224,908), "S674C1.s674c1f0");
    check_field_offset(lv, s674c1f1, ABISELECT(1264,928), "S674C1.s674c1f1");
    set_bf_and_test(lv, s674c1f2, ABISELECT(1268,932), 0, 1, 1, "S674C1");
    test_class_info(&lv, &cd_S674C1);
    dp->~S674C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS674C1(Test_S674C1, "S674C1", ABISELECT(1272,936));

#else // __cplusplus

extern void _ZN6S674C1C1Ev();
extern void _ZN6S674C1D1Ev();
Name_Map name_map_S674C1[] = {
  NSPAIR(_ZN6S674C1C1Ev),
  NSPAIR(_ZN6S674C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S674C5_nt;
extern VTBL_ENTRY _ZTI9S674C5_nt[];
extern  VTBL_ENTRY _ZTV9S674C5_nt[];
extern Class_Descriptor cd_S674C4_nt;
extern VTBL_ENTRY _ZTI9S674C4_nt[];
extern  VTBL_ENTRY _ZTV9S674C4_nt[];
extern Class_Descriptor cd_S674C3_nt;
extern VTBL_ENTRY _ZTI9S674C3_nt[];
extern  VTBL_ENTRY _ZTV9S674C3_nt[];
extern Class_Descriptor cd_S674C2_nt;
extern VTBL_ENTRY _ZTI9S674C2_nt[];
extern  VTBL_ENTRY _ZTV9S674C2_nt[];
static Base_Class bases_S674C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S674C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S674C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S674C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S674C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S674C1[];
extern void _ZN6S674C1D1Ev();
extern void _ZN6S674C1D0Ev();
extern void _ZN9S674C5_nt2v6Ev();
extern void _ZN9S674C5_nt2v7Ev();
extern void _ZN9S674C5_nt2v8Ev();
extern void _ZN9S674C5_nt2v9Ev();
extern void _ZN9S674C5_nt3v10Ev();
extern void _ZN9S674C5_nt3v11Ev();
extern void _ZN9S674C5_nt3v12Ev();
extern void _ZN9S674C5_nt3v13Ev();
extern void _ZN9S674C5_nt3v14Ev();
extern void _ZN9S674C5_nt3v15Ev();
extern void _ZN9S674C5_nt3v16Ev();
extern void _ZN9S674C5_nt3v17Ev();
extern void _ZN9S674C5_nt3v18Ev();
extern void _ZN9S674C5_nt3v19Ev();
extern void _ZN9S674C5_nt3v20Ev();
extern void _ZN9S674C5_nt3v21Ev();
extern void _ZN9S674C5_nt3v22Ev();
extern void _ZN9S674C5_nt3v23Ev();
extern void _ZN9S674C5_nt3v24Ev();
extern void _ZN9S674C5_nt3v25Ev();
extern void _ZN9S674C5_nt3v26Ev();
extern void _ZN9S674C5_nt3v27Ev();
extern void _ZN9S674C5_nt3v28Ev();
extern void _ZN9S674C5_nt3v29Ev();
extern void _ZN9S674C5_nt3v30Ev();
extern void _ZN9S674C5_nt3v31Ev();
extern void _ZN9S674C5_nt3v32Ev();
extern void _ZN9S674C5_nt3v33Ev();
extern void _ZN9S674C5_nt3v34Ev();
extern void _ZN9S674C5_nt3v35Ev();
extern void _ZN9S674C5_nt3v36Ev();
extern void _ZN9S674C5_nt3v37Ev();
extern void _ZN9S674C5_nt3v38Ev();
extern void _ZN9S674C5_nt3v39Ev();
extern void _ZN9S674C5_nt3v40Ev();
extern void _ZN9S674C5_nt3v41Ev();
extern void _ZN9S674C5_nt3v42Ev();
extern void _ZN9S674C5_nt3v43Ev();
extern void _ZN9S674C5_nt3v44Ev();
extern void _ZN9S674C5_nt3v45Ev();
extern void _ZN9S674C5_nt3v46Ev();
extern void _ZN9S674C5_nt3v47Ev();
extern void _ZN9S674C5_nt3v48Ev();
extern void _ZN9S674C5_nt3v49Ev();
extern void _ZN9S674C5_nt3v50Ev();
extern void _ZN9S674C5_nt3v51Ev();
extern void _ZN9S674C5_nt3v52Ev();
extern void _ZN9S674C5_nt3v53Ev();
extern void _ZN9S674C5_nt3v54Ev();
extern void _ZN9S674C5_nt3v55Ev();
extern void _ZN9S674C5_nt3v56Ev();
extern void _ZN9S674C5_nt3v57Ev();
extern void _ZN9S674C5_nt3v58Ev();
extern void _ZN9S674C5_nt3v59Ev();
extern void _ZN9S674C5_nt3v60Ev();
extern void _ZN9S674C5_nt3v61Ev();
extern void _ZN9S674C5_nt3v62Ev();
extern void _ZN9S674C5_nt3v63Ev();
extern void _ZN9S674C5_nt3v64Ev();
extern void _ZN9S674C5_nt3v65Ev();
extern void _ZN9S674C5_nt3v66Ev();
extern void _ZN9S674C5_nt3v67Ev();
extern void _ZN9S674C5_nt3v68Ev();
extern void _ZN9S674C5_nt3v69Ev();
extern void _ZN9S674C4_nt3v70Ev();
extern void _ZN9S674C4_nt3v71Ev();
extern void _ZN9S674C3_nt3v72Ev();
extern void _ZN9S674C3_nt3v73Ev();
extern void _ZN9S674C3_nt3v74Ev();
extern void _ZN9S674C3_nt3v75Ev();
extern void _ZN9S674C3_nt3v76Ev();
extern void _ZN9S674C3_nt3v77Ev();
extern void _ZN9S674C3_nt3v78Ev();
extern void _ZN9S674C3_nt3v79Ev();
extern void _ZN9S674C3_nt3v80Ev();
extern void _ZN9S674C3_nt3v81Ev();
extern void _ZN9S674C3_nt3v82Ev();
extern void _ZN9S674C3_nt3v83Ev();
extern void _ZN9S674C3_nt3v84Ev();
extern void _ZN9S674C3_nt3v85Ev();
extern void _ZN9S674C3_nt3v86Ev();
extern void _ZN9S674C3_nt3v87Ev();
extern void _ZN9S674C3_nt3v88Ev();
extern void _ZN9S674C3_nt3v89Ev();
extern void _ZN9S674C3_nt3v90Ev();
extern void _ZN9S674C3_nt3v91Ev();
extern void _ZN9S674C3_nt3v92Ev();
extern void _ZN9S674C3_nt3v93Ev();
extern void _ZN9S674C3_nt3v94Ev();
extern void _ZN9S674C3_nt3v95Ev();
extern void _ZN9S674C3_nt3v96Ev();
extern void _ZN9S674C3_nt3v97Ev();
extern void _ZN9S674C3_nt3v98Ev();
extern void _ZN9S674C3_nt3v99Ev();
extern void _ZN9S674C3_nt4v100Ev();
extern void _ZN9S674C3_nt4v101Ev();
extern void _ZN9S674C3_nt4v102Ev();
extern void _ZN9S674C3_nt4v103Ev();
extern void _ZN9S674C3_nt4v104Ev();
extern void _ZN9S674C3_nt4v105Ev();
extern void _ZN9S674C3_nt4v106Ev();
extern void _ZN9S674C3_nt4v107Ev();
extern void _ZN9S674C3_nt4v108Ev();
extern void _ZN9S674C3_nt4v109Ev();
extern void _ZN9S674C3_nt4v110Ev();
extern void _ZN9S674C3_nt4v111Ev();
extern void _ZN9S674C3_nt4v112Ev();
extern void _ZN9S674C3_nt4v113Ev();
extern void _ZN9S674C3_nt4v114Ev();
extern void _ZN9S674C3_nt4v115Ev();
extern void _ZN9S674C3_nt4v116Ev();
extern void _ZN9S674C3_nt4v117Ev();
extern void _ZN9S674C3_nt4v118Ev();
extern void _ZN9S674C3_nt4v119Ev();
extern void _ZN9S674C3_nt4v120Ev();
extern void _ZN9S674C3_nt4v121Ev();
extern void _ZN9S674C3_nt4v122Ev();
extern void _ZN9S674C3_nt4v123Ev();
extern void _ZN9S674C3_nt4v124Ev();
extern void _ZN9S674C3_nt4v125Ev();
extern void _ZN9S674C3_nt4v126Ev();
extern void _ZN9S674C3_nt4v127Ev();
extern void _ZN9S674C3_nt4v128Ev();
extern void _ZN9S674C3_nt4v129Ev();
extern void _ZN9S674C3_nt4v130Ev();
extern void _ZN9S674C3_nt4v131Ev();
extern void _ZN9S674C3_nt4v132Ev();
extern void _ZN9S674C3_nt4v133Ev();
extern void _ZN9S674C3_nt4v134Ev();
extern void _ZN9S674C3_nt4v135Ev();
extern void _ZN9S674C3_nt4v136Ev();
extern void _ZN9S674C3_nt4v137Ev();
extern void _ZN9S674C3_nt4v138Ev();
extern void _ZN9S674C3_nt4v139Ev();
extern void _ZN9S674C3_nt4v140Ev();
extern void _ZN9S674C3_nt4v141Ev();
extern void _ZN9S674C3_nt4v142Ev();
extern void _ZN9S674C3_nt4v143Ev();
extern void _ZN9S674C3_nt4v144Ev();
extern void _ZN9S674C3_nt4v145Ev();
extern void _ZN9S674C3_nt4v146Ev();
extern void _ZN9S674C3_nt4v147Ev();
extern void _ZN9S674C2_nt4v148Ev();
extern void _ZN9S674C2_nt4v149Ev();
extern void _ZN9S674C2_nt4v150Ev();
extern void _ZN9S674C2_nt4v151Ev();
extern void _ZN9S674C2_nt4v152Ev();
extern void _ZN9S674C2_nt4v153Ev();
extern void _ZN9S674C2_nt4v154Ev();
extern void _ZN9S674C2_nt4v155Ev();
extern void _ZN9S674C2_nt4v156Ev();
extern void _ZN9S674C2_nt4v157Ev();
extern void _ZN9S674C2_nt4v158Ev();
extern void _ZN9S674C2_nt4v159Ev();
extern void _ZN9S674C2_nt4v160Ev();
extern void _ZN9S674C2_nt4v161Ev();
extern void _ZN9S674C2_nt4v162Ev();
extern void _ZN9S674C2_nt4v163Ev();
extern void _ZN9S674C2_nt4v164Ev();
extern void _ZN9S674C2_nt4v165Ev();
extern void _ZN9S674C2_nt4v166Ev();
extern void _ZN9S674C2_nt4v167Ev();
extern void _ZN9S674C2_nt4v168Ev();
extern void _ZN9S674C2_nt4v169Ev();
extern void _ZN9S674C2_nt4v170Ev();
extern void _ZN9S674C2_nt4v171Ev();
extern void _ZN9S674C2_nt4v172Ev();
extern void _ZN9S674C2_nt4v173Ev();
extern void _ZN9S674C2_nt4v174Ev();
extern void _ZN9S674C2_nt4v175Ev();
extern void _ZN9S674C2_nt4v176Ev();
extern void _ZN9S674C2_nt4v177Ev();
extern void _ZN9S674C2_nt4v178Ev();
extern void _ZN9S674C2_nt4v179Ev();
extern void _ZN9S674C2_nt4v180Ev();
extern void _ZN9S674C2_nt4v181Ev();
extern void _ZN9S674C2_nt4v182Ev();
extern void _ZN9S674C2_nt4v183Ev();
extern void _ZN9S674C2_nt4v184Ev();
extern void _ZN9S674C2_nt4v185Ev();
extern void _ZN9S674C2_nt4v186Ev();
extern void _ZN9S674C2_nt4v187Ev();
extern void _ZN9S674C2_nt4v188Ev();
extern void _ZN9S674C2_nt4v189Ev();
extern void _ZN9S674C2_nt4v190Ev();
extern void _ZN9S674C2_nt4v191Ev();
extern void _ZN9S674C2_nt4v192Ev();
extern void _ZN9S674C2_nt4v193Ev();
extern void _ZN9S674C2_nt4v194Ev();
extern void _ZN9S674C2_nt4v195Ev();
extern void _ZN9S674C2_nt4v196Ev();
extern void _ZN9S674C2_nt4v197Ev();
extern void _ZN9S674C2_nt4v198Ev();
extern void _ZN9S674C2_nt4v199Ev();
extern void _ZN9S674C2_nt4v200Ev();
extern void _ZN9S674C2_nt4v201Ev();
extern void _ZN9S674C2_nt4v202Ev();
extern void _ZN9S674C2_nt4v203Ev();
extern void _ZN9S674C2_nt4v204Ev();
extern void _ZN9S674C2_nt4v205Ev();
extern void _ZN9S674C2_nt4v206Ev();
extern void _ZN9S674C2_nt4v207Ev();
extern void _ZN9S674C2_nt4v208Ev();
extern void _ZN9S674C2_nt4v209Ev();
extern void _ZN9S674C2_nt4v210Ev();
extern void _ZN9S674C2_nt4v211Ev();
extern void _ZN9S674C2_nt4v212Ev();
extern void _ZN9S674C2_nt4v213Ev();
extern void _ZN9S674C2_nt4v214Ev();
extern void _ZN9S674C2_nt4v215Ev();
extern void _ZN9S674C2_nt4v216Ev();
extern void _ZN6S674C12v1Ev();
extern void _ZN6S674C12v2Ev();
extern void _ZN6S674C12v3Ev();
extern void _ZN6S674C12v4Ev();
extern void _ZN6S674C12v5Ev();
static  VTBL_ENTRY vtc_S674C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S674C1[0]),
  (VTBL_ENTRY)&_ZN6S674C1D1Ev,
  (VTBL_ENTRY)&_ZN6S674C1D0Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S674C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S674C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S674C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S674C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v148Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v149Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v150Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v151Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v152Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v153Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v154Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v155Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v156Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v157Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v158Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v159Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v160Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v161Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v162Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v163Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v164Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v165Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v166Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v167Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v168Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v169Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v170Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v171Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v172Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v173Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v174Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v175Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v176Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v177Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v178Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v179Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v180Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v181Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v182Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v183Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v184Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v185Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v186Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v187Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v188Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v189Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v190Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v191Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v192Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v193Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v194Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v195Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v196Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v197Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v198Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v199Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v200Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v201Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v202Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v203Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v204Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v205Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v206Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v207Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v208Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v209Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v210Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v211Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v212Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v213Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v214Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v215Ev,
  (VTBL_ENTRY)&_ZN9S674C2_nt4v216Ev,
  (VTBL_ENTRY)&_ZN6S674C12v1Ev,
  (VTBL_ENTRY)&_ZN6S674C12v2Ev,
  (VTBL_ENTRY)&_ZN6S674C12v3Ev,
  (VTBL_ENTRY)&_ZN6S674C12v4Ev,
  (VTBL_ENTRY)&_ZN6S674C12v5Ev,
};
extern VTBL_ENTRY _ZTI6S674C1[];
extern  VTBL_ENTRY _ZTV6S674C1[];
Class_Descriptor cd_S674C1 = {  "S674C1", // class name
  bases_S674C1, 4,
  &(vtc_S674C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1272,936), // object size
  NSPAIRA(_ZTI6S674C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S674C1),220, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3625C6_nt  {
  void  mf3625c6(); // _ZN10S3625C6_nt8mf3625c6Ev
};
//SIG(-1 S3625C6_nt) C1{ m}


void  S3625C6_nt ::mf3625c6(){}

//skip512 S3625C6_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3625C4_nt  {
  void *s3625c4f0;
  int s3625c4f1;
  ::S674C30_nt s3625c4f2;
  ::S3625C6_nt s3625c4f3;
  void  mf3625c4(); // _ZN10S3625C4_nt8mf3625c4Ev
};
//SIG(-1 S3625C4_nt) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S3625C4_nt ::mf3625c4(){}

//skip512 S3625C4_nt

#else // __cplusplus

Class_Descriptor cd_S3625C4_nt = {  "S3625C4_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3625C3_nt  {
  ::S3625C4_nt s3625c3f0;
  ::S3625C4_nt s3625c3f1;
  char s3625c3f2;
  void  mf3625c3(); // _ZN10S3625C3_nt8mf3625c3Ev
  virtual  ~S3625C3_nt(); // _ZN10S3625C3_ntD1Ev
  S3625C3_nt(); // tgen
};
//SIG(-1 S3625C3_nt) C1{ vd m FC2{ m Fp Fi FC3{ m} FC4{ m}} FC2 Fc}


void  S3625C3_nt ::mf3625c3(){}
 S3625C3_nt ::~S3625C3_nt(){ note_dtor("S3625C3_nt", this);}
S3625C3_nt ::S3625C3_nt(){ note_ctor("S3625C3_nt", this);} // tgen

//skip512 S3625C3_nt

#else // __cplusplus

extern void _ZN10S3625C3_ntC1Ev();
extern void _ZN10S3625C3_ntD1Ev();
Name_Map name_map_S3625C3_nt[] = {
  NSPAIR(_ZN10S3625C3_ntC1Ev),
  NSPAIR(_ZN10S3625C3_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S3625C3_nt[];
extern void _ZN10S3625C3_ntD1Ev();
extern void _ZN10S3625C3_ntD0Ev();
static  VTBL_ENTRY vtc_S3625C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S3625C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S3625C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S3625C3_ntD0Ev,
};
extern VTBL_ENTRY _ZTI10S3625C3_nt[];
VTBL_ENTRY *P__ZTI10S3625C3_nt = _ZTI10S3625C3_nt; 
extern  VTBL_ENTRY _ZTV10S3625C3_nt[];
Class_Descriptor cd_S3625C3_nt = {  "S3625C3_nt", // class name
  0,0,//no base classes
  &(vtc_S3625C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI10S3625C3_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S3625C3_nt),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3625C10_nt  {
  char s3625c10f0;
  long s3625c10f1[2];
  short s3625c10f2[12];
  char s3625c10f3[5];
  void  mf3625c10(); // _ZN11S3625C10_nt9mf3625c10Ev
};
//SIG(-1 S3625C10_nt) C1{ m Fc Fl[2] Fs[12] Fc[5]}


void  S3625C10_nt ::mf3625c10(){}

//skip512 S3625C10_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3625C11_nt  {
  char s3625c11f0;
  long s3625c11f1[4];
  int s3625c11f2[4];
  void  mf3625c11(); // _ZN11S3625C11_nt9mf3625c11Ev
};
//SIG(-1 S3625C11_nt) C1{ m Fc Fl[4] Fi[4]}


void  S3625C11_nt ::mf3625c11(){}

//skip512 S3625C11_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3625C14_nt  {
  __tsi64 s3625c14f0[4];
};
//SIG(-1 S3625C14_nt) C1{ FL[4]}



//skip512 S3625C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3625C13_nt  {
  ::S3625C14_nt s3625c13f0;
  void  mf3625c13(); // _ZN11S3625C13_nt9mf3625c13Ev
};
//SIG(-1 S3625C13_nt) C1{ m FC2{ FL[4]}}


void  S3625C13_nt ::mf3625c13(){}

//skip512 S3625C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3625C12_nt  {
  ::S3625C13_nt s3625c12f0;
  char s3625c12f1;
  void *s3625c12f2;
  int s3625c12f3[3];
  void  mf3625c12(); // _ZN11S3625C12_nt9mf3625c12Ev
};
//SIG(-1 S3625C12_nt) C1{ m FC2{ m FC3{ FL[4]}} Fc Fp Fi[3]}


void  S3625C12_nt ::mf3625c12(){}

//skip512 S3625C12_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3625C15_nt  {
  void *s3625c15f0;
  int s3625c15f1[2];
  ::S3625C6_nt s3625c15f2;
  void  mf3625c15(); // _ZN11S3625C15_nt9mf3625c15Ev
};
//SIG(-1 S3625C15_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S3625C15_nt ::mf3625c15(){}

//skip512 S3625C15_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3625C19  {
  void  mf3625c19(); // _ZN8S3625C199mf3625c19Ev
};
//SIG(-1 S3625C19) C1{ m}


void  S3625C19 ::mf3625c19(){}

static void Test_S3625C19()
{
  {
    init_simple_test("S3625C19");
    S3625C19 lv;
    check2(sizeof(lv), 1, "sizeof(S3625C19)");
    check2(__alignof__(lv), 1, "__alignof__(S3625C19)");
  }
}
static Arrange_To_Call_Me vS3625C19(Test_S3625C19, "S3625C19", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3625C18_nt  {
  void *s3625c18f0;
  int s3625c18f1;
  ::S3625C19 s3625c18f2;
  void  mf3625c18(); // _ZN11S3625C18_nt9mf3625c18Ev
};
//SIG(-1 S3625C18_nt) C1{ m Fp Fi FC2{ m}}


void  S3625C18_nt ::mf3625c18(){}

//skip512 S3625C18_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3625C24_nt  {
  char s3625c24f0[11];
  void  mf3625c24(); // _ZN11S3625C24_nt9mf3625c24Ev
};
//SIG(-1 S3625C24_nt) C1{ m Fc[11]}


void  S3625C24_nt ::mf3625c24(){}

//skip512 S3625C24_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3625C23_nt  {
  ::S3625C24_nt s3625c23f0;
  int s3625c23f1[7];
  __tsi64 s3625c23f2;
  void  mf3625c23(); // _ZN11S3625C23_nt9mf3625c23Ev
};
//SIG(-1 S3625C23_nt) C1{ m FC2{ m Fc[11]} Fi[7] FL}


void  S3625C23_nt ::mf3625c23(){}

//skip512 S3625C23_nt

#else // __cplusplus

Class_Descriptor cd_S3625C23_nt = {  "S3625C23_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  48, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3625C25  {
  void *s3625c25f0;
  int s3625c25f1[2];
  ::S3625C19 s3625c25f2;
  void  mf3625c25(); // _ZN8S3625C259mf3625c25Ev
};
//SIG(-1 S3625C25) C1{ m Fp Fi[2] FC2{ m}}


void  S3625C25 ::mf3625c25(){}

static void Test_S3625C25()
{
  {
    init_simple_test("S3625C25");
    S3625C25 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S3625C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3625C25)");
    check_field_offset(lv, s3625c25f0, 0, "S3625C25.s3625c25f0");
    check_field_offset(lv, s3625c25f1, ABISELECT(8,4), "S3625C25.s3625c25f1");
    check_field_offset(lv, s3625c25f2, ABISELECT(16,12), "S3625C25.s3625c25f2");
  }
}
static Arrange_To_Call_Me vS3625C25(Test_S3625C25, "S3625C25", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3625C22  : S3625C23_nt {
  int s3625c22f0;
  ::S3625C25 s3625c22f1;
  ::S3625C24_nt s3625c22f2;
  int s3625c22f3;
};
//SIG(-1 S3625C22) C1{ BC2{ m FC3{ m Fc[11]} Fi[7] FL} Fi FC4{ m Fp Fi[2] FC5{ m}} FC3 Fi}



static void Test_S3625C22()
{
  extern Class_Descriptor cd_S3625C22;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,22)];
    init_test(&cd_S3625C22, buf);
    S3625C22 &lv = *(new (buf) S3625C22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,84), "sizeof(S3625C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3625C22)");
    check_base_class_offset(lv, (S3625C23_nt*), 0, "S3625C22");
    check_field_offset(lv, s3625c22f0, 48, "S3625C22.s3625c22f0");
    check_field_offset(lv, s3625c22f1, ABISELECT(56,52), "S3625C22.s3625c22f1");
    check_field_offset(lv, s3625c22f2, ABISELECT(80,68), "S3625C22.s3625c22f2");
    check_field_offset(lv, s3625c22f3, ABISELECT(92,80), "S3625C22.s3625c22f3");
    test_class_info(&lv, &cd_S3625C22);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3625C22(Test_S3625C22, "S3625C22", ABISELECT(96,84));

#else // __cplusplus

extern Class_Descriptor cd_S3625C23_nt;
static Base_Class bases_S3625C22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3625C23_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3625C22 = {  "S3625C22", // class name
  bases_S3625C22, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(96,84), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3625C32  {
  void  mf3625c32(); // _ZN8S3625C329mf3625c32Ev
};
//SIG(-1 S3625C32) C1{ m}


void  S3625C32 ::mf3625c32(){}

static void Test_S3625C32()
{
  {
    init_simple_test("S3625C32");
    S3625C32 lv;
    check2(sizeof(lv), 1, "sizeof(S3625C32)");
    check2(__alignof__(lv), 1, "__alignof__(S3625C32)");
  }
}
static Arrange_To_Call_Me vS3625C32(Test_S3625C32, "S3625C32", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S3625C32[];
VTBL_ENTRY *P__ZTI8S3625C32 = _ZTI8S3625C32; 
Class_Descriptor cd_S3625C32 = {  "S3625C32", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S3625C32),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3625C31  {
  void *s3625c31f0;
  int s3625c31f1[2];
  ::S3625C32 s3625c31f2;
  void  mf3625c31(); // _ZN8S3625C319mf3625c31Ev
};
//SIG(-1 S3625C31) C1{ m Fp Fi[2] FC2{ m}}


void  S3625C31 ::mf3625c31(){}

static void Test_S3625C31()
{
  {
    init_simple_test("S3625C31");
    S3625C31 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S3625C31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3625C31)");
    check_field_offset(lv, s3625c31f0, 0, "S3625C31.s3625c31f0");
    check_field_offset(lv, s3625c31f1, ABISELECT(8,4), "S3625C31.s3625c31f1");
    check_field_offset(lv, s3625c31f2, ABISELECT(16,12), "S3625C31.s3625c31f2");
  }
}
static Arrange_To_Call_Me vS3625C31(Test_S3625C31, "S3625C31", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3625C28_nt  {
  void *s3625c28f0;
  ::S3625C13_nt s3625c28f1;
  __tsi64 s3625c28f2[2];
  int s3625c28f3;
  __tsi64 s3625c28f4;
  int s3625c28f5[2];
  char s3625c28f6;
  ::S3625C18_nt s3625c28f7;
  ::S3625C18_nt s3625c28f8;
  __tsi64 s3625c28f9[5];
  char s3625c28f10;
  int s3625c28f11;
  ::S3625C25 s3625c28f12;
  ::S3625C25 s3625c28f13;
  ::S3625C25 s3625c28f14;
  ::S3625C25 s3625c28f15;
  ::S3625C31 s3625c28f16;
  int s3625c28f17[2];
  void  mf3625c28(); // _ZN11S3625C28_nt9mf3625c28Ev
};
//SIG(-1 S3625C28_nt) C1{ m Fp FC2{ m FC3{ FL[4]}} FL[2] Fi FL Fi[2] Fc FC4{ m Fp Fi FC5{ m}} FC4 FL[5] Fc Fi FC6{ m Fp Fi[2] FC5} FC6 FC6 FC6 FC7{ m Fp Fi[2] FC8{ m}} Fi[2]}


void  S3625C28_nt ::mf3625c28(){}

//skip512 S3625C28_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3625C2  : S3625C3_nt {
  int s3625c2f0[3];
  ::S3625C10_nt s3625c2f1;
  ::S3625C11_nt s3625c2f2;
  int s3625c2f3[3];
  void *s3625c2f4;
  char s3625c2f5[3];
  ::S3625C12_nt s3625c2f6;
  int s3625c2f7;
  ::S3625C15_nt s3625c2f8;
  void *s3625c2f9;
  int s3625c2f10[2];
  ::S3625C13_nt s3625c2f11;
  ::S3625C13_nt s3625c2f12;
  int s3625c2f13[3];
  char s3625c2f14[6144];
  ::S3625C18_nt s3625c2f15;
  ::S3625C15_nt s3625c2f16;
  char s3625c2f17;
  int s3625c2f18;
  char s3625c2f19;
  int s3625c2f20[5];
  __tsi64 s3625c2f21[7];
  char s3625c2f22;
  __tsi64 s3625c2f23[9];
  int s3625c2f24[2];
  ::S3625C22 s3625c2f25;
  ::S3625C28_nt s3625c2f26;
  void *s3625c2f27[3];
  __tsi64 s3625c2f28[2];
  ::S3625C18_nt s3625c2f29;
  int s3625c2f30;
  char s3625c2f31;
  __tsi64 s3625c2f32;
  char s3625c2f33;
  __tsi64 s3625c2f34;
  virtual  ~S3625C2(); // _ZN7S3625C2D1Ev
  virtual void  v93(); // _ZN7S3625C23v93Ev
  virtual void  v94(); // _ZN7S3625C23v94Ev
  virtual void  v95(); // _ZN7S3625C23v95Ev
  virtual void  v96(); // _ZN7S3625C23v96Ev
  virtual void  v97(); // _ZN7S3625C23v97Ev
  virtual void  v98(); // _ZN7S3625C23v98Ev
  virtual void  v99(); // _ZN7S3625C23v99Ev
  virtual void  v100(); // _ZN7S3625C24v100Ev
  virtual void  v101(); // _ZN7S3625C24v101Ev
  virtual void  v102(); // _ZN7S3625C24v102Ev
  virtual void  v103(); // _ZN7S3625C24v103Ev
  virtual void  v104(); // _ZN7S3625C24v104Ev
  virtual void  v105(); // _ZN7S3625C24v105Ev
  virtual void  v106(); // _ZN7S3625C24v106Ev
  virtual void  v107(); // _ZN7S3625C24v107Ev
  virtual void  v108(); // _ZN7S3625C24v108Ev
  virtual void  v109(); // _ZN7S3625C24v109Ev
  virtual void  v110(); // _ZN7S3625C24v110Ev
  virtual void  v111(); // _ZN7S3625C24v111Ev
  virtual void  v112(); // _ZN7S3625C24v112Ev
  virtual void  v113(); // _ZN7S3625C24v113Ev
  virtual void  v114(); // _ZN7S3625C24v114Ev
  virtual void  v115(); // _ZN7S3625C24v115Ev
  virtual void  v116(); // _ZN7S3625C24v116Ev
  virtual void  v117(); // _ZN7S3625C24v117Ev
  virtual void  v118(); // _ZN7S3625C24v118Ev
  virtual void  v119(); // _ZN7S3625C24v119Ev
  virtual void  v120(); // _ZN7S3625C24v120Ev
  virtual void  v121(); // _ZN7S3625C24v121Ev
  virtual void  v122(); // _ZN7S3625C24v122Ev
  virtual void  v123(); // _ZN7S3625C24v123Ev
  virtual void  v124(); // _ZN7S3625C24v124Ev
  virtual void  v125(); // _ZN7S3625C24v125Ev
  virtual void  v126(); // _ZN7S3625C24v126Ev
  virtual void  v127(); // _ZN7S3625C24v127Ev
  virtual void  v128(); // _ZN7S3625C24v128Ev
  virtual void  v129(); // _ZN7S3625C24v129Ev
  virtual void  v130(); // _ZN7S3625C24v130Ev
  virtual void  v131(); // _ZN7S3625C24v131Ev
  virtual void  v132(); // _ZN7S3625C24v132Ev
  virtual void  v133(); // _ZN7S3625C24v133Ev
  virtual void  v134(); // _ZN7S3625C24v134Ev
  virtual void  v135(); // _ZN7S3625C24v135Ev
  virtual void  v136(); // _ZN7S3625C24v136Ev
  virtual void  v137(); // _ZN7S3625C24v137Ev
  virtual void  v138(); // _ZN7S3625C24v138Ev
  virtual void  v139(); // _ZN7S3625C24v139Ev
  virtual void  v140(); // _ZN7S3625C24v140Ev
  virtual void  v141(); // _ZN7S3625C24v141Ev
  virtual void  v142(); // _ZN7S3625C24v142Ev
  virtual void  v143(); // _ZN7S3625C24v143Ev
  virtual void  v144(); // _ZN7S3625C24v144Ev
  virtual void  v145(); // _ZN7S3625C24v145Ev
  virtual void  v146(); // _ZN7S3625C24v146Ev
  virtual void  v147(); // _ZN7S3625C24v147Ev
  virtual void  v148(); // _ZN7S3625C24v148Ev
  virtual void  v149(); // _ZN7S3625C24v149Ev
  virtual void  v150(); // _ZN7S3625C24v150Ev
  virtual void  v151(); // _ZN7S3625C24v151Ev
  virtual void  v152(); // _ZN7S3625C24v152Ev
  virtual void  v153(); // _ZN7S3625C24v153Ev
  virtual void  v154(); // _ZN7S3625C24v154Ev
  virtual void  v155(); // _ZN7S3625C24v155Ev
  virtual void  v156(); // _ZN7S3625C24v156Ev
  virtual void  v157(); // _ZN7S3625C24v157Ev
  virtual void  v158(); // _ZN7S3625C24v158Ev
  virtual void  v159(); // _ZN7S3625C24v159Ev
  virtual void  v160(); // _ZN7S3625C24v160Ev
  virtual void  v161(); // _ZN7S3625C24v161Ev
  virtual void  v162(); // _ZN7S3625C24v162Ev
  virtual void  v163(); // _ZN7S3625C24v163Ev
  virtual void  v164(); // _ZN7S3625C24v164Ev
  virtual void  v165(); // _ZN7S3625C24v165Ev
  virtual void  v166(); // _ZN7S3625C24v166Ev
  virtual void  v167(); // _ZN7S3625C24v167Ev
  virtual void  v168(); // _ZN7S3625C24v168Ev
  virtual void  v169(); // _ZN7S3625C24v169Ev
  virtual void  v170(); // _ZN7S3625C24v170Ev
  virtual void  v171(); // _ZN7S3625C24v171Ev
  virtual void  v172(); // _ZN7S3625C24v172Ev
  virtual void  v173(); // _ZN7S3625C24v173Ev
  virtual void  v174(); // _ZN7S3625C24v174Ev
  virtual void  v175(); // _ZN7S3625C24v175Ev
  virtual void  v176(); // _ZN7S3625C24v176Ev
  virtual void  v177(); // _ZN7S3625C24v177Ev
  virtual void  v178(); // _ZN7S3625C24v178Ev
  virtual void  v179(); // _ZN7S3625C24v179Ev
  virtual void  v180(); // _ZN7S3625C24v180Ev
  virtual void  v181(); // _ZN7S3625C24v181Ev
  virtual void  v182(); // _ZN7S3625C24v182Ev
  virtual void  v183(); // _ZN7S3625C24v183Ev
  virtual void  v184(); // _ZN7S3625C24v184Ev
  virtual void  v185(); // _ZN7S3625C24v185Ev
  virtual void  v186(); // _ZN7S3625C24v186Ev
  virtual void  v187(); // _ZN7S3625C24v187Ev
  virtual void  v188(); // _ZN7S3625C24v188Ev
  virtual void  v189(); // _ZN7S3625C24v189Ev
  S3625C2(); // tgen
};
//SIG(-1 S3625C2) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 Fi[3] FC6{ m Fc Fl[2] Fs[12] Fc[5]} FC7{ m Fc Fl[4] Fi[4]} Fi[3] Fp Fc[3] FC8{ m FC9{ m FC10{ FL[4]}} Fc Fp Fi[3]} Fi FC11{ m Fp Fi[2] FC5} Fp Fi[2] FC9 FC9 Fi[3] Fc[6144] FC12{ m Fp Fi FC13{ m}} FC11 Fc Fi Fc Fi[5] FL[7] Fc FL[9] Fi[2] FC14{ BC15{ m FC16{ m Fc[11]} Fi[7] FL} Fi FC17{ m Fp Fi[2] FC13} FC16 Fi} FC18{ m Fp FC9 FL[2] Fi FL Fi[2] Fc FC12 FC12 FL[5] Fc Fi FC17 FC17 FC17 FC17 FC19{ m Fp Fi[2] FC20{ m}} Fi[2]} Fp[3] FL[2] FC12 Fi Fc FL Fc FL}


 S3625C2 ::~S3625C2(){ note_dtor("S3625C2", this);}
void  S3625C2 ::v93(){vfunc_called(this, "_ZN7S3625C23v93Ev");}
void  S3625C2 ::v94(){vfunc_called(this, "_ZN7S3625C23v94Ev");}
void  S3625C2 ::v95(){vfunc_called(this, "_ZN7S3625C23v95Ev");}
void  S3625C2 ::v96(){vfunc_called(this, "_ZN7S3625C23v96Ev");}
void  S3625C2 ::v97(){vfunc_called(this, "_ZN7S3625C23v97Ev");}
void  S3625C2 ::v98(){vfunc_called(this, "_ZN7S3625C23v98Ev");}
void  S3625C2 ::v99(){vfunc_called(this, "_ZN7S3625C23v99Ev");}
void  S3625C2 ::v100(){vfunc_called(this, "_ZN7S3625C24v100Ev");}
void  S3625C2 ::v101(){vfunc_called(this, "_ZN7S3625C24v101Ev");}
void  S3625C2 ::v102(){vfunc_called(this, "_ZN7S3625C24v102Ev");}
void  S3625C2 ::v103(){vfunc_called(this, "_ZN7S3625C24v103Ev");}
void  S3625C2 ::v104(){vfunc_called(this, "_ZN7S3625C24v104Ev");}
void  S3625C2 ::v105(){vfunc_called(this, "_ZN7S3625C24v105Ev");}
void  S3625C2 ::v106(){vfunc_called(this, "_ZN7S3625C24v106Ev");}
void  S3625C2 ::v107(){vfunc_called(this, "_ZN7S3625C24v107Ev");}
void  S3625C2 ::v108(){vfunc_called(this, "_ZN7S3625C24v108Ev");}
void  S3625C2 ::v109(){vfunc_called(this, "_ZN7S3625C24v109Ev");}
void  S3625C2 ::v110(){vfunc_called(this, "_ZN7S3625C24v110Ev");}
void  S3625C2 ::v111(){vfunc_called(this, "_ZN7S3625C24v111Ev");}
void  S3625C2 ::v112(){vfunc_called(this, "_ZN7S3625C24v112Ev");}
void  S3625C2 ::v113(){vfunc_called(this, "_ZN7S3625C24v113Ev");}
void  S3625C2 ::v114(){vfunc_called(this, "_ZN7S3625C24v114Ev");}
void  S3625C2 ::v115(){vfunc_called(this, "_ZN7S3625C24v115Ev");}
void  S3625C2 ::v116(){vfunc_called(this, "_ZN7S3625C24v116Ev");}
void  S3625C2 ::v117(){vfunc_called(this, "_ZN7S3625C24v117Ev");}
void  S3625C2 ::v118(){vfunc_called(this, "_ZN7S3625C24v118Ev");}
void  S3625C2 ::v119(){vfunc_called(this, "_ZN7S3625C24v119Ev");}
void  S3625C2 ::v120(){vfunc_called(this, "_ZN7S3625C24v120Ev");}
void  S3625C2 ::v121(){vfunc_called(this, "_ZN7S3625C24v121Ev");}
void  S3625C2 ::v122(){vfunc_called(this, "_ZN7S3625C24v122Ev");}
void  S3625C2 ::v123(){vfunc_called(this, "_ZN7S3625C24v123Ev");}
void  S3625C2 ::v124(){vfunc_called(this, "_ZN7S3625C24v124Ev");}
void  S3625C2 ::v125(){vfunc_called(this, "_ZN7S3625C24v125Ev");}
void  S3625C2 ::v126(){vfunc_called(this, "_ZN7S3625C24v126Ev");}
void  S3625C2 ::v127(){vfunc_called(this, "_ZN7S3625C24v127Ev");}
void  S3625C2 ::v128(){vfunc_called(this, "_ZN7S3625C24v128Ev");}
void  S3625C2 ::v129(){vfunc_called(this, "_ZN7S3625C24v129Ev");}
void  S3625C2 ::v130(){vfunc_called(this, "_ZN7S3625C24v130Ev");}
void  S3625C2 ::v131(){vfunc_called(this, "_ZN7S3625C24v131Ev");}
void  S3625C2 ::v132(){vfunc_called(this, "_ZN7S3625C24v132Ev");}
void  S3625C2 ::v133(){vfunc_called(this, "_ZN7S3625C24v133Ev");}
void  S3625C2 ::v134(){vfunc_called(this, "_ZN7S3625C24v134Ev");}
void  S3625C2 ::v135(){vfunc_called(this, "_ZN7S3625C24v135Ev");}
void  S3625C2 ::v136(){vfunc_called(this, "_ZN7S3625C24v136Ev");}
void  S3625C2 ::v137(){vfunc_called(this, "_ZN7S3625C24v137Ev");}
void  S3625C2 ::v138(){vfunc_called(this, "_ZN7S3625C24v138Ev");}
void  S3625C2 ::v139(){vfunc_called(this, "_ZN7S3625C24v139Ev");}
void  S3625C2 ::v140(){vfunc_called(this, "_ZN7S3625C24v140Ev");}
void  S3625C2 ::v141(){vfunc_called(this, "_ZN7S3625C24v141Ev");}
void  S3625C2 ::v142(){vfunc_called(this, "_ZN7S3625C24v142Ev");}
void  S3625C2 ::v143(){vfunc_called(this, "_ZN7S3625C24v143Ev");}
void  S3625C2 ::v144(){vfunc_called(this, "_ZN7S3625C24v144Ev");}
void  S3625C2 ::v145(){vfunc_called(this, "_ZN7S3625C24v145Ev");}
void  S3625C2 ::v146(){vfunc_called(this, "_ZN7S3625C24v146Ev");}
void  S3625C2 ::v147(){vfunc_called(this, "_ZN7S3625C24v147Ev");}
void  S3625C2 ::v148(){vfunc_called(this, "_ZN7S3625C24v148Ev");}
void  S3625C2 ::v149(){vfunc_called(this, "_ZN7S3625C24v149Ev");}
void  S3625C2 ::v150(){vfunc_called(this, "_ZN7S3625C24v150Ev");}
void  S3625C2 ::v151(){vfunc_called(this, "_ZN7S3625C24v151Ev");}
void  S3625C2 ::v152(){vfunc_called(this, "_ZN7S3625C24v152Ev");}
void  S3625C2 ::v153(){vfunc_called(this, "_ZN7S3625C24v153Ev");}
void  S3625C2 ::v154(){vfunc_called(this, "_ZN7S3625C24v154Ev");}
void  S3625C2 ::v155(){vfunc_called(this, "_ZN7S3625C24v155Ev");}
void  S3625C2 ::v156(){vfunc_called(this, "_ZN7S3625C24v156Ev");}
void  S3625C2 ::v157(){vfunc_called(this, "_ZN7S3625C24v157Ev");}
void  S3625C2 ::v158(){vfunc_called(this, "_ZN7S3625C24v158Ev");}
void  S3625C2 ::v159(){vfunc_called(this, "_ZN7S3625C24v159Ev");}
void  S3625C2 ::v160(){vfunc_called(this, "_ZN7S3625C24v160Ev");}
void  S3625C2 ::v161(){vfunc_called(this, "_ZN7S3625C24v161Ev");}
void  S3625C2 ::v162(){vfunc_called(this, "_ZN7S3625C24v162Ev");}
void  S3625C2 ::v163(){vfunc_called(this, "_ZN7S3625C24v163Ev");}
void  S3625C2 ::v164(){vfunc_called(this, "_ZN7S3625C24v164Ev");}
void  S3625C2 ::v165(){vfunc_called(this, "_ZN7S3625C24v165Ev");}
void  S3625C2 ::v166(){vfunc_called(this, "_ZN7S3625C24v166Ev");}
void  S3625C2 ::v167(){vfunc_called(this, "_ZN7S3625C24v167Ev");}
void  S3625C2 ::v168(){vfunc_called(this, "_ZN7S3625C24v168Ev");}
void  S3625C2 ::v169(){vfunc_called(this, "_ZN7S3625C24v169Ev");}
void  S3625C2 ::v170(){vfunc_called(this, "_ZN7S3625C24v170Ev");}
void  S3625C2 ::v171(){vfunc_called(this, "_ZN7S3625C24v171Ev");}
void  S3625C2 ::v172(){vfunc_called(this, "_ZN7S3625C24v172Ev");}
void  S3625C2 ::v173(){vfunc_called(this, "_ZN7S3625C24v173Ev");}
void  S3625C2 ::v174(){vfunc_called(this, "_ZN7S3625C24v174Ev");}
void  S3625C2 ::v175(){vfunc_called(this, "_ZN7S3625C24v175Ev");}
void  S3625C2 ::v176(){vfunc_called(this, "_ZN7S3625C24v176Ev");}
void  S3625C2 ::v177(){vfunc_called(this, "_ZN7S3625C24v177Ev");}
void  S3625C2 ::v178(){vfunc_called(this, "_ZN7S3625C24v178Ev");}
void  S3625C2 ::v179(){vfunc_called(this, "_ZN7S3625C24v179Ev");}
void  S3625C2 ::v180(){vfunc_called(this, "_ZN7S3625C24v180Ev");}
void  S3625C2 ::v181(){vfunc_called(this, "_ZN7S3625C24v181Ev");}
void  S3625C2 ::v182(){vfunc_called(this, "_ZN7S3625C24v182Ev");}
void  S3625C2 ::v183(){vfunc_called(this, "_ZN7S3625C24v183Ev");}
void  S3625C2 ::v184(){vfunc_called(this, "_ZN7S3625C24v184Ev");}
void  S3625C2 ::v185(){vfunc_called(this, "_ZN7S3625C24v185Ev");}
void  S3625C2 ::v186(){vfunc_called(this, "_ZN7S3625C24v186Ev");}
void  S3625C2 ::v187(){vfunc_called(this, "_ZN7S3625C24v187Ev");}
void  S3625C2 ::v188(){vfunc_called(this, "_ZN7S3625C24v188Ev");}
void  S3625C2 ::v189(){vfunc_called(this, "_ZN7S3625C24v189Ev");}
S3625C2 ::S3625C2(){ note_ctor("S3625C2", this);} // tgen

static void Test_S3625C2()
{
  extern Class_Descriptor cd_S3625C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(905,1760)];
    init_test(&cd_S3625C2, buf);
    S3625C2 *dp, &lv = *(dp=new (buf) S3625C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(7232,7036), "sizeof(S3625C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3625C2)");
    check_base_class_offset(lv, (S3625C3_nt*), 0, "S3625C2");
    check_field_offset(lv, s3625c2f0, ABISELECT(44,32), "S3625C2.s3625c2f0");
    check_field_offset(lv, s3625c2f1, ABISELECT(56,44), "S3625C2.s3625c2f1");
    check_field_offset(lv, s3625c2f2, ABISELECT(112,88), "S3625C2.s3625c2f2");
    check_field_offset(lv, s3625c2f3, ABISELECT(168,124), "S3625C2.s3625c2f3");
    check_field_offset(lv, s3625c2f4, ABISELECT(184,136), "S3625C2.s3625c2f4");
    check_field_offset(lv, s3625c2f5, ABISELECT(192,140), "S3625C2.s3625c2f5");
    check_field_offset(lv, s3625c2f6, ABISELECT(200,144), "S3625C2.s3625c2f6");
    check_field_offset(lv, s3625c2f7, ABISELECT(264,196), "S3625C2.s3625c2f7");
    check_field_offset(lv, s3625c2f8, ABISELECT(272,200), "S3625C2.s3625c2f8");
    check_field_offset(lv, s3625c2f9, ABISELECT(296,216), "S3625C2.s3625c2f9");
    check_field_offset(lv, s3625c2f10, ABISELECT(304,220), "S3625C2.s3625c2f10");
    check_field_offset(lv, s3625c2f11, ABISELECT(312,228), "S3625C2.s3625c2f11");
    check_field_offset(lv, s3625c2f12, ABISELECT(344,260), "S3625C2.s3625c2f12");
    check_field_offset(lv, s3625c2f13, ABISELECT(376,292), "S3625C2.s3625c2f13");
    check_field_offset(lv, s3625c2f14, ABISELECT(388,304), "S3625C2.s3625c2f14");
    check_field_offset(lv, s3625c2f15, ABISELECT(6536,6448), "S3625C2.s3625c2f15");
    check_field_offset(lv, s3625c2f16, ABISELECT(6552,6460), "S3625C2.s3625c2f16");
    check_field_offset(lv, s3625c2f17, ABISELECT(6576,6476), "S3625C2.s3625c2f17");
    check_field_offset(lv, s3625c2f18, ABISELECT(6580,6480), "S3625C2.s3625c2f18");
    check_field_offset(lv, s3625c2f19, ABISELECT(6584,6484), "S3625C2.s3625c2f19");
    check_field_offset(lv, s3625c2f20, ABISELECT(6588,6488), "S3625C2.s3625c2f20");
    check_field_offset(lv, s3625c2f21, ABISELECT(6608,6508), "S3625C2.s3625c2f21");
    check_field_offset(lv, s3625c2f22, ABISELECT(6664,6564), "S3625C2.s3625c2f22");
    check_field_offset(lv, s3625c2f23, ABISELECT(6672,6568), "S3625C2.s3625c2f23");
    check_field_offset(lv, s3625c2f24, ABISELECT(6744,6640), "S3625C2.s3625c2f24");
    check_field_offset(lv, s3625c2f25, ABISELECT(6752,6648), "S3625C2.s3625c2f25");
    check_field_offset(lv, s3625c2f26, ABISELECT(6848,6732), "S3625C2.s3625c2f26");
    check_field_offset(lv, s3625c2f27, ABISELECT(7144,6968), "S3625C2.s3625c2f27");
    check_field_offset(lv, s3625c2f28, ABISELECT(7168,6980), "S3625C2.s3625c2f28");
    check_field_offset(lv, s3625c2f29, ABISELECT(7184,6996), "S3625C2.s3625c2f29");
    check_field_offset(lv, s3625c2f30, ABISELECT(7200,7008), "S3625C2.s3625c2f30");
    check_field_offset(lv, s3625c2f31, ABISELECT(7204,7012), "S3625C2.s3625c2f31");
    check_field_offset(lv, s3625c2f32, ABISELECT(7208,7016), "S3625C2.s3625c2f32");
    check_field_offset(lv, s3625c2f33, ABISELECT(7216,7024), "S3625C2.s3625c2f33");
    check_field_offset(lv, s3625c2f34, ABISELECT(7224,7028), "S3625C2.s3625c2f34");
    test_class_info(&lv, &cd_S3625C2);
    dp->~S3625C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3625C2(Test_S3625C2, "S3625C2", ABISELECT(7232,7036));

#else // __cplusplus

extern void _ZN7S3625C2C1Ev();
extern void _ZN7S3625C2D1Ev();
Name_Map name_map_S3625C2[] = {
  NSPAIR(_ZN7S3625C2C1Ev),
  NSPAIR(_ZN7S3625C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3625C3_nt;
extern VTBL_ENTRY _ZTI10S3625C3_nt[];
extern  VTBL_ENTRY _ZTV10S3625C3_nt[];
static Base_Class bases_S3625C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3625C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3625C2[];
extern void _ZN7S3625C2D1Ev();
extern void _ZN7S3625C2D0Ev();
extern void _ZN7S3625C23v93Ev();
extern void _ZN7S3625C23v94Ev();
extern void _ZN7S3625C23v95Ev();
extern void _ZN7S3625C23v96Ev();
extern void _ZN7S3625C23v97Ev();
extern void _ZN7S3625C23v98Ev();
extern void _ZN7S3625C23v99Ev();
extern void _ZN7S3625C24v100Ev();
extern void _ZN7S3625C24v101Ev();
extern void _ZN7S3625C24v102Ev();
extern void _ZN7S3625C24v103Ev();
extern void _ZN7S3625C24v104Ev();
extern void _ZN7S3625C24v105Ev();
extern void _ZN7S3625C24v106Ev();
extern void _ZN7S3625C24v107Ev();
extern void _ZN7S3625C24v108Ev();
extern void _ZN7S3625C24v109Ev();
extern void _ZN7S3625C24v110Ev();
extern void _ZN7S3625C24v111Ev();
extern void _ZN7S3625C24v112Ev();
extern void _ZN7S3625C24v113Ev();
extern void _ZN7S3625C24v114Ev();
extern void _ZN7S3625C24v115Ev();
extern void _ZN7S3625C24v116Ev();
extern void _ZN7S3625C24v117Ev();
extern void _ZN7S3625C24v118Ev();
extern void _ZN7S3625C24v119Ev();
extern void _ZN7S3625C24v120Ev();
extern void _ZN7S3625C24v121Ev();
extern void _ZN7S3625C24v122Ev();
extern void _ZN7S3625C24v123Ev();
extern void _ZN7S3625C24v124Ev();
extern void _ZN7S3625C24v125Ev();
extern void _ZN7S3625C24v126Ev();
extern void _ZN7S3625C24v127Ev();
extern void _ZN7S3625C24v128Ev();
extern void _ZN7S3625C24v129Ev();
extern void _ZN7S3625C24v130Ev();
extern void _ZN7S3625C24v131Ev();
extern void _ZN7S3625C24v132Ev();
extern void _ZN7S3625C24v133Ev();
extern void _ZN7S3625C24v134Ev();
extern void _ZN7S3625C24v135Ev();
extern void _ZN7S3625C24v136Ev();
extern void _ZN7S3625C24v137Ev();
extern void _ZN7S3625C24v138Ev();
extern void _ZN7S3625C24v139Ev();
extern void _ZN7S3625C24v140Ev();
extern void _ZN7S3625C24v141Ev();
extern void _ZN7S3625C24v142Ev();
extern void _ZN7S3625C24v143Ev();
extern void _ZN7S3625C24v144Ev();
extern void _ZN7S3625C24v145Ev();
extern void _ZN7S3625C24v146Ev();
extern void _ZN7S3625C24v147Ev();
extern void _ZN7S3625C24v148Ev();
extern void _ZN7S3625C24v149Ev();
extern void _ZN7S3625C24v150Ev();
extern void _ZN7S3625C24v151Ev();
extern void _ZN7S3625C24v152Ev();
extern void _ZN7S3625C24v153Ev();
extern void _ZN7S3625C24v154Ev();
extern void _ZN7S3625C24v155Ev();
extern void _ZN7S3625C24v156Ev();
extern void _ZN7S3625C24v157Ev();
extern void _ZN7S3625C24v158Ev();
extern void _ZN7S3625C24v159Ev();
extern void _ZN7S3625C24v160Ev();
extern void _ZN7S3625C24v161Ev();
extern void _ZN7S3625C24v162Ev();
extern void _ZN7S3625C24v163Ev();
extern void _ZN7S3625C24v164Ev();
extern void _ZN7S3625C24v165Ev();
extern void _ZN7S3625C24v166Ev();
extern void _ZN7S3625C24v167Ev();
extern void _ZN7S3625C24v168Ev();
extern void _ZN7S3625C24v169Ev();
extern void _ZN7S3625C24v170Ev();
extern void _ZN7S3625C24v171Ev();
extern void _ZN7S3625C24v172Ev();
extern void _ZN7S3625C24v173Ev();
extern void _ZN7S3625C24v174Ev();
extern void _ZN7S3625C24v175Ev();
extern void _ZN7S3625C24v176Ev();
extern void _ZN7S3625C24v177Ev();
extern void _ZN7S3625C24v178Ev();
extern void _ZN7S3625C24v179Ev();
extern void _ZN7S3625C24v180Ev();
extern void _ZN7S3625C24v181Ev();
extern void _ZN7S3625C24v182Ev();
extern void _ZN7S3625C24v183Ev();
extern void _ZN7S3625C24v184Ev();
extern void _ZN7S3625C24v185Ev();
extern void _ZN7S3625C24v186Ev();
extern void _ZN7S3625C24v187Ev();
extern void _ZN7S3625C24v188Ev();
extern void _ZN7S3625C24v189Ev();
static  VTBL_ENTRY vtc_S3625C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3625C2[0]),
  (VTBL_ENTRY)&_ZN7S3625C2D1Ev,
  (VTBL_ENTRY)&_ZN7S3625C2D0Ev,
  (VTBL_ENTRY)&_ZN7S3625C23v93Ev,
  (VTBL_ENTRY)&_ZN7S3625C23v94Ev,
  (VTBL_ENTRY)&_ZN7S3625C23v95Ev,
  (VTBL_ENTRY)&_ZN7S3625C23v96Ev,
  (VTBL_ENTRY)&_ZN7S3625C23v97Ev,
  (VTBL_ENTRY)&_ZN7S3625C23v98Ev,
  (VTBL_ENTRY)&_ZN7S3625C23v99Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v100Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v101Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v102Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v103Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v104Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v105Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v106Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v107Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v108Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v109Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v110Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v111Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v112Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v113Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v114Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v115Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v116Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v117Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v118Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v119Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v120Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v121Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v122Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v123Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v124Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v125Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v126Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v127Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v128Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v129Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v130Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v131Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v132Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v133Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v134Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v135Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v136Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v137Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v138Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v139Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v140Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v141Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v142Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v143Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v144Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v145Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v146Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v147Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v148Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v149Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v150Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v151Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v152Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v153Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v154Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v155Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v156Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v157Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v158Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v159Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v160Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v161Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v162Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v163Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v164Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v165Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v166Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v167Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v168Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v169Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v170Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v171Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v172Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v173Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v174Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v175Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v176Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v177Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v178Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v179Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v180Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v181Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v182Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v183Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v184Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v185Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v186Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v187Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v188Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v189Ev,
};
extern VTBL_ENTRY _ZTI7S3625C2[];
extern  VTBL_ENTRY _ZTV7S3625C2[];
Class_Descriptor cd_S3625C2 = {  "S3625C2", // class name
  bases_S3625C2, 1,
  &(vtc_S3625C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(7232,7036), // object size
  NSPAIRA(_ZTI7S3625C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3625C2),101, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3625C33_nt  {
  void *s3625c33f0;
  void  mf3625c33(); // _ZN11S3625C33_nt9mf3625c33Ev
};
//SIG(-1 S3625C33_nt) C1{ m Fp}


void  S3625C33_nt ::mf3625c33(){}

//skip512 S3625C33_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI11S3625C33_nt[];
VTBL_ENTRY *P__ZTI11S3625C33_nt = _ZTI11S3625C33_nt; 
Class_Descriptor cd_S3625C33_nt = {  "S3625C33_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S3625C33_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3625C1  : S3625C2 {
  void *s3625c1f0;
  ::S3625C33_nt s3625c1f1;
  __tsi64 s3625c1f2;
  ::S3625C18_nt s3625c1f3;
  int s3625c1f4;
  virtual  ~S3625C1(); // _ZN7S3625C1D1Ev
  virtual void  v1(); // _ZN7S3625C12v1Ev
  virtual void  v2(); // _ZN7S3625C12v2Ev
  virtual void  v3(); // _ZN7S3625C12v3Ev
  virtual void  v4(); // _ZN7S3625C12v4Ev
  virtual void  v5(); // _ZN7S3625C12v5Ev
  virtual void  v6(); // _ZN7S3625C12v6Ev
  virtual void  v7(); // _ZN7S3625C12v7Ev
  virtual void  v8(); // _ZN7S3625C12v8Ev
  virtual void  v9(); // _ZN7S3625C12v9Ev
  virtual void  v10(); // _ZN7S3625C13v10Ev
  virtual void  v11(); // _ZN7S3625C13v11Ev
  virtual void  v12(); // _ZN7S3625C13v12Ev
  virtual void  v13(); // _ZN7S3625C13v13Ev
  virtual void  v14(); // _ZN7S3625C13v14Ev
  virtual void  v15(); // _ZN7S3625C13v15Ev
  virtual void  v16(); // _ZN7S3625C13v16Ev
  virtual void  v17(); // _ZN7S3625C13v17Ev
  virtual void  v18(); // _ZN7S3625C13v18Ev
  virtual void  v19(); // _ZN7S3625C13v19Ev
  virtual void  v20(); // _ZN7S3625C13v20Ev
  virtual void  v21(); // _ZN7S3625C13v21Ev
  virtual void  v22(); // _ZN7S3625C13v22Ev
  virtual void  v23(); // _ZN7S3625C13v23Ev
  virtual void  v24(); // _ZN7S3625C13v24Ev
  virtual void  v25(); // _ZN7S3625C13v25Ev
  virtual void  v26(); // _ZN7S3625C13v26Ev
  virtual void  v27(); // _ZN7S3625C13v27Ev
  virtual void  v28(); // _ZN7S3625C13v28Ev
  virtual void  v29(); // _ZN7S3625C13v29Ev
  virtual void  v30(); // _ZN7S3625C13v30Ev
  virtual void  v31(); // _ZN7S3625C13v31Ev
  virtual void  v32(); // _ZN7S3625C13v32Ev
  virtual void  v33(); // _ZN7S3625C13v33Ev
  virtual void  v34(); // _ZN7S3625C13v34Ev
  virtual void  v35(); // _ZN7S3625C13v35Ev
  virtual void  v36(); // _ZN7S3625C13v36Ev
  virtual void  v37(); // _ZN7S3625C13v37Ev
  virtual void  v38(); // _ZN7S3625C13v38Ev
  virtual void  v39(); // _ZN7S3625C13v39Ev
  virtual void  v40(); // _ZN7S3625C13v40Ev
  virtual void  v41(); // _ZN7S3625C13v41Ev
  virtual void  v42(); // _ZN7S3625C13v42Ev
  virtual void  v43(); // _ZN7S3625C13v43Ev
  virtual void  v44(); // _ZN7S3625C13v44Ev
  virtual void  v45(); // _ZN7S3625C13v45Ev
  virtual void  v46(); // _ZN7S3625C13v46Ev
  virtual void  v47(); // _ZN7S3625C13v47Ev
  virtual void  v48(); // _ZN7S3625C13v48Ev
  virtual void  v49(); // _ZN7S3625C13v49Ev
  virtual void  v50(); // _ZN7S3625C13v50Ev
  virtual void  v51(); // _ZN7S3625C13v51Ev
  virtual void  v52(); // _ZN7S3625C13v52Ev
  virtual void  v53(); // _ZN7S3625C13v53Ev
  virtual void  v54(); // _ZN7S3625C13v54Ev
  virtual void  v55(); // _ZN7S3625C13v55Ev
  virtual void  v56(); // _ZN7S3625C13v56Ev
  virtual void  v57(); // _ZN7S3625C13v57Ev
  virtual void  v58(); // _ZN7S3625C13v58Ev
  virtual void  v59(); // _ZN7S3625C13v59Ev
  virtual void  v60(); // _ZN7S3625C13v60Ev
  virtual void  v61(); // _ZN7S3625C13v61Ev
  virtual void  v62(); // _ZN7S3625C13v62Ev
  virtual void  v63(); // _ZN7S3625C13v63Ev
  virtual void  v64(); // _ZN7S3625C13v64Ev
  virtual void  v65(); // _ZN7S3625C13v65Ev
  virtual void  v66(); // _ZN7S3625C13v66Ev
  virtual void  v67(); // _ZN7S3625C13v67Ev
  virtual void  v68(); // _ZN7S3625C13v68Ev
  virtual void  v69(); // _ZN7S3625C13v69Ev
  virtual void  v70(); // _ZN7S3625C13v70Ev
  virtual void  v71(); // _ZN7S3625C13v71Ev
  virtual void  v72(); // _ZN7S3625C13v72Ev
  virtual void  v73(); // _ZN7S3625C13v73Ev
  virtual void  v74(); // _ZN7S3625C13v74Ev
  virtual void  v75(); // _ZN7S3625C13v75Ev
  virtual void  v76(); // _ZN7S3625C13v76Ev
  virtual void  v77(); // _ZN7S3625C13v77Ev
  virtual void  v78(); // _ZN7S3625C13v78Ev
  virtual void  v79(); // _ZN7S3625C13v79Ev
  virtual void  v80(); // _ZN7S3625C13v80Ev
  virtual void  v81(); // _ZN7S3625C13v81Ev
  virtual void  v82(); // _ZN7S3625C13v82Ev
  virtual void  v83(); // _ZN7S3625C13v83Ev
  virtual void  v84(); // _ZN7S3625C13v84Ev
  virtual void  v85(); // _ZN7S3625C13v85Ev
  virtual void  v86(); // _ZN7S3625C13v86Ev
  virtual void  v87(); // _ZN7S3625C13v87Ev
  virtual void  v88(); // _ZN7S3625C13v88Ev
  virtual void  v89(); // _ZN7S3625C13v89Ev
  virtual void  v90(); // _ZN7S3625C13v90Ev
  virtual void  v91(); // _ZN7S3625C13v91Ev
  virtual void  v92(); // _ZN7S3625C13v92Ev
  S3625C1(); // tgen
};
//SIG(1 S3625C1) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC6{ m}} FC4 Fc} vd v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 Fi[3] FC7{ m Fc Fl[2] Fs[12] Fc[5]} FC8{ m Fc Fl[4] Fi[4]} Fi[3] Fp Fc[3] FC9{ m FC10{ m FC11{ FL[4]}} Fc Fp Fi[3]} Fi FC12{ m Fp Fi[2] FC6} Fp Fi[2] FC10 FC10 Fi[3] Fc[6144] FC13{ m Fp Fi FC14{ m}} FC12 Fc Fi Fc Fi[5] FL[7] Fc FL[9] Fi[2] FC15{ BC16{ m FC17{ m Fc[11]} Fi[7] FL} Fi FC18{ m Fp Fi[2] FC14} FC17 Fi} FC19{ m Fp FC10 FL[2] Fi FL Fi[2] Fc FC13 FC13 FL[5] Fc Fi FC18 FC18 FC18 FC18 FC20{ m Fp Fi[2] FC21{ m}} Fi[2]} Fp[3] FL[2] FC13 Fi Fc FL Fc FL} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 Fp FC22{ m Fp} FL FC13 Fi}


 S3625C1 ::~S3625C1(){ note_dtor("S3625C1", this);}
void  S3625C1 ::v1(){vfunc_called(this, "_ZN7S3625C12v1Ev");}
void  S3625C1 ::v2(){vfunc_called(this, "_ZN7S3625C12v2Ev");}
void  S3625C1 ::v3(){vfunc_called(this, "_ZN7S3625C12v3Ev");}
void  S3625C1 ::v4(){vfunc_called(this, "_ZN7S3625C12v4Ev");}
void  S3625C1 ::v5(){vfunc_called(this, "_ZN7S3625C12v5Ev");}
void  S3625C1 ::v6(){vfunc_called(this, "_ZN7S3625C12v6Ev");}
void  S3625C1 ::v7(){vfunc_called(this, "_ZN7S3625C12v7Ev");}
void  S3625C1 ::v8(){vfunc_called(this, "_ZN7S3625C12v8Ev");}
void  S3625C1 ::v9(){vfunc_called(this, "_ZN7S3625C12v9Ev");}
void  S3625C1 ::v10(){vfunc_called(this, "_ZN7S3625C13v10Ev");}
void  S3625C1 ::v11(){vfunc_called(this, "_ZN7S3625C13v11Ev");}
void  S3625C1 ::v12(){vfunc_called(this, "_ZN7S3625C13v12Ev");}
void  S3625C1 ::v13(){vfunc_called(this, "_ZN7S3625C13v13Ev");}
void  S3625C1 ::v14(){vfunc_called(this, "_ZN7S3625C13v14Ev");}
void  S3625C1 ::v15(){vfunc_called(this, "_ZN7S3625C13v15Ev");}
void  S3625C1 ::v16(){vfunc_called(this, "_ZN7S3625C13v16Ev");}
void  S3625C1 ::v17(){vfunc_called(this, "_ZN7S3625C13v17Ev");}
void  S3625C1 ::v18(){vfunc_called(this, "_ZN7S3625C13v18Ev");}
void  S3625C1 ::v19(){vfunc_called(this, "_ZN7S3625C13v19Ev");}
void  S3625C1 ::v20(){vfunc_called(this, "_ZN7S3625C13v20Ev");}
void  S3625C1 ::v21(){vfunc_called(this, "_ZN7S3625C13v21Ev");}
void  S3625C1 ::v22(){vfunc_called(this, "_ZN7S3625C13v22Ev");}
void  S3625C1 ::v23(){vfunc_called(this, "_ZN7S3625C13v23Ev");}
void  S3625C1 ::v24(){vfunc_called(this, "_ZN7S3625C13v24Ev");}
void  S3625C1 ::v25(){vfunc_called(this, "_ZN7S3625C13v25Ev");}
void  S3625C1 ::v26(){vfunc_called(this, "_ZN7S3625C13v26Ev");}
void  S3625C1 ::v27(){vfunc_called(this, "_ZN7S3625C13v27Ev");}
void  S3625C1 ::v28(){vfunc_called(this, "_ZN7S3625C13v28Ev");}
void  S3625C1 ::v29(){vfunc_called(this, "_ZN7S3625C13v29Ev");}
void  S3625C1 ::v30(){vfunc_called(this, "_ZN7S3625C13v30Ev");}
void  S3625C1 ::v31(){vfunc_called(this, "_ZN7S3625C13v31Ev");}
void  S3625C1 ::v32(){vfunc_called(this, "_ZN7S3625C13v32Ev");}
void  S3625C1 ::v33(){vfunc_called(this, "_ZN7S3625C13v33Ev");}
void  S3625C1 ::v34(){vfunc_called(this, "_ZN7S3625C13v34Ev");}
void  S3625C1 ::v35(){vfunc_called(this, "_ZN7S3625C13v35Ev");}
void  S3625C1 ::v36(){vfunc_called(this, "_ZN7S3625C13v36Ev");}
void  S3625C1 ::v37(){vfunc_called(this, "_ZN7S3625C13v37Ev");}
void  S3625C1 ::v38(){vfunc_called(this, "_ZN7S3625C13v38Ev");}
void  S3625C1 ::v39(){vfunc_called(this, "_ZN7S3625C13v39Ev");}
void  S3625C1 ::v40(){vfunc_called(this, "_ZN7S3625C13v40Ev");}
void  S3625C1 ::v41(){vfunc_called(this, "_ZN7S3625C13v41Ev");}
void  S3625C1 ::v42(){vfunc_called(this, "_ZN7S3625C13v42Ev");}
void  S3625C1 ::v43(){vfunc_called(this, "_ZN7S3625C13v43Ev");}
void  S3625C1 ::v44(){vfunc_called(this, "_ZN7S3625C13v44Ev");}
void  S3625C1 ::v45(){vfunc_called(this, "_ZN7S3625C13v45Ev");}
void  S3625C1 ::v46(){vfunc_called(this, "_ZN7S3625C13v46Ev");}
void  S3625C1 ::v47(){vfunc_called(this, "_ZN7S3625C13v47Ev");}
void  S3625C1 ::v48(){vfunc_called(this, "_ZN7S3625C13v48Ev");}
void  S3625C1 ::v49(){vfunc_called(this, "_ZN7S3625C13v49Ev");}
void  S3625C1 ::v50(){vfunc_called(this, "_ZN7S3625C13v50Ev");}
void  S3625C1 ::v51(){vfunc_called(this, "_ZN7S3625C13v51Ev");}
void  S3625C1 ::v52(){vfunc_called(this, "_ZN7S3625C13v52Ev");}
void  S3625C1 ::v53(){vfunc_called(this, "_ZN7S3625C13v53Ev");}
void  S3625C1 ::v54(){vfunc_called(this, "_ZN7S3625C13v54Ev");}
void  S3625C1 ::v55(){vfunc_called(this, "_ZN7S3625C13v55Ev");}
void  S3625C1 ::v56(){vfunc_called(this, "_ZN7S3625C13v56Ev");}
void  S3625C1 ::v57(){vfunc_called(this, "_ZN7S3625C13v57Ev");}
void  S3625C1 ::v58(){vfunc_called(this, "_ZN7S3625C13v58Ev");}
void  S3625C1 ::v59(){vfunc_called(this, "_ZN7S3625C13v59Ev");}
void  S3625C1 ::v60(){vfunc_called(this, "_ZN7S3625C13v60Ev");}
void  S3625C1 ::v61(){vfunc_called(this, "_ZN7S3625C13v61Ev");}
void  S3625C1 ::v62(){vfunc_called(this, "_ZN7S3625C13v62Ev");}
void  S3625C1 ::v63(){vfunc_called(this, "_ZN7S3625C13v63Ev");}
void  S3625C1 ::v64(){vfunc_called(this, "_ZN7S3625C13v64Ev");}
void  S3625C1 ::v65(){vfunc_called(this, "_ZN7S3625C13v65Ev");}
void  S3625C1 ::v66(){vfunc_called(this, "_ZN7S3625C13v66Ev");}
void  S3625C1 ::v67(){vfunc_called(this, "_ZN7S3625C13v67Ev");}
void  S3625C1 ::v68(){vfunc_called(this, "_ZN7S3625C13v68Ev");}
void  S3625C1 ::v69(){vfunc_called(this, "_ZN7S3625C13v69Ev");}
void  S3625C1 ::v70(){vfunc_called(this, "_ZN7S3625C13v70Ev");}
void  S3625C1 ::v71(){vfunc_called(this, "_ZN7S3625C13v71Ev");}
void  S3625C1 ::v72(){vfunc_called(this, "_ZN7S3625C13v72Ev");}
void  S3625C1 ::v73(){vfunc_called(this, "_ZN7S3625C13v73Ev");}
void  S3625C1 ::v74(){vfunc_called(this, "_ZN7S3625C13v74Ev");}
void  S3625C1 ::v75(){vfunc_called(this, "_ZN7S3625C13v75Ev");}
void  S3625C1 ::v76(){vfunc_called(this, "_ZN7S3625C13v76Ev");}
void  S3625C1 ::v77(){vfunc_called(this, "_ZN7S3625C13v77Ev");}
void  S3625C1 ::v78(){vfunc_called(this, "_ZN7S3625C13v78Ev");}
void  S3625C1 ::v79(){vfunc_called(this, "_ZN7S3625C13v79Ev");}
void  S3625C1 ::v80(){vfunc_called(this, "_ZN7S3625C13v80Ev");}
void  S3625C1 ::v81(){vfunc_called(this, "_ZN7S3625C13v81Ev");}
void  S3625C1 ::v82(){vfunc_called(this, "_ZN7S3625C13v82Ev");}
void  S3625C1 ::v83(){vfunc_called(this, "_ZN7S3625C13v83Ev");}
void  S3625C1 ::v84(){vfunc_called(this, "_ZN7S3625C13v84Ev");}
void  S3625C1 ::v85(){vfunc_called(this, "_ZN7S3625C13v85Ev");}
void  S3625C1 ::v86(){vfunc_called(this, "_ZN7S3625C13v86Ev");}
void  S3625C1 ::v87(){vfunc_called(this, "_ZN7S3625C13v87Ev");}
void  S3625C1 ::v88(){vfunc_called(this, "_ZN7S3625C13v88Ev");}
void  S3625C1 ::v89(){vfunc_called(this, "_ZN7S3625C13v89Ev");}
void  S3625C1 ::v90(){vfunc_called(this, "_ZN7S3625C13v90Ev");}
void  S3625C1 ::v91(){vfunc_called(this, "_ZN7S3625C13v91Ev");}
void  S3625C1 ::v92(){vfunc_called(this, "_ZN7S3625C13v92Ev");}
S3625C1 ::S3625C1(){ note_ctor("S3625C1", this);} // tgen

static void Test_S3625C1()
{
  extern Class_Descriptor cd_S3625C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(911,1768)];
    init_test(&cd_S3625C1, buf);
    S3625C1 *dp, &lv = *(dp=new (buf) S3625C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(7280,7068), "sizeof(S3625C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3625C1)");
    check_base_class_offset(lv, (S3625C3_nt*)(S3625C2*), 0, "S3625C1");
    check_base_class_offset(lv, (S3625C2*), 0, "S3625C1");
    check_field_offset(lv, s3625c1f0, ABISELECT(7232,7036), "S3625C1.s3625c1f0");
    check_field_offset(lv, s3625c1f1, ABISELECT(7240,7040), "S3625C1.s3625c1f1");
    check_field_offset(lv, s3625c1f2, ABISELECT(7248,7044), "S3625C1.s3625c1f2");
    check_field_offset(lv, s3625c1f3, ABISELECT(7256,7052), "S3625C1.s3625c1f3");
    check_field_offset(lv, s3625c1f4, ABISELECT(7272,7064), "S3625C1.s3625c1f4");
    test_class_info(&lv, &cd_S3625C1);
    dp->~S3625C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3625C1(Test_S3625C1, "S3625C1", ABISELECT(7280,7068));

#else // __cplusplus

extern void _ZN7S3625C1C1Ev();
extern void _ZN7S3625C1D1Ev();
Name_Map name_map_S3625C1[] = {
  NSPAIR(_ZN7S3625C1C1Ev),
  NSPAIR(_ZN7S3625C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3625C3_nt;
extern VTBL_ENTRY _ZTI10S3625C3_nt[];
extern  VTBL_ENTRY _ZTV10S3625C3_nt[];
extern Class_Descriptor cd_S3625C2;
extern VTBL_ENTRY _ZTI7S3625C2[];
extern  VTBL_ENTRY _ZTV7S3625C2[];
static Base_Class bases_S3625C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3625C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3625C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3625C1[];
extern void _ZN7S3625C1D1Ev();
extern void _ZN7S3625C1D0Ev();
extern void _ZN7S3625C23v93Ev();
extern void _ZN7S3625C23v94Ev();
extern void _ZN7S3625C23v95Ev();
extern void _ZN7S3625C23v96Ev();
extern void _ZN7S3625C23v97Ev();
extern void _ZN7S3625C23v98Ev();
extern void _ZN7S3625C23v99Ev();
extern void _ZN7S3625C24v100Ev();
extern void _ZN7S3625C24v101Ev();
extern void _ZN7S3625C24v102Ev();
extern void _ZN7S3625C24v103Ev();
extern void _ZN7S3625C24v104Ev();
extern void _ZN7S3625C24v105Ev();
extern void _ZN7S3625C24v106Ev();
extern void _ZN7S3625C24v107Ev();
extern void _ZN7S3625C24v108Ev();
extern void _ZN7S3625C24v109Ev();
extern void _ZN7S3625C24v110Ev();
extern void _ZN7S3625C24v111Ev();
extern void _ZN7S3625C24v112Ev();
extern void _ZN7S3625C24v113Ev();
extern void _ZN7S3625C24v114Ev();
extern void _ZN7S3625C24v115Ev();
extern void _ZN7S3625C24v116Ev();
extern void _ZN7S3625C24v117Ev();
extern void _ZN7S3625C24v118Ev();
extern void _ZN7S3625C24v119Ev();
extern void _ZN7S3625C24v120Ev();
extern void _ZN7S3625C24v121Ev();
extern void _ZN7S3625C24v122Ev();
extern void _ZN7S3625C24v123Ev();
extern void _ZN7S3625C24v124Ev();
extern void _ZN7S3625C24v125Ev();
extern void _ZN7S3625C24v126Ev();
extern void _ZN7S3625C24v127Ev();
extern void _ZN7S3625C24v128Ev();
extern void _ZN7S3625C24v129Ev();
extern void _ZN7S3625C24v130Ev();
extern void _ZN7S3625C24v131Ev();
extern void _ZN7S3625C24v132Ev();
extern void _ZN7S3625C24v133Ev();
extern void _ZN7S3625C24v134Ev();
extern void _ZN7S3625C24v135Ev();
extern void _ZN7S3625C24v136Ev();
extern void _ZN7S3625C24v137Ev();
extern void _ZN7S3625C24v138Ev();
extern void _ZN7S3625C24v139Ev();
extern void _ZN7S3625C24v140Ev();
extern void _ZN7S3625C24v141Ev();
extern void _ZN7S3625C24v142Ev();
extern void _ZN7S3625C24v143Ev();
extern void _ZN7S3625C24v144Ev();
extern void _ZN7S3625C24v145Ev();
extern void _ZN7S3625C24v146Ev();
extern void _ZN7S3625C24v147Ev();
extern void _ZN7S3625C24v148Ev();
extern void _ZN7S3625C24v149Ev();
extern void _ZN7S3625C24v150Ev();
extern void _ZN7S3625C24v151Ev();
extern void _ZN7S3625C24v152Ev();
extern void _ZN7S3625C24v153Ev();
extern void _ZN7S3625C24v154Ev();
extern void _ZN7S3625C24v155Ev();
extern void _ZN7S3625C24v156Ev();
extern void _ZN7S3625C24v157Ev();
extern void _ZN7S3625C24v158Ev();
extern void _ZN7S3625C24v159Ev();
extern void _ZN7S3625C24v160Ev();
extern void _ZN7S3625C24v161Ev();
extern void _ZN7S3625C24v162Ev();
extern void _ZN7S3625C24v163Ev();
extern void _ZN7S3625C24v164Ev();
extern void _ZN7S3625C24v165Ev();
extern void _ZN7S3625C24v166Ev();
extern void _ZN7S3625C24v167Ev();
extern void _ZN7S3625C24v168Ev();
extern void _ZN7S3625C24v169Ev();
extern void _ZN7S3625C24v170Ev();
extern void _ZN7S3625C24v171Ev();
extern void _ZN7S3625C24v172Ev();
extern void _ZN7S3625C24v173Ev();
extern void _ZN7S3625C24v174Ev();
extern void _ZN7S3625C24v175Ev();
extern void _ZN7S3625C24v176Ev();
extern void _ZN7S3625C24v177Ev();
extern void _ZN7S3625C24v178Ev();
extern void _ZN7S3625C24v179Ev();
extern void _ZN7S3625C24v180Ev();
extern void _ZN7S3625C24v181Ev();
extern void _ZN7S3625C24v182Ev();
extern void _ZN7S3625C24v183Ev();
extern void _ZN7S3625C24v184Ev();
extern void _ZN7S3625C24v185Ev();
extern void _ZN7S3625C24v186Ev();
extern void _ZN7S3625C24v187Ev();
extern void _ZN7S3625C24v188Ev();
extern void _ZN7S3625C24v189Ev();
extern void _ZN7S3625C12v1Ev();
extern void _ZN7S3625C12v2Ev();
extern void _ZN7S3625C12v3Ev();
extern void _ZN7S3625C12v4Ev();
extern void _ZN7S3625C12v5Ev();
extern void _ZN7S3625C12v6Ev();
extern void _ZN7S3625C12v7Ev();
extern void _ZN7S3625C12v8Ev();
extern void _ZN7S3625C12v9Ev();
extern void _ZN7S3625C13v10Ev();
extern void _ZN7S3625C13v11Ev();
extern void _ZN7S3625C13v12Ev();
extern void _ZN7S3625C13v13Ev();
extern void _ZN7S3625C13v14Ev();
extern void _ZN7S3625C13v15Ev();
extern void _ZN7S3625C13v16Ev();
extern void _ZN7S3625C13v17Ev();
extern void _ZN7S3625C13v18Ev();
extern void _ZN7S3625C13v19Ev();
extern void _ZN7S3625C13v20Ev();
extern void _ZN7S3625C13v21Ev();
extern void _ZN7S3625C13v22Ev();
extern void _ZN7S3625C13v23Ev();
extern void _ZN7S3625C13v24Ev();
extern void _ZN7S3625C13v25Ev();
extern void _ZN7S3625C13v26Ev();
extern void _ZN7S3625C13v27Ev();
extern void _ZN7S3625C13v28Ev();
extern void _ZN7S3625C13v29Ev();
extern void _ZN7S3625C13v30Ev();
extern void _ZN7S3625C13v31Ev();
extern void _ZN7S3625C13v32Ev();
extern void _ZN7S3625C13v33Ev();
extern void _ZN7S3625C13v34Ev();
extern void _ZN7S3625C13v35Ev();
extern void _ZN7S3625C13v36Ev();
extern void _ZN7S3625C13v37Ev();
extern void _ZN7S3625C13v38Ev();
extern void _ZN7S3625C13v39Ev();
extern void _ZN7S3625C13v40Ev();
extern void _ZN7S3625C13v41Ev();
extern void _ZN7S3625C13v42Ev();
extern void _ZN7S3625C13v43Ev();
extern void _ZN7S3625C13v44Ev();
extern void _ZN7S3625C13v45Ev();
extern void _ZN7S3625C13v46Ev();
extern void _ZN7S3625C13v47Ev();
extern void _ZN7S3625C13v48Ev();
extern void _ZN7S3625C13v49Ev();
extern void _ZN7S3625C13v50Ev();
extern void _ZN7S3625C13v51Ev();
extern void _ZN7S3625C13v52Ev();
extern void _ZN7S3625C13v53Ev();
extern void _ZN7S3625C13v54Ev();
extern void _ZN7S3625C13v55Ev();
extern void _ZN7S3625C13v56Ev();
extern void _ZN7S3625C13v57Ev();
extern void _ZN7S3625C13v58Ev();
extern void _ZN7S3625C13v59Ev();
extern void _ZN7S3625C13v60Ev();
extern void _ZN7S3625C13v61Ev();
extern void _ZN7S3625C13v62Ev();
extern void _ZN7S3625C13v63Ev();
extern void _ZN7S3625C13v64Ev();
extern void _ZN7S3625C13v65Ev();
extern void _ZN7S3625C13v66Ev();
extern void _ZN7S3625C13v67Ev();
extern void _ZN7S3625C13v68Ev();
extern void _ZN7S3625C13v69Ev();
extern void _ZN7S3625C13v70Ev();
extern void _ZN7S3625C13v71Ev();
extern void _ZN7S3625C13v72Ev();
extern void _ZN7S3625C13v73Ev();
extern void _ZN7S3625C13v74Ev();
extern void _ZN7S3625C13v75Ev();
extern void _ZN7S3625C13v76Ev();
extern void _ZN7S3625C13v77Ev();
extern void _ZN7S3625C13v78Ev();
extern void _ZN7S3625C13v79Ev();
extern void _ZN7S3625C13v80Ev();
extern void _ZN7S3625C13v81Ev();
extern void _ZN7S3625C13v82Ev();
extern void _ZN7S3625C13v83Ev();
extern void _ZN7S3625C13v84Ev();
extern void _ZN7S3625C13v85Ev();
extern void _ZN7S3625C13v86Ev();
extern void _ZN7S3625C13v87Ev();
extern void _ZN7S3625C13v88Ev();
extern void _ZN7S3625C13v89Ev();
extern void _ZN7S3625C13v90Ev();
extern void _ZN7S3625C13v91Ev();
extern void _ZN7S3625C13v92Ev();
static  VTBL_ENTRY vtc_S3625C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3625C1[0]),
  (VTBL_ENTRY)&_ZN7S3625C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3625C1D0Ev,
  (VTBL_ENTRY)&_ZN7S3625C23v93Ev,
  (VTBL_ENTRY)&_ZN7S3625C23v94Ev,
  (VTBL_ENTRY)&_ZN7S3625C23v95Ev,
  (VTBL_ENTRY)&_ZN7S3625C23v96Ev,
  (VTBL_ENTRY)&_ZN7S3625C23v97Ev,
  (VTBL_ENTRY)&_ZN7S3625C23v98Ev,
  (VTBL_ENTRY)&_ZN7S3625C23v99Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v100Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v101Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v102Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v103Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v104Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v105Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v106Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v107Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v108Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v109Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v110Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v111Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v112Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v113Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v114Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v115Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v116Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v117Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v118Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v119Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v120Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v121Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v122Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v123Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v124Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v125Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v126Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v127Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v128Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v129Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v130Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v131Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v132Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v133Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v134Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v135Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v136Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v137Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v138Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v139Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v140Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v141Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v142Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v143Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v144Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v145Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v146Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v147Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v148Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v149Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v150Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v151Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v152Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v153Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v154Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v155Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v156Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v157Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v158Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v159Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v160Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v161Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v162Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v163Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v164Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v165Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v166Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v167Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v168Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v169Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v170Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v171Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v172Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v173Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v174Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v175Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v176Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v177Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v178Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v179Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v180Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v181Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v182Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v183Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v184Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v185Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v186Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v187Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v188Ev,
  (VTBL_ENTRY)&_ZN7S3625C24v189Ev,
  (VTBL_ENTRY)&_ZN7S3625C12v1Ev,
  (VTBL_ENTRY)&_ZN7S3625C12v2Ev,
  (VTBL_ENTRY)&_ZN7S3625C12v3Ev,
  (VTBL_ENTRY)&_ZN7S3625C12v4Ev,
  (VTBL_ENTRY)&_ZN7S3625C12v5Ev,
  (VTBL_ENTRY)&_ZN7S3625C12v6Ev,
  (VTBL_ENTRY)&_ZN7S3625C12v7Ev,
  (VTBL_ENTRY)&_ZN7S3625C12v8Ev,
  (VTBL_ENTRY)&_ZN7S3625C12v9Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v10Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v11Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v12Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v13Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v14Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v15Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v16Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v17Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v18Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v19Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v20Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v21Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v22Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v23Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v24Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v25Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v26Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v27Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v28Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v29Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v30Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v31Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v32Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v33Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v34Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v35Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v36Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v37Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v38Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v39Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v40Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v41Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v42Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v43Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v44Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v45Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v46Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v47Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v48Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v49Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v50Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v51Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v52Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v53Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v54Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v55Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v56Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v57Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v58Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v59Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v60Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v61Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v62Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v63Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v64Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v65Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v66Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v67Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v68Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v69Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v70Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v71Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v72Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v73Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v74Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v75Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v76Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v77Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v78Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v79Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v80Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v81Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v82Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v83Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v84Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v85Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v86Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v87Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v88Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v89Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v90Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v91Ev,
  (VTBL_ENTRY)&_ZN7S3625C13v92Ev,
};
extern VTBL_ENTRY _ZTI7S3625C1[];
extern  VTBL_ENTRY _ZTV7S3625C1[];
Class_Descriptor cd_S3625C1 = {  "S3625C1", // class name
  bases_S3625C1, 2,
  &(vtc_S3625C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(7280,7068), // object size
  NSPAIRA(_ZTI7S3625C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3625C1),193, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3622C2  : S3625C3_nt {
  int s3622c2f0[3];
  ::S3625C10_nt s3622c2f1;
  ::S3625C11_nt s3622c2f2;
  int s3622c2f3[3];
  void *s3622c2f4;
  char s3622c2f5[3];
  ::S3625C12_nt s3622c2f6;
  int s3622c2f7;
  ::S3625C31 s3622c2f8;
  void *s3622c2f9;
  int s3622c2f10[2];
  ::S3625C13_nt s3622c2f11;
  ::S3625C13_nt s3622c2f12;
  int s3622c2f13[3];
  char s3622c2f14[6144];
  ::S3625C18_nt s3622c2f15;
  ::S3625C25 s3622c2f16;
  char s3622c2f17;
  int s3622c2f18;
  char s3622c2f19;
  int s3622c2f20[5];
  __tsi64 s3622c2f21[7];
  char s3622c2f22;
  __tsi64 s3622c2f23[9];
  int s3622c2f24[2];
  ::S3625C22 s3622c2f25;
  ::S3625C28_nt s3622c2f26;
  void *s3622c2f27[3];
  __tsi64 s3622c2f28[2];
  ::S3625C18_nt s3622c2f29;
  int s3622c2f30;
  char s3622c2f31;
  __tsi64 s3622c2f32;
  char s3622c2f33;
  __tsi64 s3622c2f34;
  virtual  ~S3622C2(); // _ZN7S3622C2D1Ev
  virtual void  v49(); // _ZN7S3622C23v49Ev
  virtual void  v50(); // _ZN7S3622C23v50Ev
  virtual void  v51(); // _ZN7S3622C23v51Ev
  virtual void  v52(); // _ZN7S3622C23v52Ev
  virtual void  v53(); // _ZN7S3622C23v53Ev
  virtual void  v54(); // _ZN7S3622C23v54Ev
  virtual void  v55(); // _ZN7S3622C23v55Ev
  virtual void  v56(); // _ZN7S3622C23v56Ev
  virtual void  v57(); // _ZN7S3622C23v57Ev
  virtual void  v58(); // _ZN7S3622C23v58Ev
  virtual void  v59(); // _ZN7S3622C23v59Ev
  virtual void  v60(); // _ZN7S3622C23v60Ev
  virtual void  v61(); // _ZN7S3622C23v61Ev
  virtual void  v62(); // _ZN7S3622C23v62Ev
  virtual void  v63(); // _ZN7S3622C23v63Ev
  virtual void  v64(); // _ZN7S3622C23v64Ev
  virtual void  v65(); // _ZN7S3622C23v65Ev
  virtual void  v66(); // _ZN7S3622C23v66Ev
  virtual void  v67(); // _ZN7S3622C23v67Ev
  virtual void  v68(); // _ZN7S3622C23v68Ev
  virtual void  v69(); // _ZN7S3622C23v69Ev
  virtual void  v70(); // _ZN7S3622C23v70Ev
  virtual void  v71(); // _ZN7S3622C23v71Ev
  virtual void  v72(); // _ZN7S3622C23v72Ev
  virtual void  v73(); // _ZN7S3622C23v73Ev
  virtual void  v74(); // _ZN7S3622C23v74Ev
  virtual void  v75(); // _ZN7S3622C23v75Ev
  virtual void  v76(); // _ZN7S3622C23v76Ev
  virtual void  v77(); // _ZN7S3622C23v77Ev
  virtual void  v78(); // _ZN7S3622C23v78Ev
  virtual void  v79(); // _ZN7S3622C23v79Ev
  virtual void  v80(); // _ZN7S3622C23v80Ev
  virtual void  v81(); // _ZN7S3622C23v81Ev
  virtual void  v82(); // _ZN7S3622C23v82Ev
  virtual void  v83(); // _ZN7S3622C23v83Ev
  virtual void  v84(); // _ZN7S3622C23v84Ev
  virtual void  v85(); // _ZN7S3622C23v85Ev
  virtual void  v86(); // _ZN7S3622C23v86Ev
  virtual void  v87(); // _ZN7S3622C23v87Ev
  virtual void  v88(); // _ZN7S3622C23v88Ev
  virtual void  v89(); // _ZN7S3622C23v89Ev
  virtual void  v90(); // _ZN7S3622C23v90Ev
  virtual void  v91(); // _ZN7S3622C23v91Ev
  virtual void  v92(); // _ZN7S3622C23v92Ev
  virtual void  v93(); // _ZN7S3622C23v93Ev
  virtual void  v94(); // _ZN7S3622C23v94Ev
  virtual void  v95(); // _ZN7S3622C23v95Ev
  virtual void  v96(); // _ZN7S3622C23v96Ev
  virtual void  v97(); // _ZN7S3622C23v97Ev
  virtual void  v98(); // _ZN7S3622C23v98Ev
  virtual void  v99(); // _ZN7S3622C23v99Ev
  virtual void  v100(); // _ZN7S3622C24v100Ev
  virtual void  v101(); // _ZN7S3622C24v101Ev
  virtual void  v102(); // _ZN7S3622C24v102Ev
  virtual void  v103(); // _ZN7S3622C24v103Ev
  virtual void  v104(); // _ZN7S3622C24v104Ev
  virtual void  v105(); // _ZN7S3622C24v105Ev
  virtual void  v106(); // _ZN7S3622C24v106Ev
  virtual void  v107(); // _ZN7S3622C24v107Ev
  virtual void  v108(); // _ZN7S3622C24v108Ev
  virtual void  v109(); // _ZN7S3622C24v109Ev
  virtual void  v110(); // _ZN7S3622C24v110Ev
  virtual void  v111(); // _ZN7S3622C24v111Ev
  virtual void  v112(); // _ZN7S3622C24v112Ev
  virtual void  v113(); // _ZN7S3622C24v113Ev
  virtual void  v114(); // _ZN7S3622C24v114Ev
  virtual void  v115(); // _ZN7S3622C24v115Ev
  virtual void  v116(); // _ZN7S3622C24v116Ev
  virtual void  v117(); // _ZN7S3622C24v117Ev
  virtual void  v118(); // _ZN7S3622C24v118Ev
  virtual void  v119(); // _ZN7S3622C24v119Ev
  virtual void  v120(); // _ZN7S3622C24v120Ev
  virtual void  v121(); // _ZN7S3622C24v121Ev
  virtual void  v122(); // _ZN7S3622C24v122Ev
  virtual void  v123(); // _ZN7S3622C24v123Ev
  virtual void  v124(); // _ZN7S3622C24v124Ev
  virtual void  v125(); // _ZN7S3622C24v125Ev
  virtual void  v126(); // _ZN7S3622C24v126Ev
  virtual void  v127(); // _ZN7S3622C24v127Ev
  virtual void  v128(); // _ZN7S3622C24v128Ev
  virtual void  v129(); // _ZN7S3622C24v129Ev
  virtual void  v130(); // _ZN7S3622C24v130Ev
  virtual void  v131(); // _ZN7S3622C24v131Ev
  virtual void  v132(); // _ZN7S3622C24v132Ev
  virtual void  v133(); // _ZN7S3622C24v133Ev
  virtual void  v134(); // _ZN7S3622C24v134Ev
  virtual void  v135(); // _ZN7S3622C24v135Ev
  virtual void  v136(); // _ZN7S3622C24v136Ev
  virtual void  v137(); // _ZN7S3622C24v137Ev
  virtual void  v138(); // _ZN7S3622C24v138Ev
  virtual void  v139(); // _ZN7S3622C24v139Ev
  virtual void  v140(); // _ZN7S3622C24v140Ev
  virtual void  v141(); // _ZN7S3622C24v141Ev
  virtual void  v142(); // _ZN7S3622C24v142Ev
  virtual void  v143(); // _ZN7S3622C24v143Ev
  virtual void  v144(); // _ZN7S3622C24v144Ev
  virtual void  v145(); // _ZN7S3622C24v145Ev
  S3622C2(); // tgen
};
//SIG(-1 S3622C2) C1{ BC2{ vd m FC3{ m Fp Fi FC4{ m} FC5{ m}} FC3 Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 Fi[3] FC6{ m Fc Fl[2] Fs[12] Fc[5]} FC7{ m Fc Fl[4] Fi[4]} Fi[3] Fp Fc[3] FC8{ m FC9{ m FC10{ FL[4]}} Fc Fp Fi[3]} Fi FC11{ m Fp Fi[2] FC12{ m}} Fp Fi[2] FC9 FC9 Fi[3] Fc[6144] FC13{ m Fp Fi FC14{ m}} FC15{ m Fp Fi[2] FC14} Fc Fi Fc Fi[5] FL[7] Fc FL[9] Fi[2] FC16{ BC17{ m FC18{ m Fc[11]} Fi[7] FL} Fi FC15 FC18 Fi} FC19{ m Fp FC9 FL[2] Fi FL Fi[2] Fc FC13 FC13 FL[5] Fc Fi FC15 FC15 FC15 FC15 FC11 Fi[2]} Fp[3] FL[2] FC13 Fi Fc FL Fc FL}


 S3622C2 ::~S3622C2(){ note_dtor("S3622C2", this);}
void  S3622C2 ::v49(){vfunc_called(this, "_ZN7S3622C23v49Ev");}
void  S3622C2 ::v50(){vfunc_called(this, "_ZN7S3622C23v50Ev");}
void  S3622C2 ::v51(){vfunc_called(this, "_ZN7S3622C23v51Ev");}
void  S3622C2 ::v52(){vfunc_called(this, "_ZN7S3622C23v52Ev");}
void  S3622C2 ::v53(){vfunc_called(this, "_ZN7S3622C23v53Ev");}
void  S3622C2 ::v54(){vfunc_called(this, "_ZN7S3622C23v54Ev");}
void  S3622C2 ::v55(){vfunc_called(this, "_ZN7S3622C23v55Ev");}
void  S3622C2 ::v56(){vfunc_called(this, "_ZN7S3622C23v56Ev");}
void  S3622C2 ::v57(){vfunc_called(this, "_ZN7S3622C23v57Ev");}
void  S3622C2 ::v58(){vfunc_called(this, "_ZN7S3622C23v58Ev");}
void  S3622C2 ::v59(){vfunc_called(this, "_ZN7S3622C23v59Ev");}
void  S3622C2 ::v60(){vfunc_called(this, "_ZN7S3622C23v60Ev");}
void  S3622C2 ::v61(){vfunc_called(this, "_ZN7S3622C23v61Ev");}
void  S3622C2 ::v62(){vfunc_called(this, "_ZN7S3622C23v62Ev");}
void  S3622C2 ::v63(){vfunc_called(this, "_ZN7S3622C23v63Ev");}
void  S3622C2 ::v64(){vfunc_called(this, "_ZN7S3622C23v64Ev");}
void  S3622C2 ::v65(){vfunc_called(this, "_ZN7S3622C23v65Ev");}
void  S3622C2 ::v66(){vfunc_called(this, "_ZN7S3622C23v66Ev");}
void  S3622C2 ::v67(){vfunc_called(this, "_ZN7S3622C23v67Ev");}
void  S3622C2 ::v68(){vfunc_called(this, "_ZN7S3622C23v68Ev");}
void  S3622C2 ::v69(){vfunc_called(this, "_ZN7S3622C23v69Ev");}
void  S3622C2 ::v70(){vfunc_called(this, "_ZN7S3622C23v70Ev");}
void  S3622C2 ::v71(){vfunc_called(this, "_ZN7S3622C23v71Ev");}
void  S3622C2 ::v72(){vfunc_called(this, "_ZN7S3622C23v72Ev");}
void  S3622C2 ::v73(){vfunc_called(this, "_ZN7S3622C23v73Ev");}
void  S3622C2 ::v74(){vfunc_called(this, "_ZN7S3622C23v74Ev");}
void  S3622C2 ::v75(){vfunc_called(this, "_ZN7S3622C23v75Ev");}
void  S3622C2 ::v76(){vfunc_called(this, "_ZN7S3622C23v76Ev");}
void  S3622C2 ::v77(){vfunc_called(this, "_ZN7S3622C23v77Ev");}
void  S3622C2 ::v78(){vfunc_called(this, "_ZN7S3622C23v78Ev");}
void  S3622C2 ::v79(){vfunc_called(this, "_ZN7S3622C23v79Ev");}
void  S3622C2 ::v80(){vfunc_called(this, "_ZN7S3622C23v80Ev");}
void  S3622C2 ::v81(){vfunc_called(this, "_ZN7S3622C23v81Ev");}
void  S3622C2 ::v82(){vfunc_called(this, "_ZN7S3622C23v82Ev");}
void  S3622C2 ::v83(){vfunc_called(this, "_ZN7S3622C23v83Ev");}
void  S3622C2 ::v84(){vfunc_called(this, "_ZN7S3622C23v84Ev");}
void  S3622C2 ::v85(){vfunc_called(this, "_ZN7S3622C23v85Ev");}
void  S3622C2 ::v86(){vfunc_called(this, "_ZN7S3622C23v86Ev");}
void  S3622C2 ::v87(){vfunc_called(this, "_ZN7S3622C23v87Ev");}
void  S3622C2 ::v88(){vfunc_called(this, "_ZN7S3622C23v88Ev");}
void  S3622C2 ::v89(){vfunc_called(this, "_ZN7S3622C23v89Ev");}
void  S3622C2 ::v90(){vfunc_called(this, "_ZN7S3622C23v90Ev");}
void  S3622C2 ::v91(){vfunc_called(this, "_ZN7S3622C23v91Ev");}
void  S3622C2 ::v92(){vfunc_called(this, "_ZN7S3622C23v92Ev");}
void  S3622C2 ::v93(){vfunc_called(this, "_ZN7S3622C23v93Ev");}
void  S3622C2 ::v94(){vfunc_called(this, "_ZN7S3622C23v94Ev");}
void  S3622C2 ::v95(){vfunc_called(this, "_ZN7S3622C23v95Ev");}
void  S3622C2 ::v96(){vfunc_called(this, "_ZN7S3622C23v96Ev");}
void  S3622C2 ::v97(){vfunc_called(this, "_ZN7S3622C23v97Ev");}
void  S3622C2 ::v98(){vfunc_called(this, "_ZN7S3622C23v98Ev");}
void  S3622C2 ::v99(){vfunc_called(this, "_ZN7S3622C23v99Ev");}
void  S3622C2 ::v100(){vfunc_called(this, "_ZN7S3622C24v100Ev");}
void  S3622C2 ::v101(){vfunc_called(this, "_ZN7S3622C24v101Ev");}
void  S3622C2 ::v102(){vfunc_called(this, "_ZN7S3622C24v102Ev");}
void  S3622C2 ::v103(){vfunc_called(this, "_ZN7S3622C24v103Ev");}
void  S3622C2 ::v104(){vfunc_called(this, "_ZN7S3622C24v104Ev");}
void  S3622C2 ::v105(){vfunc_called(this, "_ZN7S3622C24v105Ev");}
void  S3622C2 ::v106(){vfunc_called(this, "_ZN7S3622C24v106Ev");}
void  S3622C2 ::v107(){vfunc_called(this, "_ZN7S3622C24v107Ev");}
void  S3622C2 ::v108(){vfunc_called(this, "_ZN7S3622C24v108Ev");}
void  S3622C2 ::v109(){vfunc_called(this, "_ZN7S3622C24v109Ev");}
void  S3622C2 ::v110(){vfunc_called(this, "_ZN7S3622C24v110Ev");}
void  S3622C2 ::v111(){vfunc_called(this, "_ZN7S3622C24v111Ev");}
void  S3622C2 ::v112(){vfunc_called(this, "_ZN7S3622C24v112Ev");}
void  S3622C2 ::v113(){vfunc_called(this, "_ZN7S3622C24v113Ev");}
void  S3622C2 ::v114(){vfunc_called(this, "_ZN7S3622C24v114Ev");}
void  S3622C2 ::v115(){vfunc_called(this, "_ZN7S3622C24v115Ev");}
void  S3622C2 ::v116(){vfunc_called(this, "_ZN7S3622C24v116Ev");}
void  S3622C2 ::v117(){vfunc_called(this, "_ZN7S3622C24v117Ev");}
void  S3622C2 ::v118(){vfunc_called(this, "_ZN7S3622C24v118Ev");}
void  S3622C2 ::v119(){vfunc_called(this, "_ZN7S3622C24v119Ev");}
void  S3622C2 ::v120(){vfunc_called(this, "_ZN7S3622C24v120Ev");}
void  S3622C2 ::v121(){vfunc_called(this, "_ZN7S3622C24v121Ev");}
void  S3622C2 ::v122(){vfunc_called(this, "_ZN7S3622C24v122Ev");}
void  S3622C2 ::v123(){vfunc_called(this, "_ZN7S3622C24v123Ev");}
void  S3622C2 ::v124(){vfunc_called(this, "_ZN7S3622C24v124Ev");}
void  S3622C2 ::v125(){vfunc_called(this, "_ZN7S3622C24v125Ev");}
void  S3622C2 ::v126(){vfunc_called(this, "_ZN7S3622C24v126Ev");}
void  S3622C2 ::v127(){vfunc_called(this, "_ZN7S3622C24v127Ev");}
void  S3622C2 ::v128(){vfunc_called(this, "_ZN7S3622C24v128Ev");}
void  S3622C2 ::v129(){vfunc_called(this, "_ZN7S3622C24v129Ev");}
void  S3622C2 ::v130(){vfunc_called(this, "_ZN7S3622C24v130Ev");}
void  S3622C2 ::v131(){vfunc_called(this, "_ZN7S3622C24v131Ev");}
void  S3622C2 ::v132(){vfunc_called(this, "_ZN7S3622C24v132Ev");}
void  S3622C2 ::v133(){vfunc_called(this, "_ZN7S3622C24v133Ev");}
void  S3622C2 ::v134(){vfunc_called(this, "_ZN7S3622C24v134Ev");}
void  S3622C2 ::v135(){vfunc_called(this, "_ZN7S3622C24v135Ev");}
void  S3622C2 ::v136(){vfunc_called(this, "_ZN7S3622C24v136Ev");}
void  S3622C2 ::v137(){vfunc_called(this, "_ZN7S3622C24v137Ev");}
void  S3622C2 ::v138(){vfunc_called(this, "_ZN7S3622C24v138Ev");}
void  S3622C2 ::v139(){vfunc_called(this, "_ZN7S3622C24v139Ev");}
void  S3622C2 ::v140(){vfunc_called(this, "_ZN7S3622C24v140Ev");}
void  S3622C2 ::v141(){vfunc_called(this, "_ZN7S3622C24v141Ev");}
void  S3622C2 ::v142(){vfunc_called(this, "_ZN7S3622C24v142Ev");}
void  S3622C2 ::v143(){vfunc_called(this, "_ZN7S3622C24v143Ev");}
void  S3622C2 ::v144(){vfunc_called(this, "_ZN7S3622C24v144Ev");}
void  S3622C2 ::v145(){vfunc_called(this, "_ZN7S3622C24v145Ev");}
S3622C2 ::S3622C2(){ note_ctor("S3622C2", this);} // tgen

static void Test_S3622C2()
{
  extern Class_Descriptor cd_S3622C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(905,1760)];
    init_test(&cd_S3622C2, buf);
    S3622C2 *dp, &lv = *(dp=new (buf) S3622C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(7232,7036), "sizeof(S3622C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3622C2)");
    check_base_class_offset(lv, (S3625C3_nt*), 0, "S3622C2");
    check_field_offset(lv, s3622c2f0, ABISELECT(44,32), "S3622C2.s3622c2f0");
    check_field_offset(lv, s3622c2f1, ABISELECT(56,44), "S3622C2.s3622c2f1");
    check_field_offset(lv, s3622c2f2, ABISELECT(112,88), "S3622C2.s3622c2f2");
    check_field_offset(lv, s3622c2f3, ABISELECT(168,124), "S3622C2.s3622c2f3");
    check_field_offset(lv, s3622c2f4, ABISELECT(184,136), "S3622C2.s3622c2f4");
    check_field_offset(lv, s3622c2f5, ABISELECT(192,140), "S3622C2.s3622c2f5");
    check_field_offset(lv, s3622c2f6, ABISELECT(200,144), "S3622C2.s3622c2f6");
    check_field_offset(lv, s3622c2f7, ABISELECT(264,196), "S3622C2.s3622c2f7");
    check_field_offset(lv, s3622c2f8, ABISELECT(272,200), "S3622C2.s3622c2f8");
    check_field_offset(lv, s3622c2f9, ABISELECT(296,216), "S3622C2.s3622c2f9");
    check_field_offset(lv, s3622c2f10, ABISELECT(304,220), "S3622C2.s3622c2f10");
    check_field_offset(lv, s3622c2f11, ABISELECT(312,228), "S3622C2.s3622c2f11");
    check_field_offset(lv, s3622c2f12, ABISELECT(344,260), "S3622C2.s3622c2f12");
    check_field_offset(lv, s3622c2f13, ABISELECT(376,292), "S3622C2.s3622c2f13");
    check_field_offset(lv, s3622c2f14, ABISELECT(388,304), "S3622C2.s3622c2f14");
    check_field_offset(lv, s3622c2f15, ABISELECT(6536,6448), "S3622C2.s3622c2f15");
    check_field_offset(lv, s3622c2f16, ABISELECT(6552,6460), "S3622C2.s3622c2f16");
    check_field_offset(lv, s3622c2f17, ABISELECT(6576,6476), "S3622C2.s3622c2f17");
    check_field_offset(lv, s3622c2f18, ABISELECT(6580,6480), "S3622C2.s3622c2f18");
    check_field_offset(lv, s3622c2f19, ABISELECT(6584,6484), "S3622C2.s3622c2f19");
    check_field_offset(lv, s3622c2f20, ABISELECT(6588,6488), "S3622C2.s3622c2f20");
    check_field_offset(lv, s3622c2f21, ABISELECT(6608,6508), "S3622C2.s3622c2f21");
    check_field_offset(lv, s3622c2f22, ABISELECT(6664,6564), "S3622C2.s3622c2f22");
    check_field_offset(lv, s3622c2f23, ABISELECT(6672,6568), "S3622C2.s3622c2f23");
    check_field_offset(lv, s3622c2f24, ABISELECT(6744,6640), "S3622C2.s3622c2f24");
    check_field_offset(lv, s3622c2f25, ABISELECT(6752,6648), "S3622C2.s3622c2f25");
    check_field_offset(lv, s3622c2f26, ABISELECT(6848,6732), "S3622C2.s3622c2f26");
    check_field_offset(lv, s3622c2f27, ABISELECT(7144,6968), "S3622C2.s3622c2f27");
    check_field_offset(lv, s3622c2f28, ABISELECT(7168,6980), "S3622C2.s3622c2f28");
    check_field_offset(lv, s3622c2f29, ABISELECT(7184,6996), "S3622C2.s3622c2f29");
    check_field_offset(lv, s3622c2f30, ABISELECT(7200,7008), "S3622C2.s3622c2f30");
    check_field_offset(lv, s3622c2f31, ABISELECT(7204,7012), "S3622C2.s3622c2f31");
    check_field_offset(lv, s3622c2f32, ABISELECT(7208,7016), "S3622C2.s3622c2f32");
    check_field_offset(lv, s3622c2f33, ABISELECT(7216,7024), "S3622C2.s3622c2f33");
    check_field_offset(lv, s3622c2f34, ABISELECT(7224,7028), "S3622C2.s3622c2f34");
    test_class_info(&lv, &cd_S3622C2);
    dp->~S3622C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3622C2(Test_S3622C2, "S3622C2", ABISELECT(7232,7036));

#else // __cplusplus

extern void _ZN7S3622C2C1Ev();
extern void _ZN7S3622C2D1Ev();
Name_Map name_map_S3622C2[] = {
  NSPAIR(_ZN7S3622C2C1Ev),
  NSPAIR(_ZN7S3622C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3625C3_nt;
extern VTBL_ENTRY _ZTI10S3625C3_nt[];
extern  VTBL_ENTRY _ZTV10S3625C3_nt[];
static Base_Class bases_S3622C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3625C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3622C2[];
extern void _ZN7S3622C2D1Ev();
extern void _ZN7S3622C2D0Ev();
extern void _ZN7S3622C23v49Ev();
extern void _ZN7S3622C23v50Ev();
extern void _ZN7S3622C23v51Ev();
extern void _ZN7S3622C23v52Ev();
extern void _ZN7S3622C23v53Ev();
extern void _ZN7S3622C23v54Ev();
extern void _ZN7S3622C23v55Ev();
extern void _ZN7S3622C23v56Ev();
extern void _ZN7S3622C23v57Ev();
extern void _ZN7S3622C23v58Ev();
extern void _ZN7S3622C23v59Ev();
extern void _ZN7S3622C23v60Ev();
extern void _ZN7S3622C23v61Ev();
extern void _ZN7S3622C23v62Ev();
extern void _ZN7S3622C23v63Ev();
extern void _ZN7S3622C23v64Ev();
extern void _ZN7S3622C23v65Ev();
extern void _ZN7S3622C23v66Ev();
extern void _ZN7S3622C23v67Ev();
extern void _ZN7S3622C23v68Ev();
extern void _ZN7S3622C23v69Ev();
extern void _ZN7S3622C23v70Ev();
extern void _ZN7S3622C23v71Ev();
extern void _ZN7S3622C23v72Ev();
extern void _ZN7S3622C23v73Ev();
extern void _ZN7S3622C23v74Ev();
extern void _ZN7S3622C23v75Ev();
extern void _ZN7S3622C23v76Ev();
extern void _ZN7S3622C23v77Ev();
extern void _ZN7S3622C23v78Ev();
extern void _ZN7S3622C23v79Ev();
extern void _ZN7S3622C23v80Ev();
extern void _ZN7S3622C23v81Ev();
extern void _ZN7S3622C23v82Ev();
extern void _ZN7S3622C23v83Ev();
extern void _ZN7S3622C23v84Ev();
extern void _ZN7S3622C23v85Ev();
extern void _ZN7S3622C23v86Ev();
extern void _ZN7S3622C23v87Ev();
extern void _ZN7S3622C23v88Ev();
extern void _ZN7S3622C23v89Ev();
extern void _ZN7S3622C23v90Ev();
extern void _ZN7S3622C23v91Ev();
extern void _ZN7S3622C23v92Ev();
extern void _ZN7S3622C23v93Ev();
extern void _ZN7S3622C23v94Ev();
extern void _ZN7S3622C23v95Ev();
extern void _ZN7S3622C23v96Ev();
extern void _ZN7S3622C23v97Ev();
extern void _ZN7S3622C23v98Ev();
extern void _ZN7S3622C23v99Ev();
extern void _ZN7S3622C24v100Ev();
extern void _ZN7S3622C24v101Ev();
extern void _ZN7S3622C24v102Ev();
extern void _ZN7S3622C24v103Ev();
extern void _ZN7S3622C24v104Ev();
extern void _ZN7S3622C24v105Ev();
extern void _ZN7S3622C24v106Ev();
extern void _ZN7S3622C24v107Ev();
extern void _ZN7S3622C24v108Ev();
extern void _ZN7S3622C24v109Ev();
extern void _ZN7S3622C24v110Ev();
extern void _ZN7S3622C24v111Ev();
extern void _ZN7S3622C24v112Ev();
extern void _ZN7S3622C24v113Ev();
extern void _ZN7S3622C24v114Ev();
extern void _ZN7S3622C24v115Ev();
extern void _ZN7S3622C24v116Ev();
extern void _ZN7S3622C24v117Ev();
extern void _ZN7S3622C24v118Ev();
extern void _ZN7S3622C24v119Ev();
extern void _ZN7S3622C24v120Ev();
extern void _ZN7S3622C24v121Ev();
extern void _ZN7S3622C24v122Ev();
extern void _ZN7S3622C24v123Ev();
extern void _ZN7S3622C24v124Ev();
extern void _ZN7S3622C24v125Ev();
extern void _ZN7S3622C24v126Ev();
extern void _ZN7S3622C24v127Ev();
extern void _ZN7S3622C24v128Ev();
extern void _ZN7S3622C24v129Ev();
extern void _ZN7S3622C24v130Ev();
extern void _ZN7S3622C24v131Ev();
extern void _ZN7S3622C24v132Ev();
extern void _ZN7S3622C24v133Ev();
extern void _ZN7S3622C24v134Ev();
extern void _ZN7S3622C24v135Ev();
extern void _ZN7S3622C24v136Ev();
extern void _ZN7S3622C24v137Ev();
extern void _ZN7S3622C24v138Ev();
extern void _ZN7S3622C24v139Ev();
extern void _ZN7S3622C24v140Ev();
extern void _ZN7S3622C24v141Ev();
extern void _ZN7S3622C24v142Ev();
extern void _ZN7S3622C24v143Ev();
extern void _ZN7S3622C24v144Ev();
extern void _ZN7S3622C24v145Ev();
static  VTBL_ENTRY vtc_S3622C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3622C2[0]),
  (VTBL_ENTRY)&_ZN7S3622C2D1Ev,
  (VTBL_ENTRY)&_ZN7S3622C2D0Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v49Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v50Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v51Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v52Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v53Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v54Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v55Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v56Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v57Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v58Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v59Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v60Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v61Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v62Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v63Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v64Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v65Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v66Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v67Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v68Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v69Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v70Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v71Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v72Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v73Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v74Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v75Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v76Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v77Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v78Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v79Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v80Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v81Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v82Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v83Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v84Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v85Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v86Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v87Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v88Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v89Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v90Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v91Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v92Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v93Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v94Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v95Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v96Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v97Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v98Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v99Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v100Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v101Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v102Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v103Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v104Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v105Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v106Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v107Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v108Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v109Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v110Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v111Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v112Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v113Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v114Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v115Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v116Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v117Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v118Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v119Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v120Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v121Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v122Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v123Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v124Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v125Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v126Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v127Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v128Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v129Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v130Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v131Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v132Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v133Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v134Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v135Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v136Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v137Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v138Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v139Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v140Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v141Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v142Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v143Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v144Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v145Ev,
};
extern VTBL_ENTRY _ZTI7S3622C2[];
extern  VTBL_ENTRY _ZTV7S3622C2[];
Class_Descriptor cd_S3622C2 = {  "S3622C2", // class name
  bases_S3622C2, 1,
  &(vtc_S3622C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(7232,7036), // object size
  NSPAIRA(_ZTI7S3622C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3622C2),101, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3622C35_nt  {
  __tsi64 s3622c35f0[2];
  void  mf3622c35(); // _ZN11S3622C35_nt9mf3622c35Ev
};
//SIG(-1 S3622C35_nt) C1{ m FL[2]}


void  S3622C35_nt ::mf3622c35(){}

//skip512 S3622C35_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3622C34_nt  {
  ::S3622C35_nt s3622c34f0;
  void  mf3622c34(); // _ZN11S3622C34_nt9mf3622c34Ev
};
//SIG(-1 S3622C34_nt) C1{ m FC2{ m FL[2]}}


void  S3622C34_nt ::mf3622c34(){}

//skip512 S3622C34_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3622C33  {
  char s3622c33f0;
  ::S3622C34_nt s3622c33f1;
  ::S3622C34_nt s3622c33f2;
  ::S3622C34_nt s3622c33f3;
  int s3622c33f4[3];
  char s3622c33f5;
  int s3622c33f6;
};
//SIG(1 S3622C33) C1{ Fc FC2{ m FC3{ m FL[2]}} FC2 FC2 Fi[3] Fc Fi}



static void Test_S3622C33()
{
  {
    init_simple_test("S3622C33");
    S3622C33 lv;
    check2(sizeof(lv), ABISELECT(80,72), "sizeof(S3622C33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3622C33)");
    check_field_offset(lv, s3622c33f0, 0, "S3622C33.s3622c33f0");
    check_field_offset(lv, s3622c33f1, ABISELECT(8,4), "S3622C33.s3622c33f1");
    check_field_offset(lv, s3622c33f2, ABISELECT(24,20), "S3622C33.s3622c33f2");
    check_field_offset(lv, s3622c33f3, ABISELECT(40,36), "S3622C33.s3622c33f3");
    check_field_offset(lv, s3622c33f4, ABISELECT(56,52), "S3622C33.s3622c33f4");
    check_field_offset(lv, s3622c33f5, ABISELECT(68,64), "S3622C33.s3622c33f5");
    check_field_offset(lv, s3622c33f6, ABISELECT(72,68), "S3622C33.s3622c33f6");
  }
}
static Arrange_To_Call_Me vS3622C33(Test_S3622C33, "S3622C33", ABISELECT(80,72));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3622C1  : S3622C2 {
  void *s3622c1f0[6];
  int s3622c1f1;
  ::S3625C13_nt s3622c1f2;
  char s3622c1f3[4];
  ::S3625C18_nt s3622c1f4[4];
  __tsi64 s3622c1f5[4];
  ::S3622C33 s3622c1f6[4];
  ::S3625C4_nt s3622c1f7[4];
  char s3622c1f8;
  void *s3622c1f9[2];
  int s3622c1f10;
  char s3622c1f11;
  int s3622c1f12;
  void *s3622c1f13[2];
  int s3622c1f14;
  __tsi64 s3622c1f15[4];
  char s3622c1f16;
  virtual  ~S3622C1(); // _ZN7S3622C1D1Ev
  virtual void  v1(); // _ZN7S3622C12v1Ev
  virtual void  v2(); // _ZN7S3622C12v2Ev
  virtual void  v3(); // _ZN7S3622C12v3Ev
  virtual void  v4(); // _ZN7S3622C12v4Ev
  virtual void  v5(); // _ZN7S3622C12v5Ev
  virtual void  v6(); // _ZN7S3622C12v6Ev
  virtual void  v7(); // _ZN7S3622C12v7Ev
  virtual void  v8(); // _ZN7S3622C12v8Ev
  virtual void  v9(); // _ZN7S3622C12v9Ev
  virtual void  v10(); // _ZN7S3622C13v10Ev
  virtual void  v11(); // _ZN7S3622C13v11Ev
  virtual void  v12(); // _ZN7S3622C13v12Ev
  virtual void  v13(); // _ZN7S3622C13v13Ev
  virtual void  v14(); // _ZN7S3622C13v14Ev
  virtual void  v15(); // _ZN7S3622C13v15Ev
  virtual void  v16(); // _ZN7S3622C13v16Ev
  virtual void  v17(); // _ZN7S3622C13v17Ev
  virtual void  v18(); // _ZN7S3622C13v18Ev
  virtual void  v19(); // _ZN7S3622C13v19Ev
  virtual void  v20(); // _ZN7S3622C13v20Ev
  virtual void  v21(); // _ZN7S3622C13v21Ev
  virtual void  v22(); // _ZN7S3622C13v22Ev
  virtual void  v23(); // _ZN7S3622C13v23Ev
  virtual void  v24(); // _ZN7S3622C13v24Ev
  virtual void  v25(); // _ZN7S3622C13v25Ev
  virtual void  v26(); // _ZN7S3622C13v26Ev
  virtual void  v27(); // _ZN7S3622C13v27Ev
  virtual void  v28(); // _ZN7S3622C13v28Ev
  virtual void  v29(); // _ZN7S3622C13v29Ev
  virtual void  v30(); // _ZN7S3622C13v30Ev
  virtual void  v31(); // _ZN7S3622C13v31Ev
  virtual void  v32(); // _ZN7S3622C13v32Ev
  virtual void  v33(); // _ZN7S3622C13v33Ev
  virtual void  v34(); // _ZN7S3622C13v34Ev
  virtual void  v35(); // _ZN7S3622C13v35Ev
  virtual void  v36(); // _ZN7S3622C13v36Ev
  virtual void  v37(); // _ZN7S3622C13v37Ev
  virtual void  v38(); // _ZN7S3622C13v38Ev
  virtual void  v39(); // _ZN7S3622C13v39Ev
  virtual void  v40(); // _ZN7S3622C13v40Ev
  virtual void  v41(); // _ZN7S3622C13v41Ev
  virtual void  v42(); // _ZN7S3622C13v42Ev
  virtual void  v43(); // _ZN7S3622C13v43Ev
  virtual void  v44(); // _ZN7S3622C13v44Ev
  virtual void  v45(); // _ZN7S3622C13v45Ev
  virtual void  v46(); // _ZN7S3622C13v46Ev
  virtual void  v47(); // _ZN7S3622C13v47Ev
  virtual void  v48(); // _ZN7S3622C13v48Ev
  S3622C1(); // tgen
};
//SIG(1 S3622C1) C1{ BC2{ BC3{ vd m FC4{ m Fp Fi FC5{ m} FC6{ m}} FC4 Fc} vd v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 Fi[3] FC7{ m Fc Fl[2] Fs[12] Fc[5]} FC8{ m Fc Fl[4] Fi[4]} Fi[3] Fp Fc[3] FC9{ m FC10{ m FC11{ FL[4]}} Fc Fp Fi[3]} Fi FC12{ m Fp Fi[2] FC13{ m}} Fp Fi[2] FC10 FC10 Fi[3] Fc[6144] FC14{ m Fp Fi FC15{ m}} FC16{ m Fp Fi[2] FC15} Fc Fi Fc Fi[5] FL[7] Fc FL[9] Fi[2] FC17{ BC18{ m FC19{ m Fc[11]} Fi[7] FL} Fi FC16 FC19 Fi} FC20{ m Fp FC10 FL[2] Fi FL Fi[2] Fc FC14 FC14 FL[5] Fc Fi FC16 FC16 FC16 FC16 FC12 Fi[2]} Fp[3] FL[2] FC14 Fi Fc FL Fc FL} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 Fp[6] Fi FC10 Fc[4] FC14[4] FL[4] FC21{ Fc FC22{ m FC23{ m FL[2]}} FC22 FC22 Fi[3] Fc Fi}[4] FC4[4] Fc Fp[2] Fi Fc Fi Fp[2] Fi FL[4] Fc}


 S3622C1 ::~S3622C1(){ note_dtor("S3622C1", this);}
void  S3622C1 ::v1(){vfunc_called(this, "_ZN7S3622C12v1Ev");}
void  S3622C1 ::v2(){vfunc_called(this, "_ZN7S3622C12v2Ev");}
void  S3622C1 ::v3(){vfunc_called(this, "_ZN7S3622C12v3Ev");}
void  S3622C1 ::v4(){vfunc_called(this, "_ZN7S3622C12v4Ev");}
void  S3622C1 ::v5(){vfunc_called(this, "_ZN7S3622C12v5Ev");}
void  S3622C1 ::v6(){vfunc_called(this, "_ZN7S3622C12v6Ev");}
void  S3622C1 ::v7(){vfunc_called(this, "_ZN7S3622C12v7Ev");}
void  S3622C1 ::v8(){vfunc_called(this, "_ZN7S3622C12v8Ev");}
void  S3622C1 ::v9(){vfunc_called(this, "_ZN7S3622C12v9Ev");}
void  S3622C1 ::v10(){vfunc_called(this, "_ZN7S3622C13v10Ev");}
void  S3622C1 ::v11(){vfunc_called(this, "_ZN7S3622C13v11Ev");}
void  S3622C1 ::v12(){vfunc_called(this, "_ZN7S3622C13v12Ev");}
void  S3622C1 ::v13(){vfunc_called(this, "_ZN7S3622C13v13Ev");}
void  S3622C1 ::v14(){vfunc_called(this, "_ZN7S3622C13v14Ev");}
void  S3622C1 ::v15(){vfunc_called(this, "_ZN7S3622C13v15Ev");}
void  S3622C1 ::v16(){vfunc_called(this, "_ZN7S3622C13v16Ev");}
void  S3622C1 ::v17(){vfunc_called(this, "_ZN7S3622C13v17Ev");}
void  S3622C1 ::v18(){vfunc_called(this, "_ZN7S3622C13v18Ev");}
void  S3622C1 ::v19(){vfunc_called(this, "_ZN7S3622C13v19Ev");}
void  S3622C1 ::v20(){vfunc_called(this, "_ZN7S3622C13v20Ev");}
void  S3622C1 ::v21(){vfunc_called(this, "_ZN7S3622C13v21Ev");}
void  S3622C1 ::v22(){vfunc_called(this, "_ZN7S3622C13v22Ev");}
void  S3622C1 ::v23(){vfunc_called(this, "_ZN7S3622C13v23Ev");}
void  S3622C1 ::v24(){vfunc_called(this, "_ZN7S3622C13v24Ev");}
void  S3622C1 ::v25(){vfunc_called(this, "_ZN7S3622C13v25Ev");}
void  S3622C1 ::v26(){vfunc_called(this, "_ZN7S3622C13v26Ev");}
void  S3622C1 ::v27(){vfunc_called(this, "_ZN7S3622C13v27Ev");}
void  S3622C1 ::v28(){vfunc_called(this, "_ZN7S3622C13v28Ev");}
void  S3622C1 ::v29(){vfunc_called(this, "_ZN7S3622C13v29Ev");}
void  S3622C1 ::v30(){vfunc_called(this, "_ZN7S3622C13v30Ev");}
void  S3622C1 ::v31(){vfunc_called(this, "_ZN7S3622C13v31Ev");}
void  S3622C1 ::v32(){vfunc_called(this, "_ZN7S3622C13v32Ev");}
void  S3622C1 ::v33(){vfunc_called(this, "_ZN7S3622C13v33Ev");}
void  S3622C1 ::v34(){vfunc_called(this, "_ZN7S3622C13v34Ev");}
void  S3622C1 ::v35(){vfunc_called(this, "_ZN7S3622C13v35Ev");}
void  S3622C1 ::v36(){vfunc_called(this, "_ZN7S3622C13v36Ev");}
void  S3622C1 ::v37(){vfunc_called(this, "_ZN7S3622C13v37Ev");}
void  S3622C1 ::v38(){vfunc_called(this, "_ZN7S3622C13v38Ev");}
void  S3622C1 ::v39(){vfunc_called(this, "_ZN7S3622C13v39Ev");}
void  S3622C1 ::v40(){vfunc_called(this, "_ZN7S3622C13v40Ev");}
void  S3622C1 ::v41(){vfunc_called(this, "_ZN7S3622C13v41Ev");}
void  S3622C1 ::v42(){vfunc_called(this, "_ZN7S3622C13v42Ev");}
void  S3622C1 ::v43(){vfunc_called(this, "_ZN7S3622C13v43Ev");}
void  S3622C1 ::v44(){vfunc_called(this, "_ZN7S3622C13v44Ev");}
void  S3622C1 ::v45(){vfunc_called(this, "_ZN7S3622C13v45Ev");}
void  S3622C1 ::v46(){vfunc_called(this, "_ZN7S3622C13v46Ev");}
void  S3622C1 ::v47(){vfunc_called(this, "_ZN7S3622C13v47Ev");}
void  S3622C1 ::v48(){vfunc_called(this, "_ZN7S3622C13v48Ev");}
S3622C1 ::S3622C1(){ note_ctor("S3622C1", this);} // tgen

static void Test_S3622C1()
{
  extern Class_Descriptor cd_S3622C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(990,1898)];
    init_test(&cd_S3622C1, buf);
    S3622C1 *dp, &lv = *(dp=new (buf) S3622C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(7912,7588), "sizeof(S3622C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3622C1)");
    check_base_class_offset(lv, (S3625C3_nt*)(S3622C2*), 0, "S3622C1");
    check_base_class_offset(lv, (S3622C2*), 0, "S3622C1");
    check_field_offset(lv, s3622c1f0, ABISELECT(7232,7036), "S3622C1.s3622c1f0");
    check_field_offset(lv, s3622c1f1, ABISELECT(7280,7060), "S3622C1.s3622c1f1");
    check_field_offset(lv, s3622c1f2, ABISELECT(7288,7064), "S3622C1.s3622c1f2");
    check_field_offset(lv, s3622c1f3, ABISELECT(7320,7096), "S3622C1.s3622c1f3");
    check_field_offset(lv, s3622c1f4, ABISELECT(7328,7100), "S3622C1.s3622c1f4");
    check_field_offset(lv, s3622c1f5, ABISELECT(7392,7148), "S3622C1.s3622c1f5");
    check_field_offset(lv, s3622c1f6, ABISELECT(7424,7180), "S3622C1.s3622c1f6");
    check_field_offset(lv, s3622c1f7, ABISELECT(7744,7468), "S3622C1.s3622c1f7");
    check_field_offset(lv, s3622c1f8, ABISELECT(7808,7516), "S3622C1.s3622c1f8");
    check_field_offset(lv, s3622c1f9, ABISELECT(7816,7520), "S3622C1.s3622c1f9");
    check_field_offset(lv, s3622c1f10, ABISELECT(7832,7528), "S3622C1.s3622c1f10");
    check_field_offset(lv, s3622c1f11, ABISELECT(7836,7532), "S3622C1.s3622c1f11");
    check_field_offset(lv, s3622c1f12, ABISELECT(7840,7536), "S3622C1.s3622c1f12");
    check_field_offset(lv, s3622c1f13, ABISELECT(7848,7540), "S3622C1.s3622c1f13");
    check_field_offset(lv, s3622c1f14, ABISELECT(7864,7548), "S3622C1.s3622c1f14");
    check_field_offset(lv, s3622c1f15, ABISELECT(7872,7552), "S3622C1.s3622c1f15");
    check_field_offset(lv, s3622c1f16, ABISELECT(7904,7584), "S3622C1.s3622c1f16");
    test_class_info(&lv, &cd_S3622C1);
    dp->~S3622C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3622C1(Test_S3622C1, "S3622C1", ABISELECT(7912,7588));

#else // __cplusplus

extern void _ZN7S3622C1C1Ev();
extern void _ZN7S3622C1D1Ev();
Name_Map name_map_S3622C1[] = {
  NSPAIR(_ZN7S3622C1C1Ev),
  NSPAIR(_ZN7S3622C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3625C3_nt;
extern VTBL_ENTRY _ZTI10S3625C3_nt[];
extern  VTBL_ENTRY _ZTV10S3625C3_nt[];
extern Class_Descriptor cd_S3622C2;
extern VTBL_ENTRY _ZTI7S3622C2[];
extern  VTBL_ENTRY _ZTV7S3622C2[];
static Base_Class bases_S3622C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3625C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3622C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3622C1[];
extern void _ZN7S3622C1D1Ev();
extern void _ZN7S3622C1D0Ev();
extern void _ZN7S3622C23v49Ev();
extern void _ZN7S3622C23v50Ev();
extern void _ZN7S3622C23v51Ev();
extern void _ZN7S3622C23v52Ev();
extern void _ZN7S3622C23v53Ev();
extern void _ZN7S3622C23v54Ev();
extern void _ZN7S3622C23v55Ev();
extern void _ZN7S3622C23v56Ev();
extern void _ZN7S3622C23v57Ev();
extern void _ZN7S3622C23v58Ev();
extern void _ZN7S3622C23v59Ev();
extern void _ZN7S3622C23v60Ev();
extern void _ZN7S3622C23v61Ev();
extern void _ZN7S3622C23v62Ev();
extern void _ZN7S3622C23v63Ev();
extern void _ZN7S3622C23v64Ev();
extern void _ZN7S3622C23v65Ev();
extern void _ZN7S3622C23v66Ev();
extern void _ZN7S3622C23v67Ev();
extern void _ZN7S3622C23v68Ev();
extern void _ZN7S3622C23v69Ev();
extern void _ZN7S3622C23v70Ev();
extern void _ZN7S3622C23v71Ev();
extern void _ZN7S3622C23v72Ev();
extern void _ZN7S3622C23v73Ev();
extern void _ZN7S3622C23v74Ev();
extern void _ZN7S3622C23v75Ev();
extern void _ZN7S3622C23v76Ev();
extern void _ZN7S3622C23v77Ev();
extern void _ZN7S3622C23v78Ev();
extern void _ZN7S3622C23v79Ev();
extern void _ZN7S3622C23v80Ev();
extern void _ZN7S3622C23v81Ev();
extern void _ZN7S3622C23v82Ev();
extern void _ZN7S3622C23v83Ev();
extern void _ZN7S3622C23v84Ev();
extern void _ZN7S3622C23v85Ev();
extern void _ZN7S3622C23v86Ev();
extern void _ZN7S3622C23v87Ev();
extern void _ZN7S3622C23v88Ev();
extern void _ZN7S3622C23v89Ev();
extern void _ZN7S3622C23v90Ev();
extern void _ZN7S3622C23v91Ev();
extern void _ZN7S3622C23v92Ev();
extern void _ZN7S3622C23v93Ev();
extern void _ZN7S3622C23v94Ev();
extern void _ZN7S3622C23v95Ev();
extern void _ZN7S3622C23v96Ev();
extern void _ZN7S3622C23v97Ev();
extern void _ZN7S3622C23v98Ev();
extern void _ZN7S3622C23v99Ev();
extern void _ZN7S3622C24v100Ev();
extern void _ZN7S3622C24v101Ev();
extern void _ZN7S3622C24v102Ev();
extern void _ZN7S3622C24v103Ev();
extern void _ZN7S3622C24v104Ev();
extern void _ZN7S3622C24v105Ev();
extern void _ZN7S3622C24v106Ev();
extern void _ZN7S3622C24v107Ev();
extern void _ZN7S3622C24v108Ev();
extern void _ZN7S3622C24v109Ev();
extern void _ZN7S3622C24v110Ev();
extern void _ZN7S3622C24v111Ev();
extern void _ZN7S3622C24v112Ev();
extern void _ZN7S3622C24v113Ev();
extern void _ZN7S3622C24v114Ev();
extern void _ZN7S3622C24v115Ev();
extern void _ZN7S3622C24v116Ev();
extern void _ZN7S3622C24v117Ev();
extern void _ZN7S3622C24v118Ev();
extern void _ZN7S3622C24v119Ev();
extern void _ZN7S3622C24v120Ev();
extern void _ZN7S3622C24v121Ev();
extern void _ZN7S3622C24v122Ev();
extern void _ZN7S3622C24v123Ev();
extern void _ZN7S3622C24v124Ev();
extern void _ZN7S3622C24v125Ev();
extern void _ZN7S3622C24v126Ev();
extern void _ZN7S3622C24v127Ev();
extern void _ZN7S3622C24v128Ev();
extern void _ZN7S3622C24v129Ev();
extern void _ZN7S3622C24v130Ev();
extern void _ZN7S3622C24v131Ev();
extern void _ZN7S3622C24v132Ev();
extern void _ZN7S3622C24v133Ev();
extern void _ZN7S3622C24v134Ev();
extern void _ZN7S3622C24v135Ev();
extern void _ZN7S3622C24v136Ev();
extern void _ZN7S3622C24v137Ev();
extern void _ZN7S3622C24v138Ev();
extern void _ZN7S3622C24v139Ev();
extern void _ZN7S3622C24v140Ev();
extern void _ZN7S3622C24v141Ev();
extern void _ZN7S3622C24v142Ev();
extern void _ZN7S3622C24v143Ev();
extern void _ZN7S3622C24v144Ev();
extern void _ZN7S3622C24v145Ev();
extern void _ZN7S3622C12v1Ev();
extern void _ZN7S3622C12v2Ev();
extern void _ZN7S3622C12v3Ev();
extern void _ZN7S3622C12v4Ev();
extern void _ZN7S3622C12v5Ev();
extern void _ZN7S3622C12v6Ev();
extern void _ZN7S3622C12v7Ev();
extern void _ZN7S3622C12v8Ev();
extern void _ZN7S3622C12v9Ev();
extern void _ZN7S3622C13v10Ev();
extern void _ZN7S3622C13v11Ev();
extern void _ZN7S3622C13v12Ev();
extern void _ZN7S3622C13v13Ev();
extern void _ZN7S3622C13v14Ev();
extern void _ZN7S3622C13v15Ev();
extern void _ZN7S3622C13v16Ev();
extern void _ZN7S3622C13v17Ev();
extern void _ZN7S3622C13v18Ev();
extern void _ZN7S3622C13v19Ev();
extern void _ZN7S3622C13v20Ev();
extern void _ZN7S3622C13v21Ev();
extern void _ZN7S3622C13v22Ev();
extern void _ZN7S3622C13v23Ev();
extern void _ZN7S3622C13v24Ev();
extern void _ZN7S3622C13v25Ev();
extern void _ZN7S3622C13v26Ev();
extern void _ZN7S3622C13v27Ev();
extern void _ZN7S3622C13v28Ev();
extern void _ZN7S3622C13v29Ev();
extern void _ZN7S3622C13v30Ev();
extern void _ZN7S3622C13v31Ev();
extern void _ZN7S3622C13v32Ev();
extern void _ZN7S3622C13v33Ev();
extern void _ZN7S3622C13v34Ev();
extern void _ZN7S3622C13v35Ev();
extern void _ZN7S3622C13v36Ev();
extern void _ZN7S3622C13v37Ev();
extern void _ZN7S3622C13v38Ev();
extern void _ZN7S3622C13v39Ev();
extern void _ZN7S3622C13v40Ev();
extern void _ZN7S3622C13v41Ev();
extern void _ZN7S3622C13v42Ev();
extern void _ZN7S3622C13v43Ev();
extern void _ZN7S3622C13v44Ev();
extern void _ZN7S3622C13v45Ev();
extern void _ZN7S3622C13v46Ev();
extern void _ZN7S3622C13v47Ev();
extern void _ZN7S3622C13v48Ev();
static  VTBL_ENTRY vtc_S3622C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3622C1[0]),
  (VTBL_ENTRY)&_ZN7S3622C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3622C1D0Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v49Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v50Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v51Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v52Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v53Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v54Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v55Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v56Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v57Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v58Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v59Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v60Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v61Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v62Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v63Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v64Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v65Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v66Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v67Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v68Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v69Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v70Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v71Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v72Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v73Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v74Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v75Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v76Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v77Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v78Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v79Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v80Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v81Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v82Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v83Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v84Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v85Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v86Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v87Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v88Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v89Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v90Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v91Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v92Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v93Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v94Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v95Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v96Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v97Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v98Ev,
  (VTBL_ENTRY)&_ZN7S3622C23v99Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v100Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v101Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v102Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v103Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v104Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v105Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v106Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v107Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v108Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v109Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v110Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v111Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v112Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v113Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v114Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v115Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v116Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v117Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v118Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v119Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v120Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v121Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v122Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v123Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v124Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v125Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v126Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v127Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v128Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v129Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v130Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v131Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v132Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v133Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v134Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v135Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v136Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v137Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v138Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v139Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v140Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v141Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v142Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v143Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v144Ev,
  (VTBL_ENTRY)&_ZN7S3622C24v145Ev,
  (VTBL_ENTRY)&_ZN7S3622C12v1Ev,
  (VTBL_ENTRY)&_ZN7S3622C12v2Ev,
  (VTBL_ENTRY)&_ZN7S3622C12v3Ev,
  (VTBL_ENTRY)&_ZN7S3622C12v4Ev,
  (VTBL_ENTRY)&_ZN7S3622C12v5Ev,
  (VTBL_ENTRY)&_ZN7S3622C12v6Ev,
  (VTBL_ENTRY)&_ZN7S3622C12v7Ev,
  (VTBL_ENTRY)&_ZN7S3622C12v8Ev,
  (VTBL_ENTRY)&_ZN7S3622C12v9Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v10Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v11Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v12Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v13Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v14Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v15Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v16Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v17Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v18Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v19Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v20Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v21Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v22Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v23Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v24Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v25Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v26Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v27Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v28Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v29Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v30Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v31Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v32Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v33Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v34Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v35Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v36Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v37Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v38Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v39Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v40Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v41Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v42Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v43Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v44Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v45Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v46Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v47Ev,
  (VTBL_ENTRY)&_ZN7S3622C13v48Ev,
};
extern VTBL_ENTRY _ZTI7S3622C1[];
extern  VTBL_ENTRY _ZTV7S3622C1[];
Class_Descriptor cd_S3622C1 = {  "S3622C1", // class name
  bases_S3622C1, 2,
  &(vtc_S3622C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(7912,7588), // object size
  NSPAIRA(_ZTI7S3622C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3622C1),149, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S534C5  {
  int s534c5f0;
  __tsi64 s534c5f1;
  void *s534c5f2[4];
  int s534c5f3[2];
  void *s534c5f4;
  ::S674C6_nt s534c5f5;
  void *s534c5f6[2];
  virtual  ~S534C5(); // _ZN6S534C5D1Ev
  virtual void  v3(); // _ZN6S534C52v3Ev
  virtual void  v4(); // _ZN6S534C52v4Ev
  virtual void  v5(); // _ZN6S534C52v5Ev
  virtual void  v6(); // _ZN6S534C52v6Ev
  virtual void  v7(); // _ZN6S534C52v7Ev
  virtual void  v8(); // _ZN6S534C52v8Ev
  virtual void  v9(); // _ZN6S534C52v9Ev
  virtual void  v10(); // _ZN6S534C53v10Ev
  virtual void  v11(); // _ZN6S534C53v11Ev
  virtual void  v12(); // _ZN6S534C53v12Ev
  virtual void  v13(); // _ZN6S534C53v13Ev
  virtual void  v14(); // _ZN6S534C53v14Ev
  virtual void  v15(); // _ZN6S534C53v15Ev
  virtual void  v16(); // _ZN6S534C53v16Ev
  virtual void  v17(); // _ZN6S534C53v17Ev
  virtual void  v18(); // _ZN6S534C53v18Ev
  virtual void  v19(); // _ZN6S534C53v19Ev
  virtual void  v20(); // _ZN6S534C53v20Ev
  virtual void  v21(); // _ZN6S534C53v21Ev
  virtual void  v22(); // _ZN6S534C53v22Ev
  virtual void  v23(); // _ZN6S534C53v23Ev
  virtual void  v24(); // _ZN6S534C53v24Ev
  virtual void  v25(); // _ZN6S534C53v25Ev
  virtual void  v26(); // _ZN6S534C53v26Ev
  virtual void  v27(); // _ZN6S534C53v27Ev
  virtual void  v28(); // _ZN6S534C53v28Ev
  virtual void  v29(); // _ZN6S534C53v29Ev
  virtual void  v30(); // _ZN6S534C53v30Ev
  virtual void  v31(); // _ZN6S534C53v31Ev
  virtual void  v32(); // _ZN6S534C53v32Ev
  virtual void  v33(); // _ZN6S534C53v33Ev
  virtual void  v34(); // _ZN6S534C53v34Ev
  virtual void  v35(); // _ZN6S534C53v35Ev
  virtual void  v36(); // _ZN6S534C53v36Ev
  virtual void  v37(); // _ZN6S534C53v37Ev
  virtual void  v38(); // _ZN6S534C53v38Ev
  virtual void  v39(); // _ZN6S534C53v39Ev
  virtual void  v40(); // _ZN6S534C53v40Ev
  virtual void  v41(); // _ZN6S534C53v41Ev
  virtual void  v42(); // _ZN6S534C53v42Ev
  virtual void  v43(); // _ZN6S534C53v43Ev
  virtual void  v44(); // _ZN6S534C53v44Ev
  virtual void  v45(); // _ZN6S534C53v45Ev
  virtual void  v46(); // _ZN6S534C53v46Ev
  virtual void  v47(); // _ZN6S534C53v47Ev
  virtual void  v48(); // _ZN6S534C53v48Ev
  virtual void  v49(); // _ZN6S534C53v49Ev
  virtual void  v50(); // _ZN6S534C53v50Ev
  virtual void  v51(); // _ZN6S534C53v51Ev
  virtual void  v52(); // _ZN6S534C53v52Ev
  virtual void  v53(); // _ZN6S534C53v53Ev
  virtual void  v54(); // _ZN6S534C53v54Ev
  virtual void  v55(); // _ZN6S534C53v55Ev
  virtual void  v56(); // _ZN6S534C53v56Ev
  virtual void  v57(); // _ZN6S534C53v57Ev
  virtual void  v58(); // _ZN6S534C53v58Ev
  virtual void  v59(); // _ZN6S534C53v59Ev
  virtual void  v60(); // _ZN6S534C53v60Ev
  virtual void  v61(); // _ZN6S534C53v61Ev
  virtual void  v62(); // _ZN6S534C53v62Ev
  virtual void  v63(); // _ZN6S534C53v63Ev
  virtual void  v64(); // _ZN6S534C53v64Ev
  virtual void  v65(); // _ZN6S534C53v65Ev
  virtual void  v66(); // _ZN6S534C53v66Ev
  S534C5(); // tgen
};
//SIG(-1 S534C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S534C5 ::~S534C5(){ note_dtor("S534C5", this);}
void  S534C5 ::v3(){vfunc_called(this, "_ZN6S534C52v3Ev");}
void  S534C5 ::v4(){vfunc_called(this, "_ZN6S534C52v4Ev");}
void  S534C5 ::v5(){vfunc_called(this, "_ZN6S534C52v5Ev");}
void  S534C5 ::v6(){vfunc_called(this, "_ZN6S534C52v6Ev");}
void  S534C5 ::v7(){vfunc_called(this, "_ZN6S534C52v7Ev");}
void  S534C5 ::v8(){vfunc_called(this, "_ZN6S534C52v8Ev");}
void  S534C5 ::v9(){vfunc_called(this, "_ZN6S534C52v9Ev");}
void  S534C5 ::v10(){vfunc_called(this, "_ZN6S534C53v10Ev");}
void  S534C5 ::v11(){vfunc_called(this, "_ZN6S534C53v11Ev");}
void  S534C5 ::v12(){vfunc_called(this, "_ZN6S534C53v12Ev");}
void  S534C5 ::v13(){vfunc_called(this, "_ZN6S534C53v13Ev");}
void  S534C5 ::v14(){vfunc_called(this, "_ZN6S534C53v14Ev");}
void  S534C5 ::v15(){vfunc_called(this, "_ZN6S534C53v15Ev");}
void  S534C5 ::v16(){vfunc_called(this, "_ZN6S534C53v16Ev");}
void  S534C5 ::v17(){vfunc_called(this, "_ZN6S534C53v17Ev");}
void  S534C5 ::v18(){vfunc_called(this, "_ZN6S534C53v18Ev");}
void  S534C5 ::v19(){vfunc_called(this, "_ZN6S534C53v19Ev");}
void  S534C5 ::v20(){vfunc_called(this, "_ZN6S534C53v20Ev");}
void  S534C5 ::v21(){vfunc_called(this, "_ZN6S534C53v21Ev");}
void  S534C5 ::v22(){vfunc_called(this, "_ZN6S534C53v22Ev");}
void  S534C5 ::v23(){vfunc_called(this, "_ZN6S534C53v23Ev");}
void  S534C5 ::v24(){vfunc_called(this, "_ZN6S534C53v24Ev");}
void  S534C5 ::v25(){vfunc_called(this, "_ZN6S534C53v25Ev");}
void  S534C5 ::v26(){vfunc_called(this, "_ZN6S534C53v26Ev");}
void  S534C5 ::v27(){vfunc_called(this, "_ZN6S534C53v27Ev");}
void  S534C5 ::v28(){vfunc_called(this, "_ZN6S534C53v28Ev");}
void  S534C5 ::v29(){vfunc_called(this, "_ZN6S534C53v29Ev");}
void  S534C5 ::v30(){vfunc_called(this, "_ZN6S534C53v30Ev");}
void  S534C5 ::v31(){vfunc_called(this, "_ZN6S534C53v31Ev");}
void  S534C5 ::v32(){vfunc_called(this, "_ZN6S534C53v32Ev");}
void  S534C5 ::v33(){vfunc_called(this, "_ZN6S534C53v33Ev");}
void  S534C5 ::v34(){vfunc_called(this, "_ZN6S534C53v34Ev");}
void  S534C5 ::v35(){vfunc_called(this, "_ZN6S534C53v35Ev");}
void  S534C5 ::v36(){vfunc_called(this, "_ZN6S534C53v36Ev");}
void  S534C5 ::v37(){vfunc_called(this, "_ZN6S534C53v37Ev");}
void  S534C5 ::v38(){vfunc_called(this, "_ZN6S534C53v38Ev");}
void  S534C5 ::v39(){vfunc_called(this, "_ZN6S534C53v39Ev");}
void  S534C5 ::v40(){vfunc_called(this, "_ZN6S534C53v40Ev");}
void  S534C5 ::v41(){vfunc_called(this, "_ZN6S534C53v41Ev");}
void  S534C5 ::v42(){vfunc_called(this, "_ZN6S534C53v42Ev");}
void  S534C5 ::v43(){vfunc_called(this, "_ZN6S534C53v43Ev");}
void  S534C5 ::v44(){vfunc_called(this, "_ZN6S534C53v44Ev");}
void  S534C5 ::v45(){vfunc_called(this, "_ZN6S534C53v45Ev");}
void  S534C5 ::v46(){vfunc_called(this, "_ZN6S534C53v46Ev");}
void  S534C5 ::v47(){vfunc_called(this, "_ZN6S534C53v47Ev");}
void  S534C5 ::v48(){vfunc_called(this, "_ZN6S534C53v48Ev");}
void  S534C5 ::v49(){vfunc_called(this, "_ZN6S534C53v49Ev");}
void  S534C5 ::v50(){vfunc_called(this, "_ZN6S534C53v50Ev");}
void  S534C5 ::v51(){vfunc_called(this, "_ZN6S534C53v51Ev");}
void  S534C5 ::v52(){vfunc_called(this, "_ZN6S534C53v52Ev");}
void  S534C5 ::v53(){vfunc_called(this, "_ZN6S534C53v53Ev");}
void  S534C5 ::v54(){vfunc_called(this, "_ZN6S534C53v54Ev");}
void  S534C5 ::v55(){vfunc_called(this, "_ZN6S534C53v55Ev");}
void  S534C5 ::v56(){vfunc_called(this, "_ZN6S534C53v56Ev");}
void  S534C5 ::v57(){vfunc_called(this, "_ZN6S534C53v57Ev");}
void  S534C5 ::v58(){vfunc_called(this, "_ZN6S534C53v58Ev");}
void  S534C5 ::v59(){vfunc_called(this, "_ZN6S534C53v59Ev");}
void  S534C5 ::v60(){vfunc_called(this, "_ZN6S534C53v60Ev");}
void  S534C5 ::v61(){vfunc_called(this, "_ZN6S534C53v61Ev");}
void  S534C5 ::v62(){vfunc_called(this, "_ZN6S534C53v62Ev");}
void  S534C5 ::v63(){vfunc_called(this, "_ZN6S534C53v63Ev");}
void  S534C5 ::v64(){vfunc_called(this, "_ZN6S534C53v64Ev");}
void  S534C5 ::v65(){vfunc_called(this, "_ZN6S534C53v65Ev");}
void  S534C5 ::v66(){vfunc_called(this, "_ZN6S534C53v66Ev");}
S534C5 ::S534C5(){ note_ctor("S534C5", this);} // tgen

static void Test_S534C5()
{
  extern Class_Descriptor cd_S534C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S534C5, buf);
    S534C5 *dp, &lv = *(dp=new (buf) S534C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S534C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S534C5)");
    check_field_offset(lv, s534c5f0, ABISELECT(8,4), "S534C5.s534c5f0");
    check_field_offset(lv, s534c5f1, ABISELECT(16,8), "S534C5.s534c5f1");
    check_field_offset(lv, s534c5f2, ABISELECT(24,16), "S534C5.s534c5f2");
    check_field_offset(lv, s534c5f3, ABISELECT(56,32), "S534C5.s534c5f3");
    check_field_offset(lv, s534c5f4, ABISELECT(64,40), "S534C5.s534c5f4");
    check_field_offset(lv, s534c5f5, ABISELECT(72,44), "S534C5.s534c5f5");
    check_field_offset(lv, s534c5f6, ABISELECT(80,52), "S534C5.s534c5f6");
    test_class_info(&lv, &cd_S534C5);
    dp->~S534C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS534C5(Test_S534C5, "S534C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S534C5C1Ev();
extern void _ZN6S534C5D1Ev();
Name_Map name_map_S534C5[] = {
  NSPAIR(_ZN6S534C5C1Ev),
  NSPAIR(_ZN6S534C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S534C5[];
extern void _ZN6S534C5D1Ev();
extern void _ZN6S534C5D0Ev();
extern void _ZN6S534C52v3Ev();
extern void _ZN6S534C52v4Ev();
extern void _ZN6S534C52v5Ev();
extern void _ZN6S534C52v6Ev();
extern void _ZN6S534C52v7Ev();
extern void _ZN6S534C52v8Ev();
extern void _ZN6S534C52v9Ev();
extern void _ZN6S534C53v10Ev();
extern void _ZN6S534C53v11Ev();
extern void _ZN6S534C53v12Ev();
extern void _ZN6S534C53v13Ev();
extern void _ZN6S534C53v14Ev();
extern void _ZN6S534C53v15Ev();
extern void _ZN6S534C53v16Ev();
extern void _ZN6S534C53v17Ev();
extern void _ZN6S534C53v18Ev();
extern void _ZN6S534C53v19Ev();
extern void _ZN6S534C53v20Ev();
extern void _ZN6S534C53v21Ev();
extern void _ZN6S534C53v22Ev();
extern void _ZN6S534C53v23Ev();
extern void _ZN6S534C53v24Ev();
extern void _ZN6S534C53v25Ev();
extern void _ZN6S534C53v26Ev();
extern void _ZN6S534C53v27Ev();
extern void _ZN6S534C53v28Ev();
extern void _ZN6S534C53v29Ev();
extern void _ZN6S534C53v30Ev();
extern void _ZN6S534C53v31Ev();
extern void _ZN6S534C53v32Ev();
extern void _ZN6S534C53v33Ev();
extern void _ZN6S534C53v34Ev();
extern void _ZN6S534C53v35Ev();
extern void _ZN6S534C53v36Ev();
extern void _ZN6S534C53v37Ev();
extern void _ZN6S534C53v38Ev();
extern void _ZN6S534C53v39Ev();
extern void _ZN6S534C53v40Ev();
extern void _ZN6S534C53v41Ev();
extern void _ZN6S534C53v42Ev();
extern void _ZN6S534C53v43Ev();
extern void _ZN6S534C53v44Ev();
extern void _ZN6S534C53v45Ev();
extern void _ZN6S534C53v46Ev();
extern void _ZN6S534C53v47Ev();
extern void _ZN6S534C53v48Ev();
extern void _ZN6S534C53v49Ev();
extern void _ZN6S534C53v50Ev();
extern void _ZN6S534C53v51Ev();
extern void _ZN6S534C53v52Ev();
extern void _ZN6S534C53v53Ev();
extern void _ZN6S534C53v54Ev();
extern void _ZN6S534C53v55Ev();
extern void _ZN6S534C53v56Ev();
extern void _ZN6S534C53v57Ev();
extern void _ZN6S534C53v58Ev();
extern void _ZN6S534C53v59Ev();
extern void _ZN6S534C53v60Ev();
extern void _ZN6S534C53v61Ev();
extern void _ZN6S534C53v62Ev();
extern void _ZN6S534C53v63Ev();
extern void _ZN6S534C53v64Ev();
extern void _ZN6S534C53v65Ev();
extern void _ZN6S534C53v66Ev();
static  VTBL_ENTRY vtc_S534C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S534C5[0]),
  (VTBL_ENTRY)&_ZN6S534C5D1Ev,
  (VTBL_ENTRY)&_ZN6S534C5D0Ev,
  (VTBL_ENTRY)&_ZN6S534C52v3Ev,
  (VTBL_ENTRY)&_ZN6S534C52v4Ev,
  (VTBL_ENTRY)&_ZN6S534C52v5Ev,
  (VTBL_ENTRY)&_ZN6S534C52v6Ev,
  (VTBL_ENTRY)&_ZN6S534C52v7Ev,
  (VTBL_ENTRY)&_ZN6S534C52v8Ev,
  (VTBL_ENTRY)&_ZN6S534C52v9Ev,
  (VTBL_ENTRY)&_ZN6S534C53v10Ev,
  (VTBL_ENTRY)&_ZN6S534C53v11Ev,
  (VTBL_ENTRY)&_ZN6S534C53v12Ev,
  (VTBL_ENTRY)&_ZN6S534C53v13Ev,
  (VTBL_ENTRY)&_ZN6S534C53v14Ev,
  (VTBL_ENTRY)&_ZN6S534C53v15Ev,
  (VTBL_ENTRY)&_ZN6S534C53v16Ev,
  (VTBL_ENTRY)&_ZN6S534C53v17Ev,
  (VTBL_ENTRY)&_ZN6S534C53v18Ev,
  (VTBL_ENTRY)&_ZN6S534C53v19Ev,
  (VTBL_ENTRY)&_ZN6S534C53v20Ev,
  (VTBL_ENTRY)&_ZN6S534C53v21Ev,
  (VTBL_ENTRY)&_ZN6S534C53v22Ev,
  (VTBL_ENTRY)&_ZN6S534C53v23Ev,
  (VTBL_ENTRY)&_ZN6S534C53v24Ev,
  (VTBL_ENTRY)&_ZN6S534C53v25Ev,
  (VTBL_ENTRY)&_ZN6S534C53v26Ev,
  (VTBL_ENTRY)&_ZN6S534C53v27Ev,
  (VTBL_ENTRY)&_ZN6S534C53v28Ev,
  (VTBL_ENTRY)&_ZN6S534C53v29Ev,
  (VTBL_ENTRY)&_ZN6S534C53v30Ev,
  (VTBL_ENTRY)&_ZN6S534C53v31Ev,
  (VTBL_ENTRY)&_ZN6S534C53v32Ev,
  (VTBL_ENTRY)&_ZN6S534C53v33Ev,
  (VTBL_ENTRY)&_ZN6S534C53v34Ev,
  (VTBL_ENTRY)&_ZN6S534C53v35Ev,
  (VTBL_ENTRY)&_ZN6S534C53v36Ev,
  (VTBL_ENTRY)&_ZN6S534C53v37Ev,
  (VTBL_ENTRY)&_ZN6S534C53v38Ev,
  (VTBL_ENTRY)&_ZN6S534C53v39Ev,
  (VTBL_ENTRY)&_ZN6S534C53v40Ev,
  (VTBL_ENTRY)&_ZN6S534C53v41Ev,
  (VTBL_ENTRY)&_ZN6S534C53v42Ev,
  (VTBL_ENTRY)&_ZN6S534C53v43Ev,
  (VTBL_ENTRY)&_ZN6S534C53v44Ev,
  (VTBL_ENTRY)&_ZN6S534C53v45Ev,
  (VTBL_ENTRY)&_ZN6S534C53v46Ev,
  (VTBL_ENTRY)&_ZN6S534C53v47Ev,
  (VTBL_ENTRY)&_ZN6S534C53v48Ev,
  (VTBL_ENTRY)&_ZN6S534C53v49Ev,
  (VTBL_ENTRY)&_ZN6S534C53v50Ev,
  (VTBL_ENTRY)&_ZN6S534C53v51Ev,
  (VTBL_ENTRY)&_ZN6S534C53v52Ev,
  (VTBL_ENTRY)&_ZN6S534C53v53Ev,
  (VTBL_ENTRY)&_ZN6S534C53v54Ev,
  (VTBL_ENTRY)&_ZN6S534C53v55Ev,
  (VTBL_ENTRY)&_ZN6S534C53v56Ev,
  (VTBL_ENTRY)&_ZN6S534C53v57Ev,
  (VTBL_ENTRY)&_ZN6S534C53v58Ev,
  (VTBL_ENTRY)&_ZN6S534C53v59Ev,
  (VTBL_ENTRY)&_ZN6S534C53v60Ev,
  (VTBL_ENTRY)&_ZN6S534C53v61Ev,
  (VTBL_ENTRY)&_ZN6S534C53v62Ev,
  (VTBL_ENTRY)&_ZN6S534C53v63Ev,
  (VTBL_ENTRY)&_ZN6S534C53v64Ev,
  (VTBL_ENTRY)&_ZN6S534C53v65Ev,
  (VTBL_ENTRY)&_ZN6S534C53v66Ev,
};
extern VTBL_ENTRY _ZTI6S534C5[];
extern  VTBL_ENTRY _ZTV6S534C5[];
Class_Descriptor cd_S534C5 = {  "S534C5", // class name
  0,0,//no base classes
  &(vtc_S534C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S534C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S534C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S534C4_nt  : S534C5 {
  int s534c4f0[2];
  void *s534c4f1;
  int s534c4f2[2];
  ::S674C37_nt s534c4f3;
  ::S674C37_nt s534c4f4;
  ::S3625C32 s534c4f5;
  ::S674C37_nt s534c4f6;
  unsigned int s534c4f7:1;
  unsigned int s534c4f8:1;
  unsigned int s534c4f9:1;
  unsigned int s534c4f10:1;
  unsigned int s534c4f11:1;
  int s534c4f12[2];
  virtual  ~S534C4_nt(); // _ZN9S534C4_ntD1Ev
  virtual void  v67(); // _ZN9S534C4_nt3v67Ev
  virtual void  v68(); // _ZN9S534C4_nt3v68Ev
  virtual void  v69(); // _ZN9S534C4_nt3v69Ev
  virtual void  v70(); // _ZN9S534C4_nt3v70Ev
  virtual void  v71(); // _ZN9S534C4_nt3v71Ev
  virtual void  v72(); // _ZN9S534C4_nt3v72Ev
  virtual void  v73(); // _ZN9S534C4_nt3v73Ev
  virtual void  v74(); // _ZN9S534C4_nt3v74Ev
  virtual void  v75(); // _ZN9S534C4_nt3v75Ev
  virtual void  v76(); // _ZN9S534C4_nt3v76Ev
  virtual void  v77(); // _ZN9S534C4_nt3v77Ev
  virtual void  v78(); // _ZN9S534C4_nt3v78Ev
  virtual void  v79(); // _ZN9S534C4_nt3v79Ev
  virtual void  v80(); // _ZN9S534C4_nt3v80Ev
  virtual void  v81(); // _ZN9S534C4_nt3v81Ev
  virtual void  v82(); // _ZN9S534C4_nt3v82Ev
  virtual void  v83(); // _ZN9S534C4_nt3v83Ev
  virtual void  v84(); // _ZN9S534C4_nt3v84Ev
  virtual void  v85(); // _ZN9S534C4_nt3v85Ev
  virtual void  v86(); // _ZN9S534C4_nt3v86Ev
  virtual void  v87(); // _ZN9S534C4_nt3v87Ev
  virtual void  v88(); // _ZN9S534C4_nt3v88Ev
  S534C4_nt(); // tgen
};
//SIG(-1 S534C4_nt) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S534C4_nt ::~S534C4_nt(){ note_dtor("S534C4_nt", this);}
void  S534C4_nt ::v67(){vfunc_called(this, "_ZN9S534C4_nt3v67Ev");}
void  S534C4_nt ::v68(){vfunc_called(this, "_ZN9S534C4_nt3v68Ev");}
void  S534C4_nt ::v69(){vfunc_called(this, "_ZN9S534C4_nt3v69Ev");}
void  S534C4_nt ::v70(){vfunc_called(this, "_ZN9S534C4_nt3v70Ev");}
void  S534C4_nt ::v71(){vfunc_called(this, "_ZN9S534C4_nt3v71Ev");}
void  S534C4_nt ::v72(){vfunc_called(this, "_ZN9S534C4_nt3v72Ev");}
void  S534C4_nt ::v73(){vfunc_called(this, "_ZN9S534C4_nt3v73Ev");}
void  S534C4_nt ::v74(){vfunc_called(this, "_ZN9S534C4_nt3v74Ev");}
void  S534C4_nt ::v75(){vfunc_called(this, "_ZN9S534C4_nt3v75Ev");}
void  S534C4_nt ::v76(){vfunc_called(this, "_ZN9S534C4_nt3v76Ev");}
void  S534C4_nt ::v77(){vfunc_called(this, "_ZN9S534C4_nt3v77Ev");}
void  S534C4_nt ::v78(){vfunc_called(this, "_ZN9S534C4_nt3v78Ev");}
void  S534C4_nt ::v79(){vfunc_called(this, "_ZN9S534C4_nt3v79Ev");}
void  S534C4_nt ::v80(){vfunc_called(this, "_ZN9S534C4_nt3v80Ev");}
void  S534C4_nt ::v81(){vfunc_called(this, "_ZN9S534C4_nt3v81Ev");}
void  S534C4_nt ::v82(){vfunc_called(this, "_ZN9S534C4_nt3v82Ev");}
void  S534C4_nt ::v83(){vfunc_called(this, "_ZN9S534C4_nt3v83Ev");}
void  S534C4_nt ::v84(){vfunc_called(this, "_ZN9S534C4_nt3v84Ev");}
void  S534C4_nt ::v85(){vfunc_called(this, "_ZN9S534C4_nt3v85Ev");}
void  S534C4_nt ::v86(){vfunc_called(this, "_ZN9S534C4_nt3v86Ev");}
void  S534C4_nt ::v87(){vfunc_called(this, "_ZN9S534C4_nt3v87Ev");}
void  S534C4_nt ::v88(){vfunc_called(this, "_ZN9S534C4_nt3v88Ev");}
S534C4_nt ::S534C4_nt(){ note_ctor("S534C4_nt", this);} // tgen

//skip512 S534C4_nt

#else // __cplusplus

extern void _ZN9S534C4_ntC1Ev();
extern void _ZN9S534C4_ntD1Ev();
Name_Map name_map_S534C4_nt[] = {
  NSPAIR(_ZN9S534C4_ntC1Ev),
  NSPAIR(_ZN9S534C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S534C5;
extern VTBL_ENTRY _ZTI6S534C5[];
extern  VTBL_ENTRY _ZTV6S534C5[];
static Base_Class bases_S534C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S534C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S534C4_nt[];
extern void _ZN9S534C4_ntD1Ev();
extern void _ZN9S534C4_ntD0Ev();
extern void _ZN6S534C52v3Ev();
extern void _ZN6S534C52v4Ev();
extern void _ZN6S534C52v5Ev();
extern void _ZN6S534C52v6Ev();
extern void _ZN6S534C52v7Ev();
extern void _ZN6S534C52v8Ev();
extern void _ZN6S534C52v9Ev();
extern void _ZN6S534C53v10Ev();
extern void _ZN6S534C53v11Ev();
extern void _ZN6S534C53v12Ev();
extern void _ZN6S534C53v13Ev();
extern void _ZN6S534C53v14Ev();
extern void _ZN6S534C53v15Ev();
extern void _ZN6S534C53v16Ev();
extern void _ZN6S534C53v17Ev();
extern void _ZN6S534C53v18Ev();
extern void _ZN6S534C53v19Ev();
extern void _ZN6S534C53v20Ev();
extern void _ZN6S534C53v21Ev();
extern void _ZN6S534C53v22Ev();
extern void _ZN6S534C53v23Ev();
extern void _ZN6S534C53v24Ev();
extern void _ZN6S534C53v25Ev();
extern void _ZN6S534C53v26Ev();
extern void _ZN6S534C53v27Ev();
extern void _ZN6S534C53v28Ev();
extern void _ZN6S534C53v29Ev();
extern void _ZN6S534C53v30Ev();
extern void _ZN6S534C53v31Ev();
extern void _ZN6S534C53v32Ev();
extern void _ZN6S534C53v33Ev();
extern void _ZN6S534C53v34Ev();
extern void _ZN6S534C53v35Ev();
extern void _ZN6S534C53v36Ev();
extern void _ZN6S534C53v37Ev();
extern void _ZN6S534C53v38Ev();
extern void _ZN6S534C53v39Ev();
extern void _ZN6S534C53v40Ev();
extern void _ZN6S534C53v41Ev();
extern void _ZN6S534C53v42Ev();
extern void _ZN6S534C53v43Ev();
extern void _ZN6S534C53v44Ev();
extern void _ZN6S534C53v45Ev();
extern void _ZN6S534C53v46Ev();
extern void _ZN6S534C53v47Ev();
extern void _ZN6S534C53v48Ev();
extern void _ZN6S534C53v49Ev();
extern void _ZN6S534C53v50Ev();
extern void _ZN6S534C53v51Ev();
extern void _ZN6S534C53v52Ev();
extern void _ZN6S534C53v53Ev();
extern void _ZN6S534C53v54Ev();
extern void _ZN6S534C53v55Ev();
extern void _ZN6S534C53v56Ev();
extern void _ZN6S534C53v57Ev();
extern void _ZN6S534C53v58Ev();
extern void _ZN6S534C53v59Ev();
extern void _ZN6S534C53v60Ev();
extern void _ZN6S534C53v61Ev();
extern void _ZN6S534C53v62Ev();
extern void _ZN6S534C53v63Ev();
extern void _ZN6S534C53v64Ev();
extern void _ZN6S534C53v65Ev();
extern void _ZN6S534C53v66Ev();
extern void _ZN9S534C4_nt3v67Ev();
extern void _ZN9S534C4_nt3v68Ev();
extern void _ZN9S534C4_nt3v69Ev();
extern void _ZN9S534C4_nt3v70Ev();
extern void _ZN9S534C4_nt3v71Ev();
extern void _ZN9S534C4_nt3v72Ev();
extern void _ZN9S534C4_nt3v73Ev();
extern void _ZN9S534C4_nt3v74Ev();
extern void _ZN9S534C4_nt3v75Ev();
extern void _ZN9S534C4_nt3v76Ev();
extern void _ZN9S534C4_nt3v77Ev();
extern void _ZN9S534C4_nt3v78Ev();
extern void _ZN9S534C4_nt3v79Ev();
extern void _ZN9S534C4_nt3v80Ev();
extern void _ZN9S534C4_nt3v81Ev();
extern void _ZN9S534C4_nt3v82Ev();
extern void _ZN9S534C4_nt3v83Ev();
extern void _ZN9S534C4_nt3v84Ev();
extern void _ZN9S534C4_nt3v85Ev();
extern void _ZN9S534C4_nt3v86Ev();
extern void _ZN9S534C4_nt3v87Ev();
extern void _ZN9S534C4_nt3v88Ev();
static  VTBL_ENTRY vtc_S534C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S534C4_nt[0]),
  (VTBL_ENTRY)&_ZN9S534C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S534C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S534C52v3Ev,
  (VTBL_ENTRY)&_ZN6S534C52v4Ev,
  (VTBL_ENTRY)&_ZN6S534C52v5Ev,
  (VTBL_ENTRY)&_ZN6S534C52v6Ev,
  (VTBL_ENTRY)&_ZN6S534C52v7Ev,
  (VTBL_ENTRY)&_ZN6S534C52v8Ev,
  (VTBL_ENTRY)&_ZN6S534C52v9Ev,
  (VTBL_ENTRY)&_ZN6S534C53v10Ev,
  (VTBL_ENTRY)&_ZN6S534C53v11Ev,
  (VTBL_ENTRY)&_ZN6S534C53v12Ev,
  (VTBL_ENTRY)&_ZN6S534C53v13Ev,
  (VTBL_ENTRY)&_ZN6S534C53v14Ev,
  (VTBL_ENTRY)&_ZN6S534C53v15Ev,
  (VTBL_ENTRY)&_ZN6S534C53v16Ev,
  (VTBL_ENTRY)&_ZN6S534C53v17Ev,
  (VTBL_ENTRY)&_ZN6S534C53v18Ev,
  (VTBL_ENTRY)&_ZN6S534C53v19Ev,
  (VTBL_ENTRY)&_ZN6S534C53v20Ev,
  (VTBL_ENTRY)&_ZN6S534C53v21Ev,
  (VTBL_ENTRY)&_ZN6S534C53v22Ev,
  (VTBL_ENTRY)&_ZN6S534C53v23Ev,
  (VTBL_ENTRY)&_ZN6S534C53v24Ev,
  (VTBL_ENTRY)&_ZN6S534C53v25Ev,
  (VTBL_ENTRY)&_ZN6S534C53v26Ev,
  (VTBL_ENTRY)&_ZN6S534C53v27Ev,
  (VTBL_ENTRY)&_ZN6S534C53v28Ev,
  (VTBL_ENTRY)&_ZN6S534C53v29Ev,
  (VTBL_ENTRY)&_ZN6S534C53v30Ev,
  (VTBL_ENTRY)&_ZN6S534C53v31Ev,
  (VTBL_ENTRY)&_ZN6S534C53v32Ev,
  (VTBL_ENTRY)&_ZN6S534C53v33Ev,
  (VTBL_ENTRY)&_ZN6S534C53v34Ev,
  (VTBL_ENTRY)&_ZN6S534C53v35Ev,
  (VTBL_ENTRY)&_ZN6S534C53v36Ev,
  (VTBL_ENTRY)&_ZN6S534C53v37Ev,
  (VTBL_ENTRY)&_ZN6S534C53v38Ev,
  (VTBL_ENTRY)&_ZN6S534C53v39Ev,
  (VTBL_ENTRY)&_ZN6S534C53v40Ev,
  (VTBL_ENTRY)&_ZN6S534C53v41Ev,
  (VTBL_ENTRY)&_ZN6S534C53v42Ev,
  (VTBL_ENTRY)&_ZN6S534C53v43Ev,
  (VTBL_ENTRY)&_ZN6S534C53v44Ev,
  (VTBL_ENTRY)&_ZN6S534C53v45Ev,
  (VTBL_ENTRY)&_ZN6S534C53v46Ev,
  (VTBL_ENTRY)&_ZN6S534C53v47Ev,
  (VTBL_ENTRY)&_ZN6S534C53v48Ev,
  (VTBL_ENTRY)&_ZN6S534C53v49Ev,
  (VTBL_ENTRY)&_ZN6S534C53v50Ev,
  (VTBL_ENTRY)&_ZN6S534C53v51Ev,
  (VTBL_ENTRY)&_ZN6S534C53v52Ev,
  (VTBL_ENTRY)&_ZN6S534C53v53Ev,
  (VTBL_ENTRY)&_ZN6S534C53v54Ev,
  (VTBL_ENTRY)&_ZN6S534C53v55Ev,
  (VTBL_ENTRY)&_ZN6S534C53v56Ev,
  (VTBL_ENTRY)&_ZN6S534C53v57Ev,
  (VTBL_ENTRY)&_ZN6S534C53v58Ev,
  (VTBL_ENTRY)&_ZN6S534C53v59Ev,
  (VTBL_ENTRY)&_ZN6S534C53v60Ev,
  (VTBL_ENTRY)&_ZN6S534C53v61Ev,
  (VTBL_ENTRY)&_ZN6S534C53v62Ev,
  (VTBL_ENTRY)&_ZN6S534C53v63Ev,
  (VTBL_ENTRY)&_ZN6S534C53v64Ev,
  (VTBL_ENTRY)&_ZN6S534C53v65Ev,
  (VTBL_ENTRY)&_ZN6S534C53v66Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v88Ev,
};
extern VTBL_ENTRY _ZTI9S534C4_nt[];
VTBL_ENTRY *P__ZTI9S534C4_nt = _ZTI9S534C4_nt; 
extern  VTBL_ENTRY _ZTV9S534C4_nt[];
Class_Descriptor cd_S534C4_nt = {  "S534C4_nt", // class name
  bases_S534C4_nt, 1,
  &(vtc_S534C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI9S534C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S534C4_nt),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S534C3_nt  : S534C4_nt {
  unsigned int s534c3f0:1;
  unsigned int s534c3f1:1;
  unsigned int s534c3f2:1;
  ::S674C42 s534c3f3;
  ::S674C38 s534c3f4;
  ::S674C17 s534c3f5;
  ::S674C13 s534c3f6;
  int s534c3f7[3];
  virtual  ~S534C3_nt(); // _ZN9S534C3_ntD1Ev
  virtual void  v89(); // _ZN9S534C3_nt3v89Ev
  virtual void  v90(); // _ZN9S534C3_nt3v90Ev
  virtual void  v91(); // _ZN9S534C3_nt3v91Ev
  virtual void  v92(); // _ZN9S534C3_nt3v92Ev
  virtual void  v93(); // _ZN9S534C3_nt3v93Ev
  virtual void  v94(); // _ZN9S534C3_nt3v94Ev
  virtual void  v95(); // _ZN9S534C3_nt3v95Ev
  virtual void  v96(); // _ZN9S534C3_nt3v96Ev
  virtual void  v97(); // _ZN9S534C3_nt3v97Ev
  virtual void  v98(); // _ZN9S534C3_nt3v98Ev
  virtual void  v99(); // _ZN9S534C3_nt3v99Ev
  virtual void  v100(); // _ZN9S534C3_nt4v100Ev
  virtual void  v101(); // _ZN9S534C3_nt4v101Ev
  virtual void  v102(); // _ZN9S534C3_nt4v102Ev
  virtual void  v103(); // _ZN9S534C3_nt4v103Ev
  virtual void  v104(); // _ZN9S534C3_nt4v104Ev
  virtual void  v105(); // _ZN9S534C3_nt4v105Ev
  virtual void  v106(); // _ZN9S534C3_nt4v106Ev
  virtual void  v107(); // _ZN9S534C3_nt4v107Ev
  virtual void  v108(); // _ZN9S534C3_nt4v108Ev
  S534C3_nt(); // tgen
};
//SIG(-1 S534C3_nt) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC6 FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} Fi[3]}


 S534C3_nt ::~S534C3_nt(){ note_dtor("S534C3_nt", this);}
void  S534C3_nt ::v89(){vfunc_called(this, "_ZN9S534C3_nt3v89Ev");}
void  S534C3_nt ::v90(){vfunc_called(this, "_ZN9S534C3_nt3v90Ev");}
void  S534C3_nt ::v91(){vfunc_called(this, "_ZN9S534C3_nt3v91Ev");}
void  S534C3_nt ::v92(){vfunc_called(this, "_ZN9S534C3_nt3v92Ev");}
void  S534C3_nt ::v93(){vfunc_called(this, "_ZN9S534C3_nt3v93Ev");}
void  S534C3_nt ::v94(){vfunc_called(this, "_ZN9S534C3_nt3v94Ev");}
void  S534C3_nt ::v95(){vfunc_called(this, "_ZN9S534C3_nt3v95Ev");}
void  S534C3_nt ::v96(){vfunc_called(this, "_ZN9S534C3_nt3v96Ev");}
void  S534C3_nt ::v97(){vfunc_called(this, "_ZN9S534C3_nt3v97Ev");}
void  S534C3_nt ::v98(){vfunc_called(this, "_ZN9S534C3_nt3v98Ev");}
void  S534C3_nt ::v99(){vfunc_called(this, "_ZN9S534C3_nt3v99Ev");}
void  S534C3_nt ::v100(){vfunc_called(this, "_ZN9S534C3_nt4v100Ev");}
void  S534C3_nt ::v101(){vfunc_called(this, "_ZN9S534C3_nt4v101Ev");}
void  S534C3_nt ::v102(){vfunc_called(this, "_ZN9S534C3_nt4v102Ev");}
void  S534C3_nt ::v103(){vfunc_called(this, "_ZN9S534C3_nt4v103Ev");}
void  S534C3_nt ::v104(){vfunc_called(this, "_ZN9S534C3_nt4v104Ev");}
void  S534C3_nt ::v105(){vfunc_called(this, "_ZN9S534C3_nt4v105Ev");}
void  S534C3_nt ::v106(){vfunc_called(this, "_ZN9S534C3_nt4v106Ev");}
void  S534C3_nt ::v107(){vfunc_called(this, "_ZN9S534C3_nt4v107Ev");}
void  S534C3_nt ::v108(){vfunc_called(this, "_ZN9S534C3_nt4v108Ev");}
S534C3_nt ::S534C3_nt(){ note_ctor("S534C3_nt", this);} // tgen

//skip512 S534C3_nt

#else // __cplusplus

extern void _ZN9S534C3_ntC1Ev();
extern void _ZN9S534C3_ntD1Ev();
Name_Map name_map_S534C3_nt[] = {
  NSPAIR(_ZN9S534C3_ntC1Ev),
  NSPAIR(_ZN9S534C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S534C5;
extern VTBL_ENTRY _ZTI6S534C5[];
extern  VTBL_ENTRY _ZTV6S534C5[];
extern Class_Descriptor cd_S534C4_nt;
extern VTBL_ENTRY _ZTI9S534C4_nt[];
extern  VTBL_ENTRY _ZTV9S534C4_nt[];
static Base_Class bases_S534C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S534C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S534C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S534C3_nt[];
extern void _ZN9S534C3_ntD1Ev();
extern void _ZN9S534C3_ntD0Ev();
extern void _ZN6S534C52v3Ev();
extern void _ZN6S534C52v4Ev();
extern void _ZN6S534C52v5Ev();
extern void _ZN6S534C52v6Ev();
extern void _ZN6S534C52v7Ev();
extern void _ZN6S534C52v8Ev();
extern void _ZN6S534C52v9Ev();
extern void _ZN6S534C53v10Ev();
extern void _ZN6S534C53v11Ev();
extern void _ZN6S534C53v12Ev();
extern void _ZN6S534C53v13Ev();
extern void _ZN6S534C53v14Ev();
extern void _ZN6S534C53v15Ev();
extern void _ZN6S534C53v16Ev();
extern void _ZN6S534C53v17Ev();
extern void _ZN6S534C53v18Ev();
extern void _ZN6S534C53v19Ev();
extern void _ZN6S534C53v20Ev();
extern void _ZN6S534C53v21Ev();
extern void _ZN6S534C53v22Ev();
extern void _ZN6S534C53v23Ev();
extern void _ZN6S534C53v24Ev();
extern void _ZN6S534C53v25Ev();
extern void _ZN6S534C53v26Ev();
extern void _ZN6S534C53v27Ev();
extern void _ZN6S534C53v28Ev();
extern void _ZN6S534C53v29Ev();
extern void _ZN6S534C53v30Ev();
extern void _ZN6S534C53v31Ev();
extern void _ZN6S534C53v32Ev();
extern void _ZN6S534C53v33Ev();
extern void _ZN6S534C53v34Ev();
extern void _ZN6S534C53v35Ev();
extern void _ZN6S534C53v36Ev();
extern void _ZN6S534C53v37Ev();
extern void _ZN6S534C53v38Ev();
extern void _ZN6S534C53v39Ev();
extern void _ZN6S534C53v40Ev();
extern void _ZN6S534C53v41Ev();
extern void _ZN6S534C53v42Ev();
extern void _ZN6S534C53v43Ev();
extern void _ZN6S534C53v44Ev();
extern void _ZN6S534C53v45Ev();
extern void _ZN6S534C53v46Ev();
extern void _ZN6S534C53v47Ev();
extern void _ZN6S534C53v48Ev();
extern void _ZN6S534C53v49Ev();
extern void _ZN6S534C53v50Ev();
extern void _ZN6S534C53v51Ev();
extern void _ZN6S534C53v52Ev();
extern void _ZN6S534C53v53Ev();
extern void _ZN6S534C53v54Ev();
extern void _ZN6S534C53v55Ev();
extern void _ZN6S534C53v56Ev();
extern void _ZN6S534C53v57Ev();
extern void _ZN6S534C53v58Ev();
extern void _ZN6S534C53v59Ev();
extern void _ZN6S534C53v60Ev();
extern void _ZN6S534C53v61Ev();
extern void _ZN6S534C53v62Ev();
extern void _ZN6S534C53v63Ev();
extern void _ZN6S534C53v64Ev();
extern void _ZN6S534C53v65Ev();
extern void _ZN6S534C53v66Ev();
extern void _ZN9S534C4_nt3v67Ev();
extern void _ZN9S534C4_nt3v68Ev();
extern void _ZN9S534C4_nt3v69Ev();
extern void _ZN9S534C4_nt3v70Ev();
extern void _ZN9S534C4_nt3v71Ev();
extern void _ZN9S534C4_nt3v72Ev();
extern void _ZN9S534C4_nt3v73Ev();
extern void _ZN9S534C4_nt3v74Ev();
extern void _ZN9S534C4_nt3v75Ev();
extern void _ZN9S534C4_nt3v76Ev();
extern void _ZN9S534C4_nt3v77Ev();
extern void _ZN9S534C4_nt3v78Ev();
extern void _ZN9S534C4_nt3v79Ev();
extern void _ZN9S534C4_nt3v80Ev();
extern void _ZN9S534C4_nt3v81Ev();
extern void _ZN9S534C4_nt3v82Ev();
extern void _ZN9S534C4_nt3v83Ev();
extern void _ZN9S534C4_nt3v84Ev();
extern void _ZN9S534C4_nt3v85Ev();
extern void _ZN9S534C4_nt3v86Ev();
extern void _ZN9S534C4_nt3v87Ev();
extern void _ZN9S534C4_nt3v88Ev();
extern void _ZN9S534C3_nt3v89Ev();
extern void _ZN9S534C3_nt3v90Ev();
extern void _ZN9S534C3_nt3v91Ev();
extern void _ZN9S534C3_nt3v92Ev();
extern void _ZN9S534C3_nt3v93Ev();
extern void _ZN9S534C3_nt3v94Ev();
extern void _ZN9S534C3_nt3v95Ev();
extern void _ZN9S534C3_nt3v96Ev();
extern void _ZN9S534C3_nt3v97Ev();
extern void _ZN9S534C3_nt3v98Ev();
extern void _ZN9S534C3_nt3v99Ev();
extern void _ZN9S534C3_nt4v100Ev();
extern void _ZN9S534C3_nt4v101Ev();
extern void _ZN9S534C3_nt4v102Ev();
extern void _ZN9S534C3_nt4v103Ev();
extern void _ZN9S534C3_nt4v104Ev();
extern void _ZN9S534C3_nt4v105Ev();
extern void _ZN9S534C3_nt4v106Ev();
extern void _ZN9S534C3_nt4v107Ev();
extern void _ZN9S534C3_nt4v108Ev();
static  VTBL_ENTRY vtc_S534C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S534C3_nt[0]),
  (VTBL_ENTRY)&_ZN9S534C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S534C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S534C52v3Ev,
  (VTBL_ENTRY)&_ZN6S534C52v4Ev,
  (VTBL_ENTRY)&_ZN6S534C52v5Ev,
  (VTBL_ENTRY)&_ZN6S534C52v6Ev,
  (VTBL_ENTRY)&_ZN6S534C52v7Ev,
  (VTBL_ENTRY)&_ZN6S534C52v8Ev,
  (VTBL_ENTRY)&_ZN6S534C52v9Ev,
  (VTBL_ENTRY)&_ZN6S534C53v10Ev,
  (VTBL_ENTRY)&_ZN6S534C53v11Ev,
  (VTBL_ENTRY)&_ZN6S534C53v12Ev,
  (VTBL_ENTRY)&_ZN6S534C53v13Ev,
  (VTBL_ENTRY)&_ZN6S534C53v14Ev,
  (VTBL_ENTRY)&_ZN6S534C53v15Ev,
  (VTBL_ENTRY)&_ZN6S534C53v16Ev,
  (VTBL_ENTRY)&_ZN6S534C53v17Ev,
  (VTBL_ENTRY)&_ZN6S534C53v18Ev,
  (VTBL_ENTRY)&_ZN6S534C53v19Ev,
  (VTBL_ENTRY)&_ZN6S534C53v20Ev,
  (VTBL_ENTRY)&_ZN6S534C53v21Ev,
  (VTBL_ENTRY)&_ZN6S534C53v22Ev,
  (VTBL_ENTRY)&_ZN6S534C53v23Ev,
  (VTBL_ENTRY)&_ZN6S534C53v24Ev,
  (VTBL_ENTRY)&_ZN6S534C53v25Ev,
  (VTBL_ENTRY)&_ZN6S534C53v26Ev,
  (VTBL_ENTRY)&_ZN6S534C53v27Ev,
  (VTBL_ENTRY)&_ZN6S534C53v28Ev,
  (VTBL_ENTRY)&_ZN6S534C53v29Ev,
  (VTBL_ENTRY)&_ZN6S534C53v30Ev,
  (VTBL_ENTRY)&_ZN6S534C53v31Ev,
  (VTBL_ENTRY)&_ZN6S534C53v32Ev,
  (VTBL_ENTRY)&_ZN6S534C53v33Ev,
  (VTBL_ENTRY)&_ZN6S534C53v34Ev,
  (VTBL_ENTRY)&_ZN6S534C53v35Ev,
  (VTBL_ENTRY)&_ZN6S534C53v36Ev,
  (VTBL_ENTRY)&_ZN6S534C53v37Ev,
  (VTBL_ENTRY)&_ZN6S534C53v38Ev,
  (VTBL_ENTRY)&_ZN6S534C53v39Ev,
  (VTBL_ENTRY)&_ZN6S534C53v40Ev,
  (VTBL_ENTRY)&_ZN6S534C53v41Ev,
  (VTBL_ENTRY)&_ZN6S534C53v42Ev,
  (VTBL_ENTRY)&_ZN6S534C53v43Ev,
  (VTBL_ENTRY)&_ZN6S534C53v44Ev,
  (VTBL_ENTRY)&_ZN6S534C53v45Ev,
  (VTBL_ENTRY)&_ZN6S534C53v46Ev,
  (VTBL_ENTRY)&_ZN6S534C53v47Ev,
  (VTBL_ENTRY)&_ZN6S534C53v48Ev,
  (VTBL_ENTRY)&_ZN6S534C53v49Ev,
  (VTBL_ENTRY)&_ZN6S534C53v50Ev,
  (VTBL_ENTRY)&_ZN6S534C53v51Ev,
  (VTBL_ENTRY)&_ZN6S534C53v52Ev,
  (VTBL_ENTRY)&_ZN6S534C53v53Ev,
  (VTBL_ENTRY)&_ZN6S534C53v54Ev,
  (VTBL_ENTRY)&_ZN6S534C53v55Ev,
  (VTBL_ENTRY)&_ZN6S534C53v56Ev,
  (VTBL_ENTRY)&_ZN6S534C53v57Ev,
  (VTBL_ENTRY)&_ZN6S534C53v58Ev,
  (VTBL_ENTRY)&_ZN6S534C53v59Ev,
  (VTBL_ENTRY)&_ZN6S534C53v60Ev,
  (VTBL_ENTRY)&_ZN6S534C53v61Ev,
  (VTBL_ENTRY)&_ZN6S534C53v62Ev,
  (VTBL_ENTRY)&_ZN6S534C53v63Ev,
  (VTBL_ENTRY)&_ZN6S534C53v64Ev,
  (VTBL_ENTRY)&_ZN6S534C53v65Ev,
  (VTBL_ENTRY)&_ZN6S534C53v66Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt4v108Ev,
};
extern VTBL_ENTRY _ZTI9S534C3_nt[];
VTBL_ENTRY *P__ZTI9S534C3_nt = _ZTI9S534C3_nt; 
extern  VTBL_ENTRY _ZTV9S534C3_nt[];
Class_Descriptor cd_S534C3_nt = {  "S534C3_nt", // class name
  bases_S534C3_nt, 2,
  &(vtc_S534C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI9S534C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S534C3_nt),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S534C2_nt  : S534C3_nt {
  void *s534c2f0[2];
  int s534c2f1[4];
  unsigned int s534c2f2:1;
  unsigned int s534c2f3:1;
  unsigned int s534c2f4:1;
  char s534c2f5;
  int s534c2f6;
  unsigned int s534c2f7:1;
  ::S674C8_nt s534c2f8;
  virtual  ~S534C2_nt(); // _ZN9S534C2_ntD1Ev
  virtual void  v109(); // _ZN9S534C2_nt4v109Ev
  virtual void  v110(); // _ZN9S534C2_nt4v110Ev
  virtual void  v111(); // _ZN9S534C2_nt4v111Ev
  virtual void  v112(); // _ZN9S534C2_nt4v112Ev
  virtual void  v113(); // _ZN9S534C2_nt4v113Ev
  virtual void  v114(); // _ZN9S534C2_nt4v114Ev
  virtual void  v115(); // _ZN9S534C2_nt4v115Ev
  virtual void  v116(); // _ZN9S534C2_nt4v116Ev
  virtual void  v117(); // _ZN9S534C2_nt4v117Ev
  virtual void  v118(); // _ZN9S534C2_nt4v118Ev
  virtual void  v119(); // _ZN9S534C2_nt4v119Ev
  virtual void  v120(); // _ZN9S534C2_nt4v120Ev
  virtual void  v121(); // _ZN9S534C2_nt4v121Ev
  virtual void  v122(); // _ZN9S534C2_nt4v122Ev
  S534C2_nt(); // tgen
};
//SIG(-1 S534C2_nt) C1{ BC2{ BC3{ BC4{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC7 FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} Fi[3]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] Fi[4] Fi:1 Fi:1 Fi:1 Fc Fi Fi:1 FC17{ BC18{ BC9}}}


 S534C2_nt ::~S534C2_nt(){ note_dtor("S534C2_nt", this);}
void  S534C2_nt ::v109(){vfunc_called(this, "_ZN9S534C2_nt4v109Ev");}
void  S534C2_nt ::v110(){vfunc_called(this, "_ZN9S534C2_nt4v110Ev");}
void  S534C2_nt ::v111(){vfunc_called(this, "_ZN9S534C2_nt4v111Ev");}
void  S534C2_nt ::v112(){vfunc_called(this, "_ZN9S534C2_nt4v112Ev");}
void  S534C2_nt ::v113(){vfunc_called(this, "_ZN9S534C2_nt4v113Ev");}
void  S534C2_nt ::v114(){vfunc_called(this, "_ZN9S534C2_nt4v114Ev");}
void  S534C2_nt ::v115(){vfunc_called(this, "_ZN9S534C2_nt4v115Ev");}
void  S534C2_nt ::v116(){vfunc_called(this, "_ZN9S534C2_nt4v116Ev");}
void  S534C2_nt ::v117(){vfunc_called(this, "_ZN9S534C2_nt4v117Ev");}
void  S534C2_nt ::v118(){vfunc_called(this, "_ZN9S534C2_nt4v118Ev");}
void  S534C2_nt ::v119(){vfunc_called(this, "_ZN9S534C2_nt4v119Ev");}
void  S534C2_nt ::v120(){vfunc_called(this, "_ZN9S534C2_nt4v120Ev");}
void  S534C2_nt ::v121(){vfunc_called(this, "_ZN9S534C2_nt4v121Ev");}
void  S534C2_nt ::v122(){vfunc_called(this, "_ZN9S534C2_nt4v122Ev");}
S534C2_nt ::S534C2_nt(){ note_ctor("S534C2_nt", this);} // tgen

//skip512 S534C2_nt

#else // __cplusplus

extern void _ZN9S534C2_ntC1Ev();
extern void _ZN9S534C2_ntD1Ev();
Name_Map name_map_S534C2_nt[] = {
  NSPAIR(_ZN9S534C2_ntC1Ev),
  NSPAIR(_ZN9S534C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S534C5;
extern VTBL_ENTRY _ZTI6S534C5[];
extern  VTBL_ENTRY _ZTV6S534C5[];
extern Class_Descriptor cd_S534C4_nt;
extern VTBL_ENTRY _ZTI9S534C4_nt[];
extern  VTBL_ENTRY _ZTV9S534C4_nt[];
extern Class_Descriptor cd_S534C3_nt;
extern VTBL_ENTRY _ZTI9S534C3_nt[];
extern  VTBL_ENTRY _ZTV9S534C3_nt[];
static Base_Class bases_S534C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S534C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S534C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S534C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S534C2_nt[];
extern void _ZN9S534C2_ntD1Ev();
extern void _ZN9S534C2_ntD0Ev();
extern void _ZN6S534C52v3Ev();
extern void _ZN6S534C52v4Ev();
extern void _ZN6S534C52v5Ev();
extern void _ZN6S534C52v6Ev();
extern void _ZN6S534C52v7Ev();
extern void _ZN6S534C52v8Ev();
extern void _ZN6S534C52v9Ev();
extern void _ZN6S534C53v10Ev();
extern void _ZN6S534C53v11Ev();
extern void _ZN6S534C53v12Ev();
extern void _ZN6S534C53v13Ev();
extern void _ZN6S534C53v14Ev();
extern void _ZN6S534C53v15Ev();
extern void _ZN6S534C53v16Ev();
extern void _ZN6S534C53v17Ev();
extern void _ZN6S534C53v18Ev();
extern void _ZN6S534C53v19Ev();
extern void _ZN6S534C53v20Ev();
extern void _ZN6S534C53v21Ev();
extern void _ZN6S534C53v22Ev();
extern void _ZN6S534C53v23Ev();
extern void _ZN6S534C53v24Ev();
extern void _ZN6S534C53v25Ev();
extern void _ZN6S534C53v26Ev();
extern void _ZN6S534C53v27Ev();
extern void _ZN6S534C53v28Ev();
extern void _ZN6S534C53v29Ev();
extern void _ZN6S534C53v30Ev();
extern void _ZN6S534C53v31Ev();
extern void _ZN6S534C53v32Ev();
extern void _ZN6S534C53v33Ev();
extern void _ZN6S534C53v34Ev();
extern void _ZN6S534C53v35Ev();
extern void _ZN6S534C53v36Ev();
extern void _ZN6S534C53v37Ev();
extern void _ZN6S534C53v38Ev();
extern void _ZN6S534C53v39Ev();
extern void _ZN6S534C53v40Ev();
extern void _ZN6S534C53v41Ev();
extern void _ZN6S534C53v42Ev();
extern void _ZN6S534C53v43Ev();
extern void _ZN6S534C53v44Ev();
extern void _ZN6S534C53v45Ev();
extern void _ZN6S534C53v46Ev();
extern void _ZN6S534C53v47Ev();
extern void _ZN6S534C53v48Ev();
extern void _ZN6S534C53v49Ev();
extern void _ZN6S534C53v50Ev();
extern void _ZN6S534C53v51Ev();
extern void _ZN6S534C53v52Ev();
extern void _ZN6S534C53v53Ev();
extern void _ZN6S534C53v54Ev();
extern void _ZN6S534C53v55Ev();
extern void _ZN6S534C53v56Ev();
extern void _ZN6S534C53v57Ev();
extern void _ZN6S534C53v58Ev();
extern void _ZN6S534C53v59Ev();
extern void _ZN6S534C53v60Ev();
extern void _ZN6S534C53v61Ev();
extern void _ZN6S534C53v62Ev();
extern void _ZN6S534C53v63Ev();
extern void _ZN6S534C53v64Ev();
extern void _ZN6S534C53v65Ev();
extern void _ZN6S534C53v66Ev();
extern void _ZN9S534C4_nt3v67Ev();
extern void _ZN9S534C4_nt3v68Ev();
extern void _ZN9S534C4_nt3v69Ev();
extern void _ZN9S534C4_nt3v70Ev();
extern void _ZN9S534C4_nt3v71Ev();
extern void _ZN9S534C4_nt3v72Ev();
extern void _ZN9S534C4_nt3v73Ev();
extern void _ZN9S534C4_nt3v74Ev();
extern void _ZN9S534C4_nt3v75Ev();
extern void _ZN9S534C4_nt3v76Ev();
extern void _ZN9S534C4_nt3v77Ev();
extern void _ZN9S534C4_nt3v78Ev();
extern void _ZN9S534C4_nt3v79Ev();
extern void _ZN9S534C4_nt3v80Ev();
extern void _ZN9S534C4_nt3v81Ev();
extern void _ZN9S534C4_nt3v82Ev();
extern void _ZN9S534C4_nt3v83Ev();
extern void _ZN9S534C4_nt3v84Ev();
extern void _ZN9S534C4_nt3v85Ev();
extern void _ZN9S534C4_nt3v86Ev();
extern void _ZN9S534C4_nt3v87Ev();
extern void _ZN9S534C4_nt3v88Ev();
extern void _ZN9S534C3_nt3v89Ev();
extern void _ZN9S534C3_nt3v90Ev();
extern void _ZN9S534C3_nt3v91Ev();
extern void _ZN9S534C3_nt3v92Ev();
extern void _ZN9S534C3_nt3v93Ev();
extern void _ZN9S534C3_nt3v94Ev();
extern void _ZN9S534C3_nt3v95Ev();
extern void _ZN9S534C3_nt3v96Ev();
extern void _ZN9S534C3_nt3v97Ev();
extern void _ZN9S534C3_nt3v98Ev();
extern void _ZN9S534C3_nt3v99Ev();
extern void _ZN9S534C3_nt4v100Ev();
extern void _ZN9S534C3_nt4v101Ev();
extern void _ZN9S534C3_nt4v102Ev();
extern void _ZN9S534C3_nt4v103Ev();
extern void _ZN9S534C3_nt4v104Ev();
extern void _ZN9S534C3_nt4v105Ev();
extern void _ZN9S534C3_nt4v106Ev();
extern void _ZN9S534C3_nt4v107Ev();
extern void _ZN9S534C3_nt4v108Ev();
extern void _ZN9S534C2_nt4v109Ev();
extern void _ZN9S534C2_nt4v110Ev();
extern void _ZN9S534C2_nt4v111Ev();
extern void _ZN9S534C2_nt4v112Ev();
extern void _ZN9S534C2_nt4v113Ev();
extern void _ZN9S534C2_nt4v114Ev();
extern void _ZN9S534C2_nt4v115Ev();
extern void _ZN9S534C2_nt4v116Ev();
extern void _ZN9S534C2_nt4v117Ev();
extern void _ZN9S534C2_nt4v118Ev();
extern void _ZN9S534C2_nt4v119Ev();
extern void _ZN9S534C2_nt4v120Ev();
extern void _ZN9S534C2_nt4v121Ev();
extern void _ZN9S534C2_nt4v122Ev();
static  VTBL_ENTRY vtc_S534C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S534C2_nt[0]),
  (VTBL_ENTRY)&_ZN9S534C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S534C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S534C52v3Ev,
  (VTBL_ENTRY)&_ZN6S534C52v4Ev,
  (VTBL_ENTRY)&_ZN6S534C52v5Ev,
  (VTBL_ENTRY)&_ZN6S534C52v6Ev,
  (VTBL_ENTRY)&_ZN6S534C52v7Ev,
  (VTBL_ENTRY)&_ZN6S534C52v8Ev,
  (VTBL_ENTRY)&_ZN6S534C52v9Ev,
  (VTBL_ENTRY)&_ZN6S534C53v10Ev,
  (VTBL_ENTRY)&_ZN6S534C53v11Ev,
  (VTBL_ENTRY)&_ZN6S534C53v12Ev,
  (VTBL_ENTRY)&_ZN6S534C53v13Ev,
  (VTBL_ENTRY)&_ZN6S534C53v14Ev,
  (VTBL_ENTRY)&_ZN6S534C53v15Ev,
  (VTBL_ENTRY)&_ZN6S534C53v16Ev,
  (VTBL_ENTRY)&_ZN6S534C53v17Ev,
  (VTBL_ENTRY)&_ZN6S534C53v18Ev,
  (VTBL_ENTRY)&_ZN6S534C53v19Ev,
  (VTBL_ENTRY)&_ZN6S534C53v20Ev,
  (VTBL_ENTRY)&_ZN6S534C53v21Ev,
  (VTBL_ENTRY)&_ZN6S534C53v22Ev,
  (VTBL_ENTRY)&_ZN6S534C53v23Ev,
  (VTBL_ENTRY)&_ZN6S534C53v24Ev,
  (VTBL_ENTRY)&_ZN6S534C53v25Ev,
  (VTBL_ENTRY)&_ZN6S534C53v26Ev,
  (VTBL_ENTRY)&_ZN6S534C53v27Ev,
  (VTBL_ENTRY)&_ZN6S534C53v28Ev,
  (VTBL_ENTRY)&_ZN6S534C53v29Ev,
  (VTBL_ENTRY)&_ZN6S534C53v30Ev,
  (VTBL_ENTRY)&_ZN6S534C53v31Ev,
  (VTBL_ENTRY)&_ZN6S534C53v32Ev,
  (VTBL_ENTRY)&_ZN6S534C53v33Ev,
  (VTBL_ENTRY)&_ZN6S534C53v34Ev,
  (VTBL_ENTRY)&_ZN6S534C53v35Ev,
  (VTBL_ENTRY)&_ZN6S534C53v36Ev,
  (VTBL_ENTRY)&_ZN6S534C53v37Ev,
  (VTBL_ENTRY)&_ZN6S534C53v38Ev,
  (VTBL_ENTRY)&_ZN6S534C53v39Ev,
  (VTBL_ENTRY)&_ZN6S534C53v40Ev,
  (VTBL_ENTRY)&_ZN6S534C53v41Ev,
  (VTBL_ENTRY)&_ZN6S534C53v42Ev,
  (VTBL_ENTRY)&_ZN6S534C53v43Ev,
  (VTBL_ENTRY)&_ZN6S534C53v44Ev,
  (VTBL_ENTRY)&_ZN6S534C53v45Ev,
  (VTBL_ENTRY)&_ZN6S534C53v46Ev,
  (VTBL_ENTRY)&_ZN6S534C53v47Ev,
  (VTBL_ENTRY)&_ZN6S534C53v48Ev,
  (VTBL_ENTRY)&_ZN6S534C53v49Ev,
  (VTBL_ENTRY)&_ZN6S534C53v50Ev,
  (VTBL_ENTRY)&_ZN6S534C53v51Ev,
  (VTBL_ENTRY)&_ZN6S534C53v52Ev,
  (VTBL_ENTRY)&_ZN6S534C53v53Ev,
  (VTBL_ENTRY)&_ZN6S534C53v54Ev,
  (VTBL_ENTRY)&_ZN6S534C53v55Ev,
  (VTBL_ENTRY)&_ZN6S534C53v56Ev,
  (VTBL_ENTRY)&_ZN6S534C53v57Ev,
  (VTBL_ENTRY)&_ZN6S534C53v58Ev,
  (VTBL_ENTRY)&_ZN6S534C53v59Ev,
  (VTBL_ENTRY)&_ZN6S534C53v60Ev,
  (VTBL_ENTRY)&_ZN6S534C53v61Ev,
  (VTBL_ENTRY)&_ZN6S534C53v62Ev,
  (VTBL_ENTRY)&_ZN6S534C53v63Ev,
  (VTBL_ENTRY)&_ZN6S534C53v64Ev,
  (VTBL_ENTRY)&_ZN6S534C53v65Ev,
  (VTBL_ENTRY)&_ZN6S534C53v66Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S534C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S534C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S534C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S534C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S534C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S534C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S534C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S534C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S534C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S534C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S534C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S534C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S534C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S534C2_nt4v122Ev,
};
extern VTBL_ENTRY _ZTI9S534C2_nt[];
VTBL_ENTRY *P__ZTI9S534C2_nt = _ZTI9S534C2_nt; 
extern  VTBL_ENTRY _ZTV9S534C2_nt[];
Class_Descriptor cd_S534C2_nt = {  "S534C2_nt", // class name
  bases_S534C2_nt, 3,
  &(vtc_S534C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(336,244), // object size
  NSPAIRA(_ZTI9S534C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S534C2_nt),124, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S534C1  : S534C2_nt {
  int s534c1f0;
  virtual  ~S534C1(); // _ZN6S534C1D1Ev
  virtual void  v1(); // _ZN6S534C12v1Ev
  virtual void  v2(); // _ZN6S534C12v2Ev
  S534C1(); // tgen
};
//SIG(1 S534C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC8 FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} Fi[3]} vd v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 Fp[2] Fi[4] Fi:1 Fi:1 Fi:1 Fc Fi Fi:1 FC18{ BC19{ BC10}}} vd v1 v2 Fi}


 S534C1 ::~S534C1(){ note_dtor("S534C1", this);}
void  S534C1 ::v1(){vfunc_called(this, "_ZN6S534C12v1Ev");}
void  S534C1 ::v2(){vfunc_called(this, "_ZN6S534C12v2Ev");}
S534C1 ::S534C1(){ note_ctor("S534C1", this);} // tgen

static void Test_S534C1()
{
  extern Class_Descriptor cd_S534C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(44,63)];
    init_test(&cd_S534C1, buf);
    S534C1 *dp, &lv = *(dp=new (buf) S534C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(344,248), "sizeof(S534C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S534C1)");
    check_base_class_offset(lv, (S534C5*)(S534C4_nt*)(S534C3_nt*)(S534C2_nt*), 0, "S534C1");
    check_base_class_offset(lv, (S534C4_nt*)(S534C3_nt*)(S534C2_nt*), 0, "S534C1");
    check_base_class_offset(lv, (S534C3_nt*)(S534C2_nt*), 0, "S534C1");
    check_base_class_offset(lv, (S534C2_nt*), 0, "S534C1");
    check_field_offset(lv, s534c1f0, ABISELECT(336,244), "S534C1.s534c1f0");
    test_class_info(&lv, &cd_S534C1);
    dp->~S534C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS534C1(Test_S534C1, "S534C1", ABISELECT(344,248));

#else // __cplusplus

extern void _ZN6S534C1C1Ev();
extern void _ZN6S534C1D1Ev();
Name_Map name_map_S534C1[] = {
  NSPAIR(_ZN6S534C1C1Ev),
  NSPAIR(_ZN6S534C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S534C5;
extern VTBL_ENTRY _ZTI6S534C5[];
extern  VTBL_ENTRY _ZTV6S534C5[];
extern Class_Descriptor cd_S534C4_nt;
extern VTBL_ENTRY _ZTI9S534C4_nt[];
extern  VTBL_ENTRY _ZTV9S534C4_nt[];
extern Class_Descriptor cd_S534C3_nt;
extern VTBL_ENTRY _ZTI9S534C3_nt[];
extern  VTBL_ENTRY _ZTV9S534C3_nt[];
extern Class_Descriptor cd_S534C2_nt;
extern VTBL_ENTRY _ZTI9S534C2_nt[];
extern  VTBL_ENTRY _ZTV9S534C2_nt[];
static Base_Class bases_S534C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S534C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S534C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S534C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S534C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S534C1[];
extern void _ZN6S534C1D1Ev();
extern void _ZN6S534C1D0Ev();
extern void _ZN6S534C52v3Ev();
extern void _ZN6S534C52v4Ev();
extern void _ZN6S534C52v5Ev();
extern void _ZN6S534C52v6Ev();
extern void _ZN6S534C52v7Ev();
extern void _ZN6S534C52v8Ev();
extern void _ZN6S534C52v9Ev();
extern void _ZN6S534C53v10Ev();
extern void _ZN6S534C53v11Ev();
extern void _ZN6S534C53v12Ev();
extern void _ZN6S534C53v13Ev();
extern void _ZN6S534C53v14Ev();
extern void _ZN6S534C53v15Ev();
extern void _ZN6S534C53v16Ev();
extern void _ZN6S534C53v17Ev();
extern void _ZN6S534C53v18Ev();
extern void _ZN6S534C53v19Ev();
extern void _ZN6S534C53v20Ev();
extern void _ZN6S534C53v21Ev();
extern void _ZN6S534C53v22Ev();
extern void _ZN6S534C53v23Ev();
extern void _ZN6S534C53v24Ev();
extern void _ZN6S534C53v25Ev();
extern void _ZN6S534C53v26Ev();
extern void _ZN6S534C53v27Ev();
extern void _ZN6S534C53v28Ev();
extern void _ZN6S534C53v29Ev();
extern void _ZN6S534C53v30Ev();
extern void _ZN6S534C53v31Ev();
extern void _ZN6S534C53v32Ev();
extern void _ZN6S534C53v33Ev();
extern void _ZN6S534C53v34Ev();
extern void _ZN6S534C53v35Ev();
extern void _ZN6S534C53v36Ev();
extern void _ZN6S534C53v37Ev();
extern void _ZN6S534C53v38Ev();
extern void _ZN6S534C53v39Ev();
extern void _ZN6S534C53v40Ev();
extern void _ZN6S534C53v41Ev();
extern void _ZN6S534C53v42Ev();
extern void _ZN6S534C53v43Ev();
extern void _ZN6S534C53v44Ev();
extern void _ZN6S534C53v45Ev();
extern void _ZN6S534C53v46Ev();
extern void _ZN6S534C53v47Ev();
extern void _ZN6S534C53v48Ev();
extern void _ZN6S534C53v49Ev();
extern void _ZN6S534C53v50Ev();
extern void _ZN6S534C53v51Ev();
extern void _ZN6S534C53v52Ev();
extern void _ZN6S534C53v53Ev();
extern void _ZN6S534C53v54Ev();
extern void _ZN6S534C53v55Ev();
extern void _ZN6S534C53v56Ev();
extern void _ZN6S534C53v57Ev();
extern void _ZN6S534C53v58Ev();
extern void _ZN6S534C53v59Ev();
extern void _ZN6S534C53v60Ev();
extern void _ZN6S534C53v61Ev();
extern void _ZN6S534C53v62Ev();
extern void _ZN6S534C53v63Ev();
extern void _ZN6S534C53v64Ev();
extern void _ZN6S534C53v65Ev();
extern void _ZN6S534C53v66Ev();
extern void _ZN9S534C4_nt3v67Ev();
extern void _ZN9S534C4_nt3v68Ev();
extern void _ZN9S534C4_nt3v69Ev();
extern void _ZN9S534C4_nt3v70Ev();
extern void _ZN9S534C4_nt3v71Ev();
extern void _ZN9S534C4_nt3v72Ev();
extern void _ZN9S534C4_nt3v73Ev();
extern void _ZN9S534C4_nt3v74Ev();
extern void _ZN9S534C4_nt3v75Ev();
extern void _ZN9S534C4_nt3v76Ev();
extern void _ZN9S534C4_nt3v77Ev();
extern void _ZN9S534C4_nt3v78Ev();
extern void _ZN9S534C4_nt3v79Ev();
extern void _ZN9S534C4_nt3v80Ev();
extern void _ZN9S534C4_nt3v81Ev();
extern void _ZN9S534C4_nt3v82Ev();
extern void _ZN9S534C4_nt3v83Ev();
extern void _ZN9S534C4_nt3v84Ev();
extern void _ZN9S534C4_nt3v85Ev();
extern void _ZN9S534C4_nt3v86Ev();
extern void _ZN9S534C4_nt3v87Ev();
extern void _ZN9S534C4_nt3v88Ev();
extern void _ZN9S534C3_nt3v89Ev();
extern void _ZN9S534C3_nt3v90Ev();
extern void _ZN9S534C3_nt3v91Ev();
extern void _ZN9S534C3_nt3v92Ev();
extern void _ZN9S534C3_nt3v93Ev();
extern void _ZN9S534C3_nt3v94Ev();
extern void _ZN9S534C3_nt3v95Ev();
extern void _ZN9S534C3_nt3v96Ev();
extern void _ZN9S534C3_nt3v97Ev();
extern void _ZN9S534C3_nt3v98Ev();
extern void _ZN9S534C3_nt3v99Ev();
extern void _ZN9S534C3_nt4v100Ev();
extern void _ZN9S534C3_nt4v101Ev();
extern void _ZN9S534C3_nt4v102Ev();
extern void _ZN9S534C3_nt4v103Ev();
extern void _ZN9S534C3_nt4v104Ev();
extern void _ZN9S534C3_nt4v105Ev();
extern void _ZN9S534C3_nt4v106Ev();
extern void _ZN9S534C3_nt4v107Ev();
extern void _ZN9S534C3_nt4v108Ev();
extern void _ZN9S534C2_nt4v109Ev();
extern void _ZN9S534C2_nt4v110Ev();
extern void _ZN9S534C2_nt4v111Ev();
extern void _ZN9S534C2_nt4v112Ev();
extern void _ZN9S534C2_nt4v113Ev();
extern void _ZN9S534C2_nt4v114Ev();
extern void _ZN9S534C2_nt4v115Ev();
extern void _ZN9S534C2_nt4v116Ev();
extern void _ZN9S534C2_nt4v117Ev();
extern void _ZN9S534C2_nt4v118Ev();
extern void _ZN9S534C2_nt4v119Ev();
extern void _ZN9S534C2_nt4v120Ev();
extern void _ZN9S534C2_nt4v121Ev();
extern void _ZN9S534C2_nt4v122Ev();
extern void _ZN6S534C12v1Ev();
extern void _ZN6S534C12v2Ev();
static  VTBL_ENTRY vtc_S534C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S534C1[0]),
  (VTBL_ENTRY)&_ZN6S534C1D1Ev,
  (VTBL_ENTRY)&_ZN6S534C1D0Ev,
  (VTBL_ENTRY)&_ZN6S534C52v3Ev,
  (VTBL_ENTRY)&_ZN6S534C52v4Ev,
  (VTBL_ENTRY)&_ZN6S534C52v5Ev,
  (VTBL_ENTRY)&_ZN6S534C52v6Ev,
  (VTBL_ENTRY)&_ZN6S534C52v7Ev,
  (VTBL_ENTRY)&_ZN6S534C52v8Ev,
  (VTBL_ENTRY)&_ZN6S534C52v9Ev,
  (VTBL_ENTRY)&_ZN6S534C53v10Ev,
  (VTBL_ENTRY)&_ZN6S534C53v11Ev,
  (VTBL_ENTRY)&_ZN6S534C53v12Ev,
  (VTBL_ENTRY)&_ZN6S534C53v13Ev,
  (VTBL_ENTRY)&_ZN6S534C53v14Ev,
  (VTBL_ENTRY)&_ZN6S534C53v15Ev,
  (VTBL_ENTRY)&_ZN6S534C53v16Ev,
  (VTBL_ENTRY)&_ZN6S534C53v17Ev,
  (VTBL_ENTRY)&_ZN6S534C53v18Ev,
  (VTBL_ENTRY)&_ZN6S534C53v19Ev,
  (VTBL_ENTRY)&_ZN6S534C53v20Ev,
  (VTBL_ENTRY)&_ZN6S534C53v21Ev,
  (VTBL_ENTRY)&_ZN6S534C53v22Ev,
  (VTBL_ENTRY)&_ZN6S534C53v23Ev,
  (VTBL_ENTRY)&_ZN6S534C53v24Ev,
  (VTBL_ENTRY)&_ZN6S534C53v25Ev,
  (VTBL_ENTRY)&_ZN6S534C53v26Ev,
  (VTBL_ENTRY)&_ZN6S534C53v27Ev,
  (VTBL_ENTRY)&_ZN6S534C53v28Ev,
  (VTBL_ENTRY)&_ZN6S534C53v29Ev,
  (VTBL_ENTRY)&_ZN6S534C53v30Ev,
  (VTBL_ENTRY)&_ZN6S534C53v31Ev,
  (VTBL_ENTRY)&_ZN6S534C53v32Ev,
  (VTBL_ENTRY)&_ZN6S534C53v33Ev,
  (VTBL_ENTRY)&_ZN6S534C53v34Ev,
  (VTBL_ENTRY)&_ZN6S534C53v35Ev,
  (VTBL_ENTRY)&_ZN6S534C53v36Ev,
  (VTBL_ENTRY)&_ZN6S534C53v37Ev,
  (VTBL_ENTRY)&_ZN6S534C53v38Ev,
  (VTBL_ENTRY)&_ZN6S534C53v39Ev,
  (VTBL_ENTRY)&_ZN6S534C53v40Ev,
  (VTBL_ENTRY)&_ZN6S534C53v41Ev,
  (VTBL_ENTRY)&_ZN6S534C53v42Ev,
  (VTBL_ENTRY)&_ZN6S534C53v43Ev,
  (VTBL_ENTRY)&_ZN6S534C53v44Ev,
  (VTBL_ENTRY)&_ZN6S534C53v45Ev,
  (VTBL_ENTRY)&_ZN6S534C53v46Ev,
  (VTBL_ENTRY)&_ZN6S534C53v47Ev,
  (VTBL_ENTRY)&_ZN6S534C53v48Ev,
  (VTBL_ENTRY)&_ZN6S534C53v49Ev,
  (VTBL_ENTRY)&_ZN6S534C53v50Ev,
  (VTBL_ENTRY)&_ZN6S534C53v51Ev,
  (VTBL_ENTRY)&_ZN6S534C53v52Ev,
  (VTBL_ENTRY)&_ZN6S534C53v53Ev,
  (VTBL_ENTRY)&_ZN6S534C53v54Ev,
  (VTBL_ENTRY)&_ZN6S534C53v55Ev,
  (VTBL_ENTRY)&_ZN6S534C53v56Ev,
  (VTBL_ENTRY)&_ZN6S534C53v57Ev,
  (VTBL_ENTRY)&_ZN6S534C53v58Ev,
  (VTBL_ENTRY)&_ZN6S534C53v59Ev,
  (VTBL_ENTRY)&_ZN6S534C53v60Ev,
  (VTBL_ENTRY)&_ZN6S534C53v61Ev,
  (VTBL_ENTRY)&_ZN6S534C53v62Ev,
  (VTBL_ENTRY)&_ZN6S534C53v63Ev,
  (VTBL_ENTRY)&_ZN6S534C53v64Ev,
  (VTBL_ENTRY)&_ZN6S534C53v65Ev,
  (VTBL_ENTRY)&_ZN6S534C53v66Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S534C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S534C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S534C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S534C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S534C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S534C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S534C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S534C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S534C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S534C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S534C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S534C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S534C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S534C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S534C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S534C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN6S534C12v1Ev,
  (VTBL_ENTRY)&_ZN6S534C12v2Ev,
};
extern VTBL_ENTRY _ZTI6S534C1[];
extern  VTBL_ENTRY _ZTV6S534C1[];
Class_Descriptor cd_S534C1 = {  "S534C1", // class name
  bases_S534C1, 4,
  &(vtc_S534C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(344,248), // object size
  NSPAIRA(_ZTI6S534C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S534C1),126, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S573C5  {
  int s573c5f0;
  __tsi64 s573c5f1;
  void *s573c5f2[4];
  int s573c5f3[2];
  void *s573c5f4;
  ::S674C6_nt s573c5f5;
  void *s573c5f6[2];
  virtual  ~S573C5(); // _ZN6S573C5D1Ev
  virtual void  v4(); // _ZN6S573C52v4Ev
  virtual void  v5(); // _ZN6S573C52v5Ev
  virtual void  v6(); // _ZN6S573C52v6Ev
  virtual void  v7(); // _ZN6S573C52v7Ev
  virtual void  v8(); // _ZN6S573C52v8Ev
  virtual void  v9(); // _ZN6S573C52v9Ev
  virtual void  v10(); // _ZN6S573C53v10Ev
  virtual void  v11(); // _ZN6S573C53v11Ev
  virtual void  v12(); // _ZN6S573C53v12Ev
  virtual void  v13(); // _ZN6S573C53v13Ev
  virtual void  v14(); // _ZN6S573C53v14Ev
  virtual void  v15(); // _ZN6S573C53v15Ev
  virtual void  v16(); // _ZN6S573C53v16Ev
  virtual void  v17(); // _ZN6S573C53v17Ev
  virtual void  v18(); // _ZN6S573C53v18Ev
  virtual void  v19(); // _ZN6S573C53v19Ev
  virtual void  v20(); // _ZN6S573C53v20Ev
  virtual void  v21(); // _ZN6S573C53v21Ev
  virtual void  v22(); // _ZN6S573C53v22Ev
  virtual void  v23(); // _ZN6S573C53v23Ev
  virtual void  v24(); // _ZN6S573C53v24Ev
  virtual void  v25(); // _ZN6S573C53v25Ev
  virtual void  v26(); // _ZN6S573C53v26Ev
  virtual void  v27(); // _ZN6S573C53v27Ev
  virtual void  v28(); // _ZN6S573C53v28Ev
  virtual void  v29(); // _ZN6S573C53v29Ev
  virtual void  v30(); // _ZN6S573C53v30Ev
  virtual void  v31(); // _ZN6S573C53v31Ev
  virtual void  v32(); // _ZN6S573C53v32Ev
  virtual void  v33(); // _ZN6S573C53v33Ev
  virtual void  v34(); // _ZN6S573C53v34Ev
  virtual void  v35(); // _ZN6S573C53v35Ev
  virtual void  v36(); // _ZN6S573C53v36Ev
  virtual void  v37(); // _ZN6S573C53v37Ev
  virtual void  v38(); // _ZN6S573C53v38Ev
  virtual void  v39(); // _ZN6S573C53v39Ev
  virtual void  v40(); // _ZN6S573C53v40Ev
  virtual void  v41(); // _ZN6S573C53v41Ev
  virtual void  v42(); // _ZN6S573C53v42Ev
  virtual void  v43(); // _ZN6S573C53v43Ev
  virtual void  v44(); // _ZN6S573C53v44Ev
  virtual void  v45(); // _ZN6S573C53v45Ev
  virtual void  v46(); // _ZN6S573C53v46Ev
  virtual void  v47(); // _ZN6S573C53v47Ev
  virtual void  v48(); // _ZN6S573C53v48Ev
  virtual void  v49(); // _ZN6S573C53v49Ev
  virtual void  v50(); // _ZN6S573C53v50Ev
  virtual void  v51(); // _ZN6S573C53v51Ev
  virtual void  v52(); // _ZN6S573C53v52Ev
  virtual void  v53(); // _ZN6S573C53v53Ev
  virtual void  v54(); // _ZN6S573C53v54Ev
  virtual void  v55(); // _ZN6S573C53v55Ev
  virtual void  v56(); // _ZN6S573C53v56Ev
  virtual void  v57(); // _ZN6S573C53v57Ev
  virtual void  v58(); // _ZN6S573C53v58Ev
  virtual void  v59(); // _ZN6S573C53v59Ev
  virtual void  v60(); // _ZN6S573C53v60Ev
  virtual void  v61(); // _ZN6S573C53v61Ev
  virtual void  v62(); // _ZN6S573C53v62Ev
  virtual void  v63(); // _ZN6S573C53v63Ev
  virtual void  v64(); // _ZN6S573C53v64Ev
  virtual void  v65(); // _ZN6S573C53v65Ev
  virtual void  v66(); // _ZN6S573C53v66Ev
  virtual void  v67(); // _ZN6S573C53v67Ev
  S573C5(); // tgen
};
//SIG(-1 S573C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S573C5 ::~S573C5(){ note_dtor("S573C5", this);}
void  S573C5 ::v4(){vfunc_called(this, "_ZN6S573C52v4Ev");}
void  S573C5 ::v5(){vfunc_called(this, "_ZN6S573C52v5Ev");}
void  S573C5 ::v6(){vfunc_called(this, "_ZN6S573C52v6Ev");}
void  S573C5 ::v7(){vfunc_called(this, "_ZN6S573C52v7Ev");}
void  S573C5 ::v8(){vfunc_called(this, "_ZN6S573C52v8Ev");}
void  S573C5 ::v9(){vfunc_called(this, "_ZN6S573C52v9Ev");}
void  S573C5 ::v10(){vfunc_called(this, "_ZN6S573C53v10Ev");}
void  S573C5 ::v11(){vfunc_called(this, "_ZN6S573C53v11Ev");}
void  S573C5 ::v12(){vfunc_called(this, "_ZN6S573C53v12Ev");}
void  S573C5 ::v13(){vfunc_called(this, "_ZN6S573C53v13Ev");}
void  S573C5 ::v14(){vfunc_called(this, "_ZN6S573C53v14Ev");}
void  S573C5 ::v15(){vfunc_called(this, "_ZN6S573C53v15Ev");}
void  S573C5 ::v16(){vfunc_called(this, "_ZN6S573C53v16Ev");}
void  S573C5 ::v17(){vfunc_called(this, "_ZN6S573C53v17Ev");}
void  S573C5 ::v18(){vfunc_called(this, "_ZN6S573C53v18Ev");}
void  S573C5 ::v19(){vfunc_called(this, "_ZN6S573C53v19Ev");}
void  S573C5 ::v20(){vfunc_called(this, "_ZN6S573C53v20Ev");}
void  S573C5 ::v21(){vfunc_called(this, "_ZN6S573C53v21Ev");}
void  S573C5 ::v22(){vfunc_called(this, "_ZN6S573C53v22Ev");}
void  S573C5 ::v23(){vfunc_called(this, "_ZN6S573C53v23Ev");}
void  S573C5 ::v24(){vfunc_called(this, "_ZN6S573C53v24Ev");}
void  S573C5 ::v25(){vfunc_called(this, "_ZN6S573C53v25Ev");}
void  S573C5 ::v26(){vfunc_called(this, "_ZN6S573C53v26Ev");}
void  S573C5 ::v27(){vfunc_called(this, "_ZN6S573C53v27Ev");}
void  S573C5 ::v28(){vfunc_called(this, "_ZN6S573C53v28Ev");}
void  S573C5 ::v29(){vfunc_called(this, "_ZN6S573C53v29Ev");}
void  S573C5 ::v30(){vfunc_called(this, "_ZN6S573C53v30Ev");}
void  S573C5 ::v31(){vfunc_called(this, "_ZN6S573C53v31Ev");}
void  S573C5 ::v32(){vfunc_called(this, "_ZN6S573C53v32Ev");}
void  S573C5 ::v33(){vfunc_called(this, "_ZN6S573C53v33Ev");}
void  S573C5 ::v34(){vfunc_called(this, "_ZN6S573C53v34Ev");}
void  S573C5 ::v35(){vfunc_called(this, "_ZN6S573C53v35Ev");}
void  S573C5 ::v36(){vfunc_called(this, "_ZN6S573C53v36Ev");}
void  S573C5 ::v37(){vfunc_called(this, "_ZN6S573C53v37Ev");}
void  S573C5 ::v38(){vfunc_called(this, "_ZN6S573C53v38Ev");}
void  S573C5 ::v39(){vfunc_called(this, "_ZN6S573C53v39Ev");}
void  S573C5 ::v40(){vfunc_called(this, "_ZN6S573C53v40Ev");}
void  S573C5 ::v41(){vfunc_called(this, "_ZN6S573C53v41Ev");}
void  S573C5 ::v42(){vfunc_called(this, "_ZN6S573C53v42Ev");}
void  S573C5 ::v43(){vfunc_called(this, "_ZN6S573C53v43Ev");}
void  S573C5 ::v44(){vfunc_called(this, "_ZN6S573C53v44Ev");}
void  S573C5 ::v45(){vfunc_called(this, "_ZN6S573C53v45Ev");}
void  S573C5 ::v46(){vfunc_called(this, "_ZN6S573C53v46Ev");}
void  S573C5 ::v47(){vfunc_called(this, "_ZN6S573C53v47Ev");}
void  S573C5 ::v48(){vfunc_called(this, "_ZN6S573C53v48Ev");}
void  S573C5 ::v49(){vfunc_called(this, "_ZN6S573C53v49Ev");}
void  S573C5 ::v50(){vfunc_called(this, "_ZN6S573C53v50Ev");}
void  S573C5 ::v51(){vfunc_called(this, "_ZN6S573C53v51Ev");}
void  S573C5 ::v52(){vfunc_called(this, "_ZN6S573C53v52Ev");}
void  S573C5 ::v53(){vfunc_called(this, "_ZN6S573C53v53Ev");}
void  S573C5 ::v54(){vfunc_called(this, "_ZN6S573C53v54Ev");}
void  S573C5 ::v55(){vfunc_called(this, "_ZN6S573C53v55Ev");}
void  S573C5 ::v56(){vfunc_called(this, "_ZN6S573C53v56Ev");}
void  S573C5 ::v57(){vfunc_called(this, "_ZN6S573C53v57Ev");}
void  S573C5 ::v58(){vfunc_called(this, "_ZN6S573C53v58Ev");}
void  S573C5 ::v59(){vfunc_called(this, "_ZN6S573C53v59Ev");}
void  S573C5 ::v60(){vfunc_called(this, "_ZN6S573C53v60Ev");}
void  S573C5 ::v61(){vfunc_called(this, "_ZN6S573C53v61Ev");}
void  S573C5 ::v62(){vfunc_called(this, "_ZN6S573C53v62Ev");}
void  S573C5 ::v63(){vfunc_called(this, "_ZN6S573C53v63Ev");}
void  S573C5 ::v64(){vfunc_called(this, "_ZN6S573C53v64Ev");}
void  S573C5 ::v65(){vfunc_called(this, "_ZN6S573C53v65Ev");}
void  S573C5 ::v66(){vfunc_called(this, "_ZN6S573C53v66Ev");}
void  S573C5 ::v67(){vfunc_called(this, "_ZN6S573C53v67Ev");}
S573C5 ::S573C5(){ note_ctor("S573C5", this);} // tgen

static void Test_S573C5()
{
  extern Class_Descriptor cd_S573C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S573C5, buf);
    S573C5 *dp, &lv = *(dp=new (buf) S573C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S573C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S573C5)");
    check_field_offset(lv, s573c5f0, ABISELECT(8,4), "S573C5.s573c5f0");
    check_field_offset(lv, s573c5f1, ABISELECT(16,8), "S573C5.s573c5f1");
    check_field_offset(lv, s573c5f2, ABISELECT(24,16), "S573C5.s573c5f2");
    check_field_offset(lv, s573c5f3, ABISELECT(56,32), "S573C5.s573c5f3");
    check_field_offset(lv, s573c5f4, ABISELECT(64,40), "S573C5.s573c5f4");
    check_field_offset(lv, s573c5f5, ABISELECT(72,44), "S573C5.s573c5f5");
    check_field_offset(lv, s573c5f6, ABISELECT(80,52), "S573C5.s573c5f6");
    test_class_info(&lv, &cd_S573C5);
    dp->~S573C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS573C5(Test_S573C5, "S573C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S573C5C1Ev();
extern void _ZN6S573C5D1Ev();
Name_Map name_map_S573C5[] = {
  NSPAIR(_ZN6S573C5C1Ev),
  NSPAIR(_ZN6S573C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S573C5[];
extern void _ZN6S573C5D1Ev();
extern void _ZN6S573C5D0Ev();
extern void _ZN6S573C52v4Ev();
extern void _ZN6S573C52v5Ev();
extern void _ZN6S573C52v6Ev();
extern void _ZN6S573C52v7Ev();
extern void _ZN6S573C52v8Ev();
extern void _ZN6S573C52v9Ev();
extern void _ZN6S573C53v10Ev();
extern void _ZN6S573C53v11Ev();
extern void _ZN6S573C53v12Ev();
extern void _ZN6S573C53v13Ev();
extern void _ZN6S573C53v14Ev();
extern void _ZN6S573C53v15Ev();
extern void _ZN6S573C53v16Ev();
extern void _ZN6S573C53v17Ev();
extern void _ZN6S573C53v18Ev();
extern void _ZN6S573C53v19Ev();
extern void _ZN6S573C53v20Ev();
extern void _ZN6S573C53v21Ev();
extern void _ZN6S573C53v22Ev();
extern void _ZN6S573C53v23Ev();
extern void _ZN6S573C53v24Ev();
extern void _ZN6S573C53v25Ev();
extern void _ZN6S573C53v26Ev();
extern void _ZN6S573C53v27Ev();
extern void _ZN6S573C53v28Ev();
extern void _ZN6S573C53v29Ev();
extern void _ZN6S573C53v30Ev();
extern void _ZN6S573C53v31Ev();
extern void _ZN6S573C53v32Ev();
extern void _ZN6S573C53v33Ev();
extern void _ZN6S573C53v34Ev();
extern void _ZN6S573C53v35Ev();
extern void _ZN6S573C53v36Ev();
extern void _ZN6S573C53v37Ev();
extern void _ZN6S573C53v38Ev();
extern void _ZN6S573C53v39Ev();
extern void _ZN6S573C53v40Ev();
extern void _ZN6S573C53v41Ev();
extern void _ZN6S573C53v42Ev();
extern void _ZN6S573C53v43Ev();
extern void _ZN6S573C53v44Ev();
extern void _ZN6S573C53v45Ev();
extern void _ZN6S573C53v46Ev();
extern void _ZN6S573C53v47Ev();
extern void _ZN6S573C53v48Ev();
extern void _ZN6S573C53v49Ev();
extern void _ZN6S573C53v50Ev();
extern void _ZN6S573C53v51Ev();
extern void _ZN6S573C53v52Ev();
extern void _ZN6S573C53v53Ev();
extern void _ZN6S573C53v54Ev();
extern void _ZN6S573C53v55Ev();
extern void _ZN6S573C53v56Ev();
extern void _ZN6S573C53v57Ev();
extern void _ZN6S573C53v58Ev();
extern void _ZN6S573C53v59Ev();
extern void _ZN6S573C53v60Ev();
extern void _ZN6S573C53v61Ev();
extern void _ZN6S573C53v62Ev();
extern void _ZN6S573C53v63Ev();
extern void _ZN6S573C53v64Ev();
extern void _ZN6S573C53v65Ev();
extern void _ZN6S573C53v66Ev();
extern void _ZN6S573C53v67Ev();
static  VTBL_ENTRY vtc_S573C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S573C5[0]),
  (VTBL_ENTRY)&_ZN6S573C5D1Ev,
  (VTBL_ENTRY)&_ZN6S573C5D0Ev,
  (VTBL_ENTRY)&_ZN6S573C52v4Ev,
  (VTBL_ENTRY)&_ZN6S573C52v5Ev,
  (VTBL_ENTRY)&_ZN6S573C52v6Ev,
  (VTBL_ENTRY)&_ZN6S573C52v7Ev,
  (VTBL_ENTRY)&_ZN6S573C52v8Ev,
  (VTBL_ENTRY)&_ZN6S573C52v9Ev,
  (VTBL_ENTRY)&_ZN6S573C53v10Ev,
  (VTBL_ENTRY)&_ZN6S573C53v11Ev,
  (VTBL_ENTRY)&_ZN6S573C53v12Ev,
  (VTBL_ENTRY)&_ZN6S573C53v13Ev,
  (VTBL_ENTRY)&_ZN6S573C53v14Ev,
  (VTBL_ENTRY)&_ZN6S573C53v15Ev,
  (VTBL_ENTRY)&_ZN6S573C53v16Ev,
  (VTBL_ENTRY)&_ZN6S573C53v17Ev,
  (VTBL_ENTRY)&_ZN6S573C53v18Ev,
  (VTBL_ENTRY)&_ZN6S573C53v19Ev,
  (VTBL_ENTRY)&_ZN6S573C53v20Ev,
  (VTBL_ENTRY)&_ZN6S573C53v21Ev,
  (VTBL_ENTRY)&_ZN6S573C53v22Ev,
  (VTBL_ENTRY)&_ZN6S573C53v23Ev,
  (VTBL_ENTRY)&_ZN6S573C53v24Ev,
  (VTBL_ENTRY)&_ZN6S573C53v25Ev,
  (VTBL_ENTRY)&_ZN6S573C53v26Ev,
  (VTBL_ENTRY)&_ZN6S573C53v27Ev,
  (VTBL_ENTRY)&_ZN6S573C53v28Ev,
  (VTBL_ENTRY)&_ZN6S573C53v29Ev,
  (VTBL_ENTRY)&_ZN6S573C53v30Ev,
  (VTBL_ENTRY)&_ZN6S573C53v31Ev,
  (VTBL_ENTRY)&_ZN6S573C53v32Ev,
  (VTBL_ENTRY)&_ZN6S573C53v33Ev,
  (VTBL_ENTRY)&_ZN6S573C53v34Ev,
  (VTBL_ENTRY)&_ZN6S573C53v35Ev,
  (VTBL_ENTRY)&_ZN6S573C53v36Ev,
  (VTBL_ENTRY)&_ZN6S573C53v37Ev,
  (VTBL_ENTRY)&_ZN6S573C53v38Ev,
  (VTBL_ENTRY)&_ZN6S573C53v39Ev,
  (VTBL_ENTRY)&_ZN6S573C53v40Ev,
  (VTBL_ENTRY)&_ZN6S573C53v41Ev,
  (VTBL_ENTRY)&_ZN6S573C53v42Ev,
  (VTBL_ENTRY)&_ZN6S573C53v43Ev,
  (VTBL_ENTRY)&_ZN6S573C53v44Ev,
  (VTBL_ENTRY)&_ZN6S573C53v45Ev,
  (VTBL_ENTRY)&_ZN6S573C53v46Ev,
  (VTBL_ENTRY)&_ZN6S573C53v47Ev,
  (VTBL_ENTRY)&_ZN6S573C53v48Ev,
  (VTBL_ENTRY)&_ZN6S573C53v49Ev,
  (VTBL_ENTRY)&_ZN6S573C53v50Ev,
  (VTBL_ENTRY)&_ZN6S573C53v51Ev,
  (VTBL_ENTRY)&_ZN6S573C53v52Ev,
  (VTBL_ENTRY)&_ZN6S573C53v53Ev,
  (VTBL_ENTRY)&_ZN6S573C53v54Ev,
  (VTBL_ENTRY)&_ZN6S573C53v55Ev,
  (VTBL_ENTRY)&_ZN6S573C53v56Ev,
  (VTBL_ENTRY)&_ZN6S573C53v57Ev,
  (VTBL_ENTRY)&_ZN6S573C53v58Ev,
  (VTBL_ENTRY)&_ZN6S573C53v59Ev,
  (VTBL_ENTRY)&_ZN6S573C53v60Ev,
  (VTBL_ENTRY)&_ZN6S573C53v61Ev,
  (VTBL_ENTRY)&_ZN6S573C53v62Ev,
  (VTBL_ENTRY)&_ZN6S573C53v63Ev,
  (VTBL_ENTRY)&_ZN6S573C53v64Ev,
  (VTBL_ENTRY)&_ZN6S573C53v65Ev,
  (VTBL_ENTRY)&_ZN6S573C53v66Ev,
  (VTBL_ENTRY)&_ZN6S573C53v67Ev,
};
extern VTBL_ENTRY _ZTI6S573C5[];
extern  VTBL_ENTRY _ZTV6S573C5[];
Class_Descriptor cd_S573C5 = {  "S573C5", // class name
  0,0,//no base classes
  &(vtc_S573C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S573C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S573C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S573C4  : S573C5 {
  int s573c4f0[2];
  void *s573c4f1;
  int s573c4f2[2];
  ::S674C37_nt s573c4f3;
  ::S674C37_nt s573c4f4;
  ::S3625C32 s573c4f5;
  ::S674C37_nt s573c4f6;
  unsigned int s573c4f7:1;
  unsigned int s573c4f8:1;
  unsigned int s573c4f9:1;
  unsigned int s573c4f10:1;
  unsigned int s573c4f11:1;
  int s573c4f12[2];
  virtual  ~S573C4(); // _ZN6S573C4D1Ev
  virtual void  v68(); // _ZN6S573C43v68Ev
  virtual void  v69(); // _ZN6S573C43v69Ev
  virtual void  v70(); // _ZN6S573C43v70Ev
  virtual void  v71(); // _ZN6S573C43v71Ev
  virtual void  v72(); // _ZN6S573C43v72Ev
  virtual void  v73(); // _ZN6S573C43v73Ev
  virtual void  v74(); // _ZN6S573C43v74Ev
  virtual void  v75(); // _ZN6S573C43v75Ev
  virtual void  v76(); // _ZN6S573C43v76Ev
  virtual void  v77(); // _ZN6S573C43v77Ev
  virtual void  v78(); // _ZN6S573C43v78Ev
  virtual void  v79(); // _ZN6S573C43v79Ev
  virtual void  v80(); // _ZN6S573C43v80Ev
  virtual void  v81(); // _ZN6S573C43v81Ev
  virtual void  v82(); // _ZN6S573C43v82Ev
  virtual void  v83(); // _ZN6S573C43v83Ev
  virtual void  v84(); // _ZN6S573C43v84Ev
  virtual void  v85(); // _ZN6S573C43v85Ev
  virtual void  v86(); // _ZN6S573C43v86Ev
  virtual void  v87(); // _ZN6S573C43v87Ev
  virtual void  v88(); // _ZN6S573C43v88Ev
  virtual void  v89(); // _ZN6S573C43v89Ev
  S573C4(); // tgen
};
//SIG(-1 S573C4) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S573C4 ::~S573C4(){ note_dtor("S573C4", this);}
void  S573C4 ::v68(){vfunc_called(this, "_ZN6S573C43v68Ev");}
void  S573C4 ::v69(){vfunc_called(this, "_ZN6S573C43v69Ev");}
void  S573C4 ::v70(){vfunc_called(this, "_ZN6S573C43v70Ev");}
void  S573C4 ::v71(){vfunc_called(this, "_ZN6S573C43v71Ev");}
void  S573C4 ::v72(){vfunc_called(this, "_ZN6S573C43v72Ev");}
void  S573C4 ::v73(){vfunc_called(this, "_ZN6S573C43v73Ev");}
void  S573C4 ::v74(){vfunc_called(this, "_ZN6S573C43v74Ev");}
void  S573C4 ::v75(){vfunc_called(this, "_ZN6S573C43v75Ev");}
void  S573C4 ::v76(){vfunc_called(this, "_ZN6S573C43v76Ev");}
void  S573C4 ::v77(){vfunc_called(this, "_ZN6S573C43v77Ev");}
void  S573C4 ::v78(){vfunc_called(this, "_ZN6S573C43v78Ev");}
void  S573C4 ::v79(){vfunc_called(this, "_ZN6S573C43v79Ev");}
void  S573C4 ::v80(){vfunc_called(this, "_ZN6S573C43v80Ev");}
void  S573C4 ::v81(){vfunc_called(this, "_ZN6S573C43v81Ev");}
void  S573C4 ::v82(){vfunc_called(this, "_ZN6S573C43v82Ev");}
void  S573C4 ::v83(){vfunc_called(this, "_ZN6S573C43v83Ev");}
void  S573C4 ::v84(){vfunc_called(this, "_ZN6S573C43v84Ev");}
void  S573C4 ::v85(){vfunc_called(this, "_ZN6S573C43v85Ev");}
void  S573C4 ::v86(){vfunc_called(this, "_ZN6S573C43v86Ev");}
void  S573C4 ::v87(){vfunc_called(this, "_ZN6S573C43v87Ev");}
void  S573C4 ::v88(){vfunc_called(this, "_ZN6S573C43v88Ev");}
void  S573C4 ::v89(){vfunc_called(this, "_ZN6S573C43v89Ev");}
S573C4 ::S573C4(){ note_ctor("S573C4", this);} // tgen

static void Test_S573C4()
{
  extern Class_Descriptor cd_S573C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S573C4, buf);
    S573C4 *dp, &lv = *(dp=new (buf) S573C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S573C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S573C4)");
    check_base_class_offset(lv, (S573C5*), 0, "S573C4");
    check_field_offset(lv, s573c4f0, ABISELECT(96,60), "S573C4.s573c4f0");
    check_field_offset(lv, s573c4f1, ABISELECT(104,68), "S573C4.s573c4f1");
    check_field_offset(lv, s573c4f2, ABISELECT(112,72), "S573C4.s573c4f2");
    check_field_offset(lv, s573c4f3, ABISELECT(120,80), "S573C4.s573c4f3");
    check_field_offset(lv, s573c4f4, ABISELECT(136,92), "S573C4.s573c4f4");
    check_field_offset(lv, s573c4f5, ABISELECT(152,104), "S573C4.s573c4f5");
    check_field_offset(lv, s573c4f6, ABISELECT(160,108), "S573C4.s573c4f6");
    set_bf_and_test(lv, s573c4f7, ABISELECT(176,120), 0, 1, 1, "S573C4");
    set_bf_and_test(lv, s573c4f8, ABISELECT(176,120), 1, 1, 1, "S573C4");
    set_bf_and_test(lv, s573c4f9, ABISELECT(176,120), 2, 1, 1, "S573C4");
    set_bf_and_test(lv, s573c4f10, ABISELECT(176,120), 3, 1, 1, "S573C4");
    set_bf_and_test(lv, s573c4f11, ABISELECT(176,120), 4, 1, 1, "S573C4");
    check_field_offset(lv, s573c4f12, ABISELECT(180,124), "S573C4.s573c4f12");
    test_class_info(&lv, &cd_S573C4);
    dp->~S573C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS573C4(Test_S573C4, "S573C4", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN6S573C4C1Ev();
extern void _ZN6S573C4D1Ev();
Name_Map name_map_S573C4[] = {
  NSPAIR(_ZN6S573C4C1Ev),
  NSPAIR(_ZN6S573C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S573C5;
extern VTBL_ENTRY _ZTI6S573C5[];
extern  VTBL_ENTRY _ZTV6S573C5[];
static Base_Class bases_S573C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S573C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S573C4[];
extern void _ZN6S573C4D1Ev();
extern void _ZN6S573C4D0Ev();
extern void _ZN6S573C52v4Ev();
extern void _ZN6S573C52v5Ev();
extern void _ZN6S573C52v6Ev();
extern void _ZN6S573C52v7Ev();
extern void _ZN6S573C52v8Ev();
extern void _ZN6S573C52v9Ev();
extern void _ZN6S573C53v10Ev();
extern void _ZN6S573C53v11Ev();
extern void _ZN6S573C53v12Ev();
extern void _ZN6S573C53v13Ev();
extern void _ZN6S573C53v14Ev();
extern void _ZN6S573C53v15Ev();
extern void _ZN6S573C53v16Ev();
extern void _ZN6S573C53v17Ev();
extern void _ZN6S573C53v18Ev();
extern void _ZN6S573C53v19Ev();
extern void _ZN6S573C53v20Ev();
extern void _ZN6S573C53v21Ev();
extern void _ZN6S573C53v22Ev();
extern void _ZN6S573C53v23Ev();
extern void _ZN6S573C53v24Ev();
extern void _ZN6S573C53v25Ev();
extern void _ZN6S573C53v26Ev();
extern void _ZN6S573C53v27Ev();
extern void _ZN6S573C53v28Ev();
extern void _ZN6S573C53v29Ev();
extern void _ZN6S573C53v30Ev();
extern void _ZN6S573C53v31Ev();
extern void _ZN6S573C53v32Ev();
extern void _ZN6S573C53v33Ev();
extern void _ZN6S573C53v34Ev();
extern void _ZN6S573C53v35Ev();
extern void _ZN6S573C53v36Ev();
extern void _ZN6S573C53v37Ev();
extern void _ZN6S573C53v38Ev();
extern void _ZN6S573C53v39Ev();
extern void _ZN6S573C53v40Ev();
extern void _ZN6S573C53v41Ev();
extern void _ZN6S573C53v42Ev();
extern void _ZN6S573C53v43Ev();
extern void _ZN6S573C53v44Ev();
extern void _ZN6S573C53v45Ev();
extern void _ZN6S573C53v46Ev();
extern void _ZN6S573C53v47Ev();
extern void _ZN6S573C53v48Ev();
extern void _ZN6S573C53v49Ev();
extern void _ZN6S573C53v50Ev();
extern void _ZN6S573C53v51Ev();
extern void _ZN6S573C53v52Ev();
extern void _ZN6S573C53v53Ev();
extern void _ZN6S573C53v54Ev();
extern void _ZN6S573C53v55Ev();
extern void _ZN6S573C53v56Ev();
extern void _ZN6S573C53v57Ev();
extern void _ZN6S573C53v58Ev();
extern void _ZN6S573C53v59Ev();
extern void _ZN6S573C53v60Ev();
extern void _ZN6S573C53v61Ev();
extern void _ZN6S573C53v62Ev();
extern void _ZN6S573C53v63Ev();
extern void _ZN6S573C53v64Ev();
extern void _ZN6S573C53v65Ev();
extern void _ZN6S573C53v66Ev();
extern void _ZN6S573C53v67Ev();
extern void _ZN6S573C43v68Ev();
extern void _ZN6S573C43v69Ev();
extern void _ZN6S573C43v70Ev();
extern void _ZN6S573C43v71Ev();
extern void _ZN6S573C43v72Ev();
extern void _ZN6S573C43v73Ev();
extern void _ZN6S573C43v74Ev();
extern void _ZN6S573C43v75Ev();
extern void _ZN6S573C43v76Ev();
extern void _ZN6S573C43v77Ev();
extern void _ZN6S573C43v78Ev();
extern void _ZN6S573C43v79Ev();
extern void _ZN6S573C43v80Ev();
extern void _ZN6S573C43v81Ev();
extern void _ZN6S573C43v82Ev();
extern void _ZN6S573C43v83Ev();
extern void _ZN6S573C43v84Ev();
extern void _ZN6S573C43v85Ev();
extern void _ZN6S573C43v86Ev();
extern void _ZN6S573C43v87Ev();
extern void _ZN6S573C43v88Ev();
extern void _ZN6S573C43v89Ev();
static  VTBL_ENTRY vtc_S573C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S573C4[0]),
  (VTBL_ENTRY)&_ZN6S573C4D1Ev,
  (VTBL_ENTRY)&_ZN6S573C4D0Ev,
  (VTBL_ENTRY)&_ZN6S573C52v4Ev,
  (VTBL_ENTRY)&_ZN6S573C52v5Ev,
  (VTBL_ENTRY)&_ZN6S573C52v6Ev,
  (VTBL_ENTRY)&_ZN6S573C52v7Ev,
  (VTBL_ENTRY)&_ZN6S573C52v8Ev,
  (VTBL_ENTRY)&_ZN6S573C52v9Ev,
  (VTBL_ENTRY)&_ZN6S573C53v10Ev,
  (VTBL_ENTRY)&_ZN6S573C53v11Ev,
  (VTBL_ENTRY)&_ZN6S573C53v12Ev,
  (VTBL_ENTRY)&_ZN6S573C53v13Ev,
  (VTBL_ENTRY)&_ZN6S573C53v14Ev,
  (VTBL_ENTRY)&_ZN6S573C53v15Ev,
  (VTBL_ENTRY)&_ZN6S573C53v16Ev,
  (VTBL_ENTRY)&_ZN6S573C53v17Ev,
  (VTBL_ENTRY)&_ZN6S573C53v18Ev,
  (VTBL_ENTRY)&_ZN6S573C53v19Ev,
  (VTBL_ENTRY)&_ZN6S573C53v20Ev,
  (VTBL_ENTRY)&_ZN6S573C53v21Ev,
  (VTBL_ENTRY)&_ZN6S573C53v22Ev,
  (VTBL_ENTRY)&_ZN6S573C53v23Ev,
  (VTBL_ENTRY)&_ZN6S573C53v24Ev,
  (VTBL_ENTRY)&_ZN6S573C53v25Ev,
  (VTBL_ENTRY)&_ZN6S573C53v26Ev,
  (VTBL_ENTRY)&_ZN6S573C53v27Ev,
  (VTBL_ENTRY)&_ZN6S573C53v28Ev,
  (VTBL_ENTRY)&_ZN6S573C53v29Ev,
  (VTBL_ENTRY)&_ZN6S573C53v30Ev,
  (VTBL_ENTRY)&_ZN6S573C53v31Ev,
  (VTBL_ENTRY)&_ZN6S573C53v32Ev,
  (VTBL_ENTRY)&_ZN6S573C53v33Ev,
  (VTBL_ENTRY)&_ZN6S573C53v34Ev,
  (VTBL_ENTRY)&_ZN6S573C53v35Ev,
  (VTBL_ENTRY)&_ZN6S573C53v36Ev,
  (VTBL_ENTRY)&_ZN6S573C53v37Ev,
  (VTBL_ENTRY)&_ZN6S573C53v38Ev,
  (VTBL_ENTRY)&_ZN6S573C53v39Ev,
  (VTBL_ENTRY)&_ZN6S573C53v40Ev,
  (VTBL_ENTRY)&_ZN6S573C53v41Ev,
  (VTBL_ENTRY)&_ZN6S573C53v42Ev,
  (VTBL_ENTRY)&_ZN6S573C53v43Ev,
  (VTBL_ENTRY)&_ZN6S573C53v44Ev,
  (VTBL_ENTRY)&_ZN6S573C53v45Ev,
  (VTBL_ENTRY)&_ZN6S573C53v46Ev,
  (VTBL_ENTRY)&_ZN6S573C53v47Ev,
  (VTBL_ENTRY)&_ZN6S573C53v48Ev,
  (VTBL_ENTRY)&_ZN6S573C53v49Ev,
  (VTBL_ENTRY)&_ZN6S573C53v50Ev,
  (VTBL_ENTRY)&_ZN6S573C53v51Ev,
  (VTBL_ENTRY)&_ZN6S573C53v52Ev,
  (VTBL_ENTRY)&_ZN6S573C53v53Ev,
  (VTBL_ENTRY)&_ZN6S573C53v54Ev,
  (VTBL_ENTRY)&_ZN6S573C53v55Ev,
  (VTBL_ENTRY)&_ZN6S573C53v56Ev,
  (VTBL_ENTRY)&_ZN6S573C53v57Ev,
  (VTBL_ENTRY)&_ZN6S573C53v58Ev,
  (VTBL_ENTRY)&_ZN6S573C53v59Ev,
  (VTBL_ENTRY)&_ZN6S573C53v60Ev,
  (VTBL_ENTRY)&_ZN6S573C53v61Ev,
  (VTBL_ENTRY)&_ZN6S573C53v62Ev,
  (VTBL_ENTRY)&_ZN6S573C53v63Ev,
  (VTBL_ENTRY)&_ZN6S573C53v64Ev,
  (VTBL_ENTRY)&_ZN6S573C53v65Ev,
  (VTBL_ENTRY)&_ZN6S573C53v66Ev,
  (VTBL_ENTRY)&_ZN6S573C53v67Ev,
  (VTBL_ENTRY)&_ZN6S573C43v68Ev,
  (VTBL_ENTRY)&_ZN6S573C43v69Ev,
  (VTBL_ENTRY)&_ZN6S573C43v70Ev,
  (VTBL_ENTRY)&_ZN6S573C43v71Ev,
  (VTBL_ENTRY)&_ZN6S573C43v72Ev,
  (VTBL_ENTRY)&_ZN6S573C43v73Ev,
  (VTBL_ENTRY)&_ZN6S573C43v74Ev,
  (VTBL_ENTRY)&_ZN6S573C43v75Ev,
  (VTBL_ENTRY)&_ZN6S573C43v76Ev,
  (VTBL_ENTRY)&_ZN6S573C43v77Ev,
  (VTBL_ENTRY)&_ZN6S573C43v78Ev,
  (VTBL_ENTRY)&_ZN6S573C43v79Ev,
  (VTBL_ENTRY)&_ZN6S573C43v80Ev,
  (VTBL_ENTRY)&_ZN6S573C43v81Ev,
  (VTBL_ENTRY)&_ZN6S573C43v82Ev,
  (VTBL_ENTRY)&_ZN6S573C43v83Ev,
  (VTBL_ENTRY)&_ZN6S573C43v84Ev,
  (VTBL_ENTRY)&_ZN6S573C43v85Ev,
  (VTBL_ENTRY)&_ZN6S573C43v86Ev,
  (VTBL_ENTRY)&_ZN6S573C43v87Ev,
  (VTBL_ENTRY)&_ZN6S573C43v88Ev,
  (VTBL_ENTRY)&_ZN6S573C43v89Ev,
};
extern VTBL_ENTRY _ZTI6S573C4[];
extern  VTBL_ENTRY _ZTV6S573C4[];
Class_Descriptor cd_S573C4 = {  "S573C4", // class name
  bases_S573C4, 1,
  &(vtc_S573C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI6S573C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S573C4),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S573C3  : S573C4 {
  unsigned int s573c3f0:1;
  unsigned int s573c3f1:1;
  unsigned int s573c3f2:1;
  ::S674C42 s573c3f3;
  ::S674C38 s573c3f4;
  ::S674C17 s573c3f5;
  ::S674C13 s573c3f6;
  int s573c3f7[3];
  virtual  ~S573C3(); // _ZN6S573C3D1Ev
  virtual void  v90(); // _ZN6S573C33v90Ev
  virtual void  v91(); // _ZN6S573C33v91Ev
  virtual void  v92(); // _ZN6S573C33v92Ev
  virtual void  v93(); // _ZN6S573C33v93Ev
  virtual void  v94(); // _ZN6S573C33v94Ev
  virtual void  v95(); // _ZN6S573C33v95Ev
  virtual void  v96(); // _ZN6S573C33v96Ev
  virtual void  v97(); // _ZN6S573C33v97Ev
  virtual void  v98(); // _ZN6S573C33v98Ev
  virtual void  v99(); // _ZN6S573C33v99Ev
  virtual void  v100(); // _ZN6S573C34v100Ev
  virtual void  v101(); // _ZN6S573C34v101Ev
  virtual void  v102(); // _ZN6S573C34v102Ev
  virtual void  v103(); // _ZN6S573C34v103Ev
  virtual void  v104(); // _ZN6S573C34v104Ev
  virtual void  v105(); // _ZN6S573C34v105Ev
  virtual void  v106(); // _ZN6S573C34v106Ev
  virtual void  v107(); // _ZN6S573C34v107Ev
  virtual void  v108(); // _ZN6S573C34v108Ev
  virtual void  v109(); // _ZN6S573C34v109Ev
  S573C3(); // tgen
};
//SIG(-1 S573C3) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC6 FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} Fi[3]}


 S573C3 ::~S573C3(){ note_dtor("S573C3", this);}
void  S573C3 ::v90(){vfunc_called(this, "_ZN6S573C33v90Ev");}
void  S573C3 ::v91(){vfunc_called(this, "_ZN6S573C33v91Ev");}
void  S573C3 ::v92(){vfunc_called(this, "_ZN6S573C33v92Ev");}
void  S573C3 ::v93(){vfunc_called(this, "_ZN6S573C33v93Ev");}
void  S573C3 ::v94(){vfunc_called(this, "_ZN6S573C33v94Ev");}
void  S573C3 ::v95(){vfunc_called(this, "_ZN6S573C33v95Ev");}
void  S573C3 ::v96(){vfunc_called(this, "_ZN6S573C33v96Ev");}
void  S573C3 ::v97(){vfunc_called(this, "_ZN6S573C33v97Ev");}
void  S573C3 ::v98(){vfunc_called(this, "_ZN6S573C33v98Ev");}
void  S573C3 ::v99(){vfunc_called(this, "_ZN6S573C33v99Ev");}
void  S573C3 ::v100(){vfunc_called(this, "_ZN6S573C34v100Ev");}
void  S573C3 ::v101(){vfunc_called(this, "_ZN6S573C34v101Ev");}
void  S573C3 ::v102(){vfunc_called(this, "_ZN6S573C34v102Ev");}
void  S573C3 ::v103(){vfunc_called(this, "_ZN6S573C34v103Ev");}
void  S573C3 ::v104(){vfunc_called(this, "_ZN6S573C34v104Ev");}
void  S573C3 ::v105(){vfunc_called(this, "_ZN6S573C34v105Ev");}
void  S573C3 ::v106(){vfunc_called(this, "_ZN6S573C34v106Ev");}
void  S573C3 ::v107(){vfunc_called(this, "_ZN6S573C34v107Ev");}
void  S573C3 ::v108(){vfunc_called(this, "_ZN6S573C34v108Ev");}
void  S573C3 ::v109(){vfunc_called(this, "_ZN6S573C34v109Ev");}
S573C3 ::S573C3(){ note_ctor("S573C3", this);} // tgen

static void Test_S573C3()
{
  extern Class_Descriptor cd_S573C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(35,50)];
    init_test(&cd_S573C3, buf);
    S573C3 *dp, &lv = *(dp=new (buf) S573C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,196), "sizeof(S573C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S573C3)");
    check_base_class_offset(lv, (S573C5*)(S573C4*), 0, "S573C3");
    check_base_class_offset(lv, (S573C4*), 0, "S573C3");
    set_bf_and_test(lv, s573c3f0, ABISELECT(188,132), 0, 1, 1, "S573C3");
    set_bf_and_test(lv, s573c3f1, ABISELECT(188,132), 1, 1, 1, "S573C3");
    set_bf_and_test(lv, s573c3f2, ABISELECT(188,132), 2, 1, 1, "S573C3");
    check_field_offset(lv, s573c3f3, ABISELECT(192,136), "S573C3.s573c3f3");
    check_field_offset(lv, s573c3f4, ABISELECT(208,148), "S573C3.s573c3f4");
    check_field_offset(lv, s573c3f5, ABISELECT(224,160), "S573C3.s573c3f5");
    check_field_offset(lv, s573c3f6, ABISELECT(240,172), "S573C3.s573c3f6");
    check_field_offset(lv, s573c3f7, ABISELECT(256,184), "S573C3.s573c3f7");
    test_class_info(&lv, &cd_S573C3);
    dp->~S573C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS573C3(Test_S573C3, "S573C3", ABISELECT(272,196));

#else // __cplusplus

extern void _ZN6S573C3C1Ev();
extern void _ZN6S573C3D1Ev();
Name_Map name_map_S573C3[] = {
  NSPAIR(_ZN6S573C3C1Ev),
  NSPAIR(_ZN6S573C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S573C5;
extern VTBL_ENTRY _ZTI6S573C5[];
extern  VTBL_ENTRY _ZTV6S573C5[];
extern Class_Descriptor cd_S573C4;
extern VTBL_ENTRY _ZTI6S573C4[];
extern  VTBL_ENTRY _ZTV6S573C4[];
static Base_Class bases_S573C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S573C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S573C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S573C3[];
extern void _ZN6S573C3D1Ev();
extern void _ZN6S573C3D0Ev();
extern void _ZN6S573C52v4Ev();
extern void _ZN6S573C52v5Ev();
extern void _ZN6S573C52v6Ev();
extern void _ZN6S573C52v7Ev();
extern void _ZN6S573C52v8Ev();
extern void _ZN6S573C52v9Ev();
extern void _ZN6S573C53v10Ev();
extern void _ZN6S573C53v11Ev();
extern void _ZN6S573C53v12Ev();
extern void _ZN6S573C53v13Ev();
extern void _ZN6S573C53v14Ev();
extern void _ZN6S573C53v15Ev();
extern void _ZN6S573C53v16Ev();
extern void _ZN6S573C53v17Ev();
extern void _ZN6S573C53v18Ev();
extern void _ZN6S573C53v19Ev();
extern void _ZN6S573C53v20Ev();
extern void _ZN6S573C53v21Ev();
extern void _ZN6S573C53v22Ev();
extern void _ZN6S573C53v23Ev();
extern void _ZN6S573C53v24Ev();
extern void _ZN6S573C53v25Ev();
extern void _ZN6S573C53v26Ev();
extern void _ZN6S573C53v27Ev();
extern void _ZN6S573C53v28Ev();
extern void _ZN6S573C53v29Ev();
extern void _ZN6S573C53v30Ev();
extern void _ZN6S573C53v31Ev();
extern void _ZN6S573C53v32Ev();
extern void _ZN6S573C53v33Ev();
extern void _ZN6S573C53v34Ev();
extern void _ZN6S573C53v35Ev();
extern void _ZN6S573C53v36Ev();
extern void _ZN6S573C53v37Ev();
extern void _ZN6S573C53v38Ev();
extern void _ZN6S573C53v39Ev();
extern void _ZN6S573C53v40Ev();
extern void _ZN6S573C53v41Ev();
extern void _ZN6S573C53v42Ev();
extern void _ZN6S573C53v43Ev();
extern void _ZN6S573C53v44Ev();
extern void _ZN6S573C53v45Ev();
extern void _ZN6S573C53v46Ev();
extern void _ZN6S573C53v47Ev();
extern void _ZN6S573C53v48Ev();
extern void _ZN6S573C53v49Ev();
extern void _ZN6S573C53v50Ev();
extern void _ZN6S573C53v51Ev();
extern void _ZN6S573C53v52Ev();
extern void _ZN6S573C53v53Ev();
extern void _ZN6S573C53v54Ev();
extern void _ZN6S573C53v55Ev();
extern void _ZN6S573C53v56Ev();
extern void _ZN6S573C53v57Ev();
extern void _ZN6S573C53v58Ev();
extern void _ZN6S573C53v59Ev();
extern void _ZN6S573C53v60Ev();
extern void _ZN6S573C53v61Ev();
extern void _ZN6S573C53v62Ev();
extern void _ZN6S573C53v63Ev();
extern void _ZN6S573C53v64Ev();
extern void _ZN6S573C53v65Ev();
extern void _ZN6S573C53v66Ev();
extern void _ZN6S573C53v67Ev();
extern void _ZN6S573C43v68Ev();
extern void _ZN6S573C43v69Ev();
extern void _ZN6S573C43v70Ev();
extern void _ZN6S573C43v71Ev();
extern void _ZN6S573C43v72Ev();
extern void _ZN6S573C43v73Ev();
extern void _ZN6S573C43v74Ev();
extern void _ZN6S573C43v75Ev();
extern void _ZN6S573C43v76Ev();
extern void _ZN6S573C43v77Ev();
extern void _ZN6S573C43v78Ev();
extern void _ZN6S573C43v79Ev();
extern void _ZN6S573C43v80Ev();
extern void _ZN6S573C43v81Ev();
extern void _ZN6S573C43v82Ev();
extern void _ZN6S573C43v83Ev();
extern void _ZN6S573C43v84Ev();
extern void _ZN6S573C43v85Ev();
extern void _ZN6S573C43v86Ev();
extern void _ZN6S573C43v87Ev();
extern void _ZN6S573C43v88Ev();
extern void _ZN6S573C43v89Ev();
extern void _ZN6S573C33v90Ev();
extern void _ZN6S573C33v91Ev();
extern void _ZN6S573C33v92Ev();
extern void _ZN6S573C33v93Ev();
extern void _ZN6S573C33v94Ev();
extern void _ZN6S573C33v95Ev();
extern void _ZN6S573C33v96Ev();
extern void _ZN6S573C33v97Ev();
extern void _ZN6S573C33v98Ev();
extern void _ZN6S573C33v99Ev();
extern void _ZN6S573C34v100Ev();
extern void _ZN6S573C34v101Ev();
extern void _ZN6S573C34v102Ev();
extern void _ZN6S573C34v103Ev();
extern void _ZN6S573C34v104Ev();
extern void _ZN6S573C34v105Ev();
extern void _ZN6S573C34v106Ev();
extern void _ZN6S573C34v107Ev();
extern void _ZN6S573C34v108Ev();
extern void _ZN6S573C34v109Ev();
static  VTBL_ENTRY vtc_S573C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S573C3[0]),
  (VTBL_ENTRY)&_ZN6S573C3D1Ev,
  (VTBL_ENTRY)&_ZN6S573C3D0Ev,
  (VTBL_ENTRY)&_ZN6S573C52v4Ev,
  (VTBL_ENTRY)&_ZN6S573C52v5Ev,
  (VTBL_ENTRY)&_ZN6S573C52v6Ev,
  (VTBL_ENTRY)&_ZN6S573C52v7Ev,
  (VTBL_ENTRY)&_ZN6S573C52v8Ev,
  (VTBL_ENTRY)&_ZN6S573C52v9Ev,
  (VTBL_ENTRY)&_ZN6S573C53v10Ev,
  (VTBL_ENTRY)&_ZN6S573C53v11Ev,
  (VTBL_ENTRY)&_ZN6S573C53v12Ev,
  (VTBL_ENTRY)&_ZN6S573C53v13Ev,
  (VTBL_ENTRY)&_ZN6S573C53v14Ev,
  (VTBL_ENTRY)&_ZN6S573C53v15Ev,
  (VTBL_ENTRY)&_ZN6S573C53v16Ev,
  (VTBL_ENTRY)&_ZN6S573C53v17Ev,
  (VTBL_ENTRY)&_ZN6S573C53v18Ev,
  (VTBL_ENTRY)&_ZN6S573C53v19Ev,
  (VTBL_ENTRY)&_ZN6S573C53v20Ev,
  (VTBL_ENTRY)&_ZN6S573C53v21Ev,
  (VTBL_ENTRY)&_ZN6S573C53v22Ev,
  (VTBL_ENTRY)&_ZN6S573C53v23Ev,
  (VTBL_ENTRY)&_ZN6S573C53v24Ev,
  (VTBL_ENTRY)&_ZN6S573C53v25Ev,
  (VTBL_ENTRY)&_ZN6S573C53v26Ev,
  (VTBL_ENTRY)&_ZN6S573C53v27Ev,
  (VTBL_ENTRY)&_ZN6S573C53v28Ev,
  (VTBL_ENTRY)&_ZN6S573C53v29Ev,
  (VTBL_ENTRY)&_ZN6S573C53v30Ev,
  (VTBL_ENTRY)&_ZN6S573C53v31Ev,
  (VTBL_ENTRY)&_ZN6S573C53v32Ev,
  (VTBL_ENTRY)&_ZN6S573C53v33Ev,
  (VTBL_ENTRY)&_ZN6S573C53v34Ev,
  (VTBL_ENTRY)&_ZN6S573C53v35Ev,
  (VTBL_ENTRY)&_ZN6S573C53v36Ev,
  (VTBL_ENTRY)&_ZN6S573C53v37Ev,
  (VTBL_ENTRY)&_ZN6S573C53v38Ev,
  (VTBL_ENTRY)&_ZN6S573C53v39Ev,
  (VTBL_ENTRY)&_ZN6S573C53v40Ev,
  (VTBL_ENTRY)&_ZN6S573C53v41Ev,
  (VTBL_ENTRY)&_ZN6S573C53v42Ev,
  (VTBL_ENTRY)&_ZN6S573C53v43Ev,
  (VTBL_ENTRY)&_ZN6S573C53v44Ev,
  (VTBL_ENTRY)&_ZN6S573C53v45Ev,
  (VTBL_ENTRY)&_ZN6S573C53v46Ev,
  (VTBL_ENTRY)&_ZN6S573C53v47Ev,
  (VTBL_ENTRY)&_ZN6S573C53v48Ev,
  (VTBL_ENTRY)&_ZN6S573C53v49Ev,
  (VTBL_ENTRY)&_ZN6S573C53v50Ev,
  (VTBL_ENTRY)&_ZN6S573C53v51Ev,
  (VTBL_ENTRY)&_ZN6S573C53v52Ev,
  (VTBL_ENTRY)&_ZN6S573C53v53Ev,
  (VTBL_ENTRY)&_ZN6S573C53v54Ev,
  (VTBL_ENTRY)&_ZN6S573C53v55Ev,
  (VTBL_ENTRY)&_ZN6S573C53v56Ev,
  (VTBL_ENTRY)&_ZN6S573C53v57Ev,
  (VTBL_ENTRY)&_ZN6S573C53v58Ev,
  (VTBL_ENTRY)&_ZN6S573C53v59Ev,
  (VTBL_ENTRY)&_ZN6S573C53v60Ev,
  (VTBL_ENTRY)&_ZN6S573C53v61Ev,
  (VTBL_ENTRY)&_ZN6S573C53v62Ev,
  (VTBL_ENTRY)&_ZN6S573C53v63Ev,
  (VTBL_ENTRY)&_ZN6S573C53v64Ev,
  (VTBL_ENTRY)&_ZN6S573C53v65Ev,
  (VTBL_ENTRY)&_ZN6S573C53v66Ev,
  (VTBL_ENTRY)&_ZN6S573C53v67Ev,
  (VTBL_ENTRY)&_ZN6S573C43v68Ev,
  (VTBL_ENTRY)&_ZN6S573C43v69Ev,
  (VTBL_ENTRY)&_ZN6S573C43v70Ev,
  (VTBL_ENTRY)&_ZN6S573C43v71Ev,
  (VTBL_ENTRY)&_ZN6S573C43v72Ev,
  (VTBL_ENTRY)&_ZN6S573C43v73Ev,
  (VTBL_ENTRY)&_ZN6S573C43v74Ev,
  (VTBL_ENTRY)&_ZN6S573C43v75Ev,
  (VTBL_ENTRY)&_ZN6S573C43v76Ev,
  (VTBL_ENTRY)&_ZN6S573C43v77Ev,
  (VTBL_ENTRY)&_ZN6S573C43v78Ev,
  (VTBL_ENTRY)&_ZN6S573C43v79Ev,
  (VTBL_ENTRY)&_ZN6S573C43v80Ev,
  (VTBL_ENTRY)&_ZN6S573C43v81Ev,
  (VTBL_ENTRY)&_ZN6S573C43v82Ev,
  (VTBL_ENTRY)&_ZN6S573C43v83Ev,
  (VTBL_ENTRY)&_ZN6S573C43v84Ev,
  (VTBL_ENTRY)&_ZN6S573C43v85Ev,
  (VTBL_ENTRY)&_ZN6S573C43v86Ev,
  (VTBL_ENTRY)&_ZN6S573C43v87Ev,
  (VTBL_ENTRY)&_ZN6S573C43v88Ev,
  (VTBL_ENTRY)&_ZN6S573C43v89Ev,
  (VTBL_ENTRY)&_ZN6S573C33v90Ev,
  (VTBL_ENTRY)&_ZN6S573C33v91Ev,
  (VTBL_ENTRY)&_ZN6S573C33v92Ev,
  (VTBL_ENTRY)&_ZN6S573C33v93Ev,
  (VTBL_ENTRY)&_ZN6S573C33v94Ev,
  (VTBL_ENTRY)&_ZN6S573C33v95Ev,
  (VTBL_ENTRY)&_ZN6S573C33v96Ev,
  (VTBL_ENTRY)&_ZN6S573C33v97Ev,
  (VTBL_ENTRY)&_ZN6S573C33v98Ev,
  (VTBL_ENTRY)&_ZN6S573C33v99Ev,
  (VTBL_ENTRY)&_ZN6S573C34v100Ev,
  (VTBL_ENTRY)&_ZN6S573C34v101Ev,
  (VTBL_ENTRY)&_ZN6S573C34v102Ev,
  (VTBL_ENTRY)&_ZN6S573C34v103Ev,
  (VTBL_ENTRY)&_ZN6S573C34v104Ev,
  (VTBL_ENTRY)&_ZN6S573C34v105Ev,
  (VTBL_ENTRY)&_ZN6S573C34v106Ev,
  (VTBL_ENTRY)&_ZN6S573C34v107Ev,
  (VTBL_ENTRY)&_ZN6S573C34v108Ev,
  (VTBL_ENTRY)&_ZN6S573C34v109Ev,
};
extern VTBL_ENTRY _ZTI6S573C3[];
extern  VTBL_ENTRY _ZTV6S573C3[];
Class_Descriptor cd_S573C3 = {  "S573C3", // class name
  bases_S573C3, 2,
  &(vtc_S573C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI6S573C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S573C3),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S573C2_nt  : S573C3 {
  ::S674C6_nt s573c2f0;
  unsigned int s573c2f1:1;
  ::S674C8_nt s573c2f2;
  virtual  ~S573C2_nt(); // _ZN9S573C2_ntD1Ev
  virtual void  v110(); // _ZN9S573C2_nt4v110Ev
  virtual void  v111(); // _ZN9S573C2_nt4v111Ev
  virtual void  v112(); // _ZN9S573C2_nt4v112Ev
  virtual void  v113(); // _ZN9S573C2_nt4v113Ev
  S573C2_nt(); // tgen
};
//SIG(-1 S573C2_nt) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC7 FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} Fi[3]} vd v1 v2 v3 v4 FC5 Fi:1 FC17{ BC18{ BC9}}}


 S573C2_nt ::~S573C2_nt(){ note_dtor("S573C2_nt", this);}
void  S573C2_nt ::v110(){vfunc_called(this, "_ZN9S573C2_nt4v110Ev");}
void  S573C2_nt ::v111(){vfunc_called(this, "_ZN9S573C2_nt4v111Ev");}
void  S573C2_nt ::v112(){vfunc_called(this, "_ZN9S573C2_nt4v112Ev");}
void  S573C2_nt ::v113(){vfunc_called(this, "_ZN9S573C2_nt4v113Ev");}
S573C2_nt ::S573C2_nt(){ note_ctor("S573C2_nt", this);} // tgen

//skip512 S573C2_nt

#else // __cplusplus

extern void _ZN9S573C2_ntC1Ev();
extern void _ZN9S573C2_ntD1Ev();
Name_Map name_map_S573C2_nt[] = {
  NSPAIR(_ZN9S573C2_ntC1Ev),
  NSPAIR(_ZN9S573C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S573C5;
extern VTBL_ENTRY _ZTI6S573C5[];
extern  VTBL_ENTRY _ZTV6S573C5[];
extern Class_Descriptor cd_S573C4;
extern VTBL_ENTRY _ZTI6S573C4[];
extern  VTBL_ENTRY _ZTV6S573C4[];
extern Class_Descriptor cd_S573C3;
extern VTBL_ENTRY _ZTI6S573C3[];
extern  VTBL_ENTRY _ZTV6S573C3[];
static Base_Class bases_S573C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S573C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S573C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S573C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S573C2_nt[];
extern void _ZN9S573C2_ntD1Ev();
extern void _ZN9S573C2_ntD0Ev();
extern void _ZN6S573C52v4Ev();
extern void _ZN6S573C52v5Ev();
extern void _ZN6S573C52v6Ev();
extern void _ZN6S573C52v7Ev();
extern void _ZN6S573C52v8Ev();
extern void _ZN6S573C52v9Ev();
extern void _ZN6S573C53v10Ev();
extern void _ZN6S573C53v11Ev();
extern void _ZN6S573C53v12Ev();
extern void _ZN6S573C53v13Ev();
extern void _ZN6S573C53v14Ev();
extern void _ZN6S573C53v15Ev();
extern void _ZN6S573C53v16Ev();
extern void _ZN6S573C53v17Ev();
extern void _ZN6S573C53v18Ev();
extern void _ZN6S573C53v19Ev();
extern void _ZN6S573C53v20Ev();
extern void _ZN6S573C53v21Ev();
extern void _ZN6S573C53v22Ev();
extern void _ZN6S573C53v23Ev();
extern void _ZN6S573C53v24Ev();
extern void _ZN6S573C53v25Ev();
extern void _ZN6S573C53v26Ev();
extern void _ZN6S573C53v27Ev();
extern void _ZN6S573C53v28Ev();
extern void _ZN6S573C53v29Ev();
extern void _ZN6S573C53v30Ev();
extern void _ZN6S573C53v31Ev();
extern void _ZN6S573C53v32Ev();
extern void _ZN6S573C53v33Ev();
extern void _ZN6S573C53v34Ev();
extern void _ZN6S573C53v35Ev();
extern void _ZN6S573C53v36Ev();
extern void _ZN6S573C53v37Ev();
extern void _ZN6S573C53v38Ev();
extern void _ZN6S573C53v39Ev();
extern void _ZN6S573C53v40Ev();
extern void _ZN6S573C53v41Ev();
extern void _ZN6S573C53v42Ev();
extern void _ZN6S573C53v43Ev();
extern void _ZN6S573C53v44Ev();
extern void _ZN6S573C53v45Ev();
extern void _ZN6S573C53v46Ev();
extern void _ZN6S573C53v47Ev();
extern void _ZN6S573C53v48Ev();
extern void _ZN6S573C53v49Ev();
extern void _ZN6S573C53v50Ev();
extern void _ZN6S573C53v51Ev();
extern void _ZN6S573C53v52Ev();
extern void _ZN6S573C53v53Ev();
extern void _ZN6S573C53v54Ev();
extern void _ZN6S573C53v55Ev();
extern void _ZN6S573C53v56Ev();
extern void _ZN6S573C53v57Ev();
extern void _ZN6S573C53v58Ev();
extern void _ZN6S573C53v59Ev();
extern void _ZN6S573C53v60Ev();
extern void _ZN6S573C53v61Ev();
extern void _ZN6S573C53v62Ev();
extern void _ZN6S573C53v63Ev();
extern void _ZN6S573C53v64Ev();
extern void _ZN6S573C53v65Ev();
extern void _ZN6S573C53v66Ev();
extern void _ZN6S573C53v67Ev();
extern void _ZN6S573C43v68Ev();
extern void _ZN6S573C43v69Ev();
extern void _ZN6S573C43v70Ev();
extern void _ZN6S573C43v71Ev();
extern void _ZN6S573C43v72Ev();
extern void _ZN6S573C43v73Ev();
extern void _ZN6S573C43v74Ev();
extern void _ZN6S573C43v75Ev();
extern void _ZN6S573C43v76Ev();
extern void _ZN6S573C43v77Ev();
extern void _ZN6S573C43v78Ev();
extern void _ZN6S573C43v79Ev();
extern void _ZN6S573C43v80Ev();
extern void _ZN6S573C43v81Ev();
extern void _ZN6S573C43v82Ev();
extern void _ZN6S573C43v83Ev();
extern void _ZN6S573C43v84Ev();
extern void _ZN6S573C43v85Ev();
extern void _ZN6S573C43v86Ev();
extern void _ZN6S573C43v87Ev();
extern void _ZN6S573C43v88Ev();
extern void _ZN6S573C43v89Ev();
extern void _ZN6S573C33v90Ev();
extern void _ZN6S573C33v91Ev();
extern void _ZN6S573C33v92Ev();
extern void _ZN6S573C33v93Ev();
extern void _ZN6S573C33v94Ev();
extern void _ZN6S573C33v95Ev();
extern void _ZN6S573C33v96Ev();
extern void _ZN6S573C33v97Ev();
extern void _ZN6S573C33v98Ev();
extern void _ZN6S573C33v99Ev();
extern void _ZN6S573C34v100Ev();
extern void _ZN6S573C34v101Ev();
extern void _ZN6S573C34v102Ev();
extern void _ZN6S573C34v103Ev();
extern void _ZN6S573C34v104Ev();
extern void _ZN6S573C34v105Ev();
extern void _ZN6S573C34v106Ev();
extern void _ZN6S573C34v107Ev();
extern void _ZN6S573C34v108Ev();
extern void _ZN6S573C34v109Ev();
extern void _ZN9S573C2_nt4v110Ev();
extern void _ZN9S573C2_nt4v111Ev();
extern void _ZN9S573C2_nt4v112Ev();
extern void _ZN9S573C2_nt4v113Ev();
static  VTBL_ENTRY vtc_S573C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S573C2_nt[0]),
  (VTBL_ENTRY)&_ZN9S573C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S573C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S573C52v4Ev,
  (VTBL_ENTRY)&_ZN6S573C52v5Ev,
  (VTBL_ENTRY)&_ZN6S573C52v6Ev,
  (VTBL_ENTRY)&_ZN6S573C52v7Ev,
  (VTBL_ENTRY)&_ZN6S573C52v8Ev,
  (VTBL_ENTRY)&_ZN6S573C52v9Ev,
  (VTBL_ENTRY)&_ZN6S573C53v10Ev,
  (VTBL_ENTRY)&_ZN6S573C53v11Ev,
  (VTBL_ENTRY)&_ZN6S573C53v12Ev,
  (VTBL_ENTRY)&_ZN6S573C53v13Ev,
  (VTBL_ENTRY)&_ZN6S573C53v14Ev,
  (VTBL_ENTRY)&_ZN6S573C53v15Ev,
  (VTBL_ENTRY)&_ZN6S573C53v16Ev,
  (VTBL_ENTRY)&_ZN6S573C53v17Ev,
  (VTBL_ENTRY)&_ZN6S573C53v18Ev,
  (VTBL_ENTRY)&_ZN6S573C53v19Ev,
  (VTBL_ENTRY)&_ZN6S573C53v20Ev,
  (VTBL_ENTRY)&_ZN6S573C53v21Ev,
  (VTBL_ENTRY)&_ZN6S573C53v22Ev,
  (VTBL_ENTRY)&_ZN6S573C53v23Ev,
  (VTBL_ENTRY)&_ZN6S573C53v24Ev,
  (VTBL_ENTRY)&_ZN6S573C53v25Ev,
  (VTBL_ENTRY)&_ZN6S573C53v26Ev,
  (VTBL_ENTRY)&_ZN6S573C53v27Ev,
  (VTBL_ENTRY)&_ZN6S573C53v28Ev,
  (VTBL_ENTRY)&_ZN6S573C53v29Ev,
  (VTBL_ENTRY)&_ZN6S573C53v30Ev,
  (VTBL_ENTRY)&_ZN6S573C53v31Ev,
  (VTBL_ENTRY)&_ZN6S573C53v32Ev,
  (VTBL_ENTRY)&_ZN6S573C53v33Ev,
  (VTBL_ENTRY)&_ZN6S573C53v34Ev,
  (VTBL_ENTRY)&_ZN6S573C53v35Ev,
  (VTBL_ENTRY)&_ZN6S573C53v36Ev,
  (VTBL_ENTRY)&_ZN6S573C53v37Ev,
  (VTBL_ENTRY)&_ZN6S573C53v38Ev,
  (VTBL_ENTRY)&_ZN6S573C53v39Ev,
  (VTBL_ENTRY)&_ZN6S573C53v40Ev,
  (VTBL_ENTRY)&_ZN6S573C53v41Ev,
  (VTBL_ENTRY)&_ZN6S573C53v42Ev,
  (VTBL_ENTRY)&_ZN6S573C53v43Ev,
  (VTBL_ENTRY)&_ZN6S573C53v44Ev,
  (VTBL_ENTRY)&_ZN6S573C53v45Ev,
  (VTBL_ENTRY)&_ZN6S573C53v46Ev,
  (VTBL_ENTRY)&_ZN6S573C53v47Ev,
  (VTBL_ENTRY)&_ZN6S573C53v48Ev,
  (VTBL_ENTRY)&_ZN6S573C53v49Ev,
  (VTBL_ENTRY)&_ZN6S573C53v50Ev,
  (VTBL_ENTRY)&_ZN6S573C53v51Ev,
  (VTBL_ENTRY)&_ZN6S573C53v52Ev,
  (VTBL_ENTRY)&_ZN6S573C53v53Ev,
  (VTBL_ENTRY)&_ZN6S573C53v54Ev,
  (VTBL_ENTRY)&_ZN6S573C53v55Ev,
  (VTBL_ENTRY)&_ZN6S573C53v56Ev,
  (VTBL_ENTRY)&_ZN6S573C53v57Ev,
  (VTBL_ENTRY)&_ZN6S573C53v58Ev,
  (VTBL_ENTRY)&_ZN6S573C53v59Ev,
  (VTBL_ENTRY)&_ZN6S573C53v60Ev,
  (VTBL_ENTRY)&_ZN6S573C53v61Ev,
  (VTBL_ENTRY)&_ZN6S573C53v62Ev,
  (VTBL_ENTRY)&_ZN6S573C53v63Ev,
  (VTBL_ENTRY)&_ZN6S573C53v64Ev,
  (VTBL_ENTRY)&_ZN6S573C53v65Ev,
  (VTBL_ENTRY)&_ZN6S573C53v66Ev,
  (VTBL_ENTRY)&_ZN6S573C53v67Ev,
  (VTBL_ENTRY)&_ZN6S573C43v68Ev,
  (VTBL_ENTRY)&_ZN6S573C43v69Ev,
  (VTBL_ENTRY)&_ZN6S573C43v70Ev,
  (VTBL_ENTRY)&_ZN6S573C43v71Ev,
  (VTBL_ENTRY)&_ZN6S573C43v72Ev,
  (VTBL_ENTRY)&_ZN6S573C43v73Ev,
  (VTBL_ENTRY)&_ZN6S573C43v74Ev,
  (VTBL_ENTRY)&_ZN6S573C43v75Ev,
  (VTBL_ENTRY)&_ZN6S573C43v76Ev,
  (VTBL_ENTRY)&_ZN6S573C43v77Ev,
  (VTBL_ENTRY)&_ZN6S573C43v78Ev,
  (VTBL_ENTRY)&_ZN6S573C43v79Ev,
  (VTBL_ENTRY)&_ZN6S573C43v80Ev,
  (VTBL_ENTRY)&_ZN6S573C43v81Ev,
  (VTBL_ENTRY)&_ZN6S573C43v82Ev,
  (VTBL_ENTRY)&_ZN6S573C43v83Ev,
  (VTBL_ENTRY)&_ZN6S573C43v84Ev,
  (VTBL_ENTRY)&_ZN6S573C43v85Ev,
  (VTBL_ENTRY)&_ZN6S573C43v86Ev,
  (VTBL_ENTRY)&_ZN6S573C43v87Ev,
  (VTBL_ENTRY)&_ZN6S573C43v88Ev,
  (VTBL_ENTRY)&_ZN6S573C43v89Ev,
  (VTBL_ENTRY)&_ZN6S573C33v90Ev,
  (VTBL_ENTRY)&_ZN6S573C33v91Ev,
  (VTBL_ENTRY)&_ZN6S573C33v92Ev,
  (VTBL_ENTRY)&_ZN6S573C33v93Ev,
  (VTBL_ENTRY)&_ZN6S573C33v94Ev,
  (VTBL_ENTRY)&_ZN6S573C33v95Ev,
  (VTBL_ENTRY)&_ZN6S573C33v96Ev,
  (VTBL_ENTRY)&_ZN6S573C33v97Ev,
  (VTBL_ENTRY)&_ZN6S573C33v98Ev,
  (VTBL_ENTRY)&_ZN6S573C33v99Ev,
  (VTBL_ENTRY)&_ZN6S573C34v100Ev,
  (VTBL_ENTRY)&_ZN6S573C34v101Ev,
  (VTBL_ENTRY)&_ZN6S573C34v102Ev,
  (VTBL_ENTRY)&_ZN6S573C34v103Ev,
  (VTBL_ENTRY)&_ZN6S573C34v104Ev,
  (VTBL_ENTRY)&_ZN6S573C34v105Ev,
  (VTBL_ENTRY)&_ZN6S573C34v106Ev,
  (VTBL_ENTRY)&_ZN6S573C34v107Ev,
  (VTBL_ENTRY)&_ZN6S573C34v108Ev,
  (VTBL_ENTRY)&_ZN6S573C34v109Ev,
  (VTBL_ENTRY)&_ZN9S573C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S573C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S573C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S573C2_nt4v113Ev,
};
extern VTBL_ENTRY _ZTI9S573C2_nt[];
VTBL_ENTRY *P__ZTI9S573C2_nt = _ZTI9S573C2_nt; 
extern  VTBL_ENTRY _ZTV9S573C2_nt[];
Class_Descriptor cd_S573C2_nt = {  "S573C2_nt", // class name
  bases_S573C2_nt, 3,
  &(vtc_S573C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,220), // object size
  NSPAIRA(_ZTI9S573C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S573C2_nt),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S573C1  : S573C2_nt {
  ::S674C37_nt s573c1f0;
  int s573c1f1;
  unsigned int s573c1f2:1;
  void *s573c1f3;
  unsigned int s573c1f4:1;
  int s573c1f5;
  virtual  ~S573C1(); // _ZN6S573C1D1Ev
  virtual void  v1(); // _ZN6S573C12v1Ev
  virtual void  v2(); // _ZN6S573C12v2Ev
  virtual void  v3(); // _ZN6S573C12v3Ev
  S573C1(); // tgen
};
//SIG(1 S573C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC8 FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} Fi[3]} vd v110 v111 v112 v113 FC6 Fi:1 FC18{ BC19{ BC10}}} vd v1 v2 v3 FC7 Fi Fi:1 Fp Fi:1 Fi}


 S573C1 ::~S573C1(){ note_dtor("S573C1", this);}
void  S573C1 ::v1(){vfunc_called(this, "_ZN6S573C12v1Ev");}
void  S573C1 ::v2(){vfunc_called(this, "_ZN6S573C12v2Ev");}
void  S573C1 ::v3(){vfunc_called(this, "_ZN6S573C12v3Ev");}
S573C1 ::S573C1(){ note_ctor("S573C1", this);} // tgen

static void Test_S573C1()
{
  extern Class_Descriptor cd_S573C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(43,64)];
    init_test(&cd_S573C1, buf);
    S573C1 *dp, &lv = *(dp=new (buf) S573C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(336,252), "sizeof(S573C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S573C1)");
    check_base_class_offset(lv, (S573C5*)(S573C4*)(S573C3*)(S573C2_nt*), 0, "S573C1");
    check_base_class_offset(lv, (S573C4*)(S573C3*)(S573C2_nt*), 0, "S573C1");
    check_base_class_offset(lv, (S573C3*)(S573C2_nt*), 0, "S573C1");
    check_base_class_offset(lv, (S573C2_nt*), 0, "S573C1");
    check_field_offset(lv, s573c1f0, ABISELECT(296,220), "S573C1.s573c1f0");
    check_field_offset(lv, s573c1f1, ABISELECT(312,232), "S573C1.s573c1f1");
    set_bf_and_test(lv, s573c1f2, ABISELECT(316,236), 0, 1, 1, "S573C1");
    check_field_offset(lv, s573c1f3, ABISELECT(320,240), "S573C1.s573c1f3");
    set_bf_and_test(lv, s573c1f4, ABISELECT(328,244), 0, 1, 1, "S573C1");
    check_field_offset(lv, s573c1f5, ABISELECT(332,248), "S573C1.s573c1f5");
    test_class_info(&lv, &cd_S573C1);
    dp->~S573C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS573C1(Test_S573C1, "S573C1", ABISELECT(336,252));

#else // __cplusplus

extern void _ZN6S573C1C1Ev();
extern void _ZN6S573C1D1Ev();
Name_Map name_map_S573C1[] = {
  NSPAIR(_ZN6S573C1C1Ev),
  NSPAIR(_ZN6S573C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S573C5;
extern VTBL_ENTRY _ZTI6S573C5[];
extern  VTBL_ENTRY _ZTV6S573C5[];
extern Class_Descriptor cd_S573C4;
extern VTBL_ENTRY _ZTI6S573C4[];
extern  VTBL_ENTRY _ZTV6S573C4[];
extern Class_Descriptor cd_S573C3;
extern VTBL_ENTRY _ZTI6S573C3[];
extern  VTBL_ENTRY _ZTV6S573C3[];
extern Class_Descriptor cd_S573C2_nt;
extern VTBL_ENTRY _ZTI9S573C2_nt[];
extern  VTBL_ENTRY _ZTV9S573C2_nt[];
static Base_Class bases_S573C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S573C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S573C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S573C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S573C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S573C1[];
extern void _ZN6S573C1D1Ev();
extern void _ZN6S573C1D0Ev();
extern void _ZN6S573C52v4Ev();
extern void _ZN6S573C52v5Ev();
extern void _ZN6S573C52v6Ev();
extern void _ZN6S573C52v7Ev();
extern void _ZN6S573C52v8Ev();
extern void _ZN6S573C52v9Ev();
extern void _ZN6S573C53v10Ev();
extern void _ZN6S573C53v11Ev();
extern void _ZN6S573C53v12Ev();
extern void _ZN6S573C53v13Ev();
extern void _ZN6S573C53v14Ev();
extern void _ZN6S573C53v15Ev();
extern void _ZN6S573C53v16Ev();
extern void _ZN6S573C53v17Ev();
extern void _ZN6S573C53v18Ev();
extern void _ZN6S573C53v19Ev();
extern void _ZN6S573C53v20Ev();
extern void _ZN6S573C53v21Ev();
extern void _ZN6S573C53v22Ev();
extern void _ZN6S573C53v23Ev();
extern void _ZN6S573C53v24Ev();
extern void _ZN6S573C53v25Ev();
extern void _ZN6S573C53v26Ev();
extern void _ZN6S573C53v27Ev();
extern void _ZN6S573C53v28Ev();
extern void _ZN6S573C53v29Ev();
extern void _ZN6S573C53v30Ev();
extern void _ZN6S573C53v31Ev();
extern void _ZN6S573C53v32Ev();
extern void _ZN6S573C53v33Ev();
extern void _ZN6S573C53v34Ev();
extern void _ZN6S573C53v35Ev();
extern void _ZN6S573C53v36Ev();
extern void _ZN6S573C53v37Ev();
extern void _ZN6S573C53v38Ev();
extern void _ZN6S573C53v39Ev();
extern void _ZN6S573C53v40Ev();
extern void _ZN6S573C53v41Ev();
extern void _ZN6S573C53v42Ev();
extern void _ZN6S573C53v43Ev();
extern void _ZN6S573C53v44Ev();
extern void _ZN6S573C53v45Ev();
extern void _ZN6S573C53v46Ev();
extern void _ZN6S573C53v47Ev();
extern void _ZN6S573C53v48Ev();
extern void _ZN6S573C53v49Ev();
extern void _ZN6S573C53v50Ev();
extern void _ZN6S573C53v51Ev();
extern void _ZN6S573C53v52Ev();
extern void _ZN6S573C53v53Ev();
extern void _ZN6S573C53v54Ev();
extern void _ZN6S573C53v55Ev();
extern void _ZN6S573C53v56Ev();
extern void _ZN6S573C53v57Ev();
extern void _ZN6S573C53v58Ev();
extern void _ZN6S573C53v59Ev();
extern void _ZN6S573C53v60Ev();
extern void _ZN6S573C53v61Ev();
extern void _ZN6S573C53v62Ev();
extern void _ZN6S573C53v63Ev();
extern void _ZN6S573C53v64Ev();
extern void _ZN6S573C53v65Ev();
extern void _ZN6S573C53v66Ev();
extern void _ZN6S573C53v67Ev();
extern void _ZN6S573C43v68Ev();
extern void _ZN6S573C43v69Ev();
extern void _ZN6S573C43v70Ev();
extern void _ZN6S573C43v71Ev();
extern void _ZN6S573C43v72Ev();
extern void _ZN6S573C43v73Ev();
extern void _ZN6S573C43v74Ev();
extern void _ZN6S573C43v75Ev();
extern void _ZN6S573C43v76Ev();
extern void _ZN6S573C43v77Ev();
extern void _ZN6S573C43v78Ev();
extern void _ZN6S573C43v79Ev();
extern void _ZN6S573C43v80Ev();
extern void _ZN6S573C43v81Ev();
extern void _ZN6S573C43v82Ev();
extern void _ZN6S573C43v83Ev();
extern void _ZN6S573C43v84Ev();
extern void _ZN6S573C43v85Ev();
extern void _ZN6S573C43v86Ev();
extern void _ZN6S573C43v87Ev();
extern void _ZN6S573C43v88Ev();
extern void _ZN6S573C43v89Ev();
extern void _ZN6S573C33v90Ev();
extern void _ZN6S573C33v91Ev();
extern void _ZN6S573C33v92Ev();
extern void _ZN6S573C33v93Ev();
extern void _ZN6S573C33v94Ev();
extern void _ZN6S573C33v95Ev();
extern void _ZN6S573C33v96Ev();
extern void _ZN6S573C33v97Ev();
extern void _ZN6S573C33v98Ev();
extern void _ZN6S573C33v99Ev();
extern void _ZN6S573C34v100Ev();
extern void _ZN6S573C34v101Ev();
extern void _ZN6S573C34v102Ev();
extern void _ZN6S573C34v103Ev();
extern void _ZN6S573C34v104Ev();
extern void _ZN6S573C34v105Ev();
extern void _ZN6S573C34v106Ev();
extern void _ZN6S573C34v107Ev();
extern void _ZN6S573C34v108Ev();
extern void _ZN6S573C34v109Ev();
extern void _ZN9S573C2_nt4v110Ev();
extern void _ZN9S573C2_nt4v111Ev();
extern void _ZN9S573C2_nt4v112Ev();
extern void _ZN9S573C2_nt4v113Ev();
extern void _ZN6S573C12v1Ev();
extern void _ZN6S573C12v2Ev();
extern void _ZN6S573C12v3Ev();
static  VTBL_ENTRY vtc_S573C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S573C1[0]),
  (VTBL_ENTRY)&_ZN6S573C1D1Ev,
  (VTBL_ENTRY)&_ZN6S573C1D0Ev,
  (VTBL_ENTRY)&_ZN6S573C52v4Ev,
  (VTBL_ENTRY)&_ZN6S573C52v5Ev,
  (VTBL_ENTRY)&_ZN6S573C52v6Ev,
  (VTBL_ENTRY)&_ZN6S573C52v7Ev,
  (VTBL_ENTRY)&_ZN6S573C52v8Ev,
  (VTBL_ENTRY)&_ZN6S573C52v9Ev,
  (VTBL_ENTRY)&_ZN6S573C53v10Ev,
  (VTBL_ENTRY)&_ZN6S573C53v11Ev,
  (VTBL_ENTRY)&_ZN6S573C53v12Ev,
  (VTBL_ENTRY)&_ZN6S573C53v13Ev,
  (VTBL_ENTRY)&_ZN6S573C53v14Ev,
  (VTBL_ENTRY)&_ZN6S573C53v15Ev,
  (VTBL_ENTRY)&_ZN6S573C53v16Ev,
  (VTBL_ENTRY)&_ZN6S573C53v17Ev,
  (VTBL_ENTRY)&_ZN6S573C53v18Ev,
  (VTBL_ENTRY)&_ZN6S573C53v19Ev,
  (VTBL_ENTRY)&_ZN6S573C53v20Ev,
  (VTBL_ENTRY)&_ZN6S573C53v21Ev,
  (VTBL_ENTRY)&_ZN6S573C53v22Ev,
  (VTBL_ENTRY)&_ZN6S573C53v23Ev,
  (VTBL_ENTRY)&_ZN6S573C53v24Ev,
  (VTBL_ENTRY)&_ZN6S573C53v25Ev,
  (VTBL_ENTRY)&_ZN6S573C53v26Ev,
  (VTBL_ENTRY)&_ZN6S573C53v27Ev,
  (VTBL_ENTRY)&_ZN6S573C53v28Ev,
  (VTBL_ENTRY)&_ZN6S573C53v29Ev,
  (VTBL_ENTRY)&_ZN6S573C53v30Ev,
  (VTBL_ENTRY)&_ZN6S573C53v31Ev,
  (VTBL_ENTRY)&_ZN6S573C53v32Ev,
  (VTBL_ENTRY)&_ZN6S573C53v33Ev,
  (VTBL_ENTRY)&_ZN6S573C53v34Ev,
  (VTBL_ENTRY)&_ZN6S573C53v35Ev,
  (VTBL_ENTRY)&_ZN6S573C53v36Ev,
  (VTBL_ENTRY)&_ZN6S573C53v37Ev,
  (VTBL_ENTRY)&_ZN6S573C53v38Ev,
  (VTBL_ENTRY)&_ZN6S573C53v39Ev,
  (VTBL_ENTRY)&_ZN6S573C53v40Ev,
  (VTBL_ENTRY)&_ZN6S573C53v41Ev,
  (VTBL_ENTRY)&_ZN6S573C53v42Ev,
  (VTBL_ENTRY)&_ZN6S573C53v43Ev,
  (VTBL_ENTRY)&_ZN6S573C53v44Ev,
  (VTBL_ENTRY)&_ZN6S573C53v45Ev,
  (VTBL_ENTRY)&_ZN6S573C53v46Ev,
  (VTBL_ENTRY)&_ZN6S573C53v47Ev,
  (VTBL_ENTRY)&_ZN6S573C53v48Ev,
  (VTBL_ENTRY)&_ZN6S573C53v49Ev,
  (VTBL_ENTRY)&_ZN6S573C53v50Ev,
  (VTBL_ENTRY)&_ZN6S573C53v51Ev,
  (VTBL_ENTRY)&_ZN6S573C53v52Ev,
  (VTBL_ENTRY)&_ZN6S573C53v53Ev,
  (VTBL_ENTRY)&_ZN6S573C53v54Ev,
  (VTBL_ENTRY)&_ZN6S573C53v55Ev,
  (VTBL_ENTRY)&_ZN6S573C53v56Ev,
  (VTBL_ENTRY)&_ZN6S573C53v57Ev,
  (VTBL_ENTRY)&_ZN6S573C53v58Ev,
  (VTBL_ENTRY)&_ZN6S573C53v59Ev,
  (VTBL_ENTRY)&_ZN6S573C53v60Ev,
  (VTBL_ENTRY)&_ZN6S573C53v61Ev,
  (VTBL_ENTRY)&_ZN6S573C53v62Ev,
  (VTBL_ENTRY)&_ZN6S573C53v63Ev,
  (VTBL_ENTRY)&_ZN6S573C53v64Ev,
  (VTBL_ENTRY)&_ZN6S573C53v65Ev,
  (VTBL_ENTRY)&_ZN6S573C53v66Ev,
  (VTBL_ENTRY)&_ZN6S573C53v67Ev,
  (VTBL_ENTRY)&_ZN6S573C43v68Ev,
  (VTBL_ENTRY)&_ZN6S573C43v69Ev,
  (VTBL_ENTRY)&_ZN6S573C43v70Ev,
  (VTBL_ENTRY)&_ZN6S573C43v71Ev,
  (VTBL_ENTRY)&_ZN6S573C43v72Ev,
  (VTBL_ENTRY)&_ZN6S573C43v73Ev,
  (VTBL_ENTRY)&_ZN6S573C43v74Ev,
  (VTBL_ENTRY)&_ZN6S573C43v75Ev,
  (VTBL_ENTRY)&_ZN6S573C43v76Ev,
  (VTBL_ENTRY)&_ZN6S573C43v77Ev,
  (VTBL_ENTRY)&_ZN6S573C43v78Ev,
  (VTBL_ENTRY)&_ZN6S573C43v79Ev,
  (VTBL_ENTRY)&_ZN6S573C43v80Ev,
  (VTBL_ENTRY)&_ZN6S573C43v81Ev,
  (VTBL_ENTRY)&_ZN6S573C43v82Ev,
  (VTBL_ENTRY)&_ZN6S573C43v83Ev,
  (VTBL_ENTRY)&_ZN6S573C43v84Ev,
  (VTBL_ENTRY)&_ZN6S573C43v85Ev,
  (VTBL_ENTRY)&_ZN6S573C43v86Ev,
  (VTBL_ENTRY)&_ZN6S573C43v87Ev,
  (VTBL_ENTRY)&_ZN6S573C43v88Ev,
  (VTBL_ENTRY)&_ZN6S573C43v89Ev,
  (VTBL_ENTRY)&_ZN6S573C33v90Ev,
  (VTBL_ENTRY)&_ZN6S573C33v91Ev,
  (VTBL_ENTRY)&_ZN6S573C33v92Ev,
  (VTBL_ENTRY)&_ZN6S573C33v93Ev,
  (VTBL_ENTRY)&_ZN6S573C33v94Ev,
  (VTBL_ENTRY)&_ZN6S573C33v95Ev,
  (VTBL_ENTRY)&_ZN6S573C33v96Ev,
  (VTBL_ENTRY)&_ZN6S573C33v97Ev,
  (VTBL_ENTRY)&_ZN6S573C33v98Ev,
  (VTBL_ENTRY)&_ZN6S573C33v99Ev,
  (VTBL_ENTRY)&_ZN6S573C34v100Ev,
  (VTBL_ENTRY)&_ZN6S573C34v101Ev,
  (VTBL_ENTRY)&_ZN6S573C34v102Ev,
  (VTBL_ENTRY)&_ZN6S573C34v103Ev,
  (VTBL_ENTRY)&_ZN6S573C34v104Ev,
  (VTBL_ENTRY)&_ZN6S573C34v105Ev,
  (VTBL_ENTRY)&_ZN6S573C34v106Ev,
  (VTBL_ENTRY)&_ZN6S573C34v107Ev,
  (VTBL_ENTRY)&_ZN6S573C34v108Ev,
  (VTBL_ENTRY)&_ZN6S573C34v109Ev,
  (VTBL_ENTRY)&_ZN9S573C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S573C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S573C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S573C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN6S573C12v1Ev,
  (VTBL_ENTRY)&_ZN6S573C12v2Ev,
  (VTBL_ENTRY)&_ZN6S573C12v3Ev,
};
extern VTBL_ENTRY _ZTI6S573C1[];
extern  VTBL_ENTRY _ZTV6S573C1[];
Class_Descriptor cd_S573C1 = {  "S573C1", // class name
  bases_S573C1, 4,
  &(vtc_S573C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(336,252), // object size
  NSPAIRA(_ZTI6S573C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S573C1),117, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S693C5  {
  int s693c5f0;
  __tsi64 s693c5f1;
  void *s693c5f2[4];
  int s693c5f3[2];
  void *s693c5f4;
  ::S674C6_nt s693c5f5;
  void *s693c5f6[2];
  virtual  ~S693C5(); // _ZN6S693C5D1Ev
  virtual void  v7(); // _ZN6S693C52v7Ev
  virtual void  v8(); // _ZN6S693C52v8Ev
  virtual void  v9(); // _ZN6S693C52v9Ev
  virtual void  v10(); // _ZN6S693C53v10Ev
  virtual void  v11(); // _ZN6S693C53v11Ev
  virtual void  v12(); // _ZN6S693C53v12Ev
  virtual void  v13(); // _ZN6S693C53v13Ev
  virtual void  v14(); // _ZN6S693C53v14Ev
  virtual void  v15(); // _ZN6S693C53v15Ev
  virtual void  v16(); // _ZN6S693C53v16Ev
  virtual void  v17(); // _ZN6S693C53v17Ev
  virtual void  v18(); // _ZN6S693C53v18Ev
  virtual void  v19(); // _ZN6S693C53v19Ev
  virtual void  v20(); // _ZN6S693C53v20Ev
  virtual void  v21(); // _ZN6S693C53v21Ev
  virtual void  v22(); // _ZN6S693C53v22Ev
  virtual void  v23(); // _ZN6S693C53v23Ev
  virtual void  v24(); // _ZN6S693C53v24Ev
  virtual void  v25(); // _ZN6S693C53v25Ev
  virtual void  v26(); // _ZN6S693C53v26Ev
  virtual void  v27(); // _ZN6S693C53v27Ev
  virtual void  v28(); // _ZN6S693C53v28Ev
  virtual void  v29(); // _ZN6S693C53v29Ev
  virtual void  v30(); // _ZN6S693C53v30Ev
  virtual void  v31(); // _ZN6S693C53v31Ev
  virtual void  v32(); // _ZN6S693C53v32Ev
  virtual void  v33(); // _ZN6S693C53v33Ev
  virtual void  v34(); // _ZN6S693C53v34Ev
  virtual void  v35(); // _ZN6S693C53v35Ev
  virtual void  v36(); // _ZN6S693C53v36Ev
  virtual void  v37(); // _ZN6S693C53v37Ev
  virtual void  v38(); // _ZN6S693C53v38Ev
  virtual void  v39(); // _ZN6S693C53v39Ev
  virtual void  v40(); // _ZN6S693C53v40Ev
  virtual void  v41(); // _ZN6S693C53v41Ev
  virtual void  v42(); // _ZN6S693C53v42Ev
  virtual void  v43(); // _ZN6S693C53v43Ev
  virtual void  v44(); // _ZN6S693C53v44Ev
  virtual void  v45(); // _ZN6S693C53v45Ev
  virtual void  v46(); // _ZN6S693C53v46Ev
  virtual void  v47(); // _ZN6S693C53v47Ev
  virtual void  v48(); // _ZN6S693C53v48Ev
  virtual void  v49(); // _ZN6S693C53v49Ev
  virtual void  v50(); // _ZN6S693C53v50Ev
  virtual void  v51(); // _ZN6S693C53v51Ev
  virtual void  v52(); // _ZN6S693C53v52Ev
  virtual void  v53(); // _ZN6S693C53v53Ev
  virtual void  v54(); // _ZN6S693C53v54Ev
  virtual void  v55(); // _ZN6S693C53v55Ev
  virtual void  v56(); // _ZN6S693C53v56Ev
  virtual void  v57(); // _ZN6S693C53v57Ev
  virtual void  v58(); // _ZN6S693C53v58Ev
  virtual void  v59(); // _ZN6S693C53v59Ev
  virtual void  v60(); // _ZN6S693C53v60Ev
  virtual void  v61(); // _ZN6S693C53v61Ev
  virtual void  v62(); // _ZN6S693C53v62Ev
  virtual void  v63(); // _ZN6S693C53v63Ev
  virtual void  v64(); // _ZN6S693C53v64Ev
  virtual void  v65(); // _ZN6S693C53v65Ev
  virtual void  v66(); // _ZN6S693C53v66Ev
  virtual void  v67(); // _ZN6S693C53v67Ev
  virtual void  v68(); // _ZN6S693C53v68Ev
  virtual void  v69(); // _ZN6S693C53v69Ev
  virtual void  v70(); // _ZN6S693C53v70Ev
  S693C5(); // tgen
};
//SIG(-1 S693C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S693C5 ::~S693C5(){ note_dtor("S693C5", this);}
void  S693C5 ::v7(){vfunc_called(this, "_ZN6S693C52v7Ev");}
void  S693C5 ::v8(){vfunc_called(this, "_ZN6S693C52v8Ev");}
void  S693C5 ::v9(){vfunc_called(this, "_ZN6S693C52v9Ev");}
void  S693C5 ::v10(){vfunc_called(this, "_ZN6S693C53v10Ev");}
void  S693C5 ::v11(){vfunc_called(this, "_ZN6S693C53v11Ev");}
void  S693C5 ::v12(){vfunc_called(this, "_ZN6S693C53v12Ev");}
void  S693C5 ::v13(){vfunc_called(this, "_ZN6S693C53v13Ev");}
void  S693C5 ::v14(){vfunc_called(this, "_ZN6S693C53v14Ev");}
void  S693C5 ::v15(){vfunc_called(this, "_ZN6S693C53v15Ev");}
void  S693C5 ::v16(){vfunc_called(this, "_ZN6S693C53v16Ev");}
void  S693C5 ::v17(){vfunc_called(this, "_ZN6S693C53v17Ev");}
void  S693C5 ::v18(){vfunc_called(this, "_ZN6S693C53v18Ev");}
void  S693C5 ::v19(){vfunc_called(this, "_ZN6S693C53v19Ev");}
void  S693C5 ::v20(){vfunc_called(this, "_ZN6S693C53v20Ev");}
void  S693C5 ::v21(){vfunc_called(this, "_ZN6S693C53v21Ev");}
void  S693C5 ::v22(){vfunc_called(this, "_ZN6S693C53v22Ev");}
void  S693C5 ::v23(){vfunc_called(this, "_ZN6S693C53v23Ev");}
void  S693C5 ::v24(){vfunc_called(this, "_ZN6S693C53v24Ev");}
void  S693C5 ::v25(){vfunc_called(this, "_ZN6S693C53v25Ev");}
void  S693C5 ::v26(){vfunc_called(this, "_ZN6S693C53v26Ev");}
void  S693C5 ::v27(){vfunc_called(this, "_ZN6S693C53v27Ev");}
void  S693C5 ::v28(){vfunc_called(this, "_ZN6S693C53v28Ev");}
void  S693C5 ::v29(){vfunc_called(this, "_ZN6S693C53v29Ev");}
void  S693C5 ::v30(){vfunc_called(this, "_ZN6S693C53v30Ev");}
void  S693C5 ::v31(){vfunc_called(this, "_ZN6S693C53v31Ev");}
void  S693C5 ::v32(){vfunc_called(this, "_ZN6S693C53v32Ev");}
void  S693C5 ::v33(){vfunc_called(this, "_ZN6S693C53v33Ev");}
void  S693C5 ::v34(){vfunc_called(this, "_ZN6S693C53v34Ev");}
void  S693C5 ::v35(){vfunc_called(this, "_ZN6S693C53v35Ev");}
void  S693C5 ::v36(){vfunc_called(this, "_ZN6S693C53v36Ev");}
void  S693C5 ::v37(){vfunc_called(this, "_ZN6S693C53v37Ev");}
void  S693C5 ::v38(){vfunc_called(this, "_ZN6S693C53v38Ev");}
void  S693C5 ::v39(){vfunc_called(this, "_ZN6S693C53v39Ev");}
void  S693C5 ::v40(){vfunc_called(this, "_ZN6S693C53v40Ev");}
void  S693C5 ::v41(){vfunc_called(this, "_ZN6S693C53v41Ev");}
void  S693C5 ::v42(){vfunc_called(this, "_ZN6S693C53v42Ev");}
void  S693C5 ::v43(){vfunc_called(this, "_ZN6S693C53v43Ev");}
void  S693C5 ::v44(){vfunc_called(this, "_ZN6S693C53v44Ev");}
void  S693C5 ::v45(){vfunc_called(this, "_ZN6S693C53v45Ev");}
void  S693C5 ::v46(){vfunc_called(this, "_ZN6S693C53v46Ev");}
void  S693C5 ::v47(){vfunc_called(this, "_ZN6S693C53v47Ev");}
void  S693C5 ::v48(){vfunc_called(this, "_ZN6S693C53v48Ev");}
void  S693C5 ::v49(){vfunc_called(this, "_ZN6S693C53v49Ev");}
void  S693C5 ::v50(){vfunc_called(this, "_ZN6S693C53v50Ev");}
void  S693C5 ::v51(){vfunc_called(this, "_ZN6S693C53v51Ev");}
void  S693C5 ::v52(){vfunc_called(this, "_ZN6S693C53v52Ev");}
void  S693C5 ::v53(){vfunc_called(this, "_ZN6S693C53v53Ev");}
void  S693C5 ::v54(){vfunc_called(this, "_ZN6S693C53v54Ev");}
void  S693C5 ::v55(){vfunc_called(this, "_ZN6S693C53v55Ev");}
void  S693C5 ::v56(){vfunc_called(this, "_ZN6S693C53v56Ev");}
void  S693C5 ::v57(){vfunc_called(this, "_ZN6S693C53v57Ev");}
void  S693C5 ::v58(){vfunc_called(this, "_ZN6S693C53v58Ev");}
void  S693C5 ::v59(){vfunc_called(this, "_ZN6S693C53v59Ev");}
void  S693C5 ::v60(){vfunc_called(this, "_ZN6S693C53v60Ev");}
void  S693C5 ::v61(){vfunc_called(this, "_ZN6S693C53v61Ev");}
void  S693C5 ::v62(){vfunc_called(this, "_ZN6S693C53v62Ev");}
void  S693C5 ::v63(){vfunc_called(this, "_ZN6S693C53v63Ev");}
void  S693C5 ::v64(){vfunc_called(this, "_ZN6S693C53v64Ev");}
void  S693C5 ::v65(){vfunc_called(this, "_ZN6S693C53v65Ev");}
void  S693C5 ::v66(){vfunc_called(this, "_ZN6S693C53v66Ev");}
void  S693C5 ::v67(){vfunc_called(this, "_ZN6S693C53v67Ev");}
void  S693C5 ::v68(){vfunc_called(this, "_ZN6S693C53v68Ev");}
void  S693C5 ::v69(){vfunc_called(this, "_ZN6S693C53v69Ev");}
void  S693C5 ::v70(){vfunc_called(this, "_ZN6S693C53v70Ev");}
S693C5 ::S693C5(){ note_ctor("S693C5", this);} // tgen

static void Test_S693C5()
{
  extern Class_Descriptor cd_S693C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S693C5, buf);
    S693C5 *dp, &lv = *(dp=new (buf) S693C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S693C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S693C5)");
    check_field_offset(lv, s693c5f0, ABISELECT(8,4), "S693C5.s693c5f0");
    check_field_offset(lv, s693c5f1, ABISELECT(16,8), "S693C5.s693c5f1");
    check_field_offset(lv, s693c5f2, ABISELECT(24,16), "S693C5.s693c5f2");
    check_field_offset(lv, s693c5f3, ABISELECT(56,32), "S693C5.s693c5f3");
    check_field_offset(lv, s693c5f4, ABISELECT(64,40), "S693C5.s693c5f4");
    check_field_offset(lv, s693c5f5, ABISELECT(72,44), "S693C5.s693c5f5");
    check_field_offset(lv, s693c5f6, ABISELECT(80,52), "S693C5.s693c5f6");
    test_class_info(&lv, &cd_S693C5);
    dp->~S693C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS693C5(Test_S693C5, "S693C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S693C5C1Ev();
extern void _ZN6S693C5D1Ev();
Name_Map name_map_S693C5[] = {
  NSPAIR(_ZN6S693C5C1Ev),
  NSPAIR(_ZN6S693C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S693C5[];
extern void _ZN6S693C5D1Ev();
extern void _ZN6S693C5D0Ev();
extern void _ZN6S693C52v7Ev();
extern void _ZN6S693C52v8Ev();
extern void _ZN6S693C52v9Ev();
extern void _ZN6S693C53v10Ev();
extern void _ZN6S693C53v11Ev();
extern void _ZN6S693C53v12Ev();
extern void _ZN6S693C53v13Ev();
extern void _ZN6S693C53v14Ev();
extern void _ZN6S693C53v15Ev();
extern void _ZN6S693C53v16Ev();
extern void _ZN6S693C53v17Ev();
extern void _ZN6S693C53v18Ev();
extern void _ZN6S693C53v19Ev();
extern void _ZN6S693C53v20Ev();
extern void _ZN6S693C53v21Ev();
extern void _ZN6S693C53v22Ev();
extern void _ZN6S693C53v23Ev();
extern void _ZN6S693C53v24Ev();
extern void _ZN6S693C53v25Ev();
extern void _ZN6S693C53v26Ev();
extern void _ZN6S693C53v27Ev();
extern void _ZN6S693C53v28Ev();
extern void _ZN6S693C53v29Ev();
extern void _ZN6S693C53v30Ev();
extern void _ZN6S693C53v31Ev();
extern void _ZN6S693C53v32Ev();
extern void _ZN6S693C53v33Ev();
extern void _ZN6S693C53v34Ev();
extern void _ZN6S693C53v35Ev();
extern void _ZN6S693C53v36Ev();
extern void _ZN6S693C53v37Ev();
extern void _ZN6S693C53v38Ev();
extern void _ZN6S693C53v39Ev();
extern void _ZN6S693C53v40Ev();
extern void _ZN6S693C53v41Ev();
extern void _ZN6S693C53v42Ev();
extern void _ZN6S693C53v43Ev();
extern void _ZN6S693C53v44Ev();
extern void _ZN6S693C53v45Ev();
extern void _ZN6S693C53v46Ev();
extern void _ZN6S693C53v47Ev();
extern void _ZN6S693C53v48Ev();
extern void _ZN6S693C53v49Ev();
extern void _ZN6S693C53v50Ev();
extern void _ZN6S693C53v51Ev();
extern void _ZN6S693C53v52Ev();
extern void _ZN6S693C53v53Ev();
extern void _ZN6S693C53v54Ev();
extern void _ZN6S693C53v55Ev();
extern void _ZN6S693C53v56Ev();
extern void _ZN6S693C53v57Ev();
extern void _ZN6S693C53v58Ev();
extern void _ZN6S693C53v59Ev();
extern void _ZN6S693C53v60Ev();
extern void _ZN6S693C53v61Ev();
extern void _ZN6S693C53v62Ev();
extern void _ZN6S693C53v63Ev();
extern void _ZN6S693C53v64Ev();
extern void _ZN6S693C53v65Ev();
extern void _ZN6S693C53v66Ev();
extern void _ZN6S693C53v67Ev();
extern void _ZN6S693C53v68Ev();
extern void _ZN6S693C53v69Ev();
extern void _ZN6S693C53v70Ev();
static  VTBL_ENTRY vtc_S693C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S693C5[0]),
  (VTBL_ENTRY)&_ZN6S693C5D1Ev,
  (VTBL_ENTRY)&_ZN6S693C5D0Ev,
  (VTBL_ENTRY)&_ZN6S693C52v7Ev,
  (VTBL_ENTRY)&_ZN6S693C52v8Ev,
  (VTBL_ENTRY)&_ZN6S693C52v9Ev,
  (VTBL_ENTRY)&_ZN6S693C53v10Ev,
  (VTBL_ENTRY)&_ZN6S693C53v11Ev,
  (VTBL_ENTRY)&_ZN6S693C53v12Ev,
  (VTBL_ENTRY)&_ZN6S693C53v13Ev,
  (VTBL_ENTRY)&_ZN6S693C53v14Ev,
  (VTBL_ENTRY)&_ZN6S693C53v15Ev,
  (VTBL_ENTRY)&_ZN6S693C53v16Ev,
  (VTBL_ENTRY)&_ZN6S693C53v17Ev,
  (VTBL_ENTRY)&_ZN6S693C53v18Ev,
  (VTBL_ENTRY)&_ZN6S693C53v19Ev,
  (VTBL_ENTRY)&_ZN6S693C53v20Ev,
  (VTBL_ENTRY)&_ZN6S693C53v21Ev,
  (VTBL_ENTRY)&_ZN6S693C53v22Ev,
  (VTBL_ENTRY)&_ZN6S693C53v23Ev,
  (VTBL_ENTRY)&_ZN6S693C53v24Ev,
  (VTBL_ENTRY)&_ZN6S693C53v25Ev,
  (VTBL_ENTRY)&_ZN6S693C53v26Ev,
  (VTBL_ENTRY)&_ZN6S693C53v27Ev,
  (VTBL_ENTRY)&_ZN6S693C53v28Ev,
  (VTBL_ENTRY)&_ZN6S693C53v29Ev,
  (VTBL_ENTRY)&_ZN6S693C53v30Ev,
  (VTBL_ENTRY)&_ZN6S693C53v31Ev,
  (VTBL_ENTRY)&_ZN6S693C53v32Ev,
  (VTBL_ENTRY)&_ZN6S693C53v33Ev,
  (VTBL_ENTRY)&_ZN6S693C53v34Ev,
  (VTBL_ENTRY)&_ZN6S693C53v35Ev,
  (VTBL_ENTRY)&_ZN6S693C53v36Ev,
  (VTBL_ENTRY)&_ZN6S693C53v37Ev,
  (VTBL_ENTRY)&_ZN6S693C53v38Ev,
  (VTBL_ENTRY)&_ZN6S693C53v39Ev,
  (VTBL_ENTRY)&_ZN6S693C53v40Ev,
  (VTBL_ENTRY)&_ZN6S693C53v41Ev,
  (VTBL_ENTRY)&_ZN6S693C53v42Ev,
  (VTBL_ENTRY)&_ZN6S693C53v43Ev,
  (VTBL_ENTRY)&_ZN6S693C53v44Ev,
  (VTBL_ENTRY)&_ZN6S693C53v45Ev,
  (VTBL_ENTRY)&_ZN6S693C53v46Ev,
  (VTBL_ENTRY)&_ZN6S693C53v47Ev,
  (VTBL_ENTRY)&_ZN6S693C53v48Ev,
  (VTBL_ENTRY)&_ZN6S693C53v49Ev,
  (VTBL_ENTRY)&_ZN6S693C53v50Ev,
  (VTBL_ENTRY)&_ZN6S693C53v51Ev,
  (VTBL_ENTRY)&_ZN6S693C53v52Ev,
  (VTBL_ENTRY)&_ZN6S693C53v53Ev,
  (VTBL_ENTRY)&_ZN6S693C53v54Ev,
  (VTBL_ENTRY)&_ZN6S693C53v55Ev,
  (VTBL_ENTRY)&_ZN6S693C53v56Ev,
  (VTBL_ENTRY)&_ZN6S693C53v57Ev,
  (VTBL_ENTRY)&_ZN6S693C53v58Ev,
  (VTBL_ENTRY)&_ZN6S693C53v59Ev,
  (VTBL_ENTRY)&_ZN6S693C53v60Ev,
  (VTBL_ENTRY)&_ZN6S693C53v61Ev,
  (VTBL_ENTRY)&_ZN6S693C53v62Ev,
  (VTBL_ENTRY)&_ZN6S693C53v63Ev,
  (VTBL_ENTRY)&_ZN6S693C53v64Ev,
  (VTBL_ENTRY)&_ZN6S693C53v65Ev,
  (VTBL_ENTRY)&_ZN6S693C53v66Ev,
  (VTBL_ENTRY)&_ZN6S693C53v67Ev,
  (VTBL_ENTRY)&_ZN6S693C53v68Ev,
  (VTBL_ENTRY)&_ZN6S693C53v69Ev,
  (VTBL_ENTRY)&_ZN6S693C53v70Ev,
};
extern VTBL_ENTRY _ZTI6S693C5[];
extern  VTBL_ENTRY _ZTV6S693C5[];
Class_Descriptor cd_S693C5 = {  "S693C5", // class name
  0,0,//no base classes
  &(vtc_S693C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S693C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S693C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S693C4  : S693C5 {
  unsigned int s693c4f0:1;
  unsigned int s693c4f1:1;
  unsigned int s693c4f2:1;
  unsigned int s693c4f3:1;
  unsigned int s693c4f4:1;
  unsigned int s693c4f5:1;
  unsigned int s693c4f6:1;
  ::S3625C32 s693c4f7;
  virtual  ~S693C4(); // _ZN6S693C4D1Ev
  virtual void  v71(); // _ZN6S693C43v71Ev
  virtual void  v72(); // _ZN6S693C43v72Ev
  virtual void  v73(); // _ZN6S693C43v73Ev
  virtual void  v74(); // _ZN6S693C43v74Ev
  virtual void  v75(); // _ZN6S693C43v75Ev
  virtual void  v76(); // _ZN6S693C43v76Ev
  virtual void  v77(); // _ZN6S693C43v77Ev
  virtual void  v78(); // _ZN6S693C43v78Ev
  virtual void  v79(); // _ZN6S693C43v79Ev
  virtual void  v80(); // _ZN6S693C43v80Ev
  virtual void  v81(); // _ZN6S693C43v81Ev
  virtual void  v82(); // _ZN6S693C43v82Ev
  virtual void  v83(); // _ZN6S693C43v83Ev
  virtual void  v84(); // _ZN6S693C43v84Ev
  virtual void  v85(); // _ZN6S693C43v85Ev
  virtual void  v86(); // _ZN6S693C43v86Ev
  virtual void  v87(); // _ZN6S693C43v87Ev
  virtual void  v88(); // _ZN6S693C43v88Ev
  virtual void  v89(); // _ZN6S693C43v89Ev
  virtual void  v90(); // _ZN6S693C43v90Ev
  S693C4(); // tgen
};
//SIG(-1 S693C4) C1{ BC2{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC4{ m}}


 S693C4 ::~S693C4(){ note_dtor("S693C4", this);}
void  S693C4 ::v71(){vfunc_called(this, "_ZN6S693C43v71Ev");}
void  S693C4 ::v72(){vfunc_called(this, "_ZN6S693C43v72Ev");}
void  S693C4 ::v73(){vfunc_called(this, "_ZN6S693C43v73Ev");}
void  S693C4 ::v74(){vfunc_called(this, "_ZN6S693C43v74Ev");}
void  S693C4 ::v75(){vfunc_called(this, "_ZN6S693C43v75Ev");}
void  S693C4 ::v76(){vfunc_called(this, "_ZN6S693C43v76Ev");}
void  S693C4 ::v77(){vfunc_called(this, "_ZN6S693C43v77Ev");}
void  S693C4 ::v78(){vfunc_called(this, "_ZN6S693C43v78Ev");}
void  S693C4 ::v79(){vfunc_called(this, "_ZN6S693C43v79Ev");}
void  S693C4 ::v80(){vfunc_called(this, "_ZN6S693C43v80Ev");}
void  S693C4 ::v81(){vfunc_called(this, "_ZN6S693C43v81Ev");}
void  S693C4 ::v82(){vfunc_called(this, "_ZN6S693C43v82Ev");}
void  S693C4 ::v83(){vfunc_called(this, "_ZN6S693C43v83Ev");}
void  S693C4 ::v84(){vfunc_called(this, "_ZN6S693C43v84Ev");}
void  S693C4 ::v85(){vfunc_called(this, "_ZN6S693C43v85Ev");}
void  S693C4 ::v86(){vfunc_called(this, "_ZN6S693C43v86Ev");}
void  S693C4 ::v87(){vfunc_called(this, "_ZN6S693C43v87Ev");}
void  S693C4 ::v88(){vfunc_called(this, "_ZN6S693C43v88Ev");}
void  S693C4 ::v89(){vfunc_called(this, "_ZN6S693C43v89Ev");}
void  S693C4 ::v90(){vfunc_called(this, "_ZN6S693C43v90Ev");}
S693C4 ::S693C4(){ note_ctor("S693C4", this);} // tgen

static void Test_S693C4()
{
  extern Class_Descriptor cd_S693C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S693C4, buf);
    S693C4 *dp, &lv = *(dp=new (buf) S693C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S693C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S693C4)");
    check_base_class_offset(lv, (S693C5*), 0, "S693C4");
    set_bf_and_test(lv, s693c4f0, ABISELECT(96,60), 0, 1, 1, "S693C4");
    set_bf_and_test(lv, s693c4f1, ABISELECT(96,60), 1, 1, 1, "S693C4");
    set_bf_and_test(lv, s693c4f2, ABISELECT(96,60), 2, 1, 1, "S693C4");
    set_bf_and_test(lv, s693c4f3, ABISELECT(96,60), 3, 1, 1, "S693C4");
    set_bf_and_test(lv, s693c4f4, ABISELECT(96,60), 4, 1, 1, "S693C4");
    set_bf_and_test(lv, s693c4f5, ABISELECT(96,60), 5, 1, 1, "S693C4");
    set_bf_and_test(lv, s693c4f6, ABISELECT(96,60), 6, 1, 1, "S693C4");
    check_field_offset(lv, s693c4f7, ABISELECT(97,61), "S693C4.s693c4f7");
    test_class_info(&lv, &cd_S693C4);
    dp->~S693C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS693C4(Test_S693C4, "S693C4", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN6S693C4C1Ev();
extern void _ZN6S693C4D1Ev();
Name_Map name_map_S693C4[] = {
  NSPAIR(_ZN6S693C4C1Ev),
  NSPAIR(_ZN6S693C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S693C5;
extern VTBL_ENTRY _ZTI6S693C5[];
extern  VTBL_ENTRY _ZTV6S693C5[];
static Base_Class bases_S693C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S693C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S693C4[];
extern void _ZN6S693C4D1Ev();
extern void _ZN6S693C4D0Ev();
extern void _ZN6S693C52v7Ev();
extern void _ZN6S693C52v8Ev();
extern void _ZN6S693C52v9Ev();
extern void _ZN6S693C53v10Ev();
extern void _ZN6S693C53v11Ev();
extern void _ZN6S693C53v12Ev();
extern void _ZN6S693C53v13Ev();
extern void _ZN6S693C53v14Ev();
extern void _ZN6S693C53v15Ev();
extern void _ZN6S693C53v16Ev();
extern void _ZN6S693C53v17Ev();
extern void _ZN6S693C53v18Ev();
extern void _ZN6S693C53v19Ev();
extern void _ZN6S693C53v20Ev();
extern void _ZN6S693C53v21Ev();
extern void _ZN6S693C53v22Ev();
extern void _ZN6S693C53v23Ev();
extern void _ZN6S693C53v24Ev();
extern void _ZN6S693C53v25Ev();
extern void _ZN6S693C53v26Ev();
extern void _ZN6S693C53v27Ev();
extern void _ZN6S693C53v28Ev();
extern void _ZN6S693C53v29Ev();
extern void _ZN6S693C53v30Ev();
extern void _ZN6S693C53v31Ev();
extern void _ZN6S693C53v32Ev();
extern void _ZN6S693C53v33Ev();
extern void _ZN6S693C53v34Ev();
extern void _ZN6S693C53v35Ev();
extern void _ZN6S693C53v36Ev();
extern void _ZN6S693C53v37Ev();
extern void _ZN6S693C53v38Ev();
extern void _ZN6S693C53v39Ev();
extern void _ZN6S693C53v40Ev();
extern void _ZN6S693C53v41Ev();
extern void _ZN6S693C53v42Ev();
extern void _ZN6S693C53v43Ev();
extern void _ZN6S693C53v44Ev();
extern void _ZN6S693C53v45Ev();
extern void _ZN6S693C53v46Ev();
extern void _ZN6S693C53v47Ev();
extern void _ZN6S693C53v48Ev();
extern void _ZN6S693C53v49Ev();
extern void _ZN6S693C53v50Ev();
extern void _ZN6S693C53v51Ev();
extern void _ZN6S693C53v52Ev();
extern void _ZN6S693C53v53Ev();
extern void _ZN6S693C53v54Ev();
extern void _ZN6S693C53v55Ev();
extern void _ZN6S693C53v56Ev();
extern void _ZN6S693C53v57Ev();
extern void _ZN6S693C53v58Ev();
extern void _ZN6S693C53v59Ev();
extern void _ZN6S693C53v60Ev();
extern void _ZN6S693C53v61Ev();
extern void _ZN6S693C53v62Ev();
extern void _ZN6S693C53v63Ev();
extern void _ZN6S693C53v64Ev();
extern void _ZN6S693C53v65Ev();
extern void _ZN6S693C53v66Ev();
extern void _ZN6S693C53v67Ev();
extern void _ZN6S693C53v68Ev();
extern void _ZN6S693C53v69Ev();
extern void _ZN6S693C53v70Ev();
extern void _ZN6S693C43v71Ev();
extern void _ZN6S693C43v72Ev();
extern void _ZN6S693C43v73Ev();
extern void _ZN6S693C43v74Ev();
extern void _ZN6S693C43v75Ev();
extern void _ZN6S693C43v76Ev();
extern void _ZN6S693C43v77Ev();
extern void _ZN6S693C43v78Ev();
extern void _ZN6S693C43v79Ev();
extern void _ZN6S693C43v80Ev();
extern void _ZN6S693C43v81Ev();
extern void _ZN6S693C43v82Ev();
extern void _ZN6S693C43v83Ev();
extern void _ZN6S693C43v84Ev();
extern void _ZN6S693C43v85Ev();
extern void _ZN6S693C43v86Ev();
extern void _ZN6S693C43v87Ev();
extern void _ZN6S693C43v88Ev();
extern void _ZN6S693C43v89Ev();
extern void _ZN6S693C43v90Ev();
static  VTBL_ENTRY vtc_S693C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S693C4[0]),
  (VTBL_ENTRY)&_ZN6S693C4D1Ev,
  (VTBL_ENTRY)&_ZN6S693C4D0Ev,
  (VTBL_ENTRY)&_ZN6S693C52v7Ev,
  (VTBL_ENTRY)&_ZN6S693C52v8Ev,
  (VTBL_ENTRY)&_ZN6S693C52v9Ev,
  (VTBL_ENTRY)&_ZN6S693C53v10Ev,
  (VTBL_ENTRY)&_ZN6S693C53v11Ev,
  (VTBL_ENTRY)&_ZN6S693C53v12Ev,
  (VTBL_ENTRY)&_ZN6S693C53v13Ev,
  (VTBL_ENTRY)&_ZN6S693C53v14Ev,
  (VTBL_ENTRY)&_ZN6S693C53v15Ev,
  (VTBL_ENTRY)&_ZN6S693C53v16Ev,
  (VTBL_ENTRY)&_ZN6S693C53v17Ev,
  (VTBL_ENTRY)&_ZN6S693C53v18Ev,
  (VTBL_ENTRY)&_ZN6S693C53v19Ev,
  (VTBL_ENTRY)&_ZN6S693C53v20Ev,
  (VTBL_ENTRY)&_ZN6S693C53v21Ev,
  (VTBL_ENTRY)&_ZN6S693C53v22Ev,
  (VTBL_ENTRY)&_ZN6S693C53v23Ev,
  (VTBL_ENTRY)&_ZN6S693C53v24Ev,
  (VTBL_ENTRY)&_ZN6S693C53v25Ev,
  (VTBL_ENTRY)&_ZN6S693C53v26Ev,
  (VTBL_ENTRY)&_ZN6S693C53v27Ev,
  (VTBL_ENTRY)&_ZN6S693C53v28Ev,
  (VTBL_ENTRY)&_ZN6S693C53v29Ev,
  (VTBL_ENTRY)&_ZN6S693C53v30Ev,
  (VTBL_ENTRY)&_ZN6S693C53v31Ev,
  (VTBL_ENTRY)&_ZN6S693C53v32Ev,
  (VTBL_ENTRY)&_ZN6S693C53v33Ev,
  (VTBL_ENTRY)&_ZN6S693C53v34Ev,
  (VTBL_ENTRY)&_ZN6S693C53v35Ev,
  (VTBL_ENTRY)&_ZN6S693C53v36Ev,
  (VTBL_ENTRY)&_ZN6S693C53v37Ev,
  (VTBL_ENTRY)&_ZN6S693C53v38Ev,
  (VTBL_ENTRY)&_ZN6S693C53v39Ev,
  (VTBL_ENTRY)&_ZN6S693C53v40Ev,
  (VTBL_ENTRY)&_ZN6S693C53v41Ev,
  (VTBL_ENTRY)&_ZN6S693C53v42Ev,
  (VTBL_ENTRY)&_ZN6S693C53v43Ev,
  (VTBL_ENTRY)&_ZN6S693C53v44Ev,
  (VTBL_ENTRY)&_ZN6S693C53v45Ev,
  (VTBL_ENTRY)&_ZN6S693C53v46Ev,
  (VTBL_ENTRY)&_ZN6S693C53v47Ev,
  (VTBL_ENTRY)&_ZN6S693C53v48Ev,
  (VTBL_ENTRY)&_ZN6S693C53v49Ev,
  (VTBL_ENTRY)&_ZN6S693C53v50Ev,
  (VTBL_ENTRY)&_ZN6S693C53v51Ev,
  (VTBL_ENTRY)&_ZN6S693C53v52Ev,
  (VTBL_ENTRY)&_ZN6S693C53v53Ev,
  (VTBL_ENTRY)&_ZN6S693C53v54Ev,
  (VTBL_ENTRY)&_ZN6S693C53v55Ev,
  (VTBL_ENTRY)&_ZN6S693C53v56Ev,
  (VTBL_ENTRY)&_ZN6S693C53v57Ev,
  (VTBL_ENTRY)&_ZN6S693C53v58Ev,
  (VTBL_ENTRY)&_ZN6S693C53v59Ev,
  (VTBL_ENTRY)&_ZN6S693C53v60Ev,
  (VTBL_ENTRY)&_ZN6S693C53v61Ev,
  (VTBL_ENTRY)&_ZN6S693C53v62Ev,
  (VTBL_ENTRY)&_ZN6S693C53v63Ev,
  (VTBL_ENTRY)&_ZN6S693C53v64Ev,
  (VTBL_ENTRY)&_ZN6S693C53v65Ev,
  (VTBL_ENTRY)&_ZN6S693C53v66Ev,
  (VTBL_ENTRY)&_ZN6S693C53v67Ev,
  (VTBL_ENTRY)&_ZN6S693C53v68Ev,
  (VTBL_ENTRY)&_ZN6S693C53v69Ev,
  (VTBL_ENTRY)&_ZN6S693C53v70Ev,
  (VTBL_ENTRY)&_ZN6S693C43v71Ev,
  (VTBL_ENTRY)&_ZN6S693C43v72Ev,
  (VTBL_ENTRY)&_ZN6S693C43v73Ev,
  (VTBL_ENTRY)&_ZN6S693C43v74Ev,
  (VTBL_ENTRY)&_ZN6S693C43v75Ev,
  (VTBL_ENTRY)&_ZN6S693C43v76Ev,
  (VTBL_ENTRY)&_ZN6S693C43v77Ev,
  (VTBL_ENTRY)&_ZN6S693C43v78Ev,
  (VTBL_ENTRY)&_ZN6S693C43v79Ev,
  (VTBL_ENTRY)&_ZN6S693C43v80Ev,
  (VTBL_ENTRY)&_ZN6S693C43v81Ev,
  (VTBL_ENTRY)&_ZN6S693C43v82Ev,
  (VTBL_ENTRY)&_ZN6S693C43v83Ev,
  (VTBL_ENTRY)&_ZN6S693C43v84Ev,
  (VTBL_ENTRY)&_ZN6S693C43v85Ev,
  (VTBL_ENTRY)&_ZN6S693C43v86Ev,
  (VTBL_ENTRY)&_ZN6S693C43v87Ev,
  (VTBL_ENTRY)&_ZN6S693C43v88Ev,
  (VTBL_ENTRY)&_ZN6S693C43v89Ev,
  (VTBL_ENTRY)&_ZN6S693C43v90Ev,
};
extern VTBL_ENTRY _ZTI6S693C4[];
extern  VTBL_ENTRY _ZTV6S693C4[];
Class_Descriptor cd_S693C4 = {  "S693C4", // class name
  bases_S693C4, 1,
  &(vtc_S693C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI6S693C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S693C4),88, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S693C3  : S693C4 {
  virtual  ~S693C3(); // _ZN6S693C3D1Ev
  virtual void  v91(); // _ZN6S693C33v91Ev
  virtual void  v92(); // _ZN6S693C33v92Ev
  virtual void  v93(); // _ZN6S693C33v93Ev
  virtual void  v94(); // _ZN6S693C33v94Ev
  virtual void  v95(); // _ZN6S693C33v95Ev
  virtual void  v96(); // _ZN6S693C33v96Ev
  virtual void  v97(); // _ZN6S693C33v97Ev
  virtual void  v98(); // _ZN6S693C33v98Ev
  virtual void  v99(); // _ZN6S693C33v99Ev
  S693C3(); // tgen
};
//SIG(-1 S693C3) C1{ BC2{ BC3{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC5{ m}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9}


 S693C3 ::~S693C3(){ note_dtor("S693C3", this);}
void  S693C3 ::v91(){vfunc_called(this, "_ZN6S693C33v91Ev");}
void  S693C3 ::v92(){vfunc_called(this, "_ZN6S693C33v92Ev");}
void  S693C3 ::v93(){vfunc_called(this, "_ZN6S693C33v93Ev");}
void  S693C3 ::v94(){vfunc_called(this, "_ZN6S693C33v94Ev");}
void  S693C3 ::v95(){vfunc_called(this, "_ZN6S693C33v95Ev");}
void  S693C3 ::v96(){vfunc_called(this, "_ZN6S693C33v96Ev");}
void  S693C3 ::v97(){vfunc_called(this, "_ZN6S693C33v97Ev");}
void  S693C3 ::v98(){vfunc_called(this, "_ZN6S693C33v98Ev");}
void  S693C3 ::v99(){vfunc_called(this, "_ZN6S693C33v99Ev");}
S693C3 ::S693C3(){ note_ctor("S693C3", this);} // tgen

static void Test_S693C3()
{
  extern Class_Descriptor cd_S693C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S693C3, buf);
    S693C3 *dp, &lv = *(dp=new (buf) S693C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S693C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S693C3)");
    check_base_class_offset(lv, (S693C5*)(S693C4*), 0, "S693C3");
    check_base_class_offset(lv, (S693C4*), 0, "S693C3");
    test_class_info(&lv, &cd_S693C3);
    dp->~S693C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS693C3(Test_S693C3, "S693C3", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN6S693C3C1Ev();
extern void _ZN6S693C3D1Ev();
Name_Map name_map_S693C3[] = {
  NSPAIR(_ZN6S693C3C1Ev),
  NSPAIR(_ZN6S693C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S693C5;
extern VTBL_ENTRY _ZTI6S693C5[];
extern  VTBL_ENTRY _ZTV6S693C5[];
extern Class_Descriptor cd_S693C4;
extern VTBL_ENTRY _ZTI6S693C4[];
extern  VTBL_ENTRY _ZTV6S693C4[];
static Base_Class bases_S693C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S693C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S693C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S693C3[];
extern void _ZN6S693C3D1Ev();
extern void _ZN6S693C3D0Ev();
extern void _ZN6S693C52v7Ev();
extern void _ZN6S693C52v8Ev();
extern void _ZN6S693C52v9Ev();
extern void _ZN6S693C53v10Ev();
extern void _ZN6S693C53v11Ev();
extern void _ZN6S693C53v12Ev();
extern void _ZN6S693C53v13Ev();
extern void _ZN6S693C53v14Ev();
extern void _ZN6S693C53v15Ev();
extern void _ZN6S693C53v16Ev();
extern void _ZN6S693C53v17Ev();
extern void _ZN6S693C53v18Ev();
extern void _ZN6S693C53v19Ev();
extern void _ZN6S693C53v20Ev();
extern void _ZN6S693C53v21Ev();
extern void _ZN6S693C53v22Ev();
extern void _ZN6S693C53v23Ev();
extern void _ZN6S693C53v24Ev();
extern void _ZN6S693C53v25Ev();
extern void _ZN6S693C53v26Ev();
extern void _ZN6S693C53v27Ev();
extern void _ZN6S693C53v28Ev();
extern void _ZN6S693C53v29Ev();
extern void _ZN6S693C53v30Ev();
extern void _ZN6S693C53v31Ev();
extern void _ZN6S693C53v32Ev();
extern void _ZN6S693C53v33Ev();
extern void _ZN6S693C53v34Ev();
extern void _ZN6S693C53v35Ev();
extern void _ZN6S693C53v36Ev();
extern void _ZN6S693C53v37Ev();
extern void _ZN6S693C53v38Ev();
extern void _ZN6S693C53v39Ev();
extern void _ZN6S693C53v40Ev();
extern void _ZN6S693C53v41Ev();
extern void _ZN6S693C53v42Ev();
extern void _ZN6S693C53v43Ev();
extern void _ZN6S693C53v44Ev();
extern void _ZN6S693C53v45Ev();
extern void _ZN6S693C53v46Ev();
extern void _ZN6S693C53v47Ev();
extern void _ZN6S693C53v48Ev();
extern void _ZN6S693C53v49Ev();
extern void _ZN6S693C53v50Ev();
extern void _ZN6S693C53v51Ev();
extern void _ZN6S693C53v52Ev();
extern void _ZN6S693C53v53Ev();
extern void _ZN6S693C53v54Ev();
extern void _ZN6S693C53v55Ev();
extern void _ZN6S693C53v56Ev();
extern void _ZN6S693C53v57Ev();
extern void _ZN6S693C53v58Ev();
extern void _ZN6S693C53v59Ev();
extern void _ZN6S693C53v60Ev();
extern void _ZN6S693C53v61Ev();
extern void _ZN6S693C53v62Ev();
extern void _ZN6S693C53v63Ev();
extern void _ZN6S693C53v64Ev();
extern void _ZN6S693C53v65Ev();
extern void _ZN6S693C53v66Ev();
extern void _ZN6S693C53v67Ev();
extern void _ZN6S693C53v68Ev();
extern void _ZN6S693C53v69Ev();
extern void _ZN6S693C53v70Ev();
extern void _ZN6S693C43v71Ev();
extern void _ZN6S693C43v72Ev();
extern void _ZN6S693C43v73Ev();
extern void _ZN6S693C43v74Ev();
extern void _ZN6S693C43v75Ev();
extern void _ZN6S693C43v76Ev();
extern void _ZN6S693C43v77Ev();
extern void _ZN6S693C43v78Ev();
extern void _ZN6S693C43v79Ev();
extern void _ZN6S693C43v80Ev();
extern void _ZN6S693C43v81Ev();
extern void _ZN6S693C43v82Ev();
extern void _ZN6S693C43v83Ev();
extern void _ZN6S693C43v84Ev();
extern void _ZN6S693C43v85Ev();
extern void _ZN6S693C43v86Ev();
extern void _ZN6S693C43v87Ev();
extern void _ZN6S693C43v88Ev();
extern void _ZN6S693C43v89Ev();
extern void _ZN6S693C43v90Ev();
extern void _ZN6S693C33v91Ev();
extern void _ZN6S693C33v92Ev();
extern void _ZN6S693C33v93Ev();
extern void _ZN6S693C33v94Ev();
extern void _ZN6S693C33v95Ev();
extern void _ZN6S693C33v96Ev();
extern void _ZN6S693C33v97Ev();
extern void _ZN6S693C33v98Ev();
extern void _ZN6S693C33v99Ev();
static  VTBL_ENTRY vtc_S693C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S693C3[0]),
  (VTBL_ENTRY)&_ZN6S693C3D1Ev,
  (VTBL_ENTRY)&_ZN6S693C3D0Ev,
  (VTBL_ENTRY)&_ZN6S693C52v7Ev,
  (VTBL_ENTRY)&_ZN6S693C52v8Ev,
  (VTBL_ENTRY)&_ZN6S693C52v9Ev,
  (VTBL_ENTRY)&_ZN6S693C53v10Ev,
  (VTBL_ENTRY)&_ZN6S693C53v11Ev,
  (VTBL_ENTRY)&_ZN6S693C53v12Ev,
  (VTBL_ENTRY)&_ZN6S693C53v13Ev,
  (VTBL_ENTRY)&_ZN6S693C53v14Ev,
  (VTBL_ENTRY)&_ZN6S693C53v15Ev,
  (VTBL_ENTRY)&_ZN6S693C53v16Ev,
  (VTBL_ENTRY)&_ZN6S693C53v17Ev,
  (VTBL_ENTRY)&_ZN6S693C53v18Ev,
  (VTBL_ENTRY)&_ZN6S693C53v19Ev,
  (VTBL_ENTRY)&_ZN6S693C53v20Ev,
  (VTBL_ENTRY)&_ZN6S693C53v21Ev,
  (VTBL_ENTRY)&_ZN6S693C53v22Ev,
  (VTBL_ENTRY)&_ZN6S693C53v23Ev,
  (VTBL_ENTRY)&_ZN6S693C53v24Ev,
  (VTBL_ENTRY)&_ZN6S693C53v25Ev,
  (VTBL_ENTRY)&_ZN6S693C53v26Ev,
  (VTBL_ENTRY)&_ZN6S693C53v27Ev,
  (VTBL_ENTRY)&_ZN6S693C53v28Ev,
  (VTBL_ENTRY)&_ZN6S693C53v29Ev,
  (VTBL_ENTRY)&_ZN6S693C53v30Ev,
  (VTBL_ENTRY)&_ZN6S693C53v31Ev,
  (VTBL_ENTRY)&_ZN6S693C53v32Ev,
  (VTBL_ENTRY)&_ZN6S693C53v33Ev,
  (VTBL_ENTRY)&_ZN6S693C53v34Ev,
  (VTBL_ENTRY)&_ZN6S693C53v35Ev,
  (VTBL_ENTRY)&_ZN6S693C53v36Ev,
  (VTBL_ENTRY)&_ZN6S693C53v37Ev,
  (VTBL_ENTRY)&_ZN6S693C53v38Ev,
  (VTBL_ENTRY)&_ZN6S693C53v39Ev,
  (VTBL_ENTRY)&_ZN6S693C53v40Ev,
  (VTBL_ENTRY)&_ZN6S693C53v41Ev,
  (VTBL_ENTRY)&_ZN6S693C53v42Ev,
  (VTBL_ENTRY)&_ZN6S693C53v43Ev,
  (VTBL_ENTRY)&_ZN6S693C53v44Ev,
  (VTBL_ENTRY)&_ZN6S693C53v45Ev,
  (VTBL_ENTRY)&_ZN6S693C53v46Ev,
  (VTBL_ENTRY)&_ZN6S693C53v47Ev,
  (VTBL_ENTRY)&_ZN6S693C53v48Ev,
  (VTBL_ENTRY)&_ZN6S693C53v49Ev,
  (VTBL_ENTRY)&_ZN6S693C53v50Ev,
  (VTBL_ENTRY)&_ZN6S693C53v51Ev,
  (VTBL_ENTRY)&_ZN6S693C53v52Ev,
  (VTBL_ENTRY)&_ZN6S693C53v53Ev,
  (VTBL_ENTRY)&_ZN6S693C53v54Ev,
  (VTBL_ENTRY)&_ZN6S693C53v55Ev,
  (VTBL_ENTRY)&_ZN6S693C53v56Ev,
  (VTBL_ENTRY)&_ZN6S693C53v57Ev,
  (VTBL_ENTRY)&_ZN6S693C53v58Ev,
  (VTBL_ENTRY)&_ZN6S693C53v59Ev,
  (VTBL_ENTRY)&_ZN6S693C53v60Ev,
  (VTBL_ENTRY)&_ZN6S693C53v61Ev,
  (VTBL_ENTRY)&_ZN6S693C53v62Ev,
  (VTBL_ENTRY)&_ZN6S693C53v63Ev,
  (VTBL_ENTRY)&_ZN6S693C53v64Ev,
  (VTBL_ENTRY)&_ZN6S693C53v65Ev,
  (VTBL_ENTRY)&_ZN6S693C53v66Ev,
  (VTBL_ENTRY)&_ZN6S693C53v67Ev,
  (VTBL_ENTRY)&_ZN6S693C53v68Ev,
  (VTBL_ENTRY)&_ZN6S693C53v69Ev,
  (VTBL_ENTRY)&_ZN6S693C53v70Ev,
  (VTBL_ENTRY)&_ZN6S693C43v71Ev,
  (VTBL_ENTRY)&_ZN6S693C43v72Ev,
  (VTBL_ENTRY)&_ZN6S693C43v73Ev,
  (VTBL_ENTRY)&_ZN6S693C43v74Ev,
  (VTBL_ENTRY)&_ZN6S693C43v75Ev,
  (VTBL_ENTRY)&_ZN6S693C43v76Ev,
  (VTBL_ENTRY)&_ZN6S693C43v77Ev,
  (VTBL_ENTRY)&_ZN6S693C43v78Ev,
  (VTBL_ENTRY)&_ZN6S693C43v79Ev,
  (VTBL_ENTRY)&_ZN6S693C43v80Ev,
  (VTBL_ENTRY)&_ZN6S693C43v81Ev,
  (VTBL_ENTRY)&_ZN6S693C43v82Ev,
  (VTBL_ENTRY)&_ZN6S693C43v83Ev,
  (VTBL_ENTRY)&_ZN6S693C43v84Ev,
  (VTBL_ENTRY)&_ZN6S693C43v85Ev,
  (VTBL_ENTRY)&_ZN6S693C43v86Ev,
  (VTBL_ENTRY)&_ZN6S693C43v87Ev,
  (VTBL_ENTRY)&_ZN6S693C43v88Ev,
  (VTBL_ENTRY)&_ZN6S693C43v89Ev,
  (VTBL_ENTRY)&_ZN6S693C43v90Ev,
  (VTBL_ENTRY)&_ZN6S693C33v91Ev,
  (VTBL_ENTRY)&_ZN6S693C33v92Ev,
  (VTBL_ENTRY)&_ZN6S693C33v93Ev,
  (VTBL_ENTRY)&_ZN6S693C33v94Ev,
  (VTBL_ENTRY)&_ZN6S693C33v95Ev,
  (VTBL_ENTRY)&_ZN6S693C33v96Ev,
  (VTBL_ENTRY)&_ZN6S693C33v97Ev,
  (VTBL_ENTRY)&_ZN6S693C33v98Ev,
  (VTBL_ENTRY)&_ZN6S693C33v99Ev,
};
extern VTBL_ENTRY _ZTI6S693C3[];
extern  VTBL_ENTRY _ZTV6S693C3[];
Class_Descriptor cd_S693C3 = {  "S693C3", // class name
  bases_S693C3, 2,
  &(vtc_S693C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI6S693C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S693C3),97, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S693C2  : S693C3 {
  void *s693c2f0;
  unsigned int s693c2f1:1;
  unsigned int s693c2f2:1;
  unsigned int s693c2f3:1;
  char s693c2f4;
  virtual  ~S693C2(); // _ZN6S693C2D1Ev
  virtual void  v100(); // _ZN6S693C24v100Ev
  virtual void  v101(); // _ZN6S693C24v101Ev
  virtual void  v102(); // _ZN6S693C24v102Ev
  virtual void  v103(); // _ZN6S693C24v103Ev
  virtual void  v104(); // _ZN6S693C24v104Ev
  virtual void  v105(); // _ZN6S693C24v105Ev
  S693C2(); // tgen
};
//SIG(-1 S693C2) C1{ BC2{ BC3{ BC4{ vd v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC6{ m}} vd v91 v92 v93 v94 v95 v96 v97 v98 v99} vd v1 v2 v3 v4 v5 v6 Fp Fi:1 Fi:1 Fi:1 Fc}


 S693C2 ::~S693C2(){ note_dtor("S693C2", this);}
void  S693C2 ::v100(){vfunc_called(this, "_ZN6S693C24v100Ev");}
void  S693C2 ::v101(){vfunc_called(this, "_ZN6S693C24v101Ev");}
void  S693C2 ::v102(){vfunc_called(this, "_ZN6S693C24v102Ev");}
void  S693C2 ::v103(){vfunc_called(this, "_ZN6S693C24v103Ev");}
void  S693C2 ::v104(){vfunc_called(this, "_ZN6S693C24v104Ev");}
void  S693C2 ::v105(){vfunc_called(this, "_ZN6S693C24v105Ev");}
S693C2 ::S693C2(){ note_ctor("S693C2", this);} // tgen

static void Test_S693C2()
{
  extern Class_Descriptor cd_S693C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(16,19)];
    init_test(&cd_S693C2, buf);
    S693C2 *dp, &lv = *(dp=new (buf) S693C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(120,72), "sizeof(S693C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S693C2)");
    check_base_class_offset(lv, (S693C5*)(S693C4*)(S693C3*), 0, "S693C2");
    check_base_class_offset(lv, (S693C4*)(S693C3*), 0, "S693C2");
    check_base_class_offset(lv, (S693C3*), 0, "S693C2");
    check_field_offset(lv, s693c2f0, ABISELECT(104,64), "S693C2.s693c2f0");
    set_bf_and_test(lv, s693c2f1, ABISELECT(112,68), 0, 1, 1, "S693C2");
    set_bf_and_test(lv, s693c2f2, ABISELECT(112,68), 1, 1, 1, "S693C2");
    set_bf_and_test(lv, s693c2f3, ABISELECT(112,68), 2, 1, 1, "S693C2");
    check_field_offset(lv, s693c2f4, ABISELECT(113,69), "S693C2.s693c2f4");
    test_class_info(&lv, &cd_S693C2);
    dp->~S693C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS693C2(Test_S693C2, "S693C2", ABISELECT(120,72));

#else // __cplusplus

extern void _ZN6S693C2C1Ev();
extern void _ZN6S693C2D1Ev();
Name_Map name_map_S693C2[] = {
  NSPAIR(_ZN6S693C2C1Ev),
  NSPAIR(_ZN6S693C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S693C5;
extern VTBL_ENTRY _ZTI6S693C5[];
extern  VTBL_ENTRY _ZTV6S693C5[];
extern Class_Descriptor cd_S693C4;
extern VTBL_ENTRY _ZTI6S693C4[];
extern  VTBL_ENTRY _ZTV6S693C4[];
extern Class_Descriptor cd_S693C3;
extern VTBL_ENTRY _ZTI6S693C3[];
extern  VTBL_ENTRY _ZTV6S693C3[];
static Base_Class bases_S693C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S693C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S693C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S693C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S693C2[];
extern void _ZN6S693C2D1Ev();
extern void _ZN6S693C2D0Ev();
extern void _ZN6S693C52v7Ev();
extern void _ZN6S693C52v8Ev();
extern void _ZN6S693C52v9Ev();
extern void _ZN6S693C53v10Ev();
extern void _ZN6S693C53v11Ev();
extern void _ZN6S693C53v12Ev();
extern void _ZN6S693C53v13Ev();
extern void _ZN6S693C53v14Ev();
extern void _ZN6S693C53v15Ev();
extern void _ZN6S693C53v16Ev();
extern void _ZN6S693C53v17Ev();
extern void _ZN6S693C53v18Ev();
extern void _ZN6S693C53v19Ev();
extern void _ZN6S693C53v20Ev();
extern void _ZN6S693C53v21Ev();
extern void _ZN6S693C53v22Ev();
extern void _ZN6S693C53v23Ev();
extern void _ZN6S693C53v24Ev();
extern void _ZN6S693C53v25Ev();
extern void _ZN6S693C53v26Ev();
extern void _ZN6S693C53v27Ev();
extern void _ZN6S693C53v28Ev();
extern void _ZN6S693C53v29Ev();
extern void _ZN6S693C53v30Ev();
extern void _ZN6S693C53v31Ev();
extern void _ZN6S693C53v32Ev();
extern void _ZN6S693C53v33Ev();
extern void _ZN6S693C53v34Ev();
extern void _ZN6S693C53v35Ev();
extern void _ZN6S693C53v36Ev();
extern void _ZN6S693C53v37Ev();
extern void _ZN6S693C53v38Ev();
extern void _ZN6S693C53v39Ev();
extern void _ZN6S693C53v40Ev();
extern void _ZN6S693C53v41Ev();
extern void _ZN6S693C53v42Ev();
extern void _ZN6S693C53v43Ev();
extern void _ZN6S693C53v44Ev();
extern void _ZN6S693C53v45Ev();
extern void _ZN6S693C53v46Ev();
extern void _ZN6S693C53v47Ev();
extern void _ZN6S693C53v48Ev();
extern void _ZN6S693C53v49Ev();
extern void _ZN6S693C53v50Ev();
extern void _ZN6S693C53v51Ev();
extern void _ZN6S693C53v52Ev();
extern void _ZN6S693C53v53Ev();
extern void _ZN6S693C53v54Ev();
extern void _ZN6S693C53v55Ev();
extern void _ZN6S693C53v56Ev();
extern void _ZN6S693C53v57Ev();
extern void _ZN6S693C53v58Ev();
extern void _ZN6S693C53v59Ev();
extern void _ZN6S693C53v60Ev();
extern void _ZN6S693C53v61Ev();
extern void _ZN6S693C53v62Ev();
extern void _ZN6S693C53v63Ev();
extern void _ZN6S693C53v64Ev();
extern void _ZN6S693C53v65Ev();
extern void _ZN6S693C53v66Ev();
extern void _ZN6S693C53v67Ev();
extern void _ZN6S693C53v68Ev();
extern void _ZN6S693C53v69Ev();
extern void _ZN6S693C53v70Ev();
extern void _ZN6S693C43v71Ev();
extern void _ZN6S693C43v72Ev();
extern void _ZN6S693C43v73Ev();
extern void _ZN6S693C43v74Ev();
extern void _ZN6S693C43v75Ev();
extern void _ZN6S693C43v76Ev();
extern void _ZN6S693C43v77Ev();
extern void _ZN6S693C43v78Ev();
extern void _ZN6S693C43v79Ev();
extern void _ZN6S693C43v80Ev();
extern void _ZN6S693C43v81Ev();
extern void _ZN6S693C43v82Ev();
extern void _ZN6S693C43v83Ev();
extern void _ZN6S693C43v84Ev();
extern void _ZN6S693C43v85Ev();
extern void _ZN6S693C43v86Ev();
extern void _ZN6S693C43v87Ev();
extern void _ZN6S693C43v88Ev();
extern void _ZN6S693C43v89Ev();
extern void _ZN6S693C43v90Ev();
extern void _ZN6S693C33v91Ev();
extern void _ZN6S693C33v92Ev();
extern void _ZN6S693C33v93Ev();
extern void _ZN6S693C33v94Ev();
extern void _ZN6S693C33v95Ev();
extern void _ZN6S693C33v96Ev();
extern void _ZN6S693C33v97Ev();
extern void _ZN6S693C33v98Ev();
extern void _ZN6S693C33v99Ev();
extern void _ZN6S693C24v100Ev();
extern void _ZN6S693C24v101Ev();
extern void _ZN6S693C24v102Ev();
extern void _ZN6S693C24v103Ev();
extern void _ZN6S693C24v104Ev();
extern void _ZN6S693C24v105Ev();
static  VTBL_ENTRY vtc_S693C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S693C2[0]),
  (VTBL_ENTRY)&_ZN6S693C2D1Ev,
  (VTBL_ENTRY)&_ZN6S693C2D0Ev,
  (VTBL_ENTRY)&_ZN6S693C52v7Ev,
  (VTBL_ENTRY)&_ZN6S693C52v8Ev,
  (VTBL_ENTRY)&_ZN6S693C52v9Ev,
  (VTBL_ENTRY)&_ZN6S693C53v10Ev,
  (VTBL_ENTRY)&_ZN6S693C53v11Ev,
  (VTBL_ENTRY)&_ZN6S693C53v12Ev,
  (VTBL_ENTRY)&_ZN6S693C53v13Ev,
  (VTBL_ENTRY)&_ZN6S693C53v14Ev,
  (VTBL_ENTRY)&_ZN6S693C53v15Ev,
  (VTBL_ENTRY)&_ZN6S693C53v16Ev,
  (VTBL_ENTRY)&_ZN6S693C53v17Ev,
  (VTBL_ENTRY)&_ZN6S693C53v18Ev,
  (VTBL_ENTRY)&_ZN6S693C53v19Ev,
  (VTBL_ENTRY)&_ZN6S693C53v20Ev,
  (VTBL_ENTRY)&_ZN6S693C53v21Ev,
  (VTBL_ENTRY)&_ZN6S693C53v22Ev,
  (VTBL_ENTRY)&_ZN6S693C53v23Ev,
  (VTBL_ENTRY)&_ZN6S693C53v24Ev,
  (VTBL_ENTRY)&_ZN6S693C53v25Ev,
  (VTBL_ENTRY)&_ZN6S693C53v26Ev,
  (VTBL_ENTRY)&_ZN6S693C53v27Ev,
  (VTBL_ENTRY)&_ZN6S693C53v28Ev,
  (VTBL_ENTRY)&_ZN6S693C53v29Ev,
  (VTBL_ENTRY)&_ZN6S693C53v30Ev,
  (VTBL_ENTRY)&_ZN6S693C53v31Ev,
  (VTBL_ENTRY)&_ZN6S693C53v32Ev,
  (VTBL_ENTRY)&_ZN6S693C53v33Ev,
  (VTBL_ENTRY)&_ZN6S693C53v34Ev,
  (VTBL_ENTRY)&_ZN6S693C53v35Ev,
  (VTBL_ENTRY)&_ZN6S693C53v36Ev,
  (VTBL_ENTRY)&_ZN6S693C53v37Ev,
  (VTBL_ENTRY)&_ZN6S693C53v38Ev,
  (VTBL_ENTRY)&_ZN6S693C53v39Ev,
  (VTBL_ENTRY)&_ZN6S693C53v40Ev,
  (VTBL_ENTRY)&_ZN6S693C53v41Ev,
  (VTBL_ENTRY)&_ZN6S693C53v42Ev,
  (VTBL_ENTRY)&_ZN6S693C53v43Ev,
  (VTBL_ENTRY)&_ZN6S693C53v44Ev,
  (VTBL_ENTRY)&_ZN6S693C53v45Ev,
  (VTBL_ENTRY)&_ZN6S693C53v46Ev,
  (VTBL_ENTRY)&_ZN6S693C53v47Ev,
  (VTBL_ENTRY)&_ZN6S693C53v48Ev,
  (VTBL_ENTRY)&_ZN6S693C53v49Ev,
  (VTBL_ENTRY)&_ZN6S693C53v50Ev,
  (VTBL_ENTRY)&_ZN6S693C53v51Ev,
  (VTBL_ENTRY)&_ZN6S693C53v52Ev,
  (VTBL_ENTRY)&_ZN6S693C53v53Ev,
  (VTBL_ENTRY)&_ZN6S693C53v54Ev,
  (VTBL_ENTRY)&_ZN6S693C53v55Ev,
  (VTBL_ENTRY)&_ZN6S693C53v56Ev,
  (VTBL_ENTRY)&_ZN6S693C53v57Ev,
  (VTBL_ENTRY)&_ZN6S693C53v58Ev,
  (VTBL_ENTRY)&_ZN6S693C53v59Ev,
  (VTBL_ENTRY)&_ZN6S693C53v60Ev,
  (VTBL_ENTRY)&_ZN6S693C53v61Ev,
  (VTBL_ENTRY)&_ZN6S693C53v62Ev,
  (VTBL_ENTRY)&_ZN6S693C53v63Ev,
  (VTBL_ENTRY)&_ZN6S693C53v64Ev,
  (VTBL_ENTRY)&_ZN6S693C53v65Ev,
  (VTBL_ENTRY)&_ZN6S693C53v66Ev,
  (VTBL_ENTRY)&_ZN6S693C53v67Ev,
  (VTBL_ENTRY)&_ZN6S693C53v68Ev,
  (VTBL_ENTRY)&_ZN6S693C53v69Ev,
  (VTBL_ENTRY)&_ZN6S693C53v70Ev,
  (VTBL_ENTRY)&_ZN6S693C43v71Ev,
  (VTBL_ENTRY)&_ZN6S693C43v72Ev,
  (VTBL_ENTRY)&_ZN6S693C43v73Ev,
  (VTBL_ENTRY)&_ZN6S693C43v74Ev,
  (VTBL_ENTRY)&_ZN6S693C43v75Ev,
  (VTBL_ENTRY)&_ZN6S693C43v76Ev,
  (VTBL_ENTRY)&_ZN6S693C43v77Ev,
  (VTBL_ENTRY)&_ZN6S693C43v78Ev,
  (VTBL_ENTRY)&_ZN6S693C43v79Ev,
  (VTBL_ENTRY)&_ZN6S693C43v80Ev,
  (VTBL_ENTRY)&_ZN6S693C43v81Ev,
  (VTBL_ENTRY)&_ZN6S693C43v82Ev,
  (VTBL_ENTRY)&_ZN6S693C43v83Ev,
  (VTBL_ENTRY)&_ZN6S693C43v84Ev,
  (VTBL_ENTRY)&_ZN6S693C43v85Ev,
  (VTBL_ENTRY)&_ZN6S693C43v86Ev,
  (VTBL_ENTRY)&_ZN6S693C43v87Ev,
  (VTBL_ENTRY)&_ZN6S693C43v88Ev,
  (VTBL_ENTRY)&_ZN6S693C43v89Ev,
  (VTBL_ENTRY)&_ZN6S693C43v90Ev,
  (VTBL_ENTRY)&_ZN6S693C33v91Ev,
  (VTBL_ENTRY)&_ZN6S693C33v92Ev,
  (VTBL_ENTRY)&_ZN6S693C33v93Ev,
  (VTBL_ENTRY)&_ZN6S693C33v94Ev,
  (VTBL_ENTRY)&_ZN6S693C33v95Ev,
  (VTBL_ENTRY)&_ZN6S693C33v96Ev,
  (VTBL_ENTRY)&_ZN6S693C33v97Ev,
  (VTBL_ENTRY)&_ZN6S693C33v98Ev,
  (VTBL_ENTRY)&_ZN6S693C33v99Ev,
  (VTBL_ENTRY)&_ZN6S693C24v100Ev,
  (VTBL_ENTRY)&_ZN6S693C24v101Ev,
  (VTBL_ENTRY)&_ZN6S693C24v102Ev,
  (VTBL_ENTRY)&_ZN6S693C24v103Ev,
  (VTBL_ENTRY)&_ZN6S693C24v104Ev,
  (VTBL_ENTRY)&_ZN6S693C24v105Ev,
};
extern VTBL_ENTRY _ZTI6S693C2[];
extern  VTBL_ENTRY _ZTV6S693C2[];
Class_Descriptor cd_S693C2 = {  "S693C2", // class name
  bases_S693C2, 3,
  &(vtc_S693C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(120,72), // object size
  NSPAIRA(_ZTI6S693C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S693C2),103, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S693C8  {
  int s693c8f0[7];
  char s693c8f1;
  int s693c8f2[4];
  ::S674C29_nt s693c8f3;
  int s693c8f4[7];
  char s693c8f5;
  unsigned int s693c8f6:1;
  unsigned int s693c8f7:1;
  unsigned int s693c8f8:1;
  unsigned int s693c8f9:1;
  int s693c8f10[3];
  char s693c8f11;
  int s693c8f12;
  char s693c8f13;
  int s693c8f14[2];
  ::S674C29_nt s693c8f15;
  int s693c8f16[5];
  void *s693c8f17[3];
  int s693c8f18[3];
  void *s693c8f19[9];
  int s693c8f20;
  void *s693c8f21;
  int s693c8f22;
  void *s693c8f23;
  unsigned int s693c8f24:1;
  unsigned int s693c8f25:1;
  unsigned int s693c8f26:1;
  unsigned int s693c8f27:1;
  void *s693c8f28[3];
  int s693c8f29[2];
  void  mf693c8(); // _ZN6S693C87mf693c8Ev
};
//SIG(-1 S693C8) C1{ m Fi[7] Fc Fi[4] FC2{ m Fi[3]} Fi[7] Fc Fi:1 Fi:1 Fi:1 Fi:1 Fi[3] Fc Fi Fc Fi[2] FC2 Fi[5] Fp[3] Fi[3] Fp[9] Fi Fp Fi Fp Fi:1 Fi:1 Fi:1 Fi:1 Fp[3] Fi[2]}


void  S693C8 ::mf693c8(){}

static void Test_S693C8()
{
  {
    init_simple_test("S693C8");
    static S693C8 lv;
    check2(sizeof(lv), ABISELECT(344,256), "sizeof(S693C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S693C8)");
    check_field_offset(lv, s693c8f0, 0, "S693C8.s693c8f0");
    check_field_offset(lv, s693c8f1, 28, "S693C8.s693c8f1");
    check_field_offset(lv, s693c8f2, 32, "S693C8.s693c8f2");
    check_field_offset(lv, s693c8f3, 48, "S693C8.s693c8f3");
    check_field_offset(lv, s693c8f4, 60, "S693C8.s693c8f4");
    check_field_offset(lv, s693c8f5, 88, "S693C8.s693c8f5");
    set_bf_and_test(lv, s693c8f6, 89, 0, 1, 1, "S693C8");
    set_bf_and_test(lv, s693c8f7, 89, 1, 1, 1, "S693C8");
    set_bf_and_test(lv, s693c8f8, 89, 2, 1, 1, "S693C8");
    set_bf_and_test(lv, s693c8f9, 89, 3, 1, 1, "S693C8");
    check_field_offset(lv, s693c8f10, 92, "S693C8.s693c8f10");
    check_field_offset(lv, s693c8f11, 104, "S693C8.s693c8f11");
    check_field_offset(lv, s693c8f12, 108, "S693C8.s693c8f12");
    check_field_offset(lv, s693c8f13, 112, "S693C8.s693c8f13");
    check_field_offset(lv, s693c8f14, 116, "S693C8.s693c8f14");
    check_field_offset(lv, s693c8f15, 124, "S693C8.s693c8f15");
    check_field_offset(lv, s693c8f16, 136, "S693C8.s693c8f16");
    check_field_offset(lv, s693c8f17, ABISELECT(160,156), "S693C8.s693c8f17");
    check_field_offset(lv, s693c8f18, ABISELECT(184,168), "S693C8.s693c8f18");
    check_field_offset(lv, s693c8f19, ABISELECT(200,180), "S693C8.s693c8f19");
    check_field_offset(lv, s693c8f20, ABISELECT(272,216), "S693C8.s693c8f20");
    check_field_offset(lv, s693c8f21, ABISELECT(280,220), "S693C8.s693c8f21");
    check_field_offset(lv, s693c8f22, ABISELECT(288,224), "S693C8.s693c8f22");
    check_field_offset(lv, s693c8f23, ABISELECT(296,228), "S693C8.s693c8f23");
    set_bf_and_test(lv, s693c8f24, ABISELECT(304,232), 0, 1, 1, "S693C8");
    set_bf_and_test(lv, s693c8f25, ABISELECT(304,232), 1, 1, 1, "S693C8");
    set_bf_and_test(lv, s693c8f26, ABISELECT(304,232), 2, 1, 1, "S693C8");
    set_bf_and_test(lv, s693c8f27, ABISELECT(304,232), 3, 1, 1, "S693C8");
    check_field_offset(lv, s693c8f28, ABISELECT(312,236), "S693C8.s693c8f28");
    check_field_offset(lv, s693c8f29, ABISELECT(336,248), "S693C8.s693c8f29");
  }
}
static Arrange_To_Call_Me vS693C8(Test_S693C8, "S693C8", ABISELECT(344,256));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S693C1  : S693C2 {
  ::S693C8 s693c1f0;
  char s693c1f1;
  int s693c1f2;
  virtual  ~S693C1(); // _ZN6S693C1D1Ev
  virtual void  v1(); // _ZN6S693C12v1Ev
  virtual void  v2(); // _ZN6S693C12v2Ev
  virtual void  v3(); // _ZN6S693C12v3Ev
  virtual void  v4(); // _ZN6S693C12v4Ev
  virtual void  v5(); // _ZN6S693C12v5Ev
  virtual void  v6(); // _ZN6S693C12v6Ev
  S693C1(); // tgen
};
//SIG(1 S693C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC7{ m}} vd v91 v92 v93 v94 v95 v96 v97 v98 v99} vd v100 v101 v102 v103 v104 v105 Fp Fi:1 Fi:1 Fi:1 Fc} vd v1 v2 v3 v4 v5 v6 FC8{ m Fi[7] Fc Fi[4] FC9{ m Fi[3]} Fi[7] Fc Fi:1 Fi:1 Fi:1 Fi:1 Fi[3] Fc Fi Fc Fi[2] FC9 Fi[5] Fp[3] Fi[3] Fp[9] Fi Fp Fi Fp Fi:1 Fi:1 Fi:1 Fi:1 Fp[3] Fi[2]} Fc Fi}


 S693C1 ::~S693C1(){ note_dtor("S693C1", this);}
void  S693C1 ::v1(){vfunc_called(this, "_ZN6S693C12v1Ev");}
void  S693C1 ::v2(){vfunc_called(this, "_ZN6S693C12v2Ev");}
void  S693C1 ::v3(){vfunc_called(this, "_ZN6S693C12v3Ev");}
void  S693C1 ::v4(){vfunc_called(this, "_ZN6S693C12v4Ev");}
void  S693C1 ::v5(){vfunc_called(this, "_ZN6S693C12v5Ev");}
void  S693C1 ::v6(){vfunc_called(this, "_ZN6S693C12v6Ev");}
S693C1 ::S693C1(){ note_ctor("S693C1", this);} // tgen

static void Test_S693C1()
{
  extern Class_Descriptor cd_S693C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(60,85)];
    init_test(&cd_S693C1, buf);
    S693C1 *dp, &lv = *(dp=new (buf) S693C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(472,336), "sizeof(S693C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S693C1)");
    check_base_class_offset(lv, (S693C5*)(S693C4*)(S693C3*)(S693C2*), 0, "S693C1");
    check_base_class_offset(lv, (S693C4*)(S693C3*)(S693C2*), 0, "S693C1");
    check_base_class_offset(lv, (S693C3*)(S693C2*), 0, "S693C1");
    check_base_class_offset(lv, (S693C2*), 0, "S693C1");
    check_field_offset(lv, s693c1f0, ABISELECT(120,72), "S693C1.s693c1f0");
    check_field_offset(lv, s693c1f1, ABISELECT(464,328), "S693C1.s693c1f1");
    check_field_offset(lv, s693c1f2, ABISELECT(468,332), "S693C1.s693c1f2");
    test_class_info(&lv, &cd_S693C1);
    dp->~S693C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS693C1(Test_S693C1, "S693C1", ABISELECT(472,336));

#else // __cplusplus

extern void _ZN6S693C1C1Ev();
extern void _ZN6S693C1D1Ev();
Name_Map name_map_S693C1[] = {
  NSPAIR(_ZN6S693C1C1Ev),
  NSPAIR(_ZN6S693C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S693C5;
extern VTBL_ENTRY _ZTI6S693C5[];
extern  VTBL_ENTRY _ZTV6S693C5[];
extern Class_Descriptor cd_S693C4;
extern VTBL_ENTRY _ZTI6S693C4[];
extern  VTBL_ENTRY _ZTV6S693C4[];
extern Class_Descriptor cd_S693C3;
extern VTBL_ENTRY _ZTI6S693C3[];
extern  VTBL_ENTRY _ZTV6S693C3[];
extern Class_Descriptor cd_S693C2;
extern VTBL_ENTRY _ZTI6S693C2[];
extern  VTBL_ENTRY _ZTV6S693C2[];
static Base_Class bases_S693C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S693C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S693C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S693C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S693C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S693C1[];
extern void _ZN6S693C1D1Ev();
extern void _ZN6S693C1D0Ev();
extern void _ZN6S693C52v7Ev();
extern void _ZN6S693C52v8Ev();
extern void _ZN6S693C52v9Ev();
extern void _ZN6S693C53v10Ev();
extern void _ZN6S693C53v11Ev();
extern void _ZN6S693C53v12Ev();
extern void _ZN6S693C53v13Ev();
extern void _ZN6S693C53v14Ev();
extern void _ZN6S693C53v15Ev();
extern void _ZN6S693C53v16Ev();
extern void _ZN6S693C53v17Ev();
extern void _ZN6S693C53v18Ev();
extern void _ZN6S693C53v19Ev();
extern void _ZN6S693C53v20Ev();
extern void _ZN6S693C53v21Ev();
extern void _ZN6S693C53v22Ev();
extern void _ZN6S693C53v23Ev();
extern void _ZN6S693C53v24Ev();
extern void _ZN6S693C53v25Ev();
extern void _ZN6S693C53v26Ev();
extern void _ZN6S693C53v27Ev();
extern void _ZN6S693C53v28Ev();
extern void _ZN6S693C53v29Ev();
extern void _ZN6S693C53v30Ev();
extern void _ZN6S693C53v31Ev();
extern void _ZN6S693C53v32Ev();
extern void _ZN6S693C53v33Ev();
extern void _ZN6S693C53v34Ev();
extern void _ZN6S693C53v35Ev();
extern void _ZN6S693C53v36Ev();
extern void _ZN6S693C53v37Ev();
extern void _ZN6S693C53v38Ev();
extern void _ZN6S693C53v39Ev();
extern void _ZN6S693C53v40Ev();
extern void _ZN6S693C53v41Ev();
extern void _ZN6S693C53v42Ev();
extern void _ZN6S693C53v43Ev();
extern void _ZN6S693C53v44Ev();
extern void _ZN6S693C53v45Ev();
extern void _ZN6S693C53v46Ev();
extern void _ZN6S693C53v47Ev();
extern void _ZN6S693C53v48Ev();
extern void _ZN6S693C53v49Ev();
extern void _ZN6S693C53v50Ev();
extern void _ZN6S693C53v51Ev();
extern void _ZN6S693C53v52Ev();
extern void _ZN6S693C53v53Ev();
extern void _ZN6S693C53v54Ev();
extern void _ZN6S693C53v55Ev();
extern void _ZN6S693C53v56Ev();
extern void _ZN6S693C53v57Ev();
extern void _ZN6S693C53v58Ev();
extern void _ZN6S693C53v59Ev();
extern void _ZN6S693C53v60Ev();
extern void _ZN6S693C53v61Ev();
extern void _ZN6S693C53v62Ev();
extern void _ZN6S693C53v63Ev();
extern void _ZN6S693C53v64Ev();
extern void _ZN6S693C53v65Ev();
extern void _ZN6S693C53v66Ev();
extern void _ZN6S693C53v67Ev();
extern void _ZN6S693C53v68Ev();
extern void _ZN6S693C53v69Ev();
extern void _ZN6S693C53v70Ev();
extern void _ZN6S693C43v71Ev();
extern void _ZN6S693C43v72Ev();
extern void _ZN6S693C43v73Ev();
extern void _ZN6S693C43v74Ev();
extern void _ZN6S693C43v75Ev();
extern void _ZN6S693C43v76Ev();
extern void _ZN6S693C43v77Ev();
extern void _ZN6S693C43v78Ev();
extern void _ZN6S693C43v79Ev();
extern void _ZN6S693C43v80Ev();
extern void _ZN6S693C43v81Ev();
extern void _ZN6S693C43v82Ev();
extern void _ZN6S693C43v83Ev();
extern void _ZN6S693C43v84Ev();
extern void _ZN6S693C43v85Ev();
extern void _ZN6S693C43v86Ev();
extern void _ZN6S693C43v87Ev();
extern void _ZN6S693C43v88Ev();
extern void _ZN6S693C43v89Ev();
extern void _ZN6S693C43v90Ev();
extern void _ZN6S693C33v91Ev();
extern void _ZN6S693C33v92Ev();
extern void _ZN6S693C33v93Ev();
extern void _ZN6S693C33v94Ev();
extern void _ZN6S693C33v95Ev();
extern void _ZN6S693C33v96Ev();
extern void _ZN6S693C33v97Ev();
extern void _ZN6S693C33v98Ev();
extern void _ZN6S693C33v99Ev();
extern void _ZN6S693C24v100Ev();
extern void _ZN6S693C24v101Ev();
extern void _ZN6S693C24v102Ev();
extern void _ZN6S693C24v103Ev();
extern void _ZN6S693C24v104Ev();
extern void _ZN6S693C24v105Ev();
extern void _ZN6S693C12v1Ev();
extern void _ZN6S693C12v2Ev();
extern void _ZN6S693C12v3Ev();
extern void _ZN6S693C12v4Ev();
extern void _ZN6S693C12v5Ev();
extern void _ZN6S693C12v6Ev();
static  VTBL_ENTRY vtc_S693C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S693C1[0]),
  (VTBL_ENTRY)&_ZN6S693C1D1Ev,
  (VTBL_ENTRY)&_ZN6S693C1D0Ev,
  (VTBL_ENTRY)&_ZN6S693C52v7Ev,
  (VTBL_ENTRY)&_ZN6S693C52v8Ev,
  (VTBL_ENTRY)&_ZN6S693C52v9Ev,
  (VTBL_ENTRY)&_ZN6S693C53v10Ev,
  (VTBL_ENTRY)&_ZN6S693C53v11Ev,
  (VTBL_ENTRY)&_ZN6S693C53v12Ev,
  (VTBL_ENTRY)&_ZN6S693C53v13Ev,
  (VTBL_ENTRY)&_ZN6S693C53v14Ev,
  (VTBL_ENTRY)&_ZN6S693C53v15Ev,
  (VTBL_ENTRY)&_ZN6S693C53v16Ev,
  (VTBL_ENTRY)&_ZN6S693C53v17Ev,
  (VTBL_ENTRY)&_ZN6S693C53v18Ev,
  (VTBL_ENTRY)&_ZN6S693C53v19Ev,
  (VTBL_ENTRY)&_ZN6S693C53v20Ev,
  (VTBL_ENTRY)&_ZN6S693C53v21Ev,
  (VTBL_ENTRY)&_ZN6S693C53v22Ev,
  (VTBL_ENTRY)&_ZN6S693C53v23Ev,
  (VTBL_ENTRY)&_ZN6S693C53v24Ev,
  (VTBL_ENTRY)&_ZN6S693C53v25Ev,
  (VTBL_ENTRY)&_ZN6S693C53v26Ev,
  (VTBL_ENTRY)&_ZN6S693C53v27Ev,
  (VTBL_ENTRY)&_ZN6S693C53v28Ev,
  (VTBL_ENTRY)&_ZN6S693C53v29Ev,
  (VTBL_ENTRY)&_ZN6S693C53v30Ev,
  (VTBL_ENTRY)&_ZN6S693C53v31Ev,
  (VTBL_ENTRY)&_ZN6S693C53v32Ev,
  (VTBL_ENTRY)&_ZN6S693C53v33Ev,
  (VTBL_ENTRY)&_ZN6S693C53v34Ev,
  (VTBL_ENTRY)&_ZN6S693C53v35Ev,
  (VTBL_ENTRY)&_ZN6S693C53v36Ev,
  (VTBL_ENTRY)&_ZN6S693C53v37Ev,
  (VTBL_ENTRY)&_ZN6S693C53v38Ev,
  (VTBL_ENTRY)&_ZN6S693C53v39Ev,
  (VTBL_ENTRY)&_ZN6S693C53v40Ev,
  (VTBL_ENTRY)&_ZN6S693C53v41Ev,
  (VTBL_ENTRY)&_ZN6S693C53v42Ev,
  (VTBL_ENTRY)&_ZN6S693C53v43Ev,
  (VTBL_ENTRY)&_ZN6S693C53v44Ev,
  (VTBL_ENTRY)&_ZN6S693C53v45Ev,
  (VTBL_ENTRY)&_ZN6S693C53v46Ev,
  (VTBL_ENTRY)&_ZN6S693C53v47Ev,
  (VTBL_ENTRY)&_ZN6S693C53v48Ev,
  (VTBL_ENTRY)&_ZN6S693C53v49Ev,
  (VTBL_ENTRY)&_ZN6S693C53v50Ev,
  (VTBL_ENTRY)&_ZN6S693C53v51Ev,
  (VTBL_ENTRY)&_ZN6S693C53v52Ev,
  (VTBL_ENTRY)&_ZN6S693C53v53Ev,
  (VTBL_ENTRY)&_ZN6S693C53v54Ev,
  (VTBL_ENTRY)&_ZN6S693C53v55Ev,
  (VTBL_ENTRY)&_ZN6S693C53v56Ev,
  (VTBL_ENTRY)&_ZN6S693C53v57Ev,
  (VTBL_ENTRY)&_ZN6S693C53v58Ev,
  (VTBL_ENTRY)&_ZN6S693C53v59Ev,
  (VTBL_ENTRY)&_ZN6S693C53v60Ev,
  (VTBL_ENTRY)&_ZN6S693C53v61Ev,
  (VTBL_ENTRY)&_ZN6S693C53v62Ev,
  (VTBL_ENTRY)&_ZN6S693C53v63Ev,
  (VTBL_ENTRY)&_ZN6S693C53v64Ev,
  (VTBL_ENTRY)&_ZN6S693C53v65Ev,
  (VTBL_ENTRY)&_ZN6S693C53v66Ev,
  (VTBL_ENTRY)&_ZN6S693C53v67Ev,
  (VTBL_ENTRY)&_ZN6S693C53v68Ev,
  (VTBL_ENTRY)&_ZN6S693C53v69Ev,
  (VTBL_ENTRY)&_ZN6S693C53v70Ev,
  (VTBL_ENTRY)&_ZN6S693C43v71Ev,
  (VTBL_ENTRY)&_ZN6S693C43v72Ev,
  (VTBL_ENTRY)&_ZN6S693C43v73Ev,
  (VTBL_ENTRY)&_ZN6S693C43v74Ev,
  (VTBL_ENTRY)&_ZN6S693C43v75Ev,
  (VTBL_ENTRY)&_ZN6S693C43v76Ev,
  (VTBL_ENTRY)&_ZN6S693C43v77Ev,
  (VTBL_ENTRY)&_ZN6S693C43v78Ev,
  (VTBL_ENTRY)&_ZN6S693C43v79Ev,
  (VTBL_ENTRY)&_ZN6S693C43v80Ev,
  (VTBL_ENTRY)&_ZN6S693C43v81Ev,
  (VTBL_ENTRY)&_ZN6S693C43v82Ev,
  (VTBL_ENTRY)&_ZN6S693C43v83Ev,
  (VTBL_ENTRY)&_ZN6S693C43v84Ev,
  (VTBL_ENTRY)&_ZN6S693C43v85Ev,
  (VTBL_ENTRY)&_ZN6S693C43v86Ev,
  (VTBL_ENTRY)&_ZN6S693C43v87Ev,
  (VTBL_ENTRY)&_ZN6S693C43v88Ev,
  (VTBL_ENTRY)&_ZN6S693C43v89Ev,
  (VTBL_ENTRY)&_ZN6S693C43v90Ev,
  (VTBL_ENTRY)&_ZN6S693C33v91Ev,
  (VTBL_ENTRY)&_ZN6S693C33v92Ev,
  (VTBL_ENTRY)&_ZN6S693C33v93Ev,
  (VTBL_ENTRY)&_ZN6S693C33v94Ev,
  (VTBL_ENTRY)&_ZN6S693C33v95Ev,
  (VTBL_ENTRY)&_ZN6S693C33v96Ev,
  (VTBL_ENTRY)&_ZN6S693C33v97Ev,
  (VTBL_ENTRY)&_ZN6S693C33v98Ev,
  (VTBL_ENTRY)&_ZN6S693C33v99Ev,
  (VTBL_ENTRY)&_ZN6S693C24v100Ev,
  (VTBL_ENTRY)&_ZN6S693C24v101Ev,
  (VTBL_ENTRY)&_ZN6S693C24v102Ev,
  (VTBL_ENTRY)&_ZN6S693C24v103Ev,
  (VTBL_ENTRY)&_ZN6S693C24v104Ev,
  (VTBL_ENTRY)&_ZN6S693C24v105Ev,
  (VTBL_ENTRY)&_ZN6S693C12v1Ev,
  (VTBL_ENTRY)&_ZN6S693C12v2Ev,
  (VTBL_ENTRY)&_ZN6S693C12v3Ev,
  (VTBL_ENTRY)&_ZN6S693C12v4Ev,
  (VTBL_ENTRY)&_ZN6S693C12v5Ev,
  (VTBL_ENTRY)&_ZN6S693C12v6Ev,
};
extern VTBL_ENTRY _ZTI6S693C1[];
extern  VTBL_ENTRY _ZTV6S693C1[];
Class_Descriptor cd_S693C1 = {  "S693C1", // class name
  bases_S693C1, 4,
  &(vtc_S693C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(472,336), // object size
  NSPAIRA(_ZTI6S693C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S693C1),109, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1289C4  {
  int s1289c4f0;
  __tsi64 s1289c4f1;
  void *s1289c4f2[4];
  int s1289c4f3[2];
  void *s1289c4f4;
  ::S674C6_nt s1289c4f5;
  void *s1289c4f6[2];
  virtual  ~S1289C4(); // _ZN7S1289C4D1Ev
  virtual void  v10(); // _ZN7S1289C43v10Ev
  virtual void  v11(); // _ZN7S1289C43v11Ev
  virtual void  v12(); // _ZN7S1289C43v12Ev
  virtual void  v13(); // _ZN7S1289C43v13Ev
  virtual void  v14(); // _ZN7S1289C43v14Ev
  virtual void  v15(); // _ZN7S1289C43v15Ev
  virtual void  v16(); // _ZN7S1289C43v16Ev
  virtual void  v17(); // _ZN7S1289C43v17Ev
  virtual void  v18(); // _ZN7S1289C43v18Ev
  virtual void  v19(); // _ZN7S1289C43v19Ev
  virtual void  v20(); // _ZN7S1289C43v20Ev
  virtual void  v21(); // _ZN7S1289C43v21Ev
  virtual void  v22(); // _ZN7S1289C43v22Ev
  virtual void  v23(); // _ZN7S1289C43v23Ev
  virtual void  v24(); // _ZN7S1289C43v24Ev
  virtual void  v25(); // _ZN7S1289C43v25Ev
  virtual void  v26(); // _ZN7S1289C43v26Ev
  virtual void  v27(); // _ZN7S1289C43v27Ev
  virtual void  v28(); // _ZN7S1289C43v28Ev
  virtual void  v29(); // _ZN7S1289C43v29Ev
  virtual void  v30(); // _ZN7S1289C43v30Ev
  virtual void  v31(); // _ZN7S1289C43v31Ev
  virtual void  v32(); // _ZN7S1289C43v32Ev
  virtual void  v33(); // _ZN7S1289C43v33Ev
  virtual void  v34(); // _ZN7S1289C43v34Ev
  virtual void  v35(); // _ZN7S1289C43v35Ev
  virtual void  v36(); // _ZN7S1289C43v36Ev
  virtual void  v37(); // _ZN7S1289C43v37Ev
  virtual void  v38(); // _ZN7S1289C43v38Ev
  virtual void  v39(); // _ZN7S1289C43v39Ev
  virtual void  v40(); // _ZN7S1289C43v40Ev
  virtual void  v41(); // _ZN7S1289C43v41Ev
  virtual void  v42(); // _ZN7S1289C43v42Ev
  virtual void  v43(); // _ZN7S1289C43v43Ev
  virtual void  v44(); // _ZN7S1289C43v44Ev
  virtual void  v45(); // _ZN7S1289C43v45Ev
  virtual void  v46(); // _ZN7S1289C43v46Ev
  virtual void  v47(); // _ZN7S1289C43v47Ev
  virtual void  v48(); // _ZN7S1289C43v48Ev
  virtual void  v49(); // _ZN7S1289C43v49Ev
  virtual void  v50(); // _ZN7S1289C43v50Ev
  virtual void  v51(); // _ZN7S1289C43v51Ev
  virtual void  v52(); // _ZN7S1289C43v52Ev
  virtual void  v53(); // _ZN7S1289C43v53Ev
  virtual void  v54(); // _ZN7S1289C43v54Ev
  virtual void  v55(); // _ZN7S1289C43v55Ev
  virtual void  v56(); // _ZN7S1289C43v56Ev
  virtual void  v57(); // _ZN7S1289C43v57Ev
  virtual void  v58(); // _ZN7S1289C43v58Ev
  virtual void  v59(); // _ZN7S1289C43v59Ev
  virtual void  v60(); // _ZN7S1289C43v60Ev
  virtual void  v61(); // _ZN7S1289C43v61Ev
  virtual void  v62(); // _ZN7S1289C43v62Ev
  virtual void  v63(); // _ZN7S1289C43v63Ev
  virtual void  v64(); // _ZN7S1289C43v64Ev
  virtual void  v65(); // _ZN7S1289C43v65Ev
  virtual void  v66(); // _ZN7S1289C43v66Ev
  virtual void  v67(); // _ZN7S1289C43v67Ev
  virtual void  v68(); // _ZN7S1289C43v68Ev
  virtual void  v69(); // _ZN7S1289C43v69Ev
  virtual void  v70(); // _ZN7S1289C43v70Ev
  virtual void  v71(); // _ZN7S1289C43v71Ev
  virtual void  v72(); // _ZN7S1289C43v72Ev
  virtual void  v73(); // _ZN7S1289C43v73Ev
  S1289C4(); // tgen
};
//SIG(-1 S1289C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1289C4 ::~S1289C4(){ note_dtor("S1289C4", this);}
void  S1289C4 ::v10(){vfunc_called(this, "_ZN7S1289C43v10Ev");}
void  S1289C4 ::v11(){vfunc_called(this, "_ZN7S1289C43v11Ev");}
void  S1289C4 ::v12(){vfunc_called(this, "_ZN7S1289C43v12Ev");}
void  S1289C4 ::v13(){vfunc_called(this, "_ZN7S1289C43v13Ev");}
void  S1289C4 ::v14(){vfunc_called(this, "_ZN7S1289C43v14Ev");}
void  S1289C4 ::v15(){vfunc_called(this, "_ZN7S1289C43v15Ev");}
void  S1289C4 ::v16(){vfunc_called(this, "_ZN7S1289C43v16Ev");}
void  S1289C4 ::v17(){vfunc_called(this, "_ZN7S1289C43v17Ev");}
void  S1289C4 ::v18(){vfunc_called(this, "_ZN7S1289C43v18Ev");}
void  S1289C4 ::v19(){vfunc_called(this, "_ZN7S1289C43v19Ev");}
void  S1289C4 ::v20(){vfunc_called(this, "_ZN7S1289C43v20Ev");}
void  S1289C4 ::v21(){vfunc_called(this, "_ZN7S1289C43v21Ev");}
void  S1289C4 ::v22(){vfunc_called(this, "_ZN7S1289C43v22Ev");}
void  S1289C4 ::v23(){vfunc_called(this, "_ZN7S1289C43v23Ev");}
void  S1289C4 ::v24(){vfunc_called(this, "_ZN7S1289C43v24Ev");}
void  S1289C4 ::v25(){vfunc_called(this, "_ZN7S1289C43v25Ev");}
void  S1289C4 ::v26(){vfunc_called(this, "_ZN7S1289C43v26Ev");}
void  S1289C4 ::v27(){vfunc_called(this, "_ZN7S1289C43v27Ev");}
void  S1289C4 ::v28(){vfunc_called(this, "_ZN7S1289C43v28Ev");}
void  S1289C4 ::v29(){vfunc_called(this, "_ZN7S1289C43v29Ev");}
void  S1289C4 ::v30(){vfunc_called(this, "_ZN7S1289C43v30Ev");}
void  S1289C4 ::v31(){vfunc_called(this, "_ZN7S1289C43v31Ev");}
void  S1289C4 ::v32(){vfunc_called(this, "_ZN7S1289C43v32Ev");}
void  S1289C4 ::v33(){vfunc_called(this, "_ZN7S1289C43v33Ev");}
void  S1289C4 ::v34(){vfunc_called(this, "_ZN7S1289C43v34Ev");}
void  S1289C4 ::v35(){vfunc_called(this, "_ZN7S1289C43v35Ev");}
void  S1289C4 ::v36(){vfunc_called(this, "_ZN7S1289C43v36Ev");}
void  S1289C4 ::v37(){vfunc_called(this, "_ZN7S1289C43v37Ev");}
void  S1289C4 ::v38(){vfunc_called(this, "_ZN7S1289C43v38Ev");}
void  S1289C4 ::v39(){vfunc_called(this, "_ZN7S1289C43v39Ev");}
void  S1289C4 ::v40(){vfunc_called(this, "_ZN7S1289C43v40Ev");}
void  S1289C4 ::v41(){vfunc_called(this, "_ZN7S1289C43v41Ev");}
void  S1289C4 ::v42(){vfunc_called(this, "_ZN7S1289C43v42Ev");}
void  S1289C4 ::v43(){vfunc_called(this, "_ZN7S1289C43v43Ev");}
void  S1289C4 ::v44(){vfunc_called(this, "_ZN7S1289C43v44Ev");}
void  S1289C4 ::v45(){vfunc_called(this, "_ZN7S1289C43v45Ev");}
void  S1289C4 ::v46(){vfunc_called(this, "_ZN7S1289C43v46Ev");}
void  S1289C4 ::v47(){vfunc_called(this, "_ZN7S1289C43v47Ev");}
void  S1289C4 ::v48(){vfunc_called(this, "_ZN7S1289C43v48Ev");}
void  S1289C4 ::v49(){vfunc_called(this, "_ZN7S1289C43v49Ev");}
void  S1289C4 ::v50(){vfunc_called(this, "_ZN7S1289C43v50Ev");}
void  S1289C4 ::v51(){vfunc_called(this, "_ZN7S1289C43v51Ev");}
void  S1289C4 ::v52(){vfunc_called(this, "_ZN7S1289C43v52Ev");}
void  S1289C4 ::v53(){vfunc_called(this, "_ZN7S1289C43v53Ev");}
void  S1289C4 ::v54(){vfunc_called(this, "_ZN7S1289C43v54Ev");}
void  S1289C4 ::v55(){vfunc_called(this, "_ZN7S1289C43v55Ev");}
void  S1289C4 ::v56(){vfunc_called(this, "_ZN7S1289C43v56Ev");}
void  S1289C4 ::v57(){vfunc_called(this, "_ZN7S1289C43v57Ev");}
void  S1289C4 ::v58(){vfunc_called(this, "_ZN7S1289C43v58Ev");}
void  S1289C4 ::v59(){vfunc_called(this, "_ZN7S1289C43v59Ev");}
void  S1289C4 ::v60(){vfunc_called(this, "_ZN7S1289C43v60Ev");}
void  S1289C4 ::v61(){vfunc_called(this, "_ZN7S1289C43v61Ev");}
void  S1289C4 ::v62(){vfunc_called(this, "_ZN7S1289C43v62Ev");}
void  S1289C4 ::v63(){vfunc_called(this, "_ZN7S1289C43v63Ev");}
void  S1289C4 ::v64(){vfunc_called(this, "_ZN7S1289C43v64Ev");}
void  S1289C4 ::v65(){vfunc_called(this, "_ZN7S1289C43v65Ev");}
void  S1289C4 ::v66(){vfunc_called(this, "_ZN7S1289C43v66Ev");}
void  S1289C4 ::v67(){vfunc_called(this, "_ZN7S1289C43v67Ev");}
void  S1289C4 ::v68(){vfunc_called(this, "_ZN7S1289C43v68Ev");}
void  S1289C4 ::v69(){vfunc_called(this, "_ZN7S1289C43v69Ev");}
void  S1289C4 ::v70(){vfunc_called(this, "_ZN7S1289C43v70Ev");}
void  S1289C4 ::v71(){vfunc_called(this, "_ZN7S1289C43v71Ev");}
void  S1289C4 ::v72(){vfunc_called(this, "_ZN7S1289C43v72Ev");}
void  S1289C4 ::v73(){vfunc_called(this, "_ZN7S1289C43v73Ev");}
S1289C4 ::S1289C4(){ note_ctor("S1289C4", this);} // tgen

static void Test_S1289C4()
{
  extern Class_Descriptor cd_S1289C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1289C4, buf);
    S1289C4 *dp, &lv = *(dp=new (buf) S1289C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1289C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1289C4)");
    check_field_offset(lv, s1289c4f0, ABISELECT(8,4), "S1289C4.s1289c4f0");
    check_field_offset(lv, s1289c4f1, ABISELECT(16,8), "S1289C4.s1289c4f1");
    check_field_offset(lv, s1289c4f2, ABISELECT(24,16), "S1289C4.s1289c4f2");
    check_field_offset(lv, s1289c4f3, ABISELECT(56,32), "S1289C4.s1289c4f3");
    check_field_offset(lv, s1289c4f4, ABISELECT(64,40), "S1289C4.s1289c4f4");
    check_field_offset(lv, s1289c4f5, ABISELECT(72,44), "S1289C4.s1289c4f5");
    check_field_offset(lv, s1289c4f6, ABISELECT(80,52), "S1289C4.s1289c4f6");
    test_class_info(&lv, &cd_S1289C4);
    dp->~S1289C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1289C4(Test_S1289C4, "S1289C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1289C4C1Ev();
extern void _ZN7S1289C4D1Ev();
Name_Map name_map_S1289C4[] = {
  NSPAIR(_ZN7S1289C4C1Ev),
  NSPAIR(_ZN7S1289C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1289C4[];
extern void _ZN7S1289C4D1Ev();
extern void _ZN7S1289C4D0Ev();
extern void _ZN7S1289C43v10Ev();
extern void _ZN7S1289C43v11Ev();
extern void _ZN7S1289C43v12Ev();
extern void _ZN7S1289C43v13Ev();
extern void _ZN7S1289C43v14Ev();
extern void _ZN7S1289C43v15Ev();
extern void _ZN7S1289C43v16Ev();
extern void _ZN7S1289C43v17Ev();
extern void _ZN7S1289C43v18Ev();
extern void _ZN7S1289C43v19Ev();
extern void _ZN7S1289C43v20Ev();
extern void _ZN7S1289C43v21Ev();
extern void _ZN7S1289C43v22Ev();
extern void _ZN7S1289C43v23Ev();
extern void _ZN7S1289C43v24Ev();
extern void _ZN7S1289C43v25Ev();
extern void _ZN7S1289C43v26Ev();
extern void _ZN7S1289C43v27Ev();
extern void _ZN7S1289C43v28Ev();
extern void _ZN7S1289C43v29Ev();
extern void _ZN7S1289C43v30Ev();
extern void _ZN7S1289C43v31Ev();
extern void _ZN7S1289C43v32Ev();
extern void _ZN7S1289C43v33Ev();
extern void _ZN7S1289C43v34Ev();
extern void _ZN7S1289C43v35Ev();
extern void _ZN7S1289C43v36Ev();
extern void _ZN7S1289C43v37Ev();
extern void _ZN7S1289C43v38Ev();
extern void _ZN7S1289C43v39Ev();
extern void _ZN7S1289C43v40Ev();
extern void _ZN7S1289C43v41Ev();
extern void _ZN7S1289C43v42Ev();
extern void _ZN7S1289C43v43Ev();
extern void _ZN7S1289C43v44Ev();
extern void _ZN7S1289C43v45Ev();
extern void _ZN7S1289C43v46Ev();
extern void _ZN7S1289C43v47Ev();
extern void _ZN7S1289C43v48Ev();
extern void _ZN7S1289C43v49Ev();
extern void _ZN7S1289C43v50Ev();
extern void _ZN7S1289C43v51Ev();
extern void _ZN7S1289C43v52Ev();
extern void _ZN7S1289C43v53Ev();
extern void _ZN7S1289C43v54Ev();
extern void _ZN7S1289C43v55Ev();
extern void _ZN7S1289C43v56Ev();
extern void _ZN7S1289C43v57Ev();
extern void _ZN7S1289C43v58Ev();
extern void _ZN7S1289C43v59Ev();
extern void _ZN7S1289C43v60Ev();
extern void _ZN7S1289C43v61Ev();
extern void _ZN7S1289C43v62Ev();
extern void _ZN7S1289C43v63Ev();
extern void _ZN7S1289C43v64Ev();
extern void _ZN7S1289C43v65Ev();
extern void _ZN7S1289C43v66Ev();
extern void _ZN7S1289C43v67Ev();
extern void _ZN7S1289C43v68Ev();
extern void _ZN7S1289C43v69Ev();
extern void _ZN7S1289C43v70Ev();
extern void _ZN7S1289C43v71Ev();
extern void _ZN7S1289C43v72Ev();
extern void _ZN7S1289C43v73Ev();
static  VTBL_ENTRY vtc_S1289C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1289C4[0]),
  (VTBL_ENTRY)&_ZN7S1289C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1289C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v73Ev,
};
extern VTBL_ENTRY _ZTI7S1289C4[];
extern  VTBL_ENTRY _ZTV7S1289C4[];
Class_Descriptor cd_S1289C4 = {  "S1289C4", // class name
  0,0,//no base classes
  &(vtc_S1289C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1289C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1289C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1289C3  : S1289C4 {
  unsigned int s1289c3f0:1;
  unsigned int s1289c3f1:1;
  unsigned int s1289c3f2:1;
  unsigned int s1289c3f3:1;
  unsigned int s1289c3f4:1;
  unsigned int s1289c3f5:1;
  unsigned int s1289c3f6:1;
  ::S3625C32 s1289c3f7;
  virtual  ~S1289C3(); // _ZN7S1289C3D1Ev
  virtual void  v74(); // _ZN7S1289C33v74Ev
  virtual void  v75(); // _ZN7S1289C33v75Ev
  virtual void  v76(); // _ZN7S1289C33v76Ev
  virtual void  v77(); // _ZN7S1289C33v77Ev
  virtual void  v78(); // _ZN7S1289C33v78Ev
  virtual void  v79(); // _ZN7S1289C33v79Ev
  virtual void  v80(); // _ZN7S1289C33v80Ev
  virtual void  v81(); // _ZN7S1289C33v81Ev
  virtual void  v82(); // _ZN7S1289C33v82Ev
  virtual void  v83(); // _ZN7S1289C33v83Ev
  virtual void  v84(); // _ZN7S1289C33v84Ev
  virtual void  v85(); // _ZN7S1289C33v85Ev
  virtual void  v86(); // _ZN7S1289C33v86Ev
  virtual void  v87(); // _ZN7S1289C33v87Ev
  virtual void  v88(); // _ZN7S1289C33v88Ev
  virtual void  v89(); // _ZN7S1289C33v89Ev
  virtual void  v90(); // _ZN7S1289C33v90Ev
  virtual void  v91(); // _ZN7S1289C33v91Ev
  virtual void  v92(); // _ZN7S1289C33v92Ev
  virtual void  v93(); // _ZN7S1289C33v93Ev
  S1289C3(); // tgen
};
//SIG(-1 S1289C3) C1{ BC2{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC4{ m}}


 S1289C3 ::~S1289C3(){ note_dtor("S1289C3", this);}
void  S1289C3 ::v74(){vfunc_called(this, "_ZN7S1289C33v74Ev");}
void  S1289C3 ::v75(){vfunc_called(this, "_ZN7S1289C33v75Ev");}
void  S1289C3 ::v76(){vfunc_called(this, "_ZN7S1289C33v76Ev");}
void  S1289C3 ::v77(){vfunc_called(this, "_ZN7S1289C33v77Ev");}
void  S1289C3 ::v78(){vfunc_called(this, "_ZN7S1289C33v78Ev");}
void  S1289C3 ::v79(){vfunc_called(this, "_ZN7S1289C33v79Ev");}
void  S1289C3 ::v80(){vfunc_called(this, "_ZN7S1289C33v80Ev");}
void  S1289C3 ::v81(){vfunc_called(this, "_ZN7S1289C33v81Ev");}
void  S1289C3 ::v82(){vfunc_called(this, "_ZN7S1289C33v82Ev");}
void  S1289C3 ::v83(){vfunc_called(this, "_ZN7S1289C33v83Ev");}
void  S1289C3 ::v84(){vfunc_called(this, "_ZN7S1289C33v84Ev");}
void  S1289C3 ::v85(){vfunc_called(this, "_ZN7S1289C33v85Ev");}
void  S1289C3 ::v86(){vfunc_called(this, "_ZN7S1289C33v86Ev");}
void  S1289C3 ::v87(){vfunc_called(this, "_ZN7S1289C33v87Ev");}
void  S1289C3 ::v88(){vfunc_called(this, "_ZN7S1289C33v88Ev");}
void  S1289C3 ::v89(){vfunc_called(this, "_ZN7S1289C33v89Ev");}
void  S1289C3 ::v90(){vfunc_called(this, "_ZN7S1289C33v90Ev");}
void  S1289C3 ::v91(){vfunc_called(this, "_ZN7S1289C33v91Ev");}
void  S1289C3 ::v92(){vfunc_called(this, "_ZN7S1289C33v92Ev");}
void  S1289C3 ::v93(){vfunc_called(this, "_ZN7S1289C33v93Ev");}
S1289C3 ::S1289C3(){ note_ctor("S1289C3", this);} // tgen

static void Test_S1289C3()
{
  extern Class_Descriptor cd_S1289C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S1289C3, buf);
    S1289C3 *dp, &lv = *(dp=new (buf) S1289C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S1289C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1289C3)");
    check_base_class_offset(lv, (S1289C4*), 0, "S1289C3");
    set_bf_and_test(lv, s1289c3f0, ABISELECT(96,60), 0, 1, 1, "S1289C3");
    set_bf_and_test(lv, s1289c3f1, ABISELECT(96,60), 1, 1, 1, "S1289C3");
    set_bf_and_test(lv, s1289c3f2, ABISELECT(96,60), 2, 1, 1, "S1289C3");
    set_bf_and_test(lv, s1289c3f3, ABISELECT(96,60), 3, 1, 1, "S1289C3");
    set_bf_and_test(lv, s1289c3f4, ABISELECT(96,60), 4, 1, 1, "S1289C3");
    set_bf_and_test(lv, s1289c3f5, ABISELECT(96,60), 5, 1, 1, "S1289C3");
    set_bf_and_test(lv, s1289c3f6, ABISELECT(96,60), 6, 1, 1, "S1289C3");
    check_field_offset(lv, s1289c3f7, ABISELECT(97,61), "S1289C3.s1289c3f7");
    test_class_info(&lv, &cd_S1289C3);
    dp->~S1289C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1289C3(Test_S1289C3, "S1289C3", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN7S1289C3C1Ev();
extern void _ZN7S1289C3D1Ev();
Name_Map name_map_S1289C3[] = {
  NSPAIR(_ZN7S1289C3C1Ev),
  NSPAIR(_ZN7S1289C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1289C4;
extern VTBL_ENTRY _ZTI7S1289C4[];
extern  VTBL_ENTRY _ZTV7S1289C4[];
static Base_Class bases_S1289C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1289C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1289C3[];
extern void _ZN7S1289C3D1Ev();
extern void _ZN7S1289C3D0Ev();
extern void _ZN7S1289C43v10Ev();
extern void _ZN7S1289C43v11Ev();
extern void _ZN7S1289C43v12Ev();
extern void _ZN7S1289C43v13Ev();
extern void _ZN7S1289C43v14Ev();
extern void _ZN7S1289C43v15Ev();
extern void _ZN7S1289C43v16Ev();
extern void _ZN7S1289C43v17Ev();
extern void _ZN7S1289C43v18Ev();
extern void _ZN7S1289C43v19Ev();
extern void _ZN7S1289C43v20Ev();
extern void _ZN7S1289C43v21Ev();
extern void _ZN7S1289C43v22Ev();
extern void _ZN7S1289C43v23Ev();
extern void _ZN7S1289C43v24Ev();
extern void _ZN7S1289C43v25Ev();
extern void _ZN7S1289C43v26Ev();
extern void _ZN7S1289C43v27Ev();
extern void _ZN7S1289C43v28Ev();
extern void _ZN7S1289C43v29Ev();
extern void _ZN7S1289C43v30Ev();
extern void _ZN7S1289C43v31Ev();
extern void _ZN7S1289C43v32Ev();
extern void _ZN7S1289C43v33Ev();
extern void _ZN7S1289C43v34Ev();
extern void _ZN7S1289C43v35Ev();
extern void _ZN7S1289C43v36Ev();
extern void _ZN7S1289C43v37Ev();
extern void _ZN7S1289C43v38Ev();
extern void _ZN7S1289C43v39Ev();
extern void _ZN7S1289C43v40Ev();
extern void _ZN7S1289C43v41Ev();
extern void _ZN7S1289C43v42Ev();
extern void _ZN7S1289C43v43Ev();
extern void _ZN7S1289C43v44Ev();
extern void _ZN7S1289C43v45Ev();
extern void _ZN7S1289C43v46Ev();
extern void _ZN7S1289C43v47Ev();
extern void _ZN7S1289C43v48Ev();
extern void _ZN7S1289C43v49Ev();
extern void _ZN7S1289C43v50Ev();
extern void _ZN7S1289C43v51Ev();
extern void _ZN7S1289C43v52Ev();
extern void _ZN7S1289C43v53Ev();
extern void _ZN7S1289C43v54Ev();
extern void _ZN7S1289C43v55Ev();
extern void _ZN7S1289C43v56Ev();
extern void _ZN7S1289C43v57Ev();
extern void _ZN7S1289C43v58Ev();
extern void _ZN7S1289C43v59Ev();
extern void _ZN7S1289C43v60Ev();
extern void _ZN7S1289C43v61Ev();
extern void _ZN7S1289C43v62Ev();
extern void _ZN7S1289C43v63Ev();
extern void _ZN7S1289C43v64Ev();
extern void _ZN7S1289C43v65Ev();
extern void _ZN7S1289C43v66Ev();
extern void _ZN7S1289C43v67Ev();
extern void _ZN7S1289C43v68Ev();
extern void _ZN7S1289C43v69Ev();
extern void _ZN7S1289C43v70Ev();
extern void _ZN7S1289C43v71Ev();
extern void _ZN7S1289C43v72Ev();
extern void _ZN7S1289C43v73Ev();
extern void _ZN7S1289C33v74Ev();
extern void _ZN7S1289C33v75Ev();
extern void _ZN7S1289C33v76Ev();
extern void _ZN7S1289C33v77Ev();
extern void _ZN7S1289C33v78Ev();
extern void _ZN7S1289C33v79Ev();
extern void _ZN7S1289C33v80Ev();
extern void _ZN7S1289C33v81Ev();
extern void _ZN7S1289C33v82Ev();
extern void _ZN7S1289C33v83Ev();
extern void _ZN7S1289C33v84Ev();
extern void _ZN7S1289C33v85Ev();
extern void _ZN7S1289C33v86Ev();
extern void _ZN7S1289C33v87Ev();
extern void _ZN7S1289C33v88Ev();
extern void _ZN7S1289C33v89Ev();
extern void _ZN7S1289C33v90Ev();
extern void _ZN7S1289C33v91Ev();
extern void _ZN7S1289C33v92Ev();
extern void _ZN7S1289C33v93Ev();
static  VTBL_ENTRY vtc_S1289C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1289C3[0]),
  (VTBL_ENTRY)&_ZN7S1289C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1289C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v93Ev,
};
extern VTBL_ENTRY _ZTI7S1289C3[];
extern  VTBL_ENTRY _ZTV7S1289C3[];
Class_Descriptor cd_S1289C3 = {  "S1289C3", // class name
  bases_S1289C3, 1,
  &(vtc_S1289C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI7S1289C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1289C3),88, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1289C2  : S1289C3 {
  ::S674C42 s1289c2f0;
  virtual  ~S1289C2(); // _ZN7S1289C2D1Ev
  virtual void  v94(); // _ZN7S1289C23v94Ev
  virtual void  v95(); // _ZN7S1289C23v95Ev
  virtual void  v96(); // _ZN7S1289C23v96Ev
  virtual void  v97(); // _ZN7S1289C23v97Ev
  S1289C2(); // tgen
};
//SIG(-1 S1289C2) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC5{ m}} vd v1 v2 v3 v4 FC6{ BC7{ BC8{ m Fp Fi[2]}}}}


 S1289C2 ::~S1289C2(){ note_dtor("S1289C2", this);}
void  S1289C2 ::v94(){vfunc_called(this, "_ZN7S1289C23v94Ev");}
void  S1289C2 ::v95(){vfunc_called(this, "_ZN7S1289C23v95Ev");}
void  S1289C2 ::v96(){vfunc_called(this, "_ZN7S1289C23v96Ev");}
void  S1289C2 ::v97(){vfunc_called(this, "_ZN7S1289C23v97Ev");}
S1289C2 ::S1289C2(){ note_ctor("S1289C2", this);} // tgen

static void Test_S1289C2()
{
  extern Class_Descriptor cd_S1289C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(16,20)];
    init_test(&cd_S1289C2, buf);
    S1289C2 *dp, &lv = *(dp=new (buf) S1289C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(120,76), "sizeof(S1289C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1289C2)");
    check_base_class_offset(lv, (S1289C4*)(S1289C3*), 0, "S1289C2");
    check_base_class_offset(lv, (S1289C3*), 0, "S1289C2");
    check_field_offset(lv, s1289c2f0, ABISELECT(104,64), "S1289C2.s1289c2f0");
    test_class_info(&lv, &cd_S1289C2);
    dp->~S1289C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1289C2(Test_S1289C2, "S1289C2", ABISELECT(120,76));

#else // __cplusplus

extern void _ZN7S1289C2C1Ev();
extern void _ZN7S1289C2D1Ev();
Name_Map name_map_S1289C2[] = {
  NSPAIR(_ZN7S1289C2C1Ev),
  NSPAIR(_ZN7S1289C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1289C4;
extern VTBL_ENTRY _ZTI7S1289C4[];
extern  VTBL_ENTRY _ZTV7S1289C4[];
extern Class_Descriptor cd_S1289C3;
extern VTBL_ENTRY _ZTI7S1289C3[];
extern  VTBL_ENTRY _ZTV7S1289C3[];
static Base_Class bases_S1289C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1289C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1289C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1289C2[];
extern void _ZN7S1289C2D1Ev();
extern void _ZN7S1289C2D0Ev();
extern void _ZN7S1289C43v10Ev();
extern void _ZN7S1289C43v11Ev();
extern void _ZN7S1289C43v12Ev();
extern void _ZN7S1289C43v13Ev();
extern void _ZN7S1289C43v14Ev();
extern void _ZN7S1289C43v15Ev();
extern void _ZN7S1289C43v16Ev();
extern void _ZN7S1289C43v17Ev();
extern void _ZN7S1289C43v18Ev();
extern void _ZN7S1289C43v19Ev();
extern void _ZN7S1289C43v20Ev();
extern void _ZN7S1289C43v21Ev();
extern void _ZN7S1289C43v22Ev();
extern void _ZN7S1289C43v23Ev();
extern void _ZN7S1289C43v24Ev();
extern void _ZN7S1289C43v25Ev();
extern void _ZN7S1289C43v26Ev();
extern void _ZN7S1289C43v27Ev();
extern void _ZN7S1289C43v28Ev();
extern void _ZN7S1289C43v29Ev();
extern void _ZN7S1289C43v30Ev();
extern void _ZN7S1289C43v31Ev();
extern void _ZN7S1289C43v32Ev();
extern void _ZN7S1289C43v33Ev();
extern void _ZN7S1289C43v34Ev();
extern void _ZN7S1289C43v35Ev();
extern void _ZN7S1289C43v36Ev();
extern void _ZN7S1289C43v37Ev();
extern void _ZN7S1289C43v38Ev();
extern void _ZN7S1289C43v39Ev();
extern void _ZN7S1289C43v40Ev();
extern void _ZN7S1289C43v41Ev();
extern void _ZN7S1289C43v42Ev();
extern void _ZN7S1289C43v43Ev();
extern void _ZN7S1289C43v44Ev();
extern void _ZN7S1289C43v45Ev();
extern void _ZN7S1289C43v46Ev();
extern void _ZN7S1289C43v47Ev();
extern void _ZN7S1289C43v48Ev();
extern void _ZN7S1289C43v49Ev();
extern void _ZN7S1289C43v50Ev();
extern void _ZN7S1289C43v51Ev();
extern void _ZN7S1289C43v52Ev();
extern void _ZN7S1289C43v53Ev();
extern void _ZN7S1289C43v54Ev();
extern void _ZN7S1289C43v55Ev();
extern void _ZN7S1289C43v56Ev();
extern void _ZN7S1289C43v57Ev();
extern void _ZN7S1289C43v58Ev();
extern void _ZN7S1289C43v59Ev();
extern void _ZN7S1289C43v60Ev();
extern void _ZN7S1289C43v61Ev();
extern void _ZN7S1289C43v62Ev();
extern void _ZN7S1289C43v63Ev();
extern void _ZN7S1289C43v64Ev();
extern void _ZN7S1289C43v65Ev();
extern void _ZN7S1289C43v66Ev();
extern void _ZN7S1289C43v67Ev();
extern void _ZN7S1289C43v68Ev();
extern void _ZN7S1289C43v69Ev();
extern void _ZN7S1289C43v70Ev();
extern void _ZN7S1289C43v71Ev();
extern void _ZN7S1289C43v72Ev();
extern void _ZN7S1289C43v73Ev();
extern void _ZN7S1289C33v74Ev();
extern void _ZN7S1289C33v75Ev();
extern void _ZN7S1289C33v76Ev();
extern void _ZN7S1289C33v77Ev();
extern void _ZN7S1289C33v78Ev();
extern void _ZN7S1289C33v79Ev();
extern void _ZN7S1289C33v80Ev();
extern void _ZN7S1289C33v81Ev();
extern void _ZN7S1289C33v82Ev();
extern void _ZN7S1289C33v83Ev();
extern void _ZN7S1289C33v84Ev();
extern void _ZN7S1289C33v85Ev();
extern void _ZN7S1289C33v86Ev();
extern void _ZN7S1289C33v87Ev();
extern void _ZN7S1289C33v88Ev();
extern void _ZN7S1289C33v89Ev();
extern void _ZN7S1289C33v90Ev();
extern void _ZN7S1289C33v91Ev();
extern void _ZN7S1289C33v92Ev();
extern void _ZN7S1289C33v93Ev();
extern void _ZN7S1289C23v94Ev();
extern void _ZN7S1289C23v95Ev();
extern void _ZN7S1289C23v96Ev();
extern void _ZN7S1289C23v97Ev();
static  VTBL_ENTRY vtc_S1289C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1289C2[0]),
  (VTBL_ENTRY)&_ZN7S1289C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1289C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1289C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1289C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1289C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1289C23v97Ev,
};
extern VTBL_ENTRY _ZTI7S1289C2[];
extern  VTBL_ENTRY _ZTV7S1289C2[];
Class_Descriptor cd_S1289C2 = {  "S1289C2", // class name
  bases_S1289C2, 2,
  &(vtc_S1289C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(120,76), // object size
  NSPAIRA(_ZTI7S1289C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1289C2),92, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1289C11_nt  {
  char s1289c11f0[4];
  ::S674C38 s1289c11f1;
  int s1289c11f2[2];
  void  mf1289c11(); // _ZN11S1289C11_nt9mf1289c11Ev
};
//SIG(-1 S1289C11_nt) C1{ m Fc[4] FC2{ BC3{ BC4{ m Fp Fi[2]}}} Fi[2]}


void  S1289C11_nt ::mf1289c11(){}

//skip512 S1289C11_nt

#else // __cplusplus

Class_Descriptor cd_S1289C11_nt = {  "S1289C11_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1289C10_nt  : S1289C11_nt {
  void *s1289c10f0;
};
//SIG(-1 S1289C10_nt) C1{ BC2{ m Fc[4] FC3{ BC4{ BC5{ m Fp Fi[2]}}} Fi[2]} Fp}



//skip512 S1289C10_nt

#else // __cplusplus

extern Class_Descriptor cd_S1289C11_nt;
static Base_Class bases_S1289C10_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1289C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1289C1  : S1289C2 {
  ::S1289C10_nt s1289c1f0;
  ::S1289C10_nt s1289c1f1;
  ::S1289C10_nt s1289c1f2;
  unsigned int s1289c1f3:1;
  unsigned int s1289c1f4:1;
  unsigned int s1289c1f5:1;
  unsigned int s1289c1f6:1;
  unsigned int s1289c1f7:1;
  unsigned int s1289c1f8:1;
  unsigned int s1289c1f9:1;
  unsigned int s1289c1f10:1;
  unsigned int s1289c1f11:1;
  unsigned int s1289c1f12:1;
  unsigned int s1289c1f13:1;
  unsigned int s1289c1f14:1;
  unsigned int s1289c1f15:1;
  unsigned int s1289c1f16:1;
  ::S1289C10_nt s1289c1f17;
  ::S1289C10_nt s1289c1f18;
  ::S1289C10_nt s1289c1f19;
  ::S1289C10_nt s1289c1f20;
  ::S1289C10_nt s1289c1f21;
  char s1289c1f22;
  ::S1289C10_nt s1289c1f23;
  ::S1289C10_nt s1289c1f24;
  virtual  ~S1289C1(); // _ZN7S1289C1D1Ev
  virtual void  v1(); // _ZN7S1289C12v1Ev
  virtual void  v2(); // _ZN7S1289C12v2Ev
  virtual void  v3(); // _ZN7S1289C12v3Ev
  virtual void  v4(); // _ZN7S1289C12v4Ev
  virtual void  v5(); // _ZN7S1289C12v5Ev
  virtual void  v6(); // _ZN7S1289C12v6Ev
  virtual void  v7(); // _ZN7S1289C12v7Ev
  virtual void  v8(); // _ZN7S1289C12v8Ev
  virtual void  v9(); // _ZN7S1289C12v9Ev
  S1289C1(); // tgen
};
//SIG(1 S1289C1) C1{ BC2{ BC3{ BC4{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC6{ m}} vd v94 v95 v96 v97 FC7{ BC8{ BC9{ m Fp Fi[2]}}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 FC10{ BC11{ m Fc[4] FC12{ BC13{ BC9}} Fi[2]} Fp} FC10 FC10 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC10 FC10 FC10 FC10 FC10 Fc FC10 FC10}


 S1289C1 ::~S1289C1(){ note_dtor("S1289C1", this);}
void  S1289C1 ::v1(){vfunc_called(this, "_ZN7S1289C12v1Ev");}
void  S1289C1 ::v2(){vfunc_called(this, "_ZN7S1289C12v2Ev");}
void  S1289C1 ::v3(){vfunc_called(this, "_ZN7S1289C12v3Ev");}
void  S1289C1 ::v4(){vfunc_called(this, "_ZN7S1289C12v4Ev");}
void  S1289C1 ::v5(){vfunc_called(this, "_ZN7S1289C12v5Ev");}
void  S1289C1 ::v6(){vfunc_called(this, "_ZN7S1289C12v6Ev");}
void  S1289C1 ::v7(){vfunc_called(this, "_ZN7S1289C12v7Ev");}
void  S1289C1 ::v8(){vfunc_called(this, "_ZN7S1289C12v8Ev");}
void  S1289C1 ::v9(){vfunc_called(this, "_ZN7S1289C12v9Ev");}
S1289C1 ::S1289C1(){ note_ctor("S1289C1", this);} // tgen

static void Test_S1289C1()
{
  extern Class_Descriptor cd_S1289C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(68,92)];
    init_test(&cd_S1289C1, buf);
    S1289C1 *dp, &lv = *(dp=new (buf) S1289C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(536,364), "sizeof(S1289C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1289C1)");
    check_base_class_offset(lv, (S1289C4*)(S1289C3*)(S1289C2*), 0, "S1289C1");
    check_base_class_offset(lv, (S1289C3*)(S1289C2*), 0, "S1289C1");
    check_base_class_offset(lv, (S1289C2*), 0, "S1289C1");
    check_field_offset(lv, s1289c1f0, ABISELECT(120,76), "S1289C1.s1289c1f0");
    check_field_offset(lv, s1289c1f1, ABISELECT(160,104), "S1289C1.s1289c1f1");
    check_field_offset(lv, s1289c1f2, ABISELECT(200,132), "S1289C1.s1289c1f2");
    set_bf_and_test(lv, s1289c1f3, ABISELECT(240,160), 0, 1, 1, "S1289C1");
    set_bf_and_test(lv, s1289c1f4, ABISELECT(240,160), 1, 1, 1, "S1289C1");
    set_bf_and_test(lv, s1289c1f5, ABISELECT(240,160), 2, 1, 1, "S1289C1");
    set_bf_and_test(lv, s1289c1f6, ABISELECT(240,160), 3, 1, 1, "S1289C1");
    set_bf_and_test(lv, s1289c1f7, ABISELECT(240,160), 4, 1, 1, "S1289C1");
    set_bf_and_test(lv, s1289c1f8, ABISELECT(240,160), 5, 1, 1, "S1289C1");
    set_bf_and_test(lv, s1289c1f9, ABISELECT(240,160), 6, 1, 1, "S1289C1");
    set_bf_and_test(lv, s1289c1f10, ABISELECT(240,160), 7, 1, 1, "S1289C1");
    set_bf_and_test(lv, s1289c1f11, ABISELECT(241,161), 0, 1, 1, "S1289C1");
    set_bf_and_test(lv, s1289c1f12, ABISELECT(241,161), 1, 1, 1, "S1289C1");
    set_bf_and_test(lv, s1289c1f13, ABISELECT(241,161), 2, 1, 1, "S1289C1");
    set_bf_and_test(lv, s1289c1f14, ABISELECT(241,161), 3, 1, 1, "S1289C1");
    set_bf_and_test(lv, s1289c1f15, ABISELECT(241,161), 4, 1, 1, "S1289C1");
    set_bf_and_test(lv, s1289c1f16, ABISELECT(241,161), 5, 1, 1, "S1289C1");
    check_field_offset(lv, s1289c1f17, ABISELECT(248,164), "S1289C1.s1289c1f17");
    check_field_offset(lv, s1289c1f18, ABISELECT(288,192), "S1289C1.s1289c1f18");
    check_field_offset(lv, s1289c1f19, ABISELECT(328,220), "S1289C1.s1289c1f19");
    check_field_offset(lv, s1289c1f20, ABISELECT(368,248), "S1289C1.s1289c1f20");
    check_field_offset(lv, s1289c1f21, ABISELECT(408,276), "S1289C1.s1289c1f21");
    check_field_offset(lv, s1289c1f22, ABISELECT(448,304), "S1289C1.s1289c1f22");
    check_field_offset(lv, s1289c1f23, ABISELECT(456,308), "S1289C1.s1289c1f23");
    check_field_offset(lv, s1289c1f24, ABISELECT(496,336), "S1289C1.s1289c1f24");
    test_class_info(&lv, &cd_S1289C1);
    dp->~S1289C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1289C1(Test_S1289C1, "S1289C1", ABISELECT(536,364));

#else // __cplusplus

extern void _ZN7S1289C1C1Ev();
extern void _ZN7S1289C1D1Ev();
Name_Map name_map_S1289C1[] = {
  NSPAIR(_ZN7S1289C1C1Ev),
  NSPAIR(_ZN7S1289C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1289C4;
extern VTBL_ENTRY _ZTI7S1289C4[];
extern  VTBL_ENTRY _ZTV7S1289C4[];
extern Class_Descriptor cd_S1289C3;
extern VTBL_ENTRY _ZTI7S1289C3[];
extern  VTBL_ENTRY _ZTV7S1289C3[];
extern Class_Descriptor cd_S1289C2;
extern VTBL_ENTRY _ZTI7S1289C2[];
extern  VTBL_ENTRY _ZTV7S1289C2[];
static Base_Class bases_S1289C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1289C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1289C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1289C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1289C1[];
extern void _ZN7S1289C1D1Ev();
extern void _ZN7S1289C1D0Ev();
extern void _ZN7S1289C43v10Ev();
extern void _ZN7S1289C43v11Ev();
extern void _ZN7S1289C43v12Ev();
extern void _ZN7S1289C43v13Ev();
extern void _ZN7S1289C43v14Ev();
extern void _ZN7S1289C43v15Ev();
extern void _ZN7S1289C43v16Ev();
extern void _ZN7S1289C43v17Ev();
extern void _ZN7S1289C43v18Ev();
extern void _ZN7S1289C43v19Ev();
extern void _ZN7S1289C43v20Ev();
extern void _ZN7S1289C43v21Ev();
extern void _ZN7S1289C43v22Ev();
extern void _ZN7S1289C43v23Ev();
extern void _ZN7S1289C43v24Ev();
extern void _ZN7S1289C43v25Ev();
extern void _ZN7S1289C43v26Ev();
extern void _ZN7S1289C43v27Ev();
extern void _ZN7S1289C43v28Ev();
extern void _ZN7S1289C43v29Ev();
extern void _ZN7S1289C43v30Ev();
extern void _ZN7S1289C43v31Ev();
extern void _ZN7S1289C43v32Ev();
extern void _ZN7S1289C43v33Ev();
extern void _ZN7S1289C43v34Ev();
extern void _ZN7S1289C43v35Ev();
extern void _ZN7S1289C43v36Ev();
extern void _ZN7S1289C43v37Ev();
extern void _ZN7S1289C43v38Ev();
extern void _ZN7S1289C43v39Ev();
extern void _ZN7S1289C43v40Ev();
extern void _ZN7S1289C43v41Ev();
extern void _ZN7S1289C43v42Ev();
extern void _ZN7S1289C43v43Ev();
extern void _ZN7S1289C43v44Ev();
extern void _ZN7S1289C43v45Ev();
extern void _ZN7S1289C43v46Ev();
extern void _ZN7S1289C43v47Ev();
extern void _ZN7S1289C43v48Ev();
extern void _ZN7S1289C43v49Ev();
extern void _ZN7S1289C43v50Ev();
extern void _ZN7S1289C43v51Ev();
extern void _ZN7S1289C43v52Ev();
extern void _ZN7S1289C43v53Ev();
extern void _ZN7S1289C43v54Ev();
extern void _ZN7S1289C43v55Ev();
extern void _ZN7S1289C43v56Ev();
extern void _ZN7S1289C43v57Ev();
extern void _ZN7S1289C43v58Ev();
extern void _ZN7S1289C43v59Ev();
extern void _ZN7S1289C43v60Ev();
extern void _ZN7S1289C43v61Ev();
extern void _ZN7S1289C43v62Ev();
extern void _ZN7S1289C43v63Ev();
extern void _ZN7S1289C43v64Ev();
extern void _ZN7S1289C43v65Ev();
extern void _ZN7S1289C43v66Ev();
extern void _ZN7S1289C43v67Ev();
extern void _ZN7S1289C43v68Ev();
extern void _ZN7S1289C43v69Ev();
extern void _ZN7S1289C43v70Ev();
extern void _ZN7S1289C43v71Ev();
extern void _ZN7S1289C43v72Ev();
extern void _ZN7S1289C43v73Ev();
extern void _ZN7S1289C33v74Ev();
extern void _ZN7S1289C33v75Ev();
extern void _ZN7S1289C33v76Ev();
extern void _ZN7S1289C33v77Ev();
extern void _ZN7S1289C33v78Ev();
extern void _ZN7S1289C33v79Ev();
extern void _ZN7S1289C33v80Ev();
extern void _ZN7S1289C33v81Ev();
extern void _ZN7S1289C33v82Ev();
extern void _ZN7S1289C33v83Ev();
extern void _ZN7S1289C33v84Ev();
extern void _ZN7S1289C33v85Ev();
extern void _ZN7S1289C33v86Ev();
extern void _ZN7S1289C33v87Ev();
extern void _ZN7S1289C33v88Ev();
extern void _ZN7S1289C33v89Ev();
extern void _ZN7S1289C33v90Ev();
extern void _ZN7S1289C33v91Ev();
extern void _ZN7S1289C33v92Ev();
extern void _ZN7S1289C33v93Ev();
extern void _ZN7S1289C23v94Ev();
extern void _ZN7S1289C23v95Ev();
extern void _ZN7S1289C23v96Ev();
extern void _ZN7S1289C23v97Ev();
extern void _ZN7S1289C12v1Ev();
extern void _ZN7S1289C12v2Ev();
extern void _ZN7S1289C12v3Ev();
extern void _ZN7S1289C12v4Ev();
extern void _ZN7S1289C12v5Ev();
extern void _ZN7S1289C12v6Ev();
extern void _ZN7S1289C12v7Ev();
extern void _ZN7S1289C12v8Ev();
extern void _ZN7S1289C12v9Ev();
static  VTBL_ENTRY vtc_S1289C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1289C1[0]),
  (VTBL_ENTRY)&_ZN7S1289C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1289C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1289C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1289C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1289C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1289C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1289C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1289C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1289C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1289C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1289C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1289C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1289C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1289C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1289C12v7Ev,
  (VTBL_ENTRY)&_ZN7S1289C12v8Ev,
  (VTBL_ENTRY)&_ZN7S1289C12v9Ev,
};
extern VTBL_ENTRY _ZTI7S1289C1[];
extern  VTBL_ENTRY _ZTV7S1289C1[];
Class_Descriptor cd_S1289C1 = {  "S1289C1", // class name
  bases_S1289C1, 3,
  &(vtc_S1289C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(536,364), // object size
  NSPAIRA(_ZTI7S1289C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1289C1),101, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1516C4  {
  int s1516c4f0;
  __tsi64 s1516c4f1;
  void *s1516c4f2[4];
  int s1516c4f3[2];
  void *s1516c4f4;
  ::S674C6_nt s1516c4f5;
  void *s1516c4f6[2];
  virtual  ~S1516C4(); // _ZN7S1516C4D1Ev
  virtual void  v6(); // _ZN7S1516C42v6Ev
  virtual void  v7(); // _ZN7S1516C42v7Ev
  virtual void  v8(); // _ZN7S1516C42v8Ev
  virtual void  v9(); // _ZN7S1516C42v9Ev
  virtual void  v10(); // _ZN7S1516C43v10Ev
  virtual void  v11(); // _ZN7S1516C43v11Ev
  virtual void  v12(); // _ZN7S1516C43v12Ev
  virtual void  v13(); // _ZN7S1516C43v13Ev
  virtual void  v14(); // _ZN7S1516C43v14Ev
  virtual void  v15(); // _ZN7S1516C43v15Ev
  virtual void  v16(); // _ZN7S1516C43v16Ev
  virtual void  v17(); // _ZN7S1516C43v17Ev
  virtual void  v18(); // _ZN7S1516C43v18Ev
  virtual void  v19(); // _ZN7S1516C43v19Ev
  virtual void  v20(); // _ZN7S1516C43v20Ev
  virtual void  v21(); // _ZN7S1516C43v21Ev
  virtual void  v22(); // _ZN7S1516C43v22Ev
  virtual void  v23(); // _ZN7S1516C43v23Ev
  virtual void  v24(); // _ZN7S1516C43v24Ev
  virtual void  v25(); // _ZN7S1516C43v25Ev
  virtual void  v26(); // _ZN7S1516C43v26Ev
  virtual void  v27(); // _ZN7S1516C43v27Ev
  virtual void  v28(); // _ZN7S1516C43v28Ev
  virtual void  v29(); // _ZN7S1516C43v29Ev
  virtual void  v30(); // _ZN7S1516C43v30Ev
  virtual void  v31(); // _ZN7S1516C43v31Ev
  virtual void  v32(); // _ZN7S1516C43v32Ev
  virtual void  v33(); // _ZN7S1516C43v33Ev
  virtual void  v34(); // _ZN7S1516C43v34Ev
  virtual void  v35(); // _ZN7S1516C43v35Ev
  virtual void  v36(); // _ZN7S1516C43v36Ev
  virtual void  v37(); // _ZN7S1516C43v37Ev
  virtual void  v38(); // _ZN7S1516C43v38Ev
  virtual void  v39(); // _ZN7S1516C43v39Ev
  virtual void  v40(); // _ZN7S1516C43v40Ev
  virtual void  v41(); // _ZN7S1516C43v41Ev
  virtual void  v42(); // _ZN7S1516C43v42Ev
  virtual void  v43(); // _ZN7S1516C43v43Ev
  virtual void  v44(); // _ZN7S1516C43v44Ev
  virtual void  v45(); // _ZN7S1516C43v45Ev
  virtual void  v46(); // _ZN7S1516C43v46Ev
  virtual void  v47(); // _ZN7S1516C43v47Ev
  virtual void  v48(); // _ZN7S1516C43v48Ev
  virtual void  v49(); // _ZN7S1516C43v49Ev
  virtual void  v50(); // _ZN7S1516C43v50Ev
  virtual void  v51(); // _ZN7S1516C43v51Ev
  virtual void  v52(); // _ZN7S1516C43v52Ev
  virtual void  v53(); // _ZN7S1516C43v53Ev
  virtual void  v54(); // _ZN7S1516C43v54Ev
  virtual void  v55(); // _ZN7S1516C43v55Ev
  virtual void  v56(); // _ZN7S1516C43v56Ev
  virtual void  v57(); // _ZN7S1516C43v57Ev
  virtual void  v58(); // _ZN7S1516C43v58Ev
  virtual void  v59(); // _ZN7S1516C43v59Ev
  virtual void  v60(); // _ZN7S1516C43v60Ev
  virtual void  v61(); // _ZN7S1516C43v61Ev
  virtual void  v62(); // _ZN7S1516C43v62Ev
  virtual void  v63(); // _ZN7S1516C43v63Ev
  virtual void  v64(); // _ZN7S1516C43v64Ev
  virtual void  v65(); // _ZN7S1516C43v65Ev
  virtual void  v66(); // _ZN7S1516C43v66Ev
  virtual void  v67(); // _ZN7S1516C43v67Ev
  virtual void  v68(); // _ZN7S1516C43v68Ev
  virtual void  v69(); // _ZN7S1516C43v69Ev
  S1516C4(); // tgen
};
//SIG(-1 S1516C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1516C4 ::~S1516C4(){ note_dtor("S1516C4", this);}
void  S1516C4 ::v6(){vfunc_called(this, "_ZN7S1516C42v6Ev");}
void  S1516C4 ::v7(){vfunc_called(this, "_ZN7S1516C42v7Ev");}
void  S1516C4 ::v8(){vfunc_called(this, "_ZN7S1516C42v8Ev");}
void  S1516C4 ::v9(){vfunc_called(this, "_ZN7S1516C42v9Ev");}
void  S1516C4 ::v10(){vfunc_called(this, "_ZN7S1516C43v10Ev");}
void  S1516C4 ::v11(){vfunc_called(this, "_ZN7S1516C43v11Ev");}
void  S1516C4 ::v12(){vfunc_called(this, "_ZN7S1516C43v12Ev");}
void  S1516C4 ::v13(){vfunc_called(this, "_ZN7S1516C43v13Ev");}
void  S1516C4 ::v14(){vfunc_called(this, "_ZN7S1516C43v14Ev");}
void  S1516C4 ::v15(){vfunc_called(this, "_ZN7S1516C43v15Ev");}
void  S1516C4 ::v16(){vfunc_called(this, "_ZN7S1516C43v16Ev");}
void  S1516C4 ::v17(){vfunc_called(this, "_ZN7S1516C43v17Ev");}
void  S1516C4 ::v18(){vfunc_called(this, "_ZN7S1516C43v18Ev");}
void  S1516C4 ::v19(){vfunc_called(this, "_ZN7S1516C43v19Ev");}
void  S1516C4 ::v20(){vfunc_called(this, "_ZN7S1516C43v20Ev");}
void  S1516C4 ::v21(){vfunc_called(this, "_ZN7S1516C43v21Ev");}
void  S1516C4 ::v22(){vfunc_called(this, "_ZN7S1516C43v22Ev");}
void  S1516C4 ::v23(){vfunc_called(this, "_ZN7S1516C43v23Ev");}
void  S1516C4 ::v24(){vfunc_called(this, "_ZN7S1516C43v24Ev");}
void  S1516C4 ::v25(){vfunc_called(this, "_ZN7S1516C43v25Ev");}
void  S1516C4 ::v26(){vfunc_called(this, "_ZN7S1516C43v26Ev");}
void  S1516C4 ::v27(){vfunc_called(this, "_ZN7S1516C43v27Ev");}
void  S1516C4 ::v28(){vfunc_called(this, "_ZN7S1516C43v28Ev");}
void  S1516C4 ::v29(){vfunc_called(this, "_ZN7S1516C43v29Ev");}
void  S1516C4 ::v30(){vfunc_called(this, "_ZN7S1516C43v30Ev");}
void  S1516C4 ::v31(){vfunc_called(this, "_ZN7S1516C43v31Ev");}
void  S1516C4 ::v32(){vfunc_called(this, "_ZN7S1516C43v32Ev");}
void  S1516C4 ::v33(){vfunc_called(this, "_ZN7S1516C43v33Ev");}
void  S1516C4 ::v34(){vfunc_called(this, "_ZN7S1516C43v34Ev");}
void  S1516C4 ::v35(){vfunc_called(this, "_ZN7S1516C43v35Ev");}
void  S1516C4 ::v36(){vfunc_called(this, "_ZN7S1516C43v36Ev");}
void  S1516C4 ::v37(){vfunc_called(this, "_ZN7S1516C43v37Ev");}
void  S1516C4 ::v38(){vfunc_called(this, "_ZN7S1516C43v38Ev");}
void  S1516C4 ::v39(){vfunc_called(this, "_ZN7S1516C43v39Ev");}
void  S1516C4 ::v40(){vfunc_called(this, "_ZN7S1516C43v40Ev");}
void  S1516C4 ::v41(){vfunc_called(this, "_ZN7S1516C43v41Ev");}
void  S1516C4 ::v42(){vfunc_called(this, "_ZN7S1516C43v42Ev");}
void  S1516C4 ::v43(){vfunc_called(this, "_ZN7S1516C43v43Ev");}
void  S1516C4 ::v44(){vfunc_called(this, "_ZN7S1516C43v44Ev");}
void  S1516C4 ::v45(){vfunc_called(this, "_ZN7S1516C43v45Ev");}
void  S1516C4 ::v46(){vfunc_called(this, "_ZN7S1516C43v46Ev");}
void  S1516C4 ::v47(){vfunc_called(this, "_ZN7S1516C43v47Ev");}
void  S1516C4 ::v48(){vfunc_called(this, "_ZN7S1516C43v48Ev");}
void  S1516C4 ::v49(){vfunc_called(this, "_ZN7S1516C43v49Ev");}
void  S1516C4 ::v50(){vfunc_called(this, "_ZN7S1516C43v50Ev");}
void  S1516C4 ::v51(){vfunc_called(this, "_ZN7S1516C43v51Ev");}
void  S1516C4 ::v52(){vfunc_called(this, "_ZN7S1516C43v52Ev");}
void  S1516C4 ::v53(){vfunc_called(this, "_ZN7S1516C43v53Ev");}
void  S1516C4 ::v54(){vfunc_called(this, "_ZN7S1516C43v54Ev");}
void  S1516C4 ::v55(){vfunc_called(this, "_ZN7S1516C43v55Ev");}
void  S1516C4 ::v56(){vfunc_called(this, "_ZN7S1516C43v56Ev");}
void  S1516C4 ::v57(){vfunc_called(this, "_ZN7S1516C43v57Ev");}
void  S1516C4 ::v58(){vfunc_called(this, "_ZN7S1516C43v58Ev");}
void  S1516C4 ::v59(){vfunc_called(this, "_ZN7S1516C43v59Ev");}
void  S1516C4 ::v60(){vfunc_called(this, "_ZN7S1516C43v60Ev");}
void  S1516C4 ::v61(){vfunc_called(this, "_ZN7S1516C43v61Ev");}
void  S1516C4 ::v62(){vfunc_called(this, "_ZN7S1516C43v62Ev");}
void  S1516C4 ::v63(){vfunc_called(this, "_ZN7S1516C43v63Ev");}
void  S1516C4 ::v64(){vfunc_called(this, "_ZN7S1516C43v64Ev");}
void  S1516C4 ::v65(){vfunc_called(this, "_ZN7S1516C43v65Ev");}
void  S1516C4 ::v66(){vfunc_called(this, "_ZN7S1516C43v66Ev");}
void  S1516C4 ::v67(){vfunc_called(this, "_ZN7S1516C43v67Ev");}
void  S1516C4 ::v68(){vfunc_called(this, "_ZN7S1516C43v68Ev");}
void  S1516C4 ::v69(){vfunc_called(this, "_ZN7S1516C43v69Ev");}
S1516C4 ::S1516C4(){ note_ctor("S1516C4", this);} // tgen

static void Test_S1516C4()
{
  extern Class_Descriptor cd_S1516C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1516C4, buf);
    S1516C4 *dp, &lv = *(dp=new (buf) S1516C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1516C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1516C4)");
    check_field_offset(lv, s1516c4f0, ABISELECT(8,4), "S1516C4.s1516c4f0");
    check_field_offset(lv, s1516c4f1, ABISELECT(16,8), "S1516C4.s1516c4f1");
    check_field_offset(lv, s1516c4f2, ABISELECT(24,16), "S1516C4.s1516c4f2");
    check_field_offset(lv, s1516c4f3, ABISELECT(56,32), "S1516C4.s1516c4f3");
    check_field_offset(lv, s1516c4f4, ABISELECT(64,40), "S1516C4.s1516c4f4");
    check_field_offset(lv, s1516c4f5, ABISELECT(72,44), "S1516C4.s1516c4f5");
    check_field_offset(lv, s1516c4f6, ABISELECT(80,52), "S1516C4.s1516c4f6");
    test_class_info(&lv, &cd_S1516C4);
    dp->~S1516C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1516C4(Test_S1516C4, "S1516C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1516C4C1Ev();
extern void _ZN7S1516C4D1Ev();
Name_Map name_map_S1516C4[] = {
  NSPAIR(_ZN7S1516C4C1Ev),
  NSPAIR(_ZN7S1516C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1516C4[];
extern void _ZN7S1516C4D1Ev();
extern void _ZN7S1516C4D0Ev();
extern void _ZN7S1516C42v6Ev();
extern void _ZN7S1516C42v7Ev();
extern void _ZN7S1516C42v8Ev();
extern void _ZN7S1516C42v9Ev();
extern void _ZN7S1516C43v10Ev();
extern void _ZN7S1516C43v11Ev();
extern void _ZN7S1516C43v12Ev();
extern void _ZN7S1516C43v13Ev();
extern void _ZN7S1516C43v14Ev();
extern void _ZN7S1516C43v15Ev();
extern void _ZN7S1516C43v16Ev();
extern void _ZN7S1516C43v17Ev();
extern void _ZN7S1516C43v18Ev();
extern void _ZN7S1516C43v19Ev();
extern void _ZN7S1516C43v20Ev();
extern void _ZN7S1516C43v21Ev();
extern void _ZN7S1516C43v22Ev();
extern void _ZN7S1516C43v23Ev();
extern void _ZN7S1516C43v24Ev();
extern void _ZN7S1516C43v25Ev();
extern void _ZN7S1516C43v26Ev();
extern void _ZN7S1516C43v27Ev();
extern void _ZN7S1516C43v28Ev();
extern void _ZN7S1516C43v29Ev();
extern void _ZN7S1516C43v30Ev();
extern void _ZN7S1516C43v31Ev();
extern void _ZN7S1516C43v32Ev();
extern void _ZN7S1516C43v33Ev();
extern void _ZN7S1516C43v34Ev();
extern void _ZN7S1516C43v35Ev();
extern void _ZN7S1516C43v36Ev();
extern void _ZN7S1516C43v37Ev();
extern void _ZN7S1516C43v38Ev();
extern void _ZN7S1516C43v39Ev();
extern void _ZN7S1516C43v40Ev();
extern void _ZN7S1516C43v41Ev();
extern void _ZN7S1516C43v42Ev();
extern void _ZN7S1516C43v43Ev();
extern void _ZN7S1516C43v44Ev();
extern void _ZN7S1516C43v45Ev();
extern void _ZN7S1516C43v46Ev();
extern void _ZN7S1516C43v47Ev();
extern void _ZN7S1516C43v48Ev();
extern void _ZN7S1516C43v49Ev();
extern void _ZN7S1516C43v50Ev();
extern void _ZN7S1516C43v51Ev();
extern void _ZN7S1516C43v52Ev();
extern void _ZN7S1516C43v53Ev();
extern void _ZN7S1516C43v54Ev();
extern void _ZN7S1516C43v55Ev();
extern void _ZN7S1516C43v56Ev();
extern void _ZN7S1516C43v57Ev();
extern void _ZN7S1516C43v58Ev();
extern void _ZN7S1516C43v59Ev();
extern void _ZN7S1516C43v60Ev();
extern void _ZN7S1516C43v61Ev();
extern void _ZN7S1516C43v62Ev();
extern void _ZN7S1516C43v63Ev();
extern void _ZN7S1516C43v64Ev();
extern void _ZN7S1516C43v65Ev();
extern void _ZN7S1516C43v66Ev();
extern void _ZN7S1516C43v67Ev();
extern void _ZN7S1516C43v68Ev();
extern void _ZN7S1516C43v69Ev();
static  VTBL_ENTRY vtc_S1516C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1516C4[0]),
  (VTBL_ENTRY)&_ZN7S1516C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1516C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1516C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1516C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1516C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1516C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v69Ev,
};
extern VTBL_ENTRY _ZTI7S1516C4[];
extern  VTBL_ENTRY _ZTV7S1516C4[];
Class_Descriptor cd_S1516C4 = {  "S1516C4", // class name
  0,0,//no base classes
  &(vtc_S1516C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1516C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1516C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1516C3  : S1516C4 {
  unsigned int s1516c3f0:1;
  unsigned int s1516c3f1:1;
  unsigned int s1516c3f2:1;
  unsigned int s1516c3f3:1;
  unsigned int s1516c3f4:1;
  unsigned int s1516c3f5:1;
  unsigned int s1516c3f6:1;
  ::S3625C32 s1516c3f7;
  virtual  ~S1516C3(); // _ZN7S1516C3D1Ev
  virtual void  v70(); // _ZN7S1516C33v70Ev
  virtual void  v71(); // _ZN7S1516C33v71Ev
  virtual void  v72(); // _ZN7S1516C33v72Ev
  virtual void  v73(); // _ZN7S1516C33v73Ev
  virtual void  v74(); // _ZN7S1516C33v74Ev
  virtual void  v75(); // _ZN7S1516C33v75Ev
  virtual void  v76(); // _ZN7S1516C33v76Ev
  virtual void  v77(); // _ZN7S1516C33v77Ev
  virtual void  v78(); // _ZN7S1516C33v78Ev
  virtual void  v79(); // _ZN7S1516C33v79Ev
  virtual void  v80(); // _ZN7S1516C33v80Ev
  virtual void  v81(); // _ZN7S1516C33v81Ev
  virtual void  v82(); // _ZN7S1516C33v82Ev
  virtual void  v83(); // _ZN7S1516C33v83Ev
  virtual void  v84(); // _ZN7S1516C33v84Ev
  virtual void  v85(); // _ZN7S1516C33v85Ev
  virtual void  v86(); // _ZN7S1516C33v86Ev
  virtual void  v87(); // _ZN7S1516C33v87Ev
  virtual void  v88(); // _ZN7S1516C33v88Ev
  virtual void  v89(); // _ZN7S1516C33v89Ev
  S1516C3(); // tgen
};
//SIG(-1 S1516C3) C1{ BC2{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC4{ m}}


 S1516C3 ::~S1516C3(){ note_dtor("S1516C3", this);}
void  S1516C3 ::v70(){vfunc_called(this, "_ZN7S1516C33v70Ev");}
void  S1516C3 ::v71(){vfunc_called(this, "_ZN7S1516C33v71Ev");}
void  S1516C3 ::v72(){vfunc_called(this, "_ZN7S1516C33v72Ev");}
void  S1516C3 ::v73(){vfunc_called(this, "_ZN7S1516C33v73Ev");}
void  S1516C3 ::v74(){vfunc_called(this, "_ZN7S1516C33v74Ev");}
void  S1516C3 ::v75(){vfunc_called(this, "_ZN7S1516C33v75Ev");}
void  S1516C3 ::v76(){vfunc_called(this, "_ZN7S1516C33v76Ev");}
void  S1516C3 ::v77(){vfunc_called(this, "_ZN7S1516C33v77Ev");}
void  S1516C3 ::v78(){vfunc_called(this, "_ZN7S1516C33v78Ev");}
void  S1516C3 ::v79(){vfunc_called(this, "_ZN7S1516C33v79Ev");}
void  S1516C3 ::v80(){vfunc_called(this, "_ZN7S1516C33v80Ev");}
void  S1516C3 ::v81(){vfunc_called(this, "_ZN7S1516C33v81Ev");}
void  S1516C3 ::v82(){vfunc_called(this, "_ZN7S1516C33v82Ev");}
void  S1516C3 ::v83(){vfunc_called(this, "_ZN7S1516C33v83Ev");}
void  S1516C3 ::v84(){vfunc_called(this, "_ZN7S1516C33v84Ev");}
void  S1516C3 ::v85(){vfunc_called(this, "_ZN7S1516C33v85Ev");}
void  S1516C3 ::v86(){vfunc_called(this, "_ZN7S1516C33v86Ev");}
void  S1516C3 ::v87(){vfunc_called(this, "_ZN7S1516C33v87Ev");}
void  S1516C3 ::v88(){vfunc_called(this, "_ZN7S1516C33v88Ev");}
void  S1516C3 ::v89(){vfunc_called(this, "_ZN7S1516C33v89Ev");}
S1516C3 ::S1516C3(){ note_ctor("S1516C3", this);} // tgen

static void Test_S1516C3()
{
  extern Class_Descriptor cd_S1516C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S1516C3, buf);
    S1516C3 *dp, &lv = *(dp=new (buf) S1516C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S1516C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1516C3)");
    check_base_class_offset(lv, (S1516C4*), 0, "S1516C3");
    set_bf_and_test(lv, s1516c3f0, ABISELECT(96,60), 0, 1, 1, "S1516C3");
    set_bf_and_test(lv, s1516c3f1, ABISELECT(96,60), 1, 1, 1, "S1516C3");
    set_bf_and_test(lv, s1516c3f2, ABISELECT(96,60), 2, 1, 1, "S1516C3");
    set_bf_and_test(lv, s1516c3f3, ABISELECT(96,60), 3, 1, 1, "S1516C3");
    set_bf_and_test(lv, s1516c3f4, ABISELECT(96,60), 4, 1, 1, "S1516C3");
    set_bf_and_test(lv, s1516c3f5, ABISELECT(96,60), 5, 1, 1, "S1516C3");
    set_bf_and_test(lv, s1516c3f6, ABISELECT(96,60), 6, 1, 1, "S1516C3");
    check_field_offset(lv, s1516c3f7, ABISELECT(97,61), "S1516C3.s1516c3f7");
    test_class_info(&lv, &cd_S1516C3);
    dp->~S1516C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1516C3(Test_S1516C3, "S1516C3", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN7S1516C3C1Ev();
extern void _ZN7S1516C3D1Ev();
Name_Map name_map_S1516C3[] = {
  NSPAIR(_ZN7S1516C3C1Ev),
  NSPAIR(_ZN7S1516C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1516C4;
extern VTBL_ENTRY _ZTI7S1516C4[];
extern  VTBL_ENTRY _ZTV7S1516C4[];
static Base_Class bases_S1516C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1516C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1516C3[];
extern void _ZN7S1516C3D1Ev();
extern void _ZN7S1516C3D0Ev();
extern void _ZN7S1516C42v6Ev();
extern void _ZN7S1516C42v7Ev();
extern void _ZN7S1516C42v8Ev();
extern void _ZN7S1516C42v9Ev();
extern void _ZN7S1516C43v10Ev();
extern void _ZN7S1516C43v11Ev();
extern void _ZN7S1516C43v12Ev();
extern void _ZN7S1516C43v13Ev();
extern void _ZN7S1516C43v14Ev();
extern void _ZN7S1516C43v15Ev();
extern void _ZN7S1516C43v16Ev();
extern void _ZN7S1516C43v17Ev();
extern void _ZN7S1516C43v18Ev();
extern void _ZN7S1516C43v19Ev();
extern void _ZN7S1516C43v20Ev();
extern void _ZN7S1516C43v21Ev();
extern void _ZN7S1516C43v22Ev();
extern void _ZN7S1516C43v23Ev();
extern void _ZN7S1516C43v24Ev();
extern void _ZN7S1516C43v25Ev();
extern void _ZN7S1516C43v26Ev();
extern void _ZN7S1516C43v27Ev();
extern void _ZN7S1516C43v28Ev();
extern void _ZN7S1516C43v29Ev();
extern void _ZN7S1516C43v30Ev();
extern void _ZN7S1516C43v31Ev();
extern void _ZN7S1516C43v32Ev();
extern void _ZN7S1516C43v33Ev();
extern void _ZN7S1516C43v34Ev();
extern void _ZN7S1516C43v35Ev();
extern void _ZN7S1516C43v36Ev();
extern void _ZN7S1516C43v37Ev();
extern void _ZN7S1516C43v38Ev();
extern void _ZN7S1516C43v39Ev();
extern void _ZN7S1516C43v40Ev();
extern void _ZN7S1516C43v41Ev();
extern void _ZN7S1516C43v42Ev();
extern void _ZN7S1516C43v43Ev();
extern void _ZN7S1516C43v44Ev();
extern void _ZN7S1516C43v45Ev();
extern void _ZN7S1516C43v46Ev();
extern void _ZN7S1516C43v47Ev();
extern void _ZN7S1516C43v48Ev();
extern void _ZN7S1516C43v49Ev();
extern void _ZN7S1516C43v50Ev();
extern void _ZN7S1516C43v51Ev();
extern void _ZN7S1516C43v52Ev();
extern void _ZN7S1516C43v53Ev();
extern void _ZN7S1516C43v54Ev();
extern void _ZN7S1516C43v55Ev();
extern void _ZN7S1516C43v56Ev();
extern void _ZN7S1516C43v57Ev();
extern void _ZN7S1516C43v58Ev();
extern void _ZN7S1516C43v59Ev();
extern void _ZN7S1516C43v60Ev();
extern void _ZN7S1516C43v61Ev();
extern void _ZN7S1516C43v62Ev();
extern void _ZN7S1516C43v63Ev();
extern void _ZN7S1516C43v64Ev();
extern void _ZN7S1516C43v65Ev();
extern void _ZN7S1516C43v66Ev();
extern void _ZN7S1516C43v67Ev();
extern void _ZN7S1516C43v68Ev();
extern void _ZN7S1516C43v69Ev();
extern void _ZN7S1516C33v70Ev();
extern void _ZN7S1516C33v71Ev();
extern void _ZN7S1516C33v72Ev();
extern void _ZN7S1516C33v73Ev();
extern void _ZN7S1516C33v74Ev();
extern void _ZN7S1516C33v75Ev();
extern void _ZN7S1516C33v76Ev();
extern void _ZN7S1516C33v77Ev();
extern void _ZN7S1516C33v78Ev();
extern void _ZN7S1516C33v79Ev();
extern void _ZN7S1516C33v80Ev();
extern void _ZN7S1516C33v81Ev();
extern void _ZN7S1516C33v82Ev();
extern void _ZN7S1516C33v83Ev();
extern void _ZN7S1516C33v84Ev();
extern void _ZN7S1516C33v85Ev();
extern void _ZN7S1516C33v86Ev();
extern void _ZN7S1516C33v87Ev();
extern void _ZN7S1516C33v88Ev();
extern void _ZN7S1516C33v89Ev();
static  VTBL_ENTRY vtc_S1516C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1516C3[0]),
  (VTBL_ENTRY)&_ZN7S1516C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1516C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1516C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1516C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1516C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1516C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v89Ev,
};
extern VTBL_ENTRY _ZTI7S1516C3[];
extern  VTBL_ENTRY _ZTV7S1516C3[];
Class_Descriptor cd_S1516C3 = {  "S1516C3", // class name
  bases_S1516C3, 1,
  &(vtc_S1516C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI7S1516C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1516C3),88, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1516C2  : S1516C3 {
  virtual  ~S1516C2(); // _ZN7S1516C2D1Ev
  virtual void  v90(); // _ZN7S1516C23v90Ev
  virtual void  v91(); // _ZN7S1516C23v91Ev
  virtual void  v92(); // _ZN7S1516C23v92Ev
  virtual void  v93(); // _ZN7S1516C23v93Ev
  virtual void  v94(); // _ZN7S1516C23v94Ev
  virtual void  v95(); // _ZN7S1516C23v95Ev
  virtual void  v96(); // _ZN7S1516C23v96Ev
  virtual void  v97(); // _ZN7S1516C23v97Ev
  virtual void  v98(); // _ZN7S1516C23v98Ev
  S1516C2(); // tgen
};
//SIG(-1 S1516C2) C1{ BC2{ BC3{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC5{ m}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9}


 S1516C2 ::~S1516C2(){ note_dtor("S1516C2", this);}
void  S1516C2 ::v90(){vfunc_called(this, "_ZN7S1516C23v90Ev");}
void  S1516C2 ::v91(){vfunc_called(this, "_ZN7S1516C23v91Ev");}
void  S1516C2 ::v92(){vfunc_called(this, "_ZN7S1516C23v92Ev");}
void  S1516C2 ::v93(){vfunc_called(this, "_ZN7S1516C23v93Ev");}
void  S1516C2 ::v94(){vfunc_called(this, "_ZN7S1516C23v94Ev");}
void  S1516C2 ::v95(){vfunc_called(this, "_ZN7S1516C23v95Ev");}
void  S1516C2 ::v96(){vfunc_called(this, "_ZN7S1516C23v96Ev");}
void  S1516C2 ::v97(){vfunc_called(this, "_ZN7S1516C23v97Ev");}
void  S1516C2 ::v98(){vfunc_called(this, "_ZN7S1516C23v98Ev");}
S1516C2 ::S1516C2(){ note_ctor("S1516C2", this);} // tgen

static void Test_S1516C2()
{
  extern Class_Descriptor cd_S1516C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S1516C2, buf);
    S1516C2 *dp, &lv = *(dp=new (buf) S1516C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S1516C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1516C2)");
    check_base_class_offset(lv, (S1516C4*)(S1516C3*), 0, "S1516C2");
    check_base_class_offset(lv, (S1516C3*), 0, "S1516C2");
    test_class_info(&lv, &cd_S1516C2);
    dp->~S1516C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1516C2(Test_S1516C2, "S1516C2", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN7S1516C2C1Ev();
extern void _ZN7S1516C2D1Ev();
Name_Map name_map_S1516C2[] = {
  NSPAIR(_ZN7S1516C2C1Ev),
  NSPAIR(_ZN7S1516C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1516C4;
extern VTBL_ENTRY _ZTI7S1516C4[];
extern  VTBL_ENTRY _ZTV7S1516C4[];
extern Class_Descriptor cd_S1516C3;
extern VTBL_ENTRY _ZTI7S1516C3[];
extern  VTBL_ENTRY _ZTV7S1516C3[];
static Base_Class bases_S1516C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1516C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1516C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1516C2[];
extern void _ZN7S1516C2D1Ev();
extern void _ZN7S1516C2D0Ev();
extern void _ZN7S1516C42v6Ev();
extern void _ZN7S1516C42v7Ev();
extern void _ZN7S1516C42v8Ev();
extern void _ZN7S1516C42v9Ev();
extern void _ZN7S1516C43v10Ev();
extern void _ZN7S1516C43v11Ev();
extern void _ZN7S1516C43v12Ev();
extern void _ZN7S1516C43v13Ev();
extern void _ZN7S1516C43v14Ev();
extern void _ZN7S1516C43v15Ev();
extern void _ZN7S1516C43v16Ev();
extern void _ZN7S1516C43v17Ev();
extern void _ZN7S1516C43v18Ev();
extern void _ZN7S1516C43v19Ev();
extern void _ZN7S1516C43v20Ev();
extern void _ZN7S1516C43v21Ev();
extern void _ZN7S1516C43v22Ev();
extern void _ZN7S1516C43v23Ev();
extern void _ZN7S1516C43v24Ev();
extern void _ZN7S1516C43v25Ev();
extern void _ZN7S1516C43v26Ev();
extern void _ZN7S1516C43v27Ev();
extern void _ZN7S1516C43v28Ev();
extern void _ZN7S1516C43v29Ev();
extern void _ZN7S1516C43v30Ev();
extern void _ZN7S1516C43v31Ev();
extern void _ZN7S1516C43v32Ev();
extern void _ZN7S1516C43v33Ev();
extern void _ZN7S1516C43v34Ev();
extern void _ZN7S1516C43v35Ev();
extern void _ZN7S1516C43v36Ev();
extern void _ZN7S1516C43v37Ev();
extern void _ZN7S1516C43v38Ev();
extern void _ZN7S1516C43v39Ev();
extern void _ZN7S1516C43v40Ev();
extern void _ZN7S1516C43v41Ev();
extern void _ZN7S1516C43v42Ev();
extern void _ZN7S1516C43v43Ev();
extern void _ZN7S1516C43v44Ev();
extern void _ZN7S1516C43v45Ev();
extern void _ZN7S1516C43v46Ev();
extern void _ZN7S1516C43v47Ev();
extern void _ZN7S1516C43v48Ev();
extern void _ZN7S1516C43v49Ev();
extern void _ZN7S1516C43v50Ev();
extern void _ZN7S1516C43v51Ev();
extern void _ZN7S1516C43v52Ev();
extern void _ZN7S1516C43v53Ev();
extern void _ZN7S1516C43v54Ev();
extern void _ZN7S1516C43v55Ev();
extern void _ZN7S1516C43v56Ev();
extern void _ZN7S1516C43v57Ev();
extern void _ZN7S1516C43v58Ev();
extern void _ZN7S1516C43v59Ev();
extern void _ZN7S1516C43v60Ev();
extern void _ZN7S1516C43v61Ev();
extern void _ZN7S1516C43v62Ev();
extern void _ZN7S1516C43v63Ev();
extern void _ZN7S1516C43v64Ev();
extern void _ZN7S1516C43v65Ev();
extern void _ZN7S1516C43v66Ev();
extern void _ZN7S1516C43v67Ev();
extern void _ZN7S1516C43v68Ev();
extern void _ZN7S1516C43v69Ev();
extern void _ZN7S1516C33v70Ev();
extern void _ZN7S1516C33v71Ev();
extern void _ZN7S1516C33v72Ev();
extern void _ZN7S1516C33v73Ev();
extern void _ZN7S1516C33v74Ev();
extern void _ZN7S1516C33v75Ev();
extern void _ZN7S1516C33v76Ev();
extern void _ZN7S1516C33v77Ev();
extern void _ZN7S1516C33v78Ev();
extern void _ZN7S1516C33v79Ev();
extern void _ZN7S1516C33v80Ev();
extern void _ZN7S1516C33v81Ev();
extern void _ZN7S1516C33v82Ev();
extern void _ZN7S1516C33v83Ev();
extern void _ZN7S1516C33v84Ev();
extern void _ZN7S1516C33v85Ev();
extern void _ZN7S1516C33v86Ev();
extern void _ZN7S1516C33v87Ev();
extern void _ZN7S1516C33v88Ev();
extern void _ZN7S1516C33v89Ev();
extern void _ZN7S1516C23v90Ev();
extern void _ZN7S1516C23v91Ev();
extern void _ZN7S1516C23v92Ev();
extern void _ZN7S1516C23v93Ev();
extern void _ZN7S1516C23v94Ev();
extern void _ZN7S1516C23v95Ev();
extern void _ZN7S1516C23v96Ev();
extern void _ZN7S1516C23v97Ev();
extern void _ZN7S1516C23v98Ev();
static  VTBL_ENTRY vtc_S1516C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1516C2[0]),
  (VTBL_ENTRY)&_ZN7S1516C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1516C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1516C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1516C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1516C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1516C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1516C23v90Ev,
  (VTBL_ENTRY)&_ZN7S1516C23v91Ev,
  (VTBL_ENTRY)&_ZN7S1516C23v92Ev,
  (VTBL_ENTRY)&_ZN7S1516C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1516C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1516C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1516C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1516C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1516C23v98Ev,
};
extern VTBL_ENTRY _ZTI7S1516C2[];
extern  VTBL_ENTRY _ZTV7S1516C2[];
Class_Descriptor cd_S1516C2 = {  "S1516C2", // class name
  bases_S1516C2, 2,
  &(vtc_S1516C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI7S1516C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1516C2),97, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1516C1  : S1516C2 {
  ::S693C8 s1516c1f0;
  virtual  ~S1516C1(); // _ZN7S1516C1D1Ev
  virtual void  v1(); // _ZN7S1516C12v1Ev
  virtual void  v2(); // _ZN7S1516C12v2Ev
  virtual void  v3(); // _ZN7S1516C12v3Ev
  virtual void  v4(); // _ZN7S1516C12v4Ev
  virtual void  v5(); // _ZN7S1516C12v5Ev
  S1516C1(); // tgen
};
//SIG(1 S1516C1) C1{ BC2{ BC3{ BC4{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC6{ m}} vd v90 v91 v92 v93 v94 v95 v96 v97 v98} vd v1 v2 v3 v4 v5 FC7{ m Fi[7] Fc Fi[4] FC8{ m Fi[3]} Fi[7] Fc Fi:1 Fi:1 Fi:1 Fi:1 Fi[3] Fc Fi Fc Fi[2] FC8 Fi[5] Fp[3] Fi[3] Fp[9] Fi Fp Fi Fp Fi:1 Fi:1 Fi:1 Fi:1 Fp[3] Fi[2]}}


 S1516C1 ::~S1516C1(){ note_dtor("S1516C1", this);}
void  S1516C1 ::v1(){vfunc_called(this, "_ZN7S1516C12v1Ev");}
void  S1516C1 ::v2(){vfunc_called(this, "_ZN7S1516C12v2Ev");}
void  S1516C1 ::v3(){vfunc_called(this, "_ZN7S1516C12v3Ev");}
void  S1516C1 ::v4(){vfunc_called(this, "_ZN7S1516C12v4Ev");}
void  S1516C1 ::v5(){vfunc_called(this, "_ZN7S1516C12v5Ev");}
S1516C1 ::S1516C1(){ note_ctor("S1516C1", this);} // tgen

static void Test_S1516C1()
{
  extern Class_Descriptor cd_S1516C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(57,81)];
    init_test(&cd_S1516C1, buf);
    S1516C1 *dp, &lv = *(dp=new (buf) S1516C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(448,320), "sizeof(S1516C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1516C1)");
    check_base_class_offset(lv, (S1516C4*)(S1516C3*)(S1516C2*), 0, "S1516C1");
    check_base_class_offset(lv, (S1516C3*)(S1516C2*), 0, "S1516C1");
    check_base_class_offset(lv, (S1516C2*), 0, "S1516C1");
    check_field_offset(lv, s1516c1f0, ABISELECT(104,64), "S1516C1.s1516c1f0");
    test_class_info(&lv, &cd_S1516C1);
    dp->~S1516C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1516C1(Test_S1516C1, "S1516C1", ABISELECT(448,320));

#else // __cplusplus

extern void _ZN7S1516C1C1Ev();
extern void _ZN7S1516C1D1Ev();
Name_Map name_map_S1516C1[] = {
  NSPAIR(_ZN7S1516C1C1Ev),
  NSPAIR(_ZN7S1516C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1516C4;
extern VTBL_ENTRY _ZTI7S1516C4[];
extern  VTBL_ENTRY _ZTV7S1516C4[];
extern Class_Descriptor cd_S1516C3;
extern VTBL_ENTRY _ZTI7S1516C3[];
extern  VTBL_ENTRY _ZTV7S1516C3[];
extern Class_Descriptor cd_S1516C2;
extern VTBL_ENTRY _ZTI7S1516C2[];
extern  VTBL_ENTRY _ZTV7S1516C2[];
static Base_Class bases_S1516C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1516C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1516C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1516C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1516C1[];
extern void _ZN7S1516C1D1Ev();
extern void _ZN7S1516C1D0Ev();
extern void _ZN7S1516C42v6Ev();
extern void _ZN7S1516C42v7Ev();
extern void _ZN7S1516C42v8Ev();
extern void _ZN7S1516C42v9Ev();
extern void _ZN7S1516C43v10Ev();
extern void _ZN7S1516C43v11Ev();
extern void _ZN7S1516C43v12Ev();
extern void _ZN7S1516C43v13Ev();
extern void _ZN7S1516C43v14Ev();
extern void _ZN7S1516C43v15Ev();
extern void _ZN7S1516C43v16Ev();
extern void _ZN7S1516C43v17Ev();
extern void _ZN7S1516C43v18Ev();
extern void _ZN7S1516C43v19Ev();
extern void _ZN7S1516C43v20Ev();
extern void _ZN7S1516C43v21Ev();
extern void _ZN7S1516C43v22Ev();
extern void _ZN7S1516C43v23Ev();
extern void _ZN7S1516C43v24Ev();
extern void _ZN7S1516C43v25Ev();
extern void _ZN7S1516C43v26Ev();
extern void _ZN7S1516C43v27Ev();
extern void _ZN7S1516C43v28Ev();
extern void _ZN7S1516C43v29Ev();
extern void _ZN7S1516C43v30Ev();
extern void _ZN7S1516C43v31Ev();
extern void _ZN7S1516C43v32Ev();
extern void _ZN7S1516C43v33Ev();
extern void _ZN7S1516C43v34Ev();
extern void _ZN7S1516C43v35Ev();
extern void _ZN7S1516C43v36Ev();
extern void _ZN7S1516C43v37Ev();
extern void _ZN7S1516C43v38Ev();
extern void _ZN7S1516C43v39Ev();
extern void _ZN7S1516C43v40Ev();
extern void _ZN7S1516C43v41Ev();
extern void _ZN7S1516C43v42Ev();
extern void _ZN7S1516C43v43Ev();
extern void _ZN7S1516C43v44Ev();
extern void _ZN7S1516C43v45Ev();
extern void _ZN7S1516C43v46Ev();
extern void _ZN7S1516C43v47Ev();
extern void _ZN7S1516C43v48Ev();
extern void _ZN7S1516C43v49Ev();
extern void _ZN7S1516C43v50Ev();
extern void _ZN7S1516C43v51Ev();
extern void _ZN7S1516C43v52Ev();
extern void _ZN7S1516C43v53Ev();
extern void _ZN7S1516C43v54Ev();
extern void _ZN7S1516C43v55Ev();
extern void _ZN7S1516C43v56Ev();
extern void _ZN7S1516C43v57Ev();
extern void _ZN7S1516C43v58Ev();
extern void _ZN7S1516C43v59Ev();
extern void _ZN7S1516C43v60Ev();
extern void _ZN7S1516C43v61Ev();
extern void _ZN7S1516C43v62Ev();
extern void _ZN7S1516C43v63Ev();
extern void _ZN7S1516C43v64Ev();
extern void _ZN7S1516C43v65Ev();
extern void _ZN7S1516C43v66Ev();
extern void _ZN7S1516C43v67Ev();
extern void _ZN7S1516C43v68Ev();
extern void _ZN7S1516C43v69Ev();
extern void _ZN7S1516C33v70Ev();
extern void _ZN7S1516C33v71Ev();
extern void _ZN7S1516C33v72Ev();
extern void _ZN7S1516C33v73Ev();
extern void _ZN7S1516C33v74Ev();
extern void _ZN7S1516C33v75Ev();
extern void _ZN7S1516C33v76Ev();
extern void _ZN7S1516C33v77Ev();
extern void _ZN7S1516C33v78Ev();
extern void _ZN7S1516C33v79Ev();
extern void _ZN7S1516C33v80Ev();
extern void _ZN7S1516C33v81Ev();
extern void _ZN7S1516C33v82Ev();
extern void _ZN7S1516C33v83Ev();
extern void _ZN7S1516C33v84Ev();
extern void _ZN7S1516C33v85Ev();
extern void _ZN7S1516C33v86Ev();
extern void _ZN7S1516C33v87Ev();
extern void _ZN7S1516C33v88Ev();
extern void _ZN7S1516C33v89Ev();
extern void _ZN7S1516C23v90Ev();
extern void _ZN7S1516C23v91Ev();
extern void _ZN7S1516C23v92Ev();
extern void _ZN7S1516C23v93Ev();
extern void _ZN7S1516C23v94Ev();
extern void _ZN7S1516C23v95Ev();
extern void _ZN7S1516C23v96Ev();
extern void _ZN7S1516C23v97Ev();
extern void _ZN7S1516C23v98Ev();
extern void _ZN7S1516C12v1Ev();
extern void _ZN7S1516C12v2Ev();
extern void _ZN7S1516C12v3Ev();
extern void _ZN7S1516C12v4Ev();
extern void _ZN7S1516C12v5Ev();
static  VTBL_ENTRY vtc_S1516C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1516C1[0]),
  (VTBL_ENTRY)&_ZN7S1516C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1516C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1516C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1516C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1516C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1516C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1516C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1516C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1516C23v90Ev,
  (VTBL_ENTRY)&_ZN7S1516C23v91Ev,
  (VTBL_ENTRY)&_ZN7S1516C23v92Ev,
  (VTBL_ENTRY)&_ZN7S1516C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1516C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1516C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1516C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1516C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1516C23v98Ev,
  (VTBL_ENTRY)&_ZN7S1516C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1516C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1516C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1516C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1516C12v5Ev,
};
extern VTBL_ENTRY _ZTI7S1516C1[];
extern  VTBL_ENTRY _ZTV7S1516C1[];
Class_Descriptor cd_S1516C1 = {  "S1516C1", // class name
  bases_S1516C1, 3,
  &(vtc_S1516C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(448,320), // object size
  NSPAIRA(_ZTI7S1516C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1516C1),102, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1300C4  {
  int s1300c4f0;
  __tsi64 s1300c4f1;
  void *s1300c4f2[4];
  int s1300c4f3[2];
  void *s1300c4f4;
  ::S674C6_nt s1300c4f5;
  void *s1300c4f6[2];
  virtual  ~S1300C4(); // _ZN7S1300C4D1Ev
  virtual void  v11(); // _ZN7S1300C43v11Ev
  virtual void  v12(); // _ZN7S1300C43v12Ev
  virtual void  v13(); // _ZN7S1300C43v13Ev
  virtual void  v14(); // _ZN7S1300C43v14Ev
  virtual void  v15(); // _ZN7S1300C43v15Ev
  virtual void  v16(); // _ZN7S1300C43v16Ev
  virtual void  v17(); // _ZN7S1300C43v17Ev
  virtual void  v18(); // _ZN7S1300C43v18Ev
  virtual void  v19(); // _ZN7S1300C43v19Ev
  virtual void  v20(); // _ZN7S1300C43v20Ev
  virtual void  v21(); // _ZN7S1300C43v21Ev
  virtual void  v22(); // _ZN7S1300C43v22Ev
  virtual void  v23(); // _ZN7S1300C43v23Ev
  virtual void  v24(); // _ZN7S1300C43v24Ev
  virtual void  v25(); // _ZN7S1300C43v25Ev
  virtual void  v26(); // _ZN7S1300C43v26Ev
  virtual void  v27(); // _ZN7S1300C43v27Ev
  virtual void  v28(); // _ZN7S1300C43v28Ev
  virtual void  v29(); // _ZN7S1300C43v29Ev
  virtual void  v30(); // _ZN7S1300C43v30Ev
  virtual void  v31(); // _ZN7S1300C43v31Ev
  virtual void  v32(); // _ZN7S1300C43v32Ev
  virtual void  v33(); // _ZN7S1300C43v33Ev
  virtual void  v34(); // _ZN7S1300C43v34Ev
  virtual void  v35(); // _ZN7S1300C43v35Ev
  virtual void  v36(); // _ZN7S1300C43v36Ev
  virtual void  v37(); // _ZN7S1300C43v37Ev
  virtual void  v38(); // _ZN7S1300C43v38Ev
  virtual void  v39(); // _ZN7S1300C43v39Ev
  virtual void  v40(); // _ZN7S1300C43v40Ev
  virtual void  v41(); // _ZN7S1300C43v41Ev
  virtual void  v42(); // _ZN7S1300C43v42Ev
  virtual void  v43(); // _ZN7S1300C43v43Ev
  virtual void  v44(); // _ZN7S1300C43v44Ev
  virtual void  v45(); // _ZN7S1300C43v45Ev
  virtual void  v46(); // _ZN7S1300C43v46Ev
  virtual void  v47(); // _ZN7S1300C43v47Ev
  virtual void  v48(); // _ZN7S1300C43v48Ev
  virtual void  v49(); // _ZN7S1300C43v49Ev
  virtual void  v50(); // _ZN7S1300C43v50Ev
  virtual void  v51(); // _ZN7S1300C43v51Ev
  virtual void  v52(); // _ZN7S1300C43v52Ev
  virtual void  v53(); // _ZN7S1300C43v53Ev
  virtual void  v54(); // _ZN7S1300C43v54Ev
  virtual void  v55(); // _ZN7S1300C43v55Ev
  virtual void  v56(); // _ZN7S1300C43v56Ev
  virtual void  v57(); // _ZN7S1300C43v57Ev
  virtual void  v58(); // _ZN7S1300C43v58Ev
  virtual void  v59(); // _ZN7S1300C43v59Ev
  virtual void  v60(); // _ZN7S1300C43v60Ev
  virtual void  v61(); // _ZN7S1300C43v61Ev
  virtual void  v62(); // _ZN7S1300C43v62Ev
  virtual void  v63(); // _ZN7S1300C43v63Ev
  virtual void  v64(); // _ZN7S1300C43v64Ev
  virtual void  v65(); // _ZN7S1300C43v65Ev
  virtual void  v66(); // _ZN7S1300C43v66Ev
  virtual void  v67(); // _ZN7S1300C43v67Ev
  virtual void  v68(); // _ZN7S1300C43v68Ev
  virtual void  v69(); // _ZN7S1300C43v69Ev
  virtual void  v70(); // _ZN7S1300C43v70Ev
  virtual void  v71(); // _ZN7S1300C43v71Ev
  virtual void  v72(); // _ZN7S1300C43v72Ev
  virtual void  v73(); // _ZN7S1300C43v73Ev
  virtual void  v74(); // _ZN7S1300C43v74Ev
  S1300C4(); // tgen
};
//SIG(-1 S1300C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1300C4 ::~S1300C4(){ note_dtor("S1300C4", this);}
void  S1300C4 ::v11(){vfunc_called(this, "_ZN7S1300C43v11Ev");}
void  S1300C4 ::v12(){vfunc_called(this, "_ZN7S1300C43v12Ev");}
void  S1300C4 ::v13(){vfunc_called(this, "_ZN7S1300C43v13Ev");}
void  S1300C4 ::v14(){vfunc_called(this, "_ZN7S1300C43v14Ev");}
void  S1300C4 ::v15(){vfunc_called(this, "_ZN7S1300C43v15Ev");}
void  S1300C4 ::v16(){vfunc_called(this, "_ZN7S1300C43v16Ev");}
void  S1300C4 ::v17(){vfunc_called(this, "_ZN7S1300C43v17Ev");}
void  S1300C4 ::v18(){vfunc_called(this, "_ZN7S1300C43v18Ev");}
void  S1300C4 ::v19(){vfunc_called(this, "_ZN7S1300C43v19Ev");}
void  S1300C4 ::v20(){vfunc_called(this, "_ZN7S1300C43v20Ev");}
void  S1300C4 ::v21(){vfunc_called(this, "_ZN7S1300C43v21Ev");}
void  S1300C4 ::v22(){vfunc_called(this, "_ZN7S1300C43v22Ev");}
void  S1300C4 ::v23(){vfunc_called(this, "_ZN7S1300C43v23Ev");}
void  S1300C4 ::v24(){vfunc_called(this, "_ZN7S1300C43v24Ev");}
void  S1300C4 ::v25(){vfunc_called(this, "_ZN7S1300C43v25Ev");}
void  S1300C4 ::v26(){vfunc_called(this, "_ZN7S1300C43v26Ev");}
void  S1300C4 ::v27(){vfunc_called(this, "_ZN7S1300C43v27Ev");}
void  S1300C4 ::v28(){vfunc_called(this, "_ZN7S1300C43v28Ev");}
void  S1300C4 ::v29(){vfunc_called(this, "_ZN7S1300C43v29Ev");}
void  S1300C4 ::v30(){vfunc_called(this, "_ZN7S1300C43v30Ev");}
void  S1300C4 ::v31(){vfunc_called(this, "_ZN7S1300C43v31Ev");}
void  S1300C4 ::v32(){vfunc_called(this, "_ZN7S1300C43v32Ev");}
void  S1300C4 ::v33(){vfunc_called(this, "_ZN7S1300C43v33Ev");}
void  S1300C4 ::v34(){vfunc_called(this, "_ZN7S1300C43v34Ev");}
void  S1300C4 ::v35(){vfunc_called(this, "_ZN7S1300C43v35Ev");}
void  S1300C4 ::v36(){vfunc_called(this, "_ZN7S1300C43v36Ev");}
void  S1300C4 ::v37(){vfunc_called(this, "_ZN7S1300C43v37Ev");}
void  S1300C4 ::v38(){vfunc_called(this, "_ZN7S1300C43v38Ev");}
void  S1300C4 ::v39(){vfunc_called(this, "_ZN7S1300C43v39Ev");}
void  S1300C4 ::v40(){vfunc_called(this, "_ZN7S1300C43v40Ev");}
void  S1300C4 ::v41(){vfunc_called(this, "_ZN7S1300C43v41Ev");}
void  S1300C4 ::v42(){vfunc_called(this, "_ZN7S1300C43v42Ev");}
void  S1300C4 ::v43(){vfunc_called(this, "_ZN7S1300C43v43Ev");}
void  S1300C4 ::v44(){vfunc_called(this, "_ZN7S1300C43v44Ev");}
void  S1300C4 ::v45(){vfunc_called(this, "_ZN7S1300C43v45Ev");}
void  S1300C4 ::v46(){vfunc_called(this, "_ZN7S1300C43v46Ev");}
void  S1300C4 ::v47(){vfunc_called(this, "_ZN7S1300C43v47Ev");}
void  S1300C4 ::v48(){vfunc_called(this, "_ZN7S1300C43v48Ev");}
void  S1300C4 ::v49(){vfunc_called(this, "_ZN7S1300C43v49Ev");}
void  S1300C4 ::v50(){vfunc_called(this, "_ZN7S1300C43v50Ev");}
void  S1300C4 ::v51(){vfunc_called(this, "_ZN7S1300C43v51Ev");}
void  S1300C4 ::v52(){vfunc_called(this, "_ZN7S1300C43v52Ev");}
void  S1300C4 ::v53(){vfunc_called(this, "_ZN7S1300C43v53Ev");}
void  S1300C4 ::v54(){vfunc_called(this, "_ZN7S1300C43v54Ev");}
void  S1300C4 ::v55(){vfunc_called(this, "_ZN7S1300C43v55Ev");}
void  S1300C4 ::v56(){vfunc_called(this, "_ZN7S1300C43v56Ev");}
void  S1300C4 ::v57(){vfunc_called(this, "_ZN7S1300C43v57Ev");}
void  S1300C4 ::v58(){vfunc_called(this, "_ZN7S1300C43v58Ev");}
void  S1300C4 ::v59(){vfunc_called(this, "_ZN7S1300C43v59Ev");}
void  S1300C4 ::v60(){vfunc_called(this, "_ZN7S1300C43v60Ev");}
void  S1300C4 ::v61(){vfunc_called(this, "_ZN7S1300C43v61Ev");}
void  S1300C4 ::v62(){vfunc_called(this, "_ZN7S1300C43v62Ev");}
void  S1300C4 ::v63(){vfunc_called(this, "_ZN7S1300C43v63Ev");}
void  S1300C4 ::v64(){vfunc_called(this, "_ZN7S1300C43v64Ev");}
void  S1300C4 ::v65(){vfunc_called(this, "_ZN7S1300C43v65Ev");}
void  S1300C4 ::v66(){vfunc_called(this, "_ZN7S1300C43v66Ev");}
void  S1300C4 ::v67(){vfunc_called(this, "_ZN7S1300C43v67Ev");}
void  S1300C4 ::v68(){vfunc_called(this, "_ZN7S1300C43v68Ev");}
void  S1300C4 ::v69(){vfunc_called(this, "_ZN7S1300C43v69Ev");}
void  S1300C4 ::v70(){vfunc_called(this, "_ZN7S1300C43v70Ev");}
void  S1300C4 ::v71(){vfunc_called(this, "_ZN7S1300C43v71Ev");}
void  S1300C4 ::v72(){vfunc_called(this, "_ZN7S1300C43v72Ev");}
void  S1300C4 ::v73(){vfunc_called(this, "_ZN7S1300C43v73Ev");}
void  S1300C4 ::v74(){vfunc_called(this, "_ZN7S1300C43v74Ev");}
S1300C4 ::S1300C4(){ note_ctor("S1300C4", this);} // tgen

static void Test_S1300C4()
{
  extern Class_Descriptor cd_S1300C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1300C4, buf);
    S1300C4 *dp, &lv = *(dp=new (buf) S1300C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1300C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1300C4)");
    check_field_offset(lv, s1300c4f0, ABISELECT(8,4), "S1300C4.s1300c4f0");
    check_field_offset(lv, s1300c4f1, ABISELECT(16,8), "S1300C4.s1300c4f1");
    check_field_offset(lv, s1300c4f2, ABISELECT(24,16), "S1300C4.s1300c4f2");
    check_field_offset(lv, s1300c4f3, ABISELECT(56,32), "S1300C4.s1300c4f3");
    check_field_offset(lv, s1300c4f4, ABISELECT(64,40), "S1300C4.s1300c4f4");
    check_field_offset(lv, s1300c4f5, ABISELECT(72,44), "S1300C4.s1300c4f5");
    check_field_offset(lv, s1300c4f6, ABISELECT(80,52), "S1300C4.s1300c4f6");
    test_class_info(&lv, &cd_S1300C4);
    dp->~S1300C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1300C4(Test_S1300C4, "S1300C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1300C4C1Ev();
extern void _ZN7S1300C4D1Ev();
Name_Map name_map_S1300C4[] = {
  NSPAIR(_ZN7S1300C4C1Ev),
  NSPAIR(_ZN7S1300C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1300C4[];
extern void _ZN7S1300C4D1Ev();
extern void _ZN7S1300C4D0Ev();
extern void _ZN7S1300C43v11Ev();
extern void _ZN7S1300C43v12Ev();
extern void _ZN7S1300C43v13Ev();
extern void _ZN7S1300C43v14Ev();
extern void _ZN7S1300C43v15Ev();
extern void _ZN7S1300C43v16Ev();
extern void _ZN7S1300C43v17Ev();
extern void _ZN7S1300C43v18Ev();
extern void _ZN7S1300C43v19Ev();
extern void _ZN7S1300C43v20Ev();
extern void _ZN7S1300C43v21Ev();
extern void _ZN7S1300C43v22Ev();
extern void _ZN7S1300C43v23Ev();
extern void _ZN7S1300C43v24Ev();
extern void _ZN7S1300C43v25Ev();
extern void _ZN7S1300C43v26Ev();
extern void _ZN7S1300C43v27Ev();
extern void _ZN7S1300C43v28Ev();
extern void _ZN7S1300C43v29Ev();
extern void _ZN7S1300C43v30Ev();
extern void _ZN7S1300C43v31Ev();
extern void _ZN7S1300C43v32Ev();
extern void _ZN7S1300C43v33Ev();
extern void _ZN7S1300C43v34Ev();
extern void _ZN7S1300C43v35Ev();
extern void _ZN7S1300C43v36Ev();
extern void _ZN7S1300C43v37Ev();
extern void _ZN7S1300C43v38Ev();
extern void _ZN7S1300C43v39Ev();
extern void _ZN7S1300C43v40Ev();
extern void _ZN7S1300C43v41Ev();
extern void _ZN7S1300C43v42Ev();
extern void _ZN7S1300C43v43Ev();
extern void _ZN7S1300C43v44Ev();
extern void _ZN7S1300C43v45Ev();
extern void _ZN7S1300C43v46Ev();
extern void _ZN7S1300C43v47Ev();
extern void _ZN7S1300C43v48Ev();
extern void _ZN7S1300C43v49Ev();
extern void _ZN7S1300C43v50Ev();
extern void _ZN7S1300C43v51Ev();
extern void _ZN7S1300C43v52Ev();
extern void _ZN7S1300C43v53Ev();
extern void _ZN7S1300C43v54Ev();
extern void _ZN7S1300C43v55Ev();
extern void _ZN7S1300C43v56Ev();
extern void _ZN7S1300C43v57Ev();
extern void _ZN7S1300C43v58Ev();
extern void _ZN7S1300C43v59Ev();
extern void _ZN7S1300C43v60Ev();
extern void _ZN7S1300C43v61Ev();
extern void _ZN7S1300C43v62Ev();
extern void _ZN7S1300C43v63Ev();
extern void _ZN7S1300C43v64Ev();
extern void _ZN7S1300C43v65Ev();
extern void _ZN7S1300C43v66Ev();
extern void _ZN7S1300C43v67Ev();
extern void _ZN7S1300C43v68Ev();
extern void _ZN7S1300C43v69Ev();
extern void _ZN7S1300C43v70Ev();
extern void _ZN7S1300C43v71Ev();
extern void _ZN7S1300C43v72Ev();
extern void _ZN7S1300C43v73Ev();
extern void _ZN7S1300C43v74Ev();
static  VTBL_ENTRY vtc_S1300C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1300C4[0]),
  (VTBL_ENTRY)&_ZN7S1300C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1300C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v74Ev,
};
extern VTBL_ENTRY _ZTI7S1300C4[];
extern  VTBL_ENTRY _ZTV7S1300C4[];
Class_Descriptor cd_S1300C4 = {  "S1300C4", // class name
  0,0,//no base classes
  &(vtc_S1300C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1300C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1300C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1300C3  : S1300C4 {
  unsigned int s1300c3f0:1;
  unsigned int s1300c3f1:1;
  unsigned int s1300c3f2:1;
  unsigned int s1300c3f3:1;
  unsigned int s1300c3f4:1;
  unsigned int s1300c3f5:1;
  unsigned int s1300c3f6:1;
  ::S3625C32 s1300c3f7;
  virtual  ~S1300C3(); // _ZN7S1300C3D1Ev
  virtual void  v75(); // _ZN7S1300C33v75Ev
  virtual void  v76(); // _ZN7S1300C33v76Ev
  virtual void  v77(); // _ZN7S1300C33v77Ev
  virtual void  v78(); // _ZN7S1300C33v78Ev
  virtual void  v79(); // _ZN7S1300C33v79Ev
  virtual void  v80(); // _ZN7S1300C33v80Ev
  virtual void  v81(); // _ZN7S1300C33v81Ev
  virtual void  v82(); // _ZN7S1300C33v82Ev
  virtual void  v83(); // _ZN7S1300C33v83Ev
  virtual void  v84(); // _ZN7S1300C33v84Ev
  virtual void  v85(); // _ZN7S1300C33v85Ev
  virtual void  v86(); // _ZN7S1300C33v86Ev
  virtual void  v87(); // _ZN7S1300C33v87Ev
  virtual void  v88(); // _ZN7S1300C33v88Ev
  virtual void  v89(); // _ZN7S1300C33v89Ev
  virtual void  v90(); // _ZN7S1300C33v90Ev
  virtual void  v91(); // _ZN7S1300C33v91Ev
  virtual void  v92(); // _ZN7S1300C33v92Ev
  virtual void  v93(); // _ZN7S1300C33v93Ev
  virtual void  v94(); // _ZN7S1300C33v94Ev
  S1300C3(); // tgen
};
//SIG(-1 S1300C3) C1{ BC2{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC4{ m}}


 S1300C3 ::~S1300C3(){ note_dtor("S1300C3", this);}
void  S1300C3 ::v75(){vfunc_called(this, "_ZN7S1300C33v75Ev");}
void  S1300C3 ::v76(){vfunc_called(this, "_ZN7S1300C33v76Ev");}
void  S1300C3 ::v77(){vfunc_called(this, "_ZN7S1300C33v77Ev");}
void  S1300C3 ::v78(){vfunc_called(this, "_ZN7S1300C33v78Ev");}
void  S1300C3 ::v79(){vfunc_called(this, "_ZN7S1300C33v79Ev");}
void  S1300C3 ::v80(){vfunc_called(this, "_ZN7S1300C33v80Ev");}
void  S1300C3 ::v81(){vfunc_called(this, "_ZN7S1300C33v81Ev");}
void  S1300C3 ::v82(){vfunc_called(this, "_ZN7S1300C33v82Ev");}
void  S1300C3 ::v83(){vfunc_called(this, "_ZN7S1300C33v83Ev");}
void  S1300C3 ::v84(){vfunc_called(this, "_ZN7S1300C33v84Ev");}
void  S1300C3 ::v85(){vfunc_called(this, "_ZN7S1300C33v85Ev");}
void  S1300C3 ::v86(){vfunc_called(this, "_ZN7S1300C33v86Ev");}
void  S1300C3 ::v87(){vfunc_called(this, "_ZN7S1300C33v87Ev");}
void  S1300C3 ::v88(){vfunc_called(this, "_ZN7S1300C33v88Ev");}
void  S1300C3 ::v89(){vfunc_called(this, "_ZN7S1300C33v89Ev");}
void  S1300C3 ::v90(){vfunc_called(this, "_ZN7S1300C33v90Ev");}
void  S1300C3 ::v91(){vfunc_called(this, "_ZN7S1300C33v91Ev");}
void  S1300C3 ::v92(){vfunc_called(this, "_ZN7S1300C33v92Ev");}
void  S1300C3 ::v93(){vfunc_called(this, "_ZN7S1300C33v93Ev");}
void  S1300C3 ::v94(){vfunc_called(this, "_ZN7S1300C33v94Ev");}
S1300C3 ::S1300C3(){ note_ctor("S1300C3", this);} // tgen

static void Test_S1300C3()
{
  extern Class_Descriptor cd_S1300C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S1300C3, buf);
    S1300C3 *dp, &lv = *(dp=new (buf) S1300C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S1300C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1300C3)");
    check_base_class_offset(lv, (S1300C4*), 0, "S1300C3");
    set_bf_and_test(lv, s1300c3f0, ABISELECT(96,60), 0, 1, 1, "S1300C3");
    set_bf_and_test(lv, s1300c3f1, ABISELECT(96,60), 1, 1, 1, "S1300C3");
    set_bf_and_test(lv, s1300c3f2, ABISELECT(96,60), 2, 1, 1, "S1300C3");
    set_bf_and_test(lv, s1300c3f3, ABISELECT(96,60), 3, 1, 1, "S1300C3");
    set_bf_and_test(lv, s1300c3f4, ABISELECT(96,60), 4, 1, 1, "S1300C3");
    set_bf_and_test(lv, s1300c3f5, ABISELECT(96,60), 5, 1, 1, "S1300C3");
    set_bf_and_test(lv, s1300c3f6, ABISELECT(96,60), 6, 1, 1, "S1300C3");
    check_field_offset(lv, s1300c3f7, ABISELECT(97,61), "S1300C3.s1300c3f7");
    test_class_info(&lv, &cd_S1300C3);
    dp->~S1300C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1300C3(Test_S1300C3, "S1300C3", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN7S1300C3C1Ev();
extern void _ZN7S1300C3D1Ev();
Name_Map name_map_S1300C3[] = {
  NSPAIR(_ZN7S1300C3C1Ev),
  NSPAIR(_ZN7S1300C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1300C4;
extern VTBL_ENTRY _ZTI7S1300C4[];
extern  VTBL_ENTRY _ZTV7S1300C4[];
static Base_Class bases_S1300C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1300C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1300C3[];
extern void _ZN7S1300C3D1Ev();
extern void _ZN7S1300C3D0Ev();
extern void _ZN7S1300C43v11Ev();
extern void _ZN7S1300C43v12Ev();
extern void _ZN7S1300C43v13Ev();
extern void _ZN7S1300C43v14Ev();
extern void _ZN7S1300C43v15Ev();
extern void _ZN7S1300C43v16Ev();
extern void _ZN7S1300C43v17Ev();
extern void _ZN7S1300C43v18Ev();
extern void _ZN7S1300C43v19Ev();
extern void _ZN7S1300C43v20Ev();
extern void _ZN7S1300C43v21Ev();
extern void _ZN7S1300C43v22Ev();
extern void _ZN7S1300C43v23Ev();
extern void _ZN7S1300C43v24Ev();
extern void _ZN7S1300C43v25Ev();
extern void _ZN7S1300C43v26Ev();
extern void _ZN7S1300C43v27Ev();
extern void _ZN7S1300C43v28Ev();
extern void _ZN7S1300C43v29Ev();
extern void _ZN7S1300C43v30Ev();
extern void _ZN7S1300C43v31Ev();
extern void _ZN7S1300C43v32Ev();
extern void _ZN7S1300C43v33Ev();
extern void _ZN7S1300C43v34Ev();
extern void _ZN7S1300C43v35Ev();
extern void _ZN7S1300C43v36Ev();
extern void _ZN7S1300C43v37Ev();
extern void _ZN7S1300C43v38Ev();
extern void _ZN7S1300C43v39Ev();
extern void _ZN7S1300C43v40Ev();
extern void _ZN7S1300C43v41Ev();
extern void _ZN7S1300C43v42Ev();
extern void _ZN7S1300C43v43Ev();
extern void _ZN7S1300C43v44Ev();
extern void _ZN7S1300C43v45Ev();
extern void _ZN7S1300C43v46Ev();
extern void _ZN7S1300C43v47Ev();
extern void _ZN7S1300C43v48Ev();
extern void _ZN7S1300C43v49Ev();
extern void _ZN7S1300C43v50Ev();
extern void _ZN7S1300C43v51Ev();
extern void _ZN7S1300C43v52Ev();
extern void _ZN7S1300C43v53Ev();
extern void _ZN7S1300C43v54Ev();
extern void _ZN7S1300C43v55Ev();
extern void _ZN7S1300C43v56Ev();
extern void _ZN7S1300C43v57Ev();
extern void _ZN7S1300C43v58Ev();
extern void _ZN7S1300C43v59Ev();
extern void _ZN7S1300C43v60Ev();
extern void _ZN7S1300C43v61Ev();
extern void _ZN7S1300C43v62Ev();
extern void _ZN7S1300C43v63Ev();
extern void _ZN7S1300C43v64Ev();
extern void _ZN7S1300C43v65Ev();
extern void _ZN7S1300C43v66Ev();
extern void _ZN7S1300C43v67Ev();
extern void _ZN7S1300C43v68Ev();
extern void _ZN7S1300C43v69Ev();
extern void _ZN7S1300C43v70Ev();
extern void _ZN7S1300C43v71Ev();
extern void _ZN7S1300C43v72Ev();
extern void _ZN7S1300C43v73Ev();
extern void _ZN7S1300C43v74Ev();
extern void _ZN7S1300C33v75Ev();
extern void _ZN7S1300C33v76Ev();
extern void _ZN7S1300C33v77Ev();
extern void _ZN7S1300C33v78Ev();
extern void _ZN7S1300C33v79Ev();
extern void _ZN7S1300C33v80Ev();
extern void _ZN7S1300C33v81Ev();
extern void _ZN7S1300C33v82Ev();
extern void _ZN7S1300C33v83Ev();
extern void _ZN7S1300C33v84Ev();
extern void _ZN7S1300C33v85Ev();
extern void _ZN7S1300C33v86Ev();
extern void _ZN7S1300C33v87Ev();
extern void _ZN7S1300C33v88Ev();
extern void _ZN7S1300C33v89Ev();
extern void _ZN7S1300C33v90Ev();
extern void _ZN7S1300C33v91Ev();
extern void _ZN7S1300C33v92Ev();
extern void _ZN7S1300C33v93Ev();
extern void _ZN7S1300C33v94Ev();
static  VTBL_ENTRY vtc_S1300C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1300C3[0]),
  (VTBL_ENTRY)&_ZN7S1300C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1300C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v94Ev,
};
extern VTBL_ENTRY _ZTI7S1300C3[];
extern  VTBL_ENTRY _ZTV7S1300C3[];
Class_Descriptor cd_S1300C3 = {  "S1300C3", // class name
  bases_S1300C3, 1,
  &(vtc_S1300C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI7S1300C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1300C3),88, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1300C2  : S1300C3 {
  ::S674C42 s1300c2f0;
  virtual  ~S1300C2(); // _ZN7S1300C2D1Ev
  virtual void  v95(); // _ZN7S1300C23v95Ev
  virtual void  v96(); // _ZN7S1300C23v96Ev
  virtual void  v97(); // _ZN7S1300C23v97Ev
  virtual void  v98(); // _ZN7S1300C23v98Ev
  S1300C2(); // tgen
};
//SIG(-1 S1300C2) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC5{ m}} vd v1 v2 v3 v4 FC6{ BC7{ BC8{ m Fp Fi[2]}}}}


 S1300C2 ::~S1300C2(){ note_dtor("S1300C2", this);}
void  S1300C2 ::v95(){vfunc_called(this, "_ZN7S1300C23v95Ev");}
void  S1300C2 ::v96(){vfunc_called(this, "_ZN7S1300C23v96Ev");}
void  S1300C2 ::v97(){vfunc_called(this, "_ZN7S1300C23v97Ev");}
void  S1300C2 ::v98(){vfunc_called(this, "_ZN7S1300C23v98Ev");}
S1300C2 ::S1300C2(){ note_ctor("S1300C2", this);} // tgen

static void Test_S1300C2()
{
  extern Class_Descriptor cd_S1300C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(16,20)];
    init_test(&cd_S1300C2, buf);
    S1300C2 *dp, &lv = *(dp=new (buf) S1300C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(120,76), "sizeof(S1300C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1300C2)");
    check_base_class_offset(lv, (S1300C4*)(S1300C3*), 0, "S1300C2");
    check_base_class_offset(lv, (S1300C3*), 0, "S1300C2");
    check_field_offset(lv, s1300c2f0, ABISELECT(104,64), "S1300C2.s1300c2f0");
    test_class_info(&lv, &cd_S1300C2);
    dp->~S1300C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1300C2(Test_S1300C2, "S1300C2", ABISELECT(120,76));

#else // __cplusplus

extern void _ZN7S1300C2C1Ev();
extern void _ZN7S1300C2D1Ev();
Name_Map name_map_S1300C2[] = {
  NSPAIR(_ZN7S1300C2C1Ev),
  NSPAIR(_ZN7S1300C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1300C4;
extern VTBL_ENTRY _ZTI7S1300C4[];
extern  VTBL_ENTRY _ZTV7S1300C4[];
extern Class_Descriptor cd_S1300C3;
extern VTBL_ENTRY _ZTI7S1300C3[];
extern  VTBL_ENTRY _ZTV7S1300C3[];
static Base_Class bases_S1300C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1300C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1300C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1300C2[];
extern void _ZN7S1300C2D1Ev();
extern void _ZN7S1300C2D0Ev();
extern void _ZN7S1300C43v11Ev();
extern void _ZN7S1300C43v12Ev();
extern void _ZN7S1300C43v13Ev();
extern void _ZN7S1300C43v14Ev();
extern void _ZN7S1300C43v15Ev();
extern void _ZN7S1300C43v16Ev();
extern void _ZN7S1300C43v17Ev();
extern void _ZN7S1300C43v18Ev();
extern void _ZN7S1300C43v19Ev();
extern void _ZN7S1300C43v20Ev();
extern void _ZN7S1300C43v21Ev();
extern void _ZN7S1300C43v22Ev();
extern void _ZN7S1300C43v23Ev();
extern void _ZN7S1300C43v24Ev();
extern void _ZN7S1300C43v25Ev();
extern void _ZN7S1300C43v26Ev();
extern void _ZN7S1300C43v27Ev();
extern void _ZN7S1300C43v28Ev();
extern void _ZN7S1300C43v29Ev();
extern void _ZN7S1300C43v30Ev();
extern void _ZN7S1300C43v31Ev();
extern void _ZN7S1300C43v32Ev();
extern void _ZN7S1300C43v33Ev();
extern void _ZN7S1300C43v34Ev();
extern void _ZN7S1300C43v35Ev();
extern void _ZN7S1300C43v36Ev();
extern void _ZN7S1300C43v37Ev();
extern void _ZN7S1300C43v38Ev();
extern void _ZN7S1300C43v39Ev();
extern void _ZN7S1300C43v40Ev();
extern void _ZN7S1300C43v41Ev();
extern void _ZN7S1300C43v42Ev();
extern void _ZN7S1300C43v43Ev();
extern void _ZN7S1300C43v44Ev();
extern void _ZN7S1300C43v45Ev();
extern void _ZN7S1300C43v46Ev();
extern void _ZN7S1300C43v47Ev();
extern void _ZN7S1300C43v48Ev();
extern void _ZN7S1300C43v49Ev();
extern void _ZN7S1300C43v50Ev();
extern void _ZN7S1300C43v51Ev();
extern void _ZN7S1300C43v52Ev();
extern void _ZN7S1300C43v53Ev();
extern void _ZN7S1300C43v54Ev();
extern void _ZN7S1300C43v55Ev();
extern void _ZN7S1300C43v56Ev();
extern void _ZN7S1300C43v57Ev();
extern void _ZN7S1300C43v58Ev();
extern void _ZN7S1300C43v59Ev();
extern void _ZN7S1300C43v60Ev();
extern void _ZN7S1300C43v61Ev();
extern void _ZN7S1300C43v62Ev();
extern void _ZN7S1300C43v63Ev();
extern void _ZN7S1300C43v64Ev();
extern void _ZN7S1300C43v65Ev();
extern void _ZN7S1300C43v66Ev();
extern void _ZN7S1300C43v67Ev();
extern void _ZN7S1300C43v68Ev();
extern void _ZN7S1300C43v69Ev();
extern void _ZN7S1300C43v70Ev();
extern void _ZN7S1300C43v71Ev();
extern void _ZN7S1300C43v72Ev();
extern void _ZN7S1300C43v73Ev();
extern void _ZN7S1300C43v74Ev();
extern void _ZN7S1300C33v75Ev();
extern void _ZN7S1300C33v76Ev();
extern void _ZN7S1300C33v77Ev();
extern void _ZN7S1300C33v78Ev();
extern void _ZN7S1300C33v79Ev();
extern void _ZN7S1300C33v80Ev();
extern void _ZN7S1300C33v81Ev();
extern void _ZN7S1300C33v82Ev();
extern void _ZN7S1300C33v83Ev();
extern void _ZN7S1300C33v84Ev();
extern void _ZN7S1300C33v85Ev();
extern void _ZN7S1300C33v86Ev();
extern void _ZN7S1300C33v87Ev();
extern void _ZN7S1300C33v88Ev();
extern void _ZN7S1300C33v89Ev();
extern void _ZN7S1300C33v90Ev();
extern void _ZN7S1300C33v91Ev();
extern void _ZN7S1300C33v92Ev();
extern void _ZN7S1300C33v93Ev();
extern void _ZN7S1300C33v94Ev();
extern void _ZN7S1300C23v95Ev();
extern void _ZN7S1300C23v96Ev();
extern void _ZN7S1300C23v97Ev();
extern void _ZN7S1300C23v98Ev();
static  VTBL_ENTRY vtc_S1300C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1300C2[0]),
  (VTBL_ENTRY)&_ZN7S1300C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1300C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1300C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1300C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1300C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1300C23v98Ev,
};
extern VTBL_ENTRY _ZTI7S1300C2[];
extern  VTBL_ENTRY _ZTV7S1300C2[];
Class_Descriptor cd_S1300C2 = {  "S1300C2", // class name
  bases_S1300C2, 2,
  &(vtc_S1300C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(120,76), // object size
  NSPAIRA(_ZTI7S1300C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1300C2),92, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1300C1  : S1300C2 {
  int s1300c1f0[2];
  ::S674C29_nt s1300c1f1;
  ::S674C29_nt s1300c1f2;
  ::S674C29_nt s1300c1f3;
  ::S674C29_nt s1300c1f4;
  int s1300c1f5[2];
  ::S674C29_nt s1300c1f6;
  int s1300c1f7;
  unsigned int s1300c1f8:1;
  unsigned int s1300c1f9:1;
  unsigned int s1300c1f10:1;
  unsigned int s1300c1f11:1;
  unsigned int s1300c1f12:1;
  unsigned int s1300c1f13:1;
  unsigned int s1300c1f14:1;
  unsigned int s1300c1f15:1;
  unsigned int s1300c1f16:1;
  unsigned int s1300c1f17:1;
  int s1300c1f18;
  ::S674C29_nt s1300c1f19;
  int s1300c1f20[2];
  char s1300c1f21;
  ::S674C29_nt s1300c1f22;
  ::S674C29_nt s1300c1f23;
  virtual  ~S1300C1(); // _ZN7S1300C1D1Ev
  virtual void  v1(); // _ZN7S1300C12v1Ev
  virtual void  v2(); // _ZN7S1300C12v2Ev
  virtual void  v3(); // _ZN7S1300C12v3Ev
  virtual void  v4(); // _ZN7S1300C12v4Ev
  virtual void  v5(); // _ZN7S1300C12v5Ev
  virtual void  v6(); // _ZN7S1300C12v6Ev
  virtual void  v7(); // _ZN7S1300C12v7Ev
  virtual void  v8(); // _ZN7S1300C12v8Ev
  virtual void  v9(); // _ZN7S1300C12v9Ev
  virtual void  v10(); // _ZN7S1300C13v10Ev
  S1300C1(); // tgen
};
//SIG(1 S1300C1) C1{ BC2{ BC3{ BC4{ vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC6{ m}} vd v95 v96 v97 v98 FC7{ BC8{ BC9{ m Fp Fi[2]}}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fi[2] FC10{ m Fi[3]} FC10 FC10 FC10 Fi[2] FC10 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi FC10 Fi[2] Fc FC10 FC10}


 S1300C1 ::~S1300C1(){ note_dtor("S1300C1", this);}
void  S1300C1 ::v1(){vfunc_called(this, "_ZN7S1300C12v1Ev");}
void  S1300C1 ::v2(){vfunc_called(this, "_ZN7S1300C12v2Ev");}
void  S1300C1 ::v3(){vfunc_called(this, "_ZN7S1300C12v3Ev");}
void  S1300C1 ::v4(){vfunc_called(this, "_ZN7S1300C12v4Ev");}
void  S1300C1 ::v5(){vfunc_called(this, "_ZN7S1300C12v5Ev");}
void  S1300C1 ::v6(){vfunc_called(this, "_ZN7S1300C12v6Ev");}
void  S1300C1 ::v7(){vfunc_called(this, "_ZN7S1300C12v7Ev");}
void  S1300C1 ::v8(){vfunc_called(this, "_ZN7S1300C12v8Ev");}
void  S1300C1 ::v9(){vfunc_called(this, "_ZN7S1300C12v9Ev");}
void  S1300C1 ::v10(){vfunc_called(this, "_ZN7S1300C13v10Ev");}
S1300C1 ::S1300C1(){ note_ctor("S1300C1", this);} // tgen

static void Test_S1300C1()
{
  extern Class_Descriptor cd_S1300C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(33,54)];
    init_test(&cd_S1300C1, buf);
    S1300C1 *dp, &lv = *(dp=new (buf) S1300C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(256,212), "sizeof(S1300C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1300C1)");
    check_base_class_offset(lv, (S1300C4*)(S1300C3*)(S1300C2*), 0, "S1300C1");
    check_base_class_offset(lv, (S1300C3*)(S1300C2*), 0, "S1300C1");
    check_base_class_offset(lv, (S1300C2*), 0, "S1300C1");
    check_field_offset(lv, s1300c1f0, ABISELECT(120,76), "S1300C1.s1300c1f0");
    check_field_offset(lv, s1300c1f1, ABISELECT(128,84), "S1300C1.s1300c1f1");
    check_field_offset(lv, s1300c1f2, ABISELECT(140,96), "S1300C1.s1300c1f2");
    check_field_offset(lv, s1300c1f3, ABISELECT(152,108), "S1300C1.s1300c1f3");
    check_field_offset(lv, s1300c1f4, ABISELECT(164,120), "S1300C1.s1300c1f4");
    check_field_offset(lv, s1300c1f5, ABISELECT(176,132), "S1300C1.s1300c1f5");
    check_field_offset(lv, s1300c1f6, ABISELECT(184,140), "S1300C1.s1300c1f6");
    check_field_offset(lv, s1300c1f7, ABISELECT(196,152), "S1300C1.s1300c1f7");
    set_bf_and_test(lv, s1300c1f8, ABISELECT(200,156), 0, 1, 1, "S1300C1");
    set_bf_and_test(lv, s1300c1f9, ABISELECT(200,156), 1, 1, 1, "S1300C1");
    set_bf_and_test(lv, s1300c1f10, ABISELECT(200,156), 2, 1, 1, "S1300C1");
    set_bf_and_test(lv, s1300c1f11, ABISELECT(200,156), 3, 1, 1, "S1300C1");
    set_bf_and_test(lv, s1300c1f12, ABISELECT(200,156), 4, 1, 1, "S1300C1");
    set_bf_and_test(lv, s1300c1f13, ABISELECT(200,156), 5, 1, 1, "S1300C1");
    set_bf_and_test(lv, s1300c1f14, ABISELECT(200,156), 6, 1, 1, "S1300C1");
    set_bf_and_test(lv, s1300c1f15, ABISELECT(200,156), 7, 1, 1, "S1300C1");
    set_bf_and_test(lv, s1300c1f16, ABISELECT(201,157), 0, 1, 1, "S1300C1");
    set_bf_and_test(lv, s1300c1f17, ABISELECT(201,157), 1, 1, 1, "S1300C1");
    check_field_offset(lv, s1300c1f18, ABISELECT(204,160), "S1300C1.s1300c1f18");
    check_field_offset(lv, s1300c1f19, ABISELECT(208,164), "S1300C1.s1300c1f19");
    check_field_offset(lv, s1300c1f20, ABISELECT(220,176), "S1300C1.s1300c1f20");
    check_field_offset(lv, s1300c1f21, ABISELECT(228,184), "S1300C1.s1300c1f21");
    check_field_offset(lv, s1300c1f22, ABISELECT(232,188), "S1300C1.s1300c1f22");
    check_field_offset(lv, s1300c1f23, ABISELECT(244,200), "S1300C1.s1300c1f23");
    test_class_info(&lv, &cd_S1300C1);
    dp->~S1300C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1300C1(Test_S1300C1, "S1300C1", ABISELECT(256,212));

#else // __cplusplus

extern void _ZN7S1300C1C1Ev();
extern void _ZN7S1300C1D1Ev();
Name_Map name_map_S1300C1[] = {
  NSPAIR(_ZN7S1300C1C1Ev),
  NSPAIR(_ZN7S1300C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1300C4;
extern VTBL_ENTRY _ZTI7S1300C4[];
extern  VTBL_ENTRY _ZTV7S1300C4[];
extern Class_Descriptor cd_S1300C3;
extern VTBL_ENTRY _ZTI7S1300C3[];
extern  VTBL_ENTRY _ZTV7S1300C3[];
extern Class_Descriptor cd_S1300C2;
extern VTBL_ENTRY _ZTI7S1300C2[];
extern  VTBL_ENTRY _ZTV7S1300C2[];
static Base_Class bases_S1300C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1300C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1300C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1300C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1300C1[];
extern void _ZN7S1300C1D1Ev();
extern void _ZN7S1300C1D0Ev();
extern void _ZN7S1300C43v11Ev();
extern void _ZN7S1300C43v12Ev();
extern void _ZN7S1300C43v13Ev();
extern void _ZN7S1300C43v14Ev();
extern void _ZN7S1300C43v15Ev();
extern void _ZN7S1300C43v16Ev();
extern void _ZN7S1300C43v17Ev();
extern void _ZN7S1300C43v18Ev();
extern void _ZN7S1300C43v19Ev();
extern void _ZN7S1300C43v20Ev();
extern void _ZN7S1300C43v21Ev();
extern void _ZN7S1300C43v22Ev();
extern void _ZN7S1300C43v23Ev();
extern void _ZN7S1300C43v24Ev();
extern void _ZN7S1300C43v25Ev();
extern void _ZN7S1300C43v26Ev();
extern void _ZN7S1300C43v27Ev();
extern void _ZN7S1300C43v28Ev();
extern void _ZN7S1300C43v29Ev();
extern void _ZN7S1300C43v30Ev();
extern void _ZN7S1300C43v31Ev();
extern void _ZN7S1300C43v32Ev();
extern void _ZN7S1300C43v33Ev();
extern void _ZN7S1300C43v34Ev();
extern void _ZN7S1300C43v35Ev();
extern void _ZN7S1300C43v36Ev();
extern void _ZN7S1300C43v37Ev();
extern void _ZN7S1300C43v38Ev();
extern void _ZN7S1300C43v39Ev();
extern void _ZN7S1300C43v40Ev();
extern void _ZN7S1300C43v41Ev();
extern void _ZN7S1300C43v42Ev();
extern void _ZN7S1300C43v43Ev();
extern void _ZN7S1300C43v44Ev();
extern void _ZN7S1300C43v45Ev();
extern void _ZN7S1300C43v46Ev();
extern void _ZN7S1300C43v47Ev();
extern void _ZN7S1300C43v48Ev();
extern void _ZN7S1300C43v49Ev();
extern void _ZN7S1300C43v50Ev();
extern void _ZN7S1300C43v51Ev();
extern void _ZN7S1300C43v52Ev();
extern void _ZN7S1300C43v53Ev();
extern void _ZN7S1300C43v54Ev();
extern void _ZN7S1300C43v55Ev();
extern void _ZN7S1300C43v56Ev();
extern void _ZN7S1300C43v57Ev();
extern void _ZN7S1300C43v58Ev();
extern void _ZN7S1300C43v59Ev();
extern void _ZN7S1300C43v60Ev();
extern void _ZN7S1300C43v61Ev();
extern void _ZN7S1300C43v62Ev();
extern void _ZN7S1300C43v63Ev();
extern void _ZN7S1300C43v64Ev();
extern void _ZN7S1300C43v65Ev();
extern void _ZN7S1300C43v66Ev();
extern void _ZN7S1300C43v67Ev();
extern void _ZN7S1300C43v68Ev();
extern void _ZN7S1300C43v69Ev();
extern void _ZN7S1300C43v70Ev();
extern void _ZN7S1300C43v71Ev();
extern void _ZN7S1300C43v72Ev();
extern void _ZN7S1300C43v73Ev();
extern void _ZN7S1300C43v74Ev();
extern void _ZN7S1300C33v75Ev();
extern void _ZN7S1300C33v76Ev();
extern void _ZN7S1300C33v77Ev();
extern void _ZN7S1300C33v78Ev();
extern void _ZN7S1300C33v79Ev();
extern void _ZN7S1300C33v80Ev();
extern void _ZN7S1300C33v81Ev();
extern void _ZN7S1300C33v82Ev();
extern void _ZN7S1300C33v83Ev();
extern void _ZN7S1300C33v84Ev();
extern void _ZN7S1300C33v85Ev();
extern void _ZN7S1300C33v86Ev();
extern void _ZN7S1300C33v87Ev();
extern void _ZN7S1300C33v88Ev();
extern void _ZN7S1300C33v89Ev();
extern void _ZN7S1300C33v90Ev();
extern void _ZN7S1300C33v91Ev();
extern void _ZN7S1300C33v92Ev();
extern void _ZN7S1300C33v93Ev();
extern void _ZN7S1300C33v94Ev();
extern void _ZN7S1300C23v95Ev();
extern void _ZN7S1300C23v96Ev();
extern void _ZN7S1300C23v97Ev();
extern void _ZN7S1300C23v98Ev();
extern void _ZN7S1300C12v1Ev();
extern void _ZN7S1300C12v2Ev();
extern void _ZN7S1300C12v3Ev();
extern void _ZN7S1300C12v4Ev();
extern void _ZN7S1300C12v5Ev();
extern void _ZN7S1300C12v6Ev();
extern void _ZN7S1300C12v7Ev();
extern void _ZN7S1300C12v8Ev();
extern void _ZN7S1300C12v9Ev();
extern void _ZN7S1300C13v10Ev();
static  VTBL_ENTRY vtc_S1300C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1300C1[0]),
  (VTBL_ENTRY)&_ZN7S1300C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1300C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1300C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1300C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1300C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1300C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1300C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1300C23v98Ev,
  (VTBL_ENTRY)&_ZN7S1300C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1300C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1300C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1300C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1300C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1300C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1300C12v7Ev,
  (VTBL_ENTRY)&_ZN7S1300C12v8Ev,
  (VTBL_ENTRY)&_ZN7S1300C12v9Ev,
  (VTBL_ENTRY)&_ZN7S1300C13v10Ev,
};
extern VTBL_ENTRY _ZTI7S1300C1[];
extern  VTBL_ENTRY _ZTV7S1300C1[];
Class_Descriptor cd_S1300C1 = {  "S1300C1", // class name
  bases_S1300C1, 3,
  &(vtc_S1300C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,212), // object size
  NSPAIRA(_ZTI7S1300C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1300C1),102, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1317C4  {
  int s1317c4f0;
  __tsi64 s1317c4f1;
  void *s1317c4f2[4];
  int s1317c4f3[2];
  void *s1317c4f4;
  ::S674C6_nt s1317c4f5;
  void *s1317c4f6[2];
  virtual  ~S1317C4(); // _ZN7S1317C4D1Ev
  virtual void  v15(); // _ZN7S1317C43v15Ev
  virtual void  v16(); // _ZN7S1317C43v16Ev
  virtual void  v17(); // _ZN7S1317C43v17Ev
  virtual void  v18(); // _ZN7S1317C43v18Ev
  virtual void  v19(); // _ZN7S1317C43v19Ev
  virtual void  v20(); // _ZN7S1317C43v20Ev
  virtual void  v21(); // _ZN7S1317C43v21Ev
  virtual void  v22(); // _ZN7S1317C43v22Ev
  virtual void  v23(); // _ZN7S1317C43v23Ev
  virtual void  v24(); // _ZN7S1317C43v24Ev
  virtual void  v25(); // _ZN7S1317C43v25Ev
  virtual void  v26(); // _ZN7S1317C43v26Ev
  virtual void  v27(); // _ZN7S1317C43v27Ev
  virtual void  v28(); // _ZN7S1317C43v28Ev
  virtual void  v29(); // _ZN7S1317C43v29Ev
  virtual void  v30(); // _ZN7S1317C43v30Ev
  virtual void  v31(); // _ZN7S1317C43v31Ev
  virtual void  v32(); // _ZN7S1317C43v32Ev
  virtual void  v33(); // _ZN7S1317C43v33Ev
  virtual void  v34(); // _ZN7S1317C43v34Ev
  virtual void  v35(); // _ZN7S1317C43v35Ev
  virtual void  v36(); // _ZN7S1317C43v36Ev
  virtual void  v37(); // _ZN7S1317C43v37Ev
  virtual void  v38(); // _ZN7S1317C43v38Ev
  virtual void  v39(); // _ZN7S1317C43v39Ev
  virtual void  v40(); // _ZN7S1317C43v40Ev
  virtual void  v41(); // _ZN7S1317C43v41Ev
  virtual void  v42(); // _ZN7S1317C43v42Ev
  virtual void  v43(); // _ZN7S1317C43v43Ev
  virtual void  v44(); // _ZN7S1317C43v44Ev
  virtual void  v45(); // _ZN7S1317C43v45Ev
  virtual void  v46(); // _ZN7S1317C43v46Ev
  virtual void  v47(); // _ZN7S1317C43v47Ev
  virtual void  v48(); // _ZN7S1317C43v48Ev
  virtual void  v49(); // _ZN7S1317C43v49Ev
  virtual void  v50(); // _ZN7S1317C43v50Ev
  virtual void  v51(); // _ZN7S1317C43v51Ev
  virtual void  v52(); // _ZN7S1317C43v52Ev
  virtual void  v53(); // _ZN7S1317C43v53Ev
  virtual void  v54(); // _ZN7S1317C43v54Ev
  virtual void  v55(); // _ZN7S1317C43v55Ev
  virtual void  v56(); // _ZN7S1317C43v56Ev
  virtual void  v57(); // _ZN7S1317C43v57Ev
  virtual void  v58(); // _ZN7S1317C43v58Ev
  virtual void  v59(); // _ZN7S1317C43v59Ev
  virtual void  v60(); // _ZN7S1317C43v60Ev
  virtual void  v61(); // _ZN7S1317C43v61Ev
  virtual void  v62(); // _ZN7S1317C43v62Ev
  virtual void  v63(); // _ZN7S1317C43v63Ev
  virtual void  v64(); // _ZN7S1317C43v64Ev
  virtual void  v65(); // _ZN7S1317C43v65Ev
  virtual void  v66(); // _ZN7S1317C43v66Ev
  virtual void  v67(); // _ZN7S1317C43v67Ev
  virtual void  v68(); // _ZN7S1317C43v68Ev
  virtual void  v69(); // _ZN7S1317C43v69Ev
  virtual void  v70(); // _ZN7S1317C43v70Ev
  virtual void  v71(); // _ZN7S1317C43v71Ev
  virtual void  v72(); // _ZN7S1317C43v72Ev
  virtual void  v73(); // _ZN7S1317C43v73Ev
  virtual void  v74(); // _ZN7S1317C43v74Ev
  virtual void  v75(); // _ZN7S1317C43v75Ev
  virtual void  v76(); // _ZN7S1317C43v76Ev
  virtual void  v77(); // _ZN7S1317C43v77Ev
  virtual void  v78(); // _ZN7S1317C43v78Ev
  S1317C4(); // tgen
};
//SIG(-1 S1317C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1317C4 ::~S1317C4(){ note_dtor("S1317C4", this);}
void  S1317C4 ::v15(){vfunc_called(this, "_ZN7S1317C43v15Ev");}
void  S1317C4 ::v16(){vfunc_called(this, "_ZN7S1317C43v16Ev");}
void  S1317C4 ::v17(){vfunc_called(this, "_ZN7S1317C43v17Ev");}
void  S1317C4 ::v18(){vfunc_called(this, "_ZN7S1317C43v18Ev");}
void  S1317C4 ::v19(){vfunc_called(this, "_ZN7S1317C43v19Ev");}
void  S1317C4 ::v20(){vfunc_called(this, "_ZN7S1317C43v20Ev");}
void  S1317C4 ::v21(){vfunc_called(this, "_ZN7S1317C43v21Ev");}
void  S1317C4 ::v22(){vfunc_called(this, "_ZN7S1317C43v22Ev");}
void  S1317C4 ::v23(){vfunc_called(this, "_ZN7S1317C43v23Ev");}
void  S1317C4 ::v24(){vfunc_called(this, "_ZN7S1317C43v24Ev");}
void  S1317C4 ::v25(){vfunc_called(this, "_ZN7S1317C43v25Ev");}
void  S1317C4 ::v26(){vfunc_called(this, "_ZN7S1317C43v26Ev");}
void  S1317C4 ::v27(){vfunc_called(this, "_ZN7S1317C43v27Ev");}
void  S1317C4 ::v28(){vfunc_called(this, "_ZN7S1317C43v28Ev");}
void  S1317C4 ::v29(){vfunc_called(this, "_ZN7S1317C43v29Ev");}
void  S1317C4 ::v30(){vfunc_called(this, "_ZN7S1317C43v30Ev");}
void  S1317C4 ::v31(){vfunc_called(this, "_ZN7S1317C43v31Ev");}
void  S1317C4 ::v32(){vfunc_called(this, "_ZN7S1317C43v32Ev");}
void  S1317C4 ::v33(){vfunc_called(this, "_ZN7S1317C43v33Ev");}
void  S1317C4 ::v34(){vfunc_called(this, "_ZN7S1317C43v34Ev");}
void  S1317C4 ::v35(){vfunc_called(this, "_ZN7S1317C43v35Ev");}
void  S1317C4 ::v36(){vfunc_called(this, "_ZN7S1317C43v36Ev");}
void  S1317C4 ::v37(){vfunc_called(this, "_ZN7S1317C43v37Ev");}
void  S1317C4 ::v38(){vfunc_called(this, "_ZN7S1317C43v38Ev");}
void  S1317C4 ::v39(){vfunc_called(this, "_ZN7S1317C43v39Ev");}
void  S1317C4 ::v40(){vfunc_called(this, "_ZN7S1317C43v40Ev");}
void  S1317C4 ::v41(){vfunc_called(this, "_ZN7S1317C43v41Ev");}
void  S1317C4 ::v42(){vfunc_called(this, "_ZN7S1317C43v42Ev");}
void  S1317C4 ::v43(){vfunc_called(this, "_ZN7S1317C43v43Ev");}
void  S1317C4 ::v44(){vfunc_called(this, "_ZN7S1317C43v44Ev");}
void  S1317C4 ::v45(){vfunc_called(this, "_ZN7S1317C43v45Ev");}
void  S1317C4 ::v46(){vfunc_called(this, "_ZN7S1317C43v46Ev");}
void  S1317C4 ::v47(){vfunc_called(this, "_ZN7S1317C43v47Ev");}
void  S1317C4 ::v48(){vfunc_called(this, "_ZN7S1317C43v48Ev");}
void  S1317C4 ::v49(){vfunc_called(this, "_ZN7S1317C43v49Ev");}
void  S1317C4 ::v50(){vfunc_called(this, "_ZN7S1317C43v50Ev");}
void  S1317C4 ::v51(){vfunc_called(this, "_ZN7S1317C43v51Ev");}
void  S1317C4 ::v52(){vfunc_called(this, "_ZN7S1317C43v52Ev");}
void  S1317C4 ::v53(){vfunc_called(this, "_ZN7S1317C43v53Ev");}
void  S1317C4 ::v54(){vfunc_called(this, "_ZN7S1317C43v54Ev");}
void  S1317C4 ::v55(){vfunc_called(this, "_ZN7S1317C43v55Ev");}
void  S1317C4 ::v56(){vfunc_called(this, "_ZN7S1317C43v56Ev");}
void  S1317C4 ::v57(){vfunc_called(this, "_ZN7S1317C43v57Ev");}
void  S1317C4 ::v58(){vfunc_called(this, "_ZN7S1317C43v58Ev");}
void  S1317C4 ::v59(){vfunc_called(this, "_ZN7S1317C43v59Ev");}
void  S1317C4 ::v60(){vfunc_called(this, "_ZN7S1317C43v60Ev");}
void  S1317C4 ::v61(){vfunc_called(this, "_ZN7S1317C43v61Ev");}
void  S1317C4 ::v62(){vfunc_called(this, "_ZN7S1317C43v62Ev");}
void  S1317C4 ::v63(){vfunc_called(this, "_ZN7S1317C43v63Ev");}
void  S1317C4 ::v64(){vfunc_called(this, "_ZN7S1317C43v64Ev");}
void  S1317C4 ::v65(){vfunc_called(this, "_ZN7S1317C43v65Ev");}
void  S1317C4 ::v66(){vfunc_called(this, "_ZN7S1317C43v66Ev");}
void  S1317C4 ::v67(){vfunc_called(this, "_ZN7S1317C43v67Ev");}
void  S1317C4 ::v68(){vfunc_called(this, "_ZN7S1317C43v68Ev");}
void  S1317C4 ::v69(){vfunc_called(this, "_ZN7S1317C43v69Ev");}
void  S1317C4 ::v70(){vfunc_called(this, "_ZN7S1317C43v70Ev");}
void  S1317C4 ::v71(){vfunc_called(this, "_ZN7S1317C43v71Ev");}
void  S1317C4 ::v72(){vfunc_called(this, "_ZN7S1317C43v72Ev");}
void  S1317C4 ::v73(){vfunc_called(this, "_ZN7S1317C43v73Ev");}
void  S1317C4 ::v74(){vfunc_called(this, "_ZN7S1317C43v74Ev");}
void  S1317C4 ::v75(){vfunc_called(this, "_ZN7S1317C43v75Ev");}
void  S1317C4 ::v76(){vfunc_called(this, "_ZN7S1317C43v76Ev");}
void  S1317C4 ::v77(){vfunc_called(this, "_ZN7S1317C43v77Ev");}
void  S1317C4 ::v78(){vfunc_called(this, "_ZN7S1317C43v78Ev");}
S1317C4 ::S1317C4(){ note_ctor("S1317C4", this);} // tgen

static void Test_S1317C4()
{
  extern Class_Descriptor cd_S1317C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1317C4, buf);
    S1317C4 *dp, &lv = *(dp=new (buf) S1317C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1317C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1317C4)");
    check_field_offset(lv, s1317c4f0, ABISELECT(8,4), "S1317C4.s1317c4f0");
    check_field_offset(lv, s1317c4f1, ABISELECT(16,8), "S1317C4.s1317c4f1");
    check_field_offset(lv, s1317c4f2, ABISELECT(24,16), "S1317C4.s1317c4f2");
    check_field_offset(lv, s1317c4f3, ABISELECT(56,32), "S1317C4.s1317c4f3");
    check_field_offset(lv, s1317c4f4, ABISELECT(64,40), "S1317C4.s1317c4f4");
    check_field_offset(lv, s1317c4f5, ABISELECT(72,44), "S1317C4.s1317c4f5");
    check_field_offset(lv, s1317c4f6, ABISELECT(80,52), "S1317C4.s1317c4f6");
    test_class_info(&lv, &cd_S1317C4);
    dp->~S1317C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1317C4(Test_S1317C4, "S1317C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1317C4C1Ev();
extern void _ZN7S1317C4D1Ev();
Name_Map name_map_S1317C4[] = {
  NSPAIR(_ZN7S1317C4C1Ev),
  NSPAIR(_ZN7S1317C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1317C4[];
extern void _ZN7S1317C4D1Ev();
extern void _ZN7S1317C4D0Ev();
extern void _ZN7S1317C43v15Ev();
extern void _ZN7S1317C43v16Ev();
extern void _ZN7S1317C43v17Ev();
extern void _ZN7S1317C43v18Ev();
extern void _ZN7S1317C43v19Ev();
extern void _ZN7S1317C43v20Ev();
extern void _ZN7S1317C43v21Ev();
extern void _ZN7S1317C43v22Ev();
extern void _ZN7S1317C43v23Ev();
extern void _ZN7S1317C43v24Ev();
extern void _ZN7S1317C43v25Ev();
extern void _ZN7S1317C43v26Ev();
extern void _ZN7S1317C43v27Ev();
extern void _ZN7S1317C43v28Ev();
extern void _ZN7S1317C43v29Ev();
extern void _ZN7S1317C43v30Ev();
extern void _ZN7S1317C43v31Ev();
extern void _ZN7S1317C43v32Ev();
extern void _ZN7S1317C43v33Ev();
extern void _ZN7S1317C43v34Ev();
extern void _ZN7S1317C43v35Ev();
extern void _ZN7S1317C43v36Ev();
extern void _ZN7S1317C43v37Ev();
extern void _ZN7S1317C43v38Ev();
extern void _ZN7S1317C43v39Ev();
extern void _ZN7S1317C43v40Ev();
extern void _ZN7S1317C43v41Ev();
extern void _ZN7S1317C43v42Ev();
extern void _ZN7S1317C43v43Ev();
extern void _ZN7S1317C43v44Ev();
extern void _ZN7S1317C43v45Ev();
extern void _ZN7S1317C43v46Ev();
extern void _ZN7S1317C43v47Ev();
extern void _ZN7S1317C43v48Ev();
extern void _ZN7S1317C43v49Ev();
extern void _ZN7S1317C43v50Ev();
extern void _ZN7S1317C43v51Ev();
extern void _ZN7S1317C43v52Ev();
extern void _ZN7S1317C43v53Ev();
extern void _ZN7S1317C43v54Ev();
extern void _ZN7S1317C43v55Ev();
extern void _ZN7S1317C43v56Ev();
extern void _ZN7S1317C43v57Ev();
extern void _ZN7S1317C43v58Ev();
extern void _ZN7S1317C43v59Ev();
extern void _ZN7S1317C43v60Ev();
extern void _ZN7S1317C43v61Ev();
extern void _ZN7S1317C43v62Ev();
extern void _ZN7S1317C43v63Ev();
extern void _ZN7S1317C43v64Ev();
extern void _ZN7S1317C43v65Ev();
extern void _ZN7S1317C43v66Ev();
extern void _ZN7S1317C43v67Ev();
extern void _ZN7S1317C43v68Ev();
extern void _ZN7S1317C43v69Ev();
extern void _ZN7S1317C43v70Ev();
extern void _ZN7S1317C43v71Ev();
extern void _ZN7S1317C43v72Ev();
extern void _ZN7S1317C43v73Ev();
extern void _ZN7S1317C43v74Ev();
extern void _ZN7S1317C43v75Ev();
extern void _ZN7S1317C43v76Ev();
extern void _ZN7S1317C43v77Ev();
extern void _ZN7S1317C43v78Ev();
static  VTBL_ENTRY vtc_S1317C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1317C4[0]),
  (VTBL_ENTRY)&_ZN7S1317C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1317C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v78Ev,
};
extern VTBL_ENTRY _ZTI7S1317C4[];
extern  VTBL_ENTRY _ZTV7S1317C4[];
Class_Descriptor cd_S1317C4 = {  "S1317C4", // class name
  0,0,//no base classes
  &(vtc_S1317C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1317C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1317C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1317C3  : S1317C4 {
  unsigned int s1317c3f0:1;
  unsigned int s1317c3f1:1;
  unsigned int s1317c3f2:1;
  unsigned int s1317c3f3:1;
  unsigned int s1317c3f4:1;
  unsigned int s1317c3f5:1;
  unsigned int s1317c3f6:1;
  ::S3625C32 s1317c3f7;
  virtual  ~S1317C3(); // _ZN7S1317C3D1Ev
  virtual void  v79(); // _ZN7S1317C33v79Ev
  virtual void  v80(); // _ZN7S1317C33v80Ev
  virtual void  v81(); // _ZN7S1317C33v81Ev
  virtual void  v82(); // _ZN7S1317C33v82Ev
  virtual void  v83(); // _ZN7S1317C33v83Ev
  virtual void  v84(); // _ZN7S1317C33v84Ev
  virtual void  v85(); // _ZN7S1317C33v85Ev
  virtual void  v86(); // _ZN7S1317C33v86Ev
  virtual void  v87(); // _ZN7S1317C33v87Ev
  virtual void  v88(); // _ZN7S1317C33v88Ev
  virtual void  v89(); // _ZN7S1317C33v89Ev
  virtual void  v90(); // _ZN7S1317C33v90Ev
  virtual void  v91(); // _ZN7S1317C33v91Ev
  virtual void  v92(); // _ZN7S1317C33v92Ev
  virtual void  v93(); // _ZN7S1317C33v93Ev
  virtual void  v94(); // _ZN7S1317C33v94Ev
  virtual void  v95(); // _ZN7S1317C33v95Ev
  virtual void  v96(); // _ZN7S1317C33v96Ev
  virtual void  v97(); // _ZN7S1317C33v97Ev
  virtual void  v98(); // _ZN7S1317C33v98Ev
  S1317C3(); // tgen
};
//SIG(-1 S1317C3) C1{ BC2{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC4{ m}}


 S1317C3 ::~S1317C3(){ note_dtor("S1317C3", this);}
void  S1317C3 ::v79(){vfunc_called(this, "_ZN7S1317C33v79Ev");}
void  S1317C3 ::v80(){vfunc_called(this, "_ZN7S1317C33v80Ev");}
void  S1317C3 ::v81(){vfunc_called(this, "_ZN7S1317C33v81Ev");}
void  S1317C3 ::v82(){vfunc_called(this, "_ZN7S1317C33v82Ev");}
void  S1317C3 ::v83(){vfunc_called(this, "_ZN7S1317C33v83Ev");}
void  S1317C3 ::v84(){vfunc_called(this, "_ZN7S1317C33v84Ev");}
void  S1317C3 ::v85(){vfunc_called(this, "_ZN7S1317C33v85Ev");}
void  S1317C3 ::v86(){vfunc_called(this, "_ZN7S1317C33v86Ev");}
void  S1317C3 ::v87(){vfunc_called(this, "_ZN7S1317C33v87Ev");}
void  S1317C3 ::v88(){vfunc_called(this, "_ZN7S1317C33v88Ev");}
void  S1317C3 ::v89(){vfunc_called(this, "_ZN7S1317C33v89Ev");}
void  S1317C3 ::v90(){vfunc_called(this, "_ZN7S1317C33v90Ev");}
void  S1317C3 ::v91(){vfunc_called(this, "_ZN7S1317C33v91Ev");}
void  S1317C3 ::v92(){vfunc_called(this, "_ZN7S1317C33v92Ev");}
void  S1317C3 ::v93(){vfunc_called(this, "_ZN7S1317C33v93Ev");}
void  S1317C3 ::v94(){vfunc_called(this, "_ZN7S1317C33v94Ev");}
void  S1317C3 ::v95(){vfunc_called(this, "_ZN7S1317C33v95Ev");}
void  S1317C3 ::v96(){vfunc_called(this, "_ZN7S1317C33v96Ev");}
void  S1317C3 ::v97(){vfunc_called(this, "_ZN7S1317C33v97Ev");}
void  S1317C3 ::v98(){vfunc_called(this, "_ZN7S1317C33v98Ev");}
S1317C3 ::S1317C3(){ note_ctor("S1317C3", this);} // tgen

static void Test_S1317C3()
{
  extern Class_Descriptor cd_S1317C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S1317C3, buf);
    S1317C3 *dp, &lv = *(dp=new (buf) S1317C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S1317C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1317C3)");
    check_base_class_offset(lv, (S1317C4*), 0, "S1317C3");
    set_bf_and_test(lv, s1317c3f0, ABISELECT(96,60), 0, 1, 1, "S1317C3");
    set_bf_and_test(lv, s1317c3f1, ABISELECT(96,60), 1, 1, 1, "S1317C3");
    set_bf_and_test(lv, s1317c3f2, ABISELECT(96,60), 2, 1, 1, "S1317C3");
    set_bf_and_test(lv, s1317c3f3, ABISELECT(96,60), 3, 1, 1, "S1317C3");
    set_bf_and_test(lv, s1317c3f4, ABISELECT(96,60), 4, 1, 1, "S1317C3");
    set_bf_and_test(lv, s1317c3f5, ABISELECT(96,60), 5, 1, 1, "S1317C3");
    set_bf_and_test(lv, s1317c3f6, ABISELECT(96,60), 6, 1, 1, "S1317C3");
    check_field_offset(lv, s1317c3f7, ABISELECT(97,61), "S1317C3.s1317c3f7");
    test_class_info(&lv, &cd_S1317C3);
    dp->~S1317C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1317C3(Test_S1317C3, "S1317C3", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN7S1317C3C1Ev();
extern void _ZN7S1317C3D1Ev();
Name_Map name_map_S1317C3[] = {
  NSPAIR(_ZN7S1317C3C1Ev),
  NSPAIR(_ZN7S1317C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1317C4;
extern VTBL_ENTRY _ZTI7S1317C4[];
extern  VTBL_ENTRY _ZTV7S1317C4[];
static Base_Class bases_S1317C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1317C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1317C3[];
extern void _ZN7S1317C3D1Ev();
extern void _ZN7S1317C3D0Ev();
extern void _ZN7S1317C43v15Ev();
extern void _ZN7S1317C43v16Ev();
extern void _ZN7S1317C43v17Ev();
extern void _ZN7S1317C43v18Ev();
extern void _ZN7S1317C43v19Ev();
extern void _ZN7S1317C43v20Ev();
extern void _ZN7S1317C43v21Ev();
extern void _ZN7S1317C43v22Ev();
extern void _ZN7S1317C43v23Ev();
extern void _ZN7S1317C43v24Ev();
extern void _ZN7S1317C43v25Ev();
extern void _ZN7S1317C43v26Ev();
extern void _ZN7S1317C43v27Ev();
extern void _ZN7S1317C43v28Ev();
extern void _ZN7S1317C43v29Ev();
extern void _ZN7S1317C43v30Ev();
extern void _ZN7S1317C43v31Ev();
extern void _ZN7S1317C43v32Ev();
extern void _ZN7S1317C43v33Ev();
extern void _ZN7S1317C43v34Ev();
extern void _ZN7S1317C43v35Ev();
extern void _ZN7S1317C43v36Ev();
extern void _ZN7S1317C43v37Ev();
extern void _ZN7S1317C43v38Ev();
extern void _ZN7S1317C43v39Ev();
extern void _ZN7S1317C43v40Ev();
extern void _ZN7S1317C43v41Ev();
extern void _ZN7S1317C43v42Ev();
extern void _ZN7S1317C43v43Ev();
extern void _ZN7S1317C43v44Ev();
extern void _ZN7S1317C43v45Ev();
extern void _ZN7S1317C43v46Ev();
extern void _ZN7S1317C43v47Ev();
extern void _ZN7S1317C43v48Ev();
extern void _ZN7S1317C43v49Ev();
extern void _ZN7S1317C43v50Ev();
extern void _ZN7S1317C43v51Ev();
extern void _ZN7S1317C43v52Ev();
extern void _ZN7S1317C43v53Ev();
extern void _ZN7S1317C43v54Ev();
extern void _ZN7S1317C43v55Ev();
extern void _ZN7S1317C43v56Ev();
extern void _ZN7S1317C43v57Ev();
extern void _ZN7S1317C43v58Ev();
extern void _ZN7S1317C43v59Ev();
extern void _ZN7S1317C43v60Ev();
extern void _ZN7S1317C43v61Ev();
extern void _ZN7S1317C43v62Ev();
extern void _ZN7S1317C43v63Ev();
extern void _ZN7S1317C43v64Ev();
extern void _ZN7S1317C43v65Ev();
extern void _ZN7S1317C43v66Ev();
extern void _ZN7S1317C43v67Ev();
extern void _ZN7S1317C43v68Ev();
extern void _ZN7S1317C43v69Ev();
extern void _ZN7S1317C43v70Ev();
extern void _ZN7S1317C43v71Ev();
extern void _ZN7S1317C43v72Ev();
extern void _ZN7S1317C43v73Ev();
extern void _ZN7S1317C43v74Ev();
extern void _ZN7S1317C43v75Ev();
extern void _ZN7S1317C43v76Ev();
extern void _ZN7S1317C43v77Ev();
extern void _ZN7S1317C43v78Ev();
extern void _ZN7S1317C33v79Ev();
extern void _ZN7S1317C33v80Ev();
extern void _ZN7S1317C33v81Ev();
extern void _ZN7S1317C33v82Ev();
extern void _ZN7S1317C33v83Ev();
extern void _ZN7S1317C33v84Ev();
extern void _ZN7S1317C33v85Ev();
extern void _ZN7S1317C33v86Ev();
extern void _ZN7S1317C33v87Ev();
extern void _ZN7S1317C33v88Ev();
extern void _ZN7S1317C33v89Ev();
extern void _ZN7S1317C33v90Ev();
extern void _ZN7S1317C33v91Ev();
extern void _ZN7S1317C33v92Ev();
extern void _ZN7S1317C33v93Ev();
extern void _ZN7S1317C33v94Ev();
extern void _ZN7S1317C33v95Ev();
extern void _ZN7S1317C33v96Ev();
extern void _ZN7S1317C33v97Ev();
extern void _ZN7S1317C33v98Ev();
static  VTBL_ENTRY vtc_S1317C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1317C3[0]),
  (VTBL_ENTRY)&_ZN7S1317C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1317C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v78Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v98Ev,
};
extern VTBL_ENTRY _ZTI7S1317C3[];
extern  VTBL_ENTRY _ZTV7S1317C3[];
Class_Descriptor cd_S1317C3 = {  "S1317C3", // class name
  bases_S1317C3, 1,
  &(vtc_S1317C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI7S1317C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1317C3),88, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1317C2  : S1317C3 {
  virtual  ~S1317C2(); // _ZN7S1317C2D1Ev
  virtual void  v99(); // _ZN7S1317C23v99Ev
  virtual void  v100(); // _ZN7S1317C24v100Ev
  virtual void  v101(); // _ZN7S1317C24v101Ev
  virtual void  v102(); // _ZN7S1317C24v102Ev
  virtual void  v103(); // _ZN7S1317C24v103Ev
  virtual void  v104(); // _ZN7S1317C24v104Ev
  virtual void  v105(); // _ZN7S1317C24v105Ev
  virtual void  v106(); // _ZN7S1317C24v106Ev
  virtual void  v107(); // _ZN7S1317C24v107Ev
  S1317C2(); // tgen
};
//SIG(-1 S1317C2) C1{ BC2{ BC3{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC5{ m}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9}


 S1317C2 ::~S1317C2(){ note_dtor("S1317C2", this);}
void  S1317C2 ::v99(){vfunc_called(this, "_ZN7S1317C23v99Ev");}
void  S1317C2 ::v100(){vfunc_called(this, "_ZN7S1317C24v100Ev");}
void  S1317C2 ::v101(){vfunc_called(this, "_ZN7S1317C24v101Ev");}
void  S1317C2 ::v102(){vfunc_called(this, "_ZN7S1317C24v102Ev");}
void  S1317C2 ::v103(){vfunc_called(this, "_ZN7S1317C24v103Ev");}
void  S1317C2 ::v104(){vfunc_called(this, "_ZN7S1317C24v104Ev");}
void  S1317C2 ::v105(){vfunc_called(this, "_ZN7S1317C24v105Ev");}
void  S1317C2 ::v106(){vfunc_called(this, "_ZN7S1317C24v106Ev");}
void  S1317C2 ::v107(){vfunc_called(this, "_ZN7S1317C24v107Ev");}
S1317C2 ::S1317C2(){ note_ctor("S1317C2", this);} // tgen

static void Test_S1317C2()
{
  extern Class_Descriptor cd_S1317C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S1317C2, buf);
    S1317C2 *dp, &lv = *(dp=new (buf) S1317C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S1317C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1317C2)");
    check_base_class_offset(lv, (S1317C4*)(S1317C3*), 0, "S1317C2");
    check_base_class_offset(lv, (S1317C3*), 0, "S1317C2");
    test_class_info(&lv, &cd_S1317C2);
    dp->~S1317C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1317C2(Test_S1317C2, "S1317C2", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN7S1317C2C1Ev();
extern void _ZN7S1317C2D1Ev();
Name_Map name_map_S1317C2[] = {
  NSPAIR(_ZN7S1317C2C1Ev),
  NSPAIR(_ZN7S1317C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1317C4;
extern VTBL_ENTRY _ZTI7S1317C4[];
extern  VTBL_ENTRY _ZTV7S1317C4[];
extern Class_Descriptor cd_S1317C3;
extern VTBL_ENTRY _ZTI7S1317C3[];
extern  VTBL_ENTRY _ZTV7S1317C3[];
static Base_Class bases_S1317C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1317C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1317C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1317C2[];
extern void _ZN7S1317C2D1Ev();
extern void _ZN7S1317C2D0Ev();
extern void _ZN7S1317C43v15Ev();
extern void _ZN7S1317C43v16Ev();
extern void _ZN7S1317C43v17Ev();
extern void _ZN7S1317C43v18Ev();
extern void _ZN7S1317C43v19Ev();
extern void _ZN7S1317C43v20Ev();
extern void _ZN7S1317C43v21Ev();
extern void _ZN7S1317C43v22Ev();
extern void _ZN7S1317C43v23Ev();
extern void _ZN7S1317C43v24Ev();
extern void _ZN7S1317C43v25Ev();
extern void _ZN7S1317C43v26Ev();
extern void _ZN7S1317C43v27Ev();
extern void _ZN7S1317C43v28Ev();
extern void _ZN7S1317C43v29Ev();
extern void _ZN7S1317C43v30Ev();
extern void _ZN7S1317C43v31Ev();
extern void _ZN7S1317C43v32Ev();
extern void _ZN7S1317C43v33Ev();
extern void _ZN7S1317C43v34Ev();
extern void _ZN7S1317C43v35Ev();
extern void _ZN7S1317C43v36Ev();
extern void _ZN7S1317C43v37Ev();
extern void _ZN7S1317C43v38Ev();
extern void _ZN7S1317C43v39Ev();
extern void _ZN7S1317C43v40Ev();
extern void _ZN7S1317C43v41Ev();
extern void _ZN7S1317C43v42Ev();
extern void _ZN7S1317C43v43Ev();
extern void _ZN7S1317C43v44Ev();
extern void _ZN7S1317C43v45Ev();
extern void _ZN7S1317C43v46Ev();
extern void _ZN7S1317C43v47Ev();
extern void _ZN7S1317C43v48Ev();
extern void _ZN7S1317C43v49Ev();
extern void _ZN7S1317C43v50Ev();
extern void _ZN7S1317C43v51Ev();
extern void _ZN7S1317C43v52Ev();
extern void _ZN7S1317C43v53Ev();
extern void _ZN7S1317C43v54Ev();
extern void _ZN7S1317C43v55Ev();
extern void _ZN7S1317C43v56Ev();
extern void _ZN7S1317C43v57Ev();
extern void _ZN7S1317C43v58Ev();
extern void _ZN7S1317C43v59Ev();
extern void _ZN7S1317C43v60Ev();
extern void _ZN7S1317C43v61Ev();
extern void _ZN7S1317C43v62Ev();
extern void _ZN7S1317C43v63Ev();
extern void _ZN7S1317C43v64Ev();
extern void _ZN7S1317C43v65Ev();
extern void _ZN7S1317C43v66Ev();
extern void _ZN7S1317C43v67Ev();
extern void _ZN7S1317C43v68Ev();
extern void _ZN7S1317C43v69Ev();
extern void _ZN7S1317C43v70Ev();
extern void _ZN7S1317C43v71Ev();
extern void _ZN7S1317C43v72Ev();
extern void _ZN7S1317C43v73Ev();
extern void _ZN7S1317C43v74Ev();
extern void _ZN7S1317C43v75Ev();
extern void _ZN7S1317C43v76Ev();
extern void _ZN7S1317C43v77Ev();
extern void _ZN7S1317C43v78Ev();
extern void _ZN7S1317C33v79Ev();
extern void _ZN7S1317C33v80Ev();
extern void _ZN7S1317C33v81Ev();
extern void _ZN7S1317C33v82Ev();
extern void _ZN7S1317C33v83Ev();
extern void _ZN7S1317C33v84Ev();
extern void _ZN7S1317C33v85Ev();
extern void _ZN7S1317C33v86Ev();
extern void _ZN7S1317C33v87Ev();
extern void _ZN7S1317C33v88Ev();
extern void _ZN7S1317C33v89Ev();
extern void _ZN7S1317C33v90Ev();
extern void _ZN7S1317C33v91Ev();
extern void _ZN7S1317C33v92Ev();
extern void _ZN7S1317C33v93Ev();
extern void _ZN7S1317C33v94Ev();
extern void _ZN7S1317C33v95Ev();
extern void _ZN7S1317C33v96Ev();
extern void _ZN7S1317C33v97Ev();
extern void _ZN7S1317C33v98Ev();
extern void _ZN7S1317C23v99Ev();
extern void _ZN7S1317C24v100Ev();
extern void _ZN7S1317C24v101Ev();
extern void _ZN7S1317C24v102Ev();
extern void _ZN7S1317C24v103Ev();
extern void _ZN7S1317C24v104Ev();
extern void _ZN7S1317C24v105Ev();
extern void _ZN7S1317C24v106Ev();
extern void _ZN7S1317C24v107Ev();
static  VTBL_ENTRY vtc_S1317C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1317C2[0]),
  (VTBL_ENTRY)&_ZN7S1317C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1317C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v78Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1317C23v99Ev,
  (VTBL_ENTRY)&_ZN7S1317C24v100Ev,
  (VTBL_ENTRY)&_ZN7S1317C24v101Ev,
  (VTBL_ENTRY)&_ZN7S1317C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1317C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1317C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1317C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1317C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1317C24v107Ev,
};
extern VTBL_ENTRY _ZTI7S1317C2[];
extern  VTBL_ENTRY _ZTV7S1317C2[];
Class_Descriptor cd_S1317C2 = {  "S1317C2", // class name
  bases_S1317C2, 2,
  &(vtc_S1317C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI7S1317C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1317C2),97, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1317C1  : S1317C2 {
  char s1317c1f0[2];
  int s1317c1f1[6];
  unsigned int s1317c1f2:1;
  unsigned int s1317c1f3:1;
  unsigned int s1317c1f4:1;
  unsigned int s1317c1f5:1;
  unsigned int s1317c1f6:1;
  ::S674C6_nt s1317c1f7;
  ::S1289C10_nt s1317c1f8;
  ::S1289C10_nt s1317c1f9;
  ::S1289C10_nt s1317c1f10;
  virtual  ~S1317C1(); // _ZN7S1317C1D1Ev
  virtual void  v1(); // _ZN7S1317C12v1Ev
  virtual void  v2(); // _ZN7S1317C12v2Ev
  virtual void  v3(); // _ZN7S1317C12v3Ev
  virtual void  v4(); // _ZN7S1317C12v4Ev
  virtual void  v5(); // _ZN7S1317C12v5Ev
  virtual void  v6(); // _ZN7S1317C12v6Ev
  virtual void  v7(); // _ZN7S1317C12v7Ev
  virtual void  v8(); // _ZN7S1317C12v8Ev
  virtual void  v9(); // _ZN7S1317C12v9Ev
  virtual void  v10(); // _ZN7S1317C13v10Ev
  virtual void  v11(); // _ZN7S1317C13v11Ev
  virtual void  v12(); // _ZN7S1317C13v12Ev
  virtual void  v13(); // _ZN7S1317C13v13Ev
  virtual void  v14(); // _ZN7S1317C13v14Ev
  S1317C1(); // tgen
};
//SIG(1 S1317C1) C1{ BC2{ BC3{ BC4{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC6{ m}} vd v99 v100 v101 v102 v103 v104 v105 v106 v107} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fc[2] Fi[6] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC5 FC7{ BC8{ m Fc[4] FC9{ BC10{ BC11{ m Fp Fi[2]}}} Fi[2]} Fp} FC7 FC7}


 S1317C1 ::~S1317C1(){ note_dtor("S1317C1", this);}
void  S1317C1 ::v1(){vfunc_called(this, "_ZN7S1317C12v1Ev");}
void  S1317C1 ::v2(){vfunc_called(this, "_ZN7S1317C12v2Ev");}
void  S1317C1 ::v3(){vfunc_called(this, "_ZN7S1317C12v3Ev");}
void  S1317C1 ::v4(){vfunc_called(this, "_ZN7S1317C12v4Ev");}
void  S1317C1 ::v5(){vfunc_called(this, "_ZN7S1317C12v5Ev");}
void  S1317C1 ::v6(){vfunc_called(this, "_ZN7S1317C12v6Ev");}
void  S1317C1 ::v7(){vfunc_called(this, "_ZN7S1317C12v7Ev");}
void  S1317C1 ::v8(){vfunc_called(this, "_ZN7S1317C12v8Ev");}
void  S1317C1 ::v9(){vfunc_called(this, "_ZN7S1317C12v9Ev");}
void  S1317C1 ::v10(){vfunc_called(this, "_ZN7S1317C13v10Ev");}
void  S1317C1 ::v11(){vfunc_called(this, "_ZN7S1317C13v11Ev");}
void  S1317C1 ::v12(){vfunc_called(this, "_ZN7S1317C13v12Ev");}
void  S1317C1 ::v13(){vfunc_called(this, "_ZN7S1317C13v13Ev");}
void  S1317C1 ::v14(){vfunc_called(this, "_ZN7S1317C13v14Ev");}
S1317C1 ::S1317C1(){ note_ctor("S1317C1", this);} // tgen

static void Test_S1317C1()
{
  extern Class_Descriptor cd_S1317C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(33,47)];
    init_test(&cd_S1317C1, buf);
    S1317C1 *dp, &lv = *(dp=new (buf) S1317C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(256,184), "sizeof(S1317C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1317C1)");
    check_base_class_offset(lv, (S1317C4*)(S1317C3*)(S1317C2*), 0, "S1317C1");
    check_base_class_offset(lv, (S1317C3*)(S1317C2*), 0, "S1317C1");
    check_base_class_offset(lv, (S1317C2*), 0, "S1317C1");
    check_field_offset(lv, s1317c1f0, ABISELECT(98,62), "S1317C1.s1317c1f0");
    check_field_offset(lv, s1317c1f1, ABISELECT(100,64), "S1317C1.s1317c1f1");
    set_bf_and_test(lv, s1317c1f2, ABISELECT(124,88), 0, 1, 1, "S1317C1");
    set_bf_and_test(lv, s1317c1f3, ABISELECT(124,88), 1, 1, 1, "S1317C1");
    set_bf_and_test(lv, s1317c1f4, ABISELECT(124,88), 2, 1, 1, "S1317C1");
    set_bf_and_test(lv, s1317c1f5, ABISELECT(124,88), 3, 1, 1, "S1317C1");
    set_bf_and_test(lv, s1317c1f6, ABISELECT(124,88), 4, 1, 1, "S1317C1");
    check_field_offset(lv, s1317c1f7, ABISELECT(128,92), "S1317C1.s1317c1f7");
    check_field_offset(lv, s1317c1f8, ABISELECT(136,100), "S1317C1.s1317c1f8");
    check_field_offset(lv, s1317c1f9, ABISELECT(176,128), "S1317C1.s1317c1f9");
    check_field_offset(lv, s1317c1f10, ABISELECT(216,156), "S1317C1.s1317c1f10");
    test_class_info(&lv, &cd_S1317C1);
    dp->~S1317C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1317C1(Test_S1317C1, "S1317C1", ABISELECT(256,184));

#else // __cplusplus

extern void _ZN7S1317C1C1Ev();
extern void _ZN7S1317C1D1Ev();
Name_Map name_map_S1317C1[] = {
  NSPAIR(_ZN7S1317C1C1Ev),
  NSPAIR(_ZN7S1317C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1317C4;
extern VTBL_ENTRY _ZTI7S1317C4[];
extern  VTBL_ENTRY _ZTV7S1317C4[];
extern Class_Descriptor cd_S1317C3;
extern VTBL_ENTRY _ZTI7S1317C3[];
extern  VTBL_ENTRY _ZTV7S1317C3[];
extern Class_Descriptor cd_S1317C2;
extern VTBL_ENTRY _ZTI7S1317C2[];
extern  VTBL_ENTRY _ZTV7S1317C2[];
static Base_Class bases_S1317C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1317C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1317C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1317C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1317C1[];
extern void _ZN7S1317C1D1Ev();
extern void _ZN7S1317C1D0Ev();
extern void _ZN7S1317C43v15Ev();
extern void _ZN7S1317C43v16Ev();
extern void _ZN7S1317C43v17Ev();
extern void _ZN7S1317C43v18Ev();
extern void _ZN7S1317C43v19Ev();
extern void _ZN7S1317C43v20Ev();
extern void _ZN7S1317C43v21Ev();
extern void _ZN7S1317C43v22Ev();
extern void _ZN7S1317C43v23Ev();
extern void _ZN7S1317C43v24Ev();
extern void _ZN7S1317C43v25Ev();
extern void _ZN7S1317C43v26Ev();
extern void _ZN7S1317C43v27Ev();
extern void _ZN7S1317C43v28Ev();
extern void _ZN7S1317C43v29Ev();
extern void _ZN7S1317C43v30Ev();
extern void _ZN7S1317C43v31Ev();
extern void _ZN7S1317C43v32Ev();
extern void _ZN7S1317C43v33Ev();
extern void _ZN7S1317C43v34Ev();
extern void _ZN7S1317C43v35Ev();
extern void _ZN7S1317C43v36Ev();
extern void _ZN7S1317C43v37Ev();
extern void _ZN7S1317C43v38Ev();
extern void _ZN7S1317C43v39Ev();
extern void _ZN7S1317C43v40Ev();
extern void _ZN7S1317C43v41Ev();
extern void _ZN7S1317C43v42Ev();
extern void _ZN7S1317C43v43Ev();
extern void _ZN7S1317C43v44Ev();
extern void _ZN7S1317C43v45Ev();
extern void _ZN7S1317C43v46Ev();
extern void _ZN7S1317C43v47Ev();
extern void _ZN7S1317C43v48Ev();
extern void _ZN7S1317C43v49Ev();
extern void _ZN7S1317C43v50Ev();
extern void _ZN7S1317C43v51Ev();
extern void _ZN7S1317C43v52Ev();
extern void _ZN7S1317C43v53Ev();
extern void _ZN7S1317C43v54Ev();
extern void _ZN7S1317C43v55Ev();
extern void _ZN7S1317C43v56Ev();
extern void _ZN7S1317C43v57Ev();
extern void _ZN7S1317C43v58Ev();
extern void _ZN7S1317C43v59Ev();
extern void _ZN7S1317C43v60Ev();
extern void _ZN7S1317C43v61Ev();
extern void _ZN7S1317C43v62Ev();
extern void _ZN7S1317C43v63Ev();
extern void _ZN7S1317C43v64Ev();
extern void _ZN7S1317C43v65Ev();
extern void _ZN7S1317C43v66Ev();
extern void _ZN7S1317C43v67Ev();
extern void _ZN7S1317C43v68Ev();
extern void _ZN7S1317C43v69Ev();
extern void _ZN7S1317C43v70Ev();
extern void _ZN7S1317C43v71Ev();
extern void _ZN7S1317C43v72Ev();
extern void _ZN7S1317C43v73Ev();
extern void _ZN7S1317C43v74Ev();
extern void _ZN7S1317C43v75Ev();
extern void _ZN7S1317C43v76Ev();
extern void _ZN7S1317C43v77Ev();
extern void _ZN7S1317C43v78Ev();
extern void _ZN7S1317C33v79Ev();
extern void _ZN7S1317C33v80Ev();
extern void _ZN7S1317C33v81Ev();
extern void _ZN7S1317C33v82Ev();
extern void _ZN7S1317C33v83Ev();
extern void _ZN7S1317C33v84Ev();
extern void _ZN7S1317C33v85Ev();
extern void _ZN7S1317C33v86Ev();
extern void _ZN7S1317C33v87Ev();
extern void _ZN7S1317C33v88Ev();
extern void _ZN7S1317C33v89Ev();
extern void _ZN7S1317C33v90Ev();
extern void _ZN7S1317C33v91Ev();
extern void _ZN7S1317C33v92Ev();
extern void _ZN7S1317C33v93Ev();
extern void _ZN7S1317C33v94Ev();
extern void _ZN7S1317C33v95Ev();
extern void _ZN7S1317C33v96Ev();
extern void _ZN7S1317C33v97Ev();
extern void _ZN7S1317C33v98Ev();
extern void _ZN7S1317C23v99Ev();
extern void _ZN7S1317C24v100Ev();
extern void _ZN7S1317C24v101Ev();
extern void _ZN7S1317C24v102Ev();
extern void _ZN7S1317C24v103Ev();
extern void _ZN7S1317C24v104Ev();
extern void _ZN7S1317C24v105Ev();
extern void _ZN7S1317C24v106Ev();
extern void _ZN7S1317C24v107Ev();
extern void _ZN7S1317C12v1Ev();
extern void _ZN7S1317C12v2Ev();
extern void _ZN7S1317C12v3Ev();
extern void _ZN7S1317C12v4Ev();
extern void _ZN7S1317C12v5Ev();
extern void _ZN7S1317C12v6Ev();
extern void _ZN7S1317C12v7Ev();
extern void _ZN7S1317C12v8Ev();
extern void _ZN7S1317C12v9Ev();
extern void _ZN7S1317C13v10Ev();
extern void _ZN7S1317C13v11Ev();
extern void _ZN7S1317C13v12Ev();
extern void _ZN7S1317C13v13Ev();
extern void _ZN7S1317C13v14Ev();
static  VTBL_ENTRY vtc_S1317C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1317C1[0]),
  (VTBL_ENTRY)&_ZN7S1317C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1317C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1317C43v78Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1317C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1317C23v99Ev,
  (VTBL_ENTRY)&_ZN7S1317C24v100Ev,
  (VTBL_ENTRY)&_ZN7S1317C24v101Ev,
  (VTBL_ENTRY)&_ZN7S1317C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1317C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1317C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1317C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1317C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1317C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1317C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1317C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1317C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1317C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1317C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1317C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1317C12v7Ev,
  (VTBL_ENTRY)&_ZN7S1317C12v8Ev,
  (VTBL_ENTRY)&_ZN7S1317C12v9Ev,
  (VTBL_ENTRY)&_ZN7S1317C13v10Ev,
  (VTBL_ENTRY)&_ZN7S1317C13v11Ev,
  (VTBL_ENTRY)&_ZN7S1317C13v12Ev,
  (VTBL_ENTRY)&_ZN7S1317C13v13Ev,
  (VTBL_ENTRY)&_ZN7S1317C13v14Ev,
};
extern VTBL_ENTRY _ZTI7S1317C1[];
extern  VTBL_ENTRY _ZTV7S1317C1[];
Class_Descriptor cd_S1317C1 = {  "S1317C1", // class name
  bases_S1317C1, 3,
  &(vtc_S1317C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,184), // object size
  NSPAIRA(_ZTI7S1317C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1317C1),111, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1292C4  {
  int s1292c4f0;
  __tsi64 s1292c4f1;
  void *s1292c4f2[4];
  int s1292c4f3[2];
  void *s1292c4f4;
  ::S674C6_nt s1292c4f5;
  void *s1292c4f6[2];
  virtual  ~S1292C4(); // _ZN7S1292C4D1Ev
  virtual void  v10(); // _ZN7S1292C43v10Ev
  virtual void  v11(); // _ZN7S1292C43v11Ev
  virtual void  v12(); // _ZN7S1292C43v12Ev
  virtual void  v13(); // _ZN7S1292C43v13Ev
  virtual void  v14(); // _ZN7S1292C43v14Ev
  virtual void  v15(); // _ZN7S1292C43v15Ev
  virtual void  v16(); // _ZN7S1292C43v16Ev
  virtual void  v17(); // _ZN7S1292C43v17Ev
  virtual void  v18(); // _ZN7S1292C43v18Ev
  virtual void  v19(); // _ZN7S1292C43v19Ev
  virtual void  v20(); // _ZN7S1292C43v20Ev
  virtual void  v21(); // _ZN7S1292C43v21Ev
  virtual void  v22(); // _ZN7S1292C43v22Ev
  virtual void  v23(); // _ZN7S1292C43v23Ev
  virtual void  v24(); // _ZN7S1292C43v24Ev
  virtual void  v25(); // _ZN7S1292C43v25Ev
  virtual void  v26(); // _ZN7S1292C43v26Ev
  virtual void  v27(); // _ZN7S1292C43v27Ev
  virtual void  v28(); // _ZN7S1292C43v28Ev
  virtual void  v29(); // _ZN7S1292C43v29Ev
  virtual void  v30(); // _ZN7S1292C43v30Ev
  virtual void  v31(); // _ZN7S1292C43v31Ev
  virtual void  v32(); // _ZN7S1292C43v32Ev
  virtual void  v33(); // _ZN7S1292C43v33Ev
  virtual void  v34(); // _ZN7S1292C43v34Ev
  virtual void  v35(); // _ZN7S1292C43v35Ev
  virtual void  v36(); // _ZN7S1292C43v36Ev
  virtual void  v37(); // _ZN7S1292C43v37Ev
  virtual void  v38(); // _ZN7S1292C43v38Ev
  virtual void  v39(); // _ZN7S1292C43v39Ev
  virtual void  v40(); // _ZN7S1292C43v40Ev
  virtual void  v41(); // _ZN7S1292C43v41Ev
  virtual void  v42(); // _ZN7S1292C43v42Ev
  virtual void  v43(); // _ZN7S1292C43v43Ev
  virtual void  v44(); // _ZN7S1292C43v44Ev
  virtual void  v45(); // _ZN7S1292C43v45Ev
  virtual void  v46(); // _ZN7S1292C43v46Ev
  virtual void  v47(); // _ZN7S1292C43v47Ev
  virtual void  v48(); // _ZN7S1292C43v48Ev
  virtual void  v49(); // _ZN7S1292C43v49Ev
  virtual void  v50(); // _ZN7S1292C43v50Ev
  virtual void  v51(); // _ZN7S1292C43v51Ev
  virtual void  v52(); // _ZN7S1292C43v52Ev
  virtual void  v53(); // _ZN7S1292C43v53Ev
  virtual void  v54(); // _ZN7S1292C43v54Ev
  virtual void  v55(); // _ZN7S1292C43v55Ev
  virtual void  v56(); // _ZN7S1292C43v56Ev
  virtual void  v57(); // _ZN7S1292C43v57Ev
  virtual void  v58(); // _ZN7S1292C43v58Ev
  virtual void  v59(); // _ZN7S1292C43v59Ev
  virtual void  v60(); // _ZN7S1292C43v60Ev
  virtual void  v61(); // _ZN7S1292C43v61Ev
  virtual void  v62(); // _ZN7S1292C43v62Ev
  virtual void  v63(); // _ZN7S1292C43v63Ev
  virtual void  v64(); // _ZN7S1292C43v64Ev
  virtual void  v65(); // _ZN7S1292C43v65Ev
  virtual void  v66(); // _ZN7S1292C43v66Ev
  virtual void  v67(); // _ZN7S1292C43v67Ev
  virtual void  v68(); // _ZN7S1292C43v68Ev
  virtual void  v69(); // _ZN7S1292C43v69Ev
  virtual void  v70(); // _ZN7S1292C43v70Ev
  virtual void  v71(); // _ZN7S1292C43v71Ev
  virtual void  v72(); // _ZN7S1292C43v72Ev
  virtual void  v73(); // _ZN7S1292C43v73Ev
  S1292C4(); // tgen
};
//SIG(-1 S1292C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1292C4 ::~S1292C4(){ note_dtor("S1292C4", this);}
void  S1292C4 ::v10(){vfunc_called(this, "_ZN7S1292C43v10Ev");}
void  S1292C4 ::v11(){vfunc_called(this, "_ZN7S1292C43v11Ev");}
void  S1292C4 ::v12(){vfunc_called(this, "_ZN7S1292C43v12Ev");}
void  S1292C4 ::v13(){vfunc_called(this, "_ZN7S1292C43v13Ev");}
void  S1292C4 ::v14(){vfunc_called(this, "_ZN7S1292C43v14Ev");}
void  S1292C4 ::v15(){vfunc_called(this, "_ZN7S1292C43v15Ev");}
void  S1292C4 ::v16(){vfunc_called(this, "_ZN7S1292C43v16Ev");}
void  S1292C4 ::v17(){vfunc_called(this, "_ZN7S1292C43v17Ev");}
void  S1292C4 ::v18(){vfunc_called(this, "_ZN7S1292C43v18Ev");}
void  S1292C4 ::v19(){vfunc_called(this, "_ZN7S1292C43v19Ev");}
void  S1292C4 ::v20(){vfunc_called(this, "_ZN7S1292C43v20Ev");}
void  S1292C4 ::v21(){vfunc_called(this, "_ZN7S1292C43v21Ev");}
void  S1292C4 ::v22(){vfunc_called(this, "_ZN7S1292C43v22Ev");}
void  S1292C4 ::v23(){vfunc_called(this, "_ZN7S1292C43v23Ev");}
void  S1292C4 ::v24(){vfunc_called(this, "_ZN7S1292C43v24Ev");}
void  S1292C4 ::v25(){vfunc_called(this, "_ZN7S1292C43v25Ev");}
void  S1292C4 ::v26(){vfunc_called(this, "_ZN7S1292C43v26Ev");}
void  S1292C4 ::v27(){vfunc_called(this, "_ZN7S1292C43v27Ev");}
void  S1292C4 ::v28(){vfunc_called(this, "_ZN7S1292C43v28Ev");}
void  S1292C4 ::v29(){vfunc_called(this, "_ZN7S1292C43v29Ev");}
void  S1292C4 ::v30(){vfunc_called(this, "_ZN7S1292C43v30Ev");}
void  S1292C4 ::v31(){vfunc_called(this, "_ZN7S1292C43v31Ev");}
void  S1292C4 ::v32(){vfunc_called(this, "_ZN7S1292C43v32Ev");}
void  S1292C4 ::v33(){vfunc_called(this, "_ZN7S1292C43v33Ev");}
void  S1292C4 ::v34(){vfunc_called(this, "_ZN7S1292C43v34Ev");}
void  S1292C4 ::v35(){vfunc_called(this, "_ZN7S1292C43v35Ev");}
void  S1292C4 ::v36(){vfunc_called(this, "_ZN7S1292C43v36Ev");}
void  S1292C4 ::v37(){vfunc_called(this, "_ZN7S1292C43v37Ev");}
void  S1292C4 ::v38(){vfunc_called(this, "_ZN7S1292C43v38Ev");}
void  S1292C4 ::v39(){vfunc_called(this, "_ZN7S1292C43v39Ev");}
void  S1292C4 ::v40(){vfunc_called(this, "_ZN7S1292C43v40Ev");}
void  S1292C4 ::v41(){vfunc_called(this, "_ZN7S1292C43v41Ev");}
void  S1292C4 ::v42(){vfunc_called(this, "_ZN7S1292C43v42Ev");}
void  S1292C4 ::v43(){vfunc_called(this, "_ZN7S1292C43v43Ev");}
void  S1292C4 ::v44(){vfunc_called(this, "_ZN7S1292C43v44Ev");}
void  S1292C4 ::v45(){vfunc_called(this, "_ZN7S1292C43v45Ev");}
void  S1292C4 ::v46(){vfunc_called(this, "_ZN7S1292C43v46Ev");}
void  S1292C4 ::v47(){vfunc_called(this, "_ZN7S1292C43v47Ev");}
void  S1292C4 ::v48(){vfunc_called(this, "_ZN7S1292C43v48Ev");}
void  S1292C4 ::v49(){vfunc_called(this, "_ZN7S1292C43v49Ev");}
void  S1292C4 ::v50(){vfunc_called(this, "_ZN7S1292C43v50Ev");}
void  S1292C4 ::v51(){vfunc_called(this, "_ZN7S1292C43v51Ev");}
void  S1292C4 ::v52(){vfunc_called(this, "_ZN7S1292C43v52Ev");}
void  S1292C4 ::v53(){vfunc_called(this, "_ZN7S1292C43v53Ev");}
void  S1292C4 ::v54(){vfunc_called(this, "_ZN7S1292C43v54Ev");}
void  S1292C4 ::v55(){vfunc_called(this, "_ZN7S1292C43v55Ev");}
void  S1292C4 ::v56(){vfunc_called(this, "_ZN7S1292C43v56Ev");}
void  S1292C4 ::v57(){vfunc_called(this, "_ZN7S1292C43v57Ev");}
void  S1292C4 ::v58(){vfunc_called(this, "_ZN7S1292C43v58Ev");}
void  S1292C4 ::v59(){vfunc_called(this, "_ZN7S1292C43v59Ev");}
void  S1292C4 ::v60(){vfunc_called(this, "_ZN7S1292C43v60Ev");}
void  S1292C4 ::v61(){vfunc_called(this, "_ZN7S1292C43v61Ev");}
void  S1292C4 ::v62(){vfunc_called(this, "_ZN7S1292C43v62Ev");}
void  S1292C4 ::v63(){vfunc_called(this, "_ZN7S1292C43v63Ev");}
void  S1292C4 ::v64(){vfunc_called(this, "_ZN7S1292C43v64Ev");}
void  S1292C4 ::v65(){vfunc_called(this, "_ZN7S1292C43v65Ev");}
void  S1292C4 ::v66(){vfunc_called(this, "_ZN7S1292C43v66Ev");}
void  S1292C4 ::v67(){vfunc_called(this, "_ZN7S1292C43v67Ev");}
void  S1292C4 ::v68(){vfunc_called(this, "_ZN7S1292C43v68Ev");}
void  S1292C4 ::v69(){vfunc_called(this, "_ZN7S1292C43v69Ev");}
void  S1292C4 ::v70(){vfunc_called(this, "_ZN7S1292C43v70Ev");}
void  S1292C4 ::v71(){vfunc_called(this, "_ZN7S1292C43v71Ev");}
void  S1292C4 ::v72(){vfunc_called(this, "_ZN7S1292C43v72Ev");}
void  S1292C4 ::v73(){vfunc_called(this, "_ZN7S1292C43v73Ev");}
S1292C4 ::S1292C4(){ note_ctor("S1292C4", this);} // tgen

static void Test_S1292C4()
{
  extern Class_Descriptor cd_S1292C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1292C4, buf);
    S1292C4 *dp, &lv = *(dp=new (buf) S1292C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1292C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1292C4)");
    check_field_offset(lv, s1292c4f0, ABISELECT(8,4), "S1292C4.s1292c4f0");
    check_field_offset(lv, s1292c4f1, ABISELECT(16,8), "S1292C4.s1292c4f1");
    check_field_offset(lv, s1292c4f2, ABISELECT(24,16), "S1292C4.s1292c4f2");
    check_field_offset(lv, s1292c4f3, ABISELECT(56,32), "S1292C4.s1292c4f3");
    check_field_offset(lv, s1292c4f4, ABISELECT(64,40), "S1292C4.s1292c4f4");
    check_field_offset(lv, s1292c4f5, ABISELECT(72,44), "S1292C4.s1292c4f5");
    check_field_offset(lv, s1292c4f6, ABISELECT(80,52), "S1292C4.s1292c4f6");
    test_class_info(&lv, &cd_S1292C4);
    dp->~S1292C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1292C4(Test_S1292C4, "S1292C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1292C4C1Ev();
extern void _ZN7S1292C4D1Ev();
Name_Map name_map_S1292C4[] = {
  NSPAIR(_ZN7S1292C4C1Ev),
  NSPAIR(_ZN7S1292C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1292C4[];
extern void _ZN7S1292C4D1Ev();
extern void _ZN7S1292C4D0Ev();
extern void _ZN7S1292C43v10Ev();
extern void _ZN7S1292C43v11Ev();
extern void _ZN7S1292C43v12Ev();
extern void _ZN7S1292C43v13Ev();
extern void _ZN7S1292C43v14Ev();
extern void _ZN7S1292C43v15Ev();
extern void _ZN7S1292C43v16Ev();
extern void _ZN7S1292C43v17Ev();
extern void _ZN7S1292C43v18Ev();
extern void _ZN7S1292C43v19Ev();
extern void _ZN7S1292C43v20Ev();
extern void _ZN7S1292C43v21Ev();
extern void _ZN7S1292C43v22Ev();
extern void _ZN7S1292C43v23Ev();
extern void _ZN7S1292C43v24Ev();
extern void _ZN7S1292C43v25Ev();
extern void _ZN7S1292C43v26Ev();
extern void _ZN7S1292C43v27Ev();
extern void _ZN7S1292C43v28Ev();
extern void _ZN7S1292C43v29Ev();
extern void _ZN7S1292C43v30Ev();
extern void _ZN7S1292C43v31Ev();
extern void _ZN7S1292C43v32Ev();
extern void _ZN7S1292C43v33Ev();
extern void _ZN7S1292C43v34Ev();
extern void _ZN7S1292C43v35Ev();
extern void _ZN7S1292C43v36Ev();
extern void _ZN7S1292C43v37Ev();
extern void _ZN7S1292C43v38Ev();
extern void _ZN7S1292C43v39Ev();
extern void _ZN7S1292C43v40Ev();
extern void _ZN7S1292C43v41Ev();
extern void _ZN7S1292C43v42Ev();
extern void _ZN7S1292C43v43Ev();
extern void _ZN7S1292C43v44Ev();
extern void _ZN7S1292C43v45Ev();
extern void _ZN7S1292C43v46Ev();
extern void _ZN7S1292C43v47Ev();
extern void _ZN7S1292C43v48Ev();
extern void _ZN7S1292C43v49Ev();
extern void _ZN7S1292C43v50Ev();
extern void _ZN7S1292C43v51Ev();
extern void _ZN7S1292C43v52Ev();
extern void _ZN7S1292C43v53Ev();
extern void _ZN7S1292C43v54Ev();
extern void _ZN7S1292C43v55Ev();
extern void _ZN7S1292C43v56Ev();
extern void _ZN7S1292C43v57Ev();
extern void _ZN7S1292C43v58Ev();
extern void _ZN7S1292C43v59Ev();
extern void _ZN7S1292C43v60Ev();
extern void _ZN7S1292C43v61Ev();
extern void _ZN7S1292C43v62Ev();
extern void _ZN7S1292C43v63Ev();
extern void _ZN7S1292C43v64Ev();
extern void _ZN7S1292C43v65Ev();
extern void _ZN7S1292C43v66Ev();
extern void _ZN7S1292C43v67Ev();
extern void _ZN7S1292C43v68Ev();
extern void _ZN7S1292C43v69Ev();
extern void _ZN7S1292C43v70Ev();
extern void _ZN7S1292C43v71Ev();
extern void _ZN7S1292C43v72Ev();
extern void _ZN7S1292C43v73Ev();
static  VTBL_ENTRY vtc_S1292C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1292C4[0]),
  (VTBL_ENTRY)&_ZN7S1292C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1292C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v73Ev,
};
extern VTBL_ENTRY _ZTI7S1292C4[];
extern  VTBL_ENTRY _ZTV7S1292C4[];
Class_Descriptor cd_S1292C4 = {  "S1292C4", // class name
  0,0,//no base classes
  &(vtc_S1292C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1292C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1292C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1292C3  : S1292C4 {
  unsigned int s1292c3f0:1;
  unsigned int s1292c3f1:1;
  unsigned int s1292c3f2:1;
  unsigned int s1292c3f3:1;
  unsigned int s1292c3f4:1;
  unsigned int s1292c3f5:1;
  unsigned int s1292c3f6:1;
  ::S3625C32 s1292c3f7;
  virtual  ~S1292C3(); // _ZN7S1292C3D1Ev
  virtual void  v74(); // _ZN7S1292C33v74Ev
  virtual void  v75(); // _ZN7S1292C33v75Ev
  virtual void  v76(); // _ZN7S1292C33v76Ev
  virtual void  v77(); // _ZN7S1292C33v77Ev
  virtual void  v78(); // _ZN7S1292C33v78Ev
  virtual void  v79(); // _ZN7S1292C33v79Ev
  virtual void  v80(); // _ZN7S1292C33v80Ev
  virtual void  v81(); // _ZN7S1292C33v81Ev
  virtual void  v82(); // _ZN7S1292C33v82Ev
  virtual void  v83(); // _ZN7S1292C33v83Ev
  virtual void  v84(); // _ZN7S1292C33v84Ev
  virtual void  v85(); // _ZN7S1292C33v85Ev
  virtual void  v86(); // _ZN7S1292C33v86Ev
  virtual void  v87(); // _ZN7S1292C33v87Ev
  virtual void  v88(); // _ZN7S1292C33v88Ev
  virtual void  v89(); // _ZN7S1292C33v89Ev
  virtual void  v90(); // _ZN7S1292C33v90Ev
  virtual void  v91(); // _ZN7S1292C33v91Ev
  virtual void  v92(); // _ZN7S1292C33v92Ev
  virtual void  v93(); // _ZN7S1292C33v93Ev
  S1292C3(); // tgen
};
//SIG(-1 S1292C3) C1{ BC2{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC4{ m}}


 S1292C3 ::~S1292C3(){ note_dtor("S1292C3", this);}
void  S1292C3 ::v74(){vfunc_called(this, "_ZN7S1292C33v74Ev");}
void  S1292C3 ::v75(){vfunc_called(this, "_ZN7S1292C33v75Ev");}
void  S1292C3 ::v76(){vfunc_called(this, "_ZN7S1292C33v76Ev");}
void  S1292C3 ::v77(){vfunc_called(this, "_ZN7S1292C33v77Ev");}
void  S1292C3 ::v78(){vfunc_called(this, "_ZN7S1292C33v78Ev");}
void  S1292C3 ::v79(){vfunc_called(this, "_ZN7S1292C33v79Ev");}
void  S1292C3 ::v80(){vfunc_called(this, "_ZN7S1292C33v80Ev");}
void  S1292C3 ::v81(){vfunc_called(this, "_ZN7S1292C33v81Ev");}
void  S1292C3 ::v82(){vfunc_called(this, "_ZN7S1292C33v82Ev");}
void  S1292C3 ::v83(){vfunc_called(this, "_ZN7S1292C33v83Ev");}
void  S1292C3 ::v84(){vfunc_called(this, "_ZN7S1292C33v84Ev");}
void  S1292C3 ::v85(){vfunc_called(this, "_ZN7S1292C33v85Ev");}
void  S1292C3 ::v86(){vfunc_called(this, "_ZN7S1292C33v86Ev");}
void  S1292C3 ::v87(){vfunc_called(this, "_ZN7S1292C33v87Ev");}
void  S1292C3 ::v88(){vfunc_called(this, "_ZN7S1292C33v88Ev");}
void  S1292C3 ::v89(){vfunc_called(this, "_ZN7S1292C33v89Ev");}
void  S1292C3 ::v90(){vfunc_called(this, "_ZN7S1292C33v90Ev");}
void  S1292C3 ::v91(){vfunc_called(this, "_ZN7S1292C33v91Ev");}
void  S1292C3 ::v92(){vfunc_called(this, "_ZN7S1292C33v92Ev");}
void  S1292C3 ::v93(){vfunc_called(this, "_ZN7S1292C33v93Ev");}
S1292C3 ::S1292C3(){ note_ctor("S1292C3", this);} // tgen

static void Test_S1292C3()
{
  extern Class_Descriptor cd_S1292C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S1292C3, buf);
    S1292C3 *dp, &lv = *(dp=new (buf) S1292C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S1292C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1292C3)");
    check_base_class_offset(lv, (S1292C4*), 0, "S1292C3");
    set_bf_and_test(lv, s1292c3f0, ABISELECT(96,60), 0, 1, 1, "S1292C3");
    set_bf_and_test(lv, s1292c3f1, ABISELECT(96,60), 1, 1, 1, "S1292C3");
    set_bf_and_test(lv, s1292c3f2, ABISELECT(96,60), 2, 1, 1, "S1292C3");
    set_bf_and_test(lv, s1292c3f3, ABISELECT(96,60), 3, 1, 1, "S1292C3");
    set_bf_and_test(lv, s1292c3f4, ABISELECT(96,60), 4, 1, 1, "S1292C3");
    set_bf_and_test(lv, s1292c3f5, ABISELECT(96,60), 5, 1, 1, "S1292C3");
    set_bf_and_test(lv, s1292c3f6, ABISELECT(96,60), 6, 1, 1, "S1292C3");
    check_field_offset(lv, s1292c3f7, ABISELECT(97,61), "S1292C3.s1292c3f7");
    test_class_info(&lv, &cd_S1292C3);
    dp->~S1292C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1292C3(Test_S1292C3, "S1292C3", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN7S1292C3C1Ev();
extern void _ZN7S1292C3D1Ev();
Name_Map name_map_S1292C3[] = {
  NSPAIR(_ZN7S1292C3C1Ev),
  NSPAIR(_ZN7S1292C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1292C4;
extern VTBL_ENTRY _ZTI7S1292C4[];
extern  VTBL_ENTRY _ZTV7S1292C4[];
static Base_Class bases_S1292C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1292C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1292C3[];
extern void _ZN7S1292C3D1Ev();
extern void _ZN7S1292C3D0Ev();
extern void _ZN7S1292C43v10Ev();
extern void _ZN7S1292C43v11Ev();
extern void _ZN7S1292C43v12Ev();
extern void _ZN7S1292C43v13Ev();
extern void _ZN7S1292C43v14Ev();
extern void _ZN7S1292C43v15Ev();
extern void _ZN7S1292C43v16Ev();
extern void _ZN7S1292C43v17Ev();
extern void _ZN7S1292C43v18Ev();
extern void _ZN7S1292C43v19Ev();
extern void _ZN7S1292C43v20Ev();
extern void _ZN7S1292C43v21Ev();
extern void _ZN7S1292C43v22Ev();
extern void _ZN7S1292C43v23Ev();
extern void _ZN7S1292C43v24Ev();
extern void _ZN7S1292C43v25Ev();
extern void _ZN7S1292C43v26Ev();
extern void _ZN7S1292C43v27Ev();
extern void _ZN7S1292C43v28Ev();
extern void _ZN7S1292C43v29Ev();
extern void _ZN7S1292C43v30Ev();
extern void _ZN7S1292C43v31Ev();
extern void _ZN7S1292C43v32Ev();
extern void _ZN7S1292C43v33Ev();
extern void _ZN7S1292C43v34Ev();
extern void _ZN7S1292C43v35Ev();
extern void _ZN7S1292C43v36Ev();
extern void _ZN7S1292C43v37Ev();
extern void _ZN7S1292C43v38Ev();
extern void _ZN7S1292C43v39Ev();
extern void _ZN7S1292C43v40Ev();
extern void _ZN7S1292C43v41Ev();
extern void _ZN7S1292C43v42Ev();
extern void _ZN7S1292C43v43Ev();
extern void _ZN7S1292C43v44Ev();
extern void _ZN7S1292C43v45Ev();
extern void _ZN7S1292C43v46Ev();
extern void _ZN7S1292C43v47Ev();
extern void _ZN7S1292C43v48Ev();
extern void _ZN7S1292C43v49Ev();
extern void _ZN7S1292C43v50Ev();
extern void _ZN7S1292C43v51Ev();
extern void _ZN7S1292C43v52Ev();
extern void _ZN7S1292C43v53Ev();
extern void _ZN7S1292C43v54Ev();
extern void _ZN7S1292C43v55Ev();
extern void _ZN7S1292C43v56Ev();
extern void _ZN7S1292C43v57Ev();
extern void _ZN7S1292C43v58Ev();
extern void _ZN7S1292C43v59Ev();
extern void _ZN7S1292C43v60Ev();
extern void _ZN7S1292C43v61Ev();
extern void _ZN7S1292C43v62Ev();
extern void _ZN7S1292C43v63Ev();
extern void _ZN7S1292C43v64Ev();
extern void _ZN7S1292C43v65Ev();
extern void _ZN7S1292C43v66Ev();
extern void _ZN7S1292C43v67Ev();
extern void _ZN7S1292C43v68Ev();
extern void _ZN7S1292C43v69Ev();
extern void _ZN7S1292C43v70Ev();
extern void _ZN7S1292C43v71Ev();
extern void _ZN7S1292C43v72Ev();
extern void _ZN7S1292C43v73Ev();
extern void _ZN7S1292C33v74Ev();
extern void _ZN7S1292C33v75Ev();
extern void _ZN7S1292C33v76Ev();
extern void _ZN7S1292C33v77Ev();
extern void _ZN7S1292C33v78Ev();
extern void _ZN7S1292C33v79Ev();
extern void _ZN7S1292C33v80Ev();
extern void _ZN7S1292C33v81Ev();
extern void _ZN7S1292C33v82Ev();
extern void _ZN7S1292C33v83Ev();
extern void _ZN7S1292C33v84Ev();
extern void _ZN7S1292C33v85Ev();
extern void _ZN7S1292C33v86Ev();
extern void _ZN7S1292C33v87Ev();
extern void _ZN7S1292C33v88Ev();
extern void _ZN7S1292C33v89Ev();
extern void _ZN7S1292C33v90Ev();
extern void _ZN7S1292C33v91Ev();
extern void _ZN7S1292C33v92Ev();
extern void _ZN7S1292C33v93Ev();
static  VTBL_ENTRY vtc_S1292C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1292C3[0]),
  (VTBL_ENTRY)&_ZN7S1292C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1292C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v93Ev,
};
extern VTBL_ENTRY _ZTI7S1292C3[];
extern  VTBL_ENTRY _ZTV7S1292C3[];
Class_Descriptor cd_S1292C3 = {  "S1292C3", // class name
  bases_S1292C3, 1,
  &(vtc_S1292C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI7S1292C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1292C3),88, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1292C2  : S1292C3 {
  virtual  ~S1292C2(); // _ZN7S1292C2D1Ev
  virtual void  v94(); // _ZN7S1292C23v94Ev
  virtual void  v95(); // _ZN7S1292C23v95Ev
  virtual void  v96(); // _ZN7S1292C23v96Ev
  S1292C2(); // tgen
};
//SIG(-1 S1292C2) C1{ BC2{ BC3{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC5{ m}} vd v1 v2 v3}


 S1292C2 ::~S1292C2(){ note_dtor("S1292C2", this);}
void  S1292C2 ::v94(){vfunc_called(this, "_ZN7S1292C23v94Ev");}
void  S1292C2 ::v95(){vfunc_called(this, "_ZN7S1292C23v95Ev");}
void  S1292C2 ::v96(){vfunc_called(this, "_ZN7S1292C23v96Ev");}
S1292C2 ::S1292C2(){ note_ctor("S1292C2", this);} // tgen

static void Test_S1292C2()
{
  extern Class_Descriptor cd_S1292C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S1292C2, buf);
    S1292C2 *dp, &lv = *(dp=new (buf) S1292C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S1292C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1292C2)");
    check_base_class_offset(lv, (S1292C4*)(S1292C3*), 0, "S1292C2");
    check_base_class_offset(lv, (S1292C3*), 0, "S1292C2");
    test_class_info(&lv, &cd_S1292C2);
    dp->~S1292C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1292C2(Test_S1292C2, "S1292C2", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN7S1292C2C1Ev();
extern void _ZN7S1292C2D1Ev();
Name_Map name_map_S1292C2[] = {
  NSPAIR(_ZN7S1292C2C1Ev),
  NSPAIR(_ZN7S1292C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1292C4;
extern VTBL_ENTRY _ZTI7S1292C4[];
extern  VTBL_ENTRY _ZTV7S1292C4[];
extern Class_Descriptor cd_S1292C3;
extern VTBL_ENTRY _ZTI7S1292C3[];
extern  VTBL_ENTRY _ZTV7S1292C3[];
static Base_Class bases_S1292C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1292C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1292C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1292C2[];
extern void _ZN7S1292C2D1Ev();
extern void _ZN7S1292C2D0Ev();
extern void _ZN7S1292C43v10Ev();
extern void _ZN7S1292C43v11Ev();
extern void _ZN7S1292C43v12Ev();
extern void _ZN7S1292C43v13Ev();
extern void _ZN7S1292C43v14Ev();
extern void _ZN7S1292C43v15Ev();
extern void _ZN7S1292C43v16Ev();
extern void _ZN7S1292C43v17Ev();
extern void _ZN7S1292C43v18Ev();
extern void _ZN7S1292C43v19Ev();
extern void _ZN7S1292C43v20Ev();
extern void _ZN7S1292C43v21Ev();
extern void _ZN7S1292C43v22Ev();
extern void _ZN7S1292C43v23Ev();
extern void _ZN7S1292C43v24Ev();
extern void _ZN7S1292C43v25Ev();
extern void _ZN7S1292C43v26Ev();
extern void _ZN7S1292C43v27Ev();
extern void _ZN7S1292C43v28Ev();
extern void _ZN7S1292C43v29Ev();
extern void _ZN7S1292C43v30Ev();
extern void _ZN7S1292C43v31Ev();
extern void _ZN7S1292C43v32Ev();
extern void _ZN7S1292C43v33Ev();
extern void _ZN7S1292C43v34Ev();
extern void _ZN7S1292C43v35Ev();
extern void _ZN7S1292C43v36Ev();
extern void _ZN7S1292C43v37Ev();
extern void _ZN7S1292C43v38Ev();
extern void _ZN7S1292C43v39Ev();
extern void _ZN7S1292C43v40Ev();
extern void _ZN7S1292C43v41Ev();
extern void _ZN7S1292C43v42Ev();
extern void _ZN7S1292C43v43Ev();
extern void _ZN7S1292C43v44Ev();
extern void _ZN7S1292C43v45Ev();
extern void _ZN7S1292C43v46Ev();
extern void _ZN7S1292C43v47Ev();
extern void _ZN7S1292C43v48Ev();
extern void _ZN7S1292C43v49Ev();
extern void _ZN7S1292C43v50Ev();
extern void _ZN7S1292C43v51Ev();
extern void _ZN7S1292C43v52Ev();
extern void _ZN7S1292C43v53Ev();
extern void _ZN7S1292C43v54Ev();
extern void _ZN7S1292C43v55Ev();
extern void _ZN7S1292C43v56Ev();
extern void _ZN7S1292C43v57Ev();
extern void _ZN7S1292C43v58Ev();
extern void _ZN7S1292C43v59Ev();
extern void _ZN7S1292C43v60Ev();
extern void _ZN7S1292C43v61Ev();
extern void _ZN7S1292C43v62Ev();
extern void _ZN7S1292C43v63Ev();
extern void _ZN7S1292C43v64Ev();
extern void _ZN7S1292C43v65Ev();
extern void _ZN7S1292C43v66Ev();
extern void _ZN7S1292C43v67Ev();
extern void _ZN7S1292C43v68Ev();
extern void _ZN7S1292C43v69Ev();
extern void _ZN7S1292C43v70Ev();
extern void _ZN7S1292C43v71Ev();
extern void _ZN7S1292C43v72Ev();
extern void _ZN7S1292C43v73Ev();
extern void _ZN7S1292C33v74Ev();
extern void _ZN7S1292C33v75Ev();
extern void _ZN7S1292C33v76Ev();
extern void _ZN7S1292C33v77Ev();
extern void _ZN7S1292C33v78Ev();
extern void _ZN7S1292C33v79Ev();
extern void _ZN7S1292C33v80Ev();
extern void _ZN7S1292C33v81Ev();
extern void _ZN7S1292C33v82Ev();
extern void _ZN7S1292C33v83Ev();
extern void _ZN7S1292C33v84Ev();
extern void _ZN7S1292C33v85Ev();
extern void _ZN7S1292C33v86Ev();
extern void _ZN7S1292C33v87Ev();
extern void _ZN7S1292C33v88Ev();
extern void _ZN7S1292C33v89Ev();
extern void _ZN7S1292C33v90Ev();
extern void _ZN7S1292C33v91Ev();
extern void _ZN7S1292C33v92Ev();
extern void _ZN7S1292C33v93Ev();
extern void _ZN7S1292C23v94Ev();
extern void _ZN7S1292C23v95Ev();
extern void _ZN7S1292C23v96Ev();
static  VTBL_ENTRY vtc_S1292C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1292C2[0]),
  (VTBL_ENTRY)&_ZN7S1292C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1292C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1292C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1292C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1292C23v96Ev,
};
extern VTBL_ENTRY _ZTI7S1292C2[];
extern  VTBL_ENTRY _ZTV7S1292C2[];
Class_Descriptor cd_S1292C2 = {  "S1292C2", // class name
  bases_S1292C2, 2,
  &(vtc_S1292C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI7S1292C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1292C2),91, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1292C12  : S1289C11_nt {
  void *s1292c12f0;
};
//SIG(-1 S1292C12) C1{ BC2{ m Fc[4] FC3{ BC4{ BC5{ m Fp Fi[2]}}} Fi[2]} Fp}



static void Test_S1292C12()
{
  extern Class_Descriptor cd_S1292C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_S1292C12, buf);
    S1292C12 &lv = *(new (buf) S1292C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S1292C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1292C12)");
    check_base_class_offset(lv, (S1289C11_nt*), 0, "S1292C12");
    check_field_offset(lv, s1292c12f0, ABISELECT(32,24), "S1292C12.s1292c12f0");
    test_class_info(&lv, &cd_S1292C12);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1292C12(Test_S1292C12, "S1292C12", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd_S1289C11_nt;
static Base_Class bases_S1292C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1289C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1292C12 = {  "S1292C12", // class name
  bases_S1292C12, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1292C1  : S1292C2 {
  unsigned int s1292c1f0:1;
  unsigned int s1292c1f1:1;
  unsigned int s1292c1f2:1;
  unsigned int s1292c1f3:1;
  unsigned int s1292c1f4:1;
  unsigned int s1292c1f5:1;
  unsigned int s1292c1f6:1;
  unsigned int s1292c1f7:1;
  int s1292c1f8[2];
  ::S1289C10_nt s1292c1f9;
  ::S1292C12 s1292c1f10;
  ::S1289C10_nt s1292c1f11;
  int s1292c1f12[3];
  ::S1292C12 s1292c1f13;
  int s1292c1f14[2];
  ::S1292C12 s1292c1f15;
  virtual  ~S1292C1(); // _ZN7S1292C1D1Ev
  virtual void  v1(); // _ZN7S1292C12v1Ev
  virtual void  v2(); // _ZN7S1292C12v2Ev
  virtual void  v3(); // _ZN7S1292C12v3Ev
  virtual void  v4(); // _ZN7S1292C12v4Ev
  virtual void  v5(); // _ZN7S1292C12v5Ev
  virtual void  v6(); // _ZN7S1292C12v6Ev
  virtual void  v7(); // _ZN7S1292C12v7Ev
  virtual void  v8(); // _ZN7S1292C12v8Ev
  virtual void  v9(); // _ZN7S1292C12v9Ev
  S1292C1(); // tgen
};
//SIG(1 S1292C1) C1{ BC2{ BC3{ BC4{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC6{ m}} vd v94 v95 v96} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2] FC7{ BC8{ m Fc[4] FC9{ BC10{ BC11{ m Fp Fi[2]}}} Fi[2]} Fp} FC12{ BC8 Fp} FC7 Fi[3] FC12 Fi[2] FC12}


 S1292C1 ::~S1292C1(){ note_dtor("S1292C1", this);}
void  S1292C1 ::v1(){vfunc_called(this, "_ZN7S1292C12v1Ev");}
void  S1292C1 ::v2(){vfunc_called(this, "_ZN7S1292C12v2Ev");}
void  S1292C1 ::v3(){vfunc_called(this, "_ZN7S1292C12v3Ev");}
void  S1292C1 ::v4(){vfunc_called(this, "_ZN7S1292C12v4Ev");}
void  S1292C1 ::v5(){vfunc_called(this, "_ZN7S1292C12v5Ev");}
void  S1292C1 ::v6(){vfunc_called(this, "_ZN7S1292C12v6Ev");}
void  S1292C1 ::v7(){vfunc_called(this, "_ZN7S1292C12v7Ev");}
void  S1292C1 ::v8(){vfunc_called(this, "_ZN7S1292C12v8Ev");}
void  S1292C1 ::v9(){vfunc_called(this, "_ZN7S1292C12v9Ev");}
S1292C1 ::S1292C1(){ note_ctor("S1292C1", this);} // tgen

static void Test_S1292C1()
{
  extern Class_Descriptor cd_S1292C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(43,59)];
    init_test(&cd_S1292C1, buf);
    S1292C1 *dp, &lv = *(dp=new (buf) S1292C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(336,232), "sizeof(S1292C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1292C1)");
    check_base_class_offset(lv, (S1292C4*)(S1292C3*)(S1292C2*), 0, "S1292C1");
    check_base_class_offset(lv, (S1292C3*)(S1292C2*), 0, "S1292C1");
    check_base_class_offset(lv, (S1292C2*), 0, "S1292C1");
    set_bf_and_test(lv, s1292c1f0, ABISELECT(98,62), 0, 1, 1, "S1292C1");
    set_bf_and_test(lv, s1292c1f1, ABISELECT(98,62), 1, 1, 1, "S1292C1");
    set_bf_and_test(lv, s1292c1f2, ABISELECT(98,62), 2, 1, 1, "S1292C1");
    set_bf_and_test(lv, s1292c1f3, ABISELECT(98,62), 3, 1, 1, "S1292C1");
    set_bf_and_test(lv, s1292c1f4, ABISELECT(98,62), 4, 1, 1, "S1292C1");
    set_bf_and_test(lv, s1292c1f5, ABISELECT(98,62), 5, 1, 1, "S1292C1");
    set_bf_and_test(lv, s1292c1f6, ABISELECT(98,62), 6, 1, 1, "S1292C1");
    set_bf_and_test(lv, s1292c1f7, ABISELECT(98,62), 7, 1, 1, "S1292C1");
    check_field_offset(lv, s1292c1f8, ABISELECT(100,64), "S1292C1.s1292c1f8");
    check_field_offset(lv, s1292c1f9, ABISELECT(112,72), "S1292C1.s1292c1f9");
    check_field_offset(lv, s1292c1f10, ABISELECT(152,100), "S1292C1.s1292c1f10");
    check_field_offset(lv, s1292c1f11, ABISELECT(192,128), "S1292C1.s1292c1f11");
    check_field_offset(lv, s1292c1f12, ABISELECT(232,156), "S1292C1.s1292c1f12");
    check_field_offset(lv, s1292c1f13, ABISELECT(248,168), "S1292C1.s1292c1f13");
    check_field_offset(lv, s1292c1f14, ABISELECT(288,196), "S1292C1.s1292c1f14");
    check_field_offset(lv, s1292c1f15, ABISELECT(296,204), "S1292C1.s1292c1f15");
    test_class_info(&lv, &cd_S1292C1);
    dp->~S1292C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1292C1(Test_S1292C1, "S1292C1", ABISELECT(336,232));

#else // __cplusplus

extern void _ZN7S1292C1C1Ev();
extern void _ZN7S1292C1D1Ev();
Name_Map name_map_S1292C1[] = {
  NSPAIR(_ZN7S1292C1C1Ev),
  NSPAIR(_ZN7S1292C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1292C4;
extern VTBL_ENTRY _ZTI7S1292C4[];
extern  VTBL_ENTRY _ZTV7S1292C4[];
extern Class_Descriptor cd_S1292C3;
extern VTBL_ENTRY _ZTI7S1292C3[];
extern  VTBL_ENTRY _ZTV7S1292C3[];
extern Class_Descriptor cd_S1292C2;
extern VTBL_ENTRY _ZTI7S1292C2[];
extern  VTBL_ENTRY _ZTV7S1292C2[];
static Base_Class bases_S1292C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1292C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1292C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1292C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1292C1[];
extern void _ZN7S1292C1D1Ev();
extern void _ZN7S1292C1D0Ev();
extern void _ZN7S1292C43v10Ev();
extern void _ZN7S1292C43v11Ev();
extern void _ZN7S1292C43v12Ev();
extern void _ZN7S1292C43v13Ev();
extern void _ZN7S1292C43v14Ev();
extern void _ZN7S1292C43v15Ev();
extern void _ZN7S1292C43v16Ev();
extern void _ZN7S1292C43v17Ev();
extern void _ZN7S1292C43v18Ev();
extern void _ZN7S1292C43v19Ev();
extern void _ZN7S1292C43v20Ev();
extern void _ZN7S1292C43v21Ev();
extern void _ZN7S1292C43v22Ev();
extern void _ZN7S1292C43v23Ev();
extern void _ZN7S1292C43v24Ev();
extern void _ZN7S1292C43v25Ev();
extern void _ZN7S1292C43v26Ev();
extern void _ZN7S1292C43v27Ev();
extern void _ZN7S1292C43v28Ev();
extern void _ZN7S1292C43v29Ev();
extern void _ZN7S1292C43v30Ev();
extern void _ZN7S1292C43v31Ev();
extern void _ZN7S1292C43v32Ev();
extern void _ZN7S1292C43v33Ev();
extern void _ZN7S1292C43v34Ev();
extern void _ZN7S1292C43v35Ev();
extern void _ZN7S1292C43v36Ev();
extern void _ZN7S1292C43v37Ev();
extern void _ZN7S1292C43v38Ev();
extern void _ZN7S1292C43v39Ev();
extern void _ZN7S1292C43v40Ev();
extern void _ZN7S1292C43v41Ev();
extern void _ZN7S1292C43v42Ev();
extern void _ZN7S1292C43v43Ev();
extern void _ZN7S1292C43v44Ev();
extern void _ZN7S1292C43v45Ev();
extern void _ZN7S1292C43v46Ev();
extern void _ZN7S1292C43v47Ev();
extern void _ZN7S1292C43v48Ev();
extern void _ZN7S1292C43v49Ev();
extern void _ZN7S1292C43v50Ev();
extern void _ZN7S1292C43v51Ev();
extern void _ZN7S1292C43v52Ev();
extern void _ZN7S1292C43v53Ev();
extern void _ZN7S1292C43v54Ev();
extern void _ZN7S1292C43v55Ev();
extern void _ZN7S1292C43v56Ev();
extern void _ZN7S1292C43v57Ev();
extern void _ZN7S1292C43v58Ev();
extern void _ZN7S1292C43v59Ev();
extern void _ZN7S1292C43v60Ev();
extern void _ZN7S1292C43v61Ev();
extern void _ZN7S1292C43v62Ev();
extern void _ZN7S1292C43v63Ev();
extern void _ZN7S1292C43v64Ev();
extern void _ZN7S1292C43v65Ev();
extern void _ZN7S1292C43v66Ev();
extern void _ZN7S1292C43v67Ev();
extern void _ZN7S1292C43v68Ev();
extern void _ZN7S1292C43v69Ev();
extern void _ZN7S1292C43v70Ev();
extern void _ZN7S1292C43v71Ev();
extern void _ZN7S1292C43v72Ev();
extern void _ZN7S1292C43v73Ev();
extern void _ZN7S1292C33v74Ev();
extern void _ZN7S1292C33v75Ev();
extern void _ZN7S1292C33v76Ev();
extern void _ZN7S1292C33v77Ev();
extern void _ZN7S1292C33v78Ev();
extern void _ZN7S1292C33v79Ev();
extern void _ZN7S1292C33v80Ev();
extern void _ZN7S1292C33v81Ev();
extern void _ZN7S1292C33v82Ev();
extern void _ZN7S1292C33v83Ev();
extern void _ZN7S1292C33v84Ev();
extern void _ZN7S1292C33v85Ev();
extern void _ZN7S1292C33v86Ev();
extern void _ZN7S1292C33v87Ev();
extern void _ZN7S1292C33v88Ev();
extern void _ZN7S1292C33v89Ev();
extern void _ZN7S1292C33v90Ev();
extern void _ZN7S1292C33v91Ev();
extern void _ZN7S1292C33v92Ev();
extern void _ZN7S1292C33v93Ev();
extern void _ZN7S1292C23v94Ev();
extern void _ZN7S1292C23v95Ev();
extern void _ZN7S1292C23v96Ev();
extern void _ZN7S1292C12v1Ev();
extern void _ZN7S1292C12v2Ev();
extern void _ZN7S1292C12v3Ev();
extern void _ZN7S1292C12v4Ev();
extern void _ZN7S1292C12v5Ev();
extern void _ZN7S1292C12v6Ev();
extern void _ZN7S1292C12v7Ev();
extern void _ZN7S1292C12v8Ev();
extern void _ZN7S1292C12v9Ev();
static  VTBL_ENTRY vtc_S1292C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1292C1[0]),
  (VTBL_ENTRY)&_ZN7S1292C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1292C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1292C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1292C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1292C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1292C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1292C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1292C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1292C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1292C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1292C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1292C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1292C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1292C12v7Ev,
  (VTBL_ENTRY)&_ZN7S1292C12v8Ev,
  (VTBL_ENTRY)&_ZN7S1292C12v9Ev,
};
extern VTBL_ENTRY _ZTI7S1292C1[];
extern  VTBL_ENTRY _ZTV7S1292C1[];
Class_Descriptor cd_S1292C1 = {  "S1292C1", // class name
  bases_S1292C1, 3,
  &(vtc_S1292C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(336,232), // object size
  NSPAIRA(_ZTI7S1292C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1292C1),100, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1290C4  {
  int s1290c4f0;
  __tsi64 s1290c4f1;
  void *s1290c4f2[4];
  int s1290c4f3[2];
  void *s1290c4f4;
  ::S674C6_nt s1290c4f5;
  void *s1290c4f6[2];
  virtual  ~S1290C4(); // _ZN7S1290C4D1Ev
  virtual void  v10(); // _ZN7S1290C43v10Ev
  virtual void  v11(); // _ZN7S1290C43v11Ev
  virtual void  v12(); // _ZN7S1290C43v12Ev
  virtual void  v13(); // _ZN7S1290C43v13Ev
  virtual void  v14(); // _ZN7S1290C43v14Ev
  virtual void  v15(); // _ZN7S1290C43v15Ev
  virtual void  v16(); // _ZN7S1290C43v16Ev
  virtual void  v17(); // _ZN7S1290C43v17Ev
  virtual void  v18(); // _ZN7S1290C43v18Ev
  virtual void  v19(); // _ZN7S1290C43v19Ev
  virtual void  v20(); // _ZN7S1290C43v20Ev
  virtual void  v21(); // _ZN7S1290C43v21Ev
  virtual void  v22(); // _ZN7S1290C43v22Ev
  virtual void  v23(); // _ZN7S1290C43v23Ev
  virtual void  v24(); // _ZN7S1290C43v24Ev
  virtual void  v25(); // _ZN7S1290C43v25Ev
  virtual void  v26(); // _ZN7S1290C43v26Ev
  virtual void  v27(); // _ZN7S1290C43v27Ev
  virtual void  v28(); // _ZN7S1290C43v28Ev
  virtual void  v29(); // _ZN7S1290C43v29Ev
  virtual void  v30(); // _ZN7S1290C43v30Ev
  virtual void  v31(); // _ZN7S1290C43v31Ev
  virtual void  v32(); // _ZN7S1290C43v32Ev
  virtual void  v33(); // _ZN7S1290C43v33Ev
  virtual void  v34(); // _ZN7S1290C43v34Ev
  virtual void  v35(); // _ZN7S1290C43v35Ev
  virtual void  v36(); // _ZN7S1290C43v36Ev
  virtual void  v37(); // _ZN7S1290C43v37Ev
  virtual void  v38(); // _ZN7S1290C43v38Ev
  virtual void  v39(); // _ZN7S1290C43v39Ev
  virtual void  v40(); // _ZN7S1290C43v40Ev
  virtual void  v41(); // _ZN7S1290C43v41Ev
  virtual void  v42(); // _ZN7S1290C43v42Ev
  virtual void  v43(); // _ZN7S1290C43v43Ev
  virtual void  v44(); // _ZN7S1290C43v44Ev
  virtual void  v45(); // _ZN7S1290C43v45Ev
  virtual void  v46(); // _ZN7S1290C43v46Ev
  virtual void  v47(); // _ZN7S1290C43v47Ev
  virtual void  v48(); // _ZN7S1290C43v48Ev
  virtual void  v49(); // _ZN7S1290C43v49Ev
  virtual void  v50(); // _ZN7S1290C43v50Ev
  virtual void  v51(); // _ZN7S1290C43v51Ev
  virtual void  v52(); // _ZN7S1290C43v52Ev
  virtual void  v53(); // _ZN7S1290C43v53Ev
  virtual void  v54(); // _ZN7S1290C43v54Ev
  virtual void  v55(); // _ZN7S1290C43v55Ev
  virtual void  v56(); // _ZN7S1290C43v56Ev
  virtual void  v57(); // _ZN7S1290C43v57Ev
  virtual void  v58(); // _ZN7S1290C43v58Ev
  virtual void  v59(); // _ZN7S1290C43v59Ev
  virtual void  v60(); // _ZN7S1290C43v60Ev
  virtual void  v61(); // _ZN7S1290C43v61Ev
  virtual void  v62(); // _ZN7S1290C43v62Ev
  virtual void  v63(); // _ZN7S1290C43v63Ev
  virtual void  v64(); // _ZN7S1290C43v64Ev
  virtual void  v65(); // _ZN7S1290C43v65Ev
  virtual void  v66(); // _ZN7S1290C43v66Ev
  virtual void  v67(); // _ZN7S1290C43v67Ev
  virtual void  v68(); // _ZN7S1290C43v68Ev
  virtual void  v69(); // _ZN7S1290C43v69Ev
  virtual void  v70(); // _ZN7S1290C43v70Ev
  virtual void  v71(); // _ZN7S1290C43v71Ev
  virtual void  v72(); // _ZN7S1290C43v72Ev
  virtual void  v73(); // _ZN7S1290C43v73Ev
  S1290C4(); // tgen
};
//SIG(-1 S1290C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1290C4 ::~S1290C4(){ note_dtor("S1290C4", this);}
void  S1290C4 ::v10(){vfunc_called(this, "_ZN7S1290C43v10Ev");}
void  S1290C4 ::v11(){vfunc_called(this, "_ZN7S1290C43v11Ev");}
void  S1290C4 ::v12(){vfunc_called(this, "_ZN7S1290C43v12Ev");}
void  S1290C4 ::v13(){vfunc_called(this, "_ZN7S1290C43v13Ev");}
void  S1290C4 ::v14(){vfunc_called(this, "_ZN7S1290C43v14Ev");}
void  S1290C4 ::v15(){vfunc_called(this, "_ZN7S1290C43v15Ev");}
void  S1290C4 ::v16(){vfunc_called(this, "_ZN7S1290C43v16Ev");}
void  S1290C4 ::v17(){vfunc_called(this, "_ZN7S1290C43v17Ev");}
void  S1290C4 ::v18(){vfunc_called(this, "_ZN7S1290C43v18Ev");}
void  S1290C4 ::v19(){vfunc_called(this, "_ZN7S1290C43v19Ev");}
void  S1290C4 ::v20(){vfunc_called(this, "_ZN7S1290C43v20Ev");}
void  S1290C4 ::v21(){vfunc_called(this, "_ZN7S1290C43v21Ev");}
void  S1290C4 ::v22(){vfunc_called(this, "_ZN7S1290C43v22Ev");}
void  S1290C4 ::v23(){vfunc_called(this, "_ZN7S1290C43v23Ev");}
void  S1290C4 ::v24(){vfunc_called(this, "_ZN7S1290C43v24Ev");}
void  S1290C4 ::v25(){vfunc_called(this, "_ZN7S1290C43v25Ev");}
void  S1290C4 ::v26(){vfunc_called(this, "_ZN7S1290C43v26Ev");}
void  S1290C4 ::v27(){vfunc_called(this, "_ZN7S1290C43v27Ev");}
void  S1290C4 ::v28(){vfunc_called(this, "_ZN7S1290C43v28Ev");}
void  S1290C4 ::v29(){vfunc_called(this, "_ZN7S1290C43v29Ev");}
void  S1290C4 ::v30(){vfunc_called(this, "_ZN7S1290C43v30Ev");}
void  S1290C4 ::v31(){vfunc_called(this, "_ZN7S1290C43v31Ev");}
void  S1290C4 ::v32(){vfunc_called(this, "_ZN7S1290C43v32Ev");}
void  S1290C4 ::v33(){vfunc_called(this, "_ZN7S1290C43v33Ev");}
void  S1290C4 ::v34(){vfunc_called(this, "_ZN7S1290C43v34Ev");}
void  S1290C4 ::v35(){vfunc_called(this, "_ZN7S1290C43v35Ev");}
void  S1290C4 ::v36(){vfunc_called(this, "_ZN7S1290C43v36Ev");}
void  S1290C4 ::v37(){vfunc_called(this, "_ZN7S1290C43v37Ev");}
void  S1290C4 ::v38(){vfunc_called(this, "_ZN7S1290C43v38Ev");}
void  S1290C4 ::v39(){vfunc_called(this, "_ZN7S1290C43v39Ev");}
void  S1290C4 ::v40(){vfunc_called(this, "_ZN7S1290C43v40Ev");}
void  S1290C4 ::v41(){vfunc_called(this, "_ZN7S1290C43v41Ev");}
void  S1290C4 ::v42(){vfunc_called(this, "_ZN7S1290C43v42Ev");}
void  S1290C4 ::v43(){vfunc_called(this, "_ZN7S1290C43v43Ev");}
void  S1290C4 ::v44(){vfunc_called(this, "_ZN7S1290C43v44Ev");}
void  S1290C4 ::v45(){vfunc_called(this, "_ZN7S1290C43v45Ev");}
void  S1290C4 ::v46(){vfunc_called(this, "_ZN7S1290C43v46Ev");}
void  S1290C4 ::v47(){vfunc_called(this, "_ZN7S1290C43v47Ev");}
void  S1290C4 ::v48(){vfunc_called(this, "_ZN7S1290C43v48Ev");}
void  S1290C4 ::v49(){vfunc_called(this, "_ZN7S1290C43v49Ev");}
void  S1290C4 ::v50(){vfunc_called(this, "_ZN7S1290C43v50Ev");}
void  S1290C4 ::v51(){vfunc_called(this, "_ZN7S1290C43v51Ev");}
void  S1290C4 ::v52(){vfunc_called(this, "_ZN7S1290C43v52Ev");}
void  S1290C4 ::v53(){vfunc_called(this, "_ZN7S1290C43v53Ev");}
void  S1290C4 ::v54(){vfunc_called(this, "_ZN7S1290C43v54Ev");}
void  S1290C4 ::v55(){vfunc_called(this, "_ZN7S1290C43v55Ev");}
void  S1290C4 ::v56(){vfunc_called(this, "_ZN7S1290C43v56Ev");}
void  S1290C4 ::v57(){vfunc_called(this, "_ZN7S1290C43v57Ev");}
void  S1290C4 ::v58(){vfunc_called(this, "_ZN7S1290C43v58Ev");}
void  S1290C4 ::v59(){vfunc_called(this, "_ZN7S1290C43v59Ev");}
void  S1290C4 ::v60(){vfunc_called(this, "_ZN7S1290C43v60Ev");}
void  S1290C4 ::v61(){vfunc_called(this, "_ZN7S1290C43v61Ev");}
void  S1290C4 ::v62(){vfunc_called(this, "_ZN7S1290C43v62Ev");}
void  S1290C4 ::v63(){vfunc_called(this, "_ZN7S1290C43v63Ev");}
void  S1290C4 ::v64(){vfunc_called(this, "_ZN7S1290C43v64Ev");}
void  S1290C4 ::v65(){vfunc_called(this, "_ZN7S1290C43v65Ev");}
void  S1290C4 ::v66(){vfunc_called(this, "_ZN7S1290C43v66Ev");}
void  S1290C4 ::v67(){vfunc_called(this, "_ZN7S1290C43v67Ev");}
void  S1290C4 ::v68(){vfunc_called(this, "_ZN7S1290C43v68Ev");}
void  S1290C4 ::v69(){vfunc_called(this, "_ZN7S1290C43v69Ev");}
void  S1290C4 ::v70(){vfunc_called(this, "_ZN7S1290C43v70Ev");}
void  S1290C4 ::v71(){vfunc_called(this, "_ZN7S1290C43v71Ev");}
void  S1290C4 ::v72(){vfunc_called(this, "_ZN7S1290C43v72Ev");}
void  S1290C4 ::v73(){vfunc_called(this, "_ZN7S1290C43v73Ev");}
S1290C4 ::S1290C4(){ note_ctor("S1290C4", this);} // tgen

static void Test_S1290C4()
{
  extern Class_Descriptor cd_S1290C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1290C4, buf);
    S1290C4 *dp, &lv = *(dp=new (buf) S1290C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1290C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1290C4)");
    check_field_offset(lv, s1290c4f0, ABISELECT(8,4), "S1290C4.s1290c4f0");
    check_field_offset(lv, s1290c4f1, ABISELECT(16,8), "S1290C4.s1290c4f1");
    check_field_offset(lv, s1290c4f2, ABISELECT(24,16), "S1290C4.s1290c4f2");
    check_field_offset(lv, s1290c4f3, ABISELECT(56,32), "S1290C4.s1290c4f3");
    check_field_offset(lv, s1290c4f4, ABISELECT(64,40), "S1290C4.s1290c4f4");
    check_field_offset(lv, s1290c4f5, ABISELECT(72,44), "S1290C4.s1290c4f5");
    check_field_offset(lv, s1290c4f6, ABISELECT(80,52), "S1290C4.s1290c4f6");
    test_class_info(&lv, &cd_S1290C4);
    dp->~S1290C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1290C4(Test_S1290C4, "S1290C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1290C4C1Ev();
extern void _ZN7S1290C4D1Ev();
Name_Map name_map_S1290C4[] = {
  NSPAIR(_ZN7S1290C4C1Ev),
  NSPAIR(_ZN7S1290C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1290C4[];
extern void _ZN7S1290C4D1Ev();
extern void _ZN7S1290C4D0Ev();
extern void _ZN7S1290C43v10Ev();
extern void _ZN7S1290C43v11Ev();
extern void _ZN7S1290C43v12Ev();
extern void _ZN7S1290C43v13Ev();
extern void _ZN7S1290C43v14Ev();
extern void _ZN7S1290C43v15Ev();
extern void _ZN7S1290C43v16Ev();
extern void _ZN7S1290C43v17Ev();
extern void _ZN7S1290C43v18Ev();
extern void _ZN7S1290C43v19Ev();
extern void _ZN7S1290C43v20Ev();
extern void _ZN7S1290C43v21Ev();
extern void _ZN7S1290C43v22Ev();
extern void _ZN7S1290C43v23Ev();
extern void _ZN7S1290C43v24Ev();
extern void _ZN7S1290C43v25Ev();
extern void _ZN7S1290C43v26Ev();
extern void _ZN7S1290C43v27Ev();
extern void _ZN7S1290C43v28Ev();
extern void _ZN7S1290C43v29Ev();
extern void _ZN7S1290C43v30Ev();
extern void _ZN7S1290C43v31Ev();
extern void _ZN7S1290C43v32Ev();
extern void _ZN7S1290C43v33Ev();
extern void _ZN7S1290C43v34Ev();
extern void _ZN7S1290C43v35Ev();
extern void _ZN7S1290C43v36Ev();
extern void _ZN7S1290C43v37Ev();
extern void _ZN7S1290C43v38Ev();
extern void _ZN7S1290C43v39Ev();
extern void _ZN7S1290C43v40Ev();
extern void _ZN7S1290C43v41Ev();
extern void _ZN7S1290C43v42Ev();
extern void _ZN7S1290C43v43Ev();
extern void _ZN7S1290C43v44Ev();
extern void _ZN7S1290C43v45Ev();
extern void _ZN7S1290C43v46Ev();
extern void _ZN7S1290C43v47Ev();
extern void _ZN7S1290C43v48Ev();
extern void _ZN7S1290C43v49Ev();
extern void _ZN7S1290C43v50Ev();
extern void _ZN7S1290C43v51Ev();
extern void _ZN7S1290C43v52Ev();
extern void _ZN7S1290C43v53Ev();
extern void _ZN7S1290C43v54Ev();
extern void _ZN7S1290C43v55Ev();
extern void _ZN7S1290C43v56Ev();
extern void _ZN7S1290C43v57Ev();
extern void _ZN7S1290C43v58Ev();
extern void _ZN7S1290C43v59Ev();
extern void _ZN7S1290C43v60Ev();
extern void _ZN7S1290C43v61Ev();
extern void _ZN7S1290C43v62Ev();
extern void _ZN7S1290C43v63Ev();
extern void _ZN7S1290C43v64Ev();
extern void _ZN7S1290C43v65Ev();
extern void _ZN7S1290C43v66Ev();
extern void _ZN7S1290C43v67Ev();
extern void _ZN7S1290C43v68Ev();
extern void _ZN7S1290C43v69Ev();
extern void _ZN7S1290C43v70Ev();
extern void _ZN7S1290C43v71Ev();
extern void _ZN7S1290C43v72Ev();
extern void _ZN7S1290C43v73Ev();
static  VTBL_ENTRY vtc_S1290C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1290C4[0]),
  (VTBL_ENTRY)&_ZN7S1290C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1290C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v73Ev,
};
extern VTBL_ENTRY _ZTI7S1290C4[];
extern  VTBL_ENTRY _ZTV7S1290C4[];
Class_Descriptor cd_S1290C4 = {  "S1290C4", // class name
  0,0,//no base classes
  &(vtc_S1290C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1290C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1290C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1290C3  : S1290C4 {
  unsigned int s1290c3f0:1;
  unsigned int s1290c3f1:1;
  unsigned int s1290c3f2:1;
  unsigned int s1290c3f3:1;
  unsigned int s1290c3f4:1;
  unsigned int s1290c3f5:1;
  unsigned int s1290c3f6:1;
  ::S3625C32 s1290c3f7;
  virtual  ~S1290C3(); // _ZN7S1290C3D1Ev
  virtual void  v74(); // _ZN7S1290C33v74Ev
  virtual void  v75(); // _ZN7S1290C33v75Ev
  virtual void  v76(); // _ZN7S1290C33v76Ev
  virtual void  v77(); // _ZN7S1290C33v77Ev
  virtual void  v78(); // _ZN7S1290C33v78Ev
  virtual void  v79(); // _ZN7S1290C33v79Ev
  virtual void  v80(); // _ZN7S1290C33v80Ev
  virtual void  v81(); // _ZN7S1290C33v81Ev
  virtual void  v82(); // _ZN7S1290C33v82Ev
  virtual void  v83(); // _ZN7S1290C33v83Ev
  virtual void  v84(); // _ZN7S1290C33v84Ev
  virtual void  v85(); // _ZN7S1290C33v85Ev
  virtual void  v86(); // _ZN7S1290C33v86Ev
  virtual void  v87(); // _ZN7S1290C33v87Ev
  virtual void  v88(); // _ZN7S1290C33v88Ev
  virtual void  v89(); // _ZN7S1290C33v89Ev
  virtual void  v90(); // _ZN7S1290C33v90Ev
  virtual void  v91(); // _ZN7S1290C33v91Ev
  virtual void  v92(); // _ZN7S1290C33v92Ev
  virtual void  v93(); // _ZN7S1290C33v93Ev
  S1290C3(); // tgen
};
//SIG(-1 S1290C3) C1{ BC2{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC4{ m}}


 S1290C3 ::~S1290C3(){ note_dtor("S1290C3", this);}
void  S1290C3 ::v74(){vfunc_called(this, "_ZN7S1290C33v74Ev");}
void  S1290C3 ::v75(){vfunc_called(this, "_ZN7S1290C33v75Ev");}
void  S1290C3 ::v76(){vfunc_called(this, "_ZN7S1290C33v76Ev");}
void  S1290C3 ::v77(){vfunc_called(this, "_ZN7S1290C33v77Ev");}
void  S1290C3 ::v78(){vfunc_called(this, "_ZN7S1290C33v78Ev");}
void  S1290C3 ::v79(){vfunc_called(this, "_ZN7S1290C33v79Ev");}
void  S1290C3 ::v80(){vfunc_called(this, "_ZN7S1290C33v80Ev");}
void  S1290C3 ::v81(){vfunc_called(this, "_ZN7S1290C33v81Ev");}
void  S1290C3 ::v82(){vfunc_called(this, "_ZN7S1290C33v82Ev");}
void  S1290C3 ::v83(){vfunc_called(this, "_ZN7S1290C33v83Ev");}
void  S1290C3 ::v84(){vfunc_called(this, "_ZN7S1290C33v84Ev");}
void  S1290C3 ::v85(){vfunc_called(this, "_ZN7S1290C33v85Ev");}
void  S1290C3 ::v86(){vfunc_called(this, "_ZN7S1290C33v86Ev");}
void  S1290C3 ::v87(){vfunc_called(this, "_ZN7S1290C33v87Ev");}
void  S1290C3 ::v88(){vfunc_called(this, "_ZN7S1290C33v88Ev");}
void  S1290C3 ::v89(){vfunc_called(this, "_ZN7S1290C33v89Ev");}
void  S1290C3 ::v90(){vfunc_called(this, "_ZN7S1290C33v90Ev");}
void  S1290C3 ::v91(){vfunc_called(this, "_ZN7S1290C33v91Ev");}
void  S1290C3 ::v92(){vfunc_called(this, "_ZN7S1290C33v92Ev");}
void  S1290C3 ::v93(){vfunc_called(this, "_ZN7S1290C33v93Ev");}
S1290C3 ::S1290C3(){ note_ctor("S1290C3", this);} // tgen

static void Test_S1290C3()
{
  extern Class_Descriptor cd_S1290C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S1290C3, buf);
    S1290C3 *dp, &lv = *(dp=new (buf) S1290C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S1290C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1290C3)");
    check_base_class_offset(lv, (S1290C4*), 0, "S1290C3");
    set_bf_and_test(lv, s1290c3f0, ABISELECT(96,60), 0, 1, 1, "S1290C3");
    set_bf_and_test(lv, s1290c3f1, ABISELECT(96,60), 1, 1, 1, "S1290C3");
    set_bf_and_test(lv, s1290c3f2, ABISELECT(96,60), 2, 1, 1, "S1290C3");
    set_bf_and_test(lv, s1290c3f3, ABISELECT(96,60), 3, 1, 1, "S1290C3");
    set_bf_and_test(lv, s1290c3f4, ABISELECT(96,60), 4, 1, 1, "S1290C3");
    set_bf_and_test(lv, s1290c3f5, ABISELECT(96,60), 5, 1, 1, "S1290C3");
    set_bf_and_test(lv, s1290c3f6, ABISELECT(96,60), 6, 1, 1, "S1290C3");
    check_field_offset(lv, s1290c3f7, ABISELECT(97,61), "S1290C3.s1290c3f7");
    test_class_info(&lv, &cd_S1290C3);
    dp->~S1290C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1290C3(Test_S1290C3, "S1290C3", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN7S1290C3C1Ev();
extern void _ZN7S1290C3D1Ev();
Name_Map name_map_S1290C3[] = {
  NSPAIR(_ZN7S1290C3C1Ev),
  NSPAIR(_ZN7S1290C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1290C4;
extern VTBL_ENTRY _ZTI7S1290C4[];
extern  VTBL_ENTRY _ZTV7S1290C4[];
static Base_Class bases_S1290C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1290C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1290C3[];
extern void _ZN7S1290C3D1Ev();
extern void _ZN7S1290C3D0Ev();
extern void _ZN7S1290C43v10Ev();
extern void _ZN7S1290C43v11Ev();
extern void _ZN7S1290C43v12Ev();
extern void _ZN7S1290C43v13Ev();
extern void _ZN7S1290C43v14Ev();
extern void _ZN7S1290C43v15Ev();
extern void _ZN7S1290C43v16Ev();
extern void _ZN7S1290C43v17Ev();
extern void _ZN7S1290C43v18Ev();
extern void _ZN7S1290C43v19Ev();
extern void _ZN7S1290C43v20Ev();
extern void _ZN7S1290C43v21Ev();
extern void _ZN7S1290C43v22Ev();
extern void _ZN7S1290C43v23Ev();
extern void _ZN7S1290C43v24Ev();
extern void _ZN7S1290C43v25Ev();
extern void _ZN7S1290C43v26Ev();
extern void _ZN7S1290C43v27Ev();
extern void _ZN7S1290C43v28Ev();
extern void _ZN7S1290C43v29Ev();
extern void _ZN7S1290C43v30Ev();
extern void _ZN7S1290C43v31Ev();
extern void _ZN7S1290C43v32Ev();
extern void _ZN7S1290C43v33Ev();
extern void _ZN7S1290C43v34Ev();
extern void _ZN7S1290C43v35Ev();
extern void _ZN7S1290C43v36Ev();
extern void _ZN7S1290C43v37Ev();
extern void _ZN7S1290C43v38Ev();
extern void _ZN7S1290C43v39Ev();
extern void _ZN7S1290C43v40Ev();
extern void _ZN7S1290C43v41Ev();
extern void _ZN7S1290C43v42Ev();
extern void _ZN7S1290C43v43Ev();
extern void _ZN7S1290C43v44Ev();
extern void _ZN7S1290C43v45Ev();
extern void _ZN7S1290C43v46Ev();
extern void _ZN7S1290C43v47Ev();
extern void _ZN7S1290C43v48Ev();
extern void _ZN7S1290C43v49Ev();
extern void _ZN7S1290C43v50Ev();
extern void _ZN7S1290C43v51Ev();
extern void _ZN7S1290C43v52Ev();
extern void _ZN7S1290C43v53Ev();
extern void _ZN7S1290C43v54Ev();
extern void _ZN7S1290C43v55Ev();
extern void _ZN7S1290C43v56Ev();
extern void _ZN7S1290C43v57Ev();
extern void _ZN7S1290C43v58Ev();
extern void _ZN7S1290C43v59Ev();
extern void _ZN7S1290C43v60Ev();
extern void _ZN7S1290C43v61Ev();
extern void _ZN7S1290C43v62Ev();
extern void _ZN7S1290C43v63Ev();
extern void _ZN7S1290C43v64Ev();
extern void _ZN7S1290C43v65Ev();
extern void _ZN7S1290C43v66Ev();
extern void _ZN7S1290C43v67Ev();
extern void _ZN7S1290C43v68Ev();
extern void _ZN7S1290C43v69Ev();
extern void _ZN7S1290C43v70Ev();
extern void _ZN7S1290C43v71Ev();
extern void _ZN7S1290C43v72Ev();
extern void _ZN7S1290C43v73Ev();
extern void _ZN7S1290C33v74Ev();
extern void _ZN7S1290C33v75Ev();
extern void _ZN7S1290C33v76Ev();
extern void _ZN7S1290C33v77Ev();
extern void _ZN7S1290C33v78Ev();
extern void _ZN7S1290C33v79Ev();
extern void _ZN7S1290C33v80Ev();
extern void _ZN7S1290C33v81Ev();
extern void _ZN7S1290C33v82Ev();
extern void _ZN7S1290C33v83Ev();
extern void _ZN7S1290C33v84Ev();
extern void _ZN7S1290C33v85Ev();
extern void _ZN7S1290C33v86Ev();
extern void _ZN7S1290C33v87Ev();
extern void _ZN7S1290C33v88Ev();
extern void _ZN7S1290C33v89Ev();
extern void _ZN7S1290C33v90Ev();
extern void _ZN7S1290C33v91Ev();
extern void _ZN7S1290C33v92Ev();
extern void _ZN7S1290C33v93Ev();
static  VTBL_ENTRY vtc_S1290C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1290C3[0]),
  (VTBL_ENTRY)&_ZN7S1290C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1290C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v93Ev,
};
extern VTBL_ENTRY _ZTI7S1290C3[];
extern  VTBL_ENTRY _ZTV7S1290C3[];
Class_Descriptor cd_S1290C3 = {  "S1290C3", // class name
  bases_S1290C3, 1,
  &(vtc_S1290C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI7S1290C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1290C3),88, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1290C2  : S1290C3 {
  virtual  ~S1290C2(); // _ZN7S1290C2D1Ev
  virtual void  v94(); // _ZN7S1290C23v94Ev
  virtual void  v95(); // _ZN7S1290C23v95Ev
  virtual void  v96(); // _ZN7S1290C23v96Ev
  virtual void  v97(); // _ZN7S1290C23v97Ev
  virtual void  v98(); // _ZN7S1290C23v98Ev
  virtual void  v99(); // _ZN7S1290C23v99Ev
  virtual void  v100(); // _ZN7S1290C24v100Ev
  virtual void  v101(); // _ZN7S1290C24v101Ev
  virtual void  v102(); // _ZN7S1290C24v102Ev
  S1290C2(); // tgen
};
//SIG(-1 S1290C2) C1{ BC2{ BC3{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC5{ m}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9}


 S1290C2 ::~S1290C2(){ note_dtor("S1290C2", this);}
void  S1290C2 ::v94(){vfunc_called(this, "_ZN7S1290C23v94Ev");}
void  S1290C2 ::v95(){vfunc_called(this, "_ZN7S1290C23v95Ev");}
void  S1290C2 ::v96(){vfunc_called(this, "_ZN7S1290C23v96Ev");}
void  S1290C2 ::v97(){vfunc_called(this, "_ZN7S1290C23v97Ev");}
void  S1290C2 ::v98(){vfunc_called(this, "_ZN7S1290C23v98Ev");}
void  S1290C2 ::v99(){vfunc_called(this, "_ZN7S1290C23v99Ev");}
void  S1290C2 ::v100(){vfunc_called(this, "_ZN7S1290C24v100Ev");}
void  S1290C2 ::v101(){vfunc_called(this, "_ZN7S1290C24v101Ev");}
void  S1290C2 ::v102(){vfunc_called(this, "_ZN7S1290C24v102Ev");}
S1290C2 ::S1290C2(){ note_ctor("S1290C2", this);} // tgen

static void Test_S1290C2()
{
  extern Class_Descriptor cd_S1290C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S1290C2, buf);
    S1290C2 *dp, &lv = *(dp=new (buf) S1290C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S1290C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1290C2)");
    check_base_class_offset(lv, (S1290C4*)(S1290C3*), 0, "S1290C2");
    check_base_class_offset(lv, (S1290C3*), 0, "S1290C2");
    test_class_info(&lv, &cd_S1290C2);
    dp->~S1290C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1290C2(Test_S1290C2, "S1290C2", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN7S1290C2C1Ev();
extern void _ZN7S1290C2D1Ev();
Name_Map name_map_S1290C2[] = {
  NSPAIR(_ZN7S1290C2C1Ev),
  NSPAIR(_ZN7S1290C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1290C4;
extern VTBL_ENTRY _ZTI7S1290C4[];
extern  VTBL_ENTRY _ZTV7S1290C4[];
extern Class_Descriptor cd_S1290C3;
extern VTBL_ENTRY _ZTI7S1290C3[];
extern  VTBL_ENTRY _ZTV7S1290C3[];
static Base_Class bases_S1290C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1290C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1290C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1290C2[];
extern void _ZN7S1290C2D1Ev();
extern void _ZN7S1290C2D0Ev();
extern void _ZN7S1290C43v10Ev();
extern void _ZN7S1290C43v11Ev();
extern void _ZN7S1290C43v12Ev();
extern void _ZN7S1290C43v13Ev();
extern void _ZN7S1290C43v14Ev();
extern void _ZN7S1290C43v15Ev();
extern void _ZN7S1290C43v16Ev();
extern void _ZN7S1290C43v17Ev();
extern void _ZN7S1290C43v18Ev();
extern void _ZN7S1290C43v19Ev();
extern void _ZN7S1290C43v20Ev();
extern void _ZN7S1290C43v21Ev();
extern void _ZN7S1290C43v22Ev();
extern void _ZN7S1290C43v23Ev();
extern void _ZN7S1290C43v24Ev();
extern void _ZN7S1290C43v25Ev();
extern void _ZN7S1290C43v26Ev();
extern void _ZN7S1290C43v27Ev();
extern void _ZN7S1290C43v28Ev();
extern void _ZN7S1290C43v29Ev();
extern void _ZN7S1290C43v30Ev();
extern void _ZN7S1290C43v31Ev();
extern void _ZN7S1290C43v32Ev();
extern void _ZN7S1290C43v33Ev();
extern void _ZN7S1290C43v34Ev();
extern void _ZN7S1290C43v35Ev();
extern void _ZN7S1290C43v36Ev();
extern void _ZN7S1290C43v37Ev();
extern void _ZN7S1290C43v38Ev();
extern void _ZN7S1290C43v39Ev();
extern void _ZN7S1290C43v40Ev();
extern void _ZN7S1290C43v41Ev();
extern void _ZN7S1290C43v42Ev();
extern void _ZN7S1290C43v43Ev();
extern void _ZN7S1290C43v44Ev();
extern void _ZN7S1290C43v45Ev();
extern void _ZN7S1290C43v46Ev();
extern void _ZN7S1290C43v47Ev();
extern void _ZN7S1290C43v48Ev();
extern void _ZN7S1290C43v49Ev();
extern void _ZN7S1290C43v50Ev();
extern void _ZN7S1290C43v51Ev();
extern void _ZN7S1290C43v52Ev();
extern void _ZN7S1290C43v53Ev();
extern void _ZN7S1290C43v54Ev();
extern void _ZN7S1290C43v55Ev();
extern void _ZN7S1290C43v56Ev();
extern void _ZN7S1290C43v57Ev();
extern void _ZN7S1290C43v58Ev();
extern void _ZN7S1290C43v59Ev();
extern void _ZN7S1290C43v60Ev();
extern void _ZN7S1290C43v61Ev();
extern void _ZN7S1290C43v62Ev();
extern void _ZN7S1290C43v63Ev();
extern void _ZN7S1290C43v64Ev();
extern void _ZN7S1290C43v65Ev();
extern void _ZN7S1290C43v66Ev();
extern void _ZN7S1290C43v67Ev();
extern void _ZN7S1290C43v68Ev();
extern void _ZN7S1290C43v69Ev();
extern void _ZN7S1290C43v70Ev();
extern void _ZN7S1290C43v71Ev();
extern void _ZN7S1290C43v72Ev();
extern void _ZN7S1290C43v73Ev();
extern void _ZN7S1290C33v74Ev();
extern void _ZN7S1290C33v75Ev();
extern void _ZN7S1290C33v76Ev();
extern void _ZN7S1290C33v77Ev();
extern void _ZN7S1290C33v78Ev();
extern void _ZN7S1290C33v79Ev();
extern void _ZN7S1290C33v80Ev();
extern void _ZN7S1290C33v81Ev();
extern void _ZN7S1290C33v82Ev();
extern void _ZN7S1290C33v83Ev();
extern void _ZN7S1290C33v84Ev();
extern void _ZN7S1290C33v85Ev();
extern void _ZN7S1290C33v86Ev();
extern void _ZN7S1290C33v87Ev();
extern void _ZN7S1290C33v88Ev();
extern void _ZN7S1290C33v89Ev();
extern void _ZN7S1290C33v90Ev();
extern void _ZN7S1290C33v91Ev();
extern void _ZN7S1290C33v92Ev();
extern void _ZN7S1290C33v93Ev();
extern void _ZN7S1290C23v94Ev();
extern void _ZN7S1290C23v95Ev();
extern void _ZN7S1290C23v96Ev();
extern void _ZN7S1290C23v97Ev();
extern void _ZN7S1290C23v98Ev();
extern void _ZN7S1290C23v99Ev();
extern void _ZN7S1290C24v100Ev();
extern void _ZN7S1290C24v101Ev();
extern void _ZN7S1290C24v102Ev();
static  VTBL_ENTRY vtc_S1290C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1290C2[0]),
  (VTBL_ENTRY)&_ZN7S1290C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1290C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1290C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1290C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1290C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1290C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1290C23v98Ev,
  (VTBL_ENTRY)&_ZN7S1290C23v99Ev,
  (VTBL_ENTRY)&_ZN7S1290C24v100Ev,
  (VTBL_ENTRY)&_ZN7S1290C24v101Ev,
  (VTBL_ENTRY)&_ZN7S1290C24v102Ev,
};
extern VTBL_ENTRY _ZTI7S1290C2[];
extern  VTBL_ENTRY _ZTV7S1290C2[];
Class_Descriptor cd_S1290C2 = {  "S1290C2", // class name
  bases_S1290C2, 2,
  &(vtc_S1290C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI7S1290C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1290C2),97, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1290C1  : S1290C2 {
  char s1290c1f0[2];
  ::S1292C12 s1290c1f1;
  ::S1289C10_nt s1290c1f2;
  int s1290c1f3;
  ::S1292C12 s1290c1f4;
  ::S1292C12 s1290c1f5;
  ::S1289C10_nt s1290c1f6;
  int s1290c1f7;
  unsigned int s1290c1f8:1;
  unsigned int s1290c1f9:1;
  unsigned int s1290c1f10:1;
  unsigned int s1290c1f11:1;
  virtual  ~S1290C1(); // _ZN7S1290C1D1Ev
  virtual void  v1(); // _ZN7S1290C12v1Ev
  virtual void  v2(); // _ZN7S1290C12v2Ev
  virtual void  v3(); // _ZN7S1290C12v3Ev
  virtual void  v4(); // _ZN7S1290C12v4Ev
  virtual void  v5(); // _ZN7S1290C12v5Ev
  virtual void  v6(); // _ZN7S1290C12v6Ev
  virtual void  v7(); // _ZN7S1290C12v7Ev
  virtual void  v8(); // _ZN7S1290C12v8Ev
  virtual void  v9(); // _ZN7S1290C12v9Ev
  S1290C1(); // tgen
};
//SIG(1 S1290C1) C1{ BC2{ BC3{ BC4{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC6{ m}} vd v94 v95 v96 v97 v98 v99 v100 v101 v102} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fc[2] FC7{ BC8{ m Fc[4] FC9{ BC10{ BC11{ m Fp Fi[2]}}} Fi[2]} Fp} FC12{ BC8 Fp} Fi FC7 FC7 FC12 Fi Fi:1 Fi:1 Fi:1 Fi:1}


 S1290C1 ::~S1290C1(){ note_dtor("S1290C1", this);}
void  S1290C1 ::v1(){vfunc_called(this, "_ZN7S1290C12v1Ev");}
void  S1290C1 ::v2(){vfunc_called(this, "_ZN7S1290C12v2Ev");}
void  S1290C1 ::v3(){vfunc_called(this, "_ZN7S1290C12v3Ev");}
void  S1290C1 ::v4(){vfunc_called(this, "_ZN7S1290C12v4Ev");}
void  S1290C1 ::v5(){vfunc_called(this, "_ZN7S1290C12v5Ev");}
void  S1290C1 ::v6(){vfunc_called(this, "_ZN7S1290C12v6Ev");}
void  S1290C1 ::v7(){vfunc_called(this, "_ZN7S1290C12v7Ev");}
void  S1290C1 ::v8(){vfunc_called(this, "_ZN7S1290C12v8Ev");}
void  S1290C1 ::v9(){vfunc_called(this, "_ZN7S1290C12v9Ev");}
S1290C1 ::S1290C1(){ note_ctor("S1290C1", this);} // tgen

static void Test_S1290C1()
{
  extern Class_Descriptor cd_S1290C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(41,55)];
    init_test(&cd_S1290C1, buf);
    S1290C1 *dp, &lv = *(dp=new (buf) S1290C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(320,216), "sizeof(S1290C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1290C1)");
    check_base_class_offset(lv, (S1290C4*)(S1290C3*)(S1290C2*), 0, "S1290C1");
    check_base_class_offset(lv, (S1290C3*)(S1290C2*), 0, "S1290C1");
    check_base_class_offset(lv, (S1290C2*), 0, "S1290C1");
    check_field_offset(lv, s1290c1f0, ABISELECT(98,62), "S1290C1.s1290c1f0");
    check_field_offset(lv, s1290c1f1, ABISELECT(104,64), "S1290C1.s1290c1f1");
    check_field_offset(lv, s1290c1f2, ABISELECT(144,92), "S1290C1.s1290c1f2");
    check_field_offset(lv, s1290c1f3, ABISELECT(184,120), "S1290C1.s1290c1f3");
    check_field_offset(lv, s1290c1f4, ABISELECT(192,124), "S1290C1.s1290c1f4");
    check_field_offset(lv, s1290c1f5, ABISELECT(232,152), "S1290C1.s1290c1f5");
    check_field_offset(lv, s1290c1f6, ABISELECT(272,180), "S1290C1.s1290c1f6");
    check_field_offset(lv, s1290c1f7, ABISELECT(312,208), "S1290C1.s1290c1f7");
    set_bf_and_test(lv, s1290c1f8, ABISELECT(316,212), 0, 1, 1, "S1290C1");
    set_bf_and_test(lv, s1290c1f9, ABISELECT(316,212), 1, 1, 1, "S1290C1");
    set_bf_and_test(lv, s1290c1f10, ABISELECT(316,212), 2, 1, 1, "S1290C1");
    set_bf_and_test(lv, s1290c1f11, ABISELECT(316,212), 3, 1, 1, "S1290C1");
    test_class_info(&lv, &cd_S1290C1);
    dp->~S1290C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1290C1(Test_S1290C1, "S1290C1", ABISELECT(320,216));

#else // __cplusplus

extern void _ZN7S1290C1C1Ev();
extern void _ZN7S1290C1D1Ev();
Name_Map name_map_S1290C1[] = {
  NSPAIR(_ZN7S1290C1C1Ev),
  NSPAIR(_ZN7S1290C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1290C4;
extern VTBL_ENTRY _ZTI7S1290C4[];
extern  VTBL_ENTRY _ZTV7S1290C4[];
extern Class_Descriptor cd_S1290C3;
extern VTBL_ENTRY _ZTI7S1290C3[];
extern  VTBL_ENTRY _ZTV7S1290C3[];
extern Class_Descriptor cd_S1290C2;
extern VTBL_ENTRY _ZTI7S1290C2[];
extern  VTBL_ENTRY _ZTV7S1290C2[];
static Base_Class bases_S1290C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1290C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1290C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1290C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1290C1[];
extern void _ZN7S1290C1D1Ev();
extern void _ZN7S1290C1D0Ev();
extern void _ZN7S1290C43v10Ev();
extern void _ZN7S1290C43v11Ev();
extern void _ZN7S1290C43v12Ev();
extern void _ZN7S1290C43v13Ev();
extern void _ZN7S1290C43v14Ev();
extern void _ZN7S1290C43v15Ev();
extern void _ZN7S1290C43v16Ev();
extern void _ZN7S1290C43v17Ev();
extern void _ZN7S1290C43v18Ev();
extern void _ZN7S1290C43v19Ev();
extern void _ZN7S1290C43v20Ev();
extern void _ZN7S1290C43v21Ev();
extern void _ZN7S1290C43v22Ev();
extern void _ZN7S1290C43v23Ev();
extern void _ZN7S1290C43v24Ev();
extern void _ZN7S1290C43v25Ev();
extern void _ZN7S1290C43v26Ev();
extern void _ZN7S1290C43v27Ev();
extern void _ZN7S1290C43v28Ev();
extern void _ZN7S1290C43v29Ev();
extern void _ZN7S1290C43v30Ev();
extern void _ZN7S1290C43v31Ev();
extern void _ZN7S1290C43v32Ev();
extern void _ZN7S1290C43v33Ev();
extern void _ZN7S1290C43v34Ev();
extern void _ZN7S1290C43v35Ev();
extern void _ZN7S1290C43v36Ev();
extern void _ZN7S1290C43v37Ev();
extern void _ZN7S1290C43v38Ev();
extern void _ZN7S1290C43v39Ev();
extern void _ZN7S1290C43v40Ev();
extern void _ZN7S1290C43v41Ev();
extern void _ZN7S1290C43v42Ev();
extern void _ZN7S1290C43v43Ev();
extern void _ZN7S1290C43v44Ev();
extern void _ZN7S1290C43v45Ev();
extern void _ZN7S1290C43v46Ev();
extern void _ZN7S1290C43v47Ev();
extern void _ZN7S1290C43v48Ev();
extern void _ZN7S1290C43v49Ev();
extern void _ZN7S1290C43v50Ev();
extern void _ZN7S1290C43v51Ev();
extern void _ZN7S1290C43v52Ev();
extern void _ZN7S1290C43v53Ev();
extern void _ZN7S1290C43v54Ev();
extern void _ZN7S1290C43v55Ev();
extern void _ZN7S1290C43v56Ev();
extern void _ZN7S1290C43v57Ev();
extern void _ZN7S1290C43v58Ev();
extern void _ZN7S1290C43v59Ev();
extern void _ZN7S1290C43v60Ev();
extern void _ZN7S1290C43v61Ev();
extern void _ZN7S1290C43v62Ev();
extern void _ZN7S1290C43v63Ev();
extern void _ZN7S1290C43v64Ev();
extern void _ZN7S1290C43v65Ev();
extern void _ZN7S1290C43v66Ev();
extern void _ZN7S1290C43v67Ev();
extern void _ZN7S1290C43v68Ev();
extern void _ZN7S1290C43v69Ev();
extern void _ZN7S1290C43v70Ev();
extern void _ZN7S1290C43v71Ev();
extern void _ZN7S1290C43v72Ev();
extern void _ZN7S1290C43v73Ev();
extern void _ZN7S1290C33v74Ev();
extern void _ZN7S1290C33v75Ev();
extern void _ZN7S1290C33v76Ev();
extern void _ZN7S1290C33v77Ev();
extern void _ZN7S1290C33v78Ev();
extern void _ZN7S1290C33v79Ev();
extern void _ZN7S1290C33v80Ev();
extern void _ZN7S1290C33v81Ev();
extern void _ZN7S1290C33v82Ev();
extern void _ZN7S1290C33v83Ev();
extern void _ZN7S1290C33v84Ev();
extern void _ZN7S1290C33v85Ev();
extern void _ZN7S1290C33v86Ev();
extern void _ZN7S1290C33v87Ev();
extern void _ZN7S1290C33v88Ev();
extern void _ZN7S1290C33v89Ev();
extern void _ZN7S1290C33v90Ev();
extern void _ZN7S1290C33v91Ev();
extern void _ZN7S1290C33v92Ev();
extern void _ZN7S1290C33v93Ev();
extern void _ZN7S1290C23v94Ev();
extern void _ZN7S1290C23v95Ev();
extern void _ZN7S1290C23v96Ev();
extern void _ZN7S1290C23v97Ev();
extern void _ZN7S1290C23v98Ev();
extern void _ZN7S1290C23v99Ev();
extern void _ZN7S1290C24v100Ev();
extern void _ZN7S1290C24v101Ev();
extern void _ZN7S1290C24v102Ev();
extern void _ZN7S1290C12v1Ev();
extern void _ZN7S1290C12v2Ev();
extern void _ZN7S1290C12v3Ev();
extern void _ZN7S1290C12v4Ev();
extern void _ZN7S1290C12v5Ev();
extern void _ZN7S1290C12v6Ev();
extern void _ZN7S1290C12v7Ev();
extern void _ZN7S1290C12v8Ev();
extern void _ZN7S1290C12v9Ev();
static  VTBL_ENTRY vtc_S1290C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1290C1[0]),
  (VTBL_ENTRY)&_ZN7S1290C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1290C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1290C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1290C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1290C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1290C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1290C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1290C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1290C23v98Ev,
  (VTBL_ENTRY)&_ZN7S1290C23v99Ev,
  (VTBL_ENTRY)&_ZN7S1290C24v100Ev,
  (VTBL_ENTRY)&_ZN7S1290C24v101Ev,
  (VTBL_ENTRY)&_ZN7S1290C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1290C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1290C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1290C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1290C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1290C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1290C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1290C12v7Ev,
  (VTBL_ENTRY)&_ZN7S1290C12v8Ev,
  (VTBL_ENTRY)&_ZN7S1290C12v9Ev,
};
extern VTBL_ENTRY _ZTI7S1290C1[];
extern  VTBL_ENTRY _ZTV7S1290C1[];
Class_Descriptor cd_S1290C1 = {  "S1290C1", // class name
  bases_S1290C1, 3,
  &(vtc_S1290C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(320,216), // object size
  NSPAIRA(_ZTI7S1290C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1290C1),106, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1513C4  {
  int s1513c4f0;
  __tsi64 s1513c4f1;
  void *s1513c4f2[4];
  int s1513c4f3[2];
  void *s1513c4f4;
  ::S674C6_nt s1513c4f5;
  void *s1513c4f6[2];
  virtual  ~S1513C4(); // _ZN7S1513C4D1Ev
  virtual void  v6(); // _ZN7S1513C42v6Ev
  virtual void  v7(); // _ZN7S1513C42v7Ev
  virtual void  v8(); // _ZN7S1513C42v8Ev
  virtual void  v9(); // _ZN7S1513C42v9Ev
  virtual void  v10(); // _ZN7S1513C43v10Ev
  virtual void  v11(); // _ZN7S1513C43v11Ev
  virtual void  v12(); // _ZN7S1513C43v12Ev
  virtual void  v13(); // _ZN7S1513C43v13Ev
  virtual void  v14(); // _ZN7S1513C43v14Ev
  virtual void  v15(); // _ZN7S1513C43v15Ev
  virtual void  v16(); // _ZN7S1513C43v16Ev
  virtual void  v17(); // _ZN7S1513C43v17Ev
  virtual void  v18(); // _ZN7S1513C43v18Ev
  virtual void  v19(); // _ZN7S1513C43v19Ev
  virtual void  v20(); // _ZN7S1513C43v20Ev
  virtual void  v21(); // _ZN7S1513C43v21Ev
  virtual void  v22(); // _ZN7S1513C43v22Ev
  virtual void  v23(); // _ZN7S1513C43v23Ev
  virtual void  v24(); // _ZN7S1513C43v24Ev
  virtual void  v25(); // _ZN7S1513C43v25Ev
  virtual void  v26(); // _ZN7S1513C43v26Ev
  virtual void  v27(); // _ZN7S1513C43v27Ev
  virtual void  v28(); // _ZN7S1513C43v28Ev
  virtual void  v29(); // _ZN7S1513C43v29Ev
  virtual void  v30(); // _ZN7S1513C43v30Ev
  virtual void  v31(); // _ZN7S1513C43v31Ev
  virtual void  v32(); // _ZN7S1513C43v32Ev
  virtual void  v33(); // _ZN7S1513C43v33Ev
  virtual void  v34(); // _ZN7S1513C43v34Ev
  virtual void  v35(); // _ZN7S1513C43v35Ev
  virtual void  v36(); // _ZN7S1513C43v36Ev
  virtual void  v37(); // _ZN7S1513C43v37Ev
  virtual void  v38(); // _ZN7S1513C43v38Ev
  virtual void  v39(); // _ZN7S1513C43v39Ev
  virtual void  v40(); // _ZN7S1513C43v40Ev
  virtual void  v41(); // _ZN7S1513C43v41Ev
  virtual void  v42(); // _ZN7S1513C43v42Ev
  virtual void  v43(); // _ZN7S1513C43v43Ev
  virtual void  v44(); // _ZN7S1513C43v44Ev
  virtual void  v45(); // _ZN7S1513C43v45Ev
  virtual void  v46(); // _ZN7S1513C43v46Ev
  virtual void  v47(); // _ZN7S1513C43v47Ev
  virtual void  v48(); // _ZN7S1513C43v48Ev
  virtual void  v49(); // _ZN7S1513C43v49Ev
  virtual void  v50(); // _ZN7S1513C43v50Ev
  virtual void  v51(); // _ZN7S1513C43v51Ev
  virtual void  v52(); // _ZN7S1513C43v52Ev
  virtual void  v53(); // _ZN7S1513C43v53Ev
  virtual void  v54(); // _ZN7S1513C43v54Ev
  virtual void  v55(); // _ZN7S1513C43v55Ev
  virtual void  v56(); // _ZN7S1513C43v56Ev
  virtual void  v57(); // _ZN7S1513C43v57Ev
  virtual void  v58(); // _ZN7S1513C43v58Ev
  virtual void  v59(); // _ZN7S1513C43v59Ev
  virtual void  v60(); // _ZN7S1513C43v60Ev
  virtual void  v61(); // _ZN7S1513C43v61Ev
  virtual void  v62(); // _ZN7S1513C43v62Ev
  virtual void  v63(); // _ZN7S1513C43v63Ev
  virtual void  v64(); // _ZN7S1513C43v64Ev
  virtual void  v65(); // _ZN7S1513C43v65Ev
  virtual void  v66(); // _ZN7S1513C43v66Ev
  virtual void  v67(); // _ZN7S1513C43v67Ev
  virtual void  v68(); // _ZN7S1513C43v68Ev
  virtual void  v69(); // _ZN7S1513C43v69Ev
  S1513C4(); // tgen
};
//SIG(-1 S1513C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1513C4 ::~S1513C4(){ note_dtor("S1513C4", this);}
void  S1513C4 ::v6(){vfunc_called(this, "_ZN7S1513C42v6Ev");}
void  S1513C4 ::v7(){vfunc_called(this, "_ZN7S1513C42v7Ev");}
void  S1513C4 ::v8(){vfunc_called(this, "_ZN7S1513C42v8Ev");}
void  S1513C4 ::v9(){vfunc_called(this, "_ZN7S1513C42v9Ev");}
void  S1513C4 ::v10(){vfunc_called(this, "_ZN7S1513C43v10Ev");}
void  S1513C4 ::v11(){vfunc_called(this, "_ZN7S1513C43v11Ev");}
void  S1513C4 ::v12(){vfunc_called(this, "_ZN7S1513C43v12Ev");}
void  S1513C4 ::v13(){vfunc_called(this, "_ZN7S1513C43v13Ev");}
void  S1513C4 ::v14(){vfunc_called(this, "_ZN7S1513C43v14Ev");}
void  S1513C4 ::v15(){vfunc_called(this, "_ZN7S1513C43v15Ev");}
void  S1513C4 ::v16(){vfunc_called(this, "_ZN7S1513C43v16Ev");}
void  S1513C4 ::v17(){vfunc_called(this, "_ZN7S1513C43v17Ev");}
void  S1513C4 ::v18(){vfunc_called(this, "_ZN7S1513C43v18Ev");}
void  S1513C4 ::v19(){vfunc_called(this, "_ZN7S1513C43v19Ev");}
void  S1513C4 ::v20(){vfunc_called(this, "_ZN7S1513C43v20Ev");}
void  S1513C4 ::v21(){vfunc_called(this, "_ZN7S1513C43v21Ev");}
void  S1513C4 ::v22(){vfunc_called(this, "_ZN7S1513C43v22Ev");}
void  S1513C4 ::v23(){vfunc_called(this, "_ZN7S1513C43v23Ev");}
void  S1513C4 ::v24(){vfunc_called(this, "_ZN7S1513C43v24Ev");}
void  S1513C4 ::v25(){vfunc_called(this, "_ZN7S1513C43v25Ev");}
void  S1513C4 ::v26(){vfunc_called(this, "_ZN7S1513C43v26Ev");}
void  S1513C4 ::v27(){vfunc_called(this, "_ZN7S1513C43v27Ev");}
void  S1513C4 ::v28(){vfunc_called(this, "_ZN7S1513C43v28Ev");}
void  S1513C4 ::v29(){vfunc_called(this, "_ZN7S1513C43v29Ev");}
void  S1513C4 ::v30(){vfunc_called(this, "_ZN7S1513C43v30Ev");}
void  S1513C4 ::v31(){vfunc_called(this, "_ZN7S1513C43v31Ev");}
void  S1513C4 ::v32(){vfunc_called(this, "_ZN7S1513C43v32Ev");}
void  S1513C4 ::v33(){vfunc_called(this, "_ZN7S1513C43v33Ev");}
void  S1513C4 ::v34(){vfunc_called(this, "_ZN7S1513C43v34Ev");}
void  S1513C4 ::v35(){vfunc_called(this, "_ZN7S1513C43v35Ev");}
void  S1513C4 ::v36(){vfunc_called(this, "_ZN7S1513C43v36Ev");}
void  S1513C4 ::v37(){vfunc_called(this, "_ZN7S1513C43v37Ev");}
void  S1513C4 ::v38(){vfunc_called(this, "_ZN7S1513C43v38Ev");}
void  S1513C4 ::v39(){vfunc_called(this, "_ZN7S1513C43v39Ev");}
void  S1513C4 ::v40(){vfunc_called(this, "_ZN7S1513C43v40Ev");}
void  S1513C4 ::v41(){vfunc_called(this, "_ZN7S1513C43v41Ev");}
void  S1513C4 ::v42(){vfunc_called(this, "_ZN7S1513C43v42Ev");}
void  S1513C4 ::v43(){vfunc_called(this, "_ZN7S1513C43v43Ev");}
void  S1513C4 ::v44(){vfunc_called(this, "_ZN7S1513C43v44Ev");}
void  S1513C4 ::v45(){vfunc_called(this, "_ZN7S1513C43v45Ev");}
void  S1513C4 ::v46(){vfunc_called(this, "_ZN7S1513C43v46Ev");}
void  S1513C4 ::v47(){vfunc_called(this, "_ZN7S1513C43v47Ev");}
void  S1513C4 ::v48(){vfunc_called(this, "_ZN7S1513C43v48Ev");}
void  S1513C4 ::v49(){vfunc_called(this, "_ZN7S1513C43v49Ev");}
void  S1513C4 ::v50(){vfunc_called(this, "_ZN7S1513C43v50Ev");}
void  S1513C4 ::v51(){vfunc_called(this, "_ZN7S1513C43v51Ev");}
void  S1513C4 ::v52(){vfunc_called(this, "_ZN7S1513C43v52Ev");}
void  S1513C4 ::v53(){vfunc_called(this, "_ZN7S1513C43v53Ev");}
void  S1513C4 ::v54(){vfunc_called(this, "_ZN7S1513C43v54Ev");}
void  S1513C4 ::v55(){vfunc_called(this, "_ZN7S1513C43v55Ev");}
void  S1513C4 ::v56(){vfunc_called(this, "_ZN7S1513C43v56Ev");}
void  S1513C4 ::v57(){vfunc_called(this, "_ZN7S1513C43v57Ev");}
void  S1513C4 ::v58(){vfunc_called(this, "_ZN7S1513C43v58Ev");}
void  S1513C4 ::v59(){vfunc_called(this, "_ZN7S1513C43v59Ev");}
void  S1513C4 ::v60(){vfunc_called(this, "_ZN7S1513C43v60Ev");}
void  S1513C4 ::v61(){vfunc_called(this, "_ZN7S1513C43v61Ev");}
void  S1513C4 ::v62(){vfunc_called(this, "_ZN7S1513C43v62Ev");}
void  S1513C4 ::v63(){vfunc_called(this, "_ZN7S1513C43v63Ev");}
void  S1513C4 ::v64(){vfunc_called(this, "_ZN7S1513C43v64Ev");}
void  S1513C4 ::v65(){vfunc_called(this, "_ZN7S1513C43v65Ev");}
void  S1513C4 ::v66(){vfunc_called(this, "_ZN7S1513C43v66Ev");}
void  S1513C4 ::v67(){vfunc_called(this, "_ZN7S1513C43v67Ev");}
void  S1513C4 ::v68(){vfunc_called(this, "_ZN7S1513C43v68Ev");}
void  S1513C4 ::v69(){vfunc_called(this, "_ZN7S1513C43v69Ev");}
S1513C4 ::S1513C4(){ note_ctor("S1513C4", this);} // tgen

static void Test_S1513C4()
{
  extern Class_Descriptor cd_S1513C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1513C4, buf);
    S1513C4 *dp, &lv = *(dp=new (buf) S1513C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1513C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1513C4)");
    check_field_offset(lv, s1513c4f0, ABISELECT(8,4), "S1513C4.s1513c4f0");
    check_field_offset(lv, s1513c4f1, ABISELECT(16,8), "S1513C4.s1513c4f1");
    check_field_offset(lv, s1513c4f2, ABISELECT(24,16), "S1513C4.s1513c4f2");
    check_field_offset(lv, s1513c4f3, ABISELECT(56,32), "S1513C4.s1513c4f3");
    check_field_offset(lv, s1513c4f4, ABISELECT(64,40), "S1513C4.s1513c4f4");
    check_field_offset(lv, s1513c4f5, ABISELECT(72,44), "S1513C4.s1513c4f5");
    check_field_offset(lv, s1513c4f6, ABISELECT(80,52), "S1513C4.s1513c4f6");
    test_class_info(&lv, &cd_S1513C4);
    dp->~S1513C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1513C4(Test_S1513C4, "S1513C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1513C4C1Ev();
extern void _ZN7S1513C4D1Ev();
Name_Map name_map_S1513C4[] = {
  NSPAIR(_ZN7S1513C4C1Ev),
  NSPAIR(_ZN7S1513C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1513C4[];
extern void _ZN7S1513C4D1Ev();
extern void _ZN7S1513C4D0Ev();
extern void _ZN7S1513C42v6Ev();
extern void _ZN7S1513C42v7Ev();
extern void _ZN7S1513C42v8Ev();
extern void _ZN7S1513C42v9Ev();
extern void _ZN7S1513C43v10Ev();
extern void _ZN7S1513C43v11Ev();
extern void _ZN7S1513C43v12Ev();
extern void _ZN7S1513C43v13Ev();
extern void _ZN7S1513C43v14Ev();
extern void _ZN7S1513C43v15Ev();
extern void _ZN7S1513C43v16Ev();
extern void _ZN7S1513C43v17Ev();
extern void _ZN7S1513C43v18Ev();
extern void _ZN7S1513C43v19Ev();
extern void _ZN7S1513C43v20Ev();
extern void _ZN7S1513C43v21Ev();
extern void _ZN7S1513C43v22Ev();
extern void _ZN7S1513C43v23Ev();
extern void _ZN7S1513C43v24Ev();
extern void _ZN7S1513C43v25Ev();
extern void _ZN7S1513C43v26Ev();
extern void _ZN7S1513C43v27Ev();
extern void _ZN7S1513C43v28Ev();
extern void _ZN7S1513C43v29Ev();
extern void _ZN7S1513C43v30Ev();
extern void _ZN7S1513C43v31Ev();
extern void _ZN7S1513C43v32Ev();
extern void _ZN7S1513C43v33Ev();
extern void _ZN7S1513C43v34Ev();
extern void _ZN7S1513C43v35Ev();
extern void _ZN7S1513C43v36Ev();
extern void _ZN7S1513C43v37Ev();
extern void _ZN7S1513C43v38Ev();
extern void _ZN7S1513C43v39Ev();
extern void _ZN7S1513C43v40Ev();
extern void _ZN7S1513C43v41Ev();
extern void _ZN7S1513C43v42Ev();
extern void _ZN7S1513C43v43Ev();
extern void _ZN7S1513C43v44Ev();
extern void _ZN7S1513C43v45Ev();
extern void _ZN7S1513C43v46Ev();
extern void _ZN7S1513C43v47Ev();
extern void _ZN7S1513C43v48Ev();
extern void _ZN7S1513C43v49Ev();
extern void _ZN7S1513C43v50Ev();
extern void _ZN7S1513C43v51Ev();
extern void _ZN7S1513C43v52Ev();
extern void _ZN7S1513C43v53Ev();
extern void _ZN7S1513C43v54Ev();
extern void _ZN7S1513C43v55Ev();
extern void _ZN7S1513C43v56Ev();
extern void _ZN7S1513C43v57Ev();
extern void _ZN7S1513C43v58Ev();
extern void _ZN7S1513C43v59Ev();
extern void _ZN7S1513C43v60Ev();
extern void _ZN7S1513C43v61Ev();
extern void _ZN7S1513C43v62Ev();
extern void _ZN7S1513C43v63Ev();
extern void _ZN7S1513C43v64Ev();
extern void _ZN7S1513C43v65Ev();
extern void _ZN7S1513C43v66Ev();
extern void _ZN7S1513C43v67Ev();
extern void _ZN7S1513C43v68Ev();
extern void _ZN7S1513C43v69Ev();
static  VTBL_ENTRY vtc_S1513C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1513C4[0]),
  (VTBL_ENTRY)&_ZN7S1513C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1513C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1513C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1513C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1513C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1513C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v69Ev,
};
extern VTBL_ENTRY _ZTI7S1513C4[];
extern  VTBL_ENTRY _ZTV7S1513C4[];
Class_Descriptor cd_S1513C4 = {  "S1513C4", // class name
  0,0,//no base classes
  &(vtc_S1513C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1513C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1513C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1513C3  : S1513C4 {
  unsigned int s1513c3f0:1;
  unsigned int s1513c3f1:1;
  unsigned int s1513c3f2:1;
  unsigned int s1513c3f3:1;
  unsigned int s1513c3f4:1;
  unsigned int s1513c3f5:1;
  unsigned int s1513c3f6:1;
  ::S3625C32 s1513c3f7;
  virtual  ~S1513C3(); // _ZN7S1513C3D1Ev
  virtual void  v70(); // _ZN7S1513C33v70Ev
  virtual void  v71(); // _ZN7S1513C33v71Ev
  virtual void  v72(); // _ZN7S1513C33v72Ev
  virtual void  v73(); // _ZN7S1513C33v73Ev
  virtual void  v74(); // _ZN7S1513C33v74Ev
  virtual void  v75(); // _ZN7S1513C33v75Ev
  virtual void  v76(); // _ZN7S1513C33v76Ev
  virtual void  v77(); // _ZN7S1513C33v77Ev
  virtual void  v78(); // _ZN7S1513C33v78Ev
  virtual void  v79(); // _ZN7S1513C33v79Ev
  virtual void  v80(); // _ZN7S1513C33v80Ev
  virtual void  v81(); // _ZN7S1513C33v81Ev
  virtual void  v82(); // _ZN7S1513C33v82Ev
  virtual void  v83(); // _ZN7S1513C33v83Ev
  virtual void  v84(); // _ZN7S1513C33v84Ev
  virtual void  v85(); // _ZN7S1513C33v85Ev
  virtual void  v86(); // _ZN7S1513C33v86Ev
  virtual void  v87(); // _ZN7S1513C33v87Ev
  virtual void  v88(); // _ZN7S1513C33v88Ev
  virtual void  v89(); // _ZN7S1513C33v89Ev
  S1513C3(); // tgen
};
//SIG(-1 S1513C3) C1{ BC2{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC4{ m}}


 S1513C3 ::~S1513C3(){ note_dtor("S1513C3", this);}
void  S1513C3 ::v70(){vfunc_called(this, "_ZN7S1513C33v70Ev");}
void  S1513C3 ::v71(){vfunc_called(this, "_ZN7S1513C33v71Ev");}
void  S1513C3 ::v72(){vfunc_called(this, "_ZN7S1513C33v72Ev");}
void  S1513C3 ::v73(){vfunc_called(this, "_ZN7S1513C33v73Ev");}
void  S1513C3 ::v74(){vfunc_called(this, "_ZN7S1513C33v74Ev");}
void  S1513C3 ::v75(){vfunc_called(this, "_ZN7S1513C33v75Ev");}
void  S1513C3 ::v76(){vfunc_called(this, "_ZN7S1513C33v76Ev");}
void  S1513C3 ::v77(){vfunc_called(this, "_ZN7S1513C33v77Ev");}
void  S1513C3 ::v78(){vfunc_called(this, "_ZN7S1513C33v78Ev");}
void  S1513C3 ::v79(){vfunc_called(this, "_ZN7S1513C33v79Ev");}
void  S1513C3 ::v80(){vfunc_called(this, "_ZN7S1513C33v80Ev");}
void  S1513C3 ::v81(){vfunc_called(this, "_ZN7S1513C33v81Ev");}
void  S1513C3 ::v82(){vfunc_called(this, "_ZN7S1513C33v82Ev");}
void  S1513C3 ::v83(){vfunc_called(this, "_ZN7S1513C33v83Ev");}
void  S1513C3 ::v84(){vfunc_called(this, "_ZN7S1513C33v84Ev");}
void  S1513C3 ::v85(){vfunc_called(this, "_ZN7S1513C33v85Ev");}
void  S1513C3 ::v86(){vfunc_called(this, "_ZN7S1513C33v86Ev");}
void  S1513C3 ::v87(){vfunc_called(this, "_ZN7S1513C33v87Ev");}
void  S1513C3 ::v88(){vfunc_called(this, "_ZN7S1513C33v88Ev");}
void  S1513C3 ::v89(){vfunc_called(this, "_ZN7S1513C33v89Ev");}
S1513C3 ::S1513C3(){ note_ctor("S1513C3", this);} // tgen

static void Test_S1513C3()
{
  extern Class_Descriptor cd_S1513C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S1513C3, buf);
    S1513C3 *dp, &lv = *(dp=new (buf) S1513C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S1513C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1513C3)");
    check_base_class_offset(lv, (S1513C4*), 0, "S1513C3");
    set_bf_and_test(lv, s1513c3f0, ABISELECT(96,60), 0, 1, 1, "S1513C3");
    set_bf_and_test(lv, s1513c3f1, ABISELECT(96,60), 1, 1, 1, "S1513C3");
    set_bf_and_test(lv, s1513c3f2, ABISELECT(96,60), 2, 1, 1, "S1513C3");
    set_bf_and_test(lv, s1513c3f3, ABISELECT(96,60), 3, 1, 1, "S1513C3");
    set_bf_and_test(lv, s1513c3f4, ABISELECT(96,60), 4, 1, 1, "S1513C3");
    set_bf_and_test(lv, s1513c3f5, ABISELECT(96,60), 5, 1, 1, "S1513C3");
    set_bf_and_test(lv, s1513c3f6, ABISELECT(96,60), 6, 1, 1, "S1513C3");
    check_field_offset(lv, s1513c3f7, ABISELECT(97,61), "S1513C3.s1513c3f7");
    test_class_info(&lv, &cd_S1513C3);
    dp->~S1513C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1513C3(Test_S1513C3, "S1513C3", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN7S1513C3C1Ev();
extern void _ZN7S1513C3D1Ev();
Name_Map name_map_S1513C3[] = {
  NSPAIR(_ZN7S1513C3C1Ev),
  NSPAIR(_ZN7S1513C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1513C4;
extern VTBL_ENTRY _ZTI7S1513C4[];
extern  VTBL_ENTRY _ZTV7S1513C4[];
static Base_Class bases_S1513C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1513C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1513C3[];
extern void _ZN7S1513C3D1Ev();
extern void _ZN7S1513C3D0Ev();
extern void _ZN7S1513C42v6Ev();
extern void _ZN7S1513C42v7Ev();
extern void _ZN7S1513C42v8Ev();
extern void _ZN7S1513C42v9Ev();
extern void _ZN7S1513C43v10Ev();
extern void _ZN7S1513C43v11Ev();
extern void _ZN7S1513C43v12Ev();
extern void _ZN7S1513C43v13Ev();
extern void _ZN7S1513C43v14Ev();
extern void _ZN7S1513C43v15Ev();
extern void _ZN7S1513C43v16Ev();
extern void _ZN7S1513C43v17Ev();
extern void _ZN7S1513C43v18Ev();
extern void _ZN7S1513C43v19Ev();
extern void _ZN7S1513C43v20Ev();
extern void _ZN7S1513C43v21Ev();
extern void _ZN7S1513C43v22Ev();
extern void _ZN7S1513C43v23Ev();
extern void _ZN7S1513C43v24Ev();
extern void _ZN7S1513C43v25Ev();
extern void _ZN7S1513C43v26Ev();
extern void _ZN7S1513C43v27Ev();
extern void _ZN7S1513C43v28Ev();
extern void _ZN7S1513C43v29Ev();
extern void _ZN7S1513C43v30Ev();
extern void _ZN7S1513C43v31Ev();
extern void _ZN7S1513C43v32Ev();
extern void _ZN7S1513C43v33Ev();
extern void _ZN7S1513C43v34Ev();
extern void _ZN7S1513C43v35Ev();
extern void _ZN7S1513C43v36Ev();
extern void _ZN7S1513C43v37Ev();
extern void _ZN7S1513C43v38Ev();
extern void _ZN7S1513C43v39Ev();
extern void _ZN7S1513C43v40Ev();
extern void _ZN7S1513C43v41Ev();
extern void _ZN7S1513C43v42Ev();
extern void _ZN7S1513C43v43Ev();
extern void _ZN7S1513C43v44Ev();
extern void _ZN7S1513C43v45Ev();
extern void _ZN7S1513C43v46Ev();
extern void _ZN7S1513C43v47Ev();
extern void _ZN7S1513C43v48Ev();
extern void _ZN7S1513C43v49Ev();
extern void _ZN7S1513C43v50Ev();
extern void _ZN7S1513C43v51Ev();
extern void _ZN7S1513C43v52Ev();
extern void _ZN7S1513C43v53Ev();
extern void _ZN7S1513C43v54Ev();
extern void _ZN7S1513C43v55Ev();
extern void _ZN7S1513C43v56Ev();
extern void _ZN7S1513C43v57Ev();
extern void _ZN7S1513C43v58Ev();
extern void _ZN7S1513C43v59Ev();
extern void _ZN7S1513C43v60Ev();
extern void _ZN7S1513C43v61Ev();
extern void _ZN7S1513C43v62Ev();
extern void _ZN7S1513C43v63Ev();
extern void _ZN7S1513C43v64Ev();
extern void _ZN7S1513C43v65Ev();
extern void _ZN7S1513C43v66Ev();
extern void _ZN7S1513C43v67Ev();
extern void _ZN7S1513C43v68Ev();
extern void _ZN7S1513C43v69Ev();
extern void _ZN7S1513C33v70Ev();
extern void _ZN7S1513C33v71Ev();
extern void _ZN7S1513C33v72Ev();
extern void _ZN7S1513C33v73Ev();
extern void _ZN7S1513C33v74Ev();
extern void _ZN7S1513C33v75Ev();
extern void _ZN7S1513C33v76Ev();
extern void _ZN7S1513C33v77Ev();
extern void _ZN7S1513C33v78Ev();
extern void _ZN7S1513C33v79Ev();
extern void _ZN7S1513C33v80Ev();
extern void _ZN7S1513C33v81Ev();
extern void _ZN7S1513C33v82Ev();
extern void _ZN7S1513C33v83Ev();
extern void _ZN7S1513C33v84Ev();
extern void _ZN7S1513C33v85Ev();
extern void _ZN7S1513C33v86Ev();
extern void _ZN7S1513C33v87Ev();
extern void _ZN7S1513C33v88Ev();
extern void _ZN7S1513C33v89Ev();
static  VTBL_ENTRY vtc_S1513C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1513C3[0]),
  (VTBL_ENTRY)&_ZN7S1513C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1513C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1513C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1513C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1513C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1513C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v89Ev,
};
extern VTBL_ENTRY _ZTI7S1513C3[];
extern  VTBL_ENTRY _ZTV7S1513C3[];
Class_Descriptor cd_S1513C3 = {  "S1513C3", // class name
  bases_S1513C3, 1,
  &(vtc_S1513C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI7S1513C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1513C3),88, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1513C2  : S1513C3 {
  ::S674C42 s1513c2f0;
  virtual  ~S1513C2(); // _ZN7S1513C2D1Ev
  virtual void  v90(); // _ZN7S1513C23v90Ev
  virtual void  v91(); // _ZN7S1513C23v91Ev
  virtual void  v92(); // _ZN7S1513C23v92Ev
  virtual void  v93(); // _ZN7S1513C23v93Ev
  S1513C2(); // tgen
};
//SIG(-1 S1513C2) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC5{ m}} vd v1 v2 v3 v4 FC6{ BC7{ BC8{ m Fp Fi[2]}}}}


 S1513C2 ::~S1513C2(){ note_dtor("S1513C2", this);}
void  S1513C2 ::v90(){vfunc_called(this, "_ZN7S1513C23v90Ev");}
void  S1513C2 ::v91(){vfunc_called(this, "_ZN7S1513C23v91Ev");}
void  S1513C2 ::v92(){vfunc_called(this, "_ZN7S1513C23v92Ev");}
void  S1513C2 ::v93(){vfunc_called(this, "_ZN7S1513C23v93Ev");}
S1513C2 ::S1513C2(){ note_ctor("S1513C2", this);} // tgen

static void Test_S1513C2()
{
  extern Class_Descriptor cd_S1513C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(16,20)];
    init_test(&cd_S1513C2, buf);
    S1513C2 *dp, &lv = *(dp=new (buf) S1513C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(120,76), "sizeof(S1513C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1513C2)");
    check_base_class_offset(lv, (S1513C4*)(S1513C3*), 0, "S1513C2");
    check_base_class_offset(lv, (S1513C3*), 0, "S1513C2");
    check_field_offset(lv, s1513c2f0, ABISELECT(104,64), "S1513C2.s1513c2f0");
    test_class_info(&lv, &cd_S1513C2);
    dp->~S1513C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1513C2(Test_S1513C2, "S1513C2", ABISELECT(120,76));

#else // __cplusplus

extern void _ZN7S1513C2C1Ev();
extern void _ZN7S1513C2D1Ev();
Name_Map name_map_S1513C2[] = {
  NSPAIR(_ZN7S1513C2C1Ev),
  NSPAIR(_ZN7S1513C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1513C4;
extern VTBL_ENTRY _ZTI7S1513C4[];
extern  VTBL_ENTRY _ZTV7S1513C4[];
extern Class_Descriptor cd_S1513C3;
extern VTBL_ENTRY _ZTI7S1513C3[];
extern  VTBL_ENTRY _ZTV7S1513C3[];
static Base_Class bases_S1513C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1513C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1513C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1513C2[];
extern void _ZN7S1513C2D1Ev();
extern void _ZN7S1513C2D0Ev();
extern void _ZN7S1513C42v6Ev();
extern void _ZN7S1513C42v7Ev();
extern void _ZN7S1513C42v8Ev();
extern void _ZN7S1513C42v9Ev();
extern void _ZN7S1513C43v10Ev();
extern void _ZN7S1513C43v11Ev();
extern void _ZN7S1513C43v12Ev();
extern void _ZN7S1513C43v13Ev();
extern void _ZN7S1513C43v14Ev();
extern void _ZN7S1513C43v15Ev();
extern void _ZN7S1513C43v16Ev();
extern void _ZN7S1513C43v17Ev();
extern void _ZN7S1513C43v18Ev();
extern void _ZN7S1513C43v19Ev();
extern void _ZN7S1513C43v20Ev();
extern void _ZN7S1513C43v21Ev();
extern void _ZN7S1513C43v22Ev();
extern void _ZN7S1513C43v23Ev();
extern void _ZN7S1513C43v24Ev();
extern void _ZN7S1513C43v25Ev();
extern void _ZN7S1513C43v26Ev();
extern void _ZN7S1513C43v27Ev();
extern void _ZN7S1513C43v28Ev();
extern void _ZN7S1513C43v29Ev();
extern void _ZN7S1513C43v30Ev();
extern void _ZN7S1513C43v31Ev();
extern void _ZN7S1513C43v32Ev();
extern void _ZN7S1513C43v33Ev();
extern void _ZN7S1513C43v34Ev();
extern void _ZN7S1513C43v35Ev();
extern void _ZN7S1513C43v36Ev();
extern void _ZN7S1513C43v37Ev();
extern void _ZN7S1513C43v38Ev();
extern void _ZN7S1513C43v39Ev();
extern void _ZN7S1513C43v40Ev();
extern void _ZN7S1513C43v41Ev();
extern void _ZN7S1513C43v42Ev();
extern void _ZN7S1513C43v43Ev();
extern void _ZN7S1513C43v44Ev();
extern void _ZN7S1513C43v45Ev();
extern void _ZN7S1513C43v46Ev();
extern void _ZN7S1513C43v47Ev();
extern void _ZN7S1513C43v48Ev();
extern void _ZN7S1513C43v49Ev();
extern void _ZN7S1513C43v50Ev();
extern void _ZN7S1513C43v51Ev();
extern void _ZN7S1513C43v52Ev();
extern void _ZN7S1513C43v53Ev();
extern void _ZN7S1513C43v54Ev();
extern void _ZN7S1513C43v55Ev();
extern void _ZN7S1513C43v56Ev();
extern void _ZN7S1513C43v57Ev();
extern void _ZN7S1513C43v58Ev();
extern void _ZN7S1513C43v59Ev();
extern void _ZN7S1513C43v60Ev();
extern void _ZN7S1513C43v61Ev();
extern void _ZN7S1513C43v62Ev();
extern void _ZN7S1513C43v63Ev();
extern void _ZN7S1513C43v64Ev();
extern void _ZN7S1513C43v65Ev();
extern void _ZN7S1513C43v66Ev();
extern void _ZN7S1513C43v67Ev();
extern void _ZN7S1513C43v68Ev();
extern void _ZN7S1513C43v69Ev();
extern void _ZN7S1513C33v70Ev();
extern void _ZN7S1513C33v71Ev();
extern void _ZN7S1513C33v72Ev();
extern void _ZN7S1513C33v73Ev();
extern void _ZN7S1513C33v74Ev();
extern void _ZN7S1513C33v75Ev();
extern void _ZN7S1513C33v76Ev();
extern void _ZN7S1513C33v77Ev();
extern void _ZN7S1513C33v78Ev();
extern void _ZN7S1513C33v79Ev();
extern void _ZN7S1513C33v80Ev();
extern void _ZN7S1513C33v81Ev();
extern void _ZN7S1513C33v82Ev();
extern void _ZN7S1513C33v83Ev();
extern void _ZN7S1513C33v84Ev();
extern void _ZN7S1513C33v85Ev();
extern void _ZN7S1513C33v86Ev();
extern void _ZN7S1513C33v87Ev();
extern void _ZN7S1513C33v88Ev();
extern void _ZN7S1513C33v89Ev();
extern void _ZN7S1513C23v90Ev();
extern void _ZN7S1513C23v91Ev();
extern void _ZN7S1513C23v92Ev();
extern void _ZN7S1513C23v93Ev();
static  VTBL_ENTRY vtc_S1513C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1513C2[0]),
  (VTBL_ENTRY)&_ZN7S1513C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1513C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1513C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1513C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1513C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1513C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1513C23v90Ev,
  (VTBL_ENTRY)&_ZN7S1513C23v91Ev,
  (VTBL_ENTRY)&_ZN7S1513C23v92Ev,
  (VTBL_ENTRY)&_ZN7S1513C23v93Ev,
};
extern VTBL_ENTRY _ZTI7S1513C2[];
extern  VTBL_ENTRY _ZTV7S1513C2[];
Class_Descriptor cd_S1513C2 = {  "S1513C2", // class name
  bases_S1513C2, 2,
  &(vtc_S1513C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(120,76), // object size
  NSPAIRA(_ZTI7S1513C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1513C2),92, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1513C1  : S1513C2 {
  ::S1292C12 s1513c1f0;
  ::S1289C10_nt s1513c1f1;
  ::S1289C10_nt s1513c1f2;
  ::S1292C12 s1513c1f3;
  ::S1289C10_nt s1513c1f4;
  ::S1292C12 s1513c1f5;
  ::S1289C10_nt s1513c1f6;
  ::S1292C12 s1513c1f7;
  ::S1289C10_nt s1513c1f8;
  unsigned int s1513c1f9:1;
  unsigned int s1513c1f10:1;
  unsigned int s1513c1f11:1;
  ::S1292C12 s1513c1f12;
  virtual  ~S1513C1(); // _ZN7S1513C1D1Ev
  virtual void  v1(); // _ZN7S1513C12v1Ev
  virtual void  v2(); // _ZN7S1513C12v2Ev
  virtual void  v3(); // _ZN7S1513C12v3Ev
  virtual void  v4(); // _ZN7S1513C12v4Ev
  virtual void  v5(); // _ZN7S1513C12v5Ev
  S1513C1(); // tgen
};
//SIG(1 S1513C1) C1{ BC2{ BC3{ BC4{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC6{ m}} vd v90 v91 v92 v93 FC7{ BC8{ BC9{ m Fp Fi[2]}}}} vd v1 v2 v3 v4 v5 FC10{ BC11{ m Fc[4] FC12{ BC13{ BC9}} Fi[2]} Fp} FC14{ BC11 Fp} FC14 FC10 FC14 FC10 FC14 FC10 FC14 Fi:1 Fi:1 Fi:1 FC10}


 S1513C1 ::~S1513C1(){ note_dtor("S1513C1", this);}
void  S1513C1 ::v1(){vfunc_called(this, "_ZN7S1513C12v1Ev");}
void  S1513C1 ::v2(){vfunc_called(this, "_ZN7S1513C12v2Ev");}
void  S1513C1 ::v3(){vfunc_called(this, "_ZN7S1513C12v3Ev");}
void  S1513C1 ::v4(){vfunc_called(this, "_ZN7S1513C12v4Ev");}
void  S1513C1 ::v5(){vfunc_called(this, "_ZN7S1513C12v5Ev");}
S1513C1 ::S1513C1(){ note_ctor("S1513C1", this);} // tgen

static void Test_S1513C1()
{
  extern Class_Descriptor cd_S1513C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(67,91)];
    init_test(&cd_S1513C1, buf);
    S1513C1 *dp, &lv = *(dp=new (buf) S1513C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(528,360), "sizeof(S1513C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1513C1)");
    check_base_class_offset(lv, (S1513C4*)(S1513C3*)(S1513C2*), 0, "S1513C1");
    check_base_class_offset(lv, (S1513C3*)(S1513C2*), 0, "S1513C1");
    check_base_class_offset(lv, (S1513C2*), 0, "S1513C1");
    check_field_offset(lv, s1513c1f0, ABISELECT(120,76), "S1513C1.s1513c1f0");
    check_field_offset(lv, s1513c1f1, ABISELECT(160,104), "S1513C1.s1513c1f1");
    check_field_offset(lv, s1513c1f2, ABISELECT(200,132), "S1513C1.s1513c1f2");
    check_field_offset(lv, s1513c1f3, ABISELECT(240,160), "S1513C1.s1513c1f3");
    check_field_offset(lv, s1513c1f4, ABISELECT(280,188), "S1513C1.s1513c1f4");
    check_field_offset(lv, s1513c1f5, ABISELECT(320,216), "S1513C1.s1513c1f5");
    check_field_offset(lv, s1513c1f6, ABISELECT(360,244), "S1513C1.s1513c1f6");
    check_field_offset(lv, s1513c1f7, ABISELECT(400,272), "S1513C1.s1513c1f7");
    check_field_offset(lv, s1513c1f8, ABISELECT(440,300), "S1513C1.s1513c1f8");
    set_bf_and_test(lv, s1513c1f9, ABISELECT(480,328), 0, 1, 1, "S1513C1");
    set_bf_and_test(lv, s1513c1f10, ABISELECT(480,328), 1, 1, 1, "S1513C1");
    set_bf_and_test(lv, s1513c1f11, ABISELECT(480,328), 2, 1, 1, "S1513C1");
    check_field_offset(lv, s1513c1f12, ABISELECT(488,332), "S1513C1.s1513c1f12");
    test_class_info(&lv, &cd_S1513C1);
    dp->~S1513C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1513C1(Test_S1513C1, "S1513C1", ABISELECT(528,360));

#else // __cplusplus

extern void _ZN7S1513C1C1Ev();
extern void _ZN7S1513C1D1Ev();
Name_Map name_map_S1513C1[] = {
  NSPAIR(_ZN7S1513C1C1Ev),
  NSPAIR(_ZN7S1513C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1513C4;
extern VTBL_ENTRY _ZTI7S1513C4[];
extern  VTBL_ENTRY _ZTV7S1513C4[];
extern Class_Descriptor cd_S1513C3;
extern VTBL_ENTRY _ZTI7S1513C3[];
extern  VTBL_ENTRY _ZTV7S1513C3[];
extern Class_Descriptor cd_S1513C2;
extern VTBL_ENTRY _ZTI7S1513C2[];
extern  VTBL_ENTRY _ZTV7S1513C2[];
static Base_Class bases_S1513C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1513C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1513C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1513C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1513C1[];
extern void _ZN7S1513C1D1Ev();
extern void _ZN7S1513C1D0Ev();
extern void _ZN7S1513C42v6Ev();
extern void _ZN7S1513C42v7Ev();
extern void _ZN7S1513C42v8Ev();
extern void _ZN7S1513C42v9Ev();
extern void _ZN7S1513C43v10Ev();
extern void _ZN7S1513C43v11Ev();
extern void _ZN7S1513C43v12Ev();
extern void _ZN7S1513C43v13Ev();
extern void _ZN7S1513C43v14Ev();
extern void _ZN7S1513C43v15Ev();
extern void _ZN7S1513C43v16Ev();
extern void _ZN7S1513C43v17Ev();
extern void _ZN7S1513C43v18Ev();
extern void _ZN7S1513C43v19Ev();
extern void _ZN7S1513C43v20Ev();
extern void _ZN7S1513C43v21Ev();
extern void _ZN7S1513C43v22Ev();
extern void _ZN7S1513C43v23Ev();
extern void _ZN7S1513C43v24Ev();
extern void _ZN7S1513C43v25Ev();
extern void _ZN7S1513C43v26Ev();
extern void _ZN7S1513C43v27Ev();
extern void _ZN7S1513C43v28Ev();
extern void _ZN7S1513C43v29Ev();
extern void _ZN7S1513C43v30Ev();
extern void _ZN7S1513C43v31Ev();
extern void _ZN7S1513C43v32Ev();
extern void _ZN7S1513C43v33Ev();
extern void _ZN7S1513C43v34Ev();
extern void _ZN7S1513C43v35Ev();
extern void _ZN7S1513C43v36Ev();
extern void _ZN7S1513C43v37Ev();
extern void _ZN7S1513C43v38Ev();
extern void _ZN7S1513C43v39Ev();
extern void _ZN7S1513C43v40Ev();
extern void _ZN7S1513C43v41Ev();
extern void _ZN7S1513C43v42Ev();
extern void _ZN7S1513C43v43Ev();
extern void _ZN7S1513C43v44Ev();
extern void _ZN7S1513C43v45Ev();
extern void _ZN7S1513C43v46Ev();
extern void _ZN7S1513C43v47Ev();
extern void _ZN7S1513C43v48Ev();
extern void _ZN7S1513C43v49Ev();
extern void _ZN7S1513C43v50Ev();
extern void _ZN7S1513C43v51Ev();
extern void _ZN7S1513C43v52Ev();
extern void _ZN7S1513C43v53Ev();
extern void _ZN7S1513C43v54Ev();
extern void _ZN7S1513C43v55Ev();
extern void _ZN7S1513C43v56Ev();
extern void _ZN7S1513C43v57Ev();
extern void _ZN7S1513C43v58Ev();
extern void _ZN7S1513C43v59Ev();
extern void _ZN7S1513C43v60Ev();
extern void _ZN7S1513C43v61Ev();
extern void _ZN7S1513C43v62Ev();
extern void _ZN7S1513C43v63Ev();
extern void _ZN7S1513C43v64Ev();
extern void _ZN7S1513C43v65Ev();
extern void _ZN7S1513C43v66Ev();
extern void _ZN7S1513C43v67Ev();
extern void _ZN7S1513C43v68Ev();
extern void _ZN7S1513C43v69Ev();
extern void _ZN7S1513C33v70Ev();
extern void _ZN7S1513C33v71Ev();
extern void _ZN7S1513C33v72Ev();
extern void _ZN7S1513C33v73Ev();
extern void _ZN7S1513C33v74Ev();
extern void _ZN7S1513C33v75Ev();
extern void _ZN7S1513C33v76Ev();
extern void _ZN7S1513C33v77Ev();
extern void _ZN7S1513C33v78Ev();
extern void _ZN7S1513C33v79Ev();
extern void _ZN7S1513C33v80Ev();
extern void _ZN7S1513C33v81Ev();
extern void _ZN7S1513C33v82Ev();
extern void _ZN7S1513C33v83Ev();
extern void _ZN7S1513C33v84Ev();
extern void _ZN7S1513C33v85Ev();
extern void _ZN7S1513C33v86Ev();
extern void _ZN7S1513C33v87Ev();
extern void _ZN7S1513C33v88Ev();
extern void _ZN7S1513C33v89Ev();
extern void _ZN7S1513C23v90Ev();
extern void _ZN7S1513C23v91Ev();
extern void _ZN7S1513C23v92Ev();
extern void _ZN7S1513C23v93Ev();
extern void _ZN7S1513C12v1Ev();
extern void _ZN7S1513C12v2Ev();
extern void _ZN7S1513C12v3Ev();
extern void _ZN7S1513C12v4Ev();
extern void _ZN7S1513C12v5Ev();
static  VTBL_ENTRY vtc_S1513C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1513C1[0]),
  (VTBL_ENTRY)&_ZN7S1513C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1513C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1513C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1513C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1513C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1513C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1513C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1513C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1513C23v90Ev,
  (VTBL_ENTRY)&_ZN7S1513C23v91Ev,
  (VTBL_ENTRY)&_ZN7S1513C23v92Ev,
  (VTBL_ENTRY)&_ZN7S1513C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1513C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1513C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1513C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1513C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1513C12v5Ev,
};
extern VTBL_ENTRY _ZTI7S1513C1[];
extern  VTBL_ENTRY _ZTV7S1513C1[];
Class_Descriptor cd_S1513C1 = {  "S1513C1", // class name
  bases_S1513C1, 3,
  &(vtc_S1513C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(528,360), // object size
  NSPAIRA(_ZTI7S1513C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1513C1),97, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3012C3  {
  int s3012c3f0;
  __tsi64 s3012c3f1;
  void *s3012c3f2[4];
  int s3012c3f3[2];
  void *s3012c3f4;
  ::S674C6_nt s3012c3f5;
  void *s3012c3f6[2];
  virtual  ~S3012C3(); // _ZN7S3012C3D1Ev
  virtual void  v10(); // _ZN7S3012C33v10Ev
  virtual void  v11(); // _ZN7S3012C33v11Ev
  virtual void  v12(); // _ZN7S3012C33v12Ev
  virtual void  v13(); // _ZN7S3012C33v13Ev
  virtual void  v14(); // _ZN7S3012C33v14Ev
  virtual void  v15(); // _ZN7S3012C33v15Ev
  virtual void  v16(); // _ZN7S3012C33v16Ev
  virtual void  v17(); // _ZN7S3012C33v17Ev
  virtual void  v18(); // _ZN7S3012C33v18Ev
  virtual void  v19(); // _ZN7S3012C33v19Ev
  virtual void  v20(); // _ZN7S3012C33v20Ev
  virtual void  v21(); // _ZN7S3012C33v21Ev
  virtual void  v22(); // _ZN7S3012C33v22Ev
  virtual void  v23(); // _ZN7S3012C33v23Ev
  virtual void  v24(); // _ZN7S3012C33v24Ev
  virtual void  v25(); // _ZN7S3012C33v25Ev
  virtual void  v26(); // _ZN7S3012C33v26Ev
  virtual void  v27(); // _ZN7S3012C33v27Ev
  virtual void  v28(); // _ZN7S3012C33v28Ev
  virtual void  v29(); // _ZN7S3012C33v29Ev
  virtual void  v30(); // _ZN7S3012C33v30Ev
  virtual void  v31(); // _ZN7S3012C33v31Ev
  virtual void  v32(); // _ZN7S3012C33v32Ev
  virtual void  v33(); // _ZN7S3012C33v33Ev
  virtual void  v34(); // _ZN7S3012C33v34Ev
  virtual void  v35(); // _ZN7S3012C33v35Ev
  virtual void  v36(); // _ZN7S3012C33v36Ev
  virtual void  v37(); // _ZN7S3012C33v37Ev
  virtual void  v38(); // _ZN7S3012C33v38Ev
  virtual void  v39(); // _ZN7S3012C33v39Ev
  virtual void  v40(); // _ZN7S3012C33v40Ev
  virtual void  v41(); // _ZN7S3012C33v41Ev
  virtual void  v42(); // _ZN7S3012C33v42Ev
  virtual void  v43(); // _ZN7S3012C33v43Ev
  virtual void  v44(); // _ZN7S3012C33v44Ev
  virtual void  v45(); // _ZN7S3012C33v45Ev
  virtual void  v46(); // _ZN7S3012C33v46Ev
  virtual void  v47(); // _ZN7S3012C33v47Ev
  virtual void  v48(); // _ZN7S3012C33v48Ev
  virtual void  v49(); // _ZN7S3012C33v49Ev
  virtual void  v50(); // _ZN7S3012C33v50Ev
  virtual void  v51(); // _ZN7S3012C33v51Ev
  virtual void  v52(); // _ZN7S3012C33v52Ev
  virtual void  v53(); // _ZN7S3012C33v53Ev
  virtual void  v54(); // _ZN7S3012C33v54Ev
  virtual void  v55(); // _ZN7S3012C33v55Ev
  virtual void  v56(); // _ZN7S3012C33v56Ev
  virtual void  v57(); // _ZN7S3012C33v57Ev
  virtual void  v58(); // _ZN7S3012C33v58Ev
  virtual void  v59(); // _ZN7S3012C33v59Ev
  virtual void  v60(); // _ZN7S3012C33v60Ev
  virtual void  v61(); // _ZN7S3012C33v61Ev
  virtual void  v62(); // _ZN7S3012C33v62Ev
  virtual void  v63(); // _ZN7S3012C33v63Ev
  virtual void  v64(); // _ZN7S3012C33v64Ev
  virtual void  v65(); // _ZN7S3012C33v65Ev
  virtual void  v66(); // _ZN7S3012C33v66Ev
  virtual void  v67(); // _ZN7S3012C33v67Ev
  virtual void  v68(); // _ZN7S3012C33v68Ev
  virtual void  v69(); // _ZN7S3012C33v69Ev
  virtual void  v70(); // _ZN7S3012C33v70Ev
  virtual void  v71(); // _ZN7S3012C33v71Ev
  virtual void  v72(); // _ZN7S3012C33v72Ev
  virtual void  v73(); // _ZN7S3012C33v73Ev
  S3012C3(); // tgen
};
//SIG(-1 S3012C3) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S3012C3 ::~S3012C3(){ note_dtor("S3012C3", this);}
void  S3012C3 ::v10(){vfunc_called(this, "_ZN7S3012C33v10Ev");}
void  S3012C3 ::v11(){vfunc_called(this, "_ZN7S3012C33v11Ev");}
void  S3012C3 ::v12(){vfunc_called(this, "_ZN7S3012C33v12Ev");}
void  S3012C3 ::v13(){vfunc_called(this, "_ZN7S3012C33v13Ev");}
void  S3012C3 ::v14(){vfunc_called(this, "_ZN7S3012C33v14Ev");}
void  S3012C3 ::v15(){vfunc_called(this, "_ZN7S3012C33v15Ev");}
void  S3012C3 ::v16(){vfunc_called(this, "_ZN7S3012C33v16Ev");}
void  S3012C3 ::v17(){vfunc_called(this, "_ZN7S3012C33v17Ev");}
void  S3012C3 ::v18(){vfunc_called(this, "_ZN7S3012C33v18Ev");}
void  S3012C3 ::v19(){vfunc_called(this, "_ZN7S3012C33v19Ev");}
void  S3012C3 ::v20(){vfunc_called(this, "_ZN7S3012C33v20Ev");}
void  S3012C3 ::v21(){vfunc_called(this, "_ZN7S3012C33v21Ev");}
void  S3012C3 ::v22(){vfunc_called(this, "_ZN7S3012C33v22Ev");}
void  S3012C3 ::v23(){vfunc_called(this, "_ZN7S3012C33v23Ev");}
void  S3012C3 ::v24(){vfunc_called(this, "_ZN7S3012C33v24Ev");}
void  S3012C3 ::v25(){vfunc_called(this, "_ZN7S3012C33v25Ev");}
void  S3012C3 ::v26(){vfunc_called(this, "_ZN7S3012C33v26Ev");}
void  S3012C3 ::v27(){vfunc_called(this, "_ZN7S3012C33v27Ev");}
void  S3012C3 ::v28(){vfunc_called(this, "_ZN7S3012C33v28Ev");}
void  S3012C3 ::v29(){vfunc_called(this, "_ZN7S3012C33v29Ev");}
void  S3012C3 ::v30(){vfunc_called(this, "_ZN7S3012C33v30Ev");}
void  S3012C3 ::v31(){vfunc_called(this, "_ZN7S3012C33v31Ev");}
void  S3012C3 ::v32(){vfunc_called(this, "_ZN7S3012C33v32Ev");}
void  S3012C3 ::v33(){vfunc_called(this, "_ZN7S3012C33v33Ev");}
void  S3012C3 ::v34(){vfunc_called(this, "_ZN7S3012C33v34Ev");}
void  S3012C3 ::v35(){vfunc_called(this, "_ZN7S3012C33v35Ev");}
void  S3012C3 ::v36(){vfunc_called(this, "_ZN7S3012C33v36Ev");}
void  S3012C3 ::v37(){vfunc_called(this, "_ZN7S3012C33v37Ev");}
void  S3012C3 ::v38(){vfunc_called(this, "_ZN7S3012C33v38Ev");}
void  S3012C3 ::v39(){vfunc_called(this, "_ZN7S3012C33v39Ev");}
void  S3012C3 ::v40(){vfunc_called(this, "_ZN7S3012C33v40Ev");}
void  S3012C3 ::v41(){vfunc_called(this, "_ZN7S3012C33v41Ev");}
void  S3012C3 ::v42(){vfunc_called(this, "_ZN7S3012C33v42Ev");}
void  S3012C3 ::v43(){vfunc_called(this, "_ZN7S3012C33v43Ev");}
void  S3012C3 ::v44(){vfunc_called(this, "_ZN7S3012C33v44Ev");}
void  S3012C3 ::v45(){vfunc_called(this, "_ZN7S3012C33v45Ev");}
void  S3012C3 ::v46(){vfunc_called(this, "_ZN7S3012C33v46Ev");}
void  S3012C3 ::v47(){vfunc_called(this, "_ZN7S3012C33v47Ev");}
void  S3012C3 ::v48(){vfunc_called(this, "_ZN7S3012C33v48Ev");}
void  S3012C3 ::v49(){vfunc_called(this, "_ZN7S3012C33v49Ev");}
void  S3012C3 ::v50(){vfunc_called(this, "_ZN7S3012C33v50Ev");}
void  S3012C3 ::v51(){vfunc_called(this, "_ZN7S3012C33v51Ev");}
void  S3012C3 ::v52(){vfunc_called(this, "_ZN7S3012C33v52Ev");}
void  S3012C3 ::v53(){vfunc_called(this, "_ZN7S3012C33v53Ev");}
void  S3012C3 ::v54(){vfunc_called(this, "_ZN7S3012C33v54Ev");}
void  S3012C3 ::v55(){vfunc_called(this, "_ZN7S3012C33v55Ev");}
void  S3012C3 ::v56(){vfunc_called(this, "_ZN7S3012C33v56Ev");}
void  S3012C3 ::v57(){vfunc_called(this, "_ZN7S3012C33v57Ev");}
void  S3012C3 ::v58(){vfunc_called(this, "_ZN7S3012C33v58Ev");}
void  S3012C3 ::v59(){vfunc_called(this, "_ZN7S3012C33v59Ev");}
void  S3012C3 ::v60(){vfunc_called(this, "_ZN7S3012C33v60Ev");}
void  S3012C3 ::v61(){vfunc_called(this, "_ZN7S3012C33v61Ev");}
void  S3012C3 ::v62(){vfunc_called(this, "_ZN7S3012C33v62Ev");}
void  S3012C3 ::v63(){vfunc_called(this, "_ZN7S3012C33v63Ev");}
void  S3012C3 ::v64(){vfunc_called(this, "_ZN7S3012C33v64Ev");}
void  S3012C3 ::v65(){vfunc_called(this, "_ZN7S3012C33v65Ev");}
void  S3012C3 ::v66(){vfunc_called(this, "_ZN7S3012C33v66Ev");}
void  S3012C3 ::v67(){vfunc_called(this, "_ZN7S3012C33v67Ev");}
void  S3012C3 ::v68(){vfunc_called(this, "_ZN7S3012C33v68Ev");}
void  S3012C3 ::v69(){vfunc_called(this, "_ZN7S3012C33v69Ev");}
void  S3012C3 ::v70(){vfunc_called(this, "_ZN7S3012C33v70Ev");}
void  S3012C3 ::v71(){vfunc_called(this, "_ZN7S3012C33v71Ev");}
void  S3012C3 ::v72(){vfunc_called(this, "_ZN7S3012C33v72Ev");}
void  S3012C3 ::v73(){vfunc_called(this, "_ZN7S3012C33v73Ev");}
S3012C3 ::S3012C3(){ note_ctor("S3012C3", this);} // tgen

static void Test_S3012C3()
{
  extern Class_Descriptor cd_S3012C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S3012C3, buf);
    S3012C3 *dp, &lv = *(dp=new (buf) S3012C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S3012C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3012C3)");
    check_field_offset(lv, s3012c3f0, ABISELECT(8,4), "S3012C3.s3012c3f0");
    check_field_offset(lv, s3012c3f1, ABISELECT(16,8), "S3012C3.s3012c3f1");
    check_field_offset(lv, s3012c3f2, ABISELECT(24,16), "S3012C3.s3012c3f2");
    check_field_offset(lv, s3012c3f3, ABISELECT(56,32), "S3012C3.s3012c3f3");
    check_field_offset(lv, s3012c3f4, ABISELECT(64,40), "S3012C3.s3012c3f4");
    check_field_offset(lv, s3012c3f5, ABISELECT(72,44), "S3012C3.s3012c3f5");
    check_field_offset(lv, s3012c3f6, ABISELECT(80,52), "S3012C3.s3012c3f6");
    test_class_info(&lv, &cd_S3012C3);
    dp->~S3012C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3012C3(Test_S3012C3, "S3012C3", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S3012C3C1Ev();
extern void _ZN7S3012C3D1Ev();
Name_Map name_map_S3012C3[] = {
  NSPAIR(_ZN7S3012C3C1Ev),
  NSPAIR(_ZN7S3012C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S3012C3[];
extern void _ZN7S3012C3D1Ev();
extern void _ZN7S3012C3D0Ev();
extern void _ZN7S3012C33v10Ev();
extern void _ZN7S3012C33v11Ev();
extern void _ZN7S3012C33v12Ev();
extern void _ZN7S3012C33v13Ev();
extern void _ZN7S3012C33v14Ev();
extern void _ZN7S3012C33v15Ev();
extern void _ZN7S3012C33v16Ev();
extern void _ZN7S3012C33v17Ev();
extern void _ZN7S3012C33v18Ev();
extern void _ZN7S3012C33v19Ev();
extern void _ZN7S3012C33v20Ev();
extern void _ZN7S3012C33v21Ev();
extern void _ZN7S3012C33v22Ev();
extern void _ZN7S3012C33v23Ev();
extern void _ZN7S3012C33v24Ev();
extern void _ZN7S3012C33v25Ev();
extern void _ZN7S3012C33v26Ev();
extern void _ZN7S3012C33v27Ev();
extern void _ZN7S3012C33v28Ev();
extern void _ZN7S3012C33v29Ev();
extern void _ZN7S3012C33v30Ev();
extern void _ZN7S3012C33v31Ev();
extern void _ZN7S3012C33v32Ev();
extern void _ZN7S3012C33v33Ev();
extern void _ZN7S3012C33v34Ev();
extern void _ZN7S3012C33v35Ev();
extern void _ZN7S3012C33v36Ev();
extern void _ZN7S3012C33v37Ev();
extern void _ZN7S3012C33v38Ev();
extern void _ZN7S3012C33v39Ev();
extern void _ZN7S3012C33v40Ev();
extern void _ZN7S3012C33v41Ev();
extern void _ZN7S3012C33v42Ev();
extern void _ZN7S3012C33v43Ev();
extern void _ZN7S3012C33v44Ev();
extern void _ZN7S3012C33v45Ev();
extern void _ZN7S3012C33v46Ev();
extern void _ZN7S3012C33v47Ev();
extern void _ZN7S3012C33v48Ev();
extern void _ZN7S3012C33v49Ev();
extern void _ZN7S3012C33v50Ev();
extern void _ZN7S3012C33v51Ev();
extern void _ZN7S3012C33v52Ev();
extern void _ZN7S3012C33v53Ev();
extern void _ZN7S3012C33v54Ev();
extern void _ZN7S3012C33v55Ev();
extern void _ZN7S3012C33v56Ev();
extern void _ZN7S3012C33v57Ev();
extern void _ZN7S3012C33v58Ev();
extern void _ZN7S3012C33v59Ev();
extern void _ZN7S3012C33v60Ev();
extern void _ZN7S3012C33v61Ev();
extern void _ZN7S3012C33v62Ev();
extern void _ZN7S3012C33v63Ev();
extern void _ZN7S3012C33v64Ev();
extern void _ZN7S3012C33v65Ev();
extern void _ZN7S3012C33v66Ev();
extern void _ZN7S3012C33v67Ev();
extern void _ZN7S3012C33v68Ev();
extern void _ZN7S3012C33v69Ev();
extern void _ZN7S3012C33v70Ev();
extern void _ZN7S3012C33v71Ev();
extern void _ZN7S3012C33v72Ev();
extern void _ZN7S3012C33v73Ev();
static  VTBL_ENTRY vtc_S3012C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3012C3[0]),
  (VTBL_ENTRY)&_ZN7S3012C3D1Ev,
  (VTBL_ENTRY)&_ZN7S3012C3D0Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v10Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v11Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v12Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v13Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v14Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v15Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v16Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v17Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v18Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v19Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v20Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v21Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v22Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v23Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v24Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v25Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v26Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v27Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v28Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v29Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v30Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v31Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v32Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v33Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v34Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v35Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v36Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v37Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v38Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v39Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v40Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v41Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v42Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v43Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v44Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v45Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v46Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v47Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v48Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v49Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v50Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v51Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v52Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v53Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v54Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v55Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v56Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v57Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v58Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v59Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v60Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v61Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v62Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v63Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v64Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v65Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v66Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v67Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v68Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v69Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v70Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v71Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v72Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v73Ev,
};
extern VTBL_ENTRY _ZTI7S3012C3[];
extern  VTBL_ENTRY _ZTV7S3012C3[];
Class_Descriptor cd_S3012C3 = {  "S3012C3", // class name
  0,0,//no base classes
  &(vtc_S3012C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S3012C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S3012C3),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3012C2  : S3012C3 {
  unsigned int s3012c2f0:1;
  unsigned int s3012c2f1:1;
  unsigned int s3012c2f2:1;
  unsigned int s3012c2f3:1;
  unsigned int s3012c2f4:1;
  unsigned int s3012c2f5:1;
  unsigned int s3012c2f6:1;
  ::S3625C32 s3012c2f7;
  virtual  ~S3012C2(); // _ZN7S3012C2D1Ev
  virtual void  v74(); // _ZN7S3012C23v74Ev
  virtual void  v75(); // _ZN7S3012C23v75Ev
  virtual void  v76(); // _ZN7S3012C23v76Ev
  virtual void  v77(); // _ZN7S3012C23v77Ev
  virtual void  v78(); // _ZN7S3012C23v78Ev
  virtual void  v79(); // _ZN7S3012C23v79Ev
  virtual void  v80(); // _ZN7S3012C23v80Ev
  virtual void  v81(); // _ZN7S3012C23v81Ev
  virtual void  v82(); // _ZN7S3012C23v82Ev
  virtual void  v83(); // _ZN7S3012C23v83Ev
  virtual void  v84(); // _ZN7S3012C23v84Ev
  virtual void  v85(); // _ZN7S3012C23v85Ev
  virtual void  v86(); // _ZN7S3012C23v86Ev
  virtual void  v87(); // _ZN7S3012C23v87Ev
  virtual void  v88(); // _ZN7S3012C23v88Ev
  virtual void  v89(); // _ZN7S3012C23v89Ev
  virtual void  v90(); // _ZN7S3012C23v90Ev
  virtual void  v91(); // _ZN7S3012C23v91Ev
  virtual void  v92(); // _ZN7S3012C23v92Ev
  virtual void  v93(); // _ZN7S3012C23v93Ev
  S3012C2(); // tgen
};
//SIG(-1 S3012C2) C1{ BC2{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC4{ m}}


 S3012C2 ::~S3012C2(){ note_dtor("S3012C2", this);}
void  S3012C2 ::v74(){vfunc_called(this, "_ZN7S3012C23v74Ev");}
void  S3012C2 ::v75(){vfunc_called(this, "_ZN7S3012C23v75Ev");}
void  S3012C2 ::v76(){vfunc_called(this, "_ZN7S3012C23v76Ev");}
void  S3012C2 ::v77(){vfunc_called(this, "_ZN7S3012C23v77Ev");}
void  S3012C2 ::v78(){vfunc_called(this, "_ZN7S3012C23v78Ev");}
void  S3012C2 ::v79(){vfunc_called(this, "_ZN7S3012C23v79Ev");}
void  S3012C2 ::v80(){vfunc_called(this, "_ZN7S3012C23v80Ev");}
void  S3012C2 ::v81(){vfunc_called(this, "_ZN7S3012C23v81Ev");}
void  S3012C2 ::v82(){vfunc_called(this, "_ZN7S3012C23v82Ev");}
void  S3012C2 ::v83(){vfunc_called(this, "_ZN7S3012C23v83Ev");}
void  S3012C2 ::v84(){vfunc_called(this, "_ZN7S3012C23v84Ev");}
void  S3012C2 ::v85(){vfunc_called(this, "_ZN7S3012C23v85Ev");}
void  S3012C2 ::v86(){vfunc_called(this, "_ZN7S3012C23v86Ev");}
void  S3012C2 ::v87(){vfunc_called(this, "_ZN7S3012C23v87Ev");}
void  S3012C2 ::v88(){vfunc_called(this, "_ZN7S3012C23v88Ev");}
void  S3012C2 ::v89(){vfunc_called(this, "_ZN7S3012C23v89Ev");}
void  S3012C2 ::v90(){vfunc_called(this, "_ZN7S3012C23v90Ev");}
void  S3012C2 ::v91(){vfunc_called(this, "_ZN7S3012C23v91Ev");}
void  S3012C2 ::v92(){vfunc_called(this, "_ZN7S3012C23v92Ev");}
void  S3012C2 ::v93(){vfunc_called(this, "_ZN7S3012C23v93Ev");}
S3012C2 ::S3012C2(){ note_ctor("S3012C2", this);} // tgen

static void Test_S3012C2()
{
  extern Class_Descriptor cd_S3012C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S3012C2, buf);
    S3012C2 *dp, &lv = *(dp=new (buf) S3012C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S3012C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3012C2)");
    check_base_class_offset(lv, (S3012C3*), 0, "S3012C2");
    set_bf_and_test(lv, s3012c2f0, ABISELECT(96,60), 0, 1, 1, "S3012C2");
    set_bf_and_test(lv, s3012c2f1, ABISELECT(96,60), 1, 1, 1, "S3012C2");
    set_bf_and_test(lv, s3012c2f2, ABISELECT(96,60), 2, 1, 1, "S3012C2");
    set_bf_and_test(lv, s3012c2f3, ABISELECT(96,60), 3, 1, 1, "S3012C2");
    set_bf_and_test(lv, s3012c2f4, ABISELECT(96,60), 4, 1, 1, "S3012C2");
    set_bf_and_test(lv, s3012c2f5, ABISELECT(96,60), 5, 1, 1, "S3012C2");
    set_bf_and_test(lv, s3012c2f6, ABISELECT(96,60), 6, 1, 1, "S3012C2");
    check_field_offset(lv, s3012c2f7, ABISELECT(97,61), "S3012C2.s3012c2f7");
    test_class_info(&lv, &cd_S3012C2);
    dp->~S3012C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3012C2(Test_S3012C2, "S3012C2", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN7S3012C2C1Ev();
extern void _ZN7S3012C2D1Ev();
Name_Map name_map_S3012C2[] = {
  NSPAIR(_ZN7S3012C2C1Ev),
  NSPAIR(_ZN7S3012C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3012C3;
extern VTBL_ENTRY _ZTI7S3012C3[];
extern  VTBL_ENTRY _ZTV7S3012C3[];
static Base_Class bases_S3012C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3012C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3012C2[];
extern void _ZN7S3012C2D1Ev();
extern void _ZN7S3012C2D0Ev();
extern void _ZN7S3012C33v10Ev();
extern void _ZN7S3012C33v11Ev();
extern void _ZN7S3012C33v12Ev();
extern void _ZN7S3012C33v13Ev();
extern void _ZN7S3012C33v14Ev();
extern void _ZN7S3012C33v15Ev();
extern void _ZN7S3012C33v16Ev();
extern void _ZN7S3012C33v17Ev();
extern void _ZN7S3012C33v18Ev();
extern void _ZN7S3012C33v19Ev();
extern void _ZN7S3012C33v20Ev();
extern void _ZN7S3012C33v21Ev();
extern void _ZN7S3012C33v22Ev();
extern void _ZN7S3012C33v23Ev();
extern void _ZN7S3012C33v24Ev();
extern void _ZN7S3012C33v25Ev();
extern void _ZN7S3012C33v26Ev();
extern void _ZN7S3012C33v27Ev();
extern void _ZN7S3012C33v28Ev();
extern void _ZN7S3012C33v29Ev();
extern void _ZN7S3012C33v30Ev();
extern void _ZN7S3012C33v31Ev();
extern void _ZN7S3012C33v32Ev();
extern void _ZN7S3012C33v33Ev();
extern void _ZN7S3012C33v34Ev();
extern void _ZN7S3012C33v35Ev();
extern void _ZN7S3012C33v36Ev();
extern void _ZN7S3012C33v37Ev();
extern void _ZN7S3012C33v38Ev();
extern void _ZN7S3012C33v39Ev();
extern void _ZN7S3012C33v40Ev();
extern void _ZN7S3012C33v41Ev();
extern void _ZN7S3012C33v42Ev();
extern void _ZN7S3012C33v43Ev();
extern void _ZN7S3012C33v44Ev();
extern void _ZN7S3012C33v45Ev();
extern void _ZN7S3012C33v46Ev();
extern void _ZN7S3012C33v47Ev();
extern void _ZN7S3012C33v48Ev();
extern void _ZN7S3012C33v49Ev();
extern void _ZN7S3012C33v50Ev();
extern void _ZN7S3012C33v51Ev();
extern void _ZN7S3012C33v52Ev();
extern void _ZN7S3012C33v53Ev();
extern void _ZN7S3012C33v54Ev();
extern void _ZN7S3012C33v55Ev();
extern void _ZN7S3012C33v56Ev();
extern void _ZN7S3012C33v57Ev();
extern void _ZN7S3012C33v58Ev();
extern void _ZN7S3012C33v59Ev();
extern void _ZN7S3012C33v60Ev();
extern void _ZN7S3012C33v61Ev();
extern void _ZN7S3012C33v62Ev();
extern void _ZN7S3012C33v63Ev();
extern void _ZN7S3012C33v64Ev();
extern void _ZN7S3012C33v65Ev();
extern void _ZN7S3012C33v66Ev();
extern void _ZN7S3012C33v67Ev();
extern void _ZN7S3012C33v68Ev();
extern void _ZN7S3012C33v69Ev();
extern void _ZN7S3012C33v70Ev();
extern void _ZN7S3012C33v71Ev();
extern void _ZN7S3012C33v72Ev();
extern void _ZN7S3012C33v73Ev();
extern void _ZN7S3012C23v74Ev();
extern void _ZN7S3012C23v75Ev();
extern void _ZN7S3012C23v76Ev();
extern void _ZN7S3012C23v77Ev();
extern void _ZN7S3012C23v78Ev();
extern void _ZN7S3012C23v79Ev();
extern void _ZN7S3012C23v80Ev();
extern void _ZN7S3012C23v81Ev();
extern void _ZN7S3012C23v82Ev();
extern void _ZN7S3012C23v83Ev();
extern void _ZN7S3012C23v84Ev();
extern void _ZN7S3012C23v85Ev();
extern void _ZN7S3012C23v86Ev();
extern void _ZN7S3012C23v87Ev();
extern void _ZN7S3012C23v88Ev();
extern void _ZN7S3012C23v89Ev();
extern void _ZN7S3012C23v90Ev();
extern void _ZN7S3012C23v91Ev();
extern void _ZN7S3012C23v92Ev();
extern void _ZN7S3012C23v93Ev();
static  VTBL_ENTRY vtc_S3012C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3012C2[0]),
  (VTBL_ENTRY)&_ZN7S3012C2D1Ev,
  (VTBL_ENTRY)&_ZN7S3012C2D0Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v10Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v11Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v12Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v13Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v14Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v15Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v16Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v17Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v18Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v19Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v20Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v21Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v22Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v23Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v24Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v25Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v26Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v27Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v28Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v29Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v30Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v31Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v32Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v33Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v34Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v35Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v36Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v37Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v38Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v39Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v40Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v41Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v42Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v43Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v44Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v45Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v46Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v47Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v48Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v49Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v50Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v51Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v52Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v53Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v54Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v55Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v56Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v57Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v58Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v59Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v60Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v61Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v62Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v63Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v64Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v65Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v66Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v67Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v68Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v69Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v70Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v71Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v72Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v73Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v74Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v75Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v76Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v77Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v78Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v79Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v80Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v81Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v82Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v83Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v84Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v85Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v86Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v87Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v88Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v89Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v90Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v91Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v92Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v93Ev,
};
extern VTBL_ENTRY _ZTI7S3012C2[];
extern  VTBL_ENTRY _ZTV7S3012C2[];
Class_Descriptor cd_S3012C2 = {  "S3012C2", // class name
  bases_S3012C2, 1,
  &(vtc_S3012C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI7S3012C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3012C2),88, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3012C1  : S3012C2 {
  void *s3012c1f0;
  char s3012c1f1[4];
  unsigned int s3012c1f2:1;
  unsigned int s3012c1f3:1;
  unsigned int s3012c1f4:1;
  unsigned int s3012c1f5:1;
  unsigned int s3012c1f6:1;
  unsigned int s3012c1f7:1;
  unsigned int s3012c1f8:1;
  unsigned int s3012c1f9:1;
  unsigned int s3012c1f10:1;
  unsigned int s3012c1f11:1;
  int s3012c1f12[4];
  ::S1292C12 s3012c1f13;
  ::S674C42 s3012c1f14;
  int s3012c1f15[5];
  ::S3625C32 s3012c1f16;
  virtual  ~S3012C1(); // _ZN7S3012C1D1Ev
  virtual void  v1(); // _ZN7S3012C12v1Ev
  virtual void  v2(); // _ZN7S3012C12v2Ev
  virtual void  v3(); // _ZN7S3012C12v3Ev
  virtual void  v4(); // _ZN7S3012C12v4Ev
  virtual void  v5(); // _ZN7S3012C12v5Ev
  virtual void  v6(); // _ZN7S3012C12v6Ev
  virtual void  v7(); // _ZN7S3012C12v7Ev
  virtual void  v8(); // _ZN7S3012C12v8Ev
  virtual void  v9(); // _ZN7S3012C12v9Ev
  S3012C1(); // tgen
};
//SIG(1 S3012C1) C1{ BC2{ BC3{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC5{ m}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fp Fc[4] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[4] FC6{ BC7{ m Fc[4] FC8{ BC9{ BC10{ m Fp Fi[2]}}} Fi[2]} Fp} FC11{ BC12{ BC10}} Fi[5] FC5}


 S3012C1 ::~S3012C1(){ note_dtor("S3012C1", this);}
void  S3012C1 ::v1(){vfunc_called(this, "_ZN7S3012C12v1Ev");}
void  S3012C1 ::v2(){vfunc_called(this, "_ZN7S3012C12v2Ev");}
void  S3012C1 ::v3(){vfunc_called(this, "_ZN7S3012C12v3Ev");}
void  S3012C1 ::v4(){vfunc_called(this, "_ZN7S3012C12v4Ev");}
void  S3012C1 ::v5(){vfunc_called(this, "_ZN7S3012C12v5Ev");}
void  S3012C1 ::v6(){vfunc_called(this, "_ZN7S3012C12v6Ev");}
void  S3012C1 ::v7(){vfunc_called(this, "_ZN7S3012C12v7Ev");}
void  S3012C1 ::v8(){vfunc_called(this, "_ZN7S3012C12v8Ev");}
void  S3012C1 ::v9(){vfunc_called(this, "_ZN7S3012C12v9Ev");}
S3012C1 ::S3012C1(){ note_ctor("S3012C1", this);} // tgen

static void Test_S3012C1()
{
  extern Class_Descriptor cd_S3012C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(28,40)];
    init_test(&cd_S3012C1, buf);
    S3012C1 *dp, &lv = *(dp=new (buf) S3012C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(216,156), "sizeof(S3012C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3012C1)");
    check_base_class_offset(lv, (S3012C3*)(S3012C2*), 0, "S3012C1");
    check_base_class_offset(lv, (S3012C2*), 0, "S3012C1");
    check_field_offset(lv, s3012c1f0, ABISELECT(104,64), "S3012C1.s3012c1f0");
    check_field_offset(lv, s3012c1f1, ABISELECT(112,68), "S3012C1.s3012c1f1");
    set_bf_and_test(lv, s3012c1f2, ABISELECT(116,72), 0, 1, 1, "S3012C1");
    set_bf_and_test(lv, s3012c1f3, ABISELECT(116,72), 1, 1, 1, "S3012C1");
    set_bf_and_test(lv, s3012c1f4, ABISELECT(116,72), 2, 1, 1, "S3012C1");
    set_bf_and_test(lv, s3012c1f5, ABISELECT(116,72), 3, 1, 1, "S3012C1");
    set_bf_and_test(lv, s3012c1f6, ABISELECT(116,72), 4, 1, 1, "S3012C1");
    set_bf_and_test(lv, s3012c1f7, ABISELECT(116,72), 5, 1, 1, "S3012C1");
    set_bf_and_test(lv, s3012c1f8, ABISELECT(116,72), 6, 1, 1, "S3012C1");
    set_bf_and_test(lv, s3012c1f9, ABISELECT(116,72), 7, 1, 1, "S3012C1");
    set_bf_and_test(lv, s3012c1f10, ABISELECT(117,73), 0, 1, 1, "S3012C1");
    set_bf_and_test(lv, s3012c1f11, ABISELECT(117,73), 1, 1, 1, "S3012C1");
    check_field_offset(lv, s3012c1f12, ABISELECT(120,76), "S3012C1.s3012c1f12");
    check_field_offset(lv, s3012c1f13, ABISELECT(136,92), "S3012C1.s3012c1f13");
    check_field_offset(lv, s3012c1f14, ABISELECT(176,120), "S3012C1.s3012c1f14");
    check_field_offset(lv, s3012c1f15, ABISELECT(192,132), "S3012C1.s3012c1f15");
    check_field_offset(lv, s3012c1f16, ABISELECT(212,152), "S3012C1.s3012c1f16");
    test_class_info(&lv, &cd_S3012C1);
    dp->~S3012C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3012C1(Test_S3012C1, "S3012C1", ABISELECT(216,156));

#else // __cplusplus

extern void _ZN7S3012C1C1Ev();
extern void _ZN7S3012C1D1Ev();
Name_Map name_map_S3012C1[] = {
  NSPAIR(_ZN7S3012C1C1Ev),
  NSPAIR(_ZN7S3012C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3012C3;
extern VTBL_ENTRY _ZTI7S3012C3[];
extern  VTBL_ENTRY _ZTV7S3012C3[];
extern Class_Descriptor cd_S3012C2;
extern VTBL_ENTRY _ZTI7S3012C2[];
extern  VTBL_ENTRY _ZTV7S3012C2[];
static Base_Class bases_S3012C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3012C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3012C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3012C1[];
extern void _ZN7S3012C1D1Ev();
extern void _ZN7S3012C1D0Ev();
extern void _ZN7S3012C33v10Ev();
extern void _ZN7S3012C33v11Ev();
extern void _ZN7S3012C33v12Ev();
extern void _ZN7S3012C33v13Ev();
extern void _ZN7S3012C33v14Ev();
extern void _ZN7S3012C33v15Ev();
extern void _ZN7S3012C33v16Ev();
extern void _ZN7S3012C33v17Ev();
extern void _ZN7S3012C33v18Ev();
extern void _ZN7S3012C33v19Ev();
extern void _ZN7S3012C33v20Ev();
extern void _ZN7S3012C33v21Ev();
extern void _ZN7S3012C33v22Ev();
extern void _ZN7S3012C33v23Ev();
extern void _ZN7S3012C33v24Ev();
extern void _ZN7S3012C33v25Ev();
extern void _ZN7S3012C33v26Ev();
extern void _ZN7S3012C33v27Ev();
extern void _ZN7S3012C33v28Ev();
extern void _ZN7S3012C33v29Ev();
extern void _ZN7S3012C33v30Ev();
extern void _ZN7S3012C33v31Ev();
extern void _ZN7S3012C33v32Ev();
extern void _ZN7S3012C33v33Ev();
extern void _ZN7S3012C33v34Ev();
extern void _ZN7S3012C33v35Ev();
extern void _ZN7S3012C33v36Ev();
extern void _ZN7S3012C33v37Ev();
extern void _ZN7S3012C33v38Ev();
extern void _ZN7S3012C33v39Ev();
extern void _ZN7S3012C33v40Ev();
extern void _ZN7S3012C33v41Ev();
extern void _ZN7S3012C33v42Ev();
extern void _ZN7S3012C33v43Ev();
extern void _ZN7S3012C33v44Ev();
extern void _ZN7S3012C33v45Ev();
extern void _ZN7S3012C33v46Ev();
extern void _ZN7S3012C33v47Ev();
extern void _ZN7S3012C33v48Ev();
extern void _ZN7S3012C33v49Ev();
extern void _ZN7S3012C33v50Ev();
extern void _ZN7S3012C33v51Ev();
extern void _ZN7S3012C33v52Ev();
extern void _ZN7S3012C33v53Ev();
extern void _ZN7S3012C33v54Ev();
extern void _ZN7S3012C33v55Ev();
extern void _ZN7S3012C33v56Ev();
extern void _ZN7S3012C33v57Ev();
extern void _ZN7S3012C33v58Ev();
extern void _ZN7S3012C33v59Ev();
extern void _ZN7S3012C33v60Ev();
extern void _ZN7S3012C33v61Ev();
extern void _ZN7S3012C33v62Ev();
extern void _ZN7S3012C33v63Ev();
extern void _ZN7S3012C33v64Ev();
extern void _ZN7S3012C33v65Ev();
extern void _ZN7S3012C33v66Ev();
extern void _ZN7S3012C33v67Ev();
extern void _ZN7S3012C33v68Ev();
extern void _ZN7S3012C33v69Ev();
extern void _ZN7S3012C33v70Ev();
extern void _ZN7S3012C33v71Ev();
extern void _ZN7S3012C33v72Ev();
extern void _ZN7S3012C33v73Ev();
extern void _ZN7S3012C23v74Ev();
extern void _ZN7S3012C23v75Ev();
extern void _ZN7S3012C23v76Ev();
extern void _ZN7S3012C23v77Ev();
extern void _ZN7S3012C23v78Ev();
extern void _ZN7S3012C23v79Ev();
extern void _ZN7S3012C23v80Ev();
extern void _ZN7S3012C23v81Ev();
extern void _ZN7S3012C23v82Ev();
extern void _ZN7S3012C23v83Ev();
extern void _ZN7S3012C23v84Ev();
extern void _ZN7S3012C23v85Ev();
extern void _ZN7S3012C23v86Ev();
extern void _ZN7S3012C23v87Ev();
extern void _ZN7S3012C23v88Ev();
extern void _ZN7S3012C23v89Ev();
extern void _ZN7S3012C23v90Ev();
extern void _ZN7S3012C23v91Ev();
extern void _ZN7S3012C23v92Ev();
extern void _ZN7S3012C23v93Ev();
extern void _ZN7S3012C12v1Ev();
extern void _ZN7S3012C12v2Ev();
extern void _ZN7S3012C12v3Ev();
extern void _ZN7S3012C12v4Ev();
extern void _ZN7S3012C12v5Ev();
extern void _ZN7S3012C12v6Ev();
extern void _ZN7S3012C12v7Ev();
extern void _ZN7S3012C12v8Ev();
extern void _ZN7S3012C12v9Ev();
static  VTBL_ENTRY vtc_S3012C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3012C1[0]),
  (VTBL_ENTRY)&_ZN7S3012C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3012C1D0Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v10Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v11Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v12Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v13Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v14Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v15Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v16Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v17Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v18Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v19Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v20Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v21Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v22Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v23Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v24Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v25Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v26Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v27Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v28Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v29Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v30Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v31Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v32Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v33Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v34Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v35Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v36Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v37Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v38Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v39Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v40Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v41Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v42Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v43Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v44Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v45Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v46Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v47Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v48Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v49Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v50Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v51Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v52Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v53Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v54Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v55Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v56Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v57Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v58Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v59Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v60Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v61Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v62Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v63Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v64Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v65Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v66Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v67Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v68Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v69Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v70Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v71Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v72Ev,
  (VTBL_ENTRY)&_ZN7S3012C33v73Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v74Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v75Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v76Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v77Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v78Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v79Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v80Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v81Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v82Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v83Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v84Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v85Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v86Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v87Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v88Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v89Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v90Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v91Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v92Ev,
  (VTBL_ENTRY)&_ZN7S3012C23v93Ev,
  (VTBL_ENTRY)&_ZN7S3012C12v1Ev,
  (VTBL_ENTRY)&_ZN7S3012C12v2Ev,
  (VTBL_ENTRY)&_ZN7S3012C12v3Ev,
  (VTBL_ENTRY)&_ZN7S3012C12v4Ev,
  (VTBL_ENTRY)&_ZN7S3012C12v5Ev,
  (VTBL_ENTRY)&_ZN7S3012C12v6Ev,
  (VTBL_ENTRY)&_ZN7S3012C12v7Ev,
  (VTBL_ENTRY)&_ZN7S3012C12v8Ev,
  (VTBL_ENTRY)&_ZN7S3012C12v9Ev,
};
extern VTBL_ENTRY _ZTI7S3012C1[];
extern  VTBL_ENTRY _ZTV7S3012C1[];
Class_Descriptor cd_S3012C1 = {  "S3012C1", // class name
  bases_S3012C1, 2,
  &(vtc_S3012C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(216,156), // object size
  NSPAIRA(_ZTI7S3012C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3012C1),97, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1599C4  {
  int s1599c4f0;
  __tsi64 s1599c4f1;
  void *s1599c4f2[4];
  int s1599c4f3[2];
  void *s1599c4f4;
  ::S674C6_nt s1599c4f5;
  void *s1599c4f6[2];
  virtual  ~S1599C4(); // _ZN7S1599C4D1Ev
  virtual void  v9(); // _ZN7S1599C42v9Ev
  virtual void  v10(); // _ZN7S1599C43v10Ev
  virtual void  v11(); // _ZN7S1599C43v11Ev
  virtual void  v12(); // _ZN7S1599C43v12Ev
  virtual void  v13(); // _ZN7S1599C43v13Ev
  virtual void  v14(); // _ZN7S1599C43v14Ev
  virtual void  v15(); // _ZN7S1599C43v15Ev
  virtual void  v16(); // _ZN7S1599C43v16Ev
  virtual void  v17(); // _ZN7S1599C43v17Ev
  virtual void  v18(); // _ZN7S1599C43v18Ev
  virtual void  v19(); // _ZN7S1599C43v19Ev
  virtual void  v20(); // _ZN7S1599C43v20Ev
  virtual void  v21(); // _ZN7S1599C43v21Ev
  virtual void  v22(); // _ZN7S1599C43v22Ev
  virtual void  v23(); // _ZN7S1599C43v23Ev
  virtual void  v24(); // _ZN7S1599C43v24Ev
  virtual void  v25(); // _ZN7S1599C43v25Ev
  virtual void  v26(); // _ZN7S1599C43v26Ev
  virtual void  v27(); // _ZN7S1599C43v27Ev
  virtual void  v28(); // _ZN7S1599C43v28Ev
  virtual void  v29(); // _ZN7S1599C43v29Ev
  virtual void  v30(); // _ZN7S1599C43v30Ev
  virtual void  v31(); // _ZN7S1599C43v31Ev
  virtual void  v32(); // _ZN7S1599C43v32Ev
  virtual void  v33(); // _ZN7S1599C43v33Ev
  virtual void  v34(); // _ZN7S1599C43v34Ev
  virtual void  v35(); // _ZN7S1599C43v35Ev
  virtual void  v36(); // _ZN7S1599C43v36Ev
  virtual void  v37(); // _ZN7S1599C43v37Ev
  virtual void  v38(); // _ZN7S1599C43v38Ev
  virtual void  v39(); // _ZN7S1599C43v39Ev
  virtual void  v40(); // _ZN7S1599C43v40Ev
  virtual void  v41(); // _ZN7S1599C43v41Ev
  virtual void  v42(); // _ZN7S1599C43v42Ev
  virtual void  v43(); // _ZN7S1599C43v43Ev
  virtual void  v44(); // _ZN7S1599C43v44Ev
  virtual void  v45(); // _ZN7S1599C43v45Ev
  virtual void  v46(); // _ZN7S1599C43v46Ev
  virtual void  v47(); // _ZN7S1599C43v47Ev
  virtual void  v48(); // _ZN7S1599C43v48Ev
  virtual void  v49(); // _ZN7S1599C43v49Ev
  virtual void  v50(); // _ZN7S1599C43v50Ev
  virtual void  v51(); // _ZN7S1599C43v51Ev
  virtual void  v52(); // _ZN7S1599C43v52Ev
  virtual void  v53(); // _ZN7S1599C43v53Ev
  virtual void  v54(); // _ZN7S1599C43v54Ev
  virtual void  v55(); // _ZN7S1599C43v55Ev
  virtual void  v56(); // _ZN7S1599C43v56Ev
  virtual void  v57(); // _ZN7S1599C43v57Ev
  virtual void  v58(); // _ZN7S1599C43v58Ev
  virtual void  v59(); // _ZN7S1599C43v59Ev
  virtual void  v60(); // _ZN7S1599C43v60Ev
  virtual void  v61(); // _ZN7S1599C43v61Ev
  virtual void  v62(); // _ZN7S1599C43v62Ev
  virtual void  v63(); // _ZN7S1599C43v63Ev
  virtual void  v64(); // _ZN7S1599C43v64Ev
  virtual void  v65(); // _ZN7S1599C43v65Ev
  virtual void  v66(); // _ZN7S1599C43v66Ev
  virtual void  v67(); // _ZN7S1599C43v67Ev
  virtual void  v68(); // _ZN7S1599C43v68Ev
  virtual void  v69(); // _ZN7S1599C43v69Ev
  virtual void  v70(); // _ZN7S1599C43v70Ev
  virtual void  v71(); // _ZN7S1599C43v71Ev
  virtual void  v72(); // _ZN7S1599C43v72Ev
  S1599C4(); // tgen
};
//SIG(-1 S1599C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1599C4 ::~S1599C4(){ note_dtor("S1599C4", this);}
void  S1599C4 ::v9(){vfunc_called(this, "_ZN7S1599C42v9Ev");}
void  S1599C4 ::v10(){vfunc_called(this, "_ZN7S1599C43v10Ev");}
void  S1599C4 ::v11(){vfunc_called(this, "_ZN7S1599C43v11Ev");}
void  S1599C4 ::v12(){vfunc_called(this, "_ZN7S1599C43v12Ev");}
void  S1599C4 ::v13(){vfunc_called(this, "_ZN7S1599C43v13Ev");}
void  S1599C4 ::v14(){vfunc_called(this, "_ZN7S1599C43v14Ev");}
void  S1599C4 ::v15(){vfunc_called(this, "_ZN7S1599C43v15Ev");}
void  S1599C4 ::v16(){vfunc_called(this, "_ZN7S1599C43v16Ev");}
void  S1599C4 ::v17(){vfunc_called(this, "_ZN7S1599C43v17Ev");}
void  S1599C4 ::v18(){vfunc_called(this, "_ZN7S1599C43v18Ev");}
void  S1599C4 ::v19(){vfunc_called(this, "_ZN7S1599C43v19Ev");}
void  S1599C4 ::v20(){vfunc_called(this, "_ZN7S1599C43v20Ev");}
void  S1599C4 ::v21(){vfunc_called(this, "_ZN7S1599C43v21Ev");}
void  S1599C4 ::v22(){vfunc_called(this, "_ZN7S1599C43v22Ev");}
void  S1599C4 ::v23(){vfunc_called(this, "_ZN7S1599C43v23Ev");}
void  S1599C4 ::v24(){vfunc_called(this, "_ZN7S1599C43v24Ev");}
void  S1599C4 ::v25(){vfunc_called(this, "_ZN7S1599C43v25Ev");}
void  S1599C4 ::v26(){vfunc_called(this, "_ZN7S1599C43v26Ev");}
void  S1599C4 ::v27(){vfunc_called(this, "_ZN7S1599C43v27Ev");}
void  S1599C4 ::v28(){vfunc_called(this, "_ZN7S1599C43v28Ev");}
void  S1599C4 ::v29(){vfunc_called(this, "_ZN7S1599C43v29Ev");}
void  S1599C4 ::v30(){vfunc_called(this, "_ZN7S1599C43v30Ev");}
void  S1599C4 ::v31(){vfunc_called(this, "_ZN7S1599C43v31Ev");}
void  S1599C4 ::v32(){vfunc_called(this, "_ZN7S1599C43v32Ev");}
void  S1599C4 ::v33(){vfunc_called(this, "_ZN7S1599C43v33Ev");}
void  S1599C4 ::v34(){vfunc_called(this, "_ZN7S1599C43v34Ev");}
void  S1599C4 ::v35(){vfunc_called(this, "_ZN7S1599C43v35Ev");}
void  S1599C4 ::v36(){vfunc_called(this, "_ZN7S1599C43v36Ev");}
void  S1599C4 ::v37(){vfunc_called(this, "_ZN7S1599C43v37Ev");}
void  S1599C4 ::v38(){vfunc_called(this, "_ZN7S1599C43v38Ev");}
void  S1599C4 ::v39(){vfunc_called(this, "_ZN7S1599C43v39Ev");}
void  S1599C4 ::v40(){vfunc_called(this, "_ZN7S1599C43v40Ev");}
void  S1599C4 ::v41(){vfunc_called(this, "_ZN7S1599C43v41Ev");}
void  S1599C4 ::v42(){vfunc_called(this, "_ZN7S1599C43v42Ev");}
void  S1599C4 ::v43(){vfunc_called(this, "_ZN7S1599C43v43Ev");}
void  S1599C4 ::v44(){vfunc_called(this, "_ZN7S1599C43v44Ev");}
void  S1599C4 ::v45(){vfunc_called(this, "_ZN7S1599C43v45Ev");}
void  S1599C4 ::v46(){vfunc_called(this, "_ZN7S1599C43v46Ev");}
void  S1599C4 ::v47(){vfunc_called(this, "_ZN7S1599C43v47Ev");}
void  S1599C4 ::v48(){vfunc_called(this, "_ZN7S1599C43v48Ev");}
void  S1599C4 ::v49(){vfunc_called(this, "_ZN7S1599C43v49Ev");}
void  S1599C4 ::v50(){vfunc_called(this, "_ZN7S1599C43v50Ev");}
void  S1599C4 ::v51(){vfunc_called(this, "_ZN7S1599C43v51Ev");}
void  S1599C4 ::v52(){vfunc_called(this, "_ZN7S1599C43v52Ev");}
void  S1599C4 ::v53(){vfunc_called(this, "_ZN7S1599C43v53Ev");}
void  S1599C4 ::v54(){vfunc_called(this, "_ZN7S1599C43v54Ev");}
void  S1599C4 ::v55(){vfunc_called(this, "_ZN7S1599C43v55Ev");}
void  S1599C4 ::v56(){vfunc_called(this, "_ZN7S1599C43v56Ev");}
void  S1599C4 ::v57(){vfunc_called(this, "_ZN7S1599C43v57Ev");}
void  S1599C4 ::v58(){vfunc_called(this, "_ZN7S1599C43v58Ev");}
void  S1599C4 ::v59(){vfunc_called(this, "_ZN7S1599C43v59Ev");}
void  S1599C4 ::v60(){vfunc_called(this, "_ZN7S1599C43v60Ev");}
void  S1599C4 ::v61(){vfunc_called(this, "_ZN7S1599C43v61Ev");}
void  S1599C4 ::v62(){vfunc_called(this, "_ZN7S1599C43v62Ev");}
void  S1599C4 ::v63(){vfunc_called(this, "_ZN7S1599C43v63Ev");}
void  S1599C4 ::v64(){vfunc_called(this, "_ZN7S1599C43v64Ev");}
void  S1599C4 ::v65(){vfunc_called(this, "_ZN7S1599C43v65Ev");}
void  S1599C4 ::v66(){vfunc_called(this, "_ZN7S1599C43v66Ev");}
void  S1599C4 ::v67(){vfunc_called(this, "_ZN7S1599C43v67Ev");}
void  S1599C4 ::v68(){vfunc_called(this, "_ZN7S1599C43v68Ev");}
void  S1599C4 ::v69(){vfunc_called(this, "_ZN7S1599C43v69Ev");}
void  S1599C4 ::v70(){vfunc_called(this, "_ZN7S1599C43v70Ev");}
void  S1599C4 ::v71(){vfunc_called(this, "_ZN7S1599C43v71Ev");}
void  S1599C4 ::v72(){vfunc_called(this, "_ZN7S1599C43v72Ev");}
S1599C4 ::S1599C4(){ note_ctor("S1599C4", this);} // tgen

static void Test_S1599C4()
{
  extern Class_Descriptor cd_S1599C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1599C4, buf);
    S1599C4 *dp, &lv = *(dp=new (buf) S1599C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1599C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1599C4)");
    check_field_offset(lv, s1599c4f0, ABISELECT(8,4), "S1599C4.s1599c4f0");
    check_field_offset(lv, s1599c4f1, ABISELECT(16,8), "S1599C4.s1599c4f1");
    check_field_offset(lv, s1599c4f2, ABISELECT(24,16), "S1599C4.s1599c4f2");
    check_field_offset(lv, s1599c4f3, ABISELECT(56,32), "S1599C4.s1599c4f3");
    check_field_offset(lv, s1599c4f4, ABISELECT(64,40), "S1599C4.s1599c4f4");
    check_field_offset(lv, s1599c4f5, ABISELECT(72,44), "S1599C4.s1599c4f5");
    check_field_offset(lv, s1599c4f6, ABISELECT(80,52), "S1599C4.s1599c4f6");
    test_class_info(&lv, &cd_S1599C4);
    dp->~S1599C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1599C4(Test_S1599C4, "S1599C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1599C4C1Ev();
extern void _ZN7S1599C4D1Ev();
Name_Map name_map_S1599C4[] = {
  NSPAIR(_ZN7S1599C4C1Ev),
  NSPAIR(_ZN7S1599C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1599C4[];
extern void _ZN7S1599C4D1Ev();
extern void _ZN7S1599C4D0Ev();
extern void _ZN7S1599C42v9Ev();
extern void _ZN7S1599C43v10Ev();
extern void _ZN7S1599C43v11Ev();
extern void _ZN7S1599C43v12Ev();
extern void _ZN7S1599C43v13Ev();
extern void _ZN7S1599C43v14Ev();
extern void _ZN7S1599C43v15Ev();
extern void _ZN7S1599C43v16Ev();
extern void _ZN7S1599C43v17Ev();
extern void _ZN7S1599C43v18Ev();
extern void _ZN7S1599C43v19Ev();
extern void _ZN7S1599C43v20Ev();
extern void _ZN7S1599C43v21Ev();
extern void _ZN7S1599C43v22Ev();
extern void _ZN7S1599C43v23Ev();
extern void _ZN7S1599C43v24Ev();
extern void _ZN7S1599C43v25Ev();
extern void _ZN7S1599C43v26Ev();
extern void _ZN7S1599C43v27Ev();
extern void _ZN7S1599C43v28Ev();
extern void _ZN7S1599C43v29Ev();
extern void _ZN7S1599C43v30Ev();
extern void _ZN7S1599C43v31Ev();
extern void _ZN7S1599C43v32Ev();
extern void _ZN7S1599C43v33Ev();
extern void _ZN7S1599C43v34Ev();
extern void _ZN7S1599C43v35Ev();
extern void _ZN7S1599C43v36Ev();
extern void _ZN7S1599C43v37Ev();
extern void _ZN7S1599C43v38Ev();
extern void _ZN7S1599C43v39Ev();
extern void _ZN7S1599C43v40Ev();
extern void _ZN7S1599C43v41Ev();
extern void _ZN7S1599C43v42Ev();
extern void _ZN7S1599C43v43Ev();
extern void _ZN7S1599C43v44Ev();
extern void _ZN7S1599C43v45Ev();
extern void _ZN7S1599C43v46Ev();
extern void _ZN7S1599C43v47Ev();
extern void _ZN7S1599C43v48Ev();
extern void _ZN7S1599C43v49Ev();
extern void _ZN7S1599C43v50Ev();
extern void _ZN7S1599C43v51Ev();
extern void _ZN7S1599C43v52Ev();
extern void _ZN7S1599C43v53Ev();
extern void _ZN7S1599C43v54Ev();
extern void _ZN7S1599C43v55Ev();
extern void _ZN7S1599C43v56Ev();
extern void _ZN7S1599C43v57Ev();
extern void _ZN7S1599C43v58Ev();
extern void _ZN7S1599C43v59Ev();
extern void _ZN7S1599C43v60Ev();
extern void _ZN7S1599C43v61Ev();
extern void _ZN7S1599C43v62Ev();
extern void _ZN7S1599C43v63Ev();
extern void _ZN7S1599C43v64Ev();
extern void _ZN7S1599C43v65Ev();
extern void _ZN7S1599C43v66Ev();
extern void _ZN7S1599C43v67Ev();
extern void _ZN7S1599C43v68Ev();
extern void _ZN7S1599C43v69Ev();
extern void _ZN7S1599C43v70Ev();
extern void _ZN7S1599C43v71Ev();
extern void _ZN7S1599C43v72Ev();
static  VTBL_ENTRY vtc_S1599C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1599C4[0]),
  (VTBL_ENTRY)&_ZN7S1599C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1599C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1599C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v72Ev,
};
extern VTBL_ENTRY _ZTI7S1599C4[];
extern  VTBL_ENTRY _ZTV7S1599C4[];
Class_Descriptor cd_S1599C4 = {  "S1599C4", // class name
  0,0,//no base classes
  &(vtc_S1599C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1599C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1599C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1599C3  : S1599C4 {
  unsigned int s1599c3f0:1;
  unsigned int s1599c3f1:1;
  unsigned int s1599c3f2:1;
  unsigned int s1599c3f3:1;
  unsigned int s1599c3f4:1;
  unsigned int s1599c3f5:1;
  unsigned int s1599c3f6:1;
  ::S3625C32 s1599c3f7;
  virtual  ~S1599C3(); // _ZN7S1599C3D1Ev
  virtual void  v73(); // _ZN7S1599C33v73Ev
  virtual void  v74(); // _ZN7S1599C33v74Ev
  virtual void  v75(); // _ZN7S1599C33v75Ev
  virtual void  v76(); // _ZN7S1599C33v76Ev
  virtual void  v77(); // _ZN7S1599C33v77Ev
  virtual void  v78(); // _ZN7S1599C33v78Ev
  virtual void  v79(); // _ZN7S1599C33v79Ev
  virtual void  v80(); // _ZN7S1599C33v80Ev
  virtual void  v81(); // _ZN7S1599C33v81Ev
  virtual void  v82(); // _ZN7S1599C33v82Ev
  virtual void  v83(); // _ZN7S1599C33v83Ev
  virtual void  v84(); // _ZN7S1599C33v84Ev
  virtual void  v85(); // _ZN7S1599C33v85Ev
  virtual void  v86(); // _ZN7S1599C33v86Ev
  virtual void  v87(); // _ZN7S1599C33v87Ev
  virtual void  v88(); // _ZN7S1599C33v88Ev
  virtual void  v89(); // _ZN7S1599C33v89Ev
  virtual void  v90(); // _ZN7S1599C33v90Ev
  virtual void  v91(); // _ZN7S1599C33v91Ev
  virtual void  v92(); // _ZN7S1599C33v92Ev
  S1599C3(); // tgen
};
//SIG(-1 S1599C3) C1{ BC2{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC4{ m}}


 S1599C3 ::~S1599C3(){ note_dtor("S1599C3", this);}
void  S1599C3 ::v73(){vfunc_called(this, "_ZN7S1599C33v73Ev");}
void  S1599C3 ::v74(){vfunc_called(this, "_ZN7S1599C33v74Ev");}
void  S1599C3 ::v75(){vfunc_called(this, "_ZN7S1599C33v75Ev");}
void  S1599C3 ::v76(){vfunc_called(this, "_ZN7S1599C33v76Ev");}
void  S1599C3 ::v77(){vfunc_called(this, "_ZN7S1599C33v77Ev");}
void  S1599C3 ::v78(){vfunc_called(this, "_ZN7S1599C33v78Ev");}
void  S1599C3 ::v79(){vfunc_called(this, "_ZN7S1599C33v79Ev");}
void  S1599C3 ::v80(){vfunc_called(this, "_ZN7S1599C33v80Ev");}
void  S1599C3 ::v81(){vfunc_called(this, "_ZN7S1599C33v81Ev");}
void  S1599C3 ::v82(){vfunc_called(this, "_ZN7S1599C33v82Ev");}
void  S1599C3 ::v83(){vfunc_called(this, "_ZN7S1599C33v83Ev");}
void  S1599C3 ::v84(){vfunc_called(this, "_ZN7S1599C33v84Ev");}
void  S1599C3 ::v85(){vfunc_called(this, "_ZN7S1599C33v85Ev");}
void  S1599C3 ::v86(){vfunc_called(this, "_ZN7S1599C33v86Ev");}
void  S1599C3 ::v87(){vfunc_called(this, "_ZN7S1599C33v87Ev");}
void  S1599C3 ::v88(){vfunc_called(this, "_ZN7S1599C33v88Ev");}
void  S1599C3 ::v89(){vfunc_called(this, "_ZN7S1599C33v89Ev");}
void  S1599C3 ::v90(){vfunc_called(this, "_ZN7S1599C33v90Ev");}
void  S1599C3 ::v91(){vfunc_called(this, "_ZN7S1599C33v91Ev");}
void  S1599C3 ::v92(){vfunc_called(this, "_ZN7S1599C33v92Ev");}
S1599C3 ::S1599C3(){ note_ctor("S1599C3", this);} // tgen

static void Test_S1599C3()
{
  extern Class_Descriptor cd_S1599C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S1599C3, buf);
    S1599C3 *dp, &lv = *(dp=new (buf) S1599C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S1599C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1599C3)");
    check_base_class_offset(lv, (S1599C4*), 0, "S1599C3");
    set_bf_and_test(lv, s1599c3f0, ABISELECT(96,60), 0, 1, 1, "S1599C3");
    set_bf_and_test(lv, s1599c3f1, ABISELECT(96,60), 1, 1, 1, "S1599C3");
    set_bf_and_test(lv, s1599c3f2, ABISELECT(96,60), 2, 1, 1, "S1599C3");
    set_bf_and_test(lv, s1599c3f3, ABISELECT(96,60), 3, 1, 1, "S1599C3");
    set_bf_and_test(lv, s1599c3f4, ABISELECT(96,60), 4, 1, 1, "S1599C3");
    set_bf_and_test(lv, s1599c3f5, ABISELECT(96,60), 5, 1, 1, "S1599C3");
    set_bf_and_test(lv, s1599c3f6, ABISELECT(96,60), 6, 1, 1, "S1599C3");
    check_field_offset(lv, s1599c3f7, ABISELECT(97,61), "S1599C3.s1599c3f7");
    test_class_info(&lv, &cd_S1599C3);
    dp->~S1599C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1599C3(Test_S1599C3, "S1599C3", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN7S1599C3C1Ev();
extern void _ZN7S1599C3D1Ev();
Name_Map name_map_S1599C3[] = {
  NSPAIR(_ZN7S1599C3C1Ev),
  NSPAIR(_ZN7S1599C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1599C4;
extern VTBL_ENTRY _ZTI7S1599C4[];
extern  VTBL_ENTRY _ZTV7S1599C4[];
static Base_Class bases_S1599C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1599C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1599C3[];
extern void _ZN7S1599C3D1Ev();
extern void _ZN7S1599C3D0Ev();
extern void _ZN7S1599C42v9Ev();
extern void _ZN7S1599C43v10Ev();
extern void _ZN7S1599C43v11Ev();
extern void _ZN7S1599C43v12Ev();
extern void _ZN7S1599C43v13Ev();
extern void _ZN7S1599C43v14Ev();
extern void _ZN7S1599C43v15Ev();
extern void _ZN7S1599C43v16Ev();
extern void _ZN7S1599C43v17Ev();
extern void _ZN7S1599C43v18Ev();
extern void _ZN7S1599C43v19Ev();
extern void _ZN7S1599C43v20Ev();
extern void _ZN7S1599C43v21Ev();
extern void _ZN7S1599C43v22Ev();
extern void _ZN7S1599C43v23Ev();
extern void _ZN7S1599C43v24Ev();
extern void _ZN7S1599C43v25Ev();
extern void _ZN7S1599C43v26Ev();
extern void _ZN7S1599C43v27Ev();
extern void _ZN7S1599C43v28Ev();
extern void _ZN7S1599C43v29Ev();
extern void _ZN7S1599C43v30Ev();
extern void _ZN7S1599C43v31Ev();
extern void _ZN7S1599C43v32Ev();
extern void _ZN7S1599C43v33Ev();
extern void _ZN7S1599C43v34Ev();
extern void _ZN7S1599C43v35Ev();
extern void _ZN7S1599C43v36Ev();
extern void _ZN7S1599C43v37Ev();
extern void _ZN7S1599C43v38Ev();
extern void _ZN7S1599C43v39Ev();
extern void _ZN7S1599C43v40Ev();
extern void _ZN7S1599C43v41Ev();
extern void _ZN7S1599C43v42Ev();
extern void _ZN7S1599C43v43Ev();
extern void _ZN7S1599C43v44Ev();
extern void _ZN7S1599C43v45Ev();
extern void _ZN7S1599C43v46Ev();
extern void _ZN7S1599C43v47Ev();
extern void _ZN7S1599C43v48Ev();
extern void _ZN7S1599C43v49Ev();
extern void _ZN7S1599C43v50Ev();
extern void _ZN7S1599C43v51Ev();
extern void _ZN7S1599C43v52Ev();
extern void _ZN7S1599C43v53Ev();
extern void _ZN7S1599C43v54Ev();
extern void _ZN7S1599C43v55Ev();
extern void _ZN7S1599C43v56Ev();
extern void _ZN7S1599C43v57Ev();
extern void _ZN7S1599C43v58Ev();
extern void _ZN7S1599C43v59Ev();
extern void _ZN7S1599C43v60Ev();
extern void _ZN7S1599C43v61Ev();
extern void _ZN7S1599C43v62Ev();
extern void _ZN7S1599C43v63Ev();
extern void _ZN7S1599C43v64Ev();
extern void _ZN7S1599C43v65Ev();
extern void _ZN7S1599C43v66Ev();
extern void _ZN7S1599C43v67Ev();
extern void _ZN7S1599C43v68Ev();
extern void _ZN7S1599C43v69Ev();
extern void _ZN7S1599C43v70Ev();
extern void _ZN7S1599C43v71Ev();
extern void _ZN7S1599C43v72Ev();
extern void _ZN7S1599C33v73Ev();
extern void _ZN7S1599C33v74Ev();
extern void _ZN7S1599C33v75Ev();
extern void _ZN7S1599C33v76Ev();
extern void _ZN7S1599C33v77Ev();
extern void _ZN7S1599C33v78Ev();
extern void _ZN7S1599C33v79Ev();
extern void _ZN7S1599C33v80Ev();
extern void _ZN7S1599C33v81Ev();
extern void _ZN7S1599C33v82Ev();
extern void _ZN7S1599C33v83Ev();
extern void _ZN7S1599C33v84Ev();
extern void _ZN7S1599C33v85Ev();
extern void _ZN7S1599C33v86Ev();
extern void _ZN7S1599C33v87Ev();
extern void _ZN7S1599C33v88Ev();
extern void _ZN7S1599C33v89Ev();
extern void _ZN7S1599C33v90Ev();
extern void _ZN7S1599C33v91Ev();
extern void _ZN7S1599C33v92Ev();
static  VTBL_ENTRY vtc_S1599C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1599C3[0]),
  (VTBL_ENTRY)&_ZN7S1599C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1599C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1599C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v92Ev,
};
extern VTBL_ENTRY _ZTI7S1599C3[];
extern  VTBL_ENTRY _ZTV7S1599C3[];
Class_Descriptor cd_S1599C3 = {  "S1599C3", // class name
  bases_S1599C3, 1,
  &(vtc_S1599C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI7S1599C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1599C3),88, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1599C2  : S1599C3 {
  ::S674C42 s1599c2f0;
  virtual  ~S1599C2(); // _ZN7S1599C2D1Ev
  virtual void  v93(); // _ZN7S1599C23v93Ev
  virtual void  v94(); // _ZN7S1599C23v94Ev
  virtual void  v95(); // _ZN7S1599C23v95Ev
  virtual void  v96(); // _ZN7S1599C23v96Ev
  S1599C2(); // tgen
};
//SIG(-1 S1599C2) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC5{ m}} vd v1 v2 v3 v4 FC6{ BC7{ BC8{ m Fp Fi[2]}}}}


 S1599C2 ::~S1599C2(){ note_dtor("S1599C2", this);}
void  S1599C2 ::v93(){vfunc_called(this, "_ZN7S1599C23v93Ev");}
void  S1599C2 ::v94(){vfunc_called(this, "_ZN7S1599C23v94Ev");}
void  S1599C2 ::v95(){vfunc_called(this, "_ZN7S1599C23v95Ev");}
void  S1599C2 ::v96(){vfunc_called(this, "_ZN7S1599C23v96Ev");}
S1599C2 ::S1599C2(){ note_ctor("S1599C2", this);} // tgen

static void Test_S1599C2()
{
  extern Class_Descriptor cd_S1599C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(16,20)];
    init_test(&cd_S1599C2, buf);
    S1599C2 *dp, &lv = *(dp=new (buf) S1599C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(120,76), "sizeof(S1599C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1599C2)");
    check_base_class_offset(lv, (S1599C4*)(S1599C3*), 0, "S1599C2");
    check_base_class_offset(lv, (S1599C3*), 0, "S1599C2");
    check_field_offset(lv, s1599c2f0, ABISELECT(104,64), "S1599C2.s1599c2f0");
    test_class_info(&lv, &cd_S1599C2);
    dp->~S1599C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1599C2(Test_S1599C2, "S1599C2", ABISELECT(120,76));

#else // __cplusplus

extern void _ZN7S1599C2C1Ev();
extern void _ZN7S1599C2D1Ev();
Name_Map name_map_S1599C2[] = {
  NSPAIR(_ZN7S1599C2C1Ev),
  NSPAIR(_ZN7S1599C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1599C4;
extern VTBL_ENTRY _ZTI7S1599C4[];
extern  VTBL_ENTRY _ZTV7S1599C4[];
extern Class_Descriptor cd_S1599C3;
extern VTBL_ENTRY _ZTI7S1599C3[];
extern  VTBL_ENTRY _ZTV7S1599C3[];
static Base_Class bases_S1599C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1599C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1599C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1599C2[];
extern void _ZN7S1599C2D1Ev();
extern void _ZN7S1599C2D0Ev();
extern void _ZN7S1599C42v9Ev();
extern void _ZN7S1599C43v10Ev();
extern void _ZN7S1599C43v11Ev();
extern void _ZN7S1599C43v12Ev();
extern void _ZN7S1599C43v13Ev();
extern void _ZN7S1599C43v14Ev();
extern void _ZN7S1599C43v15Ev();
extern void _ZN7S1599C43v16Ev();
extern void _ZN7S1599C43v17Ev();
extern void _ZN7S1599C43v18Ev();
extern void _ZN7S1599C43v19Ev();
extern void _ZN7S1599C43v20Ev();
extern void _ZN7S1599C43v21Ev();
extern void _ZN7S1599C43v22Ev();
extern void _ZN7S1599C43v23Ev();
extern void _ZN7S1599C43v24Ev();
extern void _ZN7S1599C43v25Ev();
extern void _ZN7S1599C43v26Ev();
extern void _ZN7S1599C43v27Ev();
extern void _ZN7S1599C43v28Ev();
extern void _ZN7S1599C43v29Ev();
extern void _ZN7S1599C43v30Ev();
extern void _ZN7S1599C43v31Ev();
extern void _ZN7S1599C43v32Ev();
extern void _ZN7S1599C43v33Ev();
extern void _ZN7S1599C43v34Ev();
extern void _ZN7S1599C43v35Ev();
extern void _ZN7S1599C43v36Ev();
extern void _ZN7S1599C43v37Ev();
extern void _ZN7S1599C43v38Ev();
extern void _ZN7S1599C43v39Ev();
extern void _ZN7S1599C43v40Ev();
extern void _ZN7S1599C43v41Ev();
extern void _ZN7S1599C43v42Ev();
extern void _ZN7S1599C43v43Ev();
extern void _ZN7S1599C43v44Ev();
extern void _ZN7S1599C43v45Ev();
extern void _ZN7S1599C43v46Ev();
extern void _ZN7S1599C43v47Ev();
extern void _ZN7S1599C43v48Ev();
extern void _ZN7S1599C43v49Ev();
extern void _ZN7S1599C43v50Ev();
extern void _ZN7S1599C43v51Ev();
extern void _ZN7S1599C43v52Ev();
extern void _ZN7S1599C43v53Ev();
extern void _ZN7S1599C43v54Ev();
extern void _ZN7S1599C43v55Ev();
extern void _ZN7S1599C43v56Ev();
extern void _ZN7S1599C43v57Ev();
extern void _ZN7S1599C43v58Ev();
extern void _ZN7S1599C43v59Ev();
extern void _ZN7S1599C43v60Ev();
extern void _ZN7S1599C43v61Ev();
extern void _ZN7S1599C43v62Ev();
extern void _ZN7S1599C43v63Ev();
extern void _ZN7S1599C43v64Ev();
extern void _ZN7S1599C43v65Ev();
extern void _ZN7S1599C43v66Ev();
extern void _ZN7S1599C43v67Ev();
extern void _ZN7S1599C43v68Ev();
extern void _ZN7S1599C43v69Ev();
extern void _ZN7S1599C43v70Ev();
extern void _ZN7S1599C43v71Ev();
extern void _ZN7S1599C43v72Ev();
extern void _ZN7S1599C33v73Ev();
extern void _ZN7S1599C33v74Ev();
extern void _ZN7S1599C33v75Ev();
extern void _ZN7S1599C33v76Ev();
extern void _ZN7S1599C33v77Ev();
extern void _ZN7S1599C33v78Ev();
extern void _ZN7S1599C33v79Ev();
extern void _ZN7S1599C33v80Ev();
extern void _ZN7S1599C33v81Ev();
extern void _ZN7S1599C33v82Ev();
extern void _ZN7S1599C33v83Ev();
extern void _ZN7S1599C33v84Ev();
extern void _ZN7S1599C33v85Ev();
extern void _ZN7S1599C33v86Ev();
extern void _ZN7S1599C33v87Ev();
extern void _ZN7S1599C33v88Ev();
extern void _ZN7S1599C33v89Ev();
extern void _ZN7S1599C33v90Ev();
extern void _ZN7S1599C33v91Ev();
extern void _ZN7S1599C33v92Ev();
extern void _ZN7S1599C23v93Ev();
extern void _ZN7S1599C23v94Ev();
extern void _ZN7S1599C23v95Ev();
extern void _ZN7S1599C23v96Ev();
static  VTBL_ENTRY vtc_S1599C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1599C2[0]),
  (VTBL_ENTRY)&_ZN7S1599C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1599C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1599C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1599C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1599C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1599C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1599C23v96Ev,
};
extern VTBL_ENTRY _ZTI7S1599C2[];
extern  VTBL_ENTRY _ZTV7S1599C2[];
Class_Descriptor cd_S1599C2 = {  "S1599C2", // class name
  bases_S1599C2, 2,
  &(vtc_S1599C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(120,76), // object size
  NSPAIRA(_ZTI7S1599C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1599C2),92, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1599C1  : S1599C2 {
  ::S1292C12 s1599c1f0;
  ::S1289C10_nt s1599c1f1;
  ::S1289C10_nt s1599c1f2;
  unsigned int s1599c1f3:1;
  unsigned int s1599c1f4:1;
  unsigned int s1599c1f5:1;
  unsigned int s1599c1f6:1;
  ::S1289C10_nt s1599c1f7;
  ::S1289C10_nt s1599c1f8;
  ::S1292C12 s1599c1f9;
  virtual  ~S1599C1(); // _ZN7S1599C1D1Ev
  virtual void  v1(); // _ZN7S1599C12v1Ev
  virtual void  v2(); // _ZN7S1599C12v2Ev
  virtual void  v3(); // _ZN7S1599C12v3Ev
  virtual void  v4(); // _ZN7S1599C12v4Ev
  virtual void  v5(); // _ZN7S1599C12v5Ev
  virtual void  v6(); // _ZN7S1599C12v6Ev
  virtual void  v7(); // _ZN7S1599C12v7Ev
  virtual void  v8(); // _ZN7S1599C12v8Ev
  S1599C1(); // tgen
};
//SIG(1 S1599C1) C1{ BC2{ BC3{ BC4{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC6{ m}} vd v93 v94 v95 v96 FC7{ BC8{ BC9{ m Fp Fi[2]}}}} vd v1 v2 v3 v4 v5 v6 v7 v8 FC10{ BC11{ m Fc[4] FC12{ BC13{ BC9}} Fi[2]} Fp} FC14{ BC11 Fp} FC14 Fi:1 Fi:1 Fi:1 Fi:1 FC14 FC14 FC10}


 S1599C1 ::~S1599C1(){ note_dtor("S1599C1", this);}
void  S1599C1 ::v1(){vfunc_called(this, "_ZN7S1599C12v1Ev");}
void  S1599C1 ::v2(){vfunc_called(this, "_ZN7S1599C12v2Ev");}
void  S1599C1 ::v3(){vfunc_called(this, "_ZN7S1599C12v3Ev");}
void  S1599C1 ::v4(){vfunc_called(this, "_ZN7S1599C12v4Ev");}
void  S1599C1 ::v5(){vfunc_called(this, "_ZN7S1599C12v5Ev");}
void  S1599C1 ::v6(){vfunc_called(this, "_ZN7S1599C12v6Ev");}
void  S1599C1 ::v7(){vfunc_called(this, "_ZN7S1599C12v7Ev");}
void  S1599C1 ::v8(){vfunc_called(this, "_ZN7S1599C12v8Ev");}
S1599C1 ::S1599C1(){ note_ctor("S1599C1", this);} // tgen

static void Test_S1599C1()
{
  extern Class_Descriptor cd_S1599C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(47,63)];
    init_test(&cd_S1599C1, buf);
    S1599C1 *dp, &lv = *(dp=new (buf) S1599C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(368,248), "sizeof(S1599C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1599C1)");
    check_base_class_offset(lv, (S1599C4*)(S1599C3*)(S1599C2*), 0, "S1599C1");
    check_base_class_offset(lv, (S1599C3*)(S1599C2*), 0, "S1599C1");
    check_base_class_offset(lv, (S1599C2*), 0, "S1599C1");
    check_field_offset(lv, s1599c1f0, ABISELECT(120,76), "S1599C1.s1599c1f0");
    check_field_offset(lv, s1599c1f1, ABISELECT(160,104), "S1599C1.s1599c1f1");
    check_field_offset(lv, s1599c1f2, ABISELECT(200,132), "S1599C1.s1599c1f2");
    set_bf_and_test(lv, s1599c1f3, ABISELECT(240,160), 0, 1, 1, "S1599C1");
    set_bf_and_test(lv, s1599c1f4, ABISELECT(240,160), 1, 1, 1, "S1599C1");
    set_bf_and_test(lv, s1599c1f5, ABISELECT(240,160), 2, 1, 1, "S1599C1");
    set_bf_and_test(lv, s1599c1f6, ABISELECT(240,160), 3, 1, 1, "S1599C1");
    check_field_offset(lv, s1599c1f7, ABISELECT(248,164), "S1599C1.s1599c1f7");
    check_field_offset(lv, s1599c1f8, ABISELECT(288,192), "S1599C1.s1599c1f8");
    check_field_offset(lv, s1599c1f9, ABISELECT(328,220), "S1599C1.s1599c1f9");
    test_class_info(&lv, &cd_S1599C1);
    dp->~S1599C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1599C1(Test_S1599C1, "S1599C1", ABISELECT(368,248));

#else // __cplusplus

extern void _ZN7S1599C1C1Ev();
extern void _ZN7S1599C1D1Ev();
Name_Map name_map_S1599C1[] = {
  NSPAIR(_ZN7S1599C1C1Ev),
  NSPAIR(_ZN7S1599C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1599C4;
extern VTBL_ENTRY _ZTI7S1599C4[];
extern  VTBL_ENTRY _ZTV7S1599C4[];
extern Class_Descriptor cd_S1599C3;
extern VTBL_ENTRY _ZTI7S1599C3[];
extern  VTBL_ENTRY _ZTV7S1599C3[];
extern Class_Descriptor cd_S1599C2;
extern VTBL_ENTRY _ZTI7S1599C2[];
extern  VTBL_ENTRY _ZTV7S1599C2[];
static Base_Class bases_S1599C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1599C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1599C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1599C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1599C1[];
extern void _ZN7S1599C1D1Ev();
extern void _ZN7S1599C1D0Ev();
extern void _ZN7S1599C42v9Ev();
extern void _ZN7S1599C43v10Ev();
extern void _ZN7S1599C43v11Ev();
extern void _ZN7S1599C43v12Ev();
extern void _ZN7S1599C43v13Ev();
extern void _ZN7S1599C43v14Ev();
extern void _ZN7S1599C43v15Ev();
extern void _ZN7S1599C43v16Ev();
extern void _ZN7S1599C43v17Ev();
extern void _ZN7S1599C43v18Ev();
extern void _ZN7S1599C43v19Ev();
extern void _ZN7S1599C43v20Ev();
extern void _ZN7S1599C43v21Ev();
extern void _ZN7S1599C43v22Ev();
extern void _ZN7S1599C43v23Ev();
extern void _ZN7S1599C43v24Ev();
extern void _ZN7S1599C43v25Ev();
extern void _ZN7S1599C43v26Ev();
extern void _ZN7S1599C43v27Ev();
extern void _ZN7S1599C43v28Ev();
extern void _ZN7S1599C43v29Ev();
extern void _ZN7S1599C43v30Ev();
extern void _ZN7S1599C43v31Ev();
extern void _ZN7S1599C43v32Ev();
extern void _ZN7S1599C43v33Ev();
extern void _ZN7S1599C43v34Ev();
extern void _ZN7S1599C43v35Ev();
extern void _ZN7S1599C43v36Ev();
extern void _ZN7S1599C43v37Ev();
extern void _ZN7S1599C43v38Ev();
extern void _ZN7S1599C43v39Ev();
extern void _ZN7S1599C43v40Ev();
extern void _ZN7S1599C43v41Ev();
extern void _ZN7S1599C43v42Ev();
extern void _ZN7S1599C43v43Ev();
extern void _ZN7S1599C43v44Ev();
extern void _ZN7S1599C43v45Ev();
extern void _ZN7S1599C43v46Ev();
extern void _ZN7S1599C43v47Ev();
extern void _ZN7S1599C43v48Ev();
extern void _ZN7S1599C43v49Ev();
extern void _ZN7S1599C43v50Ev();
extern void _ZN7S1599C43v51Ev();
extern void _ZN7S1599C43v52Ev();
extern void _ZN7S1599C43v53Ev();
extern void _ZN7S1599C43v54Ev();
extern void _ZN7S1599C43v55Ev();
extern void _ZN7S1599C43v56Ev();
extern void _ZN7S1599C43v57Ev();
extern void _ZN7S1599C43v58Ev();
extern void _ZN7S1599C43v59Ev();
extern void _ZN7S1599C43v60Ev();
extern void _ZN7S1599C43v61Ev();
extern void _ZN7S1599C43v62Ev();
extern void _ZN7S1599C43v63Ev();
extern void _ZN7S1599C43v64Ev();
extern void _ZN7S1599C43v65Ev();
extern void _ZN7S1599C43v66Ev();
extern void _ZN7S1599C43v67Ev();
extern void _ZN7S1599C43v68Ev();
extern void _ZN7S1599C43v69Ev();
extern void _ZN7S1599C43v70Ev();
extern void _ZN7S1599C43v71Ev();
extern void _ZN7S1599C43v72Ev();
extern void _ZN7S1599C33v73Ev();
extern void _ZN7S1599C33v74Ev();
extern void _ZN7S1599C33v75Ev();
extern void _ZN7S1599C33v76Ev();
extern void _ZN7S1599C33v77Ev();
extern void _ZN7S1599C33v78Ev();
extern void _ZN7S1599C33v79Ev();
extern void _ZN7S1599C33v80Ev();
extern void _ZN7S1599C33v81Ev();
extern void _ZN7S1599C33v82Ev();
extern void _ZN7S1599C33v83Ev();
extern void _ZN7S1599C33v84Ev();
extern void _ZN7S1599C33v85Ev();
extern void _ZN7S1599C33v86Ev();
extern void _ZN7S1599C33v87Ev();
extern void _ZN7S1599C33v88Ev();
extern void _ZN7S1599C33v89Ev();
extern void _ZN7S1599C33v90Ev();
extern void _ZN7S1599C33v91Ev();
extern void _ZN7S1599C33v92Ev();
extern void _ZN7S1599C23v93Ev();
extern void _ZN7S1599C23v94Ev();
extern void _ZN7S1599C23v95Ev();
extern void _ZN7S1599C23v96Ev();
extern void _ZN7S1599C12v1Ev();
extern void _ZN7S1599C12v2Ev();
extern void _ZN7S1599C12v3Ev();
extern void _ZN7S1599C12v4Ev();
extern void _ZN7S1599C12v5Ev();
extern void _ZN7S1599C12v6Ev();
extern void _ZN7S1599C12v7Ev();
extern void _ZN7S1599C12v8Ev();
static  VTBL_ENTRY vtc_S1599C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1599C1[0]),
  (VTBL_ENTRY)&_ZN7S1599C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1599C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1599C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1599C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1599C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1599C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1599C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1599C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1599C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1599C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1599C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1599C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1599C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1599C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1599C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1599C12v7Ev,
  (VTBL_ENTRY)&_ZN7S1599C12v8Ev,
};
extern VTBL_ENTRY _ZTI7S1599C1[];
extern  VTBL_ENTRY _ZTV7S1599C1[];
Class_Descriptor cd_S1599C1 = {  "S1599C1", // class name
  bases_S1599C1, 3,
  &(vtc_S1599C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(368,248), // object size
  NSPAIRA(_ZTI7S1599C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1599C1),100, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S666C5  {
  int s666c5f0;
  __tsi64 s666c5f1;
  void *s666c5f2[4];
  int s666c5f3[2];
  void *s666c5f4;
  ::S674C6_nt s666c5f5;
  void *s666c5f6[2];
  virtual  ~S666C5(); // _ZN6S666C5D1Ev
  virtual void  v6(); // _ZN6S666C52v6Ev
  virtual void  v7(); // _ZN6S666C52v7Ev
  virtual void  v8(); // _ZN6S666C52v8Ev
  virtual void  v9(); // _ZN6S666C52v9Ev
  virtual void  v10(); // _ZN6S666C53v10Ev
  virtual void  v11(); // _ZN6S666C53v11Ev
  virtual void  v12(); // _ZN6S666C53v12Ev
  virtual void  v13(); // _ZN6S666C53v13Ev
  virtual void  v14(); // _ZN6S666C53v14Ev
  virtual void  v15(); // _ZN6S666C53v15Ev
  virtual void  v16(); // _ZN6S666C53v16Ev
  virtual void  v17(); // _ZN6S666C53v17Ev
  virtual void  v18(); // _ZN6S666C53v18Ev
  virtual void  v19(); // _ZN6S666C53v19Ev
  virtual void  v20(); // _ZN6S666C53v20Ev
  virtual void  v21(); // _ZN6S666C53v21Ev
  virtual void  v22(); // _ZN6S666C53v22Ev
  virtual void  v23(); // _ZN6S666C53v23Ev
  virtual void  v24(); // _ZN6S666C53v24Ev
  virtual void  v25(); // _ZN6S666C53v25Ev
  virtual void  v26(); // _ZN6S666C53v26Ev
  virtual void  v27(); // _ZN6S666C53v27Ev
  virtual void  v28(); // _ZN6S666C53v28Ev
  virtual void  v29(); // _ZN6S666C53v29Ev
  virtual void  v30(); // _ZN6S666C53v30Ev
  virtual void  v31(); // _ZN6S666C53v31Ev
  virtual void  v32(); // _ZN6S666C53v32Ev
  virtual void  v33(); // _ZN6S666C53v33Ev
  virtual void  v34(); // _ZN6S666C53v34Ev
  virtual void  v35(); // _ZN6S666C53v35Ev
  virtual void  v36(); // _ZN6S666C53v36Ev
  virtual void  v37(); // _ZN6S666C53v37Ev
  virtual void  v38(); // _ZN6S666C53v38Ev
  virtual void  v39(); // _ZN6S666C53v39Ev
  virtual void  v40(); // _ZN6S666C53v40Ev
  virtual void  v41(); // _ZN6S666C53v41Ev
  virtual void  v42(); // _ZN6S666C53v42Ev
  virtual void  v43(); // _ZN6S666C53v43Ev
  virtual void  v44(); // _ZN6S666C53v44Ev
  virtual void  v45(); // _ZN6S666C53v45Ev
  virtual void  v46(); // _ZN6S666C53v46Ev
  virtual void  v47(); // _ZN6S666C53v47Ev
  virtual void  v48(); // _ZN6S666C53v48Ev
  virtual void  v49(); // _ZN6S666C53v49Ev
  virtual void  v50(); // _ZN6S666C53v50Ev
  virtual void  v51(); // _ZN6S666C53v51Ev
  virtual void  v52(); // _ZN6S666C53v52Ev
  virtual void  v53(); // _ZN6S666C53v53Ev
  virtual void  v54(); // _ZN6S666C53v54Ev
  virtual void  v55(); // _ZN6S666C53v55Ev
  virtual void  v56(); // _ZN6S666C53v56Ev
  virtual void  v57(); // _ZN6S666C53v57Ev
  virtual void  v58(); // _ZN6S666C53v58Ev
  virtual void  v59(); // _ZN6S666C53v59Ev
  virtual void  v60(); // _ZN6S666C53v60Ev
  virtual void  v61(); // _ZN6S666C53v61Ev
  virtual void  v62(); // _ZN6S666C53v62Ev
  virtual void  v63(); // _ZN6S666C53v63Ev
  virtual void  v64(); // _ZN6S666C53v64Ev
  virtual void  v65(); // _ZN6S666C53v65Ev
  virtual void  v66(); // _ZN6S666C53v66Ev
  virtual void  v67(); // _ZN6S666C53v67Ev
  virtual void  v68(); // _ZN6S666C53v68Ev
  virtual void  v69(); // _ZN6S666C53v69Ev
  S666C5(); // tgen
};
//SIG(-1 S666C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S666C5 ::~S666C5(){ note_dtor("S666C5", this);}
void  S666C5 ::v6(){vfunc_called(this, "_ZN6S666C52v6Ev");}
void  S666C5 ::v7(){vfunc_called(this, "_ZN6S666C52v7Ev");}
void  S666C5 ::v8(){vfunc_called(this, "_ZN6S666C52v8Ev");}
void  S666C5 ::v9(){vfunc_called(this, "_ZN6S666C52v9Ev");}
void  S666C5 ::v10(){vfunc_called(this, "_ZN6S666C53v10Ev");}
void  S666C5 ::v11(){vfunc_called(this, "_ZN6S666C53v11Ev");}
void  S666C5 ::v12(){vfunc_called(this, "_ZN6S666C53v12Ev");}
void  S666C5 ::v13(){vfunc_called(this, "_ZN6S666C53v13Ev");}
void  S666C5 ::v14(){vfunc_called(this, "_ZN6S666C53v14Ev");}
void  S666C5 ::v15(){vfunc_called(this, "_ZN6S666C53v15Ev");}
void  S666C5 ::v16(){vfunc_called(this, "_ZN6S666C53v16Ev");}
void  S666C5 ::v17(){vfunc_called(this, "_ZN6S666C53v17Ev");}
void  S666C5 ::v18(){vfunc_called(this, "_ZN6S666C53v18Ev");}
void  S666C5 ::v19(){vfunc_called(this, "_ZN6S666C53v19Ev");}
void  S666C5 ::v20(){vfunc_called(this, "_ZN6S666C53v20Ev");}
void  S666C5 ::v21(){vfunc_called(this, "_ZN6S666C53v21Ev");}
void  S666C5 ::v22(){vfunc_called(this, "_ZN6S666C53v22Ev");}
void  S666C5 ::v23(){vfunc_called(this, "_ZN6S666C53v23Ev");}
void  S666C5 ::v24(){vfunc_called(this, "_ZN6S666C53v24Ev");}
void  S666C5 ::v25(){vfunc_called(this, "_ZN6S666C53v25Ev");}
void  S666C5 ::v26(){vfunc_called(this, "_ZN6S666C53v26Ev");}
void  S666C5 ::v27(){vfunc_called(this, "_ZN6S666C53v27Ev");}
void  S666C5 ::v28(){vfunc_called(this, "_ZN6S666C53v28Ev");}
void  S666C5 ::v29(){vfunc_called(this, "_ZN6S666C53v29Ev");}
void  S666C5 ::v30(){vfunc_called(this, "_ZN6S666C53v30Ev");}
void  S666C5 ::v31(){vfunc_called(this, "_ZN6S666C53v31Ev");}
void  S666C5 ::v32(){vfunc_called(this, "_ZN6S666C53v32Ev");}
void  S666C5 ::v33(){vfunc_called(this, "_ZN6S666C53v33Ev");}
void  S666C5 ::v34(){vfunc_called(this, "_ZN6S666C53v34Ev");}
void  S666C5 ::v35(){vfunc_called(this, "_ZN6S666C53v35Ev");}
void  S666C5 ::v36(){vfunc_called(this, "_ZN6S666C53v36Ev");}
void  S666C5 ::v37(){vfunc_called(this, "_ZN6S666C53v37Ev");}
void  S666C5 ::v38(){vfunc_called(this, "_ZN6S666C53v38Ev");}
void  S666C5 ::v39(){vfunc_called(this, "_ZN6S666C53v39Ev");}
void  S666C5 ::v40(){vfunc_called(this, "_ZN6S666C53v40Ev");}
void  S666C5 ::v41(){vfunc_called(this, "_ZN6S666C53v41Ev");}
void  S666C5 ::v42(){vfunc_called(this, "_ZN6S666C53v42Ev");}
void  S666C5 ::v43(){vfunc_called(this, "_ZN6S666C53v43Ev");}
void  S666C5 ::v44(){vfunc_called(this, "_ZN6S666C53v44Ev");}
void  S666C5 ::v45(){vfunc_called(this, "_ZN6S666C53v45Ev");}
void  S666C5 ::v46(){vfunc_called(this, "_ZN6S666C53v46Ev");}
void  S666C5 ::v47(){vfunc_called(this, "_ZN6S666C53v47Ev");}
void  S666C5 ::v48(){vfunc_called(this, "_ZN6S666C53v48Ev");}
void  S666C5 ::v49(){vfunc_called(this, "_ZN6S666C53v49Ev");}
void  S666C5 ::v50(){vfunc_called(this, "_ZN6S666C53v50Ev");}
void  S666C5 ::v51(){vfunc_called(this, "_ZN6S666C53v51Ev");}
void  S666C5 ::v52(){vfunc_called(this, "_ZN6S666C53v52Ev");}
void  S666C5 ::v53(){vfunc_called(this, "_ZN6S666C53v53Ev");}
void  S666C5 ::v54(){vfunc_called(this, "_ZN6S666C53v54Ev");}
void  S666C5 ::v55(){vfunc_called(this, "_ZN6S666C53v55Ev");}
void  S666C5 ::v56(){vfunc_called(this, "_ZN6S666C53v56Ev");}
void  S666C5 ::v57(){vfunc_called(this, "_ZN6S666C53v57Ev");}
void  S666C5 ::v58(){vfunc_called(this, "_ZN6S666C53v58Ev");}
void  S666C5 ::v59(){vfunc_called(this, "_ZN6S666C53v59Ev");}
void  S666C5 ::v60(){vfunc_called(this, "_ZN6S666C53v60Ev");}
void  S666C5 ::v61(){vfunc_called(this, "_ZN6S666C53v61Ev");}
void  S666C5 ::v62(){vfunc_called(this, "_ZN6S666C53v62Ev");}
void  S666C5 ::v63(){vfunc_called(this, "_ZN6S666C53v63Ev");}
void  S666C5 ::v64(){vfunc_called(this, "_ZN6S666C53v64Ev");}
void  S666C5 ::v65(){vfunc_called(this, "_ZN6S666C53v65Ev");}
void  S666C5 ::v66(){vfunc_called(this, "_ZN6S666C53v66Ev");}
void  S666C5 ::v67(){vfunc_called(this, "_ZN6S666C53v67Ev");}
void  S666C5 ::v68(){vfunc_called(this, "_ZN6S666C53v68Ev");}
void  S666C5 ::v69(){vfunc_called(this, "_ZN6S666C53v69Ev");}
S666C5 ::S666C5(){ note_ctor("S666C5", this);} // tgen

static void Test_S666C5()
{
  extern Class_Descriptor cd_S666C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S666C5, buf);
    S666C5 *dp, &lv = *(dp=new (buf) S666C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S666C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S666C5)");
    check_field_offset(lv, s666c5f0, ABISELECT(8,4), "S666C5.s666c5f0");
    check_field_offset(lv, s666c5f1, ABISELECT(16,8), "S666C5.s666c5f1");
    check_field_offset(lv, s666c5f2, ABISELECT(24,16), "S666C5.s666c5f2");
    check_field_offset(lv, s666c5f3, ABISELECT(56,32), "S666C5.s666c5f3");
    check_field_offset(lv, s666c5f4, ABISELECT(64,40), "S666C5.s666c5f4");
    check_field_offset(lv, s666c5f5, ABISELECT(72,44), "S666C5.s666c5f5");
    check_field_offset(lv, s666c5f6, ABISELECT(80,52), "S666C5.s666c5f6");
    test_class_info(&lv, &cd_S666C5);
    dp->~S666C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS666C5(Test_S666C5, "S666C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S666C5C1Ev();
extern void _ZN6S666C5D1Ev();
Name_Map name_map_S666C5[] = {
  NSPAIR(_ZN6S666C5C1Ev),
  NSPAIR(_ZN6S666C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S666C5[];
extern void _ZN6S666C5D1Ev();
extern void _ZN6S666C5D0Ev();
extern void _ZN6S666C52v6Ev();
extern void _ZN6S666C52v7Ev();
extern void _ZN6S666C52v8Ev();
extern void _ZN6S666C52v9Ev();
extern void _ZN6S666C53v10Ev();
extern void _ZN6S666C53v11Ev();
extern void _ZN6S666C53v12Ev();
extern void _ZN6S666C53v13Ev();
extern void _ZN6S666C53v14Ev();
extern void _ZN6S666C53v15Ev();
extern void _ZN6S666C53v16Ev();
extern void _ZN6S666C53v17Ev();
extern void _ZN6S666C53v18Ev();
extern void _ZN6S666C53v19Ev();
extern void _ZN6S666C53v20Ev();
extern void _ZN6S666C53v21Ev();
extern void _ZN6S666C53v22Ev();
extern void _ZN6S666C53v23Ev();
extern void _ZN6S666C53v24Ev();
extern void _ZN6S666C53v25Ev();
extern void _ZN6S666C53v26Ev();
extern void _ZN6S666C53v27Ev();
extern void _ZN6S666C53v28Ev();
extern void _ZN6S666C53v29Ev();
extern void _ZN6S666C53v30Ev();
extern void _ZN6S666C53v31Ev();
extern void _ZN6S666C53v32Ev();
extern void _ZN6S666C53v33Ev();
extern void _ZN6S666C53v34Ev();
extern void _ZN6S666C53v35Ev();
extern void _ZN6S666C53v36Ev();
extern void _ZN6S666C53v37Ev();
extern void _ZN6S666C53v38Ev();
extern void _ZN6S666C53v39Ev();
extern void _ZN6S666C53v40Ev();
extern void _ZN6S666C53v41Ev();
extern void _ZN6S666C53v42Ev();
extern void _ZN6S666C53v43Ev();
extern void _ZN6S666C53v44Ev();
extern void _ZN6S666C53v45Ev();
extern void _ZN6S666C53v46Ev();
extern void _ZN6S666C53v47Ev();
extern void _ZN6S666C53v48Ev();
extern void _ZN6S666C53v49Ev();
extern void _ZN6S666C53v50Ev();
extern void _ZN6S666C53v51Ev();
extern void _ZN6S666C53v52Ev();
extern void _ZN6S666C53v53Ev();
extern void _ZN6S666C53v54Ev();
extern void _ZN6S666C53v55Ev();
extern void _ZN6S666C53v56Ev();
extern void _ZN6S666C53v57Ev();
extern void _ZN6S666C53v58Ev();
extern void _ZN6S666C53v59Ev();
extern void _ZN6S666C53v60Ev();
extern void _ZN6S666C53v61Ev();
extern void _ZN6S666C53v62Ev();
extern void _ZN6S666C53v63Ev();
extern void _ZN6S666C53v64Ev();
extern void _ZN6S666C53v65Ev();
extern void _ZN6S666C53v66Ev();
extern void _ZN6S666C53v67Ev();
extern void _ZN6S666C53v68Ev();
extern void _ZN6S666C53v69Ev();
static  VTBL_ENTRY vtc_S666C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S666C5[0]),
  (VTBL_ENTRY)&_ZN6S666C5D1Ev,
  (VTBL_ENTRY)&_ZN6S666C5D0Ev,
  (VTBL_ENTRY)&_ZN6S666C52v6Ev,
  (VTBL_ENTRY)&_ZN6S666C52v7Ev,
  (VTBL_ENTRY)&_ZN6S666C52v8Ev,
  (VTBL_ENTRY)&_ZN6S666C52v9Ev,
  (VTBL_ENTRY)&_ZN6S666C53v10Ev,
  (VTBL_ENTRY)&_ZN6S666C53v11Ev,
  (VTBL_ENTRY)&_ZN6S666C53v12Ev,
  (VTBL_ENTRY)&_ZN6S666C53v13Ev,
  (VTBL_ENTRY)&_ZN6S666C53v14Ev,
  (VTBL_ENTRY)&_ZN6S666C53v15Ev,
  (VTBL_ENTRY)&_ZN6S666C53v16Ev,
  (VTBL_ENTRY)&_ZN6S666C53v17Ev,
  (VTBL_ENTRY)&_ZN6S666C53v18Ev,
  (VTBL_ENTRY)&_ZN6S666C53v19Ev,
  (VTBL_ENTRY)&_ZN6S666C53v20Ev,
  (VTBL_ENTRY)&_ZN6S666C53v21Ev,
  (VTBL_ENTRY)&_ZN6S666C53v22Ev,
  (VTBL_ENTRY)&_ZN6S666C53v23Ev,
  (VTBL_ENTRY)&_ZN6S666C53v24Ev,
  (VTBL_ENTRY)&_ZN6S666C53v25Ev,
  (VTBL_ENTRY)&_ZN6S666C53v26Ev,
  (VTBL_ENTRY)&_ZN6S666C53v27Ev,
  (VTBL_ENTRY)&_ZN6S666C53v28Ev,
  (VTBL_ENTRY)&_ZN6S666C53v29Ev,
  (VTBL_ENTRY)&_ZN6S666C53v30Ev,
  (VTBL_ENTRY)&_ZN6S666C53v31Ev,
  (VTBL_ENTRY)&_ZN6S666C53v32Ev,
  (VTBL_ENTRY)&_ZN6S666C53v33Ev,
  (VTBL_ENTRY)&_ZN6S666C53v34Ev,
  (VTBL_ENTRY)&_ZN6S666C53v35Ev,
  (VTBL_ENTRY)&_ZN6S666C53v36Ev,
  (VTBL_ENTRY)&_ZN6S666C53v37Ev,
  (VTBL_ENTRY)&_ZN6S666C53v38Ev,
  (VTBL_ENTRY)&_ZN6S666C53v39Ev,
  (VTBL_ENTRY)&_ZN6S666C53v40Ev,
  (VTBL_ENTRY)&_ZN6S666C53v41Ev,
  (VTBL_ENTRY)&_ZN6S666C53v42Ev,
  (VTBL_ENTRY)&_ZN6S666C53v43Ev,
  (VTBL_ENTRY)&_ZN6S666C53v44Ev,
  (VTBL_ENTRY)&_ZN6S666C53v45Ev,
  (VTBL_ENTRY)&_ZN6S666C53v46Ev,
  (VTBL_ENTRY)&_ZN6S666C53v47Ev,
  (VTBL_ENTRY)&_ZN6S666C53v48Ev,
  (VTBL_ENTRY)&_ZN6S666C53v49Ev,
  (VTBL_ENTRY)&_ZN6S666C53v50Ev,
  (VTBL_ENTRY)&_ZN6S666C53v51Ev,
  (VTBL_ENTRY)&_ZN6S666C53v52Ev,
  (VTBL_ENTRY)&_ZN6S666C53v53Ev,
  (VTBL_ENTRY)&_ZN6S666C53v54Ev,
  (VTBL_ENTRY)&_ZN6S666C53v55Ev,
  (VTBL_ENTRY)&_ZN6S666C53v56Ev,
  (VTBL_ENTRY)&_ZN6S666C53v57Ev,
  (VTBL_ENTRY)&_ZN6S666C53v58Ev,
  (VTBL_ENTRY)&_ZN6S666C53v59Ev,
  (VTBL_ENTRY)&_ZN6S666C53v60Ev,
  (VTBL_ENTRY)&_ZN6S666C53v61Ev,
  (VTBL_ENTRY)&_ZN6S666C53v62Ev,
  (VTBL_ENTRY)&_ZN6S666C53v63Ev,
  (VTBL_ENTRY)&_ZN6S666C53v64Ev,
  (VTBL_ENTRY)&_ZN6S666C53v65Ev,
  (VTBL_ENTRY)&_ZN6S666C53v66Ev,
  (VTBL_ENTRY)&_ZN6S666C53v67Ev,
  (VTBL_ENTRY)&_ZN6S666C53v68Ev,
  (VTBL_ENTRY)&_ZN6S666C53v69Ev,
};
extern VTBL_ENTRY _ZTI6S666C5[];
extern  VTBL_ENTRY _ZTV6S666C5[];
Class_Descriptor cd_S666C5 = {  "S666C5", // class name
  0,0,//no base classes
  &(vtc_S666C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S666C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S666C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S666C4  : S666C5 {
  unsigned int s666c4f0:1;
  unsigned int s666c4f1:1;
  unsigned int s666c4f2:1;
  unsigned int s666c4f3:1;
  unsigned int s666c4f4:1;
  unsigned int s666c4f5:1;
  unsigned int s666c4f6:1;
  ::S3625C32 s666c4f7;
  virtual  ~S666C4(); // _ZN6S666C4D1Ev
  virtual void  v70(); // _ZN6S666C43v70Ev
  virtual void  v71(); // _ZN6S666C43v71Ev
  virtual void  v72(); // _ZN6S666C43v72Ev
  virtual void  v73(); // _ZN6S666C43v73Ev
  virtual void  v74(); // _ZN6S666C43v74Ev
  virtual void  v75(); // _ZN6S666C43v75Ev
  virtual void  v76(); // _ZN6S666C43v76Ev
  virtual void  v77(); // _ZN6S666C43v77Ev
  virtual void  v78(); // _ZN6S666C43v78Ev
  virtual void  v79(); // _ZN6S666C43v79Ev
  virtual void  v80(); // _ZN6S666C43v80Ev
  virtual void  v81(); // _ZN6S666C43v81Ev
  virtual void  v82(); // _ZN6S666C43v82Ev
  virtual void  v83(); // _ZN6S666C43v83Ev
  virtual void  v84(); // _ZN6S666C43v84Ev
  virtual void  v85(); // _ZN6S666C43v85Ev
  virtual void  v86(); // _ZN6S666C43v86Ev
  virtual void  v87(); // _ZN6S666C43v87Ev
  virtual void  v88(); // _ZN6S666C43v88Ev
  virtual void  v89(); // _ZN6S666C43v89Ev
  S666C4(); // tgen
};
//SIG(-1 S666C4) C1{ BC2{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC4{ m}}


 S666C4 ::~S666C4(){ note_dtor("S666C4", this);}
void  S666C4 ::v70(){vfunc_called(this, "_ZN6S666C43v70Ev");}
void  S666C4 ::v71(){vfunc_called(this, "_ZN6S666C43v71Ev");}
void  S666C4 ::v72(){vfunc_called(this, "_ZN6S666C43v72Ev");}
void  S666C4 ::v73(){vfunc_called(this, "_ZN6S666C43v73Ev");}
void  S666C4 ::v74(){vfunc_called(this, "_ZN6S666C43v74Ev");}
void  S666C4 ::v75(){vfunc_called(this, "_ZN6S666C43v75Ev");}
void  S666C4 ::v76(){vfunc_called(this, "_ZN6S666C43v76Ev");}
void  S666C4 ::v77(){vfunc_called(this, "_ZN6S666C43v77Ev");}
void  S666C4 ::v78(){vfunc_called(this, "_ZN6S666C43v78Ev");}
void  S666C4 ::v79(){vfunc_called(this, "_ZN6S666C43v79Ev");}
void  S666C4 ::v80(){vfunc_called(this, "_ZN6S666C43v80Ev");}
void  S666C4 ::v81(){vfunc_called(this, "_ZN6S666C43v81Ev");}
void  S666C4 ::v82(){vfunc_called(this, "_ZN6S666C43v82Ev");}
void  S666C4 ::v83(){vfunc_called(this, "_ZN6S666C43v83Ev");}
void  S666C4 ::v84(){vfunc_called(this, "_ZN6S666C43v84Ev");}
void  S666C4 ::v85(){vfunc_called(this, "_ZN6S666C43v85Ev");}
void  S666C4 ::v86(){vfunc_called(this, "_ZN6S666C43v86Ev");}
void  S666C4 ::v87(){vfunc_called(this, "_ZN6S666C43v87Ev");}
void  S666C4 ::v88(){vfunc_called(this, "_ZN6S666C43v88Ev");}
void  S666C4 ::v89(){vfunc_called(this, "_ZN6S666C43v89Ev");}
S666C4 ::S666C4(){ note_ctor("S666C4", this);} // tgen

static void Test_S666C4()
{
  extern Class_Descriptor cd_S666C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S666C4, buf);
    S666C4 *dp, &lv = *(dp=new (buf) S666C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S666C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S666C4)");
    check_base_class_offset(lv, (S666C5*), 0, "S666C4");
    set_bf_and_test(lv, s666c4f0, ABISELECT(96,60), 0, 1, 1, "S666C4");
    set_bf_and_test(lv, s666c4f1, ABISELECT(96,60), 1, 1, 1, "S666C4");
    set_bf_and_test(lv, s666c4f2, ABISELECT(96,60), 2, 1, 1, "S666C4");
    set_bf_and_test(lv, s666c4f3, ABISELECT(96,60), 3, 1, 1, "S666C4");
    set_bf_and_test(lv, s666c4f4, ABISELECT(96,60), 4, 1, 1, "S666C4");
    set_bf_and_test(lv, s666c4f5, ABISELECT(96,60), 5, 1, 1, "S666C4");
    set_bf_and_test(lv, s666c4f6, ABISELECT(96,60), 6, 1, 1, "S666C4");
    check_field_offset(lv, s666c4f7, ABISELECT(97,61), "S666C4.s666c4f7");
    test_class_info(&lv, &cd_S666C4);
    dp->~S666C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS666C4(Test_S666C4, "S666C4", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN6S666C4C1Ev();
extern void _ZN6S666C4D1Ev();
Name_Map name_map_S666C4[] = {
  NSPAIR(_ZN6S666C4C1Ev),
  NSPAIR(_ZN6S666C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S666C5;
extern VTBL_ENTRY _ZTI6S666C5[];
extern  VTBL_ENTRY _ZTV6S666C5[];
static Base_Class bases_S666C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S666C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S666C4[];
extern void _ZN6S666C4D1Ev();
extern void _ZN6S666C4D0Ev();
extern void _ZN6S666C52v6Ev();
extern void _ZN6S666C52v7Ev();
extern void _ZN6S666C52v8Ev();
extern void _ZN6S666C52v9Ev();
extern void _ZN6S666C53v10Ev();
extern void _ZN6S666C53v11Ev();
extern void _ZN6S666C53v12Ev();
extern void _ZN6S666C53v13Ev();
extern void _ZN6S666C53v14Ev();
extern void _ZN6S666C53v15Ev();
extern void _ZN6S666C53v16Ev();
extern void _ZN6S666C53v17Ev();
extern void _ZN6S666C53v18Ev();
extern void _ZN6S666C53v19Ev();
extern void _ZN6S666C53v20Ev();
extern void _ZN6S666C53v21Ev();
extern void _ZN6S666C53v22Ev();
extern void _ZN6S666C53v23Ev();
extern void _ZN6S666C53v24Ev();
extern void _ZN6S666C53v25Ev();
extern void _ZN6S666C53v26Ev();
extern void _ZN6S666C53v27Ev();
extern void _ZN6S666C53v28Ev();
extern void _ZN6S666C53v29Ev();
extern void _ZN6S666C53v30Ev();
extern void _ZN6S666C53v31Ev();
extern void _ZN6S666C53v32Ev();
extern void _ZN6S666C53v33Ev();
extern void _ZN6S666C53v34Ev();
extern void _ZN6S666C53v35Ev();
extern void _ZN6S666C53v36Ev();
extern void _ZN6S666C53v37Ev();
extern void _ZN6S666C53v38Ev();
extern void _ZN6S666C53v39Ev();
extern void _ZN6S666C53v40Ev();
extern void _ZN6S666C53v41Ev();
extern void _ZN6S666C53v42Ev();
extern void _ZN6S666C53v43Ev();
extern void _ZN6S666C53v44Ev();
extern void _ZN6S666C53v45Ev();
extern void _ZN6S666C53v46Ev();
extern void _ZN6S666C53v47Ev();
extern void _ZN6S666C53v48Ev();
extern void _ZN6S666C53v49Ev();
extern void _ZN6S666C53v50Ev();
extern void _ZN6S666C53v51Ev();
extern void _ZN6S666C53v52Ev();
extern void _ZN6S666C53v53Ev();
extern void _ZN6S666C53v54Ev();
extern void _ZN6S666C53v55Ev();
extern void _ZN6S666C53v56Ev();
extern void _ZN6S666C53v57Ev();
extern void _ZN6S666C53v58Ev();
extern void _ZN6S666C53v59Ev();
extern void _ZN6S666C53v60Ev();
extern void _ZN6S666C53v61Ev();
extern void _ZN6S666C53v62Ev();
extern void _ZN6S666C53v63Ev();
extern void _ZN6S666C53v64Ev();
extern void _ZN6S666C53v65Ev();
extern void _ZN6S666C53v66Ev();
extern void _ZN6S666C53v67Ev();
extern void _ZN6S666C53v68Ev();
extern void _ZN6S666C53v69Ev();
extern void _ZN6S666C43v70Ev();
extern void _ZN6S666C43v71Ev();
extern void _ZN6S666C43v72Ev();
extern void _ZN6S666C43v73Ev();
extern void _ZN6S666C43v74Ev();
extern void _ZN6S666C43v75Ev();
extern void _ZN6S666C43v76Ev();
extern void _ZN6S666C43v77Ev();
extern void _ZN6S666C43v78Ev();
extern void _ZN6S666C43v79Ev();
extern void _ZN6S666C43v80Ev();
extern void _ZN6S666C43v81Ev();
extern void _ZN6S666C43v82Ev();
extern void _ZN6S666C43v83Ev();
extern void _ZN6S666C43v84Ev();
extern void _ZN6S666C43v85Ev();
extern void _ZN6S666C43v86Ev();
extern void _ZN6S666C43v87Ev();
extern void _ZN6S666C43v88Ev();
extern void _ZN6S666C43v89Ev();
static  VTBL_ENTRY vtc_S666C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S666C4[0]),
  (VTBL_ENTRY)&_ZN6S666C4D1Ev,
  (VTBL_ENTRY)&_ZN6S666C4D0Ev,
  (VTBL_ENTRY)&_ZN6S666C52v6Ev,
  (VTBL_ENTRY)&_ZN6S666C52v7Ev,
  (VTBL_ENTRY)&_ZN6S666C52v8Ev,
  (VTBL_ENTRY)&_ZN6S666C52v9Ev,
  (VTBL_ENTRY)&_ZN6S666C53v10Ev,
  (VTBL_ENTRY)&_ZN6S666C53v11Ev,
  (VTBL_ENTRY)&_ZN6S666C53v12Ev,
  (VTBL_ENTRY)&_ZN6S666C53v13Ev,
  (VTBL_ENTRY)&_ZN6S666C53v14Ev,
  (VTBL_ENTRY)&_ZN6S666C53v15Ev,
  (VTBL_ENTRY)&_ZN6S666C53v16Ev,
  (VTBL_ENTRY)&_ZN6S666C53v17Ev,
  (VTBL_ENTRY)&_ZN6S666C53v18Ev,
  (VTBL_ENTRY)&_ZN6S666C53v19Ev,
  (VTBL_ENTRY)&_ZN6S666C53v20Ev,
  (VTBL_ENTRY)&_ZN6S666C53v21Ev,
  (VTBL_ENTRY)&_ZN6S666C53v22Ev,
  (VTBL_ENTRY)&_ZN6S666C53v23Ev,
  (VTBL_ENTRY)&_ZN6S666C53v24Ev,
  (VTBL_ENTRY)&_ZN6S666C53v25Ev,
  (VTBL_ENTRY)&_ZN6S666C53v26Ev,
  (VTBL_ENTRY)&_ZN6S666C53v27Ev,
  (VTBL_ENTRY)&_ZN6S666C53v28Ev,
  (VTBL_ENTRY)&_ZN6S666C53v29Ev,
  (VTBL_ENTRY)&_ZN6S666C53v30Ev,
  (VTBL_ENTRY)&_ZN6S666C53v31Ev,
  (VTBL_ENTRY)&_ZN6S666C53v32Ev,
  (VTBL_ENTRY)&_ZN6S666C53v33Ev,
  (VTBL_ENTRY)&_ZN6S666C53v34Ev,
  (VTBL_ENTRY)&_ZN6S666C53v35Ev,
  (VTBL_ENTRY)&_ZN6S666C53v36Ev,
  (VTBL_ENTRY)&_ZN6S666C53v37Ev,
  (VTBL_ENTRY)&_ZN6S666C53v38Ev,
  (VTBL_ENTRY)&_ZN6S666C53v39Ev,
  (VTBL_ENTRY)&_ZN6S666C53v40Ev,
  (VTBL_ENTRY)&_ZN6S666C53v41Ev,
  (VTBL_ENTRY)&_ZN6S666C53v42Ev,
  (VTBL_ENTRY)&_ZN6S666C53v43Ev,
  (VTBL_ENTRY)&_ZN6S666C53v44Ev,
  (VTBL_ENTRY)&_ZN6S666C53v45Ev,
  (VTBL_ENTRY)&_ZN6S666C53v46Ev,
  (VTBL_ENTRY)&_ZN6S666C53v47Ev,
  (VTBL_ENTRY)&_ZN6S666C53v48Ev,
  (VTBL_ENTRY)&_ZN6S666C53v49Ev,
  (VTBL_ENTRY)&_ZN6S666C53v50Ev,
  (VTBL_ENTRY)&_ZN6S666C53v51Ev,
  (VTBL_ENTRY)&_ZN6S666C53v52Ev,
  (VTBL_ENTRY)&_ZN6S666C53v53Ev,
  (VTBL_ENTRY)&_ZN6S666C53v54Ev,
  (VTBL_ENTRY)&_ZN6S666C53v55Ev,
  (VTBL_ENTRY)&_ZN6S666C53v56Ev,
  (VTBL_ENTRY)&_ZN6S666C53v57Ev,
  (VTBL_ENTRY)&_ZN6S666C53v58Ev,
  (VTBL_ENTRY)&_ZN6S666C53v59Ev,
  (VTBL_ENTRY)&_ZN6S666C53v60Ev,
  (VTBL_ENTRY)&_ZN6S666C53v61Ev,
  (VTBL_ENTRY)&_ZN6S666C53v62Ev,
  (VTBL_ENTRY)&_ZN6S666C53v63Ev,
  (VTBL_ENTRY)&_ZN6S666C53v64Ev,
  (VTBL_ENTRY)&_ZN6S666C53v65Ev,
  (VTBL_ENTRY)&_ZN6S666C53v66Ev,
  (VTBL_ENTRY)&_ZN6S666C53v67Ev,
  (VTBL_ENTRY)&_ZN6S666C53v68Ev,
  (VTBL_ENTRY)&_ZN6S666C53v69Ev,
  (VTBL_ENTRY)&_ZN6S666C43v70Ev,
  (VTBL_ENTRY)&_ZN6S666C43v71Ev,
  (VTBL_ENTRY)&_ZN6S666C43v72Ev,
  (VTBL_ENTRY)&_ZN6S666C43v73Ev,
  (VTBL_ENTRY)&_ZN6S666C43v74Ev,
  (VTBL_ENTRY)&_ZN6S666C43v75Ev,
  (VTBL_ENTRY)&_ZN6S666C43v76Ev,
  (VTBL_ENTRY)&_ZN6S666C43v77Ev,
  (VTBL_ENTRY)&_ZN6S666C43v78Ev,
  (VTBL_ENTRY)&_ZN6S666C43v79Ev,
  (VTBL_ENTRY)&_ZN6S666C43v80Ev,
  (VTBL_ENTRY)&_ZN6S666C43v81Ev,
  (VTBL_ENTRY)&_ZN6S666C43v82Ev,
  (VTBL_ENTRY)&_ZN6S666C43v83Ev,
  (VTBL_ENTRY)&_ZN6S666C43v84Ev,
  (VTBL_ENTRY)&_ZN6S666C43v85Ev,
  (VTBL_ENTRY)&_ZN6S666C43v86Ev,
  (VTBL_ENTRY)&_ZN6S666C43v87Ev,
  (VTBL_ENTRY)&_ZN6S666C43v88Ev,
  (VTBL_ENTRY)&_ZN6S666C43v89Ev,
};
extern VTBL_ENTRY _ZTI6S666C4[];
extern  VTBL_ENTRY _ZTV6S666C4[];
Class_Descriptor cd_S666C4 = {  "S666C4", // class name
  bases_S666C4, 1,
  &(vtc_S666C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI6S666C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S666C4),88, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S666C3  : S666C4 {
  virtual  ~S666C3(); // _ZN6S666C3D1Ev
  virtual void  v90(); // _ZN6S666C33v90Ev
  virtual void  v91(); // _ZN6S666C33v91Ev
  S666C3(); // tgen
};
//SIG(-1 S666C3) C1{ BC2{ BC3{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC5{ m}} vd v1 v2}


 S666C3 ::~S666C3(){ note_dtor("S666C3", this);}
void  S666C3 ::v90(){vfunc_called(this, "_ZN6S666C33v90Ev");}
void  S666C3 ::v91(){vfunc_called(this, "_ZN6S666C33v91Ev");}
S666C3 ::S666C3(){ note_ctor("S666C3", this);} // tgen

static void Test_S666C3()
{
  extern Class_Descriptor cd_S666C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S666C3, buf);
    S666C3 *dp, &lv = *(dp=new (buf) S666C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S666C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S666C3)");
    check_base_class_offset(lv, (S666C5*)(S666C4*), 0, "S666C3");
    check_base_class_offset(lv, (S666C4*), 0, "S666C3");
    test_class_info(&lv, &cd_S666C3);
    dp->~S666C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS666C3(Test_S666C3, "S666C3", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN6S666C3C1Ev();
extern void _ZN6S666C3D1Ev();
Name_Map name_map_S666C3[] = {
  NSPAIR(_ZN6S666C3C1Ev),
  NSPAIR(_ZN6S666C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S666C5;
extern VTBL_ENTRY _ZTI6S666C5[];
extern  VTBL_ENTRY _ZTV6S666C5[];
extern Class_Descriptor cd_S666C4;
extern VTBL_ENTRY _ZTI6S666C4[];
extern  VTBL_ENTRY _ZTV6S666C4[];
static Base_Class bases_S666C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S666C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S666C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S666C3[];
extern void _ZN6S666C3D1Ev();
extern void _ZN6S666C3D0Ev();
extern void _ZN6S666C52v6Ev();
extern void _ZN6S666C52v7Ev();
extern void _ZN6S666C52v8Ev();
extern void _ZN6S666C52v9Ev();
extern void _ZN6S666C53v10Ev();
extern void _ZN6S666C53v11Ev();
extern void _ZN6S666C53v12Ev();
extern void _ZN6S666C53v13Ev();
extern void _ZN6S666C53v14Ev();
extern void _ZN6S666C53v15Ev();
extern void _ZN6S666C53v16Ev();
extern void _ZN6S666C53v17Ev();
extern void _ZN6S666C53v18Ev();
extern void _ZN6S666C53v19Ev();
extern void _ZN6S666C53v20Ev();
extern void _ZN6S666C53v21Ev();
extern void _ZN6S666C53v22Ev();
extern void _ZN6S666C53v23Ev();
extern void _ZN6S666C53v24Ev();
extern void _ZN6S666C53v25Ev();
extern void _ZN6S666C53v26Ev();
extern void _ZN6S666C53v27Ev();
extern void _ZN6S666C53v28Ev();
extern void _ZN6S666C53v29Ev();
extern void _ZN6S666C53v30Ev();
extern void _ZN6S666C53v31Ev();
extern void _ZN6S666C53v32Ev();
extern void _ZN6S666C53v33Ev();
extern void _ZN6S666C53v34Ev();
extern void _ZN6S666C53v35Ev();
extern void _ZN6S666C53v36Ev();
extern void _ZN6S666C53v37Ev();
extern void _ZN6S666C53v38Ev();
extern void _ZN6S666C53v39Ev();
extern void _ZN6S666C53v40Ev();
extern void _ZN6S666C53v41Ev();
extern void _ZN6S666C53v42Ev();
extern void _ZN6S666C53v43Ev();
extern void _ZN6S666C53v44Ev();
extern void _ZN6S666C53v45Ev();
extern void _ZN6S666C53v46Ev();
extern void _ZN6S666C53v47Ev();
extern void _ZN6S666C53v48Ev();
extern void _ZN6S666C53v49Ev();
extern void _ZN6S666C53v50Ev();
extern void _ZN6S666C53v51Ev();
extern void _ZN6S666C53v52Ev();
extern void _ZN6S666C53v53Ev();
extern void _ZN6S666C53v54Ev();
extern void _ZN6S666C53v55Ev();
extern void _ZN6S666C53v56Ev();
extern void _ZN6S666C53v57Ev();
extern void _ZN6S666C53v58Ev();
extern void _ZN6S666C53v59Ev();
extern void _ZN6S666C53v60Ev();
extern void _ZN6S666C53v61Ev();
extern void _ZN6S666C53v62Ev();
extern void _ZN6S666C53v63Ev();
extern void _ZN6S666C53v64Ev();
extern void _ZN6S666C53v65Ev();
extern void _ZN6S666C53v66Ev();
extern void _ZN6S666C53v67Ev();
extern void _ZN6S666C53v68Ev();
extern void _ZN6S666C53v69Ev();
extern void _ZN6S666C43v70Ev();
extern void _ZN6S666C43v71Ev();
extern void _ZN6S666C43v72Ev();
extern void _ZN6S666C43v73Ev();
extern void _ZN6S666C43v74Ev();
extern void _ZN6S666C43v75Ev();
extern void _ZN6S666C43v76Ev();
extern void _ZN6S666C43v77Ev();
extern void _ZN6S666C43v78Ev();
extern void _ZN6S666C43v79Ev();
extern void _ZN6S666C43v80Ev();
extern void _ZN6S666C43v81Ev();
extern void _ZN6S666C43v82Ev();
extern void _ZN6S666C43v83Ev();
extern void _ZN6S666C43v84Ev();
extern void _ZN6S666C43v85Ev();
extern void _ZN6S666C43v86Ev();
extern void _ZN6S666C43v87Ev();
extern void _ZN6S666C43v88Ev();
extern void _ZN6S666C43v89Ev();
extern void _ZN6S666C33v90Ev();
extern void _ZN6S666C33v91Ev();
static  VTBL_ENTRY vtc_S666C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S666C3[0]),
  (VTBL_ENTRY)&_ZN6S666C3D1Ev,
  (VTBL_ENTRY)&_ZN6S666C3D0Ev,
  (VTBL_ENTRY)&_ZN6S666C52v6Ev,
  (VTBL_ENTRY)&_ZN6S666C52v7Ev,
  (VTBL_ENTRY)&_ZN6S666C52v8Ev,
  (VTBL_ENTRY)&_ZN6S666C52v9Ev,
  (VTBL_ENTRY)&_ZN6S666C53v10Ev,
  (VTBL_ENTRY)&_ZN6S666C53v11Ev,
  (VTBL_ENTRY)&_ZN6S666C53v12Ev,
  (VTBL_ENTRY)&_ZN6S666C53v13Ev,
  (VTBL_ENTRY)&_ZN6S666C53v14Ev,
  (VTBL_ENTRY)&_ZN6S666C53v15Ev,
  (VTBL_ENTRY)&_ZN6S666C53v16Ev,
  (VTBL_ENTRY)&_ZN6S666C53v17Ev,
  (VTBL_ENTRY)&_ZN6S666C53v18Ev,
  (VTBL_ENTRY)&_ZN6S666C53v19Ev,
  (VTBL_ENTRY)&_ZN6S666C53v20Ev,
  (VTBL_ENTRY)&_ZN6S666C53v21Ev,
  (VTBL_ENTRY)&_ZN6S666C53v22Ev,
  (VTBL_ENTRY)&_ZN6S666C53v23Ev,
  (VTBL_ENTRY)&_ZN6S666C53v24Ev,
  (VTBL_ENTRY)&_ZN6S666C53v25Ev,
  (VTBL_ENTRY)&_ZN6S666C53v26Ev,
  (VTBL_ENTRY)&_ZN6S666C53v27Ev,
  (VTBL_ENTRY)&_ZN6S666C53v28Ev,
  (VTBL_ENTRY)&_ZN6S666C53v29Ev,
  (VTBL_ENTRY)&_ZN6S666C53v30Ev,
  (VTBL_ENTRY)&_ZN6S666C53v31Ev,
  (VTBL_ENTRY)&_ZN6S666C53v32Ev,
  (VTBL_ENTRY)&_ZN6S666C53v33Ev,
  (VTBL_ENTRY)&_ZN6S666C53v34Ev,
  (VTBL_ENTRY)&_ZN6S666C53v35Ev,
  (VTBL_ENTRY)&_ZN6S666C53v36Ev,
  (VTBL_ENTRY)&_ZN6S666C53v37Ev,
  (VTBL_ENTRY)&_ZN6S666C53v38Ev,
  (VTBL_ENTRY)&_ZN6S666C53v39Ev,
  (VTBL_ENTRY)&_ZN6S666C53v40Ev,
  (VTBL_ENTRY)&_ZN6S666C53v41Ev,
  (VTBL_ENTRY)&_ZN6S666C53v42Ev,
  (VTBL_ENTRY)&_ZN6S666C53v43Ev,
  (VTBL_ENTRY)&_ZN6S666C53v44Ev,
  (VTBL_ENTRY)&_ZN6S666C53v45Ev,
  (VTBL_ENTRY)&_ZN6S666C53v46Ev,
  (VTBL_ENTRY)&_ZN6S666C53v47Ev,
  (VTBL_ENTRY)&_ZN6S666C53v48Ev,
  (VTBL_ENTRY)&_ZN6S666C53v49Ev,
  (VTBL_ENTRY)&_ZN6S666C53v50Ev,
  (VTBL_ENTRY)&_ZN6S666C53v51Ev,
  (VTBL_ENTRY)&_ZN6S666C53v52Ev,
  (VTBL_ENTRY)&_ZN6S666C53v53Ev,
  (VTBL_ENTRY)&_ZN6S666C53v54Ev,
  (VTBL_ENTRY)&_ZN6S666C53v55Ev,
  (VTBL_ENTRY)&_ZN6S666C53v56Ev,
  (VTBL_ENTRY)&_ZN6S666C53v57Ev,
  (VTBL_ENTRY)&_ZN6S666C53v58Ev,
  (VTBL_ENTRY)&_ZN6S666C53v59Ev,
  (VTBL_ENTRY)&_ZN6S666C53v60Ev,
  (VTBL_ENTRY)&_ZN6S666C53v61Ev,
  (VTBL_ENTRY)&_ZN6S666C53v62Ev,
  (VTBL_ENTRY)&_ZN6S666C53v63Ev,
  (VTBL_ENTRY)&_ZN6S666C53v64Ev,
  (VTBL_ENTRY)&_ZN6S666C53v65Ev,
  (VTBL_ENTRY)&_ZN6S666C53v66Ev,
  (VTBL_ENTRY)&_ZN6S666C53v67Ev,
  (VTBL_ENTRY)&_ZN6S666C53v68Ev,
  (VTBL_ENTRY)&_ZN6S666C53v69Ev,
  (VTBL_ENTRY)&_ZN6S666C43v70Ev,
  (VTBL_ENTRY)&_ZN6S666C43v71Ev,
  (VTBL_ENTRY)&_ZN6S666C43v72Ev,
  (VTBL_ENTRY)&_ZN6S666C43v73Ev,
  (VTBL_ENTRY)&_ZN6S666C43v74Ev,
  (VTBL_ENTRY)&_ZN6S666C43v75Ev,
  (VTBL_ENTRY)&_ZN6S666C43v76Ev,
  (VTBL_ENTRY)&_ZN6S666C43v77Ev,
  (VTBL_ENTRY)&_ZN6S666C43v78Ev,
  (VTBL_ENTRY)&_ZN6S666C43v79Ev,
  (VTBL_ENTRY)&_ZN6S666C43v80Ev,
  (VTBL_ENTRY)&_ZN6S666C43v81Ev,
  (VTBL_ENTRY)&_ZN6S666C43v82Ev,
  (VTBL_ENTRY)&_ZN6S666C43v83Ev,
  (VTBL_ENTRY)&_ZN6S666C43v84Ev,
  (VTBL_ENTRY)&_ZN6S666C43v85Ev,
  (VTBL_ENTRY)&_ZN6S666C43v86Ev,
  (VTBL_ENTRY)&_ZN6S666C43v87Ev,
  (VTBL_ENTRY)&_ZN6S666C43v88Ev,
  (VTBL_ENTRY)&_ZN6S666C43v89Ev,
  (VTBL_ENTRY)&_ZN6S666C33v90Ev,
  (VTBL_ENTRY)&_ZN6S666C33v91Ev,
};
extern VTBL_ENTRY _ZTI6S666C3[];
extern  VTBL_ENTRY _ZTV6S666C3[];
Class_Descriptor cd_S666C3 = {  "S666C3", // class name
  bases_S666C3, 2,
  &(vtc_S666C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI6S666C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S666C3),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S666C2  : S666C3 {
  unsigned int s666c2f0:1;
  unsigned int s666c2f1:1;
  unsigned int s666c2f2:1;
  unsigned int s666c2f3:1;
  unsigned int s666c2f4:1;
  unsigned int s666c2f5:1;
  unsigned int s666c2f6:1;
  unsigned int s666c2f7:1;
  ::S1292C12 s666c2f8;
  ::S1289C10_nt s666c2f9;
  virtual  ~S666C2(); // _ZN6S666C2D1Ev
  virtual void  v92(); // _ZN6S666C23v92Ev
  virtual void  v93(); // _ZN6S666C23v93Ev
  virtual void  v94(); // _ZN6S666C23v94Ev
  S666C2(); // tgen
};
//SIG(-1 S666C2) C1{ BC2{ BC3{ BC4{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC6{ m}} vd v88 v89} vd v1 v2 v3 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC7{ BC8{ m Fc[4] FC9{ BC10{ BC11{ m Fp Fi[2]}}} Fi[2]} Fp} FC12{ BC8 Fp}}


 S666C2 ::~S666C2(){ note_dtor("S666C2", this);}
void  S666C2 ::v92(){vfunc_called(this, "_ZN6S666C23v92Ev");}
void  S666C2 ::v93(){vfunc_called(this, "_ZN6S666C23v93Ev");}
void  S666C2 ::v94(){vfunc_called(this, "_ZN6S666C23v94Ev");}
S666C2 ::S666C2(){ note_ctor("S666C2", this);} // tgen

static void Test_S666C2()
{
  extern Class_Descriptor cd_S666C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(24,31)];
    init_test(&cd_S666C2, buf);
    S666C2 *dp, &lv = *(dp=new (buf) S666C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(184,120), "sizeof(S666C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S666C2)");
    check_base_class_offset(lv, (S666C5*)(S666C4*)(S666C3*), 0, "S666C2");
    check_base_class_offset(lv, (S666C4*)(S666C3*), 0, "S666C2");
    check_base_class_offset(lv, (S666C3*), 0, "S666C2");
    set_bf_and_test(lv, s666c2f0, ABISELECT(98,62), 0, 1, 1, "S666C2");
    set_bf_and_test(lv, s666c2f1, ABISELECT(98,62), 1, 1, 1, "S666C2");
    set_bf_and_test(lv, s666c2f2, ABISELECT(98,62), 2, 1, 1, "S666C2");
    set_bf_and_test(lv, s666c2f3, ABISELECT(98,62), 3, 1, 1, "S666C2");
    set_bf_and_test(lv, s666c2f4, ABISELECT(98,62), 4, 1, 1, "S666C2");
    set_bf_and_test(lv, s666c2f5, ABISELECT(98,62), 5, 1, 1, "S666C2");
    set_bf_and_test(lv, s666c2f6, ABISELECT(98,62), 6, 1, 1, "S666C2");
    set_bf_and_test(lv, s666c2f7, ABISELECT(98,62), 7, 1, 1, "S666C2");
    check_field_offset(lv, s666c2f8, ABISELECT(104,64), "S666C2.s666c2f8");
    check_field_offset(lv, s666c2f9, ABISELECT(144,92), "S666C2.s666c2f9");
    test_class_info(&lv, &cd_S666C2);
    dp->~S666C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS666C2(Test_S666C2, "S666C2", ABISELECT(184,120));

#else // __cplusplus

extern void _ZN6S666C2C1Ev();
extern void _ZN6S666C2D1Ev();
Name_Map name_map_S666C2[] = {
  NSPAIR(_ZN6S666C2C1Ev),
  NSPAIR(_ZN6S666C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S666C5;
extern VTBL_ENTRY _ZTI6S666C5[];
extern  VTBL_ENTRY _ZTV6S666C5[];
extern Class_Descriptor cd_S666C4;
extern VTBL_ENTRY _ZTI6S666C4[];
extern  VTBL_ENTRY _ZTV6S666C4[];
extern Class_Descriptor cd_S666C3;
extern VTBL_ENTRY _ZTI6S666C3[];
extern  VTBL_ENTRY _ZTV6S666C3[];
static Base_Class bases_S666C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S666C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S666C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S666C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S666C2[];
extern void _ZN6S666C2D1Ev();
extern void _ZN6S666C2D0Ev();
extern void _ZN6S666C52v6Ev();
extern void _ZN6S666C52v7Ev();
extern void _ZN6S666C52v8Ev();
extern void _ZN6S666C52v9Ev();
extern void _ZN6S666C53v10Ev();
extern void _ZN6S666C53v11Ev();
extern void _ZN6S666C53v12Ev();
extern void _ZN6S666C53v13Ev();
extern void _ZN6S666C53v14Ev();
extern void _ZN6S666C53v15Ev();
extern void _ZN6S666C53v16Ev();
extern void _ZN6S666C53v17Ev();
extern void _ZN6S666C53v18Ev();
extern void _ZN6S666C53v19Ev();
extern void _ZN6S666C53v20Ev();
extern void _ZN6S666C53v21Ev();
extern void _ZN6S666C53v22Ev();
extern void _ZN6S666C53v23Ev();
extern void _ZN6S666C53v24Ev();
extern void _ZN6S666C53v25Ev();
extern void _ZN6S666C53v26Ev();
extern void _ZN6S666C53v27Ev();
extern void _ZN6S666C53v28Ev();
extern void _ZN6S666C53v29Ev();
extern void _ZN6S666C53v30Ev();
extern void _ZN6S666C53v31Ev();
extern void _ZN6S666C53v32Ev();
extern void _ZN6S666C53v33Ev();
extern void _ZN6S666C53v34Ev();
extern void _ZN6S666C53v35Ev();
extern void _ZN6S666C53v36Ev();
extern void _ZN6S666C53v37Ev();
extern void _ZN6S666C53v38Ev();
extern void _ZN6S666C53v39Ev();
extern void _ZN6S666C53v40Ev();
extern void _ZN6S666C53v41Ev();
extern void _ZN6S666C53v42Ev();
extern void _ZN6S666C53v43Ev();
extern void _ZN6S666C53v44Ev();
extern void _ZN6S666C53v45Ev();
extern void _ZN6S666C53v46Ev();
extern void _ZN6S666C53v47Ev();
extern void _ZN6S666C53v48Ev();
extern void _ZN6S666C53v49Ev();
extern void _ZN6S666C53v50Ev();
extern void _ZN6S666C53v51Ev();
extern void _ZN6S666C53v52Ev();
extern void _ZN6S666C53v53Ev();
extern void _ZN6S666C53v54Ev();
extern void _ZN6S666C53v55Ev();
extern void _ZN6S666C53v56Ev();
extern void _ZN6S666C53v57Ev();
extern void _ZN6S666C53v58Ev();
extern void _ZN6S666C53v59Ev();
extern void _ZN6S666C53v60Ev();
extern void _ZN6S666C53v61Ev();
extern void _ZN6S666C53v62Ev();
extern void _ZN6S666C53v63Ev();
extern void _ZN6S666C53v64Ev();
extern void _ZN6S666C53v65Ev();
extern void _ZN6S666C53v66Ev();
extern void _ZN6S666C53v67Ev();
extern void _ZN6S666C53v68Ev();
extern void _ZN6S666C53v69Ev();
extern void _ZN6S666C43v70Ev();
extern void _ZN6S666C43v71Ev();
extern void _ZN6S666C43v72Ev();
extern void _ZN6S666C43v73Ev();
extern void _ZN6S666C43v74Ev();
extern void _ZN6S666C43v75Ev();
extern void _ZN6S666C43v76Ev();
extern void _ZN6S666C43v77Ev();
extern void _ZN6S666C43v78Ev();
extern void _ZN6S666C43v79Ev();
extern void _ZN6S666C43v80Ev();
extern void _ZN6S666C43v81Ev();
extern void _ZN6S666C43v82Ev();
extern void _ZN6S666C43v83Ev();
extern void _ZN6S666C43v84Ev();
extern void _ZN6S666C43v85Ev();
extern void _ZN6S666C43v86Ev();
extern void _ZN6S666C43v87Ev();
extern void _ZN6S666C43v88Ev();
extern void _ZN6S666C43v89Ev();
extern void _ZN6S666C33v90Ev();
extern void _ZN6S666C33v91Ev();
extern void _ZN6S666C23v92Ev();
extern void _ZN6S666C23v93Ev();
extern void _ZN6S666C23v94Ev();
static  VTBL_ENTRY vtc_S666C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S666C2[0]),
  (VTBL_ENTRY)&_ZN6S666C2D1Ev,
  (VTBL_ENTRY)&_ZN6S666C2D0Ev,
  (VTBL_ENTRY)&_ZN6S666C52v6Ev,
  (VTBL_ENTRY)&_ZN6S666C52v7Ev,
  (VTBL_ENTRY)&_ZN6S666C52v8Ev,
  (VTBL_ENTRY)&_ZN6S666C52v9Ev,
  (VTBL_ENTRY)&_ZN6S666C53v10Ev,
  (VTBL_ENTRY)&_ZN6S666C53v11Ev,
  (VTBL_ENTRY)&_ZN6S666C53v12Ev,
  (VTBL_ENTRY)&_ZN6S666C53v13Ev,
  (VTBL_ENTRY)&_ZN6S666C53v14Ev,
  (VTBL_ENTRY)&_ZN6S666C53v15Ev,
  (VTBL_ENTRY)&_ZN6S666C53v16Ev,
  (VTBL_ENTRY)&_ZN6S666C53v17Ev,
  (VTBL_ENTRY)&_ZN6S666C53v18Ev,
  (VTBL_ENTRY)&_ZN6S666C53v19Ev,
  (VTBL_ENTRY)&_ZN6S666C53v20Ev,
  (VTBL_ENTRY)&_ZN6S666C53v21Ev,
  (VTBL_ENTRY)&_ZN6S666C53v22Ev,
  (VTBL_ENTRY)&_ZN6S666C53v23Ev,
  (VTBL_ENTRY)&_ZN6S666C53v24Ev,
  (VTBL_ENTRY)&_ZN6S666C53v25Ev,
  (VTBL_ENTRY)&_ZN6S666C53v26Ev,
  (VTBL_ENTRY)&_ZN6S666C53v27Ev,
  (VTBL_ENTRY)&_ZN6S666C53v28Ev,
  (VTBL_ENTRY)&_ZN6S666C53v29Ev,
  (VTBL_ENTRY)&_ZN6S666C53v30Ev,
  (VTBL_ENTRY)&_ZN6S666C53v31Ev,
  (VTBL_ENTRY)&_ZN6S666C53v32Ev,
  (VTBL_ENTRY)&_ZN6S666C53v33Ev,
  (VTBL_ENTRY)&_ZN6S666C53v34Ev,
  (VTBL_ENTRY)&_ZN6S666C53v35Ev,
  (VTBL_ENTRY)&_ZN6S666C53v36Ev,
  (VTBL_ENTRY)&_ZN6S666C53v37Ev,
  (VTBL_ENTRY)&_ZN6S666C53v38Ev,
  (VTBL_ENTRY)&_ZN6S666C53v39Ev,
  (VTBL_ENTRY)&_ZN6S666C53v40Ev,
  (VTBL_ENTRY)&_ZN6S666C53v41Ev,
  (VTBL_ENTRY)&_ZN6S666C53v42Ev,
  (VTBL_ENTRY)&_ZN6S666C53v43Ev,
  (VTBL_ENTRY)&_ZN6S666C53v44Ev,
  (VTBL_ENTRY)&_ZN6S666C53v45Ev,
  (VTBL_ENTRY)&_ZN6S666C53v46Ev,
  (VTBL_ENTRY)&_ZN6S666C53v47Ev,
  (VTBL_ENTRY)&_ZN6S666C53v48Ev,
  (VTBL_ENTRY)&_ZN6S666C53v49Ev,
  (VTBL_ENTRY)&_ZN6S666C53v50Ev,
  (VTBL_ENTRY)&_ZN6S666C53v51Ev,
  (VTBL_ENTRY)&_ZN6S666C53v52Ev,
  (VTBL_ENTRY)&_ZN6S666C53v53Ev,
  (VTBL_ENTRY)&_ZN6S666C53v54Ev,
  (VTBL_ENTRY)&_ZN6S666C53v55Ev,
  (VTBL_ENTRY)&_ZN6S666C53v56Ev,
  (VTBL_ENTRY)&_ZN6S666C53v57Ev,
  (VTBL_ENTRY)&_ZN6S666C53v58Ev,
  (VTBL_ENTRY)&_ZN6S666C53v59Ev,
  (VTBL_ENTRY)&_ZN6S666C53v60Ev,
  (VTBL_ENTRY)&_ZN6S666C53v61Ev,
  (VTBL_ENTRY)&_ZN6S666C53v62Ev,
  (VTBL_ENTRY)&_ZN6S666C53v63Ev,
  (VTBL_ENTRY)&_ZN6S666C53v64Ev,
  (VTBL_ENTRY)&_ZN6S666C53v65Ev,
  (VTBL_ENTRY)&_ZN6S666C53v66Ev,
  (VTBL_ENTRY)&_ZN6S666C53v67Ev,
  (VTBL_ENTRY)&_ZN6S666C53v68Ev,
  (VTBL_ENTRY)&_ZN6S666C53v69Ev,
  (VTBL_ENTRY)&_ZN6S666C43v70Ev,
  (VTBL_ENTRY)&_ZN6S666C43v71Ev,
  (VTBL_ENTRY)&_ZN6S666C43v72Ev,
  (VTBL_ENTRY)&_ZN6S666C43v73Ev,
  (VTBL_ENTRY)&_ZN6S666C43v74Ev,
  (VTBL_ENTRY)&_ZN6S666C43v75Ev,
  (VTBL_ENTRY)&_ZN6S666C43v76Ev,
  (VTBL_ENTRY)&_ZN6S666C43v77Ev,
  (VTBL_ENTRY)&_ZN6S666C43v78Ev,
  (VTBL_ENTRY)&_ZN6S666C43v79Ev,
  (VTBL_ENTRY)&_ZN6S666C43v80Ev,
  (VTBL_ENTRY)&_ZN6S666C43v81Ev,
  (VTBL_ENTRY)&_ZN6S666C43v82Ev,
  (VTBL_ENTRY)&_ZN6S666C43v83Ev,
  (VTBL_ENTRY)&_ZN6S666C43v84Ev,
  (VTBL_ENTRY)&_ZN6S666C43v85Ev,
  (VTBL_ENTRY)&_ZN6S666C43v86Ev,
  (VTBL_ENTRY)&_ZN6S666C43v87Ev,
  (VTBL_ENTRY)&_ZN6S666C43v88Ev,
  (VTBL_ENTRY)&_ZN6S666C43v89Ev,
  (VTBL_ENTRY)&_ZN6S666C33v90Ev,
  (VTBL_ENTRY)&_ZN6S666C33v91Ev,
  (VTBL_ENTRY)&_ZN6S666C23v92Ev,
  (VTBL_ENTRY)&_ZN6S666C23v93Ev,
  (VTBL_ENTRY)&_ZN6S666C23v94Ev,
};
extern VTBL_ENTRY _ZTI6S666C2[];
extern  VTBL_ENTRY _ZTV6S666C2[];
Class_Descriptor cd_S666C2 = {  "S666C2", // class name
  bases_S666C2, 3,
  &(vtc_S666C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(184,120), // object size
  NSPAIRA(_ZTI6S666C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S666C2),93, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S666C1  : S666C2 {
  unsigned int s666c1f0:1;
  ::S1292C12 s666c1f1;
  ::S1292C12 s666c1f2;
  char s666c1f3;
  virtual  ~S666C1(); // _ZN6S666C1D1Ev
  virtual void  v1(); // _ZN6S666C12v1Ev
  virtual void  v2(); // _ZN6S666C12v2Ev
  virtual void  v3(); // _ZN6S666C12v3Ev
  virtual void  v4(); // _ZN6S666C12v4Ev
  virtual void  v5(); // _ZN6S666C12v5Ev
  S666C1(); // tgen
};
//SIG(1 S666C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC7{ m}} vd v90 v91} vd v92 v93 v94 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC8{ BC9{ m Fc[4] FC10{ BC11{ BC12{ m Fp Fi[2]}}} Fi[2]} Fp} FC13{ BC9 Fp}} vd v1 v2 v3 v4 v5 Fi:1 FC8 FC8 Fc}


 S666C1 ::~S666C1(){ note_dtor("S666C1", this);}
void  S666C1 ::v1(){vfunc_called(this, "_ZN6S666C12v1Ev");}
void  S666C1 ::v2(){vfunc_called(this, "_ZN6S666C12v2Ev");}
void  S666C1 ::v3(){vfunc_called(this, "_ZN6S666C12v3Ev");}
void  S666C1 ::v4(){vfunc_called(this, "_ZN6S666C12v4Ev");}
void  S666C1 ::v5(){vfunc_called(this, "_ZN6S666C12v5Ev");}
S666C1 ::S666C1(){ note_ctor("S666C1", this);} // tgen

static void Test_S666C1()
{
  extern Class_Descriptor cd_S666C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(36,47)];
    init_test(&cd_S666C1, buf);
    S666C1 *dp, &lv = *(dp=new (buf) S666C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(280,184), "sizeof(S666C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S666C1)");
    check_base_class_offset(lv, (S666C5*)(S666C4*)(S666C3*)(S666C2*), 0, "S666C1");
    check_base_class_offset(lv, (S666C4*)(S666C3*)(S666C2*), 0, "S666C1");
    check_base_class_offset(lv, (S666C3*)(S666C2*), 0, "S666C1");
    check_base_class_offset(lv, (S666C2*), 0, "S666C1");
    set_bf_and_test(lv, s666c1f0, ABISELECT(184,120), 0, 1, 1, "S666C1");
    check_field_offset(lv, s666c1f1, ABISELECT(192,124), "S666C1.s666c1f1");
    check_field_offset(lv, s666c1f2, ABISELECT(232,152), "S666C1.s666c1f2");
    check_field_offset(lv, s666c1f3, ABISELECT(272,180), "S666C1.s666c1f3");
    test_class_info(&lv, &cd_S666C1);
    dp->~S666C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS666C1(Test_S666C1, "S666C1", ABISELECT(280,184));

#else // __cplusplus

extern void _ZN6S666C1C1Ev();
extern void _ZN6S666C1D1Ev();
Name_Map name_map_S666C1[] = {
  NSPAIR(_ZN6S666C1C1Ev),
  NSPAIR(_ZN6S666C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S666C5;
extern VTBL_ENTRY _ZTI6S666C5[];
extern  VTBL_ENTRY _ZTV6S666C5[];
extern Class_Descriptor cd_S666C4;
extern VTBL_ENTRY _ZTI6S666C4[];
extern  VTBL_ENTRY _ZTV6S666C4[];
extern Class_Descriptor cd_S666C3;
extern VTBL_ENTRY _ZTI6S666C3[];
extern  VTBL_ENTRY _ZTV6S666C3[];
extern Class_Descriptor cd_S666C2;
extern VTBL_ENTRY _ZTI6S666C2[];
extern  VTBL_ENTRY _ZTV6S666C2[];
static Base_Class bases_S666C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S666C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S666C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S666C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S666C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S666C1[];
extern void _ZN6S666C1D1Ev();
extern void _ZN6S666C1D0Ev();
extern void _ZN6S666C52v6Ev();
extern void _ZN6S666C52v7Ev();
extern void _ZN6S666C52v8Ev();
extern void _ZN6S666C52v9Ev();
extern void _ZN6S666C53v10Ev();
extern void _ZN6S666C53v11Ev();
extern void _ZN6S666C53v12Ev();
extern void _ZN6S666C53v13Ev();
extern void _ZN6S666C53v14Ev();
extern void _ZN6S666C53v15Ev();
extern void _ZN6S666C53v16Ev();
extern void _ZN6S666C53v17Ev();
extern void _ZN6S666C53v18Ev();
extern void _ZN6S666C53v19Ev();
extern void _ZN6S666C53v20Ev();
extern void _ZN6S666C53v21Ev();
extern void _ZN6S666C53v22Ev();
extern void _ZN6S666C53v23Ev();
extern void _ZN6S666C53v24Ev();
extern void _ZN6S666C53v25Ev();
extern void _ZN6S666C53v26Ev();
extern void _ZN6S666C53v27Ev();
extern void _ZN6S666C53v28Ev();
extern void _ZN6S666C53v29Ev();
extern void _ZN6S666C53v30Ev();
extern void _ZN6S666C53v31Ev();
extern void _ZN6S666C53v32Ev();
extern void _ZN6S666C53v33Ev();
extern void _ZN6S666C53v34Ev();
extern void _ZN6S666C53v35Ev();
extern void _ZN6S666C53v36Ev();
extern void _ZN6S666C53v37Ev();
extern void _ZN6S666C53v38Ev();
extern void _ZN6S666C53v39Ev();
extern void _ZN6S666C53v40Ev();
extern void _ZN6S666C53v41Ev();
extern void _ZN6S666C53v42Ev();
extern void _ZN6S666C53v43Ev();
extern void _ZN6S666C53v44Ev();
extern void _ZN6S666C53v45Ev();
extern void _ZN6S666C53v46Ev();
extern void _ZN6S666C53v47Ev();
extern void _ZN6S666C53v48Ev();
extern void _ZN6S666C53v49Ev();
extern void _ZN6S666C53v50Ev();
extern void _ZN6S666C53v51Ev();
extern void _ZN6S666C53v52Ev();
extern void _ZN6S666C53v53Ev();
extern void _ZN6S666C53v54Ev();
extern void _ZN6S666C53v55Ev();
extern void _ZN6S666C53v56Ev();
extern void _ZN6S666C53v57Ev();
extern void _ZN6S666C53v58Ev();
extern void _ZN6S666C53v59Ev();
extern void _ZN6S666C53v60Ev();
extern void _ZN6S666C53v61Ev();
extern void _ZN6S666C53v62Ev();
extern void _ZN6S666C53v63Ev();
extern void _ZN6S666C53v64Ev();
extern void _ZN6S666C53v65Ev();
extern void _ZN6S666C53v66Ev();
extern void _ZN6S666C53v67Ev();
extern void _ZN6S666C53v68Ev();
extern void _ZN6S666C53v69Ev();
extern void _ZN6S666C43v70Ev();
extern void _ZN6S666C43v71Ev();
extern void _ZN6S666C43v72Ev();
extern void _ZN6S666C43v73Ev();
extern void _ZN6S666C43v74Ev();
extern void _ZN6S666C43v75Ev();
extern void _ZN6S666C43v76Ev();
extern void _ZN6S666C43v77Ev();
extern void _ZN6S666C43v78Ev();
extern void _ZN6S666C43v79Ev();
extern void _ZN6S666C43v80Ev();
extern void _ZN6S666C43v81Ev();
extern void _ZN6S666C43v82Ev();
extern void _ZN6S666C43v83Ev();
extern void _ZN6S666C43v84Ev();
extern void _ZN6S666C43v85Ev();
extern void _ZN6S666C43v86Ev();
extern void _ZN6S666C43v87Ev();
extern void _ZN6S666C43v88Ev();
extern void _ZN6S666C43v89Ev();
extern void _ZN6S666C33v90Ev();
extern void _ZN6S666C33v91Ev();
extern void _ZN6S666C23v92Ev();
extern void _ZN6S666C23v93Ev();
extern void _ZN6S666C23v94Ev();
extern void _ZN6S666C12v1Ev();
extern void _ZN6S666C12v2Ev();
extern void _ZN6S666C12v3Ev();
extern void _ZN6S666C12v4Ev();
extern void _ZN6S666C12v5Ev();
static  VTBL_ENTRY vtc_S666C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S666C1[0]),
  (VTBL_ENTRY)&_ZN6S666C1D1Ev,
  (VTBL_ENTRY)&_ZN6S666C1D0Ev,
  (VTBL_ENTRY)&_ZN6S666C52v6Ev,
  (VTBL_ENTRY)&_ZN6S666C52v7Ev,
  (VTBL_ENTRY)&_ZN6S666C52v8Ev,
  (VTBL_ENTRY)&_ZN6S666C52v9Ev,
  (VTBL_ENTRY)&_ZN6S666C53v10Ev,
  (VTBL_ENTRY)&_ZN6S666C53v11Ev,
  (VTBL_ENTRY)&_ZN6S666C53v12Ev,
  (VTBL_ENTRY)&_ZN6S666C53v13Ev,
  (VTBL_ENTRY)&_ZN6S666C53v14Ev,
  (VTBL_ENTRY)&_ZN6S666C53v15Ev,
  (VTBL_ENTRY)&_ZN6S666C53v16Ev,
  (VTBL_ENTRY)&_ZN6S666C53v17Ev,
  (VTBL_ENTRY)&_ZN6S666C53v18Ev,
  (VTBL_ENTRY)&_ZN6S666C53v19Ev,
  (VTBL_ENTRY)&_ZN6S666C53v20Ev,
  (VTBL_ENTRY)&_ZN6S666C53v21Ev,
  (VTBL_ENTRY)&_ZN6S666C53v22Ev,
  (VTBL_ENTRY)&_ZN6S666C53v23Ev,
  (VTBL_ENTRY)&_ZN6S666C53v24Ev,
  (VTBL_ENTRY)&_ZN6S666C53v25Ev,
  (VTBL_ENTRY)&_ZN6S666C53v26Ev,
  (VTBL_ENTRY)&_ZN6S666C53v27Ev,
  (VTBL_ENTRY)&_ZN6S666C53v28Ev,
  (VTBL_ENTRY)&_ZN6S666C53v29Ev,
  (VTBL_ENTRY)&_ZN6S666C53v30Ev,
  (VTBL_ENTRY)&_ZN6S666C53v31Ev,
  (VTBL_ENTRY)&_ZN6S666C53v32Ev,
  (VTBL_ENTRY)&_ZN6S666C53v33Ev,
  (VTBL_ENTRY)&_ZN6S666C53v34Ev,
  (VTBL_ENTRY)&_ZN6S666C53v35Ev,
  (VTBL_ENTRY)&_ZN6S666C53v36Ev,
  (VTBL_ENTRY)&_ZN6S666C53v37Ev,
  (VTBL_ENTRY)&_ZN6S666C53v38Ev,
  (VTBL_ENTRY)&_ZN6S666C53v39Ev,
  (VTBL_ENTRY)&_ZN6S666C53v40Ev,
  (VTBL_ENTRY)&_ZN6S666C53v41Ev,
  (VTBL_ENTRY)&_ZN6S666C53v42Ev,
  (VTBL_ENTRY)&_ZN6S666C53v43Ev,
  (VTBL_ENTRY)&_ZN6S666C53v44Ev,
  (VTBL_ENTRY)&_ZN6S666C53v45Ev,
  (VTBL_ENTRY)&_ZN6S666C53v46Ev,
  (VTBL_ENTRY)&_ZN6S666C53v47Ev,
  (VTBL_ENTRY)&_ZN6S666C53v48Ev,
  (VTBL_ENTRY)&_ZN6S666C53v49Ev,
  (VTBL_ENTRY)&_ZN6S666C53v50Ev,
  (VTBL_ENTRY)&_ZN6S666C53v51Ev,
  (VTBL_ENTRY)&_ZN6S666C53v52Ev,
  (VTBL_ENTRY)&_ZN6S666C53v53Ev,
  (VTBL_ENTRY)&_ZN6S666C53v54Ev,
  (VTBL_ENTRY)&_ZN6S666C53v55Ev,
  (VTBL_ENTRY)&_ZN6S666C53v56Ev,
  (VTBL_ENTRY)&_ZN6S666C53v57Ev,
  (VTBL_ENTRY)&_ZN6S666C53v58Ev,
  (VTBL_ENTRY)&_ZN6S666C53v59Ev,
  (VTBL_ENTRY)&_ZN6S666C53v60Ev,
  (VTBL_ENTRY)&_ZN6S666C53v61Ev,
  (VTBL_ENTRY)&_ZN6S666C53v62Ev,
  (VTBL_ENTRY)&_ZN6S666C53v63Ev,
  (VTBL_ENTRY)&_ZN6S666C53v64Ev,
  (VTBL_ENTRY)&_ZN6S666C53v65Ev,
  (VTBL_ENTRY)&_ZN6S666C53v66Ev,
  (VTBL_ENTRY)&_ZN6S666C53v67Ev,
  (VTBL_ENTRY)&_ZN6S666C53v68Ev,
  (VTBL_ENTRY)&_ZN6S666C53v69Ev,
  (VTBL_ENTRY)&_ZN6S666C43v70Ev,
  (VTBL_ENTRY)&_ZN6S666C43v71Ev,
  (VTBL_ENTRY)&_ZN6S666C43v72Ev,
  (VTBL_ENTRY)&_ZN6S666C43v73Ev,
  (VTBL_ENTRY)&_ZN6S666C43v74Ev,
  (VTBL_ENTRY)&_ZN6S666C43v75Ev,
  (VTBL_ENTRY)&_ZN6S666C43v76Ev,
  (VTBL_ENTRY)&_ZN6S666C43v77Ev,
  (VTBL_ENTRY)&_ZN6S666C43v78Ev,
  (VTBL_ENTRY)&_ZN6S666C43v79Ev,
  (VTBL_ENTRY)&_ZN6S666C43v80Ev,
  (VTBL_ENTRY)&_ZN6S666C43v81Ev,
  (VTBL_ENTRY)&_ZN6S666C43v82Ev,
  (VTBL_ENTRY)&_ZN6S666C43v83Ev,
  (VTBL_ENTRY)&_ZN6S666C43v84Ev,
  (VTBL_ENTRY)&_ZN6S666C43v85Ev,
  (VTBL_ENTRY)&_ZN6S666C43v86Ev,
  (VTBL_ENTRY)&_ZN6S666C43v87Ev,
  (VTBL_ENTRY)&_ZN6S666C43v88Ev,
  (VTBL_ENTRY)&_ZN6S666C43v89Ev,
  (VTBL_ENTRY)&_ZN6S666C33v90Ev,
  (VTBL_ENTRY)&_ZN6S666C33v91Ev,
  (VTBL_ENTRY)&_ZN6S666C23v92Ev,
  (VTBL_ENTRY)&_ZN6S666C23v93Ev,
  (VTBL_ENTRY)&_ZN6S666C23v94Ev,
  (VTBL_ENTRY)&_ZN6S666C12v1Ev,
  (VTBL_ENTRY)&_ZN6S666C12v2Ev,
  (VTBL_ENTRY)&_ZN6S666C12v3Ev,
  (VTBL_ENTRY)&_ZN6S666C12v4Ev,
  (VTBL_ENTRY)&_ZN6S666C12v5Ev,
};
extern VTBL_ENTRY _ZTI6S666C1[];
extern  VTBL_ENTRY _ZTV6S666C1[];
Class_Descriptor cd_S666C1 = {  "S666C1", // class name
  bases_S666C1, 4,
  &(vtc_S666C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(280,184), // object size
  NSPAIRA(_ZTI6S666C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S666C1),98, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1311C4  {
  int s1311c4f0;
  __tsi64 s1311c4f1;
  void *s1311c4f2[4];
  int s1311c4f3[2];
  void *s1311c4f4;
  ::S674C6_nt s1311c4f5;
  void *s1311c4f6[2];
  virtual  ~S1311C4(); // _ZN7S1311C4D1Ev
  virtual void  v13(); // _ZN7S1311C43v13Ev
  virtual void  v14(); // _ZN7S1311C43v14Ev
  virtual void  v15(); // _ZN7S1311C43v15Ev
  virtual void  v16(); // _ZN7S1311C43v16Ev
  virtual void  v17(); // _ZN7S1311C43v17Ev
  virtual void  v18(); // _ZN7S1311C43v18Ev
  virtual void  v19(); // _ZN7S1311C43v19Ev
  virtual void  v20(); // _ZN7S1311C43v20Ev
  virtual void  v21(); // _ZN7S1311C43v21Ev
  virtual void  v22(); // _ZN7S1311C43v22Ev
  virtual void  v23(); // _ZN7S1311C43v23Ev
  virtual void  v24(); // _ZN7S1311C43v24Ev
  virtual void  v25(); // _ZN7S1311C43v25Ev
  virtual void  v26(); // _ZN7S1311C43v26Ev
  virtual void  v27(); // _ZN7S1311C43v27Ev
  virtual void  v28(); // _ZN7S1311C43v28Ev
  virtual void  v29(); // _ZN7S1311C43v29Ev
  virtual void  v30(); // _ZN7S1311C43v30Ev
  virtual void  v31(); // _ZN7S1311C43v31Ev
  virtual void  v32(); // _ZN7S1311C43v32Ev
  virtual void  v33(); // _ZN7S1311C43v33Ev
  virtual void  v34(); // _ZN7S1311C43v34Ev
  virtual void  v35(); // _ZN7S1311C43v35Ev
  virtual void  v36(); // _ZN7S1311C43v36Ev
  virtual void  v37(); // _ZN7S1311C43v37Ev
  virtual void  v38(); // _ZN7S1311C43v38Ev
  virtual void  v39(); // _ZN7S1311C43v39Ev
  virtual void  v40(); // _ZN7S1311C43v40Ev
  virtual void  v41(); // _ZN7S1311C43v41Ev
  virtual void  v42(); // _ZN7S1311C43v42Ev
  virtual void  v43(); // _ZN7S1311C43v43Ev
  virtual void  v44(); // _ZN7S1311C43v44Ev
  virtual void  v45(); // _ZN7S1311C43v45Ev
  virtual void  v46(); // _ZN7S1311C43v46Ev
  virtual void  v47(); // _ZN7S1311C43v47Ev
  virtual void  v48(); // _ZN7S1311C43v48Ev
  virtual void  v49(); // _ZN7S1311C43v49Ev
  virtual void  v50(); // _ZN7S1311C43v50Ev
  virtual void  v51(); // _ZN7S1311C43v51Ev
  virtual void  v52(); // _ZN7S1311C43v52Ev
  virtual void  v53(); // _ZN7S1311C43v53Ev
  virtual void  v54(); // _ZN7S1311C43v54Ev
  virtual void  v55(); // _ZN7S1311C43v55Ev
  virtual void  v56(); // _ZN7S1311C43v56Ev
  virtual void  v57(); // _ZN7S1311C43v57Ev
  virtual void  v58(); // _ZN7S1311C43v58Ev
  virtual void  v59(); // _ZN7S1311C43v59Ev
  virtual void  v60(); // _ZN7S1311C43v60Ev
  virtual void  v61(); // _ZN7S1311C43v61Ev
  virtual void  v62(); // _ZN7S1311C43v62Ev
  virtual void  v63(); // _ZN7S1311C43v63Ev
  virtual void  v64(); // _ZN7S1311C43v64Ev
  virtual void  v65(); // _ZN7S1311C43v65Ev
  virtual void  v66(); // _ZN7S1311C43v66Ev
  virtual void  v67(); // _ZN7S1311C43v67Ev
  virtual void  v68(); // _ZN7S1311C43v68Ev
  virtual void  v69(); // _ZN7S1311C43v69Ev
  virtual void  v70(); // _ZN7S1311C43v70Ev
  virtual void  v71(); // _ZN7S1311C43v71Ev
  virtual void  v72(); // _ZN7S1311C43v72Ev
  virtual void  v73(); // _ZN7S1311C43v73Ev
  virtual void  v74(); // _ZN7S1311C43v74Ev
  virtual void  v75(); // _ZN7S1311C43v75Ev
  virtual void  v76(); // _ZN7S1311C43v76Ev
  S1311C4(); // tgen
};
//SIG(-1 S1311C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1311C4 ::~S1311C4(){ note_dtor("S1311C4", this);}
void  S1311C4 ::v13(){vfunc_called(this, "_ZN7S1311C43v13Ev");}
void  S1311C4 ::v14(){vfunc_called(this, "_ZN7S1311C43v14Ev");}
void  S1311C4 ::v15(){vfunc_called(this, "_ZN7S1311C43v15Ev");}
void  S1311C4 ::v16(){vfunc_called(this, "_ZN7S1311C43v16Ev");}
void  S1311C4 ::v17(){vfunc_called(this, "_ZN7S1311C43v17Ev");}
void  S1311C4 ::v18(){vfunc_called(this, "_ZN7S1311C43v18Ev");}
void  S1311C4 ::v19(){vfunc_called(this, "_ZN7S1311C43v19Ev");}
void  S1311C4 ::v20(){vfunc_called(this, "_ZN7S1311C43v20Ev");}
void  S1311C4 ::v21(){vfunc_called(this, "_ZN7S1311C43v21Ev");}
void  S1311C4 ::v22(){vfunc_called(this, "_ZN7S1311C43v22Ev");}
void  S1311C4 ::v23(){vfunc_called(this, "_ZN7S1311C43v23Ev");}
void  S1311C4 ::v24(){vfunc_called(this, "_ZN7S1311C43v24Ev");}
void  S1311C4 ::v25(){vfunc_called(this, "_ZN7S1311C43v25Ev");}
void  S1311C4 ::v26(){vfunc_called(this, "_ZN7S1311C43v26Ev");}
void  S1311C4 ::v27(){vfunc_called(this, "_ZN7S1311C43v27Ev");}
void  S1311C4 ::v28(){vfunc_called(this, "_ZN7S1311C43v28Ev");}
void  S1311C4 ::v29(){vfunc_called(this, "_ZN7S1311C43v29Ev");}
void  S1311C4 ::v30(){vfunc_called(this, "_ZN7S1311C43v30Ev");}
void  S1311C4 ::v31(){vfunc_called(this, "_ZN7S1311C43v31Ev");}
void  S1311C4 ::v32(){vfunc_called(this, "_ZN7S1311C43v32Ev");}
void  S1311C4 ::v33(){vfunc_called(this, "_ZN7S1311C43v33Ev");}
void  S1311C4 ::v34(){vfunc_called(this, "_ZN7S1311C43v34Ev");}
void  S1311C4 ::v35(){vfunc_called(this, "_ZN7S1311C43v35Ev");}
void  S1311C4 ::v36(){vfunc_called(this, "_ZN7S1311C43v36Ev");}
void  S1311C4 ::v37(){vfunc_called(this, "_ZN7S1311C43v37Ev");}
void  S1311C4 ::v38(){vfunc_called(this, "_ZN7S1311C43v38Ev");}
void  S1311C4 ::v39(){vfunc_called(this, "_ZN7S1311C43v39Ev");}
void  S1311C4 ::v40(){vfunc_called(this, "_ZN7S1311C43v40Ev");}
void  S1311C4 ::v41(){vfunc_called(this, "_ZN7S1311C43v41Ev");}
void  S1311C4 ::v42(){vfunc_called(this, "_ZN7S1311C43v42Ev");}
void  S1311C4 ::v43(){vfunc_called(this, "_ZN7S1311C43v43Ev");}
void  S1311C4 ::v44(){vfunc_called(this, "_ZN7S1311C43v44Ev");}
void  S1311C4 ::v45(){vfunc_called(this, "_ZN7S1311C43v45Ev");}
void  S1311C4 ::v46(){vfunc_called(this, "_ZN7S1311C43v46Ev");}
void  S1311C4 ::v47(){vfunc_called(this, "_ZN7S1311C43v47Ev");}
void  S1311C4 ::v48(){vfunc_called(this, "_ZN7S1311C43v48Ev");}
void  S1311C4 ::v49(){vfunc_called(this, "_ZN7S1311C43v49Ev");}
void  S1311C4 ::v50(){vfunc_called(this, "_ZN7S1311C43v50Ev");}
void  S1311C4 ::v51(){vfunc_called(this, "_ZN7S1311C43v51Ev");}
void  S1311C4 ::v52(){vfunc_called(this, "_ZN7S1311C43v52Ev");}
void  S1311C4 ::v53(){vfunc_called(this, "_ZN7S1311C43v53Ev");}
void  S1311C4 ::v54(){vfunc_called(this, "_ZN7S1311C43v54Ev");}
void  S1311C4 ::v55(){vfunc_called(this, "_ZN7S1311C43v55Ev");}
void  S1311C4 ::v56(){vfunc_called(this, "_ZN7S1311C43v56Ev");}
void  S1311C4 ::v57(){vfunc_called(this, "_ZN7S1311C43v57Ev");}
void  S1311C4 ::v58(){vfunc_called(this, "_ZN7S1311C43v58Ev");}
void  S1311C4 ::v59(){vfunc_called(this, "_ZN7S1311C43v59Ev");}
void  S1311C4 ::v60(){vfunc_called(this, "_ZN7S1311C43v60Ev");}
void  S1311C4 ::v61(){vfunc_called(this, "_ZN7S1311C43v61Ev");}
void  S1311C4 ::v62(){vfunc_called(this, "_ZN7S1311C43v62Ev");}
void  S1311C4 ::v63(){vfunc_called(this, "_ZN7S1311C43v63Ev");}
void  S1311C4 ::v64(){vfunc_called(this, "_ZN7S1311C43v64Ev");}
void  S1311C4 ::v65(){vfunc_called(this, "_ZN7S1311C43v65Ev");}
void  S1311C4 ::v66(){vfunc_called(this, "_ZN7S1311C43v66Ev");}
void  S1311C4 ::v67(){vfunc_called(this, "_ZN7S1311C43v67Ev");}
void  S1311C4 ::v68(){vfunc_called(this, "_ZN7S1311C43v68Ev");}
void  S1311C4 ::v69(){vfunc_called(this, "_ZN7S1311C43v69Ev");}
void  S1311C4 ::v70(){vfunc_called(this, "_ZN7S1311C43v70Ev");}
void  S1311C4 ::v71(){vfunc_called(this, "_ZN7S1311C43v71Ev");}
void  S1311C4 ::v72(){vfunc_called(this, "_ZN7S1311C43v72Ev");}
void  S1311C4 ::v73(){vfunc_called(this, "_ZN7S1311C43v73Ev");}
void  S1311C4 ::v74(){vfunc_called(this, "_ZN7S1311C43v74Ev");}
void  S1311C4 ::v75(){vfunc_called(this, "_ZN7S1311C43v75Ev");}
void  S1311C4 ::v76(){vfunc_called(this, "_ZN7S1311C43v76Ev");}
S1311C4 ::S1311C4(){ note_ctor("S1311C4", this);} // tgen

static void Test_S1311C4()
{
  extern Class_Descriptor cd_S1311C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1311C4, buf);
    S1311C4 *dp, &lv = *(dp=new (buf) S1311C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1311C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1311C4)");
    check_field_offset(lv, s1311c4f0, ABISELECT(8,4), "S1311C4.s1311c4f0");
    check_field_offset(lv, s1311c4f1, ABISELECT(16,8), "S1311C4.s1311c4f1");
    check_field_offset(lv, s1311c4f2, ABISELECT(24,16), "S1311C4.s1311c4f2");
    check_field_offset(lv, s1311c4f3, ABISELECT(56,32), "S1311C4.s1311c4f3");
    check_field_offset(lv, s1311c4f4, ABISELECT(64,40), "S1311C4.s1311c4f4");
    check_field_offset(lv, s1311c4f5, ABISELECT(72,44), "S1311C4.s1311c4f5");
    check_field_offset(lv, s1311c4f6, ABISELECT(80,52), "S1311C4.s1311c4f6");
    test_class_info(&lv, &cd_S1311C4);
    dp->~S1311C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1311C4(Test_S1311C4, "S1311C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1311C4C1Ev();
extern void _ZN7S1311C4D1Ev();
Name_Map name_map_S1311C4[] = {
  NSPAIR(_ZN7S1311C4C1Ev),
  NSPAIR(_ZN7S1311C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1311C4[];
extern void _ZN7S1311C4D1Ev();
extern void _ZN7S1311C4D0Ev();
extern void _ZN7S1311C43v13Ev();
extern void _ZN7S1311C43v14Ev();
extern void _ZN7S1311C43v15Ev();
extern void _ZN7S1311C43v16Ev();
extern void _ZN7S1311C43v17Ev();
extern void _ZN7S1311C43v18Ev();
extern void _ZN7S1311C43v19Ev();
extern void _ZN7S1311C43v20Ev();
extern void _ZN7S1311C43v21Ev();
extern void _ZN7S1311C43v22Ev();
extern void _ZN7S1311C43v23Ev();
extern void _ZN7S1311C43v24Ev();
extern void _ZN7S1311C43v25Ev();
extern void _ZN7S1311C43v26Ev();
extern void _ZN7S1311C43v27Ev();
extern void _ZN7S1311C43v28Ev();
extern void _ZN7S1311C43v29Ev();
extern void _ZN7S1311C43v30Ev();
extern void _ZN7S1311C43v31Ev();
extern void _ZN7S1311C43v32Ev();
extern void _ZN7S1311C43v33Ev();
extern void _ZN7S1311C43v34Ev();
extern void _ZN7S1311C43v35Ev();
extern void _ZN7S1311C43v36Ev();
extern void _ZN7S1311C43v37Ev();
extern void _ZN7S1311C43v38Ev();
extern void _ZN7S1311C43v39Ev();
extern void _ZN7S1311C43v40Ev();
extern void _ZN7S1311C43v41Ev();
extern void _ZN7S1311C43v42Ev();
extern void _ZN7S1311C43v43Ev();
extern void _ZN7S1311C43v44Ev();
extern void _ZN7S1311C43v45Ev();
extern void _ZN7S1311C43v46Ev();
extern void _ZN7S1311C43v47Ev();
extern void _ZN7S1311C43v48Ev();
extern void _ZN7S1311C43v49Ev();
extern void _ZN7S1311C43v50Ev();
extern void _ZN7S1311C43v51Ev();
extern void _ZN7S1311C43v52Ev();
extern void _ZN7S1311C43v53Ev();
extern void _ZN7S1311C43v54Ev();
extern void _ZN7S1311C43v55Ev();
extern void _ZN7S1311C43v56Ev();
extern void _ZN7S1311C43v57Ev();
extern void _ZN7S1311C43v58Ev();
extern void _ZN7S1311C43v59Ev();
extern void _ZN7S1311C43v60Ev();
extern void _ZN7S1311C43v61Ev();
extern void _ZN7S1311C43v62Ev();
extern void _ZN7S1311C43v63Ev();
extern void _ZN7S1311C43v64Ev();
extern void _ZN7S1311C43v65Ev();
extern void _ZN7S1311C43v66Ev();
extern void _ZN7S1311C43v67Ev();
extern void _ZN7S1311C43v68Ev();
extern void _ZN7S1311C43v69Ev();
extern void _ZN7S1311C43v70Ev();
extern void _ZN7S1311C43v71Ev();
extern void _ZN7S1311C43v72Ev();
extern void _ZN7S1311C43v73Ev();
extern void _ZN7S1311C43v74Ev();
extern void _ZN7S1311C43v75Ev();
extern void _ZN7S1311C43v76Ev();
static  VTBL_ENTRY vtc_S1311C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1311C4[0]),
  (VTBL_ENTRY)&_ZN7S1311C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1311C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v76Ev,
};
extern VTBL_ENTRY _ZTI7S1311C4[];
extern  VTBL_ENTRY _ZTV7S1311C4[];
Class_Descriptor cd_S1311C4 = {  "S1311C4", // class name
  0,0,//no base classes
  &(vtc_S1311C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1311C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1311C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1311C3  : S1311C4 {
  unsigned int s1311c3f0:1;
  unsigned int s1311c3f1:1;
  unsigned int s1311c3f2:1;
  unsigned int s1311c3f3:1;
  unsigned int s1311c3f4:1;
  unsigned int s1311c3f5:1;
  unsigned int s1311c3f6:1;
  ::S3625C32 s1311c3f7;
  virtual  ~S1311C3(); // _ZN7S1311C3D1Ev
  virtual void  v77(); // _ZN7S1311C33v77Ev
  virtual void  v78(); // _ZN7S1311C33v78Ev
  virtual void  v79(); // _ZN7S1311C33v79Ev
  virtual void  v80(); // _ZN7S1311C33v80Ev
  virtual void  v81(); // _ZN7S1311C33v81Ev
  virtual void  v82(); // _ZN7S1311C33v82Ev
  virtual void  v83(); // _ZN7S1311C33v83Ev
  virtual void  v84(); // _ZN7S1311C33v84Ev
  virtual void  v85(); // _ZN7S1311C33v85Ev
  virtual void  v86(); // _ZN7S1311C33v86Ev
  virtual void  v87(); // _ZN7S1311C33v87Ev
  virtual void  v88(); // _ZN7S1311C33v88Ev
  virtual void  v89(); // _ZN7S1311C33v89Ev
  virtual void  v90(); // _ZN7S1311C33v90Ev
  virtual void  v91(); // _ZN7S1311C33v91Ev
  virtual void  v92(); // _ZN7S1311C33v92Ev
  virtual void  v93(); // _ZN7S1311C33v93Ev
  virtual void  v94(); // _ZN7S1311C33v94Ev
  virtual void  v95(); // _ZN7S1311C33v95Ev
  virtual void  v96(); // _ZN7S1311C33v96Ev
  S1311C3(); // tgen
};
//SIG(-1 S1311C3) C1{ BC2{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC4{ m}}


 S1311C3 ::~S1311C3(){ note_dtor("S1311C3", this);}
void  S1311C3 ::v77(){vfunc_called(this, "_ZN7S1311C33v77Ev");}
void  S1311C3 ::v78(){vfunc_called(this, "_ZN7S1311C33v78Ev");}
void  S1311C3 ::v79(){vfunc_called(this, "_ZN7S1311C33v79Ev");}
void  S1311C3 ::v80(){vfunc_called(this, "_ZN7S1311C33v80Ev");}
void  S1311C3 ::v81(){vfunc_called(this, "_ZN7S1311C33v81Ev");}
void  S1311C3 ::v82(){vfunc_called(this, "_ZN7S1311C33v82Ev");}
void  S1311C3 ::v83(){vfunc_called(this, "_ZN7S1311C33v83Ev");}
void  S1311C3 ::v84(){vfunc_called(this, "_ZN7S1311C33v84Ev");}
void  S1311C3 ::v85(){vfunc_called(this, "_ZN7S1311C33v85Ev");}
void  S1311C3 ::v86(){vfunc_called(this, "_ZN7S1311C33v86Ev");}
void  S1311C3 ::v87(){vfunc_called(this, "_ZN7S1311C33v87Ev");}
void  S1311C3 ::v88(){vfunc_called(this, "_ZN7S1311C33v88Ev");}
void  S1311C3 ::v89(){vfunc_called(this, "_ZN7S1311C33v89Ev");}
void  S1311C3 ::v90(){vfunc_called(this, "_ZN7S1311C33v90Ev");}
void  S1311C3 ::v91(){vfunc_called(this, "_ZN7S1311C33v91Ev");}
void  S1311C3 ::v92(){vfunc_called(this, "_ZN7S1311C33v92Ev");}
void  S1311C3 ::v93(){vfunc_called(this, "_ZN7S1311C33v93Ev");}
void  S1311C3 ::v94(){vfunc_called(this, "_ZN7S1311C33v94Ev");}
void  S1311C3 ::v95(){vfunc_called(this, "_ZN7S1311C33v95Ev");}
void  S1311C3 ::v96(){vfunc_called(this, "_ZN7S1311C33v96Ev");}
S1311C3 ::S1311C3(){ note_ctor("S1311C3", this);} // tgen

static void Test_S1311C3()
{
  extern Class_Descriptor cd_S1311C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S1311C3, buf);
    S1311C3 *dp, &lv = *(dp=new (buf) S1311C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S1311C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1311C3)");
    check_base_class_offset(lv, (S1311C4*), 0, "S1311C3");
    set_bf_and_test(lv, s1311c3f0, ABISELECT(96,60), 0, 1, 1, "S1311C3");
    set_bf_and_test(lv, s1311c3f1, ABISELECT(96,60), 1, 1, 1, "S1311C3");
    set_bf_and_test(lv, s1311c3f2, ABISELECT(96,60), 2, 1, 1, "S1311C3");
    set_bf_and_test(lv, s1311c3f3, ABISELECT(96,60), 3, 1, 1, "S1311C3");
    set_bf_and_test(lv, s1311c3f4, ABISELECT(96,60), 4, 1, 1, "S1311C3");
    set_bf_and_test(lv, s1311c3f5, ABISELECT(96,60), 5, 1, 1, "S1311C3");
    set_bf_and_test(lv, s1311c3f6, ABISELECT(96,60), 6, 1, 1, "S1311C3");
    check_field_offset(lv, s1311c3f7, ABISELECT(97,61), "S1311C3.s1311c3f7");
    test_class_info(&lv, &cd_S1311C3);
    dp->~S1311C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1311C3(Test_S1311C3, "S1311C3", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN7S1311C3C1Ev();
extern void _ZN7S1311C3D1Ev();
Name_Map name_map_S1311C3[] = {
  NSPAIR(_ZN7S1311C3C1Ev),
  NSPAIR(_ZN7S1311C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1311C4;
extern VTBL_ENTRY _ZTI7S1311C4[];
extern  VTBL_ENTRY _ZTV7S1311C4[];
static Base_Class bases_S1311C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1311C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1311C3[];
extern void _ZN7S1311C3D1Ev();
extern void _ZN7S1311C3D0Ev();
extern void _ZN7S1311C43v13Ev();
extern void _ZN7S1311C43v14Ev();
extern void _ZN7S1311C43v15Ev();
extern void _ZN7S1311C43v16Ev();
extern void _ZN7S1311C43v17Ev();
extern void _ZN7S1311C43v18Ev();
extern void _ZN7S1311C43v19Ev();
extern void _ZN7S1311C43v20Ev();
extern void _ZN7S1311C43v21Ev();
extern void _ZN7S1311C43v22Ev();
extern void _ZN7S1311C43v23Ev();
extern void _ZN7S1311C43v24Ev();
extern void _ZN7S1311C43v25Ev();
extern void _ZN7S1311C43v26Ev();
extern void _ZN7S1311C43v27Ev();
extern void _ZN7S1311C43v28Ev();
extern void _ZN7S1311C43v29Ev();
extern void _ZN7S1311C43v30Ev();
extern void _ZN7S1311C43v31Ev();
extern void _ZN7S1311C43v32Ev();
extern void _ZN7S1311C43v33Ev();
extern void _ZN7S1311C43v34Ev();
extern void _ZN7S1311C43v35Ev();
extern void _ZN7S1311C43v36Ev();
extern void _ZN7S1311C43v37Ev();
extern void _ZN7S1311C43v38Ev();
extern void _ZN7S1311C43v39Ev();
extern void _ZN7S1311C43v40Ev();
extern void _ZN7S1311C43v41Ev();
extern void _ZN7S1311C43v42Ev();
extern void _ZN7S1311C43v43Ev();
extern void _ZN7S1311C43v44Ev();
extern void _ZN7S1311C43v45Ev();
extern void _ZN7S1311C43v46Ev();
extern void _ZN7S1311C43v47Ev();
extern void _ZN7S1311C43v48Ev();
extern void _ZN7S1311C43v49Ev();
extern void _ZN7S1311C43v50Ev();
extern void _ZN7S1311C43v51Ev();
extern void _ZN7S1311C43v52Ev();
extern void _ZN7S1311C43v53Ev();
extern void _ZN7S1311C43v54Ev();
extern void _ZN7S1311C43v55Ev();
extern void _ZN7S1311C43v56Ev();
extern void _ZN7S1311C43v57Ev();
extern void _ZN7S1311C43v58Ev();
extern void _ZN7S1311C43v59Ev();
extern void _ZN7S1311C43v60Ev();
extern void _ZN7S1311C43v61Ev();
extern void _ZN7S1311C43v62Ev();
extern void _ZN7S1311C43v63Ev();
extern void _ZN7S1311C43v64Ev();
extern void _ZN7S1311C43v65Ev();
extern void _ZN7S1311C43v66Ev();
extern void _ZN7S1311C43v67Ev();
extern void _ZN7S1311C43v68Ev();
extern void _ZN7S1311C43v69Ev();
extern void _ZN7S1311C43v70Ev();
extern void _ZN7S1311C43v71Ev();
extern void _ZN7S1311C43v72Ev();
extern void _ZN7S1311C43v73Ev();
extern void _ZN7S1311C43v74Ev();
extern void _ZN7S1311C43v75Ev();
extern void _ZN7S1311C43v76Ev();
extern void _ZN7S1311C33v77Ev();
extern void _ZN7S1311C33v78Ev();
extern void _ZN7S1311C33v79Ev();
extern void _ZN7S1311C33v80Ev();
extern void _ZN7S1311C33v81Ev();
extern void _ZN7S1311C33v82Ev();
extern void _ZN7S1311C33v83Ev();
extern void _ZN7S1311C33v84Ev();
extern void _ZN7S1311C33v85Ev();
extern void _ZN7S1311C33v86Ev();
extern void _ZN7S1311C33v87Ev();
extern void _ZN7S1311C33v88Ev();
extern void _ZN7S1311C33v89Ev();
extern void _ZN7S1311C33v90Ev();
extern void _ZN7S1311C33v91Ev();
extern void _ZN7S1311C33v92Ev();
extern void _ZN7S1311C33v93Ev();
extern void _ZN7S1311C33v94Ev();
extern void _ZN7S1311C33v95Ev();
extern void _ZN7S1311C33v96Ev();
static  VTBL_ENTRY vtc_S1311C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1311C3[0]),
  (VTBL_ENTRY)&_ZN7S1311C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1311C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v96Ev,
};
extern VTBL_ENTRY _ZTI7S1311C3[];
extern  VTBL_ENTRY _ZTV7S1311C3[];
Class_Descriptor cd_S1311C3 = {  "S1311C3", // class name
  bases_S1311C3, 1,
  &(vtc_S1311C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI7S1311C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1311C3),88, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1311C2  : S1311C3 {
  virtual  ~S1311C2(); // _ZN7S1311C2D1Ev
  virtual void  v97(); // _ZN7S1311C23v97Ev
  virtual void  v98(); // _ZN7S1311C23v98Ev
  virtual void  v99(); // _ZN7S1311C23v99Ev
  S1311C2(); // tgen
};
//SIG(-1 S1311C2) C1{ BC2{ BC3{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC5{ m}} vd v1 v2 v3}


 S1311C2 ::~S1311C2(){ note_dtor("S1311C2", this);}
void  S1311C2 ::v97(){vfunc_called(this, "_ZN7S1311C23v97Ev");}
void  S1311C2 ::v98(){vfunc_called(this, "_ZN7S1311C23v98Ev");}
void  S1311C2 ::v99(){vfunc_called(this, "_ZN7S1311C23v99Ev");}
S1311C2 ::S1311C2(){ note_ctor("S1311C2", this);} // tgen

static void Test_S1311C2()
{
  extern Class_Descriptor cd_S1311C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S1311C2, buf);
    S1311C2 *dp, &lv = *(dp=new (buf) S1311C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S1311C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1311C2)");
    check_base_class_offset(lv, (S1311C4*)(S1311C3*), 0, "S1311C2");
    check_base_class_offset(lv, (S1311C3*), 0, "S1311C2");
    test_class_info(&lv, &cd_S1311C2);
    dp->~S1311C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1311C2(Test_S1311C2, "S1311C2", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN7S1311C2C1Ev();
extern void _ZN7S1311C2D1Ev();
Name_Map name_map_S1311C2[] = {
  NSPAIR(_ZN7S1311C2C1Ev),
  NSPAIR(_ZN7S1311C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1311C4;
extern VTBL_ENTRY _ZTI7S1311C4[];
extern  VTBL_ENTRY _ZTV7S1311C4[];
extern Class_Descriptor cd_S1311C3;
extern VTBL_ENTRY _ZTI7S1311C3[];
extern  VTBL_ENTRY _ZTV7S1311C3[];
static Base_Class bases_S1311C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1311C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1311C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1311C2[];
extern void _ZN7S1311C2D1Ev();
extern void _ZN7S1311C2D0Ev();
extern void _ZN7S1311C43v13Ev();
extern void _ZN7S1311C43v14Ev();
extern void _ZN7S1311C43v15Ev();
extern void _ZN7S1311C43v16Ev();
extern void _ZN7S1311C43v17Ev();
extern void _ZN7S1311C43v18Ev();
extern void _ZN7S1311C43v19Ev();
extern void _ZN7S1311C43v20Ev();
extern void _ZN7S1311C43v21Ev();
extern void _ZN7S1311C43v22Ev();
extern void _ZN7S1311C43v23Ev();
extern void _ZN7S1311C43v24Ev();
extern void _ZN7S1311C43v25Ev();
extern void _ZN7S1311C43v26Ev();
extern void _ZN7S1311C43v27Ev();
extern void _ZN7S1311C43v28Ev();
extern void _ZN7S1311C43v29Ev();
extern void _ZN7S1311C43v30Ev();
extern void _ZN7S1311C43v31Ev();
extern void _ZN7S1311C43v32Ev();
extern void _ZN7S1311C43v33Ev();
extern void _ZN7S1311C43v34Ev();
extern void _ZN7S1311C43v35Ev();
extern void _ZN7S1311C43v36Ev();
extern void _ZN7S1311C43v37Ev();
extern void _ZN7S1311C43v38Ev();
extern void _ZN7S1311C43v39Ev();
extern void _ZN7S1311C43v40Ev();
extern void _ZN7S1311C43v41Ev();
extern void _ZN7S1311C43v42Ev();
extern void _ZN7S1311C43v43Ev();
extern void _ZN7S1311C43v44Ev();
extern void _ZN7S1311C43v45Ev();
extern void _ZN7S1311C43v46Ev();
extern void _ZN7S1311C43v47Ev();
extern void _ZN7S1311C43v48Ev();
extern void _ZN7S1311C43v49Ev();
extern void _ZN7S1311C43v50Ev();
extern void _ZN7S1311C43v51Ev();
extern void _ZN7S1311C43v52Ev();
extern void _ZN7S1311C43v53Ev();
extern void _ZN7S1311C43v54Ev();
extern void _ZN7S1311C43v55Ev();
extern void _ZN7S1311C43v56Ev();
extern void _ZN7S1311C43v57Ev();
extern void _ZN7S1311C43v58Ev();
extern void _ZN7S1311C43v59Ev();
extern void _ZN7S1311C43v60Ev();
extern void _ZN7S1311C43v61Ev();
extern void _ZN7S1311C43v62Ev();
extern void _ZN7S1311C43v63Ev();
extern void _ZN7S1311C43v64Ev();
extern void _ZN7S1311C43v65Ev();
extern void _ZN7S1311C43v66Ev();
extern void _ZN7S1311C43v67Ev();
extern void _ZN7S1311C43v68Ev();
extern void _ZN7S1311C43v69Ev();
extern void _ZN7S1311C43v70Ev();
extern void _ZN7S1311C43v71Ev();
extern void _ZN7S1311C43v72Ev();
extern void _ZN7S1311C43v73Ev();
extern void _ZN7S1311C43v74Ev();
extern void _ZN7S1311C43v75Ev();
extern void _ZN7S1311C43v76Ev();
extern void _ZN7S1311C33v77Ev();
extern void _ZN7S1311C33v78Ev();
extern void _ZN7S1311C33v79Ev();
extern void _ZN7S1311C33v80Ev();
extern void _ZN7S1311C33v81Ev();
extern void _ZN7S1311C33v82Ev();
extern void _ZN7S1311C33v83Ev();
extern void _ZN7S1311C33v84Ev();
extern void _ZN7S1311C33v85Ev();
extern void _ZN7S1311C33v86Ev();
extern void _ZN7S1311C33v87Ev();
extern void _ZN7S1311C33v88Ev();
extern void _ZN7S1311C33v89Ev();
extern void _ZN7S1311C33v90Ev();
extern void _ZN7S1311C33v91Ev();
extern void _ZN7S1311C33v92Ev();
extern void _ZN7S1311C33v93Ev();
extern void _ZN7S1311C33v94Ev();
extern void _ZN7S1311C33v95Ev();
extern void _ZN7S1311C33v96Ev();
extern void _ZN7S1311C23v97Ev();
extern void _ZN7S1311C23v98Ev();
extern void _ZN7S1311C23v99Ev();
static  VTBL_ENTRY vtc_S1311C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1311C2[0]),
  (VTBL_ENTRY)&_ZN7S1311C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1311C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1311C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1311C23v98Ev,
  (VTBL_ENTRY)&_ZN7S1311C23v99Ev,
};
extern VTBL_ENTRY _ZTI7S1311C2[];
extern  VTBL_ENTRY _ZTV7S1311C2[];
Class_Descriptor cd_S1311C2 = {  "S1311C2", // class name
  bases_S1311C2, 2,
  &(vtc_S1311C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI7S1311C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1311C2),91, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1311C7  {
  unsigned int s1311c7f0:1;
  unsigned int s1311c7f1:1;
  unsigned int s1311c7f2:1;
};
//SIG(-1 S1311C7) C1{ Fi:1 Fi:1 Fi:1}



static void Test_S1311C7()
{
  {
    init_simple_test("S1311C7");
    static S1311C7 lv;
    check2(sizeof(lv), 4, "sizeof(S1311C7)");
    check2(__alignof__(lv), 4, "__alignof__(S1311C7)");
    set_bf_and_test(lv, s1311c7f0, 0, 0, 1, 1, "S1311C7");
    set_bf_and_test(lv, s1311c7f1, 0, 1, 1, 1, "S1311C7");
    set_bf_and_test(lv, s1311c7f2, 0, 2, 1, 1, "S1311C7");
  }
}
static Arrange_To_Call_Me vS1311C7(Test_S1311C7, "S1311C7", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1311C1  : S1311C2 {
  char s1311c1f0;
  ::S1311C7 s1311c1f1;
  ::S1292C12 s1311c1f2;
  ::S1311C7 s1311c1f3;
  ::S1292C12 s1311c1f4;
  unsigned int s1311c1f5:1;
  ::S1311C7 s1311c1f6;
  ::S1289C10_nt s1311c1f7;
  virtual  ~S1311C1(); // _ZN7S1311C1D1Ev
  virtual void  v1(); // _ZN7S1311C12v1Ev
  virtual void  v2(); // _ZN7S1311C12v2Ev
  virtual void  v3(); // _ZN7S1311C12v3Ev
  virtual void  v4(); // _ZN7S1311C12v4Ev
  virtual void  v5(); // _ZN7S1311C12v5Ev
  virtual void  v6(); // _ZN7S1311C12v6Ev
  virtual void  v7(); // _ZN7S1311C12v7Ev
  virtual void  v8(); // _ZN7S1311C12v8Ev
  virtual void  v9(); // _ZN7S1311C12v9Ev
  virtual void  v10(); // _ZN7S1311C13v10Ev
  virtual void  v11(); // _ZN7S1311C13v11Ev
  virtual void  v12(); // _ZN7S1311C13v12Ev
  S1311C1(); // tgen
};
//SIG(1 S1311C1) C1{ BC2{ BC3{ BC4{ vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC6{ m}} vd v97 v98 v99} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fc FC7{ Fi:1 Fi:1 Fi:1} FC8{ BC9{ m Fc[4] FC10{ BC11{ BC12{ m Fp Fi[2]}}} Fi[2]} Fp} FC7 FC8 Fi:1 FC7 FC13{ BC9 Fp}}


 S1311C1 ::~S1311C1(){ note_dtor("S1311C1", this);}
void  S1311C1 ::v1(){vfunc_called(this, "_ZN7S1311C12v1Ev");}
void  S1311C1 ::v2(){vfunc_called(this, "_ZN7S1311C12v2Ev");}
void  S1311C1 ::v3(){vfunc_called(this, "_ZN7S1311C12v3Ev");}
void  S1311C1 ::v4(){vfunc_called(this, "_ZN7S1311C12v4Ev");}
void  S1311C1 ::v5(){vfunc_called(this, "_ZN7S1311C12v5Ev");}
void  S1311C1 ::v6(){vfunc_called(this, "_ZN7S1311C12v6Ev");}
void  S1311C1 ::v7(){vfunc_called(this, "_ZN7S1311C12v7Ev");}
void  S1311C1 ::v8(){vfunc_called(this, "_ZN7S1311C12v8Ev");}
void  S1311C1 ::v9(){vfunc_called(this, "_ZN7S1311C12v9Ev");}
void  S1311C1 ::v10(){vfunc_called(this, "_ZN7S1311C13v10Ev");}
void  S1311C1 ::v11(){vfunc_called(this, "_ZN7S1311C13v11Ev");}
void  S1311C1 ::v12(){vfunc_called(this, "_ZN7S1311C13v12Ev");}
S1311C1 ::S1311C1(){ note_ctor("S1311C1", this);} // tgen

static void Test_S1311C1()
{
  extern Class_Descriptor cd_S1311C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(31,42)];
    init_test(&cd_S1311C1, buf);
    S1311C1 *dp, &lv = *(dp=new (buf) S1311C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(240,164), "sizeof(S1311C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1311C1)");
    check_base_class_offset(lv, (S1311C4*)(S1311C3*)(S1311C2*), 0, "S1311C1");
    check_base_class_offset(lv, (S1311C3*)(S1311C2*), 0, "S1311C1");
    check_base_class_offset(lv, (S1311C2*), 0, "S1311C1");
    check_field_offset(lv, s1311c1f0, ABISELECT(98,62), "S1311C1.s1311c1f0");
    check_field_offset(lv, s1311c1f1, ABISELECT(100,64), "S1311C1.s1311c1f1");
    check_field_offset(lv, s1311c1f2, ABISELECT(104,68), "S1311C1.s1311c1f2");
    check_field_offset(lv, s1311c1f3, ABISELECT(144,96), "S1311C1.s1311c1f3");
    check_field_offset(lv, s1311c1f4, ABISELECT(152,100), "S1311C1.s1311c1f4");
    set_bf_and_test(lv, s1311c1f5, ABISELECT(192,128), 0, 1, 1, "S1311C1");
    check_field_offset(lv, s1311c1f6, ABISELECT(196,132), "S1311C1.s1311c1f6");
    check_field_offset(lv, s1311c1f7, ABISELECT(200,136), "S1311C1.s1311c1f7");
    test_class_info(&lv, &cd_S1311C1);
    dp->~S1311C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1311C1(Test_S1311C1, "S1311C1", ABISELECT(240,164));

#else // __cplusplus

extern void _ZN7S1311C1C1Ev();
extern void _ZN7S1311C1D1Ev();
Name_Map name_map_S1311C1[] = {
  NSPAIR(_ZN7S1311C1C1Ev),
  NSPAIR(_ZN7S1311C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1311C4;
extern VTBL_ENTRY _ZTI7S1311C4[];
extern  VTBL_ENTRY _ZTV7S1311C4[];
extern Class_Descriptor cd_S1311C3;
extern VTBL_ENTRY _ZTI7S1311C3[];
extern  VTBL_ENTRY _ZTV7S1311C3[];
extern Class_Descriptor cd_S1311C2;
extern VTBL_ENTRY _ZTI7S1311C2[];
extern  VTBL_ENTRY _ZTV7S1311C2[];
static Base_Class bases_S1311C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1311C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1311C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1311C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1311C1[];
extern void _ZN7S1311C1D1Ev();
extern void _ZN7S1311C1D0Ev();
extern void _ZN7S1311C43v13Ev();
extern void _ZN7S1311C43v14Ev();
extern void _ZN7S1311C43v15Ev();
extern void _ZN7S1311C43v16Ev();
extern void _ZN7S1311C43v17Ev();
extern void _ZN7S1311C43v18Ev();
extern void _ZN7S1311C43v19Ev();
extern void _ZN7S1311C43v20Ev();
extern void _ZN7S1311C43v21Ev();
extern void _ZN7S1311C43v22Ev();
extern void _ZN7S1311C43v23Ev();
extern void _ZN7S1311C43v24Ev();
extern void _ZN7S1311C43v25Ev();
extern void _ZN7S1311C43v26Ev();
extern void _ZN7S1311C43v27Ev();
extern void _ZN7S1311C43v28Ev();
extern void _ZN7S1311C43v29Ev();
extern void _ZN7S1311C43v30Ev();
extern void _ZN7S1311C43v31Ev();
extern void _ZN7S1311C43v32Ev();
extern void _ZN7S1311C43v33Ev();
extern void _ZN7S1311C43v34Ev();
extern void _ZN7S1311C43v35Ev();
extern void _ZN7S1311C43v36Ev();
extern void _ZN7S1311C43v37Ev();
extern void _ZN7S1311C43v38Ev();
extern void _ZN7S1311C43v39Ev();
extern void _ZN7S1311C43v40Ev();
extern void _ZN7S1311C43v41Ev();
extern void _ZN7S1311C43v42Ev();
extern void _ZN7S1311C43v43Ev();
extern void _ZN7S1311C43v44Ev();
extern void _ZN7S1311C43v45Ev();
extern void _ZN7S1311C43v46Ev();
extern void _ZN7S1311C43v47Ev();
extern void _ZN7S1311C43v48Ev();
extern void _ZN7S1311C43v49Ev();
extern void _ZN7S1311C43v50Ev();
extern void _ZN7S1311C43v51Ev();
extern void _ZN7S1311C43v52Ev();
extern void _ZN7S1311C43v53Ev();
extern void _ZN7S1311C43v54Ev();
extern void _ZN7S1311C43v55Ev();
extern void _ZN7S1311C43v56Ev();
extern void _ZN7S1311C43v57Ev();
extern void _ZN7S1311C43v58Ev();
extern void _ZN7S1311C43v59Ev();
extern void _ZN7S1311C43v60Ev();
extern void _ZN7S1311C43v61Ev();
extern void _ZN7S1311C43v62Ev();
extern void _ZN7S1311C43v63Ev();
extern void _ZN7S1311C43v64Ev();
extern void _ZN7S1311C43v65Ev();
extern void _ZN7S1311C43v66Ev();
extern void _ZN7S1311C43v67Ev();
extern void _ZN7S1311C43v68Ev();
extern void _ZN7S1311C43v69Ev();
extern void _ZN7S1311C43v70Ev();
extern void _ZN7S1311C43v71Ev();
extern void _ZN7S1311C43v72Ev();
extern void _ZN7S1311C43v73Ev();
extern void _ZN7S1311C43v74Ev();
extern void _ZN7S1311C43v75Ev();
extern void _ZN7S1311C43v76Ev();
extern void _ZN7S1311C33v77Ev();
extern void _ZN7S1311C33v78Ev();
extern void _ZN7S1311C33v79Ev();
extern void _ZN7S1311C33v80Ev();
extern void _ZN7S1311C33v81Ev();
extern void _ZN7S1311C33v82Ev();
extern void _ZN7S1311C33v83Ev();
extern void _ZN7S1311C33v84Ev();
extern void _ZN7S1311C33v85Ev();
extern void _ZN7S1311C33v86Ev();
extern void _ZN7S1311C33v87Ev();
extern void _ZN7S1311C33v88Ev();
extern void _ZN7S1311C33v89Ev();
extern void _ZN7S1311C33v90Ev();
extern void _ZN7S1311C33v91Ev();
extern void _ZN7S1311C33v92Ev();
extern void _ZN7S1311C33v93Ev();
extern void _ZN7S1311C33v94Ev();
extern void _ZN7S1311C33v95Ev();
extern void _ZN7S1311C33v96Ev();
extern void _ZN7S1311C23v97Ev();
extern void _ZN7S1311C23v98Ev();
extern void _ZN7S1311C23v99Ev();
extern void _ZN7S1311C12v1Ev();
extern void _ZN7S1311C12v2Ev();
extern void _ZN7S1311C12v3Ev();
extern void _ZN7S1311C12v4Ev();
extern void _ZN7S1311C12v5Ev();
extern void _ZN7S1311C12v6Ev();
extern void _ZN7S1311C12v7Ev();
extern void _ZN7S1311C12v8Ev();
extern void _ZN7S1311C12v9Ev();
extern void _ZN7S1311C13v10Ev();
extern void _ZN7S1311C13v11Ev();
extern void _ZN7S1311C13v12Ev();
static  VTBL_ENTRY vtc_S1311C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1311C1[0]),
  (VTBL_ENTRY)&_ZN7S1311C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1311C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1311C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1311C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1311C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1311C23v98Ev,
  (VTBL_ENTRY)&_ZN7S1311C23v99Ev,
  (VTBL_ENTRY)&_ZN7S1311C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1311C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1311C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1311C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1311C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1311C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1311C12v7Ev,
  (VTBL_ENTRY)&_ZN7S1311C12v8Ev,
  (VTBL_ENTRY)&_ZN7S1311C12v9Ev,
  (VTBL_ENTRY)&_ZN7S1311C13v10Ev,
  (VTBL_ENTRY)&_ZN7S1311C13v11Ev,
  (VTBL_ENTRY)&_ZN7S1311C13v12Ev,
};
extern VTBL_ENTRY _ZTI7S1311C1[];
extern  VTBL_ENTRY _ZTV7S1311C1[];
Class_Descriptor cd_S1311C1 = {  "S1311C1", // class name
  bases_S1311C1, 3,
  &(vtc_S1311C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(240,164), // object size
  NSPAIRA(_ZTI7S1311C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1311C1),103, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1598C4  {
  int s1598c4f0;
  __tsi64 s1598c4f1;
  void *s1598c4f2[4];
  int s1598c4f3[2];
  void *s1598c4f4;
  ::S674C6_nt s1598c4f5;
  void *s1598c4f6[2];
  virtual  ~S1598C4(); // _ZN7S1598C4D1Ev
  virtual void  v9(); // _ZN7S1598C42v9Ev
  virtual void  v10(); // _ZN7S1598C43v10Ev
  virtual void  v11(); // _ZN7S1598C43v11Ev
  virtual void  v12(); // _ZN7S1598C43v12Ev
  virtual void  v13(); // _ZN7S1598C43v13Ev
  virtual void  v14(); // _ZN7S1598C43v14Ev
  virtual void  v15(); // _ZN7S1598C43v15Ev
  virtual void  v16(); // _ZN7S1598C43v16Ev
  virtual void  v17(); // _ZN7S1598C43v17Ev
  virtual void  v18(); // _ZN7S1598C43v18Ev
  virtual void  v19(); // _ZN7S1598C43v19Ev
  virtual void  v20(); // _ZN7S1598C43v20Ev
  virtual void  v21(); // _ZN7S1598C43v21Ev
  virtual void  v22(); // _ZN7S1598C43v22Ev
  virtual void  v23(); // _ZN7S1598C43v23Ev
  virtual void  v24(); // _ZN7S1598C43v24Ev
  virtual void  v25(); // _ZN7S1598C43v25Ev
  virtual void  v26(); // _ZN7S1598C43v26Ev
  virtual void  v27(); // _ZN7S1598C43v27Ev
  virtual void  v28(); // _ZN7S1598C43v28Ev
  virtual void  v29(); // _ZN7S1598C43v29Ev
  virtual void  v30(); // _ZN7S1598C43v30Ev
  virtual void  v31(); // _ZN7S1598C43v31Ev
  virtual void  v32(); // _ZN7S1598C43v32Ev
  virtual void  v33(); // _ZN7S1598C43v33Ev
  virtual void  v34(); // _ZN7S1598C43v34Ev
  virtual void  v35(); // _ZN7S1598C43v35Ev
  virtual void  v36(); // _ZN7S1598C43v36Ev
  virtual void  v37(); // _ZN7S1598C43v37Ev
  virtual void  v38(); // _ZN7S1598C43v38Ev
  virtual void  v39(); // _ZN7S1598C43v39Ev
  virtual void  v40(); // _ZN7S1598C43v40Ev
  virtual void  v41(); // _ZN7S1598C43v41Ev
  virtual void  v42(); // _ZN7S1598C43v42Ev
  virtual void  v43(); // _ZN7S1598C43v43Ev
  virtual void  v44(); // _ZN7S1598C43v44Ev
  virtual void  v45(); // _ZN7S1598C43v45Ev
  virtual void  v46(); // _ZN7S1598C43v46Ev
  virtual void  v47(); // _ZN7S1598C43v47Ev
  virtual void  v48(); // _ZN7S1598C43v48Ev
  virtual void  v49(); // _ZN7S1598C43v49Ev
  virtual void  v50(); // _ZN7S1598C43v50Ev
  virtual void  v51(); // _ZN7S1598C43v51Ev
  virtual void  v52(); // _ZN7S1598C43v52Ev
  virtual void  v53(); // _ZN7S1598C43v53Ev
  virtual void  v54(); // _ZN7S1598C43v54Ev
  virtual void  v55(); // _ZN7S1598C43v55Ev
  virtual void  v56(); // _ZN7S1598C43v56Ev
  virtual void  v57(); // _ZN7S1598C43v57Ev
  virtual void  v58(); // _ZN7S1598C43v58Ev
  virtual void  v59(); // _ZN7S1598C43v59Ev
  virtual void  v60(); // _ZN7S1598C43v60Ev
  virtual void  v61(); // _ZN7S1598C43v61Ev
  virtual void  v62(); // _ZN7S1598C43v62Ev
  virtual void  v63(); // _ZN7S1598C43v63Ev
  virtual void  v64(); // _ZN7S1598C43v64Ev
  virtual void  v65(); // _ZN7S1598C43v65Ev
  virtual void  v66(); // _ZN7S1598C43v66Ev
  virtual void  v67(); // _ZN7S1598C43v67Ev
  virtual void  v68(); // _ZN7S1598C43v68Ev
  virtual void  v69(); // _ZN7S1598C43v69Ev
  virtual void  v70(); // _ZN7S1598C43v70Ev
  virtual void  v71(); // _ZN7S1598C43v71Ev
  virtual void  v72(); // _ZN7S1598C43v72Ev
  S1598C4(); // tgen
};
//SIG(-1 S1598C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1598C4 ::~S1598C4(){ note_dtor("S1598C4", this);}
void  S1598C4 ::v9(){vfunc_called(this, "_ZN7S1598C42v9Ev");}
void  S1598C4 ::v10(){vfunc_called(this, "_ZN7S1598C43v10Ev");}
void  S1598C4 ::v11(){vfunc_called(this, "_ZN7S1598C43v11Ev");}
void  S1598C4 ::v12(){vfunc_called(this, "_ZN7S1598C43v12Ev");}
void  S1598C4 ::v13(){vfunc_called(this, "_ZN7S1598C43v13Ev");}
void  S1598C4 ::v14(){vfunc_called(this, "_ZN7S1598C43v14Ev");}
void  S1598C4 ::v15(){vfunc_called(this, "_ZN7S1598C43v15Ev");}
void  S1598C4 ::v16(){vfunc_called(this, "_ZN7S1598C43v16Ev");}
void  S1598C4 ::v17(){vfunc_called(this, "_ZN7S1598C43v17Ev");}
void  S1598C4 ::v18(){vfunc_called(this, "_ZN7S1598C43v18Ev");}
void  S1598C4 ::v19(){vfunc_called(this, "_ZN7S1598C43v19Ev");}
void  S1598C4 ::v20(){vfunc_called(this, "_ZN7S1598C43v20Ev");}
void  S1598C4 ::v21(){vfunc_called(this, "_ZN7S1598C43v21Ev");}
void  S1598C4 ::v22(){vfunc_called(this, "_ZN7S1598C43v22Ev");}
void  S1598C4 ::v23(){vfunc_called(this, "_ZN7S1598C43v23Ev");}
void  S1598C4 ::v24(){vfunc_called(this, "_ZN7S1598C43v24Ev");}
void  S1598C4 ::v25(){vfunc_called(this, "_ZN7S1598C43v25Ev");}
void  S1598C4 ::v26(){vfunc_called(this, "_ZN7S1598C43v26Ev");}
void  S1598C4 ::v27(){vfunc_called(this, "_ZN7S1598C43v27Ev");}
void  S1598C4 ::v28(){vfunc_called(this, "_ZN7S1598C43v28Ev");}
void  S1598C4 ::v29(){vfunc_called(this, "_ZN7S1598C43v29Ev");}
void  S1598C4 ::v30(){vfunc_called(this, "_ZN7S1598C43v30Ev");}
void  S1598C4 ::v31(){vfunc_called(this, "_ZN7S1598C43v31Ev");}
void  S1598C4 ::v32(){vfunc_called(this, "_ZN7S1598C43v32Ev");}
void  S1598C4 ::v33(){vfunc_called(this, "_ZN7S1598C43v33Ev");}
void  S1598C4 ::v34(){vfunc_called(this, "_ZN7S1598C43v34Ev");}
void  S1598C4 ::v35(){vfunc_called(this, "_ZN7S1598C43v35Ev");}
void  S1598C4 ::v36(){vfunc_called(this, "_ZN7S1598C43v36Ev");}
void  S1598C4 ::v37(){vfunc_called(this, "_ZN7S1598C43v37Ev");}
void  S1598C4 ::v38(){vfunc_called(this, "_ZN7S1598C43v38Ev");}
void  S1598C4 ::v39(){vfunc_called(this, "_ZN7S1598C43v39Ev");}
void  S1598C4 ::v40(){vfunc_called(this, "_ZN7S1598C43v40Ev");}
void  S1598C4 ::v41(){vfunc_called(this, "_ZN7S1598C43v41Ev");}
void  S1598C4 ::v42(){vfunc_called(this, "_ZN7S1598C43v42Ev");}
void  S1598C4 ::v43(){vfunc_called(this, "_ZN7S1598C43v43Ev");}
void  S1598C4 ::v44(){vfunc_called(this, "_ZN7S1598C43v44Ev");}
void  S1598C4 ::v45(){vfunc_called(this, "_ZN7S1598C43v45Ev");}
void  S1598C4 ::v46(){vfunc_called(this, "_ZN7S1598C43v46Ev");}
void  S1598C4 ::v47(){vfunc_called(this, "_ZN7S1598C43v47Ev");}
void  S1598C4 ::v48(){vfunc_called(this, "_ZN7S1598C43v48Ev");}
void  S1598C4 ::v49(){vfunc_called(this, "_ZN7S1598C43v49Ev");}
void  S1598C4 ::v50(){vfunc_called(this, "_ZN7S1598C43v50Ev");}
void  S1598C4 ::v51(){vfunc_called(this, "_ZN7S1598C43v51Ev");}
void  S1598C4 ::v52(){vfunc_called(this, "_ZN7S1598C43v52Ev");}
void  S1598C4 ::v53(){vfunc_called(this, "_ZN7S1598C43v53Ev");}
void  S1598C4 ::v54(){vfunc_called(this, "_ZN7S1598C43v54Ev");}
void  S1598C4 ::v55(){vfunc_called(this, "_ZN7S1598C43v55Ev");}
void  S1598C4 ::v56(){vfunc_called(this, "_ZN7S1598C43v56Ev");}
void  S1598C4 ::v57(){vfunc_called(this, "_ZN7S1598C43v57Ev");}
void  S1598C4 ::v58(){vfunc_called(this, "_ZN7S1598C43v58Ev");}
void  S1598C4 ::v59(){vfunc_called(this, "_ZN7S1598C43v59Ev");}
void  S1598C4 ::v60(){vfunc_called(this, "_ZN7S1598C43v60Ev");}
void  S1598C4 ::v61(){vfunc_called(this, "_ZN7S1598C43v61Ev");}
void  S1598C4 ::v62(){vfunc_called(this, "_ZN7S1598C43v62Ev");}
void  S1598C4 ::v63(){vfunc_called(this, "_ZN7S1598C43v63Ev");}
void  S1598C4 ::v64(){vfunc_called(this, "_ZN7S1598C43v64Ev");}
void  S1598C4 ::v65(){vfunc_called(this, "_ZN7S1598C43v65Ev");}
void  S1598C4 ::v66(){vfunc_called(this, "_ZN7S1598C43v66Ev");}
void  S1598C4 ::v67(){vfunc_called(this, "_ZN7S1598C43v67Ev");}
void  S1598C4 ::v68(){vfunc_called(this, "_ZN7S1598C43v68Ev");}
void  S1598C4 ::v69(){vfunc_called(this, "_ZN7S1598C43v69Ev");}
void  S1598C4 ::v70(){vfunc_called(this, "_ZN7S1598C43v70Ev");}
void  S1598C4 ::v71(){vfunc_called(this, "_ZN7S1598C43v71Ev");}
void  S1598C4 ::v72(){vfunc_called(this, "_ZN7S1598C43v72Ev");}
S1598C4 ::S1598C4(){ note_ctor("S1598C4", this);} // tgen

static void Test_S1598C4()
{
  extern Class_Descriptor cd_S1598C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1598C4, buf);
    S1598C4 *dp, &lv = *(dp=new (buf) S1598C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1598C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1598C4)");
    check_field_offset(lv, s1598c4f0, ABISELECT(8,4), "S1598C4.s1598c4f0");
    check_field_offset(lv, s1598c4f1, ABISELECT(16,8), "S1598C4.s1598c4f1");
    check_field_offset(lv, s1598c4f2, ABISELECT(24,16), "S1598C4.s1598c4f2");
    check_field_offset(lv, s1598c4f3, ABISELECT(56,32), "S1598C4.s1598c4f3");
    check_field_offset(lv, s1598c4f4, ABISELECT(64,40), "S1598C4.s1598c4f4");
    check_field_offset(lv, s1598c4f5, ABISELECT(72,44), "S1598C4.s1598c4f5");
    check_field_offset(lv, s1598c4f6, ABISELECT(80,52), "S1598C4.s1598c4f6");
    test_class_info(&lv, &cd_S1598C4);
    dp->~S1598C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1598C4(Test_S1598C4, "S1598C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1598C4C1Ev();
extern void _ZN7S1598C4D1Ev();
Name_Map name_map_S1598C4[] = {
  NSPAIR(_ZN7S1598C4C1Ev),
  NSPAIR(_ZN7S1598C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1598C4[];
extern void _ZN7S1598C4D1Ev();
extern void _ZN7S1598C4D0Ev();
extern void _ZN7S1598C42v9Ev();
extern void _ZN7S1598C43v10Ev();
extern void _ZN7S1598C43v11Ev();
extern void _ZN7S1598C43v12Ev();
extern void _ZN7S1598C43v13Ev();
extern void _ZN7S1598C43v14Ev();
extern void _ZN7S1598C43v15Ev();
extern void _ZN7S1598C43v16Ev();
extern void _ZN7S1598C43v17Ev();
extern void _ZN7S1598C43v18Ev();
extern void _ZN7S1598C43v19Ev();
extern void _ZN7S1598C43v20Ev();
extern void _ZN7S1598C43v21Ev();
extern void _ZN7S1598C43v22Ev();
extern void _ZN7S1598C43v23Ev();
extern void _ZN7S1598C43v24Ev();
extern void _ZN7S1598C43v25Ev();
extern void _ZN7S1598C43v26Ev();
extern void _ZN7S1598C43v27Ev();
extern void _ZN7S1598C43v28Ev();
extern void _ZN7S1598C43v29Ev();
extern void _ZN7S1598C43v30Ev();
extern void _ZN7S1598C43v31Ev();
extern void _ZN7S1598C43v32Ev();
extern void _ZN7S1598C43v33Ev();
extern void _ZN7S1598C43v34Ev();
extern void _ZN7S1598C43v35Ev();
extern void _ZN7S1598C43v36Ev();
extern void _ZN7S1598C43v37Ev();
extern void _ZN7S1598C43v38Ev();
extern void _ZN7S1598C43v39Ev();
extern void _ZN7S1598C43v40Ev();
extern void _ZN7S1598C43v41Ev();
extern void _ZN7S1598C43v42Ev();
extern void _ZN7S1598C43v43Ev();
extern void _ZN7S1598C43v44Ev();
extern void _ZN7S1598C43v45Ev();
extern void _ZN7S1598C43v46Ev();
extern void _ZN7S1598C43v47Ev();
extern void _ZN7S1598C43v48Ev();
extern void _ZN7S1598C43v49Ev();
extern void _ZN7S1598C43v50Ev();
extern void _ZN7S1598C43v51Ev();
extern void _ZN7S1598C43v52Ev();
extern void _ZN7S1598C43v53Ev();
extern void _ZN7S1598C43v54Ev();
extern void _ZN7S1598C43v55Ev();
extern void _ZN7S1598C43v56Ev();
extern void _ZN7S1598C43v57Ev();
extern void _ZN7S1598C43v58Ev();
extern void _ZN7S1598C43v59Ev();
extern void _ZN7S1598C43v60Ev();
extern void _ZN7S1598C43v61Ev();
extern void _ZN7S1598C43v62Ev();
extern void _ZN7S1598C43v63Ev();
extern void _ZN7S1598C43v64Ev();
extern void _ZN7S1598C43v65Ev();
extern void _ZN7S1598C43v66Ev();
extern void _ZN7S1598C43v67Ev();
extern void _ZN7S1598C43v68Ev();
extern void _ZN7S1598C43v69Ev();
extern void _ZN7S1598C43v70Ev();
extern void _ZN7S1598C43v71Ev();
extern void _ZN7S1598C43v72Ev();
static  VTBL_ENTRY vtc_S1598C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1598C4[0]),
  (VTBL_ENTRY)&_ZN7S1598C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1598C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1598C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v72Ev,
};
extern VTBL_ENTRY _ZTI7S1598C4[];
extern  VTBL_ENTRY _ZTV7S1598C4[];
Class_Descriptor cd_S1598C4 = {  "S1598C4", // class name
  0,0,//no base classes
  &(vtc_S1598C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1598C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1598C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1598C3  : S1598C4 {
  unsigned int s1598c3f0:1;
  unsigned int s1598c3f1:1;
  unsigned int s1598c3f2:1;
  unsigned int s1598c3f3:1;
  unsigned int s1598c3f4:1;
  unsigned int s1598c3f5:1;
  unsigned int s1598c3f6:1;
  ::S3625C32 s1598c3f7;
  virtual  ~S1598C3(); // _ZN7S1598C3D1Ev
  virtual void  v73(); // _ZN7S1598C33v73Ev
  virtual void  v74(); // _ZN7S1598C33v74Ev
  virtual void  v75(); // _ZN7S1598C33v75Ev
  virtual void  v76(); // _ZN7S1598C33v76Ev
  virtual void  v77(); // _ZN7S1598C33v77Ev
  virtual void  v78(); // _ZN7S1598C33v78Ev
  virtual void  v79(); // _ZN7S1598C33v79Ev
  virtual void  v80(); // _ZN7S1598C33v80Ev
  virtual void  v81(); // _ZN7S1598C33v81Ev
  virtual void  v82(); // _ZN7S1598C33v82Ev
  virtual void  v83(); // _ZN7S1598C33v83Ev
  virtual void  v84(); // _ZN7S1598C33v84Ev
  virtual void  v85(); // _ZN7S1598C33v85Ev
  virtual void  v86(); // _ZN7S1598C33v86Ev
  virtual void  v87(); // _ZN7S1598C33v87Ev
  virtual void  v88(); // _ZN7S1598C33v88Ev
  virtual void  v89(); // _ZN7S1598C33v89Ev
  virtual void  v90(); // _ZN7S1598C33v90Ev
  virtual void  v91(); // _ZN7S1598C33v91Ev
  virtual void  v92(); // _ZN7S1598C33v92Ev
  S1598C3(); // tgen
};
//SIG(-1 S1598C3) C1{ BC2{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC4{ m}}


 S1598C3 ::~S1598C3(){ note_dtor("S1598C3", this);}
void  S1598C3 ::v73(){vfunc_called(this, "_ZN7S1598C33v73Ev");}
void  S1598C3 ::v74(){vfunc_called(this, "_ZN7S1598C33v74Ev");}
void  S1598C3 ::v75(){vfunc_called(this, "_ZN7S1598C33v75Ev");}
void  S1598C3 ::v76(){vfunc_called(this, "_ZN7S1598C33v76Ev");}
void  S1598C3 ::v77(){vfunc_called(this, "_ZN7S1598C33v77Ev");}
void  S1598C3 ::v78(){vfunc_called(this, "_ZN7S1598C33v78Ev");}
void  S1598C3 ::v79(){vfunc_called(this, "_ZN7S1598C33v79Ev");}
void  S1598C3 ::v80(){vfunc_called(this, "_ZN7S1598C33v80Ev");}
void  S1598C3 ::v81(){vfunc_called(this, "_ZN7S1598C33v81Ev");}
void  S1598C3 ::v82(){vfunc_called(this, "_ZN7S1598C33v82Ev");}
void  S1598C3 ::v83(){vfunc_called(this, "_ZN7S1598C33v83Ev");}
void  S1598C3 ::v84(){vfunc_called(this, "_ZN7S1598C33v84Ev");}
void  S1598C3 ::v85(){vfunc_called(this, "_ZN7S1598C33v85Ev");}
void  S1598C3 ::v86(){vfunc_called(this, "_ZN7S1598C33v86Ev");}
void  S1598C3 ::v87(){vfunc_called(this, "_ZN7S1598C33v87Ev");}
void  S1598C3 ::v88(){vfunc_called(this, "_ZN7S1598C33v88Ev");}
void  S1598C3 ::v89(){vfunc_called(this, "_ZN7S1598C33v89Ev");}
void  S1598C3 ::v90(){vfunc_called(this, "_ZN7S1598C33v90Ev");}
void  S1598C3 ::v91(){vfunc_called(this, "_ZN7S1598C33v91Ev");}
void  S1598C3 ::v92(){vfunc_called(this, "_ZN7S1598C33v92Ev");}
S1598C3 ::S1598C3(){ note_ctor("S1598C3", this);} // tgen

static void Test_S1598C3()
{
  extern Class_Descriptor cd_S1598C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S1598C3, buf);
    S1598C3 *dp, &lv = *(dp=new (buf) S1598C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S1598C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1598C3)");
    check_base_class_offset(lv, (S1598C4*), 0, "S1598C3");
    set_bf_and_test(lv, s1598c3f0, ABISELECT(96,60), 0, 1, 1, "S1598C3");
    set_bf_and_test(lv, s1598c3f1, ABISELECT(96,60), 1, 1, 1, "S1598C3");
    set_bf_and_test(lv, s1598c3f2, ABISELECT(96,60), 2, 1, 1, "S1598C3");
    set_bf_and_test(lv, s1598c3f3, ABISELECT(96,60), 3, 1, 1, "S1598C3");
    set_bf_and_test(lv, s1598c3f4, ABISELECT(96,60), 4, 1, 1, "S1598C3");
    set_bf_and_test(lv, s1598c3f5, ABISELECT(96,60), 5, 1, 1, "S1598C3");
    set_bf_and_test(lv, s1598c3f6, ABISELECT(96,60), 6, 1, 1, "S1598C3");
    check_field_offset(lv, s1598c3f7, ABISELECT(97,61), "S1598C3.s1598c3f7");
    test_class_info(&lv, &cd_S1598C3);
    dp->~S1598C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1598C3(Test_S1598C3, "S1598C3", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN7S1598C3C1Ev();
extern void _ZN7S1598C3D1Ev();
Name_Map name_map_S1598C3[] = {
  NSPAIR(_ZN7S1598C3C1Ev),
  NSPAIR(_ZN7S1598C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1598C4;
extern VTBL_ENTRY _ZTI7S1598C4[];
extern  VTBL_ENTRY _ZTV7S1598C4[];
static Base_Class bases_S1598C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1598C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1598C3[];
extern void _ZN7S1598C3D1Ev();
extern void _ZN7S1598C3D0Ev();
extern void _ZN7S1598C42v9Ev();
extern void _ZN7S1598C43v10Ev();
extern void _ZN7S1598C43v11Ev();
extern void _ZN7S1598C43v12Ev();
extern void _ZN7S1598C43v13Ev();
extern void _ZN7S1598C43v14Ev();
extern void _ZN7S1598C43v15Ev();
extern void _ZN7S1598C43v16Ev();
extern void _ZN7S1598C43v17Ev();
extern void _ZN7S1598C43v18Ev();
extern void _ZN7S1598C43v19Ev();
extern void _ZN7S1598C43v20Ev();
extern void _ZN7S1598C43v21Ev();
extern void _ZN7S1598C43v22Ev();
extern void _ZN7S1598C43v23Ev();
extern void _ZN7S1598C43v24Ev();
extern void _ZN7S1598C43v25Ev();
extern void _ZN7S1598C43v26Ev();
extern void _ZN7S1598C43v27Ev();
extern void _ZN7S1598C43v28Ev();
extern void _ZN7S1598C43v29Ev();
extern void _ZN7S1598C43v30Ev();
extern void _ZN7S1598C43v31Ev();
extern void _ZN7S1598C43v32Ev();
extern void _ZN7S1598C43v33Ev();
extern void _ZN7S1598C43v34Ev();
extern void _ZN7S1598C43v35Ev();
extern void _ZN7S1598C43v36Ev();
extern void _ZN7S1598C43v37Ev();
extern void _ZN7S1598C43v38Ev();
extern void _ZN7S1598C43v39Ev();
extern void _ZN7S1598C43v40Ev();
extern void _ZN7S1598C43v41Ev();
extern void _ZN7S1598C43v42Ev();
extern void _ZN7S1598C43v43Ev();
extern void _ZN7S1598C43v44Ev();
extern void _ZN7S1598C43v45Ev();
extern void _ZN7S1598C43v46Ev();
extern void _ZN7S1598C43v47Ev();
extern void _ZN7S1598C43v48Ev();
extern void _ZN7S1598C43v49Ev();
extern void _ZN7S1598C43v50Ev();
extern void _ZN7S1598C43v51Ev();
extern void _ZN7S1598C43v52Ev();
extern void _ZN7S1598C43v53Ev();
extern void _ZN7S1598C43v54Ev();
extern void _ZN7S1598C43v55Ev();
extern void _ZN7S1598C43v56Ev();
extern void _ZN7S1598C43v57Ev();
extern void _ZN7S1598C43v58Ev();
extern void _ZN7S1598C43v59Ev();
extern void _ZN7S1598C43v60Ev();
extern void _ZN7S1598C43v61Ev();
extern void _ZN7S1598C43v62Ev();
extern void _ZN7S1598C43v63Ev();
extern void _ZN7S1598C43v64Ev();
extern void _ZN7S1598C43v65Ev();
extern void _ZN7S1598C43v66Ev();
extern void _ZN7S1598C43v67Ev();
extern void _ZN7S1598C43v68Ev();
extern void _ZN7S1598C43v69Ev();
extern void _ZN7S1598C43v70Ev();
extern void _ZN7S1598C43v71Ev();
extern void _ZN7S1598C43v72Ev();
extern void _ZN7S1598C33v73Ev();
extern void _ZN7S1598C33v74Ev();
extern void _ZN7S1598C33v75Ev();
extern void _ZN7S1598C33v76Ev();
extern void _ZN7S1598C33v77Ev();
extern void _ZN7S1598C33v78Ev();
extern void _ZN7S1598C33v79Ev();
extern void _ZN7S1598C33v80Ev();
extern void _ZN7S1598C33v81Ev();
extern void _ZN7S1598C33v82Ev();
extern void _ZN7S1598C33v83Ev();
extern void _ZN7S1598C33v84Ev();
extern void _ZN7S1598C33v85Ev();
extern void _ZN7S1598C33v86Ev();
extern void _ZN7S1598C33v87Ev();
extern void _ZN7S1598C33v88Ev();
extern void _ZN7S1598C33v89Ev();
extern void _ZN7S1598C33v90Ev();
extern void _ZN7S1598C33v91Ev();
extern void _ZN7S1598C33v92Ev();
static  VTBL_ENTRY vtc_S1598C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1598C3[0]),
  (VTBL_ENTRY)&_ZN7S1598C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1598C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1598C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v92Ev,
};
extern VTBL_ENTRY _ZTI7S1598C3[];
extern  VTBL_ENTRY _ZTV7S1598C3[];
Class_Descriptor cd_S1598C3 = {  "S1598C3", // class name
  bases_S1598C3, 1,
  &(vtc_S1598C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI7S1598C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1598C3),88, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1598C2  : S1598C3 {
  ::S674C42 s1598c2f0;
  virtual  ~S1598C2(); // _ZN7S1598C2D1Ev
  virtual void  v93(); // _ZN7S1598C23v93Ev
  virtual void  v94(); // _ZN7S1598C23v94Ev
  virtual void  v95(); // _ZN7S1598C23v95Ev
  virtual void  v96(); // _ZN7S1598C23v96Ev
  S1598C2(); // tgen
};
//SIG(-1 S1598C2) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC5{ m}} vd v1 v2 v3 v4 FC6{ BC7{ BC8{ m Fp Fi[2]}}}}


 S1598C2 ::~S1598C2(){ note_dtor("S1598C2", this);}
void  S1598C2 ::v93(){vfunc_called(this, "_ZN7S1598C23v93Ev");}
void  S1598C2 ::v94(){vfunc_called(this, "_ZN7S1598C23v94Ev");}
void  S1598C2 ::v95(){vfunc_called(this, "_ZN7S1598C23v95Ev");}
void  S1598C2 ::v96(){vfunc_called(this, "_ZN7S1598C23v96Ev");}
S1598C2 ::S1598C2(){ note_ctor("S1598C2", this);} // tgen

static void Test_S1598C2()
{
  extern Class_Descriptor cd_S1598C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(16,20)];
    init_test(&cd_S1598C2, buf);
    S1598C2 *dp, &lv = *(dp=new (buf) S1598C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(120,76), "sizeof(S1598C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1598C2)");
    check_base_class_offset(lv, (S1598C4*)(S1598C3*), 0, "S1598C2");
    check_base_class_offset(lv, (S1598C3*), 0, "S1598C2");
    check_field_offset(lv, s1598c2f0, ABISELECT(104,64), "S1598C2.s1598c2f0");
    test_class_info(&lv, &cd_S1598C2);
    dp->~S1598C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1598C2(Test_S1598C2, "S1598C2", ABISELECT(120,76));

#else // __cplusplus

extern void _ZN7S1598C2C1Ev();
extern void _ZN7S1598C2D1Ev();
Name_Map name_map_S1598C2[] = {
  NSPAIR(_ZN7S1598C2C1Ev),
  NSPAIR(_ZN7S1598C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1598C4;
extern VTBL_ENTRY _ZTI7S1598C4[];
extern  VTBL_ENTRY _ZTV7S1598C4[];
extern Class_Descriptor cd_S1598C3;
extern VTBL_ENTRY _ZTI7S1598C3[];
extern  VTBL_ENTRY _ZTV7S1598C3[];
static Base_Class bases_S1598C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1598C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1598C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1598C2[];
extern void _ZN7S1598C2D1Ev();
extern void _ZN7S1598C2D0Ev();
extern void _ZN7S1598C42v9Ev();
extern void _ZN7S1598C43v10Ev();
extern void _ZN7S1598C43v11Ev();
extern void _ZN7S1598C43v12Ev();
extern void _ZN7S1598C43v13Ev();
extern void _ZN7S1598C43v14Ev();
extern void _ZN7S1598C43v15Ev();
extern void _ZN7S1598C43v16Ev();
extern void _ZN7S1598C43v17Ev();
extern void _ZN7S1598C43v18Ev();
extern void _ZN7S1598C43v19Ev();
extern void _ZN7S1598C43v20Ev();
extern void _ZN7S1598C43v21Ev();
extern void _ZN7S1598C43v22Ev();
extern void _ZN7S1598C43v23Ev();
extern void _ZN7S1598C43v24Ev();
extern void _ZN7S1598C43v25Ev();
extern void _ZN7S1598C43v26Ev();
extern void _ZN7S1598C43v27Ev();
extern void _ZN7S1598C43v28Ev();
extern void _ZN7S1598C43v29Ev();
extern void _ZN7S1598C43v30Ev();
extern void _ZN7S1598C43v31Ev();
extern void _ZN7S1598C43v32Ev();
extern void _ZN7S1598C43v33Ev();
extern void _ZN7S1598C43v34Ev();
extern void _ZN7S1598C43v35Ev();
extern void _ZN7S1598C43v36Ev();
extern void _ZN7S1598C43v37Ev();
extern void _ZN7S1598C43v38Ev();
extern void _ZN7S1598C43v39Ev();
extern void _ZN7S1598C43v40Ev();
extern void _ZN7S1598C43v41Ev();
extern void _ZN7S1598C43v42Ev();
extern void _ZN7S1598C43v43Ev();
extern void _ZN7S1598C43v44Ev();
extern void _ZN7S1598C43v45Ev();
extern void _ZN7S1598C43v46Ev();
extern void _ZN7S1598C43v47Ev();
extern void _ZN7S1598C43v48Ev();
extern void _ZN7S1598C43v49Ev();
extern void _ZN7S1598C43v50Ev();
extern void _ZN7S1598C43v51Ev();
extern void _ZN7S1598C43v52Ev();
extern void _ZN7S1598C43v53Ev();
extern void _ZN7S1598C43v54Ev();
extern void _ZN7S1598C43v55Ev();
extern void _ZN7S1598C43v56Ev();
extern void _ZN7S1598C43v57Ev();
extern void _ZN7S1598C43v58Ev();
extern void _ZN7S1598C43v59Ev();
extern void _ZN7S1598C43v60Ev();
extern void _ZN7S1598C43v61Ev();
extern void _ZN7S1598C43v62Ev();
extern void _ZN7S1598C43v63Ev();
extern void _ZN7S1598C43v64Ev();
extern void _ZN7S1598C43v65Ev();
extern void _ZN7S1598C43v66Ev();
extern void _ZN7S1598C43v67Ev();
extern void _ZN7S1598C43v68Ev();
extern void _ZN7S1598C43v69Ev();
extern void _ZN7S1598C43v70Ev();
extern void _ZN7S1598C43v71Ev();
extern void _ZN7S1598C43v72Ev();
extern void _ZN7S1598C33v73Ev();
extern void _ZN7S1598C33v74Ev();
extern void _ZN7S1598C33v75Ev();
extern void _ZN7S1598C33v76Ev();
extern void _ZN7S1598C33v77Ev();
extern void _ZN7S1598C33v78Ev();
extern void _ZN7S1598C33v79Ev();
extern void _ZN7S1598C33v80Ev();
extern void _ZN7S1598C33v81Ev();
extern void _ZN7S1598C33v82Ev();
extern void _ZN7S1598C33v83Ev();
extern void _ZN7S1598C33v84Ev();
extern void _ZN7S1598C33v85Ev();
extern void _ZN7S1598C33v86Ev();
extern void _ZN7S1598C33v87Ev();
extern void _ZN7S1598C33v88Ev();
extern void _ZN7S1598C33v89Ev();
extern void _ZN7S1598C33v90Ev();
extern void _ZN7S1598C33v91Ev();
extern void _ZN7S1598C33v92Ev();
extern void _ZN7S1598C23v93Ev();
extern void _ZN7S1598C23v94Ev();
extern void _ZN7S1598C23v95Ev();
extern void _ZN7S1598C23v96Ev();
static  VTBL_ENTRY vtc_S1598C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1598C2[0]),
  (VTBL_ENTRY)&_ZN7S1598C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1598C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1598C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1598C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1598C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1598C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1598C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1598C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1598C23v96Ev,
};
extern VTBL_ENTRY _ZTI7S1598C2[];
extern  VTBL_ENTRY _ZTV7S1598C2[];
Class_Descriptor cd_S1598C2 = {  "S1598C2", // class name
  bases_S1598C2, 2,
  &(vtc_S1598C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(120,76), // object size
  NSPAIRA(_ZTI7S1598C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1598C2),92, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1598C1  : S1598C2 {
  ::S1292C12 s1598c1f0;
  ::S1289C10_nt s1598c1f1;
  ::S1289C10_nt s1598c1f2;
  ::S1292C12 s1598c1f3;
  ::S1289C10_nt s1598c1f4;
  unsigned int s1598c1f5:1;
  unsigned int s1598c1f6:1;
  unsigned int s1598c1f7:1;
  ::S1292C12 s1598c1f8;
  virtual  ~S1598C1(); // _ZN7S1598C1D1Ev
  virtual void  v1(); // _ZN7S1598C12v1Ev
  virtual void  v2(); // _ZN7S1598C12v2Ev
  virtual void  v3(); // _ZN7S1598C12v3Ev
  virtual void  v4(); // _ZN7S1598C12v4Ev
  virtual void  v5(); // _ZN7S1598C12v5Ev
  virtual void  v6(); // _ZN7S1598C12v6Ev
  virtual void  v7(); // _ZN7S1598C12v7Ev
  virtual void  v8(); // _ZN7S1598C12v8Ev
  S1598C1(); // tgen
};
//SIG(1 S1598C1) C1{ BC2{ BC3{ BC4{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC6{ m}} vd v93 v94 v95 v96 FC7{ BC8{ BC9{ m Fp Fi[2]}}}} vd v1 v2 v3 v4 v5 v6 v7 v8 FC10{ BC11{ m Fc[4] FC12{ BC13{ BC9}} Fi[2]} Fp} FC14{ BC11 Fp} FC14 FC10 FC14 Fi:1 Fi:1 Fi:1 FC10}


 S1598C1 ::~S1598C1(){ note_dtor("S1598C1", this);}
void  S1598C1 ::v1(){vfunc_called(this, "_ZN7S1598C12v1Ev");}
void  S1598C1 ::v2(){vfunc_called(this, "_ZN7S1598C12v2Ev");}
void  S1598C1 ::v3(){vfunc_called(this, "_ZN7S1598C12v3Ev");}
void  S1598C1 ::v4(){vfunc_called(this, "_ZN7S1598C12v4Ev");}
void  S1598C1 ::v5(){vfunc_called(this, "_ZN7S1598C12v5Ev");}
void  S1598C1 ::v6(){vfunc_called(this, "_ZN7S1598C12v6Ev");}
void  S1598C1 ::v7(){vfunc_called(this, "_ZN7S1598C12v7Ev");}
void  S1598C1 ::v8(){vfunc_called(this, "_ZN7S1598C12v8Ev");}
S1598C1 ::S1598C1(){ note_ctor("S1598C1", this);} // tgen

static void Test_S1598C1()
{
  extern Class_Descriptor cd_S1598C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(47,63)];
    init_test(&cd_S1598C1, buf);
    S1598C1 *dp, &lv = *(dp=new (buf) S1598C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(368,248), "sizeof(S1598C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1598C1)");
    check_base_class_offset(lv, (S1598C4*)(S1598C3*)(S1598C2*), 0, "S1598C1");
    check_base_class_offset(lv, (S1598C3*)(S1598C2*), 0, "S1598C1");
    check_base_class_offset(lv, (S1598C2*), 0, "S1598C1");
    check_field_offset(lv, s1598c1f0, ABISELECT(120,76), "S1598C1.s1598c1f0");
    check_field_offset(lv, s1598c1f1, ABISELECT(160,104), "S1598C1.s1598c1f1");
    check_field_offset(lv, s1598c1f2, ABISELECT(200,132), "S1598C1.s1598c1f2");
    check_field_offset(lv, s1598c1f3, ABISELECT(240,160), "S1598C1.s1598c1f3");
    check_field_offset(lv, s1598c1f4, ABISELECT(280,188), "S1598C1.s1598c1f4");
    set_bf_and_test(lv, s1598c1f5, ABISELECT(320,216), 0, 1, 1, "S1598C1");
    set_bf_and_test(lv, s1598c1f6, ABISELECT(320,216), 1, 1, 1, "S1598C1");
    set_bf_and_test(lv, s1598c1f7, ABISELECT(320,216), 2, 1, 1, "S1598C1");
    check_field_offset(lv, s1598c1f8, ABISELECT(328,220), "S1598C1.s1598c1f8");
    test_class_info(&lv, &cd_S1598C1);
    dp->~S1598C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1598C1(Test_S1598C1, "S1598C1", ABISELECT(368,248));

#else // __cplusplus

extern void _ZN7S1598C1C1Ev();
extern void _ZN7S1598C1D1Ev();
Name_Map name_map_S1598C1[] = {
  NSPAIR(_ZN7S1598C1C1Ev),
  NSPAIR(_ZN7S1598C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1598C4;
extern VTBL_ENTRY _ZTI7S1598C