// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S3352C4_nt  {
  int s3352c4f0[2];
  void  mf3352c4(); // _ZN10S3352C4_nt8mf3352c4Ev
};
//SIG(-1 S3352C4_nt) C1{ m Fi[2]}


void  S3352C4_nt ::mf3352c4(){}

//skip512 S3352C4_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3352C3_nt  {
  int s3352c3f0;
  __tsi64 s3352c3f1;
  void *s3352c3f2[4];
  int s3352c3f3[2];
  void *s3352c3f4;
  ::S3352C4_nt s3352c3f5;
  void *s3352c3f6[2];
  virtual  ~S3352C3_nt(); // _ZN10S3352C3_ntD1Ev
  virtual void  v6(); // _ZN10S3352C3_nt2v6Ev
  virtual void  v7(); // _ZN10S3352C3_nt2v7Ev
  virtual void  v8(); // _ZN10S3352C3_nt2v8Ev
  virtual void  v9(); // _ZN10S3352C3_nt2v9Ev
  virtual void  v10(); // _ZN10S3352C3_nt3v10Ev
  virtual void  v11(); // _ZN10S3352C3_nt3v11Ev
  virtual void  v12(); // _ZN10S3352C3_nt3v12Ev
  virtual void  v13(); // _ZN10S3352C3_nt3v13Ev
  virtual void  v14(); // _ZN10S3352C3_nt3v14Ev
  virtual void  v15(); // _ZN10S3352C3_nt3v15Ev
  virtual void  v16(); // _ZN10S3352C3_nt3v16Ev
  virtual void  v17(); // _ZN10S3352C3_nt3v17Ev
  virtual void  v18(); // _ZN10S3352C3_nt3v18Ev
  virtual void  v19(); // _ZN10S3352C3_nt3v19Ev
  virtual void  v20(); // _ZN10S3352C3_nt3v20Ev
  virtual void  v21(); // _ZN10S3352C3_nt3v21Ev
  virtual void  v22(); // _ZN10S3352C3_nt3v22Ev
  virtual void  v23(); // _ZN10S3352C3_nt3v23Ev
  virtual void  v24(); // _ZN10S3352C3_nt3v24Ev
  virtual void  v25(); // _ZN10S3352C3_nt3v25Ev
  virtual void  v26(); // _ZN10S3352C3_nt3v26Ev
  virtual void  v27(); // _ZN10S3352C3_nt3v27Ev
  virtual void  v28(); // _ZN10S3352C3_nt3v28Ev
  virtual void  v29(); // _ZN10S3352C3_nt3v29Ev
  virtual void  v30(); // _ZN10S3352C3_nt3v30Ev
  virtual void  v31(); // _ZN10S3352C3_nt3v31Ev
  virtual void  v32(); // _ZN10S3352C3_nt3v32Ev
  virtual void  v33(); // _ZN10S3352C3_nt3v33Ev
  virtual void  v34(); // _ZN10S3352C3_nt3v34Ev
  virtual void  v35(); // _ZN10S3352C3_nt3v35Ev
  virtual void  v36(); // _ZN10S3352C3_nt3v36Ev
  virtual void  v37(); // _ZN10S3352C3_nt3v37Ev
  virtual void  v38(); // _ZN10S3352C3_nt3v38Ev
  virtual void  v39(); // _ZN10S3352C3_nt3v39Ev
  virtual void  v40(); // _ZN10S3352C3_nt3v40Ev
  virtual void  v41(); // _ZN10S3352C3_nt3v41Ev
  virtual void  v42(); // _ZN10S3352C3_nt3v42Ev
  virtual void  v43(); // _ZN10S3352C3_nt3v43Ev
  virtual void  v44(); // _ZN10S3352C3_nt3v44Ev
  virtual void  v45(); // _ZN10S3352C3_nt3v45Ev
  virtual void  v46(); // _ZN10S3352C3_nt3v46Ev
  virtual void  v47(); // _ZN10S3352C3_nt3v47Ev
  virtual void  v48(); // _ZN10S3352C3_nt3v48Ev
  virtual void  v49(); // _ZN10S3352C3_nt3v49Ev
  virtual void  v50(); // _ZN10S3352C3_nt3v50Ev
  virtual void  v51(); // _ZN10S3352C3_nt3v51Ev
  virtual void  v52(); // _ZN10S3352C3_nt3v52Ev
  virtual void  v53(); // _ZN10S3352C3_nt3v53Ev
  virtual void  v54(); // _ZN10S3352C3_nt3v54Ev
  virtual void  v55(); // _ZN10S3352C3_nt3v55Ev
  virtual void  v56(); // _ZN10S3352C3_nt3v56Ev
  virtual void  v57(); // _ZN10S3352C3_nt3v57Ev
  virtual void  v58(); // _ZN10S3352C3_nt3v58Ev
  virtual void  v59(); // _ZN10S3352C3_nt3v59Ev
  virtual void  v60(); // _ZN10S3352C3_nt3v60Ev
  virtual void  v61(); // _ZN10S3352C3_nt3v61Ev
  virtual void  v62(); // _ZN10S3352C3_nt3v62Ev
  virtual void  v63(); // _ZN10S3352C3_nt3v63Ev
  virtual void  v64(); // _ZN10S3352C3_nt3v64Ev
  virtual void  v65(); // _ZN10S3352C3_nt3v65Ev
  virtual void  v66(); // _ZN10S3352C3_nt3v66Ev
  virtual void  v67(); // _ZN10S3352C3_nt3v67Ev
  virtual void  v68(); // _ZN10S3352C3_nt3v68Ev
  virtual void  v69(); // _ZN10S3352C3_nt3v69Ev
  S3352C3_nt(); // tgen
};
//SIG(-1 S3352C3_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S3352C3_nt ::~S3352C3_nt(){ note_dtor("S3352C3_nt", this);}
void  S3352C3_nt ::v6(){vfunc_called(this, "_ZN10S3352C3_nt2v6Ev");}
void  S3352C3_nt ::v7(){vfunc_called(this, "_ZN10S3352C3_nt2v7Ev");}
void  S3352C3_nt ::v8(){vfunc_called(this, "_ZN10S3352C3_nt2v8Ev");}
void  S3352C3_nt ::v9(){vfunc_called(this, "_ZN10S3352C3_nt2v9Ev");}
void  S3352C3_nt ::v10(){vfunc_called(this, "_ZN10S3352C3_nt3v10Ev");}
void  S3352C3_nt ::v11(){vfunc_called(this, "_ZN10S3352C3_nt3v11Ev");}
void  S3352C3_nt ::v12(){vfunc_called(this, "_ZN10S3352C3_nt3v12Ev");}
void  S3352C3_nt ::v13(){vfunc_called(this, "_ZN10S3352C3_nt3v13Ev");}
void  S3352C3_nt ::v14(){vfunc_called(this, "_ZN10S3352C3_nt3v14Ev");}
void  S3352C3_nt ::v15(){vfunc_called(this, "_ZN10S3352C3_nt3v15Ev");}
void  S3352C3_nt ::v16(){vfunc_called(this, "_ZN10S3352C3_nt3v16Ev");}
void  S3352C3_nt ::v17(){vfunc_called(this, "_ZN10S3352C3_nt3v17Ev");}
void  S3352C3_nt ::v18(){vfunc_called(this, "_ZN10S3352C3_nt3v18Ev");}
void  S3352C3_nt ::v19(){vfunc_called(this, "_ZN10S3352C3_nt3v19Ev");}
void  S3352C3_nt ::v20(){vfunc_called(this, "_ZN10S3352C3_nt3v20Ev");}
void  S3352C3_nt ::v21(){vfunc_called(this, "_ZN10S3352C3_nt3v21Ev");}
void  S3352C3_nt ::v22(){vfunc_called(this, "_ZN10S3352C3_nt3v22Ev");}
void  S3352C3_nt ::v23(){vfunc_called(this, "_ZN10S3352C3_nt3v23Ev");}
void  S3352C3_nt ::v24(){vfunc_called(this, "_ZN10S3352C3_nt3v24Ev");}
void  S3352C3_nt ::v25(){vfunc_called(this, "_ZN10S3352C3_nt3v25Ev");}
void  S3352C3_nt ::v26(){vfunc_called(this, "_ZN10S3352C3_nt3v26Ev");}
void  S3352C3_nt ::v27(){vfunc_called(this, "_ZN10S3352C3_nt3v27Ev");}
void  S3352C3_nt ::v28(){vfunc_called(this, "_ZN10S3352C3_nt3v28Ev");}
void  S3352C3_nt ::v29(){vfunc_called(this, "_ZN10S3352C3_nt3v29Ev");}
void  S3352C3_nt ::v30(){vfunc_called(this, "_ZN10S3352C3_nt3v30Ev");}
void  S3352C3_nt ::v31(){vfunc_called(this, "_ZN10S3352C3_nt3v31Ev");}
void  S3352C3_nt ::v32(){vfunc_called(this, "_ZN10S3352C3_nt3v32Ev");}
void  S3352C3_nt ::v33(){vfunc_called(this, "_ZN10S3352C3_nt3v33Ev");}
void  S3352C3_nt ::v34(){vfunc_called(this, "_ZN10S3352C3_nt3v34Ev");}
void  S3352C3_nt ::v35(){vfunc_called(this, "_ZN10S3352C3_nt3v35Ev");}
void  S3352C3_nt ::v36(){vfunc_called(this, "_ZN10S3352C3_nt3v36Ev");}
void  S3352C3_nt ::v37(){vfunc_called(this, "_ZN10S3352C3_nt3v37Ev");}
void  S3352C3_nt ::v38(){vfunc_called(this, "_ZN10S3352C3_nt3v38Ev");}
void  S3352C3_nt ::v39(){vfunc_called(this, "_ZN10S3352C3_nt3v39Ev");}
void  S3352C3_nt ::v40(){vfunc_called(this, "_ZN10S3352C3_nt3v40Ev");}
void  S3352C3_nt ::v41(){vfunc_called(this, "_ZN10S3352C3_nt3v41Ev");}
void  S3352C3_nt ::v42(){vfunc_called(this, "_ZN10S3352C3_nt3v42Ev");}
void  S3352C3_nt ::v43(){vfunc_called(this, "_ZN10S3352C3_nt3v43Ev");}
void  S3352C3_nt ::v44(){vfunc_called(this, "_ZN10S3352C3_nt3v44Ev");}
void  S3352C3_nt ::v45(){vfunc_called(this, "_ZN10S3352C3_nt3v45Ev");}
void  S3352C3_nt ::v46(){vfunc_called(this, "_ZN10S3352C3_nt3v46Ev");}
void  S3352C3_nt ::v47(){vfunc_called(this, "_ZN10S3352C3_nt3v47Ev");}
void  S3352C3_nt ::v48(){vfunc_called(this, "_ZN10S3352C3_nt3v48Ev");}
void  S3352C3_nt ::v49(){vfunc_called(this, "_ZN10S3352C3_nt3v49Ev");}
void  S3352C3_nt ::v50(){vfunc_called(this, "_ZN10S3352C3_nt3v50Ev");}
void  S3352C3_nt ::v51(){vfunc_called(this, "_ZN10S3352C3_nt3v51Ev");}
void  S3352C3_nt ::v52(){vfunc_called(this, "_ZN10S3352C3_nt3v52Ev");}
void  S3352C3_nt ::v53(){vfunc_called(this, "_ZN10S3352C3_nt3v53Ev");}
void  S3352C3_nt ::v54(){vfunc_called(this, "_ZN10S3352C3_nt3v54Ev");}
void  S3352C3_nt ::v55(){vfunc_called(this, "_ZN10S3352C3_nt3v55Ev");}
void  S3352C3_nt ::v56(){vfunc_called(this, "_ZN10S3352C3_nt3v56Ev");}
void  S3352C3_nt ::v57(){vfunc_called(this, "_ZN10S3352C3_nt3v57Ev");}
void  S3352C3_nt ::v58(){vfunc_called(this, "_ZN10S3352C3_nt3v58Ev");}
void  S3352C3_nt ::v59(){vfunc_called(this, "_ZN10S3352C3_nt3v59Ev");}
void  S3352C3_nt ::v60(){vfunc_called(this, "_ZN10S3352C3_nt3v60Ev");}
void  S3352C3_nt ::v61(){vfunc_called(this, "_ZN10S3352C3_nt3v61Ev");}
void  S3352C3_nt ::v62(){vfunc_called(this, "_ZN10S3352C3_nt3v62Ev");}
void  S3352C3_nt ::v63(){vfunc_called(this, "_ZN10S3352C3_nt3v63Ev");}
void  S3352C3_nt ::v64(){vfunc_called(this, "_ZN10S3352C3_nt3v64Ev");}
void  S3352C3_nt ::v65(){vfunc_called(this, "_ZN10S3352C3_nt3v65Ev");}
void  S3352C3_nt ::v66(){vfunc_called(this, "_ZN10S3352C3_nt3v66Ev");}
void  S3352C3_nt ::v67(){vfunc_called(this, "_ZN10S3352C3_nt3v67Ev");}
void  S3352C3_nt ::v68(){vfunc_called(this, "_ZN10S3352C3_nt3v68Ev");}
void  S3352C3_nt ::v69(){vfunc_called(this, "_ZN10S3352C3_nt3v69Ev");}
S3352C3_nt ::S3352C3_nt(){ note_ctor("S3352C3_nt", this);} // tgen

//skip512 S3352C3_nt

#else // __cplusplus

extern void _ZN10S3352C3_ntC1Ev();
extern void _ZN10S3352C3_ntD1Ev();
Name_Map name_map_S3352C3_nt[] = {
  NSPAIR(_ZN10S3352C3_ntC1Ev),
  NSPAIR(_ZN10S3352C3_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S3352C3_nt[];
extern void _ZN10S3352C3_ntD1Ev();
extern void _ZN10S3352C3_ntD0Ev();
extern void _ZN10S3352C3_nt2v6Ev();
extern void _ZN10S3352C3_nt2v7Ev();
extern void _ZN10S3352C3_nt2v8Ev();
extern void _ZN10S3352C3_nt2v9Ev();
extern void _ZN10S3352C3_nt3v10Ev();
extern void _ZN10S3352C3_nt3v11Ev();
extern void _ZN10S3352C3_nt3v12Ev();
extern void _ZN10S3352C3_nt3v13Ev();
extern void _ZN10S3352C3_nt3v14Ev();
extern void _ZN10S3352C3_nt3v15Ev();
extern void _ZN10S3352C3_nt3v16Ev();
extern void _ZN10S3352C3_nt3v17Ev();
extern void _ZN10S3352C3_nt3v18Ev();
extern void _ZN10S3352C3_nt3v19Ev();
extern void _ZN10S3352C3_nt3v20Ev();
extern void _ZN10S3352C3_nt3v21Ev();
extern void _ZN10S3352C3_nt3v22Ev();
extern void _ZN10S3352C3_nt3v23Ev();
extern void _ZN10S3352C3_nt3v24Ev();
extern void _ZN10S3352C3_nt3v25Ev();
extern void _ZN10S3352C3_nt3v26Ev();
extern void _ZN10S3352C3_nt3v27Ev();
extern void _ZN10S3352C3_nt3v28Ev();
extern void _ZN10S3352C3_nt3v29Ev();
extern void _ZN10S3352C3_nt3v30Ev();
extern void _ZN10S3352C3_nt3v31Ev();
extern void _ZN10S3352C3_nt3v32Ev();
extern void _ZN10S3352C3_nt3v33Ev();
extern void _ZN10S3352C3_nt3v34Ev();
extern void _ZN10S3352C3_nt3v35Ev();
extern void _ZN10S3352C3_nt3v36Ev();
extern void _ZN10S3352C3_nt3v37Ev();
extern void _ZN10S3352C3_nt3v38Ev();
extern void _ZN10S3352C3_nt3v39Ev();
extern void _ZN10S3352C3_nt3v40Ev();
extern void _ZN10S3352C3_nt3v41Ev();
extern void _ZN10S3352C3_nt3v42Ev();
extern void _ZN10S3352C3_nt3v43Ev();
extern void _ZN10S3352C3_nt3v44Ev();
extern void _ZN10S3352C3_nt3v45Ev();
extern void _ZN10S3352C3_nt3v46Ev();
extern void _ZN10S3352C3_nt3v47Ev();
extern void _ZN10S3352C3_nt3v48Ev();
extern void _ZN10S3352C3_nt3v49Ev();
extern void _ZN10S3352C3_nt3v50Ev();
extern void _ZN10S3352C3_nt3v51Ev();
extern void _ZN10S3352C3_nt3v52Ev();
extern void _ZN10S3352C3_nt3v53Ev();
extern void _ZN10S3352C3_nt3v54Ev();
extern void _ZN10S3352C3_nt3v55Ev();
extern void _ZN10S3352C3_nt3v56Ev();
extern void _ZN10S3352C3_nt3v57Ev();
extern void _ZN10S3352C3_nt3v58Ev();
extern void _ZN10S3352C3_nt3v59Ev();
extern void _ZN10S3352C3_nt3v60Ev();
extern void _ZN10S3352C3_nt3v61Ev();
extern void _ZN10S3352C3_nt3v62Ev();
extern void _ZN10S3352C3_nt3v63Ev();
extern void _ZN10S3352C3_nt3v64Ev();
extern void _ZN10S3352C3_nt3v65Ev();
extern void _ZN10S3352C3_nt3v66Ev();
extern void _ZN10S3352C3_nt3v67Ev();
extern void _ZN10S3352C3_nt3v68Ev();
extern void _ZN10S3352C3_nt3v69Ev();
static  VTBL_ENTRY vtc_S3352C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S3352C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S3352C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v69Ev,
};
extern VTBL_ENTRY _ZTI10S3352C3_nt[];
VTBL_ENTRY *P__ZTI10S3352C3_nt = _ZTI10S3352C3_nt; 
extern  VTBL_ENTRY _ZTV10S3352C3_nt[];
Class_Descriptor cd_S3352C3_nt = {  "S3352C3_nt", // class name
  0,0,//no base classes
  &(vtc_S3352C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI10S3352C3_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S3352C3_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3352C7_nt  {
  void *s3352c7f0;
  int s3352c7f1[2];
  void  mf3352c7(); // _ZN10S3352C7_nt8mf3352c7Ev
};
//SIG(-1 S3352C7_nt) C1{ m Fp Fi[2]}


void  S3352C7_nt ::mf3352c7(){}

//skip512 S3352C7_nt

#else // __cplusplus

Class_Descriptor cd_S3352C7_nt = {  "S3352C7_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3352C6_nt  : S3352C7_nt {
};
//SIG(-1 S3352C6_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S3352C6_nt

#else // __cplusplus

extern Class_Descriptor cd_S3352C7_nt;
static Base_Class bases_S3352C6_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3352C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3352C6_nt = {  "S3352C6_nt", // class name
  bases_S3352C6_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3352C5_nt  : S3352C6_nt {
};
//SIG(-1 S3352C5_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S3352C5_nt

#else // __cplusplus

extern Class_Descriptor cd_S3352C7_nt;
extern Class_Descriptor cd_S3352C6_nt;
static Base_Class bases_S3352C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3352C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3352C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3352C8_nt  {
  int s3352c8f0;
  void  mf3352c8(); // _ZN10S3352C8_nt8mf3352c8Ev
};
//SIG(-1 S3352C8_nt) C1{ m Fi}


void  S3352C8_nt ::mf3352c8(){}

//skip512 S3352C8_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S3352C8_nt[];
VTBL_ENTRY *P__ZTI10S3352C8_nt = _ZTI10S3352C8_nt; 
Class_Descriptor cd_S3352C8_nt = {  "S3352C8_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI10S3352C8_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3352C12  : S3352C7_nt {
};
//SIG(-1 S3352C12) C1{ BC2{ m Fp Fi[2]}}



static void Test_S3352C12()
{
  extern Class_Descriptor cd_S3352C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3352C12, buf);
    S3352C12 &lv = *(new (buf) S3352C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3352C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3352C12)");
    check_base_class_offset(lv, (S3352C7_nt*), 0, "S3352C12");
    test_class_info(&lv, &cd_S3352C12);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3352C12(Test_S3352C12, "S3352C12", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3352C7_nt;
static Base_Class bases_S3352C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3352C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3352C12 = {  "S3352C12", // class name
  bases_S3352C12, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3352C11  : S3352C12 {
};
//SIG(-1 S3352C11) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S3352C11()
{
  extern Class_Descriptor cd_S3352C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3352C11, buf);
    S3352C11 &lv = *(new (buf) S3352C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3352C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3352C11)");
    check_base_class_offset(lv, (S3352C7_nt*)(S3352C12*), 0, "S3352C11");
    check_base_class_offset(lv, (S3352C12*), 0, "S3352C11");
    test_class_info(&lv, &cd_S3352C11);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3352C11(Test_S3352C11, "S3352C11", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3352C7_nt;
extern Class_Descriptor cd_S3352C12;
static Base_Class bases_S3352C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3352C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3352C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3352C11 = {  "S3352C11", // class name
  bases_S3352C11, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3352C13_nt  {
  int s3352c13f0[3];
  void  mf3352c13(); // _ZN11S3352C13_nt9mf3352c13Ev
};
//SIG(-1 S3352C13_nt) C1{ m Fi[3]}


void  S3352C13_nt ::mf3352c13(){}

//skip512 S3352C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3352C18  : S3352C7_nt {
};
//SIG(-1 S3352C18) C1{ BC2{ m Fp Fi[2]}}



static void Test_S3352C18()
{
  extern Class_Descriptor cd_S3352C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3352C18, buf);
    S3352C18 &lv = *(new (buf) S3352C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3352C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3352C18)");
    check_base_class_offset(lv, (S3352C7_nt*), 0, "S3352C18");
    test_class_info(&lv, &cd_S3352C18);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3352C18(Test_S3352C18, "S3352C18", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3352C7_nt;
static Base_Class bases_S3352C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3352C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3352C18 = {  "S3352C18", // class name
  bases_S3352C18, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3352C17  : S3352C18 {
};
//SIG(-1 S3352C17) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S3352C17()
{
  extern Class_Descriptor cd_S3352C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3352C17, buf);
    S3352C17 &lv = *(new (buf) S3352C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3352C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3352C17)");
    check_base_class_offset(lv, (S3352C7_nt*)(S3352C18*), 0, "S3352C17");
    check_base_class_offset(lv, (S3352C18*), 0, "S3352C17");
    test_class_info(&lv, &cd_S3352C17);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3352C17(Test_S3352C17, "S3352C17", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3352C7_nt;
extern Class_Descriptor cd_S3352C18;
static Base_Class bases_S3352C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3352C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3352C18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3352C17 = {  "S3352C17", // class name
  bases_S3352C17, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3352C2_nt  : S3352C3_nt {
  ::S3352C5_nt s3352c2f0;
  ::S3352C5_nt s3352c2f1;
  ::S3352C8_nt s3352c2f2;
  int s3352c2f3;
  char s3352c2f4[4];
  void *s3352c2f5[2];
  ::S3352C5_nt s3352c2f6;
  unsigned int s3352c2f7:1;
  unsigned int s3352c2f8:1;
  unsigned int s3352c2f9:1;
  unsigned int s3352c2f10:1;
  unsigned int s3352c2f11:1;
  unsigned int s3352c2f12:1;
  unsigned int s3352c2f13:1;
  unsigned int s3352c2f14:1;
  unsigned int s3352c2f15:1;
  unsigned int s3352c2f16:1;
  unsigned int s3352c2f17:1;
  unsigned int s3352c2f18:1;
  unsigned int s3352c2f19:1;
  unsigned int s3352c2f20:1;
  unsigned int s3352c2f21:1;
  unsigned int s3352c2f22:1;
  unsigned int s3352c2f23:1;
  unsigned int s3352c2f24:1;
  unsigned int s3352c2f25:1;
  unsigned int s3352c2f26:1;
  unsigned int s3352c2f27:1;
  unsigned int s3352c2f28:1;
  unsigned int s3352c2f29:1;
  unsigned int s3352c2f30:1;
  unsigned int s3352c2f31:1;
  unsigned int s3352c2f32:1;
  unsigned int s3352c2f33:1;
  unsigned int s3352c2f34:1;
  unsigned int s3352c2f35:1;
  unsigned int s3352c2f36:1;
  unsigned int s3352c2f37:1;
  unsigned int s3352c2f38:1;
  unsigned int s3352c2f39:1;
  unsigned int s3352c2f40:1;
  unsigned int s3352c2f41:1;
  unsigned int s3352c2f42:1;
  unsigned int s3352c2f43:1;
  unsigned int s3352c2f44:1;
  unsigned int s3352c2f45:1;
  unsigned int s3352c2f46:1;
  unsigned int s3352c2f47:1;
  unsigned int s3352c2f48:1;
  unsigned int s3352c2f49:1;
  unsigned int s3352c2f50:1;
  unsigned int s3352c2f51:1;
  unsigned int s3352c2f52:1;
  unsigned int s3352c2f53:1;
  unsigned int s3352c2f54:1;
  unsigned int s3352c2f55:1;
  unsigned int s3352c2f56:1;
  unsigned int s3352c2f57:1;
  unsigned int s3352c2f58:1;
  unsigned int s3352c2f59:1;
  unsigned int s3352c2f60:1;
  unsigned int s3352c2f61:1;
  unsigned int s3352c2f62:1;
  unsigned int s3352c2f63:1;
  unsigned int s3352c2f64:1;
  unsigned int s3352c2f65:1;
  unsigned int s3352c2f66:1;
  unsigned int s3352c2f67:1;
  unsigned int s3352c2f68:1;
  unsigned int s3352c2f69:1;
  unsigned int s3352c2f70:1;
  unsigned int s3352c2f71:1;
  unsigned int s3352c2f72:1;
  unsigned int s3352c2f73:1;
  unsigned int s3352c2f74:1;
  unsigned int s3352c2f75:1;
  unsigned int s3352c2f76:1;
  unsigned int s3352c2f77:1;
  unsigned int s3352c2f78:1;
  unsigned int s3352c2f79:1;
  unsigned int s3352c2f80:1;
  unsigned int s3352c2f81:1;
  unsigned int s3352c2f82:1;
  unsigned int s3352c2f83:1;
  int s3352c2f84[5];
  void *s3352c2f85[2];
  int s3352c2f86[3];
  ::S3352C4_nt s3352c2f87;
  ::S3352C4_nt s3352c2f88;
  ::S3352C4_nt s3352c2f89;
  ::S3352C11 s3352c2f90;
  ::S3352C11 s3352c2f91;
  int s3352c2f92;
  void *s3352c2f93[2];
  ::S3352C13_nt s3352c2f94;
  ::S3352C13_nt s3352c2f95;
  ::S3352C13_nt s3352c2f96;
  ::S3352C13_nt s3352c2f97;
  void *s3352c2f98;
  ::S3352C4_nt s3352c2f99;
  ::S3352C11 s3352c2f100;
  ::S3352C13_nt s3352c2f101;
  ::S3352C13_nt s3352c2f102;
  int s3352c2f103;
  ::S3352C13_nt s3352c2f104;
  ::S3352C13_nt s3352c2f105;
  void *s3352c2f106;
  int s3352c2f107;
  char s3352c2f108;
  ::S3352C13_nt s3352c2f109;
  ::S3352C13_nt s3352c2f110;
  void *s3352c2f111;
  int s3352c2f112;
  void *s3352c2f113;
  ::S3352C11 s3352c2f114;
  ::S3352C17 s3352c2f115;
  ::S3352C17 s3352c2f116;
  virtual  ~S3352C2_nt(); // _ZN10S3352C2_ntD1Ev
  virtual void  v70(); // _ZN10S3352C2_nt3v70Ev
  virtual void  v71(); // _ZN10S3352C2_nt3v71Ev
  virtual void  v72(); // _ZN10S3352C2_nt3v72Ev
  virtual void  v73(); // _ZN10S3352C2_nt3v73Ev
  virtual void  v74(); // _ZN10S3352C2_nt3v74Ev
  virtual void  v75(); // _ZN10S3352C2_nt3v75Ev
  virtual void  v76(); // _ZN10S3352C2_nt3v76Ev
  virtual void  v77(); // _ZN10S3352C2_nt3v77Ev
  virtual void  v78(); // _ZN10S3352C2_nt3v78Ev
  virtual void  v79(); // _ZN10S3352C2_nt3v79Ev
  virtual void  v80(); // _ZN10S3352C2_nt3v80Ev
  virtual void  v81(); // _ZN10S3352C2_nt3v81Ev
  virtual void  v82(); // _ZN10S3352C2_nt3v82Ev
  virtual void  v83(); // _ZN10S3352C2_nt3v83Ev
  virtual void  v84(); // _ZN10S3352C2_nt3v84Ev
  virtual void  v85(); // _ZN10S3352C2_nt3v85Ev
  virtual void  v86(); // _ZN10S3352C2_nt3v86Ev
  virtual void  v87(); // _ZN10S3352C2_nt3v87Ev
  virtual void  v88(); // _ZN10S3352C2_nt3v88Ev
  virtual void  v89(); // _ZN10S3352C2_nt3v89Ev
  virtual void  v90(); // _ZN10S3352C2_nt3v90Ev
  virtual void  v91(); // _ZN10S3352C2_nt3v91Ev
  virtual void  v92(); // _ZN10S3352C2_nt3v92Ev
  virtual void  v93(); // _ZN10S3352C2_nt3v93Ev
  virtual void  v94(); // _ZN10S3352C2_nt3v94Ev
  virtual void  v95(); // _ZN10S3352C2_nt3v95Ev
  virtual void  v96(); // _ZN10S3352C2_nt3v96Ev
  virtual void  v97(); // _ZN10S3352C2_nt3v97Ev
  virtual void  v98(); // _ZN10S3352C2_nt3v98Ev
  virtual void  v99(); // _ZN10S3352C2_nt3v99Ev
  virtual void  v100(); // _ZN10S3352C2_nt4v100Ev
  virtual void  v101(); // _ZN10S3352C2_nt4v101Ev
  virtual void  v102(); // _ZN10S3352C2_nt4v102Ev
  virtual void  v103(); // _ZN10S3352C2_nt4v103Ev
  virtual void  v104(); // _ZN10S3352C2_nt4v104Ev
  virtual void  v105(); // _ZN10S3352C2_nt4v105Ev
  virtual void  v106(); // _ZN10S3352C2_nt4v106Ev
  virtual void  v107(); // _ZN10S3352C2_nt4v107Ev
  virtual void  v108(); // _ZN10S3352C2_nt4v108Ev
  virtual void  v109(); // _ZN10S3352C2_nt4v109Ev
  virtual void  v110(); // _ZN10S3352C2_nt4v110Ev
  virtual void  v111(); // _ZN10S3352C2_nt4v111Ev
  virtual void  v112(); // _ZN10S3352C2_nt4v112Ev
  virtual void  v113(); // _ZN10S3352C2_nt4v113Ev
  virtual void  v114(); // _ZN10S3352C2_nt4v114Ev
  virtual void  v115(); // _ZN10S3352C2_nt4v115Ev
  virtual void  v116(); // _ZN10S3352C2_nt4v116Ev
  virtual void  v117(); // _ZN10S3352C2_nt4v117Ev
  virtual void  v118(); // _ZN10S3352C2_nt4v118Ev
  virtual void  v119(); // _ZN10S3352C2_nt4v119Ev
  virtual void  v120(); // _ZN10S3352C2_nt4v120Ev
  virtual void  v121(); // _ZN10S3352C2_nt4v121Ev
  virtual void  v122(); // _ZN10S3352C2_nt4v122Ev
  virtual void  v123(); // _ZN10S3352C2_nt4v123Ev
  virtual void  v124(); // _ZN10S3352C2_nt4v124Ev
  virtual void  v125(); // _ZN10S3352C2_nt4v125Ev
  virtual void  v126(); // _ZN10S3352C2_nt4v126Ev
  virtual void  v127(); // _ZN10S3352C2_nt4v127Ev
  virtual void  v128(); // _ZN10S3352C2_nt4v128Ev
  virtual void  v129(); // _ZN10S3352C2_nt4v129Ev
  virtual void  v130(); // _ZN10S3352C2_nt4v130Ev
  virtual void  v131(); // _ZN10S3352C2_nt4v131Ev
  virtual void  v132(); // _ZN10S3352C2_nt4v132Ev
  virtual void  v133(); // _ZN10S3352C2_nt4v133Ev
  virtual void  v134(); // _ZN10S3352C2_nt4v134Ev
  virtual void  v135(); // _ZN10S3352C2_nt4v135Ev
  virtual void  v136(); // _ZN10S3352C2_nt4v136Ev
  virtual void  v137(); // _ZN10S3352C2_nt4v137Ev
  virtual void  v138(); // _ZN10S3352C2_nt4v138Ev
  virtual void  v139(); // _ZN10S3352C2_nt4v139Ev
  virtual void  v140(); // _ZN10S3352C2_nt4v140Ev
  virtual void  v141(); // _ZN10S3352C2_nt4v141Ev
  virtual void  v142(); // _ZN10S3352C2_nt4v142Ev
  virtual void  v143(); // _ZN10S3352C2_nt4v143Ev
  virtual void  v144(); // _ZN10S3352C2_nt4v144Ev
  virtual void  v145(); // _ZN10S3352C2_nt4v145Ev
  virtual void  v146(); // _ZN10S3352C2_nt4v146Ev
  virtual void  v147(); // _ZN10S3352C2_nt4v147Ev
  virtual void  v148(); // _ZN10S3352C2_nt4v148Ev
  virtual void  v149(); // _ZN10S3352C2_nt4v149Ev
  virtual void  v150(); // _ZN10S3352C2_nt4v150Ev
  virtual void  v151(); // _ZN10S3352C2_nt4v151Ev
  virtual void  v152(); // _ZN10S3352C2_nt4v152Ev
  virtual void  v153(); // _ZN10S3352C2_nt4v153Ev
  virtual void  v154(); // _ZN10S3352C2_nt4v154Ev
  virtual void  v155(); // _ZN10S3352C2_nt4v155Ev
  virtual void  v156(); // _ZN10S3352C2_nt4v156Ev
  virtual void  v157(); // _ZN10S3352C2_nt4v157Ev
  virtual void  v158(); // _ZN10S3352C2_nt4v158Ev
  virtual void  v159(); // _ZN10S3352C2_nt4v159Ev
  virtual void  v160(); // _ZN10S3352C2_nt4v160Ev
  virtual void  v161(); // _ZN10S3352C2_nt4v161Ev
  virtual void  v162(); // _ZN10S3352C2_nt4v162Ev
  virtual void  v163(); // _ZN10S3352C2_nt4v163Ev
  virtual void  v164(); // _ZN10S3352C2_nt4v164Ev
  virtual void  v165(); // _ZN10S3352C2_nt4v165Ev
  virtual void  v166(); // _ZN10S3352C2_nt4v166Ev
  virtual void  v167(); // _ZN10S3352C2_nt4v167Ev
  virtual void  v168(); // _ZN10S3352C2_nt4v168Ev
  virtual void  v169(); // _ZN10S3352C2_nt4v169Ev
  virtual void  v170(); // _ZN10S3352C2_nt4v170Ev
  virtual void  v171(); // _ZN10S3352C2_nt4v171Ev
  virtual void  v172(); // _ZN10S3352C2_nt4v172Ev
  virtual void  v173(); // _ZN10S3352C2_nt4v173Ev
  virtual void  v174(); // _ZN10S3352C2_nt4v174Ev
  virtual void  v175(); // _ZN10S3352C2_nt4v175Ev
  virtual void  v176(); // _ZN10S3352C2_nt4v176Ev
  virtual void  v177(); // _ZN10S3352C2_nt4v177Ev
  virtual void  v178(); // _ZN10S3352C2_nt4v178Ev
  virtual void  v179(); // _ZN10S3352C2_nt4v179Ev
  virtual void  v180(); // _ZN10S3352C2_nt4v180Ev
  virtual void  v181(); // _ZN10S3352C2_nt4v181Ev
  virtual void  v182(); // _ZN10S3352C2_nt4v182Ev
  virtual void  v183(); // _ZN10S3352C2_nt4v183Ev
  virtual void  v184(); // _ZN10S3352C2_nt4v184Ev
  virtual void  v185(); // _ZN10S3352C2_nt4v185Ev
  virtual void  v186(); // _ZN10S3352C2_nt4v186Ev
  virtual void  v187(); // _ZN10S3352C2_nt4v187Ev
  virtual void  v188(); // _ZN10S3352C2_nt4v188Ev
  virtual void  v189(); // _ZN10S3352C2_nt4v189Ev
  virtual void  v190(); // _ZN10S3352C2_nt4v190Ev
  virtual void  v191(); // _ZN10S3352C2_nt4v191Ev
  virtual void  v192(); // _ZN10S3352C2_nt4v192Ev
  virtual void  v193(); // _ZN10S3352C2_nt4v193Ev
  virtual void  v194(); // _ZN10S3352C2_nt4v194Ev
  virtual void  v195(); // _ZN10S3352C2_nt4v195Ev
  virtual void  v196(); // _ZN10S3352C2_nt4v196Ev
  virtual void  v197(); // _ZN10S3352C2_nt4v197Ev
  virtual void  v198(); // _ZN10S3352C2_nt4v198Ev
  virtual void  v199(); // _ZN10S3352C2_nt4v199Ev
  virtual void  v200(); // _ZN10S3352C2_nt4v200Ev
  virtual void  v201(); // _ZN10S3352C2_nt4v201Ev
  virtual void  v202(); // _ZN10S3352C2_nt4v202Ev
  virtual void  v203(); // _ZN10S3352C2_nt4v203Ev
  virtual void  v204(); // _ZN10S3352C2_nt4v204Ev
  virtual void  v205(); // _ZN10S3352C2_nt4v205Ev
  virtual void  v206(); // _ZN10S3352C2_nt4v206Ev
  virtual void  v207(); // _ZN10S3352C2_nt4v207Ev
  virtual void  v208(); // _ZN10S3352C2_nt4v208Ev
  virtual void  v209(); // _ZN10S3352C2_nt4v209Ev
  virtual void  v210(); // _ZN10S3352C2_nt4v210Ev
  virtual void  v211(); // _ZN10S3352C2_nt4v211Ev
  virtual void  v212(); // _ZN10S3352C2_nt4v212Ev
  S3352C2_nt(); // tgen
};
//SIG(-1 S3352C2_nt) C1{ BC2{ vd v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 FC4{ BC5{ BC6{ m Fp Fi[2]}}} FC4 FC7{ m Fi} Fi Fc[4] Fp[2] FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC3 FC3 FC3 FC8{ BC9{ BC6}} FC8 Fi Fp[2] FC10{ m Fi[3]} FC10 FC10 FC10 Fp FC3 FC8 FC10 FC10 Fi FC10 FC10 Fp Fi Fc FC10 FC10 Fp Fi Fp FC8 FC11{ BC12{ BC6}} FC11}


 S3352C2_nt ::~S3352C2_nt(){ note_dtor("S3352C2_nt", this);}
void  S3352C2_nt ::v70(){vfunc_called(this, "_ZN10S3352C2_nt3v70Ev");}
void  S3352C2_nt ::v71(){vfunc_called(this, "_ZN10S3352C2_nt3v71Ev");}
void  S3352C2_nt ::v72(){vfunc_called(this, "_ZN10S3352C2_nt3v72Ev");}
void  S3352C2_nt ::v73(){vfunc_called(this, "_ZN10S3352C2_nt3v73Ev");}
void  S3352C2_nt ::v74(){vfunc_called(this, "_ZN10S3352C2_nt3v74Ev");}
void  S3352C2_nt ::v75(){vfunc_called(this, "_ZN10S3352C2_nt3v75Ev");}
void  S3352C2_nt ::v76(){vfunc_called(this, "_ZN10S3352C2_nt3v76Ev");}
void  S3352C2_nt ::v77(){vfunc_called(this, "_ZN10S3352C2_nt3v77Ev");}
void  S3352C2_nt ::v78(){vfunc_called(this, "_ZN10S3352C2_nt3v78Ev");}
void  S3352C2_nt ::v79(){vfunc_called(this, "_ZN10S3352C2_nt3v79Ev");}
void  S3352C2_nt ::v80(){vfunc_called(this, "_ZN10S3352C2_nt3v80Ev");}
void  S3352C2_nt ::v81(){vfunc_called(this, "_ZN10S3352C2_nt3v81Ev");}
void  S3352C2_nt ::v82(){vfunc_called(this, "_ZN10S3352C2_nt3v82Ev");}
void  S3352C2_nt ::v83(){vfunc_called(this, "_ZN10S3352C2_nt3v83Ev");}
void  S3352C2_nt ::v84(){vfunc_called(this, "_ZN10S3352C2_nt3v84Ev");}
void  S3352C2_nt ::v85(){vfunc_called(this, "_ZN10S3352C2_nt3v85Ev");}
void  S3352C2_nt ::v86(){vfunc_called(this, "_ZN10S3352C2_nt3v86Ev");}
void  S3352C2_nt ::v87(){vfunc_called(this, "_ZN10S3352C2_nt3v87Ev");}
void  S3352C2_nt ::v88(){vfunc_called(this, "_ZN10S3352C2_nt3v88Ev");}
void  S3352C2_nt ::v89(){vfunc_called(this, "_ZN10S3352C2_nt3v89Ev");}
void  S3352C2_nt ::v90(){vfunc_called(this, "_ZN10S3352C2_nt3v90Ev");}
void  S3352C2_nt ::v91(){vfunc_called(this, "_ZN10S3352C2_nt3v91Ev");}
void  S3352C2_nt ::v92(){vfunc_called(this, "_ZN10S3352C2_nt3v92Ev");}
void  S3352C2_nt ::v93(){vfunc_called(this, "_ZN10S3352C2_nt3v93Ev");}
void  S3352C2_nt ::v94(){vfunc_called(this, "_ZN10S3352C2_nt3v94Ev");}
void  S3352C2_nt ::v95(){vfunc_called(this, "_ZN10S3352C2_nt3v95Ev");}
void  S3352C2_nt ::v96(){vfunc_called(this, "_ZN10S3352C2_nt3v96Ev");}
void  S3352C2_nt ::v97(){vfunc_called(this, "_ZN10S3352C2_nt3v97Ev");}
void  S3352C2_nt ::v98(){vfunc_called(this, "_ZN10S3352C2_nt3v98Ev");}
void  S3352C2_nt ::v99(){vfunc_called(this, "_ZN10S3352C2_nt3v99Ev");}
void  S3352C2_nt ::v100(){vfunc_called(this, "_ZN10S3352C2_nt4v100Ev");}
void  S3352C2_nt ::v101(){vfunc_called(this, "_ZN10S3352C2_nt4v101Ev");}
void  S3352C2_nt ::v102(){vfunc_called(this, "_ZN10S3352C2_nt4v102Ev");}
void  S3352C2_nt ::v103(){vfunc_called(this, "_ZN10S3352C2_nt4v103Ev");}
void  S3352C2_nt ::v104(){vfunc_called(this, "_ZN10S3352C2_nt4v104Ev");}
void  S3352C2_nt ::v105(){vfunc_called(this, "_ZN10S3352C2_nt4v105Ev");}
void  S3352C2_nt ::v106(){vfunc_called(this, "_ZN10S3352C2_nt4v106Ev");}
void  S3352C2_nt ::v107(){vfunc_called(this, "_ZN10S3352C2_nt4v107Ev");}
void  S3352C2_nt ::v108(){vfunc_called(this, "_ZN10S3352C2_nt4v108Ev");}
void  S3352C2_nt ::v109(){vfunc_called(this, "_ZN10S3352C2_nt4v109Ev");}
void  S3352C2_nt ::v110(){vfunc_called(this, "_ZN10S3352C2_nt4v110Ev");}
void  S3352C2_nt ::v111(){vfunc_called(this, "_ZN10S3352C2_nt4v111Ev");}
void  S3352C2_nt ::v112(){vfunc_called(this, "_ZN10S3352C2_nt4v112Ev");}
void  S3352C2_nt ::v113(){vfunc_called(this, "_ZN10S3352C2_nt4v113Ev");}
void  S3352C2_nt ::v114(){vfunc_called(this, "_ZN10S3352C2_nt4v114Ev");}
void  S3352C2_nt ::v115(){vfunc_called(this, "_ZN10S3352C2_nt4v115Ev");}
void  S3352C2_nt ::v116(){vfunc_called(this, "_ZN10S3352C2_nt4v116Ev");}
void  S3352C2_nt ::v117(){vfunc_called(this, "_ZN10S3352C2_nt4v117Ev");}
void  S3352C2_nt ::v118(){vfunc_called(this, "_ZN10S3352C2_nt4v118Ev");}
void  S3352C2_nt ::v119(){vfunc_called(this, "_ZN10S3352C2_nt4v119Ev");}
void  S3352C2_nt ::v120(){vfunc_called(this, "_ZN10S3352C2_nt4v120Ev");}
void  S3352C2_nt ::v121(){vfunc_called(this, "_ZN10S3352C2_nt4v121Ev");}
void  S3352C2_nt ::v122(){vfunc_called(this, "_ZN10S3352C2_nt4v122Ev");}
void  S3352C2_nt ::v123(){vfunc_called(this, "_ZN10S3352C2_nt4v123Ev");}
void  S3352C2_nt ::v124(){vfunc_called(this, "_ZN10S3352C2_nt4v124Ev");}
void  S3352C2_nt ::v125(){vfunc_called(this, "_ZN10S3352C2_nt4v125Ev");}
void  S3352C2_nt ::v126(){vfunc_called(this, "_ZN10S3352C2_nt4v126Ev");}
void  S3352C2_nt ::v127(){vfunc_called(this, "_ZN10S3352C2_nt4v127Ev");}
void  S3352C2_nt ::v128(){vfunc_called(this, "_ZN10S3352C2_nt4v128Ev");}
void  S3352C2_nt ::v129(){vfunc_called(this, "_ZN10S3352C2_nt4v129Ev");}
void  S3352C2_nt ::v130(){vfunc_called(this, "_ZN10S3352C2_nt4v130Ev");}
void  S3352C2_nt ::v131(){vfunc_called(this, "_ZN10S3352C2_nt4v131Ev");}
void  S3352C2_nt ::v132(){vfunc_called(this, "_ZN10S3352C2_nt4v132Ev");}
void  S3352C2_nt ::v133(){vfunc_called(this, "_ZN10S3352C2_nt4v133Ev");}
void  S3352C2_nt ::v134(){vfunc_called(this, "_ZN10S3352C2_nt4v134Ev");}
void  S3352C2_nt ::v135(){vfunc_called(this, "_ZN10S3352C2_nt4v135Ev");}
void  S3352C2_nt ::v136(){vfunc_called(this, "_ZN10S3352C2_nt4v136Ev");}
void  S3352C2_nt ::v137(){vfunc_called(this, "_ZN10S3352C2_nt4v137Ev");}
void  S3352C2_nt ::v138(){vfunc_called(this, "_ZN10S3352C2_nt4v138Ev");}
void  S3352C2_nt ::v139(){vfunc_called(this, "_ZN10S3352C2_nt4v139Ev");}
void  S3352C2_nt ::v140(){vfunc_called(this, "_ZN10S3352C2_nt4v140Ev");}
void  S3352C2_nt ::v141(){vfunc_called(this, "_ZN10S3352C2_nt4v141Ev");}
void  S3352C2_nt ::v142(){vfunc_called(this, "_ZN10S3352C2_nt4v142Ev");}
void  S3352C2_nt ::v143(){vfunc_called(this, "_ZN10S3352C2_nt4v143Ev");}
void  S3352C2_nt ::v144(){vfunc_called(this, "_ZN10S3352C2_nt4v144Ev");}
void  S3352C2_nt ::v145(){vfunc_called(this, "_ZN10S3352C2_nt4v145Ev");}
void  S3352C2_nt ::v146(){vfunc_called(this, "_ZN10S3352C2_nt4v146Ev");}
void  S3352C2_nt ::v147(){vfunc_called(this, "_ZN10S3352C2_nt4v147Ev");}
void  S3352C2_nt ::v148(){vfunc_called(this, "_ZN10S3352C2_nt4v148Ev");}
void  S3352C2_nt ::v149(){vfunc_called(this, "_ZN10S3352C2_nt4v149Ev");}
void  S3352C2_nt ::v150(){vfunc_called(this, "_ZN10S3352C2_nt4v150Ev");}
void  S3352C2_nt ::v151(){vfunc_called(this, "_ZN10S3352C2_nt4v151Ev");}
void  S3352C2_nt ::v152(){vfunc_called(this, "_ZN10S3352C2_nt4v152Ev");}
void  S3352C2_nt ::v153(){vfunc_called(this, "_ZN10S3352C2_nt4v153Ev");}
void  S3352C2_nt ::v154(){vfunc_called(this, "_ZN10S3352C2_nt4v154Ev");}
void  S3352C2_nt ::v155(){vfunc_called(this, "_ZN10S3352C2_nt4v155Ev");}
void  S3352C2_nt ::v156(){vfunc_called(this, "_ZN10S3352C2_nt4v156Ev");}
void  S3352C2_nt ::v157(){vfunc_called(this, "_ZN10S3352C2_nt4v157Ev");}
void  S3352C2_nt ::v158(){vfunc_called(this, "_ZN10S3352C2_nt4v158Ev");}
void  S3352C2_nt ::v159(){vfunc_called(this, "_ZN10S3352C2_nt4v159Ev");}
void  S3352C2_nt ::v160(){vfunc_called(this, "_ZN10S3352C2_nt4v160Ev");}
void  S3352C2_nt ::v161(){vfunc_called(this, "_ZN10S3352C2_nt4v161Ev");}
void  S3352C2_nt ::v162(){vfunc_called(this, "_ZN10S3352C2_nt4v162Ev");}
void  S3352C2_nt ::v163(){vfunc_called(this, "_ZN10S3352C2_nt4v163Ev");}
void  S3352C2_nt ::v164(){vfunc_called(this, "_ZN10S3352C2_nt4v164Ev");}
void  S3352C2_nt ::v165(){vfunc_called(this, "_ZN10S3352C2_nt4v165Ev");}
void  S3352C2_nt ::v166(){vfunc_called(this, "_ZN10S3352C2_nt4v166Ev");}
void  S3352C2_nt ::v167(){vfunc_called(this, "_ZN10S3352C2_nt4v167Ev");}
void  S3352C2_nt ::v168(){vfunc_called(this, "_ZN10S3352C2_nt4v168Ev");}
void  S3352C2_nt ::v169(){vfunc_called(this, "_ZN10S3352C2_nt4v169Ev");}
void  S3352C2_nt ::v170(){vfunc_called(this, "_ZN10S3352C2_nt4v170Ev");}
void  S3352C2_nt ::v171(){vfunc_called(this, "_ZN10S3352C2_nt4v171Ev");}
void  S3352C2_nt ::v172(){vfunc_called(this, "_ZN10S3352C2_nt4v172Ev");}
void  S3352C2_nt ::v173(){vfunc_called(this, "_ZN10S3352C2_nt4v173Ev");}
void  S3352C2_nt ::v174(){vfunc_called(this, "_ZN10S3352C2_nt4v174Ev");}
void  S3352C2_nt ::v175(){vfunc_called(this, "_ZN10S3352C2_nt4v175Ev");}
void  S3352C2_nt ::v176(){vfunc_called(this, "_ZN10S3352C2_nt4v176Ev");}
void  S3352C2_nt ::v177(){vfunc_called(this, "_ZN10S3352C2_nt4v177Ev");}
void  S3352C2_nt ::v178(){vfunc_called(this, "_ZN10S3352C2_nt4v178Ev");}
void  S3352C2_nt ::v179(){vfunc_called(this, "_ZN10S3352C2_nt4v179Ev");}
void  S3352C2_nt ::v180(){vfunc_called(this, "_ZN10S3352C2_nt4v180Ev");}
void  S3352C2_nt ::v181(){vfunc_called(this, "_ZN10S3352C2_nt4v181Ev");}
void  S3352C2_nt ::v182(){vfunc_called(this, "_ZN10S3352C2_nt4v182Ev");}
void  S3352C2_nt ::v183(){vfunc_called(this, "_ZN10S3352C2_nt4v183Ev");}
void  S3352C2_nt ::v184(){vfunc_called(this, "_ZN10S3352C2_nt4v184Ev");}
void  S3352C2_nt ::v185(){vfunc_called(this, "_ZN10S3352C2_nt4v185Ev");}
void  S3352C2_nt ::v186(){vfunc_called(this, "_ZN10S3352C2_nt4v186Ev");}
void  S3352C2_nt ::v187(){vfunc_called(this, "_ZN10S3352C2_nt4v187Ev");}
void  S3352C2_nt ::v188(){vfunc_called(this, "_ZN10S3352C2_nt4v188Ev");}
void  S3352C2_nt ::v189(){vfunc_called(this, "_ZN10S3352C2_nt4v189Ev");}
void  S3352C2_nt ::v190(){vfunc_called(this, "_ZN10S3352C2_nt4v190Ev");}
void  S3352C2_nt ::v191(){vfunc_called(this, "_ZN10S3352C2_nt4v191Ev");}
void  S3352C2_nt ::v192(){vfunc_called(this, "_ZN10S3352C2_nt4v192Ev");}
void  S3352C2_nt ::v193(){vfunc_called(this, "_ZN10S3352C2_nt4v193Ev");}
void  S3352C2_nt ::v194(){vfunc_called(this, "_ZN10S3352C2_nt4v194Ev");}
void  S3352C2_nt ::v195(){vfunc_called(this, "_ZN10S3352C2_nt4v195Ev");}
void  S3352C2_nt ::v196(){vfunc_called(this, "_ZN10S3352C2_nt4v196Ev");}
void  S3352C2_nt ::v197(){vfunc_called(this, "_ZN10S3352C2_nt4v197Ev");}
void  S3352C2_nt ::v198(){vfunc_called(this, "_ZN10S3352C2_nt4v198Ev");}
void  S3352C2_nt ::v199(){vfunc_called(this, "_ZN10S3352C2_nt4v199Ev");}
void  S3352C2_nt ::v200(){vfunc_called(this, "_ZN10S3352C2_nt4v200Ev");}
void  S3352C2_nt ::v201(){vfunc_called(this, "_ZN10S3352C2_nt4v201Ev");}
void  S3352C2_nt ::v202(){vfunc_called(this, "_ZN10S3352C2_nt4v202Ev");}
void  S3352C2_nt ::v203(){vfunc_called(this, "_ZN10S3352C2_nt4v203Ev");}
void  S3352C2_nt ::v204(){vfunc_called(this, "_ZN10S3352C2_nt4v204Ev");}
void  S3352C2_nt ::v205(){vfunc_called(this, "_ZN10S3352C2_nt4v205Ev");}
void  S3352C2_nt ::v206(){vfunc_called(this, "_ZN10S3352C2_nt4v206Ev");}
void  S3352C2_nt ::v207(){vfunc_called(this, "_ZN10S3352C2_nt4v207Ev");}
void  S3352C2_nt ::v208(){vfunc_called(this, "_ZN10S3352C2_nt4v208Ev");}
void  S3352C2_nt ::v209(){vfunc_called(this, "_ZN10S3352C2_nt4v209Ev");}
void  S3352C2_nt ::v210(){vfunc_called(this, "_ZN10S3352C2_nt4v210Ev");}
void  S3352C2_nt ::v211(){vfunc_called(this, "_ZN10S3352C2_nt4v211Ev");}
void  S3352C2_nt ::v212(){vfunc_called(this, "_ZN10S3352C2_nt4v212Ev");}
S3352C2_nt ::S3352C2_nt(){ note_ctor("S3352C2_nt", this);} // tgen

//skip512 S3352C2_nt

#else // __cplusplus

extern void _ZN10S3352C2_ntC1Ev();
extern void _ZN10S3352C2_ntD1Ev();
Name_Map name_map_S3352C2_nt[] = {
  NSPAIR(_ZN10S3352C2_ntC1Ev),
  NSPAIR(_ZN10S3352C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3352C3_nt;
extern VTBL_ENTRY _ZTI10S3352C3_nt[];
extern  VTBL_ENTRY _ZTV10S3352C3_nt[];
static Base_Class bases_S3352C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3352C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S3352C2_nt[];
extern void _ZN10S3352C2_ntD1Ev();
extern void _ZN10S3352C2_ntD0Ev();
extern void _ZN10S3352C3_nt2v6Ev();
extern void _ZN10S3352C3_nt2v7Ev();
extern void _ZN10S3352C3_nt2v8Ev();
extern void _ZN10S3352C3_nt2v9Ev();
extern void _ZN10S3352C3_nt3v10Ev();
extern void _ZN10S3352C3_nt3v11Ev();
extern void _ZN10S3352C3_nt3v12Ev();
extern void _ZN10S3352C3_nt3v13Ev();
extern void _ZN10S3352C3_nt3v14Ev();
extern void _ZN10S3352C3_nt3v15Ev();
extern void _ZN10S3352C3_nt3v16Ev();
extern void _ZN10S3352C3_nt3v17Ev();
extern void _ZN10S3352C3_nt3v18Ev();
extern void _ZN10S3352C3_nt3v19Ev();
extern void _ZN10S3352C3_nt3v20Ev();
extern void _ZN10S3352C3_nt3v21Ev();
extern void _ZN10S3352C3_nt3v22Ev();
extern void _ZN10S3352C3_nt3v23Ev();
extern void _ZN10S3352C3_nt3v24Ev();
extern void _ZN10S3352C3_nt3v25Ev();
extern void _ZN10S3352C3_nt3v26Ev();
extern void _ZN10S3352C3_nt3v27Ev();
extern void _ZN10S3352C3_nt3v28Ev();
extern void _ZN10S3352C3_nt3v29Ev();
extern void _ZN10S3352C3_nt3v30Ev();
extern void _ZN10S3352C3_nt3v31Ev();
extern void _ZN10S3352C3_nt3v32Ev();
extern void _ZN10S3352C3_nt3v33Ev();
extern void _ZN10S3352C3_nt3v34Ev();
extern void _ZN10S3352C3_nt3v35Ev();
extern void _ZN10S3352C3_nt3v36Ev();
extern void _ZN10S3352C3_nt3v37Ev();
extern void _ZN10S3352C3_nt3v38Ev();
extern void _ZN10S3352C3_nt3v39Ev();
extern void _ZN10S3352C3_nt3v40Ev();
extern void _ZN10S3352C3_nt3v41Ev();
extern void _ZN10S3352C3_nt3v42Ev();
extern void _ZN10S3352C3_nt3v43Ev();
extern void _ZN10S3352C3_nt3v44Ev();
extern void _ZN10S3352C3_nt3v45Ev();
extern void _ZN10S3352C3_nt3v46Ev();
extern void _ZN10S3352C3_nt3v47Ev();
extern void _ZN10S3352C3_nt3v48Ev();
extern void _ZN10S3352C3_nt3v49Ev();
extern void _ZN10S3352C3_nt3v50Ev();
extern void _ZN10S3352C3_nt3v51Ev();
extern void _ZN10S3352C3_nt3v52Ev();
extern void _ZN10S3352C3_nt3v53Ev();
extern void _ZN10S3352C3_nt3v54Ev();
extern void _ZN10S3352C3_nt3v55Ev();
extern void _ZN10S3352C3_nt3v56Ev();
extern void _ZN10S3352C3_nt3v57Ev();
extern void _ZN10S3352C3_nt3v58Ev();
extern void _ZN10S3352C3_nt3v59Ev();
extern void _ZN10S3352C3_nt3v60Ev();
extern void _ZN10S3352C3_nt3v61Ev();
extern void _ZN10S3352C3_nt3v62Ev();
extern void _ZN10S3352C3_nt3v63Ev();
extern void _ZN10S3352C3_nt3v64Ev();
extern void _ZN10S3352C3_nt3v65Ev();
extern void _ZN10S3352C3_nt3v66Ev();
extern void _ZN10S3352C3_nt3v67Ev();
extern void _ZN10S3352C3_nt3v68Ev();
extern void _ZN10S3352C3_nt3v69Ev();
extern void _ZN10S3352C2_nt3v70Ev();
extern void _ZN10S3352C2_nt3v71Ev();
extern void _ZN10S3352C2_nt3v72Ev();
extern void _ZN10S3352C2_nt3v73Ev();
extern void _ZN10S3352C2_nt3v74Ev();
extern void _ZN10S3352C2_nt3v75Ev();
extern void _ZN10S3352C2_nt3v76Ev();
extern void _ZN10S3352C2_nt3v77Ev();
extern void _ZN10S3352C2_nt3v78Ev();
extern void _ZN10S3352C2_nt3v79Ev();
extern void _ZN10S3352C2_nt3v80Ev();
extern void _ZN10S3352C2_nt3v81Ev();
extern void _ZN10S3352C2_nt3v82Ev();
extern void _ZN10S3352C2_nt3v83Ev();
extern void _ZN10S3352C2_nt3v84Ev();
extern void _ZN10S3352C2_nt3v85Ev();
extern void _ZN10S3352C2_nt3v86Ev();
extern void _ZN10S3352C2_nt3v87Ev();
extern void _ZN10S3352C2_nt3v88Ev();
extern void _ZN10S3352C2_nt3v89Ev();
extern void _ZN10S3352C2_nt3v90Ev();
extern void _ZN10S3352C2_nt3v91Ev();
extern void _ZN10S3352C2_nt3v92Ev();
extern void _ZN10S3352C2_nt3v93Ev();
extern void _ZN10S3352C2_nt3v94Ev();
extern void _ZN10S3352C2_nt3v95Ev();
extern void _ZN10S3352C2_nt3v96Ev();
extern void _ZN10S3352C2_nt3v97Ev();
extern void _ZN10S3352C2_nt3v98Ev();
extern void _ZN10S3352C2_nt3v99Ev();
extern void _ZN10S3352C2_nt4v100Ev();
extern void _ZN10S3352C2_nt4v101Ev();
extern void _ZN10S3352C2_nt4v102Ev();
extern void _ZN10S3352C2_nt4v103Ev();
extern void _ZN10S3352C2_nt4v104Ev();
extern void _ZN10S3352C2_nt4v105Ev();
extern void _ZN10S3352C2_nt4v106Ev();
extern void _ZN10S3352C2_nt4v107Ev();
extern void _ZN10S3352C2_nt4v108Ev();
extern void _ZN10S3352C2_nt4v109Ev();
extern void _ZN10S3352C2_nt4v110Ev();
extern void _ZN10S3352C2_nt4v111Ev();
extern void _ZN10S3352C2_nt4v112Ev();
extern void _ZN10S3352C2_nt4v113Ev();
extern void _ZN10S3352C2_nt4v114Ev();
extern void _ZN10S3352C2_nt4v115Ev();
extern void _ZN10S3352C2_nt4v116Ev();
extern void _ZN10S3352C2_nt4v117Ev();
extern void _ZN10S3352C2_nt4v118Ev();
extern void _ZN10S3352C2_nt4v119Ev();
extern void _ZN10S3352C2_nt4v120Ev();
extern void _ZN10S3352C2_nt4v121Ev();
extern void _ZN10S3352C2_nt4v122Ev();
extern void _ZN10S3352C2_nt4v123Ev();
extern void _ZN10S3352C2_nt4v124Ev();
extern void _ZN10S3352C2_nt4v125Ev();
extern void _ZN10S3352C2_nt4v126Ev();
extern void _ZN10S3352C2_nt4v127Ev();
extern void _ZN10S3352C2_nt4v128Ev();
extern void _ZN10S3352C2_nt4v129Ev();
extern void _ZN10S3352C2_nt4v130Ev();
extern void _ZN10S3352C2_nt4v131Ev();
extern void _ZN10S3352C2_nt4v132Ev();
extern void _ZN10S3352C2_nt4v133Ev();
extern void _ZN10S3352C2_nt4v134Ev();
extern void _ZN10S3352C2_nt4v135Ev();
extern void _ZN10S3352C2_nt4v136Ev();
extern void _ZN10S3352C2_nt4v137Ev();
extern void _ZN10S3352C2_nt4v138Ev();
extern void _ZN10S3352C2_nt4v139Ev();
extern void _ZN10S3352C2_nt4v140Ev();
extern void _ZN10S3352C2_nt4v141Ev();
extern void _ZN10S3352C2_nt4v142Ev();
extern void _ZN10S3352C2_nt4v143Ev();
extern void _ZN10S3352C2_nt4v144Ev();
extern void _ZN10S3352C2_nt4v145Ev();
extern void _ZN10S3352C2_nt4v146Ev();
extern void _ZN10S3352C2_nt4v147Ev();
extern void _ZN10S3352C2_nt4v148Ev();
extern void _ZN10S3352C2_nt4v149Ev();
extern void _ZN10S3352C2_nt4v150Ev();
extern void _ZN10S3352C2_nt4v151Ev();
extern void _ZN10S3352C2_nt4v152Ev();
extern void _ZN10S3352C2_nt4v153Ev();
extern void _ZN10S3352C2_nt4v154Ev();
extern void _ZN10S3352C2_nt4v155Ev();
extern void _ZN10S3352C2_nt4v156Ev();
extern void _ZN10S3352C2_nt4v157Ev();
extern void _ZN10S3352C2_nt4v158Ev();
extern void _ZN10S3352C2_nt4v159Ev();
extern void _ZN10S3352C2_nt4v160Ev();
extern void _ZN10S3352C2_nt4v161Ev();
extern void _ZN10S3352C2_nt4v162Ev();
extern void _ZN10S3352C2_nt4v163Ev();
extern void _ZN10S3352C2_nt4v164Ev();
extern void _ZN10S3352C2_nt4v165Ev();
extern void _ZN10S3352C2_nt4v166Ev();
extern void _ZN10S3352C2_nt4v167Ev();
extern void _ZN10S3352C2_nt4v168Ev();
extern void _ZN10S3352C2_nt4v169Ev();
extern void _ZN10S3352C2_nt4v170Ev();
extern void _ZN10S3352C2_nt4v171Ev();
extern void _ZN10S3352C2_nt4v172Ev();
extern void _ZN10S3352C2_nt4v173Ev();
extern void _ZN10S3352C2_nt4v174Ev();
extern void _ZN10S3352C2_nt4v175Ev();
extern void _ZN10S3352C2_nt4v176Ev();
extern void _ZN10S3352C2_nt4v177Ev();
extern void _ZN10S3352C2_nt4v178Ev();
extern void _ZN10S3352C2_nt4v179Ev();
extern void _ZN10S3352C2_nt4v180Ev();
extern void _ZN10S3352C2_nt4v181Ev();
extern void _ZN10S3352C2_nt4v182Ev();
extern void _ZN10S3352C2_nt4v183Ev();
extern void _ZN10S3352C2_nt4v184Ev();
extern void _ZN10S3352C2_nt4v185Ev();
extern void _ZN10S3352C2_nt4v186Ev();
extern void _ZN10S3352C2_nt4v187Ev();
extern void _ZN10S3352C2_nt4v188Ev();
extern void _ZN10S3352C2_nt4v189Ev();
extern void _ZN10S3352C2_nt4v190Ev();
extern void _ZN10S3352C2_nt4v191Ev();
extern void _ZN10S3352C2_nt4v192Ev();
extern void _ZN10S3352C2_nt4v193Ev();
extern void _ZN10S3352C2_nt4v194Ev();
extern void _ZN10S3352C2_nt4v195Ev();
extern void _ZN10S3352C2_nt4v196Ev();
extern void _ZN10S3352C2_nt4v197Ev();
extern void _ZN10S3352C2_nt4v198Ev();
extern void _ZN10S3352C2_nt4v199Ev();
extern void _ZN10S3352C2_nt4v200Ev();
extern void _ZN10S3352C2_nt4v201Ev();
extern void _ZN10S3352C2_nt4v202Ev();
extern void _ZN10S3352C2_nt4v203Ev();
extern void _ZN10S3352C2_nt4v204Ev();
extern void _ZN10S3352C2_nt4v205Ev();
extern void _ZN10S3352C2_nt4v206Ev();
extern void _ZN10S3352C2_nt4v207Ev();
extern void _ZN10S3352C2_nt4v208Ev();
extern void _ZN10S3352C2_nt4v209Ev();
extern void _ZN10S3352C2_nt4v210Ev();
extern void _ZN10S3352C2_nt4v211Ev();
extern void _ZN10S3352C2_nt4v212Ev();
static  VTBL_ENTRY vtc_S3352C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S3352C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S3352C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v211Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v212Ev,
};
extern VTBL_ENTRY _ZTI10S3352C2_nt[];
VTBL_ENTRY *P__ZTI10S3352C2_nt = _ZTI10S3352C2_nt; 
extern  VTBL_ENTRY _ZTV10S3352C2_nt[];
Class_Descriptor cd_S3352C2_nt = {  "S3352C2_nt", // class name
  bases_S3352C2_nt, 1,
  &(vtc_S3352C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(568,436), // object size
  NSPAIRA(_ZTI10S3352C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S3352C2_nt),211, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3352C21_nt  {
  void  mf3352c21(); // _ZN11S3352C21_nt9mf3352c21Ev
};
//SIG(-1 S3352C21_nt) C1{ m}


void  S3352C21_nt ::mf3352c21(){}

//skip512 S3352C21_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI11S3352C21_nt[];
VTBL_ENTRY *P__ZTI11S3352C21_nt = _ZTI11S3352C21_nt; 
Class_Descriptor cd_S3352C21_nt = {  "S3352C21_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI11S3352C21_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3352C1  : S3352C2_nt {
  void *s3352c1f0;
  int s3352c1f1[4];
  char s3352c1f2[2];
  unsigned int s3352c1f3:1;
  unsigned int s3352c1f4:1;
  unsigned int s3352c1f5:1;
  unsigned int s3352c1f6:1;
  unsigned int s3352c1f7:1;
  int s3352c1f8;
  ::S3352C21_nt s3352c1f9;
  virtual  ~S3352C1(); // _ZN7S3352C1D1Ev
  virtual void  v1(); // _ZN7S3352C12v1Ev
  virtual void  v2(); // _ZN7S3352C12v2Ev
  virtual void  v3(); // _ZN7S3352C12v3Ev
  virtual void  v4(); // _ZN7S3352C12v4Ev
  virtual void  v5(); // _ZN7S3352C12v5Ev
  S3352C1(); // tgen
};
//SIG(1 S3352C1) C1{ BC2{ BC3{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC5 FC8{ m Fi} Fi Fc[4] Fp[2] FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC4 FC4 FC4 FC9{ BC10{ BC7}} FC9 Fi Fp[2] FC11{ m Fi[3]} FC11 FC11 FC11 Fp FC4 FC9 FC11 FC11 Fi FC11 FC11 Fp Fi Fc FC11 FC11 Fp Fi Fp FC9 FC12{ BC13{ BC7}} FC12} vd v1 v2 v3 v4 v5 Fp Fi[4] Fc[2] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi FC14{ m}}


 S3352C1 ::~S3352C1(){ note_dtor("S3352C1", this);}
void  S3352C1 ::v1(){vfunc_called(this, "_ZN7S3352C12v1Ev");}
void  S3352C1 ::v2(){vfunc_called(this, "_ZN7S3352C12v2Ev");}
void  S3352C1 ::v3(){vfunc_called(this, "_ZN7S3352C12v3Ev");}
void  S3352C1 ::v4(){vfunc_called(this, "_ZN7S3352C12v4Ev");}
void  S3352C1 ::v5(){vfunc_called(this, "_ZN7S3352C12v5Ev");}
S3352C1 ::S3352C1(){ note_ctor("S3352C1", this);} // tgen

static void Test_S3352C1()
{
  extern Class_Descriptor cd_S3352C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(77,118)];
    init_test(&cd_S3352C1, buf);
    S3352C1 *dp, &lv = *(dp=new (buf) S3352C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(608,468), "sizeof(S3352C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3352C1)");
    check_base_class_offset(lv, (S3352C3_nt*)(S3352C2_nt*), 0, "S3352C1");
    check_base_class_offset(lv, (S3352C2_nt*), 0, "S3352C1");
    check_field_offset(lv, s3352c1f0, ABISELECT(568,436), "S3352C1.s3352c1f0");
    check_field_offset(lv, s3352c1f1, ABISELECT(576,440), "S3352C1.s3352c1f1");
    check_field_offset(lv, s3352c1f2, ABISELECT(592,456), "S3352C1.s3352c1f2");
    set_bf_and_test(lv, s3352c1f3, ABISELECT(594,458), 0, 1, 1, "S3352C1");
    set_bf_and_test(lv, s3352c1f4, ABISELECT(594,458), 1, 1, 1, "S3352C1");
    set_bf_and_test(lv, s3352c1f5, ABISELECT(594,458), 2, 1, 1, "S3352C1");
    set_bf_and_test(lv, s3352c1f6, ABISELECT(594,458), 3, 1, 1, "S3352C1");
    set_bf_and_test(lv, s3352c1f7, ABISELECT(594,458), 4, 1, 1, "S3352C1");
    check_field_offset(lv, s3352c1f8, ABISELECT(596,460), "S3352C1.s3352c1f8");
    check_field_offset(lv, s3352c1f9, ABISELECT(600,464), "S3352C1.s3352c1f9");
    test_class_info(&lv, &cd_S3352C1);
    dp->~S3352C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3352C1(Test_S3352C1, "S3352C1", ABISELECT(608,468));

#else // __cplusplus

extern void _ZN7S3352C1C1Ev();
extern void _ZN7S3352C1D1Ev();
Name_Map name_map_S3352C1[] = {
  NSPAIR(_ZN7S3352C1C1Ev),
  NSPAIR(_ZN7S3352C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3352C3_nt;
extern VTBL_ENTRY _ZTI10S3352C3_nt[];
extern  VTBL_ENTRY _ZTV10S3352C3_nt[];
extern Class_Descriptor cd_S3352C2_nt;
extern VTBL_ENTRY _ZTI10S3352C2_nt[];
extern  VTBL_ENTRY _ZTV10S3352C2_nt[];
static Base_Class bases_S3352C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3352C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3352C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3352C1[];
extern void _ZN7S3352C1D1Ev();
extern void _ZN7S3352C1D0Ev();
extern void _ZN10S3352C3_nt2v6Ev();
extern void _ZN10S3352C3_nt2v7Ev();
extern void _ZN10S3352C3_nt2v8Ev();
extern void _ZN10S3352C3_nt2v9Ev();
extern void _ZN10S3352C3_nt3v10Ev();
extern void _ZN10S3352C3_nt3v11Ev();
extern void _ZN10S3352C3_nt3v12Ev();
extern void _ZN10S3352C3_nt3v13Ev();
extern void _ZN10S3352C3_nt3v14Ev();
extern void _ZN10S3352C3_nt3v15Ev();
extern void _ZN10S3352C3_nt3v16Ev();
extern void _ZN10S3352C3_nt3v17Ev();
extern void _ZN10S3352C3_nt3v18Ev();
extern void _ZN10S3352C3_nt3v19Ev();
extern void _ZN10S3352C3_nt3v20Ev();
extern void _ZN10S3352C3_nt3v21Ev();
extern void _ZN10S3352C3_nt3v22Ev();
extern void _ZN10S3352C3_nt3v23Ev();
extern void _ZN10S3352C3_nt3v24Ev();
extern void _ZN10S3352C3_nt3v25Ev();
extern void _ZN10S3352C3_nt3v26Ev();
extern void _ZN10S3352C3_nt3v27Ev();
extern void _ZN10S3352C3_nt3v28Ev();
extern void _ZN10S3352C3_nt3v29Ev();
extern void _ZN10S3352C3_nt3v30Ev();
extern void _ZN10S3352C3_nt3v31Ev();
extern void _ZN10S3352C3_nt3v32Ev();
extern void _ZN10S3352C3_nt3v33Ev();
extern void _ZN10S3352C3_nt3v34Ev();
extern void _ZN10S3352C3_nt3v35Ev();
extern void _ZN10S3352C3_nt3v36Ev();
extern void _ZN10S3352C3_nt3v37Ev();
extern void _ZN10S3352C3_nt3v38Ev();
extern void _ZN10S3352C3_nt3v39Ev();
extern void _ZN10S3352C3_nt3v40Ev();
extern void _ZN10S3352C3_nt3v41Ev();
extern void _ZN10S3352C3_nt3v42Ev();
extern void _ZN10S3352C3_nt3v43Ev();
extern void _ZN10S3352C3_nt3v44Ev();
extern void _ZN10S3352C3_nt3v45Ev();
extern void _ZN10S3352C3_nt3v46Ev();
extern void _ZN10S3352C3_nt3v47Ev();
extern void _ZN10S3352C3_nt3v48Ev();
extern void _ZN10S3352C3_nt3v49Ev();
extern void _ZN10S3352C3_nt3v50Ev();
extern void _ZN10S3352C3_nt3v51Ev();
extern void _ZN10S3352C3_nt3v52Ev();
extern void _ZN10S3352C3_nt3v53Ev();
extern void _ZN10S3352C3_nt3v54Ev();
extern void _ZN10S3352C3_nt3v55Ev();
extern void _ZN10S3352C3_nt3v56Ev();
extern void _ZN10S3352C3_nt3v57Ev();
extern void _ZN10S3352C3_nt3v58Ev();
extern void _ZN10S3352C3_nt3v59Ev();
extern void _ZN10S3352C3_nt3v60Ev();
extern void _ZN10S3352C3_nt3v61Ev();
extern void _ZN10S3352C3_nt3v62Ev();
extern void _ZN10S3352C3_nt3v63Ev();
extern void _ZN10S3352C3_nt3v64Ev();
extern void _ZN10S3352C3_nt3v65Ev();
extern void _ZN10S3352C3_nt3v66Ev();
extern void _ZN10S3352C3_nt3v67Ev();
extern void _ZN10S3352C3_nt3v68Ev();
extern void _ZN10S3352C3_nt3v69Ev();
extern void _ZN10S3352C2_nt3v70Ev();
extern void _ZN10S3352C2_nt3v71Ev();
extern void _ZN10S3352C2_nt3v72Ev();
extern void _ZN10S3352C2_nt3v73Ev();
extern void _ZN10S3352C2_nt3v74Ev();
extern void _ZN10S3352C2_nt3v75Ev();
extern void _ZN10S3352C2_nt3v76Ev();
extern void _ZN10S3352C2_nt3v77Ev();
extern void _ZN10S3352C2_nt3v78Ev();
extern void _ZN10S3352C2_nt3v79Ev();
extern void _ZN10S3352C2_nt3v80Ev();
extern void _ZN10S3352C2_nt3v81Ev();
extern void _ZN10S3352C2_nt3v82Ev();
extern void _ZN10S3352C2_nt3v83Ev();
extern void _ZN10S3352C2_nt3v84Ev();
extern void _ZN10S3352C2_nt3v85Ev();
extern void _ZN10S3352C2_nt3v86Ev();
extern void _ZN10S3352C2_nt3v87Ev();
extern void _ZN10S3352C2_nt3v88Ev();
extern void _ZN10S3352C2_nt3v89Ev();
extern void _ZN10S3352C2_nt3v90Ev();
extern void _ZN10S3352C2_nt3v91Ev();
extern void _ZN10S3352C2_nt3v92Ev();
extern void _ZN10S3352C2_nt3v93Ev();
extern void _ZN10S3352C2_nt3v94Ev();
extern void _ZN10S3352C2_nt3v95Ev();
extern void _ZN10S3352C2_nt3v96Ev();
extern void _ZN10S3352C2_nt3v97Ev();
extern void _ZN10S3352C2_nt3v98Ev();
extern void _ZN10S3352C2_nt3v99Ev();
extern void _ZN10S3352C2_nt4v100Ev();
extern void _ZN10S3352C2_nt4v101Ev();
extern void _ZN10S3352C2_nt4v102Ev();
extern void _ZN10S3352C2_nt4v103Ev();
extern void _ZN10S3352C2_nt4v104Ev();
extern void _ZN10S3352C2_nt4v105Ev();
extern void _ZN10S3352C2_nt4v106Ev();
extern void _ZN10S3352C2_nt4v107Ev();
extern void _ZN10S3352C2_nt4v108Ev();
extern void _ZN10S3352C2_nt4v109Ev();
extern void _ZN10S3352C2_nt4v110Ev();
extern void _ZN10S3352C2_nt4v111Ev();
extern void _ZN10S3352C2_nt4v112Ev();
extern void _ZN10S3352C2_nt4v113Ev();
extern void _ZN10S3352C2_nt4v114Ev();
extern void _ZN10S3352C2_nt4v115Ev();
extern void _ZN10S3352C2_nt4v116Ev();
extern void _ZN10S3352C2_nt4v117Ev();
extern void _ZN10S3352C2_nt4v118Ev();
extern void _ZN10S3352C2_nt4v119Ev();
extern void _ZN10S3352C2_nt4v120Ev();
extern void _ZN10S3352C2_nt4v121Ev();
extern void _ZN10S3352C2_nt4v122Ev();
extern void _ZN10S3352C2_nt4v123Ev();
extern void _ZN10S3352C2_nt4v124Ev();
extern void _ZN10S3352C2_nt4v125Ev();
extern void _ZN10S3352C2_nt4v126Ev();
extern void _ZN10S3352C2_nt4v127Ev();
extern void _ZN10S3352C2_nt4v128Ev();
extern void _ZN10S3352C2_nt4v129Ev();
extern void _ZN10S3352C2_nt4v130Ev();
extern void _ZN10S3352C2_nt4v131Ev();
extern void _ZN10S3352C2_nt4v132Ev();
extern void _ZN10S3352C2_nt4v133Ev();
extern void _ZN10S3352C2_nt4v134Ev();
extern void _ZN10S3352C2_nt4v135Ev();
extern void _ZN10S3352C2_nt4v136Ev();
extern void _ZN10S3352C2_nt4v137Ev();
extern void _ZN10S3352C2_nt4v138Ev();
extern void _ZN10S3352C2_nt4v139Ev();
extern void _ZN10S3352C2_nt4v140Ev();
extern void _ZN10S3352C2_nt4v141Ev();
extern void _ZN10S3352C2_nt4v142Ev();
extern void _ZN10S3352C2_nt4v143Ev();
extern void _ZN10S3352C2_nt4v144Ev();
extern void _ZN10S3352C2_nt4v145Ev();
extern void _ZN10S3352C2_nt4v146Ev();
extern void _ZN10S3352C2_nt4v147Ev();
extern void _ZN10S3352C2_nt4v148Ev();
extern void _ZN10S3352C2_nt4v149Ev();
extern void _ZN10S3352C2_nt4v150Ev();
extern void _ZN10S3352C2_nt4v151Ev();
extern void _ZN10S3352C2_nt4v152Ev();
extern void _ZN10S3352C2_nt4v153Ev();
extern void _ZN10S3352C2_nt4v154Ev();
extern void _ZN10S3352C2_nt4v155Ev();
extern void _ZN10S3352C2_nt4v156Ev();
extern void _ZN10S3352C2_nt4v157Ev();
extern void _ZN10S3352C2_nt4v158Ev();
extern void _ZN10S3352C2_nt4v159Ev();
extern void _ZN10S3352C2_nt4v160Ev();
extern void _ZN10S3352C2_nt4v161Ev();
extern void _ZN10S3352C2_nt4v162Ev();
extern void _ZN10S3352C2_nt4v163Ev();
extern void _ZN10S3352C2_nt4v164Ev();
extern void _ZN10S3352C2_nt4v165Ev();
extern void _ZN10S3352C2_nt4v166Ev();
extern void _ZN10S3352C2_nt4v167Ev();
extern void _ZN10S3352C2_nt4v168Ev();
extern void _ZN10S3352C2_nt4v169Ev();
extern void _ZN10S3352C2_nt4v170Ev();
extern void _ZN10S3352C2_nt4v171Ev();
extern void _ZN10S3352C2_nt4v172Ev();
extern void _ZN10S3352C2_nt4v173Ev();
extern void _ZN10S3352C2_nt4v174Ev();
extern void _ZN10S3352C2_nt4v175Ev();
extern void _ZN10S3352C2_nt4v176Ev();
extern void _ZN10S3352C2_nt4v177Ev();
extern void _ZN10S3352C2_nt4v178Ev();
extern void _ZN10S3352C2_nt4v179Ev();
extern void _ZN10S3352C2_nt4v180Ev();
extern void _ZN10S3352C2_nt4v181Ev();
extern void _ZN10S3352C2_nt4v182Ev();
extern void _ZN10S3352C2_nt4v183Ev();
extern void _ZN10S3352C2_nt4v184Ev();
extern void _ZN10S3352C2_nt4v185Ev();
extern void _ZN10S3352C2_nt4v186Ev();
extern void _ZN10S3352C2_nt4v187Ev();
extern void _ZN10S3352C2_nt4v188Ev();
extern void _ZN10S3352C2_nt4v189Ev();
extern void _ZN10S3352C2_nt4v190Ev();
extern void _ZN10S3352C2_nt4v191Ev();
extern void _ZN10S3352C2_nt4v192Ev();
extern void _ZN10S3352C2_nt4v193Ev();
extern void _ZN10S3352C2_nt4v194Ev();
extern void _ZN10S3352C2_nt4v195Ev();
extern void _ZN10S3352C2_nt4v196Ev();
extern void _ZN10S3352C2_nt4v197Ev();
extern void _ZN10S3352C2_nt4v198Ev();
extern void _ZN10S3352C2_nt4v199Ev();
extern void _ZN10S3352C2_nt4v200Ev();
extern void _ZN10S3352C2_nt4v201Ev();
extern void _ZN10S3352C2_nt4v202Ev();
extern void _ZN10S3352C2_nt4v203Ev();
extern void _ZN10S3352C2_nt4v204Ev();
extern void _ZN10S3352C2_nt4v205Ev();
extern void _ZN10S3352C2_nt4v206Ev();
extern void _ZN10S3352C2_nt4v207Ev();
extern void _ZN10S3352C2_nt4v208Ev();
extern void _ZN10S3352C2_nt4v209Ev();
extern void _ZN10S3352C2_nt4v210Ev();
extern void _ZN10S3352C2_nt4v211Ev();
extern void _ZN10S3352C2_nt4v212Ev();
extern void _ZN7S3352C12v1Ev();
extern void _ZN7S3352C12v2Ev();
extern void _ZN7S3352C12v3Ev();
extern void _ZN7S3352C12v4Ev();
extern void _ZN7S3352C12v5Ev();
static  VTBL_ENTRY vtc_S3352C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3352C1[0]),
  (VTBL_ENTRY)&_ZN7S3352C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3352C1D0Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S3352C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v211Ev,
  (VTBL_ENTRY)&_ZN10S3352C2_nt4v212Ev,
  (VTBL_ENTRY)&_ZN7S3352C12v1Ev,
  (VTBL_ENTRY)&_ZN7S3352C12v2Ev,
  (VTBL_ENTRY)&_ZN7S3352C12v3Ev,
  (VTBL_ENTRY)&_ZN7S3352C12v4Ev,
  (VTBL_ENTRY)&_ZN7S3352C12v5Ev,
};
extern VTBL_ENTRY _ZTI7S3352C1[];
extern  VTBL_ENTRY _ZTV7S3352C1[];
Class_Descriptor cd_S3352C1 = {  "S3352C1", // class name
  bases_S3352C1, 2,
  &(vtc_S3352C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(608,468), // object size
  NSPAIRA(_ZTI7S3352C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3352C1),216, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2120C8_nt  {
  void  mf2120c8(); // _ZN10S2120C8_nt8mf2120c8Ev
};
//SIG(-1 S2120C8_nt) C1{ m}


void  S2120C8_nt ::mf2120c8(){}

//skip512 S2120C8_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2120C6_nt  {
  void *s2120c6f0;
  int s2120c6f1;
  ::S3352C21_nt s2120c6f2;
  ::S2120C8_nt s2120c6f3;
  void  mf2120c6(); // _ZN10S2120C6_nt8mf2120c6Ev
};
//SIG(-1 S2120C6_nt) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S2120C6_nt ::mf2120c6(){}

//skip512 S2120C6_nt

#else // __cplusplus

Class_Descriptor cd_S2120C6_nt = {  "S2120C6_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2120C5_nt  : S2120C6_nt {
};
//SIG(-1 S2120C5_nt) C1{ BC2{ m Fp Fi FC3{ m} FC4{ m}}}



//skip512 S2120C5_nt

#else // __cplusplus

extern Class_Descriptor cd_S2120C6_nt;
static Base_Class bases_S2120C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2120C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2120C4_nt  {
  void *s2120c4f0;
  int s2120c4f1;
  ::S2120C5_nt s2120c4f2;
  ::S2120C5_nt s2120c4f3;
  int s2120c4f4;
  virtual  ~S2120C4_nt(); // _ZN10S2120C4_ntD1Ev
  virtual void  v2(); // _ZN10S2120C4_nt2v2Ev
  virtual void  v3(); // _ZN10S2120C4_nt2v3Ev
  virtual void  v4(); // _ZN10S2120C4_nt2v4Ev
  virtual void  v5(); // _ZN10S2120C4_nt2v5Ev
  virtual void  v6(); // _ZN10S2120C4_nt2v6Ev
  virtual void  v7(); // _ZN10S2120C4_nt2v7Ev
  virtual void  v8(); // _ZN10S2120C4_nt2v8Ev
  virtual void  v9(); // _ZN10S2120C4_nt2v9Ev
  virtual void  v10(); // _ZN10S2120C4_nt3v10Ev
  virtual void  v11(); // _ZN10S2120C4_nt3v11Ev
  virtual void  v12(); // _ZN10S2120C4_nt3v12Ev
  virtual void  v13(); // _ZN10S2120C4_nt3v13Ev
  virtual void  v14(); // _ZN10S2120C4_nt3v14Ev
  virtual void  v15(); // _ZN10S2120C4_nt3v15Ev
  virtual void  v16(); // _ZN10S2120C4_nt3v16Ev
  virtual void  v17(); // _ZN10S2120C4_nt3v17Ev
  virtual void  v18(); // _ZN10S2120C4_nt3v18Ev
  virtual void  v19(); // _ZN10S2120C4_nt3v19Ev
  virtual void  v20(); // _ZN10S2120C4_nt3v20Ev
  virtual void  v21(); // _ZN10S2120C4_nt3v21Ev
  virtual void  v22(); // _ZN10S2120C4_nt3v22Ev
  virtual void  v23(); // _ZN10S2120C4_nt3v23Ev
  virtual void  v24(); // _ZN10S2120C4_nt3v24Ev
  S2120C4_nt(); // tgen
};
//SIG(-1 S2120C4_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC2{ BC3{ m Fp Fi FC4{ m} FC5{ m}}} FC2 Fi}


 S2120C4_nt ::~S2120C4_nt(){ note_dtor("S2120C4_nt", this);}
void  S2120C4_nt ::v2(){vfunc_called(this, "_ZN10S2120C4_nt2v2Ev");}
void  S2120C4_nt ::v3(){vfunc_called(this, "_ZN10S2120C4_nt2v3Ev");}
void  S2120C4_nt ::v4(){vfunc_called(this, "_ZN10S2120C4_nt2v4Ev");}
void  S2120C4_nt ::v5(){vfunc_called(this, "_ZN10S2120C4_nt2v5Ev");}
void  S2120C4_nt ::v6(){vfunc_called(this, "_ZN10S2120C4_nt2v6Ev");}
void  S2120C4_nt ::v7(){vfunc_called(this, "_ZN10S2120C4_nt2v7Ev");}
void  S2120C4_nt ::v8(){vfunc_called(this, "_ZN10S2120C4_nt2v8Ev");}
void  S2120C4_nt ::v9(){vfunc_called(this, "_ZN10S2120C4_nt2v9Ev");}
void  S2120C4_nt ::v10(){vfunc_called(this, "_ZN10S2120C4_nt3v10Ev");}
void  S2120C4_nt ::v11(){vfunc_called(this, "_ZN10S2120C4_nt3v11Ev");}
void  S2120C4_nt ::v12(){vfunc_called(this, "_ZN10S2120C4_nt3v12Ev");}
void  S2120C4_nt ::v13(){vfunc_called(this, "_ZN10S2120C4_nt3v13Ev");}
void  S2120C4_nt ::v14(){vfunc_called(this, "_ZN10S2120C4_nt3v14Ev");}
void  S2120C4_nt ::v15(){vfunc_called(this, "_ZN10S2120C4_nt3v15Ev");}
void  S2120C4_nt ::v16(){vfunc_called(this, "_ZN10S2120C4_nt3v16Ev");}
void  S2120C4_nt ::v17(){vfunc_called(this, "_ZN10S2120C4_nt3v17Ev");}
void  S2120C4_nt ::v18(){vfunc_called(this, "_ZN10S2120C4_nt3v18Ev");}
void  S2120C4_nt ::v19(){vfunc_called(this, "_ZN10S2120C4_nt3v19Ev");}
void  S2120C4_nt ::v20(){vfunc_called(this, "_ZN10S2120C4_nt3v20Ev");}
void  S2120C4_nt ::v21(){vfunc_called(this, "_ZN10S2120C4_nt3v21Ev");}
void  S2120C4_nt ::v22(){vfunc_called(this, "_ZN10S2120C4_nt3v22Ev");}
void  S2120C4_nt ::v23(){vfunc_called(this, "_ZN10S2120C4_nt3v23Ev");}
void  S2120C4_nt ::v24(){vfunc_called(this, "_ZN10S2120C4_nt3v24Ev");}
S2120C4_nt ::S2120C4_nt(){ note_ctor("S2120C4_nt", this);} // tgen

//skip512 S2120C4_nt

#else // __cplusplus

extern void _ZN10S2120C4_ntC1Ev();
extern void _ZN10S2120C4_ntD1Ev();
Name_Map name_map_S2120C4_nt[] = {
  NSPAIR(_ZN10S2120C4_ntC1Ev),
  NSPAIR(_ZN10S2120C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S2120C4_nt[];
extern void _ZN10S2120C4_ntD1Ev();
extern void _ZN10S2120C4_ntD0Ev();
extern void _ZN10S2120C4_nt2v2Ev();
extern void _ZN10S2120C4_nt2v3Ev();
extern void _ZN10S2120C4_nt2v4Ev();
extern void _ZN10S2120C4_nt2v5Ev();
extern void _ZN10S2120C4_nt2v6Ev();
extern void _ZN10S2120C4_nt2v7Ev();
extern void _ZN10S2120C4_nt2v8Ev();
extern void _ZN10S2120C4_nt2v9Ev();
extern void _ZN10S2120C4_nt3v10Ev();
extern void _ZN10S2120C4_nt3v11Ev();
extern void _ZN10S2120C4_nt3v12Ev();
extern void _ZN10S2120C4_nt3v13Ev();
extern void _ZN10S2120C4_nt3v14Ev();
extern void _ZN10S2120C4_nt3v15Ev();
extern void _ZN10S2120C4_nt3v16Ev();
extern void _ZN10S2120C4_nt3v17Ev();
extern void _ZN10S2120C4_nt3v18Ev();
extern void _ZN10S2120C4_nt3v19Ev();
extern void _ZN10S2120C4_nt3v20Ev();
extern void _ZN10S2120C4_nt3v21Ev();
extern void _ZN10S2120C4_nt3v22Ev();
extern void _ZN10S2120C4_nt3v23Ev();
extern void _ZN10S2120C4_nt3v24Ev();
static  VTBL_ENTRY vtc_S2120C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2120C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S2120C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v2Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v24Ev,
};
extern VTBL_ENTRY _ZTI10S2120C4_nt[];
VTBL_ENTRY *P__ZTI10S2120C4_nt = _ZTI10S2120C4_nt; 
extern  VTBL_ENTRY _ZTV10S2120C4_nt[];
Class_Descriptor cd_S2120C4_nt = {  "S2120C4_nt", // class name
  0,0,//no base classes
  &(vtc_S2120C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI10S2120C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S2120C4_nt),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2120C14_nt  {
  __tsi64 s2120c14f0[2];
  void  mf2120c14(); // _ZN11S2120C14_nt9mf2120c14Ev
};
//SIG(-1 S2120C14_nt) C1{ m FL[2]}


void  S2120C14_nt ::mf2120c14(){}

//skip512 S2120C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2120C13_nt  {
  ::S2120C14_nt s2120c13f0;
  void  mf2120c13(); // _ZN11S2120C13_nt9mf2120c13Ev
};
//SIG(-1 S2120C13_nt) C1{ m FC2{ m FL[2]}}


void  S2120C13_nt ::mf2120c13(){}

//skip512 S2120C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2120C17_nt  {
  ::S2120C13_nt s2120c17f0;
  void  mf2120c17(); // _ZN11S2120C17_nt9mf2120c17Ev
};
//SIG(-1 S2120C17_nt) C1{ m FC2{ m FC3{ m FL[2]}}}


void  S2120C17_nt ::mf2120c17(){}

//skip512 S2120C17_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2120C18_nt  {
  ::S2120C13_nt s2120c18f0;
  ::S2120C13_nt s2120c18f1;
  ::S2120C13_nt s2120c18f2;
  ::S2120C13_nt s2120c18f3;
  void  mf2120c18(); // _ZN11S2120C18_nt9mf2120c18Ev
};
//SIG(-1 S2120C18_nt) C1{ m FC2{ m FC3{ m FL[2]}} FC2 FC2 FC2}


void  S2120C18_nt ::mf2120c18(){}

//skip512 S2120C18_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2120C20_nt  {
  void *s2120c20f0;
  int s2120c20f1;
  ::S2120C8_nt s2120c20f2;
  void  mf2120c20(); // _ZN11S2120C20_nt9mf2120c20Ev
};
//SIG(-1 S2120C20_nt) C1{ m Fp Fi FC2{ m}}


void  S2120C20_nt ::mf2120c20(){}

//skip512 S2120C20_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2120C19_nt  {
  ::S2120C20_nt s2120c19f0;
  int s2120c19f1;
  void  mf2120c19(); // _ZN11S2120C19_nt9mf2120c19Ev
};
//SIG(-1 S2120C19_nt) C1{ m FC2{ m Fp Fi FC3{ m}} Fi}


void  S2120C19_nt ::mf2120c19(){}

//skip512 S2120C19_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2120C23  {
  void  mf2120c23(); // _ZN8S2120C239mf2120c23Ev
};
//SIG(-1 S2120C23) C1{ m}


void  S2120C23 ::mf2120c23(){}

static void Test_S2120C23()
{
  {
    init_simple_test("S2120C23");
    S2120C23 lv;
    check2(sizeof(lv), 1, "sizeof(S2120C23)");
    check2(__alignof__(lv), 1, "__alignof__(S2120C23)");
  }
}
static Arrange_To_Call_Me vS2120C23(Test_S2120C23, "S2120C23", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2120C22  {
  void *s2120c22f0;
  int s2120c22f1;
  ::S2120C23 s2120c22f2;
  ::S2120C23 s2120c22f3;
  void  mf2120c22(); // _ZN8S2120C229mf2120c22Ev
};
//SIG(-1 S2120C22) C1{ m Fp Fi FC2{ m} FC2}


void  S2120C22 ::mf2120c22(){}

static void Test_S2120C22()
{
  {
    init_simple_test("S2120C22");
    S2120C22 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2120C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2120C22)");
    check_field_offset(lv, s2120c22f0, 0, "S2120C22.s2120c22f0");
    check_field_offset(lv, s2120c22f1, ABISELECT(8,4), "S2120C22.s2120c22f1");
    check_field_offset(lv, s2120c22f2, ABISELECT(12,8), "S2120C22.s2120c22f2");
    check_field_offset(lv, s2120c22f3, ABISELECT(13,9), "S2120C22.s2120c22f3");
  }
}
static Arrange_To_Call_Me vS2120C22(Test_S2120C22, "S2120C22", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2120C27  {
  void  mf2120c27(); // _ZN8S2120C279mf2120c27Ev
};
//SIG(-1 S2120C27) C1{ m}


void  S2120C27 ::mf2120c27(){}

static void Test_S2120C27()
{
  {
    init_simple_test("S2120C27");
    S2120C27 lv;
    check2(sizeof(lv), 1, "sizeof(S2120C27)");
    check2(__alignof__(lv), 1, "__alignof__(S2120C27)");
  }
}
static Arrange_To_Call_Me vS2120C27(Test_S2120C27, "S2120C27", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2120C26  {
  void *s2120c26f0;
  int s2120c26f1;
  ::S2120C27 s2120c26f2;
  ::S2120C27 s2120c26f3;
  void  mf2120c26(); // _ZN8S2120C269mf2120c26Ev
};
//SIG(-1 S2120C26) C1{ m Fp Fi FC2{ m} FC2}


void  S2120C26 ::mf2120c26(){}

static void Test_S2120C26()
{
  {
    init_simple_test("S2120C26");
    S2120C26 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2120C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2120C26)");
    check_field_offset(lv, s2120c26f0, 0, "S2120C26.s2120c26f0");
    check_field_offset(lv, s2120c26f1, ABISELECT(8,4), "S2120C26.s2120c26f1");
    check_field_offset(lv, s2120c26f2, ABISELECT(12,8), "S2120C26.s2120c26f2");
    check_field_offset(lv, s2120c26f3, ABISELECT(13,9), "S2120C26.s2120c26f3");
  }
}
static Arrange_To_Call_Me vS2120C26(Test_S2120C26, "S2120C26", ABISELECT(16,12));

#else // __cplusplus

Class_Descriptor cd_S2120C26 = {  "S2120C26", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2120C25  : S2120C26 {
};
//SIG(-1 S2120C25) C1{ BC2{ m Fp Fi FC3{ m} FC3}}



static void Test_S2120C25()
{
  extern Class_Descriptor cd_S2120C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S2120C25, buf);
    S2120C25 &lv = *(new (buf) S2120C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2120C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2120C25)");
    check_base_class_offset(lv, (S2120C26*), 0, "S2120C25");
    test_class_info(&lv, &cd_S2120C25);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2120C25(Test_S2120C25, "S2120C25", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S2120C26;
static Base_Class bases_S2120C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2120C26,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S2120C25 = {  "S2120C25", // class name
  bases_S2120C25, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2120C30  {
  void  mf2120c30(); // _ZN8S2120C309mf2120c30Ev
};
//SIG(-1 S2120C30) C1{ m}


void  S2120C30 ::mf2120c30(){}

static void Test_S2120C30()
{
  {
    init_simple_test("S2120C30");
    S2120C30 lv;
    check2(sizeof(lv), 1, "sizeof(S2120C30)");
    check2(__alignof__(lv), 1, "__alignof__(S2120C30)");
  }
}
static Arrange_To_Call_Me vS2120C30(Test_S2120C30, "S2120C30", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2120C29_nt  {
  void *s2120c29f0;
  int s2120c29f1[2];
  ::S2120C30 s2120c29f2;
  void  mf2120c29(); // _ZN11S2120C29_nt9mf2120c29Ev
};
//SIG(-1 S2120C29_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S2120C29_nt ::mf2120c29(){}

//skip512 S2120C29_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2120C37  {
  void *s2120c37f0;
  int s2120c37f1[2];
  ::S2120C30 s2120c37f2;
  void  mf2120c37(); // _ZN8S2120C379mf2120c37Ev
};
//SIG(-1 S2120C37) C1{ m Fp Fi[2] FC2{ m}}


void  S2120C37 ::mf2120c37(){}

static void Test_S2120C37()
{
  {
    init_simple_test("S2120C37");
    S2120C37 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S2120C37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2120C37)");
    check_field_offset(lv, s2120c37f0, 0, "S2120C37.s2120c37f0");
    check_field_offset(lv, s2120c37f1, ABISELECT(8,4), "S2120C37.s2120c37f1");
    check_field_offset(lv, s2120c37f2, ABISELECT(16,12), "S2120C37.s2120c37f2");
  }
}
static Arrange_To_Call_Me vS2120C37(Test_S2120C37, "S2120C37", ABISELECT(24,16));

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S2120C37[];
VTBL_ENTRY *P__ZTI8S2120C37 = _ZTI8S2120C37; 
Class_Descriptor cd_S2120C37 = {  "S2120C37", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI8S2120C37),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2120C3_nt  : S2120C4_nt {
  ::S2120C13_nt s2120c3f0;
  ::S2120C13_nt s2120c3f1;
  ::S2120C13_nt s2120c3f2;
  ::S2120C13_nt s2120c3f3;
  ::S2120C17_nt s2120c3f4;
  ::S2120C18_nt s2120c3f5;
  ::S2120C18_nt s2120c3f6;
  ::S2120C13_nt s2120c3f7;
  ::S2120C13_nt s2120c3f8;
  ::S2120C13_nt s2120c3f9;
  void *s2120c3f10;
  ::S2120C17_nt s2120c3f11;
  ::S2120C19_nt s2120c3f12;
  int s2120c3f13;
  void *s2120c3f14[7];
  ::S2120C22 s2120c3f15;
  int s2120c3f16:8;
  int s2120c3f17:8;
  int s2120c3f18:16;
  int s2120c3f19:16;
  int s2120c3f20:8;
  int s2120c3f21:8;
  int s2120c3f22:8;
  int s2120c3f23:32;
  int s2120c3f24:8;
  int s2120c3f25:4;
  int s2120c3f26:4;
  int s2120c3f27:4;
  int s2120c3f28:4;
  int s2120c3f29:4;
  int s2120c3f30:4;
  int s2120c3f31:4;
  int s2120c3f32:4;
  int s2120c3f33:4;
  int s2120c3f34:4;
  unsigned char s2120c3f35:1;
  unsigned char s2120c3f36:1;
  unsigned char s2120c3f37:1;
  unsigned char s2120c3f38:1;
  unsigned char s2120c3f39:1;
  unsigned char s2120c3f40:1;
  unsigned char s2120c3f41:1;
  unsigned char s2120c3f42:1;
  unsigned char s2120c3f43:1;
  unsigned char s2120c3f44:1;
  unsigned char s2120c3f45:1;
  unsigned char s2120c3f46:1;
  unsigned char s2120c3f47:1;
  unsigned char s2120c3f48:1;
  unsigned char s2120c3f49:1;
  unsigned char s2120c3f50:1;
  unsigned char s2120c3f51:1;
  unsigned char s2120c3f52:1;
  unsigned char s2120c3f53:1;
  unsigned char s2120c3f54:1;
  unsigned char s2120c3f55:1;
  unsigned char s2120c3f56:1;
  unsigned char s2120c3f57:1;
  unsigned char s2120c3f58:1;
  unsigned char s2120c3f59:1;
  unsigned char s2120c3f60:1;
  unsigned char s2120c3f61:1;
  unsigned char s2120c3f62:1;
  unsigned char s2120c3f63:1;
  unsigned char s2120c3f64:1;
  unsigned char s2120c3f65:1;
  unsigned char s2120c3f66:1;
  unsigned char s2120c3f67:1;
  unsigned char s2120c3f68:1;
  unsigned char s2120c3f69:1;
  unsigned char s2120c3f70:1;
  unsigned char s2120c3f71:1;
  unsigned char s2120c3f72:1;
  unsigned char s2120c3f73:1;
  unsigned char s2120c3f74:1;
  unsigned char s2120c3f75:1;
  int s2120c3f76[7];
  void *s2120c3f77[6];
  int s2120c3f78:8;
  int s2120c3f79:8;
  int s2120c3f80:8;
  int s2120c3f81:8;
  int s2120c3f82:8;
  int s2120c3f83:8;
  ::S2120C25 s2120c3f84;
  void *s2120c3f85[4];
  int s2120c3f86:8;
  int s2120c3f87:8;
  int s2120c3f88:8;
  int s2120c3f89:8;
  int s2120c3f90:8;
  int s2120c3f91:16;
  int s2120c3f92:16;
  int s2120c3f93:16;
  int s2120c3f94:4;
  int s2120c3f95:4;
  int s2120c3f96:4;
  int s2120c3f97:4;
  int s2120c3f98:4;
  int s2120c3f99:4;
  int s2120c3f100:4;
  int s2120c3f101:4;
  int s2120c3f102:4;
  int s2120c3f103:4;
  int s2120c3f104:4;
  int s2120c3f105:4;
  int s2120c3f106:8;
  int s2120c3f107:8;
  int s2120c3f108:8;
  void *s2120c3f109[7];
  ::S2120C29_nt s2120c3f110;
  void *s2120c3f111[2];
  int s2120c3f112:16;
  int s2120c3f113:16;
  ::S2120C25 s2120c3f114;
  ::S2120C29_nt s2120c3f115;
  ::S2120C37 s2120c3f116;
  void *s2120c3f117[2];
  int s2120c3f118:24;
  int s2120c3f119:8;
  void *s2120c3f120;
  virtual  ~S2120C3_nt(); // _ZN10S2120C3_ntD1Ev
  virtual void  v25(); // _ZN10S2120C3_nt3v25Ev
  virtual void  v26(); // _ZN10S2120C3_nt3v26Ev
  virtual void  v27(); // _ZN10S2120C3_nt3v27Ev
  virtual void  v28(); // _ZN10S2120C3_nt3v28Ev
  virtual void  v29(); // _ZN10S2120C3_nt3v29Ev
  virtual void  v30(); // _ZN10S2120C3_nt3v30Ev
  virtual void  v31(); // _ZN10S2120C3_nt3v31Ev
  virtual void  v32(); // _ZN10S2120C3_nt3v32Ev
  virtual void  v33(); // _ZN10S2120C3_nt3v33Ev
  virtual void  v34(); // _ZN10S2120C3_nt3v34Ev
  virtual void  v35(); // _ZN10S2120C3_nt3v35Ev
  virtual void  v36(); // _ZN10S2120C3_nt3v36Ev
  virtual void  v37(); // _ZN10S2120C3_nt3v37Ev
  virtual void  v38(); // _ZN10S2120C3_nt3v38Ev
  virtual void  v39(); // _ZN10S2120C3_nt3v39Ev
  virtual void  v40(); // _ZN10S2120C3_nt3v40Ev
  virtual void  v41(); // _ZN10S2120C3_nt3v41Ev
  virtual void  v42(); // _ZN10S2120C3_nt3v42Ev
  virtual void  v43(); // _ZN10S2120C3_nt3v43Ev
  virtual void  v44(); // _ZN10S2120C3_nt3v44Ev
  virtual void  v45(); // _ZN10S2120C3_nt3v45Ev
  virtual void  v46(); // _ZN10S2120C3_nt3v46Ev
  virtual void  v47(); // _ZN10S2120C3_nt3v47Ev
  virtual void  v48(); // _ZN10S2120C3_nt3v48Ev
  virtual void  v49(); // _ZN10S2120C3_nt3v49Ev
  virtual void  v50(); // _ZN10S2120C3_nt3v50Ev
  virtual void  v51(); // _ZN10S2120C3_nt3v51Ev
  virtual void  v52(); // _ZN10S2120C3_nt3v52Ev
  virtual void  v53(); // _ZN10S2120C3_nt3v53Ev
  virtual void  v54(); // _ZN10S2120C3_nt3v54Ev
  virtual void  v55(); // _ZN10S2120C3_nt3v55Ev
  virtual void  v56(); // _ZN10S2120C3_nt3v56Ev
  virtual void  v57(); // _ZN10S2120C3_nt3v57Ev
  virtual void  v58(); // _ZN10S2120C3_nt3v58Ev
  virtual void  v59(); // _ZN10S2120C3_nt3v59Ev
  virtual void  v60(); // _ZN10S2120C3_nt3v60Ev
  virtual void  v61(); // _ZN10S2120C3_nt3v61Ev
  virtual void  v62(); // _ZN10S2120C3_nt3v62Ev
  virtual void  v63(); // _ZN10S2120C3_nt3v63Ev
  virtual void  v64(); // _ZN10S2120C3_nt3v64Ev
  virtual void  v65(); // _ZN10S2120C3_nt3v65Ev
  virtual void  v66(); // _ZN10S2120C3_nt3v66Ev
  virtual void  v67(); // _ZN10S2120C3_nt3v67Ev
  virtual void  v68(); // _ZN10S2120C3_nt3v68Ev
  virtual void  v69(); // _ZN10S2120C3_nt3v69Ev
  virtual void  v70(); // _ZN10S2120C3_nt3v70Ev
  virtual void  v71(); // _ZN10S2120C3_nt3v71Ev
  virtual void  v72(); // _ZN10S2120C3_nt3v72Ev
  virtual void  v73(); // _ZN10S2120C3_nt3v73Ev
  virtual void  v74(); // _ZN10S2120C3_nt3v74Ev
  virtual void  v75(); // _ZN10S2120C3_nt3v75Ev
  virtual void  v76(); // _ZN10S2120C3_nt3v76Ev
  virtual void  v77(); // _ZN10S2120C3_nt3v77Ev
  virtual void  v78(); // _ZN10S2120C3_nt3v78Ev
  virtual void  v79(); // _ZN10S2120C3_nt3v79Ev
  virtual void  v80(); // _ZN10S2120C3_nt3v80Ev
  virtual void  v81(); // _ZN10S2120C3_nt3v81Ev
  virtual void  v82(); // _ZN10S2120C3_nt3v82Ev
  virtual void  v83(); // _ZN10S2120C3_nt3v83Ev
  virtual void  v84(); // _ZN10S2120C3_nt3v84Ev
  virtual void  v85(); // _ZN10S2120C3_nt3v85Ev
  virtual void  v86(); // _ZN10S2120C3_nt3v86Ev
  virtual void  v87(); // _ZN10S2120C3_nt3v87Ev
  virtual void  v88(); // _ZN10S2120C3_nt3v88Ev
  virtual void  v89(); // _ZN10S2120C3_nt3v89Ev
  virtual void  v90(); // _ZN10S2120C3_nt3v90Ev
  virtual void  v91(); // _ZN10S2120C3_nt3v91Ev
  virtual void  v92(); // _ZN10S2120C3_nt3v92Ev
  virtual void  v93(); // _ZN10S2120C3_nt3v93Ev
  virtual void  v94(); // _ZN10S2120C3_nt3v94Ev
  virtual void  v95(); // _ZN10S2120C3_nt3v95Ev
  virtual void  v96(); // _ZN10S2120C3_nt3v96Ev
  virtual void  v97(); // _ZN10S2120C3_nt3v97Ev
  virtual void  v98(); // _ZN10S2120C3_nt3v98Ev
  virtual void  v99(); // _ZN10S2120C3_nt3v99Ev
  virtual void  v100(); // _ZN10S2120C3_nt4v100Ev
  virtual void  v101(); // _ZN10S2120C3_nt4v101Ev
  virtual void  v102(); // _ZN10S2120C3_nt4v102Ev
  S2120C3_nt(); // tgen
};
//SIG(-1 S2120C3_nt) C1{ BC2{ vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fp Fi FC3{ BC4{ m Fp Fi FC5{ m} FC6{ m}}} FC3 Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 FC7{ m FC8{ m FL[2]}} FC7 FC7 FC7 FC9{ m FC7} FC10{ m FC7 FC7 FC7 FC7} FC10 FC7 FC7 FC7 Fp FC9 FC11{ m FC12{ m Fp Fi FC6} Fi} Fi Fp[7] FC13{ m Fp Fi FC14{ m} FC14} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC15{ BC16{ m Fp Fi FC17{ m} FC17}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC18{ m Fp Fi[2] FC19{ m}} Fp[2] Fi:16 Fi:16 FC15 FC18 FC20{ m Fp Fi[2] FC19} Fp[2] Fi:24 Fi:8 Fp}


 S2120C3_nt ::~S2120C3_nt(){ note_dtor("S2120C3_nt", this);}
void  S2120C3_nt ::v25(){vfunc_called(this, "_ZN10S2120C3_nt3v25Ev");}
void  S2120C3_nt ::v26(){vfunc_called(this, "_ZN10S2120C3_nt3v26Ev");}
void  S2120C3_nt ::v27(){vfunc_called(this, "_ZN10S2120C3_nt3v27Ev");}
void  S2120C3_nt ::v28(){vfunc_called(this, "_ZN10S2120C3_nt3v28Ev");}
void  S2120C3_nt ::v29(){vfunc_called(this, "_ZN10S2120C3_nt3v29Ev");}
void  S2120C3_nt ::v30(){vfunc_called(this, "_ZN10S2120C3_nt3v30Ev");}
void  S2120C3_nt ::v31(){vfunc_called(this, "_ZN10S2120C3_nt3v31Ev");}
void  S2120C3_nt ::v32(){vfunc_called(this, "_ZN10S2120C3_nt3v32Ev");}
void  S2120C3_nt ::v33(){vfunc_called(this, "_ZN10S2120C3_nt3v33Ev");}
void  S2120C3_nt ::v34(){vfunc_called(this, "_ZN10S2120C3_nt3v34Ev");}
void  S2120C3_nt ::v35(){vfunc_called(this, "_ZN10S2120C3_nt3v35Ev");}
void  S2120C3_nt ::v36(){vfunc_called(this, "_ZN10S2120C3_nt3v36Ev");}
void  S2120C3_nt ::v37(){vfunc_called(this, "_ZN10S2120C3_nt3v37Ev");}
void  S2120C3_nt ::v38(){vfunc_called(this, "_ZN10S2120C3_nt3v38Ev");}
void  S2120C3_nt ::v39(){vfunc_called(this, "_ZN10S2120C3_nt3v39Ev");}
void  S2120C3_nt ::v40(){vfunc_called(this, "_ZN10S2120C3_nt3v40Ev");}
void  S2120C3_nt ::v41(){vfunc_called(this, "_ZN10S2120C3_nt3v41Ev");}
void  S2120C3_nt ::v42(){vfunc_called(this, "_ZN10S2120C3_nt3v42Ev");}
void  S2120C3_nt ::v43(){vfunc_called(this, "_ZN10S2120C3_nt3v43Ev");}
void  S2120C3_nt ::v44(){vfunc_called(this, "_ZN10S2120C3_nt3v44Ev");}
void  S2120C3_nt ::v45(){vfunc_called(this, "_ZN10S2120C3_nt3v45Ev");}
void  S2120C3_nt ::v46(){vfunc_called(this, "_ZN10S2120C3_nt3v46Ev");}
void  S2120C3_nt ::v47(){vfunc_called(this, "_ZN10S2120C3_nt3v47Ev");}
void  S2120C3_nt ::v48(){vfunc_called(this, "_ZN10S2120C3_nt3v48Ev");}
void  S2120C3_nt ::v49(){vfunc_called(this, "_ZN10S2120C3_nt3v49Ev");}
void  S2120C3_nt ::v50(){vfunc_called(this, "_ZN10S2120C3_nt3v50Ev");}
void  S2120C3_nt ::v51(){vfunc_called(this, "_ZN10S2120C3_nt3v51Ev");}
void  S2120C3_nt ::v52(){vfunc_called(this, "_ZN10S2120C3_nt3v52Ev");}
void  S2120C3_nt ::v53(){vfunc_called(this, "_ZN10S2120C3_nt3v53Ev");}
void  S2120C3_nt ::v54(){vfunc_called(this, "_ZN10S2120C3_nt3v54Ev");}
void  S2120C3_nt ::v55(){vfunc_called(this, "_ZN10S2120C3_nt3v55Ev");}
void  S2120C3_nt ::v56(){vfunc_called(this, "_ZN10S2120C3_nt3v56Ev");}
void  S2120C3_nt ::v57(){vfunc_called(this, "_ZN10S2120C3_nt3v57Ev");}
void  S2120C3_nt ::v58(){vfunc_called(this, "_ZN10S2120C3_nt3v58Ev");}
void  S2120C3_nt ::v59(){vfunc_called(this, "_ZN10S2120C3_nt3v59Ev");}
void  S2120C3_nt ::v60(){vfunc_called(this, "_ZN10S2120C3_nt3v60Ev");}
void  S2120C3_nt ::v61(){vfunc_called(this, "_ZN10S2120C3_nt3v61Ev");}
void  S2120C3_nt ::v62(){vfunc_called(this, "_ZN10S2120C3_nt3v62Ev");}
void  S2120C3_nt ::v63(){vfunc_called(this, "_ZN10S2120C3_nt3v63Ev");}
void  S2120C3_nt ::v64(){vfunc_called(this, "_ZN10S2120C3_nt3v64Ev");}
void  S2120C3_nt ::v65(){vfunc_called(this, "_ZN10S2120C3_nt3v65Ev");}
void  S2120C3_nt ::v66(){vfunc_called(this, "_ZN10S2120C3_nt3v66Ev");}
void  S2120C3_nt ::v67(){vfunc_called(this, "_ZN10S2120C3_nt3v67Ev");}
void  S2120C3_nt ::v68(){vfunc_called(this, "_ZN10S2120C3_nt3v68Ev");}
void  S2120C3_nt ::v69(){vfunc_called(this, "_ZN10S2120C3_nt3v69Ev");}
void  S2120C3_nt ::v70(){vfunc_called(this, "_ZN10S2120C3_nt3v70Ev");}
void  S2120C3_nt ::v71(){vfunc_called(this, "_ZN10S2120C3_nt3v71Ev");}
void  S2120C3_nt ::v72(){vfunc_called(this, "_ZN10S2120C3_nt3v72Ev");}
void  S2120C3_nt ::v73(){vfunc_called(this, "_ZN10S2120C3_nt3v73Ev");}
void  S2120C3_nt ::v74(){vfunc_called(this, "_ZN10S2120C3_nt3v74Ev");}
void  S2120C3_nt ::v75(){vfunc_called(this, "_ZN10S2120C3_nt3v75Ev");}
void  S2120C3_nt ::v76(){vfunc_called(this, "_ZN10S2120C3_nt3v76Ev");}
void  S2120C3_nt ::v77(){vfunc_called(this, "_ZN10S2120C3_nt3v77Ev");}
void  S2120C3_nt ::v78(){vfunc_called(this, "_ZN10S2120C3_nt3v78Ev");}
void  S2120C3_nt ::v79(){vfunc_called(this, "_ZN10S2120C3_nt3v79Ev");}
void  S2120C3_nt ::v80(){vfunc_called(this, "_ZN10S2120C3_nt3v80Ev");}
void  S2120C3_nt ::v81(){vfunc_called(this, "_ZN10S2120C3_nt3v81Ev");}
void  S2120C3_nt ::v82(){vfunc_called(this, "_ZN10S2120C3_nt3v82Ev");}
void  S2120C3_nt ::v83(){vfunc_called(this, "_ZN10S2120C3_nt3v83Ev");}
void  S2120C3_nt ::v84(){vfunc_called(this, "_ZN10S2120C3_nt3v84Ev");}
void  S2120C3_nt ::v85(){vfunc_called(this, "_ZN10S2120C3_nt3v85Ev");}
void  S2120C3_nt ::v86(){vfunc_called(this, "_ZN10S2120C3_nt3v86Ev");}
void  S2120C3_nt ::v87(){vfunc_called(this, "_ZN10S2120C3_nt3v87Ev");}
void  S2120C3_nt ::v88(){vfunc_called(this, "_ZN10S2120C3_nt3v88Ev");}
void  S2120C3_nt ::v89(){vfunc_called(this, "_ZN10S2120C3_nt3v89Ev");}
void  S2120C3_nt ::v90(){vfunc_called(this, "_ZN10S2120C3_nt3v90Ev");}
void  S2120C3_nt ::v91(){vfunc_called(this, "_ZN10S2120C3_nt3v91Ev");}
void  S2120C3_nt ::v92(){vfunc_called(this, "_ZN10S2120C3_nt3v92Ev");}
void  S2120C3_nt ::v93(){vfunc_called(this, "_ZN10S2120C3_nt3v93Ev");}
void  S2120C3_nt ::v94(){vfunc_called(this, "_ZN10S2120C3_nt3v94Ev");}
void  S2120C3_nt ::v95(){vfunc_called(this, "_ZN10S2120C3_nt3v95Ev");}
void  S2120C3_nt ::v96(){vfunc_called(this, "_ZN10S2120C3_nt3v96Ev");}
void  S2120C3_nt ::v97(){vfunc_called(this, "_ZN10S2120C3_nt3v97Ev");}
void  S2120C3_nt ::v98(){vfunc_called(this, "_ZN10S2120C3_nt3v98Ev");}
void  S2120C3_nt ::v99(){vfunc_called(this, "_ZN10S2120C3_nt3v99Ev");}
void  S2120C3_nt ::v100(){vfunc_called(this, "_ZN10S2120C3_nt4v100Ev");}
void  S2120C3_nt ::v101(){vfunc_called(this, "_ZN10S2120C3_nt4v101Ev");}
void  S2120C3_nt ::v102(){vfunc_called(this, "_ZN10S2120C3_nt4v102Ev");}
S2120C3_nt ::S2120C3_nt(){ note_ctor("S2120C3_nt", this);} // tgen

//skip512 S2120C3_nt

#else // __cplusplus

extern void _ZN10S2120C3_ntC1Ev();
extern void _ZN10S2120C3_ntD1Ev();
Name_Map name_map_S2120C3_nt[] = {
  NSPAIR(_ZN10S2120C3_ntC1Ev),
  NSPAIR(_ZN10S2120C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2120C4_nt;
extern VTBL_ENTRY _ZTI10S2120C4_nt[];
extern  VTBL_ENTRY _ZTV10S2120C4_nt[];
static Base_Class bases_S2120C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2120C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S2120C3_nt[];
extern void _ZN10S2120C3_ntD1Ev();
extern void _ZN10S2120C3_ntD0Ev();
extern void _ZN10S2120C4_nt2v2Ev();
extern void _ZN10S2120C4_nt2v3Ev();
extern void _ZN10S2120C4_nt2v4Ev();
extern void _ZN10S2120C4_nt2v5Ev();
extern void _ZN10S2120C4_nt2v6Ev();
extern void _ZN10S2120C4_nt2v7Ev();
extern void _ZN10S2120C4_nt2v8Ev();
extern void _ZN10S2120C4_nt2v9Ev();
extern void _ZN10S2120C4_nt3v10Ev();
extern void _ZN10S2120C4_nt3v11Ev();
extern void _ZN10S2120C4_nt3v12Ev();
extern void _ZN10S2120C4_nt3v13Ev();
extern void _ZN10S2120C4_nt3v14Ev();
extern void _ZN10S2120C4_nt3v15Ev();
extern void _ZN10S2120C4_nt3v16Ev();
extern void _ZN10S2120C4_nt3v17Ev();
extern void _ZN10S2120C4_nt3v18Ev();
extern void _ZN10S2120C4_nt3v19Ev();
extern void _ZN10S2120C4_nt3v20Ev();
extern void _ZN10S2120C4_nt3v21Ev();
extern void _ZN10S2120C4_nt3v22Ev();
extern void _ZN10S2120C4_nt3v23Ev();
extern void _ZN10S2120C4_nt3v24Ev();
extern void _ZN10S2120C3_nt3v25Ev();
extern void _ZN10S2120C3_nt3v26Ev();
extern void _ZN10S2120C3_nt3v27Ev();
extern void _ZN10S2120C3_nt3v28Ev();
extern void _ZN10S2120C3_nt3v29Ev();
extern void _ZN10S2120C3_nt3v30Ev();
extern void _ZN10S2120C3_nt3v31Ev();
extern void _ZN10S2120C3_nt3v32Ev();
extern void _ZN10S2120C3_nt3v33Ev();
extern void _ZN10S2120C3_nt3v34Ev();
extern void _ZN10S2120C3_nt3v35Ev();
extern void _ZN10S2120C3_nt3v36Ev();
extern void _ZN10S2120C3_nt3v37Ev();
extern void _ZN10S2120C3_nt3v38Ev();
extern void _ZN10S2120C3_nt3v39Ev();
extern void _ZN10S2120C3_nt3v40Ev();
extern void _ZN10S2120C3_nt3v41Ev();
extern void _ZN10S2120C3_nt3v42Ev();
extern void _ZN10S2120C3_nt3v43Ev();
extern void _ZN10S2120C3_nt3v44Ev();
extern void _ZN10S2120C3_nt3v45Ev();
extern void _ZN10S2120C3_nt3v46Ev();
extern void _ZN10S2120C3_nt3v47Ev();
extern void _ZN10S2120C3_nt3v48Ev();
extern void _ZN10S2120C3_nt3v49Ev();
extern void _ZN10S2120C3_nt3v50Ev();
extern void _ZN10S2120C3_nt3v51Ev();
extern void _ZN10S2120C3_nt3v52Ev();
extern void _ZN10S2120C3_nt3v53Ev();
extern void _ZN10S2120C3_nt3v54Ev();
extern void _ZN10S2120C3_nt3v55Ev();
extern void _ZN10S2120C3_nt3v56Ev();
extern void _ZN10S2120C3_nt3v57Ev();
extern void _ZN10S2120C3_nt3v58Ev();
extern void _ZN10S2120C3_nt3v59Ev();
extern void _ZN10S2120C3_nt3v60Ev();
extern void _ZN10S2120C3_nt3v61Ev();
extern void _ZN10S2120C3_nt3v62Ev();
extern void _ZN10S2120C3_nt3v63Ev();
extern void _ZN10S2120C3_nt3v64Ev();
extern void _ZN10S2120C3_nt3v65Ev();
extern void _ZN10S2120C3_nt3v66Ev();
extern void _ZN10S2120C3_nt3v67Ev();
extern void _ZN10S2120C3_nt3v68Ev();
extern void _ZN10S2120C3_nt3v69Ev();
extern void _ZN10S2120C3_nt3v70Ev();
extern void _ZN10S2120C3_nt3v71Ev();
extern void _ZN10S2120C3_nt3v72Ev();
extern void _ZN10S2120C3_nt3v73Ev();
extern void _ZN10S2120C3_nt3v74Ev();
extern void _ZN10S2120C3_nt3v75Ev();
extern void _ZN10S2120C3_nt3v76Ev();
extern void _ZN10S2120C3_nt3v77Ev();
extern void _ZN10S2120C3_nt3v78Ev();
extern void _ZN10S2120C3_nt3v79Ev();
extern void _ZN10S2120C3_nt3v80Ev();
extern void _ZN10S2120C3_nt3v81Ev();
extern void _ZN10S2120C3_nt3v82Ev();
extern void _ZN10S2120C3_nt3v83Ev();
extern void _ZN10S2120C3_nt3v84Ev();
extern void _ZN10S2120C3_nt3v85Ev();
extern void _ZN10S2120C3_nt3v86Ev();
extern void _ZN10S2120C3_nt3v87Ev();
extern void _ZN10S2120C3_nt3v88Ev();
extern void _ZN10S2120C3_nt3v89Ev();
extern void _ZN10S2120C3_nt3v90Ev();
extern void _ZN10S2120C3_nt3v91Ev();
extern void _ZN10S2120C3_nt3v92Ev();
extern void _ZN10S2120C3_nt3v93Ev();
extern void _ZN10S2120C3_nt3v94Ev();
extern void _ZN10S2120C3_nt3v95Ev();
extern void _ZN10S2120C3_nt3v96Ev();
extern void _ZN10S2120C3_nt3v97Ev();
extern void _ZN10S2120C3_nt3v98Ev();
extern void _ZN10S2120C3_nt3v99Ev();
extern void _ZN10S2120C3_nt4v100Ev();
extern void _ZN10S2120C3_nt4v101Ev();
extern void _ZN10S2120C3_nt4v102Ev();
static  VTBL_ENTRY vtc_S2120C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2120C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S2120C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v2Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt4v102Ev,
};
extern VTBL_ENTRY _ZTI10S2120C3_nt[];
VTBL_ENTRY *P__ZTI10S2120C3_nt = _ZTI10S2120C3_nt; 
extern  VTBL_ENTRY _ZTV10S2120C3_nt[];
Class_Descriptor cd_S2120C3_nt = {  "S2120C3_nt", // class name
  bases_S2120C3_nt, 1,
  &(vtc_S2120C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(832,632), // object size
  NSPAIRA(_ZTI10S2120C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S2120C3_nt),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2120C2_nt  : S2120C3_nt {
  void *s2120c2f0;
  virtual  ~S2120C2_nt(); // _ZN10S2120C2_ntD1Ev
  virtual void  v103(); // _ZN10S2120C2_nt4v103Ev
  virtual void  v104(); // _ZN10S2120C2_nt4v104Ev
  virtual void  v105(); // _ZN10S2120C2_nt4v105Ev
  virtual void  v106(); // _ZN10S2120C2_nt4v106Ev
  virtual void  v107(); // _ZN10S2120C2_nt4v107Ev
  virtual void  v108(); // _ZN10S2120C2_nt4v108Ev
  virtual void  v109(); // _ZN10S2120C2_nt4v109Ev
  virtual void  v110(); // _ZN10S2120C2_nt4v110Ev
  virtual void  v111(); // _ZN10S2120C2_nt4v111Ev
  virtual void  v112(); // _ZN10S2120C2_nt4v112Ev
  S2120C2_nt(); // tgen
};
//SIG(-1 S2120C2_nt) C1{ BC2{ BC3{ vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 Fp Fi FC4{ BC5{ m Fp Fi FC6{ m} FC7{ m}}} FC4 Fi} vd v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8 FC10{ m FC8} FC11{ m FC8 FC8 FC8 FC8} FC11 FC8 FC8 FC8 Fp FC10 FC12{ m FC13{ m Fp Fi FC7} Fi} Fi Fp[7] FC14{ m Fp Fi FC15{ m} FC15} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC16{ BC17{ m Fp Fi FC18{ m} FC18}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC19{ m Fp Fi[2] FC20{ m}} Fp[2] Fi:16 Fi:16 FC16 FC19 FC21{ m Fp Fi[2] FC20} Fp[2] Fi:24 Fi:8 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp}


 S2120C2_nt ::~S2120C2_nt(){ note_dtor("S2120C2_nt", this);}
void  S2120C2_nt ::v103(){vfunc_called(this, "_ZN10S2120C2_nt4v103Ev");}
void  S2120C2_nt ::v104(){vfunc_called(this, "_ZN10S2120C2_nt4v104Ev");}
void  S2120C2_nt ::v105(){vfunc_called(this, "_ZN10S2120C2_nt4v105Ev");}
void  S2120C2_nt ::v106(){vfunc_called(this, "_ZN10S2120C2_nt4v106Ev");}
void  S2120C2_nt ::v107(){vfunc_called(this, "_ZN10S2120C2_nt4v107Ev");}
void  S2120C2_nt ::v108(){vfunc_called(this, "_ZN10S2120C2_nt4v108Ev");}
void  S2120C2_nt ::v109(){vfunc_called(this, "_ZN10S2120C2_nt4v109Ev");}
void  S2120C2_nt ::v110(){vfunc_called(this, "_ZN10S2120C2_nt4v110Ev");}
void  S2120C2_nt ::v111(){vfunc_called(this, "_ZN10S2120C2_nt4v111Ev");}
void  S2120C2_nt ::v112(){vfunc_called(this, "_ZN10S2120C2_nt4v112Ev");}
S2120C2_nt ::S2120C2_nt(){ note_ctor("S2120C2_nt", this);} // tgen

//skip512 S2120C2_nt

#else // __cplusplus

extern void _ZN10S2120C2_ntC1Ev();
extern void _ZN10S2120C2_ntD1Ev();
Name_Map name_map_S2120C2_nt[] = {
  NSPAIR(_ZN10S2120C2_ntC1Ev),
  NSPAIR(_ZN10S2120C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2120C4_nt;
extern VTBL_ENTRY _ZTI10S2120C4_nt[];
extern  VTBL_ENTRY _ZTV10S2120C4_nt[];
extern Class_Descriptor cd_S2120C3_nt;
extern VTBL_ENTRY _ZTI10S2120C3_nt[];
extern  VTBL_ENTRY _ZTV10S2120C3_nt[];
static Base_Class bases_S2120C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2120C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2120C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S2120C2_nt[];
extern void _ZN10S2120C2_ntD1Ev();
extern void _ZN10S2120C2_ntD0Ev();
extern void _ZN10S2120C4_nt2v2Ev();
extern void _ZN10S2120C4_nt2v3Ev();
extern void _ZN10S2120C4_nt2v4Ev();
extern void _ZN10S2120C4_nt2v5Ev();
extern void _ZN10S2120C4_nt2v6Ev();
extern void _ZN10S2120C4_nt2v7Ev();
extern void _ZN10S2120C4_nt2v8Ev();
extern void _ZN10S2120C4_nt2v9Ev();
extern void _ZN10S2120C4_nt3v10Ev();
extern void _ZN10S2120C4_nt3v11Ev();
extern void _ZN10S2120C4_nt3v12Ev();
extern void _ZN10S2120C4_nt3v13Ev();
extern void _ZN10S2120C4_nt3v14Ev();
extern void _ZN10S2120C4_nt3v15Ev();
extern void _ZN10S2120C4_nt3v16Ev();
extern void _ZN10S2120C4_nt3v17Ev();
extern void _ZN10S2120C4_nt3v18Ev();
extern void _ZN10S2120C4_nt3v19Ev();
extern void _ZN10S2120C4_nt3v20Ev();
extern void _ZN10S2120C4_nt3v21Ev();
extern void _ZN10S2120C4_nt3v22Ev();
extern void _ZN10S2120C4_nt3v23Ev();
extern void _ZN10S2120C4_nt3v24Ev();
extern void _ZN10S2120C3_nt3v25Ev();
extern void _ZN10S2120C3_nt3v26Ev();
extern void _ZN10S2120C3_nt3v27Ev();
extern void _ZN10S2120C3_nt3v28Ev();
extern void _ZN10S2120C3_nt3v29Ev();
extern void _ZN10S2120C3_nt3v30Ev();
extern void _ZN10S2120C3_nt3v31Ev();
extern void _ZN10S2120C3_nt3v32Ev();
extern void _ZN10S2120C3_nt3v33Ev();
extern void _ZN10S2120C3_nt3v34Ev();
extern void _ZN10S2120C3_nt3v35Ev();
extern void _ZN10S2120C3_nt3v36Ev();
extern void _ZN10S2120C3_nt3v37Ev();
extern void _ZN10S2120C3_nt3v38Ev();
extern void _ZN10S2120C3_nt3v39Ev();
extern void _ZN10S2120C3_nt3v40Ev();
extern void _ZN10S2120C3_nt3v41Ev();
extern void _ZN10S2120C3_nt3v42Ev();
extern void _ZN10S2120C3_nt3v43Ev();
extern void _ZN10S2120C3_nt3v44Ev();
extern void _ZN10S2120C3_nt3v45Ev();
extern void _ZN10S2120C3_nt3v46Ev();
extern void _ZN10S2120C3_nt3v47Ev();
extern void _ZN10S2120C3_nt3v48Ev();
extern void _ZN10S2120C3_nt3v49Ev();
extern void _ZN10S2120C3_nt3v50Ev();
extern void _ZN10S2120C3_nt3v51Ev();
extern void _ZN10S2120C3_nt3v52Ev();
extern void _ZN10S2120C3_nt3v53Ev();
extern void _ZN10S2120C3_nt3v54Ev();
extern void _ZN10S2120C3_nt3v55Ev();
extern void _ZN10S2120C3_nt3v56Ev();
extern void _ZN10S2120C3_nt3v57Ev();
extern void _ZN10S2120C3_nt3v58Ev();
extern void _ZN10S2120C3_nt3v59Ev();
extern void _ZN10S2120C3_nt3v60Ev();
extern void _ZN10S2120C3_nt3v61Ev();
extern void _ZN10S2120C3_nt3v62Ev();
extern void _ZN10S2120C3_nt3v63Ev();
extern void _ZN10S2120C3_nt3v64Ev();
extern void _ZN10S2120C3_nt3v65Ev();
extern void _ZN10S2120C3_nt3v66Ev();
extern void _ZN10S2120C3_nt3v67Ev();
extern void _ZN10S2120C3_nt3v68Ev();
extern void _ZN10S2120C3_nt3v69Ev();
extern void _ZN10S2120C3_nt3v70Ev();
extern void _ZN10S2120C3_nt3v71Ev();
extern void _ZN10S2120C3_nt3v72Ev();
extern void _ZN10S2120C3_nt3v73Ev();
extern void _ZN10S2120C3_nt3v74Ev();
extern void _ZN10S2120C3_nt3v75Ev();
extern void _ZN10S2120C3_nt3v76Ev();
extern void _ZN10S2120C3_nt3v77Ev();
extern void _ZN10S2120C3_nt3v78Ev();
extern void _ZN10S2120C3_nt3v79Ev();
extern void _ZN10S2120C3_nt3v80Ev();
extern void _ZN10S2120C3_nt3v81Ev();
extern void _ZN10S2120C3_nt3v82Ev();
extern void _ZN10S2120C3_nt3v83Ev();
extern void _ZN10S2120C3_nt3v84Ev();
extern void _ZN10S2120C3_nt3v85Ev();
extern void _ZN10S2120C3_nt3v86Ev();
extern void _ZN10S2120C3_nt3v87Ev();
extern void _ZN10S2120C3_nt3v88Ev();
extern void _ZN10S2120C3_nt3v89Ev();
extern void _ZN10S2120C3_nt3v90Ev();
extern void _ZN10S2120C3_nt3v91Ev();
extern void _ZN10S2120C3_nt3v92Ev();
extern void _ZN10S2120C3_nt3v93Ev();
extern void _ZN10S2120C3_nt3v94Ev();
extern void _ZN10S2120C3_nt3v95Ev();
extern void _ZN10S2120C3_nt3v96Ev();
extern void _ZN10S2120C3_nt3v97Ev();
extern void _ZN10S2120C3_nt3v98Ev();
extern void _ZN10S2120C3_nt3v99Ev();
extern void _ZN10S2120C3_nt4v100Ev();
extern void _ZN10S2120C3_nt4v101Ev();
extern void _ZN10S2120C3_nt4v102Ev();
extern void _ZN10S2120C2_nt4v103Ev();
extern void _ZN10S2120C2_nt4v104Ev();
extern void _ZN10S2120C2_nt4v105Ev();
extern void _ZN10S2120C2_nt4v106Ev();
extern void _ZN10S2120C2_nt4v107Ev();
extern void _ZN10S2120C2_nt4v108Ev();
extern void _ZN10S2120C2_nt4v109Ev();
extern void _ZN10S2120C2_nt4v110Ev();
extern void _ZN10S2120C2_nt4v111Ev();
extern void _ZN10S2120C2_nt4v112Ev();
static  VTBL_ENTRY vtc_S2120C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2120C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S2120C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2120C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v2Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S2120C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S2120C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S2120C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S2120C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S2120C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S2120C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S2120C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S2120C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S2120C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S2120C2_nt4v112Ev,
};
extern VTBL_ENTRY _ZTI10S2120C2_nt[];
VTBL_ENTRY *P__ZTI10S2120C2_nt = _ZTI10S2120C2_nt; 
extern  VTBL_ENTRY _ZTV10S2120C2_nt[];
Class_Descriptor cd_S2120C2_nt = {  "S2120C2_nt", // class name
  bases_S2120C2_nt, 2,
  &(vtc_S2120C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(840,636), // object size
  NSPAIRA(_ZTI10S2120C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S2120C2_nt),115, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2120C39  {
  unsigned char s2120c39f0:1;
  unsigned char s2120c39f1:1;
  virtual  ~S2120C39(); // _ZN8S2120C39D1Ev
  virtual void  v113(); // _ZN8S2120C394v113Ev
  virtual void  v114(); // _ZN8S2120C394v114Ev
  S2120C39(); // tgen
};
//SIG(-1 S2120C39) C1{ vd v1 v2 Fc:1 Fc:1}


 S2120C39 ::~S2120C39(){ note_dtor("S2120C39", this);}
void  S2120C39 ::v113(){vfunc_called(this, "_ZN8S2120C394v113Ev");}
void  S2120C39 ::v114(){vfunc_called(this, "_ZN8S2120C394v114Ev");}
S2120C39 ::S2120C39(){ note_ctor("S2120C39", this);} // tgen

static void Test_S2120C39()
{
  extern Class_Descriptor cd_S2120C39;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S2120C39, buf);
    S2120C39 *dp, &lv = *(dp=new (buf) S2120C39());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S2120C39)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2120C39)");
    set_bf_and_test(lv, s2120c39f0, ABISELECT(8,4), 0, 1, 1, "S2120C39");
    set_bf_and_test(lv, s2120c39f1, ABISELECT(8,4), 1, 1, 1, "S2120C39");
    test_class_info(&lv, &cd_S2120C39);
    dp->~S2120C39();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2120C39(Test_S2120C39, "S2120C39", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN8S2120C39C1Ev();
extern void _ZN8S2120C39D1Ev();
Name_Map name_map_S2120C39[] = {
  NSPAIR(_ZN8S2120C39C1Ev),
  NSPAIR(_ZN8S2120C39D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2120C39[];
extern void _ZN8S2120C39D1Ev();
extern void _ZN8S2120C39D0Ev();
extern void _ZN8S2120C394v113Ev();
extern void _ZN8S2120C394v114Ev();
static  VTBL_ENTRY vtc_S2120C39[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2120C39[0]),
  (VTBL_ENTRY)&_ZN8S2120C39D1Ev,
  (VTBL_ENTRY)&_ZN8S2120C39D0Ev,
  (VTBL_ENTRY)&_ZN8S2120C394v113Ev,
  (VTBL_ENTRY)&_ZN8S2120C394v114Ev,
};
extern VTBL_ENTRY _ZTI8S2120C39[];
extern  VTBL_ENTRY _ZTV8S2120C39[];
Class_Descriptor cd_S2120C39 = {  "S2120C39", // class name
  0,0,//no base classes
  &(vtc_S2120C39[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI8S2120C39),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2120C39),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2120C1  : S2120C2_nt , S2120C39 {
  void *s2120c1f0[2];
  int s2120c1f1;
  virtual  ~S2120C1(); // _ZN7S2120C1D1Ev
  virtual void  v1(); // _ZN7S2120C12v1Ev
  S2120C1(); // tgen
};
//SIG(1 S2120C1) C1{ BC2{ BC3{ BC4{ vd v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp Fi FC5{ BC6{ m Fp Fi FC7{ m} FC8{ m}}} FC5 Fi} vd v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 FC9{ m FC10{ m FL[2]}} FC9 FC9 FC9 FC11{ m FC9} FC12{ m FC9 FC9 FC9 FC9} FC12 FC9 FC9 FC9 Fp FC11 FC13{ m FC14{ m Fp Fi FC8} Fi} Fi Fp[7] FC15{ m Fp Fi FC16{ m} FC16} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC17{ BC18{ m Fp Fi FC19{ m} FC19}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC20{ m Fp Fi[2] FC21{ m}} Fp[2] Fi:16 Fi:16 FC17 FC20 FC22{ m Fp Fi[2] FC21} Fp[2] Fi:24 Fi:8 Fp} vd v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 Fp} BC23{ vd v113 v114 Fc:1 Fc:1} vd v1 Fp[2] Fi}


 S2120C1 ::~S2120C1(){ note_dtor("S2120C1", this);}
void  S2120C1 ::v1(){vfunc_called(this, "_ZN7S2120C12v1Ev");}
S2120C1 ::S2120C1(){ note_ctor("S2120C1", this);} // tgen

static void Test_S2120C1()
{
  extern Class_Descriptor cd_S2120C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(111,165)];
    init_test(&cd_S2120C1, buf);
    S2120C1 *dp, &lv = *(dp=new (buf) S2120C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(880,656), "sizeof(S2120C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2120C1)");
    check_base_class_offset(lv, (S2120C4_nt*)(S2120C3_nt*)(S2120C2_nt*), 0, "S2120C1");
    check_base_class_offset(lv, (S2120C3_nt*)(S2120C2_nt*), 0, "S2120C1");
    check_base_class_offset(lv, (S2120C2_nt*), 0, "S2120C1");
    check_base_class_offset(lv, (S2120C39*), ABISELECT(840,636), "S2120C1");
    check_field_offset(lv, s2120c1f0, ABISELECT(856,644), "S2120C1.s2120c1f0");
    check_field_offset(lv, s2120c1f1, ABISELECT(872,652), "S2120C1.s2120c1f1");
    test_class_info(&lv, &cd_S2120C1);
    dp->~S2120C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2120C1(Test_S2120C1, "S2120C1", ABISELECT(880,656));

#else // __cplusplus

extern void _ZN7S2120C1C1Ev();
extern void _ZN7S2120C1D1Ev();
Name_Map name_map_S2120C1[] = {
  NSPAIR(_ZN7S2120C1C1Ev),
  NSPAIR(_ZN7S2120C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2120C4_nt;
extern VTBL_ENTRY _ZTI10S2120C4_nt[];
extern  VTBL_ENTRY _ZTV10S2120C4_nt[];
extern Class_Descriptor cd_S2120C3_nt;
extern VTBL_ENTRY _ZTI10S2120C3_nt[];
extern  VTBL_ENTRY _ZTV10S2120C3_nt[];
extern Class_Descriptor cd_S2120C2_nt;
extern VTBL_ENTRY _ZTI10S2120C2_nt[];
extern  VTBL_ENTRY _ZTV10S2120C2_nt[];
extern Class_Descriptor cd_S2120C39;
extern VTBL_ENTRY _ZTI8S2120C39[];
extern  VTBL_ENTRY _ZTV8S2120C39[];
static Base_Class bases_S2120C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2120C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2120C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2120C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2120C39,    ABISELECT(840,636), //bcp->offset
    116, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2120C1[];
extern void _ZN7S2120C1D1Ev();
extern void _ZN7S2120C1D0Ev();
extern void _ZN10S2120C4_nt2v2Ev();
extern void _ZN10S2120C4_nt2v3Ev();
extern void _ZN10S2120C4_nt2v4Ev();
extern void _ZN10S2120C4_nt2v5Ev();
extern void _ZN10S2120C4_nt2v6Ev();
extern void _ZN10S2120C4_nt2v7Ev();
extern void _ZN10S2120C4_nt2v8Ev();
extern void _ZN10S2120C4_nt2v9Ev();
extern void _ZN10S2120C4_nt3v10Ev();
extern void _ZN10S2120C4_nt3v11Ev();
extern void _ZN10S2120C4_nt3v12Ev();
extern void _ZN10S2120C4_nt3v13Ev();
extern void _ZN10S2120C4_nt3v14Ev();
extern void _ZN10S2120C4_nt3v15Ev();
extern void _ZN10S2120C4_nt3v16Ev();
extern void _ZN10S2120C4_nt3v17Ev();
extern void _ZN10S2120C4_nt3v18Ev();
extern void _ZN10S2120C4_nt3v19Ev();
extern void _ZN10S2120C4_nt3v20Ev();
extern void _ZN10S2120C4_nt3v21Ev();
extern void _ZN10S2120C4_nt3v22Ev();
extern void _ZN10S2120C4_nt3v23Ev();
extern void _ZN10S2120C4_nt3v24Ev();
extern void _ZN10S2120C3_nt3v25Ev();
extern void _ZN10S2120C3_nt3v26Ev();
extern void _ZN10S2120C3_nt3v27Ev();
extern void _ZN10S2120C3_nt3v28Ev();
extern void _ZN10S2120C3_nt3v29Ev();
extern void _ZN10S2120C3_nt3v30Ev();
extern void _ZN10S2120C3_nt3v31Ev();
extern void _ZN10S2120C3_nt3v32Ev();
extern void _ZN10S2120C3_nt3v33Ev();
extern void _ZN10S2120C3_nt3v34Ev();
extern void _ZN10S2120C3_nt3v35Ev();
extern void _ZN10S2120C3_nt3v36Ev();
extern void _ZN10S2120C3_nt3v37Ev();
extern void _ZN10S2120C3_nt3v38Ev();
extern void _ZN10S2120C3_nt3v39Ev();
extern void _ZN10S2120C3_nt3v40Ev();
extern void _ZN10S2120C3_nt3v41Ev();
extern void _ZN10S2120C3_nt3v42Ev();
extern void _ZN10S2120C3_nt3v43Ev();
extern void _ZN10S2120C3_nt3v44Ev();
extern void _ZN10S2120C3_nt3v45Ev();
extern void _ZN10S2120C3_nt3v46Ev();
extern void _ZN10S2120C3_nt3v47Ev();
extern void _ZN10S2120C3_nt3v48Ev();
extern void _ZN10S2120C3_nt3v49Ev();
extern void _ZN10S2120C3_nt3v50Ev();
extern void _ZN10S2120C3_nt3v51Ev();
extern void _ZN10S2120C3_nt3v52Ev();
extern void _ZN10S2120C3_nt3v53Ev();
extern void _ZN10S2120C3_nt3v54Ev();
extern void _ZN10S2120C3_nt3v55Ev();
extern void _ZN10S2120C3_nt3v56Ev();
extern void _ZN10S2120C3_nt3v57Ev();
extern void _ZN10S2120C3_nt3v58Ev();
extern void _ZN10S2120C3_nt3v59Ev();
extern void _ZN10S2120C3_nt3v60Ev();
extern void _ZN10S2120C3_nt3v61Ev();
extern void _ZN10S2120C3_nt3v62Ev();
extern void _ZN10S2120C3_nt3v63Ev();
extern void _ZN10S2120C3_nt3v64Ev();
extern void _ZN10S2120C3_nt3v65Ev();
extern void _ZN10S2120C3_nt3v66Ev();
extern void _ZN10S2120C3_nt3v67Ev();
extern void _ZN10S2120C3_nt3v68Ev();
extern void _ZN10S2120C3_nt3v69Ev();
extern void _ZN10S2120C3_nt3v70Ev();
extern void _ZN10S2120C3_nt3v71Ev();
extern void _ZN10S2120C3_nt3v72Ev();
extern void _ZN10S2120C3_nt3v73Ev();
extern void _ZN10S2120C3_nt3v74Ev();
extern void _ZN10S2120C3_nt3v75Ev();
extern void _ZN10S2120C3_nt3v76Ev();
extern void _ZN10S2120C3_nt3v77Ev();
extern void _ZN10S2120C3_nt3v78Ev();
extern void _ZN10S2120C3_nt3v79Ev();
extern void _ZN10S2120C3_nt3v80Ev();
extern void _ZN10S2120C3_nt3v81Ev();
extern void _ZN10S2120C3_nt3v82Ev();
extern void _ZN10S2120C3_nt3v83Ev();
extern void _ZN10S2120C3_nt3v84Ev();
extern void _ZN10S2120C3_nt3v85Ev();
extern void _ZN10S2120C3_nt3v86Ev();
extern void _ZN10S2120C3_nt3v87Ev();
extern void _ZN10S2120C3_nt3v88Ev();
extern void _ZN10S2120C3_nt3v89Ev();
extern void _ZN10S2120C3_nt3v90Ev();
extern void _ZN10S2120C3_nt3v91Ev();
extern void _ZN10S2120C3_nt3v92Ev();
extern void _ZN10S2120C3_nt3v93Ev();
extern void _ZN10S2120C3_nt3v94Ev();
extern void _ZN10S2120C3_nt3v95Ev();
extern void _ZN10S2120C3_nt3v96Ev();
extern void _ZN10S2120C3_nt3v97Ev();
extern void _ZN10S2120C3_nt3v98Ev();
extern void _ZN10S2120C3_nt3v99Ev();
extern void _ZN10S2120C3_nt4v100Ev();
extern void _ZN10S2120C3_nt4v101Ev();
extern void _ZN10S2120C3_nt4v102Ev();
extern void _ZN10S2120C2_nt4v103Ev();
extern void _ZN10S2120C2_nt4v104Ev();
extern void _ZN10S2120C2_nt4v105Ev();
extern void _ZN10S2120C2_nt4v106Ev();
extern void _ZN10S2120C2_nt4v107Ev();
extern void _ZN10S2120C2_nt4v108Ev();
extern void _ZN10S2120C2_nt4v109Ev();
extern void _ZN10S2120C2_nt4v110Ev();
extern void _ZN10S2120C2_nt4v111Ev();
extern void _ZN10S2120C2_nt4v112Ev();
extern void _ZN7S2120C12v1Ev();
extern void ABISELECT(_ZThn840_N7S2120C1D1Ev,_ZThn636_N7S2120C1D1Ev)();
extern void ABISELECT(_ZThn840_N7S2120C1D0Ev,_ZThn636_N7S2120C1D0Ev)();
extern void _ZN8S2120C394v113Ev();
extern void _ZN8S2120C394v114Ev();
static  VTBL_ENTRY vtc_S2120C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2120C1[0]),
  (VTBL_ENTRY)&_ZN7S2120C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2120C1D0Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v2Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2120C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S2120C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S2120C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S2120C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S2120C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S2120C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S2120C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S2120C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S2120C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S2120C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S2120C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S2120C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN7S2120C12v1Ev,
  ABISELECT(-840,-636),
  (VTBL_ENTRY)&(_ZTI7S2120C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn840_N7S2120C1D1Ev,_ZThn636_N7S2120C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn840_N7S2120C1D0Ev,_ZThn636_N7S2120C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2120C394v113Ev,
  (VTBL_ENTRY)&_ZN8S2120C394v114Ev,
};
extern VTBL_ENTRY _ZTI7S2120C1[];
extern  VTBL_ENTRY _ZTV7S2120C1[];
Class_Descriptor cd_S2120C1 = {  "S2120C1", // class name
  bases_S2120C1, 4,
  &(vtc_S2120C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(880,656), // object size
  NSPAIRA(_ZTI7S2120C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2120C1),122, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C9  {
  int s601c9f0:4;
  int s601c9f1:4;
  int s601c9f2:4;
  int s601c9f3:2;
  unsigned int s601c9f4:1;
  int s601c9f5:17;
};
//SIG(1 S601C9) C1{ Fi:4 Fi:4 Fi:4 Fi:2 Fi:1 Fi:17}



static void Test_S601C9()
{
  {
    init_simple_test("S601C9");
    static S601C9 lv;
    check2(sizeof(lv), 4, "sizeof(S601C9)");
    check2(__alignof__(lv), 4, "__alignof__(S601C9)");
    set_bf_and_test(lv, s601c9f0, 0, 0, 4, 1, "S601C9");
    set_bf_and_test(lv, s601c9f0, 0, 0, 4, hide_sll(1LL<<3), "S601C9");
    set_bf_and_test(lv, s601c9f1, 0, 4, 4, 1, "S601C9");
    set_bf_and_test(lv, s601c9f1, 0, 4, 4, hide_sll(1LL<<3), "S601C9");
    set_bf_and_test(lv, s601c9f2, 1, 0, 4, 1, "S601C9");
    set_bf_and_test(lv, s601c9f2, 1, 0, 4, hide_sll(1LL<<3), "S601C9");
    set_bf_and_test(lv, s601c9f3, 1, 4, 2, 1, "S601C9");
    set_bf_and_test(lv, s601c9f3, 1, 4, 2, hide_sll(1LL<<1), "S601C9");
    set_bf_and_test(lv, s601c9f4, 1, 6, 1, 1, "S601C9");
    set_bf_and_test(lv, s601c9f5, 1, 7, 17, 1, "S601C9");
    set_bf_and_test(lv, s601c9f5, 1, 7, 17, hide_sll(1LL<<16), "S601C9");
  }
}
static Arrange_To_Call_Me vS601C9(Test_S601C9, "S601C9", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S601C8  {
  ::S601C9 s601c8f0;
  int s601c8f1;
  void  mf601c8(); // _ZN6S601C87mf601c8Ev
};
//SIG(1 S601C8) U1{ m FC2{ Fi:4 Fi:4 Fi:4 Fi:2 Fi:1 Fi:17} Fi}

#endif // __cplusplus
#ifdef __cplusplus

struct  S601C10  {
  void *s601c10f0;
  void *s601c10f1;
  void  mf601c10(); // _ZN7S601C108mf601c10Ev
};
//SIG(-1 S601C10) C1{ m Fp[2]}


void  S601C10 ::mf601c10(){}

static void Test_S601C10()
{
  {
    init_simple_test("S601C10");
    S601C10 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S601C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C10)");
    check_field_offset(lv, s601c10f0, 0, "S601C10.s601c10f0");
    check_field_offset(lv, s601c10f1, ABISELECT(8,4), "S601C10.s601c10f1");
  }
}
static Arrange_To_Call_Me vS601C10(Test_S601C10, "S601C10", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C11  {
  void *s601c11f0;
  void *s601c11f1;
};
//SIG(-1 S601C11) C1{ Fp[2]}



static void Test_S601C11()
{
  {
    init_simple_test("S601C11");
    S601C11 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S601C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C11)");
    check_field_offset(lv, s601c11f0, 0, "S601C11.s601c11f0");
    check_field_offset(lv, s601c11f1, ABISELECT(8,4), "S601C11.s601c11f1");
  }
}
static Arrange_To_Call_Me vS601C11(Test_S601C11, "S601C11", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C5  {
  ::S2120C13_nt s601c5f0;
  ::S2120C13_nt s601c5f1;
  void *s601c5f2;
  int s601c5f3;
  ::S601C8 s601c5f4;
  int s601c5f5:2;
  int s601c5f6:2;
  unsigned char s601c5f7:1;
  unsigned char s601c5f8:1;
  ::S601C10 s601c5f9;
  ::S601C11 s601c5f10[2];
  virtual  ~S601C5(); // _ZN6S601C5D1Ev
  virtual void  v5(); // _ZN6S601C52v5Ev
  virtual void  v6(); // _ZN6S601C52v6Ev
  virtual void  v7(); // _ZN6S601C52v7Ev
  virtual void  v8(); // _ZN6S601C52v8Ev
  virtual void  v9(); // _ZN6S601C52v9Ev
  virtual void  v10(); // _ZN6S601C53v10Ev
  virtual void  v11(); // _ZN6S601C53v11Ev
  virtual void  v12(); // _ZN6S601C53v12Ev
  virtual void  v13(); // _ZN6S601C53v13Ev
  virtual void  v14(); // _ZN6S601C53v14Ev
  virtual void  v15(); // _ZN6S601C53v15Ev
  virtual void  v16(); // _ZN6S601C53v16Ev
  virtual void  v17(); // _ZN6S601C53v17Ev
  virtual void  v18(); // _ZN6S601C53v18Ev
  virtual void  v19(); // _ZN6S601C53v19Ev
  S601C5(); // tgen
};
//SIG(-1 S601C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 FC2{ m FC3{ m FL[2]}} FC2 Fp Fi FU4{ m FC5{ Fi:4 Fi:4 Fi:4 Fi:2 Fi:1 Fi:17} Fi} Fi:2 Fi:2 Fc:1 Fc:1 FC6{ m Fp Fp} FC7{ Fp Fp}[2]}


 S601C5 ::~S601C5(){ note_dtor("S601C5", this);}
void  S601C5 ::v5(){vfunc_called(this, "_ZN6S601C52v5Ev");}
void  S601C5 ::v6(){vfunc_called(this, "_ZN6S601C52v6Ev");}
void  S601C5 ::v7(){vfunc_called(this, "_ZN6S601C52v7Ev");}
void  S601C5 ::v8(){vfunc_called(this, "_ZN6S601C52v8Ev");}
void  S601C5 ::v9(){vfunc_called(this, "_ZN6S601C52v9Ev");}
void  S601C5 ::v10(){vfunc_called(this, "_ZN6S601C53v10Ev");}
void  S601C5 ::v11(){vfunc_called(this, "_ZN6S601C53v11Ev");}
void  S601C5 ::v12(){vfunc_called(this, "_ZN6S601C53v12Ev");}
void  S601C5 ::v13(){vfunc_called(this, "_ZN6S601C53v13Ev");}
void  S601C5 ::v14(){vfunc_called(this, "_ZN6S601C53v14Ev");}
void  S601C5 ::v15(){vfunc_called(this, "_ZN6S601C53v15Ev");}
void  S601C5 ::v16(){vfunc_called(this, "_ZN6S601C53v16Ev");}
void  S601C5 ::v17(){vfunc_called(this, "_ZN6S601C53v17Ev");}
void  S601C5 ::v18(){vfunc_called(this, "_ZN6S601C53v18Ev");}
void  S601C5 ::v19(){vfunc_called(this, "_ZN6S601C53v19Ev");}
S601C5 ::S601C5(){ note_ctor("S601C5", this);} // tgen

static void Test_S601C5()
{
  extern Class_Descriptor cd_S601C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,20)];
    init_test(&cd_S601C5, buf);
    S601C5 *dp, &lv = *(dp=new (buf) S601C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,76), "sizeof(S601C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C5)");
    check_field_offset(lv, s601c5f0, ABISELECT(8,4), "S601C5.s601c5f0");
    check_field_offset(lv, s601c5f1, ABISELECT(24,20), "S601C5.s601c5f1");
    check_field_offset(lv, s601c5f2, ABISELECT(40,36), "S601C5.s601c5f2");
    check_field_offset(lv, s601c5f3, ABISELECT(48,40), "S601C5.s601c5f3");
    check_field_offset(lv, s601c5f4, ABISELECT(52,44), "S601C5.s601c5f4");
    set_bf_and_test(lv, s601c5f5, ABISELECT(56,48), 0, 2, 1, "S601C5");
    set_bf_and_test(lv, s601c5f5, ABISELECT(56,48), 0, 2, hide_sll(1LL<<1), "S601C5");
    set_bf_and_test(lv, s601c5f6, ABISELECT(56,48), 2, 2, 1, "S601C5");
    set_bf_and_test(lv, s601c5f6, ABISELECT(56,48), 2, 2, hide_sll(1LL<<1), "S601C5");
    set_bf_and_test(lv, s601c5f7, ABISELECT(56,48), 4, 1, 1, "S601C5");
    set_bf_and_test(lv, s601c5f8, ABISELECT(56,48), 5, 1, 1, "S601C5");
    check_field_offset(lv, s601c5f9, ABISELECT(64,52), "S601C5.s601c5f9");
    check_field_offset(lv, s601c5f10, ABISELECT(80,60), "S601C5.s601c5f10");
    test_class_info(&lv, &cd_S601C5);
    dp->~S601C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS601C5(Test_S601C5, "S601C5", ABISELECT(112,76));

#else // __cplusplus

extern void _ZN6S601C5C1Ev();
extern void _ZN6S601C5D1Ev();
Name_Map name_map_S601C5[] = {
  NSPAIR(_ZN6S601C5C1Ev),
  NSPAIR(_ZN6S601C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S601C5[];
extern void _ZN6S601C5D1Ev();
extern void _ZN6S601C5D0Ev();
extern void _ZN6S601C52v5Ev();
extern void _ZN6S601C52v6Ev();
extern void _ZN6S601C52v7Ev();
extern void _ZN6S601C52v8Ev();
extern void _ZN6S601C52v9Ev();
extern void _ZN6S601C53v10Ev();
extern void _ZN6S601C53v11Ev();
extern void _ZN6S601C53v12Ev();
extern void _ZN6S601C53v13Ev();
extern void _ZN6S601C53v14Ev();
extern void _ZN6S601C53v15Ev();
extern void _ZN6S601C53v16Ev();
extern void _ZN6S601C53v17Ev();
extern void _ZN6S601C53v18Ev();
extern void _ZN6S601C53v19Ev();
static  VTBL_ENTRY vtc_S601C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S601C5[0]),
  (VTBL_ENTRY)&_ZN6S601C5D1Ev,
  (VTBL_ENTRY)&_ZN6S601C5D0Ev,
  (VTBL_ENTRY)&_ZN6S601C52v5Ev,
  (VTBL_ENTRY)&_ZN6S601C52v6Ev,
  (VTBL_ENTRY)&_ZN6S601C52v7Ev,
  (VTBL_ENTRY)&_ZN6S601C52v8Ev,
  (VTBL_ENTRY)&_ZN6S601C52v9Ev,
  (VTBL_ENTRY)&_ZN6S601C53v10Ev,
  (VTBL_ENTRY)&_ZN6S601C53v11Ev,
  (VTBL_ENTRY)&_ZN6S601C53v12Ev,
  (VTBL_ENTRY)&_ZN6S601C53v13Ev,
  (VTBL_ENTRY)&_ZN6S601C53v14Ev,
  (VTBL_ENTRY)&_ZN6S601C53v15Ev,
  (VTBL_ENTRY)&_ZN6S601C53v16Ev,
  (VTBL_ENTRY)&_ZN6S601C53v17Ev,
  (VTBL_ENTRY)&_ZN6S601C53v18Ev,
  (VTBL_ENTRY)&_ZN6S601C53v19Ev,
};
extern VTBL_ENTRY _ZTI6S601C5[];
extern  VTBL_ENTRY _ZTV6S601C5[];
Class_Descriptor cd_S601C5 = {  "S601C5", // class name
  0,0,//no base classes
  &(vtc_S601C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,76), // object size
  NSPAIRA(_ZTI6S601C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S601C5),19, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C12  {
  ::S2120C13_nt s601c12f0;
  ::S2120C13_nt s601c12f1;
  void  mf601c12(); // _ZN7S601C128mf601c12Ev
};
//SIG(-1 S601C12) C1{ m FC2{ m FC3{ m FL[2]}} FC2}


void  S601C12 ::mf601c12(){}

static void Test_S601C12()
{
  {
    init_simple_test("S601C12");
    S601C12 lv;
    check2(sizeof(lv), 32, "sizeof(S601C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C12)");
    check_field_offset(lv, s601c12f0, 0, "S601C12.s601c12f0");
    check_field_offset(lv, s601c12f1, 16, "S601C12.s601c12f1");
  }
}
static Arrange_To_Call_Me vS601C12(Test_S601C12, "S601C12", 32);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C13_nt  {
  void *s601c13f0;
  void  mf601c13(); // _ZN10S601C13_nt8mf601c13Ev
};
//SIG(-1 S601C13_nt) C1{ m Fp}


void  S601C13_nt ::mf601c13(){}

//skip512 S601C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C4  : S601C5 {
  unsigned char s601c4f0:1;
  unsigned char s601c4f1:1;
  unsigned char s601c4f2:1;
  unsigned char s601c4f3:1;
  unsigned char s601c4f4:1;
  unsigned char s601c4f5:1;
  unsigned char s601c4f6:1;
  char s601c4f7;
  int s601c4f8[2];
  int s601c4f9[2];
  void *s601c4f10;
  ::S2120C13_nt s601c4f11;
  ::S2120C13_nt s601c4f12;
  ::S2120C13_nt s601c4f13;
  ::S601C12 s601c4f14;
  void *s601c4f15;
  int s601c4f16;
  int s601c4f17;
  ::S601C13_nt s601c4f18[4];
  void *s601c4f19;
  virtual  ~S601C4(); // _ZN6S601C4D1Ev
  virtual void  v20(); // _ZN6S601C43v20Ev
  virtual void  v21(); // _ZN6S601C43v21Ev
  virtual void  v22(); // _ZN6S601C43v22Ev
  virtual void  v23(); // _ZN6S601C43v23Ev
  virtual void  v24(); // _ZN6S601C43v24Ev
  virtual void  v25(); // _ZN6S601C43v25Ev
  virtual void  v26(); // _ZN6S601C43v26Ev
  virtual void  v27(); // _ZN6S601C43v27Ev
  virtual void  v28(); // _ZN6S601C43v28Ev
  virtual void  v29(); // _ZN6S601C43v29Ev
  virtual void  v30(); // _ZN6S601C43v30Ev
  virtual void  v31(); // _ZN6S601C43v31Ev
  virtual void  v32(); // _ZN6S601C43v32Ev
  virtual void  v33(); // _ZN6S601C43v33Ev
  virtual void  v34(); // _ZN6S601C43v34Ev
  S601C4(); // tgen
};
//SIG(-1 S601C4) C1{ BC2{ vd v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 FC3{ m FC4{ m FL[2]}} FC3 Fp Fi FU5{ m FC6{ Fi:4 Fi:4 Fi:4 Fi:2 Fi:1 Fi:17} Fi} Fi:2 Fi:2 Fc:1 Fc:1 FC7{ m Fp Fp} FC8{ Fp Fp}[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc Fi[2] Fi[2] Fp FC3 FC3 FC3 FC9{ m FC3 FC3} Fp Fi Fi FC10{ m Fp}[4] Fp}


 S601C4 ::~S601C4(){ note_dtor("S601C4", this);}
void  S601C4 ::v20(){vfunc_called(this, "_ZN6S601C43v20Ev");}
void  S601C4 ::v21(){vfunc_called(this, "_ZN6S601C43v21Ev");}
void  S601C4 ::v22(){vfunc_called(this, "_ZN6S601C43v22Ev");}
void  S601C4 ::v23(){vfunc_called(this, "_ZN6S601C43v23Ev");}
void  S601C4 ::v24(){vfunc_called(this, "_ZN6S601C43v24Ev");}
void  S601C4 ::v25(){vfunc_called(this, "_ZN6S601C43v25Ev");}
void  S601C4 ::v26(){vfunc_called(this, "_ZN6S601C43v26Ev");}
void  S601C4 ::v27(){vfunc_called(this, "_ZN6S601C43v27Ev");}
void  S601C4 ::v28(){vfunc_called(this, "_ZN6S601C43v28Ev");}
void  S601C4 ::v29(){vfunc_called(this, "_ZN6S601C43v29Ev");}
void  S601C4 ::v30(){vfunc_called(this, "_ZN6S601C43v30Ev");}
void  S601C4 ::v31(){vfunc_called(this, "_ZN6S601C43v31Ev");}
void  S601C4 ::v32(){vfunc_called(this, "_ZN6S601C43v32Ev");}
void  S601C4 ::v33(){vfunc_called(this, "_ZN6S601C43v33Ev");}
void  S601C4 ::v34(){vfunc_called(this, "_ZN6S601C43v34Ev");}
S601C4 ::S601C4(){ note_ctor("S601C4", this);} // tgen

static void Test_S601C4()
{
  extern Class_Descriptor cd_S601C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(36,54)];
    init_test(&cd_S601C4, buf);
    S601C4 *dp, &lv = *(dp=new (buf) S601C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(280,212), "sizeof(S601C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C4)");
    check_base_class_offset(lv, (S601C5*), 0, "S601C4");
    set_bf_and_test(lv, s601c4f0, ABISELECT(112,76), 0, 1, 1, "S601C4");
    set_bf_and_test(lv, s601c4f1, ABISELECT(112,76), 1, 1, 1, "S601C4");
    set_bf_and_test(lv, s601c4f2, ABISELECT(112,76), 2, 1, 1, "S601C4");
    set_bf_and_test(lv, s601c4f3, ABISELECT(112,76), 3, 1, 1, "S601C4");
    set_bf_and_test(lv, s601c4f4, ABISELECT(112,76), 4, 1, 1, "S601C4");
    set_bf_and_test(lv, s601c4f5, ABISELECT(112,76), 5, 1, 1, "S601C4");
    set_bf_and_test(lv, s601c4f6, ABISELECT(112,76), 6, 1, 1, "S601C4");
    check_field_offset(lv, s601c4f7, ABISELECT(113,77), "S601C4.s601c4f7");
    check_field_offset(lv, s601c4f8, ABISELECT(116,80), "S601C4.s601c4f8");
    check_field_offset(lv, s601c4f9, ABISELECT(124,88), "S601C4.s601c4f9");
    check_field_offset(lv, s601c4f10, ABISELECT(136,96), "S601C4.s601c4f10");
    check_field_offset(lv, s601c4f11, ABISELECT(144,100), "S601C4.s601c4f11");
    check_field_offset(lv, s601c4f12, ABISELECT(160,116), "S601C4.s601c4f12");
    check_field_offset(lv, s601c4f13, ABISELECT(176,132), "S601C4.s601c4f13");
    check_field_offset(lv, s601c4f14, ABISELECT(192,148), "S601C4.s601c4f14");
    check_field_offset(lv, s601c4f15, ABISELECT(224,180), "S601C4.s601c4f15");
    check_field_offset(lv, s601c4f16, ABISELECT(232,184), "S601C4.s601c4f16");
    check_field_offset(lv, s601c4f17, ABISELECT(236,188), "S601C4.s601c4f17");
    check_field_offset(lv, s601c4f18, ABISELECT(240,192), "S601C4.s601c4f18");
    check_field_offset(lv, s601c4f19, ABISELECT(272,208), "S601C4.s601c4f19");
    test_class_info(&lv, &cd_S601C4);
    dp->~S601C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS601C4(Test_S601C4, "S601C4", ABISELECT(280,212));

#else // __cplusplus

extern void _ZN6S601C4C1Ev();
extern void _ZN6S601C4D1Ev();
Name_Map name_map_S601C4[] = {
  NSPAIR(_ZN6S601C4C1Ev),
  NSPAIR(_ZN6S601C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S601C5;
extern VTBL_ENTRY _ZTI6S601C5[];
extern  VTBL_ENTRY _ZTV6S601C5[];
static Base_Class bases_S601C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S601C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S601C4[];
extern void _ZN6S601C4D1Ev();
extern void _ZN6S601C4D0Ev();
extern void _ZN6S601C52v5Ev();
extern void _ZN6S601C52v6Ev();
extern void _ZN6S601C52v7Ev();
extern void _ZN6S601C52v8Ev();
extern void _ZN6S601C52v9Ev();
extern void _ZN6S601C53v10Ev();
extern void _ZN6S601C53v11Ev();
extern void _ZN6S601C53v12Ev();
extern void _ZN6S601C53v13Ev();
extern void _ZN6S601C53v14Ev();
extern void _ZN6S601C53v15Ev();
extern void _ZN6S601C53v16Ev();
extern void _ZN6S601C53v17Ev();
extern void _ZN6S601C53v18Ev();
extern void _ZN6S601C53v19Ev();
extern void _ZN6S601C43v20Ev();
extern void _ZN6S601C43v21Ev();
extern void _ZN6S601C43v22Ev();
extern void _ZN6S601C43v23Ev();
extern void _ZN6S601C43v24Ev();
extern void _ZN6S601C43v25Ev();
extern void _ZN6S601C43v26Ev();
extern void _ZN6S601C43v27Ev();
extern void _ZN6S601C43v28Ev();
extern void _ZN6S601C43v29Ev();
extern void _ZN6S601C43v30Ev();
extern void _ZN6S601C43v31Ev();
extern void _ZN6S601C43v32Ev();
extern void _ZN6S601C43v33Ev();
extern void _ZN6S601C43v34Ev();
static  VTBL_ENTRY vtc_S601C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S601C4[0]),
  (VTBL_ENTRY)&_ZN6S601C4D1Ev,
  (VTBL_ENTRY)&_ZN6S601C4D0Ev,
  (VTBL_ENTRY)&_ZN6S601C52v5Ev,
  (VTBL_ENTRY)&_ZN6S601C52v6Ev,
  (VTBL_ENTRY)&_ZN6S601C52v7Ev,
  (VTBL_ENTRY)&_ZN6S601C52v8Ev,
  (VTBL_ENTRY)&_ZN6S601C52v9Ev,
  (VTBL_ENTRY)&_ZN6S601C53v10Ev,
  (VTBL_ENTRY)&_ZN6S601C53v11Ev,
  (VTBL_ENTRY)&_ZN6S601C53v12Ev,
  (VTBL_ENTRY)&_ZN6S601C53v13Ev,
  (VTBL_ENTRY)&_ZN6S601C53v14Ev,
  (VTBL_ENTRY)&_ZN6S601C53v15Ev,
  (VTBL_ENTRY)&_ZN6S601C53v16Ev,
  (VTBL_ENTRY)&_ZN6S601C53v17Ev,
  (VTBL_ENTRY)&_ZN6S601C53v18Ev,
  (VTBL_ENTRY)&_ZN6S601C53v19Ev,
  (VTBL_ENTRY)&_ZN6S601C43v20Ev,
  (VTBL_ENTRY)&_ZN6S601C43v21Ev,
  (VTBL_ENTRY)&_ZN6S601C43v22Ev,
  (VTBL_ENTRY)&_ZN6S601C43v23Ev,
  (VTBL_ENTRY)&_ZN6S601C43v24Ev,
  (VTBL_ENTRY)&_ZN6S601C43v25Ev,
  (VTBL_ENTRY)&_ZN6S601C43v26Ev,
  (VTBL_ENTRY)&_ZN6S601C43v27Ev,
  (VTBL_ENTRY)&_ZN6S601C43v28Ev,
  (VTBL_ENTRY)&_ZN6S601C43v29Ev,
  (VTBL_ENTRY)&_ZN6S601C43v30Ev,
  (VTBL_ENTRY)&_ZN6S601C43v31Ev,
  (VTBL_ENTRY)&_ZN6S601C43v32Ev,
  (VTBL_ENTRY)&_ZN6S601C43v33Ev,
  (VTBL_ENTRY)&_ZN6S601C43v34Ev,
};
extern VTBL_ENTRY _ZTI6S601C4[];
extern  VTBL_ENTRY _ZTV6S601C4[];
Class_Descriptor cd_S601C4 = {  "S601C4", // class name
  bases_S601C4, 1,
  &(vtc_S601C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(280,212), // object size
  NSPAIRA(_ZTI6S601C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S601C4),34, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C15  {
  __tsi64 s601c15f0;
  __tsi64 s601c15f1;
  void  mf601c15(); // _ZN7S601C158mf601c15Ev
};
//SIG(-1 S601C15) C1{ m FL[2]}


void  S601C15 ::mf601c15(){}

static void Test_S601C15()
{
  {
    init_simple_test("S601C15");
    S601C15 lv;
    check2(sizeof(lv), 16, "sizeof(S601C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C15)");
    check_field_offset(lv, s601c15f0, 0, "S601C15.s601c15f0");
    check_field_offset(lv, s601c15f1, 8, "S601C15.s601c15f1");
  }
}
static Arrange_To_Call_Me vS601C15(Test_S601C15, "S601C15", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C14  {
  ::S601C15 s601c14f0;
  void  mf601c14(); // _ZN7S601C148mf601c14Ev
};
//SIG(-1 S601C14) C1{ m FC2{ m FL[2]}}


void  S601C14 ::mf601c14(){}

static void Test_S601C14()
{
  {
    init_simple_test("S601C14");
    S601C14 lv;
    check2(sizeof(lv), 16, "sizeof(S601C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C14)");
    check_field_offset(lv, s601c14f0, 0, "S601C14.s601c14f0");
  }
}
static Arrange_To_Call_Me vS601C14(Test_S601C14, "S601C14", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C3  : S601C4 {
  ::S601C13_nt s601c3f0;
  ::S601C13_nt s601c3f1;
  ::S601C13_nt s601c3f2;
  ::S601C13_nt s601c3f3;
  ::S2120C13_nt s601c3f4;
  ::S2120C13_nt s601c3f5;
  ::S2120C13_nt s601c3f6;
  ::S2120C13_nt s601c3f7;
  ::S601C14 s601c3f8;
  virtual  ~S601C3(); // _ZN6S601C3D1Ev
  virtual void  v35(); // _ZN6S601C33v35Ev
  virtual void  v36(); // _ZN6S601C33v36Ev
  virtual void  v37(); // _ZN6S601C33v37Ev
  virtual void  v38(); // _ZN6S601C33v38Ev
  virtual void  v39(); // _ZN6S601C33v39Ev
  S601C3(); // tgen
};
//SIG(-1 S601C3) C1{ BC2{ BC3{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 FC4{ m FC5{ m FL[2]}} FC4 Fp Fi FU6{ m FC7{ Fi:4 Fi:4 Fi:4 Fi:2 Fi:1 Fi:17} Fi} Fi:2 Fi:2 Fc:1 Fc:1 FC8{ m Fp Fp} FC9{ Fp Fp}[2]} vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc Fi[2] Fi[2] Fp FC4 FC4 FC4 FC10{ m FC4 FC4} Fp Fi Fi FC11{ m Fp}[4] Fp} vd v1 v2 v3 v4 v5 FC11 FC11 FC11 FC11 FC4 FC4 FC4 FC4 FC12{ m FC13{ m FL FL}}}


 S601C3 ::~S601C3(){ note_dtor("S601C3", this);}
void  S601C3 ::v35(){vfunc_called(this, "_ZN6S601C33v35Ev");}
void  S601C3 ::v36(){vfunc_called(this, "_ZN6S601C33v36Ev");}
void  S601C3 ::v37(){vfunc_called(this, "_ZN6S601C33v37Ev");}
void  S601C3 ::v38(){vfunc_called(this, "_ZN6S601C33v38Ev");}
void  S601C3 ::v39(){vfunc_called(this, "_ZN6S601C33v39Ev");}
S601C3 ::S601C3(){ note_ctor("S601C3", this);} // tgen

static void Test_S601C3()
{
  extern Class_Descriptor cd_S601C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(50,78)];
    init_test(&cd_S601C3, buf);
    S601C3 *dp, &lv = *(dp=new (buf) S601C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(392,308), "sizeof(S601C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C3)");
    check_base_class_offset(lv, (S601C5*)(S601C4*), 0, "S601C3");
    check_base_class_offset(lv, (S601C4*), 0, "S601C3");
    check_field_offset(lv, s601c3f0, ABISELECT(280,212), "S601C3.s601c3f0");
    check_field_offset(lv, s601c3f1, ABISELECT(288,216), "S601C3.s601c3f1");
    check_field_offset(lv, s601c3f2, ABISELECT(296,220), "S601C3.s601c3f2");
    check_field_offset(lv, s601c3f3, ABISELECT(304,224), "S601C3.s601c3f3");
    check_field_offset(lv, s601c3f4, ABISELECT(312,228), "S601C3.s601c3f4");
    check_field_offset(lv, s601c3f5, ABISELECT(328,244), "S601C3.s601c3f5");
    check_field_offset(lv, s601c3f6, ABISELECT(344,260), "S601C3.s601c3f6");
    check_field_offset(lv, s601c3f7, ABISELECT(360,276), "S601C3.s601c3f7");
    check_field_offset(lv, s601c3f8, ABISELECT(376,292), "S601C3.s601c3f8");
    test_class_info(&lv, &cd_S601C3);
    dp->~S601C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS601C3(Test_S601C3, "S601C3", ABISELECT(392,308));

#else // __cplusplus

extern void _ZN6S601C3C1Ev();
extern void _ZN6S601C3D1Ev();
Name_Map name_map_S601C3[] = {
  NSPAIR(_ZN6S601C3C1Ev),
  NSPAIR(_ZN6S601C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S601C5;
extern VTBL_ENTRY _ZTI6S601C5[];
extern  VTBL_ENTRY _ZTV6S601C5[];
extern Class_Descriptor cd_S601C4;
extern VTBL_ENTRY _ZTI6S601C4[];
extern  VTBL_ENTRY _ZTV6S601C4[];
static Base_Class bases_S601C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S601C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S601C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S601C3[];
extern void _ZN6S601C3D1Ev();
extern void _ZN6S601C3D0Ev();
extern void _ZN6S601C52v5Ev();
extern void _ZN6S601C52v6Ev();
extern void _ZN6S601C52v7Ev();
extern void _ZN6S601C52v8Ev();
extern void _ZN6S601C52v9Ev();
extern void _ZN6S601C53v10Ev();
extern void _ZN6S601C53v11Ev();
extern void _ZN6S601C53v12Ev();
extern void _ZN6S601C53v13Ev();
extern void _ZN6S601C53v14Ev();
extern void _ZN6S601C53v15Ev();
extern void _ZN6S601C53v16Ev();
extern void _ZN6S601C53v17Ev();
extern void _ZN6S601C53v18Ev();
extern void _ZN6S601C53v19Ev();
extern void _ZN6S601C43v20Ev();
extern void _ZN6S601C43v21Ev();
extern void _ZN6S601C43v22Ev();
extern void _ZN6S601C43v23Ev();
extern void _ZN6S601C43v24Ev();
extern void _ZN6S601C43v25Ev();
extern void _ZN6S601C43v26Ev();
extern void _ZN6S601C43v27Ev();
extern void _ZN6S601C43v28Ev();
extern void _ZN6S601C43v29Ev();
extern void _ZN6S601C43v30Ev();
extern void _ZN6S601C43v31Ev();
extern void _ZN6S601C43v32Ev();
extern void _ZN6S601C43v33Ev();
extern void _ZN6S601C43v34Ev();
extern void _ZN6S601C33v35Ev();
extern void _ZN6S601C33v36Ev();
extern void _ZN6S601C33v37Ev();
extern void _ZN6S601C33v38Ev();
extern void _ZN6S601C33v39Ev();
static  VTBL_ENTRY vtc_S601C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S601C3[0]),
  (VTBL_ENTRY)&_ZN6S601C3D1Ev,
  (VTBL_ENTRY)&_ZN6S601C3D0Ev,
  (VTBL_ENTRY)&_ZN6S601C52v5Ev,
  (VTBL_ENTRY)&_ZN6S601C52v6Ev,
  (VTBL_ENTRY)&_ZN6S601C52v7Ev,
  (VTBL_ENTRY)&_ZN6S601C52v8Ev,
  (VTBL_ENTRY)&_ZN6S601C52v9Ev,
  (VTBL_ENTRY)&_ZN6S601C53v10Ev,
  (VTBL_ENTRY)&_ZN6S601C53v11Ev,
  (VTBL_ENTRY)&_ZN6S601C53v12Ev,
  (VTBL_ENTRY)&_ZN6S601C53v13Ev,
  (VTBL_ENTRY)&_ZN6S601C53v14Ev,
  (VTBL_ENTRY)&_ZN6S601C53v15Ev,
  (VTBL_ENTRY)&_ZN6S601C53v16Ev,
  (VTBL_ENTRY)&_ZN6S601C53v17Ev,
  (VTBL_ENTRY)&_ZN6S601C53v18Ev,
  (VTBL_ENTRY)&_ZN6S601C53v19Ev,
  (VTBL_ENTRY)&_ZN6S601C43v20Ev,
  (VTBL_ENTRY)&_ZN6S601C43v21Ev,
  (VTBL_ENTRY)&_ZN6S601C43v22Ev,
  (VTBL_ENTRY)&_ZN6S601C43v23Ev,
  (VTBL_ENTRY)&_ZN6S601C43v24Ev,
  (VTBL_ENTRY)&_ZN6S601C43v25Ev,
  (VTBL_ENTRY)&_ZN6S601C43v26Ev,
  (VTBL_ENTRY)&_ZN6S601C43v27Ev,
  (VTBL_ENTRY)&_ZN6S601C43v28Ev,
  (VTBL_ENTRY)&_ZN6S601C43v29Ev,
  (VTBL_ENTRY)&_ZN6S601C43v30Ev,
  (VTBL_ENTRY)&_ZN6S601C43v31Ev,
  (VTBL_ENTRY)&_ZN6S601C43v32Ev,
  (VTBL_ENTRY)&_ZN6S601C43v33Ev,
  (VTBL_ENTRY)&_ZN6S601C43v34Ev,
  (VTBL_ENTRY)&_ZN6S601C33v35Ev,
  (VTBL_ENTRY)&_ZN6S601C33v36Ev,
  (VTBL_ENTRY)&_ZN6S601C33v37Ev,
  (VTBL_ENTRY)&_ZN6S601C33v38Ev,
  (VTBL_ENTRY)&_ZN6S601C33v39Ev,
};
extern VTBL_ENTRY _ZTI6S601C3[];
extern  VTBL_ENTRY _ZTV6S601C3[];
Class_Descriptor cd_S601C3 = {  "S601C3", // class name
  bases_S601C3, 2,
  &(vtc_S601C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(392,308), // object size
  NSPAIRA(_ZTI6S601C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S601C3),39, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C2  : S601C3 {
  virtual  ~S601C2(); // _ZN6S601C2D1Ev
  virtual void  v40(); // _ZN6S601C23v40Ev
  virtual void  v41(); // _ZN6S601C23v41Ev
  virtual void  v42(); // _ZN6S601C23v42Ev
  virtual void  v43(); // _ZN6S601C23v43Ev
  S601C2(); // tgen
};
//SIG(-1 S601C2) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 FC5{ m FC6{ m FL[2]}} FC5 Fp Fi FU7{ m FC8{ Fi:4 Fi:4 Fi:4 Fi:2 Fi:1 Fi:17} Fi} Fi:2 Fi:2 Fc:1 Fc:1 FC9{ m Fp Fp} FC10{ Fp Fp}[2]} vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc Fi[2] Fi[2] Fp FC5 FC5 FC5 FC11{ m FC5 FC5} Fp Fi Fi FC12{ m Fp}[4] Fp} vd v35 v36 v37 v38 v39 FC12 FC12 FC12 FC12 FC5 FC5 FC5 FC5 FC13{ m FC14{ m FL FL}}} vd v1 v2 v3 v4}


 S601C2 ::~S601C2(){ note_dtor("S601C2", this);}
void  S601C2 ::v40(){vfunc_called(this, "_ZN6S601C23v40Ev");}
void  S601C2 ::v41(){vfunc_called(this, "_ZN6S601C23v41Ev");}
void  S601C2 ::v42(){vfunc_called(this, "_ZN6S601C23v42Ev");}
void  S601C2 ::v43(){vfunc_called(this, "_ZN6S601C23v43Ev");}
S601C2 ::S601C2(){ note_ctor("S601C2", this);} // tgen

static void Test_S601C2()
{
  extern Class_Descriptor cd_S601C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(50,78)];
    init_test(&cd_S601C2, buf);
    S601C2 *dp, &lv = *(dp=new (buf) S601C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(392,308), "sizeof(S601C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C2)");
    check_base_class_offset(lv, (S601C5*)(S601C4*)(S601C3*), 0, "S601C2");
    check_base_class_offset(lv, (S601C4*)(S601C3*), 0, "S601C2");
    check_base_class_offset(lv, (S601C3*), 0, "S601C2");
    test_class_info(&lv, &cd_S601C2);
    dp->~S601C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS601C2(Test_S601C2, "S601C2", ABISELECT(392,308));

#else // __cplusplus

extern void _ZN6S601C2C1Ev();
extern void _ZN6S601C2D1Ev();
Name_Map name_map_S601C2[] = {
  NSPAIR(_ZN6S601C2C1Ev),
  NSPAIR(_ZN6S601C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S601C5;
extern VTBL_ENTRY _ZTI6S601C5[];
extern  VTBL_ENTRY _ZTV6S601C5[];
extern Class_Descriptor cd_S601C4;
extern VTBL_ENTRY _ZTI6S601C4[];
extern  VTBL_ENTRY _ZTV6S601C4[];
extern Class_Descriptor cd_S601C3;
extern VTBL_ENTRY _ZTI6S601C3[];
extern  VTBL_ENTRY _ZTV6S601C3[];
static Base_Class bases_S601C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S601C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S601C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S601C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S601C2[];
extern void _ZN6S601C2D1Ev();
extern void _ZN6S601C2D0Ev();
extern void _ZN6S601C52v5Ev();
extern void _ZN6S601C52v6Ev();
extern void _ZN6S601C52v7Ev();
extern void _ZN6S601C52v8Ev();
extern void _ZN6S601C52v9Ev();
extern void _ZN6S601C53v10Ev();
extern void _ZN6S601C53v11Ev();
extern void _ZN6S601C53v12Ev();
extern void _ZN6S601C53v13Ev();
extern void _ZN6S601C53v14Ev();
extern void _ZN6S601C53v15Ev();
extern void _ZN6S601C53v16Ev();
extern void _ZN6S601C53v17Ev();
extern void _ZN6S601C53v18Ev();
extern void _ZN6S601C53v19Ev();
extern void _ZN6S601C43v20Ev();
extern void _ZN6S601C43v21Ev();
extern void _ZN6S601C43v22Ev();
extern void _ZN6S601C43v23Ev();
extern void _ZN6S601C43v24Ev();
extern void _ZN6S601C43v25Ev();
extern void _ZN6S601C43v26Ev();
extern void _ZN6S601C43v27Ev();
extern void _ZN6S601C43v28Ev();
extern void _ZN6S601C43v29Ev();
extern void _ZN6S601C43v30Ev();
extern void _ZN6S601C43v31Ev();
extern void _ZN6S601C43v32Ev();
extern void _ZN6S601C43v33Ev();
extern void _ZN6S601C43v34Ev();
extern void _ZN6S601C33v35Ev();
extern void _ZN6S601C33v36Ev();
extern void _ZN6S601C33v37Ev();
extern void _ZN6S601C33v38Ev();
extern void _ZN6S601C33v39Ev();
extern void _ZN6S601C23v40Ev();
extern void _ZN6S601C23v41Ev();
extern void _ZN6S601C23v42Ev();
extern void _ZN6S601C23v43Ev();
static  VTBL_ENTRY vtc_S601C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S601C2[0]),
  (VTBL_ENTRY)&_ZN6S601C2D1Ev,
  (VTBL_ENTRY)&_ZN6S601C2D0Ev,
  (VTBL_ENTRY)&_ZN6S601C52v5Ev,
  (VTBL_ENTRY)&_ZN6S601C52v6Ev,
  (VTBL_ENTRY)&_ZN6S601C52v7Ev,
  (VTBL_ENTRY)&_ZN6S601C52v8Ev,
  (VTBL_ENTRY)&_ZN6S601C52v9Ev,
  (VTBL_ENTRY)&_ZN6S601C53v10Ev,
  (VTBL_ENTRY)&_ZN6S601C53v11Ev,
  (VTBL_ENTRY)&_ZN6S601C53v12Ev,
  (VTBL_ENTRY)&_ZN6S601C53v13Ev,
  (VTBL_ENTRY)&_ZN6S601C53v14Ev,
  (VTBL_ENTRY)&_ZN6S601C53v15Ev,
  (VTBL_ENTRY)&_ZN6S601C53v16Ev,
  (VTBL_ENTRY)&_ZN6S601C53v17Ev,
  (VTBL_ENTRY)&_ZN6S601C53v18Ev,
  (VTBL_ENTRY)&_ZN6S601C53v19Ev,
  (VTBL_ENTRY)&_ZN6S601C43v20Ev,
  (VTBL_ENTRY)&_ZN6S601C43v21Ev,
  (VTBL_ENTRY)&_ZN6S601C43v22Ev,
  (VTBL_ENTRY)&_ZN6S601C43v23Ev,
  (VTBL_ENTRY)&_ZN6S601C43v24Ev,
  (VTBL_ENTRY)&_ZN6S601C43v25Ev,
  (VTBL_ENTRY)&_ZN6S601C43v26Ev,
  (VTBL_ENTRY)&_ZN6S601C43v27Ev,
  (VTBL_ENTRY)&_ZN6S601C43v28Ev,
  (VTBL_ENTRY)&_ZN6S601C43v29Ev,
  (VTBL_ENTRY)&_ZN6S601C43v30Ev,
  (VTBL_ENTRY)&_ZN6S601C43v31Ev,
  (VTBL_ENTRY)&_ZN6S601C43v32Ev,
  (VTBL_ENTRY)&_ZN6S601C43v33Ev,
  (VTBL_ENTRY)&_ZN6S601C43v34Ev,
  (VTBL_ENTRY)&_ZN6S601C33v35Ev,
  (VTBL_ENTRY)&_ZN6S601C33v36Ev,
  (VTBL_ENTRY)&_ZN6S601C33v37Ev,
  (VTBL_ENTRY)&_ZN6S601C33v38Ev,
  (VTBL_ENTRY)&_ZN6S601C33v39Ev,
  (VTBL_ENTRY)&_ZN6S601C23v40Ev,
  (VTBL_ENTRY)&_ZN6S601C23v41Ev,
  (VTBL_ENTRY)&_ZN6S601C23v42Ev,
  (VTBL_ENTRY)&_ZN6S601C23v43Ev,
};
extern VTBL_ENTRY _ZTI6S601C2[];
extern  VTBL_ENTRY _ZTV6S601C2[];
Class_Descriptor cd_S601C2 = {  "S601C2", // class name
  bases_S601C2, 3,
  &(vtc_S601C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(392,308), // object size
  NSPAIRA(_ZTI6S601C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S601C2),43, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C20  {
  void *s601c20f0;
  void *s601c20f1;
  void *s601c20f2;
  void *s601c20f3;
  void  mf601c20(); // _ZN7S601C208mf601c20Ev
};
//SIG(-1 S601C20) C1{ m Fp[4]}


void  S601C20 ::mf601c20(){}

static void Test_S601C20()
{
  {
    init_simple_test("S601C20");
    S601C20 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S601C20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C20)");
    check_field_offset(lv, s601c20f0, 0, "S601C20.s601c20f0");
    check_field_offset(lv, s601c20f1, ABISELECT(8,4), "S601C20.s601c20f1");
    check_field_offset(lv, s601c20f2, ABISELECT(16,8), "S601C20.s601c20f2");
    check_field_offset(lv, s601c20f3, ABISELECT(24,12), "S601C20.s601c20f3");
  }
}
static Arrange_To_Call_Me vS601C20(Test_S601C20, "S601C20", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C19  {
  ::S601C20 s601c19f0;
  virtual  ~S601C19(); // _ZN7S601C19D1Ev
  virtual void  v50(); // _ZN7S601C193v50Ev
  virtual void  v51(); // _ZN7S601C193v51Ev
  virtual void  v52(); // _ZN7S601C193v52Ev
  virtual void  v53(); // _ZN7S601C193v53Ev
  virtual void  v54(); // _ZN7S601C193v54Ev
  virtual void  v55(); // _ZN7S601C193v55Ev
  S601C19(); // tgen
};
//SIG(-1 S601C19) C1{ vd v1 v2 v3 v4 v5 v6 FC2{ m Fp[4]}}


 S601C19 ::~S601C19(){ note_dtor("S601C19", this);}
void  S601C19 ::v50(){vfunc_called(this, "_ZN7S601C193v50Ev");}
void  S601C19 ::v51(){vfunc_called(this, "_ZN7S601C193v51Ev");}
void  S601C19 ::v52(){vfunc_called(this, "_ZN7S601C193v52Ev");}
void  S601C19 ::v53(){vfunc_called(this, "_ZN7S601C193v53Ev");}
void  S601C19 ::v54(){vfunc_called(this, "_ZN7S601C193v54Ev");}
void  S601C19 ::v55(){vfunc_called(this, "_ZN7S601C193v55Ev");}
S601C19 ::S601C19(){ note_ctor("S601C19", this);} // tgen

static void Test_S601C19()
{
  extern Class_Descriptor cd_S601C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[6];
    init_test(&cd_S601C19, buf);
    S601C19 *dp, &lv = *(dp=new (buf) S601C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,20), "sizeof(S601C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C19)");
    check_field_offset(lv, s601c19f0, ABISELECT(8,4), "S601C19.s601c19f0");
    test_class_info(&lv, &cd_S601C19);
    dp->~S601C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS601C19(Test_S601C19, "S601C19", ABISELECT(40,20));

#else // __cplusplus

extern void _ZN7S601C19C1Ev();
extern void _ZN7S601C19D1Ev();
Name_Map name_map_S601C19[] = {
  NSPAIR(_ZN7S601C19C1Ev),
  NSPAIR(_ZN7S601C19D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S601C19[];
extern void _ZN7S601C19D1Ev();
extern void _ZN7S601C19D0Ev();
extern void _ZN7S601C193v50Ev();
extern void _ZN7S601C193v51Ev();
extern void _ZN7S601C193v52Ev();
extern void _ZN7S601C193v53Ev();
extern void _ZN7S601C193v54Ev();
extern void _ZN7S601C193v55Ev();
static  VTBL_ENTRY vtc_S601C19[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S601C19[0]),
  (VTBL_ENTRY)&_ZN7S601C19D1Ev,
  (VTBL_ENTRY)&_ZN7S601C19D0Ev,
  (VTBL_ENTRY)&_ZN7S601C193v50Ev,
  (VTBL_ENTRY)&_ZN7S601C193v51Ev,
  (VTBL_ENTRY)&_ZN7S601C193v52Ev,
  (VTBL_ENTRY)&_ZN7S601C193v53Ev,
  (VTBL_ENTRY)&_ZN7S601C193v54Ev,
  (VTBL_ENTRY)&_ZN7S601C193v55Ev,
};
extern VTBL_ENTRY _ZTI7S601C19[];
extern  VTBL_ENTRY _ZTV7S601C19[];
Class_Descriptor cd_S601C19 = {  "S601C19", // class name
  0,0,//no base classes
  &(vtc_S601C19[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,20), // object size
  NSPAIRA(_ZTI7S601C19),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S601C19),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C21_nt  {
};
//SIG(-1 S601C21_nt) C1{}



//skip512 S601C21_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S601C21_nt[];
VTBL_ENTRY *P__ZTI10S601C21_nt = _ZTI10S601C21_nt; 
Class_Descriptor cd_S601C21_nt = {  "S601C21_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI10S601C21_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C23  {
  void *s601c23f0;
  int s601c23f1;
  void *s601c23f2;
  int s601c23f3;
  int s601c23f4;
  void  mf601c23(); // _ZN7S601C238mf601c23Ev
};
//SIG(-1 S601C23) C1{ m Fp Fi Fp Fi[2]}


void  S601C23 ::mf601c23(){}

static void Test_S601C23()
{
  {
    init_simple_test("S601C23");
    S601C23 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S601C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C23)");
    check_field_offset(lv, s601c23f0, 0, "S601C23.s601c23f0");
    check_field_offset(lv, s601c23f1, ABISELECT(8,4), "S601C23.s601c23f1");
    check_field_offset(lv, s601c23f2, ABISELECT(16,8), "S601C23.s601c23f2");
    check_field_offset(lv, s601c23f3, ABISELECT(24,12), "S601C23.s601c23f3");
    check_field_offset(lv, s601c23f4, ABISELECT(28,16), "S601C23.s601c23f4");
  }
}
static Arrange_To_Call_Me vS601C23(Test_S601C23, "S601C23", ABISELECT(32,20));

#else // __cplusplus

Class_Descriptor cd_S601C23 = {  "S601C23", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C22  : S601C23 {
  ::S2120C18_nt s601c22f0;
};
//SIG(-1 S601C22) C1{ BC2{ m Fp Fi Fp Fi[2]} FC3{ m FC4{ m FC5{ m FL[2]}} FC4 FC4 FC4}}



static void Test_S601C22()
{
  extern Class_Descriptor cd_S601C22;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,22)];
    init_test(&cd_S601C22, buf);
    S601C22 &lv = *(new (buf) S601C22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,84), "sizeof(S601C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C22)");
    check_base_class_offset(lv, (S601C23*), 0, "S601C22");
    check_field_offset(lv, s601c22f0, ABISELECT(32,20), "S601C22.s601c22f0");
    test_class_info(&lv, &cd_S601C22);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS601C22(Test_S601C22, "S601C22", ABISELECT(96,84));

#else // __cplusplus

extern Class_Descriptor cd_S601C23;
static Base_Class bases_S601C22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S601C23,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S601C22 = {  "S601C22", // class name
  bases_S601C22, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(96,84), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C25_nt  {
  ::S2120C14_nt s601c25f0;
  void  mf601c25(); // _ZN10S601C25_nt8mf601c25Ev
};
//SIG(-1 S601C25_nt) C1{ m FC2{ m FL[2]}}


void  S601C25_nt ::mf601c25(){}

//skip512 S601C25_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C27  : S601C23 {
  ::S601C25_nt s601c27f0;
};
//SIG(-1 S601C27) C1{ BC2{ m Fp Fi Fp Fi[2]} FC3{ m FC4{ m FL[2]}}}



static void Test_S601C27()
{
  extern Class_Descriptor cd_S601C27;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_S601C27, buf);
    S601C27 &lv = *(new (buf) S601C27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(S601C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C27)");
    check_base_class_offset(lv, (S601C23*), 0, "S601C27");
    check_field_offset(lv, s601c27f0, ABISELECT(32,20), "S601C27.s601c27f0");
    test_class_info(&lv, &cd_S601C27);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS601C27(Test_S601C27, "S601C27", ABISELECT(48,36));

#else // __cplusplus

extern Class_Descriptor cd_S601C23;
static Base_Class bases_S601C27[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S601C23,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S601C27 = {  "S601C27", // class name
  bases_S601C27, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(48,36), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C30_nt  {
  __tsi64 s601c30f0;
  void  mf601c30(); // _ZN10S601C30_nt8mf601c30Ev
};
//SIG(-1 S601C30_nt) C1{ m FL}


void  S601C30_nt ::mf601c30(){}

//skip512 S601C30_nt

#else // __cplusplus

Class_Descriptor cd_S601C30_nt = {  "S601C30_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C29_nt  {
  ::S601C30_nt s601c29f0;
  void  mf601c29(); // _ZN10S601C29_nt8mf601c29Ev
};
//SIG(-1 S601C29_nt) C1{ m FC2{ m FL}}


void  S601C29_nt ::mf601c29(){}

//skip512 S601C29_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C28  : S601C23 {
  ::S601C29_nt s601c28f0;
};
//SIG(-1 S601C28) C1{ BC2{ m Fp Fi Fp Fi[2]} FC3{ m FC4{ m FL}}}



static void Test_S601C28()
{
  extern Class_Descriptor cd_S601C28;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_S601C28, buf);
    S601C28 &lv = *(new (buf) S601C28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S601C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C28)");
    check_base_class_offset(lv, (S601C23*), 0, "S601C28");
    check_field_offset(lv, s601c28f0, ABISELECT(32,20), "S601C28.s601c28f0");
    test_class_info(&lv, &cd_S601C28);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS601C28(Test_S601C28, "S601C28", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd_S601C23;
static Base_Class bases_S601C28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S601C23,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S601C28 = {  "S601C28", // class name
  bases_S601C28, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C31  : S601C23 {
  int s601c31f0;
};
//SIG(-1 S601C31) C1{ BC2{ m Fp Fi Fp Fi[2]} Fi}



static void Test_S601C31()
{
  extern Class_Descriptor cd_S601C31;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_S601C31, buf);
    S601C31 &lv = *(new (buf) S601C31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(S601C31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C31)");
    check_base_class_offset(lv, (S601C23*), 0, "S601C31");
    check_field_offset(lv, s601c31f0, ABISELECT(32,20), "S601C31.s601c31f0");
    test_class_info(&lv, &cd_S601C31);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS601C31(Test_S601C31, "S601C31", ABISELECT(40,24));

#else // __cplusplus

extern Class_Descriptor cd_S601C23;
static Base_Class bases_S601C31[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S601C23,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S601C31 = {  "S601C31", // class name
  bases_S601C31, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C18  : S601C19 , S601C21_nt {
  ::S601C22 s601c18f0;
  ::S601C27 s601c18f1;
  ::S601C28 s601c18f2;
  ::S601C31 s601c18f3;
  virtual void  v44(); // _ZN7S601C183v44Ev
  virtual void  v45(); // _ZN7S601C183v45Ev
  virtual void  v46(); // _ZN7S601C183v46Ev
  virtual void  v47(); // _ZN7S601C183v47Ev
  virtual void  v48(); // _ZN7S601C183v48Ev
  virtual void  v49(); // _ZN7S601C183v49Ev
  ~S601C18(); // tgen
  S601C18(); // tgen
};
//SIG(-1 S601C18) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8}} FC10{ BC6 FC11{ m FC9}} FC12{ BC6 FC13{ m FC14{ m FL}}} FC15{ BC6 Fi}}


void  S601C18 ::v44(){vfunc_called(this, "_ZN7S601C183v44Ev");}
void  S601C18 ::v45(){vfunc_called(this, "_ZN7S601C183v45Ev");}
void  S601C18 ::v46(){vfunc_called(this, "_ZN7S601C183v46Ev");}
void  S601C18 ::v47(){vfunc_called(this, "_ZN7S601C183v47Ev");}
void  S601C18 ::v48(){vfunc_called(this, "_ZN7S601C183v48Ev");}
void  S601C18 ::v49(){vfunc_called(this, "_ZN7S601C183v49Ev");}
S601C18 ::~S601C18(){ note_dtor("S601C18", this);} // tgen
S601C18 ::S601C18(){ note_ctor("S601C18", this);} // tgen

static void Test_S601C18()
{
  extern Class_Descriptor cd_S601C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(34,49)];
    init_test(&cd_S601C18, buf);
    S601C18 *dp, &lv = *(dp=new (buf) S601C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(264,192), "sizeof(S601C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C18)");
    check_base_class_offset(lv, (S601C19*), 0, "S601C18");
    check_base_class_offset(lv, (S601C21_nt*), 0, "S601C18");
    check_field_offset(lv, s601c18f0, ABISELECT(40,20), "S601C18.s601c18f0");
    check_field_offset(lv, s601c18f1, ABISELECT(136,104), "S601C18.s601c18f1");
    check_field_offset(lv, s601c18f2, ABISELECT(184,140), "S601C18.s601c18f2");
    check_field_offset(lv, s601c18f3, ABISELECT(224,168), "S601C18.s601c18f3");
    test_class_info(&lv, &cd_S601C18);
    dp->~S601C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS601C18(Test_S601C18, "S601C18", ABISELECT(264,192));

#else // __cplusplus

extern void _ZN7S601C18C1Ev();
extern void _ZN7S601C18D1Ev();
Name_Map name_map_S601C18[] = {
  NSPAIR(_ZN7S601C18C1Ev),
  NSPAIR(_ZN7S601C18D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S601C19;
extern VTBL_ENTRY _ZTI7S601C19[];
extern  VTBL_ENTRY _ZTV7S601C19[];
extern Class_Descriptor cd_S601C21_nt;
extern VTBL_ENTRY _ZTI10S601C21_nt[];
static Base_Class bases_S601C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S601C19,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S601C21_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S601C18[];
extern void _ZN7S601C18D1Ev();
extern void _ZN7S601C18D0Ev();
extern void _ZN7S601C193v50Ev();
extern void _ZN7S601C193v51Ev();
extern void _ZN7S601C193v52Ev();
extern void _ZN7S601C193v53Ev();
extern void _ZN7S601C193v54Ev();
extern void _ZN7S601C193v55Ev();
extern void _ZN7S601C183v44Ev();
extern void _ZN7S601C183v45Ev();
extern void _ZN7S601C183v46Ev();
extern void _ZN7S601C183v47Ev();
extern void _ZN7S601C183v48Ev();
extern void _ZN7S601C183v49Ev();
static  VTBL_ENTRY vtc_S601C18[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S601C18[0]),
  (VTBL_ENTRY)&_ZN7S601C18D1Ev,
  (VTBL_ENTRY)&_ZN7S601C18D0Ev,
  (VTBL_ENTRY)&_ZN7S601C193v50Ev,
  (VTBL_ENTRY)&_ZN7S601C193v51Ev,
  (VTBL_ENTRY)&_ZN7S601C193v52Ev,
  (VTBL_ENTRY)&_ZN7S601C193v53Ev,
  (VTBL_ENTRY)&_ZN7S601C193v54Ev,
  (VTBL_ENTRY)&_ZN7S601C193v55Ev,
  (VTBL_ENTRY)&_ZN7S601C183v44Ev,
  (VTBL_ENTRY)&_ZN7S601C183v45Ev,
  (VTBL_ENTRY)&_ZN7S601C183v46Ev,
  (VTBL_ENTRY)&_ZN7S601C183v47Ev,
  (VTBL_ENTRY)&_ZN7S601C183v48Ev,
  (VTBL_ENTRY)&_ZN7S601C183v49Ev,
};
extern VTBL_ENTRY _ZTI7S601C18[];
extern  VTBL_ENTRY _ZTV7S601C18[];
Class_Descriptor cd_S601C18 = {  "S601C18", // class name
  bases_S601C18, 2,
  &(vtc_S601C18[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(264,192), // object size
  NSPAIRA(_ZTI7S601C18),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S601C18),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C34_nt  {
  virtual  ~S601C34_nt(); // _ZN10S601C34_ntD1Ev
  virtual void  v56(); // _ZN10S601C34_nt3v56Ev
  S601C34_nt(); // tgen
};
//SIG(-1 S601C34_nt) C1{ vd v1}


 S601C34_nt ::~S601C34_nt(){ note_dtor("S601C34_nt", this);}
void  S601C34_nt ::v56(){vfunc_called(this, "_ZN10S601C34_nt3v56Ev");}
S601C34_nt ::S601C34_nt(){ note_ctor("S601C34_nt", this);} // tgen

//skip512 S601C34_nt

#else // __cplusplus

extern void _ZN10S601C34_ntC1Ev();
extern void _ZN10S601C34_ntD1Ev();
Name_Map name_map_S601C34_nt[] = {
  NSPAIR(_ZN10S601C34_ntC1Ev),
  NSPAIR(_ZN10S601C34_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S601C34_nt[];
extern void _ZN10S601C34_ntD1Ev();
extern void _ZN10S601C34_ntD0Ev();
extern void _ZN10S601C34_nt3v56Ev();
static  VTBL_ENTRY vtc_S601C34_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S601C34_nt[0]),
  (VTBL_ENTRY)&_ZN10S601C34_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S601C34_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S601C34_nt3v56Ev,
};
extern VTBL_ENTRY _ZTI10S601C34_nt[];
VTBL_ENTRY *P__ZTI10S601C34_nt = _ZTI10S601C34_nt; 
extern  VTBL_ENTRY _ZTV10S601C34_nt[];
Class_Descriptor cd_S601C34_nt = {  "S601C34_nt", // class name
  0,0,//no base classes
  &(vtc_S601C34_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S601C34_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S601C34_nt),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C36  {
  void *s601c36f0;
  int s601c36f1;
  int s601c36f2;
  ::S3352C21_nt s601c36f3;
  void  mf601c36(); // _ZN7S601C368mf601c36Ev
};
//SIG(-1 S601C36) C1{ m Fp Fi[2] FC2{ m}}


void  S601C36 ::mf601c36(){}

static void Test_S601C36()
{
  {
    init_simple_test("S601C36");
    S601C36 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S601C36)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C36)");
    check_field_offset(lv, s601c36f0, 0, "S601C36.s601c36f0");
    check_field_offset(lv, s601c36f1, ABISELECT(8,4), "S601C36.s601c36f1");
    check_field_offset(lv, s601c36f2, ABISELECT(12,8), "S601C36.s601c36f2");
    check_field_offset(lv, s601c36f3, ABISELECT(16,12), "S601C36.s601c36f3");
  }
}
static Arrange_To_Call_Me vS601C36(Test_S601C36, "S601C36", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C35  {
  ::S601C36 s601c35f0;
  void  mf601c35(); // _ZN7S601C358mf601c35Ev
};
//SIG(-1 S601C35) C1{ m FC2{ m Fp Fi[2] FC3{ m}}}


void  S601C35 ::mf601c35(){}

static void Test_S601C35()
{
  {
    init_simple_test("S601C35");
    S601C35 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S601C35)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C35)");
    check_field_offset(lv, s601c35f0, 0, "S601C35.s601c35f0");
  }
}
static Arrange_To_Call_Me vS601C35(Test_S601C35, "S601C35", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C33  : S601C34_nt {
  void *s601c33f0;
  void *s601c33f1;
  ::S601C35 s601c33f2;
  ::S601C10 s601c33f3;
  virtual  ~S601C33(); // _ZN7S601C33D1Ev
  virtual void  v57(); // _ZN7S601C333v57Ev
  S601C33(); // tgen
};
//SIG(-1 S601C33) C1{ BC2{ vd v2} vd v1 Fp[2] FC3{ m FC4{ m Fp Fi[2] FC5{ m}}} FC6{ m Fp[2]}}


 S601C33 ::~S601C33(){ note_dtor("S601C33", this);}
void  S601C33 ::v57(){vfunc_called(this, "_ZN7S601C333v57Ev");}
S601C33 ::S601C33(){ note_ctor("S601C33", this);} // tgen

static void Test_S601C33()
{
  extern Class_Descriptor cd_S601C33;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_S601C33, buf);
    S601C33 *dp, &lv = *(dp=new (buf) S601C33());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(S601C33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C33)");
    check_base_class_offset(lv, (S601C34_nt*), 0, "S601C33");
    check_field_offset(lv, s601c33f0, ABISELECT(8,4), "S601C33.s601c33f0");
    check_field_offset(lv, s601c33f1, ABISELECT(16,8), "S601C33.s601c33f1");
    check_field_offset(lv, s601c33f2, ABISELECT(24,12), "S601C33.s601c33f2");
    check_field_offset(lv, s601c33f3, ABISELECT(48,28), "S601C33.s601c33f3");
    test_class_info(&lv, &cd_S601C33);
    dp->~S601C33();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS601C33(Test_S601C33, "S601C33", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7S601C33C1Ev();
extern void _ZN7S601C33D1Ev();
Name_Map name_map_S601C33[] = {
  NSPAIR(_ZN7S601C33C1Ev),
  NSPAIR(_ZN7S601C33D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S601C34_nt;
extern VTBL_ENTRY _ZTI10S601C34_nt[];
extern  VTBL_ENTRY _ZTV10S601C34_nt[];
static Base_Class bases_S601C33[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S601C34_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S601C33[];
extern void _ZN7S601C33D1Ev();
extern void _ZN7S601C33D0Ev();
extern void _ZN10S601C34_nt3v56Ev();
extern void _ZN7S601C333v57Ev();
static  VTBL_ENTRY vtc_S601C33[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S601C33[0]),
  (VTBL_ENTRY)&_ZN7S601C33D1Ev,
  (VTBL_ENTRY)&_ZN7S601C33D0Ev,
  (VTBL_ENTRY)&_ZN10S601C34_nt3v56Ev,
  (VTBL_ENTRY)&_ZN7S601C333v57Ev,
};
extern VTBL_ENTRY _ZTI7S601C33[];
extern  VTBL_ENTRY _ZTV7S601C33[];
Class_Descriptor cd_S601C33 = {  "S601C33", // class name
  bases_S601C33, 1,
  &(vtc_S601C33[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7S601C33),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S601C33),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C40  {
  short s601c40f0;
  short s601c40f1;
  char s601c40f2;
  char s601c40f3;
  short s601c40f4;
};
//SIG(1 S601C40) C1{ Fs[2] Fc[2] Fs}



static void Test_S601C40()
{
  {
    init_simple_test("S601C40");
    S601C40 lv;
    check2(sizeof(lv), 8, "sizeof(S601C40)");
    check2(__alignof__(lv), 2, "__alignof__(S601C40)");
    check_field_offset(lv, s601c40f0, 0, "S601C40.s601c40f0");
    check_field_offset(lv, s601c40f1, 2, "S601C40.s601c40f1");
    check_field_offset(lv, s601c40f2, 4, "S601C40.s601c40f2");
    check_field_offset(lv, s601c40f3, 5, "S601C40.s601c40f3");
    check_field_offset(lv, s601c40f4, 6, "S601C40.s601c40f4");
  }
}
static Arrange_To_Call_Me vS601C40(Test_S601C40, "S601C40", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C41  {
  short s601c41f0;
  short s601c41f1;
};
//SIG(-1 S601C41) C1{ Fs[2]}



static void Test_S601C41()
{
  {
    init_simple_test("S601C41");
    S601C41 lv;
    check2(sizeof(lv), 4, "sizeof(S601C41)");
    check2(__alignof__(lv), 2, "__alignof__(S601C41)");
    check_field_offset(lv, s601c41f0, 0, "S601C41.s601c41f0");
    check_field_offset(lv, s601c41f1, 2, "S601C41.s601c41f1");
  }
}
static Arrange_To_Call_Me vS601C41(Test_S601C41, "S601C41", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C42  {
  void *s601c42f0;
  void *s601c42f1;
  void  mf601c42(); // _ZN7S601C428mf601c42Ev
};
//SIG(-1 S601C42) C1{ m Fp[2]}


void  S601C42 ::mf601c42(){}

static void Test_S601C42()
{
  {
    init_simple_test("S601C42");
    S601C42 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S601C42)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C42)");
    check_field_offset(lv, s601c42f0, 0, "S601C42.s601c42f0");
    check_field_offset(lv, s601c42f1, ABISELECT(8,4), "S601C42.s601c42f1");
  }
}
static Arrange_To_Call_Me vS601C42(Test_S601C42, "S601C42", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C39  {
  ::S601C40 s601c39f0[12];
  int s601c39f1;
  ::S601C41 s601c39f2[4];
  int s601c39f3;
  ::S601C42 s601c39f4;
  void  mf601c39(); // _ZN7S601C398mf601c39Ev
};
//SIG(-1 S601C39) C1{ m FC2{ Fs[2] Fc[2] Fs}[12] Fi FC3{ Fs[2]}[4] Fi FC4{ m Fp[2]}}


void  S601C39 ::mf601c39(){}

static void Test_S601C39()
{
  {
    init_simple_test("S601C39");
    S601C39 lv;
    check2(sizeof(lv), ABISELECT(136,128), "sizeof(S601C39)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C39)");
    check_field_offset(lv, s601c39f0, 0, "S601C39.s601c39f0");
    check_field_offset(lv, s601c39f1, 96, "S601C39.s601c39f1");
    check_field_offset(lv, s601c39f2, 100, "S601C39.s601c39f2");
    check_field_offset(lv, s601c39f3, 116, "S601C39.s601c39f3");
    check_field_offset(lv, s601c39f4, 120, "S601C39.s601c39f4");
  }
}
static Arrange_To_Call_Me vS601C39(Test_S601C39, "S601C39", ABISELECT(136,128));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C32  : S601C33 {
  ::S601C39 s601c32f0;
  virtual  ~S601C32(); // _ZN7S601C32D1Ev
  S601C32(); // tgen
};
//SIG(-1 S601C32) C1{ BC2{ BC3{ vd v1} vd v2 Fp[2] FC4{ m FC5{ m Fp Fi[2] FC6{ m}}} FC7{ m Fp[2]}} vd FC8{ m FC9{ Fs[2] Fc[2] Fs}[12] Fi FC10{ Fs[2]}[4] Fi FC11{ m Fp[2]}}}


 S601C32 ::~S601C32(){ note_dtor("S601C32", this);}
S601C32 ::S601C32(){ note_ctor("S601C32", this);} // tgen

static void Test_S601C32()
{
  extern Class_Descriptor cd_S601C32;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,42)];
    init_test(&cd_S601C32, buf);
    S601C32 *dp, &lv = *(dp=new (buf) S601C32());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,164), "sizeof(S601C32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C32)");
    check_base_class_offset(lv, (S601C34_nt*)(S601C33*), 0, "S601C32");
    check_base_class_offset(lv, (S601C33*), 0, "S601C32");
    check_field_offset(lv, s601c32f0, ABISELECT(64,36), "S601C32.s601c32f0");
    test_class_info(&lv, &cd_S601C32);
    dp->~S601C32();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS601C32(Test_S601C32, "S601C32", ABISELECT(200,164));

#else // __cplusplus

extern void _ZN7S601C32C1Ev();
extern void _ZN7S601C32D1Ev();
Name_Map name_map_S601C32[] = {
  NSPAIR(_ZN7S601C32C1Ev),
  NSPAIR(_ZN7S601C32D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S601C34_nt;
extern VTBL_ENTRY _ZTI10S601C34_nt[];
extern  VTBL_ENTRY _ZTV10S601C34_nt[];
extern Class_Descriptor cd_S601C33;
extern VTBL_ENTRY _ZTI7S601C33[];
extern  VTBL_ENTRY _ZTV7S601C33[];
static Base_Class bases_S601C32[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S601C34_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S601C33,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S601C32[];
extern void _ZN7S601C32D1Ev();
extern void _ZN7S601C32D0Ev();
extern void _ZN10S601C34_nt3v56Ev();
extern void _ZN7S601C333v57Ev();
static  VTBL_ENTRY vtc_S601C32[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S601C32[0]),
  (VTBL_ENTRY)&_ZN7S601C32D1Ev,
  (VTBL_ENTRY)&_ZN7S601C32D0Ev,
  (VTBL_ENTRY)&_ZN10S601C34_nt3v56Ev,
  (VTBL_ENTRY)&_ZN7S601C333v57Ev,
};
extern VTBL_ENTRY _ZTI7S601C32[];
extern  VTBL_ENTRY _ZTV7S601C32[];
Class_Descriptor cd_S601C32 = {  "S601C32", // class name
  bases_S601C32, 2,
  &(vtc_S601C32[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(200,164), // object size
  NSPAIRA(_ZTI7S601C32),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S601C32),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C17  {
  ::S601C18 s601c17f0;
  ::S601C32 s601c17f1;
  void  mf601c17(); // _ZN7S601C178mf601c17Ev
};
//SIG(-1 S601C17) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m FC10{ m FL[2]}} FC9 FC9 FC9}} FC11{ BC7 FC12{ m FC10}} FC13{ BC7 FC14{ m FC15{ m FL}}} FC16{ BC7 Fi}} FC17{ BC18{ BC19{ vd v13} vd v14 Fp[2] FC20{ m FC21{ m Fp Fi[2] FC22{ m}}} FC23{ m Fp[2]}} vd FC24{ m FC25{ Fs[2] Fc[2] Fs}[12] Fi FC26{ Fs[2]}[4] Fi FC27{ m Fp[2]}}}}


void  S601C17 ::mf601c17(){}

static void Test_S601C17()
{
  {
    init_simple_test("S601C17");
    S601C17 lv;
    check2(sizeof(lv), ABISELECT(464,356), "sizeof(S601C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C17)");
    check_field_offset(lv, s601c17f0, 0, "S601C17.s601c17f0");
    check_field_offset(lv, s601c17f1, ABISELECT(264,192), "S601C17.s601c17f1");
  }
}
static Arrange_To_Call_Me vS601C17(Test_S601C17, "S601C17", ABISELECT(464,356));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C46  {
  ::S601C42 s601c46f0;
  ::S601C13_nt s601c46f1;
  void  mf601c46(); // _ZN7S601C468mf601c46Ev
};
//SIG(-1 S601C46) C1{ m FC2{ m Fp[2]} FC3{ m Fp}}


void  S601C46 ::mf601c46(){}

static void Test_S601C46()
{
  {
    init_simple_test("S601C46");
    S601C46 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S601C46)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C46)");
    check_field_offset(lv, s601c46f0, 0, "S601C46.s601c46f0");
    check_field_offset(lv, s601c46f1, ABISELECT(16,8), "S601C46.s601c46f1");
  }
}
static Arrange_To_Call_Me vS601C46(Test_S601C46, "S601C46", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C45  : S601C23 {
  ::S601C46 s601c45f0;
};
//SIG(-1 S601C45) C1{ BC2{ m Fp Fi Fp Fi[2]} FC3{ m FC4{ m Fp[2]} FC5{ m Fp}}}



static void Test_S601C45()
{
  extern Class_Descriptor cd_S601C45;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_S601C45, buf);
    S601C45 &lv = *(new (buf) S601C45());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S601C45)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C45)");
    check_base_class_offset(lv, (S601C23*), 0, "S601C45");
    check_field_offset(lv, s601c45f0, ABISELECT(32,20), "S601C45.s601c45f0");
    test_class_info(&lv, &cd_S601C45);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS601C45(Test_S601C45, "S601C45", ABISELECT(56,32));

#else // __cplusplus

extern Class_Descriptor cd_S601C23;
static Base_Class bases_S601C45[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S601C23,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S601C45 = {  "S601C45", // class name
  bases_S601C45, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(56,32), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C44  : S601C19 , S601C21_nt {
  ::S601C45 s601c44f0;
  ::S601C45 s601c44f1;
  ::S601C31 s601c44f2;
  ::S601C27 s601c44f3;
  virtual void  v58(); // _ZN7S601C443v58Ev
  virtual void  v59(); // _ZN7S601C443v59Ev
  virtual void  v60(); // _ZN7S601C443v60Ev
  virtual void  v61(); // _ZN7S601C443v61Ev
  virtual void  v62(); // _ZN7S601C443v62Ev
  virtual void  v63(); // _ZN7S601C443v63Ev
  ~S601C44(); // tgen
  S601C44(); // tgen
};
//SIG(-1 S601C44) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m Fp[2]} FC9{ m Fp}}} FC5 FC10{ BC6 Fi} FC11{ BC6 FC12{ m FC13{ m FL[2]}}}}


void  S601C44 ::v58(){vfunc_called(this, "_ZN7S601C443v58Ev");}
void  S601C44 ::v59(){vfunc_called(this, "_ZN7S601C443v59Ev");}
void  S601C44 ::v60(){vfunc_called(this, "_ZN7S601C443v60Ev");}
void  S601C44 ::v61(){vfunc_called(this, "_ZN7S601C443v61Ev");}
void  S601C44 ::v62(){vfunc_called(this, "_ZN7S601C443v62Ev");}
void  S601C44 ::v63(){vfunc_called(this, "_ZN7S601C443v63Ev");}
S601C44 ::~S601C44(){ note_dtor("S601C44", this);} // tgen
S601C44 ::S601C44(){ note_ctor("S601C44", this);} // tgen

static void Test_S601C44()
{
  extern Class_Descriptor cd_S601C44;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(31,37)];
    init_test(&cd_S601C44, buf);
    S601C44 *dp, &lv = *(dp=new (buf) S601C44());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(240,144), "sizeof(S601C44)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C44)");
    check_base_class_offset(lv, (S601C19*), 0, "S601C44");
    check_base_class_offset(lv, (S601C21_nt*), 0, "S601C44");
    check_field_offset(lv, s601c44f0, ABISELECT(40,20), "S601C44.s601c44f0");
    check_field_offset(lv, s601c44f1, ABISELECT(96,52), "S601C44.s601c44f1");
    check_field_offset(lv, s601c44f2, ABISELECT(152,84), "S601C44.s601c44f2");
    check_field_offset(lv, s601c44f3, ABISELECT(192,108), "S601C44.s601c44f3");
    test_class_info(&lv, &cd_S601C44);
    dp->~S601C44();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS601C44(Test_S601C44, "S601C44", ABISELECT(240,144));

#else // __cplusplus

extern void _ZN7S601C44C1Ev();
extern void _ZN7S601C44D1Ev();
Name_Map name_map_S601C44[] = {
  NSPAIR(_ZN7S601C44C1Ev),
  NSPAIR(_ZN7S601C44D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S601C19;
extern VTBL_ENTRY _ZTI7S601C19[];
extern  VTBL_ENTRY _ZTV7S601C19[];
extern Class_Descriptor cd_S601C21_nt;
extern VTBL_ENTRY _ZTI10S601C21_nt[];
static Base_Class bases_S601C44[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S601C19,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S601C21_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S601C44[];
extern void _ZN7S601C44D1Ev();
extern void _ZN7S601C44D0Ev();
extern void _ZN7S601C193v50Ev();
extern void _ZN7S601C193v51Ev();
extern void _ZN7S601C193v52Ev();
extern void _ZN7S601C193v53Ev();
extern void _ZN7S601C193v54Ev();
extern void _ZN7S601C193v55Ev();
extern void _ZN7S601C443v58Ev();
extern void _ZN7S601C443v59Ev();
extern void _ZN7S601C443v60Ev();
extern void _ZN7S601C443v61Ev();
extern void _ZN7S601C443v62Ev();
extern void _ZN7S601C443v63Ev();
static  VTBL_ENTRY vtc_S601C44[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S601C44[0]),
  (VTBL_ENTRY)&_ZN7S601C44D1Ev,
  (VTBL_ENTRY)&_ZN7S601C44D0Ev,
  (VTBL_ENTRY)&_ZN7S601C193v50Ev,
  (VTBL_ENTRY)&_ZN7S601C193v51Ev,
  (VTBL_ENTRY)&_ZN7S601C193v52Ev,
  (VTBL_ENTRY)&_ZN7S601C193v53Ev,
  (VTBL_ENTRY)&_ZN7S601C193v54Ev,
  (VTBL_ENTRY)&_ZN7S601C193v55Ev,
  (VTBL_ENTRY)&_ZN7S601C443v58Ev,
  (VTBL_ENTRY)&_ZN7S601C443v59Ev,
  (VTBL_ENTRY)&_ZN7S601C443v60Ev,
  (VTBL_ENTRY)&_ZN7S601C443v61Ev,
  (VTBL_ENTRY)&_ZN7S601C443v62Ev,
  (VTBL_ENTRY)&_ZN7S601C443v63Ev,
};
extern VTBL_ENTRY _ZTI7S601C44[];
extern  VTBL_ENTRY _ZTV7S601C44[];
Class_Descriptor cd_S601C44 = {  "S601C44", // class name
  bases_S601C44, 2,
  &(vtc_S601C44[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(240,144), // object size
  NSPAIRA(_ZTI7S601C44),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S601C44),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C53  {
  void *s601c53f0;
  void *s601c53f1;
  void  mf601c53(); // _ZN7S601C538mf601c53Ev
};
//SIG(-1 S601C53) C1{ m Fp[2]}


void  S601C53 ::mf601c53(){}

static void Test_S601C53()
{
  {
    init_simple_test("S601C53");
    S601C53 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S601C53)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C53)");
    check_field_offset(lv, s601c53f0, 0, "S601C53.s601c53f0");
    check_field_offset(lv, s601c53f1, ABISELECT(8,4), "S601C53.s601c53f1");
  }
}
static Arrange_To_Call_Me vS601C53(Test_S601C53, "S601C53", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C49  : S601C34_nt {
  void *s601c49f0;
  void *s601c49f1;
  ::S601C35 s601c49f2;
  ::S601C53 s601c49f3;
  virtual  ~S601C49(); // _ZN7S601C49D1Ev
  virtual void  v64(); // _ZN7S601C493v64Ev
  S601C49(); // tgen
};
//SIG(-1 S601C49) C1{ BC2{ vd v2} vd v1 Fp[2] FC3{ m FC4{ m Fp Fi[2] FC5{ m}}} FC6{ m Fp[2]}}


 S601C49 ::~S601C49(){ note_dtor("S601C49", this);}
void  S601C49 ::v64(){vfunc_called(this, "_ZN7S601C493v64Ev");}
S601C49 ::S601C49(){ note_ctor("S601C49", this);} // tgen

static void Test_S601C49()
{
  extern Class_Descriptor cd_S601C49;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_S601C49, buf);
    S601C49 *dp, &lv = *(dp=new (buf) S601C49());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(S601C49)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C49)");
    check_base_class_offset(lv, (S601C34_nt*), 0, "S601C49");
    check_field_offset(lv, s601c49f0, ABISELECT(8,4), "S601C49.s601c49f0");
    check_field_offset(lv, s601c49f1, ABISELECT(16,8), "S601C49.s601c49f1");
    check_field_offset(lv, s601c49f2, ABISELECT(24,12), "S601C49.s601c49f2");
    check_field_offset(lv, s601c49f3, ABISELECT(48,28), "S601C49.s601c49f3");
    test_class_info(&lv, &cd_S601C49);
    dp->~S601C49();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS601C49(Test_S601C49, "S601C49", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7S601C49C1Ev();
extern void _ZN7S601C49D1Ev();
Name_Map name_map_S601C49[] = {
  NSPAIR(_ZN7S601C49C1Ev),
  NSPAIR(_ZN7S601C49D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S601C34_nt;
extern VTBL_ENTRY _ZTI10S601C34_nt[];
extern  VTBL_ENTRY _ZTV10S601C34_nt[];
static Base_Class bases_S601C49[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S601C34_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S601C49[];
extern void _ZN7S601C49D1Ev();
extern void _ZN7S601C49D0Ev();
extern void _ZN10S601C34_nt3v56Ev();
extern void _ZN7S601C493v64Ev();
static  VTBL_ENTRY vtc_S601C49[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S601C49[0]),
  (VTBL_ENTRY)&_ZN7S601C49D1Ev,
  (VTBL_ENTRY)&_ZN7S601C49D0Ev,
  (VTBL_ENTRY)&_ZN10S601C34_nt3v56Ev,
  (VTBL_ENTRY)&_ZN7S601C493v64Ev,
};
extern VTBL_ENTRY _ZTI7S601C49[];
extern  VTBL_ENTRY _ZTV7S601C49[];
Class_Descriptor cd_S601C49 = {  "S601C49", // class name
  bases_S601C49, 1,
  &(vtc_S601C49[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7S601C49),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S601C49),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C55_nt  {
  char s601c55f0;
  char s601c55f1:4;
  char s601c55f2:4;
  char s601c55f3:4;
  char s601c55f4:4;
  char s601c55f5:4;
  char s601c55f6:4;
};
//SIG(-1 S601C55_nt) C1{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4}



//skip512 S601C55_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C54  {
  void *s601c54f0;
  int s601c54f1;
  ::S601C55_nt s601c54f2;
  int s601c54f3;
  ::S601C42 s601c54f4;
  void  mf601c54(); // _ZN7S601C548mf601c54Ev
};
//SIG(-1 S601C54) C1{ m Fp Fi FC2{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC3{ m Fp[2]}}


void  S601C54 ::mf601c54(){}

static void Test_S601C54()
{
  {
    init_simple_test("S601C54");
    static S601C54 lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(S601C54)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C54)");
    check_field_offset(lv, s601c54f0, 0, "S601C54.s601c54f0");
    check_field_offset(lv, s601c54f1, ABISELECT(8,4), "S601C54.s601c54f1");
    check_field_offset(lv, s601c54f2, ABISELECT(12,8), "S601C54.s601c54f2");
    check_field_offset(lv, s601c54f3, ABISELECT(16,12), "S601C54.s601c54f3");
    check_field_offset(lv, s601c54f4, ABISELECT(24,16), "S601C54.s601c54f4");
  }
}
static Arrange_To_Call_Me vS601C54(Test_S601C54, "S601C54", ABISELECT(40,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C48  : S601C49 {
  ::S601C54 s601c48f0;
  virtual  ~S601C48(); // _ZN7S601C48D1Ev
  S601C48(); // tgen
};
//SIG(-1 S601C48) C1{ BC2{ BC3{ vd v1} vd v2 Fp[2] FC4{ m FC5{ m Fp Fi[2] FC6{ m}}} FC7{ m Fp[2]}} vd FC8{ m Fp Fi FC9{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC10{ m Fp[2]}}}


 S601C48 ::~S601C48(){ note_dtor("S601C48", this);}
S601C48 ::S601C48(){ note_ctor("S601C48", this);} // tgen

static void Test_S601C48()
{
  extern Class_Descriptor cd_S601C48;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,16)];
    init_test(&cd_S601C48, buf);
    S601C48 *dp, &lv = *(dp=new (buf) S601C48());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,60), "sizeof(S601C48)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C48)");
    check_base_class_offset(lv, (S601C34_nt*)(S601C49*), 0, "S601C48");
    check_base_class_offset(lv, (S601C49*), 0, "S601C48");
    check_field_offset(lv, s601c48f0, ABISELECT(64,36), "S601C48.s601c48f0");
    test_class_info(&lv, &cd_S601C48);
    dp->~S601C48();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS601C48(Test_S601C48, "S601C48", ABISELECT(104,60));

#else // __cplusplus

extern void _ZN7S601C48C1Ev();
extern void _ZN7S601C48D1Ev();
Name_Map name_map_S601C48[] = {
  NSPAIR(_ZN7S601C48C1Ev),
  NSPAIR(_ZN7S601C48D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S601C34_nt;
extern VTBL_ENTRY _ZTI10S601C34_nt[];
extern  VTBL_ENTRY _ZTV10S601C34_nt[];
extern Class_Descriptor cd_S601C49;
extern VTBL_ENTRY _ZTI7S601C49[];
extern  VTBL_ENTRY _ZTV7S601C49[];
static Base_Class bases_S601C48[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S601C34_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S601C49,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S601C48[];
extern void _ZN7S601C48D1Ev();
extern void _ZN7S601C48D0Ev();
extern void _ZN10S601C34_nt3v56Ev();
extern void _ZN7S601C493v64Ev();
static  VTBL_ENTRY vtc_S601C48[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S601C48[0]),
  (VTBL_ENTRY)&_ZN7S601C48D1Ev,
  (VTBL_ENTRY)&_ZN7S601C48D0Ev,
  (VTBL_ENTRY)&_ZN10S601C34_nt3v56Ev,
  (VTBL_ENTRY)&_ZN7S601C493v64Ev,
};
extern VTBL_ENTRY _ZTI7S601C48[];
extern  VTBL_ENTRY _ZTV7S601C48[];
Class_Descriptor cd_S601C48 = {  "S601C48", // class name
  bases_S601C48, 2,
  &(vtc_S601C48[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,60), // object size
  NSPAIRA(_ZTI7S601C48),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S601C48),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C43  {
  ::S601C44 s601c43f0;
  ::S601C48 s601c43f1;
  void  mf601c43(); // _ZN7S601C438mf601c43Ev
};
//SIG(-1 S601C43) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}} FC6 FC11{ BC7 Fi} FC12{ BC7 FC13{ m FC14{ m FL[2]}}}} FC15{ BC16{ BC17{ vd v13} vd v14 Fp[2] FC18{ m FC19{ m Fp Fi[2] FC20{ m}}} FC21{ m Fp[2]}} vd FC22{ m Fp Fi FC23{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC9}}}


void  S601C43 ::mf601c43(){}

static void Test_S601C43()
{
  {
    init_simple_test("S601C43");
    static S601C43 lv;
    check2(sizeof(lv), ABISELECT(344,204), "sizeof(S601C43)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C43)");
    check_field_offset(lv, s601c43f0, 0, "S601C43.s601c43f0");
    check_field_offset(lv, s601c43f1, ABISELECT(240,144), "S601C43.s601c43f1");
  }
}
static Arrange_To_Call_Me vS601C43(Test_S601C43, "S601C43", ABISELECT(344,204));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C16  {
  ::S601C17 s601c16f0;
  ::S601C43 s601c16f1;
  void  mf601c16(); // _ZN7S601C168mf601c16Ev
};
//SIG(-1 S601C16) C1{ m FC2{ m FC3{ BC4{ vd v7 v8 v9 v10 v11 v12 FC5{ m Fp[4]}} BC6{} v1 v2 v3 v4 v5 v6 FC7{ BC8{ m Fp Fi Fp Fi[2]} FC9{ m FC10{ m FC11{ m FL[2]}} FC10 FC10 FC10}} FC12{ BC8 FC13{ m FC11}} FC14{ BC8 FC15{ m FC16{ m FL}}} FC17{ BC8 Fi}} FC18{ BC19{ BC20{ vd v13} vd v14 Fp[2] FC21{ m FC22{ m Fp Fi[2] FC23{ m}}} FC24{ m Fp[2]}} vd FC25{ m FC26{ Fs[2] Fc[2] Fs}[12] Fi FC27{ Fs[2]}[4] Fi FC28{ m Fp[2]}}}} FC29{ m FC30{ BC4 BC6 v15 v16 v17 v18 v19 v20 FC31{ BC8 FC32{ m FC28 FC33{ m Fp}}} FC31 FC17 FC12} FC34{ BC35{ BC20 vd v21 Fp[2] FC21 FC36{ m Fp[2]}} vd FC37{ m Fp Fi FC38{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC28}}}}


void  S601C16 ::mf601c16(){}

static void Test_S601C16()
{
  {
    init_simple_test("S601C16");
    static S601C16 lv;
    check2(sizeof(lv), ABISELECT(808,560), "sizeof(S601C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C16)");
    check_field_offset(lv, s601c16f0, 0, "S601C16.s601c16f0");
    check_field_offset(lv, s601c16f1, ABISELECT(464,356), "S601C16.s601c16f1");
  }
}
static Arrange_To_Call_Me vS601C16(Test_S601C16, "S601C16", ABISELECT(808,560));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S601C1  : S601C2 {
  ::S601C16 s601c1f0;
  virtual  ~S601C1(); // _ZN6S601C1D1Ev
  virtual void  v1(); // _ZN6S601C12v1Ev
  virtual void  v2(); // _ZN6S601C12v2Ev
  virtual void  v3(); // _ZN6S601C12v3Ev
  virtual void  v4(); // _ZN6S601C12v4Ev
  S601C1(); // tgen
};
//SIG(1 S601C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 FC6{ m FC7{ m FL[2]}} FC6 Fp Fi FU8{ m FC9{ Fi:4 Fi:4 Fi:4 Fi:2 Fi:1 Fi:17} Fi} Fi:2 Fi:2 Fc:1 Fc:1 FC10{ m Fp Fp} FC11{ Fp Fp}[2]} vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc Fi[2] Fi[2] Fp FC6 FC6 FC6 FC12{ m FC6 FC6} Fp Fi Fi FC13{ m Fp}[4] Fp} vd v35 v36 v37 v38 v39 FC13 FC13 FC13 FC13 FC6 FC6 FC6 FC6 FC14{ m FC15{ m FL FL}}} vd v40 v41 v42 v43} vd v1 v2 v3 v4 FC16{ m FC17{ m FC18{ BC19{ vd v50 v51 v52 v53 v54 v55 FC20{ m Fp Fp Fp Fp}} BC21{} v44 v45 v46 v47 v48 v49 FC22{ BC23{ m Fp Fi Fp Fi Fi} FC24{ m FC6 FC6 FC6 FC6}} FC25{ BC23 FC26{ m FC7}} FC27{ BC23 FC28{ m FC29{ m FL}}} FC30{ BC23 Fi}} FC31{ BC32{ BC33{ vd v56} vd v57 Fp Fp FC34{ m FC35{ m Fp Fi Fi FC36{ m}}} FC10} vd FC37{ m FC38{ Fs Fs Fc Fc Fs}[12] Fi FC39{ Fs Fs}[4] Fi FC40{ m Fp Fp}}}} FC41{ m FC42{ BC19 BC21 v58 v59 v60 v61 v62 v63 FC43{ BC23 FC44{ m FC40 FC13}} FC43 FC30 FC25} FC45{ BC46{ BC33 vd v64 Fp Fp FC34 FC47{ m Fp Fp}} vd FC48{ m Fp Fi FC49{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC40}}}}}


 S601C1 ::~S601C1(){ note_dtor("S601C1", this);}
void  S601C1 ::v1(){vfunc_called(this, "_ZN6S601C12v1Ev");}
void  S601C1 ::v2(){vfunc_called(this, "_ZN6S601C12v2Ev");}
void  S601C1 ::v3(){vfunc_called(this, "_ZN6S601C12v3Ev");}
void  S601C1 ::v4(){vfunc_called(this, "_ZN6S601C12v4Ev");}
S601C1 ::S601C1(){ note_ctor("S601C1", this);} // tgen

static void Test_S601C1()
{
  extern Class_Descriptor cd_S601C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(151,218)];
    init_test(&cd_S601C1, buf);
    S601C1 *dp, &lv = *(dp=new (buf) S601C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1200,868), "sizeof(S601C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S601C1)");
    check_base_class_offset(lv, (S601C5*)(S601C4*)(S601C3*)(S601C2*), 0, "S601C1");
    check_base_class_offset(lv, (S601C4*)(S601C3*)(S601C2*), 0, "S601C1");
    check_base_class_offset(lv, (S601C3*)(S601C2*), 0, "S601C1");
    check_base_class_offset(lv, (S601C2*), 0, "S601C1");
    check_field_offset(lv, s601c1f0, ABISELECT(392,308), "S601C1.s601c1f0");
    test_class_info(&lv, &cd_S601C1);
    dp->~S601C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS601C1(Test_S601C1, "S601C1", ABISELECT(1200,868));

#else // __cplusplus

extern void _ZN6S601C1C1Ev();
extern void _ZN6S601C1D1Ev();
Name_Map name_map_S601C1[] = {
  NSPAIR(_ZN6S601C1C1Ev),
  NSPAIR(_ZN6S601C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S601C5;
extern VTBL_ENTRY _ZTI6S601C5[];
extern  VTBL_ENTRY _ZTV6S601C5[];
extern Class_Descriptor cd_S601C4;
extern VTBL_ENTRY _ZTI6S601C4[];
extern  VTBL_ENTRY _ZTV6S601C4[];
extern Class_Descriptor cd_S601C3;
extern VTBL_ENTRY _ZTI6S601C3[];
extern  VTBL_ENTRY _ZTV6S601C3[];
extern Class_Descriptor cd_S601C2;
extern VTBL_ENTRY _ZTI6S601C2[];
extern  VTBL_ENTRY _ZTV6S601C2[];
static Base_Class bases_S601C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S601C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S601C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S601C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S601C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S601C1[];
extern void _ZN6S601C1D1Ev();
extern void _ZN6S601C1D0Ev();
extern void _ZN6S601C52v5Ev();
extern void _ZN6S601C52v6Ev();
extern void _ZN6S601C52v7Ev();
extern void _ZN6S601C52v8Ev();
extern void _ZN6S601C52v9Ev();
extern void _ZN6S601C53v10Ev();
extern void _ZN6S601C53v11Ev();
extern void _ZN6S601C53v12Ev();
extern void _ZN6S601C53v13Ev();
extern void _ZN6S601C53v14Ev();
extern void _ZN6S601C53v15Ev();
extern void _ZN6S601C53v16Ev();
extern void _ZN6S601C53v17Ev();
extern void _ZN6S601C53v18Ev();
extern void _ZN6S601C53v19Ev();
extern void _ZN6S601C43v20Ev();
extern void _ZN6S601C43v21Ev();
extern void _ZN6S601C43v22Ev();
extern void _ZN6S601C43v23Ev();
extern void _ZN6S601C43v24Ev();
extern void _ZN6S601C43v25Ev();
extern void _ZN6S601C43v26Ev();
extern void _ZN6S601C43v27Ev();
extern void _ZN6S601C43v28Ev();
extern void _ZN6S601C43v29Ev();
extern void _ZN6S601C43v30Ev();
extern void _ZN6S601C43v31Ev();
extern void _ZN6S601C43v32Ev();
extern void _ZN6S601C43v33Ev();
extern void _ZN6S601C43v34Ev();
extern void _ZN6S601C33v35Ev();
extern void _ZN6S601C33v36Ev();
extern void _ZN6S601C33v37Ev();
extern void _ZN6S601C33v38Ev();
extern void _ZN6S601C33v39Ev();
extern void _ZN6S601C23v40Ev();
extern void _ZN6S601C23v41Ev();
extern void _ZN6S601C23v42Ev();
extern void _ZN6S601C23v43Ev();
extern void _ZN6S601C12v1Ev();
extern void _ZN6S601C12v2Ev();
extern void _ZN6S601C12v3Ev();
extern void _ZN6S601C12v4Ev();
static  VTBL_ENTRY vtc_S601C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S601C1[0]),
  (VTBL_ENTRY)&_ZN6S601C1D1Ev,
  (VTBL_ENTRY)&_ZN6S601C1D0Ev,
  (VTBL_ENTRY)&_ZN6S601C52v5Ev,
  (VTBL_ENTRY)&_ZN6S601C52v6Ev,
  (VTBL_ENTRY)&_ZN6S601C52v7Ev,
  (VTBL_ENTRY)&_ZN6S601C52v8Ev,
  (VTBL_ENTRY)&_ZN6S601C52v9Ev,
  (VTBL_ENTRY)&_ZN6S601C53v10Ev,
  (VTBL_ENTRY)&_ZN6S601C53v11Ev,
  (VTBL_ENTRY)&_ZN6S601C53v12Ev,
  (VTBL_ENTRY)&_ZN6S601C53v13Ev,
  (VTBL_ENTRY)&_ZN6S601C53v14Ev,
  (VTBL_ENTRY)&_ZN6S601C53v15Ev,
  (VTBL_ENTRY)&_ZN6S601C53v16Ev,
  (VTBL_ENTRY)&_ZN6S601C53v17Ev,
  (VTBL_ENTRY)&_ZN6S601C53v18Ev,
  (VTBL_ENTRY)&_ZN6S601C53v19Ev,
  (VTBL_ENTRY)&_ZN6S601C43v20Ev,
  (VTBL_ENTRY)&_ZN6S601C43v21Ev,
  (VTBL_ENTRY)&_ZN6S601C43v22Ev,
  (VTBL_ENTRY)&_ZN6S601C43v23Ev,
  (VTBL_ENTRY)&_ZN6S601C43v24Ev,
  (VTBL_ENTRY)&_ZN6S601C43v25Ev,
  (VTBL_ENTRY)&_ZN6S601C43v26Ev,
  (VTBL_ENTRY)&_ZN6S601C43v27Ev,
  (VTBL_ENTRY)&_ZN6S601C43v28Ev,
  (VTBL_ENTRY)&_ZN6S601C43v29Ev,
  (VTBL_ENTRY)&_ZN6S601C43v30Ev,
  (VTBL_ENTRY)&_ZN6S601C43v31Ev,
  (VTBL_ENTRY)&_ZN6S601C43v32Ev,
  (VTBL_ENTRY)&_ZN6S601C43v33Ev,
  (VTBL_ENTRY)&_ZN6S601C43v34Ev,
  (VTBL_ENTRY)&_ZN6S601C33v35Ev,
  (VTBL_ENTRY)&_ZN6S601C33v36Ev,
  (VTBL_ENTRY)&_ZN6S601C33v37Ev,
  (VTBL_ENTRY)&_ZN6S601C33v38Ev,
  (VTBL_ENTRY)&_ZN6S601C33v39Ev,
  (VTBL_ENTRY)&_ZN6S601C23v40Ev,
  (VTBL_ENTRY)&_ZN6S601C23v41Ev,
  (VTBL_ENTRY)&_ZN6S601C23v42Ev,
  (VTBL_ENTRY)&_ZN6S601C23v43Ev,
  (VTBL_ENTRY)&_ZN6S601C12v1Ev,
  (VTBL_ENTRY)&_ZN6S601C12v2Ev,
  (VTBL_ENTRY)&_ZN6S601C12v3Ev,
  (VTBL_ENTRY)&_ZN6S601C12v4Ev,
};
extern VTBL_ENTRY _ZTI6S601C1[];
extern  VTBL_ENTRY _ZTV6S601C1[];
Class_Descriptor cd_S601C1 = {  "S601C1", // class name
  bases_S601C1, 4,
  &(vtc_S601C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1200,868), // object size
  NSPAIRA(_ZTI6S601C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S601C1),47, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S602C5  {
  ::S2120C13_nt s602c5f0;
  ::S2120C13_nt s602c5f1;
  void *s602c5f2;
  int s602c5f3;
  ::S601C8 s602c5f4;
  int s602c5f5:2;
  int s602c5f6:2;
  unsigned char s602c5f7:1;
  unsigned char s602c5f8:1;
  ::S601C53 s602c5f9;
  ::S601C11 s602c5f10[2];
  virtual  ~S602C5(); // _ZN6S602C5D1Ev
  virtual void  v5(); // _ZN6S602C52v5Ev
  virtual void  v6(); // _ZN6S602C52v6Ev
  virtual void  v7(); // _ZN6S602C52v7Ev
  virtual void  v8(); // _ZN6S602C52v8Ev
  virtual void  v9(); // _ZN6S602C52v9Ev
  virtual void  v10(); // _ZN6S602C53v10Ev
  virtual void  v11(); // _ZN6S602C53v11Ev
  virtual void  v12(); // _ZN6S602C53v12Ev
  virtual void  v13(); // _ZN6S602C53v13Ev
  virtual void  v14(); // _ZN6S602C53v14Ev
  virtual void  v15(); // _ZN6S602C53v15Ev
  virtual void  v16(); // _ZN6S602C53v16Ev
  virtual void  v17(); // _ZN6S602C53v17Ev
  virtual void  v18(); // _ZN6S602C53v18Ev
  virtual void  v19(); // _ZN6S602C53v19Ev
  S602C5(); // tgen
};
//SIG(-1 S602C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 FC2{ m FC3{ m FL[2]}} FC2 Fp Fi FU4{ m FC5{ Fi:4 Fi:4 Fi:4 Fi:2 Fi:1 Fi:17} Fi} Fi:2 Fi:2 Fc:1 Fc:1 FC6{ m Fp Fp} FC7{ Fp Fp}[2]}


 S602C5 ::~S602C5(){ note_dtor("S602C5", this);}
void  S602C5 ::v5(){vfunc_called(this, "_ZN6S602C52v5Ev");}
void  S602C5 ::v6(){vfunc_called(this, "_ZN6S602C52v6Ev");}
void  S602C5 ::v7(){vfunc_called(this, "_ZN6S602C52v7Ev");}
void  S602C5 ::v8(){vfunc_called(this, "_ZN6S602C52v8Ev");}
void  S602C5 ::v9(){vfunc_called(this, "_ZN6S602C52v9Ev");}
void  S602C5 ::v10(){vfunc_called(this, "_ZN6S602C53v10Ev");}
void  S602C5 ::v11(){vfunc_called(this, "_ZN6S602C53v11Ev");}
void  S602C5 ::v12(){vfunc_called(this, "_ZN6S602C53v12Ev");}
void  S602C5 ::v13(){vfunc_called(this, "_ZN6S602C53v13Ev");}
void  S602C5 ::v14(){vfunc_called(this, "_ZN6S602C53v14Ev");}
void  S602C5 ::v15(){vfunc_called(this, "_ZN6S602C53v15Ev");}
void  S602C5 ::v16(){vfunc_called(this, "_ZN6S602C53v16Ev");}
void  S602C5 ::v17(){vfunc_called(this, "_ZN6S602C53v17Ev");}
void  S602C5 ::v18(){vfunc_called(this, "_ZN6S602C53v18Ev");}
void  S602C5 ::v19(){vfunc_called(this, "_ZN6S602C53v19Ev");}
S602C5 ::S602C5(){ note_ctor("S602C5", this);} // tgen

static void Test_S602C5()
{
  extern Class_Descriptor cd_S602C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,20)];
    init_test(&cd_S602C5, buf);
    S602C5 *dp, &lv = *(dp=new (buf) S602C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,76), "sizeof(S602C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S602C5)");
    check_field_offset(lv, s602c5f0, ABISELECT(8,4), "S602C5.s602c5f0");
    check_field_offset(lv, s602c5f1, ABISELECT(24,20), "S602C5.s602c5f1");
    check_field_offset(lv, s602c5f2, ABISELECT(40,36), "S602C5.s602c5f2");
    check_field_offset(lv, s602c5f3, ABISELECT(48,40), "S602C5.s602c5f3");
    check_field_offset(lv, s602c5f4, ABISELECT(52,44), "S602C5.s602c5f4");
    set_bf_and_test(lv, s602c5f5, ABISELECT(56,48), 0, 2, 1, "S602C5");
    set_bf_and_test(lv, s602c5f5, ABISELECT(56,48), 0, 2, hide_sll(1LL<<1), "S602C5");
    set_bf_and_test(lv, s602c5f6, ABISELECT(56,48), 2, 2, 1, "S602C5");
    set_bf_and_test(lv, s602c5f6, ABISELECT(56,48), 2, 2, hide_sll(1LL<<1), "S602C5");
    set_bf_and_test(lv, s602c5f7, ABISELECT(56,48), 4, 1, 1, "S602C5");
    set_bf_and_test(lv, s602c5f8, ABISELECT(56,48), 5, 1, 1, "S602C5");
    check_field_offset(lv, s602c5f9, ABISELECT(64,52), "S602C5.s602c5f9");
    check_field_offset(lv, s602c5f10, ABISELECT(80,60), "S602C5.s602c5f10");
    test_class_info(&lv, &cd_S602C5);
    dp->~S602C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS602C5(Test_S602C5, "S602C5", ABISELECT(112,76));

#else // __cplusplus

extern void _ZN6S602C5C1Ev();
extern void _ZN6S602C5D1Ev();
Name_Map name_map_S602C5[] = {
  NSPAIR(_ZN6S602C5C1Ev),
  NSPAIR(_ZN6S602C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S602C5[];
extern void _ZN6S602C5D1Ev();
extern void _ZN6S602C5D0Ev();
extern void _ZN6S602C52v5Ev();
extern void _ZN6S602C52v6Ev();
extern void _ZN6S602C52v7Ev();
extern void _ZN6S602C52v8Ev();
extern void _ZN6S602C52v9Ev();
extern void _ZN6S602C53v10Ev();
extern void _ZN6S602C53v11Ev();
extern void _ZN6S602C53v12Ev();
extern void _ZN6S602C53v13Ev();
extern void _ZN6S602C53v14Ev();
extern void _ZN6S602C53v15Ev();
extern void _ZN6S602C53v16Ev();
extern void _ZN6S602C53v17Ev();
extern void _ZN6S602C53v18Ev();
extern void _ZN6S602C53v19Ev();
static  VTBL_ENTRY vtc_S602C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S602C5[0]),
  (VTBL_ENTRY)&_ZN6S602C5D1Ev,
  (VTBL_ENTRY)&_ZN6S602C5D0Ev,
  (VTBL_ENTRY)&_ZN6S602C52v5Ev,
  (VTBL_ENTRY)&_ZN6S602C52v6Ev,
  (VTBL_ENTRY)&_ZN6S602C52v7Ev,
  (VTBL_ENTRY)&_ZN6S602C52v8Ev,
  (VTBL_ENTRY)&_ZN6S602C52v9Ev,
  (VTBL_ENTRY)&_ZN6S602C53v10Ev,
  (VTBL_ENTRY)&_ZN6S602C53v11Ev,
  (VTBL_ENTRY)&_ZN6S602C53v12Ev,
  (VTBL_ENTRY)&_ZN6S602C53v13Ev,
  (VTBL_ENTRY)&_ZN6S602C53v14Ev,
  (VTBL_ENTRY)&_ZN6S602C53v15Ev,
  (VTBL_ENTRY)&_ZN6S602C53v16Ev,
  (VTBL_ENTRY)&_ZN6S602C53v17Ev,
  (VTBL_ENTRY)&_ZN6S602C53v18Ev,
  (VTBL_ENTRY)&_ZN6S602C53v19Ev,
};
extern VTBL_ENTRY _ZTI6S602C5[];
extern  VTBL_ENTRY _ZTV6S602C5[];
Class_Descriptor cd_S602C5 = {  "S602C5", // class name
  0,0,//no base classes
  &(vtc_S602C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,76), // object size
  NSPAIRA(_ZTI6S602C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S602C5),19, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S602C4  : S602C5 {
  unsigned char s602c4f0:1;
  unsigned char s602c4f1:1;
  unsigned char s602c4f2:1;
  unsigned char s602c4f3:1;
  unsigned char s602c4f4:1;
  unsigned char s602c4f5:1;
  unsigned char s602c4f6:1;
  char s602c4f7;
  int s602c4f8[2];
  int s602c4f9[2];
  void *s602c4f10;
  ::S2120C13_nt s602c4f11;
  ::S2120C13_nt s602c4f12;
  ::S2120C13_nt s602c4f13;
  ::S601C12 s602c4f14;
  void *s602c4f15;
  int s602c4f16;
  int s602c4f17;
  ::S601C13_nt s602c4f18[4];
  void *s602c4f19;
  virtual  ~S602C4(); // _ZN6S602C4D1Ev
  virtual void  v20(); // _ZN6S602C43v20Ev
  virtual void  v21(); // _ZN6S602C43v21Ev
  virtual void  v22(); // _ZN6S602C43v22Ev
  virtual void  v23(); // _ZN6S602C43v23Ev
  virtual void  v24(); // _ZN6S602C43v24Ev
  virtual void  v25(); // _ZN6S602C43v25Ev
  virtual void  v26(); // _ZN6S602C43v26Ev
  virtual void  v27(); // _ZN6S602C43v27Ev
  virtual void  v28(); // _ZN6S602C43v28Ev
  virtual void  v29(); // _ZN6S602C43v29Ev
  virtual void  v30(); // _ZN6S602C43v30Ev
  virtual void  v31(); // _ZN6S602C43v31Ev
  virtual void  v32(); // _ZN6S602C43v32Ev
  virtual void  v33(); // _ZN6S602C43v33Ev
  virtual void  v34(); // _ZN6S602C43v34Ev
  S602C4(); // tgen
};
//SIG(-1 S602C4) C1{ BC2{ vd v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 FC3{ m FC4{ m FL[2]}} FC3 Fp Fi FU5{ m FC6{ Fi:4 Fi:4 Fi:4 Fi:2 Fi:1 Fi:17} Fi} Fi:2 Fi:2 Fc:1 Fc:1 FC7{ m Fp Fp} FC8{ Fp Fp}[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc Fi[2] Fi[2] Fp FC3 FC3 FC3 FC9{ m FC3 FC3} Fp Fi Fi FC10{ m Fp}[4] Fp}


 S602C4 ::~S602C4(){ note_dtor("S602C4", this);}
void  S602C4 ::v20(){vfunc_called(this, "_ZN6S602C43v20Ev");}
void  S602C4 ::v21(){vfunc_called(this, "_ZN6S602C43v21Ev");}
void  S602C4 ::v22(){vfunc_called(this, "_ZN6S602C43v22Ev");}
void  S602C4 ::v23(){vfunc_called(this, "_ZN6S602C43v23Ev");}
void  S602C4 ::v24(){vfunc_called(this, "_ZN6S602C43v24Ev");}
void  S602C4 ::v25(){vfunc_called(this, "_ZN6S602C43v25Ev");}
void  S602C4 ::v26(){vfunc_called(this, "_ZN6S602C43v26Ev");}
void  S602C4 ::v27(){vfunc_called(this, "_ZN6S602C43v27Ev");}
void  S602C4 ::v28(){vfunc_called(this, "_ZN6S602C43v28Ev");}
void  S602C4 ::v29(){vfunc_called(this, "_ZN6S602C43v29Ev");}
void  S602C4 ::v30(){vfunc_called(this, "_ZN6S602C43v30Ev");}
void  S602C4 ::v31(){vfunc_called(this, "_ZN6S602C43v31Ev");}
void  S602C4 ::v32(){vfunc_called(this, "_ZN6S602C43v32Ev");}
void  S602C4 ::v33(){vfunc_called(this, "_ZN6S602C43v33Ev");}
void  S602C4 ::v34(){vfunc_called(this, "_ZN6S602C43v34Ev");}
S602C4 ::S602C4(){ note_ctor("S602C4", this);} // tgen

static void Test_S602C4()
{
  extern Class_Descriptor cd_S602C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(36,54)];
    init_test(&cd_S602C4, buf);
    S602C4 *dp, &lv = *(dp=new (buf) S602C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(280,212), "sizeof(S602C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S602C4)");
    check_base_class_offset(lv, (S602C5*), 0, "S602C4");
    set_bf_and_test(lv, s602c4f0, ABISELECT(112,76), 0, 1, 1, "S602C4");
    set_bf_and_test(lv, s602c4f1, ABISELECT(112,76), 1, 1, 1, "S602C4");
    set_bf_and_test(lv, s602c4f2, ABISELECT(112,76), 2, 1, 1, "S602C4");
    set_bf_and_test(lv, s602c4f3, ABISELECT(112,76), 3, 1, 1, "S602C4");
    set_bf_and_test(lv, s602c4f4, ABISELECT(112,76), 4, 1, 1, "S602C4");
    set_bf_and_test(lv, s602c4f5, ABISELECT(112,76), 5, 1, 1, "S602C4");
    set_bf_and_test(lv, s602c4f6, ABISELECT(112,76), 6, 1, 1, "S602C4");
    check_field_offset(lv, s602c4f7, ABISELECT(113,77), "S602C4.s602c4f7");
    check_field_offset(lv, s602c4f8, ABISELECT(116,80), "S602C4.s602c4f8");
    check_field_offset(lv, s602c4f9, ABISELECT(124,88), "S602C4.s602c4f9");
    check_field_offset(lv, s602c4f10, ABISELECT(136,96), "S602C4.s602c4f10");
    check_field_offset(lv, s602c4f11, ABISELECT(144,100), "S602C4.s602c4f11");
    check_field_offset(lv, s602c4f12, ABISELECT(160,116), "S602C4.s602c4f12");
    check_field_offset(lv, s602c4f13, ABISELECT(176,132), "S602C4.s602c4f13");
    check_field_offset(lv, s602c4f14, ABISELECT(192,148), "S602C4.s602c4f14");
    check_field_offset(lv, s602c4f15, ABISELECT(224,180), "S602C4.s602c4f15");
    check_field_offset(lv, s602c4f16, ABISELECT(232,184), "S602C4.s602c4f16");
    check_field_offset(lv, s602c4f17, ABISELECT(236,188), "S602C4.s602c4f17");
    check_field_offset(lv, s602c4f18, ABISELECT(240,192), "S602C4.s602c4f18");
    check_field_offset(lv, s602c4f19, ABISELECT(272,208), "S602C4.s602c4f19");
    test_class_info(&lv, &cd_S602C4);
    dp->~S602C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS602C4(Test_S602C4, "S602C4", ABISELECT(280,212));

#else // __cplusplus

extern void _ZN6S602C4C1Ev();
extern void _ZN6S602C4D1Ev();
Name_Map name_map_S602C4[] = {
  NSPAIR(_ZN6S602C4C1Ev),
  NSPAIR(_ZN6S602C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S602C5;
extern VTBL_ENTRY _ZTI6S602C5[];
extern  VTBL_ENTRY _ZTV6S602C5[];
static Base_Class bases_S602C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S602C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S602C4[];
extern void _ZN6S602C4D1Ev();
extern void _ZN6S602C4D0Ev();
extern void _ZN6S602C52v5Ev();
extern void _ZN6S602C52v6Ev();
extern void _ZN6S602C52v7Ev();
extern void _ZN6S602C52v8Ev();
extern void _ZN6S602C52v9Ev();
extern void _ZN6S602C53v10Ev();
extern void _ZN6S602C53v11Ev();
extern void _ZN6S602C53v12Ev();
extern void _ZN6S602C53v13Ev();
extern void _ZN6S602C53v14Ev();
extern void _ZN6S602C53v15Ev();
extern void _ZN6S602C53v16Ev();
extern void _ZN6S602C53v17Ev();
extern void _ZN6S602C53v18Ev();
extern void _ZN6S602C53v19Ev();
extern void _ZN6S602C43v20Ev();
extern void _ZN6S602C43v21Ev();
extern void _ZN6S602C43v22Ev();
extern void _ZN6S602C43v23Ev();
extern void _ZN6S602C43v24Ev();
extern void _ZN6S602C43v25Ev();
extern void _ZN6S602C43v26Ev();
extern void _ZN6S602C43v27Ev();
extern void _ZN6S602C43v28Ev();
extern void _ZN6S602C43v29Ev();
extern void _ZN6S602C43v30Ev();
extern void _ZN6S602C43v31Ev();
extern void _ZN6S602C43v32Ev();
extern void _ZN6S602C43v33Ev();
extern void _ZN6S602C43v34Ev();
static  VTBL_ENTRY vtc_S602C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S602C4[0]),
  (VTBL_ENTRY)&_ZN6S602C4D1Ev,
  (VTBL_ENTRY)&_ZN6S602C4D0Ev,
  (VTBL_ENTRY)&_ZN6S602C52v5Ev,
  (VTBL_ENTRY)&_ZN6S602C52v6Ev,
  (VTBL_ENTRY)&_ZN6S602C52v7Ev,
  (VTBL_ENTRY)&_ZN6S602C52v8Ev,
  (VTBL_ENTRY)&_ZN6S602C52v9Ev,
  (VTBL_ENTRY)&_ZN6S602C53v10Ev,
  (VTBL_ENTRY)&_ZN6S602C53v11Ev,
  (VTBL_ENTRY)&_ZN6S602C53v12Ev,
  (VTBL_ENTRY)&_ZN6S602C53v13Ev,
  (VTBL_ENTRY)&_ZN6S602C53v14Ev,
  (VTBL_ENTRY)&_ZN6S602C53v15Ev,
  (VTBL_ENTRY)&_ZN6S602C53v16Ev,
  (VTBL_ENTRY)&_ZN6S602C53v17Ev,
  (VTBL_ENTRY)&_ZN6S602C53v18Ev,
  (VTBL_ENTRY)&_ZN6S602C53v19Ev,
  (VTBL_ENTRY)&_ZN6S602C43v20Ev,
  (VTBL_ENTRY)&_ZN6S602C43v21Ev,
  (VTBL_ENTRY)&_ZN6S602C43v22Ev,
  (VTBL_ENTRY)&_ZN6S602C43v23Ev,
  (VTBL_ENTRY)&_ZN6S602C43v24Ev,
  (VTBL_ENTRY)&_ZN6S602C43v25Ev,
  (VTBL_ENTRY)&_ZN6S602C43v26Ev,
  (VTBL_ENTRY)&_ZN6S602C43v27Ev,
  (VTBL_ENTRY)&_ZN6S602C43v28Ev,
  (VTBL_ENTRY)&_ZN6S602C43v29Ev,
  (VTBL_ENTRY)&_ZN6S602C43v30Ev,
  (VTBL_ENTRY)&_ZN6S602C43v31Ev,
  (VTBL_ENTRY)&_ZN6S602C43v32Ev,
  (VTBL_ENTRY)&_ZN6S602C43v33Ev,
  (VTBL_ENTRY)&_ZN6S602C43v34Ev,
};
extern VTBL_ENTRY _ZTI6S602C4[];
extern  VTBL_ENTRY _ZTV6S602C4[];
Class_Descriptor cd_S602C4 = {  "S602C4", // class name
  bases_S602C4, 1,
  &(vtc_S602C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(280,212), // object size
  NSPAIRA(_ZTI6S602C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S602C4),34, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S602C3  : S602C4 {
  ::S601C13_nt s602c3f0;
  ::S601C13_nt s602c3f1;
  ::S601C13_nt s602c3f2;
  ::S601C13_nt s602c3f3;
  ::S2120C13_nt s602c3f4;
  ::S2120C13_nt s602c3f5;
  ::S2120C13_nt s602c3f6;
  ::S2120C13_nt s602c3f7;
  ::S601C14 s602c3f8;
  virtual  ~S602C3(); // _ZN6S602C3D1Ev
  virtual void  v35(); // _ZN6S602C33v35Ev
  virtual void  v36(); // _ZN6S602C33v36Ev
  virtual void  v37(); // _ZN6S602C33v37Ev
  virtual void  v38(); // _ZN6S602C33v38Ev
  virtual void  v39(); // _ZN6S602C33v39Ev
  S602C3(); // tgen
};
//SIG(-1 S602C3) C1{ BC2{ BC3{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 FC4{ m FC5{ m FL[2]}} FC4 Fp Fi FU6{ m FC7{ Fi:4 Fi:4 Fi:4 Fi:2 Fi:1 Fi:17} Fi} Fi:2 Fi:2 Fc:1 Fc:1 FC8{ m Fp Fp} FC9{ Fp Fp}[2]} vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc Fi[2] Fi[2] Fp FC4 FC4 FC4 FC10{ m FC4 FC4} Fp Fi Fi FC11{ m Fp}[4] Fp} vd v1 v2 v3 v4 v5 FC11 FC11 FC11 FC11 FC4 FC4 FC4 FC4 FC12{ m FC13{ m FL FL}}}


 S602C3 ::~S602C3(){ note_dtor("S602C3", this);}
void  S602C3 ::v35(){vfunc_called(this, "_ZN6S602C33v35Ev");}
void  S602C3 ::v36(){vfunc_called(this, "_ZN6S602C33v36Ev");}
void  S602C3 ::v37(){vfunc_called(this, "_ZN6S602C33v37Ev");}
void  S602C3 ::v38(){vfunc_called(this, "_ZN6S602C33v38Ev");}
void  S602C3 ::v39(){vfunc_called(this, "_ZN6S602C33v39Ev");}
S602C3 ::S602C3(){ note_ctor("S602C3", this);} // tgen

static void Test_S602C3()
{
  extern Class_Descriptor cd_S602C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(50,78)];
    init_test(&cd_S602C3, buf);
    S602C3 *dp, &lv = *(dp=new (buf) S602C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(392,308), "sizeof(S602C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S602C3)");
    check_base_class_offset(lv, (S602C5*)(S602C4*), 0, "S602C3");
    check_base_class_offset(lv, (S602C4*), 0, "S602C3");
    check_field_offset(lv, s602c3f0, ABISELECT(280,212), "S602C3.s602c3f0");
    check_field_offset(lv, s602c3f1, ABISELECT(288,216), "S602C3.s602c3f1");
    check_field_offset(lv, s602c3f2, ABISELECT(296,220), "S602C3.s602c3f2");
    check_field_offset(lv, s602c3f3, ABISELECT(304,224), "S602C3.s602c3f3");
    check_field_offset(lv, s602c3f4, ABISELECT(312,228), "S602C3.s602c3f4");
    check_field_offset(lv, s602c3f5, ABISELECT(328,244), "S602C3.s602c3f5");
    check_field_offset(lv, s602c3f6, ABISELECT(344,260), "S602C3.s602c3f6");
    check_field_offset(lv, s602c3f7, ABISELECT(360,276), "S602C3.s602c3f7");
    check_field_offset(lv, s602c3f8, ABISELECT(376,292), "S602C3.s602c3f8");
    test_class_info(&lv, &cd_S602C3);
    dp->~S602C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS602C3(Test_S602C3, "S602C3", ABISELECT(392,308));

#else // __cplusplus

extern void _ZN6S602C3C1Ev();
extern void _ZN6S602C3D1Ev();
Name_Map name_map_S602C3[] = {
  NSPAIR(_ZN6S602C3C1Ev),
  NSPAIR(_ZN6S602C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S602C5;
extern VTBL_ENTRY _ZTI6S602C5[];
extern  VTBL_ENTRY _ZTV6S602C5[];
extern Class_Descriptor cd_S602C4;
extern VTBL_ENTRY _ZTI6S602C4[];
extern  VTBL_ENTRY _ZTV6S602C4[];
static Base_Class bases_S602C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S602C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S602C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S602C3[];
extern void _ZN6S602C3D1Ev();
extern void _ZN6S602C3D0Ev();
extern void _ZN6S602C52v5Ev();
extern void _ZN6S602C52v6Ev();
extern void _ZN6S602C52v7Ev();
extern void _ZN6S602C52v8Ev();
extern void _ZN6S602C52v9Ev();
extern void _ZN6S602C53v10Ev();
extern void _ZN6S602C53v11Ev();
extern void _ZN6S602C53v12Ev();
extern void _ZN6S602C53v13Ev();
extern void _ZN6S602C53v14Ev();
extern void _ZN6S602C53v15Ev();
extern void _ZN6S602C53v16Ev();
extern void _ZN6S602C53v17Ev();
extern void _ZN6S602C53v18Ev();
extern void _ZN6S602C53v19Ev();
extern void _ZN6S602C43v20Ev();
extern void _ZN6S602C43v21Ev();
extern void _ZN6S602C43v22Ev();
extern void _ZN6S602C43v23Ev();
extern void _ZN6S602C43v24Ev();
extern void _ZN6S602C43v25Ev();
extern void _ZN6S602C43v26Ev();
extern void _ZN6S602C43v27Ev();
extern void _ZN6S602C43v28Ev();
extern void _ZN6S602C43v29Ev();
extern void _ZN6S602C43v30Ev();
extern void _ZN6S602C43v31Ev();
extern void _ZN6S602C43v32Ev();
extern void _ZN6S602C43v33Ev();
extern void _ZN6S602C43v34Ev();
extern void _ZN6S602C33v35Ev();
extern void _ZN6S602C33v36Ev();
extern void _ZN6S602C33v37Ev();
extern void _ZN6S602C33v38Ev();
extern void _ZN6S602C33v39Ev();
static  VTBL_ENTRY vtc_S602C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S602C3[0]),
  (VTBL_ENTRY)&_ZN6S602C3D1Ev,
  (VTBL_ENTRY)&_ZN6S602C3D0Ev,
  (VTBL_ENTRY)&_ZN6S602C52v5Ev,
  (VTBL_ENTRY)&_ZN6S602C52v6Ev,
  (VTBL_ENTRY)&_ZN6S602C52v7Ev,
  (VTBL_ENTRY)&_ZN6S602C52v8Ev,
  (VTBL_ENTRY)&_ZN6S602C52v9Ev,
  (VTBL_ENTRY)&_ZN6S602C53v10Ev,
  (VTBL_ENTRY)&_ZN6S602C53v11Ev,
  (VTBL_ENTRY)&_ZN6S602C53v12Ev,
  (VTBL_ENTRY)&_ZN6S602C53v13Ev,
  (VTBL_ENTRY)&_ZN6S602C53v14Ev,
  (VTBL_ENTRY)&_ZN6S602C53v15Ev,
  (VTBL_ENTRY)&_ZN6S602C53v16Ev,
  (VTBL_ENTRY)&_ZN6S602C53v17Ev,
  (VTBL_ENTRY)&_ZN6S602C53v18Ev,
  (VTBL_ENTRY)&_ZN6S602C53v19Ev,
  (VTBL_ENTRY)&_ZN6S602C43v20Ev,
  (VTBL_ENTRY)&_ZN6S602C43v21Ev,
  (VTBL_ENTRY)&_ZN6S602C43v22Ev,
  (VTBL_ENTRY)&_ZN6S602C43v23Ev,
  (VTBL_ENTRY)&_ZN6S602C43v24Ev,
  (VTBL_ENTRY)&_ZN6S602C43v25Ev,
  (VTBL_ENTRY)&_ZN6S602C43v26Ev,
  (VTBL_ENTRY)&_ZN6S602C43v27Ev,
  (VTBL_ENTRY)&_ZN6S602C43v28Ev,
  (VTBL_ENTRY)&_ZN6S602C43v29Ev,
  (VTBL_ENTRY)&_ZN6S602C43v30Ev,
  (VTBL_ENTRY)&_ZN6S602C43v31Ev,
  (VTBL_ENTRY)&_ZN6S602C43v32Ev,
  (VTBL_ENTRY)&_ZN6S602C43v33Ev,
  (VTBL_ENTRY)&_ZN6S602C43v34Ev,
  (VTBL_ENTRY)&_ZN6S602C33v35Ev,
  (VTBL_ENTRY)&_ZN6S602C33v36Ev,
  (VTBL_ENTRY)&_ZN6S602C33v37Ev,
  (VTBL_ENTRY)&_ZN6S602C33v38Ev,
  (VTBL_ENTRY)&_ZN6S602C33v39Ev,
};
extern VTBL_ENTRY _ZTI6S602C3[];
extern  VTBL_ENTRY _ZTV6S602C3[];
Class_Descriptor cd_S602C3 = {  "S602C3", // class name
  bases_S602C3, 2,
  &(vtc_S602C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(392,308), // object size
  NSPAIRA(_ZTI6S602C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S602C3),39, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S602C2  : S602C3 {
  virtual  ~S602C2(); // _ZN6S602C2D1Ev
  virtual void  v40(); // _ZN6S602C23v40Ev
  virtual void  v41(); // _ZN6S602C23v41Ev
  virtual void  v42(); // _ZN6S602C23v42Ev
  virtual void  v43(); // _ZN6S602C23v43Ev
  S602C2(); // tgen
};
//SIG(-1 S602C2) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 FC5{ m FC6{ m FL[2]}} FC5 Fp Fi FU7{ m FC8{ Fi:4 Fi:4 Fi:4 Fi:2 Fi:1 Fi:17} Fi} Fi:2 Fi:2 Fc:1 Fc:1 FC9{ m Fp Fp} FC10{ Fp Fp}[2]} vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc Fi[2] Fi[2] Fp FC5 FC5 FC5 FC11{ m FC5 FC5} Fp Fi Fi FC12{ m Fp}[4] Fp} vd v35 v36 v37 v38 v39 FC12 FC12 FC12 FC12 FC5 FC5 FC5 FC5 FC13{ m FC14{ m FL FL}}} vd v1 v2 v3 v4}


 S602C2 ::~S602C2(){ note_dtor("S602C2", this);}
void  S602C2 ::v40(){vfunc_called(this, "_ZN6S602C23v40Ev");}
void  S602C2 ::v41(){vfunc_called(this, "_ZN6S602C23v41Ev");}
void  S602C2 ::v42(){vfunc_called(this, "_ZN6S602C23v42Ev");}
void  S602C2 ::v43(){vfunc_called(this, "_ZN6S602C23v43Ev");}
S602C2 ::S602C2(){ note_ctor("S602C2", this);} // tgen

static void Test_S602C2()
{
  extern Class_Descriptor cd_S602C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(50,78)];
    init_test(&cd_S602C2, buf);
    S602C2 *dp, &lv = *(dp=new (buf) S602C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(392,308), "sizeof(S602C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S602C2)");
    check_base_class_offset(lv, (S602C5*)(S602C4*)(S602C3*), 0, "S602C2");
    check_base_class_offset(lv, (S602C4*)(S602C3*), 0, "S602C2");
    check_base_class_offset(lv, (S602C3*), 0, "S602C2");
    test_class_info(&lv, &cd_S602C2);
    dp->~S602C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS602C2(Test_S602C2, "S602C2", ABISELECT(392,308));

#else // __cplusplus

extern void _ZN6S602C2C1Ev();
extern void _ZN6S602C2D1Ev();
Name_Map name_map_S602C2[] = {
  NSPAIR(_ZN6S602C2C1Ev),
  NSPAIR(_ZN6S602C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S602C5;
extern VTBL_ENTRY _ZTI6S602C5[];
extern  VTBL_ENTRY _ZTV6S602C5[];
extern Class_Descriptor cd_S602C4;
extern VTBL_ENTRY _ZTI6S602C4[];
extern  VTBL_ENTRY _ZTV6S602C4[];
extern Class_Descriptor cd_S602C3;
extern VTBL_ENTRY _ZTI6S602C3[];
extern  VTBL_ENTRY _ZTV6S602C3[];
static Base_Class bases_S602C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S602C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S602C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S602C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S602C2[];
extern void _ZN6S602C2D1Ev();
extern void _ZN6S602C2D0Ev();
extern void _ZN6S602C52v5Ev();
extern void _ZN6S602C52v6Ev();
extern void _ZN6S602C52v7Ev();
extern void _ZN6S602C52v8Ev();
extern void _ZN6S602C52v9Ev();
extern void _ZN6S602C53v10Ev();
extern void _ZN6S602C53v11Ev();
extern void _ZN6S602C53v12Ev();
extern void _ZN6S602C53v13Ev();
extern void _ZN6S602C53v14Ev();
extern void _ZN6S602C53v15Ev();
extern void _ZN6S602C53v16Ev();
extern void _ZN6S602C53v17Ev();
extern void _ZN6S602C53v18Ev();
extern void _ZN6S602C53v19Ev();
extern void _ZN6S602C43v20Ev();
extern void _ZN6S602C43v21Ev();
extern void _ZN6S602C43v22Ev();
extern void _ZN6S602C43v23Ev();
extern void _ZN6S602C43v24Ev();
extern void _ZN6S602C43v25Ev();
extern void _ZN6S602C43v26Ev();
extern void _ZN6S602C43v27Ev();
extern void _ZN6S602C43v28Ev();
extern void _ZN6S602C43v29Ev();
extern void _ZN6S602C43v30Ev();
extern void _ZN6S602C43v31Ev();
extern void _ZN6S602C43v32Ev();
extern void _ZN6S602C43v33Ev();
extern void _ZN6S602C43v34Ev();
extern void _ZN6S602C33v35Ev();
extern void _ZN6S602C33v36Ev();
extern void _ZN6S602C33v37Ev();
extern void _ZN6S602C33v38Ev();
extern void _ZN6S602C33v39Ev();
extern void _ZN6S602C23v40Ev();
extern void _ZN6S602C23v41Ev();
extern void _ZN6S602C23v42Ev();
extern void _ZN6S602C23v43Ev();
static  VTBL_ENTRY vtc_S602C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S602C2[0]),
  (VTBL_ENTRY)&_ZN6S602C2D1Ev,
  (VTBL_ENTRY)&_ZN6S602C2D0Ev,
  (VTBL_ENTRY)&_ZN6S602C52v5Ev,
  (VTBL_ENTRY)&_ZN6S602C52v6Ev,
  (VTBL_ENTRY)&_ZN6S602C52v7Ev,
  (VTBL_ENTRY)&_ZN6S602C52v8Ev,
  (VTBL_ENTRY)&_ZN6S602C52v9Ev,
  (VTBL_ENTRY)&_ZN6S602C53v10Ev,
  (VTBL_ENTRY)&_ZN6S602C53v11Ev,
  (VTBL_ENTRY)&_ZN6S602C53v12Ev,
  (VTBL_ENTRY)&_ZN6S602C53v13Ev,
  (VTBL_ENTRY)&_ZN6S602C53v14Ev,
  (VTBL_ENTRY)&_ZN6S602C53v15Ev,
  (VTBL_ENTRY)&_ZN6S602C53v16Ev,
  (VTBL_ENTRY)&_ZN6S602C53v17Ev,
  (VTBL_ENTRY)&_ZN6S602C53v18Ev,
  (VTBL_ENTRY)&_ZN6S602C53v19Ev,
  (VTBL_ENTRY)&_ZN6S602C43v20Ev,
  (VTBL_ENTRY)&_ZN6S602C43v21Ev,
  (VTBL_ENTRY)&_ZN6S602C43v22Ev,
  (VTBL_ENTRY)&_ZN6S602C43v23Ev,
  (VTBL_ENTRY)&_ZN6S602C43v24Ev,
  (VTBL_ENTRY)&_ZN6S602C43v25Ev,
  (VTBL_ENTRY)&_ZN6S602C43v26Ev,
  (VTBL_ENTRY)&_ZN6S602C43v27Ev,
  (VTBL_ENTRY)&_ZN6S602C43v28Ev,
  (VTBL_ENTRY)&_ZN6S602C43v29Ev,
  (VTBL_ENTRY)&_ZN6S602C43v30Ev,
  (VTBL_ENTRY)&_ZN6S602C43v31Ev,
  (VTBL_ENTRY)&_ZN6S602C43v32Ev,
  (VTBL_ENTRY)&_ZN6S602C43v33Ev,
  (VTBL_ENTRY)&_ZN6S602C43v34Ev,
  (VTBL_ENTRY)&_ZN6S602C33v35Ev,
  (VTBL_ENTRY)&_ZN6S602C33v36Ev,
  (VTBL_ENTRY)&_ZN6S602C33v37Ev,
  (VTBL_ENTRY)&_ZN6S602C33v38Ev,
  (VTBL_ENTRY)&_ZN6S602C33v39Ev,
  (VTBL_ENTRY)&_ZN6S602C23v40Ev,
  (VTBL_ENTRY)&_ZN6S602C23v41Ev,
  (VTBL_ENTRY)&_ZN6S602C23v42Ev,
  (VTBL_ENTRY)&_ZN6S602C23v43Ev,
};
extern VTBL_ENTRY _ZTI6S602C2[];
extern  VTBL_ENTRY _ZTV6S602C2[];
Class_Descriptor cd_S602C2 = {  "S602C2", // class name
  bases_S602C2, 3,
  &(vtc_S602C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(392,308), // object size
  NSPAIRA(_ZTI6S602C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S602C2),43, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S602C19  {
  ::S601C20 s602c19f0;
  virtual  ~S602C19(); // _ZN7S602C19D1Ev
  virtual void  v50(); // _ZN7S602C193v50Ev
  virtual void  v51(); // _ZN7S602C193v51Ev
  virtual void  v52(); // _ZN7S602C193v52Ev
  virtual void  v53(); // _ZN7S602C193v53Ev
  virtual void  v54(); // _ZN7S602C193v54Ev
  virtual void  v55(); // _ZN7S602C193v55Ev
  S602C19(); // tgen
};
//SIG(-1 S602C19) C1{ vd v1 v2 v3 v4 v5 v6 FC2{ m Fp[4]}}


 S602C19 ::~S602C19(){ note_dtor("S602C19", this);}
void  S602C19 ::v50(){vfunc_called(this, "_ZN7S602C193v50Ev");}
void  S602C19 ::v51(){vfunc_called(this, "_ZN7S602C193v51Ev");}
void  S602C19 ::v52(){vfunc_called(this, "_ZN7S602C193v52Ev");}
void  S602C19 ::v53(){vfunc_called(this, "_ZN7S602C193v53Ev");}
void  S602C19 ::v54(){vfunc_called(this, "_ZN7S602C193v54Ev");}
void  S602C19 ::v55(){vfunc_called(this, "_ZN7S602C193v55Ev");}
S602C19 ::S602C19(){ note_ctor("S602C19", this);} // tgen

static void Test_S602C19()
{
  extern Class_Descriptor cd_S602C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[6];
    init_test(&cd_S602C19, buf);
    S602C19 *dp, &lv = *(dp=new (buf) S602C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,20), "sizeof(S602C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S602C19)");
    check_field_offset(lv, s602c19f0, ABISELECT(8,4), "S602C19.s602c19f0");
    test_class_info(&lv, &cd_S602C19);
    dp->~S602C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS602C19(Test_S602C19, "S602C19", ABISELECT(40,20));

#else // __cplusplus

extern void _ZN7S602C19C1Ev();
extern void _ZN7S602C19D1Ev();
Name_Map name_map_S602C19[] = {
  NSPAIR(_ZN7S602C19C1Ev),
  NSPAIR(_ZN7S602C19D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S602C19[];
extern void _ZN7S602C19D1Ev();
extern void _ZN7S602C19D0Ev();
extern void _ZN7S602C193v50Ev();
extern void _ZN7S602C193v51Ev();
extern void _ZN7S602C193v52Ev();
extern void _ZN7S602C193v53Ev();
extern void _ZN7S602C193v54Ev();
extern void _ZN7S602C193v55Ev();
static  VTBL_ENTRY vtc_S602C19[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S602C19[0]),
  (VTBL_ENTRY)&_ZN7S602C19D1Ev,
  (VTBL_ENTRY)&_ZN7S602C19D0Ev,
  (VTBL_ENTRY)&_ZN7S602C193v50Ev,
  (VTBL_ENTRY)&_ZN7S602C193v51Ev,
  (VTBL_ENTRY)&_ZN7S602C193v52Ev,
  (VTBL_ENTRY)&_ZN7S602C193v53Ev,
  (VTBL_ENTRY)&_ZN7S602C193v54Ev,
  (VTBL_ENTRY)&_ZN7S602C193v55Ev,
};
extern VTBL_ENTRY _ZTI7S602C19[];
extern  VTBL_ENTRY _ZTV7S602C19[];
Class_Descriptor cd_S602C19 = {  "S602C19", // class name
  0,0,//no base classes
  &(vtc_S602C19[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,20), // object size
  NSPAIRA(_ZTI7S602C19),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S602C19),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S602C18  : S602C19 , S601C21_nt {
  ::S601C22 s602c18f0;
  ::S601C28 s602c18f1;
  ::S601C28 s602c18f2;
  virtual void  v44(); // _ZN7S602C183v44Ev
  virtual void  v45(); // _ZN7S602C183v45Ev
  virtual void  v46(); // _ZN7S602C183v46Ev
  virtual void  v47(); // _ZN7S602C183v47Ev
  virtual void  v48(); // _ZN7S602C183v48Ev
  virtual void  v49(); // _ZN7S602C183v49Ev
  ~S602C18(); // tgen
  S602C18(); // tgen
};
//SIG(-1 S602C18) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8}} FC10{ BC6 FC11{ m FC12{ m FL}}} FC10}


void  S602C18 ::v44(){vfunc_called(this, "_ZN7S602C183v44Ev");}
void  S602C18 ::v45(){vfunc_called(this, "_ZN7S602C183v45Ev");}
void  S602C18 ::v46(){vfunc_called(this, "_ZN7S602C183v46Ev");}
void  S602C18 ::v47(){vfunc_called(this, "_ZN7S602C183v47Ev");}
void  S602C18 ::v48(){vfunc_called(this, "_ZN7S602C183v48Ev");}
void  S602C18 ::v49(){vfunc_called(this, "_ZN7S602C183v49Ev");}
S602C18 ::~S602C18(){ note_dtor("S602C18", this);} // tgen
S602C18 ::S602C18(){ note_ctor("S602C18", this);} // tgen

static void Test_S602C18()
{
  extern Class_Descriptor cd_S602C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(28,41)];
    init_test(&cd_S602C18, buf);
    S602C18 *dp, &lv = *(dp=new (buf) S602C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(216,160), "sizeof(S602C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S602C18)");
    check_base_class_offset(lv, (S602C19*), 0, "S602C18");
    check_base_class_offset(lv, (S601C21_nt*), 0, "S602C18");
    check_field_offset(lv, s602c18f0, ABISELECT(40,20), "S602C18.s602c18f0");
    check_field_offset(lv, s602c18f1, ABISELECT(136,104), "S602C18.s602c18f1");
    check_field_offset(lv, s602c18f2, ABISELECT(176,132), "S602C18.s602c18f2");
    test_class_info(&lv, &cd_S602C18);
    dp->~S602C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS602C18(Test_S602C18, "S602C18", ABISELECT(216,160));

#else // __cplusplus

extern void _ZN7S602C18C1Ev();
extern void _ZN7S602C18D1Ev();
Name_Map name_map_S602C18[] = {
  NSPAIR(_ZN7S602C18C1Ev),
  NSPAIR(_ZN7S602C18D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S602C19;
extern VTBL_ENTRY _ZTI7S602C19[];
extern  VTBL_ENTRY _ZTV7S602C19[];
extern Class_Descriptor cd_S601C21_nt;
extern VTBL_ENTRY _ZTI10S601C21_nt[];
static Base_Class bases_S602C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S602C19,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S601C21_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S602C18[];
extern void _ZN7S602C18D1Ev();
extern void _ZN7S602C18D0Ev();
extern void _ZN7S602C193v50Ev();
extern void _ZN7S602C193v51Ev();
extern void _ZN7S602C193v52Ev();
extern void _ZN7S602C193v53Ev();
extern void _ZN7S602C193v54Ev();
extern void _ZN7S602C193v55Ev();
extern void _ZN7S602C183v44Ev();
extern void _ZN7S602C183v45Ev();
extern void _ZN7S602C183v46Ev();
extern void _ZN7S602C183v47Ev();
extern void _ZN7S602C183v48Ev();
extern void _ZN7S602C183v49Ev();
static  VTBL_ENTRY vtc_S602C18[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S602C18[0]),
  (VTBL_ENTRY)&_ZN7S602C18D1Ev,
  (VTBL_ENTRY)&_ZN7S602C18D0Ev,
  (VTBL_ENTRY)&_ZN7S602C193v50Ev,
  (VTBL_ENTRY)&_ZN7S602C193v51Ev,
  (VTBL_ENTRY)&_ZN7S602C193v52Ev,
  (VTBL_ENTRY)&_ZN7S602C193v53Ev,
  (VTBL_ENTRY)&_ZN7S602C193v54Ev,
  (VTBL_ENTRY)&_ZN7S602C193v55Ev,
  (VTBL_ENTRY)&_ZN7S602C183v44Ev,
  (VTBL_ENTRY)&_ZN7S602C183v45Ev,
  (VTBL_ENTRY)&_ZN7S602C183v46Ev,
  (VTBL_ENTRY)&_ZN7S602C183v47Ev,
  (VTBL_ENTRY)&_ZN7S602C183v48Ev,
  (VTBL_ENTRY)&_ZN7S602C183v49Ev,
};
extern VTBL_ENTRY _ZTI7S602C18[];
extern  VTBL_ENTRY _ZTV7S602C18[];
Class_Descriptor cd_S602C18 = {  "S602C18", // class name
  bases_S602C18, 2,
  &(vtc_S602C18[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(216,160), // object size
  NSPAIRA(_ZTI7S602C18),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S602C18),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S602C17  {
  ::S602C18 s602c17f0;
  ::S601C32 s602c17f1;
  void  mf602c17(); // _ZN7S602C178mf602c17Ev
};
//SIG(-1 S602C17) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m FC10{ m FL[2]}} FC9 FC9 FC9}} FC11{ BC7 FC12{ m FC13{ m FL}}} FC11} FC14{ BC15{ BC16{ vd v13} vd v14 Fp[2] FC17{ m FC18{ m Fp Fi[2] FC19{ m}}} FC20{ m Fp[2]}} vd FC21{ m FC22{ Fs[2] Fc[2] Fs}[12] Fi FC23{ Fs[2]}[4] Fi FC24{ m Fp[2]}}}}


void  S602C17 ::mf602c17(){}

static void Test_S602C17()
{
  {
    init_simple_test("S602C17");
    S602C17 lv;
    check2(sizeof(lv), ABISELECT(416,324), "sizeof(S602C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S602C17)");
    check_field_offset(lv, s602c17f0, 0, "S602C17.s602c17f0");
    check_field_offset(lv, s602c17f1, ABISELECT(216,160), "S602C17.s602c17f1");
  }
}
static Arrange_To_Call_Me vS602C17(Test_S602C17, "S602C17", ABISELECT(416,324));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S602C42  : S602C19 , S601C21_nt {
  ::S601C45 s602c42f0;
  ::S601C45 s602c42f1;
  ::S601C27 s602c42f2;
  virtual void  v58(); // _ZN7S602C423v58Ev
  virtual void  v59(); // _ZN7S602C423v59Ev
  virtual void  v60(); // _ZN7S602C423v60Ev
  virtual void  v61(); // _ZN7S602C423v61Ev
  virtual void  v62(); // _ZN7S602C423v62Ev
  virtual void  v63(); // _ZN7S602C423v63Ev
  ~S602C42(); // tgen
  S602C42(); // tgen
};
//SIG(-1 S602C42) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m Fp[2]} FC9{ m Fp}}} FC5 FC10{ BC6 FC11{ m FC12{ m FL[2]}}}}


void  S602C42 ::v58(){vfunc_called(this, "_ZN7S602C423v58Ev");}
void  S602C42 ::v59(){vfunc_called(this, "_ZN7S602C423v59Ev");}
void  S602C42 ::v60(){vfunc_called(this, "_ZN7S602C423v60Ev");}
void  S602C42 ::v61(){vfunc_called(this, "_ZN7S602C423v61Ev");}
void  S602C42 ::v62(){vfunc_called(this, "_ZN7S602C423v62Ev");}
void  S602C42 ::v63(){vfunc_called(this, "_ZN7S602C423v63Ev");}
S602C42 ::~S602C42(){ note_dtor("S602C42", this);} // tgen
S602C42 ::S602C42(){ note_ctor("S602C42", this);} // tgen

static void Test_S602C42()
{
  extern Class_Descriptor cd_S602C42;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,31)];
    init_test(&cd_S602C42, buf);
    S602C42 *dp, &lv = *(dp=new (buf) S602C42());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,120), "sizeof(S602C42)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S602C42)");
    check_base_class_offset(lv, (S602C19*), 0, "S602C42");
    check_base_class_offset(lv, (S601C21_nt*), 0, "S602C42");
    check_field_offset(lv, s602c42f0, ABISELECT(40,20), "S602C42.s602c42f0");
    check_field_offset(lv, s602c42f1, ABISELECT(96,52), "S602C42.s602c42f1");
    check_field_offset(lv, s602c42f2, ABISELECT(152,84), "S602C42.s602c42f2");
    test_class_info(&lv, &cd_S602C42);
    dp->~S602C42();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS602C42(Test_S602C42, "S602C42", ABISELECT(200,120));

#else // __cplusplus

extern void _ZN7S602C42C1Ev();
extern void _ZN7S602C42D1Ev();
Name_Map name_map_S602C42[] = {
  NSPAIR(_ZN7S602C42C1Ev),
  NSPAIR(_ZN7S602C42D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S602C19;
extern VTBL_ENTRY _ZTI7S602C19[];
extern  VTBL_ENTRY _ZTV7S602C19[];
extern Class_Descriptor cd_S601C21_nt;
extern VTBL_ENTRY _ZTI10S601C21_nt[];
static Base_Class bases_S602C42[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S602C19,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S601C21_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S602C42[];
extern void _ZN7S602C42D1Ev();
extern void _ZN7S602C42D0Ev();
extern void _ZN7S602C193v50Ev();
extern void _ZN7S602C193v51Ev();
extern void _ZN7S602C193v52Ev();
extern void _ZN7S602C193v53Ev();
extern void _ZN7S602C193v54Ev();
extern void _ZN7S602C193v55Ev();
extern void _ZN7S602C423v58Ev();
extern void _ZN7S602C423v59Ev();
extern void _ZN7S602C423v60Ev();
extern void _ZN7S602C423v61Ev();
extern void _ZN7S602C423v62Ev();
extern void _ZN7S602C423v63Ev();
static  VTBL_ENTRY vtc_S602C42[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S602C42[0]),
  (VTBL_ENTRY)&_ZN7S602C42D1Ev,
  (VTBL_ENTRY)&_ZN7S602C42D0Ev,
  (VTBL_ENTRY)&_ZN7S602C193v50Ev,
  (VTBL_ENTRY)&_ZN7S602C193v51Ev,
  (VTBL_ENTRY)&_ZN7S602C193v52Ev,
  (VTBL_ENTRY)&_ZN7S602C193v53Ev,
  (VTBL_ENTRY)&_ZN7S602C193v54Ev,
  (VTBL_ENTRY)&_ZN7S602C193v55Ev,
  (VTBL_ENTRY)&_ZN7S602C423v58Ev,
  (VTBL_ENTRY)&_ZN7S602C423v59Ev,
  (VTBL_ENTRY)&_ZN7S602C423v60Ev,
  (VTBL_ENTRY)&_ZN7S602C423v61Ev,
  (VTBL_ENTRY)&_ZN7S602C423v62Ev,
  (VTBL_ENTRY)&_ZN7S602C423v63Ev,
};
extern VTBL_ENTRY _ZTI7S602C42[];
extern  VTBL_ENTRY _ZTV7S602C42[];
Class_Descriptor cd_S602C42 = {  "S602C42", // class name
  bases_S602C42, 2,
  &(vtc_S602C42[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(200,120), // object size
  NSPAIRA(_ZTI7S602C42),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S602C42),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S602C41  {
  ::S602C42 s602c41f0;
  ::S601C48 s602c41f1;
  void  mf602c41(); // _ZN7S602C418mf602c41Ev
};
//SIG(-1 S602C41) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}} FC6 FC11{ BC7 FC12{ m FC13{ m FL[2]}}}} FC14{ BC15{ BC16{ vd v13} vd v14 Fp[2] FC17{ m FC18{ m Fp Fi[2] FC19{ m}}} FC20{ m Fp[2]}} vd FC21{ m Fp Fi FC22{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC9}}}


void  S602C41 ::mf602c41(){}

static void Test_S602C41()
{
  {
    init_simple_test("S602C41");
    static S602C41 lv;
    check2(sizeof(lv), ABISELECT(304,180), "sizeof(S602C41)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S602C41)");
    check_field_offset(lv, s602c41f0, 0, "S602C41.s602c41f0");
    check_field_offset(lv, s602c41f1, ABISELECT(200,120), "S602C41.s602c41f1");
  }
}
static Arrange_To_Call_Me vS602C41(Test_S602C41, "S602C41", ABISELECT(304,180));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S602C16  {
  ::S602C17 s602c16f0;
  ::S602C41 s602c16f1;
  void  mf602c16(); // _ZN7S602C168mf602c16Ev
};
//SIG(-1 S602C16) C1{ m FC2{ m FC3{ BC4{ vd v7 v8 v9 v10 v11 v12 FC5{ m Fp[4]}} BC6{} v1 v2 v3 v4 v5 v6 FC7{ BC8{ m Fp Fi Fp Fi[2]} FC9{ m FC10{ m FC11{ m FL[2]}} FC10 FC10 FC10}} FC12{ BC8 FC13{ m FC14{ m FL}}} FC12} FC15{ BC16{ BC17{ vd v13} vd v14 Fp[2] FC18{ m FC19{ m Fp Fi[2] FC20{ m}}} FC21{ m Fp[2]}} vd FC22{ m FC23{ Fs[2] Fc[2] Fs}[12] Fi FC24{ Fs[2]}[4] Fi FC25{ m Fp[2]}}}} FC26{ m FC27{ BC4 BC6 v15 v16 v17 v18 v19 v20 FC28{ BC8 FC29{ m FC25 FC30{ m Fp}}} FC28 FC31{ BC8 FC32{ m FC11}}} FC33{ BC34{ BC17 vd v21 Fp[2] FC18 FC35{ m Fp[2]}} vd FC36{ m Fp Fi FC37{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC25}}}}


void  S602C16 ::mf602c16(){}

static void Test_S602C16()
{
  {
    init_simple_test("S602C16");
    static S602C16 lv;
    check2(sizeof(lv), ABISELECT(720,504), "sizeof(S602C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S602C16)");
    check_field_offset(lv, s602c16f0, 0, "S602C16.s602c16f0");
    check_field_offset(lv, s602c16f1, ABISELECT(416,324), "S602C16.s602c16f1");
  }
}
static Arrange_To_Call_Me vS602C16(Test_S602C16, "S602C16", ABISELECT(720,504));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S602C1  : S602C2 {
  ::S602C16 s602c1f0;
  virtual  ~S602C1(); // _ZN6S602C1D1Ev
  virtual void  v1(); // _ZN6S602C12v1Ev
  virtual void  v2(); // _ZN6S602C12v2Ev
  virtual void  v3(); // _ZN6S602C12v3Ev
  virtual void  v4(); // _ZN6S602C12v4Ev
  S602C1(); // tgen
};
//SIG(1 S602C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 FC6{ m FC7{ m FL[2]}} FC6 Fp Fi FU8{ m FC9{ Fi:4 Fi:4 Fi:4 Fi:2 Fi:1 Fi:17} Fi} Fi:2 Fi:2 Fc:1 Fc:1 FC10{ m Fp Fp} FC11{ Fp Fp}[2]} vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc Fi[2] Fi[2] Fp FC6 FC6 FC6 FC12{ m FC6 FC6} Fp Fi Fi FC13{ m Fp}[4] Fp} vd v35 v36 v37 v38 v39 FC13 FC13 FC13 FC13 FC6 FC6 FC6 FC6 FC14{ m FC15{ m FL FL}}} vd v40 v41 v42 v43} vd v1 v2 v3 v4 FC16{ m FC17{ m FC18{ BC19{ vd v50 v51 v52 v53 v54 v55 FC20{ m Fp Fp Fp Fp}} BC21{} v44 v45 v46 v47 v48 v49 FC22{ BC23{ m Fp Fi Fp Fi Fi} FC24{ m FC6 FC6 FC6 FC6}} FC25{ BC23 FC26{ m FC27{ m FL}}} FC25} FC28{ BC29{ BC30{ vd v56} vd v57 Fp Fp FC31{ m FC32{ m Fp Fi Fi FC33{ m}}} FC34{ m Fp Fp}} vd FC35{ m FC36{ Fs Fs Fc Fc Fs}[12] Fi FC37{ Fs Fs}[4] Fi FC38{ m Fp Fp}}}} FC39{ m FC40{ BC19 BC21 v58 v59 v60 v61 v62 v63 FC41{ BC23 FC42{ m FC38 FC13}} FC41 FC43{ BC23 FC44{ m FC7}}} FC45{ BC46{ BC30 vd v64 Fp Fp FC31 FC10} vd FC47{ m Fp Fi FC48{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC38}}}}}


 S602C1 ::~S602C1(){ note_dtor("S602C1", this);}
void  S602C1 ::v1(){vfunc_called(this, "_ZN6S602C12v1Ev");}
void  S602C1 ::v2(){vfunc_called(this, "_ZN6S602C12v2Ev");}
void  S602C1 ::v3(){vfunc_called(this, "_ZN6S602C12v3Ev");}
void  S602C1 ::v4(){vfunc_called(this, "_ZN6S602C12v4Ev");}
S602C1 ::S602C1(){ note_ctor("S602C1", this);} // tgen

static void Test_S602C1()
{
  extern Class_Descriptor cd_S602C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(140,204)];
    init_test(&cd_S602C1, buf);
    S602C1 *dp, &lv = *(dp=new (buf) S602C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1112,812), "sizeof(S602C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S602C1)");
    check_base_class_offset(lv, (S602C5*)(S602C4*)(S602C3*)(S602C2*), 0, "S602C1");
    check_base_class_offset(lv, (S602C4*)(S602C3*)(S602C2*), 0, "S602C1");
    check_base_class_offset(lv, (S602C3*)(S602C2*), 0, "S602C1");
    check_base_class_offset(lv, (S602C2*), 0, "S602C1");
    check_field_offset(lv, s602c1f0, ABISELECT(392,308), "S602C1.s602c1f0");
    test_class_info(&lv, &cd_S602C1);
    dp->~S602C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS602C1(Test_S602C1, "S602C1", ABISELECT(1112,812));

#else // __cplusplus

extern void _ZN6S602C1C1Ev();
extern void _ZN6S602C1D1Ev();
Name_Map name_map_S602C1[] = {
  NSPAIR(_ZN6S602C1C1Ev),
  NSPAIR(_ZN6S602C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S602C5;
extern VTBL_ENTRY _ZTI6S602C5[];
extern  VTBL_ENTRY _ZTV6S602C5[];
extern Class_Descriptor cd_S602C4;
extern VTBL_ENTRY _ZTI6S602C4[];
extern  VTBL_ENTRY _ZTV6S602C4[];
extern Class_Descriptor cd_S602C3;
extern VTBL_ENTRY _ZTI6S602C3[];
extern  VTBL_ENTRY _ZTV6S602C3[];
extern Class_Descriptor cd_S602C2;
extern VTBL_ENTRY _ZTI6S602C2[];
extern  VTBL_ENTRY _ZTV6S602C2[];
static Base_Class bases_S602C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S602C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S602C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S602C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S602C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S602C1[];
extern void _ZN6S602C1D1Ev();
extern void _ZN6S602C1D0Ev();
extern void _ZN6S602C52v5Ev();
extern void _ZN6S602C52v6Ev();
extern void _ZN6S602C52v7Ev();
extern void _ZN6S602C52v8Ev();
extern void _ZN6S602C52v9Ev();
extern void _ZN6S602C53v10Ev();
extern void _ZN6S602C53v11Ev();
extern void _ZN6S602C53v12Ev();
extern void _ZN6S602C53v13Ev();
extern void _ZN6S602C53v14Ev();
extern void _ZN6S602C53v15Ev();
extern void _ZN6S602C53v16Ev();
extern void _ZN6S602C53v17Ev();
extern void _ZN6S602C53v18Ev();
extern void _ZN6S602C53v19Ev();
extern void _ZN6S602C43v20Ev();
extern void _ZN6S602C43v21Ev();
extern void _ZN6S602C43v22Ev();
extern void _ZN6S602C43v23Ev();
extern void _ZN6S602C43v24Ev();
extern void _ZN6S602C43v25Ev();
extern void _ZN6S602C43v26Ev();
extern void _ZN6S602C43v27Ev();
extern void _ZN6S602C43v28Ev();
extern void _ZN6S602C43v29Ev();
extern void _ZN6S602C43v30Ev();
extern void _ZN6S602C43v31Ev();
extern void _ZN6S602C43v32Ev();
extern void _ZN6S602C43v33Ev();
extern void _ZN6S602C43v34Ev();
extern void _ZN6S602C33v35Ev();
extern void _ZN6S602C33v36Ev();
extern void _ZN6S602C33v37Ev();
extern void _ZN6S602C33v38Ev();
extern void _ZN6S602C33v39Ev();
extern void _ZN6S602C23v40Ev();
extern void _ZN6S602C23v41Ev();
extern void _ZN6S602C23v42Ev();
extern void _ZN6S602C23v43Ev();
extern void _ZN6S602C12v1Ev();
extern void _ZN6S602C12v2Ev();
extern void _ZN6S602C12v3Ev();
extern void _ZN6S602C12v4Ev();
static  VTBL_ENTRY vtc_S602C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S602C1[0]),
  (VTBL_ENTRY)&_ZN6S602C1D1Ev,
  (VTBL_ENTRY)&_ZN6S602C1D0Ev,
  (VTBL_ENTRY)&_ZN6S602C52v5Ev,
  (VTBL_ENTRY)&_ZN6S602C52v6Ev,
  (VTBL_ENTRY)&_ZN6S602C52v7Ev,
  (VTBL_ENTRY)&_ZN6S602C52v8Ev,
  (VTBL_ENTRY)&_ZN6S602C52v9Ev,
  (VTBL_ENTRY)&_ZN6S602C53v10Ev,
  (VTBL_ENTRY)&_ZN6S602C53v11Ev,
  (VTBL_ENTRY)&_ZN6S602C53v12Ev,
  (VTBL_ENTRY)&_ZN6S602C53v13Ev,
  (VTBL_ENTRY)&_ZN6S602C53v14Ev,
  (VTBL_ENTRY)&_ZN6S602C53v15Ev,
  (VTBL_ENTRY)&_ZN6S602C53v16Ev,
  (VTBL_ENTRY)&_ZN6S602C53v17Ev,
  (VTBL_ENTRY)&_ZN6S602C53v18Ev,
  (VTBL_ENTRY)&_ZN6S602C53v19Ev,
  (VTBL_ENTRY)&_ZN6S602C43v20Ev,
  (VTBL_ENTRY)&_ZN6S602C43v21Ev,
  (VTBL_ENTRY)&_ZN6S602C43v22Ev,
  (VTBL_ENTRY)&_ZN6S602C43v23Ev,
  (VTBL_ENTRY)&_ZN6S602C43v24Ev,
  (VTBL_ENTRY)&_ZN6S602C43v25Ev,
  (VTBL_ENTRY)&_ZN6S602C43v26Ev,
  (VTBL_ENTRY)&_ZN6S602C43v27Ev,
  (VTBL_ENTRY)&_ZN6S602C43v28Ev,
  (VTBL_ENTRY)&_ZN6S602C43v29Ev,
  (VTBL_ENTRY)&_ZN6S602C43v30Ev,
  (VTBL_ENTRY)&_ZN6S602C43v31Ev,
  (VTBL_ENTRY)&_ZN6S602C43v32Ev,
  (VTBL_ENTRY)&_ZN6S602C43v33Ev,
  (VTBL_ENTRY)&_ZN6S602C43v34Ev,
  (VTBL_ENTRY)&_ZN6S602C33v35Ev,
  (VTBL_ENTRY)&_ZN6S602C33v36Ev,
  (VTBL_ENTRY)&_ZN6S602C33v37Ev,
  (VTBL_ENTRY)&_ZN6S602C33v38Ev,
  (VTBL_ENTRY)&_ZN6S602C33v39Ev,
  (VTBL_ENTRY)&_ZN6S602C23v40Ev,
  (VTBL_ENTRY)&_ZN6S602C23v41Ev,
  (VTBL_ENTRY)&_ZN6S602C23v42Ev,
  (VTBL_ENTRY)&_ZN6S602C23v43Ev,
  (VTBL_ENTRY)&_ZN6S602C12v1Ev,
  (VTBL_ENTRY)&_ZN6S602C12v2Ev,
  (VTBL_ENTRY)&_ZN6S602C12v3Ev,
  (VTBL_ENTRY)&_ZN6S602C12v4Ev,
};
extern VTBL_ENTRY _ZTI6S602C1[];
extern  VTBL_ENTRY _ZTV6S602C1[];
Class_Descriptor cd_S602C1 = {  "S602C1", // class name
  bases_S602C1, 4,
  &(vtc_S602C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1112,812), // object size
  NSPAIRA(_ZTI6S602C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S602C1),47, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S603C5  {
  ::S2120C13_nt s603c5f0;
  ::S2120C13_nt s603c5f1;
  void *s603c5f2;
  int s603c5f3;
  ::S601C8 s603c5f4;
  int s603c5f5:2;
  int s603c5f6:2;
  unsigned char s603c5f7:1;
  unsigned char s603c5f8:1;
  ::S601C53 s603c5f9;
  ::S601C11 s603c5f10[2];
  virtual  ~S603C5(); // _ZN6S603C5D1Ev
  virtual void  v5(); // _ZN6S603C52v5Ev
  virtual void  v6(); // _ZN6S603C52v6Ev
  virtual void  v7(); // _ZN6S603C52v7Ev
  virtual void  v8(); // _ZN6S603C52v8Ev
  virtual void  v9(); // _ZN6S603C52v9Ev
  virtual void  v10(); // _ZN6S603C53v10Ev
  virtual void  v11(); // _ZN6S603C53v11Ev
  virtual void  v12(); // _ZN6S603C53v12Ev
  virtual void  v13(); // _ZN6S603C53v13Ev
  virtual void  v14(); // _ZN6S603C53v14Ev
  virtual void  v15(); // _ZN6S603C53v15Ev
  virtual void  v16(); // _ZN6S603C53v16Ev
  virtual void  v17(); // _ZN6S603C53v17Ev
  virtual void  v18(); // _ZN6S603C53v18Ev
  virtual void  v19(); // _ZN6S603C53v19Ev
  S603C5(); // tgen
};
//SIG(-1 S603C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 FC2{ m FC3{ m FL[2]}} FC2 Fp Fi FU4{ m FC5{ Fi:4 Fi:4 Fi:4 Fi:2 Fi:1 Fi:17} Fi} Fi:2 Fi:2 Fc:1 Fc:1 FC6{ m Fp Fp} FC7{ Fp Fp}[2]}


 S603C5 ::~S603C5(){ note_dtor("S603C5", this);}
void  S603C5 ::v5(){vfunc_called(this, "_ZN6S603C52v5Ev");}
void  S603C5 ::v6(){vfunc_called(this, "_ZN6S603C52v6Ev");}
void  S603C5 ::v7(){vfunc_called(this, "_ZN6S603C52v7Ev");}
void  S603C5 ::v8(){vfunc_called(this, "_ZN6S603C52v8Ev");}
void  S603C5 ::v9(){vfunc_called(this, "_ZN6S603C52v9Ev");}
void  S603C5 ::v10(){vfunc_called(this, "_ZN6S603C53v10Ev");}
void  S603C5 ::v11(){vfunc_called(this, "_ZN6S603C53v11Ev");}
void  S603C5 ::v12(){vfunc_called(this, "_ZN6S603C53v12Ev");}
void  S603C5 ::v13(){vfunc_called(this, "_ZN6S603C53v13Ev");}
void  S603C5 ::v14(){vfunc_called(this, "_ZN6S603C53v14Ev");}
void  S603C5 ::v15(){vfunc_called(this, "_ZN6S603C53v15Ev");}
void  S603C5 ::v16(){vfunc_called(this, "_ZN6S603C53v16Ev");}
void  S603C5 ::v17(){vfunc_called(this, "_ZN6S603C53v17Ev");}
void  S603C5 ::v18(){vfunc_called(this, "_ZN6S603C53v18Ev");}
void  S603C5 ::v19(){vfunc_called(this, "_ZN6S603C53v19Ev");}
S603C5 ::S603C5(){ note_ctor("S603C5", this);} // tgen

static void Test_S603C5()
{
  extern Class_Descriptor cd_S603C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,20)];
    init_test(&cd_S603C5, buf);
    S603C5 *dp, &lv = *(dp=new (buf) S603C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,76), "sizeof(S603C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S603C5)");
    check_field_offset(lv, s603c5f0, ABISELECT(8,4), "S603C5.s603c5f0");
    check_field_offset(lv, s603c5f1, ABISELECT(24,20), "S603C5.s603c5f1");
    check_field_offset(lv, s603c5f2, ABISELECT(40,36), "S603C5.s603c5f2");
    check_field_offset(lv, s603c5f3, ABISELECT(48,40), "S603C5.s603c5f3");
    check_field_offset(lv, s603c5f4, ABISELECT(52,44), "S603C5.s603c5f4");
    set_bf_and_test(lv, s603c5f5, ABISELECT(56,48), 0, 2, 1, "S603C5");
    set_bf_and_test(lv, s603c5f5, ABISELECT(56,48), 0, 2, hide_sll(1LL<<1), "S603C5");
    set_bf_and_test(lv, s603c5f6, ABISELECT(56,48), 2, 2, 1, "S603C5");
    set_bf_and_test(lv, s603c5f6, ABISELECT(56,48), 2, 2, hide_sll(1LL<<1), "S603C5");
    set_bf_and_test(lv, s603c5f7, ABISELECT(56,48), 4, 1, 1, "S603C5");
    set_bf_and_test(lv, s603c5f8, ABISELECT(56,48), 5, 1, 1, "S603C5");
    check_field_offset(lv, s603c5f9, ABISELECT(64,52), "S603C5.s603c5f9");
    check_field_offset(lv, s603c5f10, ABISELECT(80,60), "S603C5.s603c5f10");
    test_class_info(&lv, &cd_S603C5);
    dp->~S603C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS603C5(Test_S603C5, "S603C5", ABISELECT(112,76));

#else // __cplusplus

extern void _ZN6S603C5C1Ev();
extern void _ZN6S603C5D1Ev();
Name_Map name_map_S603C5[] = {
  NSPAIR(_ZN6S603C5C1Ev),
  NSPAIR(_ZN6S603C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S603C5[];
extern void _ZN6S603C5D1Ev();
extern void _ZN6S603C5D0Ev();
extern void _ZN6S603C52v5Ev();
extern void _ZN6S603C52v6Ev();
extern void _ZN6S603C52v7Ev();
extern void _ZN6S603C52v8Ev();
extern void _ZN6S603C52v9Ev();
extern void _ZN6S603C53v10Ev();
extern void _ZN6S603C53v11Ev();
extern void _ZN6S603C53v12Ev();
extern void _ZN6S603C53v13Ev();
extern void _ZN6S603C53v14Ev();
extern void _ZN6S603C53v15Ev();
extern void _ZN6S603C53v16Ev();
extern void _ZN6S603C53v17Ev();
extern void _ZN6S603C53v18Ev();
extern void _ZN6S603C53v19Ev();
static  VTBL_ENTRY vtc_S603C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S603C5[0]),
  (VTBL_ENTRY)&_ZN6S603C5D1Ev,
  (VTBL_ENTRY)&_ZN6S603C5D0Ev,
  (VTBL_ENTRY)&_ZN6S603C52v5Ev,
  (VTBL_ENTRY)&_ZN6S603C52v6Ev,
  (VTBL_ENTRY)&_ZN6S603C52v7Ev,
  (VTBL_ENTRY)&_ZN6S603C52v8Ev,
  (VTBL_ENTRY)&_ZN6S603C52v9Ev,
  (VTBL_ENTRY)&_ZN6S603C53v10Ev,
  (VTBL_ENTRY)&_ZN6S603C53v11Ev,
  (VTBL_ENTRY)&_ZN6S603C53v12Ev,
  (VTBL_ENTRY)&_ZN6S603C53v13Ev,
  (VTBL_ENTRY)&_ZN6S603C53v14Ev,
  (VTBL_ENTRY)&_ZN6S603C53v15Ev,
  (VTBL_ENTRY)&_ZN6S603C53v16Ev,
  (VTBL_ENTRY)&_ZN6S603C53v17Ev,
  (VTBL_ENTRY)&_ZN6S603C53v18Ev,
  (VTBL_ENTRY)&_ZN6S603C53v19Ev,
};
extern VTBL_ENTRY _ZTI6S603C5[];
extern  VTBL_ENTRY _ZTV6S603C5[];
Class_Descriptor cd_S603C5 = {  "S603C5", // class name
  0,0,//no base classes
  &(vtc_S603C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,76), // object size
  NSPAIRA(_ZTI6S603C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S603C5),19, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S603C4  : S603C5 {
  unsigned char s603c4f0:1;
  unsigned char s603c4f1:1;
  unsigned char s603c4f2:1;
  unsigned char s603c4f3:1;
  unsigned char s603c4f4:1;
  unsigned char s603c4f5:1;
  unsigned char s603c4f6:1;
  char s603c4f7;
  int s603c4f8[2];
  int s603c4f9[2];
  void *s603c4f10;
  ::S2120C13_nt s603c4f11;
  ::S2120C13_nt s603c4f12;
  ::S2120C13_nt s603c4f13;
  ::S601C12 s603c4f14;
  void *s603c4f15;
  int s603c4f16;
  int s603c4f17;
  ::S601C13_nt s603c4f18[4];
  void *s603c4f19;
  virtual  ~S603C4(); // _ZN6S603C4D1Ev
  virtual void  v20(); // _ZN6S603C43v20Ev
  virtual void  v21(); // _ZN6S603C43v21Ev
  virtual void  v22(); // _ZN6S603C43v22Ev
  virtual void  v23(); // _ZN6S603C43v23Ev
  virtual void  v24(); // _ZN6S603C43v24Ev
  virtual void  v25(); // _ZN6S603C43v25Ev
  virtual void  v26(); // _ZN6S603C43v26Ev
  virtual void  v27(); // _ZN6S603C43v27Ev
  virtual void  v28(); // _ZN6S603C43v28Ev
  virtual void  v29(); // _ZN6S603C43v29Ev
  virtual void  v30(); // _ZN6S603C43v30Ev
  virtual void  v31(); // _ZN6S603C43v31Ev
  virtual void  v32(); // _ZN6S603C43v32Ev
  virtual void  v33(); // _ZN6S603C43v33Ev
  virtual void  v34(); // _ZN6S603C43v34Ev
  S603C4(); // tgen
};
//SIG(-1 S603C4) C1{ BC2{ vd v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 FC3{ m FC4{ m FL[2]}} FC3 Fp Fi FU5{ m FC6{ Fi:4 Fi:4 Fi:4 Fi:2 Fi:1 Fi:17} Fi} Fi:2 Fi:2 Fc:1 Fc:1 FC7{ m Fp Fp} FC8{ Fp Fp}[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc Fi[2] Fi[2] Fp FC3 FC3 FC3 FC9{ m FC3 FC3} Fp Fi Fi FC10{ m Fp}[4] Fp}


 S603C4 ::~S603C4(){ note_dtor("S603C4", this);}
void  S603C4 ::v20(){vfunc_called(this, "_ZN6S603C43v20Ev");}
void  S603C4 ::v21(){vfunc_called(this, "_ZN6S603C43v21Ev");}
void  S603C4 ::v22(){vfunc_called(this, "_ZN6S603C43v22Ev");}
void  S603C4 ::v23(){vfunc_called(this, "_ZN6S603C43v23Ev");}
void  S603C4 ::v24(){vfunc_called(this, "_ZN6S603C43v24Ev");}
void  S603C4 ::v25(){vfunc_called(this, "_ZN6S603C43v25Ev");}
void  S603C4 ::v26(){vfunc_called(this, "_ZN6S603C43v26Ev");}
void  S603C4 ::v27(){vfunc_called(this, "_ZN6S603C43v27Ev");}
void  S603C4 ::v28(){vfunc_called(this, "_ZN6S603C43v28Ev");}
void  S603C4 ::v29(){vfunc_called(this, "_ZN6S603C43v29Ev");}
void  S603C4 ::v30(){vfunc_called(this, "_ZN6S603C43v30Ev");}
void  S603C4 ::v31(){vfunc_called(this, "_ZN6S603C43v31Ev");}
void  S603C4 ::v32(){vfunc_called(this, "_ZN6S603C43v32Ev");}
void  S603C4 ::v33(){vfunc_called(this, "_ZN6S603C43v33Ev");}
void  S603C4 ::v34(){vfunc_called(this, "_ZN6S603C43v34Ev");}
S603C4 ::S603C4(){ note_ctor("S603C4", this);} // tgen

static void Test_S603C4()
{
  extern Class_Descriptor cd_S603C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(36,54)];
    init_test(&cd_S603C4, buf);
    S603C4 *dp, &lv = *(dp=new (buf) S603C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(280,212), "sizeof(S603C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S603C4)");
    check_base_class_offset(lv, (S603C5*), 0, "S603C4");
    set_bf_and_test(lv, s603c4f0, ABISELECT(112,76), 0, 1, 1, "S603C4");
    set_bf_and_test(lv, s603c4f1, ABISELECT(112,76), 1, 1, 1, "S603C4");
    set_bf_and_test(lv, s603c4f2, ABISELECT(112,76), 2, 1, 1, "S603C4");
    set_bf_and_test(lv, s603c4f3, ABISELECT(112,76), 3, 1, 1, "S603C4");
    set_bf_and_test(lv, s603c4f4, ABISELECT(112,76), 4, 1, 1, "S603C4");
    set_bf_and_test(lv, s603c4f5, ABISELECT(112,76), 5, 1, 1, "S603C4");
    set_bf_and_test(lv, s603c4f6, ABISELECT(112,76), 6, 1, 1, "S603C4");
    check_field_offset(lv, s603c4f7, ABISELECT(113,77), "S603C4.s603c4f7");
    check_field_offset(lv, s603c4f8, ABISELECT(116,80), "S603C4.s603c4f8");
    check_field_offset(lv, s603c4f9, ABISELECT(124,88), "S603C4.s603c4f9");
    check_field_offset(lv, s603c4f10, ABISELECT(136,96), "S603C4.s603c4f10");
    check_field_offset(lv, s603c4f11, ABISELECT(144,100), "S603C4.s603c4f11");
    check_field_offset(lv, s603c4f12, ABISELECT(160,116), "S603C4.s603c4f12");
    check_field_offset(lv, s603c4f13, ABISELECT(176,132), "S603C4.s603c4f13");
    check_field_offset(lv, s603c4f14, ABISELECT(192,148), "S603C4.s603c4f14");
    check_field_offset(lv, s603c4f15, ABISELECT(224,180), "S603C4.s603c4f15");
    check_field_offset(lv, s603c4f16, ABISELECT(232,184), "S603C4.s603c4f16");
    check_field_offset(lv, s603c4f17, ABISELECT(236,188), "S603C4.s603c4f17");
    check_field_offset(lv, s603c4f18, ABISELECT(240,192), "S603C4.s603c4f18");
    check_field_offset(lv, s603c4f19, ABISELECT(272,208), "S603C4.s603c4f19");
    test_class_info(&lv, &cd_S603C4);
    dp->~S603C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS603C4(Test_S603C4, "S603C4", ABISELECT(280,212));

#else // __cplusplus

extern void _ZN6S603C4C1Ev();
extern void _ZN6S603C4D1Ev();
Name_Map name_map_S603C4[] = {
  NSPAIR(_ZN6S603C4C1Ev),
  NSPAIR(_ZN6S603C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S603C5;
extern VTBL_ENTRY _ZTI6S603C5[];
extern  VTBL_ENTRY _ZTV6S603C5[];
static Base_Class bases_S603C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S603C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S603C4[];
extern void _ZN6S603C4D1Ev();
extern void _ZN6S603C4D0Ev();
extern void _ZN6S603C52v5Ev();
extern void _ZN6S603C52v6Ev();
extern void _ZN6S603C52v7Ev();
extern void _ZN6S603C52v8Ev();
extern void _ZN6S603C52v9Ev();
extern void _ZN6S603C53v10Ev();
extern void _ZN6S603C53v11Ev();
extern void _ZN6S603C53v12Ev();
extern void _ZN6S603C53v13Ev();
extern void _ZN6S603C53v14Ev();
extern void _ZN6S603C53v15Ev();
extern void _ZN6S603C53v16Ev();
extern void _ZN6S603C53v17Ev();
extern void _ZN6S603C53v18Ev();
extern void _ZN6S603C53v19Ev();
extern void _ZN6S603C43v20Ev();
extern void _ZN6S603C43v21Ev();
extern void _ZN6S603C43v22Ev();
extern void _ZN6S603C43v23Ev();
extern void _ZN6S603C43v24Ev();
extern void _ZN6S603C43v25Ev();
extern void _ZN6S603C43v26Ev();
extern void _ZN6S603C43v27Ev();
extern void _ZN6S603C43v28Ev();
extern void _ZN6S603C43v29Ev();
extern void _ZN6S603C43v30Ev();
extern void _ZN6S603C43v31Ev();
extern void _ZN6S603C43v32Ev();
extern void _ZN6S603C43v33Ev();
extern void _ZN6S603C43v34Ev();
static  VTBL_ENTRY vtc_S603C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S603C4[0]),
  (VTBL_ENTRY)&_ZN6S603C4D1Ev,
  (VTBL_ENTRY)&_ZN6S603C4D0Ev,
  (VTBL_ENTRY)&_ZN6S603C52v5Ev,
  (VTBL_ENTRY)&_ZN6S603C52v6Ev,
  (VTBL_ENTRY)&_ZN6S603C52v7Ev,
  (VTBL_ENTRY)&_ZN6S603C52v8Ev,
  (VTBL_ENTRY)&_ZN6S603C52v9Ev,
  (VTBL_ENTRY)&_ZN6S603C53v10Ev,
  (VTBL_ENTRY)&_ZN6S603C53v11Ev,
  (VTBL_ENTRY)&_ZN6S603C53v12Ev,
  (VTBL_ENTRY)&_ZN6S603C53v13Ev,
  (VTBL_ENTRY)&_ZN6S603C53v14Ev,
  (VTBL_ENTRY)&_ZN6S603C53v15Ev,
  (VTBL_ENTRY)&_ZN6S603C53v16Ev,
  (VTBL_ENTRY)&_ZN6S603C53v17Ev,
  (VTBL_ENTRY)&_ZN6S603C53v18Ev,
  (VTBL_ENTRY)&_ZN6S603C53v19Ev,
  (VTBL_ENTRY)&_ZN6S603C43v20Ev,
  (VTBL_ENTRY)&_ZN6S603C43v21Ev,
  (VTBL_ENTRY)&_ZN6S603C43v22Ev,
  (VTBL_ENTRY)&_ZN6S603C43v23Ev,
  (VTBL_ENTRY)&_ZN6S603C43v24Ev,
  (VTBL_ENTRY)&_ZN6S603C43v25Ev,
  (VTBL_ENTRY)&_ZN6S603C43v26Ev,
  (VTBL_ENTRY)&_ZN6S603C43v27Ev,
  (VTBL_ENTRY)&_ZN6S603C43v28Ev,
  (VTBL_ENTRY)&_ZN6S603C43v29Ev,
  (VTBL_ENTRY)&_ZN6S603C43v30Ev,
  (VTBL_ENTRY)&_ZN6S603C43v31Ev,
  (VTBL_ENTRY)&_ZN6S603C43v32Ev,
  (VTBL_ENTRY)&_ZN6S603C43v33Ev,
  (VTBL_ENTRY)&_ZN6S603C43v34Ev,
};
extern VTBL_ENTRY _ZTI6S603C4[];
extern  VTBL_ENTRY _ZTV6S603C4[];
Class_Descriptor cd_S603C4 = {  "S603C4", // class name
  bases_S603C4, 1,
  &(vtc_S603C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(280,212), // object size
  NSPAIRA(_ZTI6S603C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S603C4),34, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S603C3  : S603C4 {
  ::S601C13_nt s603c3f0;
  ::S601C13_nt s603c3f1;
  ::S601C13_nt s603c3f2;
  ::S601C13_nt s603c3f3;
  ::S2120C13_nt s603c3f4;
  ::S2120C13_nt s603c3f5;
  ::S2120C13_nt s603c3f6;
  ::S2120C13_nt s603c3f7;
  ::S601C14 s603c3f8;
  virtual  ~S603C3(); // _ZN6S603C3D1Ev
  virtual void  v35(); // _ZN6S603C33v35Ev
  virtual void  v36(); // _ZN6S603C33v36Ev
  virtual void  v37(); // _ZN6S603C33v37Ev
  virtual void  v38(); // _ZN6S603C33v38Ev
  virtual void  v39(); // _ZN6S603C33v39Ev
  S603C3(); // tgen
};
//SIG(-1 S603C3) C1{ BC2{ BC3{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 FC4{ m FC5{ m FL[2]}} FC4 Fp Fi FU6{ m FC7{ Fi:4 Fi:4 Fi:4 Fi:2 Fi:1 Fi:17} Fi} Fi:2 Fi:2 Fc:1 Fc:1 FC8{ m Fp Fp} FC9{ Fp Fp}[2]} vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc Fi[2] Fi[2] Fp FC4 FC4 FC4 FC10{ m FC4 FC4} Fp Fi Fi FC11{ m Fp}[4] Fp} vd v1 v2 v3 v4 v5 FC11 FC11 FC11 FC11 FC4 FC4 FC4 FC4 FC12{ m FC13{ m FL FL}}}


 S603C3 ::~S603C3(){ note_dtor("S603C3", this);}
void  S603C3 ::v35(){vfunc_called(this, "_ZN6S603C33v35Ev");}
void  S603C3 ::v36(){vfunc_called(this, "_ZN6S603C33v36Ev");}
void  S603C3 ::v37(){vfunc_called(this, "_ZN6S603C33v37Ev");}
void  S603C3 ::v38(){vfunc_called(this, "_ZN6S603C33v38Ev");}
void  S603C3 ::v39(){vfunc_called(this, "_ZN6S603C33v39Ev");}
S603C3 ::S603C3(){ note_ctor("S603C3", this);} // tgen

static void Test_S603C3()
{
  extern Class_Descriptor cd_S603C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(50,78)];
    init_test(&cd_S603C3, buf);
    S603C3 *dp, &lv = *(dp=new (buf) S603C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(392,308), "sizeof(S603C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S603C3)");
    check_base_class_offset(lv, (S603C5*)(S603C4*), 0, "S603C3");
    check_base_class_offset(lv, (S603C4*), 0, "S603C3");
    check_field_offset(lv, s603c3f0, ABISELECT(280,212), "S603C3.s603c3f0");
    check_field_offset(lv, s603c3f1, ABISELECT(288,216), "S603C3.s603c3f1");
    check_field_offset(lv, s603c3f2, ABISELECT(296,220), "S603C3.s603c3f2");
    check_field_offset(lv, s603c3f3, ABISELECT(304,224), "S603C3.s603c3f3");
    check_field_offset(lv, s603c3f4, ABISELECT(312,228), "S603C3.s603c3f4");
    check_field_offset(lv, s603c3f5, ABISELECT(328,244), "S603C3.s603c3f5");
    check_field_offset(lv, s603c3f6, ABISELECT(344,260), "S603C3.s603c3f6");
    check_field_offset(lv, s603c3f7, ABISELECT(360,276), "S603C3.s603c3f7");
    check_field_offset(lv, s603c3f8, ABISELECT(376,292), "S603C3.s603c3f8");
    test_class_info(&lv, &cd_S603C3);
    dp->~S603C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS603C3(Test_S603C3, "S603C3", ABISELECT(392,308));

#else // __cplusplus

extern void _ZN6S603C3C1Ev();
extern void _ZN6S603C3D1Ev();
Name_Map name_map_S603C3[] = {
  NSPAIR(_ZN6S603C3C1Ev),
  NSPAIR(_ZN6S603C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S603C5;
extern VTBL_ENTRY _ZTI6S603C5[];
extern  VTBL_ENTRY _ZTV6S603C5[];
extern Class_Descriptor cd_S603C4;
extern VTBL_ENTRY _ZTI6S603C4[];
extern  VTBL_ENTRY _ZTV6S603C4[];
static Base_Class bases_S603C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S603C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S603C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S603C3[];
extern void _ZN6S603C3D1Ev();
extern void _ZN6S603C3D0Ev();
extern void _ZN6S603C52v5Ev();
extern void _ZN6S603C52v6Ev();
extern void _ZN6S603C52v7Ev();
extern void _ZN6S603C52v8Ev();
extern void _ZN6S603C52v9Ev();
extern void _ZN6S603C53v10Ev();
extern void _ZN6S603C53v11Ev();
extern void _ZN6S603C53v12Ev();
extern void _ZN6S603C53v13Ev();
extern void _ZN6S603C53v14Ev();
extern void _ZN6S603C53v15Ev();
extern void _ZN6S603C53v16Ev();
extern void _ZN6S603C53v17Ev();
extern void _ZN6S603C53v18Ev();
extern void _ZN6S603C53v19Ev();
extern void _ZN6S603C43v20Ev();
extern void _ZN6S603C43v21Ev();
extern void _ZN6S603C43v22Ev();
extern void _ZN6S603C43v23Ev();
extern void _ZN6S603C43v24Ev();
extern void _ZN6S603C43v25Ev();
extern void _ZN6S603C43v26Ev();
extern void _ZN6S603C43v27Ev();
extern void _ZN6S603C43v28Ev();
extern void _ZN6S603C43v29Ev();
extern void _ZN6S603C43v30Ev();
extern void _ZN6S603C43v31Ev();
extern void _ZN6S603C43v32Ev();
extern void _ZN6S603C43v33Ev();
extern void _ZN6S603C43v34Ev();
extern void _ZN6S603C33v35Ev();
extern void _ZN6S603C33v36Ev();
extern void _ZN6S603C33v37Ev();
extern void _ZN6S603C33v38Ev();
extern void _ZN6S603C33v39Ev();
static  VTBL_ENTRY vtc_S603C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S603C3[0]),
  (VTBL_ENTRY)&_ZN6S603C3D1Ev,
  (VTBL_ENTRY)&_ZN6S603C3D0Ev,
  (VTBL_ENTRY)&_ZN6S603C52v5Ev,
  (VTBL_ENTRY)&_ZN6S603C52v6Ev,
  (VTBL_ENTRY)&_ZN6S603C52v7Ev,
  (VTBL_ENTRY)&_ZN6S603C52v8Ev,
  (VTBL_ENTRY)&_ZN6S603C52v9Ev,
  (VTBL_ENTRY)&_ZN6S603C53v10Ev,
  (VTBL_ENTRY)&_ZN6S603C53v11Ev,
  (VTBL_ENTRY)&_ZN6S603C53v12Ev,
  (VTBL_ENTRY)&_ZN6S603C53v13Ev,
  (VTBL_ENTRY)&_ZN6S603C53v14Ev,
  (VTBL_ENTRY)&_ZN6S603C53v15Ev,
  (VTBL_ENTRY)&_ZN6S603C53v16Ev,
  (VTBL_ENTRY)&_ZN6S603C53v17Ev,
  (VTBL_ENTRY)&_ZN6S603C53v18Ev,
  (VTBL_ENTRY)&_ZN6S603C53v19Ev,
  (VTBL_ENTRY)&_ZN6S603C43v20Ev,
  (VTBL_ENTRY)&_ZN6S603C43v21Ev,
  (VTBL_ENTRY)&_ZN6S603C43v22Ev,
  (VTBL_ENTRY)&_ZN6S603C43v23Ev,
  (VTBL_ENTRY)&_ZN6S603C43v24Ev,
  (VTBL_ENTRY)&_ZN6S603C43v25Ev,
  (VTBL_ENTRY)&_ZN6S603C43v26Ev,
  (VTBL_ENTRY)&_ZN6S603C43v27Ev,
  (VTBL_ENTRY)&_ZN6S603C43v28Ev,
  (VTBL_ENTRY)&_ZN6S603C43v29Ev,
  (VTBL_ENTRY)&_ZN6S603C43v30Ev,
  (VTBL_ENTRY)&_ZN6S603C43v31Ev,
  (VTBL_ENTRY)&_ZN6S603C43v32Ev,
  (VTBL_ENTRY)&_ZN6S603C43v33Ev,
  (VTBL_ENTRY)&_ZN6S603C43v34Ev,
  (VTBL_ENTRY)&_ZN6S603C33v35Ev,
  (VTBL_ENTRY)&_ZN6S603C33v36Ev,
  (VTBL_ENTRY)&_ZN6S603C33v37Ev,
  (VTBL_ENTRY)&_ZN6S603C33v38Ev,
  (VTBL_ENTRY)&_ZN6S603C33v39Ev,
};
extern VTBL_ENTRY _ZTI6S603C3[];
extern  VTBL_ENTRY _ZTV6S603C3[];
Class_Descriptor cd_S603C3 = {  "S603C3", // class name
  bases_S603C3, 2,
  &(vtc_S603C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(392,308), // object size
  NSPAIRA(_ZTI6S603C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S603C3),39, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S603C2  : S603C3 {
  virtual  ~S603C2(); // _ZN6S603C2D1Ev
  virtual void  v40(); // _ZN6S603C23v40Ev
  virtual void  v41(); // _ZN6S603C23v41Ev
  virtual void  v42(); // _ZN6S603C23v42Ev
  virtual void  v43(); // _ZN6S603C23v43Ev
  S603C2(); // tgen
};
//SIG(-1 S603C2) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 FC5{ m FC6{ m FL[2]}} FC5 Fp Fi FU7{ m FC8{ Fi:4 Fi:4 Fi:4 Fi:2 Fi:1 Fi:17} Fi} Fi:2 Fi:2 Fc:1 Fc:1 FC9{ m Fp Fp} FC10{ Fp Fp}[2]} vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc Fi[2] Fi[2] Fp FC5 FC5 FC5 FC11{ m FC5 FC5} Fp Fi Fi FC12{ m Fp}[4] Fp} vd v35 v36 v37 v38 v39 FC12 FC12 FC12 FC12 FC5 FC5 FC5 FC5 FC13{ m FC14{ m FL FL}}} vd v1 v2 v3 v4}


 S603C2 ::~S603C2(){ note_dtor("S603C2", this);}
void  S603C2 ::v40(){vfunc_called(this, "_ZN6S603C23v40Ev");}
void  S603C2 ::v41(){vfunc_called(this, "_ZN6S603C23v41Ev");}
void  S603C2 ::v42(){vfunc_called(this, "_ZN6S603C23v42Ev");}
void  S603C2 ::v43(){vfunc_called(this, "_ZN6S603C23v43Ev");}
S603C2 ::S603C2(){ note_ctor("S603C2", this);} // tgen

static void Test_S603C2()
{
  extern Class_Descriptor cd_S603C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(50,78)];
    init_test(&cd_S603C2, buf);
    S603C2 *dp, &lv = *(dp=new (buf) S603C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(392,308), "sizeof(S603C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S603C2)");
    check_base_class_offset(lv, (S603C5*)(S603C4*)(S603C3*), 0, "S603C2");
    check_base_class_offset(lv, (S603C4*)(S603C3*), 0, "S603C2");
    check_base_class_offset(lv, (S603C3*), 0, "S603C2");
    test_class_info(&lv, &cd_S603C2);
    dp->~S603C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS603C2(Test_S603C2, "S603C2", ABISELECT(392,308));

#else // __cplusplus

extern void _ZN6S603C2C1Ev();
extern void _ZN6S603C2D1Ev();
Name_Map name_map_S603C2[] = {
  NSPAIR(_ZN6S603C2C1Ev),
  NSPAIR(_ZN6S603C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S603C5;
extern VTBL_ENTRY _ZTI6S603C5[];
extern  VTBL_ENTRY _ZTV6S603C5[];
extern Class_Descriptor cd_S603C4;
extern VTBL_ENTRY _ZTI6S603C4[];
extern  VTBL_ENTRY _ZTV6S603C4[];
extern Class_Descriptor cd_S603C3;
extern VTBL_ENTRY _ZTI6S603C3[];
extern  VTBL_ENTRY _ZTV6S603C3[];
static Base_Class bases_S603C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S603C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S603C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S603C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S603C2[];
extern void _ZN6S603C2D1Ev();
extern void _ZN6S603C2D0Ev();
extern void _ZN6S603C52v5Ev();
extern void _ZN6S603C52v6Ev();
extern void _ZN6S603C52v7Ev();
extern void _ZN6S603C52v8Ev();
extern void _ZN6S603C52v9Ev();
extern void _ZN6S603C53v10Ev();
extern void _ZN6S603C53v11Ev();
extern void _ZN6S603C53v12Ev();
extern void _ZN6S603C53v13Ev();
extern void _ZN6S603C53v14Ev();
extern void _ZN6S603C53v15Ev();
extern void _ZN6S603C53v16Ev();
extern void _ZN6S603C53v17Ev();
extern void _ZN6S603C53v18Ev();
extern void _ZN6S603C53v19Ev();
extern void _ZN6S603C43v20Ev();
extern void _ZN6S603C43v21Ev();
extern void _ZN6S603C43v22Ev();
extern void _ZN6S603C43v23Ev();
extern void _ZN6S603C43v24Ev();
extern void _ZN6S603C43v25Ev();
extern void _ZN6S603C43v26Ev();
extern void _ZN6S603C43v27Ev();
extern void _ZN6S603C43v28Ev();
extern void _ZN6S603C43v29Ev();
extern void _ZN6S603C43v30Ev();
extern void _ZN6S603C43v31Ev();
extern void _ZN6S603C43v32Ev();
extern void _ZN6S603C43v33Ev();
extern void _ZN6S603C43v34Ev();
extern void _ZN6S603C33v35Ev();
extern void _ZN6S603C33v36Ev();
extern void _ZN6S603C33v37Ev();
extern void _ZN6S603C33v38Ev();
extern void _ZN6S603C33v39Ev();
extern void _ZN6S603C23v40Ev();
extern void _ZN6S603C23v41Ev();
extern void _ZN6S603C23v42Ev();
extern void _ZN6S603C23v43Ev();
static  VTBL_ENTRY vtc_S603C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S603C2[0]),
  (VTBL_ENTRY)&_ZN6S603C2D1Ev,
  (VTBL_ENTRY)&_ZN6S603C2D0Ev,
  (VTBL_ENTRY)&_ZN6S603C52v5Ev,
  (VTBL_ENTRY)&_ZN6S603C52v6Ev,
  (VTBL_ENTRY)&_ZN6S603C52v7Ev,
  (VTBL_ENTRY)&_ZN6S603C52v8Ev,
  (VTBL_ENTRY)&_ZN6S603C52v9Ev,
  (VTBL_ENTRY)&_ZN6S603C53v10Ev,
  (VTBL_ENTRY)&_ZN6S603C53v11Ev,
  (VTBL_ENTRY)&_ZN6S603C53v12Ev,
  (VTBL_ENTRY)&_ZN6S603C53v13Ev,
  (VTBL_ENTRY)&_ZN6S603C53v14Ev,
  (VTBL_ENTRY)&_ZN6S603C53v15Ev,
  (VTBL_ENTRY)&_ZN6S603C53v16Ev,
  (VTBL_ENTRY)&_ZN6S603C53v17Ev,
  (VTBL_ENTRY)&_ZN6S603C53v18Ev,
  (VTBL_ENTRY)&_ZN6S603C53v19Ev,
  (VTBL_ENTRY)&_ZN6S603C43v20Ev,
  (VTBL_ENTRY)&_ZN6S603C43v21Ev,
  (VTBL_ENTRY)&_ZN6S603C43v22Ev,
  (VTBL_ENTRY)&_ZN6S603C43v23Ev,
  (VTBL_ENTRY)&_ZN6S603C43v24Ev,
  (VTBL_ENTRY)&_ZN6S603C43v25Ev,
  (VTBL_ENTRY)&_ZN6S603C43v26Ev,
  (VTBL_ENTRY)&_ZN6S603C43v27Ev,
  (VTBL_ENTRY)&_ZN6S603C43v28Ev,
  (VTBL_ENTRY)&_ZN6S603C43v29Ev,
  (VTBL_ENTRY)&_ZN6S603C43v30Ev,
  (VTBL_ENTRY)&_ZN6S603C43v31Ev,
  (VTBL_ENTRY)&_ZN6S603C43v32Ev,
  (VTBL_ENTRY)&_ZN6S603C43v33Ev,
  (VTBL_ENTRY)&_ZN6S603C43v34Ev,
  (VTBL_ENTRY)&_ZN6S603C33v35Ev,
  (VTBL_ENTRY)&_ZN6S603C33v36Ev,
  (VTBL_ENTRY)&_ZN6S603C33v37Ev,
  (VTBL_ENTRY)&_ZN6S603C33v38Ev,
  (VTBL_ENTRY)&_ZN6S603C33v39Ev,
  (VTBL_ENTRY)&_ZN6S603C23v40Ev,
  (VTBL_ENTRY)&_ZN6S603C23v41Ev,
  (VTBL_ENTRY)&_ZN6S603C23v42Ev,
  (VTBL_ENTRY)&_ZN6S603C23v43Ev,
};
extern VTBL_ENTRY _ZTI6S603C2[];
extern  VTBL_ENTRY _ZTV6S603C2[];
Class_Descriptor cd_S603C2 = {  "S603C2", // class name
  bases_S603C2, 3,
  &(vtc_S603C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(392,308), // object size
  NSPAIRA(_ZTI6S603C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S603C2),43, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S603C19  {
  ::S601C20 s603c19f0;
  virtual  ~S603C19(); // _ZN7S603C19D1Ev
  virtual void  v50(); // _ZN7S603C193v50Ev
  virtual void  v51(); // _ZN7S603C193v51Ev
  virtual void  v52(); // _ZN7S603C193v52Ev
  virtual void  v53(); // _ZN7S603C193v53Ev
  virtual void  v54(); // _ZN7S603C193v54Ev
  virtual void  v55(); // _ZN7S603C193v55Ev
  S603C19(); // tgen
};
//SIG(-1 S603C19) C1{ vd v1 v2 v3 v4 v5 v6 FC2{ m Fp[4]}}


 S603C19 ::~S603C19(){ note_dtor("S603C19", this);}
void  S603C19 ::v50(){vfunc_called(this, "_ZN7S603C193v50Ev");}
void  S603C19 ::v51(){vfunc_called(this, "_ZN7S603C193v51Ev");}
void  S603C19 ::v52(){vfunc_called(this, "_ZN7S603C193v52Ev");}
void  S603C19 ::v53(){vfunc_called(this, "_ZN7S603C193v53Ev");}
void  S603C19 ::v54(){vfunc_called(this, "_ZN7S603C193v54Ev");}
void  S603C19 ::v55(){vfunc_called(this, "_ZN7S603C193v55Ev");}
S603C19 ::S603C19(){ note_ctor("S603C19", this);} // tgen

static void Test_S603C19()
{
  extern Class_Descriptor cd_S603C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[6];
    init_test(&cd_S603C19, buf);
    S603C19 *dp, &lv = *(dp=new (buf) S603C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,20), "sizeof(S603C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S603C19)");
    check_field_offset(lv, s603c19f0, ABISELECT(8,4), "S603C19.s603c19f0");
    test_class_info(&lv, &cd_S603C19);
    dp->~S603C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS603C19(Test_S603C19, "S603C19", ABISELECT(40,20));

#else // __cplusplus

extern void _ZN7S603C19C1Ev();
extern void _ZN7S603C19D1Ev();
Name_Map name_map_S603C19[] = {
  NSPAIR(_ZN7S603C19C1Ev),
  NSPAIR(_ZN7S603C19D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S603C19[];
extern void _ZN7S603C19D1Ev();
extern void _ZN7S603C19D0Ev();
extern void _ZN7S603C193v50Ev();
extern void _ZN7S603C193v51Ev();
extern void _ZN7S603C193v52Ev();
extern void _ZN7S603C193v53Ev();
extern void _ZN7S603C193v54Ev();
extern void _ZN7S603C193v55Ev();
static  VTBL_ENTRY vtc_S603C19[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S603C19[0]),
  (VTBL_ENTRY)&_ZN7S603C19D1Ev,
  (VTBL_ENTRY)&_ZN7S603C19D0Ev,
  (VTBL_ENTRY)&_ZN7S603C193v50Ev,
  (VTBL_ENTRY)&_ZN7S603C193v51Ev,
  (VTBL_ENTRY)&_ZN7S603C193v52Ev,
  (VTBL_ENTRY)&_ZN7S603C193v53Ev,
  (VTBL_ENTRY)&_ZN7S603C193v54Ev,
  (VTBL_ENTRY)&_ZN7S603C193v55Ev,
};
extern VTBL_ENTRY _ZTI7S603C19[];
extern  VTBL_ENTRY _ZTV7S603C19[];
Class_Descriptor cd_S603C19 = {  "S603C19", // class name
  0,0,//no base classes
  &(vtc_S603C19[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,20), // object size
  NSPAIRA(_ZTI7S603C19),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S603C19),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S603C42  : S603C19 , S601C21_nt {
  ::S601C45 s603c42f0;
  ::S601C27 s603c42f1;
  virtual void  v58(); // _ZN7S603C423v58Ev
  virtual void  v59(); // _ZN7S603C423v59Ev
  virtual void  v60(); // _ZN7S603C423v60Ev
  virtual void  v61(); // _ZN7S603C423v61Ev
  virtual void  v62(); // _ZN7S603C423v62Ev
  virtual void  v63(); // _ZN7S603C423v63Ev
  ~S603C42(); // tgen
  S603C42(); // tgen
};
//SIG(-1 S603C42) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m Fp[2]} FC9{ m Fp}}} FC10{ BC6 FC11{ m FC12{ m FL[2]}}}}


void  S603C42 ::v58(){vfunc_called(this, "_ZN7S603C423v58Ev");}
void  S603C42 ::v59(){vfunc_called(this, "_ZN7S603C423v59Ev");}
void  S603C42 ::v60(){vfunc_called(this, "_ZN7S603C423v60Ev");}
void  S603C42 ::v61(){vfunc_called(this, "_ZN7S603C423v61Ev");}
void  S603C42 ::v62(){vfunc_called(this, "_ZN7S603C423v62Ev");}
void  S603C42 ::v63(){vfunc_called(this, "_ZN7S603C423v63Ev");}
S603C42 ::~S603C42(){ note_dtor("S603C42", this);} // tgen
S603C42 ::S603C42(){ note_ctor("S603C42", this);} // tgen

static void Test_S603C42()
{
  extern Class_Descriptor cd_S603C42;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,23)];
    init_test(&cd_S603C42, buf);
    S603C42 *dp, &lv = *(dp=new (buf) S603C42());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,88), "sizeof(S603C42)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S603C42)");
    check_base_class_offset(lv, (S603C19*), 0, "S603C42");
    check_base_class_offset(lv, (S601C21_nt*), 0, "S603C42");
    check_field_offset(lv, s603c42f0, ABISELECT(40,20), "S603C42.s603c42f0");
    check_field_offset(lv, s603c42f1, ABISELECT(96,52), "S603C42.s603c42f1");
    test_class_info(&lv, &cd_S603C42);
    dp->~S603C42();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS603C42(Test_S603C42, "S603C42", ABISELECT(144,88));

#else // __cplusplus

extern void _ZN7S603C42C1Ev();
extern void _ZN7S603C42D1Ev();
Name_Map name_map_S603C42[] = {
  NSPAIR(_ZN7S603C42C1Ev),
  NSPAIR(_ZN7S603C42D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S603C19;
extern VTBL_ENTRY _ZTI7S603C19[];
extern  VTBL_ENTRY _ZTV7S603C19[];
extern Class_Descriptor cd_S601C21_nt;
extern VTBL_ENTRY _ZTI10S601C21_nt[];
static Base_Class bases_S603C42[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S603C19,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S601C21_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S603C42[];
extern void _ZN7S603C42D1Ev();
extern void _ZN7S603C42D0Ev();
extern void _ZN7S603C193v50Ev();
extern void _ZN7S603C193v51Ev();
extern void _ZN7S603C193v52Ev();
extern void _ZN7S603C193v53Ev();
extern void _ZN7S603C193v54Ev();
extern void _ZN7S603C193v55Ev();
extern void _ZN7S603C423v58Ev();
extern void _ZN7S603C423v59Ev();
extern void _ZN7S603C423v60Ev();
extern void _ZN7S603C423v61Ev();
extern void _ZN7S603C423v62Ev();
extern void _ZN7S603C423v63Ev();
static  VTBL_ENTRY vtc_S603C42[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S603C42[0]),
  (VTBL_ENTRY)&_ZN7S603C42D1Ev,
  (VTBL_ENTRY)&_ZN7S603C42D0Ev,
  (VTBL_ENTRY)&_ZN7S603C193v50Ev,
  (VTBL_ENTRY)&_ZN7S603C193v51Ev,
  (VTBL_ENTRY)&_ZN7S603C193v52Ev,
  (VTBL_ENTRY)&_ZN7S603C193v53Ev,
  (VTBL_ENTRY)&_ZN7S603C193v54Ev,
  (VTBL_ENTRY)&_ZN7S603C193v55Ev,
  (VTBL_ENTRY)&_ZN7S603C423v58Ev,
  (VTBL_ENTRY)&_ZN7S603C423v59Ev,
  (VTBL_ENTRY)&_ZN7S603C423v60Ev,
  (VTBL_ENTRY)&_ZN7S603C423v61Ev,
  (VTBL_ENTRY)&_ZN7S603C423v62Ev,
  (VTBL_ENTRY)&_ZN7S603C423v63Ev,
};
extern VTBL_ENTRY _ZTI7S603C42[];
extern  VTBL_ENTRY _ZTV7S603C42[];
Class_Descriptor cd_S603C42 = {  "S603C42", // class name
  bases_S603C42, 2,
  &(vtc_S603C42[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,88), // object size
  NSPAIRA(_ZTI7S603C42),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S603C42),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S603C41  {
  ::S603C42 s603c41f0;
  ::S601C48 s603c41f1;
  void  mf603c41(); // _ZN7S603C418mf603c41Ev
};
//SIG(-1 S603C41) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}} FC11{ BC7 FC12{ m FC13{ m FL[2]}}}} FC14{ BC15{ BC16{ vd v13} vd v14 Fp[2] FC17{ m FC18{ m Fp Fi[2] FC19{ m}}} FC20{ m Fp[2]}} vd FC21{ m Fp Fi FC22{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC9}}}


void  S603C41 ::mf603c41(){}

static void Test_S603C41()
{
  {
    init_simple_test("S603C41");
    static S603C41 lv;
    check2(sizeof(lv), ABISELECT(248,148), "sizeof(S603C41)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S603C41)");
    check_field_offset(lv, s603c41f0, 0, "S603C41.s603c41f0");
    check_field_offset(lv, s603c41f1, ABISELECT(144,88), "S603C41.s603c41f1");
  }
}
static Arrange_To_Call_Me vS603C41(Test_S603C41, "S603C41", ABISELECT(248,148));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S603C16  {
  ::S602C17 s603c16f0;
  ::S603C41 s603c16f1;
  void  mf603c16(); // _ZN7S603C168mf603c16Ev
};
//SIG(-1 S603C16) C1{ m FC2{ m FC3{ BC4{ vd v7 v8 v9 v10 v11 v12 FC5{ m Fp[4]}} BC6{} v1 v2 v3 v4 v5 v6 FC7{ BC8{ m Fp Fi Fp Fi[2]} FC9{ m FC10{ m FC11{ m FL[2]}} FC10 FC10 FC10}} FC12{ BC8 FC13{ m FC14{ m FL}}} FC12} FC15{ BC16{ BC17{ vd v13} vd v14 Fp[2] FC18{ m FC19{ m Fp Fi[2] FC20{ m}}} FC21{ m Fp[2]}} vd FC22{ m FC23{ Fs[2] Fc[2] Fs}[12] Fi FC24{ Fs[2]}[4] Fi FC25{ m Fp[2]}}}} FC26{ m FC27{ BC28{ vd v21 v22 v23 v24 v25 v26 FC5} BC6 v15 v16 v17 v18 v19 v20 FC29{ BC8 FC30{ m FC25 FC31{ m Fp}}} FC32{ BC8 FC33{ m FC11}}} FC34{ BC35{ BC17 vd v27 Fp[2] FC18 FC36{ m Fp[2]}} vd FC37{ m Fp Fi FC38{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC25}}}}


void  S603C16 ::mf603c16(){}

static void Test_S603C16()
{
  {
    init_simple_test("S603C16");
    static S603C16 lv;
    check2(sizeof(lv), ABISELECT(664,472), "sizeof(S603C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S603C16)");
    check_field_offset(lv, s603c16f0, 0, "S603C16.s603c16f0");
    check_field_offset(lv, s603c16f1, ABISELECT(416,324), "S603C16.s603c16f1");
  }
}
static Arrange_To_Call_Me vS603C16(Test_S603C16, "S603C16", ABISELECT(664,472));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S603C1  : S603C2 {
  ::S603C16 s603c1f0;
  virtual  ~S603C1(); // _ZN6S603C1D1Ev
  virtual void  v1(); // _ZN6S603C12v1Ev
  virtual void  v2(); // _ZN6S603C12v2Ev
  virtual void  v3(); // _ZN6S603C12v3Ev
  virtual void  v4(); // _ZN6S603C12v4Ev
  S603C1(); // tgen
};
//SIG(1 S603C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 FC6{ m FC7{ m FL[2]}} FC6 Fp Fi FU8{ m FC9{ Fi:4 Fi:4 Fi:4 Fi:2 Fi:1 Fi:17} Fi} Fi:2 Fi:2 Fc:1 Fc:1 FC10{ m Fp Fp} FC11{ Fp Fp}[2]} vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc Fi[2] Fi[2] Fp FC6 FC6 FC6 FC12{ m FC6 FC6} Fp Fi Fi FC13{ m Fp}[4] Fp} vd v35 v36 v37 v38 v39 FC13 FC13 FC13 FC13 FC6 FC6 FC6 FC6 FC14{ m FC15{ m FL FL}}} vd v40 v41 v42 v43} vd v1 v2 v3 v4 FC16{ m FC17{ m FC18{ BC19{ vd v50 v51 v52 v53 v54 v55 FC20{ m Fp Fp Fp Fp}} BC21{} v44 v45 v46 v47 v48 v49 FC22{ BC23{ m Fp Fi Fp Fi Fi} FC24{ m FC6 FC6 FC6 FC6}} FC25{ BC23 FC26{ m FC27{ m FL}}} FC25} FC28{ BC29{ BC30{ vd v56} vd v57 Fp Fp FC31{ m FC32{ m Fp Fi Fi FC33{ m}}} FC34{ m Fp Fp}} vd FC35{ m FC36{ Fs Fs Fc Fc Fs}[12] Fi FC37{ Fs Fs}[4] Fi FC38{ m Fp Fp}}}} FC39{ m FC40{ BC41{ vd v64 v65 v66 v67 v68 v69 FC20} BC21 v58 v59 v60 v61 v62 v63 FC42{ BC23 FC43{ m FC38 FC13}} FC44{ BC23 FC45{ m FC7}}} FC46{ BC47{ BC30 vd v70 Fp Fp FC31 FC10} vd FC48{ m Fp Fi FC49{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC38}}}}}


 S603C1 ::~S603C1(){ note_dtor("S603C1", this);}
void  S603C1 ::v1(){vfunc_called(this, "_ZN6S603C12v1Ev");}
void  S603C1 ::v2(){vfunc_called(this, "_ZN6S603C12v2Ev");}
void  S603C1 ::v3(){vfunc_called(this, "_ZN6S603C12v3Ev");}
void  S603C1 ::v4(){vfunc_called(this, "_ZN6S603C12v4Ev");}
S603C1 ::S603C1(){ note_ctor("S603C1", this);} // tgen

static void Test_S603C1()
{
  extern Class_Descriptor cd_S603C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(133,196)];
    init_test(&cd_S603C1, buf);
    S603C1 *dp, &lv = *(dp=new (buf) S603C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1056,780), "sizeof(S603C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S603C1)");
    check_base_class_offset(lv, (S603C5*)(S603C4*)(S603C3*)(S603C2*), 0, "S603C1");
    check_base_class_offset(lv, (S603C4*)(S603C3*)(S603C2*), 0, "S603C1");
    check_base_class_offset(lv, (S603C3*)(S603C2*), 0, "S603C1");
    check_base_class_offset(lv, (S603C2*), 0, "S603C1");
    check_field_offset(lv, s603c1f0, ABISELECT(392,308), "S603C1.s603c1f0");
    test_class_info(&lv, &cd_S603C1);
    dp->~S603C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS603C1(Test_S603C1, "S603C1", ABISELECT(1056,780));

#else // __cplusplus

extern void _ZN6S603C1C1Ev();
extern void _ZN6S603C1D1Ev();
Name_Map name_map_S603C1[] = {
  NSPAIR(_ZN6S603C1C1Ev),
  NSPAIR(_ZN6S603C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S603C5;
extern VTBL_ENTRY _ZTI6S603C5[];
extern  VTBL_ENTRY _ZTV6S603C5[];
extern Class_Descriptor cd_S603C4;
extern VTBL_ENTRY _ZTI6S603C4[];
extern  VTBL_ENTRY _ZTV6S603C4[];
extern Class_Descriptor cd_S603C3;
extern VTBL_ENTRY _ZTI6S603C3[];
extern  VTBL_ENTRY _ZTV6S603C3[];
extern Class_Descriptor cd_S603C2;
extern VTBL_ENTRY _ZTI6S603C2[];
extern  VTBL_ENTRY _ZTV6S603C2[];
static Base_Class bases_S603C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S603C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S603C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S603C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S603C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S603C1[];
extern void _ZN6S603C1D1Ev();
extern void _ZN6S603C1D0Ev();
extern void _ZN6S603C52v5Ev();
extern void _ZN6S603C52v6Ev();
extern void _ZN6S603C52v7Ev();
extern void _ZN6S603C52v8Ev();
extern void _ZN6S603C52v9Ev();
extern void _ZN6S603C53v10Ev();
extern void _ZN6S603C53v11Ev();
extern void _ZN6S603C53v12Ev();
extern void _ZN6S603C53v13Ev();
extern void _ZN6S603C53v14Ev();
extern void _ZN6S603C53v15Ev();
extern void _ZN6S603C53v16Ev();
extern void _ZN6S603C53v17Ev();
extern void _ZN6S603C53v18Ev();
extern void _ZN6S603C53v19Ev();
extern void _ZN6S603C43v20Ev();
extern void _ZN6S603C43v21Ev();
extern void _ZN6S603C43v22Ev();
extern void _ZN6S603C43v23Ev();
extern void _ZN6S603C43v24Ev();
extern void _ZN6S603C43v25Ev();
extern void _ZN6S603C43v26Ev();
extern void _ZN6S603C43v27Ev();
extern void _ZN6S603C43v28Ev();
extern void _ZN6S603C43v29Ev();
extern void _ZN6S603C43v30Ev();
extern void _ZN6S603C43v31Ev();
extern void _ZN6S603C43v32Ev();
extern void _ZN6S603C43v33Ev();
extern void _ZN6S603C43v34Ev();
extern void _ZN6S603C33v35Ev();
extern void _ZN6S603C33v36Ev();
extern void _ZN6S603C33v37Ev();
extern void _ZN6S603C33v38Ev();
extern void _ZN6S603C33v39Ev();
extern void _ZN6S603C23v40Ev();
extern void _ZN6S603C23v41Ev();
extern void _ZN6S603C23v42Ev();
extern void _ZN6S603C23v43Ev();
extern void _ZN6S603C12v1Ev();
extern void _ZN6S603C12v2Ev();
extern void _ZN6S603C12v3Ev();
extern void _ZN6S603C12v4Ev();
static  VTBL_ENTRY vtc_S603C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S603C1[0]),
  (VTBL_ENTRY)&_ZN6S603C1D1Ev,
  (VTBL_ENTRY)&_ZN6S603C1D0Ev,
  (VTBL_ENTRY)&_ZN6S603C52v5Ev,
  (VTBL_ENTRY)&_ZN6S603C52v6Ev,
  (VTBL_ENTRY)&_ZN6S603C52v7Ev,
  (VTBL_ENTRY)&_ZN6S603C52v8Ev,
  (VTBL_ENTRY)&_ZN6S603C52v9Ev,
  (VTBL_ENTRY)&_ZN6S603C53v10Ev,
  (VTBL_ENTRY)&_ZN6S603C53v11Ev,
  (VTBL_ENTRY)&_ZN6S603C53v12Ev,
  (VTBL_ENTRY)&_ZN6S603C53v13Ev,
  (VTBL_ENTRY)&_ZN6S603C53v14Ev,
  (VTBL_ENTRY)&_ZN6S603C53v15Ev,
  (VTBL_ENTRY)&_ZN6S603C53v16Ev,
  (VTBL_ENTRY)&_ZN6S603C53v17Ev,
  (VTBL_ENTRY)&_ZN6S603C53v18Ev,
  (VTBL_ENTRY)&_ZN6S603C53v19Ev,
  (VTBL_ENTRY)&_ZN6S603C43v20Ev,
  (VTBL_ENTRY)&_ZN6S603C43v21Ev,
  (VTBL_ENTRY)&_ZN6S603C43v22Ev,
  (VTBL_ENTRY)&_ZN6S603C43v23Ev,
  (VTBL_ENTRY)&_ZN6S603C43v24Ev,
  (VTBL_ENTRY)&_ZN6S603C43v25Ev,
  (VTBL_ENTRY)&_ZN6S603C43v26Ev,
  (VTBL_ENTRY)&_ZN6S603C43v27Ev,
  (VTBL_ENTRY)&_ZN6S603C43v28Ev,
  (VTBL_ENTRY)&_ZN6S603C43v29Ev,
  (VTBL_ENTRY)&_ZN6S603C43v30Ev,
  (VTBL_ENTRY)&_ZN6S603C43v31Ev,
  (VTBL_ENTRY)&_ZN6S603C43v32Ev,
  (VTBL_ENTRY)&_ZN6S603C43v33Ev,
  (VTBL_ENTRY)&_ZN6S603C43v34Ev,
  (VTBL_ENTRY)&_ZN6S603C33v35Ev,
  (VTBL_ENTRY)&_ZN6S603C33v36Ev,
  (VTBL_ENTRY)&_ZN6S603C33v37Ev,
  (VTBL_ENTRY)&_ZN6S603C33v38Ev,
  (VTBL_ENTRY)&_ZN6S603C33v39Ev,
  (VTBL_ENTRY)&_ZN6S603C23v40Ev,
  (VTBL_ENTRY)&_ZN6S603C23v41Ev,
  (VTBL_ENTRY)&_ZN6S603C23v42Ev,
  (VTBL_ENTRY)&_ZN6S603C23v43Ev,
  (VTBL_ENTRY)&_ZN6S603C12v1Ev,
  (VTBL_ENTRY)&_ZN6S603C12v2Ev,
  (VTBL_ENTRY)&_ZN6S603C12v3Ev,
  (VTBL_ENTRY)&_ZN6S603C12v4Ev,
};
extern VTBL_ENTRY _ZTI6S603C1[];
extern  VTBL_ENTRY _ZTV6S603C1[];
Class_Descriptor cd_S603C1 = {  "S603C1", // class name
  bases_S603C1, 4,
  &(vtc_S603C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1056,780), // object size
  NSPAIRA(_ZTI6S603C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S603C1),47, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S600C5  {
  ::S2120C13_nt s600c5f0;
  ::S2120C13_nt s600c5f1;
  void *s600c5f2;
  int s600c5f3;
  ::S601C8 s600c5f4;
  int s600c5f5:2;
  int s600c5f6:2;
  unsigned char s600c5f7:1;
  unsigned char s600c5f8:1;
  ::S601C53 s600c5f9;
  ::S601C11 s600c5f10[2];
  virtual  ~S600C5(); // _ZN6S600C5D1Ev
  virtual void  v5(); // _ZN6S600C52v5Ev
  virtual void  v6(); // _ZN6S600C52v6Ev
  virtual void  v7(); // _ZN6S600C52v7Ev
  virtual void  v8(); // _ZN6S600C52v8Ev
  virtual void  v9(); // _ZN6S600C52v9Ev
  virtual void  v10(); // _ZN6S600C53v10Ev
  virtual void  v11(); // _ZN6S600C53v11Ev
  virtual void  v12(); // _ZN6S600C53v12Ev
  virtual void  v13(); // _ZN6S600C53v13Ev
  virtual void  v14(); // _ZN6S600C53v14Ev
  virtual void  v15(); // _ZN6S600C53v15Ev
  virtual void  v16(); // _ZN6S600C53v16Ev
  virtual void  v17(); // _ZN6S600C53v17Ev
  virtual void  v18(); // _ZN6S600C53v18Ev
  virtual void  v19(); // _ZN6S600C53v19Ev
  S600C5(); // tgen
};
//SIG(-1 S600C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 FC2{ m FC3{ m FL[2]}} FC2 Fp Fi FU4{ m FC5{ Fi:4 Fi:4 Fi:4 Fi:2 Fi:1 Fi:17} Fi} Fi:2 Fi:2 Fc:1 Fc:1 FC6{ m Fp Fp} FC7{ Fp Fp}[2]}


 S600C5 ::~S600C5(){ note_dtor("S600C5", this);}
void  S600C5 ::v5(){vfunc_called(this, "_ZN6S600C52v5Ev");}
void  S600C5 ::v6(){vfunc_called(this, "_ZN6S600C52v6Ev");}
void  S600C5 ::v7(){vfunc_called(this, "_ZN6S600C52v7Ev");}
void  S600C5 ::v8(){vfunc_called(this, "_ZN6S600C52v8Ev");}
void  S600C5 ::v9(){vfunc_called(this, "_ZN6S600C52v9Ev");}
void  S600C5 ::v10(){vfunc_called(this, "_ZN6S600C53v10Ev");}
void  S600C5 ::v11(){vfunc_called(this, "_ZN6S600C53v11Ev");}
void  S600C5 ::v12(){vfunc_called(this, "_ZN6S600C53v12Ev");}
void  S600C5 ::v13(){vfunc_called(this, "_ZN6S600C53v13Ev");}
void  S600C5 ::v14(){vfunc_called(this, "_ZN6S600C53v14Ev");}
void  S600C5 ::v15(){vfunc_called(this, "_ZN6S600C53v15Ev");}
void  S600C5 ::v16(){vfunc_called(this, "_ZN6S600C53v16Ev");}
void  S600C5 ::v17(){vfunc_called(this, "_ZN6S600C53v17Ev");}
void  S600C5 ::v18(){vfunc_called(this, "_ZN6S600C53v18Ev");}
void  S600C5 ::v19(){vfunc_called(this, "_ZN6S600C53v19Ev");}
S600C5 ::S600C5(){ note_ctor("S600C5", this);} // tgen

static void Test_S600C5()
{
  extern Class_Descriptor cd_S600C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,20)];
    init_test(&cd_S600C5, buf);
    S600C5 *dp, &lv = *(dp=new (buf) S600C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,76), "sizeof(S600C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S600C5)");
    check_field_offset(lv, s600c5f0, ABISELECT(8,4), "S600C5.s600c5f0");
    check_field_offset(lv, s600c5f1, ABISELECT(24,20), "S600C5.s600c5f1");
    check_field_offset(lv, s600c5f2, ABISELECT(40,36), "S600C5.s600c5f2");
    check_field_offset(lv, s600c5f3, ABISELECT(48,40), "S600C5.s600c5f3");
    check_field_offset(lv, s600c5f4, ABISELECT(52,44), "S600C5.s600c5f4");
    set_bf_and_test(lv, s600c5f5, ABISELECT(56,48), 0, 2, 1, "S600C5");
    set_bf_and_test(lv, s600c5f5, ABISELECT(56,48), 0, 2, hide_sll(1LL<<1), "S600C5");
    set_bf_and_test(lv, s600c5f6, ABISELECT(56,48), 2, 2, 1, "S600C5");
    set_bf_and_test(lv, s600c5f6, ABISELECT(56,48), 2, 2, hide_sll(1LL<<1), "S600C5");
    set_bf_and_test(lv, s600c5f7, ABISELECT(56,48), 4, 1, 1, "S600C5");
    set_bf_and_test(lv, s600c5f8, ABISELECT(56,48), 5, 1, 1, "S600C5");
    check_field_offset(lv, s600c5f9, ABISELECT(64,52), "S600C5.s600c5f9");
    check_field_offset(lv, s600c5f10, ABISELECT(80,60), "S600C5.s600c5f10");
    test_class_info(&lv, &cd_S600C5);
    dp->~S600C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS600C5(Test_S600C5, "S600C5", ABISELECT(112,76));

#else // __cplusplus

extern void _ZN6S600C5C1Ev();
extern void _ZN6S600C5D1Ev();
Name_Map name_map_S600C5[] = {
  NSPAIR(_ZN6S600C5C1Ev),
  NSPAIR(_ZN6S600C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S600C5[];
extern void _ZN6S600C5D1Ev();
extern void _ZN6S600C5D0Ev();
extern void _ZN6S600C52v5Ev();
extern void _ZN6S600C52v6Ev();
extern void _ZN6S600C52v7Ev();
extern void _ZN6S600C52v8Ev();
extern void _ZN6S600C52v9Ev();
extern void _ZN6S600C53v10Ev();
extern void _ZN6S600C53v11Ev();
extern void _ZN6S600C53v12Ev();
extern void _ZN6S600C53v13Ev();
extern void _ZN6S600C53v14Ev();
extern void _ZN6S600C53v15Ev();
extern void _ZN6S600C53v16Ev();
extern void _ZN6S600C53v17Ev();
extern void _ZN6S600C53v18Ev();
extern void _ZN6S600C53v19Ev();
static  VTBL_ENTRY vtc_S600C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S600C5[0]),
  (VTBL_ENTRY)&_ZN6S600C5D1Ev,
  (VTBL_ENTRY)&_ZN6S600C5D0Ev,
  (VTBL_ENTRY)&_ZN6S600C52v5Ev,
  (VTBL_ENTRY)&_ZN6S600C52v6Ev,
  (VTBL_ENTRY)&_ZN6S600C52v7Ev,
  (VTBL_ENTRY)&_ZN6S600C52v8Ev,
  (VTBL_ENTRY)&_ZN6S600C52v9Ev,
  (VTBL_ENTRY)&_ZN6S600C53v10Ev,
  (VTBL_ENTRY)&_ZN6S600C53v11Ev,
  (VTBL_ENTRY)&_ZN6S600C53v12Ev,
  (VTBL_ENTRY)&_ZN6S600C53v13Ev,
  (VTBL_ENTRY)&_ZN6S600C53v14Ev,
  (VTBL_ENTRY)&_ZN6S600C53v15Ev,
  (VTBL_ENTRY)&_ZN6S600C53v16Ev,
  (VTBL_ENTRY)&_ZN6S600C53v17Ev,
  (VTBL_ENTRY)&_ZN6S600C53v18Ev,
  (VTBL_ENTRY)&_ZN6S600C53v19Ev,
};
extern VTBL_ENTRY _ZTI6S600C5[];
extern  VTBL_ENTRY _ZTV6S600C5[];
Class_Descriptor cd_S600C5 = {  "S600C5", // class name
  0,0,//no base classes
  &(vtc_S600C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,76), // object size
  NSPAIRA(_ZTI6S600C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S600C5),19, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S600C4  : S600C5 {
  unsigned char s600c4f0:1;
  unsigned char s600c4f1:1;
  unsigned char s600c4f2:1;
  unsigned char s600c4f3:1;
  unsigned char s600c4f4:1;
  unsigned char s600c4f5:1;
  unsigned char s600c4f6:1;
  char s600c4f7;
  int s600c4f8[2];
  int s600c4f9[2];
  void *s600c4f10;
  ::S2120C13_nt s600c4f11;
  ::S2120C13_nt s600c4f12;
  ::S2120C13_nt s600c4f13;
  ::S601C12 s600c4f14;
  void *s600c4f15;
  int s600c4f16;
  int s600c4f17;
  ::S601C13_nt s600c4f18[4];
  void *s600c4f19;
  virtual  ~S600C4(); // _ZN6S600C4D1Ev
  virtual void  v20(); // _ZN6S600C43v20Ev
  virtual void  v21(); // _ZN6S600C43v21Ev
  virtual void  v22(); // _ZN6S600C43v22Ev
  virtual void  v23(); // _ZN6S600C43v23Ev
  virtual void  v24(); // _ZN6S600C43v24Ev
  virtual void  v25(); // _ZN6S600C43v25Ev
  virtual void  v26(); // _ZN6S600C43v26Ev
  virtual void  v27(); // _ZN6S600C43v27Ev
  virtual void  v28(); // _ZN6S600C43v28Ev
  virtual void  v29(); // _ZN6S600C43v29Ev
  virtual void  v30(); // _ZN6S600C43v30Ev
  virtual void  v31(); // _ZN6S600C43v31Ev
  virtual void  v32(); // _ZN6S600C43v32Ev
  virtual void  v33(); // _ZN6S600C43v33Ev
  virtual void  v34(); // _ZN6S600C43v34Ev
  S600C4(); // tgen
};
//SIG(-1 S600C4) C1{ BC2{ vd v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 FC3{ m FC4{ m FL[2]}} FC3 Fp Fi FU5{ m FC6{ Fi:4 Fi:4 Fi:4 Fi:2 Fi:1 Fi:17} Fi} Fi:2 Fi:2 Fc:1 Fc:1 FC7{ m Fp Fp} FC8{ Fp Fp}[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc Fi[2] Fi[2] Fp FC3 FC3 FC3 FC9{ m FC3 FC3} Fp Fi Fi FC10{ m Fp}[4] Fp}


 S600C4 ::~S600C4(){ note_dtor("S600C4", this);}
void  S600C4 ::v20(){vfunc_called(this, "_ZN6S600C43v20Ev");}
void  S600C4 ::v21(){vfunc_called(this, "_ZN6S600C43v21Ev");}
void  S600C4 ::v22(){vfunc_called(this, "_ZN6S600C43v22Ev");}
void  S600C4 ::v23(){vfunc_called(this, "_ZN6S600C43v23Ev");}
void  S600C4 ::v24(){vfunc_called(this, "_ZN6S600C43v24Ev");}
void  S600C4 ::v25(){vfunc_called(this, "_ZN6S600C43v25Ev");}
void  S600C4 ::v26(){vfunc_called(this, "_ZN6S600C43v26Ev");}
void  S600C4 ::v27(){vfunc_called(this, "_ZN6S600C43v27Ev");}
void  S600C4 ::v28(){vfunc_called(this, "_ZN6S600C43v28Ev");}
void  S600C4 ::v29(){vfunc_called(this, "_ZN6S600C43v29Ev");}
void  S600C4 ::v30(){vfunc_called(this, "_ZN6S600C43v30Ev");}
void  S600C4 ::v31(){vfunc_called(this, "_ZN6S600C43v31Ev");}
void  S600C4 ::v32(){vfunc_called(this, "_ZN6S600C43v32Ev");}
void  S600C4 ::v33(){vfunc_called(this, "_ZN6S600C43v33Ev");}
void  S600C4 ::v34(){vfunc_called(this, "_ZN6S600C43v34Ev");}
S600C4 ::S600C4(){ note_ctor("S600C4", this);} // tgen

static void Test_S600C4()
{
  extern Class_Descriptor cd_S600C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(36,54)];
    init_test(&cd_S600C4, buf);
    S600C4 *dp, &lv = *(dp=new (buf) S600C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(280,212), "sizeof(S600C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S600C4)");
    check_base_class_offset(lv, (S600C5*), 0, "S600C4");
    set_bf_and_test(lv, s600c4f0, ABISELECT(112,76), 0, 1, 1, "S600C4");
    set_bf_and_test(lv, s600c4f1, ABISELECT(112,76), 1, 1, 1, "S600C4");
    set_bf_and_test(lv, s600c4f2, ABISELECT(112,76), 2, 1, 1, "S600C4");
    set_bf_and_test(lv, s600c4f3, ABISELECT(112,76), 3, 1, 1, "S600C4");
    set_bf_and_test(lv, s600c4f4, ABISELECT(112,76), 4, 1, 1, "S600C4");
    set_bf_and_test(lv, s600c4f5, ABISELECT(112,76), 5, 1, 1, "S600C4");
    set_bf_and_test(lv, s600c4f6, ABISELECT(112,76), 6, 1, 1, "S600C4");
    check_field_offset(lv, s600c4f7, ABISELECT(113,77), "S600C4.s600c4f7");
    check_field_offset(lv, s600c4f8, ABISELECT(116,80), "S600C4.s600c4f8");
    check_field_offset(lv, s600c4f9, ABISELECT(124,88), "S600C4.s600c4f9");
    check_field_offset(lv, s600c4f10, ABISELECT(136,96), "S600C4.s600c4f10");
    check_field_offset(lv, s600c4f11, ABISELECT(144,100), "S600C4.s600c4f11");
    check_field_offset(lv, s600c4f12, ABISELECT(160,116), "S600C4.s600c4f12");
    check_field_offset(lv, s600c4f13, ABISELECT(176,132), "S600C4.s600c4f13");
    check_field_offset(lv, s600c4f14, ABISELECT(192,148), "S600C4.s600c4f14");
    check_field_offset(lv, s600c4f15, ABISELECT(224,180), "S600C4.s600c4f15");
    check_field_offset(lv, s600c4f16, ABISELECT(232,184), "S600C4.s600c4f16");
    check_field_offset(lv, s600c4f17, ABISELECT(236,188), "S600C4.s600c4f17");
    check_field_offset(lv, s600c4f18, ABISELECT(240,192), "S600C4.s600c4f18");
    check_field_offset(lv, s600c4f19, ABISELECT(272,208), "S600C4.s600c4f19");
    test_class_info(&lv, &cd_S600C4);
    dp->~S600C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS600C4(Test_S600C4, "S600C4", ABISELECT(280,212));

#else // __cplusplus

extern void _ZN6S600C4C1Ev();
extern void _ZN6S600C4D1Ev();
Name_Map name_map_S600C4[] = {
  NSPAIR(_ZN6S600C4C1Ev),
  NSPAIR(_ZN6S600C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S600C5;
extern VTBL_ENTRY _ZTI6S600C5[];
extern  VTBL_ENTRY _ZTV6S600C5[];
static Base_Class bases_S600C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S600C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S600C4[];
extern void _ZN6S600C4D1Ev();
extern void _ZN6S600C4D0Ev();
extern void _ZN6S600C52v5Ev();
extern void _ZN6S600C52v6Ev();
extern void _ZN6S600C52v7Ev();
extern void _ZN6S600C52v8Ev();
extern void _ZN6S600C52v9Ev();
extern void _ZN6S600C53v10Ev();
extern void _ZN6S600C53v11Ev();
extern void _ZN6S600C53v12Ev();
extern void _ZN6S600C53v13Ev();
extern void _ZN6S600C53v14Ev();
extern void _ZN6S600C53v15Ev();
extern void _ZN6S600C53v16Ev();
extern void _ZN6S600C53v17Ev();
extern void _ZN6S600C53v18Ev();
extern void _ZN6S600C53v19Ev();
extern void _ZN6S600C43v20Ev();
extern void _ZN6S600C43v21Ev();
extern void _ZN6S600C43v22Ev();
extern void _ZN6S600C43v23Ev();
extern void _ZN6S600C43v24Ev();
extern void _ZN6S600C43v25Ev();
extern void _ZN6S600C43v26Ev();
extern void _ZN6S600C43v27Ev();
extern void _ZN6S600C43v28Ev();
extern void _ZN6S600C43v29Ev();
extern void _ZN6S600C43v30Ev();
extern void _ZN6S600C43v31Ev();
extern void _ZN6S600C43v32Ev();
extern void _ZN6S600C43v33Ev();
extern void _ZN6S600C43v34Ev();
static  VTBL_ENTRY vtc_S600C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S600C4[0]),
  (VTBL_ENTRY)&_ZN6S600C4D1Ev,
  (VTBL_ENTRY)&_ZN6S600C4D0Ev,
  (VTBL_ENTRY)&_ZN6S600C52v5Ev,
  (VTBL_ENTRY)&_ZN6S600C52v6Ev,
  (VTBL_ENTRY)&_ZN6S600C52v7Ev,
  (VTBL_ENTRY)&_ZN6S600C52v8Ev,
  (VTBL_ENTRY)&_ZN6S600C52v9Ev,
  (VTBL_ENTRY)&_ZN6S600C53v10Ev,
  (VTBL_ENTRY)&_ZN6S600C53v11Ev,
  (VTBL_ENTRY)&_ZN6S600C53v12Ev,
  (VTBL_ENTRY)&_ZN6S600C53v13Ev,
  (VTBL_ENTRY)&_ZN6S600C53v14Ev,
  (VTBL_ENTRY)&_ZN6S600C53v15Ev,
  (VTBL_ENTRY)&_ZN6S600C53v16Ev,
  (VTBL_ENTRY)&_ZN6S600C53v17Ev,
  (VTBL_ENTRY)&_ZN6S600C53v18Ev,
  (VTBL_ENTRY)&_ZN6S600C53v19Ev,
  (VTBL_ENTRY)&_ZN6S600C43v20Ev,
  (VTBL_ENTRY)&_ZN6S600C43v21Ev,
  (VTBL_ENTRY)&_ZN6S600C43v22Ev,
  (VTBL_ENTRY)&_ZN6S600C43v23Ev,
  (VTBL_ENTRY)&_ZN6S600C43v24Ev,
  (VTBL_ENTRY)&_ZN6S600C43v25Ev,
  (VTBL_ENTRY)&_ZN6S600C43v26Ev,
  (VTBL_ENTRY)&_ZN6S600C43v27Ev,
  (VTBL_ENTRY)&_ZN6S600C43v28Ev,
  (VTBL_ENTRY)&_ZN6S600C43v29Ev,
  (VTBL_ENTRY)&_ZN6S600C43v30Ev,
  (VTBL_ENTRY)&_ZN6S600C43v31Ev,
  (VTBL_ENTRY)&_ZN6S600C43v32Ev,
  (VTBL_ENTRY)&_ZN6S600C43v33Ev,
  (VTBL_ENTRY)&_ZN6S600C43v34Ev,
};
extern VTBL_ENTRY _ZTI6S600C4[];
extern  VTBL_ENTRY _ZTV6S600C4[];
Class_Descriptor cd_S600C4 = {  "S600C4", // class name
  bases_S600C4, 1,
  &(vtc_S600C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(280,212), // object size
  NSPAIRA(_ZTI6S600C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S600C4),34, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S600C3  : S600C4 {
  ::S601C13_nt s600c3f0;
  ::S601C13_nt s600c3f1;
  ::S601C13_nt s600c3f2;
  ::S601C13_nt s600c3f3;
  ::S2120C13_nt s600c3f4;
  ::S2120C13_nt s600c3f5;
  ::S2120C13_nt s600c3f6;
  ::S2120C13_nt s600c3f7;
  ::S601C14 s600c3f8;
  virtual  ~S600C3(); // _ZN6S600C3D1Ev
  virtual void  v35(); // _ZN6S600C33v35Ev
  virtual void  v36(); // _ZN6S600C33v36Ev
  virtual void  v37(); // _ZN6S600C33v37Ev
  virtual void  v38(); // _ZN6S600C33v38Ev
  virtual void  v39(); // _ZN6S600C33v39Ev
  S600C3(); // tgen
};
//SIG(-1 S600C3) C1{ BC2{ BC3{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 FC4{ m FC5{ m FL[2]}} FC4 Fp Fi FU6{ m FC7{ Fi:4 Fi:4 Fi:4 Fi:2 Fi:1 Fi:17} Fi} Fi:2 Fi:2 Fc:1 Fc:1 FC8{ m Fp Fp} FC9{ Fp Fp}[2]} vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc Fi[2] Fi[2] Fp FC4 FC4 FC4 FC10{ m FC4 FC4} Fp Fi Fi FC11{ m Fp}[4] Fp} vd v1 v2 v3 v4 v5 FC11 FC11 FC11 FC11 FC4 FC4 FC4 FC4 FC12{ m FC13{ m FL FL}}}


 S600C3 ::~S600C3(){ note_dtor("S600C3", this);}
void  S600C3 ::v35(){vfunc_called(this, "_ZN6S600C33v35Ev");}
void  S600C3 ::v36(){vfunc_called(this, "_ZN6S600C33v36Ev");}
void  S600C3 ::v37(){vfunc_called(this, "_ZN6S600C33v37Ev");}
void  S600C3 ::v38(){vfunc_called(this, "_ZN6S600C33v38Ev");}
void  S600C3 ::v39(){vfunc_called(this, "_ZN6S600C33v39Ev");}
S600C3 ::S600C3(){ note_ctor("S600C3", this);} // tgen

static void Test_S600C3()
{
  extern Class_Descriptor cd_S600C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(50,78)];
    init_test(&cd_S600C3, buf);
    S600C3 *dp, &lv = *(dp=new (buf) S600C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(392,308), "sizeof(S600C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S600C3)");
    check_base_class_offset(lv, (S600C5*)(S600C4*), 0, "S600C3");
    check_base_class_offset(lv, (S600C4*), 0, "S600C3");
    check_field_offset(lv, s600c3f0, ABISELECT(280,212), "S600C3.s600c3f0");
    check_field_offset(lv, s600c3f1, ABISELECT(288,216), "S600C3.s600c3f1");
    check_field_offset(lv, s600c3f2, ABISELECT(296,220), "S600C3.s600c3f2");
    check_field_offset(lv, s600c3f3, ABISELECT(304,224), "S600C3.s600c3f3");
    check_field_offset(lv, s600c3f4, ABISELECT(312,228), "S600C3.s600c3f4");
    check_field_offset(lv, s600c3f5, ABISELECT(328,244), "S600C3.s600c3f5");
    check_field_offset(lv, s600c3f6, ABISELECT(344,260), "S600C3.s600c3f6");
    check_field_offset(lv, s600c3f7, ABISELECT(360,276), "S600C3.s600c3f7");
    check_field_offset(lv, s600c3f8, ABISELECT(376,292), "S600C3.s600c3f8");
    test_class_info(&lv, &cd_S600C3);
    dp->~S600C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS600C3(Test_S600C3, "S600C3", ABISELECT(392,308));

#else // __cplusplus

extern void _ZN6S600C3C1Ev();
extern void _ZN6S600C3D1Ev();
Name_Map name_map_S600C3[] = {
  NSPAIR(_ZN6S600C3C1Ev),
  NSPAIR(_ZN6S600C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S600C5;
extern VTBL_ENTRY _ZTI6S600C5[];
extern  VTBL_ENTRY _ZTV6S600C5[];
extern Class_Descriptor cd_S600C4;
extern VTBL_ENTRY _ZTI6S600C4[];
extern  VTBL_ENTRY _ZTV6S600C4[];
static Base_Class bases_S600C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S600C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S600C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S600C3[];
extern void _ZN6S600C3D1Ev();
extern void _ZN6S600C3D0Ev();
extern void _ZN6S600C52v5Ev();
extern void _ZN6S600C52v6Ev();
extern void _ZN6S600C52v7Ev();
extern void _ZN6S600C52v8Ev();
extern void _ZN6S600C52v9Ev();
extern void _ZN6S600C53v10Ev();
extern void _ZN6S600C53v11Ev();
extern void _ZN6S600C53v12Ev();
extern void _ZN6S600C53v13Ev();
extern void _ZN6S600C53v14Ev();
extern void _ZN6S600C53v15Ev();
extern void _ZN6S600C53v16Ev();
extern void _ZN6S600C53v17Ev();
extern void _ZN6S600C53v18Ev();
extern void _ZN6S600C53v19Ev();
extern void _ZN6S600C43v20Ev();
extern void _ZN6S600C43v21Ev();
extern void _ZN6S600C43v22Ev();
extern void _ZN6S600C43v23Ev();
extern void _ZN6S600C43v24Ev();
extern void _ZN6S600C43v25Ev();
extern void _ZN6S600C43v26Ev();
extern void _ZN6S600C43v27Ev();
extern void _ZN6S600C43v28Ev();
extern void _ZN6S600C43v29Ev();
extern void _ZN6S600C43v30Ev();
extern void _ZN6S600C43v31Ev();
extern void _ZN6S600C43v32Ev();
extern void _ZN6S600C43v33Ev();
extern void _ZN6S600C43v34Ev();
extern void _ZN6S600C33v35Ev();
extern void _ZN6S600C33v36Ev();
extern void _ZN6S600C33v37Ev();
extern void _ZN6S600C33v38Ev();
extern void _ZN6S600C33v39Ev();
static  VTBL_ENTRY vtc_S600C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S600C3[0]),
  (VTBL_ENTRY)&_ZN6S600C3D1Ev,
  (VTBL_ENTRY)&_ZN6S600C3D0Ev,
  (VTBL_ENTRY)&_ZN6S600C52v5Ev,
  (VTBL_ENTRY)&_ZN6S600C52v6Ev,
  (VTBL_ENTRY)&_ZN6S600C52v7Ev,
  (VTBL_ENTRY)&_ZN6S600C52v8Ev,
  (VTBL_ENTRY)&_ZN6S600C52v9Ev,
  (VTBL_ENTRY)&_ZN6S600C53v10Ev,
  (VTBL_ENTRY)&_ZN6S600C53v11Ev,
  (VTBL_ENTRY)&_ZN6S600C53v12Ev,
  (VTBL_ENTRY)&_ZN6S600C53v13Ev,
  (VTBL_ENTRY)&_ZN6S600C53v14Ev,
  (VTBL_ENTRY)&_ZN6S600C53v15Ev,
  (VTBL_ENTRY)&_ZN6S600C53v16Ev,
  (VTBL_ENTRY)&_ZN6S600C53v17Ev,
  (VTBL_ENTRY)&_ZN6S600C53v18Ev,
  (VTBL_ENTRY)&_ZN6S600C53v19Ev,
  (VTBL_ENTRY)&_ZN6S600C43v20Ev,
  (VTBL_ENTRY)&_ZN6S600C43v21Ev,
  (VTBL_ENTRY)&_ZN6S600C43v22Ev,
  (VTBL_ENTRY)&_ZN6S600C43v23Ev,
  (VTBL_ENTRY)&_ZN6S600C43v24Ev,
  (VTBL_ENTRY)&_ZN6S600C43v25Ev,
  (VTBL_ENTRY)&_ZN6S600C43v26Ev,
  (VTBL_ENTRY)&_ZN6S600C43v27Ev,
  (VTBL_ENTRY)&_ZN6S600C43v28Ev,
  (VTBL_ENTRY)&_ZN6S600C43v29Ev,
  (VTBL_ENTRY)&_ZN6S600C43v30Ev,
  (VTBL_ENTRY)&_ZN6S600C43v31Ev,
  (VTBL_ENTRY)&_ZN6S600C43v32Ev,
  (VTBL_ENTRY)&_ZN6S600C43v33Ev,
  (VTBL_ENTRY)&_ZN6S600C43v34Ev,
  (VTBL_ENTRY)&_ZN6S600C33v35Ev,
  (VTBL_ENTRY)&_ZN6S600C33v36Ev,
  (VTBL_ENTRY)&_ZN6S600C33v37Ev,
  (VTBL_ENTRY)&_ZN6S600C33v38Ev,
  (VTBL_ENTRY)&_ZN6S600C33v39Ev,
};
extern VTBL_ENTRY _ZTI6S600C3[];
extern  VTBL_ENTRY _ZTV6S600C3[];
Class_Descriptor cd_S600C3 = {  "S600C3", // class name
  bases_S600C3, 2,
  &(vtc_S600C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(392,308), // object size
  NSPAIRA(_ZTI6S600C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S600C3),39, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S600C2  : S600C3 {
  virtual  ~S600C2(); // _ZN6S600C2D1Ev
  virtual void  v40(); // _ZN6S600C23v40Ev
  virtual void  v41(); // _ZN6S600C23v41Ev
  virtual void  v42(); // _ZN6S600C23v42Ev
  virtual void  v43(); // _ZN6S600C23v43Ev
  S600C2(); // tgen
};
//SIG(-1 S600C2) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 FC5{ m FC6{ m FL[2]}} FC5 Fp Fi FU7{ m FC8{ Fi:4 Fi:4 Fi:4 Fi:2 Fi:1 Fi:17} Fi} Fi:2 Fi:2 Fc:1 Fc:1 FC9{ m Fp Fp} FC10{ Fp Fp}[2]} vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc Fi[2] Fi[2] Fp FC5 FC5 FC5 FC11{ m FC5 FC5} Fp Fi Fi FC12{ m Fp}[4] Fp} vd v35 v36 v37 v38 v39 FC12 FC12 FC12 FC12 FC5 FC5 FC5 FC5 FC13{ m FC14{ m FL FL}}} vd v1 v2 v3 v4}


 S600C2 ::~S600C2(){ note_dtor("S600C2", this);}
void  S600C2 ::v40(){vfunc_called(this, "_ZN6S600C23v40Ev");}
void  S600C2 ::v41(){vfunc_called(this, "_ZN6S600C23v41Ev");}
void  S600C2 ::v42(){vfunc_called(this, "_ZN6S600C23v42Ev");}
void  S600C2 ::v43(){vfunc_called(this, "_ZN6S600C23v43Ev");}
S600C2 ::S600C2(){ note_ctor("S600C2", this);} // tgen

static void Test_S600C2()
{
  extern Class_Descriptor cd_S600C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(50,78)];
    init_test(&cd_S600C2, buf);
    S600C2 *dp, &lv = *(dp=new (buf) S600C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(392,308), "sizeof(S600C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S600C2)");
    check_base_class_offset(lv, (S600C5*)(S600C4*)(S600C3*), 0, "S600C2");
    check_base_class_offset(lv, (S600C4*)(S600C3*), 0, "S600C2");
    check_base_class_offset(lv, (S600C3*), 0, "S600C2");
    test_class_info(&lv, &cd_S600C2);
    dp->~S600C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS600C2(Test_S600C2, "S600C2", ABISELECT(392,308));

#else // __cplusplus

extern void _ZN6S600C2C1Ev();
extern void _ZN6S600C2D1Ev();
Name_Map name_map_S600C2[] = {
  NSPAIR(_ZN6S600C2C1Ev),
  NSPAIR(_ZN6S600C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S600C5;
extern VTBL_ENTRY _ZTI6S600C5[];
extern  VTBL_ENTRY _ZTV6S600C5[];
extern Class_Descriptor cd_S600C4;
extern VTBL_ENTRY _ZTI6S600C4[];
extern  VTBL_ENTRY _ZTV6S600C4[];
extern Class_Descriptor cd_S600C3;
extern VTBL_ENTRY _ZTI6S600C3[];
extern  VTBL_ENTRY _ZTV6S600C3[];
static Base_Class bases_S600C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S600C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S600C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S600C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S600C2[];
extern void _ZN6S600C2D1Ev();
extern void _ZN6S600C2D0Ev();
extern void _ZN6S600C52v5Ev();
extern void _ZN6S600C52v6Ev();
extern void _ZN6S600C52v7Ev();
extern void _ZN6S600C52v8Ev();
extern void _ZN6S600C52v9Ev();
extern void _ZN6S600C53v10Ev();
extern void _ZN6S600C53v11Ev();
extern void _ZN6S600C53v12Ev();
extern void _ZN6S600C53v13Ev();
extern void _ZN6S600C53v14Ev();
extern void _ZN6S600C53v15Ev();
extern void _ZN6S600C53v16Ev();
extern void _ZN6S600C53v17Ev();
extern void _ZN6S600C53v18Ev();
extern void _ZN6S600C53v19Ev();
extern void _ZN6S600C43v20Ev();
extern void _ZN6S600C43v21Ev();
extern void _ZN6S600C43v22Ev();
extern void _ZN6S600C43v23Ev();
extern void _ZN6S600C43v24Ev();
extern void _ZN6S600C43v25Ev();
extern void _ZN6S600C43v26Ev();
extern void _ZN6S600C43v27Ev();
extern void _ZN6S600C43v28Ev();
extern void _ZN6S600C43v29Ev();
extern void _ZN6S600C43v30Ev();
extern void _ZN6S600C43v31Ev();
extern void _ZN6S600C43v32Ev();
extern void _ZN6S600C43v33Ev();
extern void _ZN6S600C43v34Ev();
extern void _ZN6S600C33v35Ev();
extern void _ZN6S600C33v36Ev();
extern void _ZN6S600C33v37Ev();
extern void _ZN6S600C33v38Ev();
extern void _ZN6S600C33v39Ev();
extern void _ZN6S600C23v40Ev();
extern void _ZN6S600C23v41Ev();
extern void _ZN6S600C23v42Ev();
extern void _ZN6S600C23v43Ev();
static  VTBL_ENTRY vtc_S600C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S600C2[0]),
  (VTBL_ENTRY)&_ZN6S600C2D1Ev,
  (VTBL_ENTRY)&_ZN6S600C2D0Ev,
  (VTBL_ENTRY)&_ZN6S600C52v5Ev,
  (VTBL_ENTRY)&_ZN6S600C52v6Ev,
  (VTBL_ENTRY)&_ZN6S600C52v7Ev,
  (VTBL_ENTRY)&_ZN6S600C52v8Ev,
  (VTBL_ENTRY)&_ZN6S600C52v9Ev,
  (VTBL_ENTRY)&_ZN6S600C53v10Ev,
  (VTBL_ENTRY)&_ZN6S600C53v11Ev,
  (VTBL_ENTRY)&_ZN6S600C53v12Ev,
  (VTBL_ENTRY)&_ZN6S600C53v13Ev,
  (VTBL_ENTRY)&_ZN6S600C53v14Ev,
  (VTBL_ENTRY)&_ZN6S600C53v15Ev,
  (VTBL_ENTRY)&_ZN6S600C53v16Ev,
  (VTBL_ENTRY)&_ZN6S600C53v17Ev,
  (VTBL_ENTRY)&_ZN6S600C53v18Ev,
  (VTBL_ENTRY)&_ZN6S600C53v19Ev,
  (VTBL_ENTRY)&_ZN6S600C43v20Ev,
  (VTBL_ENTRY)&_ZN6S600C43v21Ev,
  (VTBL_ENTRY)&_ZN6S600C43v22Ev,
  (VTBL_ENTRY)&_ZN6S600C43v23Ev,
  (VTBL_ENTRY)&_ZN6S600C43v24Ev,
  (VTBL_ENTRY)&_ZN6S600C43v25Ev,
  (VTBL_ENTRY)&_ZN6S600C43v26Ev,
  (VTBL_ENTRY)&_ZN6S600C43v27Ev,
  (VTBL_ENTRY)&_ZN6S600C43v28Ev,
  (VTBL_ENTRY)&_ZN6S600C43v29Ev,
  (VTBL_ENTRY)&_ZN6S600C43v30Ev,
  (VTBL_ENTRY)&_ZN6S600C43v31Ev,
  (VTBL_ENTRY)&_ZN6S600C43v32Ev,
  (VTBL_ENTRY)&_ZN6S600C43v33Ev,
  (VTBL_ENTRY)&_ZN6S600C43v34Ev,
  (VTBL_ENTRY)&_ZN6S600C33v35Ev,
  (VTBL_ENTRY)&_ZN6S600C33v36Ev,
  (VTBL_ENTRY)&_ZN6S600C33v37Ev,
  (VTBL_ENTRY)&_ZN6S600C33v38Ev,
  (VTBL_ENTRY)&_ZN6S600C33v39Ev,
  (VTBL_ENTRY)&_ZN6S600C23v40Ev,
  (VTBL_ENTRY)&_ZN6S600C23v41Ev,
  (VTBL_ENTRY)&_ZN6S600C23v42Ev,
  (VTBL_ENTRY)&_ZN6S600C23v43Ev,
};
extern VTBL_ENTRY _ZTI6S600C2[];
extern  VTBL_ENTRY _ZTV6S600C2[];
Class_Descriptor cd_S600C2 = {  "S600C2", // class name
  bases_S600C2, 3,
  &(vtc_S600C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(392,308), // object size
  NSPAIRA(_ZTI6S600C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S600C2),43, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S600C19  {
  ::S601C20 s600c19f0;
  virtual  ~S600C19(); // _ZN7S600C19D1Ev
  virtual void  v50(); // _ZN7S600C193v50Ev
  virtual void  v51(); // _ZN7S600C193v51Ev
  virtual void  v52(); // _ZN7S600C193v52Ev
  virtual void  v53(); // _ZN7S600C193v53Ev
  virtual void  v54(); // _ZN7S600C193v54Ev
  virtual void  v55(); // _ZN7S600C193v55Ev
  S600C19(); // tgen
};
//SIG(-1 S600C19) C1{ vd v1 v2 v3 v4 v5 v6 FC2{ m Fp[4]}}


 S600C19 ::~S600C19(){ note_dtor("S600C19", this);}
void  S600C19 ::v50(){vfunc_called(this, "_ZN7S600C193v50Ev");}
void  S600C19 ::v51(){vfunc_called(this, "_ZN7S600C193v51Ev");}
void  S600C19 ::v52(){vfunc_called(this, "_ZN7S600C193v52Ev");}
void  S600C19 ::v53(){vfunc_called(this, "_ZN7S600C193v53Ev");}
void  S600C19 ::v54(){vfunc_called(this, "_ZN7S600C193v54Ev");}
void  S600C19 ::v55(){vfunc_called(this, "_ZN7S600C193v55Ev");}
S600C19 ::S600C19(){ note_ctor("S600C19", this);} // tgen

static void Test_S600C19()
{
  extern Class_Descriptor cd_S600C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[6];
    init_test(&cd_S600C19, buf);
    S600C19 *dp, &lv = *(dp=new (buf) S600C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,20), "sizeof(S600C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S600C19)");
    check_field_offset(lv, s600c19f0, ABISELECT(8,4), "S600C19.s600c19f0");
    test_class_info(&lv, &cd_S600C19);
    dp->~S600C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS600C19(Test_S600C19, "S600C19", ABISELECT(40,20));

#else // __cplusplus

extern void _ZN7S600C19C1Ev();
extern void _ZN7S600C19D1Ev();
Name_Map name_map_S600C19[] = {
  NSPAIR(_ZN7S600C19C1Ev),
  NSPAIR(_ZN7S600C19D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S600C19[];
extern void _ZN7S600C19D1Ev();
extern void _ZN7S600C19D0Ev();
extern void _ZN7S600C193v50Ev();
extern void _ZN7S600C193v51Ev();
extern void _ZN7S600C193v52Ev();
extern void _ZN7S600C193v53Ev();
extern void _ZN7S600C193v54Ev();
extern void _ZN7S600C193v55Ev();
static  VTBL_ENTRY vtc_S600C19[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S600C19[0]),
  (VTBL_ENTRY)&_ZN7S600C19D1Ev,
  (VTBL_ENTRY)&_ZN7S600C19D0Ev,
  (VTBL_ENTRY)&_ZN7S600C193v50Ev,
  (VTBL_ENTRY)&_ZN7S600C193v51Ev,
  (VTBL_ENTRY)&_ZN7S600C193v52Ev,
  (VTBL_ENTRY)&_ZN7S600C193v53Ev,
  (VTBL_ENTRY)&_ZN7S600C193v54Ev,
  (VTBL_ENTRY)&_ZN7S600C193v55Ev,
};
extern VTBL_ENTRY _ZTI7S600C19[];
extern  VTBL_ENTRY _ZTV7S600C19[];
Class_Descriptor cd_S600C19 = {  "S600C19", // class name
  0,0,//no base classes
  &(vtc_S600C19[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,20), // object size
  NSPAIRA(_ZTI7S600C19),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S600C19),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S600C18  : S600C19 , S601C21_nt {
  ::S601C22 s600c18f0;
  ::S601C27 s600c18f1;
  ::S601C27 s600c18f2;
  virtual void  v44(); // _ZN7S600C183v44Ev
  virtual void  v45(); // _ZN7S600C183v45Ev
  virtual void  v46(); // _ZN7S600C183v46Ev
  virtual void  v47(); // _ZN7S600C183v47Ev
  virtual void  v48(); // _ZN7S600C183v48Ev
  virtual void  v49(); // _ZN7S600C183v49Ev
  ~S600C18(); // tgen
  S600C18(); // tgen
};
//SIG(-1 S600C18) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8}} FC10{ BC6 FC11{ m FC9}} FC10}


void  S600C18 ::v44(){vfunc_called(this, "_ZN7S600C183v44Ev");}
void  S600C18 ::v45(){vfunc_called(this, "_ZN7S600C183v45Ev");}
void  S600C18 ::v46(){vfunc_called(this, "_ZN7S600C183v46Ev");}
void  S600C18 ::v47(){vfunc_called(this, "_ZN7S600C183v47Ev");}
void  S600C18 ::v48(){vfunc_called(this, "_ZN7S600C183v48Ev");}
void  S600C18 ::v49(){vfunc_called(this, "_ZN7S600C183v49Ev");}
S600C18 ::~S600C18(){ note_dtor("S600C18", this);} // tgen
S600C18 ::S600C18(){ note_ctor("S600C18", this);} // tgen

static void Test_S600C18()
{
  extern Class_Descriptor cd_S600C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(30,45)];
    init_test(&cd_S600C18, buf);
    S600C18 *dp, &lv = *(dp=new (buf) S600C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(232,176), "sizeof(S600C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S600C18)");
    check_base_class_offset(lv, (S600C19*), 0, "S600C18");
    check_base_class_offset(lv, (S601C21_nt*), 0, "S600C18");
    check_field_offset(lv, s600c18f0, ABISELECT(40,20), "S600C18.s600c18f0");
    check_field_offset(lv, s600c18f1, ABISELECT(136,104), "S600C18.s600c18f1");
    check_field_offset(lv, s600c18f2, ABISELECT(184,140), "S600C18.s600c18f2");
    test_class_info(&lv, &cd_S600C18);
    dp->~S600C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS600C18(Test_S600C18, "S600C18", ABISELECT(232,176));

#else // __cplusplus

extern void _ZN7S600C18C1Ev();
extern void _ZN7S600C18D1Ev();
Name_Map name_map_S600C18[] = {
  NSPAIR(_ZN7S600C18C1Ev),
  NSPAIR(_ZN7S600C18D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S600C19;
extern VTBL_ENTRY _ZTI7S600C19[];
extern  VTBL_ENTRY _ZTV7S600C19[];
extern Class_Descriptor cd_S601C21_nt;
extern VTBL_ENTRY _ZTI10S601C21_nt[];
static Base_Class bases_S600C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S600C19,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S601C21_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S600C18[];
extern void _ZN7S600C18D1Ev();
extern void _ZN7S600C18D0Ev();
extern void _ZN7S600C193v50Ev();
extern void _ZN7S600C193v51Ev();
extern void _ZN7S600C193v52Ev();
extern void _ZN7S600C193v53Ev();
extern void _ZN7S600C193v54Ev();
extern void _ZN7S600C193v55Ev();
extern void _ZN7S600C183v44Ev();
extern void _ZN7S600C183v45Ev();
extern void _ZN7S600C183v46Ev();
extern void _ZN7S600C183v47Ev();
extern void _ZN7S600C183v48Ev();
extern void _ZN7S600C183v49Ev();
static  VTBL_ENTRY vtc_S600C18[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S600C18[0]),
  (VTBL_ENTRY)&_ZN7S600C18D1Ev,
  (VTBL_ENTRY)&_ZN7S600C18D0Ev,
  (VTBL_ENTRY)&_ZN7S600C193v50Ev,
  (VTBL_ENTRY)&_ZN7S600C193v51Ev,
  (VTBL_ENTRY)&_ZN7S600C193v52Ev,
  (VTBL_ENTRY)&_ZN7S600C193v53Ev,
  (VTBL_ENTRY)&_ZN7S600C193v54Ev,
  (VTBL_ENTRY)&_ZN7S600C193v55Ev,
  (VTBL_ENTRY)&_ZN7S600C183v44Ev,
  (VTBL_ENTRY)&_ZN7S600C183v45Ev,
  (VTBL_ENTRY)&_ZN7S600C183v46Ev,
  (VTBL_ENTRY)&_ZN7S600C183v47Ev,
  (VTBL_ENTRY)&_ZN7S600C183v48Ev,
  (VTBL_ENTRY)&_ZN7S600C183v49Ev,
};
extern VTBL_ENTRY _ZTI7S600C18[];
extern  VTBL_ENTRY _ZTV7S600C18[];
Class_Descriptor cd_S600C18 = {  "S600C18", // class name
  bases_S600C18, 2,
  &(vtc_S600C18[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(232,176), // object size
  NSPAIRA(_ZTI7S600C18),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S600C18),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S600C17  {
  ::S600C18 s600c17f0;
  ::S601C32 s600c17f1;
  void  mf600c17(); // _ZN7S600C178mf600c17Ev
};
//SIG(-1 S600C17) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m FC10{ m FL[2]}} FC9 FC9 FC9}} FC11{ BC7 FC12{ m FC10}} FC11} FC13{ BC14{ BC15{ vd v13} vd v14 Fp[2] FC16{ m FC17{ m Fp Fi[2] FC18{ m}}} FC19{ m Fp[2]}} vd FC20{ m FC21{ Fs[2] Fc[2] Fs}[12] Fi FC22{ Fs[2]}[4] Fi FC23{ m Fp[2]}}}}


void  S600C17 ::mf600c17(){}

static void Test_S600C17()
{
  {
    init_simple_test("S600C17");
    S600C17 lv;
    check2(sizeof(lv), ABISELECT(432,340), "sizeof(S600C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S600C17)");
    check_field_offset(lv, s600c17f0, 0, "S600C17.s600c17f0");
    check_field_offset(lv, s600c17f1, ABISELECT(232,176), "S600C17.s600c17f1");
  }
}
static Arrange_To_Call_Me vS600C17(Test_S600C17, "S600C17", ABISELECT(432,340));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S600C40  : S600C19 , S601C21_nt {
  ::S601C45 s600c40f0;
  ::S601C45 s600c40f1;
  ::S601C27 s600c40f2;
  ::S601C27 s600c40f3;
  virtual void  v58(); // _ZN7S600C403v58Ev
  virtual void  v59(); // _ZN7S600C403v59Ev
  virtual void  v60(); // _ZN7S600C403v60Ev
  virtual void  v61(); // _ZN7S600C403v61Ev
  virtual void  v62(); // _ZN7S600C403v62Ev
  virtual void  v63(); // _ZN7S600C403v63Ev
  ~S600C40(); // tgen
  S600C40(); // tgen
};
//SIG(-1 S600C40) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m Fp[2]} FC9{ m Fp}}} FC5 FC10{ BC6 FC11{ m FC12{ m FL[2]}}} FC10}


void  S600C40 ::v58(){vfunc_called(this, "_ZN7S600C403v58Ev");}
void  S600C40 ::v59(){vfunc_called(this, "_ZN7S600C403v59Ev");}
void  S600C40 ::v60(){vfunc_called(this, "_ZN7S600C403v60Ev");}
void  S600C40 ::v61(){vfunc_called(this, "_ZN7S600C403v61Ev");}
void  S600C40 ::v62(){vfunc_called(this, "_ZN7S600C403v62Ev");}
void  S600C40 ::v63(){vfunc_called(this, "_ZN7S600C403v63Ev");}
S600C40 ::~S600C40(){ note_dtor("S600C40", this);} // tgen
S600C40 ::S600C40(){ note_ctor("S600C40", this);} // tgen

static void Test_S600C40()
{
  extern Class_Descriptor cd_S600C40;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(32,40)];
    init_test(&cd_S600C40, buf);
    S600C40 *dp, &lv = *(dp=new (buf) S600C40());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(248,156), "sizeof(S600C40)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S600C40)");
    check_base_class_offset(lv, (S600C19*), 0, "S600C40");
    check_base_class_offset(lv, (S601C21_nt*), 0, "S600C40");
    check_field_offset(lv, s600c40f0, ABISELECT(40,20), "S600C40.s600c40f0");
    check_field_offset(lv, s600c40f1, ABISELECT(96,52), "S600C40.s600c40f1");
    check_field_offset(lv, s600c40f2, ABISELECT(152,84), "S600C40.s600c40f2");
    check_field_offset(lv, s600c40f3, ABISELECT(200,120), "S600C40.s600c40f3");
    test_class_info(&lv, &cd_S600C40);
    dp->~S600C40();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS600C40(Test_S600C40, "S600C40", ABISELECT(248,156));

#else // __cplusplus

extern void _ZN7S600C40C1Ev();
extern void _ZN7S600C40D1Ev();
Name_Map name_map_S600C40[] = {
  NSPAIR(_ZN7S600C40C1Ev),
  NSPAIR(_ZN7S600C40D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S600C19;
extern VTBL_ENTRY _ZTI7S600C19[];
extern  VTBL_ENTRY _ZTV7S600C19[];
extern Class_Descriptor cd_S601C21_nt;
extern VTBL_ENTRY _ZTI10S601C21_nt[];
static Base_Class bases_S600C40[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S600C19,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S601C21_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S600C40[];
extern void _ZN7S600C40D1Ev();
extern void _ZN7S600C40D0Ev();
extern void _ZN7S600C193v50Ev();
extern void _ZN7S600C193v51Ev();
extern void _ZN7S600C193v52Ev();
extern void _ZN7S600C193v53Ev();
extern void _ZN7S600C193v54Ev();
extern void _ZN7S600C193v55Ev();
extern void _ZN7S600C403v58Ev();
extern void _ZN7S600C403v59Ev();
extern void _ZN7S600C403v60Ev();
extern void _ZN7S600C403v61Ev();
extern void _ZN7S600C403v62Ev();
extern void _ZN7S600C403v63Ev();
static  VTBL_ENTRY vtc_S600C40[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S600C40[0]),
  (VTBL_ENTRY)&_ZN7S600C40D1Ev,
  (VTBL_ENTRY)&_ZN7S600C40D0Ev,
  (VTBL_ENTRY)&_ZN7S600C193v50Ev,
  (VTBL_ENTRY)&_ZN7S600C193v51Ev,
  (VTBL_ENTRY)&_ZN7S600C193v52Ev,
  (VTBL_ENTRY)&_ZN7S600C193v53Ev,
  (VTBL_ENTRY)&_ZN7S600C193v54Ev,
  (VTBL_ENTRY)&_ZN7S600C193v55Ev,
  (VTBL_ENTRY)&_ZN7S600C403v58Ev,
  (VTBL_ENTRY)&_ZN7S600C403v59Ev,
  (VTBL_ENTRY)&_ZN7S600C403v60Ev,
  (VTBL_ENTRY)&_ZN7S600C403v61Ev,
  (VTBL_ENTRY)&_ZN7S600C403v62Ev,
  (VTBL_ENTRY)&_ZN7S600C403v63Ev,
};
extern VTBL_ENTRY _ZTI7S600C40[];
extern  VTBL_ENTRY _ZTV7S600C40[];
Class_Descriptor cd_S600C40 = {  "S600C40", // class name
  bases_S600C40, 2,
  &(vtc_S600C40[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(248,156), // object size
  NSPAIRA(_ZTI7S600C40),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S600C40),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S600C39  {
  ::S600C40 s600c39f0;
  ::S601C48 s600c39f1;
  void  mf600c39(); // _ZN7S600C398mf600c39Ev
};
//SIG(-1 S600C39) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}} FC6 FC11{ BC7 FC12{ m FC13{ m FL[2]}}} FC11} FC14{ BC15{ BC16{ vd v13} vd v14 Fp[2] FC17{ m FC18{ m Fp Fi[2] FC19{ m}}} FC20{ m Fp[2]}} vd FC21{ m Fp Fi FC22{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC9}}}


void  S600C39 ::mf600c39(){}

static void Test_S600C39()
{
  {
    init_simple_test("S600C39");
    static S600C39 lv;
    check2(sizeof(lv), ABISELECT(352,216), "sizeof(S600C39)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S600C39)");
    check_field_offset(lv, s600c39f0, 0, "S600C39.s600c39f0");
    check_field_offset(lv, s600c39f1, ABISELECT(248,156), "S600C39.s600c39f1");
  }
}
static Arrange_To_Call_Me vS600C39(Test_S600C39, "S600C39", ABISELECT(352,216));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S600C16  {
  ::S600C17 s600c16f0;
  ::S600C39 s600c16f1;
  void  mf600c16(); // _ZN7S600C168mf600c16Ev
};
//SIG(-1 S600C16) C1{ m FC2{ m FC3{ BC4{ vd v7 v8 v9 v10 v11 v12 FC5{ m Fp[4]}} BC6{} v1 v2 v3 v4 v5 v6 FC7{ BC8{ m Fp Fi Fp Fi[2]} FC9{ m FC10{ m FC11{ m FL[2]}} FC10 FC10 FC10}} FC12{ BC8 FC13{ m FC11}} FC12} FC14{ BC15{ BC16{ vd v13} vd v14 Fp[2] FC17{ m FC18{ m Fp Fi[2] FC19{ m}}} FC20{ m Fp[2]}} vd FC21{ m FC22{ Fs[2] Fc[2] Fs}[12] Fi FC23{ Fs[2]}[4] Fi FC24{ m Fp[2]}}}} FC25{ m FC26{ BC4 BC6 v15 v16 v17 v18 v19 v20 FC27{ BC8 FC28{ m FC24 FC29{ m Fp}}} FC27 FC12 FC12} FC30{ BC31{ BC16 vd v21 Fp[2] FC17 FC32{ m Fp[2]}} vd FC33{ m Fp Fi FC34{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC24}}}}


void  S600C16 ::mf600c16(){}

static void Test_S600C16()
{
  {
    init_simple_test("S600C16");
    static S600C16 lv;
    check2(sizeof(lv), ABISELECT(784,556), "sizeof(S600C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S600C16)");
    check_field_offset(lv, s600c16f0, 0, "S600C16.s600c16f0");
    check_field_offset(lv, s600c16f1, ABISELECT(432,340), "S600C16.s600c16f1");
  }
}
static Arrange_To_Call_Me vS600C16(Test_S600C16, "S600C16", ABISELECT(784,556));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S600C1  : S600C2 {
  ::S600C16 s600c1f0;
  virtual  ~S600C1(); // _ZN6S600C1D1Ev
  virtual void  v1(); // _ZN6S600C12v1Ev
  virtual void  v2(); // _ZN6S600C12v2Ev
  virtual void  v3(); // _ZN6S600C12v3Ev
  virtual void  v4(); // _ZN6S600C12v4Ev
  S600C1(); // tgen
};
//SIG(1 S600C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 FC6{ m FC7{ m FL[2]}} FC6 Fp Fi FU8{ m FC9{ Fi:4 Fi:4 Fi:4 Fi:2 Fi:1 Fi:17} Fi} Fi:2 Fi:2 Fc:1 Fc:1 FC10{ m Fp Fp} FC11{ Fp Fp}[2]} vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc Fi[2] Fi[2] Fp FC6 FC6 FC6 FC12{ m FC6 FC6} Fp Fi Fi FC13{ m Fp}[4] Fp} vd v35 v36 v37 v38 v39 FC13 FC13 FC13 FC13 FC6 FC6 FC6 FC6 FC14{ m FC15{ m FL FL}}} vd v40 v41 v42 v43} vd v1 v2 v3 v4 FC16{ m FC17{ m FC18{ BC19{ vd v50 v51 v52 v53 v54 v55 FC20{ m Fp Fp Fp Fp}} BC21{} v44 v45 v46 v47 v48 v49 FC22{ BC23{ m Fp Fi Fp Fi Fi} FC24{ m FC6 FC6 FC6 FC6}} FC25{ BC23 FC26{ m FC7}} FC25} FC27{ BC28{ BC29{ vd v56} vd v57 Fp Fp FC30{ m FC31{ m Fp Fi Fi FC32{ m}}} FC33{ m Fp Fp}} vd FC34{ m FC35{ Fs Fs Fc Fc Fs}[12] Fi FC36{ Fs Fs}[4] Fi FC37{ m Fp Fp}}}} FC38{ m FC39{ BC19 BC21 v58 v59 v60 v61 v62 v63 FC40{ BC23 FC41{ m FC37 FC13}} FC40 FC25 FC25} FC42{ BC43{ BC29 vd v64 Fp Fp FC30 FC10} vd FC44{ m Fp Fi FC45{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC37}}}}}


 S600C1 ::~S600C1(){ note_dtor("S600C1", this);}
void  S600C1 ::v1(){vfunc_called(this, "_ZN6S600C12v1Ev");}
void  S600C1 ::v2(){vfunc_called(this, "_ZN6S600C12v2Ev");}
void  S600C1 ::v3(){vfunc_called(this, "_ZN6S600C12v3Ev");}
void  S600C1 ::v4(){vfunc_called(this, "_ZN6S600C12v4Ev");}
S600C1 ::S600C1(){ note_ctor("S600C1", this);} // tgen

static void Test_S600C1()
{
  extern Class_Descriptor cd_S600C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(148,217)];
    init_test(&cd_S600C1, buf);
    S600C1 *dp, &lv = *(dp=new (buf) S600C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1176,864), "sizeof(S600C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S600C1)");
    check_base_class_offset(lv, (S600C5*)(S600C4*)(S600C3*)(S600C2*), 0, "S600C1");
    check_base_class_offset(lv, (S600C4*)(S600C3*)(S600C2*), 0, "S600C1");
    check_base_class_offset(lv, (S600C3*)(S600C2*), 0, "S600C1");
    check_base_class_offset(lv, (S600C2*), 0, "S600C1");
    check_field_offset(lv, s600c1f0, ABISELECT(392,308), "S600C1.s600c1f0");
    test_class_info(&lv, &cd_S600C1);
    dp->~S600C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS600C1(Test_S600C1, "S600C1", ABISELECT(1176,864));

#else // __cplusplus

extern void _ZN6S600C1C1Ev();
extern void _ZN6S600C1D1Ev();
Name_Map name_map_S600C1[] = {
  NSPAIR(_ZN6S600C1C1Ev),
  NSPAIR(_ZN6S600C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S600C5;
extern VTBL_ENTRY _ZTI6S600C5[];
extern  VTBL_ENTRY _ZTV6S600C5[];
extern Class_Descriptor cd_S600C4;
extern VTBL_ENTRY _ZTI6S600C4[];
extern  VTBL_ENTRY _ZTV6S600C4[];
extern Class_Descriptor cd_S600C3;
extern VTBL_ENTRY _ZTI6S600C3[];
extern  VTBL_ENTRY _ZTV6S600C3[];
extern Class_Descriptor cd_S600C2;
extern VTBL_ENTRY _ZTI6S600C2[];
extern  VTBL_ENTRY _ZTV6S600C2[];
static Base_Class bases_S600C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S600C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S600C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S600C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S600C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S600C1[];
extern void _ZN6S600C1D1Ev();
extern void _ZN6S600C1D0Ev();
extern void _ZN6S600C52v5Ev();
extern void _ZN6S600C52v6Ev();
extern void _ZN6S600C52v7Ev();
extern void _ZN6S600C52v8Ev();
extern void _ZN6S600C52v9Ev();
extern void _ZN6S600C53v10Ev();
extern void _ZN6S600C53v11Ev();
extern void _ZN6S600C53v12Ev();
extern void _ZN6S600C53v13Ev();
extern void _ZN6S600C53v14Ev();
extern void _ZN6S600C53v15Ev();
extern void _ZN6S600C53v16Ev();
extern void _ZN6S600C53v17Ev();
extern void _ZN6S600C53v18Ev();
extern void _ZN6S600C53v19Ev();
extern void _ZN6S600C43v20Ev();
extern void _ZN6S600C43v21Ev();
extern void _ZN6S600C43v22Ev();
extern void _ZN6S600C43v23Ev();
extern void _ZN6S600C43v24Ev();
extern void _ZN6S600C43v25Ev();
extern void _ZN6S600C43v26Ev();
extern void _ZN6S600C43v27Ev();
extern void _ZN6S600C43v28Ev();
extern void _ZN6S600C43v29Ev();
extern void _ZN6S600C43v30Ev();
extern void _ZN6S600C43v31Ev();
extern void _ZN6S600C43v32Ev();
extern void _ZN6S600C43v33Ev();
extern void _ZN6S600C43v34Ev();
extern void _ZN6S600C33v35Ev();
extern void _ZN6S600C33v36Ev();
extern void _ZN6S600C33v37Ev();
extern void _ZN6S600C33v38Ev();
extern void _ZN6S600C33v39Ev();
extern void _ZN6S600C23v40Ev();
extern void _ZN6S600C23v41Ev();
extern void _ZN6S600C23v42Ev();
extern void _ZN6S600C23v43Ev();
extern void _ZN6S600C12v1Ev();
extern void _ZN6S600C12v2Ev();
extern void _ZN6S600C12v3Ev();
extern void _ZN6S600C12v4Ev();
static  VTBL_ENTRY vtc_S600C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S600C1[0]),
  (VTBL_ENTRY)&_ZN6S600C1D1Ev,
  (VTBL_ENTRY)&_ZN6S600C1D0Ev,
  (VTBL_ENTRY)&_ZN6S600C52v5Ev,
  (VTBL_ENTRY)&_ZN6S600C52v6Ev,
  (VTBL_ENTRY)&_ZN6S600C52v7Ev,
  (VTBL_ENTRY)&_ZN6S600C52v8Ev,
  (VTBL_ENTRY)&_ZN6S600C52v9Ev,
  (VTBL_ENTRY)&_ZN6S600C53v10Ev,
  (VTBL_ENTRY)&_ZN6S600C53v11Ev,
  (VTBL_ENTRY)&_ZN6S600C53v12Ev,
  (VTBL_ENTRY)&_ZN6S600C53v13Ev,
  (VTBL_ENTRY)&_ZN6S600C53v14Ev,
  (VTBL_ENTRY)&_ZN6S600C53v15Ev,
  (VTBL_ENTRY)&_ZN6S600C53v16Ev,
  (VTBL_ENTRY)&_ZN6S600C53v17Ev,
  (VTBL_ENTRY)&_ZN6S600C53v18Ev,
  (VTBL_ENTRY)&_ZN6S600C53v19Ev,
  (VTBL_ENTRY)&_ZN6S600C43v20Ev,
  (VTBL_ENTRY)&_ZN6S600C43v21Ev,
  (VTBL_ENTRY)&_ZN6S600C43v22Ev,
  (VTBL_ENTRY)&_ZN6S600C43v23Ev,
  (VTBL_ENTRY)&_ZN6S600C43v24Ev,
  (VTBL_ENTRY)&_ZN6S600C43v25Ev,
  (VTBL_ENTRY)&_ZN6S600C43v26Ev,
  (VTBL_ENTRY)&_ZN6S600C43v27Ev,
  (VTBL_ENTRY)&_ZN6S600C43v28Ev,
  (VTBL_ENTRY)&_ZN6S600C43v29Ev,
  (VTBL_ENTRY)&_ZN6S600C43v30Ev,
  (VTBL_ENTRY)&_ZN6S600C43v31Ev,
  (VTBL_ENTRY)&_ZN6S600C43v32Ev,
  (VTBL_ENTRY)&_ZN6S600C43v33Ev,
  (VTBL_ENTRY)&_ZN6S600C43v34Ev,
  (VTBL_ENTRY)&_ZN6S600C33v35Ev,
  (VTBL_ENTRY)&_ZN6S600C33v36Ev,
  (VTBL_ENTRY)&_ZN6S600C33v37Ev,
  (VTBL_ENTRY)&_ZN6S600C33v38Ev,
  (VTBL_ENTRY)&_ZN6S600C33v39Ev,
  (VTBL_ENTRY)&_ZN6S600C23v40Ev,
  (VTBL_ENTRY)&_ZN6S600C23v41Ev,
  (VTBL_ENTRY)&_ZN6S600C23v42Ev,
  (VTBL_ENTRY)&_ZN6S600C23v43Ev,
  (VTBL_ENTRY)&_ZN6S600C12v1Ev,
  (VTBL_ENTRY)&_ZN6S600C12v2Ev,
  (VTBL_ENTRY)&_ZN6S600C12v3Ev,
  (VTBL_ENTRY)&_ZN6S600C12v4Ev,
};
extern VTBL_ENTRY _ZTI6S600C1[];
extern  VTBL_ENTRY _ZTV6S600C1[];
Class_Descriptor cd_S600C1 = {  "S600C1", // class name
  bases_S600C1, 4,
  &(vtc_S600C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1176,864), // object size
  NSPAIRA(_ZTI6S600C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S600C1),47, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1564C4  {
  ::S2120C13_nt s1564c4f0;
  ::S2120C13_nt s1564c4f1;
  void *s1564c4f2;
  int s1564c4f3;
  ::S601C8 s1564c4f4;
  int s1564c4f5:2;
  int s1564c4f6:2;
  unsigned char s1564c4f7:1;
  unsigned char s1564c4f8:1;
  ::S601C53 s1564c4f9;
  ::S601C11 s1564c4f10[2];
  virtual  ~S1564C4(); // _ZN7S1564C4D1Ev
  virtual void  v8(); // _ZN7S1564C42v8Ev
  virtual void  v9(); // _ZN7S1564C42v9Ev
  virtual void  v10(); // _ZN7S1564C43v10Ev
  virtual void  v11(); // _ZN7S1564C43v11Ev
  virtual void  v12(); // _ZN7S1564C43v12Ev
  virtual void  v13(); // _ZN7S1564C43v13Ev
  virtual void  v14(); // _ZN7S1564C43v14Ev
  virtual void  v15(); // _ZN7S1564C43v15Ev
  virtual void  v16(); // _ZN7S1564C43v16Ev
  virtual void  v17(); // _ZN7S1564C43v17Ev
  virtual void  v18(); // _ZN7S1564C43v18Ev
  virtual void  v19(); // _ZN7S1564C43v19Ev
  virtual void  v20(); // _ZN7S1564C43v20Ev
  virtual void  v21(); // _ZN7S1564C43v21Ev
  virtual void  v22(); // _ZN7S1564C43v22Ev
  S1564C4(); // tgen
};
//SIG(-1 S1564C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 FC2{ m FC3{ m FL[2]}} FC2 Fp Fi FU4{ m FC5{ Fi:4 Fi:4 Fi:4 Fi:2 Fi:1 Fi:17} Fi} Fi:2 Fi:2 Fc:1 Fc:1 FC6{ m Fp Fp} FC7{ Fp Fp}[2]}


 S1564C4 ::~S1564C4(){ note_dtor("S1564C4", this);}
void  S1564C4 ::v8(){vfunc_called(this, "_ZN7S1564C42v8Ev");}
void  S1564C4 ::v9(){vfunc_called(this, "_ZN7S1564C42v9Ev");}
void  S1564C4 ::v10(){vfunc_called(this, "_ZN7S1564C43v10Ev");}
void  S1564C4 ::v11(){vfunc_called(this, "_ZN7S1564C43v11Ev");}
void  S1564C4 ::v12(){vfunc_called(this, "_ZN7S1564C43v12Ev");}
void  S1564C4 ::v13(){vfunc_called(this, "_ZN7S1564C43v13Ev");}
void  S1564C4 ::v14(){vfunc_called(this, "_ZN7S1564C43v14Ev");}
void  S1564C4 ::v15(){vfunc_called(this, "_ZN7S1564C43v15Ev");}
void  S1564C4 ::v16(){vfunc_called(this, "_ZN7S1564C43v16Ev");}
void  S1564C4 ::v17(){vfunc_called(this, "_ZN7S1564C43v17Ev");}
void  S1564C4 ::v18(){vfunc_called(this, "_ZN7S1564C43v18Ev");}
void  S1564C4 ::v19(){vfunc_called(this, "_ZN7S1564C43v19Ev");}
void  S1564C4 ::v20(){vfunc_called(this, "_ZN7S1564C43v20Ev");}
void  S1564C4 ::v21(){vfunc_called(this, "_ZN7S1564C43v21Ev");}
void  S1564C4 ::v22(){vfunc_called(this, "_ZN7S1564C43v22Ev");}
S1564C4 ::S1564C4(){ note_ctor("S1564C4", this);} // tgen

static void Test_S1564C4()
{
  extern Class_Descriptor cd_S1564C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,20)];
    init_test(&cd_S1564C4, buf);
    S1564C4 *dp, &lv = *(dp=new (buf) S1564C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,76), "sizeof(S1564C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1564C4)");
    check_field_offset(lv, s1564c4f0, ABISELECT(8,4), "S1564C4.s1564c4f0");
    check_field_offset(lv, s1564c4f1, ABISELECT(24,20), "S1564C4.s1564c4f1");
    check_field_offset(lv, s1564c4f2, ABISELECT(40,36), "S1564C4.s1564c4f2");
    check_field_offset(lv, s1564c4f3, ABISELECT(48,40), "S1564C4.s1564c4f3");
    check_field_offset(lv, s1564c4f4, ABISELECT(52,44), "S1564C4.s1564c4f4");
    set_bf_and_test(lv, s1564c4f5, ABISELECT(56,48), 0, 2, 1, "S1564C4");
    set_bf_and_test(lv, s1564c4f5, ABISELECT(56,48), 0, 2, hide_sll(1LL<<1), "S1564C4");
    set_bf_and_test(lv, s1564c4f6, ABISELECT(56,48), 2, 2, 1, "S1564C4");
    set_bf_and_test(lv, s1564c4f6, ABISELECT(56,48), 2, 2, hide_sll(1LL<<1), "S1564C4");
    set_bf_and_test(lv, s1564c4f7, ABISELECT(56,48), 4, 1, 1, "S1564C4");
    set_bf_and_test(lv, s1564c4f8, ABISELECT(56,48), 5, 1, 1, "S1564C4");
    check_field_offset(lv, s1564c4f9, ABISELECT(64,52), "S1564C4.s1564c4f9");
    check_field_offset(lv, s1564c4f10, ABISELECT(80,60), "S1564C4.s1564c4f10");
    test_class_info(&lv, &cd_S1564C4);
    dp->~S1564C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1564C4(Test_S1564C4, "S1564C4", ABISELECT(112,76));

#else // __cplusplus

extern void _ZN7S1564C4C1Ev();
extern void _ZN7S1564C4D1Ev();
Name_Map name_map_S1564C4[] = {
  NSPAIR(_ZN7S1564C4C1Ev),
  NSPAIR(_ZN7S1564C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1564C4[];
extern void _ZN7S1564C4D1Ev();
extern void _ZN7S1564C4D0Ev();
extern void _ZN7S1564C42v8Ev();
extern void _ZN7S1564C42v9Ev();
extern void _ZN7S1564C43v10Ev();
extern void _ZN7S1564C43v11Ev();
extern void _ZN7S1564C43v12Ev();
extern void _ZN7S1564C43v13Ev();
extern void _ZN7S1564C43v14Ev();
extern void _ZN7S1564C43v15Ev();
extern void _ZN7S1564C43v16Ev();
extern void _ZN7S1564C43v17Ev();
extern void _ZN7S1564C43v18Ev();
extern void _ZN7S1564C43v19Ev();
extern void _ZN7S1564C43v20Ev();
extern void _ZN7S1564C43v21Ev();
extern void _ZN7S1564C43v22Ev();
static  VTBL_ENTRY vtc_S1564C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1564C4[0]),
  (VTBL_ENTRY)&_ZN7S1564C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1564C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1564C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1564C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v22Ev,
};
extern VTBL_ENTRY _ZTI7S1564C4[];
extern  VTBL_ENTRY _ZTV7S1564C4[];
Class_Descriptor cd_S1564C4 = {  "S1564C4", // class name
  0,0,//no base classes
  &(vtc_S1564C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,76), // object size
  NSPAIRA(_ZTI7S1564C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1564C4),19, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1564C3  : S1564C4 {
  unsigned char s1564c3f0:1;
  unsigned char s1564c3f1:1;
  unsigned char s1564c3f2:1;
  unsigned char s1564c3f3:1;
  unsigned char s1564c3f4:1;
  unsigned char s1564c3f5:1;
  unsigned char s1564c3f6:1;
  char s1564c3f7;
  int s1564c3f8[2];
  int s1564c3f9[2];
  void *s1564c3f10;
  ::S2120C13_nt s1564c3f11;
  ::S2120C13_nt s1564c3f12;
  ::S2120C13_nt s1564c3f13;
  ::S601C12 s1564c3f14;
  void *s1564c3f15;
  int s1564c3f16;
  int s1564c3f17;
  ::S601C13_nt s1564c3f18[4];
  void *s1564c3f19;
  virtual  ~S1564C3(); // _ZN7S1564C3D1Ev
  virtual void  v23(); // _ZN7S1564C33v23Ev
  virtual void  v24(); // _ZN7S1564C33v24Ev
  virtual void  v25(); // _ZN7S1564C33v25Ev
  virtual void  v26(); // _ZN7S1564C33v26Ev
  virtual void  v27(); // _ZN7S1564C33v27Ev
  virtual void  v28(); // _ZN7S1564C33v28Ev
  virtual void  v29(); // _ZN7S1564C33v29Ev
  virtual void  v30(); // _ZN7S1564C33v30Ev
  virtual void  v31(); // _ZN7S1564C33v31Ev
  virtual void  v32(); // _ZN7S1564C33v32Ev
  virtual void  v33(); // _ZN7S1564C33v33Ev
  virtual void  v34(); // _ZN7S1564C33v34Ev
  virtual void  v35(); // _ZN7S1564C33v35Ev
  virtual void  v36(); // _ZN7S1564C33v36Ev
  virtual void  v37(); // _ZN7S1564C33v37Ev
  S1564C3(); // tgen
};
//SIG(-1 S1564C3) C1{ BC2{ vd v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 FC3{ m FC4{ m FL[2]}} FC3 Fp Fi FU5{ m FC6{ Fi:4 Fi:4 Fi:4 Fi:2 Fi:1 Fi:17} Fi} Fi:2 Fi:2 Fc:1 Fc:1 FC7{ m Fp Fp} FC8{ Fp Fp}[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc Fi[2] Fi[2] Fp FC3 FC3 FC3 FC9{ m FC3 FC3} Fp Fi Fi FC10{ m Fp}[4] Fp}


 S1564C3 ::~S1564C3(){ note_dtor("S1564C3", this);}
void  S1564C3 ::v23(){vfunc_called(this, "_ZN7S1564C33v23Ev");}
void  S1564C3 ::v24(){vfunc_called(this, "_ZN7S1564C33v24Ev");}
void  S1564C3 ::v25(){vfunc_called(this, "_ZN7S1564C33v25Ev");}
void  S1564C3 ::v26(){vfunc_called(this, "_ZN7S1564C33v26Ev");}
void  S1564C3 ::v27(){vfunc_called(this, "_ZN7S1564C33v27Ev");}
void  S1564C3 ::v28(){vfunc_called(this, "_ZN7S1564C33v28Ev");}
void  S1564C3 ::v29(){vfunc_called(this, "_ZN7S1564C33v29Ev");}
void  S1564C3 ::v30(){vfunc_called(this, "_ZN7S1564C33v30Ev");}
void  S1564C3 ::v31(){vfunc_called(this, "_ZN7S1564C33v31Ev");}
void  S1564C3 ::v32(){vfunc_called(this, "_ZN7S1564C33v32Ev");}
void  S1564C3 ::v33(){vfunc_called(this, "_ZN7S1564C33v33Ev");}
void  S1564C3 ::v34(){vfunc_called(this, "_ZN7S1564C33v34Ev");}
void  S1564C3 ::v35(){vfunc_called(this, "_ZN7S1564C33v35Ev");}
void  S1564C3 ::v36(){vfunc_called(this, "_ZN7S1564C33v36Ev");}
void  S1564C3 ::v37(){vfunc_called(this, "_ZN7S1564C33v37Ev");}
S1564C3 ::S1564C3(){ note_ctor("S1564C3", this);} // tgen

static void Test_S1564C3()
{
  extern Class_Descriptor cd_S1564C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(36,54)];
    init_test(&cd_S1564C3, buf);
    S1564C3 *dp, &lv = *(dp=new (buf) S1564C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(280,212), "sizeof(S1564C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1564C3)");
    check_base_class_offset(lv, (S1564C4*), 0, "S1564C3");
    set_bf_and_test(lv, s1564c3f0, ABISELECT(112,76), 0, 1, 1, "S1564C3");
    set_bf_and_test(lv, s1564c3f1, ABISELECT(112,76), 1, 1, 1, "S1564C3");
    set_bf_and_test(lv, s1564c3f2, ABISELECT(112,76), 2, 1, 1, "S1564C3");
    set_bf_and_test(lv, s1564c3f3, ABISELECT(112,76), 3, 1, 1, "S1564C3");
    set_bf_and_test(lv, s1564c3f4, ABISELECT(112,76), 4, 1, 1, "S1564C3");
    set_bf_and_test(lv, s1564c3f5, ABISELECT(112,76), 5, 1, 1, "S1564C3");
    set_bf_and_test(lv, s1564c3f6, ABISELECT(112,76), 6, 1, 1, "S1564C3");
    check_field_offset(lv, s1564c3f7, ABISELECT(113,77), "S1564C3.s1564c3f7");
    check_field_offset(lv, s1564c3f8, ABISELECT(116,80), "S1564C3.s1564c3f8");
    check_field_offset(lv, s1564c3f9, ABISELECT(124,88), "S1564C3.s1564c3f9");
    check_field_offset(lv, s1564c3f10, ABISELECT(136,96), "S1564C3.s1564c3f10");
    check_field_offset(lv, s1564c3f11, ABISELECT(144,100), "S1564C3.s1564c3f11");
    check_field_offset(lv, s1564c3f12, ABISELECT(160,116), "S1564C3.s1564c3f12");
    check_field_offset(lv, s1564c3f13, ABISELECT(176,132), "S1564C3.s1564c3f13");
    check_field_offset(lv, s1564c3f14, ABISELECT(192,148), "S1564C3.s1564c3f14");
    check_field_offset(lv, s1564c3f15, ABISELECT(224,180), "S1564C3.s1564c3f15");
    check_field_offset(lv, s1564c3f16, ABISELECT(232,184), "S1564C3.s1564c3f16");
    check_field_offset(lv, s1564c3f17, ABISELECT(236,188), "S1564C3.s1564c3f17");
    check_field_offset(lv, s1564c3f18, ABISELECT(240,192), "S1564C3.s1564c3f18");
    check_field_offset(lv, s1564c3f19, ABISELECT(272,208), "S1564C3.s1564c3f19");
    test_class_info(&lv, &cd_S1564C3);
    dp->~S1564C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1564C3(Test_S1564C3, "S1564C3", ABISELECT(280,212));

#else // __cplusplus

extern void _ZN7S1564C3C1Ev();
extern void _ZN7S1564C3D1Ev();
Name_Map name_map_S1564C3[] = {
  NSPAIR(_ZN7S1564C3C1Ev),
  NSPAIR(_ZN7S1564C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1564C4;
extern VTBL_ENTRY _ZTI7S1564C4[];
extern  VTBL_ENTRY _ZTV7S1564C4[];
static Base_Class bases_S1564C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1564C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1564C3[];
extern void _ZN7S1564C3D1Ev();
extern void _ZN7S1564C3D0Ev();
extern void _ZN7S1564C42v8Ev();
extern void _ZN7S1564C42v9Ev();
extern void _ZN7S1564C43v10Ev();
extern void _ZN7S1564C43v11Ev();
extern void _ZN7S1564C43v12Ev();
extern void _ZN7S1564C43v13Ev();
extern void _ZN7S1564C43v14Ev();
extern void _ZN7S1564C43v15Ev();
extern void _ZN7S1564C43v16Ev();
extern void _ZN7S1564C43v17Ev();
extern void _ZN7S1564C43v18Ev();
extern void _ZN7S1564C43v19Ev();
extern void _ZN7S1564C43v20Ev();
extern void _ZN7S1564C43v21Ev();
extern void _ZN7S1564C43v22Ev();
extern void _ZN7S1564C33v23Ev();
extern void _ZN7S1564C33v24Ev();
extern void _ZN7S1564C33v25Ev();
extern void _ZN7S1564C33v26Ev();
extern void _ZN7S1564C33v27Ev();
extern void _ZN7S1564C33v28Ev();
extern void _ZN7S1564C33v29Ev();
extern void _ZN7S1564C33v30Ev();
extern void _ZN7S1564C33v31Ev();
extern void _ZN7S1564C33v32Ev();
extern void _ZN7S1564C33v33Ev();
extern void _ZN7S1564C33v34Ev();
extern void _ZN7S1564C33v35Ev();
extern void _ZN7S1564C33v36Ev();
extern void _ZN7S1564C33v37Ev();
static  VTBL_ENTRY vtc_S1564C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1564C3[0]),
  (VTBL_ENTRY)&_ZN7S1564C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1564C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1564C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1564C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v29Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v30Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v31Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v32Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v33Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v34Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v35Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v36Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v37Ev,
};
extern VTBL_ENTRY _ZTI7S1564C3[];
extern  VTBL_ENTRY _ZTV7S1564C3[];
Class_Descriptor cd_S1564C3 = {  "S1564C3", // class name
  bases_S1564C3, 1,
  &(vtc_S1564C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(280,212), // object size
  NSPAIRA(_ZTI7S1564C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1564C3),34, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1564C13_nt  {
  virtual  ~S1564C13_nt(); // _ZN11S1564C13_ntD1Ev
  virtual void  v38(); // _ZN11S1564C13_nt3v38Ev
  virtual void  v39(); // _ZN11S1564C13_nt3v39Ev
  virtual void  v40(); // _ZN11S1564C13_nt3v40Ev
  virtual void  v41(); // _ZN11S1564C13_nt3v41Ev
  virtual void  v42(); // _ZN11S1564C13_nt3v42Ev
  virtual void  v43(); // _ZN11S1564C13_nt3v43Ev
  S1564C13_nt(); // tgen
};
//SIG(-1 S1564C13_nt) C1{ vd v1 v2 v3 v4 v5 v6}


 S1564C13_nt ::~S1564C13_nt(){ note_dtor("S1564C13_nt", this);}
void  S1564C13_nt ::v38(){vfunc_called(this, "_ZN11S1564C13_nt3v38Ev");}
void  S1564C13_nt ::v39(){vfunc_called(this, "_ZN11S1564C13_nt3v39Ev");}
void  S1564C13_nt ::v40(){vfunc_called(this, "_ZN11S1564C13_nt3v40Ev");}
void  S1564C13_nt ::v41(){vfunc_called(this, "_ZN11S1564C13_nt3v41Ev");}
void  S1564C13_nt ::v42(){vfunc_called(this, "_ZN11S1564C13_nt3v42Ev");}
void  S1564C13_nt ::v43(){vfunc_called(this, "_ZN11S1564C13_nt3v43Ev");}
S1564C13_nt ::S1564C13_nt(){ note_ctor("S1564C13_nt", this);} // tgen

//skip512 S1564C13_nt

#else // __cplusplus

extern void _ZN11S1564C13_ntC1Ev();
extern void _ZN11S1564C13_ntD1Ev();
Name_Map name_map_S1564C13_nt[] = {
  NSPAIR(_ZN11S1564C13_ntC1Ev),
  NSPAIR(_ZN11S1564C13_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S1564C13_nt[];
extern void _ZN11S1564C13_ntD1Ev();
extern void _ZN11S1564C13_ntD0Ev();
extern void _ZN11S1564C13_nt3v38Ev();
extern void _ZN11S1564C13_nt3v39Ev();
extern void _ZN11S1564C13_nt3v40Ev();
extern void _ZN11S1564C13_nt3v41Ev();
extern void _ZN11S1564C13_nt3v42Ev();
extern void _ZN11S1564C13_nt3v43Ev();
static  VTBL_ENTRY vtc_S1564C13_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S1564C13_nt[0]),
  (VTBL_ENTRY)&_ZN11S1564C13_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S1564C13_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S1564C13_nt3v38Ev,
  (VTBL_ENTRY)&_ZN11S1564C13_nt3v39Ev,
  (VTBL_ENTRY)&_ZN11S1564C13_nt3v40Ev,
  (VTBL_ENTRY)&_ZN11S1564C13_nt3v41Ev,
  (VTBL_ENTRY)&_ZN11S1564C13_nt3v42Ev,
  (VTBL_ENTRY)&_ZN11S1564C13_nt3v43Ev,
};
extern VTBL_ENTRY _ZTI11S1564C13_nt[];
VTBL_ENTRY *P__ZTI11S1564C13_nt = _ZTI11S1564C13_nt; 
extern  VTBL_ENTRY _ZTV11S1564C13_nt[];
Class_Descriptor cd_S1564C13_nt = {  "S1564C13_nt", // class name
  0,0,//no base classes
  &(vtc_S1564C13_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S1564C13_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S1564C13_nt),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1564C14  {
  ::S2120C13_nt s1564c14f0;
  ::S2120C13_nt s1564c14f1;
  ::S2120C13_nt s1564c14f2;
  void  mf1564c14(); // _ZN8S1564C149mf1564c14Ev
};
//SIG(-1 S1564C14) C1{ m FC2{ m FC3{ m FL[2]}} FC2 FC2}


void  S1564C14 ::mf1564c14(){}

static void Test_S1564C14()
{
  {
    init_simple_test("S1564C14");
    S1564C14 lv;
    check2(sizeof(lv), 48, "sizeof(S1564C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1564C14)");
    check_field_offset(lv, s1564c14f0, 0, "S1564C14.s1564c14f0");
    check_field_offset(lv, s1564c14f1, 16, "S1564C14.s1564c14f1");
    check_field_offset(lv, s1564c14f2, 32, "S1564C14.s1564c14f2");
  }
}
static Arrange_To_Call_Me vS1564C14(Test_S1564C14, "S1564C14", 48);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1564C15  {
  int s1564c15f0;
  int s1564c15f1;
  int s1564c15f2;
  int s1564c15f3;
  void  mf1564c15(); // _ZN8S1564C159mf1564c15Ev
};
//SIG(-1 S1564C15) C1{ m Fi[4]}


void  S1564C15 ::mf1564c15(){}

static void Test_S1564C15()
{
  {
    init_simple_test("S1564C15");
    S1564C15 lv;
    check2(sizeof(lv), 16, "sizeof(S1564C15)");
    check2(__alignof__(lv), 4, "__alignof__(S1564C15)");
    check_field_offset(lv, s1564c15f0, 0, "S1564C15.s1564c15f0");
    check_field_offset(lv, s1564c15f1, 4, "S1564C15.s1564c15f1");
    check_field_offset(lv, s1564c15f2, 8, "S1564C15.s1564c15f2");
    check_field_offset(lv, s1564c15f3, 12, "S1564C15.s1564c15f3");
  }
}
static Arrange_To_Call_Me vS1564C15(Test_S1564C15, "S1564C15", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1564C2  : S1564C3 , S1564C13_nt {
  ::S1564C14 s1564c2f0;
  ::S1564C14 s1564c2f1;
  ::S601C13_nt s1564c2f2;
  void *s1564c2f3;
  ::S1564C15 s1564c2f4;
  ::S1564C15 s1564c2f5;
  int s1564c2f6;
  int s1564c2f7;
  void *s1564c2f8;
  int s1564c2f9;
  char s1564c2f10;
  ::S1564C15 s1564c2f11;
  ::S1564C15 s1564c2f12;
  ::S601C29_nt s1564c2f13;
  ::S601C29_nt s1564c2f14;
  ::S601C29_nt s1564c2f15;
  ::S601C29_nt s1564c2f16;
  char s1564c2f17;
  int s1564c2f18;
  int s1564c2f19;
  char s1564c2f20;
  char s1564c2f21;
  char s1564c2f22;
  ::S601C29_nt s1564c2f23;
  int s1564c2f24;
  ::S2120C13_nt s1564c2f25;
  ::S1564C15 s1564c2f26;
  int s1564c2f27;
  char s1564c2f28;
  void *s1564c2f29;
  virtual  ~S1564C2(); // _ZN7S1564C2D1Ev
  virtual void  v44(); // _ZN7S1564C23v44Ev
  virtual void  v45(); // _ZN7S1564C23v45Ev
  virtual void  v46(); // _ZN7S1564C23v46Ev
  virtual void  v47(); // _ZN7S1564C23v47Ev
  virtual void  v48(); // _ZN7S1564C23v48Ev
  virtual void  v49(); // _ZN7S1564C23v49Ev
  virtual void  v50(); // _ZN7S1564C23v50Ev
  virtual void  v51(); // _ZN7S1564C23v51Ev
  virtual void  v52(); // _ZN7S1564C23v52Ev
  virtual void  v53(); // _ZN7S1564C23v53Ev
  virtual void  v54(); // _ZN7S1564C23v54Ev
  virtual void  v55(); // _ZN7S1564C23v55Ev
  virtual void  v56(); // _ZN7S1564C23v56Ev
  virtual void  v57(); // _ZN7S1564C23v57Ev
  virtual void  v58(); // _ZN7S1564C23v58Ev
  virtual void  v59(); // _ZN7S1564C23v59Ev
  virtual void  v60(); // _ZN7S1564C23v60Ev
  virtual void  v61(); // _ZN7S1564C23v61Ev
  virtual void  v62(); // _ZN7S1564C23v62Ev
  virtual void  v63(); // _ZN7S1564C23v63Ev
  virtual void  v64(); // _ZN7S1564C23v64Ev
  virtual void  v65(); // _ZN7S1564C23v65Ev
  virtual void  v66(); // _ZN7S1564C23v66Ev
  virtual void  v67(); // _ZN7S1564C23v67Ev
  S1564C2(); // tgen
};
//SIG(-1 S1564C2) C1{ BC2{ BC3{ vd v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 FC4{ m FC5{ m FL[2]}} FC4 Fp Fi FU6{ m FC7{ Fi:4 Fi:4 Fi:4 Fi:2 Fi:1 Fi:17} Fi} Fi:2 Fi:2 Fc:1 Fc:1 FC8{ m Fp Fp} FC9{ Fp Fp}[2]} vd v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc Fi[2] Fi[2] Fp FC4 FC4 FC4 FC10{ m FC4 FC4} Fp Fi Fi FC11{ m Fp}[4] Fp} BC12{ vd v55 v56 v57 v58 v59 v60} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 FC13{ m FC4 FC4 FC4} FC13 FC11 Fp FC14{ m Fi Fi Fi Fi} FC14 Fi Fi Fp Fi Fc FC14 FC14 FC15{ m FC16{ m FL}} FC15 FC15 FC15 Fc Fi Fi Fc Fc Fc FC15 Fi FC4 FC14 Fi Fc Fp}


 S1564C2 ::~S1564C2(){ note_dtor("S1564C2", this);}
void  S1564C2 ::v44(){vfunc_called(this, "_ZN7S1564C23v44Ev");}
void  S1564C2 ::v45(){vfunc_called(this, "_ZN7S1564C23v45Ev");}
void  S1564C2 ::v46(){vfunc_called(this, "_ZN7S1564C23v46Ev");}
void  S1564C2 ::v47(){vfunc_called(this, "_ZN7S1564C23v47Ev");}
void  S1564C2 ::v48(){vfunc_called(this, "_ZN7S1564C23v48Ev");}
void  S1564C2 ::v49(){vfunc_called(this, "_ZN7S1564C23v49Ev");}
void  S1564C2 ::v50(){vfunc_called(this, "_ZN7S1564C23v50Ev");}
void  S1564C2 ::v51(){vfunc_called(this, "_ZN7S1564C23v51Ev");}
void  S1564C2 ::v52(){vfunc_called(this, "_ZN7S1564C23v52Ev");}
void  S1564C2 ::v53(){vfunc_called(this, "_ZN7S1564C23v53Ev");}
void  S1564C2 ::v54(){vfunc_called(this, "_ZN7S1564C23v54Ev");}
void  S1564C2 ::v55(){vfunc_called(this, "_ZN7S1564C23v55Ev");}
void  S1564C2 ::v56(){vfunc_called(this, "_ZN7S1564C23v56Ev");}
void  S1564C2 ::v57(){vfunc_called(this, "_ZN7S1564C23v57Ev");}
void  S1564C2 ::v58(){vfunc_called(this, "_ZN7S1564C23v58Ev");}
void  S1564C2 ::v59(){vfunc_called(this, "_ZN7S1564C23v59Ev");}
void  S1564C2 ::v60(){vfunc_called(this, "_ZN7S1564C23v60Ev");}
void  S1564C2 ::v61(){vfunc_called(this, "_ZN7S1564C23v61Ev");}
void  S1564C2 ::v62(){vfunc_called(this, "_ZN7S1564C23v62Ev");}
void  S1564C2 ::v63(){vfunc_called(this, "_ZN7S1564C23v63Ev");}
void  S1564C2 ::v64(){vfunc_called(this, "_ZN7S1564C23v64Ev");}
void  S1564C2 ::v65(){vfunc_called(this, "_ZN7S1564C23v65Ev");}
void  S1564C2 ::v66(){vfunc_called(this, "_ZN7S1564C23v66Ev");}
void  S1564C2 ::v67(){vfunc_called(this, "_ZN7S1564C23v67Ev");}
S1564C2 ::S1564C2(){ note_ctor("S1564C2", this);} // tgen

static void Test_S1564C2()
{
  extern Class_Descriptor cd_S1564C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(76,128)];
    init_test(&cd_S1564C2, buf);
    S1564C2 *dp, &lv = *(dp=new (buf) S1564C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(600,508), "sizeof(S1564C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1564C2)");
    check_base_class_offset(lv, (S1564C4*)(S1564C3*), 0, "S1564C2");
    check_base_class_offset(lv, (S1564C3*), 0, "S1564C2");
    check_base_class_offset(lv, (S1564C13_nt*), ABISELECT(280,212), "S1564C2");
    check_field_offset(lv, s1564c2f0, ABISELECT(288,216), "S1564C2.s1564c2f0");
    check_field_offset(lv, s1564c2f1, ABISELECT(336,264), "S1564C2.s1564c2f1");
    check_field_offset(lv, s1564c2f2, ABISELECT(384,312), "S1564C2.s1564c2f2");
    check_field_offset(lv, s1564c2f3, ABISELECT(392,316), "S1564C2.s1564c2f3");
    check_field_offset(lv, s1564c2f4, ABISELECT(400,320), "S1564C2.s1564c2f4");
    check_field_offset(lv, s1564c2f5, ABISELECT(416,336), "S1564C2.s1564c2f5");
    check_field_offset(lv, s1564c2f6, ABISELECT(432,352), "S1564C2.s1564c2f6");
    check_field_offset(lv, s1564c2f7, ABISELECT(436,356), "S1564C2.s1564c2f7");
    check_field_offset(lv, s1564c2f8, ABISELECT(440,360), "S1564C2.s1564c2f8");
    check_field_offset(lv, s1564c2f9, ABISELECT(448,364), "S1564C2.s1564c2f9");
    check_field_offset(lv, s1564c2f10, ABISELECT(452,368), "S1564C2.s1564c2f10");
    check_field_offset(lv, s1564c2f11, ABISELECT(456,372), "S1564C2.s1564c2f11");
    check_field_offset(lv, s1564c2f12, ABISELECT(472,388), "S1564C2.s1564c2f12");
    check_field_offset(lv, s1564c2f13, ABISELECT(488,404), "S1564C2.s1564c2f13");
    check_field_offset(lv, s1564c2f14, ABISELECT(496,412), "S1564C2.s1564c2f14");
    check_field_offset(lv, s1564c2f15, ABISELECT(504,420), "S1564C2.s1564c2f15");
    check_field_offset(lv, s1564c2f16, ABISELECT(512,428), "S1564C2.s1564c2f16");
    check_field_offset(lv, s1564c2f17, ABISELECT(520,436), "S1564C2.s1564c2f17");
    check_field_offset(lv, s1564c2f18, ABISELECT(524,440), "S1564C2.s1564c2f18");
    check_field_offset(lv, s1564c2f19, ABISELECT(528,444), "S1564C2.s1564c2f19");
    check_field_offset(lv, s1564c2f20, ABISELECT(532,448), "S1564C2.s1564c2f20");
    check_field_offset(lv, s1564c2f21, ABISELECT(533,449), "S1564C2.s1564c2f21");
    check_field_offset(lv, s1564c2f22, ABISELECT(534,450), "S1564C2.s1564c2f22");
    check_field_offset(lv, s1564c2f23, ABISELECT(536,452), "S1564C2.s1564c2f23");
    check_field_offset(lv, s1564c2f24, ABISELECT(544,460), "S1564C2.s1564c2f24");
    check_field_offset(lv, s1564c2f25, ABISELECT(552,464), "S1564C2.s1564c2f25");
    check_field_offset(lv, s1564c2f26, ABISELECT(568,480), "S1564C2.s1564c2f26");
    check_field_offset(lv, s1564c2f27, ABISELECT(584,496), "S1564C2.s1564c2f27");
    check_field_offset(lv, s1564c2f28, ABISELECT(588,500), "S1564C2.s1564c2f28");
    check_field_offset(lv, s1564c2f29, ABISELECT(592,504), "S1564C2.s1564c2f29");
    test_class_info(&lv, &cd_S1564C2);
    dp->~S1564C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1564C2(Test_S1564C2, "S1564C2", ABISELECT(600,508));

#else // __cplusplus

extern void _ZN7S1564C2C1Ev();
extern void _ZN7S1564C2D1Ev();
Name_Map name_map_S1564C2[] = {
  NSPAIR(_ZN7S1564C2C1Ev),
  NSPAIR(_ZN7S1564C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1564C4;
extern VTBL_ENTRY _ZTI7S1564C4[];
extern  VTBL_ENTRY _ZTV7S1564C4[];
extern Class_Descriptor cd_S1564C3;
extern VTBL_ENTRY _ZTI7S1564C3[];
extern  VTBL_ENTRY _ZTV7S1564C3[];
extern Class_Descriptor cd_S1564C13_nt;
extern VTBL_ENTRY _ZTI11S1564C13_nt[];
extern  VTBL_ENTRY _ZTV11S1564C13_nt[];
static Base_Class bases_S1564C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1564C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1564C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1564C13_nt,    ABISELECT(280,212), //bcp->offset
    58, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1564C2[];
extern void _ZN7S1564C2D1Ev();
extern void _ZN7S1564C2D0Ev();
extern void _ZN7S1564C42v8Ev();
extern void _ZN7S1564C42v9Ev();
extern void _ZN7S1564C43v10Ev();
extern void _ZN7S1564C43v11Ev();
extern void _ZN7S1564C43v12Ev();
extern void _ZN7S1564C43v13Ev();
extern void _ZN7S1564C43v14Ev();
extern void _ZN7S1564C43v15Ev();
extern void _ZN7S1564C43v16Ev();
extern void _ZN7S1564C43v17Ev();
extern void _ZN7S1564C43v18Ev();
extern void _ZN7S1564C43v19Ev();
extern void _ZN7S1564C43v20Ev();
extern void _ZN7S1564C43v21Ev();
extern void _ZN7S1564C43v22Ev();
extern void _ZN7S1564C33v23Ev();
extern void _ZN7S1564C33v24Ev();
extern void _ZN7S1564C33v25Ev();
extern void _ZN7S1564C33v26Ev();
extern void _ZN7S1564C33v27Ev();
extern void _ZN7S1564C33v28Ev();
extern void _ZN7S1564C33v29Ev();
extern void _ZN7S1564C33v30Ev();
extern void _ZN7S1564C33v31Ev();
extern void _ZN7S1564C33v32Ev();
extern void _ZN7S1564C33v33Ev();
extern void _ZN7S1564C33v34Ev();
extern void _ZN7S1564C33v35Ev();
extern void _ZN7S1564C33v36Ev();
extern void _ZN7S1564C33v37Ev();
extern void _ZN7S1564C23v44Ev();
extern void _ZN7S1564C23v45Ev();
extern void _ZN7S1564C23v46Ev();
extern void _ZN7S1564C23v47Ev();
extern void _ZN7S1564C23v48Ev();
extern void _ZN7S1564C23v49Ev();
extern void _ZN7S1564C23v50Ev();
extern void _ZN7S1564C23v51Ev();
extern void _ZN7S1564C23v52Ev();
extern void _ZN7S1564C23v53Ev();
extern void _ZN7S1564C23v54Ev();
extern void _ZN7S1564C23v55Ev();
extern void _ZN7S1564C23v56Ev();
extern void _ZN7S1564C23v57Ev();
extern void _ZN7S1564C23v58Ev();
extern void _ZN7S1564C23v59Ev();
extern void _ZN7S1564C23v60Ev();
extern void _ZN7S1564C23v61Ev();
extern void _ZN7S1564C23v62Ev();
extern void _ZN7S1564C23v63Ev();
extern void _ZN7S1564C23v64Ev();
extern void _ZN7S1564C23v65Ev();
extern void _ZN7S1564C23v66Ev();
extern void _ZN7S1564C23v67Ev();
extern void ABISELECT(_ZThn280_N7S1564C2D1Ev,_ZThn212_N7S1564C2D1Ev)();
extern void ABISELECT(_ZThn280_N7S1564C2D0Ev,_ZThn212_N7S1564C2D0Ev)();
extern void _ZN11S1564C13_nt3v38Ev();
extern void _ZN11S1564C13_nt3v39Ev();
extern void _ZN11S1564C13_nt3v40Ev();
extern void _ZN11S1564C13_nt3v41Ev();
extern void _ZN11S1564C13_nt3v42Ev();
extern void _ZN11S1564C13_nt3v43Ev();
static  VTBL_ENTRY vtc_S1564C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1564C2[0]),
  (VTBL_ENTRY)&_ZN7S1564C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1564C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1564C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1564C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v29Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v30Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v31Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v32Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v33Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v34Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v35Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v36Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v37Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v44Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v45Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v46Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v47Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v48Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v49Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v50Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v51Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v52Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v53Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v54Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v55Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v56Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v57Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v58Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v59Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v60Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v61Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v62Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v63Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v64Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v65Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v66Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v67Ev,
  ABISELECT(-280,-212),
  (VTBL_ENTRY)&(_ZTI7S1564C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn280_N7S1564C2D1Ev,_ZThn212_N7S1564C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn280_N7S1564C2D0Ev,_ZThn212_N7S1564C2D0Ev),
  (VTBL_ENTRY)&_ZN11S1564C13_nt3v38Ev,
  (VTBL_ENTRY)&_ZN11S1564C13_nt3v39Ev,
  (VTBL_ENTRY)&_ZN11S1564C13_nt3v40Ev,
  (VTBL_ENTRY)&_ZN11S1564C13_nt3v41Ev,
  (VTBL_ENTRY)&_ZN11S1564C13_nt3v42Ev,
  (VTBL_ENTRY)&_ZN11S1564C13_nt3v43Ev,
};
extern VTBL_ENTRY _ZTI7S1564C2[];
extern  VTBL_ENTRY _ZTV7S1564C2[];
Class_Descriptor cd_S1564C2 = {  "S1564C2", // class name
  bases_S1564C2, 3,
  &(vtc_S1564C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(600,508), // object size
  NSPAIRA(_ZTI7S1564C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S1564C2),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1564C1  : S1564C2 {
  ::S1564C15 s1564c1f0;
  char s1564c1f1;
  ::S2120C13_nt s1564c1f2;
  char s1564c1f3;
  void *s1564c1f4;
  void *s1564c1f5;
  char s1564c1f6;
  char s1564c1f7;
  char s1564c1f8;
  ::S601C13_nt s1564c1f9;
  char s1564c1f10;
  virtual  ~S1564C1(); // _ZN7S1564C1D1Ev
  virtual void  v1(); // _ZN7S1564C12v1Ev
  virtual void  v2(); // _ZN7S1564C12v2Ev
  virtual void  v3(); // _ZN7S1564C12v3Ev
  virtual void  v4(); // _ZN7S1564C12v4Ev
  virtual void  v5(); // _ZN7S1564C12v5Ev
  virtual void  v6(); // _ZN7S1564C12v6Ev
  virtual void  v7(); // _ZN7S1564C12v7Ev
  S1564C1(); // tgen
};
//SIG(1 S1564C1) C1{ BC2{ BC3{ BC4{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 FC5{ m FC6{ m FL[2]}} FC5 Fp Fi FU7{ m FC8{ Fi:4 Fi:4 Fi:4 Fi:2 Fi:1 Fi:17} Fi} Fi:2 Fi:2 Fc:1 Fc:1 FC9{ m Fp Fp} FC10{ Fp Fp}[2]} vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc Fi[2] Fi[2] Fp FC5 FC5 FC5 FC11{ m FC5 FC5} Fp Fi Fi FC12{ m Fp}[4] Fp} BC13{ vd v38 v39 v40 v41 v42 v43} vd v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 FC14{ m FC5 FC5 FC5} FC14 FC12 Fp FC15{ m Fi Fi Fi Fi} FC15 Fi Fi Fp Fi Fc FC15 FC15 FC16{ m FC17{ m FL}} FC16 FC16 FC16 Fc Fi Fi Fc Fc Fc FC16 Fi FC5 FC15 Fi Fc Fp} vd v1 v2 v3 v4 v5 v6 v7 FC15 Fc FC5 Fc Fp Fp Fc Fc Fc FC12 Fc}


 S1564C1 ::~S1564C1(){ note_dtor("S1564C1", this);}
void  S1564C1 ::v1(){vfunc_called(this, "_ZN7S1564C12v1Ev");}
void  S1564C1 ::v2(){vfunc_called(this, "_ZN7S1564C12v2Ev");}
void  S1564C1 ::v3(){vfunc_called(this, "_ZN7S1564C12v3Ev");}
void  S1564C1 ::v4(){vfunc_called(this, "_ZN7S1564C12v4Ev");}
void  S1564C1 ::v5(){vfunc_called(this, "_ZN7S1564C12v5Ev");}
void  S1564C1 ::v6(){vfunc_called(this, "_ZN7S1564C12v6Ev");}
void  S1564C1 ::v7(){vfunc_called(this, "_ZN7S1564C12v7Ev");}
S1564C1 ::S1564C1(){ note_ctor("S1564C1", this);} // tgen

static void Test_S1564C1()
{
  extern Class_Descriptor cd_S1564C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(87,143)];
    init_test(&cd_S1564C1, buf);
    S1564C1 *dp, &lv = *(dp=new (buf) S1564C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(688,568), "sizeof(S1564C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1564C1)");
    check_base_class_offset(lv, (S1564C4*)(S1564C3*)(S1564C2*), 0, "S1564C1");
    check_base_class_offset(lv, (S1564C3*)(S1564C2*), 0, "S1564C1");
    check_base_class_offset(lv, (S1564C13_nt*)(S1564C2*), ABISELECT(280,212), "S1564C1");
    check_base_class_offset(lv, (S1564C2*), 0, "S1564C1");
    check_field_offset(lv, s1564c1f0, ABISELECT(600,508), "S1564C1.s1564c1f0");
    check_field_offset(lv, s1564c1f1, ABISELECT(616,524), "S1564C1.s1564c1f1");
    check_field_offset(lv, s1564c1f2, ABISELECT(624,528), "S1564C1.s1564c1f2");
    check_field_offset(lv, s1564c1f3, ABISELECT(640,544), "S1564C1.s1564c1f3");
    check_field_offset(lv, s1564c1f4, ABISELECT(648,548), "S1564C1.s1564c1f4");
    check_field_offset(lv, s1564c1f5, ABISELECT(656,552), "S1564C1.s1564c1f5");
    check_field_offset(lv, s1564c1f6, ABISELECT(664,556), "S1564C1.s1564c1f6");
    check_field_offset(lv, s1564c1f7, ABISELECT(665,557), "S1564C1.s1564c1f7");
    check_field_offset(lv, s1564c1f8, ABISELECT(666,558), "S1564C1.s1564c1f8");
    check_field_offset(lv, s1564c1f9, ABISELECT(672,560), "S1564C1.s1564c1f9");
    check_field_offset(lv, s1564c1f10, ABISELECT(680,564), "S1564C1.s1564c1f10");
    test_class_info(&lv, &cd_S1564C1);
    dp->~S1564C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1564C1(Test_S1564C1, "S1564C1", ABISELECT(688,568));

#else // __cplusplus

extern void _ZN7S1564C1C1Ev();
extern void _ZN7S1564C1D1Ev();
Name_Map name_map_S1564C1[] = {
  NSPAIR(_ZN7S1564C1C1Ev),
  NSPAIR(_ZN7S1564C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1564C4;
extern VTBL_ENTRY _ZTI7S1564C4[];
extern  VTBL_ENTRY _ZTV7S1564C4[];
extern Class_Descriptor cd_S1564C3;
extern VTBL_ENTRY _ZTI7S1564C3[];
extern  VTBL_ENTRY _ZTV7S1564C3[];
extern Class_Descriptor cd_S1564C13_nt;
extern VTBL_ENTRY _ZTI11S1564C13_nt[];
extern  VTBL_ENTRY _ZTV11S1564C13_nt[];
extern Class_Descriptor cd_S1564C2;
extern VTBL_ENTRY _ZTI7S1564C2[];
extern  VTBL_ENTRY _ZTV7S1564C2[];
static Base_Class bases_S1564C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1564C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1564C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1564C13_nt,    ABISELECT(280,212), //bcp->offset
    65, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1564C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1564C1[];
extern void _ZN7S1564C1D1Ev();
extern void _ZN7S1564C1D0Ev();
extern void _ZN7S1564C42v8Ev();
extern void _ZN7S1564C42v9Ev();
extern void _ZN7S1564C43v10Ev();
extern void _ZN7S1564C43v11Ev();
extern void _ZN7S1564C43v12Ev();
extern void _ZN7S1564C43v13Ev();
extern void _ZN7S1564C43v14Ev();
extern void _ZN7S1564C43v15Ev();
extern void _ZN7S1564C43v16Ev();
extern void _ZN7S1564C43v17Ev();
extern void _ZN7S1564C43v18Ev();
extern void _ZN7S1564C43v19Ev();
extern void _ZN7S1564C43v20Ev();
extern void _ZN7S1564C43v21Ev();
extern void _ZN7S1564C43v22Ev();
extern void _ZN7S1564C33v23Ev();
extern void _ZN7S1564C33v24Ev();
extern void _ZN7S1564C33v25Ev();
extern void _ZN7S1564C33v26Ev();
extern void _ZN7S1564C33v27Ev();
extern void _ZN7S1564C33v28Ev();
extern void _ZN7S1564C33v29Ev();
extern void _ZN7S1564C33v30Ev();
extern void _ZN7S1564C33v31Ev();
extern void _ZN7S1564C33v32Ev();
extern void _ZN7S1564C33v33Ev();
extern void _ZN7S1564C33v34Ev();
extern void _ZN7S1564C33v35Ev();
extern void _ZN7S1564C33v36Ev();
extern void _ZN7S1564C33v37Ev();
extern void _ZN7S1564C23v44Ev();
extern void _ZN7S1564C23v45Ev();
extern void _ZN7S1564C23v46Ev();
extern void _ZN7S1564C23v47Ev();
extern void _ZN7S1564C23v48Ev();
extern void _ZN7S1564C23v49Ev();
extern void _ZN7S1564C23v50Ev();
extern void _ZN7S1564C23v51Ev();
extern void _ZN7S1564C23v52Ev();
extern void _ZN7S1564C23v53Ev();
extern void _ZN7S1564C23v54Ev();
extern void _ZN7S1564C23v55Ev();
extern void _ZN7S1564C23v56Ev();
extern void _ZN7S1564C23v57Ev();
extern void _ZN7S1564C23v58Ev();
extern void _ZN7S1564C23v59Ev();
extern void _ZN7S1564C23v60Ev();
extern void _ZN7S1564C23v61Ev();
extern void _ZN7S1564C23v62Ev();
extern void _ZN7S1564C23v63Ev();
extern void _ZN7S1564C23v64Ev();
extern void _ZN7S1564C23v65Ev();
extern void _ZN7S1564C23v66Ev();
extern void _ZN7S1564C23v67Ev();
extern void _ZN7S1564C12v1Ev();
extern void _ZN7S1564C12v2Ev();
extern void _ZN7S1564C12v3Ev();
extern void _ZN7S1564C12v4Ev();
extern void _ZN7S1564C12v5Ev();
extern void _ZN7S1564C12v6Ev();
extern void _ZN7S1564C12v7Ev();
extern void ABISELECT(_ZThn280_N7S1564C1D1Ev,_ZThn212_N7S1564C1D1Ev)();
extern void ABISELECT(_ZThn280_N7S1564C1D0Ev,_ZThn212_N7S1564C1D0Ev)();
extern void _ZN11S1564C13_nt3v38Ev();
extern void _ZN11S1564C13_nt3v39Ev();
extern void _ZN11S1564C13_nt3v40Ev();
extern void _ZN11S1564C13_nt3v41Ev();
extern void _ZN11S1564C13_nt3v42Ev();
extern void _ZN11S1564C13_nt3v43Ev();
static  VTBL_ENTRY vtc_S1564C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1564C1[0]),
  (VTBL_ENTRY)&_ZN7S1564C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1564C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1564C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1564C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1564C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v29Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v30Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v31Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v32Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v33Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v34Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v35Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v36Ev,
  (VTBL_ENTRY)&_ZN7S1564C33v37Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v44Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v45Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v46Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v47Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v48Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v49Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v50Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v51Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v52Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v53Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v54Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v55Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v56Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v57Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v58Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v59Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v60Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v61Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v62Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v63Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v64Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v65Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v66Ev,
  (VTBL_ENTRY)&_ZN7S1564C23v67Ev,
  (VTBL_ENTRY)&_ZN7S1564C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1564C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1564C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1564C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1564C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1564C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1564C12v7Ev,
  ABISELECT(-280,-212),
  (VTBL_ENTRY)&(_ZTI7S1564C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn280_N7S1564C1D1Ev,_ZThn212_N7S1564C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn280_N7S1564C1D0Ev,_ZThn212_N7S1564C1D0Ev),
  (VTBL_ENTRY)&_ZN11S1564C13_nt3v38Ev,
  (VTBL_ENTRY)&_ZN11S1564C13_nt3v39Ev,
  (VTBL_ENTRY)&_ZN11S1564C13_nt3v40Ev,
  (VTBL_ENTRY)&_ZN11S1564C13_nt3v41Ev,
  (VTBL_ENTRY)&_ZN11S1564C13_nt3v42Ev,
  (VTBL_ENTRY)&_ZN11S1564C13_nt3v43Ev,
};
extern VTBL_ENTRY _ZTI7S1564C1[];
extern  VTBL_ENTRY _ZTV7S1564C1[];
Class_Descriptor cd_S1564C1 = {  "S1564C1", // class name
  bases_S1564C1, 4,
  &(vtc_S1564C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(688,568), // object size
  NSPAIRA(_ZTI7S1564C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1564C1),75, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S87C7  {
  int s87c7f0;
  __tsi64 s87c7f1;
  void *s87c7f2[4];
  int s87c7f3[2];
  void *s87c7f4;
  ::S3352C4_nt s87c7f5;
  void *s87c7f6[2];
  virtual  ~S87C7(); // _ZN5S87C7D1Ev
  virtual void  v4(); // _ZN5S87C72v4Ev
  virtual void  v5(); // _ZN5S87C72v5Ev
  virtual void  v6(); // _ZN5S87C72v6Ev
  virtual void  v7(); // _ZN5S87C72v7Ev
  virtual void  v8(); // _ZN5S87C72v8Ev
  virtual void  v9(); // _ZN5S87C72v9Ev
  virtual void  v10(); // _ZN5S87C73v10Ev
  virtual void  v11(); // _ZN5S87C73v11Ev
  virtual void  v12(); // _ZN5S87C73v12Ev
  virtual void  v13(); // _ZN5S87C73v13Ev
  virtual void  v14(); // _ZN5S87C73v14Ev
  virtual void  v15(); // _ZN5S87C73v15Ev
  virtual void  v16(); // _ZN5S87C73v16Ev
  virtual void  v17(); // _ZN5S87C73v17Ev
  virtual void  v18(); // _ZN5S87C73v18Ev
  virtual void  v19(); // _ZN5S87C73v19Ev
  virtual void  v20(); // _ZN5S87C73v20Ev
  virtual void  v21(); // _ZN5S87C73v21Ev
  virtual void  v22(); // _ZN5S87C73v22Ev
  virtual void  v23(); // _ZN5S87C73v23Ev
  virtual void  v24(); // _ZN5S87C73v24Ev
  virtual void  v25(); // _ZN5S87C73v25Ev
  virtual void  v26(); // _ZN5S87C73v26Ev
  virtual void  v27(); // _ZN5S87C73v27Ev
  virtual void  v28(); // _ZN5S87C73v28Ev
  virtual void  v29(); // _ZN5S87C73v29Ev
  virtual void  v30(); // _ZN5S87C73v30Ev
  virtual void  v31(); // _ZN5S87C73v31Ev
  virtual void  v32(); // _ZN5S87C73v32Ev
  virtual void  v33(); // _ZN5S87C73v33Ev
  virtual void  v34(); // _ZN5S87C73v34Ev
  virtual void  v35(); // _ZN5S87C73v35Ev
  virtual void  v36(); // _ZN5S87C73v36Ev
  virtual void  v37(); // _ZN5S87C73v37Ev
  virtual void  v38(); // _ZN5S87C73v38Ev
  virtual void  v39(); // _ZN5S87C73v39Ev
  virtual void  v40(); // _ZN5S87C73v40Ev
  virtual void  v41(); // _ZN5S87C73v41Ev
  virtual void  v42(); // _ZN5S87C73v42Ev
  virtual void  v43(); // _ZN5S87C73v43Ev
  virtual void  v44(); // _ZN5S87C73v44Ev
  virtual void  v45(); // _ZN5S87C73v45Ev
  virtual void  v46(); // _ZN5S87C73v46Ev
  virtual void  v47(); // _ZN5S87C73v47Ev
  virtual void  v48(); // _ZN5S87C73v48Ev
  virtual void  v49(); // _ZN5S87C73v49Ev
  virtual void  v50(); // _ZN5S87C73v50Ev
  virtual void  v51(); // _ZN5S87C73v51Ev
  virtual void  v52(); // _ZN5S87C73v52Ev
  virtual void  v53(); // _ZN5S87C73v53Ev
  virtual void  v54(); // _ZN5S87C73v54Ev
  virtual void  v55(); // _ZN5S87C73v55Ev
  virtual void  v56(); // _ZN5S87C73v56Ev
  virtual void  v57(); // _ZN5S87C73v57Ev
  virtual void  v58(); // _ZN5S87C73v58Ev
  virtual void  v59(); // _ZN5S87C73v59Ev
  virtual void  v60(); // _ZN5S87C73v60Ev
  virtual void  v61(); // _ZN5S87C73v61Ev
  virtual void  v62(); // _ZN5S87C73v62Ev
  virtual void  v63(); // _ZN5S87C73v63Ev
  virtual void  v64(); // _ZN5S87C73v64Ev
  virtual void  v65(); // _ZN5S87C73v65Ev
  virtual void  v66(); // _ZN5S87C73v66Ev
  virtual void  v67(); // _ZN5S87C73v67Ev
  S87C7(); // tgen
};
//SIG(-1 S87C7) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S87C7 ::~S87C7(){ note_dtor("S87C7", this);}
void  S87C7 ::v4(){vfunc_called(this, "_ZN5S87C72v4Ev");}
void  S87C7 ::v5(){vfunc_called(this, "_ZN5S87C72v5Ev");}
void  S87C7 ::v6(){vfunc_called(this, "_ZN5S87C72v6Ev");}
void  S87C7 ::v7(){vfunc_called(this, "_ZN5S87C72v7Ev");}
void  S87C7 ::v8(){vfunc_called(this, "_ZN5S87C72v8Ev");}
void  S87C7 ::v9(){vfunc_called(this, "_ZN5S87C72v9Ev");}
void  S87C7 ::v10(){vfunc_called(this, "_ZN5S87C73v10Ev");}
void  S87C7 ::v11(){vfunc_called(this, "_ZN5S87C73v11Ev");}
void  S87C7 ::v12(){vfunc_called(this, "_ZN5S87C73v12Ev");}
void  S87C7 ::v13(){vfunc_called(this, "_ZN5S87C73v13Ev");}
void  S87C7 ::v14(){vfunc_called(this, "_ZN5S87C73v14Ev");}
void  S87C7 ::v15(){vfunc_called(this, "_ZN5S87C73v15Ev");}
void  S87C7 ::v16(){vfunc_called(this, "_ZN5S87C73v16Ev");}
void  S87C7 ::v17(){vfunc_called(this, "_ZN5S87C73v17Ev");}
void  S87C7 ::v18(){vfunc_called(this, "_ZN5S87C73v18Ev");}
void  S87C7 ::v19(){vfunc_called(this, "_ZN5S87C73v19Ev");}
void  S87C7 ::v20(){vfunc_called(this, "_ZN5S87C73v20Ev");}
void  S87C7 ::v21(){vfunc_called(this, "_ZN5S87C73v21Ev");}
void  S87C7 ::v22(){vfunc_called(this, "_ZN5S87C73v22Ev");}
void  S87C7 ::v23(){vfunc_called(this, "_ZN5S87C73v23Ev");}
void  S87C7 ::v24(){vfunc_called(this, "_ZN5S87C73v24Ev");}
void  S87C7 ::v25(){vfunc_called(this, "_ZN5S87C73v25Ev");}
void  S87C7 ::v26(){vfunc_called(this, "_ZN5S87C73v26Ev");}
void  S87C7 ::v27(){vfunc_called(this, "_ZN5S87C73v27Ev");}
void  S87C7 ::v28(){vfunc_called(this, "_ZN5S87C73v28Ev");}
void  S87C7 ::v29(){vfunc_called(this, "_ZN5S87C73v29Ev");}
void  S87C7 ::v30(){vfunc_called(this, "_ZN5S87C73v30Ev");}
void  S87C7 ::v31(){vfunc_called(this, "_ZN5S87C73v31Ev");}
void  S87C7 ::v32(){vfunc_called(this, "_ZN5S87C73v32Ev");}
void  S87C7 ::v33(){vfunc_called(this, "_ZN5S87C73v33Ev");}
void  S87C7 ::v34(){vfunc_called(this, "_ZN5S87C73v34Ev");}
void  S87C7 ::v35(){vfunc_called(this, "_ZN5S87C73v35Ev");}
void  S87C7 ::v36(){vfunc_called(this, "_ZN5S87C73v36Ev");}
void  S87C7 ::v37(){vfunc_called(this, "_ZN5S87C73v37Ev");}
void  S87C7 ::v38(){vfunc_called(this, "_ZN5S87C73v38Ev");}
void  S87C7 ::v39(){vfunc_called(this, "_ZN5S87C73v39Ev");}
void  S87C7 ::v40(){vfunc_called(this, "_ZN5S87C73v40Ev");}
void  S87C7 ::v41(){vfunc_called(this, "_ZN5S87C73v41Ev");}
void  S87C7 ::v42(){vfunc_called(this, "_ZN5S87C73v42Ev");}
void  S87C7 ::v43(){vfunc_called(this, "_ZN5S87C73v43Ev");}
void  S87C7 ::v44(){vfunc_called(this, "_ZN5S87C73v44Ev");}
void  S87C7 ::v45(){vfunc_called(this, "_ZN5S87C73v45Ev");}
void  S87C7 ::v46(){vfunc_called(this, "_ZN5S87C73v46Ev");}
void  S87C7 ::v47(){vfunc_called(this, "_ZN5S87C73v47Ev");}
void  S87C7 ::v48(){vfunc_called(this, "_ZN5S87C73v48Ev");}
void  S87C7 ::v49(){vfunc_called(this, "_ZN5S87C73v49Ev");}
void  S87C7 ::v50(){vfunc_called(this, "_ZN5S87C73v50Ev");}
void  S87C7 ::v51(){vfunc_called(this, "_ZN5S87C73v51Ev");}
void  S87C7 ::v52(){vfunc_called(this, "_ZN5S87C73v52Ev");}
void  S87C7 ::v53(){vfunc_called(this, "_ZN5S87C73v53Ev");}
void  S87C7 ::v54(){vfunc_called(this, "_ZN5S87C73v54Ev");}
void  S87C7 ::v55(){vfunc_called(this, "_ZN5S87C73v55Ev");}
void  S87C7 ::v56(){vfunc_called(this, "_ZN5S87C73v56Ev");}
void  S87C7 ::v57(){vfunc_called(this, "_ZN5S87C73v57Ev");}
void  S87C7 ::v58(){vfunc_called(this, "_ZN5S87C73v58Ev");}
void  S87C7 ::v59(){vfunc_called(this, "_ZN5S87C73v59Ev");}
void  S87C7 ::v60(){vfunc_called(this, "_ZN5S87C73v60Ev");}
void  S87C7 ::v61(){vfunc_called(this, "_ZN5S87C73v61Ev");}
void  S87C7 ::v62(){vfunc_called(this, "_ZN5S87C73v62Ev");}
void  S87C7 ::v63(){vfunc_called(this, "_ZN5S87C73v63Ev");}
void  S87C7 ::v64(){vfunc_called(this, "_ZN5S87C73v64Ev");}
void  S87C7 ::v65(){vfunc_called(this, "_ZN5S87C73v65Ev");}
void  S87C7 ::v66(){vfunc_called(this, "_ZN5S87C73v66Ev");}
void  S87C7 ::v67(){vfunc_called(this, "_ZN5S87C73v67Ev");}
S87C7 ::S87C7(){ note_ctor("S87C7", this);} // tgen

static void Test_S87C7()
{
  extern Class_Descriptor cd_S87C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S87C7, buf);
    S87C7 *dp, &lv = *(dp=new (buf) S87C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S87C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S87C7)");
    check_field_offset(lv, s87c7f0, ABISELECT(8,4), "S87C7.s87c7f0");
    check_field_offset(lv, s87c7f1, ABISELECT(16,8), "S87C7.s87c7f1");
    check_field_offset(lv, s87c7f2, ABISELECT(24,16), "S87C7.s87c7f2");
    check_field_offset(lv, s87c7f3, ABISELECT(56,32), "S87C7.s87c7f3");
    check_field_offset(lv, s87c7f4, ABISELECT(64,40), "S87C7.s87c7f4");
    check_field_offset(lv, s87c7f5, ABISELECT(72,44), "S87C7.s87c7f5");
    check_field_offset(lv, s87c7f6, ABISELECT(80,52), "S87C7.s87c7f6");
    test_class_info(&lv, &cd_S87C7);
    dp->~S87C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS87C7(Test_S87C7, "S87C7", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN5S87C7C1Ev();
extern void _ZN5S87C7D1Ev();
Name_Map name_map_S87C7[] = {
  NSPAIR(_ZN5S87C7C1Ev),
  NSPAIR(_ZN5S87C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI5S87C7[];
extern void _ZN5S87C7D1Ev();
extern void _ZN5S87C7D0Ev();
extern void _ZN5S87C72v4Ev();
extern void _ZN5S87C72v5Ev();
extern void _ZN5S87C72v6Ev();
extern void _ZN5S87C72v7Ev();
extern void _ZN5S87C72v8Ev();
extern void _ZN5S87C72v9Ev();
extern void _ZN5S87C73v10Ev();
extern void _ZN5S87C73v11Ev();
extern void _ZN5S87C73v12Ev();
extern void _ZN5S87C73v13Ev();
extern void _ZN5S87C73v14Ev();
extern void _ZN5S87C73v15Ev();
extern void _ZN5S87C73v16Ev();
extern void _ZN5S87C73v17Ev();
extern void _ZN5S87C73v18Ev();
extern void _ZN5S87C73v19Ev();
extern void _ZN5S87C73v20Ev();
extern void _ZN5S87C73v21Ev();
extern void _ZN5S87C73v22Ev();
extern void _ZN5S87C73v23Ev();
extern void _ZN5S87C73v24Ev();
extern void _ZN5S87C73v25Ev();
extern void _ZN5S87C73v26Ev();
extern void _ZN5S87C73v27Ev();
extern void _ZN5S87C73v28Ev();
extern void _ZN5S87C73v29Ev();
extern void _ZN5S87C73v30Ev();
extern void _ZN5S87C73v31Ev();
extern void _ZN5S87C73v32Ev();
extern void _ZN5S87C73v33Ev();
extern void _ZN5S87C73v34Ev();
extern void _ZN5S87C73v35Ev();
extern void _ZN5S87C73v36Ev();
extern void _ZN5S87C73v37Ev();
extern void _ZN5S87C73v38Ev();
extern void _ZN5S87C73v39Ev();
extern void _ZN5S87C73v40Ev();
extern void _ZN5S87C73v41Ev();
extern void _ZN5S87C73v42Ev();
extern void _ZN5S87C73v43Ev();
extern void _ZN5S87C73v44Ev();
extern void _ZN5S87C73v45Ev();
extern void _ZN5S87C73v46Ev();
extern void _ZN5S87C73v47Ev();
extern void _ZN5S87C73v48Ev();
extern void _ZN5S87C73v49Ev();
extern void _ZN5S87C73v50Ev();
extern void _ZN5S87C73v51Ev();
extern void _ZN5S87C73v52Ev();
extern void _ZN5S87C73v53Ev();
extern void _ZN5S87C73v54Ev();
extern void _ZN5S87C73v55Ev();
extern void _ZN5S87C73v56Ev();
extern void _ZN5S87C73v57Ev();
extern void _ZN5S87C73v58Ev();
extern void _ZN5S87C73v59Ev();
extern void _ZN5S87C73v60Ev();
extern void _ZN5S87C73v61Ev();
extern void _ZN5S87C73v62Ev();
extern void _ZN5S87C73v63Ev();
extern void _ZN5S87C73v64Ev();
extern void _ZN5S87C73v65Ev();
extern void _ZN5S87C73v66Ev();
extern void _ZN5S87C73v67Ev();
static  VTBL_ENTRY vtc_S87C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S87C7[0]),
  (VTBL_ENTRY)&_ZN5S87C7D1Ev,
  (VTBL_ENTRY)&_ZN5S87C7D0Ev,
  (VTBL_ENTRY)&_ZN5S87C72v4Ev,
  (VTBL_ENTRY)&_ZN5S87C72v5Ev,
  (VTBL_ENTRY)&_ZN5S87C72v6Ev,
  (VTBL_ENTRY)&_ZN5S87C72v7Ev,
  (VTBL_ENTRY)&_ZN5S87C72v8Ev,
  (VTBL_ENTRY)&_ZN5S87C72v9Ev,
  (VTBL_ENTRY)&_ZN5S87C73v10Ev,
  (VTBL_ENTRY)&_ZN5S87C73v11Ev,
  (VTBL_ENTRY)&_ZN5S87C73v12Ev,
  (VTBL_ENTRY)&_ZN5S87C73v13Ev,
  (VTBL_ENTRY)&_ZN5S87C73v14Ev,
  (VTBL_ENTRY)&_ZN5S87C73v15Ev,
  (VTBL_ENTRY)&_ZN5S87C73v16Ev,
  (VTBL_ENTRY)&_ZN5S87C73v17Ev,
  (VTBL_ENTRY)&_ZN5S87C73v18Ev,
  (VTBL_ENTRY)&_ZN5S87C73v19Ev,
  (VTBL_ENTRY)&_ZN5S87C73v20Ev,
  (VTBL_ENTRY)&_ZN5S87C73v21Ev,
  (VTBL_ENTRY)&_ZN5S87C73v22Ev,
  (VTBL_ENTRY)&_ZN5S87C73v23Ev,
  (VTBL_ENTRY)&_ZN5S87C73v24Ev,
  (VTBL_ENTRY)&_ZN5S87C73v25Ev,
  (VTBL_ENTRY)&_ZN5S87C73v26Ev,
  (VTBL_ENTRY)&_ZN5S87C73v27Ev,
  (VTBL_ENTRY)&_ZN5S87C73v28Ev,
  (VTBL_ENTRY)&_ZN5S87C73v29Ev,
  (VTBL_ENTRY)&_ZN5S87C73v30Ev,
  (VTBL_ENTRY)&_ZN5S87C73v31Ev,
  (VTBL_ENTRY)&_ZN5S87C73v32Ev,
  (VTBL_ENTRY)&_ZN5S87C73v33Ev,
  (VTBL_ENTRY)&_ZN5S87C73v34Ev,
  (VTBL_ENTRY)&_ZN5S87C73v35Ev,
  (VTBL_ENTRY)&_ZN5S87C73v36Ev,
  (VTBL_ENTRY)&_ZN5S87C73v37Ev,
  (VTBL_ENTRY)&_ZN5S87C73v38Ev,
  (VTBL_ENTRY)&_ZN5S87C73v39Ev,
  (VTBL_ENTRY)&_ZN5S87C73v40Ev,
  (VTBL_ENTRY)&_ZN5S87C73v41Ev,
  (VTBL_ENTRY)&_ZN5S87C73v42Ev,
  (VTBL_ENTRY)&_ZN5S87C73v43Ev,
  (VTBL_ENTRY)&_ZN5S87C73v44Ev,
  (VTBL_ENTRY)&_ZN5S87C73v45Ev,
  (VTBL_ENTRY)&_ZN5S87C73v46Ev,
  (VTBL_ENTRY)&_ZN5S87C73v47Ev,
  (VTBL_ENTRY)&_ZN5S87C73v48Ev,
  (VTBL_ENTRY)&_ZN5S87C73v49Ev,
  (VTBL_ENTRY)&_ZN5S87C73v50Ev,
  (VTBL_ENTRY)&_ZN5S87C73v51Ev,
  (VTBL_ENTRY)&_ZN5S87C73v52Ev,
  (VTBL_ENTRY)&_ZN5S87C73v53Ev,
  (VTBL_ENTRY)&_ZN5S87C73v54Ev,
  (VTBL_ENTRY)&_ZN5S87C73v55Ev,
  (VTBL_ENTRY)&_ZN5S87C73v56Ev,
  (VTBL_ENTRY)&_ZN5S87C73v57Ev,
  (VTBL_ENTRY)&_ZN5S87C73v58Ev,
  (VTBL_ENTRY)&_ZN5S87C73v59Ev,
  (VTBL_ENTRY)&_ZN5S87C73v60Ev,
  (VTBL_ENTRY)&_ZN5S87C73v61Ev,
  (VTBL_ENTRY)&_ZN5S87C73v62Ev,
  (VTBL_ENTRY)&_ZN5S87C73v63Ev,
  (VTBL_ENTRY)&_ZN5S87C73v64Ev,
  (VTBL_ENTRY)&_ZN5S87C73v65Ev,
  (VTBL_ENTRY)&_ZN5S87C73v66Ev,
  (VTBL_ENTRY)&_ZN5S87C73v67Ev,
};
extern VTBL_ENTRY _ZTI5S87C7[];
extern  VTBL_ENTRY _ZTV5S87C7[];
Class_Descriptor cd_S87C7 = {  "S87C7", // class name
  0,0,//no base classes
  &(vtc_S87C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI5S87C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV5S87C7),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S87C6_nt  : S87C7 {
  virtual  ~S87C6_nt(); // _ZN8S87C6_ntD1Ev
  virtual void  v68(); // _ZN8S87C6_nt3v68Ev
  virtual void  v69(); // _ZN8S87C6_nt3v69Ev
  S87C6_nt(); // tgen
};
//SIG(-1 S87C6_nt) C1{ BC2{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2}


 S87C6_nt ::~S87C6_nt(){ note_dtor("S87C6_nt", this);}
void  S87C6_nt ::v68(){vfunc_called(this, "_ZN8S87C6_nt3v68Ev");}
void  S87C6_nt ::v69(){vfunc_called(this, "_ZN8S87C6_nt3v69Ev");}
S87C6_nt ::S87C6_nt(){ note_ctor("S87C6_nt", this);} // tgen

//skip512 S87C6_nt

#else // __cplusplus

extern void _ZN8S87C6_ntC1Ev();
extern void _ZN8S87C6_ntD1Ev();
Name_Map name_map_S87C6_nt[] = {
  NSPAIR(_ZN8S87C6_ntC1Ev),
  NSPAIR(_ZN8S87C6_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S87C7;
extern VTBL_ENTRY _ZTI5S87C7[];
extern  VTBL_ENTRY _ZTV5S87C7[];
static Base_Class bases_S87C6_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S87C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S87C6_nt[];
extern void _ZN8S87C6_ntD1Ev();
extern void _ZN8S87C6_ntD0Ev();
extern void _ZN5S87C72v4Ev();
extern void _ZN5S87C72v5Ev();
extern void _ZN5S87C72v6Ev();
extern void _ZN5S87C72v7Ev();
extern void _ZN5S87C72v8Ev();
extern void _ZN5S87C72v9Ev();
extern void _ZN5S87C73v10Ev();
extern void _ZN5S87C73v11Ev();
extern void _ZN5S87C73v12Ev();
extern void _ZN5S87C73v13Ev();
extern void _ZN5S87C73v14Ev();
extern void _ZN5S87C73v15Ev();
extern void _ZN5S87C73v16Ev();
extern void _ZN5S87C73v17Ev();
extern void _ZN5S87C73v18Ev();
extern void _ZN5S87C73v19Ev();
extern void _ZN5S87C73v20Ev();
extern void _ZN5S87C73v21Ev();
extern void _ZN5S87C73v22Ev();
extern void _ZN5S87C73v23Ev();
extern void _ZN5S87C73v24Ev();
extern void _ZN5S87C73v25Ev();
extern void _ZN5S87C73v26Ev();
extern void _ZN5S87C73v27Ev();
extern void _ZN5S87C73v28Ev();
extern void _ZN5S87C73v29Ev();
extern void _ZN5S87C73v30Ev();
extern void _ZN5S87C73v31Ev();
extern void _ZN5S87C73v32Ev();
extern void _ZN5S87C73v33Ev();
extern void _ZN5S87C73v34Ev();
extern void _ZN5S87C73v35Ev();
extern void _ZN5S87C73v36Ev();
extern void _ZN5S87C73v37Ev();
extern void _ZN5S87C73v38Ev();
extern void _ZN5S87C73v39Ev();
extern void _ZN5S87C73v40Ev();
extern void _ZN5S87C73v41Ev();
extern void _ZN5S87C73v42Ev();
extern void _ZN5S87C73v43Ev();
extern void _ZN5S87C73v44Ev();
extern void _ZN5S87C73v45Ev();
extern void _ZN5S87C73v46Ev();
extern void _ZN5S87C73v47Ev();
extern void _ZN5S87C73v48Ev();
extern void _ZN5S87C73v49Ev();
extern void _ZN5S87C73v50Ev();
extern void _ZN5S87C73v51Ev();
extern void _ZN5S87C73v52Ev();
extern void _ZN5S87C73v53Ev();
extern void _ZN5S87C73v54Ev();
extern void _ZN5S87C73v55Ev();
extern void _ZN5S87C73v56Ev();
extern void _ZN5S87C73v57Ev();
extern void _ZN5S87C73v58Ev();
extern void _ZN5S87C73v59Ev();
extern void _ZN5S87C73v60Ev();
extern void _ZN5S87C73v61Ev();
extern void _ZN5S87C73v62Ev();
extern void _ZN5S87C73v63Ev();
extern void _ZN5S87C73v64Ev();
extern void _ZN5S87C73v65Ev();
extern void _ZN5S87C73v66Ev();
extern void _ZN5S87C73v67Ev();
extern void _ZN8S87C6_nt3v68Ev();
extern void _ZN8S87C6_nt3v69Ev();
static  VTBL_ENTRY vtc_S87C6_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S87C6_nt[0]),
  (VTBL_ENTRY)&_ZN8S87C6_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S87C6_ntD0Ev,
  (VTBL_ENTRY)&_ZN5S87C72v4Ev,
  (VTBL_ENTRY)&_ZN5S87C72v5Ev,
  (VTBL_ENTRY)&_ZN5S87C72v6Ev,
  (VTBL_ENTRY)&_ZN5S87C72v7Ev,
  (VTBL_ENTRY)&_ZN5S87C72v8Ev,
  (VTBL_ENTRY)&_ZN5S87C72v9Ev,
  (VTBL_ENTRY)&_ZN5S87C73v10Ev,
  (VTBL_ENTRY)&_ZN5S87C73v11Ev,
  (VTBL_ENTRY)&_ZN5S87C73v12Ev,
  (VTBL_ENTRY)&_ZN5S87C73v13Ev,
  (VTBL_ENTRY)&_ZN5S87C73v14Ev,
  (VTBL_ENTRY)&_ZN5S87C73v15Ev,
  (VTBL_ENTRY)&_ZN5S87C73v16Ev,
  (VTBL_ENTRY)&_ZN5S87C73v17Ev,
  (VTBL_ENTRY)&_ZN5S87C73v18Ev,
  (VTBL_ENTRY)&_ZN5S87C73v19Ev,
  (VTBL_ENTRY)&_ZN5S87C73v20Ev,
  (VTBL_ENTRY)&_ZN5S87C73v21Ev,
  (VTBL_ENTRY)&_ZN5S87C73v22Ev,
  (VTBL_ENTRY)&_ZN5S87C73v23Ev,
  (VTBL_ENTRY)&_ZN5S87C73v24Ev,
  (VTBL_ENTRY)&_ZN5S87C73v25Ev,
  (VTBL_ENTRY)&_ZN5S87C73v26Ev,
  (VTBL_ENTRY)&_ZN5S87C73v27Ev,
  (VTBL_ENTRY)&_ZN5S87C73v28Ev,
  (VTBL_ENTRY)&_ZN5S87C73v29Ev,
  (VTBL_ENTRY)&_ZN5S87C73v30Ev,
  (VTBL_ENTRY)&_ZN5S87C73v31Ev,
  (VTBL_ENTRY)&_ZN5S87C73v32Ev,
  (VTBL_ENTRY)&_ZN5S87C73v33Ev,
  (VTBL_ENTRY)&_ZN5S87C73v34Ev,
  (VTBL_ENTRY)&_ZN5S87C73v35Ev,
  (VTBL_ENTRY)&_ZN5S87C73v36Ev,
  (VTBL_ENTRY)&_ZN5S87C73v37Ev,
  (VTBL_ENTRY)&_ZN5S87C73v38Ev,
  (VTBL_ENTRY)&_ZN5S87C73v39Ev,
  (VTBL_ENTRY)&_ZN5S87C73v40Ev,
  (VTBL_ENTRY)&_ZN5S87C73v41Ev,
  (VTBL_ENTRY)&_ZN5S87C73v42Ev,
  (VTBL_ENTRY)&_ZN5S87C73v43Ev,
  (VTBL_ENTRY)&_ZN5S87C73v44Ev,
  (VTBL_ENTRY)&_ZN5S87C73v45Ev,
  (VTBL_ENTRY)&_ZN5S87C73v46Ev,
  (VTBL_ENTRY)&_ZN5S87C73v47Ev,
  (VTBL_ENTRY)&_ZN5S87C73v48Ev,
  (VTBL_ENTRY)&_ZN5S87C73v49Ev,
  (VTBL_ENTRY)&_ZN5S87C73v50Ev,
  (VTBL_ENTRY)&_ZN5S87C73v51Ev,
  (VTBL_ENTRY)&_ZN5S87C73v52Ev,
  (VTBL_ENTRY)&_ZN5S87C73v53Ev,
  (VTBL_ENTRY)&_ZN5S87C73v54Ev,
  (VTBL_ENTRY)&_ZN5S87C73v55Ev,
  (VTBL_ENTRY)&_ZN5S87C73v56Ev,
  (VTBL_ENTRY)&_ZN5S87C73v57Ev,
  (VTBL_ENTRY)&_ZN5S87C73v58Ev,
  (VTBL_ENTRY)&_ZN5S87C73v59Ev,
  (VTBL_ENTRY)&_ZN5S87C73v60Ev,
  (VTBL_ENTRY)&_ZN5S87C73v61Ev,
  (VTBL_ENTRY)&_ZN5S87C73v62Ev,
  (VTBL_ENTRY)&_ZN5S87C73v63Ev,
  (VTBL_ENTRY)&_ZN5S87C73v64Ev,
  (VTBL_ENTRY)&_ZN5S87C73v65Ev,
  (VTBL_ENTRY)&_ZN5S87C73v66Ev,
  (VTBL_ENTRY)&_ZN5S87C73v67Ev,
  (VTBL_ENTRY)&_ZN8S87C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S87C6_nt3v69Ev,
};
extern VTBL_ENTRY _ZTI8S87C6_nt[];
VTBL_ENTRY *P__ZTI8S87C6_nt = _ZTI8S87C6_nt; 
extern  VTBL_ENTRY _ZTV8S87C6_nt[];
Class_Descriptor cd_S87C6_nt = {  "S87C6_nt", // class name
  bases_S87C6_nt, 1,
  &(vtc_S87C6_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI8S87C6_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S87C6_nt),70, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S87C12_nt  {
  void *s87c12f0;
  ::S3352C4_nt s87c12f1;
  void  mf87c12(); // _ZN9S87C12_nt7mf87c12Ev
};
//SIG(-1 S87C12_nt) C1{ m Fp FC2{ m Fi[2]}}


void  S87C12_nt ::mf87c12(){}

//skip512 S87C12_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S87C5_nt  : S87C6_nt {
  char s87c5f0;
  ::S3352C17 s87c5f1;
  ::S87C12_nt s87c5f2;
  virtual  ~S87C5_nt(); // _ZN8S87C5_ntD1Ev
  virtual void  v70(); // _ZN8S87C5_nt3v70Ev
  virtual void  v71(); // _ZN8S87C5_nt3v71Ev
  virtual void  v72(); // _ZN8S87C5_nt3v72Ev
  virtual void  v73(); // _ZN8S87C5_nt3v73Ev
  virtual void  v74(); // _ZN8S87C5_nt3v74Ev
  virtual void  v75(); // _ZN8S87C5_nt3v75Ev
  virtual void  v76(); // _ZN8S87C5_nt3v76Ev
  virtual void  v77(); // _ZN8S87C5_nt3v77Ev
  virtual void  v78(); // _ZN8S87C5_nt3v78Ev
  virtual void  v79(); // _ZN8S87C5_nt3v79Ev
  virtual void  v80(); // _ZN8S87C5_nt3v80Ev
  virtual void  v81(); // _ZN8S87C5_nt3v81Ev
  S87C5_nt(); // tgen
};
//SIG(-1 S87C5_nt) C1{ BC2{ BC3{ vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v77 v78} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fc FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC8{ m Fp FC4}}


 S87C5_nt ::~S87C5_nt(){ note_dtor("S87C5_nt", this);}
void  S87C5_nt ::v70(){vfunc_called(this, "_ZN8S87C5_nt3v70Ev");}
void  S87C5_nt ::v71(){vfunc_called(this, "_ZN8S87C5_nt3v71Ev");}
void  S87C5_nt ::v72(){vfunc_called(this, "_ZN8S87C5_nt3v72Ev");}
void  S87C5_nt ::v73(){vfunc_called(this, "_ZN8S87C5_nt3v73Ev");}
void  S87C5_nt ::v74(){vfunc_called(this, "_ZN8S87C5_nt3v74Ev");}
void  S87C5_nt ::v75(){vfunc_called(this, "_ZN8S87C5_nt3v75Ev");}
void  S87C5_nt ::v76(){vfunc_called(this, "_ZN8S87C5_nt3v76Ev");}
void  S87C5_nt ::v77(){vfunc_called(this, "_ZN8S87C5_nt3v77Ev");}
void  S87C5_nt ::v78(){vfunc_called(this, "_ZN8S87C5_nt3v78Ev");}
void  S87C5_nt ::v79(){vfunc_called(this, "_ZN8S87C5_nt3v79Ev");}
void  S87C5_nt ::v80(){vfunc_called(this, "_ZN8S87C5_nt3v80Ev");}
void  S87C5_nt ::v81(){vfunc_called(this, "_ZN8S87C5_nt3v81Ev");}
S87C5_nt ::S87C5_nt(){ note_ctor("S87C5_nt", this);} // tgen

//skip512 S87C5_nt

#else // __cplusplus

extern void _ZN8S87C5_ntC1Ev();
extern void _ZN8S87C5_ntD1Ev();
Name_Map name_map_S87C5_nt[] = {
  NSPAIR(_ZN8S87C5_ntC1Ev),
  NSPAIR(_ZN8S87C5_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S87C7;
extern VTBL_ENTRY _ZTI5S87C7[];
extern  VTBL_ENTRY _ZTV5S87C7[];
extern Class_Descriptor cd_S87C6_nt;
extern VTBL_ENTRY _ZTI8S87C6_nt[];
extern  VTBL_ENTRY _ZTV8S87C6_nt[];
static Base_Class bases_S87C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S87C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S87C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S87C5_nt[];
extern void _ZN8S87C5_ntD1Ev();
extern void _ZN8S87C5_ntD0Ev();
extern void _ZN5S87C72v4Ev();
extern void _ZN5S87C72v5Ev();
extern void _ZN5S87C72v6Ev();
extern void _ZN5S87C72v7Ev();
extern void _ZN5S87C72v8Ev();
extern void _ZN5S87C72v9Ev();
extern void _ZN5S87C73v10Ev();
extern void _ZN5S87C73v11Ev();
extern void _ZN5S87C73v12Ev();
extern void _ZN5S87C73v13Ev();
extern void _ZN5S87C73v14Ev();
extern void _ZN5S87C73v15Ev();
extern void _ZN5S87C73v16Ev();
extern void _ZN5S87C73v17Ev();
extern void _ZN5S87C73v18Ev();
extern void _ZN5S87C73v19Ev();
extern void _ZN5S87C73v20Ev();
extern void _ZN5S87C73v21Ev();
extern void _ZN5S87C73v22Ev();
extern void _ZN5S87C73v23Ev();
extern void _ZN5S87C73v24Ev();
extern void _ZN5S87C73v25Ev();
extern void _ZN5S87C73v26Ev();
extern void _ZN5S87C73v27Ev();
extern void _ZN5S87C73v28Ev();
extern void _ZN5S87C73v29Ev();
extern void _ZN5S87C73v30Ev();
extern void _ZN5S87C73v31Ev();
extern void _ZN5S87C73v32Ev();
extern void _ZN5S87C73v33Ev();
extern void _ZN5S87C73v34Ev();
extern void _ZN5S87C73v35Ev();
extern void _ZN5S87C73v36Ev();
extern void _ZN5S87C73v37Ev();
extern void _ZN5S87C73v38Ev();
extern void _ZN5S87C73v39Ev();
extern void _ZN5S87C73v40Ev();
extern void _ZN5S87C73v41Ev();
extern void _ZN5S87C73v42Ev();
extern void _ZN5S87C73v43Ev();
extern void _ZN5S87C73v44Ev();
extern void _ZN5S87C73v45Ev();
extern void _ZN5S87C73v46Ev();
extern void _ZN5S87C73v47Ev();
extern void _ZN5S87C73v48Ev();
extern void _ZN5S87C73v49Ev();
extern void _ZN5S87C73v50Ev();
extern void _ZN5S87C73v51Ev();
extern void _ZN5S87C73v52Ev();
extern void _ZN5S87C73v53Ev();
extern void _ZN5S87C73v54Ev();
extern void _ZN5S87C73v55Ev();
extern void _ZN5S87C73v56Ev();
extern void _ZN5S87C73v57Ev();
extern void _ZN5S87C73v58Ev();
extern void _ZN5S87C73v59Ev();
extern void _ZN5S87C73v60Ev();
extern void _ZN5S87C73v61Ev();
extern void _ZN5S87C73v62Ev();
extern void _ZN5S87C73v63Ev();
extern void _ZN5S87C73v64Ev();
extern void _ZN5S87C73v65Ev();
extern void _ZN5S87C73v66Ev();
extern void _ZN5S87C73v67Ev();
extern void _ZN8S87C6_nt3v68Ev();
extern void _ZN8S87C6_nt3v69Ev();
extern void _ZN8S87C5_nt3v70Ev();
extern void _ZN8S87C5_nt3v71Ev();
extern void _ZN8S87C5_nt3v72Ev();
extern void _ZN8S87C5_nt3v73Ev();
extern void _ZN8S87C5_nt3v74Ev();
extern void _ZN8S87C5_nt3v75Ev();
extern void _ZN8S87C5_nt3v76Ev();
extern void _ZN8S87C5_nt3v77Ev();
extern void _ZN8S87C5_nt3v78Ev();
extern void _ZN8S87C5_nt3v79Ev();
extern void _ZN8S87C5_nt3v80Ev();
extern void _ZN8S87C5_nt3v81Ev();
static  VTBL_ENTRY vtc_S87C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S87C5_nt[0]),
  (VTBL_ENTRY)&_ZN8S87C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S87C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN5S87C72v4Ev,
  (VTBL_ENTRY)&_ZN5S87C72v5Ev,
  (VTBL_ENTRY)&_ZN5S87C72v6Ev,
  (VTBL_ENTRY)&_ZN5S87C72v7Ev,
  (VTBL_ENTRY)&_ZN5S87C72v8Ev,
  (VTBL_ENTRY)&_ZN5S87C72v9Ev,
  (VTBL_ENTRY)&_ZN5S87C73v10Ev,
  (VTBL_ENTRY)&_ZN5S87C73v11Ev,
  (VTBL_ENTRY)&_ZN5S87C73v12Ev,
  (VTBL_ENTRY)&_ZN5S87C73v13Ev,
  (VTBL_ENTRY)&_ZN5S87C73v14Ev,
  (VTBL_ENTRY)&_ZN5S87C73v15Ev,
  (VTBL_ENTRY)&_ZN5S87C73v16Ev,
  (VTBL_ENTRY)&_ZN5S87C73v17Ev,
  (VTBL_ENTRY)&_ZN5S87C73v18Ev,
  (VTBL_ENTRY)&_ZN5S87C73v19Ev,
  (VTBL_ENTRY)&_ZN5S87C73v20Ev,
  (VTBL_ENTRY)&_ZN5S87C73v21Ev,
  (VTBL_ENTRY)&_ZN5S87C73v22Ev,
  (VTBL_ENTRY)&_ZN5S87C73v23Ev,
  (VTBL_ENTRY)&_ZN5S87C73v24Ev,
  (VTBL_ENTRY)&_ZN5S87C73v25Ev,
  (VTBL_ENTRY)&_ZN5S87C73v26Ev,
  (VTBL_ENTRY)&_ZN5S87C73v27Ev,
  (VTBL_ENTRY)&_ZN5S87C73v28Ev,
  (VTBL_ENTRY)&_ZN5S87C73v29Ev,
  (VTBL_ENTRY)&_ZN5S87C73v30Ev,
  (VTBL_ENTRY)&_ZN5S87C73v31Ev,
  (VTBL_ENTRY)&_ZN5S87C73v32Ev,
  (VTBL_ENTRY)&_ZN5S87C73v33Ev,
  (VTBL_ENTRY)&_ZN5S87C73v34Ev,
  (VTBL_ENTRY)&_ZN5S87C73v35Ev,
  (VTBL_ENTRY)&_ZN5S87C73v36Ev,
  (VTBL_ENTRY)&_ZN5S87C73v37Ev,
  (VTBL_ENTRY)&_ZN5S87C73v38Ev,
  (VTBL_ENTRY)&_ZN5S87C73v39Ev,
  (VTBL_ENTRY)&_ZN5S87C73v40Ev,
  (VTBL_ENTRY)&_ZN5S87C73v41Ev,
  (VTBL_ENTRY)&_ZN5S87C73v42Ev,
  (VTBL_ENTRY)&_ZN5S87C73v43Ev,
  (VTBL_ENTRY)&_ZN5S87C73v44Ev,
  (VTBL_ENTRY)&_ZN5S87C73v45Ev,
  (VTBL_ENTRY)&_ZN5S87C73v46Ev,
  (VTBL_ENTRY)&_ZN5S87C73v47Ev,
  (VTBL_ENTRY)&_ZN5S87C73v48Ev,
  (VTBL_ENTRY)&_ZN5S87C73v49Ev,
  (VTBL_ENTRY)&_ZN5S87C73v50Ev,
  (VTBL_ENTRY)&_ZN5S87C73v51Ev,
  (VTBL_ENTRY)&_ZN5S87C73v52Ev,
  (VTBL_ENTRY)&_ZN5S87C73v53Ev,
  (VTBL_ENTRY)&_ZN5S87C73v54Ev,
  (VTBL_ENTRY)&_ZN5S87C73v55Ev,
  (VTBL_ENTRY)&_ZN5S87C73v56Ev,
  (VTBL_ENTRY)&_ZN5S87C73v57Ev,
  (VTBL_ENTRY)&_ZN5S87C73v58Ev,
  (VTBL_ENTRY)&_ZN5S87C73v59Ev,
  (VTBL_ENTRY)&_ZN5S87C73v60Ev,
  (VTBL_ENTRY)&_ZN5S87C73v61Ev,
  (VTBL_ENTRY)&_ZN5S87C73v62Ev,
  (VTBL_ENTRY)&_ZN5S87C73v63Ev,
  (VTBL_ENTRY)&_ZN5S87C73v64Ev,
  (VTBL_ENTRY)&_ZN5S87C73v65Ev,
  (VTBL_ENTRY)&_ZN5S87C73v66Ev,
  (VTBL_ENTRY)&_ZN5S87C73v67Ev,
  (VTBL_ENTRY)&_ZN8S87C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S87C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v81Ev,
};
extern VTBL_ENTRY _ZTI8S87C5_nt[];
VTBL_ENTRY *P__ZTI8S87C5_nt = _ZTI8S87C5_nt; 
extern  VTBL_ENTRY _ZTV8S87C5_nt[];
Class_Descriptor cd_S87C5_nt = {  "S87C5_nt", // class name
  bases_S87C5_nt, 2,
  &(vtc_S87C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,88), // object size
  NSPAIRA(_ZTI8S87C5_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S87C5_nt),82, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S87C13_nt  {
  virtual  ~S87C13_nt(); // _ZN9S87C13_ntD1Ev
  virtual void  v82(); // _ZN9S87C13_nt3v82Ev
  virtual void  v83(); // _ZN9S87C13_nt3v83Ev
  virtual void  v84(); // _ZN9S87C13_nt3v84Ev
  virtual void  v85(); // _ZN9S87C13_nt3v85Ev
  S87C13_nt(); // tgen
};
//SIG(-1 S87C13_nt) C1{ vd v1 v2 v3 v4}


 S87C13_nt ::~S87C13_nt(){ note_dtor("S87C13_nt", this);}
void  S87C13_nt ::v82(){vfunc_called(this, "_ZN9S87C13_nt3v82Ev");}
void  S87C13_nt ::v83(){vfunc_called(this, "_ZN9S87C13_nt3v83Ev");}
void  S87C13_nt ::v84(){vfunc_called(this, "_ZN9S87C13_nt3v84Ev");}
void  S87C13_nt ::v85(){vfunc_called(this, "_ZN9S87C13_nt3v85Ev");}
S87C13_nt ::S87C13_nt(){ note_ctor("S87C13_nt", this);} // tgen

//skip512 S87C13_nt

#else // __cplusplus

extern void _ZN9S87C13_ntC1Ev();
extern void _ZN9S87C13_ntD1Ev();
Name_Map name_map_S87C13_nt[] = {
  NSPAIR(_ZN9S87C13_ntC1Ev),
  NSPAIR(_ZN9S87C13_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S87C13_nt[];
extern void _ZN9S87C13_ntD1Ev();
extern void _ZN9S87C13_ntD0Ev();
extern void _ZN9S87C13_nt3v82Ev();
extern void _ZN9S87C13_nt3v83Ev();
extern void _ZN9S87C13_nt3v84Ev();
extern void _ZN9S87C13_nt3v85Ev();
static  VTBL_ENTRY vtc_S87C13_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S87C13_nt[0]),
  (VTBL_ENTRY)&_ZN9S87C13_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S87C13_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S87C13_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S87C13_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S87C13_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S87C13_nt3v85Ev,
};
extern VTBL_ENTRY _ZTI9S87C13_nt[];
VTBL_ENTRY *P__ZTI9S87C13_nt = _ZTI9S87C13_nt; 
extern  VTBL_ENTRY _ZTV9S87C13_nt[];
Class_Descriptor cd_S87C13_nt = {  "S87C13_nt", // class name
  0,0,//no base classes
  &(vtc_S87C13_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S87C13_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S87C13_nt),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S87C4  : S87C5_nt , S87C13_nt {
  virtual  ~S87C4(); // _ZN5S87C4D1Ev
  virtual void  v86(); // _ZN5S87C43v86Ev
  virtual void  v87(); // _ZN5S87C43v87Ev
  virtual void  v88(); // _ZN5S87C43v88Ev
  virtual void  v89(); // _ZN5S87C43v89Ev
  virtual void  v90(); // _ZN5S87C43v90Ev
  virtual void  v91(); // _ZN5S87C43v91Ev
  virtual void  v92(); // _ZN5S87C43v92Ev
  virtual void  v93(); // _ZN5S87C43v93Ev
  virtual void  v94(); // _ZN5S87C43v94Ev
  virtual void  v95(); // _ZN5S87C43v95Ev
  S87C4(); // tgen
};
//SIG(-1 S87C4) C1{ BC2{ BC3{ BC4{ vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v75 v76} vd v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fc FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC9{ m Fp FC5}} BC10{ vd v89 v90 v91 v92} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10}


 S87C4 ::~S87C4(){ note_dtor("S87C4", this);}
void  S87C4 ::v86(){vfunc_called(this, "_ZN5S87C43v86Ev");}
void  S87C4 ::v87(){vfunc_called(this, "_ZN5S87C43v87Ev");}
void  S87C4 ::v88(){vfunc_called(this, "_ZN5S87C43v88Ev");}
void  S87C4 ::v89(){vfunc_called(this, "_ZN5S87C43v89Ev");}
void  S87C4 ::v90(){vfunc_called(this, "_ZN5S87C43v90Ev");}
void  S87C4 ::v91(){vfunc_called(this, "_ZN5S87C43v91Ev");}
void  S87C4 ::v92(){vfunc_called(this, "_ZN5S87C43v92Ev");}
void  S87C4 ::v93(){vfunc_called(this, "_ZN5S87C43v93Ev");}
void  S87C4 ::v94(){vfunc_called(this, "_ZN5S87C43v94Ev");}
void  S87C4 ::v95(){vfunc_called(this, "_ZN5S87C43v95Ev");}
S87C4 ::S87C4(){ note_ctor("S87C4", this);} // tgen

static void Test_S87C4()
{
  extern Class_Descriptor cd_S87C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,24)];
    init_test(&cd_S87C4, buf);
    S87C4 *dp, &lv = *(dp=new (buf) S87C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,92), "sizeof(S87C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S87C4)");
    check_base_class_offset(lv, (S87C7*)(S87C6_nt*)(S87C5_nt*), 0, "S87C4");
    check_base_class_offset(lv, (S87C6_nt*)(S87C5_nt*), 0, "S87C4");
    check_base_class_offset(lv, (S87C5_nt*), 0, "S87C4");
    check_base_class_offset(lv, (S87C13_nt*), ABISELECT(136,88), "S87C4");
    test_class_info(&lv, &cd_S87C4);
    dp->~S87C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS87C4(Test_S87C4, "S87C4", ABISELECT(144,92));

#else // __cplusplus

extern void _ZN5S87C4C1Ev();
extern void _ZN5S87C4D1Ev();
Name_Map name_map_S87C4[] = {
  NSPAIR(_ZN5S87C4C1Ev),
  NSPAIR(_ZN5S87C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S87C7;
extern VTBL_ENTRY _ZTI5S87C7[];
extern  VTBL_ENTRY _ZTV5S87C7[];
extern Class_Descriptor cd_S87C6_nt;
extern VTBL_ENTRY _ZTI8S87C6_nt[];
extern  VTBL_ENTRY _ZTV8S87C6_nt[];
extern Class_Descriptor cd_S87C5_nt;
extern VTBL_ENTRY _ZTI8S87C5_nt[];
extern  VTBL_ENTRY _ZTV8S87C5_nt[];
extern Class_Descriptor cd_S87C13_nt;
extern VTBL_ENTRY _ZTI9S87C13_nt[];
extern  VTBL_ENTRY _ZTV9S87C13_nt[];
static Base_Class bases_S87C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S87C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S87C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S87C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S87C13_nt,    ABISELECT(136,88), //bcp->offset
    92, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S87C4[];
extern void _ZN5S87C4D1Ev();
extern void _ZN5S87C4D0Ev();
extern void _ZN5S87C72v4Ev();
extern void _ZN5S87C72v5Ev();
extern void _ZN5S87C72v6Ev();
extern void _ZN5S87C72v7Ev();
extern void _ZN5S87C72v8Ev();
extern void _ZN5S87C72v9Ev();
extern void _ZN5S87C73v10Ev();
extern void _ZN5S87C73v11Ev();
extern void _ZN5S87C73v12Ev();
extern void _ZN5S87C73v13Ev();
extern void _ZN5S87C73v14Ev();
extern void _ZN5S87C73v15Ev();
extern void _ZN5S87C73v16Ev();
extern void _ZN5S87C73v17Ev();
extern void _ZN5S87C73v18Ev();
extern void _ZN5S87C73v19Ev();
extern void _ZN5S87C73v20Ev();
extern void _ZN5S87C73v21Ev();
extern void _ZN5S87C73v22Ev();
extern void _ZN5S87C73v23Ev();
extern void _ZN5S87C73v24Ev();
extern void _ZN5S87C73v25Ev();
extern void _ZN5S87C73v26Ev();
extern void _ZN5S87C73v27Ev();
extern void _ZN5S87C73v28Ev();
extern void _ZN5S87C73v29Ev();
extern void _ZN5S87C73v30Ev();
extern void _ZN5S87C73v31Ev();
extern void _ZN5S87C73v32Ev();
extern void _ZN5S87C73v33Ev();
extern void _ZN5S87C73v34Ev();
extern void _ZN5S87C73v35Ev();
extern void _ZN5S87C73v36Ev();
extern void _ZN5S87C73v37Ev();
extern void _ZN5S87C73v38Ev();
extern void _ZN5S87C73v39Ev();
extern void _ZN5S87C73v40Ev();
extern void _ZN5S87C73v41Ev();
extern void _ZN5S87C73v42Ev();
extern void _ZN5S87C73v43Ev();
extern void _ZN5S87C73v44Ev();
extern void _ZN5S87C73v45Ev();
extern void _ZN5S87C73v46Ev();
extern void _ZN5S87C73v47Ev();
extern void _ZN5S87C73v48Ev();
extern void _ZN5S87C73v49Ev();
extern void _ZN5S87C73v50Ev();
extern void _ZN5S87C73v51Ev();
extern void _ZN5S87C73v52Ev();
extern void _ZN5S87C73v53Ev();
extern void _ZN5S87C73v54Ev();
extern void _ZN5S87C73v55Ev();
extern void _ZN5S87C73v56Ev();
extern void _ZN5S87C73v57Ev();
extern void _ZN5S87C73v58Ev();
extern void _ZN5S87C73v59Ev();
extern void _ZN5S87C73v60Ev();
extern void _ZN5S87C73v61Ev();
extern void _ZN5S87C73v62Ev();
extern void _ZN5S87C73v63Ev();
extern void _ZN5S87C73v64Ev();
extern void _ZN5S87C73v65Ev();
extern void _ZN5S87C73v66Ev();
extern void _ZN5S87C73v67Ev();
extern void _ZN8S87C6_nt3v68Ev();
extern void _ZN8S87C6_nt3v69Ev();
extern void _ZN8S87C5_nt3v70Ev();
extern void _ZN8S87C5_nt3v71Ev();
extern void _ZN8S87C5_nt3v72Ev();
extern void _ZN8S87C5_nt3v73Ev();
extern void _ZN8S87C5_nt3v74Ev();
extern void _ZN8S87C5_nt3v75Ev();
extern void _ZN8S87C5_nt3v76Ev();
extern void _ZN8S87C5_nt3v77Ev();
extern void _ZN8S87C5_nt3v78Ev();
extern void _ZN8S87C5_nt3v79Ev();
extern void _ZN8S87C5_nt3v80Ev();
extern void _ZN8S87C5_nt3v81Ev();
extern void _ZN5S87C43v86Ev();
extern void _ZN5S87C43v87Ev();
extern void _ZN5S87C43v88Ev();
extern void _ZN5S87C43v89Ev();
extern void _ZN5S87C43v90Ev();
extern void _ZN5S87C43v91Ev();
extern void _ZN5S87C43v92Ev();
extern void _ZN5S87C43v93Ev();
extern void _ZN5S87C43v94Ev();
extern void _ZN5S87C43v95Ev();
extern void ABISELECT(_ZThn136_N5S87C4D1Ev,_ZThn88_N5S87C4D1Ev)();
extern void ABISELECT(_ZThn136_N5S87C4D0Ev,_ZThn88_N5S87C4D0Ev)();
extern void _ZN9S87C13_nt3v82Ev();
extern void _ZN9S87C13_nt3v83Ev();
extern void _ZN9S87C13_nt3v84Ev();
extern void _ZN9S87C13_nt3v85Ev();
static  VTBL_ENTRY vtc_S87C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S87C4[0]),
  (VTBL_ENTRY)&_ZN5S87C4D1Ev,
  (VTBL_ENTRY)&_ZN5S87C4D0Ev,
  (VTBL_ENTRY)&_ZN5S87C72v4Ev,
  (VTBL_ENTRY)&_ZN5S87C72v5Ev,
  (VTBL_ENTRY)&_ZN5S87C72v6Ev,
  (VTBL_ENTRY)&_ZN5S87C72v7Ev,
  (VTBL_ENTRY)&_ZN5S87C72v8Ev,
  (VTBL_ENTRY)&_ZN5S87C72v9Ev,
  (VTBL_ENTRY)&_ZN5S87C73v10Ev,
  (VTBL_ENTRY)&_ZN5S87C73v11Ev,
  (VTBL_ENTRY)&_ZN5S87C73v12Ev,
  (VTBL_ENTRY)&_ZN5S87C73v13Ev,
  (VTBL_ENTRY)&_ZN5S87C73v14Ev,
  (VTBL_ENTRY)&_ZN5S87C73v15Ev,
  (VTBL_ENTRY)&_ZN5S87C73v16Ev,
  (VTBL_ENTRY)&_ZN5S87C73v17Ev,
  (VTBL_ENTRY)&_ZN5S87C73v18Ev,
  (VTBL_ENTRY)&_ZN5S87C73v19Ev,
  (VTBL_ENTRY)&_ZN5S87C73v20Ev,
  (VTBL_ENTRY)&_ZN5S87C73v21Ev,
  (VTBL_ENTRY)&_ZN5S87C73v22Ev,
  (VTBL_ENTRY)&_ZN5S87C73v23Ev,
  (VTBL_ENTRY)&_ZN5S87C73v24Ev,
  (VTBL_ENTRY)&_ZN5S87C73v25Ev,
  (VTBL_ENTRY)&_ZN5S87C73v26Ev,
  (VTBL_ENTRY)&_ZN5S87C73v27Ev,
  (VTBL_ENTRY)&_ZN5S87C73v28Ev,
  (VTBL_ENTRY)&_ZN5S87C73v29Ev,
  (VTBL_ENTRY)&_ZN5S87C73v30Ev,
  (VTBL_ENTRY)&_ZN5S87C73v31Ev,
  (VTBL_ENTRY)&_ZN5S87C73v32Ev,
  (VTBL_ENTRY)&_ZN5S87C73v33Ev,
  (VTBL_ENTRY)&_ZN5S87C73v34Ev,
  (VTBL_ENTRY)&_ZN5S87C73v35Ev,
  (VTBL_ENTRY)&_ZN5S87C73v36Ev,
  (VTBL_ENTRY)&_ZN5S87C73v37Ev,
  (VTBL_ENTRY)&_ZN5S87C73v38Ev,
  (VTBL_ENTRY)&_ZN5S87C73v39Ev,
  (VTBL_ENTRY)&_ZN5S87C73v40Ev,
  (VTBL_ENTRY)&_ZN5S87C73v41Ev,
  (VTBL_ENTRY)&_ZN5S87C73v42Ev,
  (VTBL_ENTRY)&_ZN5S87C73v43Ev,
  (VTBL_ENTRY)&_ZN5S87C73v44Ev,
  (VTBL_ENTRY)&_ZN5S87C73v45Ev,
  (VTBL_ENTRY)&_ZN5S87C73v46Ev,
  (VTBL_ENTRY)&_ZN5S87C73v47Ev,
  (VTBL_ENTRY)&_ZN5S87C73v48Ev,
  (VTBL_ENTRY)&_ZN5S87C73v49Ev,
  (VTBL_ENTRY)&_ZN5S87C73v50Ev,
  (VTBL_ENTRY)&_ZN5S87C73v51Ev,
  (VTBL_ENTRY)&_ZN5S87C73v52Ev,
  (VTBL_ENTRY)&_ZN5S87C73v53Ev,
  (VTBL_ENTRY)&_ZN5S87C73v54Ev,
  (VTBL_ENTRY)&_ZN5S87C73v55Ev,
  (VTBL_ENTRY)&_ZN5S87C73v56Ev,
  (VTBL_ENTRY)&_ZN5S87C73v57Ev,
  (VTBL_ENTRY)&_ZN5S87C73v58Ev,
  (VTBL_ENTRY)&_ZN5S87C73v59Ev,
  (VTBL_ENTRY)&_ZN5S87C73v60Ev,
  (VTBL_ENTRY)&_ZN5S87C73v61Ev,
  (VTBL_ENTRY)&_ZN5S87C73v62Ev,
  (VTBL_ENTRY)&_ZN5S87C73v63Ev,
  (VTBL_ENTRY)&_ZN5S87C73v64Ev,
  (VTBL_ENTRY)&_ZN5S87C73v65Ev,
  (VTBL_ENTRY)&_ZN5S87C73v66Ev,
  (VTBL_ENTRY)&_ZN5S87C73v67Ev,
  (VTBL_ENTRY)&_ZN8S87C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S87C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN5S87C43v86Ev,
  (VTBL_ENTRY)&_ZN5S87C43v87Ev,
  (VTBL_ENTRY)&_ZN5S87C43v88Ev,
  (VTBL_ENTRY)&_ZN5S87C43v89Ev,
  (VTBL_ENTRY)&_ZN5S87C43v90Ev,
  (VTBL_ENTRY)&_ZN5S87C43v91Ev,
  (VTBL_ENTRY)&_ZN5S87C43v92Ev,
  (VTBL_ENTRY)&_ZN5S87C43v93Ev,
  (VTBL_ENTRY)&_ZN5S87C43v94Ev,
  (VTBL_ENTRY)&_ZN5S87C43v95Ev,
  ABISELECT(-136,-88),
  (VTBL_ENTRY)&(_ZTI5S87C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn136_N5S87C4D1Ev,_ZThn88_N5S87C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn136_N5S87C4D0Ev,_ZThn88_N5S87C4D0Ev),
  (VTBL_ENTRY)&_ZN9S87C13_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S87C13_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S87C13_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S87C13_nt3v85Ev,
};
extern VTBL_ENTRY _ZTI5S87C4[];
extern  VTBL_ENTRY _ZTV5S87C4[];
Class_Descriptor cd_S87C4 = {  "S87C4", // class name
  bases_S87C4, 4,
  &(vtc_S87C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,92), // object size
  NSPAIRA(_ZTI5S87C4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5S87C4),100, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S87C3  : S87C4 {
  void *s87c3f0;
  virtual  ~S87C3(); // _ZN5S87C3D1Ev
  virtual void  v96(); // _ZN5S87C33v96Ev
  virtual void  v97(); // _ZN5S87C33v97Ev
  virtual void  v98(); // _ZN5S87C33v98Ev
  virtual void  v99(); // _ZN5S87C33v99Ev
  virtual void  v100(); // _ZN5S87C34v100Ev
  virtual void  v101(); // _ZN5S87C34v101Ev
  S87C3(); // tgen
};
//SIG(-1 S87C3) C1{ BC2{ BC3{ BC4{ BC5{ vd v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v71 v72} vd v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fc FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC10{ m Fp FC6}} BC11{ vd v85 v86 v87 v88} vd v89 v90 v91 v92 v93 v94 v95 v96 v97 v98} vd v1 v2 v3 v4 v5 v6 Fp}


 S87C3 ::~S87C3(){ note_dtor("S87C3", this);}
void  S87C3 ::v96(){vfunc_called(this, "_ZN5S87C33v96Ev");}
void  S87C3 ::v97(){vfunc_called(this, "_ZN5S87C33v97Ev");}
void  S87C3 ::v98(){vfunc_called(this, "_ZN5S87C33v98Ev");}
void  S87C3 ::v99(){vfunc_called(this, "_ZN5S87C33v99Ev");}
void  S87C3 ::v100(){vfunc_called(this, "_ZN5S87C34v100Ev");}
void  S87C3 ::v101(){vfunc_called(this, "_ZN5S87C34v101Ev");}
S87C3 ::S87C3(){ note_ctor("S87C3", this);} // tgen

static void Test_S87C3()
{
  extern Class_Descriptor cd_S87C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(20,25)];
    init_test(&cd_S87C3, buf);
    S87C3 *dp, &lv = *(dp=new (buf) S87C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(152,96), "sizeof(S87C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S87C3)");
    check_base_class_offset(lv, (S87C7*)(S87C6_nt*)(S87C5_nt*)(S87C4*), 0, "S87C3");
    check_base_class_offset(lv, (S87C6_nt*)(S87C5_nt*)(S87C4*), 0, "S87C3");
    check_base_class_offset(lv, (S87C5_nt*)(S87C4*), 0, "S87C3");
    check_base_class_offset(lv, (S87C13_nt*)(S87C4*), ABISELECT(136,88), "S87C3");
    check_base_class_offset(lv, (S87C4*), 0, "S87C3");
    check_field_offset(lv, s87c3f0, ABISELECT(144,92), "S87C3.s87c3f0");
    test_class_info(&lv, &cd_S87C3);
    dp->~S87C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS87C3(Test_S87C3, "S87C3", ABISELECT(152,96));

#else // __cplusplus

extern void _ZN5S87C3C1Ev();
extern void _ZN5S87C3D1Ev();
Name_Map name_map_S87C3[] = {
  NSPAIR(_ZN5S87C3C1Ev),
  NSPAIR(_ZN5S87C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S87C7;
extern VTBL_ENTRY _ZTI5S87C7[];
extern  VTBL_ENTRY _ZTV5S87C7[];
extern Class_Descriptor cd_S87C6_nt;
extern VTBL_ENTRY _ZTI8S87C6_nt[];
extern  VTBL_ENTRY _ZTV8S87C6_nt[];
extern Class_Descriptor cd_S87C5_nt;
extern VTBL_ENTRY _ZTI8S87C5_nt[];
extern  VTBL_ENTRY _ZTV8S87C5_nt[];
extern Class_Descriptor cd_S87C13_nt;
extern VTBL_ENTRY _ZTI9S87C13_nt[];
extern  VTBL_ENTRY _ZTV9S87C13_nt[];
extern Class_Descriptor cd_S87C4;
extern VTBL_ENTRY _ZTI5S87C4[];
extern  VTBL_ENTRY _ZTV5S87C4[];
static Base_Class bases_S87C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S87C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S87C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S87C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S87C13_nt,    ABISELECT(136,88), //bcp->offset
    98, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S87C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S87C3[];
extern void _ZN5S87C3D1Ev();
extern void _ZN5S87C3D0Ev();
extern void _ZN5S87C72v4Ev();
extern void _ZN5S87C72v5Ev();
extern void _ZN5S87C72v6Ev();
extern void _ZN5S87C72v7Ev();
extern void _ZN5S87C72v8Ev();
extern void _ZN5S87C72v9Ev();
extern void _ZN5S87C73v10Ev();
extern void _ZN5S87C73v11Ev();
extern void _ZN5S87C73v12Ev();
extern void _ZN5S87C73v13Ev();
extern void _ZN5S87C73v14Ev();
extern void _ZN5S87C73v15Ev();
extern void _ZN5S87C73v16Ev();
extern void _ZN5S87C73v17Ev();
extern void _ZN5S87C73v18Ev();
extern void _ZN5S87C73v19Ev();
extern void _ZN5S87C73v20Ev();
extern void _ZN5S87C73v21Ev();
extern void _ZN5S87C73v22Ev();
extern void _ZN5S87C73v23Ev();
extern void _ZN5S87C73v24Ev();
extern void _ZN5S87C73v25Ev();
extern void _ZN5S87C73v26Ev();
extern void _ZN5S87C73v27Ev();
extern void _ZN5S87C73v28Ev();
extern void _ZN5S87C73v29Ev();
extern void _ZN5S87C73v30Ev();
extern void _ZN5S87C73v31Ev();
extern void _ZN5S87C73v32Ev();
extern void _ZN5S87C73v33Ev();
extern void _ZN5S87C73v34Ev();
extern void _ZN5S87C73v35Ev();
extern void _ZN5S87C73v36Ev();
extern void _ZN5S87C73v37Ev();
extern void _ZN5S87C73v38Ev();
extern void _ZN5S87C73v39Ev();
extern void _ZN5S87C73v40Ev();
extern void _ZN5S87C73v41Ev();
extern void _ZN5S87C73v42Ev();
extern void _ZN5S87C73v43Ev();
extern void _ZN5S87C73v44Ev();
extern void _ZN5S87C73v45Ev();
extern void _ZN5S87C73v46Ev();
extern void _ZN5S87C73v47Ev();
extern void _ZN5S87C73v48Ev();
extern void _ZN5S87C73v49Ev();
extern void _ZN5S87C73v50Ev();
extern void _ZN5S87C73v51Ev();
extern void _ZN5S87C73v52Ev();
extern void _ZN5S87C73v53Ev();
extern void _ZN5S87C73v54Ev();
extern void _ZN5S87C73v55Ev();
extern void _ZN5S87C73v56Ev();
extern void _ZN5S87C73v57Ev();
extern void _ZN5S87C73v58Ev();
extern void _ZN5S87C73v59Ev();
extern void _ZN5S87C73v60Ev();
extern void _ZN5S87C73v61Ev();
extern void _ZN5S87C73v62Ev();
extern void _ZN5S87C73v63Ev();
extern void _ZN5S87C73v64Ev();
extern void _ZN5S87C73v65Ev();
extern void _ZN5S87C73v66Ev();
extern void _ZN5S87C73v67Ev();
extern void _ZN8S87C6_nt3v68Ev();
extern void _ZN8S87C6_nt3v69Ev();
extern void _ZN8S87C5_nt3v70Ev();
extern void _ZN8S87C5_nt3v71Ev();
extern void _ZN8S87C5_nt3v72Ev();
extern void _ZN8S87C5_nt3v73Ev();
extern void _ZN8S87C5_nt3v74Ev();
extern void _ZN8S87C5_nt3v75Ev();
extern void _ZN8S87C5_nt3v76Ev();
extern void _ZN8S87C5_nt3v77Ev();
extern void _ZN8S87C5_nt3v78Ev();
extern void _ZN8S87C5_nt3v79Ev();
extern void _ZN8S87C5_nt3v80Ev();
extern void _ZN8S87C5_nt3v81Ev();
extern void _ZN5S87C43v86Ev();
extern void _ZN5S87C43v87Ev();
extern void _ZN5S87C43v88Ev();
extern void _ZN5S87C43v89Ev();
extern void _ZN5S87C43v90Ev();
extern void _ZN5S87C43v91Ev();
extern void _ZN5S87C43v92Ev();
extern void _ZN5S87C43v93Ev();
extern void _ZN5S87C43v94Ev();
extern void _ZN5S87C43v95Ev();
extern void _ZN5S87C33v96Ev();
extern void _ZN5S87C33v97Ev();
extern void _ZN5S87C33v98Ev();
extern void _ZN5S87C33v99Ev();
extern void _ZN5S87C34v100Ev();
extern void _ZN5S87C34v101Ev();
extern void ABISELECT(_ZThn136_N5S87C3D1Ev,_ZThn88_N5S87C3D1Ev)();
extern void ABISELECT(_ZThn136_N5S87C3D0Ev,_ZThn88_N5S87C3D0Ev)();
extern void _ZN9S87C13_nt3v82Ev();
extern void _ZN9S87C13_nt3v83Ev();
extern void _ZN9S87C13_nt3v84Ev();
extern void _ZN9S87C13_nt3v85Ev();
static  VTBL_ENTRY vtc_S87C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S87C3[0]),
  (VTBL_ENTRY)&_ZN5S87C3D1Ev,
  (VTBL_ENTRY)&_ZN5S87C3D0Ev,
  (VTBL_ENTRY)&_ZN5S87C72v4Ev,
  (VTBL_ENTRY)&_ZN5S87C72v5Ev,
  (VTBL_ENTRY)&_ZN5S87C72v6Ev,
  (VTBL_ENTRY)&_ZN5S87C72v7Ev,
  (VTBL_ENTRY)&_ZN5S87C72v8Ev,
  (VTBL_ENTRY)&_ZN5S87C72v9Ev,
  (VTBL_ENTRY)&_ZN5S87C73v10Ev,
  (VTBL_ENTRY)&_ZN5S87C73v11Ev,
  (VTBL_ENTRY)&_ZN5S87C73v12Ev,
  (VTBL_ENTRY)&_ZN5S87C73v13Ev,
  (VTBL_ENTRY)&_ZN5S87C73v14Ev,
  (VTBL_ENTRY)&_ZN5S87C73v15Ev,
  (VTBL_ENTRY)&_ZN5S87C73v16Ev,
  (VTBL_ENTRY)&_ZN5S87C73v17Ev,
  (VTBL_ENTRY)&_ZN5S87C73v18Ev,
  (VTBL_ENTRY)&_ZN5S87C73v19Ev,
  (VTBL_ENTRY)&_ZN5S87C73v20Ev,
  (VTBL_ENTRY)&_ZN5S87C73v21Ev,
  (VTBL_ENTRY)&_ZN5S87C73v22Ev,
  (VTBL_ENTRY)&_ZN5S87C73v23Ev,
  (VTBL_ENTRY)&_ZN5S87C73v24Ev,
  (VTBL_ENTRY)&_ZN5S87C73v25Ev,
  (VTBL_ENTRY)&_ZN5S87C73v26Ev,
  (VTBL_ENTRY)&_ZN5S87C73v27Ev,
  (VTBL_ENTRY)&_ZN5S87C73v28Ev,
  (VTBL_ENTRY)&_ZN5S87C73v29Ev,
  (VTBL_ENTRY)&_ZN5S87C73v30Ev,
  (VTBL_ENTRY)&_ZN5S87C73v31Ev,
  (VTBL_ENTRY)&_ZN5S87C73v32Ev,
  (VTBL_ENTRY)&_ZN5S87C73v33Ev,
  (VTBL_ENTRY)&_ZN5S87C73v34Ev,
  (VTBL_ENTRY)&_ZN5S87C73v35Ev,
  (VTBL_ENTRY)&_ZN5S87C73v36Ev,
  (VTBL_ENTRY)&_ZN5S87C73v37Ev,
  (VTBL_ENTRY)&_ZN5S87C73v38Ev,
  (VTBL_ENTRY)&_ZN5S87C73v39Ev,
  (VTBL_ENTRY)&_ZN5S87C73v40Ev,
  (VTBL_ENTRY)&_ZN5S87C73v41Ev,
  (VTBL_ENTRY)&_ZN5S87C73v42Ev,
  (VTBL_ENTRY)&_ZN5S87C73v43Ev,
  (VTBL_ENTRY)&_ZN5S87C73v44Ev,
  (VTBL_ENTRY)&_ZN5S87C73v45Ev,
  (VTBL_ENTRY)&_ZN5S87C73v46Ev,
  (VTBL_ENTRY)&_ZN5S87C73v47Ev,
  (VTBL_ENTRY)&_ZN5S87C73v48Ev,
  (VTBL_ENTRY)&_ZN5S87C73v49Ev,
  (VTBL_ENTRY)&_ZN5S87C73v50Ev,
  (VTBL_ENTRY)&_ZN5S87C73v51Ev,
  (VTBL_ENTRY)&_ZN5S87C73v52Ev,
  (VTBL_ENTRY)&_ZN5S87C73v53Ev,
  (VTBL_ENTRY)&_ZN5S87C73v54Ev,
  (VTBL_ENTRY)&_ZN5S87C73v55Ev,
  (VTBL_ENTRY)&_ZN5S87C73v56Ev,
  (VTBL_ENTRY)&_ZN5S87C73v57Ev,
  (VTBL_ENTRY)&_ZN5S87C73v58Ev,
  (VTBL_ENTRY)&_ZN5S87C73v59Ev,
  (VTBL_ENTRY)&_ZN5S87C73v60Ev,
  (VTBL_ENTRY)&_ZN5S87C73v61Ev,
  (VTBL_ENTRY)&_ZN5S87C73v62Ev,
  (VTBL_ENTRY)&_ZN5S87C73v63Ev,
  (VTBL_ENTRY)&_ZN5S87C73v64Ev,
  (VTBL_ENTRY)&_ZN5S87C73v65Ev,
  (VTBL_ENTRY)&_ZN5S87C73v66Ev,
  (VTBL_ENTRY)&_ZN5S87C73v67Ev,
  (VTBL_ENTRY)&_ZN8S87C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S87C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN5S87C43v86Ev,
  (VTBL_ENTRY)&_ZN5S87C43v87Ev,
  (VTBL_ENTRY)&_ZN5S87C43v88Ev,
  (VTBL_ENTRY)&_ZN5S87C43v89Ev,
  (VTBL_ENTRY)&_ZN5S87C43v90Ev,
  (VTBL_ENTRY)&_ZN5S87C43v91Ev,
  (VTBL_ENTRY)&_ZN5S87C43v92Ev,
  (VTBL_ENTRY)&_ZN5S87C43v93Ev,
  (VTBL_ENTRY)&_ZN5S87C43v94Ev,
  (VTBL_ENTRY)&_ZN5S87C43v95Ev,
  (VTBL_ENTRY)&_ZN5S87C33v96Ev,
  (VTBL_ENTRY)&_ZN5S87C33v97Ev,
  (VTBL_ENTRY)&_ZN5S87C33v98Ev,
  (VTBL_ENTRY)&_ZN5S87C33v99Ev,
  (VTBL_ENTRY)&_ZN5S87C34v100Ev,
  (VTBL_ENTRY)&_ZN5S87C34v101Ev,
  ABISELECT(-136,-88),
  (VTBL_ENTRY)&(_ZTI5S87C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn136_N5S87C3D1Ev,_ZThn88_N5S87C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn136_N5S87C3D0Ev,_ZThn88_N5S87C3D0Ev),
  (VTBL_ENTRY)&_ZN9S87C13_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S87C13_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S87C13_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S87C13_nt3v85Ev,
};
extern VTBL_ENTRY _ZTI5S87C3[];
extern  VTBL_ENTRY _ZTV5S87C3[];
Class_Descriptor cd_S87C3 = {  "S87C3", // class name
  bases_S87C3, 5,
  &(vtc_S87C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(152,96), // object size
  NSPAIRA(_ZTI5S87C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S87C3),106, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S87C2  : S87C3 {
  ::S3352C11 s87c2f0;
  virtual  ~S87C2(); // _ZN5S87C2D1Ev
  virtual void  v102(); // _ZN5S87C24v102Ev
  virtual void  v103(); // _ZN5S87C24v103Ev
  virtual void  v104(); // _ZN5S87C24v104Ev
  virtual void  v105(); // _ZN5S87C24v105Ev
  virtual void  v106(); // _ZN5S87C24v106Ev
  S87C2(); // tgen
};
//SIG(-1 S87C2) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v70 v71} vd v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 Fc FC8{ BC9{ BC10{ m Fp Fi[2]}}} FC11{ m Fp FC7}} BC12{ vd v84 v85 v86 v87} vd v88 v89 v90 v91 v92 v93 v94 v95 v96 v97} vd v98 v99 v100 v101 v102 v103 Fp} vd v1 v2 v3 v4 v5 FC13{ BC14{ BC10}}}


 S87C2 ::~S87C2(){ note_dtor("S87C2", this);}
void  S87C2 ::v102(){vfunc_called(this, "_ZN5S87C24v102Ev");}
void  S87C2 ::v103(){vfunc_called(this, "_ZN5S87C24v103Ev");}
void  S87C2 ::v104(){vfunc_called(this, "_ZN5S87C24v104Ev");}
void  S87C2 ::v105(){vfunc_called(this, "_ZN5S87C24v105Ev");}
void  S87C2 ::v106(){vfunc_called(this, "_ZN5S87C24v106Ev");}
S87C2 ::S87C2(){ note_ctor("S87C2", this);} // tgen

static void Test_S87C2()
{
  extern Class_Descriptor cd_S87C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(22,28)];
    init_test(&cd_S87C2, buf);
    S87C2 *dp, &lv = *(dp=new (buf) S87C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(168,108), "sizeof(S87C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S87C2)");
    check_base_class_offset(lv, (S87C7*)(S87C6_nt*)(S87C5_nt*)(S87C4*)(S87C3*), 0, "S87C2");
    check_base_class_offset(lv, (S87C6_nt*)(S87C5_nt*)(S87C4*)(S87C3*), 0, "S87C2");
    check_base_class_offset(lv, (S87C5_nt*)(S87C4*)(S87C3*), 0, "S87C2");
    check_base_class_offset(lv, (S87C13_nt*)(S87C4*)(S87C3*), ABISELECT(136,88), "S87C2");
    check_base_class_offset(lv, (S87C4*)(S87C3*), 0, "S87C2");
    check_base_class_offset(lv, (S87C3*), 0, "S87C2");
    check_field_offset(lv, s87c2f0, ABISELECT(152,96), "S87C2.s87c2f0");
    test_class_info(&lv, &cd_S87C2);
    dp->~S87C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS87C2(Test_S87C2, "S87C2", ABISELECT(168,108));

#else // __cplusplus

extern void _ZN5S87C2C1Ev();
extern void _ZN5S87C2D1Ev();
Name_Map name_map_S87C2[] = {
  NSPAIR(_ZN5S87C2C1Ev),
  NSPAIR(_ZN5S87C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S87C7;
extern VTBL_ENTRY _ZTI5S87C7[];
extern  VTBL_ENTRY _ZTV5S87C7[];
extern Class_Descriptor cd_S87C6_nt;
extern VTBL_ENTRY _ZTI8S87C6_nt[];
extern  VTBL_ENTRY _ZTV8S87C6_nt[];
extern Class_Descriptor cd_S87C5_nt;
extern VTBL_ENTRY _ZTI8S87C5_nt[];
extern  VTBL_ENTRY _ZTV8S87C5_nt[];
extern Class_Descriptor cd_S87C13_nt;
extern VTBL_ENTRY _ZTI9S87C13_nt[];
extern  VTBL_ENTRY _ZTV9S87C13_nt[];
extern Class_Descriptor cd_S87C4;
extern VTBL_ENTRY _ZTI5S87C4[];
extern  VTBL_ENTRY _ZTV5S87C4[];
extern Class_Descriptor cd_S87C3;
extern VTBL_ENTRY _ZTI5S87C3[];
extern  VTBL_ENTRY _ZTV5S87C3[];
static Base_Class bases_S87C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S87C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S87C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S87C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S87C13_nt,    ABISELECT(136,88), //bcp->offset
    103, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S87C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S87C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S87C2[];
extern void _ZN5S87C2D1Ev();
extern void _ZN5S87C2D0Ev();
extern void _ZN5S87C72v4Ev();
extern void _ZN5S87C72v5Ev();
extern void _ZN5S87C72v6Ev();
extern void _ZN5S87C72v7Ev();
extern void _ZN5S87C72v8Ev();
extern void _ZN5S87C72v9Ev();
extern void _ZN5S87C73v10Ev();
extern void _ZN5S87C73v11Ev();
extern void _ZN5S87C73v12Ev();
extern void _ZN5S87C73v13Ev();
extern void _ZN5S87C73v14Ev();
extern void _ZN5S87C73v15Ev();
extern void _ZN5S87C73v16Ev();
extern void _ZN5S87C73v17Ev();
extern void _ZN5S87C73v18Ev();
extern void _ZN5S87C73v19Ev();
extern void _ZN5S87C73v20Ev();
extern void _ZN5S87C73v21Ev();
extern void _ZN5S87C73v22Ev();
extern void _ZN5S87C73v23Ev();
extern void _ZN5S87C73v24Ev();
extern void _ZN5S87C73v25Ev();
extern void _ZN5S87C73v26Ev();
extern void _ZN5S87C73v27Ev();
extern void _ZN5S87C73v28Ev();
extern void _ZN5S87C73v29Ev();
extern void _ZN5S87C73v30Ev();
extern void _ZN5S87C73v31Ev();
extern void _ZN5S87C73v32Ev();
extern void _ZN5S87C73v33Ev();
extern void _ZN5S87C73v34Ev();
extern void _ZN5S87C73v35Ev();
extern void _ZN5S87C73v36Ev();
extern void _ZN5S87C73v37Ev();
extern void _ZN5S87C73v38Ev();
extern void _ZN5S87C73v39Ev();
extern void _ZN5S87C73v40Ev();
extern void _ZN5S87C73v41Ev();
extern void _ZN5S87C73v42Ev();
extern void _ZN5S87C73v43Ev();
extern void _ZN5S87C73v44Ev();
extern void _ZN5S87C73v45Ev();
extern void _ZN5S87C73v46Ev();
extern void _ZN5S87C73v47Ev();
extern void _ZN5S87C73v48Ev();
extern void _ZN5S87C73v49Ev();
extern void _ZN5S87C73v50Ev();
extern void _ZN5S87C73v51Ev();
extern void _ZN5S87C73v52Ev();
extern void _ZN5S87C73v53Ev();
extern void _ZN5S87C73v54Ev();
extern void _ZN5S87C73v55Ev();
extern void _ZN5S87C73v56Ev();
extern void _ZN5S87C73v57Ev();
extern void _ZN5S87C73v58Ev();
extern void _ZN5S87C73v59Ev();
extern void _ZN5S87C73v60Ev();
extern void _ZN5S87C73v61Ev();
extern void _ZN5S87C73v62Ev();
extern void _ZN5S87C73v63Ev();
extern void _ZN5S87C73v64Ev();
extern void _ZN5S87C73v65Ev();
extern void _ZN5S87C73v66Ev();
extern void _ZN5S87C73v67Ev();
extern void _ZN8S87C6_nt3v68Ev();
extern void _ZN8S87C6_nt3v69Ev();
extern void _ZN8S87C5_nt3v70Ev();
extern void _ZN8S87C5_nt3v71Ev();
extern void _ZN8S87C5_nt3v72Ev();
extern void _ZN8S87C5_nt3v73Ev();
extern void _ZN8S87C5_nt3v74Ev();
extern void _ZN8S87C5_nt3v75Ev();
extern void _ZN8S87C5_nt3v76Ev();
extern void _ZN8S87C5_nt3v77Ev();
extern void _ZN8S87C5_nt3v78Ev();
extern void _ZN8S87C5_nt3v79Ev();
extern void _ZN8S87C5_nt3v80Ev();
extern void _ZN8S87C5_nt3v81Ev();
extern void _ZN5S87C43v86Ev();
extern void _ZN5S87C43v87Ev();
extern void _ZN5S87C43v88Ev();
extern void _ZN5S87C43v89Ev();
extern void _ZN5S87C43v90Ev();
extern void _ZN5S87C43v91Ev();
extern void _ZN5S87C43v92Ev();
extern void _ZN5S87C43v93Ev();
extern void _ZN5S87C43v94Ev();
extern void _ZN5S87C43v95Ev();
extern void _ZN5S87C33v96Ev();
extern void _ZN5S87C33v97Ev();
extern void _ZN5S87C33v98Ev();
extern void _ZN5S87C33v99Ev();
extern void _ZN5S87C34v100Ev();
extern void _ZN5S87C34v101Ev();
extern void _ZN5S87C24v102Ev();
extern void _ZN5S87C24v103Ev();
extern void _ZN5S87C24v104Ev();
extern void _ZN5S87C24v105Ev();
extern void _ZN5S87C24v106Ev();
extern void ABISELECT(_ZThn136_N5S87C2D1Ev,_ZThn88_N5S87C2D1Ev)();
extern void ABISELECT(_ZThn136_N5S87C2D0Ev,_ZThn88_N5S87C2D0Ev)();
extern void _ZN9S87C13_nt3v82Ev();
extern void _ZN9S87C13_nt3v83Ev();
extern void _ZN9S87C13_nt3v84Ev();
extern void _ZN9S87C13_nt3v85Ev();
static  VTBL_ENTRY vtc_S87C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S87C2[0]),
  (VTBL_ENTRY)&_ZN5S87C2D1Ev,
  (VTBL_ENTRY)&_ZN5S87C2D0Ev,
  (VTBL_ENTRY)&_ZN5S87C72v4Ev,
  (VTBL_ENTRY)&_ZN5S87C72v5Ev,
  (VTBL_ENTRY)&_ZN5S87C72v6Ev,
  (VTBL_ENTRY)&_ZN5S87C72v7Ev,
  (VTBL_ENTRY)&_ZN5S87C72v8Ev,
  (VTBL_ENTRY)&_ZN5S87C72v9Ev,
  (VTBL_ENTRY)&_ZN5S87C73v10Ev,
  (VTBL_ENTRY)&_ZN5S87C73v11Ev,
  (VTBL_ENTRY)&_ZN5S87C73v12Ev,
  (VTBL_ENTRY)&_ZN5S87C73v13Ev,
  (VTBL_ENTRY)&_ZN5S87C73v14Ev,
  (VTBL_ENTRY)&_ZN5S87C73v15Ev,
  (VTBL_ENTRY)&_ZN5S87C73v16Ev,
  (VTBL_ENTRY)&_ZN5S87C73v17Ev,
  (VTBL_ENTRY)&_ZN5S87C73v18Ev,
  (VTBL_ENTRY)&_ZN5S87C73v19Ev,
  (VTBL_ENTRY)&_ZN5S87C73v20Ev,
  (VTBL_ENTRY)&_ZN5S87C73v21Ev,
  (VTBL_ENTRY)&_ZN5S87C73v22Ev,
  (VTBL_ENTRY)&_ZN5S87C73v23Ev,
  (VTBL_ENTRY)&_ZN5S87C73v24Ev,
  (VTBL_ENTRY)&_ZN5S87C73v25Ev,
  (VTBL_ENTRY)&_ZN5S87C73v26Ev,
  (VTBL_ENTRY)&_ZN5S87C73v27Ev,
  (VTBL_ENTRY)&_ZN5S87C73v28Ev,
  (VTBL_ENTRY)&_ZN5S87C73v29Ev,
  (VTBL_ENTRY)&_ZN5S87C73v30Ev,
  (VTBL_ENTRY)&_ZN5S87C73v31Ev,
  (VTBL_ENTRY)&_ZN5S87C73v32Ev,
  (VTBL_ENTRY)&_ZN5S87C73v33Ev,
  (VTBL_ENTRY)&_ZN5S87C73v34Ev,
  (VTBL_ENTRY)&_ZN5S87C73v35Ev,
  (VTBL_ENTRY)&_ZN5S87C73v36Ev,
  (VTBL_ENTRY)&_ZN5S87C73v37Ev,
  (VTBL_ENTRY)&_ZN5S87C73v38Ev,
  (VTBL_ENTRY)&_ZN5S87C73v39Ev,
  (VTBL_ENTRY)&_ZN5S87C73v40Ev,
  (VTBL_ENTRY)&_ZN5S87C73v41Ev,
  (VTBL_ENTRY)&_ZN5S87C73v42Ev,
  (VTBL_ENTRY)&_ZN5S87C73v43Ev,
  (VTBL_ENTRY)&_ZN5S87C73v44Ev,
  (VTBL_ENTRY)&_ZN5S87C73v45Ev,
  (VTBL_ENTRY)&_ZN5S87C73v46Ev,
  (VTBL_ENTRY)&_ZN5S87C73v47Ev,
  (VTBL_ENTRY)&_ZN5S87C73v48Ev,
  (VTBL_ENTRY)&_ZN5S87C73v49Ev,
  (VTBL_ENTRY)&_ZN5S87C73v50Ev,
  (VTBL_ENTRY)&_ZN5S87C73v51Ev,
  (VTBL_ENTRY)&_ZN5S87C73v52Ev,
  (VTBL_ENTRY)&_ZN5S87C73v53Ev,
  (VTBL_ENTRY)&_ZN5S87C73v54Ev,
  (VTBL_ENTRY)&_ZN5S87C73v55Ev,
  (VTBL_ENTRY)&_ZN5S87C73v56Ev,
  (VTBL_ENTRY)&_ZN5S87C73v57Ev,
  (VTBL_ENTRY)&_ZN5S87C73v58Ev,
  (VTBL_ENTRY)&_ZN5S87C73v59Ev,
  (VTBL_ENTRY)&_ZN5S87C73v60Ev,
  (VTBL_ENTRY)&_ZN5S87C73v61Ev,
  (VTBL_ENTRY)&_ZN5S87C73v62Ev,
  (VTBL_ENTRY)&_ZN5S87C73v63Ev,
  (VTBL_ENTRY)&_ZN5S87C73v64Ev,
  (VTBL_ENTRY)&_ZN5S87C73v65Ev,
  (VTBL_ENTRY)&_ZN5S87C73v66Ev,
  (VTBL_ENTRY)&_ZN5S87C73v67Ev,
  (VTBL_ENTRY)&_ZN8S87C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S87C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN5S87C43v86Ev,
  (VTBL_ENTRY)&_ZN5S87C43v87Ev,
  (VTBL_ENTRY)&_ZN5S87C43v88Ev,
  (VTBL_ENTRY)&_ZN5S87C43v89Ev,
  (VTBL_ENTRY)&_ZN5S87C43v90Ev,
  (VTBL_ENTRY)&_ZN5S87C43v91Ev,
  (VTBL_ENTRY)&_ZN5S87C43v92Ev,
  (VTBL_ENTRY)&_ZN5S87C43v93Ev,
  (VTBL_ENTRY)&_ZN5S87C43v94Ev,
  (VTBL_ENTRY)&_ZN5S87C43v95Ev,
  (VTBL_ENTRY)&_ZN5S87C33v96Ev,
  (VTBL_ENTRY)&_ZN5S87C33v97Ev,
  (VTBL_ENTRY)&_ZN5S87C33v98Ev,
  (VTBL_ENTRY)&_ZN5S87C33v99Ev,
  (VTBL_ENTRY)&_ZN5S87C34v100Ev,
  (VTBL_ENTRY)&_ZN5S87C34v101Ev,
  (VTBL_ENTRY)&_ZN5S87C24v102Ev,
  (VTBL_ENTRY)&_ZN5S87C24v103Ev,
  (VTBL_ENTRY)&_ZN5S87C24v104Ev,
  (VTBL_ENTRY)&_ZN5S87C24v105Ev,
  (VTBL_ENTRY)&_ZN5S87C24v106Ev,
  ABISELECT(-136,-88),
  (VTBL_ENTRY)&(_ZTI5S87C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn136_N5S87C2D1Ev,_ZThn88_N5S87C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn136_N5S87C2D0Ev,_ZThn88_N5S87C2D0Ev),
  (VTBL_ENTRY)&_ZN9S87C13_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S87C13_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S87C13_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S87C13_nt3v85Ev,
};
extern VTBL_ENTRY _ZTI5S87C2[];
extern  VTBL_ENTRY _ZTV5S87C2[];
Class_Descriptor cd_S87C2 = {  "S87C2", // class name
  bases_S87C2, 6,
  &(vtc_S87C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(168,108), // object size
  NSPAIRA(_ZTI5S87C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S87C2),111, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S87C1  : S87C2 {
  virtual  ~S87C1(); // _ZN5S87C1D1Ev
  virtual void  v1(); // _ZN5S87C12v1Ev
  virtual void  v2(); // _ZN5S87C12v2Ev
  virtual void  v3(); // _ZN5S87C12v3Ev
  S87C1(); // tgen
};
//SIG(1 S87C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC8{ m Fi[2]} Fp[2]} vd v68 v69} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 Fc FC9{ BC10{ BC11{ m Fp Fi[2]}}} FC12{ m Fp FC8}} BC13{ vd v82 v83 v84 v85} vd v86 v87 v88 v89 v90 v91 v92 v93 v94 v95} vd v96 v97 v98 v99 v100 v101 Fp} vd v102 v103 v104 v105 v106 FC14{ BC15{ BC11}}} vd v1 v2 v3}


 S87C1 ::~S87C1(){ note_dtor("S87C1", this);}
void  S87C1 ::v1(){vfunc_called(this, "_ZN5S87C12v1Ev");}
void  S87C1 ::v2(){vfunc_called(this, "_ZN5S87C12v2Ev");}
void  S87C1 ::v3(){vfunc_called(this, "_ZN5S87C12v3Ev");}
S87C1 ::S87C1(){ note_ctor("S87C1", this);} // tgen

static void Test_S87C1()
{
  extern Class_Descriptor cd_S87C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(22,28)];
    init_test(&cd_S87C1, buf);
    S87C1 *dp, &lv = *(dp=new (buf) S87C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(168,108), "sizeof(S87C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S87C1)");
    check_base_class_offset(lv, (S87C7*)(S87C6_nt*)(S87C5_nt*)(S87C4*)(S87C3*)(S87C2*), 0, "S87C1");
    check_base_class_offset(lv, (S87C6_nt*)(S87C5_nt*)(S87C4*)(S87C3*)(S87C2*), 0, "S87C1");
    check_base_class_offset(lv, (S87C5_nt*)(S87C4*)(S87C3*)(S87C2*), 0, "S87C1");
    check_base_class_offset(lv, (S87C13_nt*)(S87C4*)(S87C3*)(S87C2*), ABISELECT(136,88), "S87C1");
    check_base_class_offset(lv, (S87C4*)(S87C3*)(S87C2*), 0, "S87C1");
    check_base_class_offset(lv, (S87C3*)(S87C2*), 0, "S87C1");
    check_base_class_offset(lv, (S87C2*), 0, "S87C1");
    test_class_info(&lv, &cd_S87C1);
    dp->~S87C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS87C1(Test_S87C1, "S87C1", ABISELECT(168,108));

#else // __cplusplus

extern void _ZN5S87C1C1Ev();
extern void _ZN5S87C1D1Ev();
Name_Map name_map_S87C1[] = {
  NSPAIR(_ZN5S87C1C1Ev),
  NSPAIR(_ZN5S87C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S87C7;
extern VTBL_ENTRY _ZTI5S87C7[];
extern  VTBL_ENTRY _ZTV5S87C7[];
extern Class_Descriptor cd_S87C6_nt;
extern VTBL_ENTRY _ZTI8S87C6_nt[];
extern  VTBL_ENTRY _ZTV8S87C6_nt[];
extern Class_Descriptor cd_S87C5_nt;
extern VTBL_ENTRY _ZTI8S87C5_nt[];
extern  VTBL_ENTRY _ZTV8S87C5_nt[];
extern Class_Descriptor cd_S87C13_nt;
extern VTBL_ENTRY _ZTI9S87C13_nt[];
extern  VTBL_ENTRY _ZTV9S87C13_nt[];
extern Class_Descriptor cd_S87C4;
extern VTBL_ENTRY _ZTI5S87C4[];
extern  VTBL_ENTRY _ZTV5S87C4[];
extern Class_Descriptor cd_S87C3;
extern VTBL_ENTRY _ZTI5S87C3[];
extern  VTBL_ENTRY _ZTV5S87C3[];
extern Class_Descriptor cd_S87C2;
extern VTBL_ENTRY _ZTI5S87C2[];
extern  VTBL_ENTRY _ZTV5S87C2[];
static Base_Class bases_S87C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S87C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S87C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S87C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S87C13_nt,    ABISELECT(136,88), //bcp->offset
    106, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S87C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S87C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S87C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S87C1[];
extern void _ZN5S87C1D1Ev();
extern void _ZN5S87C1D0Ev();
extern void _ZN5S87C72v4Ev();
extern void _ZN5S87C72v5Ev();
extern void _ZN5S87C72v6Ev();
extern void _ZN5S87C72v7Ev();
extern void _ZN5S87C72v8Ev();
extern void _ZN5S87C72v9Ev();
extern void _ZN5S87C73v10Ev();
extern void _ZN5S87C73v11Ev();
extern void _ZN5S87C73v12Ev();
extern void _ZN5S87C73v13Ev();
extern void _ZN5S87C73v14Ev();
extern void _ZN5S87C73v15Ev();
extern void _ZN5S87C73v16Ev();
extern void _ZN5S87C73v17Ev();
extern void _ZN5S87C73v18Ev();
extern void _ZN5S87C73v19Ev();
extern void _ZN5S87C73v20Ev();
extern void _ZN5S87C73v21Ev();
extern void _ZN5S87C73v22Ev();
extern void _ZN5S87C73v23Ev();
extern void _ZN5S87C73v24Ev();
extern void _ZN5S87C73v25Ev();
extern void _ZN5S87C73v26Ev();
extern void _ZN5S87C73v27Ev();
extern void _ZN5S87C73v28Ev();
extern void _ZN5S87C73v29Ev();
extern void _ZN5S87C73v30Ev();
extern void _ZN5S87C73v31Ev();
extern void _ZN5S87C73v32Ev();
extern void _ZN5S87C73v33Ev();
extern void _ZN5S87C73v34Ev();
extern void _ZN5S87C73v35Ev();
extern void _ZN5S87C73v36Ev();
extern void _ZN5S87C73v37Ev();
extern void _ZN5S87C73v38Ev();
extern void _ZN5S87C73v39Ev();
extern void _ZN5S87C73v40Ev();
extern void _ZN5S87C73v41Ev();
extern void _ZN5S87C73v42Ev();
extern void _ZN5S87C73v43Ev();
extern void _ZN5S87C73v44Ev();
extern void _ZN5S87C73v45Ev();
extern void _ZN5S87C73v46Ev();
extern void _ZN5S87C73v47Ev();
extern void _ZN5S87C73v48Ev();
extern void _ZN5S87C73v49Ev();
extern void _ZN5S87C73v50Ev();
extern void _ZN5S87C73v51Ev();
extern void _ZN5S87C73v52Ev();
extern void _ZN5S87C73v53Ev();
extern void _ZN5S87C73v54Ev();
extern void _ZN5S87C73v55Ev();
extern void _ZN5S87C73v56Ev();
extern void _ZN5S87C73v57Ev();
extern void _ZN5S87C73v58Ev();
extern void _ZN5S87C73v59Ev();
extern void _ZN5S87C73v60Ev();
extern void _ZN5S87C73v61Ev();
extern void _ZN5S87C73v62Ev();
extern void _ZN5S87C73v63Ev();
extern void _ZN5S87C73v64Ev();
extern void _ZN5S87C73v65Ev();
extern void _ZN5S87C73v66Ev();
extern void _ZN5S87C73v67Ev();
extern void _ZN8S87C6_nt3v68Ev();
extern void _ZN8S87C6_nt3v69Ev();
extern void _ZN8S87C5_nt3v70Ev();
extern void _ZN8S87C5_nt3v71Ev();
extern void _ZN8S87C5_nt3v72Ev();
extern void _ZN8S87C5_nt3v73Ev();
extern void _ZN8S87C5_nt3v74Ev();
extern void _ZN8S87C5_nt3v75Ev();
extern void _ZN8S87C5_nt3v76Ev();
extern void _ZN8S87C5_nt3v77Ev();
extern void _ZN8S87C5_nt3v78Ev();
extern void _ZN8S87C5_nt3v79Ev();
extern void _ZN8S87C5_nt3v80Ev();
extern void _ZN8S87C5_nt3v81Ev();
extern void _ZN5S87C43v86Ev();
extern void _ZN5S87C43v87Ev();
extern void _ZN5S87C43v88Ev();
extern void _ZN5S87C43v89Ev();
extern void _ZN5S87C43v90Ev();
extern void _ZN5S87C43v91Ev();
extern void _ZN5S87C43v92Ev();
extern void _ZN5S87C43v93Ev();
extern void _ZN5S87C43v94Ev();
extern void _ZN5S87C43v95Ev();
extern void _ZN5S87C33v96Ev();
extern void _ZN5S87C33v97Ev();
extern void _ZN5S87C33v98Ev();
extern void _ZN5S87C33v99Ev();
extern void _ZN5S87C34v100Ev();
extern void _ZN5S87C34v101Ev();
extern void _ZN5S87C24v102Ev();
extern void _ZN5S87C24v103Ev();
extern void _ZN5S87C24v104Ev();
extern void _ZN5S87C24v105Ev();
extern void _ZN5S87C24v106Ev();
extern void _ZN5S87C12v1Ev();
extern void _ZN5S87C12v2Ev();
extern void _ZN5S87C12v3Ev();
extern void ABISELECT(_ZThn136_N5S87C1D1Ev,_ZThn88_N5S87C1D1Ev)();
extern void ABISELECT(_ZThn136_N5S87C1D0Ev,_ZThn88_N5S87C1D0Ev)();
extern void _ZN9S87C13_nt3v82Ev();
extern void _ZN9S87C13_nt3v83Ev();
extern void _ZN9S87C13_nt3v84Ev();
extern void _ZN9S87C13_nt3v85Ev();
static  VTBL_ENTRY vtc_S87C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S87C1[0]),
  (VTBL_ENTRY)&_ZN5S87C1D1Ev,
  (VTBL_ENTRY)&_ZN5S87C1D0Ev,
  (VTBL_ENTRY)&_ZN5S87C72v4Ev,
  (VTBL_ENTRY)&_ZN5S87C72v5Ev,
  (VTBL_ENTRY)&_ZN5S87C72v6Ev,
  (VTBL_ENTRY)&_ZN5S87C72v7Ev,
  (VTBL_ENTRY)&_ZN5S87C72v8Ev,
  (VTBL_ENTRY)&_ZN5S87C72v9Ev,
  (VTBL_ENTRY)&_ZN5S87C73v10Ev,
  (VTBL_ENTRY)&_ZN5S87C73v11Ev,
  (VTBL_ENTRY)&_ZN5S87C73v12Ev,
  (VTBL_ENTRY)&_ZN5S87C73v13Ev,
  (VTBL_ENTRY)&_ZN5S87C73v14Ev,
  (VTBL_ENTRY)&_ZN5S87C73v15Ev,
  (VTBL_ENTRY)&_ZN5S87C73v16Ev,
  (VTBL_ENTRY)&_ZN5S87C73v17Ev,
  (VTBL_ENTRY)&_ZN5S87C73v18Ev,
  (VTBL_ENTRY)&_ZN5S87C73v19Ev,
  (VTBL_ENTRY)&_ZN5S87C73v20Ev,
  (VTBL_ENTRY)&_ZN5S87C73v21Ev,
  (VTBL_ENTRY)&_ZN5S87C73v22Ev,
  (VTBL_ENTRY)&_ZN5S87C73v23Ev,
  (VTBL_ENTRY)&_ZN5S87C73v24Ev,
  (VTBL_ENTRY)&_ZN5S87C73v25Ev,
  (VTBL_ENTRY)&_ZN5S87C73v26Ev,
  (VTBL_ENTRY)&_ZN5S87C73v27Ev,
  (VTBL_ENTRY)&_ZN5S87C73v28Ev,
  (VTBL_ENTRY)&_ZN5S87C73v29Ev,
  (VTBL_ENTRY)&_ZN5S87C73v30Ev,
  (VTBL_ENTRY)&_ZN5S87C73v31Ev,
  (VTBL_ENTRY)&_ZN5S87C73v32Ev,
  (VTBL_ENTRY)&_ZN5S87C73v33Ev,
  (VTBL_ENTRY)&_ZN5S87C73v34Ev,
  (VTBL_ENTRY)&_ZN5S87C73v35Ev,
  (VTBL_ENTRY)&_ZN5S87C73v36Ev,
  (VTBL_ENTRY)&_ZN5S87C73v37Ev,
  (VTBL_ENTRY)&_ZN5S87C73v38Ev,
  (VTBL_ENTRY)&_ZN5S87C73v39Ev,
  (VTBL_ENTRY)&_ZN5S87C73v40Ev,
  (VTBL_ENTRY)&_ZN5S87C73v41Ev,
  (VTBL_ENTRY)&_ZN5S87C73v42Ev,
  (VTBL_ENTRY)&_ZN5S87C73v43Ev,
  (VTBL_ENTRY)&_ZN5S87C73v44Ev,
  (VTBL_ENTRY)&_ZN5S87C73v45Ev,
  (VTBL_ENTRY)&_ZN5S87C73v46Ev,
  (VTBL_ENTRY)&_ZN5S87C73v47Ev,
  (VTBL_ENTRY)&_ZN5S87C73v48Ev,
  (VTBL_ENTRY)&_ZN5S87C73v49Ev,
  (VTBL_ENTRY)&_ZN5S87C73v50Ev,
  (VTBL_ENTRY)&_ZN5S87C73v51Ev,
  (VTBL_ENTRY)&_ZN5S87C73v52Ev,
  (VTBL_ENTRY)&_ZN5S87C73v53Ev,
  (VTBL_ENTRY)&_ZN5S87C73v54Ev,
  (VTBL_ENTRY)&_ZN5S87C73v55Ev,
  (VTBL_ENTRY)&_ZN5S87C73v56Ev,
  (VTBL_ENTRY)&_ZN5S87C73v57Ev,
  (VTBL_ENTRY)&_ZN5S87C73v58Ev,
  (VTBL_ENTRY)&_ZN5S87C73v59Ev,
  (VTBL_ENTRY)&_ZN5S87C73v60Ev,
  (VTBL_ENTRY)&_ZN5S87C73v61Ev,
  (VTBL_ENTRY)&_ZN5S87C73v62Ev,
  (VTBL_ENTRY)&_ZN5S87C73v63Ev,
  (VTBL_ENTRY)&_ZN5S87C73v64Ev,
  (VTBL_ENTRY)&_ZN5S87C73v65Ev,
  (VTBL_ENTRY)&_ZN5S87C73v66Ev,
  (VTBL_ENTRY)&_ZN5S87C73v67Ev,
  (VTBL_ENTRY)&_ZN8S87C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S87C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S87C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN5S87C43v86Ev,
  (VTBL_ENTRY)&_ZN5S87C43v87Ev,
  (VTBL_ENTRY)&_ZN5S87C43v88Ev,
  (VTBL_ENTRY)&_ZN5S87C43v89Ev,
  (VTBL_ENTRY)&_ZN5S87C43v90Ev,
  (VTBL_ENTRY)&_ZN5S87C43v91Ev,
  (VTBL_ENTRY)&_ZN5S87C43v92Ev,
  (VTBL_ENTRY)&_ZN5S87C43v93Ev,
  (VTBL_ENTRY)&_ZN5S87C43v94Ev,
  (VTBL_ENTRY)&_ZN5S87C43v95Ev,
  (VTBL_ENTRY)&_ZN5S87C33v96Ev,
  (VTBL_ENTRY)&_ZN5S87C33v97Ev,
  (VTBL_ENTRY)&_ZN5S87C33v98Ev,
  (VTBL_ENTRY)&_ZN5S87C33v99Ev,
  (VTBL_ENTRY)&_ZN5S87C34v100Ev,
  (VTBL_ENTRY)&_ZN5S87C34v101Ev,
  (VTBL_ENTRY)&_ZN5S87C24v102Ev,
  (VTBL_ENTRY)&_ZN5S87C24v103Ev,
  (VTBL_ENTRY)&_ZN5S87C24v104Ev,
  (VTBL_ENTRY)&_ZN5S87C24v105Ev,
  (VTBL_ENTRY)&_ZN5S87C24v106Ev,
  (VTBL_ENTRY)&_ZN5S87C12v1Ev,
  (VTBL_ENTRY)&_ZN5S87C12v2Ev,
  (VTBL_ENTRY)&_ZN5S87C12v3Ev,
  ABISELECT(-136,-88),
  (VTBL_ENTRY)&(_ZTI5S87C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn136_N5S87C1D1Ev,_ZThn88_N5S87C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn136_N5S87C1D0Ev,_ZThn88_N5S87C1D0Ev),
  (VTBL_ENTRY)&_ZN9S87C13_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S87C13_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S87C13_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S87C13_nt3v85Ev,
};
extern VTBL_ENTRY _ZTI5S87C1[];
extern  VTBL_ENTRY _ZTV5S87C1[];
Class_Descriptor cd_S87C1 = {  "S87C1", // class name
  bases_S87C1, 7,
  &(vtc_S87C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(168,108), // object size
  NSPAIRA(_ZTI5S87C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S87C1),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  7, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6962C2  {
  int s6962c2f0;
  __tsi64 s6962c2f1;
  void *s6962c2f2[4];
  int s6962c2f3[2];
  void *s6962c2f4;
  ::S3352C4_nt s6962c2f5;
  void *s6962c2f6[2];
  virtual  ~S6962C2(); // _ZN7S6962C2D1Ev
  virtual void  v5(); // _ZN7S6962C22v5Ev
  virtual void  v6(); // _ZN7S6962C22v6Ev
  virtual void  v7(); // _ZN7S6962C22v7Ev
  virtual void  v8(); // _ZN7S6962C22v8Ev
  virtual void  v9(); // _ZN7S6962C22v9Ev
  virtual void  v10(); // _ZN7S6962C23v10Ev
  virtual void  v11(); // _ZN7S6962C23v11Ev
  virtual void  v12(); // _ZN7S6962C23v12Ev
  virtual void  v13(); // _ZN7S6962C23v13Ev
  virtual void  v14(); // _ZN7S6962C23v14Ev
  virtual void  v15(); // _ZN7S6962C23v15Ev
  virtual void  v16(); // _ZN7S6962C23v16Ev
  virtual void  v17(); // _ZN7S6962C23v17Ev
  virtual void  v18(); // _ZN7S6962C23v18Ev
  virtual void  v19(); // _ZN7S6962C23v19Ev
  virtual void  v20(); // _ZN7S6962C23v20Ev
  virtual void  v21(); // _ZN7S6962C23v21Ev
  virtual void  v22(); // _ZN7S6962C23v22Ev
  virtual void  v23(); // _ZN7S6962C23v23Ev
  virtual void  v24(); // _ZN7S6962C23v24Ev
  virtual void  v25(); // _ZN7S6962C23v25Ev
  virtual void  v26(); // _ZN7S6962C23v26Ev
  virtual void  v27(); // _ZN7S6962C23v27Ev
  virtual void  v28(); // _ZN7S6962C23v28Ev
  virtual void  v29(); // _ZN7S6962C23v29Ev
  virtual void  v30(); // _ZN7S6962C23v30Ev
  virtual void  v31(); // _ZN7S6962C23v31Ev
  virtual void  v32(); // _ZN7S6962C23v32Ev
  virtual void  v33(); // _ZN7S6962C23v33Ev
  virtual void  v34(); // _ZN7S6962C23v34Ev
  virtual void  v35(); // _ZN7S6962C23v35Ev
  virtual void  v36(); // _ZN7S6962C23v36Ev
  virtual void  v37(); // _ZN7S6962C23v37Ev
  virtual void  v38(); // _ZN7S6962C23v38Ev
  virtual void  v39(); // _ZN7S6962C23v39Ev
  virtual void  v40(); // _ZN7S6962C23v40Ev
  virtual void  v41(); // _ZN7S6962C23v41Ev
  virtual void  v42(); // _ZN7S6962C23v42Ev
  virtual void  v43(); // _ZN7S6962C23v43Ev
  virtual void  v44(); // _ZN7S6962C23v44Ev
  virtual void  v45(); // _ZN7S6962C23v45Ev
  virtual void  v46(); // _ZN7S6962C23v46Ev
  virtual void  v47(); // _ZN7S6962C23v47Ev
  virtual void  v48(); // _ZN7S6962C23v48Ev
  virtual void  v49(); // _ZN7S6962C23v49Ev
  virtual void  v50(); // _ZN7S6962C23v50Ev
  virtual void  v51(); // _ZN7S6962C23v51Ev
  virtual void  v52(); // _ZN7S6962C23v52Ev
  virtual void  v53(); // _ZN7S6962C23v53Ev
  virtual void  v54(); // _ZN7S6962C23v54Ev
  virtual void  v55(); // _ZN7S6962C23v55Ev
  virtual void  v56(); // _ZN7S6962C23v56Ev
  virtual void  v57(); // _ZN7S6962C23v57Ev
  virtual void  v58(); // _ZN7S6962C23v58Ev
  virtual void  v59(); // _ZN7S6962C23v59Ev
  virtual void  v60(); // _ZN7S6962C23v60Ev
  virtual void  v61(); // _ZN7S6962C23v61Ev
  virtual void  v62(); // _ZN7S6962C23v62Ev
  virtual void  v63(); // _ZN7S6962C23v63Ev
  virtual void  v64(); // _ZN7S6962C23v64Ev
  virtual void  v65(); // _ZN7S6962C23v65Ev
  virtual void  v66(); // _ZN7S6962C23v66Ev
  virtual void  v67(); // _ZN7S6962C23v67Ev
  virtual void  v68(); // _ZN7S6962C23v68Ev
  S6962C2(); // tgen
};
//SIG(-1 S6962C2) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S6962C2 ::~S6962C2(){ note_dtor("S6962C2", this);}
void  S6962C2 ::v5(){vfunc_called(this, "_ZN7S6962C22v5Ev");}
void  S6962C2 ::v6(){vfunc_called(this, "_ZN7S6962C22v6Ev");}
void  S6962C2 ::v7(){vfunc_called(this, "_ZN7S6962C22v7Ev");}
void  S6962C2 ::v8(){vfunc_called(this, "_ZN7S6962C22v8Ev");}
void  S6962C2 ::v9(){vfunc_called(this, "_ZN7S6962C22v9Ev");}
void  S6962C2 ::v10(){vfunc_called(this, "_ZN7S6962C23v10Ev");}
void  S6962C2 ::v11(){vfunc_called(this, "_ZN7S6962C23v11Ev");}
void  S6962C2 ::v12(){vfunc_called(this, "_ZN7S6962C23v12Ev");}
void  S6962C2 ::v13(){vfunc_called(this, "_ZN7S6962C23v13Ev");}
void  S6962C2 ::v14(){vfunc_called(this, "_ZN7S6962C23v14Ev");}
void  S6962C2 ::v15(){vfunc_called(this, "_ZN7S6962C23v15Ev");}
void  S6962C2 ::v16(){vfunc_called(this, "_ZN7S6962C23v16Ev");}
void  S6962C2 ::v17(){vfunc_called(this, "_ZN7S6962C23v17Ev");}
void  S6962C2 ::v18(){vfunc_called(this, "_ZN7S6962C23v18Ev");}
void  S6962C2 ::v19(){vfunc_called(this, "_ZN7S6962C23v19Ev");}
void  S6962C2 ::v20(){vfunc_called(this, "_ZN7S6962C23v20Ev");}
void  S6962C2 ::v21(){vfunc_called(this, "_ZN7S6962C23v21Ev");}
void  S6962C2 ::v22(){vfunc_called(this, "_ZN7S6962C23v22Ev");}
void  S6962C2 ::v23(){vfunc_called(this, "_ZN7S6962C23v23Ev");}
void  S6962C2 ::v24(){vfunc_called(this, "_ZN7S6962C23v24Ev");}
void  S6962C2 ::v25(){vfunc_called(this, "_ZN7S6962C23v25Ev");}
void  S6962C2 ::v26(){vfunc_called(this, "_ZN7S6962C23v26Ev");}
void  S6962C2 ::v27(){vfunc_called(this, "_ZN7S6962C23v27Ev");}
void  S6962C2 ::v28(){vfunc_called(this, "_ZN7S6962C23v28Ev");}
void  S6962C2 ::v29(){vfunc_called(this, "_ZN7S6962C23v29Ev");}
void  S6962C2 ::v30(){vfunc_called(this, "_ZN7S6962C23v30Ev");}
void  S6962C2 ::v31(){vfunc_called(this, "_ZN7S6962C23v31Ev");}
void  S6962C2 ::v32(){vfunc_called(this, "_ZN7S6962C23v32Ev");}
void  S6962C2 ::v33(){vfunc_called(this, "_ZN7S6962C23v33Ev");}
void  S6962C2 ::v34(){vfunc_called(this, "_ZN7S6962C23v34Ev");}
void  S6962C2 ::v35(){vfunc_called(this, "_ZN7S6962C23v35Ev");}
void  S6962C2 ::v36(){vfunc_called(this, "_ZN7S6962C23v36Ev");}
void  S6962C2 ::v37(){vfunc_called(this, "_ZN7S6962C23v37Ev");}
void  S6962C2 ::v38(){vfunc_called(this, "_ZN7S6962C23v38Ev");}
void  S6962C2 ::v39(){vfunc_called(this, "_ZN7S6962C23v39Ev");}
void  S6962C2 ::v40(){vfunc_called(this, "_ZN7S6962C23v40Ev");}
void  S6962C2 ::v41(){vfunc_called(this, "_ZN7S6962C23v41Ev");}
void  S6962C2 ::v42(){vfunc_called(this, "_ZN7S6962C23v42Ev");}
void  S6962C2 ::v43(){vfunc_called(this, "_ZN7S6962C23v43Ev");}
void  S6962C2 ::v44(){vfunc_called(this, "_ZN7S6962C23v44Ev");}
void  S6962C2 ::v45(){vfunc_called(this, "_ZN7S6962C23v45Ev");}
void  S6962C2 ::v46(){vfunc_called(this, "_ZN7S6962C23v46Ev");}
void  S6962C2 ::v47(){vfunc_called(this, "_ZN7S6962C23v47Ev");}
void  S6962C2 ::v48(){vfunc_called(this, "_ZN7S6962C23v48Ev");}
void  S6962C2 ::v49(){vfunc_called(this, "_ZN7S6962C23v49Ev");}
void  S6962C2 ::v50(){vfunc_called(this, "_ZN7S6962C23v50Ev");}
void  S6962C2 ::v51(){vfunc_called(this, "_ZN7S6962C23v51Ev");}
void  S6962C2 ::v52(){vfunc_called(this, "_ZN7S6962C23v52Ev");}
void  S6962C2 ::v53(){vfunc_called(this, "_ZN7S6962C23v53Ev");}
void  S6962C2 ::v54(){vfunc_called(this, "_ZN7S6962C23v54Ev");}
void  S6962C2 ::v55(){vfunc_called(this, "_ZN7S6962C23v55Ev");}
void  S6962C2 ::v56(){vfunc_called(this, "_ZN7S6962C23v56Ev");}
void  S6962C2 ::v57(){vfunc_called(this, "_ZN7S6962C23v57Ev");}
void  S6962C2 ::v58(){vfunc_called(this, "_ZN7S6962C23v58Ev");}
void  S6962C2 ::v59(){vfunc_called(this, "_ZN7S6962C23v59Ev");}
void  S6962C2 ::v60(){vfunc_called(this, "_ZN7S6962C23v60Ev");}
void  S6962C2 ::v61(){vfunc_called(this, "_ZN7S6962C23v61Ev");}
void  S6962C2 ::v62(){vfunc_called(this, "_ZN7S6962C23v62Ev");}
void  S6962C2 ::v63(){vfunc_called(this, "_ZN7S6962C23v63Ev");}
void  S6962C2 ::v64(){vfunc_called(this, "_ZN7S6962C23v64Ev");}
void  S6962C2 ::v65(){vfunc_called(this, "_ZN7S6962C23v65Ev");}
void  S6962C2 ::v66(){vfunc_called(this, "_ZN7S6962C23v66Ev");}
void  S6962C2 ::v67(){vfunc_called(this, "_ZN7S6962C23v67Ev");}
void  S6962C2 ::v68(){vfunc_called(this, "_ZN7S6962C23v68Ev");}
S6962C2 ::S6962C2(){ note_ctor("S6962C2", this);} // tgen

static void Test_S6962C2()
{
  extern Class_Descriptor cd_S6962C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S6962C2, buf);
    S6962C2 *dp, &lv = *(dp=new (buf) S6962C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S6962C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S6962C2)");
    check_field_offset(lv, s6962c2f0, ABISELECT(8,4), "S6962C2.s6962c2f0");
    check_field_offset(lv, s6962c2f1, ABISELECT(16,8), "S6962C2.s6962c2f1");
    check_field_offset(lv, s6962c2f2, ABISELECT(24,16), "S6962C2.s6962c2f2");
    check_field_offset(lv, s6962c2f3, ABISELECT(56,32), "S6962C2.s6962c2f3");
    check_field_offset(lv, s6962c2f4, ABISELECT(64,40), "S6962C2.s6962c2f4");
    check_field_offset(lv, s6962c2f5, ABISELECT(72,44), "S6962C2.s6962c2f5");
    check_field_offset(lv, s6962c2f6, ABISELECT(80,52), "S6962C2.s6962c2f6");
    test_class_info(&lv, &cd_S6962C2);
    dp->~S6962C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6962C2(Test_S6962C2, "S6962C2", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S6962C2C1Ev();
extern void _ZN7S6962C2D1Ev();
Name_Map name_map_S6962C2[] = {
  NSPAIR(_ZN7S6962C2C1Ev),
  NSPAIR(_ZN7S6962C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S6962C2[];
extern void _ZN7S6962C2D1Ev();
extern void _ZN7S6962C2D0Ev();
extern void _ZN7S6962C22v5Ev();
extern void _ZN7S6962C22v6Ev();
extern void _ZN7S6962C22v7Ev();
extern void _ZN7S6962C22v8Ev();
extern void _ZN7S6962C22v9Ev();
extern void _ZN7S6962C23v10Ev();
extern void _ZN7S6962C23v11Ev();
extern void _ZN7S6962C23v12Ev();
extern void _ZN7S6962C23v13Ev();
extern void _ZN7S6962C23v14Ev();
extern void _ZN7S6962C23v15Ev();
extern void _ZN7S6962C23v16Ev();
extern void _ZN7S6962C23v17Ev();
extern void _ZN7S6962C23v18Ev();
extern void _ZN7S6962C23v19Ev();
extern void _ZN7S6962C23v20Ev();
extern void _ZN7S6962C23v21Ev();
extern void _ZN7S6962C23v22Ev();
extern void _ZN7S6962C23v23Ev();
extern void _ZN7S6962C23v24Ev();
extern void _ZN7S6962C23v25Ev();
extern void _ZN7S6962C23v26Ev();
extern void _ZN7S6962C23v27Ev();
extern void _ZN7S6962C23v28Ev();
extern void _ZN7S6962C23v29Ev();
extern void _ZN7S6962C23v30Ev();
extern void _ZN7S6962C23v31Ev();
extern void _ZN7S6962C23v32Ev();
extern void _ZN7S6962C23v33Ev();
extern void _ZN7S6962C23v34Ev();
extern void _ZN7S6962C23v35Ev();
extern void _ZN7S6962C23v36Ev();
extern void _ZN7S6962C23v37Ev();
extern void _ZN7S6962C23v38Ev();
extern void _ZN7S6962C23v39Ev();
extern void _ZN7S6962C23v40Ev();
extern void _ZN7S6962C23v41Ev();
extern void _ZN7S6962C23v42Ev();
extern void _ZN7S6962C23v43Ev();
extern void _ZN7S6962C23v44Ev();
extern void _ZN7S6962C23v45Ev();
extern void _ZN7S6962C23v46Ev();
extern void _ZN7S6962C23v47Ev();
extern void _ZN7S6962C23v48Ev();
extern void _ZN7S6962C23v49Ev();
extern void _ZN7S6962C23v50Ev();
extern void _ZN7S6962C23v51Ev();
extern void _ZN7S6962C23v52Ev();
extern void _ZN7S6962C23v53Ev();
extern void _ZN7S6962C23v54Ev();
extern void _ZN7S6962C23v55Ev();
extern void _ZN7S6962C23v56Ev();
extern void _ZN7S6962C23v57Ev();
extern void _ZN7S6962C23v58Ev();
extern void _ZN7S6962C23v59Ev();
extern void _ZN7S6962C23v60Ev();
extern void _ZN7S6962C23v61Ev();
extern void _ZN7S6962C23v62Ev();
extern void _ZN7S6962C23v63Ev();
extern void _ZN7S6962C23v64Ev();
extern void _ZN7S6962C23v65Ev();
extern void _ZN7S6962C23v66Ev();
extern void _ZN7S6962C23v67Ev();
extern void _ZN7S6962C23v68Ev();
static  VTBL_ENTRY vtc_S6962C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S6962C2[0]),
  (VTBL_ENTRY)&_ZN7S6962C2D1Ev,
  (VTBL_ENTRY)&_ZN7S6962C2D0Ev,
  (VTBL_ENTRY)&_ZN7S6962C22v5Ev,
  (VTBL_ENTRY)&_ZN7S6962C22v6Ev,
  (VTBL_ENTRY)&_ZN7S6962C22v7Ev,
  (VTBL_ENTRY)&_ZN7S6962C22v8Ev,
  (VTBL_ENTRY)&_ZN7S6962C22v9Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v10Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v11Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v12Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v13Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v14Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v15Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v16Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v17Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v18Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v19Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v20Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v21Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v22Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v23Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v24Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v25Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v26Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v27Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v28Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v29Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v30Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v31Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v32Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v33Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v34Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v35Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v36Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v37Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v38Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v39Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v40Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v41Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v42Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v43Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v44Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v45Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v46Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v47Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v48Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v49Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v50Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v51Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v52Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v53Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v54Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v55Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v56Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v57Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v58Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v59Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v60Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v61Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v62Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v63Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v64Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v65Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v66Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v67Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v68Ev,
};
extern VTBL_ENTRY _ZTI7S6962C2[];
extern  VTBL_ENTRY _ZTV7S6962C2[];
Class_Descriptor cd_S6962C2 = {  "S6962C2", // class name
  0,0,//no base classes
  &(vtc_S6962C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S6962C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S6962C2),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6962C10_nt  {
  char s6962c10f0[4];
  ::S3352C11 s6962c10f1;
  int s6962c10f2[2];
  void  mf6962c10(); // _ZN11S6962C10_nt9mf6962c10Ev
};
//SIG(-1 S6962C10_nt) C1{ m Fc[4] FC2{ BC3{ BC4{ m Fp Fi[2]}}} Fi[2]}


void  S6962C10_nt ::mf6962c10(){}

//skip512 S6962C10_nt

#else // __cplusplus

Class_Descriptor cd_S6962C10_nt = {  "S6962C10_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6962C9_nt  : S6962C10_nt {
  void *s6962c9f0;
};
//SIG(-1 S6962C9_nt) C1{ BC2{ m Fc[4] FC3{ BC4{ BC5{ m Fp Fi[2]}}} Fi[2]} Fp}



//skip512 S6962C9_nt

#else // __cplusplus

extern Class_Descriptor cd_S6962C10_nt;
static Base_Class bases_S6962C9_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S6962C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6962C4  {
  ::S3352C4_nt s6962c4f0;
  int s6962c4f1;
  unsigned int s6962c4f2:1;
  unsigned int s6962c4f3:1;
  unsigned int s6962c4f4:1;
  unsigned int s6962c4f5:1;
  ::S3352C13_nt s6962c4f6;
  ::S3352C17 s6962c4f7;
  ::S6962C9_nt s6962c4f8;
  ::S6962C9_nt s6962c4f9;
  ::S6962C9_nt s6962c4f10;
  ::S6962C9_nt s6962c4f11;
  ::S6962C9_nt s6962c4f12;
  ::S6962C9_nt s6962c4f13;
  ::S6962C9_nt s6962c4f14;
  ::S6962C9_nt s6962c4f15;
  ::S6962C9_nt s6962c4f16;
  ::S6962C9_nt s6962c4f17;
  void  mf6962c4(); // _ZN7S6962C48mf6962c4Ev
};
//SIG(-1 S6962C4) C1{ m FC2{ m Fi[2]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC3{ m Fi[3]} FC4{ BC5{ BC6{ m Fp Fi[2]}}} FC7{ BC8{ m Fc[4] FC9{ BC10{ BC6}} Fi[2]} Fp} FC7 FC7 FC7 FC7 FC7 FC7 FC7 FC7 FC7}


void  S6962C4 ::mf6962c4(){}

static void Test_S6962C4()
{
  {
    init_simple_test("S6962C4");
    static S6962C4 lv;
    check2(sizeof(lv), ABISELECT(448,320), "sizeof(S6962C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S6962C4)");
    check_field_offset(lv, s6962c4f0, 0, "S6962C4.s6962c4f0");
    check_field_offset(lv, s6962c4f1, 8, "S6962C4.s6962c4f1");
    set_bf_and_test(lv, s6962c4f2, 12, 0, 1, 1, "S6962C4");
    set_bf_and_test(lv, s6962c4f3, 12, 1, 1, 1, "S6962C4");
    set_bf_and_test(lv, s6962c4f4, 12, 2, 1, 1, "S6962C4");
    set_bf_and_test(lv, s6962c4f5, 12, 3, 1, 1, "S6962C4");
    check_field_offset(lv, s6962c4f6, 16, "S6962C4.s6962c4f6");
    check_field_offset(lv, s6962c4f7, ABISELECT(32,28), "S6962C4.s6962c4f7");
    check_field_offset(lv, s6962c4f8, ABISELECT(48,40), "S6962C4.s6962c4f8");
    check_field_offset(lv, s6962c4f9, ABISELECT(88,68), "S6962C4.s6962c4f9");
    check_field_offset(lv, s6962c4f10, ABISELECT(128,96), "S6962C4.s6962c4f10");
    check_field_offset(lv, s6962c4f11, ABISELECT(168,124), "S6962C4.s6962c4f11");
    check_field_offset(lv, s6962c4f12, ABISELECT(208,152), "S6962C4.s6962c4f12");
    check_field_offset(lv, s6962c4f13, ABISELECT(248,180), "S6962C4.s6962c4f13");
    check_field_offset(lv, s6962c4f14, ABISELECT(288,208), "S6962C4.s6962c4f14");
    check_field_offset(lv, s6962c4f15, ABISELECT(328,236), "S6962C4.s6962c4f15");
    check_field_offset(lv, s6962c4f16, ABISELECT(368,264), "S6962C4.s6962c4f16");
    check_field_offset(lv, s6962c4f17, ABISELECT(408,292), "S6962C4.s6962c4f17");
  }
}
static Arrange_To_Call_Me vS6962C4(Test_S6962C4, "S6962C4", ABISELECT(448,320));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6962C16_nt  {
  ::S3352C13_nt s6962c16f0;
  ::S3352C13_nt s6962c16f1;
  char s6962c16f2;
  void  mf6962c16(); // _ZN11S6962C16_nt9mf6962c16Ev
};
//SIG(-1 S6962C16_nt) C1{ m FC2{ m Fi[3]} FC2 Fc}


void  S6962C16_nt ::mf6962c16(){}

//skip512 S6962C16_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6962C17_nt  {
  int s6962c17f0[3];
  void  mf6962c17(); // _ZN11S6962C17_nt9mf6962c17Ev
};
//SIG(-1 S6962C17_nt) C1{ m Fi[3]}


void  S6962C17_nt ::mf6962c17(){}

//skip512 S6962C17_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6962C1  : S6962C2 {
  ::S6962C4 s6962c1f0;
  void *s6962c1f1;
  char s6962c1f2[2];
  ::S3352C5_nt s6962c1f3;
  int s6962c1f4[4];
  ::S6962C9_nt s6962c1f5;
  unsigned int s6962c1f6:1;
  unsigned int s6962c1f7:1;
  unsigned int s6962c1f8:1;
  ::S6962C16_nt s6962c1f9;
  void *s6962c1f10;
  int s6962c1f11;
  ::S6962C17_nt s6962c1f12;
  int s6962c1f13;
  void *s6962c1f14;
  virtual  ~S6962C1(); // _ZN7S6962C1D1Ev
  virtual void  v1(); // _ZN7S6962C12v1Ev
  virtual void  v2(); // _ZN7S6962C12v2Ev
  virtual void  v3(); // _ZN7S6962C12v3Ev
  virtual void  v4(); // _ZN7S6962C12v4Ev
  S6962C1(); // tgen
};
//SIG(1 S6962C1) C1{ BC2{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 FC4{ m FC3 Fi Fi:1 Fi:1 Fi:1 Fi:1 FC5{ m Fi[3]} FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC9{ BC10{ m Fc[4] FC11{ BC12{ BC8}} Fi[2]} Fp} FC9 FC9 FC9 FC9 FC9 FC9 FC9 FC9 FC9} Fp Fc[2] FC13{ BC14{ BC8}} Fi[4] FC9 Fi:1 Fi:1 Fi:1 FC15{ m FC5 FC5 Fc} Fp Fi FC16{ m Fi[3]} Fi Fp}


 S6962C1 ::~S6962C1(){ note_dtor("S6962C1", this);}
void  S6962C1 ::v1(){vfunc_called(this, "_ZN7S6962C12v1Ev");}
void  S6962C1 ::v2(){vfunc_called(this, "_ZN7S6962C12v2Ev");}
void  S6962C1 ::v3(){vfunc_called(this, "_ZN7S6962C12v3Ev");}
void  S6962C1 ::v4(){vfunc_called(this, "_ZN7S6962C12v4Ev");}
S6962C1 ::S6962C1(){ note_ctor("S6962C1", this);} // tgen

static void Test_S6962C1()
{
  extern Class_Descriptor cd_S6962C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(89,127)];
    init_test(&cd_S6962C1, buf);
    S6962C1 *dp, &lv = *(dp=new (buf) S6962C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(704,504), "sizeof(S6962C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S6962C1)");
    check_base_class_offset(lv, (S6962C2*), 0, "S6962C1");
    check_field_offset(lv, s6962c1f0, ABISELECT(96,60), "S6962C1.s6962c1f0");
    check_field_offset(lv, s6962c1f1, ABISELECT(544,380), "S6962C1.s6962c1f1");
    check_field_offset(lv, s6962c1f2, ABISELECT(552,384), "S6962C1.s6962c1f2");
    check_field_offset(lv, s6962c1f3, ABISELECT(560,388), "S6962C1.s6962c1f3");
    check_field_offset(lv, s6962c1f4, ABISELECT(576,400), "S6962C1.s6962c1f4");
    check_field_offset(lv, s6962c1f5, ABISELECT(592,416), "S6962C1.s6962c1f5");
    set_bf_and_test(lv, s6962c1f6, ABISELECT(632,444), 0, 1, 1, "S6962C1");
    set_bf_and_test(lv, s6962c1f7, ABISELECT(632,444), 1, 1, 1, "S6962C1");
    set_bf_and_test(lv, s6962c1f8, ABISELECT(632,444), 2, 1, 1, "S6962C1");
    check_field_offset(lv, s6962c1f9, ABISELECT(636,448), "S6962C1.s6962c1f9");
    check_field_offset(lv, s6962c1f10, ABISELECT(664,476), "S6962C1.s6962c1f10");
    check_field_offset(lv, s6962c1f11, ABISELECT(672,480), "S6962C1.s6962c1f11");
    check_field_offset(lv, s6962c1f12, ABISELECT(676,484), "S6962C1.s6962c1f12");
    check_field_offset(lv, s6962c1f13, ABISELECT(688,496), "S6962C1.s6962c1f13");
    check_field_offset(lv, s6962c1f14, ABISELECT(696,500), "S6962C1.s6962c1f14");
    test_class_info(&lv, &cd_S6962C1);
    dp->~S6962C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6962C1(Test_S6962C1, "S6962C1", ABISELECT(704,504));

#else // __cplusplus

extern void _ZN7S6962C1C1Ev();
extern void _ZN7S6962C1D1Ev();
Name_Map name_map_S6962C1[] = {
  NSPAIR(_ZN7S6962C1C1Ev),
  NSPAIR(_ZN7S6962C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S6962C2;
extern VTBL_ENTRY _ZTI7S6962C2[];
extern  VTBL_ENTRY _ZTV7S6962C2[];
static Base_Class bases_S6962C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S6962C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S6962C1[];
extern void _ZN7S6962C1D1Ev();
extern void _ZN7S6962C1D0Ev();
extern void _ZN7S6962C22v5Ev();
extern void _ZN7S6962C22v6Ev();
extern void _ZN7S6962C22v7Ev();
extern void _ZN7S6962C22v8Ev();
extern void _ZN7S6962C22v9Ev();
extern void _ZN7S6962C23v10Ev();
extern void _ZN7S6962C23v11Ev();
extern void _ZN7S6962C23v12Ev();
extern void _ZN7S6962C23v13Ev();
extern void _ZN7S6962C23v14Ev();
extern void _ZN7S6962C23v15Ev();
extern void _ZN7S6962C23v16Ev();
extern void _ZN7S6962C23v17Ev();
extern void _ZN7S6962C23v18Ev();
extern void _ZN7S6962C23v19Ev();
extern void _ZN7S6962C23v20Ev();
extern void _ZN7S6962C23v21Ev();
extern void _ZN7S6962C23v22Ev();
extern void _ZN7S6962C23v23Ev();
extern void _ZN7S6962C23v24Ev();
extern void _ZN7S6962C23v25Ev();
extern void _ZN7S6962C23v26Ev();
extern void _ZN7S6962C23v27Ev();
extern void _ZN7S6962C23v28Ev();
extern void _ZN7S6962C23v29Ev();
extern void _ZN7S6962C23v30Ev();
extern void _ZN7S6962C23v31Ev();
extern void _ZN7S6962C23v32Ev();
extern void _ZN7S6962C23v33Ev();
extern void _ZN7S6962C23v34Ev();
extern void _ZN7S6962C23v35Ev();
extern void _ZN7S6962C23v36Ev();
extern void _ZN7S6962C23v37Ev();
extern void _ZN7S6962C23v38Ev();
extern void _ZN7S6962C23v39Ev();
extern void _ZN7S6962C23v40Ev();
extern void _ZN7S6962C23v41Ev();
extern void _ZN7S6962C23v42Ev();
extern void _ZN7S6962C23v43Ev();
extern void _ZN7S6962C23v44Ev();
extern void _ZN7S6962C23v45Ev();
extern void _ZN7S6962C23v46Ev();
extern void _ZN7S6962C23v47Ev();
extern void _ZN7S6962C23v48Ev();
extern void _ZN7S6962C23v49Ev();
extern void _ZN7S6962C23v50Ev();
extern void _ZN7S6962C23v51Ev();
extern void _ZN7S6962C23v52Ev();
extern void _ZN7S6962C23v53Ev();
extern void _ZN7S6962C23v54Ev();
extern void _ZN7S6962C23v55Ev();
extern void _ZN7S6962C23v56Ev();
extern void _ZN7S6962C23v57Ev();
extern void _ZN7S6962C23v58Ev();
extern void _ZN7S6962C23v59Ev();
extern void _ZN7S6962C23v60Ev();
extern void _ZN7S6962C23v61Ev();
extern void _ZN7S6962C23v62Ev();
extern void _ZN7S6962C23v63Ev();
extern void _ZN7S6962C23v64Ev();
extern void _ZN7S6962C23v65Ev();
extern void _ZN7S6962C23v66Ev();
extern void _ZN7S6962C23v67Ev();
extern void _ZN7S6962C23v68Ev();
extern void _ZN7S6962C12v1Ev();
extern void _ZN7S6962C12v2Ev();
extern void _ZN7S6962C12v3Ev();
extern void _ZN7S6962C12v4Ev();
static  VTBL_ENTRY vtc_S6962C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S6962C1[0]),
  (VTBL_ENTRY)&_ZN7S6962C1D1Ev,
  (VTBL_ENTRY)&_ZN7S6962C1D0Ev,
  (VTBL_ENTRY)&_ZN7S6962C22v5Ev,
  (VTBL_ENTRY)&_ZN7S6962C22v6Ev,
  (VTBL_ENTRY)&_ZN7S6962C22v7Ev,
  (VTBL_ENTRY)&_ZN7S6962C22v8Ev,
  (VTBL_ENTRY)&_ZN7S6962C22v9Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v10Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v11Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v12Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v13Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v14Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v15Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v16Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v17Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v18Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v19Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v20Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v21Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v22Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v23Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v24Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v25Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v26Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v27Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v28Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v29Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v30Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v31Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v32Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v33Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v34Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v35Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v36Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v37Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v38Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v39Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v40Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v41Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v42Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v43Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v44Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v45Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v46Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v47Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v48Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v49Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v50Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v51Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v52Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v53Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v54Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v55Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v56Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v57Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v58Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v59Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v60Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v61Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v62Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v63Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v64Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v65Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v66Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v67Ev,
  (VTBL_ENTRY)&_ZN7S6962C23v68Ev,
  (VTBL_ENTRY)&_ZN7S6962C12v1Ev,
  (VTBL_ENTRY)&_ZN7S6962C12v2Ev,
  (VTBL_ENTRY)&_ZN7S6962C12v3Ev,
  (VTBL_ENTRY)&_ZN7S6962C12v4Ev,
};
extern VTBL_ENTRY _ZTI7S6962C1[];
extern  VTBL_ENTRY _ZTV7S6962C1[];
Class_Descriptor cd_S6962C1 = {  "S6962C1", // class name
  bases_S6962C1, 1,
  &(vtc_S6962C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(704,504), // object size
  NSPAIRA(_ZTI7S6962C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S6962C1),72, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1522C4  {
  int s1522c4f0;
  __tsi64 s1522c4f1;
  void *s1522c4f2[4];
  int s1522c4f3[2];
  void *s1522c4f4;
  ::S3352C4_nt s1522c4f5;
  void *s1522c4f6[2];
  virtual  ~S1522C4(); // _ZN7S1522C4D1Ev
  virtual void  v6(); // _ZN7S1522C42v6Ev
  virtual void  v7(); // _ZN7S1522C42v7Ev
  virtual void  v8(); // _ZN7S1522C42v8Ev
  virtual void  v9(); // _ZN7S1522C42v9Ev
  virtual void  v10(); // _ZN7S1522C43v10Ev
  virtual void  v11(); // _ZN7S1522C43v11Ev
  virtual void  v12(); // _ZN7S1522C43v12Ev
  virtual void  v13(); // _ZN7S1522C43v13Ev
  virtual void  v14(); // _ZN7S1522C43v14Ev
  virtual void  v15(); // _ZN7S1522C43v15Ev
  virtual void  v16(); // _ZN7S1522C43v16Ev
  virtual void  v17(); // _ZN7S1522C43v17Ev
  virtual void  v18(); // _ZN7S1522C43v18Ev
  virtual void  v19(); // _ZN7S1522C43v19Ev
  virtual void  v20(); // _ZN7S1522C43v20Ev
  virtual void  v21(); // _ZN7S1522C43v21Ev
  virtual void  v22(); // _ZN7S1522C43v22Ev
  virtual void  v23(); // _ZN7S1522C43v23Ev
  virtual void  v24(); // _ZN7S1522C43v24Ev
  virtual void  v25(); // _ZN7S1522C43v25Ev
  virtual void  v26(); // _ZN7S1522C43v26Ev
  virtual void  v27(); // _ZN7S1522C43v27Ev
  virtual void  v28(); // _ZN7S1522C43v28Ev
  virtual void  v29(); // _ZN7S1522C43v29Ev
  virtual void  v30(); // _ZN7S1522C43v30Ev
  virtual void  v31(); // _ZN7S1522C43v31Ev
  virtual void  v32(); // _ZN7S1522C43v32Ev
  virtual void  v33(); // _ZN7S1522C43v33Ev
  virtual void  v34(); // _ZN7S1522C43v34Ev
  virtual void  v35(); // _ZN7S1522C43v35Ev
  virtual void  v36(); // _ZN7S1522C43v36Ev
  virtual void  v37(); // _ZN7S1522C43v37Ev
  virtual void  v38(); // _ZN7S1522C43v38Ev
  virtual void  v39(); // _ZN7S1522C43v39Ev
  virtual void  v40(); // _ZN7S1522C43v40Ev
  virtual void  v41(); // _ZN7S1522C43v41Ev
  virtual void  v42(); // _ZN7S1522C43v42Ev
  virtual void  v43(); // _ZN7S1522C43v43Ev
  virtual void  v44(); // _ZN7S1522C43v44Ev
  virtual void  v45(); // _ZN7S1522C43v45Ev
  virtual void  v46(); // _ZN7S1522C43v46Ev
  virtual void  v47(); // _ZN7S1522C43v47Ev
  virtual void  v48(); // _ZN7S1522C43v48Ev
  virtual void  v49(); // _ZN7S1522C43v49Ev
  virtual void  v50(); // _ZN7S1522C43v50Ev
  virtual void  v51(); // _ZN7S1522C43v51Ev
  virtual void  v52(); // _ZN7S1522C43v52Ev
  virtual void  v53(); // _ZN7S1522C43v53Ev
  virtual void  v54(); // _ZN7S1522C43v54Ev
  virtual void  v55(); // _ZN7S1522C43v55Ev
  virtual void  v56(); // _ZN7S1522C43v56Ev
  virtual void  v57(); // _ZN7S1522C43v57Ev
  virtual void  v58(); // _ZN7S1522C43v58Ev
  virtual void  v59(); // _ZN7S1522C43v59Ev
  virtual void  v60(); // _ZN7S1522C43v60Ev
  virtual void  v61(); // _ZN7S1522C43v61Ev
  virtual void  v62(); // _ZN7S1522C43v62Ev
  virtual void  v63(); // _ZN7S1522C43v63Ev
  virtual void  v64(); // _ZN7S1522C43v64Ev
  virtual void  v65(); // _ZN7S1522C43v65Ev
  virtual void  v66(); // _ZN7S1522C43v66Ev
  virtual void  v67(); // _ZN7S1522C43v67Ev
  virtual void  v68(); // _ZN7S1522C43v68Ev
  virtual void  v69(); // _ZN7S1522C43v69Ev
  S1522C4(); // tgen
};
//SIG(-1 S1522C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1522C4 ::~S1522C4(){ note_dtor("S1522C4", this);}
void  S1522C4 ::v6(){vfunc_called(this, "_ZN7S1522C42v6Ev");}
void  S1522C4 ::v7(){vfunc_called(this, "_ZN7S1522C42v7Ev");}
void  S1522C4 ::v8(){vfunc_called(this, "_ZN7S1522C42v8Ev");}
void  S1522C4 ::v9(){vfunc_called(this, "_ZN7S1522C42v9Ev");}
void  S1522C4 ::v10(){vfunc_called(this, "_ZN7S1522C43v10Ev");}
void  S1522C4 ::v11(){vfunc_called(this, "_ZN7S1522C43v11Ev");}
void  S1522C4 ::v12(){vfunc_called(this, "_ZN7S1522C43v12Ev");}
void  S1522C4 ::v13(){vfunc_called(this, "_ZN7S1522C43v13Ev");}
void  S1522C4 ::v14(){vfunc_called(this, "_ZN7S1522C43v14Ev");}
void  S1522C4 ::v15(){vfunc_called(this, "_ZN7S1522C43v15Ev");}
void  S1522C4 ::v16(){vfunc_called(this, "_ZN7S1522C43v16Ev");}
void  S1522C4 ::v17(){vfunc_called(this, "_ZN7S1522C43v17Ev");}
void  S1522C4 ::v18(){vfunc_called(this, "_ZN7S1522C43v18Ev");}
void  S1522C4 ::v19(){vfunc_called(this, "_ZN7S1522C43v19Ev");}
void  S1522C4 ::v20(){vfunc_called(this, "_ZN7S1522C43v20Ev");}
void  S1522C4 ::v21(){vfunc_called(this, "_ZN7S1522C43v21Ev");}
void  S1522C4 ::v22(){vfunc_called(this, "_ZN7S1522C43v22Ev");}
void  S1522C4 ::v23(){vfunc_called(this, "_ZN7S1522C43v23Ev");}
void  S1522C4 ::v24(){vfunc_called(this, "_ZN7S1522C43v24Ev");}
void  S1522C4 ::v25(){vfunc_called(this, "_ZN7S1522C43v25Ev");}
void  S1522C4 ::v26(){vfunc_called(this, "_ZN7S1522C43v26Ev");}
void  S1522C4 ::v27(){vfunc_called(this, "_ZN7S1522C43v27Ev");}
void  S1522C4 ::v28(){vfunc_called(this, "_ZN7S1522C43v28Ev");}
void  S1522C4 ::v29(){vfunc_called(this, "_ZN7S1522C43v29Ev");}
void  S1522C4 ::v30(){vfunc_called(this, "_ZN7S1522C43v30Ev");}
void  S1522C4 ::v31(){vfunc_called(this, "_ZN7S1522C43v31Ev");}
void  S1522C4 ::v32(){vfunc_called(this, "_ZN7S1522C43v32Ev");}
void  S1522C4 ::v33(){vfunc_called(this, "_ZN7S1522C43v33Ev");}
void  S1522C4 ::v34(){vfunc_called(this, "_ZN7S1522C43v34Ev");}
void  S1522C4 ::v35(){vfunc_called(this, "_ZN7S1522C43v35Ev");}
void  S1522C4 ::v36(){vfunc_called(this, "_ZN7S1522C43v36Ev");}
void  S1522C4 ::v37(){vfunc_called(this, "_ZN7S1522C43v37Ev");}
void  S1522C4 ::v38(){vfunc_called(this, "_ZN7S1522C43v38Ev");}
void  S1522C4 ::v39(){vfunc_called(this, "_ZN7S1522C43v39Ev");}
void  S1522C4 ::v40(){vfunc_called(this, "_ZN7S1522C43v40Ev");}
void  S1522C4 ::v41(){vfunc_called(this, "_ZN7S1522C43v41Ev");}
void  S1522C4 ::v42(){vfunc_called(this, "_ZN7S1522C43v42Ev");}
void  S1522C4 ::v43(){vfunc_called(this, "_ZN7S1522C43v43Ev");}
void  S1522C4 ::v44(){vfunc_called(this, "_ZN7S1522C43v44Ev");}
void  S1522C4 ::v45(){vfunc_called(this, "_ZN7S1522C43v45Ev");}
void  S1522C4 ::v46(){vfunc_called(this, "_ZN7S1522C43v46Ev");}
void  S1522C4 ::v47(){vfunc_called(this, "_ZN7S1522C43v47Ev");}
void  S1522C4 ::v48(){vfunc_called(this, "_ZN7S1522C43v48Ev");}
void  S1522C4 ::v49(){vfunc_called(this, "_ZN7S1522C43v49Ev");}
void  S1522C4 ::v50(){vfunc_called(this, "_ZN7S1522C43v50Ev");}
void  S1522C4 ::v51(){vfunc_called(this, "_ZN7S1522C43v51Ev");}
void  S1522C4 ::v52(){vfunc_called(this, "_ZN7S1522C43v52Ev");}
void  S1522C4 ::v53(){vfunc_called(this, "_ZN7S1522C43v53Ev");}
void  S1522C4 ::v54(){vfunc_called(this, "_ZN7S1522C43v54Ev");}
void  S1522C4 ::v55(){vfunc_called(this, "_ZN7S1522C43v55Ev");}
void  S1522C4 ::v56(){vfunc_called(this, "_ZN7S1522C43v56Ev");}
void  S1522C4 ::v57(){vfunc_called(this, "_ZN7S1522C43v57Ev");}
void  S1522C4 ::v58(){vfunc_called(this, "_ZN7S1522C43v58Ev");}
void  S1522C4 ::v59(){vfunc_called(this, "_ZN7S1522C43v59Ev");}
void  S1522C4 ::v60(){vfunc_called(this, "_ZN7S1522C43v60Ev");}
void  S1522C4 ::v61(){vfunc_called(this, "_ZN7S1522C43v61Ev");}
void  S1522C4 ::v62(){vfunc_called(this, "_ZN7S1522C43v62Ev");}
void  S1522C4 ::v63(){vfunc_called(this, "_ZN7S1522C43v63Ev");}
void  S1522C4 ::v64(){vfunc_called(this, "_ZN7S1522C43v64Ev");}
void  S1522C4 ::v65(){vfunc_called(this, "_ZN7S1522C43v65Ev");}
void  S1522C4 ::v66(){vfunc_called(this, "_ZN7S1522C43v66Ev");}
void  S1522C4 ::v67(){vfunc_called(this, "_ZN7S1522C43v67Ev");}
void  S1522C4 ::v68(){vfunc_called(this, "_ZN7S1522C43v68Ev");}
void  S1522C4 ::v69(){vfunc_called(this, "_ZN7S1522C43v69Ev");}
S1522C4 ::S1522C4(){ note_ctor("S1522C4", this);} // tgen

static void Test_S1522C4()
{
  extern Class_Descriptor cd_S1522C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1522C4, buf);
    S1522C4 *dp, &lv = *(dp=new (buf) S1522C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1522C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1522C4)");
    check_field_offset(lv, s1522c4f0, ABISELECT(8,4), "S1522C4.s1522c4f0");
    check_field_offset(lv, s1522c4f1, ABISELECT(16,8), "S1522C4.s1522c4f1");
    check_field_offset(lv, s1522c4f2, ABISELECT(24,16), "S1522C4.s1522c4f2");
    check_field_offset(lv, s1522c4f3, ABISELECT(56,32), "S1522C4.s1522c4f3");
    check_field_offset(lv, s1522c4f4, ABISELECT(64,40), "S1522C4.s1522c4f4");
    check_field_offset(lv, s1522c4f5, ABISELECT(72,44), "S1522C4.s1522c4f5");
    check_field_offset(lv, s1522c4f6, ABISELECT(80,52), "S1522C4.s1522c4f6");
    test_class_info(&lv, &cd_S1522C4);
    dp->~S1522C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1522C4(Test_S1522C4, "S1522C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1522C4C1Ev();
extern void _ZN7S1522C4D1Ev();
Name_Map name_map_S1522C4[] = {
  NSPAIR(_ZN7S1522C4C1Ev),
  NSPAIR(_ZN7S1522C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1522C4[];
extern void _ZN7S1522C4D1Ev();
extern void _ZN7S1522C4D0Ev();
extern void _ZN7S1522C42v6Ev();
extern void _ZN7S1522C42v7Ev();
extern void _ZN7S1522C42v8Ev();
extern void _ZN7S1522C42v9Ev();
extern void _ZN7S1522C43v10Ev();
extern void _ZN7S1522C43v11Ev();
extern void _ZN7S1522C43v12Ev();
extern void _ZN7S1522C43v13Ev();
extern void _ZN7S1522C43v14Ev();
extern void _ZN7S1522C43v15Ev();
extern void _ZN7S1522C43v16Ev();
extern void _ZN7S1522C43v17Ev();
extern void _ZN7S1522C43v18Ev();
extern void _ZN7S1522C43v19Ev();
extern void _ZN7S1522C43v20Ev();
extern void _ZN7S1522C43v21Ev();
extern void _ZN7S1522C43v22Ev();
extern void _ZN7S1522C43v23Ev();
extern void _ZN7S1522C43v24Ev();
extern void _ZN7S1522C43v25Ev();
extern void _ZN7S1522C43v26Ev();
extern void _ZN7S1522C43v27Ev();
extern void _ZN7S1522C43v28Ev();
extern void _ZN7S1522C43v29Ev();
extern void _ZN7S1522C43v30Ev();
extern void _ZN7S1522C43v31Ev();
extern void _ZN7S1522C43v32Ev();
extern void _ZN7S1522C43v33Ev();
extern void _ZN7S1522C43v34Ev();
extern void _ZN7S1522C43v35Ev();
extern void _ZN7S1522C43v36Ev();
extern void _ZN7S1522C43v37Ev();
extern void _ZN7S1522C43v38Ev();
extern void _ZN7S1522C43v39Ev();
extern void _ZN7S1522C43v40Ev();
extern void _ZN7S1522C43v41Ev();
extern void _ZN7S1522C43v42Ev();
extern void _ZN7S1522C43v43Ev();
extern void _ZN7S1522C43v44Ev();
extern void _ZN7S1522C43v45Ev();
extern void _ZN7S1522C43v46Ev();
extern void _ZN7S1522C43v47Ev();
extern void _ZN7S1522C43v48Ev();
extern void _ZN7S1522C43v49Ev();
extern void _ZN7S1522C43v50Ev();
extern void _ZN7S1522C43v51Ev();
extern void _ZN7S1522C43v52Ev();
extern void _ZN7S1522C43v53Ev();
extern void _ZN7S1522C43v54Ev();
extern void _ZN7S1522C43v55Ev();
extern void _ZN7S1522C43v56Ev();
extern void _ZN7S1522C43v57Ev();
extern void _ZN7S1522C43v58Ev();
extern void _ZN7S1522C43v59Ev();
extern void _ZN7S1522C43v60Ev();
extern void _ZN7S1522C43v61Ev();
extern void _ZN7S1522C43v62Ev();
extern void _ZN7S1522C43v63Ev();
extern void _ZN7S1522C43v64Ev();
extern void _ZN7S1522C43v65Ev();
extern void _ZN7S1522C43v66Ev();
extern void _ZN7S1522C43v67Ev();
extern void _ZN7S1522C43v68Ev();
extern void _ZN7S1522C43v69Ev();
static  VTBL_ENTRY vtc_S1522C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1522C4[0]),
  (VTBL_ENTRY)&_ZN7S1522C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1522C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1522C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1522C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1522C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1522C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v69Ev,
};
extern VTBL_ENTRY _ZTI7S1522C4[];
extern  VTBL_ENTRY _ZTV7S1522C4[];
Class_Descriptor cd_S1522C4 = {  "S1522C4", // class name
  0,0,//no base classes
  &(vtc_S1522C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1522C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1522C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1522C3_nt  : S1522C4 {
  unsigned int s1522c3f0:1;
  unsigned int s1522c3f1:1;
  unsigned int s1522c3f2:1;
  unsigned int s1522c3f3:1;
  unsigned int s1522c3f4:1;
  unsigned int s1522c3f5:1;
  unsigned int s1522c3f6:1;
  ::S3352C21_nt s1522c3f7;
  virtual  ~S1522C3_nt(); // _ZN10S1522C3_ntD1Ev
  virtual void  v70(); // _ZN10S1522C3_nt3v70Ev
  virtual void  v71(); // _ZN10S1522C3_nt3v71Ev
  virtual void  v72(); // _ZN10S1522C3_nt3v72Ev
  virtual void  v73(); // _ZN10S1522C3_nt3v73Ev
  virtual void  v74(); // _ZN10S1522C3_nt3v74Ev
  virtual void  v75(); // _ZN10S1522C3_nt3v75Ev
  virtual void  v76(); // _ZN10S1522C3_nt3v76Ev
  virtual void  v77(); // _ZN10S1522C3_nt3v77Ev
  virtual void  v78(); // _ZN10S1522C3_nt3v78Ev
  virtual void  v79(); // _ZN10S1522C3_nt3v79Ev
  virtual void  v80(); // _ZN10S1522C3_nt3v80Ev
  virtual void  v81(); // _ZN10S1522C3_nt3v81Ev
  virtual void  v82(); // _ZN10S1522C3_nt3v82Ev
  virtual void  v83(); // _ZN10S1522C3_nt3v83Ev
  virtual void  v84(); // _ZN10S1522C3_nt3v84Ev
  virtual void  v85(); // _ZN10S1522C3_nt3v85Ev
  virtual void  v86(); // _ZN10S1522C3_nt3v86Ev
  virtual void  v87(); // _ZN10S1522C3_nt3v87Ev
  virtual void  v88(); // _ZN10S1522C3_nt3v88Ev
  virtual void  v89(); // _ZN10S1522C3_nt3v89Ev
  S1522C3_nt(); // tgen
};
//SIG(-1 S1522C3_nt) C1{ BC2{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC4{ m}}


 S1522C3_nt ::~S1522C3_nt(){ note_dtor("S1522C3_nt", this);}
void  S1522C3_nt ::v70(){vfunc_called(this, "_ZN10S1522C3_nt3v70Ev");}
void  S1522C3_nt ::v71(){vfunc_called(this, "_ZN10S1522C3_nt3v71Ev");}
void  S1522C3_nt ::v72(){vfunc_called(this, "_ZN10S1522C3_nt3v72Ev");}
void  S1522C3_nt ::v73(){vfunc_called(this, "_ZN10S1522C3_nt3v73Ev");}
void  S1522C3_nt ::v74(){vfunc_called(this, "_ZN10S1522C3_nt3v74Ev");}
void  S1522C3_nt ::v75(){vfunc_called(this, "_ZN10S1522C3_nt3v75Ev");}
void  S1522C3_nt ::v76(){vfunc_called(this, "_ZN10S1522C3_nt3v76Ev");}
void  S1522C3_nt ::v77(){vfunc_called(this, "_ZN10S1522C3_nt3v77Ev");}
void  S1522C3_nt ::v78(){vfunc_called(this, "_ZN10S1522C3_nt3v78Ev");}
void  S1522C3_nt ::v79(){vfunc_called(this, "_ZN10S1522C3_nt3v79Ev");}
void  S1522C3_nt ::v80(){vfunc_called(this, "_ZN10S1522C3_nt3v80Ev");}
void  S1522C3_nt ::v81(){vfunc_called(this, "_ZN10S1522C3_nt3v81Ev");}
void  S1522C3_nt ::v82(){vfunc_called(this, "_ZN10S1522C3_nt3v82Ev");}
void  S1522C3_nt ::v83(){vfunc_called(this, "_ZN10S1522C3_nt3v83Ev");}
void  S1522C3_nt ::v84(){vfunc_called(this, "_ZN10S1522C3_nt3v84Ev");}
void  S1522C3_nt ::v85(){vfunc_called(this, "_ZN10S1522C3_nt3v85Ev");}
void  S1522C3_nt ::v86(){vfunc_called(this, "_ZN10S1522C3_nt3v86Ev");}
void  S1522C3_nt ::v87(){vfunc_called(this, "_ZN10S1522C3_nt3v87Ev");}
void  S1522C3_nt ::v88(){vfunc_called(this, "_ZN10S1522C3_nt3v88Ev");}
void  S1522C3_nt ::v89(){vfunc_called(this, "_ZN10S1522C3_nt3v89Ev");}
S1522C3_nt ::S1522C3_nt(){ note_ctor("S1522C3_nt", this);} // tgen

//skip512 S1522C3_nt

#else // __cplusplus

extern void _ZN10S1522C3_ntC1Ev();
extern void _ZN10S1522C3_ntD1Ev();
Name_Map name_map_S1522C3_nt[] = {
  NSPAIR(_ZN10S1522C3_ntC1Ev),
  NSPAIR(_ZN10S1522C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1522C4;
extern VTBL_ENTRY _ZTI7S1522C4[];
extern  VTBL_ENTRY _ZTV7S1522C4[];
static Base_Class bases_S1522C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1522C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S1522C3_nt[];
extern void _ZN10S1522C3_ntD1Ev();
extern void _ZN10S1522C3_ntD0Ev();
extern void _ZN7S1522C42v6Ev();
extern void _ZN7S1522C42v7Ev();
extern void _ZN7S1522C42v8Ev();
extern void _ZN7S1522C42v9Ev();
extern void _ZN7S1522C43v10Ev();
extern void _ZN7S1522C43v11Ev();
extern void _ZN7S1522C43v12Ev();
extern void _ZN7S1522C43v13Ev();
extern void _ZN7S1522C43v14Ev();
extern void _ZN7S1522C43v15Ev();
extern void _ZN7S1522C43v16Ev();
extern void _ZN7S1522C43v17Ev();
extern void _ZN7S1522C43v18Ev();
extern void _ZN7S1522C43v19Ev();
extern void _ZN7S1522C43v20Ev();
extern void _ZN7S1522C43v21Ev();
extern void _ZN7S1522C43v22Ev();
extern void _ZN7S1522C43v23Ev();
extern void _ZN7S1522C43v24Ev();
extern void _ZN7S1522C43v25Ev();
extern void _ZN7S1522C43v26Ev();
extern void _ZN7S1522C43v27Ev();
extern void _ZN7S1522C43v28Ev();
extern void _ZN7S1522C43v29Ev();
extern void _ZN7S1522C43v30Ev();
extern void _ZN7S1522C43v31Ev();
extern void _ZN7S1522C43v32Ev();
extern void _ZN7S1522C43v33Ev();
extern void _ZN7S1522C43v34Ev();
extern void _ZN7S1522C43v35Ev();
extern void _ZN7S1522C43v36Ev();
extern void _ZN7S1522C43v37Ev();
extern void _ZN7S1522C43v38Ev();
extern void _ZN7S1522C43v39Ev();
extern void _ZN7S1522C43v40Ev();
extern void _ZN7S1522C43v41Ev();
extern void _ZN7S1522C43v42Ev();
extern void _ZN7S1522C43v43Ev();
extern void _ZN7S1522C43v44Ev();
extern void _ZN7S1522C43v45Ev();
extern void _ZN7S1522C43v46Ev();
extern void _ZN7S1522C43v47Ev();
extern void _ZN7S1522C43v48Ev();
extern void _ZN7S1522C43v49Ev();
extern void _ZN7S1522C43v50Ev();
extern void _ZN7S1522C43v51Ev();
extern void _ZN7S1522C43v52Ev();
extern void _ZN7S1522C43v53Ev();
extern void _ZN7S1522C43v54Ev();
extern void _ZN7S1522C43v55Ev();
extern void _ZN7S1522C43v56Ev();
extern void _ZN7S1522C43v57Ev();
extern void _ZN7S1522C43v58Ev();
extern void _ZN7S1522C43v59Ev();
extern void _ZN7S1522C43v60Ev();
extern void _ZN7S1522C43v61Ev();
extern void _ZN7S1522C43v62Ev();
extern void _ZN7S1522C43v63Ev();
extern void _ZN7S1522C43v64Ev();
extern void _ZN7S1522C43v65Ev();
extern void _ZN7S1522C43v66Ev();
extern void _ZN7S1522C43v67Ev();
extern void _ZN7S1522C43v68Ev();
extern void _ZN7S1522C43v69Ev();
extern void _ZN10S1522C3_nt3v70Ev();
extern void _ZN10S1522C3_nt3v71Ev();
extern void _ZN10S1522C3_nt3v72Ev();
extern void _ZN10S1522C3_nt3v73Ev();
extern void _ZN10S1522C3_nt3v74Ev();
extern void _ZN10S1522C3_nt3v75Ev();
extern void _ZN10S1522C3_nt3v76Ev();
extern void _ZN10S1522C3_nt3v77Ev();
extern void _ZN10S1522C3_nt3v78Ev();
extern void _ZN10S1522C3_nt3v79Ev();
extern void _ZN10S1522C3_nt3v80Ev();
extern void _ZN10S1522C3_nt3v81Ev();
extern void _ZN10S1522C3_nt3v82Ev();
extern void _ZN10S1522C3_nt3v83Ev();
extern void _ZN10S1522C3_nt3v84Ev();
extern void _ZN10S1522C3_nt3v85Ev();
extern void _ZN10S1522C3_nt3v86Ev();
extern void _ZN10S1522C3_nt3v87Ev();
extern void _ZN10S1522C3_nt3v88Ev();
extern void _ZN10S1522C3_nt3v89Ev();
static  VTBL_ENTRY vtc_S1522C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1522C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S1522C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN7S1522C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1522C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1522C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1522C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v69Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v89Ev,
};
extern VTBL_ENTRY _ZTI10S1522C3_nt[];
VTBL_ENTRY *P__ZTI10S1522C3_nt = _ZTI10S1522C3_nt; 
extern  VTBL_ENTRY _ZTV10S1522C3_nt[];
Class_Descriptor cd_S1522C3_nt = {  "S1522C3_nt", // class name
  bases_S1522C3_nt, 1,
  &(vtc_S1522C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI10S1522C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S1522C3_nt),88, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1522C2_nt  : S1522C3_nt {
  virtual  ~S1522C2_nt(); // _ZN10S1522C2_ntD1Ev
  virtual void  v90(); // _ZN10S1522C2_nt3v90Ev
  virtual void  v91(); // _ZN10S1522C2_nt3v91Ev
  S1522C2_nt(); // tgen
};
//SIG(-1 S1522C2_nt) C1{ BC2{ BC3{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC5{ m}} vd v1 v2}


 S1522C2_nt ::~S1522C2_nt(){ note_dtor("S1522C2_nt", this);}
void  S1522C2_nt ::v90(){vfunc_called(this, "_ZN10S1522C2_nt3v90Ev");}
void  S1522C2_nt ::v91(){vfunc_called(this, "_ZN10S1522C2_nt3v91Ev");}
S1522C2_nt ::S1522C2_nt(){ note_ctor("S1522C2_nt", this);} // tgen

//skip512 S1522C2_nt

#else // __cplusplus

extern void _ZN10S1522C2_ntC1Ev();
extern void _ZN10S1522C2_ntD1Ev();
Name_Map name_map_S1522C2_nt[] = {
  NSPAIR(_ZN10S1522C2_ntC1Ev),
  NSPAIR(_ZN10S1522C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1522C4;
extern VTBL_ENTRY _ZTI7S1522C4[];
extern  VTBL_ENTRY _ZTV7S1522C4[];
extern Class_Descriptor cd_S1522C3_nt;
extern VTBL_ENTRY _ZTI10S1522C3_nt[];
extern  VTBL_ENTRY _ZTV10S1522C3_nt[];
static Base_Class bases_S1522C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1522C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1522C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S1522C2_nt[];
extern void _ZN10S1522C2_ntD1Ev();
extern void _ZN10S1522C2_ntD0Ev();
extern void _ZN7S1522C42v6Ev();
extern void _ZN7S1522C42v7Ev();
extern void _ZN7S1522C42v8Ev();
extern void _ZN7S1522C42v9Ev();
extern void _ZN7S1522C43v10Ev();
extern void _ZN7S1522C43v11Ev();
extern void _ZN7S1522C43v12Ev();
extern void _ZN7S1522C43v13Ev();
extern void _ZN7S1522C43v14Ev();
extern void _ZN7S1522C43v15Ev();
extern void _ZN7S1522C43v16Ev();
extern void _ZN7S1522C43v17Ev();
extern void _ZN7S1522C43v18Ev();
extern void _ZN7S1522C43v19Ev();
extern void _ZN7S1522C43v20Ev();
extern void _ZN7S1522C43v21Ev();
extern void _ZN7S1522C43v22Ev();
extern void _ZN7S1522C43v23Ev();
extern void _ZN7S1522C43v24Ev();
extern void _ZN7S1522C43v25Ev();
extern void _ZN7S1522C43v26Ev();
extern void _ZN7S1522C43v27Ev();
extern void _ZN7S1522C43v28Ev();
extern void _ZN7S1522C43v29Ev();
extern void _ZN7S1522C43v30Ev();
extern void _ZN7S1522C43v31Ev();
extern void _ZN7S1522C43v32Ev();
extern void _ZN7S1522C43v33Ev();
extern void _ZN7S1522C43v34Ev();
extern void _ZN7S1522C43v35Ev();
extern void _ZN7S1522C43v36Ev();
extern void _ZN7S1522C43v37Ev();
extern void _ZN7S1522C43v38Ev();
extern void _ZN7S1522C43v39Ev();
extern void _ZN7S1522C43v40Ev();
extern void _ZN7S1522C43v41Ev();
extern void _ZN7S1522C43v42Ev();
extern void _ZN7S1522C43v43Ev();
extern void _ZN7S1522C43v44Ev();
extern void _ZN7S1522C43v45Ev();
extern void _ZN7S1522C43v46Ev();
extern void _ZN7S1522C43v47Ev();
extern void _ZN7S1522C43v48Ev();
extern void _ZN7S1522C43v49Ev();
extern void _ZN7S1522C43v50Ev();
extern void _ZN7S1522C43v51Ev();
extern void _ZN7S1522C43v52Ev();
extern void _ZN7S1522C43v53Ev();
extern void _ZN7S1522C43v54Ev();
extern void _ZN7S1522C43v55Ev();
extern void _ZN7S1522C43v56Ev();
extern void _ZN7S1522C43v57Ev();
extern void _ZN7S1522C43v58Ev();
extern void _ZN7S1522C43v59Ev();
extern void _ZN7S1522C43v60Ev();
extern void _ZN7S1522C43v61Ev();
extern void _ZN7S1522C43v62Ev();
extern void _ZN7S1522C43v63Ev();
extern void _ZN7S1522C43v64Ev();
extern void _ZN7S1522C43v65Ev();
extern void _ZN7S1522C43v66Ev();
extern void _ZN7S1522C43v67Ev();
extern void _ZN7S1522C43v68Ev();
extern void _ZN7S1522C43v69Ev();
extern void _ZN10S1522C3_nt3v70Ev();
extern void _ZN10S1522C3_nt3v71Ev();
extern void _ZN10S1522C3_nt3v72Ev();
extern void _ZN10S1522C3_nt3v73Ev();
extern void _ZN10S1522C3_nt3v74Ev();
extern void _ZN10S1522C3_nt3v75Ev();
extern void _ZN10S1522C3_nt3v76Ev();
extern void _ZN10S1522C3_nt3v77Ev();
extern void _ZN10S1522C3_nt3v78Ev();
extern void _ZN10S1522C3_nt3v79Ev();
extern void _ZN10S1522C3_nt3v80Ev();
extern void _ZN10S1522C3_nt3v81Ev();
extern void _ZN10S1522C3_nt3v82Ev();
extern void _ZN10S1522C3_nt3v83Ev();
extern void _ZN10S1522C3_nt3v84Ev();
extern void _ZN10S1522C3_nt3v85Ev();
extern void _ZN10S1522C3_nt3v86Ev();
extern void _ZN10S1522C3_nt3v87Ev();
extern void _ZN10S1522C3_nt3v88Ev();
extern void _ZN10S1522C3_nt3v89Ev();
extern void _ZN10S1522C2_nt3v90Ev();
extern void _ZN10S1522C2_nt3v91Ev();
static  VTBL_ENTRY vtc_S1522C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1522C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S1522C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1522C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN7S1522C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1522C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1522C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1522C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v69Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1522C2_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1522C2_nt3v91Ev,
};
extern VTBL_ENTRY _ZTI10S1522C2_nt[];
VTBL_ENTRY *P__ZTI10S1522C2_nt = _ZTI10S1522C2_nt; 
extern  VTBL_ENTRY _ZTV10S1522C2_nt[];
Class_Descriptor cd_S1522C2_nt = {  "S1522C2_nt", // class name
  bases_S1522C2_nt, 2,
  &(vtc_S1522C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI10S1522C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S1522C2_nt),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1522C12_nt  : S6962C10_nt {
  void *s1522c12f0;
};
//SIG(-1 S1522C12_nt) C1{ BC2{ m Fc[4] FC3{ BC4{ BC5{ m Fp Fi[2]}}} Fi[2]} Fp}



//skip512 S1522C12_nt

#else // __cplusplus

extern Class_Descriptor cd_S6962C10_nt;
static Base_Class bases_S1522C12_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S6962C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1522C1  : S1522C2_nt {
  ::S6962C9_nt s1522c1f0;
  ::S1522C12_nt s1522c1f1;
  ::S1522C12_nt s1522c1f2;
  unsigned int s1522c1f3:1;
  unsigned int s1522c1f4:1;
  unsigned int s1522c1f5:1;
  virtual  ~S1522C1(); // _ZN7S1522C1D1Ev
  virtual void  v1(); // _ZN7S1522C12v1Ev
  virtual void  v2(); // _ZN7S1522C12v2Ev
  virtual void  v3(); // _ZN7S1522C12v3Ev
  virtual void  v4(); // _ZN7S1522C12v4Ev
  virtual void  v5(); // _ZN7S1522C12v5Ev
  S1522C1(); // tgen
};
//SIG(1 S1522C1) C1{ BC2{ BC3{ BC4{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC6{ m}} vd v90 v91} vd v1 v2 v3 v4 v5 FC7{ BC8{ m Fc[4] FC9{ BC10{ BC11{ m Fp Fi[2]}}} Fi[2]} Fp} FC12{ BC8 Fp} FC12 Fi:1 Fi:1 Fi:1}


 S1522C1 ::~S1522C1(){ note_dtor("S1522C1", this);}
void  S1522C1 ::v1(){vfunc_called(this, "_ZN7S1522C12v1Ev");}
void  S1522C1 ::v2(){vfunc_called(this, "_ZN7S1522C12v2Ev");}
void  S1522C1 ::v3(){vfunc_called(this, "_ZN7S1522C12v3Ev");}
void  S1522C1 ::v4(){vfunc_called(this, "_ZN7S1522C12v4Ev");}
void  S1522C1 ::v5(){vfunc_called(this, "_ZN7S1522C12v5Ev");}
S1522C1 ::S1522C1(){ note_ctor("S1522C1", this);} // tgen

static void Test_S1522C1()
{
  extern Class_Descriptor cd_S1522C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(30,39)];
    init_test(&cd_S1522C1, buf);
    S1522C1 *dp, &lv = *(dp=new (buf) S1522C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(232,152), "sizeof(S1522C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1522C1)");
    check_base_class_offset(lv, (S1522C4*)(S1522C3_nt*)(S1522C2_nt*), 0, "S1522C1");
    check_base_class_offset(lv, (S1522C3_nt*)(S1522C2_nt*), 0, "S1522C1");
    check_base_class_offset(lv, (S1522C2_nt*), 0, "S1522C1");
    check_field_offset(lv, s1522c1f0, ABISELECT(104,64), "S1522C1.s1522c1f0");
    check_field_offset(lv, s1522c1f1, ABISELECT(144,92), "S1522C1.s1522c1f1");
    check_field_offset(lv, s1522c1f2, ABISELECT(184,120), "S1522C1.s1522c1f2");
    set_bf_and_test(lv, s1522c1f3, ABISELECT(224,148), 0, 1, 1, "S1522C1");
    set_bf_and_test(lv, s1522c1f4, ABISELECT(224,148), 1, 1, 1, "S1522C1");
    set_bf_and_test(lv, s1522c1f5, ABISELECT(224,148), 2, 1, 1, "S1522C1");
    test_class_info(&lv, &cd_S1522C1);
    dp->~S1522C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1522C1(Test_S1522C1, "S1522C1", ABISELECT(232,152));

#else // __cplusplus

extern void _ZN7S1522C1C1Ev();
extern void _ZN7S1522C1D1Ev();
Name_Map name_map_S1522C1[] = {
  NSPAIR(_ZN7S1522C1C1Ev),
  NSPAIR(_ZN7S1522C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1522C4;
extern VTBL_ENTRY _ZTI7S1522C4[];
extern  VTBL_ENTRY _ZTV7S1522C4[];
extern Class_Descriptor cd_S1522C3_nt;
extern VTBL_ENTRY _ZTI10S1522C3_nt[];
extern  VTBL_ENTRY _ZTV10S1522C3_nt[];
extern Class_Descriptor cd_S1522C2_nt;
extern VTBL_ENTRY _ZTI10S1522C2_nt[];
extern  VTBL_ENTRY _ZTV10S1522C2_nt[];
static Base_Class bases_S1522C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1522C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1522C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1522C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1522C1[];
extern void _ZN7S1522C1D1Ev();
extern void _ZN7S1522C1D0Ev();
extern void _ZN7S1522C42v6Ev();
extern void _ZN7S1522C42v7Ev();
extern void _ZN7S1522C42v8Ev();
extern void _ZN7S1522C42v9Ev();
extern void _ZN7S1522C43v10Ev();
extern void _ZN7S1522C43v11Ev();
extern void _ZN7S1522C43v12Ev();
extern void _ZN7S1522C43v13Ev();
extern void _ZN7S1522C43v14Ev();
extern void _ZN7S1522C43v15Ev();
extern void _ZN7S1522C43v16Ev();
extern void _ZN7S1522C43v17Ev();
extern void _ZN7S1522C43v18Ev();
extern void _ZN7S1522C43v19Ev();
extern void _ZN7S1522C43v20Ev();
extern void _ZN7S1522C43v21Ev();
extern void _ZN7S1522C43v22Ev();
extern void _ZN7S1522C43v23Ev();
extern void _ZN7S1522C43v24Ev();
extern void _ZN7S1522C43v25Ev();
extern void _ZN7S1522C43v26Ev();
extern void _ZN7S1522C43v27Ev();
extern void _ZN7S1522C43v28Ev();
extern void _ZN7S1522C43v29Ev();
extern void _ZN7S1522C43v30Ev();
extern void _ZN7S1522C43v31Ev();
extern void _ZN7S1522C43v32Ev();
extern void _ZN7S1522C43v33Ev();
extern void _ZN7S1522C43v34Ev();
extern void _ZN7S1522C43v35Ev();
extern void _ZN7S1522C43v36Ev();
extern void _ZN7S1522C43v37Ev();
extern void _ZN7S1522C43v38Ev();
extern void _ZN7S1522C43v39Ev();
extern void _ZN7S1522C43v40Ev();
extern void _ZN7S1522C43v41Ev();
extern void _ZN7S1522C43v42Ev();
extern void _ZN7S1522C43v43Ev();
extern void _ZN7S1522C43v44Ev();
extern void _ZN7S1522C43v45Ev();
extern void _ZN7S1522C43v46Ev();
extern void _ZN7S1522C43v47Ev();
extern void _ZN7S1522C43v48Ev();
extern void _ZN7S1522C43v49Ev();
extern void _ZN7S1522C43v50Ev();
extern void _ZN7S1522C43v51Ev();
extern void _ZN7S1522C43v52Ev();
extern void _ZN7S1522C43v53Ev();
extern void _ZN7S1522C43v54Ev();
extern void _ZN7S1522C43v55Ev();
extern void _ZN7S1522C43v56Ev();
extern void _ZN7S1522C43v57Ev();
extern void _ZN7S1522C43v58Ev();
extern void _ZN7S1522C43v59Ev();
extern void _ZN7S1522C43v60Ev();
extern void _ZN7S1522C43v61Ev();
extern void _ZN7S1522C43v62Ev();
extern void _ZN7S1522C43v63Ev();
extern void _ZN7S1522C43v64Ev();
extern void _ZN7S1522C43v65Ev();
extern void _ZN7S1522C43v66Ev();
extern void _ZN7S1522C43v67Ev();
extern void _ZN7S1522C43v68Ev();
extern void _ZN7S1522C43v69Ev();
extern void _ZN10S1522C3_nt3v70Ev();
extern void _ZN10S1522C3_nt3v71Ev();
extern void _ZN10S1522C3_nt3v72Ev();
extern void _ZN10S1522C3_nt3v73Ev();
extern void _ZN10S1522C3_nt3v74Ev();
extern void _ZN10S1522C3_nt3v75Ev();
extern void _ZN10S1522C3_nt3v76Ev();
extern void _ZN10S1522C3_nt3v77Ev();
extern void _ZN10S1522C3_nt3v78Ev();
extern void _ZN10S1522C3_nt3v79Ev();
extern void _ZN10S1522C3_nt3v80Ev();
extern void _ZN10S1522C3_nt3v81Ev();
extern void _ZN10S1522C3_nt3v82Ev();
extern void _ZN10S1522C3_nt3v83Ev();
extern void _ZN10S1522C3_nt3v84Ev();
extern void _ZN10S1522C3_nt3v85Ev();
extern void _ZN10S1522C3_nt3v86Ev();
extern void _ZN10S1522C3_nt3v87Ev();
extern void _ZN10S1522C3_nt3v88Ev();
extern void _ZN10S1522C3_nt3v89Ev();
extern void _ZN10S1522C2_nt3v90Ev();
extern void _ZN10S1522C2_nt3v91Ev();
extern void _ZN7S1522C12v1Ev();
extern void _ZN7S1522C12v2Ev();
extern void _ZN7S1522C12v3Ev();
extern void _ZN7S1522C12v4Ev();
extern void _ZN7S1522C12v5Ev();
static  VTBL_ENTRY vtc_S1522C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1522C1[0]),
  (VTBL_ENTRY)&_ZN7S1522C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1522C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1522C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1522C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1522C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1522C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1522C43v69Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1522C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1522C2_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1522C2_nt3v91Ev,
  (VTBL_ENTRY)&_ZN7S1522C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1522C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1522C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1522C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1522C12v5Ev,
};
extern VTBL_ENTRY _ZTI7S1522C1[];
extern  VTBL_ENTRY _ZTV7S1522C1[];
Class_Descriptor cd_S1522C1 = {  "S1522C1", // class name
  bases_S1522C1, 3,
  &(vtc_S1522C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(232,152), // object size
  NSPAIRA(_ZTI7S1522C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1522C1),95, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3490C4  {
  __tsi64 s3490c4f0;
  int s3490c4f1;
  char s3490c4f2;
  void  mf3490c4(); // _ZN7S3490C48mf3490c4Ev
};
//SIG(-1 S3490C4) C1{ m FL Fi Fc}


void  S3490C4 ::mf3490c4(){}

static void Test_S3490C4()
{
  {
    init_simple_test("S3490C4");
    S3490C4 lv;
    check2(sizeof(lv), 16, "sizeof(S3490C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3490C4)");
    check_field_offset(lv, s3490c4f0, 0, "S3490C4.s3490c4f0");
    check_field_offset(lv, s3490c4f1, 8, "S3490C4.s3490c4f1");
    check_field_offset(lv, s3490c4f2, 12, "S3490C4.s3490c4f2");
  }
}
static Arrange_To_Call_Me vS3490C4(Test_S3490C4, "S3490C4", 16);

#else // __cplusplus

extern VTBL_ENTRY _ZTI7S3490C4[];
VTBL_ENTRY *P__ZTI7S3490C4 = _ZTI7S3490C4; 
Class_Descriptor cd_S3490C4 = {  "S3490C4", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  16, // object size
  NSPAIRA(_ZTI7S3490C4),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3490C6  {
  long double s3490c6f0;
  int s3490c6f1:3;
  char s3490c6f2:8;
  long double s3490c6f3[2];
  __tsi64 s3490c6f4;
  virtual void  v2(); // _ZN7S3490C62v2Ev
  ~S3490C6(); // tgen
  S3490C6(); // tgen
};
//SIG(-1 S3490C6) C1{ v1 FD Fi:3 Fc:8 FD[2] FL}


void  S3490C6 ::v2(){vfunc_called(this, "_ZN7S3490C62v2Ev");}
S3490C6 ::~S3490C6(){ note_dtor("S3490C6", this);} // tgen
S3490C6 ::S3490C6(){ note_ctor("S3490C6", this);} // tgen

static void Test_S3490C6()
{
  extern Class_Descriptor cd_S3490C6;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(7,14)];
    init_test(&cd_S3490C6, buf);
    S3490C6 *dp, &lv = *(dp=new (buf) S3490C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,52), "sizeof(S3490C6)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S3490C6)");
    check_field_offset(lv, s3490c6f0, ABISELECT(16,4), "S3490C6.s3490c6f0");
    set_bf_and_test(lv, s3490c6f1, ABISELECT(32,16), 0, 3, 1, "S3490C6");
    set_bf_and_test(lv, s3490c6f1, ABISELECT(32,16), 0, 3, hide_sll(1LL<<2), "S3490C6");
    set_bf_and_test(lv, s3490c6f2, ABISELECT(33,17), 0, 8, 1, "S3490C6");
    set_bf_and_test(lv, s3490c6f2, ABISELECT(33,17), 0, 8, hide_sll(1LL<<7), "S3490C6");
    check_field_offset(lv, s3490c6f3, ABISELECT(48,20), "S3490C6.s3490c6f3");
    check_field_offset(lv, s3490c6f4, ABISELECT(80,44), "S3490C6.s3490c6f4");
    test_class_info(&lv, &cd_S3490C6);
    dp->~S3490C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3490C6(Test_S3490C6, "S3490C6", ABISELECT(96,52));

#else // __cplusplus

extern void _ZN7S3490C6C1Ev();
extern void _ZN7S3490C6D1Ev();
Name_Map name_map_S3490C6[] = {
  NSPAIR(_ZN7S3490C6C1Ev),
  NSPAIR(_ZN7S3490C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S3490C6[];
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY vtc_S3490C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C6[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
Class_Descriptor cd_S3490C6 = {  "S3490C6", // class name
  0,0,//no base classes
  &(vtc_S3490C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,52), // object size
  NSPAIRA(_ZTI7S3490C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S3490C6),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3490C7  : virtual S3490C6 {
  ::S3490C4 s3490c7f0;
  __tsi64 s3490c7f1;
  ::S3490C4 s3490c7f2[7];
  void *s3490c7f3;
  __tsi64 s3490c7f4;
  ::S3490C4 s3490c7f5;
  void *s3490c7f6;
  char s3490c7f7;
  short s3490c7f8;
  int s3490c7f9;
  ::S3490C6 s3490c7f10;
  virtual void  v3(); // _ZN7S3490C72v3Ev
  ~S3490C7(); // tgen
  S3490C7(); // tgen
};
//SIG(-1 S3490C7) C1{ VBC2{ v2 FD Fi:3 Fc:8 FD[2] FL} v1 FC3{ m FL Fi Fc} FL FC3[7] Fp FL FC3 Fp Fc Fs Fi FC2}


void  S3490C7 ::v3(){vfunc_called(this, "_ZN7S3490C72v3Ev");}
S3490C7 ::~S3490C7(){ note_dtor("S3490C7", this);} // tgen
S3490C7 ::S3490C7(){ note_ctor("S3490C7", this);} // tgen

static void Test_S3490C7()
{
  extern Class_Descriptor cd_S3490C7;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(25,72)];
    init_test(&cd_S3490C7, buf);
    S3490C7 *dp, &lv = *(dp=new (buf) S3490C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(384,284), "sizeof(S3490C7)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S3490C7)");
    check_base_class_offset(lv, (S3490C6*), ABISELECT(288,232), "S3490C7");
    check_field_offset(lv, s3490c7f0, ABISELECT(8,4), "S3490C7.s3490c7f0");
    check_field_offset(lv, s3490c7f1, ABISELECT(24,20), "S3490C7.s3490c7f1");
    check_field_offset(lv, s3490c7f2, ABISELECT(32,28), "S3490C7.s3490c7f2");
    check_field_offset(lv, s3490c7f3, ABISELECT(144,140), "S3490C7.s3490c7f3");
    check_field_offset(lv, s3490c7f4, ABISELECT(152,144), "S3490C7.s3490c7f4");
    check_field_offset(lv, s3490c7f5, ABISELECT(160,152), "S3490C7.s3490c7f5");
    check_field_offset(lv, s3490c7f6, ABISELECT(176,168), "S3490C7.s3490c7f6");
    check_field_offset(lv, s3490c7f7, ABISELECT(184,172), "S3490C7.s3490c7f7");
    check_field_offset(lv, s3490c7f8, ABISELECT(186,174), "S3490C7.s3490c7f8");
    check_field_offset(lv, s3490c7f9, ABISELECT(188,176), "S3490C7.s3490c7f9");
    check_field_offset(lv, s3490c7f10, ABISELECT(192,180), "S3490C7.s3490c7f10");
    test_class_info(&lv, &cd_S3490C7);
    dp->~S3490C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3490C7(Test_S3490C7, "S3490C7", ABISELECT(384,284));

#else // __cplusplus

extern void _ZN7S3490C7C1Ev();
extern void _ZN7S3490C7D1Ev();
Name_Map name_map_S3490C7[] = {
  NSPAIR(_ZN7S3490C7C1Ev),
  NSPAIR(_ZN7S3490C7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
static Base_Class bases_S3490C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3490C6,    ABISELECT(288,232), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S3490C7[];
extern void _ZN7S3490C72v3Ev();
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY vtc_S3490C7[] = {
  ABISELECT(288,232),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
  0,
  ABISELECT(-288,-232),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern VTBL_ENTRY _ZTV7S3490C7[];
static  VTT_ENTRY vtt_S3490C7[] = {
  {&(_ZTV7S3490C7[3]),  3,8},
  {&(_ZTV7S3490C7[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
Class_Descriptor cd_S3490C7 = {  "S3490C7", // class name
  bases_S3490C7, 1,
  &(vtc_S3490C7[0]), // expected_vtbl_contents
  &(vtt_S3490C7[0]), // expected_vtt_contents
  ABISELECT(384,284), // object size
  NSPAIRA(_ZTI7S3490C7),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7S3490C7),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S3490C7),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3490C5  : S3490C6 , virtual S3490C4 {
  char s3490c5f0[10];
  int s3490c5f1;
  ::S3490C7 s3490c5f2;
  __tsi64 s3490c5f3;
  ~S3490C5(); // tgen
  S3490C5(); // tgen
};
//SIG(-1 S3490C5) C1{ BC2{ v1 FD Fi:3 Fc:8 FD[2] FL} VBC3{ m FL Fi Fc} Fc[10] Fi FC4{ VBC2 v2 FC3 FL FC3[7] Fp FL FC3 Fp Fc Fs Fi FC2} FL}


S3490C5 ::~S3490C5(){ note_dtor("S3490C5", this);} // tgen
S3490C5 ::S3490C5(){ note_ctor("S3490C5", this);} // tgen

static void Test_S3490C5()
{
  extern Class_Descriptor cd_S3490C5;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(34,95)];
    init_test(&cd_S3490C5, buf);
    S3490C5 *dp, &lv = *(dp=new (buf) S3490C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(528,376), "sizeof(S3490C5)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S3490C5)");
    check_base_class_offset(lv, (S3490C6*), 0, "S3490C5");
    check_base_class_offset(lv, (S3490C4*), ABISELECT(504,360), "S3490C5");
    check_field_offset(lv, s3490c5f0, ABISELECT(88,52), "S3490C5.s3490c5f0");
    check_field_offset(lv, s3490c5f1, ABISELECT(100,64), "S3490C5.s3490c5f1");
    check_field_offset(lv, s3490c5f2, ABISELECT(112,68), "S3490C5.s3490c5f2");
    check_field_offset(lv, s3490c5f3, ABISELECT(496,352), "S3490C5.s3490c5f3");
    test_class_info(&lv, &cd_S3490C5);
    dp->~S3490C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3490C5(Test_S3490C5, "S3490C5", ABISELECT(528,376));

#else // __cplusplus

extern void _ZN7S3490C5C1Ev();
extern void _ZN7S3490C5D1Ev();
Name_Map name_map_S3490C5[] = {
  NSPAIR(_ZN7S3490C5C1Ev),
  NSPAIR(_ZN7S3490C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C4;
extern VTBL_ENTRY _ZTI7S3490C4[];
static Base_Class bases_S3490C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3490C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3490C4,    ABISELECT(504,360), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S3490C5[];
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY vtc_S3490C5[] = {
  ABISELECT(504,360),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern VTBL_ENTRY _ZTV7S3490C5[];
static  VTT_ENTRY vtt_S3490C5[] = {
  {&(_ZTV7S3490C5[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
Class_Descriptor cd_S3490C5 = {  "S3490C5", // class name
  bases_S3490C5, 2,
  &(vtc_S3490C5[0]), // expected_vtbl_contents
  &(vtt_S3490C5[0]), // expected_vtt_contents
  ABISELECT(528,376), // object size
  NSPAIRA(_ZTI7S3490C5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S3490C5),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S3490C5),1, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3490C3  : virtual S3490C4 , virtual S3490C5 , virtual S3490C6 , virtual S3490C7 {
  void *s3490c3f0;
  ~S3490C3(); // tgen
  S3490C3(); // tgen
};
//SIG(-1 S3490C3) C1{ VBC2{ m FL Fi Fc} VBC3{ BC4{ v1 FD Fi:3 Fc:8 FD[2] FL} VBC2 Fc[10] Fi FC5{ VBC4 v2 FC2 FL FC2[7] Fp FL FC2 Fp Fc Fs Fi FC4} FL} VBC4 VBC5 Fp}


S3490C3 ::~S3490C3(){ note_dtor("S3490C3", this);} // tgen
S3490C3 ::S3490C3(){ note_ctor("S3490C3", this);} // tgen

static void Test_S3490C3()
{
  extern Class_Descriptor cd_S3490C3;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(59,168)];
    init_test(&cd_S3490C3, buf);
    S3490C3 *dp, &lv = *(dp=new (buf) S3490C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(928,668), "sizeof(S3490C3)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S3490C3)");
    check_base_class_offset(lv, (S3490C4*), ABISELECT(16,8), "S3490C3");
    check_base_class_offset(lv, (S3490C4*)(S3490C5*), ABISELECT(16,8), "S3490C3");
    check_base_class_offset(lv, (S3490C6*)(S3490C5*), ABISELECT(32,24), "S3490C3");
    check_base_class_offset(lv, (S3490C5*), ABISELECT(32,24), "S3490C3");
    /*is_ambiguous_... S3490C3::S3490C6 */ AMB_check_base_class_offset(lv, (S3490C6*), ABISELECT(544,384), "S3490C3");
    check_base_class_offset(lv, (S3490C6*)(S3490C7*), ABISELECT(544,384), "S3490C3");
    check_base_class_offset(lv, (S3490C7*), ABISELECT(640,436), "S3490C3");
    check_field_offset(lv, s3490c3f0, ABISELECT(8,4), "S3490C3.s3490c3f0");
    test_class_info(&lv, &cd_S3490C3);
    dp->~S3490C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3490C3(Test_S3490C3, "S3490C3", ABISELECT(928,668));

#else // __cplusplus

extern void _ZN7S3490C3C1Ev();
extern void _ZN7S3490C3D1Ev();
Name_Map name_map_S3490C3[] = {
  NSPAIR(_ZN7S3490C3C1Ev),
  NSPAIR(_ZN7S3490C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3490C4;
extern VTBL_ENTRY _ZTI7S3490C4[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C7;
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
static Base_Class bases_S3490C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3490C4,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3490C6,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(32,24), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3490C6,    ABISELECT(544,384), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3490C7,    ABISELECT(640,436), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S3490C3[];
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY vtc_S3490C3[] = {
  ABISELECT(640,436),
  ABISELECT(544,384),
  ABISELECT(32,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  0,
  -16,
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  0,
  ABISELECT(-544,-384),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  0,
  ABISELECT(-96,-52),
  ABISELECT(-640,-436),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern VTBL_ENTRY _ZTV7S3490C3[];
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C3[] = {
  -16,
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C3[] = {
  ABISELECT(-96,-52),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__7S3490C7__7S3490C3[] = {
  0,
  ABISELECT(96,52),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTT_ENTRY vtt_S3490C3[] = {
  {&(_ZTV7S3490C3[6]),  6,20},
  {&(_ZTV7S3490C3[10]),  10,20},
  {&(_ZTV7S3490C3[14]),  14,20},
  {&(_ZTV7S3490C3[19]),  19,20},
  {&(_tg__ZTV7S3490C5__7S3490C3[3]),  3,4},
  {&(_tg__ZTV7S3490C7__7S3490C3[3]),  3,4},
  {&(_tg__ZTV7S3490C6__7S3490C7__7S3490C3[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7S3490C3[];
extern  VTBL_ENTRY _ZTV7S3490C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C3[];
Class_Descriptor cd_S3490C3 = {  "S3490C3", // class name
  bases_S3490C3, 5,
  &(vtc_S3490C3[0]), // expected_vtbl_contents
  &(vtt_S3490C3[0]), // expected_vtt_contents
  ABISELECT(928,668), // object size
  NSPAIRA(_ZTI7S3490C3),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV7S3490C3),20, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S3490C3),7, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3490C9  : S3490C6 , virtual S3490C4 , S3490C5 , S3490C7 , virtual S3490C3 {
  ::S3490C7 s3490c9f0;
  ::S3490C3 s3490c9f1;
  void *s3490c9f2;
  int s3490c9f3;
  ::S3490C6 s3490c9f4;
  ::S3490C7 s3490c9f5;
  virtual  ~S3490C9(); // _ZN7S3490C9D2Ev
  S3490C9(); // tgen
};
//SIG(-1 S3490C9) C1{ BC2{ v1 FD Fi:3 Fc:8 FD[2] FL} VBC3{ m FL Fi Fc} BC4{ BC2 VBC3 Fc[10] Fi FC5{ VBC2 v2 FC3 FL FC3[7] Fp FL FC3 Fp Fc Fs Fi FC2} FL} BC5 VBC6{ VBC3 VBC4 VBC2 VBC5 Fp} vd FC5 FC6 Fp Fi FC2 FC5}


 S3490C9 ::~S3490C9(){ note_dtor("S3490C9", this);}
S3490C9 ::S3490C9(){ note_ctor("S3490C9", this);} // tgen

static void Test_S3490C9()
{
  extern Class_Descriptor cd_S3490C9;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(228,653)];
    init_test(&cd_S3490C9, buf);
    S3490C9 *dp, &lv = *(dp=new (buf) S3490C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(3632,2608), "sizeof(S3490C9)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S3490C9)");
    /*is_ambiguous_... S3490C9::S3490C6 */ AMB_check_base_class_offset(lv, (S3490C6*), 0, "S3490C9");
    check_base_class_offset(lv, (S3490C4*), ABISELECT(2704,1940), "S3490C9");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*), ABISELECT(2704,1940), "S3490C9");
    check_base_class_offset(lv, (S3490C4*)(S3490C3*), ABISELECT(2704,1940), "S3490C9");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*), ABISELECT(2704,1940), "S3490C9");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*), ABISELECT(96,52), "S3490C9");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C5*), ABISELECT(96,52), "S3490C9");
    /*is_ambiguous_... S3490C9::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C7*), ABISELECT(2720,1956), "S3490C9");
    /*is_ambiguous_... S3490C3::S3490C6 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C3*), ABISELECT(2720,1956), "S3490C9");
    /*is_ambiguous_... S3490C9::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C7*), ABISELECT(2720,1956), "S3490C9");
    /*is_ambiguous_... S3490C9::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C7*), ABISELECT(608,412), "S3490C9");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*), ABISELECT(2832,2016), "S3490C9");
    check_base_class_offset(lv, (S3490C5*)(S3490C3*), ABISELECT(2832,2016), "S3490C9");
    check_base_class_offset(lv, (S3490C7*)(S3490C3*), ABISELECT(3344,2376), "S3490C9");
    check_base_class_offset(lv, (S3490C3*), ABISELECT(2808,2008), "S3490C9");
    check_field_offset(lv, s3490c9f0, ABISELECT(896,644), "S3490C9.s3490c9f0");
    check_field_offset(lv, s3490c9f1, ABISELECT(1280,928), "S3490C9.s3490c9f1");
    check_field_offset(lv, s3490c9f2, ABISELECT(2208,1596), "S3490C9.s3490c9f2");
    check_field_offset(lv, s3490c9f3, ABISELECT(2216,1600), "S3490C9.s3490c9f3");
    check_field_offset(lv, s3490c9f4, ABISELECT(2224,1604), "S3490C9.s3490c9f4");
    check_field_offset(lv, s3490c9f5, ABISELECT(2320,1656), "S3490C9.s3490c9f5");
    test_class_info(&lv, &cd_S3490C9);
    dp->~S3490C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3490C9(Test_S3490C9, "S3490C9", ABISELECT(3632,2608));

#else // __cplusplus

extern void _ZN7S3490C9C1Ev();
extern void _ZN7S3490C9D2Ev();
Name_Map name_map_S3490C9[] = {
  NSPAIR(_ZN7S3490C9C1Ev),
  NSPAIR(_ZN7S3490C9D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C4;
extern VTBL_ENTRY _ZTI7S3490C4[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C7;
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C7;
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
extern Class_Descriptor cd_S3490C3;
extern VTBL_ENTRY _ZTI7S3490C3[];
extern  VTBL_ENTRY _ZTV7S3490C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C3[];
static Base_Class bases_S3490C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3490C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3490C4,    ABISELECT(2704,1940), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3490C6,    ABISELECT(96,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(96,52), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3490C6,    ABISELECT(2720,1956), //bcp->offset
    18, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S3490C7,    ABISELECT(608,412), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3490C6,    ABISELECT(2832,2016), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(2832,2016), //bcp->offset
    28, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S3490C7,    ABISELECT(3344,2376), //bcp->offset
    33, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S3490C3,    ABISELECT(2808,2008), //bcp->offset
    22, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S3490C9[];
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C9D1Ev();
extern void _ZN7S3490C9D0Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C72v3Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY vtc_S3490C9[] = {
  ABISELECT(3344,2376),
  ABISELECT(2832,2016),
  ABISELECT(2808,2008),
  ABISELECT(2720,1956),
  ABISELECT(2704,1940),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D0Ev,
  ABISELECT(2608,1888),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(2112,1544),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
  0,
  ABISELECT(-2720,-1956),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(536,368),
  ABISELECT(-88,-52),
  ABISELECT(24,8),
  ABISELECT(-104,-68),
  ABISELECT(-2808,-2008),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  0,
  ABISELECT(-128,-76),
  ABISELECT(-2832,-2016),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  0,
  ABISELECT(-624,-420),
  ABISELECT(-3344,-2376),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern VTBL_ENTRY _ZTV7S3490C9[];
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A__7S3490C9[] = {
  ABISELECT(2608,1888),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A__7S3490C9[] = {
  ABISELECT(2112,1544),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__7S3490C7__A__7S3490C9[] = {
  0,
  ABISELECT(-2112,-1544),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__7S3490C9[] = {
  ABISELECT(536,368),
  ABISELECT(-88,-52),
  ABISELECT(24,8),
  ABISELECT(-104,-68),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C3__7S3490C9[] = {
  0,
  ABISELECT(-128,-76),
  ABISELECT(-24,-8),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C3__7S3490C9[] = {
  0,
  ABISELECT(88,52),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C3__7S3490C9[] = {
  0,
  ABISELECT(-624,-420),
  ABISELECT(-536,-368),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A1__7S3490C9[] = {
  ABISELECT(-128,-76),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A1__7S3490C9[] = {
  ABISELECT(-624,-420),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__7S3490C7__A1__7S3490C9[] = {
  0,
  ABISELECT(624,420),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTT_ENTRY vtt_S3490C9[] = {
  {&(_ZTV7S3490C9[7]),  7,38},
  {&(_tg__ZTV7S3490C5__A__7S3490C9[3]),  3,4},
  {&(_tg__ZTV7S3490C7__A__7S3490C9[3]),  3,4},
  {&(_tg__ZTV7S3490C6__7S3490C7__A__7S3490C9[3]),  3,4},
  {&(_ZTV7S3490C9[13]),  13,38},
  {&(_ZTV7S3490C9[17]),  17,38},
  {&(_ZTV7S3490C9[21]),  21,38},
  {&(_ZTV7S3490C9[28]),  28,38},
  {&(_ZTV7S3490C9[32]),  32,38},
  {&(_ZTV7S3490C9[37]),  37,38},
  {&(_tg__ZTV7S3490C3__7S3490C9[6]),  6,6},
  {&(_tg__ZTV7S3490C5__7S3490C3__7S3490C9[4]),  4,5},
  {&(_tg__ZTV7S3490C6__A1__7S3490C3__7S3490C9[3]),  3,4},
  {&(_tg__ZTV7S3490C7__7S3490C3__7S3490C9[4]),  4,5},
  {&(_tg__ZTV7S3490C5__A1__7S3490C9[3]),  3,4},
  {&(_tg__ZTV7S3490C7__A1__7S3490C9[3]),  3,4},
  {&(_tg__ZTV7S3490C6__7S3490C7__A1__7S3490C9[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7S3490C9[];
extern  VTBL_ENTRY _ZTV7S3490C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C9[];
Class_Descriptor cd_S3490C9 = {  "S3490C9", // class name
  bases_S3490C9, 10,
  &(vtc_S3490C9[0]), // expected_vtbl_contents
  &(vtt_S3490C9[0]), // expected_vtt_contents
  ABISELECT(3632,2608), // object size
  NSPAIRA(_ZTI7S3490C9),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV7S3490C9),38, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S3490C9),17, //virtual table table var
  9, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3490C8  : S3490C3 , S3490C9 , S3490C5 , S3490C6 {
  ::S3490C5 s3490c8f0[2];
  ::S3490C6 s3490c8f1;
  int s3490c8f2;
  ::S3490C4 s3490c8f3;
  void *s3490c8f4[10];
  int s3490c8f5[2];
  __tsi64 s3490c8f6;
  long double s3490c8f7;
  __tsi64 s3490c8f8;
  int s3490c8f9;
  virtual void  v4(); // _ZN7S3490C82v4Ev
  ~S3490C8(); // tgen
  S3490C8(); // tgen
};
//SIG(-1 S3490C8) C1{ BC2{ VBC3{ m FL Fi Fc} VBC4{ BC5{ v2 FD Fi:3 Fc:8 FD[2] FL} VBC3 Fc[10] Fi FC6{ VBC5 v3 FC3 FL FC3[7] Fp FL FC3 Fp Fc Fs Fi FC5} FL} VBC5 VBC6 Fp} BC7{ BC5 VBC3 BC4 BC6 VBC2 vd FC6 FC2 Fp Fi FC5 FC6} BC4 BC5 v1 FC4[2] FC5 Fi FC3 Fp[10] Fi[2] FL FD FL Fi}


void  S3490C8 ::v4(){vfunc_called(this, "_ZN7S3490C82v4Ev");}
S3490C8 ::~S3490C8(){ note_dtor("S3490C8", this);} // tgen
S3490C8 ::S3490C8(){ note_ctor("S3490C8", this);} // tgen

static void Test_S3490C8()
{
  extern Class_Descriptor cd_S3490C8;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(349,984)];
    init_test(&cd_S3490C8, buf);
    S3490C8 *dp, &lv = *(dp=new (buf) S3490C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(5568,3932), "sizeof(S3490C8)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S3490C8)");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C3*), ABISELECT(4640,3264), "S3490C8");
    /*is_ambiguous_... S3490C8::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*), ABISELECT(4640,3264), "S3490C8");
    check_base_class_offset(lv, (S3490C4*)(S3490C9*), ABISELECT(4640,3264), "S3490C8");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*)(S3490C9*), ABISELECT(4640,3264), "S3490C8");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C3*), ABISELECT(4640,3264), "S3490C8");
    /*is_ambiguous_... S3490C8::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*), ABISELECT(4640,3264), "S3490C8");
    /*is_ambiguous_... S3490C8::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*), ABISELECT(4656,3280), "S3490C8");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C3*), ABISELECT(4656,3280), "S3490C8");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C3*), ABISELECT(4656,3280), "S3490C8");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C3*), ABISELECT(5168,3640), "S3490C8");
    /*is_ambiguous_... S3490C8::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C7*), ABISELECT(5168,3640), "S3490C8");
    /*is_ambiguous_... S3490C9::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C7*)(S3490C9*), ABISELECT(5168,3640), "S3490C8");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C3*), ABISELECT(5168,3640), "S3490C8");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C3*), ABISELECT(5264,3692), "S3490C8");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C3*), ABISELECT(5264,3692), "S3490C8");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C3*), 0, "S3490C8");
    /*is_ambiguous_... S3490C9::S3490C6 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C9*), ABISELECT(16,8), "S3490C8");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*)(S3490C9*), ABISELECT(112,60), "S3490C8");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C9*), ABISELECT(112,60), "S3490C8");
    /*is_ambiguous_... S3490C9::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C9*), ABISELECT(624,420), "S3490C8");
    check_base_class_offset(lv, (S3490C3*)(S3490C9*), ABISELECT(5552,3924), "S3490C8");
    check_base_class_offset(lv, (S3490C9*), ABISELECT(16,8), "S3490C8");
    /*is_ambiguous_... S3490C8::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*), ABISELECT(2720,1948), "S3490C8");
    /*is_ambiguous_... S3490C8::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C5*), ABISELECT(2720,1948), "S3490C8");
    /*is_ambiguous_... S3490C8::S3490C6 */ AMB_check_base_class_offset(lv, (S3490C6*), ABISELECT(3232,2308), "S3490C8");
    check_field_offset(lv, s3490c8f0, ABISELECT(3328,2360), "S3490C8.s3490c8f0");
    check_field_offset(lv, s3490c8f1, ABISELECT(4384,3112), "S3490C8.s3490c8f1");
    check_field_offset(lv, s3490c8f2, ABISELECT(4480,3164), "S3490C8.s3490c8f2");
    check_field_offset(lv, s3490c8f3, ABISELECT(4488,3168), "S3490C8.s3490c8f3");
    check_field_offset(lv, s3490c8f4, ABISELECT(4504,3184), "S3490C8.s3490c8f4");
    check_field_offset(lv, s3490c8f5, ABISELECT(4584,3224), "S3490C8.s3490c8f5");
    check_field_offset(lv, s3490c8f6, ABISELECT(4592,3232), "S3490C8.s3490c8f6");
    check_field_offset(lv, s3490c8f7, ABISELECT(4608,3240), "S3490C8.s3490c8f7");
    check_field_offset(lv, s3490c8f8, ABISELECT(4624,3252), "S3490C8.s3490c8f8");
    check_field_offset(lv, s3490c8f9, ABISELECT(4632,3260), "S3490C8.s3490c8f9");
    test_class_info(&lv, &cd_S3490C8);
    dp->~S3490C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3490C8(Test_S3490C8, "S3490C8", ABISELECT(5568,3932));

#else // __cplusplus

extern void _ZN7S3490C8C1Ev();
extern void _ZN7S3490C8D1Ev();
Name_Map name_map_S3490C8[] = {
  NSPAIR(_ZN7S3490C8C1Ev),
  NSPAIR(_ZN7S3490C8D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3490C4;
extern VTBL_ENTRY _ZTI7S3490C4[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C7;
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
extern Class_Descriptor cd_S3490C3;
extern VTBL_ENTRY _ZTI7S3490C3[];
extern  VTBL_ENTRY _ZTV7S3490C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C3[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C7;
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
extern Class_Descriptor cd_S3490C3;
extern VTBL_ENTRY _ZTI7S3490C3[];
extern  VTBL_ENTRY _ZTV7S3490C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C3[];
extern Class_Descriptor cd_S3490C9;
extern VTBL_ENTRY _ZTI7S3490C9[];
extern  VTBL_ENTRY _ZTV7S3490C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C9[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
static Base_Class bases_S3490C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3490C4,    ABISELECT(4640,3264), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S3490C6,    ABISELECT(4656,3280), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(4656,3280), //bcp->offset
    35, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S3490C6,    ABISELECT(5168,3640), //bcp->offset
    40, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S3490C7,    ABISELECT(5264,3692), //bcp->offset
    44, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S3490C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3490C6,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(112,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(112,60), //bcp->offset
    20, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S3490C7,    ABISELECT(624,420), //bcp->offset
    24, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S3490C3,    ABISELECT(5552,3924), //bcp->offset
    49, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S3490C9,    ABISELECT(16,8), //bcp->offset
    10, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3490C6,    ABISELECT(2720,1948), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(2720,1948), //bcp->offset
    28, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3490C6,    ABISELECT(3232,2308), //bcp->offset
    32, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3490C8[];
extern void _ZN7S3490C82v4Ev();
extern void _ZN7S3490C8D1Ev();
extern void _ZN7S3490C8D0Ev();
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZThn16_N7S3490C8D1Ev,_ZThn8_N7S3490C8D1Ev)();
extern void ABISELECT(_ZThn16_N7S3490C8D0Ev,_ZThn8_N7S3490C8D0Ev)();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C72v3Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY vtc_S3490C8[] = {
  ABISELECT(5552,3924),
  ABISELECT(5264,3692),
  ABISELECT(5168,3640),
  ABISELECT(4656,3280),
  ABISELECT(4640,3264),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C82v4Ev,
  (VTBL_ENTRY)&_ZN7S3490C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C8D0Ev,
  ABISELECT(5248,3684),
  ABISELECT(4640,3272),
  ABISELECT(5536,3916),
  ABISELECT(5152,3632),
  ABISELECT(4624,3256),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S3490C8D1Ev,_ZThn8_N7S3490C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S3490C8D0Ev,_ZThn8_N7S3490C8D0Ev),
  ABISELECT(4528,3204),
  ABISELECT(-112,-60),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(4544,3220),
  ABISELECT(-624,-420),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
  ABISELECT(1920,1316),
  ABISELECT(-2720,-1948),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(-3232,-2308),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  0,
  -16,
  ABISELECT(-4656,-3280),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  0,
  ABISELECT(-5168,-3640),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  0,
  ABISELECT(-96,-52),
  ABISELECT(-5264,-3692),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
  ABISELECT(-288,-232),
  ABISELECT(-384,-284),
  ABISELECT(-896,-644),
  ABISELECT(-912,-660),
  ABISELECT(-5552,-3924),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
};
extern VTBL_ENTRY _ZTV7S3490C8[];
static  VTBL_ENTRY _tg__ZTV7S3490C3__A__7S3490C8[] = {
  ABISELECT(5264,3692),
  ABISELECT(5168,3640),
  ABISELECT(4656,3280),
  ABISELECT(4640,3264),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C3__A__7S3490C8[] = {
  0,
  -16,
  ABISELECT(-4656,-3280),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C3__A__7S3490C8[] = {
  0,
  ABISELECT(-5168,-3640),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C3__A__7S3490C8[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-5264,-3692),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C9D1Ev();
extern void _ZN7S3490C9D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C9__7S3490C8[] = {
  ABISELECT(5248,3684),
  ABISELECT(4640,3272),
  ABISELECT(5536,3916),
  ABISELECT(5152,3632),
  ABISELECT(4624,3256),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D0Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C9__A1__7S3490C8[] = {
  ABISELECT(4528,3204),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C9__A1__7S3490C8[] = {
  ABISELECT(4544,3220),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__7S3490C77S3490C9__A1__7S3490C8[] = {
  0,
  ABISELECT(-4544,-3220),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A__7S3490C9__7S3490C8[] = {
  ABISELECT(4528,3204),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A__7S3490C9__7S3490C8[] = {
  ABISELECT(4544,3220),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A2__7S3490C9__7S3490C8[] = {
  0,
  ABISELECT(-5152,-3632),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__7S3490C9__7S3490C8[] = {
  ABISELECT(-288,-232),
  ABISELECT(-384,-284),
  ABISELECT(-896,-644),
  ABISELECT(-912,-660),
  ABISELECT(-5536,-3916),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A1__7S3490C9__7S3490C8[] = {
  0,
  -16,
  ABISELECT(-4640,-3272),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A1__7S3490C9__7S3490C8[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-5248,-3684),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A__7S3490C8[] = {
  ABISELECT(1920,1316),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C8[] = {
  -16,
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C8[] = {
  ABISELECT(-96,-52),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__7S3490C7__7S3490C8[] = {
  0,
  ABISELECT(96,52),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__A1__7S3490C8[] = {
  ABISELECT(-288,-232),
  ABISELECT(-384,-284),
  ABISELECT(-896,-644),
  ABISELECT(-912,-660),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C3__A1__7S3490C8[] = {
  0,
  -16,
  ABISELECT(896,644),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C3__A1__7S3490C8[] = {
  0,
  ABISELECT(384,284),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C3__A1__7S3490C8[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(288,232),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
static  VTT_ENTRY vtt_S3490C8[] = {
  {&(_ZTV7S3490C8[7]),  7,55},
  {&(_tg__ZTV7S3490C3__A__7S3490C8[6]),  6,6},
  {&(_tg__ZTV7S3490C5__7S3490C3__A__7S3490C8[4]),  4,5},
  {&(_tg__ZTV7S3490C6__A1__7S3490C3__A__7S3490C8[3]),  3,4},
  {&(_tg__ZTV7S3490C7__7S3490C3__A__7S3490C8[4]),  4,5},
  {&(_tg__ZTV7S3490C9__7S3490C8[7]),  7,10},
  {&(_tg__ZTV7S3490C57S3490C9__A1__7S3490C8[3]),  3,4},
  {&(_tg__ZTV7S3490C77S3490C9__A1__7S3490C8[3]),  3,4},
  {&(_tg__ZTV7S3490C6__7S3490C77S3490C9__A1__7S3490C8[3]),  3,4},
  {&(_tg__ZTV7S3490C5__A__7S3490C9__7S3490C8[3]),  3,4},
  {&(_tg__ZTV7S3490C7__A__7S3490C9__7S3490C8[3]),  3,4},
  {&(_tg__ZTV7S3490C6__A2__7S3490C9__7S3490C8[3]),  3,4},
  {&(_tg__ZTV7S3490C3__7S3490C9__7S3490C8[6]),  6,6},
  {&(_tg__ZTV7S3490C5__A1__7S3490C9__7S3490C8[4]),  4,5},
  {&(_tg__ZTV7S3490C7__A1__7S3490C9__7S3490C8[4]),  4,5},
  {&(_tg__ZTV7S3490C5__A__7S3490C8[3]),  3,4},
  {&(_ZTV7S3490C8[39]),  39,55},
  {&(_ZTV7S3490C8[43]),  43,55},
  {&(_ZTV7S3490C8[48]),  48,55},
  {&(_ZTV7S3490C8[17]),  17,55},
  {&(_ZTV7S3490C8[23]),  23,55},
  {&(_ZTV7S3490C8[27]),  27,55},
  {&(_ZTV7S3490C8[55]),  55,55},
  {&(_ZTV7S3490C8[31]),  31,55},
  {&(_tg__ZTV7S3490C5__7S3490C8[3]),  3,4},
  {&(_tg__ZTV7S3490C7__7S3490C8[3]),  3,4},
  {&(_tg__ZTV7S3490C6__7S3490C7__7S3490C8[3]),  3,4},
  {&(_tg__ZTV7S3490C3__A1__7S3490C8[6]),  6,6},
  {&(_tg__ZTV7S3490C5__7S3490C3__A1__7S3490C8[4]),  4,5},
  {&(_tg__ZTV7S3490C6__A1__7S3490C3__A1__7S3490C8[3]),  3,4},
  {&(_tg__ZTV7S3490C7__7S3490C3__A1__7S3490C8[4]),  4,5},
};
extern VTBL_ENTRY _ZTI7S3490C8[];
extern  VTBL_ENTRY _ZTV7S3490C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C8[];
Class_Descriptor cd_S3490C8 = {  "S3490C8", // class name
  bases_S3490C8, 15,
  &(vtc_S3490C8[0]), // expected_vtbl_contents
  &(vtt_S3490C8[0]), // expected_vtt_contents
  ABISELECT(5568,3932), // object size
  NSPAIRA(_ZTI7S3490C8),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV7S3490C8),55, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S3490C8),31, //virtual table table var
  14, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3490C2  : S3490C3 , S3490C8 {
  void *s3490c2f0[2];
  int s3490c2f1;
  char s3490c2f2;
  ::S3490C5 s3490c2f3;
  ::S3490C8 s3490c2f4;
  long double s3490c2f5;
  virtual  ~S3490C2(); // _ZN7S3490C2D2Ev
  virtual void  v5(); // _ZN7S3490C22v5Ev
  virtual void  v6(); // _ZN7S3490C22v6Ev
  S3490C2(); // tgen
};
//SIG(-1 S3490C2) C1{ BC2{ VBC3{ m FL Fi Fc} VBC4{ BC5{ v3 FD Fi:3 Fc:8 FD[2] FL} VBC3 Fc[10] Fi FC6{ VBC5 v4 FC3 FL FC3[7] Fp FL FC3 Fp Fc Fs Fi FC5} FL} VBC5 VBC6 Fp} BC7{ BC2 BC8{ BC5 VBC3 BC4 BC6 VBC2 vd FC6 FC2 Fp Fi FC5 FC6} BC4 BC5 v5 FC4[2] FC5 Fi FC3 Fp[10] Fi[2] FL FD FL Fi} vd v1 v2 Fp[2] Fi Fc FC4 FC7 FD}


 S3490C2 ::~S3490C2(){ note_dtor("S3490C2", this);}
void  S3490C2 ::v5(){vfunc_called(this, "_ZN7S3490C22v5Ev");}
void  S3490C2 ::v6(){vfunc_called(this, "_ZN7S3490C22v6Ev");}
S3490C2 ::S3490C2(){ note_ctor("S3490C2", this);} // tgen

static void Test_S3490C2()
{
  extern Class_Descriptor cd_S3490C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(734,2070)];
    init_test(&cd_S3490C2, buf);
    S3490C2 *dp, &lv = *(dp=new (buf) S3490C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(11728,8276), "sizeof(S3490C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S3490C2)");
    /*is_ambiguous_... S3490C2::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C3*), ABISELECT(10800,7608), "S3490C2");
    /*is_ambiguous_... S3490C2::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*), ABISELECT(10800,7608), "S3490C2");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C3*)(S3490C8*), ABISELECT(10800,7608), "S3490C2");
    check_base_class_offset(lv, (S3490C4*)(S3490C9*)(S3490C8*), ABISELECT(10800,7608), "S3490C2");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*)(S3490C9*)(S3490C8*), ABISELECT(10800,7608), "S3490C2");
    /*is_ambiguous_... S3490C2::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C3*), ABISELECT(10800,7608), "S3490C2");
    /*is_ambiguous_... S3490C8::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*)(S3490C8*), ABISELECT(10800,7608), "S3490C2");
    /*is_ambiguous_... S3490C2::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*), ABISELECT(10816,7624), "S3490C2");
    /*is_ambiguous_... S3490C2::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C3*), ABISELECT(10816,7624), "S3490C2");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C3*)(S3490C8*), ABISELECT(10816,7624), "S3490C2");
    /*is_ambiguous_... S3490C2::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C3*), ABISELECT(10816,7624), "S3490C2");
    /*is_ambiguous_... S3490C2::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C3*), ABISELECT(11328,7984), "S3490C2");
    /*is_ambiguous_... S3490C2::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C7*), ABISELECT(11328,7984), "S3490C2");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C3*)(S3490C8*), ABISELECT(11328,7984), "S3490C2");
    /*is_ambiguous_... S3490C9::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C7*)(S3490C9*)(S3490C8*), ABISELECT(11328,7984), "S3490C2");
    /*is_ambiguous_... S3490C2::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C3*), ABISELECT(11328,7984), "S3490C2");
    /*is_ambiguous_... S3490C2::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C3*), ABISELECT(11424,8036), "S3490C2");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C3*)(S3490C8*), ABISELECT(11424,8036), "S3490C2");
    /*is_ambiguous_... S3490C2::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C3*), ABISELECT(11424,8036), "S3490C2");
    /*is_ambiguous_... S3490C2::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C3*), 0, "S3490C2");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C3*)(S3490C8*), ABISELECT(16,8), "S3490C2");
    /*is_ambiguous_... S3490C9::S3490C6 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C9*)(S3490C8*), ABISELECT(32,16), "S3490C2");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*)(S3490C9*)(S3490C8*), ABISELECT(128,68), "S3490C2");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C9*)(S3490C8*), ABISELECT(128,68), "S3490C2");
    /*is_ambiguous_... S3490C9::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C9*)(S3490C8*), ABISELECT(640,428), "S3490C2");
    check_base_class_offset(lv, (S3490C3*)(S3490C9*)(S3490C8*), ABISELECT(11712,8268), "S3490C2");
    check_base_class_offset(lv, (S3490C9*)(S3490C8*), ABISELECT(32,16), "S3490C2");
    /*is_ambiguous_... S3490C8::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*)(S3490C8*), ABISELECT(2736,1956), "S3490C2");
    /*is_ambiguous_... S3490C8::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C8*), ABISELECT(2736,1956), "S3490C2");
    /*is_ambiguous_... S3490C8::S3490C6 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C8*), ABISELECT(3248,2316), "S3490C2");
    check_base_class_offset(lv, (S3490C8*), ABISELECT(16,8), "S3490C2");
    check_field_offset(lv, s3490c2f0, ABISELECT(4656,3272), "S3490C2.s3490c2f0");
    check_field_offset(lv, s3490c2f1, ABISELECT(4672,3280), "S3490C2.s3490c2f1");
    check_field_offset(lv, s3490c2f2, ABISELECT(4676,3284), "S3490C2.s3490c2f2");
    check_field_offset(lv, s3490c2f3, ABISELECT(4688,3288), "S3490C2.s3490c2f3");
    check_field_offset(lv, s3490c2f4, ABISELECT(5216,3664), "S3490C2.s3490c2f4");
    check_field_offset(lv, s3490c2f5, ABISELECT(10784,7596), "S3490C2.s3490c2f5");
    test_class_info(&lv, &cd_S3490C2);
    dp->~S3490C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3490C2(Test_S3490C2, "S3490C2", ABISELECT(11728,8276));

#else // __cplusplus

extern void _ZN7S3490C2C1Ev();
extern void _ZN7S3490C2D2Ev();
Name_Map name_map_S3490C2[] = {
  NSPAIR(_ZN7S3490C2C1Ev),
  NSPAIR(_ZN7S3490C2D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S3490C4;
extern VTBL_ENTRY _ZTI7S3490C4[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C7;
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
extern Class_Descriptor cd_S3490C3;
extern VTBL_ENTRY _ZTI7S3490C3[];
extern  VTBL_ENTRY _ZTV7S3490C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C3[];
extern Class_Descriptor cd_S3490C3;
extern VTBL_ENTRY _ZTI7S3490C3[];
extern  VTBL_ENTRY _ZTV7S3490C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C3[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C7;
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
extern Class_Descriptor cd_S3490C3;
extern VTBL_ENTRY _ZTI7S3490C3[];
extern  VTBL_ENTRY _ZTV7S3490C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C3[];
extern Class_Descriptor cd_S3490C9;
extern VTBL_ENTRY _ZTI7S3490C9[];
extern  VTBL_ENTRY _ZTV7S3490C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C9[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C8;
extern VTBL_ENTRY _ZTI7S3490C8[];
extern  VTBL_ENTRY _ZTV7S3490C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C8[];
static Base_Class bases_S3490C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3490C4,    ABISELECT(10800,7608), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S3490C6,    ABISELECT(10816,7624), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(10816,7624), //bcp->offset
    46, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    39, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S3490C6,    ABISELECT(11328,7984), //bcp->offset
    51, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S3490C7,    ABISELECT(11424,8036), //bcp->offset
    55, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    32, //bcp->index_in_construction_vtbl_array
    40, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S3490C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3490C3,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(128,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(128,68), //bcp->offset
    31, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    35, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S3490C7,    ABISELECT(640,428), //bcp->offset
    35, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    36, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S3490C3,    ABISELECT(11712,8268), //bcp->offset
    60, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    37, //bcp->index_in_construction_vtbl_array
    42, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S3490C9,    ABISELECT(32,16), //bcp->offset
    21, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    34, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(2736,1956), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(2736,1956), //bcp->offset
    39, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    38, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(3248,2316), //bcp->offset
    43, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S3490C8,    ABISELECT(16,8), //bcp->offset
    11, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    33, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3490C2[];
extern void _ZN7S3490C2D1Ev();
extern void _ZN7S3490C2D0Ev();
extern void _ZN7S3490C22v5Ev();
extern void _ZN7S3490C22v6Ev();
extern void _ZN7S3490C82v4Ev();
extern void ABISELECT(_ZThn16_N7S3490C2D1Ev,_ZThn8_N7S3490C2D1Ev)();
extern void ABISELECT(_ZThn16_N7S3490C2D0Ev,_ZThn8_N7S3490C2D0Ev)();
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZThn32_N7S3490C2D1Ev,_ZThn16_N7S3490C2D1Ev)();
extern void ABISELECT(_ZThn32_N7S3490C2D0Ev,_ZThn16_N7S3490C2D0Ev)();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C72v3Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY vtc_S3490C2[] = {
  ABISELECT(11712,8268),
  ABISELECT(11424,8036),
  ABISELECT(11328,7984),
  ABISELECT(10816,7624),
  ABISELECT(10800,7608),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C2D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C2D0Ev,
  (VTBL_ENTRY)&_ZN7S3490C22v5Ev,
  (VTBL_ENTRY)&_ZN7S3490C22v6Ev,
  ABISELECT(11696,8260),
  ABISELECT(11408,8028),
  ABISELECT(11312,7976),
  ABISELECT(10800,7616),
  ABISELECT(10784,7600),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C82v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S3490C2D1Ev,_ZThn8_N7S3490C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S3490C2D0Ev,_ZThn8_N7S3490C2D0Ev),
  ABISELECT(11392,8020),
  ABISELECT(10784,7608),
  ABISELECT(11680,8252),
  ABISELECT(11296,7968),
  ABISELECT(10768,7592),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N7S3490C2D1Ev,_ZThn16_N7S3490C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N7S3490C2D0Ev,_ZThn16_N7S3490C2D0Ev),
  ABISELECT(10672,7540),
  ABISELECT(-128,-68),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(10688,7556),
  ABISELECT(-640,-428),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
  ABISELECT(8064,5652),
  ABISELECT(-2736,-1956),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(-3248,-2316),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  0,
  -16,
  ABISELECT(-10816,-7624),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  0,
  ABISELECT(-11328,-7984),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  0,
  ABISELECT(-96,-52),
  ABISELECT(-11424,-8036),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
  ABISELECT(-288,-232),
  ABISELECT(-384,-284),
  ABISELECT(-896,-644),
  ABISELECT(-912,-660),
  ABISELECT(-11712,-8268),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
};
extern VTBL_ENTRY _ZTV7S3490C2[];
static  VTBL_ENTRY _tg__ZTV7S3490C3__A__7S3490C2[] = {
  ABISELECT(11424,8036),
  ABISELECT(11328,7984),
  ABISELECT(10816,7624),
  ABISELECT(10800,7608),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C3__A__7S3490C2[] = {
  0,
  -16,
  ABISELECT(-10816,-7624),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C3__A__7S3490C2[] = {
  0,
  ABISELECT(-11328,-7984),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C3__A__7S3490C2[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-11424,-8036),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C82v4Ev();
extern void _ZN7S3490C8D1Ev();
extern void _ZN7S3490C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C8__7S3490C2[] = {
  ABISELECT(11696,8260),
  ABISELECT(11408,8028),
  ABISELECT(11312,7976),
  ABISELECT(10800,7616),
  ABISELECT(10784,7600),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C82v4Ev,
  (VTBL_ENTRY)&_ZN7S3490C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C8D0Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C37S3490C8__A1__7S3490C2[] = {
  ABISELECT(11408,8028),
  ABISELECT(11312,7976),
  ABISELECT(10800,7616),
  ABISELECT(10784,7600),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C37S3490C8__A1__7S3490C2[] = {
  0,
  -16,
  ABISELECT(-10800,-7616),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C37S3490C8__A1__7S3490C2[] = {
  0,
  ABISELECT(-11312,-7976),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C37S3490C8__A1__7S3490C2[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-11408,-8028),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C9D1Ev();
extern void _ZN7S3490C9D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C97S3490C8__7S3490C2[] = {
  ABISELECT(11392,8020),
  ABISELECT(10784,7608),
  ABISELECT(11680,8252),
  ABISELECT(11296,7968),
  ABISELECT(10768,7592),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D0Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C97S3490C8__A1__7S3490C2[] = {
  ABISELECT(10672,7540),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C97S3490C8__A1__7S3490C2[] = {
  ABISELECT(10688,7556),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__7S3490C77S3490C97S3490C8__A1__7S3490C2[] = {
  0,
  ABISELECT(-10688,-7556),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A__7S3490C97S3490C8__7S3490C2[] = {
  ABISELECT(10672,7540),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A__7S3490C97S3490C8__7S3490C2[] = {
  ABISELECT(10688,7556),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A2__7S3490C97S3490C8__7S3490C2[] = {
  0,
  ABISELECT(-11296,-7968),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__7S3490C97S3490C8__7S3490C2[] = {
  ABISELECT(-288,-232),
  ABISELECT(-384,-284),
  ABISELECT(-896,-644),
  ABISELECT(-912,-660),
  ABISELECT(-11680,-8252),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A1__7S3490C97S3490C8__7S3490C2[] = {
  0,
  -16,
  ABISELECT(-10784,-7608),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A1__7S3490C97S3490C8__7S3490C2[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-11392,-8020),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C8__A2__7S3490C2[] = {
  ABISELECT(8064,5652),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C8__7S3490C2[] = {
  0,
  -16,
  ABISELECT(-10800,-7616),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C8__7S3490C2[] = {
  0,
  ABISELECT(-11312,-7976),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C8__7S3490C2[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-11408,-8028),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZThn16_N7S3490C8D1Ev,_ZThn8_N7S3490C8D1Ev)();
extern void ABISELECT(_ZThn16_N7S3490C8D0Ev,_ZThn8_N7S3490C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S3490C9__7S3490C8__7S3490C2[] = {
  ABISELECT(11392,8020),
  ABISELECT(10784,7608),
  ABISELECT(11680,8252),
  ABISELECT(11296,7968),
  ABISELECT(10768,7592),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S3490C8D1Ev,_ZThn8_N7S3490C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S3490C8D0Ev,_ZThn8_N7S3490C8D0Ev),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C9__A1__7S3490C8__7S3490C2[] = {
  ABISELECT(10672,7540),
  ABISELECT(-112,-60),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C9__A1__7S3490C8__7S3490C2[] = {
  ABISELECT(10688,7556),
  ABISELECT(-624,-420),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__A1__7S3490C8__7S3490C2[] = {
  ABISELECT(-288,-232),
  ABISELECT(-384,-284),
  ABISELECT(-896,-644),
  ABISELECT(-912,-660),
  ABISELECT(-11696,-8260),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A__7S3490C8__7S3490C2[] = {
  ABISELECT(8064,5652),
  ABISELECT(-2720,-1948),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C2[] = {
  -16,
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C2[] = {
  ABISELECT(-96,-52),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__7S3490C7__7S3490C2[] = {
  0,
  ABISELECT(96,52),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__A2__7S3490C2[] = {
  ABISELECT(-288,-232),
  ABISELECT(-384,-284),
  ABISELECT(-896,-644),
  ABISELECT(-912,-660),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C3__A2__7S3490C2[] = {
  0,
  -16,
  ABISELECT(896,644),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C3__A2__7S3490C2[] = {
  0,
  ABISELECT(384,284),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C3__A2__7S3490C2[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(288,232),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
static  VTT_ENTRY vtt_S3490C2[] = {
  {&(_ZTV7S3490C2[7]),  7,66},
  {&(_tg__ZTV7S3490C3__A__7S3490C2[6]),  6,6},
  {&(_tg__ZTV7S3490C5__7S3490C3__A__7S3490C2[4]),  4,5},
  {&(_tg__ZTV7S3490C6__A1__7S3490C3__A__7S3490C2[3]),  3,4},
  {&(_tg__ZTV7S3490C7__7S3490C3__A__7S3490C2[4]),  4,5},
  {&(_tg__ZTV7S3490C8__7S3490C2[7]),  7,10},
  {&(_tg__ZTV7S3490C37S3490C8__A1__7S3490C2[6]),  6,6},
  {&(_tg__ZTV7S3490C5__7S3490C37S3490C8__A1__7S3490C2[4]),  4,5},
  {&(_tg__ZTV7S3490C6__A1__7S3490C37S3490C8__A1__7S3490C2[3]),  3,4},
  {&(_tg__ZTV7S3490C7__7S3490C37S3490C8__A1__7S3490C2[4]),  4,5},
  {&(_tg__ZTV7S3490C97S3490C8__7S3490C2[7]),  7,10},
  {&(_tg__ZTV7S3490C57S3490C97S3490C8__A1__7S3490C2[3]),  3,4},
  {&(_tg__ZTV7S3490C77S3490C97S3490C8__A1__7S3490C2[3]),  3,4},
  {&(_tg__ZTV7S3490C6__7S3490C77S3490C97S3490C8__A1__7S3490C2[3]),  3,4},
  {&(_tg__ZTV7S3490C5__A__7S3490C97S3490C8__7S3490C2[3]),  3,4},
  {&(_tg__ZTV7S3490C7__A__7S3490C97S3490C8__7S3490C2[3]),  3,4},
  {&(_tg__ZTV7S3490C6__A2__7S3490C97S3490C8__7S3490C2[3]),  3,4},
  {&(_tg__ZTV7S3490C3__7S3490C97S3490C8__7S3490C2[6]),  6,6},
  {&(_tg__ZTV7S3490C5__A1__7S3490C97S3490C8__7S3490C2[4]),  4,5},
  {&(_tg__ZTV7S3490C7__A1__7S3490C97S3490C8__7S3490C2[4]),  4,5},
  {&(_tg__ZTV7S3490C57S3490C8__A2__7S3490C2[3]),  3,4},
  {&(_tg__ZTV7S3490C5__7S3490C8__7S3490C2[4]),  4,5},
  {&(_tg__ZTV7S3490C6__A1__7S3490C8__7S3490C2[3]),  3,4},
  {&(_tg__ZTV7S3490C7__7S3490C8__7S3490C2[4]),  4,5},
  {&(_tg__ZTV7S3490C9__7S3490C8__7S3490C2[7]),  7,10},
  {&(_tg__ZTV7S3490C57S3490C9__A1__7S3490C8__7S3490C2[3]),  3,4},
  {&(_tg__ZTV7S3490C77S3490C9__A1__7S3490C8__7S3490C2[3]),  3,4},
  {&(_tg__ZTV7S3490C3__A1__7S3490C8__7S3490C2[6]),  6,6},
  {&(_tg__ZTV7S3490C5__A__7S3490C8__7S3490C2[3]),  3,4},
  {&(_ZTV7S3490C2[50]),  50,66},
  {&(_ZTV7S3490C2[54]),  54,66},
  {&(_ZTV7S3490C2[59]),  59,66},
  {&(_ZTV7S3490C2[18]),  18,66},
  {&(_ZTV7S3490C2[28]),  28,66},
  {&(_ZTV7S3490C2[34]),  34,66},
  {&(_ZTV7S3490C2[38]),  38,66},
  {&(_ZTV7S3490C2[66]),  66,66},
  {&(_ZTV7S3490C2[42]),  42,66},
  {&(_tg__ZTV7S3490C5__7S3490C2[3]),  3,4},
  {&(_tg__ZTV7S3490C7__7S3490C2[3]),  3,4},
  {&(_tg__ZTV7S3490C6__7S3490C7__7S3490C2[3]),  3,4},
  {&(_tg__ZTV7S3490C3__A2__7S3490C2[6]),  6,6},
  {&(_tg__ZTV7S3490C5__7S3490C3__A2__7S3490C2[4]),  4,5},
  {&(_tg__ZTV7S3490C6__A1__7S3490C3__A2__7S3490C2[3]),  3,4},
  {&(_tg__ZTV7S3490C7__7S3490C3__A2__7S3490C2[4]),  4,5},
};
extern VTBL_ENTRY _ZTI7S3490C2[];
extern  VTBL_ENTRY _ZTV7S3490C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C2[];
Class_Descriptor cd_S3490C2 = {  "S3490C2", // class name
  bases_S3490C2, 17,
  &(vtc_S3490C2[0]), // expected_vtbl_contents
  &(vtt_S3490C2[0]), // expected_vtt_contents
  ABISELECT(11728,8276), // object size
  NSPAIRA(_ZTI7S3490C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S3490C2),66, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S3490C2),45, //virtual table table var
  16, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3490C12  : S3490C9 {
  void *s3490c12f0;
  short s3490c12f1:6;
  ::S3490C6 s3490c12f2;
  long double s3490c12f3;
  int s3490c12f4;
  ::S3490C4 s3490c12f5;
  ::S3490C7 s3490c12f6;
  void *s3490c12f7;
  int s3490c12f8;
  void *s3490c12f9[2];
  virtual  ~S3490C12(); // _ZN8S3490C12D2Ev
  virtual void  v7(); // _ZN8S3490C122v7Ev
  virtual void  v8(); // _ZN8S3490C122v8Ev
  S3490C12(); // tgen
};
//SIG(-1 S3490C12) C1{ BC2{ BC3{ v3 FD Fi:3 Fc:8 FD[2] FL} VBC4{ m FL Fi Fc} BC5{ BC3 VBC4 Fc[10] Fi FC6{ VBC3 v4 FC4 FL FC4[7] Fp FL FC4 Fp Fc Fs Fi FC3} FL} BC6 VBC7{ VBC4 VBC5 VBC3 VBC6 Fp} vd FC6 FC7 Fp Fi FC3 FC6} vd v1 v2 Fp Fs:6 FC3 FD Fi FC4 FC6 Fp Fi Fp[2]}


 S3490C12 ::~S3490C12(){ note_dtor("S3490C12", this);}
void  S3490C12 ::v7(){vfunc_called(this, "_ZN8S3490C122v7Ev");}
void  S3490C12 ::v8(){vfunc_called(this, "_ZN8S3490C122v8Ev");}
S3490C12 ::S3490C12(){ note_ctor("S3490C12", this);} // tgen

static void Test_S3490C12()
{
  extern Class_Descriptor cd_S3490C12;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(264,751)];
    init_test(&cd_S3490C12, buf);
    S3490C12 *dp, &lv = *(dp=new (buf) S3490C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(4208,3000), "sizeof(S3490C12)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S3490C12)");
    /*is_ambiguous_... S3490C9::S3490C6 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C9*), 0, "S3490C12");
    check_base_class_offset(lv, (S3490C4*)(S3490C9*), ABISELECT(3280,2332), "S3490C12");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*)(S3490C9*), ABISELECT(3280,2332), "S3490C12");
    check_base_class_offset(lv, (S3490C4*)(S3490C3*), ABISELECT(3280,2332), "S3490C12");
    /*is_ambiguous_... S3490C12::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*), ABISELECT(3280,2332), "S3490C12");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*)(S3490C9*), ABISELECT(96,52), "S3490C12");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C9*), ABISELECT(96,52), "S3490C12");
    /*is_ambiguous_... S3490C9::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C7*)(S3490C9*), ABISELECT(3296,2348), "S3490C12");
    /*is_ambiguous_... S3490C3::S3490C6 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C3*), ABISELECT(3296,2348), "S3490C12");
    /*is_ambiguous_... S3490C12::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C7*), ABISELECT(3296,2348), "S3490C12");
    /*is_ambiguous_... S3490C9::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C9*), ABISELECT(608,412), "S3490C12");
    /*is_ambiguous_... S3490C12::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*), ABISELECT(3408,2408), "S3490C12");
    check_base_class_offset(lv, (S3490C5*)(S3490C3*), ABISELECT(3408,2408), "S3490C12");
    check_base_class_offset(lv, (S3490C7*)(S3490C3*), ABISELECT(3920,2768), "S3490C12");
    check_base_class_offset(lv, (S3490C3*)(S3490C9*), ABISELECT(3384,2400), "S3490C12");
    check_base_class_offset(lv, (S3490C9*), 0, "S3490C12");
    check_field_offset(lv, s3490c12f0, ABISELECT(2704,1940), "S3490C12.s3490c12f0");
    set_bf_and_test(lv, s3490c12f1, ABISELECT(2712,1944), 0, 6, 1, "S3490C12");
    set_bf_and_test(lv, s3490c12f1, ABISELECT(2712,1944), 0, 6, hide_sll(1LL<<5), "S3490C12");
    check_field_offset(lv, s3490c12f2, ABISELECT(2720,1948), "S3490C12.s3490c12f2");
    check_field_offset(lv, s3490c12f3, ABISELECT(2816,2000), "S3490C12.s3490c12f3");
    check_field_offset(lv, s3490c12f4, ABISELECT(2832,2012), "S3490C12.s3490c12f4");
    check_field_offset(lv, s3490c12f5, ABISELECT(2840,2016), "S3490C12.s3490c12f5");
    check_field_offset(lv, s3490c12f6, ABISELECT(2864,2032), "S3490C12.s3490c12f6");
    check_field_offset(lv, s3490c12f7, ABISELECT(3248,2316), "S3490C12.s3490c12f7");
    check_field_offset(lv, s3490c12f8, ABISELECT(3256,2320), "S3490C12.s3490c12f8");
    check_field_offset(lv, s3490c12f9, ABISELECT(3264,2324), "S3490C12.s3490c12f9");
    test_class_info(&lv, &cd_S3490C12);
    dp->~S3490C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3490C12(Test_S3490C12, "S3490C12", ABISELECT(4208,3000));

#else // __cplusplus

extern void _ZN8S3490C12C1Ev();
extern void _ZN8S3490C12D2Ev();
Name_Map name_map_S3490C12[] = {
  NSPAIR(_ZN8S3490C12C1Ev),
  NSPAIR(_ZN8S3490C12D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C4;
extern VTBL_ENTRY _ZTI7S3490C4[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C7;
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C7;
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
extern Class_Descriptor cd_S3490C3;
extern VTBL_ENTRY _ZTI7S3490C3[];
extern  VTBL_ENTRY _ZTV7S3490C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C3[];
extern Class_Descriptor cd_S3490C9;
extern VTBL_ENTRY _ZTI7S3490C9[];
extern  VTBL_ENTRY _ZTV7S3490C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C9[];
static Base_Class bases_S3490C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3490C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S3490C4,    ABISELECT(3280,2332), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S3490C6,    ABISELECT(96,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(96,52), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(3296,2348), //bcp->offset
    20, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S3490C7,    ABISELECT(608,412), //bcp->offset
    16, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(3408,2408), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(3408,2408), //bcp->offset
    30, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S3490C7,    ABISELECT(3920,2768), //bcp->offset
    35, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S3490C3,    ABISELECT(3384,2400), //bcp->offset
    24, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S3490C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S3490C12[];
extern void _ZN7S3490C62v2Ev();
extern void _ZN8S3490C12D1Ev();
extern void _ZN8S3490C12D0Ev();
extern void _ZN8S3490C122v7Ev();
extern void _ZN8S3490C122v8Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C72v3Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY vtc_S3490C12[] = {
  ABISELECT(3920,2768),
  ABISELECT(3408,2408),
  ABISELECT(3384,2400),
  ABISELECT(3296,2348),
  ABISELECT(3280,2332),
  0,
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN8S3490C12D1Ev,
  (VTBL_ENTRY)&_ZN8S3490C12D0Ev,
  (VTBL_ENTRY)&_ZN8S3490C122v7Ev,
  (VTBL_ENTRY)&_ZN8S3490C122v8Ev,
  ABISELECT(3184,2280),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(2688,1936),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
  0,
  ABISELECT(-3296,-2348),
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(536,368),
  ABISELECT(-88,-52),
  ABISELECT(24,8),
  ABISELECT(-104,-68),
  ABISELECT(-3384,-2400),
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
  0,
  ABISELECT(-128,-76),
  ABISELECT(-3408,-2408),
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  0,
  ABISELECT(-624,-420),
  ABISELECT(-3920,-2768),
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern VTBL_ENTRY _ZTV8S3490C12[];
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C9D1Ev();
extern void _ZN7S3490C9D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C9__8S3490C12[] = {
  ABISELECT(3920,2768),
  ABISELECT(3408,2408),
  ABISELECT(3384,2400),
  ABISELECT(3296,2348),
  ABISELECT(3280,2332),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D0Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C9__8S3490C12[] = {
  ABISELECT(3184,2280),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C9__8S3490C12[] = {
  ABISELECT(2688,1936),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__7S3490C77S3490C9__8S3490C12[] = {
  0,
  ABISELECT(-2688,-1936),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A__7S3490C9__8S3490C12[] = {
  ABISELECT(3184,2280),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A__7S3490C9__8S3490C12[] = {
  ABISELECT(2688,1936),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A2__7S3490C9__8S3490C12[] = {
  0,
  ABISELECT(-3296,-2348),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__7S3490C9__8S3490C12[] = {
  ABISELECT(536,368),
  ABISELECT(-88,-52),
  ABISELECT(24,8),
  ABISELECT(-104,-68),
  ABISELECT(-3384,-2400),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A1__7S3490C9__8S3490C12[] = {
  0,
  ABISELECT(-128,-76),
  ABISELECT(-3408,-2408),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A1__7S3490C9__8S3490C12[] = {
  0,
  ABISELECT(-624,-420),
  ABISELECT(-3920,-2768),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__8S3490C12[] = {
  ABISELECT(536,368),
  ABISELECT(-88,-52),
  ABISELECT(24,8),
  ABISELECT(-104,-68),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C3__8S3490C12[] = {
  0,
  ABISELECT(-128,-76),
  ABISELECT(-24,-8),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C3__8S3490C12[] = {
  0,
  ABISELECT(88,52),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C3__8S3490C12[] = {
  0,
  ABISELECT(-624,-420),
  ABISELECT(-536,-368),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A1__8S3490C12[] = {
  ABISELECT(-128,-76),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A1__8S3490C12[] = {
  ABISELECT(-624,-420),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__7S3490C7__A1__8S3490C12[] = {
  0,
  ABISELECT(624,420),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTT_ENTRY vtt_S3490C12[] = {
  {&(_ZTV8S3490C12[7]),  7,40},
  {&(_tg__ZTV7S3490C9__8S3490C12[7]),  7,10},
  {&(_tg__ZTV7S3490C57S3490C9__8S3490C12[3]),  3,4},
  {&(_tg__ZTV7S3490C77S3490C9__8S3490C12[3]),  3,4},
  {&(_tg__ZTV7S3490C6__7S3490C77S3490C9__8S3490C12[3]),  3,4},
  {&(_tg__ZTV7S3490C5__A__7S3490C9__8S3490C12[3]),  3,4},
  {&(_tg__ZTV7S3490C7__A__7S3490C9__8S3490C12[3]),  3,4},
  {&(_tg__ZTV7S3490C6__A2__7S3490C9__8S3490C12[3]),  3,4},
  {&(_tg__ZTV7S3490C3__7S3490C9__8S3490C12[6]),  6,6},
  {&(_tg__ZTV7S3490C5__A1__7S3490C9__8S3490C12[4]),  4,5},
  {&(_tg__ZTV7S3490C7__A1__7S3490C9__8S3490C12[4]),  4,5},
  {&(_ZTV8S3490C12[15]),  15,40},
  {&(_ZTV8S3490C12[19]),  19,40},
  {&(_ZTV8S3490C12[23]),  23,40},
  {&(_ZTV8S3490C12[30]),  30,40},
  {&(_ZTV8S3490C12[34]),  34,40},
  {&(_ZTV8S3490C12[39]),  39,40},
  {&(_tg__ZTV7S3490C3__8S3490C12[6]),  6,6},
  {&(_tg__ZTV7S3490C5__7S3490C3__8S3490C12[4]),  4,5},
  {&(_tg__ZTV7S3490C6__A1__7S3490C3__8S3490C12[3]),  3,4},
  {&(_tg__ZTV7S3490C7__7S3490C3__8S3490C12[4]),  4,5},
  {&(_tg__ZTV7S3490C5__A1__8S3490C12[3]),  3,4},
  {&(_tg__ZTV7S3490C7__A1__8S3490C12[3]),  3,4},
  {&(_tg__ZTV7S3490C6__7S3490C7__A1__8S3490C12[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8S3490C12[];
extern  VTBL_ENTRY _ZTV8S3490C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3490C12[];
Class_Descriptor cd_S3490C12 = {  "S3490C12", // class name
  bases_S3490C12, 11,
  &(vtc_S3490C12[0]), // expected_vtbl_contents
  &(vtt_S3490C12[0]), // expected_vtt_contents
  ABISELECT(4208,3000), // object size
  NSPAIRA(_ZTI8S3490C12),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S3490C12),40, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S3490C12),24, //virtual table table var
  10, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3490C11  : virtual S3490C4 , virtual S3490C3 , S3490C12 , S3490C8 {
  ::S601C21_nt s3490c11f0;
  ::S3490C12 s3490c11f1;
  __tsi64 s3490c11f2;
  ~S3490C11(); // tgen
  S3490C11(); // tgen
};
//SIG(-1 S3490C11) C1{ VBC2{ m FL Fi Fc} VBC3{ VBC2 VBC4{ BC5{ v1 FD Fi:3 Fc:8 FD[2] FL} VBC2 Fc[10] Fi FC6{ VBC5 v2 FC2 FL FC2[7] Fp FL FC2 Fp Fc Fs Fi FC5} FL} VBC5 VBC6 Fp} BC7{ BC8{ BC5 VBC2 BC4 BC6 VBC3 vd FC6 FC3 Fp Fi FC5 FC6} vd v3 v4 Fp Fs:6 FC5 FD Fi FC2 FC6 Fp Fi Fp[2]} BC9{ BC3 BC8 BC4 BC5 v5 FC4[2] FC5 Fi FC2 Fp[10] Fi[2] FL FD FL Fi} FC10{} FC7 FL}


S3490C11 ::~S3490C11(){ note_dtor("S3490C11", this);} // tgen
S3490C11 ::S3490C11(){ note_ctor("S3490C11", this);} // tgen

static void Test_S3490C11()
{
  extern Class_Descriptor cd_S3490C11;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(818,2320)];
    init_test(&cd_S3490C11, buf);
    S3490C11 *dp, &lv = *(dp=new (buf) S3490C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(13072,9276), "sizeof(S3490C11)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S3490C11)");
    check_base_class_offset(lv, (S3490C4*), ABISELECT(12136,8608), "S3490C11");
    /*is_ambiguous_... S3490C11::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C3*), ABISELECT(12136,8608), "S3490C11");
    /*is_ambiguous_... S3490C11::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*), ABISELECT(12136,8608), "S3490C11");
    check_base_class_offset(lv, (S3490C4*)(S3490C9*)(S3490C12*), ABISELECT(12136,8608), "S3490C11");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*)(S3490C9*)(S3490C12*), ABISELECT(12136,8608), "S3490C11");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C3*)(S3490C8*), ABISELECT(12136,8608), "S3490C11");
    check_base_class_offset(lv, (S3490C4*)(S3490C9*)(S3490C8*), ABISELECT(12136,8608), "S3490C11");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*)(S3490C9*)(S3490C8*), ABISELECT(12136,8608), "S3490C11");
    /*is_ambiguous_... S3490C8::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*)(S3490C8*), ABISELECT(12136,8608), "S3490C11");
    /*is_ambiguous_... S3490C11::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*), ABISELECT(12176,8632), "S3490C11");
    /*is_ambiguous_... S3490C11::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C3*), ABISELECT(12176,8632), "S3490C11");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C3*)(S3490C8*), ABISELECT(12176,8632), "S3490C11");
    /*is_ambiguous_... S3490C11::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C3*), ABISELECT(12688,8992), "S3490C11");
    /*is_ambiguous_... S3490C11::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C7*), ABISELECT(12688,8992), "S3490C11");
    /*is_ambiguous_... S3490C9::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C7*)(S3490C9*)(S3490C12*), ABISELECT(12688,8992), "S3490C11");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C3*)(S3490C8*), ABISELECT(12688,8992), "S3490C11");
    /*is_ambiguous_... S3490C9::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C7*)(S3490C9*)(S3490C8*), ABISELECT(12688,8992), "S3490C11");
    /*is_ambiguous_... S3490C11::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C3*), ABISELECT(12784,9044), "S3490C11");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C3*)(S3490C8*), ABISELECT(12784,9044), "S3490C11");
    /*is_ambiguous_... S3490C11::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C3*), ABISELECT(12152,8624), "S3490C11");
    check_base_class_offset(lv, (S3490C3*)(S3490C9*)(S3490C12*), ABISELECT(12152,8624), "S3490C11");
    check_base_class_offset(lv, (S3490C3*)(S3490C9*)(S3490C8*), ABISELECT(12152,8624), "S3490C11");
    /*is_ambiguous_... S3490C9::S3490C6 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C9*)(S3490C12*), 0, "S3490C11");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*)(S3490C9*)(S3490C12*), ABISELECT(96,52), "S3490C11");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C9*)(S3490C12*), ABISELECT(96,52), "S3490C11");
    /*is_ambiguous_... S3490C9::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C9*)(S3490C12*), ABISELECT(608,412), "S3490C11");
    check_base_class_offset(lv, (S3490C9*)(S3490C12*), 0, "S3490C11");
    check_base_class_offset(lv, (S3490C12*), 0, "S3490C11");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C3*)(S3490C8*), ABISELECT(3280,2332), "S3490C11");
    /*is_ambiguous_... S3490C9::S3490C6 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C9*)(S3490C8*), ABISELECT(3296,2340), "S3490C11");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*)(S3490C9*)(S3490C8*), ABISELECT(3392,2392), "S3490C11");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C9*)(S3490C8*), ABISELECT(3392,2392), "S3490C11");
    /*is_ambiguous_... S3490C9::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C9*)(S3490C8*), ABISELECT(3904,2752), "S3490C11");
    check_base_class_offset(lv, (S3490C9*)(S3490C8*), ABISELECT(3296,2340), "S3490C11");
    /*is_ambiguous_... S3490C8::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*)(S3490C8*), ABISELECT(6000,4280), "S3490C11");
    /*is_ambiguous_... S3490C8::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C8*), ABISELECT(6000,4280), "S3490C11");
    /*is_ambiguous_... S3490C8::S3490C6 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C8*), ABISELECT(6512,4640), "S3490C11");
    check_base_class_offset(lv, (S3490C8*), ABISELECT(3280,2332), "S3490C11");
    check_field_offset(lv, s3490c11f0, ABISELECT(7916,5596), "S3490C11.s3490c11f0");
    check_field_offset(lv, s3490c11f1, ABISELECT(7920,5600), "S3490C11.s3490c11f1");
    check_field_offset(lv, s3490c11f2, ABISELECT(12128,8600), "S3490C11.s3490c11f2");
    test_class_info(&lv, &cd_S3490C11);
    dp->~S3490C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3490C11(Test_S3490C11, "S3490C11", ABISELECT(13072,9276));

#else // __cplusplus

extern void _ZN8S3490C11C1Ev();
extern void _ZN8S3490C11D1Ev();
Name_Map name_map_S3490C11[] = {
  NSPAIR(_ZN8S3490C11C1Ev),
  NSPAIR(_ZN8S3490C11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3490C4;
extern VTBL_ENTRY _ZTI7S3490C4[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C7;
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
extern Class_Descriptor cd_S3490C3;
extern VTBL_ENTRY _ZTI7S3490C3[];
extern  VTBL_ENTRY _ZTV7S3490C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C3[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C7;
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
extern Class_Descriptor cd_S3490C9;
extern VTBL_ENTRY _ZTI7S3490C9[];
extern  VTBL_ENTRY _ZTV7S3490C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C9[];
extern Class_Descriptor cd_S3490C12;
extern VTBL_ENTRY _ZTI8S3490C12[];
extern  VTBL_ENTRY _ZTV8S3490C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3490C12[];
extern Class_Descriptor cd_S3490C3;
extern VTBL_ENTRY _ZTI7S3490C3[];
extern  VTBL_ENTRY _ZTV7S3490C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C3[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C7;
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
extern Class_Descriptor cd_S3490C9;
extern VTBL_ENTRY _ZTI7S3490C9[];
extern  VTBL_ENTRY _ZTV7S3490C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C9[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C8;
extern VTBL_ENTRY _ZTI7S3490C8[];
extern  VTBL_ENTRY _ZTV7S3490C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C8[];
static Base_Class bases_S3490C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3490C4,    ABISELECT(12136,8608), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3490C6,    ABISELECT(12176,8632), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(12176,8632), //bcp->offset
    61, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    44, //bcp->index_in_construction_vtbl_array
    58, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S3490C6,    ABISELECT(12688,8992), //bcp->offset
    66, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    45, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S3490C7,    ABISELECT(12784,9044), //bcp->offset
    70, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    46, //bcp->index_in_construction_vtbl_array
    59, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S3490C3,    ABISELECT(12152,8624), //bcp->offset
    55, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    43, //bcp->index_in_construction_vtbl_array
    54, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3490C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(96,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(96,52), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    47, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S3490C7,    ABISELECT(608,412), //bcp->offset
    16, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    48, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S3490C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S3490C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3490C3,    ABISELECT(3280,2332), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(3296,2340), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(3392,2392), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(3392,2392), //bcp->offset
    40, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    51, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S3490C7,    ABISELECT(3904,2752), //bcp->offset
    44, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    52, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S3490C9,    ABISELECT(3296,2340), //bcp->offset
    30, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    50, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(6000,4280), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(6000,4280), //bcp->offset
    48, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    53, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(6512,4640), //bcp->offset
    52, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S3490C8,    ABISELECT(3280,2332), //bcp->offset
    20, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    49, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S3490C11[];
extern void _ZN7S3490C62v2Ev();
extern void _ZN8S3490C11D1Ev();
extern void _ZN8S3490C11D0Ev();
extern void _ZN8S3490C122v7Ev();
extern void _ZN8S3490C122v8Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C72v3Ev();
extern void _ZN7S3490C82v4Ev();
extern void ABISELECT(_ZThn3280_N8S3490C11D1Ev,_ZThn2332_N8S3490C11D1Ev)();
extern void ABISELECT(_ZThn3280_N8S3490C11D0Ev,_ZThn2332_N8S3490C11D0Ev)();
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZThn3296_N8S3490C11D1Ev,_ZThn2340_N8S3490C11D1Ev)();
extern void ABISELECT(_ZThn3296_N8S3490C11D0Ev,_ZThn2340_N8S3490C11D0Ev)();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C72v3Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY vtc_S3490C11[] = {
  ABISELECT(12784,9044),
  ABISELECT(12176,8632),
  ABISELECT(12152,8624),
  ABISELECT(12688,8992),
  ABISELECT(12136,8608),
  0,
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN8S3490C11D1Ev,
  (VTBL_ENTRY)&_ZN8S3490C11D0Ev,
  (VTBL_ENTRY)&_ZN8S3490C122v7Ev,
  (VTBL_ENTRY)&_ZN8S3490C122v8Ev,
  ABISELECT(12040,8556),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(12080,8580),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
  ABISELECT(8872,6292),
  ABISELECT(9504,6712),
  ABISELECT(9408,6660),
  ABISELECT(8896,6300),
  ABISELECT(8856,6276),
  ABISELECT(-3280,-2332),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C82v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn3280_N8S3490C11D1Ev,_ZThn2332_N8S3490C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn3280_N8S3490C11D0Ev,_ZThn2332_N8S3490C11D0Ev),
  ABISELECT(9488,6704),
  ABISELECT(8880,6292),
  ABISELECT(8856,6284),
  ABISELECT(9392,6652),
  ABISELECT(8840,6268),
  ABISELECT(-3296,-2340),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn3296_N8S3490C11D1Ev,_ZThn2340_N8S3490C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn3296_N8S3490C11D0Ev,_ZThn2340_N8S3490C11D0Ev),
  ABISELECT(8744,6216),
  ABISELECT(-3392,-2392),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(8784,6240),
  ABISELECT(-3904,-2752),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
  ABISELECT(6136,4328),
  ABISELECT(-6000,-4280),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(-6512,-4640),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(632,420),
  ABISELECT(536,368),
  ABISELECT(24,8),
  -16,
  ABISELECT(-12152,-8624),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  0,
  ABISELECT(-40,-24),
  ABISELECT(-12176,-8632),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  0,
  ABISELECT(-12688,-8992),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  0,
  ABISELECT(-96,-52),
  ABISELECT(-12784,-9044),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern VTBL_ENTRY _ZTV8S3490C11[];
extern void _ZN7S3490C62v2Ev();
extern void _ZN8S3490C12D1Ev();
extern void _ZN8S3490C12D0Ev();
extern void _ZN8S3490C122v7Ev();
extern void _ZN8S3490C122v8Ev();
static  VTBL_ENTRY _tg__ZTV8S3490C12__8S3490C11[] = {
  ABISELECT(12784,9044),
  ABISELECT(12176,8632),
  ABISELECT(12152,8624),
  ABISELECT(12688,8992),
  ABISELECT(12136,8608),
  0,
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN8S3490C12D1Ev,
  (VTBL_ENTRY)&_ZN8S3490C12D0Ev,
  (VTBL_ENTRY)&_ZN8S3490C122v7Ev,
  (VTBL_ENTRY)&_ZN8S3490C122v8Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C9D1Ev();
extern void _ZN7S3490C9D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C98S3490C12__8S3490C11[] = {
  ABISELECT(12784,9044),
  ABISELECT(12176,8632),
  ABISELECT(12152,8624),
  ABISELECT(12688,8992),
  ABISELECT(12136,8608),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D0Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C98S3490C12__A1__8S3490C11[] = {
  ABISELECT(12040,8556),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C98S3490C12__A1__8S3490C11[] = {
  ABISELECT(12080,8580),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__7S3490C77S3490C98S3490C12__A1__8S3490C11[] = {
  0,
  ABISELECT(-12080,-8580),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A__7S3490C98S3490C12__8S3490C11[] = {
  ABISELECT(12040,8556),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A__7S3490C98S3490C12__8S3490C11[] = {
  ABISELECT(12080,8580),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A2__7S3490C98S3490C12__8S3490C11[] = {
  0,
  ABISELECT(-12688,-8992),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__7S3490C98S3490C12__8S3490C11[] = {
  ABISELECT(632,420),
  ABISELECT(536,368),
  ABISELECT(24,8),
  -16,
  ABISELECT(-12152,-8624),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A1__7S3490C98S3490C12__8S3490C11[] = {
  0,
  ABISELECT(-40,-24),
  ABISELECT(-12176,-8632),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A1__7S3490C98S3490C12__8S3490C11[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-12784,-9044),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C9__8S3490C12__8S3490C11[] = {
  ABISELECT(12040,8556),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C9__8S3490C12__8S3490C11[] = {
  ABISELECT(12080,8580),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A2__8S3490C12__8S3490C11[] = {
  0,
  ABISELECT(-12688,-8992),
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__8S3490C12__8S3490C11[] = {
  ABISELECT(632,420),
  ABISELECT(536,368),
  ABISELECT(24,8),
  -16,
  ABISELECT(-12152,-8624),
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A1__8S3490C12__8S3490C11[] = {
  0,
  ABISELECT(-40,-24),
  ABISELECT(-12176,-8632),
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A1__8S3490C12__8S3490C11[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-12784,-9044),
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C82v4Ev();
extern void _ZN7S3490C8D1Ev();
extern void _ZN7S3490C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C8__8S3490C11[] = {
  ABISELECT(8872,6292),
  ABISELECT(9504,6712),
  ABISELECT(9408,6660),
  ABISELECT(8896,6300),
  ABISELECT(8856,6276),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C82v4Ev,
  (VTBL_ENTRY)&_ZN7S3490C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C8D0Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C37S3490C8__A1__8S3490C11[] = {
  ABISELECT(9504,6712),
  ABISELECT(9408,6660),
  ABISELECT(8896,6300),
  ABISELECT(8856,6276),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C37S3490C8__A1__8S3490C11[] = {
  0,
  ABISELECT(-40,-24),
  ABISELECT(-8896,-6300),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C37S3490C8__A1__8S3490C11[] = {
  0,
  ABISELECT(-9408,-6660),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C37S3490C8__A1__8S3490C11[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-9504,-6712),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C9D1Ev();
extern void _ZN7S3490C9D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C97S3490C8__A1__8S3490C11[] = {
  ABISELECT(9488,6704),
  ABISELECT(8880,6292),
  ABISELECT(8856,6284),
  ABISELECT(9392,6652),
  ABISELECT(8840,6268),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D0Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C97S3490C8__A2__8S3490C11[] = {
  ABISELECT(8744,6216),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C97S3490C8__A2__8S3490C11[] = {
  ABISELECT(8784,6240),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__7S3490C77S3490C97S3490C8__A2__8S3490C11[] = {
  0,
  ABISELECT(-8784,-6240),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A__7S3490C97S3490C8__A1__8S3490C11[] = {
  ABISELECT(8744,6216),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A__7S3490C97S3490C8__A1__8S3490C11[] = {
  ABISELECT(8784,6240),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A2__7S3490C97S3490C8__A1__8S3490C11[] = {
  0,
  ABISELECT(-9392,-6652),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__7S3490C97S3490C8__A1__8S3490C11[] = {
  ABISELECT(632,420),
  ABISELECT(536,368),
  ABISELECT(24,8),
  -16,
  ABISELECT(-8856,-6284),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A1__7S3490C97S3490C8__A1__8S3490C11[] = {
  0,
  ABISELECT(-40,-24),
  ABISELECT(-8880,-6292),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A1__7S3490C97S3490C8__A1__8S3490C11[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-9488,-6704),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C8__A3__8S3490C11[] = {
  ABISELECT(6136,4328),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C8__8S3490C11[] = {
  0,
  ABISELECT(-40,-24),
  ABISELECT(-8896,-6300),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C8__8S3490C11[] = {
  0,
  ABISELECT(-9408,-6660),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C8__8S3490C11[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-9504,-6712),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZThn16_N7S3490C8D1Ev,_ZThn8_N7S3490C8D1Ev)();
extern void ABISELECT(_ZThn16_N7S3490C8D0Ev,_ZThn8_N7S3490C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S3490C9__7S3490C8__8S3490C11[] = {
  ABISELECT(9488,6704),
  ABISELECT(8880,6292),
  ABISELECT(8856,6284),
  ABISELECT(9392,6652),
  ABISELECT(8840,6268),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S3490C8D1Ev,_ZThn8_N7S3490C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S3490C8D0Ev,_ZThn8_N7S3490C8D0Ev),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C9__A1__7S3490C8__8S3490C11[] = {
  ABISELECT(8744,6216),
  ABISELECT(-112,-60),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C9__A1__7S3490C8__8S3490C11[] = {
  ABISELECT(8784,6240),
  ABISELECT(-624,-420),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__A1__7S3490C8__8S3490C11[] = {
  ABISELECT(632,420),
  ABISELECT(536,368),
  ABISELECT(24,8),
  -16,
  ABISELECT(-8872,-6292),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A__7S3490C8__8S3490C11[] = {
  ABISELECT(6136,4328),
  ABISELECT(-2720,-1948),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__8S3490C11[] = {
  ABISELECT(632,420),
  ABISELECT(536,368),
  ABISELECT(24,8),
  -16,
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C3__8S3490C11[] = {
  0,
  ABISELECT(-40,-24),
  ABISELECT(-24,-8),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C3__8S3490C11[] = {
  0,
  ABISELECT(-536,-368),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C3__8S3490C11[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-632,-420),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__8S3490C11[] = {
  ABISELECT(-40,-24),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__8S3490C11[] = {
  ABISELECT(-96,-52),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__7S3490C7__8S3490C11[] = {
  0,
  ABISELECT(96,52),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTT_ENTRY vtt_S3490C11[] = {
  {&(_ZTV8S3490C11[7]),  7,75},
  {&(_tg__ZTV8S3490C12__8S3490C11[7]),  7,12},
  {&(_tg__ZTV7S3490C98S3490C12__8S3490C11[7]),  7,10},
  {&(_tg__ZTV7S3490C57S3490C98S3490C12__A1__8S3490C11[3]),  3,4},
  {&(_tg__ZTV7S3490C77S3490C98S3490C12__A1__8S3490C11[3]),  3,4},
  {&(_tg__ZTV7S3490C6__7S3490C77S3490C98S3490C12__A1__8S3490C11[3]),  3,4},
  {&(_tg__ZTV7S3490C5__A__7S3490C98S3490C12__8S3490C11[3]),  3,4},
  {&(_tg__ZTV7S3490C7__A__7S3490C98S3490C12__8S3490C11[3]),  3,4},
  {&(_tg__ZTV7S3490C6__A2__7S3490C98S3490C12__8S3490C11[3]),  3,4},
  {&(_tg__ZTV7S3490C3__7S3490C98S3490C12__8S3490C11[6]),  6,6},
  {&(_tg__ZTV7S3490C5__A1__7S3490C98S3490C12__8S3490C11[4]),  4,5},
  {&(_tg__ZTV7S3490C7__A1__7S3490C98S3490C12__8S3490C11[4]),  4,5},
  {&(_tg__ZTV7S3490C57S3490C9__8S3490C12__8S3490C11[3]),  3,4},
  {&(_tg__ZTV7S3490C77S3490C9__8S3490C12__8S3490C11[3]),  3,4},
  {&(_tg__ZTV7S3490C6__A2__8S3490C12__8S3490C11[3]),  3,4},
  {&(_tg__ZTV7S3490C3__8S3490C12__8S3490C11[6]),  6,6},
  {&(_tg__ZTV7S3490C5__A1__8S3490C12__8S3490C11[4]),  4,5},
  {&(_tg__ZTV7S3490C7__A1__8S3490C12__8S3490C11[4]),  4,5},
  {&(_tg__ZTV7S3490C8__8S3490C11[7]),  7,10},
  {&(_tg__ZTV7S3490C37S3490C8__A1__8S3490C11[6]),  6,6},
  {&(_tg__ZTV7S3490C5__7S3490C37S3490C8__A1__8S3490C11[4]),  4,5},
  {&(_tg__ZTV7S3490C6__A1__7S3490C37S3490C8__A1__8S3490C11[3]),  3,4},
  {&(_tg__ZTV7S3490C7__7S3490C37S3490C8__A1__8S3490C11[4]),  4,5},
  {&(_tg__ZTV7S3490C97S3490C8__A1__8S3490C11[7]),  7,10},
  {&(_tg__ZTV7S3490C57S3490C97S3490C8__A2__8S3490C11[3]),  3,4},
  {&(_tg__ZTV7S3490C77S3490C97S3490C8__A2__8S3490C11[3]),  3,4},
  {&(_tg__ZTV7S3490C6__7S3490C77S3490C97S3490C8__A2__8S3490C11[3]),  3,4},
  {&(_tg__ZTV7S3490C5__A__7S3490C97S3490C8__A1__8S3490C11[3]),  3,4},
  {&(_tg__ZTV7S3490C7__A__7S3490C97S3490C8__A1__8S3490C11[3]),  3,4},
  {&(_tg__ZTV7S3490C6__A2__7S3490C97S3490C8__A1__8S3490C11[3]),  3,4},
  {&(_tg__ZTV7S3490C3__7S3490C97S3490C8__A1__8S3490C11[6]),  6,6},
  {&(_tg__ZTV7S3490C5__A1__7S3490C97S3490C8__A1__8S3490C11[4]),  4,5},
  {&(_tg__ZTV7S3490C7__A1__7S3490C97S3490C8__A1__8S3490C11[4]),  4,5},
  {&(_tg__ZTV7S3490C57S3490C8__A3__8S3490C11[3]),  3,4},
  {&(_tg__ZTV7S3490C5__7S3490C8__8S3490C11[4]),  4,5},
  {&(_tg__ZTV7S3490C6__A1__7S3490C8__8S3490C11[3]),  3,4},
  {&(_tg__ZTV7S3490C7__7S3490C8__8S3490C11[4]),  4,5},
  {&(_tg__ZTV7S3490C9__7S3490C8__8S3490C11[7]),  7,10},
  {&(_tg__ZTV7S3490C57S3490C9__A1__7S3490C8__8S3490C11[3]),  3,4},
  {&(_tg__ZTV7S3490C77S3490C9__A1__7S3490C8__8S3490C11[3]),  3,4},
  {&(_tg__ZTV7S3490C3__A1__7S3490C8__8S3490C11[6]),  6,6},
  {&(_tg__ZTV7S3490C5__A__7S3490C8__8S3490C11[3]),  3,4},
  {&(_ZTV8S3490C11[61]),  61,75},
  {&(_ZTV8S3490C11[65]),  65,75},
  {&(_ZTV8S3490C11[69]),  69,75},
  {&(_ZTV8S3490C11[74]),  74,75},
  {&(_ZTV8S3490C11[15]),  15,75},
  {&(_ZTV8S3490C11[19]),  19,75},
  {&(_ZTV8S3490C11[27]),  27,75},
  {&(_ZTV8S3490C11[37]),  37,75},
  {&(_ZTV8S3490C11[43]),  43,75},
  {&(_ZTV8S3490C11[47]),  47,75},
  {&(_ZTV8S3490C11[51]),  51,75},
  {&(_tg__ZTV7S3490C3__8S3490C11[6]),  6,6},
  {&(_tg__ZTV7S3490C5__7S3490C3__8S3490C11[4]),  4,5},
  {&(_tg__ZTV7S3490C6__A1__7S3490C3__8S3490C11[3]),  3,4},
  {&(_tg__ZTV7S3490C7__7S3490C3__8S3490C11[4]),  4,5},
  {&(_tg__ZTV7S3490C5__8S3490C11[3]),  3,4},
  {&(_tg__ZTV7S3490C7__8S3490C11[3]),  3,4},
  {&(_tg__ZTV7S3490C6__7S3490C7__8S3490C11[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8S3490C11[];
extern  VTBL_ENTRY _ZTV8S3490C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3490C11[];
Class_Descriptor cd_S3490C11 = {  "S3490C11", // class name
  bases_S3490C11, 22,
  &(vtc_S3490C11[0]), // expected_vtbl_contents
  &(vtt_S3490C11[0]), // expected_vtt_contents
  ABISELECT(13072,9276), // object size
  NSPAIRA(_ZTI8S3490C11),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S3490C11),75, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S3490C11),60, //virtual table table var
  21, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3490C14  : virtual S3490C3 , S3490C9 , S3490C12 {
  int s3490c14f0;
  char s3490c14f1;
  void *s3490c14f2;
  long s3490c14f3;
  virtual void  v9(); // _ZN8S3490C142v9Ev
  ~S3490C14(); // tgen
  S3490C14(); // tgen
};
//SIG(-1 S3490C14) C1{ VBC2{ VBC3{ m FL Fi Fc} VBC4{ BC5{ v2 FD Fi:3 Fc:8 FD[2] FL} VBC3 Fc[10] Fi FC6{ VBC5 v3 FC3 FL FC3[7] Fp FL FC3 Fp Fc Fs Fi FC5} FL} VBC5 VBC6 Fp} BC7{ BC5 VBC3 BC4 BC6 VBC2 vd FC6 FC2 Fp Fi FC5 FC6} BC8{ BC7 vd v4 v5 Fp Fs:6 FC5 FD Fi FC3 FC6 Fp Fi Fp[2]} v1 Fi Fc Fp Fl}


void  S3490C14 ::v9(){vfunc_called(this, "_ZN8S3490C142v9Ev");}
S3490C14 ::~S3490C14(){ note_dtor("S3490C14", this);} // tgen
S3490C14 ::S3490C14(){ note_ctor("S3490C14", this);} // tgen

static void Test_S3490C14()
{
  extern Class_Descriptor cd_S3490C14;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(435,1240)];
    init_test(&cd_S3490C14, buf);
    S3490C14 *dp, &lv = *(dp=new (buf) S3490C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(6944,4956), "sizeof(S3490C14)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S3490C14)");
    check_base_class_offset(lv, (S3490C4*)(S3490C3*), ABISELECT(6024,4296), "S3490C14");
    /*is_ambiguous_... S3490C14::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*), ABISELECT(6024,4296), "S3490C14");
    /*is_ambiguous_... S3490C14::S3490C9 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C9*), ABISELECT(6024,4296), "S3490C14");
    /*is_ambiguous_... S3490C14::S3490C9 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*)(S3490C9*), ABISELECT(6024,4296), "S3490C14");
    check_base_class_offset(lv, (S3490C4*)(S3490C9*)(S3490C12*), ABISELECT(6024,4296), "S3490C14");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*)(S3490C9*)(S3490C12*), ABISELECT(6024,4296), "S3490C14");
    /*is_ambiguous_... S3490C14::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*), ABISELECT(6048,4312), "S3490C14");
    check_base_class_offset(lv, (S3490C5*)(S3490C3*), ABISELECT(6048,4312), "S3490C14");
    /*is_ambiguous_... S3490C3::S3490C6 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C3*), ABISELECT(6560,4672), "S3490C14");
    /*is_ambiguous_... S3490C14::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C7*), ABISELECT(6560,4672), "S3490C14");
    /*is_ambiguous_... S3490C14::S3490C9 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C7*)(S3490C9*), ABISELECT(6560,4672), "S3490C14");
    /*is_ambiguous_... S3490C9::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C7*)(S3490C9*)(S3490C12*), ABISELECT(6560,4672), "S3490C14");
    check_base_class_offset(lv, (S3490C7*)(S3490C3*), ABISELECT(6656,4724), "S3490C14");
    check_base_class_offset(lv, (S3490C3*), ABISELECT(6008,4288), "S3490C14");
    /*is_ambiguous_... S3490C14::S3490C9 */ AMB_check_base_class_offset(lv, (S3490C3*)(S3490C9*), ABISELECT(6008,4288), "S3490C14");
    check_base_class_offset(lv, (S3490C3*)(S3490C9*)(S3490C12*), ABISELECT(6008,4288), "S3490C14");
    /*is_ambiguous_... S3490C14::S3490C9 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C9*), 0, "S3490C14");
    /*is_ambiguous_... S3490C14::S3490C9 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*)(S3490C9*), ABISELECT(96,52), "S3490C14");
    /*is_ambiguous_... S3490C14::S3490C9 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C9*), ABISELECT(96,52), "S3490C14");
    /*is_ambiguous_... S3490C14::S3490C9 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C9*), ABISELECT(608,412), "S3490C14");
    /*is_ambiguous_... S3490C14::S3490C9 */ AMB_check_base_class_offset(lv, (S3490C9*), 0, "S3490C14");
    /*is_ambiguous_... S3490C9::S3490C6 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C9*)(S3490C12*), ABISELECT(2704,1940), "S3490C14");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*)(S3490C9*)(S3490C12*), ABISELECT(2800,1992), "S3490C14");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C9*)(S3490C12*), ABISELECT(2800,1992), "S3490C14");
    /*is_ambiguous_... S3490C9::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C9*)(S3490C12*), ABISELECT(3312,2352), "S3490C14");
    check_base_class_offset(lv, (S3490C9*)(S3490C12*), ABISELECT(2704,1940), "S3490C14");
    check_base_class_offset(lv, (S3490C12*), ABISELECT(2704,1940), "S3490C14");
    check_field_offset(lv, s3490c14f0, ABISELECT(5984,4272), "S3490C14.s3490c14f0");
    check_field_offset(lv, s3490c14f1, ABISELECT(5988,4276), "S3490C14.s3490c14f1");
    check_field_offset(lv, s3490c14f2, ABISELECT(5992,4280), "S3490C14.s3490c14f2");
    check_field_offset(lv, s3490c14f3, ABISELECT(6000,4284), "S3490C14.s3490c14f3");
    test_class_info(&lv, &cd_S3490C14);
    dp->~S3490C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3490C14(Test_S3490C14, "S3490C14", ABISELECT(6944,4956));

#else // __cplusplus

extern void _ZN8S3490C14C1Ev();
extern void _ZN8S3490C14D1Ev();
Name_Map name_map_S3490C14[] = {
  NSPAIR(_ZN8S3490C14C1Ev),
  NSPAIR(_ZN8S3490C14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3490C4;
extern VTBL_ENTRY _ZTI7S3490C4[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C7;
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
extern Class_Descriptor cd_S3490C3;
extern VTBL_ENTRY _ZTI7S3490C3[];
extern  VTBL_ENTRY _ZTV7S3490C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C3[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C7;
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
extern Class_Descriptor cd_S3490C9;
extern VTBL_ENTRY _ZTI7S3490C9[];
extern  VTBL_ENTRY _ZTV7S3490C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C9[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C7;
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
extern Class_Descriptor cd_S3490C9;
extern VTBL_ENTRY _ZTI7S3490C9[];
extern  VTBL_ENTRY _ZTV7S3490C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C9[];
extern Class_Descriptor cd_S3490C12;
extern VTBL_ENTRY _ZTI8S3490C12[];
extern  VTBL_ENTRY _ZTV8S3490C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3490C12[];
static Base_Class bases_S3490C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3490C4,    ABISELECT(6024,4296), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S3490C6,    ABISELECT(6048,4312), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(6048,4312), //bcp->offset
    45, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    42, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S3490C6,    ABISELECT(6560,4672), //bcp->offset
    50, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S3490C7,    ABISELECT(6656,4724), //bcp->offset
    54, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    32, //bcp->index_in_construction_vtbl_array
    43, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S3490C3,    ABISELECT(6008,4288), //bcp->offset
    39, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    38, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3490C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(96,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(96,52), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    33, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S3490C7,    ABISELECT(608,412), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    34, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S3490C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3490C6,    ABISELECT(2704,1940), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(2800,1992), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(2800,1992), //bcp->offset
    31, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    36, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S3490C7,    ABISELECT(3312,2352), //bcp->offset
    35, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    37, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S3490C9,    ABISELECT(2704,1940), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S3490C12,    ABISELECT(2704,1940), //bcp->offset
    19, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    35, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S3490C14[];
extern void _ZN7S3490C62v2Ev();
extern void _ZN8S3490C14D1Ev();
extern void _ZN8S3490C14D0Ev();
extern void _ZN8S3490C142v9Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C72v3Ev();
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZThn2704_N8S3490C14D1Ev,_ZThn1940_N8S3490C14D1Ev)();
extern void ABISELECT(_ZThn2704_N8S3490C14D0Ev,_ZThn1940_N8S3490C14D0Ev)();
extern void _ZN8S3490C122v7Ev();
extern void _ZN8S3490C122v8Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C72v3Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY vtc_S3490C14[] = {
  ABISELECT(6656,4724),
  ABISELECT(6048,4312),
  ABISELECT(6008,4288),
  ABISELECT(6560,4672),
  ABISELECT(6024,4296),
  0,
  (VTBL_ENTRY)&(_ZTI8S3490C14[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN8S3490C14D1Ev,
  (VTBL_ENTRY)&_ZN8S3490C14D0Ev,
  (VTBL_ENTRY)&_ZN8S3490C142v9Ev,
  ABISELECT(5928,4244),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI8S3490C14[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(5952,4260),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI8S3490C14[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
  ABISELECT(3952,2784),
  ABISELECT(3344,2372),
  ABISELECT(3304,2348),
  ABISELECT(3856,2732),
  ABISELECT(3320,2356),
  ABISELECT(-2704,-1940),
  (VTBL_ENTRY)&(_ZTI8S3490C14[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn2704_N8S3490C14D1Ev,_ZThn1940_N8S3490C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2704_N8S3490C14D0Ev,_ZThn1940_N8S3490C14D0Ev),
  (VTBL_ENTRY)&_ZN8S3490C122v7Ev,
  (VTBL_ENTRY)&_ZN8S3490C122v8Ev,
  ABISELECT(3224,2304),
  ABISELECT(-2800,-1992),
  (VTBL_ENTRY)&(_ZTI8S3490C14[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(3248,2320),
  ABISELECT(-3312,-2352),
  (VTBL_ENTRY)&(_ZTI8S3490C14[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
  ABISELECT(648,436),
  ABISELECT(552,384),
  ABISELECT(40,24),
  ABISELECT(16,8),
  ABISELECT(-6008,-4288),
  (VTBL_ENTRY)&(_ZTI8S3490C14[0]),
  0,
  ABISELECT(-24,-16),
  ABISELECT(-6048,-4312),
  (VTBL_ENTRY)&(_ZTI8S3490C14[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  0,
  ABISELECT(-6560,-4672),
  (VTBL_ENTRY)&(_ZTI8S3490C14[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  0,
  ABISELECT(-96,-52),
  ABISELECT(-6656,-4724),
  (VTBL_ENTRY)&(_ZTI8S3490C14[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern VTBL_ENTRY _ZTV8S3490C14[];
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C9D1Ev();
extern void _ZN7S3490C9D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C9__8S3490C14[] = {
  ABISELECT(6656,4724),
  ABISELECT(6048,4312),
  ABISELECT(6008,4288),
  ABISELECT(6560,4672),
  ABISELECT(6024,4296),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D0Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C9__A1__8S3490C14[] = {
  ABISELECT(5928,4244),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C9__A1__8S3490C14[] = {
  ABISELECT(5952,4260),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__7S3490C77S3490C9__A1__8S3490C14[] = {
  0,
  ABISELECT(-5952,-4260),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A__7S3490C9__8S3490C14[] = {
  ABISELECT(5928,4244),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A__7S3490C9__8S3490C14[] = {
  ABISELECT(5952,4260),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A2__7S3490C9__8S3490C14[] = {
  0,
  ABISELECT(-6560,-4672),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__7S3490C9__8S3490C14[] = {
  ABISELECT(648,436),
  ABISELECT(552,384),
  ABISELECT(40,24),
  ABISELECT(16,8),
  ABISELECT(-6008,-4288),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A1__7S3490C9__8S3490C14[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-6048,-4312),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A1__7S3490C9__8S3490C14[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-6656,-4724),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void _ZN8S3490C12D1Ev();
extern void _ZN8S3490C12D0Ev();
extern void _ZN8S3490C122v7Ev();
extern void _ZN8S3490C122v8Ev();
static  VTBL_ENTRY _tg__ZTV8S3490C12__8S3490C14[] = {
  ABISELECT(3952,2784),
  ABISELECT(3344,2372),
  ABISELECT(3304,2348),
  ABISELECT(3856,2732),
  ABISELECT(3320,2356),
  0,
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN8S3490C12D1Ev,
  (VTBL_ENTRY)&_ZN8S3490C12D0Ev,
  (VTBL_ENTRY)&_ZN8S3490C122v7Ev,
  (VTBL_ENTRY)&_ZN8S3490C122v8Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C9D1Ev();
extern void _ZN7S3490C9D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C98S3490C12__A1__8S3490C14[] = {
  ABISELECT(3952,2784),
  ABISELECT(3344,2372),
  ABISELECT(3304,2348),
  ABISELECT(3856,2732),
  ABISELECT(3320,2356),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D0Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C98S3490C12__A2__8S3490C14[] = {
  ABISELECT(3224,2304),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C98S3490C12__A2__8S3490C14[] = {
  ABISELECT(3248,2320),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__7S3490C77S3490C98S3490C12__A2__8S3490C14[] = {
  0,
  ABISELECT(-3248,-2320),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A__7S3490C98S3490C12__A1__8S3490C14[] = {
  ABISELECT(3224,2304),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A__7S3490C98S3490C12__A1__8S3490C14[] = {
  ABISELECT(3248,2320),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A2__7S3490C98S3490C12__A1__8S3490C14[] = {
  0,
  ABISELECT(-3856,-2732),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__7S3490C98S3490C12__A1__8S3490C14[] = {
  ABISELECT(648,436),
  ABISELECT(552,384),
  ABISELECT(40,24),
  ABISELECT(16,8),
  ABISELECT(-3304,-2348),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A1__7S3490C98S3490C12__A1__8S3490C14[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-3344,-2372),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A1__7S3490C98S3490C12__A1__8S3490C14[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-3952,-2784),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C9__8S3490C12__8S3490C14[] = {
  ABISELECT(3224,2304),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C9__8S3490C12__8S3490C14[] = {
  ABISELECT(3248,2320),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A2__8S3490C12__8S3490C14[] = {
  0,
  ABISELECT(-3856,-2732),
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__8S3490C12__8S3490C14[] = {
  ABISELECT(648,436),
  ABISELECT(552,384),
  ABISELECT(40,24),
  ABISELECT(16,8),
  ABISELECT(-3304,-2348),
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A1__8S3490C12__8S3490C14[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-3344,-2372),
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A1__8S3490C12__8S3490C14[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-3952,-2784),
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__8S3490C14[] = {
  ABISELECT(648,436),
  ABISELECT(552,384),
  ABISELECT(40,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C3__8S3490C14[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C3__8S3490C14[] = {
  0,
  ABISELECT(-552,-384),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C3__8S3490C14[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-648,-436),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__8S3490C14[] = {
  ABISELECT(-24,-16),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__8S3490C14[] = {
  ABISELECT(-96,-52),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__7S3490C7__8S3490C14[] = {
  0,
  ABISELECT(96,52),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTT_ENTRY vtt_S3490C14[] = {
  {&(_ZTV8S3490C14[7]),  7,59},
  {&(_tg__ZTV7S3490C9__8S3490C14[7]),  7,10},
  {&(_tg__ZTV7S3490C57S3490C9__A1__8S3490C14[3]),  3,4},
  {&(_tg__ZTV7S3490C77S3490C9__A1__8S3490C14[3]),  3,4},
  {&(_tg__ZTV7S3490C6__7S3490C77S3490C9__A1__8S3490C14[3]),  3,4},
  {&(_tg__ZTV7S3490C5__A__7S3490C9__8S3490C14[3]),  3,4},
  {&(_tg__ZTV7S3490C7__A__7S3490C9__8S3490C14[3]),  3,4},
  {&(_tg__ZTV7S3490C6__A2__7S3490C9__8S3490C14[3]),  3,4},
  {&(_tg__ZTV7S3490C3__7S3490C9__8S3490C14[6]),  6,6},
  {&(_tg__ZTV7S3490C5__A1__7S3490C9__8S3490C14[4]),  4,5},
  {&(_tg__ZTV7S3490C7__A1__7S3490C9__8S3490C14[4]),  4,5},
  {&(_tg__ZTV8S3490C12__8S3490C14[7]),  7,12},
  {&(_tg__ZTV7S3490C98S3490C12__A1__8S3490C14[7]),  7,10},
  {&(_tg__ZTV7S3490C57S3490C98S3490C12__A2__8S3490C14[3]),  3,4},
  {&(_tg__ZTV7S3490C77S3490C98S3490C12__A2__8S3490C14[3]),  3,4},
  {&(_tg__ZTV7S3490C6__7S3490C77S3490C98S3490C12__A2__8S3490C14[3]),  3,4},
  {&(_tg__ZTV7S3490C5__A__7S3490C98S3490C12__A1__8S3490C14[3]),  3,4},
  {&(_tg__ZTV7S3490C7__A__7S3490C98S3490C12__A1__8S3490C14[3]),  3,4},
  {&(_tg__ZTV7S3490C6__A2__7S3490C98S3490C12__A1__8S3490C14[3]),  3,4},
  {&(_tg__ZTV7S3490C3__7S3490C98S3490C12__A1__8S3490C14[6]),  6,6},
  {&(_tg__ZTV7S3490C5__A1__7S3490C98S3490C12__A1__8S3490C14[4]),  4,5},
  {&(_tg__ZTV7S3490C7__A1__7S3490C98S3490C12__A1__8S3490C14[4]),  4,5},
  {&(_tg__ZTV7S3490C57S3490C9__8S3490C12__8S3490C14[3]),  3,4},
  {&(_tg__ZTV7S3490C77S3490C9__8S3490C12__8S3490C14[3]),  3,4},
  {&(_tg__ZTV7S3490C6__A2__8S3490C12__8S3490C14[3]),  3,4},
  {&(_tg__ZTV7S3490C3__8S3490C12__8S3490C14[6]),  6,6},
  {&(_tg__ZTV7S3490C5__A1__8S3490C12__8S3490C14[4]),  4,5},
  {&(_tg__ZTV7S3490C7__A1__8S3490C12__8S3490C14[4]),  4,5},
  {&(_ZTV8S3490C14[45]),  45,59},
  {&(_ZTV8S3490C14[49]),  49,59},
  {&(_ZTV8S3490C14[53]),  53,59},
  {&(_ZTV8S3490C14[58]),  58,59},
  {&(_ZTV8S3490C14[14]),  14,59},
  {&(_ZTV8S3490C14[18]),  18,59},
  {&(_ZTV8S3490C14[26]),  26,59},
  {&(_ZTV8S3490C14[34]),  34,59},
  {&(_ZTV8S3490C14[38]),  38,59},
  {&(_tg__ZTV7S3490C3__8S3490C14[6]),  6,6},
  {&(_tg__ZTV7S3490C5__7S3490C3__8S3490C14[4]),  4,5},
  {&(_tg__ZTV7S3490C6__A1__7S3490C3__8S3490C14[3]),  3,4},
  {&(_tg__ZTV7S3490C7__7S3490C3__8S3490C14[4]),  4,5},
  {&(_tg__ZTV7S3490C5__8S3490C14[3]),  3,4},
  {&(_tg__ZTV7S3490C7__8S3490C14[3]),  3,4},
  {&(_tg__ZTV7S3490C6__7S3490C7__8S3490C14[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8S3490C14[];
extern  VTBL_ENTRY _ZTV8S3490C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3490C14[];
Class_Descriptor cd_S3490C14 = {  "S3490C14", // class name
  bases_S3490C14, 17,
  &(vtc_S3490C14[0]), // expected_vtbl_contents
  &(vtt_S3490C14[0]), // expected_vtt_contents
  ABISELECT(6944,4956), // object size
  NSPAIRA(_ZTI8S3490C14),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S3490C14),59, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S3490C14),44, //virtual table table var
  16, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3490C10  : virtual S3490C9 , S3490C11 , S3490C2 {
  int s3490c10f0[10];
  long double s3490c10f1;
  void *s3490c10f2[9];
  long s3490c10f3[8];
  int s3490c10f4;
  void *s3490c10f5;
  ::S3490C14 s3490c10f6;
  void *s3490c10f7;
  ~S3490C10(); // tgen
  S3490C10(); // tgen
};
//SIG(-1 S3490C10) C1{ VBC2{ BC3{ v1 FD Fi:3 Fc:8 FD[2] FL} VBC4{ m FL Fi Fc} BC5{ BC3 VBC4 Fc[10] Fi FC6{ VBC3 v2 FC4 FL FC4[7] Fp FL FC4 Fp Fc Fs Fi FC3} FL} BC6 VBC7{ VBC4 VBC5 VBC3 VBC6 Fp} vd FC6 FC7 Fp Fi FC3 FC6} BC8{ VBC4 VBC7 BC9{ BC2 vd v3 v4 Fp Fs:6 FC3 FD Fi FC4 FC6 Fp Fi Fp[2]} BC10{ BC7 BC2 BC5 BC3 v5 FC5[2] FC3 Fi FC4 Fp[10] Fi[2] FL FD FL Fi} FC11{} FC9 FL} BC12{ BC7 BC10 vd v6 v7 Fp[2] Fi Fc FC5 FC10 FD} Fi[10] FD Fp[9] Fl[8] Fi Fp FC13{ VBC7 BC2 BC9 v8 Fi Fc Fp Fl} Fp}


S3490C10 ::~S3490C10(){ note_dtor("S3490C10", this);} // tgen
S3490C10 ::S3490C10(){ note_ctor("S3490C10", this);} // tgen

static void Test_S3490C10()
{
  extern Class_Descriptor cd_S3490C10;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(2111,5979)];
    init_test(&cd_S3490C10, buf);
    S3490C10 *dp, &lv = *(dp=new (buf) S3490C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(33760,23912), "sizeof(S3490C10)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S3490C10)");
    /*is_ambiguous_... S3490C10::S3490C9 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C9*), ABISELECT(30128,21304), "S3490C10");
    /*is_ambiguous_... S3490C10::S3490C9 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C9*), ABISELECT(32832,23244), "S3490C10");
    /*is_ambiguous_... S3490C10::S3490C9 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*)(S3490C9*), ABISELECT(32832,23244), "S3490C10");
    /*is_ambiguous_... S3490C10::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C3*), ABISELECT(32832,23244), "S3490C10");
    /*is_ambiguous_... S3490C10::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*), ABISELECT(32832,23244), "S3490C10");
    check_base_class_offset(lv, (S3490C4*)(S3490C11*), ABISELECT(32832,23244), "S3490C10");
    check_base_class_offset(lv, (S3490C4*)(S3490C9*)(S3490C12*)(S3490C11*), ABISELECT(32832,23244), "S3490C10");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*)(S3490C9*)(S3490C12*)(S3490C11*), ABISELECT(32832,23244), "S3490C10");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C3*)(S3490C8*)(S3490C11*), ABISELECT(32832,23244), "S3490C10");
    check_base_class_offset(lv, (S3490C4*)(S3490C9*)(S3490C8*)(S3490C11*), ABISELECT(32832,23244), "S3490C10");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*)(S3490C9*)(S3490C8*)(S3490C11*), ABISELECT(32832,23244), "S3490C10");
    /*is_ambiguous_... S3490C8::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*)(S3490C8*)(S3490C11*), ABISELECT(32832,23244), "S3490C10");
    /*is_ambiguous_... S3490C2::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C3*)(S3490C2*), ABISELECT(32832,23244), "S3490C10");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C3*)(S3490C8*)(S3490C2*), ABISELECT(32832,23244), "S3490C10");
    check_base_class_offset(lv, (S3490C4*)(S3490C9*)(S3490C8*)(S3490C2*), ABISELECT(32832,23244), "S3490C10");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*)(S3490C9*)(S3490C8*)(S3490C2*), ABISELECT(32832,23244), "S3490C10");
    /*is_ambiguous_... S3490C8::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*)(S3490C8*)(S3490C2*), ABISELECT(32832,23244), "S3490C10");
    /*is_ambiguous_... S3490C10::S3490C9 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*)(S3490C9*), ABISELECT(30224,21356), "S3490C10");
    /*is_ambiguous_... S3490C10::S3490C9 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C9*), ABISELECT(30224,21356), "S3490C10");
    /*is_ambiguous_... S3490C10::S3490C9 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C7*)(S3490C9*), ABISELECT(32848,23260), "S3490C10");
    /*is_ambiguous_... S3490C10::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C3*), ABISELECT(32848,23260), "S3490C10");
    /*is_ambiguous_... S3490C10::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C7*), ABISELECT(32848,23260), "S3490C10");
    /*is_ambiguous_... S3490C9::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C7*)(S3490C9*)(S3490C12*)(S3490C11*), ABISELECT(32848,23260), "S3490C10");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C3*)(S3490C8*)(S3490C11*), ABISELECT(32848,23260), "S3490C10");
    /*is_ambiguous_... S3490C9::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C7*)(S3490C9*)(S3490C8*)(S3490C11*), ABISELECT(32848,23260), "S3490C10");
    /*is_ambiguous_... S3490C2::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C3*)(S3490C2*), ABISELECT(32848,23260), "S3490C10");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C3*)(S3490C8*)(S3490C2*), ABISELECT(32848,23260), "S3490C10");
    /*is_ambiguous_... S3490C9::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C7*)(S3490C9*)(S3490C8*)(S3490C2*), ABISELECT(32848,23260), "S3490C10");
    /*is_ambiguous_... S3490C10::S3490C9 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C9*), ABISELECT(30736,21716), "S3490C10");
    /*is_ambiguous_... S3490C10::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*), ABISELECT(32960,23320), "S3490C10");
    /*is_ambiguous_... S3490C10::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C3*), ABISELECT(32960,23320), "S3490C10");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C3*)(S3490C8*)(S3490C11*), ABISELECT(32960,23320), "S3490C10");
    /*is_ambiguous_... S3490C2::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C3*)(S3490C2*), ABISELECT(32960,23320), "S3490C10");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C3*)(S3490C8*)(S3490C2*), ABISELECT(32960,23320), "S3490C10");
    /*is_ambiguous_... S3490C10::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C3*), ABISELECT(33472,23680), "S3490C10");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C3*)(S3490C8*)(S3490C11*), ABISELECT(33472,23680), "S3490C10");
    /*is_ambiguous_... S3490C2::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C3*)(S3490C2*), ABISELECT(33472,23680), "S3490C10");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C3*)(S3490C8*)(S3490C2*), ABISELECT(33472,23680), "S3490C10");
    /*is_ambiguous_... S3490C10::S3490C9 */ AMB_check_base_class_offset(lv, (S3490C3*)(S3490C9*), ABISELECT(32936,23312), "S3490C10");
    /*is_ambiguous_... S3490C11::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C3*)(S3490C11*), ABISELECT(32936,23312), "S3490C10");
    check_base_class_offset(lv, (S3490C3*)(S3490C9*)(S3490C12*)(S3490C11*), ABISELECT(32936,23312), "S3490C10");
    check_base_class_offset(lv, (S3490C3*)(S3490C9*)(S3490C8*)(S3490C11*), ABISELECT(32936,23312), "S3490C10");
    check_base_class_offset(lv, (S3490C3*)(S3490C9*)(S3490C8*)(S3490C2*), ABISELECT(32936,23312), "S3490C10");
    /*is_ambiguous_... S3490C10::S3490C9 */ AMB_check_base_class_offset(lv, (S3490C9*), ABISELECT(30128,21304), "S3490C10");
    /*is_ambiguous_... S3490C9::S3490C6 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C9*)(S3490C12*)(S3490C11*), 0, "S3490C10");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*)(S3490C9*)(S3490C12*)(S3490C11*), ABISELECT(96,52), "S3490C10");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C9*)(S3490C12*)(S3490C11*), ABISELECT(96,52), "S3490C10");
    /*is_ambiguous_... S3490C9::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C9*)(S3490C12*)(S3490C11*), ABISELECT(608,412), "S3490C10");
    check_base_class_offset(lv, (S3490C9*)(S3490C12*)(S3490C11*), 0, "S3490C10");
    check_base_class_offset(lv, (S3490C12*)(S3490C11*), 0, "S3490C10");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C3*)(S3490C8*)(S3490C11*), ABISELECT(3280,2332), "S3490C10");
    /*is_ambiguous_... S3490C9::S3490C6 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C9*)(S3490C8*)(S3490C11*), ABISELECT(3296,2340), "S3490C10");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*)(S3490C9*)(S3490C8*)(S3490C11*), ABISELECT(3392,2392), "S3490C10");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C9*)(S3490C8*)(S3490C11*), ABISELECT(3392,2392), "S3490C10");
    /*is_ambiguous_... S3490C9::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C9*)(S3490C8*)(S3490C11*), ABISELECT(3904,2752), "S3490C10");
    check_base_class_offset(lv, (S3490C9*)(S3490C8*)(S3490C11*), ABISELECT(3296,2340), "S3490C10");
    /*is_ambiguous_... S3490C8::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*)(S3490C8*)(S3490C11*), ABISELECT(6000,4280), "S3490C10");
    /*is_ambiguous_... S3490C8::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C8*)(S3490C11*), ABISELECT(6000,4280), "S3490C10");
    /*is_ambiguous_... S3490C8::S3490C6 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C8*)(S3490C11*), ABISELECT(6512,4640), "S3490C10");
    check_base_class_offset(lv, (S3490C8*)(S3490C11*), ABISELECT(3280,2332), "S3490C10");
    check_base_class_offset(lv, (S3490C11*), 0, "S3490C10");
    /*is_ambiguous_... S3490C2::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C3*)(S3490C2*), ABISELECT(12144,8608), "S3490C10");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C3*)(S3490C8*)(S3490C2*), ABISELECT(12160,8616), "S3490C10");
    /*is_ambiguous_... S3490C9::S3490C6 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C9*)(S3490C8*)(S3490C2*), ABISELECT(12176,8624), "S3490C10");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*)(S3490C9*)(S3490C8*)(S3490C2*), ABISELECT(12272,8676), "S3490C10");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C9*)(S3490C8*)(S3490C2*), ABISELECT(12272,8676), "S3490C10");
    /*is_ambiguous_... S3490C9::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C9*)(S3490C8*)(S3490C2*), ABISELECT(12784,9036), "S3490C10");
    check_base_class_offset(lv, (S3490C9*)(S3490C8*)(S3490C2*), ABISELECT(12176,8624), "S3490C10");
    /*is_ambiguous_... S3490C8::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*)(S3490C8*)(S3490C2*), ABISELECT(14880,10564), "S3490C10");
    /*is_ambiguous_... S3490C8::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C8*)(S3490C2*), ABISELECT(14880,10564), "S3490C10");
    /*is_ambiguous_... S3490C8::S3490C6 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C8*)(S3490C2*), ABISELECT(15392,10924), "S3490C10");
    check_base_class_offset(lv, (S3490C8*)(S3490C2*), ABISELECT(12160,8616), "S3490C10");
    check_base_class_offset(lv, (S3490C2*), ABISELECT(12144,8608), "S3490C10");
    check_field_offset(lv, s3490c10f0, ABISELECT(22944,16216), "S3490C10.s3490c10f0");
    check_field_offset(lv, s3490c10f1, ABISELECT(22992,16256), "S3490C10.s3490c10f1");
    check_field_offset(lv, s3490c10f2, ABISELECT(23008,16268), "S3490C10.s3490c10f2");
    check_field_offset(lv, s3490c10f3, ABISELECT(23080,16304), "S3490C10.s3490c10f3");
    check_field_offset(lv, s3490c10f4, ABISELECT(23144,16336), "S3490C10.s3490c10f4");
    check_field_offset(lv, s3490c10f5, ABISELECT(23152,16340), "S3490C10.s3490c10f5");
    check_field_offset(lv, s3490c10f6, ABISELECT(23168,16344), "S3490C10.s3490c10f6");
    check_field_offset(lv, s3490c10f7, ABISELECT(30112,21300), "S3490C10.s3490c10f7");
    test_class_info(&lv, &cd_S3490C10);
    dp->~S3490C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3490C10(Test_S3490C10, "S3490C10", ABISELECT(33760,23912));

#else // __cplusplus

extern void _ZN8S3490C10C1Ev();
extern void _ZN8S3490C10D1Ev();
Name_Map name_map_S3490C10[] = {
  NSPAIR(_ZN8S3490C10C1Ev),
  NSPAIR(_ZN8S3490C10D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C4;
extern VTBL_ENTRY _ZTI7S3490C4[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C7;
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C7;
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
extern Class_Descriptor cd_S3490C3;
extern VTBL_ENTRY _ZTI7S3490C3[];
extern  VTBL_ENTRY _ZTV7S3490C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C3[];
extern Class_Descriptor cd_S3490C9;
extern VTBL_ENTRY _ZTI7S3490C9[];
extern  VTBL_ENTRY _ZTV7S3490C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C9[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C7;
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
extern Class_Descriptor cd_S3490C9;
extern VTBL_ENTRY _ZTI7S3490C9[];
extern  VTBL_ENTRY _ZTV7S3490C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C9[];
extern Class_Descriptor cd_S3490C12;
extern VTBL_ENTRY _ZTI8S3490C12[];
extern  VTBL_ENTRY _ZTV8S3490C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3490C12[];
extern Class_Descriptor cd_S3490C3;
extern VTBL_ENTRY _ZTI7S3490C3[];
extern  VTBL_ENTRY _ZTV7S3490C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C3[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C7;
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
extern Class_Descriptor cd_S3490C9;
extern VTBL_ENTRY _ZTI7S3490C9[];
extern  VTBL_ENTRY _ZTV7S3490C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C9[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C8;
extern VTBL_ENTRY _ZTI7S3490C8[];
extern  VTBL_ENTRY _ZTV7S3490C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C8[];
extern Class_Descriptor cd_S3490C11;
extern VTBL_ENTRY _ZTI8S3490C11[];
extern  VTBL_ENTRY _ZTV8S3490C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3490C11[];
extern Class_Descriptor cd_S3490C3;
extern VTBL_ENTRY _ZTI7S3490C3[];
extern  VTBL_ENTRY _ZTV7S3490C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C3[];
extern Class_Descriptor cd_S3490C3;
extern VTBL_ENTRY _ZTI7S3490C3[];
extern  VTBL_ENTRY _ZTV7S3490C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C3[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C7;
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
extern Class_Descriptor cd_S3490C9;
extern VTBL_ENTRY _ZTI7S3490C9[];
extern  VTBL_ENTRY _ZTV7S3490C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C9[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C8;
extern VTBL_ENTRY _ZTI7S3490C8[];
extern  VTBL_ENTRY _ZTV7S3490C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C8[];
extern Class_Descriptor cd_S3490C2;
extern VTBL_ENTRY _ZTI7S3490C2[];
extern  VTBL_ENTRY _ZTV7S3490C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C2[];
static Base_Class bases_S3490C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3490C6,    ABISELECT(30128,21304), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S3490C4,    ABISELECT(32832,23244), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S3490C6,    ABISELECT(30224,21356), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(30224,21356), //bcp->offset
    115, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    94, //bcp->index_in_construction_vtbl_array
    114, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(32848,23260), //bcp->offset
    123, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    96, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S3490C7,    ABISELECT(30736,21716), //bcp->offset
    119, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    95, //bcp->index_in_construction_vtbl_array
    115, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(32960,23320), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(32960,23320), //bcp->offset
    133, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    98, //bcp->index_in_construction_vtbl_array
    127, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S3490C7,    ABISELECT(33472,23680), //bcp->offset
    138, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    99, //bcp->index_in_construction_vtbl_array
    128, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S3490C3,    ABISELECT(32936,23312), //bcp->offset
    127, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    97, //bcp->index_in_construction_vtbl_array
    123, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S3490C9,    ABISELECT(30128,21304), //bcp->offset
    102, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    93, //bcp->index_in_construction_vtbl_array
    113, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3490C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(96,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(96,52), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    100, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S3490C7,    ABISELECT(608,412), //bcp->offset
    17, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    101, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S3490C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S3490C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S3490C3,    ABISELECT(3280,2332), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(3296,2340), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(3392,2392), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(3392,2392), //bcp->offset
    41, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    104, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S3490C7,    ABISELECT(3904,2752), //bcp->offset
    45, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    105, //bcp->index_in_construction_vtbl_array
    27, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S3490C9,    ABISELECT(3296,2340), //bcp->offset
    31, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    103, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(6000,4280), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(6000,4280), //bcp->offset
    49, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    106, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(6512,4640), //bcp->offset
    53, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S3490C8,    ABISELECT(3280,2332), //bcp->offset
    21, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    102, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S3490C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3490C3,    ABISELECT(12144,8608), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    56, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S3490C3,    ABISELECT(12160,8616), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    61, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(12176,8624), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(12272,8676), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(12272,8676), //bcp->offset
    87, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    110, //bcp->index_in_construction_vtbl_array
    66, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S3490C7,    ABISELECT(12784,9036), //bcp->offset
    91, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    111, //bcp->index_in_construction_vtbl_array
    67, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S3490C9,    ABISELECT(12176,8624), //bcp->offset
    77, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    109, //bcp->index_in_construction_vtbl_array
    65, //bcp->base_subarray_index_in_construction_vtbl_array
    34, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(14880,10564), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    35, //init_seq
    36, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(14880,10564), //bcp->offset
    95, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    112, //bcp->index_in_construction_vtbl_array
    75, //bcp->base_subarray_index_in_construction_vtbl_array
    36, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(15392,10924), //bcp->offset
    99, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    37, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S3490C8,    ABISELECT(12160,8616), //bcp->offset
    67, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    108, //bcp->index_in_construction_vtbl_array
    60, //bcp->base_subarray_index_in_construction_vtbl_array
    38, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S3490C2,    ABISELECT(12144,8608), //bcp->offset
    56, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    107, //bcp->index_in_construction_vtbl_array
    55, //bcp->base_subarray_index_in_construction_vtbl_array
    39, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S3490C10[];
extern void _ZN7S3490C62v2Ev();
extern void _ZN8S3490C10D1Ev();
extern void _ZN8S3490C10D0Ev();
extern void _ZN8S3490C122v7Ev();
extern void _ZN8S3490C122v8Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C72v3Ev();
extern void _ZN7S3490C82v4Ev();
extern void ABISELECT(_ZThn3280_N8S3490C10D1Ev,_ZThn2332_N8S3490C10D1Ev)();
extern void ABISELECT(_ZThn3280_N8S3490C10D0Ev,_ZThn2332_N8S3490C10D0Ev)();
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZThn3296_N8S3490C10D1Ev,_ZThn2340_N8S3490C10D1Ev)();
extern void ABISELECT(_ZThn3296_N8S3490C10D0Ev,_ZThn2340_N8S3490C10D0Ev)();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C72v3Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZThn12144_N8S3490C10D1Ev,_ZThn8608_N8S3490C10D1Ev)();
extern void ABISELECT(_ZThn12144_N8S3490C10D0Ev,_ZThn8608_N8S3490C10D0Ev)();
extern void _ZN7S3490C22v5Ev();
extern void _ZN7S3490C22v6Ev();
extern void _ZN7S3490C82v4Ev();
extern void ABISELECT(_ZThn12160_N8S3490C10D1Ev,_ZThn8616_N8S3490C10D1Ev)();
extern void ABISELECT(_ZThn12160_N8S3490C10D0Ev,_ZThn8616_N8S3490C10D0Ev)();
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZThn12176_N8S3490C10D1Ev,_ZThn8624_N8S3490C10D1Ev)();
extern void ABISELECT(_ZThn12176_N8S3490C10D0Ev,_ZThn8624_N8S3490C10D0Ev)();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C72v3Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZTv0_n72_N8S3490C10D1Ev,_ZTv0_n36_N8S3490C10D1Ev)();
extern void ABISELECT(_ZThn30128_N8S3490C10D1Ev,_ZThn21304_N8S3490C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S3490C10D0Ev,_ZTv0_n36_N8S3490C10D0Ev)();
extern void ABISELECT(_ZThn30128_N8S3490C10D0Ev,_ZThn21304_N8S3490C10D0Ev)() __attribute__((weak));
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C72v3Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY vtc_S3490C10[] = {
  ABISELECT(30128,21304),
  ABISELECT(33472,23680),
  ABISELECT(32960,23320),
  ABISELECT(32936,23312),
  ABISELECT(32848,23260),
  ABISELECT(32832,23244),
  0,
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN8S3490C10D1Ev,
  (VTBL_ENTRY)&_ZN8S3490C10D0Ev,
  (VTBL_ENTRY)&_ZN8S3490C122v7Ev,
  (VTBL_ENTRY)&_ZN8S3490C122v8Ev,
  ABISELECT(32736,23192),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(32240,22848),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
  ABISELECT(29656,20980),
  ABISELECT(30192,21348),
  ABISELECT(29568,20928),
  ABISELECT(29680,20988),
  ABISELECT(29552,20912),
  ABISELECT(-3280,-2332),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C82v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn3280_N8S3490C10D1Ev,_ZThn2332_N8S3490C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn3280_N8S3490C10D0Ev,_ZThn2332_N8S3490C10D0Ev),
  ABISELECT(30176,21340),
  ABISELECT(29664,20980),
  ABISELECT(29640,20972),
  ABISELECT(29552,20920),
  ABISELECT(29536,20904),
  ABISELECT(-3296,-2340),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn3296_N8S3490C10D1Ev,_ZThn2340_N8S3490C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn3296_N8S3490C10D0Ev,_ZThn2340_N8S3490C10D0Ev),
  ABISELECT(29440,20852),
  ABISELECT(-3392,-2392),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(28944,20508),
  ABISELECT(-3904,-2752),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
  ABISELECT(26832,18964),
  ABISELECT(-6000,-4280),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(-6512,-4640),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(20792,14704),
  ABISELECT(21328,15072),
  ABISELECT(20704,14652),
  ABISELECT(20816,14712),
  ABISELECT(20688,14636),
  ABISELECT(-12144,-8608),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn12144_N8S3490C10D1Ev,_ZThn8608_N8S3490C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn12144_N8S3490C10D0Ev,_ZThn8608_N8S3490C10D0Ev),
  (VTBL_ENTRY)&_ZN7S3490C22v5Ev,
  (VTBL_ENTRY)&_ZN7S3490C22v6Ev,
  ABISELECT(20776,14696),
  ABISELECT(21312,15064),
  ABISELECT(20688,14644),
  ABISELECT(20800,14704),
  ABISELECT(20672,14628),
  ABISELECT(-12160,-8616),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C82v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn12160_N8S3490C10D1Ev,_ZThn8616_N8S3490C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn12160_N8S3490C10D0Ev,_ZThn8616_N8S3490C10D0Ev),
  ABISELECT(21296,15056),
  ABISELECT(20784,14696),
  ABISELECT(20760,14688),
  ABISELECT(20672,14636),
  ABISELECT(20656,14620),
  ABISELECT(-12176,-8624),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn12176_N8S3490C10D1Ev,_ZThn8624_N8S3490C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn12176_N8S3490C10D0Ev,_ZThn8624_N8S3490C10D0Ev),
  ABISELECT(20560,14568),
  ABISELECT(-12272,-8676),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(20064,14224),
  ABISELECT(-12784,-9036),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
  ABISELECT(17952,12680),
  ABISELECT(-14880,-10564),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(-15392,-10924),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(608,412),
  ABISELECT(-30128,-21304),
  0,
  ABISELECT(3344,2376),
  ABISELECT(2832,2016),
  ABISELECT(2808,2008),
  ABISELECT(2720,1956),
  ABISELECT(2704,1940),
  ABISELECT(-30128,-21304),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S3490C10D1Ev,_ZTv0_n36_N8S3490C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S3490C10D0Ev,_ZTv0_n36_N8S3490C10D0Ev),
  ABISELECT(2608,1888),
  ABISELECT(-30224,-21356),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(2112,1544),
  ABISELECT(-30736,-21716),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
  0,
  ABISELECT(-32848,-23260),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(536,368),
  ABISELECT(-88,-52),
  ABISELECT(24,8),
  ABISELECT(-104,-68),
  ABISELECT(-32936,-23312),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  0,
  ABISELECT(-128,-76),
  ABISELECT(-32960,-23320),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  0,
  ABISELECT(-624,-420),
  ABISELECT(-33472,-23680),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern VTBL_ENTRY _ZTV8S3490C10[];
extern void _ZN7S3490C62v2Ev();
extern void _ZN8S3490C11D1Ev();
extern void _ZN8S3490C11D0Ev();
extern void _ZN8S3490C122v7Ev();
extern void _ZN8S3490C122v8Ev();
static  VTBL_ENTRY _tg__ZTV8S3490C11__8S3490C10[] = {
  ABISELECT(33472,23680),
  ABISELECT(32960,23320),
  ABISELECT(32936,23312),
  ABISELECT(32848,23260),
  ABISELECT(32832,23244),
  0,
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN8S3490C11D1Ev,
  (VTBL_ENTRY)&_ZN8S3490C11D0Ev,
  (VTBL_ENTRY)&_ZN8S3490C122v7Ev,
  (VTBL_ENTRY)&_ZN8S3490C122v8Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void _ZN8S3490C12D1Ev();
extern void _ZN8S3490C12D0Ev();
extern void _ZN8S3490C122v7Ev();
extern void _ZN8S3490C122v8Ev();
static  VTBL_ENTRY _tg__ZTV8S3490C128S3490C11__8S3490C10[] = {
  ABISELECT(33472,23680),
  ABISELECT(32960,23320),
  ABISELECT(32936,23312),
  ABISELECT(32848,23260),
  ABISELECT(32832,23244),
  0,
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN8S3490C12D1Ev,
  (VTBL_ENTRY)&_ZN8S3490C12D0Ev,
  (VTBL_ENTRY)&_ZN8S3490C122v7Ev,
  (VTBL_ENTRY)&_ZN8S3490C122v8Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C9D1Ev();
extern void _ZN7S3490C9D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C98S3490C128S3490C11__A1__8S3490C10[] = {
  ABISELECT(33472,23680),
  ABISELECT(32960,23320),
  ABISELECT(32936,23312),
  ABISELECT(32848,23260),
  ABISELECT(32832,23244),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D0Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C98S3490C128S3490C11__A2__8S3490C10[] = {
  ABISELECT(32736,23192),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C98S3490C128S3490C11__A2__8S3490C10[] = {
  ABISELECT(32240,22848),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__7S3490C77S3490C98S3490C128S3490C11__A2__8S3490C10[] = {
  0,
  ABISELECT(-32240,-22848),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A__7S3490C98S3490C128S3490C11__A1__8S3490C10[] = {
  ABISELECT(32736,23192),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A__7S3490C98S3490C128S3490C11__A1__8S3490C10[] = {
  ABISELECT(32240,22848),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A2__7S3490C98S3490C128S3490C11__A1__8S3490C10[] = {
  0,
  ABISELECT(-32848,-23260),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__7S3490C98S3490C128S3490C11__A1__8S3490C10[] = {
  ABISELECT(536,368),
  ABISELECT(-88,-52),
  ABISELECT(24,8),
  ABISELECT(-104,-68),
  ABISELECT(-32936,-23312),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A1__7S3490C98S3490C128S3490C11__A1__8S3490C10[] = {
  0,
  ABISELECT(-128,-76),
  ABISELECT(-32960,-23320),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A1__7S3490C98S3490C128S3490C11__A1__8S3490C10[] = {
  0,
  ABISELECT(-624,-420),
  ABISELECT(-33472,-23680),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C9__8S3490C128S3490C11__8S3490C10[] = {
  ABISELECT(32736,23192),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C9__8S3490C128S3490C11__8S3490C10[] = {
  ABISELECT(32240,22848),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A2__8S3490C128S3490C11__8S3490C10[] = {
  0,
  ABISELECT(-32848,-23260),
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__8S3490C128S3490C11__8S3490C10[] = {
  ABISELECT(536,368),
  ABISELECT(-88,-52),
  ABISELECT(24,8),
  ABISELECT(-104,-68),
  ABISELECT(-32936,-23312),
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A1__8S3490C128S3490C11__8S3490C10[] = {
  0,
  ABISELECT(-128,-76),
  ABISELECT(-32960,-23320),
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A1__8S3490C128S3490C11__8S3490C10[] = {
  0,
  ABISELECT(-624,-420),
  ABISELECT(-33472,-23680),
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C82v4Ev();
extern void _ZN7S3490C8D1Ev();
extern void _ZN7S3490C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C88S3490C11__8S3490C10[] = {
  ABISELECT(29656,20980),
  ABISELECT(30192,21348),
  ABISELECT(29568,20928),
  ABISELECT(29680,20988),
  ABISELECT(29552,20912),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C82v4Ev,
  (VTBL_ENTRY)&_ZN7S3490C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C8D0Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C37S3490C88S3490C11__A1__8S3490C10[] = {
  ABISELECT(30192,21348),
  ABISELECT(29568,20928),
  ABISELECT(29680,20988),
  ABISELECT(29552,20912),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C37S3490C88S3490C11__A1__8S3490C10[] = {
  0,
  ABISELECT(-128,-76),
  ABISELECT(-29680,-20988),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C37S3490C88S3490C11__A1__8S3490C10[] = {
  0,
  ABISELECT(-29568,-20928),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C37S3490C88S3490C11__A1__8S3490C10[] = {
  0,
  ABISELECT(-624,-420),
  ABISELECT(-30192,-21348),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C9D1Ev();
extern void _ZN7S3490C9D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C97S3490C88S3490C11__A2__8S3490C10[] = {
  ABISELECT(30176,21340),
  ABISELECT(29664,20980),
  ABISELECT(29640,20972),
  ABISELECT(29552,20920),
  ABISELECT(29536,20904),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D0Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C97S3490C88S3490C11__A3__8S3490C10[] = {
  ABISELECT(29440,20852),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C97S3490C88S3490C11__A3__8S3490C10[] = {
  ABISELECT(28944,20508),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__7S3490C77S3490C97S3490C88S3490C11__A3__8S3490C10[] = {
  0,
  ABISELECT(-28944,-20508),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A__7S3490C97S3490C88S3490C11__A2__8S3490C10[] = {
  ABISELECT(29440,20852),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A__7S3490C97S3490C88S3490C11__A2__8S3490C10[] = {
  ABISELECT(28944,20508),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A2__7S3490C97S3490C88S3490C11__A2__8S3490C10[] = {
  0,
  ABISELECT(-29552,-20920),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__7S3490C97S3490C88S3490C11__A2__8S3490C10[] = {
  ABISELECT(536,368),
  ABISELECT(-88,-52),
  ABISELECT(24,8),
  ABISELECT(-104,-68),
  ABISELECT(-29640,-20972),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A1__7S3490C97S3490C88S3490C11__A2__8S3490C10[] = {
  0,
  ABISELECT(-128,-76),
  ABISELECT(-29664,-20980),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A1__7S3490C97S3490C88S3490C11__A2__8S3490C10[] = {
  0,
  ABISELECT(-624,-420),
  ABISELECT(-30176,-21340),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C88S3490C11__A4__8S3490C10[] = {
  ABISELECT(26832,18964),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C88S3490C11__8S3490C10[] = {
  0,
  ABISELECT(-128,-76),
  ABISELECT(-29680,-20988),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C88S3490C11__8S3490C10[] = {
  0,
  ABISELECT(-29568,-20928),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C88S3490C11__8S3490C10[] = {
  0,
  ABISELECT(-624,-420),
  ABISELECT(-30192,-21348),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZThn16_N7S3490C8D1Ev,_ZThn8_N7S3490C8D1Ev)();
extern void ABISELECT(_ZThn16_N7S3490C8D0Ev,_ZThn8_N7S3490C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S3490C9__7S3490C88S3490C11__8S3490C10[] = {
  ABISELECT(30176,21340),
  ABISELECT(29664,20980),
  ABISELECT(29640,20972),
  ABISELECT(29552,20920),
  ABISELECT(29536,20904),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S3490C8D1Ev,_ZThn8_N7S3490C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S3490C8D0Ev,_ZThn8_N7S3490C8D0Ev),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C9__A1__7S3490C88S3490C11__8S3490C10[] = {
  ABISELECT(29440,20852),
  ABISELECT(-112,-60),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C9__A1__7S3490C88S3490C11__8S3490C10[] = {
  ABISELECT(28944,20508),
  ABISELECT(-624,-420),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__A1__7S3490C88S3490C11__8S3490C10[] = {
  ABISELECT(536,368),
  ABISELECT(-88,-52),
  ABISELECT(24,8),
  ABISELECT(-104,-68),
  ABISELECT(-29656,-20980),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A__7S3490C88S3490C11__8S3490C10[] = {
  ABISELECT(26832,18964),
  ABISELECT(-2720,-1948),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__8S3490C11__8S3490C10[] = {
  ABISELECT(536,368),
  ABISELECT(-88,-52),
  ABISELECT(24,8),
  ABISELECT(-104,-68),
  ABISELECT(-32936,-23312),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__8S3490C11__8S3490C10[] = {
  0,
  ABISELECT(-128,-76),
  ABISELECT(-32960,-23320),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__8S3490C11__8S3490C10[] = {
  0,
  ABISELECT(-32848,-23260),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__8S3490C11__8S3490C10[] = {
  0,
  ABISELECT(-624,-420),
  ABISELECT(-33472,-23680),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C98S3490C12__A1__8S3490C11__8S3490C10[] = {
  ABISELECT(32736,23192),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C98S3490C12__A1__8S3490C11__8S3490C10[] = {
  ABISELECT(32240,22848),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C82v4Ev();
extern void ABISELECT(_ZThn3280_N8S3490C11D1Ev,_ZThn2332_N8S3490C11D1Ev)();
extern void ABISELECT(_ZThn3280_N8S3490C11D0Ev,_ZThn2332_N8S3490C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S3490C8__8S3490C11__8S3490C10[] = {
  ABISELECT(29656,20980),
  ABISELECT(30192,21348),
  ABISELECT(29568,20928),
  ABISELECT(29680,20988),
  ABISELECT(29552,20912),
  ABISELECT(-3280,-2332),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C82v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn3280_N8S3490C11D1Ev,_ZThn2332_N8S3490C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn3280_N8S3490C11D0Ev,_ZThn2332_N8S3490C11D0Ev),
};
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZThn3296_N8S3490C11D1Ev,_ZThn2340_N8S3490C11D1Ev)();
extern void ABISELECT(_ZThn3296_N8S3490C11D0Ev,_ZThn2340_N8S3490C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S3490C97S3490C8__A1__8S3490C11__8S3490C10[] = {
  ABISELECT(30176,21340),
  ABISELECT(29664,20980),
  ABISELECT(29640,20972),
  ABISELECT(29552,20920),
  ABISELECT(29536,20904),
  ABISELECT(-3296,-2340),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn3296_N8S3490C11D1Ev,_ZThn2340_N8S3490C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn3296_N8S3490C11D0Ev,_ZThn2340_N8S3490C11D0Ev),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C97S3490C8__A2__8S3490C11__8S3490C10[] = {
  ABISELECT(29440,20852),
  ABISELECT(-3392,-2392),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C97S3490C8__A2__8S3490C11__8S3490C10[] = {
  ABISELECT(28944,20508),
  ABISELECT(-3904,-2752),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C8__A3__8S3490C11__8S3490C10[] = {
  ABISELECT(26832,18964),
  ABISELECT(-6000,-4280),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C2D1Ev();
extern void _ZN7S3490C2D0Ev();
extern void _ZN7S3490C22v5Ev();
extern void _ZN7S3490C22v6Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C2__8S3490C10[] = {
  ABISELECT(20792,14704),
  ABISELECT(21328,15072),
  ABISELECT(20704,14652),
  ABISELECT(20816,14712),
  ABISELECT(20688,14636),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C2D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C2D0Ev,
  (VTBL_ENTRY)&_ZN7S3490C22v5Ev,
  (VTBL_ENTRY)&_ZN7S3490C22v6Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C37S3490C2__A2__8S3490C10[] = {
  ABISELECT(21328,15072),
  ABISELECT(20704,14652),
  ABISELECT(20816,14712),
  ABISELECT(20688,14636),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C37S3490C2__A2__8S3490C10[] = {
  0,
  ABISELECT(-128,-76),
  ABISELECT(-20816,-14712),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C37S3490C2__A2__8S3490C10[] = {
  0,
  ABISELECT(-20704,-14652),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C37S3490C2__A2__8S3490C10[] = {
  0,
  ABISELECT(-624,-420),
  ABISELECT(-21328,-15072),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C82v4Ev();
extern void _ZN7S3490C8D1Ev();
extern void _ZN7S3490C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C87S3490C2__A1__8S3490C10[] = {
  ABISELECT(20776,14696),
  ABISELECT(21312,15064),
  ABISELECT(20688,14644),
  ABISELECT(20800,14704),
  ABISELECT(20672,14628),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C82v4Ev,
  (VTBL_ENTRY)&_ZN7S3490C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C8D0Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C37S3490C87S3490C2__A3__8S3490C10[] = {
  ABISELECT(21312,15064),
  ABISELECT(20688,14644),
  ABISELECT(20800,14704),
  ABISELECT(20672,14628),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C37S3490C87S3490C2__A3__8S3490C10[] = {
  0,
  ABISELECT(-128,-76),
  ABISELECT(-20800,-14704),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C37S3490C87S3490C2__A3__8S3490C10[] = {
  0,
  ABISELECT(-20688,-14644),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C37S3490C87S3490C2__A3__8S3490C10[] = {
  0,
  ABISELECT(-624,-420),
  ABISELECT(-21312,-15064),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C9D1Ev();
extern void _ZN7S3490C9D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C97S3490C87S3490C2__A3__8S3490C10[] = {
  ABISELECT(21296,15056),
  ABISELECT(20784,14696),
  ABISELECT(20760,14688),
  ABISELECT(20672,14636),
  ABISELECT(20656,14620),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D0Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C97S3490C87S3490C2__A5__8S3490C10[] = {
  ABISELECT(20560,14568),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C97S3490C87S3490C2__A4__8S3490C10[] = {
  ABISELECT(20064,14224),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__7S3490C77S3490C97S3490C87S3490C2__A4__8S3490C10[] = {
  0,
  ABISELECT(-20064,-14224),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A__7S3490C97S3490C87S3490C2__A3__8S3490C10[] = {
  ABISELECT(20560,14568),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A__7S3490C97S3490C87S3490C2__A3__8S3490C10[] = {
  ABISELECT(20064,14224),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A2__7S3490C97S3490C87S3490C2__A3__8S3490C10[] = {
  0,
  ABISELECT(-20672,-14636),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__7S3490C97S3490C87S3490C2__A3__8S3490C10[] = {
  ABISELECT(536,368),
  ABISELECT(-88,-52),
  ABISELECT(24,8),
  ABISELECT(-104,-68),
  ABISELECT(-20760,-14688),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A1__7S3490C97S3490C87S3490C2__A3__8S3490C10[] = {
  0,
  ABISELECT(-128,-76),
  ABISELECT(-20784,-14696),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A1__7S3490C97S3490C87S3490C2__A3__8S3490C10[] = {
  0,
  ABISELECT(-624,-420),
  ABISELECT(-21296,-15056),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C87S3490C2__A6__8S3490C10[] = {
  ABISELECT(17952,12680),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C87S3490C2__A1__8S3490C10[] = {
  0,
  ABISELECT(-128,-76),
  ABISELECT(-20800,-14704),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C87S3490C2__A1__8S3490C10[] = {
  0,
  ABISELECT(-20688,-14644),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C87S3490C2__A1__8S3490C10[] = {
  0,
  ABISELECT(-624,-420),
  ABISELECT(-21312,-15064),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZThn16_N7S3490C8D1Ev,_ZThn8_N7S3490C8D1Ev)();
extern void ABISELECT(_ZThn16_N7S3490C8D0Ev,_ZThn8_N7S3490C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S3490C9__7S3490C87S3490C2__A1__8S3490C10[] = {
  ABISELECT(21296,15056),
  ABISELECT(20784,14696),
  ABISELECT(20760,14688),
  ABISELECT(20672,14636),
  ABISELECT(20656,14620),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S3490C8D1Ev,_ZThn8_N7S3490C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S3490C8D0Ev,_ZThn8_N7S3490C8D0Ev),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C9__A1__7S3490C87S3490C2__A1__8S3490C10[] = {
  ABISELECT(20560,14568),
  ABISELECT(-112,-60),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C9__A1__7S3490C87S3490C2__A1__8S3490C10[] = {
  ABISELECT(20064,14224),
  ABISELECT(-624,-420),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__A1__7S3490C87S3490C2__A1__8S3490C10[] = {
  ABISELECT(536,368),
  ABISELECT(-88,-52),
  ABISELECT(24,8),
  ABISELECT(-104,-68),
  ABISELECT(-20776,-14696),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A__7S3490C87S3490C2__A1__8S3490C10[] = {
  ABISELECT(17952,12680),
  ABISELECT(-2720,-1948),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C2__8S3490C10[] = {
  0,
  ABISELECT(-128,-76),
  ABISELECT(-20816,-14712),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C2__8S3490C10[] = {
  0,
  ABISELECT(-20704,-14652),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C2__8S3490C10[] = {
  0,
  ABISELECT(-624,-420),
  ABISELECT(-21328,-15072),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C82v4Ev();
extern void ABISELECT(_ZThn16_N7S3490C2D1Ev,_ZThn8_N7S3490C2D1Ev)();
extern void ABISELECT(_ZThn16_N7S3490C2D0Ev,_ZThn8_N7S3490C2D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S3490C8__7S3490C2__8S3490C10[] = {
  ABISELECT(20776,14696),
  ABISELECT(21312,15064),
  ABISELECT(20688,14644),
  ABISELECT(20800,14704),
  ABISELECT(20672,14628),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C82v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S3490C2D1Ev,_ZThn8_N7S3490C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S3490C2D0Ev,_ZThn8_N7S3490C2D0Ev),
};
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZThn32_N7S3490C2D1Ev,_ZThn16_N7S3490C2D1Ev)();
extern void ABISELECT(_ZThn32_N7S3490C2D0Ev,_ZThn16_N7S3490C2D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S3490C97S3490C8__7S3490C2__8S3490C10[] = {
  ABISELECT(21296,15056),
  ABISELECT(20784,14696),
  ABISELECT(20760,14688),
  ABISELECT(20672,14636),
  ABISELECT(20656,14620),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N7S3490C2D1Ev,_ZThn16_N7S3490C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N7S3490C2D0Ev,_ZThn16_N7S3490C2D0Ev),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C97S3490C8__A1__7S3490C2__8S3490C10[] = {
  ABISELECT(20560,14568),
  ABISELECT(-128,-68),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C97S3490C8__A1__7S3490C2__8S3490C10[] = {
  ABISELECT(20064,14224),
  ABISELECT(-640,-428),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__A2__7S3490C2__8S3490C10[] = {
  ABISELECT(536,368),
  ABISELECT(-88,-52),
  ABISELECT(24,8),
  ABISELECT(-104,-68),
  ABISELECT(-20792,-14704),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C8__A2__7S3490C2__8S3490C10[] = {
  ABISELECT(17952,12680),
  ABISELECT(-2736,-1956),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C9D1Ev();
extern void _ZN7S3490C9D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C9__8S3490C10[] = {
  ABISELECT(3344,2376),
  ABISELECT(2832,2016),
  ABISELECT(2808,2008),
  ABISELECT(2720,1956),
  ABISELECT(2704,1940),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D0Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C9__8S3490C10[] = {
  ABISELECT(2608,1888),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C9__8S3490C10[] = {
  ABISELECT(2112,1544),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__7S3490C77S3490C9__8S3490C10[] = {
  0,
  ABISELECT(-2112,-1544),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A__7S3490C9__8S3490C10[] = {
  ABISELECT(2608,1888),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A__7S3490C9__8S3490C10[] = {
  ABISELECT(2112,1544),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A2__7S3490C9__8S3490C10[] = {
  0,
  ABISELECT(-2720,-1956),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__7S3490C9__8S3490C10[] = {
  ABISELECT(536,368),
  ABISELECT(-88,-52),
  ABISELECT(24,8),
  ABISELECT(-104,-68),
  ABISELECT(-2808,-2008),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A1__7S3490C9__8S3490C10[] = {
  0,
  ABISELECT(-128,-76),
  ABISELECT(-2832,-2016),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A1__7S3490C9__8S3490C10[] = {
  0,
  ABISELECT(-624,-420),
  ABISELECT(-3344,-2376),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__8S3490C10[] = {
  ABISELECT(536,368),
  ABISELECT(-88,-52),
  ABISELECT(24,8),
  ABISELECT(-104,-68),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C3__8S3490C10[] = {
  0,
  ABISELECT(-128,-76),
  ABISELECT(-24,-8),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C3__8S3490C10[] = {
  0,
  ABISELECT(88,52),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C3__8S3490C10[] = {
  0,
  ABISELECT(-624,-420),
  ABISELECT(-536,-368),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A1__8S3490C10[] = {
  ABISELECT(-128,-76),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A1__8S3490C10[] = {
  ABISELECT(-624,-420),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__7S3490C7__A1__8S3490C10[] = {
  0,
  ABISELECT(624,420),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTT_ENTRY vtt_S3490C10[] = {
  {&(_ZTV8S3490C10[8]),  8,143},
  {&(_tg__ZTV8S3490C11__8S3490C10[7]),  7,12},
  {&(_tg__ZTV8S3490C128S3490C11__8S3490C10[7]),  7,12},
  {&(_tg__ZTV7S3490C98S3490C128S3490C11__A1__8S3490C10[7]),  7,10},
  {&(_tg__ZTV7S3490C57S3490C98S3490C128S3490C11__A2__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C77S3490C98S3490C128S3490C11__A2__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C6__7S3490C77S3490C98S3490C128S3490C11__A2__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C5__A__7S3490C98S3490C128S3490C11__A1__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C7__A__7S3490C98S3490C128S3490C11__A1__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C6__A2__7S3490C98S3490C128S3490C11__A1__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C3__7S3490C98S3490C128S3490C11__A1__8S3490C10[6]),  6,6},
  {&(_tg__ZTV7S3490C5__A1__7S3490C98S3490C128S3490C11__A1__8S3490C10[4]),  4,5},
  {&(_tg__ZTV7S3490C7__A1__7S3490C98S3490C128S3490C11__A1__8S3490C10[4]),  4,5},
  {&(_tg__ZTV7S3490C57S3490C9__8S3490C128S3490C11__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C77S3490C9__8S3490C128S3490C11__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C6__A2__8S3490C128S3490C11__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C3__8S3490C128S3490C11__8S3490C10[6]),  6,6},
  {&(_tg__ZTV7S3490C5__A1__8S3490C128S3490C11__8S3490C10[4]),  4,5},
  {&(_tg__ZTV7S3490C7__A1__8S3490C128S3490C11__8S3490C10[4]),  4,5},
  {&(_tg__ZTV7S3490C88S3490C11__8S3490C10[7]),  7,10},
  {&(_tg__ZTV7S3490C37S3490C88S3490C11__A1__8S3490C10[6]),  6,6},
  {&(_tg__ZTV7S3490C5__7S3490C37S3490C88S3490C11__A1__8S3490C10[4]),  4,5},
  {&(_tg__ZTV7S3490C6__A1__7S3490C37S3490C88S3490C11__A1__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C7__7S3490C37S3490C88S3490C11__A1__8S3490C10[4]),  4,5},
  {&(_tg__ZTV7S3490C97S3490C88S3490C11__A2__8S3490C10[7]),  7,10},
  {&(_tg__ZTV7S3490C57S3490C97S3490C88S3490C11__A3__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C77S3490C97S3490C88S3490C11__A3__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C6__7S3490C77S3490C97S3490C88S3490C11__A3__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C5__A__7S3490C97S3490C88S3490C11__A2__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C7__A__7S3490C97S3490C88S3490C11__A2__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C6__A2__7S3490C97S3490C88S3490C11__A2__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C3__7S3490C97S3490C88S3490C11__A2__8S3490C10[6]),  6,6},
  {&(_tg__ZTV7S3490C5__A1__7S3490C97S3490C88S3490C11__A2__8S3490C10[4]),  4,5},
  {&(_tg__ZTV7S3490C7__A1__7S3490C97S3490C88S3490C11__A2__8S3490C10[4]),  4,5},
  {&(_tg__ZTV7S3490C57S3490C88S3490C11__A4__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C5__7S3490C88S3490C11__8S3490C10[4]),  4,5},
  {&(_tg__ZTV7S3490C6__A1__7S3490C88S3490C11__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C7__7S3490C88S3490C11__8S3490C10[4]),  4,5},
  {&(_tg__ZTV7S3490C9__7S3490C88S3490C11__8S3490C10[7]),  7,10},
  {&(_tg__ZTV7S3490C57S3490C9__A1__7S3490C88S3490C11__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C77S3490C9__A1__7S3490C88S3490C11__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C3__A1__7S3490C88S3490C11__8S3490C10[6]),  6,6},
  {&(_tg__ZTV7S3490C5__A__7S3490C88S3490C11__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C3__8S3490C11__8S3490C10[6]),  6,6},
  {&(_tg__ZTV7S3490C5__8S3490C11__8S3490C10[4]),  4,5},
  {&(_tg__ZTV7S3490C6__A1__8S3490C11__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C7__8S3490C11__8S3490C10[4]),  4,5},
  {&(_tg__ZTV7S3490C57S3490C98S3490C12__A1__8S3490C11__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C77S3490C98S3490C12__A1__8S3490C11__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C8__8S3490C11__8S3490C10[7]),  7,10},
  {&(_tg__ZTV7S3490C97S3490C8__A1__8S3490C11__8S3490C10[7]),  7,10},
  {&(_tg__ZTV7S3490C57S3490C97S3490C8__A2__8S3490C11__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C77S3490C97S3490C8__A2__8S3490C11__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C57S3490C8__A3__8S3490C11__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C2__8S3490C10[7]),  7,11},
  {&(_tg__ZTV7S3490C37S3490C2__A2__8S3490C10[6]),  6,6},
  {&(_tg__ZTV7S3490C5__7S3490C37S3490C2__A2__8S3490C10[4]),  4,5},
  {&(_tg__ZTV7S3490C6__A1__7S3490C37S3490C2__A2__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C7__7S3490C37S3490C2__A2__8S3490C10[4]),  4,5},
  {&(_tg__ZTV7S3490C87S3490C2__A1__8S3490C10[7]),  7,10},
  {&(_tg__ZTV7S3490C37S3490C87S3490C2__A3__8S3490C10[6]),  6,6},
  {&(_tg__ZTV7S3490C5__7S3490C37S3490C87S3490C2__A3__8S3490C10[4]),  4,5},
  {&(_tg__ZTV7S3490C6__A1__7S3490C37S3490C87S3490C2__A3__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C7__7S3490C37S3490C87S3490C2__A3__8S3490C10[4]),  4,5},
  {&(_tg__ZTV7S3490C97S3490C87S3490C2__A3__8S3490C10[7]),  7,10},
  {&(_tg__ZTV7S3490C57S3490C97S3490C87S3490C2__A5__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C77S3490C97S3490C87S3490C2__A4__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C6__7S3490C77S3490C97S3490C87S3490C2__A4__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C5__A__7S3490C97S3490C87S3490C2__A3__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C7__A__7S3490C97S3490C87S3490C2__A3__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C6__A2__7S3490C97S3490C87S3490C2__A3__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C3__7S3490C97S3490C87S3490C2__A3__8S3490C10[6]),  6,6},
  {&(_tg__ZTV7S3490C5__A1__7S3490C97S3490C87S3490C2__A3__8S3490C10[4]),  4,5},
  {&(_tg__ZTV7S3490C7__A1__7S3490C97S3490C87S3490C2__A3__8S3490C10[4]),  4,5},
  {&(_tg__ZTV7S3490C57S3490C87S3490C2__A6__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C5__7S3490C87S3490C2__A1__8S3490C10[4]),  4,5},
  {&(_tg__ZTV7S3490C6__A1__7S3490C87S3490C2__A1__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C7__7S3490C87S3490C2__A1__8S3490C10[4]),  4,5},
  {&(_tg__ZTV7S3490C9__7S3490C87S3490C2__A1__8S3490C10[7]),  7,10},
  {&(_tg__ZTV7S3490C57S3490C9__A1__7S3490C87S3490C2__A1__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C77S3490C9__A1__7S3490C87S3490C2__A1__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C3__A1__7S3490C87S3490C2__A1__8S3490C10[6]),  6,6},
  {&(_tg__ZTV7S3490C5__A__7S3490C87S3490C2__A1__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C5__7S3490C2__8S3490C10[4]),  4,5},
  {&(_tg__ZTV7S3490C6__A1__7S3490C2__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C7__7S3490C2__8S3490C10[4]),  4,5},
  {&(_tg__ZTV7S3490C8__7S3490C2__8S3490C10[7]),  7,10},
  {&(_tg__ZTV7S3490C97S3490C8__7S3490C2__8S3490C10[7]),  7,10},
  {&(_tg__ZTV7S3490C57S3490C97S3490C8__A1__7S3490C2__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C77S3490C97S3490C8__A1__7S3490C2__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C3__A2__7S3490C2__8S3490C10[6]),  6,6},
  {&(_tg__ZTV7S3490C57S3490C8__A2__7S3490C2__8S3490C10[3]),  3,4},
  {&(_ZTV8S3490C10[112]),  112,143},
  {&(_ZTV8S3490C10[118]),  118,143},
  {&(_ZTV8S3490C10[122]),  122,143},
  {&(_ZTV8S3490C10[126]),  126,143},
  {&(_ZTV8S3490C10[133]),  133,143},
  {&(_ZTV8S3490C10[137]),  137,143},
  {&(_ZTV8S3490C10[142]),  142,143},
  {&(_ZTV8S3490C10[16]),  16,143},
  {&(_ZTV8S3490C10[20]),  20,143},
  {&(_ZTV8S3490C10[28]),  28,143},
  {&(_ZTV8S3490C10[38]),  38,143},
  {&(_ZTV8S3490C10[44]),  44,143},
  {&(_ZTV8S3490C10[48]),  48,143},
  {&(_ZTV8S3490C10[52]),  52,143},
  {&(_ZTV8S3490C10[63]),  63,143},
  {&(_ZTV8S3490C10[74]),  74,143},
  {&(_ZTV8S3490C10[84]),  84,143},
  {&(_ZTV8S3490C10[90]),  90,143},
  {&(_ZTV8S3490C10[94]),  94,143},
  {&(_ZTV8S3490C10[98]),  98,143},
  {&(_tg__ZTV7S3490C9__8S3490C10[7]),  7,10},
  {&(_tg__ZTV7S3490C57S3490C9__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C77S3490C9__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C6__7S3490C77S3490C9__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C5__A__7S3490C9__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C7__A__7S3490C9__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C6__A2__7S3490C9__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C3__7S3490C9__8S3490C10[6]),  6,6},
  {&(_tg__ZTV7S3490C5__A1__7S3490C9__8S3490C10[4]),  4,5},
  {&(_tg__ZTV7S3490C7__A1__7S3490C9__8S3490C10[4]),  4,5},
  {&(_tg__ZTV7S3490C3__8S3490C10[6]),  6,6},
  {&(_tg__ZTV7S3490C5__7S3490C3__8S3490C10[4]),  4,5},
  {&(_tg__ZTV7S3490C6__A1__7S3490C3__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C7__7S3490C3__8S3490C10[4]),  4,5},
  {&(_tg__ZTV7S3490C5__A1__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C7__A1__8S3490C10[3]),  3,4},
  {&(_tg__ZTV7S3490C6__7S3490C7__A1__8S3490C10[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8S3490C10[];
extern  VTBL_ENTRY _ZTV8S3490C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3490C10[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S3490C10D0Ev,_ZTv0_n36_N8S3490C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn30128_N8S3490C10D0Ev,_ZThn21304_N8S3490C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S3490C10D1Ev,_ZTv0_n36_N8S3490C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn30128_N8S3490C10D1Ev,_ZThn21304_N8S3490C10D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S3490C10 = {  "S3490C10", // class name
  bases_S3490C10, 40,
  &(vtc_S3490C10[0]), // expected_vtbl_contents
  &(vtt_S3490C10[0]), // expected_vtt_contents
  ABISELECT(33760,23912), // object size
  NSPAIRA(_ZTI8S3490C10),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S3490C10),143, //virtual function table var
  8, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S3490C10),129, //virtual table table var
  39, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3490C15  : virtual S3490C8 , S3490C5 , S3490C7 , S3490C3 {
  void *s3490c15f0;
  ~S3490C15(); // tgen
  S3490C15(); // tgen
};
//SIG(-1 S3490C15) C1{ VBC2{ BC3{ VBC4{ m FL Fi Fc} VBC5{ BC6{ v1 FD Fi:3 Fc:8 FD[2] FL} VBC4 Fc[10] Fi FC7{ VBC6 v2 FC4 FL FC4[7] Fp FL FC4 Fp Fc Fs Fi FC6} FL} VBC6 VBC7 Fp} BC8{ BC6 VBC4 BC5 BC7 VBC3 vd FC7 FC3 Fp Fi FC6 FC7} BC5 BC6 v3 FC5[2] FC6 Fi FC4 Fp[10] Fi[2] FL FD FL Fi} BC5 BC7 BC3 Fp}


S3490C15 ::~S3490C15(){ note_dtor("S3490C15", this);} // tgen
S3490C15 ::S3490C15(){ note_ctor("S3490C15", this);} // tgen

static void Test_S3490C15()
{
  extern Class_Descriptor cd_S3490C15;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(401,1135)];
    init_test(&cd_S3490C15, buf);
    S3490C15 *dp, &lv = *(dp=new (buf) S3490C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(6400,4536), "sizeof(S3490C15)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S3490C15)");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C3*)(S3490C8*), ABISELECT(5472,3868), "S3490C15");
    /*is_ambiguous_... S3490C15::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*), ABISELECT(5472,3868), "S3490C15");
    check_base_class_offset(lv, (S3490C4*)(S3490C9*)(S3490C8*), ABISELECT(5472,3868), "S3490C15");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*)(S3490C9*)(S3490C8*), ABISELECT(5472,3868), "S3490C15");
    /*is_ambiguous_... S3490C15::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C3*), ABISELECT(5472,3868), "S3490C15");
    /*is_ambiguous_... S3490C8::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*)(S3490C8*), ABISELECT(5472,3868), "S3490C15");
    /*is_ambiguous_... S3490C15::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*), ABISELECT(5472,3868), "S3490C15");
    /*is_ambiguous_... S3490C15::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C3*), ABISELECT(5472,3868), "S3490C15");
    /*is_ambiguous_... S3490C15::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*), ABISELECT(5488,3884), "S3490C15");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C3*)(S3490C8*), ABISELECT(5488,3884), "S3490C15");
    /*is_ambiguous_... S3490C15::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C3*), ABISELECT(5488,3884), "S3490C15");
    /*is_ambiguous_... S3490C15::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C3*), ABISELECT(5488,3884), "S3490C15");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C3*)(S3490C8*), ABISELECT(6000,4244), "S3490C15");
    /*is_ambiguous_... S3490C15::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C7*), ABISELECT(6000,4244), "S3490C15");
    /*is_ambiguous_... S3490C9::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C7*)(S3490C9*)(S3490C8*), ABISELECT(6000,4244), "S3490C15");
    /*is_ambiguous_... S3490C15::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C3*), ABISELECT(6000,4244), "S3490C15");
    /*is_ambiguous_... S3490C15::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C7*), ABISELECT(6000,4244), "S3490C15");
    /*is_ambiguous_... S3490C15::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C3*), ABISELECT(6000,4244), "S3490C15");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C3*)(S3490C8*), ABISELECT(6096,4296), "S3490C15");
    /*is_ambiguous_... S3490C15::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C3*), ABISELECT(6096,4296), "S3490C15");
    /*is_ambiguous_... S3490C15::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C3*), ABISELECT(6096,4296), "S3490C15");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C3*)(S3490C8*), ABISELECT(832,604), "S3490C15");
    /*is_ambiguous_... S3490C9::S3490C6 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C9*)(S3490C8*), ABISELECT(848,612), "S3490C15");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*)(S3490C9*)(S3490C8*), ABISELECT(944,664), "S3490C15");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C9*)(S3490C8*), ABISELECT(944,664), "S3490C15");
    /*is_ambiguous_... S3490C9::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C9*)(S3490C8*), ABISELECT(1456,1024), "S3490C15");
    check_base_class_offset(lv, (S3490C3*)(S3490C9*)(S3490C8*), ABISELECT(6384,4528), "S3490C15");
    check_base_class_offset(lv, (S3490C9*)(S3490C8*), ABISELECT(848,612), "S3490C15");
    /*is_ambiguous_... S3490C8::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*)(S3490C8*), ABISELECT(3552,2552), "S3490C15");
    /*is_ambiguous_... S3490C8::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C8*), ABISELECT(3552,2552), "S3490C15");
    /*is_ambiguous_... S3490C8::S3490C6 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C8*), ABISELECT(4064,2912), "S3490C15");
    check_base_class_offset(lv, (S3490C8*), ABISELECT(832,604), "S3490C15");
    /*is_ambiguous_... S3490C15::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*), 0, "S3490C15");
    /*is_ambiguous_... S3490C15::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C5*), 0, "S3490C15");
    /*is_ambiguous_... S3490C15::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C7*), ABISELECT(512,360), "S3490C15");
    /*is_ambiguous_... S3490C15::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C3*), ABISELECT(800,592), "S3490C15");
    check_field_offset(lv, s3490c15f0, ABISELECT(816,600), "S3490C15.s3490c15f0");
    test_class_info(&lv, &cd_S3490C15);
    dp->~S3490C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3490C15(Test_S3490C15, "S3490C15", ABISELECT(6400,4536));

#else // __cplusplus

extern void _ZN8S3490C15C1Ev();
extern void _ZN8S3490C15D1Ev();
Name_Map name_map_S3490C15[] = {
  NSPAIR(_ZN8S3490C15C1Ev),
  NSPAIR(_ZN8S3490C15D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3490C4;
extern VTBL_ENTRY _ZTI7S3490C4[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C7;
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
extern Class_Descriptor cd_S3490C3;
extern VTBL_ENTRY _ZTI7S3490C3[];
extern  VTBL_ENTRY _ZTV7S3490C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C3[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C7;
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
extern Class_Descriptor cd_S3490C3;
extern VTBL_ENTRY _ZTI7S3490C3[];
extern  VTBL_ENTRY _ZTV7S3490C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C3[];
extern Class_Descriptor cd_S3490C9;
extern VTBL_ENTRY _ZTI7S3490C9[];
extern  VTBL_ENTRY _ZTV7S3490C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C9[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C8;
extern VTBL_ENTRY _ZTI7S3490C8[];
extern  VTBL_ENTRY _ZTV7S3490C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C8[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C7;
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
extern Class_Descriptor cd_S3490C3;
extern VTBL_ENTRY _ZTI7S3490C3[];
extern  VTBL_ENTRY _ZTV7S3490C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C3[];
static Base_Class bases_S3490C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3490C4,    ABISELECT(5472,3868), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S3490C6,    ABISELECT(5488,3884), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(5488,3884), //bcp->offset
    60, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    45, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S3490C6,    ABISELECT(6000,4244), //bcp->offset
    65, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S3490C7,    ABISELECT(6096,4296), //bcp->offset
    69, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    46, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S3490C3,    ABISELECT(832,604), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(848,612), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(944,664), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(944,664), //bcp->offset
    45, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    27, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S3490C7,    ABISELECT(1456,1024), //bcp->offset
    49, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S3490C3,    ABISELECT(6384,4528), //bcp->offset
    74, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    48, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S3490C9,    ABISELECT(848,612), //bcp->offset
    35, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(3552,2552), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(3552,2552), //bcp->offset
    53, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    36, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(4064,2912), //bcp->offset
    57, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S3490C8,    ABISELECT(832,604), //bcp->offset
    21, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3490C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S3490C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3490C7,    ABISELECT(512,360), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3490C3,    ABISELECT(800,592), //bcp->offset
    15, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S3490C15[];
extern void _ZN7S3490C62v2Ev();
extern void _ZN8S3490C15D1Ev();
extern void _ZN8S3490C15D0Ev();
extern void _ZN7S3490C72v3Ev();
extern void _ZN7S3490C82v4Ev();
extern void ABISELECT(_ZTv0_n72_N8S3490C15D1Ev,_ZTv0_n36_N8S3490C15D1Ev)();
extern void ABISELECT(_ZThn832_N8S3490C15D1Ev,_ZThn604_N8S3490C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S3490C15D0Ev,_ZTv0_n36_N8S3490C15D0Ev)();
extern void ABISELECT(_ZThn832_N8S3490C15D0Ev,_ZThn604_N8S3490C15D0Ev)() __attribute__((weak));
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZTvn16_n72_N8S3490C15D1Ev,_ZTvn8_n36_N8S3490C15D1Ev)();
extern void ABISELECT(_ZTvn16_n72_N8S3490C15D0Ev,_ZTvn8_n36_N8S3490C15D0Ev)();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C72v3Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY vtc_S3490C15[] = {
  ABISELECT(6384,4528),
  ABISELECT(6096,4296),
  ABISELECT(6000,4244),
  ABISELECT(5488,3884),
  ABISELECT(832,604),
  ABISELECT(5472,3868),
  0,
  (VTBL_ENTRY)&(_ZTI8S3490C15[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN8S3490C15D1Ev,
  (VTBL_ENTRY)&_ZN8S3490C15D0Ev,
  ABISELECT(5488,3884),
  ABISELECT(-512,-360),
  (VTBL_ENTRY)&(_ZTI8S3490C15[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
  ABISELECT(5296,3704),
  ABISELECT(5200,3652),
  ABISELECT(4688,3292),
  ABISELECT(4672,3276),
  ABISELECT(-800,-592),
  (VTBL_ENTRY)&(_ZTI8S3490C15[0]),
  ABISELECT(624,420),
  ABISELECT(16,8),
  ABISELECT(-832,-604),
  0,
  ABISELECT(5552,3924),
  ABISELECT(5264,3692),
  ABISELECT(5168,3640),
  ABISELECT(4656,3280),
  ABISELECT(4640,3264),
  ABISELECT(-832,-604),
  (VTBL_ENTRY)&(_ZTI8S3490C15[0]),
  (VTBL_ENTRY)&_ZN7S3490C82v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S3490C15D1Ev,_ZTv0_n36_N8S3490C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S3490C15D0Ev,_ZTv0_n36_N8S3490C15D0Ev),
  ABISELECT(5248,3684),
  ABISELECT(4640,3272),
  ABISELECT(5536,3916),
  ABISELECT(5152,3632),
  ABISELECT(4624,3256),
  ABISELECT(-848,-612),
  (VTBL_ENTRY)&(_ZTI8S3490C15[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n72_N8S3490C15D1Ev,_ZTvn8_n36_N8S3490C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n72_N8S3490C15D0Ev,_ZTvn8_n36_N8S3490C15D0Ev),
  ABISELECT(4528,3204),
  ABISELECT(-944,-664),
  (VTBL_ENTRY)&(_ZTI8S3490C15[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(4544,3220),
  ABISELECT(-1456,-1024),
  (VTBL_ENTRY)&(_ZTI8S3490C15[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
  ABISELECT(1920,1316),
  ABISELECT(-3552,-2552),
  (VTBL_ENTRY)&(_ZTI8S3490C15[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(-4064,-2912),
  (VTBL_ENTRY)&(_ZTI8S3490C15[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  0,
  -16,
  ABISELECT(-5488,-3884),
  (VTBL_ENTRY)&(_ZTI8S3490C15[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  0,
  ABISELECT(-6000,-4244),
  (VTBL_ENTRY)&(_ZTI8S3490C15[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  0,
  ABISELECT(-96,-52),
  ABISELECT(-6096,-4296),
  (VTBL_ENTRY)&(_ZTI8S3490C15[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
  ABISELECT(-288,-232),
  ABISELECT(-384,-284),
  ABISELECT(-896,-644),
  ABISELECT(-912,-660),
  ABISELECT(-6384,-4528),
  (VTBL_ENTRY)&(_ZTI8S3490C15[0]),
};
extern VTBL_ENTRY _ZTV8S3490C15[];
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A__8S3490C15[] = {
  ABISELECT(5472,3868),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A__8S3490C15[] = {
  ABISELECT(5488,3884),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__7S3490C7__A__8S3490C15[] = {
  0,
  ABISELECT(-5488,-3884),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__A__8S3490C15[] = {
  ABISELECT(5296,3704),
  ABISELECT(5200,3652),
  ABISELECT(4688,3292),
  ABISELECT(4672,3276),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C3__A__8S3490C15[] = {
  0,
  -16,
  ABISELECT(-4688,-3292),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C3__A__8S3490C15[] = {
  0,
  ABISELECT(-5200,-3652),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C3__A__8S3490C15[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-5296,-3704),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C82v4Ev();
extern void _ZN7S3490C8D1Ev();
extern void _ZN7S3490C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C8__8S3490C15[] = {
  ABISELECT(5552,3924),
  ABISELECT(5264,3692),
  ABISELECT(5168,3640),
  ABISELECT(4656,3280),
  ABISELECT(4640,3264),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C82v4Ev,
  (VTBL_ENTRY)&_ZN7S3490C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C8D0Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C37S3490C8__8S3490C15[] = {
  ABISELECT(5264,3692),
  ABISELECT(5168,3640),
  ABISELECT(4656,3280),
  ABISELECT(4640,3264),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C37S3490C8__8S3490C15[] = {
  0,
  -16,
  ABISELECT(-4656,-3280),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C37S3490C8__8S3490C15[] = {
  0,
  ABISELECT(-5168,-3640),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C37S3490C8__8S3490C15[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-5264,-3692),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C9D1Ev();
extern void _ZN7S3490C9D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C97S3490C8__8S3490C15[] = {
  ABISELECT(5248,3684),
  ABISELECT(4640,3272),
  ABISELECT(5536,3916),
  ABISELECT(5152,3632),
  ABISELECT(4624,3256),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D0Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C97S3490C8__A1__8S3490C15[] = {
  ABISELECT(4528,3204),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C97S3490C8__A1__8S3490C15[] = {
  ABISELECT(4544,3220),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__7S3490C77S3490C97S3490C8__A1__8S3490C15[] = {
  0,
  ABISELECT(-4544,-3220),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A__7S3490C97S3490C8__8S3490C15[] = {
  ABISELECT(4528,3204),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A__7S3490C97S3490C8__8S3490C15[] = {
  ABISELECT(4544,3220),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A2__7S3490C97S3490C8__8S3490C15[] = {
  0,
  ABISELECT(-5152,-3632),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__7S3490C97S3490C8__8S3490C15[] = {
  ABISELECT(-288,-232),
  ABISELECT(-384,-284),
  ABISELECT(-896,-644),
  ABISELECT(-912,-660),
  ABISELECT(-5536,-3916),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A1__7S3490C97S3490C8__8S3490C15[] = {
  0,
  -16,
  ABISELECT(-4640,-3272),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A1__7S3490C97S3490C8__8S3490C15[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-5248,-3684),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C8__A2__8S3490C15[] = {
  ABISELECT(1920,1316),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C8__8S3490C15[] = {
  0,
  -16,
  ABISELECT(-4656,-3280),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C8__8S3490C15[] = {
  0,
  ABISELECT(-5168,-3640),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C8__8S3490C15[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-5264,-3692),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZThn16_N7S3490C8D1Ev,_ZThn8_N7S3490C8D1Ev)();
extern void ABISELECT(_ZThn16_N7S3490C8D0Ev,_ZThn8_N7S3490C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S3490C9__7S3490C8__8S3490C15[] = {
  ABISELECT(5248,3684),
  ABISELECT(4640,3272),
  ABISELECT(5536,3916),
  ABISELECT(5152,3632),
  ABISELECT(4624,3256),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S3490C8D1Ev,_ZThn8_N7S3490C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S3490C8D0Ev,_ZThn8_N7S3490C8D0Ev),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C9__A1__7S3490C8__8S3490C15[] = {
  ABISELECT(4528,3204),
  ABISELECT(-112,-60),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C9__A1__7S3490C8__8S3490C15[] = {
  ABISELECT(4544,3220),
  ABISELECT(-624,-420),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__A1__7S3490C8__8S3490C15[] = {
  ABISELECT(-288,-232),
  ABISELECT(-384,-284),
  ABISELECT(-896,-644),
  ABISELECT(-912,-660),
  ABISELECT(-5552,-3924),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A__7S3490C8__8S3490C15[] = {
  ABISELECT(1920,1316),
  ABISELECT(-2720,-1948),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__8S3490C15[] = {
  -16,
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__8S3490C15[] = {
  ABISELECT(-96,-52),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__7S3490C7__8S3490C15[] = {
  0,
  ABISELECT(96,52),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__A1__8S3490C15[] = {
  ABISELECT(-288,-232),
  ABISELECT(-384,-284),
  ABISELECT(-896,-644),
  ABISELECT(-912,-660),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C3__A1__8S3490C15[] = {
  0,
  -16,
  ABISELECT(896,644),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C3__A1__8S3490C15[] = {
  0,
  ABISELECT(384,284),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C3__A1__8S3490C15[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(288,232),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
static  VTT_ENTRY vtt_S3490C15[] = {
  {&(_ZTV8S3490C15[8]),  8,80},
  {&(_tg__ZTV7S3490C5__A__8S3490C15[3]),  3,4},
  {&(_tg__ZTV7S3490C7__A__8S3490C15[3]),  3,4},
  {&(_tg__ZTV7S3490C6__7S3490C7__A__8S3490C15[3]),  3,4},
  {&(_tg__ZTV7S3490C3__A__8S3490C15[6]),  6,6},
  {&(_tg__ZTV7S3490C5__7S3490C3__A__8S3490C15[4]),  4,5},
  {&(_tg__ZTV7S3490C6__A1__7S3490C3__A__8S3490C15[3]),  3,4},
  {&(_tg__ZTV7S3490C7__7S3490C3__A__8S3490C15[4]),  4,5},
  {&(_ZTV8S3490C15[32]),  32,80},
  {&(_ZTV8S3490C15[64]),  64,80},
  {&(_ZTV8S3490C15[68]),  68,80},
  {&(_ZTV8S3490C15[73]),  73,80},
  {&(_ZTV8S3490C15[42]),  42,80},
  {&(_ZTV8S3490C15[48]),  48,80},
  {&(_ZTV8S3490C15[52]),  52,80},
  {&(_ZTV8S3490C15[80]),  80,80},
  {&(_ZTV8S3490C15[56]),  56,80},
  {&(_ZTV8S3490C15[59]),  59,80},
  {&(_ZTV8S3490C15[14]),  14,80},
  {&(_ZTV8S3490C15[21]),  21,80},
  {&(_tg__ZTV7S3490C8__8S3490C15[7]),  7,10},
  {&(_tg__ZTV7S3490C37S3490C8__8S3490C15[6]),  6,6},
  {&(_tg__ZTV7S3490C5__7S3490C37S3490C8__8S3490C15[4]),  4,5},
  {&(_tg__ZTV7S3490C6__A1__7S3490C37S3490C8__8S3490C15[3]),  3,4},
  {&(_tg__ZTV7S3490C7__7S3490C37S3490C8__8S3490C15[4]),  4,5},
  {&(_tg__ZTV7S3490C97S3490C8__8S3490C15[7]),  7,10},
  {&(_tg__ZTV7S3490C57S3490C97S3490C8__A1__8S3490C15[3]),  3,4},
  {&(_tg__ZTV7S3490C77S3490C97S3490C8__A1__8S3490C15[3]),  3,4},
  {&(_tg__ZTV7S3490C6__7S3490C77S3490C97S3490C8__A1__8S3490C15[3]),  3,4},
  {&(_tg__ZTV7S3490C5__A__7S3490C97S3490C8__8S3490C15[3]),  3,4},
  {&(_tg__ZTV7S3490C7__A__7S3490C97S3490C8__8S3490C15[3]),  3,4},
  {&(_tg__ZTV7S3490C6__A2__7S3490C97S3490C8__8S3490C15[3]),  3,4},
  {&(_tg__ZTV7S3490C3__7S3490C97S3490C8__8S3490C15[6]),  6,6},
  {&(_tg__ZTV7S3490C5__A1__7S3490C97S3490C8__8S3490C15[4]),  4,5},
  {&(_tg__ZTV7S3490C7__A1__7S3490C97S3490C8__8S3490C15[4]),  4,5},
  {&(_tg__ZTV7S3490C57S3490C8__A2__8S3490C15[3]),  3,4},
  {&(_tg__ZTV7S3490C5__7S3490C8__8S3490C15[4]),  4,5},
  {&(_tg__ZTV7S3490C6__A1__7S3490C8__8S3490C15[3]),  3,4},
  {&(_tg__ZTV7S3490C7__7S3490C8__8S3490C15[4]),  4,5},
  {&(_tg__ZTV7S3490C9__7S3490C8__8S3490C15[7]),  7,10},
  {&(_tg__ZTV7S3490C57S3490C9__A1__7S3490C8__8S3490C15[3]),  3,4},
  {&(_tg__ZTV7S3490C77S3490C9__A1__7S3490C8__8S3490C15[3]),  3,4},
  {&(_tg__ZTV7S3490C3__A1__7S3490C8__8S3490C15[6]),  6,6},
  {&(_tg__ZTV7S3490C5__A__7S3490C8__8S3490C15[3]),  3,4},
  {&(_tg__ZTV7S3490C5__8S3490C15[3]),  3,4},
  {&(_tg__ZTV7S3490C7__8S3490C15[3]),  3,4},
  {&(_tg__ZTV7S3490C6__7S3490C7__8S3490C15[3]),  3,4},
  {&(_tg__ZTV7S3490C3__A1__8S3490C15[6]),  6,6},
  {&(_tg__ZTV7S3490C5__7S3490C3__A1__8S3490C15[4]),  4,5},
  {&(_tg__ZTV7S3490C6__A1__7S3490C3__A1__8S3490C15[3]),  3,4},
  {&(_tg__ZTV7S3490C7__7S3490C3__A1__8S3490C15[4]),  4,5},
};
extern VTBL_ENTRY _ZTI8S3490C15[];
extern  VTBL_ENTRY _ZTV8S3490C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3490C15[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S3490C15D0Ev,_ZTv0_n36_N8S3490C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn832_N8S3490C15D0Ev,_ZThn604_N8S3490C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S3490C15D1Ev,_ZTv0_n36_N8S3490C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn832_N8S3490C15D1Ev,_ZThn604_N8S3490C15D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S3490C15 = {  "S3490C15", // class name
  bases_S3490C15, 20,
  &(vtc_S3490C15[0]), // expected_vtbl_contents
  &(vtt_S3490C15[0]), // expected_vtt_contents
  ABISELECT(6400,4536), // object size
  NSPAIRA(_ZTI8S3490C15),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S3490C15),80, //virtual function table var
  8, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S3490C15),51, //virtual table table var
  19, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3490C1  : S3490C2 , S3490C10 , virtual S3490C15 {
  short s3490c1f0:16;
  void *s3490c1f1;
  short s3490c1f2[5];
  void *s3490c1f3[2];
  int s3490c1f4;
  ::S3490C10 s3490c1f5;
  void *s3490c1f6;
  ::S3490C4 s3490c1f7;
  int s3490c1f8[2];
  char s3490c1f9;
  virtual void  v1(); // _ZN7S3490C12v1Ev
  ~S3490C1(); // tgen
  S3490C1(); // tgen
};
//SIG(1 S3490C1) C1{ BC2{ BC3{ VBC4{ m FL Fi Fc} VBC5{ BC6{ v2 FD Fi:3 Fc:8 FD[2] FL} VBC4 Fc[10] Fi FC7{ VBC6 v3 FC4 FL FC4[7] Fp FL FC4 Fp Fc Fs Fi FC6} FL} VBC6 VBC7 Fp} BC8{ BC3 BC9{ BC6 VBC4 BC5 BC7 VBC3 vd FC7 FC3 Fp Fi FC6 FC7} BC5 BC6 v4 FC5[2] FC6 Fi FC4 Fp[10] Fi[2] FL FD FL Fi} vd v5 v6 Fp[2] Fi Fc FC5 FC8 FD} BC10{ VBC9 BC11{ VBC4 VBC3 BC12{ BC9 vd v7 v8 Fp Fs:6 FC6 FD Fi FC4 FC7 Fp Fi Fp[2]} BC8 FC13{} FC12 FL} BC2 Fi[10] FD Fp[9] Fl[8] Fi Fp FC14{ VBC3 BC9 BC12 v9 Fi Fc Fp Fl} Fp} VBC15{ VBC8 BC5 BC7 BC3 Fp} v1 Fs:16 Fp Fs[5] Fp[2] Fi FC10 Fp FC4 Fi[2] Fc}


void  S3490C1 ::v1(){vfunc_called(this, "_ZN7S3490C12v1Ev");}
S3490C1 ::~S3490C1(){ note_dtor("S3490C1", this);} // tgen
S3490C1 ::S3490C1(){ note_ctor("S3490C1", this);} // tgen

static void Test_S3490C1()
{
  extern Class_Descriptor cd_S3490C1;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(5244,14842)];
    init_test(&cd_S3490C1, buf);
    S3490C1 *dp, &lv = *(dp=new (buf) S3490C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(83888,59364), "sizeof(S3490C1)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S3490C1)");
    /*is_ambiguous_... S3490C1::S3490C2 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C3*)(S3490C2*), ABISELECT(74776,52888), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*), ABISELECT(74776,52888), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C2 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C3*)(S3490C8*)(S3490C2*), ABISELECT(74776,52888), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C2 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C9*)(S3490C8*)(S3490C2*), ABISELECT(74776,52888), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C2 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*)(S3490C9*)(S3490C8*)(S3490C2*), ABISELECT(74776,52888), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C3*), ABISELECT(74776,52888), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C2 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*)(S3490C8*)(S3490C2*), ABISELECT(74776,52888), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C9 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C9*), ABISELECT(74776,52888), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C9 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*)(S3490C9*), ABISELECT(74776,52888), "S3490C1");
    check_base_class_offset(lv, (S3490C4*)(S3490C11*)(S3490C10*), ABISELECT(74776,52888), "S3490C1");
    check_base_class_offset(lv, (S3490C4*)(S3490C9*)(S3490C12*)(S3490C11*)(S3490C10*), ABISELECT(74776,52888), "S3490C1");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*)(S3490C9*)(S3490C12*)(S3490C11*)(S3490C10*), ABISELECT(74776,52888), "S3490C1");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C3*)(S3490C8*)(S3490C11*)(S3490C10*), ABISELECT(74776,52888), "S3490C1");
    check_base_class_offset(lv, (S3490C4*)(S3490C9*)(S3490C8*)(S3490C11*)(S3490C10*), ABISELECT(74776,52888), "S3490C1");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*)(S3490C9*)(S3490C8*)(S3490C11*)(S3490C10*), ABISELECT(74776,52888), "S3490C1");
    /*is_ambiguous_... S3490C8::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*)(S3490C8*)(S3490C11*)(S3490C10*), ABISELECT(74776,52888), "S3490C1");
    /*is_ambiguous_... S3490C2::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C3*)(S3490C2*)(S3490C10*), ABISELECT(74776,52888), "S3490C1");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C3*)(S3490C8*)(S3490C2*)(S3490C10*), ABISELECT(74776,52888), "S3490C1");
    check_base_class_offset(lv, (S3490C4*)(S3490C9*)(S3490C8*)(S3490C2*)(S3490C10*), ABISELECT(74776,52888), "S3490C1");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*)(S3490C9*)(S3490C8*)(S3490C2*)(S3490C10*), ABISELECT(74776,52888), "S3490C1");
    /*is_ambiguous_... S3490C8::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*)(S3490C8*)(S3490C2*)(S3490C10*), ABISELECT(74776,52888), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C8 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C3*)(S3490C8*), ABISELECT(74776,52888), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C8 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C9*)(S3490C8*), ABISELECT(74776,52888), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C8 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*)(S3490C9*)(S3490C8*), ABISELECT(74776,52888), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C8 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*)(S3490C8*), ABISELECT(74776,52888), "S3490C1");
    /*is_ambiguous_... S3490C15::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C5*)(S3490C15*), ABISELECT(74776,52888), "S3490C1");
    /*is_ambiguous_... S3490C15::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C4*)(S3490C3*)(S3490C15*), ABISELECT(74776,52888), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*), ABISELECT(74800,52904), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C2 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C3*)(S3490C2*), ABISELECT(74800,52904), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C2 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C3*)(S3490C8*)(S3490C2*), ABISELECT(74800,52904), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C3*), ABISELECT(74800,52904), "S3490C1");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C3*)(S3490C8*)(S3490C11*)(S3490C10*), ABISELECT(74800,52904), "S3490C1");
    /*is_ambiguous_... S3490C2::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C3*)(S3490C2*)(S3490C10*), ABISELECT(74800,52904), "S3490C1");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C3*)(S3490C8*)(S3490C2*)(S3490C10*), ABISELECT(74800,52904), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C8 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C3*)(S3490C8*), ABISELECT(74800,52904), "S3490C1");
    /*is_ambiguous_... S3490C15::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C3*)(S3490C15*), ABISELECT(74800,52904), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C2 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C3*)(S3490C2*), ABISELECT(75312,53264), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C7*), ABISELECT(75312,53264), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C2 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C3*)(S3490C8*)(S3490C2*), ABISELECT(75312,53264), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C2 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C7*)(S3490C9*)(S3490C8*)(S3490C2*), ABISELECT(75312,53264), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C3*), ABISELECT(75312,53264), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C9 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C7*)(S3490C9*), ABISELECT(75312,53264), "S3490C1");
    /*is_ambiguous_... S3490C9::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C7*)(S3490C9*)(S3490C12*)(S3490C11*)(S3490C10*), ABISELECT(75312,53264), "S3490C1");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C3*)(S3490C8*)(S3490C11*)(S3490C10*), ABISELECT(75312,53264), "S3490C1");
    /*is_ambiguous_... S3490C9::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C7*)(S3490C9*)(S3490C8*)(S3490C11*)(S3490C10*), ABISELECT(75312,53264), "S3490C1");
    /*is_ambiguous_... S3490C2::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C3*)(S3490C2*)(S3490C10*), ABISELECT(75312,53264), "S3490C1");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C3*)(S3490C8*)(S3490C2*)(S3490C10*), ABISELECT(75312,53264), "S3490C1");
    /*is_ambiguous_... S3490C9::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C7*)(S3490C9*)(S3490C8*)(S3490C2*)(S3490C10*), ABISELECT(75312,53264), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C8 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C3*)(S3490C8*), ABISELECT(75312,53264), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C8 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C7*)(S3490C9*)(S3490C8*), ABISELECT(75312,53264), "S3490C1");
    /*is_ambiguous_... S3490C15::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C7*)(S3490C15*), ABISELECT(75312,53264), "S3490C1");
    /*is_ambiguous_... S3490C15::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C3*)(S3490C15*), ABISELECT(75312,53264), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C2 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C3*)(S3490C2*), ABISELECT(75408,53316), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C2 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C3*)(S3490C8*)(S3490C2*), ABISELECT(75408,53316), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C3*), ABISELECT(75408,53316), "S3490C1");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C3*)(S3490C8*)(S3490C11*)(S3490C10*), ABISELECT(75408,53316), "S3490C1");
    /*is_ambiguous_... S3490C2::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C3*)(S3490C2*)(S3490C10*), ABISELECT(75408,53316), "S3490C1");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C3*)(S3490C8*)(S3490C2*)(S3490C10*), ABISELECT(75408,53316), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C8 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C3*)(S3490C8*), ABISELECT(75408,53316), "S3490C1");
    /*is_ambiguous_... S3490C15::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C3*)(S3490C15*), ABISELECT(75408,53316), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C2 */ AMB_check_base_class_offset(lv, (S3490C3*)(S3490C2*), 0, "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C2 */ AMB_check_base_class_offset(lv, (S3490C3*)(S3490C8*)(S3490C2*), ABISELECT(16,8), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C2 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C9*)(S3490C8*)(S3490C2*), ABISELECT(32,16), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C2 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*)(S3490C9*)(S3490C8*)(S3490C2*), ABISELECT(128,68), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C2 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C9*)(S3490C8*)(S3490C2*), ABISELECT(128,68), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C2 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C9*)(S3490C8*)(S3490C2*), ABISELECT(640,428), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C2 */ AMB_check_base_class_offset(lv, (S3490C3*)(S3490C9*)(S3490C8*)(S3490C2*), ABISELECT(75696,53548), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C9 */ AMB_check_base_class_offset(lv, (S3490C3*)(S3490C9*), ABISELECT(75696,53548), "S3490C1");
    /*is_ambiguous_... S3490C11::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C3*)(S3490C11*)(S3490C10*), ABISELECT(75696,53548), "S3490C1");
    check_base_class_offset(lv, (S3490C3*)(S3490C9*)(S3490C12*)(S3490C11*)(S3490C10*), ABISELECT(75696,53548), "S3490C1");
    check_base_class_offset(lv, (S3490C3*)(S3490C9*)(S3490C8*)(S3490C11*)(S3490C10*), ABISELECT(75696,53548), "S3490C1");
    check_base_class_offset(lv, (S3490C3*)(S3490C9*)(S3490C8*)(S3490C2*)(S3490C10*), ABISELECT(75696,53548), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C8 */ AMB_check_base_class_offset(lv, (S3490C3*)(S3490C9*)(S3490C8*), ABISELECT(75696,53548), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C2 */ AMB_check_base_class_offset(lv, (S3490C9*)(S3490C8*)(S3490C2*), ABISELECT(32,16), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C2 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*)(S3490C8*)(S3490C2*), ABISELECT(2736,1956), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C2 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C8*)(S3490C2*), ABISELECT(2736,1956), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C2 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C8*)(S3490C2*), ABISELECT(3248,2316), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C2 */ AMB_check_base_class_offset(lv, (S3490C8*)(S3490C2*), ABISELECT(16,8), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C2 */ AMB_check_base_class_offset(lv, (S3490C2*), 0, "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C9 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C9*), ABISELECT(75712,53556), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C9 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*)(S3490C9*), ABISELECT(75808,53608), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C9 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C9*), ABISELECT(75808,53608), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C9 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C9*), ABISELECT(76320,53968), "S3490C1");
    /*is_ambiguous_... S3490C10::S3490C9 */ AMB_check_base_class_offset(lv, (S3490C9*)(S3490C10*), ABISELECT(75712,53556), "S3490C1");
    /*is_ambiguous_... S3490C9::S3490C6 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C9*)(S3490C12*)(S3490C11*)(S3490C10*), ABISELECT(10800,7608), "S3490C1");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*)(S3490C9*)(S3490C12*)(S3490C11*)(S3490C10*), ABISELECT(10896,7660), "S3490C1");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C9*)(S3490C12*)(S3490C11*)(S3490C10*), ABISELECT(10896,7660), "S3490C1");
    /*is_ambiguous_... S3490C9::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C9*)(S3490C12*)(S3490C11*)(S3490C10*), ABISELECT(11408,8020), "S3490C1");
    check_base_class_offset(lv, (S3490C9*)(S3490C12*)(S3490C11*)(S3490C10*), ABISELECT(10800,7608), "S3490C1");
    check_base_class_offset(lv, (S3490C12*)(S3490C11*)(S3490C10*), ABISELECT(10800,7608), "S3490C1");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C3*)(S3490C8*)(S3490C11*)(S3490C10*), ABISELECT(14080,9940), "S3490C1");
    /*is_ambiguous_... S3490C9::S3490C6 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C9*)(S3490C8*)(S3490C11*)(S3490C10*), ABISELECT(14096,9948), "S3490C1");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*)(S3490C9*)(S3490C8*)(S3490C11*)(S3490C10*), ABISELECT(14192,10000), "S3490C1");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C9*)(S3490C8*)(S3490C11*)(S3490C10*), ABISELECT(14192,10000), "S3490C1");
    /*is_ambiguous_... S3490C9::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C9*)(S3490C8*)(S3490C11*)(S3490C10*), ABISELECT(14704,10360), "S3490C1");
    check_base_class_offset(lv, (S3490C9*)(S3490C8*)(S3490C11*)(S3490C10*), ABISELECT(14096,9948), "S3490C1");
    /*is_ambiguous_... S3490C8::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*)(S3490C8*)(S3490C11*)(S3490C10*), ABISELECT(16800,11888), "S3490C1");
    /*is_ambiguous_... S3490C8::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C8*)(S3490C11*)(S3490C10*), ABISELECT(16800,11888), "S3490C1");
    /*is_ambiguous_... S3490C8::S3490C6 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C8*)(S3490C11*)(S3490C10*), ABISELECT(17312,12248), "S3490C1");
    check_base_class_offset(lv, (S3490C8*)(S3490C11*)(S3490C10*), ABISELECT(14080,9940), "S3490C1");
    check_base_class_offset(lv, (S3490C11*)(S3490C10*), ABISELECT(10800,7608), "S3490C1");
    /*is_ambiguous_... S3490C2::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C3*)(S3490C2*)(S3490C10*), ABISELECT(22944,16216), "S3490C1");
    /*is_ambiguous_... S3490C8::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C3*)(S3490C8*)(S3490C2*)(S3490C10*), ABISELECT(22960,16224), "S3490C1");
    /*is_ambiguous_... S3490C9::S3490C6 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C9*)(S3490C8*)(S3490C2*)(S3490C10*), ABISELECT(22976,16232), "S3490C1");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*)(S3490C9*)(S3490C8*)(S3490C2*)(S3490C10*), ABISELECT(23072,16284), "S3490C1");
    /*is_ambiguous_... S3490C9::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C9*)(S3490C8*)(S3490C2*)(S3490C10*), ABISELECT(23072,16284), "S3490C1");
    /*is_ambiguous_... S3490C9::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C9*)(S3490C8*)(S3490C2*)(S3490C10*), ABISELECT(23584,16644), "S3490C1");
    check_base_class_offset(lv, (S3490C9*)(S3490C8*)(S3490C2*)(S3490C10*), ABISELECT(22976,16232), "S3490C1");
    /*is_ambiguous_... S3490C8::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*)(S3490C8*)(S3490C2*)(S3490C10*), ABISELECT(25680,18172), "S3490C1");
    /*is_ambiguous_... S3490C8::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C8*)(S3490C2*)(S3490C10*), ABISELECT(25680,18172), "S3490C1");
    /*is_ambiguous_... S3490C8::S3490C6 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C8*)(S3490C2*)(S3490C10*), ABISELECT(26192,18532), "S3490C1");
    check_base_class_offset(lv, (S3490C8*)(S3490C2*)(S3490C10*), ABISELECT(22960,16224), "S3490C1");
    check_base_class_offset(lv, (S3490C2*)(S3490C10*), ABISELECT(22944,16216), "S3490C1");
    check_base_class_offset(lv, (S3490C10*), ABISELECT(10800,7608), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C8 */ AMB_check_base_class_offset(lv, (S3490C3*)(S3490C8*), ABISELECT(79248,56100), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C8 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C9*)(S3490C8*), ABISELECT(79264,56108), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C8 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*)(S3490C9*)(S3490C8*), ABISELECT(79360,56160), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C8 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C9*)(S3490C8*), ABISELECT(79360,56160), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C8 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C9*)(S3490C8*), ABISELECT(79872,56520), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C8 */ AMB_check_base_class_offset(lv, (S3490C9*)(S3490C8*), ABISELECT(79264,56108), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C8 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*)(S3490C8*), ABISELECT(81968,58048), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C8 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C8*), ABISELECT(81968,58048), "S3490C1");
    /*is_ambiguous_... S3490C1::S3490C8 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C8*), ABISELECT(82480,58408), "S3490C1");
    check_base_class_offset(lv, (S3490C8*)(S3490C15*), ABISELECT(79248,56100), "S3490C1");
    /*is_ambiguous_... S3490C15::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C6*)(S3490C5*)(S3490C15*), ABISELECT(78416,55496), "S3490C1");
    /*is_ambiguous_... S3490C15::S3490C5 */ AMB_check_base_class_offset(lv, (S3490C5*)(S3490C15*), ABISELECT(78416,55496), "S3490C1");
    /*is_ambiguous_... S3490C15::S3490C7 */ AMB_check_base_class_offset(lv, (S3490C7*)(S3490C15*), ABISELECT(78928,55856), "S3490C1");
    /*is_ambiguous_... S3490C15::S3490C3 */ AMB_check_base_class_offset(lv, (S3490C3*)(S3490C15*), ABISELECT(79216,56088), "S3490C1");
    check_base_class_offset(lv, (S3490C15*), ABISELECT(78416,55496), "S3490C1");
    set_bf_and_test(lv, s3490c1f0, ABISELECT(40920,28912), 0, 16, 1, "S3490C1");
    set_bf_and_test(lv, s3490c1f0, ABISELECT(40920,28912), 0, 16, hide_sll(1LL<<15), "S3490C1");
    check_field_offset(lv, s3490c1f1, ABISELECT(40928,28916), "S3490C1.s3490c1f1");
    check_field_offset(lv, s3490c1f2, ABISELECT(40936,28920), "S3490C1.s3490c1f2");
    check_field_offset(lv, s3490c1f3, ABISELECT(40952,28932), "S3490C1.s3490c1f3");
    check_field_offset(lv, s3490c1f4, ABISELECT(40968,28940), "S3490C1.s3490c1f4");
    check_field_offset(lv, s3490c1f5, ABISELECT(40976,28944), "S3490C1.s3490c1f5");
    check_field_offset(lv, s3490c1f6, ABISELECT(74736,52856), "S3490C1.s3490c1f6");
    check_field_offset(lv, s3490c1f7, ABISELECT(74744,52860), "S3490C1.s3490c1f7");
    check_field_offset(lv, s3490c1f8, ABISELECT(74760,52876), "S3490C1.s3490c1f8");
    check_field_offset(lv, s3490c1f9, ABISELECT(74768,52884), "S3490C1.s3490c1f9");
    test_class_info(&lv, &cd_S3490C1);
    dp->~S3490C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3490C1(Test_S3490C1, "S3490C1", ABISELECT(83888,59364));

#else // __cplusplus

extern void _ZN7S3490C1C1Ev();
extern void _ZN7S3490C1D1Ev();
Name_Map name_map_S3490C1[] = {
  NSPAIR(_ZN7S3490C1C1Ev),
  NSPAIR(_ZN7S3490C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3490C4;
extern VTBL_ENTRY _ZTI7S3490C4[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C7;
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
extern Class_Descriptor cd_S3490C3;
extern VTBL_ENTRY _ZTI7S3490C3[];
extern  VTBL_ENTRY _ZTV7S3490C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C3[];
extern Class_Descriptor cd_S3490C3;
extern VTBL_ENTRY _ZTI7S3490C3[];
extern  VTBL_ENTRY _ZTV7S3490C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C3[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C7;
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
extern Class_Descriptor cd_S3490C3;
extern VTBL_ENTRY _ZTI7S3490C3[];
extern  VTBL_ENTRY _ZTV7S3490C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C3[];
extern Class_Descriptor cd_S3490C9;
extern VTBL_ENTRY _ZTI7S3490C9[];
extern  VTBL_ENTRY _ZTV7S3490C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C9[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C8;
extern VTBL_ENTRY _ZTI7S3490C8[];
extern  VTBL_ENTRY _ZTV7S3490C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C8[];
extern Class_Descriptor cd_S3490C2;
extern VTBL_ENTRY _ZTI7S3490C2[];
extern  VTBL_ENTRY _ZTV7S3490C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C2[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C7;
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
extern Class_Descriptor cd_S3490C9;
extern VTBL_ENTRY _ZTI7S3490C9[];
extern  VTBL_ENTRY _ZTV7S3490C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C9[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C7;
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
extern Class_Descriptor cd_S3490C9;
extern VTBL_ENTRY _ZTI7S3490C9[];
extern  VTBL_ENTRY _ZTV7S3490C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C9[];
extern Class_Descriptor cd_S3490C12;
extern VTBL_ENTRY _ZTI8S3490C12[];
extern  VTBL_ENTRY _ZTV8S3490C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3490C12[];
extern Class_Descriptor cd_S3490C3;
extern VTBL_ENTRY _ZTI7S3490C3[];
extern  VTBL_ENTRY _ZTV7S3490C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C3[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C7;
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
extern Class_Descriptor cd_S3490C9;
extern VTBL_ENTRY _ZTI7S3490C9[];
extern  VTBL_ENTRY _ZTV7S3490C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C9[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C8;
extern VTBL_ENTRY _ZTI7S3490C8[];
extern  VTBL_ENTRY _ZTV7S3490C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C8[];
extern Class_Descriptor cd_S3490C11;
extern VTBL_ENTRY _ZTI8S3490C11[];
extern  VTBL_ENTRY _ZTV8S3490C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3490C11[];
extern Class_Descriptor cd_S3490C3;
extern VTBL_ENTRY _ZTI7S3490C3[];
extern  VTBL_ENTRY _ZTV7S3490C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C3[];
extern Class_Descriptor cd_S3490C3;
extern VTBL_ENTRY _ZTI7S3490C3[];
extern  VTBL_ENTRY _ZTV7S3490C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C3[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C7;
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
extern Class_Descriptor cd_S3490C9;
extern VTBL_ENTRY _ZTI7S3490C9[];
extern  VTBL_ENTRY _ZTV7S3490C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C9[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C8;
extern VTBL_ENTRY _ZTI7S3490C8[];
extern  VTBL_ENTRY _ZTV7S3490C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C8[];
extern Class_Descriptor cd_S3490C2;
extern VTBL_ENTRY _ZTI7S3490C2[];
extern  VTBL_ENTRY _ZTV7S3490C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C2[];
extern Class_Descriptor cd_S3490C10;
extern VTBL_ENTRY _ZTI8S3490C10[];
extern  VTBL_ENTRY _ZTV8S3490C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3490C10[];
extern Class_Descriptor cd_S3490C3;
extern VTBL_ENTRY _ZTI7S3490C3[];
extern  VTBL_ENTRY _ZTV7S3490C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C3[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C7;
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
extern Class_Descriptor cd_S3490C9;
extern VTBL_ENTRY _ZTI7S3490C9[];
extern  VTBL_ENTRY _ZTV7S3490C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C9[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C8;
extern VTBL_ENTRY _ZTI7S3490C8[];
extern  VTBL_ENTRY _ZTV7S3490C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C8[];
extern Class_Descriptor cd_S3490C6;
extern VTBL_ENTRY _ZTI7S3490C6[];
extern  VTBL_ENTRY _ZTV7S3490C6[];
extern Class_Descriptor cd_S3490C5;
extern VTBL_ENTRY _ZTI7S3490C5[];
extern  VTBL_ENTRY _ZTV7S3490C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C5[];
extern Class_Descriptor cd_S3490C7;
extern VTBL_ENTRY _ZTI7S3490C7[];
extern  VTBL_ENTRY _ZTV7S3490C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C7[];
extern Class_Descriptor cd_S3490C3;
extern VTBL_ENTRY _ZTI7S3490C3[];
extern  VTBL_ENTRY _ZTV7S3490C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3490C3[];
extern Class_Descriptor cd_S3490C15;
extern VTBL_ENTRY _ZTI8S3490C15[];
extern  VTBL_ENTRY _ZTV8S3490C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3490C15[];
static Base_Class bases_S3490C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3490C4,    ABISELECT(74776,52888), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S3490C6,    ABISELECT(74800,52904), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(74800,52904), //bcp->offset
    152, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    152, //bcp->index_in_construction_vtbl_array
    187, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S3490C6,    ABISELECT(75312,53264), //bcp->offset
    157, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    153, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S3490C7,    ABISELECT(75408,53316), //bcp->offset
    161, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    154, //bcp->index_in_construction_vtbl_array
    188, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S3490C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S3490C3,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(128,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(128,68), //bcp->offset
    35, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    157, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S3490C7,    ABISELECT(640,428), //bcp->offset
    39, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    158, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S3490C3,    ABISELECT(75696,53548), //bcp->offset
    166, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    159, //bcp->index_in_construction_vtbl_array
    190, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S3490C9,    ABISELECT(32,16), //bcp->offset
    25, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    156, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(2736,1956), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(2736,1956), //bcp->offset
    43, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    160, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    34, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(3248,2316), //bcp->offset
    47, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    35, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S3490C8,    ABISELECT(16,8), //bcp->offset
    15, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    155, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    36, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S3490C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    37, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3490C6,    ABISELECT(75712,53556), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(75808,53608), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(75808,53608), //bcp->offset
    185, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    163, //bcp->index_in_construction_vtbl_array
    195, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S3490C7,    ABISELECT(76320,53968), //bcp->offset
    189, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    164, //bcp->index_in_construction_vtbl_array
    196, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S3490C9,    ABISELECT(75712,53556), //bcp->offset
    172, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    162, //bcp->index_in_construction_vtbl_array
    194, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    52, //immediately_derived
  0, 1},
  {&cd_S3490C6,    ABISELECT(10800,7608), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    38, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(10896,7660), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    39, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(10896,7660), //bcp->offset
    63, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    165, //bcp->index_in_construction_vtbl_array
    44, //bcp->base_subarray_index_in_construction_vtbl_array
    40, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S3490C7,    ABISELECT(11408,8020), //bcp->offset
    67, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    166, //bcp->index_in_construction_vtbl_array
    45, //bcp->base_subarray_index_in_construction_vtbl_array
    41, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S3490C9,    ABISELECT(10800,7608), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    43, //bcp->base_subarray_index_in_construction_vtbl_array
    42, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S3490C12,    ABISELECT(10800,7608), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    42, //bcp->base_subarray_index_in_construction_vtbl_array
    43, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S3490C3,    ABISELECT(14080,9940), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    60, //bcp->base_subarray_index_in_construction_vtbl_array
    44, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(14096,9948), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    45, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(14192,10000), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    46, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(14192,10000), //bcp->offset
    91, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    169, //bcp->index_in_construction_vtbl_array
    65, //bcp->base_subarray_index_in_construction_vtbl_array
    47, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S3490C7,    ABISELECT(14704,10360), //bcp->offset
    95, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    170, //bcp->index_in_construction_vtbl_array
    66, //bcp->base_subarray_index_in_construction_vtbl_array
    48, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S3490C9,    ABISELECT(14096,9948), //bcp->offset
    81, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    168, //bcp->index_in_construction_vtbl_array
    64, //bcp->base_subarray_index_in_construction_vtbl_array
    49, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(16800,11888), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    50, //init_seq
    36, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(16800,11888), //bcp->offset
    99, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    171, //bcp->index_in_construction_vtbl_array
    74, //bcp->base_subarray_index_in_construction_vtbl_array
    51, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(17312,12248), //bcp->offset
    103, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    52, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S3490C8,    ABISELECT(14080,9940), //bcp->offset
    71, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    167, //bcp->index_in_construction_vtbl_array
    59, //bcp->base_subarray_index_in_construction_vtbl_array
    53, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S3490C11,    ABISELECT(10800,7608), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    41, //bcp->base_subarray_index_in_construction_vtbl_array
    54, //init_seq
    52, //immediately_derived
  0, 0},
  {&cd_S3490C3,    ABISELECT(22944,16216), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    95, //bcp->base_subarray_index_in_construction_vtbl_array
    55, //init_seq
    51, //immediately_derived
  0, 0},
  {&cd_S3490C3,    ABISELECT(22960,16224), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    100, //bcp->base_subarray_index_in_construction_vtbl_array
    56, //init_seq
    50, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(22976,16232), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    57, //init_seq
    46, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(23072,16284), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    58, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(23072,16284), //bcp->offset
    137, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    175, //bcp->index_in_construction_vtbl_array
    105, //bcp->base_subarray_index_in_construction_vtbl_array
    59, //init_seq
    46, //immediately_derived
  0, 0},
  {&cd_S3490C7,    ABISELECT(23584,16644), //bcp->offset
    141, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    176, //bcp->index_in_construction_vtbl_array
    106, //bcp->base_subarray_index_in_construction_vtbl_array
    60, //init_seq
    46, //immediately_derived
  0, 0},
  {&cd_S3490C9,    ABISELECT(22976,16232), //bcp->offset
    127, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    174, //bcp->index_in_construction_vtbl_array
    104, //bcp->base_subarray_index_in_construction_vtbl_array
    61, //init_seq
    50, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(25680,18172), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    62, //init_seq
    48, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(25680,18172), //bcp->offset
    145, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    177, //bcp->index_in_construction_vtbl_array
    114, //bcp->base_subarray_index_in_construction_vtbl_array
    63, //init_seq
    50, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(26192,18532), //bcp->offset
    149, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    64, //init_seq
    50, //immediately_derived
  0, 0},
  {&cd_S3490C8,    ABISELECT(22960,16224), //bcp->offset
    117, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    173, //bcp->index_in_construction_vtbl_array
    99, //bcp->base_subarray_index_in_construction_vtbl_array
    65, //init_seq
    51, //immediately_derived
  0, 0},
  {&cd_S3490C2,    ABISELECT(22944,16216), //bcp->offset
    106, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    172, //bcp->index_in_construction_vtbl_array
    94, //bcp->base_subarray_index_in_construction_vtbl_array
    66, //init_seq
    52, //immediately_derived
  0, 0},
  {&cd_S3490C10,    ABISELECT(10800,7608), //bcp->offset
    50, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    161, //bcp->index_in_construction_vtbl_array
    40, //bcp->base_subarray_index_in_construction_vtbl_array
    67, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3490C3,    ABISELECT(79248,56100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    225, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    62, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(79264,56108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    58, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(79360,56160), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    56, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(79360,56160), //bcp->offset
    241, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    181, //bcp->index_in_construction_vtbl_array
    230, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    58, //immediately_derived
  0, 0},
  {&cd_S3490C7,    ABISELECT(79872,56520), //bcp->offset
    245, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    182, //bcp->index_in_construction_vtbl_array
    231, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    58, //immediately_derived
  0, 0},
  {&cd_S3490C9,    ABISELECT(79264,56108), //bcp->offset
    231, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    180, //bcp->index_in_construction_vtbl_array
    229, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    62, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(81968,58048), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    60, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(81968,58048), //bcp->offset
    249, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    183, //bcp->index_in_construction_vtbl_array
    239, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    62, //immediately_derived
  0, 0},
  {&cd_S3490C6,    ABISELECT(82480,58408), //bcp->offset
    253, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    184, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    62, //immediately_derived
  0, 0},
  {&cd_S3490C8,    ABISELECT(79248,56100), //bcp->offset
    217, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    179, //bcp->index_in_construction_vtbl_array
    224, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    67, //immediately_derived
  0, 1},
  {&cd_S3490C6,    ABISELECT(78416,55496), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    64, //immediately_derived
  0, 0},
  {&cd_S3490C5,    ABISELECT(78416,55496), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    205, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    67, //immediately_derived
  0, 0},
  {&cd_S3490C7,    ABISELECT(78928,55856), //bcp->offset
    207, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    185, //bcp->index_in_construction_vtbl_array
    206, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    67, //immediately_derived
  0, 0},
  {&cd_S3490C3,    ABISELECT(79216,56088), //bcp->offset
    211, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    186, //bcp->index_in_construction_vtbl_array
    208, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    67, //immediately_derived
  0, 0},
  {&cd_S3490C15,    ABISELECT(78416,55496), //bcp->offset
    193, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    178, //bcp->index_in_construction_vtbl_array
    204, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S3490C1[];
extern void _ZN7S3490C1D1Ev();
extern void _ZN7S3490C1D0Ev();
extern void _ZN7S3490C22v5Ev();
extern void _ZN7S3490C22v6Ev();
extern void _ZN7S3490C12v1Ev();
extern void _ZN7S3490C82v4Ev();
extern void ABISELECT(_ZThn16_N7S3490C1D1Ev,_ZThn8_N7S3490C1D1Ev)();
extern void ABISELECT(_ZThn16_N7S3490C1D0Ev,_ZThn8_N7S3490C1D0Ev)();
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZThn32_N7S3490C1D1Ev,_ZThn16_N7S3490C1D1Ev)();
extern void ABISELECT(_ZThn32_N7S3490C1D0Ev,_ZThn16_N7S3490C1D0Ev)();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C72v3Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZThn10800_N7S3490C1D1Ev,_ZThn7608_N7S3490C1D1Ev)();
extern void ABISELECT(_ZThn10800_N7S3490C1D0Ev,_ZThn7608_N7S3490C1D0Ev)();
extern void _ZN8S3490C122v7Ev();
extern void _ZN8S3490C122v8Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C72v3Ev();
extern void _ZN7S3490C82v4Ev();
extern void ABISELECT(_ZThn14080_N7S3490C1D1Ev,_ZThn9940_N7S3490C1D1Ev)();
extern void ABISELECT(_ZThn14080_N7S3490C1D0Ev,_ZThn9940_N7S3490C1D0Ev)();
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZThn14096_N7S3490C1D1Ev,_ZThn9948_N7S3490C1D1Ev)();
extern void ABISELECT(_ZThn14096_N7S3490C1D0Ev,_ZThn9948_N7S3490C1D0Ev)();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C72v3Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZThn22944_N7S3490C1D1Ev,_ZThn16216_N7S3490C1D1Ev)();
extern void ABISELECT(_ZThn22944_N7S3490C1D0Ev,_ZThn16216_N7S3490C1D0Ev)();
extern void _ZN7S3490C22v5Ev();
extern void _ZN7S3490C22v6Ev();
extern void _ZN7S3490C82v4Ev();
extern void ABISELECT(_ZThn22960_N7S3490C1D1Ev,_ZThn16224_N7S3490C1D1Ev)();
extern void ABISELECT(_ZThn22960_N7S3490C1D0Ev,_ZThn16224_N7S3490C1D0Ev)();
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZThn22976_N7S3490C1D1Ev,_ZThn16232_N7S3490C1D1Ev)();
extern void ABISELECT(_ZThn22976_N7S3490C1D0Ev,_ZThn16232_N7S3490C1D0Ev)();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C72v3Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C72v3Ev();
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZTv0_n72_N7S3490C1D1Ev,_ZTv0_n36_N7S3490C1D1Ev)();
extern void ABISELECT(_ZThn75712_N7S3490C1D1Ev,_ZThn53556_N7S3490C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N7S3490C1D0Ev,_ZTv0_n36_N7S3490C1D0Ev)();
extern void ABISELECT(_ZThn75712_N7S3490C1D0Ev,_ZThn53556_N7S3490C1D0Ev)() __attribute__((weak));
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C72v3Ev();
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZTv0_n80_N7S3490C1D1Ev,_ZTv0_n40_N7S3490C1D1Ev)();
extern void ABISELECT(_ZThn78416_N7S3490C1D1Ev,_ZThn55496_N7S3490C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N7S3490C1D0Ev,_ZTv0_n40_N7S3490C1D0Ev)();
extern void ABISELECT(_ZThn78416_N7S3490C1D0Ev,_ZThn55496_N7S3490C1D0Ev)() __attribute__((weak));
extern void _ZN7S3490C72v3Ev();
extern void _ZN7S3490C82v4Ev();
extern void ABISELECT(_ZTv0_n72_N7S3490C1D1Ev,_ZTv0_n36_N7S3490C1D1Ev)();
extern void ABISELECT(_ZThn79248_N7S3490C1D1Ev,_ZThn56100_N7S3490C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N7S3490C1D0Ev,_ZTv0_n36_N7S3490C1D0Ev)();
extern void ABISELECT(_ZThn79248_N7S3490C1D0Ev,_ZThn56100_N7S3490C1D0Ev)() __attribute__((weak));
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZTvn16_n72_N7S3490C1D1Ev,_ZTvn8_n36_N7S3490C1D1Ev)();
extern void ABISELECT(_ZTvn16_n72_N7S3490C1D0Ev,_ZTvn8_n36_N7S3490C1D0Ev)();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C72v3Ev();
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY vtc_S3490C1[] = {
  ABISELECT(79248,56100),
  ABISELECT(78416,55496),
  ABISELECT(75712,53556),
  ABISELECT(75696,53548),
  ABISELECT(75408,53316),
  ABISELECT(75312,53264),
  ABISELECT(74800,52904),
  ABISELECT(74776,52888),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C1D0Ev,
  (VTBL_ENTRY)&_ZN7S3490C22v5Ev,
  (VTBL_ENTRY)&_ZN7S3490C22v6Ev,
  (VTBL_ENTRY)&_ZN7S3490C12v1Ev,
  ABISELECT(75680,53540),
  ABISELECT(75392,53308),
  ABISELECT(75296,53256),
  ABISELECT(74784,52896),
  ABISELECT(74760,52880),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C82v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S3490C1D1Ev,_ZThn8_N7S3490C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S3490C1D0Ev,_ZThn8_N7S3490C1D0Ev),
  ABISELECT(75376,53300),
  ABISELECT(74768,52888),
  ABISELECT(75664,53532),
  ABISELECT(75280,53248),
  ABISELECT(74744,52872),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N7S3490C1D1Ev,_ZThn16_N7S3490C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N7S3490C1D0Ev,_ZThn16_N7S3490C1D0Ev),
  ABISELECT(74648,52820),
  ABISELECT(-128,-68),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(74672,52836),
  ABISELECT(-640,-428),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
  ABISELECT(72040,50932),
  ABISELECT(-2736,-1956),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(-3248,-2316),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(64912,45948),
  ABISELECT(64608,45708),
  ABISELECT(64000,45296),
  ABISELECT(64896,45940),
  ABISELECT(64512,45656),
  ABISELECT(63976,45280),
  ABISELECT(-10800,-7608),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn10800_N7S3490C1D1Ev,_ZThn7608_N7S3490C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn10800_N7S3490C1D0Ev,_ZThn7608_N7S3490C1D0Ev),
  (VTBL_ENTRY)&_ZN8S3490C122v7Ev,
  (VTBL_ENTRY)&_ZN8S3490C122v8Ev,
  ABISELECT(63880,45228),
  ABISELECT(-10896,-7660),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(63904,45244),
  ABISELECT(-11408,-8020),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
  ABISELECT(61616,43608),
  ABISELECT(61328,43376),
  ABISELECT(61232,43324),
  ABISELECT(60720,42964),
  ABISELECT(60696,42948),
  ABISELECT(-14080,-9940),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C82v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn14080_N7S3490C1D1Ev,_ZThn9940_N7S3490C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn14080_N7S3490C1D0Ev,_ZThn9940_N7S3490C1D0Ev),
  ABISELECT(61312,43368),
  ABISELECT(60704,42956),
  ABISELECT(61600,43600),
  ABISELECT(61216,43316),
  ABISELECT(60680,42940),
  ABISELECT(-14096,-9948),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn14096_N7S3490C1D1Ev,_ZThn9948_N7S3490C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn14096_N7S3490C1D0Ev,_ZThn9948_N7S3490C1D0Ev),
  ABISELECT(60584,42888),
  ABISELECT(-14192,-10000),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(60608,42904),
  ABISELECT(-14704,-10360),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
  ABISELECT(57976,41000),
  ABISELECT(-16800,-11888),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(-17312,-12248),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(52752,37332),
  ABISELECT(52464,37100),
  ABISELECT(52368,37048),
  ABISELECT(51856,36688),
  ABISELECT(51832,36672),
  ABISELECT(-22944,-16216),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn22944_N7S3490C1D1Ev,_ZThn16216_N7S3490C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn22944_N7S3490C1D0Ev,_ZThn16216_N7S3490C1D0Ev),
  (VTBL_ENTRY)&_ZN7S3490C22v5Ev,
  (VTBL_ENTRY)&_ZN7S3490C22v6Ev,
  ABISELECT(52736,37324),
  ABISELECT(52448,37092),
  ABISELECT(52352,37040),
  ABISELECT(51840,36680),
  ABISELECT(51816,36664),
  ABISELECT(-22960,-16224),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C82v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn22960_N7S3490C1D1Ev,_ZThn16224_N7S3490C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn22960_N7S3490C1D0Ev,_ZThn16224_N7S3490C1D0Ev),
  ABISELECT(52432,37084),
  ABISELECT(51824,36672),
  ABISELECT(52720,37316),
  ABISELECT(52336,37032),
  ABISELECT(51800,36656),
  ABISELECT(-22976,-16232),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn22976_N7S3490C1D1Ev,_ZThn16232_N7S3490C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn22976_N7S3490C1D0Ev,_ZThn16232_N7S3490C1D0Ev),
  ABISELECT(51704,36604),
  ABISELECT(-23072,-16284),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(51728,36620),
  ABISELECT(-23584,-16644),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
  ABISELECT(49096,34716),
  ABISELECT(-25680,-18172),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(-26192,-18532),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  0,
  ABISELECT(-24,-16),
  ABISELECT(-74800,-52904),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  0,
  ABISELECT(-75312,-53264),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  0,
  ABISELECT(-96,-52),
  ABISELECT(-75408,-53316),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
  ABISELECT(-288,-232),
  ABISELECT(-384,-284),
  ABISELECT(-896,-644),
  ABISELECT(-920,-660),
  ABISELECT(-75696,-53548),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  ABISELECT(608,412),
  ABISELECT(-75712,-53556),
  0,
  ABISELECT(-304,-240),
  ABISELECT(-912,-652),
  ABISELECT(-16,-8),
  ABISELECT(-400,-292),
  ABISELECT(-936,-668),
  ABISELECT(-75712,-53556),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N7S3490C1D1Ev,_ZTv0_n36_N7S3490C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N7S3490C1D0Ev,_ZTv0_n36_N7S3490C1D0Ev),
  ABISELECT(-1032,-720),
  ABISELECT(-75808,-53608),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(-1008,-704),
  ABISELECT(-76320,-53968),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
  ABISELECT(512,360),
  ABISELECT(-78416,-55496),
  0,
  ABISELECT(-2720,-1948),
  ABISELECT(-3008,-2180),
  ABISELECT(-3104,-2232),
  ABISELECT(-3616,-2592),
  ABISELECT(832,604),
  ABISELECT(-3640,-2608),
  ABISELECT(-78416,-55496),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N7S3490C1D1Ev,_ZTv0_n40_N7S3490C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N7S3490C1D0Ev,_ZTv0_n40_N7S3490C1D0Ev),
  ABISELECT(-3616,-2592),
  ABISELECT(-78928,-55856),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
  ABISELECT(-3808,-2772),
  ABISELECT(-3904,-2824),
  ABISELECT(-4416,-3184),
  ABISELECT(-4440,-3200),
  ABISELECT(-79216,-56088),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  ABISELECT(624,420),
  ABISELECT(16,8),
  ABISELECT(-79248,-56100),
  0,
  ABISELECT(-3552,-2552),
  ABISELECT(-3840,-2784),
  ABISELECT(-3936,-2836),
  ABISELECT(-4448,-3196),
  ABISELECT(-4472,-3212),
  ABISELECT(-79248,-56100),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C82v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N7S3490C1D1Ev,_ZTv0_n36_N7S3490C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N7S3490C1D0Ev,_ZTv0_n36_N7S3490C1D0Ev),
  ABISELECT(-3856,-2792),
  ABISELECT(-4464,-3204),
  ABISELECT(-3568,-2560),
  ABISELECT(-3952,-2844),
  ABISELECT(-4488,-3220),
  ABISELECT(-79264,-56108),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n72_N7S3490C1D1Ev,_ZTvn8_n36_N7S3490C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n72_N7S3490C1D0Ev,_ZTvn8_n36_N7S3490C1D0Ev),
  ABISELECT(-4584,-3272),
  ABISELECT(-79360,-56160),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(-4560,-3256),
  ABISELECT(-79872,-56520),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
  ABISELECT(-7192,-5160),
  ABISELECT(-81968,-58048),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  ABISELECT(-82480,-58408),
  (VTBL_ENTRY)&(_ZTI7S3490C1[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern VTBL_ENTRY _ZTV7S3490C1[];
extern void _ZN7S3490C2D1Ev();
extern void _ZN7S3490C2D0Ev();
extern void _ZN7S3490C22v5Ev();
extern void _ZN7S3490C22v6Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C2__7S3490C1[] = {
  ABISELECT(75696,53548),
  ABISELECT(75408,53316),
  ABISELECT(75312,53264),
  ABISELECT(74800,52904),
  ABISELECT(74776,52888),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C2D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C2D0Ev,
  (VTBL_ENTRY)&_ZN7S3490C22v5Ev,
  (VTBL_ENTRY)&_ZN7S3490C22v6Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C37S3490C2__7S3490C1[] = {
  ABISELECT(75408,53316),
  ABISELECT(75312,53264),
  ABISELECT(74800,52904),
  ABISELECT(74776,52888),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C37S3490C2__7S3490C1[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-74800,-52904),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C37S3490C2__7S3490C1[] = {
  0,
  ABISELECT(-75312,-53264),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C37S3490C2__7S3490C1[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-75408,-53316),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C82v4Ev();
extern void _ZN7S3490C8D1Ev();
extern void _ZN7S3490C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C87S3490C2__7S3490C1[] = {
  ABISELECT(75680,53540),
  ABISELECT(75392,53308),
  ABISELECT(75296,53256),
  ABISELECT(74784,52896),
  ABISELECT(74760,52880),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C82v4Ev,
  (VTBL_ENTRY)&_ZN7S3490C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C8D0Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C37S3490C87S3490C2__A1__7S3490C1[] = {
  ABISELECT(75392,53308),
  ABISELECT(75296,53256),
  ABISELECT(74784,52896),
  ABISELECT(74760,52880),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C37S3490C87S3490C2__A1__7S3490C1[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-74784,-52896),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C37S3490C87S3490C2__A1__7S3490C1[] = {
  0,
  ABISELECT(-75296,-53256),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C37S3490C87S3490C2__A1__7S3490C1[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-75392,-53308),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C9D1Ev();
extern void _ZN7S3490C9D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C97S3490C87S3490C2__7S3490C1[] = {
  ABISELECT(75376,53300),
  ABISELECT(74768,52888),
  ABISELECT(75664,53532),
  ABISELECT(75280,53248),
  ABISELECT(74744,52872),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D0Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C97S3490C87S3490C2__A1__7S3490C1[] = {
  ABISELECT(74648,52820),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C97S3490C87S3490C2__A1__7S3490C1[] = {
  ABISELECT(74672,52836),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__7S3490C77S3490C97S3490C87S3490C2__A1__7S3490C1[] = {
  0,
  ABISELECT(-74672,-52836),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A__7S3490C97S3490C87S3490C2__7S3490C1[] = {
  ABISELECT(74648,52820),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A__7S3490C97S3490C87S3490C2__7S3490C1[] = {
  ABISELECT(74672,52836),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A2__7S3490C97S3490C87S3490C2__7S3490C1[] = {
  0,
  ABISELECT(-75280,-53248),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__7S3490C97S3490C87S3490C2__7S3490C1[] = {
  ABISELECT(-288,-232),
  ABISELECT(-384,-284),
  ABISELECT(-896,-644),
  ABISELECT(-920,-660),
  ABISELECT(-75664,-53532),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A1__7S3490C97S3490C87S3490C2__7S3490C1[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-74768,-52888),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A1__7S3490C97S3490C87S3490C2__7S3490C1[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-75376,-53300),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C87S3490C2__A2__7S3490C1[] = {
  ABISELECT(72040,50932),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C87S3490C2__7S3490C1[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-74784,-52896),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C87S3490C2__7S3490C1[] = {
  0,
  ABISELECT(-75296,-53256),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C87S3490C2__7S3490C1[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-75392,-53308),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZThn16_N7S3490C8D1Ev,_ZThn8_N7S3490C8D1Ev)();
extern void ABISELECT(_ZThn16_N7S3490C8D0Ev,_ZThn8_N7S3490C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S3490C9__7S3490C87S3490C2__7S3490C1[] = {
  ABISELECT(75376,53300),
  ABISELECT(74768,52888),
  ABISELECT(75664,53532),
  ABISELECT(75280,53248),
  ABISELECT(74744,52872),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S3490C8D1Ev,_ZThn8_N7S3490C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S3490C8D0Ev,_ZThn8_N7S3490C8D0Ev),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C9__A1__7S3490C87S3490C2__7S3490C1[] = {
  ABISELECT(74648,52820),
  ABISELECT(-112,-60),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C9__A1__7S3490C87S3490C2__7S3490C1[] = {
  ABISELECT(74672,52836),
  ABISELECT(-624,-420),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__A1__7S3490C87S3490C2__7S3490C1[] = {
  ABISELECT(-288,-232),
  ABISELECT(-384,-284),
  ABISELECT(-896,-644),
  ABISELECT(-920,-660),
  ABISELECT(-75680,-53540),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A__7S3490C87S3490C2__7S3490C1[] = {
  ABISELECT(72040,50932),
  ABISELECT(-2720,-1948),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C2__7S3490C1[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-74800,-52904),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C2__7S3490C1[] = {
  0,
  ABISELECT(-75312,-53264),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C2__7S3490C1[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-75408,-53316),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C82v4Ev();
extern void ABISELECT(_ZThn16_N7S3490C2D1Ev,_ZThn8_N7S3490C2D1Ev)();
extern void ABISELECT(_ZThn16_N7S3490C2D0Ev,_ZThn8_N7S3490C2D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S3490C8__7S3490C2__7S3490C1[] = {
  ABISELECT(75680,53540),
  ABISELECT(75392,53308),
  ABISELECT(75296,53256),
  ABISELECT(74784,52896),
  ABISELECT(74760,52880),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C82v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S3490C2D1Ev,_ZThn8_N7S3490C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S3490C2D0Ev,_ZThn8_N7S3490C2D0Ev),
};
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZThn32_N7S3490C2D1Ev,_ZThn16_N7S3490C2D1Ev)();
extern void ABISELECT(_ZThn32_N7S3490C2D0Ev,_ZThn16_N7S3490C2D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S3490C97S3490C8__7S3490C2__7S3490C1[] = {
  ABISELECT(75376,53300),
  ABISELECT(74768,52888),
  ABISELECT(75664,53532),
  ABISELECT(75280,53248),
  ABISELECT(74744,52872),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N7S3490C2D1Ev,_ZThn16_N7S3490C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N7S3490C2D0Ev,_ZThn16_N7S3490C2D0Ev),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C97S3490C8__A1__7S3490C2__7S3490C1[] = {
  ABISELECT(74648,52820),
  ABISELECT(-128,-68),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C97S3490C8__A1__7S3490C2__7S3490C1[] = {
  ABISELECT(74672,52836),
  ABISELECT(-640,-428),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__A2__7S3490C2__7S3490C1[] = {
  ABISELECT(-288,-232),
  ABISELECT(-384,-284),
  ABISELECT(-896,-644),
  ABISELECT(-920,-660),
  ABISELECT(-75696,-53548),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C8__A2__7S3490C2__7S3490C1[] = {
  ABISELECT(72040,50932),
  ABISELECT(-2736,-1956),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void _ZN8S3490C10D1Ev();
extern void _ZN8S3490C10D0Ev();
extern void _ZN8S3490C122v7Ev();
extern void _ZN8S3490C122v8Ev();
static  VTBL_ENTRY _tg__ZTV8S3490C10__7S3490C1[] = {
  ABISELECT(64912,45948),
  ABISELECT(64608,45708),
  ABISELECT(64000,45296),
  ABISELECT(64896,45940),
  ABISELECT(64512,45656),
  ABISELECT(63976,45280),
  0,
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN8S3490C10D1Ev,
  (VTBL_ENTRY)&_ZN8S3490C10D0Ev,
  (VTBL_ENTRY)&_ZN8S3490C122v7Ev,
  (VTBL_ENTRY)&_ZN8S3490C122v8Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void _ZN8S3490C11D1Ev();
extern void _ZN8S3490C11D0Ev();
extern void _ZN8S3490C122v7Ev();
extern void _ZN8S3490C122v8Ev();
static  VTBL_ENTRY _tg__ZTV8S3490C118S3490C10__7S3490C1[] = {
  ABISELECT(64608,45708),
  ABISELECT(64000,45296),
  ABISELECT(64896,45940),
  ABISELECT(64512,45656),
  ABISELECT(63976,45280),
  0,
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN8S3490C11D1Ev,
  (VTBL_ENTRY)&_ZN8S3490C11D0Ev,
  (VTBL_ENTRY)&_ZN8S3490C122v7Ev,
  (VTBL_ENTRY)&_ZN8S3490C122v8Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void _ZN8S3490C12D1Ev();
extern void _ZN8S3490C12D0Ev();
extern void _ZN8S3490C122v7Ev();
extern void _ZN8S3490C122v8Ev();
static  VTBL_ENTRY _tg__ZTV8S3490C128S3490C118S3490C10__7S3490C1[] = {
  ABISELECT(64608,45708),
  ABISELECT(64000,45296),
  ABISELECT(64896,45940),
  ABISELECT(64512,45656),
  ABISELECT(63976,45280),
  0,
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN8S3490C12D1Ev,
  (VTBL_ENTRY)&_ZN8S3490C12D0Ev,
  (VTBL_ENTRY)&_ZN8S3490C122v7Ev,
  (VTBL_ENTRY)&_ZN8S3490C122v8Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C9D1Ev();
extern void _ZN7S3490C9D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C98S3490C128S3490C118S3490C10__A2__7S3490C1[] = {
  ABISELECT(64608,45708),
  ABISELECT(64000,45296),
  ABISELECT(64896,45940),
  ABISELECT(64512,45656),
  ABISELECT(63976,45280),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D0Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C98S3490C128S3490C118S3490C10__A4__7S3490C1[] = {
  ABISELECT(63880,45228),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C98S3490C128S3490C118S3490C10__A3__7S3490C1[] = {
  ABISELECT(63904,45244),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__7S3490C77S3490C98S3490C128S3490C118S3490C10__A3__7S3490C1[] = {
  0,
  ABISELECT(-63904,-45244),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A__7S3490C98S3490C128S3490C118S3490C10__A2__7S3490C1[] = {
  ABISELECT(63880,45228),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A__7S3490C98S3490C128S3490C118S3490C10__A2__7S3490C1[] = {
  ABISELECT(63904,45244),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A2__7S3490C98S3490C128S3490C118S3490C10__A2__7S3490C1[] = {
  0,
  ABISELECT(-64512,-45656),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__7S3490C98S3490C128S3490C118S3490C10__A2__7S3490C1[] = {
  ABISELECT(-288,-232),
  ABISELECT(-384,-284),
  ABISELECT(-896,-644),
  ABISELECT(-920,-660),
  ABISELECT(-64896,-45940),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A1__7S3490C98S3490C128S3490C118S3490C10__A2__7S3490C1[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-64000,-45296),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A1__7S3490C98S3490C128S3490C118S3490C10__A2__7S3490C1[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-64608,-45708),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C9__8S3490C128S3490C118S3490C10__7S3490C1[] = {
  ABISELECT(63880,45228),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C9__8S3490C128S3490C118S3490C10__7S3490C1[] = {
  ABISELECT(63904,45244),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A2__8S3490C128S3490C118S3490C10__7S3490C1[] = {
  0,
  ABISELECT(-64512,-45656),
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__8S3490C128S3490C118S3490C10__7S3490C1[] = {
  ABISELECT(-288,-232),
  ABISELECT(-384,-284),
  ABISELECT(-896,-644),
  ABISELECT(-920,-660),
  ABISELECT(-64896,-45940),
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A1__8S3490C128S3490C118S3490C10__7S3490C1[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-64000,-45296),
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A1__8S3490C128S3490C118S3490C10__7S3490C1[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-64608,-45708),
  (VTBL_ENTRY)&(_ZTI8S3490C12[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C82v4Ev();
extern void _ZN7S3490C8D1Ev();
extern void _ZN7S3490C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C88S3490C118S3490C10__A1__7S3490C1[] = {
  ABISELECT(61616,43608),
  ABISELECT(61328,43376),
  ABISELECT(61232,43324),
  ABISELECT(60720,42964),
  ABISELECT(60696,42948),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C82v4Ev,
  (VTBL_ENTRY)&_ZN7S3490C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C8D0Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C37S3490C88S3490C118S3490C10__A3__7S3490C1[] = {
  ABISELECT(61328,43376),
  ABISELECT(61232,43324),
  ABISELECT(60720,42964),
  ABISELECT(60696,42948),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C37S3490C88S3490C118S3490C10__A3__7S3490C1[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-60720,-42964),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C37S3490C88S3490C118S3490C10__A3__7S3490C1[] = {
  0,
  ABISELECT(-61232,-43324),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C37S3490C88S3490C118S3490C10__A3__7S3490C1[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-61328,-43376),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C9D1Ev();
extern void _ZN7S3490C9D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C97S3490C88S3490C118S3490C10__A3__7S3490C1[] = {
  ABISELECT(61312,43368),
  ABISELECT(60704,42956),
  ABISELECT(61600,43600),
  ABISELECT(61216,43316),
  ABISELECT(60680,42940),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D0Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C97S3490C88S3490C118S3490C10__A5__7S3490C1[] = {
  ABISELECT(60584,42888),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C97S3490C88S3490C118S3490C10__A4__7S3490C1[] = {
  ABISELECT(60608,42904),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__7S3490C77S3490C97S3490C88S3490C118S3490C10__A4__7S3490C1[] = {
  0,
  ABISELECT(-60608,-42904),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A__7S3490C97S3490C88S3490C118S3490C10__A3__7S3490C1[] = {
  ABISELECT(60584,42888),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A__7S3490C97S3490C88S3490C118S3490C10__A3__7S3490C1[] = {
  ABISELECT(60608,42904),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A2__7S3490C97S3490C88S3490C118S3490C10__A3__7S3490C1[] = {
  0,
  ABISELECT(-61216,-43316),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__7S3490C97S3490C88S3490C118S3490C10__A3__7S3490C1[] = {
  ABISELECT(-288,-232),
  ABISELECT(-384,-284),
  ABISELECT(-896,-644),
  ABISELECT(-920,-660),
  ABISELECT(-61600,-43600),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A1__7S3490C97S3490C88S3490C118S3490C10__A3__7S3490C1[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-60704,-42956),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A1__7S3490C97S3490C88S3490C118S3490C10__A3__7S3490C1[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-61312,-43368),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C88S3490C118S3490C10__A6__7S3490C1[] = {
  ABISELECT(57976,41000),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C88S3490C118S3490C10__A1__7S3490C1[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-60720,-42964),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C88S3490C118S3490C10__A1__7S3490C1[] = {
  0,
  ABISELECT(-61232,-43324),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C88S3490C118S3490C10__A1__7S3490C1[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-61328,-43376),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZThn16_N7S3490C8D1Ev,_ZThn8_N7S3490C8D1Ev)();
extern void ABISELECT(_ZThn16_N7S3490C8D0Ev,_ZThn8_N7S3490C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S3490C9__7S3490C88S3490C118S3490C10__A1__7S3490C1[] = {
  ABISELECT(61312,43368),
  ABISELECT(60704,42956),
  ABISELECT(61600,43600),
  ABISELECT(61216,43316),
  ABISELECT(60680,42940),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S3490C8D1Ev,_ZThn8_N7S3490C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S3490C8D0Ev,_ZThn8_N7S3490C8D0Ev),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C9__A1__7S3490C88S3490C118S3490C10__A1__7S3490C1[] = {
  ABISELECT(60584,42888),
  ABISELECT(-112,-60),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C9__A1__7S3490C88S3490C118S3490C10__A1__7S3490C1[] = {
  ABISELECT(60608,42904),
  ABISELECT(-624,-420),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__A1__7S3490C88S3490C118S3490C10__A1__7S3490C1[] = {
  ABISELECT(-288,-232),
  ABISELECT(-384,-284),
  ABISELECT(-896,-644),
  ABISELECT(-920,-660),
  ABISELECT(-61616,-43608),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A__7S3490C88S3490C118S3490C10__A1__7S3490C1[] = {
  ABISELECT(57976,41000),
  ABISELECT(-2720,-1948),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__8S3490C118S3490C10__7S3490C1[] = {
  ABISELECT(-288,-232),
  ABISELECT(-384,-284),
  ABISELECT(-896,-644),
  ABISELECT(-920,-660),
  ABISELECT(-64896,-45940),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__8S3490C118S3490C10__7S3490C1[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-64000,-45296),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__8S3490C118S3490C10__7S3490C1[] = {
  0,
  ABISELECT(-64512,-45656),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__8S3490C118S3490C10__7S3490C1[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-64608,-45708),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C98S3490C12__A1__8S3490C118S3490C10__7S3490C1[] = {
  ABISELECT(63880,45228),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C98S3490C12__A1__8S3490C118S3490C10__7S3490C1[] = {
  ABISELECT(63904,45244),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C82v4Ev();
extern void ABISELECT(_ZThn3280_N8S3490C11D1Ev,_ZThn2332_N8S3490C11D1Ev)();
extern void ABISELECT(_ZThn3280_N8S3490C11D0Ev,_ZThn2332_N8S3490C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S3490C8__8S3490C118S3490C10__7S3490C1[] = {
  ABISELECT(61616,43608),
  ABISELECT(61328,43376),
  ABISELECT(61232,43324),
  ABISELECT(60720,42964),
  ABISELECT(60696,42948),
  ABISELECT(-3280,-2332),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C82v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn3280_N8S3490C11D1Ev,_ZThn2332_N8S3490C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn3280_N8S3490C11D0Ev,_ZThn2332_N8S3490C11D0Ev),
};
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZThn3296_N8S3490C11D1Ev,_ZThn2340_N8S3490C11D1Ev)();
extern void ABISELECT(_ZThn3296_N8S3490C11D0Ev,_ZThn2340_N8S3490C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S3490C97S3490C8__A1__8S3490C118S3490C10__7S3490C1[] = {
  ABISELECT(61312,43368),
  ABISELECT(60704,42956),
  ABISELECT(61600,43600),
  ABISELECT(61216,43316),
  ABISELECT(60680,42940),
  ABISELECT(-3296,-2340),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn3296_N8S3490C11D1Ev,_ZThn2340_N8S3490C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn3296_N8S3490C11D0Ev,_ZThn2340_N8S3490C11D0Ev),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C97S3490C8__A2__8S3490C118S3490C10__7S3490C1[] = {
  ABISELECT(60584,42888),
  ABISELECT(-3392,-2392),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C97S3490C8__A2__8S3490C118S3490C10__7S3490C1[] = {
  ABISELECT(60608,42904),
  ABISELECT(-3904,-2752),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C8__A3__8S3490C118S3490C10__7S3490C1[] = {
  ABISELECT(57976,41000),
  ABISELECT(-6000,-4280),
  (VTBL_ENTRY)&(_ZTI8S3490C11[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C2D1Ev();
extern void _ZN7S3490C2D0Ev();
extern void _ZN7S3490C22v5Ev();
extern void _ZN7S3490C22v6Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C28S3490C10__A1__7S3490C1[] = {
  ABISELECT(52752,37332),
  ABISELECT(52464,37100),
  ABISELECT(52368,37048),
  ABISELECT(51856,36688),
  ABISELECT(51832,36672),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C2D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C2D0Ev,
  (VTBL_ENTRY)&_ZN7S3490C22v5Ev,
  (VTBL_ENTRY)&_ZN7S3490C22v6Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C37S3490C28S3490C10__A4__7S3490C1[] = {
  ABISELECT(52464,37100),
  ABISELECT(52368,37048),
  ABISELECT(51856,36688),
  ABISELECT(51832,36672),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C37S3490C28S3490C10__A4__7S3490C1[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-51856,-36688),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C37S3490C28S3490C10__A4__7S3490C1[] = {
  0,
  ABISELECT(-52368,-37048),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C37S3490C28S3490C10__A4__7S3490C1[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-52464,-37100),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C82v4Ev();
extern void _ZN7S3490C8D1Ev();
extern void _ZN7S3490C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C87S3490C28S3490C10__A2__7S3490C1[] = {
  ABISELECT(52736,37324),
  ABISELECT(52448,37092),
  ABISELECT(52352,37040),
  ABISELECT(51840,36680),
  ABISELECT(51816,36664),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C82v4Ev,
  (VTBL_ENTRY)&_ZN7S3490C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C8D0Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C37S3490C87S3490C28S3490C10__A5__7S3490C1[] = {
  ABISELECT(52448,37092),
  ABISELECT(52352,37040),
  ABISELECT(51840,36680),
  ABISELECT(51816,36664),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C37S3490C87S3490C28S3490C10__A5__7S3490C1[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-51840,-36680),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C37S3490C87S3490C28S3490C10__A5__7S3490C1[] = {
  0,
  ABISELECT(-52352,-37040),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C37S3490C87S3490C28S3490C10__A5__7S3490C1[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-52448,-37092),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C9D1Ev();
extern void _ZN7S3490C9D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C97S3490C87S3490C28S3490C10__A4__7S3490C1[] = {
  ABISELECT(52432,37084),
  ABISELECT(51824,36672),
  ABISELECT(52720,37316),
  ABISELECT(52336,37032),
  ABISELECT(51800,36656),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D0Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C97S3490C87S3490C28S3490C10__A7__7S3490C1[] = {
  ABISELECT(51704,36604),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C97S3490C87S3490C28S3490C10__A5__7S3490C1[] = {
  ABISELECT(51728,36620),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__7S3490C77S3490C97S3490C87S3490C28S3490C10__A5__7S3490C1[] = {
  0,
  ABISELECT(-51728,-36620),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A__7S3490C97S3490C87S3490C28S3490C10__A4__7S3490C1[] = {
  ABISELECT(51704,36604),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A__7S3490C97S3490C87S3490C28S3490C10__A4__7S3490C1[] = {
  ABISELECT(51728,36620),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A2__7S3490C97S3490C87S3490C28S3490C10__A4__7S3490C1[] = {
  0,
  ABISELECT(-52336,-37032),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__7S3490C97S3490C87S3490C28S3490C10__A4__7S3490C1[] = {
  ABISELECT(-288,-232),
  ABISELECT(-384,-284),
  ABISELECT(-896,-644),
  ABISELECT(-920,-660),
  ABISELECT(-52720,-37316),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A1__7S3490C97S3490C87S3490C28S3490C10__A4__7S3490C1[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-51824,-36672),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A1__7S3490C97S3490C87S3490C28S3490C10__A4__7S3490C1[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-52432,-37084),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C87S3490C28S3490C10__A8__7S3490C1[] = {
  ABISELECT(49096,34716),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C87S3490C28S3490C10__A2__7S3490C1[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-51840,-36680),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C87S3490C28S3490C10__A2__7S3490C1[] = {
  0,
  ABISELECT(-52352,-37040),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C87S3490C28S3490C10__A2__7S3490C1[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-52448,-37092),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZThn16_N7S3490C8D1Ev,_ZThn8_N7S3490C8D1Ev)();
extern void ABISELECT(_ZThn16_N7S3490C8D0Ev,_ZThn8_N7S3490C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S3490C9__7S3490C87S3490C28S3490C10__A2__7S3490C1[] = {
  ABISELECT(52432,37084),
  ABISELECT(51824,36672),
  ABISELECT(52720,37316),
  ABISELECT(52336,37032),
  ABISELECT(51800,36656),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S3490C8D1Ev,_ZThn8_N7S3490C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S3490C8D0Ev,_ZThn8_N7S3490C8D0Ev),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C9__A1__7S3490C87S3490C28S3490C10__A2__7S3490C1[] = {
  ABISELECT(51704,36604),
  ABISELECT(-112,-60),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C9__A1__7S3490C87S3490C28S3490C10__A2__7S3490C1[] = {
  ABISELECT(51728,36620),
  ABISELECT(-624,-420),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__A1__7S3490C87S3490C28S3490C10__A2__7S3490C1[] = {
  ABISELECT(-288,-232),
  ABISELECT(-384,-284),
  ABISELECT(-896,-644),
  ABISELECT(-920,-660),
  ABISELECT(-52736,-37324),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A__7S3490C87S3490C28S3490C10__A2__7S3490C1[] = {
  ABISELECT(49096,34716),
  ABISELECT(-2720,-1948),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C28S3490C10__A1__7S3490C1[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-51856,-36688),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C28S3490C10__A1__7S3490C1[] = {
  0,
  ABISELECT(-52368,-37048),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C28S3490C10__A1__7S3490C1[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-52464,-37100),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C82v4Ev();
extern void ABISELECT(_ZThn16_N7S3490C2D1Ev,_ZThn8_N7S3490C2D1Ev)();
extern void ABISELECT(_ZThn16_N7S3490C2D0Ev,_ZThn8_N7S3490C2D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S3490C8__7S3490C28S3490C10__A1__7S3490C1[] = {
  ABISELECT(52736,37324),
  ABISELECT(52448,37092),
  ABISELECT(52352,37040),
  ABISELECT(51840,36680),
  ABISELECT(51816,36664),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C82v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S3490C2D1Ev,_ZThn8_N7S3490C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S3490C2D0Ev,_ZThn8_N7S3490C2D0Ev),
};
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZThn32_N7S3490C2D1Ev,_ZThn16_N7S3490C2D1Ev)();
extern void ABISELECT(_ZThn32_N7S3490C2D0Ev,_ZThn16_N7S3490C2D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S3490C97S3490C8__7S3490C28S3490C10__A1__7S3490C1[] = {
  ABISELECT(52432,37084),
  ABISELECT(51824,36672),
  ABISELECT(52720,37316),
  ABISELECT(52336,37032),
  ABISELECT(51800,36656),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N7S3490C2D1Ev,_ZThn16_N7S3490C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N7S3490C2D0Ev,_ZThn16_N7S3490C2D0Ev),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C97S3490C8__A1__7S3490C28S3490C10__A1__7S3490C1[] = {
  ABISELECT(51704,36604),
  ABISELECT(-128,-68),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C97S3490C8__A1__7S3490C28S3490C10__A1__7S3490C1[] = {
  ABISELECT(51728,36620),
  ABISELECT(-640,-428),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__A2__7S3490C28S3490C10__A1__7S3490C1[] = {
  ABISELECT(-288,-232),
  ABISELECT(-384,-284),
  ABISELECT(-896,-644),
  ABISELECT(-920,-660),
  ABISELECT(-52752,-37332),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C8__A2__7S3490C28S3490C10__A1__7S3490C1[] = {
  ABISELECT(49096,34716),
  ABISELECT(-2736,-1956),
  (VTBL_ENTRY)&(_ZTI7S3490C2[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZTv0_n72_N8S3490C10D1Ev,_ZTv0_n36_N8S3490C10D1Ev)();
extern void ABISELECT(_ZThn64912_N8S3490C10D1Ev,_ZThn45948_N8S3490C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S3490C10D0Ev,_ZTv0_n36_N8S3490C10D0Ev)();
extern void ABISELECT(_ZThn64912_N8S3490C10D0Ev,_ZThn45948_N8S3490C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S3490C9__8S3490C10__7S3490C1[] = {
  ABISELECT(608,412),
  ABISELECT(-64912,-45948),
  0,
  ABISELECT(-304,-240),
  ABISELECT(-912,-652),
  ABISELECT(-16,-8),
  ABISELECT(-400,-292),
  ABISELECT(-936,-668),
  ABISELECT(-64912,-45948),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S3490C10D1Ev,_ZTv0_n36_N8S3490C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S3490C10D0Ev,_ZTv0_n36_N8S3490C10D0Ev),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C9__8S3490C10__7S3490C1[] = {
  ABISELECT(-1032,-720),
  ABISELECT(-65008,-46000),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C9__8S3490C10__7S3490C1[] = {
  ABISELECT(-1008,-704),
  ABISELECT(-65520,-46360),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A2__8S3490C10__7S3490C1[] = {
  0,
  ABISELECT(-64512,-45656),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__8S3490C10__7S3490C1[] = {
  ABISELECT(-288,-232),
  ABISELECT(-384,-284),
  ABISELECT(-896,-644),
  ABISELECT(-920,-660),
  ABISELECT(-64896,-45940),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A1__8S3490C10__7S3490C1[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-64000,-45296),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A1__8S3490C10__7S3490C1[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(-64608,-45708),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C98S3490C128S3490C11__A2__8S3490C10__7S3490C1[] = {
  ABISELECT(63880,45228),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C98S3490C128S3490C11__A2__8S3490C10__7S3490C1[] = {
  ABISELECT(63904,45244),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C82v4Ev();
extern void ABISELECT(_ZThn3280_N8S3490C10D1Ev,_ZThn2332_N8S3490C10D1Ev)();
extern void ABISELECT(_ZThn3280_N8S3490C10D0Ev,_ZThn2332_N8S3490C10D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S3490C88S3490C11__8S3490C10__7S3490C1[] = {
  ABISELECT(61616,43608),
  ABISELECT(61328,43376),
  ABISELECT(61232,43324),
  ABISELECT(60720,42964),
  ABISELECT(60696,42948),
  ABISELECT(-3280,-2332),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C82v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn3280_N8S3490C10D1Ev,_ZThn2332_N8S3490C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn3280_N8S3490C10D0Ev,_ZThn2332_N8S3490C10D0Ev),
};
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZThn3296_N8S3490C10D1Ev,_ZThn2340_N8S3490C10D1Ev)();
extern void ABISELECT(_ZThn3296_N8S3490C10D0Ev,_ZThn2340_N8S3490C10D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S3490C97S3490C88S3490C11__A2__8S3490C10__7S3490C1[] = {
  ABISELECT(61312,43368),
  ABISELECT(60704,42956),
  ABISELECT(61600,43600),
  ABISELECT(61216,43316),
  ABISELECT(60680,42940),
  ABISELECT(-3296,-2340),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn3296_N8S3490C10D1Ev,_ZThn2340_N8S3490C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn3296_N8S3490C10D0Ev,_ZThn2340_N8S3490C10D0Ev),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C97S3490C88S3490C11__A3__8S3490C10__7S3490C1[] = {
  ABISELECT(60584,42888),
  ABISELECT(-3392,-2392),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C97S3490C88S3490C11__A3__8S3490C10__7S3490C1[] = {
  ABISELECT(60608,42904),
  ABISELECT(-3904,-2752),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C88S3490C11__A4__8S3490C10__7S3490C1[] = {
  ABISELECT(57976,41000),
  ABISELECT(-6000,-4280),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void ABISELECT(_ZThn12144_N8S3490C10D1Ev,_ZThn8608_N8S3490C10D1Ev)();
extern void ABISELECT(_ZThn12144_N8S3490C10D0Ev,_ZThn8608_N8S3490C10D0Ev)();
extern void _ZN7S3490C22v5Ev();
extern void _ZN7S3490C22v6Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C2__8S3490C10__7S3490C1[] = {
  ABISELECT(52752,37332),
  ABISELECT(52464,37100),
  ABISELECT(52368,37048),
  ABISELECT(51856,36688),
  ABISELECT(51832,36672),
  ABISELECT(-12144,-8608),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn12144_N8S3490C10D1Ev,_ZThn8608_N8S3490C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn12144_N8S3490C10D0Ev,_ZThn8608_N8S3490C10D0Ev),
  (VTBL_ENTRY)&_ZN7S3490C22v5Ev,
  (VTBL_ENTRY)&_ZN7S3490C22v6Ev,
};
extern void _ZN7S3490C82v4Ev();
extern void ABISELECT(_ZThn12160_N8S3490C10D1Ev,_ZThn8616_N8S3490C10D1Ev)();
extern void ABISELECT(_ZThn12160_N8S3490C10D0Ev,_ZThn8616_N8S3490C10D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S3490C87S3490C2__A1__8S3490C10__7S3490C1[] = {
  ABISELECT(52736,37324),
  ABISELECT(52448,37092),
  ABISELECT(52352,37040),
  ABISELECT(51840,36680),
  ABISELECT(51816,36664),
  ABISELECT(-12160,-8616),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C82v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn12160_N8S3490C10D1Ev,_ZThn8616_N8S3490C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn12160_N8S3490C10D0Ev,_ZThn8616_N8S3490C10D0Ev),
};
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZThn12176_N8S3490C10D1Ev,_ZThn8624_N8S3490C10D1Ev)();
extern void ABISELECT(_ZThn12176_N8S3490C10D0Ev,_ZThn8624_N8S3490C10D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S3490C97S3490C87S3490C2__A3__8S3490C10__7S3490C1[] = {
  ABISELECT(52432,37084),
  ABISELECT(51824,36672),
  ABISELECT(52720,37316),
  ABISELECT(52336,37032),
  ABISELECT(51800,36656),
  ABISELECT(-12176,-8624),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn12176_N8S3490C10D1Ev,_ZThn8624_N8S3490C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn12176_N8S3490C10D0Ev,_ZThn8624_N8S3490C10D0Ev),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C97S3490C87S3490C2__A5__8S3490C10__7S3490C1[] = {
  ABISELECT(51704,36604),
  ABISELECT(-12272,-8676),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C97S3490C87S3490C2__A4__8S3490C10__7S3490C1[] = {
  ABISELECT(51728,36620),
  ABISELECT(-12784,-9036),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C87S3490C2__A6__8S3490C10__7S3490C1[] = {
  ABISELECT(49096,34716),
  ABISELECT(-14880,-10564),
  (VTBL_ENTRY)&(_ZTI8S3490C10[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C1[] = {
  ABISELECT(-24,-16),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C1[] = {
  ABISELECT(-96,-52),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__7S3490C7__7S3490C1[] = {
  0,
  ABISELECT(96,52),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__A2__7S3490C1[] = {
  ABISELECT(-288,-232),
  ABISELECT(-384,-284),
  ABISELECT(-896,-644),
  ABISELECT(-920,-660),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C3__A2__7S3490C1[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(896,644),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C3__A2__7S3490C1[] = {
  0,
  ABISELECT(384,284),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C3__A2__7S3490C1[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(288,232),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C9D1Ev();
extern void _ZN7S3490C9D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C9__A1__7S3490C1[] = {
  ABISELECT(-304,-240),
  ABISELECT(-912,-652),
  ABISELECT(-16,-8),
  ABISELECT(-400,-292),
  ABISELECT(-936,-668),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D0Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C9__A3__7S3490C1[] = {
  ABISELECT(-1032,-720),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C9__A2__7S3490C1[] = {
  ABISELECT(-1008,-704),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__7S3490C77S3490C9__A2__7S3490C1[] = {
  0,
  ABISELECT(1008,704),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A__7S3490C9__A1__7S3490C1[] = {
  ABISELECT(-1032,-720),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A__7S3490C9__A1__7S3490C1[] = {
  ABISELECT(-1008,-704),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A2__7S3490C9__A1__7S3490C1[] = {
  0,
  ABISELECT(400,292),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__7S3490C9__A1__7S3490C1[] = {
  ABISELECT(-288,-232),
  ABISELECT(-384,-284),
  ABISELECT(-896,-644),
  ABISELECT(-920,-660),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A1__7S3490C9__A1__7S3490C1[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(912,652),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A1__7S3490C9__A1__7S3490C1[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(304,240),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void _ZN8S3490C15D1Ev();
extern void _ZN8S3490C15D0Ev();
static  VTBL_ENTRY _tg__ZTV8S3490C15__7S3490C1[] = {
  ABISELECT(-2720,-1948),
  ABISELECT(-3008,-2180),
  ABISELECT(-3104,-2232),
  ABISELECT(-3616,-2592),
  ABISELECT(832,604),
  ABISELECT(-3640,-2608),
  0,
  (VTBL_ENTRY)&(_ZTI8S3490C15[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN8S3490C15D1Ev,
  (VTBL_ENTRY)&_ZN8S3490C15D0Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C58S3490C15__A11__7S3490C1[] = {
  ABISELECT(-3640,-2608),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C78S3490C15__A7__7S3490C1[] = {
  ABISELECT(-3616,-2592),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__7S3490C78S3490C15__A7__7S3490C1[] = {
  0,
  ABISELECT(3616,2592),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C38S3490C15__A7__7S3490C1[] = {
  ABISELECT(-3808,-2772),
  ABISELECT(-3904,-2824),
  ABISELECT(-4416,-3184),
  ABISELECT(-4440,-3200),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C38S3490C15__A7__7S3490C1[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(4416,3184),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C38S3490C15__A7__7S3490C1[] = {
  0,
  ABISELECT(3904,2824),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C38S3490C15__A7__7S3490C1[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(3808,2772),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C82v4Ev();
extern void ABISELECT(_ZTv0_n72_N8S3490C15D1Ev,_ZTv0_n36_N8S3490C15D1Ev)();
extern void ABISELECT(_ZThn832_N8S3490C15D1Ev,_ZThn604_N8S3490C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S3490C15D0Ev,_ZTv0_n36_N8S3490C15D0Ev)();
extern void ABISELECT(_ZThn832_N8S3490C15D0Ev,_ZThn604_N8S3490C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S3490C8__8S3490C15__7S3490C1[] = {
  ABISELECT(624,420),
  ABISELECT(16,8),
  ABISELECT(-832,-604),
  0,
  ABISELECT(-3552,-2552),
  ABISELECT(-3840,-2784),
  ABISELECT(-3936,-2836),
  ABISELECT(-4448,-3196),
  ABISELECT(-4472,-3212),
  ABISELECT(-832,-604),
  (VTBL_ENTRY)&(_ZTI8S3490C15[0]),
  (VTBL_ENTRY)&_ZN7S3490C82v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S3490C15D1Ev,_ZTv0_n36_N8S3490C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S3490C15D0Ev,_ZTv0_n36_N8S3490C15D0Ev),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__8S3490C15__7S3490C1[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(3616,2592),
  (VTBL_ENTRY)&(_ZTI8S3490C15[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__8S3490C15__7S3490C1[] = {
  0,
  ABISELECT(3104,2232),
  (VTBL_ENTRY)&(_ZTI8S3490C15[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__8S3490C15__7S3490C1[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(3008,2180),
  (VTBL_ENTRY)&(_ZTI8S3490C15[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZTvn16_n72_N8S3490C15D1Ev,_ZTvn8_n36_N8S3490C15D1Ev)();
extern void ABISELECT(_ZTvn16_n72_N8S3490C15D0Ev,_ZTvn8_n36_N8S3490C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S3490C97S3490C8__8S3490C15__7S3490C1[] = {
  ABISELECT(-3856,-2792),
  ABISELECT(-4464,-3204),
  ABISELECT(-3568,-2560),
  ABISELECT(-3952,-2844),
  ABISELECT(-4488,-3220),
  ABISELECT(-848,-612),
  (VTBL_ENTRY)&(_ZTI8S3490C15[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n72_N8S3490C15D1Ev,_ZTvn8_n36_N8S3490C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n72_N8S3490C15D0Ev,_ZTvn8_n36_N8S3490C15D0Ev),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C97S3490C8__A1__8S3490C15__7S3490C1[] = {
  ABISELECT(-4584,-3272),
  ABISELECT(-944,-664),
  (VTBL_ENTRY)&(_ZTI8S3490C15[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C97S3490C8__A1__8S3490C15__7S3490C1[] = {
  ABISELECT(-4560,-3256),
  ABISELECT(-1456,-1024),
  (VTBL_ENTRY)&(_ZTI8S3490C15[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__A1__8S3490C15__7S3490C1[] = {
  ABISELECT(-288,-232),
  ABISELECT(-384,-284),
  ABISELECT(-896,-644),
  ABISELECT(-920,-660),
  ABISELECT(2720,1948),
  (VTBL_ENTRY)&(_ZTI8S3490C15[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C8__A2__8S3490C15__7S3490C1[] = {
  ABISELECT(-7192,-5160),
  ABISELECT(-3552,-2552),
  (VTBL_ENTRY)&(_ZTI8S3490C15[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C67S3490C8__A5__8S3490C15__7S3490C1[] = {
  ABISELECT(-4064,-2912),
  (VTBL_ENTRY)&(_ZTI8S3490C15[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A__8S3490C15__7S3490C1[] = {
  ABISELECT(-3616,-2592),
  ABISELECT(-512,-360),
  (VTBL_ENTRY)&(_ZTI8S3490C15[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__A__8S3490C15__7S3490C1[] = {
  ABISELECT(-3808,-2772),
  ABISELECT(-3904,-2824),
  ABISELECT(-4416,-3184),
  ABISELECT(-4440,-3200),
  ABISELECT(-800,-592),
  (VTBL_ENTRY)&(_ZTI8S3490C15[0]),
};
extern void _ZN7S3490C82v4Ev();
extern void _ZN7S3490C8D1Ev();
extern void _ZN7S3490C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C8__A3__7S3490C1[] = {
  ABISELECT(-3552,-2552),
  ABISELECT(-3840,-2784),
  ABISELECT(-3936,-2836),
  ABISELECT(-4448,-3196),
  ABISELECT(-4472,-3212),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C82v4Ev,
  (VTBL_ENTRY)&_ZN7S3490C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C8D0Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C37S3490C8__A6__7S3490C1[] = {
  ABISELECT(-3840,-2784),
  ABISELECT(-3936,-2836),
  ABISELECT(-4448,-3196),
  ABISELECT(-4472,-3212),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C37S3490C8__A6__7S3490C1[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(4448,3196),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C37S3490C8__A6__7S3490C1[] = {
  0,
  ABISELECT(3936,2836),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C37S3490C8__A6__7S3490C1[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(3840,2784),
  (VTBL_ENTRY)&(_ZTI7S3490C3[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void _ZN7S3490C9D1Ev();
extern void _ZN7S3490C9D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C97S3490C8__A5__7S3490C1[] = {
  ABISELECT(-3856,-2792),
  ABISELECT(-4464,-3204),
  ABISELECT(-3568,-2560),
  ABISELECT(-3952,-2844),
  ABISELECT(-4488,-3220),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D1Ev,
  (VTBL_ENTRY)&_ZN7S3490C9D0Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C97S3490C8__A9__7S3490C1[] = {
  ABISELECT(-4584,-3272),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C97S3490C8__A6__7S3490C1[] = {
  ABISELECT(-4560,-3256),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__7S3490C77S3490C97S3490C8__A6__7S3490C1[] = {
  0,
  ABISELECT(4560,3256),
  (VTBL_ENTRY)&(_ZTI7S3490C7[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A__7S3490C97S3490C8__A5__7S3490C1[] = {
  ABISELECT(-4584,-3272),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A__7S3490C97S3490C8__A5__7S3490C1[] = {
  ABISELECT(-4560,-3256),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A2__7S3490C97S3490C8__A5__7S3490C1[] = {
  0,
  ABISELECT(3952,2844),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__7S3490C97S3490C8__A5__7S3490C1[] = {
  ABISELECT(-288,-232),
  ABISELECT(-384,-284),
  ABISELECT(-896,-644),
  ABISELECT(-920,-660),
  ABISELECT(3568,2560),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A1__7S3490C97S3490C8__A5__7S3490C1[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(4464,3204),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__A1__7S3490C97S3490C8__A5__7S3490C1[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(3856,2792),
  (VTBL_ENTRY)&(_ZTI7S3490C9[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C8__A10__7S3490C1[] = {
  ABISELECT(-7192,-5160),
  0,
  (VTBL_ENTRY)&(_ZTI7S3490C5[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__7S3490C8__A3__7S3490C1[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(4448,3196),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C6__A1__7S3490C8__A3__7S3490C1[] = {
  0,
  ABISELECT(3936,2836),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C7__7S3490C8__A3__7S3490C1[] = {
  0,
  ABISELECT(-96,-52),
  ABISELECT(3840,2784),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
extern void _ZN7S3490C62v2Ev();
extern void ABISELECT(_ZThn16_N7S3490C8D1Ev,_ZThn8_N7S3490C8D1Ev)();
extern void ABISELECT(_ZThn16_N7S3490C8D0Ev,_ZThn8_N7S3490C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S3490C9__7S3490C8__A3__7S3490C1[] = {
  ABISELECT(-3856,-2792),
  ABISELECT(-4464,-3204),
  ABISELECT(-3568,-2560),
  ABISELECT(-3952,-2844),
  ABISELECT(-4488,-3220),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S3490C8D1Ev,_ZThn8_N7S3490C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S3490C8D0Ev,_ZThn8_N7S3490C8D0Ev),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C57S3490C9__A1__7S3490C8__A3__7S3490C1[] = {
  ABISELECT(-4584,-3272),
  ABISELECT(-112,-60),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
extern void _ZN7S3490C72v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C77S3490C9__A1__7S3490C8__A3__7S3490C1[] = {
  ABISELECT(-4560,-3256),
  ABISELECT(-624,-420),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C72v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S3490C3__A1__7S3490C8__A3__7S3490C1[] = {
  ABISELECT(-288,-232),
  ABISELECT(-384,-284),
  ABISELECT(-896,-644),
  ABISELECT(-920,-660),
  ABISELECT(3552,2552),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
};
extern void _ZN7S3490C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S3490C5__A__7S3490C8__A3__7S3490C1[] = {
  ABISELECT(-7192,-5160),
  ABISELECT(-2720,-1948),
  (VTBL_ENTRY)&(_ZTI7S3490C8[0]),
  (VTBL_ENTRY)&_ZN7S3490C62v2Ev,
};
static  VTT_ENTRY vtt_S3490C1[] = {
  {&(_ZTV7S3490C1[10]),  10,256},
  {&(_tg__ZTV7S3490C2__7S3490C1[7]),  7,11},
  {&(_tg__ZTV7S3490C37S3490C2__7S3490C1[6]),  6,6},
  {&(_tg__ZTV7S3490C5__7S3490C37S3490C2__7S3490C1[4]),  4,5},
  {&(_tg__ZTV7S3490C6__A1__7S3490C37S3490C2__7S3490C1[3]),  3,4},
  {&(_tg__ZTV7S3490C7__7S3490C37S3490C2__7S3490C1[4]),  4,5},
  {&(_tg__ZTV7S3490C87S3490C2__7S3490C1[7]),  7,10},
  {&(_tg__ZTV7S3490C37S3490C87S3490C2__A1__7S3490C1[6]),  6,6},
  {&(_tg__ZTV7S3490C5__7S3490C37S3490C87S3490C2__A1__7S3490C1[4]),  4,5},
  {&(_tg__ZTV7S3490C6__A1__7S3490C37S3490C87S3490C2__A1__7S3490C1[3]),  3,4},
  {&(_tg__ZTV7S3490C7__7S3490C37S3490C87S3490C2__A1__7S3490C1[4]),  4,5},
  {&(_tg__ZTV7S3490C97S3490C87S3490C2__7S3490C1[7]),  7,10},
  {&(_tg__ZTV7S3490C57S3490C97S3490C87S3490C2__A1__7S3490C1[3]),  3,4},
  {&(_tg__ZTV7S3490C77S3490C97S3490C87S3490C2__A1__7S3490C1[3]),  3,4},
  {&(_tg__ZTV7S3490C6__7S3490C77S3490C97S3490C87S3490C2__A1__7S3490C1[3]),  3,4},
  {&(_tg__ZTV7S3490C5__A__7S3490C97S3490C87S3490C2__7S3490C1[3]),  3,4},
  {&(_tg__ZTV7S3490C7__A__7S3490C97S3490C87S3490C2__7S3490C1[3]),  3,4},
  {&(_tg__ZTV7S3490C6__A2__7S3490C97S3490C87S3490C2__7S3490C1[3]),  3,4},
  {&(_tg__ZTV7S3490C3__7S3490C97S3490C87S3490C2__7S3490C1[6]),  6,6},
  {&(_tg__ZTV7S3490C5__A1__7S3490C97S3490C87S3490C2__7S3490C1[4]),  4,5},
  {&(_tg__ZTV7S3490C7__A1__7S3490C97S3490C87S3490C2__7S3490C1[4]),  4,5},
  {&(_tg__ZTV7S3490C57S3490C87S3490C2__A2__7S3490C1[3]),  3,4},
  {&(_tg__ZTV7S3490C5__7S3490C87S3490C2__7S3490C1[4]),  4,5},
  {&(_tg__ZTV7S3490C6__A1__7S3490C87S3490C2__7S3490C1[3]),  3,4},
  {&(_tg__ZTV7S3490C7__7S3490C87S3490C2__7S3490C1[4]),  4,5},
  {&(_tg__ZTV7S3490C9__7S3490C87S3490C2__7S3490C1[7]),  7,10},
  {&(_tg__ZTV7S3490C57S3490C9__A1__7S3490C87S3490C2__7S3490C1[3]),  3,4},
  {&(_tg__ZTV7S3490C77S3490C9__A1__7S3490C87S3490C2__7S3490C1[3]),  3,4},
  {&(_tg__ZTV7S3490C3__A1__7S3490C87S3490C2__7S3490C1[6]),  6,6},
  {&(_tg__ZTV7S3490C5__A__7S3490C87S3490C2__7S3490C1[3]),  3,4},
  {&(_tg__ZTV7S3490C5__7S3490C2__7S3490C1[4]),  4,5},
  {&(_tg__ZTV7S3490C6__A1__7S3490C2__7S3490C1[3]),  3,4},
  {&(_tg__ZTV7S3490C7__7S3490C2__7S3490C1[4]),  4,5},
  {&(_tg__ZTV7S3490C8__7S3490C2__7S3490C1[7]),  7,10},
  {&(_tg__ZTV7S3490C97S3490C8__7S3490C2__7S3490C1[7]),  7,10},
  {&(_tg__ZTV7S3490C57S3490C97S3490C8__A1__7S3490C2__7S3490C1[3]),  3,4},
  {&(_tg__ZTV7S3490C77S3490C97S3490C8__A1__7S3490C2__7S3490C1[3]),  3,4},
  {&(_tg__ZTV7S3490C3__A2__7S3490C2__7S3490C1[6]),  6,6},
  {&(_tg__ZTV7S3490C57S3490C8__A2__7S3490C2__7S3490C1[3]),  3,4},
  {&(_tg__ZTV8S3490C10__7S3490C1[8]),  8,13},
  {&(_tg__ZTV8S3490C118S3490C10__7S3490C1[7]),  7,12},
  {&(_tg__ZTV8S3490C128S3490C118S3490C10__7S3490C1[7]),  7,12},
  {&(_tg__ZTV7S3490C98S3490C128S3490C118S3490C10__A2__7S3490C1[7]),  7,10},
  {&(_tg__ZTV7S3490C57S3490C98S3490C128S3490C118S3490C10__A4__7S3490C1[3]),  3,4},
  {&(_tg__ZTV7S3490C77S3490C98S3490C128S3490C118S3490C10__A3__7S3490C1[3]),  3,4},
  {&(_tg__ZTV7S3490C6__7S3490C77S3490C98S3490C128S3490C118S3490C10__A3__7S3490C1[3]),  3,4},
  {&(_tg__ZTV7S3490C5__A__7S3490C98S3490C128S3490C118S3490C10__A2__7S3490C1[3]),  3,4},
  {&(_tg__ZTV7S3490C7__A__7S3490C98S3490C128S3490C118S3490C10__A2__7S3490C1[3]),  3,4},
  {&(_tg__ZTV7S3490C6__A2__7S3490C98S3490C128S3490C118S3490C10__A2__7S3490C1[3]),  3,4},
  {&(_tg__ZTV7S3490C3__7S3490C98S3490C128S3490C118S3490C10__A2__7S3490C1[6]),  6,6},
  {&(_tg__ZTV7S3490C5__A1__7S3490C98S3490C128S3490C118S3490C10__A2__7S3490C1[4]),  4,5},
  {&(_tg__ZTV7S3490C7__A1__7S3490C98S3490C128S3490C118S3490C10__A2__7S3490C1[4]),  4,5},
  {&(_tg__ZTV7S3490C57S3490C9__8S3490C128S3490C118S3490C10__7S3490C1[3]),  3,4},
  {&(_tg__ZTV7S3490C77S3490C9__8S3490C128S3490C118S3490C10__7S3490C1[3]),  3,4},
  {&(_tg__ZTV7S3490C6__A2__8S3490C128S3490C118S3490C10__7S3490C1[3]),  3,4},
  {&(_tg__ZTV7S3490C3__8S3490C128S3490C118S3490C10__7S3490C1[6]),  6,6},
  {&(_tg__ZTV7S3490C5__A1__8S3490C128S3490C118S3490C10__7S3490C1[4]),  4,5},
  {&(_tg__ZTV7S3490C7__A1__8S3490C128S3490C118S3490C10__7S3490C1[4]),  4,5},
  {&(_tg__ZTV7S3490C88S3490C118S3490C10__A1__7S3490C1[7]),  7,10},
  {&(_tg__ZTV7S3490C37S3490C88S3490C118S3490C10__A3__7S3490C1[6]),  6,6},
  {&(_tg__ZTV7S3490C5__7S3490C37S3490C88S3490C118S34