// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S217C7_nt  {
  int s217c7f0[2];
  void  mf217c7(); // _ZN9S217C7_nt7mf217c7Ev
};
//SIG(-1 S217C7_nt) C1{ m Fi[2]}


void  S217C7_nt ::mf217c7(){}

//skip512 S217C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C6_nt  {
  int s217c6f0;
  __tsi64 s217c6f1;
  void *s217c6f2[4];
  int s217c6f3[2];
  void *s217c6f4;
  ::S217C7_nt s217c6f5;
  void *s217c6f6[2];
  virtual  ~S217C6_nt(); // _ZN9S217C6_ntD1Ev
  virtual void  v4(); // _ZN9S217C6_nt2v4Ev
  virtual void  v5(); // _ZN9S217C6_nt2v5Ev
  virtual void  v6(); // _ZN9S217C6_nt2v6Ev
  virtual void  v7(); // _ZN9S217C6_nt2v7Ev
  virtual void  v8(); // _ZN9S217C6_nt2v8Ev
  virtual void  v9(); // _ZN9S217C6_nt2v9Ev
  virtual void  v10(); // _ZN9S217C6_nt3v10Ev
  virtual void  v11(); // _ZN9S217C6_nt3v11Ev
  virtual void  v12(); // _ZN9S217C6_nt3v12Ev
  virtual void  v13(); // _ZN9S217C6_nt3v13Ev
  virtual void  v14(); // _ZN9S217C6_nt3v14Ev
  virtual void  v15(); // _ZN9S217C6_nt3v15Ev
  virtual void  v16(); // _ZN9S217C6_nt3v16Ev
  virtual void  v17(); // _ZN9S217C6_nt3v17Ev
  virtual void  v18(); // _ZN9S217C6_nt3v18Ev
  virtual void  v19(); // _ZN9S217C6_nt3v19Ev
  virtual void  v20(); // _ZN9S217C6_nt3v20Ev
  virtual void  v21(); // _ZN9S217C6_nt3v21Ev
  virtual void  v22(); // _ZN9S217C6_nt3v22Ev
  virtual void  v23(); // _ZN9S217C6_nt3v23Ev
  virtual void  v24(); // _ZN9S217C6_nt3v24Ev
  virtual void  v25(); // _ZN9S217C6_nt3v25Ev
  virtual void  v26(); // _ZN9S217C6_nt3v26Ev
  virtual void  v27(); // _ZN9S217C6_nt3v27Ev
  virtual void  v28(); // _ZN9S217C6_nt3v28Ev
  virtual void  v29(); // _ZN9S217C6_nt3v29Ev
  virtual void  v30(); // _ZN9S217C6_nt3v30Ev
  virtual void  v31(); // _ZN9S217C6_nt3v31Ev
  virtual void  v32(); // _ZN9S217C6_nt3v32Ev
  virtual void  v33(); // _ZN9S217C6_nt3v33Ev
  virtual void  v34(); // _ZN9S217C6_nt3v34Ev
  virtual void  v35(); // _ZN9S217C6_nt3v35Ev
  virtual void  v36(); // _ZN9S217C6_nt3v36Ev
  virtual void  v37(); // _ZN9S217C6_nt3v37Ev
  virtual void  v38(); // _ZN9S217C6_nt3v38Ev
  virtual void  v39(); // _ZN9S217C6_nt3v39Ev
  virtual void  v40(); // _ZN9S217C6_nt3v40Ev
  virtual void  v41(); // _ZN9S217C6_nt3v41Ev
  virtual void  v42(); // _ZN9S217C6_nt3v42Ev
  virtual void  v43(); // _ZN9S217C6_nt3v43Ev
  virtual void  v44(); // _ZN9S217C6_nt3v44Ev
  virtual void  v45(); // _ZN9S217C6_nt3v45Ev
  virtual void  v46(); // _ZN9S217C6_nt3v46Ev
  virtual void  v47(); // _ZN9S217C6_nt3v47Ev
  virtual void  v48(); // _ZN9S217C6_nt3v48Ev
  virtual void  v49(); // _ZN9S217C6_nt3v49Ev
  virtual void  v50(); // _ZN9S217C6_nt3v50Ev
  virtual void  v51(); // _ZN9S217C6_nt3v51Ev
  virtual void  v52(); // _ZN9S217C6_nt3v52Ev
  virtual void  v53(); // _ZN9S217C6_nt3v53Ev
  virtual void  v54(); // _ZN9S217C6_nt3v54Ev
  virtual void  v55(); // _ZN9S217C6_nt3v55Ev
  virtual void  v56(); // _ZN9S217C6_nt3v56Ev
  virtual void  v57(); // _ZN9S217C6_nt3v57Ev
  virtual void  v58(); // _ZN9S217C6_nt3v58Ev
  virtual void  v59(); // _ZN9S217C6_nt3v59Ev
  virtual void  v60(); // _ZN9S217C6_nt3v60Ev
  virtual void  v61(); // _ZN9S217C6_nt3v61Ev
  virtual void  v62(); // _ZN9S217C6_nt3v62Ev
  virtual void  v63(); // _ZN9S217C6_nt3v63Ev
  virtual void  v64(); // _ZN9S217C6_nt3v64Ev
  virtual void  v65(); // _ZN9S217C6_nt3v65Ev
  virtual void  v66(); // _ZN9S217C6_nt3v66Ev
  virtual void  v67(); // _ZN9S217C6_nt3v67Ev
  S217C6_nt(); // tgen
};
//SIG(-1 S217C6_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S217C6_nt ::~S217C6_nt(){ note_dtor("S217C6_nt", this);}
void  S217C6_nt ::v4(){vfunc_called(this, "_ZN9S217C6_nt2v4Ev");}
void  S217C6_nt ::v5(){vfunc_called(this, "_ZN9S217C6_nt2v5Ev");}
void  S217C6_nt ::v6(){vfunc_called(this, "_ZN9S217C6_nt2v6Ev");}
void  S217C6_nt ::v7(){vfunc_called(this, "_ZN9S217C6_nt2v7Ev");}
void  S217C6_nt ::v8(){vfunc_called(this, "_ZN9S217C6_nt2v8Ev");}
void  S217C6_nt ::v9(){vfunc_called(this, "_ZN9S217C6_nt2v9Ev");}
void  S217C6_nt ::v10(){vfunc_called(this, "_ZN9S217C6_nt3v10Ev");}
void  S217C6_nt ::v11(){vfunc_called(this, "_ZN9S217C6_nt3v11Ev");}
void  S217C6_nt ::v12(){vfunc_called(this, "_ZN9S217C6_nt3v12Ev");}
void  S217C6_nt ::v13(){vfunc_called(this, "_ZN9S217C6_nt3v13Ev");}
void  S217C6_nt ::v14(){vfunc_called(this, "_ZN9S217C6_nt3v14Ev");}
void  S217C6_nt ::v15(){vfunc_called(this, "_ZN9S217C6_nt3v15Ev");}
void  S217C6_nt ::v16(){vfunc_called(this, "_ZN9S217C6_nt3v16Ev");}
void  S217C6_nt ::v17(){vfunc_called(this, "_ZN9S217C6_nt3v17Ev");}
void  S217C6_nt ::v18(){vfunc_called(this, "_ZN9S217C6_nt3v18Ev");}
void  S217C6_nt ::v19(){vfunc_called(this, "_ZN9S217C6_nt3v19Ev");}
void  S217C6_nt ::v20(){vfunc_called(this, "_ZN9S217C6_nt3v20Ev");}
void  S217C6_nt ::v21(){vfunc_called(this, "_ZN9S217C6_nt3v21Ev");}
void  S217C6_nt ::v22(){vfunc_called(this, "_ZN9S217C6_nt3v22Ev");}
void  S217C6_nt ::v23(){vfunc_called(this, "_ZN9S217C6_nt3v23Ev");}
void  S217C6_nt ::v24(){vfunc_called(this, "_ZN9S217C6_nt3v24Ev");}
void  S217C6_nt ::v25(){vfunc_called(this, "_ZN9S217C6_nt3v25Ev");}
void  S217C6_nt ::v26(){vfunc_called(this, "_ZN9S217C6_nt3v26Ev");}
void  S217C6_nt ::v27(){vfunc_called(this, "_ZN9S217C6_nt3v27Ev");}
void  S217C6_nt ::v28(){vfunc_called(this, "_ZN9S217C6_nt3v28Ev");}
void  S217C6_nt ::v29(){vfunc_called(this, "_ZN9S217C6_nt3v29Ev");}
void  S217C6_nt ::v30(){vfunc_called(this, "_ZN9S217C6_nt3v30Ev");}
void  S217C6_nt ::v31(){vfunc_called(this, "_ZN9S217C6_nt3v31Ev");}
void  S217C6_nt ::v32(){vfunc_called(this, "_ZN9S217C6_nt3v32Ev");}
void  S217C6_nt ::v33(){vfunc_called(this, "_ZN9S217C6_nt3v33Ev");}
void  S217C6_nt ::v34(){vfunc_called(this, "_ZN9S217C6_nt3v34Ev");}
void  S217C6_nt ::v35(){vfunc_called(this, "_ZN9S217C6_nt3v35Ev");}
void  S217C6_nt ::v36(){vfunc_called(this, "_ZN9S217C6_nt3v36Ev");}
void  S217C6_nt ::v37(){vfunc_called(this, "_ZN9S217C6_nt3v37Ev");}
void  S217C6_nt ::v38(){vfunc_called(this, "_ZN9S217C6_nt3v38Ev");}
void  S217C6_nt ::v39(){vfunc_called(this, "_ZN9S217C6_nt3v39Ev");}
void  S217C6_nt ::v40(){vfunc_called(this, "_ZN9S217C6_nt3v40Ev");}
void  S217C6_nt ::v41(){vfunc_called(this, "_ZN9S217C6_nt3v41Ev");}
void  S217C6_nt ::v42(){vfunc_called(this, "_ZN9S217C6_nt3v42Ev");}
void  S217C6_nt ::v43(){vfunc_called(this, "_ZN9S217C6_nt3v43Ev");}
void  S217C6_nt ::v44(){vfunc_called(this, "_ZN9S217C6_nt3v44Ev");}
void  S217C6_nt ::v45(){vfunc_called(this, "_ZN9S217C6_nt3v45Ev");}
void  S217C6_nt ::v46(){vfunc_called(this, "_ZN9S217C6_nt3v46Ev");}
void  S217C6_nt ::v47(){vfunc_called(this, "_ZN9S217C6_nt3v47Ev");}
void  S217C6_nt ::v48(){vfunc_called(this, "_ZN9S217C6_nt3v48Ev");}
void  S217C6_nt ::v49(){vfunc_called(this, "_ZN9S217C6_nt3v49Ev");}
void  S217C6_nt ::v50(){vfunc_called(this, "_ZN9S217C6_nt3v50Ev");}
void  S217C6_nt ::v51(){vfunc_called(this, "_ZN9S217C6_nt3v51Ev");}
void  S217C6_nt ::v52(){vfunc_called(this, "_ZN9S217C6_nt3v52Ev");}
void  S217C6_nt ::v53(){vfunc_called(this, "_ZN9S217C6_nt3v53Ev");}
void  S217C6_nt ::v54(){vfunc_called(this, "_ZN9S217C6_nt3v54Ev");}
void  S217C6_nt ::v55(){vfunc_called(this, "_ZN9S217C6_nt3v55Ev");}
void  S217C6_nt ::v56(){vfunc_called(this, "_ZN9S217C6_nt3v56Ev");}
void  S217C6_nt ::v57(){vfunc_called(this, "_ZN9S217C6_nt3v57Ev");}
void  S217C6_nt ::v58(){vfunc_called(this, "_ZN9S217C6_nt3v58Ev");}
void  S217C6_nt ::v59(){vfunc_called(this, "_ZN9S217C6_nt3v59Ev");}
void  S217C6_nt ::v60(){vfunc_called(this, "_ZN9S217C6_nt3v60Ev");}
void  S217C6_nt ::v61(){vfunc_called(this, "_ZN9S217C6_nt3v61Ev");}
void  S217C6_nt ::v62(){vfunc_called(this, "_ZN9S217C6_nt3v62Ev");}
void  S217C6_nt ::v63(){vfunc_called(this, "_ZN9S217C6_nt3v63Ev");}
void  S217C6_nt ::v64(){vfunc_called(this, "_ZN9S217C6_nt3v64Ev");}
void  S217C6_nt ::v65(){vfunc_called(this, "_ZN9S217C6_nt3v65Ev");}
void  S217C6_nt ::v66(){vfunc_called(this, "_ZN9S217C6_nt3v66Ev");}
void  S217C6_nt ::v67(){vfunc_called(this, "_ZN9S217C6_nt3v67Ev");}
S217C6_nt ::S217C6_nt(){ note_ctor("S217C6_nt", this);} // tgen

//skip512 S217C6_nt

#else // __cplusplus

extern void _ZN9S217C6_ntC1Ev();
extern void _ZN9S217C6_ntD1Ev();
Name_Map name_map_S217C6_nt[] = {
  NSPAIR(_ZN9S217C6_ntC1Ev),
  NSPAIR(_ZN9S217C6_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S217C6_nt[];
extern void _ZN9S217C6_ntD1Ev();
extern void _ZN9S217C6_ntD0Ev();
extern void _ZN9S217C6_nt2v4Ev();
extern void _ZN9S217C6_nt2v5Ev();
extern void _ZN9S217C6_nt2v6Ev();
extern void _ZN9S217C6_nt2v7Ev();
extern void _ZN9S217C6_nt2v8Ev();
extern void _ZN9S217C6_nt2v9Ev();
extern void _ZN9S217C6_nt3v10Ev();
extern void _ZN9S217C6_nt3v11Ev();
extern void _ZN9S217C6_nt3v12Ev();
extern void _ZN9S217C6_nt3v13Ev();
extern void _ZN9S217C6_nt3v14Ev();
extern void _ZN9S217C6_nt3v15Ev();
extern void _ZN9S217C6_nt3v16Ev();
extern void _ZN9S217C6_nt3v17Ev();
extern void _ZN9S217C6_nt3v18Ev();
extern void _ZN9S217C6_nt3v19Ev();
extern void _ZN9S217C6_nt3v20Ev();
extern void _ZN9S217C6_nt3v21Ev();
extern void _ZN9S217C6_nt3v22Ev();
extern void _ZN9S217C6_nt3v23Ev();
extern void _ZN9S217C6_nt3v24Ev();
extern void _ZN9S217C6_nt3v25Ev();
extern void _ZN9S217C6_nt3v26Ev();
extern void _ZN9S217C6_nt3v27Ev();
extern void _ZN9S217C6_nt3v28Ev();
extern void _ZN9S217C6_nt3v29Ev();
extern void _ZN9S217C6_nt3v30Ev();
extern void _ZN9S217C6_nt3v31Ev();
extern void _ZN9S217C6_nt3v32Ev();
extern void _ZN9S217C6_nt3v33Ev();
extern void _ZN9S217C6_nt3v34Ev();
extern void _ZN9S217C6_nt3v35Ev();
extern void _ZN9S217C6_nt3v36Ev();
extern void _ZN9S217C6_nt3v37Ev();
extern void _ZN9S217C6_nt3v38Ev();
extern void _ZN9S217C6_nt3v39Ev();
extern void _ZN9S217C6_nt3v40Ev();
extern void _ZN9S217C6_nt3v41Ev();
extern void _ZN9S217C6_nt3v42Ev();
extern void _ZN9S217C6_nt3v43Ev();
extern void _ZN9S217C6_nt3v44Ev();
extern void _ZN9S217C6_nt3v45Ev();
extern void _ZN9S217C6_nt3v46Ev();
extern void _ZN9S217C6_nt3v47Ev();
extern void _ZN9S217C6_nt3v48Ev();
extern void _ZN9S217C6_nt3v49Ev();
extern void _ZN9S217C6_nt3v50Ev();
extern void _ZN9S217C6_nt3v51Ev();
extern void _ZN9S217C6_nt3v52Ev();
extern void _ZN9S217C6_nt3v53Ev();
extern void _ZN9S217C6_nt3v54Ev();
extern void _ZN9S217C6_nt3v55Ev();
extern void _ZN9S217C6_nt3v56Ev();
extern void _ZN9S217C6_nt3v57Ev();
extern void _ZN9S217C6_nt3v58Ev();
extern void _ZN9S217C6_nt3v59Ev();
extern void _ZN9S217C6_nt3v60Ev();
extern void _ZN9S217C6_nt3v61Ev();
extern void _ZN9S217C6_nt3v62Ev();
extern void _ZN9S217C6_nt3v63Ev();
extern void _ZN9S217C6_nt3v64Ev();
extern void _ZN9S217C6_nt3v65Ev();
extern void _ZN9S217C6_nt3v66Ev();
extern void _ZN9S217C6_nt3v67Ev();
static  VTBL_ENTRY vtc_S217C6_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S217C6_nt[0]),
  (VTBL_ENTRY)&_ZN9S217C6_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S217C6_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v4Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v67Ev,
};
extern VTBL_ENTRY _ZTI9S217C6_nt[];
VTBL_ENTRY *P__ZTI9S217C6_nt = _ZTI9S217C6_nt; 
extern  VTBL_ENTRY _ZTV9S217C6_nt[];
Class_Descriptor cd_S217C6_nt = {  "S217C6_nt", // class name
  0,0,//no base classes
  &(vtc_S217C6_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI9S217C6_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S217C6_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C5_nt  : S217C6_nt {
  virtual  ~S217C5_nt(); // _ZN9S217C5_ntD1Ev
  virtual void  v68(); // _ZN9S217C5_nt3v68Ev
  virtual void  v69(); // _ZN9S217C5_nt3v69Ev
  S217C5_nt(); // tgen
};
//SIG(-1 S217C5_nt) C1{ BC2{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2}


 S217C5_nt ::~S217C5_nt(){ note_dtor("S217C5_nt", this);}
void  S217C5_nt ::v68(){vfunc_called(this, "_ZN9S217C5_nt3v68Ev");}
void  S217C5_nt ::v69(){vfunc_called(this, "_ZN9S217C5_nt3v69Ev");}
S217C5_nt ::S217C5_nt(){ note_ctor("S217C5_nt", this);} // tgen

//skip512 S217C5_nt

#else // __cplusplus

extern void _ZN9S217C5_ntC1Ev();
extern void _ZN9S217C5_ntD1Ev();
Name_Map name_map_S217C5_nt[] = {
  NSPAIR(_ZN9S217C5_ntC1Ev),
  NSPAIR(_ZN9S217C5_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S217C6_nt;
extern VTBL_ENTRY _ZTI9S217C6_nt[];
extern  VTBL_ENTRY _ZTV9S217C6_nt[];
static Base_Class bases_S217C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S217C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S217C5_nt[];
extern void _ZN9S217C5_ntD1Ev();
extern void _ZN9S217C5_ntD0Ev();
extern void _ZN9S217C6_nt2v4Ev();
extern void _ZN9S217C6_nt2v5Ev();
extern void _ZN9S217C6_nt2v6Ev();
extern void _ZN9S217C6_nt2v7Ev();
extern void _ZN9S217C6_nt2v8Ev();
extern void _ZN9S217C6_nt2v9Ev();
extern void _ZN9S217C6_nt3v10Ev();
extern void _ZN9S217C6_nt3v11Ev();
extern void _ZN9S217C6_nt3v12Ev();
extern void _ZN9S217C6_nt3v13Ev();
extern void _ZN9S217C6_nt3v14Ev();
extern void _ZN9S217C6_nt3v15Ev();
extern void _ZN9S217C6_nt3v16Ev();
extern void _ZN9S217C6_nt3v17Ev();
extern void _ZN9S217C6_nt3v18Ev();
extern void _ZN9S217C6_nt3v19Ev();
extern void _ZN9S217C6_nt3v20Ev();
extern void _ZN9S217C6_nt3v21Ev();
extern void _ZN9S217C6_nt3v22Ev();
extern void _ZN9S217C6_nt3v23Ev();
extern void _ZN9S217C6_nt3v24Ev();
extern void _ZN9S217C6_nt3v25Ev();
extern void _ZN9S217C6_nt3v26Ev();
extern void _ZN9S217C6_nt3v27Ev();
extern void _ZN9S217C6_nt3v28Ev();
extern void _ZN9S217C6_nt3v29Ev();
extern void _ZN9S217C6_nt3v30Ev();
extern void _ZN9S217C6_nt3v31Ev();
extern void _ZN9S217C6_nt3v32Ev();
extern void _ZN9S217C6_nt3v33Ev();
extern void _ZN9S217C6_nt3v34Ev();
extern void _ZN9S217C6_nt3v35Ev();
extern void _ZN9S217C6_nt3v36Ev();
extern void _ZN9S217C6_nt3v37Ev();
extern void _ZN9S217C6_nt3v38Ev();
extern void _ZN9S217C6_nt3v39Ev();
extern void _ZN9S217C6_nt3v40Ev();
extern void _ZN9S217C6_nt3v41Ev();
extern void _ZN9S217C6_nt3v42Ev();
extern void _ZN9S217C6_nt3v43Ev();
extern void _ZN9S217C6_nt3v44Ev();
extern void _ZN9S217C6_nt3v45Ev();
extern void _ZN9S217C6_nt3v46Ev();
extern void _ZN9S217C6_nt3v47Ev();
extern void _ZN9S217C6_nt3v48Ev();
extern void _ZN9S217C6_nt3v49Ev();
extern void _ZN9S217C6_nt3v50Ev();
extern void _ZN9S217C6_nt3v51Ev();
extern void _ZN9S217C6_nt3v52Ev();
extern void _ZN9S217C6_nt3v53Ev();
extern void _ZN9S217C6_nt3v54Ev();
extern void _ZN9S217C6_nt3v55Ev();
extern void _ZN9S217C6_nt3v56Ev();
extern void _ZN9S217C6_nt3v57Ev();
extern void _ZN9S217C6_nt3v58Ev();
extern void _ZN9S217C6_nt3v59Ev();
extern void _ZN9S217C6_nt3v60Ev();
extern void _ZN9S217C6_nt3v61Ev();
extern void _ZN9S217C6_nt3v62Ev();
extern void _ZN9S217C6_nt3v63Ev();
extern void _ZN9S217C6_nt3v64Ev();
extern void _ZN9S217C6_nt3v65Ev();
extern void _ZN9S217C6_nt3v66Ev();
extern void _ZN9S217C6_nt3v67Ev();
extern void _ZN9S217C5_nt3v68Ev();
extern void _ZN9S217C5_nt3v69Ev();
static  VTBL_ENTRY vtc_S217C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S217C5_nt[0]),
  (VTBL_ENTRY)&_ZN9S217C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S217C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v4Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S217C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S217C5_nt3v69Ev,
};
extern VTBL_ENTRY _ZTI9S217C5_nt[];
VTBL_ENTRY *P__ZTI9S217C5_nt = _ZTI9S217C5_nt; 
extern  VTBL_ENTRY _ZTV9S217C5_nt[];
Class_Descriptor cd_S217C5_nt = {  "S217C5_nt", // class name
  bases_S217C5_nt, 1,
  &(vtc_S217C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI9S217C5_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S217C5_nt),70, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C8_nt  {
  int s217c8f0[4];
  char s217c8f1[9];
  void  mf217c8(); // _ZN9S217C8_nt7mf217c8Ev
};
//SIG(-1 S217C8_nt) C1{ m Fi[4] Fc[9]}


void  S217C8_nt ::mf217c8(){}

//skip512 S217C8_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C11_nt  {
  void *s217c11f0;
  int s217c11f1[2];
  void  mf217c11(); // _ZN10S217C11_nt8mf217c11Ev
};
//SIG(-1 S217C11_nt) C1{ m Fp Fi[2]}


void  S217C11_nt ::mf217c11(){}

//skip512 S217C11_nt

#else // __cplusplus

Class_Descriptor cd_S217C11_nt = {  "S217C11_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C10_nt  : S217C11_nt {
};
//SIG(-1 S217C10_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S217C10_nt

#else // __cplusplus

extern Class_Descriptor cd_S217C11_nt;
static Base_Class bases_S217C10_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S217C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S217C10_nt = {  "S217C10_nt", // class name
  bases_S217C10_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C9_nt  : S217C10_nt {
};
//SIG(-1 S217C9_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S217C9_nt

#else // __cplusplus

extern Class_Descriptor cd_S217C11_nt;
extern Class_Descriptor cd_S217C10_nt;
static Base_Class bases_S217C9_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S217C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S217C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C15  : S217C11_nt {
};
//SIG(-1 S217C15) C1{ BC2{ m Fp Fi[2]}}



static void Test_S217C15()
{
  extern Class_Descriptor cd_S217C15;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S217C15, buf);
    S217C15 &lv = *(new (buf) S217C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S217C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S217C15)");
    check_base_class_offset(lv, (S217C11_nt*), 0, "S217C15");
    test_class_info(&lv, &cd_S217C15);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS217C15(Test_S217C15, "S217C15", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S217C11_nt;
static Base_Class bases_S217C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S217C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S217C15 = {  "S217C15", // class name
  bases_S217C15, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C14  : S217C15 {
};
//SIG(-1 S217C14) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S217C14()
{
  extern Class_Descriptor cd_S217C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S217C14, buf);
    S217C14 &lv = *(new (buf) S217C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S217C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S217C14)");
    check_base_class_offset(lv, (S217C11_nt*)(S217C15*), 0, "S217C14");
    check_base_class_offset(lv, (S217C15*), 0, "S217C14");
    test_class_info(&lv, &cd_S217C14);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS217C14(Test_S217C14, "S217C14", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S217C11_nt;
extern Class_Descriptor cd_S217C15;
static Base_Class bases_S217C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S217C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S217C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S217C14 = {  "S217C14", // class name
  bases_S217C14, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C19  : S217C11_nt {
};
//SIG(-1 S217C19) C1{ BC2{ m Fp Fi[2]}}



static void Test_S217C19()
{
  extern Class_Descriptor cd_S217C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S217C19, buf);
    S217C19 &lv = *(new (buf) S217C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S217C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S217C19)");
    check_base_class_offset(lv, (S217C11_nt*), 0, "S217C19");
    test_class_info(&lv, &cd_S217C19);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS217C19(Test_S217C19, "S217C19", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S217C11_nt;
static Base_Class bases_S217C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S217C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S217C19 = {  "S217C19", // class name
  bases_S217C19, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C18  : S217C19 {
};
//SIG(-1 S217C18) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S217C18()
{
  extern Class_Descriptor cd_S217C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S217C18, buf);
    S217C18 &lv = *(new (buf) S217C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S217C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S217C18)");
    check_base_class_offset(lv, (S217C11_nt*)(S217C19*), 0, "S217C18");
    check_base_class_offset(lv, (S217C19*), 0, "S217C18");
    test_class_info(&lv, &cd_S217C18);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS217C18(Test_S217C18, "S217C18", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S217C11_nt;
extern Class_Descriptor cd_S217C19;
static Base_Class bases_S217C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S217C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S217C19,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S217C18 = {  "S217C18", // class name
  bases_S217C18, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C20_nt  {
  void *s217c20f0;
  ::S217C7_nt s217c20f1;
  void  mf217c20(); // _ZN10S217C20_nt8mf217c20Ev
};
//SIG(-1 S217C20_nt) C1{ m Fp FC2{ m Fi[2]}}


void  S217C20_nt ::mf217c20(){}

//skip512 S217C20_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C4_nt  : S217C5_nt {
  ::S217C8_nt s217c4f0;
  int s217c4f1;
  unsigned int s217c4f2:1;
  unsigned int s217c4f3:1;
  unsigned int s217c4f4:1;
  unsigned int s217c4f5:1;
  ::S217C9_nt s217c4f6;
  ::S217C9_nt s217c4f7;
  void *s217c4f8;
  ::S217C14 s217c4f9;
  ::S217C14 s217c4f10;
  ::S217C14 s217c4f11;
  ::S217C18 s217c4f12;
  char s217c4f13;
  int s217c4f14;
  void *s217c4f15;
  ::S217C7_nt s217c4f16;
  ::S217C7_nt s217c4f17;
  ::S217C7_nt s217c4f18;
  ::S217C7_nt s217c4f19;
  ::S217C7_nt s217c4f20;
  ::S217C7_nt s217c4f21;
  ::S217C20_nt s217c4f22;
  ::S217C20_nt s217c4f23;
  ::S217C20_nt s217c4f24;
  ::S217C20_nt s217c4f25;
  ::S217C20_nt s217c4f26;
  ::S217C20_nt s217c4f27;
  ::S217C20_nt s217c4f28;
  ::S217C20_nt s217c4f29;
  ::S217C20_nt s217c4f30;
  ::S217C20_nt s217c4f31;
  virtual  ~S217C4_nt(); // _ZN9S217C4_ntD1Ev
  virtual void  v70(); // _ZN9S217C4_nt3v70Ev
  virtual void  v71(); // _ZN9S217C4_nt3v71Ev
  virtual void  v72(); // _ZN9S217C4_nt3v72Ev
  virtual void  v73(); // _ZN9S217C4_nt3v73Ev
  virtual void  v74(); // _ZN9S217C4_nt3v74Ev
  virtual void  v75(); // _ZN9S217C4_nt3v75Ev
  virtual void  v76(); // _ZN9S217C4_nt3v76Ev
  virtual void  v77(); // _ZN9S217C4_nt3v77Ev
  virtual void  v78(); // _ZN9S217C4_nt3v78Ev
  virtual void  v79(); // _ZN9S217C4_nt3v79Ev
  virtual void  v80(); // _ZN9S217C4_nt3v80Ev
  virtual void  v81(); // _ZN9S217C4_nt3v81Ev
  virtual void  v82(); // _ZN9S217C4_nt3v82Ev
  virtual void  v83(); // _ZN9S217C4_nt3v83Ev
  virtual void  v84(); // _ZN9S217C4_nt3v84Ev
  virtual void  v85(); // _ZN9S217C4_nt3v85Ev
  virtual void  v86(); // _ZN9S217C4_nt3v86Ev
  virtual void  v87(); // _ZN9S217C4_nt3v87Ev
  virtual void  v88(); // _ZN9S217C4_nt3v88Ev
  virtual void  v89(); // _ZN9S217C4_nt3v89Ev
  virtual void  v90(); // _ZN9S217C4_nt3v90Ev
  virtual void  v91(); // _ZN9S217C4_nt3v91Ev
  virtual void  v92(); // _ZN9S217C4_nt3v92Ev
  virtual void  v93(); // _ZN9S217C4_nt3v93Ev
  virtual void  v94(); // _ZN9S217C4_nt3v94Ev
  virtual void  v95(); // _ZN9S217C4_nt3v95Ev
  virtual void  v96(); // _ZN9S217C4_nt3v96Ev
  virtual void  v97(); // _ZN9S217C4_nt3v97Ev
  virtual void  v98(); // _ZN9S217C4_nt3v98Ev
  virtual void  v99(); // _ZN9S217C4_nt3v99Ev
  virtual void  v100(); // _ZN9S217C4_nt4v100Ev
  virtual void  v101(); // _ZN9S217C4_nt4v101Ev
  virtual void  v102(); // _ZN9S217C4_nt4v102Ev
  virtual void  v103(); // _ZN9S217C4_nt4v103Ev
  virtual void  v104(); // _ZN9S217C4_nt4v104Ev
  virtual void  v105(); // _ZN9S217C4_nt4v105Ev
  virtual void  v106(); // _ZN9S217C4_nt4v106Ev
  virtual void  v107(); // _ZN9S217C4_nt4v107Ev
  virtual void  v108(); // _ZN9S217C4_nt4v108Ev
  virtual void  v109(); // _ZN9S217C4_nt4v109Ev
  virtual void  v110(); // _ZN9S217C4_nt4v110Ev
  virtual void  v111(); // _ZN9S217C4_nt4v111Ev
  virtual void  v112(); // _ZN9S217C4_nt4v112Ev
  virtual void  v113(); // _ZN9S217C4_nt4v113Ev
  virtual void  v114(); // _ZN9S217C4_nt4v114Ev
  virtual void  v115(); // _ZN9S217C4_nt4v115Ev
  virtual void  v116(); // _ZN9S217C4_nt4v116Ev
  virtual void  v117(); // _ZN9S217C4_nt4v117Ev
  virtual void  v118(); // _ZN9S217C4_nt4v118Ev
  virtual void  v119(); // _ZN9S217C4_nt4v119Ev
  virtual void  v120(); // _ZN9S217C4_nt4v120Ev
  virtual void  v121(); // _ZN9S217C4_nt4v121Ev
  virtual void  v122(); // _ZN9S217C4_nt4v122Ev
  virtual void  v123(); // _ZN9S217C4_nt4v123Ev
  virtual void  v124(); // _ZN9S217C4_nt4v124Ev
  virtual void  v125(); // _ZN9S217C4_nt4v125Ev
  virtual void  v126(); // _ZN9S217C4_nt4v126Ev
  virtual void  v127(); // _ZN9S217C4_nt4v127Ev
  virtual void  v128(); // _ZN9S217C4_nt4v128Ev
  virtual void  v129(); // _ZN9S217C4_nt4v129Ev
  virtual void  v130(); // _ZN9S217C4_nt4v130Ev
  virtual void  v131(); // _ZN9S217C4_nt4v131Ev
  virtual void  v132(); // _ZN9S217C4_nt4v132Ev
  virtual void  v133(); // _ZN9S217C4_nt4v133Ev
  virtual void  v134(); // _ZN9S217C4_nt4v134Ev
  virtual void  v135(); // _ZN9S217C4_nt4v135Ev
  virtual void  v136(); // _ZN9S217C4_nt4v136Ev
  virtual void  v137(); // _ZN9S217C4_nt4v137Ev
  virtual void  v138(); // _ZN9S217C4_nt4v138Ev
  virtual void  v139(); // _ZN9S217C4_nt4v139Ev
  virtual void  v140(); // _ZN9S217C4_nt4v140Ev
  virtual void  v141(); // _ZN9S217C4_nt4v141Ev
  virtual void  v142(); // _ZN9S217C4_nt4v142Ev
  virtual void  v143(); // _ZN9S217C4_nt4v143Ev
  virtual void  v144(); // _ZN9S217C4_nt4v144Ev
  virtual void  v145(); // _ZN9S217C4_nt4v145Ev
  S217C4_nt(); // tgen
};
//SIG(-1 S217C4_nt) C1{ BC2{ BC3{ vd v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v141 v142} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 FC5{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC6 Fp FC9{ BC10{ BC8}} FC9 FC9 FC11{ BC12{ BC8}} Fc Fi Fp FC4 FC4 FC4 FC4 FC4 FC4 FC13{ m Fp FC4} FC13 FC13 FC13 FC13 FC13 FC13 FC13 FC13 FC13}


 S217C4_nt ::~S217C4_nt(){ note_dtor("S217C4_nt", this);}
void  S217C4_nt ::v70(){vfunc_called(this, "_ZN9S217C4_nt3v70Ev");}
void  S217C4_nt ::v71(){vfunc_called(this, "_ZN9S217C4_nt3v71Ev");}
void  S217C4_nt ::v72(){vfunc_called(this, "_ZN9S217C4_nt3v72Ev");}
void  S217C4_nt ::v73(){vfunc_called(this, "_ZN9S217C4_nt3v73Ev");}
void  S217C4_nt ::v74(){vfunc_called(this, "_ZN9S217C4_nt3v74Ev");}
void  S217C4_nt ::v75(){vfunc_called(this, "_ZN9S217C4_nt3v75Ev");}
void  S217C4_nt ::v76(){vfunc_called(this, "_ZN9S217C4_nt3v76Ev");}
void  S217C4_nt ::v77(){vfunc_called(this, "_ZN9S217C4_nt3v77Ev");}
void  S217C4_nt ::v78(){vfunc_called(this, "_ZN9S217C4_nt3v78Ev");}
void  S217C4_nt ::v79(){vfunc_called(this, "_ZN9S217C4_nt3v79Ev");}
void  S217C4_nt ::v80(){vfunc_called(this, "_ZN9S217C4_nt3v80Ev");}
void  S217C4_nt ::v81(){vfunc_called(this, "_ZN9S217C4_nt3v81Ev");}
void  S217C4_nt ::v82(){vfunc_called(this, "_ZN9S217C4_nt3v82Ev");}
void  S217C4_nt ::v83(){vfunc_called(this, "_ZN9S217C4_nt3v83Ev");}
void  S217C4_nt ::v84(){vfunc_called(this, "_ZN9S217C4_nt3v84Ev");}
void  S217C4_nt ::v85(){vfunc_called(this, "_ZN9S217C4_nt3v85Ev");}
void  S217C4_nt ::v86(){vfunc_called(this, "_ZN9S217C4_nt3v86Ev");}
void  S217C4_nt ::v87(){vfunc_called(this, "_ZN9S217C4_nt3v87Ev");}
void  S217C4_nt ::v88(){vfunc_called(this, "_ZN9S217C4_nt3v88Ev");}
void  S217C4_nt ::v89(){vfunc_called(this, "_ZN9S217C4_nt3v89Ev");}
void  S217C4_nt ::v90(){vfunc_called(this, "_ZN9S217C4_nt3v90Ev");}
void  S217C4_nt ::v91(){vfunc_called(this, "_ZN9S217C4_nt3v91Ev");}
void  S217C4_nt ::v92(){vfunc_called(this, "_ZN9S217C4_nt3v92Ev");}
void  S217C4_nt ::v93(){vfunc_called(this, "_ZN9S217C4_nt3v93Ev");}
void  S217C4_nt ::v94(){vfunc_called(this, "_ZN9S217C4_nt3v94Ev");}
void  S217C4_nt ::v95(){vfunc_called(this, "_ZN9S217C4_nt3v95Ev");}
void  S217C4_nt ::v96(){vfunc_called(this, "_ZN9S217C4_nt3v96Ev");}
void  S217C4_nt ::v97(){vfunc_called(this, "_ZN9S217C4_nt3v97Ev");}
void  S217C4_nt ::v98(){vfunc_called(this, "_ZN9S217C4_nt3v98Ev");}
void  S217C4_nt ::v99(){vfunc_called(this, "_ZN9S217C4_nt3v99Ev");}
void  S217C4_nt ::v100(){vfunc_called(this, "_ZN9S217C4_nt4v100Ev");}
void  S217C4_nt ::v101(){vfunc_called(this, "_ZN9S217C4_nt4v101Ev");}
void  S217C4_nt ::v102(){vfunc_called(this, "_ZN9S217C4_nt4v102Ev");}
void  S217C4_nt ::v103(){vfunc_called(this, "_ZN9S217C4_nt4v103Ev");}
void  S217C4_nt ::v104(){vfunc_called(this, "_ZN9S217C4_nt4v104Ev");}
void  S217C4_nt ::v105(){vfunc_called(this, "_ZN9S217C4_nt4v105Ev");}
void  S217C4_nt ::v106(){vfunc_called(this, "_ZN9S217C4_nt4v106Ev");}
void  S217C4_nt ::v107(){vfunc_called(this, "_ZN9S217C4_nt4v107Ev");}
void  S217C4_nt ::v108(){vfunc_called(this, "_ZN9S217C4_nt4v108Ev");}
void  S217C4_nt ::v109(){vfunc_called(this, "_ZN9S217C4_nt4v109Ev");}
void  S217C4_nt ::v110(){vfunc_called(this, "_ZN9S217C4_nt4v110Ev");}
void  S217C4_nt ::v111(){vfunc_called(this, "_ZN9S217C4_nt4v111Ev");}
void  S217C4_nt ::v112(){vfunc_called(this, "_ZN9S217C4_nt4v112Ev");}
void  S217C4_nt ::v113(){vfunc_called(this, "_ZN9S217C4_nt4v113Ev");}
void  S217C4_nt ::v114(){vfunc_called(this, "_ZN9S217C4_nt4v114Ev");}
void  S217C4_nt ::v115(){vfunc_called(this, "_ZN9S217C4_nt4v115Ev");}
void  S217C4_nt ::v116(){vfunc_called(this, "_ZN9S217C4_nt4v116Ev");}
void  S217C4_nt ::v117(){vfunc_called(this, "_ZN9S217C4_nt4v117Ev");}
void  S217C4_nt ::v118(){vfunc_called(this, "_ZN9S217C4_nt4v118Ev");}
void  S217C4_nt ::v119(){vfunc_called(this, "_ZN9S217C4_nt4v119Ev");}
void  S217C4_nt ::v120(){vfunc_called(this, "_ZN9S217C4_nt4v120Ev");}
void  S217C4_nt ::v121(){vfunc_called(this, "_ZN9S217C4_nt4v121Ev");}
void  S217C4_nt ::v122(){vfunc_called(this, "_ZN9S217C4_nt4v122Ev");}
void  S217C4_nt ::v123(){vfunc_called(this, "_ZN9S217C4_nt4v123Ev");}
void  S217C4_nt ::v124(){vfunc_called(this, "_ZN9S217C4_nt4v124Ev");}
void  S217C4_nt ::v125(){vfunc_called(this, "_ZN9S217C4_nt4v125Ev");}
void  S217C4_nt ::v126(){vfunc_called(this, "_ZN9S217C4_nt4v126Ev");}
void  S217C4_nt ::v127(){vfunc_called(this, "_ZN9S217C4_nt4v127Ev");}
void  S217C4_nt ::v128(){vfunc_called(this, "_ZN9S217C4_nt4v128Ev");}
void  S217C4_nt ::v129(){vfunc_called(this, "_ZN9S217C4_nt4v129Ev");}
void  S217C4_nt ::v130(){vfunc_called(this, "_ZN9S217C4_nt4v130Ev");}
void  S217C4_nt ::v131(){vfunc_called(this, "_ZN9S217C4_nt4v131Ev");}
void  S217C4_nt ::v132(){vfunc_called(this, "_ZN9S217C4_nt4v132Ev");}
void  S217C4_nt ::v133(){vfunc_called(this, "_ZN9S217C4_nt4v133Ev");}
void  S217C4_nt ::v134(){vfunc_called(this, "_ZN9S217C4_nt4v134Ev");}
void  S217C4_nt ::v135(){vfunc_called(this, "_ZN9S217C4_nt4v135Ev");}
void  S217C4_nt ::v136(){vfunc_called(this, "_ZN9S217C4_nt4v136Ev");}
void  S217C4_nt ::v137(){vfunc_called(this, "_ZN9S217C4_nt4v137Ev");}
void  S217C4_nt ::v138(){vfunc_called(this, "_ZN9S217C4_nt4v138Ev");}
void  S217C4_nt ::v139(){vfunc_called(this, "_ZN9S217C4_nt4v139Ev");}
void  S217C4_nt ::v140(){vfunc_called(this, "_ZN9S217C4_nt4v140Ev");}
void  S217C4_nt ::v141(){vfunc_called(this, "_ZN9S217C4_nt4v141Ev");}
void  S217C4_nt ::v142(){vfunc_called(this, "_ZN9S217C4_nt4v142Ev");}
void  S217C4_nt ::v143(){vfunc_called(this, "_ZN9S217C4_nt4v143Ev");}
void  S217C4_nt ::v144(){vfunc_called(this, "_ZN9S217C4_nt4v144Ev");}
void  S217C4_nt ::v145(){vfunc_called(this, "_ZN9S217C4_nt4v145Ev");}
S217C4_nt ::S217C4_nt(){ note_ctor("S217C4_nt", this);} // tgen

//skip512 S217C4_nt

#else // __cplusplus

extern void _ZN9S217C4_ntC1Ev();
extern void _ZN9S217C4_ntD1Ev();
Name_Map name_map_S217C4_nt[] = {
  NSPAIR(_ZN9S217C4_ntC1Ev),
  NSPAIR(_ZN9S217C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S217C6_nt;
extern VTBL_ENTRY _ZTI9S217C6_nt[];
extern  VTBL_ENTRY _ZTV9S217C6_nt[];
extern Class_Descriptor cd_S217C5_nt;
extern VTBL_ENTRY _ZTI9S217C5_nt[];
extern  VTBL_ENTRY _ZTV9S217C5_nt[];
static Base_Class bases_S217C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S217C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S217C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S217C4_nt[];
extern void _ZN9S217C4_ntD1Ev();
extern void _ZN9S217C4_ntD0Ev();
extern void _ZN9S217C6_nt2v4Ev();
extern void _ZN9S217C6_nt2v5Ev();
extern void _ZN9S217C6_nt2v6Ev();
extern void _ZN9S217C6_nt2v7Ev();
extern void _ZN9S217C6_nt2v8Ev();
extern void _ZN9S217C6_nt2v9Ev();
extern void _ZN9S217C6_nt3v10Ev();
extern void _ZN9S217C6_nt3v11Ev();
extern void _ZN9S217C6_nt3v12Ev();
extern void _ZN9S217C6_nt3v13Ev();
extern void _ZN9S217C6_nt3v14Ev();
extern void _ZN9S217C6_nt3v15Ev();
extern void _ZN9S217C6_nt3v16Ev();
extern void _ZN9S217C6_nt3v17Ev();
extern void _ZN9S217C6_nt3v18Ev();
extern void _ZN9S217C6_nt3v19Ev();
extern void _ZN9S217C6_nt3v20Ev();
extern void _ZN9S217C6_nt3v21Ev();
extern void _ZN9S217C6_nt3v22Ev();
extern void _ZN9S217C6_nt3v23Ev();
extern void _ZN9S217C6_nt3v24Ev();
extern void _ZN9S217C6_nt3v25Ev();
extern void _ZN9S217C6_nt3v26Ev();
extern void _ZN9S217C6_nt3v27Ev();
extern void _ZN9S217C6_nt3v28Ev();
extern void _ZN9S217C6_nt3v29Ev();
extern void _ZN9S217C6_nt3v30Ev();
extern void _ZN9S217C6_nt3v31Ev();
extern void _ZN9S217C6_nt3v32Ev();
extern void _ZN9S217C6_nt3v33Ev();
extern void _ZN9S217C6_nt3v34Ev();
extern void _ZN9S217C6_nt3v35Ev();
extern void _ZN9S217C6_nt3v36Ev();
extern void _ZN9S217C6_nt3v37Ev();
extern void _ZN9S217C6_nt3v38Ev();
extern void _ZN9S217C6_nt3v39Ev();
extern void _ZN9S217C6_nt3v40Ev();
extern void _ZN9S217C6_nt3v41Ev();
extern void _ZN9S217C6_nt3v42Ev();
extern void _ZN9S217C6_nt3v43Ev();
extern void _ZN9S217C6_nt3v44Ev();
extern void _ZN9S217C6_nt3v45Ev();
extern void _ZN9S217C6_nt3v46Ev();
extern void _ZN9S217C6_nt3v47Ev();
extern void _ZN9S217C6_nt3v48Ev();
extern void _ZN9S217C6_nt3v49Ev();
extern void _ZN9S217C6_nt3v50Ev();
extern void _ZN9S217C6_nt3v51Ev();
extern void _ZN9S217C6_nt3v52Ev();
extern void _ZN9S217C6_nt3v53Ev();
extern void _ZN9S217C6_nt3v54Ev();
extern void _ZN9S217C6_nt3v55Ev();
extern void _ZN9S217C6_nt3v56Ev();
extern void _ZN9S217C6_nt3v57Ev();
extern void _ZN9S217C6_nt3v58Ev();
extern void _ZN9S217C6_nt3v59Ev();
extern void _ZN9S217C6_nt3v60Ev();
extern void _ZN9S217C6_nt3v61Ev();
extern void _ZN9S217C6_nt3v62Ev();
extern void _ZN9S217C6_nt3v63Ev();
extern void _ZN9S217C6_nt3v64Ev();
extern void _ZN9S217C6_nt3v65Ev();
extern void _ZN9S217C6_nt3v66Ev();
extern void _ZN9S217C6_nt3v67Ev();
extern void _ZN9S217C5_nt3v68Ev();
extern void _ZN9S217C5_nt3v69Ev();
extern void _ZN9S217C4_nt3v70Ev();
extern void _ZN9S217C4_nt3v71Ev();
extern void _ZN9S217C4_nt3v72Ev();
extern void _ZN9S217C4_nt3v73Ev();
extern void _ZN9S217C4_nt3v74Ev();
extern void _ZN9S217C4_nt3v75Ev();
extern void _ZN9S217C4_nt3v76Ev();
extern void _ZN9S217C4_nt3v77Ev();
extern void _ZN9S217C4_nt3v78Ev();
extern void _ZN9S217C4_nt3v79Ev();
extern void _ZN9S217C4_nt3v80Ev();
extern void _ZN9S217C4_nt3v81Ev();
extern void _ZN9S217C4_nt3v82Ev();
extern void _ZN9S217C4_nt3v83Ev();
extern void _ZN9S217C4_nt3v84Ev();
extern void _ZN9S217C4_nt3v85Ev();
extern void _ZN9S217C4_nt3v86Ev();
extern void _ZN9S217C4_nt3v87Ev();
extern void _ZN9S217C4_nt3v88Ev();
extern void _ZN9S217C4_nt3v89Ev();
extern void _ZN9S217C4_nt3v90Ev();
extern void _ZN9S217C4_nt3v91Ev();
extern void _ZN9S217C4_nt3v92Ev();
extern void _ZN9S217C4_nt3v93Ev();
extern void _ZN9S217C4_nt3v94Ev();
extern void _ZN9S217C4_nt3v95Ev();
extern void _ZN9S217C4_nt3v96Ev();
extern void _ZN9S217C4_nt3v97Ev();
extern void _ZN9S217C4_nt3v98Ev();
extern void _ZN9S217C4_nt3v99Ev();
extern void _ZN9S217C4_nt4v100Ev();
extern void _ZN9S217C4_nt4v101Ev();
extern void _ZN9S217C4_nt4v102Ev();
extern void _ZN9S217C4_nt4v103Ev();
extern void _ZN9S217C4_nt4v104Ev();
extern void _ZN9S217C4_nt4v105Ev();
extern void _ZN9S217C4_nt4v106Ev();
extern void _ZN9S217C4_nt4v107Ev();
extern void _ZN9S217C4_nt4v108Ev();
extern void _ZN9S217C4_nt4v109Ev();
extern void _ZN9S217C4_nt4v110Ev();
extern void _ZN9S217C4_nt4v111Ev();
extern void _ZN9S217C4_nt4v112Ev();
extern void _ZN9S217C4_nt4v113Ev();
extern void _ZN9S217C4_nt4v114Ev();
extern void _ZN9S217C4_nt4v115Ev();
extern void _ZN9S217C4_nt4v116Ev();
extern void _ZN9S217C4_nt4v117Ev();
extern void _ZN9S217C4_nt4v118Ev();
extern void _ZN9S217C4_nt4v119Ev();
extern void _ZN9S217C4_nt4v120Ev();
extern void _ZN9S217C4_nt4v121Ev();
extern void _ZN9S217C4_nt4v122Ev();
extern void _ZN9S217C4_nt4v123Ev();
extern void _ZN9S217C4_nt4v124Ev();
extern void _ZN9S217C4_nt4v125Ev();
extern void _ZN9S217C4_nt4v126Ev();
extern void _ZN9S217C4_nt4v127Ev();
extern void _ZN9S217C4_nt4v128Ev();
extern void _ZN9S217C4_nt4v129Ev();
extern void _ZN9S217C4_nt4v130Ev();
extern void _ZN9S217C4_nt4v131Ev();
extern void _ZN9S217C4_nt4v132Ev();
extern void _ZN9S217C4_nt4v133Ev();
extern void _ZN9S217C4_nt4v134Ev();
extern void _ZN9S217C4_nt4v135Ev();
extern void _ZN9S217C4_nt4v136Ev();
extern void _ZN9S217C4_nt4v137Ev();
extern void _ZN9S217C4_nt4v138Ev();
extern void _ZN9S217C4_nt4v139Ev();
extern void _ZN9S217C4_nt4v140Ev();
extern void _ZN9S217C4_nt4v141Ev();
extern void _ZN9S217C4_nt4v142Ev();
extern void _ZN9S217C4_nt4v143Ev();
extern void _ZN9S217C4_nt4v144Ev();
extern void _ZN9S217C4_nt4v145Ev();
static  VTBL_ENTRY vtc_S217C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S217C4_nt[0]),
  (VTBL_ENTRY)&_ZN9S217C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S217C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v4Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S217C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S217C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v145Ev,
};
extern VTBL_ENTRY _ZTI9S217C4_nt[];
VTBL_ENTRY *P__ZTI9S217C4_nt = _ZTI9S217C4_nt; 
extern  VTBL_ENTRY _ZTV9S217C4_nt[];
Class_Descriptor cd_S217C4_nt = {  "S217C4_nt", // class name
  bases_S217C4_nt, 2,
  &(vtc_S217C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(464,352), // object size
  NSPAIRA(_ZTI9S217C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S217C4_nt),146, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C22_nt  {
  int s217c22f0[4];
  void  mf217c22(); // _ZN10S217C22_nt8mf217c22Ev
};
//SIG(-1 S217C22_nt) C1{ m Fi[4]}


void  S217C22_nt ::mf217c22(){}

//skip512 S217C22_nt

#else // __cplusplus

Class_Descriptor cd_S217C22_nt = {  "S217C22_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C21_nt  : S217C22_nt {
};
//SIG(-1 S217C21_nt) C1{ BC2{ m Fi[4]}}



//skip512 S217C21_nt

#else // __cplusplus

extern Class_Descriptor cd_S217C22_nt;
static Base_Class bases_S217C21_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S217C22_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C23_nt  {
  ::S217C7_nt s217c23f0;
  void *s217c23f1;
  ::S217C21_nt s217c23f2;
  void *s217c23f3;
  void  mf217c23(); // _ZN10S217C23_nt8mf217c23Ev
};
//SIG(-1 S217C23_nt) C1{ m FC2{ m Fi[2]} Fp FC3{ BC4{ m Fi[4]}} Fp}


void  S217C23_nt ::mf217c23(){}

//skip512 S217C23_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C25_nt  {
  void *s217c25f0[8];
  char s217c25f1[4];
  void  mf217c25(); // _ZN10S217C25_nt8mf217c25Ev
};
//SIG(-1 S217C25_nt) C1{ m Fp[8] Fc[4]}


void  S217C25_nt ::mf217c25(){}

//skip512 S217C25_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C27_nt  {
  int s217c27f0[4];
  char s217c27f1[4];
  void  mf217c27(); // _ZN10S217C27_nt8mf217c27Ev
};
//SIG(-1 S217C27_nt) C1{ m Fi[4] Fc[4]}


void  S217C27_nt ::mf217c27(){}

//skip512 S217C27_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C26_nt  {
  void *s217c26f0[5];
  ::S217C27_nt s217c26f1;
  unsigned int s217c26f2:1;
  unsigned int s217c26f3:1;
  int s217c26f4;
  char s217c26f5[8];
  void  mf217c26(); // _ZN10S217C26_nt8mf217c26Ev
};
//SIG(-1 S217C26_nt) C1{ m Fp[5] FC2{ m Fi[4] Fc[4]} Fi:1 Fi:1 Fi Fc[8]}


void  S217C26_nt ::mf217c26(){}

//skip512 S217C26_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C30_nt  {
  int s217c30f0[3];
  void  mf217c30(); // _ZN10S217C30_nt8mf217c30Ev
};
//SIG(-1 S217C30_nt) C1{ m Fi[3]}


void  S217C30_nt ::mf217c30(){}

//skip512 S217C30_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C31_nt  {
  void  mf217c31(); // _ZN10S217C31_nt8mf217c31Ev
};
//SIG(-1 S217C31_nt) C1{ m}


void  S217C31_nt ::mf217c31(){}

//skip512 S217C31_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C33_nt  {
  int s217c33f0[2];
  char s217c33f1[2];
  void  mf217c33(); // _ZN10S217C33_nt8mf217c33Ev
};
//SIG(-1 S217C33_nt) C1{ m Fi[2] Fc[2]}


void  S217C33_nt ::mf217c33(){}

//skip512 S217C33_nt

#else // __cplusplus

Class_Descriptor cd_S217C33_nt = {  "S217C33_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C32_nt  : S217C33_nt {
  int s217c32f0;
};
//SIG(-1 S217C32_nt) C1{ BC2{ m Fi[2] Fc[2]} Fi}



//skip512 S217C32_nt

#else // __cplusplus

extern Class_Descriptor cd_S217C33_nt;
static Base_Class bases_S217C32_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S217C33_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C29_nt  {
  ::S217C30_nt s217c29f0;
  ::S217C31_nt s217c29f1;
  ::S217C32_nt s217c29f2;
  char s217c29f3;
  void  mf217c29(); // _ZN10S217C29_nt8mf217c29Ev
};
//SIG(-1 S217C29_nt) C1{ m FC2{ m Fi[3]} FC3{ m} FC4{ BC5{ m Fi[2] Fc[2]} Fi} Fc}


void  S217C29_nt ::mf217c29(){}

//skip512 S217C29_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C37_nt  {
  void *s217c37f0[2];
  void  mf217c37(); // _ZN10S217C37_nt8mf217c37Ev
};
//SIG(-1 S217C37_nt) C1{ m Fp[2]}


void  S217C37_nt ::mf217c37(){}

//skip512 S217C37_nt

#else // __cplusplus

Class_Descriptor cd_S217C37_nt = {  "S217C37_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,8), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C36_nt  : S217C37_nt {
};
//SIG(-1 S217C36_nt) C1{ BC2{ m Fp[2]}}



//skip512 S217C36_nt

#else // __cplusplus

extern Class_Descriptor cd_S217C37_nt;
static Base_Class bases_S217C36_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S217C37_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C40  : S217C11_nt {
};
//SIG(-1 S217C40) C1{ BC2{ m Fp Fi[2]}}



static void Test_S217C40()
{
  extern Class_Descriptor cd_S217C40;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S217C40, buf);
    S217C40 &lv = *(new (buf) S217C40());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S217C40)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S217C40)");
    check_base_class_offset(lv, (S217C11_nt*), 0, "S217C40");
    test_class_info(&lv, &cd_S217C40);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS217C40(Test_S217C40, "S217C40", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S217C11_nt;
static Base_Class bases_S217C40[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S217C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S217C40 = {  "S217C40", // class name
  bases_S217C40, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C39  : S217C40 {
};
//SIG(-1 S217C39) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S217C39()
{
  extern Class_Descriptor cd_S217C39;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S217C39, buf);
    S217C39 &lv = *(new (buf) S217C39());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S217C39)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S217C39)");
    check_base_class_offset(lv, (S217C11_nt*)(S217C40*), 0, "S217C39");
    check_base_class_offset(lv, (S217C40*), 0, "S217C39");
    test_class_info(&lv, &cd_S217C39);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS217C39(Test_S217C39, "S217C39", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S217C11_nt;
extern Class_Descriptor cd_S217C40;
static Base_Class bases_S217C39[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S217C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S217C40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S217C39 = {  "S217C39", // class name
  bases_S217C39, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C38_nt  : S217C39 {
};
//SIG(-1 S217C38_nt) C1{ BC2{ BC3{ BC4{ m Fp Fi[2]}}}}



//skip512 S217C38_nt

#else // __cplusplus

extern Class_Descriptor cd_S217C11_nt;
extern Class_Descriptor cd_S217C40;
extern Class_Descriptor cd_S217C39;
static Base_Class bases_S217C38_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S217C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S217C40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S217C39,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C35_nt  {
  ::S217C36_nt s217c35f0;
  char s217c35f1;
  ::S217C38_nt s217c35f2;
  int s217c35f3;
  ::S217C7_nt s217c35f4;
  ::S217C7_nt s217c35f5;
  void *s217c35f6;
  void  mf217c35(); // _ZN10S217C35_nt8mf217c35Ev
};
//SIG(-1 S217C35_nt) C1{ m FC2{ BC3{ m Fp[2]}} Fc FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} Fi FC8{ m Fi[2]} FC8 Fp}


void  S217C35_nt ::mf217c35(){}

//skip512 S217C35_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C44  : S217C11_nt {
};
//SIG(-1 S217C44) C1{ BC2{ m Fp Fi[2]}}



static void Test_S217C44()
{
  extern Class_Descriptor cd_S217C44;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S217C44, buf);
    S217C44 &lv = *(new (buf) S217C44());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S217C44)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S217C44)");
    check_base_class_offset(lv, (S217C11_nt*), 0, "S217C44");
    test_class_info(&lv, &cd_S217C44);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS217C44(Test_S217C44, "S217C44", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S217C11_nt;
static Base_Class bases_S217C44[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S217C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S217C44 = {  "S217C44", // class name
  bases_S217C44, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C43  : S217C44 {
};
//SIG(-1 S217C43) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S217C43()
{
  extern Class_Descriptor cd_S217C43;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S217C43, buf);
    S217C43 &lv = *(new (buf) S217C43());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S217C43)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S217C43)");
    check_base_class_offset(lv, (S217C11_nt*)(S217C44*), 0, "S217C43");
    check_base_class_offset(lv, (S217C44*), 0, "S217C43");
    test_class_info(&lv, &cd_S217C43);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS217C43(Test_S217C43, "S217C43", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S217C11_nt;
extern Class_Descriptor cd_S217C44;
static Base_Class bases_S217C43[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S217C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S217C44,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S217C43 = {  "S217C43", // class name
  bases_S217C43, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C3_nt  : S217C4_nt {
  ::S217C21_nt s217c3f0;
  ::S217C7_nt s217c3f1;
  void *s217c3f2[2];
  ::S217C23_nt s217c3f3;
  ::S217C25_nt s217c3f4;
  int s217c3f5;
  ::S217C26_nt s217c3f6;
  int s217c3f7[4];
  ::S217C7_nt s217c3f8[4];
  ::S217C29_nt s217c3f9;
  ::S217C30_nt s217c3f10;
  int s217c3f11;
  ::S217C35_nt s217c3f12;
  ::S217C35_nt s217c3f13;
  void *s217c3f14;
  ::S217C30_nt s217c3f15;
  ::S217C18 s217c3f16;
  ::S217C43 s217c3f17;
  unsigned int s217c3f18:1;
  unsigned int s217c3f19:1;
  unsigned int s217c3f20:1;
  ::S217C31_nt s217c3f21;
  ::S217C20_nt s217c3f22;
  ::S217C20_nt s217c3f23;
  ::S217C20_nt s217c3f24;
  ::S217C20_nt s217c3f25;
  ::S217C20_nt s217c3f26;
  ::S217C20_nt s217c3f27;
  ::S217C20_nt s217c3f28;
  ::S217C20_nt s217c3f29;
  ::S217C20_nt s217c3f30;
  ::S217C20_nt s217c3f31;
  ::S217C20_nt s217c3f32;
  ::S217C20_nt s217c3f33;
  ::S217C20_nt s217c3f34;
  virtual  ~S217C3_nt(); // _ZN9S217C3_ntD1Ev
  virtual void  v146(); // _ZN9S217C3_nt4v146Ev
  virtual void  v147(); // _ZN9S217C3_nt4v147Ev
  virtual void  v148(); // _ZN9S217C3_nt4v148Ev
  virtual void  v149(); // _ZN9S217C3_nt4v149Ev
  virtual void  v150(); // _ZN9S217C3_nt4v150Ev
  virtual void  v151(); // _ZN9S217C3_nt4v151Ev
  virtual void  v152(); // _ZN9S217C3_nt4v152Ev
  virtual void  v153(); // _ZN9S217C3_nt4v153Ev
  virtual void  v154(); // _ZN9S217C3_nt4v154Ev
  virtual void  v155(); // _ZN9S217C3_nt4v155Ev
  virtual void  v156(); // _ZN9S217C3_nt4v156Ev
  virtual void  v157(); // _ZN9S217C3_nt4v157Ev
  virtual void  v158(); // _ZN9S217C3_nt4v158Ev
  virtual void  v159(); // _ZN9S217C3_nt4v159Ev
  virtual void  v160(); // _ZN9S217C3_nt4v160Ev
  virtual void  v161(); // _ZN9S217C3_nt4v161Ev
  virtual void  v162(); // _ZN9S217C3_nt4v162Ev
  virtual void  v163(); // _ZN9S217C3_nt4v163Ev
  virtual void  v164(); // _ZN9S217C3_nt4v164Ev
  virtual void  v165(); // _ZN9S217C3_nt4v165Ev
  virtual void  v166(); // _ZN9S217C3_nt4v166Ev
  virtual void  v167(); // _ZN9S217C3_nt4v167Ev
  virtual void  v168(); // _ZN9S217C3_nt4v168Ev
  virtual void  v169(); // _ZN9S217C3_nt4v169Ev
  virtual void  v170(); // _ZN9S217C3_nt4v170Ev
  virtual void  v171(); // _ZN9S217C3_nt4v171Ev
  virtual void  v172(); // _ZN9S217C3_nt4v172Ev
  virtual void  v173(); // _ZN9S217C3_nt4v173Ev
  virtual void  v174(); // _ZN9S217C3_nt4v174Ev
  virtual void  v175(); // _ZN9S217C3_nt4v175Ev
  virtual void  v176(); // _ZN9S217C3_nt4v176Ev
  virtual void  v177(); // _ZN9S217C3_nt4v177Ev
  virtual void  v178(); // _ZN9S217C3_nt4v178Ev
  virtual void  v179(); // _ZN9S217C3_nt4v179Ev
  virtual void  v180(); // _ZN9S217C3_nt4v180Ev
  virtual void  v181(); // _ZN9S217C3_nt4v181Ev
  virtual void  v182(); // _ZN9S217C3_nt4v182Ev
  virtual void  v183(); // _ZN9S217C3_nt4v183Ev
  virtual void  v184(); // _ZN9S217C3_nt4v184Ev
  virtual void  v185(); // _ZN9S217C3_nt4v185Ev
  virtual void  v186(); // _ZN9S217C3_nt4v186Ev
  virtual void  v187(); // _ZN9S217C3_nt4v187Ev
  virtual void  v188(); // _ZN9S217C3_nt4v188Ev
  virtual void  v189(); // _ZN9S217C3_nt4v189Ev
  virtual void  v190(); // _ZN9S217C3_nt4v190Ev
  virtual void  v191(); // _ZN9S217C3_nt4v191Ev
  virtual void  v192(); // _ZN9S217C3_nt4v192Ev
  virtual void  v193(); // _ZN9S217C3_nt4v193Ev
  virtual void  v194(); // _ZN9S217C3_nt4v194Ev
  virtual void  v195(); // _ZN9S217C3_nt4v195Ev
  virtual void  v196(); // _ZN9S217C3_nt4v196Ev
  virtual void  v197(); // _ZN9S217C3_nt4v197Ev
  virtual void  v198(); // _ZN9S217C3_nt4v198Ev
  virtual void  v199(); // _ZN9S217C3_nt4v199Ev
  virtual void  v200(); // _ZN9S217C3_nt4v200Ev
  virtual void  v201(); // _ZN9S217C3_nt4v201Ev
  virtual void  v202(); // _ZN9S217C3_nt4v202Ev
  virtual void  v203(); // _ZN9S217C3_nt4v203Ev
  virtual void  v204(); // _ZN9S217C3_nt4v204Ev
  virtual void  v205(); // _ZN9S217C3_nt4v205Ev
  virtual void  v206(); // _ZN9S217C3_nt4v206Ev
  virtual void  v207(); // _ZN9S217C3_nt4v207Ev
  virtual void  v208(); // _ZN9S217C3_nt4v208Ev
  virtual void  v209(); // _ZN9S217C3_nt4v209Ev
  virtual void  v210(); // _ZN9S217C3_nt4v210Ev
  virtual void  v211(); // _ZN9S217C3_nt4v211Ev
  virtual void  v212(); // _ZN9S217C3_nt4v212Ev
  virtual void  v213(); // _ZN9S217C3_nt4v213Ev
  virtual void  v214(); // _ZN9S217C3_nt4v214Ev
  S217C3_nt(); // tgen
};
//SIG(-1 S217C3_nt) C1{ BC2{ BC3{ BC4{ vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v134 v135} vd v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 FC6{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC7 Fp FC10{ BC11{ BC9}} FC10 FC10 FC12{ BC13{ BC9}} Fc Fi Fp FC5 FC5 FC5 FC5 FC5 FC5 FC14{ m Fp FC5} FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 FC15{ BC16{ m Fi[4]}} FC5 Fp[2] FC17{ m FC5 Fp FC15 Fp} FC18{ m Fp[8] Fc[4]} Fi FC19{ m Fp[5] FC20{ m Fi[4] Fc[4]} Fi:1 Fi:1 Fi Fc[8]} Fi[4] FC5[4] FC21{ m FC22{ m Fi[3]} FC23{ m} FC24{ BC25{ m Fi[2] Fc[2]} Fi} Fc} FC22 Fi FC26{ m FC27{ BC28{ m Fp[2]}} Fc FC29{ BC30{ BC31{ BC9}}} Fi FC5 FC5 Fp} FC26 Fp FC22 FC12 FC32{ BC33{ BC9}} Fi:1 Fi:1 Fi:1 FC23 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14}


 S217C3_nt ::~S217C3_nt(){ note_dtor("S217C3_nt", this);}
void  S217C3_nt ::v146(){vfunc_called(this, "_ZN9S217C3_nt4v146Ev");}
void  S217C3_nt ::v147(){vfunc_called(this, "_ZN9S217C3_nt4v147Ev");}
void  S217C3_nt ::v148(){vfunc_called(this, "_ZN9S217C3_nt4v148Ev");}
void  S217C3_nt ::v149(){vfunc_called(this, "_ZN9S217C3_nt4v149Ev");}
void  S217C3_nt ::v150(){vfunc_called(this, "_ZN9S217C3_nt4v150Ev");}
void  S217C3_nt ::v151(){vfunc_called(this, "_ZN9S217C3_nt4v151Ev");}
void  S217C3_nt ::v152(){vfunc_called(this, "_ZN9S217C3_nt4v152Ev");}
void  S217C3_nt ::v153(){vfunc_called(this, "_ZN9S217C3_nt4v153Ev");}
void  S217C3_nt ::v154(){vfunc_called(this, "_ZN9S217C3_nt4v154Ev");}
void  S217C3_nt ::v155(){vfunc_called(this, "_ZN9S217C3_nt4v155Ev");}
void  S217C3_nt ::v156(){vfunc_called(this, "_ZN9S217C3_nt4v156Ev");}
void  S217C3_nt ::v157(){vfunc_called(this, "_ZN9S217C3_nt4v157Ev");}
void  S217C3_nt ::v158(){vfunc_called(this, "_ZN9S217C3_nt4v158Ev");}
void  S217C3_nt ::v159(){vfunc_called(this, "_ZN9S217C3_nt4v159Ev");}
void  S217C3_nt ::v160(){vfunc_called(this, "_ZN9S217C3_nt4v160Ev");}
void  S217C3_nt ::v161(){vfunc_called(this, "_ZN9S217C3_nt4v161Ev");}
void  S217C3_nt ::v162(){vfunc_called(this, "_ZN9S217C3_nt4v162Ev");}
void  S217C3_nt ::v163(){vfunc_called(this, "_ZN9S217C3_nt4v163Ev");}
void  S217C3_nt ::v164(){vfunc_called(this, "_ZN9S217C3_nt4v164Ev");}
void  S217C3_nt ::v165(){vfunc_called(this, "_ZN9S217C3_nt4v165Ev");}
void  S217C3_nt ::v166(){vfunc_called(this, "_ZN9S217C3_nt4v166Ev");}
void  S217C3_nt ::v167(){vfunc_called(this, "_ZN9S217C3_nt4v167Ev");}
void  S217C3_nt ::v168(){vfunc_called(this, "_ZN9S217C3_nt4v168Ev");}
void  S217C3_nt ::v169(){vfunc_called(this, "_ZN9S217C3_nt4v169Ev");}
void  S217C3_nt ::v170(){vfunc_called(this, "_ZN9S217C3_nt4v170Ev");}
void  S217C3_nt ::v171(){vfunc_called(this, "_ZN9S217C3_nt4v171Ev");}
void  S217C3_nt ::v172(){vfunc_called(this, "_ZN9S217C3_nt4v172Ev");}
void  S217C3_nt ::v173(){vfunc_called(this, "_ZN9S217C3_nt4v173Ev");}
void  S217C3_nt ::v174(){vfunc_called(this, "_ZN9S217C3_nt4v174Ev");}
void  S217C3_nt ::v175(){vfunc_called(this, "_ZN9S217C3_nt4v175Ev");}
void  S217C3_nt ::v176(){vfunc_called(this, "_ZN9S217C3_nt4v176Ev");}
void  S217C3_nt ::v177(){vfunc_called(this, "_ZN9S217C3_nt4v177Ev");}
void  S217C3_nt ::v178(){vfunc_called(this, "_ZN9S217C3_nt4v178Ev");}
void  S217C3_nt ::v179(){vfunc_called(this, "_ZN9S217C3_nt4v179Ev");}
void  S217C3_nt ::v180(){vfunc_called(this, "_ZN9S217C3_nt4v180Ev");}
void  S217C3_nt ::v181(){vfunc_called(this, "_ZN9S217C3_nt4v181Ev");}
void  S217C3_nt ::v182(){vfunc_called(this, "_ZN9S217C3_nt4v182Ev");}
void  S217C3_nt ::v183(){vfunc_called(this, "_ZN9S217C3_nt4v183Ev");}
void  S217C3_nt ::v184(){vfunc_called(this, "_ZN9S217C3_nt4v184Ev");}
void  S217C3_nt ::v185(){vfunc_called(this, "_ZN9S217C3_nt4v185Ev");}
void  S217C3_nt ::v186(){vfunc_called(this, "_ZN9S217C3_nt4v186Ev");}
void  S217C3_nt ::v187(){vfunc_called(this, "_ZN9S217C3_nt4v187Ev");}
void  S217C3_nt ::v188(){vfunc_called(this, "_ZN9S217C3_nt4v188Ev");}
void  S217C3_nt ::v189(){vfunc_called(this, "_ZN9S217C3_nt4v189Ev");}
void  S217C3_nt ::v190(){vfunc_called(this, "_ZN9S217C3_nt4v190Ev");}
void  S217C3_nt ::v191(){vfunc_called(this, "_ZN9S217C3_nt4v191Ev");}
void  S217C3_nt ::v192(){vfunc_called(this, "_ZN9S217C3_nt4v192Ev");}
void  S217C3_nt ::v193(){vfunc_called(this, "_ZN9S217C3_nt4v193Ev");}
void  S217C3_nt ::v194(){vfunc_called(this, "_ZN9S217C3_nt4v194Ev");}
void  S217C3_nt ::v195(){vfunc_called(this, "_ZN9S217C3_nt4v195Ev");}
void  S217C3_nt ::v196(){vfunc_called(this, "_ZN9S217C3_nt4v196Ev");}
void  S217C3_nt ::v197(){vfunc_called(this, "_ZN9S217C3_nt4v197Ev");}
void  S217C3_nt ::v198(){vfunc_called(this, "_ZN9S217C3_nt4v198Ev");}
void  S217C3_nt ::v199(){vfunc_called(this, "_ZN9S217C3_nt4v199Ev");}
void  S217C3_nt ::v200(){vfunc_called(this, "_ZN9S217C3_nt4v200Ev");}
void  S217C3_nt ::v201(){vfunc_called(this, "_ZN9S217C3_nt4v201Ev");}
void  S217C3_nt ::v202(){vfunc_called(this, "_ZN9S217C3_nt4v202Ev");}
void  S217C3_nt ::v203(){vfunc_called(this, "_ZN9S217C3_nt4v203Ev");}
void  S217C3_nt ::v204(){vfunc_called(this, "_ZN9S217C3_nt4v204Ev");}
void  S217C3_nt ::v205(){vfunc_called(this, "_ZN9S217C3_nt4v205Ev");}
void  S217C3_nt ::v206(){vfunc_called(this, "_ZN9S217C3_nt4v206Ev");}
void  S217C3_nt ::v207(){vfunc_called(this, "_ZN9S217C3_nt4v207Ev");}
void  S217C3_nt ::v208(){vfunc_called(this, "_ZN9S217C3_nt4v208Ev");}
void  S217C3_nt ::v209(){vfunc_called(this, "_ZN9S217C3_nt4v209Ev");}
void  S217C3_nt ::v210(){vfunc_called(this, "_ZN9S217C3_nt4v210Ev");}
void  S217C3_nt ::v211(){vfunc_called(this, "_ZN9S217C3_nt4v211Ev");}
void  S217C3_nt ::v212(){vfunc_called(this, "_ZN9S217C3_nt4v212Ev");}
void  S217C3_nt ::v213(){vfunc_called(this, "_ZN9S217C3_nt4v213Ev");}
void  S217C3_nt ::v214(){vfunc_called(this, "_ZN9S217C3_nt4v214Ev");}
S217C3_nt ::S217C3_nt(){ note_ctor("S217C3_nt", this);} // tgen

//skip512 S217C3_nt

#else // __cplusplus

extern void _ZN9S217C3_ntC1Ev();
extern void _ZN9S217C3_ntD1Ev();
Name_Map name_map_S217C3_nt[] = {
  NSPAIR(_ZN9S217C3_ntC1Ev),
  NSPAIR(_ZN9S217C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S217C6_nt;
extern VTBL_ENTRY _ZTI9S217C6_nt[];
extern  VTBL_ENTRY _ZTV9S217C6_nt[];
extern Class_Descriptor cd_S217C5_nt;
extern VTBL_ENTRY _ZTI9S217C5_nt[];
extern  VTBL_ENTRY _ZTV9S217C5_nt[];
extern Class_Descriptor cd_S217C4_nt;
extern VTBL_ENTRY _ZTI9S217C4_nt[];
extern  VTBL_ENTRY _ZTV9S217C4_nt[];
static Base_Class bases_S217C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S217C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S217C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S217C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S217C3_nt[];
extern void _ZN9S217C3_ntD1Ev();
extern void _ZN9S217C3_ntD0Ev();
extern void _ZN9S217C6_nt2v4Ev();
extern void _ZN9S217C6_nt2v5Ev();
extern void _ZN9S217C6_nt2v6Ev();
extern void _ZN9S217C6_nt2v7Ev();
extern void _ZN9S217C6_nt2v8Ev();
extern void _ZN9S217C6_nt2v9Ev();
extern void _ZN9S217C6_nt3v10Ev();
extern void _ZN9S217C6_nt3v11Ev();
extern void _ZN9S217C6_nt3v12Ev();
extern void _ZN9S217C6_nt3v13Ev();
extern void _ZN9S217C6_nt3v14Ev();
extern void _ZN9S217C6_nt3v15Ev();
extern void _ZN9S217C6_nt3v16Ev();
extern void _ZN9S217C6_nt3v17Ev();
extern void _ZN9S217C6_nt3v18Ev();
extern void _ZN9S217C6_nt3v19Ev();
extern void _ZN9S217C6_nt3v20Ev();
extern void _ZN9S217C6_nt3v21Ev();
extern void _ZN9S217C6_nt3v22Ev();
extern void _ZN9S217C6_nt3v23Ev();
extern void _ZN9S217C6_nt3v24Ev();
extern void _ZN9S217C6_nt3v25Ev();
extern void _ZN9S217C6_nt3v26Ev();
extern void _ZN9S217C6_nt3v27Ev();
extern void _ZN9S217C6_nt3v28Ev();
extern void _ZN9S217C6_nt3v29Ev();
extern void _ZN9S217C6_nt3v30Ev();
extern void _ZN9S217C6_nt3v31Ev();
extern void _ZN9S217C6_nt3v32Ev();
extern void _ZN9S217C6_nt3v33Ev();
extern void _ZN9S217C6_nt3v34Ev();
extern void _ZN9S217C6_nt3v35Ev();
extern void _ZN9S217C6_nt3v36Ev();
extern void _ZN9S217C6_nt3v37Ev();
extern void _ZN9S217C6_nt3v38Ev();
extern void _ZN9S217C6_nt3v39Ev();
extern void _ZN9S217C6_nt3v40Ev();
extern void _ZN9S217C6_nt3v41Ev();
extern void _ZN9S217C6_nt3v42Ev();
extern void _ZN9S217C6_nt3v43Ev();
extern void _ZN9S217C6_nt3v44Ev();
extern void _ZN9S217C6_nt3v45Ev();
extern void _ZN9S217C6_nt3v46Ev();
extern void _ZN9S217C6_nt3v47Ev();
extern void _ZN9S217C6_nt3v48Ev();
extern void _ZN9S217C6_nt3v49Ev();
extern void _ZN9S217C6_nt3v50Ev();
extern void _ZN9S217C6_nt3v51Ev();
extern void _ZN9S217C6_nt3v52Ev();
extern void _ZN9S217C6_nt3v53Ev();
extern void _ZN9S217C6_nt3v54Ev();
extern void _ZN9S217C6_nt3v55Ev();
extern void _ZN9S217C6_nt3v56Ev();
extern void _ZN9S217C6_nt3v57Ev();
extern void _ZN9S217C6_nt3v58Ev();
extern void _ZN9S217C6_nt3v59Ev();
extern void _ZN9S217C6_nt3v60Ev();
extern void _ZN9S217C6_nt3v61Ev();
extern void _ZN9S217C6_nt3v62Ev();
extern void _ZN9S217C6_nt3v63Ev();
extern void _ZN9S217C6_nt3v64Ev();
extern void _ZN9S217C6_nt3v65Ev();
extern void _ZN9S217C6_nt3v66Ev();
extern void _ZN9S217C6_nt3v67Ev();
extern void _ZN9S217C5_nt3v68Ev();
extern void _ZN9S217C5_nt3v69Ev();
extern void _ZN9S217C4_nt3v70Ev();
extern void _ZN9S217C4_nt3v71Ev();
extern void _ZN9S217C4_nt3v72Ev();
extern void _ZN9S217C4_nt3v73Ev();
extern void _ZN9S217C4_nt3v74Ev();
extern void _ZN9S217C4_nt3v75Ev();
extern void _ZN9S217C4_nt3v76Ev();
extern void _ZN9S217C4_nt3v77Ev();
extern void _ZN9S217C4_nt3v78Ev();
extern void _ZN9S217C4_nt3v79Ev();
extern void _ZN9S217C4_nt3v80Ev();
extern void _ZN9S217C4_nt3v81Ev();
extern void _ZN9S217C4_nt3v82Ev();
extern void _ZN9S217C4_nt3v83Ev();
extern void _ZN9S217C4_nt3v84Ev();
extern void _ZN9S217C4_nt3v85Ev();
extern void _ZN9S217C4_nt3v86Ev();
extern void _ZN9S217C4_nt3v87Ev();
extern void _ZN9S217C4_nt3v88Ev();
extern void _ZN9S217C4_nt3v89Ev();
extern void _ZN9S217C4_nt3v90Ev();
extern void _ZN9S217C4_nt3v91Ev();
extern void _ZN9S217C4_nt3v92Ev();
extern void _ZN9S217C4_nt3v93Ev();
extern void _ZN9S217C4_nt3v94Ev();
extern void _ZN9S217C4_nt3v95Ev();
extern void _ZN9S217C4_nt3v96Ev();
extern void _ZN9S217C4_nt3v97Ev();
extern void _ZN9S217C4_nt3v98Ev();
extern void _ZN9S217C4_nt3v99Ev();
extern void _ZN9S217C4_nt4v100Ev();
extern void _ZN9S217C4_nt4v101Ev();
extern void _ZN9S217C4_nt4v102Ev();
extern void _ZN9S217C4_nt4v103Ev();
extern void _ZN9S217C4_nt4v104Ev();
extern void _ZN9S217C4_nt4v105Ev();
extern void _ZN9S217C4_nt4v106Ev();
extern void _ZN9S217C4_nt4v107Ev();
extern void _ZN9S217C4_nt4v108Ev();
extern void _ZN9S217C4_nt4v109Ev();
extern void _ZN9S217C4_nt4v110Ev();
extern void _ZN9S217C4_nt4v111Ev();
extern void _ZN9S217C4_nt4v112Ev();
extern void _ZN9S217C4_nt4v113Ev();
extern void _ZN9S217C4_nt4v114Ev();
extern void _ZN9S217C4_nt4v115Ev();
extern void _ZN9S217C4_nt4v116Ev();
extern void _ZN9S217C4_nt4v117Ev();
extern void _ZN9S217C4_nt4v118Ev();
extern void _ZN9S217C4_nt4v119Ev();
extern void _ZN9S217C4_nt4v120Ev();
extern void _ZN9S217C4_nt4v121Ev();
extern void _ZN9S217C4_nt4v122Ev();
extern void _ZN9S217C4_nt4v123Ev();
extern void _ZN9S217C4_nt4v124Ev();
extern void _ZN9S217C4_nt4v125Ev();
extern void _ZN9S217C4_nt4v126Ev();
extern void _ZN9S217C4_nt4v127Ev();
extern void _ZN9S217C4_nt4v128Ev();
extern void _ZN9S217C4_nt4v129Ev();
extern void _ZN9S217C4_nt4v130Ev();
extern void _ZN9S217C4_nt4v131Ev();
extern void _ZN9S217C4_nt4v132Ev();
extern void _ZN9S217C4_nt4v133Ev();
extern void _ZN9S217C4_nt4v134Ev();
extern void _ZN9S217C4_nt4v135Ev();
extern void _ZN9S217C4_nt4v136Ev();
extern void _ZN9S217C4_nt4v137Ev();
extern void _ZN9S217C4_nt4v138Ev();
extern void _ZN9S217C4_nt4v139Ev();
extern void _ZN9S217C4_nt4v140Ev();
extern void _ZN9S217C4_nt4v141Ev();
extern void _ZN9S217C4_nt4v142Ev();
extern void _ZN9S217C4_nt4v143Ev();
extern void _ZN9S217C4_nt4v144Ev();
extern void _ZN9S217C4_nt4v145Ev();
extern void _ZN9S217C3_nt4v146Ev();
extern void _ZN9S217C3_nt4v147Ev();
extern void _ZN9S217C3_nt4v148Ev();
extern void _ZN9S217C3_nt4v149Ev();
extern void _ZN9S217C3_nt4v150Ev();
extern void _ZN9S217C3_nt4v151Ev();
extern void _ZN9S217C3_nt4v152Ev();
extern void _ZN9S217C3_nt4v153Ev();
extern void _ZN9S217C3_nt4v154Ev();
extern void _ZN9S217C3_nt4v155Ev();
extern void _ZN9S217C3_nt4v156Ev();
extern void _ZN9S217C3_nt4v157Ev();
extern void _ZN9S217C3_nt4v158Ev();
extern void _ZN9S217C3_nt4v159Ev();
extern void _ZN9S217C3_nt4v160Ev();
extern void _ZN9S217C3_nt4v161Ev();
extern void _ZN9S217C3_nt4v162Ev();
extern void _ZN9S217C3_nt4v163Ev();
extern void _ZN9S217C3_nt4v164Ev();
extern void _ZN9S217C3_nt4v165Ev();
extern void _ZN9S217C3_nt4v166Ev();
extern void _ZN9S217C3_nt4v167Ev();
extern void _ZN9S217C3_nt4v168Ev();
extern void _ZN9S217C3_nt4v169Ev();
extern void _ZN9S217C3_nt4v170Ev();
extern void _ZN9S217C3_nt4v171Ev();
extern void _ZN9S217C3_nt4v172Ev();
extern void _ZN9S217C3_nt4v173Ev();
extern void _ZN9S217C3_nt4v174Ev();
extern void _ZN9S217C3_nt4v175Ev();
extern void _ZN9S217C3_nt4v176Ev();
extern void _ZN9S217C3_nt4v177Ev();
extern void _ZN9S217C3_nt4v178Ev();
extern void _ZN9S217C3_nt4v179Ev();
extern void _ZN9S217C3_nt4v180Ev();
extern void _ZN9S217C3_nt4v181Ev();
extern void _ZN9S217C3_nt4v182Ev();
extern void _ZN9S217C3_nt4v183Ev();
extern void _ZN9S217C3_nt4v184Ev();
extern void _ZN9S217C3_nt4v185Ev();
extern void _ZN9S217C3_nt4v186Ev();
extern void _ZN9S217C3_nt4v187Ev();
extern void _ZN9S217C3_nt4v188Ev();
extern void _ZN9S217C3_nt4v189Ev();
extern void _ZN9S217C3_nt4v190Ev();
extern void _ZN9S217C3_nt4v191Ev();
extern void _ZN9S217C3_nt4v192Ev();
extern void _ZN9S217C3_nt4v193Ev();
extern void _ZN9S217C3_nt4v194Ev();
extern void _ZN9S217C3_nt4v195Ev();
extern void _ZN9S217C3_nt4v196Ev();
extern void _ZN9S217C3_nt4v197Ev();
extern void _ZN9S217C3_nt4v198Ev();
extern void _ZN9S217C3_nt4v199Ev();
extern void _ZN9S217C3_nt4v200Ev();
extern void _ZN9S217C3_nt4v201Ev();
extern void _ZN9S217C3_nt4v202Ev();
extern void _ZN9S217C3_nt4v203Ev();
extern void _ZN9S217C3_nt4v204Ev();
extern void _ZN9S217C3_nt4v205Ev();
extern void _ZN9S217C3_nt4v206Ev();
extern void _ZN9S217C3_nt4v207Ev();
extern void _ZN9S217C3_nt4v208Ev();
extern void _ZN9S217C3_nt4v209Ev();
extern void _ZN9S217C3_nt4v210Ev();
extern void _ZN9S217C3_nt4v211Ev();
extern void _ZN9S217C3_nt4v212Ev();
extern void _ZN9S217C3_nt4v213Ev();
extern void _ZN9S217C3_nt4v214Ev();
static  VTBL_ENTRY vtc_S217C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S217C3_nt[0]),
  (VTBL_ENTRY)&_ZN9S217C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S217C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v4Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S217C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S217C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v211Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v212Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v213Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v214Ev,
};
extern VTBL_ENTRY _ZTI9S217C3_nt[];
VTBL_ENTRY *P__ZTI9S217C3_nt = _ZTI9S217C3_nt; 
extern  VTBL_ENTRY _ZTV9S217C3_nt[];
Class_Descriptor cd_S217C3_nt = {  "S217C3_nt", // class name
  bases_S217C3_nt, 3,
  &(vtc_S217C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1224,908), // object size
  NSPAIRA(_ZTI9S217C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S217C3_nt),215, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C2_nt  : S217C3_nt {
  unsigned int s217c2f0:1;
  void *s217c2f1;
  virtual  ~S217C2_nt(); // _ZN9S217C2_ntD1Ev
  virtual void  v215(); // _ZN9S217C2_nt4v215Ev
  virtual void  v216(); // _ZN9S217C2_nt4v216Ev
  virtual void  v217(); // _ZN9S217C2_nt4v217Ev
  virtual void  v218(); // _ZN9S217C2_nt4v218Ev
  virtual void  v219(); // _ZN9S217C2_nt4v219Ev
  virtual void  v220(); // _ZN9S217C2_nt4v220Ev
  S217C2_nt(); // tgen
};
//SIG(-1 S217C2_nt) C1{ BC2{ BC3{ BC4{ BC5{ vd v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v71 v72} vd v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 FC7{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC8{ BC9{ BC10{ m Fp Fi[2]}}} FC8 Fp FC11{ BC12{ BC10}} FC11 FC11 FC13{ BC14{ BC10}} Fc Fi Fp FC6 FC6 FC6 FC6 FC6 FC6 FC15{ m Fp FC6} FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15} vd v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 FC16{ BC17{ m Fi[4]}} FC6 Fp[2] FC18{ m FC6 Fp FC16 Fp} FC19{ m Fp[8] Fc[4]} Fi FC20{ m Fp[5] FC21{ m Fi[4] Fc[4]} Fi:1 Fi:1 Fi Fc[8]} Fi[4] FC6[4] FC22{ m FC23{ m Fi[3]} FC24{ m} FC25{ BC26{ m Fi[2] Fc[2]} Fi} Fc} FC23 Fi FC27{ m FC28{ BC29{ m Fp[2]}} Fc FC30{ BC31{ BC32{ BC10}}} Fi FC6 FC6 Fp} FC27 Fp FC23 FC13 FC33{ BC34{ BC10}} Fi:1 Fi:1 Fi:1 FC24 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15} vd v1 v2 v3 v4 v5 v6 Fi:1 Fp}


 S217C2_nt ::~S217C2_nt(){ note_dtor("S217C2_nt", this);}
void  S217C2_nt ::v215(){vfunc_called(this, "_ZN9S217C2_nt4v215Ev");}
void  S217C2_nt ::v216(){vfunc_called(this, "_ZN9S217C2_nt4v216Ev");}
void  S217C2_nt ::v217(){vfunc_called(this, "_ZN9S217C2_nt4v217Ev");}
void  S217C2_nt ::v218(){vfunc_called(this, "_ZN9S217C2_nt4v218Ev");}
void  S217C2_nt ::v219(){vfunc_called(this, "_ZN9S217C2_nt4v219Ev");}
void  S217C2_nt ::v220(){vfunc_called(this, "_ZN9S217C2_nt4v220Ev");}
S217C2_nt ::S217C2_nt(){ note_ctor("S217C2_nt", this);} // tgen

//skip512 S217C2_nt

#else // __cplusplus

extern void _ZN9S217C2_ntC1Ev();
extern void _ZN9S217C2_ntD1Ev();
Name_Map name_map_S217C2_nt[] = {
  NSPAIR(_ZN9S217C2_ntC1Ev),
  NSPAIR(_ZN9S217C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S217C6_nt;
extern VTBL_ENTRY _ZTI9S217C6_nt[];
extern  VTBL_ENTRY _ZTV9S217C6_nt[];
extern Class_Descriptor cd_S217C5_nt;
extern VTBL_ENTRY _ZTI9S217C5_nt[];
extern  VTBL_ENTRY _ZTV9S217C5_nt[];
extern Class_Descriptor cd_S217C4_nt;
extern VTBL_ENTRY _ZTI9S217C4_nt[];
extern  VTBL_ENTRY _ZTV9S217C4_nt[];
extern Class_Descriptor cd_S217C3_nt;
extern VTBL_ENTRY _ZTI9S217C3_nt[];
extern  VTBL_ENTRY _ZTV9S217C3_nt[];
static Base_Class bases_S217C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S217C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S217C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S217C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S217C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S217C2_nt[];
extern void _ZN9S217C2_ntD1Ev();
extern void _ZN9S217C2_ntD0Ev();
extern void _ZN9S217C6_nt2v4Ev();
extern void _ZN9S217C6_nt2v5Ev();
extern void _ZN9S217C6_nt2v6Ev();
extern void _ZN9S217C6_nt2v7Ev();
extern void _ZN9S217C6_nt2v8Ev();
extern void _ZN9S217C6_nt2v9Ev();
extern void _ZN9S217C6_nt3v10Ev();
extern void _ZN9S217C6_nt3v11Ev();
extern void _ZN9S217C6_nt3v12Ev();
extern void _ZN9S217C6_nt3v13Ev();
extern void _ZN9S217C6_nt3v14Ev();
extern void _ZN9S217C6_nt3v15Ev();
extern void _ZN9S217C6_nt3v16Ev();
extern void _ZN9S217C6_nt3v17Ev();
extern void _ZN9S217C6_nt3v18Ev();
extern void _ZN9S217C6_nt3v19Ev();
extern void _ZN9S217C6_nt3v20Ev();
extern void _ZN9S217C6_nt3v21Ev();
extern void _ZN9S217C6_nt3v22Ev();
extern void _ZN9S217C6_nt3v23Ev();
extern void _ZN9S217C6_nt3v24Ev();
extern void _ZN9S217C6_nt3v25Ev();
extern void _ZN9S217C6_nt3v26Ev();
extern void _ZN9S217C6_nt3v27Ev();
extern void _ZN9S217C6_nt3v28Ev();
extern void _ZN9S217C6_nt3v29Ev();
extern void _ZN9S217C6_nt3v30Ev();
extern void _ZN9S217C6_nt3v31Ev();
extern void _ZN9S217C6_nt3v32Ev();
extern void _ZN9S217C6_nt3v33Ev();
extern void _ZN9S217C6_nt3v34Ev();
extern void _ZN9S217C6_nt3v35Ev();
extern void _ZN9S217C6_nt3v36Ev();
extern void _ZN9S217C6_nt3v37Ev();
extern void _ZN9S217C6_nt3v38Ev();
extern void _ZN9S217C6_nt3v39Ev();
extern void _ZN9S217C6_nt3v40Ev();
extern void _ZN9S217C6_nt3v41Ev();
extern void _ZN9S217C6_nt3v42Ev();
extern void _ZN9S217C6_nt3v43Ev();
extern void _ZN9S217C6_nt3v44Ev();
extern void _ZN9S217C6_nt3v45Ev();
extern void _ZN9S217C6_nt3v46Ev();
extern void _ZN9S217C6_nt3v47Ev();
extern void _ZN9S217C6_nt3v48Ev();
extern void _ZN9S217C6_nt3v49Ev();
extern void _ZN9S217C6_nt3v50Ev();
extern void _ZN9S217C6_nt3v51Ev();
extern void _ZN9S217C6_nt3v52Ev();
extern void _ZN9S217C6_nt3v53Ev();
extern void _ZN9S217C6_nt3v54Ev();
extern void _ZN9S217C6_nt3v55Ev();
extern void _ZN9S217C6_nt3v56Ev();
extern void _ZN9S217C6_nt3v57Ev();
extern void _ZN9S217C6_nt3v58Ev();
extern void _ZN9S217C6_nt3v59Ev();
extern void _ZN9S217C6_nt3v60Ev();
extern void _ZN9S217C6_nt3v61Ev();
extern void _ZN9S217C6_nt3v62Ev();
extern void _ZN9S217C6_nt3v63Ev();
extern void _ZN9S217C6_nt3v64Ev();
extern void _ZN9S217C6_nt3v65Ev();
extern void _ZN9S217C6_nt3v66Ev();
extern void _ZN9S217C6_nt3v67Ev();
extern void _ZN9S217C5_nt3v68Ev();
extern void _ZN9S217C5_nt3v69Ev();
extern void _ZN9S217C4_nt3v70Ev();
extern void _ZN9S217C4_nt3v71Ev();
extern void _ZN9S217C4_nt3v72Ev();
extern void _ZN9S217C4_nt3v73Ev();
extern void _ZN9S217C4_nt3v74Ev();
extern void _ZN9S217C4_nt3v75Ev();
extern void _ZN9S217C4_nt3v76Ev();
extern void _ZN9S217C4_nt3v77Ev();
extern void _ZN9S217C4_nt3v78Ev();
extern void _ZN9S217C4_nt3v79Ev();
extern void _ZN9S217C4_nt3v80Ev();
extern void _ZN9S217C4_nt3v81Ev();
extern void _ZN9S217C4_nt3v82Ev();
extern void _ZN9S217C4_nt3v83Ev();
extern void _ZN9S217C4_nt3v84Ev();
extern void _ZN9S217C4_nt3v85Ev();
extern void _ZN9S217C4_nt3v86Ev();
extern void _ZN9S217C4_nt3v87Ev();
extern void _ZN9S217C4_nt3v88Ev();
extern void _ZN9S217C4_nt3v89Ev();
extern void _ZN9S217C4_nt3v90Ev();
extern void _ZN9S217C4_nt3v91Ev();
extern void _ZN9S217C4_nt3v92Ev();
extern void _ZN9S217C4_nt3v93Ev();
extern void _ZN9S217C4_nt3v94Ev();
extern void _ZN9S217C4_nt3v95Ev();
extern void _ZN9S217C4_nt3v96Ev();
extern void _ZN9S217C4_nt3v97Ev();
extern void _ZN9S217C4_nt3v98Ev();
extern void _ZN9S217C4_nt3v99Ev();
extern void _ZN9S217C4_nt4v100Ev();
extern void _ZN9S217C4_nt4v101Ev();
extern void _ZN9S217C4_nt4v102Ev();
extern void _ZN9S217C4_nt4v103Ev();
extern void _ZN9S217C4_nt4v104Ev();
extern void _ZN9S217C4_nt4v105Ev();
extern void _ZN9S217C4_nt4v106Ev();
extern void _ZN9S217C4_nt4v107Ev();
extern void _ZN9S217C4_nt4v108Ev();
extern void _ZN9S217C4_nt4v109Ev();
extern void _ZN9S217C4_nt4v110Ev();
extern void _ZN9S217C4_nt4v111Ev();
extern void _ZN9S217C4_nt4v112Ev();
extern void _ZN9S217C4_nt4v113Ev();
extern void _ZN9S217C4_nt4v114Ev();
extern void _ZN9S217C4_nt4v115Ev();
extern void _ZN9S217C4_nt4v116Ev();
extern void _ZN9S217C4_nt4v117Ev();
extern void _ZN9S217C4_nt4v118Ev();
extern void _ZN9S217C4_nt4v119Ev();
extern void _ZN9S217C4_nt4v120Ev();
extern void _ZN9S217C4_nt4v121Ev();
extern void _ZN9S217C4_nt4v122Ev();
extern void _ZN9S217C4_nt4v123Ev();
extern void _ZN9S217C4_nt4v124Ev();
extern void _ZN9S217C4_nt4v125Ev();
extern void _ZN9S217C4_nt4v126Ev();
extern void _ZN9S217C4_nt4v127Ev();
extern void _ZN9S217C4_nt4v128Ev();
extern void _ZN9S217C4_nt4v129Ev();
extern void _ZN9S217C4_nt4v130Ev();
extern void _ZN9S217C4_nt4v131Ev();
extern void _ZN9S217C4_nt4v132Ev();
extern void _ZN9S217C4_nt4v133Ev();
extern void _ZN9S217C4_nt4v134Ev();
extern void _ZN9S217C4_nt4v135Ev();
extern void _ZN9S217C4_nt4v136Ev();
extern void _ZN9S217C4_nt4v137Ev();
extern void _ZN9S217C4_nt4v138Ev();
extern void _ZN9S217C4_nt4v139Ev();
extern void _ZN9S217C4_nt4v140Ev();
extern void _ZN9S217C4_nt4v141Ev();
extern void _ZN9S217C4_nt4v142Ev();
extern void _ZN9S217C4_nt4v143Ev();
extern void _ZN9S217C4_nt4v144Ev();
extern void _ZN9S217C4_nt4v145Ev();
extern void _ZN9S217C3_nt4v146Ev();
extern void _ZN9S217C3_nt4v147Ev();
extern void _ZN9S217C3_nt4v148Ev();
extern void _ZN9S217C3_nt4v149Ev();
extern void _ZN9S217C3_nt4v150Ev();
extern void _ZN9S217C3_nt4v151Ev();
extern void _ZN9S217C3_nt4v152Ev();
extern void _ZN9S217C3_nt4v153Ev();
extern void _ZN9S217C3_nt4v154Ev();
extern void _ZN9S217C3_nt4v155Ev();
extern void _ZN9S217C3_nt4v156Ev();
extern void _ZN9S217C3_nt4v157Ev();
extern void _ZN9S217C3_nt4v158Ev();
extern void _ZN9S217C3_nt4v159Ev();
extern void _ZN9S217C3_nt4v160Ev();
extern void _ZN9S217C3_nt4v161Ev();
extern void _ZN9S217C3_nt4v162Ev();
extern void _ZN9S217C3_nt4v163Ev();
extern void _ZN9S217C3_nt4v164Ev();
extern void _ZN9S217C3_nt4v165Ev();
extern void _ZN9S217C3_nt4v166Ev();
extern void _ZN9S217C3_nt4v167Ev();
extern void _ZN9S217C3_nt4v168Ev();
extern void _ZN9S217C3_nt4v169Ev();
extern void _ZN9S217C3_nt4v170Ev();
extern void _ZN9S217C3_nt4v171Ev();
extern void _ZN9S217C3_nt4v172Ev();
extern void _ZN9S217C3_nt4v173Ev();
extern void _ZN9S217C3_nt4v174Ev();
extern void _ZN9S217C3_nt4v175Ev();
extern void _ZN9S217C3_nt4v176Ev();
extern void _ZN9S217C3_nt4v177Ev();
extern void _ZN9S217C3_nt4v178Ev();
extern void _ZN9S217C3_nt4v179Ev();
extern void _ZN9S217C3_nt4v180Ev();
extern void _ZN9S217C3_nt4v181Ev();
extern void _ZN9S217C3_nt4v182Ev();
extern void _ZN9S217C3_nt4v183Ev();
extern void _ZN9S217C3_nt4v184Ev();
extern void _ZN9S217C3_nt4v185Ev();
extern void _ZN9S217C3_nt4v186Ev();
extern void _ZN9S217C3_nt4v187Ev();
extern void _ZN9S217C3_nt4v188Ev();
extern void _ZN9S217C3_nt4v189Ev();
extern void _ZN9S217C3_nt4v190Ev();
extern void _ZN9S217C3_nt4v191Ev();
extern void _ZN9S217C3_nt4v192Ev();
extern void _ZN9S217C3_nt4v193Ev();
extern void _ZN9S217C3_nt4v194Ev();
extern void _ZN9S217C3_nt4v195Ev();
extern void _ZN9S217C3_nt4v196Ev();
extern void _ZN9S217C3_nt4v197Ev();
extern void _ZN9S217C3_nt4v198Ev();
extern void _ZN9S217C3_nt4v199Ev();
extern void _ZN9S217C3_nt4v200Ev();
extern void _ZN9S217C3_nt4v201Ev();
extern void _ZN9S217C3_nt4v202Ev();
extern void _ZN9S217C3_nt4v203Ev();
extern void _ZN9S217C3_nt4v204Ev();
extern void _ZN9S217C3_nt4v205Ev();
extern void _ZN9S217C3_nt4v206Ev();
extern void _ZN9S217C3_nt4v207Ev();
extern void _ZN9S217C3_nt4v208Ev();
extern void _ZN9S217C3_nt4v209Ev();
extern void _ZN9S217C3_nt4v210Ev();
extern void _ZN9S217C3_nt4v211Ev();
extern void _ZN9S217C3_nt4v212Ev();
extern void _ZN9S217C3_nt4v213Ev();
extern void _ZN9S217C3_nt4v214Ev();
extern void _ZN9S217C2_nt4v215Ev();
extern void _ZN9S217C2_nt4v216Ev();
extern void _ZN9S217C2_nt4v217Ev();
extern void _ZN9S217C2_nt4v218Ev();
extern void _ZN9S217C2_nt4v219Ev();
extern void _ZN9S217C2_nt4v220Ev();
static  VTBL_ENTRY vtc_S217C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S217C2_nt[0]),
  (VTBL_ENTRY)&_ZN9S217C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S217C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v4Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S217C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S217C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v211Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v212Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v213Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v214Ev,
  (VTBL_ENTRY)&_ZN9S217C2_nt4v215Ev,
  (VTBL_ENTRY)&_ZN9S217C2_nt4v216Ev,
  (VTBL_ENTRY)&_ZN9S217C2_nt4v217Ev,
  (VTBL_ENTRY)&_ZN9S217C2_nt4v218Ev,
  (VTBL_ENTRY)&_ZN9S217C2_nt4v219Ev,
  (VTBL_ENTRY)&_ZN9S217C2_nt4v220Ev,
};
extern VTBL_ENTRY _ZTI9S217C2_nt[];
VTBL_ENTRY *P__ZTI9S217C2_nt = _ZTI9S217C2_nt; 
extern  VTBL_ENTRY _ZTV9S217C2_nt[];
Class_Descriptor cd_S217C2_nt = {  "S217C2_nt", // class name
  bases_S217C2_nt, 4,
  &(vtc_S217C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1240,916), // object size
  NSPAIRA(_ZTI9S217C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S217C2_nt),221, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S217C1  : S217C2_nt {
  void *s217c1f0[6];
  virtual  ~S217C1(); // _ZN6S217C1D1Ev
  virtual void  v1(); // _ZN6S217C12v1Ev
  virtual void  v2(); // _ZN6S217C12v2Ev
  virtual void  v3(); // _ZN6S217C12v3Ev
  S217C1(); // tgen
};
//SIG(1 S217C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v68 v69} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 FC8{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC9{ BC10{ BC11{ m Fp Fi[2]}}} FC9 Fp FC12{ BC13{ BC11}} FC12 FC12 FC14{ BC15{ BC11}} Fc Fi Fp FC7 FC7 FC7 FC7 FC7 FC7 FC16{ m Fp FC7} FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16} vd v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 FC17{ BC18{ m Fi[4]}} FC7 Fp[2] FC19{ m FC7 Fp FC17 Fp} FC20{ m Fp[8] Fc[4]} Fi FC21{ m Fp[5] FC22{ m Fi[4] Fc[4]} Fi:1 Fi:1 Fi Fc[8]} Fi[4] FC7[4] FC23{ m FC24{ m Fi[3]} FC25{ m} FC26{ BC27{ m Fi[2] Fc[2]} Fi} Fc} FC24 Fi FC28{ m FC29{ BC30{ m Fp[2]}} Fc FC31{ BC32{ BC33{ BC11}}} Fi FC7 FC7 Fp} FC28 Fp FC24 FC14 FC34{ BC35{ BC11}} Fi:1 Fi:1 Fi:1 FC25 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16} vd v215 v216 v217 v218 v219 v220 Fi:1 Fp} vd v1 v2 v3 Fp[6]}


 S217C1 ::~S217C1(){ note_dtor("S217C1", this);}
void  S217C1 ::v1(){vfunc_called(this, "_ZN6S217C12v1Ev");}
void  S217C1 ::v2(){vfunc_called(this, "_ZN6S217C12v2Ev");}
void  S217C1 ::v3(){vfunc_called(this, "_ZN6S217C12v3Ev");}
S217C1 ::S217C1(){ note_ctor("S217C1", this);} // tgen

static void Test_S217C1()
{
  extern Class_Descriptor cd_S217C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(162,236)];
    init_test(&cd_S217C1, buf);
    S217C1 *dp, &lv = *(dp=new (buf) S217C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1288,940), "sizeof(S217C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S217C1)");
    check_base_class_offset(lv, (S217C6_nt*)(S217C5_nt*)(S217C4_nt*)(S217C3_nt*)(S217C2_nt*), 0, "S217C1");
    check_base_class_offset(lv, (S217C5_nt*)(S217C4_nt*)(S217C3_nt*)(S217C2_nt*), 0, "S217C1");
    check_base_class_offset(lv, (S217C4_nt*)(S217C3_nt*)(S217C2_nt*), 0, "S217C1");
    check_base_class_offset(lv, (S217C3_nt*)(S217C2_nt*), 0, "S217C1");
    check_base_class_offset(lv, (S217C2_nt*), 0, "S217C1");
    check_field_offset(lv, s217c1f0, ABISELECT(1240,916), "S217C1.s217c1f0");
    test_class_info(&lv, &cd_S217C1);
    dp->~S217C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS217C1(Test_S217C1, "S217C1", ABISELECT(1288,940));

#else // __cplusplus

extern void _ZN6S217C1C1Ev();
extern void _ZN6S217C1D1Ev();
Name_Map name_map_S217C1[] = {
  NSPAIR(_ZN6S217C1C1Ev),
  NSPAIR(_ZN6S217C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S217C6_nt;
extern VTBL_ENTRY _ZTI9S217C6_nt[];
extern  VTBL_ENTRY _ZTV9S217C6_nt[];
extern Class_Descriptor cd_S217C5_nt;
extern VTBL_ENTRY _ZTI9S217C5_nt[];
extern  VTBL_ENTRY _ZTV9S217C5_nt[];
extern Class_Descriptor cd_S217C4_nt;
extern VTBL_ENTRY _ZTI9S217C4_nt[];
extern  VTBL_ENTRY _ZTV9S217C4_nt[];
extern Class_Descriptor cd_S217C3_nt;
extern VTBL_ENTRY _ZTI9S217C3_nt[];
extern  VTBL_ENTRY _ZTV9S217C3_nt[];
extern Class_Descriptor cd_S217C2_nt;
extern VTBL_ENTRY _ZTI9S217C2_nt[];
extern  VTBL_ENTRY _ZTV9S217C2_nt[];
static Base_Class bases_S217C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S217C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S217C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S217C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S217C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S217C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S217C1[];
extern void _ZN6S217C1D1Ev();
extern void _ZN6S217C1D0Ev();
extern void _ZN9S217C6_nt2v4Ev();
extern void _ZN9S217C6_nt2v5Ev();
extern void _ZN9S217C6_nt2v6Ev();
extern void _ZN9S217C6_nt2v7Ev();
extern void _ZN9S217C6_nt2v8Ev();
extern void _ZN9S217C6_nt2v9Ev();
extern void _ZN9S217C6_nt3v10Ev();
extern void _ZN9S217C6_nt3v11Ev();
extern void _ZN9S217C6_nt3v12Ev();
extern void _ZN9S217C6_nt3v13Ev();
extern void _ZN9S217C6_nt3v14Ev();
extern void _ZN9S217C6_nt3v15Ev();
extern void _ZN9S217C6_nt3v16Ev();
extern void _ZN9S217C6_nt3v17Ev();
extern void _ZN9S217C6_nt3v18Ev();
extern void _ZN9S217C6_nt3v19Ev();
extern void _ZN9S217C6_nt3v20Ev();
extern void _ZN9S217C6_nt3v21Ev();
extern void _ZN9S217C6_nt3v22Ev();
extern void _ZN9S217C6_nt3v23Ev();
extern void _ZN9S217C6_nt3v24Ev();
extern void _ZN9S217C6_nt3v25Ev();
extern void _ZN9S217C6_nt3v26Ev();
extern void _ZN9S217C6_nt3v27Ev();
extern void _ZN9S217C6_nt3v28Ev();
extern void _ZN9S217C6_nt3v29Ev();
extern void _ZN9S217C6_nt3v30Ev();
extern void _ZN9S217C6_nt3v31Ev();
extern void _ZN9S217C6_nt3v32Ev();
extern void _ZN9S217C6_nt3v33Ev();
extern void _ZN9S217C6_nt3v34Ev();
extern void _ZN9S217C6_nt3v35Ev();
extern void _ZN9S217C6_nt3v36Ev();
extern void _ZN9S217C6_nt3v37Ev();
extern void _ZN9S217C6_nt3v38Ev();
extern void _ZN9S217C6_nt3v39Ev();
extern void _ZN9S217C6_nt3v40Ev();
extern void _ZN9S217C6_nt3v41Ev();
extern void _ZN9S217C6_nt3v42Ev();
extern void _ZN9S217C6_nt3v43Ev();
extern void _ZN9S217C6_nt3v44Ev();
extern void _ZN9S217C6_nt3v45Ev();
extern void _ZN9S217C6_nt3v46Ev();
extern void _ZN9S217C6_nt3v47Ev();
extern void _ZN9S217C6_nt3v48Ev();
extern void _ZN9S217C6_nt3v49Ev();
extern void _ZN9S217C6_nt3v50Ev();
extern void _ZN9S217C6_nt3v51Ev();
extern void _ZN9S217C6_nt3v52Ev();
extern void _ZN9S217C6_nt3v53Ev();
extern void _ZN9S217C6_nt3v54Ev();
extern void _ZN9S217C6_nt3v55Ev();
extern void _ZN9S217C6_nt3v56Ev();
extern void _ZN9S217C6_nt3v57Ev();
extern void _ZN9S217C6_nt3v58Ev();
extern void _ZN9S217C6_nt3v59Ev();
extern void _ZN9S217C6_nt3v60Ev();
extern void _ZN9S217C6_nt3v61Ev();
extern void _ZN9S217C6_nt3v62Ev();
extern void _ZN9S217C6_nt3v63Ev();
extern void _ZN9S217C6_nt3v64Ev();
extern void _ZN9S217C6_nt3v65Ev();
extern void _ZN9S217C6_nt3v66Ev();
extern void _ZN9S217C6_nt3v67Ev();
extern void _ZN9S217C5_nt3v68Ev();
extern void _ZN9S217C5_nt3v69Ev();
extern void _ZN9S217C4_nt3v70Ev();
extern void _ZN9S217C4_nt3v71Ev();
extern void _ZN9S217C4_nt3v72Ev();
extern void _ZN9S217C4_nt3v73Ev();
extern void _ZN9S217C4_nt3v74Ev();
extern void _ZN9S217C4_nt3v75Ev();
extern void _ZN9S217C4_nt3v76Ev();
extern void _ZN9S217C4_nt3v77Ev();
extern void _ZN9S217C4_nt3v78Ev();
extern void _ZN9S217C4_nt3v79Ev();
extern void _ZN9S217C4_nt3v80Ev();
extern void _ZN9S217C4_nt3v81Ev();
extern void _ZN9S217C4_nt3v82Ev();
extern void _ZN9S217C4_nt3v83Ev();
extern void _ZN9S217C4_nt3v84Ev();
extern void _ZN9S217C4_nt3v85Ev();
extern void _ZN9S217C4_nt3v86Ev();
extern void _ZN9S217C4_nt3v87Ev();
extern void _ZN9S217C4_nt3v88Ev();
extern void _ZN9S217C4_nt3v89Ev();
extern void _ZN9S217C4_nt3v90Ev();
extern void _ZN9S217C4_nt3v91Ev();
extern void _ZN9S217C4_nt3v92Ev();
extern void _ZN9S217C4_nt3v93Ev();
extern void _ZN9S217C4_nt3v94Ev();
extern void _ZN9S217C4_nt3v95Ev();
extern void _ZN9S217C4_nt3v96Ev();
extern void _ZN9S217C4_nt3v97Ev();
extern void _ZN9S217C4_nt3v98Ev();
extern void _ZN9S217C4_nt3v99Ev();
extern void _ZN9S217C4_nt4v100Ev();
extern void _ZN9S217C4_nt4v101Ev();
extern void _ZN9S217C4_nt4v102Ev();
extern void _ZN9S217C4_nt4v103Ev();
extern void _ZN9S217C4_nt4v104Ev();
extern void _ZN9S217C4_nt4v105Ev();
extern void _ZN9S217C4_nt4v106Ev();
extern void _ZN9S217C4_nt4v107Ev();
extern void _ZN9S217C4_nt4v108Ev();
extern void _ZN9S217C4_nt4v109Ev();
extern void _ZN9S217C4_nt4v110Ev();
extern void _ZN9S217C4_nt4v111Ev();
extern void _ZN9S217C4_nt4v112Ev();
extern void _ZN9S217C4_nt4v113Ev();
extern void _ZN9S217C4_nt4v114Ev();
extern void _ZN9S217C4_nt4v115Ev();
extern void _ZN9S217C4_nt4v116Ev();
extern void _ZN9S217C4_nt4v117Ev();
extern void _ZN9S217C4_nt4v118Ev();
extern void _ZN9S217C4_nt4v119Ev();
extern void _ZN9S217C4_nt4v120Ev();
extern void _ZN9S217C4_nt4v121Ev();
extern void _ZN9S217C4_nt4v122Ev();
extern void _ZN9S217C4_nt4v123Ev();
extern void _ZN9S217C4_nt4v124Ev();
extern void _ZN9S217C4_nt4v125Ev();
extern void _ZN9S217C4_nt4v126Ev();
extern void _ZN9S217C4_nt4v127Ev();
extern void _ZN9S217C4_nt4v128Ev();
extern void _ZN9S217C4_nt4v129Ev();
extern void _ZN9S217C4_nt4v130Ev();
extern void _ZN9S217C4_nt4v131Ev();
extern void _ZN9S217C4_nt4v132Ev();
extern void _ZN9S217C4_nt4v133Ev();
extern void _ZN9S217C4_nt4v134Ev();
extern void _ZN9S217C4_nt4v135Ev();
extern void _ZN9S217C4_nt4v136Ev();
extern void _ZN9S217C4_nt4v137Ev();
extern void _ZN9S217C4_nt4v138Ev();
extern void _ZN9S217C4_nt4v139Ev();
extern void _ZN9S217C4_nt4v140Ev();
extern void _ZN9S217C4_nt4v141Ev();
extern void _ZN9S217C4_nt4v142Ev();
extern void _ZN9S217C4_nt4v143Ev();
extern void _ZN9S217C4_nt4v144Ev();
extern void _ZN9S217C4_nt4v145Ev();
extern void _ZN9S217C3_nt4v146Ev();
extern void _ZN9S217C3_nt4v147Ev();
extern void _ZN9S217C3_nt4v148Ev();
extern void _ZN9S217C3_nt4v149Ev();
extern void _ZN9S217C3_nt4v150Ev();
extern void _ZN9S217C3_nt4v151Ev();
extern void _ZN9S217C3_nt4v152Ev();
extern void _ZN9S217C3_nt4v153Ev();
extern void _ZN9S217C3_nt4v154Ev();
extern void _ZN9S217C3_nt4v155Ev();
extern void _ZN9S217C3_nt4v156Ev();
extern void _ZN9S217C3_nt4v157Ev();
extern void _ZN9S217C3_nt4v158Ev();
extern void _ZN9S217C3_nt4v159Ev();
extern void _ZN9S217C3_nt4v160Ev();
extern void _ZN9S217C3_nt4v161Ev();
extern void _ZN9S217C3_nt4v162Ev();
extern void _ZN9S217C3_nt4v163Ev();
extern void _ZN9S217C3_nt4v164Ev();
extern void _ZN9S217C3_nt4v165Ev();
extern void _ZN9S217C3_nt4v166Ev();
extern void _ZN9S217C3_nt4v167Ev();
extern void _ZN9S217C3_nt4v168Ev();
extern void _ZN9S217C3_nt4v169Ev();
extern void _ZN9S217C3_nt4v170Ev();
extern void _ZN9S217C3_nt4v171Ev();
extern void _ZN9S217C3_nt4v172Ev();
extern void _ZN9S217C3_nt4v173Ev();
extern void _ZN9S217C3_nt4v174Ev();
extern void _ZN9S217C3_nt4v175Ev();
extern void _ZN9S217C3_nt4v176Ev();
extern void _ZN9S217C3_nt4v177Ev();
extern void _ZN9S217C3_nt4v178Ev();
extern void _ZN9S217C3_nt4v179Ev();
extern void _ZN9S217C3_nt4v180Ev();
extern void _ZN9S217C3_nt4v181Ev();
extern void _ZN9S217C3_nt4v182Ev();
extern void _ZN9S217C3_nt4v183Ev();
extern void _ZN9S217C3_nt4v184Ev();
extern void _ZN9S217C3_nt4v185Ev();
extern void _ZN9S217C3_nt4v186Ev();
extern void _ZN9S217C3_nt4v187Ev();
extern void _ZN9S217C3_nt4v188Ev();
extern void _ZN9S217C3_nt4v189Ev();
extern void _ZN9S217C3_nt4v190Ev();
extern void _ZN9S217C3_nt4v191Ev();
extern void _ZN9S217C3_nt4v192Ev();
extern void _ZN9S217C3_nt4v193Ev();
extern void _ZN9S217C3_nt4v194Ev();
extern void _ZN9S217C3_nt4v195Ev();
extern void _ZN9S217C3_nt4v196Ev();
extern void _ZN9S217C3_nt4v197Ev();
extern void _ZN9S217C3_nt4v198Ev();
extern void _ZN9S217C3_nt4v199Ev();
extern void _ZN9S217C3_nt4v200Ev();
extern void _ZN9S217C3_nt4v201Ev();
extern void _ZN9S217C3_nt4v202Ev();
extern void _ZN9S217C3_nt4v203Ev();
extern void _ZN9S217C3_nt4v204Ev();
extern void _ZN9S217C3_nt4v205Ev();
extern void _ZN9S217C3_nt4v206Ev();
extern void _ZN9S217C3_nt4v207Ev();
extern void _ZN9S217C3_nt4v208Ev();
extern void _ZN9S217C3_nt4v209Ev();
extern void _ZN9S217C3_nt4v210Ev();
extern void _ZN9S217C3_nt4v211Ev();
extern void _ZN9S217C3_nt4v212Ev();
extern void _ZN9S217C3_nt4v213Ev();
extern void _ZN9S217C3_nt4v214Ev();
extern void _ZN9S217C2_nt4v215Ev();
extern void _ZN9S217C2_nt4v216Ev();
extern void _ZN9S217C2_nt4v217Ev();
extern void _ZN9S217C2_nt4v218Ev();
extern void _ZN9S217C2_nt4v219Ev();
extern void _ZN9S217C2_nt4v220Ev();
extern void _ZN6S217C12v1Ev();
extern void _ZN6S217C12v2Ev();
extern void _ZN6S217C12v3Ev();
static  VTBL_ENTRY vtc_S217C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S217C1[0]),
  (VTBL_ENTRY)&_ZN6S217C1D1Ev,
  (VTBL_ENTRY)&_ZN6S217C1D0Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v4Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S217C6_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S217C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S217C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S217C4_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v211Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v212Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v213Ev,
  (VTBL_ENTRY)&_ZN9S217C3_nt4v214Ev,
  (VTBL_ENTRY)&_ZN9S217C2_nt4v215Ev,
  (VTBL_ENTRY)&_ZN9S217C2_nt4v216Ev,
  (VTBL_ENTRY)&_ZN9S217C2_nt4v217Ev,
  (VTBL_ENTRY)&_ZN9S217C2_nt4v218Ev,
  (VTBL_ENTRY)&_ZN9S217C2_nt4v219Ev,
  (VTBL_ENTRY)&_ZN9S217C2_nt4v220Ev,
  (VTBL_ENTRY)&_ZN6S217C12v1Ev,
  (VTBL_ENTRY)&_ZN6S217C12v2Ev,
  (VTBL_ENTRY)&_ZN6S217C12v3Ev,
};
extern VTBL_ENTRY _ZTI6S217C1[];
extern  VTBL_ENTRY _ZTV6S217C1[];
Class_Descriptor cd_S217C1 = {  "S217C1", // class name
  bases_S217C1, 5,
  &(vtc_S217C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1288,940), // object size
  NSPAIRA(_ZTI6S217C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S217C1),224, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2216C8_nt  {
  void  mf2216c8(); // _ZN10S2216C8_nt8mf2216c8Ev
};
//SIG(-1 S2216C8_nt) C1{ m}


void  S2216C8_nt ::mf2216c8(){}

//skip512 S2216C8_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2216C6_nt  {
  void *s2216c6f0;
  int s2216c6f1;
  ::S217C31_nt s2216c6f2;
  ::S2216C8_nt s2216c6f3;
  void  mf2216c6(); // _ZN10S2216C6_nt8mf2216c6Ev
};
//SIG(-1 S2216C6_nt) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S2216C6_nt ::mf2216c6(){}

//skip512 S2216C6_nt

#else // __cplusplus

Class_Descriptor cd_S2216C6_nt = {  "S2216C6_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2216C5_nt  : S2216C6_nt {
};
//SIG(-1 S2216C5_nt) C1{ BC2{ m Fp Fi FC3{ m} FC4{ m}}}



//skip512 S2216C5_nt

#else // __cplusplus

extern Class_Descriptor cd_S2216C6_nt;
static Base_Class bases_S2216C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2216C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2216C4_nt  {
  void *s2216c4f0;
  int s2216c4f1;
  ::S2216C5_nt s2216c4f2;
  ::S2216C5_nt s2216c4f3;
  int s2216c4f4;
  virtual  ~S2216C4_nt(); // _ZN10S2216C4_ntD1Ev
  virtual void  v3(); // _ZN10S2216C4_nt2v3Ev
  virtual void  v4(); // _ZN10S2216C4_nt2v4Ev
  virtual void  v5(); // _ZN10S2216C4_nt2v5Ev
  virtual void  v6(); // _ZN10S2216C4_nt2v6Ev
  virtual void  v7(); // _ZN10S2216C4_nt2v7Ev
  virtual void  v8(); // _ZN10S2216C4_nt2v8Ev
  virtual void  v9(); // _ZN10S2216C4_nt2v9Ev
  virtual void  v10(); // _ZN10S2216C4_nt3v10Ev
  virtual void  v11(); // _ZN10S2216C4_nt3v11Ev
  virtual void  v12(); // _ZN10S2216C4_nt3v12Ev
  virtual void  v13(); // _ZN10S2216C4_nt3v13Ev
  virtual void  v14(); // _ZN10S2216C4_nt3v14Ev
  virtual void  v15(); // _ZN10S2216C4_nt3v15Ev
  virtual void  v16(); // _ZN10S2216C4_nt3v16Ev
  virtual void  v17(); // _ZN10S2216C4_nt3v17Ev
  virtual void  v18(); // _ZN10S2216C4_nt3v18Ev
  virtual void  v19(); // _ZN10S2216C4_nt3v19Ev
  virtual void  v20(); // _ZN10S2216C4_nt3v20Ev
  virtual void  v21(); // _ZN10S2216C4_nt3v21Ev
  virtual void  v22(); // _ZN10S2216C4_nt3v22Ev
  virtual void  v23(); // _ZN10S2216C4_nt3v23Ev
  virtual void  v24(); // _ZN10S2216C4_nt3v24Ev
  virtual void  v25(); // _ZN10S2216C4_nt3v25Ev
  S2216C4_nt(); // tgen
};
//SIG(-1 S2216C4_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC2{ BC3{ m Fp Fi FC4{ m} FC5{ m}}} FC2 Fi}


 S2216C4_nt ::~S2216C4_nt(){ note_dtor("S2216C4_nt", this);}
void  S2216C4_nt ::v3(){vfunc_called(this, "_ZN10S2216C4_nt2v3Ev");}
void  S2216C4_nt ::v4(){vfunc_called(this, "_ZN10S2216C4_nt2v4Ev");}
void  S2216C4_nt ::v5(){vfunc_called(this, "_ZN10S2216C4_nt2v5Ev");}
void  S2216C4_nt ::v6(){vfunc_called(this, "_ZN10S2216C4_nt2v6Ev");}
void  S2216C4_nt ::v7(){vfunc_called(this, "_ZN10S2216C4_nt2v7Ev");}
void  S2216C4_nt ::v8(){vfunc_called(this, "_ZN10S2216C4_nt2v8Ev");}
void  S2216C4_nt ::v9(){vfunc_called(this, "_ZN10S2216C4_nt2v9Ev");}
void  S2216C4_nt ::v10(){vfunc_called(this, "_ZN10S2216C4_nt3v10Ev");}
void  S2216C4_nt ::v11(){vfunc_called(this, "_ZN10S2216C4_nt3v11Ev");}
void  S2216C4_nt ::v12(){vfunc_called(this, "_ZN10S2216C4_nt3v12Ev");}
void  S2216C4_nt ::v13(){vfunc_called(this, "_ZN10S2216C4_nt3v13Ev");}
void  S2216C4_nt ::v14(){vfunc_called(this, "_ZN10S2216C4_nt3v14Ev");}
void  S2216C4_nt ::v15(){vfunc_called(this, "_ZN10S2216C4_nt3v15Ev");}
void  S2216C4_nt ::v16(){vfunc_called(this, "_ZN10S2216C4_nt3v16Ev");}
void  S2216C4_nt ::v17(){vfunc_called(this, "_ZN10S2216C4_nt3v17Ev");}
void  S2216C4_nt ::v18(){vfunc_called(this, "_ZN10S2216C4_nt3v18Ev");}
void  S2216C4_nt ::v19(){vfunc_called(this, "_ZN10S2216C4_nt3v19Ev");}
void  S2216C4_nt ::v20(){vfunc_called(this, "_ZN10S2216C4_nt3v20Ev");}
void  S2216C4_nt ::v21(){vfunc_called(this, "_ZN10S2216C4_nt3v21Ev");}
void  S2216C4_nt ::v22(){vfunc_called(this, "_ZN10S2216C4_nt3v22Ev");}
void  S2216C4_nt ::v23(){vfunc_called(this, "_ZN10S2216C4_nt3v23Ev");}
void  S2216C4_nt ::v24(){vfunc_called(this, "_ZN10S2216C4_nt3v24Ev");}
void  S2216C4_nt ::v25(){vfunc_called(this, "_ZN10S2216C4_nt3v25Ev");}
S2216C4_nt ::S2216C4_nt(){ note_ctor("S2216C4_nt", this);} // tgen

//skip512 S2216C4_nt

#else // __cplusplus

extern void _ZN10S2216C4_ntC1Ev();
extern void _ZN10S2216C4_ntD1Ev();
Name_Map name_map_S2216C4_nt[] = {
  NSPAIR(_ZN10S2216C4_ntC1Ev),
  NSPAIR(_ZN10S2216C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S2216C4_nt[];
extern void _ZN10S2216C4_ntD1Ev();
extern void _ZN10S2216C4_ntD0Ev();
extern void _ZN10S2216C4_nt2v3Ev();
extern void _ZN10S2216C4_nt2v4Ev();
extern void _ZN10S2216C4_nt2v5Ev();
extern void _ZN10S2216C4_nt2v6Ev();
extern void _ZN10S2216C4_nt2v7Ev();
extern void _ZN10S2216C4_nt2v8Ev();
extern void _ZN10S2216C4_nt2v9Ev();
extern void _ZN10S2216C4_nt3v10Ev();
extern void _ZN10S2216C4_nt3v11Ev();
extern void _ZN10S2216C4_nt3v12Ev();
extern void _ZN10S2216C4_nt3v13Ev();
extern void _ZN10S2216C4_nt3v14Ev();
extern void _ZN10S2216C4_nt3v15Ev();
extern void _ZN10S2216C4_nt3v16Ev();
extern void _ZN10S2216C4_nt3v17Ev();
extern void _ZN10S2216C4_nt3v18Ev();
extern void _ZN10S2216C4_nt3v19Ev();
extern void _ZN10S2216C4_nt3v20Ev();
extern void _ZN10S2216C4_nt3v21Ev();
extern void _ZN10S2216C4_nt3v22Ev();
extern void _ZN10S2216C4_nt3v23Ev();
extern void _ZN10S2216C4_nt3v24Ev();
extern void _ZN10S2216C4_nt3v25Ev();
static  VTBL_ENTRY vtc_S2216C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2216C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S2216C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v25Ev,
};
extern VTBL_ENTRY _ZTI10S2216C4_nt[];
VTBL_ENTRY *P__ZTI10S2216C4_nt = _ZTI10S2216C4_nt; 
extern  VTBL_ENTRY _ZTV10S2216C4_nt[];
Class_Descriptor cd_S2216C4_nt = {  "S2216C4_nt", // class name
  0,0,//no base classes
  &(vtc_S2216C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI10S2216C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S2216C4_nt),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2216C14_nt  {
  __tsi64 s2216c14f0[2];
  void  mf2216c14(); // _ZN11S2216C14_nt9mf2216c14Ev
};
//SIG(-1 S2216C14_nt) C1{ m FL[2]}


void  S2216C14_nt ::mf2216c14(){}

//skip512 S2216C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2216C13_nt  {
  ::S2216C14_nt s2216c13f0;
  void  mf2216c13(); // _ZN11S2216C13_nt9mf2216c13Ev
};
//SIG(-1 S2216C13_nt) C1{ m FC2{ m FL[2]}}


void  S2216C13_nt ::mf2216c13(){}

//skip512 S2216C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2216C17_nt  {
  ::S2216C13_nt s2216c17f0;
  void  mf2216c17(); // _ZN11S2216C17_nt9mf2216c17Ev
};
//SIG(-1 S2216C17_nt) C1{ m FC2{ m FC3{ m FL[2]}}}


void  S2216C17_nt ::mf2216c17(){}

//skip512 S2216C17_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2216C18_nt  {
  ::S2216C13_nt s2216c18f0;
  ::S2216C13_nt s2216c18f1;
  ::S2216C13_nt s2216c18f2;
  ::S2216C13_nt s2216c18f3;
  void  mf2216c18(); // _ZN11S2216C18_nt9mf2216c18Ev
};
//SIG(-1 S2216C18_nt) C1{ m FC2{ m FC3{ m FL[2]}} FC2 FC2 FC2}


void  S2216C18_nt ::mf2216c18(){}

//skip512 S2216C18_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2216C20_nt  {
  void *s2216c20f0;
  int s2216c20f1;
  ::S2216C8_nt s2216c20f2;
  void  mf2216c20(); // _ZN11S2216C20_nt9mf2216c20Ev
};
//SIG(-1 S2216C20_nt) C1{ m Fp Fi FC2{ m}}


void  S2216C20_nt ::mf2216c20(){}

//skip512 S2216C20_nt

#else // __cplusplus

Class_Descriptor cd_S2216C20_nt = {  "S2216C20_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2216C19_nt  {
  ::S2216C20_nt s2216c19f0;
  int s2216c19f1;
  void  mf2216c19(); // _ZN11S2216C19_nt9mf2216c19Ev
};
//SIG(-1 S2216C19_nt) C1{ m FC2{ m Fp Fi FC3{ m}} Fi}


void  S2216C19_nt ::mf2216c19(){}

//skip512 S2216C19_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2216C23  {
  void  mf2216c23(); // _ZN8S2216C239mf2216c23Ev
};
//SIG(-1 S2216C23) C1{ m}


void  S2216C23 ::mf2216c23(){}

static void Test_S2216C23()
{
  {
    init_simple_test("S2216C23");
    S2216C23 lv;
    check2(sizeof(lv), 1, "sizeof(S2216C23)");
    check2(__alignof__(lv), 1, "__alignof__(S2216C23)");
  }
}
static Arrange_To_Call_Me vS2216C23(Test_S2216C23, "S2216C23", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2216C22  {
  void *s2216c22f0;
  int s2216c22f1;
  ::S2216C23 s2216c22f2;
  ::S2216C23 s2216c22f3;
  void  mf2216c22(); // _ZN8S2216C229mf2216c22Ev
};
//SIG(-1 S2216C22) C1{ m Fp Fi FC2{ m} FC2}


void  S2216C22 ::mf2216c22(){}

static void Test_S2216C22()
{
  {
    init_simple_test("S2216C22");
    S2216C22 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2216C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2216C22)");
    check_field_offset(lv, s2216c22f0, 0, "S2216C22.s2216c22f0");
    check_field_offset(lv, s2216c22f1, ABISELECT(8,4), "S2216C22.s2216c22f1");
    check_field_offset(lv, s2216c22f2, ABISELECT(12,8), "S2216C22.s2216c22f2");
    check_field_offset(lv, s2216c22f3, ABISELECT(13,9), "S2216C22.s2216c22f3");
  }
}
static Arrange_To_Call_Me vS2216C22(Test_S2216C22, "S2216C22", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2216C27  {
  void  mf2216c27(); // _ZN8S2216C279mf2216c27Ev
};
//SIG(-1 S2216C27) C1{ m}


void  S2216C27 ::mf2216c27(){}

static void Test_S2216C27()
{
  {
    init_simple_test("S2216C27");
    S2216C27 lv;
    check2(sizeof(lv), 1, "sizeof(S2216C27)");
    check2(__alignof__(lv), 1, "__alignof__(S2216C27)");
  }
}
static Arrange_To_Call_Me vS2216C27(Test_S2216C27, "S2216C27", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2216C26  {
  void *s2216c26f0;
  int s2216c26f1;
  ::S2216C27 s2216c26f2;
  ::S2216C27 s2216c26f3;
  void  mf2216c26(); // _ZN8S2216C269mf2216c26Ev
};
//SIG(-1 S2216C26) C1{ m Fp Fi FC2{ m} FC2}


void  S2216C26 ::mf2216c26(){}

static void Test_S2216C26()
{
  {
    init_simple_test("S2216C26");
    S2216C26 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2216C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2216C26)");
    check_field_offset(lv, s2216c26f0, 0, "S2216C26.s2216c26f0");
    check_field_offset(lv, s2216c26f1, ABISELECT(8,4), "S2216C26.s2216c26f1");
    check_field_offset(lv, s2216c26f2, ABISELECT(12,8), "S2216C26.s2216c26f2");
    check_field_offset(lv, s2216c26f3, ABISELECT(13,9), "S2216C26.s2216c26f3");
  }
}
static Arrange_To_Call_Me vS2216C26(Test_S2216C26, "S2216C26", ABISELECT(16,12));

#else // __cplusplus

Class_Descriptor cd_S2216C26 = {  "S2216C26", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2216C25  : S2216C26 {
};
//SIG(-1 S2216C25) C1{ BC2{ m Fp Fi FC3{ m} FC3}}



static void Test_S2216C25()
{
  extern Class_Descriptor cd_S2216C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S2216C25, buf);
    S2216C25 &lv = *(new (buf) S2216C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2216C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2216C25)");
    check_base_class_offset(lv, (S2216C26*), 0, "S2216C25");
    test_class_info(&lv, &cd_S2216C25);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2216C25(Test_S2216C25, "S2216C25", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S2216C26;
static Base_Class bases_S2216C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2216C26,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S2216C25 = {  "S2216C25", // class name
  bases_S2216C25, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2216C30  {
  void  mf2216c30(); // _ZN8S2216C309mf2216c30Ev
};
//SIG(-1 S2216C30) C1{ m}


void  S2216C30 ::mf2216c30(){}

static void Test_S2216C30()
{
  {
    init_simple_test("S2216C30");
    S2216C30 lv;
    check2(sizeof(lv), 1, "sizeof(S2216C30)");
    check2(__alignof__(lv), 1, "__alignof__(S2216C30)");
  }
}
static Arrange_To_Call_Me vS2216C30(Test_S2216C30, "S2216C30", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S2216C30[];
VTBL_ENTRY *P__ZTI8S2216C30 = _ZTI8S2216C30; 
Class_Descriptor cd_S2216C30 = {  "S2216C30", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S2216C30),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2216C29_nt  {
  void *s2216c29f0;
  int s2216c29f1[2];
  ::S2216C30 s2216c29f2;
  void  mf2216c29(); // _ZN11S2216C29_nt9mf2216c29Ev
};
//SIG(-1 S2216C29_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S2216C29_nt ::mf2216c29(){}

//skip512 S2216C29_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2216C37  {
  void *s2216c37f0;
  int s2216c37f1[2];
  ::S2216C30 s2216c37f2;
  void  mf2216c37(); // _ZN8S2216C379mf2216c37Ev
};
//SIG(-1 S2216C37) C1{ m Fp Fi[2] FC2{ m}}


void  S2216C37 ::mf2216c37(){}

static void Test_S2216C37()
{
  {
    init_simple_test("S2216C37");
    S2216C37 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S2216C37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2216C37)");
    check_field_offset(lv, s2216c37f0, 0, "S2216C37.s2216c37f0");
    check_field_offset(lv, s2216c37f1, ABISELECT(8,4), "S2216C37.s2216c37f1");
    check_field_offset(lv, s2216c37f2, ABISELECT(16,12), "S2216C37.s2216c37f2");
  }
}
static Arrange_To_Call_Me vS2216C37(Test_S2216C37, "S2216C37", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2216C3_nt  : S2216C4_nt {
  ::S2216C13_nt s2216c3f0;
  ::S2216C13_nt s2216c3f1;
  ::S2216C13_nt s2216c3f2;
  ::S2216C13_nt s2216c3f3;
  ::S2216C17_nt s2216c3f4;
  ::S2216C18_nt s2216c3f5;
  ::S2216C18_nt s2216c3f6;
  ::S2216C13_nt s2216c3f7;
  ::S2216C13_nt s2216c3f8;
  ::S2216C13_nt s2216c3f9;
  void *s2216c3f10;
  ::S2216C17_nt s2216c3f11;
  ::S2216C19_nt s2216c3f12;
  int s2216c3f13;
  void *s2216c3f14[7];
  ::S2216C22 s2216c3f15;
  int s2216c3f16:8;
  int s2216c3f17:8;
  int s2216c3f18:16;
  int s2216c3f19:16;
  int s2216c3f20:8;
  int s2216c3f21:8;
  int s2216c3f22:8;
  int s2216c3f23:32;
  int s2216c3f24:8;
  int s2216c3f25:4;
  int s2216c3f26:4;
  int s2216c3f27:4;
  int s2216c3f28:4;
  int s2216c3f29:4;
  int s2216c3f30:4;
  int s2216c3f31:4;
  int s2216c3f32:4;
  int s2216c3f33:4;
  int s2216c3f34:4;
  unsigned char s2216c3f35:1;
  unsigned char s2216c3f36:1;
  unsigned char s2216c3f37:1;
  unsigned char s2216c3f38:1;
  unsigned char s2216c3f39:1;
  unsigned char s2216c3f40:1;
  unsigned char s2216c3f41:1;
  unsigned char s2216c3f42:1;
  unsigned char s2216c3f43:1;
  unsigned char s2216c3f44:1;
  unsigned char s2216c3f45:1;
  unsigned char s2216c3f46:1;
  unsigned char s2216c3f47:1;
  unsigned char s2216c3f48:1;
  unsigned char s2216c3f49:1;
  unsigned char s2216c3f50:1;
  unsigned char s2216c3f51:1;
  unsigned char s2216c3f52:1;
  unsigned char s2216c3f53:1;
  unsigned char s2216c3f54:1;
  unsigned char s2216c3f55:1;
  unsigned char s2216c3f56:1;
  unsigned char s2216c3f57:1;
  unsigned char s2216c3f58:1;
  unsigned char s2216c3f59:1;
  unsigned char s2216c3f60:1;
  unsigned char s2216c3f61:1;
  unsigned char s2216c3f62:1;
  unsigned char s2216c3f63:1;
  unsigned char s2216c3f64:1;
  unsigned char s2216c3f65:1;
  unsigned char s2216c3f66:1;
  unsigned char s2216c3f67:1;
  unsigned char s2216c3f68:1;
  unsigned char s2216c3f69:1;
  unsigned char s2216c3f70:1;
  unsigned char s2216c3f71:1;
  unsigned char s2216c3f72:1;
  unsigned char s2216c3f73:1;
  unsigned char s2216c3f74:1;
  unsigned char s2216c3f75:1;
  int s2216c3f76[7];
  void *s2216c3f77[6];
  int s2216c3f78:8;
  int s2216c3f79:8;
  int s2216c3f80:8;
  int s2216c3f81:8;
  int s2216c3f82:8;
  int s2216c3f83:8;
  ::S2216C25 s2216c3f84;
  void *s2216c3f85[4];
  int s2216c3f86:8;
  int s2216c3f87:8;
  int s2216c3f88:8;
  int s2216c3f89:8;
  int s2216c3f90:8;
  int s2216c3f91:16;
  int s2216c3f92:16;
  int s2216c3f93:16;
  int s2216c3f94:4;
  int s2216c3f95:4;
  int s2216c3f96:4;
  int s2216c3f97:4;
  int s2216c3f98:4;
  int s2216c3f99:4;
  int s2216c3f100:4;
  int s2216c3f101:4;
  int s2216c3f102:4;
  int s2216c3f103:4;
  int s2216c3f104:4;
  int s2216c3f105:4;
  int s2216c3f106:8;
  int s2216c3f107:8;
  int s2216c3f108:8;
  void *s2216c3f109[7];
  ::S2216C29_nt s2216c3f110;
  void *s2216c3f111[2];
  int s2216c3f112:16;
  int s2216c3f113:16;
  ::S2216C25 s2216c3f114;
  ::S2216C29_nt s2216c3f115;
  ::S2216C37 s2216c3f116;
  void *s2216c3f117[2];
  int s2216c3f118:24;
  int s2216c3f119:8;
  void *s2216c3f120;
  virtual  ~S2216C3_nt(); // _ZN10S2216C3_ntD1Ev
  virtual void  v26(); // _ZN10S2216C3_nt3v26Ev
  virtual void  v27(); // _ZN10S2216C3_nt3v27Ev
  virtual void  v28(); // _ZN10S2216C3_nt3v28Ev
  virtual void  v29(); // _ZN10S2216C3_nt3v29Ev
  virtual void  v30(); // _ZN10S2216C3_nt3v30Ev
  virtual void  v31(); // _ZN10S2216C3_nt3v31Ev
  virtual void  v32(); // _ZN10S2216C3_nt3v32Ev
  virtual void  v33(); // _ZN10S2216C3_nt3v33Ev
  virtual void  v34(); // _ZN10S2216C3_nt3v34Ev
  virtual void  v35(); // _ZN10S2216C3_nt3v35Ev
  virtual void  v36(); // _ZN10S2216C3_nt3v36Ev
  virtual void  v37(); // _ZN10S2216C3_nt3v37Ev
  virtual void  v38(); // _ZN10S2216C3_nt3v38Ev
  virtual void  v39(); // _ZN10S2216C3_nt3v39Ev
  virtual void  v40(); // _ZN10S2216C3_nt3v40Ev
  virtual void  v41(); // _ZN10S2216C3_nt3v41Ev
  virtual void  v42(); // _ZN10S2216C3_nt3v42Ev
  virtual void  v43(); // _ZN10S2216C3_nt3v43Ev
  virtual void  v44(); // _ZN10S2216C3_nt3v44Ev
  virtual void  v45(); // _ZN10S2216C3_nt3v45Ev
  virtual void  v46(); // _ZN10S2216C3_nt3v46Ev
  virtual void  v47(); // _ZN10S2216C3_nt3v47Ev
  virtual void  v48(); // _ZN10S2216C3_nt3v48Ev
  virtual void  v49(); // _ZN10S2216C3_nt3v49Ev
  virtual void  v50(); // _ZN10S2216C3_nt3v50Ev
  virtual void  v51(); // _ZN10S2216C3_nt3v51Ev
  virtual void  v52(); // _ZN10S2216C3_nt3v52Ev
  virtual void  v53(); // _ZN10S2216C3_nt3v53Ev
  virtual void  v54(); // _ZN10S2216C3_nt3v54Ev
  virtual void  v55(); // _ZN10S2216C3_nt3v55Ev
  virtual void  v56(); // _ZN10S2216C3_nt3v56Ev
  virtual void  v57(); // _ZN10S2216C3_nt3v57Ev
  virtual void  v58(); // _ZN10S2216C3_nt3v58Ev
  virtual void  v59(); // _ZN10S2216C3_nt3v59Ev
  virtual void  v60(); // _ZN10S2216C3_nt3v60Ev
  virtual void  v61(); // _ZN10S2216C3_nt3v61Ev
  virtual void  v62(); // _ZN10S2216C3_nt3v62Ev
  virtual void  v63(); // _ZN10S2216C3_nt3v63Ev
  virtual void  v64(); // _ZN10S2216C3_nt3v64Ev
  virtual void  v65(); // _ZN10S2216C3_nt3v65Ev
  virtual void  v66(); // _ZN10S2216C3_nt3v66Ev
  virtual void  v67(); // _ZN10S2216C3_nt3v67Ev
  virtual void  v68(); // _ZN10S2216C3_nt3v68Ev
  virtual void  v69(); // _ZN10S2216C3_nt3v69Ev
  virtual void  v70(); // _ZN10S2216C3_nt3v70Ev
  virtual void  v71(); // _ZN10S2216C3_nt3v71Ev
  virtual void  v72(); // _ZN10S2216C3_nt3v72Ev
  virtual void  v73(); // _ZN10S2216C3_nt3v73Ev
  virtual void  v74(); // _ZN10S2216C3_nt3v74Ev
  virtual void  v75(); // _ZN10S2216C3_nt3v75Ev
  virtual void  v76(); // _ZN10S2216C3_nt3v76Ev
  virtual void  v77(); // _ZN10S2216C3_nt3v77Ev
  virtual void  v78(); // _ZN10S2216C3_nt3v78Ev
  virtual void  v79(); // _ZN10S2216C3_nt3v79Ev
  virtual void  v80(); // _ZN10S2216C3_nt3v80Ev
  virtual void  v81(); // _ZN10S2216C3_nt3v81Ev
  virtual void  v82(); // _ZN10S2216C3_nt3v82Ev
  virtual void  v83(); // _ZN10S2216C3_nt3v83Ev
  virtual void  v84(); // _ZN10S2216C3_nt3v84Ev
  virtual void  v85(); // _ZN10S2216C3_nt3v85Ev
  virtual void  v86(); // _ZN10S2216C3_nt3v86Ev
  virtual void  v87(); // _ZN10S2216C3_nt3v87Ev
  virtual void  v88(); // _ZN10S2216C3_nt3v88Ev
  virtual void  v89(); // _ZN10S2216C3_nt3v89Ev
  virtual void  v90(); // _ZN10S2216C3_nt3v90Ev
  virtual void  v91(); // _ZN10S2216C3_nt3v91Ev
  virtual void  v92(); // _ZN10S2216C3_nt3v92Ev
  virtual void  v93(); // _ZN10S2216C3_nt3v93Ev
  virtual void  v94(); // _ZN10S2216C3_nt3v94Ev
  virtual void  v95(); // _ZN10S2216C3_nt3v95Ev
  virtual void  v96(); // _ZN10S2216C3_nt3v96Ev
  virtual void  v97(); // _ZN10S2216C3_nt3v97Ev
  virtual void  v98(); // _ZN10S2216C3_nt3v98Ev
  virtual void  v99(); // _ZN10S2216C3_nt3v99Ev
  virtual void  v100(); // _ZN10S2216C3_nt4v100Ev
  virtual void  v101(); // _ZN10S2216C3_nt4v101Ev
  virtual void  v102(); // _ZN10S2216C3_nt4v102Ev
  virtual void  v103(); // _ZN10S2216C3_nt4v103Ev
  S2216C3_nt(); // tgen
};
//SIG(-1 S2216C3_nt) C1{ BC2{ vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fp Fi FC3{ BC4{ m Fp Fi FC5{ m} FC6{ m}}} FC3 Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 FC7{ m FC8{ m FL[2]}} FC7 FC7 FC7 FC9{ m FC7} FC10{ m FC7 FC7 FC7 FC7} FC10 FC7 FC7 FC7 Fp FC9 FC11{ m FC12{ m Fp Fi FC6} Fi} Fi Fp[7] FC13{ m Fp Fi FC14{ m} FC14} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC15{ BC16{ m Fp Fi FC17{ m} FC17}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC18{ m Fp Fi[2] FC19{ m}} Fp[2] Fi:16 Fi:16 FC15 FC18 FC20{ m Fp Fi[2] FC19} Fp[2] Fi:24 Fi:8 Fp}


 S2216C3_nt ::~S2216C3_nt(){ note_dtor("S2216C3_nt", this);}
void  S2216C3_nt ::v26(){vfunc_called(this, "_ZN10S2216C3_nt3v26Ev");}
void  S2216C3_nt ::v27(){vfunc_called(this, "_ZN10S2216C3_nt3v27Ev");}
void  S2216C3_nt ::v28(){vfunc_called(this, "_ZN10S2216C3_nt3v28Ev");}
void  S2216C3_nt ::v29(){vfunc_called(this, "_ZN10S2216C3_nt3v29Ev");}
void  S2216C3_nt ::v30(){vfunc_called(this, "_ZN10S2216C3_nt3v30Ev");}
void  S2216C3_nt ::v31(){vfunc_called(this, "_ZN10S2216C3_nt3v31Ev");}
void  S2216C3_nt ::v32(){vfunc_called(this, "_ZN10S2216C3_nt3v32Ev");}
void  S2216C3_nt ::v33(){vfunc_called(this, "_ZN10S2216C3_nt3v33Ev");}
void  S2216C3_nt ::v34(){vfunc_called(this, "_ZN10S2216C3_nt3v34Ev");}
void  S2216C3_nt ::v35(){vfunc_called(this, "_ZN10S2216C3_nt3v35Ev");}
void  S2216C3_nt ::v36(){vfunc_called(this, "_ZN10S2216C3_nt3v36Ev");}
void  S2216C3_nt ::v37(){vfunc_called(this, "_ZN10S2216C3_nt3v37Ev");}
void  S2216C3_nt ::v38(){vfunc_called(this, "_ZN10S2216C3_nt3v38Ev");}
void  S2216C3_nt ::v39(){vfunc_called(this, "_ZN10S2216C3_nt3v39Ev");}
void  S2216C3_nt ::v40(){vfunc_called(this, "_ZN10S2216C3_nt3v40Ev");}
void  S2216C3_nt ::v41(){vfunc_called(this, "_ZN10S2216C3_nt3v41Ev");}
void  S2216C3_nt ::v42(){vfunc_called(this, "_ZN10S2216C3_nt3v42Ev");}
void  S2216C3_nt ::v43(){vfunc_called(this, "_ZN10S2216C3_nt3v43Ev");}
void  S2216C3_nt ::v44(){vfunc_called(this, "_ZN10S2216C3_nt3v44Ev");}
void  S2216C3_nt ::v45(){vfunc_called(this, "_ZN10S2216C3_nt3v45Ev");}
void  S2216C3_nt ::v46(){vfunc_called(this, "_ZN10S2216C3_nt3v46Ev");}
void  S2216C3_nt ::v47(){vfunc_called(this, "_ZN10S2216C3_nt3v47Ev");}
void  S2216C3_nt ::v48(){vfunc_called(this, "_ZN10S2216C3_nt3v48Ev");}
void  S2216C3_nt ::v49(){vfunc_called(this, "_ZN10S2216C3_nt3v49Ev");}
void  S2216C3_nt ::v50(){vfunc_called(this, "_ZN10S2216C3_nt3v50Ev");}
void  S2216C3_nt ::v51(){vfunc_called(this, "_ZN10S2216C3_nt3v51Ev");}
void  S2216C3_nt ::v52(){vfunc_called(this, "_ZN10S2216C3_nt3v52Ev");}
void  S2216C3_nt ::v53(){vfunc_called(this, "_ZN10S2216C3_nt3v53Ev");}
void  S2216C3_nt ::v54(){vfunc_called(this, "_ZN10S2216C3_nt3v54Ev");}
void  S2216C3_nt ::v55(){vfunc_called(this, "_ZN10S2216C3_nt3v55Ev");}
void  S2216C3_nt ::v56(){vfunc_called(this, "_ZN10S2216C3_nt3v56Ev");}
void  S2216C3_nt ::v57(){vfunc_called(this, "_ZN10S2216C3_nt3v57Ev");}
void  S2216C3_nt ::v58(){vfunc_called(this, "_ZN10S2216C3_nt3v58Ev");}
void  S2216C3_nt ::v59(){vfunc_called(this, "_ZN10S2216C3_nt3v59Ev");}
void  S2216C3_nt ::v60(){vfunc_called(this, "_ZN10S2216C3_nt3v60Ev");}
void  S2216C3_nt ::v61(){vfunc_called(this, "_ZN10S2216C3_nt3v61Ev");}
void  S2216C3_nt ::v62(){vfunc_called(this, "_ZN10S2216C3_nt3v62Ev");}
void  S2216C3_nt ::v63(){vfunc_called(this, "_ZN10S2216C3_nt3v63Ev");}
void  S2216C3_nt ::v64(){vfunc_called(this, "_ZN10S2216C3_nt3v64Ev");}
void  S2216C3_nt ::v65(){vfunc_called(this, "_ZN10S2216C3_nt3v65Ev");}
void  S2216C3_nt ::v66(){vfunc_called(this, "_ZN10S2216C3_nt3v66Ev");}
void  S2216C3_nt ::v67(){vfunc_called(this, "_ZN10S2216C3_nt3v67Ev");}
void  S2216C3_nt ::v68(){vfunc_called(this, "_ZN10S2216C3_nt3v68Ev");}
void  S2216C3_nt ::v69(){vfunc_called(this, "_ZN10S2216C3_nt3v69Ev");}
void  S2216C3_nt ::v70(){vfunc_called(this, "_ZN10S2216C3_nt3v70Ev");}
void  S2216C3_nt ::v71(){vfunc_called(this, "_ZN10S2216C3_nt3v71Ev");}
void  S2216C3_nt ::v72(){vfunc_called(this, "_ZN10S2216C3_nt3v72Ev");}
void  S2216C3_nt ::v73(){vfunc_called(this, "_ZN10S2216C3_nt3v73Ev");}
void  S2216C3_nt ::v74(){vfunc_called(this, "_ZN10S2216C3_nt3v74Ev");}
void  S2216C3_nt ::v75(){vfunc_called(this, "_ZN10S2216C3_nt3v75Ev");}
void  S2216C3_nt ::v76(){vfunc_called(this, "_ZN10S2216C3_nt3v76Ev");}
void  S2216C3_nt ::v77(){vfunc_called(this, "_ZN10S2216C3_nt3v77Ev");}
void  S2216C3_nt ::v78(){vfunc_called(this, "_ZN10S2216C3_nt3v78Ev");}
void  S2216C3_nt ::v79(){vfunc_called(this, "_ZN10S2216C3_nt3v79Ev");}
void  S2216C3_nt ::v80(){vfunc_called(this, "_ZN10S2216C3_nt3v80Ev");}
void  S2216C3_nt ::v81(){vfunc_called(this, "_ZN10S2216C3_nt3v81Ev");}
void  S2216C3_nt ::v82(){vfunc_called(this, "_ZN10S2216C3_nt3v82Ev");}
void  S2216C3_nt ::v83(){vfunc_called(this, "_ZN10S2216C3_nt3v83Ev");}
void  S2216C3_nt ::v84(){vfunc_called(this, "_ZN10S2216C3_nt3v84Ev");}
void  S2216C3_nt ::v85(){vfunc_called(this, "_ZN10S2216C3_nt3v85Ev");}
void  S2216C3_nt ::v86(){vfunc_called(this, "_ZN10S2216C3_nt3v86Ev");}
void  S2216C3_nt ::v87(){vfunc_called(this, "_ZN10S2216C3_nt3v87Ev");}
void  S2216C3_nt ::v88(){vfunc_called(this, "_ZN10S2216C3_nt3v88Ev");}
void  S2216C3_nt ::v89(){vfunc_called(this, "_ZN10S2216C3_nt3v89Ev");}
void  S2216C3_nt ::v90(){vfunc_called(this, "_ZN10S2216C3_nt3v90Ev");}
void  S2216C3_nt ::v91(){vfunc_called(this, "_ZN10S2216C3_nt3v91Ev");}
void  S2216C3_nt ::v92(){vfunc_called(this, "_ZN10S2216C3_nt3v92Ev");}
void  S2216C3_nt ::v93(){vfunc_called(this, "_ZN10S2216C3_nt3v93Ev");}
void  S2216C3_nt ::v94(){vfunc_called(this, "_ZN10S2216C3_nt3v94Ev");}
void  S2216C3_nt ::v95(){vfunc_called(this, "_ZN10S2216C3_nt3v95Ev");}
void  S2216C3_nt ::v96(){vfunc_called(this, "_ZN10S2216C3_nt3v96Ev");}
void  S2216C3_nt ::v97(){vfunc_called(this, "_ZN10S2216C3_nt3v97Ev");}
void  S2216C3_nt ::v98(){vfunc_called(this, "_ZN10S2216C3_nt3v98Ev");}
void  S2216C3_nt ::v99(){vfunc_called(this, "_ZN10S2216C3_nt3v99Ev");}
void  S2216C3_nt ::v100(){vfunc_called(this, "_ZN10S2216C3_nt4v100Ev");}
void  S2216C3_nt ::v101(){vfunc_called(this, "_ZN10S2216C3_nt4v101Ev");}
void  S2216C3_nt ::v102(){vfunc_called(this, "_ZN10S2216C3_nt4v102Ev");}
void  S2216C3_nt ::v103(){vfunc_called(this, "_ZN10S2216C3_nt4v103Ev");}
S2216C3_nt ::S2216C3_nt(){ note_ctor("S2216C3_nt", this);} // tgen

//skip512 S2216C3_nt

#else // __cplusplus

extern void _ZN10S2216C3_ntC1Ev();
extern void _ZN10S2216C3_ntD1Ev();
Name_Map name_map_S2216C3_nt[] = {
  NSPAIR(_ZN10S2216C3_ntC1Ev),
  NSPAIR(_ZN10S2216C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2216C4_nt;
extern VTBL_ENTRY _ZTI10S2216C4_nt[];
extern  VTBL_ENTRY _ZTV10S2216C4_nt[];
static Base_Class bases_S2216C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2216C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S2216C3_nt[];
extern void _ZN10S2216C3_ntD1Ev();
extern void _ZN10S2216C3_ntD0Ev();
extern void _ZN10S2216C4_nt2v3Ev();
extern void _ZN10S2216C4_nt2v4Ev();
extern void _ZN10S2216C4_nt2v5Ev();
extern void _ZN10S2216C4_nt2v6Ev();
extern void _ZN10S2216C4_nt2v7Ev();
extern void _ZN10S2216C4_nt2v8Ev();
extern void _ZN10S2216C4_nt2v9Ev();
extern void _ZN10S2216C4_nt3v10Ev();
extern void _ZN10S2216C4_nt3v11Ev();
extern void _ZN10S2216C4_nt3v12Ev();
extern void _ZN10S2216C4_nt3v13Ev();
extern void _ZN10S2216C4_nt3v14Ev();
extern void _ZN10S2216C4_nt3v15Ev();
extern void _ZN10S2216C4_nt3v16Ev();
extern void _ZN10S2216C4_nt3v17Ev();
extern void _ZN10S2216C4_nt3v18Ev();
extern void _ZN10S2216C4_nt3v19Ev();
extern void _ZN10S2216C4_nt3v20Ev();
extern void _ZN10S2216C4_nt3v21Ev();
extern void _ZN10S2216C4_nt3v22Ev();
extern void _ZN10S2216C4_nt3v23Ev();
extern void _ZN10S2216C4_nt3v24Ev();
extern void _ZN10S2216C4_nt3v25Ev();
extern void _ZN10S2216C3_nt3v26Ev();
extern void _ZN10S2216C3_nt3v27Ev();
extern void _ZN10S2216C3_nt3v28Ev();
extern void _ZN10S2216C3_nt3v29Ev();
extern void _ZN10S2216C3_nt3v30Ev();
extern void _ZN10S2216C3_nt3v31Ev();
extern void _ZN10S2216C3_nt3v32Ev();
extern void _ZN10S2216C3_nt3v33Ev();
extern void _ZN10S2216C3_nt3v34Ev();
extern void _ZN10S2216C3_nt3v35Ev();
extern void _ZN10S2216C3_nt3v36Ev();
extern void _ZN10S2216C3_nt3v37Ev();
extern void _ZN10S2216C3_nt3v38Ev();
extern void _ZN10S2216C3_nt3v39Ev();
extern void _ZN10S2216C3_nt3v40Ev();
extern void _ZN10S2216C3_nt3v41Ev();
extern void _ZN10S2216C3_nt3v42Ev();
extern void _ZN10S2216C3_nt3v43Ev();
extern void _ZN10S2216C3_nt3v44Ev();
extern void _ZN10S2216C3_nt3v45Ev();
extern void _ZN10S2216C3_nt3v46Ev();
extern void _ZN10S2216C3_nt3v47Ev();
extern void _ZN10S2216C3_nt3v48Ev();
extern void _ZN10S2216C3_nt3v49Ev();
extern void _ZN10S2216C3_nt3v50Ev();
extern void _ZN10S2216C3_nt3v51Ev();
extern void _ZN10S2216C3_nt3v52Ev();
extern void _ZN10S2216C3_nt3v53Ev();
extern void _ZN10S2216C3_nt3v54Ev();
extern void _ZN10S2216C3_nt3v55Ev();
extern void _ZN10S2216C3_nt3v56Ev();
extern void _ZN10S2216C3_nt3v57Ev();
extern void _ZN10S2216C3_nt3v58Ev();
extern void _ZN10S2216C3_nt3v59Ev();
extern void _ZN10S2216C3_nt3v60Ev();
extern void _ZN10S2216C3_nt3v61Ev();
extern void _ZN10S2216C3_nt3v62Ev();
extern void _ZN10S2216C3_nt3v63Ev();
extern void _ZN10S2216C3_nt3v64Ev();
extern void _ZN10S2216C3_nt3v65Ev();
extern void _ZN10S2216C3_nt3v66Ev();
extern void _ZN10S2216C3_nt3v67Ev();
extern void _ZN10S2216C3_nt3v68Ev();
extern void _ZN10S2216C3_nt3v69Ev();
extern void _ZN10S2216C3_nt3v70Ev();
extern void _ZN10S2216C3_nt3v71Ev();
extern void _ZN10S2216C3_nt3v72Ev();
extern void _ZN10S2216C3_nt3v73Ev();
extern void _ZN10S2216C3_nt3v74Ev();
extern void _ZN10S2216C3_nt3v75Ev();
extern void _ZN10S2216C3_nt3v76Ev();
extern void _ZN10S2216C3_nt3v77Ev();
extern void _ZN10S2216C3_nt3v78Ev();
extern void _ZN10S2216C3_nt3v79Ev();
extern void _ZN10S2216C3_nt3v80Ev();
extern void _ZN10S2216C3_nt3v81Ev();
extern void _ZN10S2216C3_nt3v82Ev();
extern void _ZN10S2216C3_nt3v83Ev();
extern void _ZN10S2216C3_nt3v84Ev();
extern void _ZN10S2216C3_nt3v85Ev();
extern void _ZN10S2216C3_nt3v86Ev();
extern void _ZN10S2216C3_nt3v87Ev();
extern void _ZN10S2216C3_nt3v88Ev();
extern void _ZN10S2216C3_nt3v89Ev();
extern void _ZN10S2216C3_nt3v90Ev();
extern void _ZN10S2216C3_nt3v91Ev();
extern void _ZN10S2216C3_nt3v92Ev();
extern void _ZN10S2216C3_nt3v93Ev();
extern void _ZN10S2216C3_nt3v94Ev();
extern void _ZN10S2216C3_nt3v95Ev();
extern void _ZN10S2216C3_nt3v96Ev();
extern void _ZN10S2216C3_nt3v97Ev();
extern void _ZN10S2216C3_nt3v98Ev();
extern void _ZN10S2216C3_nt3v99Ev();
extern void _ZN10S2216C3_nt4v100Ev();
extern void _ZN10S2216C3_nt4v101Ev();
extern void _ZN10S2216C3_nt4v102Ev();
extern void _ZN10S2216C3_nt4v103Ev();
static  VTBL_ENTRY vtc_S2216C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2216C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S2216C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt4v103Ev,
};
extern VTBL_ENTRY _ZTI10S2216C3_nt[];
VTBL_ENTRY *P__ZTI10S2216C3_nt = _ZTI10S2216C3_nt; 
extern  VTBL_ENTRY _ZTV10S2216C3_nt[];
Class_Descriptor cd_S2216C3_nt = {  "S2216C3_nt", // class name
  bases_S2216C3_nt, 1,
  &(vtc_S2216C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(832,632), // object size
  NSPAIRA(_ZTI10S2216C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S2216C3_nt),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2216C2_nt  : S2216C3_nt {
  void *s2216c2f0;
  virtual  ~S2216C2_nt(); // _ZN10S2216C2_ntD1Ev
  virtual void  v104(); // _ZN10S2216C2_nt4v104Ev
  virtual void  v105(); // _ZN10S2216C2_nt4v105Ev
  virtual void  v106(); // _ZN10S2216C2_nt4v106Ev
  virtual void  v107(); // _ZN10S2216C2_nt4v107Ev
  virtual void  v108(); // _ZN10S2216C2_nt4v108Ev
  virtual void  v109(); // _ZN10S2216C2_nt4v109Ev
  virtual void  v110(); // _ZN10S2216C2_nt4v110Ev
  virtual void  v111(); // _ZN10S2216C2_nt4v111Ev
  virtual void  v112(); // _ZN10S2216C2_nt4v112Ev
  virtual void  v113(); // _ZN10S2216C2_nt4v113Ev
  S2216C2_nt(); // tgen
};
//SIG(-1 S2216C2_nt) C1{ BC2{ BC3{ vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 Fp Fi FC4{ BC5{ m Fp Fi FC6{ m} FC7{ m}}} FC4 Fi} vd v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8 FC10{ m FC8} FC11{ m FC8 FC8 FC8 FC8} FC11 FC8 FC8 FC8 Fp FC10 FC12{ m FC13{ m Fp Fi FC7} Fi} Fi Fp[7] FC14{ m Fp Fi FC15{ m} FC15} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC16{ BC17{ m Fp Fi FC18{ m} FC18}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC19{ m Fp Fi[2] FC20{ m}} Fp[2] Fi:16 Fi:16 FC16 FC19 FC21{ m Fp Fi[2] FC20} Fp[2] Fi:24 Fi:8 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp}


 S2216C2_nt ::~S2216C2_nt(){ note_dtor("S2216C2_nt", this);}
void  S2216C2_nt ::v104(){vfunc_called(this, "_ZN10S2216C2_nt4v104Ev");}
void  S2216C2_nt ::v105(){vfunc_called(this, "_ZN10S2216C2_nt4v105Ev");}
void  S2216C2_nt ::v106(){vfunc_called(this, "_ZN10S2216C2_nt4v106Ev");}
void  S2216C2_nt ::v107(){vfunc_called(this, "_ZN10S2216C2_nt4v107Ev");}
void  S2216C2_nt ::v108(){vfunc_called(this, "_ZN10S2216C2_nt4v108Ev");}
void  S2216C2_nt ::v109(){vfunc_called(this, "_ZN10S2216C2_nt4v109Ev");}
void  S2216C2_nt ::v110(){vfunc_called(this, "_ZN10S2216C2_nt4v110Ev");}
void  S2216C2_nt ::v111(){vfunc_called(this, "_ZN10S2216C2_nt4v111Ev");}
void  S2216C2_nt ::v112(){vfunc_called(this, "_ZN10S2216C2_nt4v112Ev");}
void  S2216C2_nt ::v113(){vfunc_called(this, "_ZN10S2216C2_nt4v113Ev");}
S2216C2_nt ::S2216C2_nt(){ note_ctor("S2216C2_nt", this);} // tgen

//skip512 S2216C2_nt

#else // __cplusplus

extern void _ZN10S2216C2_ntC1Ev();
extern void _ZN10S2216C2_ntD1Ev();
Name_Map name_map_S2216C2_nt[] = {
  NSPAIR(_ZN10S2216C2_ntC1Ev),
  NSPAIR(_ZN10S2216C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2216C4_nt;
extern VTBL_ENTRY _ZTI10S2216C4_nt[];
extern  VTBL_ENTRY _ZTV10S2216C4_nt[];
extern Class_Descriptor cd_S2216C3_nt;
extern VTBL_ENTRY _ZTI10S2216C3_nt[];
extern  VTBL_ENTRY _ZTV10S2216C3_nt[];
static Base_Class bases_S2216C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2216C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2216C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S2216C2_nt[];
extern void _ZN10S2216C2_ntD1Ev();
extern void _ZN10S2216C2_ntD0Ev();
extern void _ZN10S2216C4_nt2v3Ev();
extern void _ZN10S2216C4_nt2v4Ev();
extern void _ZN10S2216C4_nt2v5Ev();
extern void _ZN10S2216C4_nt2v6Ev();
extern void _ZN10S2216C4_nt2v7Ev();
extern void _ZN10S2216C4_nt2v8Ev();
extern void _ZN10S2216C4_nt2v9Ev();
extern void _ZN10S2216C4_nt3v10Ev();
extern void _ZN10S2216C4_nt3v11Ev();
extern void _ZN10S2216C4_nt3v12Ev();
extern void _ZN10S2216C4_nt3v13Ev();
extern void _ZN10S2216C4_nt3v14Ev();
extern void _ZN10S2216C4_nt3v15Ev();
extern void _ZN10S2216C4_nt3v16Ev();
extern void _ZN10S2216C4_nt3v17Ev();
extern void _ZN10S2216C4_nt3v18Ev();
extern void _ZN10S2216C4_nt3v19Ev();
extern void _ZN10S2216C4_nt3v20Ev();
extern void _ZN10S2216C4_nt3v21Ev();
extern void _ZN10S2216C4_nt3v22Ev();
extern void _ZN10S2216C4_nt3v23Ev();
extern void _ZN10S2216C4_nt3v24Ev();
extern void _ZN10S2216C4_nt3v25Ev();
extern void _ZN10S2216C3_nt3v26Ev();
extern void _ZN10S2216C3_nt3v27Ev();
extern void _ZN10S2216C3_nt3v28Ev();
extern void _ZN10S2216C3_nt3v29Ev();
extern void _ZN10S2216C3_nt3v30Ev();
extern void _ZN10S2216C3_nt3v31Ev();
extern void _ZN10S2216C3_nt3v32Ev();
extern void _ZN10S2216C3_nt3v33Ev();
extern void _ZN10S2216C3_nt3v34Ev();
extern void _ZN10S2216C3_nt3v35Ev();
extern void _ZN10S2216C3_nt3v36Ev();
extern void _ZN10S2216C3_nt3v37Ev();
extern void _ZN10S2216C3_nt3v38Ev();
extern void _ZN10S2216C3_nt3v39Ev();
extern void _ZN10S2216C3_nt3v40Ev();
extern void _ZN10S2216C3_nt3v41Ev();
extern void _ZN10S2216C3_nt3v42Ev();
extern void _ZN10S2216C3_nt3v43Ev();
extern void _ZN10S2216C3_nt3v44Ev();
extern void _ZN10S2216C3_nt3v45Ev();
extern void _ZN10S2216C3_nt3v46Ev();
extern void _ZN10S2216C3_nt3v47Ev();
extern void _ZN10S2216C3_nt3v48Ev();
extern void _ZN10S2216C3_nt3v49Ev();
extern void _ZN10S2216C3_nt3v50Ev();
extern void _ZN10S2216C3_nt3v51Ev();
extern void _ZN10S2216C3_nt3v52Ev();
extern void _ZN10S2216C3_nt3v53Ev();
extern void _ZN10S2216C3_nt3v54Ev();
extern void _ZN10S2216C3_nt3v55Ev();
extern void _ZN10S2216C3_nt3v56Ev();
extern void _ZN10S2216C3_nt3v57Ev();
extern void _ZN10S2216C3_nt3v58Ev();
extern void _ZN10S2216C3_nt3v59Ev();
extern void _ZN10S2216C3_nt3v60Ev();
extern void _ZN10S2216C3_nt3v61Ev();
extern void _ZN10S2216C3_nt3v62Ev();
extern void _ZN10S2216C3_nt3v63Ev();
extern void _ZN10S2216C3_nt3v64Ev();
extern void _ZN10S2216C3_nt3v65Ev();
extern void _ZN10S2216C3_nt3v66Ev();
extern void _ZN10S2216C3_nt3v67Ev();
extern void _ZN10S2216C3_nt3v68Ev();
extern void _ZN10S2216C3_nt3v69Ev();
extern void _ZN10S2216C3_nt3v70Ev();
extern void _ZN10S2216C3_nt3v71Ev();
extern void _ZN10S2216C3_nt3v72Ev();
extern void _ZN10S2216C3_nt3v73Ev();
extern void _ZN10S2216C3_nt3v74Ev();
extern void _ZN10S2216C3_nt3v75Ev();
extern void _ZN10S2216C3_nt3v76Ev();
extern void _ZN10S2216C3_nt3v77Ev();
extern void _ZN10S2216C3_nt3v78Ev();
extern void _ZN10S2216C3_nt3v79Ev();
extern void _ZN10S2216C3_nt3v80Ev();
extern void _ZN10S2216C3_nt3v81Ev();
extern void _ZN10S2216C3_nt3v82Ev();
extern void _ZN10S2216C3_nt3v83Ev();
extern void _ZN10S2216C3_nt3v84Ev();
extern void _ZN10S2216C3_nt3v85Ev();
extern void _ZN10S2216C3_nt3v86Ev();
extern void _ZN10S2216C3_nt3v87Ev();
extern void _ZN10S2216C3_nt3v88Ev();
extern void _ZN10S2216C3_nt3v89Ev();
extern void _ZN10S2216C3_nt3v90Ev();
extern void _ZN10S2216C3_nt3v91Ev();
extern void _ZN10S2216C3_nt3v92Ev();
extern void _ZN10S2216C3_nt3v93Ev();
extern void _ZN10S2216C3_nt3v94Ev();
extern void _ZN10S2216C3_nt3v95Ev();
extern void _ZN10S2216C3_nt3v96Ev();
extern void _ZN10S2216C3_nt3v97Ev();
extern void _ZN10S2216C3_nt3v98Ev();
extern void _ZN10S2216C3_nt3v99Ev();
extern void _ZN10S2216C3_nt4v100Ev();
extern void _ZN10S2216C3_nt4v101Ev();
extern void _ZN10S2216C3_nt4v102Ev();
extern void _ZN10S2216C3_nt4v103Ev();
extern void _ZN10S2216C2_nt4v104Ev();
extern void _ZN10S2216C2_nt4v105Ev();
extern void _ZN10S2216C2_nt4v106Ev();
extern void _ZN10S2216C2_nt4v107Ev();
extern void _ZN10S2216C2_nt4v108Ev();
extern void _ZN10S2216C2_nt4v109Ev();
extern void _ZN10S2216C2_nt4v110Ev();
extern void _ZN10S2216C2_nt4v111Ev();
extern void _ZN10S2216C2_nt4v112Ev();
extern void _ZN10S2216C2_nt4v113Ev();
static  VTBL_ENTRY vtc_S2216C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2216C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S2216C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2216C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S2216C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S2216C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S2216C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S2216C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S2216C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S2216C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S2216C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S2216C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S2216C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S2216C2_nt4v113Ev,
};
extern VTBL_ENTRY _ZTI10S2216C2_nt[];
VTBL_ENTRY *P__ZTI10S2216C2_nt = _ZTI10S2216C2_nt; 
extern  VTBL_ENTRY _ZTV10S2216C2_nt[];
Class_Descriptor cd_S2216C2_nt = {  "S2216C2_nt", // class name
  bases_S2216C2_nt, 2,
  &(vtc_S2216C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(840,636), // object size
  NSPAIRA(_ZTI10S2216C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S2216C2_nt),115, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2216C1  : S2216C2_nt {
  int s2216c1f0[4];
  void *s2216c1f1[4];
  char s2216c1f2;
  int s2216c1f3[4];
  char s2216c1f4;
  virtual  ~S2216C1(); // _ZN7S2216C1D1Ev
  virtual void  v1(); // _ZN7S2216C12v1Ev
  virtual void  v2(); // _ZN7S2216C12v2Ev
  S2216C1(); // tgen
};
//SIG(1 S2216C1) C1{ BC2{ BC3{ BC4{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 Fp Fi FC5{ BC6{ m Fp Fi FC7{ m} FC8{ m}}} FC5 Fi} vd v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 FC9{ m FC10{ m FL[2]}} FC9 FC9 FC9 FC11{ m FC9} FC12{ m FC9 FC9 FC9 FC9} FC12 FC9 FC9 FC9 Fp FC11 FC13{ m FC14{ m Fp Fi FC8} Fi} Fi Fp[7] FC15{ m Fp Fi FC16{ m} FC16} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC17{ BC18{ m Fp Fi FC19{ m} FC19}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC20{ m Fp Fi[2] FC21{ m}} Fp[2] Fi:16 Fi:16 FC17 FC20 FC22{ m Fp Fi[2] FC21} Fp[2] Fi:24 Fi:8 Fp} vd v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 Fp} vd v1 v2 Fi[4] Fp[4] Fc Fi[4] Fc}


 S2216C1 ::~S2216C1(){ note_dtor("S2216C1", this);}
void  S2216C1 ::v1(){vfunc_called(this, "_ZN7S2216C12v1Ev");}
void  S2216C1 ::v2(){vfunc_called(this, "_ZN7S2216C12v2Ev");}
S2216C1 ::S2216C1(){ note_ctor("S2216C1", this);} // tgen

static void Test_S2216C1()
{
  extern Class_Descriptor cd_S2216C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(115,174)];
    init_test(&cd_S2216C1, buf);
    S2216C1 *dp, &lv = *(dp=new (buf) S2216C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(912,692), "sizeof(S2216C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2216C1)");
    check_base_class_offset(lv, (S2216C4_nt*)(S2216C3_nt*)(S2216C2_nt*), 0, "S2216C1");
    check_base_class_offset(lv, (S2216C3_nt*)(S2216C2_nt*), 0, "S2216C1");
    check_base_class_offset(lv, (S2216C2_nt*), 0, "S2216C1");
    check_field_offset(lv, s2216c1f0, ABISELECT(840,636), "S2216C1.s2216c1f0");
    check_field_offset(lv, s2216c1f1, ABISELECT(856,652), "S2216C1.s2216c1f1");
    check_field_offset(lv, s2216c1f2, ABISELECT(888,668), "S2216C1.s2216c1f2");
    check_field_offset(lv, s2216c1f3, ABISELECT(892,672), "S2216C1.s2216c1f3");
    check_field_offset(lv, s2216c1f4, ABISELECT(908,688), "S2216C1.s2216c1f4");
    test_class_info(&lv, &cd_S2216C1);
    dp->~S2216C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2216C1(Test_S2216C1, "S2216C1", ABISELECT(912,692));

#else // __cplusplus

extern void _ZN7S2216C1C1Ev();
extern void _ZN7S2216C1D1Ev();
Name_Map name_map_S2216C1[] = {
  NSPAIR(_ZN7S2216C1C1Ev),
  NSPAIR(_ZN7S2216C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2216C4_nt;
extern VTBL_ENTRY _ZTI10S2216C4_nt[];
extern  VTBL_ENTRY _ZTV10S2216C4_nt[];
extern Class_Descriptor cd_S2216C3_nt;
extern VTBL_ENTRY _ZTI10S2216C3_nt[];
extern  VTBL_ENTRY _ZTV10S2216C3_nt[];
extern Class_Descriptor cd_S2216C2_nt;
extern VTBL_ENTRY _ZTI10S2216C2_nt[];
extern  VTBL_ENTRY _ZTV10S2216C2_nt[];
static Base_Class bases_S2216C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2216C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2216C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2216C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2216C1[];
extern void _ZN7S2216C1D1Ev();
extern void _ZN7S2216C1D0Ev();
extern void _ZN10S2216C4_nt2v3Ev();
extern void _ZN10S2216C4_nt2v4Ev();
extern void _ZN10S2216C4_nt2v5Ev();
extern void _ZN10S2216C4_nt2v6Ev();
extern void _ZN10S2216C4_nt2v7Ev();
extern void _ZN10S2216C4_nt2v8Ev();
extern void _ZN10S2216C4_nt2v9Ev();
extern void _ZN10S2216C4_nt3v10Ev();
extern void _ZN10S2216C4_nt3v11Ev();
extern void _ZN10S2216C4_nt3v12Ev();
extern void _ZN10S2216C4_nt3v13Ev();
extern void _ZN10S2216C4_nt3v14Ev();
extern void _ZN10S2216C4_nt3v15Ev();
extern void _ZN10S2216C4_nt3v16Ev();
extern void _ZN10S2216C4_nt3v17Ev();
extern void _ZN10S2216C4_nt3v18Ev();
extern void _ZN10S2216C4_nt3v19Ev();
extern void _ZN10S2216C4_nt3v20Ev();
extern void _ZN10S2216C4_nt3v21Ev();
extern void _ZN10S2216C4_nt3v22Ev();
extern void _ZN10S2216C4_nt3v23Ev();
extern void _ZN10S2216C4_nt3v24Ev();
extern void _ZN10S2216C4_nt3v25Ev();
extern void _ZN10S2216C3_nt3v26Ev();
extern void _ZN10S2216C3_nt3v27Ev();
extern void _ZN10S2216C3_nt3v28Ev();
extern void _ZN10S2216C3_nt3v29Ev();
extern void _ZN10S2216C3_nt3v30Ev();
extern void _ZN10S2216C3_nt3v31Ev();
extern void _ZN10S2216C3_nt3v32Ev();
extern void _ZN10S2216C3_nt3v33Ev();
extern void _ZN10S2216C3_nt3v34Ev();
extern void _ZN10S2216C3_nt3v35Ev();
extern void _ZN10S2216C3_nt3v36Ev();
extern void _ZN10S2216C3_nt3v37Ev();
extern void _ZN10S2216C3_nt3v38Ev();
extern void _ZN10S2216C3_nt3v39Ev();
extern void _ZN10S2216C3_nt3v40Ev();
extern void _ZN10S2216C3_nt3v41Ev();
extern void _ZN10S2216C3_nt3v42Ev();
extern void _ZN10S2216C3_nt3v43Ev();
extern void _ZN10S2216C3_nt3v44Ev();
extern void _ZN10S2216C3_nt3v45Ev();
extern void _ZN10S2216C3_nt3v46Ev();
extern void _ZN10S2216C3_nt3v47Ev();
extern void _ZN10S2216C3_nt3v48Ev();
extern void _ZN10S2216C3_nt3v49Ev();
extern void _ZN10S2216C3_nt3v50Ev();
extern void _ZN10S2216C3_nt3v51Ev();
extern void _ZN10S2216C3_nt3v52Ev();
extern void _ZN10S2216C3_nt3v53Ev();
extern void _ZN10S2216C3_nt3v54Ev();
extern void _ZN10S2216C3_nt3v55Ev();
extern void _ZN10S2216C3_nt3v56Ev();
extern void _ZN10S2216C3_nt3v57Ev();
extern void _ZN10S2216C3_nt3v58Ev();
extern void _ZN10S2216C3_nt3v59Ev();
extern void _ZN10S2216C3_nt3v60Ev();
extern void _ZN10S2216C3_nt3v61Ev();
extern void _ZN10S2216C3_nt3v62Ev();
extern void _ZN10S2216C3_nt3v63Ev();
extern void _ZN10S2216C3_nt3v64Ev();
extern void _ZN10S2216C3_nt3v65Ev();
extern void _ZN10S2216C3_nt3v66Ev();
extern void _ZN10S2216C3_nt3v67Ev();
extern void _ZN10S2216C3_nt3v68Ev();
extern void _ZN10S2216C3_nt3v69Ev();
extern void _ZN10S2216C3_nt3v70Ev();
extern void _ZN10S2216C3_nt3v71Ev();
extern void _ZN10S2216C3_nt3v72Ev();
extern void _ZN10S2216C3_nt3v73Ev();
extern void _ZN10S2216C3_nt3v74Ev();
extern void _ZN10S2216C3_nt3v75Ev();
extern void _ZN10S2216C3_nt3v76Ev();
extern void _ZN10S2216C3_nt3v77Ev();
extern void _ZN10S2216C3_nt3v78Ev();
extern void _ZN10S2216C3_nt3v79Ev();
extern void _ZN10S2216C3_nt3v80Ev();
extern void _ZN10S2216C3_nt3v81Ev();
extern void _ZN10S2216C3_nt3v82Ev();
extern void _ZN10S2216C3_nt3v83Ev();
extern void _ZN10S2216C3_nt3v84Ev();
extern void _ZN10S2216C3_nt3v85Ev();
extern void _ZN10S2216C3_nt3v86Ev();
extern void _ZN10S2216C3_nt3v87Ev();
extern void _ZN10S2216C3_nt3v88Ev();
extern void _ZN10S2216C3_nt3v89Ev();
extern void _ZN10S2216C3_nt3v90Ev();
extern void _ZN10S2216C3_nt3v91Ev();
extern void _ZN10S2216C3_nt3v92Ev();
extern void _ZN10S2216C3_nt3v93Ev();
extern void _ZN10S2216C3_nt3v94Ev();
extern void _ZN10S2216C3_nt3v95Ev();
extern void _ZN10S2216C3_nt3v96Ev();
extern void _ZN10S2216C3_nt3v97Ev();
extern void _ZN10S2216C3_nt3v98Ev();
extern void _ZN10S2216C3_nt3v99Ev();
extern void _ZN10S2216C3_nt4v100Ev();
extern void _ZN10S2216C3_nt4v101Ev();
extern void _ZN10S2216C3_nt4v102Ev();
extern void _ZN10S2216C3_nt4v103Ev();
extern void _ZN10S2216C2_nt4v104Ev();
extern void _ZN10S2216C2_nt4v105Ev();
extern void _ZN10S2216C2_nt4v106Ev();
extern void _ZN10S2216C2_nt4v107Ev();
extern void _ZN10S2216C2_nt4v108Ev();
extern void _ZN10S2216C2_nt4v109Ev();
extern void _ZN10S2216C2_nt4v110Ev();
extern void _ZN10S2216C2_nt4v111Ev();
extern void _ZN10S2216C2_nt4v112Ev();
extern void _ZN10S2216C2_nt4v113Ev();
extern void _ZN7S2216C12v1Ev();
extern void _ZN7S2216C12v2Ev();
static  VTBL_ENTRY vtc_S2216C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2216C1[0]),
  (VTBL_ENTRY)&_ZN7S2216C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2216C1D0Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2216C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S2216C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S2216C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S2216C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S2216C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S2216C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S2216C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S2216C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S2216C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S2216C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S2216C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S2216C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN7S2216C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2216C12v2Ev,
};
extern VTBL_ENTRY _ZTI7S2216C1[];
extern  VTBL_ENTRY _ZTV7S2216C1[];
Class_Descriptor cd_S2216C1 = {  "S2216C1", // class name
  bases_S2216C1, 3,
  &(vtc_S2216C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(912,692), // object size
  NSPAIRA(_ZTI7S2216C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2216C1),117, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19008C4_nt  {
  int s19008c4f0;
  void  mf19008c4(); // _ZN11S19008C4_nt9mf19008c4Ev
};
//SIG(-1 S19008C4_nt) C1{ m Fi}


void  S19008C4_nt ::mf19008c4(){}

//skip512 S19008C4_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI11S19008C4_nt[];
VTBL_ENTRY *P__ZTI11S19008C4_nt = _ZTI11S19008C4_nt; 
Class_Descriptor cd_S19008C4_nt = {  "S19008C4_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI11S19008C4_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S19008C7  {
  void *s19008c7f0;
  __tsi64 s19008c7f1[9];
  char  :0;
  void *s19008c7f3[2];
  __tsi64 s19008c7f4[7];
  void  mf19008c7(); // _ZN8S19008C79mf19008c7Ev
};
//SIG(1 S19008C7) U1{ m Fp FL[9] Fc:0 Fp[2] FL[7]}

#endif // __cplusplus
#ifdef __cplusplus

union  S19008C9  {
  int s19008c9f0;
  __tsi64 s19008c9f1;
  long double s19008c9f2;
  char s19008c9f3:2;
  char s19008c9f4[7];
  int s19008c9f5;
  int s19008c9f6;
  void *s19008c9f7;
  void  mf19008c9(); // _ZN8S19008C99mf19008c9Ev
};
//SIG(1 S19008C9) U1{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}

#endif // __cplusplus
#ifdef __cplusplus

struct  S19008C8  : S19008C4_nt {
  int s19008c8f0;
  ::S19008C9 s19008c8f1;
};
//SIG(-1 S19008C8) C1{ BC2{ m Fi} Fi FU3{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}}



static void Test_S19008C8()
{
  extern Class_Descriptor cd_S19008C8;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(3,6)];
    init_test(&cd_S19008C8, buf);
    S19008C8 &lv = *(new (buf) S19008C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S19008C8)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19008C8)");
    check_base_class_offset(lv, (S19008C4_nt*), 0, "S19008C8");
    check_field_offset(lv, s19008c8f0, 4, "S19008C8.s19008c8f0");
    check_field_offset(lv, s19008c8f1, ABISELECT(16,8), "S19008C8.s19008c8f1");
    test_class_info(&lv, &cd_S19008C8);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19008C8(Test_S19008C8, "S19008C8", ABISELECT(32,20));

#else // __cplusplus

extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
static Base_Class bases_S19008C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19008C8[];
Class_Descriptor cd_S19008C8 = {  "S19008C8", // class name
  bases_S19008C8, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI8S19008C8),ABISELECT(24,12), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19008C6  : virtual S19008C4_nt {
  void *s19008c6f0;
  __tsi64 s19008c6f1;
  int s19008c6f2;
  void *s19008c6f3;
  int s19008c6f4;
  ::S19008C7 s19008c6f5;
  char s19008c6f6;
  char s19008c6f7;
  long double s19008c6f8;
  ::S19008C4_nt s19008c6f9;
  ::S19008C8 s19008c6f10;
  void *s19008c6f11;
  ~S19008C6(); // tgen
  S19008C6(); // tgen
};
//SIG(-1 S19008C6) C1{ VBC2{ m Fi} Fp FL Fi Fp Fi FU3{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC2 FC4{ BC2 Fi FU5{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp}


S19008C6 ::~S19008C6(){ note_dtor("S19008C6", this);} // tgen
S19008C6 ::S19008C6(){ note_ctor("S19008C6", this);} // tgen

static void Test_S19008C6()
{
  extern Class_Descriptor cd_S19008C6;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(14,38)];
    init_test(&cd_S19008C6, buf);
    S19008C6 *dp, &lv = *(dp=new (buf) S19008C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,148), "sizeof(S19008C6)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19008C6)");
    check_base_class_offset(lv, (S19008C4_nt*), ABISELECT(200,144), "S19008C6");
    check_field_offset(lv, s19008c6f0, ABISELECT(8,4), "S19008C6.s19008c6f0");
    check_field_offset(lv, s19008c6f1, ABISELECT(16,8), "S19008C6.s19008c6f1");
    check_field_offset(lv, s19008c6f2, ABISELECT(24,16), "S19008C6.s19008c6f2");
    check_field_offset(lv, s19008c6f3, ABISELECT(32,20), "S19008C6.s19008c6f3");
    check_field_offset(lv, s19008c6f4, ABISELECT(40,24), "S19008C6.s19008c6f4");
    check_field_offset(lv, s19008c6f5, ABISELECT(48,28), "S19008C6.s19008c6f5");
    check_field_offset(lv, s19008c6f6, ABISELECT(120,100), "S19008C6.s19008c6f6");
    check_field_offset(lv, s19008c6f7, ABISELECT(121,101), "S19008C6.s19008c6f7");
    check_field_offset(lv, s19008c6f8, ABISELECT(128,104), "S19008C6.s19008c6f8");
    check_field_offset(lv, s19008c6f9, ABISELECT(144,116), "S19008C6.s19008c6f9");
    check_field_offset(lv, s19008c6f10, ABISELECT(160,120), "S19008C6.s19008c6f10");
    check_field_offset(lv, s19008c6f11, ABISELECT(192,140), "S19008C6.s19008c6f11");
    test_class_info(&lv, &cd_S19008C6);
    dp->~S19008C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19008C6(Test_S19008C6, "S19008C6", ABISELECT(208,148));

#else // __cplusplus

extern void _ZN8S19008C6C1Ev();
extern void _ZN8S19008C6D1Ev();
Name_Map name_map_S19008C6[] = {
  NSPAIR(_ZN8S19008C6C1Ev),
  NSPAIR(_ZN8S19008C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
static Base_Class bases_S19008C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C4_nt,    ABISELECT(200,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S19008C6[];
static  VTBL_ENTRY vtc_S19008C6[] = {
  ABISELECT(200,144),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
extern VTBL_ENTRY _ZTV8S19008C6[];
static  VTT_ENTRY vtt_S19008C6[] = {
  {&(_ZTV8S19008C6[3]),  3,3},
};
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
Class_Descriptor cd_S19008C6 = {  "S19008C6", // class name
  bases_S19008C6, 1,
  &(vtc_S19008C6[0]), // expected_vtbl_contents
  &(vtt_S19008C6[0]), // expected_vtt_contents
  ABISELECT(208,148), // object size
  NSPAIRA(_ZTI8S19008C6),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S19008C6),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19008C6),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19008C5  : S19008C6 , S19008C8 {
  int s19008c5f0;
  __tsi64 s19008c5f1;
  int s19008c5f2;
  __tsi64 s19008c5f3;
  ::S19008C4_nt s19008c5f4;
  int s19008c5f5;
  short s19008c5f6;
  int s19008c5f7;
  virtual void  v1(); // _ZN8S19008C52v1Ev
  ~S19008C5(); // tgen
  S19008C5(); // tgen
};
//SIG(-1 S19008C5) C1{ BC2{ VBC3{ m Fi} Fp FL Fi Fp Fi FU4{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC3 FC5{ BC3 Fi FU6{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC5 v1 Fi FL Fi FL FC3 Fi Fs Fi}


void  S19008C5 ::v1(){vfunc_called(this, "_ZN8S19008C52v1Ev");}
S19008C5 ::~S19008C5(){ note_dtor("S19008C5", this);} // tgen
S19008C5 ::S19008C5(){ note_ctor("S19008C5", this);} // tgen

static void Test_S19008C5()
{
  extern Class_Descriptor cd_S19008C5;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(20,53)];
    init_test(&cd_S19008C5, buf);
    S19008C5 *dp, &lv = *(dp=new (buf) S19008C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,208), "sizeof(S19008C5)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19008C5)");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*), ABISELECT(288,204), "S19008C5");
    check_base_class_offset(lv, (S19008C6*), 0, "S19008C5");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*), ABISELECT(208,144), "S19008C5");
    check_base_class_offset(lv, (S19008C8*), ABISELECT(208,144), "S19008C5");
    check_field_offset(lv, s19008c5f0, ABISELECT(240,164), "S19008C5.s19008c5f0");
    check_field_offset(lv, s19008c5f1, ABISELECT(248,168), "S19008C5.s19008c5f1");
    check_field_offset(lv, s19008c5f2, ABISELECT(256,176), "S19008C5.s19008c5f2");
    check_field_offset(lv, s19008c5f3, ABISELECT(264,180), "S19008C5.s19008c5f3");
    check_field_offset(lv, s19008c5f4, ABISELECT(272,188), "S19008C5.s19008c5f4");
    check_field_offset(lv, s19008c5f5, ABISELECT(276,192), "S19008C5.s19008c5f5");
    check_field_offset(lv, s19008c5f6, ABISELECT(280,196), "S19008C5.s19008c5f6");
    check_field_offset(lv, s19008c5f7, ABISELECT(284,200), "S19008C5.s19008c5f7");
    test_class_info(&lv, &cd_S19008C5);
    dp->~S19008C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19008C5(Test_S19008C5, "S19008C5", ABISELECT(304,208));

#else // __cplusplus

extern void _ZN8S19008C5C1Ev();
extern void _ZN8S19008C5D1Ev();
Name_Map name_map_S19008C5[] = {
  NSPAIR(_ZN8S19008C5C1Ev),
  NSPAIR(_ZN8S19008C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
static Base_Class bases_S19008C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C4_nt,    ABISELECT(288,204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S19008C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C4_nt,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19008C5[];
extern void _ZN8S19008C52v1Ev();
static  VTBL_ENTRY vtc_S19008C5[] = {
  ABISELECT(288,204),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C5[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
};
extern VTBL_ENTRY _ZTV8S19008C5[];
static  VTBL_ENTRY _tg__ZTV8S19008C6__8S19008C5[] = {
  ABISELECT(288,204),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTT_ENTRY vtt_S19008C5[] = {
  {&(_ZTV8S19008C5[3]),  3,4},
  {&(_tg__ZTV8S19008C6__8S19008C5[3]),  3,3},
};
extern VTBL_ENTRY _ZTI8S19008C5[];
extern  VTBL_ENTRY _ZTV8S19008C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C5[];
Class_Descriptor cd_S19008C5 = {  "S19008C5", // class name
  bases_S19008C5, 4,
  &(vtc_S19008C5[0]), // expected_vtbl_contents
  &(vtt_S19008C5[0]), // expected_vtt_contents
  ABISELECT(304,208), // object size
  NSPAIRA(_ZTI8S19008C5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S19008C5),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19008C5),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19008C11_nt  {
};
//SIG(-1 S19008C11_nt) C1{}



//skip512 S19008C11_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19008C10  : virtual S19008C4_nt , S19008C6 , S19008C8 {
  __tsi64 s19008c10f0;
  ::S19008C9 s19008c10f1;
  void *s19008c10f2;
  void *s19008c10f3;
  ::S19008C11_nt s19008c10f4;
  int s19008c10f5;
  int s19008c10f6;
  void *s19008c10f7;
  char s19008c10f8;
  ::S19008C11_nt s19008c10f9;
  ~S19008C10(); // tgen
  S19008C10(); // tgen
};
//SIG(-1 S19008C10) C1{ VBC2{ m Fi} BC3{ VBC2 Fp FL Fi Fp Fi FU4{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC2 FC5{ BC2 Fi FU6{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC5 FL FU6 Fp Fp FC7{} Fi Fi Fp Fc FC7}


S19008C10 ::~S19008C10(){ note_dtor("S19008C10", this);} // tgen
S19008C10 ::S19008C10(){ note_ctor("S19008C10", this);} // tgen

static void Test_S19008C10()
{
  extern Class_Descriptor cd_S19008C10;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(21,55)];
    init_test(&cd_S19008C10, buf);
    S19008C10 *dp, &lv = *(dp=new (buf) S19008C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(320,216), "sizeof(S19008C10)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19008C10)");
    /*is_ambiguous_... S19008C10::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*), ABISELECT(316,212), "S19008C10");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*), ABISELECT(316,212), "S19008C10");
    check_base_class_offset(lv, (S19008C6*), 0, "S19008C10");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*), ABISELECT(208,144), "S19008C10");
    check_base_class_offset(lv, (S19008C8*), ABISELECT(208,144), "S19008C10");
    check_field_offset(lv, s19008c10f0, ABISELECT(240,164), "S19008C10.s19008c10f0");
    check_field_offset(lv, s19008c10f1, ABISELECT(256,172), "S19008C10.s19008c10f1");
    check_field_offset(lv, s19008c10f2, ABISELECT(272,184), "S19008C10.s19008c10f2");
    check_field_offset(lv, s19008c10f3, ABISELECT(280,188), "S19008C10.s19008c10f3");
    check_field_offset(lv, s19008c10f4, ABISELECT(288,192), "S19008C10.s19008c10f4");
    check_field_offset(lv, s19008c10f5, ABISELECT(292,196), "S19008C10.s19008c10f5");
    check_field_offset(lv, s19008c10f6, ABISELECT(296,200), "S19008C10.s19008c10f6");
    check_field_offset(lv, s19008c10f7, ABISELECT(304,204), "S19008C10.s19008c10f7");
    check_field_offset(lv, s19008c10f8, ABISELECT(312,208), "S19008C10.s19008c10f8");
    check_field_offset(lv, s19008c10f9, ABISELECT(313,209), "S19008C10.s19008c10f9");
    test_class_info(&lv, &cd_S19008C10);
    dp->~S19008C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19008C10(Test_S19008C10, "S19008C10", ABISELECT(320,216));

#else // __cplusplus

extern void _ZN9S19008C10C1Ev();
extern void _ZN9S19008C10D1Ev();
Name_Map name_map_S19008C10[] = {
  NSPAIR(_ZN9S19008C10C1Ev),
  NSPAIR(_ZN9S19008C10D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
static Base_Class bases_S19008C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C4_nt,    ABISELECT(316,212), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19008C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C4_nt,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19008C10[];
static  VTBL_ENTRY vtc_S19008C10[] = {
  ABISELECT(316,212),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
extern VTBL_ENTRY _ZTV9S19008C10[];
static  VTBL_ENTRY _tg__ZTV8S19008C6__9S19008C10[] = {
  ABISELECT(316,212),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTT_ENTRY vtt_S19008C10[] = {
  {&(_ZTV9S19008C10[3]),  3,3},
  {&(_tg__ZTV8S19008C6__9S19008C10[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
Class_Descriptor cd_S19008C10 = {  "S19008C10", // class name
  bases_S19008C10, 4,
  &(vtc_S19008C10[0]), // expected_vtbl_contents
  &(vtt_S19008C10[0]), // expected_vtt_contents
  ABISELECT(320,216), // object size
  NSPAIRA(_ZTI9S19008C10),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S19008C10),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19008C10),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19008C3  : S19008C4_nt , S19008C5 , S19008C8 , virtual S19008C10 , S19008C6 {
  ::S19008C9 s19008c3f0;
  long double s19008c3f1;
  char s19008c3f2;
  void *s19008c3f3;
  __tsi64 s19008c3f4;
  ::S19008C8 s19008c3f5;
  int s19008c3f6;
  void *s19008c3f7[10];
  int s19008c3f8;
  ::S19008C10 s19008c3f9;
  int s19008c3f10;
  virtual  ~S19008C3(); // _ZN8S19008C3D2Ev
  virtual void  v2(); // _ZN8S19008C32v2Ev
  virtual void  v3(); // _ZN8S19008C32v3Ev
  S19008C3(); // tgen
};
//SIG(-1 S19008C3) C1{ BC2{ m Fi} BC3{ BC4{ VBC2 Fp FL Fi Fp Fi FU5{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC2 FC6{ BC2 Fi FU7{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC6 v3 Fi FL Fi FL FC2 Fi Fs Fi} BC6 VBC8{ VBC2 BC4 BC6 FL FU7 Fp Fp FC9{} Fi Fi Fp Fc FC9} BC4 vd v1 v2 FU7 FD Fc Fp FL FC6 Fi Fp[10] Fi FC8 Fi}


 S19008C3 ::~S19008C3(){ note_dtor("S19008C3", this);}
void  S19008C3 ::v2(){vfunc_called(this, "_ZN8S19008C32v2Ev");}
void  S19008C3 ::v3(){vfunc_called(this, "_ZN8S19008C32v3Ev");}
S19008C3 ::S19008C3(){ note_ctor("S19008C3", this);} // tgen

static void Test_S19008C3()
{
  extern Class_Descriptor cd_S19008C3;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(88,230)];
    init_test(&cd_S19008C3, buf);
    S19008C3 *dp, &lv = *(dp=new (buf) S19008C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1392,916), "sizeof(S19008C3)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19008C3)");
    /*is_ambiguous_... S19008C3::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*), ABISELECT(288,204), "S19008C3");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C5*), ABISELECT(1060,700), "S19008C3");
    /*is_ambiguous_... S19008C10::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*), ABISELECT(1060,700), "S19008C3");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*), ABISELECT(1060,700), "S19008C3");
    /*is_ambiguous_... S19008C3::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*), ABISELECT(1060,700), "S19008C3");
    check_base_class_offset(lv, (S19008C6*)(S19008C5*), 0, "S19008C3");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C5*), ABISELECT(208,144), "S19008C3");
    check_base_class_offset(lv, (S19008C8*)(S19008C5*), ABISELECT(208,144), "S19008C3");
    check_base_class_offset(lv, (S19008C5*), 0, "S19008C3");
    /*is_ambiguous_... S19008C3::S19008C8 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*), ABISELECT(304,208), "S19008C3");
    /*is_ambiguous_... S19008C3::S19008C8 */ AMB_check_base_class_offset(lv, (S19008C8*), ABISELECT(304,208), "S19008C3");
    check_base_class_offset(lv, (S19008C6*)(S19008C10*), ABISELECT(1072,704), "S19008C3");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*), ABISELECT(1280,848), "S19008C3");
    check_base_class_offset(lv, (S19008C8*)(S19008C10*), ABISELECT(1280,848), "S19008C3");
    check_base_class_offset(lv, (S19008C10*), ABISELECT(1072,704), "S19008C3");
    /*is_ambiguous_... S19008C3::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C6*), ABISELECT(336,228), "S19008C3");
    check_field_offset(lv, s19008c3f0, ABISELECT(544,372), "S19008C3.s19008c3f0");
    check_field_offset(lv, s19008c3f1, ABISELECT(560,384), "S19008C3.s19008c3f1");
    check_field_offset(lv, s19008c3f2, ABISELECT(576,396), "S19008C3.s19008c3f2");
    check_field_offset(lv, s19008c3f3, ABISELECT(584,400), "S19008C3.s19008c3f3");
    check_field_offset(lv, s19008c3f4, ABISELECT(592,404), "S19008C3.s19008c3f4");
    check_field_offset(lv, s19008c3f5, ABISELECT(608,412), "S19008C3.s19008c3f5");
    check_field_offset(lv, s19008c3f6, ABISELECT(640,432), "S19008C3.s19008c3f6");
    check_field_offset(lv, s19008c3f7, ABISELECT(648,436), "S19008C3.s19008c3f7");
    check_field_offset(lv, s19008c3f8, ABISELECT(728,476), "S19008C3.s19008c3f8");
    check_field_offset(lv, s19008c3f9, ABISELECT(736,480), "S19008C3.s19008c3f9");
    check_field_offset(lv, s19008c3f10, ABISELECT(1056,696), "S19008C3.s19008c3f10");
    test_class_info(&lv, &cd_S19008C3);
    dp->~S19008C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19008C3(Test_S19008C3, "S19008C3", ABISELECT(1392,916));

#else // __cplusplus

extern void _ZN8S19008C3C1Ev();
extern void _ZN8S19008C3D2Ev();
Name_Map name_map_S19008C3[] = {
  NSPAIR(_ZN8S19008C3C1Ev),
  NSPAIR(_ZN8S19008C3D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C5;
extern VTBL_ENTRY _ZTI8S19008C5[];
extern  VTBL_ENTRY _ZTV8S19008C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
static Base_Class bases_S19008C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C4_nt,    ABISELECT(288,204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C4_nt,    ABISELECT(1060,700), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S19008C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19008C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C4_nt,    ABISELECT(304,208), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(304,208), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C6,    ABISELECT(1072,704), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(1280,848), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(1280,848), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19008C10,    ABISELECT(1072,704), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19008C6,    ABISELECT(336,228), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19008C3[];
extern void _ZN8S19008C52v1Ev();
extern void _ZN8S19008C3D1Ev();
extern void _ZN8S19008C3D0Ev();
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
static  VTBL_ENTRY vtc_S19008C3[] = {
  ABISELECT(1072,704),
  ABISELECT(1060,700),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&_ZN8S19008C3D1Ev,
  (VTBL_ENTRY)&_ZN8S19008C3D0Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
  ABISELECT(724,472),
  ABISELECT(-336,-228),
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
  ABISELECT(-12,-4),
  ABISELECT(-1072,-704),
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
};
extern VTBL_ENTRY _ZTV8S19008C3[];
extern void _ZN8S19008C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C5__8S19008C3[] = {
  ABISELECT(1060,700),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C5[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C5__8S19008C3[] = {
  ABISELECT(1060,700),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C6__A2__8S19008C3[] = {
  ABISELECT(724,472),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__8S19008C3[] = {
  ABISELECT(-12,-4),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C10__A1__8S19008C3[] = {
  ABISELECT(-12,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTT_ENTRY vtt_S19008C3[] = {
  {&(_ZTV8S19008C3[4]),  4,15},
  {&(_tg__ZTV8S19008C5__8S19008C3[3]),  3,4},
  {&(_tg__ZTV8S19008C68S19008C5__8S19008C3[3]),  3,3},
  {&(_tg__ZTV8S19008C6__A2__8S19008C3[3]),  3,3},
  {&(_ZTV8S19008C3[15]),  15,15},
  {&(_ZTV8S19008C3[12]),  12,15},
  {&(_tg__ZTV9S19008C10__8S19008C3[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C10__A1__8S19008C3[3]),  3,3},
};
extern VTBL_ENTRY _ZTI8S19008C3[];
extern  VTBL_ENTRY _ZTV8S19008C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C3[];
Class_Descriptor cd_S19008C3 = {  "S19008C3", // class name
  bases_S19008C3, 13,
  &(vtc_S19008C3[0]), // expected_vtbl_contents
  &(vtt_S19008C3[0]), // expected_vtt_contents
  ABISELECT(1392,916), // object size
  NSPAIRA(_ZTI8S19008C3),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S19008C3),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19008C3),8, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19008C13  {
  int s19008c13f0;
  int s19008c13f1:20;
  ::S19008C5 s19008c13f2;
  int s19008c13f3;
  char s19008c13f4[4];
  int s19008c13f5;
  int s19008c13f6;
  int s19008c13f7;
  int s19008c13f8;
  int s19008c13f9;
  int s19008c13f10;
  int s19008c13f11;
  void  mf19008c13(); // _ZN9S19008C1310mf19008c13Ev
};
//SIG(-1 S19008C13) C1{ m Fi Fi:20 FC2{ BC3{ VBC4{ m Fi} Fp FL Fi Fp Fi FU5{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC4 FC6{ BC4 Fi FU7{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC6 v1 Fi FL Fi FL FC4 Fi Fs Fi} Fi Fc[4] Fi Fi Fi Fi Fi Fi Fi}


void  S19008C13 ::mf19008c13(){}

static void Test_S19008C13()
{
  {
    init_simple_test("S19008C13");
    static S19008C13 lv;
    check2(sizeof(lv), ABISELECT(368,252), "sizeof(S19008C13)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19008C13)");
    check_field_offset(lv, s19008c13f0, 0, "S19008C13.s19008c13f0");
    set_bf_and_test(lv, s19008c13f1, 4, 0, 20, 1, "S19008C13");
    set_bf_and_test(lv, s19008c13f1, 4, 0, 20, hide_sll(1LL<<19), "S19008C13");
    check_field_offset(lv, s19008c13f2, ABISELECT(16,8), "S19008C13.s19008c13f2");
    check_field_offset(lv, s19008c13f3, ABISELECT(320,216), "S19008C13.s19008c13f3");
    check_field_offset(lv, s19008c13f4, ABISELECT(324,220), "S19008C13.s19008c13f4");
    check_field_offset(lv, s19008c13f5, ABISELECT(328,224), "S19008C13.s19008c13f5");
    check_field_offset(lv, s19008c13f6, ABISELECT(332,228), "S19008C13.s19008c13f6");
    check_field_offset(lv, s19008c13f7, ABISELECT(336,232), "S19008C13.s19008c13f7");
    check_field_offset(lv, s19008c13f8, ABISELECT(340,236), "S19008C13.s19008c13f8");
    check_field_offset(lv, s19008c13f9, ABISELECT(344,240), "S19008C13.s19008c13f9");
    check_field_offset(lv, s19008c13f10, ABISELECT(348,244), "S19008C13.s19008c13f10");
    check_field_offset(lv, s19008c13f11, ABISELECT(352,248), "S19008C13.s19008c13f11");
  }
}
static Arrange_To_Call_Me vS19008C13(Test_S19008C13, "S19008C13", ABISELECT(368,252));

#else // __cplusplus

extern VTBL_ENTRY _ZTI9S19008C13[];
VTBL_ENTRY *P__ZTI9S19008C13 = _ZTI9S19008C13; 
Class_Descriptor cd_S19008C13 = {  "S19008C13", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(368,252), // object size
  NSPAIRA(_ZTI9S19008C13),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19008C17  : virtual S19008C4_nt , S19008C6 , S19008C10 {
  ::S19008C5 s19008c17f0;
  int s19008c17f1[6];
  int s19008c17f2;
  ::S19008C4_nt s19008c17f3[7];
  int s19008c17f4;
  void *s19008c17f5[2];
  ~S19008C17(); // tgen
  S19008C17(); // tgen
};
//SIG(-1 S19008C17) C1{ VBC2{ m Fi} BC3{ VBC2 Fp FL Fi Fp Fi FU4{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC2 FC5{ BC2 Fi FU6{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC7{ VBC2 BC3 BC5 FL FU6 Fp Fp FC8{} Fi Fi Fp Fc FC8} FC9{ BC3 BC5 v1 Fi FL Fi FL FC2 Fi Fs Fi} Fi[6] Fi FC2[7] Fi Fp[2]}


S19008C17 ::~S19008C17(){ note_dtor("S19008C17", this);} // tgen
S19008C17 ::S19008C17(){ note_ctor("S19008C17", this);} // tgen

static void Test_S19008C17()
{
  extern Class_Descriptor cd_S19008C17;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(59,160)];
    init_test(&cd_S19008C17, buf);
    S19008C17 *dp, &lv = *(dp=new (buf) S19008C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(928,636), "sizeof(S19008C17)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19008C17)");
    /*is_ambiguous_... S19008C17::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*), ABISELECT(912,632), "S19008C17");
    /*is_ambiguous_... S19008C17::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*), ABISELECT(912,632), "S19008C17");
    /*is_ambiguous_... S19008C10::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*), ABISELECT(912,632), "S19008C17");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*), ABISELECT(912,632), "S19008C17");
    /*is_ambiguous_... S19008C17::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C6*), 0, "S19008C17");
    check_base_class_offset(lv, (S19008C6*)(S19008C10*), ABISELECT(208,144), "S19008C17");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*), ABISELECT(416,288), "S19008C17");
    check_base_class_offset(lv, (S19008C8*)(S19008C10*), ABISELECT(416,288), "S19008C17");
    check_base_class_offset(lv, (S19008C10*), ABISELECT(208,144), "S19008C17");
    check_field_offset(lv, s19008c17f0, ABISELECT(528,356), "S19008C17.s19008c17f0");
    check_field_offset(lv, s19008c17f1, ABISELECT(832,564), "S19008C17.s19008c17f1");
    check_field_offset(lv, s19008c17f2, ABISELECT(856,588), "S19008C17.s19008c17f2");
    check_field_offset(lv, s19008c17f3, ABISELECT(860,592), "S19008C17.s19008c17f3");
    check_field_offset(lv, s19008c17f4, ABISELECT(888,620), "S19008C17.s19008c17f4");
    check_field_offset(lv, s19008c17f5, ABISELECT(896,624), "S19008C17.s19008c17f5");
    test_class_info(&lv, &cd_S19008C17);
    dp->~S19008C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19008C17(Test_S19008C17, "S19008C17", ABISELECT(928,636));

#else // __cplusplus

extern void _ZN9S19008C17C1Ev();
extern void _ZN9S19008C17D1Ev();
Name_Map name_map_S19008C17[] = {
  NSPAIR(_ZN9S19008C17C1Ev),
  NSPAIR(_ZN9S19008C17D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
static Base_Class bases_S19008C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C4_nt,    ABISELECT(912,632), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19008C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C6,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(416,288), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(416,288), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19008C10,    ABISELECT(208,144), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19008C17[];
static  VTBL_ENTRY vtc_S19008C17[] = {
  ABISELECT(912,632),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C17[0]),
  ABISELECT(704,488),
  ABISELECT(-208,-144),
  (VTBL_ENTRY)&(_ZTI9S19008C17[0]),
};
extern VTBL_ENTRY _ZTV9S19008C17[];
static  VTBL_ENTRY _tg__ZTV8S19008C6__9S19008C17[] = {
  ABISELECT(912,632),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__9S19008C17[] = {
  ABISELECT(704,488),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C10__A1__9S19008C17[] = {
  ABISELECT(704,488),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTT_ENTRY vtt_S19008C17[] = {
  {&(_ZTV9S19008C17[3]),  3,6},
  {&(_tg__ZTV8S19008C6__9S19008C17[3]),  3,3},
  {&(_tg__ZTV9S19008C10__9S19008C17[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C10__A1__9S19008C17[3]),  3,3},
  {&(_ZTV9S19008C17[6]),  6,6},
};
extern VTBL_ENTRY _ZTI9S19008C17[];
extern  VTBL_ENTRY _ZTV9S19008C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C17[];
Class_Descriptor cd_S19008C17 = {  "S19008C17", // class name
  bases_S19008C17, 6,
  &(vtc_S19008C17[0]), // expected_vtbl_contents
  &(vtt_S19008C17[0]), // expected_vtt_contents
  ABISELECT(928,636), // object size
  NSPAIRA(_ZTI9S19008C17),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S19008C17),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19008C17),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19008C16  : virtual S19008C17 {
  void *s19008c16f0[7];
  int s19008c16f1;
  short s19008c16f2;
  long double s19008c16f3;
  int s19008c16f4;
  ::S19008C5 s19008c16f5;
  int s19008c16f6;
  virtual void  v8(); // _ZN9S19008C162v8Ev
  ~S19008C16(); // tgen
  S19008C16(); // tgen
};
//SIG(-1 S19008C16) C1{ VBC2{ VBC3{ m Fi} BC4{ VBC3 Fp FL Fi Fp Fi FU5{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC3 FC6{ BC3 Fi FU7{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC8{ VBC3 BC4 BC6 FL FU7 Fp Fp FC9{} Fi Fi Fp Fc FC9} FC10{ BC4 BC6 v2 Fi FL Fi FL FC3 Fi Fs Fi} Fi[6] Fi FC3[7] Fi Fp[2]} v1 Fp[7] Fi Fs FD Fi FC10 Fi}


void  S19008C16 ::v8(){vfunc_called(this, "_ZN9S19008C162v8Ev");}
S19008C16 ::~S19008C16(){ note_dtor("S19008C16", this);} // tgen
S19008C16 ::S19008C16(){ note_ctor("S19008C16", this);} // tgen

static void Test_S19008C16()
{
  extern Class_Descriptor cd_S19008C16;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(86,227)];
    init_test(&cd_S19008C16, buf);
    S19008C16 *dp, &lv = *(dp=new (buf) S19008C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1360,904), "sizeof(S19008C16)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19008C16)");
    /*is_ambiguous_... S19008C17::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C17*), ABISELECT(1344,900), "S19008C16");
    /*is_ambiguous_... S19008C17::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C17*), ABISELECT(1344,900), "S19008C16");
    /*is_ambiguous_... S19008C10::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*)(S19008C17*), ABISELECT(1344,900), "S19008C16");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*)(S19008C17*), ABISELECT(1344,900), "S19008C16");
    /*is_ambiguous_... S19008C17::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C17*), ABISELECT(432,268), "S19008C16");
    check_base_class_offset(lv, (S19008C6*)(S19008C10*)(S19008C17*), ABISELECT(640,412), "S19008C16");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*)(S19008C17*), ABISELECT(848,556), "S19008C16");
    check_base_class_offset(lv, (S19008C8*)(S19008C10*)(S19008C17*), ABISELECT(848,556), "S19008C16");
    check_base_class_offset(lv, (S19008C10*)(S19008C17*), ABISELECT(640,412), "S19008C16");
    check_base_class_offset(lv, (S19008C17*), ABISELECT(432,268), "S19008C16");
    check_field_offset(lv, s19008c16f0, ABISELECT(8,4), "S19008C16.s19008c16f0");
    check_field_offset(lv, s19008c16f1, ABISELECT(64,32), "S19008C16.s19008c16f1");
    check_field_offset(lv, s19008c16f2, ABISELECT(68,36), "S19008C16.s19008c16f2");
    check_field_offset(lv, s19008c16f3, ABISELECT(80,40), "S19008C16.s19008c16f3");
    check_field_offset(lv, s19008c16f4, ABISELECT(96,52), "S19008C16.s19008c16f4");
    check_field_offset(lv, s19008c16f5, ABISELECT(112,56), "S19008C16.s19008c16f5");
    check_field_offset(lv, s19008c16f6, ABISELECT(416,264), "S19008C16.s19008c16f6");
    test_class_info(&lv, &cd_S19008C16);
    dp->~S19008C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19008C16(Test_S19008C16, "S19008C16", ABISELECT(1360,904));

#else // __cplusplus

extern void _ZN9S19008C16C1Ev();
extern void _ZN9S19008C16D1Ev();
Name_Map name_map_S19008C16[] = {
  NSPAIR(_ZN9S19008C16C1Ev),
  NSPAIR(_ZN9S19008C16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
extern Class_Descriptor cd_S19008C17;
extern VTBL_ENTRY _ZTI9S19008C17[];
extern  VTBL_ENTRY _ZTV9S19008C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C17[];
static Base_Class bases_S19008C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C4_nt,    ABISELECT(1344,900), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S19008C6,    ABISELECT(432,268), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(640,412), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(848,556), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(848,556), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19008C10,    ABISELECT(640,412), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19008C17,    ABISELECT(432,268), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19008C16[];
extern void _ZN9S19008C162v8Ev();
static  VTBL_ENTRY vtc_S19008C16[] = {
  ABISELECT(1344,900),
  ABISELECT(432,268),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
  ABISELECT(912,632),
  ABISELECT(-432,-268),
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
  ABISELECT(704,488),
  ABISELECT(-640,-412),
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
};
extern VTBL_ENTRY _ZTV9S19008C16[];
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C16[] = {
  ABISELECT(912,632),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C17[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C17__9S19008C16[] = {
  ABISELECT(912,632),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__9S19008C16[] = {
  ABISELECT(704,488),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C109S19008C17__A1__9S19008C16[] = {
  ABISELECT(704,488),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__9S19008C17__9S19008C16[] = {
  ABISELECT(704,488),
  ABISELECT(-208,-144),
  (VTBL_ENTRY)&(_ZTI9S19008C17[0]),
};
static  VTT_ENTRY vtt_S19008C16[] = {
  {&(_ZTV9S19008C16[4]),  4,11},
  {&(_ZTV9S19008C16[8]),  8,11},
  {&(_ZTV9S19008C16[11]),  11,11},
  {&(_tg__ZTV9S19008C17__9S19008C16[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C17__9S19008C16[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__9S19008C16[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C109S19008C17__A1__9S19008C16[3]),  3,3},
  {&(_tg__ZTV9S19008C10__9S19008C17__9S19008C16[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S19008C16[];
extern  VTBL_ENTRY _ZTV9S19008C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C16[];
Class_Descriptor cd_S19008C16 = {  "S19008C16", // class name
  bases_S19008C16, 7,
  &(vtc_S19008C16[0]), // expected_vtbl_contents
  &(vtt_S19008C16[0]), // expected_vtt_contents
  ABISELECT(1360,904), // object size
  NSPAIRA(_ZTI9S19008C16),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV9S19008C16),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19008C16),8, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19008C18  : S19008C10 , S19008C8 , S19008C6 , virtual S19008C3 {
  short s19008c18f0;
  short s19008c18f1;
  ::S19008C8 s19008c18f2[5];
  __tsi64 s19008c18f3;
  long double s19008c18f4;
  __tsi64 s19008c18f5;
  int s19008c18f6;
  int s19008c18f7;
  void *s19008c18f8;
  virtual  ~S19008C18(); // _ZN9S19008C18D2Ev
  virtual void  v9(); // _ZN9S19008C182v9Ev
  virtual void  v10(); // _ZN9S19008C183v10Ev
  S19008C18(); // tgen
};
//SIG(-1 S19008C18) C1{ BC2{ VBC3{ m Fi} BC4{ VBC3 Fp FL Fi Fp Fi FU5{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC3 FC6{ BC3 Fi FU7{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC6 FL FU7 Fp Fp FC8{} Fi Fi Fp Fc FC8} BC6 BC4 VBC9{ BC3 BC10{ BC4 BC6 v3 Fi FL Fi FL FC3 Fi Fs Fi} BC6 VBC2 BC4 vd v4 v5 FU7 FD Fc Fp FL FC6 Fi Fp[10] Fi FC2 Fi} vd v1 v2 Fs Fs FC6[5] FL FD FL Fi Fi Fp}


 S19008C18 ::~S19008C18(){ note_dtor("S19008C18", this);}
void  S19008C18 ::v9(){vfunc_called(this, "_ZN9S19008C182v9Ev");}
void  S19008C18 ::v10(){vfunc_called(this, "_ZN9S19008C183v10Ev");}
S19008C18 ::S19008C18(){ note_ctor("S19008C18", this);} // tgen

static void Test_S19008C18()
{
  extern Class_Descriptor cd_S19008C18;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(137,360)];
    init_test(&cd_S19008C18, buf);
    S19008C18 *dp, &lv = *(dp=new (buf) S19008C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2176,1436), "sizeof(S19008C18)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19008C18)");
    /*is_ambiguous_... S19008C18::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*), ABISELECT(776,520), "S19008C18");
    /*is_ambiguous_... S19008C18::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*), ABISELECT(776,520), "S19008C18");
    /*is_ambiguous_... S19008C18::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*), ABISELECT(776,520), "S19008C18");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C5*)(S19008C3*), ABISELECT(776,520), "S19008C18");
    /*is_ambiguous_... S19008C18::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*), ABISELECT(776,520), "S19008C18");
    /*is_ambiguous_... S19008C18::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*), ABISELECT(776,520), "S19008C18");
    /*is_ambiguous_... S19008C3::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C3*), ABISELECT(776,520), "S19008C18");
    /*is_ambiguous_... S19008C18::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C10*), 0, "S19008C18");
    /*is_ambiguous_... S19008C18::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*), ABISELECT(208,144), "S19008C18");
    /*is_ambiguous_... S19008C18::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C10*), ABISELECT(208,144), "S19008C18");
    /*is_ambiguous_... S19008C18::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C10*), 0, "S19008C18");
    /*is_ambiguous_... S19008C18::S19008C8 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*), ABISELECT(320,212), "S19008C18");
    /*is_ambiguous_... S19008C18::S19008C8 */ AMB_check_base_class_offset(lv, (S19008C8*), ABISELECT(320,212), "S19008C18");
    /*is_ambiguous_... S19008C18::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C6*), ABISELECT(352,232), "S19008C18");
    /*is_ambiguous_... S19008C3::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C3*), ABISELECT(1072,728), "S19008C18");
    check_base_class_offset(lv, (S19008C6*)(S19008C5*)(S19008C3*), ABISELECT(784,524), "S19008C18");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C5*)(S19008C3*), ABISELECT(992,668), "S19008C18");
    check_base_class_offset(lv, (S19008C8*)(S19008C5*)(S19008C3*), ABISELECT(992,668), "S19008C18");
    check_base_class_offset(lv, (S19008C5*)(S19008C3*), ABISELECT(784,524), "S19008C18");
    /*is_ambiguous_... S19008C3::S19008C8 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C3*), ABISELECT(1088,732), "S19008C18");
    /*is_ambiguous_... S19008C3::S19008C8 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C3*), ABISELECT(1088,732), "S19008C18");
    /*is_ambiguous_... S19008C18::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C10*), ABISELECT(1856,1224), "S19008C18");
    /*is_ambiguous_... S19008C18::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*), ABISELECT(2064,1368), "S19008C18");
    /*is_ambiguous_... S19008C18::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C10*), ABISELECT(2064,1368), "S19008C18");
    check_base_class_offset(lv, (S19008C10*)(S19008C3*), ABISELECT(1856,1224), "S19008C18");
    /*is_ambiguous_... S19008C3::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C3*), ABISELECT(1120,752), "S19008C18");
    check_base_class_offset(lv, (S19008C3*), ABISELECT(784,524), "S19008C18");
    check_field_offset(lv, s19008c18f0, ABISELECT(552,376), "S19008C18.s19008c18f0");
    check_field_offset(lv, s19008c18f1, ABISELECT(554,378), "S19008C18.s19008c18f1");
    check_field_offset(lv, s19008c18f2, ABISELECT(560,380), "S19008C18.s19008c18f2");
    check_field_offset(lv, s19008c18f3, ABISELECT(720,480), "S19008C18.s19008c18f3");
    check_field_offset(lv, s19008c18f4, ABISELECT(736,488), "S19008C18.s19008c18f4");
    check_field_offset(lv, s19008c18f5, ABISELECT(752,500), "S19008C18.s19008c18f5");
    check_field_offset(lv, s19008c18f6, ABISELECT(760,508), "S19008C18.s19008c18f6");
    check_field_offset(lv, s19008c18f7, ABISELECT(764,512), "S19008C18.s19008c18f7");
    check_field_offset(lv, s19008c18f8, ABISELECT(768,516), "S19008C18.s19008c18f8");
    test_class_info(&lv, &cd_S19008C18);
    dp->~S19008C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19008C18(Test_S19008C18, "S19008C18", ABISELECT(2176,1436));

#else // __cplusplus

extern void _ZN9S19008C18C1Ev();
extern void _ZN9S19008C18D2Ev();
Name_Map name_map_S19008C18[] = {
  NSPAIR(_ZN9S19008C18C1Ev),
  NSPAIR(_ZN9S19008C18D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C5;
extern VTBL_ENTRY _ZTI8S19008C5[];
extern  VTBL_ENTRY _ZTV8S19008C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C3;
extern VTBL_ENTRY _ZTI8S19008C3[];
extern  VTBL_ENTRY _ZTV8S19008C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C3[];
static Base_Class bases_S19008C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C4_nt,    ABISELECT(776,520), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S19008C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19008C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C4_nt,    ABISELECT(320,212), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(320,212), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C6,    ABISELECT(352,232), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C4_nt,    ABISELECT(1072,728), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(784,524), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(992,668), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(992,668), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19008C5,    ABISELECT(784,524), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(1088,732), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(1088,732), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(1856,1224), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(2064,1368), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(2064,1368), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S19008C10,    ABISELECT(1856,1224), //bcp->offset
    28, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    20, //immediately_derived
  0, 1},
  {&cd_S19008C6,    ABISELECT(1120,752), //bcp->offset
    25, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19008C3,    ABISELECT(784,524), //bcp->offset
    12, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19008C18[];
extern void _ZN9S19008C18D1Ev();
extern void _ZN9S19008C18D0Ev();
extern void _ZN9S19008C182v9Ev();
extern void _ZN9S19008C183v10Ev();
extern void _ZN8S19008C52v1Ev();
extern void ABISELECT(_ZTv0_n48_N9S19008C18D1Ev,_ZTv0_n24_N9S19008C18D1Ev)();
extern void ABISELECT(_ZThn784_N9S19008C18D1Ev,_ZThn524_N9S19008C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19008C18D0Ev,_ZTv0_n24_N9S19008C18D0Ev)();
extern void ABISELECT(_ZThn784_N9S19008C18D0Ev,_ZThn524_N9S19008C18D0Ev)() __attribute__((weak));
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
static  VTBL_ENTRY vtc_S19008C18[] = {
  ABISELECT(1856,1224),
  ABISELECT(784,524),
  ABISELECT(776,520),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
  (VTBL_ENTRY)&_ZN9S19008C18D1Ev,
  (VTBL_ENTRY)&_ZN9S19008C18D0Ev,
  (VTBL_ENTRY)&_ZN9S19008C182v9Ev,
  (VTBL_ENTRY)&_ZN9S19008C183v10Ev,
  ABISELECT(424,288),
  ABISELECT(-352,-232),
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
  0,
  0,
  ABISELECT(-784,-524),
  0,
  ABISELECT(1072,700),
  ABISELECT(-8,-4),
  ABISELECT(-784,-524),
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C18D1Ev,_ZTv0_n24_N9S19008C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C18D0Ev,_ZTv0_n24_N9S19008C18D0Ev),
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
  ABISELECT(-344,-232),
  ABISELECT(-1120,-752),
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
  ABISELECT(-1080,-704),
  ABISELECT(-1856,-1224),
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
};
extern VTBL_ENTRY _ZTV9S19008C18[];
static  VTBL_ENTRY _tg__ZTV9S19008C10__A__9S19008C18[] = {
  ABISELECT(776,520),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C10__9S19008C18[] = {
  ABISELECT(776,520),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C6__A1__9S19008C18[] = {
  ABISELECT(424,288),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
extern void _ZN8S19008C52v1Ev();
extern void _ZN8S19008C3D1Ev();
extern void _ZN8S19008C3D0Ev();
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C3__9S19008C18[] = {
  ABISELECT(1072,700),
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&_ZN8S19008C3D1Ev,
  (VTBL_ENTRY)&_ZN8S19008C3D0Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
};
extern void _ZN8S19008C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C58S19008C3__9S19008C18[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C5[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C58S19008C3__A2__9S19008C18[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C3__A4__9S19008C18[] = {
  ABISELECT(-344,-232),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__8S19008C3__9S19008C18[] = {
  ABISELECT(-1080,-704),
  ABISELECT(-1072,-700),
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C6__A2__8S19008C3__9S19008C18[] = {
  ABISELECT(-344,-232),
  ABISELECT(-336,-228),
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__A1__9S19008C18[] = {
  ABISELECT(-1080,-704),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C10__A3__9S19008C18[] = {
  ABISELECT(-1080,-704),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTT_ENTRY vtt_S19008C18[] = {
  {&(_ZTV9S19008C18[5]),  5,31},
  {&(_tg__ZTV9S19008C10__A__9S19008C18[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C10__9S19008C18[3]),  3,3},
  {&(_tg__ZTV8S19008C6__A1__9S19008C18[3]),  3,3},
  {&(_ZTV9S19008C18[12]),  12,31},
  {&(_ZTV9S19008C18[20]),  20,31},
  {&(_ZTV9S19008C18[31]),  31,31},
  {&(_ZTV9S19008C18[28]),  28,31},
  {&(_tg__ZTV8S19008C3__9S19008C18[4]),  4,9},
  {&(_tg__ZTV8S19008C58S19008C3__9S19008C18[3]),  3,4},
  {&(_tg__ZTV8S19008C68S19008C58S19008C3__A2__9S19008C18[3]),  3,3},
  {&(_tg__ZTV8S19008C68S19008C3__A4__9S19008C18[3]),  3,3},
  {&(_tg__ZTV9S19008C10__8S19008C3__9S19008C18[3]),  3,3},
  {&(_tg__ZTV8S19008C6__A2__8S19008C3__9S19008C18[3]),  3,3},
  {&(_tg__ZTV9S19008C10__A1__9S19008C18[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C10__A3__9S19008C18[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S19008C18[];
extern  VTBL_ENTRY _ZTV9S19008C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C18[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19008C18D0Ev,_ZTv0_n24_N9S19008C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn784_N9S19008C18D0Ev,_ZThn524_N9S19008C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19008C18D1Ev,_ZTv0_n24_N9S19008C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn784_N9S19008C18D1Ev,_ZThn524_N9S19008C18D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19008C18 = {  "S19008C18", // class name
  bases_S19008C18, 21,
  &(vtc_S19008C18[0]), // expected_vtbl_contents
  &(vtt_S19008C18[0]), // expected_vtt_contents
  ABISELECT(2176,1436), // object size
  NSPAIRA(_ZTI9S19008C18),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S19008C18),31, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19008C18),16, //virtual table table var
  9, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19008C15  : virtual S19008C13 , S19008C16 , S19008C5 , S19008C18 {
  int s19008c15f0;
  int s19008c15f1;
  void *s19008c15f2;
  long double s19008c15f3[6];
  int s19008c15f4;
  int s19008c15f5;
  long double s19008c15f6;
  int s19008c15f7;
  int s19008c15f8;
  int s19008c15f9;
  virtual  ~S19008C15(); // _ZN9S19008C15D2Ev
  S19008C15(); // tgen
};
//SIG(-1 S19008C15) C1{ VBC2{ m Fi Fi:20 FC3{ BC4{ VBC5{ m Fi} Fp FL Fi Fp Fi FU6{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC5 FC7{ BC5 Fi FU8{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC7 v2 Fi FL Fi FL FC5 Fi Fs Fi} Fi Fc[4] Fi Fi Fi Fi Fi Fi Fi} BC9{ VBC10{ VBC5 BC4 BC11{ VBC5 BC4 BC7 FL FU8 Fp Fp FC12{} Fi Fi Fp Fc FC12} FC3 Fi[6] Fi FC5[7] Fi Fp[2]} v1 Fp[7] Fi Fs FD Fi FC3 Fi} BC3 BC13{ BC11 BC7 BC4 VBC14{ BC5 BC3 BC7 VBC11 BC4 vd v3 v4 FU8 FD Fc Fp FL FC7 Fi Fp[10] Fi FC11 Fi} vd v5 v6 Fs Fs FC7[5] FL FD FL Fi Fi Fp} vd Fi Fi Fp FD[6] Fi Fi FD Fi Fi Fi}


 S19008C15 ::~S19008C15(){ note_dtor("S19008C15", this);}
S19008C15 ::S19008C15(){ note_ctor("S19008C15", this);} // tgen

static void Test_S19008C15()
{
  extern Class_Descriptor cd_S19008C15;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(273,728)];
    init_test(&cd_S19008C15, buf);
    S19008C15 *dp, &lv = *(dp=new (buf) S19008C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(4352,2908), "sizeof(S19008C15)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19008C15)");
    check_base_class_offset(lv, (S19008C13*), ABISELECT(1664,1108), "S19008C15");
    /*is_ambiguous_... S19008C17::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C17*), ABISELECT(2944,1992), "S19008C15");
    /*is_ambiguous_... S19008C17::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C17*), ABISELECT(2944,1992), "S19008C15");
    /*is_ambiguous_... S19008C10::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*)(S19008C17*), ABISELECT(2944,1992), "S19008C15");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*)(S19008C17*), ABISELECT(2944,1992), "S19008C15");
    /*is_ambiguous_... S19008C15::S19008C5 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C5*), ABISELECT(2944,1992), "S19008C15");
    /*is_ambiguous_... S19008C18::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*)(S19008C18*), ABISELECT(2944,1992), "S19008C15");
    /*is_ambiguous_... S19008C18::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*)(S19008C18*), ABISELECT(2944,1992), "S19008C15");
    /*is_ambiguous_... S19008C18::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C18*), ABISELECT(2944,1992), "S19008C15");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C5*)(S19008C3*), ABISELECT(2944,1992), "S19008C15");
    /*is_ambiguous_... S19008C15::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*), ABISELECT(2944,1992), "S19008C15");
    /*is_ambiguous_... S19008C15::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*), ABISELECT(2944,1992), "S19008C15");
    /*is_ambiguous_... S19008C3::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C3*), ABISELECT(2944,1992), "S19008C15");
    /*is_ambiguous_... S19008C17::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C17*), ABISELECT(2032,1360), "S19008C15");
    check_base_class_offset(lv, (S19008C6*)(S19008C10*)(S19008C17*), ABISELECT(2240,1504), "S19008C15");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*)(S19008C17*), ABISELECT(2448,1648), "S19008C15");
    check_base_class_offset(lv, (S19008C8*)(S19008C10*)(S19008C17*), ABISELECT(2448,1648), "S19008C15");
    check_base_class_offset(lv, (S19008C10*)(S19008C17*), ABISELECT(2240,1504), "S19008C15");
    check_base_class_offset(lv, (S19008C17*)(S19008C16*), ABISELECT(2032,1360), "S19008C15");
    check_base_class_offset(lv, (S19008C16*), 0, "S19008C15");
    /*is_ambiguous_... S19008C15::S19008C5 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C5*), ABISELECT(432,268), "S19008C15");
    /*is_ambiguous_... S19008C15::S19008C5 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C5*), ABISELECT(640,412), "S19008C15");
    /*is_ambiguous_... S19008C15::S19008C5 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C5*), ABISELECT(640,412), "S19008C15");
    /*is_ambiguous_... S19008C15::S19008C5 */ AMB_check_base_class_offset(lv, (S19008C5*), ABISELECT(432,268), "S19008C15");
    /*is_ambiguous_... S19008C18::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C10*)(S19008C18*), ABISELECT(720,472), "S19008C15");
    /*is_ambiguous_... S19008C18::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*)(S19008C18*), ABISELECT(928,616), "S19008C15");
    /*is_ambiguous_... S19008C18::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C10*)(S19008C18*), ABISELECT(928,616), "S19008C15");
    /*is_ambiguous_... S19008C18::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C10*)(S19008C18*), ABISELECT(720,472), "S19008C15");
    /*is_ambiguous_... S19008C18::S19008C8 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C18*), ABISELECT(1040,684), "S19008C15");
    /*is_ambiguous_... S19008C18::S19008C8 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C18*), ABISELECT(1040,684), "S19008C15");
    /*is_ambiguous_... S19008C18::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C18*), ABISELECT(1072,704), "S19008C15");
    /*is_ambiguous_... S19008C3::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C3*), ABISELECT(3248,2200), "S19008C15");
    check_base_class_offset(lv, (S19008C6*)(S19008C5*)(S19008C3*), ABISELECT(2960,1996), "S19008C15");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C5*)(S19008C3*), ABISELECT(3168,2140), "S19008C15");
    check_base_class_offset(lv, (S19008C8*)(S19008C5*)(S19008C3*), ABISELECT(3168,2140), "S19008C15");
    check_base_class_offset(lv, (S19008C5*)(S19008C3*), ABISELECT(2960,1996), "S19008C15");
    /*is_ambiguous_... S19008C3::S19008C8 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C3*), ABISELECT(3264,2204), "S19008C15");
    /*is_ambiguous_... S19008C3::S19008C8 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C3*), ABISELECT(3264,2204), "S19008C15");
    /*is_ambiguous_... S19008C15::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C10*), ABISELECT(4032,2696), "S19008C15");
    /*is_ambiguous_... S19008C15::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*), ABISELECT(4240,2840), "S19008C15");
    /*is_ambiguous_... S19008C15::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C10*), ABISELECT(4240,2840), "S19008C15");
    check_base_class_offset(lv, (S19008C10*)(S19008C3*), ABISELECT(4032,2696), "S19008C15");
    /*is_ambiguous_... S19008C3::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C3*), ABISELECT(3296,2224), "S19008C15");
    check_base_class_offset(lv, (S19008C3*)(S19008C18*), ABISELECT(2960,1996), "S19008C15");
    check_base_class_offset(lv, (S19008C18*), ABISELECT(720,472), "S19008C15");
    check_field_offset(lv, s19008c15f0, ABISELECT(1496,992), "S19008C15.s19008c15f0");
    check_field_offset(lv, s19008c15f1, ABISELECT(1500,996), "S19008C15.s19008c15f1");
    check_field_offset(lv, s19008c15f2, ABISELECT(1504,1000), "S19008C15.s19008c15f2");
    check_field_offset(lv, s19008c15f3, ABISELECT(1520,1004), "S19008C15.s19008c15f3");
    check_field_offset(lv, s19008c15f4, ABISELECT(1616,1076), "S19008C15.s19008c15f4");
    check_field_offset(lv, s19008c15f5, ABISELECT(1620,1080), "S19008C15.s19008c15f5");
    check_field_offset(lv, s19008c15f6, ABISELECT(1632,1084), "S19008C15.s19008c15f6");
    check_field_offset(lv, s19008c15f7, ABISELECT(1648,1096), "S19008C15.s19008c15f7");
    check_field_offset(lv, s19008c15f8, ABISELECT(1652,1100), "S19008C15.s19008c15f8");
    check_field_offset(lv, s19008c15f9, ABISELECT(1656,1104), "S19008C15.s19008c15f9");
    test_class_info(&lv, &cd_S19008C15);
    dp->~S19008C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19008C15(Test_S19008C15, "S19008C15", ABISELECT(4352,2908));

#else // __cplusplus

extern void _ZN9S19008C15C1Ev();
extern void _ZN9S19008C15D2Ev();
Name_Map name_map_S19008C15[] = {
  NSPAIR(_ZN9S19008C15C1Ev),
  NSPAIR(_ZN9S19008C15D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C13;
extern VTBL_ENTRY _ZTI9S19008C13[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
extern Class_Descriptor cd_S19008C17;
extern VTBL_ENTRY _ZTI9S19008C17[];
extern  VTBL_ENTRY _ZTV9S19008C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C17[];
extern Class_Descriptor cd_S19008C16;
extern VTBL_ENTRY _ZTI9S19008C16[];
extern  VTBL_ENTRY _ZTV9S19008C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C16[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C5;
extern VTBL_ENTRY _ZTI8S19008C5[];
extern  VTBL_ENTRY _ZTV8S19008C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C5[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C5;
extern VTBL_ENTRY _ZTI8S19008C5[];
extern  VTBL_ENTRY _ZTV8S19008C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C3;
extern VTBL_ENTRY _ZTI8S19008C3[];
extern  VTBL_ENTRY _ZTV8S19008C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C3[];
extern Class_Descriptor cd_S19008C18;
extern VTBL_ENTRY _ZTI9S19008C18[];
extern  VTBL_ENTRY _ZTV9S19008C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C18[];
static Base_Class bases_S19008C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C13,    ABISELECT(1664,1108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19008C4_nt,    ABISELECT(2944,1992), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S19008C6,    ABISELECT(2032,1360), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(2240,1504), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(2448,1648), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(2448,1648), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19008C10,    ABISELECT(2240,1504), //bcp->offset
    29, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19008C17,    ABISELECT(2032,1360), //bcp->offset
    26, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S19008C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C6,    ABISELECT(432,268), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(640,412), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(640,412), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19008C5,    ABISELECT(432,268), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C6,    ABISELECT(720,472), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(928,616), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(928,616), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19008C10,    ABISELECT(720,472), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(1040,684), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(1040,684), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(1072,704), //bcp->offset
    23, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(3248,2200), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(2960,1996), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    30, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(3168,2140), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(3168,2140), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S19008C5,    ABISELECT(2960,1996), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    29, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(3264,2204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(3264,2204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(4032,2696), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(4240,2840), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(4240,2840), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S19008C10,    ABISELECT(4032,2696), //bcp->offset
    48, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    32, //immediately_derived
  0, 1},
  {&cd_S19008C6,    ABISELECT(3296,2224), //bcp->offset
    45, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    31, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S19008C3,    ABISELECT(2960,1996), //bcp->offset
    32, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    33, //immediately_derived
  0, 1},
  {&cd_S19008C18,    ABISELECT(720,472), //bcp->offset
    14, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19008C15[];
extern void _ZN9S19008C162v8Ev();
extern void _ZN9S19008C15D1Ev();
extern void _ZN9S19008C15D0Ev();
extern void _ZN8S19008C52v1Ev();
extern void ABISELECT(_ZThn720_N9S19008C15D1Ev,_ZThn472_N9S19008C15D1Ev)();
extern void ABISELECT(_ZThn720_N9S19008C15D0Ev,_ZThn472_N9S19008C15D0Ev)();
extern void _ZN9S19008C182v9Ev();
extern void _ZN9S19008C183v10Ev();
extern void _ZN8S19008C52v1Ev();
extern void ABISELECT(_ZTv0_n48_N9S19008C15D1Ev,_ZTv0_n24_N9S19008C15D1Ev)();
extern void ABISELECT(_ZThn2960_N9S19008C15D1Ev,_ZThn1996_N9S19008C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19008C15D0Ev,_ZTv0_n24_N9S19008C15D0Ev)();
extern void ABISELECT(_ZThn2960_N9S19008C15D0Ev,_ZThn1996_N9S19008C15D0Ev)() __attribute__((weak));
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
static  VTBL_ENTRY vtc_S19008C15[] = {
  ABISELECT(4032,2696),
  ABISELECT(2960,1996),
  ABISELECT(1664,1108),
  ABISELECT(2944,1992),
  ABISELECT(2032,1360),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
  (VTBL_ENTRY)&_ZN9S19008C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19008C15D0Ev,
  ABISELECT(2512,1724),
  ABISELECT(-432,-268),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  ABISELECT(3312,2224),
  ABISELECT(2240,1524),
  ABISELECT(2224,1520),
  ABISELECT(-720,-472),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn720_N9S19008C15D1Ev,_ZThn472_N9S19008C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn720_N9S19008C15D0Ev,_ZThn472_N9S19008C15D0Ev),
  (VTBL_ENTRY)&_ZN9S19008C182v9Ev,
  (VTBL_ENTRY)&_ZN9S19008C183v10Ev,
  ABISELECT(1872,1288),
  ABISELECT(-1072,-704),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
  ABISELECT(912,632),
  ABISELECT(-2032,-1360),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
  ABISELECT(704,488),
  ABISELECT(-2240,-1504),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
  0,
  0,
  ABISELECT(-2960,-1996),
  0,
  ABISELECT(1072,700),
  ABISELECT(-16,-4),
  ABISELECT(-2960,-1996),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C15D1Ev,_ZTv0_n24_N9S19008C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C15D0Ev,_ZTv0_n24_N9S19008C15D0Ev),
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
  ABISELECT(-352,-232),
  ABISELECT(-3296,-2224),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
  ABISELECT(-1088,-704),
  ABISELECT(-4032,-2696),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
};
extern VTBL_ENTRY _ZTV9S19008C15[];
extern void _ZN9S19008C162v8Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C16__9S19008C15[] = {
  ABISELECT(2944,1992),
  ABISELECT(2032,1360),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C16__9S19008C15[] = {
  ABISELECT(912,632),
  ABISELECT(-2032,-1360),
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__9S19008C16__9S19008C15[] = {
  ABISELECT(704,488),
  ABISELECT(-2240,-1504),
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
};
extern void _ZN8S19008C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C5__9S19008C15[] = {
  ABISELECT(2512,1724),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C5[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C5__A2__9S19008C15[] = {
  ABISELECT(2512,1724),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
extern void _ZN9S19008C18D1Ev();
extern void _ZN9S19008C18D0Ev();
extern void _ZN9S19008C182v9Ev();
extern void _ZN9S19008C183v10Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C18__9S19008C15[] = {
  ABISELECT(3312,2224),
  ABISELECT(2240,1524),
  ABISELECT(2224,1520),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
  (VTBL_ENTRY)&_ZN9S19008C18D1Ev,
  (VTBL_ENTRY)&_ZN9S19008C18D0Ev,
  (VTBL_ENTRY)&_ZN9S19008C182v9Ev,
  (VTBL_ENTRY)&_ZN9S19008C183v10Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C18__A1__9S19008C15[] = {
  ABISELECT(2224,1520),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C109S19008C18__A3__9S19008C15[] = {
  ABISELECT(2224,1520),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C18__A4__9S19008C15[] = {
  ABISELECT(1872,1288),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C6__A1__9S19008C18__9S19008C15[] = {
  ABISELECT(1872,1288),
  ABISELECT(-352,-232),
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
};
extern void _ZN8S19008C52v1Ev();
extern void ABISELECT(_ZTv0_n48_N9S19008C18D1Ev,_ZTv0_n24_N9S19008C18D1Ev)();
extern void ABISELECT(_ZThn2240_N9S19008C18D1Ev,_ZThn1524_N9S19008C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19008C18D0Ev,_ZTv0_n24_N9S19008C18D0Ev)();
extern void ABISELECT(_ZThn2240_N9S19008C18D0Ev,_ZThn1524_N9S19008C18D0Ev)() __attribute__((weak));
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C3__9S19008C18__9S19008C15[] = {
  0,
  0,
  ABISELECT(-2240,-1524),
  0,
  ABISELECT(1072,700),
  ABISELECT(-16,-4),
  ABISELECT(-2240,-1524),
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C18D1Ev,_ZTv0_n24_N9S19008C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C18D0Ev,_ZTv0_n24_N9S19008C18D0Ev),
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__A1__9S19008C18__9S19008C15[] = {
  ABISELECT(-1088,-704),
  ABISELECT(-3312,-2224),
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C3__A4__9S19008C18__9S19008C15[] = {
  ABISELECT(-352,-232),
  ABISELECT(-2576,-1752),
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C15[] = {
  ABISELECT(912,632),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C17[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C17__9S19008C15[] = {
  ABISELECT(912,632),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__9S19008C15[] = {
  ABISELECT(704,488),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C109S19008C17__A1__9S19008C15[] = {
  ABISELECT(704,488),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__9S19008C17__9S19008C15[] = {
  ABISELECT(704,488),
  ABISELECT(-208,-144),
  (VTBL_ENTRY)&(_ZTI9S19008C17[0]),
};
extern void _ZN8S19008C52v1Ev();
extern void _ZN8S19008C3D1Ev();
extern void _ZN8S19008C3D0Ev();
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C3__9S19008C15[] = {
  ABISELECT(1072,700),
  ABISELECT(-16,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&_ZN8S19008C3D1Ev,
  (VTBL_ENTRY)&_ZN8S19008C3D0Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
};
extern void _ZN8S19008C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C58S19008C3__A1__9S19008C15[] = {
  ABISELECT(-16,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C5[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C58S19008C3__A5__9S19008C15[] = {
  ABISELECT(-16,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C3__A7__9S19008C15[] = {
  ABISELECT(-352,-232),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__8S19008C3__9S19008C15[] = {
  ABISELECT(-1088,-704),
  ABISELECT(-1072,-700),
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C6__A2__8S19008C3__9S19008C15[] = {
  ABISELECT(-352,-232),
  ABISELECT(-336,-228),
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__A2__9S19008C15[] = {
  ABISELECT(-1088,-704),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C10__A6__9S19008C15[] = {
  ABISELECT(-1088,-704),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTT_ENTRY vtt_S19008C15[] = {
  {&(_ZTV9S19008C15[7]),  7,51},
  {&(_tg__ZTV9S19008C16__9S19008C15[4]),  4,5},
  {&(_tg__ZTV9S19008C17__9S19008C16__9S19008C15[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__9S19008C16__9S19008C15[3]),  3,3},
  {&(_tg__ZTV8S19008C5__9S19008C15[3]),  3,4},
  {&(_tg__ZTV8S19008C68S19008C5__A2__9S19008C15[3]),  3,3},
  {&(_tg__ZTV9S19008C18__9S19008C15[5]),  5,9},
  {&(_tg__ZTV9S19008C109S19008C18__A1__9S19008C15[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C109S19008C18__A3__9S19008C15[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C18__A4__9S19008C15[3]),  3,3},
  {&(_tg__ZTV8S19008C6__A1__9S19008C18__9S19008C15[3]),  3,3},
  {&(_tg__ZTV8S19008C3__9S19008C18__9S19008C15[8]),  8,13},
  {&(_tg__ZTV9S19008C10__A1__9S19008C18__9S19008C15[3]),  3,3},
  {&(_tg__ZTV8S19008C68S19008C3__A4__9S19008C18__9S19008C15[3]),  3,3},
  {&(_ZTV9S19008C15[29]),  29,51},
  {&(_ZTV9S19008C15[32]),  32,51},
  {&(_ZTV9S19008C15[13]),  13,51},
  {&(_ZTV9S19008C15[19]),  19,51},
  {&(_ZTV9S19008C15[26]),  26,51},
  {&(_ZTV9S19008C15[40]),  40,51},
  {&(_ZTV9S19008C15[51]),  51,51},
  {&(_ZTV9S19008C15[48]),  48,51},
  {&(_tg__ZTV9S19008C17__9S19008C15[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C17__9S19008C15[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__9S19008C15[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C109S19008C17__A1__9S19008C15[3]),  3,3},
  {&(_tg__ZTV9S19008C10__9S19008C17__9S19008C15[3]),  3,3},
  {&(_tg__ZTV8S19008C3__9S19008C15[4]),  4,9},
  {&(_tg__ZTV8S19008C58S19008C3__A1__9S19008C15[3]),  3,4},
  {&(_tg__ZTV8S19008C68S19008C58S19008C3__A5__9S19008C15[3]),  3,3},
  {&(_tg__ZTV8S19008C68S19008C3__A7__9S19008C15[3]),  3,3},
  {&(_tg__ZTV9S19008C10__8S19008C3__9S19008C15[3]),  3,3},
  {&(_tg__ZTV8S19008C6__A2__8S19008C3__9S19008C15[3]),  3,3},
  {&(_tg__ZTV9S19008C10__A2__9S19008C15[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C10__A6__9S19008C15[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S19008C15[];
extern  VTBL_ENTRY _ZTV9S19008C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C15[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19008C18D0Ev,_ZTv0_n24_N9S19008C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2240_N9S19008C18D0Ev,_ZThn1524_N9S19008C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19008C18D1Ev,_ZTv0_n24_N9S19008C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2240_N9S19008C18D1Ev,_ZThn1524_N9S19008C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19008C15D0Ev,_ZTv0_n24_N9S19008C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2960_N9S19008C15D0Ev,_ZThn1996_N9S19008C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19008C15D1Ev,_ZTv0_n24_N9S19008C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2960_N9S19008C15D1Ev,_ZThn1996_N9S19008C15D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19008C15 = {  "S19008C15", // class name
  bases_S19008C15, 34,
  &(vtc_S19008C15[0]), // expected_vtbl_contents
  &(vtt_S19008C15[0]), // expected_vtt_contents
  ABISELECT(4352,2908), // object size
  NSPAIRA(_ZTI9S19008C15),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S19008C15),51, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19008C15),35, //virtual table table var
  17, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19008C19  : S19008C3 , S19008C6 , S19008C13 , virtual S19008C15 {
  int s19008c19f0;
  __tsi64 s19008c19f1;
  ::S19008C7 s19008c19f2;
  int s19008c19f3;
  int s19008c19f4;
  ::S19008C11_nt s19008c19f5;
  ::S19008C3 s19008c19f6;
  virtual  ~S19008C19(); // _ZN9S19008C19D2Ev
  S19008C19(); // tgen
};
//SIG(-1 S19008C19) C1{ BC2{ BC3{ m Fi} BC4{ BC5{ VBC3 Fp FL Fi Fp Fi FU6{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC3 FC7{ BC3 Fi FU8{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC7 v1 Fi FL Fi FL FC3 Fi Fs Fi} BC7 VBC9{ VBC3 BC5 BC7 FL FU8 Fp Fp FC10{} Fi Fi Fp Fc FC10} BC5 vd v2 v3 FU8 FD Fc Fp FL FC7 Fi Fp[10] Fi FC9 Fi} BC5 BC11{ m Fi Fi:20 FC4 Fi Fc[4] Fi Fi Fi Fi Fi Fi Fi} VBC12{ VBC11 BC13{ VBC14{ VBC3 BC5 BC9 FC4 Fi[6] Fi FC3[7] Fi Fp[2]} v4 Fp[7] Fi Fs FD Fi FC4 Fi} BC4 BC15{ BC9 BC7 BC5 VBC2 vd v5 v6 Fs Fs FC7[5] FL FD FL Fi Fi Fp} vd Fi Fi Fp FD[6] Fi Fi FD Fi Fi Fi} vd Fi FL FU6 Fi Fi FC10 FC2}


 S19008C19 ::~S19008C19(){ note_dtor("S19008C19", this);}
S19008C19 ::S19008C19(){ note_ctor("S19008C19", this);} // tgen

static void Test_S19008C19()
{
  extern Class_Descriptor cd_S19008C19;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(469,1255)];
    init_test(&cd_S19008C19, buf);
    S19008C19 *dp, &lv = *(dp=new (buf) S19008C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(7488,5016), "sizeof(S19008C19)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19008C19)");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C3*), ABISELECT(288,204), "S19008C19");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C5*)(S19008C3*), ABISELECT(3136,2108), "S19008C19");
    /*is_ambiguous_... S19008C19::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*), ABISELECT(3136,2108), "S19008C19");
    /*is_ambiguous_... S19008C19::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*), ABISELECT(3136,2108), "S19008C19");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C3*), ABISELECT(3136,2108), "S19008C19");
    /*is_ambiguous_... S19008C19::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*), ABISELECT(3136,2108), "S19008C19");
    /*is_ambiguous_... S19008C17::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C17*), ABISELECT(3136,2108), "S19008C19");
    /*is_ambiguous_... S19008C17::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C17*), ABISELECT(3136,2108), "S19008C19");
    /*is_ambiguous_... S19008C10::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*)(S19008C17*), ABISELECT(3136,2108), "S19008C19");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*)(S19008C17*), ABISELECT(3136,2108), "S19008C19");
    /*is_ambiguous_... S19008C15::S19008C5 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C5*)(S19008C15*), ABISELECT(3136,2108), "S19008C19");
    /*is_ambiguous_... S19008C18::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*)(S19008C18*)(S19008C15*), ABISELECT(3136,2108), "S19008C19");
    /*is_ambiguous_... S19008C18::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*)(S19008C18*)(S19008C15*), ABISELECT(3136,2108), "S19008C19");
    /*is_ambiguous_... S19008C18::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C18*)(S19008C15*), ABISELECT(3136,2108), "S19008C19");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C5*)(S19008C3*), ABISELECT(3136,2108), "S19008C19");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C3*), ABISELECT(3136,2108), "S19008C19");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C5*)(S19008C3*), 0, "S19008C19");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C5*)(S19008C3*), ABISELECT(208,144), "S19008C19");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C5*)(S19008C3*), ABISELECT(208,144), "S19008C19");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C5*)(S19008C3*), 0, "S19008C19");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C3*), ABISELECT(304,208), "S19008C19");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C3*), ABISELECT(304,208), "S19008C19");
    /*is_ambiguous_... S19008C19::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C10*), ABISELECT(3152,2112), "S19008C19");
    /*is_ambiguous_... S19008C19::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*), ABISELECT(3360,2256), "S19008C19");
    /*is_ambiguous_... S19008C19::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C10*), ABISELECT(3360,2256), "S19008C19");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C10*)(S19008C3*), ABISELECT(3152,2112), "S19008C19");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C10*)(S19008C3*), ABISELECT(3152,2112), "S19008C19");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C3*), ABISELECT(336,228), "S19008C19");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C3*), 0, "S19008C19");
    /*is_ambiguous_... S19008C19::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C6*), ABISELECT(1072,700), "S19008C19");
    /*is_ambiguous_... S19008C19::S19008C13 */ AMB_check_base_class_offset(lv, (S19008C13*), ABISELECT(1280,844), "S19008C19");
    check_base_class_offset(lv, (S19008C13*)(S19008C15*), ABISELECT(5136,3432), "S19008C19");
    /*is_ambiguous_... S19008C17::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C17*), ABISELECT(5504,3684), "S19008C19");
    check_base_class_offset(lv, (S19008C6*)(S19008C10*)(S19008C17*), ABISELECT(5712,3828), "S19008C19");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*)(S19008C17*), ABISELECT(5920,3972), "S19008C19");
    check_base_class_offset(lv, (S19008C8*)(S19008C10*)(S19008C17*), ABISELECT(5920,3972), "S19008C19");
    check_base_class_offset(lv, (S19008C10*)(S19008C17*), ABISELECT(5712,3828), "S19008C19");
    check_base_class_offset(lv, (S19008C17*)(S19008C16*)(S19008C15*), ABISELECT(5504,3684), "S19008C19");
    check_base_class_offset(lv, (S19008C16*)(S19008C15*), ABISELECT(3472,2324), "S19008C19");
    /*is_ambiguous_... S19008C15::S19008C5 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C5*)(S19008C15*), ABISELECT(3904,2592), "S19008C19");
    /*is_ambiguous_... S19008C15::S19008C5 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C5*)(S19008C15*), ABISELECT(4112,2736), "S19008C19");
    /*is_ambiguous_... S19008C15::S19008C5 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C5*)(S19008C15*), ABISELECT(4112,2736), "S19008C19");
    /*is_ambiguous_... S19008C15::S19008C5 */ AMB_check_base_class_offset(lv, (S19008C5*)(S19008C15*), ABISELECT(3904,2592), "S19008C19");
    /*is_ambiguous_... S19008C18::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C10*)(S19008C18*)(S19008C15*), ABISELECT(4192,2796), "S19008C19");
    /*is_ambiguous_... S19008C18::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*)(S19008C18*)(S19008C15*), ABISELECT(4400,2940), "S19008C19");
    /*is_ambiguous_... S19008C18::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C10*)(S19008C18*)(S19008C15*), ABISELECT(4400,2940), "S19008C19");
    /*is_ambiguous_... S19008C18::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C10*)(S19008C18*)(S19008C15*), ABISELECT(4192,2796), "S19008C19");
    /*is_ambiguous_... S19008C18::S19008C8 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C18*)(S19008C15*), ABISELECT(4512,3008), "S19008C19");
    /*is_ambiguous_... S19008C18::S19008C8 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C18*)(S19008C15*), ABISELECT(4512,3008), "S19008C19");
    /*is_ambiguous_... S19008C18::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C18*)(S19008C15*), ABISELECT(4544,3028), "S19008C19");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C3*), ABISELECT(6704,4520), "S19008C19");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C5*)(S19008C3*), ABISELECT(6416,4316), "S19008C19");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C5*)(S19008C3*), ABISELECT(6624,4460), "S19008C19");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C5*)(S19008C3*), ABISELECT(6624,4460), "S19008C19");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C5*)(S19008C3*), ABISELECT(6416,4316), "S19008C19");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C3*), ABISELECT(6720,4524), "S19008C19");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C3*), ABISELECT(6720,4524), "S19008C19");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C3*), ABISELECT(6752,4544), "S19008C19");
    check_base_class_offset(lv, (S19008C3*)(S19008C18*)(S19008C15*), ABISELECT(6416,4316), "S19008C19");
    check_base_class_offset(lv, (S19008C18*)(S19008C15*), ABISELECT(4192,2796), "S19008C19");
    check_base_class_offset(lv, (S19008C15*), ABISELECT(3472,2324), "S19008C19");
    check_field_offset(lv, s19008c19f0, ABISELECT(1636,1096), "S19008C19.s19008c19f0");
    check_field_offset(lv, s19008c19f1, ABISELECT(1640,1100), "S19008C19.s19008c19f1");
    check_field_offset(lv, s19008c19f2, ABISELECT(1648,1108), "S19008C19.s19008c19f2");
    check_field_offset(lv, s19008c19f3, ABISELECT(1720,1180), "S19008C19.s19008c19f3");
    check_field_offset(lv, s19008c19f4, ABISELECT(1724,1184), "S19008C19.s19008c19f4");
    check_field_offset(lv, s19008c19f5, ABISELECT(1728,1188), "S19008C19.s19008c19f5");
    check_field_offset(lv, s19008c19f6, ABISELECT(1744,1192), "S19008C19.s19008c19f6");
    test_class_info(&lv, &cd_S19008C19);
    dp->~S19008C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19008C19(Test_S19008C19, "S19008C19", ABISELECT(7488,5016));

#else // __cplusplus

extern void _ZN9S19008C19C1Ev();
extern void _ZN9S19008C19D2Ev();
Name_Map name_map_S19008C19[] = {
  NSPAIR(_ZN9S19008C19C1Ev),
  NSPAIR(_ZN9S19008C19D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C5;
extern VTBL_ENTRY _ZTI8S19008C5[];
extern  VTBL_ENTRY _ZTV8S19008C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C3;
extern VTBL_ENTRY _ZTI8S19008C3[];
extern  VTBL_ENTRY _ZTV8S19008C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C3[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C13;
extern VTBL_ENTRY _ZTI9S19008C13[];
extern Class_Descriptor cd_S19008C13;
extern VTBL_ENTRY _ZTI9S19008C13[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
extern Class_Descriptor cd_S19008C17;
extern VTBL_ENTRY _ZTI9S19008C17[];
extern  VTBL_ENTRY _ZTV9S19008C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C17[];
extern Class_Descriptor cd_S19008C16;
extern VTBL_ENTRY _ZTI9S19008C16[];
extern  VTBL_ENTRY _ZTV9S19008C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C16[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C5;
extern VTBL_ENTRY _ZTI8S19008C5[];
extern  VTBL_ENTRY _ZTV8S19008C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C5[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C5;
extern VTBL_ENTRY _ZTI8S19008C5[];
extern  VTBL_ENTRY _ZTV8S19008C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C3;
extern VTBL_ENTRY _ZTI8S19008C3[];
extern  VTBL_ENTRY _ZTV8S19008C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C3[];
extern Class_Descriptor cd_S19008C18;
extern VTBL_ENTRY _ZTI9S19008C18[];
extern  VTBL_ENTRY _ZTV9S19008C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C18[];
extern Class_Descriptor cd_S19008C15;
extern VTBL_ENTRY _ZTI9S19008C15[];
extern  VTBL_ENTRY _ZTV9S19008C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C15[];
static Base_Class bases_S19008C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C4_nt,    ABISELECT(288,204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(3136,2108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S19008C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19008C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(304,208), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(304,208), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(3152,2112), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(3360,2256), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(3360,2256), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19008C10,    ABISELECT(3152,2112), //bcp->offset
    19, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S19008C6,    ABISELECT(336,228), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19008C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C6,    ABISELECT(1072,700), //bcp->offset
    16, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C13,    ABISELECT(1280,844), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C13,    ABISELECT(5136,3432), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    45, //immediately_derived
  0, 1},
  {&cd_S19008C6,    ABISELECT(5504,3684), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    45, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(5712,3828), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    47, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(5920,3972), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(5920,3972), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19008C10,    ABISELECT(5712,3828), //bcp->offset
    56, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    46, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S19008C17,    ABISELECT(5504,3684), //bcp->offset
    53, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    44, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    23, //immediately_derived
  0, 1},
  {&cd_S19008C16,    ABISELECT(3472,2324), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    45, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(3904,2592), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    27, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(4112,2736), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(4112,2736), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S19008C5,    ABISELECT(3904,2592), //bcp->offset
    37, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    45, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(4192,2796), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    30, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(4400,2940), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(4400,2940), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S19008C10,    ABISELECT(4192,2796), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    29, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(4512,3008), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(4512,3008), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(4544,3028), //bcp->offset
    50, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    31, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(6704,4520), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(6416,4316), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    51, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(6624,4460), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(6624,4460), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S19008C5,    ABISELECT(6416,4316), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    50, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(6720,4524), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(6720,4524), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(6752,4544), //bcp->offset
    72, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    52, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S19008C3,    ABISELECT(6416,4316), //bcp->offset
    59, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    49, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    44, //immediately_derived
  0, 1},
  {&cd_S19008C18,    ABISELECT(4192,2796), //bcp->offset
    41, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    45, //immediately_derived
  0, 0},
  {&cd_S19008C15,    ABISELECT(3472,2324), //bcp->offset
    22, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19008C19[];
extern void _ZN8S19008C52v1Ev();
extern void _ZN9S19008C19D1Ev();
extern void _ZN9S19008C19D0Ev();
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
extern void _ZN9S19008C162v8Ev();
extern void ABISELECT(_ZTv0_n72_N9S19008C19D1Ev,_ZTv0_n36_N9S19008C19D1Ev)();
extern void ABISELECT(_ZThn3472_N9S19008C19D1Ev,_ZThn2324_N9S19008C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S19008C19D0Ev,_ZTv0_n36_N9S19008C19D0Ev)();
extern void ABISELECT(_ZThn3472_N9S19008C19D0Ev,_ZThn2324_N9S19008C19D0Ev)() __attribute__((weak));
extern void _ZN8S19008C52v1Ev();
extern void ABISELECT(_ZTvn720_n72_N9S19008C19D1Ev,_ZTvn472_n36_N9S19008C19D1Ev)();
extern void ABISELECT(_ZTvn720_n72_N9S19008C19D0Ev,_ZTvn472_n36_N9S19008C19D0Ev)();
extern void _ZN9S19008C182v9Ev();
extern void _ZN9S19008C183v10Ev();
extern void _ZN8S19008C52v1Ev();
extern void ABISELECT(_ZTv0_n48_N9S19008C19D1Ev,_ZTv0_n24_N9S19008C19D1Ev)();
extern void ABISELECT(_ZThn6416_N9S19008C19D1Ev,_ZThn4316_N9S19008C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19008C19D0Ev,_ZTv0_n24_N9S19008C19D0Ev)();
extern void ABISELECT(_ZThn6416_N9S19008C19D0Ev,_ZThn4316_N9S19008C19D0Ev)() __attribute__((weak));
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
static  VTBL_ENTRY vtc_S19008C19[] = {
  ABISELECT(6416,4316),
  ABISELECT(5504,3684),
  ABISELECT(5136,3432),
  ABISELECT(3472,2324),
  ABISELECT(3152,2112),
  ABISELECT(3136,2108),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&_ZN9S19008C19D1Ev,
  (VTBL_ENTRY)&_ZN9S19008C19D0Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
  ABISELECT(2800,1880),
  ABISELECT(-336,-228),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
  ABISELECT(2064,1408),
  ABISELECT(-1072,-700),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
  ABISELECT(-16,-4),
  ABISELECT(-3152,-2112),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
  ABISELECT(720,472),
  ABISELECT(720,472),
  ABISELECT(432,268),
  ABISELECT(-3472,-2324),
  0,
  ABISELECT(-320,-212),
  ABISELECT(2944,1992),
  ABISELECT(1664,1108),
  ABISELECT(-336,-216),
  ABISELECT(2032,1360),
  ABISELECT(-3472,-2324),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S19008C19D1Ev,_ZTv0_n36_N9S19008C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S19008C19D0Ev,_ZTv0_n36_N9S19008C19D0Ev),
  ABISELECT(-768,-484),
  ABISELECT(-3904,-2592),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  ABISELECT(-1040,-684),
  ABISELECT(2224,1520),
  ABISELECT(-1056,-688),
  ABISELECT(-4192,-2796),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn720_n72_N9S19008C19D1Ev,_ZTvn472_n36_N9S19008C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn720_n72_N9S19008C19D0Ev,_ZTvn472_n36_N9S19008C19D0Ev),
  (VTBL_ENTRY)&_ZN9S19008C182v9Ev,
  (VTBL_ENTRY)&_ZN9S19008C183v10Ev,
  ABISELECT(-1408,-920),
  ABISELECT(-4544,-3028),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
  ABISELECT(-2368,-1576),
  ABISELECT(-5504,-3684),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
  ABISELECT(-2576,-1720),
  ABISELECT(-5712,-3828),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
  0,
  0,
  ABISELECT(-6416,-4316),
  0,
  ABISELECT(-3264,-2204),
  ABISELECT(-3280,-2208),
  ABISELECT(-6416,-4316),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C19D1Ev,_ZTv0_n24_N9S19008C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C19D0Ev,_ZTv0_n24_N9S19008C19D0Ev),
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
  ABISELECT(-3616,-2436),
  ABISELECT(-6752,-4544),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
};
extern VTBL_ENTRY _ZTV9S19008C19[];
extern void _ZN8S19008C52v1Ev();
extern void _ZN8S19008C3D1Ev();
extern void _ZN8S19008C3D0Ev();
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C3__A__9S19008C19[] = {
  ABISELECT(3152,2112),
  ABISELECT(3136,2108),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&_ZN8S19008C3D1Ev,
  (VTBL_ENTRY)&_ZN8S19008C3D0Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
};
extern void _ZN8S19008C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C58S19008C3__9S19008C19[] = {
  ABISELECT(3136,2108),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C5[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C58S19008C3__9S19008C19[] = {
  ABISELECT(3136,2108),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C3__A2__9S19008C19[] = {
  ABISELECT(2800,1880),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__8S19008C3__A__9S19008C19[] = {
  ABISELECT(-16,-4),
  ABISELECT(-3152,-2112),
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C6__A2__8S19008C3__A__9S19008C19[] = {
  ABISELECT(2800,1880),
  ABISELECT(-336,-228),
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C6__A3__9S19008C19[] = {
  ABISELECT(2064,1408),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__9S19008C19[] = {
  ABISELECT(-16,-4),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C10__A1__9S19008C19[] = {
  ABISELECT(-16,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
extern void _ZN9S19008C162v8Ev();
extern void _ZN9S19008C15D1Ev();
extern void _ZN9S19008C15D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C15__9S19008C19[] = {
  ABISELECT(-320,-212),
  ABISELECT(2944,1992),
  ABISELECT(1664,1108),
  ABISELECT(-336,-216),
  ABISELECT(2032,1360),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
  (VTBL_ENTRY)&_ZN9S19008C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19008C15D0Ev,
};
extern void _ZN9S19008C162v8Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C169S19008C15__9S19008C19[] = {
  ABISELECT(-336,-216),
  ABISELECT(2032,1360),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C169S19008C15__9S19008C19[] = {
  ABISELECT(-2368,-1576),
  ABISELECT(-2032,-1360),
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__9S19008C169S19008C15__9S19008C19[] = {
  ABISELECT(-2576,-1720),
  ABISELECT(-2240,-1504),
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
};
extern void _ZN8S19008C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C59S19008C15__A1__9S19008C19[] = {
  ABISELECT(-768,-484),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C5[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C59S19008C15__A6__9S19008C19[] = {
  ABISELECT(-768,-484),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
extern void _ZN9S19008C18D1Ev();
extern void _ZN9S19008C18D0Ev();
extern void _ZN9S19008C182v9Ev();
extern void _ZN9S19008C183v10Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C189S19008C15__9S19008C19[] = {
  ABISELECT(-1040,-684),
  ABISELECT(2224,1520),
  ABISELECT(-1056,-688),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
  (VTBL_ENTRY)&_ZN9S19008C18D1Ev,
  (VTBL_ENTRY)&_ZN9S19008C18D0Ev,
  (VTBL_ENTRY)&_ZN9S19008C182v9Ev,
  (VTBL_ENTRY)&_ZN9S19008C183v10Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C189S19008C15__A2__9S19008C19[] = {
  ABISELECT(-1056,-688),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C109S19008C189S19008C15__A7__9S19008C19[] = {
  ABISELECT(-1056,-688),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C189S19008C15__A8__9S19008C19[] = {
  ABISELECT(-1408,-920),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C6__A1__9S19008C189S19008C15__9S19008C19[] = {
  ABISELECT(-1408,-920),
  ABISELECT(-352,-232),
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
};
extern void _ZN8S19008C52v1Ev();
extern void ABISELECT(_ZTv0_n48_N9S19008C18D1Ev,_ZTv0_n24_N9S19008C18D1Ev)();
extern void ABISELECT(_ZThn2224_N9S19008C18D1Ev,_ZThn1520_N9S19008C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19008C18D0Ev,_ZTv0_n24_N9S19008C18D0Ev)();
extern void ABISELECT(_ZThn2224_N9S19008C18D0Ev,_ZThn1520_N9S19008C18D0Ev)() __attribute__((weak));
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C3__9S19008C189S19008C15__9S19008C19[] = {
  0,
  0,
  ABISELECT(-2224,-1520),
  0,
  ABISELECT(-3264,-2204),
  ABISELECT(-3280,-2208),
  ABISELECT(-2224,-1520),
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C18D1Ev,_ZTv0_n24_N9S19008C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C18D0Ev,_ZTv0_n24_N9S19008C18D0Ev),
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__A1__9S19008C189S19008C15__9S19008C19[] = {
  ABISELECT(-16,-4),
  ABISELECT(1040,684),
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C3__A4__9S19008C189S19008C15__9S19008C19[] = {
  ABISELECT(-3616,-2436),
  ABISELECT(-2560,-1748),
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C15__9S19008C19[] = {
  ABISELECT(-2368,-1576),
  ABISELECT(-2032,-1360),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__9S19008C15__9S19008C19[] = {
  ABISELECT(-2576,-1720),
  ABISELECT(-2240,-1504),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
};
extern void _ZN8S19008C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C5__9S19008C15__9S19008C19[] = {
  ABISELECT(-768,-484),
  ABISELECT(-432,-268),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
};
extern void ABISELECT(_ZThn720_N9S19008C15D1Ev,_ZThn472_N9S19008C15D1Ev)();
extern void ABISELECT(_ZThn720_N9S19008C15D0Ev,_ZThn472_N9S19008C15D0Ev)();
extern void _ZN9S19008C182v9Ev();
extern void _ZN9S19008C183v10Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C18__9S19008C15__9S19008C19[] = {
  ABISELECT(-1040,-684),
  ABISELECT(2224,1520),
  ABISELECT(-1056,-688),
  ABISELECT(-720,-472),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn720_N9S19008C15D1Ev,_ZThn472_N9S19008C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn720_N9S19008C15D0Ev,_ZThn472_N9S19008C15D0Ev),
  (VTBL_ENTRY)&_ZN9S19008C182v9Ev,
  (VTBL_ENTRY)&_ZN9S19008C183v10Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C18__A4__9S19008C15__9S19008C19[] = {
  ABISELECT(-1408,-920),
  ABISELECT(-1072,-704),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
};
extern void _ZN8S19008C52v1Ev();
extern void ABISELECT(_ZTv0_n48_N9S19008C15D1Ev,_ZTv0_n24_N9S19008C15D1Ev)();
extern void ABISELECT(_ZThn2944_N9S19008C15D1Ev,_ZThn1992_N9S19008C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19008C15D0Ev,_ZTv0_n24_N9S19008C15D0Ev)();
extern void ABISELECT(_ZThn2944_N9S19008C15D0Ev,_ZThn1992_N9S19008C15D0Ev)() __attribute__((weak));
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C3__9S19008C15__9S19008C19[] = {
  0,
  0,
  ABISELECT(-2944,-1992),
  0,
  ABISELECT(-3264,-2204),
  ABISELECT(-3280,-2208),
  ABISELECT(-2944,-1992),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C15D1Ev,_ZTv0_n24_N9S19008C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C15D0Ev,_ZTv0_n24_N9S19008C15D0Ev),
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__A2__9S19008C15__9S19008C19[] = {
  ABISELECT(-16,-4),
  ABISELECT(320,212),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C3__A7__9S19008C15__9S19008C19[] = {
  ABISELECT(-3616,-2436),
  ABISELECT(-3280,-2220),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C19[] = {
  ABISELECT(-2368,-1576),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C17[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C17__A4__9S19008C19[] = {
  ABISELECT(-2368,-1576),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__A1__9S19008C19[] = {
  ABISELECT(-2576,-1720),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C109S19008C17__A5__9S19008C19[] = {
  ABISELECT(-2576,-1720),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__9S19008C17__9S19008C19[] = {
  ABISELECT(-2576,-1720),
  ABISELECT(-208,-144),
  (VTBL_ENTRY)&(_ZTI9S19008C17[0]),
};
extern void _ZN8S19008C52v1Ev();
extern void _ZN8S19008C3D1Ev();
extern void _ZN8S19008C3D0Ev();
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C3__A1__9S19008C19[] = {
  ABISELECT(-3264,-2204),
  ABISELECT(-3280,-2208),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&_ZN8S19008C3D1Ev,
  (VTBL_ENTRY)&_ZN8S19008C3D0Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
};
extern void _ZN8S19008C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C58S19008C3__A2__9S19008C19[] = {
  ABISELECT(-3280,-2208),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C5[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C58S19008C3__A9__9S19008C19[] = {
  ABISELECT(-3280,-2208),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C3__A10__9S19008C19[] = {
  ABISELECT(-3616,-2436),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__8S19008C3__A1__9S19008C19[] = {
  ABISELECT(-16,-4),
  ABISELECT(3264,2204),
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C6__A2__8S19008C3__A1__9S19008C19[] = {
  ABISELECT(-3616,-2436),
  ABISELECT(-336,-228),
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
};
static  VTT_ENTRY vtt_S19008C19[] = {
  {&(_ZTV9S19008C19[8]),  8,75},
  {&(_tg__ZTV8S19008C3__A__9S19008C19[4]),  4,9},
  {&(_tg__ZTV8S19008C58S19008C3__9S19008C19[3]),  3,4},
  {&(_tg__ZTV8S19008C68S19008C58S19008C3__9S19008C19[3]),  3,3},
  {&(_tg__ZTV8S19008C68S19008C3__A2__9S19008C19[3]),  3,3},
  {&(_tg__ZTV9S19008C10__8S19008C3__A__9S19008C19[3]),  3,3},
  {&(_tg__ZTV8S19008C6__A2__8S19008C3__A__9S19008C19[3]),  3,3},
  {&(_tg__ZTV8S19008C6__A3__9S19008C19[3]),  3,3},
  {&(_ZTV9S19008C19[22]),  22,75},
  {&(_ZTV9S19008C19[16]),  16,75},
  {&(_ZTV9S19008C19[19]),  19,75},
  {&(_ZTV9S19008C19[34]),  34,75},
  {&(_ZTV9S19008C19[56]),  56,75},
  {&(_ZTV9S19008C19[59]),  59,75},
  {&(_ZTV9S19008C19[40]),  40,75},
  {&(_ZTV9S19008C19[46]),  46,75},
  {&(_ZTV9S19008C19[53]),  53,75},
  {&(_ZTV9S19008C19[67]),  67,75},
  {&(_ZTV9S19008C19[75]),  75,75},
  {&(_tg__ZTV9S19008C10__9S19008C19[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C10__A1__9S19008C19[3]),  3,3},
  {&(_tg__ZTV9S19008C15__9S19008C19[7]),  7,10},
  {&(_tg__ZTV9S19008C169S19008C15__9S19008C19[4]),  4,5},
  {&(_tg__ZTV9S19008C17__9S19008C169S19008C15__9S19008C19[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__9S19008C169S19008C15__9S19008C19[3]),  3,3},
  {&(_tg__ZTV8S19008C59S19008C15__A1__9S19008C19[3]),  3,4},
  {&(_tg__ZTV8S19008C68S19008C59S19008C15__A6__9S19008C19[3]),  3,3},
  {&(_tg__ZTV9S19008C189S19008C15__9S19008C19[5]),  5,9},
  {&(_tg__ZTV9S19008C109S19008C189S19008C15__A2__9S19008C19[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C109S19008C189S19008C15__A7__9S19008C19[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C189S19008C15__A8__9S19008C19[3]),  3,3},
  {&(_tg__ZTV8S19008C6__A1__9S19008C189S19008C15__9S19008C19[3]),  3,3},
  {&(_tg__ZTV8S19008C3__9S19008C189S19008C15__9S19008C19[8]),  8,13},
  {&(_tg__ZTV9S19008C10__A1__9S19008C189S19008C15__9S19008C19[3]),  3,3},
  {&(_tg__ZTV8S19008C68S19008C3__A4__9S19008C189S19008C15__9S19008C19[3]),  3,3},
  {&(_tg__ZTV9S19008C17__9S19008C15__9S19008C19[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__9S19008C15__9S19008C19[3]),  3,3},
  {&(_tg__ZTV8S19008C5__9S19008C15__9S19008C19[3]),  3,4},
  {&(_tg__ZTV9S19008C18__9S19008C15__9S19008C19[5]),  5,9},
  {&(_tg__ZTV8S19008C69S19008C18__A4__9S19008C15__9S19008C19[3]),  3,3},
  {&(_tg__ZTV8S19008C3__9S19008C15__9S19008C19[8]),  8,13},
  {&(_tg__ZTV9S19008C10__A2__9S19008C15__9S19008C19[3]),  3,3},
  {&(_tg__ZTV8S19008C68S19008C3__A7__9S19008C15__9S19008C19[3]),  3,3},
  {&(_tg__ZTV9S19008C17__9S19008C19[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C17__A4__9S19008C19[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__A1__9S19008C19[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C109S19008C17__A5__9S19008C19[3]),  3,3},
  {&(_tg__ZTV9S19008C10__9S19008C17__9S19008C19[3]),  3,3},
  {&(_tg__ZTV8S19008C3__A1__9S19008C19[4]),  4,9},
  {&(_tg__ZTV8S19008C58S19008C3__A2__9S19008C19[3]),  3,4},
  {&(_tg__ZTV8S19008C68S19008C58S19008C3__A9__9S19008C19[3]),  3,3},
  {&(_tg__ZTV8S19008C68S19008C3__A10__9S19008C19[3]),  3,3},
  {&(_tg__ZTV9S19008C10__8S19008C3__A1__9S19008C19[3]),  3,3},
  {&(_tg__ZTV8S19008C6__A2__8S19008C3__A1__9S19008C19[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S19008C19[];
extern  VTBL_ENTRY _ZTV9S19008C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C19[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19008C15D0Ev,_ZTv0_n24_N9S19008C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2944_N9S19008C15D0Ev,_ZThn1992_N9S19008C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19008C15D1Ev,_ZTv0_n24_N9S19008C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2944_N9S19008C15D1Ev,_ZThn1992_N9S19008C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19008C18D0Ev,_ZTv0_n24_N9S19008C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2224_N9S19008C18D0Ev,_ZThn1520_N9S19008C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19008C18D1Ev,_ZTv0_n24_N9S19008C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2224_N9S19008C18D1Ev,_ZThn1520_N9S19008C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19008C19D0Ev,_ZTv0_n24_N9S19008C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6416_N9S19008C19D0Ev,_ZThn4316_N9S19008C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19008C19D1Ev,_ZTv0_n24_N9S19008C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6416_N9S19008C19D1Ev,_ZThn4316_N9S19008C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S19008C19D0Ev,_ZTv0_n36_N9S19008C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3472_N9S19008C19D0Ev,_ZThn2324_N9S19008C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S19008C19D1Ev,_ZTv0_n36_N9S19008C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3472_N9S19008C19D1Ev,_ZThn2324_N9S19008C19D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19008C19 = {  "S19008C19", // class name
  bases_S19008C19, 46,
  &(vtc_S19008C19[0]), // expected_vtbl_contents
  &(vtt_S19008C19[0]), // expected_vtt_contents
  ABISELECT(7488,5016), // object size
  NSPAIRA(_ZTI9S19008C19),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S19008C19),75, //virtual function table var
  8, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19008C19),54, //virtual table table var
  23, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19008C22  {
  int s19008c22f0;
  unsigned int s19008c22f1:1;
  int s19008c22f2;
  int s19008c22f3;
  int s19008c22f4:9;
  int s19008c22f5;
  int s19008c22f6;
  int s19008c22f7[8];
  short s19008c22f8;
  void  mf19008c22(); // _ZN9S19008C2210mf19008c22Ev
  virtual  ~S19008C22(); // _ZN9S19008C22D1Ev
  S19008C22(); // tgen
};
//SIG(-1 S19008C22) C1{ vd m Fi Fi:1 Fi[2] Fi:9 Fi[10] Fs}


void  S19008C22 ::mf19008c22(){}
 S19008C22 ::~S19008C22(){ note_dtor("S19008C22", this);}
S19008C22 ::S19008C22(){ note_ctor("S19008C22", this);} // tgen

static void Test_S19008C22()
{
  extern Class_Descriptor cd_S19008C22;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,18)];
    init_test(&cd_S19008C22, buf);
    S19008C22 *dp, &lv = *(dp=new (buf) S19008C22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,68), "sizeof(S19008C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19008C22)");
    check_field_offset(lv, s19008c22f0, ABISELECT(8,4), "S19008C22.s19008c22f0");
    set_bf_and_test(lv, s19008c22f1, ABISELECT(12,8), 0, 1, 1, "S19008C22");
    check_field_offset(lv, s19008c22f2, ABISELECT(16,12), "S19008C22.s19008c22f2");
    check_field_offset(lv, s19008c22f3, ABISELECT(20,16), "S19008C22.s19008c22f3");
    set_bf_and_test(lv, s19008c22f4, ABISELECT(24,20), 0, 9, 1, "S19008C22");
    set_bf_and_test(lv, s19008c22f4, ABISELECT(24,20), 0, 9, hide_sll(1LL<<8), "S19008C22");
    check_field_offset(lv, s19008c22f5, ABISELECT(28,24), "S19008C22.s19008c22f5");
    check_field_offset(lv, s19008c22f6, ABISELECT(32,28), "S19008C22.s19008c22f6");
    check_field_offset(lv, s19008c22f7, ABISELECT(36,32), "S19008C22.s19008c22f7");
    check_field_offset(lv, s19008c22f8, ABISELECT(68,64), "S19008C22.s19008c22f8");
    test_class_info(&lv, &cd_S19008C22);
    dp->~S19008C22();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19008C22(Test_S19008C22, "S19008C22", ABISELECT(72,68));

#else // __cplusplus

extern void _ZN9S19008C22C1Ev();
extern void _ZN9S19008C22D1Ev();
Name_Map name_map_S19008C22[] = {
  NSPAIR(_ZN9S19008C22C1Ev),
  NSPAIR(_ZN9S19008C22D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S19008C22[];
extern void _ZN9S19008C22D1Ev();
extern void _ZN9S19008C22D0Ev();
static  VTBL_ENTRY vtc_S19008C22[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C22[0]),
  (VTBL_ENTRY)&_ZN9S19008C22D1Ev,
  (VTBL_ENTRY)&_ZN9S19008C22D0Ev,
};
extern VTBL_ENTRY _ZTI9S19008C22[];
extern  VTBL_ENTRY _ZTV9S19008C22[];
Class_Descriptor cd_S19008C22 = {  "S19008C22", // class name
  0,0,//no base classes
  &(vtc_S19008C22[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,68), // object size
  NSPAIRA(_ZTI9S19008C22),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S19008C22),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19008C21  : virtual S19008C17 , S19008C10 , virtual S19008C16 , virtual S19008C22 , S19008C8 {
  long double s19008c21f0;
  ::S19008C4_nt s19008c21f1;
  int s19008c21f2;
  void *s19008c21f3[4];
  int s19008c21f4[5];
  ::S19008C5 s19008c21f5;
  ::S19008C6 s19008c21f6;
  char s19008c21f7;
  virtual  ~S19008C21(); // _ZN9S19008C21D2Ev
  virtual void  v11(); // _ZN9S19008C213v11Ev
  virtual void  v12(); // _ZN9S19008C213v12Ev
  virtual void  v13(); // _ZN9S19008C213v13Ev
  virtual void  v14(); // _ZN9S19008C213v14Ev
  S19008C21(); // tgen
};
//SIG(-1 S19008C21) C1{ VBC2{ VBC3{ m Fi} BC4{ VBC3 Fp FL Fi Fp Fi FU5{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC3 FC6{ BC3 Fi FU7{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC8{ VBC3 BC4 BC6 FL FU7 Fp Fp FC9{} Fi Fi Fp Fc FC9} FC10{ BC4 BC6 v6 Fi FL Fi FL FC3 Fi Fs Fi} Fi[6] Fi FC3[7] Fi Fp[2]} BC8 VBC11{ VBC2 v5 Fp[7] Fi Fs FD Fi FC10 Fi} VBC12{ vd m Fi Fi:1 Fi Fi Fi:9 Fi Fi Fi[8] Fs} BC6 vd v1 v2 v3 v4 FD FC3 Fi Fp[4] Fi[5] FC10 FC4 Fc}


 S19008C21 ::~S19008C21(){ note_dtor("S19008C21", this);}
void  S19008C21 ::v11(){vfunc_called(this, "_ZN9S19008C213v11Ev");}
void  S19008C21 ::v12(){vfunc_called(this, "_ZN9S19008C213v12Ev");}
void  S19008C21 ::v13(){vfunc_called(this, "_ZN9S19008C213v13Ev");}
void  S19008C21 ::v14(){vfunc_called(this, "_ZN9S19008C213v14Ev");}
S19008C21 ::S19008C21(){ note_ctor("S19008C21", this);} // tgen

static void Test_S19008C21()
{
  extern Class_Descriptor cd_S19008C21;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(150,406)];
    init_test(&cd_S19008C21, buf);
    S19008C21 *dp, &lv = *(dp=new (buf) S19008C21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2384,1620), "sizeof(S19008C21)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19008C21)");
    /*is_ambiguous_... S19008C17::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C17*), ABISELECT(1872,1280), "S19008C21");
    /*is_ambiguous_... S19008C17::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C17*), ABISELECT(1872,1280), "S19008C21");
    /*is_ambiguous_... S19008C10::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*)(S19008C17*), ABISELECT(1872,1280), "S19008C21");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*)(S19008C17*), ABISELECT(1872,1280), "S19008C21");
    /*is_ambiguous_... S19008C21::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*), ABISELECT(1872,1280), "S19008C21");
    /*is_ambiguous_... S19008C21::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*), ABISELECT(1872,1280), "S19008C21");
    /*is_ambiguous_... S19008C17::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C17*), ABISELECT(960,648), "S19008C21");
    check_base_class_offset(lv, (S19008C6*)(S19008C10*)(S19008C17*), ABISELECT(1168,792), "S19008C21");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*)(S19008C17*), ABISELECT(1376,936), "S19008C21");
    check_base_class_offset(lv, (S19008C8*)(S19008C10*)(S19008C17*), ABISELECT(1376,936), "S19008C21");
    check_base_class_offset(lv, (S19008C10*)(S19008C17*), ABISELECT(1168,792), "S19008C21");
    check_base_class_offset(lv, (S19008C17*), ABISELECT(960,648), "S19008C21");
    check_base_class_offset(lv, (S19008C17*)(S19008C16*), ABISELECT(960,648), "S19008C21");
    /*is_ambiguous_... S19008C21::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C10*), 0, "S19008C21");
    /*is_ambiguous_... S19008C21::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*), ABISELECT(208,144), "S19008C21");
    /*is_ambiguous_... S19008C21::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C10*), ABISELECT(208,144), "S19008C21");
    /*is_ambiguous_... S19008C21::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C10*), 0, "S19008C21");
    check_base_class_offset(lv, (S19008C16*), ABISELECT(1888,1284), "S19008C21");
    check_base_class_offset(lv, (S19008C22*), ABISELECT(2312,1552), "S19008C21");
    /*is_ambiguous_... S19008C21::S19008C8 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*), ABISELECT(320,212), "S19008C21");
    /*is_ambiguous_... S19008C21::S19008C8 */ AMB_check_base_class_offset(lv, (S19008C8*), ABISELECT(320,212), "S19008C21");
    check_field_offset(lv, s19008c21f0, ABISELECT(352,232), "S19008C21.s19008c21f0");
    check_field_offset(lv, s19008c21f1, ABISELECT(368,244), "S19008C21.s19008c21f1");
    check_field_offset(lv, s19008c21f2, ABISELECT(372,248), "S19008C21.s19008c21f2");
    check_field_offset(lv, s19008c21f3, ABISELECT(376,252), "S19008C21.s19008c21f3");
    check_field_offset(lv, s19008c21f4, ABISELECT(408,268), "S19008C21.s19008c21f4");
    check_field_offset(lv, s19008c21f5, ABISELECT(432,288), "S19008C21.s19008c21f5");
    check_field_offset(lv, s19008c21f6, ABISELECT(736,496), "S19008C21.s19008c21f6");
    check_field_offset(lv, s19008c21f7, ABISELECT(944,644), "S19008C21.s19008c21f7");
    test_class_info(&lv, &cd_S19008C21);
    dp->~S19008C21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19008C21(Test_S19008C21, "S19008C21", ABISELECT(2384,1620));

#else // __cplusplus

extern void _ZN9S19008C21C1Ev();
extern void _ZN9S19008C21D2Ev();
Name_Map name_map_S19008C21[] = {
  NSPAIR(_ZN9S19008C21C1Ev),
  NSPAIR(_ZN9S19008C21D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
extern Class_Descriptor cd_S19008C17;
extern VTBL_ENTRY _ZTI9S19008C17[];
extern  VTBL_ENTRY _ZTV9S19008C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C17[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
extern Class_Descriptor cd_S19008C16;
extern VTBL_ENTRY _ZTI9S19008C16[];
extern  VTBL_ENTRY _ZTV9S19008C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C16[];
extern Class_Descriptor cd_S19008C22;
extern VTBL_ENTRY _ZTI9S19008C22[];
extern  VTBL_ENTRY _ZTV9S19008C22[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
static Base_Class bases_S19008C21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C4_nt,    ABISELECT(1872,1280), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S19008C6,    ABISELECT(960,648), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(1168,792), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(1376,936), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(1376,936), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19008C10,    ABISELECT(1168,792), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19008C17,    ABISELECT(960,648), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19008C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19008C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C16,    ABISELECT(1888,1284), //bcp->offset
    18, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19008C22,    ABISELECT(2312,1552), //bcp->offset
    24, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19008C4_nt,    ABISELECT(320,212), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(320,212), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19008C21[];
extern void _ZN9S19008C21D1Ev();
extern void _ZN9S19008C21D0Ev();
extern void _ZN9S19008C213v11Ev();
extern void _ZN9S19008C213v12Ev();
extern void _ZN9S19008C213v13Ev();
extern void _ZN9S19008C213v14Ev();
extern void _ZN9S19008C162v8Ev();
extern void ABISELECT(_ZTv0_n24_N9S19008C21D1Ev,_ZTv0_n12_N9S19008C21D1Ev)();
extern void ABISELECT(_ZThn2312_N9S19008C21D1Ev,_ZThn1552_N9S19008C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19008C21D0Ev,_ZTv0_n12_N9S19008C21D0Ev)();
extern void ABISELECT(_ZThn2312_N9S19008C21D0Ev,_ZThn1552_N9S19008C21D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19008C21[] = {
  ABISELECT(2312,1552),
  ABISELECT(1888,1284),
  ABISELECT(960,648),
  ABISELECT(1872,1280),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C21[0]),
  (VTBL_ENTRY)&_ZN9S19008C21D1Ev,
  (VTBL_ENTRY)&_ZN9S19008C21D0Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v11Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v12Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v13Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v14Ev,
  ABISELECT(912,632),
  ABISELECT(-960,-648),
  (VTBL_ENTRY)&(_ZTI9S19008C21[0]),
  ABISELECT(704,488),
  ABISELECT(-1168,-792),
  (VTBL_ENTRY)&(_ZTI9S19008C21[0]),
  0,
  ABISELECT(-16,-4),
  ABISELECT(-928,-636),
  ABISELECT(-1888,-1284),
  (VTBL_ENTRY)&(_ZTI9S19008C21[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
  ABISELECT(-2312,-1552),
  ABISELECT(-2312,-1552),
  (VTBL_ENTRY)&(_ZTI9S19008C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19008C21D1Ev,_ZTv0_n12_N9S19008C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19008C21D0Ev,_ZTv0_n12_N9S19008C21D0Ev),
};
extern VTBL_ENTRY _ZTV9S19008C21[];
static  VTBL_ENTRY _tg__ZTV9S19008C10__A1__9S19008C21[] = {
  ABISELECT(1872,1280),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C10__A2__9S19008C21[] = {
  ABISELECT(1872,1280),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C21[] = {
  ABISELECT(912,632),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C17[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C17__9S19008C21[] = {
  ABISELECT(912,632),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__9S19008C21[] = {
  ABISELECT(704,488),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C109S19008C17__A1__9S19008C21[] = {
  ABISELECT(704,488),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__9S19008C17__9S19008C21[] = {
  ABISELECT(704,488),
  ABISELECT(-208,-144),
  (VTBL_ENTRY)&(_ZTI9S19008C17[0]),
};
extern void _ZN9S19008C162v8Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C16__9S19008C21[] = {
  ABISELECT(-16,-4),
  ABISELECT(-928,-636),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C16__9S19008C21[] = {
  ABISELECT(912,632),
  ABISELECT(928,636),
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__9S19008C16__9S19008C21[] = {
  ABISELECT(704,488),
  ABISELECT(720,492),
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
};
static  VTT_ENTRY vtt_S19008C21[] = {
  {&(_ZTV9S19008C21[6]),  6,29},
  {&(_tg__ZTV9S19008C10__A1__9S19008C21[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C10__A2__9S19008C21[3]),  3,3},
  {&(_ZTV9S19008C21[15]),  15,29},
  {&(_ZTV9S19008C21[18]),  18,29},
  {&(_ZTV9S19008C21[23]),  23,29},
  {&(_ZTV9S19008C21[27]),  27,29},
  {&(_tg__ZTV9S19008C17__9S19008C21[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C17__9S19008C21[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__9S19008C21[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C109S19008C17__A1__9S19008C21[3]),  3,3},
  {&(_tg__ZTV9S19008C10__9S19008C17__9S19008C21[3]),  3,3},
  {&(_tg__ZTV9S19008C16__9S19008C21[4]),  4,5},
  {&(_tg__ZTV9S19008C17__9S19008C16__9S19008C21[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__9S19008C16__9S19008C21[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S19008C21[];
extern  VTBL_ENTRY _ZTV9S19008C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C21[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19008C21D0Ev,_ZTv0_n12_N9S19008C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2312_N9S19008C21D0Ev,_ZThn1552_N9S19008C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19008C21D1Ev,_ZTv0_n12_N9S19008C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2312_N9S19008C21D1Ev,_ZThn1552_N9S19008C21D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19008C21 = {  "S19008C21", // class name
  bases_S19008C21, 15,
  &(vtc_S19008C21[0]), // expected_vtbl_contents
  &(vtt_S19008C21[0]), // expected_vtt_contents
  ABISELECT(2384,1620), // object size
  NSPAIRA(_ZTI9S19008C21),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S19008C21),29, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19008C21),15, //virtual table table var
  8, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19008C20  : virtual S19008C13 , S19008C5 , S19008C16 , S19008C17 , virtual S19008C21 {
  int s19008c20f0;
  void *s19008c20f1[2];
  char s19008c20f2;
  ::S19008C10 s19008c20f3[2];
  ::S19008C22 s19008c20f4;
  ::S19008C5 s19008c20f5;
  virtual void  v15(); // _ZN9S19008C203v15Ev
  ~S19008C20(); // tgen
  S19008C20(); // tgen
};
//SIG(-1 S19008C20) C1{ VBC2{ m Fi Fi:20 FC3{ BC4{ VBC5{ m Fi} Fp FL Fi Fp Fi FU6{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC5 FC7{ BC5 Fi FU8{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC7 v2 Fi FL Fi FL FC5 Fi Fs Fi} Fi Fc[4] Fi Fi Fi Fi Fi Fi Fi} BC3 BC9{ VBC10{ VBC5 BC4 BC11{ VBC5 BC4 BC7 FL FU8 Fp Fp FC12{} Fi Fi Fp Fc FC12} FC3 Fi[6] Fi FC5[7] Fi Fp[2]} v3 Fp[7] Fi Fs FD Fi FC3 Fi} BC10 VBC13{ VBC10 BC11 VBC9 VBC14{ vd m Fi Fi:1 Fi Fi Fi:9 Fi Fi Fi[8] Fs} BC7 vd v4 v5 v6 v7 FD FC5 Fi Fp[4] Fi[5] FC3 FC4 Fc} v1 Fi Fp[2] Fc FC11[2] FC14 FC3}


void  S19008C20 ::v15(){vfunc_called(this, "_ZN9S19008C203v15Ev");}
S19008C20 ::~S19008C20(){ note_dtor("S19008C20", this);} // tgen
S19008C20 ::S19008C20(){ note_ctor("S19008C20", this);} // tgen

static void Test_S19008C20()
{
  extern Class_Descriptor cd_S19008C20;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(340,926)];
    init_test(&cd_S19008C20, buf);
    S19008C20 *dp, &lv = *(dp=new (buf) S19008C20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(5424,3700), "sizeof(S19008C20)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19008C20)");
    check_base_class_offset(lv, (S19008C13*), ABISELECT(2688,1828), "S19008C20");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C5*), ABISELECT(3044,2080), "S19008C20");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C17*), ABISELECT(3044,2080), "S19008C20");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C17*), ABISELECT(3044,2080), "S19008C20");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*)(S19008C17*), ABISELECT(3044,2080), "S19008C20");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*)(S19008C17*), ABISELECT(3044,2080), "S19008C20");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C17*), ABISELECT(3044,2080), "S19008C20");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C17*), ABISELECT(3044,2080), "S19008C20");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*)(S19008C17*), ABISELECT(3044,2080), "S19008C20");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*)(S19008C17*), ABISELECT(3044,2080), "S19008C20");
    /*is_ambiguous_... S19008C21::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*)(S19008C21*), ABISELECT(3044,2080), "S19008C20");
    /*is_ambiguous_... S19008C21::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*)(S19008C21*), ABISELECT(3044,2080), "S19008C20");
    check_base_class_offset(lv, (S19008C6*)(S19008C5*), 0, "S19008C20");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C5*), ABISELECT(208,144), "S19008C20");
    check_base_class_offset(lv, (S19008C8*)(S19008C5*), ABISELECT(208,144), "S19008C20");
    check_base_class_offset(lv, (S19008C5*), 0, "S19008C20");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C17*), ABISELECT(3056,2084), "S19008C20");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C10*)(S19008C17*), ABISELECT(3264,2228), "S19008C20");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*)(S19008C17*), ABISELECT(3472,2372), "S19008C20");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C10*)(S19008C17*), ABISELECT(3472,2372), "S19008C20");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C10*)(S19008C17*), ABISELECT(3264,2228), "S19008C20");
    /*is_ambiguous_... S19008C20::S19008C16 */ AMB_check_base_class_offset(lv, (S19008C17*)(S19008C16*), ABISELECT(3056,2084), "S19008C20");
    check_base_class_offset(lv, (S19008C17*)(S19008C21*), ABISELECT(3056,2084), "S19008C20");
    /*is_ambiguous_... S19008C20::S19008C16 */ AMB_check_base_class_offset(lv, (S19008C17*)(S19008C16*), ABISELECT(3056,2084), "S19008C20");
    /*is_ambiguous_... S19008C20::S19008C16 */ AMB_check_base_class_offset(lv, (S19008C16*), ABISELECT(288,204), "S19008C20");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C17*), ABISELECT(720,472), "S19008C20");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C10*)(S19008C17*), ABISELECT(928,616), "S19008C20");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*)(S19008C17*), ABISELECT(1136,760), "S19008C20");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C10*)(S19008C17*), ABISELECT(1136,760), "S19008C20");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C10*)(S19008C17*), ABISELECT(928,616), "S19008C20");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C17*), ABISELECT(720,472), "S19008C20");
    /*is_ambiguous_... S19008C21::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C10*)(S19008C21*), ABISELECT(3968,2716), "S19008C20");
    /*is_ambiguous_... S19008C21::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*)(S19008C21*), ABISELECT(4176,2860), "S19008C20");
    /*is_ambiguous_... S19008C21::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C10*)(S19008C21*), ABISELECT(4176,2860), "S19008C20");
    /*is_ambiguous_... S19008C21::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C10*)(S19008C21*), ABISELECT(3968,2716), "S19008C20");
    check_base_class_offset(lv, (S19008C16*)(S19008C21*), ABISELECT(4928,3364), "S19008C20");
    check_base_class_offset(lv, (S19008C22*)(S19008C21*), ABISELECT(5352,3632), "S19008C20");
    /*is_ambiguous_... S19008C21::S19008C8 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C21*), ABISELECT(4288,2928), "S19008C20");
    /*is_ambiguous_... S19008C21::S19008C8 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C21*), ABISELECT(4288,2928), "S19008C20");
    check_base_class_offset(lv, (S19008C21*), ABISELECT(3968,2716), "S19008C20");
    check_field_offset(lv, s19008c20f0, ABISELECT(1632,1104), "S19008C20.s19008c20f0");
    check_field_offset(lv, s19008c20f1, ABISELECT(1640,1108), "S19008C20.s19008c20f1");
    check_field_offset(lv, s19008c20f2, ABISELECT(1656,1116), "S19008C20.s19008c20f2");
    check_field_offset(lv, s19008c20f3, ABISELECT(1664,1120), "S19008C20.s19008c20f3");
    check_field_offset(lv, s19008c20f4, ABISELECT(2304,1552), "S19008C20.s19008c20f4");
    check_field_offset(lv, s19008c20f5, ABISELECT(2384,1620), "S19008C20.s19008c20f5");
    test_class_info(&lv, &cd_S19008C20);
    dp->~S19008C20();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19008C20(Test_S19008C20, "S19008C20", ABISELECT(5424,3700));

#else // __cplusplus

extern void _ZN9S19008C20C1Ev();
extern void _ZN9S19008C20D1Ev();
Name_Map name_map_S19008C20[] = {
  NSPAIR(_ZN9S19008C20C1Ev),
  NSPAIR(_ZN9S19008C20D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C13;
extern VTBL_ENTRY _ZTI9S19008C13[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C5;
extern VTBL_ENTRY _ZTI8S19008C5[];
extern  VTBL_ENTRY _ZTV8S19008C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C5[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
extern Class_Descriptor cd_S19008C17;
extern VTBL_ENTRY _ZTI9S19008C17[];
extern  VTBL_ENTRY _ZTV9S19008C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C17[];
extern Class_Descriptor cd_S19008C16;
extern VTBL_ENTRY _ZTI9S19008C16[];
extern  VTBL_ENTRY _ZTV9S19008C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C16[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
extern Class_Descriptor cd_S19008C17;
extern VTBL_ENTRY _ZTI9S19008C17[];
extern  VTBL_ENTRY _ZTV9S19008C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C17[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
extern Class_Descriptor cd_S19008C16;
extern VTBL_ENTRY _ZTI9S19008C16[];
extern  VTBL_ENTRY _ZTV9S19008C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C16[];
extern Class_Descriptor cd_S19008C22;
extern VTBL_ENTRY _ZTI9S19008C22[];
extern  VTBL_ENTRY _ZTV9S19008C22[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C21;
extern VTBL_ENTRY _ZTI9S19008C21[];
extern  VTBL_ENTRY _ZTV9S19008C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C21[];
static Base_Class bases_S19008C20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C13,    ABISELECT(2688,1828), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19008C4_nt,    ABISELECT(3044,2080), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S19008C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19008C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C6,    ABISELECT(3056,2084), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(3264,2228), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(3472,2372), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(3472,2372), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19008C10,    ABISELECT(3264,2228), //bcp->offset
    26, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19008C17,    ABISELECT(3056,2084), //bcp->offset
    23, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S19008C16,    ABISELECT(288,204), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C6,    ABISELECT(720,472), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(928,616), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(1136,760), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(1136,760), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19008C10,    ABISELECT(928,616), //bcp->offset
    20, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S19008C17,    ABISELECT(720,472), //bcp->offset
    17, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C6,    ABISELECT(3968,2716), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    27, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(4176,2860), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(4176,2860), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S19008C10,    ABISELECT(3968,2716), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S19008C16,    ABISELECT(4928,3364), //bcp->offset
    46, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    27, //immediately_derived
  0, 1},
  {&cd_S19008C22,    ABISELECT(5352,3632), //bcp->offset
    52, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    27, //immediately_derived
  0, 1},
  {&cd_S19008C4_nt,    ABISELECT(4288,2928), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(4288,2928), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S19008C21,    ABISELECT(3968,2716), //bcp->offset
    29, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19008C20[];
extern void _ZN8S19008C52v1Ev();
extern void _ZN9S19008C203v15Ev();
extern void _ZN9S19008C20D1Ev();
extern void _ZN9S19008C20D0Ev();
extern void _ZN9S19008C162v8Ev();
extern void ABISELECT(_ZTv0_n56_N9S19008C20D1Ev,_ZTv0_n28_N9S19008C20D1Ev)();
extern void ABISELECT(_ZThn3968_N9S19008C20D1Ev,_ZThn2716_N9S19008C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S19008C20D0Ev,_ZTv0_n28_N9S19008C20D0Ev)();
extern void ABISELECT(_ZThn3968_N9S19008C20D0Ev,_ZThn2716_N9S19008C20D0Ev)() __attribute__((weak));
extern void _ZN9S19008C213v11Ev();
extern void _ZN9S19008C213v12Ev();
extern void _ZN9S19008C213v13Ev();
extern void _ZN9S19008C213v14Ev();
extern void _ZN9S19008C162v8Ev();
extern void ABISELECT(_ZTv0_n24_N9S19008C20D1Ev,_ZTv0_n12_N9S19008C20D1Ev)();
extern void ABISELECT(_ZThn5352_N9S19008C20D1Ev,_ZThn3632_N9S19008C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19008C20D0Ev,_ZTv0_n12_N9S19008C20D0Ev)();
extern void ABISELECT(_ZThn5352_N9S19008C20D0Ev,_ZThn3632_N9S19008C20D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19008C20[] = {
  ABISELECT(5352,3632),
  ABISELECT(4928,3364),
  ABISELECT(3968,2716),
  ABISELECT(3056,2084),
  ABISELECT(2688,1828),
  ABISELECT(3044,2080),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C20[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&_ZN9S19008C203v15Ev,
  (VTBL_ENTRY)&_ZN9S19008C20D1Ev,
  (VTBL_ENTRY)&_ZN9S19008C20D0Ev,
  ABISELECT(2756,1876),
  ABISELECT(2768,1880),
  ABISELECT(-288,-204),
  (VTBL_ENTRY)&(_ZTI9S19008C20[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
  ABISELECT(2324,1608),
  ABISELECT(-720,-472),
  (VTBL_ENTRY)&(_ZTI9S19008C20[0]),
  ABISELECT(2116,1464),
  ABISELECT(-928,-616),
  (VTBL_ENTRY)&(_ZTI9S19008C20[0]),
  ABISELECT(-12,-4),
  ABISELECT(-3056,-2084),
  (VTBL_ENTRY)&(_ZTI9S19008C20[0]),
  ABISELECT(-220,-148),
  ABISELECT(-3264,-2228),
  (VTBL_ENTRY)&(_ZTI9S19008C20[0]),
  0,
  0,
  0,
  0,
  ABISELECT(-3968,-2716),
  ABISELECT(1384,916),
  ABISELECT(960,648),
  ABISELECT(-912,-632),
  ABISELECT(-924,-636),
  ABISELECT(-3968,-2716),
  (VTBL_ENTRY)&(_ZTI9S19008C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19008C20D1Ev,_ZTv0_n28_N9S19008C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19008C20D0Ev,_ZTv0_n28_N9S19008C20D0Ev),
  (VTBL_ENTRY)&_ZN9S19008C213v11Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v12Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v13Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v14Ev,
  0,
  ABISELECT(-1884,-1284),
  ABISELECT(-1872,-1280),
  ABISELECT(-4928,-3364),
  (VTBL_ENTRY)&(_ZTI9S19008C20[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
  ABISELECT(-5352,-3632),
  ABISELECT(-5352,-3632),
  (VTBL_ENTRY)&(_ZTI9S19008C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19008C20D1Ev,_ZTv0_n12_N9S19008C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19008C20D0Ev,_ZTv0_n12_N9S19008C20D0Ev),
};
extern VTBL_ENTRY _ZTV9S19008C20[];
extern void _ZN8S19008C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C5__9S19008C20[] = {
  ABISELECT(3044,2080),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C5[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C5__9S19008C20[] = {
  ABISELECT(3044,2080),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
extern void _ZN9S19008C162v8Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C16__A__9S19008C20[] = {
  ABISELECT(2756,1876),
  ABISELECT(2768,1880),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C16__A__9S19008C20[] = {
  ABISELECT(-12,-4),
  ABISELECT(-2768,-1880),
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__9S19008C16__A__9S19008C20[] = {
  ABISELECT(-220,-148),
  ABISELECT(-2976,-2024),
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__A__9S19008C20[] = {
  ABISELECT(2324,1608),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C17[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C17__A3__9S19008C20[] = {
  ABISELECT(2324,1608),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__A1__9S19008C20[] = {
  ABISELECT(2116,1464),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C109S19008C17__A4__9S19008C20[] = {
  ABISELECT(2116,1464),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__9S19008C17__A__9S19008C20[] = {
  ABISELECT(2116,1464),
  ABISELECT(-208,-144),
  (VTBL_ENTRY)&(_ZTI9S19008C17[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C20[] = {
  ABISELECT(-12,-4),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C17[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C17__A1__9S19008C20[] = {
  ABISELECT(-12,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__9S19008C20[] = {
  ABISELECT(-220,-148),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C109S19008C17__A2__9S19008C20[] = {
  ABISELECT(-220,-148),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__9S19008C17__9S19008C20[] = {
  ABISELECT(-220,-148),
  ABISELECT(-208,-144),
  (VTBL_ENTRY)&(_ZTI9S19008C17[0]),
};
extern void _ZN9S19008C21D1Ev();
extern void _ZN9S19008C21D0Ev();
extern void _ZN9S19008C213v11Ev();
extern void _ZN9S19008C213v12Ev();
extern void _ZN9S19008C213v13Ev();
extern void _ZN9S19008C213v14Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C21__9S19008C20[] = {
  ABISELECT(1384,916),
  ABISELECT(960,648),
  ABISELECT(-912,-632),
  ABISELECT(-924,-636),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C21[0]),
  (VTBL_ENTRY)&_ZN9S19008C21D1Ev,
  (VTBL_ENTRY)&_ZN9S19008C21D0Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v11Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v12Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v13Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v14Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C21__A2__9S19008C20[] = {
  ABISELECT(-924,-636),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C109S19008C21__A5__9S19008C20[] = {
  ABISELECT(-924,-636),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C21__9S19008C20[] = {
  ABISELECT(-12,-4),
  ABISELECT(912,632),
  (VTBL_ENTRY)&(_ZTI9S19008C21[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__9S19008C21__9S19008C20[] = {
  ABISELECT(-220,-148),
  ABISELECT(704,488),
  (VTBL_ENTRY)&(_ZTI9S19008C21[0]),
};
extern void _ZN9S19008C162v8Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C16__9S19008C21__9S19008C20[] = {
  0,
  ABISELECT(-1884,-1284),
  ABISELECT(-1872,-1280),
  ABISELECT(-960,-648),
  (VTBL_ENTRY)&(_ZTI9S19008C21[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19008C21D1Ev,_ZTv0_n12_N9S19008C21D1Ev)();
extern void ABISELECT(_ZThn1384_N9S19008C21D1Ev,_ZThn916_N9S19008C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19008C21D0Ev,_ZTv0_n12_N9S19008C21D0Ev)();
extern void ABISELECT(_ZThn1384_N9S19008C21D0Ev,_ZThn916_N9S19008C21D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19008C22__9S19008C21__9S19008C20[] = {
  ABISELECT(-1384,-916),
  ABISELECT(-1384,-916),
  (VTBL_ENTRY)&(_ZTI9S19008C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19008C21D1Ev,_ZTv0_n12_N9S19008C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19008C21D0Ev,_ZTv0_n12_N9S19008C21D0Ev),
};
extern void _ZN9S19008C162v8Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C16__A1__9S19008C20[] = {
  ABISELECT(-1884,-1284),
  ABISELECT(-1872,-1280),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C16__A1__9S19008C20[] = {
  ABISELECT(-12,-4),
  ABISELECT(1872,1280),
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__9S19008C16__A1__9S19008C20[] = {
  ABISELECT(-220,-148),
  ABISELECT(1664,1136),
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
};
static  VTT_ENTRY vtt_S19008C20[] = {
  {&(_ZTV9S19008C20[8]),  8,57},
  {&(_tg__ZTV8S19008C5__9S19008C20[3]),  3,4},
  {&(_tg__ZTV8S19008C68S19008C5__9S19008C20[3]),  3,3},
  {&(_tg__ZTV9S19008C16__A__9S19008C20[4]),  4,5},
  {&(_tg__ZTV9S19008C17__9S19008C16__A__9S19008C20[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__9S19008C16__A__9S19008C20[3]),  3,3},
  {&(_tg__ZTV9S19008C17__A__9S19008C20[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C17__A3__9S19008C20[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__A1__9S19008C20[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C109S19008C17__A4__9S19008C20[3]),  3,3},
  {&(_tg__ZTV9S19008C10__9S19008C17__A__9S19008C20[3]),  3,3},
  {&(_ZTV9S19008C20[16]),  16,57},
  {&(_ZTV9S19008C20[26]),  26,57},
  {&(_ZTV9S19008C20[29]),  29,57},
  {&(_ZTV9S19008C20[20]),  20,57},
  {&(_ZTV9S19008C20[23]),  23,57},
  {&(_ZTV9S19008C20[40]),  40,57},
  {&(_ZTV9S19008C20[51]),  51,57},
  {&(_ZTV9S19008C20[55]),  55,57},
  {&(_tg__ZTV9S19008C17__9S19008C20[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C17__A1__9S19008C20[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__9S19008C20[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C109S19008C17__A2__9S19008C20[3]),  3,3},
  {&(_tg__ZTV9S19008C10__9S19008C17__9S19008C20[3]),  3,3},
  {&(_tg__ZTV9S19008C21__9S19008C20[6]),  6,12},
  {&(_tg__ZTV9S19008C109S19008C21__A2__9S19008C20[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C109S19008C21__A5__9S19008C20[3]),  3,3},
  {&(_tg__ZTV9S19008C17__9S19008C21__9S19008C20[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__9S19008C21__9S19008C20[3]),  3,3},
  {&(_tg__ZTV9S19008C16__9S19008C21__9S19008C20[5]),  5,6},
  {&(_tg__ZTV9S19008C22__9S19008C21__9S19008C20[3]),  3,5},
  {&(_tg__ZTV9S19008C16__A1__9S19008C20[4]),  4,5},
  {&(_tg__ZTV9S19008C17__9S19008C16__A1__9S19008C20[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__9S19008C16__A1__9S19008C20[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S19008C20[];
extern  VTBL_ENTRY _ZTV9S19008C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C20[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19008C21D0Ev,_ZTv0_n12_N9S19008C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1384_N9S19008C21D0Ev,_ZThn916_N9S19008C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19008C21D1Ev,_ZTv0_n12_N9S19008C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1384_N9S19008C21D1Ev,_ZThn916_N9S19008C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19008C20D0Ev,_ZTv0_n12_N9S19008C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5352_N9S19008C20D0Ev,_ZThn3632_N9S19008C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19008C20D1Ev,_ZTv0_n12_N9S19008C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5352_N9S19008C20D1Ev,_ZThn3632_N9S19008C20D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19008C20D0Ev,_ZTv0_n28_N9S19008C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3968_N9S19008C20D0Ev,_ZThn2716_N9S19008C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19008C20D1Ev,_ZTv0_n28_N9S19008C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3968_N9S19008C20D1Ev,_ZThn2716_N9S19008C20D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19008C20 = {  "S19008C20", // class name
  bases_S19008C20, 28,
  &(vtc_S19008C20[0]), // expected_vtbl_contents
  &(vtt_S19008C20[0]), // expected_vtt_contents
  ABISELECT(5424,3700), // object size
  NSPAIRA(_ZTI9S19008C20),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S19008C20),57, //virtual function table var
  8, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19008C20),34, //virtual table table var
  16, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19008C14  : S19008C15 , S19008C19 , S19008C20 , S19008C17 {
  __tsi64 s19008c14f0;
  void *s19008c14f1;
  virtual void  v16(); // _ZN9S19008C143v16Ev
  virtual void  v17(); // _ZN9S19008C143v17Ev
  virtual void  v18(); // _ZN9S19008C143v18Ev
  ~S19008C14(); // tgen
  S19008C14(); // tgen
};
//SIG(-1 S19008C14) C1{ BC2{ VBC3{ m Fi Fi:20 FC4{ BC5{ VBC6{ m Fi} Fp FL Fi Fp Fi FU7{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC6 FC8{ BC6 Fi FU9{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC8 v5 Fi FL Fi FL FC6 Fi Fs Fi} Fi Fc[4] Fi Fi Fi Fi Fi Fi Fi} BC10{ VBC11{ VBC6 BC5 BC12{ VBC6 BC5 BC8 FL FU9 Fp Fp FC13{} Fi Fi Fp Fc FC13} FC4 Fi[6] Fi FC6[7] Fi Fp[2]} v4 Fp[7] Fi Fs FD Fi FC4 Fi} BC4 BC14{ BC12 BC8 BC5 VBC15{ BC6 BC4 BC8 VBC12 BC5 vd v6 v7 FU9 FD Fc Fp FL FC8 Fi Fp[10] Fi FC12 Fi} vd v8 v9 Fs Fs FC8[5] FL FD FL Fi Fi Fp} vd Fi Fi Fp FD[6] Fi Fi FD Fi Fi Fi} BC16{ BC15 BC5 BC3 VBC2 vd Fi FL FU7 Fi Fi FC13 FC15} BC17{ VBC3 BC4 BC10 BC11 VBC18{ VBC11 BC12 VBC10 VBC19{ vd m Fi Fi:1 Fi Fi Fi:9 Fi Fi Fi[8] Fs} BC8 vd v10 v11 v12 v13 FD FC6 Fi Fp[4] Fi[5] FC4 FC5 Fc} v14 Fi Fp[2] Fc FC12[2] FC19 FC4} BC11 v1 v2 v3 FL Fp}


void  S19008C14 ::v16(){vfunc_called(this, "_ZN9S19008C143v16Ev");}
void  S19008C14 ::v17(){vfunc_called(this, "_ZN9S19008C143v17Ev");}
void  S19008C14 ::v18(){vfunc_called(this, "_ZN9S19008C143v18Ev");}
S19008C14 ::~S19008C14(){ note_dtor("S19008C14", this);} // tgen
S19008C14 ::S19008C14(){ note_ctor("S19008C14", this);} // tgen

static void Test_S19008C14()
{
  extern Class_Descriptor cd_S19008C14;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(890,2396)];
    init_test(&cd_S19008C14, buf);
    S19008C14 *dp, &lv = *(dp=new (buf) S19008C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(14224,9580), "sizeof(S19008C14)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19008C14)");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C13*)(S19008C15*), ABISELECT(8416,5688), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C13*)(S19008C15*), ABISELECT(8416,5688), "S19008C14");
    check_base_class_offset(lv, (S19008C13*)(S19008C20*), ABISELECT(8416,5688), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C17*), ABISELECT(9696,6572), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C17*), ABISELECT(9696,6572), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*)(S19008C17*), ABISELECT(9696,6572), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*)(S19008C17*), ABISELECT(9696,6572), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C5*)(S19008C15*), ABISELECT(9696,6572), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*)(S19008C18*)(S19008C15*), ABISELECT(9696,6572), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*)(S19008C18*)(S19008C15*), ABISELECT(9696,6572), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C18*)(S19008C15*), ABISELECT(9696,6572), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C5*)(S19008C3*), ABISELECT(9696,6572), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*), ABISELECT(9696,6572), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*), ABISELECT(9696,6572), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C3*), ABISELECT(9696,6572), "S19008C14");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C5*)(S19008C3*)(S19008C19*), ABISELECT(9696,6572), "S19008C14");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C3*)(S19008C19*), ABISELECT(9696,6572), "S19008C14");
    /*is_ambiguous_... S19008C19::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C19*), ABISELECT(9696,6572), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C5*)(S19008C15*), ABISELECT(9696,6572), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*)(S19008C18*)(S19008C15*), ABISELECT(9696,6572), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*)(S19008C18*)(S19008C15*), ABISELECT(9696,6572), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C18*)(S19008C15*), ABISELECT(9696,6572), "S19008C14");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C5*)(S19008C20*), ABISELECT(9696,6572), "S19008C14");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C17*)(S19008C20*), ABISELECT(9696,6572), "S19008C14");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C17*)(S19008C20*), ABISELECT(9696,6572), "S19008C14");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*)(S19008C17*)(S19008C20*), ABISELECT(9696,6572), "S19008C14");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*)(S19008C17*)(S19008C20*), ABISELECT(9696,6572), "S19008C14");
    /*is_ambiguous_... S19008C21::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*)(S19008C21*), ABISELECT(9696,6572), "S19008C14");
    /*is_ambiguous_... S19008C21::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*)(S19008C21*), ABISELECT(9696,6572), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C17*), ABISELECT(9696,6572), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C17*), ABISELECT(9696,6572), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*)(S19008C17*), ABISELECT(9696,6572), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*)(S19008C17*), ABISELECT(9696,6572), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C17*), ABISELECT(8784,5940), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C10*)(S19008C17*), ABISELECT(8992,6084), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*)(S19008C17*), ABISELECT(9200,6228), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C10*)(S19008C17*), ABISELECT(9200,6228), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C10*)(S19008C17*), ABISELECT(8992,6084), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C17*)(S19008C16*)(S19008C15*), ABISELECT(8784,5940), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C17*)(S19008C16*)(S19008C15*), ABISELECT(8784,5940), "S19008C14");
    /*is_ambiguous_... S19008C20::S19008C16 */ AMB_check_base_class_offset(lv, (S19008C17*)(S19008C16*)(S19008C20*), ABISELECT(8784,5940), "S19008C14");
    check_base_class_offset(lv, (S19008C17*)(S19008C21*), ABISELECT(8784,5940), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C16 */ AMB_check_base_class_offset(lv, (S19008C17*)(S19008C16*), ABISELECT(8784,5940), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C16*)(S19008C15*), 0, "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C5*)(S19008C15*), ABISELECT(432,268), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C5*)(S19008C15*), ABISELECT(640,412), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C5*)(S19008C15*), ABISELECT(640,412), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C5*)(S19008C15*), ABISELECT(432,268), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C10*)(S19008C18*)(S19008C15*), ABISELECT(720,472), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*)(S19008C18*)(S19008C15*), ABISELECT(928,616), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C10*)(S19008C18*)(S19008C15*), ABISELECT(928,616), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C10*)(S19008C18*)(S19008C15*), ABISELECT(720,472), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C18*)(S19008C15*), ABISELECT(1040,684), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C18*)(S19008C15*), ABISELECT(1040,684), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C18*)(S19008C15*), ABISELECT(1072,704), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C3*), ABISELECT(10000,6780), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C5*)(S19008C3*), ABISELECT(9712,6576), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C5*)(S19008C3*), ABISELECT(9920,6720), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C5*)(S19008C3*), ABISELECT(9920,6720), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C5*)(S19008C3*), ABISELECT(9712,6576), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C3*), ABISELECT(10016,6784), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C3*), ABISELECT(10016,6784), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C10*), ABISELECT(10784,7276), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*), ABISELECT(10992,7420), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C10*), ABISELECT(10992,7420), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C10*)(S19008C3*), ABISELECT(10784,7276), "S19008C14");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C10*)(S19008C3*)(S19008C19*), ABISELECT(10784,7276), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C3*), ABISELECT(10048,6804), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C3*)(S19008C18*)(S19008C15*), ABISELECT(9712,6576), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C3*)(S19008C18*)(S19008C15*), ABISELECT(9712,6576), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C18*)(S19008C15*), ABISELECT(720,472), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C15*), 0, "S19008C14");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C3*)(S19008C19*), ABISELECT(1952,1312), "S19008C14");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C5*)(S19008C3*)(S19008C19*), ABISELECT(1664,1108), "S19008C14");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C5*)(S19008C3*)(S19008C19*), ABISELECT(1872,1252), "S19008C14");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C5*)(S19008C3*)(S19008C19*), ABISELECT(1872,1252), "S19008C14");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C5*)(S19008C3*)(S19008C19*), ABISELECT(1664,1108), "S19008C14");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C3*)(S19008C19*), ABISELECT(1968,1316), "S19008C14");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C3*)(S19008C19*), ABISELECT(1968,1316), "S19008C14");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C3*)(S19008C19*), ABISELECT(2000,1336), "S19008C14");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C3*)(S19008C19*), ABISELECT(1664,1108), "S19008C14");
    /*is_ambiguous_... S19008C19::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C19*), ABISELECT(2736,1808), "S19008C14");
    /*is_ambiguous_... S19008C19::S19008C13 */ AMB_check_base_class_offset(lv, (S19008C13*)(S19008C19*), ABISELECT(2944,1952), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C16*)(S19008C15*), ABISELECT(11104,7488), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C5*)(S19008C15*), ABISELECT(11536,7756), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C5*)(S19008C15*), ABISELECT(11744,7900), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C5*)(S19008C15*), ABISELECT(11744,7900), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C5*)(S19008C15*), ABISELECT(11536,7756), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C10*)(S19008C18*)(S19008C15*), ABISELECT(11824,7960), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*)(S19008C18*)(S19008C15*), ABISELECT(12032,8104), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C10*)(S19008C18*)(S19008C15*), ABISELECT(12032,8104), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C10*)(S19008C18*)(S19008C15*), ABISELECT(11824,7960), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C18*)(S19008C15*), ABISELECT(12144,8172), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C18*)(S19008C15*), ABISELECT(12144,8172), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C18*)(S19008C15*), ABISELECT(12176,8192), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C18*)(S19008C15*), ABISELECT(11824,7960), "S19008C14");
    check_base_class_offset(lv, (S19008C15*)(S19008C19*), ABISELECT(11104,7488), "S19008C14");
    check_base_class_offset(lv, (S19008C19*), ABISELECT(1664,1108), "S19008C14");
    check_base_class_offset(lv, (S19008C6*)(S19008C5*)(S19008C20*), ABISELECT(4800,3216), "S19008C14");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C5*)(S19008C20*), ABISELECT(5008,3360), "S19008C14");
    check_base_class_offset(lv, (S19008C8*)(S19008C5*)(S19008C20*), ABISELECT(5008,3360), "S19008C14");
    check_base_class_offset(lv, (S19008C5*)(S19008C20*), ABISELECT(4800,3216), "S19008C14");
    /*is_ambiguous_... S19008C20::S19008C16 */ AMB_check_base_class_offset(lv, (S19008C16*)(S19008C20*), ABISELECT(5088,3420), "S19008C14");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C17*)(S19008C20*), ABISELECT(5520,3688), "S19008C14");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C10*)(S19008C17*)(S19008C20*), ABISELECT(5728,3832), "S19008C14");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*)(S19008C17*)(S19008C20*), ABISELECT(5936,3976), "S19008C14");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C10*)(S19008C17*)(S19008C20*), ABISELECT(5936,3976), "S19008C14");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C10*)(S19008C17*)(S19008C20*), ABISELECT(5728,3832), "S19008C14");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C17*)(S19008C20*), ABISELECT(5520,3688), "S19008C14");
    /*is_ambiguous_... S19008C21::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C10*)(S19008C21*), ABISELECT(12768,8596), "S19008C14");
    /*is_ambiguous_... S19008C21::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*)(S19008C21*), ABISELECT(12976,8740), "S19008C14");
    /*is_ambiguous_... S19008C21::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C10*)(S19008C21*), ABISELECT(12976,8740), "S19008C14");
    /*is_ambiguous_... S19008C21::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C10*)(S19008C21*), ABISELECT(12768,8596), "S19008C14");
    check_base_class_offset(lv, (S19008C16*)(S19008C21*), ABISELECT(13728,9244), "S19008C14");
    check_base_class_offset(lv, (S19008C22*)(S19008C21*), ABISELECT(14152,9512), "S19008C14");
    /*is_ambiguous_... S19008C21::S19008C8 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C21*), ABISELECT(13088,8808), "S19008C14");
    /*is_ambiguous_... S19008C21::S19008C8 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C21*), ABISELECT(13088,8808), "S19008C14");
    check_base_class_offset(lv, (S19008C21*)(S19008C20*), ABISELECT(12768,8596), "S19008C14");
    check_base_class_offset(lv, (S19008C20*), ABISELECT(4800,3216), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C17*), ABISELECT(7488,5044), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C10*)(S19008C17*), ABISELECT(7696,5188), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*)(S19008C17*), ABISELECT(7904,5332), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C10*)(S19008C17*), ABISELECT(7904,5332), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C10*)(S19008C17*), ABISELECT(7696,5188), "S19008C14");
    /*is_ambiguous_... S19008C14::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C17*), ABISELECT(7488,5044), "S19008C14");
    check_field_offset(lv, s19008c14f0, ABISELECT(8400,5676), "S19008C14.s19008c14f0");
    check_field_offset(lv, s19008c14f1, ABISELECT(8408,5684), "S19008C14.s19008c14f1");
    test_class_info(&lv, &cd_S19008C14);
    dp->~S19008C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19008C14(Test_S19008C14, "S19008C14", ABISELECT(14224,9580));

#else // __cplusplus

extern void _ZN9S19008C14C1Ev();
extern void _ZN9S19008C14D1Ev();
Name_Map name_map_S19008C14[] = {
  NSPAIR(_ZN9S19008C14C1Ev),
  NSPAIR(_ZN9S19008C14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C13;
extern VTBL_ENTRY _ZTI9S19008C13[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
extern Class_Descriptor cd_S19008C17;
extern VTBL_ENTRY _ZTI9S19008C17[];
extern  VTBL_ENTRY _ZTV9S19008C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C17[];
extern Class_Descriptor cd_S19008C16;
extern VTBL_ENTRY _ZTI9S19008C16[];
extern  VTBL_ENTRY _ZTV9S19008C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C16[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C5;
extern VTBL_ENTRY _ZTI8S19008C5[];
extern  VTBL_ENTRY _ZTV8S19008C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C5[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C5;
extern VTBL_ENTRY _ZTI8S19008C5[];
extern  VTBL_ENTRY _ZTV8S19008C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C3;
extern VTBL_ENTRY _ZTI8S19008C3[];
extern  VTBL_ENTRY _ZTV8S19008C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C3[];
extern Class_Descriptor cd_S19008C18;
extern VTBL_ENTRY _ZTI9S19008C18[];
extern  VTBL_ENTRY _ZTV9S19008C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C18[];
extern Class_Descriptor cd_S19008C15;
extern VTBL_ENTRY _ZTI9S19008C15[];
extern  VTBL_ENTRY _ZTV9S19008C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C15[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C5;
extern VTBL_ENTRY _ZTI8S19008C5[];
extern  VTBL_ENTRY _ZTV8S19008C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C3;
extern VTBL_ENTRY _ZTI8S19008C3[];
extern  VTBL_ENTRY _ZTV8S19008C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C3[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C13;
extern VTBL_ENTRY _ZTI9S19008C13[];
extern Class_Descriptor cd_S19008C16;
extern VTBL_ENTRY _ZTI9S19008C16[];
extern  VTBL_ENTRY _ZTV9S19008C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C16[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C5;
extern VTBL_ENTRY _ZTI8S19008C5[];
extern  VTBL_ENTRY _ZTV8S19008C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C5[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C18;
extern VTBL_ENTRY _ZTI9S19008C18[];
extern  VTBL_ENTRY _ZTV9S19008C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C18[];
extern Class_Descriptor cd_S19008C15;
extern VTBL_ENTRY _ZTI9S19008C15[];
extern  VTBL_ENTRY _ZTV9S19008C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C15[];
extern Class_Descriptor cd_S19008C19;
extern VTBL_ENTRY _ZTI9S19008C19[];
extern  VTBL_ENTRY _ZTV9S19008C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C19[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C5;
extern VTBL_ENTRY _ZTI8S19008C5[];
extern  VTBL_ENTRY _ZTV8S19008C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C5[];
extern Class_Descriptor cd_S19008C16;
extern VTBL_ENTRY _ZTI9S19008C16[];
extern  VTBL_ENTRY _ZTV9S19008C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C16[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
extern Class_Descriptor cd_S19008C17;
extern VTBL_ENTRY _ZTI9S19008C17[];
extern  VTBL_ENTRY _ZTV9S19008C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C17[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
extern Class_Descriptor cd_S19008C16;
extern VTBL_ENTRY _ZTI9S19008C16[];
extern  VTBL_ENTRY _ZTV9S19008C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C16[];
extern Class_Descriptor cd_S19008C22;
extern VTBL_ENTRY _ZTI9S19008C22[];
extern  VTBL_ENTRY _ZTV9S19008C22[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C21;
extern VTBL_ENTRY _ZTI9S19008C21[];
extern  VTBL_ENTRY _ZTV9S19008C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C21[];
extern Class_Descriptor cd_S19008C20;
extern VTBL_ENTRY _ZTI9S19008C20[];
extern  VTBL_ENTRY _ZTV9S19008C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C20[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
extern Class_Descriptor cd_S19008C17;
extern VTBL_ENTRY _ZTI9S19008C17[];
extern  VTBL_ENTRY _ZTV9S19008C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C17[];
static Base_Class bases_S19008C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C13,    ABISELECT(8416,5688), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 1},
  {&cd_S19008C4_nt,    ABISELECT(9696,6572), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S19008C6,    ABISELECT(8784,5940), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    92, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(8992,6084), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    94, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(9200,6228), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(9200,6228), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19008C10,    ABISELECT(8992,6084), //bcp->offset
    84, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    68, //bcp->index_in_construction_vtbl_array
    93, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19008C17,    ABISELECT(8784,5940), //bcp->offset
    81, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    67, //bcp->index_in_construction_vtbl_array
    91, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S19008C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(432,268), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(640,412), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(640,412), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19008C5,    ABISELECT(432,268), //bcp->offset
    17, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    69, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(720,472), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(928,616), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(928,616), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19008C10,    ABISELECT(720,472), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(1040,684), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(1040,684), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(1072,704), //bcp->offset
    30, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    71, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(10000,6780), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(9712,6576), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    98, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(9920,6720), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(9920,6720), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S19008C5,    ABISELECT(9712,6576), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    97, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(10016,6784), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(10016,6784), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(10784,7276), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    103, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(10992,7420), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(10992,7420), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S19008C10,    ABISELECT(10784,7276), //bcp->offset
    103, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    73, //bcp->index_in_construction_vtbl_array
    102, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    32, //immediately_derived
  0, 1},
  {&cd_S19008C6,    ABISELECT(10048,6804), //bcp->offset
    100, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    74, //bcp->index_in_construction_vtbl_array
    99, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S19008C3,    ABISELECT(9712,6576), //bcp->offset
    87, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    72, //bcp->index_in_construction_vtbl_array
    96, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    33, //immediately_derived
  0, 1},
  {&cd_S19008C18,    ABISELECT(720,472), //bcp->offset
    21, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    70, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S19008C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C4_nt,    ABISELECT(1952,1312), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(1664,1108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    27, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(1872,1252), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(1872,1252), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S19008C5,    ABISELECT(1664,1108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(1968,1316), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(1968,1316), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(2000,1336), //bcp->offset
    46, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    76, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    34, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S19008C3,    ABISELECT(1664,1108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    35, //init_seq
    60, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(2736,1808), //bcp->offset
    49, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    77, //bcp->index_in_construction_vtbl_array
    31, //bcp->base_subarray_index_in_construction_vtbl_array
    36, //init_seq
    60, //immediately_derived
  0, 0},
  {&cd_S19008C13,    ABISELECT(2944,1952), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    60, //immediately_derived
  0, 0},
  {&cd_S19008C16,    ABISELECT(11104,7488), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    105, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    59, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(11536,7756), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    109, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    50, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(11744,7900), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    49, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(11744,7900), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    50, //immediately_derived
  0, 0},
  {&cd_S19008C5,    ABISELECT(11536,7756), //bcp->offset
    121, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    79, //bcp->index_in_construction_vtbl_array
    108, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    59, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(11824,7960), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    112, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    54, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(12032,8104), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    53, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(12032,8104), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    54, //immediately_derived
  0, 0},
  {&cd_S19008C10,    ABISELECT(11824,7960), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    111, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    58, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(12144,8172), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    56, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(12144,8172), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    58, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(12176,8192), //bcp->offset
    134, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    81, //bcp->index_in_construction_vtbl_array
    113, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    58, //immediately_derived
  0, 0},
  {&cd_S19008C18,    ABISELECT(11824,7960), //bcp->offset
    125, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    80, //bcp->index_in_construction_vtbl_array
    110, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    59, //immediately_derived
  0, 0},
  {&cd_S19008C15,    ABISELECT(11104,7488), //bcp->offset
    106, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    78, //bcp->index_in_construction_vtbl_array
    104, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    60, //immediately_derived
  0, 1},
  {&cd_S19008C19,    ABISELECT(1664,1108), //bcp->offset
    33, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    75, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    37, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C6,    ABISELECT(4800,3216), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    45, //bcp->base_subarray_index_in_construction_vtbl_array
    38, //init_seq
    64, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(5008,3360), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    63, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(5008,3360), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    64, //immediately_derived
  0, 0},
  {&cd_S19008C5,    ABISELECT(4800,3216), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    44, //bcp->base_subarray_index_in_construction_vtbl_array
    39, //init_seq
    81, //immediately_derived
  0, 0},
  {&cd_S19008C16,    ABISELECT(5088,3420), //bcp->offset
    64, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    83, //bcp->index_in_construction_vtbl_array
    46, //bcp->base_subarray_index_in_construction_vtbl_array
    40, //init_seq
    81, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(5520,3688), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    50, //bcp->base_subarray_index_in_construction_vtbl_array
    41, //init_seq
    71, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(5728,3832), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    52, //bcp->base_subarray_index_in_construction_vtbl_array
    42, //init_seq
    70, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(5936,3976), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    69, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(5936,3976), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    70, //immediately_derived
  0, 0},
  {&cd_S19008C10,    ABISELECT(5728,3832), //bcp->offset
    72, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    85, //bcp->index_in_construction_vtbl_array
    51, //bcp->base_subarray_index_in_construction_vtbl_array
    43, //init_seq
    71, //immediately_derived
  0, 0},
  {&cd_S19008C17,    ABISELECT(5520,3688), //bcp->offset
    69, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    84, //bcp->index_in_construction_vtbl_array
    49, //bcp->base_subarray_index_in_construction_vtbl_array
    44, //init_seq
    81, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(12768,8596), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    128, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    75, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(12976,8740), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    74, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(12976,8740), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    75, //immediately_derived
  0, 0},
  {&cd_S19008C10,    ABISELECT(12768,8596), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    127, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    80, //immediately_derived
  0, 0},
  {&cd_S19008C16,    ABISELECT(13728,9244), //bcp->offset
    154, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    87, //bcp->index_in_construction_vtbl_array
    133, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    80, //immediately_derived
  0, 1},
  {&cd_S19008C22,    ABISELECT(14152,9512), //bcp->offset
    160, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    88, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    80, //immediately_derived
  0, 1},
  {&cd_S19008C4_nt,    ABISELECT(13088,8808), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    79, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(13088,8808), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    80, //immediately_derived
  0, 0},
  {&cd_S19008C21,    ABISELECT(12768,8596), //bcp->offset
    137, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    86, //bcp->index_in_construction_vtbl_array
    126, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    81, //immediately_derived
  0, 1},
  {&cd_S19008C20,    ABISELECT(4800,3216), //bcp->offset
    52, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    82, //bcp->index_in_construction_vtbl_array
    43, //bcp->base_subarray_index_in_construction_vtbl_array
    45, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C6,    ABISELECT(7488,5044), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    63, //bcp->base_subarray_index_in_construction_vtbl_array
    46, //init_seq
    87, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(7696,5188), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    65, //bcp->base_subarray_index_in_construction_vtbl_array
    47, //init_seq
    86, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(7904,5332), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    85, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(7904,5332), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    86, //immediately_derived
  0, 0},
  {&cd_S19008C10,    ABISELECT(7696,5188), //bcp->offset
    78, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    90, //bcp->index_in_construction_vtbl_array
    64, //bcp->base_subarray_index_in_construction_vtbl_array
    48, //init_seq
    87, //immediately_derived
  0, 0},
  {&cd_S19008C17,    ABISELECT(7488,5044), //bcp->offset
    75, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    89, //bcp->index_in_construction_vtbl_array
    62, //bcp->base_subarray_index_in_construction_vtbl_array
    49, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19008C14[];
extern void _ZN9S19008C162v8Ev();
extern void _ZN9S19008C14D1Ev();
extern void _ZN9S19008C14D0Ev();
extern void _ZN9S19008C143v16Ev();
extern void _ZN9S19008C143v17Ev();
extern void _ZN9S19008C143v18Ev();
extern void _ZN8S19008C52v1Ev();
extern void ABISELECT(_ZThn720_N9S19008C14D1Ev,_ZThn472_N9S19008C14D1Ev)();
extern void ABISELECT(_ZThn720_N9S19008C14D0Ev,_ZThn472_N9S19008C14D0Ev)();
extern void _ZN9S19008C182v9Ev();
extern void _ZN9S19008C183v10Ev();
extern void _ZN8S19008C52v1Ev();
extern void ABISELECT(_ZThn1664_N9S19008C14D1Ev,_ZThn1108_N9S19008C14D1Ev)();
extern void ABISELECT(_ZThn1664_N9S19008C14D0Ev,_ZThn1108_N9S19008C14D0Ev)();
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
extern void _ZN8S19008C52v1Ev();
extern void _ZN9S19008C203v15Ev();
extern void ABISELECT(_ZThn4800_N9S19008C14D1Ev,_ZThn3216_N9S19008C14D1Ev)();
extern void ABISELECT(_ZThn4800_N9S19008C14D0Ev,_ZThn3216_N9S19008C14D0Ev)();
extern void _ZN9S19008C162v8Ev();
extern void _ZN8S19008C52v1Ev();
extern void ABISELECT(_ZTv0_n48_N9S19008C14D1Ev,_ZTv0_n24_N9S19008C14D1Ev)();
extern void ABISELECT(_ZThn9712_N9S19008C14D1Ev,_ZThn6576_N9S19008C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19008C14D0Ev,_ZTv0_n24_N9S19008C14D0Ev)();
extern void ABISELECT(_ZThn9712_N9S19008C14D0Ev,_ZThn6576_N9S19008C14D0Ev)() __attribute__((weak));
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
extern void _ZN9S19008C162v8Ev();
extern void ABISELECT(_ZTv0_n72_N9S19008C14D1Ev,_ZTv0_n36_N9S19008C14D1Ev)();
extern void ABISELECT(_ZThn11104_N9S19008C14D1Ev,_ZThn7488_N9S19008C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S19008C14D0Ev,_ZTv0_n36_N9S19008C14D0Ev)();
extern void ABISELECT(_ZThn11104_N9S19008C14D0Ev,_ZThn7488_N9S19008C14D0Ev)() __attribute__((weak));
extern void _ZN8S19008C52v1Ev();
extern void ABISELECT(_ZTvn720_n72_N9S19008C14D1Ev,_ZTvn472_n36_N9S19008C14D1Ev)();
extern void ABISELECT(_ZTvn720_n72_N9S19008C14D0Ev,_ZTvn472_n36_N9S19008C14D0Ev)();
extern void _ZN9S19008C182v9Ev();
extern void _ZN9S19008C183v10Ev();
extern void ABISELECT(_ZTv0_n56_N9S19008C14D1Ev,_ZTv0_n28_N9S19008C14D1Ev)();
extern void ABISELECT(_ZThn12768_N9S19008C14D1Ev,_ZThn8596_N9S19008C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S19008C14D0Ev,_ZTv0_n28_N9S19008C14D0Ev)();
extern void ABISELECT(_ZThn12768_N9S19008C14D0Ev,_ZThn8596_N9S19008C14D0Ev)() __attribute__((weak));
extern void _ZN9S19008C213v11Ev();
extern void _ZN9S19008C213v12Ev();
extern void _ZN9S19008C213v13Ev();
extern void _ZN9S19008C213v14Ev();
extern void _ZN9S19008C162v8Ev();
extern void ABISELECT(_ZTv0_n24_N9S19008C14D1Ev,_ZTv0_n12_N9S19008C14D1Ev)();
extern void ABISELECT(_ZThn14152_N9S19008C14D1Ev,_ZThn9512_N9S19008C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19008C14D0Ev,_ZTv0_n12_N9S19008C14D0Ev)();
extern void ABISELECT(_ZThn14152_N9S19008C14D0Ev,_ZThn9512_N9S19008C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19008C14[] = {
  ABISELECT(14152,9512),
  ABISELECT(13728,9244),
  ABISELECT(12768,8596),
  ABISELECT(11104,7488),
  ABISELECT(10784,7276),
  ABISELECT(9712,6576),
  ABISELECT(8416,5688),
  ABISELECT(9696,6572),
  ABISELECT(8784,5940),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
  (VTBL_ENTRY)&_ZN9S19008C14D1Ev,
  (VTBL_ENTRY)&_ZN9S19008C14D0Ev,
  (VTBL_ENTRY)&_ZN9S19008C143v16Ev,
  (VTBL_ENTRY)&_ZN9S19008C143v17Ev,
  (VTBL_ENTRY)&_ZN9S19008C143v18Ev,
  ABISELECT(9264,6304),
  ABISELECT(-432,-268),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  ABISELECT(10064,6804),
  ABISELECT(8992,6104),
  ABISELECT(8976,6100),
  ABISELECT(-720,-472),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn720_N9S19008C14D1Ev,_ZThn472_N9S19008C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn720_N9S19008C14D0Ev,_ZThn472_N9S19008C14D0Ev),
  (VTBL_ENTRY)&_ZN9S19008C182v9Ev,
  (VTBL_ENTRY)&_ZN9S19008C183v10Ev,
  ABISELECT(8624,5868),
  ABISELECT(-1072,-704),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  ABISELECT(8048,5468),
  ABISELECT(7120,4832),
  ABISELECT(6752,4580),
  ABISELECT(9440,6380),
  ABISELECT(9120,6168),
  ABISELECT(8032,5464),
  ABISELECT(-1664,-1108),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn1664_N9S19008C14D1Ev,_ZThn1108_N9S19008C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1664_N9S19008C14D0Ev,_ZThn1108_N9S19008C14D0Ev),
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
  ABISELECT(7696,5236),
  ABISELECT(-2000,-1336),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  ABISELECT(6960,4764),
  ABISELECT(-2736,-1808),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  ABISELECT(9352,6296),
  ABISELECT(8928,6028),
  ABISELECT(7968,5380),
  ABISELECT(3984,2724),
  ABISELECT(3616,2472),
  ABISELECT(4896,3356),
  ABISELECT(-4800,-3216),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&_ZN9S19008C203v15Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn4800_N9S19008C14D1Ev,_ZThn3216_N9S19008C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn4800_N9S19008C14D0Ev,_ZThn3216_N9S19008C14D0Ev),
  ABISELECT(4608,3152),
  ABISELECT(3696,2520),
  ABISELECT(-5088,-3420),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
  ABISELECT(4176,2884),
  ABISELECT(-5520,-3688),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  ABISELECT(3968,2740),
  ABISELECT(-5728,-3832),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  ABISELECT(2208,1528),
  ABISELECT(-7488,-5044),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  ABISELECT(2000,1384),
  ABISELECT(-7696,-5188),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  ABISELECT(912,632),
  ABISELECT(-8784,-5940),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  ABISELECT(704,488),
  ABISELECT(-8992,-6084),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  0,
  0,
  ABISELECT(-9712,-6576),
  0,
  ABISELECT(1072,700),
  ABISELECT(-16,-4),
  ABISELECT(-9712,-6576),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C14D1Ev,_ZTv0_n24_N9S19008C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C14D0Ev,_ZTv0_n24_N9S19008C14D0Ev),
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
  ABISELECT(-352,-232),
  ABISELECT(-10048,-6804),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  ABISELECT(-1088,-704),
  ABISELECT(-10784,-7276),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  ABISELECT(720,472),
  ABISELECT(720,472),
  ABISELECT(432,268),
  ABISELECT(-11104,-7488),
  0,
  ABISELECT(-320,-212),
  ABISELECT(-1392,-912),
  ABISELECT(-2688,-1800),
  ABISELECT(-1408,-916),
  ABISELECT(-2320,-1548),
  ABISELECT(-11104,-7488),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S19008C14D1Ev,_ZTv0_n36_N9S19008C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S19008C14D0Ev,_ZTv0_n36_N9S19008C14D0Ev),
  ABISELECT(-1840,-1184),
  ABISELECT(-11536,-7756),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  ABISELECT(-1040,-684),
  ABISELECT(-2112,-1384),
  ABISELECT(-2128,-1388),
  ABISELECT(-11824,-7960),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn720_n72_N9S19008C14D1Ev,_ZTvn472_n36_N9S19008C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn720_n72_N9S19008C14D0Ev,_ZTvn472_n36_N9S19008C14D0Ev),
  (VTBL_ENTRY)&_ZN9S19008C182v9Ev,
  (VTBL_ENTRY)&_ZN9S19008C183v10Ev,
  ABISELECT(-2480,-1620),
  ABISELECT(-12176,-8192),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  0,
  0,
  0,
  0,
  ABISELECT(-12768,-8596),
  ABISELECT(1384,916),
  ABISELECT(960,648),
  ABISELECT(-3984,-2656),
  ABISELECT(-3072,-2024),
  ABISELECT(-12768,-8596),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19008C14D1Ev,_ZTv0_n28_N9S19008C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19008C14D0Ev,_ZTv0_n28_N9S19008C14D0Ev),
  (VTBL_ENTRY)&_ZN9S19008C213v11Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v12Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v13Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v14Ev,
  0,
  ABISELECT(-4032,-2672),
  ABISELECT(-4944,-3304),
  ABISELECT(-13728,-9244),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
  ABISELECT(-14152,-9512),
  ABISELECT(-14152,-9512),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19008C14D1Ev,_ZTv0_n12_N9S19008C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19008C14D0Ev,_ZTv0_n12_N9S19008C14D0Ev),
};
extern VTBL_ENTRY _ZTV9S19008C14[];
extern void _ZN9S19008C162v8Ev();
extern void _ZN9S19008C15D1Ev();
extern void _ZN9S19008C15D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C15__A__9S19008C14[] = {
  ABISELECT(10784,7276),
  ABISELECT(9712,6576),
  ABISELECT(8416,5688),
  ABISELECT(9696,6572),
  ABISELECT(8784,5940),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
  (VTBL_ENTRY)&_ZN9S19008C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19008C15D0Ev,
};
extern void _ZN9S19008C162v8Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C169S19008C15__9S19008C14[] = {
  ABISELECT(9696,6572),
  ABISELECT(8784,5940),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C169S19008C15__9S19008C14[] = {
  ABISELECT(912,632),
  ABISELECT(-8784,-5940),
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__9S19008C169S19008C15__9S19008C14[] = {
  ABISELECT(704,488),
  ABISELECT(-8992,-6084),
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
};
extern void _ZN8S19008C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C59S19008C15__9S19008C14[] = {
  ABISELECT(9264,6304),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C5[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C59S19008C15__A2__9S19008C14[] = {
  ABISELECT(9264,6304),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
extern void _ZN9S19008C18D1Ev();
extern void _ZN9S19008C18D0Ev();
extern void _ZN9S19008C182v9Ev();
extern void _ZN9S19008C183v10Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C189S19008C15__9S19008C14[] = {
  ABISELECT(10064,6804),
  ABISELECT(8992,6104),
  ABISELECT(8976,6100),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
  (VTBL_ENTRY)&_ZN9S19008C18D1Ev,
  (VTBL_ENTRY)&_ZN9S19008C18D0Ev,
  (VTBL_ENTRY)&_ZN9S19008C182v9Ev,
  (VTBL_ENTRY)&_ZN9S19008C183v10Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C189S19008C15__A1__9S19008C14[] = {
  ABISELECT(8976,6100),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C109S19008C189S19008C15__A3__9S19008C14[] = {
  ABISELECT(8976,6100),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C189S19008C15__A4__9S19008C14[] = {
  ABISELECT(8624,5868),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C6__A1__9S19008C189S19008C15__9S19008C14[] = {
  ABISELECT(8624,5868),
  ABISELECT(-352,-232),
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
};
extern void _ZN8S19008C52v1Ev();
extern void ABISELECT(_ZTv0_n48_N9S19008C18D1Ev,_ZTv0_n24_N9S19008C18D1Ev)();
extern void ABISELECT(_ZThn8992_N9S19008C18D1Ev,_ZThn6104_N9S19008C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19008C18D0Ev,_ZTv0_n24_N9S19008C18D0Ev)();
extern void ABISELECT(_ZThn8992_N9S19008C18D0Ev,_ZThn6104_N9S19008C18D0Ev)() __attribute__((weak));
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C3__9S19008C189S19008C15__9S19008C14[] = {
  0,
  0,
  ABISELECT(-8992,-6104),
  0,
  ABISELECT(1072,700),
  ABISELECT(-16,-4),
  ABISELECT(-8992,-6104),
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C18D1Ev,_ZTv0_n24_N9S19008C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C18D0Ev,_ZTv0_n24_N9S19008C18D0Ev),
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__A1__9S19008C189S19008C15__9S19008C14[] = {
  ABISELECT(-1088,-704),
  ABISELECT(-10064,-6804),
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C3__A4__9S19008C189S19008C15__9S19008C14[] = {
  ABISELECT(-352,-232),
  ABISELECT(-9328,-6332),
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C15__A__9S19008C14[] = {
  ABISELECT(912,632),
  ABISELECT(-8784,-5940),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__9S19008C15__A__9S19008C14[] = {
  ABISELECT(704,488),
  ABISELECT(-8992,-6084),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
};
extern void _ZN8S19008C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C5__9S19008C15__A__9S19008C14[] = {
  ABISELECT(9264,6304),
  ABISELECT(-432,-268),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
};
extern void ABISELECT(_ZThn720_N9S19008C15D1Ev,_ZThn472_N9S19008C15D1Ev)();
extern void ABISELECT(_ZThn720_N9S19008C15D0Ev,_ZThn472_N9S19008C15D0Ev)();
extern void _ZN9S19008C182v9Ev();
extern void _ZN9S19008C183v10Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C18__9S19008C15__A__9S19008C14[] = {
  ABISELECT(10064,6804),
  ABISELECT(8992,6104),
  ABISELECT(8976,6100),
  ABISELECT(-720,-472),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn720_N9S19008C15D1Ev,_ZThn472_N9S19008C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn720_N9S19008C15D0Ev,_ZThn472_N9S19008C15D0Ev),
  (VTBL_ENTRY)&_ZN9S19008C182v9Ev,
  (VTBL_ENTRY)&_ZN9S19008C183v10Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C18__A4__9S19008C15__A__9S19008C14[] = {
  ABISELECT(8624,5868),
  ABISELECT(-1072,-704),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
};
extern void _ZN8S19008C52v1Ev();
extern void ABISELECT(_ZTv0_n48_N9S19008C15D1Ev,_ZTv0_n24_N9S19008C15D1Ev)();
extern void ABISELECT(_ZThn9712_N9S19008C15D1Ev,_ZThn6576_N9S19008C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19008C15D0Ev,_ZTv0_n24_N9S19008C15D0Ev)();
extern void ABISELECT(_ZThn9712_N9S19008C15D0Ev,_ZThn6576_N9S19008C15D0Ev)() __attribute__((weak));
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C3__9S19008C15__A__9S19008C14[] = {
  0,
  0,
  ABISELECT(-9712,-6576),
  0,
  ABISELECT(1072,700),
  ABISELECT(-16,-4),
  ABISELECT(-9712,-6576),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C15D1Ev,_ZTv0_n24_N9S19008C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C15D0Ev,_ZTv0_n24_N9S19008C15D0Ev),
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__A2__9S19008C15__A__9S19008C14[] = {
  ABISELECT(-1088,-704),
  ABISELECT(-10784,-7276),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C3__A7__9S19008C15__A__9S19008C14[] = {
  ABISELECT(-352,-232),
  ABISELECT(-10048,-6804),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
};
extern void _ZN8S19008C52v1Ev();
extern void _ZN9S19008C19D1Ev();
extern void _ZN9S19008C19D0Ev();
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C19__9S19008C14[] = {
  ABISELECT(8048,5468),
  ABISELECT(7120,4832),
  ABISELECT(6752,4580),
  ABISELECT(9440,6380),
  ABISELECT(9120,6168),
  ABISELECT(8032,5464),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&_ZN9S19008C19D1Ev,
  (VTBL_ENTRY)&_ZN9S19008C19D0Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
};
extern void _ZN8S19008C52v1Ev();
extern void _ZN8S19008C3D1Ev();
extern void _ZN8S19008C3D0Ev();
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C39S19008C19__A1__9S19008C14[] = {
  ABISELECT(9120,6168),
  ABISELECT(8032,5464),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&_ZN8S19008C3D1Ev,
  (VTBL_ENTRY)&_ZN8S19008C3D0Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
};
extern void _ZN8S19008C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C58S19008C39S19008C19__A2__9S19008C14[] = {
  ABISELECT(8032,5464),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C5[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C58S19008C39S19008C19__A8__9S19008C14[] = {
  ABISELECT(8032,5464),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C39S19008C19__A9__9S19008C14[] = {
  ABISELECT(7696,5236),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__8S19008C39S19008C19__A1__9S19008C14[] = {
  ABISELECT(-1088,-704),
  ABISELECT(-9120,-6168),
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C6__A2__8S19008C39S19008C19__A1__9S19008C14[] = {
  ABISELECT(7696,5236),
  ABISELECT(-336,-228),
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C19__A10__9S19008C14[] = {
  ABISELECT(6960,4764),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__9S19008C19__9S19008C14[] = {
  ABISELECT(-1088,-704),
  ABISELECT(-9120,-6168),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C3__A2__9S19008C19__9S19008C14[] = {
  ABISELECT(7696,5236),
  ABISELECT(-336,-228),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C6__A3__9S19008C19__9S19008C14[] = {
  ABISELECT(6960,4764),
  ABISELECT(-1072,-700),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
};
extern void _ZN9S19008C162v8Ev();
extern void ABISELECT(_ZTv0_n72_N9S19008C19D1Ev,_ZTv0_n36_N9S19008C19D1Ev)();
extern void ABISELECT(_ZThn9440_N9S19008C19D1Ev,_ZThn6380_N9S19008C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S19008C19D0Ev,_ZTv0_n36_N9S19008C19D0Ev)();
extern void ABISELECT(_ZThn9440_N9S19008C19D0Ev,_ZThn6380_N9S19008C19D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19008C15__9S19008C19__9S19008C14[] = {
  ABISELECT(720,472),
  ABISELECT(720,472),
  ABISELECT(432,268),
  ABISELECT(-9440,-6380),
  0,
  ABISELECT(-320,-212),
  ABISELECT(-1392,-912),
  ABISELECT(-2688,-1800),
  ABISELECT(-1408,-916),
  ABISELECT(-2320,-1548),
  ABISELECT(-9440,-6380),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S19008C19D1Ev,_ZTv0_n36_N9S19008C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S19008C19D0Ev,_ZTv0_n36_N9S19008C19D0Ev),
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C19__9S19008C14[] = {
  ABISELECT(912,632),
  ABISELECT(-7120,-4832),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__A1__9S19008C19__9S19008C14[] = {
  ABISELECT(704,488),
  ABISELECT(-7328,-4976),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
};
extern void _ZN8S19008C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C59S19008C15__A1__9S19008C19__9S19008C14[] = {
  ABISELECT(-1840,-1184),
  ABISELECT(-9872,-6648),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
};
extern void ABISELECT(_ZTvn720_n72_N9S19008C19D1Ev,_ZTvn472_n36_N9S19008C19D1Ev)();
extern void ABISELECT(_ZTvn720_n72_N9S19008C19D0Ev,_ZTvn472_n36_N9S19008C19D0Ev)();
extern void _ZN9S19008C182v9Ev();
extern void _ZN9S19008C183v10Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C189S19008C15__9S19008C19__9S19008C14[] = {
  ABISELECT(-1040,-684),
  ABISELECT(-2112,-1384),
  ABISELECT(-2128,-1388),
  ABISELECT(-10160,-6852),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn720_n72_N9S19008C19D1Ev,_ZTvn472_n36_N9S19008C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn720_n72_N9S19008C19D0Ev,_ZTvn472_n36_N9S19008C19D0Ev),
  (VTBL_ENTRY)&_ZN9S19008C182v9Ev,
  (VTBL_ENTRY)&_ZN9S19008C183v10Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C189S19008C15__A8__9S19008C19__9S19008C14[] = {
  ABISELECT(-2480,-1620),
  ABISELECT(-10512,-7084),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
};
extern void _ZN8S19008C52v1Ev();
extern void ABISELECT(_ZTv0_n48_N9S19008C19D1Ev,_ZTv0_n24_N9S19008C19D1Ev)();
extern void ABISELECT(_ZThn8048_N9S19008C19D1Ev,_ZThn5468_N9S19008C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19008C19D0Ev,_ZTv0_n24_N9S19008C19D0Ev)();
extern void ABISELECT(_ZThn8048_N9S19008C19D0Ev,_ZThn5468_N9S19008C19D0Ev)() __attribute__((weak));
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C3__A1__9S19008C19__9S19008C14[] = {
  0,
  0,
  ABISELECT(-8048,-5468),
  0,
  ABISELECT(1072,700),
  ABISELECT(-16,-4),
  ABISELECT(-8048,-5468),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C19D1Ev,_ZTv0_n24_N9S19008C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C19D0Ev,_ZTv0_n24_N9S19008C19D0Ev),
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C3__A10__9S19008C19__9S19008C14[] = {
  ABISELECT(-352,-232),
  ABISELECT(-8384,-5696),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
};
extern void _ZN8S19008C52v1Ev();
extern void _ZN9S19008C203v15Ev();
extern void _ZN9S19008C20D1Ev();
extern void _ZN9S19008C20D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C20__9S19008C14[] = {
  ABISELECT(9352,6296),
  ABISELECT(8928,6028),
  ABISELECT(7968,5380),
  ABISELECT(3984,2724),
  ABISELECT(3616,2472),
  ABISELECT(4896,3356),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C20[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&_ZN9S19008C203v15Ev,
  (VTBL_ENTRY)&_ZN9S19008C20D1Ev,
  (VTBL_ENTRY)&_ZN9S19008C20D0Ev,
};
extern void _ZN8S19008C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C59S19008C20__A4__9S19008C14[] = {
  ABISELECT(4896,3356),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C5[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C59S19008C20__A14__9S19008C14[] = {
  ABISELECT(4896,3356),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
extern void _ZN9S19008C162v8Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C169S19008C20__A2__9S19008C14[] = {
  ABISELECT(4608,3152),
  ABISELECT(3696,2520),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C169S19008C20__A2__9S19008C14[] = {
  ABISELECT(912,632),
  ABISELECT(-3696,-2520),
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__9S19008C169S19008C20__A2__9S19008C14[] = {
  ABISELECT(704,488),
  ABISELECT(-3904,-2664),
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C179S19008C20__A1__9S19008C14[] = {
  ABISELECT(4176,2884),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C17[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C179S19008C20__A15__9S19008C14[] = {
  ABISELECT(4176,2884),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C179S19008C20__A4__9S19008C14[] = {
  ABISELECT(3968,2740),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C109S19008C179S19008C20__A16__9S19008C14[] = {
  ABISELECT(3968,2740),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__9S19008C179S19008C20__A1__9S19008C14[] = {
  ABISELECT(3968,2740),
  ABISELECT(-208,-144),
  (VTBL_ENTRY)&(_ZTI9S19008C17[0]),
};
extern void _ZN9S19008C162v8Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C16__A__9S19008C20__9S19008C14[] = {
  ABISELECT(4608,3152),
  ABISELECT(3696,2520),
  ABISELECT(-288,-204),
  (VTBL_ENTRY)&(_ZTI9S19008C20[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C20__9S19008C14[] = {
  ABISELECT(912,632),
  ABISELECT(-3984,-2724),
  (VTBL_ENTRY)&(_ZTI9S19008C20[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__9S19008C20__9S19008C14[] = {
  ABISELECT(704,488),
  ABISELECT(-4192,-2868),
  (VTBL_ENTRY)&(_ZTI9S19008C20[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__A__9S19008C20__9S19008C14[] = {
  ABISELECT(4176,2884),
  ABISELECT(-720,-472),
  (VTBL_ENTRY)&(_ZTI9S19008C20[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__A1__9S19008C20__9S19008C14[] = {
  ABISELECT(3968,2740),
  ABISELECT(-928,-616),
  (VTBL_ENTRY)&(_ZTI9S19008C20[0]),
};
extern void ABISELECT(_ZTv0_n56_N9S19008C20D1Ev,_ZTv0_n28_N9S19008C20D1Ev)();
extern void ABISELECT(_ZThn7968_N9S19008C20D1Ev,_ZThn5380_N9S19008C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S19008C20D0Ev,_ZTv0_n28_N9S19008C20D0Ev)();
extern void ABISELECT(_ZThn7968_N9S19008C20D0Ev,_ZThn5380_N9S19008C20D0Ev)() __attribute__((weak));
extern void _ZN9S19008C213v11Ev();
extern void _ZN9S19008C213v12Ev();
extern void _ZN9S19008C213v13Ev();
extern void _ZN9S19008C213v14Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C21__9S19008C20__9S19008C14[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-7968,-5380),
  ABISELECT(1384,916),
  ABISELECT(960,648),
  ABISELECT(-3984,-2656),
  ABISELECT(-3072,-2024),
  ABISELECT(-7968,-5380),
  (VTBL_ENTRY)&(_ZTI9S19008C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19008C20D1Ev,_ZTv0_n28_N9S19008C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19008C20D0Ev,_ZTv0_n28_N9S19008C20D0Ev),
  (VTBL_ENTRY)&_ZN9S19008C213v11Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v12Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v13Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v14Ev,
};
extern void _ZN9S19008C162v8Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C16__A1__9S19008C20__9S19008C14[] = {
  0,
  ABISELECT(-4032,-2672),
  ABISELECT(-4944,-3304),
  ABISELECT(-8928,-6028),
  (VTBL_ENTRY)&(_ZTI9S19008C20[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19008C20D1Ev,_ZTv0_n12_N9S19008C20D1Ev)();
extern void ABISELECT(_ZThn9352_N9S19008C20D1Ev,_ZThn6296_N9S19008C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19008C20D0Ev,_ZTv0_n12_N9S19008C20D0Ev)();
extern void ABISELECT(_ZThn9352_N9S19008C20D0Ev,_ZThn6296_N9S19008C20D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19008C22__9S19008C20__9S19008C14[] = {
  ABISELECT(-9352,-6296),
  ABISELECT(-9352,-6296),
  (VTBL_ENTRY)&(_ZTI9S19008C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19008C20D1Ev,_ZTv0_n12_N9S19008C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19008C20D0Ev,_ZTv0_n12_N9S19008C20D0Ev),
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__A__9S19008C14[] = {
  ABISELECT(2208,1528),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C17[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C17__A18__9S19008C14[] = {
  ABISELECT(2208,1528),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__A6__9S19008C14[] = {
  ABISELECT(2000,1384),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C109S19008C17__A19__9S19008C14[] = {
  ABISELECT(2000,1384),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__9S19008C17__A__9S19008C14[] = {
  ABISELECT(2000,1384),
  ABISELECT(-208,-144),
  (VTBL_ENTRY)&(_ZTI9S19008C17[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C14[] = {
  ABISELECT(912,632),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C17[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C17__9S19008C14[] = {
  ABISELECT(912,632),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__9S19008C14[] = {
  ABISELECT(704,488),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C109S19008C17__A1__9S19008C14[] = {
  ABISELECT(704,488),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__9S19008C17__9S19008C14[] = {
  ABISELECT(704,488),
  ABISELECT(-208,-144),
  (VTBL_ENTRY)&(_ZTI9S19008C17[0]),
};
extern void _ZN8S19008C52v1Ev();
extern void _ZN8S19008C3D1Ev();
extern void _ZN8S19008C3D0Ev();
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C3__9S19008C14[] = {
  ABISELECT(1072,700),
  ABISELECT(-16,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&_ZN8S19008C3D1Ev,
  (VTBL_ENTRY)&_ZN8S19008C3D0Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
};
extern void _ZN8S19008C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C58S19008C3__A1__9S19008C14[] = {
  ABISELECT(-16,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C5[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C58S19008C3__A5__9S19008C14[] = {
  ABISELECT(-16,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C3__A7__9S19008C14[] = {
  ABISELECT(-352,-232),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__8S19008C3__9S19008C14[] = {
  ABISELECT(-1088,-704),
  ABISELECT(-1072,-700),
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C6__A2__8S19008C3__9S19008C14[] = {
  ABISELECT(-352,-232),
  ABISELECT(-336,-228),
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__A2__9S19008C14[] = {
  ABISELECT(-1088,-704),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C10__A6__9S19008C14[] = {
  ABISELECT(-1088,-704),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
extern void _ZN9S19008C162v8Ev();
extern void _ZN9S19008C15D1Ev();
extern void _ZN9S19008C15D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C15__A1__9S19008C14[] = {
  ABISELECT(-320,-212),
  ABISELECT(-1392,-912),
  ABISELECT(-2688,-1800),
  ABISELECT(-1408,-916),
  ABISELECT(-2320,-1548),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
  (VTBL_ENTRY)&_ZN9S19008C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19008C15D0Ev,
};
extern void _ZN9S19008C162v8Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C169S19008C15__A1__9S19008C14[] = {
  ABISELECT(-1408,-916),
  ABISELECT(-2320,-1548),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C169S19008C15__A1__9S19008C14[] = {
  ABISELECT(912,632),
  ABISELECT(2320,1548),
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__9S19008C169S19008C15__A1__9S19008C14[] = {
  ABISELECT(704,488),
  ABISELECT(2112,1404),
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
};
extern void _ZN8S19008C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C59S19008C15__A3__9S19008C14[] = {
  ABISELECT(-1840,-1184),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C5[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C59S19008C15__A11__9S19008C14[] = {
  ABISELECT(-1840,-1184),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
extern void _ZN9S19008C18D1Ev();
extern void _ZN9S19008C18D0Ev();
extern void _ZN9S19008C182v9Ev();
extern void _ZN9S19008C183v10Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C189S19008C15__A1__9S19008C14[] = {
  ABISELECT(-1040,-684),
  ABISELECT(-2112,-1384),
  ABISELECT(-2128,-1388),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
  (VTBL_ENTRY)&_ZN9S19008C18D1Ev,
  (VTBL_ENTRY)&_ZN9S19008C18D0Ev,
  (VTBL_ENTRY)&_ZN9S19008C182v9Ev,
  (VTBL_ENTRY)&_ZN9S19008C183v10Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C189S19008C15__A3__9S19008C14[] = {
  ABISELECT(-2128,-1388),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C109S19008C189S19008C15__A12__9S19008C14[] = {
  ABISELECT(-2128,-1388),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C189S19008C15__A13__9S19008C14[] = {
  ABISELECT(-2480,-1620),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C6__A1__9S19008C189S19008C15__A1__9S19008C14[] = {
  ABISELECT(-2480,-1620),
  ABISELECT(-352,-232),
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
};
extern void _ZN8S19008C52v1Ev();
extern void ABISELECT(_ZTv0_n48_N9S19008C18D1Ev,_ZTv0_n24_N9S19008C18D1Ev)();
extern void ABISELECT(_ZTv0_n48_N9S19008C18D0Ev,_ZTv0_n24_N9S19008C18D0Ev)();
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C3__9S19008C189S19008C15__A1__9S19008C14[] = {
  0,
  0,
  ABISELECT(2112,1384),
  0,
  ABISELECT(1072,700),
  ABISELECT(-16,-4),
  ABISELECT(2112,1384),
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C18D1Ev,_ZTv0_n24_N9S19008C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C18D0Ev,_ZTv0_n24_N9S19008C18D0Ev),
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__A1__9S19008C189S19008C15__A1__9S19008C14[] = {
  ABISELECT(-1088,-704),
  ABISELECT(1040,684),
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C3__A4__9S19008C189S19008C15__A1__9S19008C14[] = {
  ABISELECT(-352,-232),
  ABISELECT(1776,1156),
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C15__A1__9S19008C14[] = {
  ABISELECT(912,632),
  ABISELECT(2320,1548),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__9S19008C15__A1__9S19008C14[] = {
  ABISELECT(704,488),
  ABISELECT(2112,1404),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
};
extern void _ZN8S19008C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C5__9S19008C15__A1__9S19008C14[] = {
  ABISELECT(-1840,-1184),
  ABISELECT(-432,-268),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
};
extern void ABISELECT(_ZThn720_N9S19008C15D1Ev,_ZThn472_N9S19008C15D1Ev)();
extern void ABISELECT(_ZThn720_N9S19008C15D0Ev,_ZThn472_N9S19008C15D0Ev)();
extern void _ZN9S19008C182v9Ev();
extern void _ZN9S19008C183v10Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C18__9S19008C15__A1__9S19008C14[] = {
  ABISELECT(-1040,-684),
  ABISELECT(-2112,-1384),
  ABISELECT(-2128,-1388),
  ABISELECT(-720,-472),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn720_N9S19008C15D1Ev,_ZThn472_N9S19008C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn720_N9S19008C15D0Ev,_ZThn472_N9S19008C15D0Ev),
  (VTBL_ENTRY)&_ZN9S19008C182v9Ev,
  (VTBL_ENTRY)&_ZN9S19008C183v10Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C18__A4__9S19008C15__A1__9S19008C14[] = {
  ABISELECT(-2480,-1620),
  ABISELECT(-1072,-704),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
};
extern void _ZN8S19008C52v1Ev();
extern void ABISELECT(_ZTv0_n48_N9S19008C15D1Ev,_ZTv0_n24_N9S19008C15D1Ev)();
extern void ABISELECT(_ZTv0_n48_N9S19008C15D0Ev,_ZTv0_n24_N9S19008C15D0Ev)();
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C3__9S19008C15__A1__9S19008C14[] = {
  0,
  0,
  ABISELECT(1392,912),
  0,
  ABISELECT(1072,700),
  ABISELECT(-16,-4),
  ABISELECT(1392,912),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C15D1Ev,_ZTv0_n24_N9S19008C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C15D0Ev,_ZTv0_n24_N9S19008C15D0Ev),
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__A2__9S19008C15__A1__9S19008C14[] = {
  ABISELECT(-1088,-704),
  ABISELECT(320,212),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C3__A7__9S19008C15__A1__9S19008C14[] = {
  ABISELECT(-352,-232),
  ABISELECT(1056,684),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
};
extern void _ZN9S19008C21D1Ev();
extern void _ZN9S19008C21D0Ev();
extern void _ZN9S19008C213v11Ev();
extern void _ZN9S19008C213v12Ev();
extern void _ZN9S19008C213v13Ev();
extern void _ZN9S19008C213v14Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C21__9S19008C14[] = {
  ABISELECT(1384,916),
  ABISELECT(960,648),
  ABISELECT(-3984,-2656),
  ABISELECT(-3072,-2024),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C21[0]),
  (VTBL_ENTRY)&_ZN9S19008C21D1Ev,
  (VTBL_ENTRY)&_ZN9S19008C21D0Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v11Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v12Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v13Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v14Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C21__A5__9S19008C14[] = {
  ABISELECT(-3072,-2024),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C109S19008C21__A17__9S19008C14[] = {
  ABISELECT(-3072,-2024),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C21__9S19008C14[] = {
  ABISELECT(912,632),
  ABISELECT(3984,2656),
  (VTBL_ENTRY)&(_ZTI9S19008C21[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__9S19008C21__9S19008C14[] = {
  ABISELECT(704,488),
  ABISELECT(3776,2512),
  (VTBL_ENTRY)&(_ZTI9S19008C21[0]),
};
extern void _ZN9S19008C162v8Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C16__9S19008C21__9S19008C14[] = {
  0,
  ABISELECT(-4032,-2672),
  ABISELECT(-4944,-3304),
  ABISELECT(-960,-648),
  (VTBL_ENTRY)&(_ZTI9S19008C21[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19008C21D1Ev,_ZTv0_n12_N9S19008C21D1Ev)();
extern void ABISELECT(_ZThn1384_N9S19008C21D1Ev,_ZThn916_N9S19008C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19008C21D0Ev,_ZTv0_n12_N9S19008C21D0Ev)();
extern void ABISELECT(_ZThn1384_N9S19008C21D0Ev,_ZThn916_N9S19008C21D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19008C22__9S19008C21__9S19008C14[] = {
  ABISELECT(-1384,-916),
  ABISELECT(-1384,-916),
  (VTBL_ENTRY)&(_ZTI9S19008C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19008C21D1Ev,_ZTv0_n12_N9S19008C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19008C21D0Ev,_ZTv0_n12_N9S19008C21D0Ev),
};
extern void _ZN9S19008C162v8Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C16__A3__9S19008C14[] = {
  ABISELECT(-4032,-2672),
  ABISELECT(-4944,-3304),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C16__A3__9S19008C14[] = {
  ABISELECT(912,632),
  ABISELECT(4944,3304),
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__9S19008C16__A3__9S19008C14[] = {
  ABISELECT(704,488),
  ABISELECT(4736,3160),
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
};
static  VTT_ENTRY vtt_S19008C14[] = {
  {&(_ZTV9S19008C14[11]),  11,165},
  {&(_tg__ZTV9S19008C15__A__9S19008C14[7]),  7,10},
  {&(_tg__ZTV9S19008C169S19008C15__9S19008C14[4]),  4,5},
  {&(_tg__ZTV9S19008C17__9S19008C169S19008C15__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__9S19008C169S19008C15__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C59S19008C15__9S19008C14[3]),  3,4},
  {&(_tg__ZTV8S19008C68S19008C59S19008C15__A2__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C189S19008C15__9S19008C14[5]),  5,9},
  {&(_tg__ZTV9S19008C109S19008C189S19008C15__A1__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C109S19008C189S19008C15__A3__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C189S19008C15__A4__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C6__A1__9S19008C189S19008C15__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C3__9S19008C189S19008C15__9S19008C14[8]),  8,13},
  {&(_tg__ZTV9S19008C10__A1__9S19008C189S19008C15__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C68S19008C3__A4__9S19008C189S19008C15__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C17__9S19008C15__A__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__9S19008C15__A__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C5__9S19008C15__A__9S19008C14[3]),  3,4},
  {&(_tg__ZTV9S19008C18__9S19008C15__A__9S19008C14[5]),  5,9},
  {&(_tg__ZTV8S19008C69S19008C18__A4__9S19008C15__A__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C3__9S19008C15__A__9S19008C14[8]),  8,13},
  {&(_tg__ZTV9S19008C10__A2__9S19008C15__A__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C68S19008C3__A7__9S19008C15__A__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C19__9S19008C14[8]),  8,13},
  {&(_tg__ZTV8S19008C39S19008C19__A1__9S19008C14[4]),  4,9},
  {&(_tg__ZTV8S19008C58S19008C39S19008C19__A2__9S19008C14[3]),  3,4},
  {&(_tg__ZTV8S19008C68S19008C58S19008C39S19008C19__A8__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C68S19008C39S19008C19__A9__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C10__8S19008C39S19008C19__A1__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C6__A2__8S19008C39S19008C19__A1__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C19__A10__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C10__9S19008C19__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C68S19008C3__A2__9S19008C19__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C6__A3__9S19008C19__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C15__9S19008C19__9S19008C14[12]),  12,15},
  {&(_tg__ZTV9S19008C17__9S19008C19__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__A1__9S19008C19__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C59S19008C15__A1__9S19008C19__9S19008C14[3]),  3,4},
  {&(_tg__ZTV9S19008C189S19008C15__9S19008C19__9S19008C14[5]),  5,9},
  {&(_tg__ZTV8S19008C69S19008C189S19008C15__A8__9S19008C19__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C3__A1__9S19008C19__9S19008C14[8]),  8,13},
  {&(_tg__ZTV8S19008C68S19008C3__A10__9S19008C19__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C20__9S19008C14[8]),  8,12},
  {&(_tg__ZTV8S19008C59S19008C20__A4__9S19008C14[3]),  3,4},
  {&(_tg__ZTV8S19008C68S19008C59S19008C20__A14__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C169S19008C20__A2__9S19008C14[4]),  4,5},
  {&(_tg__ZTV9S19008C17__9S19008C169S19008C20__A2__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__9S19008C169S19008C20__A2__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C179S19008C20__A1__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C179S19008C20__A15__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C179S19008C20__A4__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C109S19008C179S19008C20__A16__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C10__9S19008C179S19008C20__A1__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C16__A__9S19008C20__9S19008C14[4]),  4,5},
  {&(_tg__ZTV9S19008C17__9S19008C20__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__9S19008C20__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C17__A__9S19008C20__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__A1__9S19008C20__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C21__9S19008C20__9S19008C14[11]),  11,17},
  {&(_tg__ZTV9S19008C16__A1__9S19008C20__9S19008C14[5]),  5,6},
  {&(_tg__ZTV9S19008C22__9S19008C20__9S19008C14[3]),  3,5},
  {&(_tg__ZTV9S19008C17__A__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C17__A18__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__A6__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C109S19008C17__A19__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C10__9S19008C17__A__9S19008C14[3]),  3,3},
  {&(_ZTV9S19008C14[84]),  84,165},
  {&(_ZTV9S19008C14[87]),  87,165},
  {&(_ZTV9S19008C14[20]),  20,165},
  {&(_ZTV9S19008C14[26]),  26,165},
  {&(_ZTV9S19008C14[33]),  33,165},
  {&(_ZTV9S19008C14[95]),  95,165},
  {&(_ZTV9S19008C14[106]),  106,165},
  {&(_ZTV9S19008C14[103]),  103,165},
  {&(_ZTV9S19008C14[41]),  41,165},
  {&(_ZTV9S19008C14[49]),  49,165},
  {&(_ZTV9S19008C14[52]),  52,165},
  {&(_ZTV9S19008C14[118]),  118,165},
  {&(_ZTV9S19008C14[124]),  124,165},
  {&(_ZTV9S19008C14[130]),  130,165},
  {&(_ZTV9S19008C14[137]),  137,165},
  {&(_ZTV9S19008C14[60]),  60,165},
  {&(_ZTV9S19008C14[68]),  68,165},
  {&(_ZTV9S19008C14[72]),  72,165},
  {&(_ZTV9S19008C14[75]),  75,165},
  {&(_ZTV9S19008C14[148]),  148,165},
  {&(_ZTV9S19008C14[159]),  159,165},
  {&(_ZTV9S19008C14[163]),  163,165},
  {&(_ZTV9S19008C14[78]),  78,165},
  {&(_ZTV9S19008C14[81]),  81,165},
  {&(_tg__ZTV9S19008C17__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C17__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C109S19008C17__A1__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C10__9S19008C17__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C3__9S19008C14[4]),  4,9},
  {&(_tg__ZTV8S19008C58S19008C3__A1__9S19008C14[3]),  3,4},
  {&(_tg__ZTV8S19008C68S19008C58S19008C3__A5__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C68S19008C3__A7__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C10__8S19008C3__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C6__A2__8S19008C3__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C10__A2__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C10__A6__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C15__A1__9S19008C14[7]),  7,10},
  {&(_tg__ZTV9S19008C169S19008C15__A1__9S19008C14[4]),  4,5},
  {&(_tg__ZTV9S19008C17__9S19008C169S19008C15__A1__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__9S19008C169S19008C15__A1__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C59S19008C15__A3__9S19008C14[3]),  3,4},
  {&(_tg__ZTV8S19008C68S19008C59S19008C15__A11__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C189S19008C15__A1__9S19008C14[5]),  5,9},
  {&(_tg__ZTV9S19008C109S19008C189S19008C15__A3__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C109S19008C189S19008C15__A12__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C189S19008C15__A13__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C6__A1__9S19008C189S19008C15__A1__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C3__9S19008C189S19008C15__A1__9S19008C14[8]),  8,13},
  {&(_tg__ZTV9S19008C10__A1__9S19008C189S19008C15__A1__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C68S19008C3__A4__9S19008C189S19008C15__A1__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C17__9S19008C15__A1__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__9S19008C15__A1__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C5__9S19008C15__A1__9S19008C14[3]),  3,4},
  {&(_tg__ZTV9S19008C18__9S19008C15__A1__9S19008C14[5]),  5,9},
  {&(_tg__ZTV8S19008C69S19008C18__A4__9S19008C15__A1__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C3__9S19008C15__A1__9S19008C14[8]),  8,13},
  {&(_tg__ZTV9S19008C10__A2__9S19008C15__A1__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C68S19008C3__A7__9S19008C15__A1__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C21__9S19008C14[6]),  6,12},
  {&(_tg__ZTV9S19008C109S19008C21__A5__9S19008C14[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C109S19008C21__A17__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C17__9S19008C21__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__9S19008C21__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C16__9S19008C21__9S19008C14[5]),  5,6},
  {&(_tg__ZTV9S19008C22__9S19008C21__9S19008C14[3]),  3,5},
  {&(_tg__ZTV9S19008C16__A3__9S19008C14[4]),  4,5},
  {&(_tg__ZTV9S19008C17__9S19008C16__A3__9S19008C14[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__9S19008C16__A3__9S19008C14[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S19008C14[];
extern  VTBL_ENTRY _ZTV9S19008C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C14[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19008C21D0Ev,_ZTv0_n12_N9S19008C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1384_N9S19008C21D0Ev,_ZThn916_N9S19008C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19008C21D1Ev,_ZTv0_n12_N9S19008C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1384_N9S19008C21D1Ev,_ZThn916_N9S19008C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19008C20D0Ev,_ZTv0_n12_N9S19008C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9352_N9S19008C20D0Ev,_ZThn6296_N9S19008C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19008C20D1Ev,_ZTv0_n12_N9S19008C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9352_N9S19008C20D1Ev,_ZThn6296_N9S19008C20D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19008C20D0Ev,_ZTv0_n28_N9S19008C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7968_N9S19008C20D0Ev,_ZThn5380_N9S19008C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19008C20D1Ev,_ZTv0_n28_N9S19008C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7968_N9S19008C20D1Ev,_ZThn5380_N9S19008C20D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19008C19D0Ev,_ZTv0_n24_N9S19008C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8048_N9S19008C19D0Ev,_ZThn5468_N9S19008C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19008C19D1Ev,_ZTv0_n24_N9S19008C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8048_N9S19008C19D1Ev,_ZThn5468_N9S19008C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S19008C19D0Ev,_ZTv0_n36_N9S19008C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9440_N9S19008C19D0Ev,_ZThn6380_N9S19008C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S19008C19D1Ev,_ZTv0_n36_N9S19008C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9440_N9S19008C19D1Ev,_ZThn6380_N9S19008C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19008C15D0Ev,_ZTv0_n24_N9S19008C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9712_N9S19008C15D0Ev,_ZThn6576_N9S19008C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19008C15D1Ev,_ZTv0_n24_N9S19008C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9712_N9S19008C15D1Ev,_ZThn6576_N9S19008C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19008C18D0Ev,_ZTv0_n24_N9S19008C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8992_N9S19008C18D0Ev,_ZThn6104_N9S19008C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19008C18D1Ev,_ZTv0_n24_N9S19008C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8992_N9S19008C18D1Ev,_ZThn6104_N9S19008C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19008C14D0Ev,_ZTv0_n12_N9S19008C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14152_N9S19008C14D0Ev,_ZThn9512_N9S19008C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19008C14D1Ev,_ZTv0_n12_N9S19008C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14152_N9S19008C14D1Ev,_ZThn9512_N9S19008C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19008C14D0Ev,_ZTv0_n28_N9S19008C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12768_N9S19008C14D0Ev,_ZThn8596_N9S19008C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19008C14D1Ev,_ZTv0_n28_N9S19008C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12768_N9S19008C14D1Ev,_ZThn8596_N9S19008C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S19008C14D0Ev,_ZTv0_n36_N9S19008C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11104_N9S19008C14D0Ev,_ZThn7488_N9S19008C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S19008C14D1Ev,_ZTv0_n36_N9S19008C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11104_N9S19008C14D1Ev,_ZThn7488_N9S19008C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19008C14D0Ev,_ZTv0_n24_N9S19008C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9712_N9S19008C14D0Ev,_ZThn6576_N9S19008C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19008C14D1Ev,_ZTv0_n24_N9S19008C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9712_N9S19008C14D1Ev,_ZThn6576_N9S19008C14D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19008C14 = {  "S19008C14", // class name
  bases_S19008C14, 88,
  &(vtc_S19008C14[0]), // expected_vtbl_contents
  &(vtt_S19008C14[0]), // expected_vtt_contents
  ABISELECT(14224,9580), // object size
  NSPAIRA(_ZTI9S19008C14),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S19008C14),165, //virtual function table var
  11, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19008C14),135, //virtual table table var
  49, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19008C23  {
  void *s19008c23f0;
  int s19008c23f1;
  int s19008c23f2;
  ::S19008C4_nt s19008c23f3;
  void *s19008c23f4;
  long double s19008c23f5;
  int s19008c23f6;
  ::S19008C3 s19008c23f7;
  void *s19008c23f8[8];
  void *s19008c23f9[6];
  virtual void  v19(); // _ZN9S19008C233v19Ev
  ~S19008C23(); // tgen
  S19008C23(); // tgen
};
//SIG(-1 S19008C23) C1{ v1 Fp Fi[2] FC2{ m Fi} Fp FD Fi FC3{ BC2 BC4{ BC5{ VBC2 Fp FL Fi Fp Fi FU6{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC2 FC7{ BC2 Fi FU8{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC7 v4 Fi FL Fi FL FC2 Fi Fs Fi} BC7 VBC9{ VBC2 BC5 BC7 FL FU8 Fp Fp FC10{} Fi Fi Fp Fc FC10} BC5 vd v2 v3 FU8 FD Fc Fp FL FC7 Fi Fp[10] Fi FC9 Fi} Fp[8] Fp[6]}


void  S19008C23 ::v19(){vfunc_called(this, "_ZN9S19008C233v19Ev");}
S19008C23 ::~S19008C23(){ note_dtor("S19008C23", this);} // tgen
S19008C23 ::S19008C23(){ note_ctor("S19008C23", this);} // tgen

static void Test_S19008C23()
{
  extern Class_Descriptor cd_S19008C23;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(100,254)];
    init_test(&cd_S19008C23, buf);
    S19008C23 *dp, &lv = *(dp=new (buf) S19008C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1584,1012), "sizeof(S19008C23)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19008C23)");
    check_field_offset(lv, s19008c23f0, ABISELECT(8,4), "S19008C23.s19008c23f0");
    check_field_offset(lv, s19008c23f1, ABISELECT(16,8), "S19008C23.s19008c23f1");
    check_field_offset(lv, s19008c23f2, ABISELECT(20,12), "S19008C23.s19008c23f2");
    check_field_offset(lv, s19008c23f3, ABISELECT(24,16), "S19008C23.s19008c23f3");
    check_field_offset(lv, s19008c23f4, ABISELECT(32,20), "S19008C23.s19008c23f4");
    check_field_offset(lv, s19008c23f5, ABISELECT(48,24), "S19008C23.s19008c23f5");
    check_field_offset(lv, s19008c23f6, ABISELECT(64,36), "S19008C23.s19008c23f6");
    check_field_offset(lv, s19008c23f7, ABISELECT(80,40), "S19008C23.s19008c23f7");
    check_field_offset(lv, s19008c23f8, ABISELECT(1472,956), "S19008C23.s19008c23f8");
    check_field_offset(lv, s19008c23f9, ABISELECT(1536,988), "S19008C23.s19008c23f9");
    test_class_info(&lv, &cd_S19008C23);
    dp->~S19008C23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19008C23(Test_S19008C23, "S19008C23", ABISELECT(1584,1012));

#else // __cplusplus

extern void _ZN9S19008C23C1Ev();
extern void _ZN9S19008C23D1Ev();
Name_Map name_map_S19008C23[] = {
  NSPAIR(_ZN9S19008C23C1Ev),
  NSPAIR(_ZN9S19008C23D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S19008C23[];
extern void _ZN9S19008C233v19Ev();
static  VTBL_ENTRY vtc_S19008C23[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C23[0]),
  (VTBL_ENTRY)&_ZN9S19008C233v19Ev,
};
extern VTBL_ENTRY _ZTI9S19008C23[];
extern  VTBL_ENTRY _ZTV9S19008C23[];
Class_Descriptor cd_S19008C23 = {  "S19008C23", // class name
  0,0,//no base classes
  &(vtc_S19008C23[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1584,1012), // object size
  NSPAIRA(_ZTI9S19008C23),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S19008C23),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19008C12  : virtual S19008C13 , S19008C5 , virtual S19008C3 , virtual S19008C14 , virtual S19008C23 {
  long s19008c12f0;
  int s19008c12f1:19;
  int s19008c12f2[6];
  int s19008c12f3;
  ::S19008C8 s19008c12f4;
  virtual  ~S19008C12(); // _ZN9S19008C12D2Ev
  virtual void  v6(); // _ZN9S19008C122v6Ev
  virtual void  v7(); // _ZN9S19008C122v7Ev
  S19008C12(); // tgen
};
//SIG(-1 S19008C12) C1{ VBC2{ m Fi Fi:20 FC3{ BC4{ VBC5{ m Fi} Fp FL Fi Fp Fi FU6{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC5 FC7{ BC5 Fi FU8{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC7 v3 Fi FL Fi FL FC5 Fi Fs Fi} Fi Fc[4] Fi Fi Fi Fi Fi Fi Fi} BC3 VBC9{ BC5 BC3 BC7 VBC10{ VBC5 BC4 BC7 FL FU8 Fp Fp FC11{} Fi Fi Fp Fc FC11} BC4 vd v4 v5 FU8 FD Fc Fp FL FC7 Fi Fp[10] Fi FC10 Fi} VBC12{ BC13{ VBC2 BC14{ VBC15{ VBC5 BC4 BC10 FC3 Fi[6] Fi FC5[7] Fi Fp[2]} v6 Fp[7] Fi Fs FD Fi FC3 Fi} BC3 BC16{ BC10 BC7 BC4 VBC9 vd v7 v8 Fs Fs FC7[5] FL FD FL Fi Fi Fp} vd Fi Fi Fp FD[6] Fi Fi FD Fi Fi Fi} BC17{ BC9 BC4 BC2 VBC13 vd Fi FL FU6 Fi Fi FC11 FC9} BC18{ VBC2 BC3 BC14 BC15 VBC19{ VBC15 BC10 VBC14 VBC20{ vd m Fi Fi:1 Fi Fi Fi:9 Fi Fi Fi[8] Fs} BC7 vd v9 v10 v11 v12 FD FC5 Fi Fp[4] Fi[5] FC3 FC4 Fc} v13 Fi Fp[2] Fc FC10[2] FC20 FC3} BC15 v14 v15 v16 FL Fp} VBC21{ v17 Fp Fi Fi FC5 Fp FD Fi FC9 Fp[8] Fp[6]} vd v1 v2 Fl Fi:19 Fi[6] Fi FC7}


 S19008C12 ::~S19008C12(){ note_dtor("S19008C12", this);}
void  S19008C12 ::v6(){vfunc_called(this, "_ZN9S19008C122v6Ev");}
void  S19008C12 ::v7(){vfunc_called(this, "_ZN9S19008C122v7Ev");}
S19008C12 ::S19008C12(){ note_ctor("S19008C12", this);} // tgen

static void Test_S19008C12()
{
  extern Class_Descriptor cd_S19008C12;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1011,2714)];
    init_test(&cd_S19008C12, buf);
    S19008C12 *dp, &lv = *(dp=new (buf) S19008C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16160,10852), "sizeof(S19008C12)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19008C12)");
    /*is_ambiguous_... S19008C12::S19008C13 */ AMB_check_base_class_offset(lv, (S19008C13*), ABISELECT(368,260), "S19008C12");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C13*)(S19008C15*)(S19008C14*), ABISELECT(368,260), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C13*)(S19008C15*), ABISELECT(368,260), "S19008C12");
    check_base_class_offset(lv, (S19008C13*)(S19008C20*)(S19008C14*), ABISELECT(368,260), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C5 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C5*), ABISELECT(724,512), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C5*)(S19008C3*), ABISELECT(724,512), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*), ABISELECT(724,512), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*), ABISELECT(724,512), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C3*), ABISELECT(724,512), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C17*), ABISELECT(724,512), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C17*), ABISELECT(724,512), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*)(S19008C17*), ABISELECT(724,512), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*)(S19008C17*), ABISELECT(724,512), "S19008C12");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C5*)(S19008C15*)(S19008C14*), ABISELECT(724,512), "S19008C12");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*)(S19008C18*)(S19008C15*)(S19008C14*), ABISELECT(724,512), "S19008C12");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*)(S19008C18*)(S19008C15*)(S19008C14*), ABISELECT(724,512), "S19008C12");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C18*)(S19008C15*)(S19008C14*), ABISELECT(724,512), "S19008C12");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C5*)(S19008C3*)(S19008C19*)(S19008C14*), ABISELECT(724,512), "S19008C12");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C3*)(S19008C19*)(S19008C14*), ABISELECT(724,512), "S19008C12");
    /*is_ambiguous_... S19008C19::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C19*)(S19008C14*), ABISELECT(724,512), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C5*)(S19008C15*), ABISELECT(724,512), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*)(S19008C18*)(S19008C15*), ABISELECT(724,512), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*)(S19008C18*)(S19008C15*), ABISELECT(724,512), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C18*)(S19008C15*), ABISELECT(724,512), "S19008C12");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C5*)(S19008C20*)(S19008C14*), ABISELECT(724,512), "S19008C12");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C17*)(S19008C20*)(S19008C14*), ABISELECT(724,512), "S19008C12");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C17*)(S19008C20*)(S19008C14*), ABISELECT(724,512), "S19008C12");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*)(S19008C17*)(S19008C20*)(S19008C14*), ABISELECT(724,512), "S19008C12");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*)(S19008C17*)(S19008C20*)(S19008C14*), ABISELECT(724,512), "S19008C12");
    /*is_ambiguous_... S19008C21::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*)(S19008C21*), ABISELECT(724,512), "S19008C12");
    /*is_ambiguous_... S19008C21::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*)(S19008C21*), ABISELECT(724,512), "S19008C12");
    /*is_ambiguous_... S19008C14::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C17*)(S19008C14*), ABISELECT(724,512), "S19008C12");
    /*is_ambiguous_... S19008C14::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C17*)(S19008C14*), ABISELECT(724,512), "S19008C12");
    /*is_ambiguous_... S19008C14::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*)(S19008C17*)(S19008C14*), ABISELECT(724,512), "S19008C12");
    /*is_ambiguous_... S19008C14::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*)(S19008C17*)(S19008C14*), ABISELECT(724,512), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C5 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C5*), 0, "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C5 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C5*), ABISELECT(208,144), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C5 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C5*), ABISELECT(208,144), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C5 */ AMB_check_base_class_offset(lv, (S19008C5*), 0, "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C3*), ABISELECT(1024,720), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C5*)(S19008C3*), ABISELECT(736,516), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C5*)(S19008C3*), ABISELECT(944,660), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C5*)(S19008C3*), ABISELECT(944,660), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C5*)(S19008C3*), ABISELECT(736,516), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C3*), ABISELECT(1040,724), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C3*), ABISELECT(1040,724), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C10*), ABISELECT(1808,1216), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*), ABISELECT(2016,1360), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C10*), ABISELECT(2016,1360), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C10*)(S19008C3*), ABISELECT(1808,1216), "S19008C12");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C10*)(S19008C3*)(S19008C19*)(S19008C14*), ABISELECT(1808,1216), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C3*), ABISELECT(1072,744), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C3*), ABISELECT(736,516), "S19008C12");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C3*)(S19008C18*)(S19008C15*)(S19008C14*), ABISELECT(736,516), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C3*)(S19008C18*)(S19008C15*), ABISELECT(736,516), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C17*), ABISELECT(10544,7116), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C10*)(S19008C17*), ABISELECT(10752,7260), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*)(S19008C17*), ABISELECT(10960,7404), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C10*)(S19008C17*), ABISELECT(10960,7404), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C10*)(S19008C17*), ABISELECT(10752,7260), "S19008C12");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C17*)(S19008C16*)(S19008C15*)(S19008C14*), ABISELECT(10544,7116), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C17*)(S19008C16*)(S19008C15*), ABISELECT(10544,7116), "S19008C12");
    /*is_ambiguous_... S19008C20::S19008C16 */ AMB_check_base_class_offset(lv, (S19008C17*)(S19008C16*)(S19008C20*)(S19008C14*), ABISELECT(10544,7116), "S19008C12");
    check_base_class_offset(lv, (S19008C17*)(S19008C21*), ABISELECT(10544,7116), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C16 */ AMB_check_base_class_offset(lv, (S19008C17*)(S19008C16*), ABISELECT(10544,7116), "S19008C12");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C16*)(S19008C15*)(S19008C14*), ABISELECT(2128,1428), "S19008C12");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C5*)(S19008C15*)(S19008C14*), ABISELECT(2560,1696), "S19008C12");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C5*)(S19008C15*)(S19008C14*), ABISELECT(2768,1840), "S19008C12");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C5*)(S19008C15*)(S19008C14*), ABISELECT(2768,1840), "S19008C12");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C5*)(S19008C15*)(S19008C14*), ABISELECT(2560,1696), "S19008C12");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C10*)(S19008C18*)(S19008C15*)(S19008C14*), ABISELECT(2848,1900), "S19008C12");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*)(S19008C18*)(S19008C15*)(S19008C14*), ABISELECT(3056,2044), "S19008C12");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C10*)(S19008C18*)(S19008C15*)(S19008C14*), ABISELECT(3056,2044), "S19008C12");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C10*)(S19008C18*)(S19008C15*)(S19008C14*), ABISELECT(2848,1900), "S19008C12");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C18*)(S19008C15*)(S19008C14*), ABISELECT(3168,2112), "S19008C12");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C18*)(S19008C15*)(S19008C14*), ABISELECT(3168,2112), "S19008C12");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C18*)(S19008C15*)(S19008C14*), ABISELECT(3200,2132), "S19008C12");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C18*)(S19008C15*)(S19008C14*), ABISELECT(2848,1900), "S19008C12");
    /*is_ambiguous_... S19008C14::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C15*)(S19008C14*), ABISELECT(2128,1428), "S19008C12");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C3*)(S19008C19*)(S19008C14*), ABISELECT(4080,2740), "S19008C12");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C5*)(S19008C3*)(S19008C19*)(S19008C14*), ABISELECT(3792,2536), "S19008C12");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C5*)(S19008C3*)(S19008C19*)(S19008C14*), ABISELECT(4000,2680), "S19008C12");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C5*)(S19008C3*)(S19008C19*)(S19008C14*), ABISELECT(4000,2680), "S19008C12");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C5*)(S19008C3*)(S19008C19*)(S19008C14*), ABISELECT(3792,2536), "S19008C12");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C3*)(S19008C19*)(S19008C14*), ABISELECT(4096,2744), "S19008C12");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C3*)(S19008C19*)(S19008C14*), ABISELECT(4096,2744), "S19008C12");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C3*)(S19008C19*)(S19008C14*), ABISELECT(4128,2764), "S19008C12");
    /*is_ambiguous_... S19008C19::S19008C3 */ AMB_check_base_class_offset(lv, (S19008C3*)(S19008C19*)(S19008C14*), ABISELECT(3792,2536), "S19008C12");
    /*is_ambiguous_... S19008C19::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C19*)(S19008C14*), ABISELECT(4864,3236), "S19008C12");
    /*is_ambiguous_... S19008C19::S19008C13 */ AMB_check_base_class_offset(lv, (S19008C13*)(S19008C19*)(S19008C14*), ABISELECT(5072,3380), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C16*)(S19008C15*), ABISELECT(11456,7748), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C5*)(S19008C15*), ABISELECT(11888,8016), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C5*)(S19008C15*), ABISELECT(12096,8160), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C5*)(S19008C15*), ABISELECT(12096,8160), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C5*)(S19008C15*), ABISELECT(11888,8016), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C10*)(S19008C18*)(S19008C15*), ABISELECT(12176,8220), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*)(S19008C18*)(S19008C15*), ABISELECT(12384,8364), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C10*)(S19008C18*)(S19008C15*), ABISELECT(12384,8364), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C10*)(S19008C18*)(S19008C15*), ABISELECT(12176,8220), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C18*)(S19008C15*), ABISELECT(12496,8432), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C18*)(S19008C15*), ABISELECT(12496,8432), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C18*)(S19008C15*), ABISELECT(12528,8452), "S19008C12");
    /*is_ambiguous_... S19008C12::S19008C15 */ AMB_check_base_class_offset(lv, (S19008C18*)(S19008C15*), ABISELECT(12176,8220), "S19008C12");
    check_base_class_offset(lv, (S19008C15*)(S19008C19*)(S19008C14*), ABISELECT(11456,7748), "S19008C12");
    check_base_class_offset(lv, (S19008C19*)(S19008C14*), ABISELECT(3792,2536), "S19008C12");
    check_base_class_offset(lv, (S19008C6*)(S19008C5*)(S19008C20*)(S19008C14*), ABISELECT(6928,4644), "S19008C12");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C5*)(S19008C20*)(S19008C14*), ABISELECT(7136,4788), "S19008C12");
    check_base_class_offset(lv, (S19008C8*)(S19008C5*)(S19008C20*)(S19008C14*), ABISELECT(7136,4788), "S19008C12");
    check_base_class_offset(lv, (S19008C5*)(S19008C20*)(S19008C14*), ABISELECT(6928,4644), "S19008C12");
    /*is_ambiguous_... S19008C20::S19008C16 */ AMB_check_base_class_offset(lv, (S19008C16*)(S19008C20*)(S19008C14*), ABISELECT(7216,4848), "S19008C12");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C17*)(S19008C20*)(S19008C14*), ABISELECT(7648,5116), "S19008C12");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C10*)(S19008C17*)(S19008C20*)(S19008C14*), ABISELECT(7856,5260), "S19008C12");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*)(S19008C17*)(S19008C20*)(S19008C14*), ABISELECT(8064,5404), "S19008C12");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C10*)(S19008C17*)(S19008C20*)(S19008C14*), ABISELECT(8064,5404), "S19008C12");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C10*)(S19008C17*)(S19008C20*)(S19008C14*), ABISELECT(7856,5260), "S19008C12");
    /*is_ambiguous_... S19008C20::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C17*)(S19008C20*)(S19008C14*), ABISELECT(7648,5116), "S19008C12");
    /*is_ambiguous_... S19008C21::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C10*)(S19008C21*), ABISELECT(13120,8856), "S19008C12");
    /*is_ambiguous_... S19008C21::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*)(S19008C21*), ABISELECT(13328,9000), "S19008C12");
    /*is_ambiguous_... S19008C21::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C10*)(S19008C21*), ABISELECT(13328,9000), "S19008C12");
    /*is_ambiguous_... S19008C21::S19008C10 */ AMB_check_base_class_offset(lv, (S19008C10*)(S19008C21*), ABISELECT(13120,8856), "S19008C12");
    check_base_class_offset(lv, (S19008C16*)(S19008C21*), ABISELECT(14080,9504), "S19008C12");
    check_base_class_offset(lv, (S19008C22*)(S19008C21*), ABISELECT(14504,9772), "S19008C12");
    /*is_ambiguous_... S19008C21::S19008C8 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C21*), ABISELECT(13440,9068), "S19008C12");
    /*is_ambiguous_... S19008C21::S19008C8 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C21*), ABISELECT(13440,9068), "S19008C12");
    check_base_class_offset(lv, (S19008C21*)(S19008C20*)(S19008C14*), ABISELECT(13120,8856), "S19008C12");
    check_base_class_offset(lv, (S19008C20*)(S19008C14*), ABISELECT(6928,4644), "S19008C12");
    /*is_ambiguous_... S19008C14::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C17*)(S19008C14*), ABISELECT(9616,6472), "S19008C12");
    /*is_ambiguous_... S19008C14::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C10*)(S19008C17*)(S19008C14*), ABISELECT(9824,6616), "S19008C12");
    /*is_ambiguous_... S19008C14::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*)(S19008C17*)(S19008C14*), ABISELECT(10032,6760), "S19008C12");
    /*is_ambiguous_... S19008C14::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C10*)(S19008C17*)(S19008C14*), ABISELECT(10032,6760), "S19008C12");
    /*is_ambiguous_... S19008C14::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C10*)(S19008C17*)(S19008C14*), ABISELECT(9824,6616), "S19008C12");
    /*is_ambiguous_... S19008C14::S19008C17 */ AMB_check_base_class_offset(lv, (S19008C17*)(S19008C14*), ABISELECT(9616,6472), "S19008C12");
    check_base_class_offset(lv, (S19008C14*), ABISELECT(2128,1428), "S19008C12");
    check_base_class_offset(lv, (S19008C23*), ABISELECT(14576,9840), "S19008C12");
    check_field_offset(lv, s19008c12f0, ABISELECT(288,204), "S19008C12.s19008c12f0");
    set_bf_and_test(lv, s19008c12f1, ABISELECT(296,208), 0, 19, 1, "S19008C12");
    set_bf_and_test(lv, s19008c12f1, ABISELECT(296,208), 0, 19, hide_sll(1LL<<18), "S19008C12");
    check_field_offset(lv, s19008c12f2, ABISELECT(300,212), "S19008C12.s19008c12f2");
    check_field_offset(lv, s19008c12f3, ABISELECT(324,236), "S19008C12.s19008c12f3");
    check_field_offset(lv, s19008c12f4, ABISELECT(336,240), "S19008C12.s19008c12f4");
    test_class_info(&lv, &cd_S19008C12);
    dp->~S19008C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19008C12(Test_S19008C12, "S19008C12", ABISELECT(16160,10852));

#else // __cplusplus

extern void _ZN9S19008C12C1Ev();
extern void _ZN9S19008C12D2Ev();
Name_Map name_map_S19008C12[] = {
  NSPAIR(_ZN9S19008C12C1Ev),
  NSPAIR(_ZN9S19008C12D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C13;
extern VTBL_ENTRY _ZTI9S19008C13[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C5;
extern VTBL_ENTRY _ZTI8S19008C5[];
extern  VTBL_ENTRY _ZTV8S19008C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C5;
extern VTBL_ENTRY _ZTI8S19008C5[];
extern  VTBL_ENTRY _ZTV8S19008C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C3;
extern VTBL_ENTRY _ZTI8S19008C3[];
extern  VTBL_ENTRY _ZTV8S19008C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C3[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
extern Class_Descriptor cd_S19008C17;
extern VTBL_ENTRY _ZTI9S19008C17[];
extern  VTBL_ENTRY _ZTV9S19008C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C17[];
extern Class_Descriptor cd_S19008C16;
extern VTBL_ENTRY _ZTI9S19008C16[];
extern  VTBL_ENTRY _ZTV9S19008C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C16[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C5;
extern VTBL_ENTRY _ZTI8S19008C5[];
extern  VTBL_ENTRY _ZTV8S19008C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C5[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C18;
extern VTBL_ENTRY _ZTI9S19008C18[];
extern  VTBL_ENTRY _ZTV9S19008C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C18[];
extern Class_Descriptor cd_S19008C15;
extern VTBL_ENTRY _ZTI9S19008C15[];
extern  VTBL_ENTRY _ZTV9S19008C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C15[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C5;
extern VTBL_ENTRY _ZTI8S19008C5[];
extern  VTBL_ENTRY _ZTV8S19008C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C3;
extern VTBL_ENTRY _ZTI8S19008C3[];
extern  VTBL_ENTRY _ZTV8S19008C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C3[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C13;
extern VTBL_ENTRY _ZTI9S19008C13[];
extern Class_Descriptor cd_S19008C16;
extern VTBL_ENTRY _ZTI9S19008C16[];
extern  VTBL_ENTRY _ZTV9S19008C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C16[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C5;
extern VTBL_ENTRY _ZTI8S19008C5[];
extern  VTBL_ENTRY _ZTV8S19008C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C5[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C18;
extern VTBL_ENTRY _ZTI9S19008C18[];
extern  VTBL_ENTRY _ZTV9S19008C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C18[];
extern Class_Descriptor cd_S19008C15;
extern VTBL_ENTRY _ZTI9S19008C15[];
extern  VTBL_ENTRY _ZTV9S19008C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C15[];
extern Class_Descriptor cd_S19008C19;
extern VTBL_ENTRY _ZTI9S19008C19[];
extern  VTBL_ENTRY _ZTV9S19008C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C19[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C5;
extern VTBL_ENTRY _ZTI8S19008C5[];
extern  VTBL_ENTRY _ZTV8S19008C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C5[];
extern Class_Descriptor cd_S19008C16;
extern VTBL_ENTRY _ZTI9S19008C16[];
extern  VTBL_ENTRY _ZTV9S19008C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C16[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
extern Class_Descriptor cd_S19008C17;
extern VTBL_ENTRY _ZTI9S19008C17[];
extern  VTBL_ENTRY _ZTV9S19008C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C17[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
extern Class_Descriptor cd_S19008C16;
extern VTBL_ENTRY _ZTI9S19008C16[];
extern  VTBL_ENTRY _ZTV9S19008C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C16[];
extern Class_Descriptor cd_S19008C22;
extern VTBL_ENTRY _ZTI9S19008C22[];
extern  VTBL_ENTRY _ZTV9S19008C22[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C21;
extern VTBL_ENTRY _ZTI9S19008C21[];
extern  VTBL_ENTRY _ZTV9S19008C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C21[];
extern Class_Descriptor cd_S19008C20;
extern VTBL_ENTRY _ZTI9S19008C20[];
extern  VTBL_ENTRY _ZTV9S19008C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C20[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
extern Class_Descriptor cd_S19008C17;
extern VTBL_ENTRY _ZTI9S19008C17[];
extern  VTBL_ENTRY _ZTV9S19008C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C17[];
extern Class_Descriptor cd_S19008C14;
extern VTBL_ENTRY _ZTI9S19008C14[];
extern  VTBL_ENTRY _ZTV9S19008C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C14[];
extern Class_Descriptor cd_S19008C23;
extern VTBL_ENTRY _ZTI9S19008C23[];
extern  VTBL_ENTRY _ZTV9S19008C23[];
static Base_Class bases_S19008C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C13,    ABISELECT(368,260), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19008C4_nt,    ABISELECT(724,512), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S19008C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    52, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19008C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    53, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C4_nt,    ABISELECT(1024,720), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(736,516), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(944,660), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(944,660), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19008C5,    ABISELECT(736,516), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    31, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(1040,724), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(1040,724), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(1808,1216), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    37, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(2016,1360), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(2016,1360), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19008C10,    ABISELECT(1808,1216), //bcp->offset
    34, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    36, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    18, //immediately_derived
  0, 1},
  {&cd_S19008C6,    ABISELECT(1072,744), //bcp->offset
    31, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S19008C3,    ABISELECT(736,516), //bcp->offset
    18, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    30, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19008C6,    ABISELECT(10544,7116), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    129, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(10752,7260), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    131, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(10960,7404), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(10960,7404), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S19008C10,    ABISELECT(10752,7260), //bcp->offset
    132, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    130, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S19008C17,    ABISELECT(10544,7116), //bcp->offset
    129, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    128, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    25, //immediately_derived
  0, 1},
  {&cd_S19008C16,    ABISELECT(2128,1428), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    40, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(2560,1696), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    44, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(2768,1840), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(2768,1840), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19008C5,    ABISELECT(2560,1696), //bcp->offset
    65, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    43, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(2848,1900), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    47, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(3056,2044), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(3056,2044), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S19008C10,    ABISELECT(2848,1900), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    46, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(3168,2112), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(3168,2112), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(3200,2132), //bcp->offset
    78, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    48, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S19008C18,    ABISELECT(2848,1900), //bcp->offset
    69, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    45, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S19008C15,    ABISELECT(2128,1428), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    39, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    92, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(4080,2740), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    47, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(3792,2536), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    64, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(4000,2680), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    42, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(4000,2680), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S19008C5,    ABISELECT(3792,2536), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    63, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    47, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(4096,2744), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    45, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(4096,2744), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    47, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(4128,2764), //bcp->offset
    94, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    65, //bcp->base_subarray_index_in_construction_vtbl_array
    34, //init_seq
    47, //immediately_derived
  0, 0},
  {&cd_S19008C3,    ABISELECT(3792,2536), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    62, //bcp->base_subarray_index_in_construction_vtbl_array
    35, //init_seq
    64, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(4864,3236), //bcp->offset
    97, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    68, //bcp->base_subarray_index_in_construction_vtbl_array
    36, //init_seq
    64, //immediately_derived
  0, 0},
  {&cd_S19008C13,    ABISELECT(5072,3380), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    64, //immediately_derived
  0, 0},
  {&cd_S19008C16,    ABISELECT(11456,7748), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    134, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    63, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(11888,8016), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    138, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    54, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(12096,8160), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    53, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(12096,8160), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    54, //immediately_derived
  0, 0},
  {&cd_S19008C5,    ABISELECT(11888,8016), //bcp->offset
    150, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    137, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    63, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(12176,8220), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    141, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    58, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(12384,8364), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    57, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(12384,8364), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    58, //immediately_derived
  0, 0},
  {&cd_S19008C10,    ABISELECT(12176,8220), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    140, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    62, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(12496,8432), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    60, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(12496,8432), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    62, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(12528,8452), //bcp->offset
    163, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    142, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    62, //immediately_derived
  0, 0},
  {&cd_S19008C18,    ABISELECT(12176,8220), //bcp->offset
    154, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    139, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    63, //immediately_derived
  0, 0},
  {&cd_S19008C15,    ABISELECT(11456,7748), //bcp->offset
    135, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    133, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    64, //immediately_derived
  0, 1},
  {&cd_S19008C19,    ABISELECT(3792,2536), //bcp->offset
    81, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    61, //bcp->base_subarray_index_in_construction_vtbl_array
    37, //init_seq
    92, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(6928,4644), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    82, //bcp->base_subarray_index_in_construction_vtbl_array
    38, //init_seq
    68, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(7136,4788), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    67, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(7136,4788), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    68, //immediately_derived
  0, 0},
  {&cd_S19008C5,    ABISELECT(6928,4644), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    81, //bcp->base_subarray_index_in_construction_vtbl_array
    39, //init_seq
    85, //immediately_derived
  0, 0},
  {&cd_S19008C16,    ABISELECT(7216,4848), //bcp->offset
    112, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    83, //bcp->base_subarray_index_in_construction_vtbl_array
    40, //init_seq
    85, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(7648,5116), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    87, //bcp->base_subarray_index_in_construction_vtbl_array
    41, //init_seq
    75, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(7856,5260), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    89, //bcp->base_subarray_index_in_construction_vtbl_array
    42, //init_seq
    74, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(8064,5404), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    73, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(8064,5404), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    74, //immediately_derived
  0, 0},
  {&cd_S19008C10,    ABISELECT(7856,5260), //bcp->offset
    120, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    88, //bcp->base_subarray_index_in_construction_vtbl_array
    43, //init_seq
    75, //immediately_derived
  0, 0},
  {&cd_S19008C17,    ABISELECT(7648,5116), //bcp->offset
    117, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    86, //bcp->base_subarray_index_in_construction_vtbl_array
    44, //init_seq
    85, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(13120,8856), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    157, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    79, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(13328,9000), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    78, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(13328,9000), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    79, //immediately_derived
  0, 0},
  {&cd_S19008C10,    ABISELECT(13120,8856), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    156, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    84, //immediately_derived
  0, 0},
  {&cd_S19008C16,    ABISELECT(14080,9504), //bcp->offset
    183, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    162, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    84, //immediately_derived
  0, 1},
  {&cd_S19008C22,    ABISELECT(14504,9772), //bcp->offset
    189, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    84, //immediately_derived
  0, 1},
  {&cd_S19008C4_nt,    ABISELECT(13440,9068), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    83, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(13440,9068), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    84, //immediately_derived
  0, 0},
  {&cd_S19008C21,    ABISELECT(13120,8856), //bcp->offset
    166, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    155, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    85, //immediately_derived
  0, 1},
  {&cd_S19008C20,    ABISELECT(6928,4644), //bcp->offset
    100, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    80, //bcp->base_subarray_index_in_construction_vtbl_array
    45, //init_seq
    92, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(9616,6472), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    100, //bcp->base_subarray_index_in_construction_vtbl_array
    46, //init_seq
    91, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(9824,6616), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    102, //bcp->base_subarray_index_in_construction_vtbl_array
    47, //init_seq
    90, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(10032,6760), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    89, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(10032,6760), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    90, //immediately_derived
  0, 0},
  {&cd_S19008C10,    ABISELECT(9824,6616), //bcp->offset
    126, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    101, //bcp->base_subarray_index_in_construction_vtbl_array
    48, //init_seq
    91, //immediately_derived
  0, 0},
  {&cd_S19008C17,    ABISELECT(9616,6472), //bcp->offset
    123, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    99, //bcp->base_subarray_index_in_construction_vtbl_array
    49, //init_seq
    92, //immediately_derived
  0, 0},
  {&cd_S19008C14,    ABISELECT(2128,1428), //bcp->offset
    37, //bcp->virtual_function_table_offset
    22, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    38, //bcp->base_subarray_index_in_construction_vtbl_array
    50, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19008C23,    ABISELECT(14576,9840), //bcp->offset
    194, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    51, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19008C12[];
extern void _ZN8S19008C52v1Ev();
extern void _ZN9S19008C12D1Ev();
extern void _ZN9S19008C12D0Ev();
extern void _ZN9S19008C122v6Ev();
extern void _ZN9S19008C122v7Ev();
extern void _ZN8S19008C52v1Ev();
extern void ABISELECT(_ZTv0_n48_N9S19008C12D1Ev,_ZTv0_n24_N9S19008C12D1Ev)();
extern void ABISELECT(_ZThn736_N9S19008C12D1Ev,_ZThn516_N9S19008C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19008C12D0Ev,_ZTv0_n24_N9S19008C12D0Ev)();
extern void ABISELECT(_ZThn736_N9S19008C12D0Ev,_ZThn516_N9S19008C12D0Ev)() __attribute__((weak));
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
extern void _ZN9S19008C162v8Ev();
extern void ABISELECT(_ZTv0_n104_N9S19008C12D1Ev,_ZTv0_n52_N9S19008C12D1Ev)();
extern void ABISELECT(_ZThn2128_N9S19008C12D1Ev,_ZThn1428_N9S19008C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n104_N9S19008C12D0Ev,_ZTv0_n52_N9S19008C12D0Ev)();
extern void ABISELECT(_ZThn2128_N9S19008C12D0Ev,_ZThn1428_N9S19008C12D0Ev)() __attribute__((weak));
extern void _ZN9S19008C143v16Ev();
extern void _ZN9S19008C143v17Ev();
extern void _ZN9S19008C143v18Ev();
extern void _ZN8S19008C52v1Ev();
extern void ABISELECT(_ZTvn720_n104_N9S19008C12D1Ev,_ZTvn472_n52_N9S19008C12D1Ev)();
extern void ABISELECT(_ZTvn720_n104_N9S19008C12D0Ev,_ZTvn472_n52_N9S19008C12D0Ev)();
extern void _ZN9S19008C182v9Ev();
extern void _ZN9S19008C183v10Ev();
extern void _ZN8S19008C52v1Ev();
extern void ABISELECT(_ZTvn1664_n104_N9S19008C12D1Ev,_ZTvn1108_n52_N9S19008C12D1Ev)();
extern void ABISELECT(_ZTvn1664_n104_N9S19008C12D0Ev,_ZTvn1108_n52_N9S19008C12D0Ev)();
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
extern void _ZN8S19008C52v1Ev();
extern void _ZN9S19008C203v15Ev();
extern void ABISELECT(_ZTvn4800_n104_N9S19008C12D1Ev,_ZTvn3216_n52_N9S19008C12D1Ev)();
extern void ABISELECT(_ZTvn4800_n104_N9S19008C12D0Ev,_ZTvn3216_n52_N9S19008C12D0Ev)();
extern void _ZN9S19008C162v8Ev();
extern void _ZN9S19008C162v8Ev();
extern void ABISELECT(_ZTv0_n72_N9S19008C12D1Ev,_ZTv0_n36_N9S19008C12D1Ev)();
extern void ABISELECT(_ZThn11456_N9S19008C12D1Ev,_ZThn7748_N9S19008C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S19008C12D0Ev,_ZTv0_n36_N9S19008C12D0Ev)();
extern void ABISELECT(_ZThn11456_N9S19008C12D0Ev,_ZThn7748_N9S19008C12D0Ev)() __attribute__((weak));
extern void _ZN8S19008C52v1Ev();
extern void ABISELECT(_ZTvn720_n72_N9S19008C12D1Ev,_ZTvn472_n36_N9S19008C12D1Ev)();
extern void ABISELECT(_ZTvn720_n72_N9S19008C12D0Ev,_ZTvn472_n36_N9S19008C12D0Ev)();
extern void _ZN9S19008C182v9Ev();
extern void _ZN9S19008C183v10Ev();
extern void ABISELECT(_ZTv0_n56_N9S19008C12D1Ev,_ZTv0_n28_N9S19008C12D1Ev)();
extern void ABISELECT(_ZThn13120_N9S19008C12D1Ev,_ZThn8856_N9S19008C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S19008C12D0Ev,_ZTv0_n28_N9S19008C12D0Ev)();
extern void ABISELECT(_ZThn13120_N9S19008C12D0Ev,_ZThn8856_N9S19008C12D0Ev)() __attribute__((weak));
extern void _ZN9S19008C213v11Ev();
extern void _ZN9S19008C213v12Ev();
extern void _ZN9S19008C213v13Ev();
extern void _ZN9S19008C213v14Ev();
extern void _ZN9S19008C162v8Ev();
extern void ABISELECT(_ZTv0_n24_N9S19008C12D1Ev,_ZTv0_n12_N9S19008C12D1Ev)();
extern void ABISELECT(_ZThn14504_N9S19008C12D1Ev,_ZThn9772_N9S19008C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19008C12D0Ev,_ZTv0_n12_N9S19008C12D0Ev)();
extern void ABISELECT(_ZThn14504_N9S19008C12D0Ev,_ZThn9772_N9S19008C12D0Ev)() __attribute__((weak));
extern void _ZN9S19008C233v19Ev();
static  VTBL_ENTRY vtc_S19008C12[] = {
  ABISELECT(14576,9840),
  ABISELECT(14504,9772),
  ABISELECT(14080,9504),
  ABISELECT(13120,8856),
  ABISELECT(11456,7748),
  ABISELECT(10544,7116),
  ABISELECT(2128,1428),
  ABISELECT(1808,1216),
  ABISELECT(736,516),
  ABISELECT(368,260),
  ABISELECT(724,512),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C12[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&_ZN9S19008C12D1Ev,
  (VTBL_ENTRY)&_ZN9S19008C12D0Ev,
  (VTBL_ENTRY)&_ZN9S19008C122v6Ev,
  (VTBL_ENTRY)&_ZN9S19008C122v7Ev,
  0,
  0,
  ABISELECT(-736,-516),
  0,
  ABISELECT(1072,700),
  ABISELECT(-12,-4),
  ABISELECT(-736,-516),
  (VTBL_ENTRY)&(_ZTI9S19008C12[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C12D1Ev,_ZTv0_n24_N9S19008C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C12D0Ev,_ZTv0_n24_N9S19008C12D0Ev),
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
  ABISELECT(-348,-232),
  ABISELECT(-1072,-744),
  (VTBL_ENTRY)&(_ZTI9S19008C12[0]),
  ABISELECT(-1084,-704),
  ABISELECT(-1808,-1216),
  (VTBL_ENTRY)&(_ZTI9S19008C12[0]),
  ABISELECT(4800,3216),
  ABISELECT(1664,1108),
  ABISELECT(1664,1108),
  0,
  0,
  0,
  ABISELECT(720,472),
  ABISELECT(720,472),
  ABISELECT(432,268),
  ABISELECT(-2128,-1428),
  0,
  ABISELECT(12376,8344),
  ABISELECT(11952,8076),
  ABISELECT(10992,7428),
  ABISELECT(9328,6320),
  ABISELECT(-320,-212),
  ABISELECT(-1392,-912),
  ABISELECT(-1760,-1168),
  ABISELECT(-1404,-916),
  ABISELECT(8416,5688),
  ABISELECT(-2128,-1428),
  (VTBL_ENTRY)&(_ZTI9S19008C12[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n104_N9S19008C12D1Ev,_ZTv0_n52_N9S19008C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n104_N9S19008C12D0Ev,_ZTv0_n52_N9S19008C12D0Ev),
  (VTBL_ENTRY)&_ZN9S19008C143v16Ev,
  (VTBL_ENTRY)&_ZN9S19008C143v17Ev,
  (VTBL_ENTRY)&_ZN9S19008C143v18Ev,
  ABISELECT(-1836,-1184),
  ABISELECT(-2560,-1696),
  (VTBL_ENTRY)&(_ZTI9S19008C12[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  ABISELECT(-1040,-684),
  ABISELECT(-2112,-1384),
  ABISELECT(-2124,-1388),
  ABISELECT(-2848,-1900),
  (VTBL_ENTRY)&(_ZTI9S19008C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn720_n104_N9S19008C12D1Ev,_ZTvn472_n52_N9S19008C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn720_n104_N9S19008C12D0Ev,_ZTvn472_n52_N9S19008C12D0Ev),
  (VTBL_ENTRY)&_ZN9S19008C182v9Ev,
  (VTBL_ENTRY)&_ZN9S19008C183v10Ev,
  ABISELECT(-2476,-1620),
  ABISELECT(-3200,-2132),
  (VTBL_ENTRY)&(_ZTI9S19008C12[0]),
  ABISELECT(-3056,-2020),
  ABISELECT(6752,4580),
  ABISELECT(-3424,-2276),
  ABISELECT(7664,5212),
  ABISELECT(-1984,-1320),
  ABISELECT(-3068,-2024),
  ABISELECT(-3792,-2536),
  (VTBL_ENTRY)&(_ZTI9S19008C12[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn1664_n104_N9S19008C12D1Ev,_ZTvn1108_n52_N9S19008C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1664_n104_N9S19008C12D0Ev,_ZTvn1108_n52_N9S19008C12D0Ev),
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
  ABISELECT(-3404,-2252),
  ABISELECT(-4128,-2764),
  (VTBL_ENTRY)&(_ZTI9S19008C12[0]),
  ABISELECT(-4140,-2724),
  ABISELECT(-4864,-3236),
  (VTBL_ENTRY)&(_ZTI9S19008C12[0]),
  ABISELECT(7576,5128),
  ABISELECT(7152,4860),
  ABISELECT(6192,4212),
  ABISELECT(3616,2472),
  ABISELECT(-6560,-4384),
  ABISELECT(-6204,-4132),
  ABISELECT(-6928,-4644),
  (VTBL_ENTRY)&(_ZTI9S19008C12[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&_ZN9S19008C203v15Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn4800_n104_N9S19008C12D1Ev,_ZTvn3216_n52_N9S19008C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn4800_n104_N9S19008C12D0Ev,_ZTvn3216_n52_N9S19008C12D0Ev),
  ABISELECT(-6492,-4336),
  ABISELECT(3328,2268),
  ABISELECT(-7216,-4848),
  (VTBL_ENTRY)&(_ZTI9S19008C12[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
  ABISELECT(-6924,-4604),
  ABISELECT(-7648,-5116),
  (VTBL_ENTRY)&(_ZTI9S19008C12[0]),
  ABISELECT(-7132,-4748),
  ABISELECT(-7856,-5260),
  (VTBL_ENTRY)&(_ZTI9S19008C12[0]),
  ABISELECT(-8892,-5960),
  ABISELECT(-9616,-6472),
  (VTBL_ENTRY)&(_ZTI9S19008C12[0]),
  ABISELECT(-9100,-6104),
  ABISELECT(-9824,-6616),
  (VTBL_ENTRY)&(_ZTI9S19008C12[0]),
  ABISELECT(-9820,-6604),
  ABISELECT(-10544,-7116),
  (VTBL_ENTRY)&(_ZTI9S19008C12[0]),
  ABISELECT(-10028,-6748),
  ABISELECT(-10752,-7260),
  (VTBL_ENTRY)&(_ZTI9S19008C12[0]),
  ABISELECT(720,472),
  ABISELECT(720,472),
  ABISELECT(432,268),
  ABISELECT(-11456,-7748),
  0,
  ABISELECT(-9648,-6532),
  ABISELECT(-10720,-7232),
  ABISELECT(-11088,-7488),
  ABISELECT(-10732,-7236),
  ABISELECT(-912,-632),
  ABISELECT(-11456,-7748),
  (VTBL_ENTRY)&(_ZTI9S19008C12[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S19008C12D1Ev,_ZTv0_n36_N9S19008C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S19008C12D0Ev,_ZTv0_n36_N9S19008C12D0Ev),
  ABISELECT(-11164,-7504),
  ABISELECT(-11888,-8016),
  (VTBL_ENTRY)&(_ZTI9S19008C12[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  ABISELECT(-10368,-7004),
  ABISELECT(-11440,-7704),
  ABISELECT(-11452,-7708),
  ABISELECT(-12176,-8220),
  (VTBL_ENTRY)&(_ZTI9S19008C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn720_n72_N9S19008C12D1Ev,_ZTvn472_n36_N9S19008C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn720_n72_N9S19008C12D0Ev,_ZTvn472_n36_N9S19008C12D0Ev),
  (VTBL_ENTRY)&_ZN9S19008C182v9Ev,
  (VTBL_ENTRY)&_ZN9S19008C183v10Ev,
  ABISELECT(-11804,-7940),
  ABISELECT(-12528,-8452),
  (VTBL_ENTRY)&(_ZTI9S19008C12[0]),
  0,
  0,
  0,
  0,
  ABISELECT(-13120,-8856),
  ABISELECT(1384,916),
  ABISELECT(960,648),
  ABISELECT(-2576,-1740),
  ABISELECT(-12396,-8344),
  ABISELECT(-13120,-8856),
  (VTBL_ENTRY)&(_ZTI9S19008C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19008C12D1Ev,_ZTv0_n28_N9S19008C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19008C12D0Ev,_ZTv0_n28_N9S19008C12D0Ev),
  (VTBL_ENTRY)&_ZN9S19008C213v11Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v12Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v13Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v14Ev,
  0,
  ABISELECT(-13356,-8992),
  ABISELECT(-3536,-2388),
  ABISELECT(-14080,-9504),
  (VTBL_ENTRY)&(_ZTI9S19008C12[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
  ABISELECT(-14504,-9772),
  ABISELECT(-14504,-9772),
  (VTBL_ENTRY)&(_ZTI9S19008C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19008C12D1Ev,_ZTv0_n12_N9S19008C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19008C12D0Ev,_ZTv0_n12_N9S19008C12D0Ev),
  0,
  ABISELECT(-14576,-9840),
  (VTBL_ENTRY)&(_ZTI9S19008C12[0]),
  (VTBL_ENTRY)&_ZN9S19008C233v19Ev,
};
extern VTBL_ENTRY _ZTV9S19008C12[];
extern void _ZN8S19008C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C5__9S19008C12[] = {
  ABISELECT(724,512),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C5[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C5__9S19008C12[] = {
  ABISELECT(724,512),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
extern void _ZN8S19008C52v1Ev();
extern void _ZN8S19008C3D1Ev();
extern void _ZN8S19008C3D0Ev();
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C3__9S19008C12[] = {
  ABISELECT(1072,700),
  ABISELECT(-12,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&_ZN8S19008C3D1Ev,
  (VTBL_ENTRY)&_ZN8S19008C3D0Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
};
extern void _ZN8S19008C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C58S19008C3__A1__9S19008C12[] = {
  ABISELECT(-12,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C5[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C58S19008C3__A1__9S19008C12[] = {
  ABISELECT(-12,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C3__A3__9S19008C12[] = {
  ABISELECT(-348,-232),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__8S19008C3__9S19008C12[] = {
  ABISELECT(-1084,-704),
  ABISELECT(-1072,-700),
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C6__A2__8S19008C3__9S19008C12[] = {
  ABISELECT(-348,-232),
  ABISELECT(-336,-228),
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__9S19008C12[] = {
  ABISELECT(-1084,-704),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C10__A2__9S19008C12[] = {
  ABISELECT(-1084,-704),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
extern void _ZN9S19008C162v8Ev();
extern void _ZN9S19008C14D1Ev();
extern void _ZN9S19008C14D0Ev();
extern void _ZN9S19008C143v16Ev();
extern void _ZN9S19008C143v17Ev();
extern void _ZN9S19008C143v18Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C14__9S19008C12[] = {
  ABISELECT(12376,8344),
  ABISELECT(11952,8076),
  ABISELECT(10992,7428),
  ABISELECT(9328,6320),
  ABISELECT(-320,-212),
  ABISELECT(-1392,-912),
  ABISELECT(-1760,-1168),
  ABISELECT(-1404,-916),
  ABISELECT(8416,5688),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
  (VTBL_ENTRY)&_ZN9S19008C14D1Ev,
  (VTBL_ENTRY)&_ZN9S19008C14D0Ev,
  (VTBL_ENTRY)&_ZN9S19008C143v16Ev,
  (VTBL_ENTRY)&_ZN9S19008C143v17Ev,
  (VTBL_ENTRY)&_ZN9S19008C143v18Ev,
};
extern void _ZN9S19008C162v8Ev();
extern void _ZN9S19008C15D1Ev();
extern void _ZN9S19008C15D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C159S19008C14__9S19008C12[] = {
  ABISELECT(-320,-212),
  ABISELECT(-1392,-912),
  ABISELECT(-1760,-1168),
  ABISELECT(-1404,-916),
  ABISELECT(8416,5688),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
  (VTBL_ENTRY)&_ZN9S19008C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19008C15D0Ev,
};
extern void _ZN9S19008C162v8Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C169S19008C159S19008C14__9S19008C12[] = {
  ABISELECT(-1404,-916),
  ABISELECT(8416,5688),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C169S19008C159S19008C14__9S19008C12[] = {
  ABISELECT(-9820,-6604),
  ABISELECT(-8416,-5688),
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__9S19008C169S19008C159S19008C14__9S19008C12[] = {
  ABISELECT(-10028,-6748),
  ABISELECT(-8624,-5832),
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
};
extern void _ZN8S19008C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C59S19008C159S19008C14__A2__9S19008C12[] = {
  ABISELECT(-1836,-1184),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C5[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C59S19008C159S19008C14__A6__9S19008C12[] = {
  ABISELECT(-1836,-1184),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
extern void _ZN9S19008C18D1Ev();
extern void _ZN9S19008C18D0Ev();
extern void _ZN9S19008C182v9Ev();
extern void _ZN9S19008C183v10Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C189S19008C159S19008C14__9S19008C12[] = {
  ABISELECT(-1040,-684),
  ABISELECT(-2112,-1384),
  ABISELECT(-2124,-1388),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
  (VTBL_ENTRY)&_ZN9S19008C18D1Ev,
  (VTBL_ENTRY)&_ZN9S19008C18D0Ev,
  (VTBL_ENTRY)&_ZN9S19008C182v9Ev,
  (VTBL_ENTRY)&_ZN9S19008C183v10Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C189S19008C159S19008C14__A2__9S19008C12[] = {
  ABISELECT(-2124,-1388),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C109S19008C189S19008C159S19008C14__A7__9S19008C12[] = {
  ABISELECT(-2124,-1388),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C189S19008C159S19008C14__A8__9S19008C12[] = {
  ABISELECT(-2476,-1620),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C6__A1__9S19008C189S19008C159S19008C14__9S19008C12[] = {
  ABISELECT(-2476,-1620),
  ABISELECT(-352,-232),
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
};
extern void _ZN8S19008C52v1Ev();
extern void ABISELECT(_ZTv0_n48_N9S19008C18D1Ev,_ZTv0_n24_N9S19008C18D1Ev)();
extern void ABISELECT(_ZTv0_n48_N9S19008C18D0Ev,_ZTv0_n24_N9S19008C18D0Ev)();
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C3__9S19008C189S19008C159S19008C14__9S19008C12[] = {
  0,
  0,
  ABISELECT(2112,1384),
  0,
  ABISELECT(1072,700),
  ABISELECT(-12,-4),
  ABISELECT(2112,1384),
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C18D1Ev,_ZTv0_n24_N9S19008C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C18D0Ev,_ZTv0_n24_N9S19008C18D0Ev),
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__A1__9S19008C189S19008C159S19008C14__9S19008C12[] = {
  ABISELECT(-1084,-704),
  ABISELECT(1040,684),
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C3__A4__9S19008C189S19008C159S19008C14__9S19008C12[] = {
  ABISELECT(-348,-232),
  ABISELECT(1776,1156),
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C159S19008C14__9S19008C12[] = {
  ABISELECT(-9820,-6604),
  ABISELECT(-8416,-5688),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__9S19008C159S19008C14__9S19008C12[] = {
  ABISELECT(-10028,-6748),
  ABISELECT(-8624,-5832),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
};
extern void _ZN8S19008C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C5__9S19008C159S19008C14__9S19008C12[] = {
  ABISELECT(-1836,-1184),
  ABISELECT(-432,-268),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
};
extern void ABISELECT(_ZThn720_N9S19008C15D1Ev,_ZThn472_N9S19008C15D1Ev)();
extern void ABISELECT(_ZThn720_N9S19008C15D0Ev,_ZThn472_N9S19008C15D0Ev)();
extern void _ZN9S19008C182v9Ev();
extern void _ZN9S19008C183v10Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C18__9S19008C159S19008C14__9S19008C12[] = {
  ABISELECT(-1040,-684),
  ABISELECT(-2112,-1384),
  ABISELECT(-2124,-1388),
  ABISELECT(-720,-472),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn720_N9S19008C15D1Ev,_ZThn472_N9S19008C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn720_N9S19008C15D0Ev,_ZThn472_N9S19008C15D0Ev),
  (VTBL_ENTRY)&_ZN9S19008C182v9Ev,
  (VTBL_ENTRY)&_ZN9S19008C183v10Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C18__A4__9S19008C159S19008C14__9S19008C12[] = {
  ABISELECT(-2476,-1620),
  ABISELECT(-1072,-704),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
};
extern void _ZN8S19008C52v1Ev();
extern void ABISELECT(_ZTv0_n48_N9S19008C15D1Ev,_ZTv0_n24_N9S19008C15D1Ev)();
extern void ABISELECT(_ZTv0_n48_N9S19008C15D0Ev,_ZTv0_n24_N9S19008C15D0Ev)();
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C3__9S19008C159S19008C14__9S19008C12[] = {
  0,
  0,
  ABISELECT(1392,912),
  0,
  ABISELECT(1072,700),
  ABISELECT(-12,-4),
  ABISELECT(1392,912),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C15D1Ev,_ZTv0_n24_N9S19008C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C15D0Ev,_ZTv0_n24_N9S19008C15D0Ev),
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__A2__9S19008C159S19008C14__9S19008C12[] = {
  ABISELECT(-1084,-704),
  ABISELECT(320,212),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C3__A7__9S19008C159S19008C14__9S19008C12[] = {
  ABISELECT(-348,-232),
  ABISELECT(1056,684),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
};
extern void _ZN8S19008C52v1Ev();
extern void _ZN9S19008C19D1Ev();
extern void _ZN9S19008C19D0Ev();
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C199S19008C14__9S19008C12[] = {
  ABISELECT(-3056,-2020),
  ABISELECT(6752,4580),
  ABISELECT(-3424,-2276),
  ABISELECT(7664,5212),
  ABISELECT(-1984,-1320),
  ABISELECT(-3068,-2024),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&_ZN9S19008C19D1Ev,
  (VTBL_ENTRY)&_ZN9S19008C19D0Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
};
extern void _ZN8S19008C52v1Ev();
extern void _ZN8S19008C3D1Ev();
extern void _ZN8S19008C3D0Ev();
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C39S19008C199S19008C14__A1__9S19008C12[] = {
  ABISELECT(-1984,-1320),
  ABISELECT(-3068,-2024),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&_ZN8S19008C3D1Ev,
  (VTBL_ENTRY)&_ZN8S19008C3D0Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
};
extern void _ZN8S19008C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C58S19008C39S19008C199S19008C14__A3__9S19008C12[] = {
  ABISELECT(-3068,-2024),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C5[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C58S19008C39S19008C199S19008C14__A9__9S19008C12[] = {
  ABISELECT(-3068,-2024),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C39S19008C199S19008C14__A10__9S19008C12[] = {
  ABISELECT(-3404,-2252),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__8S19008C39S19008C199S19008C14__A1__9S19008C12[] = {
  ABISELECT(-1084,-704),
  ABISELECT(1984,1320),
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C6__A2__8S19008C39S19008C199S19008C14__A1__9S19008C12[] = {
  ABISELECT(-3404,-2252),
  ABISELECT(-336,-228),
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C199S19008C14__A11__9S19008C12[] = {
  ABISELECT(-4140,-2724),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__9S19008C199S19008C14__9S19008C12[] = {
  ABISELECT(-1084,-704),
  ABISELECT(1984,1320),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C3__A2__9S19008C199S19008C14__9S19008C12[] = {
  ABISELECT(-3404,-2252),
  ABISELECT(-336,-228),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C6__A3__9S19008C199S19008C14__9S19008C12[] = {
  ABISELECT(-4140,-2724),
  ABISELECT(-1072,-700),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
};
extern void _ZN9S19008C162v8Ev();
extern void ABISELECT(_ZTv0_n72_N9S19008C19D1Ev,_ZTv0_n36_N9S19008C19D1Ev)();
extern void ABISELECT(_ZThn7664_N9S19008C19D1Ev,_ZThn5212_N9S19008C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S19008C19D0Ev,_ZTv0_n36_N9S19008C19D0Ev)();
extern void ABISELECT(_ZThn7664_N9S19008C19D0Ev,_ZThn5212_N9S19008C19D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19008C15__9S19008C199S19008C14__9S19008C12[] = {
  ABISELECT(720,472),
  ABISELECT(720,472),
  ABISELECT(432,268),
  ABISELECT(-7664,-5212),
  0,
  ABISELECT(-9648,-6532),
  ABISELECT(-10720,-7232),
  ABISELECT(-11088,-7488),
  ABISELECT(-10732,-7236),
  ABISELECT(-912,-632),
  ABISELECT(-7664,-5212),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S19008C19D1Ev,_ZTv0_n36_N9S19008C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S19008C19D0Ev,_ZTv0_n36_N9S19008C19D0Ev),
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C199S19008C14__9S19008C12[] = {
  ABISELECT(-9820,-6604),
  ABISELECT(-6752,-4580),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__A1__9S19008C199S19008C14__9S19008C12[] = {
  ABISELECT(-10028,-6748),
  ABISELECT(-6960,-4724),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
};
extern void _ZN8S19008C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C59S19008C15__A1__9S19008C199S19008C14__9S19008C12[] = {
  ABISELECT(-11164,-7504),
  ABISELECT(-8096,-5480),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
};
extern void ABISELECT(_ZTvn720_n72_N9S19008C19D1Ev,_ZTvn472_n36_N9S19008C19D1Ev)();
extern void ABISELECT(_ZTvn720_n72_N9S19008C19D0Ev,_ZTvn472_n36_N9S19008C19D0Ev)();
extern void _ZN9S19008C182v9Ev();
extern void _ZN9S19008C183v10Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C189S19008C15__9S19008C199S19008C14__9S19008C12[] = {
  ABISELECT(-10368,-7004),
  ABISELECT(-11440,-7704),
  ABISELECT(-11452,-7708),
  ABISELECT(-8384,-5684),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn720_n72_N9S19008C19D1Ev,_ZTvn472_n36_N9S19008C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn720_n72_N9S19008C19D0Ev,_ZTvn472_n36_N9S19008C19D0Ev),
  (VTBL_ENTRY)&_ZN9S19008C182v9Ev,
  (VTBL_ENTRY)&_ZN9S19008C183v10Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C189S19008C15__A8__9S19008C199S19008C14__9S19008C12[] = {
  ABISELECT(-11804,-7940),
  ABISELECT(-8736,-5916),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
};
extern void _ZN8S19008C52v1Ev();
extern void ABISELECT(_ZTv0_n48_N9S19008C19D1Ev,_ZTv0_n24_N9S19008C19D1Ev)();
extern void ABISELECT(_ZTv0_n48_N9S19008C19D0Ev,_ZTv0_n24_N9S19008C19D0Ev)();
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C3__A1__9S19008C199S19008C14__9S19008C12[] = {
  0,
  0,
  ABISELECT(3056,2020),
  0,
  ABISELECT(1072,700),
  ABISELECT(-12,-4),
  ABISELECT(3056,2020),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C19D1Ev,_ZTv0_n24_N9S19008C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C19D0Ev,_ZTv0_n24_N9S19008C19D0Ev),
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C3__A10__9S19008C199S19008C14__9S19008C12[] = {
  ABISELECT(-348,-232),
  ABISELECT(2720,1792),
  (VTBL_ENTRY)&(_ZTI9S19008C19[0]),
};
extern void _ZN8S19008C52v1Ev();
extern void _ZN9S19008C203v15Ev();
extern void _ZN9S19008C20D1Ev();
extern void _ZN9S19008C20D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C209S19008C14__9S19008C12[] = {
  ABISELECT(7576,5128),
  ABISELECT(7152,4860),
  ABISELECT(6192,4212),
  ABISELECT(3616,2472),
  ABISELECT(-6560,-4384),
  ABISELECT(-6204,-4132),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C20[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&_ZN9S19008C203v15Ev,
  (VTBL_ENTRY)&_ZN9S19008C20D1Ev,
  (VTBL_ENTRY)&_ZN9S19008C20D0Ev,
};
extern void _ZN8S19008C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C59S19008C209S19008C14__A5__9S19008C12[] = {
  ABISELECT(-6204,-4132),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C5[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C59S19008C209S19008C14__A15__9S19008C12[] = {
  ABISELECT(-6204,-4132),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
extern void _ZN9S19008C162v8Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C169S19008C209S19008C14__A2__9S19008C12[] = {
  ABISELECT(-6492,-4336),
  ABISELECT(3328,2268),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C169S19008C209S19008C14__A2__9S19008C12[] = {
  ABISELECT(-9820,-6604),
  ABISELECT(-3328,-2268),
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__9S19008C169S19008C209S19008C14__A2__9S19008C12[] = {
  ABISELECT(-10028,-6748),
  ABISELECT(-3536,-2412),
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C179S19008C209S19008C14__A1__9S19008C12[] = {
  ABISELECT(-6924,-4604),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C17[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C179S19008C209S19008C14__A16__9S19008C12[] = {
  ABISELECT(-6924,-4604),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C179S19008C209S19008C14__A4__9S19008C12[] = {
  ABISELECT(-7132,-4748),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C109S19008C179S19008C209S19008C14__A17__9S19008C12[] = {
  ABISELECT(-7132,-4748),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__9S19008C179S19008C209S19008C14__A1__9S19008C12[] = {
  ABISELECT(-7132,-4748),
  ABISELECT(-208,-144),
  (VTBL_ENTRY)&(_ZTI9S19008C17[0]),
};
extern void _ZN9S19008C162v8Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C16__A__9S19008C209S19008C14__9S19008C12[] = {
  ABISELECT(-6492,-4336),
  ABISELECT(3328,2268),
  ABISELECT(-288,-204),
  (VTBL_ENTRY)&(_ZTI9S19008C20[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C209S19008C14__9S19008C12[] = {
  ABISELECT(-9820,-6604),
  ABISELECT(-3616,-2472),
  (VTBL_ENTRY)&(_ZTI9S19008C20[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__9S19008C209S19008C14__9S19008C12[] = {
  ABISELECT(-10028,-6748),
  ABISELECT(-3824,-2616),
  (VTBL_ENTRY)&(_ZTI9S19008C20[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__A__9S19008C209S19008C14__9S19008C12[] = {
  ABISELECT(-6924,-4604),
  ABISELECT(-720,-472),
  (VTBL_ENTRY)&(_ZTI9S19008C20[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__A1__9S19008C209S19008C14__9S19008C12[] = {
  ABISELECT(-7132,-4748),
  ABISELECT(-928,-616),
  (VTBL_ENTRY)&(_ZTI9S19008C20[0]),
};
extern void ABISELECT(_ZTv0_n56_N9S19008C20D1Ev,_ZTv0_n28_N9S19008C20D1Ev)();
extern void ABISELECT(_ZThn6192_N9S19008C20D1Ev,_ZThn4212_N9S19008C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S19008C20D0Ev,_ZTv0_n28_N9S19008C20D0Ev)();
extern void ABISELECT(_ZThn6192_N9S19008C20D0Ev,_ZThn4212_N9S19008C20D0Ev)() __attribute__((weak));
extern void _ZN9S19008C213v11Ev();
extern void _ZN9S19008C213v12Ev();
extern void _ZN9S19008C213v13Ev();
extern void _ZN9S19008C213v14Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C21__9S19008C209S19008C14__9S19008C12[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-6192,-4212),
  ABISELECT(1384,916),
  ABISELECT(960,648),
  ABISELECT(-2576,-1740),
  ABISELECT(-12396,-8344),
  ABISELECT(-6192,-4212),
  (VTBL_ENTRY)&(_ZTI9S19008C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19008C20D1Ev,_ZTv0_n28_N9S19008C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19008C20D0Ev,_ZTv0_n28_N9S19008C20D0Ev),
  (VTBL_ENTRY)&_ZN9S19008C213v11Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v12Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v13Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v14Ev,
};
extern void _ZN9S19008C162v8Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C16__A1__9S19008C209S19008C14__9S19008C12[] = {
  0,
  ABISELECT(-13356,-8992),
  ABISELECT(-3536,-2388),
  ABISELECT(-7152,-4860),
  (VTBL_ENTRY)&(_ZTI9S19008C20[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19008C20D1Ev,_ZTv0_n12_N9S19008C20D1Ev)();
extern void ABISELECT(_ZThn7576_N9S19008C20D1Ev,_ZThn5128_N9S19008C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19008C20D0Ev,_ZTv0_n12_N9S19008C20D0Ev)();
extern void ABISELECT(_ZThn7576_N9S19008C20D0Ev,_ZThn5128_N9S19008C20D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19008C22__9S19008C209S19008C14__9S19008C12[] = {
  ABISELECT(-7576,-5128),
  ABISELECT(-7576,-5128),
  (VTBL_ENTRY)&(_ZTI9S19008C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19008C20D1Ev,_ZTv0_n12_N9S19008C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19008C20D0Ev,_ZTv0_n12_N9S19008C20D0Ev),
};
static  VTBL_ENTRY _tg__ZTV9S19008C179S19008C14__A2__9S19008C12[] = {
  ABISELECT(-8892,-5960),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C17[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C179S19008C14__A19__9S19008C12[] = {
  ABISELECT(-8892,-5960),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C179S19008C14__A6__9S19008C12[] = {
  ABISELECT(-9100,-6104),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C109S19008C179S19008C14__A20__9S19008C12[] = {
  ABISELECT(-9100,-6104),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__9S19008C179S19008C14__A2__9S19008C12[] = {
  ABISELECT(-9100,-6104),
  ABISELECT(-208,-144),
  (VTBL_ENTRY)&(_ZTI9S19008C17[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C14__9S19008C12[] = {
  ABISELECT(-9820,-6604),
  ABISELECT(-8416,-5688),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__9S19008C14__9S19008C12[] = {
  ABISELECT(-10028,-6748),
  ABISELECT(-8624,-5832),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
};
extern void _ZN8S19008C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C59S19008C15__9S19008C14__9S19008C12[] = {
  ABISELECT(-1836,-1184),
  ABISELECT(-432,-268),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
};
extern void ABISELECT(_ZThn720_N9S19008C14D1Ev,_ZThn472_N9S19008C14D1Ev)();
extern void ABISELECT(_ZThn720_N9S19008C14D0Ev,_ZThn472_N9S19008C14D0Ev)();
extern void _ZN9S19008C182v9Ev();
extern void _ZN9S19008C183v10Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C189S19008C15__9S19008C14__9S19008C12[] = {
  ABISELECT(-1040,-684),
  ABISELECT(-2112,-1384),
  ABISELECT(-2124,-1388),
  ABISELECT(-720,-472),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn720_N9S19008C14D1Ev,_ZThn472_N9S19008C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn720_N9S19008C14D0Ev,_ZThn472_N9S19008C14D0Ev),
  (VTBL_ENTRY)&_ZN9S19008C182v9Ev,
  (VTBL_ENTRY)&_ZN9S19008C183v10Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C189S19008C15__A4__9S19008C14__9S19008C12[] = {
  ABISELECT(-2476,-1620),
  ABISELECT(-1072,-704),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
};
extern void _ZN8S19008C52v1Ev();
extern void ABISELECT(_ZTv0_n48_N9S19008C14D1Ev,_ZTv0_n24_N9S19008C14D1Ev)();
extern void ABISELECT(_ZTv0_n48_N9S19008C14D0Ev,_ZTv0_n24_N9S19008C14D0Ev)();
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C3__9S19008C14__9S19008C12[] = {
  0,
  0,
  ABISELECT(1392,912),
  0,
  ABISELECT(1072,700),
  ABISELECT(-12,-4),
  ABISELECT(1392,912),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C14D1Ev,_ZTv0_n24_N9S19008C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C14D0Ev,_ZTv0_n24_N9S19008C14D0Ev),
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__A2__9S19008C14__9S19008C12[] = {
  ABISELECT(-1084,-704),
  ABISELECT(320,212),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C3__A7__9S19008C14__9S19008C12[] = {
  ABISELECT(-348,-232),
  ABISELECT(1056,684),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
};
extern void _ZN8S19008C52v1Ev();
extern void ABISELECT(_ZThn1664_N9S19008C14D1Ev,_ZThn1108_N9S19008C14D1Ev)();
extern void ABISELECT(_ZThn1664_N9S19008C14D0Ev,_ZThn1108_N9S19008C14D0Ev)();
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C19__9S19008C14__9S19008C12[] = {
  ABISELECT(-3056,-2020),
  ABISELECT(6752,4580),
  ABISELECT(-3424,-2276),
  ABISELECT(7664,5212),
  ABISELECT(-1984,-1320),
  ABISELECT(-3068,-2024),
  ABISELECT(-1664,-1108),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn1664_N9S19008C14D1Ev,_ZThn1108_N9S19008C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1664_N9S19008C14D0Ev,_ZThn1108_N9S19008C14D0Ev),
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C39S19008C19__A9__9S19008C14__9S19008C12[] = {
  ABISELECT(-3404,-2252),
  ABISELECT(-2000,-1336),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C19__A10__9S19008C14__9S19008C12[] = {
  ABISELECT(-4140,-2724),
  ABISELECT(-2736,-1808),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
};
extern void _ZN9S19008C162v8Ev();
extern void ABISELECT(_ZTv0_n72_N9S19008C14D1Ev,_ZTv0_n36_N9S19008C14D1Ev)();
extern void ABISELECT(_ZThn9328_N9S19008C14D1Ev,_ZThn6320_N9S19008C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S19008C14D0Ev,_ZTv0_n36_N9S19008C14D0Ev)();
extern void ABISELECT(_ZThn9328_N9S19008C14D0Ev,_ZThn6320_N9S19008C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19008C15__A1__9S19008C14__9S19008C12[] = {
  ABISELECT(720,472),
  ABISELECT(720,472),
  ABISELECT(432,268),
  ABISELECT(-9328,-6320),
  0,
  ABISELECT(-9648,-6532),
  ABISELECT(-10720,-7232),
  ABISELECT(-11088,-7488),
  ABISELECT(-10732,-7236),
  ABISELECT(-912,-632),
  ABISELECT(-9328,-6320),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S19008C14D1Ev,_ZTv0_n36_N9S19008C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S19008C14D0Ev,_ZTv0_n36_N9S19008C14D0Ev),
};
extern void _ZN8S19008C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C59S19008C15__A3__9S19008C14__9S19008C12[] = {
  ABISELECT(-11164,-7504),
  ABISELECT(-9760,-6588),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
};
extern void ABISELECT(_ZTvn720_n72_N9S19008C14D1Ev,_ZTvn472_n36_N9S19008C14D1Ev)();
extern void ABISELECT(_ZTvn720_n72_N9S19008C14D0Ev,_ZTvn472_n36_N9S19008C14D0Ev)();
extern void _ZN9S19008C182v9Ev();
extern void _ZN9S19008C183v10Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C189S19008C15__A1__9S19008C14__9S19008C12[] = {
  ABISELECT(-10368,-7004),
  ABISELECT(-11440,-7704),
  ABISELECT(-11452,-7708),
  ABISELECT(-10048,-6792),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn720_n72_N9S19008C14D1Ev,_ZTvn472_n36_N9S19008C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn720_n72_N9S19008C14D0Ev,_ZTvn472_n36_N9S19008C14D0Ev),
  (VTBL_ENTRY)&_ZN9S19008C182v9Ev,
  (VTBL_ENTRY)&_ZN9S19008C183v10Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C189S19008C15__A13__9S19008C14__9S19008C12[] = {
  ABISELECT(-11804,-7940),
  ABISELECT(-10400,-7024),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
};
extern void _ZN8S19008C52v1Ev();
extern void _ZN9S19008C203v15Ev();
extern void ABISELECT(_ZThn4800_N9S19008C14D1Ev,_ZThn3216_N9S19008C14D1Ev)();
extern void ABISELECT(_ZThn4800_N9S19008C14D0Ev,_ZThn3216_N9S19008C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19008C20__9S19008C14__9S19008C12[] = {
  ABISELECT(7576,5128),
  ABISELECT(7152,4860),
  ABISELECT(6192,4212),
  ABISELECT(3616,2472),
  ABISELECT(-6560,-4384),
  ABISELECT(-6204,-4132),
  ABISELECT(-4800,-3216),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&_ZN9S19008C203v15Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn4800_N9S19008C14D1Ev,_ZThn3216_N9S19008C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn4800_N9S19008C14D0Ev,_ZThn3216_N9S19008C14D0Ev),
};
extern void _ZN9S19008C162v8Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C169S19008C20__A2__9S19008C14__9S19008C12[] = {
  ABISELECT(-6492,-4336),
  ABISELECT(3328,2268),
  ABISELECT(-5088,-3420),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C179S19008C20__A1__9S19008C14__9S19008C12[] = {
  ABISELECT(-6924,-4604),
  ABISELECT(-5520,-3688),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C179S19008C20__A4__9S19008C14__9S19008C12[] = {
  ABISELECT(-7132,-4748),
  ABISELECT(-5728,-3832),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
};
extern void ABISELECT(_ZTv0_n56_N9S19008C14D1Ev,_ZTv0_n28_N9S19008C14D1Ev)();
extern void ABISELECT(_ZThn10992_N9S19008C14D1Ev,_ZThn7428_N9S19008C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S19008C14D0Ev,_ZTv0_n28_N9S19008C14D0Ev)();
extern void ABISELECT(_ZThn10992_N9S19008C14D0Ev,_ZThn7428_N9S19008C14D0Ev)() __attribute__((weak));
extern void _ZN9S19008C213v11Ev();
extern void _ZN9S19008C213v12Ev();
extern void _ZN9S19008C213v13Ev();
extern void _ZN9S19008C213v14Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C21__9S19008C14__9S19008C12[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-10992,-7428),
  ABISELECT(1384,916),
  ABISELECT(960,648),
  ABISELECT(-2576,-1740),
  ABISELECT(-12396,-8344),
  ABISELECT(-10992,-7428),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19008C14D1Ev,_ZTv0_n28_N9S19008C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19008C14D0Ev,_ZTv0_n28_N9S19008C14D0Ev),
  (VTBL_ENTRY)&_ZN9S19008C213v11Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v12Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v13Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v14Ev,
};
extern void _ZN9S19008C162v8Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C16__A3__9S19008C14__9S19008C12[] = {
  0,
  ABISELECT(-13356,-8992),
  ABISELECT(-3536,-2388),
  ABISELECT(-11952,-8076),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19008C14D1Ev,_ZTv0_n12_N9S19008C14D1Ev)();
extern void ABISELECT(_ZThn12376_N9S19008C14D1Ev,_ZThn8344_N9S19008C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19008C14D0Ev,_ZTv0_n12_N9S19008C14D0Ev)();
extern void ABISELECT(_ZThn12376_N9S19008C14D0Ev,_ZThn8344_N9S19008C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19008C22__9S19008C14__9S19008C12[] = {
  ABISELECT(-12376,-8344),
  ABISELECT(-12376,-8344),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19008C14D1Ev,_ZTv0_n12_N9S19008C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19008C14D0Ev,_ZTv0_n12_N9S19008C14D0Ev),
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__A__9S19008C14__9S19008C12[] = {
  ABISELECT(-8892,-5960),
  ABISELECT(-7488,-5044),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__A6__9S19008C14__9S19008C12[] = {
  ABISELECT(-9100,-6104),
  ABISELECT(-7696,-5188),
  (VTBL_ENTRY)&(_ZTI9S19008C14[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C12[] = {
  ABISELECT(-9820,-6604),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C17[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C17__A4__9S19008C12[] = {
  ABISELECT(-9820,-6604),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__A1__9S19008C12[] = {
  ABISELECT(-10028,-6748),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C109S19008C17__A5__9S19008C12[] = {
  ABISELECT(-10028,-6748),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__9S19008C17__9S19008C12[] = {
  ABISELECT(-10028,-6748),
  ABISELECT(-208,-144),
  (VTBL_ENTRY)&(_ZTI9S19008C17[0]),
};
extern void _ZN9S19008C162v8Ev();
extern void _ZN9S19008C15D1Ev();
extern void _ZN9S19008C15D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C15__A1__9S19008C12[] = {
  ABISELECT(-9648,-6532),
  ABISELECT(-10720,-7232),
  ABISELECT(-11088,-7488),
  ABISELECT(-10732,-7236),
  ABISELECT(-912,-632),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
  (VTBL_ENTRY)&_ZN9S19008C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19008C15D0Ev,
};
extern void _ZN9S19008C162v8Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C169S19008C15__A1__9S19008C12[] = {
  ABISELECT(-10732,-7236),
  ABISELECT(-912,-632),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C169S19008C15__A1__9S19008C12[] = {
  ABISELECT(-9820,-6604),
  ABISELECT(912,632),
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__9S19008C169S19008C15__A1__9S19008C12[] = {
  ABISELECT(-10028,-6748),
  ABISELECT(704,488),
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
};
extern void _ZN8S19008C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C59S19008C15__A4__9S19008C12[] = {
  ABISELECT(-11164,-7504),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C5[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C59S19008C15__A12__9S19008C12[] = {
  ABISELECT(-11164,-7504),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
extern void _ZN9S19008C18D1Ev();
extern void _ZN9S19008C18D0Ev();
extern void _ZN9S19008C182v9Ev();
extern void _ZN9S19008C183v10Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C189S19008C15__A1__9S19008C12[] = {
  ABISELECT(-10368,-7004),
  ABISELECT(-11440,-7704),
  ABISELECT(-11452,-7708),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
  (VTBL_ENTRY)&_ZN9S19008C18D1Ev,
  (VTBL_ENTRY)&_ZN9S19008C18D0Ev,
  (VTBL_ENTRY)&_ZN9S19008C182v9Ev,
  (VTBL_ENTRY)&_ZN9S19008C183v10Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C189S19008C15__A3__9S19008C12[] = {
  ABISELECT(-11452,-7708),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C109S19008C189S19008C15__A13__9S19008C12[] = {
  ABISELECT(-11452,-7708),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C189S19008C15__A14__9S19008C12[] = {
  ABISELECT(-11804,-7940),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C6__A1__9S19008C189S19008C15__A1__9S19008C12[] = {
  ABISELECT(-11804,-7940),
  ABISELECT(-352,-232),
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
};
extern void _ZN8S19008C52v1Ev();
extern void ABISELECT(_ZTv0_n48_N9S19008C18D1Ev,_ZTv0_n24_N9S19008C18D1Ev)();
extern void ABISELECT(_ZTv0_n48_N9S19008C18D0Ev,_ZTv0_n24_N9S19008C18D0Ev)();
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C3__9S19008C189S19008C15__A1__9S19008C12[] = {
  0,
  0,
  ABISELECT(11440,7704),
  0,
  ABISELECT(1072,700),
  ABISELECT(-12,-4),
  ABISELECT(11440,7704),
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C18D1Ev,_ZTv0_n24_N9S19008C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C18D0Ev,_ZTv0_n24_N9S19008C18D0Ev),
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__A1__9S19008C189S19008C15__A1__9S19008C12[] = {
  ABISELECT(-1084,-704),
  ABISELECT(10368,7004),
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C3__A4__9S19008C189S19008C15__A1__9S19008C12[] = {
  ABISELECT(-348,-232),
  ABISELECT(11104,7476),
  (VTBL_ENTRY)&(_ZTI9S19008C18[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C15__A1__9S19008C12[] = {
  ABISELECT(-9820,-6604),
  ABISELECT(912,632),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__9S19008C15__A1__9S19008C12[] = {
  ABISELECT(-10028,-6748),
  ABISELECT(704,488),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
};
extern void _ZN8S19008C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C5__9S19008C15__A1__9S19008C12[] = {
  ABISELECT(-11164,-7504),
  ABISELECT(-432,-268),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
};
extern void ABISELECT(_ZThn720_N9S19008C15D1Ev,_ZThn472_N9S19008C15D1Ev)();
extern void ABISELECT(_ZThn720_N9S19008C15D0Ev,_ZThn472_N9S19008C15D0Ev)();
extern void _ZN9S19008C182v9Ev();
extern void _ZN9S19008C183v10Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C18__9S19008C15__A1__9S19008C12[] = {
  ABISELECT(-10368,-7004),
  ABISELECT(-11440,-7704),
  ABISELECT(-11452,-7708),
  ABISELECT(-720,-472),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn720_N9S19008C15D1Ev,_ZThn472_N9S19008C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn720_N9S19008C15D0Ev,_ZThn472_N9S19008C15D0Ev),
  (VTBL_ENTRY)&_ZN9S19008C182v9Ev,
  (VTBL_ENTRY)&_ZN9S19008C183v10Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C18__A4__9S19008C15__A1__9S19008C12[] = {
  ABISELECT(-11804,-7940),
  ABISELECT(-1072,-704),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
};
extern void _ZN8S19008C52v1Ev();
extern void ABISELECT(_ZTv0_n48_N9S19008C15D1Ev,_ZTv0_n24_N9S19008C15D1Ev)();
extern void ABISELECT(_ZTv0_n48_N9S19008C15D0Ev,_ZTv0_n24_N9S19008C15D0Ev)();
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C3__9S19008C15__A1__9S19008C12[] = {
  0,
  0,
  ABISELECT(10720,7232),
  0,
  ABISELECT(1072,700),
  ABISELECT(-12,-4),
  ABISELECT(10720,7232),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C15D1Ev,_ZTv0_n24_N9S19008C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19008C15D0Ev,_ZTv0_n24_N9S19008C15D0Ev),
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__A2__9S19008C15__A1__9S19008C12[] = {
  ABISELECT(-1084,-704),
  ABISELECT(9648,6532),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C3__A7__9S19008C15__A1__9S19008C12[] = {
  ABISELECT(-348,-232),
  ABISELECT(10384,7004),
  (VTBL_ENTRY)&(_ZTI9S19008C15[0]),
};
extern void _ZN9S19008C21D1Ev();
extern void _ZN9S19008C21D0Ev();
extern void _ZN9S19008C213v11Ev();
extern void _ZN9S19008C213v12Ev();
extern void _ZN9S19008C213v13Ev();
extern void _ZN9S19008C213v14Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C21__9S19008C12[] = {
  ABISELECT(1384,916),
  ABISELECT(960,648),
  ABISELECT(-2576,-1740),
  ABISELECT(-12396,-8344),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C21[0]),
  (VTBL_ENTRY)&_ZN9S19008C21D1Ev,
  (VTBL_ENTRY)&_ZN9S19008C21D0Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v11Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v12Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v13Ev,
  (VTBL_ENTRY)&_ZN9S19008C213v14Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C21__A5__9S19008C12[] = {
  ABISELECT(-12396,-8344),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C109S19008C21__A18__9S19008C12[] = {
  ABISELECT(-12396,-8344),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C21__9S19008C12[] = {
  ABISELECT(-9820,-6604),
  ABISELECT(2576,1740),
  (VTBL_ENTRY)&(_ZTI9S19008C21[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__9S19008C21__9S19008C12[] = {
  ABISELECT(-10028,-6748),
  ABISELECT(2368,1596),
  (VTBL_ENTRY)&(_ZTI9S19008C21[0]),
};
extern void _ZN9S19008C162v8Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C16__9S19008C21__9S19008C12[] = {
  0,
  ABISELECT(-13356,-8992),
  ABISELECT(-3536,-2388),
  ABISELECT(-960,-648),
  (VTBL_ENTRY)&(_ZTI9S19008C21[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19008C21D1Ev,_ZTv0_n12_N9S19008C21D1Ev)();
extern void ABISELECT(_ZThn1384_N9S19008C21D1Ev,_ZThn916_N9S19008C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19008C21D0Ev,_ZTv0_n12_N9S19008C21D0Ev)();
extern void ABISELECT(_ZThn1384_N9S19008C21D0Ev,_ZThn916_N9S19008C21D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19008C22__9S19008C21__9S19008C12[] = {
  ABISELECT(-1384,-916),
  ABISELECT(-1384,-916),
  (VTBL_ENTRY)&(_ZTI9S19008C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19008C21D1Ev,_ZTv0_n12_N9S19008C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19008C21D0Ev,_ZTv0_n12_N9S19008C21D0Ev),
};
extern void _ZN9S19008C162v8Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C16__A3__9S19008C12[] = {
  ABISELECT(-13356,-8992),
  ABISELECT(-3536,-2388),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
  (VTBL_ENTRY)&_ZN9S19008C162v8Ev,
};
static  VTBL_ENTRY _tg__ZTV9S19008C17__9S19008C16__A3__9S19008C12[] = {
  ABISELECT(-9820,-6604),
  ABISELECT(3536,2388),
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C109S19008C17__9S19008C16__A3__9S19008C12[] = {
  ABISELECT(-10028,-6748),
  ABISELECT(3328,2244),
  (VTBL_ENTRY)&(_ZTI9S19008C16[0]),
};
static  VTT_ENTRY vtt_S19008C12[] = {
  {&(_ZTV9S19008C12[13]),  13,198},
  {&(_tg__ZTV8S19008C5__9S19008C12[3]),  3,4},
  {&(_tg__ZTV8S19008C68S19008C5__9S19008C12[3]),  3,3},
  {&(_ZTV9S19008C12[26]),  26,198},
  {&(_ZTV9S19008C12[37]),  37,198},
  {&(_ZTV9S19008C12[34]),  34,198},
  {&(_ZTV9S19008C12[59]),  59,198},
  {&(_ZTV9S19008C12[132]),  132,198},
  {&(_ZTV9S19008C12[135]),  135,198},
  {&(_ZTV9S19008C12[68]),  68,198},
  {&(_ZTV9S19008C12[74]),  74,198},
  {&(_ZTV9S19008C12[81]),  81,198},
  {&(_ZTV9S19008C12[89]),  89,198},
  {&(_ZTV9S19008C12[97]),  97,198},
  {&(_ZTV9S19008C12[100]),  100,198},
  {&(_ZTV9S19008C12[147]),  147,198},
  {&(_ZTV9S19008C12[153]),  153,198},
  {&(_ZTV9S19008C12[159]),  159,198},
  {&(_ZTV9S19008C12[166]),  166,198},
  {&(_ZTV9S19008C12[108]),  108,198},
  {&(_ZTV9S19008C12[116]),  116,198},
  {&(_ZTV9S19008C12[120]),  120,198},
  {&(_ZTV9S19008C12[123]),  123,198},
  {&(_ZTV9S19008C12[177]),  177,198},
  {&(_ZTV9S19008C12[188]),  188,198},
  {&(_ZTV9S19008C12[192]),  192,198},
  {&(_ZTV9S19008C12[126]),  126,198},
  {&(_ZTV9S19008C12[129]),  129,198},
  {&(_ZTV9S19008C12[197]),  197,198},
  {&(_tg__ZTV8S19008C3__9S19008C12[4]),  4,9},
  {&(_tg__ZTV8S19008C58S19008C3__A1__9S19008C12[3]),  3,4},
  {&(_tg__ZTV8S19008C68S19008C58S19008C3__A1__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C68S19008C3__A3__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C10__8S19008C3__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C6__A2__8S19008C3__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C10__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C10__A2__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C14__9S19008C12[11]),  11,17},
  {&(_tg__ZTV9S19008C159S19008C14__9S19008C12[7]),  7,10},
  {&(_tg__ZTV9S19008C169S19008C159S19008C14__9S19008C12[4]),  4,5},
  {&(_tg__ZTV9S19008C17__9S19008C169S19008C159S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__9S19008C169S19008C159S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C59S19008C159S19008C14__A2__9S19008C12[3]),  3,4},
  {&(_tg__ZTV8S19008C68S19008C59S19008C159S19008C14__A6__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C189S19008C159S19008C14__9S19008C12[5]),  5,9},
  {&(_tg__ZTV9S19008C109S19008C189S19008C159S19008C14__A2__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C109S19008C189S19008C159S19008C14__A7__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C189S19008C159S19008C14__A8__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C6__A1__9S19008C189S19008C159S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C3__9S19008C189S19008C159S19008C14__9S19008C12[8]),  8,13},
  {&(_tg__ZTV9S19008C10__A1__9S19008C189S19008C159S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C68S19008C3__A4__9S19008C189S19008C159S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C17__9S19008C159S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__9S19008C159S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C5__9S19008C159S19008C14__9S19008C12[3]),  3,4},
  {&(_tg__ZTV9S19008C18__9S19008C159S19008C14__9S19008C12[5]),  5,9},
  {&(_tg__ZTV8S19008C69S19008C18__A4__9S19008C159S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C3__9S19008C159S19008C14__9S19008C12[8]),  8,13},
  {&(_tg__ZTV9S19008C10__A2__9S19008C159S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C68S19008C3__A7__9S19008C159S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C199S19008C14__9S19008C12[8]),  8,13},
  {&(_tg__ZTV8S19008C39S19008C199S19008C14__A1__9S19008C12[4]),  4,9},
  {&(_tg__ZTV8S19008C58S19008C39S19008C199S19008C14__A3__9S19008C12[3]),  3,4},
  {&(_tg__ZTV8S19008C68S19008C58S19008C39S19008C199S19008C14__A9__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C68S19008C39S19008C199S19008C14__A10__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C10__8S19008C39S19008C199S19008C14__A1__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C6__A2__8S19008C39S19008C199S19008C14__A1__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C199S19008C14__A11__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C10__9S19008C199S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C68S19008C3__A2__9S19008C199S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C6__A3__9S19008C199S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C15__9S19008C199S19008C14__9S19008C12[12]),  12,15},
  {&(_tg__ZTV9S19008C17__9S19008C199S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__A1__9S19008C199S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C59S19008C15__A1__9S19008C199S19008C14__9S19008C12[3]),  3,4},
  {&(_tg__ZTV9S19008C189S19008C15__9S19008C199S19008C14__9S19008C12[5]),  5,9},
  {&(_tg__ZTV8S19008C69S19008C189S19008C15__A8__9S19008C199S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C3__A1__9S19008C199S19008C14__9S19008C12[8]),  8,13},
  {&(_tg__ZTV8S19008C68S19008C3__A10__9S19008C199S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C209S19008C14__9S19008C12[8]),  8,12},
  {&(_tg__ZTV8S19008C59S19008C209S19008C14__A5__9S19008C12[3]),  3,4},
  {&(_tg__ZTV8S19008C68S19008C59S19008C209S19008C14__A15__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C169S19008C209S19008C14__A2__9S19008C12[4]),  4,5},
  {&(_tg__ZTV9S19008C17__9S19008C169S19008C209S19008C14__A2__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__9S19008C169S19008C209S19008C14__A2__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C179S19008C209S19008C14__A1__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C179S19008C209S19008C14__A16__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C179S19008C209S19008C14__A4__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C109S19008C179S19008C209S19008C14__A17__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C10__9S19008C179S19008C209S19008C14__A1__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C16__A__9S19008C209S19008C14__9S19008C12[4]),  4,5},
  {&(_tg__ZTV9S19008C17__9S19008C209S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__9S19008C209S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C17__A__9S19008C209S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__A1__9S19008C209S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C21__9S19008C209S19008C14__9S19008C12[11]),  11,17},
  {&(_tg__ZTV9S19008C16__A1__9S19008C209S19008C14__9S19008C12[5]),  5,6},
  {&(_tg__ZTV9S19008C22__9S19008C209S19008C14__9S19008C12[3]),  3,5},
  {&(_tg__ZTV9S19008C179S19008C14__A2__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C179S19008C14__A19__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C179S19008C14__A6__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C109S19008C179S19008C14__A20__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C10__9S19008C179S19008C14__A2__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C17__9S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__9S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C59S19008C15__9S19008C14__9S19008C12[3]),  3,4},
  {&(_tg__ZTV9S19008C189S19008C15__9S19008C14__9S19008C12[5]),  5,9},
  {&(_tg__ZTV8S19008C69S19008C189S19008C15__A4__9S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C3__9S19008C14__9S19008C12[8]),  8,13},
  {&(_tg__ZTV9S19008C10__A2__9S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C68S19008C3__A7__9S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C19__9S19008C14__9S19008C12[8]),  8,13},
  {&(_tg__ZTV8S19008C68S19008C39S19008C19__A9__9S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C19__A10__9S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C15__A1__9S19008C14__9S19008C12[12]),  12,15},
  {&(_tg__ZTV8S19008C59S19008C15__A3__9S19008C14__9S19008C12[3]),  3,4},
  {&(_tg__ZTV9S19008C189S19008C15__A1__9S19008C14__9S19008C12[5]),  5,9},
  {&(_tg__ZTV8S19008C69S19008C189S19008C15__A13__9S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C20__9S19008C14__9S19008C12[8]),  8,12},
  {&(_tg__ZTV9S19008C169S19008C20__A2__9S19008C14__9S19008C12[4]),  4,5},
  {&(_tg__ZTV9S19008C179S19008C20__A1__9S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C179S19008C20__A4__9S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C21__9S19008C14__9S19008C12[11]),  11,17},
  {&(_tg__ZTV9S19008C16__A3__9S19008C14__9S19008C12[5]),  5,6},
  {&(_tg__ZTV9S19008C22__9S19008C14__9S19008C12[3]),  3,5},
  {&(_tg__ZTV9S19008C17__A__9S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__A6__9S19008C14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C17__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C17__A4__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__A1__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C109S19008C17__A5__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C10__9S19008C17__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C15__A1__9S19008C12[7]),  7,10},
  {&(_tg__ZTV9S19008C169S19008C15__A1__9S19008C12[4]),  4,5},
  {&(_tg__ZTV9S19008C17__9S19008C169S19008C15__A1__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__9S19008C169S19008C15__A1__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C59S19008C15__A4__9S19008C12[3]),  3,4},
  {&(_tg__ZTV8S19008C68S19008C59S19008C15__A12__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C189S19008C15__A1__9S19008C12[5]),  5,9},
  {&(_tg__ZTV9S19008C109S19008C189S19008C15__A3__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C109S19008C189S19008C15__A13__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C189S19008C15__A14__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C6__A1__9S19008C189S19008C15__A1__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C3__9S19008C189S19008C15__A1__9S19008C12[8]),  8,13},
  {&(_tg__ZTV9S19008C10__A1__9S19008C189S19008C15__A1__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C68S19008C3__A4__9S19008C189S19008C15__A1__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C17__9S19008C15__A1__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__9S19008C15__A1__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C5__9S19008C15__A1__9S19008C12[3]),  3,4},
  {&(_tg__ZTV9S19008C18__9S19008C15__A1__9S19008C12[5]),  5,9},
  {&(_tg__ZTV8S19008C69S19008C18__A4__9S19008C15__A1__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C3__9S19008C15__A1__9S19008C12[8]),  8,13},
  {&(_tg__ZTV9S19008C10__A2__9S19008C15__A1__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C68S19008C3__A7__9S19008C15__A1__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C21__9S19008C12[6]),  6,12},
  {&(_tg__ZTV9S19008C109S19008C21__A5__9S19008C12[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C109S19008C21__A18__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C17__9S19008C21__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__9S19008C21__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C16__9S19008C21__9S19008C12[5]),  5,6},
  {&(_tg__ZTV9S19008C22__9S19008C21__9S19008C12[3]),  3,5},
  {&(_tg__ZTV9S19008C16__A3__9S19008C12[4]),  4,5},
  {&(_tg__ZTV9S19008C17__9S19008C16__A3__9S19008C12[3]),  3,3},
  {&(_tg__ZTV9S19008C109S19008C17__9S19008C16__A3__9S19008C12[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S19008C12[];
extern  VTBL_ENTRY _ZTV9S19008C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C12[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19008C21D0Ev,_ZTv0_n12_N9S19008C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1384_N9S19008C21D0Ev,_ZThn916_N9S19008C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19008C21D1Ev,_ZTv0_n12_N9S19008C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1384_N9S19008C21D1Ev,_ZThn916_N9S19008C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19008C14D0Ev,_ZTv0_n12_N9S19008C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12376_N9S19008C14D0Ev,_ZThn8344_N9S19008C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19008C14D1Ev,_ZTv0_n12_N9S19008C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12376_N9S19008C14D1Ev,_ZThn8344_N9S19008C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19008C14D0Ev,_ZTv0_n28_N9S19008C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10992_N9S19008C14D0Ev,_ZThn7428_N9S19008C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19008C14D1Ev,_ZTv0_n28_N9S19008C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10992_N9S19008C14D1Ev,_ZThn7428_N9S19008C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S19008C14D0Ev,_ZTv0_n36_N9S19008C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9328_N9S19008C14D0Ev,_ZThn6320_N9S19008C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S19008C14D1Ev,_ZTv0_n36_N9S19008C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9328_N9S19008C14D1Ev,_ZThn6320_N9S19008C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19008C20D0Ev,_ZTv0_n12_N9S19008C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7576_N9S19008C20D0Ev,_ZThn5128_N9S19008C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19008C20D1Ev,_ZTv0_n12_N9S19008C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7576_N9S19008C20D1Ev,_ZThn5128_N9S19008C20D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19008C20D0Ev,_ZTv0_n28_N9S19008C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6192_N9S19008C20D0Ev,_ZThn4212_N9S19008C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19008C20D1Ev,_ZTv0_n28_N9S19008C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6192_N9S19008C20D1Ev,_ZThn4212_N9S19008C20D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S19008C19D0Ev,_ZTv0_n36_N9S19008C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7664_N9S19008C19D0Ev,_ZThn5212_N9S19008C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S19008C19D1Ev,_ZTv0_n36_N9S19008C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7664_N9S19008C19D1Ev,_ZThn5212_N9S19008C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19008C12D0Ev,_ZTv0_n12_N9S19008C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14504_N9S19008C12D0Ev,_ZThn9772_N9S19008C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19008C12D1Ev,_ZTv0_n12_N9S19008C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14504_N9S19008C12D1Ev,_ZThn9772_N9S19008C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19008C12D0Ev,_ZTv0_n28_N9S19008C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn13120_N9S19008C12D0Ev,_ZThn8856_N9S19008C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19008C12D1Ev,_ZTv0_n28_N9S19008C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn13120_N9S19008C12D1Ev,_ZThn8856_N9S19008C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S19008C12D0Ev,_ZTv0_n36_N9S19008C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11456_N9S19008C12D0Ev,_ZThn7748_N9S19008C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S19008C12D1Ev,_ZTv0_n36_N9S19008C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11456_N9S19008C12D1Ev,_ZThn7748_N9S19008C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n104_N9S19008C12D0Ev,_ZTv0_n52_N9S19008C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2128_N9S19008C12D0Ev,_ZThn1428_N9S19008C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n104_N9S19008C12D1Ev,_ZTv0_n52_N9S19008C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2128_N9S19008C12D1Ev,_ZThn1428_N9S19008C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19008C12D0Ev,_ZTv0_n24_N9S19008C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn736_N9S19008C12D0Ev,_ZThn516_N9S19008C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19008C12D1Ev,_ZTv0_n24_N9S19008C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn736_N9S19008C12D1Ev,_ZThn516_N9S19008C12D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19008C12 = {  "S19008C12", // class name
  bases_S19008C12, 94,
  &(vtc_S19008C12[0]), // expected_vtbl_contents
  &(vtt_S19008C12[0]), // expected_vtt_contents
  ABISELECT(16160,10852), // object size
  NSPAIRA(_ZTI9S19008C12),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S19008C12),198, //virtual function table var
  13, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19008C12),164, //virtual table table var
  53, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19008C2  : S19008C3 {
  void *s19008c2f0;
  char s19008c2f1[2];
  int s19008c2f2;
  void *s19008c2f3;
  void *s19008c2f4;
  int s19008c2f5:32;
  ::S19008C12 s19008c2f6;
  virtual  ~S19008C2(); // _ZN8S19008C2D2Ev
  virtual void  v4(); // _ZN8S19008C22v4Ev
  S19008C2(); // tgen
};
//SIG(-1 S19008C2) C1{ BC2{ BC3{ m Fi} BC4{ BC5{ VBC3 Fp FL Fi Fp Fi FU6{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC3 FC7{ BC3 Fi FU8{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC7 v2 Fi FL Fi FL FC3 Fi Fs Fi} BC7 VBC9{ VBC3 BC5 BC7 FL FU8 Fp Fp FC10{} Fi Fi Fp Fc FC10} BC5 vd v3 v4 FU8 FD Fc Fp FL FC7 Fi Fp[10] Fi FC9 Fi} vd v1 Fp Fc[2] Fi Fp Fp Fi:32 FC11{ VBC12{ m Fi Fi:20 FC4 Fi Fc[4] Fi Fi Fi Fi Fi Fi Fi} BC4 VBC2 VBC13{ BC14{ VBC12 BC15{ VBC16{ VBC3 BC5 BC9 FC4 Fi[6] Fi FC3[7] Fi Fp[2]} v7 Fp[7] Fi Fs FD Fi FC4 Fi} BC4 BC17{ BC9 BC7 BC5 VBC2 vd v8 v9 Fs Fs FC7[5] FL FD FL Fi Fi Fp} vd Fi Fi Fp FD[6] Fi Fi FD Fi Fi Fi} BC18{ BC2 BC5 BC12 VBC14 vd Fi FL FU6 Fi Fi FC10 FC2} BC19{ VBC12 BC4 BC15 BC16 VBC20{ VBC16 BC9 VBC15 VBC21{ vd m Fi Fi:1 Fi Fi Fi:9 Fi Fi Fi[8] Fs} BC7 vd v10 v11 v12 v13 FD FC3 Fi Fp[4] Fi[5] FC4 FC5 Fc} v14 Fi Fp[2] Fc FC9[2] FC21 FC4} BC16 v15 v16 v17 FL Fp} VBC22{ v18 Fp Fi Fi FC3 Fp FD Fi FC2 Fp[8] Fp[6]} vd v5 v6 Fl Fi:19 Fi[6] Fi FC7}}


 S19008C2 ::~S19008C2(){ note_dtor("S19008C2", this);}
void  S19008C2 ::v4(){vfunc_called(this, "_ZN8S19008C22v4Ev");}
S19008C2 ::S19008C2(){ note_ctor("S19008C2", this);} // tgen

static void Test_S19008C2()
{
  extern Class_Descriptor cd_S19008C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1101,2949)];
    init_test(&cd_S19008C2, buf);
    S19008C2 *dp, &lv = *(dp=new (buf) S19008C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(17600,11792), "sizeof(S19008C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19008C2)");
    /*is_ambiguous_... S19008C3::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C3*), ABISELECT(288,204), "S19008C2");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C5*)(S19008C3*), ABISELECT(17264,11576), "S19008C2");
    /*is_ambiguous_... S19008C10::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*), ABISELECT(17264,11576), "S19008C2");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*), ABISELECT(17264,11576), "S19008C2");
    /*is_ambiguous_... S19008C3::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C3*), ABISELECT(17264,11576), "S19008C2");
    check_base_class_offset(lv, (S19008C6*)(S19008C5*)(S19008C3*), 0, "S19008C2");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C5*)(S19008C3*), ABISELECT(208,144), "S19008C2");
    check_base_class_offset(lv, (S19008C8*)(S19008C5*)(S19008C3*), ABISELECT(208,144), "S19008C2");
    check_base_class_offset(lv, (S19008C5*)(S19008C3*), 0, "S19008C2");
    /*is_ambiguous_... S19008C3::S19008C8 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C3*), ABISELECT(304,208), "S19008C2");
    /*is_ambiguous_... S19008C3::S19008C8 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C3*), ABISELECT(304,208), "S19008C2");
    check_base_class_offset(lv, (S19008C6*)(S19008C10*), ABISELECT(17280,11580), "S19008C2");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*), ABISELECT(17488,11724), "S19008C2");
    check_base_class_offset(lv, (S19008C8*)(S19008C10*), ABISELECT(17488,11724), "S19008C2");
    check_base_class_offset(lv, (S19008C10*)(S19008C3*), ABISELECT(17280,11580), "S19008C2");
    /*is_ambiguous_... S19008C3::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C3*), ABISELECT(336,228), "S19008C2");
    check_base_class_offset(lv, (S19008C3*), 0, "S19008C2");
    check_field_offset(lv, s19008c2f0, ABISELECT(1064,700), "S19008C2.s19008c2f0");
    check_field_offset(lv, s19008c2f1, ABISELECT(1072,704), "S19008C2.s19008c2f1");
    check_field_offset(lv, s19008c2f2, ABISELECT(1076,708), "S19008C2.s19008c2f2");
    check_field_offset(lv, s19008c2f3, ABISELECT(1080,712), "S19008C2.s19008c2f3");
    check_field_offset(lv, s19008c2f4, ABISELECT(1088,716), "S19008C2.s19008c2f4");
    set_bf_and_test(lv, s19008c2f5, ABISELECT(1096,720), 0, 32, 1, "S19008C2");
    set_bf_and_test(lv, s19008c2f5, ABISELECT(1096,720), 0, 32, hide_sll(1LL<<31), "S19008C2");
    check_field_offset(lv, s19008c2f6, ABISELECT(1104,724), "S19008C2.s19008c2f6");
    test_class_info(&lv, &cd_S19008C2);
    dp->~S19008C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19008C2(Test_S19008C2, "S19008C2", ABISELECT(17600,11792));

#else // __cplusplus

extern void _ZN8S19008C2C1Ev();
extern void _ZN8S19008C2D2Ev();
Name_Map name_map_S19008C2[] = {
  NSPAIR(_ZN8S19008C2C1Ev),
  NSPAIR(_ZN8S19008C2D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C5;
extern VTBL_ENTRY _ZTI8S19008C5[];
extern  VTBL_ENTRY _ZTV8S19008C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C3;
extern VTBL_ENTRY _ZTI8S19008C3[];
extern  VTBL_ENTRY _ZTV8S19008C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C3[];
static Base_Class bases_S19008C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C4_nt,    ABISELECT(288,204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(17264,11576), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S19008C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19008C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(304,208), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(304,208), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(17280,11580), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(17488,11724), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(17488,11724), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19008C10,    ABISELECT(17280,11580), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S19008C6,    ABISELECT(336,228), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19008C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19008C2[];
extern void _ZN8S19008C52v1Ev();
extern void _ZN8S19008C2D1Ev();
extern void _ZN8S19008C2D0Ev();
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
extern void _ZN8S19008C22v4Ev();
static  VTBL_ENTRY vtc_S19008C2[] = {
  ABISELECT(17280,11580),
  ABISELECT(17264,11576),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C2[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&_ZN8S19008C2D1Ev,
  (VTBL_ENTRY)&_ZN8S19008C2D0Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19008C22v4Ev,
  ABISELECT(16928,11348),
  ABISELECT(-336,-228),
  (VTBL_ENTRY)&(_ZTI8S19008C2[0]),
  ABISELECT(-16,-4),
  ABISELECT(-17280,-11580),
  (VTBL_ENTRY)&(_ZTI8S19008C2[0]),
};
extern VTBL_ENTRY _ZTV8S19008C2[];
extern void _ZN8S19008C52v1Ev();
extern void _ZN8S19008C3D1Ev();
extern void _ZN8S19008C3D0Ev();
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C3__8S19008C2[] = {
  ABISELECT(17280,11580),
  ABISELECT(17264,11576),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&_ZN8S19008C3D1Ev,
  (VTBL_ENTRY)&_ZN8S19008C3D0Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
};
extern void _ZN8S19008C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C58S19008C3__8S19008C2[] = {
  ABISELECT(17264,11576),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C5[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C58S19008C3__8S19008C2[] = {
  ABISELECT(17264,11576),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C3__A2__8S19008C2[] = {
  ABISELECT(16928,11348),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__8S19008C3__8S19008C2[] = {
  ABISELECT(-16,-4),
  ABISELECT(-17280,-11580),
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C6__A2__8S19008C3__8S19008C2[] = {
  ABISELECT(16928,11348),
  ABISELECT(-336,-228),
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__8S19008C2[] = {
  ABISELECT(-16,-4),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C10__A1__8S19008C2[] = {
  ABISELECT(-16,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTT_ENTRY vtt_S19008C2[] = {
  {&(_ZTV8S19008C2[4]),  4,16},
  {&(_tg__ZTV8S19008C3__8S19008C2[4]),  4,9},
  {&(_tg__ZTV8S19008C58S19008C3__8S19008C2[3]),  3,4},
  {&(_tg__ZTV8S19008C68S19008C58S19008C3__8S19008C2[3]),  3,3},
  {&(_tg__ZTV8S19008C68S19008C3__A2__8S19008C2[3]),  3,3},
  {&(_tg__ZTV9S19008C10__8S19008C3__8S19008C2[3]),  3,3},
  {&(_tg__ZTV8S19008C6__A2__8S19008C3__8S19008C2[3]),  3,3},
  {&(_ZTV8S19008C2[16]),  16,16},
  {&(_ZTV8S19008C2[13]),  13,16},
  {&(_tg__ZTV9S19008C10__8S19008C2[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C10__A1__8S19008C2[3]),  3,3},
};
extern VTBL_ENTRY _ZTI8S19008C2[];
extern  VTBL_ENTRY _ZTV8S19008C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C2[];
Class_Descriptor cd_S19008C2 = {  "S19008C2", // class name
  bases_S19008C2, 14,
  &(vtc_S19008C2[0]), // expected_vtbl_contents
  &(vtt_S19008C2[0]), // expected_vtt_contents
  ABISELECT(17600,11792), // object size
  NSPAIRA(_ZTI8S19008C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S19008C2),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19008C2),11, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19008C24  : virtual S19008C22 {
  ::S19008C23 s19008c24f0;
  long double s19008c24f1;
  int s19008c24f2;
  virtual  ~S19008C24(); // _ZN9S19008C24D2Ev
  virtual void  v5(); // _ZN9S19008C242v5Ev
  S19008C24(); // tgen
};
//SIG(-1 S19008C24) C1{ VBC2{ vd m Fi Fi:1 Fi[2] Fi:9 Fi[10] Fs} vd v1 FC3{ v2 Fp Fi[2] FC4{ m Fi} Fp FD Fi FC5{ BC4 BC6{ BC7{ VBC4 Fp FL Fi Fp Fi FU8{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC4 FC9{ BC4 Fi FU10{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC9 v5 Fi FL Fi FL FC4 Fi Fs Fi} BC9 VBC11{ VBC4 BC7 BC9 FL FU10 Fp Fp FC12{} Fi Fi Fp Fc FC12} BC7 vd v3 v4 FU10 FD Fc Fp FL FC9 Fi Fp[10] Fi FC11 Fi} Fp[8] Fp[6]} FD Fi}


 S19008C24 ::~S19008C24(){ note_dtor("S19008C24", this);}
void  S19008C24 ::v5(){vfunc_called(this, "_ZN9S19008C242v5Ev");}
S19008C24 ::S19008C24(){ note_ctor("S19008C24", this);} // tgen

static void Test_S19008C24()
{
  extern Class_Descriptor cd_S19008C24;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(107,276)];
    init_test(&cd_S19008C24, buf);
    S19008C24 *dp, &lv = *(dp=new (buf) S19008C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1696,1100), "sizeof(S19008C24)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19008C24)");
    check_base_class_offset(lv, (S19008C22*), ABISELECT(1624,1032), "S19008C24");
    check_field_offset(lv, s19008c24f0, ABISELECT(16,4), "S19008C24.s19008c24f0");
    check_field_offset(lv, s19008c24f1, ABISELECT(1600,1016), "S19008C24.s19008c24f1");
    check_field_offset(lv, s19008c24f2, ABISELECT(1616,1028), "S19008C24.s19008c24f2");
    test_class_info(&lv, &cd_S19008C24);
    dp->~S19008C24();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19008C24(Test_S19008C24, "S19008C24", ABISELECT(1696,1100));

#else // __cplusplus

extern void _ZN9S19008C24C1Ev();
extern void _ZN9S19008C24D2Ev();
Name_Map name_map_S19008C24[] = {
  NSPAIR(_ZN9S19008C24C1Ev),
  NSPAIR(_ZN9S19008C24D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C22;
extern VTBL_ENTRY _ZTI9S19008C22[];
extern  VTBL_ENTRY _ZTV9S19008C22[];
static Base_Class bases_S19008C24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C22,    ABISELECT(1624,1032), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19008C24[];
extern void _ZN9S19008C24D1Ev();
extern void _ZN9S19008C24D0Ev();
extern void _ZN9S19008C242v5Ev();
extern void ABISELECT(_ZTv0_n24_N9S19008C24D1Ev,_ZTv0_n12_N9S19008C24D1Ev)();
extern void ABISELECT(_ZThn1624_N9S19008C24D1Ev,_ZThn1032_N9S19008C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19008C24D0Ev,_ZTv0_n12_N9S19008C24D0Ev)();
extern void ABISELECT(_ZThn1624_N9S19008C24D0Ev,_ZThn1032_N9S19008C24D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19008C24[] = {
  ABISELECT(1624,1032),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C24[0]),
  (VTBL_ENTRY)&_ZN9S19008C24D1Ev,
  (VTBL_ENTRY)&_ZN9S19008C24D0Ev,
  (VTBL_ENTRY)&_ZN9S19008C242v5Ev,
  ABISELECT(-1624,-1032),
  ABISELECT(-1624,-1032),
  (VTBL_ENTRY)&(_ZTI9S19008C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19008C24D1Ev,_ZTv0_n12_N9S19008C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19008C24D0Ev,_ZTv0_n12_N9S19008C24D0Ev),
};
extern VTBL_ENTRY _ZTV9S19008C24[];
static  VTT_ENTRY vtt_S19008C24[] = {
  {&(_ZTV9S19008C24[3]),  3,11},
  {&(_ZTV9S19008C24[9]),  9,11},
};
extern VTBL_ENTRY _ZTI9S19008C24[];
extern  VTBL_ENTRY _ZTV9S19008C24[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C24[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19008C24D0Ev,_ZTv0_n12_N9S19008C24D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1624_N9S19008C24D0Ev,_ZThn1032_N9S19008C24D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19008C24D1Ev,_ZTv0_n12_N9S19008C24D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1624_N9S19008C24D1Ev,_ZThn1032_N9S19008C24D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19008C24 = {  "S19008C24", // class name
  bases_S19008C24, 1,
  &(vtc_S19008C24[0]), // expected_vtbl_contents
  &(vtt_S19008C24[0]), // expected_vtt_contents
  ABISELECT(1696,1100), // object size
  NSPAIRA(_ZTI9S19008C24),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV9S19008C24),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19008C24),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S19008C25  {
  char s19008c25f0;
  long double s19008c25f1;
  void  mf19008c25(); // _ZN9S19008C2510mf19008c25Ev
};
//SIG(1 S19008C25) U1{ m Fc FD}

#endif // __cplusplus
#ifdef __cplusplus

struct  S19008C1  : virtual S19008C2 , virtual S19008C24 {
  ::S19008C25 s19008c1f0;
  long s19008c1f1;
  void *s19008c1f2;
  char s19008c1f3;
  void *s19008c1f4;
  void *s19008c1f5;
  int s19008c1f6;
  ~S19008C1(); // tgen
  S19008C1(); // tgen
};
//SIG(1 S19008C1) C1{ VBC2{ BC3{ BC4{ m Fi} BC5{ BC6{ VBC4 Fp FL Fi Fp Fi FU7{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC4 FC8{ BC4 Fi FU9{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC8 v1 Fi FL Fi FL FC4 Fi Fs Fi} BC8 VBC10{ VBC4 BC6 BC8 FL FU9 Fp Fp FC11{} Fi Fi Fp Fc FC11} BC6 vd v2 v3 FU9 FD Fc Fp FL FC8 Fi Fp[10] Fi FC10 Fi} vd v4 Fp Fc[2] Fi Fp Fp Fi:32 FC12{ VBC13{ m Fi Fi:20 FC5 Fi Fc[4] Fi Fi Fi Fi Fi Fi Fi} BC5 VBC3 VBC14{ BC15{ VBC13 BC16{ VBC17{ VBC4 BC6 BC10 FC5 Fi[6] Fi FC4[7] Fi Fp[2]} v8 Fp[7] Fi Fs FD Fi FC5 Fi} BC5 BC18{ BC10 BC8 BC6 VBC3 vd v9 v10 Fs Fs FC8[5] FL FD FL Fi Fi Fp} vd Fi Fi Fp FD[6] Fi Fi FD Fi Fi Fi} BC19{ BC3 BC6 BC13 VBC15 vd Fi FL FU7 Fi Fi FC11 FC3} BC20{ VBC13 BC5 BC16 BC17 VBC21{ VBC17 BC10 VBC16 VBC22{ vd m Fi Fi:1 Fi Fi Fi:9 Fi Fi Fi[8] Fs} BC8 vd v11 v12 v13 v14 FD FC4 Fi Fp[4] Fi[5] FC5 FC6 Fc} v15 Fi Fp[2] Fc FC10[2] FC22 FC5} BC17 v16 v17 v18 FL Fp} VBC23{ v19 Fp Fi Fi FC4 Fp FD Fi FC3 Fp[8] Fp[6]} vd v6 v7 Fl Fi:19 Fi[6] Fi FC8}} VBC24{ VBC22 vd v5 FC23 FD Fi} FU25{ m Fc FD} Fl Fp Fc Fp Fp Fi}


S19008C1 ::~S19008C1(){ note_dtor("S19008C1", this);} // tgen
S19008C1 ::S19008C1(){ note_ctor("S19008C1", this);} // tgen

static void Test_S19008C1()
{
  extern Class_Descriptor cd_S19008C1;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1212,3234)];
    init_test(&cd_S19008C1, buf);
    S19008C1 *dp, &lv = *(dp=new (buf) S19008C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(19376,12932), "sizeof(S19008C1)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19008C1)");
    /*is_ambiguous_... S19008C3::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C3*)(S19008C2*), ABISELECT(368,244), "S19008C1");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C5*)(S19008C3*)(S19008C2*), ABISELECT(17344,11616), "S19008C1");
    /*is_ambiguous_... S19008C10::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C10*), ABISELECT(17344,11616), "S19008C1");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C10*), ABISELECT(17344,11616), "S19008C1");
    /*is_ambiguous_... S19008C3::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C6*)(S19008C3*)(S19008C2*), ABISELECT(17344,11616), "S19008C1");
    check_base_class_offset(lv, (S19008C6*)(S19008C5*)(S19008C3*)(S19008C2*), ABISELECT(80,40), "S19008C1");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C5*)(S19008C3*)(S19008C2*), ABISELECT(288,184), "S19008C1");
    check_base_class_offset(lv, (S19008C8*)(S19008C5*)(S19008C3*)(S19008C2*), ABISELECT(288,184), "S19008C1");
    check_base_class_offset(lv, (S19008C5*)(S19008C3*)(S19008C2*), ABISELECT(80,40), "S19008C1");
    /*is_ambiguous_... S19008C3::S19008C8 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C3*)(S19008C2*), ABISELECT(384,248), "S19008C1");
    /*is_ambiguous_... S19008C3::S19008C8 */ AMB_check_base_class_offset(lv, (S19008C8*)(S19008C3*)(S19008C2*), ABISELECT(384,248), "S19008C1");
    check_base_class_offset(lv, (S19008C6*)(S19008C10*), ABISELECT(17360,11620), "S19008C1");
    check_base_class_offset(lv, (S19008C4_nt*)(S19008C8*)(S19008C10*), ABISELECT(17568,11764), "S19008C1");
    check_base_class_offset(lv, (S19008C8*)(S19008C10*), ABISELECT(17568,11764), "S19008C1");
    check_base_class_offset(lv, (S19008C10*)(S19008C3*)(S19008C2*), ABISELECT(17360,11620), "S19008C1");
    /*is_ambiguous_... S19008C3::S19008C6 */ AMB_check_base_class_offset(lv, (S19008C6*)(S19008C3*)(S19008C2*), ABISELECT(416,268), "S19008C1");
    check_base_class_offset(lv, (S19008C3*)(S19008C2*), ABISELECT(80,40), "S19008C1");
    check_base_class_offset(lv, (S19008C2*), ABISELECT(80,40), "S19008C1");
    check_base_class_offset(lv, (S19008C22*)(S19008C24*), ABISELECT(19304,12864), "S19008C1");
    check_base_class_offset(lv, (S19008C24*), ABISELECT(17680,11832), "S19008C1");
    check_field_offset(lv, s19008c1f0, ABISELECT(16,4), "S19008C1.s19008c1f0");
    check_field_offset(lv, s19008c1f1, ABISELECT(32,16), "S19008C1.s19008c1f1");
    check_field_offset(lv, s19008c1f2, ABISELECT(40,20), "S19008C1.s19008c1f2");
    check_field_offset(lv, s19008c1f3, ABISELECT(48,24), "S19008C1.s19008c1f3");
    check_field_offset(lv, s19008c1f4, ABISELECT(56,28), "S19008C1.s19008c1f4");
    check_field_offset(lv, s19008c1f5, ABISELECT(64,32), "S19008C1.s19008c1f5");
    check_field_offset(lv, s19008c1f6, ABISELECT(72,36), "S19008C1.s19008c1f6");
    test_class_info(&lv, &cd_S19008C1);
    dp->~S19008C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19008C1(Test_S19008C1, "S19008C1", ABISELECT(19376,12932));

#else // __cplusplus

extern void _ZN8S19008C1C1Ev();
extern void _ZN8S19008C1D1Ev();
Name_Map name_map_S19008C1[] = {
  NSPAIR(_ZN8S19008C1C1Ev),
  NSPAIR(_ZN8S19008C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C5;
extern VTBL_ENTRY _ZTI8S19008C5[];
extern  VTBL_ENTRY _ZTV8S19008C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C8;
extern VTBL_ENTRY _ZTI8S19008C8[];
extern Class_Descriptor cd_S19008C10;
extern VTBL_ENTRY _ZTI9S19008C10[];
extern  VTBL_ENTRY _ZTV9S19008C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C10[];
extern Class_Descriptor cd_S19008C6;
extern VTBL_ENTRY _ZTI8S19008C6[];
extern  VTBL_ENTRY _ZTV8S19008C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C6[];
extern Class_Descriptor cd_S19008C3;
extern VTBL_ENTRY _ZTI8S19008C3[];
extern  VTBL_ENTRY _ZTV8S19008C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C3[];
extern Class_Descriptor cd_S19008C2;
extern VTBL_ENTRY _ZTI8S19008C2[];
extern  VTBL_ENTRY _ZTV8S19008C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C2[];
extern Class_Descriptor cd_S19008C22;
extern VTBL_ENTRY _ZTI9S19008C22[];
extern  VTBL_ENTRY _ZTV9S19008C22[];
extern Class_Descriptor cd_S19008C24;
extern VTBL_ENTRY _ZTI9S19008C24[];
extern  VTBL_ENTRY _ZTV9S19008C24[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19008C24[];
static Base_Class bases_S19008C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C4_nt,    ABISELECT(368,244), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(17344,11616), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S19008C6,    ABISELECT(80,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(288,184), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(288,184), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19008C5,    ABISELECT(80,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(384,248), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(384,248), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19008C6,    ABISELECT(17360,11620), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(17568,11764), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19008C8,    ABISELECT(17568,11764), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19008C10,    ABISELECT(17360,11620), //bcp->offset
    27, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S19008C6,    ABISELECT(416,268), //bcp->offset
    24, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19008C3,    ABISELECT(80,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19008C2,    ABISELECT(80,40), //bcp->offset
    9, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19008C22,    ABISELECT(19304,12864), //bcp->offset
    38, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S19008C24,    ABISELECT(17680,11832), //bcp->offset
    30, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S19008C1[];
extern void _ZN8S19008C1D1Ev();
extern void _ZN8S19008C1D0Ev();
extern void _ZN8S19008C52v1Ev();
extern void ABISELECT(_ZTv0_n48_N8S19008C1D1Ev,_ZTv0_n24_N8S19008C1D1Ev)();
extern void ABISELECT(_ZThn80_N8S19008C1D1Ev,_ZThn40_N8S19008C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19008C1D0Ev,_ZTv0_n24_N8S19008C1D0Ev)();
extern void ABISELECT(_ZThn80_N8S19008C1D0Ev,_ZThn40_N8S19008C1D0Ev)() __attribute__((weak));
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
extern void _ZN8S19008C22v4Ev();
extern void ABISELECT(_ZTv0_n32_N8S19008C1D1Ev,_ZTv0_n16_N8S19008C1D1Ev)();
extern void ABISELECT(_ZThn17680_N8S19008C1D1Ev,_ZThn11832_N8S19008C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19008C1D0Ev,_ZTv0_n16_N8S19008C1D0Ev)();
extern void ABISELECT(_ZThn17680_N8S19008C1D0Ev,_ZThn11832_N8S19008C1D0Ev)() __attribute__((weak));
extern void _ZN9S19008C242v5Ev();
extern void ABISELECT(_ZTv0_n24_N8S19008C1D1Ev,_ZTv0_n12_N8S19008C1D1Ev)();
extern void ABISELECT(_ZThn19304_N8S19008C1D1Ev,_ZThn12864_N8S19008C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19008C1D0Ev,_ZTv0_n12_N8S19008C1D0Ev)();
extern void ABISELECT(_ZThn19304_N8S19008C1D0Ev,_ZThn12864_N8S19008C1D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19008C1[] = {
  ABISELECT(19304,12864),
  ABISELECT(17680,11832),
  ABISELECT(17360,11620),
  ABISELECT(17344,11616),
  ABISELECT(80,40),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C1[0]),
  (VTBL_ENTRY)&_ZN8S19008C1D1Ev,
  (VTBL_ENTRY)&_ZN8S19008C1D0Ev,
  0,
  0,
  0,
  ABISELECT(-80,-40),
  0,
  ABISELECT(17280,11580),
  ABISELECT(17264,11576),
  ABISELECT(-80,-40),
  (VTBL_ENTRY)&(_ZTI8S19008C1[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19008C1D1Ev,_ZTv0_n24_N8S19008C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19008C1D0Ev,_ZTv0_n24_N8S19008C1D0Ev),
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19008C22v4Ev,
  ABISELECT(16928,11348),
  ABISELECT(-416,-268),
  (VTBL_ENTRY)&(_ZTI8S19008C1[0]),
  ABISELECT(-16,-4),
  ABISELECT(-17360,-11620),
  (VTBL_ENTRY)&(_ZTI8S19008C1[0]),
  0,
  ABISELECT(-17680,-11832),
  ABISELECT(1624,1032),
  ABISELECT(-17680,-11832),
  (VTBL_ENTRY)&(_ZTI8S19008C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19008C1D1Ev,_ZTv0_n16_N8S19008C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19008C1D0Ev,_ZTv0_n16_N8S19008C1D0Ev),
  (VTBL_ENTRY)&_ZN9S19008C242v5Ev,
  ABISELECT(-19304,-12864),
  ABISELECT(-19304,-12864),
  (VTBL_ENTRY)&(_ZTI8S19008C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19008C1D1Ev,_ZTv0_n12_N8S19008C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19008C1D0Ev,_ZTv0_n12_N8S19008C1D0Ev),
};
extern VTBL_ENTRY _ZTV8S19008C1[];
extern void _ZN8S19008C52v1Ev();
extern void _ZN8S19008C2D1Ev();
extern void _ZN8S19008C2D0Ev();
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
extern void _ZN8S19008C22v4Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C2__8S19008C1[] = {
  ABISELECT(17280,11580),
  ABISELECT(17264,11576),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C2[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&_ZN8S19008C2D1Ev,
  (VTBL_ENTRY)&_ZN8S19008C2D0Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19008C22v4Ev,
};
extern void _ZN8S19008C52v1Ev();
extern void _ZN8S19008C3D1Ev();
extern void _ZN8S19008C3D0Ev();
extern void _ZN8S19008C32v2Ev();
extern void _ZN8S19008C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C38S19008C2__8S19008C1[] = {
  ABISELECT(17280,11580),
  ABISELECT(17264,11576),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
  (VTBL_ENTRY)&_ZN8S19008C3D1Ev,
  (VTBL_ENTRY)&_ZN8S19008C3D0Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19008C32v3Ev,
};
extern void _ZN8S19008C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19008C58S19008C38S19008C2__8S19008C1[] = {
  ABISELECT(17264,11576),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C5[0]),
  (VTBL_ENTRY)&_ZN8S19008C52v1Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C58S19008C38S19008C2__8S19008C1[] = {
  ABISELECT(17264,11576),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C38S19008C2__A2__8S19008C1[] = {
  ABISELECT(16928,11348),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__8S19008C38S19008C2__8S19008C1[] = {
  ABISELECT(-16,-4),
  ABISELECT(-17280,-11580),
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C6__A2__8S19008C38S19008C2__8S19008C1[] = {
  ABISELECT(16928,11348),
  ABISELECT(-336,-228),
  (VTBL_ENTRY)&(_ZTI8S19008C3[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__8S19008C2__8S19008C1[] = {
  ABISELECT(-16,-4),
  ABISELECT(-17280,-11580),
  (VTBL_ENTRY)&(_ZTI8S19008C2[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C68S19008C3__A2__8S19008C2__8S19008C1[] = {
  ABISELECT(16928,11348),
  ABISELECT(-336,-228),
  (VTBL_ENTRY)&(_ZTI8S19008C2[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19008C10__8S19008C1[] = {
  ABISELECT(-16,-4),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19008C69S19008C10__A1__8S19008C1[] = {
  ABISELECT(-16,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S19008C6[0]),
};
extern void _ZN9S19008C24D1Ev();
extern void _ZN9S19008C24D0Ev();
extern void _ZN9S19008C242v5Ev();
static  VTBL_ENTRY _tg__ZTV9S19008C24__8S19008C1[] = {
  ABISELECT(1624,1032),
  0,
  (VTBL_ENTRY)&(_ZTI9S19008C24[0]),
  (VTBL_ENTRY)&_ZN9S19008C24D1Ev,
  (VTBL_ENTRY)&_ZN9S19008C24D0Ev,
  (VTBL_ENTRY)&_ZN9S19008C242v5Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19008C24D1Ev,_ZTv0_n12_N9S19008C24D1Ev)();
extern void ABISELECT(_ZThn1624_N9S19008C24D1Ev,_ZThn1032_N9S19008C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19008C24D0Ev,_ZTv0_n12_N9S19008C24D0Ev)();
extern void ABISELECT(_ZThn1624_N9S19008C24D0Ev,_ZThn1032_N9S19008C24D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19008C22__9S19008C24__8S19008C1[] = {
  ABISELECT(-1624,-1032),
  ABISELECT(-1624,-1032),
  (VTBL_ENTRY)&(_ZTI9S19008C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19008C24D1Ev,_ZTv0_n12_N9S19008C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19008C24D0Ev,_ZTv0_n12_N9S19008C24D0Ev),
};
static  VTT_ENTRY vtt_S19008C1[] = {
  {&(_ZTV8S19008C1[7]),  7,43},
  {&(_ZTV8S19008C1[18]),  18,43},
  {&(_ZTV8S19008C1[30]),  30,43},
  {&(_ZTV8S19008C1[27]),  27,43},
  {&(_ZTV8S19008C1[35]),  35,43},
  {&(_ZTV8S19008C1[41]),  41,43},
  {&(_tg__ZTV8S19008C2__8S19008C1[4]),  4,10},
  {&(_tg__ZTV8S19008C38S19008C2__8S19008C1[4]),  4,9},
  {&(_tg__ZTV8S19008C58S19008C38S19008C2__8S19008C1[3]),  3,4},
  {&(_tg__ZTV8S19008C68S19008C58S19008C38S19008C2__8S19008C1[3]),  3,3},
  {&(_tg__ZTV8S19008C68S19008C38S19008C2__A2__8S19008C1[3]),  3,3},
  {&(_tg__ZTV9S19008C10__8S19008C38S19008C2__8S19008C1[3]),  3,3},
  {&(_tg__ZTV8S19008C6__A2__8S19008C38S19008C2__8S19008C1[3]),  3,3},
  {&(_tg__ZTV9S19008C10__8S19008C2__8S19008C1[3]),  3,3},
  {&(_tg__ZTV8S19008C68S19008C3__A2__8S19008C2__8S19008C1[3]),  3,3},
  {&(_tg__ZTV9S19008C10__8S19008C1[3]),  3,3},
  {&(_tg__ZTV8S19008C69S19008C10__A1__8S19008C1[3]),  3,3},
  {&(_tg__ZTV9S19008C24__8S19008C1[3]),  3,6},
  {&(_tg__ZTV9S19008C22__9S19008C24__8S19008C1[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S19008C1[];
extern  VTBL_ENTRY _ZTV8S19008C1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19008C1[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19008C24D0Ev,_ZTv0_n12_N9S19008C24D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1624_N9S19008C24D0Ev,_ZThn1032_N9S19008C24D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19008C24D1Ev,_ZTv0_n12_N9S19008C24D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1624_N9S19008C24D1Ev,_ZThn1032_N9S19008C24D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19008C1D0Ev,_ZTv0_n12_N8S19008C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn19304_N8S19008C1D0Ev,_ZThn12864_N8S19008C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19008C1D1Ev,_ZTv0_n12_N8S19008C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn19304_N8S19008C1D1Ev,_ZThn12864_N8S19008C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19008C1D0Ev,_ZTv0_n16_N8S19008C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17680_N8S19008C1D0Ev,_ZThn11832_N8S19008C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19008C1D1Ev,_ZTv0_n16_N8S19008C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17680_N8S19008C1D1Ev,_ZThn11832_N8S19008C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19008C1D0Ev,_ZTv0_n24_N8S19008C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N8S19008C1D0Ev,_ZThn40_N8S19008C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19008C1D1Ev,_ZTv0_n24_N8S19008C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N8S19008C1D1Ev,_ZThn40_N8S19008C1D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19008C1 = {  "S19008C1", // class name
  bases_S19008C1, 17,
  &(vtc_S19008C1[0]), // expected_vtbl_contents
  &(vtt_S19008C1[0]), // expected_vtt_contents
  ABISELECT(19376,12932), // object size
  NSPAIRA(_ZTI8S19008C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S19008C1),43, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19008C1),19, //virtual table table var
  9, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19009C8  : S19008C4_nt {
  int s19009c8f0;
  ::S19008C9 s19009c8f1;
};
//SIG(-1 S19009C8) C1{ BC2{ m Fi} Fi FU3{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}}



static void Test_S19009C8()
{
  extern Class_Descriptor cd_S19009C8;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(3,6)];
    init_test(&cd_S19009C8, buf);
    S19009C8 &lv = *(new (buf) S19009C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S19009C8)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19009C8)");
    check_base_class_offset(lv, (S19008C4_nt*), 0, "S19009C8");
    check_field_offset(lv, s19009c8f0, 4, "S19009C8.s19009c8f0");
    check_field_offset(lv, s19009c8f1, ABISELECT(16,8), "S19009C8.s19009c8f1");
    test_class_info(&lv, &cd_S19009C8);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19009C8(Test_S19009C8, "S19009C8", ABISELECT(32,20));

#else // __cplusplus

extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
static Base_Class bases_S19009C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19009C8[];
Class_Descriptor cd_S19009C8 = {  "S19009C8", // class name
  bases_S19009C8, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI8S19009C8),ABISELECT(24,12), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19009C6  : virtual S19008C4_nt {
  void *s19009c6f0;
  __tsi64 s19009c6f1;
  int s19009c6f2;
  void *s19009c6f3;
  int s19009c6f4;
  ::S19008C7 s19009c6f5;
  char s19009c6f6;
  char s19009c6f7;
  long double s19009c6f8;
  ::S19008C4_nt s19009c6f9;
  ::S19009C8 s19009c6f10;
  void *s19009c6f11;
  ~S19009C6(); // tgen
  S19009C6(); // tgen
};
//SIG(-1 S19009C6) C1{ VBC2{ m Fi} Fp FL Fi Fp Fi FU3{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC2 FC4{ BC2 Fi FU5{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp}


S19009C6 ::~S19009C6(){ note_dtor("S19009C6", this);} // tgen
S19009C6 ::S19009C6(){ note_ctor("S19009C6", this);} // tgen

static void Test_S19009C6()
{
  extern Class_Descriptor cd_S19009C6;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(14,38)];
    init_test(&cd_S19009C6, buf);
    S19009C6 *dp, &lv = *(dp=new (buf) S19009C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,148), "sizeof(S19009C6)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19009C6)");
    check_base_class_offset(lv, (S19008C4_nt*), ABISELECT(200,144), "S19009C6");
    check_field_offset(lv, s19009c6f0, ABISELECT(8,4), "S19009C6.s19009c6f0");
    check_field_offset(lv, s19009c6f1, ABISELECT(16,8), "S19009C6.s19009c6f1");
    check_field_offset(lv, s19009c6f2, ABISELECT(24,16), "S19009C6.s19009c6f2");
    check_field_offset(lv, s19009c6f3, ABISELECT(32,20), "S19009C6.s19009c6f3");
    check_field_offset(lv, s19009c6f4, ABISELECT(40,24), "S19009C6.s19009c6f4");
    check_field_offset(lv, s19009c6f5, ABISELECT(48,28), "S19009C6.s19009c6f5");
    check_field_offset(lv, s19009c6f6, ABISELECT(120,100), "S19009C6.s19009c6f6");
    check_field_offset(lv, s19009c6f7, ABISELECT(121,101), "S19009C6.s19009c6f7");
    check_field_offset(lv, s19009c6f8, ABISELECT(128,104), "S19009C6.s19009c6f8");
    check_field_offset(lv, s19009c6f9, ABISELECT(144,116), "S19009C6.s19009c6f9");
    check_field_offset(lv, s19009c6f10, ABISELECT(160,120), "S19009C6.s19009c6f10");
    check_field_offset(lv, s19009c6f11, ABISELECT(192,140), "S19009C6.s19009c6f11");
    test_class_info(&lv, &cd_S19009C6);
    dp->~S19009C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19009C6(Test_S19009C6, "S19009C6", ABISELECT(208,148));

#else // __cplusplus

extern void _ZN8S19009C6C1Ev();
extern void _ZN8S19009C6D1Ev();
Name_Map name_map_S19009C6[] = {
  NSPAIR(_ZN8S19009C6C1Ev),
  NSPAIR(_ZN8S19009C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
static Base_Class bases_S19009C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C4_nt,    ABISELECT(200,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S19009C6[];
static  VTBL_ENTRY vtc_S19009C6[] = {
  ABISELECT(200,144),
  0,
  (VTBL_ENTRY)&(_ZTI8S19009C6[0]),
};
extern VTBL_ENTRY _ZTV8S19009C6[];
static  VTT_ENTRY vtt_S19009C6[] = {
  {&(_ZTV8S19009C6[3]),  3,3},
};
extern VTBL_ENTRY _ZTI8S19009C6[];
extern  VTBL_ENTRY _ZTV8S19009C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19009C6[];
Class_Descriptor cd_S19009C6 = {  "S19009C6", // class name
  bases_S19009C6, 1,
  &(vtc_S19009C6[0]), // expected_vtbl_contents
  &(vtt_S19009C6[0]), // expected_vtt_contents
  ABISELECT(208,148), // object size
  NSPAIRA(_ZTI8S19009C6),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S19009C6),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19009C6),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19009C5  : S19009C6 , S19009C8 {
  int s19009c5f0;
  __tsi64 s19009c5f1;
  int s19009c5f2;
  __tsi64 s19009c5f3;
  ::S19008C4_nt s19009c5f4;
  int s19009c5f5;
  short s19009c5f6;
  int s19009c5f7;
  virtual void  v1(); // _ZN8S19009C52v1Ev
  ~S19009C5(); // tgen
  S19009C5(); // tgen
};
//SIG(-1 S19009C5) C1{ BC2{ VBC3{ m Fi} Fp FL Fi Fp Fi FU4{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC3 FC5{ BC3 Fi FU6{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC5 v1 Fi FL Fi FL FC3 Fi Fs Fi}


void  S19009C5 ::v1(){vfunc_called(this, "_ZN8S19009C52v1Ev");}
S19009C5 ::~S19009C5(){ note_dtor("S19009C5", this);} // tgen
S19009C5 ::S19009C5(){ note_ctor("S19009C5", this);} // tgen

static void Test_S19009C5()
{
  extern Class_Descriptor cd_S19009C5;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(20,53)];
    init_test(&cd_S19009C5, buf);
    S19009C5 *dp, &lv = *(dp=new (buf) S19009C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,208), "sizeof(S19009C5)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19009C5)");
    check_base_class_offset(lv, (S19008C4_nt*)(S19009C6*), ABISELECT(288,204), "S19009C5");
    check_base_class_offset(lv, (S19009C6*), 0, "S19009C5");
    check_base_class_offset(lv, (S19008C4_nt*)(S19009C8*), ABISELECT(208,144), "S19009C5");
    check_base_class_offset(lv, (S19009C8*), ABISELECT(208,144), "S19009C5");
    check_field_offset(lv, s19009c5f0, ABISELECT(240,164), "S19009C5.s19009c5f0");
    check_field_offset(lv, s19009c5f1, ABISELECT(248,168), "S19009C5.s19009c5f1");
    check_field_offset(lv, s19009c5f2, ABISELECT(256,176), "S19009C5.s19009c5f2");
    check_field_offset(lv, s19009c5f3, ABISELECT(264,180), "S19009C5.s19009c5f3");
    check_field_offset(lv, s19009c5f4, ABISELECT(272,188), "S19009C5.s19009c5f4");
    check_field_offset(lv, s19009c5f5, ABISELECT(276,192), "S19009C5.s19009c5f5");
    check_field_offset(lv, s19009c5f6, ABISELECT(280,196), "S19009C5.s19009c5f6");
    check_field_offset(lv, s19009c5f7, ABISELECT(284,200), "S19009C5.s19009c5f7");
    test_class_info(&lv, &cd_S19009C5);
    dp->~S19009C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19009C5(Test_S19009C5, "S19009C5", ABISELECT(304,208));

#else // __cplusplus

extern void _ZN8S19009C5C1Ev();
extern void _ZN8S19009C5D1Ev();
Name_Map name_map_S19009C5[] = {
  NSPAIR(_ZN8S19009C5C1Ev),
  NSPAIR(_ZN8S19009C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19009C6;
extern VTBL_ENTRY _ZTI8S19009C6[];
extern  VTBL_ENTRY _ZTV8S19009C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19009C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19009C8;
extern VTBL_ENTRY _ZTI8S19009C8[];
static Base_Class bases_S19009C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C4_nt,    ABISELECT(288,204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S19009C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C4_nt,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19009C8,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19009C5[];
extern void _ZN8S19009C52v1Ev();
static  VTBL_ENTRY vtc_S19009C5[] = {
  ABISELECT(288,204),
  0,
  (VTBL_ENTRY)&(_ZTI8S19009C5[0]),
  (VTBL_ENTRY)&_ZN8S19009C52v1Ev,
};
extern VTBL_ENTRY _ZTV8S19009C5[];
static  VTBL_ENTRY _tg__ZTV8S19009C6__8S19009C5[] = {
  ABISELECT(288,204),
  0,
  (VTBL_ENTRY)&(_ZTI8S19009C6[0]),
};
static  VTT_ENTRY vtt_S19009C5[] = {
  {&(_ZTV8S19009C5[3]),  3,4},
  {&(_tg__ZTV8S19009C6__8S19009C5[3]),  3,3},
};
extern VTBL_ENTRY _ZTI8S19009C5[];
extern  VTBL_ENTRY _ZTV8S19009C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19009C5[];
Class_Descriptor cd_S19009C5 = {  "S19009C5", // class name
  bases_S19009C5, 4,
  &(vtc_S19009C5[0]), // expected_vtbl_contents
  &(vtt_S19009C5[0]), // expected_vtt_contents
  ABISELECT(304,208), // object size
  NSPAIRA(_ZTI8S19009C5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S19009C5),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19009C5),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19009C10  : virtual S19008C4_nt , S19009C6 , S19009C8 {
  __tsi64 s19009c10f0;
  ::S19008C9 s19009c10f1;
  void *s19009c10f2;
  void *s19009c10f3;
  ::S19008C11_nt s19009c10f4;
  int s19009c10f5;
  int s19009c10f6;
  void *s19009c10f7;
  char s19009c10f8;
  ::S19008C11_nt s19009c10f9;
  ~S19009C10(); // tgen
  S19009C10(); // tgen
};
//SIG(-1 S19009C10) C1{ VBC2{ m Fi} BC3{ VBC2 Fp FL Fi Fp Fi FU4{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC2 FC5{ BC2 Fi FU6{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC5 FL FU6 Fp Fp FC7{} Fi Fi Fp Fc FC7}


S19009C10 ::~S19009C10(){ note_dtor("S19009C10", this);} // tgen
S19009C10 ::S19009C10(){ note_ctor("S19009C10", this);} // tgen

static void Test_S19009C10()
{
  extern Class_Descriptor cd_S19009C10;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(21,55)];
    init_test(&cd_S19009C10, buf);
    S19009C10 *dp, &lv = *(dp=new (buf) S19009C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(320,216), "sizeof(S19009C10)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19009C10)");
    /*is_ambiguous_... S19009C10::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*), ABISELECT(316,212), "S19009C10");
    check_base_class_offset(lv, (S19008C4_nt*)(S19009C6*), ABISELECT(316,212), "S19009C10");
    check_base_class_offset(lv, (S19009C6*), 0, "S19009C10");
    check_base_class_offset(lv, (S19008C4_nt*)(S19009C8*), ABISELECT(208,144), "S19009C10");
    check_base_class_offset(lv, (S19009C8*), ABISELECT(208,144), "S19009C10");
    check_field_offset(lv, s19009c10f0, ABISELECT(240,164), "S19009C10.s19009c10f0");
    check_field_offset(lv, s19009c10f1, ABISELECT(256,172), "S19009C10.s19009c10f1");
    check_field_offset(lv, s19009c10f2, ABISELECT(272,184), "S19009C10.s19009c10f2");
    check_field_offset(lv, s19009c10f3, ABISELECT(280,188), "S19009C10.s19009c10f3");
    check_field_offset(lv, s19009c10f4, ABISELECT(288,192), "S19009C10.s19009c10f4");
    check_field_offset(lv, s19009c10f5, ABISELECT(292,196), "S19009C10.s19009c10f5");
    check_field_offset(lv, s19009c10f6, ABISELECT(296,200), "S19009C10.s19009c10f6");
    check_field_offset(lv, s19009c10f7, ABISELECT(304,204), "S19009C10.s19009c10f7");
    check_field_offset(lv, s19009c10f8, ABISELECT(312,208), "S19009C10.s19009c10f8");
    check_field_offset(lv, s19009c10f9, ABISELECT(313,209), "S19009C10.s19009c10f9");
    test_class_info(&lv, &cd_S19009C10);
    dp->~S19009C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19009C10(Test_S19009C10, "S19009C10", ABISELECT(320,216));

#else // __cplusplus

extern void _ZN9S19009C10C1Ev();
extern void _ZN9S19009C10D1Ev();
Name_Map name_map_S19009C10[] = {
  NSPAIR(_ZN9S19009C10C1Ev),
  NSPAIR(_ZN9S19009C10D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19009C6;
extern VTBL_ENTRY _ZTI8S19009C6[];
extern  VTBL_ENTRY _ZTV8S19009C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19009C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19009C8;
extern VTBL_ENTRY _ZTI8S19009C8[];
static Base_Class bases_S19009C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C4_nt,    ABISELECT(316,212), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19009C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C4_nt,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19009C8,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19009C10[];
static  VTBL_ENTRY vtc_S19009C10[] = {
  ABISELECT(316,212),
  0,
  (VTBL_ENTRY)&(_ZTI9S19009C10[0]),
};
extern VTBL_ENTRY _ZTV9S19009C10[];
static  VTBL_ENTRY _tg__ZTV8S19009C6__9S19009C10[] = {
  ABISELECT(316,212),
  0,
  (VTBL_ENTRY)&(_ZTI8S19009C6[0]),
};
static  VTT_ENTRY vtt_S19009C10[] = {
  {&(_ZTV9S19009C10[3]),  3,3},
  {&(_tg__ZTV8S19009C6__9S19009C10[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S19009C10[];
extern  VTBL_ENTRY _ZTV9S19009C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19009C10[];
Class_Descriptor cd_S19009C10 = {  "S19009C10", // class name
  bases_S19009C10, 4,
  &(vtc_S19009C10[0]), // expected_vtbl_contents
  &(vtt_S19009C10[0]), // expected_vtt_contents
  ABISELECT(320,216), // object size
  NSPAIRA(_ZTI9S19009C10),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S19009C10),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19009C10),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19009C3  : S19008C4_nt , S19009C5 , S19009C8 , virtual S19009C10 , S19009C6 {
  ::S19008C9 s19009c3f0;
  long double s19009c3f1;
  char s19009c3f2;
  void *s19009c3f3;
  __tsi64 s19009c3f4;
  ::S19009C8 s19009c3f5;
  int s19009c3f6;
  void *s19009c3f7[10];
  int s19009c3f8;
  ::S19009C10 s19009c3f9;
  int s19009c3f10;
  virtual  ~S19009C3(); // _ZN8S19009C3D2Ev
  virtual void  v2(); // _ZN8S19009C32v2Ev
  virtual void  v3(); // _ZN8S19009C32v3Ev
  S19009C3(); // tgen
};
//SIG(-1 S19009C3) C1{ BC2{ m Fi} BC3{ BC4{ VBC2 Fp FL Fi Fp Fi FU5{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC2 FC6{ BC2 Fi FU7{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC6 v3 Fi FL Fi FL FC2 Fi Fs Fi} BC6 VBC8{ VBC2 BC4 BC6 FL FU7 Fp Fp FC9{} Fi Fi Fp Fc FC9} BC4 vd v1 v2 FU7 FD Fc Fp FL FC6 Fi Fp[10] Fi FC8 Fi}


 S19009C3 ::~S19009C3(){ note_dtor("S19009C3", this);}
void  S19009C3 ::v2(){vfunc_called(this, "_ZN8S19009C32v2Ev");}
void  S19009C3 ::v3(){vfunc_called(this, "_ZN8S19009C32v3Ev");}
S19009C3 ::S19009C3(){ note_ctor("S19009C3", this);} // tgen

static void Test_S19009C3()
{
  extern Class_Descriptor cd_S19009C3;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(88,230)];
    init_test(&cd_S19009C3, buf);
    S19009C3 *dp, &lv = *(dp=new (buf) S19009C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1392,916), "sizeof(S19009C3)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19009C3)");
    /*is_ambiguous_... S19009C3::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*), ABISELECT(288,204), "S19009C3");
    check_base_class_offset(lv, (S19008C4_nt*)(S19009C6*)(S19009C5*), ABISELECT(1060,700), "S19009C3");
    /*is_ambiguous_... S19009C10::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19009C10*), ABISELECT(1060,700), "S19009C3");
    check_base_class_offset(lv, (S19008C4_nt*)(S19009C6*)(S19009C10*), ABISELECT(1060,700), "S19009C3");
    /*is_ambiguous_... S19009C3::S19009C6 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19009C6*), ABISELECT(1060,700), "S19009C3");
    check_base_class_offset(lv, (S19009C6*)(S19009C5*), 0, "S19009C3");
    check_base_class_offset(lv, (S19008C4_nt*)(S19009C8*)(S19009C5*), ABISELECT(208,144), "S19009C3");
    check_base_class_offset(lv, (S19009C8*)(S19009C5*), ABISELECT(208,144), "S19009C3");
    check_base_class_offset(lv, (S19009C5*), 0, "S19009C3");
    /*is_ambiguous_... S19009C3::S19009C8 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19009C8*), ABISELECT(304,208), "S19009C3");
    /*is_ambiguous_... S19009C3::S19009C8 */ AMB_check_base_class_offset(lv, (S19009C8*), ABISELECT(304,208), "S19009C3");
    check_base_class_offset(lv, (S19009C6*)(S19009C10*), ABISELECT(1072,704), "S19009C3");
    check_base_class_offset(lv, (S19008C4_nt*)(S19009C8*)(S19009C10*), ABISELECT(1280,848), "S19009C3");
    check_base_class_offset(lv, (S19009C8*)(S19009C10*), ABISELECT(1280,848), "S19009C3");
    check_base_class_offset(lv, (S19009C10*), ABISELECT(1072,704), "S19009C3");
    /*is_ambiguous_... S19009C3::S19009C6 */ AMB_check_base_class_offset(lv, (S19009C6*), ABISELECT(336,228), "S19009C3");
    check_field_offset(lv, s19009c3f0, ABISELECT(544,372), "S19009C3.s19009c3f0");
    check_field_offset(lv, s19009c3f1, ABISELECT(560,384), "S19009C3.s19009c3f1");
    check_field_offset(lv, s19009c3f2, ABISELECT(576,396), "S19009C3.s19009c3f2");
    check_field_offset(lv, s19009c3f3, ABISELECT(584,400), "S19009C3.s19009c3f3");
    check_field_offset(lv, s19009c3f4, ABISELECT(592,404), "S19009C3.s19009c3f4");
    check_field_offset(lv, s19009c3f5, ABISELECT(608,412), "S19009C3.s19009c3f5");
    check_field_offset(lv, s19009c3f6, ABISELECT(640,432), "S19009C3.s19009c3f6");
    check_field_offset(lv, s19009c3f7, ABISELECT(648,436), "S19009C3.s19009c3f7");
    check_field_offset(lv, s19009c3f8, ABISELECT(728,476), "S19009C3.s19009c3f8");
    check_field_offset(lv, s19009c3f9, ABISELECT(736,480), "S19009C3.s19009c3f9");
    check_field_offset(lv, s19009c3f10, ABISELECT(1056,696), "S19009C3.s19009c3f10");
    test_class_info(&lv, &cd_S19009C3);
    dp->~S19009C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19009C3(Test_S19009C3, "S19009C3", ABISELECT(1392,916));

#else // __cplusplus

extern void _ZN8S19009C3C1Ev();
extern void _ZN8S19009C3D2Ev();
Name_Map name_map_S19009C3[] = {
  NSPAIR(_ZN8S19009C3C1Ev),
  NSPAIR(_ZN8S19009C3D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19009C6;
extern VTBL_ENTRY _ZTI8S19009C6[];
extern  VTBL_ENTRY _ZTV8S19009C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19009C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19009C8;
extern VTBL_ENTRY _ZTI8S19009C8[];
extern Class_Descriptor cd_S19009C5;
extern VTBL_ENTRY _ZTI8S19009C5[];
extern  VTBL_ENTRY _ZTV8S19009C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19009C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19009C8;
extern VTBL_ENTRY _ZTI8S19009C8[];
extern Class_Descriptor cd_S19009C6;
extern VTBL_ENTRY _ZTI8S19009C6[];
extern  VTBL_ENTRY _ZTV8S19009C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19009C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19009C8;
extern VTBL_ENTRY _ZTI8S19009C8[];
extern Class_Descriptor cd_S19009C10;
extern VTBL_ENTRY _ZTI9S19009C10[];
extern  VTBL_ENTRY _ZTV9S19009C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19009C10[];
extern Class_Descriptor cd_S19009C6;
extern VTBL_ENTRY _ZTI8S19009C6[];
extern  VTBL_ENTRY _ZTV8S19009C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19009C6[];
static Base_Class bases_S19009C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C4_nt,    ABISELECT(288,204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C4_nt,    ABISELECT(1060,700), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S19009C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19009C8,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19009C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C4_nt,    ABISELECT(304,208), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19009C8,    ABISELECT(304,208), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19009C6,    ABISELECT(1072,704), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(1280,848), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19009C8,    ABISELECT(1280,848), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19009C10,    ABISELECT(1072,704), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19009C6,    ABISELECT(336,228), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19009C3[];
extern void _ZN8S19009C52v1Ev();
extern void _ZN8S19009C3D1Ev();
extern void _ZN8S19009C3D0Ev();
extern void _ZN8S19009C32v2Ev();
extern void _ZN8S19009C32v3Ev();
static  VTBL_ENTRY vtc_S19009C3[] = {
  ABISELECT(1072,704),
  ABISELECT(1060,700),
  0,
  (VTBL_ENTRY)&(_ZTI8S19009C3[0]),
  (VTBL_ENTRY)&_ZN8S19009C52v1Ev,
  (VTBL_ENTRY)&_ZN8S19009C3D1Ev,
  (VTBL_ENTRY)&_ZN8S19009C3D0Ev,
  (VTBL_ENTRY)&_ZN8S19009C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19009C32v3Ev,
  ABISELECT(724,472),
  ABISELECT(-336,-228),
  (VTBL_ENTRY)&(_ZTI8S19009C3[0]),
  ABISELECT(-12,-4),
  ABISELECT(-1072,-704),
  (VTBL_ENTRY)&(_ZTI8S19009C3[0]),
};
extern VTBL_ENTRY _ZTV8S19009C3[];
extern void _ZN8S19009C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19009C5__8S19009C3[] = {
  ABISELECT(1060,700),
  0,
  (VTBL_ENTRY)&(_ZTI8S19009C5[0]),
  (VTBL_ENTRY)&_ZN8S19009C52v1Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19009C68S19009C5__8S19009C3[] = {
  ABISELECT(1060,700),
  0,
  (VTBL_ENTRY)&(_ZTI8S19009C6[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19009C6__A2__8S19009C3[] = {
  ABISELECT(724,472),
  0,
  (VTBL_ENTRY)&(_ZTI8S19009C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19009C10__8S19009C3[] = {
  ABISELECT(-12,-4),
  0,
  (VTBL_ENTRY)&(_ZTI9S19009C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19009C69S19009C10__A1__8S19009C3[] = {
  ABISELECT(-12,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S19009C6[0]),
};
static  VTT_ENTRY vtt_S19009C3[] = {
  {&(_ZTV8S19009C3[4]),  4,15},
  {&(_tg__ZTV8S19009C5__8S19009C3[3]),  3,4},
  {&(_tg__ZTV8S19009C68S19009C5__8S19009C3[3]),  3,3},
  {&(_tg__ZTV8S19009C6__A2__8S19009C3[3]),  3,3},
  {&(_ZTV8S19009C3[15]),  15,15},
  {&(_ZTV8S19009C3[12]),  12,15},
  {&(_tg__ZTV9S19009C10__8S19009C3[3]),  3,3},
  {&(_tg__ZTV8S19009C69S19009C10__A1__8S19009C3[3]),  3,3},
};
extern VTBL_ENTRY _ZTI8S19009C3[];
extern  VTBL_ENTRY _ZTV8S19009C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19009C3[];
Class_Descriptor cd_S19009C3 = {  "S19009C3", // class name
  bases_S19009C3, 13,
  &(vtc_S19009C3[0]), // expected_vtbl_contents
  &(vtt_S19009C3[0]), // expected_vtt_contents
  ABISELECT(1392,916), // object size
  NSPAIRA(_ZTI8S19009C3),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S19009C3),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19009C3),8, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19009C2  : S19009C3 {
  void *s19009c2f0;
  char s19009c2f1[2];
  int s19009c2f2;
  void *s19009c2f3;
  void *s19009c2f4;
  __tsi64 s19009c2f5:64;
  ::S19008C12 s19009c2f6;
  virtual  ~S19009C2(); // _ZN8S19009C2D2Ev
  virtual void  v4(); // _ZN8S19009C22v4Ev
  S19009C2(); // tgen
};
//SIG(-1 S19009C2) C1{ BC2{ BC3{ m Fi} BC4{ BC5{ VBC3 Fp FL Fi Fp Fi FU6{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC3 FC7{ BC3 Fi FU8{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC7 v2 Fi FL Fi FL FC3 Fi Fs Fi} BC7 VBC9{ VBC3 BC5 BC7 FL FU8 Fp Fp FC10{} Fi Fi Fp Fc FC10} BC5 vd v3 v4 FU8 FD Fc Fp FL FC7 Fi Fp[10] Fi FC9 Fi} vd v1 Fp Fc[2] Fi Fp Fp FL:64 FC11{ VBC12{ m Fi Fi:20 FC13{ BC14{ VBC3 Fp FL Fi Fp Fi FU6 Fc Fc FD FC3 FC15{ BC3 Fi FU8} Fp} BC15 v7 Fi FL Fi FL FC3 Fi Fs Fi} Fi Fc[4] Fi Fi Fi Fi Fi Fi Fi} BC13 VBC16{ BC3 BC13 BC15 VBC17{ VBC3 BC14 BC15 FL FU8 Fp Fp FC10 Fi Fi Fp Fc FC10} BC14 vd v8 v9 FU8 FD Fc Fp FL FC15 Fi Fp[10] Fi FC17 Fi} VBC18{ BC19{ VBC12 BC20{ VBC21{ VBC3 BC14 BC17 FC13 Fi[6] Fi FC3[7] Fi Fp[2]} v10 Fp[7] Fi Fs FD Fi FC13 Fi} BC13 BC22{ BC17 BC15 BC14 VBC16 vd v11 v12 Fs Fs FC15[5] FL FD FL Fi Fi Fp} vd Fi Fi Fp FD[6] Fi Fi FD Fi Fi Fi} BC23{ BC16 BC14 BC12 VBC19 vd Fi FL FU6 Fi Fi FC10 FC16} BC24{ VBC12 BC13 BC20 BC21 VBC25{ VBC21 BC17 VBC20 VBC26{ vd m Fi Fi:1 Fi Fi Fi:9 Fi Fi Fi[8] Fs} BC15 vd v13 v14 v15 v16 FD FC3 Fi Fp[4] Fi[5] FC13 FC14 Fc} v17 Fi Fp[2] Fc FC17[2] FC26 FC13} BC21 v18 v19 v20 FL Fp} VBC27{ v21 Fp Fi Fi FC3 Fp FD Fi FC16 Fp[8] Fp[6]} vd v5 v6 Fl Fi:19 Fi[6] Fi FC15}}


 S19009C2 ::~S19009C2(){ note_dtor("S19009C2", this);}
void  S19009C2 ::v4(){vfunc_called(this, "_ZN8S19009C22v4Ev");}
S19009C2 ::S19009C2(){ note_ctor("S19009C2", this);} // tgen

static void Test_S19009C2()
{
  extern Class_Descriptor cd_S19009C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1101,2950)];
    init_test(&cd_S19009C2, buf);
    S19009C2 *dp, &lv = *(dp=new (buf) S19009C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(17600,11796), "sizeof(S19009C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19009C2)");
    /*is_ambiguous_... S19009C3::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19009C3*), ABISELECT(288,204), "S19009C2");
    check_base_class_offset(lv, (S19008C4_nt*)(S19009C6*)(S19009C5*)(S19009C3*), ABISELECT(17264,11580), "S19009C2");
    /*is_ambiguous_... S19009C10::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19009C10*), ABISELECT(17264,11580), "S19009C2");
    check_base_class_offset(lv, (S19008C4_nt*)(S19009C6*)(S19009C10*), ABISELECT(17264,11580), "S19009C2");
    /*is_ambiguous_... S19009C3::S19009C6 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19009C6*)(S19009C3*), ABISELECT(17264,11580), "S19009C2");
    check_base_class_offset(lv, (S19009C6*)(S19009C5*)(S19009C3*), 0, "S19009C2");
    check_base_class_offset(lv, (S19008C4_nt*)(S19009C8*)(S19009C5*)(S19009C3*), ABISELECT(208,144), "S19009C2");
    check_base_class_offset(lv, (S19009C8*)(S19009C5*)(S19009C3*), ABISELECT(208,144), "S19009C2");
    check_base_class_offset(lv, (S19009C5*)(S19009C3*), 0, "S19009C2");
    /*is_ambiguous_... S19009C3::S19009C8 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19009C8*)(S19009C3*), ABISELECT(304,208), "S19009C2");
    /*is_ambiguous_... S19009C3::S19009C8 */ AMB_check_base_class_offset(lv, (S19009C8*)(S19009C3*), ABISELECT(304,208), "S19009C2");
    check_base_class_offset(lv, (S19009C6*)(S19009C10*), ABISELECT(17280,11584), "S19009C2");
    check_base_class_offset(lv, (S19008C4_nt*)(S19009C8*)(S19009C10*), ABISELECT(17488,11728), "S19009C2");
    check_base_class_offset(lv, (S19009C8*)(S19009C10*), ABISELECT(17488,11728), "S19009C2");
    check_base_class_offset(lv, (S19009C10*)(S19009C3*), ABISELECT(17280,11584), "S19009C2");
    /*is_ambiguous_... S19009C3::S19009C6 */ AMB_check_base_class_offset(lv, (S19009C6*)(S19009C3*), ABISELECT(336,228), "S19009C2");
    check_base_class_offset(lv, (S19009C3*), 0, "S19009C2");
    check_field_offset(lv, s19009c2f0, ABISELECT(1064,700), "S19009C2.s19009c2f0");
    check_field_offset(lv, s19009c2f1, ABISELECT(1072,704), "S19009C2.s19009c2f1");
    check_field_offset(lv, s19009c2f2, ABISELECT(1076,708), "S19009C2.s19009c2f2");
    check_field_offset(lv, s19009c2f3, ABISELECT(1080,712), "S19009C2.s19009c2f3");
    check_field_offset(lv, s19009c2f4, ABISELECT(1088,716), "S19009C2.s19009c2f4");
    set_bf_and_test(lv, s19009c2f5, ABISELECT(1096,720), 0, 64, 1, "S19009C2");
    set_bf_and_test(lv, s19009c2f5, ABISELECT(1096,720), 0, 64, hide_sll(1LL<<63), "S19009C2");
    check_field_offset(lv, s19009c2f6, ABISELECT(1104,728), "S19009C2.s19009c2f6");
    test_class_info(&lv, &cd_S19009C2);
    dp->~S19009C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19009C2(Test_S19009C2, "S19009C2", ABISELECT(17600,11796));

#else // __cplusplus

extern void _ZN8S19009C2C1Ev();
extern void _ZN8S19009C2D2Ev();
Name_Map name_map_S19009C2[] = {
  NSPAIR(_ZN8S19009C2C1Ev),
  NSPAIR(_ZN8S19009C2D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19009C6;
extern VTBL_ENTRY _ZTI8S19009C6[];
extern  VTBL_ENTRY _ZTV8S19009C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19009C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19009C8;
extern VTBL_ENTRY _ZTI8S19009C8[];
extern Class_Descriptor cd_S19009C5;
extern VTBL_ENTRY _ZTI8S19009C5[];
extern  VTBL_ENTRY _ZTV8S19009C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19009C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19009C8;
extern VTBL_ENTRY _ZTI8S19009C8[];
extern Class_Descriptor cd_S19009C6;
extern VTBL_ENTRY _ZTI8S19009C6[];
extern  VTBL_ENTRY _ZTV8S19009C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19009C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19009C8;
extern VTBL_ENTRY _ZTI8S19009C8[];
extern Class_Descriptor cd_S19009C10;
extern VTBL_ENTRY _ZTI9S19009C10[];
extern  VTBL_ENTRY _ZTV9S19009C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19009C10[];
extern Class_Descriptor cd_S19009C6;
extern VTBL_ENTRY _ZTI8S19009C6[];
extern  VTBL_ENTRY _ZTV8S19009C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19009C6[];
extern Class_Descriptor cd_S19009C3;
extern VTBL_ENTRY _ZTI8S19009C3[];
extern  VTBL_ENTRY _ZTV8S19009C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19009C3[];
static Base_Class bases_S19009C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C4_nt,    ABISELECT(288,204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(17264,11580), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S19009C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19009C8,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19009C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(304,208), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19009C8,    ABISELECT(304,208), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19009C6,    ABISELECT(17280,11584), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(17488,11728), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19009C8,    ABISELECT(17488,11728), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19009C10,    ABISELECT(17280,11584), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S19009C6,    ABISELECT(336,228), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19009C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19009C2[];
extern void _ZN8S19009C52v1Ev();
extern void _ZN8S19009C2D1Ev();
extern void _ZN8S19009C2D0Ev();
extern void _ZN8S19009C32v2Ev();
extern void _ZN8S19009C32v3Ev();
extern void _ZN8S19009C22v4Ev();
static  VTBL_ENTRY vtc_S19009C2[] = {
  ABISELECT(17280,11584),
  ABISELECT(17264,11580),
  0,
  (VTBL_ENTRY)&(_ZTI8S19009C2[0]),
  (VTBL_ENTRY)&_ZN8S19009C52v1Ev,
  (VTBL_ENTRY)&_ZN8S19009C2D1Ev,
  (VTBL_ENTRY)&_ZN8S19009C2D0Ev,
  (VTBL_ENTRY)&_ZN8S19009C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19009C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19009C22v4Ev,
  ABISELECT(16928,11352),
  ABISELECT(-336,-228),
  (VTBL_ENTRY)&(_ZTI8S19009C2[0]),
  ABISELECT(-16,-4),
  ABISELECT(-17280,-11584),
  (VTBL_ENTRY)&(_ZTI8S19009C2[0]),
};
extern VTBL_ENTRY _ZTV8S19009C2[];
extern void _ZN8S19009C52v1Ev();
extern void _ZN8S19009C3D1Ev();
extern void _ZN8S19009C3D0Ev();
extern void _ZN8S19009C32v2Ev();
extern void _ZN8S19009C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19009C3__8S19009C2[] = {
  ABISELECT(17280,11584),
  ABISELECT(17264,11580),
  0,
  (VTBL_ENTRY)&(_ZTI8S19009C3[0]),
  (VTBL_ENTRY)&_ZN8S19009C52v1Ev,
  (VTBL_ENTRY)&_ZN8S19009C3D1Ev,
  (VTBL_ENTRY)&_ZN8S19009C3D0Ev,
  (VTBL_ENTRY)&_ZN8S19009C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19009C32v3Ev,
};
extern void _ZN8S19009C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19009C58S19009C3__8S19009C2[] = {
  ABISELECT(17264,11580),
  0,
  (VTBL_ENTRY)&(_ZTI8S19009C5[0]),
  (VTBL_ENTRY)&_ZN8S19009C52v1Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19009C68S19009C58S19009C3__8S19009C2[] = {
  ABISELECT(17264,11580),
  0,
  (VTBL_ENTRY)&(_ZTI8S19009C6[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19009C68S19009C3__A2__8S19009C2[] = {
  ABISELECT(16928,11352),
  0,
  (VTBL_ENTRY)&(_ZTI8S19009C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19009C10__8S19009C3__8S19009C2[] = {
  ABISELECT(-16,-4),
  ABISELECT(-17280,-11584),
  (VTBL_ENTRY)&(_ZTI8S19009C3[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19009C6__A2__8S19009C3__8S19009C2[] = {
  ABISELECT(16928,11352),
  ABISELECT(-336,-228),
  (VTBL_ENTRY)&(_ZTI8S19009C3[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19009C10__8S19009C2[] = {
  ABISELECT(-16,-4),
  0,
  (VTBL_ENTRY)&(_ZTI9S19009C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19009C69S19009C10__A1__8S19009C2[] = {
  ABISELECT(-16,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S19009C6[0]),
};
static  VTT_ENTRY vtt_S19009C2[] = {
  {&(_ZTV8S19009C2[4]),  4,16},
  {&(_tg__ZTV8S19009C3__8S19009C2[4]),  4,9},
  {&(_tg__ZTV8S19009C58S19009C3__8S19009C2[3]),  3,4},
  {&(_tg__ZTV8S19009C68S19009C58S19009C3__8S19009C2[3]),  3,3},
  {&(_tg__ZTV8S19009C68S19009C3__A2__8S19009C2[3]),  3,3},
  {&(_tg__ZTV9S19009C10__8S19009C3__8S19009C2[3]),  3,3},
  {&(_tg__ZTV8S19009C6__A2__8S19009C3__8S19009C2[3]),  3,3},
  {&(_ZTV8S19009C2[16]),  16,16},
  {&(_ZTV8S19009C2[13]),  13,16},
  {&(_tg__ZTV9S19009C10__8S19009C2[3]),  3,3},
  {&(_tg__ZTV8S19009C69S19009C10__A1__8S19009C2[3]),  3,3},
};
extern VTBL_ENTRY _ZTI8S19009C2[];
extern  VTBL_ENTRY _ZTV8S19009C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19009C2[];
Class_Descriptor cd_S19009C2 = {  "S19009C2", // class name
  bases_S19009C2, 14,
  &(vtc_S19009C2[0]), // expected_vtbl_contents
  &(vtt_S19009C2[0]), // expected_vtt_contents
  ABISELECT(17600,11796), // object size
  NSPAIRA(_ZTI8S19009C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S19009C2),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19009C2),11, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19009C23  {
  void *s19009c23f0;
  int s19009c23f1;
  int s19009c23f2;
  ::S19008C4_nt s19009c23f3;
  void *s19009c23f4;
  long double s19009c23f5;
  int s19009c23f6;
  ::S19009C3 s19009c23f7;
  void *s19009c23f8[8];
  void *s19009c23f9[6];
  virtual void  v19(); // _ZN9S19009C233v19Ev
  ~S19009C23(); // tgen
  S19009C23(); // tgen
};
//SIG(-1 S19009C23) C1{ v1 Fp Fi[2] FC2{ m Fi} Fp FD Fi FC3{ BC2 BC4{ BC5{ VBC2 Fp FL Fi Fp Fi FU6{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC2 FC7{ BC2 Fi FU8{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC7 v4 Fi FL Fi FL FC2 Fi Fs Fi} BC7 VBC9{ VBC2 BC5 BC7 FL FU8 Fp Fp FC10{} Fi Fi Fp Fc FC10} BC5 vd v2 v3 FU8 FD Fc Fp FL FC7 Fi Fp[10] Fi FC9 Fi} Fp[8] Fp[6]}


void  S19009C23 ::v19(){vfunc_called(this, "_ZN9S19009C233v19Ev");}
S19009C23 ::~S19009C23(){ note_dtor("S19009C23", this);} // tgen
S19009C23 ::S19009C23(){ note_ctor("S19009C23", this);} // tgen

static void Test_S19009C23()
{
  extern Class_Descriptor cd_S19009C23;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(100,254)];
    init_test(&cd_S19009C23, buf);
    S19009C23 *dp, &lv = *(dp=new (buf) S19009C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1584,1012), "sizeof(S19009C23)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19009C23)");
    check_field_offset(lv, s19009c23f0, ABISELECT(8,4), "S19009C23.s19009c23f0");
    check_field_offset(lv, s19009c23f1, ABISELECT(16,8), "S19009C23.s19009c23f1");
    check_field_offset(lv, s19009c23f2, ABISELECT(20,12), "S19009C23.s19009c23f2");
    check_field_offset(lv, s19009c23f3, ABISELECT(24,16), "S19009C23.s19009c23f3");
    check_field_offset(lv, s19009c23f4, ABISELECT(32,20), "S19009C23.s19009c23f4");
    check_field_offset(lv, s19009c23f5, ABISELECT(48,24), "S19009C23.s19009c23f5");
    check_field_offset(lv, s19009c23f6, ABISELECT(64,36), "S19009C23.s19009c23f6");
    check_field_offset(lv, s19009c23f7, ABISELECT(80,40), "S19009C23.s19009c23f7");
    check_field_offset(lv, s19009c23f8, ABISELECT(1472,956), "S19009C23.s19009c23f8");
    check_field_offset(lv, s19009c23f9, ABISELECT(1536,988), "S19009C23.s19009c23f9");
    test_class_info(&lv, &cd_S19009C23);
    dp->~S19009C23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19009C23(Test_S19009C23, "S19009C23", ABISELECT(1584,1012));

#else // __cplusplus

extern void _ZN9S19009C23C1Ev();
extern void _ZN9S19009C23D1Ev();
Name_Map name_map_S19009C23[] = {
  NSPAIR(_ZN9S19009C23C1Ev),
  NSPAIR(_ZN9S19009C23D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S19009C23[];
extern void _ZN9S19009C233v19Ev();
static  VTBL_ENTRY vtc_S19009C23[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S19009C23[0]),
  (VTBL_ENTRY)&_ZN9S19009C233v19Ev,
};
extern VTBL_ENTRY _ZTI9S19009C23[];
extern  VTBL_ENTRY _ZTV9S19009C23[];
Class_Descriptor cd_S19009C23 = {  "S19009C23", // class name
  0,0,//no base classes
  &(vtc_S19009C23[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1584,1012), // object size
  NSPAIRA(_ZTI9S19009C23),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S19009C23),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19009C24  : virtual S19008C22 {
  ::S19009C23 s19009c24f0;
  long double s19009c24f1;
  int s19009c24f2;
  virtual  ~S19009C24(); // _ZN9S19009C24D2Ev
  virtual void  v5(); // _ZN9S19009C242v5Ev
  S19009C24(); // tgen
};
//SIG(-1 S19009C24) C1{ VBC2{ vd m Fi Fi:1 Fi[2] Fi:9 Fi[10] Fs} vd v1 FC3{ v2 Fp Fi[2] FC4{ m Fi} Fp FD Fi FC5{ BC4 BC6{ BC7{ VBC4 Fp FL Fi Fp Fi FU8{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC4 FC9{ BC4 Fi FU10{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC9 v5 Fi FL Fi FL FC4 Fi Fs Fi} BC9 VBC11{ VBC4 BC7 BC9 FL FU10 Fp Fp FC12{} Fi Fi Fp Fc FC12} BC7 vd v3 v4 FU10 FD Fc Fp FL FC9 Fi Fp[10] Fi FC11 Fi} Fp[8] Fp[6]} FD Fi}


 S19009C24 ::~S19009C24(){ note_dtor("S19009C24", this);}
void  S19009C24 ::v5(){vfunc_called(this, "_ZN9S19009C242v5Ev");}
S19009C24 ::S19009C24(){ note_ctor("S19009C24", this);} // tgen

static void Test_S19009C24()
{
  extern Class_Descriptor cd_S19009C24;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(107,276)];
    init_test(&cd_S19009C24, buf);
    S19009C24 *dp, &lv = *(dp=new (buf) S19009C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1696,1100), "sizeof(S19009C24)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19009C24)");
    check_base_class_offset(lv, (S19008C22*), ABISELECT(1624,1032), "S19009C24");
    check_field_offset(lv, s19009c24f0, ABISELECT(16,4), "S19009C24.s19009c24f0");
    check_field_offset(lv, s19009c24f1, ABISELECT(1600,1016), "S19009C24.s19009c24f1");
    check_field_offset(lv, s19009c24f2, ABISELECT(1616,1028), "S19009C24.s19009c24f2");
    test_class_info(&lv, &cd_S19009C24);
    dp->~S19009C24();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19009C24(Test_S19009C24, "S19009C24", ABISELECT(1696,1100));

#else // __cplusplus

extern void _ZN9S19009C24C1Ev();
extern void _ZN9S19009C24D2Ev();
Name_Map name_map_S19009C24[] = {
  NSPAIR(_ZN9S19009C24C1Ev),
  NSPAIR(_ZN9S19009C24D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C22;
extern VTBL_ENTRY _ZTI9S19008C22[];
extern  VTBL_ENTRY _ZTV9S19008C22[];
static Base_Class bases_S19009C24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C22,    ABISELECT(1624,1032), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19009C24[];
extern void _ZN9S19009C24D1Ev();
extern void _ZN9S19009C24D0Ev();
extern void _ZN9S19009C242v5Ev();
extern void ABISELECT(_ZTv0_n24_N9S19009C24D1Ev,_ZTv0_n12_N9S19009C24D1Ev)();
extern void ABISELECT(_ZThn1624_N9S19009C24D1Ev,_ZThn1032_N9S19009C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19009C24D0Ev,_ZTv0_n12_N9S19009C24D0Ev)();
extern void ABISELECT(_ZThn1624_N9S19009C24D0Ev,_ZThn1032_N9S19009C24D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19009C24[] = {
  ABISELECT(1624,1032),
  0,
  (VTBL_ENTRY)&(_ZTI9S19009C24[0]),
  (VTBL_ENTRY)&_ZN9S19009C24D1Ev,
  (VTBL_ENTRY)&_ZN9S19009C24D0Ev,
  (VTBL_ENTRY)&_ZN9S19009C242v5Ev,
  ABISELECT(-1624,-1032),
  ABISELECT(-1624,-1032),
  (VTBL_ENTRY)&(_ZTI9S19009C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19009C24D1Ev,_ZTv0_n12_N9S19009C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19009C24D0Ev,_ZTv0_n12_N9S19009C24D0Ev),
};
extern VTBL_ENTRY _ZTV9S19009C24[];
static  VTT_ENTRY vtt_S19009C24[] = {
  {&(_ZTV9S19009C24[3]),  3,11},
  {&(_ZTV9S19009C24[9]),  9,11},
};
extern VTBL_ENTRY _ZTI9S19009C24[];
extern  VTBL_ENTRY _ZTV9S19009C24[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19009C24[];
static VTBL_ENTRY alt_thunk_names10[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19009C24D0Ev,_ZTv0_n12_N9S19009C24D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1624_N9S19009C24D0Ev,_ZThn1032_N9S19009C24D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19009C24D1Ev,_ZTv0_n12_N9S19009C24D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1624_N9S19009C24D1Ev,_ZThn1032_N9S19009C24D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19009C24 = {  "S19009C24", // class name
  bases_S19009C24, 1,
  &(vtc_S19009C24[0]), // expected_vtbl_contents
  &(vtt_S19009C24[0]), // expected_vtt_contents
  ABISELECT(1696,1100), // object size
  NSPAIRA(_ZTI9S19009C24),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV9S19009C24),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19009C24),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names10,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19009C1  : virtual S19009C2 , virtual S19009C24 {
  ::S19008C25 s19009c1f0;
  long s19009c1f1;
  void *s19009c1f2;
  char s19009c1f3;
  void *s19009c1f4;
  void *s19009c1f5;
  int s19009c1f6;
  ~S19009C1(); // tgen
  S19009C1(); // tgen
};
//SIG(1 S19009C1) C1{ VBC2{ BC3{ BC4{ m Fi} BC5{ BC6{ VBC4 Fp FL Fi Fp Fi FU7{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC4 FC8{ BC4 Fi FU9{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC8 v1 Fi FL Fi FL FC4 Fi Fs Fi} BC8 VBC10{ VBC4 BC6 BC8 FL FU9 Fp Fp FC11{} Fi Fi Fp Fc FC11} BC6 vd v2 v3 FU9 FD Fc Fp FL FC8 Fi Fp[10] Fi FC10 Fi} vd v4 Fp Fc[2] Fi Fp Fp FL:64 FC12{ VBC13{ m Fi Fi:20 FC14{ BC15{ VBC4 Fp FL Fi Fp Fi FU7 Fc Fc FD FC4 FC16{ BC4 Fi FU9} Fp} BC16 v8 Fi FL Fi FL FC4 Fi Fs Fi} Fi Fc[4] Fi Fi Fi Fi Fi Fi Fi} BC14 VBC17{ BC4 BC14 BC16 VBC18{ VBC4 BC15 BC16 FL FU9 Fp Fp FC11 Fi Fi Fp Fc FC11} BC15 vd v9 v10 FU9 FD Fc Fp FL FC16 Fi Fp[10] Fi FC18 Fi} VBC19{ BC20{ VBC13 BC21{ VBC22{ VBC4 BC15 BC18 FC14 Fi[6] Fi FC4[7] Fi Fp[2]} v11 Fp[7] Fi Fs FD Fi FC14 Fi} BC14 BC23{ BC18 BC16 BC15 VBC17 vd v12 v13 Fs Fs FC16[5] FL FD FL Fi Fi Fp} vd Fi Fi Fp FD[6] Fi Fi FD Fi Fi Fi} BC24{ BC17 BC15 BC13 VBC20 vd Fi FL FU7 Fi Fi FC11 FC17} BC25{ VBC13 BC14 BC21 BC22 VBC26{ VBC22 BC18 VBC21 VBC27{ vd m Fi Fi:1 Fi Fi Fi:9 Fi Fi Fi[8] Fs} BC16 vd v14 v15 v16 v17 FD FC4 Fi Fp[4] Fi[5] FC14 FC15 Fc} v18 Fi Fp[2] Fc FC18[2] FC27 FC14} BC22 v19 v20 v21 FL Fp} VBC28{ v22 Fp Fi Fi FC4 Fp FD Fi FC17 Fp[8] Fp[6]} vd v6 v7 Fl Fi:19 Fi[6] Fi FC16}} VBC29{ VBC27 vd v5 FC30{ v23 Fp Fi Fi FC4 Fp FD Fi FC3 Fp[8] Fp[6]} FD Fi} FU31{ m Fc FD} Fl Fp Fc Fp Fp Fi}


S19009C1 ::~S19009C1(){ note_dtor("S19009C1", this);} // tgen
S19009C1 ::S19009C1(){ note_ctor("S19009C1", this);} // tgen

static void Test_S19009C1()
{
  extern Class_Descriptor cd_S19009C1;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1212,3235)];
    init_test(&cd_S19009C1, buf);
    S19009C1 *dp, &lv = *(dp=new (buf) S19009C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(19376,12936), "sizeof(S19009C1)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19009C1)");
    /*is_ambiguous_... S19009C3::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19009C3*)(S19009C2*), ABISELECT(368,244), "S19009C1");
    check_base_class_offset(lv, (S19008C4_nt*)(S19009C6*)(S19009C5*)(S19009C3*)(S19009C2*), ABISELECT(17344,11620), "S19009C1");
    /*is_ambiguous_... S19009C10::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19009C10*), ABISELECT(17344,11620), "S19009C1");
    check_base_class_offset(lv, (S19008C4_nt*)(S19009C6*)(S19009C10*), ABISELECT(17344,11620), "S19009C1");
    /*is_ambiguous_... S19009C3::S19009C6 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19009C6*)(S19009C3*)(S19009C2*), ABISELECT(17344,11620), "S19009C1");
    check_base_class_offset(lv, (S19009C6*)(S19009C5*)(S19009C3*)(S19009C2*), ABISELECT(80,40), "S19009C1");
    check_base_class_offset(lv, (S19008C4_nt*)(S19009C8*)(S19009C5*)(S19009C3*)(S19009C2*), ABISELECT(288,184), "S19009C1");
    check_base_class_offset(lv, (S19009C8*)(S19009C5*)(S19009C3*)(S19009C2*), ABISELECT(288,184), "S19009C1");
    check_base_class_offset(lv, (S19009C5*)(S19009C3*)(S19009C2*), ABISELECT(80,40), "S19009C1");
    /*is_ambiguous_... S19009C3::S19009C8 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S19009C8*)(S19009C3*)(S19009C2*), ABISELECT(384,248), "S19009C1");
    /*is_ambiguous_... S19009C3::S19009C8 */ AMB_check_base_class_offset(lv, (S19009C8*)(S19009C3*)(S19009C2*), ABISELECT(384,248), "S19009C1");
    check_base_class_offset(lv, (S19009C6*)(S19009C10*), ABISELECT(17360,11624), "S19009C1");
    check_base_class_offset(lv, (S19008C4_nt*)(S19009C8*)(S19009C10*), ABISELECT(17568,11768), "S19009C1");
    check_base_class_offset(lv, (S19009C8*)(S19009C10*), ABISELECT(17568,11768), "S19009C1");
    check_base_class_offset(lv, (S19009C10*)(S19009C3*)(S19009C2*), ABISELECT(17360,11624), "S19009C1");
    /*is_ambiguous_... S19009C3::S19009C6 */ AMB_check_base_class_offset(lv, (S19009C6*)(S19009C3*)(S19009C2*), ABISELECT(416,268), "S19009C1");
    check_base_class_offset(lv, (S19009C3*)(S19009C2*), ABISELECT(80,40), "S19009C1");
    check_base_class_offset(lv, (S19009C2*), ABISELECT(80,40), "S19009C1");
    check_base_class_offset(lv, (S19008C22*)(S19009C24*), ABISELECT(19304,12868), "S19009C1");
    check_base_class_offset(lv, (S19009C24*), ABISELECT(17680,11836), "S19009C1");
    check_field_offset(lv, s19009c1f0, ABISELECT(16,4), "S19009C1.s19009c1f0");
    check_field_offset(lv, s19009c1f1, ABISELECT(32,16), "S19009C1.s19009c1f1");
    check_field_offset(lv, s19009c1f2, ABISELECT(40,20), "S19009C1.s19009c1f2");
    check_field_offset(lv, s19009c1f3, ABISELECT(48,24), "S19009C1.s19009c1f3");
    check_field_offset(lv, s19009c1f4, ABISELECT(56,28), "S19009C1.s19009c1f4");
    check_field_offset(lv, s19009c1f5, ABISELECT(64,32), "S19009C1.s19009c1f5");
    check_field_offset(lv, s19009c1f6, ABISELECT(72,36), "S19009C1.s19009c1f6");
    test_class_info(&lv, &cd_S19009C1);
    dp->~S19009C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19009C1(Test_S19009C1, "S19009C1", ABISELECT(19376,12936));

#else // __cplusplus

extern void _ZN8S19009C1C1Ev();
extern void _ZN8S19009C1D1Ev();
Name_Map name_map_S19009C1[] = {
  NSPAIR(_ZN8S19009C1C1Ev),
  NSPAIR(_ZN8S19009C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19009C6;
extern VTBL_ENTRY _ZTI8S19009C6[];
extern  VTBL_ENTRY _ZTV8S19009C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19009C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19009C8;
extern VTBL_ENTRY _ZTI8S19009C8[];
extern Class_Descriptor cd_S19009C5;
extern VTBL_ENTRY _ZTI8S19009C5[];
extern  VTBL_ENTRY _ZTV8S19009C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19009C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19009C8;
extern VTBL_ENTRY _ZTI8S19009C8[];
extern Class_Descriptor cd_S19009C6;
extern VTBL_ENTRY _ZTI8S19009C6[];
extern  VTBL_ENTRY _ZTV8S19009C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19009C6[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19009C8;
extern VTBL_ENTRY _ZTI8S19009C8[];
extern Class_Descriptor cd_S19009C10;
extern VTBL_ENTRY _ZTI9S19009C10[];
extern  VTBL_ENTRY _ZTV9S19009C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19009C10[];
extern Class_Descriptor cd_S19009C6;
extern VTBL_ENTRY _ZTI8S19009C6[];
extern  VTBL_ENTRY _ZTV8S19009C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19009C6[];
extern Class_Descriptor cd_S19009C3;
extern VTBL_ENTRY _ZTI8S19009C3[];
extern  VTBL_ENTRY _ZTV8S19009C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19009C3[];
extern Class_Descriptor cd_S19009C2;
extern VTBL_ENTRY _ZTI8S19009C2[];
extern  VTBL_ENTRY _ZTV8S19009C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19009C2[];
extern Class_Descriptor cd_S19008C22;
extern VTBL_ENTRY _ZTI9S19008C22[];
extern  VTBL_ENTRY _ZTV9S19008C22[];
extern Class_Descriptor cd_S19009C24;
extern VTBL_ENTRY _ZTI9S19009C24[];
extern  VTBL_ENTRY _ZTV9S19009C24[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19009C24[];
static Base_Class bases_S19009C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C4_nt,    ABISELECT(368,244), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(17344,11620), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S19009C6,    ABISELECT(80,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(288,184), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19009C8,    ABISELECT(288,184), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19009C5,    ABISELECT(80,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(384,248), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19009C8,    ABISELECT(384,248), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19009C6,    ABISELECT(17360,11624), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(17568,11768), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19009C8,    ABISELECT(17568,11768), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19009C10,    ABISELECT(17360,11624), //bcp->offset
    27, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S19009C6,    ABISELECT(416,268), //bcp->offset
    24, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19009C3,    ABISELECT(80,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19009C2,    ABISELECT(80,40), //bcp->offset
    9, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19008C22,    ABISELECT(19304,12868), //bcp->offset
    38, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S19009C24,    ABISELECT(17680,11836), //bcp->offset
    30, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S19009C1[];
extern void _ZN8S19009C1D1Ev();
extern void _ZN8S19009C1D0Ev();
extern void _ZN8S19009C52v1Ev();
extern void ABISELECT(_ZTv0_n48_N8S19009C1D1Ev,_ZTv0_n24_N8S19009C1D1Ev)();
extern void ABISELECT(_ZThn80_N8S19009C1D1Ev,_ZThn40_N8S19009C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19009C1D0Ev,_ZTv0_n24_N8S19009C1D0Ev)();
extern void ABISELECT(_ZThn80_N8S19009C1D0Ev,_ZThn40_N8S19009C1D0Ev)() __attribute__((weak));
extern void _ZN8S19009C32v2Ev();
extern void _ZN8S19009C32v3Ev();
extern void _ZN8S19009C22v4Ev();
extern void ABISELECT(_ZTv0_n32_N8S19009C1D1Ev,_ZTv0_n16_N8S19009C1D1Ev)();
extern void ABISELECT(_ZThn17680_N8S19009C1D1Ev,_ZThn11836_N8S19009C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19009C1D0Ev,_ZTv0_n16_N8S19009C1D0Ev)();
extern void ABISELECT(_ZThn17680_N8S19009C1D0Ev,_ZThn11836_N8S19009C1D0Ev)() __attribute__((weak));
extern void _ZN9S19009C242v5Ev();
extern void ABISELECT(_ZTv0_n24_N8S19009C1D1Ev,_ZTv0_n12_N8S19009C1D1Ev)();
extern void ABISELECT(_ZThn19304_N8S19009C1D1Ev,_ZThn12868_N8S19009C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19009C1D0Ev,_ZTv0_n12_N8S19009C1D0Ev)();
extern void ABISELECT(_ZThn19304_N8S19009C1D0Ev,_ZThn12868_N8S19009C1D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19009C1[] = {
  ABISELECT(19304,12868),
  ABISELECT(17680,11836),
  ABISELECT(17360,11624),
  ABISELECT(17344,11620),
  ABISELECT(80,40),
  0,
  (VTBL_ENTRY)&(_ZTI8S19009C1[0]),
  (VTBL_ENTRY)&_ZN8S19009C1D1Ev,
  (VTBL_ENTRY)&_ZN8S19009C1D0Ev,
  0,
  0,
  0,
  ABISELECT(-80,-40),
  0,
  ABISELECT(17280,11584),
  ABISELECT(17264,11580),
  ABISELECT(-80,-40),
  (VTBL_ENTRY)&(_ZTI8S19009C1[0]),
  (VTBL_ENTRY)&_ZN8S19009C52v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19009C1D1Ev,_ZTv0_n24_N8S19009C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19009C1D0Ev,_ZTv0_n24_N8S19009C1D0Ev),
  (VTBL_ENTRY)&_ZN8S19009C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19009C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19009C22v4Ev,
  ABISELECT(16928,11352),
  ABISELECT(-416,-268),
  (VTBL_ENTRY)&(_ZTI8S19009C1[0]),
  ABISELECT(-16,-4),
  ABISELECT(-17360,-11624),
  (VTBL_ENTRY)&(_ZTI8S19009C1[0]),
  0,
  ABISELECT(-17680,-11836),
  ABISELECT(1624,1032),
  ABISELECT(-17680,-11836),
  (VTBL_ENTRY)&(_ZTI8S19009C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19009C1D1Ev,_ZTv0_n16_N8S19009C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19009C1D0Ev,_ZTv0_n16_N8S19009C1D0Ev),
  (VTBL_ENTRY)&_ZN9S19009C242v5Ev,
  ABISELECT(-19304,-12868),
  ABISELECT(-19304,-12868),
  (VTBL_ENTRY)&(_ZTI8S19009C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19009C1D1Ev,_ZTv0_n12_N8S19009C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19009C1D0Ev,_ZTv0_n12_N8S19009C1D0Ev),
};
extern VTBL_ENTRY _ZTV8S19009C1[];
extern void _ZN8S19009C52v1Ev();
extern void _ZN8S19009C2D1Ev();
extern void _ZN8S19009C2D0Ev();
extern void _ZN8S19009C32v2Ev();
extern void _ZN8S19009C32v3Ev();
extern void _ZN8S19009C22v4Ev();
static  VTBL_ENTRY _tg__ZTV8S19009C2__8S19009C1[] = {
  ABISELECT(17280,11584),
  ABISELECT(17264,11580),
  0,
  (VTBL_ENTRY)&(_ZTI8S19009C2[0]),
  (VTBL_ENTRY)&_ZN8S19009C52v1Ev,
  (VTBL_ENTRY)&_ZN8S19009C2D1Ev,
  (VTBL_ENTRY)&_ZN8S19009C2D0Ev,
  (VTBL_ENTRY)&_ZN8S19009C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19009C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19009C22v4Ev,
};
extern void _ZN8S19009C52v1Ev();
extern void _ZN8S19009C3D1Ev();
extern void _ZN8S19009C3D0Ev();
extern void _ZN8S19009C32v2Ev();
extern void _ZN8S19009C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19009C38S19009C2__8S19009C1[] = {
  ABISELECT(17280,11584),
  ABISELECT(17264,11580),
  0,
  (VTBL_ENTRY)&(_ZTI8S19009C3[0]),
  (VTBL_ENTRY)&_ZN8S19009C52v1Ev,
  (VTBL_ENTRY)&_ZN8S19009C3D1Ev,
  (VTBL_ENTRY)&_ZN8S19009C3D0Ev,
  (VTBL_ENTRY)&_ZN8S19009C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19009C32v3Ev,
};
extern void _ZN8S19009C52v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19009C58S19009C38S19009C2__8S19009C1[] = {
  ABISELECT(17264,11580),
  0,
  (VTBL_ENTRY)&(_ZTI8S19009C5[0]),
  (VTBL_ENTRY)&_ZN8S19009C52v1Ev,
};
static  VTBL_ENTRY _tg__ZTV8S19009C68S19009C58S19009C38S19009C2__8S19009C1[] = {
  ABISELECT(17264,11580),
  0,
  (VTBL_ENTRY)&(_ZTI8S19009C6[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19009C68S19009C38S19009C2__A2__8S19009C1[] = {
  ABISELECT(16928,11352),
  0,
  (VTBL_ENTRY)&(_ZTI8S19009C6[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19009C10__8S19009C38S19009C2__8S19009C1[] = {
  ABISELECT(-16,-4),
  ABISELECT(-17280,-11584),
  (VTBL_ENTRY)&(_ZTI8S19009C3[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19009C6__A2__8S19009C38S19009C2__8S19009C1[] = {
  ABISELECT(16928,11352),
  ABISELECT(-336,-228),
  (VTBL_ENTRY)&(_ZTI8S19009C3[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19009C10__8S19009C2__8S19009C1[] = {
  ABISELECT(-16,-4),
  ABISELECT(-17280,-11584),
  (VTBL_ENTRY)&(_ZTI8S19009C2[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19009C68S19009C3__A2__8S19009C2__8S19009C1[] = {
  ABISELECT(16928,11352),
  ABISELECT(-336,-228),
  (VTBL_ENTRY)&(_ZTI8S19009C2[0]),
};
static  VTBL_ENTRY _tg__ZTV9S19009C10__8S19009C1[] = {
  ABISELECT(-16,-4),
  0,
  (VTBL_ENTRY)&(_ZTI9S19009C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S19009C69S19009C10__A1__8S19009C1[] = {
  ABISELECT(-16,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S19009C6[0]),
};
extern void _ZN9S19009C24D1Ev();
extern void _ZN9S19009C24D0Ev();
extern void _ZN9S19009C242v5Ev();
static  VTBL_ENTRY _tg__ZTV9S19009C24__8S19009C1[] = {
  ABISELECT(1624,1032),
  0,
  (VTBL_ENTRY)&(_ZTI9S19009C24[0]),
  (VTBL_ENTRY)&_ZN9S19009C24D1Ev,
  (VTBL_ENTRY)&_ZN9S19009C24D0Ev,
  (VTBL_ENTRY)&_ZN9S19009C242v5Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19009C24D1Ev,_ZTv0_n12_N9S19009C24D1Ev)();
extern void ABISELECT(_ZThn1624_N9S19009C24D1Ev,_ZThn1032_N9S19009C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19009C24D0Ev,_ZTv0_n12_N9S19009C24D0Ev)();
extern void ABISELECT(_ZThn1624_N9S19009C24D0Ev,_ZThn1032_N9S19009C24D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19008C22__9S19009C24__8S19009C1[] = {
  ABISELECT(-1624,-1032),
  ABISELECT(-1624,-1032),
  (VTBL_ENTRY)&(_ZTI9S19009C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19009C24D1Ev,_ZTv0_n12_N9S19009C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19009C24D0Ev,_ZTv0_n12_N9S19009C24D0Ev),
};
static  VTT_ENTRY vtt_S19009C1[] = {
  {&(_ZTV8S19009C1[7]),  7,43},
  {&(_ZTV8S19009C1[18]),  18,43},
  {&(_ZTV8S19009C1[30]),  30,43},
  {&(_ZTV8S19009C1[27]),  27,43},
  {&(_ZTV8S19009C1[35]),  35,43},
  {&(_ZTV8S19009C1[41]),  41,43},
  {&(_tg__ZTV8S19009C2__8S19009C1[4]),  4,10},
  {&(_tg__ZTV8S19009C38S19009C2__8S19009C1[4]),  4,9},
  {&(_tg__ZTV8S19009C58S19009C38S19009C2__8S19009C1[3]),  3,4},
  {&(_tg__ZTV8S19009C68S19009C58S19009C38S19009C2__8S19009C1[3]),  3,3},
  {&(_tg__ZTV8S19009C68S19009C38S19009C2__A2__8S19009C1[3]),  3,3},
  {&(_tg__ZTV9S19009C10__8S19009C38S19009C2__8S19009C1[3]),  3,3},
  {&(_tg__ZTV8S19009C6__A2__8S19009C38S19009C2__8S19009C1[3]),  3,3},
  {&(_tg__ZTV9S19009C10__8S19009C2__8S19009C1[3]),  3,3},
  {&(_tg__ZTV8S19009C68S19009C3__A2__8S19009C2__8S19009C1[3]),  3,3},
  {&(_tg__ZTV9S19009C10__8S19009C1[3]),  3,3},
  {&(_tg__ZTV8S19009C69S19009C10__A1__8S19009C1[3]),  3,3},
  {&(_tg__ZTV9S19009C24__8S19009C1[3]),  3,6},
  {&(_tg__ZTV9S19008C22__9S19009C24__8S19009C1[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S19009C1[];
extern  VTBL_ENTRY _ZTV8S19009C1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19009C1[];
static VTBL_ENTRY alt_thunk_names11[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19009C24D0Ev,_ZTv0_n12_N9S19009C24D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1624_N9S19009C24D0Ev,_ZThn1032_N9S19009C24D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19009C24D1Ev,_ZTv0_n12_N9S19009C24D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1624_N9S19009C24D1Ev,_ZThn1032_N9S19009C24D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19009C1D0Ev,_ZTv0_n12_N8S19009C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn19304_N8S19009C1D0Ev,_ZThn12868_N8S19009C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19009C1D1Ev,_ZTv0_n12_N8S19009C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn19304_N8S19009C1D1Ev,_ZThn12868_N8S19009C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19009C1D0Ev,_ZTv0_n16_N8S19009C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17680_N8S19009C1D0Ev,_ZThn11836_N8S19009C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19009C1D1Ev,_ZTv0_n16_N8S19009C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17680_N8S19009C1D1Ev,_ZThn11836_N8S19009C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19009C1D0Ev,_ZTv0_n24_N8S19009C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N8S19009C1D0Ev,_ZThn40_N8S19009C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19009C1D1Ev,_ZTv0_n24_N8S19009C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N8S19009C1D1Ev,_ZThn40_N8S19009C1D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19009C1 = {  "S19009C1", // class name
  bases_S19009C1, 17,
  &(vtc_S19009C1[0]), // expected_vtbl_contents
  &(vtt_S19009C1[0]), // expected_vtt_contents
  ABISELECT(19376,12936), // object size
  NSPAIRA(_ZTI8S19009C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S19009C1),43, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19009C1),19, //virtual table table var
  9, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names11,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20624C8  : S19008C4_nt {
  int s20624c8f0;
  ::S19008C9 s20624c8f1;
};
//SIG(-1 S20624C8) C1{ BC2{ m Fi} Fi FU3{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}}



static void Test_S20624C8()
{
  extern Class_Descriptor cd_S20624C8;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(3,6)];
    init_test(&cd_S20624C8, buf);
    S20624C8 &lv = *(new (buf) S20624C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S20624C8)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20624C8)");
    check_base_class_offset(lv, (S19008C4_nt*), 0, "S20624C8");
    check_field_offset(lv, s20624c8f0, 4, "S20624C8.s20624c8f0");
    check_field_offset(lv, s20624c8f1, ABISELECT(16,8), "S20624C8.s20624c8f1");
    test_class_info(&lv, &cd_S20624C8);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20624C8(Test_S20624C8, "S20624C8", ABISELECT(32,20));

#else // __cplusplus

extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
static Base_Class bases_S20624C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20624C8[];
Class_Descriptor cd_S20624C8 = {  "S20624C8", // class name
  bases_S20624C8, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI8S20624C8),ABISELECT(24,12), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20624C5  : virtual S19008C4_nt {
  void *s20624c5f0;
  __tsi64 s20624c5f1;
  int s20624c5f2;
  void *s20624c5f3;
  int s20624c5f4;
  ::S19008C7 s20624c5f5;
  char s20624c5f6;
  char s20624c5f7;
  long double s20624c5f8;
  ::S19008C4_nt s20624c5f9;
  ::S20624C8 s20624c5f10;
  void *s20624c5f11;
  ~S20624C5(); // tgen
  S20624C5(); // tgen
};
//SIG(-1 S20624C5) C1{ VBC2{ m Fi} Fp FL Fi Fp Fi FU3{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC2 FC4{ BC2 Fi FU5{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp}


S20624C5 ::~S20624C5(){ note_dtor("S20624C5", this);} // tgen
S20624C5 ::S20624C5(){ note_ctor("S20624C5", this);} // tgen

static void Test_S20624C5()
{
  extern Class_Descriptor cd_S20624C5;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(14,38)];
    init_test(&cd_S20624C5, buf);
    S20624C5 *dp, &lv = *(dp=new (buf) S20624C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,148), "sizeof(S20624C5)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20624C5)");
    check_base_class_offset(lv, (S19008C4_nt*), ABISELECT(200,144), "S20624C5");
    check_field_offset(lv, s20624c5f0, ABISELECT(8,4), "S20624C5.s20624c5f0");
    check_field_offset(lv, s20624c5f1, ABISELECT(16,8), "S20624C5.s20624c5f1");
    check_field_offset(lv, s20624c5f2, ABISELECT(24,16), "S20624C5.s20624c5f2");
    check_field_offset(lv, s20624c5f3, ABISELECT(32,20), "S20624C5.s20624c5f3");
    check_field_offset(lv, s20624c5f4, ABISELECT(40,24), "S20624C5.s20624c5f4");
    check_field_offset(lv, s20624c5f5, ABISELECT(48,28), "S20624C5.s20624c5f5");
    check_field_offset(lv, s20624c5f6, ABISELECT(120,100), "S20624C5.s20624c5f6");
    check_field_offset(lv, s20624c5f7, ABISELECT(121,101), "S20624C5.s20624c5f7");
    check_field_offset(lv, s20624c5f8, ABISELECT(128,104), "S20624C5.s20624c5f8");
    check_field_offset(lv, s20624c5f9, ABISELECT(144,116), "S20624C5.s20624c5f9");
    check_field_offset(lv, s20624c5f10, ABISELECT(160,120), "S20624C5.s20624c5f10");
    check_field_offset(lv, s20624c5f11, ABISELECT(192,140), "S20624C5.s20624c5f11");
    test_class_info(&lv, &cd_S20624C5);
    dp->~S20624C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20624C5(Test_S20624C5, "S20624C5", ABISELECT(208,148));

#else // __cplusplus

extern void _ZN8S20624C5C1Ev();
extern void _ZN8S20624C5D1Ev();
Name_Map name_map_S20624C5[] = {
  NSPAIR(_ZN8S20624C5C1Ev),
  NSPAIR(_ZN8S20624C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
static Base_Class bases_S20624C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C4_nt,    ABISELECT(200,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20624C5[];
static  VTBL_ENTRY vtc_S20624C5[] = {
  ABISELECT(200,144),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
extern VTBL_ENTRY _ZTV8S20624C5[];
static  VTT_ENTRY vtt_S20624C5[] = {
  {&(_ZTV8S20624C5[3]),  3,3},
};
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
Class_Descriptor cd_S20624C5 = {  "S20624C5", // class name
  bases_S20624C5, 1,
  &(vtc_S20624C5[0]), // expected_vtbl_contents
  &(vtt_S20624C5[0]), // expected_vtt_contents
  ABISELECT(208,148), // object size
  NSPAIRA(_ZTI8S20624C5),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S20624C5),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20624C5),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20624C12  : virtual S19008C4_nt , S20624C5 , S20624C8 {
  __tsi64 s20624c12f0;
  ::S19008C9 s20624c12f1;
  void *s20624c12f2;
  void *s20624c12f3;
  ::S19008C11_nt s20624c12f4;
  int s20624c12f5;
  int s20624c12f6;
  void *s20624c12f7;
  char s20624c12f8;
  ::S19008C11_nt s20624c12f9;
  ~S20624C12(); // tgen
  S20624C12(); // tgen
};
//SIG(-1 S20624C12) C1{ VBC2{ m Fi} BC3{ VBC2 Fp FL Fi Fp Fi FU4{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC2 FC5{ BC2 Fi FU6{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC5 FL FU6 Fp Fp FC7{} Fi Fi Fp Fc FC7}


S20624C12 ::~S20624C12(){ note_dtor("S20624C12", this);} // tgen
S20624C12 ::S20624C12(){ note_ctor("S20624C12", this);} // tgen

static void Test_S20624C12()
{
  extern Class_Descriptor cd_S20624C12;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(21,55)];
    init_test(&cd_S20624C12, buf);
    S20624C12 *dp, &lv = *(dp=new (buf) S20624C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(320,216), "sizeof(S20624C12)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20624C12)");
    /*is_ambiguous_... S20624C12::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*), ABISELECT(316,212), "S20624C12");
    check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*), ABISELECT(316,212), "S20624C12");
    check_base_class_offset(lv, (S20624C5*), 0, "S20624C12");
    check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*), ABISELECT(208,144), "S20624C12");
    check_base_class_offset(lv, (S20624C8*), ABISELECT(208,144), "S20624C12");
    check_field_offset(lv, s20624c12f0, ABISELECT(240,164), "S20624C12.s20624c12f0");
    check_field_offset(lv, s20624c12f1, ABISELECT(256,172), "S20624C12.s20624c12f1");
    check_field_offset(lv, s20624c12f2, ABISELECT(272,184), "S20624C12.s20624c12f2");
    check_field_offset(lv, s20624c12f3, ABISELECT(280,188), "S20624C12.s20624c12f3");
    check_field_offset(lv, s20624c12f4, ABISELECT(288,192), "S20624C12.s20624c12f4");
    check_field_offset(lv, s20624c12f5, ABISELECT(292,196), "S20624C12.s20624c12f5");
    check_field_offset(lv, s20624c12f6, ABISELECT(296,200), "S20624C12.s20624c12f6");
    check_field_offset(lv, s20624c12f7, ABISELECT(304,204), "S20624C12.s20624c12f7");
    check_field_offset(lv, s20624c12f8, ABISELECT(312,208), "S20624C12.s20624c12f8");
    check_field_offset(lv, s20624c12f9, ABISELECT(313,209), "S20624C12.s20624c12f9");
    test_class_info(&lv, &cd_S20624C12);
    dp->~S20624C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20624C12(Test_S20624C12, "S20624C12", ABISELECT(320,216));

#else // __cplusplus

extern void _ZN9S20624C12C1Ev();
extern void _ZN9S20624C12D1Ev();
Name_Map name_map_S20624C12[] = {
  NSPAIR(_ZN9S20624C12C1Ev),
  NSPAIR(_ZN9S20624C12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
static Base_Class bases_S20624C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C4_nt,    ABISELECT(316,212), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20624C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C4_nt,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20624C12[];
static  VTBL_ENTRY vtc_S20624C12[] = {
  ABISELECT(316,212),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C12[0]),
};
extern VTBL_ENTRY _ZTV9S20624C12[];
static  VTBL_ENTRY _tg__ZTV8S20624C5__9S20624C12[] = {
  ABISELECT(316,212),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTT_ENTRY vtt_S20624C12[] = {
  {&(_ZTV9S20624C12[3]),  3,3},
  {&(_tg__ZTV8S20624C5__9S20624C12[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20624C12[];
extern  VTBL_ENTRY _ZTV9S20624C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C12[];
Class_Descriptor cd_S20624C12 = {  "S20624C12", // class name
  bases_S20624C12, 4,
  &(vtc_S20624C12[0]), // expected_vtbl_contents
  &(vtt_S20624C12[0]), // expected_vtt_contents
  ABISELECT(320,216), // object size
  NSPAIRA(_ZTI9S20624C12),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S20624C12),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20624C12),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20624C4  : S20624C5 , S20624C8 {
  int s20624c4f0;
  __tsi64 s20624c4f1;
  int s20624c4f2;
  __tsi64 s20624c4f3;
  ::S19008C4_nt s20624c4f4;
  int s20624c4f5;
  short s20624c4f6;
  int s20624c4f7;
  virtual void  v2(); // _ZN8S20624C42v2Ev
  ~S20624C4(); // tgen
  S20624C4(); // tgen
};
//SIG(-1 S20624C4) C1{ BC2{ VBC3{ m Fi} Fp FL Fi Fp Fi FU4{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC3 FC5{ BC3 Fi FU6{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC5 v1 Fi FL Fi FL FC3 Fi Fs Fi}


void  S20624C4 ::v2(){vfunc_called(this, "_ZN8S20624C42v2Ev");}
S20624C4 ::~S20624C4(){ note_dtor("S20624C4", this);} // tgen
S20624C4 ::S20624C4(){ note_ctor("S20624C4", this);} // tgen

static void Test_S20624C4()
{
  extern Class_Descriptor cd_S20624C4;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(20,53)];
    init_test(&cd_S20624C4, buf);
    S20624C4 *dp, &lv = *(dp=new (buf) S20624C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,208), "sizeof(S20624C4)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20624C4)");
    check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*), ABISELECT(288,204), "S20624C4");
    check_base_class_offset(lv, (S20624C5*), 0, "S20624C4");
    check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*), ABISELECT(208,144), "S20624C4");
    check_base_class_offset(lv, (S20624C8*), ABISELECT(208,144), "S20624C4");
    check_field_offset(lv, s20624c4f0, ABISELECT(240,164), "S20624C4.s20624c4f0");
    check_field_offset(lv, s20624c4f1, ABISELECT(248,168), "S20624C4.s20624c4f1");
    check_field_offset(lv, s20624c4f2, ABISELECT(256,176), "S20624C4.s20624c4f2");
    check_field_offset(lv, s20624c4f3, ABISELECT(264,180), "S20624C4.s20624c4f3");
    check_field_offset(lv, s20624c4f4, ABISELECT(272,188), "S20624C4.s20624c4f4");
    check_field_offset(lv, s20624c4f5, ABISELECT(276,192), "S20624C4.s20624c4f5");
    check_field_offset(lv, s20624c4f6, ABISELECT(280,196), "S20624C4.s20624c4f6");
    check_field_offset(lv, s20624c4f7, ABISELECT(284,200), "S20624C4.s20624c4f7");
    test_class_info(&lv, &cd_S20624C4);
    dp->~S20624C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20624C4(Test_S20624C4, "S20624C4", ABISELECT(304,208));

#else // __cplusplus

extern void _ZN8S20624C4C1Ev();
extern void _ZN8S20624C4D1Ev();
Name_Map name_map_S20624C4[] = {
  NSPAIR(_ZN8S20624C4C1Ev),
  NSPAIR(_ZN8S20624C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
static Base_Class bases_S20624C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C4_nt,    ABISELECT(288,204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20624C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C4_nt,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20624C4[];
extern void _ZN8S20624C42v2Ev();
static  VTBL_ENTRY vtc_S20624C4[] = {
  ABISELECT(288,204),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C4[0]),
  (VTBL_ENTRY)&_ZN8S20624C42v2Ev,
};
extern VTBL_ENTRY _ZTV8S20624C4[];
static  VTBL_ENTRY _tg__ZTV8S20624C5__8S20624C4[] = {
  ABISELECT(288,204),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTT_ENTRY vtt_S20624C4[] = {
  {&(_ZTV8S20624C4[3]),  3,4},
  {&(_tg__ZTV8S20624C5__8S20624C4[3]),  3,3},
};
extern VTBL_ENTRY _ZTI8S20624C4[];
extern  VTBL_ENTRY _ZTV8S20624C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C4[];
Class_Descriptor cd_S20624C4 = {  "S20624C4", // class name
  bases_S20624C4, 4,
  &(vtc_S20624C4[0]), // expected_vtbl_contents
  &(vtt_S20624C4[0]), // expected_vtt_contents
  ABISELECT(304,208), // object size
  NSPAIRA(_ZTI8S20624C4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S20624C4),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20624C4),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20624C11  : virtual S19008C4_nt , S20624C5 , S20624C12 {
  ::S20624C4 s20624c11f0;
  int s20624c11f1[6];
  int s20624c11f2;
  ::S19008C4_nt s20624c11f3[7];
  int s20624c11f4;
  void *s20624c11f5[2];
  ~S20624C11(); // tgen
  S20624C11(); // tgen
};
//SIG(-1 S20624C11) C1{ VBC2{ m Fi} BC3{ VBC2 Fp FL Fi Fp Fi FU4{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC2 FC5{ BC2 Fi FU6{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC7{ VBC2 BC3 BC5 FL FU6 Fp Fp FC8{} Fi Fi Fp Fc FC8} FC9{ BC3 BC5 v1 Fi FL Fi FL FC2 Fi Fs Fi} Fi[6] Fi FC2[7] Fi Fp[2]}


S20624C11 ::~S20624C11(){ note_dtor("S20624C11", this);} // tgen
S20624C11 ::S20624C11(){ note_ctor("S20624C11", this);} // tgen

static void Test_S20624C11()
{
  extern Class_Descriptor cd_S20624C11;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(59,160)];
    init_test(&cd_S20624C11, buf);
    S20624C11 *dp, &lv = *(dp=new (buf) S20624C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(928,636), "sizeof(S20624C11)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20624C11)");
    /*is_ambiguous_... S20624C11::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*), ABISELECT(912,632), "S20624C11");
    /*is_ambiguous_... S20624C11::S20624C5 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*), ABISELECT(912,632), "S20624C11");
    /*is_ambiguous_... S20624C12::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C12*), ABISELECT(912,632), "S20624C11");
    check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C12*), ABISELECT(912,632), "S20624C11");
    /*is_ambiguous_... S20624C11::S20624C5 */ AMB_check_base_class_offset(lv, (S20624C5*), 0, "S20624C11");
    check_base_class_offset(lv, (S20624C5*)(S20624C12*), ABISELECT(208,144), "S20624C11");
    check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C12*), ABISELECT(416,288), "S20624C11");
    check_base_class_offset(lv, (S20624C8*)(S20624C12*), ABISELECT(416,288), "S20624C11");
    check_base_class_offset(lv, (S20624C12*), ABISELECT(208,144), "S20624C11");
    check_field_offset(lv, s20624c11f0, ABISELECT(528,356), "S20624C11.s20624c11f0");
    check_field_offset(lv, s20624c11f1, ABISELECT(832,564), "S20624C11.s20624c11f1");
    check_field_offset(lv, s20624c11f2, ABISELECT(856,588), "S20624C11.s20624c11f2");
    check_field_offset(lv, s20624c11f3, ABISELECT(860,592), "S20624C11.s20624c11f3");
    check_field_offset(lv, s20624c11f4, ABISELECT(888,620), "S20624C11.s20624c11f4");
    check_field_offset(lv, s20624c11f5, ABISELECT(896,624), "S20624C11.s20624c11f5");
    test_class_info(&lv, &cd_S20624C11);
    dp->~S20624C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20624C11(Test_S20624C11, "S20624C11", ABISELECT(928,636));

#else // __cplusplus

extern void _ZN9S20624C11C1Ev();
extern void _ZN9S20624C11D1Ev();
Name_Map name_map_S20624C11[] = {
  NSPAIR(_ZN9S20624C11C1Ev),
  NSPAIR(_ZN9S20624C11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C12;
extern VTBL_ENTRY _ZTI9S20624C12[];
extern  VTBL_ENTRY _ZTV9S20624C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C12[];
static Base_Class bases_S20624C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C4_nt,    ABISELECT(912,632), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20624C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20624C5,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(416,288), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(416,288), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20624C12,    ABISELECT(208,144), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20624C11[];
static  VTBL_ENTRY vtc_S20624C11[] = {
  ABISELECT(912,632),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C11[0]),
  ABISELECT(704,488),
  ABISELECT(-208,-144),
  (VTBL_ENTRY)&(_ZTI9S20624C11[0]),
};
extern VTBL_ENTRY _ZTV9S20624C11[];
static  VTBL_ENTRY _tg__ZTV8S20624C5__9S20624C11[] = {
  ABISELECT(912,632),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C12__9S20624C11[] = {
  ABISELECT(704,488),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C12__A1__9S20624C11[] = {
  ABISELECT(704,488),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTT_ENTRY vtt_S20624C11[] = {
  {&(_ZTV9S20624C11[3]),  3,6},
  {&(_tg__ZTV8S20624C5__9S20624C11[3]),  3,3},
  {&(_tg__ZTV9S20624C12__9S20624C11[3]),  3,3},
  {&(_tg__ZTV8S20624C59S20624C12__A1__9S20624C11[3]),  3,3},
  {&(_ZTV9S20624C11[6]),  6,6},
};
extern VTBL_ENTRY _ZTI9S20624C11[];
extern  VTBL_ENTRY _ZTV9S20624C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C11[];
Class_Descriptor cd_S20624C11 = {  "S20624C11", // class name
  bases_S20624C11, 6,
  &(vtc_S20624C11[0]), // expected_vtbl_contents
  &(vtt_S20624C11[0]), // expected_vtt_contents
  ABISELECT(928,636), // object size
  NSPAIRA(_ZTI9S20624C11),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S20624C11),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20624C11),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20624C10  : virtual S20624C11 {
  void *s20624c10f0[7];
  int s20624c10f1;
  short s20624c10f2;
  long double s20624c10f3;
  int s20624c10f4;
  ::S20624C4 s20624c10f5;
  int s20624c10f6;
  virtual void  v1(); // _ZN9S20624C102v1Ev
  ~S20624C10(); // tgen
  S20624C10(); // tgen
};
//SIG(-1 S20624C10) C1{ VBC2{ VBC3{ m Fi} BC4{ VBC3 Fp FL Fi Fp Fi FU5{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC3 FC6{ BC3 Fi FU7{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC8{ VBC3 BC4 BC6 FL FU7 Fp Fp FC9{} Fi Fi Fp Fc FC9} FC10{ BC4 BC6 v2 Fi FL Fi FL FC3 Fi Fs Fi} Fi[6] Fi FC3[7] Fi Fp[2]} v1 Fp[7] Fi Fs FD Fi FC10 Fi}


void  S20624C10 ::v1(){vfunc_called(this, "_ZN9S20624C102v1Ev");}
S20624C10 ::~S20624C10(){ note_dtor("S20624C10", this);} // tgen
S20624C10 ::S20624C10(){ note_ctor("S20624C10", this);} // tgen

static void Test_S20624C10()
{
  extern Class_Descriptor cd_S20624C10;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(86,227)];
    init_test(&cd_S20624C10, buf);
    S20624C10 *dp, &lv = *(dp=new (buf) S20624C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1360,904), "sizeof(S20624C10)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20624C10)");
    /*is_ambiguous_... S20624C11::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C11*), ABISELECT(1344,900), "S20624C10");
    /*is_ambiguous_... S20624C11::S20624C5 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C11*), ABISELECT(1344,900), "S20624C10");
    /*is_ambiguous_... S20624C12::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C12*)(S20624C11*), ABISELECT(1344,900), "S20624C10");
    check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C12*)(S20624C11*), ABISELECT(1344,900), "S20624C10");
    /*is_ambiguous_... S20624C11::S20624C5 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C11*), ABISELECT(432,268), "S20624C10");
    check_base_class_offset(lv, (S20624C5*)(S20624C12*)(S20624C11*), ABISELECT(640,412), "S20624C10");
    check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C12*)(S20624C11*), ABISELECT(848,556), "S20624C10");
    check_base_class_offset(lv, (S20624C8*)(S20624C12*)(S20624C11*), ABISELECT(848,556), "S20624C10");
    check_base_class_offset(lv, (S20624C12*)(S20624C11*), ABISELECT(640,412), "S20624C10");
    check_base_class_offset(lv, (S20624C11*), ABISELECT(432,268), "S20624C10");
    check_field_offset(lv, s20624c10f0, ABISELECT(8,4), "S20624C10.s20624c10f0");
    check_field_offset(lv, s20624c10f1, ABISELECT(64,32), "S20624C10.s20624c10f1");
    check_field_offset(lv, s20624c10f2, ABISELECT(68,36), "S20624C10.s20624c10f2");
    check_field_offset(lv, s20624c10f3, ABISELECT(80,40), "S20624C10.s20624c10f3");
    check_field_offset(lv, s20624c10f4, ABISELECT(96,52), "S20624C10.s20624c10f4");
    check_field_offset(lv, s20624c10f5, ABISELECT(112,56), "S20624C10.s20624c10f5");
    check_field_offset(lv, s20624c10f6, ABISELECT(416,264), "S20624C10.s20624c10f6");
    test_class_info(&lv, &cd_S20624C10);
    dp->~S20624C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20624C10(Test_S20624C10, "S20624C10", ABISELECT(1360,904));

#else // __cplusplus

extern void _ZN9S20624C10C1Ev();
extern void _ZN9S20624C10D1Ev();
Name_Map name_map_S20624C10[] = {
  NSPAIR(_ZN9S20624C10C1Ev),
  NSPAIR(_ZN9S20624C10D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C12;
extern VTBL_ENTRY _ZTI9S20624C12[];
extern  VTBL_ENTRY _ZTV9S20624C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C12[];
extern Class_Descriptor cd_S20624C11;
extern VTBL_ENTRY _ZTI9S20624C11[];
extern  VTBL_ENTRY _ZTV9S20624C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C11[];
static Base_Class bases_S20624C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C4_nt,    ABISELECT(1344,900), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20624C5,    ABISELECT(432,268), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20624C5,    ABISELECT(640,412), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(848,556), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(848,556), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20624C12,    ABISELECT(640,412), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20624C11,    ABISELECT(432,268), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20624C10[];
extern void _ZN9S20624C102v1Ev();
static  VTBL_ENTRY vtc_S20624C10[] = {
  ABISELECT(1344,900),
  ABISELECT(432,268),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C10[0]),
  (VTBL_ENTRY)&_ZN9S20624C102v1Ev,
  ABISELECT(912,632),
  ABISELECT(-432,-268),
  (VTBL_ENTRY)&(_ZTI9S20624C10[0]),
  ABISELECT(704,488),
  ABISELECT(-640,-412),
  (VTBL_ENTRY)&(_ZTI9S20624C10[0]),
};
extern VTBL_ENTRY _ZTV9S20624C10[];
static  VTBL_ENTRY _tg__ZTV9S20624C11__9S20624C10[] = {
  ABISELECT(912,632),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C11[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C11__9S20624C10[] = {
  ABISELECT(912,632),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C129S20624C11__9S20624C10[] = {
  ABISELECT(704,488),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C129S20624C11__A1__9S20624C10[] = {
  ABISELECT(704,488),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C12__9S20624C11__9S20624C10[] = {
  ABISELECT(704,488),
  ABISELECT(-208,-144),
  (VTBL_ENTRY)&(_ZTI9S20624C11[0]),
};
static  VTT_ENTRY vtt_S20624C10[] = {
  {&(_ZTV9S20624C10[4]),  4,11},
  {&(_ZTV9S20624C10[8]),  8,11},
  {&(_ZTV9S20624C10[11]),  11,11},
  {&(_tg__ZTV9S20624C11__9S20624C10[3]),  3,3},
  {&(_tg__ZTV8S20624C59S20624C11__9S20624C10[3]),  3,3},
  {&(_tg__ZTV9S20624C129S20624C11__9S20624C10[3]),  3,3},
  {&(_tg__ZTV8S20624C59S20624C129S20624C11__A1__9S20624C10[3]),  3,3},
  {&(_tg__ZTV9S20624C12__9S20624C11__9S20624C10[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20624C10[];
extern  VTBL_ENTRY _ZTV9S20624C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C10[];
Class_Descriptor cd_S20624C10 = {  "S20624C10", // class name
  bases_S20624C10, 7,
  &(vtc_S20624C10[0]), // expected_vtbl_contents
  &(vtt_S20624C10[0]), // expected_vtt_contents
  ABISELECT(1360,904), // object size
  NSPAIRA(_ZTI9S20624C10),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV9S20624C10),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20624C10),8, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20624C15  : S19008C4_nt , S20624C4 , S20624C8 , virtual S20624C12 , S20624C5 {
  ::S19008C9 s20624c15f0;
  long double s20624c15f1;
  char s20624c15f2;
  void *s20624c15f3;
  __tsi64 s20624c15f4;
  ::S20624C8 s20624c15f5;
  int s20624c15f6;
  void *s20624c15f7[10];
  int s20624c15f8;
  ::S20624C12 s20624c15f9;
  int s20624c15f10;
  virtual  ~S20624C15(); // _ZN9S20624C15D2Ev
  virtual void  v3(); // _ZN9S20624C152v3Ev
  virtual void  v4(); // _ZN9S20624C152v4Ev
  S20624C15(); // tgen
};
//SIG(-1 S20624C15) C1{ BC2{ m Fi} BC3{ BC4{ VBC2 Fp FL Fi Fp Fi FU5{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC2 FC6{ BC2 Fi FU7{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC6 v3 Fi FL Fi FL FC2 Fi Fs Fi} BC6 VBC8{ VBC2 BC4 BC6 FL FU7 Fp Fp FC9{} Fi Fi Fp Fc FC9} BC4 vd v1 v2 FU7 FD Fc Fp FL FC6 Fi Fp[10] Fi FC8 Fi}


 S20624C15 ::~S20624C15(){ note_dtor("S20624C15", this);}
void  S20624C15 ::v3(){vfunc_called(this, "_ZN9S20624C152v3Ev");}
void  S20624C15 ::v4(){vfunc_called(this, "_ZN9S20624C152v4Ev");}
S20624C15 ::S20624C15(){ note_ctor("S20624C15", this);} // tgen

static void Test_S20624C15()
{
  extern Class_Descriptor cd_S20624C15;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(88,230)];
    init_test(&cd_S20624C15, buf);
    S20624C15 *dp, &lv = *(dp=new (buf) S20624C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1392,916), "sizeof(S20624C15)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20624C15)");
    /*is_ambiguous_... S20624C15::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*), ABISELECT(288,204), "S20624C15");
    check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C4*), ABISELECT(1060,700), "S20624C15");
    /*is_ambiguous_... S20624C12::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C12*), ABISELECT(1060,700), "S20624C15");
    check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C12*), ABISELECT(1060,700), "S20624C15");
    /*is_ambiguous_... S20624C15::S20624C5 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*), ABISELECT(1060,700), "S20624C15");
    check_base_class_offset(lv, (S20624C5*)(S20624C4*), 0, "S20624C15");
    check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C4*), ABISELECT(208,144), "S20624C15");
    check_base_class_offset(lv, (S20624C8*)(S20624C4*), ABISELECT(208,144), "S20624C15");
    check_base_class_offset(lv, (S20624C4*), 0, "S20624C15");
    /*is_ambiguous_... S20624C15::S20624C8 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*), ABISELECT(304,208), "S20624C15");
    /*is_ambiguous_... S20624C15::S20624C8 */ AMB_check_base_class_offset(lv, (S20624C8*), ABISELECT(304,208), "S20624C15");
    check_base_class_offset(lv, (S20624C5*)(S20624C12*), ABISELECT(1072,704), "S20624C15");
    check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C12*), ABISELECT(1280,848), "S20624C15");
    check_base_class_offset(lv, (S20624C8*)(S20624C12*), ABISELECT(1280,848), "S20624C15");
    check_base_class_offset(lv, (S20624C12*), ABISELECT(1072,704), "S20624C15");
    /*is_ambiguous_... S20624C15::S20624C5 */ AMB_check_base_class_offset(lv, (S20624C5*), ABISELECT(336,228), "S20624C15");
    check_field_offset(lv, s20624c15f0, ABISELECT(544,372), "S20624C15.s20624c15f0");
    check_field_offset(lv, s20624c15f1, ABISELECT(560,384), "S20624C15.s20624c15f1");
    check_field_offset(lv, s20624c15f2, ABISELECT(576,396), "S20624C15.s20624c15f2");
    check_field_offset(lv, s20624c15f3, ABISELECT(584,400), "S20624C15.s20624c15f3");
    check_field_offset(lv, s20624c15f4, ABISELECT(592,404), "S20624C15.s20624c15f4");
    check_field_offset(lv, s20624c15f5, ABISELECT(608,412), "S20624C15.s20624c15f5");
    check_field_offset(lv, s20624c15f6, ABISELECT(640,432), "S20624C15.s20624c15f6");
    check_field_offset(lv, s20624c15f7, ABISELECT(648,436), "S20624C15.s20624c15f7");
    check_field_offset(lv, s20624c15f8, ABISELECT(728,476), "S20624C15.s20624c15f8");
    check_field_offset(lv, s20624c15f9, ABISELECT(736,480), "S20624C15.s20624c15f9");
    check_field_offset(lv, s20624c15f10, ABISELECT(1056,696), "S20624C15.s20624c15f10");
    test_class_info(&lv, &cd_S20624C15);
    dp->~S20624C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20624C15(Test_S20624C15, "S20624C15", ABISELECT(1392,916));

#else // __cplusplus

extern void _ZN9S20624C15C1Ev();
extern void _ZN9S20624C15D2Ev();
Name_Map name_map_S20624C15[] = {
  NSPAIR(_ZN9S20624C15C1Ev),
  NSPAIR(_ZN9S20624C15D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C4;
extern VTBL_ENTRY _ZTI8S20624C4[];
extern  VTBL_ENTRY _ZTV8S20624C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C4[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C12;
extern VTBL_ENTRY _ZTI9S20624C12[];
extern  VTBL_ENTRY _ZTV9S20624C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C12[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
static Base_Class bases_S20624C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C4_nt,    ABISELECT(288,204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C4_nt,    ABISELECT(1060,700), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S20624C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20624C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C4_nt,    ABISELECT(304,208), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(304,208), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20624C5,    ABISELECT(1072,704), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(1280,848), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(1280,848), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20624C12,    ABISELECT(1072,704), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20624C5,    ABISELECT(336,228), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20624C15[];
extern void _ZN8S20624C42v2Ev();
extern void _ZN9S20624C15D1Ev();
extern void _ZN9S20624C15D0Ev();
extern void _ZN9S20624C152v3Ev();
extern void _ZN9S20624C152v4Ev();
static  VTBL_ENTRY vtc_S20624C15[] = {
  ABISELECT(1072,704),
  ABISELECT(1060,700),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C15[0]),
  (VTBL_ENTRY)&_ZN8S20624C42v2Ev,
  (VTBL_ENTRY)&_ZN9S20624C15D1Ev,
  (VTBL_ENTRY)&_ZN9S20624C15D0Ev,
  (VTBL_ENTRY)&_ZN9S20624C152v3Ev,
  (VTBL_ENTRY)&_ZN9S20624C152v4Ev,
  ABISELECT(724,472),
  ABISELECT(-336,-228),
  (VTBL_ENTRY)&(_ZTI9S20624C15[0]),
  ABISELECT(-12,-4),
  ABISELECT(-1072,-704),
  (VTBL_ENTRY)&(_ZTI9S20624C15[0]),
};
extern VTBL_ENTRY _ZTV9S20624C15[];
extern void _ZN8S20624C42v2Ev();
static  VTBL_ENTRY _tg__ZTV8S20624C4__9S20624C15[] = {
  ABISELECT(1060,700),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C4[0]),
  (VTBL_ENTRY)&_ZN8S20624C42v2Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20624C58S20624C4__9S20624C15[] = {
  ABISELECT(1060,700),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C5__A2__9S20624C15[] = {
  ABISELECT(724,472),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C12__9S20624C15[] = {
  ABISELECT(-12,-4),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C12__A1__9S20624C15[] = {
  ABISELECT(-12,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTT_ENTRY vtt_S20624C15[] = {
  {&(_ZTV9S20624C15[4]),  4,15},
  {&(_tg__ZTV8S20624C4__9S20624C15[3]),  3,4},
  {&(_tg__ZTV8S20624C58S20624C4__9S20624C15[3]),  3,3},
  {&(_tg__ZTV8S20624C5__A2__9S20624C15[3]),  3,3},
  {&(_ZTV9S20624C15[15]),  15,15},
  {&(_ZTV9S20624C15[12]),  12,15},
  {&(_tg__ZTV9S20624C12__9S20624C15[3]),  3,3},
  {&(_tg__ZTV8S20624C59S20624C12__A1__9S20624C15[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20624C15[];
extern  VTBL_ENTRY _ZTV9S20624C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C15[];
Class_Descriptor cd_S20624C15 = {  "S20624C15", // class name
  bases_S20624C15, 13,
  &(vtc_S20624C15[0]), // expected_vtbl_contents
  &(vtt_S20624C15[0]), // expected_vtt_contents
  ABISELECT(1392,916), // object size
  NSPAIRA(_ZTI9S20624C15),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S20624C15),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20624C15),8, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20624C14  : S20624C12 , S20624C8 , S20624C5 , virtual S20624C15 {
  short s20624c14f0;
  short s20624c14f1;
  ::S20624C8 s20624c14f2[5];
  __tsi64 s20624c14f3;
  long double s20624c14f4;
  __tsi64 s20624c14f5;
  int s20624c14f6;
  int s20624c14f7;
  void *s20624c14f8;
  virtual  ~S20624C14(); // _ZN9S20624C14D2Ev
  virtual void  v5(); // _ZN9S20624C142v5Ev
  virtual void  v6(); // _ZN9S20624C142v6Ev
  S20624C14(); // tgen
};
//SIG(-1 S20624C14) C1{ BC2{ VBC3{ m Fi} BC4{ VBC3 Fp FL Fi Fp Fi FU5{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC3 FC6{ BC3 Fi FU7{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC6 FL FU7 Fp Fp FC8{} Fi Fi Fp Fc FC8} BC6 BC4 VBC9{ BC3 BC10{ BC4 BC6 v3 Fi FL Fi FL FC3 Fi Fs Fi} BC6 VBC2 BC4 vd v4 v5 FU7 FD Fc Fp FL FC6 Fi Fp[10] Fi FC2 Fi} vd v1 v2 Fs Fs FC6[5] FL FD FL Fi Fi Fp}


 S20624C14 ::~S20624C14(){ note_dtor("S20624C14", this);}
void  S20624C14 ::v5(){vfunc_called(this, "_ZN9S20624C142v5Ev");}
void  S20624C14 ::v6(){vfunc_called(this, "_ZN9S20624C142v6Ev");}
S20624C14 ::S20624C14(){ note_ctor("S20624C14", this);} // tgen

static void Test_S20624C14()
{
  extern Class_Descriptor cd_S20624C14;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(137,360)];
    init_test(&cd_S20624C14, buf);
    S20624C14 *dp, &lv = *(dp=new (buf) S20624C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2176,1436), "sizeof(S20624C14)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20624C14)");
    /*is_ambiguous_... S20624C14::S20624C12 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C12*), ABISELECT(776,520), "S20624C14");
    /*is_ambiguous_... S20624C14::S20624C12 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C12*), ABISELECT(776,520), "S20624C14");
    /*is_ambiguous_... S20624C14::S20624C5 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*), ABISELECT(776,520), "S20624C14");
    check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C4*)(S20624C15*), ABISELECT(776,520), "S20624C14");
    /*is_ambiguous_... S20624C14::S20624C12 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C12*), ABISELECT(776,520), "S20624C14");
    /*is_ambiguous_... S20624C14::S20624C12 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C12*), ABISELECT(776,520), "S20624C14");
    /*is_ambiguous_... S20624C15::S20624C5 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C15*), ABISELECT(776,520), "S20624C14");
    /*is_ambiguous_... S20624C14::S20624C12 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C12*), 0, "S20624C14");
    /*is_ambiguous_... S20624C14::S20624C12 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C12*), ABISELECT(208,144), "S20624C14");
    /*is_ambiguous_... S20624C14::S20624C12 */ AMB_check_base_class_offset(lv, (S20624C8*)(S20624C12*), ABISELECT(208,144), "S20624C14");
    /*is_ambiguous_... S20624C14::S20624C12 */ AMB_check_base_class_offset(lv, (S20624C12*), 0, "S20624C14");
    /*is_ambiguous_... S20624C14::S20624C8 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*), ABISELECT(320,212), "S20624C14");
    /*is_ambiguous_... S20624C14::S20624C8 */ AMB_check_base_class_offset(lv, (S20624C8*), ABISELECT(320,212), "S20624C14");
    /*is_ambiguous_... S20624C14::S20624C5 */ AMB_check_base_class_offset(lv, (S20624C5*), ABISELECT(352,232), "S20624C14");
    /*is_ambiguous_... S20624C15::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C15*), ABISELECT(1072,728), "S20624C14");
    check_base_class_offset(lv, (S20624C5*)(S20624C4*)(S20624C15*), ABISELECT(784,524), "S20624C14");
    check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C4*)(S20624C15*), ABISELECT(992,668), "S20624C14");
    check_base_class_offset(lv, (S20624C8*)(S20624C4*)(S20624C15*), ABISELECT(992,668), "S20624C14");
    check_base_class_offset(lv, (S20624C4*)(S20624C15*), ABISELECT(784,524), "S20624C14");
    /*is_ambiguous_... S20624C15::S20624C8 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C15*), ABISELECT(1088,732), "S20624C14");
    /*is_ambiguous_... S20624C15::S20624C8 */ AMB_check_base_class_offset(lv, (S20624C8*)(S20624C15*), ABISELECT(1088,732), "S20624C14");
    /*is_ambiguous_... S20624C14::S20624C12 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C12*), ABISELECT(1856,1224), "S20624C14");
    /*is_ambiguous_... S20624C14::S20624C12 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C12*), ABISELECT(2064,1368), "S20624C14");
    /*is_ambiguous_... S20624C14::S20624C12 */ AMB_check_base_class_offset(lv, (S20624C8*)(S20624C12*), ABISELECT(2064,1368), "S20624C14");
    check_base_class_offset(lv, (S20624C12*)(S20624C15*), ABISELECT(1856,1224), "S20624C14");
    /*is_ambiguous_... S20624C15::S20624C5 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C15*), ABISELECT(1120,752), "S20624C14");
    check_base_class_offset(lv, (S20624C15*), ABISELECT(784,524), "S20624C14");
    check_field_offset(lv, s20624c14f0, ABISELECT(552,376), "S20624C14.s20624c14f0");
    check_field_offset(lv, s20624c14f1, ABISELECT(554,378), "S20624C14.s20624c14f1");
    check_field_offset(lv, s20624c14f2, ABISELECT(560,380), "S20624C14.s20624c14f2");
    check_field_offset(lv, s20624c14f3, ABISELECT(720,480), "S20624C14.s20624c14f3");
    check_field_offset(lv, s20624c14f4, ABISELECT(736,488), "S20624C14.s20624c14f4");
    check_field_offset(lv, s20624c14f5, ABISELECT(752,500), "S20624C14.s20624c14f5");
    check_field_offset(lv, s20624c14f6, ABISELECT(760,508), "S20624C14.s20624c14f6");
    check_field_offset(lv, s20624c14f7, ABISELECT(764,512), "S20624C14.s20624c14f7");
    check_field_offset(lv, s20624c14f8, ABISELECT(768,516), "S20624C14.s20624c14f8");
    test_class_info(&lv, &cd_S20624C14);
    dp->~S20624C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20624C14(Test_S20624C14, "S20624C14", ABISELECT(2176,1436));

#else // __cplusplus

extern void _ZN9S20624C14C1Ev();
extern void _ZN9S20624C14D2Ev();
Name_Map name_map_S20624C14[] = {
  NSPAIR(_ZN9S20624C14C1Ev),
  NSPAIR(_ZN9S20624C14D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C12;
extern VTBL_ENTRY _ZTI9S20624C12[];
extern  VTBL_ENTRY _ZTV9S20624C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C12[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C4;
extern VTBL_ENTRY _ZTI8S20624C4[];
extern  VTBL_ENTRY _ZTV8S20624C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C4[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C12;
extern VTBL_ENTRY _ZTI9S20624C12[];
extern  VTBL_ENTRY _ZTV9S20624C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C12[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S20624C15;
extern VTBL_ENTRY _ZTI9S20624C15[];
extern  VTBL_ENTRY _ZTV9S20624C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C15[];
static Base_Class bases_S20624C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C4_nt,    ABISELECT(776,520), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20624C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20624C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C4_nt,    ABISELECT(320,212), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(320,212), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20624C5,    ABISELECT(352,232), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C4_nt,    ABISELECT(1072,728), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S20624C5,    ABISELECT(784,524), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(992,668), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(992,668), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20624C4,    ABISELECT(784,524), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(1088,732), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(1088,732), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S20624C5,    ABISELECT(1856,1224), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(2064,1368), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(2064,1368), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20624C12,    ABISELECT(1856,1224), //bcp->offset
    28, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    20, //immediately_derived
  0, 1},
  {&cd_S20624C5,    ABISELECT(1120,752), //bcp->offset
    25, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S20624C15,    ABISELECT(784,524), //bcp->offset
    12, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20624C14[];
extern void _ZN9S20624C14D1Ev();
extern void _ZN9S20624C14D0Ev();
extern void _ZN9S20624C142v5Ev();
extern void _ZN9S20624C142v6Ev();
extern void _ZN8S20624C42v2Ev();
extern void ABISELECT(_ZTv0_n48_N9S20624C14D1Ev,_ZTv0_n24_N9S20624C14D1Ev)();
extern void ABISELECT(_ZThn784_N9S20624C14D1Ev,_ZThn524_N9S20624C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S20624C14D0Ev,_ZTv0_n24_N9S20624C14D0Ev)();
extern void ABISELECT(_ZThn784_N9S20624C14D0Ev,_ZThn524_N9S20624C14D0Ev)() __attribute__((weak));
extern void _ZN9S20624C152v3Ev();
extern void _ZN9S20624C152v4Ev();
static  VTBL_ENTRY vtc_S20624C14[] = {
  ABISELECT(1856,1224),
  ABISELECT(784,524),
  ABISELECT(776,520),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C14[0]),
  (VTBL_ENTRY)&_ZN9S20624C14D1Ev,
  (VTBL_ENTRY)&_ZN9S20624C14D0Ev,
  (VTBL_ENTRY)&_ZN9S20624C142v5Ev,
  (VTBL_ENTRY)&_ZN9S20624C142v6Ev,
  ABISELECT(424,288),
  ABISELECT(-352,-232),
  (VTBL_ENTRY)&(_ZTI9S20624C14[0]),
  0,
  0,
  ABISELECT(-784,-524),
  0,
  ABISELECT(1072,700),
  ABISELECT(-8,-4),
  ABISELECT(-784,-524),
  (VTBL_ENTRY)&(_ZTI9S20624C14[0]),
  (VTBL_ENTRY)&_ZN8S20624C42v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S20624C14D1Ev,_ZTv0_n24_N9S20624C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S20624C14D0Ev,_ZTv0_n24_N9S20624C14D0Ev),
  (VTBL_ENTRY)&_ZN9S20624C152v3Ev,
  (VTBL_ENTRY)&_ZN9S20624C152v4Ev,
  ABISELECT(-344,-232),
  ABISELECT(-1120,-752),
  (VTBL_ENTRY)&(_ZTI9S20624C14[0]),
  ABISELECT(-1080,-704),
  ABISELECT(-1856,-1224),
  (VTBL_ENTRY)&(_ZTI9S20624C14[0]),
};
extern VTBL_ENTRY _ZTV9S20624C14[];
static  VTBL_ENTRY _tg__ZTV9S20624C12__A__9S20624C14[] = {
  ABISELECT(776,520),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C12__9S20624C14[] = {
  ABISELECT(776,520),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C5__A1__9S20624C14[] = {
  ABISELECT(424,288),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
extern void _ZN8S20624C42v2Ev();
extern void _ZN9S20624C15D1Ev();
extern void _ZN9S20624C15D0Ev();
extern void _ZN9S20624C152v3Ev();
extern void _ZN9S20624C152v4Ev();
static  VTBL_ENTRY _tg__ZTV9S20624C15__9S20624C14[] = {
  ABISELECT(1072,700),
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C15[0]),
  (VTBL_ENTRY)&_ZN8S20624C42v2Ev,
  (VTBL_ENTRY)&_ZN9S20624C15D1Ev,
  (VTBL_ENTRY)&_ZN9S20624C15D0Ev,
  (VTBL_ENTRY)&_ZN9S20624C152v3Ev,
  (VTBL_ENTRY)&_ZN9S20624C152v4Ev,
};
extern void _ZN8S20624C42v2Ev();
static  VTBL_ENTRY _tg__ZTV8S20624C49S20624C15__9S20624C14[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C4[0]),
  (VTBL_ENTRY)&_ZN8S20624C42v2Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20624C58S20624C49S20624C15__A2__9S20624C14[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C15__A4__9S20624C14[] = {
  ABISELECT(-344,-232),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C12__9S20624C15__9S20624C14[] = {
  ABISELECT(-1080,-704),
  ABISELECT(-1072,-700),
  (VTBL_ENTRY)&(_ZTI9S20624C15[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C5__A2__9S20624C15__9S20624C14[] = {
  ABISELECT(-344,-232),
  ABISELECT(-336,-228),
  (VTBL_ENTRY)&(_ZTI9S20624C15[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C12__A1__9S20624C14[] = {
  ABISELECT(-1080,-704),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C12__A3__9S20624C14[] = {
  ABISELECT(-1080,-704),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTT_ENTRY vtt_S20624C14[] = {
  {&(_ZTV9S20624C14[5]),  5,31},
  {&(_tg__ZTV9S20624C12__A__9S20624C14[3]),  3,3},
  {&(_tg__ZTV8S20624C59S20624C12__9S20624C14[3]),  3,3},
  {&(_tg__ZTV8S20624C5__A1__9S20624C14[3]),  3,3},
  {&(_ZTV9S20624C14[12]),  12,31},
  {&(_ZTV9S20624C14[20]),  20,31},
  {&(_ZTV9S20624C14[31]),  31,31},
  {&(_ZTV9S20624C14[28]),  28,31},
  {&(_tg__ZTV9S20624C15__9S20624C14[4]),  4,9},
  {&(_tg__ZTV8S20624C49S20624C15__9S20624C14[3]),  3,4},
  {&(_tg__ZTV8S20624C58S20624C49S20624C15__A2__9S20624C14[3]),  3,3},
  {&(_tg__ZTV8S20624C59S20624C15__A4__9S20624C14[3]),  3,3},
  {&(_tg__ZTV9S20624C12__9S20624C15__9S20624C14[3]),  3,3},
  {&(_tg__ZTV8S20624C5__A2__9S20624C15__9S20624C14[3]),  3,3},
  {&(_tg__ZTV9S20624C12__A1__9S20624C14[3]),  3,3},
  {&(_tg__ZTV8S20624C59S20624C12__A3__9S20624C14[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20624C14[];
extern  VTBL_ENTRY _ZTV9S20624C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C14[];
static VTBL_ENTRY alt_thunk_names12[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S20624C14D0Ev,_ZTv0_n24_N9S20624C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn784_N9S20624C14D0Ev,_ZThn524_N9S20624C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S20624C14D1Ev,_ZTv0_n24_N9S20624C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn784_N9S20624C14D1Ev,_ZThn524_N9S20624C14D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20624C14 = {  "S20624C14", // class name
  bases_S20624C14, 21,
  &(vtc_S20624C14[0]), // expected_vtbl_contents
  &(vtt_S20624C14[0]), // expected_vtt_contents
  ABISELECT(2176,1436), // object size
  NSPAIRA(_ZTI9S20624C14),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S20624C14),31, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20624C14),16, //virtual table table var
  9, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names12,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20624C2  : virtual S19008C13 , S20624C10 , S20624C4 , S20624C14 {
  int s20624c2f0;
  int s20624c2f1;
  void *s20624c2f2;
  long double s20624c2f3[6];
  int s20624c2f4;
  int s20624c2f5;
  long double s20624c2f6;
  int s20624c2f7;
  int s20624c2f8;
  int s20624c2f9;
  virtual  ~S20624C2(); // _ZN8S20624C2D2Ev
  S20624C2(); // tgen
};
//SIG(-1 S20624C2) C1{ VBC2{ m Fi Fi:20 FC3{ BC4{ VBC5{ m Fi} Fp FL Fi Fp Fi FU6{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC5 FC7{ BC5 Fi FU8{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC7 v7 Fi FL Fi FL FC5 Fi Fs Fi} Fi Fc[4] Fi Fi Fi Fi Fi Fi Fi} BC9{ VBC10{ VBC5 BC11{ VBC5 Fp FL Fi Fp Fi FU6 Fc Fc FD FC5 FC12{ BC5 Fi FU8} Fp} BC13{ VBC5 BC11 BC12 FL FU8 Fp Fp FC14{} Fi Fi Fp Fc FC14} FC15{ BC11 BC12 v2 Fi FL Fi FL FC5 Fi Fs Fi} Fi[6] Fi FC5[7] Fi Fp[2]} v1 Fp[7] Fi Fs FD Fi FC15 Fi} BC15 BC16{ BC13 BC12 BC11 VBC17{ BC5 BC15 BC12 VBC13 BC11 vd v3 v4 FU8 FD Fc Fp FL FC12 Fi Fp[10] Fi FC13 Fi} vd v5 v6 Fs Fs FC12[5] FL FD FL Fi Fi Fp} vd Fi Fi Fp FD[6] Fi Fi FD Fi Fi Fi}


 S20624C2 ::~S20624C2(){ note_dtor("S20624C2", this);}
S20624C2 ::S20624C2(){ note_ctor("S20624C2", this);} // tgen

static void Test_S20624C2()
{
  extern Class_Descriptor cd_S20624C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(273,728)];
    init_test(&cd_S20624C2, buf);
    S20624C2 *dp, &lv = *(dp=new (buf) S20624C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(4352,2908), "sizeof(S20624C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20624C2)");
    check_base_class_offset(lv, (S19008C13*), ABISELECT(1664,1108), "S20624C2");
    /*is_ambiguous_... S20624C11::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C11*), ABISELECT(2944,1992), "S20624C2");
    /*is_ambiguous_... S20624C11::S20624C5 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C11*), ABISELECT(2944,1992), "S20624C2");
    /*is_ambiguous_... S20624C12::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C12*)(S20624C11*), ABISELECT(2944,1992), "S20624C2");
    check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C12*)(S20624C11*), ABISELECT(2944,1992), "S20624C2");
    /*is_ambiguous_... S20624C2::S20624C4 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C4*), ABISELECT(2944,1992), "S20624C2");
    /*is_ambiguous_... S20624C14::S20624C12 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C12*)(S20624C14*), ABISELECT(2944,1992), "S20624C2");
    /*is_ambiguous_... S20624C14::S20624C12 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C12*)(S20624C14*), ABISELECT(2944,1992), "S20624C2");
    /*is_ambiguous_... S20624C14::S20624C5 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C14*), ABISELECT(2944,1992), "S20624C2");
    check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C4*)(S20624C15*), ABISELECT(2944,1992), "S20624C2");
    /*is_ambiguous_... S20624C2::S20624C12 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C12*), ABISELECT(2944,1992), "S20624C2");
    /*is_ambiguous_... S20624C2::S20624C12 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C12*), ABISELECT(2944,1992), "S20624C2");
    /*is_ambiguous_... S20624C15::S20624C5 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C15*), ABISELECT(2944,1992), "S20624C2");
    /*is_ambiguous_... S20624C11::S20624C5 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C11*), ABISELECT(2032,1360), "S20624C2");
    check_base_class_offset(lv, (S20624C5*)(S20624C12*)(S20624C11*), ABISELECT(2240,1504), "S20624C2");
    check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C12*)(S20624C11*), ABISELECT(2448,1648), "S20624C2");
    check_base_class_offset(lv, (S20624C8*)(S20624C12*)(S20624C11*), ABISELECT(2448,1648), "S20624C2");
    check_base_class_offset(lv, (S20624C12*)(S20624C11*), ABISELECT(2240,1504), "S20624C2");
    check_base_class_offset(lv, (S20624C11*)(S20624C10*), ABISELECT(2032,1360), "S20624C2");
    check_base_class_offset(lv, (S20624C10*), 0, "S20624C2");
    /*is_ambiguous_... S20624C2::S20624C4 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C4*), ABISELECT(432,268), "S20624C2");
    /*is_ambiguous_... S20624C2::S20624C4 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C4*), ABISELECT(640,412), "S20624C2");
    /*is_ambiguous_... S20624C2::S20624C4 */ AMB_check_base_class_offset(lv, (S20624C8*)(S20624C4*), ABISELECT(640,412), "S20624C2");
    /*is_ambiguous_... S20624C2::S20624C4 */ AMB_check_base_class_offset(lv, (S20624C4*), ABISELECT(432,268), "S20624C2");
    /*is_ambiguous_... S20624C14::S20624C12 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C12*)(S20624C14*), ABISELECT(720,472), "S20624C2");
    /*is_ambiguous_... S20624C14::S20624C12 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C12*)(S20624C14*), ABISELECT(928,616), "S20624C2");
    /*is_ambiguous_... S20624C14::S20624C12 */ AMB_check_base_class_offset(lv, (S20624C8*)(S20624C12*)(S20624C14*), ABISELECT(928,616), "S20624C2");
    /*is_ambiguous_... S20624C14::S20624C12 */ AMB_check_base_class_offset(lv, (S20624C12*)(S20624C14*), ABISELECT(720,472), "S20624C2");
    /*is_ambiguous_... S20624C14::S20624C8 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C14*), ABISELECT(1040,684), "S20624C2");
    /*is_ambiguous_... S20624C14::S20624C8 */ AMB_check_base_class_offset(lv, (S20624C8*)(S20624C14*), ABISELECT(1040,684), "S20624C2");
    /*is_ambiguous_... S20624C14::S20624C5 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C14*), ABISELECT(1072,704), "S20624C2");
    /*is_ambiguous_... S20624C15::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C15*), ABISELECT(3248,2200), "S20624C2");
    check_base_class_offset(lv, (S20624C5*)(S20624C4*)(S20624C15*), ABISELECT(2960,1996), "S20624C2");
    check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C4*)(S20624C15*), ABISELECT(3168,2140), "S20624C2");
    check_base_class_offset(lv, (S20624C8*)(S20624C4*)(S20624C15*), ABISELECT(3168,2140), "S20624C2");
    check_base_class_offset(lv, (S20624C4*)(S20624C15*), ABISELECT(2960,1996), "S20624C2");
    /*is_ambiguous_... S20624C15::S20624C8 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C15*), ABISELECT(3264,2204), "S20624C2");
    /*is_ambiguous_... S20624C15::S20624C8 */ AMB_check_base_class_offset(lv, (S20624C8*)(S20624C15*), ABISELECT(3264,2204), "S20624C2");
    /*is_ambiguous_... S20624C2::S20624C12 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C12*), ABISELECT(4032,2696), "S20624C2");
    /*is_ambiguous_... S20624C2::S20624C12 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C12*), ABISELECT(4240,2840), "S20624C2");
    /*is_ambiguous_... S20624C2::S20624C12 */ AMB_check_base_class_offset(lv, (S20624C8*)(S20624C12*), ABISELECT(4240,2840), "S20624C2");
    check_base_class_offset(lv, (S20624C12*)(S20624C15*), ABISELECT(4032,2696), "S20624C2");
    /*is_ambiguous_... S20624C15::S20624C5 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C15*), ABISELECT(3296,2224), "S20624C2");
    check_base_class_offset(lv, (S20624C15*)(S20624C14*), ABISELECT(2960,1996), "S20624C2");
    check_base_class_offset(lv, (S20624C14*), ABISELECT(720,472), "S20624C2");
    check_field_offset(lv, s20624c2f0, ABISELECT(1496,992), "S20624C2.s20624c2f0");
    check_field_offset(lv, s20624c2f1, ABISELECT(1500,996), "S20624C2.s20624c2f1");
    check_field_offset(lv, s20624c2f2, ABISELECT(1504,1000), "S20624C2.s20624c2f2");
    check_field_offset(lv, s20624c2f3, ABISELECT(1520,1004), "S20624C2.s20624c2f3");
    check_field_offset(lv, s20624c2f4, ABISELECT(1616,1076), "S20624C2.s20624c2f4");
    check_field_offset(lv, s20624c2f5, ABISELECT(1620,1080), "S20624C2.s20624c2f5");
    check_field_offset(lv, s20624c2f6, ABISELECT(1632,1084), "S20624C2.s20624c2f6");
    check_field_offset(lv, s20624c2f7, ABISELECT(1648,1096), "S20624C2.s20624c2f7");
    check_field_offset(lv, s20624c2f8, ABISELECT(1652,1100), "S20624C2.s20624c2f8");
    check_field_offset(lv, s20624c2f9, ABISELECT(1656,1104), "S20624C2.s20624c2f9");
    test_class_info(&lv, &cd_S20624C2);
    dp->~S20624C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20624C2(Test_S20624C2, "S20624C2", ABISELECT(4352,2908));

#else // __cplusplus

extern void _ZN8S20624C2C1Ev();
extern void _ZN8S20624C2D2Ev();
Name_Map name_map_S20624C2[] = {
  NSPAIR(_ZN8S20624C2C1Ev),
  NSPAIR(_ZN8S20624C2D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C13;
extern VTBL_ENTRY _ZTI9S19008C13[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C12;
extern VTBL_ENTRY _ZTI9S20624C12[];
extern  VTBL_ENTRY _ZTV9S20624C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C12[];
extern Class_Descriptor cd_S20624C11;
extern VTBL_ENTRY _ZTI9S20624C11[];
extern  VTBL_ENTRY _ZTV9S20624C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C11[];
extern Class_Descriptor cd_S20624C10;
extern VTBL_ENTRY _ZTI9S20624C10[];
extern  VTBL_ENTRY _ZTV9S20624C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C10[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C4;
extern VTBL_ENTRY _ZTI8S20624C4[];
extern  VTBL_ENTRY _ZTV8S20624C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C4[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C12;
extern VTBL_ENTRY _ZTI9S20624C12[];
extern  VTBL_ENTRY _ZTV9S20624C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C12[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C4;
extern VTBL_ENTRY _ZTI8S20624C4[];
extern  VTBL_ENTRY _ZTV8S20624C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C4[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C12;
extern VTBL_ENTRY _ZTI9S20624C12[];
extern  VTBL_ENTRY _ZTV9S20624C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C12[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S20624C15;
extern VTBL_ENTRY _ZTI9S20624C15[];
extern  VTBL_ENTRY _ZTV9S20624C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C15[];
extern Class_Descriptor cd_S20624C14;
extern VTBL_ENTRY _ZTI9S20624C14[];
extern  VTBL_ENTRY _ZTV9S20624C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C14[];
static Base_Class bases_S20624C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C13,    ABISELECT(1664,1108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19008C4_nt,    ABISELECT(2944,1992), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S20624C5,    ABISELECT(2032,1360), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20624C5,    ABISELECT(2240,1504), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(2448,1648), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(2448,1648), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20624C12,    ABISELECT(2240,1504), //bcp->offset
    29, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20624C11,    ABISELECT(2032,1360), //bcp->offset
    26, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S20624C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20624C5,    ABISELECT(432,268), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(640,412), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(640,412), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20624C4,    ABISELECT(432,268), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20624C5,    ABISELECT(720,472), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(928,616), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(928,616), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20624C12,    ABISELECT(720,472), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(1040,684), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(1040,684), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S20624C5,    ABISELECT(1072,704), //bcp->offset
    23, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(3248,2200), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S20624C5,    ABISELECT(2960,1996), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    30, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(3168,2140), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(3168,2140), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S20624C4,    ABISELECT(2960,1996), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    29, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(3264,2204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(3264,2204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S20624C5,    ABISELECT(4032,2696), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(4240,2840), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(4240,2840), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S20624C12,    ABISELECT(4032,2696), //bcp->offset
    48, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    32, //immediately_derived
  0, 1},
  {&cd_S20624C5,    ABISELECT(3296,2224), //bcp->offset
    45, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    31, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S20624C15,    ABISELECT(2960,1996), //bcp->offset
    32, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    33, //immediately_derived
  0, 1},
  {&cd_S20624C14,    ABISELECT(720,472), //bcp->offset
    14, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20624C2[];
extern void _ZN9S20624C102v1Ev();
extern void _ZN8S20624C2D1Ev();
extern void _ZN8S20624C2D0Ev();
extern void _ZN8S20624C42v2Ev();
extern void ABISELECT(_ZThn720_N8S20624C2D1Ev,_ZThn472_N8S20624C2D1Ev)();
extern void ABISELECT(_ZThn720_N8S20624C2D0Ev,_ZThn472_N8S20624C2D0Ev)();
extern void _ZN9S20624C142v5Ev();
extern void _ZN9S20624C142v6Ev();
extern void _ZN8S20624C42v2Ev();
extern void ABISELECT(_ZTv0_n48_N8S20624C2D1Ev,_ZTv0_n24_N8S20624C2D1Ev)();
extern void ABISELECT(_ZThn2960_N8S20624C2D1Ev,_ZThn1996_N8S20624C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S20624C2D0Ev,_ZTv0_n24_N8S20624C2D0Ev)();
extern void ABISELECT(_ZThn2960_N8S20624C2D0Ev,_ZThn1996_N8S20624C2D0Ev)() __attribute__((weak));
extern void _ZN9S20624C152v3Ev();
extern void _ZN9S20624C152v4Ev();
static  VTBL_ENTRY vtc_S20624C2[] = {
  ABISELECT(4032,2696),
  ABISELECT(2960,1996),
  ABISELECT(1664,1108),
  ABISELECT(2944,1992),
  ABISELECT(2032,1360),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C2[0]),
  (VTBL_ENTRY)&_ZN9S20624C102v1Ev,
  (VTBL_ENTRY)&_ZN8S20624C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20624C2D0Ev,
  ABISELECT(2512,1724),
  ABISELECT(-432,-268),
  (VTBL_ENTRY)&(_ZTI8S20624C2[0]),
  (VTBL_ENTRY)&_ZN8S20624C42v2Ev,
  ABISELECT(3312,2224),
  ABISELECT(2240,1524),
  ABISELECT(2224,1520),
  ABISELECT(-720,-472),
  (VTBL_ENTRY)&(_ZTI8S20624C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn720_N8S20624C2D1Ev,_ZThn472_N8S20624C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn720_N8S20624C2D0Ev,_ZThn472_N8S20624C2D0Ev),
  (VTBL_ENTRY)&_ZN9S20624C142v5Ev,
  (VTBL_ENTRY)&_ZN9S20624C142v6Ev,
  ABISELECT(1872,1288),
  ABISELECT(-1072,-704),
  (VTBL_ENTRY)&(_ZTI8S20624C2[0]),
  ABISELECT(912,632),
  ABISELECT(-2032,-1360),
  (VTBL_ENTRY)&(_ZTI8S20624C2[0]),
  ABISELECT(704,488),
  ABISELECT(-2240,-1504),
  (VTBL_ENTRY)&(_ZTI8S20624C2[0]),
  0,
  0,
  ABISELECT(-2960,-1996),
  0,
  ABISELECT(1072,700),
  ABISELECT(-16,-4),
  ABISELECT(-2960,-1996),
  (VTBL_ENTRY)&(_ZTI8S20624C2[0]),
  (VTBL_ENTRY)&_ZN8S20624C42v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S20624C2D1Ev,_ZTv0_n24_N8S20624C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S20624C2D0Ev,_ZTv0_n24_N8S20624C2D0Ev),
  (VTBL_ENTRY)&_ZN9S20624C152v3Ev,
  (VTBL_ENTRY)&_ZN9S20624C152v4Ev,
  ABISELECT(-352,-232),
  ABISELECT(-3296,-2224),
  (VTBL_ENTRY)&(_ZTI8S20624C2[0]),
  ABISELECT(-1088,-704),
  ABISELECT(-4032,-2696),
  (VTBL_ENTRY)&(_ZTI8S20624C2[0]),
};
extern VTBL_ENTRY _ZTV8S20624C2[];
extern void _ZN9S20624C102v1Ev();
static  VTBL_ENTRY _tg__ZTV9S20624C10__8S20624C2[] = {
  ABISELECT(2944,1992),
  ABISELECT(2032,1360),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C10[0]),
  (VTBL_ENTRY)&_ZN9S20624C102v1Ev,
};
static  VTBL_ENTRY _tg__ZTV9S20624C11__9S20624C10__8S20624C2[] = {
  ABISELECT(912,632),
  ABISELECT(-2032,-1360),
  (VTBL_ENTRY)&(_ZTI9S20624C10[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C129S20624C11__9S20624C10__8S20624C2[] = {
  ABISELECT(704,488),
  ABISELECT(-2240,-1504),
  (VTBL_ENTRY)&(_ZTI9S20624C10[0]),
};
extern void _ZN8S20624C42v2Ev();
static  VTBL_ENTRY _tg__ZTV8S20624C4__8S20624C2[] = {
  ABISELECT(2512,1724),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C4[0]),
  (VTBL_ENTRY)&_ZN8S20624C42v2Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20624C58S20624C4__A2__8S20624C2[] = {
  ABISELECT(2512,1724),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
extern void _ZN9S20624C14D1Ev();
extern void _ZN9S20624C14D0Ev();
extern void _ZN9S20624C142v5Ev();
extern void _ZN9S20624C142v6Ev();
static  VTBL_ENTRY _tg__ZTV9S20624C14__8S20624C2[] = {
  ABISELECT(3312,2224),
  ABISELECT(2240,1524),
  ABISELECT(2224,1520),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C14[0]),
  (VTBL_ENTRY)&_ZN9S20624C14D1Ev,
  (VTBL_ENTRY)&_ZN9S20624C14D0Ev,
  (VTBL_ENTRY)&_ZN9S20624C142v5Ev,
  (VTBL_ENTRY)&_ZN9S20624C142v6Ev,
};
static  VTBL_ENTRY _tg__ZTV9S20624C129S20624C14__A1__8S20624C2[] = {
  ABISELECT(2224,1520),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C129S20624C14__A3__8S20624C2[] = {
  ABISELECT(2224,1520),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C14__A4__8S20624C2[] = {
  ABISELECT(1872,1288),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C5__A1__9S20624C14__8S20624C2[] = {
  ABISELECT(1872,1288),
  ABISELECT(-352,-232),
  (VTBL_ENTRY)&(_ZTI9S20624C14[0]),
};
extern void _ZN8S20624C42v2Ev();
extern void ABISELECT(_ZTv0_n48_N9S20624C14D1Ev,_ZTv0_n24_N9S20624C14D1Ev)();
extern void ABISELECT(_ZThn2240_N9S20624C14D1Ev,_ZThn1524_N9S20624C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S20624C14D0Ev,_ZTv0_n24_N9S20624C14D0Ev)();
extern void ABISELECT(_ZThn2240_N9S20624C14D0Ev,_ZThn1524_N9S20624C14D0Ev)() __attribute__((weak));
extern void _ZN9S20624C152v3Ev();
extern void _ZN9S20624C152v4Ev();
static  VTBL_ENTRY _tg__ZTV9S20624C15__9S20624C14__8S20624C2[] = {
  0,
  0,
  ABISELECT(-2240,-1524),
  0,
  ABISELECT(1072,700),
  ABISELECT(-16,-4),
  ABISELECT(-2240,-1524),
  (VTBL_ENTRY)&(_ZTI9S20624C14[0]),
  (VTBL_ENTRY)&_ZN8S20624C42v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S20624C14D1Ev,_ZTv0_n24_N9S20624C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S20624C14D0Ev,_ZTv0_n24_N9S20624C14D0Ev),
  (VTBL_ENTRY)&_ZN9S20624C152v3Ev,
  (VTBL_ENTRY)&_ZN9S20624C152v4Ev,
};
static  VTBL_ENTRY _tg__ZTV9S20624C12__A1__9S20624C14__8S20624C2[] = {
  ABISELECT(-1088,-704),
  ABISELECT(-3312,-2224),
  (VTBL_ENTRY)&(_ZTI9S20624C14[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C15__A4__9S20624C14__8S20624C2[] = {
  ABISELECT(-352,-232),
  ABISELECT(-2576,-1752),
  (VTBL_ENTRY)&(_ZTI9S20624C14[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C11__8S20624C2[] = {
  ABISELECT(912,632),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C11[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C11__8S20624C2[] = {
  ABISELECT(912,632),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C129S20624C11__8S20624C2[] = {
  ABISELECT(704,488),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C129S20624C11__A1__8S20624C2[] = {
  ABISELECT(704,488),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C12__9S20624C11__8S20624C2[] = {
  ABISELECT(704,488),
  ABISELECT(-208,-144),
  (VTBL_ENTRY)&(_ZTI9S20624C11[0]),
};
extern void _ZN8S20624C42v2Ev();
extern void _ZN9S20624C15D1Ev();
extern void _ZN9S20624C15D0Ev();
extern void _ZN9S20624C152v3Ev();
extern void _ZN9S20624C152v4Ev();
static  VTBL_ENTRY _tg__ZTV9S20624C15__8S20624C2[] = {
  ABISELECT(1072,700),
  ABISELECT(-16,-4),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C15[0]),
  (VTBL_ENTRY)&_ZN8S20624C42v2Ev,
  (VTBL_ENTRY)&_ZN9S20624C15D1Ev,
  (VTBL_ENTRY)&_ZN9S20624C15D0Ev,
  (VTBL_ENTRY)&_ZN9S20624C152v3Ev,
  (VTBL_ENTRY)&_ZN9S20624C152v4Ev,
};
extern void _ZN8S20624C42v2Ev();
static  VTBL_ENTRY _tg__ZTV8S20624C49S20624C15__A1__8S20624C2[] = {
  ABISELECT(-16,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C4[0]),
  (VTBL_ENTRY)&_ZN8S20624C42v2Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20624C58S20624C49S20624C15__A5__8S20624C2[] = {
  ABISELECT(-16,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C15__A7__8S20624C2[] = {
  ABISELECT(-352,-232),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C12__9S20624C15__8S20624C2[] = {
  ABISELECT(-1088,-704),
  ABISELECT(-1072,-700),
  (VTBL_ENTRY)&(_ZTI9S20624C15[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C5__A2__9S20624C15__8S20624C2[] = {
  ABISELECT(-352,-232),
  ABISELECT(-336,-228),
  (VTBL_ENTRY)&(_ZTI9S20624C15[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C12__A2__8S20624C2[] = {
  ABISELECT(-1088,-704),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C12__A6__8S20624C2[] = {
  ABISELECT(-1088,-704),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTT_ENTRY vtt_S20624C2[] = {
  {&(_ZTV8S20624C2[7]),  7,51},
  {&(_tg__ZTV9S20624C10__8S20624C2[4]),  4,5},
  {&(_tg__ZTV9S20624C11__9S20624C10__8S20624C2[3]),  3,3},
  {&(_tg__ZTV9S20624C129S20624C11__9S20624C10__8S20624C2[3]),  3,3},
  {&(_tg__ZTV8S20624C4__8S20624C2[3]),  3,4},
  {&(_tg__ZTV8S20624C58S20624C4__A2__8S20624C2[3]),  3,3},
  {&(_tg__ZTV9S20624C14__8S20624C2[5]),  5,9},
  {&(_tg__ZTV9S20624C129S20624C14__A1__8S20624C2[3]),  3,3},
  {&(_tg__ZTV8S20624C59S20624C129S20624C14__A3__8S20624C2[3]),  3,3},
  {&(_tg__ZTV8S20624C59S20624C14__A4__8S20624C2[3]),  3,3},
  {&(_tg__ZTV8S20624C5__A1__9S20624C14__8S20624C2[3]),  3,3},
  {&(_tg__ZTV9S20624C15__9S20624C14__8S20624C2[8]),  8,13},
  {&(_tg__ZTV9S20624C12__A1__9S20624C14__8S20624C2[3]),  3,3},
  {&(_tg__ZTV8S20624C59S20624C15__A4__9S20624C14__8S20624C2[3]),  3,3},
  {&(_ZTV8S20624C2[29]),  29,51},
  {&(_ZTV8S20624C2[32]),  32,51},
  {&(_ZTV8S20624C2[13]),  13,51},
  {&(_ZTV8S20624C2[19]),  19,51},
  {&(_ZTV8S20624C2[26]),  26,51},
  {&(_ZTV8S20624C2[40]),  40,51},
  {&(_ZTV8S20624C2[51]),  51,51},
  {&(_ZTV8S20624C2[48]),  48,51},
  {&(_tg__ZTV9S20624C11__8S20624C2[3]),  3,3},
  {&(_tg__ZTV8S20624C59S20624C11__8S20624C2[3]),  3,3},
  {&(_tg__ZTV9S20624C129S20624C11__8S20624C2[3]),  3,3},
  {&(_tg__ZTV8S20624C59S20624C129S20624C11__A1__8S20624C2[3]),  3,3},
  {&(_tg__ZTV9S20624C12__9S20624C11__8S20624C2[3]),  3,3},
  {&(_tg__ZTV9S20624C15__8S20624C2[4]),  4,9},
  {&(_tg__ZTV8S20624C49S20624C15__A1__8S20624C2[3]),  3,4},
  {&(_tg__ZTV8S20624C58S20624C49S20624C15__A5__8S20624C2[3]),  3,3},
  {&(_tg__ZTV8S20624C59S20624C15__A7__8S20624C2[3]),  3,3},
  {&(_tg__ZTV9S20624C12__9S20624C15__8S20624C2[3]),  3,3},
  {&(_tg__ZTV8S20624C5__A2__9S20624C15__8S20624C2[3]),  3,3},
  {&(_tg__ZTV9S20624C12__A2__8S20624C2[3]),  3,3},
  {&(_tg__ZTV8S20624C59S20624C12__A6__8S20624C2[3]),  3,3},
};
extern VTBL_ENTRY _ZTI8S20624C2[];
extern  VTBL_ENTRY _ZTV8S20624C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C2[];
static VTBL_ENTRY alt_thunk_names13[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S20624C14D0Ev,_ZTv0_n24_N9S20624C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2240_N9S20624C14D0Ev,_ZThn1524_N9S20624C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S20624C14D1Ev,_ZTv0_n24_N9S20624C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2240_N9S20624C14D1Ev,_ZThn1524_N9S20624C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S20624C2D0Ev,_ZTv0_n24_N8S20624C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2960_N8S20624C2D0Ev,_ZThn1996_N8S20624C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S20624C2D1Ev,_ZTv0_n24_N8S20624C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2960_N8S20624C2D1Ev,_ZThn1996_N8S20624C2D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20624C2 = {  "S20624C2", // class name
  bases_S20624C2, 34,
  &(vtc_S20624C2[0]), // expected_vtbl_contents
  &(vtt_S20624C2[0]), // expected_vtt_contents
  ABISELECT(4352,2908), // object size
  NSPAIRA(_ZTI8S20624C2),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S20624C2),51, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20624C2),35, //virtual table table var
  17, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names13,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20624C16  {
  void *s20624c16f0;
  int s20624c16f1;
  int s20624c16f2;
  ::S19008C4_nt s20624c16f3;
  void *s20624c16f4;
  long double s20624c16f5;
  int s20624c16f6;
  ::S20624C15 s20624c16f7;
  void *s20624c16f8[8];
  void *s20624c16f9[6];
  virtual void  v7(); // _ZN9S20624C162v7Ev
  ~S20624C16(); // tgen
  S20624C16(); // tgen
};
//SIG(-1 S20624C16) C1{ v1 Fp Fi[2] FC2{ m Fi} Fp FD Fi FC3{ BC2 BC4{ BC5{ VBC2 Fp FL Fi Fp Fi FU6{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC2 FC7{ BC2 Fi FU8{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC7 v4 Fi FL Fi FL FC2 Fi Fs Fi} BC7 VBC9{ VBC2 BC5 BC7 FL FU8 Fp Fp FC10{} Fi Fi Fp Fc FC10} BC5 vd v2 v3 FU8 FD Fc Fp FL FC7 Fi Fp[10] Fi FC9 Fi} Fp[8] Fp[6]}


void  S20624C16 ::v7(){vfunc_called(this, "_ZN9S20624C162v7Ev");}
S20624C16 ::~S20624C16(){ note_dtor("S20624C16", this);} // tgen
S20624C16 ::S20624C16(){ note_ctor("S20624C16", this);} // tgen

static void Test_S20624C16()
{
  extern Class_Descriptor cd_S20624C16;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(100,254)];
    init_test(&cd_S20624C16, buf);
    S20624C16 *dp, &lv = *(dp=new (buf) S20624C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1584,1012), "sizeof(S20624C16)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20624C16)");
    check_field_offset(lv, s20624c16f0, ABISELECT(8,4), "S20624C16.s20624c16f0");
    check_field_offset(lv, s20624c16f1, ABISELECT(16,8), "S20624C16.s20624c16f1");
    check_field_offset(lv, s20624c16f2, ABISELECT(20,12), "S20624C16.s20624c16f2");
    check_field_offset(lv, s20624c16f3, ABISELECT(24,16), "S20624C16.s20624c16f3");
    check_field_offset(lv, s20624c16f4, ABISELECT(32,20), "S20624C16.s20624c16f4");
    check_field_offset(lv, s20624c16f5, ABISELECT(48,24), "S20624C16.s20624c16f5");
    check_field_offset(lv, s20624c16f6, ABISELECT(64,36), "S20624C16.s20624c16f6");
    check_field_offset(lv, s20624c16f7, ABISELECT(80,40), "S20624C16.s20624c16f7");
    check_field_offset(lv, s20624c16f8, ABISELECT(1472,956), "S20624C16.s20624c16f8");
    check_field_offset(lv, s20624c16f9, ABISELECT(1536,988), "S20624C16.s20624c16f9");
    test_class_info(&lv, &cd_S20624C16);
    dp->~S20624C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20624C16(Test_S20624C16, "S20624C16", ABISELECT(1584,1012));

#else // __cplusplus

extern void _ZN9S20624C16C1Ev();
extern void _ZN9S20624C16D1Ev();
Name_Map name_map_S20624C16[] = {
  NSPAIR(_ZN9S20624C16C1Ev),
  NSPAIR(_ZN9S20624C16D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S20624C16[];
extern void _ZN9S20624C162v7Ev();
static  VTBL_ENTRY vtc_S20624C16[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C16[0]),
  (VTBL_ENTRY)&_ZN9S20624C162v7Ev,
};
extern VTBL_ENTRY _ZTI9S20624C16[];
extern  VTBL_ENTRY _ZTV9S20624C16[];
Class_Descriptor cd_S20624C16 = {  "S20624C16", // class name
  0,0,//no base classes
  &(vtc_S20624C16[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1584,1012), // object size
  NSPAIRA(_ZTI9S20624C16),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S20624C16),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20624C19  : S20624C15 , S20624C5 , S19008C13 , virtual S20624C2 {
  int s20624c19f0;
  __tsi64 s20624c19f1;
  ::S19008C7 s20624c19f2;
  int s20624c19f3;
  int s20624c19f4;
  ::S19008C11_nt s20624c19f5;
  ::S20624C15 s20624c19f6;
  virtual  ~S20624C19(); // _ZN9S20624C19D2Ev
  S20624C19(); // tgen
};
//SIG(-1 S20624C19) C1{ BC2{ BC3{ m Fi} BC4{ BC5{ VBC3 Fp FL Fi Fp Fi FU6{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC3 FC7{ BC3 Fi FU8{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC7 v1 Fi FL Fi FL FC3 Fi Fs Fi} BC7 VBC9{ VBC3 BC5 BC7 FL FU8 Fp Fp FC10{} Fi Fi Fp Fc FC10} BC5 vd v2 v3 FU8 FD Fc Fp FL FC7 Fi Fp[10] Fi FC9 Fi} BC5 BC11{ m Fi Fi:20 FC12{ BC13{ VBC3 Fp FL Fi Fp Fi FU6 Fc Fc FD FC3 FC14{ BC3 Fi FU8} Fp} BC14 v7 Fi FL Fi FL FC3 Fi Fs Fi} Fi Fc[4] Fi Fi Fi Fi Fi Fi Fi} VBC15{ VBC11 BC16{ VBC17{ VBC3 BC5 BC9 FC4 Fi[6] Fi FC3[7] Fi Fp[2]} v4 Fp[7] Fi Fs FD Fi FC4 Fi} BC4 BC18{ BC9 BC7 BC5 VBC2 vd v5 v6 Fs Fs FC7[5] FL FD FL Fi Fi Fp} vd Fi Fi Fp FD[6] Fi Fi FD Fi Fi Fi} vd Fi FL FU6 Fi Fi FC10 FC2}


 S20624C19 ::~S20624C19(){ note_dtor("S20624C19", this);}
S20624C19 ::S20624C19(){ note_ctor("S20624C19", this);} // tgen

static void Test_S20624C19()
{
  extern Class_Descriptor cd_S20624C19;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(469,1255)];
    init_test(&cd_S20624C19, buf);
    S20624C19 *dp, &lv = *(dp=new (buf) S20624C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(7488,5016), "sizeof(S20624C19)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20624C19)");
    /*is_ambiguous_... S20624C19::S20624C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C15*), ABISELECT(288,204), "S20624C19");
    /*is_ambiguous_... S20624C19::S20624C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C4*)(S20624C15*), ABISELECT(3136,2108), "S20624C19");
    /*is_ambiguous_... S20624C19::S20624C12 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C12*), ABISELECT(3136,2108), "S20624C19");
    /*is_ambiguous_... S20624C19::S20624C12 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C12*), ABISELECT(3136,2108), "S20624C19");
    /*is_ambiguous_... S20624C19::S20624C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C15*), ABISELECT(3136,2108), "S20624C19");
    /*is_ambiguous_... S20624C19::S20624C5 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*), ABISELECT(3136,2108), "S20624C19");
    /*is_ambiguous_... S20624C11::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C11*), ABISELECT(3136,2108), "S20624C19");
    /*is_ambiguous_... S20624C11::S20624C5 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C11*), ABISELECT(3136,2108), "S20624C19");
    /*is_ambiguous_... S20624C12::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C12*)(S20624C11*), ABISELECT(3136,2108), "S20624C19");
    check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C12*)(S20624C11*), ABISELECT(3136,2108), "S20624C19");
    /*is_ambiguous_... S20624C2::S20624C4 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C4*)(S20624C2*), ABISELECT(3136,2108), "S20624C19");
    /*is_ambiguous_... S20624C14::S20624C12 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C12*)(S20624C14*)(S20624C2*), ABISELECT(3136,2108), "S20624C19");
    /*is_ambiguous_... S20624C14::S20624C12 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C12*)(S20624C14*)(S20624C2*), ABISELECT(3136,2108), "S20624C19");
    /*is_ambiguous_... S20624C14::S20624C5 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C14*)(S20624C2*), ABISELECT(3136,2108), "S20624C19");
    /*is_ambiguous_... S20624C19::S20624C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C4*)(S20624C15*), ABISELECT(3136,2108), "S20624C19");
    /*is_ambiguous_... S20624C19::S20624C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C15*), ABISELECT(3136,2108), "S20624C19");
    /*is_ambiguous_... S20624C19::S20624C15 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C4*)(S20624C15*), 0, "S20624C19");
    /*is_ambiguous_... S20624C19::S20624C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C4*)(S20624C15*), ABISELECT(208,144), "S20624C19");
    /*is_ambiguous_... S20624C19::S20624C15 */ AMB_check_base_class_offset(lv, (S20624C8*)(S20624C4*)(S20624C15*), ABISELECT(208,144), "S20624C19");
    /*is_ambiguous_... S20624C19::S20624C15 */ AMB_check_base_class_offset(lv, (S20624C4*)(S20624C15*), 0, "S20624C19");
    /*is_ambiguous_... S20624C19::S20624C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C15*), ABISELECT(304,208), "S20624C19");
    /*is_ambiguous_... S20624C19::S20624C15 */ AMB_check_base_class_offset(lv, (S20624C8*)(S20624C15*), ABISELECT(304,208), "S20624C19");
    /*is_ambiguous_... S20624C19::S20624C12 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C12*), ABISELECT(3152,2112), "S20624C19");
    /*is_ambiguous_... S20624C19::S20624C12 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C12*), ABISELECT(3360,2256), "S20624C19");
    /*is_ambiguous_... S20624C19::S20624C12 */ AMB_check_base_class_offset(lv, (S20624C8*)(S20624C12*), ABISELECT(3360,2256), "S20624C19");
    /*is_ambiguous_... S20624C19::S20624C15 */ AMB_check_base_class_offset(lv, (S20624C12*)(S20624C15*), ABISELECT(3152,2112), "S20624C19");
    /*is_ambiguous_... S20624C19::S20624C15 */ AMB_check_base_class_offset(lv, (S20624C12*)(S20624C15*), ABISELECT(3152,2112), "S20624C19");
    /*is_ambiguous_... S20624C19::S20624C15 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C15*), ABISELECT(336,228), "S20624C19");
    /*is_ambiguous_... S20624C19::S20624C15 */ AMB_check_base_class_offset(lv, (S20624C15*), 0, "S20624C19");
    /*is_ambiguous_... S20624C19::S20624C5 */ AMB_check_base_class_offset(lv, (S20624C5*), ABISELECT(1072,700), "S20624C19");
    /*is_ambiguous_... S20624C19::S19008C13 */ AMB_check_base_class_offset(lv, (S19008C13*), ABISELECT(1280,844), "S20624C19");
    check_base_class_offset(lv, (S19008C13*)(S20624C2*), ABISELECT(5136,3432), "S20624C19");
    /*is_ambiguous_... S20624C11::S20624C5 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C11*), ABISELECT(5504,3684), "S20624C19");
    check_base_class_offset(lv, (S20624C5*)(S20624C12*)(S20624C11*), ABISELECT(5712,3828), "S20624C19");
    check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C12*)(S20624C11*), ABISELECT(5920,3972), "S20624C19");
    check_base_class_offset(lv, (S20624C8*)(S20624C12*)(S20624C11*), ABISELECT(5920,3972), "S20624C19");
    check_base_class_offset(lv, (S20624C12*)(S20624C11*), ABISELECT(5712,3828), "S20624C19");
    check_base_class_offset(lv, (S20624C11*)(S20624C10*)(S20624C2*), ABISELECT(5504,3684), "S20624C19");
    check_base_class_offset(lv, (S20624C10*)(S20624C2*), ABISELECT(3472,2324), "S20624C19");
    /*is_ambiguous_... S20624C2::S20624C4 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C4*)(S20624C2*), ABISELECT(3904,2592), "S20624C19");
    /*is_ambiguous_... S20624C2::S20624C4 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C4*)(S20624C2*), ABISELECT(4112,2736), "S20624C19");
    /*is_ambiguous_... S20624C2::S20624C4 */ AMB_check_base_class_offset(lv, (S20624C8*)(S20624C4*)(S20624C2*), ABISELECT(4112,2736), "S20624C19");
    /*is_ambiguous_... S20624C2::S20624C4 */ AMB_check_base_class_offset(lv, (S20624C4*)(S20624C2*), ABISELECT(3904,2592), "S20624C19");
    /*is_ambiguous_... S20624C14::S20624C12 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C12*)(S20624C14*)(S20624C2*), ABISELECT(4192,2796), "S20624C19");
    /*is_ambiguous_... S20624C14::S20624C12 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C12*)(S20624C14*)(S20624C2*), ABISELECT(4400,2940), "S20624C19");
    /*is_ambiguous_... S20624C14::S20624C12 */ AMB_check_base_class_offset(lv, (S20624C8*)(S20624C12*)(S20624C14*)(S20624C2*), ABISELECT(4400,2940), "S20624C19");
    /*is_ambiguous_... S20624C14::S20624C12 */ AMB_check_base_class_offset(lv, (S20624C12*)(S20624C14*)(S20624C2*), ABISELECT(4192,2796), "S20624C19");
    /*is_ambiguous_... S20624C14::S20624C8 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C14*)(S20624C2*), ABISELECT(4512,3008), "S20624C19");
    /*is_ambiguous_... S20624C14::S20624C8 */ AMB_check_base_class_offset(lv, (S20624C8*)(S20624C14*)(S20624C2*), ABISELECT(4512,3008), "S20624C19");
    /*is_ambiguous_... S20624C14::S20624C5 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C14*)(S20624C2*), ABISELECT(4544,3028), "S20624C19");
    /*is_ambiguous_... S20624C19::S20624C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C15*), ABISELECT(6704,4520), "S20624C19");
    /*is_ambiguous_... S20624C19::S20624C15 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C4*)(S20624C15*), ABISELECT(6416,4316), "S20624C19");
    /*is_ambiguous_... S20624C19::S20624C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C4*)(S20624C15*), ABISELECT(6624,4460), "S20624C19");
    /*is_ambiguous_... S20624C19::S20624C15 */ AMB_check_base_class_offset(lv, (S20624C8*)(S20624C4*)(S20624C15*), ABISELECT(6624,4460), "S20624C19");
    /*is_ambiguous_... S20624C19::S20624C15 */ AMB_check_base_class_offset(lv, (S20624C4*)(S20624C15*), ABISELECT(6416,4316), "S20624C19");
    /*is_ambiguous_... S20624C19::S20624C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C15*), ABISELECT(6720,4524), "S20624C19");
    /*is_ambiguous_... S20624C19::S20624C15 */ AMB_check_base_class_offset(lv, (S20624C8*)(S20624C15*), ABISELECT(6720,4524), "S20624C19");
    /*is_ambiguous_... S20624C19::S20624C15 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C15*), ABISELECT(6752,4544), "S20624C19");
    check_base_class_offset(lv, (S20624C15*)(S20624C14*)(S20624C2*), ABISELECT(6416,4316), "S20624C19");
    check_base_class_offset(lv, (S20624C14*)(S20624C2*), ABISELECT(4192,2796), "S20624C19");
    check_base_class_offset(lv, (S20624C2*), ABISELECT(3472,2324), "S20624C19");
    check_field_offset(lv, s20624c19f0, ABISELECT(1636,1096), "S20624C19.s20624c19f0");
    check_field_offset(lv, s20624c19f1, ABISELECT(1640,1100), "S20624C19.s20624c19f1");
    check_field_offset(lv, s20624c19f2, ABISELECT(1648,1108), "S20624C19.s20624c19f2");
    check_field_offset(lv, s20624c19f3, ABISELECT(1720,1180), "S20624C19.s20624c19f3");
    check_field_offset(lv, s20624c19f4, ABISELECT(1724,1184), "S20624C19.s20624c19f4");
    check_field_offset(lv, s20624c19f5, ABISELECT(1728,1188), "S20624C19.s20624c19f5");
    check_field_offset(lv, s20624c19f6, ABISELECT(1744,1192), "S20624C19.s20624c19f6");
    test_class_info(&lv, &cd_S20624C19);
    dp->~S20624C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20624C19(Test_S20624C19, "S20624C19", ABISELECT(7488,5016));

#else // __cplusplus

extern void _ZN9S20624C19C1Ev();
extern void _ZN9S20624C19D2Ev();
Name_Map name_map_S20624C19[] = {
  NSPAIR(_ZN9S20624C19C1Ev),
  NSPAIR(_ZN9S20624C19D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C4;
extern VTBL_ENTRY _ZTI8S20624C4[];
extern  VTBL_ENTRY _ZTV8S20624C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C4[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C12;
extern VTBL_ENTRY _ZTI9S20624C12[];
extern  VTBL_ENTRY _ZTV9S20624C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C12[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S20624C15;
extern VTBL_ENTRY _ZTI9S20624C15[];
extern  VTBL_ENTRY _ZTV9S20624C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C15[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S19008C13;
extern VTBL_ENTRY _ZTI9S19008C13[];
extern Class_Descriptor cd_S19008C13;
extern VTBL_ENTRY _ZTI9S19008C13[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C12;
extern VTBL_ENTRY _ZTI9S20624C12[];
extern  VTBL_ENTRY _ZTV9S20624C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C12[];
extern Class_Descriptor cd_S20624C11;
extern VTBL_ENTRY _ZTI9S20624C11[];
extern  VTBL_ENTRY _ZTV9S20624C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C11[];
extern Class_Descriptor cd_S20624C10;
extern VTBL_ENTRY _ZTI9S20624C10[];
extern  VTBL_ENTRY _ZTV9S20624C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C10[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C4;
extern VTBL_ENTRY _ZTI8S20624C4[];
extern  VTBL_ENTRY _ZTV8S20624C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C4[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C12;
extern VTBL_ENTRY _ZTI9S20624C12[];
extern  VTBL_ENTRY _ZTV9S20624C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C12[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C4;
extern VTBL_ENTRY _ZTI8S20624C4[];
extern  VTBL_ENTRY _ZTV8S20624C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C4[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S20624C15;
extern VTBL_ENTRY _ZTI9S20624C15[];
extern  VTBL_ENTRY _ZTV9S20624C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C15[];
extern Class_Descriptor cd_S20624C14;
extern VTBL_ENTRY _ZTI9S20624C14[];
extern  VTBL_ENTRY _ZTV9S20624C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C14[];
extern Class_Descriptor cd_S20624C2;
extern VTBL_ENTRY _ZTI8S20624C2[];
extern  VTBL_ENTRY _ZTV8S20624C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C2[];
static Base_Class bases_S20624C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C4_nt,    ABISELECT(288,204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(3136,2108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S20624C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20624C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(304,208), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(304,208), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S20624C5,    ABISELECT(3152,2112), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(3360,2256), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(3360,2256), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20624C12,    ABISELECT(3152,2112), //bcp->offset
    19, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S20624C5,    ABISELECT(336,228), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S20624C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20624C5,    ABISELECT(1072,700), //bcp->offset
    16, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C13,    ABISELECT(1280,844), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19008C13,    ABISELECT(5136,3432), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    45, //immediately_derived
  0, 1},
  {&cd_S20624C5,    ABISELECT(5504,3684), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    45, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S20624C5,    ABISELECT(5712,3828), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    47, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(5920,3972), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(5920,3972), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S20624C12,    ABISELECT(5712,3828), //bcp->offset
    56, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    46, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S20624C11,    ABISELECT(5504,3684), //bcp->offset
    53, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    44, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    23, //immediately_derived
  0, 1},
  {&cd_S20624C10,    ABISELECT(3472,2324), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    45, //immediately_derived
  0, 0},
  {&cd_S20624C5,    ABISELECT(3904,2592), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    27, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(4112,2736), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(4112,2736), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S20624C4,    ABISELECT(3904,2592), //bcp->offset
    37, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    45, //immediately_derived
  0, 0},
  {&cd_S20624C5,    ABISELECT(4192,2796), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    30, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(4400,2940), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(4400,2940), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S20624C12,    ABISELECT(4192,2796), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    29, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(4512,3008), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(4512,3008), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S20624C5,    ABISELECT(4544,3028), //bcp->offset
    50, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    31, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(6704,4520), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S20624C5,    ABISELECT(6416,4316), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    51, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(6624,4460), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(6624,4460), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S20624C4,    ABISELECT(6416,4316), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    50, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(6720,4524), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(6720,4524), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S20624C5,    ABISELECT(6752,4544), //bcp->offset
    72, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    52, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S20624C15,    ABISELECT(6416,4316), //bcp->offset
    59, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    49, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    44, //immediately_derived
  0, 1},
  {&cd_S20624C14,    ABISELECT(4192,2796), //bcp->offset
    41, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    45, //immediately_derived
  0, 0},
  {&cd_S20624C2,    ABISELECT(3472,2324), //bcp->offset
    22, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20624C19[];
extern void _ZN8S20624C42v2Ev();
extern void _ZN9S20624C19D1Ev();
extern void _ZN9S20624C19D0Ev();
extern void _ZN9S20624C152v3Ev();
extern void _ZN9S20624C152v4Ev();
extern void _ZN9S20624C102v1Ev();
extern void ABISELECT(_ZTv0_n72_N9S20624C19D1Ev,_ZTv0_n36_N9S20624C19D1Ev)();
extern void ABISELECT(_ZThn3472_N9S20624C19D1Ev,_ZThn2324_N9S20624C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S20624C19D0Ev,_ZTv0_n36_N9S20624C19D0Ev)();
extern void ABISELECT(_ZThn3472_N9S20624C19D0Ev,_ZThn2324_N9S20624C19D0Ev)() __attribute__((weak));
extern void _ZN8S20624C42v2Ev();
extern void ABISELECT(_ZTvn720_n72_N9S20624C19D1Ev,_ZTvn472_n36_N9S20624C19D1Ev)();
extern void ABISELECT(_ZTvn720_n72_N9S20624C19D0Ev,_ZTvn472_n36_N9S20624C19D0Ev)();
extern void _ZN9S20624C142v5Ev();
extern void _ZN9S20624C142v6Ev();
extern void _ZN8S20624C42v2Ev();
extern void ABISELECT(_ZTv0_n48_N9S20624C19D1Ev,_ZTv0_n24_N9S20624C19D1Ev)();
extern void ABISELECT(_ZThn6416_N9S20624C19D1Ev,_ZThn4316_N9S20624C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S20624C19D0Ev,_ZTv0_n24_N9S20624C19D0Ev)();
extern void ABISELECT(_ZThn6416_N9S20624C19D0Ev,_ZThn4316_N9S20624C19D0Ev)() __attribute__((weak));
extern void _ZN9S20624C152v3Ev();
extern void _ZN9S20624C152v4Ev();
static  VTBL_ENTRY vtc_S20624C19[] = {
  ABISELECT(6416,4316),
  ABISELECT(5504,3684),
  ABISELECT(5136,3432),
  ABISELECT(3472,2324),
  ABISELECT(3152,2112),
  ABISELECT(3136,2108),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C19[0]),
  (VTBL_ENTRY)&_ZN8S20624C42v2Ev,
  (VTBL_ENTRY)&_ZN9S20624C19D1Ev,
  (VTBL_ENTRY)&_ZN9S20624C19D0Ev,
  (VTBL_ENTRY)&_ZN9S20624C152v3Ev,
  (VTBL_ENTRY)&_ZN9S20624C152v4Ev,
  ABISELECT(2800,1880),
  ABISELECT(-336,-228),
  (VTBL_ENTRY)&(_ZTI9S20624C19[0]),
  ABISELECT(2064,1408),
  ABISELECT(-1072,-700),
  (VTBL_ENTRY)&(_ZTI9S20624C19[0]),
  ABISELECT(-16,-4),
  ABISELECT(-3152,-2112),
  (VTBL_ENTRY)&(_ZTI9S20624C19[0]),
  ABISELECT(720,472),
  ABISELECT(720,472),
  ABISELECT(432,268),
  ABISELECT(-3472,-2324),
  0,
  ABISELECT(-320,-212),
  ABISELECT(2944,1992),
  ABISELECT(1664,1108),
  ABISELECT(-336,-216),
  ABISELECT(2032,1360),
  ABISELECT(-3472,-2324),
  (VTBL_ENTRY)&(_ZTI9S20624C19[0]),
  (VTBL_ENTRY)&_ZN9S20624C102v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20624C19D1Ev,_ZTv0_n36_N9S20624C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20624C19D0Ev,_ZTv0_n36_N9S20624C19D0Ev),
  ABISELECT(-768,-484),
  ABISELECT(-3904,-2592),
  (VTBL_ENTRY)&(_ZTI9S20624C19[0]),
  (VTBL_ENTRY)&_ZN8S20624C42v2Ev,
  ABISELECT(-1040,-684),
  ABISELECT(2224,1520),
  ABISELECT(-1056,-688),
  ABISELECT(-4192,-2796),
  (VTBL_ENTRY)&(_ZTI9S20624C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn720_n72_N9S20624C19D1Ev,_ZTvn472_n36_N9S20624C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn720_n72_N9S20624C19D0Ev,_ZTvn472_n36_N9S20624C19D0Ev),
  (VTBL_ENTRY)&_ZN9S20624C142v5Ev,
  (VTBL_ENTRY)&_ZN9S20624C142v6Ev,
  ABISELECT(-1408,-920),
  ABISELECT(-4544,-3028),
  (VTBL_ENTRY)&(_ZTI9S20624C19[0]),
  ABISELECT(-2368,-1576),
  ABISELECT(-5504,-3684),
  (VTBL_ENTRY)&(_ZTI9S20624C19[0]),
  ABISELECT(-2576,-1720),
  ABISELECT(-5712,-3828),
  (VTBL_ENTRY)&(_ZTI9S20624C19[0]),
  0,
  0,
  ABISELECT(-6416,-4316),
  0,
  ABISELECT(-3264,-2204),
  ABISELECT(-3280,-2208),
  ABISELECT(-6416,-4316),
  (VTBL_ENTRY)&(_ZTI9S20624C19[0]),
  (VTBL_ENTRY)&_ZN8S20624C42v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S20624C19D1Ev,_ZTv0_n24_N9S20624C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S20624C19D0Ev,_ZTv0_n24_N9S20624C19D0Ev),
  (VTBL_ENTRY)&_ZN9S20624C152v3Ev,
  (VTBL_ENTRY)&_ZN9S20624C152v4Ev,
  ABISELECT(-3616,-2436),
  ABISELECT(-6752,-4544),
  (VTBL_ENTRY)&(_ZTI9S20624C19[0]),
};
extern VTBL_ENTRY _ZTV9S20624C19[];
extern void _ZN8S20624C42v2Ev();
extern void _ZN9S20624C15D1Ev();
extern void _ZN9S20624C15D0Ev();
extern void _ZN9S20624C152v3Ev();
extern void _ZN9S20624C152v4Ev();
static  VTBL_ENTRY _tg__ZTV9S20624C15__A__9S20624C19[] = {
  ABISELECT(3152,2112),
  ABISELECT(3136,2108),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C15[0]),
  (VTBL_ENTRY)&_ZN8S20624C42v2Ev,
  (VTBL_ENTRY)&_ZN9S20624C15D1Ev,
  (VTBL_ENTRY)&_ZN9S20624C15D0Ev,
  (VTBL_ENTRY)&_ZN9S20624C152v3Ev,
  (VTBL_ENTRY)&_ZN9S20624C152v4Ev,
};
extern void _ZN8S20624C42v2Ev();
static  VTBL_ENTRY _tg__ZTV8S20624C49S20624C15__9S20624C19[] = {
  ABISELECT(3136,2108),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C4[0]),
  (VTBL_ENTRY)&_ZN8S20624C42v2Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20624C58S20624C49S20624C15__9S20624C19[] = {
  ABISELECT(3136,2108),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C15__A2__9S20624C19[] = {
  ABISELECT(2800,1880),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C12__9S20624C15__A__9S20624C19[] = {
  ABISELECT(-16,-4),
  ABISELECT(-3152,-2112),
  (VTBL_ENTRY)&(_ZTI9S20624C15[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C5__A2__9S20624C15__A__9S20624C19[] = {
  ABISELECT(2800,1880),
  ABISELECT(-336,-228),
  (VTBL_ENTRY)&(_ZTI9S20624C15[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C5__A3__9S20624C19[] = {
  ABISELECT(2064,1408),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C12__9S20624C19[] = {
  ABISELECT(-16,-4),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C12__A1__9S20624C19[] = {
  ABISELECT(-16,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
extern void _ZN9S20624C102v1Ev();
extern void _ZN8S20624C2D1Ev();
extern void _ZN8S20624C2D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20624C2__9S20624C19[] = {
  ABISELECT(-320,-212),
  ABISELECT(2944,1992),
  ABISELECT(1664,1108),
  ABISELECT(-336,-216),
  ABISELECT(2032,1360),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C2[0]),
  (VTBL_ENTRY)&_ZN9S20624C102v1Ev,
  (VTBL_ENTRY)&_ZN8S20624C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20624C2D0Ev,
};
extern void _ZN9S20624C102v1Ev();
static  VTBL_ENTRY _tg__ZTV9S20624C108S20624C2__9S20624C19[] = {
  ABISELECT(-336,-216),
  ABISELECT(2032,1360),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C10[0]),
  (VTBL_ENTRY)&_ZN9S20624C102v1Ev,
};
static  VTBL_ENTRY _tg__ZTV9S20624C11__9S20624C108S20624C2__9S20624C19[] = {
  ABISELECT(-2368,-1576),
  ABISELECT(-2032,-1360),
  (VTBL_ENTRY)&(_ZTI9S20624C10[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C129S20624C11__9S20624C108S20624C2__9S20624C19[] = {
  ABISELECT(-2576,-1720),
  ABISELECT(-2240,-1504),
  (VTBL_ENTRY)&(_ZTI9S20624C10[0]),
};
extern void _ZN8S20624C42v2Ev();
static  VTBL_ENTRY _tg__ZTV8S20624C48S20624C2__A1__9S20624C19[] = {
  ABISELECT(-768,-484),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C4[0]),
  (VTBL_ENTRY)&_ZN8S20624C42v2Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20624C58S20624C48S20624C2__A6__9S20624C19[] = {
  ABISELECT(-768,-484),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
extern void _ZN9S20624C14D1Ev();
extern void _ZN9S20624C14D0Ev();
extern void _ZN9S20624C142v5Ev();
extern void _ZN9S20624C142v6Ev();
static  VTBL_ENTRY _tg__ZTV9S20624C148S20624C2__9S20624C19[] = {
  ABISELECT(-1040,-684),
  ABISELECT(2224,1520),
  ABISELECT(-1056,-688),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C14[0]),
  (VTBL_ENTRY)&_ZN9S20624C14D1Ev,
  (VTBL_ENTRY)&_ZN9S20624C14D0Ev,
  (VTBL_ENTRY)&_ZN9S20624C142v5Ev,
  (VTBL_ENTRY)&_ZN9S20624C142v6Ev,
};
static  VTBL_ENTRY _tg__ZTV9S20624C129S20624C148S20624C2__A2__9S20624C19[] = {
  ABISELECT(-1056,-688),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C129S20624C148S20624C2__A7__9S20624C19[] = {
  ABISELECT(-1056,-688),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C148S20624C2__A8__9S20624C19[] = {
  ABISELECT(-1408,-920),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C5__A1__9S20624C148S20624C2__9S20624C19[] = {
  ABISELECT(-1408,-920),
  ABISELECT(-352,-232),
  (VTBL_ENTRY)&(_ZTI9S20624C14[0]),
};
extern void _ZN8S20624C42v2Ev();
extern void ABISELECT(_ZTv0_n48_N9S20624C14D1Ev,_ZTv0_n24_N9S20624C14D1Ev)();
extern void ABISELECT(_ZThn2224_N9S20624C14D1Ev,_ZThn1520_N9S20624C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S20624C14D0Ev,_ZTv0_n24_N9S20624C14D0Ev)();
extern void ABISELECT(_ZThn2224_N9S20624C14D0Ev,_ZThn1520_N9S20624C14D0Ev)() __attribute__((weak));
extern void _ZN9S20624C152v3Ev();
extern void _ZN9S20624C152v4Ev();
static  VTBL_ENTRY _tg__ZTV9S20624C15__9S20624C148S20624C2__9S20624C19[] = {
  0,
  0,
  ABISELECT(-2224,-1520),
  0,
  ABISELECT(-3264,-2204),
  ABISELECT(-3280,-2208),
  ABISELECT(-2224,-1520),
  (VTBL_ENTRY)&(_ZTI9S20624C14[0]),
  (VTBL_ENTRY)&_ZN8S20624C42v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S20624C14D1Ev,_ZTv0_n24_N9S20624C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S20624C14D0Ev,_ZTv0_n24_N9S20624C14D0Ev),
  (VTBL_ENTRY)&_ZN9S20624C152v3Ev,
  (VTBL_ENTRY)&_ZN9S20624C152v4Ev,
};
static  VTBL_ENTRY _tg__ZTV9S20624C12__A1__9S20624C148S20624C2__9S20624C19[] = {
  ABISELECT(-16,-4),
  ABISELECT(1040,684),
  (VTBL_ENTRY)&(_ZTI9S20624C14[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C15__A4__9S20624C148S20624C2__9S20624C19[] = {
  ABISELECT(-3616,-2436),
  ABISELECT(-2560,-1748),
  (VTBL_ENTRY)&(_ZTI9S20624C14[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C11__8S20624C2__9S20624C19[] = {
  ABISELECT(-2368,-1576),
  ABISELECT(-2032,-1360),
  (VTBL_ENTRY)&(_ZTI8S20624C2[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C129S20624C11__8S20624C2__9S20624C19[] = {
  ABISELECT(-2576,-1720),
  ABISELECT(-2240,-1504),
  (VTBL_ENTRY)&(_ZTI8S20624C2[0]),
};
extern void _ZN8S20624C42v2Ev();
static  VTBL_ENTRY _tg__ZTV8S20624C4__8S20624C2__9S20624C19[] = {
  ABISELECT(-768,-484),
  ABISELECT(-432,-268),
  (VTBL_ENTRY)&(_ZTI8S20624C2[0]),
  (VTBL_ENTRY)&_ZN8S20624C42v2Ev,
};
extern void ABISELECT(_ZThn720_N8S20624C2D1Ev,_ZThn472_N8S20624C2D1Ev)();
extern void ABISELECT(_ZThn720_N8S20624C2D0Ev,_ZThn472_N8S20624C2D0Ev)();
extern void _ZN9S20624C142v5Ev();
extern void _ZN9S20624C142v6Ev();
static  VTBL_ENTRY _tg__ZTV9S20624C14__8S20624C2__9S20624C19[] = {
  ABISELECT(-1040,-684),
  ABISELECT(2224,1520),
  ABISELECT(-1056,-688),
  ABISELECT(-720,-472),
  (VTBL_ENTRY)&(_ZTI8S20624C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn720_N8S20624C2D1Ev,_ZThn472_N8S20624C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn720_N8S20624C2D0Ev,_ZThn472_N8S20624C2D0Ev),
  (VTBL_ENTRY)&_ZN9S20624C142v5Ev,
  (VTBL_ENTRY)&_ZN9S20624C142v6Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C14__A4__8S20624C2__9S20624C19[] = {
  ABISELECT(-1408,-920),
  ABISELECT(-1072,-704),
  (VTBL_ENTRY)&(_ZTI8S20624C2[0]),
};
extern void _ZN8S20624C42v2Ev();
extern void ABISELECT(_ZTv0_n48_N8S20624C2D1Ev,_ZTv0_n24_N8S20624C2D1Ev)();
extern void ABISELECT(_ZThn2944_N8S20624C2D1Ev,_ZThn1992_N8S20624C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S20624C2D0Ev,_ZTv0_n24_N8S20624C2D0Ev)();
extern void ABISELECT(_ZThn2944_N8S20624C2D0Ev,_ZThn1992_N8S20624C2D0Ev)() __attribute__((weak));
extern void _ZN9S20624C152v3Ev();
extern void _ZN9S20624C152v4Ev();
static  VTBL_ENTRY _tg__ZTV9S20624C15__8S20624C2__9S20624C19[] = {
  0,
  0,
  ABISELECT(-2944,-1992),
  0,
  ABISELECT(-3264,-2204),
  ABISELECT(-3280,-2208),
  ABISELECT(-2944,-1992),
  (VTBL_ENTRY)&(_ZTI8S20624C2[0]),
  (VTBL_ENTRY)&_ZN8S20624C42v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S20624C2D1Ev,_ZTv0_n24_N8S20624C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S20624C2D0Ev,_ZTv0_n24_N8S20624C2D0Ev),
  (VTBL_ENTRY)&_ZN9S20624C152v3Ev,
  (VTBL_ENTRY)&_ZN9S20624C152v4Ev,
};
static  VTBL_ENTRY _tg__ZTV9S20624C12__A2__8S20624C2__9S20624C19[] = {
  ABISELECT(-16,-4),
  ABISELECT(320,212),
  (VTBL_ENTRY)&(_ZTI8S20624C2[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C15__A7__8S20624C2__9S20624C19[] = {
  ABISELECT(-3616,-2436),
  ABISELECT(-3280,-2220),
  (VTBL_ENTRY)&(_ZTI8S20624C2[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C11__9S20624C19[] = {
  ABISELECT(-2368,-1576),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C11[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C11__A4__9S20624C19[] = {
  ABISELECT(-2368,-1576),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C129S20624C11__A1__9S20624C19[] = {
  ABISELECT(-2576,-1720),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C129S20624C11__A5__9S20624C19[] = {
  ABISELECT(-2576,-1720),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C12__9S20624C11__9S20624C19[] = {
  ABISELECT(-2576,-1720),
  ABISELECT(-208,-144),
  (VTBL_ENTRY)&(_ZTI9S20624C11[0]),
};
extern void _ZN8S20624C42v2Ev();
extern void _ZN9S20624C15D1Ev();
extern void _ZN9S20624C15D0Ev();
extern void _ZN9S20624C152v3Ev();
extern void _ZN9S20624C152v4Ev();
static  VTBL_ENTRY _tg__ZTV9S20624C15__A1__9S20624C19[] = {
  ABISELECT(-3264,-2204),
  ABISELECT(-3280,-2208),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C15[0]),
  (VTBL_ENTRY)&_ZN8S20624C42v2Ev,
  (VTBL_ENTRY)&_ZN9S20624C15D1Ev,
  (VTBL_ENTRY)&_ZN9S20624C15D0Ev,
  (VTBL_ENTRY)&_ZN9S20624C152v3Ev,
  (VTBL_ENTRY)&_ZN9S20624C152v4Ev,
};
extern void _ZN8S20624C42v2Ev();
static  VTBL_ENTRY _tg__ZTV8S20624C49S20624C15__A2__9S20624C19[] = {
  ABISELECT(-3280,-2208),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C4[0]),
  (VTBL_ENTRY)&_ZN8S20624C42v2Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20624C58S20624C49S20624C15__A9__9S20624C19[] = {
  ABISELECT(-3280,-2208),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C15__A10__9S20624C19[] = {
  ABISELECT(-3616,-2436),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C12__9S20624C15__A1__9S20624C19[] = {
  ABISELECT(-16,-4),
  ABISELECT(3264,2204),
  (VTBL_ENTRY)&(_ZTI9S20624C15[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C5__A2__9S20624C15__A1__9S20624C19[] = {
  ABISELECT(-3616,-2436),
  ABISELECT(-336,-228),
  (VTBL_ENTRY)&(_ZTI9S20624C15[0]),
};
static  VTT_ENTRY vtt_S20624C19[] = {
  {&(_ZTV9S20624C19[8]),  8,75},
  {&(_tg__ZTV9S20624C15__A__9S20624C19[4]),  4,9},
  {&(_tg__ZTV8S20624C49S20624C15__9S20624C19[3]),  3,4},
  {&(_tg__ZTV8S20624C58S20624C49S20624C15__9S20624C19[3]),  3,3},
  {&(_tg__ZTV8S20624C59S20624C15__A2__9S20624C19[3]),  3,3},
  {&(_tg__ZTV9S20624C12__9S20624C15__A__9S20624C19[3]),  3,3},
  {&(_tg__ZTV8S20624C5__A2__9S20624C15__A__9S20624C19[3]),  3,3},
  {&(_tg__ZTV8S20624C5__A3__9S20624C19[3]),  3,3},
  {&(_ZTV9S20624C19[22]),  22,75},
  {&(_ZTV9S20624C19[16]),  16,75},
  {&(_ZTV9S20624C19[19]),  19,75},
  {&(_ZTV9S20624C19[34]),  34,75},
  {&(_ZTV9S20624C19[56]),  56,75},
  {&(_ZTV9S20624C19[59]),  59,75},
  {&(_ZTV9S20624C19[40]),  40,75},
  {&(_ZTV9S20624C19[46]),  46,75},
  {&(_ZTV9S20624C19[53]),  53,75},
  {&(_ZTV9S20624C19[67]),  67,75},
  {&(_ZTV9S20624C19[75]),  75,75},
  {&(_tg__ZTV9S20624C12__9S20624C19[3]),  3,3},
  {&(_tg__ZTV8S20624C59S20624C12__A1__9S20624C19[3]),  3,3},
  {&(_tg__ZTV8S20624C2__9S20624C19[7]),  7,10},
  {&(_tg__ZTV9S20624C108S20624C2__9S20624C19[4]),  4,5},
  {&(_tg__ZTV9S20624C11__9S20624C108S20624C2__9S20624C19[3]),  3,3},
  {&(_tg__ZTV9S20624C129S20624C11__9S20624C108S20624C2__9S20624C19[3]),  3,3},
  {&(_tg__ZTV8S20624C48S20624C2__A1__9S20624C19[3]),  3,4},
  {&(_tg__ZTV8S20624C58S20624C48S20624C2__A6__9S20624C19[3]),  3,3},
  {&(_tg__ZTV9S20624C148S20624C2__9S20624C19[5]),  5,9},
  {&(_tg__ZTV9S20624C129S20624C148S20624C2__A2__9S20624C19[3]),  3,3},
  {&(_tg__ZTV8S20624C59S20624C129S20624C148S20624C2__A7__9S20624C19[3]),  3,3},
  {&(_tg__ZTV8S20624C59S20624C148S20624C2__A8__9S20624C19[3]),  3,3},
  {&(_tg__ZTV8S20624C5__A1__9S20624C148S20624C2__9S20624C19[3]),  3,3},
  {&(_tg__ZTV9S20624C15__9S20624C148S20624C2__9S20624C19[8]),  8,13},
  {&(_tg__ZTV9S20624C12__A1__9S20624C148S20624C2__9S20624C19[3]),  3,3},
  {&(_tg__ZTV8S20624C59S20624C15__A4__9S20624C148S20624C2__9S20624C19[3]),  3,3},
  {&(_tg__ZTV9S20624C11__8S20624C2__9S20624C19[3]),  3,3},
  {&(_tg__ZTV9S20624C129S20624C11__8S20624C2__9S20624C19[3]),  3,3},
  {&(_tg__ZTV8S20624C4__8S20624C2__9S20624C19[3]),  3,4},
  {&(_tg__ZTV9S20624C14__8S20624C2__9S20624C19[5]),  5,9},
  {&(_tg__ZTV8S20624C59S20624C14__A4__8S20624C2__9S20624C19[3]),  3,3},
  {&(_tg__ZTV9S20624C15__8S20624C2__9S20624C19[8]),  8,13},
  {&(_tg__ZTV9S20624C12__A2__8S20624C2__9S20624C19[3]),  3,3},
  {&(_tg__ZTV8S20624C59S20624C15__A7__8S20624C2__9S20624C19[3]),  3,3},
  {&(_tg__ZTV9S20624C11__9S20624C19[3]),  3,3},
  {&(_tg__ZTV8S20624C59S20624C11__A4__9S20624C19[3]),  3,3},
  {&(_tg__ZTV9S20624C129S20624C11__A1__9S20624C19[3]),  3,3},
  {&(_tg__ZTV8S20624C59S20624C129S20624C11__A5__9S20624C19[3]),  3,3},
  {&(_tg__ZTV9S20624C12__9S20624C11__9S20624C19[3]),  3,3},
  {&(_tg__ZTV9S20624C15__A1__9S20624C19[4]),  4,9},
  {&(_tg__ZTV8S20624C49S20624C15__A2__9S20624C19[3]),  3,4},
  {&(_tg__ZTV8S20624C58S20624C49S20624C15__A9__9S20624C19[3]),  3,3},
  {&(_tg__ZTV8S20624C59S20624C15__A10__9S20624C19[3]),  3,3},
  {&(_tg__ZTV9S20624C12__9S20624C15__A1__9S20624C19[3]),  3,3},
  {&(_tg__ZTV8S20624C5__A2__9S20624C15__A1__9S20624C19[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20624C19[];
extern  VTBL_ENTRY _ZTV9S20624C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C19[];
static VTBL_ENTRY alt_thunk_names14[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S20624C2D0Ev,_ZTv0_n24_N8S20624C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2944_N8S20624C2D0Ev,_ZThn1992_N8S20624C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S20624C2D1Ev,_ZTv0_n24_N8S20624C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2944_N8S20624C2D1Ev,_ZThn1992_N8S20624C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S20624C14D0Ev,_ZTv0_n24_N9S20624C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2224_N9S20624C14D0Ev,_ZThn1520_N9S20624C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S20624C14D1Ev,_ZTv0_n24_N9S20624C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2224_N9S20624C14D1Ev,_ZThn1520_N9S20624C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S20624C19D0Ev,_ZTv0_n24_N9S20624C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6416_N9S20624C19D0Ev,_ZThn4316_N9S20624C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S20624C19D1Ev,_ZTv0_n24_N9S20624C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6416_N9S20624C19D1Ev,_ZThn4316_N9S20624C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S20624C19D0Ev,_ZTv0_n36_N9S20624C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3472_N9S20624C19D0Ev,_ZThn2324_N9S20624C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S20624C19D1Ev,_ZTv0_n36_N9S20624C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3472_N9S20624C19D1Ev,_ZThn2324_N9S20624C19D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20624C19 = {  "S20624C19", // class name
  bases_S20624C19, 46,
  &(vtc_S20624C19[0]), // expected_vtbl_contents
  &(vtt_S20624C19[0]), // expected_vtt_contents
  ABISELECT(7488,5016), // object size
  NSPAIRA(_ZTI9S20624C19),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S20624C19),75, //virtual function table var
  8, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20624C19),54, //virtual table table var
  23, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names14,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20624C21  : virtual S20624C11 , S20624C12 , virtual S20624C10 , virtual S19008C22 , S20624C8 {
  long double s20624c21f0;
  ::S19008C4_nt s20624c21f1;
  int s20624c21f2;
  void *s20624c21f3[4];
  int s20624c21f4[5];
  ::S20624C4 s20624c21f5;
  ::S20624C5 s20624c21f6;
  char s20624c21f7;
  virtual  ~S20624C21(); // _ZN9S20624C21D2Ev
  virtual void  v8(); // _ZN9S20624C212v8Ev
  virtual void  v9(); // _ZN9S20624C212v9Ev
  virtual void  v10(); // _ZN9S20624C213v10Ev
  virtual void  v11(); // _ZN9S20624C213v11Ev
  S20624C21(); // tgen
};
//SIG(-1 S20624C21) C1{ VBC2{ VBC3{ m Fi} BC4{ VBC3 Fp FL Fi Fp Fi FU5{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC3 FC6{ BC3 Fi FU7{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC8{ VBC3 BC4 BC6 FL FU7 Fp Fp FC9{} Fi Fi Fp Fc FC9} FC10{ BC4 BC6 v6 Fi FL Fi FL FC3 Fi Fs Fi} Fi[6] Fi FC3[7] Fi Fp[2]} BC8 VBC11{ VBC2 v5 Fp[7] Fi Fs FD Fi FC10 Fi} VBC12{ vd m Fi Fi:1 Fi Fi Fi:9 Fi Fi Fi[8] Fs} BC6 vd v1 v2 v3 v4 FD FC3 Fi Fp[4] Fi[5] FC10 FC4 Fc}


 S20624C21 ::~S20624C21(){ note_dtor("S20624C21", this);}
void  S20624C21 ::v8(){vfunc_called(this, "_ZN9S20624C212v8Ev");}
void  S20624C21 ::v9(){vfunc_called(this, "_ZN9S20624C212v9Ev");}
void  S20624C21 ::v10(){vfunc_called(this, "_ZN9S20624C213v10Ev");}
void  S20624C21 ::v11(){vfunc_called(this, "_ZN9S20624C213v11Ev");}
S20624C21 ::S20624C21(){ note_ctor("S20624C21", this);} // tgen

static void Test_S20624C21()
{
  extern Class_Descriptor cd_S20624C21;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(150,406)];
    init_test(&cd_S20624C21, buf);
    S20624C21 *dp, &lv = *(dp=new (buf) S20624C21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2384,1620), "sizeof(S20624C21)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20624C21)");
    /*is_ambiguous_... S20624C11::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C11*), ABISELECT(1872,1280), "S20624C21");
    /*is_ambiguous_... S20624C11::S20624C5 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C11*), ABISELECT(1872,1280), "S20624C21");
    /*is_ambiguous_... S20624C12::S19008C4_nt */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C12*)(S20624C11*), ABISELECT(1872,1280), "S20624C21");
    check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C12*)(S20624C11*), ABISELECT(1872,1280), "S20624C21");
    /*is_ambiguous_... S20624C21::S20624C12 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C12*), ABISELECT(1872,1280), "S20624C21");
    /*is_ambiguous_... S20624C21::S20624C12 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C12*), ABISELECT(1872,1280), "S20624C21");
    /*is_ambiguous_... S20624C11::S20624C5 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C11*), ABISELECT(960,648), "S20624C21");
    check_base_class_offset(lv, (S20624C5*)(S20624C12*)(S20624C11*), ABISELECT(1168,792), "S20624C21");
    check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C12*)(S20624C11*), ABISELECT(1376,936), "S20624C21");
    check_base_class_offset(lv, (S20624C8*)(S20624C12*)(S20624C11*), ABISELECT(1376,936), "S20624C21");
    check_base_class_offset(lv, (S20624C12*)(S20624C11*), ABISELECT(1168,792), "S20624C21");
    check_base_class_offset(lv, (S20624C11*), ABISELECT(960,648), "S20624C21");
    check_base_class_offset(lv, (S20624C11*)(S20624C10*), ABISELECT(960,648), "S20624C21");
    /*is_ambiguous_... S20624C21::S20624C12 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C12*), 0, "S20624C21");
    /*is_ambiguous_... S20624C21::S20624C12 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C12*), ABISELECT(208,144), "S20624C21");
    /*is_ambiguous_... S20624C21::S20624C12 */ AMB_check_base_class_offset(lv, (S20624C8*)(S20624C12*), ABISELECT(208,144), "S20624C21");
    /*is_ambiguous_... S20624C21::S20624C12 */ AMB_check_base_class_offset(lv, (S20624C12*), 0, "S20624C21");
    check_base_class_offset(lv, (S20624C10*), ABISELECT(1888,1284), "S20624C21");
    check_base_class_offset(lv, (S19008C22*), ABISELECT(2312,1552), "S20624C21");
    /*is_ambiguous_... S20624C21::S20624C8 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*), ABISELECT(320,212), "S20624C21");
    /*is_ambiguous_... S20624C21::S20624C8 */ AMB_check_base_class_offset(lv, (S20624C8*), ABISELECT(320,212), "S20624C21");
    check_field_offset(lv, s20624c21f0, ABISELECT(352,232), "S20624C21.s20624c21f0");
    check_field_offset(lv, s20624c21f1, ABISELECT(368,244), "S20624C21.s20624c21f1");
    check_field_offset(lv, s20624c21f2, ABISELECT(372,248), "S20624C21.s20624c21f2");
    check_field_offset(lv, s20624c21f3, ABISELECT(376,252), "S20624C21.s20624c21f3");
    check_field_offset(lv, s20624c21f4, ABISELECT(408,268), "S20624C21.s20624c21f4");
    check_field_offset(lv, s20624c21f5, ABISELECT(432,288), "S20624C21.s20624c21f5");
    check_field_offset(lv, s20624c21f6, ABISELECT(736,496), "S20624C21.s20624c21f6");
    check_field_offset(lv, s20624c21f7, ABISELECT(944,644), "S20624C21.s20624c21f7");
    test_class_info(&lv, &cd_S20624C21);
    dp->~S20624C21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20624C21(Test_S20624C21, "S20624C21", ABISELECT(2384,1620));

#else // __cplusplus

extern void _ZN9S20624C21C1Ev();
extern void _ZN9S20624C21D2Ev();
Name_Map name_map_S20624C21[] = {
  NSPAIR(_ZN9S20624C21C1Ev),
  NSPAIR(_ZN9S20624C21D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C12;
extern VTBL_ENTRY _ZTI9S20624C12[];
extern  VTBL_ENTRY _ZTV9S20624C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C12[];
extern Class_Descriptor cd_S20624C11;
extern VTBL_ENTRY _ZTI9S20624C11[];
extern  VTBL_ENTRY _ZTV9S20624C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C11[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C12;
extern VTBL_ENTRY _ZTI9S20624C12[];
extern  VTBL_ENTRY _ZTV9S20624C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C12[];
extern Class_Descriptor cd_S20624C10;
extern VTBL_ENTRY _ZTI9S20624C10[];
extern  VTBL_ENTRY _ZTV9S20624C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C10[];
extern Class_Descriptor cd_S19008C22;
extern VTBL_ENTRY _ZTI9S19008C22[];
extern  VTBL_ENTRY _ZTV9S19008C22[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
static Base_Class bases_S20624C21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C4_nt,    ABISELECT(1872,1280), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20624C5,    ABISELECT(960,648), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20624C5,    ABISELECT(1168,792), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(1376,936), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(1376,936), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20624C12,    ABISELECT(1168,792), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20624C11,    ABISELECT(960,648), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20624C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20624C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20624C10,    ABISELECT(1888,1284), //bcp->offset
    18, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19008C22,    ABISELECT(2312,1552), //bcp->offset
    24, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19008C4_nt,    ABISELECT(320,212), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(320,212), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20624C21[];
extern void _ZN9S20624C21D1Ev();
extern void _ZN9S20624C21D0Ev();
extern void _ZN9S20624C212v8Ev();
extern void _ZN9S20624C212v9Ev();
extern void _ZN9S20624C213v10Ev();
extern void _ZN9S20624C213v11Ev();
extern void _ZN9S20624C102v1Ev();
extern void ABISELECT(_ZTv0_n24_N9S20624C21D1Ev,_ZTv0_n12_N9S20624C21D1Ev)();
extern void ABISELECT(_ZThn2312_N9S20624C21D1Ev,_ZThn1552_N9S20624C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20624C21D0Ev,_ZTv0_n12_N9S20624C21D0Ev)();
extern void ABISELECT(_ZThn2312_N9S20624C21D0Ev,_ZThn1552_N9S20624C21D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S20624C21[] = {
  ABISELECT(2312,1552),
  ABISELECT(1888,1284),
  ABISELECT(960,648),
  ABISELECT(1872,1280),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C21[0]),
  (VTBL_ENTRY)&_ZN9S20624C21D1Ev,
  (VTBL_ENTRY)&_ZN9S20624C21D0Ev,
  (VTBL_ENTRY)&_ZN9S20624C212v8Ev,
  (VTBL_ENTRY)&_ZN9S20624C212v9Ev,
  (VTBL_ENTRY)&_ZN9S20624C213v10Ev,
  (VTBL_ENTRY)&_ZN9S20624C213v11Ev,
  ABISELECT(912,632),
  ABISELECT(-960,-648),
  (VTBL_ENTRY)&(_ZTI9S20624C21[0]),
  ABISELECT(704,488),
  ABISELECT(-1168,-792),
  (VTBL_ENTRY)&(_ZTI9S20624C21[0]),
  0,
  ABISELECT(-16,-4),
  ABISELECT(-928,-636),
  ABISELECT(-1888,-1284),
  (VTBL_ENTRY)&(_ZTI9S20624C21[0]),
  (VTBL_ENTRY)&_ZN9S20624C102v1Ev,
  ABISELECT(-2312,-1552),
  ABISELECT(-2312,-1552),
  (VTBL_ENTRY)&(_ZTI9S20624C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20624C21D1Ev,_ZTv0_n12_N9S20624C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20624C21D0Ev,_ZTv0_n12_N9S20624C21D0Ev),
};
extern VTBL_ENTRY _ZTV9S20624C21[];
static  VTBL_ENTRY _tg__ZTV9S20624C12__A1__9S20624C21[] = {
  ABISELECT(1872,1280),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C12__A2__9S20624C21[] = {
  ABISELECT(1872,1280),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C11__9S20624C21[] = {
  ABISELECT(912,632),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C11[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C11__9S20624C21[] = {
  ABISELECT(912,632),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C129S20624C11__9S20624C21[] = {
  ABISELECT(704,488),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C129S20624C11__A1__9S20624C21[] = {
  ABISELECT(704,488),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C12__9S20624C11__9S20624C21[] = {
  ABISELECT(704,488),
  ABISELECT(-208,-144),
  (VTBL_ENTRY)&(_ZTI9S20624C11[0]),
};
extern void _ZN9S20624C102v1Ev();
static  VTBL_ENTRY _tg__ZTV9S20624C10__9S20624C21[] = {
  ABISELECT(-16,-4),
  ABISELECT(-928,-636),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C10[0]),
  (VTBL_ENTRY)&_ZN9S20624C102v1Ev,
};
static  VTBL_ENTRY _tg__ZTV9S20624C11__9S20624C10__9S20624C21[] = {
  ABISELECT(912,632),
  ABISELECT(928,636),
  (VTBL_ENTRY)&(_ZTI9S20624C10[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C129S20624C11__9S20624C10__9S20624C21[] = {
  ABISELECT(704,488),
  ABISELECT(720,492),
  (VTBL_ENTRY)&(_ZTI9S20624C10[0]),
};
static  VTT_ENTRY vtt_S20624C21[] = {
  {&(_ZTV9S20624C21[6]),  6,29},
  {&(_tg__ZTV9S20624C12__A1__9S20624C21[3]),  3,3},
  {&(_tg__ZTV8S20624C59S20624C12__A2__9S20624C21[3]),  3,3},
  {&(_ZTV9S20624C21[15]),  15,29},
  {&(_ZTV9S20624C21[18]),  18,29},
  {&(_ZTV9S20624C21[23]),  23,29},
  {&(_ZTV9S20624C21[27]),  27,29},
  {&(_tg__ZTV9S20624C11__9S20624C21[3]),  3,3},
  {&(_tg__ZTV8S20624C59S20624C11__9S20624C21[3]),  3,3},
  {&(_tg__ZTV9S20624C129S20624C11__9S20624C21[3]),  3,3},
  {&(_tg__ZTV8S20624C59S20624C129S20624C11__A1__9S20624C21[3]),  3,3},
  {&(_tg__ZTV9S20624C12__9S20624C11__9S20624C21[3]),  3,3},
  {&(_tg__ZTV9S20624C10__9S20624C21[4]),  4,5},
  {&(_tg__ZTV9S20624C11__9S20624C10__9S20624C21[3]),  3,3},
  {&(_tg__ZTV9S20624C129S20624C11__9S20624C10__9S20624C21[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20624C21[];
extern  VTBL_ENTRY _ZTV9S20624C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C21[];
static VTBL_ENTRY alt_thunk_names15[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20624C21D0Ev,_ZTv0_n12_N9S20624C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2312_N9S20624C21D0Ev,_ZThn1552_N9S20624C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20624C21D1Ev,_ZTv0_n12_N9S20624C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2312_N9S20624C21D1Ev,_ZThn1552_N9S20624C21D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20624C21 = {  "S20624C21", // class name
  bases_S20624C21, 15,
  &(vtc_S20624C21[0]), // expected_vtbl_contents
  &(vtt_S20624C21[0]), // expected_vtt_contents
  ABISELECT(2384,1620), // object size
  NSPAIRA(_ZTI9S20624C21),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S20624C21),29, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20624C21),15, //virtual table table var
  8, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names15,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20624C20  : virtual S19008C13 , S20624C4 , S20624C10 , S20624C11 , virtual S20624C21 {
  int s20624c20f0;
  void *s20624c20f1[2];
  char s20624c20f2;
  ::S20624C12 s20624c20f3[2];
  ::S19008C22 s20624c20f4;
  ::S20624C4 s20624c20f5;
  virtual void  v12(); // _ZN9S20624C203v12Ev
  ~S20624C20(); // tgen
  S20624C20(); // tgen
};
//SIG(-1 S20624C20) C1{ VBC2{ m Fi Fi:20 FC3{ BC4{ VBC5{ m Fi} Fp FL Fi Fp Fi FU6{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC5 FC7{ BC5 Fi FU8{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC7 v8 Fi FL Fi FL FC5 Fi Fs Fi} Fi Fc[4] Fi Fi Fi Fi Fi Fi Fi} BC9{ BC10{ VBC5 Fp FL Fi Fp Fi FU6 Fc Fc FD FC5 FC11{ BC5 Fi FU8} Fp} BC11 v2 Fi FL Fi FL FC5 Fi Fs Fi} BC12{ VBC13{ VBC5 BC10 BC14{ VBC5 BC10 BC11 FL FU8 Fp Fp FC15{} Fi Fi Fp Fc FC15} FC9 Fi[6] Fi FC5[7] Fi Fp[2]} v3 Fp[7] Fi Fs FD Fi FC9 Fi} BC13 VBC16{ VBC13 BC14 VBC12 VBC17{ vd m Fi Fi:1 Fi Fi Fi:9 Fi Fi Fi[8] Fs} BC11 vd v4 v5 v6 v7 FD FC5 Fi Fp[4] Fi[5] FC9 FC10 Fc} v1 Fi Fp[2] Fc FC14[2] FC17 FC9}


void  S20624C20 ::v12(){vfunc_called(this, "_ZN9S20624C203v12Ev");}
S20624C20 ::~S20624C20(){ note_dtor("S20624C20", this);} // tgen
S20624C20 ::S20624C20(){ note_ctor("S20624C20", this);} // tgen

static void Test_S20624C20()
{
  extern Class_Descriptor cd_S20624C20;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(340,926)];
    init_test(&cd_S20624C20, buf);
    S20624C20 *dp, &lv = *(dp=new (buf) S20624C20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(5424,3700), "sizeof(S20624C20)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20624C20)");
    check_base_class_offset(lv, (S19008C13*), ABISELECT(2688,1828), "S20624C20");
    check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C4*), ABISELECT(3044,2080), "S20624C20");
    /*is_ambiguous_... S20624C20::S20624C11 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C11*), ABISELECT(3044,2080), "S20624C20");
    /*is_ambiguous_... S20624C20::S20624C11 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C11*), ABISELECT(3044,2080), "S20624C20");
    /*is_ambiguous_... S20624C20::S20624C11 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C12*)(S20624C11*), ABISELECT(3044,2080), "S20624C20");
    /*is_ambiguous_... S20624C20::S20624C11 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C12*)(S20624C11*), ABISELECT(3044,2080), "S20624C20");
    /*is_ambiguous_... S20624C20::S20624C11 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C11*), ABISELECT(3044,2080), "S20624C20");
    /*is_ambiguous_... S20624C20::S20624C11 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C11*), ABISELECT(3044,2080), "S20624C20");
    /*is_ambiguous_... S20624C20::S20624C11 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C12*)(S20624C11*), ABISELECT(3044,2080), "S20624C20");
    /*is_ambiguous_... S20624C20::S20624C11 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C12*)(S20624C11*), ABISELECT(3044,2080), "S20624C20");
    /*is_ambiguous_... S20624C21::S20624C12 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C12*)(S20624C21*), ABISELECT(3044,2080), "S20624C20");
    /*is_ambiguous_... S20624C21::S20624C12 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C12*)(S20624C21*), ABISELECT(3044,2080), "S20624C20");
    check_base_class_offset(lv, (S20624C5*)(S20624C4*), 0, "S20624C20");
    check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C4*), ABISELECT(208,144), "S20624C20");
    check_base_class_offset(lv, (S20624C8*)(S20624C4*), ABISELECT(208,144), "S20624C20");
    check_base_class_offset(lv, (S20624C4*), 0, "S20624C20");
    /*is_ambiguous_... S20624C20::S20624C11 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C11*), ABISELECT(3056,2084), "S20624C20");
    /*is_ambiguous_... S20624C20::S20624C11 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C12*)(S20624C11*), ABISELECT(3264,2228), "S20624C20");
    /*is_ambiguous_... S20624C20::S20624C11 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C12*)(S20624C11*), ABISELECT(3472,2372), "S20624C20");
    /*is_ambiguous_... S20624C20::S20624C11 */ AMB_check_base_class_offset(lv, (S20624C8*)(S20624C12*)(S20624C11*), ABISELECT(3472,2372), "S20624C20");
    /*is_ambiguous_... S20624C20::S20624C11 */ AMB_check_base_class_offset(lv, (S20624C12*)(S20624C11*), ABISELECT(3264,2228), "S20624C20");
    /*is_ambiguous_... S20624C20::S20624C10 */ AMB_check_base_class_offset(lv, (S20624C11*)(S20624C10*), ABISELECT(3056,2084), "S20624C20");
    check_base_class_offset(lv, (S20624C11*)(S20624C21*), ABISELECT(3056,2084), "S20624C20");
    /*is_ambiguous_... S20624C20::S20624C10 */ AMB_check_base_class_offset(lv, (S20624C11*)(S20624C10*), ABISELECT(3056,2084), "S20624C20");
    /*is_ambiguous_... S20624C20::S20624C10 */ AMB_check_base_class_offset(lv, (S20624C10*), ABISELECT(288,204), "S20624C20");
    /*is_ambiguous_... S20624C20::S20624C11 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C11*), ABISELECT(720,472), "S20624C20");
    /*is_ambiguous_... S20624C20::S20624C11 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C12*)(S20624C11*), ABISELECT(928,616), "S20624C20");
    /*is_ambiguous_... S20624C20::S20624C11 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C12*)(S20624C11*), ABISELECT(1136,760), "S20624C20");
    /*is_ambiguous_... S20624C20::S20624C11 */ AMB_check_base_class_offset(lv, (S20624C8*)(S20624C12*)(S20624C11*), ABISELECT(1136,760), "S20624C20");
    /*is_ambiguous_... S20624C20::S20624C11 */ AMB_check_base_class_offset(lv, (S20624C12*)(S20624C11*), ABISELECT(928,616), "S20624C20");
    /*is_ambiguous_... S20624C20::S20624C11 */ AMB_check_base_class_offset(lv, (S20624C11*), ABISELECT(720,472), "S20624C20");
    /*is_ambiguous_... S20624C21::S20624C12 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C12*)(S20624C21*), ABISELECT(3968,2716), "S20624C20");
    /*is_ambiguous_... S20624C21::S20624C12 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C12*)(S20624C21*), ABISELECT(4176,2860), "S20624C20");
    /*is_ambiguous_... S20624C21::S20624C12 */ AMB_check_base_class_offset(lv, (S20624C8*)(S20624C12*)(S20624C21*), ABISELECT(4176,2860), "S20624C20");
    /*is_ambiguous_... S20624C21::S20624C12 */ AMB_check_base_class_offset(lv, (S20624C12*)(S20624C21*), ABISELECT(3968,2716), "S20624C20");
    check_base_class_offset(lv, (S20624C10*)(S20624C21*), ABISELECT(4928,3364), "S20624C20");
    check_base_class_offset(lv, (S19008C22*)(S20624C21*), ABISELECT(5352,3632), "S20624C20");
    /*is_ambiguous_... S20624C21::S20624C8 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C21*), ABISELECT(4288,2928), "S20624C20");
    /*is_ambiguous_... S20624C21::S20624C8 */ AMB_check_base_class_offset(lv, (S20624C8*)(S20624C21*), ABISELECT(4288,2928), "S20624C20");
    check_base_class_offset(lv, (S20624C21*), ABISELECT(3968,2716), "S20624C20");
    check_field_offset(lv, s20624c20f0, ABISELECT(1632,1104), "S20624C20.s20624c20f0");
    check_field_offset(lv, s20624c20f1, ABISELECT(1640,1108), "S20624C20.s20624c20f1");
    check_field_offset(lv, s20624c20f2, ABISELECT(1656,1116), "S20624C20.s20624c20f2");
    check_field_offset(lv, s20624c20f3, ABISELECT(1664,1120), "S20624C20.s20624c20f3");
    check_field_offset(lv, s20624c20f4, ABISELECT(2304,1552), "S20624C20.s20624c20f4");
    check_field_offset(lv, s20624c20f5, ABISELECT(2384,1620), "S20624C20.s20624c20f5");
    test_class_info(&lv, &cd_S20624C20);
    dp->~S20624C20();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20624C20(Test_S20624C20, "S20624C20", ABISELECT(5424,3700));

#else // __cplusplus

extern void _ZN9S20624C20C1Ev();
extern void _ZN9S20624C20D1Ev();
Name_Map name_map_S20624C20[] = {
  NSPAIR(_ZN9S20624C20C1Ev),
  NSPAIR(_ZN9S20624C20D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19008C13;
extern VTBL_ENTRY _ZTI9S19008C13[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C4;
extern VTBL_ENTRY _ZTI8S20624C4[];
extern  VTBL_ENTRY _ZTV8S20624C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C4[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C12;
extern VTBL_ENTRY _ZTI9S20624C12[];
extern  VTBL_ENTRY _ZTV9S20624C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C12[];
extern Class_Descriptor cd_S20624C11;
extern VTBL_ENTRY _ZTI9S20624C11[];
extern  VTBL_ENTRY _ZTV9S20624C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C11[];
extern Class_Descriptor cd_S20624C10;
extern VTBL_ENTRY _ZTI9S20624C10[];
extern  VTBL_ENTRY _ZTV9S20624C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C10[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C12;
extern VTBL_ENTRY _ZTI9S20624C12[];
extern  VTBL_ENTRY _ZTV9S20624C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C12[];
extern Class_Descriptor cd_S20624C11;
extern VTBL_ENTRY _ZTI9S20624C11[];
extern  VTBL_ENTRY _ZTV9S20624C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C11[];
extern Class_Descriptor cd_S20624C5;
extern VTBL_ENTRY _ZTI8S20624C5[];
extern  VTBL_ENTRY _ZTV8S20624C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20624C5[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C12;
extern VTBL_ENTRY _ZTI9S20624C12[];
extern  VTBL_ENTRY _ZTV9S20624C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C12[];
extern Class_Descriptor cd_S20624C10;
extern VTBL_ENTRY _ZTI9S20624C10[];
extern  VTBL_ENTRY _ZTV9S20624C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C10[];
extern Class_Descriptor cd_S19008C22;
extern VTBL_ENTRY _ZTI9S19008C22[];
extern  VTBL_ENTRY _ZTV9S19008C22[];
extern Class_Descriptor cd_S19008C4_nt;
extern VTBL_ENTRY _ZTI11S19008C4_nt[];
extern Class_Descriptor cd_S20624C8;
extern VTBL_ENTRY _ZTI8S20624C8[];
extern Class_Descriptor cd_S20624C21;
extern VTBL_ENTRY _ZTI9S20624C21[];
extern  VTBL_ENTRY _ZTV9S20624C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C21[];
static Base_Class bases_S20624C20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19008C13,    ABISELECT(2688,1828), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19008C4_nt,    ABISELECT(3044,2080), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S20624C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(208,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20624C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20624C5,    ABISELECT(3056,2084), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20624C5,    ABISELECT(3264,2228), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(3472,2372), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(3472,2372), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20624C12,    ABISELECT(3264,2228), //bcp->offset
    26, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20624C11,    ABISELECT(3056,2084), //bcp->offset
    23, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S20624C10,    ABISELECT(288,204), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20624C5,    ABISELECT(720,472), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20624C5,    ABISELECT(928,616), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(1136,760), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(1136,760), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S20624C12,    ABISELECT(928,616), //bcp->offset
    20, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20624C11,    ABISELECT(720,472), //bcp->offset
    17, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20624C5,    ABISELECT(3968,2716), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    27, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S19008C4_nt,    ABISELECT(4176,2860), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(4176,2860), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S20624C12,    ABISELECT(3968,2716), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S20624C10,    ABISELECT(4928,3364), //bcp->offset
    46, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    27, //immediately_derived
  0, 1},
  {&cd_S19008C22,    ABISELECT(5352,3632), //bcp->offset
    52, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    27, //immediately_derived
  0, 1},
  {&cd_S19008C4_nt,    ABISELECT(4288,2928), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S20624C8,    ABISELECT(4288,2928), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S20624C21,    ABISELECT(3968,2716), //bcp->offset
    29, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20624C20[];
extern void _ZN8S20624C42v2Ev();
extern void _ZN9S20624C203v12Ev();
extern void _ZN9S20624C20D1Ev();
extern void _ZN9S20624C20D0Ev();
extern void _ZN9S20624C102v1Ev();
extern void ABISELECT(_ZTv0_n56_N9S20624C20D1Ev,_ZTv0_n28_N9S20624C20D1Ev)();
extern void ABISELECT(_ZThn3968_N9S20624C20D1Ev,_ZThn2716_N9S20624C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S20624C20D0Ev,_ZTv0_n28_N9S20624C20D0Ev)();
extern void ABISELECT(_ZThn3968_N9S20624C20D0Ev,_ZThn2716_N9S20624C20D0Ev)() __attribute__((weak));
extern void _ZN9S20624C212v8Ev();
extern void _ZN9S20624C212v9Ev();
extern void _ZN9S20624C213v10Ev();
extern void _ZN9S20624C213v11Ev();
extern void _ZN9S20624C102v1Ev();
extern void ABISELECT(_ZTv0_n24_N9S20624C20D1Ev,_ZTv0_n12_N9S20624C20D1Ev)();
extern void ABISELECT(_ZThn5352_N9S20624C20D1Ev,_ZThn3632_N9S20624C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20624C20D0Ev,_ZTv0_n12_N9S20624C20D0Ev)();
extern void ABISELECT(_ZThn5352_N9S20624C20D0Ev,_ZThn3632_N9S20624C20D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S20624C20[] = {
  ABISELECT(5352,3632),
  ABISELECT(4928,3364),
  ABISELECT(3968,2716),
  ABISELECT(3056,2084),
  ABISELECT(2688,1828),
  ABISELECT(3044,2080),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C20[0]),
  (VTBL_ENTRY)&_ZN8S20624C42v2Ev,
  (VTBL_ENTRY)&_ZN9S20624C203v12Ev,
  (VTBL_ENTRY)&_ZN9S20624C20D1Ev,
  (VTBL_ENTRY)&_ZN9S20624C20D0Ev,
  ABISELECT(2756,1876),
  ABISELECT(2768,1880),
  ABISELECT(-288,-204),
  (VTBL_ENTRY)&(_ZTI9S20624C20[0]),
  (VTBL_ENTRY)&_ZN9S20624C102v1Ev,
  ABISELECT(2324,1608),
  ABISELECT(-720,-472),
  (VTBL_ENTRY)&(_ZTI9S20624C20[0]),
  ABISELECT(2116,1464),
  ABISELECT(-928,-616),
  (VTBL_ENTRY)&(_ZTI9S20624C20[0]),
  ABISELECT(-12,-4),
  ABISELECT(-3056,-2084),
  (VTBL_ENTRY)&(_ZTI9S20624C20[0]),
  ABISELECT(-220,-148),
  ABISELECT(-3264,-2228),
  (VTBL_ENTRY)&(_ZTI9S20624C20[0]),
  0,
  0,
  0,
  0,
  ABISELECT(-3968,-2716),
  ABISELECT(1384,916),
  ABISELECT(960,648),
  ABISELECT(-912,-632),
  ABISELECT(-924,-636),
  ABISELECT(-3968,-2716),
  (VTBL_ENTRY)&(_ZTI9S20624C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20624C20D1Ev,_ZTv0_n28_N9S20624C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20624C20D0Ev,_ZTv0_n28_N9S20624C20D0Ev),
  (VTBL_ENTRY)&_ZN9S20624C212v8Ev,
  (VTBL_ENTRY)&_ZN9S20624C212v9Ev,
  (VTBL_ENTRY)&_ZN9S20624C213v10Ev,
  (VTBL_ENTRY)&_ZN9S20624C213v11Ev,
  0,
  ABISELECT(-1884,-1284),
  ABISELECT(-1872,-1280),
  ABISELECT(-4928,-3364),
  (VTBL_ENTRY)&(_ZTI9S20624C20[0]),
  (VTBL_ENTRY)&_ZN9S20624C102v1Ev,
  ABISELECT(-5352,-3632),
  ABISELECT(-5352,-3632),
  (VTBL_ENTRY)&(_ZTI9S20624C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20624C20D1Ev,_ZTv0_n12_N9S20624C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20624C20D0Ev,_ZTv0_n12_N9S20624C20D0Ev),
};
extern VTBL_ENTRY _ZTV9S20624C20[];
extern void _ZN8S20624C42v2Ev();
static  VTBL_ENTRY _tg__ZTV8S20624C4__9S20624C20[] = {
  ABISELECT(3044,2080),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C4[0]),
  (VTBL_ENTRY)&_ZN8S20624C42v2Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20624C58S20624C4__9S20624C20[] = {
  ABISELECT(3044,2080),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
extern void _ZN9S20624C102v1Ev();
static  VTBL_ENTRY _tg__ZTV9S20624C10__A__9S20624C20[] = {
  ABISELECT(2756,1876),
  ABISELECT(2768,1880),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C10[0]),
  (VTBL_ENTRY)&_ZN9S20624C102v1Ev,
};
static  VTBL_ENTRY _tg__ZTV9S20624C11__9S20624C10__A__9S20624C20[] = {
  ABISELECT(-12,-4),
  ABISELECT(-2768,-1880),
  (VTBL_ENTRY)&(_ZTI9S20624C10[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C129S20624C11__9S20624C10__A__9S20624C20[] = {
  ABISELECT(-220,-148),
  ABISELECT(-2976,-2024),
  (VTBL_ENTRY)&(_ZTI9S20624C10[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C11__A__9S20624C20[] = {
  ABISELECT(2324,1608),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C11[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C11__A3__9S20624C20[] = {
  ABISELECT(2324,1608),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C129S20624C11__A1__9S20624C20[] = {
  ABISELECT(2116,1464),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C129S20624C11__A4__9S20624C20[] = {
  ABISELECT(2116,1464),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C12__9S20624C11__A__9S20624C20[] = {
  ABISELECT(2116,1464),
  ABISELECT(-208,-144),
  (VTBL_ENTRY)&(_ZTI9S20624C11[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C11__9S20624C20[] = {
  ABISELECT(-12,-4),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C11[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C11__A1__9S20624C20[] = {
  ABISELECT(-12,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C129S20624C11__9S20624C20[] = {
  ABISELECT(-220,-148),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C129S20624C11__A2__9S20624C20[] = {
  ABISELECT(-220,-148),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C12__9S20624C11__9S20624C20[] = {
  ABISELECT(-220,-148),
  ABISELECT(-208,-144),
  (VTBL_ENTRY)&(_ZTI9S20624C11[0]),
};
extern void _ZN9S20624C21D1Ev();
extern void _ZN9S20624C21D0Ev();
extern void _ZN9S20624C212v8Ev();
extern void _ZN9S20624C212v9Ev();
extern void _ZN9S20624C213v10Ev();
extern void _ZN9S20624C213v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20624C21__9S20624C20[] = {
  ABISELECT(1384,916),
  ABISELECT(960,648),
  ABISELECT(-912,-632),
  ABISELECT(-924,-636),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C21[0]),
  (VTBL_ENTRY)&_ZN9S20624C21D1Ev,
  (VTBL_ENTRY)&_ZN9S20624C21D0Ev,
  (VTBL_ENTRY)&_ZN9S20624C212v8Ev,
  (VTBL_ENTRY)&_ZN9S20624C212v9Ev,
  (VTBL_ENTRY)&_ZN9S20624C213v10Ev,
  (VTBL_ENTRY)&_ZN9S20624C213v11Ev,
};
static  VTBL_ENTRY _tg__ZTV9S20624C129S20624C21__A2__9S20624C20[] = {
  ABISELECT(-924,-636),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20624C59S20624C129S20624C21__A5__9S20624C20[] = {
  ABISELECT(-924,-636),
  0,
  (VTBL_ENTRY)&(_ZTI8S20624C5[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C11__9S20624C21__9S20624C20[] = {
  ABISELECT(-12,-4),
  ABISELECT(912,632),
  (VTBL_ENTRY)&(_ZTI9S20624C21[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C129S20624C11__9S20624C21__9S20624C20[] = {
  ABISELECT(-220,-148),
  ABISELECT(704,488),
  (VTBL_ENTRY)&(_ZTI9S20624C21[0]),
};
extern void _ZN9S20624C102v1Ev();
static  VTBL_ENTRY _tg__ZTV9S20624C10__9S20624C21__9S20624C20[] = {
  0,
  ABISELECT(-1884,-1284),
  ABISELECT(-1872,-1280),
  ABISELECT(-960,-648),
  (VTBL_ENTRY)&(_ZTI9S20624C21[0]),
  (VTBL_ENTRY)&_ZN9S20624C102v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20624C21D1Ev,_ZTv0_n12_N9S20624C21D1Ev)();
extern void ABISELECT(_ZThn1384_N9S20624C21D1Ev,_ZThn916_N9S20624C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20624C21D0Ev,_ZTv0_n12_N9S20624C21D0Ev)();
extern void ABISELECT(_ZThn1384_N9S20624C21D0Ev,_ZThn916_N9S20624C21D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19008C22__9S20624C21__9S20624C20[] = {
  ABISELECT(-1384,-916),
  ABISELECT(-1384,-916),
  (VTBL_ENTRY)&(_ZTI9S20624C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20624C21D1Ev,_ZTv0_n12_N9S20624C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20624C21D0Ev,_ZTv0_n12_N9S20624C21D0Ev),
};
extern void _ZN9S20624C102v1Ev();
static  VTBL_ENTRY _tg__ZTV9S20624C10__A1__9S20624C20[] = {
  ABISELECT(-1884,-1284),
  ABISELECT(-1872,-1280),
  0,
  (VTBL_ENTRY)&(_ZTI9S20624C10[0]),
  (VTBL_ENTRY)&_ZN9S20624C102v1Ev,
};
static  VTBL_ENTRY _tg__ZTV9S20624C11__9S20624C10__A1__9S20624C20[] = {
  ABISELECT(-12,-4),
  ABISELECT(1872,1280),
  (VTBL_ENTRY)&(_ZTI9S20624C10[0]),
};
static  VTBL_ENTRY _tg__ZTV9S20624C129S20624C11__9S20624C10__A1__9S20624C20[] = {
  ABISELECT(-220,-148),
  ABISELECT(1664,1136),
  (VTBL_ENTRY)&(_ZTI9S20624C10[0]),
};
static  VTT_ENTRY vtt_S20624C20[] = {
  {&(_ZTV9S20624C20[8]),  8,57},
  {&(_tg__ZTV8S20624C4__9S20624C20[3]),  3,4},
  {&(_tg__ZTV8S20624C58S20624C4__9S20624C20[3]),  3,3},
  {&(_tg__ZTV9S20624C10__A__9S20624C20[4]),  4,5},
  {&(_tg__ZTV9S20624C11__9S20624C10__A__9S20624C20[3]),  3,3},
  {&(_tg__ZTV9S20624C129S20624C11__9S20624C10__A__9S20624C20[3]),  3,3},
  {&(_tg__ZTV9S20624C11__A__9S20624C20[3]),  3,3},
  {&(_tg__ZTV8S20624C59S20624C11__A3__9S20624C20[3]),  3,3},
  {&(_tg__ZTV9S20624C129S20624C11__A1__9S20624C20[3]),  3,3},
  {&(_tg__ZTV8S20624C59S20624C129S20624C11__A4__9S20624C20[3]),  3,3},
  {&(_tg__ZTV9S20624C12__9S20624C11__A__9S20624C20[3]),  3,3},
  {&(_ZTV9S20624C20[16]),  16,57},
  {&(_ZTV9S20624C20[26]),  26,57},
  {&(_ZTV9S20624C20[29]),  29,57},
  {&(_ZTV9S20624C20[20]),  20,57},
  {&(_ZTV9S20624C20[23]),  23,57},
  {&(_ZTV9S20624C20[40]),  40,57},
  {&(_ZTV9S20624C20[51]),  51,57},
  {&(_ZTV9S20624C20[55]),  55,57},
  {&(_tg__ZTV9S20624C11__9S20624C20[3]),  3,3},
  {&(_tg__ZTV8S20624C59S20624C11__A1__9S20624C20[3]),  3,3},
  {&(_tg__ZTV9S20624C129S20624C11__9S20624C20[3]),  3,3},
  {&(_tg__ZTV8S20624C59S20624C129S20624C11__A2__9S20624C20[3]),  3,3},
  {&(_tg__ZTV9S20624C12__9S20624C11__9S20624C20[3]),  3,3},
  {&(_tg__ZTV9S20624C21__9S20624C20[6]),  6,12},
  {&(_tg__ZTV9S20624C129S20624C21__A2__9S20624C20[3]),  3,3},
  {&(_tg__ZTV8S20624C59S20624C129S20624C21__A5__9S20624C20[3]),  3,3},
  {&(_tg__ZTV9S20624C11__9S20624C21__9S20624C20[3]),  3,3},
  {&(_tg__ZTV9S20624C129S20624C11__9S20624C21__9S20624C20[3]),  3,3},
  {&(_tg__ZTV9S20624C10__9S20624C21__9S20624C20[5]),  5,6},
  {&(_tg__ZTV9S19008C22__9S20624C21__9S20624C20[3]),  3,5},
  {&(_tg__ZTV9S20624C10__A1__9S20624C20[4]),  4,5},
  {&(_tg__ZTV9S20624C11__9S20624C10__A1__9S20624C20[3]),  3,3},
  {&(_tg__ZTV9S20624C129S20624C11__9S20624C10__A1__9S20624C20[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20624C20[];
extern  VTBL_ENTRY _ZTV9S20624C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20624C20[];
static VTBL_ENTRY alt_thunk_names16[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20624C21D0Ev,_ZTv0_n12_N9S20624C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1384_N9S20624C21D0Ev,_ZThn916_N9S20624C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20624C21D1Ev,_ZTv0_n12_N9S20624C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1384_N9S20624C21D1Ev,_ZThn916_N9S20624C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20624C20D0Ev,_ZTv0_n12_N9S20624C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5352_N9S20624C20D0Ev,_ZThn3632_N9S20624C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20624C20D1Ev,_ZTv0_n12_N9S20624C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5352_N9S20624C20D1Ev,_ZThn3632_N9S20624C20D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20624C20D0Ev,_ZTv0_n28_N9S20624C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3968_N9S20624C20D0Ev,_ZThn2716_N9S20624C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20624C20D1Ev,_ZTv0_n28_N9S20624C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3968_N9S20624C20D1Ev,_ZThn2716_N9S20624C20D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20624C20 = {  "S20624C20", // class name
  bases_S20624C20, 28,
  &(vtc_S20624C20[0]), // expected_vtbl_contents
  &(vtt_S20624C20[0]), // expected_vtt_contents
  ABISELECT(5424,3700), // object size
  NSPAIRA(_ZTI9S20624C20),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S20624C20),57, //virtual function table var
  8, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20624C20),34, //virtual table table var
  16, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names16,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20624C18  : S20624C2 , S20624C19 , S20624C20 , S20624C11 {
  __tsi64 s20624c18f0;
  void *s20624c18f1;
  virtual void  v13(); // _ZN9S20624C183v13Ev
  virtual void  v14(); // _ZN9S20624C183v14Ev
  virtual void  v15(); // _ZN9S20624C183v15Ev
  ~S20624C18(); // tgen
  S20624C18(); // tgen
};
//SIG(-1 S20624C18) C1{ BC2{ VBC3{ m Fi Fi:20 FC4{ BC5{ VBC6{ m Fi} Fp FL Fi Fp Fi FU7{ m Fp FL[9] Fc:0 Fp[2] FL[7]} Fc Fc FD FC6 FC8{ BC6 Fi FU9{ m Fi FL FD Fc:2 Fc[7] Fi Fi Fp}} Fp} BC8 v15 Fi FL Fi FL FC6 Fi Fs Fi} Fi Fc[4] Fi Fi Fi Fi Fi Fi Fi} BC10{ VBC11{ VBC6 BC12{ VBC6 Fp FL Fi Fp Fi FU7 Fc Fc FD FC6 FC13{ BC6 Fi FU9} Fp} BC14{ VBC6 BC12 BC13 FL FU9 Fp Fp FC15{} Fi Fi Fp Fc FC15} FC16{ BC12 BC13 v5 Fi FL Fi FL FC6 Fi Fs Fi} Fi[6] Fi FC6[7] Fi Fp[2]} v4 Fp[7] Fi Fs FD Fi FC16 Fi} BC16 BC17{ BC14 BC13 BC12 VBC18{ BC6 BC16 BC13 VBC14 BC12 vd v6 v7 FU9 FD Fc Fp FL FC13 Fi Fp[10] Fi FC14 Fi} vd v8 v9 Fs Fs FC13[5] FL FD FL Fi Fi Fp} vd Fi Fi Fp FD[6] Fi Fi FD Fi Fi Fi} BC19{ BC18 BC12 BC3 VBC2 vd Fi FL FU7 Fi Fi FC15 FC18} BC20{ VBC3 BC16 BC10 BC11 VBC21{ VBC11 BC14 VBC10 VBC22{ vd m Fi Fi:1 Fi Fi Fi:9 Fi Fi Fi[8] Fs} BC13 vd v10 v11 v12 v13 FD FC6 Fi Fp[4] Fi[5] FC16 FC12 Fc} v14 Fi Fp[2] Fc FC14[2] FC22 FC16} BC11 v1 v2 v3 FL Fp}


void  S20624C18 ::v13(){vfunc_called(this, "_ZN9S20624C183v13Ev");}
void  S20624C18 ::v14(){vfunc_called(this, "_ZN9S20624C183v14Ev");}
void  S20624C18 ::v15(){vfunc_called(this, "_ZN9S20624C183v15Ev");}
S20624C18 ::~S20624C18(){ note_dtor("S20624C18", this);} // tgen
S20624C18 ::S20624C18(){ note_ctor("S20624C18", this);} // tgen

static void Test_S20624C18()
{
  extern Class_Descriptor cd_S20624C18;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(890,2396)];
    init_test(&cd_S20624C18, buf);
    S20624C18 *dp, &lv = *(dp=new (buf) S20624C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(14224,9580), "sizeof(S20624C18)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20624C18)");
    /*is_ambiguous_... S20624C18::S20624C2 */ AMB_check_base_class_offset(lv, (S19008C13*)(S20624C2*), ABISELECT(8416,5688), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C2 */ AMB_check_base_class_offset(lv, (S19008C13*)(S20624C2*), ABISELECT(8416,5688), "S20624C18");
    check_base_class_offset(lv, (S19008C13*)(S20624C20*), ABISELECT(8416,5688), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C11 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C11*), ABISELECT(9696,6572), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C11 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C11*), ABISELECT(9696,6572), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C11 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C12*)(S20624C11*), ABISELECT(9696,6572), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C11 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C12*)(S20624C11*), ABISELECT(9696,6572), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C2 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C4*)(S20624C2*), ABISELECT(9696,6572), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C2 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C12*)(S20624C14*)(S20624C2*), ABISELECT(9696,6572), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C2 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C12*)(S20624C14*)(S20624C2*), ABISELECT(9696,6572), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C2 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C14*)(S20624C2*), ABISELECT(9696,6572), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C4*)(S20624C15*), ABISELECT(9696,6572), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C12 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C12*), ABISELECT(9696,6572), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C12 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C12*), ABISELECT(9696,6572), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C15*), ABISELECT(9696,6572), "S20624C18");
    /*is_ambiguous_... S20624C19::S20624C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C4*)(S20624C15*)(S20624C19*), ABISELECT(9696,6572), "S20624C18");
    /*is_ambiguous_... S20624C19::S20624C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C15*)(S20624C19*), ABISELECT(9696,6572), "S20624C18");
    /*is_ambiguous_... S20624C19::S20624C5 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C19*), ABISELECT(9696,6572), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C2 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C4*)(S20624C2*), ABISELECT(9696,6572), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C2 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C12*)(S20624C14*)(S20624C2*), ABISELECT(9696,6572), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C2 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C12*)(S20624C14*)(S20624C2*), ABISELECT(9696,6572), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C2 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C14*)(S20624C2*), ABISELECT(9696,6572), "S20624C18");
    check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C4*)(S20624C20*), ABISELECT(9696,6572), "S20624C18");
    /*is_ambiguous_... S20624C20::S20624C11 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C11*)(S20624C20*), ABISELECT(9696,6572), "S20624C18");
    /*is_ambiguous_... S20624C20::S20624C11 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C11*)(S20624C20*), ABISELECT(9696,6572), "S20624C18");
    /*is_ambiguous_... S20624C20::S20624C11 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C12*)(S20624C11*)(S20624C20*), ABISELECT(9696,6572), "S20624C18");
    /*is_ambiguous_... S20624C20::S20624C11 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C12*)(S20624C11*)(S20624C20*), ABISELECT(9696,6572), "S20624C18");
    /*is_ambiguous_... S20624C21::S20624C12 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C12*)(S20624C21*), ABISELECT(9696,6572), "S20624C18");
    /*is_ambiguous_... S20624C21::S20624C12 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C12*)(S20624C21*), ABISELECT(9696,6572), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C11 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C11*), ABISELECT(9696,6572), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C11 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C11*), ABISELECT(9696,6572), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C11 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C12*)(S20624C11*), ABISELECT(9696,6572), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C11 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C5*)(S20624C12*)(S20624C11*), ABISELECT(9696,6572), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C11 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C11*), ABISELECT(8784,5940), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C11 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C12*)(S20624C11*), ABISELECT(8992,6084), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C11 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C12*)(S20624C11*), ABISELECT(9200,6228), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C11 */ AMB_check_base_class_offset(lv, (S20624C8*)(S20624C12*)(S20624C11*), ABISELECT(9200,6228), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C11 */ AMB_check_base_class_offset(lv, (S20624C12*)(S20624C11*), ABISELECT(8992,6084), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C2 */ AMB_check_base_class_offset(lv, (S20624C11*)(S20624C10*)(S20624C2*), ABISELECT(8784,5940), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C2 */ AMB_check_base_class_offset(lv, (S20624C11*)(S20624C10*)(S20624C2*), ABISELECT(8784,5940), "S20624C18");
    /*is_ambiguous_... S20624C20::S20624C10 */ AMB_check_base_class_offset(lv, (S20624C11*)(S20624C10*)(S20624C20*), ABISELECT(8784,5940), "S20624C18");
    check_base_class_offset(lv, (S20624C11*)(S20624C21*), ABISELECT(8784,5940), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C10 */ AMB_check_base_class_offset(lv, (S20624C11*)(S20624C10*), ABISELECT(8784,5940), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C2 */ AMB_check_base_class_offset(lv, (S20624C10*)(S20624C2*), 0, "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C2 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C4*)(S20624C2*), ABISELECT(432,268), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C2 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C4*)(S20624C2*), ABISELECT(640,412), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C2 */ AMB_check_base_class_offset(lv, (S20624C8*)(S20624C4*)(S20624C2*), ABISELECT(640,412), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C2 */ AMB_check_base_class_offset(lv, (S20624C4*)(S20624C2*), ABISELECT(432,268), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C2 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C12*)(S20624C14*)(S20624C2*), ABISELECT(720,472), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C2 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C12*)(S20624C14*)(S20624C2*), ABISELECT(928,616), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C2 */ AMB_check_base_class_offset(lv, (S20624C8*)(S20624C12*)(S20624C14*)(S20624C2*), ABISELECT(928,616), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C2 */ AMB_check_base_class_offset(lv, (S20624C12*)(S20624C14*)(S20624C2*), ABISELECT(720,472), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C2 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C14*)(S20624C2*), ABISELECT(1040,684), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C2 */ AMB_check_base_class_offset(lv, (S20624C8*)(S20624C14*)(S20624C2*), ABISELECT(1040,684), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C2 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C14*)(S20624C2*), ABISELECT(1072,704), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C15*), ABISELECT(10000,6780), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C15 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C4*)(S20624C15*), ABISELECT(9712,6576), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C4*)(S20624C15*), ABISELECT(9920,6720), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C15 */ AMB_check_base_class_offset(lv, (S20624C8*)(S20624C4*)(S20624C15*), ABISELECT(9920,6720), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C15 */ AMB_check_base_class_offset(lv, (S20624C4*)(S20624C15*), ABISELECT(9712,6576), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C15 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C15*), ABISELECT(10016,6784), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C15 */ AMB_check_base_class_offset(lv, (S20624C8*)(S20624C15*), ABISELECT(10016,6784), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C12 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C12*), ABISELECT(10784,7276), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C12 */ AMB_check_base_class_offset(lv, (S19008C4_nt*)(S20624C8*)(S20624C12*), ABISELECT(10992,7420), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C12 */ AMB_check_base_class_offset(lv, (S20624C8*)(S20624C12*), ABISELECT(10992,7420), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C15 */ AMB_check_base_class_offset(lv, (S20624C12*)(S20624C15*), ABISELECT(10784,7276), "S20624C18");
    /*is_ambiguous_... S20624C19::S20624C15 */ AMB_check_base_class_offset(lv, (S20624C12*)(S20624C15*)(S20624C19*), ABISELECT(10784,7276), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C15 */ AMB_check_base_class_offset(lv, (S20624C5*)(S20624C15*), ABISELECT(10048,6804), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C2 */ AMB_check_base_class_offset(lv, (S20624C15*)(S20624C14*)(S20624C2*), ABISELECT(9712,6576), "S20624C18");
    /*is_ambiguous_... S20624C18::S20624C2 */ AMB_check_base_class_offset(lv, (S20624C15*)(S20624C14*)(S20624C2*), ABISELECT(9712,6576), "S20624C18")