// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S249C7_nt  {
  int s249c7f0[2];
  void  mf249c7(); // _ZN9S249C7_nt7mf249c7Ev
};
//SIG(-1 S249C7_nt) C1{ m Fi[2]}


void  S249C7_nt ::mf249c7(){}

//skip512 S249C7_nt

#else // __cplusplus

Class_Descriptor cd_S249C7_nt = {  "S249C7_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C6_nt  {
  int s249c6f0;
  __tsi64 s249c6f1;
  void *s249c6f2[4];
  int s249c6f3[2];
  void *s249c6f4;
  ::S249C7_nt s249c6f5;
  void *s249c6f6[2];
  virtual  ~S249C6_nt(); // _ZN9S249C6_ntD1Ev
  virtual void  v5(); // _ZN9S249C6_nt2v5Ev
  virtual void  v6(); // _ZN9S249C6_nt2v6Ev
  virtual void  v7(); // _ZN9S249C6_nt2v7Ev
  virtual void  v8(); // _ZN9S249C6_nt2v8Ev
  virtual void  v9(); // _ZN9S249C6_nt2v9Ev
  virtual void  v10(); // _ZN9S249C6_nt3v10Ev
  virtual void  v11(); // _ZN9S249C6_nt3v11Ev
  virtual void  v12(); // _ZN9S249C6_nt3v12Ev
  virtual void  v13(); // _ZN9S249C6_nt3v13Ev
  virtual void  v14(); // _ZN9S249C6_nt3v14Ev
  virtual void  v15(); // _ZN9S249C6_nt3v15Ev
  virtual void  v16(); // _ZN9S249C6_nt3v16Ev
  virtual void  v17(); // _ZN9S249C6_nt3v17Ev
  virtual void  v18(); // _ZN9S249C6_nt3v18Ev
  virtual void  v19(); // _ZN9S249C6_nt3v19Ev
  virtual void  v20(); // _ZN9S249C6_nt3v20Ev
  virtual void  v21(); // _ZN9S249C6_nt3v21Ev
  virtual void  v22(); // _ZN9S249C6_nt3v22Ev
  virtual void  v23(); // _ZN9S249C6_nt3v23Ev
  virtual void  v24(); // _ZN9S249C6_nt3v24Ev
  virtual void  v25(); // _ZN9S249C6_nt3v25Ev
  virtual void  v26(); // _ZN9S249C6_nt3v26Ev
  virtual void  v27(); // _ZN9S249C6_nt3v27Ev
  virtual void  v28(); // _ZN9S249C6_nt3v28Ev
  virtual void  v29(); // _ZN9S249C6_nt3v29Ev
  virtual void  v30(); // _ZN9S249C6_nt3v30Ev
  virtual void  v31(); // _ZN9S249C6_nt3v31Ev
  virtual void  v32(); // _ZN9S249C6_nt3v32Ev
  virtual void  v33(); // _ZN9S249C6_nt3v33Ev
  virtual void  v34(); // _ZN9S249C6_nt3v34Ev
  virtual void  v35(); // _ZN9S249C6_nt3v35Ev
  virtual void  v36(); // _ZN9S249C6_nt3v36Ev
  virtual void  v37(); // _ZN9S249C6_nt3v37Ev
  virtual void  v38(); // _ZN9S249C6_nt3v38Ev
  virtual void  v39(); // _ZN9S249C6_nt3v39Ev
  virtual void  v40(); // _ZN9S249C6_nt3v40Ev
  virtual void  v41(); // _ZN9S249C6_nt3v41Ev
  virtual void  v42(); // _ZN9S249C6_nt3v42Ev
  virtual void  v43(); // _ZN9S249C6_nt3v43Ev
  virtual void  v44(); // _ZN9S249C6_nt3v44Ev
  virtual void  v45(); // _ZN9S249C6_nt3v45Ev
  virtual void  v46(); // _ZN9S249C6_nt3v46Ev
  virtual void  v47(); // _ZN9S249C6_nt3v47Ev
  virtual void  v48(); // _ZN9S249C6_nt3v48Ev
  virtual void  v49(); // _ZN9S249C6_nt3v49Ev
  virtual void  v50(); // _ZN9S249C6_nt3v50Ev
  virtual void  v51(); // _ZN9S249C6_nt3v51Ev
  virtual void  v52(); // _ZN9S249C6_nt3v52Ev
  virtual void  v53(); // _ZN9S249C6_nt3v53Ev
  virtual void  v54(); // _ZN9S249C6_nt3v54Ev
  virtual void  v55(); // _ZN9S249C6_nt3v55Ev
  virtual void  v56(); // _ZN9S249C6_nt3v56Ev
  virtual void  v57(); // _ZN9S249C6_nt3v57Ev
  virtual void  v58(); // _ZN9S249C6_nt3v58Ev
  virtual void  v59(); // _ZN9S249C6_nt3v59Ev
  virtual void  v60(); // _ZN9S249C6_nt3v60Ev
  virtual void  v61(); // _ZN9S249C6_nt3v61Ev
  virtual void  v62(); // _ZN9S249C6_nt3v62Ev
  virtual void  v63(); // _ZN9S249C6_nt3v63Ev
  virtual void  v64(); // _ZN9S249C6_nt3v64Ev
  virtual void  v65(); // _ZN9S249C6_nt3v65Ev
  virtual void  v66(); // _ZN9S249C6_nt3v66Ev
  virtual void  v67(); // _ZN9S249C6_nt3v67Ev
  virtual void  v68(); // _ZN9S249C6_nt3v68Ev
  S249C6_nt(); // tgen
};
//SIG(-1 S249C6_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S249C6_nt ::~S249C6_nt(){ note_dtor("S249C6_nt", this);}
void  S249C6_nt ::v5(){vfunc_called(this, "_ZN9S249C6_nt2v5Ev");}
void  S249C6_nt ::v6(){vfunc_called(this, "_ZN9S249C6_nt2v6Ev");}
void  S249C6_nt ::v7(){vfunc_called(this, "_ZN9S249C6_nt2v7Ev");}
void  S249C6_nt ::v8(){vfunc_called(this, "_ZN9S249C6_nt2v8Ev");}
void  S249C6_nt ::v9(){vfunc_called(this, "_ZN9S249C6_nt2v9Ev");}
void  S249C6_nt ::v10(){vfunc_called(this, "_ZN9S249C6_nt3v10Ev");}
void  S249C6_nt ::v11(){vfunc_called(this, "_ZN9S249C6_nt3v11Ev");}
void  S249C6_nt ::v12(){vfunc_called(this, "_ZN9S249C6_nt3v12Ev");}
void  S249C6_nt ::v13(){vfunc_called(this, "_ZN9S249C6_nt3v13Ev");}
void  S249C6_nt ::v14(){vfunc_called(this, "_ZN9S249C6_nt3v14Ev");}
void  S249C6_nt ::v15(){vfunc_called(this, "_ZN9S249C6_nt3v15Ev");}
void  S249C6_nt ::v16(){vfunc_called(this, "_ZN9S249C6_nt3v16Ev");}
void  S249C6_nt ::v17(){vfunc_called(this, "_ZN9S249C6_nt3v17Ev");}
void  S249C6_nt ::v18(){vfunc_called(this, "_ZN9S249C6_nt3v18Ev");}
void  S249C6_nt ::v19(){vfunc_called(this, "_ZN9S249C6_nt3v19Ev");}
void  S249C6_nt ::v20(){vfunc_called(this, "_ZN9S249C6_nt3v20Ev");}
void  S249C6_nt ::v21(){vfunc_called(this, "_ZN9S249C6_nt3v21Ev");}
void  S249C6_nt ::v22(){vfunc_called(this, "_ZN9S249C6_nt3v22Ev");}
void  S249C6_nt ::v23(){vfunc_called(this, "_ZN9S249C6_nt3v23Ev");}
void  S249C6_nt ::v24(){vfunc_called(this, "_ZN9S249C6_nt3v24Ev");}
void  S249C6_nt ::v25(){vfunc_called(this, "_ZN9S249C6_nt3v25Ev");}
void  S249C6_nt ::v26(){vfunc_called(this, "_ZN9S249C6_nt3v26Ev");}
void  S249C6_nt ::v27(){vfunc_called(this, "_ZN9S249C6_nt3v27Ev");}
void  S249C6_nt ::v28(){vfunc_called(this, "_ZN9S249C6_nt3v28Ev");}
void  S249C6_nt ::v29(){vfunc_called(this, "_ZN9S249C6_nt3v29Ev");}
void  S249C6_nt ::v30(){vfunc_called(this, "_ZN9S249C6_nt3v30Ev");}
void  S249C6_nt ::v31(){vfunc_called(this, "_ZN9S249C6_nt3v31Ev");}
void  S249C6_nt ::v32(){vfunc_called(this, "_ZN9S249C6_nt3v32Ev");}
void  S249C6_nt ::v33(){vfunc_called(this, "_ZN9S249C6_nt3v33Ev");}
void  S249C6_nt ::v34(){vfunc_called(this, "_ZN9S249C6_nt3v34Ev");}
void  S249C6_nt ::v35(){vfunc_called(this, "_ZN9S249C6_nt3v35Ev");}
void  S249C6_nt ::v36(){vfunc_called(this, "_ZN9S249C6_nt3v36Ev");}
void  S249C6_nt ::v37(){vfunc_called(this, "_ZN9S249C6_nt3v37Ev");}
void  S249C6_nt ::v38(){vfunc_called(this, "_ZN9S249C6_nt3v38Ev");}
void  S249C6_nt ::v39(){vfunc_called(this, "_ZN9S249C6_nt3v39Ev");}
void  S249C6_nt ::v40(){vfunc_called(this, "_ZN9S249C6_nt3v40Ev");}
void  S249C6_nt ::v41(){vfunc_called(this, "_ZN9S249C6_nt3v41Ev");}
void  S249C6_nt ::v42(){vfunc_called(this, "_ZN9S249C6_nt3v42Ev");}
void  S249C6_nt ::v43(){vfunc_called(this, "_ZN9S249C6_nt3v43Ev");}
void  S249C6_nt ::v44(){vfunc_called(this, "_ZN9S249C6_nt3v44Ev");}
void  S249C6_nt ::v45(){vfunc_called(this, "_ZN9S249C6_nt3v45Ev");}
void  S249C6_nt ::v46(){vfunc_called(this, "_ZN9S249C6_nt3v46Ev");}
void  S249C6_nt ::v47(){vfunc_called(this, "_ZN9S249C6_nt3v47Ev");}
void  S249C6_nt ::v48(){vfunc_called(this, "_ZN9S249C6_nt3v48Ev");}
void  S249C6_nt ::v49(){vfunc_called(this, "_ZN9S249C6_nt3v49Ev");}
void  S249C6_nt ::v50(){vfunc_called(this, "_ZN9S249C6_nt3v50Ev");}
void  S249C6_nt ::v51(){vfunc_called(this, "_ZN9S249C6_nt3v51Ev");}
void  S249C6_nt ::v52(){vfunc_called(this, "_ZN9S249C6_nt3v52Ev");}
void  S249C6_nt ::v53(){vfunc_called(this, "_ZN9S249C6_nt3v53Ev");}
void  S249C6_nt ::v54(){vfunc_called(this, "_ZN9S249C6_nt3v54Ev");}
void  S249C6_nt ::v55(){vfunc_called(this, "_ZN9S249C6_nt3v55Ev");}
void  S249C6_nt ::v56(){vfunc_called(this, "_ZN9S249C6_nt3v56Ev");}
void  S249C6_nt ::v57(){vfunc_called(this, "_ZN9S249C6_nt3v57Ev");}
void  S249C6_nt ::v58(){vfunc_called(this, "_ZN9S249C6_nt3v58Ev");}
void  S249C6_nt ::v59(){vfunc_called(this, "_ZN9S249C6_nt3v59Ev");}
void  S249C6_nt ::v60(){vfunc_called(this, "_ZN9S249C6_nt3v60Ev");}
void  S249C6_nt ::v61(){vfunc_called(this, "_ZN9S249C6_nt3v61Ev");}
void  S249C6_nt ::v62(){vfunc_called(this, "_ZN9S249C6_nt3v62Ev");}
void  S249C6_nt ::v63(){vfunc_called(this, "_ZN9S249C6_nt3v63Ev");}
void  S249C6_nt ::v64(){vfunc_called(this, "_ZN9S249C6_nt3v64Ev");}
void  S249C6_nt ::v65(){vfunc_called(this, "_ZN9S249C6_nt3v65Ev");}
void  S249C6_nt ::v66(){vfunc_called(this, "_ZN9S249C6_nt3v66Ev");}
void  S249C6_nt ::v67(){vfunc_called(this, "_ZN9S249C6_nt3v67Ev");}
void  S249C6_nt ::v68(){vfunc_called(this, "_ZN9S249C6_nt3v68Ev");}
S249C6_nt ::S249C6_nt(){ note_ctor("S249C6_nt", this);} // tgen

//skip512 S249C6_nt

#else // __cplusplus

extern void _ZN9S249C6_ntC1Ev();
extern void _ZN9S249C6_ntD1Ev();
Name_Map name_map_S249C6_nt[] = {
  NSPAIR(_ZN9S249C6_ntC1Ev),
  NSPAIR(_ZN9S249C6_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S249C6_nt[];
extern void _ZN9S249C6_ntD1Ev();
extern void _ZN9S249C6_ntD0Ev();
extern void _ZN9S249C6_nt2v5Ev();
extern void _ZN9S249C6_nt2v6Ev();
extern void _ZN9S249C6_nt2v7Ev();
extern void _ZN9S249C6_nt2v8Ev();
extern void _ZN9S249C6_nt2v9Ev();
extern void _ZN9S249C6_nt3v10Ev();
extern void _ZN9S249C6_nt3v11Ev();
extern void _ZN9S249C6_nt3v12Ev();
extern void _ZN9S249C6_nt3v13Ev();
extern void _ZN9S249C6_nt3v14Ev();
extern void _ZN9S249C6_nt3v15Ev();
extern void _ZN9S249C6_nt3v16Ev();
extern void _ZN9S249C6_nt3v17Ev();
extern void _ZN9S249C6_nt3v18Ev();
extern void _ZN9S249C6_nt3v19Ev();
extern void _ZN9S249C6_nt3v20Ev();
extern void _ZN9S249C6_nt3v21Ev();
extern void _ZN9S249C6_nt3v22Ev();
extern void _ZN9S249C6_nt3v23Ev();
extern void _ZN9S249C6_nt3v24Ev();
extern void _ZN9S249C6_nt3v25Ev();
extern void _ZN9S249C6_nt3v26Ev();
extern void _ZN9S249C6_nt3v27Ev();
extern void _ZN9S249C6_nt3v28Ev();
extern void _ZN9S249C6_nt3v29Ev();
extern void _ZN9S249C6_nt3v30Ev();
extern void _ZN9S249C6_nt3v31Ev();
extern void _ZN9S249C6_nt3v32Ev();
extern void _ZN9S249C6_nt3v33Ev();
extern void _ZN9S249C6_nt3v34Ev();
extern void _ZN9S249C6_nt3v35Ev();
extern void _ZN9S249C6_nt3v36Ev();
extern void _ZN9S249C6_nt3v37Ev();
extern void _ZN9S249C6_nt3v38Ev();
extern void _ZN9S249C6_nt3v39Ev();
extern void _ZN9S249C6_nt3v40Ev();
extern void _ZN9S249C6_nt3v41Ev();
extern void _ZN9S249C6_nt3v42Ev();
extern void _ZN9S249C6_nt3v43Ev();
extern void _ZN9S249C6_nt3v44Ev();
extern void _ZN9S249C6_nt3v45Ev();
extern void _ZN9S249C6_nt3v46Ev();
extern void _ZN9S249C6_nt3v47Ev();
extern void _ZN9S249C6_nt3v48Ev();
extern void _ZN9S249C6_nt3v49Ev();
extern void _ZN9S249C6_nt3v50Ev();
extern void _ZN9S249C6_nt3v51Ev();
extern void _ZN9S249C6_nt3v52Ev();
extern void _ZN9S249C6_nt3v53Ev();
extern void _ZN9S249C6_nt3v54Ev();
extern void _ZN9S249C6_nt3v55Ev();
extern void _ZN9S249C6_nt3v56Ev();
extern void _ZN9S249C6_nt3v57Ev();
extern void _ZN9S249C6_nt3v58Ev();
extern void _ZN9S249C6_nt3v59Ev();
extern void _ZN9S249C6_nt3v60Ev();
extern void _ZN9S249C6_nt3v61Ev();
extern void _ZN9S249C6_nt3v62Ev();
extern void _ZN9S249C6_nt3v63Ev();
extern void _ZN9S249C6_nt3v64Ev();
extern void _ZN9S249C6_nt3v65Ev();
extern void _ZN9S249C6_nt3v66Ev();
extern void _ZN9S249C6_nt3v67Ev();
extern void _ZN9S249C6_nt3v68Ev();
static  VTBL_ENTRY vtc_S249C6_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S249C6_nt[0]),
  (VTBL_ENTRY)&_ZN9S249C6_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S249C6_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v68Ev,
};
extern VTBL_ENTRY _ZTI9S249C6_nt[];
VTBL_ENTRY *P__ZTI9S249C6_nt = _ZTI9S249C6_nt; 
extern  VTBL_ENTRY _ZTV9S249C6_nt[];
Class_Descriptor cd_S249C6_nt = {  "S249C6_nt", // class name
  0,0,//no base classes
  &(vtc_S249C6_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI9S249C6_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S249C6_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C5_nt  : S249C6_nt {
  virtual  ~S249C5_nt(); // _ZN9S249C5_ntD1Ev
  virtual void  v69(); // _ZN9S249C5_nt3v69Ev
  virtual void  v70(); // _ZN9S249C5_nt3v70Ev
  S249C5_nt(); // tgen
};
//SIG(-1 S249C5_nt) C1{ BC2{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2}


 S249C5_nt ::~S249C5_nt(){ note_dtor("S249C5_nt", this);}
void  S249C5_nt ::v69(){vfunc_called(this, "_ZN9S249C5_nt3v69Ev");}
void  S249C5_nt ::v70(){vfunc_called(this, "_ZN9S249C5_nt3v70Ev");}
S249C5_nt ::S249C5_nt(){ note_ctor("S249C5_nt", this);} // tgen

//skip512 S249C5_nt

#else // __cplusplus

extern void _ZN9S249C5_ntC1Ev();
extern void _ZN9S249C5_ntD1Ev();
Name_Map name_map_S249C5_nt[] = {
  NSPAIR(_ZN9S249C5_ntC1Ev),
  NSPAIR(_ZN9S249C5_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S249C6_nt;
extern VTBL_ENTRY _ZTI9S249C6_nt[];
extern  VTBL_ENTRY _ZTV9S249C6_nt[];
static Base_Class bases_S249C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S249C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S249C5_nt[];
extern void _ZN9S249C5_ntD1Ev();
extern void _ZN9S249C5_ntD0Ev();
extern void _ZN9S249C6_nt2v5Ev();
extern void _ZN9S249C6_nt2v6Ev();
extern void _ZN9S249C6_nt2v7Ev();
extern void _ZN9S249C6_nt2v8Ev();
extern void _ZN9S249C6_nt2v9Ev();
extern void _ZN9S249C6_nt3v10Ev();
extern void _ZN9S249C6_nt3v11Ev();
extern void _ZN9S249C6_nt3v12Ev();
extern void _ZN9S249C6_nt3v13Ev();
extern void _ZN9S249C6_nt3v14Ev();
extern void _ZN9S249C6_nt3v15Ev();
extern void _ZN9S249C6_nt3v16Ev();
extern void _ZN9S249C6_nt3v17Ev();
extern void _ZN9S249C6_nt3v18Ev();
extern void _ZN9S249C6_nt3v19Ev();
extern void _ZN9S249C6_nt3v20Ev();
extern void _ZN9S249C6_nt3v21Ev();
extern void _ZN9S249C6_nt3v22Ev();
extern void _ZN9S249C6_nt3v23Ev();
extern void _ZN9S249C6_nt3v24Ev();
extern void _ZN9S249C6_nt3v25Ev();
extern void _ZN9S249C6_nt3v26Ev();
extern void _ZN9S249C6_nt3v27Ev();
extern void _ZN9S249C6_nt3v28Ev();
extern void _ZN9S249C6_nt3v29Ev();
extern void _ZN9S249C6_nt3v30Ev();
extern void _ZN9S249C6_nt3v31Ev();
extern void _ZN9S249C6_nt3v32Ev();
extern void _ZN9S249C6_nt3v33Ev();
extern void _ZN9S249C6_nt3v34Ev();
extern void _ZN9S249C6_nt3v35Ev();
extern void _ZN9S249C6_nt3v36Ev();
extern void _ZN9S249C6_nt3v37Ev();
extern void _ZN9S249C6_nt3v38Ev();
extern void _ZN9S249C6_nt3v39Ev();
extern void _ZN9S249C6_nt3v40Ev();
extern void _ZN9S249C6_nt3v41Ev();
extern void _ZN9S249C6_nt3v42Ev();
extern void _ZN9S249C6_nt3v43Ev();
extern void _ZN9S249C6_nt3v44Ev();
extern void _ZN9S249C6_nt3v45Ev();
extern void _ZN9S249C6_nt3v46Ev();
extern void _ZN9S249C6_nt3v47Ev();
extern void _ZN9S249C6_nt3v48Ev();
extern void _ZN9S249C6_nt3v49Ev();
extern void _ZN9S249C6_nt3v50Ev();
extern void _ZN9S249C6_nt3v51Ev();
extern void _ZN9S249C6_nt3v52Ev();
extern void _ZN9S249C6_nt3v53Ev();
extern void _ZN9S249C6_nt3v54Ev();
extern void _ZN9S249C6_nt3v55Ev();
extern void _ZN9S249C6_nt3v56Ev();
extern void _ZN9S249C6_nt3v57Ev();
extern void _ZN9S249C6_nt3v58Ev();
extern void _ZN9S249C6_nt3v59Ev();
extern void _ZN9S249C6_nt3v60Ev();
extern void _ZN9S249C6_nt3v61Ev();
extern void _ZN9S249C6_nt3v62Ev();
extern void _ZN9S249C6_nt3v63Ev();
extern void _ZN9S249C6_nt3v64Ev();
extern void _ZN9S249C6_nt3v65Ev();
extern void _ZN9S249C6_nt3v66Ev();
extern void _ZN9S249C6_nt3v67Ev();
extern void _ZN9S249C6_nt3v68Ev();
extern void _ZN9S249C5_nt3v69Ev();
extern void _ZN9S249C5_nt3v70Ev();
static  VTBL_ENTRY vtc_S249C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S249C5_nt[0]),
  (VTBL_ENTRY)&_ZN9S249C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S249C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S249C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S249C5_nt3v70Ev,
};
extern VTBL_ENTRY _ZTI9S249C5_nt[];
VTBL_ENTRY *P__ZTI9S249C5_nt = _ZTI9S249C5_nt; 
extern  VTBL_ENTRY _ZTV9S249C5_nt[];
Class_Descriptor cd_S249C5_nt = {  "S249C5_nt", // class name
  bases_S249C5_nt, 1,
  &(vtc_S249C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI9S249C5_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S249C5_nt),70, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C8_nt  {
  int s249c8f0[4];
  char s249c8f1[9];
  void  mf249c8(); // _ZN9S249C8_nt7mf249c8Ev
};
//SIG(-1 S249C8_nt) C1{ m Fi[4] Fc[9]}


void  S249C8_nt ::mf249c8(){}

//skip512 S249C8_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C11_nt  {
  void *s249c11f0;
  int s249c11f1[2];
  void  mf249c11(); // _ZN10S249C11_nt8mf249c11Ev
};
//SIG(-1 S249C11_nt) C1{ m Fp Fi[2]}


void  S249C11_nt ::mf249c11(){}

//skip512 S249C11_nt

#else // __cplusplus

Class_Descriptor cd_S249C11_nt = {  "S249C11_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C10_nt  : S249C11_nt {
};
//SIG(-1 S249C10_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S249C10_nt

#else // __cplusplus

extern Class_Descriptor cd_S249C11_nt;
static Base_Class bases_S249C10_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S249C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S249C10_nt = {  "S249C10_nt", // class name
  bases_S249C10_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C9_nt  : S249C10_nt {
};
//SIG(-1 S249C9_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S249C9_nt

#else // __cplusplus

extern Class_Descriptor cd_S249C11_nt;
extern Class_Descriptor cd_S249C10_nt;
static Base_Class bases_S249C9_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S249C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S249C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C15  : S249C11_nt {
};
//SIG(-1 S249C15) C1{ BC2{ m Fp Fi[2]}}



static void Test_S249C15()
{
  extern Class_Descriptor cd_S249C15;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S249C15, buf);
    S249C15 &lv = *(new (buf) S249C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S249C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S249C15)");
    check_base_class_offset(lv, (S249C11_nt*), 0, "S249C15");
    test_class_info(&lv, &cd_S249C15);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS249C15(Test_S249C15, "S249C15", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S249C11_nt;
static Base_Class bases_S249C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S249C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S249C15 = {  "S249C15", // class name
  bases_S249C15, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C14  : S249C15 {
};
//SIG(-1 S249C14) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S249C14()
{
  extern Class_Descriptor cd_S249C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S249C14, buf);
    S249C14 &lv = *(new (buf) S249C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S249C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S249C14)");
    check_base_class_offset(lv, (S249C11_nt*)(S249C15*), 0, "S249C14");
    check_base_class_offset(lv, (S249C15*), 0, "S249C14");
    test_class_info(&lv, &cd_S249C14);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS249C14(Test_S249C14, "S249C14", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S249C11_nt;
extern Class_Descriptor cd_S249C15;
static Base_Class bases_S249C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S249C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S249C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S249C14 = {  "S249C14", // class name
  bases_S249C14, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C19  : S249C11_nt {
};
//SIG(-1 S249C19) C1{ BC2{ m Fp Fi[2]}}



static void Test_S249C19()
{
  extern Class_Descriptor cd_S249C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S249C19, buf);
    S249C19 &lv = *(new (buf) S249C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S249C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S249C19)");
    check_base_class_offset(lv, (S249C11_nt*), 0, "S249C19");
    test_class_info(&lv, &cd_S249C19);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS249C19(Test_S249C19, "S249C19", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S249C11_nt;
static Base_Class bases_S249C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S249C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S249C19 = {  "S249C19", // class name
  bases_S249C19, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C18  : S249C19 {
};
//SIG(-1 S249C18) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S249C18()
{
  extern Class_Descriptor cd_S249C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S249C18, buf);
    S249C18 &lv = *(new (buf) S249C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S249C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S249C18)");
    check_base_class_offset(lv, (S249C11_nt*)(S249C19*), 0, "S249C18");
    check_base_class_offset(lv, (S249C19*), 0, "S249C18");
    test_class_info(&lv, &cd_S249C18);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS249C18(Test_S249C18, "S249C18", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S249C11_nt;
extern Class_Descriptor cd_S249C19;
static Base_Class bases_S249C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S249C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S249C19,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S249C18 = {  "S249C18", // class name
  bases_S249C18, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C20_nt  {
  void *s249c20f0;
  ::S249C7_nt s249c20f1;
  void  mf249c20(); // _ZN10S249C20_nt8mf249c20Ev
};
//SIG(-1 S249C20_nt) C1{ m Fp FC2{ m Fi[2]}}


void  S249C20_nt ::mf249c20(){}

//skip512 S249C20_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C4_nt  : S249C5_nt {
  ::S249C8_nt s249c4f0;
  int s249c4f1;
  unsigned int s249c4f2:1;
  unsigned int s249c4f3:1;
  unsigned int s249c4f4:1;
  unsigned int s249c4f5:1;
  ::S249C9_nt s249c4f6;
  ::S249C9_nt s249c4f7;
  void *s249c4f8;
  ::S249C14 s249c4f9;
  ::S249C14 s249c4f10;
  ::S249C14 s249c4f11;
  ::S249C18 s249c4f12;
  char s249c4f13;
  int s249c4f14;
  void *s249c4f15;
  ::S249C7_nt s249c4f16;
  ::S249C7_nt s249c4f17;
  ::S249C7_nt s249c4f18;
  ::S249C7_nt s249c4f19;
  ::S249C7_nt s249c4f20;
  ::S249C7_nt s249c4f21;
  ::S249C20_nt s249c4f22;
  ::S249C20_nt s249c4f23;
  ::S249C20_nt s249c4f24;
  ::S249C20_nt s249c4f25;
  ::S249C20_nt s249c4f26;
  ::S249C20_nt s249c4f27;
  ::S249C20_nt s249c4f28;
  ::S249C20_nt s249c4f29;
  ::S249C20_nt s249c4f30;
  ::S249C20_nt s249c4f31;
  virtual  ~S249C4_nt(); // _ZN9S249C4_ntD1Ev
  virtual void  v71(); // _ZN9S249C4_nt3v71Ev
  virtual void  v72(); // _ZN9S249C4_nt3v72Ev
  virtual void  v73(); // _ZN9S249C4_nt3v73Ev
  virtual void  v74(); // _ZN9S249C4_nt3v74Ev
  virtual void  v75(); // _ZN9S249C4_nt3v75Ev
  virtual void  v76(); // _ZN9S249C4_nt3v76Ev
  virtual void  v77(); // _ZN9S249C4_nt3v77Ev
  virtual void  v78(); // _ZN9S249C4_nt3v78Ev
  virtual void  v79(); // _ZN9S249C4_nt3v79Ev
  virtual void  v80(); // _ZN9S249C4_nt3v80Ev
  virtual void  v81(); // _ZN9S249C4_nt3v81Ev
  virtual void  v82(); // _ZN9S249C4_nt3v82Ev
  virtual void  v83(); // _ZN9S249C4_nt3v83Ev
  virtual void  v84(); // _ZN9S249C4_nt3v84Ev
  virtual void  v85(); // _ZN9S249C4_nt3v85Ev
  virtual void  v86(); // _ZN9S249C4_nt3v86Ev
  virtual void  v87(); // _ZN9S249C4_nt3v87Ev
  virtual void  v88(); // _ZN9S249C4_nt3v88Ev
  virtual void  v89(); // _ZN9S249C4_nt3v89Ev
  virtual void  v90(); // _ZN9S249C4_nt3v90Ev
  virtual void  v91(); // _ZN9S249C4_nt3v91Ev
  virtual void  v92(); // _ZN9S249C4_nt3v92Ev
  virtual void  v93(); // _ZN9S249C4_nt3v93Ev
  virtual void  v94(); // _ZN9S249C4_nt3v94Ev
  virtual void  v95(); // _ZN9S249C4_nt3v95Ev
  virtual void  v96(); // _ZN9S249C4_nt3v96Ev
  virtual void  v97(); // _ZN9S249C4_nt3v97Ev
  virtual void  v98(); // _ZN9S249C4_nt3v98Ev
  virtual void  v99(); // _ZN9S249C4_nt3v99Ev
  virtual void  v100(); // _ZN9S249C4_nt4v100Ev
  virtual void  v101(); // _ZN9S249C4_nt4v101Ev
  virtual void  v102(); // _ZN9S249C4_nt4v102Ev
  virtual void  v103(); // _ZN9S249C4_nt4v103Ev
  virtual void  v104(); // _ZN9S249C4_nt4v104Ev
  virtual void  v105(); // _ZN9S249C4_nt4v105Ev
  virtual void  v106(); // _ZN9S249C4_nt4v106Ev
  virtual void  v107(); // _ZN9S249C4_nt4v107Ev
  virtual void  v108(); // _ZN9S249C4_nt4v108Ev
  virtual void  v109(); // _ZN9S249C4_nt4v109Ev
  virtual void  v110(); // _ZN9S249C4_nt4v110Ev
  virtual void  v111(); // _ZN9S249C4_nt4v111Ev
  virtual void  v112(); // _ZN9S249C4_nt4v112Ev
  virtual void  v113(); // _ZN9S249C4_nt4v113Ev
  virtual void  v114(); // _ZN9S249C4_nt4v114Ev
  virtual void  v115(); // _ZN9S249C4_nt4v115Ev
  virtual void  v116(); // _ZN9S249C4_nt4v116Ev
  virtual void  v117(); // _ZN9S249C4_nt4v117Ev
  virtual void  v118(); // _ZN9S249C4_nt4v118Ev
  virtual void  v119(); // _ZN9S249C4_nt4v119Ev
  virtual void  v120(); // _ZN9S249C4_nt4v120Ev
  virtual void  v121(); // _ZN9S249C4_nt4v121Ev
  virtual void  v122(); // _ZN9S249C4_nt4v122Ev
  virtual void  v123(); // _ZN9S249C4_nt4v123Ev
  virtual void  v124(); // _ZN9S249C4_nt4v124Ev
  virtual void  v125(); // _ZN9S249C4_nt4v125Ev
  virtual void  v126(); // _ZN9S249C4_nt4v126Ev
  virtual void  v127(); // _ZN9S249C4_nt4v127Ev
  virtual void  v128(); // _ZN9S249C4_nt4v128Ev
  virtual void  v129(); // _ZN9S249C4_nt4v129Ev
  virtual void  v130(); // _ZN9S249C4_nt4v130Ev
  virtual void  v131(); // _ZN9S249C4_nt4v131Ev
  virtual void  v132(); // _ZN9S249C4_nt4v132Ev
  virtual void  v133(); // _ZN9S249C4_nt4v133Ev
  virtual void  v134(); // _ZN9S249C4_nt4v134Ev
  virtual void  v135(); // _ZN9S249C4_nt4v135Ev
  virtual void  v136(); // _ZN9S249C4_nt4v136Ev
  virtual void  v137(); // _ZN9S249C4_nt4v137Ev
  virtual void  v138(); // _ZN9S249C4_nt4v138Ev
  virtual void  v139(); // _ZN9S249C4_nt4v139Ev
  virtual void  v140(); // _ZN9S249C4_nt4v140Ev
  virtual void  v141(); // _ZN9S249C4_nt4v141Ev
  virtual void  v142(); // _ZN9S249C4_nt4v142Ev
  virtual void  v143(); // _ZN9S249C4_nt4v143Ev
  virtual void  v144(); // _ZN9S249C4_nt4v144Ev
  virtual void  v145(); // _ZN9S249C4_nt4v145Ev
  virtual void  v146(); // _ZN9S249C4_nt4v146Ev
  S249C4_nt(); // tgen
};
//SIG(-1 S249C4_nt) C1{ BC2{ BC3{ vd v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v141 v142} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 FC5{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC6 Fp FC9{ BC10{ BC8}} FC9 FC9 FC11{ BC12{ BC8}} Fc Fi Fp FC4 FC4 FC4 FC4 FC4 FC4 FC13{ m Fp FC4} FC13 FC13 FC13 FC13 FC13 FC13 FC13 FC13 FC13}


 S249C4_nt ::~S249C4_nt(){ note_dtor("S249C4_nt", this);}
void  S249C4_nt ::v71(){vfunc_called(this, "_ZN9S249C4_nt3v71Ev");}
void  S249C4_nt ::v72(){vfunc_called(this, "_ZN9S249C4_nt3v72Ev");}
void  S249C4_nt ::v73(){vfunc_called(this, "_ZN9S249C4_nt3v73Ev");}
void  S249C4_nt ::v74(){vfunc_called(this, "_ZN9S249C4_nt3v74Ev");}
void  S249C4_nt ::v75(){vfunc_called(this, "_ZN9S249C4_nt3v75Ev");}
void  S249C4_nt ::v76(){vfunc_called(this, "_ZN9S249C4_nt3v76Ev");}
void  S249C4_nt ::v77(){vfunc_called(this, "_ZN9S249C4_nt3v77Ev");}
void  S249C4_nt ::v78(){vfunc_called(this, "_ZN9S249C4_nt3v78Ev");}
void  S249C4_nt ::v79(){vfunc_called(this, "_ZN9S249C4_nt3v79Ev");}
void  S249C4_nt ::v80(){vfunc_called(this, "_ZN9S249C4_nt3v80Ev");}
void  S249C4_nt ::v81(){vfunc_called(this, "_ZN9S249C4_nt3v81Ev");}
void  S249C4_nt ::v82(){vfunc_called(this, "_ZN9S249C4_nt3v82Ev");}
void  S249C4_nt ::v83(){vfunc_called(this, "_ZN9S249C4_nt3v83Ev");}
void  S249C4_nt ::v84(){vfunc_called(this, "_ZN9S249C4_nt3v84Ev");}
void  S249C4_nt ::v85(){vfunc_called(this, "_ZN9S249C4_nt3v85Ev");}
void  S249C4_nt ::v86(){vfunc_called(this, "_ZN9S249C4_nt3v86Ev");}
void  S249C4_nt ::v87(){vfunc_called(this, "_ZN9S249C4_nt3v87Ev");}
void  S249C4_nt ::v88(){vfunc_called(this, "_ZN9S249C4_nt3v88Ev");}
void  S249C4_nt ::v89(){vfunc_called(this, "_ZN9S249C4_nt3v89Ev");}
void  S249C4_nt ::v90(){vfunc_called(this, "_ZN9S249C4_nt3v90Ev");}
void  S249C4_nt ::v91(){vfunc_called(this, "_ZN9S249C4_nt3v91Ev");}
void  S249C4_nt ::v92(){vfunc_called(this, "_ZN9S249C4_nt3v92Ev");}
void  S249C4_nt ::v93(){vfunc_called(this, "_ZN9S249C4_nt3v93Ev");}
void  S249C4_nt ::v94(){vfunc_called(this, "_ZN9S249C4_nt3v94Ev");}
void  S249C4_nt ::v95(){vfunc_called(this, "_ZN9S249C4_nt3v95Ev");}
void  S249C4_nt ::v96(){vfunc_called(this, "_ZN9S249C4_nt3v96Ev");}
void  S249C4_nt ::v97(){vfunc_called(this, "_ZN9S249C4_nt3v97Ev");}
void  S249C4_nt ::v98(){vfunc_called(this, "_ZN9S249C4_nt3v98Ev");}
void  S249C4_nt ::v99(){vfunc_called(this, "_ZN9S249C4_nt3v99Ev");}
void  S249C4_nt ::v100(){vfunc_called(this, "_ZN9S249C4_nt4v100Ev");}
void  S249C4_nt ::v101(){vfunc_called(this, "_ZN9S249C4_nt4v101Ev");}
void  S249C4_nt ::v102(){vfunc_called(this, "_ZN9S249C4_nt4v102Ev");}
void  S249C4_nt ::v103(){vfunc_called(this, "_ZN9S249C4_nt4v103Ev");}
void  S249C4_nt ::v104(){vfunc_called(this, "_ZN9S249C4_nt4v104Ev");}
void  S249C4_nt ::v105(){vfunc_called(this, "_ZN9S249C4_nt4v105Ev");}
void  S249C4_nt ::v106(){vfunc_called(this, "_ZN9S249C4_nt4v106Ev");}
void  S249C4_nt ::v107(){vfunc_called(this, "_ZN9S249C4_nt4v107Ev");}
void  S249C4_nt ::v108(){vfunc_called(this, "_ZN9S249C4_nt4v108Ev");}
void  S249C4_nt ::v109(){vfunc_called(this, "_ZN9S249C4_nt4v109Ev");}
void  S249C4_nt ::v110(){vfunc_called(this, "_ZN9S249C4_nt4v110Ev");}
void  S249C4_nt ::v111(){vfunc_called(this, "_ZN9S249C4_nt4v111Ev");}
void  S249C4_nt ::v112(){vfunc_called(this, "_ZN9S249C4_nt4v112Ev");}
void  S249C4_nt ::v113(){vfunc_called(this, "_ZN9S249C4_nt4v113Ev");}
void  S249C4_nt ::v114(){vfunc_called(this, "_ZN9S249C4_nt4v114Ev");}
void  S249C4_nt ::v115(){vfunc_called(this, "_ZN9S249C4_nt4v115Ev");}
void  S249C4_nt ::v116(){vfunc_called(this, "_ZN9S249C4_nt4v116Ev");}
void  S249C4_nt ::v117(){vfunc_called(this, "_ZN9S249C4_nt4v117Ev");}
void  S249C4_nt ::v118(){vfunc_called(this, "_ZN9S249C4_nt4v118Ev");}
void  S249C4_nt ::v119(){vfunc_called(this, "_ZN9S249C4_nt4v119Ev");}
void  S249C4_nt ::v120(){vfunc_called(this, "_ZN9S249C4_nt4v120Ev");}
void  S249C4_nt ::v121(){vfunc_called(this, "_ZN9S249C4_nt4v121Ev");}
void  S249C4_nt ::v122(){vfunc_called(this, "_ZN9S249C4_nt4v122Ev");}
void  S249C4_nt ::v123(){vfunc_called(this, "_ZN9S249C4_nt4v123Ev");}
void  S249C4_nt ::v124(){vfunc_called(this, "_ZN9S249C4_nt4v124Ev");}
void  S249C4_nt ::v125(){vfunc_called(this, "_ZN9S249C4_nt4v125Ev");}
void  S249C4_nt ::v126(){vfunc_called(this, "_ZN9S249C4_nt4v126Ev");}
void  S249C4_nt ::v127(){vfunc_called(this, "_ZN9S249C4_nt4v127Ev");}
void  S249C4_nt ::v128(){vfunc_called(this, "_ZN9S249C4_nt4v128Ev");}
void  S249C4_nt ::v129(){vfunc_called(this, "_ZN9S249C4_nt4v129Ev");}
void  S249C4_nt ::v130(){vfunc_called(this, "_ZN9S249C4_nt4v130Ev");}
void  S249C4_nt ::v131(){vfunc_called(this, "_ZN9S249C4_nt4v131Ev");}
void  S249C4_nt ::v132(){vfunc_called(this, "_ZN9S249C4_nt4v132Ev");}
void  S249C4_nt ::v133(){vfunc_called(this, "_ZN9S249C4_nt4v133Ev");}
void  S249C4_nt ::v134(){vfunc_called(this, "_ZN9S249C4_nt4v134Ev");}
void  S249C4_nt ::v135(){vfunc_called(this, "_ZN9S249C4_nt4v135Ev");}
void  S249C4_nt ::v136(){vfunc_called(this, "_ZN9S249C4_nt4v136Ev");}
void  S249C4_nt ::v137(){vfunc_called(this, "_ZN9S249C4_nt4v137Ev");}
void  S249C4_nt ::v138(){vfunc_called(this, "_ZN9S249C4_nt4v138Ev");}
void  S249C4_nt ::v139(){vfunc_called(this, "_ZN9S249C4_nt4v139Ev");}
void  S249C4_nt ::v140(){vfunc_called(this, "_ZN9S249C4_nt4v140Ev");}
void  S249C4_nt ::v141(){vfunc_called(this, "_ZN9S249C4_nt4v141Ev");}
void  S249C4_nt ::v142(){vfunc_called(this, "_ZN9S249C4_nt4v142Ev");}
void  S249C4_nt ::v143(){vfunc_called(this, "_ZN9S249C4_nt4v143Ev");}
void  S249C4_nt ::v144(){vfunc_called(this, "_ZN9S249C4_nt4v144Ev");}
void  S249C4_nt ::v145(){vfunc_called(this, "_ZN9S249C4_nt4v145Ev");}
void  S249C4_nt ::v146(){vfunc_called(this, "_ZN9S249C4_nt4v146Ev");}
S249C4_nt ::S249C4_nt(){ note_ctor("S249C4_nt", this);} // tgen

//skip512 S249C4_nt

#else // __cplusplus

extern void _ZN9S249C4_ntC1Ev();
extern void _ZN9S249C4_ntD1Ev();
Name_Map name_map_S249C4_nt[] = {
  NSPAIR(_ZN9S249C4_ntC1Ev),
  NSPAIR(_ZN9S249C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S249C6_nt;
extern VTBL_ENTRY _ZTI9S249C6_nt[];
extern  VTBL_ENTRY _ZTV9S249C6_nt[];
extern Class_Descriptor cd_S249C5_nt;
extern VTBL_ENTRY _ZTI9S249C5_nt[];
extern  VTBL_ENTRY _ZTV9S249C5_nt[];
static Base_Class bases_S249C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S249C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S249C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S249C4_nt[];
extern void _ZN9S249C4_ntD1Ev();
extern void _ZN9S249C4_ntD0Ev();
extern void _ZN9S249C6_nt2v5Ev();
extern void _ZN9S249C6_nt2v6Ev();
extern void _ZN9S249C6_nt2v7Ev();
extern void _ZN9S249C6_nt2v8Ev();
extern void _ZN9S249C6_nt2v9Ev();
extern void _ZN9S249C6_nt3v10Ev();
extern void _ZN9S249C6_nt3v11Ev();
extern void _ZN9S249C6_nt3v12Ev();
extern void _ZN9S249C6_nt3v13Ev();
extern void _ZN9S249C6_nt3v14Ev();
extern void _ZN9S249C6_nt3v15Ev();
extern void _ZN9S249C6_nt3v16Ev();
extern void _ZN9S249C6_nt3v17Ev();
extern void _ZN9S249C6_nt3v18Ev();
extern void _ZN9S249C6_nt3v19Ev();
extern void _ZN9S249C6_nt3v20Ev();
extern void _ZN9S249C6_nt3v21Ev();
extern void _ZN9S249C6_nt3v22Ev();
extern void _ZN9S249C6_nt3v23Ev();
extern void _ZN9S249C6_nt3v24Ev();
extern void _ZN9S249C6_nt3v25Ev();
extern void _ZN9S249C6_nt3v26Ev();
extern void _ZN9S249C6_nt3v27Ev();
extern void _ZN9S249C6_nt3v28Ev();
extern void _ZN9S249C6_nt3v29Ev();
extern void _ZN9S249C6_nt3v30Ev();
extern void _ZN9S249C6_nt3v31Ev();
extern void _ZN9S249C6_nt3v32Ev();
extern void _ZN9S249C6_nt3v33Ev();
extern void _ZN9S249C6_nt3v34Ev();
extern void _ZN9S249C6_nt3v35Ev();
extern void _ZN9S249C6_nt3v36Ev();
extern void _ZN9S249C6_nt3v37Ev();
extern void _ZN9S249C6_nt3v38Ev();
extern void _ZN9S249C6_nt3v39Ev();
extern void _ZN9S249C6_nt3v40Ev();
extern void _ZN9S249C6_nt3v41Ev();
extern void _ZN9S249C6_nt3v42Ev();
extern void _ZN9S249C6_nt3v43Ev();
extern void _ZN9S249C6_nt3v44Ev();
extern void _ZN9S249C6_nt3v45Ev();
extern void _ZN9S249C6_nt3v46Ev();
extern void _ZN9S249C6_nt3v47Ev();
extern void _ZN9S249C6_nt3v48Ev();
extern void _ZN9S249C6_nt3v49Ev();
extern void _ZN9S249C6_nt3v50Ev();
extern void _ZN9S249C6_nt3v51Ev();
extern void _ZN9S249C6_nt3v52Ev();
extern void _ZN9S249C6_nt3v53Ev();
extern void _ZN9S249C6_nt3v54Ev();
extern void _ZN9S249C6_nt3v55Ev();
extern void _ZN9S249C6_nt3v56Ev();
extern void _ZN9S249C6_nt3v57Ev();
extern void _ZN9S249C6_nt3v58Ev();
extern void _ZN9S249C6_nt3v59Ev();
extern void _ZN9S249C6_nt3v60Ev();
extern void _ZN9S249C6_nt3v61Ev();
extern void _ZN9S249C6_nt3v62Ev();
extern void _ZN9S249C6_nt3v63Ev();
extern void _ZN9S249C6_nt3v64Ev();
extern void _ZN9S249C6_nt3v65Ev();
extern void _ZN9S249C6_nt3v66Ev();
extern void _ZN9S249C6_nt3v67Ev();
extern void _ZN9S249C6_nt3v68Ev();
extern void _ZN9S249C5_nt3v69Ev();
extern void _ZN9S249C5_nt3v70Ev();
extern void _ZN9S249C4_nt3v71Ev();
extern void _ZN9S249C4_nt3v72Ev();
extern void _ZN9S249C4_nt3v73Ev();
extern void _ZN9S249C4_nt3v74Ev();
extern void _ZN9S249C4_nt3v75Ev();
extern void _ZN9S249C4_nt3v76Ev();
extern void _ZN9S249C4_nt3v77Ev();
extern void _ZN9S249C4_nt3v78Ev();
extern void _ZN9S249C4_nt3v79Ev();
extern void _ZN9S249C4_nt3v80Ev();
extern void _ZN9S249C4_nt3v81Ev();
extern void _ZN9S249C4_nt3v82Ev();
extern void _ZN9S249C4_nt3v83Ev();
extern void _ZN9S249C4_nt3v84Ev();
extern void _ZN9S249C4_nt3v85Ev();
extern void _ZN9S249C4_nt3v86Ev();
extern void _ZN9S249C4_nt3v87Ev();
extern void _ZN9S249C4_nt3v88Ev();
extern void _ZN9S249C4_nt3v89Ev();
extern void _ZN9S249C4_nt3v90Ev();
extern void _ZN9S249C4_nt3v91Ev();
extern void _ZN9S249C4_nt3v92Ev();
extern void _ZN9S249C4_nt3v93Ev();
extern void _ZN9S249C4_nt3v94Ev();
extern void _ZN9S249C4_nt3v95Ev();
extern void _ZN9S249C4_nt3v96Ev();
extern void _ZN9S249C4_nt3v97Ev();
extern void _ZN9S249C4_nt3v98Ev();
extern void _ZN9S249C4_nt3v99Ev();
extern void _ZN9S249C4_nt4v100Ev();
extern void _ZN9S249C4_nt4v101Ev();
extern void _ZN9S249C4_nt4v102Ev();
extern void _ZN9S249C4_nt4v103Ev();
extern void _ZN9S249C4_nt4v104Ev();
extern void _ZN9S249C4_nt4v105Ev();
extern void _ZN9S249C4_nt4v106Ev();
extern void _ZN9S249C4_nt4v107Ev();
extern void _ZN9S249C4_nt4v108Ev();
extern void _ZN9S249C4_nt4v109Ev();
extern void _ZN9S249C4_nt4v110Ev();
extern void _ZN9S249C4_nt4v111Ev();
extern void _ZN9S249C4_nt4v112Ev();
extern void _ZN9S249C4_nt4v113Ev();
extern void _ZN9S249C4_nt4v114Ev();
extern void _ZN9S249C4_nt4v115Ev();
extern void _ZN9S249C4_nt4v116Ev();
extern void _ZN9S249C4_nt4v117Ev();
extern void _ZN9S249C4_nt4v118Ev();
extern void _ZN9S249C4_nt4v119Ev();
extern void _ZN9S249C4_nt4v120Ev();
extern void _ZN9S249C4_nt4v121Ev();
extern void _ZN9S249C4_nt4v122Ev();
extern void _ZN9S249C4_nt4v123Ev();
extern void _ZN9S249C4_nt4v124Ev();
extern void _ZN9S249C4_nt4v125Ev();
extern void _ZN9S249C4_nt4v126Ev();
extern void _ZN9S249C4_nt4v127Ev();
extern void _ZN9S249C4_nt4v128Ev();
extern void _ZN9S249C4_nt4v129Ev();
extern void _ZN9S249C4_nt4v130Ev();
extern void _ZN9S249C4_nt4v131Ev();
extern void _ZN9S249C4_nt4v132Ev();
extern void _ZN9S249C4_nt4v133Ev();
extern void _ZN9S249C4_nt4v134Ev();
extern void _ZN9S249C4_nt4v135Ev();
extern void _ZN9S249C4_nt4v136Ev();
extern void _ZN9S249C4_nt4v137Ev();
extern void _ZN9S249C4_nt4v138Ev();
extern void _ZN9S249C4_nt4v139Ev();
extern void _ZN9S249C4_nt4v140Ev();
extern void _ZN9S249C4_nt4v141Ev();
extern void _ZN9S249C4_nt4v142Ev();
extern void _ZN9S249C4_nt4v143Ev();
extern void _ZN9S249C4_nt4v144Ev();
extern void _ZN9S249C4_nt4v145Ev();
extern void _ZN9S249C4_nt4v146Ev();
static  VTBL_ENTRY vtc_S249C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S249C4_nt[0]),
  (VTBL_ENTRY)&_ZN9S249C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S249C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S249C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S249C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v146Ev,
};
extern VTBL_ENTRY _ZTI9S249C4_nt[];
VTBL_ENTRY *P__ZTI9S249C4_nt = _ZTI9S249C4_nt; 
extern  VTBL_ENTRY _ZTV9S249C4_nt[];
Class_Descriptor cd_S249C4_nt = {  "S249C4_nt", // class name
  bases_S249C4_nt, 2,
  &(vtc_S249C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(464,352), // object size
  NSPAIRA(_ZTI9S249C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S249C4_nt),146, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C22_nt  {
  int s249c22f0[4];
  void  mf249c22(); // _ZN10S249C22_nt8mf249c22Ev
};
//SIG(-1 S249C22_nt) C1{ m Fi[4]}


void  S249C22_nt ::mf249c22(){}

//skip512 S249C22_nt

#else // __cplusplus

Class_Descriptor cd_S249C22_nt = {  "S249C22_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C21_nt  : S249C22_nt {
};
//SIG(-1 S249C21_nt) C1{ BC2{ m Fi[4]}}



//skip512 S249C21_nt

#else // __cplusplus

extern Class_Descriptor cd_S249C22_nt;
static Base_Class bases_S249C21_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S249C22_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C23_nt  {
  ::S249C7_nt s249c23f0;
  void *s249c23f1;
  ::S249C21_nt s249c23f2;
  void *s249c23f3;
  void  mf249c23(); // _ZN10S249C23_nt8mf249c23Ev
};
//SIG(-1 S249C23_nt) C1{ m FC2{ m Fi[2]} Fp FC3{ BC4{ m Fi[4]}} Fp}


void  S249C23_nt ::mf249c23(){}

//skip512 S249C23_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C25_nt  {
  void *s249c25f0[8];
  char s249c25f1[4];
  void  mf249c25(); // _ZN10S249C25_nt8mf249c25Ev
};
//SIG(-1 S249C25_nt) C1{ m Fp[8] Fc[4]}


void  S249C25_nt ::mf249c25(){}

//skip512 S249C25_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C27_nt  {
  int s249c27f0[4];
  char s249c27f1[4];
  void  mf249c27(); // _ZN10S249C27_nt8mf249c27Ev
};
//SIG(-1 S249C27_nt) C1{ m Fi[4] Fc[4]}


void  S249C27_nt ::mf249c27(){}

//skip512 S249C27_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C26_nt  {
  void *s249c26f0[5];
  ::S249C27_nt s249c26f1;
  unsigned int s249c26f2:1;
  unsigned int s249c26f3:1;
  int s249c26f4;
  char s249c26f5[8];
  void  mf249c26(); // _ZN10S249C26_nt8mf249c26Ev
};
//SIG(-1 S249C26_nt) C1{ m Fp[5] FC2{ m Fi[4] Fc[4]} Fi:1 Fi:1 Fi Fc[8]}


void  S249C26_nt ::mf249c26(){}

//skip512 S249C26_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C30_nt  {
  int s249c30f0[3];
  void  mf249c30(); // _ZN10S249C30_nt8mf249c30Ev
};
//SIG(-1 S249C30_nt) C1{ m Fi[3]}


void  S249C30_nt ::mf249c30(){}

//skip512 S249C30_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C31_nt  {
  void  mf249c31(); // _ZN10S249C31_nt8mf249c31Ev
};
//SIG(-1 S249C31_nt) C1{ m}


void  S249C31_nt ::mf249c31(){}

//skip512 S249C31_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S249C31_nt[];
VTBL_ENTRY *P__ZTI10S249C31_nt = _ZTI10S249C31_nt; 
Class_Descriptor cd_S249C31_nt = {  "S249C31_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI10S249C31_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C33_nt  {
  int s249c33f0[2];
  char s249c33f1[2];
  void  mf249c33(); // _ZN10S249C33_nt8mf249c33Ev
};
//SIG(-1 S249C33_nt) C1{ m Fi[2] Fc[2]}


void  S249C33_nt ::mf249c33(){}

//skip512 S249C33_nt

#else // __cplusplus

Class_Descriptor cd_S249C33_nt = {  "S249C33_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C32_nt  : S249C33_nt {
  int s249c32f0;
};
//SIG(-1 S249C32_nt) C1{ BC2{ m Fi[2] Fc[2]} Fi}



//skip512 S249C32_nt

#else // __cplusplus

extern Class_Descriptor cd_S249C33_nt;
static Base_Class bases_S249C32_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S249C33_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C29_nt  {
  ::S249C30_nt s249c29f0;
  ::S249C31_nt s249c29f1;
  ::S249C32_nt s249c29f2;
  char s249c29f3;
  void  mf249c29(); // _ZN10S249C29_nt8mf249c29Ev
};
//SIG(-1 S249C29_nt) C1{ m FC2{ m Fi[3]} FC3{ m} FC4{ BC5{ m Fi[2] Fc[2]} Fi} Fc}


void  S249C29_nt ::mf249c29(){}

//skip512 S249C29_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C37_nt  {
  void *s249c37f0[2];
  void  mf249c37(); // _ZN10S249C37_nt8mf249c37Ev
};
//SIG(-1 S249C37_nt) C1{ m Fp[2]}


void  S249C37_nt ::mf249c37(){}

//skip512 S249C37_nt

#else // __cplusplus

Class_Descriptor cd_S249C37_nt = {  "S249C37_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,8), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C36_nt  : S249C37_nt {
};
//SIG(-1 S249C36_nt) C1{ BC2{ m Fp[2]}}



//skip512 S249C36_nt

#else // __cplusplus

extern Class_Descriptor cd_S249C37_nt;
static Base_Class bases_S249C36_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S249C37_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C40  : S249C11_nt {
};
//SIG(-1 S249C40) C1{ BC2{ m Fp Fi[2]}}



static void Test_S249C40()
{
  extern Class_Descriptor cd_S249C40;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S249C40, buf);
    S249C40 &lv = *(new (buf) S249C40());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S249C40)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S249C40)");
    check_base_class_offset(lv, (S249C11_nt*), 0, "S249C40");
    test_class_info(&lv, &cd_S249C40);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS249C40(Test_S249C40, "S249C40", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S249C11_nt;
static Base_Class bases_S249C40[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S249C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S249C40 = {  "S249C40", // class name
  bases_S249C40, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C39  : S249C40 {
};
//SIG(-1 S249C39) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S249C39()
{
  extern Class_Descriptor cd_S249C39;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S249C39, buf);
    S249C39 &lv = *(new (buf) S249C39());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S249C39)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S249C39)");
    check_base_class_offset(lv, (S249C11_nt*)(S249C40*), 0, "S249C39");
    check_base_class_offset(lv, (S249C40*), 0, "S249C39");
    test_class_info(&lv, &cd_S249C39);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS249C39(Test_S249C39, "S249C39", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S249C11_nt;
extern Class_Descriptor cd_S249C40;
static Base_Class bases_S249C39[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S249C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S249C40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S249C39 = {  "S249C39", // class name
  bases_S249C39, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C38_nt  : S249C39 {
};
//SIG(-1 S249C38_nt) C1{ BC2{ BC3{ BC4{ m Fp Fi[2]}}}}



//skip512 S249C38_nt

#else // __cplusplus

extern Class_Descriptor cd_S249C11_nt;
extern Class_Descriptor cd_S249C40;
extern Class_Descriptor cd_S249C39;
static Base_Class bases_S249C38_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S249C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S249C40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S249C39,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C35_nt  {
  ::S249C36_nt s249c35f0;
  char s249c35f1;
  ::S249C38_nt s249c35f2;
  int s249c35f3;
  ::S249C7_nt s249c35f4;
  ::S249C7_nt s249c35f5;
  void *s249c35f6;
  void  mf249c35(); // _ZN10S249C35_nt8mf249c35Ev
};
//SIG(-1 S249C35_nt) C1{ m FC2{ BC3{ m Fp[2]}} Fc FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} Fi FC8{ m Fi[2]} FC8 Fp}


void  S249C35_nt ::mf249c35(){}

//skip512 S249C35_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C44  : S249C11_nt {
};
//SIG(-1 S249C44) C1{ BC2{ m Fp Fi[2]}}



static void Test_S249C44()
{
  extern Class_Descriptor cd_S249C44;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S249C44, buf);
    S249C44 &lv = *(new (buf) S249C44());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S249C44)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S249C44)");
    check_base_class_offset(lv, (S249C11_nt*), 0, "S249C44");
    test_class_info(&lv, &cd_S249C44);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS249C44(Test_S249C44, "S249C44", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S249C11_nt;
static Base_Class bases_S249C44[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S249C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S249C44 = {  "S249C44", // class name
  bases_S249C44, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C43  : S249C44 {
};
//SIG(-1 S249C43) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S249C43()
{
  extern Class_Descriptor cd_S249C43;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S249C43, buf);
    S249C43 &lv = *(new (buf) S249C43());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S249C43)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S249C43)");
    check_base_class_offset(lv, (S249C11_nt*)(S249C44*), 0, "S249C43");
    check_base_class_offset(lv, (S249C44*), 0, "S249C43");
    test_class_info(&lv, &cd_S249C43);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS249C43(Test_S249C43, "S249C43", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S249C11_nt;
extern Class_Descriptor cd_S249C44;
static Base_Class bases_S249C43[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S249C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S249C44,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S249C43 = {  "S249C43", // class name
  bases_S249C43, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C3_nt  : S249C4_nt {
  ::S249C21_nt s249c3f0;
  ::S249C7_nt s249c3f1;
  void *s249c3f2[2];
  ::S249C23_nt s249c3f3;
  ::S249C25_nt s249c3f4;
  int s249c3f5;
  ::S249C26_nt s249c3f6;
  int s249c3f7[4];
  ::S249C7_nt s249c3f8[4];
  ::S249C29_nt s249c3f9;
  ::S249C30_nt s249c3f10;
  int s249c3f11;
  ::S249C35_nt s249c3f12;
  ::S249C35_nt s249c3f13;
  void *s249c3f14;
  ::S249C30_nt s249c3f15;
  ::S249C18 s249c3f16;
  ::S249C43 s249c3f17;
  unsigned int s249c3f18:1;
  unsigned int s249c3f19:1;
  unsigned int s249c3f20:1;
  ::S249C31_nt s249c3f21;
  ::S249C20_nt s249c3f22;
  ::S249C20_nt s249c3f23;
  ::S249C20_nt s249c3f24;
  ::S249C20_nt s249c3f25;
  ::S249C20_nt s249c3f26;
  ::S249C20_nt s249c3f27;
  ::S249C20_nt s249c3f28;
  ::S249C20_nt s249c3f29;
  ::S249C20_nt s249c3f30;
  ::S249C20_nt s249c3f31;
  ::S249C20_nt s249c3f32;
  ::S249C20_nt s249c3f33;
  ::S249C20_nt s249c3f34;
  virtual  ~S249C3_nt(); // _ZN9S249C3_ntD1Ev
  virtual void  v147(); // _ZN9S249C3_nt4v147Ev
  virtual void  v148(); // _ZN9S249C3_nt4v148Ev
  virtual void  v149(); // _ZN9S249C3_nt4v149Ev
  virtual void  v150(); // _ZN9S249C3_nt4v150Ev
  virtual void  v151(); // _ZN9S249C3_nt4v151Ev
  virtual void  v152(); // _ZN9S249C3_nt4v152Ev
  virtual void  v153(); // _ZN9S249C3_nt4v153Ev
  virtual void  v154(); // _ZN9S249C3_nt4v154Ev
  virtual void  v155(); // _ZN9S249C3_nt4v155Ev
  virtual void  v156(); // _ZN9S249C3_nt4v156Ev
  virtual void  v157(); // _ZN9S249C3_nt4v157Ev
  virtual void  v158(); // _ZN9S249C3_nt4v158Ev
  virtual void  v159(); // _ZN9S249C3_nt4v159Ev
  virtual void  v160(); // _ZN9S249C3_nt4v160Ev
  virtual void  v161(); // _ZN9S249C3_nt4v161Ev
  virtual void  v162(); // _ZN9S249C3_nt4v162Ev
  virtual void  v163(); // _ZN9S249C3_nt4v163Ev
  virtual void  v164(); // _ZN9S249C3_nt4v164Ev
  virtual void  v165(); // _ZN9S249C3_nt4v165Ev
  virtual void  v166(); // _ZN9S249C3_nt4v166Ev
  virtual void  v167(); // _ZN9S249C3_nt4v167Ev
  virtual void  v168(); // _ZN9S249C3_nt4v168Ev
  virtual void  v169(); // _ZN9S249C3_nt4v169Ev
  virtual void  v170(); // _ZN9S249C3_nt4v170Ev
  virtual void  v171(); // _ZN9S249C3_nt4v171Ev
  virtual void  v172(); // _ZN9S249C3_nt4v172Ev
  virtual void  v173(); // _ZN9S249C3_nt4v173Ev
  virtual void  v174(); // _ZN9S249C3_nt4v174Ev
  virtual void  v175(); // _ZN9S249C3_nt4v175Ev
  virtual void  v176(); // _ZN9S249C3_nt4v176Ev
  virtual void  v177(); // _ZN9S249C3_nt4v177Ev
  virtual void  v178(); // _ZN9S249C3_nt4v178Ev
  virtual void  v179(); // _ZN9S249C3_nt4v179Ev
  virtual void  v180(); // _ZN9S249C3_nt4v180Ev
  virtual void  v181(); // _ZN9S249C3_nt4v181Ev
  virtual void  v182(); // _ZN9S249C3_nt4v182Ev
  virtual void  v183(); // _ZN9S249C3_nt4v183Ev
  virtual void  v184(); // _ZN9S249C3_nt4v184Ev
  virtual void  v185(); // _ZN9S249C3_nt4v185Ev
  virtual void  v186(); // _ZN9S249C3_nt4v186Ev
  virtual void  v187(); // _ZN9S249C3_nt4v187Ev
  virtual void  v188(); // _ZN9S249C3_nt4v188Ev
  virtual void  v189(); // _ZN9S249C3_nt4v189Ev
  virtual void  v190(); // _ZN9S249C3_nt4v190Ev
  virtual void  v191(); // _ZN9S249C3_nt4v191Ev
  virtual void  v192(); // _ZN9S249C3_nt4v192Ev
  virtual void  v193(); // _ZN9S249C3_nt4v193Ev
  virtual void  v194(); // _ZN9S249C3_nt4v194Ev
  virtual void  v195(); // _ZN9S249C3_nt4v195Ev
  virtual void  v196(); // _ZN9S249C3_nt4v196Ev
  virtual void  v197(); // _ZN9S249C3_nt4v197Ev
  virtual void  v198(); // _ZN9S249C3_nt4v198Ev
  virtual void  v199(); // _ZN9S249C3_nt4v199Ev
  virtual void  v200(); // _ZN9S249C3_nt4v200Ev
  virtual void  v201(); // _ZN9S249C3_nt4v201Ev
  virtual void  v202(); // _ZN9S249C3_nt4v202Ev
  virtual void  v203(); // _ZN9S249C3_nt4v203Ev
  virtual void  v204(); // _ZN9S249C3_nt4v204Ev
  virtual void  v205(); // _ZN9S249C3_nt4v205Ev
  virtual void  v206(); // _ZN9S249C3_nt4v206Ev
  virtual void  v207(); // _ZN9S249C3_nt4v207Ev
  virtual void  v208(); // _ZN9S249C3_nt4v208Ev
  virtual void  v209(); // _ZN9S249C3_nt4v209Ev
  virtual void  v210(); // _ZN9S249C3_nt4v210Ev
  virtual void  v211(); // _ZN9S249C3_nt4v211Ev
  virtual void  v212(); // _ZN9S249C3_nt4v212Ev
  virtual void  v213(); // _ZN9S249C3_nt4v213Ev
  virtual void  v214(); // _ZN9S249C3_nt4v214Ev
  virtual void  v215(); // _ZN9S249C3_nt4v215Ev
  S249C3_nt(); // tgen
};
//SIG(-1 S249C3_nt) C1{ BC2{ BC3{ BC4{ vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v134 v135} vd v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 FC6{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC7 Fp FC10{ BC11{ BC9}} FC10 FC10 FC12{ BC13{ BC9}} Fc Fi Fp FC5 FC5 FC5 FC5 FC5 FC5 FC14{ m Fp FC5} FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 FC15{ BC16{ m Fi[4]}} FC5 Fp[2] FC17{ m FC5 Fp FC15 Fp} FC18{ m Fp[8] Fc[4]} Fi FC19{ m Fp[5] FC20{ m Fi[4] Fc[4]} Fi:1 Fi:1 Fi Fc[8]} Fi[4] FC5[4] FC21{ m FC22{ m Fi[3]} FC23{ m} FC24{ BC25{ m Fi[2] Fc[2]} Fi} Fc} FC22 Fi FC26{ m FC27{ BC28{ m Fp[2]}} Fc FC29{ BC30{ BC31{ BC9}}} Fi FC5 FC5 Fp} FC26 Fp FC22 FC12 FC32{ BC33{ BC9}} Fi:1 Fi:1 Fi:1 FC23 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14}


 S249C3_nt ::~S249C3_nt(){ note_dtor("S249C3_nt", this);}
void  S249C3_nt ::v147(){vfunc_called(this, "_ZN9S249C3_nt4v147Ev");}
void  S249C3_nt ::v148(){vfunc_called(this, "_ZN9S249C3_nt4v148Ev");}
void  S249C3_nt ::v149(){vfunc_called(this, "_ZN9S249C3_nt4v149Ev");}
void  S249C3_nt ::v150(){vfunc_called(this, "_ZN9S249C3_nt4v150Ev");}
void  S249C3_nt ::v151(){vfunc_called(this, "_ZN9S249C3_nt4v151Ev");}
void  S249C3_nt ::v152(){vfunc_called(this, "_ZN9S249C3_nt4v152Ev");}
void  S249C3_nt ::v153(){vfunc_called(this, "_ZN9S249C3_nt4v153Ev");}
void  S249C3_nt ::v154(){vfunc_called(this, "_ZN9S249C3_nt4v154Ev");}
void  S249C3_nt ::v155(){vfunc_called(this, "_ZN9S249C3_nt4v155Ev");}
void  S249C3_nt ::v156(){vfunc_called(this, "_ZN9S249C3_nt4v156Ev");}
void  S249C3_nt ::v157(){vfunc_called(this, "_ZN9S249C3_nt4v157Ev");}
void  S249C3_nt ::v158(){vfunc_called(this, "_ZN9S249C3_nt4v158Ev");}
void  S249C3_nt ::v159(){vfunc_called(this, "_ZN9S249C3_nt4v159Ev");}
void  S249C3_nt ::v160(){vfunc_called(this, "_ZN9S249C3_nt4v160Ev");}
void  S249C3_nt ::v161(){vfunc_called(this, "_ZN9S249C3_nt4v161Ev");}
void  S249C3_nt ::v162(){vfunc_called(this, "_ZN9S249C3_nt4v162Ev");}
void  S249C3_nt ::v163(){vfunc_called(this, "_ZN9S249C3_nt4v163Ev");}
void  S249C3_nt ::v164(){vfunc_called(this, "_ZN9S249C3_nt4v164Ev");}
void  S249C3_nt ::v165(){vfunc_called(this, "_ZN9S249C3_nt4v165Ev");}
void  S249C3_nt ::v166(){vfunc_called(this, "_ZN9S249C3_nt4v166Ev");}
void  S249C3_nt ::v167(){vfunc_called(this, "_ZN9S249C3_nt4v167Ev");}
void  S249C3_nt ::v168(){vfunc_called(this, "_ZN9S249C3_nt4v168Ev");}
void  S249C3_nt ::v169(){vfunc_called(this, "_ZN9S249C3_nt4v169Ev");}
void  S249C3_nt ::v170(){vfunc_called(this, "_ZN9S249C3_nt4v170Ev");}
void  S249C3_nt ::v171(){vfunc_called(this, "_ZN9S249C3_nt4v171Ev");}
void  S249C3_nt ::v172(){vfunc_called(this, "_ZN9S249C3_nt4v172Ev");}
void  S249C3_nt ::v173(){vfunc_called(this, "_ZN9S249C3_nt4v173Ev");}
void  S249C3_nt ::v174(){vfunc_called(this, "_ZN9S249C3_nt4v174Ev");}
void  S249C3_nt ::v175(){vfunc_called(this, "_ZN9S249C3_nt4v175Ev");}
void  S249C3_nt ::v176(){vfunc_called(this, "_ZN9S249C3_nt4v176Ev");}
void  S249C3_nt ::v177(){vfunc_called(this, "_ZN9S249C3_nt4v177Ev");}
void  S249C3_nt ::v178(){vfunc_called(this, "_ZN9S249C3_nt4v178Ev");}
void  S249C3_nt ::v179(){vfunc_called(this, "_ZN9S249C3_nt4v179Ev");}
void  S249C3_nt ::v180(){vfunc_called(this, "_ZN9S249C3_nt4v180Ev");}
void  S249C3_nt ::v181(){vfunc_called(this, "_ZN9S249C3_nt4v181Ev");}
void  S249C3_nt ::v182(){vfunc_called(this, "_ZN9S249C3_nt4v182Ev");}
void  S249C3_nt ::v183(){vfunc_called(this, "_ZN9S249C3_nt4v183Ev");}
void  S249C3_nt ::v184(){vfunc_called(this, "_ZN9S249C3_nt4v184Ev");}
void  S249C3_nt ::v185(){vfunc_called(this, "_ZN9S249C3_nt4v185Ev");}
void  S249C3_nt ::v186(){vfunc_called(this, "_ZN9S249C3_nt4v186Ev");}
void  S249C3_nt ::v187(){vfunc_called(this, "_ZN9S249C3_nt4v187Ev");}
void  S249C3_nt ::v188(){vfunc_called(this, "_ZN9S249C3_nt4v188Ev");}
void  S249C3_nt ::v189(){vfunc_called(this, "_ZN9S249C3_nt4v189Ev");}
void  S249C3_nt ::v190(){vfunc_called(this, "_ZN9S249C3_nt4v190Ev");}
void  S249C3_nt ::v191(){vfunc_called(this, "_ZN9S249C3_nt4v191Ev");}
void  S249C3_nt ::v192(){vfunc_called(this, "_ZN9S249C3_nt4v192Ev");}
void  S249C3_nt ::v193(){vfunc_called(this, "_ZN9S249C3_nt4v193Ev");}
void  S249C3_nt ::v194(){vfunc_called(this, "_ZN9S249C3_nt4v194Ev");}
void  S249C3_nt ::v195(){vfunc_called(this, "_ZN9S249C3_nt4v195Ev");}
void  S249C3_nt ::v196(){vfunc_called(this, "_ZN9S249C3_nt4v196Ev");}
void  S249C3_nt ::v197(){vfunc_called(this, "_ZN9S249C3_nt4v197Ev");}
void  S249C3_nt ::v198(){vfunc_called(this, "_ZN9S249C3_nt4v198Ev");}
void  S249C3_nt ::v199(){vfunc_called(this, "_ZN9S249C3_nt4v199Ev");}
void  S249C3_nt ::v200(){vfunc_called(this, "_ZN9S249C3_nt4v200Ev");}
void  S249C3_nt ::v201(){vfunc_called(this, "_ZN9S249C3_nt4v201Ev");}
void  S249C3_nt ::v202(){vfunc_called(this, "_ZN9S249C3_nt4v202Ev");}
void  S249C3_nt ::v203(){vfunc_called(this, "_ZN9S249C3_nt4v203Ev");}
void  S249C3_nt ::v204(){vfunc_called(this, "_ZN9S249C3_nt4v204Ev");}
void  S249C3_nt ::v205(){vfunc_called(this, "_ZN9S249C3_nt4v205Ev");}
void  S249C3_nt ::v206(){vfunc_called(this, "_ZN9S249C3_nt4v206Ev");}
void  S249C3_nt ::v207(){vfunc_called(this, "_ZN9S249C3_nt4v207Ev");}
void  S249C3_nt ::v208(){vfunc_called(this, "_ZN9S249C3_nt4v208Ev");}
void  S249C3_nt ::v209(){vfunc_called(this, "_ZN9S249C3_nt4v209Ev");}
void  S249C3_nt ::v210(){vfunc_called(this, "_ZN9S249C3_nt4v210Ev");}
void  S249C3_nt ::v211(){vfunc_called(this, "_ZN9S249C3_nt4v211Ev");}
void  S249C3_nt ::v212(){vfunc_called(this, "_ZN9S249C3_nt4v212Ev");}
void  S249C3_nt ::v213(){vfunc_called(this, "_ZN9S249C3_nt4v213Ev");}
void  S249C3_nt ::v214(){vfunc_called(this, "_ZN9S249C3_nt4v214Ev");}
void  S249C3_nt ::v215(){vfunc_called(this, "_ZN9S249C3_nt4v215Ev");}
S249C3_nt ::S249C3_nt(){ note_ctor("S249C3_nt", this);} // tgen

//skip512 S249C3_nt

#else // __cplusplus

extern void _ZN9S249C3_ntC1Ev();
extern void _ZN9S249C3_ntD1Ev();
Name_Map name_map_S249C3_nt[] = {
  NSPAIR(_ZN9S249C3_ntC1Ev),
  NSPAIR(_ZN9S249C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S249C6_nt;
extern VTBL_ENTRY _ZTI9S249C6_nt[];
extern  VTBL_ENTRY _ZTV9S249C6_nt[];
extern Class_Descriptor cd_S249C5_nt;
extern VTBL_ENTRY _ZTI9S249C5_nt[];
extern  VTBL_ENTRY _ZTV9S249C5_nt[];
extern Class_Descriptor cd_S249C4_nt;
extern VTBL_ENTRY _ZTI9S249C4_nt[];
extern  VTBL_ENTRY _ZTV9S249C4_nt[];
static Base_Class bases_S249C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S249C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S249C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S249C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S249C3_nt[];
extern void _ZN9S249C3_ntD1Ev();
extern void _ZN9S249C3_ntD0Ev();
extern void _ZN9S249C6_nt2v5Ev();
extern void _ZN9S249C6_nt2v6Ev();
extern void _ZN9S249C6_nt2v7Ev();
extern void _ZN9S249C6_nt2v8Ev();
extern void _ZN9S249C6_nt2v9Ev();
extern void _ZN9S249C6_nt3v10Ev();
extern void _ZN9S249C6_nt3v11Ev();
extern void _ZN9S249C6_nt3v12Ev();
extern void _ZN9S249C6_nt3v13Ev();
extern void _ZN9S249C6_nt3v14Ev();
extern void _ZN9S249C6_nt3v15Ev();
extern void _ZN9S249C6_nt3v16Ev();
extern void _ZN9S249C6_nt3v17Ev();
extern void _ZN9S249C6_nt3v18Ev();
extern void _ZN9S249C6_nt3v19Ev();
extern void _ZN9S249C6_nt3v20Ev();
extern void _ZN9S249C6_nt3v21Ev();
extern void _ZN9S249C6_nt3v22Ev();
extern void _ZN9S249C6_nt3v23Ev();
extern void _ZN9S249C6_nt3v24Ev();
extern void _ZN9S249C6_nt3v25Ev();
extern void _ZN9S249C6_nt3v26Ev();
extern void _ZN9S249C6_nt3v27Ev();
extern void _ZN9S249C6_nt3v28Ev();
extern void _ZN9S249C6_nt3v29Ev();
extern void _ZN9S249C6_nt3v30Ev();
extern void _ZN9S249C6_nt3v31Ev();
extern void _ZN9S249C6_nt3v32Ev();
extern void _ZN9S249C6_nt3v33Ev();
extern void _ZN9S249C6_nt3v34Ev();
extern void _ZN9S249C6_nt3v35Ev();
extern void _ZN9S249C6_nt3v36Ev();
extern void _ZN9S249C6_nt3v37Ev();
extern void _ZN9S249C6_nt3v38Ev();
extern void _ZN9S249C6_nt3v39Ev();
extern void _ZN9S249C6_nt3v40Ev();
extern void _ZN9S249C6_nt3v41Ev();
extern void _ZN9S249C6_nt3v42Ev();
extern void _ZN9S249C6_nt3v43Ev();
extern void _ZN9S249C6_nt3v44Ev();
extern void _ZN9S249C6_nt3v45Ev();
extern void _ZN9S249C6_nt3v46Ev();
extern void _ZN9S249C6_nt3v47Ev();
extern void _ZN9S249C6_nt3v48Ev();
extern void _ZN9S249C6_nt3v49Ev();
extern void _ZN9S249C6_nt3v50Ev();
extern void _ZN9S249C6_nt3v51Ev();
extern void _ZN9S249C6_nt3v52Ev();
extern void _ZN9S249C6_nt3v53Ev();
extern void _ZN9S249C6_nt3v54Ev();
extern void _ZN9S249C6_nt3v55Ev();
extern void _ZN9S249C6_nt3v56Ev();
extern void _ZN9S249C6_nt3v57Ev();
extern void _ZN9S249C6_nt3v58Ev();
extern void _ZN9S249C6_nt3v59Ev();
extern void _ZN9S249C6_nt3v60Ev();
extern void _ZN9S249C6_nt3v61Ev();
extern void _ZN9S249C6_nt3v62Ev();
extern void _ZN9S249C6_nt3v63Ev();
extern void _ZN9S249C6_nt3v64Ev();
extern void _ZN9S249C6_nt3v65Ev();
extern void _ZN9S249C6_nt3v66Ev();
extern void _ZN9S249C6_nt3v67Ev();
extern void _ZN9S249C6_nt3v68Ev();
extern void _ZN9S249C5_nt3v69Ev();
extern void _ZN9S249C5_nt3v70Ev();
extern void _ZN9S249C4_nt3v71Ev();
extern void _ZN9S249C4_nt3v72Ev();
extern void _ZN9S249C4_nt3v73Ev();
extern void _ZN9S249C4_nt3v74Ev();
extern void _ZN9S249C4_nt3v75Ev();
extern void _ZN9S249C4_nt3v76Ev();
extern void _ZN9S249C4_nt3v77Ev();
extern void _ZN9S249C4_nt3v78Ev();
extern void _ZN9S249C4_nt3v79Ev();
extern void _ZN9S249C4_nt3v80Ev();
extern void _ZN9S249C4_nt3v81Ev();
extern void _ZN9S249C4_nt3v82Ev();
extern void _ZN9S249C4_nt3v83Ev();
extern void _ZN9S249C4_nt3v84Ev();
extern void _ZN9S249C4_nt3v85Ev();
extern void _ZN9S249C4_nt3v86Ev();
extern void _ZN9S249C4_nt3v87Ev();
extern void _ZN9S249C4_nt3v88Ev();
extern void _ZN9S249C4_nt3v89Ev();
extern void _ZN9S249C4_nt3v90Ev();
extern void _ZN9S249C4_nt3v91Ev();
extern void _ZN9S249C4_nt3v92Ev();
extern void _ZN9S249C4_nt3v93Ev();
extern void _ZN9S249C4_nt3v94Ev();
extern void _ZN9S249C4_nt3v95Ev();
extern void _ZN9S249C4_nt3v96Ev();
extern void _ZN9S249C4_nt3v97Ev();
extern void _ZN9S249C4_nt3v98Ev();
extern void _ZN9S249C4_nt3v99Ev();
extern void _ZN9S249C4_nt4v100Ev();
extern void _ZN9S249C4_nt4v101Ev();
extern void _ZN9S249C4_nt4v102Ev();
extern void _ZN9S249C4_nt4v103Ev();
extern void _ZN9S249C4_nt4v104Ev();
extern void _ZN9S249C4_nt4v105Ev();
extern void _ZN9S249C4_nt4v106Ev();
extern void _ZN9S249C4_nt4v107Ev();
extern void _ZN9S249C4_nt4v108Ev();
extern void _ZN9S249C4_nt4v109Ev();
extern void _ZN9S249C4_nt4v110Ev();
extern void _ZN9S249C4_nt4v111Ev();
extern void _ZN9S249C4_nt4v112Ev();
extern void _ZN9S249C4_nt4v113Ev();
extern void _ZN9S249C4_nt4v114Ev();
extern void _ZN9S249C4_nt4v115Ev();
extern void _ZN9S249C4_nt4v116Ev();
extern void _ZN9S249C4_nt4v117Ev();
extern void _ZN9S249C4_nt4v118Ev();
extern void _ZN9S249C4_nt4v119Ev();
extern void _ZN9S249C4_nt4v120Ev();
extern void _ZN9S249C4_nt4v121Ev();
extern void _ZN9S249C4_nt4v122Ev();
extern void _ZN9S249C4_nt4v123Ev();
extern void _ZN9S249C4_nt4v124Ev();
extern void _ZN9S249C4_nt4v125Ev();
extern void _ZN9S249C4_nt4v126Ev();
extern void _ZN9S249C4_nt4v127Ev();
extern void _ZN9S249C4_nt4v128Ev();
extern void _ZN9S249C4_nt4v129Ev();
extern void _ZN9S249C4_nt4v130Ev();
extern void _ZN9S249C4_nt4v131Ev();
extern void _ZN9S249C4_nt4v132Ev();
extern void _ZN9S249C4_nt4v133Ev();
extern void _ZN9S249C4_nt4v134Ev();
extern void _ZN9S249C4_nt4v135Ev();
extern void _ZN9S249C4_nt4v136Ev();
extern void _ZN9S249C4_nt4v137Ev();
extern void _ZN9S249C4_nt4v138Ev();
extern void _ZN9S249C4_nt4v139Ev();
extern void _ZN9S249C4_nt4v140Ev();
extern void _ZN9S249C4_nt4v141Ev();
extern void _ZN9S249C4_nt4v142Ev();
extern void _ZN9S249C4_nt4v143Ev();
extern void _ZN9S249C4_nt4v144Ev();
extern void _ZN9S249C4_nt4v145Ev();
extern void _ZN9S249C4_nt4v146Ev();
extern void _ZN9S249C3_nt4v147Ev();
extern void _ZN9S249C3_nt4v148Ev();
extern void _ZN9S249C3_nt4v149Ev();
extern void _ZN9S249C3_nt4v150Ev();
extern void _ZN9S249C3_nt4v151Ev();
extern void _ZN9S249C3_nt4v152Ev();
extern void _ZN9S249C3_nt4v153Ev();
extern void _ZN9S249C3_nt4v154Ev();
extern void _ZN9S249C3_nt4v155Ev();
extern void _ZN9S249C3_nt4v156Ev();
extern void _ZN9S249C3_nt4v157Ev();
extern void _ZN9S249C3_nt4v158Ev();
extern void _ZN9S249C3_nt4v159Ev();
extern void _ZN9S249C3_nt4v160Ev();
extern void _ZN9S249C3_nt4v161Ev();
extern void _ZN9S249C3_nt4v162Ev();
extern void _ZN9S249C3_nt4v163Ev();
extern void _ZN9S249C3_nt4v164Ev();
extern void _ZN9S249C3_nt4v165Ev();
extern void _ZN9S249C3_nt4v166Ev();
extern void _ZN9S249C3_nt4v167Ev();
extern void _ZN9S249C3_nt4v168Ev();
extern void _ZN9S249C3_nt4v169Ev();
extern void _ZN9S249C3_nt4v170Ev();
extern void _ZN9S249C3_nt4v171Ev();
extern void _ZN9S249C3_nt4v172Ev();
extern void _ZN9S249C3_nt4v173Ev();
extern void _ZN9S249C3_nt4v174Ev();
extern void _ZN9S249C3_nt4v175Ev();
extern void _ZN9S249C3_nt4v176Ev();
extern void _ZN9S249C3_nt4v177Ev();
extern void _ZN9S249C3_nt4v178Ev();
extern void _ZN9S249C3_nt4v179Ev();
extern void _ZN9S249C3_nt4v180Ev();
extern void _ZN9S249C3_nt4v181Ev();
extern void _ZN9S249C3_nt4v182Ev();
extern void _ZN9S249C3_nt4v183Ev();
extern void _ZN9S249C3_nt4v184Ev();
extern void _ZN9S249C3_nt4v185Ev();
extern void _ZN9S249C3_nt4v186Ev();
extern void _ZN9S249C3_nt4v187Ev();
extern void _ZN9S249C3_nt4v188Ev();
extern void _ZN9S249C3_nt4v189Ev();
extern void _ZN9S249C3_nt4v190Ev();
extern void _ZN9S249C3_nt4v191Ev();
extern void _ZN9S249C3_nt4v192Ev();
extern void _ZN9S249C3_nt4v193Ev();
extern void _ZN9S249C3_nt4v194Ev();
extern void _ZN9S249C3_nt4v195Ev();
extern void _ZN9S249C3_nt4v196Ev();
extern void _ZN9S249C3_nt4v197Ev();
extern void _ZN9S249C3_nt4v198Ev();
extern void _ZN9S249C3_nt4v199Ev();
extern void _ZN9S249C3_nt4v200Ev();
extern void _ZN9S249C3_nt4v201Ev();
extern void _ZN9S249C3_nt4v202Ev();
extern void _ZN9S249C3_nt4v203Ev();
extern void _ZN9S249C3_nt4v204Ev();
extern void _ZN9S249C3_nt4v205Ev();
extern void _ZN9S249C3_nt4v206Ev();
extern void _ZN9S249C3_nt4v207Ev();
extern void _ZN9S249C3_nt4v208Ev();
extern void _ZN9S249C3_nt4v209Ev();
extern void _ZN9S249C3_nt4v210Ev();
extern void _ZN9S249C3_nt4v211Ev();
extern void _ZN9S249C3_nt4v212Ev();
extern void _ZN9S249C3_nt4v213Ev();
extern void _ZN9S249C3_nt4v214Ev();
extern void _ZN9S249C3_nt4v215Ev();
static  VTBL_ENTRY vtc_S249C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S249C3_nt[0]),
  (VTBL_ENTRY)&_ZN9S249C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S249C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S249C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S249C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v211Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v212Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v213Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v214Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v215Ev,
};
extern VTBL_ENTRY _ZTI9S249C3_nt[];
VTBL_ENTRY *P__ZTI9S249C3_nt = _ZTI9S249C3_nt; 
extern  VTBL_ENTRY _ZTV9S249C3_nt[];
Class_Descriptor cd_S249C3_nt = {  "S249C3_nt", // class name
  bases_S249C3_nt, 3,
  &(vtc_S249C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1224,908), // object size
  NSPAIRA(_ZTI9S249C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S249C3_nt),215, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C2  : S249C3_nt {
  void *s249c2f0;
  virtual  ~S249C2(); // _ZN6S249C2D1Ev
  virtual void  v216(); // _ZN6S249C24v216Ev
  virtual void  v217(); // _ZN6S249C24v217Ev
  virtual void  v218(); // _ZN6S249C24v218Ev
  virtual void  v219(); // _ZN6S249C24v219Ev
  S249C2(); // tgen
};
//SIG(-1 S249C2) C1{ BC2{ BC3{ BC4{ BC5{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v69 v70} vd v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 FC7{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC8{ BC9{ BC10{ m Fp Fi[2]}}} FC8 Fp FC11{ BC12{ BC10}} FC11 FC11 FC13{ BC14{ BC10}} Fc Fi Fp FC6 FC6 FC6 FC6 FC6 FC6 FC15{ m Fp FC6} FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15} vd v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 FC16{ BC17{ m Fi[4]}} FC6 Fp[2] FC18{ m FC6 Fp FC16 Fp} FC19{ m Fp[8] Fc[4]} Fi FC20{ m Fp[5] FC21{ m Fi[4] Fc[4]} Fi:1 Fi:1 Fi Fc[8]} Fi[4] FC6[4] FC22{ m FC23{ m Fi[3]} FC24{ m} FC25{ BC26{ m Fi[2] Fc[2]} Fi} Fc} FC23 Fi FC27{ m FC28{ BC29{ m Fp[2]}} Fc FC30{ BC31{ BC32{ BC10}}} Fi FC6 FC6 Fp} FC27 Fp FC23 FC13 FC33{ BC34{ BC10}} Fi:1 Fi:1 Fi:1 FC24 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15} vd v1 v2 v3 v4 Fp}


 S249C2 ::~S249C2(){ note_dtor("S249C2", this);}
void  S249C2 ::v216(){vfunc_called(this, "_ZN6S249C24v216Ev");}
void  S249C2 ::v217(){vfunc_called(this, "_ZN6S249C24v217Ev");}
void  S249C2 ::v218(){vfunc_called(this, "_ZN6S249C24v218Ev");}
void  S249C2 ::v219(){vfunc_called(this, "_ZN6S249C24v219Ev");}
S249C2 ::S249C2(){ note_ctor("S249C2", this);} // tgen

static void Test_S249C2()
{
  extern Class_Descriptor cd_S249C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(155,229)];
    init_test(&cd_S249C2, buf);
    S249C2 *dp, &lv = *(dp=new (buf) S249C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1232,912), "sizeof(S249C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S249C2)");
    check_base_class_offset(lv, (S249C6_nt*)(S249C5_nt*)(S249C4_nt*)(S249C3_nt*), 0, "S249C2");
    check_base_class_offset(lv, (S249C5_nt*)(S249C4_nt*)(S249C3_nt*), 0, "S249C2");
    check_base_class_offset(lv, (S249C4_nt*)(S249C3_nt*), 0, "S249C2");
    check_base_class_offset(lv, (S249C3_nt*), 0, "S249C2");
    check_field_offset(lv, s249c2f0, ABISELECT(1224,908), "S249C2.s249c2f0");
    test_class_info(&lv, &cd_S249C2);
    dp->~S249C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS249C2(Test_S249C2, "S249C2", ABISELECT(1232,912));

#else // __cplusplus

extern void _ZN6S249C2C1Ev();
extern void _ZN6S249C2D1Ev();
Name_Map name_map_S249C2[] = {
  NSPAIR(_ZN6S249C2C1Ev),
  NSPAIR(_ZN6S249C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S249C6_nt;
extern VTBL_ENTRY _ZTI9S249C6_nt[];
extern  VTBL_ENTRY _ZTV9S249C6_nt[];
extern Class_Descriptor cd_S249C5_nt;
extern VTBL_ENTRY _ZTI9S249C5_nt[];
extern  VTBL_ENTRY _ZTV9S249C5_nt[];
extern Class_Descriptor cd_S249C4_nt;
extern VTBL_ENTRY _ZTI9S249C4_nt[];
extern  VTBL_ENTRY _ZTV9S249C4_nt[];
extern Class_Descriptor cd_S249C3_nt;
extern VTBL_ENTRY _ZTI9S249C3_nt[];
extern  VTBL_ENTRY _ZTV9S249C3_nt[];
static Base_Class bases_S249C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S249C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S249C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S249C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S249C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S249C2[];
extern void _ZN6S249C2D1Ev();
extern void _ZN6S249C2D0Ev();
extern void _ZN9S249C6_nt2v5Ev();
extern void _ZN9S249C6_nt2v6Ev();
extern void _ZN9S249C6_nt2v7Ev();
extern void _ZN9S249C6_nt2v8Ev();
extern void _ZN9S249C6_nt2v9Ev();
extern void _ZN9S249C6_nt3v10Ev();
extern void _ZN9S249C6_nt3v11Ev();
extern void _ZN9S249C6_nt3v12Ev();
extern void _ZN9S249C6_nt3v13Ev();
extern void _ZN9S249C6_nt3v14Ev();
extern void _ZN9S249C6_nt3v15Ev();
extern void _ZN9S249C6_nt3v16Ev();
extern void _ZN9S249C6_nt3v17Ev();
extern void _ZN9S249C6_nt3v18Ev();
extern void _ZN9S249C6_nt3v19Ev();
extern void _ZN9S249C6_nt3v20Ev();
extern void _ZN9S249C6_nt3v21Ev();
extern void _ZN9S249C6_nt3v22Ev();
extern void _ZN9S249C6_nt3v23Ev();
extern void _ZN9S249C6_nt3v24Ev();
extern void _ZN9S249C6_nt3v25Ev();
extern void _ZN9S249C6_nt3v26Ev();
extern void _ZN9S249C6_nt3v27Ev();
extern void _ZN9S249C6_nt3v28Ev();
extern void _ZN9S249C6_nt3v29Ev();
extern void _ZN9S249C6_nt3v30Ev();
extern void _ZN9S249C6_nt3v31Ev();
extern void _ZN9S249C6_nt3v32Ev();
extern void _ZN9S249C6_nt3v33Ev();
extern void _ZN9S249C6_nt3v34Ev();
extern void _ZN9S249C6_nt3v35Ev();
extern void _ZN9S249C6_nt3v36Ev();
extern void _ZN9S249C6_nt3v37Ev();
extern void _ZN9S249C6_nt3v38Ev();
extern void _ZN9S249C6_nt3v39Ev();
extern void _ZN9S249C6_nt3v40Ev();
extern void _ZN9S249C6_nt3v41Ev();
extern void _ZN9S249C6_nt3v42Ev();
extern void _ZN9S249C6_nt3v43Ev();
extern void _ZN9S249C6_nt3v44Ev();
extern void _ZN9S249C6_nt3v45Ev();
extern void _ZN9S249C6_nt3v46Ev();
extern void _ZN9S249C6_nt3v47Ev();
extern void _ZN9S249C6_nt3v48Ev();
extern void _ZN9S249C6_nt3v49Ev();
extern void _ZN9S249C6_nt3v50Ev();
extern void _ZN9S249C6_nt3v51Ev();
extern void _ZN9S249C6_nt3v52Ev();
extern void _ZN9S249C6_nt3v53Ev();
extern void _ZN9S249C6_nt3v54Ev();
extern void _ZN9S249C6_nt3v55Ev();
extern void _ZN9S249C6_nt3v56Ev();
extern void _ZN9S249C6_nt3v57Ev();
extern void _ZN9S249C6_nt3v58Ev();
extern void _ZN9S249C6_nt3v59Ev();
extern void _ZN9S249C6_nt3v60Ev();
extern void _ZN9S249C6_nt3v61Ev();
extern void _ZN9S249C6_nt3v62Ev();
extern void _ZN9S249C6_nt3v63Ev();
extern void _ZN9S249C6_nt3v64Ev();
extern void _ZN9S249C6_nt3v65Ev();
extern void _ZN9S249C6_nt3v66Ev();
extern void _ZN9S249C6_nt3v67Ev();
extern void _ZN9S249C6_nt3v68Ev();
extern void _ZN9S249C5_nt3v69Ev();
extern void _ZN9S249C5_nt3v70Ev();
extern void _ZN9S249C4_nt3v71Ev();
extern void _ZN9S249C4_nt3v72Ev();
extern void _ZN9S249C4_nt3v73Ev();
extern void _ZN9S249C4_nt3v74Ev();
extern void _ZN9S249C4_nt3v75Ev();
extern void _ZN9S249C4_nt3v76Ev();
extern void _ZN9S249C4_nt3v77Ev();
extern void _ZN9S249C4_nt3v78Ev();
extern void _ZN9S249C4_nt3v79Ev();
extern void _ZN9S249C4_nt3v80Ev();
extern void _ZN9S249C4_nt3v81Ev();
extern void _ZN9S249C4_nt3v82Ev();
extern void _ZN9S249C4_nt3v83Ev();
extern void _ZN9S249C4_nt3v84Ev();
extern void _ZN9S249C4_nt3v85Ev();
extern void _ZN9S249C4_nt3v86Ev();
extern void _ZN9S249C4_nt3v87Ev();
extern void _ZN9S249C4_nt3v88Ev();
extern void _ZN9S249C4_nt3v89Ev();
extern void _ZN9S249C4_nt3v90Ev();
extern void _ZN9S249C4_nt3v91Ev();
extern void _ZN9S249C4_nt3v92Ev();
extern void _ZN9S249C4_nt3v93Ev();
extern void _ZN9S249C4_nt3v94Ev();
extern void _ZN9S249C4_nt3v95Ev();
extern void _ZN9S249C4_nt3v96Ev();
extern void _ZN9S249C4_nt3v97Ev();
extern void _ZN9S249C4_nt3v98Ev();
extern void _ZN9S249C4_nt3v99Ev();
extern void _ZN9S249C4_nt4v100Ev();
extern void _ZN9S249C4_nt4v101Ev();
extern void _ZN9S249C4_nt4v102Ev();
extern void _ZN9S249C4_nt4v103Ev();
extern void _ZN9S249C4_nt4v104Ev();
extern void _ZN9S249C4_nt4v105Ev();
extern void _ZN9S249C4_nt4v106Ev();
extern void _ZN9S249C4_nt4v107Ev();
extern void _ZN9S249C4_nt4v108Ev();
extern void _ZN9S249C4_nt4v109Ev();
extern void _ZN9S249C4_nt4v110Ev();
extern void _ZN9S249C4_nt4v111Ev();
extern void _ZN9S249C4_nt4v112Ev();
extern void _ZN9S249C4_nt4v113Ev();
extern void _ZN9S249C4_nt4v114Ev();
extern void _ZN9S249C4_nt4v115Ev();
extern void _ZN9S249C4_nt4v116Ev();
extern void _ZN9S249C4_nt4v117Ev();
extern void _ZN9S249C4_nt4v118Ev();
extern void _ZN9S249C4_nt4v119Ev();
extern void _ZN9S249C4_nt4v120Ev();
extern void _ZN9S249C4_nt4v121Ev();
extern void _ZN9S249C4_nt4v122Ev();
extern void _ZN9S249C4_nt4v123Ev();
extern void _ZN9S249C4_nt4v124Ev();
extern void _ZN9S249C4_nt4v125Ev();
extern void _ZN9S249C4_nt4v126Ev();
extern void _ZN9S249C4_nt4v127Ev();
extern void _ZN9S249C4_nt4v128Ev();
extern void _ZN9S249C4_nt4v129Ev();
extern void _ZN9S249C4_nt4v130Ev();
extern void _ZN9S249C4_nt4v131Ev();
extern void _ZN9S249C4_nt4v132Ev();
extern void _ZN9S249C4_nt4v133Ev();
extern void _ZN9S249C4_nt4v134Ev();
extern void _ZN9S249C4_nt4v135Ev();
extern void _ZN9S249C4_nt4v136Ev();
extern void _ZN9S249C4_nt4v137Ev();
extern void _ZN9S249C4_nt4v138Ev();
extern void _ZN9S249C4_nt4v139Ev();
extern void _ZN9S249C4_nt4v140Ev();
extern void _ZN9S249C4_nt4v141Ev();
extern void _ZN9S249C4_nt4v142Ev();
extern void _ZN9S249C4_nt4v143Ev();
extern void _ZN9S249C4_nt4v144Ev();
extern void _ZN9S249C4_nt4v145Ev();
extern void _ZN9S249C4_nt4v146Ev();
extern void _ZN9S249C3_nt4v147Ev();
extern void _ZN9S249C3_nt4v148Ev();
extern void _ZN9S249C3_nt4v149Ev();
extern void _ZN9S249C3_nt4v150Ev();
extern void _ZN9S249C3_nt4v151Ev();
extern void _ZN9S249C3_nt4v152Ev();
extern void _ZN9S249C3_nt4v153Ev();
extern void _ZN9S249C3_nt4v154Ev();
extern void _ZN9S249C3_nt4v155Ev();
extern void _ZN9S249C3_nt4v156Ev();
extern void _ZN9S249C3_nt4v157Ev();
extern void _ZN9S249C3_nt4v158Ev();
extern void _ZN9S249C3_nt4v159Ev();
extern void _ZN9S249C3_nt4v160Ev();
extern void _ZN9S249C3_nt4v161Ev();
extern void _ZN9S249C3_nt4v162Ev();
extern void _ZN9S249C3_nt4v163Ev();
extern void _ZN9S249C3_nt4v164Ev();
extern void _ZN9S249C3_nt4v165Ev();
extern void _ZN9S249C3_nt4v166Ev();
extern void _ZN9S249C3_nt4v167Ev();
extern void _ZN9S249C3_nt4v168Ev();
extern void _ZN9S249C3_nt4v169Ev();
extern void _ZN9S249C3_nt4v170Ev();
extern void _ZN9S249C3_nt4v171Ev();
extern void _ZN9S249C3_nt4v172Ev();
extern void _ZN9S249C3_nt4v173Ev();
extern void _ZN9S249C3_nt4v174Ev();
extern void _ZN9S249C3_nt4v175Ev();
extern void _ZN9S249C3_nt4v176Ev();
extern void _ZN9S249C3_nt4v177Ev();
extern void _ZN9S249C3_nt4v178Ev();
extern void _ZN9S249C3_nt4v179Ev();
extern void _ZN9S249C3_nt4v180Ev();
extern void _ZN9S249C3_nt4v181Ev();
extern void _ZN9S249C3_nt4v182Ev();
extern void _ZN9S249C3_nt4v183Ev();
extern void _ZN9S249C3_nt4v184Ev();
extern void _ZN9S249C3_nt4v185Ev();
extern void _ZN9S249C3_nt4v186Ev();
extern void _ZN9S249C3_nt4v187Ev();
extern void _ZN9S249C3_nt4v188Ev();
extern void _ZN9S249C3_nt4v189Ev();
extern void _ZN9S249C3_nt4v190Ev();
extern void _ZN9S249C3_nt4v191Ev();
extern void _ZN9S249C3_nt4v192Ev();
extern void _ZN9S249C3_nt4v193Ev();
extern void _ZN9S249C3_nt4v194Ev();
extern void _ZN9S249C3_nt4v195Ev();
extern void _ZN9S249C3_nt4v196Ev();
extern void _ZN9S249C3_nt4v197Ev();
extern void _ZN9S249C3_nt4v198Ev();
extern void _ZN9S249C3_nt4v199Ev();
extern void _ZN9S249C3_nt4v200Ev();
extern void _ZN9S249C3_nt4v201Ev();
extern void _ZN9S249C3_nt4v202Ev();
extern void _ZN9S249C3_nt4v203Ev();
extern void _ZN9S249C3_nt4v204Ev();
extern void _ZN9S249C3_nt4v205Ev();
extern void _ZN9S249C3_nt4v206Ev();
extern void _ZN9S249C3_nt4v207Ev();
extern void _ZN9S249C3_nt4v208Ev();
extern void _ZN9S249C3_nt4v209Ev();
extern void _ZN9S249C3_nt4v210Ev();
extern void _ZN9S249C3_nt4v211Ev();
extern void _ZN9S249C3_nt4v212Ev();
extern void _ZN9S249C3_nt4v213Ev();
extern void _ZN9S249C3_nt4v214Ev();
extern void _ZN9S249C3_nt4v215Ev();
extern void _ZN6S249C24v216Ev();
extern void _ZN6S249C24v217Ev();
extern void _ZN6S249C24v218Ev();
extern void _ZN6S249C24v219Ev();
static  VTBL_ENTRY vtc_S249C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S249C2[0]),
  (VTBL_ENTRY)&_ZN6S249C2D1Ev,
  (VTBL_ENTRY)&_ZN6S249C2D0Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S249C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S249C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v211Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v212Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v213Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v214Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v215Ev,
  (VTBL_ENTRY)&_ZN6S249C24v216Ev,
  (VTBL_ENTRY)&_ZN6S249C24v217Ev,
  (VTBL_ENTRY)&_ZN6S249C24v218Ev,
  (VTBL_ENTRY)&_ZN6S249C24v219Ev,
};
extern VTBL_ENTRY _ZTI6S249C2[];
extern  VTBL_ENTRY _ZTV6S249C2[];
Class_Descriptor cd_S249C2 = {  "S249C2", // class name
  bases_S249C2, 4,
  &(vtc_S249C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1232,912), // object size
  NSPAIRA(_ZTI6S249C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S249C2),219, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S249C1  : S249C2 {
  ::S249C30_nt s249c1f0;
  void *s249c1f1[2];
  ::S249C30_nt s249c1f2;
  void *s249c1f3;
  ::S249C30_nt s249c1f4;
  int s249c1f5;
  virtual  ~S249C1(); // _ZN6S249C1D1Ev
  virtual void  v1(); // _ZN6S249C12v1Ev
  virtual void  v2(); // _ZN6S249C12v2Ev
  virtual void  v3(); // _ZN6S249C12v3Ev
  virtual void  v4(); // _ZN6S249C12v4Ev
  S249C1(); // tgen
};
//SIG(1 S249C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v69 v70} vd v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 FC8{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC9{ BC10{ BC11{ m Fp Fi[2]}}} FC9 Fp FC12{ BC13{ BC11}} FC12 FC12 FC14{ BC15{ BC11}} Fc Fi Fp FC7 FC7 FC7 FC7 FC7 FC7 FC16{ m Fp FC7} FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16} vd v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 FC17{ BC18{ m Fi[4]}} FC7 Fp[2] FC19{ m FC7 Fp FC17 Fp} FC20{ m Fp[8] Fc[4]} Fi FC21{ m Fp[5] FC22{ m Fi[4] Fc[4]} Fi:1 Fi:1 Fi Fc[8]} Fi[4] FC7[4] FC23{ m FC24{ m Fi[3]} FC25{ m} FC26{ BC27{ m Fi[2] Fc[2]} Fi} Fc} FC24 Fi FC28{ m FC29{ BC30{ m Fp[2]}} Fc FC31{ BC32{ BC33{ BC11}}} Fi FC7 FC7 Fp} FC28 Fp FC24 FC14 FC34{ BC35{ BC11}} Fi:1 Fi:1 Fi:1 FC25 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16} vd v216 v217 v218 v219 Fp} vd v1 v2 v3 v4 FC24 Fp[2] FC24 Fp FC24 Fi}


 S249C1 ::~S249C1(){ note_dtor("S249C1", this);}
void  S249C1 ::v1(){vfunc_called(this, "_ZN6S249C12v1Ev");}
void  S249C1 ::v2(){vfunc_called(this, "_ZN6S249C12v2Ev");}
void  S249C1 ::v3(){vfunc_called(this, "_ZN6S249C12v3Ev");}
void  S249C1 ::v4(){vfunc_called(this, "_ZN6S249C12v4Ev");}
S249C1 ::S249C1(){ note_ctor("S249C1", this);} // tgen

static void Test_S249C1()
{
  extern Class_Descriptor cd_S249C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(164,242)];
    init_test(&cd_S249C1, buf);
    S249C1 *dp, &lv = *(dp=new (buf) S249C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1304,964), "sizeof(S249C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S249C1)");
    check_base_class_offset(lv, (S249C6_nt*)(S249C5_nt*)(S249C4_nt*)(S249C3_nt*)(S249C2*), 0, "S249C1");
    check_base_class_offset(lv, (S249C5_nt*)(S249C4_nt*)(S249C3_nt*)(S249C2*), 0, "S249C1");
    check_base_class_offset(lv, (S249C4_nt*)(S249C3_nt*)(S249C2*), 0, "S249C1");
    check_base_class_offset(lv, (S249C3_nt*)(S249C2*), 0, "S249C1");
    check_base_class_offset(lv, (S249C2*), 0, "S249C1");
    check_field_offset(lv, s249c1f0, ABISELECT(1232,912), "S249C1.s249c1f0");
    check_field_offset(lv, s249c1f1, ABISELECT(1248,924), "S249C1.s249c1f1");
    check_field_offset(lv, s249c1f2, ABISELECT(1264,932), "S249C1.s249c1f2");
    check_field_offset(lv, s249c1f3, ABISELECT(1280,944), "S249C1.s249c1f3");
    check_field_offset(lv, s249c1f4, ABISELECT(1288,948), "S249C1.s249c1f4");
    check_field_offset(lv, s249c1f5, ABISELECT(1300,960), "S249C1.s249c1f5");
    test_class_info(&lv, &cd_S249C1);
    dp->~S249C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS249C1(Test_S249C1, "S249C1", ABISELECT(1304,964));

#else // __cplusplus

extern void _ZN6S249C1C1Ev();
extern void _ZN6S249C1D1Ev();
Name_Map name_map_S249C1[] = {
  NSPAIR(_ZN6S249C1C1Ev),
  NSPAIR(_ZN6S249C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S249C6_nt;
extern VTBL_ENTRY _ZTI9S249C6_nt[];
extern  VTBL_ENTRY _ZTV9S249C6_nt[];
extern Class_Descriptor cd_S249C5_nt;
extern VTBL_ENTRY _ZTI9S249C5_nt[];
extern  VTBL_ENTRY _ZTV9S249C5_nt[];
extern Class_Descriptor cd_S249C4_nt;
extern VTBL_ENTRY _ZTI9S249C4_nt[];
extern  VTBL_ENTRY _ZTV9S249C4_nt[];
extern Class_Descriptor cd_S249C3_nt;
extern VTBL_ENTRY _ZTI9S249C3_nt[];
extern  VTBL_ENTRY _ZTV9S249C3_nt[];
extern Class_Descriptor cd_S249C2;
extern VTBL_ENTRY _ZTI6S249C2[];
extern  VTBL_ENTRY _ZTV6S249C2[];
static Base_Class bases_S249C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S249C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S249C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S249C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S249C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S249C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S249C1[];
extern void _ZN6S249C1D1Ev();
extern void _ZN6S249C1D0Ev();
extern void _ZN9S249C6_nt2v5Ev();
extern void _ZN9S249C6_nt2v6Ev();
extern void _ZN9S249C6_nt2v7Ev();
extern void _ZN9S249C6_nt2v8Ev();
extern void _ZN9S249C6_nt2v9Ev();
extern void _ZN9S249C6_nt3v10Ev();
extern void _ZN9S249C6_nt3v11Ev();
extern void _ZN9S249C6_nt3v12Ev();
extern void _ZN9S249C6_nt3v13Ev();
extern void _ZN9S249C6_nt3v14Ev();
extern void _ZN9S249C6_nt3v15Ev();
extern void _ZN9S249C6_nt3v16Ev();
extern void _ZN9S249C6_nt3v17Ev();
extern void _ZN9S249C6_nt3v18Ev();
extern void _ZN9S249C6_nt3v19Ev();
extern void _ZN9S249C6_nt3v20Ev();
extern void _ZN9S249C6_nt3v21Ev();
extern void _ZN9S249C6_nt3v22Ev();
extern void _ZN9S249C6_nt3v23Ev();
extern void _ZN9S249C6_nt3v24Ev();
extern void _ZN9S249C6_nt3v25Ev();
extern void _ZN9S249C6_nt3v26Ev();
extern void _ZN9S249C6_nt3v27Ev();
extern void _ZN9S249C6_nt3v28Ev();
extern void _ZN9S249C6_nt3v29Ev();
extern void _ZN9S249C6_nt3v30Ev();
extern void _ZN9S249C6_nt3v31Ev();
extern void _ZN9S249C6_nt3v32Ev();
extern void _ZN9S249C6_nt3v33Ev();
extern void _ZN9S249C6_nt3v34Ev();
extern void _ZN9S249C6_nt3v35Ev();
extern void _ZN9S249C6_nt3v36Ev();
extern void _ZN9S249C6_nt3v37Ev();
extern void _ZN9S249C6_nt3v38Ev();
extern void _ZN9S249C6_nt3v39Ev();
extern void _ZN9S249C6_nt3v40Ev();
extern void _ZN9S249C6_nt3v41Ev();
extern void _ZN9S249C6_nt3v42Ev();
extern void _ZN9S249C6_nt3v43Ev();
extern void _ZN9S249C6_nt3v44Ev();
extern void _ZN9S249C6_nt3v45Ev();
extern void _ZN9S249C6_nt3v46Ev();
extern void _ZN9S249C6_nt3v47Ev();
extern void _ZN9S249C6_nt3v48Ev();
extern void _ZN9S249C6_nt3v49Ev();
extern void _ZN9S249C6_nt3v50Ev();
extern void _ZN9S249C6_nt3v51Ev();
extern void _ZN9S249C6_nt3v52Ev();
extern void _ZN9S249C6_nt3v53Ev();
extern void _ZN9S249C6_nt3v54Ev();
extern void _ZN9S249C6_nt3v55Ev();
extern void _ZN9S249C6_nt3v56Ev();
extern void _ZN9S249C6_nt3v57Ev();
extern void _ZN9S249C6_nt3v58Ev();
extern void _ZN9S249C6_nt3v59Ev();
extern void _ZN9S249C6_nt3v60Ev();
extern void _ZN9S249C6_nt3v61Ev();
extern void _ZN9S249C6_nt3v62Ev();
extern void _ZN9S249C6_nt3v63Ev();
extern void _ZN9S249C6_nt3v64Ev();
extern void _ZN9S249C6_nt3v65Ev();
extern void _ZN9S249C6_nt3v66Ev();
extern void _ZN9S249C6_nt3v67Ev();
extern void _ZN9S249C6_nt3v68Ev();
extern void _ZN9S249C5_nt3v69Ev();
extern void _ZN9S249C5_nt3v70Ev();
extern void _ZN9S249C4_nt3v71Ev();
extern void _ZN9S249C4_nt3v72Ev();
extern void _ZN9S249C4_nt3v73Ev();
extern void _ZN9S249C4_nt3v74Ev();
extern void _ZN9S249C4_nt3v75Ev();
extern void _ZN9S249C4_nt3v76Ev();
extern void _ZN9S249C4_nt3v77Ev();
extern void _ZN9S249C4_nt3v78Ev();
extern void _ZN9S249C4_nt3v79Ev();
extern void _ZN9S249C4_nt3v80Ev();
extern void _ZN9S249C4_nt3v81Ev();
extern void _ZN9S249C4_nt3v82Ev();
extern void _ZN9S249C4_nt3v83Ev();
extern void _ZN9S249C4_nt3v84Ev();
extern void _ZN9S249C4_nt3v85Ev();
extern void _ZN9S249C4_nt3v86Ev();
extern void _ZN9S249C4_nt3v87Ev();
extern void _ZN9S249C4_nt3v88Ev();
extern void _ZN9S249C4_nt3v89Ev();
extern void _ZN9S249C4_nt3v90Ev();
extern void _ZN9S249C4_nt3v91Ev();
extern void _ZN9S249C4_nt3v92Ev();
extern void _ZN9S249C4_nt3v93Ev();
extern void _ZN9S249C4_nt3v94Ev();
extern void _ZN9S249C4_nt3v95Ev();
extern void _ZN9S249C4_nt3v96Ev();
extern void _ZN9S249C4_nt3v97Ev();
extern void _ZN9S249C4_nt3v98Ev();
extern void _ZN9S249C4_nt3v99Ev();
extern void _ZN9S249C4_nt4v100Ev();
extern void _ZN9S249C4_nt4v101Ev();
extern void _ZN9S249C4_nt4v102Ev();
extern void _ZN9S249C4_nt4v103Ev();
extern void _ZN9S249C4_nt4v104Ev();
extern void _ZN9S249C4_nt4v105Ev();
extern void _ZN9S249C4_nt4v106Ev();
extern void _ZN9S249C4_nt4v107Ev();
extern void _ZN9S249C4_nt4v108Ev();
extern void _ZN9S249C4_nt4v109Ev();
extern void _ZN9S249C4_nt4v110Ev();
extern void _ZN9S249C4_nt4v111Ev();
extern void _ZN9S249C4_nt4v112Ev();
extern void _ZN9S249C4_nt4v113Ev();
extern void _ZN9S249C4_nt4v114Ev();
extern void _ZN9S249C4_nt4v115Ev();
extern void _ZN9S249C4_nt4v116Ev();
extern void _ZN9S249C4_nt4v117Ev();
extern void _ZN9S249C4_nt4v118Ev();
extern void _ZN9S249C4_nt4v119Ev();
extern void _ZN9S249C4_nt4v120Ev();
extern void _ZN9S249C4_nt4v121Ev();
extern void _ZN9S249C4_nt4v122Ev();
extern void _ZN9S249C4_nt4v123Ev();
extern void _ZN9S249C4_nt4v124Ev();
extern void _ZN9S249C4_nt4v125Ev();
extern void _ZN9S249C4_nt4v126Ev();
extern void _ZN9S249C4_nt4v127Ev();
extern void _ZN9S249C4_nt4v128Ev();
extern void _ZN9S249C4_nt4v129Ev();
extern void _ZN9S249C4_nt4v130Ev();
extern void _ZN9S249C4_nt4v131Ev();
extern void _ZN9S249C4_nt4v132Ev();
extern void _ZN9S249C4_nt4v133Ev();
extern void _ZN9S249C4_nt4v134Ev();
extern void _ZN9S249C4_nt4v135Ev();
extern void _ZN9S249C4_nt4v136Ev();
extern void _ZN9S249C4_nt4v137Ev();
extern void _ZN9S249C4_nt4v138Ev();
extern void _ZN9S249C4_nt4v139Ev();
extern void _ZN9S249C4_nt4v140Ev();
extern void _ZN9S249C4_nt4v141Ev();
extern void _ZN9S249C4_nt4v142Ev();
extern void _ZN9S249C4_nt4v143Ev();
extern void _ZN9S249C4_nt4v144Ev();
extern void _ZN9S249C4_nt4v145Ev();
extern void _ZN9S249C4_nt4v146Ev();
extern void _ZN9S249C3_nt4v147Ev();
extern void _ZN9S249C3_nt4v148Ev();
extern void _ZN9S249C3_nt4v149Ev();
extern void _ZN9S249C3_nt4v150Ev();
extern void _ZN9S249C3_nt4v151Ev();
extern void _ZN9S249C3_nt4v152Ev();
extern void _ZN9S249C3_nt4v153Ev();
extern void _ZN9S249C3_nt4v154Ev();
extern void _ZN9S249C3_nt4v155Ev();
extern void _ZN9S249C3_nt4v156Ev();
extern void _ZN9S249C3_nt4v157Ev();
extern void _ZN9S249C3_nt4v158Ev();
extern void _ZN9S249C3_nt4v159Ev();
extern void _ZN9S249C3_nt4v160Ev();
extern void _ZN9S249C3_nt4v161Ev();
extern void _ZN9S249C3_nt4v162Ev();
extern void _ZN9S249C3_nt4v163Ev();
extern void _ZN9S249C3_nt4v164Ev();
extern void _ZN9S249C3_nt4v165Ev();
extern void _ZN9S249C3_nt4v166Ev();
extern void _ZN9S249C3_nt4v167Ev();
extern void _ZN9S249C3_nt4v168Ev();
extern void _ZN9S249C3_nt4v169Ev();
extern void _ZN9S249C3_nt4v170Ev();
extern void _ZN9S249C3_nt4v171Ev();
extern void _ZN9S249C3_nt4v172Ev();
extern void _ZN9S249C3_nt4v173Ev();
extern void _ZN9S249C3_nt4v174Ev();
extern void _ZN9S249C3_nt4v175Ev();
extern void _ZN9S249C3_nt4v176Ev();
extern void _ZN9S249C3_nt4v177Ev();
extern void _ZN9S249C3_nt4v178Ev();
extern void _ZN9S249C3_nt4v179Ev();
extern void _ZN9S249C3_nt4v180Ev();
extern void _ZN9S249C3_nt4v181Ev();
extern void _ZN9S249C3_nt4v182Ev();
extern void _ZN9S249C3_nt4v183Ev();
extern void _ZN9S249C3_nt4v184Ev();
extern void _ZN9S249C3_nt4v185Ev();
extern void _ZN9S249C3_nt4v186Ev();
extern void _ZN9S249C3_nt4v187Ev();
extern void _ZN9S249C3_nt4v188Ev();
extern void _ZN9S249C3_nt4v189Ev();
extern void _ZN9S249C3_nt4v190Ev();
extern void _ZN9S249C3_nt4v191Ev();
extern void _ZN9S249C3_nt4v192Ev();
extern void _ZN9S249C3_nt4v193Ev();
extern void _ZN9S249C3_nt4v194Ev();
extern void _ZN9S249C3_nt4v195Ev();
extern void _ZN9S249C3_nt4v196Ev();
extern void _ZN9S249C3_nt4v197Ev();
extern void _ZN9S249C3_nt4v198Ev();
extern void _ZN9S249C3_nt4v199Ev();
extern void _ZN9S249C3_nt4v200Ev();
extern void _ZN9S249C3_nt4v201Ev();
extern void _ZN9S249C3_nt4v202Ev();
extern void _ZN9S249C3_nt4v203Ev();
extern void _ZN9S249C3_nt4v204Ev();
extern void _ZN9S249C3_nt4v205Ev();
extern void _ZN9S249C3_nt4v206Ev();
extern void _ZN9S249C3_nt4v207Ev();
extern void _ZN9S249C3_nt4v208Ev();
extern void _ZN9S249C3_nt4v209Ev();
extern void _ZN9S249C3_nt4v210Ev();
extern void _ZN9S249C3_nt4v211Ev();
extern void _ZN9S249C3_nt4v212Ev();
extern void _ZN9S249C3_nt4v213Ev();
extern void _ZN9S249C3_nt4v214Ev();
extern void _ZN9S249C3_nt4v215Ev();
extern void _ZN6S249C24v216Ev();
extern void _ZN6S249C24v217Ev();
extern void _ZN6S249C24v218Ev();
extern void _ZN6S249C24v219Ev();
extern void _ZN6S249C12v1Ev();
extern void _ZN6S249C12v2Ev();
extern void _ZN6S249C12v3Ev();
extern void _ZN6S249C12v4Ev();
static  VTBL_ENTRY vtc_S249C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S249C1[0]),
  (VTBL_ENTRY)&_ZN6S249C1D1Ev,
  (VTBL_ENTRY)&_ZN6S249C1D0Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S249C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S249C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S249C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S249C4_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v211Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v212Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v213Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v214Ev,
  (VTBL_ENTRY)&_ZN9S249C3_nt4v215Ev,
  (VTBL_ENTRY)&_ZN6S249C24v216Ev,
  (VTBL_ENTRY)&_ZN6S249C24v217Ev,
  (VTBL_ENTRY)&_ZN6S249C24v218Ev,
  (VTBL_ENTRY)&_ZN6S249C24v219Ev,
  (VTBL_ENTRY)&_ZN6S249C12v1Ev,
  (VTBL_ENTRY)&_ZN6S249C12v2Ev,
  (VTBL_ENTRY)&_ZN6S249C12v3Ev,
  (VTBL_ENTRY)&_ZN6S249C12v4Ev,
};
extern VTBL_ENTRY _ZTI6S249C1[];
extern  VTBL_ENTRY _ZTV6S249C1[];
Class_Descriptor cd_S249C1 = {  "S249C1", // class name
  bases_S249C1, 5,
  &(vtc_S249C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1304,964), // object size
  NSPAIRA(_ZTI6S249C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S249C1),223, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2407C8_nt  {
  void  mf2407c8(); // _ZN10S2407C8_nt8mf2407c8Ev
};
//SIG(-1 S2407C8_nt) C1{ m}


void  S2407C8_nt ::mf2407c8(){}

//skip512 S2407C8_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S2407C8_nt[];
VTBL_ENTRY *P__ZTI10S2407C8_nt = _ZTI10S2407C8_nt; 
Class_Descriptor cd_S2407C8_nt = {  "S2407C8_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI10S2407C8_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2407C6_nt  {
  void *s2407c6f0;
  int s2407c6f1;
  ::S249C31_nt s2407c6f2;
  ::S2407C8_nt s2407c6f3;
  void  mf2407c6(); // _ZN10S2407C6_nt8mf2407c6Ev
};
//SIG(-1 S2407C6_nt) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S2407C6_nt ::mf2407c6(){}

//skip512 S2407C6_nt

#else // __cplusplus

Class_Descriptor cd_S2407C6_nt = {  "S2407C6_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2407C5_nt  : S2407C6_nt {
};
//SIG(-1 S2407C5_nt) C1{ BC2{ m Fp Fi FC3{ m} FC4{ m}}}



//skip512 S2407C5_nt

#else // __cplusplus

extern Class_Descriptor cd_S2407C6_nt;
static Base_Class bases_S2407C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2407C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2407C4_nt  {
  void *s2407c4f0;
  int s2407c4f1;
  ::S2407C5_nt s2407c4f2;
  ::S2407C5_nt s2407c4f3;
  int s2407c4f4;
  virtual  ~S2407C4_nt(); // _ZN10S2407C4_ntD1Ev
  virtual void  v6(); // _ZN10S2407C4_nt2v6Ev
  virtual void  v7(); // _ZN10S2407C4_nt2v7Ev
  virtual void  v8(); // _ZN10S2407C4_nt2v8Ev
  virtual void  v9(); // _ZN10S2407C4_nt2v9Ev
  virtual void  v10(); // _ZN10S2407C4_nt3v10Ev
  virtual void  v11(); // _ZN10S2407C4_nt3v11Ev
  virtual void  v12(); // _ZN10S2407C4_nt3v12Ev
  virtual void  v13(); // _ZN10S2407C4_nt3v13Ev
  virtual void  v14(); // _ZN10S2407C4_nt3v14Ev
  virtual void  v15(); // _ZN10S2407C4_nt3v15Ev
  virtual void  v16(); // _ZN10S2407C4_nt3v16Ev
  virtual void  v17(); // _ZN10S2407C4_nt3v17Ev
  virtual void  v18(); // _ZN10S2407C4_nt3v18Ev
  virtual void  v19(); // _ZN10S2407C4_nt3v19Ev
  virtual void  v20(); // _ZN10S2407C4_nt3v20Ev
  virtual void  v21(); // _ZN10S2407C4_nt3v21Ev
  virtual void  v22(); // _ZN10S2407C4_nt3v22Ev
  virtual void  v23(); // _ZN10S2407C4_nt3v23Ev
  virtual void  v24(); // _ZN10S2407C4_nt3v24Ev
  virtual void  v25(); // _ZN10S2407C4_nt3v25Ev
  virtual void  v26(); // _ZN10S2407C4_nt3v26Ev
  virtual void  v27(); // _ZN10S2407C4_nt3v27Ev
  virtual void  v28(); // _ZN10S2407C4_nt3v28Ev
  S2407C4_nt(); // tgen
};
//SIG(-1 S2407C4_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC2{ BC3{ m Fp Fi FC4{ m} FC5{ m}}} FC2 Fi}


 S2407C4_nt ::~S2407C4_nt(){ note_dtor("S2407C4_nt", this);}
void  S2407C4_nt ::v6(){vfunc_called(this, "_ZN10S2407C4_nt2v6Ev");}
void  S2407C4_nt ::v7(){vfunc_called(this, "_ZN10S2407C4_nt2v7Ev");}
void  S2407C4_nt ::v8(){vfunc_called(this, "_ZN10S2407C4_nt2v8Ev");}
void  S2407C4_nt ::v9(){vfunc_called(this, "_ZN10S2407C4_nt2v9Ev");}
void  S2407C4_nt ::v10(){vfunc_called(this, "_ZN10S2407C4_nt3v10Ev");}
void  S2407C4_nt ::v11(){vfunc_called(this, "_ZN10S2407C4_nt3v11Ev");}
void  S2407C4_nt ::v12(){vfunc_called(this, "_ZN10S2407C4_nt3v12Ev");}
void  S2407C4_nt ::v13(){vfunc_called(this, "_ZN10S2407C4_nt3v13Ev");}
void  S2407C4_nt ::v14(){vfunc_called(this, "_ZN10S2407C4_nt3v14Ev");}
void  S2407C4_nt ::v15(){vfunc_called(this, "_ZN10S2407C4_nt3v15Ev");}
void  S2407C4_nt ::v16(){vfunc_called(this, "_ZN10S2407C4_nt3v16Ev");}
void  S2407C4_nt ::v17(){vfunc_called(this, "_ZN10S2407C4_nt3v17Ev");}
void  S2407C4_nt ::v18(){vfunc_called(this, "_ZN10S2407C4_nt3v18Ev");}
void  S2407C4_nt ::v19(){vfunc_called(this, "_ZN10S2407C4_nt3v19Ev");}
void  S2407C4_nt ::v20(){vfunc_called(this, "_ZN10S2407C4_nt3v20Ev");}
void  S2407C4_nt ::v21(){vfunc_called(this, "_ZN10S2407C4_nt3v21Ev");}
void  S2407C4_nt ::v22(){vfunc_called(this, "_ZN10S2407C4_nt3v22Ev");}
void  S2407C4_nt ::v23(){vfunc_called(this, "_ZN10S2407C4_nt3v23Ev");}
void  S2407C4_nt ::v24(){vfunc_called(this, "_ZN10S2407C4_nt3v24Ev");}
void  S2407C4_nt ::v25(){vfunc_called(this, "_ZN10S2407C4_nt3v25Ev");}
void  S2407C4_nt ::v26(){vfunc_called(this, "_ZN10S2407C4_nt3v26Ev");}
void  S2407C4_nt ::v27(){vfunc_called(this, "_ZN10S2407C4_nt3v27Ev");}
void  S2407C4_nt ::v28(){vfunc_called(this, "_ZN10S2407C4_nt3v28Ev");}
S2407C4_nt ::S2407C4_nt(){ note_ctor("S2407C4_nt", this);} // tgen

//skip512 S2407C4_nt

#else // __cplusplus

extern void _ZN10S2407C4_ntC1Ev();
extern void _ZN10S2407C4_ntD1Ev();
Name_Map name_map_S2407C4_nt[] = {
  NSPAIR(_ZN10S2407C4_ntC1Ev),
  NSPAIR(_ZN10S2407C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S2407C4_nt[];
extern void _ZN10S2407C4_ntD1Ev();
extern void _ZN10S2407C4_ntD0Ev();
extern void _ZN10S2407C4_nt2v6Ev();
extern void _ZN10S2407C4_nt2v7Ev();
extern void _ZN10S2407C4_nt2v8Ev();
extern void _ZN10S2407C4_nt2v9Ev();
extern void _ZN10S2407C4_nt3v10Ev();
extern void _ZN10S2407C4_nt3v11Ev();
extern void _ZN10S2407C4_nt3v12Ev();
extern void _ZN10S2407C4_nt3v13Ev();
extern void _ZN10S2407C4_nt3v14Ev();
extern void _ZN10S2407C4_nt3v15Ev();
extern void _ZN10S2407C4_nt3v16Ev();
extern void _ZN10S2407C4_nt3v17Ev();
extern void _ZN10S2407C4_nt3v18Ev();
extern void _ZN10S2407C4_nt3v19Ev();
extern void _ZN10S2407C4_nt3v20Ev();
extern void _ZN10S2407C4_nt3v21Ev();
extern void _ZN10S2407C4_nt3v22Ev();
extern void _ZN10S2407C4_nt3v23Ev();
extern void _ZN10S2407C4_nt3v24Ev();
extern void _ZN10S2407C4_nt3v25Ev();
extern void _ZN10S2407C4_nt3v26Ev();
extern void _ZN10S2407C4_nt3v27Ev();
extern void _ZN10S2407C4_nt3v28Ev();
static  VTBL_ENTRY vtc_S2407C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2407C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S2407C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v28Ev,
};
extern VTBL_ENTRY _ZTI10S2407C4_nt[];
VTBL_ENTRY *P__ZTI10S2407C4_nt = _ZTI10S2407C4_nt; 
extern  VTBL_ENTRY _ZTV10S2407C4_nt[];
Class_Descriptor cd_S2407C4_nt = {  "S2407C4_nt", // class name
  0,0,//no base classes
  &(vtc_S2407C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI10S2407C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S2407C4_nt),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2407C14_nt  {
  __tsi64 s2407c14f0[2];
  void  mf2407c14(); // _ZN11S2407C14_nt9mf2407c14Ev
};
//SIG(-1 S2407C14_nt) C1{ m FL[2]}


void  S2407C14_nt ::mf2407c14(){}

//skip512 S2407C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2407C13_nt  {
  ::S2407C14_nt s2407c13f0;
  void  mf2407c13(); // _ZN11S2407C13_nt9mf2407c13Ev
};
//SIG(-1 S2407C13_nt) C1{ m FC2{ m FL[2]}}


void  S2407C13_nt ::mf2407c13(){}

//skip512 S2407C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2407C17_nt  {
  ::S2407C13_nt s2407c17f0;
  void  mf2407c17(); // _ZN11S2407C17_nt9mf2407c17Ev
};
//SIG(-1 S2407C17_nt) C1{ m FC2{ m FC3{ m FL[2]}}}


void  S2407C17_nt ::mf2407c17(){}

//skip512 S2407C17_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2407C18_nt  {
  ::S2407C13_nt s2407c18f0;
  ::S2407C13_nt s2407c18f1;
  ::S2407C13_nt s2407c18f2;
  ::S2407C13_nt s2407c18f3;
  void  mf2407c18(); // _ZN11S2407C18_nt9mf2407c18Ev
};
//SIG(-1 S2407C18_nt) C1{ m FC2{ m FC3{ m FL[2]}} FC2 FC2 FC2}


void  S2407C18_nt ::mf2407c18(){}

//skip512 S2407C18_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2407C20_nt  {
  void *s2407c20f0;
  int s2407c20f1;
  ::S2407C8_nt s2407c20f2;
  void  mf2407c20(); // _ZN11S2407C20_nt9mf2407c20Ev
};
//SIG(-1 S2407C20_nt) C1{ m Fp Fi FC2{ m}}


void  S2407C20_nt ::mf2407c20(){}

//skip512 S2407C20_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2407C19_nt  {
  ::S2407C20_nt s2407c19f0;
  int s2407c19f1;
  void  mf2407c19(); // _ZN11S2407C19_nt9mf2407c19Ev
};
//SIG(-1 S2407C19_nt) C1{ m FC2{ m Fp Fi FC3{ m}} Fi}


void  S2407C19_nt ::mf2407c19(){}

//skip512 S2407C19_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2407C23  {
  void  mf2407c23(); // _ZN8S2407C239mf2407c23Ev
};
//SIG(-1 S2407C23) C1{ m}


void  S2407C23 ::mf2407c23(){}

static void Test_S2407C23()
{
  {
    init_simple_test("S2407C23");
    S2407C23 lv;
    check2(sizeof(lv), 1, "sizeof(S2407C23)");
    check2(__alignof__(lv), 1, "__alignof__(S2407C23)");
  }
}
static Arrange_To_Call_Me vS2407C23(Test_S2407C23, "S2407C23", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S2407C23[];
VTBL_ENTRY *P__ZTI8S2407C23 = _ZTI8S2407C23; 
Class_Descriptor cd_S2407C23 = {  "S2407C23", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S2407C23),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2407C22  {
  void *s2407c22f0;
  int s2407c22f1;
  ::S2407C23 s2407c22f2;
  ::S2407C23 s2407c22f3;
  void  mf2407c22(); // _ZN8S2407C229mf2407c22Ev
};
//SIG(-1 S2407C22) C1{ m Fp Fi FC2{ m} FC2}


void  S2407C22 ::mf2407c22(){}

static void Test_S2407C22()
{
  {
    init_simple_test("S2407C22");
    S2407C22 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2407C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2407C22)");
    check_field_offset(lv, s2407c22f0, 0, "S2407C22.s2407c22f0");
    check_field_offset(lv, s2407c22f1, ABISELECT(8,4), "S2407C22.s2407c22f1");
    check_field_offset(lv, s2407c22f2, ABISELECT(12,8), "S2407C22.s2407c22f2");
    check_field_offset(lv, s2407c22f3, ABISELECT(13,9), "S2407C22.s2407c22f3");
  }
}
static Arrange_To_Call_Me vS2407C22(Test_S2407C22, "S2407C22", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2407C27  {
  void  mf2407c27(); // _ZN8S2407C279mf2407c27Ev
};
//SIG(-1 S2407C27) C1{ m}


void  S2407C27 ::mf2407c27(){}

static void Test_S2407C27()
{
  {
    init_simple_test("S2407C27");
    S2407C27 lv;
    check2(sizeof(lv), 1, "sizeof(S2407C27)");
    check2(__alignof__(lv), 1, "__alignof__(S2407C27)");
  }
}
static Arrange_To_Call_Me vS2407C27(Test_S2407C27, "S2407C27", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S2407C27[];
VTBL_ENTRY *P__ZTI8S2407C27 = _ZTI8S2407C27; 
Class_Descriptor cd_S2407C27 = {  "S2407C27", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S2407C27),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2407C26  {
  void *s2407c26f0;
  int s2407c26f1;
  ::S2407C27 s2407c26f2;
  ::S2407C27 s2407c26f3;
  void  mf2407c26(); // _ZN8S2407C269mf2407c26Ev
};
//SIG(-1 S2407C26) C1{ m Fp Fi FC2{ m} FC2}


void  S2407C26 ::mf2407c26(){}

static void Test_S2407C26()
{
  {
    init_simple_test("S2407C26");
    S2407C26 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2407C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2407C26)");
    check_field_offset(lv, s2407c26f0, 0, "S2407C26.s2407c26f0");
    check_field_offset(lv, s2407c26f1, ABISELECT(8,4), "S2407C26.s2407c26f1");
    check_field_offset(lv, s2407c26f2, ABISELECT(12,8), "S2407C26.s2407c26f2");
    check_field_offset(lv, s2407c26f3, ABISELECT(13,9), "S2407C26.s2407c26f3");
  }
}
static Arrange_To_Call_Me vS2407C26(Test_S2407C26, "S2407C26", ABISELECT(16,12));

#else // __cplusplus

Class_Descriptor cd_S2407C26 = {  "S2407C26", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2407C25  : S2407C26 {
};
//SIG(-1 S2407C25) C1{ BC2{ m Fp Fi FC3{ m} FC3}}



static void Test_S2407C25()
{
  extern Class_Descriptor cd_S2407C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S2407C25, buf);
    S2407C25 &lv = *(new (buf) S2407C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2407C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2407C25)");
    check_base_class_offset(lv, (S2407C26*), 0, "S2407C25");
    test_class_info(&lv, &cd_S2407C25);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2407C25(Test_S2407C25, "S2407C25", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S2407C26;
static Base_Class bases_S2407C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2407C26,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S2407C25 = {  "S2407C25", // class name
  bases_S2407C25, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2407C30  {
  void  mf2407c30(); // _ZN8S2407C309mf2407c30Ev
};
//SIG(-1 S2407C30) C1{ m}


void  S2407C30 ::mf2407c30(){}

static void Test_S2407C30()
{
  {
    init_simple_test("S2407C30");
    S2407C30 lv;
    check2(sizeof(lv), 1, "sizeof(S2407C30)");
    check2(__alignof__(lv), 1, "__alignof__(S2407C30)");
  }
}
static Arrange_To_Call_Me vS2407C30(Test_S2407C30, "S2407C30", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S2407C30[];
VTBL_ENTRY *P__ZTI8S2407C30 = _ZTI8S2407C30; 
Class_Descriptor cd_S2407C30 = {  "S2407C30", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S2407C30),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2407C29_nt  {
  void *s2407c29f0;
  int s2407c29f1[2];
  ::S2407C30 s2407c29f2;
  void  mf2407c29(); // _ZN11S2407C29_nt9mf2407c29Ev
};
//SIG(-1 S2407C29_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S2407C29_nt ::mf2407c29(){}

//skip512 S2407C29_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2407C37  {
  void *s2407c37f0;
  int s2407c37f1[2];
  ::S2407C30 s2407c37f2;
  void  mf2407c37(); // _ZN8S2407C379mf2407c37Ev
};
//SIG(-1 S2407C37) C1{ m Fp Fi[2] FC2{ m}}


void  S2407C37 ::mf2407c37(){}

static void Test_S2407C37()
{
  {
    init_simple_test("S2407C37");
    S2407C37 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S2407C37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2407C37)");
    check_field_offset(lv, s2407c37f0, 0, "S2407C37.s2407c37f0");
    check_field_offset(lv, s2407c37f1, ABISELECT(8,4), "S2407C37.s2407c37f1");
    check_field_offset(lv, s2407c37f2, ABISELECT(16,12), "S2407C37.s2407c37f2");
  }
}
static Arrange_To_Call_Me vS2407C37(Test_S2407C37, "S2407C37", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2407C3_nt  : S2407C4_nt {
  ::S2407C13_nt s2407c3f0;
  ::S2407C13_nt s2407c3f1;
  ::S2407C13_nt s2407c3f2;
  ::S2407C13_nt s2407c3f3;
  ::S2407C17_nt s2407c3f4;
  ::S2407C18_nt s2407c3f5;
  ::S2407C18_nt s2407c3f6;
  ::S2407C13_nt s2407c3f7;
  ::S2407C13_nt s2407c3f8;
  ::S2407C13_nt s2407c3f9;
  void *s2407c3f10;
  ::S2407C17_nt s2407c3f11;
  ::S2407C19_nt s2407c3f12;
  int s2407c3f13;
  void *s2407c3f14[7];
  ::S2407C22 s2407c3f15;
  int s2407c3f16:8;
  int s2407c3f17:8;
  int s2407c3f18:16;
  int s2407c3f19:16;
  int s2407c3f20:8;
  int s2407c3f21:8;
  int s2407c3f22:8;
  int s2407c3f23:32;
  int s2407c3f24:8;
  int s2407c3f25:4;
  int s2407c3f26:4;
  int s2407c3f27:4;
  int s2407c3f28:4;
  int s2407c3f29:4;
  int s2407c3f30:4;
  int s2407c3f31:4;
  int s2407c3f32:4;
  int s2407c3f33:4;
  int s2407c3f34:4;
  unsigned char s2407c3f35:1;
  unsigned char s2407c3f36:1;
  unsigned char s2407c3f37:1;
  unsigned char s2407c3f38:1;
  unsigned char s2407c3f39:1;
  unsigned char s2407c3f40:1;
  unsigned char s2407c3f41:1;
  unsigned char s2407c3f42:1;
  unsigned char s2407c3f43:1;
  unsigned char s2407c3f44:1;
  unsigned char s2407c3f45:1;
  unsigned char s2407c3f46:1;
  unsigned char s2407c3f47:1;
  unsigned char s2407c3f48:1;
  unsigned char s2407c3f49:1;
  unsigned char s2407c3f50:1;
  unsigned char s2407c3f51:1;
  unsigned char s2407c3f52:1;
  unsigned char s2407c3f53:1;
  unsigned char s2407c3f54:1;
  unsigned char s2407c3f55:1;
  unsigned char s2407c3f56:1;
  unsigned char s2407c3f57:1;
  unsigned char s2407c3f58:1;
  unsigned char s2407c3f59:1;
  unsigned char s2407c3f60:1;
  unsigned char s2407c3f61:1;
  unsigned char s2407c3f62:1;
  unsigned char s2407c3f63:1;
  unsigned char s2407c3f64:1;
  unsigned char s2407c3f65:1;
  unsigned char s2407c3f66:1;
  unsigned char s2407c3f67:1;
  unsigned char s2407c3f68:1;
  unsigned char s2407c3f69:1;
  unsigned char s2407c3f70:1;
  unsigned char s2407c3f71:1;
  unsigned char s2407c3f72:1;
  unsigned char s2407c3f73:1;
  unsigned char s2407c3f74:1;
  unsigned char s2407c3f75:1;
  int s2407c3f76[7];
  void *s2407c3f77[6];
  int s2407c3f78:8;
  int s2407c3f79:8;
  int s2407c3f80:8;
  int s2407c3f81:8;
  int s2407c3f82:8;
  int s2407c3f83:8;
  ::S2407C25 s2407c3f84;
  void *s2407c3f85[4];
  int s2407c3f86:8;
  int s2407c3f87:8;
  int s2407c3f88:8;
  int s2407c3f89:8;
  int s2407c3f90:8;
  int s2407c3f91:16;
  int s2407c3f92:16;
  int s2407c3f93:16;
  int s2407c3f94:4;
  int s2407c3f95:4;
  int s2407c3f96:4;
  int s2407c3f97:4;
  int s2407c3f98:4;
  int s2407c3f99:4;
  int s2407c3f100:4;
  int s2407c3f101:4;
  int s2407c3f102:4;
  int s2407c3f103:4;
  int s2407c3f104:4;
  int s2407c3f105:4;
  int s2407c3f106:8;
  int s2407c3f107:8;
  int s2407c3f108:8;
  void *s2407c3f109[7];
  ::S2407C29_nt s2407c3f110;
  void *s2407c3f111[2];
  int s2407c3f112:16;
  int s2407c3f113:16;
  ::S2407C25 s2407c3f114;
  ::S2407C29_nt s2407c3f115;
  ::S2407C37 s2407c3f116;
  void *s2407c3f117[2];
  int s2407c3f118:24;
  int s2407c3f119:8;
  void *s2407c3f120;
  virtual  ~S2407C3_nt(); // _ZN10S2407C3_ntD1Ev
  virtual void  v29(); // _ZN10S2407C3_nt3v29Ev
  virtual void  v30(); // _ZN10S2407C3_nt3v30Ev
  virtual void  v31(); // _ZN10S2407C3_nt3v31Ev
  virtual void  v32(); // _ZN10S2407C3_nt3v32Ev
  virtual void  v33(); // _ZN10S2407C3_nt3v33Ev
  virtual void  v34(); // _ZN10S2407C3_nt3v34Ev
  virtual void  v35(); // _ZN10S2407C3_nt3v35Ev
  virtual void  v36(); // _ZN10S2407C3_nt3v36Ev
  virtual void  v37(); // _ZN10S2407C3_nt3v37Ev
  virtual void  v38(); // _ZN10S2407C3_nt3v38Ev
  virtual void  v39(); // _ZN10S2407C3_nt3v39Ev
  virtual void  v40(); // _ZN10S2407C3_nt3v40Ev
  virtual void  v41(); // _ZN10S2407C3_nt3v41Ev
  virtual void  v42(); // _ZN10S2407C3_nt3v42Ev
  virtual void  v43(); // _ZN10S2407C3_nt3v43Ev
  virtual void  v44(); // _ZN10S2407C3_nt3v44Ev
  virtual void  v45(); // _ZN10S2407C3_nt3v45Ev
  virtual void  v46(); // _ZN10S2407C3_nt3v46Ev
  virtual void  v47(); // _ZN10S2407C3_nt3v47Ev
  virtual void  v48(); // _ZN10S2407C3_nt3v48Ev
  virtual void  v49(); // _ZN10S2407C3_nt3v49Ev
  virtual void  v50(); // _ZN10S2407C3_nt3v50Ev
  virtual void  v51(); // _ZN10S2407C3_nt3v51Ev
  virtual void  v52(); // _ZN10S2407C3_nt3v52Ev
  virtual void  v53(); // _ZN10S2407C3_nt3v53Ev
  virtual void  v54(); // _ZN10S2407C3_nt3v54Ev
  virtual void  v55(); // _ZN10S2407C3_nt3v55Ev
  virtual void  v56(); // _ZN10S2407C3_nt3v56Ev
  virtual void  v57(); // _ZN10S2407C3_nt3v57Ev
  virtual void  v58(); // _ZN10S2407C3_nt3v58Ev
  virtual void  v59(); // _ZN10S2407C3_nt3v59Ev
  virtual void  v60(); // _ZN10S2407C3_nt3v60Ev
  virtual void  v61(); // _ZN10S2407C3_nt3v61Ev
  virtual void  v62(); // _ZN10S2407C3_nt3v62Ev
  virtual void  v63(); // _ZN10S2407C3_nt3v63Ev
  virtual void  v64(); // _ZN10S2407C3_nt3v64Ev
  virtual void  v65(); // _ZN10S2407C3_nt3v65Ev
  virtual void  v66(); // _ZN10S2407C3_nt3v66Ev
  virtual void  v67(); // _ZN10S2407C3_nt3v67Ev
  virtual void  v68(); // _ZN10S2407C3_nt3v68Ev
  virtual void  v69(); // _ZN10S2407C3_nt3v69Ev
  virtual void  v70(); // _ZN10S2407C3_nt3v70Ev
  virtual void  v71(); // _ZN10S2407C3_nt3v71Ev
  virtual void  v72(); // _ZN10S2407C3_nt3v72Ev
  virtual void  v73(); // _ZN10S2407C3_nt3v73Ev
  virtual void  v74(); // _ZN10S2407C3_nt3v74Ev
  virtual void  v75(); // _ZN10S2407C3_nt3v75Ev
  virtual void  v76(); // _ZN10S2407C3_nt3v76Ev
  virtual void  v77(); // _ZN10S2407C3_nt3v77Ev
  virtual void  v78(); // _ZN10S2407C3_nt3v78Ev
  virtual void  v79(); // _ZN10S2407C3_nt3v79Ev
  virtual void  v80(); // _ZN10S2407C3_nt3v80Ev
  virtual void  v81(); // _ZN10S2407C3_nt3v81Ev
  virtual void  v82(); // _ZN10S2407C3_nt3v82Ev
  virtual void  v83(); // _ZN10S2407C3_nt3v83Ev
  virtual void  v84(); // _ZN10S2407C3_nt3v84Ev
  virtual void  v85(); // _ZN10S2407C3_nt3v85Ev
  virtual void  v86(); // _ZN10S2407C3_nt3v86Ev
  virtual void  v87(); // _ZN10S2407C3_nt3v87Ev
  virtual void  v88(); // _ZN10S2407C3_nt3v88Ev
  virtual void  v89(); // _ZN10S2407C3_nt3v89Ev
  virtual void  v90(); // _ZN10S2407C3_nt3v90Ev
  virtual void  v91(); // _ZN10S2407C3_nt3v91Ev
  virtual void  v92(); // _ZN10S2407C3_nt3v92Ev
  virtual void  v93(); // _ZN10S2407C3_nt3v93Ev
  virtual void  v94(); // _ZN10S2407C3_nt3v94Ev
  virtual void  v95(); // _ZN10S2407C3_nt3v95Ev
  virtual void  v96(); // _ZN10S2407C3_nt3v96Ev
  virtual void  v97(); // _ZN10S2407C3_nt3v97Ev
  virtual void  v98(); // _ZN10S2407C3_nt3v98Ev
  virtual void  v99(); // _ZN10S2407C3_nt3v99Ev
  virtual void  v100(); // _ZN10S2407C3_nt4v100Ev
  virtual void  v101(); // _ZN10S2407C3_nt4v101Ev
  virtual void  v102(); // _ZN10S2407C3_nt4v102Ev
  virtual void  v103(); // _ZN10S2407C3_nt4v103Ev
  virtual void  v104(); // _ZN10S2407C3_nt4v104Ev
  virtual void  v105(); // _ZN10S2407C3_nt4v105Ev
  virtual void  v106(); // _ZN10S2407C3_nt4v106Ev
  S2407C3_nt(); // tgen
};
//SIG(-1 S2407C3_nt) C1{ BC2{ vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fp Fi FC3{ BC4{ m Fp Fi FC5{ m} FC6{ m}}} FC3 Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 FC7{ m FC8{ m FL[2]}} FC7 FC7 FC7 FC9{ m FC7} FC10{ m FC7 FC7 FC7 FC7} FC10 FC7 FC7 FC7 Fp FC9 FC11{ m FC12{ m Fp Fi FC6} Fi} Fi Fp[7] FC13{ m Fp Fi FC14{ m} FC14} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC15{ BC16{ m Fp Fi FC17{ m} FC17}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC18{ m Fp Fi[2] FC19{ m}} Fp[2] Fi:16 Fi:16 FC15 FC18 FC20{ m Fp Fi[2] FC19} Fp[2] Fi:24 Fi:8 Fp}


 S2407C3_nt ::~S2407C3_nt(){ note_dtor("S2407C3_nt", this);}
void  S2407C3_nt ::v29(){vfunc_called(this, "_ZN10S2407C3_nt3v29Ev");}
void  S2407C3_nt ::v30(){vfunc_called(this, "_ZN10S2407C3_nt3v30Ev");}
void  S2407C3_nt ::v31(){vfunc_called(this, "_ZN10S2407C3_nt3v31Ev");}
void  S2407C3_nt ::v32(){vfunc_called(this, "_ZN10S2407C3_nt3v32Ev");}
void  S2407C3_nt ::v33(){vfunc_called(this, "_ZN10S2407C3_nt3v33Ev");}
void  S2407C3_nt ::v34(){vfunc_called(this, "_ZN10S2407C3_nt3v34Ev");}
void  S2407C3_nt ::v35(){vfunc_called(this, "_ZN10S2407C3_nt3v35Ev");}
void  S2407C3_nt ::v36(){vfunc_called(this, "_ZN10S2407C3_nt3v36Ev");}
void  S2407C3_nt ::v37(){vfunc_called(this, "_ZN10S2407C3_nt3v37Ev");}
void  S2407C3_nt ::v38(){vfunc_called(this, "_ZN10S2407C3_nt3v38Ev");}
void  S2407C3_nt ::v39(){vfunc_called(this, "_ZN10S2407C3_nt3v39Ev");}
void  S2407C3_nt ::v40(){vfunc_called(this, "_ZN10S2407C3_nt3v40Ev");}
void  S2407C3_nt ::v41(){vfunc_called(this, "_ZN10S2407C3_nt3v41Ev");}
void  S2407C3_nt ::v42(){vfunc_called(this, "_ZN10S2407C3_nt3v42Ev");}
void  S2407C3_nt ::v43(){vfunc_called(this, "_ZN10S2407C3_nt3v43Ev");}
void  S2407C3_nt ::v44(){vfunc_called(this, "_ZN10S2407C3_nt3v44Ev");}
void  S2407C3_nt ::v45(){vfunc_called(this, "_ZN10S2407C3_nt3v45Ev");}
void  S2407C3_nt ::v46(){vfunc_called(this, "_ZN10S2407C3_nt3v46Ev");}
void  S2407C3_nt ::v47(){vfunc_called(this, "_ZN10S2407C3_nt3v47Ev");}
void  S2407C3_nt ::v48(){vfunc_called(this, "_ZN10S2407C3_nt3v48Ev");}
void  S2407C3_nt ::v49(){vfunc_called(this, "_ZN10S2407C3_nt3v49Ev");}
void  S2407C3_nt ::v50(){vfunc_called(this, "_ZN10S2407C3_nt3v50Ev");}
void  S2407C3_nt ::v51(){vfunc_called(this, "_ZN10S2407C3_nt3v51Ev");}
void  S2407C3_nt ::v52(){vfunc_called(this, "_ZN10S2407C3_nt3v52Ev");}
void  S2407C3_nt ::v53(){vfunc_called(this, "_ZN10S2407C3_nt3v53Ev");}
void  S2407C3_nt ::v54(){vfunc_called(this, "_ZN10S2407C3_nt3v54Ev");}
void  S2407C3_nt ::v55(){vfunc_called(this, "_ZN10S2407C3_nt3v55Ev");}
void  S2407C3_nt ::v56(){vfunc_called(this, "_ZN10S2407C3_nt3v56Ev");}
void  S2407C3_nt ::v57(){vfunc_called(this, "_ZN10S2407C3_nt3v57Ev");}
void  S2407C3_nt ::v58(){vfunc_called(this, "_ZN10S2407C3_nt3v58Ev");}
void  S2407C3_nt ::v59(){vfunc_called(this, "_ZN10S2407C3_nt3v59Ev");}
void  S2407C3_nt ::v60(){vfunc_called(this, "_ZN10S2407C3_nt3v60Ev");}
void  S2407C3_nt ::v61(){vfunc_called(this, "_ZN10S2407C3_nt3v61Ev");}
void  S2407C3_nt ::v62(){vfunc_called(this, "_ZN10S2407C3_nt3v62Ev");}
void  S2407C3_nt ::v63(){vfunc_called(this, "_ZN10S2407C3_nt3v63Ev");}
void  S2407C3_nt ::v64(){vfunc_called(this, "_ZN10S2407C3_nt3v64Ev");}
void  S2407C3_nt ::v65(){vfunc_called(this, "_ZN10S2407C3_nt3v65Ev");}
void  S2407C3_nt ::v66(){vfunc_called(this, "_ZN10S2407C3_nt3v66Ev");}
void  S2407C3_nt ::v67(){vfunc_called(this, "_ZN10S2407C3_nt3v67Ev");}
void  S2407C3_nt ::v68(){vfunc_called(this, "_ZN10S2407C3_nt3v68Ev");}
void  S2407C3_nt ::v69(){vfunc_called(this, "_ZN10S2407C3_nt3v69Ev");}
void  S2407C3_nt ::v70(){vfunc_called(this, "_ZN10S2407C3_nt3v70Ev");}
void  S2407C3_nt ::v71(){vfunc_called(this, "_ZN10S2407C3_nt3v71Ev");}
void  S2407C3_nt ::v72(){vfunc_called(this, "_ZN10S2407C3_nt3v72Ev");}
void  S2407C3_nt ::v73(){vfunc_called(this, "_ZN10S2407C3_nt3v73Ev");}
void  S2407C3_nt ::v74(){vfunc_called(this, "_ZN10S2407C3_nt3v74Ev");}
void  S2407C3_nt ::v75(){vfunc_called(this, "_ZN10S2407C3_nt3v75Ev");}
void  S2407C3_nt ::v76(){vfunc_called(this, "_ZN10S2407C3_nt3v76Ev");}
void  S2407C3_nt ::v77(){vfunc_called(this, "_ZN10S2407C3_nt3v77Ev");}
void  S2407C3_nt ::v78(){vfunc_called(this, "_ZN10S2407C3_nt3v78Ev");}
void  S2407C3_nt ::v79(){vfunc_called(this, "_ZN10S2407C3_nt3v79Ev");}
void  S2407C3_nt ::v80(){vfunc_called(this, "_ZN10S2407C3_nt3v80Ev");}
void  S2407C3_nt ::v81(){vfunc_called(this, "_ZN10S2407C3_nt3v81Ev");}
void  S2407C3_nt ::v82(){vfunc_called(this, "_ZN10S2407C3_nt3v82Ev");}
void  S2407C3_nt ::v83(){vfunc_called(this, "_ZN10S2407C3_nt3v83Ev");}
void  S2407C3_nt ::v84(){vfunc_called(this, "_ZN10S2407C3_nt3v84Ev");}
void  S2407C3_nt ::v85(){vfunc_called(this, "_ZN10S2407C3_nt3v85Ev");}
void  S2407C3_nt ::v86(){vfunc_called(this, "_ZN10S2407C3_nt3v86Ev");}
void  S2407C3_nt ::v87(){vfunc_called(this, "_ZN10S2407C3_nt3v87Ev");}
void  S2407C3_nt ::v88(){vfunc_called(this, "_ZN10S2407C3_nt3v88Ev");}
void  S2407C3_nt ::v89(){vfunc_called(this, "_ZN10S2407C3_nt3v89Ev");}
void  S2407C3_nt ::v90(){vfunc_called(this, "_ZN10S2407C3_nt3v90Ev");}
void  S2407C3_nt ::v91(){vfunc_called(this, "_ZN10S2407C3_nt3v91Ev");}
void  S2407C3_nt ::v92(){vfunc_called(this, "_ZN10S2407C3_nt3v92Ev");}
void  S2407C3_nt ::v93(){vfunc_called(this, "_ZN10S2407C3_nt3v93Ev");}
void  S2407C3_nt ::v94(){vfunc_called(this, "_ZN10S2407C3_nt3v94Ev");}
void  S2407C3_nt ::v95(){vfunc_called(this, "_ZN10S2407C3_nt3v95Ev");}
void  S2407C3_nt ::v96(){vfunc_called(this, "_ZN10S2407C3_nt3v96Ev");}
void  S2407C3_nt ::v97(){vfunc_called(this, "_ZN10S2407C3_nt3v97Ev");}
void  S2407C3_nt ::v98(){vfunc_called(this, "_ZN10S2407C3_nt3v98Ev");}
void  S2407C3_nt ::v99(){vfunc_called(this, "_ZN10S2407C3_nt3v99Ev");}
void  S2407C3_nt ::v100(){vfunc_called(this, "_ZN10S2407C3_nt4v100Ev");}
void  S2407C3_nt ::v101(){vfunc_called(this, "_ZN10S2407C3_nt4v101Ev");}
void  S2407C3_nt ::v102(){vfunc_called(this, "_ZN10S2407C3_nt4v102Ev");}
void  S2407C3_nt ::v103(){vfunc_called(this, "_ZN10S2407C3_nt4v103Ev");}
void  S2407C3_nt ::v104(){vfunc_called(this, "_ZN10S2407C3_nt4v104Ev");}
void  S2407C3_nt ::v105(){vfunc_called(this, "_ZN10S2407C3_nt4v105Ev");}
void  S2407C3_nt ::v106(){vfunc_called(this, "_ZN10S2407C3_nt4v106Ev");}
S2407C3_nt ::S2407C3_nt(){ note_ctor("S2407C3_nt", this);} // tgen

//skip512 S2407C3_nt

#else // __cplusplus

extern void _ZN10S2407C3_ntC1Ev();
extern void _ZN10S2407C3_ntD1Ev();
Name_Map name_map_S2407C3_nt[] = {
  NSPAIR(_ZN10S2407C3_ntC1Ev),
  NSPAIR(_ZN10S2407C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2407C4_nt;
extern VTBL_ENTRY _ZTI10S2407C4_nt[];
extern  VTBL_ENTRY _ZTV10S2407C4_nt[];
static Base_Class bases_S2407C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2407C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S2407C3_nt[];
extern void _ZN10S2407C3_ntD1Ev();
extern void _ZN10S2407C3_ntD0Ev();
extern void _ZN10S2407C4_nt2v6Ev();
extern void _ZN10S2407C4_nt2v7Ev();
extern void _ZN10S2407C4_nt2v8Ev();
extern void _ZN10S2407C4_nt2v9Ev();
extern void _ZN10S2407C4_nt3v10Ev();
extern void _ZN10S2407C4_nt3v11Ev();
extern void _ZN10S2407C4_nt3v12Ev();
extern void _ZN10S2407C4_nt3v13Ev();
extern void _ZN10S2407C4_nt3v14Ev();
extern void _ZN10S2407C4_nt3v15Ev();
extern void _ZN10S2407C4_nt3v16Ev();
extern void _ZN10S2407C4_nt3v17Ev();
extern void _ZN10S2407C4_nt3v18Ev();
extern void _ZN10S2407C4_nt3v19Ev();
extern void _ZN10S2407C4_nt3v20Ev();
extern void _ZN10S2407C4_nt3v21Ev();
extern void _ZN10S2407C4_nt3v22Ev();
extern void _ZN10S2407C4_nt3v23Ev();
extern void _ZN10S2407C4_nt3v24Ev();
extern void _ZN10S2407C4_nt3v25Ev();
extern void _ZN10S2407C4_nt3v26Ev();
extern void _ZN10S2407C4_nt3v27Ev();
extern void _ZN10S2407C4_nt3v28Ev();
extern void _ZN10S2407C3_nt3v29Ev();
extern void _ZN10S2407C3_nt3v30Ev();
extern void _ZN10S2407C3_nt3v31Ev();
extern void _ZN10S2407C3_nt3v32Ev();
extern void _ZN10S2407C3_nt3v33Ev();
extern void _ZN10S2407C3_nt3v34Ev();
extern void _ZN10S2407C3_nt3v35Ev();
extern void _ZN10S2407C3_nt3v36Ev();
extern void _ZN10S2407C3_nt3v37Ev();
extern void _ZN10S2407C3_nt3v38Ev();
extern void _ZN10S2407C3_nt3v39Ev();
extern void _ZN10S2407C3_nt3v40Ev();
extern void _ZN10S2407C3_nt3v41Ev();
extern void _ZN10S2407C3_nt3v42Ev();
extern void _ZN10S2407C3_nt3v43Ev();
extern void _ZN10S2407C3_nt3v44Ev();
extern void _ZN10S2407C3_nt3v45Ev();
extern void _ZN10S2407C3_nt3v46Ev();
extern void _ZN10S2407C3_nt3v47Ev();
extern void _ZN10S2407C3_nt3v48Ev();
extern void _ZN10S2407C3_nt3v49Ev();
extern void _ZN10S2407C3_nt3v50Ev();
extern void _ZN10S2407C3_nt3v51Ev();
extern void _ZN10S2407C3_nt3v52Ev();
extern void _ZN10S2407C3_nt3v53Ev();
extern void _ZN10S2407C3_nt3v54Ev();
extern void _ZN10S2407C3_nt3v55Ev();
extern void _ZN10S2407C3_nt3v56Ev();
extern void _ZN10S2407C3_nt3v57Ev();
extern void _ZN10S2407C3_nt3v58Ev();
extern void _ZN10S2407C3_nt3v59Ev();
extern void _ZN10S2407C3_nt3v60Ev();
extern void _ZN10S2407C3_nt3v61Ev();
extern void _ZN10S2407C3_nt3v62Ev();
extern void _ZN10S2407C3_nt3v63Ev();
extern void _ZN10S2407C3_nt3v64Ev();
extern void _ZN10S2407C3_nt3v65Ev();
extern void _ZN10S2407C3_nt3v66Ev();
extern void _ZN10S2407C3_nt3v67Ev();
extern void _ZN10S2407C3_nt3v68Ev();
extern void _ZN10S2407C3_nt3v69Ev();
extern void _ZN10S2407C3_nt3v70Ev();
extern void _ZN10S2407C3_nt3v71Ev();
extern void _ZN10S2407C3_nt3v72Ev();
extern void _ZN10S2407C3_nt3v73Ev();
extern void _ZN10S2407C3_nt3v74Ev();
extern void _ZN10S2407C3_nt3v75Ev();
extern void _ZN10S2407C3_nt3v76Ev();
extern void _ZN10S2407C3_nt3v77Ev();
extern void _ZN10S2407C3_nt3v78Ev();
extern void _ZN10S2407C3_nt3v79Ev();
extern void _ZN10S2407C3_nt3v80Ev();
extern void _ZN10S2407C3_nt3v81Ev();
extern void _ZN10S2407C3_nt3v82Ev();
extern void _ZN10S2407C3_nt3v83Ev();
extern void _ZN10S2407C3_nt3v84Ev();
extern void _ZN10S2407C3_nt3v85Ev();
extern void _ZN10S2407C3_nt3v86Ev();
extern void _ZN10S2407C3_nt3v87Ev();
extern void _ZN10S2407C3_nt3v88Ev();
extern void _ZN10S2407C3_nt3v89Ev();
extern void _ZN10S2407C3_nt3v90Ev();
extern void _ZN10S2407C3_nt3v91Ev();
extern void _ZN10S2407C3_nt3v92Ev();
extern void _ZN10S2407C3_nt3v93Ev();
extern void _ZN10S2407C3_nt3v94Ev();
extern void _ZN10S2407C3_nt3v95Ev();
extern void _ZN10S2407C3_nt3v96Ev();
extern void _ZN10S2407C3_nt3v97Ev();
extern void _ZN10S2407C3_nt3v98Ev();
extern void _ZN10S2407C3_nt3v99Ev();
extern void _ZN10S2407C3_nt4v100Ev();
extern void _ZN10S2407C3_nt4v101Ev();
extern void _ZN10S2407C3_nt4v102Ev();
extern void _ZN10S2407C3_nt4v103Ev();
extern void _ZN10S2407C3_nt4v104Ev();
extern void _ZN10S2407C3_nt4v105Ev();
extern void _ZN10S2407C3_nt4v106Ev();
static  VTBL_ENTRY vtc_S2407C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2407C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S2407C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt4v106Ev,
};
extern VTBL_ENTRY _ZTI10S2407C3_nt[];
VTBL_ENTRY *P__ZTI10S2407C3_nt = _ZTI10S2407C3_nt; 
extern  VTBL_ENTRY _ZTV10S2407C3_nt[];
Class_Descriptor cd_S2407C3_nt = {  "S2407C3_nt", // class name
  bases_S2407C3_nt, 1,
  &(vtc_S2407C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(832,632), // object size
  NSPAIRA(_ZTI10S2407C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S2407C3_nt),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2407C2_nt  : S2407C3_nt {
  void *s2407c2f0;
  virtual  ~S2407C2_nt(); // _ZN10S2407C2_ntD1Ev
  virtual void  v107(); // _ZN10S2407C2_nt4v107Ev
  virtual void  v108(); // _ZN10S2407C2_nt4v108Ev
  virtual void  v109(); // _ZN10S2407C2_nt4v109Ev
  virtual void  v110(); // _ZN10S2407C2_nt4v110Ev
  virtual void  v111(); // _ZN10S2407C2_nt4v111Ev
  virtual void  v112(); // _ZN10S2407C2_nt4v112Ev
  virtual void  v113(); // _ZN10S2407C2_nt4v113Ev
  virtual void  v114(); // _ZN10S2407C2_nt4v114Ev
  virtual void  v115(); // _ZN10S2407C2_nt4v115Ev
  virtual void  v116(); // _ZN10S2407C2_nt4v116Ev
  S2407C2_nt(); // tgen
};
//SIG(-1 S2407C2_nt) C1{ BC2{ BC3{ vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 Fp Fi FC4{ BC5{ m Fp Fi FC6{ m} FC7{ m}}} FC4 Fi} vd v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8 FC10{ m FC8} FC11{ m FC8 FC8 FC8 FC8} FC11 FC8 FC8 FC8 Fp FC10 FC12{ m FC13{ m Fp Fi FC7} Fi} Fi Fp[7] FC14{ m Fp Fi FC15{ m} FC15} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC16{ BC17{ m Fp Fi FC18{ m} FC18}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC19{ m Fp Fi[2] FC20{ m}} Fp[2] Fi:16 Fi:16 FC16 FC19 FC21{ m Fp Fi[2] FC20} Fp[2] Fi:24 Fi:8 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp}


 S2407C2_nt ::~S2407C2_nt(){ note_dtor("S2407C2_nt", this);}
void  S2407C2_nt ::v107(){vfunc_called(this, "_ZN10S2407C2_nt4v107Ev");}
void  S2407C2_nt ::v108(){vfunc_called(this, "_ZN10S2407C2_nt4v108Ev");}
void  S2407C2_nt ::v109(){vfunc_called(this, "_ZN10S2407C2_nt4v109Ev");}
void  S2407C2_nt ::v110(){vfunc_called(this, "_ZN10S2407C2_nt4v110Ev");}
void  S2407C2_nt ::v111(){vfunc_called(this, "_ZN10S2407C2_nt4v111Ev");}
void  S2407C2_nt ::v112(){vfunc_called(this, "_ZN10S2407C2_nt4v112Ev");}
void  S2407C2_nt ::v113(){vfunc_called(this, "_ZN10S2407C2_nt4v113Ev");}
void  S2407C2_nt ::v114(){vfunc_called(this, "_ZN10S2407C2_nt4v114Ev");}
void  S2407C2_nt ::v115(){vfunc_called(this, "_ZN10S2407C2_nt4v115Ev");}
void  S2407C2_nt ::v116(){vfunc_called(this, "_ZN10S2407C2_nt4v116Ev");}
S2407C2_nt ::S2407C2_nt(){ note_ctor("S2407C2_nt", this);} // tgen

//skip512 S2407C2_nt

#else // __cplusplus

extern void _ZN10S2407C2_ntC1Ev();
extern void _ZN10S2407C2_ntD1Ev();
Name_Map name_map_S2407C2_nt[] = {
  NSPAIR(_ZN10S2407C2_ntC1Ev),
  NSPAIR(_ZN10S2407C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2407C4_nt;
extern VTBL_ENTRY _ZTI10S2407C4_nt[];
extern  VTBL_ENTRY _ZTV10S2407C4_nt[];
extern Class_Descriptor cd_S2407C3_nt;
extern VTBL_ENTRY _ZTI10S2407C3_nt[];
extern  VTBL_ENTRY _ZTV10S2407C3_nt[];
static Base_Class bases_S2407C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2407C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2407C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S2407C2_nt[];
extern void _ZN10S2407C2_ntD1Ev();
extern void _ZN10S2407C2_ntD0Ev();
extern void _ZN10S2407C4_nt2v6Ev();
extern void _ZN10S2407C4_nt2v7Ev();
extern void _ZN10S2407C4_nt2v8Ev();
extern void _ZN10S2407C4_nt2v9Ev();
extern void _ZN10S2407C4_nt3v10Ev();
extern void _ZN10S2407C4_nt3v11Ev();
extern void _ZN10S2407C4_nt3v12Ev();
extern void _ZN10S2407C4_nt3v13Ev();
extern void _ZN10S2407C4_nt3v14Ev();
extern void _ZN10S2407C4_nt3v15Ev();
extern void _ZN10S2407C4_nt3v16Ev();
extern void _ZN10S2407C4_nt3v17Ev();
extern void _ZN10S2407C4_nt3v18Ev();
extern void _ZN10S2407C4_nt3v19Ev();
extern void _ZN10S2407C4_nt3v20Ev();
extern void _ZN10S2407C4_nt3v21Ev();
extern void _ZN10S2407C4_nt3v22Ev();
extern void _ZN10S2407C4_nt3v23Ev();
extern void _ZN10S2407C4_nt3v24Ev();
extern void _ZN10S2407C4_nt3v25Ev();
extern void _ZN10S2407C4_nt3v26Ev();
extern void _ZN10S2407C4_nt3v27Ev();
extern void _ZN10S2407C4_nt3v28Ev();
extern void _ZN10S2407C3_nt3v29Ev();
extern void _ZN10S2407C3_nt3v30Ev();
extern void _ZN10S2407C3_nt3v31Ev();
extern void _ZN10S2407C3_nt3v32Ev();
extern void _ZN10S2407C3_nt3v33Ev();
extern void _ZN10S2407C3_nt3v34Ev();
extern void _ZN10S2407C3_nt3v35Ev();
extern void _ZN10S2407C3_nt3v36Ev();
extern void _ZN10S2407C3_nt3v37Ev();
extern void _ZN10S2407C3_nt3v38Ev();
extern void _ZN10S2407C3_nt3v39Ev();
extern void _ZN10S2407C3_nt3v40Ev();
extern void _ZN10S2407C3_nt3v41Ev();
extern void _ZN10S2407C3_nt3v42Ev();
extern void _ZN10S2407C3_nt3v43Ev();
extern void _ZN10S2407C3_nt3v44Ev();
extern void _ZN10S2407C3_nt3v45Ev();
extern void _ZN10S2407C3_nt3v46Ev();
extern void _ZN10S2407C3_nt3v47Ev();
extern void _ZN10S2407C3_nt3v48Ev();
extern void _ZN10S2407C3_nt3v49Ev();
extern void _ZN10S2407C3_nt3v50Ev();
extern void _ZN10S2407C3_nt3v51Ev();
extern void _ZN10S2407C3_nt3v52Ev();
extern void _ZN10S2407C3_nt3v53Ev();
extern void _ZN10S2407C3_nt3v54Ev();
extern void _ZN10S2407C3_nt3v55Ev();
extern void _ZN10S2407C3_nt3v56Ev();
extern void _ZN10S2407C3_nt3v57Ev();
extern void _ZN10S2407C3_nt3v58Ev();
extern void _ZN10S2407C3_nt3v59Ev();
extern void _ZN10S2407C3_nt3v60Ev();
extern void _ZN10S2407C3_nt3v61Ev();
extern void _ZN10S2407C3_nt3v62Ev();
extern void _ZN10S2407C3_nt3v63Ev();
extern void _ZN10S2407C3_nt3v64Ev();
extern void _ZN10S2407C3_nt3v65Ev();
extern void _ZN10S2407C3_nt3v66Ev();
extern void _ZN10S2407C3_nt3v67Ev();
extern void _ZN10S2407C3_nt3v68Ev();
extern void _ZN10S2407C3_nt3v69Ev();
extern void _ZN10S2407C3_nt3v70Ev();
extern void _ZN10S2407C3_nt3v71Ev();
extern void _ZN10S2407C3_nt3v72Ev();
extern void _ZN10S2407C3_nt3v73Ev();
extern void _ZN10S2407C3_nt3v74Ev();
extern void _ZN10S2407C3_nt3v75Ev();
extern void _ZN10S2407C3_nt3v76Ev();
extern void _ZN10S2407C3_nt3v77Ev();
extern void _ZN10S2407C3_nt3v78Ev();
extern void _ZN10S2407C3_nt3v79Ev();
extern void _ZN10S2407C3_nt3v80Ev();
extern void _ZN10S2407C3_nt3v81Ev();
extern void _ZN10S2407C3_nt3v82Ev();
extern void _ZN10S2407C3_nt3v83Ev();
extern void _ZN10S2407C3_nt3v84Ev();
extern void _ZN10S2407C3_nt3v85Ev();
extern void _ZN10S2407C3_nt3v86Ev();
extern void _ZN10S2407C3_nt3v87Ev();
extern void _ZN10S2407C3_nt3v88Ev();
extern void _ZN10S2407C3_nt3v89Ev();
extern void _ZN10S2407C3_nt3v90Ev();
extern void _ZN10S2407C3_nt3v91Ev();
extern void _ZN10S2407C3_nt3v92Ev();
extern void _ZN10S2407C3_nt3v93Ev();
extern void _ZN10S2407C3_nt3v94Ev();
extern void _ZN10S2407C3_nt3v95Ev();
extern void _ZN10S2407C3_nt3v96Ev();
extern void _ZN10S2407C3_nt3v97Ev();
extern void _ZN10S2407C3_nt3v98Ev();
extern void _ZN10S2407C3_nt3v99Ev();
extern void _ZN10S2407C3_nt4v100Ev();
extern void _ZN10S2407C3_nt4v101Ev();
extern void _ZN10S2407C3_nt4v102Ev();
extern void _ZN10S2407C3_nt4v103Ev();
extern void _ZN10S2407C3_nt4v104Ev();
extern void _ZN10S2407C3_nt4v105Ev();
extern void _ZN10S2407C3_nt4v106Ev();
extern void _ZN10S2407C2_nt4v107Ev();
extern void _ZN10S2407C2_nt4v108Ev();
extern void _ZN10S2407C2_nt4v109Ev();
extern void _ZN10S2407C2_nt4v110Ev();
extern void _ZN10S2407C2_nt4v111Ev();
extern void _ZN10S2407C2_nt4v112Ev();
extern void _ZN10S2407C2_nt4v113Ev();
extern void _ZN10S2407C2_nt4v114Ev();
extern void _ZN10S2407C2_nt4v115Ev();
extern void _ZN10S2407C2_nt4v116Ev();
static  VTBL_ENTRY vtc_S2407C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2407C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S2407C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2407C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S2407C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S2407C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S2407C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S2407C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S2407C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S2407C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S2407C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S2407C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S2407C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S2407C2_nt4v116Ev,
};
extern VTBL_ENTRY _ZTI10S2407C2_nt[];
VTBL_ENTRY *P__ZTI10S2407C2_nt = _ZTI10S2407C2_nt; 
extern  VTBL_ENTRY _ZTV10S2407C2_nt[];
Class_Descriptor cd_S2407C2_nt = {  "S2407C2_nt", // class name
  bases_S2407C2_nt, 2,
  &(vtc_S2407C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(840,636), // object size
  NSPAIRA(_ZTI10S2407C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S2407C2_nt),115, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2407C1  : S2407C2_nt {
  int s2407c1f0;
  virtual  ~S2407C1(); // _ZN7S2407C1D1Ev
  virtual void  v1(); // _ZN7S2407C12v1Ev
  virtual void  v2(); // _ZN7S2407C12v2Ev
  virtual void  v3(); // _ZN7S2407C12v3Ev
  virtual void  v4(); // _ZN7S2407C12v4Ev
  virtual void  v5(); // _ZN7S2407C12v5Ev
  S2407C1(); // tgen
};
//SIG(1 S2407C1) C1{ BC2{ BC3{ BC4{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 Fp Fi FC5{ BC6{ m Fp Fi FC7{ m} FC8{ m}}} FC5 Fi} vd v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 FC9{ m FC10{ m FL[2]}} FC9 FC9 FC9 FC11{ m FC9} FC12{ m FC9 FC9 FC9 FC9} FC12 FC9 FC9 FC9 Fp FC11 FC13{ m FC14{ m Fp Fi FC8} Fi} Fi Fp[7] FC15{ m Fp Fi FC16{ m} FC16} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC17{ BC18{ m Fp Fi FC19{ m} FC19}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC20{ m Fp Fi[2] FC21{ m}} Fp[2] Fi:16 Fi:16 FC17 FC20 FC22{ m Fp Fi[2] FC21} Fp[2] Fi:24 Fi:8 Fp} vd v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 Fp} vd v1 v2 v3 v4 v5 Fi}


 S2407C1 ::~S2407C1(){ note_dtor("S2407C1", this);}
void  S2407C1 ::v1(){vfunc_called(this, "_ZN7S2407C12v1Ev");}
void  S2407C1 ::v2(){vfunc_called(this, "_ZN7S2407C12v2Ev");}
void  S2407C1 ::v3(){vfunc_called(this, "_ZN7S2407C12v3Ev");}
void  S2407C1 ::v4(){vfunc_called(this, "_ZN7S2407C12v4Ev");}
void  S2407C1 ::v5(){vfunc_called(this, "_ZN7S2407C12v5Ev");}
S2407C1 ::S2407C1(){ note_ctor("S2407C1", this);} // tgen

static void Test_S2407C1()
{
  extern Class_Descriptor cd_S2407C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(107,161)];
    init_test(&cd_S2407C1, buf);
    S2407C1 *dp, &lv = *(dp=new (buf) S2407C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(848,640), "sizeof(S2407C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2407C1)");
    check_base_class_offset(lv, (S2407C4_nt*)(S2407C3_nt*)(S2407C2_nt*), 0, "S2407C1");
    check_base_class_offset(lv, (S2407C3_nt*)(S2407C2_nt*), 0, "S2407C1");
    check_base_class_offset(lv, (S2407C2_nt*), 0, "S2407C1");
    check_field_offset(lv, s2407c1f0, ABISELECT(840,636), "S2407C1.s2407c1f0");
    test_class_info(&lv, &cd_S2407C1);
    dp->~S2407C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2407C1(Test_S2407C1, "S2407C1", ABISELECT(848,640));

#else // __cplusplus

extern void _ZN7S2407C1C1Ev();
extern void _ZN7S2407C1D1Ev();
Name_Map name_map_S2407C1[] = {
  NSPAIR(_ZN7S2407C1C1Ev),
  NSPAIR(_ZN7S2407C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2407C4_nt;
extern VTBL_ENTRY _ZTI10S2407C4_nt[];
extern  VTBL_ENTRY _ZTV10S2407C4_nt[];
extern Class_Descriptor cd_S2407C3_nt;
extern VTBL_ENTRY _ZTI10S2407C3_nt[];
extern  VTBL_ENTRY _ZTV10S2407C3_nt[];
extern Class_Descriptor cd_S2407C2_nt;
extern VTBL_ENTRY _ZTI10S2407C2_nt[];
extern  VTBL_ENTRY _ZTV10S2407C2_nt[];
static Base_Class bases_S2407C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2407C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2407C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2407C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2407C1[];
extern void _ZN7S2407C1D1Ev();
extern void _ZN7S2407C1D0Ev();
extern void _ZN10S2407C4_nt2v6Ev();
extern void _ZN10S2407C4_nt2v7Ev();
extern void _ZN10S2407C4_nt2v8Ev();
extern void _ZN10S2407C4_nt2v9Ev();
extern void _ZN10S2407C4_nt3v10Ev();
extern void _ZN10S2407C4_nt3v11Ev();
extern void _ZN10S2407C4_nt3v12Ev();
extern void _ZN10S2407C4_nt3v13Ev();
extern void _ZN10S2407C4_nt3v14Ev();
extern void _ZN10S2407C4_nt3v15Ev();
extern void _ZN10S2407C4_nt3v16Ev();
extern void _ZN10S2407C4_nt3v17Ev();
extern void _ZN10S2407C4_nt3v18Ev();
extern void _ZN10S2407C4_nt3v19Ev();
extern void _ZN10S2407C4_nt3v20Ev();
extern void _ZN10S2407C4_nt3v21Ev();
extern void _ZN10S2407C4_nt3v22Ev();
extern void _ZN10S2407C4_nt3v23Ev();
extern void _ZN10S2407C4_nt3v24Ev();
extern void _ZN10S2407C4_nt3v25Ev();
extern void _ZN10S2407C4_nt3v26Ev();
extern void _ZN10S2407C4_nt3v27Ev();
extern void _ZN10S2407C4_nt3v28Ev();
extern void _ZN10S2407C3_nt3v29Ev();
extern void _ZN10S2407C3_nt3v30Ev();
extern void _ZN10S2407C3_nt3v31Ev();
extern void _ZN10S2407C3_nt3v32Ev();
extern void _ZN10S2407C3_nt3v33Ev();
extern void _ZN10S2407C3_nt3v34Ev();
extern void _ZN10S2407C3_nt3v35Ev();
extern void _ZN10S2407C3_nt3v36Ev();
extern void _ZN10S2407C3_nt3v37Ev();
extern void _ZN10S2407C3_nt3v38Ev();
extern void _ZN10S2407C3_nt3v39Ev();
extern void _ZN10S2407C3_nt3v40Ev();
extern void _ZN10S2407C3_nt3v41Ev();
extern void _ZN10S2407C3_nt3v42Ev();
extern void _ZN10S2407C3_nt3v43Ev();
extern void _ZN10S2407C3_nt3v44Ev();
extern void _ZN10S2407C3_nt3v45Ev();
extern void _ZN10S2407C3_nt3v46Ev();
extern void _ZN10S2407C3_nt3v47Ev();
extern void _ZN10S2407C3_nt3v48Ev();
extern void _ZN10S2407C3_nt3v49Ev();
extern void _ZN10S2407C3_nt3v50Ev();
extern void _ZN10S2407C3_nt3v51Ev();
extern void _ZN10S2407C3_nt3v52Ev();
extern void _ZN10S2407C3_nt3v53Ev();
extern void _ZN10S2407C3_nt3v54Ev();
extern void _ZN10S2407C3_nt3v55Ev();
extern void _ZN10S2407C3_nt3v56Ev();
extern void _ZN10S2407C3_nt3v57Ev();
extern void _ZN10S2407C3_nt3v58Ev();
extern void _ZN10S2407C3_nt3v59Ev();
extern void _ZN10S2407C3_nt3v60Ev();
extern void _ZN10S2407C3_nt3v61Ev();
extern void _ZN10S2407C3_nt3v62Ev();
extern void _ZN10S2407C3_nt3v63Ev();
extern void _ZN10S2407C3_nt3v64Ev();
extern void _ZN10S2407C3_nt3v65Ev();
extern void _ZN10S2407C3_nt3v66Ev();
extern void _ZN10S2407C3_nt3v67Ev();
extern void _ZN10S2407C3_nt3v68Ev();
extern void _ZN10S2407C3_nt3v69Ev();
extern void _ZN10S2407C3_nt3v70Ev();
extern void _ZN10S2407C3_nt3v71Ev();
extern void _ZN10S2407C3_nt3v72Ev();
extern void _ZN10S2407C3_nt3v73Ev();
extern void _ZN10S2407C3_nt3v74Ev();
extern void _ZN10S2407C3_nt3v75Ev();
extern void _ZN10S2407C3_nt3v76Ev();
extern void _ZN10S2407C3_nt3v77Ev();
extern void _ZN10S2407C3_nt3v78Ev();
extern void _ZN10S2407C3_nt3v79Ev();
extern void _ZN10S2407C3_nt3v80Ev();
extern void _ZN10S2407C3_nt3v81Ev();
extern void _ZN10S2407C3_nt3v82Ev();
extern void _ZN10S2407C3_nt3v83Ev();
extern void _ZN10S2407C3_nt3v84Ev();
extern void _ZN10S2407C3_nt3v85Ev();
extern void _ZN10S2407C3_nt3v86Ev();
extern void _ZN10S2407C3_nt3v87Ev();
extern void _ZN10S2407C3_nt3v88Ev();
extern void _ZN10S2407C3_nt3v89Ev();
extern void _ZN10S2407C3_nt3v90Ev();
extern void _ZN10S2407C3_nt3v91Ev();
extern void _ZN10S2407C3_nt3v92Ev();
extern void _ZN10S2407C3_nt3v93Ev();
extern void _ZN10S2407C3_nt3v94Ev();
extern void _ZN10S2407C3_nt3v95Ev();
extern void _ZN10S2407C3_nt3v96Ev();
extern void _ZN10S2407C3_nt3v97Ev();
extern void _ZN10S2407C3_nt3v98Ev();
extern void _ZN10S2407C3_nt3v99Ev();
extern void _ZN10S2407C3_nt4v100Ev();
extern void _ZN10S2407C3_nt4v101Ev();
extern void _ZN10S2407C3_nt4v102Ev();
extern void _ZN10S2407C3_nt4v103Ev();
extern void _ZN10S2407C3_nt4v104Ev();
extern void _ZN10S2407C3_nt4v105Ev();
extern void _ZN10S2407C3_nt4v106Ev();
extern void _ZN10S2407C2_nt4v107Ev();
extern void _ZN10S2407C2_nt4v108Ev();
extern void _ZN10S2407C2_nt4v109Ev();
extern void _ZN10S2407C2_nt4v110Ev();
extern void _ZN10S2407C2_nt4v111Ev();
extern void _ZN10S2407C2_nt4v112Ev();
extern void _ZN10S2407C2_nt4v113Ev();
extern void _ZN10S2407C2_nt4v114Ev();
extern void _ZN10S2407C2_nt4v115Ev();
extern void _ZN10S2407C2_nt4v116Ev();
extern void _ZN7S2407C12v1Ev();
extern void _ZN7S2407C12v2Ev();
extern void _ZN7S2407C12v3Ev();
extern void _ZN7S2407C12v4Ev();
extern void _ZN7S2407C12v5Ev();
static  VTBL_ENTRY vtc_S2407C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2407C1[0]),
  (VTBL_ENTRY)&_ZN7S2407C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2407C1D0Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2407C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S2407C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S2407C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S2407C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S2407C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S2407C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S2407C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S2407C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S2407C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S2407C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S2407C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S2407C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN7S2407C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2407C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2407C12v3Ev,
  (VTBL_ENTRY)&_ZN7S2407C12v4Ev,
  (VTBL_ENTRY)&_ZN7S2407C12v5Ev,
};
extern VTBL_ENTRY _ZTI7S2407C1[];
extern  VTBL_ENTRY _ZTV7S2407C1[];
Class_Descriptor cd_S2407C1 = {  "S2407C1", // class name
  bases_S2407C1, 3,
  &(vtc_S2407C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(848,640), // object size
  NSPAIRA(_ZTI7S2407C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2407C1),120, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21243C15  {
  void *s21243c15f0;
  char s21243c15f1;
  ::S2407C29_nt s21243c15f2;
  void  mf21243c15(); // _ZN9S21243C1510mf21243c15Ev
};
//SIG(-1 S21243C15) C1{ m Fp Fc FC2{ m Fp Fi[2] FC3{ m}}}


void  S21243C15 ::mf21243c15(){}

static void Test_S21243C15()
{
  {
    init_simple_test("S21243C15");
    S21243C15 lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(S21243C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21243C15)");
    check_field_offset(lv, s21243c15f0, 0, "S21243C15.s21243c15f0");
    check_field_offset(lv, s21243c15f1, ABISELECT(8,4), "S21243C15.s21243c15f1");
    check_field_offset(lv, s21243c15f2, ABISELECT(16,8), "S21243C15.s21243c15f2");
  }
}
static Arrange_To_Call_Me vS21243C15(Test_S21243C15, "S21243C15", ABISELECT(40,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21243C26_nt  {
  long s21243c26f0;
  void  mf21243c26(); // _ZN12S21243C26_nt10mf21243c26Ev
};
//SIG(-1 S21243C26_nt) C1{ m Fl}


void  S21243C26_nt ::mf21243c26(){}

//skip512 S21243C26_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21243C27  {
  void *s21243c27f0[2];
  int s21243c27f1;
};
//SIG(-1 S21243C27) C1{ Fp[2] Fi}



static void Test_S21243C27()
{
  {
    init_simple_test("S21243C27");
    S21243C27 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S21243C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21243C27)");
    check_field_offset(lv, s21243c27f0, 0, "S21243C27.s21243c27f0");
    check_field_offset(lv, s21243c27f1, ABISELECT(16,8), "S21243C27.s21243c27f1");
  }
}
static Arrange_To_Call_Me vS21243C27(Test_S21243C27, "S21243C27", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21243C28_nt  {
  void *s21243c28f0;
  void  mf21243c28(); // _ZN12S21243C28_nt10mf21243c28Ev
};
//SIG(-1 S21243C28_nt) C1{ m Fp}


void  S21243C28_nt ::mf21243c28(){}

//skip512 S21243C28_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI12S21243C28_nt[];
VTBL_ENTRY *P__ZTI12S21243C28_nt = _ZTI12S21243C28_nt; 
Class_Descriptor cd_S21243C28_nt = {  "S21243C28_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI12S21243C28_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21243C22  {
  void *s21243c22f0[4];
  ::S2407C13_nt s21243c22f1;
  ::S2407C13_nt s21243c22f2;
  ::S2407C13_nt s21243c22f3;
  ::S2407C13_nt s21243c22f4;
  ::S2407C13_nt s21243c22f5;
  ::S2407C17_nt s21243c22f6;
  int s21243c22f7[2];
  ::S21243C26_nt s21243c22f8;
  unsigned char s21243c22f9:1;
  unsigned char s21243c22f10:1;
  unsigned char s21243c22f11:1;
  unsigned char s21243c22f12:1;
  unsigned char s21243c22f13:1;
  ::S21243C27 s21243c22f14;
  int s21243c22f15;
  ::S21243C28_nt s21243c22f16;
  char s21243c22f17;
  int s21243c22f18;
  void  mf21243c22(); // _ZN9S21243C2210mf21243c22Ev
};
//SIG(1 S21243C22) C1{ m Fp[4] FC2{ m FC3{ m FL[2]}} FC2 FC2 FC2 FC2 FC4{ m FC2} Fi[2] FC5{ m Fl} Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 FC6{ Fp[2] Fi} Fi FC7{ m Fp} Fc Fi}


void  S21243C22 ::mf21243c22(){}

static void Test_S21243C22()
{
  {
    init_simple_test("S21243C22");
    static S21243C22 lv;
    check2(sizeof(lv), ABISELECT(200,156), "sizeof(S21243C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21243C22)");
    check_field_offset(lv, s21243c22f0, 0, "S21243C22.s21243c22f0");
    check_field_offset(lv, s21243c22f1, ABISELECT(32,16), "S21243C22.s21243c22f1");
    check_field_offset(lv, s21243c22f2, ABISELECT(48,32), "S21243C22.s21243c22f2");
    check_field_offset(lv, s21243c22f3, ABISELECT(64,48), "S21243C22.s21243c22f3");
    check_field_offset(lv, s21243c22f4, ABISELECT(80,64), "S21243C22.s21243c22f4");
    check_field_offset(lv, s21243c22f5, ABISELECT(96,80), "S21243C22.s21243c22f5");
    check_field_offset(lv, s21243c22f6, ABISELECT(112,96), "S21243C22.s21243c22f6");
    check_field_offset(lv, s21243c22f7, ABISELECT(128,112), "S21243C22.s21243c22f7");
    check_field_offset(lv, s21243c22f8, ABISELECT(136,120), "S21243C22.s21243c22f8");
    set_bf_and_test(lv, s21243c22f9, ABISELECT(144,124), 0, 1, 1, "S21243C22");
    set_bf_and_test(lv, s21243c22f10, ABISELECT(144,124), 1, 1, 1, "S21243C22");
    set_bf_and_test(lv, s21243c22f11, ABISELECT(144,124), 2, 1, 1, "S21243C22");
    set_bf_and_test(lv, s21243c22f12, ABISELECT(144,124), 3, 1, 1, "S21243C22");
    set_bf_and_test(lv, s21243c22f13, ABISELECT(144,124), 4, 1, 1, "S21243C22");
    check_field_offset(lv, s21243c22f14, ABISELECT(152,128), "S21243C22.s21243c22f14");
    check_field_offset(lv, s21243c22f15, ABISELECT(176,140), "S21243C22.s21243c22f15");
    check_field_offset(lv, s21243c22f16, ABISELECT(184,144), "S21243C22.s21243c22f16");
    check_field_offset(lv, s21243c22f17, ABISELECT(192,148), "S21243C22.s21243c22f17");
    check_field_offset(lv, s21243c22f18, ABISELECT(196,152), "S21243C22.s21243c22f18");
  }
}
static Arrange_To_Call_Me vS21243C22(Test_S21243C22, "S21243C22", ABISELECT(200,156));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21243C30_nt  {
  void *s21243c30f0;
  int s21243c30f1[2];
  ::S2407C30 s21243c30f2;
  void  mf21243c30(); // _ZN12S21243C30_nt10mf21243c30Ev
};
//SIG(-1 S21243C30_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S21243C30_nt ::mf21243c30(){}

//skip512 S21243C30_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI12S21243C30_nt[];
VTBL_ENTRY *P__ZTI12S21243C30_nt = _ZTI12S21243C30_nt; 
Class_Descriptor cd_S21243C30_nt = {  "S21243C30_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI12S21243C30_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21243C33_nt  {
  long s21243c33f0[4];
};
//SIG(-1 S21243C33_nt) C1{ Fl[4]}



//skip512 S21243C33_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21243C32_nt  {
  ::S21243C33_nt s21243c32f0;
  void  mf21243c32(); // _ZN12S21243C32_nt10mf21243c32Ev
};
//SIG(-1 S21243C32_nt) C1{ m FC2{ Fl[4]}}


void  S21243C32_nt ::mf21243c32(){}

//skip512 S21243C32_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21243C29  {
  ::S21243C30_nt s21243c29f0;
  ::S21243C32_nt s21243c29f1;
  void  mf21243c29(); // _ZN9S21243C2910mf21243c29Ev
  virtual  ~S21243C29(); // _ZN9S21243C29D1Ev
  S21243C29(); // tgen
};
//SIG(-1 S21243C29) C1{ vd m FC2{ m Fp Fi[2] FC3{ m}} FC4{ m FC5{ Fl[4]}}}


void  S21243C29 ::mf21243c29(){}
 S21243C29 ::~S21243C29(){ note_dtor("S21243C29", this);}
S21243C29 ::S21243C29(){ note_ctor("S21243C29", this);} // tgen

static void Test_S21243C29()
{
  extern Class_Descriptor cd_S21243C29;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_S21243C29, buf);
    S21243C29 *dp, &lv = *(dp=new (buf) S21243C29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(S21243C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21243C29)");
    check_field_offset(lv, s21243c29f0, ABISELECT(8,4), "S21243C29.s21243c29f0");
    check_field_offset(lv, s21243c29f1, ABISELECT(32,20), "S21243C29.s21243c29f1");
    test_class_info(&lv, &cd_S21243C29);
    dp->~S21243C29();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21243C29(Test_S21243C29, "S21243C29", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN9S21243C29C1Ev();
extern void _ZN9S21243C29D1Ev();
Name_Map name_map_S21243C29[] = {
  NSPAIR(_ZN9S21243C29C1Ev),
  NSPAIR(_ZN9S21243C29D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S21243C29[];
extern void _ZN9S21243C29D1Ev();
extern void _ZN9S21243C29D0Ev();
static  VTBL_ENTRY vtc_S21243C29[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S21243C29[0]),
  (VTBL_ENTRY)&_ZN9S21243C29D1Ev,
  (VTBL_ENTRY)&_ZN9S21243C29D0Ev,
};
extern VTBL_ENTRY _ZTI9S21243C29[];
extern  VTBL_ENTRY _ZTV9S21243C29[];
Class_Descriptor cd_S21243C29 = {  "S21243C29", // class name
  0,0,//no base classes
  &(vtc_S21243C29[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI9S21243C29),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S21243C29),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21243C36_nt  {
  void *s21243c36f0;
  int s21243c36f1;
  ::S2407C27 s21243c36f2;
  ::S2407C23 s21243c36f3;
  void  mf21243c36(); // _ZN12S21243C36_nt10mf21243c36Ev
};
//SIG(-1 S21243C36_nt) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S21243C36_nt ::mf21243c36(){}

//skip512 S21243C36_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21243C39  {
  int s21243c39f0[3];
  char s21243c39f1;
  int s21243c39f2[4];
  ::S2407C13_nt s21243c39f3;
  ::S2407C13_nt s21243c39f4;
  ::S2407C18_nt s21243c39f5;
  void  mf21243c39(); // _ZN9S21243C3910mf21243c39Ev
};
//SIG(1 S21243C39) C1{ m Fi[3] Fc Fi[4] FC2{ m FC3{ m FL[2]}} FC2 FC4{ m FC2 FC2 FC2 FC2}}


void  S21243C39 ::mf21243c39(){}

static void Test_S21243C39()
{
  {
    init_simple_test("S21243C39");
    S21243C39 lv;
    check2(sizeof(lv), 128, "sizeof(S21243C39)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21243C39)");
    check_field_offset(lv, s21243c39f0, 0, "S21243C39.s21243c39f0");
    check_field_offset(lv, s21243c39f1, 12, "S21243C39.s21243c39f1");
    check_field_offset(lv, s21243c39f2, 16, "S21243C39.s21243c39f2");
    check_field_offset(lv, s21243c39f3, 32, "S21243C39.s21243c39f3");
    check_field_offset(lv, s21243c39f4, 48, "S21243C39.s21243c39f4");
    check_field_offset(lv, s21243c39f5, 64, "S21243C39.s21243c39f5");
  }
}
static Arrange_To_Call_Me vS21243C39(Test_S21243C39, "S21243C39", 128);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21243C41  {
  ::S2407C13_nt s21243c41f0;
  ::S2407C13_nt s21243c41f1;
  ::S2407C13_nt s21243c41f2;
  ::S2407C13_nt s21243c41f3;
  ::S2407C13_nt s21243c41f4;
  ::S2407C17_nt s21243c41f5;
  ::S2407C13_nt s21243c41f6;
  ::S2407C13_nt s21243c41f7;
  int s21243c41f8[3];
  void *s21243c41f9;
  void  mf21243c41(); // _ZN9S21243C4110mf21243c41Ev
};
//SIG(-1 S21243C41) C1{ m FC2{ m FC3{ m FL[2]}} FC2 FC2 FC2 FC2 FC4{ m FC2} FC2 FC2 Fi[3] Fp}


void  S21243C41 ::mf21243c41(){}

static void Test_S21243C41()
{
  {
    init_simple_test("S21243C41");
    S21243C41 lv;
    check2(sizeof(lv), ABISELECT(152,144), "sizeof(S21243C41)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21243C41)");
    check_field_offset(lv, s21243c41f0, 0, "S21243C41.s21243c41f0");
    check_field_offset(lv, s21243c41f1, 16, "S21243C41.s21243c41f1");
    check_field_offset(lv, s21243c41f2, 32, "S21243C41.s21243c41f2");
    check_field_offset(lv, s21243c41f3, 48, "S21243C41.s21243c41f3");
    check_field_offset(lv, s21243c41f4, 64, "S21243C41.s21243c41f4");
    check_field_offset(lv, s21243c41f5, 80, "S21243C41.s21243c41f5");
    check_field_offset(lv, s21243c41f6, 96, "S21243C41.s21243c41f6");
    check_field_offset(lv, s21243c41f7, 112, "S21243C41.s21243c41f7");
    check_field_offset(lv, s21243c41f8, 128, "S21243C41.s21243c41f8");
    check_field_offset(lv, s21243c41f9, ABISELECT(144,140), "S21243C41.s21243c41f9");
  }
}
static Arrange_To_Call_Me vS21243C41(Test_S21243C41, "S21243C41", ABISELECT(152,144));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21243C42  {
  int s21243c42f0[2];
  void *s21243c42f1[2];
  void  mf21243c42(); // _ZN9S21243C4210mf21243c42Ev
};
//SIG(1 S21243C42) C1{ m Fi[2] Fp[2]}


void  S21243C42 ::mf21243c42(){}

static void Test_S21243C42()
{
  {
    init_simple_test("S21243C42");
    S21243C42 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S21243C42)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21243C42)");
    check_field_offset(lv, s21243c42f0, 0, "S21243C42.s21243c42f0");
    check_field_offset(lv, s21243c42f1, 8, "S21243C42.s21243c42f1");
  }
}
static Arrange_To_Call_Me vS21243C42(Test_S21243C42, "S21243C42", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21243C43  {
  int s21243c43f0[2];
  void *s21243c43f1[2];
  ::S21243C41 s21243c43f2;
  ::S2407C13_nt s21243c43f3;
  ::S2407C13_nt s21243c43f4;
  ::S2407C13_nt s21243c43f5;
  ::S2407C13_nt s21243c43f6;
  void  mf21243c43(); // _ZN9S21243C4310mf21243c43Ev
};
//SIG(1 S21243C43) C1{ m Fi[2] Fp[2] FC2{ m FC3{ m FC4{ m FL[2]}} FC3 FC3 FC3 FC3 FC5{ m FC3} FC3 FC3 Fi[3] Fp} FC3 FC3 FC3 FC3}


void  S21243C43 ::mf21243c43(){}

static void Test_S21243C43()
{
  {
    init_simple_test("S21243C43");
    S21243C43 lv;
    check2(sizeof(lv), ABISELECT(240,224), "sizeof(S21243C43)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21243C43)");
    check_field_offset(lv, s21243c43f0, 0, "S21243C43.s21243c43f0");
    check_field_offset(lv, s21243c43f1, 8, "S21243C43.s21243c43f1");
    check_field_offset(lv, s21243c43f2, ABISELECT(24,16), "S21243C43.s21243c43f2");
    check_field_offset(lv, s21243c43f3, ABISELECT(176,160), "S21243C43.s21243c43f3");
    check_field_offset(lv, s21243c43f4, ABISELECT(192,176), "S21243C43.s21243c43f4");
    check_field_offset(lv, s21243c43f5, ABISELECT(208,192), "S21243C43.s21243c43f5");
    check_field_offset(lv, s21243c43f6, ABISELECT(224,208), "S21243C43.s21243c43f6");
  }
}
static Arrange_To_Call_Me vS21243C43(Test_S21243C43, "S21243C43", ABISELECT(240,224));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21243C44  {
  void *s21243c44f0[3];
  ::S2407C13_nt s21243c44f1;
  ::S2407C13_nt s21243c44f2;
  ::S2407C13_nt s21243c44f3;
  ::S2407C13_nt s21243c44f4;
  ::S2407C13_nt s21243c44f5;
  ::S2407C13_nt s21243c44f6;
  ::S2407C17_nt s21243c44f7;
  void  mf21243c44(); // _ZN9S21243C4410mf21243c44Ev
};
//SIG(1 S21243C44) C1{ m Fp[3] FC2{ m FC3{ m FL[2]}} FC2 FC2 FC2 FC2 FC2 FC4{ m FC2}}


void  S21243C44 ::mf21243c44(){}

static void Test_S21243C44()
{
  {
    init_simple_test("S21243C44");
    S21243C44 lv;
    check2(sizeof(lv), ABISELECT(136,124), "sizeof(S21243C44)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21243C44)");
    check_field_offset(lv, s21243c44f0, 0, "S21243C44.s21243c44f0");
    check_field_offset(lv, s21243c44f1, ABISELECT(24,12), "S21243C44.s21243c44f1");
    check_field_offset(lv, s21243c44f2, ABISELECT(40,28), "S21243C44.s21243c44f2");
    check_field_offset(lv, s21243c44f3, ABISELECT(56,44), "S21243C44.s21243c44f3");
    check_field_offset(lv, s21243c44f4, ABISELECT(72,60), "S21243C44.s21243c44f4");
    check_field_offset(lv, s21243c44f5, ABISELECT(88,76), "S21243C44.s21243c44f5");
    check_field_offset(lv, s21243c44f6, ABISELECT(104,92), "S21243C44.s21243c44f6");
    check_field_offset(lv, s21243c44f7, ABISELECT(120,108), "S21243C44.s21243c44f7");
  }
}
static Arrange_To_Call_Me vS21243C44(Test_S21243C44, "S21243C44", ABISELECT(136,124));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21243C48  {
  void *s21243c48f0;
  int s21243c48f1;
  ::S2407C8_nt s21243c48f2;
  ::S249C31_nt s21243c48f3;
  void  mf21243c48(); // _ZN9S21243C4810mf21243c48Ev
};
//SIG(-1 S21243C48) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S21243C48 ::mf21243c48(){}

static void Test_S21243C48()
{
  {
    init_simple_test("S21243C48");
    S21243C48 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S21243C48)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21243C48)");
    check_field_offset(lv, s21243c48f0, 0, "S21243C48.s21243c48f0");
    check_field_offset(lv, s21243c48f1, ABISELECT(8,4), "S21243C48.s21243c48f1");
    check_field_offset(lv, s21243c48f2, ABISELECT(12,8), "S21243C48.s21243c48f2");
    check_field_offset(lv, s21243c48f3, ABISELECT(13,9), "S21243C48.s21243c48f3");
  }
}
static Arrange_To_Call_Me vS21243C48(Test_S21243C48, "S21243C48", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21243C51_nt  {
  void *s21243c51f0[2];
  void  mf21243c51(); // _ZN12S21243C51_nt10mf21243c51Ev
};
//SIG(-1 S21243C51_nt) C1{ m Fp[2]}


void  S21243C51_nt ::mf21243c51(){}

//skip512 S21243C51_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21243C1  {
  char s21243c1f0;
  ::S2407C37 s21243c1f1;
  char s21243c1f2;
  ::S2407C25 s21243c1f3;
  ::S2407C26 s21243c1f4;
  char s21243c1f5[2];
  int s21243c1f6;
  char s21243c1f7[3];
  short s21243c1f8[2];
  ::S2407C22 s21243c1f9;
  ::S2407C22 s21243c1f10;
  ::S2407C22 s21243c1f11;
  char s21243c1f12;
  ::S249C37_nt s21243c1f13;
  ::S249C37_nt s21243c1f14;
  ::S249C37_nt s21243c1f15;
  ::S249C37_nt s21243c1f16;
  ::S249C37_nt s21243c1f17;
  ::S249C37_nt s21243c1f18;
  void *s21243c1f19;
  int s21243c1f20[2];
  void *s21243c1f21;
  char s21243c1f22;
  void *s21243c1f23[2];
  int s21243c1f24:8;
  int s21243c1f25:8;
  int s21243c1f26;
  char s21243c1f27[5];
  void *s21243c1f28[6];
  ::S21243C15 s21243c1f29;
  void *s21243c1f30[2];
  ::S21243C15 s21243c1f31;
  ::S2407C5_nt s21243c1f32;
  void *s21243c1f33;
  ::S21243C15 s21243c1f34;
  int s21243c1f35;
  char s21243c1f36[3];
  ::S21243C22 s21243c1f37[2];
  ::S21243C28_nt s21243c1f38;
  void *s21243c1f39[10];
  ::S21243C29 s21243c1f40;
  ::S2407C6_nt s21243c1f41;
  ::S2407C6_nt s21243c1f42;
  ::S21243C36_nt s21243c1f43;
  void *s21243c1f44;
  ::S21243C39 s21243c1f45[16];
  ::S21243C41 s21243c1f46[16];
  ::S21243C41 s21243c1f47[16];
  ::S21243C42 s21243c1f48[16];
  ::S21243C43 s21243c1f49[16];
  ::S21243C44 s21243c1f50[2];
  ::S21243C36_nt s21243c1f51;
  ::S21243C48 s21243c1f52;
  int s21243c1f53[2];
  void *s21243c1f54[6];
  char s21243c1f55[7];
  int s21243c1f56;
  ::S21243C28_nt s21243c1f57;
  ::S21243C28_nt s21243c1f58;
  ::S21243C28_nt s21243c1f59;
  int s21243c1f60[4];
  ::S21243C51_nt s21243c1f61;
  void  mf21243c1(); // _ZN8S21243C19mf21243c1Ev
  virtual  ~S21243C1(); // _ZN8S21243C1D1Ev
  S21243C1(); // tgen
};
//SIG(1 S21243C1) C1{ vd m Fc FC2{ m Fp Fi[2] FC3{ m}} Fc FC4{ BC5{ m Fp Fi FC6{ m} FC6}} FC5 Fc[2] Fi Fc[3] Fs[2] FC7{ m Fp Fi FC8{ m} FC8} FC7 FC7 Fc FC9{ m Fp[2]} FC9 FC9 FC9 FC9 FC9 Fp Fi[2] Fp Fc Fp[2] Fi:8 Fi:8 Fi Fc[5] Fp[6] FC10{ m Fp Fc FC11{ m Fp Fi[2] FC3}} Fp[2] FC10 FC12{ BC13{ m Fp Fi FC14{ m} FC15{ m}}} Fp FC10 Fi Fc[3] FC16{ m Fp[4] FC17{ m FC18{ m FL[2]}} FC17 FC17 FC17 FC17 FC19{ m FC17} Fi[2] FC20{ m Fl} Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 FC21{ Fp[2] Fi} Fi FC22{ m Fp} Fc Fi}[2] FC22 Fp[10] FC23{ vd m FC24{ m Fp Fi[2] FC3} FC25{ m FC26{ Fl[4]}}} FC13 FC13 FC27{ m Fp Fi FC6 FC8} Fp FC28{ m Fi[3] Fc Fi[4] FC17 FC17 FC29{ m FC17 FC17 FC17 FC17}}[16] FC30{ m FC17 FC17 FC17 FC17 FC17 FC19 FC17 FC17 Fi[3] Fp}[16] FC30[16] FC31{ m Fi[2] Fp[2]}[16] FC32{ m Fi[2] Fp[2] FC30 FC17 FC17 FC17 FC17}[16] FC33{ m Fp[3] FC17 FC17 FC17 FC17 FC17 FC17 FC19}[2] FC27 FC34{ m Fp Fi FC15 FC14} Fi[2] Fp[6] Fc[7] Fi FC22 FC22 FC22 Fi[4] FC35{ m Fp[2]}}


void  S21243C1 ::mf21243c1(){}
 S21243C1 ::~S21243C1(){ note_dtor("S21243C1", this);}
S21243C1 ::S21243C1(){ note_ctor("S21243C1", this);} // tgen

static void Test_S21243C1()
{
  extern Class_Descriptor cd_S21243C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(1589,2903)];
    init_test(&cd_S21243C1, buf);
    S21243C1 *dp, &lv = *(dp=new (buf) S21243C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(12704,11608), "sizeof(S21243C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21243C1)");
    check_field_offset(lv, s21243c1f0, ABISELECT(8,4), "S21243C1.s21243c1f0");
    check_field_offset(lv, s21243c1f1, ABISELECT(16,8), "S21243C1.s21243c1f1");
    check_field_offset(lv, s21243c1f2, ABISELECT(40,24), "S21243C1.s21243c1f2");
    check_field_offset(lv, s21243c1f3, ABISELECT(48,28), "S21243C1.s21243c1f3");
    check_field_offset(lv, s21243c1f4, ABISELECT(64,40), "S21243C1.s21243c1f4");
    check_field_offset(lv, s21243c1f5, ABISELECT(80,52), "S21243C1.s21243c1f5");
    check_field_offset(lv, s21243c1f6, ABISELECT(84,56), "S21243C1.s21243c1f6");
    check_field_offset(lv, s21243c1f7, ABISELECT(88,60), "S21243C1.s21243c1f7");
    check_field_offset(lv, s21243c1f8, ABISELECT(92,64), "S21243C1.s21243c1f8");
    check_field_offset(lv, s21243c1f9, ABISELECT(96,68), "S21243C1.s21243c1f9");
    check_field_offset(lv, s21243c1f10, ABISELECT(112,80), "S21243C1.s21243c1f10");
    check_field_offset(lv, s21243c1f11, ABISELECT(128,92), "S21243C1.s21243c1f11");
    check_field_offset(lv, s21243c1f12, ABISELECT(144,104), "S21243C1.s21243c1f12");
    check_field_offset(lv, s21243c1f13, ABISELECT(152,108), "S21243C1.s21243c1f13");
    check_field_offset(lv, s21243c1f14, ABISELECT(168,116), "S21243C1.s21243c1f14");
    check_field_offset(lv, s21243c1f15, ABISELECT(184,124), "S21243C1.s21243c1f15");
    check_field_offset(lv, s21243c1f16, ABISELECT(200,132), "S21243C1.s21243c1f16");
    check_field_offset(lv, s21243c1f17, ABISELECT(216,140), "S21243C1.s21243c1f17");
    check_field_offset(lv, s21243c1f18, ABISELECT(232,148), "S21243C1.s21243c1f18");
    check_field_offset(lv, s21243c1f19, ABISELECT(248,156), "S21243C1.s21243c1f19");
    check_field_offset(lv, s21243c1f20, ABISELECT(256,160), "S21243C1.s21243c1f20");
    check_field_offset(lv, s21243c1f21, ABISELECT(264,168), "S21243C1.s21243c1f21");
    check_field_offset(lv, s21243c1f22, ABISELECT(272,172), "S21243C1.s21243c1f22");
    check_field_offset(lv, s21243c1f23, ABISELECT(280,176), "S21243C1.s21243c1f23");
    set_bf_and_test(lv, s21243c1f24, ABISELECT(296,184), 0, 8, 1, "S21243C1");
    set_bf_and_test(lv, s21243c1f24, ABISELECT(296,184), 0, 8, hide_sll(1LL<<7), "S21243C1");
    set_bf_and_test(lv, s21243c1f25, ABISELECT(297,185), 0, 8, 1, "S21243C1");
    set_bf_and_test(lv, s21243c1f25, ABISELECT(297,185), 0, 8, hide_sll(1LL<<7), "S21243C1");
    check_field_offset(lv, s21243c1f26, ABISELECT(300,188), "S21243C1.s21243c1f26");
    check_field_offset(lv, s21243c1f27, ABISELECT(304,192), "S21243C1.s21243c1f27");
    check_field_offset(lv, s21243c1f28, ABISELECT(312,200), "S21243C1.s21243c1f28");
    check_field_offset(lv, s21243c1f29, ABISELECT(360,224), "S21243C1.s21243c1f29");
    check_field_offset(lv, s21243c1f30, ABISELECT(400,248), "S21243C1.s21243c1f30");
    check_field_offset(lv, s21243c1f31, ABISELECT(416,256), "S21243C1.s21243c1f31");
    check_field_offset(lv, s21243c1f32, ABISELECT(456,280), "S21243C1.s21243c1f32");
    check_field_offset(lv, s21243c1f33, ABISELECT(472,292), "S21243C1.s21243c1f33");
    check_field_offset(lv, s21243c1f34, ABISELECT(480,296), "S21243C1.s21243c1f34");
    check_field_offset(lv, s21243c1f35, ABISELECT(520,320), "S21243C1.s21243c1f35");
    check_field_offset(lv, s21243c1f36, ABISELECT(524,324), "S21243C1.s21243c1f36");
    check_field_offset(lv, s21243c1f37, ABISELECT(528,328), "S21243C1.s21243c1f37");
    check_field_offset(lv, s21243c1f38, ABISELECT(928,640), "S21243C1.s21243c1f38");
    check_field_offset(lv, s21243c1f39, ABISELECT(936,644), "S21243C1.s21243c1f39");
    check_field_offset(lv, s21243c1f40, ABISELECT(1016,684), "S21243C1.s21243c1f40");
    check_field_offset(lv, s21243c1f41, ABISELECT(1080,720), "S21243C1.s21243c1f41");
    check_field_offset(lv, s21243c1f42, ABISELECT(1096,732), "S21243C1.s21243c1f42");
    check_field_offset(lv, s21243c1f43, ABISELECT(1112,744), "S21243C1.s21243c1f43");
    check_field_offset(lv, s21243c1f44, ABISELECT(1128,756), "S21243C1.s21243c1f44");
    check_field_offset(lv, s21243c1f45, ABISELECT(1136,760), "S21243C1.s21243c1f45");
    check_field_offset(lv, s21243c1f46, ABISELECT(3184,2808), "S21243C1.s21243c1f46");
    check_field_offset(lv, s21243c1f47, ABISELECT(5616,5112), "S21243C1.s21243c1f47");
    check_field_offset(lv, s21243c1f48, ABISELECT(8048,7416), "S21243C1.s21243c1f48");
    check_field_offset(lv, s21243c1f49, ABISELECT(8432,7672), "S21243C1.s21243c1f49");
    check_field_offset(lv, s21243c1f50, ABISELECT(12272,11256), "S21243C1.s21243c1f50");
    check_field_offset(lv, s21243c1f51, ABISELECT(12544,11504), "S21243C1.s21243c1f51");
    check_field_offset(lv, s21243c1f52, ABISELECT(12560,11516), "S21243C1.s21243c1f52");
    check_field_offset(lv, s21243c1f53, ABISELECT(12576,11528), "S21243C1.s21243c1f53");
    check_field_offset(lv, s21243c1f54, ABISELECT(12584,11536), "S21243C1.s21243c1f54");
    check_field_offset(lv, s21243c1f55, ABISELECT(12632,11560), "S21243C1.s21243c1f55");
    check_field_offset(lv, s21243c1f56, ABISELECT(12640,11568), "S21243C1.s21243c1f56");
    check_field_offset(lv, s21243c1f57, ABISELECT(12648,11572), "S21243C1.s21243c1f57");
    check_field_offset(lv, s21243c1f58, ABISELECT(12656,11576), "S21243C1.s21243c1f58");
    check_field_offset(lv, s21243c1f59, ABISELECT(12664,11580), "S21243C1.s21243c1f59");
    check_field_offset(lv, s21243c1f60, ABISELECT(12672,11584), "S21243C1.s21243c1f60");
    check_field_offset(lv, s21243c1f61, ABISELECT(12688,11600), "S21243C1.s21243c1f61");
    test_class_info(&lv, &cd_S21243C1);
    dp->~S21243C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21243C1(Test_S21243C1, "S21243C1", ABISELECT(12704,11608));

#else // __cplusplus

extern void _ZN8S21243C1C1Ev();
extern void _ZN8S21243C1D1Ev();
Name_Map name_map_S21243C1[] = {
  NSPAIR(_ZN8S21243C1C1Ev),
  NSPAIR(_ZN8S21243C1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S21243C1[];
extern void _ZN8S21243C1D1Ev();
extern void _ZN8S21243C1D0Ev();
static  VTBL_ENTRY vtc_S21243C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S21243C1[0]),
  (VTBL_ENTRY)&_ZN8S21243C1D1Ev,
  (VTBL_ENTRY)&_ZN8S21243C1D0Ev,
};
extern VTBL_ENTRY _ZTI8S21243C1[];
extern  VTBL_ENTRY _ZTV8S21243C1[];
Class_Descriptor cd_S21243C1 = {  "S21243C1", // class name
  0,0,//no base classes
  &(vtc_S21243C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(12704,11608), // object size
  NSPAIRA(_ZTI8S21243C1),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S21243C1),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21244C26_nt  {
  __tsi64 s21244c26f0;
  void  mf21244c26(); // _ZN12S21244C26_nt10mf21244c26Ev
};
//SIG(-1 S21244C26_nt) C1{ m FL}


void  S21244C26_nt ::mf21244c26(){}

//skip512 S21244C26_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21244C22  {
  void *s21244c22f0[4];
  ::S2407C13_nt s21244c22f1;
  ::S2407C13_nt s21244c22f2;
  ::S2407C13_nt s21244c22f3;
  ::S2407C13_nt s21244c22f4;
  ::S2407C13_nt s21244c22f5;
  ::S2407C17_nt s21244c22f6;
  int s21244c22f7[2];
  ::S21244C26_nt s21244c22f8;
  unsigned char s21244c22f9:1;
  unsigned char s21244c22f10:1;
  unsigned char s21244c22f11:1;
  unsigned char s21244c22f12:1;
  unsigned char s21244c22f13:1;
  ::S21243C27 s21244c22f14;
  int s21244c22f15;
  ::S21243C28_nt s21244c22f16;
  char s21244c22f17;
  int s21244c22f18;
  void  mf21244c22(); // _ZN9S21244C2210mf21244c22Ev
};
//SIG(1 S21244C22) C1{ m Fp[4] FC2{ m FC3{ m FL[2]}} FC2 FC2 FC2 FC2 FC4{ m FC2} Fi[2] FC5{ m FL} Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 FC6{ Fp[2] Fi} Fi FC7{ m Fp} Fc Fi}


void  S21244C22 ::mf21244c22(){}

static void Test_S21244C22()
{
  {
    init_simple_test("S21244C22");
    static S21244C22 lv;
    check2(sizeof(lv), ABISELECT(200,160), "sizeof(S21244C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21244C22)");
    check_field_offset(lv, s21244c22f0, 0, "S21244C22.s21244c22f0");
    check_field_offset(lv, s21244c22f1, ABISELECT(32,16), "S21244C22.s21244c22f1");
    check_field_offset(lv, s21244c22f2, ABISELECT(48,32), "S21244C22.s21244c22f2");
    check_field_offset(lv, s21244c22f3, ABISELECT(64,48), "S21244C22.s21244c22f3");
    check_field_offset(lv, s21244c22f4, ABISELECT(80,64), "S21244C22.s21244c22f4");
    check_field_offset(lv, s21244c22f5, ABISELECT(96,80), "S21244C22.s21244c22f5");
    check_field_offset(lv, s21244c22f6, ABISELECT(112,96), "S21244C22.s21244c22f6");
    check_field_offset(lv, s21244c22f7, ABISELECT(128,112), "S21244C22.s21244c22f7");
    check_field_offset(lv, s21244c22f8, ABISELECT(136,120), "S21244C22.s21244c22f8");
    set_bf_and_test(lv, s21244c22f9, ABISELECT(144,128), 0, 1, 1, "S21244C22");
    set_bf_and_test(lv, s21244c22f10, ABISELECT(144,128), 1, 1, 1, "S21244C22");
    set_bf_and_test(lv, s21244c22f11, ABISELECT(144,128), 2, 1, 1, "S21244C22");
    set_bf_and_test(lv, s21244c22f12, ABISELECT(144,128), 3, 1, 1, "S21244C22");
    set_bf_and_test(lv, s21244c22f13, ABISELECT(144,128), 4, 1, 1, "S21244C22");
    check_field_offset(lv, s21244c22f14, ABISELECT(152,132), "S21244C22.s21244c22f14");
    check_field_offset(lv, s21244c22f15, ABISELECT(176,144), "S21244C22.s21244c22f15");
    check_field_offset(lv, s21244c22f16, ABISELECT(184,148), "S21244C22.s21244c22f16");
    check_field_offset(lv, s21244c22f17, ABISELECT(192,152), "S21244C22.s21244c22f17");
    check_field_offset(lv, s21244c22f18, ABISELECT(196,156), "S21244C22.s21244c22f18");
  }
}
static Arrange_To_Call_Me vS21244C22(Test_S21244C22, "S21244C22", ABISELECT(200,160));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21244C33_nt  {
  __tsi64 s21244c33f0[4];
};
//SIG(-1 S21244C33_nt) C1{ FL[4]}



//skip512 S21244C33_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21244C32_nt  {
  ::S21244C33_nt s21244c32f0;
  void  mf21244c32(); // _ZN12S21244C32_nt10mf21244c32Ev
};
//SIG(-1 S21244C32_nt) C1{ m FC2{ FL[4]}}


void  S21244C32_nt ::mf21244c32(){}

//skip512 S21244C32_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21244C29  {
  ::S2407C37 s21244c29f0;
  ::S21244C32_nt s21244c29f1;
  void  mf21244c29(); // _ZN9S21244C2910mf21244c29Ev
  virtual  ~S21244C29(); // _ZN9S21244C29D1Ev
  S21244C29(); // tgen
};
//SIG(-1 S21244C29) C1{ vd m FC2{ m Fp Fi[2] FC3{ m}} FC4{ m FC5{ FL[4]}}}


void  S21244C29 ::mf21244c29(){}
 S21244C29 ::~S21244C29(){ note_dtor("S21244C29", this);}
S21244C29 ::S21244C29(){ note_ctor("S21244C29", this);} // tgen

static void Test_S21244C29()
{
  extern Class_Descriptor cd_S21244C29;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,14)];
    init_test(&cd_S21244C29, buf);
    S21244C29 *dp, &lv = *(dp=new (buf) S21244C29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,52), "sizeof(S21244C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21244C29)");
    check_field_offset(lv, s21244c29f0, ABISELECT(8,4), "S21244C29.s21244c29f0");
    check_field_offset(lv, s21244c29f1, ABISELECT(32,20), "S21244C29.s21244c29f1");
    test_class_info(&lv, &cd_S21244C29);
    dp->~S21244C29();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21244C29(Test_S21244C29, "S21244C29", ABISELECT(64,52));

#else // __cplusplus

extern void _ZN9S21244C29C1Ev();
extern void _ZN9S21244C29D1Ev();
Name_Map name_map_S21244C29[] = {
  NSPAIR(_ZN9S21244C29C1Ev),
  NSPAIR(_ZN9S21244C29D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S21244C29[];
extern void _ZN9S21244C29D1Ev();
extern void _ZN9S21244C29D0Ev();
static  VTBL_ENTRY vtc_S21244C29[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S21244C29[0]),
  (VTBL_ENTRY)&_ZN9S21244C29D1Ev,
  (VTBL_ENTRY)&_ZN9S21244C29D0Ev,
};
extern VTBL_ENTRY _ZTI9S21244C29[];
extern  VTBL_ENTRY _ZTV9S21244C29[];
Class_Descriptor cd_S21244C29 = {  "S21244C29", // class name
  0,0,//no base classes
  &(vtc_S21244C29[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,52), // object size
  NSPAIRA(_ZTI9S21244C29),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S21244C29),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21244C48  {
  void *s21244c48f0;
  int s21244c48f1;
  ::S2407C30 s21244c48f2;
  ::S2407C27 s21244c48f3;
  void  mf21244c48(); // _ZN9S21244C4810mf21244c48Ev
};
//SIG(-1 S21244C48) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S21244C48 ::mf21244c48(){}

static void Test_S21244C48()
{
  {
    init_simple_test("S21244C48");
    S21244C48 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S21244C48)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21244C48)");
    check_field_offset(lv, s21244c48f0, 0, "S21244C48.s21244c48f0");
    check_field_offset(lv, s21244c48f1, ABISELECT(8,4), "S21244C48.s21244c48f1");
    check_field_offset(lv, s21244c48f2, ABISELECT(12,8), "S21244C48.s21244c48f2");
    check_field_offset(lv, s21244c48f3, ABISELECT(13,9), "S21244C48.s21244c48f3");
  }
}
static Arrange_To_Call_Me vS21244C48(Test_S21244C48, "S21244C48", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21244C1  {
  char s21244c1f0;
  ::S21243C30_nt s21244c1f1;
  char s21244c1f2;
  ::S2407C25 s21244c1f3;
  ::S21243C48 s21244c1f4;
  char s21244c1f5[2];
  int s21244c1f6;
  char s21244c1f7[3];
  short s21244c1f8[2];
  ::S21243C36_nt s21244c1f9;
  ::S21243C36_nt s21244c1f10;
  ::S21243C36_nt s21244c1f11;
  char s21244c1f12;
  ::S21243C51_nt s21244c1f13;
  ::S21243C51_nt s21244c1f14;
  ::S21243C51_nt s21244c1f15;
  ::S21243C51_nt s21244c1f16;
  ::S21243C51_nt s21244c1f17;
  ::S21243C51_nt s21244c1f18;
  void *s21244c1f19;
  int s21244c1f20[2];
  void *s21244c1f21;
  char s21244c1f22;
  void *s21244c1f23[2];
  int s21244c1f24:8;
  int s21244c1f25:8;
  int s21244c1f26;
  char s21244c1f27[5];
  void *s21244c1f28[6];
  ::S21243C15 s21244c1f29;
  void *s21244c1f30[2];
  ::S21243C15 s21244c1f31;
  ::S2407C5_nt s21244c1f32;
  void *s21244c1f33;
  ::S21243C15 s21244c1f34;
  int s21244c1f35;
  char s21244c1f36[3];
  ::S21244C22 s21244c1f37[2];
  ::S21243C28_nt s21244c1f38;
  void *s21244c1f39[10];
  ::S21244C29 s21244c1f40;
  ::S2407C26 s21244c1f41;
  ::S2407C26 s21244c1f42;
  ::S2407C22 s21244c1f43;
  void *s21244c1f44;
  ::S21243C39 s21244c1f45[16];
  ::S21243C41 s21244c1f46[16];
  ::S21243C41 s21244c1f47[16];
  ::S21243C42 s21244c1f48[16];
  ::S21243C43 s21244c1f49[16];
  ::S21243C44 s21244c1f50[2];
  ::S2407C6_nt s21244c1f51;
  ::S21244C48 s21244c1f52;
  int s21244c1f53[2];
  void *s21244c1f54[6];
  char s21244c1f55[7];
  int s21244c1f56;
  ::S21243C28_nt s21244c1f57;
  ::S21243C28_nt s21244c1f58;
  ::S21243C28_nt s21244c1f59;
  int s21244c1f60[4];
  ::S249C37_nt s21244c1f61;
  void  mf21244c1(); // _ZN8S21244C19mf21244c1Ev
  virtual  ~S21244C1(); // _ZN8S21244C1D1Ev
  S21244C1(); // tgen
};
//SIG(1 S21244C1) C1{ vd m Fc FC2{ m Fp Fi[2] FC3{ m}} Fc FC4{ BC5{ m Fp Fi FC6{ m} FC6}} FC7{ m Fp Fi FC8{ m} FC9{ m}} Fc[2] Fi Fc[3] Fs[2] FC10{ m Fp Fi FC6 FC11{ m}} FC10 FC10 Fc FC12{ m Fp[2]} FC12 FC12 FC12 FC12 FC12 Fp Fi[2] Fp Fc Fp[2] Fi:8 Fi:8 Fi Fc[5] Fp[6] FC13{ m Fp Fc FC14{ m Fp Fi[2] FC3}} Fp[2] FC13 FC15{ BC16{ m Fp Fi FC9 FC8}} Fp FC13 Fi Fc[3] FC17{ m Fp[4] FC18{ m FC19{ m FL[2]}} FC18 FC18 FC18 FC18 FC20{ m FC18} Fi[2] FC21{ m FL} Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 FC22{ Fp[2] Fi} Fi FC23{ m Fp} Fc Fi}[2] FC23 Fp[10] FC24{ vd m FC25{ m Fp Fi[2] FC3} FC26{ m FC27{ FL[4]}}} FC5 FC5 FC28{ m Fp Fi FC11 FC11} Fp FC29{ m Fi[3] Fc Fi[4] FC18 FC18 FC30{ m FC18 FC18 FC18 FC18}}[16] FC31{ m FC18 FC18 FC18 FC18 FC18 FC20 FC18 FC18 Fi[3] Fp}[16] FC31[16] FC32{ m Fi[2] Fp[2]}[16] FC33{ m Fi[2] Fp[2] FC31 FC18 FC18 FC18 FC18}[16] FC34{ m Fp[3] FC18 FC18 FC18 FC18 FC18 FC18 FC20}[2] FC16 FC35{ m Fp Fi FC3 FC6} Fi[2] Fp[6] Fc[7] Fi FC23 FC23 FC23 Fi[4] FC36{ m Fp[2]}}


void  S21244C1 ::mf21244c1(){}
 S21244C1 ::~S21244C1(){ note_dtor("S21244C1", this);}
S21244C1 ::S21244C1(){ note_ctor("S21244C1", this);} // tgen

static void Test_S21244C1()
{
  extern Class_Descriptor cd_S21244C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(1589,2909)];
    init_test(&cd_S21244C1, buf);
    S21244C1 *dp, &lv = *(dp=new (buf) S21244C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(12704,11632), "sizeof(S21244C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21244C1)");
    check_field_offset(lv, s21244c1f0, ABISELECT(8,4), "S21244C1.s21244c1f0");
    check_field_offset(lv, s21244c1f1, ABISELECT(16,8), "S21244C1.s21244c1f1");
    check_field_offset(lv, s21244c1f2, ABISELECT(40,24), "S21244C1.s21244c1f2");
    check_field_offset(lv, s21244c1f3, ABISELECT(48,28), "S21244C1.s21244c1f3");
    check_field_offset(lv, s21244c1f4, ABISELECT(64,40), "S21244C1.s21244c1f4");
    check_field_offset(lv, s21244c1f5, ABISELECT(80,52), "S21244C1.s21244c1f5");
    check_field_offset(lv, s21244c1f6, ABISELECT(84,56), "S21244C1.s21244c1f6");
    check_field_offset(lv, s21244c1f7, ABISELECT(88,60), "S21244C1.s21244c1f7");
    check_field_offset(lv, s21244c1f8, ABISELECT(92,64), "S21244C1.s21244c1f8");
    check_field_offset(lv, s21244c1f9, ABISELECT(96,68), "S21244C1.s21244c1f9");
    check_field_offset(lv, s21244c1f10, ABISELECT(112,80), "S21244C1.s21244c1f10");
    check_field_offset(lv, s21244c1f11, ABISELECT(128,92), "S21244C1.s21244c1f11");
    check_field_offset(lv, s21244c1f12, ABISELECT(144,104), "S21244C1.s21244c1f12");
    check_field_offset(lv, s21244c1f13, ABISELECT(152,108), "S21244C1.s21244c1f13");
    check_field_offset(lv, s21244c1f14, ABISELECT(168,116), "S21244C1.s21244c1f14");
    check_field_offset(lv, s21244c1f15, ABISELECT(184,124), "S21244C1.s21244c1f15");
    check_field_offset(lv, s21244c1f16, ABISELECT(200,132), "S21244C1.s21244c1f16");
    check_field_offset(lv, s21244c1f17, ABISELECT(216,140), "S21244C1.s21244c1f17");
    check_field_offset(lv, s21244c1f18, ABISELECT(232,148), "S21244C1.s21244c1f18");
    check_field_offset(lv, s21244c1f19, ABISELECT(248,156), "S21244C1.s21244c1f19");
    check_field_offset(lv, s21244c1f20, ABISELECT(256,160), "S21244C1.s21244c1f20");
    check_field_offset(lv, s21244c1f21, ABISELECT(264,168), "S21244C1.s21244c1f21");
    check_field_offset(lv, s21244c1f22, ABISELECT(272,172), "S21244C1.s21244c1f22");
    check_field_offset(lv, s21244c1f23, ABISELECT(280,176), "S21244C1.s21244c1f23");
    set_bf_and_test(lv, s21244c1f24, ABISELECT(296,184), 0, 8, 1, "S21244C1");
    set_bf_and_test(lv, s21244c1f24, ABISELECT(296,184), 0, 8, hide_sll(1LL<<7), "S21244C1");
    set_bf_and_test(lv, s21244c1f25, ABISELECT(297,185), 0, 8, 1, "S21244C1");
    set_bf_and_test(lv, s21244c1f25, ABISELECT(297,185), 0, 8, hide_sll(1LL<<7), "S21244C1");
    check_field_offset(lv, s21244c1f26, ABISELECT(300,188), "S21244C1.s21244c1f26");
    check_field_offset(lv, s21244c1f27, ABISELECT(304,192), "S21244C1.s21244c1f27");
    check_field_offset(lv, s21244c1f28, ABISELECT(312,200), "S21244C1.s21244c1f28");
    check_field_offset(lv, s21244c1f29, ABISELECT(360,224), "S21244C1.s21244c1f29");
    check_field_offset(lv, s21244c1f30, ABISELECT(400,248), "S21244C1.s21244c1f30");
    check_field_offset(lv, s21244c1f31, ABISELECT(416,256), "S21244C1.s21244c1f31");
    check_field_offset(lv, s21244c1f32, ABISELECT(456,280), "S21244C1.s21244c1f32");
    check_field_offset(lv, s21244c1f33, ABISELECT(472,292), "S21244C1.s21244c1f33");
    check_field_offset(lv, s21244c1f34, ABISELECT(480,296), "S21244C1.s21244c1f34");
    check_field_offset(lv, s21244c1f35, ABISELECT(520,320), "S21244C1.s21244c1f35");
    check_field_offset(lv, s21244c1f36, ABISELECT(524,324), "S21244C1.s21244c1f36");
    check_field_offset(lv, s21244c1f37, ABISELECT(528,328), "S21244C1.s21244c1f37");
    check_field_offset(lv, s21244c1f38, ABISELECT(928,648), "S21244C1.s21244c1f38");
    check_field_offset(lv, s21244c1f39, ABISELECT(936,652), "S21244C1.s21244c1f39");
    check_field_offset(lv, s21244c1f40, ABISELECT(1016,692), "S21244C1.s21244c1f40");
    check_field_offset(lv, s21244c1f41, ABISELECT(1080,744), "S21244C1.s21244c1f41");
    check_field_offset(lv, s21244c1f42, ABISELECT(1096,756), "S21244C1.s21244c1f42");
    check_field_offset(lv, s21244c1f43, ABISELECT(1112,768), "S21244C1.s21244c1f43");
    check_field_offset(lv, s21244c1f44, ABISELECT(1128,780), "S21244C1.s21244c1f44");
    check_field_offset(lv, s21244c1f45, ABISELECT(1136,784), "S21244C1.s21244c1f45");
    check_field_offset(lv, s21244c1f46, ABISELECT(3184,2832), "S21244C1.s21244c1f46");
    check_field_offset(lv, s21244c1f47, ABISELECT(5616,5136), "S21244C1.s21244c1f47");
    check_field_offset(lv, s21244c1f48, ABISELECT(8048,7440), "S21244C1.s21244c1f48");
    check_field_offset(lv, s21244c1f49, ABISELECT(8432,7696), "S21244C1.s21244c1f49");
    check_field_offset(lv, s21244c1f50, ABISELECT(12272,11280), "S21244C1.s21244c1f50");
    check_field_offset(lv, s21244c1f51, ABISELECT(12544,11528), "S21244C1.s21244c1f51");
    check_field_offset(lv, s21244c1f52, ABISELECT(12560,11540), "S21244C1.s21244c1f52");
    check_field_offset(lv, s21244c1f53, ABISELECT(12576,11552), "S21244C1.s21244c1f53");
    check_field_offset(lv, s21244c1f54, ABISELECT(12584,11560), "S21244C1.s21244c1f54");
    check_field_offset(lv, s21244c1f55, ABISELECT(12632,11584), "S21244C1.s21244c1f55");
    check_field_offset(lv, s21244c1f56, ABISELECT(12640,11592), "S21244C1.s21244c1f56");
    check_field_offset(lv, s21244c1f57, ABISELECT(12648,11596), "S21244C1.s21244c1f57");
    check_field_offset(lv, s21244c1f58, ABISELECT(12656,11600), "S21244C1.s21244c1f58");
    check_field_offset(lv, s21244c1f59, ABISELECT(12664,11604), "S21244C1.s21244c1f59");
    check_field_offset(lv, s21244c1f60, ABISELECT(12672,11608), "S21244C1.s21244c1f60");
    check_field_offset(lv, s21244c1f61, ABISELECT(12688,11624), "S21244C1.s21244c1f61");
    test_class_info(&lv, &cd_S21244C1);
    dp->~S21244C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21244C1(Test_S21244C1, "S21244C1", ABISELECT(12704,11632));

#else // __cplusplus

extern void _ZN8S21244C1C1Ev();
extern void _ZN8S21244C1D1Ev();
Name_Map name_map_S21244C1[] = {
  NSPAIR(_ZN8S21244C1C1Ev),
  NSPAIR(_ZN8S21244C1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S21244C1[];
extern void _ZN8S21244C1D1Ev();
extern void _ZN8S21244C1D0Ev();
static  VTBL_ENTRY vtc_S21244C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S21244C1[0]),
  (VTBL_ENTRY)&_ZN8S21244C1D1Ev,
  (VTBL_ENTRY)&_ZN8S21244C1D0Ev,
};
extern VTBL_ENTRY _ZTI8S21244C1[];
extern  VTBL_ENTRY _ZTV8S21244C1[];
Class_Descriptor cd_S21244C1 = {  "S21244C1", // class name
  0,0,//no base classes
  &(vtc_S21244C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(12704,11632), // object size
  NSPAIRA(_ZTI8S21244C1),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S21244C1),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21245C32_nt  {
  __tsi64 s21245c32f0[4];
  void  mf21245c32(); // _ZN12S21245C32_nt10mf21245c32Ev
};
//SIG(-1 S21245C32_nt) C1{ m FL[4]}


void  S21245C32_nt ::mf21245c32(){}

//skip512 S21245C32_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21245C29  {
  ::S2407C37 s21245c29f0;
  ::S21245C32_nt s21245c29f1;
  void  mf21245c29(); // _ZN9S21245C2910mf21245c29Ev
  virtual  ~S21245C29(); // _ZN9S21245C29D1Ev
  S21245C29(); // tgen
};
//SIG(-1 S21245C29) C1{ vd m FC2{ m Fp Fi[2] FC3{ m}} FC4{ m FL[4]}}


void  S21245C29 ::mf21245c29(){}
 S21245C29 ::~S21245C29(){ note_dtor("S21245C29", this);}
S21245C29 ::S21245C29(){ note_ctor("S21245C29", this);} // tgen

static void Test_S21245C29()
{
  extern Class_Descriptor cd_S21245C29;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,14)];
    init_test(&cd_S21245C29, buf);
    S21245C29 *dp, &lv = *(dp=new (buf) S21245C29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,52), "sizeof(S21245C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21245C29)");
    check_field_offset(lv, s21245c29f0, ABISELECT(8,4), "S21245C29.s21245c29f0");
    check_field_offset(lv, s21245c29f1, ABISELECT(32,20), "S21245C29.s21245c29f1");
    test_class_info(&lv, &cd_S21245C29);
    dp->~S21245C29();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21245C29(Test_S21245C29, "S21245C29", ABISELECT(64,52));

#else // __cplusplus

extern void _ZN9S21245C29C1Ev();
extern void _ZN9S21245C29D1Ev();
Name_Map name_map_S21245C29[] = {
  NSPAIR(_ZN9S21245C29C1Ev),
  NSPAIR(_ZN9S21245C29D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S21245C29[];
extern void _ZN9S21245C29D1Ev();
extern void _ZN9S21245C29D0Ev();
static  VTBL_ENTRY vtc_S21245C29[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S21245C29[0]),
  (VTBL_ENTRY)&_ZN9S21245C29D1Ev,
  (VTBL_ENTRY)&_ZN9S21245C29D0Ev,
};
extern VTBL_ENTRY _ZTI9S21245C29[];
extern  VTBL_ENTRY _ZTV9S21245C29[];
Class_Descriptor cd_S21245C29 = {  "S21245C29", // class name
  0,0,//no base classes
  &(vtc_S21245C29[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,52), // object size
  NSPAIRA(_ZTI9S21245C29),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S21245C29),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21245C1  {
  char s21245c1f0;
  ::S21243C30_nt s21245c1f1;
  char s21245c1f2;
  ::S2407C25 s21245c1f3;
  ::S21244C48 s21245c1f4;
  char s21245c1f5[2];
  int s21245c1f6;
  char s21245c1f7[3];
  short s21245c1f8[2];
  ::S21243C48 s21245c1f9;
  ::S21243C48 s21245c1f10;
  ::S21243C48 s21245c1f11;
  char s21245c1f12;
  ::S21243C51_nt s21245c1f13;
  ::S21243C51_nt s21245c1f14;
  ::S21243C51_nt s21245c1f15;
  ::S21243C51_nt s21245c1f16;
  ::S21243C51_nt s21245c1f17;
  ::S21243C51_nt s21245c1f18;
  void *s21245c1f19;
  int s21245c1f20[2];
  void *s21245c1f21;
  char s21245c1f22;
  void *s21245c1f23[2];
  int s21245c1f24:8;
  int s21245c1f25:8;
  int s21245c1f26;
  char s21245c1f27[5];
  void *s21245c1f28[6];
  ::S21243C15 s21245c1f29;
  void *s21245c1f30[2];
  ::S21243C15 s21245c1f31;
  ::S2407C5_nt s21245c1f32;
  void *s21245c1f33;
  ::S21243C15 s21245c1f34;
  int s21245c1f35;
  char s21245c1f36[3];
  ::S21244C22 s21245c1f37[2];
  ::S21243C28_nt s21245c1f38;
  void *s21245c1f39[10];
  ::S21245C29 s21245c1f40;
  ::S21243C36_nt s21245c1f41;
  ::S21243C36_nt s21245c1f42;
  ::S2407C26 s21245c1f43;
  void *s21245c1f44;
  ::S21243C39 s21245c1f45[16];
  ::S21243C41 s21245c1f46[16];
  ::S21243C41 s21245c1f47[16];
  ::S21243C42 s21245c1f48[16];
  ::S21243C43 s21245c1f49[16];
  ::S21243C44 s21245c1f50[2];
  ::S2407C22 s21245c1f51;
  ::S2407C6_nt s21245c1f52;
  int s21245c1f53[2];
  void *s21245c1f54[6];
  char s21245c1f55[7];
  int s21245c1f56;
  ::S21243C28_nt s21245c1f57;
  ::S21243C28_nt s21245c1f58;
  ::S21243C28_nt s21245c1f59;
  int s21245c1f60[4];
  ::S249C37_nt s21245c1f61;
  void  mf21245c1(); // _ZN8S21245C19mf21245c1Ev
  virtual  ~S21245C1(); // _ZN8S21245C1D1Ev
  S21245C1(); // tgen
};
//SIG(1 S21245C1) C1{ vd m Fc FC2{ m Fp Fi[2] FC3{ m}} Fc FC4{ BC5{ m Fp Fi FC6{ m} FC6}} FC7{ m Fp Fi FC3 FC6} Fc[2] Fi Fc[3] Fs[2] FC8{ m Fp Fi FC9{ m} FC10{ m}} FC8 FC8 Fc FC11{ m Fp[2]} FC11 FC11 FC11 FC11 FC11 Fp Fi[2] Fp Fc Fp[2] Fi:8 Fi:8 Fi Fc[5] Fp[6] FC12{ m Fp Fc FC13{ m Fp Fi[2] FC3}} Fp[2] FC12 FC14{ BC15{ m Fp Fi FC10 FC9}} Fp FC12 Fi Fc[3] FC16{ m Fp[4] FC17{ m FC18{ m FL[2]}} FC17 FC17 FC17 FC17 FC19{ m FC17} Fi[2] FC20{ m FL} Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 FC21{ Fp[2] Fi} Fi FC22{ m Fp} Fc Fi}[2] FC22 Fp[10] FC23{ vd m FC24{ m Fp Fi[2] FC3} FC25{ m FL[4]}} FC26{ m Fp Fi FC6 FC27{ m}} FC26 FC5 Fp FC28{ m Fi[3] Fc Fi[4] FC17 FC17 FC29{ m FC17 FC17 FC17 FC17}}[16] FC30{ m FC17 FC17 FC17 FC17 FC17 FC19 FC17 FC17 Fi[3] Fp}[16] FC30[16] FC31{ m Fi[2] Fp[2]}[16] FC32{ m Fi[2] Fp[2] FC30 FC17 FC17 FC17 FC17}[16] FC33{ m Fp[3] FC17 FC17 FC17 FC17 FC17 FC17 FC19}[2] FC34{ m Fp Fi FC27 FC27} FC15 Fi[2] Fp[6] Fc[7] Fi FC22 FC22 FC22 Fi[4] FC35{ m Fp[2]}}


void  S21245C1 ::mf21245c1(){}
 S21245C1 ::~S21245C1(){ note_dtor("S21245C1", this);}
S21245C1 ::S21245C1(){ note_ctor("S21245C1", this);} // tgen

static void Test_S21245C1()
{
  extern Class_Descriptor cd_S21245C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(1589,2909)];
    init_test(&cd_S21245C1, buf);
    S21245C1 *dp, &lv = *(dp=new (buf) S21245C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(12704,11632), "sizeof(S21245C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21245C1)");
    check_field_offset(lv, s21245c1f0, ABISELECT(8,4), "S21245C1.s21245c1f0");
    check_field_offset(lv, s21245c1f1, ABISELECT(16,8), "S21245C1.s21245c1f1");
    check_field_offset(lv, s21245c1f2, ABISELECT(40,24), "S21245C1.s21245c1f2");
    check_field_offset(lv, s21245c1f3, ABISELECT(48,28), "S21245C1.s21245c1f3");
    check_field_offset(lv, s21245c1f4, ABISELECT(64,40), "S21245C1.s21245c1f4");
    check_field_offset(lv, s21245c1f5, ABISELECT(80,52), "S21245C1.s21245c1f5");
    check_field_offset(lv, s21245c1f6, ABISELECT(84,56), "S21245C1.s21245c1f6");
    check_field_offset(lv, s21245c1f7, ABISELECT(88,60), "S21245C1.s21245c1f7");
    check_field_offset(lv, s21245c1f8, ABISELECT(92,64), "S21245C1.s21245c1f8");
    check_field_offset(lv, s21245c1f9, ABISELECT(96,68), "S21245C1.s21245c1f9");
    check_field_offset(lv, s21245c1f10, ABISELECT(112,80), "S21245C1.s21245c1f10");
    check_field_offset(lv, s21245c1f11, ABISELECT(128,92), "S21245C1.s21245c1f11");
    check_field_offset(lv, s21245c1f12, ABISELECT(144,104), "S21245C1.s21245c1f12");
    check_field_offset(lv, s21245c1f13, ABISELECT(152,108), "S21245C1.s21245c1f13");
    check_field_offset(lv, s21245c1f14, ABISELECT(168,116), "S21245C1.s21245c1f14");
    check_field_offset(lv, s21245c1f15, ABISELECT(184,124), "S21245C1.s21245c1f15");
    check_field_offset(lv, s21245c1f16, ABISELECT(200,132), "S21245C1.s21245c1f16");
    check_field_offset(lv, s21245c1f17, ABISELECT(216,140), "S21245C1.s21245c1f17");
    check_field_offset(lv, s21245c1f18, ABISELECT(232,148), "S21245C1.s21245c1f18");
    check_field_offset(lv, s21245c1f19, ABISELECT(248,156), "S21245C1.s21245c1f19");
    check_field_offset(lv, s21245c1f20, ABISELECT(256,160), "S21245C1.s21245c1f20");
    check_field_offset(lv, s21245c1f21, ABISELECT(264,168), "S21245C1.s21245c1f21");
    check_field_offset(lv, s21245c1f22, ABISELECT(272,172), "S21245C1.s21245c1f22");
    check_field_offset(lv, s21245c1f23, ABISELECT(280,176), "S21245C1.s21245c1f23");
    set_bf_and_test(lv, s21245c1f24, ABISELECT(296,184), 0, 8, 1, "S21245C1");
    set_bf_and_test(lv, s21245c1f24, ABISELECT(296,184), 0, 8, hide_sll(1LL<<7), "S21245C1");
    set_bf_and_test(lv, s21245c1f25, ABISELECT(297,185), 0, 8, 1, "S21245C1");
    set_bf_and_test(lv, s21245c1f25, ABISELECT(297,185), 0, 8, hide_sll(1LL<<7), "S21245C1");
    check_field_offset(lv, s21245c1f26, ABISELECT(300,188), "S21245C1.s21245c1f26");
    check_field_offset(lv, s21245c1f27, ABISELECT(304,192), "S21245C1.s21245c1f27");
    check_field_offset(lv, s21245c1f28, ABISELECT(312,200), "S21245C1.s21245c1f28");
    check_field_offset(lv, s21245c1f29, ABISELECT(360,224), "S21245C1.s21245c1f29");
    check_field_offset(lv, s21245c1f30, ABISELECT(400,248), "S21245C1.s21245c1f30");
    check_field_offset(lv, s21245c1f31, ABISELECT(416,256), "S21245C1.s21245c1f31");
    check_field_offset(lv, s21245c1f32, ABISELECT(456,280), "S21245C1.s21245c1f32");
    check_field_offset(lv, s21245c1f33, ABISELECT(472,292), "S21245C1.s21245c1f33");
    check_field_offset(lv, s21245c1f34, ABISELECT(480,296), "S21245C1.s21245c1f34");
    check_field_offset(lv, s21245c1f35, ABISELECT(520,320), "S21245C1.s21245c1f35");
    check_field_offset(lv, s21245c1f36, ABISELECT(524,324), "S21245C1.s21245c1f36");
    check_field_offset(lv, s21245c1f37, ABISELECT(528,328), "S21245C1.s21245c1f37");
    check_field_offset(lv, s21245c1f38, ABISELECT(928,648), "S21245C1.s21245c1f38");
    check_field_offset(lv, s21245c1f39, ABISELECT(936,652), "S21245C1.s21245c1f39");
    check_field_offset(lv, s21245c1f40, ABISELECT(1016,692), "S21245C1.s21245c1f40");
    check_field_offset(lv, s21245c1f41, ABISELECT(1080,744), "S21245C1.s21245c1f41");
    check_field_offset(lv, s21245c1f42, ABISELECT(1096,756), "S21245C1.s21245c1f42");
    check_field_offset(lv, s21245c1f43, ABISELECT(1112,768), "S21245C1.s21245c1f43");
    check_field_offset(lv, s21245c1f44, ABISELECT(1128,780), "S21245C1.s21245c1f44");
    check_field_offset(lv, s21245c1f45, ABISELECT(1136,784), "S21245C1.s21245c1f45");
    check_field_offset(lv, s21245c1f46, ABISELECT(3184,2832), "S21245C1.s21245c1f46");
    check_field_offset(lv, s21245c1f47, ABISELECT(5616,5136), "S21245C1.s21245c1f47");
    check_field_offset(lv, s21245c1f48, ABISELECT(8048,7440), "S21245C1.s21245c1f48");
    check_field_offset(lv, s21245c1f49, ABISELECT(8432,7696), "S21245C1.s21245c1f49");
    check_field_offset(lv, s21245c1f50, ABISELECT(12272,11280), "S21245C1.s21245c1f50");
    check_field_offset(lv, s21245c1f51, ABISELECT(12544,11528), "S21245C1.s21245c1f51");
    check_field_offset(lv, s21245c1f52, ABISELECT(12560,11540), "S21245C1.s21245c1f52");
    check_field_offset(lv, s21245c1f53, ABISELECT(12576,11552), "S21245C1.s21245c1f53");
    check_field_offset(lv, s21245c1f54, ABISELECT(12584,11560), "S21245C1.s21245c1f54");
    check_field_offset(lv, s21245c1f55, ABISELECT(12632,11584), "S21245C1.s21245c1f55");
    check_field_offset(lv, s21245c1f56, ABISELECT(12640,11592), "S21245C1.s21245c1f56");
    check_field_offset(lv, s21245c1f57, ABISELECT(12648,11596), "S21245C1.s21245c1f57");
    check_field_offset(lv, s21245c1f58, ABISELECT(12656,11600), "S21245C1.s21245c1f58");
    check_field_offset(lv, s21245c1f59, ABISELECT(12664,11604), "S21245C1.s21245c1f59");
    check_field_offset(lv, s21245c1f60, ABISELECT(12672,11608), "S21245C1.s21245c1f60");
    check_field_offset(lv, s21245c1f61, ABISELECT(12688,11624), "S21245C1.s21245c1f61");
    test_class_info(&lv, &cd_S21245C1);
    dp->~S21245C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21245C1(Test_S21245C1, "S21245C1", ABISELECT(12704,11632));

#else // __cplusplus

extern void _ZN8S21245C1C1Ev();
extern void _ZN8S21245C1D1Ev();
Name_Map name_map_S21245C1[] = {
  NSPAIR(_ZN8S21245C1C1Ev),
  NSPAIR(_ZN8S21245C1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S21245C1[];
extern void _ZN8S21245C1D1Ev();
extern void _ZN8S21245C1D0Ev();
static  VTBL_ENTRY vtc_S21245C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S21245C1[0]),
  (VTBL_ENTRY)&_ZN8S21245C1D1Ev,
  (VTBL_ENTRY)&_ZN8S21245C1D0Ev,
};
extern VTBL_ENTRY _ZTI8S21245C1[];
extern  VTBL_ENTRY _ZTV8S21245C1[];
Class_Descriptor cd_S21245C1 = {  "S21245C1", // class name
  0,0,//no base classes
  &(vtc_S21245C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(12704,11632), // object size
  NSPAIRA(_ZTI8S21245C1),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S21245C1),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C8_nt  {
  char s7825c8f0;
  void  mf7825c8(); // _ZN10S7825C8_nt8mf7825c8Ev
  virtual  ~S7825C8_nt(); // _ZN10S7825C8_ntD1Ev
  S7825C8_nt(); // tgen
};
//SIG(-1 S7825C8_nt) C1{ vd m Fc}


void  S7825C8_nt ::mf7825c8(){}
 S7825C8_nt ::~S7825C8_nt(){ note_dtor("S7825C8_nt", this);}
S7825C8_nt ::S7825C8_nt(){ note_ctor("S7825C8_nt", this);} // tgen

//skip512 S7825C8_nt

#else // __cplusplus

extern void _ZN10S7825C8_ntC1Ev();
extern void _ZN10S7825C8_ntD1Ev();
Name_Map name_map_S7825C8_nt[] = {
  NSPAIR(_ZN10S7825C8_ntC1Ev),
  NSPAIR(_ZN10S7825C8_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern void _ZN10S7825C8_ntD1Ev();
extern void _ZN10S7825C8_ntD0Ev();
static  VTBL_ENTRY vtc_S7825C8_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S7825C8_nt[0]),
  (VTBL_ENTRY)&_ZN10S7825C8_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S7825C8_ntD0Ev,
};
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
VTBL_ENTRY *P__ZTI10S7825C8_nt = _ZTI10S7825C8_nt; 
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
Class_Descriptor cd_S7825C8_nt = {  "S7825C8_nt", // class name
  0,0,//no base classes
  &(vtc_S7825C8_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI10S7825C8_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S7825C8_nt),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C5  : S2407C30 , S2407C27 , S7825C8_nt {
  void *s7825c5f0;
  virtual  ~S7825C5(); // _ZN7S7825C5D1Ev
  S7825C5(); // tgen
};
//SIG(-1 S7825C5) C1{ BC2{ m} BC3{ m} BC4{ vd m Fc} vd Fp}


 S7825C5 ::~S7825C5(){ note_dtor("S7825C5", this);}
S7825C5 ::S7825C5(){ note_ctor("S7825C5", this);} // tgen

static void Test_S7825C5()
{
  extern Class_Descriptor cd_S7825C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S7825C5, buf);
    S7825C5 *dp, &lv = *(dp=new (buf) S7825C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S7825C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7825C5)");
    check_base_class_offset(lv, (S2407C30*), 0, "S7825C5");
    check_base_class_offset(lv, (S2407C27*), 0, "S7825C5");
    check_base_class_offset(lv, (S7825C8_nt*), 0, "S7825C5");
    check_field_offset(lv, s7825c5f0, ABISELECT(16,8), "S7825C5.s7825c5f0");
    test_class_info(&lv, &cd_S7825C5);
    dp->~S7825C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7825C5(Test_S7825C5, "S7825C5", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN7S7825C5C1Ev();
extern void _ZN7S7825C5D1Ev();
Name_Map name_map_S7825C5[] = {
  NSPAIR(_ZN7S7825C5C1Ev),
  NSPAIR(_ZN7S7825C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
static Base_Class bases_S7825C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2407C30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2407C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7825C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S7825C5[];
extern void _ZN7S7825C5D1Ev();
extern void _ZN7S7825C5D0Ev();
static  VTBL_ENTRY vtc_S7825C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S7825C5[0]),
  (VTBL_ENTRY)&_ZN7S7825C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7825C5D0Ev,
};
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
Class_Descriptor cd_S7825C5 = {  "S7825C5", // class name
  bases_S7825C5, 3,
  &(vtc_S7825C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI7S7825C5),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S7825C5),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C13  : S2407C30 , S7825C5 {
  int s7825c13f0;
  virtual  ~S7825C13(); // _ZN8S7825C13D1Ev
  S7825C13(); // tgen
};
//SIG(-1 S7825C13) C1{ BC2{ m} BC3{ BC2 BC4{ m} BC5{ vd m Fc} vd Fp} vd Fi}


 S7825C13 ::~S7825C13(){ note_dtor("S7825C13", this);}
S7825C13 ::S7825C13(){ note_ctor("S7825C13", this);} // tgen

static void Test_S7825C13()
{
  extern Class_Descriptor cd_S7825C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S7825C13, buf);
    S7825C13 *dp, &lv = *(dp=new (buf) S7825C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S7825C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7825C13)");
    /*is_ambiguous_... S7825C13::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*), ABISELECT(24,12), "S7825C13");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*), 0, "S7825C13");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*), 0, "S7825C13");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*), 0, "S7825C13");
    check_base_class_offset(lv, (S7825C5*), 0, "S7825C13");
    check_field_offset(lv, s7825c13f0, ABISELECT(24,12), "S7825C13.s7825c13f0");
    test_class_info(&lv, &cd_S7825C13);
    dp->~S7825C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7825C13(Test_S7825C13, "S7825C13", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN8S7825C13C1Ev();
extern void _ZN8S7825C13D1Ev();
Name_Map name_map_S7825C13[] = {
  NSPAIR(_ZN8S7825C13C1Ev),
  NSPAIR(_ZN8S7825C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
static Base_Class bases_S7825C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2407C30,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2407C30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2407C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7825C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7825C13[];
extern void _ZN8S7825C13D1Ev();
extern void _ZN8S7825C13D0Ev();
static  VTBL_ENTRY vtc_S7825C13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C13[0]),
  (VTBL_ENTRY)&_ZN8S7825C13D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C13D0Ev,
};
extern VTBL_ENTRY _ZTI8S7825C13[];
extern  VTBL_ENTRY _ZTV8S7825C13[];
Class_Descriptor cd_S7825C13 = {  "S7825C13", // class name
  bases_S7825C13, 5,
  &(vtc_S7825C13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI8S7825C13),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S7825C13),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C14  : S7825C8_nt , S2407C27 {
  ~S7825C14(); // tgen
  S7825C14(); // tgen
};
//SIG(-1 S7825C14) C1{ BC2{ vd m Fc} BC3{ m}}


S7825C14 ::~S7825C14(){ note_dtor("S7825C14", this);} // tgen
S7825C14 ::S7825C14(){ note_ctor("S7825C14", this);} // tgen

static void Test_S7825C14()
{
  extern Class_Descriptor cd_S7825C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S7825C14, buf);
    S7825C14 *dp, &lv = *(dp=new (buf) S7825C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S7825C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7825C14)");
    check_base_class_offset(lv, (S7825C8_nt*), 0, "S7825C14");
    check_base_class_offset(lv, (S2407C27*), 0, "S7825C14");
    test_class_info(&lv, &cd_S7825C14);
    dp->~S7825C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7825C14(Test_S7825C14, "S7825C14", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN8S7825C14C1Ev();
extern void _ZN8S7825C14D1Ev();
Name_Map name_map_S7825C14[] = {
  NSPAIR(_ZN8S7825C14C1Ev),
  NSPAIR(_ZN8S7825C14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
static Base_Class bases_S7825C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7825C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2407C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7825C14[];
extern void _ZN8S7825C14D1Ev();
extern void _ZN8S7825C14D0Ev();
static  VTBL_ENTRY vtc_S7825C14[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C14[0]),
  (VTBL_ENTRY)&_ZN8S7825C14D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C14D0Ev,
};
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
Class_Descriptor cd_S7825C14 = {  "S7825C14", // class name
  bases_S7825C14, 2,
  &(vtc_S7825C14[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI8S7825C14),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S7825C14),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C12  : virtual S2407C27 , S7825C13 , virtual S7825C5 , virtual S7825C14 {
  virtual  ~S7825C12(); // _ZN8S7825C12D2Ev
  S7825C12(); // tgen
};
//SIG(-1 S7825C12) C1{ VBC2{ m} BC3{ BC4{ m} BC5{ BC4 BC2 BC6{ vd m Fc} vd Fp} vd Fi} VBC5 VBC7{ BC6 BC2} vd}


 S7825C12 ::~S7825C12(){ note_dtor("S7825C12", this);}
S7825C12 ::S7825C12(){ note_ctor("S7825C12", this);} // tgen

static void Test_S7825C12()
{
  extern Class_Descriptor cd_S7825C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,11)];
    init_test(&cd_S7825C12, buf);
    S7825C12 *dp, &lv = *(dp=new (buf) S7825C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,40), "sizeof(S7825C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7825C12)");
    /*is_ambiguous_... S7825C12::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*), ABISELECT(28,16), "S7825C12");
    /*is_ambiguous_... S7825C13::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C13*), ABISELECT(24,12), "S7825C12");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C13*), 0, "S7825C12");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C13*), 0, "S7825C12");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C13*), 0, "S7825C12");
    check_base_class_offset(lv, (S7825C5*)(S7825C13*), 0, "S7825C12");
    check_base_class_offset(lv, (S7825C13*), 0, "S7825C12");
    /*is_ambiguous_... S7825C12::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*), ABISELECT(32,20), "S7825C12");
    /*is_ambiguous_... S7825C12::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*), ABISELECT(32,20), "S7825C12");
    /*is_ambiguous_... S7825C12::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*), ABISELECT(32,20), "S7825C12");
    /*is_ambiguous_... S7825C12::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C5*), ABISELECT(32,20), "S7825C12");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*), ABISELECT(56,32), "S7825C12");
    check_base_class_offset(lv, (S2407C27*)(S7825C14*), ABISELECT(56,32), "S7825C12");
    check_base_class_offset(lv, (S7825C14*), ABISELECT(56,32), "S7825C12");
    test_class_info(&lv, &cd_S7825C12);
    dp->~S7825C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7825C12(Test_S7825C12, "S7825C12", ABISELECT(72,40));

#else // __cplusplus

extern void _ZN8S7825C12C1Ev();
extern void _ZN8S7825C12D2Ev();
Name_Map name_map_S7825C12[] = {
  NSPAIR(_ZN8S7825C12C1Ev),
  NSPAIR(_ZN8S7825C12D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C13;
extern VTBL_ENTRY _ZTI8S7825C13[];
extern  VTBL_ENTRY _ZTV8S7825C13[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
static Base_Class bases_S7825C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2407C27,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2407C30,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2407C30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S2407C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7825C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S7825C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2407C30,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7825C8_nt,    ABISELECT(56,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(56,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(56,32), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7825C12[];
extern void _ZN8S7825C12D1Ev();
extern void _ZN8S7825C12D0Ev();
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZThn32_N8S7825C12D1Ev,_ZThn20_N8S7825C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
extern void ABISELECT(_ZThn32_N8S7825C12D0Ev,_ZThn20_N8S7825C12D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZThn56_N8S7825C12D1Ev,_ZThn32_N8S7825C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
extern void ABISELECT(_ZThn56_N8S7825C12D0Ev,_ZThn32_N8S7825C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7825C12[] = {
  ABISELECT(56,32),
  ABISELECT(32,20),
  ABISELECT(28,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&_ZN8S7825C12D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C12D0Ev,
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
  ABISELECT(-56,-32),
  ABISELECT(-56,-32),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
};
extern VTBL_ENTRY _ZTV8S7825C12[];
static  VTT_ENTRY vtt_S7825C12[] = {
  {&(_ZTV8S7825C12[5]),  5,17},
  {&(_ZTV8S7825C12[10]),  10,17},
  {&(_ZTV8S7825C12[15]),  15,17},
};
extern VTBL_ENTRY _ZTI8S7825C12[];
extern  VTBL_ENTRY _ZTV8S7825C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C12[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S7825C12D0Ev,_ZThn32_N8S7825C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C12D0Ev,_ZThn20_N8S7825C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S7825C12D1Ev,_ZThn32_N8S7825C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C12D1Ev,_ZThn20_N8S7825C12D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7825C12 = {  "S7825C12", // class name
  bases_S7825C12, 14,
  &(vtc_S7825C12[0]), // expected_vtbl_contents
  &(vtt_S7825C12[0]), // expected_vtt_contents
  ABISELECT(72,40), // object size
  NSPAIRA(_ZTI8S7825C12),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S7825C12),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7825C12),3, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C15  : S2407C27 , S7825C14 , S7825C8_nt , S7825C5 , virtual S2407C30 {
  virtual  ~S7825C15(); // _ZN8S7825C15D2Ev
  virtual void  v2(); // _ZN8S7825C152v2Ev
  S7825C15(); // tgen
};
//SIG(-1 S7825C15) C1{ BC2{ m} BC3{ BC4{ vd m Fc} BC2} BC4 BC5{ BC6{ m} BC2 BC4 vd Fp} VBC6 vd v1}


 S7825C15 ::~S7825C15(){ note_dtor("S7825C15", this);}
void  S7825C15 ::v2(){vfunc_called(this, "_ZN8S7825C152v2Ev");}
S7825C15 ::S7825C15(){ note_ctor("S7825C15", this);} // tgen

static void Test_S7825C15()
{
  extern Class_Descriptor cd_S7825C15;
  void *lvp;
  {
    ABISELECT(double,int) buf[8];
    init_test(&cd_S7825C15, buf);
    S7825C15 *dp, &lv = *(dp=new (buf) S7825C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,28), "sizeof(S7825C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7825C15)");
    /*is_ambiguous_... S7825C15::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*), ABISELECT(9,5), "S7825C15");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*), 0, "S7825C15");
    check_base_class_offset(lv, (S2407C27*)(S7825C14*), 0, "S7825C15");
    check_base_class_offset(lv, (S7825C14*), 0, "S7825C15");
    /*is_ambiguous_... S7825C15::S7825C8_nt */ AMB_check_base_class_offset(lv, (S7825C8_nt*), ABISELECT(16,8), "S7825C15");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*), ABISELECT(32,16), "S7825C15");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*), ABISELECT(32,16), "S7825C15");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*), ABISELECT(32,16), "S7825C15");
    check_base_class_offset(lv, (S7825C5*), ABISELECT(32,16), "S7825C15");
    /*is_ambiguous_... S7825C15::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*), 0, "S7825C15");
    test_class_info(&lv, &cd_S7825C15);
    dp->~S7825C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7825C15(Test_S7825C15, "S7825C15", ABISELECT(56,28));

#else // __cplusplus

extern void _ZN8S7825C15C1Ev();
extern void _ZN8S7825C15D2Ev();
Name_Map name_map_S7825C15[] = {
  NSPAIR(_ZN8S7825C15C1Ev),
  NSPAIR(_ZN8S7825C15D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
static Base_Class bases_S7825C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2407C27,    ABISELECT(9,5), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7825C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2407C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S7825C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7825C8_nt,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2407C30,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2407C30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7825C15[];
extern void _ZN8S7825C15D1Ev();
extern void _ZN8S7825C15D0Ev();
extern void _ZN8S7825C152v2Ev();
extern void ABISELECT(_ZThn16_N8S7825C15D1Ev,_ZThn8_N8S7825C15D1Ev)();
extern void ABISELECT(_ZThn16_N8S7825C15D0Ev,_ZThn8_N8S7825C15D0Ev)();
extern void ABISELECT(_ZThn32_N8S7825C15D1Ev,_ZThn16_N8S7825C15D1Ev)();
extern void ABISELECT(_ZThn32_N8S7825C15D0Ev,_ZThn16_N8S7825C15D0Ev)();
static  VTBL_ENTRY vtc_S7825C15[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C15[0]),
  (VTBL_ENTRY)&_ZN8S7825C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C15D0Ev,
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S7825C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C15D1Ev,_ZThn8_N8S7825C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C15D0Ev,_ZThn8_N8S7825C15D0Ev),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S7825C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S7825C15D1Ev,_ZThn16_N8S7825C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S7825C15D0Ev,_ZThn16_N8S7825C15D0Ev),
};
extern VTBL_ENTRY _ZTV8S7825C15[];
static  VTT_ENTRY vtt_S7825C15[] = {
  {&(_ZTV8S7825C15[3]),  3,14},
};
extern VTBL_ENTRY _ZTI8S7825C15[];
extern  VTBL_ENTRY _ZTV8S7825C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C15[];
Class_Descriptor cd_S7825C15 = {  "S7825C15", // class name
  bases_S7825C15, 10,
  &(vtc_S7825C15[0]), // expected_vtbl_contents
  &(vtt_S7825C15[0]), // expected_vtt_contents
  ABISELECT(56,28), // object size
  NSPAIRA(_ZTI8S7825C15),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S7825C15),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7825C15),1, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C11  : S7825C12 , S7825C13 , virtual S2407C30 , S7825C15 {
  virtual  ~S7825C11(); // _ZN8S7825C11D2Ev
  S7825C11(); // tgen
};
//SIG(-1 S7825C11) C1{ BC2{ VBC3{ m} BC4{ BC5{ m} BC6{ BC5 BC3 BC7{ vd m Fc} vd Fp} vd Fi} VBC6 VBC8{ BC7 BC3} vd} BC4 VBC5 BC9{ BC3 BC8 BC7 BC6 VBC5 vd v1} vd}


 S7825C11 ::~S7825C11(){ note_dtor("S7825C11", this);}
S7825C11 ::S7825C11(){ note_ctor("S7825C11", this);} // tgen

static void Test_S7825C11()
{
  extern Class_Descriptor cd_S7825C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[22];
    init_test(&cd_S7825C11, buf);
    S7825C11 *dp, &lv = *(dp=new (buf) S7825C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(168,84), "sizeof(S7825C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7825C11)");
    /*is_ambiguous_... S7825C12::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C12*), ABISELECT(120,60), "S7825C11");
    /*is_ambiguous_... S7825C13::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C13*)(S7825C12*), ABISELECT(24,12), "S7825C11");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C13*)(S7825C12*), 0, "S7825C11");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C13*)(S7825C12*), 0, "S7825C11");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C13*)(S7825C12*), 0, "S7825C11");
    check_base_class_offset(lv, (S7825C5*)(S7825C13*)(S7825C12*), 0, "S7825C11");
    check_base_class_offset(lv, (S7825C13*)(S7825C12*), 0, "S7825C11");
    /*is_ambiguous_... S7825C11::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*), ABISELECT(128,64), "S7825C11");
    /*is_ambiguous_... S7825C11::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*), ABISELECT(128,64), "S7825C11");
    /*is_ambiguous_... S7825C11::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*), ABISELECT(128,64), "S7825C11");
    /*is_ambiguous_... S7825C12::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C12*), ABISELECT(128,64), "S7825C11");
    /*is_ambiguous_... S7825C11::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*), ABISELECT(152,76), "S7825C11");
    /*is_ambiguous_... S7825C11::S7825C14 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C14*), ABISELECT(152,76), "S7825C11");
    check_base_class_offset(lv, (S7825C14*)(S7825C12*), ABISELECT(152,76), "S7825C11");
    check_base_class_offset(lv, (S7825C12*), 0, "S7825C11");
    /*is_ambiguous_... S7825C11::S7825C13 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C13*), ABISELECT(56,28), "S7825C11");
    /*is_ambiguous_... S7825C11::S7825C13 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C13*), ABISELECT(32,16), "S7825C11");
    /*is_ambiguous_... S7825C11::S7825C13 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C13*), ABISELECT(32,16), "S7825C11");
    /*is_ambiguous_... S7825C11::S7825C13 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C13*), ABISELECT(32,16), "S7825C11");
    /*is_ambiguous_... S7825C11::S7825C13 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C13*), ABISELECT(32,16), "S7825C11");
    /*is_ambiguous_... S7825C11::S7825C13 */ AMB_check_base_class_offset(lv, (S7825C13*), ABISELECT(32,16), "S7825C11");
    /*is_ambiguous_... S7825C11::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*), ABISELECT(161,81), "S7825C11");
    /*is_ambiguous_... S7825C15::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C15*), ABISELECT(161,81), "S7825C11");
    /*is_ambiguous_... S7825C15::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C15*), ABISELECT(73,37), "S7825C11");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C15*), ABISELECT(64,32), "S7825C11");
    check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C15*), ABISELECT(64,32), "S7825C11");
    check_base_class_offset(lv, (S7825C14*)(S7825C15*), ABISELECT(64,32), "S7825C11");
    /*is_ambiguous_... S7825C15::S7825C8_nt */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C15*), ABISELECT(80,40), "S7825C11");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C15*), ABISELECT(96,48), "S7825C11");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C15*), ABISELECT(96,48), "S7825C11");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C15*), ABISELECT(96,48), "S7825C11");
    check_base_class_offset(lv, (S7825C5*)(S7825C15*), ABISELECT(96,48), "S7825C11");
    check_base_class_offset(lv, (S7825C15*), ABISELECT(64,32), "S7825C11");
    test_class_info(&lv, &cd_S7825C11);
    dp->~S7825C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7825C11(Test_S7825C11, "S7825C11", ABISELECT(168,84));

#else // __cplusplus

extern void _ZN8S7825C11C1Ev();
extern void _ZN8S7825C11D2Ev();
Name_Map name_map_S7825C11[] = {
  NSPAIR(_ZN8S7825C11C1Ev),
  NSPAIR(_ZN8S7825C11D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C13;
extern VTBL_ENTRY _ZTI8S7825C13[];
extern  VTBL_ENTRY _ZTV8S7825C13[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C12;
extern VTBL_ENTRY _ZTI8S7825C12[];
extern  VTBL_ENTRY _ZTV8S7825C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C12[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C13;
extern VTBL_ENTRY _ZTI8S7825C13[];
extern  VTBL_ENTRY _ZTV8S7825C13[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C15;
extern VTBL_ENTRY _ZTI8S7825C15[];
extern  VTBL_ENTRY _ZTV8S7825C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C15[];
static Base_Class bases_S7825C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2407C27,    ABISELECT(120,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S2407C30,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2407C30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S2407C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7825C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S7825C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(128,64), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(128,64), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(128,64), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(128,64), //bcp->offset
    26, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S7825C8_nt,    ABISELECT(152,76), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(152,76), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(152,76), //bcp->offset
    31, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S7825C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2407C30,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S7825C13,    ABISELECT(32,16), //bcp->offset
    8, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2407C30,    ABISELECT(161,81), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2407C27,    ABISELECT(73,37), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(64,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(64,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(64,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(80,40), //bcp->offset
    18, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(96,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(96,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(96,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(96,48), //bcp->offset
    22, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S7825C15,    ABISELECT(64,32), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7825C11[];
extern void _ZN8S7825C11D1Ev();
extern void _ZN8S7825C11D0Ev();
extern void ABISELECT(_ZThn32_N8S7825C11D1Ev,_ZThn16_N8S7825C11D1Ev)();
extern void ABISELECT(_ZThn32_N8S7825C11D0Ev,_ZThn16_N8S7825C11D0Ev)();
extern void ABISELECT(_ZThn64_N8S7825C11D1Ev,_ZThn32_N8S7825C11D1Ev)();
extern void ABISELECT(_ZThn64_N8S7825C11D0Ev,_ZThn32_N8S7825C11D0Ev)();
extern void _ZN8S7825C152v2Ev();
extern void ABISELECT(_ZThn80_N8S7825C11D1Ev,_ZThn40_N8S7825C11D1Ev)();
extern void ABISELECT(_ZThn80_N8S7825C11D0Ev,_ZThn40_N8S7825C11D0Ev)();
extern void ABISELECT(_ZThn96_N8S7825C11D1Ev,_ZThn48_N8S7825C11D1Ev)();
extern void ABISELECT(_ZThn96_N8S7825C11D0Ev,_ZThn48_N8S7825C11D0Ev)();
extern void ABISELECT(_ZTv0_n24_N8S7825C11D1Ev,_ZTv0_n12_N8S7825C11D1Ev)();
extern void ABISELECT(_ZThn128_N8S7825C11D1Ev,_ZThn64_N8S7825C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C11D0Ev,_ZTv0_n12_N8S7825C11D0Ev)();
extern void ABISELECT(_ZThn128_N8S7825C11D0Ev,_ZThn64_N8S7825C11D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C11D1Ev,_ZTv0_n12_N8S7825C11D1Ev)();
extern void ABISELECT(_ZThn152_N8S7825C11D1Ev,_ZThn76_N8S7825C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C11D0Ev,_ZTv0_n12_N8S7825C11D0Ev)();
extern void ABISELECT(_ZThn152_N8S7825C11D0Ev,_ZThn76_N8S7825C11D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7825C11[] = {
  ABISELECT(161,81),
  ABISELECT(152,76),
  ABISELECT(128,64),
  ABISELECT(120,60),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C11[0]),
  (VTBL_ENTRY)&_ZN8S7825C11D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C11D0Ev,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S7825C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S7825C11D1Ev,_ZThn16_N8S7825C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S7825C11D0Ev,_ZThn16_N8S7825C11D0Ev),
  ABISELECT(97,49),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI8S7825C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N8S7825C11D1Ev,_ZThn32_N8S7825C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N8S7825C11D0Ev,_ZThn32_N8S7825C11D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
  ABISELECT(-80,-40),
  (VTBL_ENTRY)&(_ZTI8S7825C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N8S7825C11D1Ev,_ZThn40_N8S7825C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N8S7825C11D0Ev,_ZThn40_N8S7825C11D0Ev),
  ABISELECT(-96,-48),
  (VTBL_ENTRY)&(_ZTI8S7825C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S7825C11D1Ev,_ZThn48_N8S7825C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S7825C11D0Ev,_ZThn48_N8S7825C11D0Ev),
  ABISELECT(-128,-64),
  ABISELECT(-128,-64),
  (VTBL_ENTRY)&(_ZTI8S7825C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C11D1Ev,_ZTv0_n12_N8S7825C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C11D0Ev,_ZTv0_n12_N8S7825C11D0Ev),
  ABISELECT(-152,-76),
  ABISELECT(-152,-76),
  (VTBL_ENTRY)&(_ZTI8S7825C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C11D1Ev,_ZTv0_n12_N8S7825C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C11D0Ev,_ZTv0_n12_N8S7825C11D0Ev),
};
extern VTBL_ENTRY _ZTV8S7825C11[];
extern void _ZN8S7825C12D1Ev();
extern void _ZN8S7825C12D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C12__8S7825C11[] = {
  ABISELECT(152,76),
  ABISELECT(128,64),
  ABISELECT(120,60),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&_ZN8S7825C12D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C12D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZThn128_N8S7825C12D1Ev,_ZThn64_N8S7825C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
extern void ABISELECT(_ZThn128_N8S7825C12D0Ev,_ZThn64_N8S7825C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7825C5__A1__8S7825C12__8S7825C11[] = {
  ABISELECT(-128,-64),
  ABISELECT(-128,-64),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZThn152_N8S7825C12D1Ev,_ZThn76_N8S7825C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
extern void ABISELECT(_ZThn152_N8S7825C12D0Ev,_ZThn76_N8S7825C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C14__8S7825C12__8S7825C11[] = {
  ABISELECT(-152,-76),
  ABISELECT(-152,-76),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
};
extern void _ZN8S7825C15D1Ev();
extern void _ZN8S7825C15D0Ev();
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C15__8S7825C11[] = {
  ABISELECT(97,49),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C15[0]),
  (VTBL_ENTRY)&_ZN8S7825C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C15D0Ev,
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
static  VTT_ENTRY vtt_S7825C11[] = {
  {&(_ZTV8S7825C11[6]),  6,36},
  {&(_tg__ZTV8S7825C12__8S7825C11[5]),  5,7},
  {&(_tg__ZTV7S7825C5__A1__8S7825C12__8S7825C11[3]),  3,5},
  {&(_tg__ZTV8S7825C14__8S7825C12__8S7825C11[3]),  3,5},
  {&(_tg__ZTV8S7825C15__8S7825C11[3]),  3,6},
  {&(_ZTV8S7825C11[29]),  29,36},
  {&(_ZTV8S7825C11[34]),  34,36},
  {&(_ZTV8S7825C11[15]),  15,36},
};
extern VTBL_ENTRY _ZTI8S7825C11[];
extern  VTBL_ENTRY _ZTV8S7825C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C11[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn152_N8S7825C12D0Ev,_ZThn76_N8S7825C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn128_N8S7825C12D0Ev,_ZThn64_N8S7825C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn152_N8S7825C12D1Ev,_ZThn76_N8S7825C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn128_N8S7825C12D1Ev,_ZThn64_N8S7825C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C11D0Ev,_ZTv0_n12_N8S7825C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn152_N8S7825C11D0Ev,_ZThn76_N8S7825C11D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn128_N8S7825C11D0Ev,_ZThn64_N8S7825C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C11D1Ev,_ZTv0_n12_N8S7825C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn152_N8S7825C11D1Ev,_ZThn76_N8S7825C11D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn128_N8S7825C11D1Ev,_ZThn64_N8S7825C11D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7825C11 = {  "S7825C11", // class name
  bases_S7825C11, 32,
  &(vtc_S7825C11[0]), // expected_vtbl_contents
  &(vtt_S7825C11[0]), // expected_vtt_contents
  ABISELECT(168,84), // object size
  NSPAIRA(_ZTI8S7825C11),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S7825C11),36, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7825C11),8, //virtual table table var
  17, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C16  : S7825C5 {
  virtual  ~S7825C16(); // _ZN8S7825C16D1Ev
  S7825C16(); // tgen
};
//SIG(-1 S7825C16) C1{ BC2{ BC3{ m} BC4{ m} BC5{ vd m Fc} vd Fp} vd}


 S7825C16 ::~S7825C16(){ note_dtor("S7825C16", this);}
S7825C16 ::S7825C16(){ note_ctor("S7825C16", this);} // tgen

static void Test_S7825C16()
{
  extern Class_Descriptor cd_S7825C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S7825C16, buf);
    S7825C16 *dp, &lv = *(dp=new (buf) S7825C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S7825C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7825C16)");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*), 0, "S7825C16");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*), 0, "S7825C16");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*), 0, "S7825C16");
    check_base_class_offset(lv, (S7825C5*), 0, "S7825C16");
    test_class_info(&lv, &cd_S7825C16);
    dp->~S7825C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7825C16(Test_S7825C16, "S7825C16", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN8S7825C16C1Ev();
extern void _ZN8S7825C16D1Ev();
Name_Map name_map_S7825C16[] = {
  NSPAIR(_ZN8S7825C16C1Ev),
  NSPAIR(_ZN8S7825C16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
static Base_Class bases_S7825C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2407C30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2407C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S7825C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7825C16[];
extern void _ZN8S7825C16D1Ev();
extern void _ZN8S7825C16D0Ev();
static  VTBL_ENTRY vtc_S7825C16[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C16[0]),
  (VTBL_ENTRY)&_ZN8S7825C16D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C16D0Ev,
};
extern VTBL_ENTRY _ZTI8S7825C16[];
extern  VTBL_ENTRY _ZTV8S7825C16[];
Class_Descriptor cd_S7825C16 = {  "S7825C16", // class name
  bases_S7825C16, 4,
  &(vtc_S7825C16[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI8S7825C16),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S7825C16),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C20  : virtual S2407C30 , virtual S7825C15 , virtual S2407C27 , S7825C14 , virtual S7825C13 {
  virtual  ~S7825C20(); // _ZN8S7825C20D2Ev
  S7825C20(); // tgen
};
//SIG(-1 S7825C20) C1{ VBC2{ m} VBC3{ BC4{ m} BC5{ BC6{ vd m Fc} BC4} BC6 BC7{ BC2 BC4 BC6 vd Fp} VBC2 vd v1} VBC4 BC5 VBC8{ BC2 BC7 vd Fi} vd}


 S7825C20 ::~S7825C20(){ note_dtor("S7825C20", this);}
S7825C20 ::S7825C20(){ note_ctor("S7825C20", this);} // tgen

static void Test_S7825C20()
{
  extern Class_Descriptor cd_S7825C20;
  void *lvp;
  {
    ABISELECT(double,int) buf[15];
    init_test(&cd_S7825C20, buf);
    S7825C20 *dp, &lv = *(dp=new (buf) S7825C20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,56), "sizeof(S7825C20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7825C20)");
    /*is_ambiguous_... S7825C20::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*), 0, "S7825C20");
    /*is_ambiguous_... S7825C15::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C15*), 0, "S7825C20");
    /*is_ambiguous_... S7825C15::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C15*), ABISELECT(25,13), "S7825C20");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C15*), ABISELECT(16,8), "S7825C20");
    check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C15*), ABISELECT(16,8), "S7825C20");
    check_base_class_offset(lv, (S7825C14*)(S7825C15*), ABISELECT(16,8), "S7825C20");
    /*is_ambiguous_... S7825C15::S7825C8_nt */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C15*), ABISELECT(32,16), "S7825C20");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C15*), ABISELECT(48,24), "S7825C20");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C15*), ABISELECT(48,24), "S7825C20");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C15*), ABISELECT(48,24), "S7825C20");
    check_base_class_offset(lv, (S7825C5*)(S7825C15*), ABISELECT(48,24), "S7825C20");
    check_base_class_offset(lv, (S7825C15*), ABISELECT(16,8), "S7825C20");
    /*is_ambiguous_... S7825C20::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*), ABISELECT(72,36), "S7825C20");
    /*is_ambiguous_... S7825C20::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*), 0, "S7825C20");
    /*is_ambiguous_... S7825C20::S7825C14 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C14*), 0, "S7825C20");
    /*is_ambiguous_... S7825C20::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C14*), 0, "S7825C20");
    /*is_ambiguous_... S7825C13::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C13*), ABISELECT(104,52), "S7825C20");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C13*), ABISELECT(80,40), "S7825C20");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C13*), ABISELECT(80,40), "S7825C20");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C13*), ABISELECT(80,40), "S7825C20");
    check_base_class_offset(lv, (S7825C5*)(S7825C13*), ABISELECT(80,40), "S7825C20");
    check_base_class_offset(lv, (S7825C13*), ABISELECT(80,40), "S7825C20");
    test_class_info(&lv, &cd_S7825C20);
    dp->~S7825C20();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7825C20(Test_S7825C20, "S7825C20", ABISELECT(112,56));

#else // __cplusplus

extern void _ZN8S7825C20C1Ev();
extern void _ZN8S7825C20D2Ev();
Name_Map name_map_S7825C20[] = {
  NSPAIR(_ZN8S7825C20C1Ev),
  NSPAIR(_ZN8S7825C20D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C15;
extern VTBL_ENTRY _ZTI8S7825C15[];
extern  VTBL_ENTRY _ZTV8S7825C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C15[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C13;
extern VTBL_ENTRY _ZTI8S7825C13[];
extern  VTBL_ENTRY _ZTV8S7825C13[];
static Base_Class bases_S7825C20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2407C30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2407C27,    ABISELECT(25,13), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(32,16), //bcp->offset
    16, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(48,24), //bcp->offset
    20, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7825C15,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2407C27,    ABISELECT(72,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7825C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S2407C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S7825C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2407C30,    ABISELECT(104,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(80,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(80,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(80,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(80,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S7825C13,    ABISELECT(80,40), //bcp->offset
    24, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7825C20[];
extern void _ZN8S7825C20D1Ev();
extern void _ZN8S7825C20D0Ev();
extern void ABISELECT(_ZTv0_n32_N8S7825C20D1Ev,_ZTv0_n16_N8S7825C20D1Ev)();
extern void ABISELECT(_ZThn16_N8S7825C20D1Ev,_ZThn8_N8S7825C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7825C20D0Ev,_ZTv0_n16_N8S7825C20D0Ev)();
extern void ABISELECT(_ZThn16_N8S7825C20D0Ev,_ZThn8_N8S7825C20D0Ev)() __attribute__((weak));
extern void _ZN8S7825C152v2Ev();
extern void ABISELECT(_ZTvn16_n32_N8S7825C20D1Ev,_ZTvn8_n16_N8S7825C20D1Ev)();
extern void ABISELECT(_ZTvn16_n32_N8S7825C20D0Ev,_ZTvn8_n16_N8S7825C20D0Ev)();
extern void ABISELECT(_ZTvn32_n32_N8S7825C20D1Ev,_ZTvn16_n16_N8S7825C20D1Ev)();
extern void ABISELECT(_ZTvn32_n32_N8S7825C20D0Ev,_ZTvn16_n16_N8S7825C20D0Ev)();
extern void ABISELECT(_ZTv0_n24_N8S7825C20D1Ev,_ZTv0_n12_N8S7825C20D1Ev)();
extern void ABISELECT(_ZThn80_N8S7825C20D1Ev,_ZThn40_N8S7825C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C20D0Ev,_ZTv0_n12_N8S7825C20D0Ev)();
extern void ABISELECT(_ZThn80_N8S7825C20D0Ev,_ZThn40_N8S7825C20D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7825C20[] = {
  ABISELECT(80,40),
  ABISELECT(72,36),
  ABISELECT(16,8),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C20[0]),
  (VTBL_ENTRY)&_ZN8S7825C20D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C20D0Ev,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S7825C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7825C20D1Ev,_ZTv0_n16_N8S7825C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7825C20D0Ev,_ZTv0_n16_N8S7825C20D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S7825C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n32_N8S7825C20D1Ev,_ZTvn8_n16_N8S7825C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n32_N8S7825C20D0Ev,_ZTvn8_n16_N8S7825C20D0Ev),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S7825C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n32_N8S7825C20D1Ev,_ZTvn16_n16_N8S7825C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n32_N8S7825C20D0Ev,_ZTvn16_n16_N8S7825C20D0Ev),
  ABISELECT(-80,-40),
  ABISELECT(-80,-40),
  (VTBL_ENTRY)&(_ZTI8S7825C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C20D1Ev,_ZTv0_n12_N8S7825C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C20D0Ev,_ZTv0_n12_N8S7825C20D0Ev),
};
extern VTBL_ENTRY _ZTV8S7825C20[];
extern void _ZN8S7825C15D1Ev();
extern void _ZN8S7825C15D0Ev();
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C15__8S7825C20[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C15[0]),
  (VTBL_ENTRY)&_ZN8S7825C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C15D0Ev,
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
static  VTT_ENTRY vtt_S7825C20[] = {
  {&(_ZTV8S7825C20[6]),  6,29},
  {&(_ZTV8S7825C20[13]),  13,29},
  {&(_ZTV8S7825C20[18]),  18,29},
  {&(_ZTV8S7825C20[22]),  22,29},
  {&(_ZTV8S7825C20[27]),  27,29},
  {&(_tg__ZTV8S7825C15__8S7825C20[3]),  3,6},
};
extern VTBL_ENTRY _ZTI8S7825C20[];
extern  VTBL_ENTRY _ZTV8S7825C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C20[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C20D0Ev,_ZTv0_n12_N8S7825C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N8S7825C20D0Ev,_ZThn40_N8S7825C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C20D1Ev,_ZTv0_n12_N8S7825C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N8S7825C20D1Ev,_ZThn40_N8S7825C20D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7825C20D0Ev,_ZTv0_n16_N8S7825C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S7825C20D0Ev,_ZThn8_N8S7825C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7825C20D1Ev,_ZTv0_n16_N8S7825C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S7825C20D1Ev,_ZThn8_N8S7825C20D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7825C20 = {  "S7825C20", // class name
  bases_S7825C20, 21,
  &(vtc_S7825C20[0]), // expected_vtbl_contents
  &(vtt_S7825C20[0]), // expected_vtt_contents
  ABISELECT(112,56), // object size
  NSPAIRA(_ZTI8S7825C20),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S7825C20),29, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7825C20),6, //virtual table table var
  11, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C19  : virtual S7825C20 {
  __tsi64 s7825c19f0;
  ~S7825C19(); // tgen
  S7825C19(); // tgen
};
//SIG(-1 S7825C19) C1{ VBC2{ VBC3{ m} VBC4{ BC5{ m} BC6{ BC7{ vd m Fc} BC5} BC7 BC8{ BC3 BC5 BC7 vd Fp} VBC3 vd v1} VBC5 BC6 VBC9{ BC3 BC8 vd Fi} vd} FL}


S7825C19 ::~S7825C19(){ note_dtor("S7825C19", this);} // tgen
S7825C19 ::S7825C19(){ note_ctor("S7825C19", this);} // tgen

static void Test_S7825C19()
{
  extern Class_Descriptor cd_S7825C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(16,17)];
    init_test(&cd_S7825C19, buf);
    S7825C19 *dp, &lv = *(dp=new (buf) S7825C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(120,64), "sizeof(S7825C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7825C19)");
    /*is_ambiguous_... S7825C20::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C20*), 0, "S7825C19");
    /*is_ambiguous_... S7825C15::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C15*), 0, "S7825C19");
    /*is_ambiguous_... S7825C15::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C15*), ABISELECT(41,25), "S7825C19");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C15*), ABISELECT(32,20), "S7825C19");
    check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C15*), ABISELECT(32,20), "S7825C19");
    check_base_class_offset(lv, (S7825C14*)(S7825C15*), ABISELECT(32,20), "S7825C19");
    /*is_ambiguous_... S7825C15::S7825C8_nt */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C15*), ABISELECT(48,28), "S7825C19");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C15*), ABISELECT(64,36), "S7825C19");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C15*), ABISELECT(64,36), "S7825C19");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C15*), ABISELECT(64,36), "S7825C19");
    check_base_class_offset(lv, (S7825C5*)(S7825C15*), ABISELECT(64,36), "S7825C19");
    check_base_class_offset(lv, (S7825C15*)(S7825C20*), ABISELECT(32,20), "S7825C19");
    /*is_ambiguous_... S7825C20::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C20*), 0, "S7825C19");
    /*is_ambiguous_... S7825C20::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C20*), ABISELECT(16,12), "S7825C19");
    /*is_ambiguous_... S7825C20::S7825C14 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C20*), ABISELECT(16,12), "S7825C19");
    /*is_ambiguous_... S7825C20::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C14*)(S7825C20*), ABISELECT(16,12), "S7825C19");
    /*is_ambiguous_... S7825C13::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C13*), ABISELECT(112,60), "S7825C19");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C13*), ABISELECT(88,48), "S7825C19");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C13*), ABISELECT(88,48), "S7825C19");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C13*), ABISELECT(88,48), "S7825C19");
    check_base_class_offset(lv, (S7825C5*)(S7825C13*), ABISELECT(88,48), "S7825C19");
    check_base_class_offset(lv, (S7825C13*)(S7825C20*), ABISELECT(88,48), "S7825C19");
    check_base_class_offset(lv, (S7825C20*), ABISELECT(16,12), "S7825C19");
    check_field_offset(lv, s7825c19f0, ABISELECT(8,4), "S7825C19.s7825c19f0");
    test_class_info(&lv, &cd_S7825C19);
    dp->~S7825C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7825C19(Test_S7825C19, "S7825C19", ABISELECT(120,64));

#else // __cplusplus

extern void _ZN8S7825C19C1Ev();
extern void _ZN8S7825C19D1Ev();
Name_Map name_map_S7825C19[] = {
  NSPAIR(_ZN8S7825C19C1Ev),
  NSPAIR(_ZN8S7825C19D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C15;
extern VTBL_ENTRY _ZTI8S7825C15[];
extern  VTBL_ENTRY _ZTV8S7825C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C15[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C13;
extern VTBL_ENTRY _ZTI8S7825C13[];
extern  VTBL_ENTRY _ZTV8S7825C13[];
extern Class_Descriptor cd_S7825C20;
extern VTBL_ENTRY _ZTI8S7825C20[];
extern  VTBL_ENTRY _ZTV8S7825C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C20[];
static Base_Class bases_S7825C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2407C30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S2407C27,    ABISELECT(41,25), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(48,28), //bcp->offset
    26, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(64,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(64,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(64,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(64,36), //bcp->offset
    30, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7825C15,    ABISELECT(32,20), //bcp->offset
    18, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    21, //immediately_derived
  0, 1},
  {&cd_S2407C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    21, //immediately_derived
  0, 1},
  {&cd_S7825C8_nt,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(112,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(88,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(88,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(88,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(88,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S7825C13,    ABISELECT(88,48), //bcp->offset
    34, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    21, //immediately_derived
  0, 1},
  {&cd_S7825C20,    ABISELECT(16,12), //bcp->offset
    9, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7825C19[];
extern void _ZN8S7825C19D1Ev();
extern void _ZN8S7825C19D0Ev();
extern void ABISELECT(_ZTv0_n56_N8S7825C19D1Ev,_ZTv0_n28_N8S7825C19D1Ev)();
extern void ABISELECT(_ZThn16_N8S7825C19D1Ev,_ZThn12_N8S7825C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7825C19D0Ev,_ZTv0_n28_N8S7825C19D0Ev)();
extern void ABISELECT(_ZThn16_N8S7825C19D0Ev,_ZThn12_N8S7825C19D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7825C19D1Ev,_ZTv0_n16_N8S7825C19D1Ev)();
extern void ABISELECT(_ZThn32_N8S7825C19D1Ev,_ZThn20_N8S7825C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7825C19D0Ev,_ZTv0_n16_N8S7825C19D0Ev)();
extern void ABISELECT(_ZThn32_N8S7825C19D0Ev,_ZThn20_N8S7825C19D0Ev)() __attribute__((weak));
extern void _ZN8S7825C152v2Ev();
extern void ABISELECT(_ZTvn16_n32_N8S7825C19D1Ev,_ZTvn8_n16_N8S7825C19D1Ev)();
extern void ABISELECT(_ZTvn16_n32_N8S7825C19D0Ev,_ZTvn8_n16_N8S7825C19D0Ev)();
extern void ABISELECT(_ZTvn32_n32_N8S7825C19D1Ev,_ZTvn16_n16_N8S7825C19D1Ev)();
extern void ABISELECT(_ZTvn32_n32_N8S7825C19D0Ev,_ZTvn16_n16_N8S7825C19D0Ev)();
extern void ABISELECT(_ZTv0_n24_N8S7825C19D1Ev,_ZTv0_n12_N8S7825C19D1Ev)();
extern void ABISELECT(_ZThn88_N8S7825C19D1Ev,_ZThn48_N8S7825C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C19D0Ev,_ZTv0_n12_N8S7825C19D0Ev)();
extern void ABISELECT(_ZThn88_N8S7825C19D0Ev,_ZThn48_N8S7825C19D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7825C19[] = {
  ABISELECT(88,48),
  0,
  ABISELECT(32,20),
  0,
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C19[0]),
  (VTBL_ENTRY)&_ZN8S7825C19D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C19D0Ev,
  ABISELECT(-16,-12),
  ABISELECT(72,36),
  ABISELECT(-16,-12),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8S7825C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7825C19D1Ev,_ZTv0_n28_N8S7825C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7825C19D0Ev,_ZTv0_n28_N8S7825C19D0Ev),
  0,
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI8S7825C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7825C19D1Ev,_ZTv0_n16_N8S7825C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7825C19D0Ev,_ZTv0_n16_N8S7825C19D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI8S7825C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n32_N8S7825C19D1Ev,_ZTvn8_n16_N8S7825C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n32_N8S7825C19D0Ev,_ZTvn8_n16_N8S7825C19D0Ev),
  ABISELECT(-64,-36),
  (VTBL_ENTRY)&(_ZTI8S7825C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n32_N8S7825C19D1Ev,_ZTvn16_n16_N8S7825C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n32_N8S7825C19D0Ev,_ZTvn16_n16_N8S7825C19D0Ev),
  ABISELECT(-88,-48),
  ABISELECT(-88,-48),
  (VTBL_ENTRY)&(_ZTI8S7825C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C19D1Ev,_ZTv0_n12_N8S7825C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C19D0Ev,_ZTv0_n12_N8S7825C19D0Ev),
};
extern VTBL_ENTRY _ZTV8S7825C19[];
extern void _ZN8S7825C20D1Ev();
extern void _ZN8S7825C20D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C20__8S7825C19[] = {
  ABISELECT(72,36),
  ABISELECT(-16,-12),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C20[0]),
  (VTBL_ENTRY)&_ZN8S7825C20D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C20D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S7825C20D1Ev,_ZTv0_n16_N8S7825C20D1Ev)();
extern void ABISELECT(_ZThn16_N8S7825C20D1Ev,_ZThn8_N8S7825C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7825C20D0Ev,_ZTv0_n16_N8S7825C20D0Ev)();
extern void ABISELECT(_ZThn16_N8S7825C20D0Ev,_ZThn8_N8S7825C20D0Ev)() __attribute__((weak));
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C15__8S7825C20__8S7825C19[] = {
  0,
  ABISELECT(-16,-8),
  ABISELECT(-32,-20),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S7825C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7825C20D1Ev,_ZTv0_n16_N8S7825C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7825C20D0Ev,_ZTv0_n16_N8S7825C20D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
extern void ABISELECT(_ZTvn16_n32_N8S7825C20D1Ev,_ZTvn8_n16_N8S7825C20D1Ev)();
extern void ABISELECT(_ZTvn16_n32_N8S7825C20D0Ev,_ZTvn8_n16_N8S7825C20D0Ev)();
static  VTBL_ENTRY _tg__ZTV10S7825C8_nt8S7825C15__A1__8S7825C20__8S7825C19[] = {
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S7825C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n32_N8S7825C20D1Ev,_ZTvn8_n16_N8S7825C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n32_N8S7825C20D0Ev,_ZTvn8_n16_N8S7825C20D0Ev),
};
extern void ABISELECT(_ZTvn32_n32_N8S7825C20D1Ev,_ZTvn16_n16_N8S7825C20D1Ev)();
extern void ABISELECT(_ZTvn32_n32_N8S7825C20D0Ev,_ZTvn16_n16_N8S7825C20D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S7825C58S7825C15__8S7825C20__8S7825C19[] = {
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S7825C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n32_N8S7825C20D1Ev,_ZTvn16_n16_N8S7825C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n32_N8S7825C20D0Ev,_ZTvn16_n16_N8S7825C20D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C20D1Ev,_ZTv0_n12_N8S7825C20D1Ev)();
extern void ABISELECT(_ZThn72_N8S7825C20D1Ev,_ZThn36_N8S7825C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C20D0Ev,_ZTv0_n12_N8S7825C20D0Ev)();
extern void ABISELECT(_ZThn72_N8S7825C20D0Ev,_ZThn36_N8S7825C20D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C13__8S7825C20__8S7825C19[] = {
  ABISELECT(-72,-36),
  ABISELECT(-72,-36),
  (VTBL_ENTRY)&(_ZTI8S7825C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C20D1Ev,_ZTv0_n12_N8S7825C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C20D0Ev,_ZTv0_n12_N8S7825C20D0Ev),
};
extern void _ZN8S7825C15D1Ev();
extern void _ZN8S7825C15D0Ev();
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C15__8S7825C19[] = {
  ABISELECT(-32,-20),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C15[0]),
  (VTBL_ENTRY)&_ZN8S7825C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C15D0Ev,
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
static  VTT_ENTRY vtt_S7825C19[] = {
  {&(_ZTV8S7825C19[7]),  7,39},
  {&(_ZTV8S7825C19[16]),  16,39},
  {&(_ZTV8S7825C19[23]),  23,39},
  {&(_ZTV8S7825C19[28]),  28,39},
  {&(_ZTV8S7825C19[32]),  32,39},
  {&(_ZTV8S7825C19[37]),  37,39},
  {&(_tg__ZTV8S7825C20__8S7825C19[6]),  6,8},
  {&(_tg__ZTV8S7825C15__8S7825C20__8S7825C19[5]),  5,8},
  {&(_tg__ZTV10S7825C8_nt8S7825C15__A1__8S7825C20__8S7825C19[2]),  2,4},
  {&(_tg__ZTV7S7825C58S7825C15__8S7825C20__8S7825C19[2]),  2,4},
  {&(_tg__ZTV8S7825C13__8S7825C20__8S7825C19[3]),  3,5},
  {&(_tg__ZTV8S7825C15__8S7825C19[3]),  3,6},
};
extern VTBL_ENTRY _ZTI8S7825C19[];
extern  VTBL_ENTRY _ZTV8S7825C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C19[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C20D0Ev,_ZTv0_n12_N8S7825C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N8S7825C20D0Ev,_ZThn36_N8S7825C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C20D1Ev,_ZTv0_n12_N8S7825C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N8S7825C20D1Ev,_ZThn36_N8S7825C20D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7825C20D0Ev,_ZTv0_n16_N8S7825C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S7825C20D0Ev,_ZThn8_N8S7825C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7825C20D1Ev,_ZTv0_n16_N8S7825C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S7825C20D1Ev,_ZThn8_N8S7825C20D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C19D0Ev,_ZTv0_n12_N8S7825C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn88_N8S7825C19D0Ev,_ZThn48_N8S7825C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C19D1Ev,_ZTv0_n12_N8S7825C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn88_N8S7825C19D1Ev,_ZThn48_N8S7825C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7825C19D0Ev,_ZTv0_n16_N8S7825C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C19D0Ev,_ZThn20_N8S7825C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7825C19D1Ev,_ZTv0_n16_N8S7825C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C19D1Ev,_ZThn20_N8S7825C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7825C19D0Ev,_ZTv0_n28_N8S7825C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S7825C19D0Ev,_ZThn12_N8S7825C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7825C19D1Ev,_ZTv0_n28_N8S7825C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S7825C19D1Ev,_ZThn12_N8S7825C19D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7825C19 = {  "S7825C19", // class name
  bases_S7825C19, 22,
  &(vtc_S7825C19[0]), // expected_vtbl_contents
  &(vtt_S7825C19[0]), // expected_vtt_contents
  ABISELECT(120,64), // object size
  NSPAIRA(_ZTI8S7825C19),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S7825C19),39, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7825C19),12, //virtual table table var
  12, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C18  {
  ::S7825C19 s7825c18f0;
  void  mf7825c18(); // _ZN8S7825C189mf7825c18Ev
  virtual  ~S7825C18(); // _ZN8S7825C18D1Ev
  S7825C18(); // tgen
};
//SIG(-1 S7825C18) C1{ vd m FC2{ VBC3{ VBC4{ m} VBC5{ BC6{ m} BC7{ BC8{ vd m Fc} BC6} BC8 BC9{ BC4 BC6 BC8 vd Fp} VBC4 vd v1} VBC6 BC7 VBC10{ BC4 BC9 vd Fi} vd} FL}}


void  S7825C18 ::mf7825c18(){}
 S7825C18 ::~S7825C18(){ note_dtor("S7825C18", this);}
S7825C18 ::S7825C18(){ note_ctor("S7825C18", this);} // tgen

static void Test_S7825C18()
{
  extern Class_Descriptor cd_S7825C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(17,18)];
    init_test(&cd_S7825C18, buf);
    S7825C18 *dp, &lv = *(dp=new (buf) S7825C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,68), "sizeof(S7825C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7825C18)");
    check_field_offset(lv, s7825c18f0, ABISELECT(8,4), "S7825C18.s7825c18f0");
    test_class_info(&lv, &cd_S7825C18);
    dp->~S7825C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7825C18(Test_S7825C18, "S7825C18", ABISELECT(128,68));

#else // __cplusplus

extern void _ZN8S7825C18C1Ev();
extern void _ZN8S7825C18D1Ev();
Name_Map name_map_S7825C18[] = {
  NSPAIR(_ZN8S7825C18C1Ev),
  NSPAIR(_ZN8S7825C18D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S7825C18[];
extern void _ZN8S7825C18D1Ev();
extern void _ZN8S7825C18D0Ev();
static  VTBL_ENTRY vtc_S7825C18[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C18[0]),
  (VTBL_ENTRY)&_ZN8S7825C18D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C18D0Ev,
};
extern VTBL_ENTRY _ZTI8S7825C18[];
extern  VTBL_ENTRY _ZTV8S7825C18[];
Class_Descriptor cd_S7825C18 = {  "S7825C18", // class name
  0,0,//no base classes
  &(vtc_S7825C18[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(128,68), // object size
  NSPAIRA(_ZTI8S7825C18),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S7825C18),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C17  : S7825C8_nt , virtual S7825C18 , S2407C8_nt {
  __tsi64 s7825c17f0;
  virtual  ~S7825C17(); // _ZN8S7825C17D2Ev
  S7825C17(); // tgen
};
//SIG(-1 S7825C17) C1{ BC2{ vd m Fc} VBC3{ vd m FC4{ VBC5{ VBC6{ m} VBC7{ BC8{ m} BC9{ BC2 BC8} BC2 BC10{ BC6 BC8 BC2 vd Fp} VBC6 vd v1} VBC8 BC9 VBC11{ BC6 BC10 vd Fi} vd} FL}} BC12{ m} vd FL}


 S7825C17 ::~S7825C17(){ note_dtor("S7825C17", this);}
S7825C17 ::S7825C17(){ note_ctor("S7825C17", this);} // tgen

static void Test_S7825C17()
{
  extern Class_Descriptor cd_S7825C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(20,22)];
    init_test(&cd_S7825C17, buf);
    S7825C17 *dp, &lv = *(dp=new (buf) S7825C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(152,84), "sizeof(S7825C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7825C17)");
    check_base_class_offset(lv, (S7825C8_nt*), 0, "S7825C17");
    check_base_class_offset(lv, (S7825C18*), ABISELECT(24,16), "S7825C17");
    check_base_class_offset(lv, (S2407C8_nt*), 0, "S7825C17");
    check_field_offset(lv, s7825c17f0, ABISELECT(16,8), "S7825C17.s7825c17f0");
    test_class_info(&lv, &cd_S7825C17);
    dp->~S7825C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7825C17(Test_S7825C17, "S7825C17", ABISELECT(152,84));

#else // __cplusplus

extern void _ZN8S7825C17C1Ev();
extern void _ZN8S7825C17D2Ev();
Name_Map name_map_S7825C17[] = {
  NSPAIR(_ZN8S7825C17C1Ev),
  NSPAIR(_ZN8S7825C17D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C18;
extern VTBL_ENTRY _ZTI8S7825C18[];
extern  VTBL_ENTRY _ZTV8S7825C18[];
extern Class_Descriptor cd_S2407C8_nt;
extern VTBL_ENTRY _ZTI10S2407C8_nt[];
static Base_Class bases_S7825C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7825C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7825C18,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2407C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7825C17[];
extern void _ZN8S7825C17D1Ev();
extern void _ZN8S7825C17D0Ev();
extern void ABISELECT(_ZTv0_n24_N8S7825C17D1Ev,_ZTv0_n12_N8S7825C17D1Ev)();
extern void ABISELECT(_ZThn24_N8S7825C17D1Ev,_ZThn16_N8S7825C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C17D0Ev,_ZTv0_n12_N8S7825C17D0Ev)();
extern void ABISELECT(_ZThn24_N8S7825C17D0Ev,_ZThn16_N8S7825C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7825C17[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C17[0]),
  (VTBL_ENTRY)&_ZN8S7825C17D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C17D0Ev,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI8S7825C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C17D1Ev,_ZTv0_n12_N8S7825C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C17D0Ev,_ZTv0_n12_N8S7825C17D0Ev),
};
extern VTBL_ENTRY _ZTV8S7825C17[];
static  VTT_ENTRY vtt_S7825C17[] = {
  {&(_ZTV8S7825C17[3]),  3,10},
  {&(_ZTV8S7825C17[8]),  8,10},
};
extern VTBL_ENTRY _ZTI8S7825C17[];
extern  VTBL_ENTRY _ZTV8S7825C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C17[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C17D0Ev,_ZTv0_n12_N8S7825C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S7825C17D0Ev,_ZThn16_N8S7825C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C17D1Ev,_ZTv0_n12_N8S7825C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S7825C17D1Ev,_ZThn16_N8S7825C17D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7825C17 = {  "S7825C17", // class name
  bases_S7825C17, 3,
  &(vtc_S7825C17[0]), // expected_vtbl_contents
  &(vtt_S7825C17[0]), // expected_vtt_contents
  ABISELECT(152,84), // object size
  NSPAIRA(_ZTI8S7825C17),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S7825C17),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7825C17),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C23_nt  {
  void *s7825c23f0;
  void  mf7825c23(); // _ZN11S7825C23_nt9mf7825c23Ev
  virtual  ~S7825C23_nt(); // _ZN11S7825C23_ntD1Ev
  S7825C23_nt(); // tgen
};
//SIG(-1 S7825C23_nt) C1{ vd m Fp}


void  S7825C23_nt ::mf7825c23(){}
 S7825C23_nt ::~S7825C23_nt(){ note_dtor("S7825C23_nt", this);}
S7825C23_nt ::S7825C23_nt(){ note_ctor("S7825C23_nt", this);} // tgen

//skip512 S7825C23_nt

#else // __cplusplus

extern void _ZN11S7825C23_ntC1Ev();
extern void _ZN11S7825C23_ntD1Ev();
Name_Map name_map_S7825C23_nt[] = {
  NSPAIR(_ZN11S7825C23_ntC1Ev),
  NSPAIR(_ZN11S7825C23_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S7825C23_nt[];
extern void _ZN11S7825C23_ntD1Ev();
extern void _ZN11S7825C23_ntD0Ev();
static  VTBL_ENTRY vtc_S7825C23_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S7825C23_nt[0]),
  (VTBL_ENTRY)&_ZN11S7825C23_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S7825C23_ntD0Ev,
};
extern VTBL_ENTRY _ZTI11S7825C23_nt[];
VTBL_ENTRY *P__ZTI11S7825C23_nt = _ZTI11S7825C23_nt; 
extern  VTBL_ENTRY _ZTV11S7825C23_nt[];
Class_Descriptor cd_S7825C23_nt = {  "S7825C23_nt", // class name
  0,0,//no base classes
  &(vtc_S7825C23_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI11S7825C23_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S7825C23_nt),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C22  : virtual S7825C5 , virtual S7825C12 , S7825C23_nt , S7825C15 , S7825C14 {
  virtual  ~S7825C22(); // _ZN8S7825C22D2Ev
  S7825C22(); // tgen
};
//SIG(-1 S7825C22) C1{ VBC2{ BC3{ m} BC4{ m} BC5{ vd m Fc} vd Fp} VBC6{ VBC4 BC7{ BC3 BC2 vd Fi} VBC2 VBC8{ BC5 BC4} vd} BC9{ vd m Fp} BC10{ BC4 BC8 BC5 BC2 VBC3 vd v1} BC8 vd}


 S7825C22 ::~S7825C22(){ note_dtor("S7825C22", this);}
S7825C22 ::S7825C22(){ note_ctor("S7825C22", this);} // tgen

static void Test_S7825C22()
{
  extern Class_Descriptor cd_S7825C22;
  void *lvp;
  {
    ABISELECT(double,int) buf[21];
    init_test(&cd_S7825C22, buf);
    S7825C22 *dp, &lv = *(dp=new (buf) S7825C22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(160,80), "sizeof(S7825C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7825C22)");
    /*is_ambiguous_... S7825C22::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*), ABISELECT(88,44), "S7825C22");
    /*is_ambiguous_... S7825C22::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*), ABISELECT(88,44), "S7825C22");
    /*is_ambiguous_... S7825C22::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*), ABISELECT(88,44), "S7825C22");
    /*is_ambiguous_... S7825C22::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C5*), ABISELECT(88,44), "S7825C22");
    /*is_ambiguous_... S7825C12::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C12*), ABISELECT(88,44), "S7825C22");
    /*is_ambiguous_... S7825C12::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C12*), 0, "S7825C22");
    /*is_ambiguous_... S7825C13::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C13*)(S7825C12*), ABISELECT(136,68), "S7825C22");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(112,56), "S7825C22");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(112,56), "S7825C22");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(112,56), "S7825C22");
    check_base_class_offset(lv, (S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(112,56), "S7825C22");
    check_base_class_offset(lv, (S7825C13*)(S7825C12*), ABISELECT(112,56), "S7825C22");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*), ABISELECT(144,72), "S7825C22");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C14*), ABISELECT(144,72), "S7825C22");
    check_base_class_offset(lv, (S7825C14*)(S7825C12*), ABISELECT(144,72), "S7825C22");
    check_base_class_offset(lv, (S7825C12*), ABISELECT(112,56), "S7825C22");
    check_base_class_offset(lv, (S7825C23_nt*), 0, "S7825C22");
    /*is_ambiguous_... S7825C15::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C15*), ABISELECT(25,13), "S7825C22");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C15*), ABISELECT(16,8), "S7825C22");
    check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C15*), ABISELECT(16,8), "S7825C22");
    check_base_class_offset(lv, (S7825C14*)(S7825C15*), ABISELECT(16,8), "S7825C22");
    /*is_ambiguous_... S7825C15::S7825C8_nt */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C15*), ABISELECT(32,16), "S7825C22");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C15*), ABISELECT(48,24), "S7825C22");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C15*), ABISELECT(48,24), "S7825C22");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C15*), ABISELECT(48,24), "S7825C22");
    check_base_class_offset(lv, (S7825C5*)(S7825C15*), ABISELECT(48,24), "S7825C22");
    /*is_ambiguous_... S7825C15::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C15*), 0, "S7825C22");
    check_base_class_offset(lv, (S7825C15*), ABISELECT(16,8), "S7825C22");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*), ABISELECT(72,36), "S7825C22");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C14*), ABISELECT(72,36), "S7825C22");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C14*), ABISELECT(72,36), "S7825C22");
    test_class_info(&lv, &cd_S7825C22);
    dp->~S7825C22();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7825C22(Test_S7825C22, "S7825C22", ABISELECT(160,80));

#else // __cplusplus

extern void _ZN8S7825C22C1Ev();
extern void _ZN8S7825C22D2Ev();
Name_Map name_map_S7825C22[] = {
  NSPAIR(_ZN8S7825C22C1Ev),
  NSPAIR(_ZN8S7825C22D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C13;
extern VTBL_ENTRY _ZTI8S7825C13[];
extern  VTBL_ENTRY _ZTV8S7825C13[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C12;
extern VTBL_ENTRY _ZTI8S7825C12[];
extern  VTBL_ENTRY _ZTV8S7825C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C12[];
extern Class_Descriptor cd_S7825C23_nt;
extern VTBL_ENTRY _ZTI11S7825C23_nt[];
extern  VTBL_ENTRY _ZTV11S7825C23_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S7825C15;
extern VTBL_ENTRY _ZTI8S7825C15[];
extern  VTBL_ENTRY _ZTV8S7825C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C15[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
static Base_Class bases_S7825C22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2407C30,    ABISELECT(88,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(88,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(88,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(88,44), //bcp->offset
    27, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2407C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S2407C30,    ABISELECT(136,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(112,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(112,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(112,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(112,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7825C13,    ABISELECT(112,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(144,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(144,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(144,72), //bcp->offset
    40, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S7825C12,    ABISELECT(112,56), //bcp->offset
    32, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7825C23_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2407C27,    ABISELECT(25,13), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(48,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S2407C30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    26, //immediately_derived
  0, 1},
  {&cd_S7825C15,    ABISELECT(16,8), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7825C8_nt,    ABISELECT(72,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(72,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(72,36), //bcp->offset
    23, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7825C22[];
extern void _ZN8S7825C22D1Ev();
extern void _ZN8S7825C22D0Ev();
extern void ABISELECT(_ZThn16_N8S7825C22D1Ev,_ZThn8_N8S7825C22D1Ev)();
extern void ABISELECT(_ZThn16_N8S7825C22D0Ev,_ZThn8_N8S7825C22D0Ev)();
extern void _ZN8S7825C152v2Ev();
extern void ABISELECT(_ZThn32_N8S7825C22D1Ev,_ZThn16_N8S7825C22D1Ev)();
extern void ABISELECT(_ZThn32_N8S7825C22D0Ev,_ZThn16_N8S7825C22D0Ev)();
extern void ABISELECT(_ZThn48_N8S7825C22D1Ev,_ZThn24_N8S7825C22D1Ev)();
extern void ABISELECT(_ZThn48_N8S7825C22D0Ev,_ZThn24_N8S7825C22D0Ev)();
extern void ABISELECT(_ZThn72_N8S7825C22D1Ev,_ZThn36_N8S7825C22D1Ev)();
extern void ABISELECT(_ZThn72_N8S7825C22D0Ev,_ZThn36_N8S7825C22D0Ev)();
extern void ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev)();
extern void ABISELECT(_ZThn88_N8S7825C22D1Ev,_ZThn44_N8S7825C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev)();
extern void ABISELECT(_ZThn88_N8S7825C22D0Ev,_ZThn44_N8S7825C22D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7825C22D1Ev,_ZTv0_n24_N8S7825C22D1Ev)();
extern void ABISELECT(_ZThn112_N8S7825C22D1Ev,_ZThn56_N8S7825C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7825C22D0Ev,_ZTv0_n24_N8S7825C22D0Ev)();
extern void ABISELECT(_ZThn112_N8S7825C22D0Ev,_ZThn56_N8S7825C22D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev)();
extern void ABISELECT(_ZThn144_N8S7825C22D1Ev,_ZThn72_N8S7825C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev)();
extern void ABISELECT(_ZThn144_N8S7825C22D0Ev,_ZThn72_N8S7825C22D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7825C22[] = {
  0,
  ABISELECT(144,72),
  0,
  ABISELECT(112,56),
  ABISELECT(88,44),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&_ZN8S7825C22D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C22D0Ev,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C22D1Ev,_ZThn8_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C22D0Ev,_ZThn8_N8S7825C22D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S7825C22D1Ev,_ZThn16_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S7825C22D0Ev,_ZThn16_N8S7825C22D0Ev),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N8S7825C22D1Ev,_ZThn24_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N8S7825C22D0Ev,_ZThn24_N8S7825C22D0Ev),
  ABISELECT(-72,-36),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N8S7825C22D1Ev,_ZThn36_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N8S7825C22D0Ev,_ZThn36_N8S7825C22D0Ev),
  ABISELECT(-88,-44),
  ABISELECT(-88,-44),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev),
  ABISELECT(-112,-56),
  ABISELECT(32,16),
  ABISELECT(-24,-12),
  ABISELECT(-112,-56),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C22D1Ev,_ZTv0_n24_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C22D0Ev,_ZTv0_n24_N8S7825C22D0Ev),
  ABISELECT(-144,-72),
  ABISELECT(-144,-72),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev),
};
extern VTBL_ENTRY _ZTV8S7825C22[];
extern void _ZN8S7825C15D1Ev();
extern void _ZN8S7825C15D0Ev();
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C15__8S7825C22[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C15[0]),
  (VTBL_ENTRY)&_ZN8S7825C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C15D0Ev,
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
extern void _ZN8S7825C12D1Ev();
extern void _ZN8S7825C12D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C12__8S7825C22[] = {
  ABISELECT(32,16),
  ABISELECT(-24,-12),
  ABISELECT(-112,-56),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&_ZN8S7825C12D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C12D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S7825C5__A1__8S7825C12__8S7825C22[] = {
  ABISELECT(24,12),
  ABISELECT(24,12),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZThn32_N8S7825C12D1Ev,_ZThn16_N8S7825C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
extern void ABISELECT(_ZThn32_N8S7825C12D0Ev,_ZThn16_N8S7825C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C14__8S7825C12__8S7825C22[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
};
static  VTT_ENTRY vtt_S7825C22[] = {
  {&(_ZTV8S7825C22[7]),  7,45},
  {&(_tg__ZTV8S7825C15__8S7825C22[3]),  3,6},
  {&(_ZTV8S7825C22[30]),  30,45},
  {&(_ZTV8S7825C22[38]),  38,45},
  {&(_ZTV8S7825C22[43]),  43,45},
  {&(_ZTV8S7825C22[12]),  12,45},
  {&(_tg__ZTV8S7825C12__8S7825C22[5]),  5,7},
  {&(_tg__ZTV7S7825C5__A1__8S7825C12__8S7825C22[3]),  3,5},
  {&(_tg__ZTV8S7825C14__8S7825C12__8S7825C22[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S7825C22[];
extern  VTBL_ENTRY _ZTV8S7825C22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C22[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C12D0Ev,_ZThn16_N8S7825C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C12D1Ev,_ZThn16_N8S7825C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C22D0Ev,_ZTv0_n24_N8S7825C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N8S7825C22D0Ev,_ZThn56_N8S7825C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C22D1Ev,_ZTv0_n24_N8S7825C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N8S7825C22D1Ev,_ZThn56_N8S7825C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn144_N8S7825C22D0Ev,_ZThn72_N8S7825C22D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn88_N8S7825C22D0Ev,_ZThn44_N8S7825C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn144_N8S7825C22D1Ev,_ZThn72_N8S7825C22D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn88_N8S7825C22D1Ev,_ZThn44_N8S7825C22D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7825C22 = {  "S7825C22", // class name
  bases_S7825C22, 30,
  &(vtc_S7825C22[0]), // expected_vtbl_contents
  &(vtt_S7825C22[0]), // expected_vtt_contents
  ABISELECT(160,80), // object size
  NSPAIRA(_ZTI8S7825C22),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S7825C22),45, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7825C22),9, //virtual table table var
  17, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C10  : virtual S7825C11 , virtual S7825C16 , virtual S7825C17 , virtual S7825C22 , S2407C30 {
  __tsi64 s7825c10f0:64;
  ~S7825C10(); // tgen
  S7825C10(); // tgen
};
//SIG(-1 S7825C10) C1{ VBC2{ BC3{ VBC4{ m} BC5{ BC6{ m} BC7{ BC6 BC4 BC8{ vd m Fc} vd Fp} vd Fi} VBC7 VBC9{ BC8 BC4} vd} BC5 VBC6 BC10{ BC4 BC9 BC8 BC7 VBC6 vd v1} vd} VBC11{ BC7 vd} VBC12{ BC8 VBC13{ vd m FC14{ VBC15{ VBC6 VBC10 VBC4 BC9 VBC5 vd} FL}} BC16{ m} vd FL} VBC17{ VBC7 VBC3 BC18{ vd m Fp} BC10 BC9 vd} BC6 FL:64}


S7825C10 ::~S7825C10(){ note_dtor("S7825C10", this);} // tgen
S7825C10 ::S7825C10(){ note_ctor("S7825C10", this);} // tgen

static void Test_S7825C10()
{
  extern Class_Descriptor cd_S7825C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(60,63)];
    init_test(&cd_S7825C10, buf);
    S7825C10 *dp, &lv = *(dp=new (buf) S7825C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(472,248), "sizeof(S7825C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7825C10)");
    /*is_ambiguous_... S7825C12::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C12*)(S7825C11*), 0, "S7825C10");
    /*is_ambiguous_... S7825C10::S7825C12 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C12*), 0, "S7825C10");
    /*is_ambiguous_... S7825C13::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C13*)(S7825C12*)(S7825C11*), ABISELECT(40,24), "S7825C10");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C13*)(S7825C12*)(S7825C11*), ABISELECT(16,12), "S7825C10");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C13*)(S7825C12*)(S7825C11*), ABISELECT(16,12), "S7825C10");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C13*)(S7825C12*)(S7825C11*), ABISELECT(16,12), "S7825C10");
    check_base_class_offset(lv, (S7825C5*)(S7825C13*)(S7825C12*)(S7825C11*), ABISELECT(16,12), "S7825C10");
    check_base_class_offset(lv, (S7825C13*)(S7825C12*)(S7825C11*), ABISELECT(16,12), "S7825C10");
    /*is_ambiguous_... S7825C10::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*), ABISELECT(136,72), "S7825C10");
    /*is_ambiguous_... S7825C10::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*), ABISELECT(136,72), "S7825C10");
    /*is_ambiguous_... S7825C10::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*), ABISELECT(136,72), "S7825C10");
    /*is_ambiguous_... S7825C12::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C12*)(S7825C11*), ABISELECT(136,72), "S7825C10");
    /*is_ambiguous_... S7825C22::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C22*), ABISELECT(136,72), "S7825C10");
    /*is_ambiguous_... S7825C10::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C12*), ABISELECT(136,72), "S7825C10");
    /*is_ambiguous_... S7825C10::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*), ABISELECT(160,84), "S7825C10");
    /*is_ambiguous_... S7825C10::S7825C14 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C14*), ABISELECT(160,84), "S7825C10");
    check_base_class_offset(lv, (S7825C14*)(S7825C12*)(S7825C11*), ABISELECT(160,84), "S7825C10");
    /*is_ambiguous_... S7825C10::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C14*)(S7825C12*), ABISELECT(160,84), "S7825C10");
    check_base_class_offset(lv, (S7825C12*)(S7825C11*), ABISELECT(16,12), "S7825C10");
    /*is_ambiguous_... S7825C11::S7825C13 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C13*)(S7825C11*), ABISELECT(72,40), "S7825C10");
    /*is_ambiguous_... S7825C11::S7825C13 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C13*)(S7825C11*), ABISELECT(48,28), "S7825C10");
    /*is_ambiguous_... S7825C11::S7825C13 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C13*)(S7825C11*), ABISELECT(48,28), "S7825C10");
    /*is_ambiguous_... S7825C11::S7825C13 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C13*)(S7825C11*), ABISELECT(48,28), "S7825C10");
    /*is_ambiguous_... S7825C11::S7825C13 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C13*)(S7825C11*), ABISELECT(48,28), "S7825C10");
    /*is_ambiguous_... S7825C11::S7825C13 */ AMB_check_base_class_offset(lv, (S7825C13*)(S7825C11*), ABISELECT(48,28), "S7825C10");
    /*is_ambiguous_... S7825C11::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C11*), ABISELECT(169,89), "S7825C10");
    /*is_ambiguous_... S7825C15::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C15*)(S7825C11*), ABISELECT(169,89), "S7825C10");
    /*is_ambiguous_... S7825C15::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C15*)(S7825C22*), ABISELECT(169,89), "S7825C10");
    /*is_ambiguous_... S7825C15::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C15*)(S7825C11*), ABISELECT(89,49), "S7825C10");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C15*)(S7825C11*), ABISELECT(80,44), "S7825C10");
    check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C15*)(S7825C11*), ABISELECT(80,44), "S7825C10");
    check_base_class_offset(lv, (S7825C14*)(S7825C15*)(S7825C11*), ABISELECT(80,44), "S7825C10");
    /*is_ambiguous_... S7825C15::S7825C8_nt */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C15*)(S7825C11*), ABISELECT(96,52), "S7825C10");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C15*)(S7825C11*), ABISELECT(112,60), "S7825C10");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C15*)(S7825C11*), ABISELECT(112,60), "S7825C10");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C15*)(S7825C11*), ABISELECT(112,60), "S7825C10");
    check_base_class_offset(lv, (S7825C5*)(S7825C15*)(S7825C11*), ABISELECT(112,60), "S7825C10");
    check_base_class_offset(lv, (S7825C15*)(S7825C11*), ABISELECT(80,44), "S7825C10");
    check_base_class_offset(lv, (S7825C11*), ABISELECT(16,12), "S7825C10");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C16*), ABISELECT(176,92), "S7825C10");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C16*), ABISELECT(176,92), "S7825C10");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C16*), ABISELECT(176,92), "S7825C10");
    check_base_class_offset(lv, (S7825C5*)(S7825C16*), ABISELECT(176,92), "S7825C10");
    check_base_class_offset(lv, (S7825C16*), ABISELECT(176,92), "S7825C10");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C17*), ABISELECT(200,104), "S7825C10");
    check_base_class_offset(lv, (S7825C18*)(S7825C17*), ABISELECT(224,120), "S7825C10");
    check_base_class_offset(lv, (S2407C8_nt*)(S7825C17*), ABISELECT(200,104), "S7825C10");
    check_base_class_offset(lv, (S7825C17*), ABISELECT(200,104), "S7825C10");
    /*is_ambiguous_... S7825C10::S7825C12 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C13*)(S7825C12*), ABISELECT(464,244), "S7825C10");
    /*is_ambiguous_... S7825C10::S7825C12 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(440,232), "S7825C10");
    /*is_ambiguous_... S7825C10::S7825C12 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(440,232), "S7825C10");
    /*is_ambiguous_... S7825C10::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(440,232), "S7825C10");
    /*is_ambiguous_... S7825C10::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(440,232), "S7825C10");
    /*is_ambiguous_... S7825C10::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C13*)(S7825C12*), ABISELECT(440,232), "S7825C10");
    check_base_class_offset(lv, (S7825C12*)(S7825C22*), ABISELECT(440,232), "S7825C10");
    check_base_class_offset(lv, (S7825C23_nt*)(S7825C22*), ABISELECT(352,188), "S7825C10");
    /*is_ambiguous_... S7825C15::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C15*)(S7825C22*), ABISELECT(377,201), "S7825C10");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C15*)(S7825C22*), ABISELECT(368,196), "S7825C10");
    check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C15*)(S7825C22*), ABISELECT(368,196), "S7825C10");
    check_base_class_offset(lv, (S7825C14*)(S7825C15*)(S7825C22*), ABISELECT(368,196), "S7825C10");
    /*is_ambiguous_... S7825C15::S7825C8_nt */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C15*)(S7825C22*), ABISELECT(384,204), "S7825C10");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C15*)(S7825C22*), ABISELECT(400,212), "S7825C10");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C15*)(S7825C22*), ABISELECT(400,212), "S7825C10");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C15*)(S7825C22*), ABISELECT(400,212), "S7825C10");
    check_base_class_offset(lv, (S7825C5*)(S7825C15*)(S7825C22*), ABISELECT(400,212), "S7825C10");
    check_base_class_offset(lv, (S7825C15*)(S7825C22*), ABISELECT(368,196), "S7825C10");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C22*), ABISELECT(424,224), "S7825C10");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C22*), ABISELECT(424,224), "S7825C10");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C14*)(S7825C22*), ABISELECT(424,224), "S7825C10");
    check_base_class_offset(lv, (S7825C22*), ABISELECT(352,188), "S7825C10");
    /*is_ambiguous_... S7825C10::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*), 0, "S7825C10");
    set_bf_and_test(lv, s7825c10f0, ABISELECT(8,4), 0, 64, 1, "S7825C10");
    set_bf_and_test(lv, s7825c10f0, ABISELECT(8,4), 0, 64, hide_sll(1LL<<63), "S7825C10");
    test_class_info(&lv, &cd_S7825C10);
    dp->~S7825C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7825C10(Test_S7825C10, "S7825C10", ABISELECT(472,248));

#else // __cplusplus

extern void _ZN8S7825C10C1Ev();
extern void _ZN8S7825C10D1Ev();
Name_Map name_map_S7825C10[] = {
  NSPAIR(_ZN8S7825C10C1Ev),
  NSPAIR(_ZN8S7825C10D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C13;
extern VTBL_ENTRY _ZTI8S7825C13[];
extern  VTBL_ENTRY _ZTV8S7825C13[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C12;
extern VTBL_ENTRY _ZTI8S7825C12[];
extern  VTBL_ENTRY _ZTV8S7825C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C12[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C13;
extern VTBL_ENTRY _ZTI8S7825C13[];
extern  VTBL_ENTRY _ZTV8S7825C13[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C15;
extern VTBL_ENTRY _ZTI8S7825C15[];
extern  VTBL_ENTRY _ZTV8S7825C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C15[];
extern Class_Descriptor cd_S7825C11;
extern VTBL_ENTRY _ZTI8S7825C11[];
extern  VTBL_ENTRY _ZTV8S7825C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C11[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C16;
extern VTBL_ENTRY _ZTI8S7825C16[];
extern  VTBL_ENTRY _ZTV8S7825C16[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C18;
extern VTBL_ENTRY _ZTI8S7825C18[];
extern  VTBL_ENTRY _ZTV8S7825C18[];
extern Class_Descriptor cd_S2407C8_nt;
extern VTBL_ENTRY _ZTI10S2407C8_nt[];
extern Class_Descriptor cd_S7825C17;
extern VTBL_ENTRY _ZTI8S7825C17[];
extern  VTBL_ENTRY _ZTV8S7825C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C17[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C13;
extern VTBL_ENTRY _ZTI8S7825C13[];
extern  VTBL_ENTRY _ZTV8S7825C13[];
extern Class_Descriptor cd_S7825C12;
extern VTBL_ENTRY _ZTI8S7825C12[];
extern  VTBL_ENTRY _ZTV8S7825C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C12[];
extern Class_Descriptor cd_S7825C23_nt;
extern VTBL_ENTRY _ZTI11S7825C23_nt[];
extern  VTBL_ENTRY _ZTV11S7825C23_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C15;
extern VTBL_ENTRY _ZTI8S7825C15[];
extern  VTBL_ENTRY _ZTV8S7825C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C15[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C22;
extern VTBL_ENTRY _ZTI8S7825C22[];
extern  VTBL_ENTRY _ZTV8S7825C22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C22[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
static Base_Class bases_S7825C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2407C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S2407C30,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S7825C13,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(136,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(136,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(136,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(136,72), //bcp->offset
    42, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S7825C8_nt,    ABISELECT(160,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(160,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(160,84), //bcp->offset
    47, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S7825C12,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(72,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S7825C13,    ABISELECT(48,28), //bcp->offset
    24, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(169,89), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    31, //immediately_derived
  0, 1},
  {&cd_S2407C27,    ABISELECT(89,49), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(80,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(80,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(80,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(96,52), //bcp->offset
    34, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(112,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(112,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(112,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(112,60), //bcp->offset
    38, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S7825C15,    ABISELECT(80,44), //bcp->offset
    28, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S7825C11,    ABISELECT(16,12), //bcp->offset
    14, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2407C30,    ABISELECT(176,92), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    36, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(176,92), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    36, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(176,92), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    36, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(176,92), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S7825C16,    ABISELECT(176,92), //bcp->offset
    52, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7825C8_nt,    ABISELECT(200,104), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S7825C18,    ABISELECT(224,120), //bcp->offset
    63, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    41, //immediately_derived
  0, 1},
  {&cd_S2407C8_nt,    ABISELECT(200,104), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S7825C17,    ABISELECT(200,104), //bcp->offset
    57, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2407C30,    ABISELECT(464,244), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    47, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(440,232), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    46, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(440,232), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    46, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(440,232), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    46, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(440,232), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    47, //immediately_derived
  0, 0},
  {&cd_S7825C13,    ABISELECT(440,232), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    48, //immediately_derived
  0, 0},
  {&cd_S7825C12,    ABISELECT(440,232), //bcp->offset
    97, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    63, //immediately_derived
  0, 1},
  {&cd_S7825C23_nt,    ABISELECT(352,188), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    63, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(377,201), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    59, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(368,196), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    53, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(368,196), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    53, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(368,196), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    59, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(384,204), //bcp->offset
    85, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    59, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(400,212), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    58, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(400,212), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    58, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(400,212), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    58, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(400,212), //bcp->offset
    89, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    34, //init_seq
    59, //immediately_derived
  0, 0},
  {&cd_S7825C15,    ABISELECT(368,196), //bcp->offset
    79, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    29, //bcp->base_subarray_index_in_construction_vtbl_array
    35, //init_seq
    63, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(424,224), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    36, //init_seq
    62, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(424,224), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    62, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(424,224), //bcp->offset
    93, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    37, //init_seq
    63, //immediately_derived
  0, 0},
  {&cd_S7825C22,    ABISELECT(352,188), //bcp->offset
    68, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    38, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2407C30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7825C10[];
extern void _ZN8S7825C10D1Ev();
extern void _ZN8S7825C10D0Ev();
extern void ABISELECT(_ZTv0_n56_N8S7825C10D1Ev,_ZTv0_n28_N8S7825C10D1Ev)();
extern void ABISELECT(_ZThn16_N8S7825C10D1Ev,_ZThn12_N8S7825C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7825C10D0Ev,_ZTv0_n28_N8S7825C10D0Ev)();
extern void ABISELECT(_ZThn16_N8S7825C10D0Ev,_ZThn12_N8S7825C10D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn32_n56_N8S7825C10D1Ev,_ZTvn16_n28_N8S7825C10D1Ev)();
extern void ABISELECT(_ZTvn32_n56_N8S7825C10D0Ev,_ZTvn16_n28_N8S7825C10D0Ev)();
extern void ABISELECT(_ZTvn64_n56_N8S7825C10D1Ev,_ZTvn32_n28_N8S7825C10D1Ev)();
extern void ABISELECT(_ZTvn64_n56_N8S7825C10D0Ev,_ZTvn32_n28_N8S7825C10D0Ev)();
extern void _ZN8S7825C152v2Ev();
extern void ABISELECT(_ZTvn80_n56_N8S7825C10D1Ev,_ZTvn40_n28_N8S7825C10D1Ev)();
extern void ABISELECT(_ZTvn80_n56_N8S7825C10D0Ev,_ZTvn40_n28_N8S7825C10D0Ev)();
extern void ABISELECT(_ZTvn96_n56_N8S7825C10D1Ev,_ZTvn48_n28_N8S7825C10D1Ev)();
extern void ABISELECT(_ZTvn96_n56_N8S7825C10D0Ev,_ZTvn48_n28_N8S7825C10D0Ev)();
extern void ABISELECT(_ZTv0_n24_N8S7825C10D1Ev,_ZTv0_n12_N8S7825C10D1Ev)();
extern void ABISELECT(_ZThn136_N8S7825C10D1Ev,_ZThn72_N8S7825C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C10D0Ev,_ZTv0_n12_N8S7825C10D0Ev)();
extern void ABISELECT(_ZThn136_N8S7825C10D0Ev,_ZThn72_N8S7825C10D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C10D1Ev,_ZTv0_n12_N8S7825C10D1Ev)();
extern void ABISELECT(_ZThn160_N8S7825C10D1Ev,_ZThn84_N8S7825C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C10D0Ev,_ZTv0_n12_N8S7825C10D0Ev)();
extern void ABISELECT(_ZThn160_N8S7825C10D0Ev,_ZThn84_N8S7825C10D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C10D1Ev,_ZTv0_n12_N8S7825C10D1Ev)();
extern void ABISELECT(_ZThn176_N8S7825C10D1Ev,_ZThn92_N8S7825C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C10D0Ev,_ZTv0_n12_N8S7825C10D0Ev)();
extern void ABISELECT(_ZThn176_N8S7825C10D0Ev,_ZThn92_N8S7825C10D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7825C10D1Ev,_ZTv0_n16_N8S7825C10D1Ev)();
extern void ABISELECT(_ZThn200_N8S7825C10D1Ev,_ZThn104_N8S7825C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7825C10D0Ev,_ZTv0_n16_N8S7825C10D0Ev)();
extern void ABISELECT(_ZThn200_N8S7825C10D0Ev,_ZThn104_N8S7825C10D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C10D1Ev,_ZTv0_n12_N8S7825C10D1Ev)();
extern void ABISELECT(_ZThn224_N8S7825C10D1Ev,_ZThn120_N8S7825C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C10D0Ev,_ZTv0_n12_N8S7825C10D0Ev)();
extern void ABISELECT(_ZThn224_N8S7825C10D0Ev,_ZThn120_N8S7825C10D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S7825C10D1Ev,_ZTv0_n32_N8S7825C10D1Ev)();
extern void ABISELECT(_ZThn352_N8S7825C10D1Ev,_ZThn188_N8S7825C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S7825C10D0Ev,_ZTv0_n32_N8S7825C10D0Ev)();
extern void ABISELECT(_ZThn352_N8S7825C10D0Ev,_ZThn188_N8S7825C10D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n64_N8S7825C10D1Ev,_ZTvn8_n32_N8S7825C10D1Ev)();
extern void ABISELECT(_ZTvn16_n64_N8S7825C10D0Ev,_ZTvn8_n32_N8S7825C10D0Ev)();
extern void _ZN8S7825C152v2Ev();
extern void ABISELECT(_ZTvn32_n64_N8S7825C10D1Ev,_ZTvn16_n32_N8S7825C10D1Ev)();
extern void ABISELECT(_ZTvn32_n64_N8S7825C10D0Ev,_ZTvn16_n32_N8S7825C10D0Ev)();
extern void ABISELECT(_ZTvn48_n64_N8S7825C10D1Ev,_ZTvn24_n32_N8S7825C10D1Ev)();
extern void ABISELECT(_ZTvn48_n64_N8S7825C10D0Ev,_ZTvn24_n32_N8S7825C10D0Ev)();
extern void ABISELECT(_ZTvn72_n64_N8S7825C10D1Ev,_ZTvn36_n32_N8S7825C10D1Ev)();
extern void ABISELECT(_ZTvn72_n64_N8S7825C10D0Ev,_ZTvn36_n32_N8S7825C10D0Ev)();
extern void ABISELECT(_ZTv0_n48_N8S7825C10D1Ev,_ZTv0_n24_N8S7825C10D1Ev)();
extern void ABISELECT(_ZThn440_N8S7825C10D1Ev,_ZThn232_N8S7825C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7825C10D0Ev,_ZTv0_n24_N8S7825C10D0Ev)();
extern void ABISELECT(_ZThn440_N8S7825C10D0Ev,_ZThn232_N8S7825C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7825C10[] = {
  ABISELECT(440,232),
  ABISELECT(352,188),
  ABISELECT(224,120),
  ABISELECT(200,104),
  ABISELECT(176,92),
  ABISELECT(169,89),
  ABISELECT(160,84),
  ABISELECT(136,72),
  0,
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C10[0]),
  (VTBL_ENTRY)&_ZN8S7825C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C10D0Ev,
  ABISELECT(64,32),
  ABISELECT(-16,-12),
  ABISELECT(153,77),
  ABISELECT(144,72),
  ABISELECT(120,60),
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8S7825C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7825C10D1Ev,_ZTv0_n28_N8S7825C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7825C10D0Ev,_ZTv0_n28_N8S7825C10D0Ev),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI8S7825C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n56_N8S7825C10D1Ev,_ZTvn16_n28_N8S7825C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n56_N8S7825C10D0Ev,_ZTvn16_n28_N8S7825C10D0Ev),
  ABISELECT(89,45),
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI8S7825C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn64_n56_N8S7825C10D1Ev,_ZTvn32_n28_N8S7825C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn64_n56_N8S7825C10D0Ev,_ZTvn32_n28_N8S7825C10D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI8S7825C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn80_n56_N8S7825C10D1Ev,_ZTvn40_n28_N8S7825C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn80_n56_N8S7825C10D0Ev,_ZTvn40_n28_N8S7825C10D0Ev),
  ABISELECT(-112,-60),
  (VTBL_ENTRY)&(_ZTI8S7825C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn96_n56_N8S7825C10D1Ev,_ZTvn48_n28_N8S7825C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn96_n56_N8S7825C10D0Ev,_ZTvn48_n28_N8S7825C10D0Ev),
  ABISELECT(-136,-72),
  ABISELECT(-136,-72),
  (VTBL_ENTRY)&(_ZTI8S7825C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C10D1Ev,_ZTv0_n12_N8S7825C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C10D0Ev,_ZTv0_n12_N8S7825C10D0Ev),
  ABISELECT(-160,-84),
  ABISELECT(-160,-84),
  (VTBL_ENTRY)&(_ZTI8S7825C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C10D1Ev,_ZTv0_n12_N8S7825C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C10D0Ev,_ZTv0_n12_N8S7825C10D0Ev),
  ABISELECT(-176,-92),
  ABISELECT(-176,-92),
  (VTBL_ENTRY)&(_ZTI8S7825C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C10D1Ev,_ZTv0_n12_N8S7825C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C10D0Ev,_ZTv0_n12_N8S7825C10D0Ev),
  ABISELECT(-200,-104),
  ABISELECT(24,16),
  ABISELECT(-200,-104),
  (VTBL_ENTRY)&(_ZTI8S7825C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7825C10D1Ev,_ZTv0_n16_N8S7825C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7825C10D0Ev,_ZTv0_n16_N8S7825C10D0Ev),
  ABISELECT(-224,-120),
  ABISELECT(-224,-120),
  (VTBL_ENTRY)&(_ZTI8S7825C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C10D1Ev,_ZTv0_n12_N8S7825C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C10D0Ev,_ZTv0_n12_N8S7825C10D0Ev),
  ABISELECT(16,8),
  ABISELECT(-352,-188),
  ABISELECT(-183,-99),
  ABISELECT(-192,-104),
  ABISELECT(-352,-188),
  ABISELECT(88,44),
  ABISELECT(-216,-116),
  ABISELECT(-352,-188),
  (VTBL_ENTRY)&(_ZTI8S7825C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7825C10D1Ev,_ZTv0_n32_N8S7825C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7825C10D0Ev,_ZTv0_n32_N8S7825C10D0Ev),
  ABISELECT(-199,-107),
  ABISELECT(-368,-196),
  (VTBL_ENTRY)&(_ZTI8S7825C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n64_N8S7825C10D1Ev,_ZTvn8_n32_N8S7825C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n64_N8S7825C10D0Ev,_ZTvn8_n32_N8S7825C10D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
  ABISELECT(-384,-204),
  (VTBL_ENTRY)&(_ZTI8S7825C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n64_N8S7825C10D1Ev,_ZTvn16_n32_N8S7825C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n64_N8S7825C10D0Ev,_ZTvn16_n32_N8S7825C10D0Ev),
  ABISELECT(-400,-212),
  (VTBL_ENTRY)&(_ZTI8S7825C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn48_n64_N8S7825C10D1Ev,_ZTvn24_n32_N8S7825C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn48_n64_N8S7825C10D0Ev,_ZTvn24_n32_N8S7825C10D0Ev),
  ABISELECT(-424,-224),
  (VTBL_ENTRY)&(_ZTI8S7825C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn72_n64_N8S7825C10D1Ev,_ZTvn36_n32_N8S7825C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn72_n64_N8S7825C10D0Ev,_ZTvn36_n32_N8S7825C10D0Ev),
  ABISELECT(-440,-232),
  ABISELECT(-280,-148),
  ABISELECT(-304,-160),
  ABISELECT(-440,-232),
  ABISELECT(-440,-232),
  (VTBL_ENTRY)&(_ZTI8S7825C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C10D1Ev,_ZTv0_n24_N8S7825C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C10D0Ev,_ZTv0_n24_N8S7825C10D0Ev),
};
extern VTBL_ENTRY _ZTV8S7825C10[];
extern void _ZN8S7825C11D1Ev();
extern void _ZN8S7825C11D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C11__8S7825C10[] = {
  ABISELECT(153,77),
  ABISELECT(144,72),
  ABISELECT(120,60),
  ABISELECT(-16,-12),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C11[0]),
  (VTBL_ENTRY)&_ZN8S7825C11D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C11D0Ev,
};
extern void _ZN8S7825C12D1Ev();
extern void _ZN8S7825C12D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C128S7825C11__8S7825C10[] = {
  ABISELECT(144,72),
  ABISELECT(120,60),
  ABISELECT(-16,-12),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&_ZN8S7825C12D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C12D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZThn120_N8S7825C12D1Ev,_ZThn60_N8S7825C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
extern void ABISELECT(_ZThn120_N8S7825C12D0Ev,_ZThn60_N8S7825C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7825C5__A1__8S7825C128S7825C11__8S7825C10[] = {
  ABISELECT(-120,-60),
  ABISELECT(-120,-60),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZThn144_N8S7825C12D1Ev,_ZThn72_N8S7825C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
extern void ABISELECT(_ZThn144_N8S7825C12D0Ev,_ZThn72_N8S7825C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C14__8S7825C128S7825C11__8S7825C10[] = {
  ABISELECT(-144,-72),
  ABISELECT(-144,-72),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
};
extern void _ZN8S7825C15D1Ev();
extern void _ZN8S7825C15D0Ev();
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C158S7825C11__8S7825C10[] = {
  ABISELECT(89,45),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C15[0]),
  (VTBL_ENTRY)&_ZN8S7825C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C15D0Ev,
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C11D1Ev,_ZTv0_n12_N8S7825C11D1Ev)();
extern void ABISELECT(_ZThn120_N8S7825C11D1Ev,_ZThn60_N8S7825C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C11D0Ev,_ZTv0_n12_N8S7825C11D0Ev)();
extern void ABISELECT(_ZThn120_N8S7825C11D0Ev,_ZThn60_N8S7825C11D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7825C5__A1__8S7825C11__8S7825C10[] = {
  ABISELECT(-120,-60),
  ABISELECT(-120,-60),
  (VTBL_ENTRY)&(_ZTI8S7825C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C11D1Ev,_ZTv0_n12_N8S7825C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C11D0Ev,_ZTv0_n12_N8S7825C11D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C11D1Ev,_ZTv0_n12_N8S7825C11D1Ev)();
extern void ABISELECT(_ZThn144_N8S7825C11D1Ev,_ZThn72_N8S7825C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C11D0Ev,_ZTv0_n12_N8S7825C11D0Ev)();
extern void ABISELECT(_ZThn144_N8S7825C11D0Ev,_ZThn72_N8S7825C11D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C14__8S7825C11__8S7825C10[] = {
  ABISELECT(-144,-72),
  ABISELECT(-144,-72),
  (VTBL_ENTRY)&(_ZTI8S7825C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C11D1Ev,_ZTv0_n12_N8S7825C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C11D0Ev,_ZTv0_n12_N8S7825C11D0Ev),
};
extern void ABISELECT(_ZThn64_N8S7825C11D1Ev,_ZThn32_N8S7825C11D1Ev)();
extern void ABISELECT(_ZThn64_N8S7825C11D0Ev,_ZThn32_N8S7825C11D0Ev)();
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C15__8S7825C11__8S7825C10[] = {
  ABISELECT(89,45),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI8S7825C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N8S7825C11D1Ev,_ZThn32_N8S7825C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N8S7825C11D0Ev,_ZThn32_N8S7825C11D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
extern void _ZN8S7825C17D1Ev();
extern void _ZN8S7825C17D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C17__8S7825C10[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C17[0]),
  (VTBL_ENTRY)&_ZN8S7825C17D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C17D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C17D1Ev,_ZTv0_n12_N8S7825C17D1Ev)();
extern void ABISELECT(_ZThn24_N8S7825C17D1Ev,_ZThn16_N8S7825C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C17D0Ev,_ZTv0_n12_N8S7825C17D0Ev)();
extern void ABISELECT(_ZThn24_N8S7825C17D0Ev,_ZThn16_N8S7825C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C18__8S7825C17__8S7825C10[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI8S7825C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C17D1Ev,_ZTv0_n12_N8S7825C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C17D0Ev,_ZTv0_n12_N8S7825C17D0Ev),
};
extern void _ZN8S7825C22D1Ev();
extern void _ZN8S7825C22D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C22__8S7825C10[] = {
  ABISELECT(-183,-99),
  ABISELECT(-192,-104),
  ABISELECT(-352,-188),
  ABISELECT(88,44),
  ABISELECT(-216,-116),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&_ZN8S7825C22D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C22D0Ev,
};
extern void _ZN8S7825C15D1Ev();
extern void _ZN8S7825C15D0Ev();
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C158S7825C22__A1__8S7825C10[] = {
  ABISELECT(-199,-107),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C15[0]),
  (VTBL_ENTRY)&_ZN8S7825C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C15D0Ev,
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S7825C5__8S7825C22__8S7825C10[] = {
  ABISELECT(216,116),
  ABISELECT(216,116),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev),
};
extern void ABISELECT(_ZTv0_n48_N8S7825C22D1Ev,_ZTv0_n24_N8S7825C22D1Ev)();
extern void ABISELECT(_ZThn88_N8S7825C22D1Ev,_ZThn44_N8S7825C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7825C22D0Ev,_ZTv0_n24_N8S7825C22D0Ev)();
extern void ABISELECT(_ZThn88_N8S7825C22D0Ev,_ZThn44_N8S7825C22D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C12__8S7825C22__8S7825C10[] = {
  ABISELECT(-88,-44),
  ABISELECT(-280,-148),
  ABISELECT(-304,-160),
  ABISELECT(-440,-232),
  ABISELECT(-88,-44),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C22D1Ev,_ZTv0_n24_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C22D0Ev,_ZTv0_n24_N8S7825C22D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S7825C14__8S7825C22__8S7825C10[] = {
  ABISELECT(192,104),
  ABISELECT(192,104),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev),
};
extern void ABISELECT(_ZThn16_N8S7825C22D1Ev,_ZThn8_N8S7825C22D1Ev)();
extern void ABISELECT(_ZThn16_N8S7825C22D0Ev,_ZThn8_N8S7825C22D0Ev)();
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C15__8S7825C22__8S7825C10[] = {
  ABISELECT(-199,-107),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C22D1Ev,_ZThn8_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C22D0Ev,_ZThn8_N8S7825C22D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
extern void _ZN8S7825C12D1Ev();
extern void _ZN8S7825C12D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C12__A1__8S7825C10[] = {
  ABISELECT(-280,-148),
  ABISELECT(-304,-160),
  ABISELECT(-440,-232),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&_ZN8S7825C12D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C12D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S7825C5__A1__8S7825C12__A1__8S7825C10[] = {
  ABISELECT(304,160),
  ABISELECT(304,160),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S7825C14__8S7825C12__A1__8S7825C10[] = {
  ABISELECT(280,148),
  ABISELECT(280,148),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
};
static  VTT_ENTRY vtt_S7825C10[] = {
  {&(_ZTV8S7825C10[12]),  12,105},
  {&(_ZTV8S7825C10[22]),  22,105},
  {&(_ZTV8S7825C10[45]),  45,105},
  {&(_ZTV8S7825C10[50]),  50,105},
  {&(_ZTV8S7825C10[26]),  26,105},
  {&(_ZTV8S7825C10[31]),  31,105},
  {&(_ZTV8S7825C10[36]),  36,105},
  {&(_ZTV8S7825C10[40]),  40,105},
  {&(_ZTV8S7825C10[55]),  55,105},
  {&(_ZTV8S7825C10[61]),  61,105},
  {&(_ZTV8S7825C10[66]),  66,105},
  {&(_ZTV8S7825C10[77]),  77,105},
  {&(_ZTV8S7825C10[103]),  103,105},
  {&(_ZTV8S7825C10[82]),  82,105},
  {&(_ZTV8S7825C10[87]),  87,105},
  {&(_ZTV8S7825C10[91]),  91,105},
  {&(_ZTV8S7825C10[95]),  95,105},
  {&(_tg__ZTV8S7825C11__8S7825C10[6]),  6,8},
  {&(_tg__ZTV8S7825C128S7825C11__8S7825C10[5]),  5,7},
  {&(_tg__ZTV7S7825C5__A1__8S7825C128S7825C11__8S7825C10[3]),  3,5},
  {&(_tg__ZTV8S7825C14__8S7825C128S7825C11__8S7825C10[3]),  3,5},
  {&(_tg__ZTV8S7825C158S7825C11__8S7825C10[3]),  3,6},
  {&(_tg__ZTV7S7825C5__A1__8S7825C11__8S7825C10[3]),  3,5},
  {&(_tg__ZTV8S7825C14__8S7825C11__8S7825C10[3]),  3,5},
  {&(_tg__ZTV8S7825C15__8S7825C11__8S7825C10[3]),  3,6},
  {&(_tg__ZTV8S7825C17__8S7825C10[3]),  3,5},
  {&(_tg__ZTV8S7825C18__8S7825C17__8S7825C10[3]),  3,5},
  {&(_tg__ZTV8S7825C22__8S7825C10[7]),  7,9},
  {&(_tg__ZTV8S7825C158S7825C22__A1__8S7825C10[3]),  3,6},
  {&(_tg__ZTV7S7825C5__8S7825C22__8S7825C10[3]),  3,5},
  {&(_tg__ZTV8S7825C12__8S7825C22__8S7825C10[6]),  6,8},
  {&(_tg__ZTV8S7825C14__8S7825C22__8S7825C10[3]),  3,5},
  {&(_tg__ZTV8S7825C15__8S7825C22__8S7825C10[3]),  3,6},
  {&(_tg__ZTV8S7825C12__A1__8S7825C10[5]),  5,7},
  {&(_tg__ZTV7S7825C5__A1__8S7825C12__A1__8S7825C10[3]),  3,5},
  {&(_tg__ZTV8S7825C14__8S7825C12__A1__8S7825C10[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S7825C10[];
extern  VTBL_ENTRY _ZTV8S7825C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C10[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C22D0Ev,_ZTv0_n24_N8S7825C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn88_N8S7825C22D0Ev,_ZThn44_N8S7825C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C22D1Ev,_ZTv0_n24_N8S7825C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn88_N8S7825C22D1Ev,_ZThn44_N8S7825C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C17D0Ev,_ZTv0_n12_N8S7825C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S7825C17D0Ev,_ZThn16_N8S7825C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C17D1Ev,_ZTv0_n12_N8S7825C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S7825C17D1Ev,_ZThn16_N8S7825C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C11D0Ev,_ZTv0_n12_N8S7825C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn144_N8S7825C11D0Ev,_ZThn72_N8S7825C11D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn120_N8S7825C11D0Ev,_ZThn60_N8S7825C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C11D1Ev,_ZTv0_n12_N8S7825C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn144_N8S7825C11D1Ev,_ZThn72_N8S7825C11D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn120_N8S7825C11D1Ev,_ZThn60_N8S7825C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn144_N8S7825C12D0Ev,_ZThn72_N8S7825C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn120_N8S7825C12D0Ev,_ZThn60_N8S7825C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn144_N8S7825C12D1Ev,_ZThn72_N8S7825C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn120_N8S7825C12D1Ev,_ZThn60_N8S7825C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C10D0Ev,_ZTv0_n24_N8S7825C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn440_N8S7825C10D0Ev,_ZThn232_N8S7825C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C10D1Ev,_ZTv0_n24_N8S7825C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn440_N8S7825C10D1Ev,_ZThn232_N8S7825C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S7825C10D0Ev,_ZTv0_n32_N8S7825C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn352_N8S7825C10D0Ev,_ZThn188_N8S7825C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S7825C10D1Ev,_ZTv0_n32_N8S7825C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn352_N8S7825C10D1Ev,_ZThn188_N8S7825C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7825C10D0Ev,_ZTv0_n16_N8S7825C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn200_N8S7825C10D0Ev,_ZThn104_N8S7825C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7825C10D1Ev,_ZTv0_n16_N8S7825C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn200_N8S7825C10D1Ev,_ZThn104_N8S7825C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C10D0Ev,_ZTv0_n12_N8S7825C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N8S7825C10D0Ev,_ZThn120_N8S7825C10D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7825C10D0Ev,_ZThn92_N8S7825C10D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn160_N8S7825C10D0Ev,_ZThn84_N8S7825C10D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn136_N8S7825C10D0Ev,_ZThn72_N8S7825C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C10D1Ev,_ZTv0_n12_N8S7825C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N8S7825C10D1Ev,_ZThn120_N8S7825C10D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7825C10D1Ev,_ZThn92_N8S7825C10D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn160_N8S7825C10D1Ev,_ZThn84_N8S7825C10D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn136_N8S7825C10D1Ev,_ZThn72_N8S7825C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7825C10D0Ev,_ZTv0_n28_N8S7825C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S7825C10D0Ev,_ZThn12_N8S7825C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7825C10D1Ev,_ZTv0_n28_N8S7825C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S7825C10D1Ev,_ZThn12_N8S7825C10D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7825C10 = {  "S7825C10", // class name
  bases_S7825C10, 65,
  &(vtc_S7825C10[0]), // expected_vtbl_contents
  &(vtt_S7825C10[0]), // expected_vtt_contents
  ABISELECT(472,248), // object size
  NSPAIRA(_ZTI8S7825C10),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S7825C10),105, //virtual function table var
  12, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7825C10),36, //virtual table table var
  38, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C4  : virtual S7825C5 , S2407C23 {
  ::S7825C10 s7825c4f0;
  int s7825c4f1[7];
  virtual  ~S7825C4(); // _ZN7S7825C4D2Ev
  S7825C4(); // tgen
};
//SIG(-1 S7825C4) C1{ VBC2{ BC3{ m} BC4{ m} BC5{ vd m Fc} vd Fp} BC6{ m} vd FC7{ VBC8{ BC9{ VBC4 BC10{ BC3 BC2 vd Fi} VBC2 VBC11{ BC5 BC4} vd} BC10 VBC3 BC12{ BC4 BC11 BC5 BC2 VBC3 vd v1} vd} VBC13{ BC2 vd} VBC14{ BC5 VBC15{ vd m FC16{ VBC17{ VBC3 VBC12 VBC4 BC11 VBC10 vd} FL}} BC18{ m} vd FL} VBC19{ VBC2 VBC9 BC20{ vd m Fp} BC12 BC11 vd} BC3 FL:64} Fi[7]}


 S7825C4 ::~S7825C4(){ note_dtor("S7825C4", this);}
S7825C4 ::S7825C4(){ note_ctor("S7825C4", this);} // tgen

static void Test_S7825C4()
{
  extern Class_Descriptor cd_S7825C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(68,74)];
    init_test(&cd_S7825C4, buf);
    S7825C4 *dp, &lv = *(dp=new (buf) S7825C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(536,292), "sizeof(S7825C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7825C4)");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*), ABISELECT(512,280), "S7825C4");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*), ABISELECT(512,280), "S7825C4");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*), ABISELECT(512,280), "S7825C4");
    check_base_class_offset(lv, (S7825C5*), ABISELECT(512,280), "S7825C4");
    check_base_class_offset(lv, (S2407C23*), 0, "S7825C4");
    check_field_offset(lv, s7825c4f0, ABISELECT(8,4), "S7825C4.s7825c4f0");
    check_field_offset(lv, s7825c4f1, ABISELECT(480,252), "S7825C4.s7825c4f1");
    test_class_info(&lv, &cd_S7825C4);
    dp->~S7825C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7825C4(Test_S7825C4, "S7825C4", ABISELECT(536,292));

#else // __cplusplus

extern void _ZN7S7825C4C1Ev();
extern void _ZN7S7825C4D2Ev();
Name_Map name_map_S7825C4[] = {
  NSPAIR(_ZN7S7825C4C1Ev),
  NSPAIR(_ZN7S7825C4D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S2407C23;
extern VTBL_ENTRY _ZTI8S2407C23[];
static Base_Class bases_S7825C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2407C30,    ABISELECT(512,280), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(512,280), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(512,280), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(512,280), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2407C23,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S7825C4[];
extern void _ZN7S7825C4D1Ev();
extern void _ZN7S7825C4D0Ev();
extern void ABISELECT(_ZTv0_n24_N7S7825C4D1Ev,_ZTv0_n12_N7S7825C4D1Ev)();
extern void ABISELECT(_ZThn512_N7S7825C4D1Ev,_ZThn280_N7S7825C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7825C4D0Ev,_ZTv0_n12_N7S7825C4D0Ev)();
extern void ABISELECT(_ZThn512_N7S7825C4D0Ev,_ZThn280_N7S7825C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7825C4[] = {
  ABISELECT(512,280),
  0,
  (VTBL_ENTRY)&(_ZTI7S7825C4[0]),
  (VTBL_ENTRY)&_ZN7S7825C4D1Ev,
  (VTBL_ENTRY)&_ZN7S7825C4D0Ev,
  ABISELECT(-512,-280),
  ABISELECT(-512,-280),
  (VTBL_ENTRY)&(_ZTI7S7825C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7825C4D1Ev,_ZTv0_n12_N7S7825C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7825C4D0Ev,_ZTv0_n12_N7S7825C4D0Ev),
};
extern VTBL_ENTRY _ZTV7S7825C4[];
static  VTT_ENTRY vtt_S7825C4[] = {
  {&(_ZTV7S7825C4[3]),  3,10},
  {&(_ZTV7S7825C4[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7S7825C4[];
extern  VTBL_ENTRY _ZTV7S7825C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7825C4[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7825C4D0Ev,_ZTv0_n12_N7S7825C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn512_N7S7825C4D0Ev,_ZThn280_N7S7825C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7825C4D1Ev,_ZTv0_n12_N7S7825C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn512_N7S7825C4D1Ev,_ZThn280_N7S7825C4D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7825C4 = {  "S7825C4", // class name
  bases_S7825C4, 5,
  &(vtc_S7825C4[0]), // expected_vtbl_contents
  &(vtt_S7825C4[0]), // expected_vtt_contents
  ABISELECT(536,292), // object size
  NSPAIRA(_ZTI7S7825C4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S7825C4),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7825C4),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C25  : virtual S7825C8_nt , S7825C14 , virtual S2407C30 {
  virtual  ~S7825C25(); // _ZN8S7825C25D2Ev
  S7825C25(); // tgen
};
//SIG(-1 S7825C25) C1{ VBC2{ vd m Fc} BC3{ BC2 BC4{ m}} VBC5{ m} vd}


 S7825C25 ::~S7825C25(){ note_dtor("S7825C25", this);}
S7825C25 ::S7825C25(){ note_ctor("S7825C25", this);} // tgen

static void Test_S7825C25()
{
  extern Class_Descriptor cd_S7825C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S7825C25, buf);
    S7825C25 *dp, &lv = *(dp=new (buf) S7825C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S7825C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7825C25)");
    /*is_ambiguous_... S7825C25::S7825C8_nt */ AMB_check_base_class_offset(lv, (S7825C8_nt*), ABISELECT(16,8), "S7825C25");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*), 0, "S7825C25");
    check_base_class_offset(lv, (S2407C27*)(S7825C14*), 0, "S7825C25");
    check_base_class_offset(lv, (S7825C14*), 0, "S7825C25");
    check_base_class_offset(lv, (S2407C30*), 0, "S7825C25");
    test_class_info(&lv, &cd_S7825C25);
    dp->~S7825C25();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7825C25(Test_S7825C25, "S7825C25", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN8S7825C25C1Ev();
extern void _ZN8S7825C25D2Ev();
Name_Map name_map_S7825C25[] = {
  NSPAIR(_ZN8S7825C25C1Ev),
  NSPAIR(_ZN8S7825C25D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
static Base_Class bases_S7825C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7825C8_nt,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7825C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2407C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S7825C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2407C30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7825C25[];
extern void _ZN8S7825C25D1Ev();
extern void _ZN8S7825C25D0Ev();
extern void ABISELECT(_ZTv0_n24_N8S7825C25D1Ev,_ZTv0_n12_N8S7825C25D1Ev)();
extern void ABISELECT(_ZThn16_N8S7825C25D1Ev,_ZThn8_N8S7825C25D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C25D0Ev,_ZTv0_n12_N8S7825C25D0Ev)();
extern void ABISELECT(_ZThn16_N8S7825C25D0Ev,_ZThn8_N8S7825C25D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7825C25[] = {
  0,
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C25[0]),
  (VTBL_ENTRY)&_ZN8S7825C25D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C25D0Ev,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S7825C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C25D1Ev,_ZTv0_n12_N8S7825C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C25D0Ev,_ZTv0_n12_N8S7825C25D0Ev),
};
extern VTBL_ENTRY _ZTV8S7825C25[];
static  VTT_ENTRY vtt_S7825C25[] = {
  {&(_ZTV8S7825C25[4]),  4,11},
  {&(_ZTV8S7825C25[9]),  9,11},
};
extern VTBL_ENTRY _ZTI8S7825C25[];
extern  VTBL_ENTRY _ZTV8S7825C25[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C25[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C25D0Ev,_ZTv0_n12_N8S7825C25D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S7825C25D0Ev,_ZThn8_N8S7825C25D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C25D1Ev,_ZTv0_n12_N8S7825C25D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S7825C25D1Ev,_ZThn8_N8S7825C25D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7825C25 = {  "S7825C25", // class name
  bases_S7825C25, 5,
  &(vtc_S7825C25[0]), // expected_vtbl_contents
  &(vtt_S7825C25[0]), // expected_vtt_contents
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI8S7825C25),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S7825C25),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7825C25),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C24  : S7825C25 , S7825C23_nt , virtual S7825C5 {
  virtual void  v1(); // _ZN8S7825C242v1Ev
  ~S7825C24(); // tgen
  S7825C24(); // tgen
};
//SIG(-1 S7825C24) C1{ BC2{ VBC3{ vd m Fc} BC4{ BC3 BC5{ m}} VBC6{ m} vd} BC7{ vd m Fp} VBC8{ BC6 BC5 BC3 vd Fp} v1}


void  S7825C24 ::v1(){vfunc_called(this, "_ZN8S7825C242v1Ev");}
S7825C24 ::~S7825C24(){ note_dtor("S7825C24", this);} // tgen
S7825C24 ::S7825C24(){ note_ctor("S7825C24", this);} // tgen

static void Test_S7825C24()
{
  extern Class_Descriptor cd_S7825C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[10];
    init_test(&cd_S7825C24, buf);
    S7825C24 *dp, &lv = *(dp=new (buf) S7825C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,36), "sizeof(S7825C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7825C24)");
    /*is_ambiguous_... S7825C25::S7825C8_nt */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C25*), ABISELECT(32,16), "S7825C24");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C25*), 0, "S7825C24");
    check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C25*), 0, "S7825C24");
    check_base_class_offset(lv, (S7825C14*)(S7825C25*), 0, "S7825C24");
    check_base_class_offset(lv, (S2407C30*)(S7825C25*), 0, "S7825C24");
    check_base_class_offset(lv, (S7825C25*), 0, "S7825C24");
    check_base_class_offset(lv, (S7825C23_nt*), ABISELECT(16,8), "S7825C24");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*), ABISELECT(48,24), "S7825C24");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*), ABISELECT(48,24), "S7825C24");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*), ABISELECT(48,24), "S7825C24");
    check_base_class_offset(lv, (S7825C5*), ABISELECT(48,24), "S7825C24");
    test_class_info(&lv, &cd_S7825C24);
    dp->~S7825C24();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7825C24(Test_S7825C24, "S7825C24", ABISELECT(72,36));

#else // __cplusplus

extern void _ZN8S7825C24C1Ev();
extern void _ZN8S7825C24D1Ev();
Name_Map name_map_S7825C24[] = {
  NSPAIR(_ZN8S7825C24C1Ev),
  NSPAIR(_ZN8S7825C24D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S7825C25;
extern VTBL_ENTRY _ZTI8S7825C25[];
extern  VTBL_ENTRY _ZTV8S7825C25[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C25[];
extern Class_Descriptor cd_S7825C23_nt;
extern VTBL_ENTRY _ZTI11S7825C23_nt[];
extern  VTBL_ENTRY _ZTV11S7825C23_nt[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
static Base_Class bases_S7825C24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7825C8_nt,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S7825C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2407C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S7825C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S2407C30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S7825C25,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7825C23_nt,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2407C30,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7825C24[];
extern void _ZN8S7825C24D1Ev();
extern void _ZN8S7825C24D0Ev();
extern void _ZN8S7825C242v1Ev();
extern void ABISELECT(_ZThn16_N8S7825C24D1Ev,_ZThn8_N8S7825C24D1Ev)();
extern void ABISELECT(_ZThn16_N8S7825C24D0Ev,_ZThn8_N8S7825C24D0Ev)();
extern void ABISELECT(_ZTv0_n24_N8S7825C24D1Ev,_ZTv0_n12_N8S7825C24D1Ev)();
extern void ABISELECT(_ZThn32_N8S7825C24D1Ev,_ZThn16_N8S7825C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C24D0Ev,_ZTv0_n12_N8S7825C24D0Ev)();
extern void ABISELECT(_ZThn32_N8S7825C24D0Ev,_ZThn16_N8S7825C24D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C24D1Ev,_ZTv0_n12_N8S7825C24D1Ev)();
extern void ABISELECT(_ZThn48_N8S7825C24D1Ev,_ZThn24_N8S7825C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C24D0Ev,_ZTv0_n12_N8S7825C24D0Ev)();
extern void ABISELECT(_ZThn48_N8S7825C24D0Ev,_ZThn24_N8S7825C24D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7825C24[] = {
  ABISELECT(48,24),
  0,
  ABISELECT(32,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C24[0]),
  (VTBL_ENTRY)&_ZN8S7825C24D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C24D0Ev,
  (VTBL_ENTRY)&_ZN8S7825C242v1Ev,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S7825C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C24D1Ev,_ZThn8_N8S7825C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C24D0Ev,_ZThn8_N8S7825C24D0Ev),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S7825C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C24D1Ev,_ZTv0_n12_N8S7825C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C24D0Ev,_ZTv0_n12_N8S7825C24D0Ev),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S7825C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C24D1Ev,_ZTv0_n12_N8S7825C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C24D0Ev,_ZTv0_n12_N8S7825C24D0Ev),
};
extern VTBL_ENTRY _ZTV8S7825C24[];
extern void _ZN8S7825C25D1Ev();
extern void _ZN8S7825C25D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C25__8S7825C24[] = {
  0,
  ABISELECT(32,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C25[0]),
  (VTBL_ENTRY)&_ZN8S7825C25D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C25D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C25D1Ev,_ZTv0_n12_N8S7825C25D1Ev)();
extern void ABISELECT(_ZThn32_N8S7825C25D1Ev,_ZThn16_N8S7825C25D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C25D0Ev,_ZTv0_n12_N8S7825C25D0Ev)();
extern void ABISELECT(_ZThn32_N8S7825C25D0Ev,_ZThn16_N8S7825C25D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV10S7825C8_nt__8S7825C25__8S7825C24[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S7825C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C25D1Ev,_ZTv0_n12_N8S7825C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C25D0Ev,_ZTv0_n12_N8S7825C25D0Ev),
};
static  VTT_ENTRY vtt_S7825C24[] = {
  {&(_ZTV8S7825C24[5]),  5,22},
  {&(_tg__ZTV8S7825C25__8S7825C24[4]),  4,6},
  {&(_tg__ZTV10S7825C8_nt__8S7825C25__8S7825C24[3]),  3,5},
  {&(_ZTV8S7825C24[15]),  15,22},
  {&(_ZTV8S7825C24[20]),  20,22},
};
extern VTBL_ENTRY _ZTI8S7825C24[];
extern  VTBL_ENTRY _ZTV8S7825C24[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C24[];
static VTBL_ENTRY alt_thunk_names10[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C25D0Ev,_ZTv0_n12_N8S7825C25D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C25D0Ev,_ZThn16_N8S7825C25D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C25D1Ev,_ZTv0_n12_N8S7825C25D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C25D1Ev,_ZThn16_N8S7825C25D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C24D0Ev,_ZTv0_n12_N8S7825C24D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S7825C24D0Ev,_ZThn24_N8S7825C24D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C24D0Ev,_ZThn16_N8S7825C24D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C24D1Ev,_ZTv0_n12_N8S7825C24D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S7825C24D1Ev,_ZThn24_N8S7825C24D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C24D1Ev,_ZThn16_N8S7825C24D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7825C24 = {  "S7825C24", // class name
  bases_S7825C24, 11,
  &(vtc_S7825C24[0]), // expected_vtbl_contents
  &(vtt_S7825C24[0]), // expected_vtt_contents
  ABISELECT(72,36), // object size
  NSPAIRA(_ZTI8S7825C24),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S7825C24),22, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7825C24),5, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names10,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C26  : S7825C23_nt {
  char s7825c26f0:7;
  void *s7825c26f1;
  ~S7825C26(); // tgen
  S7825C26(); // tgen
};
//SIG(-1 S7825C26) C1{ BC2{ vd m Fp} Fc:7 Fp}


S7825C26 ::~S7825C26(){ note_dtor("S7825C26", this);} // tgen
S7825C26 ::S7825C26(){ note_ctor("S7825C26", this);} // tgen

static void Test_S7825C26()
{
  extern Class_Descriptor cd_S7825C26;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S7825C26, buf);
    S7825C26 *dp, &lv = *(dp=new (buf) S7825C26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S7825C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7825C26)");
    check_base_class_offset(lv, (S7825C23_nt*), 0, "S7825C26");
    set_bf_and_test(lv, s7825c26f0, ABISELECT(16,8), 0, 7, 1, "S7825C26");
    set_bf_and_test(lv, s7825c26f0, ABISELECT(16,8), 0, 7, hide_sll(1LL<<6), "S7825C26");
    check_field_offset(lv, s7825c26f1, ABISELECT(24,12), "S7825C26.s7825c26f1");
    test_class_info(&lv, &cd_S7825C26);
    dp->~S7825C26();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7825C26(Test_S7825C26, "S7825C26", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN8S7825C26C1Ev();
extern void _ZN8S7825C26D1Ev();
Name_Map name_map_S7825C26[] = {
  NSPAIR(_ZN8S7825C26C1Ev),
  NSPAIR(_ZN8S7825C26D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7825C23_nt;
extern VTBL_ENTRY _ZTI11S7825C23_nt[];
extern  VTBL_ENTRY _ZTV11S7825C23_nt[];
static Base_Class bases_S7825C26[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7825C23_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7825C26[];
extern void _ZN8S7825C26D1Ev();
extern void _ZN8S7825C26D0Ev();
static  VTBL_ENTRY vtc_S7825C26[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C26[0]),
  (VTBL_ENTRY)&_ZN8S7825C26D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C26D0Ev,
};
extern VTBL_ENTRY _ZTI8S7825C26[];
extern  VTBL_ENTRY _ZTV8S7825C26[];
Class_Descriptor cd_S7825C26 = {  "S7825C26", // class name
  bases_S7825C26, 1,
  &(vtc_S7825C26[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI8S7825C26),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S7825C26),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C3  : virtual S7825C4 , virtual S7825C24 , virtual S7825C26 , virtual S7825C12 , S2407C30 {
  void *s7825c3f0;
  virtual  ~S7825C3(); // _ZN7S7825C3D2Ev
  S7825C3(); // tgen
};
//SIG(-1 S7825C3) C1{ VBC2{ VBC3{ BC4{ m} BC5{ m} BC6{ vd m Fc} vd Fp} BC7{ m} vd FC8{ VBC9{ BC10{ VBC5 BC11{ BC4 BC3 vd Fi} VBC3 VBC12{ BC6 BC5} vd} BC11 VBC4 BC13{ BC5 BC12 BC6 BC3 VBC4 vd v2} vd} VBC14{ BC3 vd} VBC15{ BC6 VBC16{ vd m FC17{ VBC18{ VBC4 VBC13 VBC5 BC12 VBC11 vd} FL}} BC19{ m} vd FL} VBC20{ VBC3 VBC10 BC21{ vd m Fp} BC13 BC12 vd} BC4 FL:64} Fi[7]} VBC22{ BC23{ VBC6 BC12 VBC4 vd} BC21 VBC3 v1} VBC24{ BC21 Fc:7 Fp} VBC10 BC4 vd Fp}


 S7825C3 ::~S7825C3(){ note_dtor("S7825C3", this);}
S7825C3 ::S7825C3(){ note_ctor("S7825C3", this);} // tgen

static void Test_S7825C3()
{
  extern Class_Descriptor cd_S7825C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(86,92)];
    init_test(&cd_S7825C3, buf);
    S7825C3 *dp, &lv = *(dp=new (buf) S7825C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(680,364), "sizeof(S7825C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7825C3)");
    /*is_ambiguous_... S7825C3::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*), ABISELECT(528,288), "S7825C3");
    /*is_ambiguous_... S7825C3::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*), ABISELECT(528,288), "S7825C3");
    /*is_ambiguous_... S7825C3::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*), ABISELECT(528,288), "S7825C3");
    check_base_class_offset(lv, (S7825C5*)(S7825C4*), ABISELECT(528,288), "S7825C3");
    check_base_class_offset(lv, (S7825C5*)(S7825C24*), ABISELECT(528,288), "S7825C3");
    /*is_ambiguous_... S7825C12::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C12*), ABISELECT(528,288), "S7825C3");
    check_base_class_offset(lv, (S2407C23*)(S7825C4*), ABISELECT(16,8), "S7825C3");
    check_base_class_offset(lv, (S7825C4*), ABISELECT(16,8), "S7825C3");
    /*is_ambiguous_... S7825C25::S7825C8_nt */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C25*)(S7825C24*), ABISELECT(584,316), "S7825C3");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C25*)(S7825C24*), ABISELECT(552,300), "S7825C3");
    check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C25*)(S7825C24*), ABISELECT(552,300), "S7825C3");
    check_base_class_offset(lv, (S7825C14*)(S7825C25*)(S7825C24*), ABISELECT(552,300), "S7825C3");
    check_base_class_offset(lv, (S2407C30*)(S7825C25*)(S7825C24*), ABISELECT(593,321), "S7825C3");
    check_base_class_offset(lv, (S7825C25*)(S7825C24*), ABISELECT(552,300), "S7825C3");
    check_base_class_offset(lv, (S7825C23_nt*)(S7825C24*), ABISELECT(568,308), "S7825C3");
    check_base_class_offset(lv, (S7825C24*), ABISELECT(552,300), "S7825C3");
    check_base_class_offset(lv, (S7825C23_nt*)(S7825C26*), ABISELECT(600,324), "S7825C3");
    check_base_class_offset(lv, (S7825C26*), ABISELECT(600,324), "S7825C3");
    /*is_ambiguous_... S7825C12::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C12*), 0, "S7825C3");
    /*is_ambiguous_... S7825C13::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C13*)(S7825C12*), ABISELECT(656,352), "S7825C3");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(632,340), "S7825C3");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(632,340), "S7825C3");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(632,340), "S7825C3");
    check_base_class_offset(lv, (S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(632,340), "S7825C3");
    check_base_class_offset(lv, (S7825C13*)(S7825C12*), ABISELECT(632,340), "S7825C3");
    /*is_ambiguous_... S7825C3::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*), ABISELECT(664,356), "S7825C3");
    /*is_ambiguous_... S7825C3::S7825C14 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C14*), ABISELECT(664,356), "S7825C3");
    check_base_class_offset(lv, (S7825C14*)(S7825C12*), ABISELECT(664,356), "S7825C3");
    check_base_class_offset(lv, (S7825C12*), ABISELECT(632,340), "S7825C3");
    /*is_ambiguous_... S7825C3::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*), 0, "S7825C3");
    check_field_offset(lv, s7825c3f0, ABISELECT(8,4), "S7825C3.s7825c3f0");
    test_class_info(&lv, &cd_S7825C3);
    dp->~S7825C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7825C3(Test_S7825C3, "S7825C3", ABISELECT(680,364));

#else // __cplusplus

extern void _ZN7S7825C3C1Ev();
extern void _ZN7S7825C3D2Ev();
Name_Map name_map_S7825C3[] = {
  NSPAIR(_ZN7S7825C3C1Ev),
  NSPAIR(_ZN7S7825C3D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S2407C23;
extern VTBL_ENTRY _ZTI8S2407C23[];
extern Class_Descriptor cd_S7825C4;
extern VTBL_ENTRY _ZTI7S7825C4[];
extern  VTBL_ENTRY _ZTV7S7825C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7825C4[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S7825C25;
extern VTBL_ENTRY _ZTI8S7825C25[];
extern  VTBL_ENTRY _ZTV8S7825C25[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C25[];
extern Class_Descriptor cd_S7825C23_nt;
extern VTBL_ENTRY _ZTI11S7825C23_nt[];
extern  VTBL_ENTRY _ZTV11S7825C23_nt[];
extern Class_Descriptor cd_S7825C24;
extern VTBL_ENTRY _ZTI8S7825C24[];
extern  VTBL_ENTRY _ZTV8S7825C24[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C24[];
extern Class_Descriptor cd_S7825C23_nt;
extern VTBL_ENTRY _ZTI11S7825C23_nt[];
extern  VTBL_ENTRY _ZTV11S7825C23_nt[];
extern Class_Descriptor cd_S7825C26;
extern VTBL_ENTRY _ZTI8S7825C26[];
extern  VTBL_ENTRY _ZTV8S7825C26[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C13;
extern VTBL_ENTRY _ZTI8S7825C13[];
extern  VTBL_ENTRY _ZTV8S7825C13[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C12;
extern VTBL_ENTRY _ZTI8S7825C12[];
extern  VTBL_ENTRY _ZTV8S7825C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C12[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
static Base_Class bases_S7825C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2407C30,    ABISELECT(528,288), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(528,288), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(528,288), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(528,288), //bcp->offset
    19, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S2407C23,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7825C4,    ABISELECT(16,8), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7825C8_nt,    ABISELECT(584,316), //bcp->offset
    38, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S7825C8_nt,    ABISELECT(552,300), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(552,300), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(552,300), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(593,321), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S7825C25,    ABISELECT(552,300), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S7825C23_nt,    ABISELECT(568,308), //bcp->offset
    34, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S7825C24,    ABISELECT(552,300), //bcp->offset
    24, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7825C23_nt,    ABISELECT(600,324), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S7825C26,    ABISELECT(600,324), //bcp->offset
    43, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2407C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    26, //immediately_derived
  0, 1},
  {&cd_S2407C30,    ABISELECT(656,352), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(632,340), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(632,340), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(632,340), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(632,340), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S7825C13,    ABISELECT(632,340), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(664,356), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(664,356), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(664,356), //bcp->offset
    56, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    26, //immediately_derived
  0, 1},
  {&cd_S7825C12,    ABISELECT(632,340), //bcp->offset
    48, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2407C30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S7825C3[];
extern void _ZN7S7825C3D1Ev();
extern void _ZN7S7825C3D0Ev();
extern void ABISELECT(_ZTv0_n32_N7S7825C3D1Ev,_ZTv0_n16_N7S7825C3D1Ev)();
extern void ABISELECT(_ZThn16_N7S7825C3D1Ev,_ZThn8_N7S7825C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S7825C3D0Ev,_ZTv0_n16_N7S7825C3D0Ev)();
extern void ABISELECT(_ZThn16_N7S7825C3D0Ev,_ZThn8_N7S7825C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7825C3D1Ev,_ZTv0_n12_N7S7825C3D1Ev)();
extern void ABISELECT(_ZThn528_N7S7825C3D1Ev,_ZThn288_N7S7825C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7825C3D0Ev,_ZTv0_n12_N7S7825C3D0Ev)();
extern void ABISELECT(_ZThn528_N7S7825C3D0Ev,_ZThn288_N7S7825C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7S7825C3D1Ev,_ZTv0_n24_N7S7825C3D1Ev)();
extern void ABISELECT(_ZThn552_N7S7825C3D1Ev,_ZThn300_N7S7825C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7S7825C3D0Ev,_ZTv0_n24_N7S7825C3D0Ev)();
extern void ABISELECT(_ZThn552_N7S7825C3D0Ev,_ZThn300_N7S7825C3D0Ev)() __attribute__((weak));
extern void _ZN8S7825C242v1Ev();
extern void ABISELECT(_ZTvn16_n48_N7S7825C3D1Ev,_ZTvn8_n24_N7S7825C3D1Ev)();
extern void ABISELECT(_ZTvn16_n48_N7S7825C3D0Ev,_ZTvn8_n24_N7S7825C3D0Ev)();
extern void ABISELECT(_ZTv0_n24_N7S7825C3D1Ev,_ZTv0_n12_N7S7825C3D1Ev)();
extern void ABISELECT(_ZThn584_N7S7825C3D1Ev,_ZThn316_N7S7825C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7825C3D0Ev,_ZTv0_n12_N7S7825C3D0Ev)();
extern void ABISELECT(_ZThn584_N7S7825C3D0Ev,_ZThn316_N7S7825C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7825C3D1Ev,_ZTv0_n12_N7S7825C3D1Ev)();
extern void ABISELECT(_ZThn600_N7S7825C3D1Ev,_ZThn324_N7S7825C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7825C3D0Ev,_ZTv0_n12_N7S7825C3D0Ev)();
extern void ABISELECT(_ZThn600_N7S7825C3D0Ev,_ZThn324_N7S7825C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7S7825C3D1Ev,_ZTv0_n24_N7S7825C3D1Ev)();
extern void ABISELECT(_ZThn632_N7S7825C3D1Ev,_ZThn340_N7S7825C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7S7825C3D0Ev,_ZTv0_n24_N7S7825C3D0Ev)();
extern void ABISELECT(_ZThn632_N7S7825C3D0Ev,_ZThn340_N7S7825C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7825C3D1Ev,_ZTv0_n12_N7S7825C3D1Ev)();
extern void ABISELECT(_ZThn664_N7S7825C3D1Ev,_ZThn356_N7S7825C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7825C3D0Ev,_ZTv0_n12_N7S7825C3D0Ev)();
extern void ABISELECT(_ZThn664_N7S7825C3D0Ev,_ZThn356_N7S7825C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7825C3[] = {
  ABISELECT(664,356),
  0,
  ABISELECT(632,340),
  ABISELECT(600,324),
  ABISELECT(593,321),
  ABISELECT(584,316),
  ABISELECT(552,300),
  ABISELECT(528,288),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7S7825C3[0]),
  (VTBL_ENTRY)&_ZN7S7825C3D1Ev,
  (VTBL_ENTRY)&_ZN7S7825C3D0Ev,
  ABISELECT(-16,-8),
  ABISELECT(512,280),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S7825C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S7825C3D1Ev,_ZTv0_n16_N7S7825C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S7825C3D0Ev,_ZTv0_n16_N7S7825C3D0Ev),
  ABISELECT(-528,-288),
  ABISELECT(-528,-288),
  (VTBL_ENTRY)&(_ZTI7S7825C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7825C3D1Ev,_ZTv0_n12_N7S7825C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7825C3D0Ev,_ZTv0_n12_N7S7825C3D0Ev),
  0,
  ABISELECT(-552,-300),
  ABISELECT(-24,-12),
  ABISELECT(41,21),
  ABISELECT(32,16),
  ABISELECT(-552,-300),
  (VTBL_ENTRY)&(_ZTI7S7825C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S7825C3D1Ev,_ZTv0_n24_N7S7825C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S7825C3D0Ev,_ZTv0_n24_N7S7825C3D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C242v1Ev,
  ABISELECT(-568,-308),
  (VTBL_ENTRY)&(_ZTI7S7825C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n48_N7S7825C3D1Ev,_ZTvn8_n24_N7S7825C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n48_N7S7825C3D0Ev,_ZTvn8_n24_N7S7825C3D0Ev),
  ABISELECT(-584,-316),
  ABISELECT(-584,-316),
  (VTBL_ENTRY)&(_ZTI7S7825C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7825C3D1Ev,_ZTv0_n12_N7S7825C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7825C3D0Ev,_ZTv0_n12_N7S7825C3D0Ev),
  ABISELECT(-600,-324),
  ABISELECT(-600,-324),
  (VTBL_ENTRY)&(_ZTI7S7825C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7825C3D1Ev,_ZTv0_n12_N7S7825C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7825C3D0Ev,_ZTv0_n12_N7S7825C3D0Ev),
  ABISELECT(-632,-340),
  ABISELECT(32,16),
  ABISELECT(-104,-52),
  ABISELECT(-632,-340),
  ABISELECT(-632,-340),
  (VTBL_ENTRY)&(_ZTI7S7825C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S7825C3D1Ev,_ZTv0_n24_N7S7825C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S7825C3D0Ev,_ZTv0_n24_N7S7825C3D0Ev),
  ABISELECT(-664,-356),
  ABISELECT(-664,-356),
  (VTBL_ENTRY)&(_ZTI7S7825C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7825C3D1Ev,_ZTv0_n12_N7S7825C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7825C3D0Ev,_ZTv0_n12_N7S7825C3D0Ev),
};
extern VTBL_ENTRY _ZTV7S7825C3[];
extern void _ZN7S7825C4D1Ev();
extern void _ZN7S7825C4D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7825C4__7S7825C3[] = {
  ABISELECT(512,280),
  0,
  (VTBL_ENTRY)&(_ZTI7S7825C4[0]),
  (VTBL_ENTRY)&_ZN7S7825C4D1Ev,
  (VTBL_ENTRY)&_ZN7S7825C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S7825C4D1Ev,_ZTv0_n12_N7S7825C4D1Ev)();
extern void ABISELECT(_ZThn512_N7S7825C4D1Ev,_ZThn280_N7S7825C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7825C4D0Ev,_ZTv0_n12_N7S7825C4D0Ev)();
extern void ABISELECT(_ZThn512_N7S7825C4D0Ev,_ZThn280_N7S7825C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7825C5__7S7825C4__7S7825C3[] = {
  ABISELECT(-512,-280),
  ABISELECT(-512,-280),
  (VTBL_ENTRY)&(_ZTI7S7825C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7825C4D1Ev,_ZTv0_n12_N7S7825C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7825C4D0Ev,_ZTv0_n12_N7S7825C4D0Ev),
};
extern void _ZN8S7825C24D1Ev();
extern void _ZN8S7825C24D0Ev();
extern void _ZN8S7825C242v1Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C24__7S7825C3[] = {
  ABISELECT(-24,-12),
  ABISELECT(41,21),
  ABISELECT(32,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C24[0]),
  (VTBL_ENTRY)&_ZN8S7825C24D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C24D0Ev,
  (VTBL_ENTRY)&_ZN8S7825C242v1Ev,
};
extern void _ZN8S7825C25D1Ev();
extern void _ZN8S7825C25D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C258S7825C24__7S7825C3[] = {
  ABISELECT(41,21),
  ABISELECT(32,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C25[0]),
  (VTBL_ENTRY)&_ZN8S7825C25D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C25D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C25D1Ev,_ZTv0_n12_N8S7825C25D1Ev)();
extern void ABISELECT(_ZThn32_N8S7825C25D1Ev,_ZThn16_N8S7825C25D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C25D0Ev,_ZTv0_n12_N8S7825C25D0Ev)();
extern void ABISELECT(_ZThn32_N8S7825C25D0Ev,_ZThn16_N8S7825C25D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV10S7825C8_nt__8S7825C258S7825C24__7S7825C3[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S7825C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C25D1Ev,_ZTv0_n12_N8S7825C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C25D0Ev,_ZTv0_n12_N8S7825C25D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C24D1Ev,_ZTv0_n12_N8S7825C24D1Ev)();
extern void ABISELECT(_ZThn32_N8S7825C24D1Ev,_ZThn16_N8S7825C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C24D0Ev,_ZTv0_n12_N8S7825C24D0Ev)();
extern void ABISELECT(_ZThn32_N8S7825C24D0Ev,_ZThn16_N8S7825C24D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV10S7825C8_nt__8S7825C24__7S7825C3[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S7825C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C24D1Ev,_ZTv0_n12_N8S7825C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C24D0Ev,_ZTv0_n12_N8S7825C24D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C24D1Ev,_ZTv0_n12_N8S7825C24D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S7825C24D0Ev,_ZTv0_n12_N8S7825C24D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S7825C5__8S7825C24__7S7825C3[] = {
  ABISELECT(24,12),
  ABISELECT(24,12),
  (VTBL_ENTRY)&(_ZTI8S7825C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C24D1Ev,_ZTv0_n12_N8S7825C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C24D0Ev,_ZTv0_n12_N8S7825C24D0Ev),
};
extern void _ZN8S7825C12D1Ev();
extern void _ZN8S7825C12D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C12__7S7825C3[] = {
  ABISELECT(32,16),
  ABISELECT(-104,-52),
  ABISELECT(-632,-340),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&_ZN8S7825C12D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C12D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S7825C5__A1__8S7825C12__7S7825C3[] = {
  ABISELECT(104,52),
  ABISELECT(104,52),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZThn32_N8S7825C12D1Ev,_ZThn16_N8S7825C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
extern void ABISELECT(_ZThn32_N8S7825C12D0Ev,_ZThn16_N8S7825C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C14__8S7825C12__7S7825C3[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
};
static  VTT_ENTRY vtt_S7825C3[] = {
  {&(_ZTV7S7825C3[11]),  11,61},
  {&(_ZTV7S7825C3[17]),  17,61},
  {&(_ZTV7S7825C3[22]),  22,61},
  {&(_ZTV7S7825C3[31]),  31,61},
  {&(_ZTV7S7825C3[41]),  41,61},
  {&(_ZTV7S7825C3[36]),  36,61},
  {&(_ZTV7S7825C3[46]),  46,61},
  {&(_ZTV7S7825C3[54]),  54,61},
  {&(_ZTV7S7825C3[59]),  59,61},
  {&(_tg__ZTV7S7825C4__7S7825C3[3]),  3,5},
  {&(_tg__ZTV7S7825C5__7S7825C4__7S7825C3[3]),  3,5},
  {&(_tg__ZTV8S7825C24__7S7825C3[5]),  5,8},
  {&(_tg__ZTV8S7825C258S7825C24__7S7825C3[4]),  4,6},
  {&(_tg__ZTV10S7825C8_nt__8S7825C258S7825C24__7S7825C3[3]),  3,5},
  {&(_tg__ZTV10S7825C8_nt__8S7825C24__7S7825C3[3]),  3,5},
  {&(_tg__ZTV7S7825C5__8S7825C24__7S7825C3[3]),  3,5},
  {&(_tg__ZTV8S7825C12__7S7825C3[5]),  5,7},
  {&(_tg__ZTV7S7825C5__A1__8S7825C12__7S7825C3[3]),  3,5},
  {&(_tg__ZTV8S7825C14__8S7825C12__7S7825C3[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7S7825C3[];
extern  VTBL_ENTRY _ZTV7S7825C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7825C3[];
static VTBL_ENTRY alt_thunk_names11[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C12D0Ev,_ZThn16_N8S7825C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C12D1Ev,_ZThn16_N8S7825C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C24D0Ev,_ZTv0_n12_N8S7825C24D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C24D0Ev,_ZThn16_N8S7825C24D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C24D1Ev,_ZTv0_n12_N8S7825C24D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C24D1Ev,_ZThn16_N8S7825C24D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C25D0Ev,_ZTv0_n12_N8S7825C25D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C25D0Ev,_ZThn16_N8S7825C25D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C25D1Ev,_ZTv0_n12_N8S7825C25D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C25D1Ev,_ZThn16_N8S7825C25D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7825C4D0Ev,_ZTv0_n12_N7S7825C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn512_N7S7825C4D0Ev,_ZThn280_N7S7825C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7825C4D1Ev,_ZTv0_n12_N7S7825C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn512_N7S7825C4D1Ev,_ZThn280_N7S7825C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7S7825C3D0Ev,_ZTv0_n24_N7S7825C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn632_N7S7825C3D0Ev,_ZThn340_N7S7825C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn552_N7S7825C3D0Ev,_ZThn300_N7S7825C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7S7825C3D1Ev,_ZTv0_n24_N7S7825C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn632_N7S7825C3D1Ev,_ZThn340_N7S7825C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn552_N7S7825C3D1Ev,_ZThn300_N7S7825C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7825C3D0Ev,_ZTv0_n12_N7S7825C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn664_N7S7825C3D0Ev,_ZThn356_N7S7825C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn600_N7S7825C3D0Ev,_ZThn324_N7S7825C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn584_N7S7825C3D0Ev,_ZThn316_N7S7825C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn528_N7S7825C3D0Ev,_ZThn288_N7S7825C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7825C3D1Ev,_ZTv0_n12_N7S7825C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn664_N7S7825C3D1Ev,_ZThn356_N7S7825C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn600_N7S7825C3D1Ev,_ZThn324_N7S7825C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn584_N7S7825C3D1Ev,_ZThn316_N7S7825C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn528_N7S7825C3D1Ev,_ZThn288_N7S7825C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S7825C3D0Ev,_ZTv0_n16_N7S7825C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7S7825C3D0Ev,_ZThn8_N7S7825C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S7825C3D1Ev,_ZTv0_n16_N7S7825C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7S7825C3D1Ev,_ZThn8_N7S7825C3D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7825C3 = {  "S7825C3", // class name
  bases_S7825C3, 28,
  &(vtc_S7825C3[0]), // expected_vtbl_contents
  &(vtt_S7825C3[0]), // expected_vtt_contents
  ABISELECT(680,364), // object size
  NSPAIRA(_ZTI7S7825C3),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV7S7825C3),61, //virtual function table var
  11, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7825C3),19, //virtual table table var
  17, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names11,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C29  : virtual S2407C27 , virtual S7825C12 , S7825C22 , S7825C5 {
  ~S7825C29(); // tgen
  S7825C29(); // tgen
};
//SIG(-1 S7825C29) C1{ VBC2{ m} VBC3{ VBC2 BC4{ BC5{ m} BC6{ BC5 BC2 BC7{ vd m Fc} vd Fp} vd Fi} VBC6 VBC8{ BC7 BC2} vd} BC9{ VBC6 VBC3 BC10{ vd m Fp} BC11{ BC2 BC8 BC7 BC6 VBC5 vd v1} BC8 vd} BC6}


S7825C29 ::~S7825C29(){ note_dtor("S7825C29", this);} // tgen
S7825C29 ::S7825C29(){ note_ctor("S7825C29", this);} // tgen

static void Test_S7825C29()
{
  extern Class_Descriptor cd_S7825C29;
  void *lvp;
  {
    ABISELECT(double,int) buf[24];
    init_test(&cd_S7825C29, buf);
    S7825C29 *dp, &lv = *(dp=new (buf) S7825C29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(184,92), "sizeof(S7825C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7825C29)");
    /*is_ambiguous_... S7825C29::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*), 0, "S7825C29");
    /*is_ambiguous_... S7825C12::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C12*), 0, "S7825C29");
    /*is_ambiguous_... S7825C13::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C13*)(S7825C12*), ABISELECT(136,68), "S7825C29");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(112,56), "S7825C29");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(112,56), "S7825C29");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(112,56), "S7825C29");
    check_base_class_offset(lv, (S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(112,56), "S7825C29");
    check_base_class_offset(lv, (S7825C13*)(S7825C12*), ABISELECT(112,56), "S7825C29");
    /*is_ambiguous_... S7825C29::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*), ABISELECT(144,72), "S7825C29");
    /*is_ambiguous_... S7825C29::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*), ABISELECT(144,72), "S7825C29");
    /*is_ambiguous_... S7825C29::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*), ABISELECT(144,72), "S7825C29");
    /*is_ambiguous_... S7825C12::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C12*), ABISELECT(144,72), "S7825C29");
    /*is_ambiguous_... S7825C22::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C22*), ABISELECT(144,72), "S7825C29");
    /*is_ambiguous_... S7825C29::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*), ABISELECT(168,84), "S7825C29");
    /*is_ambiguous_... S7825C29::S7825C14 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C14*), ABISELECT(168,84), "S7825C29");
    check_base_class_offset(lv, (S7825C14*)(S7825C12*), ABISELECT(168,84), "S7825C29");
    check_base_class_offset(lv, (S7825C12*), ABISELECT(112,56), "S7825C29");
    check_base_class_offset(lv, (S7825C12*)(S7825C22*), ABISELECT(112,56), "S7825C29");
    check_base_class_offset(lv, (S7825C23_nt*)(S7825C22*), 0, "S7825C29");
    /*is_ambiguous_... S7825C15::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C15*)(S7825C22*), ABISELECT(25,13), "S7825C29");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C15*)(S7825C22*), ABISELECT(16,8), "S7825C29");
    check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C15*)(S7825C22*), ABISELECT(16,8), "S7825C29");
    check_base_class_offset(lv, (S7825C14*)(S7825C15*)(S7825C22*), ABISELECT(16,8), "S7825C29");
    /*is_ambiguous_... S7825C15::S7825C8_nt */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C15*)(S7825C22*), ABISELECT(32,16), "S7825C29");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C15*)(S7825C22*), ABISELECT(48,24), "S7825C29");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C15*)(S7825C22*), ABISELECT(48,24), "S7825C29");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C15*)(S7825C22*), ABISELECT(48,24), "S7825C29");
    check_base_class_offset(lv, (S7825C5*)(S7825C15*)(S7825C22*), ABISELECT(48,24), "S7825C29");
    /*is_ambiguous_... S7825C15::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C15*)(S7825C22*), 0, "S7825C29");
    check_base_class_offset(lv, (S7825C15*)(S7825C22*), ABISELECT(16,8), "S7825C29");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C22*), ABISELECT(72,36), "S7825C29");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C22*), ABISELECT(72,36), "S7825C29");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C14*)(S7825C22*), ABISELECT(72,36), "S7825C29");
    check_base_class_offset(lv, (S7825C22*), 0, "S7825C29");
    /*is_ambiguous_... S7825C29::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*), ABISELECT(88,44), "S7825C29");
    /*is_ambiguous_... S7825C29::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*), ABISELECT(88,44), "S7825C29");
    /*is_ambiguous_... S7825C29::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*), ABISELECT(88,44), "S7825C29");
    /*is_ambiguous_... S7825C29::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C5*), ABISELECT(88,44), "S7825C29");
    test_class_info(&lv, &cd_S7825C29);
    dp->~S7825C29();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7825C29(Test_S7825C29, "S7825C29", ABISELECT(184,92));

#else // __cplusplus

extern void _ZN8S7825C29C1Ev();
extern void _ZN8S7825C29D1Ev();
Name_Map name_map_S7825C29[] = {
  NSPAIR(_ZN8S7825C29C1Ev),
  NSPAIR(_ZN8S7825C29D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C13;
extern VTBL_ENTRY _ZTI8S7825C13[];
extern  VTBL_ENTRY _ZTV8S7825C13[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C12;
extern VTBL_ENTRY _ZTI8S7825C12[];
extern  VTBL_ENTRY _ZTV8S7825C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C12[];
extern Class_Descriptor cd_S7825C23_nt;
extern VTBL_ENTRY _ZTI11S7825C23_nt[];
extern  VTBL_ENTRY _ZTV11S7825C23_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S7825C15;
extern VTBL_ENTRY _ZTI8S7825C15[];
extern  VTBL_ENTRY _ZTV8S7825C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C15[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C22;
extern VTBL_ENTRY _ZTI8S7825C22[];
extern  VTBL_ENTRY _ZTV8S7825C22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C22[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
static Base_Class bases_S7825C29[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2407C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2407C30,    ABISELECT(136,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(112,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(112,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(112,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(112,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S7825C13,    ABISELECT(112,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(144,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(144,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(144,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(144,72), //bcp->offset
    39, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S7825C8_nt,    ABISELECT(168,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(168,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(168,84), //bcp->offset
    44, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S7825C12,    ABISELECT(112,56), //bcp->offset
    31, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7825C23_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(25,13), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(48,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S2407C30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    26, //immediately_derived
  0, 1},
  {&cd_S7825C15,    ABISELECT(16,8), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(72,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(72,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(72,36), //bcp->offset
    23, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S7825C22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2407C30,    ABISELECT(88,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(88,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(88,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(88,44), //bcp->offset
    27, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7825C29[];
extern void _ZN8S7825C29D1Ev();
extern void _ZN8S7825C29D0Ev();
extern void ABISELECT(_ZThn16_N8S7825C29D1Ev,_ZThn8_N8S7825C29D1Ev)();
extern void ABISELECT(_ZThn16_N8S7825C29D0Ev,_ZThn8_N8S7825C29D0Ev)();
extern void _ZN8S7825C152v2Ev();
extern void ABISELECT(_ZThn32_N8S7825C29D1Ev,_ZThn16_N8S7825C29D1Ev)();
extern void ABISELECT(_ZThn32_N8S7825C29D0Ev,_ZThn16_N8S7825C29D0Ev)();
extern void ABISELECT(_ZThn48_N8S7825C29D1Ev,_ZThn24_N8S7825C29D1Ev)();
extern void ABISELECT(_ZThn48_N8S7825C29D0Ev,_ZThn24_N8S7825C29D0Ev)();
extern void ABISELECT(_ZThn72_N8S7825C29D1Ev,_ZThn36_N8S7825C29D1Ev)();
extern void ABISELECT(_ZThn72_N8S7825C29D0Ev,_ZThn36_N8S7825C29D0Ev)();
extern void ABISELECT(_ZThn88_N8S7825C29D1Ev,_ZThn44_N8S7825C29D1Ev)();
extern void ABISELECT(_ZThn88_N8S7825C29D0Ev,_ZThn44_N8S7825C29D0Ev)();
extern void ABISELECT(_ZTv0_n48_N8S7825C29D1Ev,_ZTv0_n24_N8S7825C29D1Ev)();
extern void ABISELECT(_ZThn112_N8S7825C29D1Ev,_ZThn56_N8S7825C29D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7825C29D0Ev,_ZTv0_n24_N8S7825C29D0Ev)();
extern void ABISELECT(_ZThn112_N8S7825C29D0Ev,_ZThn56_N8S7825C29D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C29D1Ev,_ZTv0_n12_N8S7825C29D1Ev)();
extern void ABISELECT(_ZThn144_N8S7825C29D1Ev,_ZThn72_N8S7825C29D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C29D0Ev,_ZTv0_n12_N8S7825C29D0Ev)();
extern void ABISELECT(_ZThn144_N8S7825C29D0Ev,_ZThn72_N8S7825C29D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C29D1Ev,_ZTv0_n12_N8S7825C29D1Ev)();
extern void ABISELECT(_ZThn168_N8S7825C29D1Ev,_ZThn84_N8S7825C29D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C29D0Ev,_ZTv0_n12_N8S7825C29D0Ev)();
extern void ABISELECT(_ZThn168_N8S7825C29D0Ev,_ZThn84_N8S7825C29D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7825C29[] = {
  0,
  ABISELECT(168,84),
  0,
  ABISELECT(112,56),
  ABISELECT(144,72),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C29[0]),
  (VTBL_ENTRY)&_ZN8S7825C29D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C29D0Ev,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S7825C29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C29D1Ev,_ZThn8_N8S7825C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C29D0Ev,_ZThn8_N8S7825C29D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S7825C29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S7825C29D1Ev,_ZThn16_N8S7825C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S7825C29D0Ev,_ZThn16_N8S7825C29D0Ev),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S7825C29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N8S7825C29D1Ev,_ZThn24_N8S7825C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N8S7825C29D0Ev,_ZThn24_N8S7825C29D0Ev),
  ABISELECT(-72,-36),
  (VTBL_ENTRY)&(_ZTI8S7825C29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N8S7825C29D1Ev,_ZThn36_N8S7825C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N8S7825C29D0Ev,_ZThn36_N8S7825C29D0Ev),
  ABISELECT(-88,-44),
  (VTBL_ENTRY)&(_ZTI8S7825C29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn88_N8S7825C29D1Ev,_ZThn44_N8S7825C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn88_N8S7825C29D0Ev,_ZThn44_N8S7825C29D0Ev),
  ABISELECT(-112,-56),
  ABISELECT(56,28),
  ABISELECT(32,16),
  ABISELECT(-112,-56),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI8S7825C29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C29D1Ev,_ZTv0_n24_N8S7825C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C29D0Ev,_ZTv0_n24_N8S7825C29D0Ev),
  ABISELECT(-144,-72),
  ABISELECT(-144,-72),
  (VTBL_ENTRY)&(_ZTI8S7825C29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C29D1Ev,_ZTv0_n12_N8S7825C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C29D0Ev,_ZTv0_n12_N8S7825C29D0Ev),
  ABISELECT(-168,-84),
  ABISELECT(-168,-84),
  (VTBL_ENTRY)&(_ZTI8S7825C29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C29D1Ev,_ZTv0_n12_N8S7825C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C29D0Ev,_ZTv0_n12_N8S7825C29D0Ev),
};
extern VTBL_ENTRY _ZTV8S7825C29[];
extern void _ZN8S7825C22D1Ev();
extern void _ZN8S7825C22D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C22__8S7825C29[] = {
  0,
  ABISELECT(168,84),
  0,
  ABISELECT(112,56),
  ABISELECT(144,72),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&_ZN8S7825C22D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C22D0Ev,
};
extern void _ZN8S7825C15D1Ev();
extern void _ZN8S7825C15D0Ev();
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C158S7825C22__8S7825C29[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C15[0]),
  (VTBL_ENTRY)&_ZN8S7825C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C15D0Ev,
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev)();
extern void ABISELECT(_ZThn144_N8S7825C22D1Ev,_ZThn72_N8S7825C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev)();
extern void ABISELECT(_ZThn144_N8S7825C22D0Ev,_ZThn72_N8S7825C22D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7825C5__8S7825C22__8S7825C29[] = {
  ABISELECT(-144,-72),
  ABISELECT(-144,-72),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev),
};
extern void ABISELECT(_ZTv0_n48_N8S7825C22D1Ev,_ZTv0_n24_N8S7825C22D1Ev)();
extern void ABISELECT(_ZThn112_N8S7825C22D1Ev,_ZThn56_N8S7825C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7825C22D0Ev,_ZTv0_n24_N8S7825C22D0Ev)();
extern void ABISELECT(_ZThn112_N8S7825C22D0Ev,_ZThn56_N8S7825C22D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C12__8S7825C22__8S7825C29[] = {
  ABISELECT(-112,-56),
  ABISELECT(56,28),
  ABISELECT(32,16),
  ABISELECT(-112,-56),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C22D1Ev,_ZTv0_n24_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C22D0Ev,_ZTv0_n24_N8S7825C22D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev)();
extern void ABISELECT(_ZThn168_N8S7825C22D1Ev,_ZThn84_N8S7825C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev)();
extern void ABISELECT(_ZThn168_N8S7825C22D0Ev,_ZThn84_N8S7825C22D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C14__8S7825C22__8S7825C29[] = {
  ABISELECT(-168,-84),
  ABISELECT(-168,-84),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev),
};
extern void ABISELECT(_ZThn16_N8S7825C22D1Ev,_ZThn8_N8S7825C22D1Ev)();
extern void ABISELECT(_ZThn16_N8S7825C22D0Ev,_ZThn8_N8S7825C22D0Ev)();
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C15__8S7825C22__8S7825C29[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C22D1Ev,_ZThn8_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C22D0Ev,_ZThn8_N8S7825C22D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
extern void _ZN8S7825C12D1Ev();
extern void _ZN8S7825C12D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C12__8S7825C29[] = {
  ABISELECT(56,28),
  ABISELECT(32,16),
  ABISELECT(-112,-56),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&_ZN8S7825C12D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C12D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZThn32_N8S7825C12D1Ev,_ZThn16_N8S7825C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
extern void ABISELECT(_ZThn32_N8S7825C12D0Ev,_ZThn16_N8S7825C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7825C5__A1__8S7825C12__8S7825C29[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZThn56_N8S7825C12D1Ev,_ZThn28_N8S7825C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
extern void ABISELECT(_ZThn56_N8S7825C12D0Ev,_ZThn28_N8S7825C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C14__8S7825C12__8S7825C29[] = {
  ABISELECT(-56,-28),
  ABISELECT(-56,-28),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
};
static  VTT_ENTRY vtt_S7825C29[] = {
  {&(_ZTV8S7825C29[7]),  7,49},
  {&(_tg__ZTV8S7825C22__8S7825C29[7]),  7,9},
  {&(_tg__ZTV8S7825C158S7825C22__8S7825C29[3]),  3,6},
  {&(_tg__ZTV7S7825C5__8S7825C22__8S7825C29[3]),  3,5},
  {&(_tg__ZTV8S7825C12__8S7825C22__8S7825C29[6]),  6,8},
  {&(_tg__ZTV8S7825C14__8S7825C22__8S7825C29[3]),  3,5},
  {&(_tg__ZTV8S7825C15__8S7825C22__8S7825C29[3]),  3,6},
  {&(_ZTV8S7825C29[37]),  37,49},
  {&(_ZTV8S7825C29[42]),  42,49},
  {&(_ZTV8S7825C29[47]),  47,49},
  {&(_ZTV8S7825C29[12]),  12,49},
  {&(_tg__ZTV8S7825C12__8S7825C29[5]),  5,7},
  {&(_tg__ZTV7S7825C5__A1__8S7825C12__8S7825C29[3]),  3,5},
  {&(_tg__ZTV8S7825C14__8S7825C12__8S7825C29[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S7825C29[];
extern  VTBL_ENTRY _ZTV8S7825C29[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C29[];
static VTBL_ENTRY alt_thunk_names12[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S7825C12D0Ev,_ZThn28_N8S7825C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C12D0Ev,_ZThn16_N8S7825C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S7825C12D1Ev,_ZThn28_N8S7825C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C12D1Ev,_ZThn16_N8S7825C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C22D0Ev,_ZTv0_n24_N8S7825C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N8S7825C22D0Ev,_ZThn56_N8S7825C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C22D1Ev,_ZTv0_n24_N8S7825C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N8S7825C22D1Ev,_ZThn56_N8S7825C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn168_N8S7825C22D0Ev,_ZThn84_N8S7825C22D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn144_N8S7825C22D0Ev,_ZThn72_N8S7825C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn168_N8S7825C22D1Ev,_ZThn84_N8S7825C22D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn144_N8S7825C22D1Ev,_ZThn72_N8S7825C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C29D0Ev,_ZTv0_n12_N8S7825C29D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn168_N8S7825C29D0Ev,_ZThn84_N8S7825C29D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn144_N8S7825C29D0Ev,_ZThn72_N8S7825C29D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C29D1Ev,_ZTv0_n12_N8S7825C29D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn168_N8S7825C29D1Ev,_ZThn84_N8S7825C29D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn144_N8S7825C29D1Ev,_ZThn72_N8S7825C29D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C29D0Ev,_ZTv0_n24_N8S7825C29D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N8S7825C29D0Ev,_ZThn56_N8S7825C29D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C29D1Ev,_ZTv0_n24_N8S7825C29D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N8S7825C29D1Ev,_ZThn56_N8S7825C29D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7825C29 = {  "S7825C29", // class name
  bases_S7825C29, 35,
  &(vtc_S7825C29[0]), // expected_vtbl_contents
  &(vtt_S7825C29[0]), // expected_vtt_contents
  ABISELECT(184,92), // object size
  NSPAIRA(_ZTI8S7825C29),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S7825C29),49, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7825C29),14, //virtual table table var
  20, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names12,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C31  : virtual S7825C13 , virtual S2407C8_nt , virtual S2407C27 , S7825C23_nt {
  int s7825c31f0;
  ::S7825C5 s7825c31f1[10];
  ~S7825C31(); // tgen
  S7825C31(); // tgen
};
//SIG(-1 S7825C31) C1{ VBC2{ BC3{ m} BC4{ BC3 BC5{ m} BC6{ vd m Fc} vd Fp} vd Fi} VBC7{ m} VBC5 BC8{ vd m Fp} Fi FC4[10]}


S7825C31 ::~S7825C31(){ note_dtor("S7825C31", this);} // tgen
S7825C31 ::S7825C31(){ note_ctor("S7825C31", this);} // tgen

static void Test_S7825C31()
{
  extern Class_Descriptor cd_S7825C31;
  void *lvp;
  {
    ABISELECT(double,int) buf[38];
    init_test(&cd_S7825C31, buf);
    S7825C31 *dp, &lv = *(dp=new (buf) S7825C31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(296,148), "sizeof(S7825C31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7825C31)");
    /*is_ambiguous_... S7825C13::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C13*), ABISELECT(288,144), "S7825C31");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C13*), ABISELECT(264,132), "S7825C31");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C13*), ABISELECT(264,132), "S7825C31");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C13*), ABISELECT(264,132), "S7825C31");
    check_base_class_offset(lv, (S7825C5*)(S7825C13*), ABISELECT(264,132), "S7825C31");
    check_base_class_offset(lv, (S7825C13*), ABISELECT(264,132), "S7825C31");
    check_base_class_offset(lv, (S2407C8_nt*), 0, "S7825C31");
    /*is_ambiguous_... S7825C31::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*), 0, "S7825C31");
    check_base_class_offset(lv, (S7825C23_nt*), 0, "S7825C31");
    check_field_offset(lv, s7825c31f0, ABISELECT(16,8), "S7825C31.s7825c31f0");
    check_field_offset(lv, s7825c31f1, ABISELECT(24,12), "S7825C31.s7825c31f1");
    test_class_info(&lv, &cd_S7825C31);
    dp->~S7825C31();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7825C31(Test_S7825C31, "S7825C31", ABISELECT(296,148));

#else // __cplusplus

extern void _ZN8S7825C31C1Ev();
extern void _ZN8S7825C31D1Ev();
Name_Map name_map_S7825C31[] = {
  NSPAIR(_ZN8S7825C31C1Ev),
  NSPAIR(_ZN8S7825C31D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C13;
extern VTBL_ENTRY _ZTI8S7825C13[];
extern  VTBL_ENTRY _ZTV8S7825C13[];
extern Class_Descriptor cd_S2407C8_nt;
extern VTBL_ENTRY _ZTI10S2407C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C23_nt;
extern VTBL_ENTRY _ZTI11S7825C23_nt[];
extern  VTBL_ENTRY _ZTV11S7825C23_nt[];
static Base_Class bases_S7825C31[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2407C30,    ABISELECT(288,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(264,132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(264,132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(264,132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(264,132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7825C13,    ABISELECT(264,132), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2407C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2407C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7825C23_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7825C31[];
extern void _ZN8S7825C31D1Ev();
extern void _ZN8S7825C31D0Ev();
extern void ABISELECT(_ZTv0_n24_N8S7825C31D1Ev,_ZTv0_n12_N8S7825C31D1Ev)();
extern void ABISELECT(_ZThn264_N8S7825C31D1Ev,_ZThn132_N8S7825C31D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C31D0Ev,_ZTv0_n12_N8S7825C31D0Ev)();
extern void ABISELECT(_ZThn264_N8S7825C31D0Ev,_ZThn132_N8S7825C31D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7825C31[] = {
  0,
  0,
  ABISELECT(264,132),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C31[0]),
  (VTBL_ENTRY)&_ZN8S7825C31D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C31D0Ev,
  ABISELECT(-264,-132),
  ABISELECT(-264,-132),
  (VTBL_ENTRY)&(_ZTI8S7825C31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C31D1Ev,_ZTv0_n12_N8S7825C31D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C31D0Ev,_ZTv0_n12_N8S7825C31D0Ev),
};
extern VTBL_ENTRY _ZTV8S7825C31[];
static  VTT_ENTRY vtt_S7825C31[] = {
  {&(_ZTV8S7825C31[5]),  5,12},
  {&(_ZTV8S7825C31[10]),  10,12},
};
extern VTBL_ENTRY _ZTI8S7825C31[];
extern  VTBL_ENTRY _ZTV8S7825C31[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C31[];
static VTBL_ENTRY alt_thunk_names13[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C31D0Ev,_ZTv0_n12_N8S7825C31D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn264_N8S7825C31D0Ev,_ZThn132_N8S7825C31D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C31D1Ev,_ZTv0_n12_N8S7825C31D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn264_N8S7825C31D1Ev,_ZThn132_N8S7825C31D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7825C31 = {  "S7825C31", // class name
  bases_S7825C31, 9,
  &(vtc_S7825C31[0]), // expected_vtbl_contents
  &(vtt_S7825C31[0]), // expected_vtt_contents
  ABISELECT(296,148), // object size
  NSPAIRA(_ZTI8S7825C31),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S7825C31),12, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7825C31),2, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names13,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C32  {
  ::S7825C5 s7825c32f0;
  void  mf7825c32(); // _ZN8S7825C329mf7825c32Ev
};
//SIG(-1 S7825C32) C1{ m FC2{ BC3{ m} BC4{ m} BC5{ vd m Fc} vd Fp}}


void  S7825C32 ::mf7825c32(){}

static void Test_S7825C32()
{
  {
    init_simple_test("S7825C32");
    S7825C32 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S7825C32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7825C32)");
    check_field_offset(lv, s7825c32f0, 0, "S7825C32.s7825c32f0");
  }
}
static Arrange_To_Call_Me vS7825C32(Test_S7825C32, "S7825C32", ABISELECT(24,12));

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S7825C32[];
VTBL_ENTRY *P__ZTI8S7825C32 = _ZTI8S7825C32; 
Class_Descriptor cd_S7825C32 = {  "S7825C32", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI8S7825C32),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C34  : virtual S7825C32 , virtual S2407C27 {
  ~S7825C34(); // tgen
  S7825C34(); // tgen
};
//SIG(-1 S7825C34) C1{ VBC2{ m FC3{ BC4{ m} BC5{ m} BC6{ vd m Fc} vd Fp}} VBC5}


S7825C34 ::~S7825C34(){ note_dtor("S7825C34", this);} // tgen
S7825C34 ::S7825C34(){ note_ctor("S7825C34", this);} // tgen

static void Test_S7825C34()
{
  extern Class_Descriptor cd_S7825C34;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S7825C34, buf);
    S7825C34 *dp, &lv = *(dp=new (buf) S7825C34());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S7825C34)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7825C34)");
    check_base_class_offset(lv, (S7825C32*), ABISELECT(8,4), "S7825C34");
    check_base_class_offset(lv, (S2407C27*), 0, "S7825C34");
    test_class_info(&lv, &cd_S7825C34);
    dp->~S7825C34();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7825C34(Test_S7825C34, "S7825C34", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN8S7825C34C1Ev();
extern void _ZN8S7825C34D1Ev();
Name_Map name_map_S7825C34[] = {
  NSPAIR(_ZN8S7825C34C1Ev),
  NSPAIR(_ZN8S7825C34D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7825C32;
extern VTBL_ENTRY _ZTI8S7825C32[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
static Base_Class bases_S7825C34[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7825C32,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2407C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7825C34[];
static  VTBL_ENTRY vtc_S7825C34[] = {
  0,
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C34[0]),
};
extern VTBL_ENTRY _ZTV8S7825C34[];
static  VTT_ENTRY vtt_S7825C34[] = {
  {&(_ZTV8S7825C34[4]),  4,4},
};
extern VTBL_ENTRY _ZTI8S7825C34[];
extern  VTBL_ENTRY _ZTV8S7825C34[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C34[];
Class_Descriptor cd_S7825C34 = {  "S7825C34", // class name
  bases_S7825C34, 2,
  &(vtc_S7825C34[0]), // expected_vtbl_contents
  &(vtt_S7825C34[0]), // expected_vtt_contents
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI8S7825C34),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S7825C34),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7825C34),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C33  : S7825C34 {
  ~S7825C33(); // tgen
  S7825C33(); // tgen
};
//SIG(-1 S7825C33) C1{ BC2{ VBC3{ m FC4{ BC5{ m} BC6{ m} BC7{ vd m Fc} vd Fp}} VBC6}}


S7825C33 ::~S7825C33(){ note_dtor("S7825C33", this);} // tgen
S7825C33 ::S7825C33(){ note_ctor("S7825C33", this);} // tgen

static void Test_S7825C33()
{
  extern Class_Descriptor cd_S7825C33;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S7825C33, buf);
    S7825C33 *dp, &lv = *(dp=new (buf) S7825C33());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S7825C33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7825C33)");
    check_base_class_offset(lv, (S7825C32*)(S7825C34*), ABISELECT(8,4), "S7825C33");
    check_base_class_offset(lv, (S2407C27*)(S7825C34*), 0, "S7825C33");
    check_base_class_offset(lv, (S7825C34*), 0, "S7825C33");
    test_class_info(&lv, &cd_S7825C33);
    dp->~S7825C33();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7825C33(Test_S7825C33, "S7825C33", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN8S7825C33C1Ev();
extern void _ZN8S7825C33D1Ev();
Name_Map name_map_S7825C33[] = {
  NSPAIR(_ZN8S7825C33C1Ev),
  NSPAIR(_ZN8S7825C33D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7825C32;
extern VTBL_ENTRY _ZTI8S7825C32[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C34;
extern VTBL_ENTRY _ZTI8S7825C34[];
extern  VTBL_ENTRY _ZTV8S7825C34[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C34[];
static Base_Class bases_S7825C33[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7825C32,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S2407C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S7825C34,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7825C33[];
static  VTBL_ENTRY vtc_S7825C33[] = {
  0,
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C33[0]),
};
extern VTBL_ENTRY _ZTV8S7825C33[];
static  VTBL_ENTRY _tg__ZTV8S7825C34__8S7825C33[] = {
  0,
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C34[0]),
};
static  VTT_ENTRY vtt_S7825C33[] = {
  {&(_ZTV8S7825C33[4]),  4,4},
  {&(_tg__ZTV8S7825C34__8S7825C33[4]),  4,4},
};
extern VTBL_ENTRY _ZTI8S7825C33[];
extern  VTBL_ENTRY _ZTV8S7825C33[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C33[];
Class_Descriptor cd_S7825C33 = {  "S7825C33", // class name
  bases_S7825C33, 3,
  &(vtc_S7825C33[0]), // expected_vtbl_contents
  &(vtt_S7825C33[0]), // expected_vtt_contents
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI8S7825C33),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S7825C33),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7825C33),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C30  : virtual S2407C27 , virtual S7825C31 , virtual S7825C32 , S7825C33 {
  __tsi64 s7825c30f0[8];
  virtual  ~S7825C30(); // _ZN8S7825C30D2Ev
  virtual void  v4(); // _ZN8S7825C302v4Ev
  S7825C30(); // tgen
};
//SIG(-1 S7825C30) C1{ VBC2{ m} VBC3{ VBC4{ BC5{ m} BC6{ BC5 BC2 BC7{ vd m Fc} vd Fp} vd Fi} VBC8{ m} VBC2 BC9{ vd m Fp} Fi FC6[10]} VBC10{ m FC6} BC11{ BC12{ VBC10 VBC2}} vd v1 FL[8]}


 S7825C30 ::~S7825C30(){ note_dtor("S7825C30", this);}
void  S7825C30 ::v4(){vfunc_called(this, "_ZN8S7825C302v4Ev");}
S7825C30 ::S7825C30(){ note_ctor("S7825C30", this);} // tgen

static void Test_S7825C30()
{
  extern Class_Descriptor cd_S7825C30;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(50,58)];
    init_test(&cd_S7825C30, buf);
    S7825C30 *dp, &lv = *(dp=new (buf) S7825C30());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(392,228), "sizeof(S7825C30)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7825C30)");
    /*is_ambiguous_... S7825C30::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*), 0, "S7825C30");
    /*is_ambiguous_... S7825C31::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C31*), 0, "S7825C30");
    check_base_class_offset(lv, (S2407C27*)(S7825C34*)(S7825C33*), 0, "S7825C30");
    /*is_ambiguous_... S7825C13::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C13*), ABISELECT(360,212), "S7825C30");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C13*), ABISELECT(336,200), "S7825C30");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C13*), ABISELECT(336,200), "S7825C30");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C13*), ABISELECT(336,200), "S7825C30");
    check_base_class_offset(lv, (S7825C5*)(S7825C13*), ABISELECT(336,200), "S7825C30");
    check_base_class_offset(lv, (S7825C13*)(S7825C31*), ABISELECT(336,200), "S7825C30");
    check_base_class_offset(lv, (S2407C8_nt*)(S7825C31*), 0, "S7825C30");
    check_base_class_offset(lv, (S7825C23_nt*)(S7825C31*), ABISELECT(72,68), "S7825C30");
    check_base_class_offset(lv, (S7825C31*), ABISELECT(72,68), "S7825C30");
    check_base_class_offset(lv, (S7825C32*), ABISELECT(368,216), "S7825C30");
    check_base_class_offset(lv, (S7825C32*)(S7825C34*)(S7825C33*), ABISELECT(368,216), "S7825C30");
    check_base_class_offset(lv, (S7825C34*)(S7825C33*), 0, "S7825C30");
    check_base_class_offset(lv, (S7825C33*), 0, "S7825C30");
    check_field_offset(lv, s7825c30f0, ABISELECT(8,4), "S7825C30.s7825c30f0");
    test_class_info(&lv, &cd_S7825C30);
    dp->~S7825C30();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7825C30(Test_S7825C30, "S7825C30", ABISELECT(392,228));

#else // __cplusplus

extern void _ZN8S7825C30C1Ev();
extern void _ZN8S7825C30D2Ev();
Name_Map name_map_S7825C30[] = {
  NSPAIR(_ZN8S7825C30C1Ev),
  NSPAIR(_ZN8S7825C30D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C13;
extern VTBL_ENTRY _ZTI8S7825C13[];
extern  VTBL_ENTRY _ZTV8S7825C13[];
extern Class_Descriptor cd_S2407C8_nt;
extern VTBL_ENTRY _ZTI10S2407C8_nt[];
extern Class_Descriptor cd_S7825C23_nt;
extern VTBL_ENTRY _ZTI11S7825C23_nt[];
extern  VTBL_ENTRY _ZTV11S7825C23_nt[];
extern Class_Descriptor cd_S7825C31;
extern VTBL_ENTRY _ZTI8S7825C31[];
extern  VTBL_ENTRY _ZTV8S7825C31[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C31[];
extern Class_Descriptor cd_S7825C32;
extern VTBL_ENTRY _ZTI8S7825C32[];
extern Class_Descriptor cd_S7825C34;
extern VTBL_ENTRY _ZTI8S7825C34[];
extern  VTBL_ENTRY _ZTV8S7825C34[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C34[];
extern Class_Descriptor cd_S7825C33;
extern VTBL_ENTRY _ZTI8S7825C33[];
extern  VTBL_ENTRY _ZTV8S7825C33[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C33[];
static Base_Class bases_S7825C30[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2407C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2407C30,    ABISELECT(360,212), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(336,200), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(336,200), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(336,200), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(336,200), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S7825C13,    ABISELECT(336,200), //bcp->offset
    18, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S2407C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S7825C23_nt,    ABISELECT(72,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S7825C31,    ABISELECT(72,68), //bcp->offset
    10, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7825C32,    ABISELECT(368,216), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7825C34,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S7825C33,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7825C30[];
extern void _ZN8S7825C30D1Ev();
extern void _ZN8S7825C30D0Ev();
extern void _ZN8S7825C302v4Ev();
extern void ABISELECT(_ZTv0_n48_N8S7825C30D1Ev,_ZTv0_n24_N8S7825C30D1Ev)();
extern void ABISELECT(_ZThn72_N8S7825C30D1Ev,_ZThn68_N8S7825C30D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7825C30D0Ev,_ZTv0_n24_N8S7825C30D0Ev)();
extern void ABISELECT(_ZThn72_N8S7825C30D0Ev,_ZThn68_N8S7825C30D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C30D1Ev,_ZTv0_n12_N8S7825C30D1Ev)();
extern void ABISELECT(_ZThn336_N8S7825C30D1Ev,_ZThn200_N8S7825C30D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C30D0Ev,_ZTv0_n12_N8S7825C30D0Ev)();
extern void ABISELECT(_ZThn336_N8S7825C30D0Ev,_ZThn200_N8S7825C30D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7825C30[] = {
  0,
  ABISELECT(336,200),
  ABISELECT(72,68),
  0,
  ABISELECT(368,216),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C30[0]),
  (VTBL_ENTRY)&_ZN8S7825C30D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C30D0Ev,
  (VTBL_ENTRY)&_ZN8S7825C302v4Ev,
  ABISELECT(-72,-68),
  ABISELECT(-72,-68),
  ABISELECT(-72,-68),
  ABISELECT(264,132),
  ABISELECT(-72,-68),
  (VTBL_ENTRY)&(_ZTI8S7825C30[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C30D1Ev,_ZTv0_n24_N8S7825C30D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C30D0Ev,_ZTv0_n24_N8S7825C30D0Ev),
  ABISELECT(-336,-200),
  ABISELECT(-336,-200),
  (VTBL_ENTRY)&(_ZTI8S7825C30[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C30D1Ev,_ZTv0_n12_N8S7825C30D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C30D0Ev,_ZTv0_n12_N8S7825C30D0Ev),
};
extern VTBL_ENTRY _ZTV8S7825C30[];
static  VTBL_ENTRY _tg__ZTV8S7825C33__8S7825C30[] = {
  0,
  ABISELECT(368,216),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C33[0]),
};
static  VTBL_ENTRY _tg__ZTV8S7825C348S7825C33__8S7825C30[] = {
  0,
  ABISELECT(368,216),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C34[0]),
};
extern void _ZN8S7825C31D1Ev();
extern void _ZN8S7825C31D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C31__8S7825C30[] = {
  ABISELECT(-72,-68),
  ABISELECT(-72,-68),
  ABISELECT(264,132),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C31[0]),
  (VTBL_ENTRY)&_ZN8S7825C31D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C31D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C31D1Ev,_ZTv0_n12_N8S7825C31D1Ev)();
extern void ABISELECT(_ZThn264_N8S7825C31D1Ev,_ZThn132_N8S7825C31D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C31D0Ev,_ZTv0_n12_N8S7825C31D0Ev)();
extern void ABISELECT(_ZThn264_N8S7825C31D0Ev,_ZThn132_N8S7825C31D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C13__8S7825C31__8S7825C30[] = {
  ABISELECT(-264,-132),
  ABISELECT(-264,-132),
  (VTBL_ENTRY)&(_ZTI8S7825C31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C31D1Ev,_ZTv0_n12_N8S7825C31D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C31D0Ev,_ZTv0_n12_N8S7825C31D0Ev),
};
static  VTT_ENTRY vtt_S7825C30[] = {
  {&(_ZTV8S7825C30[7]),  7,23},
  {&(_tg__ZTV8S7825C33__8S7825C30[4]),  4,4},
  {&(_tg__ZTV8S7825C348S7825C33__8S7825C30[4]),  4,4},
  {&(_ZTV8S7825C30[16]),  16,23},
  {&(_ZTV8S7825C30[21]),  21,23},
  {&(_tg__ZTV8S7825C31__8S7825C30[5]),  5,7},
  {&(_tg__ZTV8S7825C13__8S7825C31__8S7825C30[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S7825C30[];
extern  VTBL_ENTRY _ZTV8S7825C30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C30[];
static VTBL_ENTRY alt_thunk_names14[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C31D0Ev,_ZTv0_n12_N8S7825C31D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn264_N8S7825C31D0Ev,_ZThn132_N8S7825C31D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C31D1Ev,_ZTv0_n12_N8S7825C31D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn264_N8S7825C31D1Ev,_ZThn132_N8S7825C31D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C30D0Ev,_ZTv0_n12_N8S7825C30D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn336_N8S7825C30D0Ev,_ZThn200_N8S7825C30D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C30D1Ev,_ZTv0_n12_N8S7825C30D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn336_N8S7825C30D1Ev,_ZThn200_N8S7825C30D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C30D0Ev,_ZTv0_n24_N8S7825C30D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N8S7825C30D0Ev,_ZThn68_N8S7825C30D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C30D1Ev,_ZTv0_n24_N8S7825C30D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N8S7825C30D1Ev,_ZThn68_N8S7825C30D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7825C30 = {  "S7825C30", // class name
  bases_S7825C30, 13,
  &(vtc_S7825C30[0]), // expected_vtbl_contents
  &(vtt_S7825C30[0]), // expected_vtt_contents
  ABISELECT(392,228), // object size
  NSPAIRA(_ZTI8S7825C30),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S7825C30),23, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7825C30),7, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names14,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C28  : virtual S7825C29 {
  ::S7825C30 s7825c28f0;
  virtual  ~S7825C28(); // _ZN8S7825C28D2Ev
  S7825C28(); // tgen
};
//SIG(-1 S7825C28) C1{ VBC2{ VBC3{ m} VBC4{ VBC3 BC5{ BC6{ m} BC7{ BC6 BC3 BC8{ vd m Fc} vd Fp} vd Fi} VBC7 VBC9{ BC8 BC3} vd} BC10{ VBC7 VBC4 BC11{ vd m Fp} BC12{ BC3 BC9 BC8 BC7 VBC6 vd v1} BC9 vd} BC7} vd FC13{ VBC3 VBC14{ VBC5 VBC15{ m} VBC3 BC11 Fi FC7[10]} VBC16{ m FC7} BC17{ BC18{ VBC16 VBC3}} vd v2 FL[8]}}


 S7825C28 ::~S7825C28(){ note_dtor("S7825C28", this);}
S7825C28 ::S7825C28(){ note_ctor("S7825C28", this);} // tgen

static void Test_S7825C28()
{
  extern Class_Descriptor cd_S7825C28;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(74,82)];
    init_test(&cd_S7825C28, buf);
    S7825C28 *dp, &lv = *(dp=new (buf) S7825C28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(584,324), "sizeof(S7825C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7825C28)");
    /*is_ambiguous_... S7825C29::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C29*), 0, "S7825C28");
    /*is_ambiguous_... S7825C12::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C12*), 0, "S7825C28");
    /*is_ambiguous_... S7825C13::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C13*)(S7825C12*), ABISELECT(536,300), "S7825C28");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(512,288), "S7825C28");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(512,288), "S7825C28");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(512,288), "S7825C28");
    check_base_class_offset(lv, (S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(512,288), "S7825C28");
    check_base_class_offset(lv, (S7825C13*)(S7825C12*), ABISELECT(512,288), "S7825C28");
    /*is_ambiguous_... S7825C28::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*), ABISELECT(544,304), "S7825C28");
    /*is_ambiguous_... S7825C28::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*), ABISELECT(544,304), "S7825C28");
    /*is_ambiguous_... S7825C28::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*), ABISELECT(544,304), "S7825C28");
    /*is_ambiguous_... S7825C12::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C12*), ABISELECT(544,304), "S7825C28");
    /*is_ambiguous_... S7825C22::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C22*)(S7825C29*), ABISELECT(544,304), "S7825C28");
    /*is_ambiguous_... S7825C28::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*), ABISELECT(568,316), "S7825C28");
    /*is_ambiguous_... S7825C28::S7825C14 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C14*), ABISELECT(568,316), "S7825C28");
    check_base_class_offset(lv, (S7825C14*)(S7825C12*), ABISELECT(568,316), "S7825C28");
    check_base_class_offset(lv, (S7825C12*)(S7825C29*), ABISELECT(512,288), "S7825C28");
    check_base_class_offset(lv, (S7825C12*)(S7825C22*)(S7825C29*), ABISELECT(512,288), "S7825C28");
    check_base_class_offset(lv, (S7825C23_nt*)(S7825C22*)(S7825C29*), ABISELECT(400,232), "S7825C28");
    /*is_ambiguous_... S7825C15::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C15*)(S7825C22*)(S7825C29*), ABISELECT(425,245), "S7825C28");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C15*)(S7825C22*)(S7825C29*), ABISELECT(416,240), "S7825C28");
    check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C15*)(S7825C22*)(S7825C29*), ABISELECT(416,240), "S7825C28");
    check_base_class_offset(lv, (S7825C14*)(S7825C15*)(S7825C22*)(S7825C29*), ABISELECT(416,240), "S7825C28");
    /*is_ambiguous_... S7825C15::S7825C8_nt */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C15*)(S7825C22*)(S7825C29*), ABISELECT(432,248), "S7825C28");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C15*)(S7825C22*)(S7825C29*), ABISELECT(448,256), "S7825C28");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C15*)(S7825C22*)(S7825C29*), ABISELECT(448,256), "S7825C28");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C15*)(S7825C22*)(S7825C29*), ABISELECT(448,256), "S7825C28");
    check_base_class_offset(lv, (S7825C5*)(S7825C15*)(S7825C22*)(S7825C29*), ABISELECT(448,256), "S7825C28");
    /*is_ambiguous_... S7825C15::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C15*)(S7825C22*)(S7825C29*), 0, "S7825C28");
    check_base_class_offset(lv, (S7825C15*)(S7825C22*)(S7825C29*), ABISELECT(416,240), "S7825C28");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C22*)(S7825C29*), ABISELECT(472,268), "S7825C28");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C22*)(S7825C29*), ABISELECT(472,268), "S7825C28");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C14*)(S7825C22*)(S7825C29*), ABISELECT(472,268), "S7825C28");
    check_base_class_offset(lv, (S7825C22*)(S7825C29*), ABISELECT(400,232), "S7825C28");
    /*is_ambiguous_... S7825C29::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C29*), ABISELECT(488,276), "S7825C28");
    /*is_ambiguous_... S7825C29::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C29*), ABISELECT(488,276), "S7825C28");
    /*is_ambiguous_... S7825C29::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C29*), ABISELECT(488,276), "S7825C28");
    /*is_ambiguous_... S7825C29::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C29*), ABISELECT(488,276), "S7825C28");
    check_base_class_offset(lv, (S7825C29*), ABISELECT(400,232), "S7825C28");
    check_field_offset(lv, s7825c28f0, ABISELECT(8,4), "S7825C28.s7825c28f0");
    test_class_info(&lv, &cd_S7825C28);
    dp->~S7825C28();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7825C28(Test_S7825C28, "S7825C28", ABISELECT(584,324));

#else // __cplusplus

extern void _ZN8S7825C28C1Ev();
extern void _ZN8S7825C28D2Ev();
Name_Map name_map_S7825C28[] = {
  NSPAIR(_ZN8S7825C28C1Ev),
  NSPAIR(_ZN8S7825C28D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C13;
extern VTBL_ENTRY _ZTI8S7825C13[];
extern  VTBL_ENTRY _ZTV8S7825C13[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C12;
extern VTBL_ENTRY _ZTI8S7825C12[];
extern  VTBL_ENTRY _ZTV8S7825C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C12[];
extern Class_Descriptor cd_S7825C23_nt;
extern VTBL_ENTRY _ZTI11S7825C23_nt[];
extern  VTBL_ENTRY _ZTV11S7825C23_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S7825C15;
extern VTBL_ENTRY _ZTI8S7825C15[];
extern  VTBL_ENTRY _ZTV8S7825C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C15[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C22;
extern VTBL_ENTRY _ZTI8S7825C22[];
extern  VTBL_ENTRY _ZTV8S7825C22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C22[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C29;
extern VTBL_ENTRY _ZTI8S7825C29[];
extern  VTBL_ENTRY _ZTV8S7825C29[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C29[];
static Base_Class bases_S7825C28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2407C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S2407C30,    ABISELECT(536,300), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(512,288), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(512,288), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(512,288), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(512,288), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S7825C13,    ABISELECT(512,288), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(544,304), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(544,304), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(544,304), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(544,304), //bcp->offset
    51, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S7825C8_nt,    ABISELECT(568,316), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(568,316), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(568,316), //bcp->offset
    56, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S7825C12,    ABISELECT(512,288), //bcp->offset
    43, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    30, //immediately_derived
  0, 1},
  {&cd_S7825C23_nt,    ABISELECT(400,232), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(425,245), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(416,240), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(416,240), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(416,240), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(432,248), //bcp->offset
    27, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(448,256), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(448,256), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(448,256), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(448,256), //bcp->offset
    31, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S2407C30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    26, //immediately_derived
  0, 1},
  {&cd_S7825C15,    ABISELECT(416,240), //bcp->offset
    21, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(472,268), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(472,268), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(472,268), //bcp->offset
    35, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S7825C22,    ABISELECT(400,232), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(488,276), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(488,276), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(488,276), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(488,276), //bcp->offset
    39, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S7825C29,    ABISELECT(400,232), //bcp->offset
    10, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7825C28[];
extern void _ZN8S7825C28D1Ev();
extern void _ZN8S7825C28D0Ev();
extern void ABISELECT(_ZTv0_n64_N8S7825C28D1Ev,_ZTv0_n32_N8S7825C28D1Ev)();
extern void ABISELECT(_ZThn400_N8S7825C28D1Ev,_ZThn232_N8S7825C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S7825C28D0Ev,_ZTv0_n32_N8S7825C28D0Ev)();
extern void ABISELECT(_ZThn400_N8S7825C28D0Ev,_ZThn232_N8S7825C28D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n64_N8S7825C28D1Ev,_ZTvn8_n32_N8S7825C28D1Ev)();
extern void ABISELECT(_ZTvn16_n64_N8S7825C28D0Ev,_ZTvn8_n32_N8S7825C28D0Ev)();
extern void _ZN8S7825C152v2Ev();
extern void ABISELECT(_ZTvn32_n64_N8S7825C28D1Ev,_ZTvn16_n32_N8S7825C28D1Ev)();
extern void ABISELECT(_ZTvn32_n64_N8S7825C28D0Ev,_ZTvn16_n32_N8S7825C28D0Ev)();
extern void ABISELECT(_ZTvn48_n64_N8S7825C28D1Ev,_ZTvn24_n32_N8S7825C28D1Ev)();
extern void ABISELECT(_ZTvn48_n64_N8S7825C28D0Ev,_ZTvn24_n32_N8S7825C28D0Ev)();
extern void ABISELECT(_ZTvn72_n64_N8S7825C28D1Ev,_ZTvn36_n32_N8S7825C28D1Ev)();
extern void ABISELECT(_ZTvn72_n64_N8S7825C28D0Ev,_ZTvn36_n32_N8S7825C28D0Ev)();
extern void ABISELECT(_ZTvn88_n64_N8S7825C28D1Ev,_ZTvn44_n32_N8S7825C28D1Ev)();
extern void ABISELECT(_ZTvn88_n64_N8S7825C28D0Ev,_ZTvn44_n32_N8S7825C28D0Ev)();
extern void ABISELECT(_ZTv0_n48_N8S7825C28D1Ev,_ZTv0_n24_N8S7825C28D1Ev)();
extern void ABISELECT(_ZThn512_N8S7825C28D1Ev,_ZThn288_N8S7825C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7825C28D0Ev,_ZTv0_n24_N8S7825C28D0Ev)();
extern void ABISELECT(_ZThn512_N8S7825C28D0Ev,_ZThn288_N8S7825C28D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C28D1Ev,_ZTv0_n12_N8S7825C28D1Ev)();
extern void ABISELECT(_ZThn544_N8S7825C28D1Ev,_ZThn304_N8S7825C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C28D0Ev,_ZTv0_n12_N8S7825C28D0Ev)();
extern void ABISELECT(_ZThn544_N8S7825C28D0Ev,_ZThn304_N8S7825C28D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C28D1Ev,_ZTv0_n12_N8S7825C28D1Ev)();
extern void ABISELECT(_ZThn568_N8S7825C28D1Ev,_ZThn316_N8S7825C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C28D0Ev,_ZTv0_n12_N8S7825C28D0Ev)();
extern void ABISELECT(_ZThn568_N8S7825C28D0Ev,_ZThn316_N8S7825C28D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7825C28[] = {
  0,
  ABISELECT(568,316),
  ABISELECT(544,304),
  ABISELECT(512,288),
  0,
  ABISELECT(400,232),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C28[0]),
  (VTBL_ENTRY)&_ZN8S7825C28D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C28D0Ev,
  ABISELECT(16,8),
  ABISELECT(-400,-232),
  ABISELECT(-400,-232),
  ABISELECT(168,84),
  ABISELECT(-400,-232),
  ABISELECT(112,56),
  ABISELECT(144,72),
  ABISELECT(-400,-232),
  (VTBL_ENTRY)&(_ZTI8S7825C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7825C28D1Ev,_ZTv0_n32_N8S7825C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7825C28D0Ev,_ZTv0_n32_N8S7825C28D0Ev),
  ABISELECT(-416,-240),
  ABISELECT(-416,-240),
  (VTBL_ENTRY)&(_ZTI8S7825C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n64_N8S7825C28D1Ev,_ZTvn8_n32_N8S7825C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n64_N8S7825C28D0Ev,_ZTvn8_n32_N8S7825C28D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
  ABISELECT(-432,-248),
  (VTBL_ENTRY)&(_ZTI8S7825C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n64_N8S7825C28D1Ev,_ZTvn16_n32_N8S7825C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n64_N8S7825C28D0Ev,_ZTvn16_n32_N8S7825C28D0Ev),
  ABISELECT(-448,-256),
  (VTBL_ENTRY)&(_ZTI8S7825C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn48_n64_N8S7825C28D1Ev,_ZTvn24_n32_N8S7825C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn48_n64_N8S7825C28D0Ev,_ZTvn24_n32_N8S7825C28D0Ev),
  ABISELECT(-472,-268),
  (VTBL_ENTRY)&(_ZTI8S7825C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn72_n64_N8S7825C28D1Ev,_ZTvn36_n32_N8S7825C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn72_n64_N8S7825C28D0Ev,_ZTvn36_n32_N8S7825C28D0Ev),
  ABISELECT(-488,-276),
  (VTBL_ENTRY)&(_ZTI8S7825C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn88_n64_N8S7825C28D1Ev,_ZTvn44_n32_N8S7825C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn88_n64_N8S7825C28D0Ev,_ZTvn44_n32_N8S7825C28D0Ev),
  ABISELECT(-512,-288),
  ABISELECT(56,28),
  ABISELECT(32,16),
  ABISELECT(-512,-288),
  ABISELECT(-512,-288),
  (VTBL_ENTRY)&(_ZTI8S7825C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C28D1Ev,_ZTv0_n24_N8S7825C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C28D0Ev,_ZTv0_n24_N8S7825C28D0Ev),
  ABISELECT(-544,-304),
  ABISELECT(-544,-304),
  (VTBL_ENTRY)&(_ZTI8S7825C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C28D1Ev,_ZTv0_n12_N8S7825C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C28D0Ev,_ZTv0_n12_N8S7825C28D0Ev),
  ABISELECT(-568,-316),
  ABISELECT(-568,-316),
  (VTBL_ENTRY)&(_ZTI8S7825C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C28D1Ev,_ZTv0_n12_N8S7825C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C28D0Ev,_ZTv0_n12_N8S7825C28D0Ev),
};
extern VTBL_ENTRY _ZTV8S7825C28[];
extern void _ZN8S7825C29D1Ev();
extern void _ZN8S7825C29D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C29__8S7825C28[] = {
  ABISELECT(-400,-232),
  ABISELECT(168,84),
  ABISELECT(-400,-232),
  ABISELECT(112,56),
  ABISELECT(144,72),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C29[0]),
  (VTBL_ENTRY)&_ZN8S7825C29D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C29D0Ev,
};
extern void _ZN8S7825C22D1Ev();
extern void _ZN8S7825C22D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C228S7825C29__8S7825C28[] = {
  ABISELECT(-400,-232),
  ABISELECT(168,84),
  ABISELECT(-400,-232),
  ABISELECT(112,56),
  ABISELECT(144,72),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&_ZN8S7825C22D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C22D0Ev,
};
extern void _ZN8S7825C15D1Ev();
extern void _ZN8S7825C15D0Ev();
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C158S7825C228S7825C29__8S7825C28[] = {
  ABISELECT(-416,-240),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C15[0]),
  (VTBL_ENTRY)&_ZN8S7825C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C15D0Ev,
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev)();
extern void ABISELECT(_ZThn144_N8S7825C22D1Ev,_ZThn72_N8S7825C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev)();
extern void ABISELECT(_ZThn144_N8S7825C22D0Ev,_ZThn72_N8S7825C22D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7825C5__8S7825C228S7825C29__8S7825C28[] = {
  ABISELECT(-144,-72),
  ABISELECT(-144,-72),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev),
};
extern void ABISELECT(_ZTv0_n48_N8S7825C22D1Ev,_ZTv0_n24_N8S7825C22D1Ev)();
extern void ABISELECT(_ZThn112_N8S7825C22D1Ev,_ZThn56_N8S7825C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7825C22D0Ev,_ZTv0_n24_N8S7825C22D0Ev)();
extern void ABISELECT(_ZThn112_N8S7825C22D0Ev,_ZThn56_N8S7825C22D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C12__8S7825C228S7825C29__8S7825C28[] = {
  ABISELECT(-112,-56),
  ABISELECT(56,28),
  ABISELECT(32,16),
  ABISELECT(-512,-288),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C22D1Ev,_ZTv0_n24_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C22D0Ev,_ZTv0_n24_N8S7825C22D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev)();
extern void ABISELECT(_ZThn168_N8S7825C22D1Ev,_ZThn84_N8S7825C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev)();
extern void ABISELECT(_ZThn168_N8S7825C22D0Ev,_ZThn84_N8S7825C22D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C14__8S7825C228S7825C29__8S7825C28[] = {
  ABISELECT(-168,-84),
  ABISELECT(-168,-84),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev),
};
extern void ABISELECT(_ZThn16_N8S7825C22D1Ev,_ZThn8_N8S7825C22D1Ev)();
extern void ABISELECT(_ZThn16_N8S7825C22D0Ev,_ZThn8_N8S7825C22D0Ev)();
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C15__8S7825C228S7825C29__8S7825C28[] = {
  ABISELECT(-416,-240),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C22D1Ev,_ZThn8_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C22D0Ev,_ZThn8_N8S7825C22D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
extern void ABISELECT(_ZTv0_n48_N8S7825C29D1Ev,_ZTv0_n24_N8S7825C29D1Ev)();
extern void ABISELECT(_ZThn112_N8S7825C29D1Ev,_ZThn56_N8S7825C29D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7825C29D0Ev,_ZTv0_n24_N8S7825C29D0Ev)();
extern void ABISELECT(_ZThn112_N8S7825C29D0Ev,_ZThn56_N8S7825C29D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C12__8S7825C29__8S7825C28[] = {
  ABISELECT(-112,-56),
  ABISELECT(56,28),
  ABISELECT(32,16),
  ABISELECT(-512,-288),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI8S7825C29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C29D1Ev,_ZTv0_n24_N8S7825C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C29D0Ev,_ZTv0_n24_N8S7825C29D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C29D1Ev,_ZTv0_n12_N8S7825C29D1Ev)();
extern void ABISELECT(_ZThn144_N8S7825C29D1Ev,_ZThn72_N8S7825C29D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C29D0Ev,_ZTv0_n12_N8S7825C29D0Ev)();
extern void ABISELECT(_ZThn144_N8S7825C29D0Ev,_ZThn72_N8S7825C29D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7825C5__A1__8S7825C29__8S7825C28[] = {
  ABISELECT(-144,-72),
  ABISELECT(-144,-72),
  (VTBL_ENTRY)&(_ZTI8S7825C29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C29D1Ev,_ZTv0_n12_N8S7825C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C29D0Ev,_ZTv0_n12_N8S7825C29D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C29D1Ev,_ZTv0_n12_N8S7825C29D1Ev)();
extern void ABISELECT(_ZThn168_N8S7825C29D1Ev,_ZThn84_N8S7825C29D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C29D0Ev,_ZTv0_n12_N8S7825C29D0Ev)();
extern void ABISELECT(_ZThn168_N8S7825C29D0Ev,_ZThn84_N8S7825C29D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C14__8S7825C29__8S7825C28[] = {
  ABISELECT(-168,-84),
  ABISELECT(-168,-84),
  (VTBL_ENTRY)&(_ZTI8S7825C29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C29D1Ev,_ZTv0_n12_N8S7825C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C29D0Ev,_ZTv0_n12_N8S7825C29D0Ev),
};
extern void ABISELECT(_ZThn16_N8S7825C29D1Ev,_ZThn8_N8S7825C29D1Ev)();
extern void ABISELECT(_ZThn16_N8S7825C29D0Ev,_ZThn8_N8S7825C29D0Ev)();
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C158S7825C22__8S7825C29__8S7825C28[] = {
  ABISELECT(-416,-240),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S7825C29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C29D1Ev,_ZThn8_N8S7825C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C29D0Ev,_ZThn8_N8S7825C29D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
extern void _ZN8S7825C12D1Ev();
extern void _ZN8S7825C12D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C12__8S7825C28[] = {
  ABISELECT(56,28),
  ABISELECT(32,16),
  ABISELECT(-512,-288),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&_ZN8S7825C12D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C12D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZThn32_N8S7825C12D1Ev,_ZThn16_N8S7825C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
extern void ABISELECT(_ZThn32_N8S7825C12D0Ev,_ZThn16_N8S7825C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7825C5__A1__8S7825C12__8S7825C28[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZThn56_N8S7825C12D1Ev,_ZThn28_N8S7825C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
extern void ABISELECT(_ZThn56_N8S7825C12D0Ev,_ZThn28_N8S7825C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C14__8S7825C12__8S7825C28[] = {
  ABISELECT(-56,-28),
  ABISELECT(-56,-28),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
};
static  VTT_ENTRY vtt_S7825C28[] = {
  {&(_ZTV8S7825C28[8]),  8,61},
  {&(_ZTV8S7825C28[19]),  19,61},
  {&(_ZTV8S7825C28[49]),  49,61},
  {&(_ZTV8S7825C28[54]),  54,61},
  {&(_ZTV8S7825C28[59]),  59,61},
  {&(_ZTV8S7825C28[24]),  24,61},
  {&(_ZTV8S7825C28[29]),  29,61},
  {&(_ZTV8S7825C28[33]),  33,61},
  {&(_ZTV8S7825C28[37]),  37,61},
  {&(_ZTV8S7825C28[41]),  41,61},
  {&(_tg__ZTV8S7825C29__8S7825C28[7]),  7,9},
  {&(_tg__ZTV8S7825C228S7825C29__8S7825C28[7]),  7,9},
  {&(_tg__ZTV8S7825C158S7825C228S7825C29__8S7825C28[3]),  3,6},
  {&(_tg__ZTV7S7825C5__8S7825C228S7825C29__8S7825C28[3]),  3,5},
  {&(_tg__ZTV8S7825C12__8S7825C228S7825C29__8S7825C28[6]),  6,8},
  {&(_tg__ZTV8S7825C14__8S7825C228S7825C29__8S7825C28[3]),  3,5},
  {&(_tg__ZTV8S7825C15__8S7825C228S7825C29__8S7825C28[3]),  3,6},
  {&(_tg__ZTV8S7825C12__8S7825C29__8S7825C28[6]),  6,8},
  {&(_tg__ZTV7S7825C5__A1__8S7825C29__8S7825C28[3]),  3,5},
  {&(_tg__ZTV8S7825C14__8S7825C29__8S7825C28[3]),  3,5},
  {&(_tg__ZTV8S7825C158S7825C22__8S7825C29__8S7825C28[3]),  3,6},
  {&(_tg__ZTV8S7825C12__8S7825C28[5]),  5,7},
  {&(_tg__ZTV7S7825C5__A1__8S7825C12__8S7825C28[3]),  3,5},
  {&(_tg__ZTV8S7825C14__8S7825C12__8S7825C28[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S7825C28[];
extern  VTBL_ENTRY _ZTV8S7825C28[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C28[];
static VTBL_ENTRY alt_thunk_names15[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S7825C12D0Ev,_ZThn28_N8S7825C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C12D0Ev,_ZThn16_N8S7825C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S7825C12D1Ev,_ZThn28_N8S7825C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C12D1Ev,_ZThn16_N8S7825C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C29D0Ev,_ZTv0_n12_N8S7825C29D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn168_N8S7825C29D0Ev,_ZThn84_N8S7825C29D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn144_N8S7825C29D0Ev,_ZThn72_N8S7825C29D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C29D1Ev,_ZTv0_n12_N8S7825C29D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn168_N8S7825C29D1Ev,_ZThn84_N8S7825C29D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn144_N8S7825C29D1Ev,_ZThn72_N8S7825C29D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C29D0Ev,_ZTv0_n24_N8S7825C29D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N8S7825C29D0Ev,_ZThn56_N8S7825C29D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C29D1Ev,_ZTv0_n24_N8S7825C29D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N8S7825C29D1Ev,_ZThn56_N8S7825C29D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C22D0Ev,_ZTv0_n24_N8S7825C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N8S7825C22D0Ev,_ZThn56_N8S7825C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C22D1Ev,_ZTv0_n24_N8S7825C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N8S7825C22D1Ev,_ZThn56_N8S7825C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn168_N8S7825C22D0Ev,_ZThn84_N8S7825C22D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn144_N8S7825C22D0Ev,_ZThn72_N8S7825C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn168_N8S7825C22D1Ev,_ZThn84_N8S7825C22D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn144_N8S7825C22D1Ev,_ZThn72_N8S7825C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C28D0Ev,_ZTv0_n12_N8S7825C28D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn568_N8S7825C28D0Ev,_ZThn316_N8S7825C28D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn544_N8S7825C28D0Ev,_ZThn304_N8S7825C28D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C28D1Ev,_ZTv0_n12_N8S7825C28D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn568_N8S7825C28D1Ev,_ZThn316_N8S7825C28D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn544_N8S7825C28D1Ev,_ZThn304_N8S7825C28D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C28D0Ev,_ZTv0_n24_N8S7825C28D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn512_N8S7825C28D0Ev,_ZThn288_N8S7825C28D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C28D1Ev,_ZTv0_n24_N8S7825C28D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn512_N8S7825C28D1Ev,_ZThn288_N8S7825C28D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S7825C28D0Ev,_ZTv0_n32_N8S7825C28D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn400_N8S7825C28D0Ev,_ZThn232_N8S7825C28D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S7825C28D1Ev,_ZTv0_n32_N8S7825C28D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn400_N8S7825C28D1Ev,_ZThn232_N8S7825C28D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7825C28 = {  "S7825C28", // class name
  bases_S7825C28, 36,
  &(vtc_S7825C28[0]), // expected_vtbl_contents
  &(vtt_S7825C28[0]), // expected_vtt_contents
  ABISELECT(584,324), // object size
  NSPAIRA(_ZTI8S7825C28),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S7825C28),61, //virtual function table var
  8, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7825C28),24, //virtual table table var
  21, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names15,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C2  : virtual S7825C3 , virtual S249C31_nt , S7825C28 {
  long double s7825c2f0;
  ~S7825C2(); // tgen
  S7825C2(); // tgen
};
//SIG(-1 S7825C2) C1{ VBC2{ VBC3{ VBC4{ BC5{ m} BC6{ m} BC7{ vd m Fc} vd Fp} BC8{ m} vd FC9{ VBC10{ BC11{ VBC6 BC12{ BC5 BC4 vd Fi} VBC4 VBC13{ BC7 BC6} vd} BC12 VBC5 BC14{ BC6 BC13 BC7 BC4 VBC5 vd v2} vd} VBC15{ BC4 vd} VBC16{ BC7 VBC17{ vd m FC18{ VBC19{ VBC5 VBC14 VBC6 BC13 VBC12 vd} FL}} BC20{ m} vd FL} VBC21{ VBC4 VBC11 BC22{ vd m Fp} BC14 BC13 vd} BC5 FL:64} Fi[7]} VBC23{ BC24{ VBC7 BC13 VBC5 vd} BC22 VBC4 v1} VBC25{ BC22 Fc:7 Fp} VBC11 BC5 vd Fp} VBC26{ m} BC27{ VBC28{ VBC6 VBC11 BC21 BC4} vd FC29{ VBC6 VBC30{ VBC12 VBC20 VBC6 BC22 Fi FC4[10]} VBC31{ m FC4} BC32{ BC33{ VBC31 VBC6}} vd v3 FL[8]}} FD}


S7825C2 ::~S7825C2(){ note_dtor("S7825C2", this);} // tgen
S7825C2 ::S7825C2(){ note_ctor("S7825C2", this);} // tgen

static void Test_S7825C2()
{
  extern Class_Descriptor cd_S7825C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(77,167)];
    init_test(&cd_S7825C2, buf);
    S7825C2 *dp, &lv = *(dp=new (buf) S7825C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1216,664), "sizeof(S7825C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7825C2)");
    /*is_ambiguous_... S7825C2::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*), ABISELECT(944,532), "S7825C2");
    /*is_ambiguous_... S7825C2::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*), ABISELECT(944,532), "S7825C2");
    /*is_ambiguous_... S7825C2::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*), ABISELECT(944,532), "S7825C2");
    check_base_class_offset(lv, (S7825C5*)(S7825C4*), ABISELECT(944,532), "S7825C2");
    check_base_class_offset(lv, (S7825C5*)(S7825C24*), ABISELECT(944,532), "S7825C2");
    /*is_ambiguous_... S7825C12::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C12*), ABISELECT(944,532), "S7825C2");
    /*is_ambiguous_... S7825C22::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C22*)(S7825C29*), ABISELECT(944,532), "S7825C2");
    check_base_class_offset(lv, (S2407C23*)(S7825C4*), ABISELECT(432,252), "S7825C2");
    check_base_class_offset(lv, (S7825C4*)(S7825C3*), ABISELECT(432,252), "S7825C2");
    /*is_ambiguous_... S7825C25::S7825C8_nt */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C25*)(S7825C24*), ABISELECT(1000,560), "S7825C2");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C25*)(S7825C24*), ABISELECT(968,544), "S7825C2");
    check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C25*)(S7825C24*), ABISELECT(968,544), "S7825C2");
    check_base_class_offset(lv, (S7825C14*)(S7825C25*)(S7825C24*), ABISELECT(968,544), "S7825C2");
    check_base_class_offset(lv, (S2407C30*)(S7825C25*)(S7825C24*), 0, "S7825C2");
    /*is_ambiguous_... S7825C15::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C15*)(S7825C22*)(S7825C29*), 0, "S7825C2");
    check_base_class_offset(lv, (S7825C25*)(S7825C24*), ABISELECT(968,544), "S7825C2");
    check_base_class_offset(lv, (S7825C23_nt*)(S7825C24*), ABISELECT(984,552), "S7825C2");
    check_base_class_offset(lv, (S7825C24*)(S7825C3*), ABISELECT(968,544), "S7825C2");
    check_base_class_offset(lv, (S7825C23_nt*)(S7825C26*), ABISELECT(1016,568), "S7825C2");
    check_base_class_offset(lv, (S7825C26*)(S7825C3*), ABISELECT(1016,568), "S7825C2");
    /*is_ambiguous_... S7825C12::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C12*), 0, "S7825C2");
    /*is_ambiguous_... S7825C29::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C29*), 0, "S7825C2");
    /*is_ambiguous_... S7825C13::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C13*)(S7825C12*), ABISELECT(1072,596), "S7825C2");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(1048,584), "S7825C2");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(1048,584), "S7825C2");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(1048,584), "S7825C2");
    check_base_class_offset(lv, (S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(1048,584), "S7825C2");
    check_base_class_offset(lv, (S7825C13*)(S7825C12*), ABISELECT(1048,584), "S7825C2");
    /*is_ambiguous_... S7825C2::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*), ABISELECT(1080,600), "S7825C2");
    /*is_ambiguous_... S7825C2::S7825C14 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C14*), ABISELECT(1080,600), "S7825C2");
    check_base_class_offset(lv, (S7825C14*)(S7825C12*), ABISELECT(1080,600), "S7825C2");
    check_base_class_offset(lv, (S7825C12*)(S7825C3*), ABISELECT(1048,584), "S7825C2");
    check_base_class_offset(lv, (S7825C12*)(S7825C29*), ABISELECT(1048,584), "S7825C2");
    check_base_class_offset(lv, (S7825C12*)(S7825C22*)(S7825C29*), ABISELECT(1048,584), "S7825C2");
    /*is_ambiguous_... S7825C3::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C3*), ABISELECT(416,244), "S7825C2");
    check_base_class_offset(lv, (S7825C3*), ABISELECT(416,244), "S7825C2");
    check_base_class_offset(lv, (S249C31_nt*), 0, "S7825C2");
    check_base_class_offset(lv, (S7825C23_nt*)(S7825C22*)(S7825C29*), ABISELECT(1096,608), "S7825C2");
    /*is_ambiguous_... S7825C15::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C15*)(S7825C22*)(S7825C29*), ABISELECT(1121,621), "S7825C2");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C15*)(S7825C22*)(S7825C29*), ABISELECT(1112,616), "S7825C2");
    check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C15*)(S7825C22*)(S7825C29*), ABISELECT(1112,616), "S7825C2");
    check_base_class_offset(lv, (S7825C14*)(S7825C15*)(S7825C22*)(S7825C29*), ABISELECT(1112,616), "S7825C2");
    /*is_ambiguous_... S7825C15::S7825C8_nt */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C15*)(S7825C22*)(S7825C29*), ABISELECT(1128,624), "S7825C2");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C15*)(S7825C22*)(S7825C29*), ABISELECT(1144,632), "S7825C2");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C15*)(S7825C22*)(S7825C29*), ABISELECT(1144,632), "S7825C2");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C15*)(S7825C22*)(S7825C29*), ABISELECT(1144,632), "S7825C2");
    check_base_class_offset(lv, (S7825C5*)(S7825C15*)(S7825C22*)(S7825C29*), ABISELECT(1144,632), "S7825C2");
    check_base_class_offset(lv, (S7825C15*)(S7825C22*)(S7825C29*), ABISELECT(1112,616), "S7825C2");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C22*)(S7825C29*), ABISELECT(1168,644), "S7825C2");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C22*)(S7825C29*), ABISELECT(1168,644), "S7825C2");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C14*)(S7825C22*)(S7825C29*), ABISELECT(1168,644), "S7825C2");
    check_base_class_offset(lv, (S7825C22*)(S7825C29*), ABISELECT(1096,608), "S7825C2");
    /*is_ambiguous_... S7825C29::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C29*), ABISELECT(1184,652), "S7825C2");
    /*is_ambiguous_... S7825C29::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C29*), ABISELECT(1184,652), "S7825C2");
    /*is_ambiguous_... S7825C29::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C29*), ABISELECT(1184,652), "S7825C2");
    /*is_ambiguous_... S7825C29::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C29*), ABISELECT(1184,652), "S7825C2");
    check_base_class_offset(lv, (S7825C29*)(S7825C28*), ABISELECT(1096,608), "S7825C2");
    check_base_class_offset(lv, (S7825C28*), 0, "S7825C2");
    check_field_offset(lv, s7825c2f0, ABISELECT(400,232), "S7825C2.s7825c2f0");
    test_class_info(&lv, &cd_S7825C2);
    dp->~S7825C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7825C2(Test_S7825C2, "S7825C2", ABISELECT(1216,664));

#else // __cplusplus

extern void _ZN7S7825C2C1Ev();
extern void _ZN7S7825C2D1Ev();
Name_Map name_map_S7825C2[] = {
  NSPAIR(_ZN7S7825C2C1Ev),
  NSPAIR(_ZN7S7825C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S2407C23;
extern VTBL_ENTRY _ZTI8S2407C23[];
extern Class_Descriptor cd_S7825C4;
extern VTBL_ENTRY _ZTI7S7825C4[];
extern  VTBL_ENTRY _ZTV7S7825C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7825C4[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S7825C25;
extern VTBL_ENTRY _ZTI8S7825C25[];
extern  VTBL_ENTRY _ZTV8S7825C25[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C25[];
extern Class_Descriptor cd_S7825C23_nt;
extern VTBL_ENTRY _ZTI11S7825C23_nt[];
extern  VTBL_ENTRY _ZTV11S7825C23_nt[];
extern Class_Descriptor cd_S7825C24;
extern VTBL_ENTRY _ZTI8S7825C24[];
extern  VTBL_ENTRY _ZTV8S7825C24[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C24[];
extern Class_Descriptor cd_S7825C23_nt;
extern VTBL_ENTRY _ZTI11S7825C23_nt[];
extern  VTBL_ENTRY _ZTV11S7825C23_nt[];
extern Class_Descriptor cd_S7825C26;
extern VTBL_ENTRY _ZTI8S7825C26[];
extern  VTBL_ENTRY _ZTV8S7825C26[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C13;
extern VTBL_ENTRY _ZTI8S7825C13[];
extern  VTBL_ENTRY _ZTV8S7825C13[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C12;
extern VTBL_ENTRY _ZTI8S7825C12[];
extern  VTBL_ENTRY _ZTV8S7825C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C12[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S7825C3;
extern VTBL_ENTRY _ZTI7S7825C3[];
extern  VTBL_ENTRY _ZTV7S7825C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7825C3[];
extern Class_Descriptor cd_S249C31_nt;
extern VTBL_ENTRY _ZTI10S249C31_nt[];
extern Class_Descriptor cd_S7825C23_nt;
extern VTBL_ENTRY _ZTI11S7825C23_nt[];
extern  VTBL_ENTRY _ZTV11S7825C23_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C15;
extern VTBL_ENTRY _ZTI8S7825C15[];
extern  VTBL_ENTRY _ZTV8S7825C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C15[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C22;
extern VTBL_ENTRY _ZTI8S7825C22[];
extern  VTBL_ENTRY _ZTV8S7825C22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C22[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C29;
extern VTBL_ENTRY _ZTI8S7825C29[];
extern  VTBL_ENTRY _ZTV8S7825C29[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C29[];
extern Class_Descriptor cd_S7825C28;
extern VTBL_ENTRY _ZTI8S7825C28[];
extern  VTBL_ENTRY _ZTV8S7825C28[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C28[];
static Base_Class bases_S7825C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2407C30,    ABISELECT(944,532), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(944,532), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(944,532), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(944,532), //bcp->offset
    36, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S2407C23,    ABISELECT(432,252), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7825C4,    ABISELECT(432,252), //bcp->offset
    30, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    36, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    28, //immediately_derived
  0, 1},
  {&cd_S7825C8_nt,    ABISELECT(1000,560), //bcp->offset
    55, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S7825C8_nt,    ABISELECT(968,544), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(968,544), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(968,544), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S2407C30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S7825C25,    ABISELECT(968,544), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    39, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S7825C23_nt,    ABISELECT(984,552), //bcp->offset
    51, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S7825C24,    ABISELECT(968,544), //bcp->offset
    41, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    38, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    28, //immediately_derived
  0, 1},
  {&cd_S7825C23_nt,    ABISELECT(1016,568), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S7825C26,    ABISELECT(1016,568), //bcp->offset
    60, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    28, //immediately_derived
  0, 1},
  {&cd_S2407C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    26, //immediately_derived
  0, 1},
  {&cd_S2407C30,    ABISELECT(1072,596), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(1048,584), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(1048,584), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(1048,584), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(1048,584), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S7825C13,    ABISELECT(1048,584), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(1080,600), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(1080,600), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(1080,600), //bcp->offset
    73, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    26, //immediately_derived
  0, 1},
  {&cd_S7825C12,    ABISELECT(1048,584), //bcp->offset
    65, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    43, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    28, //immediately_derived
  0, 1},
  {&cd_S2407C30,    ABISELECT(416,244), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S7825C3,    ABISELECT(416,244), //bcp->offset
    16, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    27, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S249C31_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7825C23_nt,    ABISELECT(1096,608), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(1121,621), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    40, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(1112,616), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(1112,616), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(1112,616), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    40, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(1128,624), //bcp->offset
    95, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    40, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(1144,632), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(1144,632), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(1144,632), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(1144,632), //bcp->offset
    99, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    40, //immediately_derived
  0, 0},
  {&cd_S7825C15,    ABISELECT(1112,616), //bcp->offset
    89, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    48, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(1168,644), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(1168,644), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(1168,644), //bcp->offset
    103, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S7825C22,    ABISELECT(1096,608), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    47, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    49, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(1184,652), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    48, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(1184,652), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    48, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(1184,652), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    48, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(1184,652), //bcp->offset
    107, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    49, //immediately_derived
  0, 0},
  {&cd_S7825C29,    ABISELECT(1096,608), //bcp->offset
    78, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    46, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    50, //immediately_derived
  0, 1},
  {&cd_S7825C28,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S7825C2[];
extern void _ZN7S7825C2D1Ev();
extern void _ZN7S7825C2D0Ev();
extern void ABISELECT(_ZTv0_n96_N7S7825C2D1Ev,_ZTv0_n48_N7S7825C2D1Ev)();
extern void ABISELECT(_ZThn416_N7S7825C2D1Ev,_ZThn244_N7S7825C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N7S7825C2D0Ev,_ZTv0_n48_N7S7825C2D0Ev)();
extern void ABISELECT(_ZThn416_N7S7825C2D0Ev,_ZThn244_N7S7825C2D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S7825C2D1Ev,_ZTv0_n16_N7S7825C2D1Ev)();
extern void ABISELECT(_ZThn432_N7S7825C2D1Ev,_ZThn252_N7S7825C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S7825C2D0Ev,_ZTv0_n16_N7S7825C2D0Ev)();
extern void ABISELECT(_ZThn432_N7S7825C2D0Ev,_ZThn252_N7S7825C2D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7825C2D1Ev,_ZTv0_n12_N7S7825C2D1Ev)();
extern void ABISELECT(_ZThn944_N7S7825C2D1Ev,_ZThn532_N7S7825C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7825C2D0Ev,_ZTv0_n12_N7S7825C2D0Ev)();
extern void ABISELECT(_ZThn944_N7S7825C2D0Ev,_ZThn532_N7S7825C2D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7S7825C2D1Ev,_ZTv0_n24_N7S7825C2D1Ev)();
extern void ABISELECT(_ZThn968_N7S7825C2D1Ev,_ZThn544_N7S7825C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7S7825C2D0Ev,_ZTv0_n24_N7S7825C2D0Ev)();
extern void ABISELECT(_ZThn968_N7S7825C2D0Ev,_ZThn544_N7S7825C2D0Ev)() __attribute__((weak));
extern void _ZN8S7825C242v1Ev();
extern void ABISELECT(_ZTvn16_n48_N7S7825C2D1Ev,_ZTvn8_n24_N7S7825C2D1Ev)();
extern void ABISELECT(_ZTvn16_n48_N7S7825C2D0Ev,_ZTvn8_n24_N7S7825C2D0Ev)();
extern void ABISELECT(_ZTv0_n24_N7S7825C2D1Ev,_ZTv0_n12_N7S7825C2D1Ev)();
extern void ABISELECT(_ZThn1000_N7S7825C2D1Ev,_ZThn560_N7S7825C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7825C2D0Ev,_ZTv0_n12_N7S7825C2D0Ev)();
extern void ABISELECT(_ZThn1000_N7S7825C2D0Ev,_ZThn560_N7S7825C2D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7825C2D1Ev,_ZTv0_n12_N7S7825C2D1Ev)();
extern void ABISELECT(_ZThn1016_N7S7825C2D1Ev,_ZThn568_N7S7825C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7825C2D0Ev,_ZTv0_n12_N7S7825C2D0Ev)();
extern void ABISELECT(_ZThn1016_N7S7825C2D0Ev,_ZThn568_N7S7825C2D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7S7825C2D1Ev,_ZTv0_n24_N7S7825C2D1Ev)();
extern void ABISELECT(_ZThn1048_N7S7825C2D1Ev,_ZThn584_N7S7825C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7S7825C2D0Ev,_ZTv0_n24_N7S7825C2D0Ev)();
extern void ABISELECT(_ZThn1048_N7S7825C2D0Ev,_ZThn584_N7S7825C2D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7825C2D1Ev,_ZTv0_n12_N7S7825C2D1Ev)();
extern void ABISELECT(_ZThn1080_N7S7825C2D1Ev,_ZThn600_N7S7825C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7825C2D0Ev,_ZTv0_n12_N7S7825C2D0Ev)();
extern void ABISELECT(_ZThn1080_N7S7825C2D0Ev,_ZThn600_N7S7825C2D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S7825C2D1Ev,_ZTv0_n32_N7S7825C2D1Ev)();
extern void ABISELECT(_ZThn1096_N7S7825C2D1Ev,_ZThn608_N7S7825C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S7825C2D0Ev,_ZTv0_n32_N7S7825C2D0Ev)();
extern void ABISELECT(_ZThn1096_N7S7825C2D0Ev,_ZThn608_N7S7825C2D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n64_N7S7825C2D1Ev,_ZTvn8_n32_N7S7825C2D1Ev)();
extern void ABISELECT(_ZTvn16_n64_N7S7825C2D0Ev,_ZTvn8_n32_N7S7825C2D0Ev)();
extern void _ZN8S7825C152v2Ev();
extern void ABISELECT(_ZTvn32_n64_N7S7825C2D1Ev,_ZTvn16_n32_N7S7825C2D1Ev)();
extern void ABISELECT(_ZTvn32_n64_N7S7825C2D0Ev,_ZTvn16_n32_N7S7825C2D0Ev)();
extern void ABISELECT(_ZTvn48_n64_N7S7825C2D1Ev,_ZTvn24_n32_N7S7825C2D1Ev)();
extern void ABISELECT(_ZTvn48_n64_N7S7825C2D0Ev,_ZTvn24_n32_N7S7825C2D0Ev)();
extern void ABISELECT(_ZTvn72_n64_N7S7825C2D1Ev,_ZTvn36_n32_N7S7825C2D1Ev)();
extern void ABISELECT(_ZTvn72_n64_N7S7825C2D0Ev,_ZTvn36_n32_N7S7825C2D0Ev)();
extern void ABISELECT(_ZTvn88_n64_N7S7825C2D1Ev,_ZTvn44_n32_N7S7825C2D1Ev)();
extern void ABISELECT(_ZTvn88_n64_N7S7825C2D0Ev,_ZTvn44_n32_N7S7825C2D0Ev)();
static  VTBL_ENTRY vtc_S7825C2[] = {
  0,
  ABISELECT(1016,568),
  ABISELECT(1000,560),
  ABISELECT(968,544),
  ABISELECT(432,252),
  ABISELECT(416,244),
  0,
  ABISELECT(1080,600),
  ABISELECT(944,532),
  ABISELECT(1048,584),
  0,
  ABISELECT(1096,608),
  0,
  (VTBL_ENTRY)&(_ZTI7S7825C2[0]),
  (VTBL_ENTRY)&_ZN7S7825C2D1Ev,
  (VTBL_ENTRY)&_ZN7S7825C2D0Ev,
  ABISELECT(-416,-244),
  ABISELECT(664,356),
  ABISELECT(-416,-244),
  ABISELECT(632,340),
  ABISELECT(600,324),
  ABISELECT(-416,-244),
  ABISELECT(584,316),
  ABISELECT(552,300),
  ABISELECT(528,288),
  ABISELECT(16,8),
  ABISELECT(-416,-244),
  (VTBL_ENTRY)&(_ZTI7S7825C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N7S7825C2D1Ev,_ZTv0_n48_N7S7825C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N7S7825C2D0Ev,_ZTv0_n48_N7S7825C2D0Ev),
  ABISELECT(-432,-252),
  ABISELECT(512,280),
  ABISELECT(-432,-252),
  (VTBL_ENTRY)&(_ZTI7S7825C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S7825C2D1Ev,_ZTv0_n16_N7S7825C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S7825C2D0Ev,_ZTv0_n16_N7S7825C2D0Ev),
  ABISELECT(-944,-532),
  ABISELECT(-944,-532),
  (VTBL_ENTRY)&(_ZTI7S7825C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7825C2D1Ev,_ZTv0_n12_N7S7825C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7825C2D0Ev,_ZTv0_n12_N7S7825C2D0Ev),
  0,
  ABISELECT(-968,-544),
  ABISELECT(-24,-12),
  ABISELECT(-968,-544),
  ABISELECT(32,16),
  ABISELECT(-968,-544),
  (VTBL_ENTRY)&(_ZTI7S7825C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S7825C2D1Ev,_ZTv0_n24_N7S7825C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S7825C2D0Ev,_ZTv0_n24_N7S7825C2D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C242v1Ev,
  ABISELECT(-984,-552),
  (VTBL_ENTRY)&(_ZTI7S7825C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n48_N7S7825C2D1Ev,_ZTvn8_n24_N7S7825C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n48_N7S7825C2D0Ev,_ZTvn8_n24_N7S7825C2D0Ev),
  ABISELECT(-1000,-560),
  ABISELECT(-1000,-560),
  (VTBL_ENTRY)&(_ZTI7S7825C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7825C2D1Ev,_ZTv0_n12_N7S7825C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7825C2D0Ev,_ZTv0_n12_N7S7825C2D0Ev),
  ABISELECT(-1016,-568),
  ABISELECT(-1016,-568),
  (VTBL_ENTRY)&(_ZTI7S7825C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7825C2D1Ev,_ZTv0_n12_N7S7825C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7825C2D0Ev,_ZTv0_n12_N7S7825C2D0Ev),
  ABISELECT(-1048,-584),
  ABISELECT(32,16),
  ABISELECT(-104,-52),
  ABISELECT(-1048,-584),
  ABISELECT(-1048,-584),
  (VTBL_ENTRY)&(_ZTI7S7825C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S7825C2D1Ev,_ZTv0_n24_N7S7825C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S7825C2D0Ev,_ZTv0_n24_N7S7825C2D0Ev),
  ABISELECT(-1080,-600),
  ABISELECT(-1080,-600),
  (VTBL_ENTRY)&(_ZTI7S7825C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7825C2D1Ev,_ZTv0_n12_N7S7825C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7825C2D0Ev,_ZTv0_n12_N7S7825C2D0Ev),
  ABISELECT(16,8),
  ABISELECT(-1096,-608),
  ABISELECT(-1096,-608),
  ABISELECT(-16,-8),
  ABISELECT(-1096,-608),
  ABISELECT(-48,-24),
  ABISELECT(-152,-76),
  ABISELECT(-1096,-608),
  (VTBL_ENTRY)&(_ZTI7S7825C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S7825C2D1Ev,_ZTv0_n32_N7S7825C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S7825C2D0Ev,_ZTv0_n32_N7S7825C2D0Ev),
  ABISELECT(-1112,-616),
  ABISELECT(-1112,-616),
  (VTBL_ENTRY)&(_ZTI7S7825C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n64_N7S7825C2D1Ev,_ZTvn8_n32_N7S7825C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n64_N7S7825C2D0Ev,_ZTvn8_n32_N7S7825C2D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
  ABISELECT(-1128,-624),
  (VTBL_ENTRY)&(_ZTI7S7825C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n64_N7S7825C2D1Ev,_ZTvn16_n32_N7S7825C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n64_N7S7825C2D0Ev,_ZTvn16_n32_N7S7825C2D0Ev),
  ABISELECT(-1144,-632),
  (VTBL_ENTRY)&(_ZTI7S7825C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn48_n64_N7S7825C2D1Ev,_ZTvn24_n32_N7S7825C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn48_n64_N7S7825C2D0Ev,_ZTvn24_n32_N7S7825C2D0Ev),
  ABISELECT(-1168,-644),
  (VTBL_ENTRY)&(_ZTI7S7825C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn72_n64_N7S7825C2D1Ev,_ZTvn36_n32_N7S7825C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn72_n64_N7S7825C2D0Ev,_ZTvn36_n32_N7S7825C2D0Ev),
  ABISELECT(-1184,-652),
  (VTBL_ENTRY)&(_ZTI7S7825C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn88_n64_N7S7825C2D1Ev,_ZTvn44_n32_N7S7825C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn88_n64_N7S7825C2D0Ev,_ZTvn44_n32_N7S7825C2D0Ev),
};
extern VTBL_ENTRY _ZTV7S7825C2[];
extern void _ZN8S7825C28D1Ev();
extern void _ZN8S7825C28D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C28__7S7825C2[] = {
  0,
  ABISELECT(1080,600),
  ABISELECT(944,532),
  ABISELECT(1048,584),
  0,
  ABISELECT(1096,608),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C28[0]),
  (VTBL_ENTRY)&_ZN8S7825C28D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C28D0Ev,
};
extern void ABISELECT(_ZTv0_n64_N8S7825C28D1Ev,_ZTv0_n32_N8S7825C28D1Ev)();
extern void ABISELECT(_ZThn1096_N8S7825C28D1Ev,_ZThn608_N8S7825C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S7825C28D0Ev,_ZTv0_n32_N8S7825C28D0Ev)();
extern void ABISELECT(_ZThn1096_N8S7825C28D0Ev,_ZThn608_N8S7825C28D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C29__8S7825C28__7S7825C2[] = {
  ABISELECT(16,8),
  ABISELECT(-1096,-608),
  ABISELECT(-1096,-608),
  ABISELECT(-16,-8),
  ABISELECT(-1096,-608),
  ABISELECT(-48,-24),
  ABISELECT(-152,-76),
  ABISELECT(-1096,-608),
  (VTBL_ENTRY)&(_ZTI8S7825C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7825C28D1Ev,_ZTv0_n32_N8S7825C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7825C28D0Ev,_ZTv0_n32_N8S7825C28D0Ev),
};
extern void ABISELECT(_ZTv0_n48_N8S7825C28D1Ev,_ZTv0_n24_N8S7825C28D1Ev)();
extern void ABISELECT(_ZThn1048_N8S7825C28D1Ev,_ZThn584_N8S7825C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7825C28D0Ev,_ZTv0_n24_N8S7825C28D0Ev)();
extern void ABISELECT(_ZThn1048_N8S7825C28D0Ev,_ZThn584_N8S7825C28D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C12__8S7825C28__7S7825C2[] = {
  ABISELECT(-1048,-584),
  ABISELECT(32,16),
  ABISELECT(-104,-52),
  ABISELECT(-1048,-584),
  ABISELECT(-1048,-584),
  (VTBL_ENTRY)&(_ZTI8S7825C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C28D1Ev,_ZTv0_n24_N8S7825C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C28D0Ev,_ZTv0_n24_N8S7825C28D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C28D1Ev,_ZTv0_n12_N8S7825C28D1Ev)();
extern void ABISELECT(_ZThn944_N8S7825C28D1Ev,_ZThn532_N8S7825C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C28D0Ev,_ZTv0_n12_N8S7825C28D0Ev)();
extern void ABISELECT(_ZThn944_N8S7825C28D0Ev,_ZThn532_N8S7825C28D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7825C5__A1__8S7825C28__7S7825C2[] = {
  ABISELECT(-944,-532),
  ABISELECT(-944,-532),
  (VTBL_ENTRY)&(_ZTI8S7825C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C28D1Ev,_ZTv0_n12_N8S7825C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C28D0Ev,_ZTv0_n12_N8S7825C28D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C28D1Ev,_ZTv0_n12_N8S7825C28D1Ev)();
extern void ABISELECT(_ZThn1080_N8S7825C28D1Ev,_ZThn600_N8S7825C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C28D0Ev,_ZTv0_n12_N8S7825C28D0Ev)();
extern void ABISELECT(_ZThn1080_N8S7825C28D0Ev,_ZThn600_N8S7825C28D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C14__8S7825C28__7S7825C2[] = {
  ABISELECT(-1080,-600),
  ABISELECT(-1080,-600),
  (VTBL_ENTRY)&(_ZTI8S7825C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C28D1Ev,_ZTv0_n12_N8S7825C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C28D0Ev,_ZTv0_n12_N8S7825C28D0Ev),
};
extern void ABISELECT(_ZTvn16_n64_N8S7825C28D1Ev,_ZTvn8_n32_N8S7825C28D1Ev)();
extern void ABISELECT(_ZTvn16_n64_N8S7825C28D0Ev,_ZTvn8_n32_N8S7825C28D0Ev)();
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C158S7825C228S7825C29__8S7825C28__7S7825C2[] = {
  ABISELECT(-1112,-616),
  ABISELECT(-1112,-616),
  (VTBL_ENTRY)&(_ZTI8S7825C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n64_N8S7825C28D1Ev,_ZTvn8_n32_N8S7825C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n64_N8S7825C28D0Ev,_ZTvn8_n32_N8S7825C28D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
extern void ABISELECT(_ZTvn32_n64_N8S7825C28D1Ev,_ZTvn16_n32_N8S7825C28D1Ev)();
extern void ABISELECT(_ZTvn32_n64_N8S7825C28D0Ev,_ZTvn16_n32_N8S7825C28D0Ev)();
static  VTBL_ENTRY _tg__ZTV10S7825C8_nt8S7825C158S7825C228S7825C29__A4__8S7825C28__7S7825C2[] = {
  ABISELECT(-1128,-624),
  (VTBL_ENTRY)&(_ZTI8S7825C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n64_N8S7825C28D1Ev,_ZTvn16_n32_N8S7825C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n64_N8S7825C28D0Ev,_ZTvn16_n32_N8S7825C28D0Ev),
};
extern void ABISELECT(_ZTvn48_n64_N8S7825C28D1Ev,_ZTvn24_n32_N8S7825C28D1Ev)();
extern void ABISELECT(_ZTvn48_n64_N8S7825C28D0Ev,_ZTvn24_n32_N8S7825C28D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S7825C58S7825C158S7825C228S7825C29__A2__8S7825C28__7S7825C2[] = {
  ABISELECT(-1144,-632),
  (VTBL_ENTRY)&(_ZTI8S7825C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn48_n64_N8S7825C28D1Ev,_ZTvn24_n32_N8S7825C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn48_n64_N8S7825C28D0Ev,_ZTvn24_n32_N8S7825C28D0Ev),
};
extern void ABISELECT(_ZTvn72_n64_N8S7825C28D1Ev,_ZTvn36_n32_N8S7825C28D1Ev)();
extern void ABISELECT(_ZTvn72_n64_N8S7825C28D0Ev,_ZTvn36_n32_N8S7825C28D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S7825C148S7825C228S7825C29__A2__8S7825C28__7S7825C2[] = {
  ABISELECT(-1168,-644),
  (VTBL_ENTRY)&(_ZTI8S7825C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn72_n64_N8S7825C28D1Ev,_ZTvn36_n32_N8S7825C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn72_n64_N8S7825C28D0Ev,_ZTvn36_n32_N8S7825C28D0Ev),
};
extern void ABISELECT(_ZTvn88_n64_N8S7825C28D1Ev,_ZTvn44_n32_N8S7825C28D1Ev)();
extern void ABISELECT(_ZTvn88_n64_N8S7825C28D0Ev,_ZTvn44_n32_N8S7825C28D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S7825C58S7825C29__A3__8S7825C28__7S7825C2[] = {
  ABISELECT(-1184,-652),
  (VTBL_ENTRY)&(_ZTI8S7825C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn88_n64_N8S7825C28D1Ev,_ZTvn44_n32_N8S7825C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn88_n64_N8S7825C28D0Ev,_ZTvn44_n32_N8S7825C28D0Ev),
};
extern void _ZN7S7825C3D1Ev();
extern void _ZN7S7825C3D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7825C3__7S7825C2[] = {
  ABISELECT(664,356),
  ABISELECT(-416,-244),
  ABISELECT(632,340),
  ABISELECT(600,324),
  ABISELECT(-416,-244),
  ABISELECT(584,316),
  ABISELECT(552,300),
  ABISELECT(528,288),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7S7825C3[0]),
  (VTBL_ENTRY)&_ZN7S7825C3D1Ev,
  (VTBL_ENTRY)&_ZN7S7825C3D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N7S7825C3D1Ev,_ZTv0_n16_N7S7825C3D1Ev)();
extern void ABISELECT(_ZThn16_N7S7825C3D1Ev,_ZThn8_N7S7825C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S7825C3D0Ev,_ZTv0_n16_N7S7825C3D0Ev)();
extern void ABISELECT(_ZThn16_N7S7825C3D0Ev,_ZThn8_N7S7825C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7825C4__7S7825C3__7S7825C2[] = {
  ABISELECT(-16,-8),
  ABISELECT(512,280),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S7825C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S7825C3D1Ev,_ZTv0_n16_N7S7825C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S7825C3D0Ev,_ZTv0_n16_N7S7825C3D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N7S7825C3D1Ev,_ZTv0_n12_N7S7825C3D1Ev)();
extern void ABISELECT(_ZThn528_N7S7825C3D1Ev,_ZThn288_N7S7825C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7825C3D0Ev,_ZTv0_n12_N7S7825C3D0Ev)();
extern void ABISELECT(_ZThn528_N7S7825C3D0Ev,_ZThn288_N7S7825C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7825C5__7S7825C3__7S7825C2[] = {
  ABISELECT(-528,-288),
  ABISELECT(-528,-288),
  (VTBL_ENTRY)&(_ZTI7S7825C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7825C3D1Ev,_ZTv0_n12_N7S7825C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7825C3D0Ev,_ZTv0_n12_N7S7825C3D0Ev),
};
extern void ABISELECT(_ZTv0_n48_N7S7825C3D1Ev,_ZTv0_n24_N7S7825C3D1Ev)();
extern void ABISELECT(_ZThn552_N7S7825C3D1Ev,_ZThn300_N7S7825C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7S7825C3D0Ev,_ZTv0_n24_N7S7825C3D0Ev)();
extern void ABISELECT(_ZThn552_N7S7825C3D0Ev,_ZThn300_N7S7825C3D0Ev)() __attribute__((weak));
extern void _ZN8S7825C242v1Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C24__7S7825C3__7S7825C2[] = {
  0,
  ABISELECT(-552,-300),
  ABISELECT(-24,-12),
  ABISELECT(-968,-544),
  ABISELECT(32,16),
  ABISELECT(-552,-300),
  (VTBL_ENTRY)&(_ZTI7S7825C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S7825C3D1Ev,_ZTv0_n24_N7S7825C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S7825C3D0Ev,_ZTv0_n24_N7S7825C3D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C242v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S7825C3D1Ev,_ZTv0_n12_N7S7825C3D1Ev)();
extern void ABISELECT(_ZThn584_N7S7825C3D1Ev,_ZThn316_N7S7825C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7825C3D0Ev,_ZTv0_n12_N7S7825C3D0Ev)();
extern void ABISELECT(_ZThn584_N7S7825C3D0Ev,_ZThn316_N7S7825C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV10S7825C8_nt__A1__7S7825C3__7S7825C2[] = {
  ABISELECT(-584,-316),
  ABISELECT(-584,-316),
  (VTBL_ENTRY)&(_ZTI7S7825C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7825C3D1Ev,_ZTv0_n12_N7S7825C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7825C3D0Ev,_ZTv0_n12_N7S7825C3D0Ev),
};
extern void ABISELECT(_ZTvn16_n48_N7S7825C3D1Ev,_ZTvn8_n24_N7S7825C3D1Ev)();
extern void ABISELECT(_ZTvn16_n48_N7S7825C3D0Ev,_ZTvn8_n24_N7S7825C3D0Ev)();
static  VTBL_ENTRY _tg__ZTV11S7825C23_nt8S7825C24__7S7825C3__7S7825C2[] = {
  ABISELECT(-568,-308),
  (VTBL_ENTRY)&(_ZTI7S7825C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n48_N7S7825C3D1Ev,_ZTvn8_n24_N7S7825C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n48_N7S7825C3D0Ev,_ZTvn8_n24_N7S7825C3D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N7S7825C3D1Ev,_ZTv0_n12_N7S7825C3D1Ev)();
extern void ABISELECT(_ZThn600_N7S7825C3D1Ev,_ZThn324_N7S7825C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7825C3D0Ev,_ZTv0_n12_N7S7825C3D0Ev)();
extern void ABISELECT(_ZThn600_N7S7825C3D0Ev,_ZThn324_N7S7825C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C26__7S7825C3__7S7825C2[] = {
  ABISELECT(-600,-324),
  ABISELECT(-600,-324),
  (VTBL_ENTRY)&(_ZTI7S7825C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7825C3D1Ev,_ZTv0_n12_N7S7825C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7825C3D0Ev,_ZTv0_n12_N7S7825C3D0Ev),
};
extern void ABISELECT(_ZTv0_n48_N7S7825C3D1Ev,_ZTv0_n24_N7S7825C3D1Ev)();
extern void ABISELECT(_ZThn632_N7S7825C3D1Ev,_ZThn340_N7S7825C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7S7825C3D0Ev,_ZTv0_n24_N7S7825C3D0Ev)();
extern void ABISELECT(_ZThn632_N7S7825C3D0Ev,_ZThn340_N7S7825C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C12__7S7825C3__7S7825C2[] = {
  ABISELECT(-632,-340),
  ABISELECT(32,16),
  ABISELECT(-104,-52),
  ABISELECT(-1048,-584),
  ABISELECT(-632,-340),
  (VTBL_ENTRY)&(_ZTI7S7825C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S7825C3D1Ev,_ZTv0_n24_N7S7825C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S7825C3D0Ev,_ZTv0_n24_N7S7825C3D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N7S7825C3D1Ev,_ZTv0_n12_N7S7825C3D1Ev)();
extern void ABISELECT(_ZThn664_N7S7825C3D1Ev,_ZThn356_N7S7825C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7825C3D0Ev,_ZTv0_n12_N7S7825C3D0Ev)();
extern void ABISELECT(_ZThn664_N7S7825C3D0Ev,_ZThn356_N7S7825C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C14__A1__7S7825C3__7S7825C2[] = {
  ABISELECT(-664,-356),
  ABISELECT(-664,-356),
  (VTBL_ENTRY)&(_ZTI7S7825C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7825C3D1Ev,_ZTv0_n12_N7S7825C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7825C3D0Ev,_ZTv0_n12_N7S7825C3D0Ev),
};
extern void _ZN7S7825C4D1Ev();
extern void _ZN7S7825C4D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7825C4__7S7825C2[] = {
  ABISELECT(512,280),
  0,
  (VTBL_ENTRY)&(_ZTI7S7825C4[0]),
  (VTBL_ENTRY)&_ZN7S7825C4D1Ev,
  (VTBL_ENTRY)&_ZN7S7825C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S7825C4D1Ev,_ZTv0_n12_N7S7825C4D1Ev)();
extern void ABISELECT(_ZThn512_N7S7825C4D1Ev,_ZThn280_N7S7825C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7825C4D0Ev,_ZTv0_n12_N7S7825C4D0Ev)();
extern void ABISELECT(_ZThn512_N7S7825C4D0Ev,_ZThn280_N7S7825C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7825C5__7S7825C4__7S7825C2[] = {
  ABISELECT(-512,-280),
  ABISELECT(-512,-280),
  (VTBL_ENTRY)&(_ZTI7S7825C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7825C4D1Ev,_ZTv0_n12_N7S7825C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7825C4D0Ev,_ZTv0_n12_N7S7825C4D0Ev),
};
extern void _ZN8S7825C24D1Ev();
extern void _ZN8S7825C24D0Ev();
extern void _ZN8S7825C242v1Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C24__7S7825C2[] = {
  ABISELECT(-24,-12),
  ABISELECT(-968,-544),
  ABISELECT(32,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C24[0]),
  (VTBL_ENTRY)&_ZN8S7825C24D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C24D0Ev,
  (VTBL_ENTRY)&_ZN8S7825C242v1Ev,
};
extern void _ZN8S7825C25D1Ev();
extern void _ZN8S7825C25D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C258S7825C24__7S7825C2[] = {
  ABISELECT(-968,-544),
  ABISELECT(32,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C25[0]),
  (VTBL_ENTRY)&_ZN8S7825C25D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C25D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C25D1Ev,_ZTv0_n12_N8S7825C25D1Ev)();
extern void ABISELECT(_ZThn32_N8S7825C25D1Ev,_ZThn16_N8S7825C25D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C25D0Ev,_ZTv0_n12_N8S7825C25D0Ev)();
extern void ABISELECT(_ZThn32_N8S7825C25D0Ev,_ZThn16_N8S7825C25D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV10S7825C8_nt__8S7825C258S7825C24__7S7825C2[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S7825C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C25D1Ev,_ZTv0_n12_N8S7825C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C25D0Ev,_ZTv0_n12_N8S7825C25D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C24D1Ev,_ZTv0_n12_N8S7825C24D1Ev)();
extern void ABISELECT(_ZThn32_N8S7825C24D1Ev,_ZThn16_N8S7825C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C24D0Ev,_ZTv0_n12_N8S7825C24D0Ev)();
extern void ABISELECT(_ZThn32_N8S7825C24D0Ev,_ZThn16_N8S7825C24D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV10S7825C8_nt__8S7825C24__7S7825C2[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S7825C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C24D1Ev,_ZTv0_n12_N8S7825C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C24D0Ev,_ZTv0_n12_N8S7825C24D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C24D1Ev,_ZTv0_n12_N8S7825C24D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S7825C24D0Ev,_ZTv0_n12_N8S7825C24D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S7825C5__8S7825C24__7S7825C2[] = {
  ABISELECT(24,12),
  ABISELECT(24,12),
  (VTBL_ENTRY)&(_ZTI8S7825C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C24D1Ev,_ZTv0_n12_N8S7825C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C24D0Ev,_ZTv0_n12_N8S7825C24D0Ev),
};
extern void _ZN8S7825C12D1Ev();
extern void _ZN8S7825C12D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C12__7S7825C2[] = {
  ABISELECT(32,16),
  ABISELECT(-104,-52),
  ABISELECT(-1048,-584),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&_ZN8S7825C12D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C12D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S7825C5__A1__8S7825C12__7S7825C2[] = {
  ABISELECT(104,52),
  ABISELECT(104,52),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZThn32_N8S7825C12D1Ev,_ZThn16_N8S7825C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
extern void ABISELECT(_ZThn32_N8S7825C12D0Ev,_ZThn16_N8S7825C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C14__8S7825C12__7S7825C2[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
};
extern void _ZN8S7825C29D1Ev();
extern void _ZN8S7825C29D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C29__7S7825C2[] = {
  ABISELECT(-1096,-608),
  ABISELECT(-16,-8),
  ABISELECT(-1096,-608),
  ABISELECT(-48,-24),
  ABISELECT(-152,-76),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C29[0]),
  (VTBL_ENTRY)&_ZN8S7825C29D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C29D0Ev,
};
extern void _ZN8S7825C22D1Ev();
extern void _ZN8S7825C22D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C228S7825C29__7S7825C2[] = {
  ABISELECT(-1096,-608),
  ABISELECT(-16,-8),
  ABISELECT(-1096,-608),
  ABISELECT(-48,-24),
  ABISELECT(-152,-76),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&_ZN8S7825C22D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C22D0Ev,
};
extern void _ZN8S7825C15D1Ev();
extern void _ZN8S7825C15D0Ev();
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C158S7825C228S7825C29__7S7825C2[] = {
  ABISELECT(-1112,-616),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C15[0]),
  (VTBL_ENTRY)&_ZN8S7825C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C15D0Ev,
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S7825C5__8S7825C228S7825C29__7S7825C2[] = {
  ABISELECT(152,76),
  ABISELECT(152,76),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev),
};
extern void ABISELECT(_ZTv0_n48_N8S7825C22D1Ev,_ZTv0_n24_N8S7825C22D1Ev)();
extern void ABISELECT(_ZTv0_n48_N8S7825C22D0Ev,_ZTv0_n24_N8S7825C22D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S7825C12__8S7825C228S7825C29__7S7825C2[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(-104,-52),
  ABISELECT(-1048,-584),
  ABISELECT(48,24),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C22D1Ev,_ZTv0_n24_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C22D0Ev,_ZTv0_n24_N8S7825C22D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S7825C14__8S7825C228S7825C29__7S7825C2[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev),
};
extern void ABISELECT(_ZThn16_N8S7825C22D1Ev,_ZThn8_N8S7825C22D1Ev)();
extern void ABISELECT(_ZThn16_N8S7825C22D0Ev,_ZThn8_N8S7825C22D0Ev)();
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C15__8S7825C228S7825C29__7S7825C2[] = {
  ABISELECT(-1112,-616),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C22D1Ev,_ZThn8_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C22D0Ev,_ZThn8_N8S7825C22D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
extern void ABISELECT(_ZTv0_n48_N8S7825C29D1Ev,_ZTv0_n24_N8S7825C29D1Ev)();
extern void ABISELECT(_ZTv0_n48_N8S7825C29D0Ev,_ZTv0_n24_N8S7825C29D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S7825C12__8S7825C29__7S7825C2[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(-104,-52),
  ABISELECT(-1048,-584),
  ABISELECT(48,24),
  (VTBL_ENTRY)&(_ZTI8S7825C29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C29D1Ev,_ZTv0_n24_N8S7825C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C29D0Ev,_ZTv0_n24_N8S7825C29D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C29D1Ev,_ZTv0_n12_N8S7825C29D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S7825C29D0Ev,_ZTv0_n12_N8S7825C29D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S7825C5__A1__8S7825C29__7S7825C2[] = {
  ABISELECT(152,76),
  ABISELECT(152,76),
  (VTBL_ENTRY)&(_ZTI8S7825C29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C29D1Ev,_ZTv0_n12_N8S7825C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C29D0Ev,_ZTv0_n12_N8S7825C29D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C29D1Ev,_ZTv0_n12_N8S7825C29D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S7825C29D0Ev,_ZTv0_n12_N8S7825C29D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S7825C14__8S7825C29__7S7825C2[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI8S7825C29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C29D1Ev,_ZTv0_n12_N8S7825C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C29D0Ev,_ZTv0_n12_N8S7825C29D0Ev),
};
extern void ABISELECT(_ZThn16_N8S7825C29D1Ev,_ZThn8_N8S7825C29D1Ev)();
extern void ABISELECT(_ZThn16_N8S7825C29D0Ev,_ZThn8_N8S7825C29D0Ev)();
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C158S7825C22__8S7825C29__7S7825C2[] = {
  ABISELECT(-1112,-616),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S7825C29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C29D1Ev,_ZThn8_N8S7825C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C29D0Ev,_ZThn8_N8S7825C29D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
static  VTT_ENTRY vtt_S7825C2[] = {
  {&(_ZTV7S7825C2[14]),  14,111},
  {&(_tg__ZTV8S7825C28__7S7825C2[8]),  8,10},
  {&(_tg__ZTV8S7825C29__8S7825C28__7S7825C2[9]),  9,11},
  {&(_tg__ZTV8S7825C12__8S7825C28__7S7825C2[6]),  6,8},
  {&(_tg__ZTV7S7825C5__A1__8S7825C28__7S7825C2[3]),  3,5},
  {&(_tg__ZTV8S7825C14__8S7825C28__7S7825C2[3]),  3,5},
  {&(_tg__ZTV8S7825C158S7825C228S7825C29__8S7825C28__7S7825C2[3]),  3,6},
  {&(_tg__ZTV10S7825C8_nt8S7825C158S7825C228S7825C29__A4__8S7825C28__7S7825C2[2]),  2,4},
  {&(_tg__ZTV7S7825C58S7825C158S7825C228S7825C29__A2__8S7825C28__7S7825C2[2]),  2,4},
  {&(_tg__ZTV8S7825C148S7825C228S7825C29__A2__8S7825C28__7S7825C2[2]),  2,4},
  {&(_tg__ZTV7S7825C58S7825C29__A3__8S7825C28__7S7825C2[2]),  2,4},
  {&(_ZTV7S7825C2[28]),  28,111},
  {&(_ZTV7S7825C2[34]),  34,111},
  {&(_ZTV7S7825C2[39]),  39,111},
  {&(_ZTV7S7825C2[48]),  48,111},
  {&(_ZTV7S7825C2[58]),  58,111},
  {&(_ZTV7S7825C2[53]),  53,111},
  {&(_ZTV7S7825C2[63]),  63,111},
  {&(_ZTV7S7825C2[71]),  71,111},
  {&(_ZTV7S7825C2[76]),  76,111},
  {&(_ZTV7S7825C2[87]),  87,111},
  {&(_ZTV7S7825C2[92]),  92,111},
  {&(_ZTV7S7825C2[97]),  97,111},
  {&(_ZTV7S7825C2[101]),  101,111},
  {&(_ZTV7S7825C2[105]),  105,111},
  {&(_ZTV7S7825C2[109]),  109,111},
  {&(_tg__ZTV7S7825C3__7S7825C2[11]),  11,13},
  {&(_tg__ZTV7S7825C4__7S7825C3__7S7825C2[4]),  4,6},
  {&(_tg__ZTV7S7825C5__7S7825C3__7S7825C2[3]),  3,5},
  {&(_tg__ZTV8S7825C24__7S7825C3__7S7825C2[7]),  7,10},
  {&(_tg__ZTV10S7825C8_nt__A1__7S7825C3__7S7825C2[3]),  3,5},
  {&(_tg__ZTV11S7825C23_nt8S7825C24__7S7825C3__7S7825C2[2]),  2,4},
  {&(_tg__ZTV8S7825C26__7S7825C3__7S7825C2[3]),  3,5},
  {&(_tg__ZTV8S7825C12__7S7825C3__7S7825C2[6]),  6,8},
  {&(_tg__ZTV8S7825C14__A1__7S7825C3__7S7825C2[3]),  3,5},
  {&(_tg__ZTV7S7825C4__7S7825C2[3]),  3,5},
  {&(_tg__ZTV7S7825C5__7S7825C4__7S7825C2[3]),  3,5},
  {&(_tg__ZTV8S7825C24__7S7825C2[5]),  5,8},
  {&(_tg__ZTV8S7825C258S7825C24__7S7825C2[4]),  4,6},
  {&(_tg__ZTV10S7825C8_nt__8S7825C258S7825C24__7S7825C2[3]),  3,5},
  {&(_tg__ZTV10S7825C8_nt__8S7825C24__7S7825C2[3]),  3,5},
  {&(_tg__ZTV7S7825C5__8S7825C24__7S7825C2[3]),  3,5},
  {&(_tg__ZTV8S7825C12__7S7825C2[5]),  5,7},
  {&(_tg__ZTV7S7825C5__A1__8S7825C12__7S7825C2[3]),  3,5},
  {&(_tg__ZTV8S7825C14__8S7825C12__7S7825C2[3]),  3,5},
  {&(_tg__ZTV8S7825C29__7S7825C2[7]),  7,9},
  {&(_tg__ZTV8S7825C228S7825C29__7S7825C2[7]),  7,9},
  {&(_tg__ZTV8S7825C158S7825C228S7825C29__7S7825C2[3]),  3,6},
  {&(_tg__ZTV7S7825C5__8S7825C228S7825C29__7S7825C2[3]),  3,5},
  {&(_tg__ZTV8S7825C12__8S7825C228S7825C29__7S7825C2[6]),  6,8},
  {&(_tg__ZTV8S7825C14__8S7825C228S7825C29__7S7825C2[3]),  3,5},
  {&(_tg__ZTV8S7825C15__8S7825C228S7825C29__7S7825C2[3]),  3,6},
  {&(_tg__ZTV8S7825C12__8S7825C29__7S7825C2[6]),  6,8},
  {&(_tg__ZTV7S7825C5__A1__8S7825C29__7S7825C2[3]),  3,5},
  {&(_tg__ZTV8S7825C14__8S7825C29__7S7825C2[3]),  3,5},
  {&(_tg__ZTV8S7825C158S7825C22__8S7825C29__7S7825C2[3]),  3,6},
};
extern VTBL_ENTRY _ZTI7S7825C2[];
extern  VTBL_ENTRY _ZTV7S7825C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7825C2[];
static VTBL_ENTRY alt_thunk_names16[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C12D0Ev,_ZThn16_N8S7825C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C12D1Ev,_ZThn16_N8S7825C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C24D0Ev,_ZTv0_n12_N8S7825C24D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C24D0Ev,_ZThn16_N8S7825C24D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C24D1Ev,_ZTv0_n12_N8S7825C24D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C24D1Ev,_ZThn16_N8S7825C24D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C25D0Ev,_ZTv0_n12_N8S7825C25D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C25D0Ev,_ZThn16_N8S7825C25D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C25D1Ev,_ZTv0_n12_N8S7825C25D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C25D1Ev,_ZThn16_N8S7825C25D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7825C4D0Ev,_ZTv0_n12_N7S7825C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn512_N7S7825C4D0Ev,_ZThn280_N7S7825C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7825C4D1Ev,_ZTv0_n12_N7S7825C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn512_N7S7825C4D1Ev,_ZThn280_N7S7825C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7S7825C3D0Ev,_ZTv0_n24_N7S7825C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn632_N7S7825C3D0Ev,_ZThn340_N7S7825C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn552_N7S7825C3D0Ev,_ZThn300_N7S7825C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7S7825C3D1Ev,_ZTv0_n24_N7S7825C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn632_N7S7825C3D1Ev,_ZThn340_N7S7825C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn552_N7S7825C3D1Ev,_ZThn300_N7S7825C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7825C3D0Ev,_ZTv0_n12_N7S7825C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn664_N7S7825C3D0Ev,_ZThn356_N7S7825C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn600_N7S7825C3D0Ev,_ZThn324_N7S7825C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn584_N7S7825C3D0Ev,_ZThn316_N7S7825C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn528_N7S7825C3D0Ev,_ZThn288_N7S7825C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7825C3D1Ev,_ZTv0_n12_N7S7825C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn664_N7S7825C3D1Ev,_ZThn356_N7S7825C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn600_N7S7825C3D1Ev,_ZThn324_N7S7825C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn584_N7S7825C3D1Ev,_ZThn316_N7S7825C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn528_N7S7825C3D1Ev,_ZThn288_N7S7825C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S7825C3D0Ev,_ZTv0_n16_N7S7825C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7S7825C3D0Ev,_ZThn8_N7S7825C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S7825C3D1Ev,_ZTv0_n16_N7S7825C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7S7825C3D1Ev,_ZThn8_N7S7825C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C28D0Ev,_ZTv0_n12_N8S7825C28D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1080_N8S7825C28D0Ev,_ZThn600_N8S7825C28D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn944_N8S7825C28D0Ev,_ZThn532_N8S7825C28D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C28D1Ev,_ZTv0_n12_N8S7825C28D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1080_N8S7825C28D1Ev,_ZThn600_N8S7825C28D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn944_N8S7825C28D1Ev,_ZThn532_N8S7825C28D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C28D0Ev,_ZTv0_n24_N8S7825C28D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1048_N8S7825C28D0Ev,_ZThn584_N8S7825C28D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C28D1Ev,_ZTv0_n24_N8S7825C28D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1048_N8S7825C28D1Ev,_ZThn584_N8S7825C28D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S7825C28D0Ev,_ZTv0_n32_N8S7825C28D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1096_N8S7825C28D0Ev,_ZThn608_N8S7825C28D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S7825C28D1Ev,_ZTv0_n32_N8S7825C28D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1096_N8S7825C28D1Ev,_ZThn608_N8S7825C28D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S7825C2D0Ev,_ZTv0_n32_N7S7825C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1096_N7S7825C2D0Ev,_ZThn608_N7S7825C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S7825C2D1Ev,_ZTv0_n32_N7S7825C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1096_N7S7825C2D1Ev,_ZThn608_N7S7825C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7S7825C2D0Ev,_ZTv0_n24_N7S7825C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1048_N7S7825C2D0Ev,_ZThn584_N7S7825C2D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn968_N7S7825C2D0Ev,_ZThn544_N7S7825C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7S7825C2D1Ev,_ZTv0_n24_N7S7825C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1048_N7S7825C2D1Ev,_ZThn584_N7S7825C2D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn968_N7S7825C2D1Ev,_ZThn544_N7S7825C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7825C2D0Ev,_ZTv0_n12_N7S7825C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1080_N7S7825C2D0Ev,_ZThn600_N7S7825C2D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1016_N7S7825C2D0Ev,_ZThn568_N7S7825C2D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1000_N7S7825C2D0Ev,_ZThn560_N7S7825C2D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn944_N7S7825C2D0Ev,_ZThn532_N7S7825C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7825C2D1Ev,_ZTv0_n12_N7S7825C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1080_N7S7825C2D1Ev,_ZThn600_N7S7825C2D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1016_N7S7825C2D1Ev,_ZThn568_N7S7825C2D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1000_N7S7825C2D1Ev,_ZThn560_N7S7825C2D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn944_N7S7825C2D1Ev,_ZThn532_N7S7825C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S7825C2D0Ev,_ZTv0_n16_N7S7825C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn432_N7S7825C2D0Ev,_ZThn252_N7S7825C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S7825C2D1Ev,_ZTv0_n16_N7S7825C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn432_N7S7825C2D1Ev,_ZThn252_N7S7825C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N7S7825C2D0Ev,_ZTv0_n48_N7S7825C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn416_N7S7825C2D0Ev,_ZThn244_N7S7825C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N7S7825C2D1Ev,_ZTv0_n48_N7S7825C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn416_N7S7825C2D1Ev,_ZThn244_N7S7825C2D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7825C2 = {  "S7825C2", // class name
  bases_S7825C2, 51,
  &(vtc_S7825C2[0]), // expected_vtbl_contents
  &(vtt_S7825C2[0]), // expected_vtt_contents
  ABISELECT(1216,664), // object size
  NSPAIRA(_ZTI7S7825C2),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S7825C2),111, //virtual function table var
  14, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7825C2),56, //virtual table table var
  32, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names16,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C36  : virtual S2407C30 , virtual S7825C23_nt , S7825C12 {
  virtual  ~S7825C36(); // _ZN8S7825C36D2Ev
  virtual void  v3(); // _ZN8S7825C362v3Ev
  S7825C36(); // tgen
};
//SIG(-1 S7825C36) C1{ VBC2{ m} VBC3{ vd m Fp} BC4{ VBC5{ m} BC6{ BC2 BC7{ BC2 BC5 BC8{ vd m Fc} vd Fp} vd Fi} VBC7 VBC9{ BC8 BC5} vd} vd v1}


 S7825C36 ::~S7825C36(){ note_dtor("S7825C36", this);}
void  S7825C36 ::v3(){vfunc_called(this, "_ZN8S7825C362v3Ev");}
S7825C36 ::S7825C36(){ note_ctor("S7825C36", this);} // tgen

static void Test_S7825C36()
{
  extern Class_Descriptor cd_S7825C36;
  void *lvp;
  {
    ABISELECT(double,int) buf[13];
    init_test(&cd_S7825C36, buf);
    S7825C36 *dp, &lv = *(dp=new (buf) S7825C36());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,48), "sizeof(S7825C36)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7825C36)");
    /*is_ambiguous_... S7825C36::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*), ABISELECT(28,16), "S7825C36");
    check_base_class_offset(lv, (S7825C23_nt*), ABISELECT(32,16), "S7825C36");
    /*is_ambiguous_... S7825C12::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C12*), ABISELECT(48,24), "S7825C36");
    /*is_ambiguous_... S7825C13::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C13*)(S7825C12*), ABISELECT(24,12), "S7825C36");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C13*)(S7825C12*), 0, "S7825C36");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C13*)(S7825C12*), 0, "S7825C36");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C13*)(S7825C12*), 0, "S7825C36");
    check_base_class_offset(lv, (S7825C5*)(S7825C13*)(S7825C12*), 0, "S7825C36");
    check_base_class_offset(lv, (S7825C13*)(S7825C12*), 0, "S7825C36");
    /*is_ambiguous_... S7825C36::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*), ABISELECT(56,28), "S7825C36");
    /*is_ambiguous_... S7825C36::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*), ABISELECT(56,28), "S7825C36");
    /*is_ambiguous_... S7825C36::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*), ABISELECT(56,28), "S7825C36");
    /*is_ambiguous_... S7825C12::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C12*), ABISELECT(56,28), "S7825C36");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*), ABISELECT(80,40), "S7825C36");
    check_base_class_offset(lv, (S2407C27*)(S7825C14*), ABISELECT(80,40), "S7825C36");
    check_base_class_offset(lv, (S7825C14*)(S7825C12*), ABISELECT(80,40), "S7825C36");
    check_base_class_offset(lv, (S7825C12*), 0, "S7825C36");
    test_class_info(&lv, &cd_S7825C36);
    dp->~S7825C36();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7825C36(Test_S7825C36, "S7825C36", ABISELECT(96,48));

#else // __cplusplus

extern void _ZN8S7825C36C1Ev();
extern void _ZN8S7825C36D2Ev();
Name_Map name_map_S7825C36[] = {
  NSPAIR(_ZN8S7825C36C1Ev),
  NSPAIR(_ZN8S7825C36D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S7825C23_nt;
extern VTBL_ENTRY _ZTI11S7825C23_nt[];
extern  VTBL_ENTRY _ZTV11S7825C23_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C13;
extern VTBL_ENTRY _ZTI8S7825C13[];
extern  VTBL_ENTRY _ZTV8S7825C13[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C12;
extern VTBL_ENTRY _ZTI8S7825C12[];
extern  VTBL_ENTRY _ZTV8S7825C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C12[];
static Base_Class bases_S7825C36[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2407C30,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7825C23_nt,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2407C27,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S2407C30,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S2407C30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S2407C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S7825C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7825C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(56,28), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S7825C8_nt,    ABISELECT(80,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(80,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(80,40), //bcp->offset
    20, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S7825C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7825C36[];
extern void _ZN8S7825C36D1Ev();
extern void _ZN8S7825C36D0Ev();
extern void _ZN8S7825C362v3Ev();
extern void ABISELECT(_ZTv0_n24_N8S7825C36D1Ev,_ZTv0_n12_N8S7825C36D1Ev)();
extern void ABISELECT(_ZThn32_N8S7825C36D1Ev,_ZThn16_N8S7825C36D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C36D0Ev,_ZTv0_n12_N8S7825C36D0Ev)();
extern void ABISELECT(_ZThn32_N8S7825C36D0Ev,_ZThn16_N8S7825C36D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C36D1Ev,_ZTv0_n12_N8S7825C36D1Ev)();
extern void ABISELECT(_ZThn56_N8S7825C36D1Ev,_ZThn28_N8S7825C36D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C36D0Ev,_ZTv0_n12_N8S7825C36D0Ev)();
extern void ABISELECT(_ZThn56_N8S7825C36D0Ev,_ZThn28_N8S7825C36D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C36D1Ev,_ZTv0_n12_N8S7825C36D1Ev)();
extern void ABISELECT(_ZThn80_N8S7825C36D1Ev,_ZThn40_N8S7825C36D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C36D0Ev,_ZTv0_n12_N8S7825C36D0Ev)();
extern void ABISELECT(_ZThn80_N8S7825C36D0Ev,_ZThn40_N8S7825C36D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7825C36[] = {
  ABISELECT(32,16),
  ABISELECT(28,16),
  ABISELECT(80,40),
  ABISELECT(56,28),
  ABISELECT(48,24),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C36[0]),
  (VTBL_ENTRY)&_ZN8S7825C36D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C36D0Ev,
  (VTBL_ENTRY)&_ZN8S7825C362v3Ev,
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S7825C36[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C36D1Ev,_ZTv0_n12_N8S7825C36D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C36D0Ev,_ZTv0_n12_N8S7825C36D0Ev),
  ABISELECT(-56,-28),
  ABISELECT(-56,-28),
  (VTBL_ENTRY)&(_ZTI8S7825C36[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C36D1Ev,_ZTv0_n12_N8S7825C36D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C36D0Ev,_ZTv0_n12_N8S7825C36D0Ev),
  ABISELECT(-80,-40),
  ABISELECT(-80,-40),
  (VTBL_ENTRY)&(_ZTI8S7825C36[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C36D1Ev,_ZTv0_n12_N8S7825C36D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C36D0Ev,_ZTv0_n12_N8S7825C36D0Ev),
};
extern VTBL_ENTRY _ZTV8S7825C36[];
extern void _ZN8S7825C12D1Ev();
extern void _ZN8S7825C12D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C12__8S7825C36[] = {
  ABISELECT(80,40),
  ABISELECT(56,28),
  ABISELECT(48,24),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&_ZN8S7825C12D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C12D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZThn56_N8S7825C12D1Ev,_ZThn28_N8S7825C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
extern void ABISELECT(_ZThn56_N8S7825C12D0Ev,_ZThn28_N8S7825C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7825C5__A1__8S7825C12__8S7825C36[] = {
  ABISELECT(-56,-28),
  ABISELECT(-56,-28),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZThn80_N8S7825C12D1Ev,_ZThn40_N8S7825C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
extern void ABISELECT(_ZThn80_N8S7825C12D0Ev,_ZThn40_N8S7825C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C14__8S7825C12__8S7825C36[] = {
  ABISELECT(-80,-40),
  ABISELECT(-80,-40),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
};
static  VTT_ENTRY vtt_S7825C36[] = {
  {&(_ZTV8S7825C36[7]),  7,25},
  {&(_tg__ZTV8S7825C12__8S7825C36[5]),  5,7},
  {&(_tg__ZTV7S7825C5__A1__8S7825C12__8S7825C36[3]),  3,5},
  {&(_tg__ZTV8S7825C14__8S7825C12__8S7825C36[3]),  3,5},
  {&(_ZTV8S7825C36[13]),  13,25},
  {&(_ZTV8S7825C36[18]),  18,25},
  {&(_ZTV8S7825C36[23]),  23,25},
};
extern VTBL_ENTRY _ZTI8S7825C36[];
extern  VTBL_ENTRY _ZTV8S7825C36[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C36[];
static VTBL_ENTRY alt_thunk_names17[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N8S7825C12D0Ev,_ZThn40_N8S7825C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S7825C12D0Ev,_ZThn28_N8S7825C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N8S7825C12D1Ev,_ZThn40_N8S7825C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S7825C12D1Ev,_ZThn28_N8S7825C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C36D0Ev,_ZTv0_n12_N8S7825C36D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N8S7825C36D0Ev,_ZThn40_N8S7825C36D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S7825C36D0Ev,_ZThn28_N8S7825C36D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C36D0Ev,_ZThn16_N8S7825C36D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C36D1Ev,_ZTv0_n12_N8S7825C36D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N8S7825C36D1Ev,_ZThn40_N8S7825C36D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S7825C36D1Ev,_ZThn28_N8S7825C36D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C36D1Ev,_ZThn16_N8S7825C36D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7825C36 = {  "S7825C36", // class name
  bases_S7825C36, 17,
  &(vtc_S7825C36[0]), // expected_vtbl_contents
  &(vtt_S7825C36[0]), // expected_vtt_contents
  ABISELECT(96,48), // object size
  NSPAIRA(_ZTI8S7825C36),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S7825C36),25, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7825C36),7, //virtual table table var
  9, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names17,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C38  : S7825C29 , S7825C24 , virtual S7825C26 , S7825C12 {
  int s7825c38f0;
  virtual  ~S7825C38(); // _ZN8S7825C38D2Ev
  S7825C38(); // tgen
};
//SIG(-1 S7825C38) C1{ BC2{ VBC3{ m} VBC4{ VBC3 BC5{ BC6{ m} BC7{ BC6 BC3 BC8{ vd m Fc} vd Fp} vd Fi} VBC7 VBC9{ BC8 BC3} vd} BC10{ VBC7 VBC4 BC11{ vd m Fp} BC12{ BC3 BC9 BC8 BC7 VBC6 vd v1} BC9 vd} BC7} BC13{ BC14{ VBC8 BC9 VBC6 vd} BC11 VBC7 v2} VBC15{ BC11 Fc:7 Fp} BC4 vd Fi}


 S7825C38 ::~S7825C38(){ note_dtor("S7825C38", this);}
S7825C38 ::S7825C38(){ note_ctor("S7825C38", this);} // tgen

static void Test_S7825C38()
{
  extern Class_Descriptor cd_S7825C38;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(38,39)];
    init_test(&cd_S7825C38, buf);
    S7825C38 *dp, &lv = *(dp=new (buf) S7825C38());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(296,152), "sizeof(S7825C38)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7825C38)");
    /*is_ambiguous_... S7825C29::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C29*), 0, "S7825C38");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C12*), 0, "S7825C38");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C12*), 0, "S7825C38");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C13*)(S7825C12*), ABISELECT(200,104), "S7825C38");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(176,92), "S7825C38");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(176,92), "S7825C38");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(176,92), "S7825C38");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(176,92), "S7825C38");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C13*)(S7825C12*), ABISELECT(176,92), "S7825C38");
    /*is_ambiguous_... S7825C38::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*), ABISELECT(208,108), "S7825C38");
    /*is_ambiguous_... S7825C38::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*), ABISELECT(208,108), "S7825C38");
    /*is_ambiguous_... S7825C38::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*), ABISELECT(208,108), "S7825C38");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C12*), ABISELECT(208,108), "S7825C38");
    /*is_ambiguous_... S7825C22::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C22*)(S7825C29*), ABISELECT(208,108), "S7825C38");
    check_base_class_offset(lv, (S7825C5*)(S7825C24*), ABISELECT(208,108), "S7825C38");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C12*), ABISELECT(208,108), "S7825C38");
    /*is_ambiguous_... S7825C38::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*), ABISELECT(232,120), "S7825C38");
    /*is_ambiguous_... S7825C38::S7825C14 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C14*), ABISELECT(232,120), "S7825C38");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C14*)(S7825C12*), ABISELECT(232,120), "S7825C38");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C14*)(S7825C12*), ABISELECT(232,120), "S7825C38");
    check_base_class_offset(lv, (S7825C12*)(S7825C29*), ABISELECT(176,92), "S7825C38");
    check_base_class_offset(lv, (S7825C12*)(S7825C22*)(S7825C29*), ABISELECT(176,92), "S7825C38");
    check_base_class_offset(lv, (S7825C23_nt*)(S7825C22*)(S7825C29*), 0, "S7825C38");
    /*is_ambiguous_... S7825C15::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C15*)(S7825C22*)(S7825C29*), ABISELECT(25,13), "S7825C38");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C15*)(S7825C22*)(S7825C29*), ABISELECT(16,8), "S7825C38");
    check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C15*)(S7825C22*)(S7825C29*), ABISELECT(16,8), "S7825C38");
    check_base_class_offset(lv, (S7825C14*)(S7825C15*)(S7825C22*)(S7825C29*), ABISELECT(16,8), "S7825C38");
    /*is_ambiguous_... S7825C15::S7825C8_nt */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C15*)(S7825C22*)(S7825C29*), ABISELECT(32,16), "S7825C38");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C15*)(S7825C22*)(S7825C29*), ABISELECT(48,24), "S7825C38");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C15*)(S7825C22*)(S7825C29*), ABISELECT(48,24), "S7825C38");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C15*)(S7825C22*)(S7825C29*), ABISELECT(48,24), "S7825C38");
    check_base_class_offset(lv, (S7825C5*)(S7825C15*)(S7825C22*)(S7825C29*), ABISELECT(48,24), "S7825C38");
    /*is_ambiguous_... S7825C15::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C15*)(S7825C22*)(S7825C29*), 0, "S7825C38");
    check_base_class_offset(lv, (S2407C30*)(S7825C25*)(S7825C24*), 0, "S7825C38");
    check_base_class_offset(lv, (S7825C15*)(S7825C22*)(S7825C29*), ABISELECT(16,8), "S7825C38");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C22*)(S7825C29*), ABISELECT(72,36), "S7825C38");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C22*)(S7825C29*), ABISELECT(72,36), "S7825C38");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C14*)(S7825C22*)(S7825C29*), ABISELECT(72,36), "S7825C38");
    check_base_class_offset(lv, (S7825C22*)(S7825C29*), 0, "S7825C38");
    /*is_ambiguous_... S7825C29::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C29*), ABISELECT(88,44), "S7825C38");
    /*is_ambiguous_... S7825C29::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C29*), ABISELECT(88,44), "S7825C38");
    /*is_ambiguous_... S7825C29::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C29*), ABISELECT(88,44), "S7825C38");
    /*is_ambiguous_... S7825C29::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C29*), ABISELECT(88,44), "S7825C38");
    check_base_class_offset(lv, (S7825C29*), 0, "S7825C38");
    /*is_ambiguous_... S7825C25::S7825C8_nt */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C25*)(S7825C24*), ABISELECT(248,128), "S7825C38");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C25*)(S7825C24*), ABISELECT(112,56), "S7825C38");
    check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C25*)(S7825C24*), ABISELECT(112,56), "S7825C38");
    check_base_class_offset(lv, (S7825C14*)(S7825C25*)(S7825C24*), ABISELECT(112,56), "S7825C38");
    check_base_class_offset(lv, (S7825C25*)(S7825C24*), ABISELECT(112,56), "S7825C38");
    check_base_class_offset(lv, (S7825C23_nt*)(S7825C24*), ABISELECT(128,64), "S7825C38");
    check_base_class_offset(lv, (S7825C24*), ABISELECT(112,56), "S7825C38");
    check_base_class_offset(lv, (S7825C23_nt*)(S7825C26*), ABISELECT(264,136), "S7825C38");
    check_base_class_offset(lv, (S7825C26*), ABISELECT(264,136), "S7825C38");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C13*)(S7825C12*), ABISELECT(168,84), "S7825C38");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(144,72), "S7825C38");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(144,72), "S7825C38");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(144,72), "S7825C38");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(144,72), "S7825C38");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C13*)(S7825C12*), ABISELECT(144,72), "S7825C38");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C12*), ABISELECT(144,72), "S7825C38");
    check_field_offset(lv, s7825c38f0, ABISELECT(172,88), "S7825C38.s7825c38f0");
    test_class_info(&lv, &cd_S7825C38);
    dp->~S7825C38();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7825C38(Test_S7825C38, "S7825C38", ABISELECT(296,152));

#else // __cplusplus

extern void _ZN8S7825C38C1Ev();
extern void _ZN8S7825C38D2Ev();
Name_Map name_map_S7825C38[] = {
  NSPAIR(_ZN8S7825C38C1Ev),
  NSPAIR(_ZN8S7825C38D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C13;
extern VTBL_ENTRY _ZTI8S7825C13[];
extern  VTBL_ENTRY _ZTV8S7825C13[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C12;
extern VTBL_ENTRY _ZTI8S7825C12[];
extern  VTBL_ENTRY _ZTV8S7825C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C12[];
extern Class_Descriptor cd_S7825C23_nt;
extern VTBL_ENTRY _ZTI11S7825C23_nt[];
extern  VTBL_ENTRY _ZTV11S7825C23_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S7825C15;
extern VTBL_ENTRY _ZTI8S7825C15[];
extern  VTBL_ENTRY _ZTV8S7825C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C15[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C22;
extern VTBL_ENTRY _ZTI8S7825C22[];
extern  VTBL_ENTRY _ZTV8S7825C22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C22[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C29;
extern VTBL_ENTRY _ZTI8S7825C29[];
extern  VTBL_ENTRY _ZTV8S7825C29[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C29[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C25;
extern VTBL_ENTRY _ZTI8S7825C25[];
extern  VTBL_ENTRY _ZTV8S7825C25[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C25[];
extern Class_Descriptor cd_S7825C23_nt;
extern VTBL_ENTRY _ZTI11S7825C23_nt[];
extern  VTBL_ENTRY _ZTV11S7825C23_nt[];
extern Class_Descriptor cd_S7825C24;
extern VTBL_ENTRY _ZTI8S7825C24[];
extern  VTBL_ENTRY _ZTV8S7825C24[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C24[];
extern Class_Descriptor cd_S7825C23_nt;
extern VTBL_ENTRY _ZTI11S7825C23_nt[];
extern  VTBL_ENTRY _ZTV11S7825C23_nt[];
extern Class_Descriptor cd_S7825C26;
extern VTBL_ENTRY _ZTI8S7825C26[];
extern  VTBL_ENTRY _ZTV8S7825C26[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C13;
extern VTBL_ENTRY _ZTI8S7825C13[];
extern  VTBL_ENTRY _ZTV8S7825C13[];
extern Class_Descriptor cd_S7825C12;
extern VTBL_ENTRY _ZTI8S7825C12[];
extern  VTBL_ENTRY _ZTV8S7825C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C12[];
static Base_Class bases_S7825C38[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2407C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S2407C30,    ABISELECT(200,104), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(176,92), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(176,92), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(176,92), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(176,92), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S7825C13,    ABISELECT(176,92), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(208,108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(208,108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(208,108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(208,108), //bcp->offset
    60, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S7825C8_nt,    ABISELECT(232,120), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(232,120), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(232,120), //bcp->offset
    65, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S7825C12,    ABISELECT(176,92), //bcp->offset
    52, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    29, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    30, //immediately_derived
  0, 1},
  {&cd_S7825C23_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(25,13), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(32,16), //bcp->offset
    17, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(48,24), //bcp->offset
    21, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S2407C30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    26, //immediately_derived
  0, 1},
  {&cd_S7825C15,    ABISELECT(16,8), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(72,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(72,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(72,36), //bcp->offset
    25, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S7825C22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(88,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(88,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(88,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(88,44), //bcp->offset
    29, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S7825C29,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7825C8_nt,    ABISELECT(248,128), //bcp->offset
    70, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    40, //immediately_derived
  0, 1},
  {&cd_S7825C8_nt,    ABISELECT(112,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(112,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(112,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    40, //immediately_derived
  0, 0},
  {&cd_S7825C25,    ABISELECT(112,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    42, //immediately_derived
  0, 0},
  {&cd_S7825C23_nt,    ABISELECT(128,64), //bcp->offset
    41, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    42, //immediately_derived
  0, 0},
  {&cd_S7825C24,    ABISELECT(112,56), //bcp->offset
    33, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7825C23_nt,    ABISELECT(264,136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S7825C26,    ABISELECT(264,136), //bcp->offset
    75, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2407C30,    ABISELECT(168,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    50, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(144,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    49, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(144,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    49, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(144,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    49, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(144,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    50, //immediately_derived
  0, 0},
  {&cd_S7825C13,    ABISELECT(144,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    51, //immediately_derived
  0, 0},
  {&cd_S7825C12,    ABISELECT(144,72), //bcp->offset
    45, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7825C38[];
extern void _ZN8S7825C38D1Ev();
extern void _ZN8S7825C38D0Ev();
extern void ABISELECT(_ZThn16_N8S7825C38D1Ev,_ZThn8_N8S7825C38D1Ev)();
extern void ABISELECT(_ZThn16_N8S7825C38D0Ev,_ZThn8_N8S7825C38D0Ev)();
extern void _ZN8S7825C152v2Ev();
extern void ABISELECT(_ZThn32_N8S7825C38D1Ev,_ZThn16_N8S7825C38D1Ev)();
extern void ABISELECT(_ZThn32_N8S7825C38D0Ev,_ZThn16_N8S7825C38D0Ev)();
extern void ABISELECT(_ZThn48_N8S7825C38D1Ev,_ZThn24_N8S7825C38D1Ev)();
extern void ABISELECT(_ZThn48_N8S7825C38D0Ev,_ZThn24_N8S7825C38D0Ev)();
extern void ABISELECT(_ZThn72_N8S7825C38D1Ev,_ZThn36_N8S7825C38D1Ev)();
extern void ABISELECT(_ZThn72_N8S7825C38D0Ev,_ZThn36_N8S7825C38D0Ev)();
extern void ABISELECT(_ZThn88_N8S7825C38D1Ev,_ZThn44_N8S7825C38D1Ev)();
extern void ABISELECT(_ZThn88_N8S7825C38D0Ev,_ZThn44_N8S7825C38D0Ev)();
extern void ABISELECT(_ZThn112_N8S7825C38D1Ev,_ZThn56_N8S7825C38D1Ev)();
extern void ABISELECT(_ZThn112_N8S7825C38D0Ev,_ZThn56_N8S7825C38D0Ev)();
extern void _ZN8S7825C242v1Ev();
extern void ABISELECT(_ZThn128_N8S7825C38D1Ev,_ZThn64_N8S7825C38D1Ev)();
extern void ABISELECT(_ZThn128_N8S7825C38D0Ev,_ZThn64_N8S7825C38D0Ev)();
extern void ABISELECT(_ZThn144_N8S7825C38D1Ev,_ZThn72_N8S7825C38D1Ev)();
extern void ABISELECT(_ZThn144_N8S7825C38D0Ev,_ZThn72_N8S7825C38D0Ev)();
extern void ABISELECT(_ZTv0_n48_N8S7825C38D1Ev,_ZTv0_n24_N8S7825C38D1Ev)();
extern void ABISELECT(_ZThn176_N8S7825C38D1Ev,_ZThn92_N8S7825C38D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7825C38D0Ev,_ZTv0_n24_N8S7825C38D0Ev)();
extern void ABISELECT(_ZThn176_N8S7825C38D0Ev,_ZThn92_N8S7825C38D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C38D1Ev,_ZTv0_n12_N8S7825C38D1Ev)();
extern void ABISELECT(_ZThn208_N8S7825C38D1Ev,_ZThn108_N8S7825C38D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C38D0Ev,_ZTv0_n12_N8S7825C38D0Ev)();
extern void ABISELECT(_ZThn208_N8S7825C38D0Ev,_ZThn108_N8S7825C38D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C38D1Ev,_ZTv0_n12_N8S7825C38D1Ev)();
extern void ABISELECT(_ZThn232_N8S7825C38D1Ev,_ZThn120_N8S7825C38D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C38D0Ev,_ZTv0_n12_N8S7825C38D0Ev)();
extern void ABISELECT(_ZThn232_N8S7825C38D0Ev,_ZThn120_N8S7825C38D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C38D1Ev,_ZTv0_n12_N8S7825C38D1Ev)();
extern void ABISELECT(_ZThn248_N8S7825C38D1Ev,_ZThn128_N8S7825C38D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C38D0Ev,_ZTv0_n12_N8S7825C38D0Ev)();
extern void ABISELECT(_ZThn248_N8S7825C38D0Ev,_ZThn128_N8S7825C38D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C38D1Ev,_ZTv0_n12_N8S7825C38D1Ev)();
extern void ABISELECT(_ZThn264_N8S7825C38D1Ev,_ZThn136_N8S7825C38D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C38D0Ev,_ZTv0_n12_N8S7825C38D0Ev)();
extern void ABISELECT(_ZThn264_N8S7825C38D0Ev,_ZThn136_N8S7825C38D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7825C38[] = {
  ABISELECT(264,136),
  ABISELECT(248,128),
  0,
  ABISELECT(232,120),
  0,
  ABISELECT(176,92),
  ABISELECT(208,108),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C38[0]),
  (VTBL_ENTRY)&_ZN8S7825C38D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C38D0Ev,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S7825C38[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C38D1Ev,_ZThn8_N8S7825C38D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C38D0Ev,_ZThn8_N8S7825C38D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S7825C38[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S7825C38D1Ev,_ZThn16_N8S7825C38D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S7825C38D0Ev,_ZThn16_N8S7825C38D0Ev),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S7825C38[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N8S7825C38D1Ev,_ZThn24_N8S7825C38D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N8S7825C38D0Ev,_ZThn24_N8S7825C38D0Ev),
  ABISELECT(-72,-36),
  (VTBL_ENTRY)&(_ZTI8S7825C38[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N8S7825C38D1Ev,_ZThn36_N8S7825C38D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N8S7825C38D0Ev,_ZThn36_N8S7825C38D0Ev),
  ABISELECT(-88,-44),
  (VTBL_ENTRY)&(_ZTI8S7825C38[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn88_N8S7825C38D1Ev,_ZThn44_N8S7825C38D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn88_N8S7825C38D0Ev,_ZThn44_N8S7825C38D0Ev),
  ABISELECT(96,52),
  ABISELECT(-112,-56),
  ABISELECT(136,72),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI8S7825C38[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N8S7825C38D1Ev,_ZThn56_N8S7825C38D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N8S7825C38D0Ev,_ZThn56_N8S7825C38D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C242v1Ev,
  ABISELECT(-128,-64),
  (VTBL_ENTRY)&(_ZTI8S7825C38[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N8S7825C38D1Ev,_ZThn64_N8S7825C38D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N8S7825C38D0Ev,_ZThn64_N8S7825C38D0Ev),
  ABISELECT(88,48),
  ABISELECT(64,36),
  ABISELECT(-144,-72),
  ABISELECT(-144,-72),
  (VTBL_ENTRY)&(_ZTI8S7825C38[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N8S7825C38D1Ev,_ZThn72_N8S7825C38D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N8S7825C38D0Ev,_ZThn72_N8S7825C38D0Ev),
  ABISELECT(-176,-92),
  ABISELECT(56,28),
  ABISELECT(32,16),
  ABISELECT(-176,-92),
  ABISELECT(-176,-92),
  (VTBL_ENTRY)&(_ZTI8S7825C38[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C38D1Ev,_ZTv0_n24_N8S7825C38D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C38D0Ev,_ZTv0_n24_N8S7825C38D0Ev),
  ABISELECT(-208,-108),
  ABISELECT(-208,-108),
  (VTBL_ENTRY)&(_ZTI8S7825C38[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C38D1Ev,_ZTv0_n12_N8S7825C38D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C38D0Ev,_ZTv0_n12_N8S7825C38D0Ev),
  ABISELECT(-232,-120),
  ABISELECT(-232,-120),
  (VTBL_ENTRY)&(_ZTI8S7825C38[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C38D1Ev,_ZTv0_n12_N8S7825C38D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C38D0Ev,_ZTv0_n12_N8S7825C38D0Ev),
  ABISELECT(-248,-128),
  ABISELECT(-248,-128),
  (VTBL_ENTRY)&(_ZTI8S7825C38[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C38D1Ev,_ZTv0_n12_N8S7825C38D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C38D0Ev,_ZTv0_n12_N8S7825C38D0Ev),
  ABISELECT(-264,-136),
  ABISELECT(-264,-136),
  (VTBL_ENTRY)&(_ZTI8S7825C38[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C38D1Ev,_ZTv0_n12_N8S7825C38D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C38D0Ev,_ZTv0_n12_N8S7825C38D0Ev),
};
extern VTBL_ENTRY _ZTV8S7825C38[];
extern void _ZN8S7825C29D1Ev();
extern void _ZN8S7825C29D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C29__8S7825C38[] = {
  0,
  ABISELECT(232,120),
  0,
  ABISELECT(176,92),
  ABISELECT(208,108),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C29[0]),
  (VTBL_ENTRY)&_ZN8S7825C29D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C29D0Ev,
};
extern void _ZN8S7825C22D1Ev();
extern void _ZN8S7825C22D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C228S7825C29__8S7825C38[] = {
  0,
  ABISELECT(232,120),
  0,
  ABISELECT(176,92),
  ABISELECT(208,108),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&_ZN8S7825C22D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C22D0Ev,
};
extern void _ZN8S7825C15D1Ev();
extern void _ZN8S7825C15D0Ev();
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C158S7825C228S7825C29__8S7825C38[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C15[0]),
  (VTBL_ENTRY)&_ZN8S7825C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C15D0Ev,
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev)();
extern void ABISELECT(_ZThn208_N8S7825C22D1Ev,_ZThn108_N8S7825C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev)();
extern void ABISELECT(_ZThn208_N8S7825C22D0Ev,_ZThn108_N8S7825C22D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7825C5__8S7825C228S7825C29__8S7825C38[] = {
  ABISELECT(-208,-108),
  ABISELECT(-208,-108),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev),
};
extern void ABISELECT(_ZTv0_n48_N8S7825C22D1Ev,_ZTv0_n24_N8S7825C22D1Ev)();
extern void ABISELECT(_ZThn176_N8S7825C22D1Ev,_ZThn92_N8S7825C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7825C22D0Ev,_ZTv0_n24_N8S7825C22D0Ev)();
extern void ABISELECT(_ZThn176_N8S7825C22D0Ev,_ZThn92_N8S7825C22D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C12__8S7825C228S7825C29__8S7825C38[] = {
  ABISELECT(-176,-92),
  ABISELECT(56,28),
  ABISELECT(32,16),
  ABISELECT(-176,-92),
  ABISELECT(-176,-92),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C22D1Ev,_ZTv0_n24_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C22D0Ev,_ZTv0_n24_N8S7825C22D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev)();
extern void ABISELECT(_ZThn232_N8S7825C22D1Ev,_ZThn120_N8S7825C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev)();
extern void ABISELECT(_ZThn232_N8S7825C22D0Ev,_ZThn120_N8S7825C22D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C14__8S7825C228S7825C29__8S7825C38[] = {
  ABISELECT(-232,-120),
  ABISELECT(-232,-120),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev),
};
extern void ABISELECT(_ZThn16_N8S7825C22D1Ev,_ZThn8_N8S7825C22D1Ev)();
extern void ABISELECT(_ZThn16_N8S7825C22D0Ev,_ZThn8_N8S7825C22D0Ev)();
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C15__8S7825C228S7825C29__8S7825C38[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C22D1Ev,_ZThn8_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C22D0Ev,_ZThn8_N8S7825C22D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
extern void ABISELECT(_ZTv0_n48_N8S7825C29D1Ev,_ZTv0_n24_N8S7825C29D1Ev)();
extern void ABISELECT(_ZThn176_N8S7825C29D1Ev,_ZThn92_N8S7825C29D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7825C29D0Ev,_ZTv0_n24_N8S7825C29D0Ev)();
extern void ABISELECT(_ZThn176_N8S7825C29D0Ev,_ZThn92_N8S7825C29D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C12__8S7825C29__8S7825C38[] = {
  ABISELECT(-176,-92),
  ABISELECT(56,28),
  ABISELECT(32,16),
  ABISELECT(-176,-92),
  ABISELECT(-176,-92),
  (VTBL_ENTRY)&(_ZTI8S7825C29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C29D1Ev,_ZTv0_n24_N8S7825C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C29D0Ev,_ZTv0_n24_N8S7825C29D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C29D1Ev,_ZTv0_n12_N8S7825C29D1Ev)();
extern void ABISELECT(_ZThn208_N8S7825C29D1Ev,_ZThn108_N8S7825C29D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C29D0Ev,_ZTv0_n12_N8S7825C29D0Ev)();
extern void ABISELECT(_ZThn208_N8S7825C29D0Ev,_ZThn108_N8S7825C29D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7825C5__A1__8S7825C29__8S7825C38[] = {
  ABISELECT(-208,-108),
  ABISELECT(-208,-108),
  (VTBL_ENTRY)&(_ZTI8S7825C29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C29D1Ev,_ZTv0_n12_N8S7825C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C29D0Ev,_ZTv0_n12_N8S7825C29D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C29D1Ev,_ZTv0_n12_N8S7825C29D1Ev)();
extern void ABISELECT(_ZThn232_N8S7825C29D1Ev,_ZThn120_N8S7825C29D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C29D0Ev,_ZTv0_n12_N8S7825C29D0Ev)();
extern void ABISELECT(_ZThn232_N8S7825C29D0Ev,_ZThn120_N8S7825C29D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C14__8S7825C29__8S7825C38[] = {
  ABISELECT(-232,-120),
  ABISELECT(-232,-120),
  (VTBL_ENTRY)&(_ZTI8S7825C29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C29D1Ev,_ZTv0_n12_N8S7825C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C29D0Ev,_ZTv0_n12_N8S7825C29D0Ev),
};
extern void ABISELECT(_ZThn16_N8S7825C29D1Ev,_ZThn8_N8S7825C29D1Ev)();
extern void ABISELECT(_ZThn16_N8S7825C29D0Ev,_ZThn8_N8S7825C29D0Ev)();
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C158S7825C22__8S7825C29__8S7825C38[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S7825C29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C29D1Ev,_ZThn8_N8S7825C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C29D0Ev,_ZThn8_N8S7825C29D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
extern void _ZN8S7825C24D1Ev();
extern void _ZN8S7825C24D0Ev();
extern void _ZN8S7825C242v1Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C24__8S7825C38[] = {
  ABISELECT(96,52),
  ABISELECT(-112,-56),
  ABISELECT(136,72),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C24[0]),
  (VTBL_ENTRY)&_ZN8S7825C24D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C24D0Ev,
  (VTBL_ENTRY)&_ZN8S7825C242v1Ev,
};
extern void _ZN8S7825C25D1Ev();
extern void _ZN8S7825C25D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C258S7825C24__8S7825C38[] = {
  ABISELECT(-112,-56),
  ABISELECT(136,72),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C25[0]),
  (VTBL_ENTRY)&_ZN8S7825C25D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C25D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C25D1Ev,_ZTv0_n12_N8S7825C25D1Ev)();
extern void ABISELECT(_ZThn136_N8S7825C25D1Ev,_ZThn72_N8S7825C25D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C25D0Ev,_ZTv0_n12_N8S7825C25D0Ev)();
extern void ABISELECT(_ZThn136_N8S7825C25D0Ev,_ZThn72_N8S7825C25D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV10S7825C8_nt__8S7825C258S7825C24__8S7825C38[] = {
  ABISELECT(-136,-72),
  ABISELECT(-136,-72),
  (VTBL_ENTRY)&(_ZTI8S7825C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C25D1Ev,_ZTv0_n12_N8S7825C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C25D0Ev,_ZTv0_n12_N8S7825C25D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C24D1Ev,_ZTv0_n12_N8S7825C24D1Ev)();
extern void ABISELECT(_ZThn136_N8S7825C24D1Ev,_ZThn72_N8S7825C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C24D0Ev,_ZTv0_n12_N8S7825C24D0Ev)();
extern void ABISELECT(_ZThn136_N8S7825C24D0Ev,_ZThn72_N8S7825C24D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV10S7825C8_nt__8S7825C24__8S7825C38[] = {
  ABISELECT(-136,-72),
  ABISELECT(-136,-72),
  (VTBL_ENTRY)&(_ZTI8S7825C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C24D1Ev,_ZTv0_n12_N8S7825C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C24D0Ev,_ZTv0_n12_N8S7825C24D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C24D1Ev,_ZTv0_n12_N8S7825C24D1Ev)();
extern void ABISELECT(_ZThn96_N8S7825C24D1Ev,_ZThn52_N8S7825C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C24D0Ev,_ZTv0_n12_N8S7825C24D0Ev)();
extern void ABISELECT(_ZThn96_N8S7825C24D0Ev,_ZThn52_N8S7825C24D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7825C5__8S7825C24__8S7825C38[] = {
  ABISELECT(-96,-52),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI8S7825C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C24D1Ev,_ZTv0_n12_N8S7825C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C24D0Ev,_ZTv0_n12_N8S7825C24D0Ev),
};
extern void _ZN8S7825C12D1Ev();
extern void _ZN8S7825C12D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C12__A__8S7825C38[] = {
  ABISELECT(88,48),
  ABISELECT(64,36),
  ABISELECT(-144,-72),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&_ZN8S7825C12D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C12D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZThn64_N8S7825C12D1Ev,_ZThn36_N8S7825C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
extern void ABISELECT(_ZThn64_N8S7825C12D0Ev,_ZThn36_N8S7825C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7825C5__A1__8S7825C12__A__8S7825C38[] = {
  ABISELECT(-64,-36),
  ABISELECT(-64,-36),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZThn88_N8S7825C12D1Ev,_ZThn48_N8S7825C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
extern void ABISELECT(_ZThn88_N8S7825C12D0Ev,_ZThn48_N8S7825C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C14__8S7825C12__A__8S7825C38[] = {
  ABISELECT(-88,-48),
  ABISELECT(-88,-48),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
};
extern void _ZN8S7825C12D1Ev();
extern void _ZN8S7825C12D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C12__8S7825C38[] = {
  ABISELECT(56,28),
  ABISELECT(32,16),
  ABISELECT(-176,-92),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&_ZN8S7825C12D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C12D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZThn32_N8S7825C12D1Ev,_ZThn16_N8S7825C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
extern void ABISELECT(_ZThn32_N8S7825C12D0Ev,_ZThn16_N8S7825C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7825C5__A1__8S7825C12__8S7825C38[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZThn56_N8S7825C12D1Ev,_ZThn28_N8S7825C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
extern void ABISELECT(_ZThn56_N8S7825C12D0Ev,_ZThn28_N8S7825C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C14__8S7825C12__8S7825C38[] = {
  ABISELECT(-56,-28),
  ABISELECT(-56,-28),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
};
static  VTT_ENTRY vtt_S7825C38[] = {
  {&(_ZTV8S7825C38[9]),  9,80},
  {&(_tg__ZTV8S7825C29__8S7825C38[7]),  7,9},
  {&(_tg__ZTV8S7825C228S7825C29__8S7825C38[7]),  7,9},
  {&(_tg__ZTV8S7825C158S7825C228S7825C29__8S7825C38[3]),  3,6},
  {&(_tg__ZTV7S7825C5__8S7825C228S7825C29__8S7825C38[3]),  3,5},
  {&(_tg__ZTV8S7825C12__8S7825C228S7825C29__8S7825C38[6]),  6,8},
  {&(_tg__ZTV8S7825C14__8S7825C228S7825C29__8S7825C38[3]),  3,5},
  {&(_tg__ZTV8S7825C15__8S7825C228S7825C29__8S7825C38[3]),  3,6},
  {&(_tg__ZTV8S7825C12__8S7825C29__8S7825C38[6]),  6,8},
  {&(_tg__ZTV7S7825C5__A1__8S7825C29__8S7825C38[3]),  3,5},
  {&(_tg__ZTV8S7825C14__8S7825C29__8S7825C38[3]),  3,5},
  {&(_tg__ZTV8S7825C158S7825C22__8S7825C29__8S7825C38[3]),  3,6},
  {&(_tg__ZTV8S7825C24__8S7825C38[5]),  5,8},
  {&(_tg__ZTV8S7825C258S7825C24__8S7825C38[4]),  4,6},
  {&(_tg__ZTV10S7825C8_nt__8S7825C258S7825C24__8S7825C38[3]),  3,5},
  {&(_tg__ZTV10S7825C8_nt__8S7825C24__8S7825C38[3]),  3,5},
  {&(_tg__ZTV7S7825C5__8S7825C24__8S7825C38[3]),  3,5},
  {&(_tg__ZTV8S7825C12__A__8S7825C38[5]),  5,7},
  {&(_tg__ZTV7S7825C5__A1__8S7825C12__A__8S7825C38[3]),  3,5},
  {&(_tg__ZTV8S7825C14__8S7825C12__A__8S7825C38[3]),  3,5},
  {&(_ZTV8S7825C38[58]),  58,80},
  {&(_ZTV8S7825C38[63]),  63,80},
  {&(_ZTV8S7825C38[68]),  68,80},
  {&(_ZTV8S7825C38[14]),  14,80},
  {&(_ZTV8S7825C38[38]),  38,80},
  {&(_ZTV8S7825C38[73]),  73,80},
  {&(_ZTV8S7825C38[78]),  78,80},
  {&(_ZTV8S7825C38[50]),  50,80},
  {&(_tg__ZTV8S7825C12__8S7825C38[5]),  5,7},
  {&(_tg__ZTV7S7825C5__A1__8S7825C12__8S7825C38[3]),  3,5},
  {&(_tg__ZTV8S7825C14__8S7825C12__8S7825C38[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S7825C38[];
extern  VTBL_ENTRY _ZTV8S7825C38[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C38[];
static VTBL_ENTRY alt_thunk_names18[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S7825C12D0Ev,_ZThn28_N8S7825C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C12D0Ev,_ZThn16_N8S7825C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn88_N8S7825C12D0Ev,_ZThn48_N8S7825C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn64_N8S7825C12D0Ev,_ZThn36_N8S7825C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S7825C12D1Ev,_ZThn28_N8S7825C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C12D1Ev,_ZThn16_N8S7825C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn88_N8S7825C12D1Ev,_ZThn48_N8S7825C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn64_N8S7825C12D1Ev,_ZThn36_N8S7825C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C24D0Ev,_ZTv0_n12_N8S7825C24D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N8S7825C24D0Ev,_ZThn52_N8S7825C24D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn136_N8S7825C24D0Ev,_ZThn72_N8S7825C24D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C24D1Ev,_ZTv0_n12_N8S7825C24D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N8S7825C24D1Ev,_ZThn52_N8S7825C24D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn136_N8S7825C24D1Ev,_ZThn72_N8S7825C24D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C25D0Ev,_ZTv0_n12_N8S7825C25D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn136_N8S7825C25D0Ev,_ZThn72_N8S7825C25D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C25D1Ev,_ZTv0_n12_N8S7825C25D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn136_N8S7825C25D1Ev,_ZThn72_N8S7825C25D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C29D0Ev,_ZTv0_n12_N8S7825C29D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn232_N8S7825C29D0Ev,_ZThn120_N8S7825C29D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn208_N8S7825C29D0Ev,_ZThn108_N8S7825C29D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C29D1Ev,_ZTv0_n12_N8S7825C29D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn232_N8S7825C29D1Ev,_ZThn120_N8S7825C29D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn208_N8S7825C29D1Ev,_ZThn108_N8S7825C29D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C29D0Ev,_ZTv0_n24_N8S7825C29D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7825C29D0Ev,_ZThn92_N8S7825C29D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C29D1Ev,_ZTv0_n24_N8S7825C29D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7825C29D1Ev,_ZThn92_N8S7825C29D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C22D0Ev,_ZTv0_n24_N8S7825C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7825C22D0Ev,_ZThn92_N8S7825C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C22D1Ev,_ZTv0_n24_N8S7825C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7825C22D1Ev,_ZThn92_N8S7825C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn232_N8S7825C22D0Ev,_ZThn120_N8S7825C22D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn208_N8S7825C22D0Ev,_ZThn108_N8S7825C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn232_N8S7825C22D1Ev,_ZThn120_N8S7825C22D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn208_N8S7825C22D1Ev,_ZThn108_N8S7825C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C38D0Ev,_ZTv0_n12_N8S7825C38D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn264_N8S7825C38D0Ev,_ZThn136_N8S7825C38D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn248_N8S7825C38D0Ev,_ZThn128_N8S7825C38D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn232_N8S7825C38D0Ev,_ZThn120_N8S7825C38D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn208_N8S7825C38D0Ev,_ZThn108_N8S7825C38D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C38D1Ev,_ZTv0_n12_N8S7825C38D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn264_N8S7825C38D1Ev,_ZThn136_N8S7825C38D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn248_N8S7825C38D1Ev,_ZThn128_N8S7825C38D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn232_N8S7825C38D1Ev,_ZThn120_N8S7825C38D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn208_N8S7825C38D1Ev,_ZThn108_N8S7825C38D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C38D0Ev,_ZTv0_n24_N8S7825C38D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7825C38D0Ev,_ZThn92_N8S7825C38D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C38D1Ev,_ZTv0_n24_N8S7825C38D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7825C38D1Ev,_ZThn92_N8S7825C38D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7825C38 = {  "S7825C38", // class name
  bases_S7825C38, 52,
  &(vtc_S7825C38[0]), // expected_vtbl_contents
  &(vtt_S7825C38[0]), // expected_vtt_contents
  ABISELECT(296,152), // object size
  NSPAIRA(_ZTI8S7825C38),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S7825C38),80, //virtual function table var
  9, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7825C38),31, //virtual table table var
  33, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names18,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C37  : virtual S7825C34 , S7825C13 , virtual S7825C38 , virtual S7825C15 {
  virtual  ~S7825C37(); // _ZN8S7825C37D2Ev
  S7825C37(); // tgen
};
//SIG(-1 S7825C37) C1{ VBC2{ VBC3{ m FC4{ BC5{ m} BC6{ m} BC7{ vd m Fc} vd Fp}} VBC6} BC8{ BC5 BC4 vd Fi} VBC9{ BC10{ VBC6 VBC11{ VBC6 BC8 VBC4 VBC12{ BC7 BC6} vd} BC13{ VBC4 VBC11 BC14{ vd m Fp} BC15{ BC6 BC12 BC7 BC4 VBC5 vd v1} BC12 vd} BC4} BC16{ BC17{ VBC7 BC12 VBC5 vd} BC14 VBC4 v2} VBC18{ BC14 Fc:7 Fp} BC11 vd Fi} VBC15 vd}


 S7825C37 ::~S7825C37(){ note_dtor("S7825C37", this);}
S7825C37 ::S7825C37(){ note_ctor("S7825C37", this);} // tgen

static void Test_S7825C37()
{
  extern Class_Descriptor cd_S7825C37;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(53,54)];
    init_test(&cd_S7825C37, buf);
    S7825C37 *dp, &lv = *(dp=new (buf) S7825C37());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(416,212), "sizeof(S7825C37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7825C37)");
    check_base_class_offset(lv, (S7825C32*)(S7825C34*), ABISELECT(40,20), "S7825C37");
    check_base_class_offset(lv, (S2407C27*)(S7825C34*), ABISELECT(64,32), "S7825C37");
    /*is_ambiguous_... S7825C29::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C29*)(S7825C38*), ABISELECT(64,32), "S7825C37");
    /*is_ambiguous_... S7825C37::S7825C12 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C12*), ABISELECT(64,32), "S7825C37");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C12*)(S7825C38*), ABISELECT(64,32), "S7825C37");
    check_base_class_offset(lv, (S7825C34*), ABISELECT(32,16), "S7825C37");
    /*is_ambiguous_... S7825C37::S7825C13 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C13*), ABISELECT(24,12), "S7825C37");
    /*is_ambiguous_... S7825C37::S7825C13 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C13*), 0, "S7825C37");
    /*is_ambiguous_... S7825C37::S7825C13 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C13*), 0, "S7825C37");
    /*is_ambiguous_... S7825C37::S7825C13 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C13*), 0, "S7825C37");
    /*is_ambiguous_... S7825C37::S7825C13 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C13*), 0, "S7825C37");
    /*is_ambiguous_... S7825C37::S7825C13 */ AMB_check_base_class_offset(lv, (S7825C13*), 0, "S7825C37");
    /*is_ambiguous_... S7825C37::S7825C12 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C13*)(S7825C12*), ABISELECT(264,136), "S7825C37");
    /*is_ambiguous_... S7825C37::S7825C12 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(240,124), "S7825C37");
    /*is_ambiguous_... S7825C37::S7825C12 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(240,124), "S7825C37");
    /*is_ambiguous_... S7825C37::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(240,124), "S7825C37");
    /*is_ambiguous_... S7825C37::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(240,124), "S7825C37");
    /*is_ambiguous_... S7825C37::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C13*)(S7825C12*), ABISELECT(240,124), "S7825C37");
    /*is_ambiguous_... S7825C37::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*), ABISELECT(272,140), "S7825C37");
    /*is_ambiguous_... S7825C37::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*), ABISELECT(272,140), "S7825C37");
    /*is_ambiguous_... S7825C37::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*), ABISELECT(272,140), "S7825C37");
    /*is_ambiguous_... S7825C37::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C12*), ABISELECT(272,140), "S7825C37");
    /*is_ambiguous_... S7825C22::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(272,140), "S7825C37");
    check_base_class_offset(lv, (S7825C5*)(S7825C24*)(S7825C38*), ABISELECT(272,140), "S7825C37");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C12*)(S7825C38*), ABISELECT(272,140), "S7825C37");
    /*is_ambiguous_... S7825C37::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*), ABISELECT(296,152), "S7825C37");
    /*is_ambiguous_... S7825C37::S7825C14 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C14*), ABISELECT(296,152), "S7825C37");
    /*is_ambiguous_... S7825C37::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C14*)(S7825C12*), ABISELECT(296,152), "S7825C37");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C14*)(S7825C12*)(S7825C38*), ABISELECT(296,152), "S7825C37");
    check_base_class_offset(lv, (S7825C12*)(S7825C29*)(S7825C38*), ABISELECT(240,124), "S7825C37");
    check_base_class_offset(lv, (S7825C12*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(240,124), "S7825C37");
    check_base_class_offset(lv, (S7825C23_nt*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(64,32), "S7825C37");
    /*is_ambiguous_... S7825C15::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C15*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(89,45), "S7825C37");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C15*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(80,40), "S7825C37");
    check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C15*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(80,40), "S7825C37");
    check_base_class_offset(lv, (S7825C14*)(S7825C15*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(80,40), "S7825C37");
    /*is_ambiguous_... S7825C15::S7825C8_nt */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C15*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(96,48), "S7825C37");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C15*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(112,56), "S7825C37");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C15*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(112,56), "S7825C37");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C15*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(112,56), "S7825C37");
    check_base_class_offset(lv, (S7825C5*)(S7825C15*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(112,56), "S7825C37");
    /*is_ambiguous_... S7825C15::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C15*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(305,157), "S7825C37");
    check_base_class_offset(lv, (S2407C30*)(S7825C25*)(S7825C24*)(S7825C38*), ABISELECT(305,157), "S7825C37");
    /*is_ambiguous_... S7825C37::S7825C15 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C15*), ABISELECT(305,157), "S7825C37");
    check_base_class_offset(lv, (S7825C15*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(80,40), "S7825C37");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(136,68), "S7825C37");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(136,68), "S7825C37");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C14*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(136,68), "S7825C37");
    check_base_class_offset(lv, (S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(64,32), "S7825C37");
    /*is_ambiguous_... S7825C29::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C29*)(S7825C38*), ABISELECT(152,76), "S7825C37");
    /*is_ambiguous_... S7825C29::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C29*)(S7825C38*), ABISELECT(152,76), "S7825C37");
    /*is_ambiguous_... S7825C29::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C29*)(S7825C38*), ABISELECT(152,76), "S7825C37");
    /*is_ambiguous_... S7825C29::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C29*)(S7825C38*), ABISELECT(152,76), "S7825C37");
    check_base_class_offset(lv, (S7825C29*)(S7825C38*), ABISELECT(64,32), "S7825C37");
    /*is_ambiguous_... S7825C25::S7825C8_nt */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C25*)(S7825C24*)(S7825C38*), ABISELECT(312,160), "S7825C37");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C25*)(S7825C24*)(S7825C38*), ABISELECT(176,88), "S7825C37");
    check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C25*)(S7825C24*)(S7825C38*), ABISELECT(176,88), "S7825C37");
    check_base_class_offset(lv, (S7825C14*)(S7825C25*)(S7825C24*)(S7825C38*), ABISELECT(176,88), "S7825C37");
    check_base_class_offset(lv, (S7825C25*)(S7825C24*)(S7825C38*), ABISELECT(176,88), "S7825C37");
    check_base_class_offset(lv, (S7825C23_nt*)(S7825C24*)(S7825C38*), ABISELECT(192,96), "S7825C37");
    check_base_class_offset(lv, (S7825C24*)(S7825C38*), ABISELECT(176,88), "S7825C37");
    check_base_class_offset(lv, (S7825C23_nt*)(S7825C26*), ABISELECT(328,168), "S7825C37");
    check_base_class_offset(lv, (S7825C26*)(S7825C38*), ABISELECT(328,168), "S7825C37");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C13*)(S7825C12*)(S7825C38*), ABISELECT(232,116), "S7825C37");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C13*)(S7825C12*)(S7825C38*), ABISELECT(208,104), "S7825C37");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C13*)(S7825C12*)(S7825C38*), ABISELECT(208,104), "S7825C37");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C13*)(S7825C12*)(S7825C38*), ABISELECT(208,104), "S7825C37");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C13*)(S7825C12*)(S7825C38*), ABISELECT(208,104), "S7825C37");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C13*)(S7825C12*)(S7825C38*), ABISELECT(208,104), "S7825C37");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C12*)(S7825C38*), ABISELECT(208,104), "S7825C37");
    check_base_class_offset(lv, (S7825C38*), ABISELECT(64,32), "S7825C37");
    /*is_ambiguous_... S7825C37::S7825C15 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C15*), ABISELECT(369,189), "S7825C37");
    /*is_ambiguous_... S7825C37::S7825C15 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C15*), ABISELECT(360,184), "S7825C37");
    /*is_ambiguous_... S7825C37::S7825C15 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C15*), ABISELECT(360,184), "S7825C37");
    /*is_ambiguous_... S7825C37::S7825C15 */ AMB_check_base_class_offset(lv, (S7825C14*)(S7825C15*), ABISELECT(360,184), "S7825C37");
    /*is_ambiguous_... S7825C37::S7825C15 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C15*), ABISELECT(376,192), "S7825C37");
    /*is_ambiguous_... S7825C37::S7825C15 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C15*), ABISELECT(392,200), "S7825C37");
    /*is_ambiguous_... S7825C37::S7825C15 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C15*), ABISELECT(392,200), "S7825C37");
    /*is_ambiguous_... S7825C37::S7825C15 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C15*), ABISELECT(392,200), "S7825C37");
    /*is_ambiguous_... S7825C37::S7825C15 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C15*), ABISELECT(392,200), "S7825C37");
    /*is_ambiguous_... S7825C37::S7825C15 */ AMB_check_base_class_offset(lv, (S7825C15*), ABISELECT(360,184), "S7825C37");
    test_class_info(&lv, &cd_S7825C37);
    dp->~S7825C37();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7825C37(Test_S7825C37, "S7825C37", ABISELECT(416,212));

#else // __cplusplus

extern void _ZN8S7825C37C1Ev();
extern void _ZN8S7825C37D2Ev();
Name_Map name_map_S7825C37[] = {
  NSPAIR(_ZN8S7825C37C1Ev),
  NSPAIR(_ZN8S7825C37D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7825C32;
extern VTBL_ENTRY _ZTI8S7825C32[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C34;
extern VTBL_ENTRY _ZTI8S7825C34[];
extern  VTBL_ENTRY _ZTV8S7825C34[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C34[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C13;
extern VTBL_ENTRY _ZTI8S7825C13[];
extern  VTBL_ENTRY _ZTV8S7825C13[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C13;
extern VTBL_ENTRY _ZTI8S7825C13[];
extern  VTBL_ENTRY _ZTV8S7825C13[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C12;
extern VTBL_ENTRY _ZTI8S7825C12[];
extern  VTBL_ENTRY _ZTV8S7825C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C12[];
extern Class_Descriptor cd_S7825C23_nt;
extern VTBL_ENTRY _ZTI11S7825C23_nt[];
extern  VTBL_ENTRY _ZTV11S7825C23_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S7825C15;
extern VTBL_ENTRY _ZTI8S7825C15[];
extern  VTBL_ENTRY _ZTV8S7825C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C15[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C22;
extern VTBL_ENTRY _ZTI8S7825C22[];
extern  VTBL_ENTRY _ZTV8S7825C22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C22[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C29;
extern VTBL_ENTRY _ZTI8S7825C29[];
extern  VTBL_ENTRY _ZTV8S7825C29[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C29[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C25;
extern VTBL_ENTRY _ZTI8S7825C25[];
extern  VTBL_ENTRY _ZTV8S7825C25[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C25[];
extern Class_Descriptor cd_S7825C23_nt;
extern VTBL_ENTRY _ZTI11S7825C23_nt[];
extern  VTBL_ENTRY _ZTV11S7825C23_nt[];
extern Class_Descriptor cd_S7825C24;
extern VTBL_ENTRY _ZTI8S7825C24[];
extern  VTBL_ENTRY _ZTV8S7825C24[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C24[];
extern Class_Descriptor cd_S7825C23_nt;
extern VTBL_ENTRY _ZTI11S7825C23_nt[];
extern  VTBL_ENTRY _ZTV11S7825C23_nt[];
extern Class_Descriptor cd_S7825C26;
extern VTBL_ENTRY _ZTI8S7825C26[];
extern  VTBL_ENTRY _ZTV8S7825C26[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C13;
extern VTBL_ENTRY _ZTI8S7825C13[];
extern  VTBL_ENTRY _ZTV8S7825C13[];
extern Class_Descriptor cd_S7825C12;
extern VTBL_ENTRY _ZTI8S7825C12[];
extern  VTBL_ENTRY _ZTV8S7825C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C12[];
extern Class_Descriptor cd_S7825C38;
extern VTBL_ENTRY _ZTI8S7825C38[];
extern  VTBL_ENTRY _ZTV8S7825C38[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C38[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C15;
extern VTBL_ENTRY _ZTI8S7825C15[];
extern  VTBL_ENTRY _ZTV8S7825C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C15[];
static Base_Class bases_S7825C37[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7825C32,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S2407C27,    ABISELECT(64,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S7825C34,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2407C30,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S2407C30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S2407C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    42, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S7825C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    43, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7825C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    44, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2407C30,    ABISELECT(264,136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(240,124), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(240,124), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(240,124), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(240,124), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S7825C13,    ABISELECT(240,124), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(272,140), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(272,140), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(272,140), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(272,140), //bcp->offset
    82, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    22, //immediately_derived
  0, 1},
  {&cd_S7825C8_nt,    ABISELECT(296,152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(296,152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(296,152), //bcp->offset
    87, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    22, //immediately_derived
  0, 1},
  {&cd_S7825C12,    ABISELECT(240,124), //bcp->offset
    74, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    49, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    38, //immediately_derived
  0, 1},
  {&cd_S7825C23_nt,    ABISELECT(64,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(89,45), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(80,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(80,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(80,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(96,48), //bcp->offset
    39, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(112,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(112,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(112,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(112,56), //bcp->offset
    43, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(305,157), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 1},
  {&cd_S7825C15,    ABISELECT(80,40), //bcp->offset
    33, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(136,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(136,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(136,68), //bcp->offset
    47, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S7825C22,    ABISELECT(64,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(152,76), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    42, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(152,76), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    42, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(152,76), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    42, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(152,76), //bcp->offset
    51, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S7825C29,    ABISELECT(64,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    60, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(312,160), //bcp->offset
    92, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    48, //immediately_derived
  0, 1},
  {&cd_S7825C8_nt,    ABISELECT(176,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    47, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(176,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    47, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(176,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    48, //immediately_derived
  0, 0},
  {&cd_S7825C25,    ABISELECT(176,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    50, //immediately_derived
  0, 0},
  {&cd_S7825C23_nt,    ABISELECT(192,96), //bcp->offset
    63, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    50, //immediately_derived
  0, 0},
  {&cd_S7825C24,    ABISELECT(176,88), //bcp->offset
    55, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    60, //immediately_derived
  0, 0},
  {&cd_S7825C23_nt,    ABISELECT(328,168), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    52, //immediately_derived
  0, 0},
  {&cd_S7825C26,    ABISELECT(328,168), //bcp->offset
    97, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    60, //immediately_derived
  0, 1},
  {&cd_S2407C30,    ABISELECT(232,116), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    58, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(208,104), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    57, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(208,104), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    57, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(208,104), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    57, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(208,104), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    58, //immediately_derived
  0, 0},
  {&cd_S7825C13,    ABISELECT(208,104), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    59, //immediately_derived
  0, 0},
  {&cd_S7825C12,    ABISELECT(208,104), //bcp->offset
    67, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    38, //bcp->base_subarray_index_in_construction_vtbl_array
    34, //init_seq
    60, //immediately_derived
  0, 0},
  {&cd_S7825C38,    ABISELECT(64,32), //bcp->offset
    19, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    35, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2407C27,    ABISELECT(369,189), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    70, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(360,184), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    36, //init_seq
    64, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(360,184), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    64, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(360,184), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    37, //init_seq
    70, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(376,192), //bcp->offset
    110, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    38, //init_seq
    70, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(392,200), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    69, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(392,200), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    69, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(392,200), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    39, //init_seq
    69, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(392,200), //bcp->offset
    114, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    40, //init_seq
    70, //immediately_derived
  0, 0},
  {&cd_S7825C15,    ABISELECT(360,184), //bcp->offset
    102, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    52, //bcp->base_subarray_index_in_construction_vtbl_array
    41, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7825C37[];
extern void _ZN8S7825C37D1Ev();
extern void _ZN8S7825C37D0Ev();
extern void ABISELECT(_ZTv0_n80_N8S7825C37D1Ev,_ZTv0_n40_N8S7825C37D1Ev)();
extern void ABISELECT(_ZThn64_N8S7825C37D1Ev,_ZThn32_N8S7825C37D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N8S7825C37D0Ev,_ZTv0_n40_N8S7825C37D0Ev)();
extern void ABISELECT(_ZThn64_N8S7825C37D0Ev,_ZThn32_N8S7825C37D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n80_N8S7825C37D1Ev,_ZTvn8_n40_N8S7825C37D1Ev)();
extern void ABISELECT(_ZTvn16_n80_N8S7825C37D0Ev,_ZTvn8_n40_N8S7825C37D0Ev)();
extern void _ZN8S7825C152v2Ev();
extern void ABISELECT(_ZTvn32_n80_N8S7825C37D1Ev,_ZTvn16_n40_N8S7825C37D1Ev)();
extern void ABISELECT(_ZTvn32_n80_N8S7825C37D0Ev,_ZTvn16_n40_N8S7825C37D0Ev)();
extern void ABISELECT(_ZTvn48_n80_N8S7825C37D1Ev,_ZTvn24_n40_N8S7825C37D1Ev)();
extern void ABISELECT(_ZTvn48_n80_N8S7825C37D0Ev,_ZTvn24_n40_N8S7825C37D0Ev)();
extern void ABISELECT(_ZTvn72_n80_N8S7825C37D1Ev,_ZTvn36_n40_N8S7825C37D1Ev)();
extern void ABISELECT(_ZTvn72_n80_N8S7825C37D0Ev,_ZTvn36_n40_N8S7825C37D0Ev)();
extern void ABISELECT(_ZTvn88_n80_N8S7825C37D1Ev,_ZTvn44_n40_N8S7825C37D1Ev)();
extern void ABISELECT(_ZTvn88_n80_N8S7825C37D0Ev,_ZTvn44_n40_N8S7825C37D0Ev)();
extern void ABISELECT(_ZTvn112_n80_N8S7825C37D1Ev,_ZTvn56_n40_N8S7825C37D1Ev)();
extern void ABISELECT(_ZTvn112_n80_N8S7825C37D0Ev,_ZTvn56_n40_N8S7825C37D0Ev)();
extern void _ZN8S7825C242v1Ev();
extern void ABISELECT(_ZTvn128_n80_N8S7825C37D1Ev,_ZTvn64_n40_N8S7825C37D1Ev)();
extern void ABISELECT(_ZTvn128_n80_N8S7825C37D0Ev,_ZTvn64_n40_N8S7825C37D0Ev)();
extern void ABISELECT(_ZTvn144_n80_N8S7825C37D1Ev,_ZTvn72_n40_N8S7825C37D1Ev)();
extern void ABISELECT(_ZTvn144_n80_N8S7825C37D0Ev,_ZTvn72_n40_N8S7825C37D0Ev)();
extern void ABISELECT(_ZTv0_n48_N8S7825C37D1Ev,_ZTv0_n24_N8S7825C37D1Ev)();
extern void ABISELECT(_ZThn240_N8S7825C37D1Ev,_ZThn124_N8S7825C37D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7825C37D0Ev,_ZTv0_n24_N8S7825C37D0Ev)();
extern void ABISELECT(_ZThn240_N8S7825C37D0Ev,_ZThn124_N8S7825C37D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C37D1Ev,_ZTv0_n12_N8S7825C37D1Ev)();
extern void ABISELECT(_ZThn272_N8S7825C37D1Ev,_ZThn140_N8S7825C37D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C37D0Ev,_ZTv0_n12_N8S7825C37D0Ev)();
extern void ABISELECT(_ZThn272_N8S7825C37D0Ev,_ZThn140_N8S7825C37D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C37D1Ev,_ZTv0_n12_N8S7825C37D1Ev)();
extern void ABISELECT(_ZThn296_N8S7825C37D1Ev,_ZThn152_N8S7825C37D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C37D0Ev,_ZTv0_n12_N8S7825C37D0Ev)();
extern void ABISELECT(_ZThn296_N8S7825C37D0Ev,_ZThn152_N8S7825C37D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C37D1Ev,_ZTv0_n12_N8S7825C37D1Ev)();
extern void ABISELECT(_ZThn312_N8S7825C37D1Ev,_ZThn160_N8S7825C37D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C37D0Ev,_ZTv0_n12_N8S7825C37D0Ev)();
extern void ABISELECT(_ZThn312_N8S7825C37D0Ev,_ZThn160_N8S7825C37D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C37D1Ev,_ZTv0_n12_N8S7825C37D1Ev)();
extern void ABISELECT(_ZThn328_N8S7825C37D1Ev,_ZThn168_N8S7825C37D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C37D0Ev,_ZTv0_n12_N8S7825C37D0Ev)();
extern void ABISELECT(_ZThn328_N8S7825C37D0Ev,_ZThn168_N8S7825C37D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7825C37D1Ev,_ZTv0_n16_N8S7825C37D1Ev)();
extern void ABISELECT(_ZThn360_N8S7825C37D1Ev,_ZThn184_N8S7825C37D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7825C37D0Ev,_ZTv0_n16_N8S7825C37D0Ev)();
extern void ABISELECT(_ZThn360_N8S7825C37D0Ev,_ZThn184_N8S7825C37D0Ev)() __attribute__((weak));
extern void _ZN8S7825C152v2Ev();
extern void ABISELECT(_ZTvn16_n32_N8S7825C37D1Ev,_ZTvn8_n16_N8S7825C37D1Ev)();
extern void ABISELECT(_ZTvn16_n32_N8S7825C37D0Ev,_ZTvn8_n16_N8S7825C37D0Ev)();
extern void ABISELECT(_ZTvn32_n32_N8S7825C37D1Ev,_ZTvn16_n16_N8S7825C37D1Ev)();
extern void ABISELECT(_ZTvn32_n32_N8S7825C37D0Ev,_ZTvn16_n16_N8S7825C37D0Ev)();
static  VTBL_ENTRY vtc_S7825C37[] = {
  ABISELECT(360,184),
  ABISELECT(328,168),
  ABISELECT(312,160),
  ABISELECT(305,157),
  ABISELECT(296,152),
  ABISELECT(272,140),
  ABISELECT(240,124),
  ABISELECT(64,32),
  ABISELECT(64,32),
  ABISELECT(40,20),
  ABISELECT(32,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&_ZN8S7825C37D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C37D0Ev,
  ABISELECT(32,16),
  ABISELECT(8,4),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  ABISELECT(112,56),
  ABISELECT(16,8),
  ABISELECT(-64,-32),
  ABISELECT(264,136),
  ABISELECT(248,128),
  ABISELECT(241,125),
  ABISELECT(232,120),
  0,
  ABISELECT(176,92),
  ABISELECT(208,108),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S7825C37D1Ev,_ZTv0_n40_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S7825C37D0Ev,_ZTv0_n40_N8S7825C37D0Ev),
  ABISELECT(225,117),
  ABISELECT(-80,-40),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n80_N8S7825C37D1Ev,_ZTvn8_n40_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n80_N8S7825C37D0Ev,_ZTvn8_n40_N8S7825C37D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
  ABISELECT(-96,-48),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n80_N8S7825C37D1Ev,_ZTvn16_n40_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n80_N8S7825C37D0Ev,_ZTvn16_n40_N8S7825C37D0Ev),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn48_n80_N8S7825C37D1Ev,_ZTvn24_n40_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn48_n80_N8S7825C37D0Ev,_ZTvn24_n40_N8S7825C37D0Ev),
  ABISELECT(-136,-68),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn72_n80_N8S7825C37D1Ev,_ZTvn36_n40_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn72_n80_N8S7825C37D0Ev,_ZTvn36_n40_N8S7825C37D0Ev),
  ABISELECT(-152,-76),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn88_n80_N8S7825C37D1Ev,_ZTvn44_n40_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn88_n80_N8S7825C37D0Ev,_ZTvn44_n40_N8S7825C37D0Ev),
  ABISELECT(96,52),
  ABISELECT(129,69),
  ABISELECT(136,72),
  ABISELECT(-176,-88),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n80_N8S7825C37D1Ev,_ZTvn56_n40_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n80_N8S7825C37D0Ev,_ZTvn56_n40_N8S7825C37D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C242v1Ev,
  ABISELECT(-192,-96),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn128_n80_N8S7825C37D1Ev,_ZTvn64_n40_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn128_n80_N8S7825C37D0Ev,_ZTvn64_n40_N8S7825C37D0Ev),
  ABISELECT(88,48),
  ABISELECT(64,36),
  ABISELECT(-144,-72),
  ABISELECT(-208,-104),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn144_n80_N8S7825C37D1Ev,_ZTvn72_n40_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn144_n80_N8S7825C37D0Ev,_ZTvn72_n40_N8S7825C37D0Ev),
  ABISELECT(-240,-124),
  ABISELECT(56,28),
  ABISELECT(32,16),
  ABISELECT(-176,-92),
  ABISELECT(-240,-124),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C37D1Ev,_ZTv0_n24_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C37D0Ev,_ZTv0_n24_N8S7825C37D0Ev),
  ABISELECT(-272,-140),
  ABISELECT(-272,-140),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C37D1Ev,_ZTv0_n12_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C37D0Ev,_ZTv0_n12_N8S7825C37D0Ev),
  ABISELECT(-296,-152),
  ABISELECT(-296,-152),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C37D1Ev,_ZTv0_n12_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C37D0Ev,_ZTv0_n12_N8S7825C37D0Ev),
  ABISELECT(-312,-160),
  ABISELECT(-312,-160),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C37D1Ev,_ZTv0_n12_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C37D0Ev,_ZTv0_n12_N8S7825C37D0Ev),
  ABISELECT(-328,-168),
  ABISELECT(-328,-168),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C37D1Ev,_ZTv0_n12_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C37D0Ev,_ZTv0_n12_N8S7825C37D0Ev),
  0,
  ABISELECT(-360,-184),
  ABISELECT(-55,-27),
  ABISELECT(-360,-184),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7825C37D1Ev,_ZTv0_n16_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7825C37D0Ev,_ZTv0_n16_N8S7825C37D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
  ABISELECT(-376,-192),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n32_N8S7825C37D1Ev,_ZTvn8_n16_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n32_N8S7825C37D0Ev,_ZTvn8_n16_N8S7825C37D0Ev),
  ABISELECT(-392,-200),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n32_N8S7825C37D1Ev,_ZTvn16_n16_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n32_N8S7825C37D0Ev,_ZTvn16_n16_N8S7825C37D0Ev),
};
extern VTBL_ENTRY _ZTV8S7825C37[];
static  VTBL_ENTRY _tg__ZTV8S7825C34__8S7825C37[] = {
  ABISELECT(32,16),
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C34[0]),
};
extern void _ZN8S7825C38D1Ev();
extern void _ZN8S7825C38D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C38__8S7825C37[] = {
  ABISELECT(264,136),
  ABISELECT(248,128),
  ABISELECT(241,125),
  ABISELECT(232,120),
  0,
  ABISELECT(176,92),
  ABISELECT(208,108),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C38[0]),
  (VTBL_ENTRY)&_ZN8S7825C38D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C38D0Ev,
};
extern void _ZN8S7825C29D1Ev();
extern void _ZN8S7825C29D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C298S7825C38__8S7825C37[] = {
  ABISELECT(241,125),
  ABISELECT(232,120),
  0,
  ABISELECT(176,92),
  ABISELECT(208,108),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C29[0]),
  (VTBL_ENTRY)&_ZN8S7825C29D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C29D0Ev,
};
extern void _ZN8S7825C22D1Ev();
extern void _ZN8S7825C22D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C228S7825C298S7825C38__8S7825C37[] = {
  ABISELECT(241,125),
  ABISELECT(232,120),
  0,
  ABISELECT(176,92),
  ABISELECT(208,108),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&_ZN8S7825C22D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C22D0Ev,
};
extern void _ZN8S7825C15D1Ev();
extern void _ZN8S7825C15D0Ev();
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C158S7825C228S7825C298S7825C38__8S7825C37[] = {
  ABISELECT(225,117),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C15[0]),
  (VTBL_ENTRY)&_ZN8S7825C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C15D0Ev,
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev)();
extern void ABISELECT(_ZThn208_N8S7825C22D1Ev,_ZThn108_N8S7825C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev)();
extern void ABISELECT(_ZThn208_N8S7825C22D0Ev,_ZThn108_N8S7825C22D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7825C5__8S7825C228S7825C298S7825C38__8S7825C37[] = {
  ABISELECT(-208,-108),
  ABISELECT(-208,-108),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev),
};
extern void ABISELECT(_ZTv0_n48_N8S7825C22D1Ev,_ZTv0_n24_N8S7825C22D1Ev)();
extern void ABISELECT(_ZThn176_N8S7825C22D1Ev,_ZThn92_N8S7825C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7825C22D0Ev,_ZTv0_n24_N8S7825C22D0Ev)();
extern void ABISELECT(_ZThn176_N8S7825C22D0Ev,_ZThn92_N8S7825C22D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C12__8S7825C228S7825C298S7825C38__8S7825C37[] = {
  ABISELECT(-176,-92),
  ABISELECT(56,28),
  ABISELECT(32,16),
  ABISELECT(-176,-92),
  ABISELECT(-176,-92),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C22D1Ev,_ZTv0_n24_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C22D0Ev,_ZTv0_n24_N8S7825C22D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev)();
extern void ABISELECT(_ZThn232_N8S7825C22D1Ev,_ZThn120_N8S7825C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev)();
extern void ABISELECT(_ZThn232_N8S7825C22D0Ev,_ZThn120_N8S7825C22D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C14__8S7825C228S7825C298S7825C38__8S7825C37[] = {
  ABISELECT(-232,-120),
  ABISELECT(-232,-120),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev),
};
extern void ABISELECT(_ZThn16_N8S7825C22D1Ev,_ZThn8_N8S7825C22D1Ev)();
extern void ABISELECT(_ZThn16_N8S7825C22D0Ev,_ZThn8_N8S7825C22D0Ev)();
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C15__8S7825C228S7825C298S7825C38__8S7825C37[] = {
  ABISELECT(225,117),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C22D1Ev,_ZThn8_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C22D0Ev,_ZThn8_N8S7825C22D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
extern void ABISELECT(_ZTv0_n48_N8S7825C29D1Ev,_ZTv0_n24_N8S7825C29D1Ev)();
extern void ABISELECT(_ZThn176_N8S7825C29D1Ev,_ZThn92_N8S7825C29D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7825C29D0Ev,_ZTv0_n24_N8S7825C29D0Ev)();
extern void ABISELECT(_ZThn176_N8S7825C29D0Ev,_ZThn92_N8S7825C29D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C12__8S7825C298S7825C38__8S7825C37[] = {
  ABISELECT(-176,-92),
  ABISELECT(56,28),
  ABISELECT(32,16),
  ABISELECT(-176,-92),
  ABISELECT(-176,-92),
  (VTBL_ENTRY)&(_ZTI8S7825C29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C29D1Ev,_ZTv0_n24_N8S7825C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C29D0Ev,_ZTv0_n24_N8S7825C29D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C29D1Ev,_ZTv0_n12_N8S7825C29D1Ev)();
extern void ABISELECT(_ZThn208_N8S7825C29D1Ev,_ZThn108_N8S7825C29D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C29D0Ev,_ZTv0_n12_N8S7825C29D0Ev)();
extern void ABISELECT(_ZThn208_N8S7825C29D0Ev,_ZThn108_N8S7825C29D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7825C5__A1__8S7825C298S7825C38__8S7825C37[] = {
  ABISELECT(-208,-108),
  ABISELECT(-208,-108),
  (VTBL_ENTRY)&(_ZTI8S7825C29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C29D1Ev,_ZTv0_n12_N8S7825C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C29D0Ev,_ZTv0_n12_N8S7825C29D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C29D1Ev,_ZTv0_n12_N8S7825C29D1Ev)();
extern void ABISELECT(_ZThn232_N8S7825C29D1Ev,_ZThn120_N8S7825C29D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C29D0Ev,_ZTv0_n12_N8S7825C29D0Ev)();
extern void ABISELECT(_ZThn232_N8S7825C29D0Ev,_ZThn120_N8S7825C29D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C14__8S7825C298S7825C38__8S7825C37[] = {
  ABISELECT(-232,-120),
  ABISELECT(-232,-120),
  (VTBL_ENTRY)&(_ZTI8S7825C29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C29D1Ev,_ZTv0_n12_N8S7825C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C29D0Ev,_ZTv0_n12_N8S7825C29D0Ev),
};
extern void ABISELECT(_ZThn16_N8S7825C29D1Ev,_ZThn8_N8S7825C29D1Ev)();
extern void ABISELECT(_ZThn16_N8S7825C29D0Ev,_ZThn8_N8S7825C29D0Ev)();
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C158S7825C22__8S7825C298S7825C38__8S7825C37[] = {
  ABISELECT(225,117),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S7825C29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C29D1Ev,_ZThn8_N8S7825C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C29D0Ev,_ZThn8_N8S7825C29D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
extern void _ZN8S7825C24D1Ev();
extern void _ZN8S7825C24D0Ev();
extern void _ZN8S7825C242v1Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C248S7825C38__8S7825C37[] = {
  ABISELECT(96,52),
  ABISELECT(129,69),
  ABISELECT(136,72),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C24[0]),
  (VTBL_ENTRY)&_ZN8S7825C24D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C24D0Ev,
  (VTBL_ENTRY)&_ZN8S7825C242v1Ev,
};
extern void _ZN8S7825C25D1Ev();
extern void _ZN8S7825C25D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C258S7825C248S7825C38__8S7825C37[] = {
  ABISELECT(129,69),
  ABISELECT(136,72),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C25[0]),
  (VTBL_ENTRY)&_ZN8S7825C25D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C25D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C25D1Ev,_ZTv0_n12_N8S7825C25D1Ev)();
extern void ABISELECT(_ZThn136_N8S7825C25D1Ev,_ZThn72_N8S7825C25D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C25D0Ev,_ZTv0_n12_N8S7825C25D0Ev)();
extern void ABISELECT(_ZThn136_N8S7825C25D0Ev,_ZThn72_N8S7825C25D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV10S7825C8_nt__8S7825C258S7825C248S7825C38__8S7825C37[] = {
  ABISELECT(-136,-72),
  ABISELECT(-136,-72),
  (VTBL_ENTRY)&(_ZTI8S7825C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C25D1Ev,_ZTv0_n12_N8S7825C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C25D0Ev,_ZTv0_n12_N8S7825C25D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C24D1Ev,_ZTv0_n12_N8S7825C24D1Ev)();
extern void ABISELECT(_ZThn136_N8S7825C24D1Ev,_ZThn72_N8S7825C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C24D0Ev,_ZTv0_n12_N8S7825C24D0Ev)();
extern void ABISELECT(_ZThn136_N8S7825C24D0Ev,_ZThn72_N8S7825C24D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV10S7825C8_nt__8S7825C248S7825C38__8S7825C37[] = {
  ABISELECT(-136,-72),
  ABISELECT(-136,-72),
  (VTBL_ENTRY)&(_ZTI8S7825C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C24D1Ev,_ZTv0_n12_N8S7825C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C24D0Ev,_ZTv0_n12_N8S7825C24D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C24D1Ev,_ZTv0_n12_N8S7825C24D1Ev)();
extern void ABISELECT(_ZThn96_N8S7825C24D1Ev,_ZThn52_N8S7825C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C24D0Ev,_ZTv0_n12_N8S7825C24D0Ev)();
extern void ABISELECT(_ZThn96_N8S7825C24D0Ev,_ZThn52_N8S7825C24D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7825C5__8S7825C248S7825C38__8S7825C37[] = {
  ABISELECT(-96,-52),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI8S7825C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C24D1Ev,_ZTv0_n12_N8S7825C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C24D0Ev,_ZTv0_n12_N8S7825C24D0Ev),
};
extern void _ZN8S7825C12D1Ev();
extern void _ZN8S7825C12D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C128S7825C38__A1__8S7825C37[] = {
  ABISELECT(88,48),
  ABISELECT(64,36),
  ABISELECT(-144,-72),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&_ZN8S7825C12D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C12D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZThn64_N8S7825C12D1Ev,_ZThn36_N8S7825C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
extern void ABISELECT(_ZThn64_N8S7825C12D0Ev,_ZThn36_N8S7825C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7825C5__A1__8S7825C128S7825C38__A1__8S7825C37[] = {
  ABISELECT(-64,-36),
  ABISELECT(-64,-36),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZThn88_N8S7825C12D1Ev,_ZThn48_N8S7825C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
extern void ABISELECT(_ZThn88_N8S7825C12D0Ev,_ZThn48_N8S7825C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C14__8S7825C128S7825C38__A1__8S7825C37[] = {
  ABISELECT(-88,-48),
  ABISELECT(-88,-48),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
};
extern void ABISELECT(_ZTv0_n48_N8S7825C38D1Ev,_ZTv0_n24_N8S7825C38D1Ev)();
extern void ABISELECT(_ZThn176_N8S7825C38D1Ev,_ZThn92_N8S7825C38D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7825C38D0Ev,_ZTv0_n24_N8S7825C38D0Ev)();
extern void ABISELECT(_ZThn176_N8S7825C38D0Ev,_ZThn92_N8S7825C38D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C12__8S7825C38__8S7825C37[] = {
  ABISELECT(-176,-92),
  ABISELECT(56,28),
  ABISELECT(32,16),
  ABISELECT(-176,-92),
  ABISELECT(-176,-92),
  (VTBL_ENTRY)&(_ZTI8S7825C38[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C38D1Ev,_ZTv0_n24_N8S7825C38D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C38D0Ev,_ZTv0_n24_N8S7825C38D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C38D1Ev,_ZTv0_n12_N8S7825C38D1Ev)();
extern void ABISELECT(_ZThn208_N8S7825C38D1Ev,_ZThn108_N8S7825C38D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C38D0Ev,_ZTv0_n12_N8S7825C38D0Ev)();
extern void ABISELECT(_ZThn208_N8S7825C38D0Ev,_ZThn108_N8S7825C38D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7825C5__A1__8S7825C38__8S7825C37[] = {
  ABISELECT(-208,-108),
  ABISELECT(-208,-108),
  (VTBL_ENTRY)&(_ZTI8S7825C38[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C38D1Ev,_ZTv0_n12_N8S7825C38D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C38D0Ev,_ZTv0_n12_N8S7825C38D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C38D1Ev,_ZTv0_n12_N8S7825C38D1Ev)();
extern void ABISELECT(_ZThn232_N8S7825C38D1Ev,_ZThn120_N8S7825C38D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C38D0Ev,_ZTv0_n12_N8S7825C38D0Ev)();
extern void ABISELECT(_ZThn232_N8S7825C38D0Ev,_ZThn120_N8S7825C38D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C14__8S7825C38__8S7825C37[] = {
  ABISELECT(-232,-120),
  ABISELECT(-232,-120),
  (VTBL_ENTRY)&(_ZTI8S7825C38[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C38D1Ev,_ZTv0_n12_N8S7825C38D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C38D0Ev,_ZTv0_n12_N8S7825C38D0Ev),
};
extern void ABISELECT(_ZThn16_N8S7825C38D1Ev,_ZThn8_N8S7825C38D1Ev)();
extern void ABISELECT(_ZThn16_N8S7825C38D0Ev,_ZThn8_N8S7825C38D0Ev)();
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C158S7825C228S7825C29__8S7825C38__8S7825C37[] = {
  ABISELECT(225,117),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S7825C38[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C38D1Ev,_ZThn8_N8S7825C38D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C38D0Ev,_ZThn8_N8S7825C38D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
extern void ABISELECT(_ZThn112_N8S7825C38D1Ev,_ZThn56_N8S7825C38D1Ev)();
extern void ABISELECT(_ZThn112_N8S7825C38D0Ev,_ZThn56_N8S7825C38D0Ev)();
extern void _ZN8S7825C242v1Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C24__8S7825C38__8S7825C37[] = {
  ABISELECT(96,52),
  ABISELECT(129,69),
  ABISELECT(136,72),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI8S7825C38[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N8S7825C38D1Ev,_ZThn56_N8S7825C38D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N8S7825C38D0Ev,_ZThn56_N8S7825C38D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C242v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C38D1Ev,_ZTv0_n12_N8S7825C38D1Ev)();
extern void ABISELECT(_ZThn248_N8S7825C38D1Ev,_ZThn128_N8S7825C38D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C38D0Ev,_ZTv0_n12_N8S7825C38D0Ev)();
extern void ABISELECT(_ZThn248_N8S7825C38D0Ev,_ZThn128_N8S7825C38D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV10S7825C8_nt__A8__8S7825C38__8S7825C37[] = {
  ABISELECT(-248,-128),
  ABISELECT(-248,-128),
  (VTBL_ENTRY)&(_ZTI8S7825C38[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C38D1Ev,_ZTv0_n12_N8S7825C38D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C38D0Ev,_ZTv0_n12_N8S7825C38D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C38D1Ev,_ZTv0_n12_N8S7825C38D1Ev)();
extern void ABISELECT(_ZThn264_N8S7825C38D1Ev,_ZThn136_N8S7825C38D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C38D0Ev,_ZTv0_n12_N8S7825C38D0Ev)();
extern void ABISELECT(_ZThn264_N8S7825C38D0Ev,_ZThn136_N8S7825C38D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C26__8S7825C38__8S7825C37[] = {
  ABISELECT(-264,-136),
  ABISELECT(-264,-136),
  (VTBL_ENTRY)&(_ZTI8S7825C38[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C38D1Ev,_ZTv0_n12_N8S7825C38D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C38D0Ev,_ZTv0_n12_N8S7825C38D0Ev),
};
extern void ABISELECT(_ZThn144_N8S7825C38D1Ev,_ZThn72_N8S7825C38D1Ev)();
extern void ABISELECT(_ZThn144_N8S7825C38D0Ev,_ZThn72_N8S7825C38D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S7825C12__A__8S7825C38__8S7825C37[] = {
  ABISELECT(88,48),
  ABISELECT(64,36),
  ABISELECT(-144,-72),
  ABISELECT(-144,-72),
  (VTBL_ENTRY)&(_ZTI8S7825C38[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N8S7825C38D1Ev,_ZThn72_N8S7825C38D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N8S7825C38D0Ev,_ZThn72_N8S7825C38D0Ev),
};
extern void _ZN8S7825C12D1Ev();
extern void _ZN8S7825C12D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C12__8S7825C37[] = {
  ABISELECT(56,28),
  ABISELECT(32,16),
  ABISELECT(-176,-92),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&_ZN8S7825C12D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C12D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZThn32_N8S7825C12D1Ev,_ZThn16_N8S7825C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
extern void ABISELECT(_ZThn32_N8S7825C12D0Ev,_ZThn16_N8S7825C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7825C5__A1__8S7825C12__8S7825C37[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZThn56_N8S7825C12D1Ev,_ZThn28_N8S7825C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
extern void ABISELECT(_ZThn56_N8S7825C12D0Ev,_ZThn28_N8S7825C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C14__8S7825C12__8S7825C37[] = {
  ABISELECT(-56,-28),
  ABISELECT(-56,-28),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
};
extern void _ZN8S7825C15D1Ev();
extern void _ZN8S7825C15D0Ev();
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C15__A1__8S7825C37[] = {
  ABISELECT(-55,-27),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C15[0]),
  (VTBL_ENTRY)&_ZN8S7825C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C15D0Ev,
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
static  VTT_ENTRY vtt_S7825C37[] = {
  {&(_ZTV8S7825C37[13]),  13,118},
  {&(_ZTV8S7825C37[19]),  19,118},
  {&(_ZTV8S7825C37[31]),  31,118},
  {&(_ZTV8S7825C37[80]),  80,118},
  {&(_ZTV8S7825C37[85]),  85,118},
  {&(_ZTV8S7825C37[90]),  90,118},
  {&(_ZTV8S7825C37[36]),  36,118},
  {&(_ZTV8S7825C37[41]),  41,118},
  {&(_ZTV8S7825C37[45]),  45,118},
  {&(_ZTV8S7825C37[49]),  49,118},
  {&(_ZTV8S7825C37[53]),  53,118},
  {&(_ZTV8S7825C37[60]),  60,118},
  {&(_ZTV8S7825C37[95]),  95,118},
  {&(_ZTV8S7825C37[65]),  65,118},
  {&(_ZTV8S7825C37[100]),  100,118},
  {&(_ZTV8S7825C37[72]),  72,118},
  {&(_ZTV8S7825C37[107]),  107,118},
  {&(_ZTV8S7825C37[112]),  112,118},
  {&(_ZTV8S7825C37[116]),  116,118},
  {&(_tg__ZTV8S7825C34__8S7825C37[4]),  4,4},
  {&(_tg__ZTV8S7825C38__8S7825C37[9]),  9,11},
  {&(_tg__ZTV8S7825C298S7825C38__8S7825C37[7]),  7,9},
  {&(_tg__ZTV8S7825C228S7825C298S7825C38__8S7825C37[7]),  7,9},
  {&(_tg__ZTV8S7825C158S7825C228S7825C298S7825C38__8S7825C37[3]),  3,6},
  {&(_tg__ZTV7S7825C5__8S7825C228S7825C298S7825C38__8S7825C37[3]),  3,5},
  {&(_tg__ZTV8S7825C12__8S7825C228S7825C298S7825C38__8S7825C37[6]),  6,8},
  {&(_tg__ZTV8S7825C14__8S7825C228S7825C298S7825C38__8S7825C37[3]),  3,5},
  {&(_tg__ZTV8S7825C15__8S7825C228S7825C298S7825C38__8S7825C37[3]),  3,6},
  {&(_tg__ZTV8S7825C12__8S7825C298S7825C38__8S7825C37[6]),  6,8},
  {&(_tg__ZTV7S7825C5__A1__8S7825C298S7825C38__8S7825C37[3]),  3,5},
  {&(_tg__ZTV8S7825C14__8S7825C298S7825C38__8S7825C37[3]),  3,5},
  {&(_tg__ZTV8S7825C158S7825C22__8S7825C298S7825C38__8S7825C37[3]),  3,6},
  {&(_tg__ZTV8S7825C248S7825C38__8S7825C37[5]),  5,8},
  {&(_tg__ZTV8S7825C258S7825C248S7825C38__8S7825C37[4]),  4,6},
  {&(_tg__ZTV10S7825C8_nt__8S7825C258S7825C248S7825C38__8S7825C37[3]),  3,5},
  {&(_tg__ZTV10S7825C8_nt__8S7825C248S7825C38__8S7825C37[3]),  3,5},
  {&(_tg__ZTV7S7825C5__8S7825C248S7825C38__8S7825C37[3]),  3,5},
  {&(_tg__ZTV8S7825C128S7825C38__A1__8S7825C37[5]),  5,7},
  {&(_tg__ZTV7S7825C5__A1__8S7825C128S7825C38__A1__8S7825C37[3]),  3,5},
  {&(_tg__ZTV8S7825C14__8S7825C128S7825C38__A1__8S7825C37[3]),  3,5},
  {&(_tg__ZTV8S7825C12__8S7825C38__8S7825C37[6]),  6,8},
  {&(_tg__ZTV7S7825C5__A1__8S7825C38__8S7825C37[3]),  3,5},
  {&(_tg__ZTV8S7825C14__8S7825C38__8S7825C37[3]),  3,5},
  {&(_tg__ZTV8S7825C158S7825C228S7825C29__8S7825C38__8S7825C37[3]),  3,6},
  {&(_tg__ZTV8S7825C24__8S7825C38__8S7825C37[5]),  5,8},
  {&(_tg__ZTV10S7825C8_nt__A8__8S7825C38__8S7825C37[3]),  3,5},
  {&(_tg__ZTV8S7825C26__8S7825C38__8S7825C37[3]),  3,5},
  {&(_tg__ZTV8S7825C12__A__8S7825C38__8S7825C37[5]),  5,7},
  {&(_tg__ZTV8S7825C12__8S7825C37[5]),  5,7},
  {&(_tg__ZTV7S7825C5__A1__8S7825C12__8S7825C37[3]),  3,5},
  {&(_tg__ZTV8S7825C14__8S7825C12__8S7825C37[3]),  3,5},
  {&(_tg__ZTV8S7825C15__A1__8S7825C37[3]),  3,6},
};
extern VTBL_ENTRY _ZTI8S7825C37[];
extern  VTBL_ENTRY _ZTV8S7825C37[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C37[];
static VTBL_ENTRY alt_thunk_names19[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C38D0Ev,_ZTv0_n12_N8S7825C38D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn264_N8S7825C38D0Ev,_ZThn136_N8S7825C38D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn248_N8S7825C38D0Ev,_ZThn128_N8S7825C38D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn232_N8S7825C38D0Ev,_ZThn120_N8S7825C38D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn208_N8S7825C38D0Ev,_ZThn108_N8S7825C38D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C38D1Ev,_ZTv0_n12_N8S7825C38D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn264_N8S7825C38D1Ev,_ZThn136_N8S7825C38D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn248_N8S7825C38D1Ev,_ZThn128_N8S7825C38D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn232_N8S7825C38D1Ev,_ZThn120_N8S7825C38D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn208_N8S7825C38D1Ev,_ZThn108_N8S7825C38D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C38D0Ev,_ZTv0_n24_N8S7825C38D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7825C38D0Ev,_ZThn92_N8S7825C38D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C38D1Ev,_ZTv0_n24_N8S7825C38D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7825C38D1Ev,_ZThn92_N8S7825C38D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S7825C12D0Ev,_ZThn28_N8S7825C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C12D0Ev,_ZThn16_N8S7825C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn88_N8S7825C12D0Ev,_ZThn48_N8S7825C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn64_N8S7825C12D0Ev,_ZThn36_N8S7825C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S7825C12D1Ev,_ZThn28_N8S7825C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C12D1Ev,_ZThn16_N8S7825C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn88_N8S7825C12D1Ev,_ZThn48_N8S7825C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn64_N8S7825C12D1Ev,_ZThn36_N8S7825C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C24D0Ev,_ZTv0_n12_N8S7825C24D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N8S7825C24D0Ev,_ZThn52_N8S7825C24D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn136_N8S7825C24D0Ev,_ZThn72_N8S7825C24D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C24D1Ev,_ZTv0_n12_N8S7825C24D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N8S7825C24D1Ev,_ZThn52_N8S7825C24D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn136_N8S7825C24D1Ev,_ZThn72_N8S7825C24D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C25D0Ev,_ZTv0_n12_N8S7825C25D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn136_N8S7825C25D0Ev,_ZThn72_N8S7825C25D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C25D1Ev,_ZTv0_n12_N8S7825C25D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn136_N8S7825C25D1Ev,_ZThn72_N8S7825C25D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C29D0Ev,_ZTv0_n12_N8S7825C29D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn232_N8S7825C29D0Ev,_ZThn120_N8S7825C29D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn208_N8S7825C29D0Ev,_ZThn108_N8S7825C29D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C29D1Ev,_ZTv0_n12_N8S7825C29D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn232_N8S7825C29D1Ev,_ZThn120_N8S7825C29D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn208_N8S7825C29D1Ev,_ZThn108_N8S7825C29D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C29D0Ev,_ZTv0_n24_N8S7825C29D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7825C29D0Ev,_ZThn92_N8S7825C29D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C29D1Ev,_ZTv0_n24_N8S7825C29D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7825C29D1Ev,_ZThn92_N8S7825C29D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C22D0Ev,_ZTv0_n24_N8S7825C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7825C22D0Ev,_ZThn92_N8S7825C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C22D1Ev,_ZTv0_n24_N8S7825C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S7825C22D1Ev,_ZThn92_N8S7825C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn232_N8S7825C22D0Ev,_ZThn120_N8S7825C22D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn208_N8S7825C22D0Ev,_ZThn108_N8S7825C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn232_N8S7825C22D1Ev,_ZThn120_N8S7825C22D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn208_N8S7825C22D1Ev,_ZThn108_N8S7825C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7825C37D0Ev,_ZTv0_n16_N8S7825C37D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn360_N8S7825C37D0Ev,_ZThn184_N8S7825C37D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7825C37D1Ev,_ZTv0_n16_N8S7825C37D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn360_N8S7825C37D1Ev,_ZThn184_N8S7825C37D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C37D0Ev,_ZTv0_n12_N8S7825C37D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn328_N8S7825C37D0Ev,_ZThn168_N8S7825C37D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn312_N8S7825C37D0Ev,_ZThn160_N8S7825C37D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn296_N8S7825C37D0Ev,_ZThn152_N8S7825C37D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn272_N8S7825C37D0Ev,_ZThn140_N8S7825C37D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C37D1Ev,_ZTv0_n12_N8S7825C37D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn328_N8S7825C37D1Ev,_ZThn168_N8S7825C37D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn312_N8S7825C37D1Ev,_ZThn160_N8S7825C37D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn296_N8S7825C37D1Ev,_ZThn152_N8S7825C37D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn272_N8S7825C37D1Ev,_ZThn140_N8S7825C37D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C37D0Ev,_ZTv0_n24_N8S7825C37D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn240_N8S7825C37D0Ev,_ZThn124_N8S7825C37D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C37D1Ev,_ZTv0_n24_N8S7825C37D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn240_N8S7825C37D1Ev,_ZThn124_N8S7825C37D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S7825C37D0Ev,_ZTv0_n40_N8S7825C37D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N8S7825C37D0Ev,_ZThn32_N8S7825C37D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S7825C37D1Ev,_ZTv0_n40_N8S7825C37D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N8S7825C37D1Ev,_ZThn32_N8S7825C37D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7825C37 = {  "S7825C37", // class name
  bases_S7825C37, 71,
  &(vtc_S7825C37[0]), // expected_vtbl_contents
  &(vtt_S7825C37[0]), // expected_vtt_contents
  ABISELECT(416,212), // object size
  NSPAIRA(_ZTI8S7825C37),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S7825C37),118, //virtual function table var
  13, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7825C37),52, //virtual table table var
  44, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names19,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C40_nt  {
  void  mf7825c40(); // _ZN11S7825C40_nt9mf7825c40Ev
};
//SIG(-1 S7825C40_nt) C1{ m}


void  S7825C40_nt ::mf7825c40(){}

//skip512 S7825C40_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI11S7825C40_nt[];
VTBL_ENTRY *P__ZTI11S7825C40_nt = _ZTI11S7825C40_nt; 
Class_Descriptor cd_S7825C40_nt = {  "S7825C40_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI11S7825C40_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C39  : S7825C22 , S7825C5 , virtual S7825C19 , S2407C27 , virtual S7825C40_nt {
  virtual  ~S7825C39(); // _ZN8S7825C39D2Ev
  S7825C39(); // tgen
};
//SIG(-1 S7825C39) C1{ BC2{ VBC3{ BC4{ m} BC5{ m} BC6{ vd m Fc} vd Fp} VBC7{ VBC5 BC8{ BC4 BC3 vd Fi} VBC3 VBC9{ BC6 BC5} vd} BC10{ vd m Fp} BC11{ BC5 BC9 BC6 BC3 VBC4 vd v1} BC9 vd} BC3 VBC12{ VBC13{ VBC4 VBC11 VBC5 BC9 VBC8 vd} FL} BC5 VBC14{ m} vd}


 S7825C39 ::~S7825C39(){ note_dtor("S7825C39", this);}
S7825C39 ::S7825C39(){ note_ctor("S7825C39", this);} // tgen

static void Test_S7825C39()
{
  extern Class_Descriptor cd_S7825C39;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(39,41)];
    init_test(&cd_S7825C39, buf);
    S7825C39 *dp, &lv = *(dp=new (buf) S7825C39());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,160), "sizeof(S7825C39)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7825C39)");
    /*is_ambiguous_... S7825C39::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*), ABISELECT(112,56), "S7825C39");
    /*is_ambiguous_... S7825C39::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*), ABISELECT(112,56), "S7825C39");
    /*is_ambiguous_... S7825C39::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*), ABISELECT(112,56), "S7825C39");
    /*is_ambiguous_... S7825C22::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C22*), ABISELECT(112,56), "S7825C39");
    /*is_ambiguous_... S7825C12::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C12*), ABISELECT(112,56), "S7825C39");
    /*is_ambiguous_... S7825C12::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C12*), ABISELECT(164,84), "S7825C39");
    /*is_ambiguous_... S7825C20::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C20*), ABISELECT(164,84), "S7825C39");
    /*is_ambiguous_... S7825C13::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C13*)(S7825C12*), ABISELECT(160,80), "S7825C39");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(136,68), "S7825C39");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(136,68), "S7825C39");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(136,68), "S7825C39");
    check_base_class_offset(lv, (S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(136,68), "S7825C39");
    check_base_class_offset(lv, (S7825C13*)(S7825C12*), ABISELECT(136,68), "S7825C39");
    /*is_ambiguous_... S7825C39::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*), ABISELECT(168,88), "S7825C39");
    /*is_ambiguous_... S7825C39::S7825C14 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C14*), ABISELECT(168,88), "S7825C39");
    check_base_class_offset(lv, (S7825C14*)(S7825C12*), ABISELECT(168,88), "S7825C39");
    check_base_class_offset(lv, (S7825C12*)(S7825C22*), ABISELECT(136,68), "S7825C39");
    check_base_class_offset(lv, (S7825C23_nt*)(S7825C22*), 0, "S7825C39");
    /*is_ambiguous_... S7825C15::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C15*)(S7825C22*), ABISELECT(25,13), "S7825C39");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C15*)(S7825C22*), ABISELECT(16,8), "S7825C39");
    check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C15*)(S7825C22*), ABISELECT(16,8), "S7825C39");
    check_base_class_offset(lv, (S7825C14*)(S7825C15*)(S7825C22*), ABISELECT(16,8), "S7825C39");
    /*is_ambiguous_... S7825C15::S7825C8_nt */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C15*)(S7825C22*), ABISELECT(32,16), "S7825C39");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C15*)(S7825C22*), ABISELECT(48,24), "S7825C39");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C15*)(S7825C22*), ABISELECT(48,24), "S7825C39");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C15*)(S7825C22*), ABISELECT(48,24), "S7825C39");
    check_base_class_offset(lv, (S7825C5*)(S7825C15*)(S7825C22*), ABISELECT(48,24), "S7825C39");
    /*is_ambiguous_... S7825C15::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C15*)(S7825C22*), 0, "S7825C39");
    /*is_ambiguous_... S7825C20::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C20*), 0, "S7825C39");
    /*is_ambiguous_... S7825C39::S7825C15 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C15*), 0, "S7825C39");
    check_base_class_offset(lv, (S7825C15*)(S7825C22*), ABISELECT(16,8), "S7825C39");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C22*), ABISELECT(72,36), "S7825C39");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C22*), ABISELECT(72,36), "S7825C39");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C14*)(S7825C22*), ABISELECT(72,36), "S7825C39");
    check_base_class_offset(lv, (S7825C22*), 0, "S7825C39");
    /*is_ambiguous_... S7825C39::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*), ABISELECT(88,44), "S7825C39");
    /*is_ambiguous_... S7825C39::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*), ABISELECT(88,44), "S7825C39");
    /*is_ambiguous_... S7825C39::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*), ABISELECT(88,44), "S7825C39");
    /*is_ambiguous_... S7825C39::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C5*), ABISELECT(88,44), "S7825C39");
    /*is_ambiguous_... S7825C39::S7825C15 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C15*), ABISELECT(225,121), "S7825C39");
    /*is_ambiguous_... S7825C39::S7825C15 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C15*), ABISELECT(216,116), "S7825C39");
    /*is_ambiguous_... S7825C39::S7825C15 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C15*), ABISELECT(216,116), "S7825C39");
    /*is_ambiguous_... S7825C39::S7825C15 */ AMB_check_base_class_offset(lv, (S7825C14*)(S7825C15*), ABISELECT(216,116), "S7825C39");
    /*is_ambiguous_... S7825C39::S7825C15 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C15*), ABISELECT(232,124), "S7825C39");
    /*is_ambiguous_... S7825C39::S7825C15 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C15*), ABISELECT(248,132), "S7825C39");
    /*is_ambiguous_... S7825C39::S7825C15 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C15*), ABISELECT(248,132), "S7825C39");
    /*is_ambiguous_... S7825C39::S7825C15 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C15*), ABISELECT(248,132), "S7825C39");
    /*is_ambiguous_... S7825C39::S7825C15 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C15*), ABISELECT(248,132), "S7825C39");
    check_base_class_offset(lv, (S7825C15*)(S7825C20*), ABISELECT(216,116), "S7825C39");
    /*is_ambiguous_... S7825C20::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C20*), ABISELECT(200,108), "S7825C39");
    /*is_ambiguous_... S7825C20::S7825C14 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C20*), ABISELECT(200,108), "S7825C39");
    /*is_ambiguous_... S7825C20::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C14*)(S7825C20*), ABISELECT(200,108), "S7825C39");
    /*is_ambiguous_... S7825C39::S7825C13 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C13*), ABISELECT(296,156), "S7825C39");
    /*is_ambiguous_... S7825C39::S7825C13 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C13*), ABISELECT(272,144), "S7825C39");
    /*is_ambiguous_... S7825C39::S7825C13 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C13*), ABISELECT(272,144), "S7825C39");
    /*is_ambiguous_... S7825C39::S7825C13 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C13*), ABISELECT(272,144), "S7825C39");
    /*is_ambiguous_... S7825C39::S7825C13 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C13*), ABISELECT(272,144), "S7825C39");
    check_base_class_offset(lv, (S7825C13*)(S7825C20*), ABISELECT(272,144), "S7825C39");
    check_base_class_offset(lv, (S7825C20*)(S7825C19*), ABISELECT(200,108), "S7825C39");
    check_base_class_offset(lv, (S7825C19*), ABISELECT(184,96), "S7825C39");
    /*is_ambiguous_... S7825C39::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*), 0, "S7825C39");
    check_base_class_offset(lv, (S7825C40_nt*), 0, "S7825C39");
    test_class_info(&lv, &cd_S7825C39);
    dp->~S7825C39();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7825C39(Test_S7825C39, "S7825C39", ABISELECT(304,160));

#else // __cplusplus

extern void _ZN8S7825C39C1Ev();
extern void _ZN8S7825C39D2Ev();
Name_Map name_map_S7825C39[] = {
  NSPAIR(_ZN8S7825C39C1Ev),
  NSPAIR(_ZN8S7825C39D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C13;
extern VTBL_ENTRY _ZTI8S7825C13[];
extern  VTBL_ENTRY _ZTV8S7825C13[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C12;
extern VTBL_ENTRY _ZTI8S7825C12[];
extern  VTBL_ENTRY _ZTV8S7825C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C12[];
extern Class_Descriptor cd_S7825C23_nt;
extern VTBL_ENTRY _ZTI11S7825C23_nt[];
extern  VTBL_ENTRY _ZTV11S7825C23_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S7825C15;
extern VTBL_ENTRY _ZTI8S7825C15[];
extern  VTBL_ENTRY _ZTV8S7825C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C15[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C22;
extern VTBL_ENTRY _ZTI8S7825C22[];
extern  VTBL_ENTRY _ZTV8S7825C22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C22[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C15;
extern VTBL_ENTRY _ZTI8S7825C15[];
extern  VTBL_ENTRY _ZTV8S7825C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C15[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C13;
extern VTBL_ENTRY _ZTI8S7825C13[];
extern  VTBL_ENTRY _ZTV8S7825C13[];
extern Class_Descriptor cd_S7825C20;
extern VTBL_ENTRY _ZTI8S7825C20[];
extern  VTBL_ENTRY _ZTV8S7825C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C20[];
extern Class_Descriptor cd_S7825C19;
extern VTBL_ENTRY _ZTI8S7825C19[];
extern  VTBL_ENTRY _ZTV8S7825C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C19[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C40_nt;
extern VTBL_ENTRY _ZTI11S7825C40_nt[];
static Base_Class bases_S7825C39[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2407C30,    ABISELECT(112,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(112,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(112,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(112,56), //bcp->offset
    36, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S2407C27,    ABISELECT(164,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S2407C30,    ABISELECT(160,80), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(136,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(136,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(136,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(136,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7825C13,    ABISELECT(136,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(168,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(168,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(168,88), //bcp->offset
    49, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S7825C12,    ABISELECT(136,68), //bcp->offset
    41, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    30, //immediately_derived
  0, 1},
  {&cd_S7825C23_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(25,13), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(32,16), //bcp->offset
    20, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(48,24), //bcp->offset
    24, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S2407C30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    26, //immediately_derived
  0, 1},
  {&cd_S7825C15,    ABISELECT(16,8), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(72,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(72,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(72,36), //bcp->offset
    28, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S7825C22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2407C30,    ABISELECT(88,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(88,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(88,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(88,44), //bcp->offset
    32, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2407C27,    ABISELECT(225,121), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(216,116), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(216,116), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(216,116), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(232,124), //bcp->offset
    81, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(248,132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(248,132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(248,132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(248,132), //bcp->offset
    85, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S7825C15,    ABISELECT(216,116), //bcp->offset
    73, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    54, //immediately_derived
  0, 1},
  {&cd_S7825C8_nt,    ABISELECT(200,108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    47, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(200,108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    47, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(200,108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    54, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(296,156), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    53, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(272,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    52, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(272,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    52, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(272,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    52, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(272,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    53, //immediately_derived
  0, 0},
  {&cd_S7825C13,    ABISELECT(272,144), //bcp->offset
    89, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    54, //immediately_derived
  0, 1},
  {&cd_S7825C20,    ABISELECT(200,108), //bcp->offset
    64, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    27, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    55, //immediately_derived
  0, 1},
  {&cd_S7825C19,    ABISELECT(184,96), //bcp->offset
    54, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2407C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7825C40_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7825C39[];
extern void _ZN8S7825C39D1Ev();
extern void _ZN8S7825C39D0Ev();
extern void ABISELECT(_ZThn16_N8S7825C39D1Ev,_ZThn8_N8S7825C39D1Ev)();
extern void ABISELECT(_ZThn16_N8S7825C39D0Ev,_ZThn8_N8S7825C39D0Ev)();
extern void _ZN8S7825C152v2Ev();
extern void ABISELECT(_ZThn32_N8S7825C39D1Ev,_ZThn16_N8S7825C39D1Ev)();
extern void ABISELECT(_ZThn32_N8S7825C39D0Ev,_ZThn16_N8S7825C39D0Ev)();
extern void ABISELECT(_ZThn48_N8S7825C39D1Ev,_ZThn24_N8S7825C39D1Ev)();
extern void ABISELECT(_ZThn48_N8S7825C39D0Ev,_ZThn24_N8S7825C39D0Ev)();
extern void ABISELECT(_ZThn72_N8S7825C39D1Ev,_ZThn36_N8S7825C39D1Ev)();
extern void ABISELECT(_ZThn72_N8S7825C39D0Ev,_ZThn36_N8S7825C39D0Ev)();
extern void ABISELECT(_ZThn88_N8S7825C39D1Ev,_ZThn44_N8S7825C39D1Ev)();
extern void ABISELECT(_ZThn88_N8S7825C39D0Ev,_ZThn44_N8S7825C39D0Ev)();
extern void ABISELECT(_ZTv0_n24_N8S7825C39D1Ev,_ZTv0_n12_N8S7825C39D1Ev)();
extern void ABISELECT(_ZThn112_N8S7825C39D1Ev,_ZThn56_N8S7825C39D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C39D0Ev,_ZTv0_n12_N8S7825C39D0Ev)();
extern void ABISELECT(_ZThn112_N8S7825C39D0Ev,_ZThn56_N8S7825C39D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7825C39D1Ev,_ZTv0_n24_N8S7825C39D1Ev)();
extern void ABISELECT(_ZThn136_N8S7825C39D1Ev,_ZThn68_N8S7825C39D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7825C39D0Ev,_ZTv0_n24_N8S7825C39D0Ev)();
extern void ABISELECT(_ZThn136_N8S7825C39D0Ev,_ZThn68_N8S7825C39D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C39D1Ev,_ZTv0_n12_N8S7825C39D1Ev)();
extern void ABISELECT(_ZThn168_N8S7825C39D1Ev,_ZThn88_N8S7825C39D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C39D0Ev,_ZTv0_n12_N8S7825C39D0Ev)();
extern void ABISELECT(_ZThn168_N8S7825C39D0Ev,_ZThn88_N8S7825C39D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S7825C39D1Ev,_ZTv0_n32_N8S7825C39D1Ev)();
extern void ABISELECT(_ZThn184_N8S7825C39D1Ev,_ZThn96_N8S7825C39D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S7825C39D0Ev,_ZTv0_n32_N8S7825C39D0Ev)();
extern void ABISELECT(_ZThn184_N8S7825C39D0Ev,_ZThn96_N8S7825C39D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7825C39D1Ev,_ZTv0_n28_N8S7825C39D1Ev)();
extern void ABISELECT(_ZThn200_N8S7825C39D1Ev,_ZThn108_N8S7825C39D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7825C39D0Ev,_ZTv0_n28_N8S7825C39D0Ev)();
extern void ABISELECT(_ZThn200_N8S7825C39D0Ev,_ZThn108_N8S7825C39D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7825C39D1Ev,_ZTv0_n16_N8S7825C39D1Ev)();
extern void ABISELECT(_ZThn216_N8S7825C39D1Ev,_ZThn116_N8S7825C39D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7825C39D0Ev,_ZTv0_n16_N8S7825C39D0Ev)();
extern void ABISELECT(_ZThn216_N8S7825C39D0Ev,_ZThn116_N8S7825C39D0Ev)() __attribute__((weak));
extern void _ZN8S7825C152v2Ev();
extern void ABISELECT(_ZTvn16_n32_N8S7825C39D1Ev,_ZTvn8_n16_N8S7825C39D1Ev)();
extern void ABISELECT(_ZTvn16_n32_N8S7825C39D0Ev,_ZTvn8_n16_N8S7825C39D0Ev)();
extern void ABISELECT(_ZTvn32_n32_N8S7825C39D1Ev,_ZTvn16_n16_N8S7825C39D1Ev)();
extern void ABISELECT(_ZTvn32_n32_N8S7825C39D0Ev,_ZTvn16_n16_N8S7825C39D0Ev)();
extern void ABISELECT(_ZTv0_n24_N8S7825C39D1Ev,_ZTv0_n12_N8S7825C39D1Ev)();
extern void ABISELECT(_ZThn272_N8S7825C39D1Ev,_ZThn144_N8S7825C39D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C39D0Ev,_ZTv0_n12_N8S7825C39D0Ev)();
extern void ABISELECT(_ZThn272_N8S7825C39D0Ev,_ZThn144_N8S7825C39D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7825C39[] = {
  0,
  ABISELECT(272,144),
  ABISELECT(216,116),
  ABISELECT(200,108),
  ABISELECT(184,96),
  0,
  ABISELECT(168,88),
  ABISELECT(164,84),
  ABISELECT(136,68),
  ABISELECT(112,56),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C39[0]),
  (VTBL_ENTRY)&_ZN8S7825C39D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C39D0Ev,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S7825C39[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C39D1Ev,_ZThn8_N8S7825C39D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C39D0Ev,_ZThn8_N8S7825C39D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S7825C39[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S7825C39D1Ev,_ZThn16_N8S7825C39D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S7825C39D0Ev,_ZThn16_N8S7825C39D0Ev),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S7825C39[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N8S7825C39D1Ev,_ZThn24_N8S7825C39D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N8S7825C39D0Ev,_ZThn24_N8S7825C39D0Ev),
  ABISELECT(-72,-36),
  (VTBL_ENTRY)&(_ZTI8S7825C39[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N8S7825C39D1Ev,_ZThn36_N8S7825C39D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N8S7825C39D0Ev,_ZThn36_N8S7825C39D0Ev),
  ABISELECT(-88,-44),
  (VTBL_ENTRY)&(_ZTI8S7825C39[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn88_N8S7825C39D1Ev,_ZThn44_N8S7825C39D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn88_N8S7825C39D0Ev,_ZThn44_N8S7825C39D0Ev),
  ABISELECT(-112,-56),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI8S7825C39[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C39D1Ev,_ZTv0_n12_N8S7825C39D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C39D0Ev,_ZTv0_n12_N8S7825C39D0Ev),
  ABISELECT(-136,-68),
  ABISELECT(32,20),
  ABISELECT(-24,-12),
  ABISELECT(28,16),
  ABISELECT(-136,-68),
  (VTBL_ENTRY)&(_ZTI8S7825C39[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C39D1Ev,_ZTv0_n24_N8S7825C39D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C39D0Ev,_ZTv0_n24_N8S7825C39D0Ev),
  ABISELECT(-168,-88),
  ABISELECT(-168,-88),
  (VTBL_ENTRY)&(_ZTI8S7825C39[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C39D1Ev,_ZTv0_n12_N8S7825C39D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C39D0Ev,_ZTv0_n12_N8S7825C39D0Ev),
  ABISELECT(-184,-96),
  ABISELECT(88,48),
  ABISELECT(-20,-12),
  ABISELECT(32,20),
  ABISELECT(-184,-96),
  ABISELECT(16,12),
  ABISELECT(-184,-96),
  (VTBL_ENTRY)&(_ZTI8S7825C39[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7825C39D1Ev,_ZTv0_n32_N8S7825C39D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7825C39D0Ev,_ZTv0_n32_N8S7825C39D0Ev),
  ABISELECT(-200,-108),
  ABISELECT(72,36),
  ABISELECT(-36,-24),
  ABISELECT(16,8),
  ABISELECT(-200,-108),
  ABISELECT(-200,-108),
  (VTBL_ENTRY)&(_ZTI8S7825C39[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7825C39D1Ev,_ZTv0_n28_N8S7825C39D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7825C39D0Ev,_ZTv0_n28_N8S7825C39D0Ev),
  0,
  ABISELECT(-216,-116),
  ABISELECT(-216,-116),
  ABISELECT(-216,-116),
  (VTBL_ENTRY)&(_ZTI8S7825C39[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7825C39D1Ev,_ZTv0_n16_N8S7825C39D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7825C39D0Ev,_ZTv0_n16_N8S7825C39D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
  ABISELECT(-232,-124),
  (VTBL_ENTRY)&(_ZTI8S7825C39[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n32_N8S7825C39D1Ev,_ZTvn8_n16_N8S7825C39D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n32_N8S7825C39D0Ev,_ZTvn8_n16_N8S7825C39D0Ev),
  ABISELECT(-248,-132),
  (VTBL_ENTRY)&(_ZTI8S7825C39[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n32_N8S7825C39D1Ev,_ZTvn16_n16_N8S7825C39D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n32_N8S7825C39D0Ev,_ZTvn16_n16_N8S7825C39D0Ev),
  ABISELECT(-272,-144),
  ABISELECT(-272,-144),
  (VTBL_ENTRY)&(_ZTI8S7825C39[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C39D1Ev,_ZTv0_n12_N8S7825C39D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C39D0Ev,_ZTv0_n12_N8S7825C39D0Ev),
};
extern VTBL_ENTRY _ZTV8S7825C39[];
extern void _ZN8S7825C22D1Ev();
extern void _ZN8S7825C22D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C22__8S7825C39[] = {
  0,
  ABISELECT(168,88),
  ABISELECT(164,84),
  ABISELECT(136,68),
  ABISELECT(112,56),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&_ZN8S7825C22D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C22D0Ev,
};
extern void _ZN8S7825C15D1Ev();
extern void _ZN8S7825C15D0Ev();
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C158S7825C22__8S7825C39[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C15[0]),
  (VTBL_ENTRY)&_ZN8S7825C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C15D0Ev,
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev)();
extern void ABISELECT(_ZThn112_N8S7825C22D1Ev,_ZThn56_N8S7825C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev)();
extern void ABISELECT(_ZThn112_N8S7825C22D0Ev,_ZThn56_N8S7825C22D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7825C5__8S7825C22__8S7825C39[] = {
  ABISELECT(-112,-56),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev),
};
extern void ABISELECT(_ZTv0_n48_N8S7825C22D1Ev,_ZTv0_n24_N8S7825C22D1Ev)();
extern void ABISELECT(_ZThn136_N8S7825C22D1Ev,_ZThn68_N8S7825C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7825C22D0Ev,_ZTv0_n24_N8S7825C22D0Ev)();
extern void ABISELECT(_ZThn136_N8S7825C22D0Ev,_ZThn68_N8S7825C22D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C12__8S7825C22__8S7825C39[] = {
  ABISELECT(-136,-68),
  ABISELECT(32,20),
  ABISELECT(-24,-12),
  ABISELECT(28,16),
  ABISELECT(-136,-68),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C22D1Ev,_ZTv0_n24_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C22D0Ev,_ZTv0_n24_N8S7825C22D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev)();
extern void ABISELECT(_ZThn168_N8S7825C22D1Ev,_ZThn88_N8S7825C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev)();
extern void ABISELECT(_ZThn168_N8S7825C22D0Ev,_ZThn88_N8S7825C22D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C14__8S7825C22__8S7825C39[] = {
  ABISELECT(-168,-88),
  ABISELECT(-168,-88),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev),
};
extern void ABISELECT(_ZThn16_N8S7825C22D1Ev,_ZThn8_N8S7825C22D1Ev)();
extern void ABISELECT(_ZThn16_N8S7825C22D0Ev,_ZThn8_N8S7825C22D0Ev)();
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C15__8S7825C22__8S7825C39[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S7825C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C22D1Ev,_ZThn8_N8S7825C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S7825C22D0Ev,_ZThn8_N8S7825C22D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
extern void _ZN8S7825C12D1Ev();
extern void _ZN8S7825C12D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C12__8S7825C39[] = {
  ABISELECT(32,20),
  ABISELECT(-24,-12),
  ABISELECT(28,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&_ZN8S7825C12D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C12D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S7825C5__A1__8S7825C12__8S7825C39[] = {
  ABISELECT(24,12),
  ABISELECT(24,12),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZThn32_N8S7825C12D1Ev,_ZThn20_N8S7825C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
extern void ABISELECT(_ZThn32_N8S7825C12D0Ev,_ZThn20_N8S7825C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C14__8S7825C12__8S7825C39[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
};
extern void _ZN8S7825C19D1Ev();
extern void _ZN8S7825C19D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C19__8S7825C39[] = {
  ABISELECT(88,48),
  ABISELECT(-20,-12),
  ABISELECT(32,20),
  ABISELECT(-184,-96),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C19[0]),
  (VTBL_ENTRY)&_ZN8S7825C19D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C19D0Ev,
};
extern void ABISELECT(_ZTv0_n56_N8S7825C19D1Ev,_ZTv0_n28_N8S7825C19D1Ev)();
extern void ABISELECT(_ZThn16_N8S7825C19D1Ev,_ZThn12_N8S7825C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7825C19D0Ev,_ZTv0_n28_N8S7825C19D0Ev)();
extern void ABISELECT(_ZThn16_N8S7825C19D0Ev,_ZThn12_N8S7825C19D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C20__8S7825C19__8S7825C39[] = {
  ABISELECT(-16,-12),
  ABISELECT(72,36),
  ABISELECT(-36,-24),
  ABISELECT(16,8),
  ABISELECT(-200,-108),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8S7825C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7825C19D1Ev,_ZTv0_n28_N8S7825C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7825C19D0Ev,_ZTv0_n28_N8S7825C19D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S7825C19D1Ev,_ZTv0_n16_N8S7825C19D1Ev)();
extern void ABISELECT(_ZThn32_N8S7825C19D1Ev,_ZThn20_N8S7825C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7825C19D0Ev,_ZTv0_n16_N8S7825C19D0Ev)();
extern void ABISELECT(_ZThn32_N8S7825C19D0Ev,_ZThn20_N8S7825C19D0Ev)() __attribute__((weak));
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C15__8S7825C19__8S7825C39[] = {
  0,
  ABISELECT(-32,-20),
  ABISELECT(-216,-116),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI8S7825C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7825C19D1Ev,_ZTv0_n16_N8S7825C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7825C19D0Ev,_ZTv0_n16_N8S7825C19D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
extern void ABISELECT(_ZTvn16_n32_N8S7825C19D1Ev,_ZTvn8_n16_N8S7825C19D1Ev)();
extern void ABISELECT(_ZTvn16_n32_N8S7825C19D0Ev,_ZTvn8_n16_N8S7825C19D0Ev)();
static  VTBL_ENTRY _tg__ZTV10S7825C8_nt8S7825C15__A1__8S7825C19__8S7825C39[] = {
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI8S7825C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n32_N8S7825C19D1Ev,_ZTvn8_n16_N8S7825C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n32_N8S7825C19D0Ev,_ZTvn8_n16_N8S7825C19D0Ev),
};
extern void ABISELECT(_ZTvn32_n32_N8S7825C19D1Ev,_ZTvn16_n16_N8S7825C19D1Ev)();
extern void ABISELECT(_ZTvn32_n32_N8S7825C19D0Ev,_ZTvn16_n16_N8S7825C19D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S7825C58S7825C15__8S7825C19__8S7825C39[] = {
  ABISELECT(-64,-36),
  (VTBL_ENTRY)&(_ZTI8S7825C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n32_N8S7825C19D1Ev,_ZTvn16_n16_N8S7825C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n32_N8S7825C19D0Ev,_ZTvn16_n16_N8S7825C19D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C19D1Ev,_ZTv0_n12_N8S7825C19D1Ev)();
extern void ABISELECT(_ZThn88_N8S7825C19D1Ev,_ZThn48_N8S7825C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C19D0Ev,_ZTv0_n12_N8S7825C19D0Ev)();
extern void ABISELECT(_ZThn88_N8S7825C19D0Ev,_ZThn48_N8S7825C19D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C13__8S7825C19__8S7825C39[] = {
  ABISELECT(-88,-48),
  ABISELECT(-88,-48),
  (VTBL_ENTRY)&(_ZTI8S7825C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C19D1Ev,_ZTv0_n12_N8S7825C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C19D0Ev,_ZTv0_n12_N8S7825C19D0Ev),
};
extern void _ZN8S7825C20D1Ev();
extern void _ZN8S7825C20D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C20__8S7825C39[] = {
  ABISELECT(72,36),
  ABISELECT(-36,-24),
  ABISELECT(16,8),
  ABISELECT(-200,-108),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C20[0]),
  (VTBL_ENTRY)&_ZN8S7825C20D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C20D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S7825C20D1Ev,_ZTv0_n16_N8S7825C20D1Ev)();
extern void ABISELECT(_ZThn16_N8S7825C20D1Ev,_ZThn8_N8S7825C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7825C20D0Ev,_ZTv0_n16_N8S7825C20D0Ev)();
extern void ABISELECT(_ZThn16_N8S7825C20D0Ev,_ZThn8_N8S7825C20D0Ev)() __attribute__((weak));
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C15__8S7825C20__8S7825C39[] = {
  0,
  ABISELECT(-16,-8),
  ABISELECT(-216,-116),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S7825C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7825C20D1Ev,_ZTv0_n16_N8S7825C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7825C20D0Ev,_ZTv0_n16_N8S7825C20D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
extern void ABISELECT(_ZTvn16_n32_N8S7825C20D1Ev,_ZTvn8_n16_N8S7825C20D1Ev)();
extern void ABISELECT(_ZTvn16_n32_N8S7825C20D0Ev,_ZTvn8_n16_N8S7825C20D0Ev)();
static  VTBL_ENTRY _tg__ZTV10S7825C8_nt8S7825C15__A1__8S7825C20__8S7825C39[] = {
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S7825C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n32_N8S7825C20D1Ev,_ZTvn8_n16_N8S7825C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n32_N8S7825C20D0Ev,_ZTvn8_n16_N8S7825C20D0Ev),
};
extern void ABISELECT(_ZTvn32_n32_N8S7825C20D1Ev,_ZTvn16_n16_N8S7825C20D1Ev)();
extern void ABISELECT(_ZTvn32_n32_N8S7825C20D0Ev,_ZTvn16_n16_N8S7825C20D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S7825C58S7825C15__8S7825C20__8S7825C39[] = {
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S7825C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n32_N8S7825C20D1Ev,_ZTvn16_n16_N8S7825C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n32_N8S7825C20D0Ev,_ZTvn16_n16_N8S7825C20D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C20D1Ev,_ZTv0_n12_N8S7825C20D1Ev)();
extern void ABISELECT(_ZThn72_N8S7825C20D1Ev,_ZThn36_N8S7825C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C20D0Ev,_ZTv0_n12_N8S7825C20D0Ev)();
extern void ABISELECT(_ZThn72_N8S7825C20D0Ev,_ZThn36_N8S7825C20D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C13__8S7825C20__8S7825C39[] = {
  ABISELECT(-72,-36),
  ABISELECT(-72,-36),
  (VTBL_ENTRY)&(_ZTI8S7825C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C20D1Ev,_ZTv0_n12_N8S7825C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C20D0Ev,_ZTv0_n12_N8S7825C20D0Ev),
};
extern void _ZN8S7825C15D1Ev();
extern void _ZN8S7825C15D0Ev();
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C15__A1__8S7825C39[] = {
  ABISELECT(-216,-116),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C15[0]),
  (VTBL_ENTRY)&_ZN8S7825C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C15D0Ev,
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
static  VTT_ENTRY vtt_S7825C39[] = {
  {&(_ZTV8S7825C39[12]),  12,94},
  {&(_tg__ZTV8S7825C22__8S7825C39[7]),  7,9},
  {&(_tg__ZTV8S7825C158S7825C22__8S7825C39[3]),  3,6},
  {&(_tg__ZTV7S7825C5__8S7825C22__8S7825C39[3]),  3,5},
  {&(_tg__ZTV8S7825C12__8S7825C22__8S7825C39[6]),  6,8},
  {&(_tg__ZTV8S7825C14__8S7825C22__8S7825C39[3]),  3,5},
  {&(_tg__ZTV8S7825C15__8S7825C22__8S7825C39[3]),  3,6},
  {&(_ZTV8S7825C39[39]),  39,94},
  {&(_ZTV8S7825C39[47]),  47,94},
  {&(_ZTV8S7825C39[52]),  52,94},
  {&(_ZTV8S7825C39[17]),  17,94},
  {&(_ZTV8S7825C39[62]),  62,94},
  {&(_ZTV8S7825C39[71]),  71,94},
  {&(_ZTV8S7825C39[78]),  78,94},
  {&(_ZTV8S7825C39[83]),  83,94},
  {&(_ZTV8S7825C39[87]),  87,94},
  {&(_ZTV8S7825C39[92]),  92,94},
  {&(_tg__ZTV8S7825C12__8S7825C39[5]),  5,7},
  {&(_tg__ZTV7S7825C5__A1__8S7825C12__8S7825C39[3]),  3,5},
  {&(_tg__ZTV8S7825C14__8S7825C12__8S7825C39[3]),  3,5},
  {&(_tg__ZTV8S7825C19__8S7825C39[7]),  7,9},
  {&(_tg__ZTV8S7825C20__8S7825C19__8S7825C39[7]),  7,9},
  {&(_tg__ZTV8S7825C15__8S7825C19__8S7825C39[5]),  5,8},
  {&(_tg__ZTV10S7825C8_nt8S7825C15__A1__8S7825C19__8S7825C39[2]),  2,4},
  {&(_tg__ZTV7S7825C58S7825C15__8S7825C19__8S7825C39[2]),  2,4},
  {&(_tg__ZTV8S7825C13__8S7825C19__8S7825C39[3]),  3,5},
  {&(_tg__ZTV8S7825C20__8S7825C39[6]),  6,8},
  {&(_tg__ZTV8S7825C15__8S7825C20__8S7825C39[5]),  5,8},
  {&(_tg__ZTV10S7825C8_nt8S7825C15__A1__8S7825C20__8S7825C39[2]),  2,4},
  {&(_tg__ZTV7S7825C58S7825C15__8S7825C20__8S7825C39[2]),  2,4},
  {&(_tg__ZTV8S7825C13__8S7825C20__8S7825C39[3]),  3,5},
  {&(_tg__ZTV8S7825C15__A1__8S7825C39[3]),  3,6},
};
extern VTBL_ENTRY _ZTI8S7825C39[];
extern  VTBL_ENTRY _ZTV8S7825C39[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C39[];
static VTBL_ENTRY alt_thunk_names20[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C20D0Ev,_ZTv0_n12_N8S7825C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N8S7825C20D0Ev,_ZThn36_N8S7825C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C20D1Ev,_ZTv0_n12_N8S7825C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N8S7825C20D1Ev,_ZThn36_N8S7825C20D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7825C20D0Ev,_ZTv0_n16_N8S7825C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S7825C20D0Ev,_ZThn8_N8S7825C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7825C20D1Ev,_ZTv0_n16_N8S7825C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S7825C20D1Ev,_ZThn8_N8S7825C20D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C19D0Ev,_ZTv0_n12_N8S7825C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn88_N8S7825C19D0Ev,_ZThn48_N8S7825C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C19D1Ev,_ZTv0_n12_N8S7825C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn88_N8S7825C19D1Ev,_ZThn48_N8S7825C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7825C19D0Ev,_ZTv0_n16_N8S7825C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C19D0Ev,_ZThn20_N8S7825C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7825C19D1Ev,_ZTv0_n16_N8S7825C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C19D1Ev,_ZThn20_N8S7825C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7825C19D0Ev,_ZTv0_n28_N8S7825C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S7825C19D0Ev,_ZThn12_N8S7825C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7825C19D1Ev,_ZTv0_n28_N8S7825C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S7825C19D1Ev,_ZThn12_N8S7825C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C12D0Ev,_ZThn20_N8S7825C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7825C12D1Ev,_ZThn20_N8S7825C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C22D0Ev,_ZTv0_n24_N8S7825C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn136_N8S7825C22D0Ev,_ZThn68_N8S7825C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C22D1Ev,_ZTv0_n24_N8S7825C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn136_N8S7825C22D1Ev,_ZThn68_N8S7825C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C22D0Ev,_ZTv0_n12_N8S7825C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn168_N8S7825C22D0Ev,_ZThn88_N8S7825C22D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn112_N8S7825C22D0Ev,_ZThn56_N8S7825C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C22D1Ev,_ZTv0_n12_N8S7825C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn168_N8S7825C22D1Ev,_ZThn88_N8S7825C22D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn112_N8S7825C22D1Ev,_ZThn56_N8S7825C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7825C39D0Ev,_ZTv0_n16_N8S7825C39D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn216_N8S7825C39D0Ev,_ZThn116_N8S7825C39D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S7825C39D1Ev,_ZTv0_n16_N8S7825C39D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn216_N8S7825C39D1Ev,_ZThn116_N8S7825C39D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7825C39D0Ev,_ZTv0_n28_N8S7825C39D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn200_N8S7825C39D0Ev,_ZThn108_N8S7825C39D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7825C39D1Ev,_ZTv0_n28_N8S7825C39D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn200_N8S7825C39D1Ev,_ZThn108_N8S7825C39D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S7825C39D0Ev,_ZTv0_n32_N8S7825C39D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn184_N8S7825C39D0Ev,_ZThn96_N8S7825C39D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S7825C39D1Ev,_ZTv0_n32_N8S7825C39D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn184_N8S7825C39D1Ev,_ZThn96_N8S7825C39D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C39D0Ev,_ZTv0_n24_N8S7825C39D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn136_N8S7825C39D0Ev,_ZThn68_N8S7825C39D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7825C39D1Ev,_ZTv0_n24_N8S7825C39D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn136_N8S7825C39D1Ev,_ZThn68_N8S7825C39D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C39D0Ev,_ZTv0_n12_N8S7825C39D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn272_N8S7825C39D0Ev,_ZThn144_N8S7825C39D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn168_N8S7825C39D0Ev,_ZThn88_N8S7825C39D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn112_N8S7825C39D0Ev,_ZThn56_N8S7825C39D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7825C39D1Ev,_ZTv0_n12_N8S7825C39D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn272_N8S7825C39D1Ev,_ZThn144_N8S7825C39D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn168_N8S7825C39D1Ev,_ZThn88_N8S7825C39D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn112_N8S7825C39D1Ev,_ZThn56_N8S7825C39D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7825C39 = {  "S7825C39", // class name
  bases_S7825C39, 58,
  &(vtc_S7825C39[0]), // expected_vtbl_contents
  &(vtt_S7825C39[0]), // expected_vtt_contents
  ABISELECT(304,160), // object size
  NSPAIRA(_ZTI8S7825C39),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S7825C39),94, //virtual function table var
  12, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7825C39),32, //virtual table table var
  33, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names20,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7825C35  : virtual S7825C36 , virtual S7825C37 , virtual S7825C39 {
  void *s7825c35f0;
  virtual  ~S7825C35(); // _ZN8S7825C35D2Ev
  S7825C35(); // tgen
};
//SIG(-1 S7825C35) C1{ VBC2{ VBC3{ m} VBC4{ vd m Fp} BC5{ VBC6{ m} BC7{ BC3 BC8{ BC3 BC6 BC9{ vd m Fc} vd Fp} vd Fi} VBC8 VBC10{ BC9 BC6} vd} vd v1} VBC11{ VBC12{ VBC13{ m FC8} VBC6} BC7 VBC14{ BC15{ VBC6 VBC5 BC16{ VBC8 VBC5 BC4 BC17{ BC6 BC10 BC9 BC8 VBC3 vd v2} BC10 vd} BC8} BC18{ BC19{ VBC9 BC10 VBC3 vd} BC4 VBC8 v3} VBC20{ BC4 Fc:7 Fp} BC5 vd Fi} VBC17 vd} VBC21{ BC16 BC8 VBC22{ VBC23{ VBC3 VBC17 VBC6 BC10 VBC7 vd} FL} BC6 VBC24{ m} vd} vd Fp}


 S7825C35 ::~S7825C35(){ note_dtor("S7825C35", this);}
S7825C35 ::S7825C35(){ note_ctor("S7825C35", this);} // tgen

static void Test_S7825C35()
{
  extern Class_Descriptor cd_S7825C35;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(82,84)];
    init_test(&cd_S7825C35, buf);
    S7825C35 *dp, &lv = *(dp=new (buf) S7825C35());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(648,332), "sizeof(S7825C35)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7825C35)");
    /*is_ambiguous_... S7825C36::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C36*), 0, "S7825C35");
    /*is_ambiguous_... S7825C15::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C15*)(S7825C22*)(S7825C29*)(S7825C38*), 0, "S7825C35");
    check_base_class_offset(lv, (S2407C30*)(S7825C25*)(S7825C24*)(S7825C38*), 0, "S7825C35");
    /*is_ambiguous_... S7825C35::S7825C15 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C15*), 0, "S7825C35");
    /*is_ambiguous_... S7825C15::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C15*)(S7825C22*)(S7825C39*), 0, "S7825C35");
    /*is_ambiguous_... S7825C20::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C20*), 0, "S7825C35");
    check_base_class_offset(lv, (S7825C23_nt*)(S7825C36*), ABISELECT(48,24), "S7825C35");
    /*is_ambiguous_... S7825C12::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C12*)(S7825C36*), 0, "S7825C35");
    check_base_class_offset(lv, (S2407C27*)(S7825C34*), 0, "S7825C35");
    /*is_ambiguous_... S7825C29::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C29*)(S7825C38*), 0, "S7825C35");
    /*is_ambiguous_... S7825C35::S7825C12 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C12*), 0, "S7825C35");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C12*)(S7825C38*), 0, "S7825C35");
    /*is_ambiguous_... S7825C20::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C20*), 0, "S7825C35");
    /*is_ambiguous_... S7825C13::S2407C30 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C13*)(S7825C12*)(S7825C36*), ABISELECT(40,20), "S7825C35");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C13*)(S7825C12*)(S7825C36*), ABISELECT(16,8), "S7825C35");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C13*)(S7825C12*)(S7825C36*), ABISELECT(16,8), "S7825C35");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C13*)(S7825C12*)(S7825C36*), ABISELECT(16,8), "S7825C35");
    check_base_class_offset(lv, (S7825C5*)(S7825C13*)(S7825C12*)(S7825C36*), ABISELECT(16,8), "S7825C35");
    check_base_class_offset(lv, (S7825C13*)(S7825C12*)(S7825C36*), ABISELECT(16,8), "S7825C35");
    /*is_ambiguous_... S7825C35::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*), ABISELECT(64,32), "S7825C35");
    /*is_ambiguous_... S7825C35::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*), ABISELECT(64,32), "S7825C35");
    /*is_ambiguous_... S7825C35::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*), ABISELECT(64,32), "S7825C35");
    /*is_ambiguous_... S7825C12::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C12*)(S7825C36*), ABISELECT(64,32), "S7825C35");
    /*is_ambiguous_... S7825C35::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C12*), ABISELECT(64,32), "S7825C35");
    /*is_ambiguous_... S7825C22::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(64,32), "S7825C35");
    check_base_class_offset(lv, (S7825C5*)(S7825C24*)(S7825C38*), ABISELECT(64,32), "S7825C35");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C12*)(S7825C38*), ABISELECT(64,32), "S7825C35");
    /*is_ambiguous_... S7825C22::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C22*)(S7825C39*), ABISELECT(64,32), "S7825C35");
    /*is_ambiguous_... S7825C35::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*), ABISELECT(88,44), "S7825C35");
    /*is_ambiguous_... S7825C35::S7825C14 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C14*), ABISELECT(88,44), "S7825C35");
    check_base_class_offset(lv, (S7825C14*)(S7825C12*)(S7825C36*), ABISELECT(88,44), "S7825C35");
    /*is_ambiguous_... S7825C35::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C14*)(S7825C12*), ABISELECT(88,44), "S7825C35");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C14*)(S7825C12*)(S7825C38*), ABISELECT(88,44), "S7825C35");
    check_base_class_offset(lv, (S7825C12*)(S7825C36*), ABISELECT(16,8), "S7825C35");
    check_base_class_offset(lv, (S7825C36*), ABISELECT(16,8), "S7825C35");
    check_base_class_offset(lv, (S7825C32*)(S7825C34*), ABISELECT(136,68), "S7825C35");
    check_base_class_offset(lv, (S7825C34*)(S7825C37*), 0, "S7825C35");
    /*is_ambiguous_... S7825C37::S7825C13 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C13*)(S7825C37*), ABISELECT(128,64), "S7825C35");
    /*is_ambiguous_... S7825C37::S7825C13 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C13*)(S7825C37*), ABISELECT(104,52), "S7825C35");
    /*is_ambiguous_... S7825C37::S7825C13 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C13*)(S7825C37*), ABISELECT(104,52), "S7825C35");
    /*is_ambiguous_... S7825C37::S7825C13 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C13*)(S7825C37*), ABISELECT(104,52), "S7825C35");
    /*is_ambiguous_... S7825C37::S7825C13 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C13*)(S7825C37*), ABISELECT(104,52), "S7825C35");
    /*is_ambiguous_... S7825C37::S7825C13 */ AMB_check_base_class_offset(lv, (S7825C13*)(S7825C37*), ABISELECT(104,52), "S7825C35");
    /*is_ambiguous_... S7825C35::S7825C12 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C13*)(S7825C12*), ABISELECT(360,184), "S7825C35");
    /*is_ambiguous_... S7825C35::S7825C12 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(336,172), "S7825C35");
    /*is_ambiguous_... S7825C35::S7825C12 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(336,172), "S7825C35");
    /*is_ambiguous_... S7825C35::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(336,172), "S7825C35");
    /*is_ambiguous_... S7825C35::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C13*)(S7825C12*), ABISELECT(336,172), "S7825C35");
    /*is_ambiguous_... S7825C35::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C13*)(S7825C12*), ABISELECT(336,172), "S7825C35");
    check_base_class_offset(lv, (S7825C12*)(S7825C29*)(S7825C38*), ABISELECT(336,172), "S7825C35");
    check_base_class_offset(lv, (S7825C12*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(336,172), "S7825C35");
    check_base_class_offset(lv, (S7825C12*)(S7825C22*)(S7825C39*), ABISELECT(336,172), "S7825C35");
    check_base_class_offset(lv, (S7825C23_nt*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(160,80), "S7825C35");
    /*is_ambiguous_... S7825C15::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C15*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(185,93), "S7825C35");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C15*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(176,88), "S7825C35");
    check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C15*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(176,88), "S7825C35");
    check_base_class_offset(lv, (S7825C14*)(S7825C15*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(176,88), "S7825C35");
    /*is_ambiguous_... S7825C15::S7825C8_nt */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C15*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(192,96), "S7825C35");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C15*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(208,104), "S7825C35");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C15*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(208,104), "S7825C35");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C15*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(208,104), "S7825C35");
    check_base_class_offset(lv, (S7825C5*)(S7825C15*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(208,104), "S7825C35");
    check_base_class_offset(lv, (S7825C15*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(176,88), "S7825C35");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(232,116), "S7825C35");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(232,116), "S7825C35");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C14*)(S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(232,116), "S7825C35");
    check_base_class_offset(lv, (S7825C22*)(S7825C29*)(S7825C38*), ABISELECT(160,80), "S7825C35");
    /*is_ambiguous_... S7825C29::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C29*)(S7825C38*), ABISELECT(248,124), "S7825C35");
    /*is_ambiguous_... S7825C29::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C29*)(S7825C38*), ABISELECT(248,124), "S7825C35");
    /*is_ambiguous_... S7825C29::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C29*)(S7825C38*), ABISELECT(248,124), "S7825C35");
    /*is_ambiguous_... S7825C29::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C29*)(S7825C38*), ABISELECT(248,124), "S7825C35");
    check_base_class_offset(lv, (S7825C29*)(S7825C38*), ABISELECT(160,80), "S7825C35");
    /*is_ambiguous_... S7825C25::S7825C8_nt */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C25*)(S7825C24*)(S7825C38*), ABISELECT(368,188), "S7825C35");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C25*)(S7825C24*)(S7825C38*), ABISELECT(272,136), "S7825C35");
    check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C25*)(S7825C24*)(S7825C38*), ABISELECT(272,136), "S7825C35");
    check_base_class_offset(lv, (S7825C14*)(S7825C25*)(S7825C24*)(S7825C38*), ABISELECT(272,136), "S7825C35");
    check_base_class_offset(lv, (S7825C25*)(S7825C24*)(S7825C38*), ABISELECT(272,136), "S7825C35");
    check_base_class_offset(lv, (S7825C23_nt*)(S7825C24*)(S7825C38*), ABISELECT(288,144), "S7825C35");
    check_base_class_offset(lv, (S7825C24*)(S7825C38*), ABISELECT(272,136), "S7825C35");
    check_base_class_offset(lv, (S7825C23_nt*)(S7825C26*), ABISELECT(384,196), "S7825C35");
    check_base_class_offset(lv, (S7825C26*)(S7825C38*), ABISELECT(384,196), "S7825C35");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C13*)(S7825C12*)(S7825C38*), ABISELECT(328,164), "S7825C35");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C13*)(S7825C12*)(S7825C38*), ABISELECT(304,152), "S7825C35");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C13*)(S7825C12*)(S7825C38*), ABISELECT(304,152), "S7825C35");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C13*)(S7825C12*)(S7825C38*), ABISELECT(304,152), "S7825C35");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C13*)(S7825C12*)(S7825C38*), ABISELECT(304,152), "S7825C35");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C13*)(S7825C12*)(S7825C38*), ABISELECT(304,152), "S7825C35");
    /*is_ambiguous_... S7825C38::S7825C12 */ AMB_check_base_class_offset(lv, (S7825C12*)(S7825C38*), ABISELECT(304,152), "S7825C35");
    check_base_class_offset(lv, (S7825C38*)(S7825C37*), ABISELECT(160,80), "S7825C35");
    /*is_ambiguous_... S7825C35::S7825C15 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C15*), ABISELECT(425,217), "S7825C35");
    /*is_ambiguous_... S7825C35::S7825C15 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C15*), ABISELECT(416,212), "S7825C35");
    /*is_ambiguous_... S7825C35::S7825C15 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C15*), ABISELECT(416,212), "S7825C35");
    /*is_ambiguous_... S7825C35::S7825C15 */ AMB_check_base_class_offset(lv, (S7825C14*)(S7825C15*), ABISELECT(416,212), "S7825C35");
    /*is_ambiguous_... S7825C35::S7825C15 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C15*), ABISELECT(432,220), "S7825C35");
    /*is_ambiguous_... S7825C35::S7825C15 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C15*), ABISELECT(448,228), "S7825C35");
    /*is_ambiguous_... S7825C35::S7825C15 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C15*), ABISELECT(448,228), "S7825C35");
    /*is_ambiguous_... S7825C35::S7825C15 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C15*), ABISELECT(448,228), "S7825C35");
    /*is_ambiguous_... S7825C35::S7825C15 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C15*), ABISELECT(448,228), "S7825C35");
    /*is_ambiguous_... S7825C37::S7825C15 */ AMB_check_base_class_offset(lv, (S7825C15*)(S7825C37*), ABISELECT(416,212), "S7825C35");
    check_base_class_offset(lv, (S7825C15*)(S7825C20*), ABISELECT(416,212), "S7825C35");
    check_base_class_offset(lv, (S7825C37*), ABISELECT(104,52), "S7825C35");
    check_base_class_offset(lv, (S7825C23_nt*)(S7825C22*)(S7825C39*), ABISELECT(472,240), "S7825C35");
    /*is_ambiguous_... S7825C15::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C15*)(S7825C22*)(S7825C39*), ABISELECT(497,253), "S7825C35");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C15*)(S7825C22*)(S7825C39*), ABISELECT(488,248), "S7825C35");
    check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C15*)(S7825C22*)(S7825C39*), ABISELECT(488,248), "S7825C35");
    check_base_class_offset(lv, (S7825C14*)(S7825C15*)(S7825C22*)(S7825C39*), ABISELECT(488,248), "S7825C35");
    /*is_ambiguous_... S7825C15::S7825C8_nt */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C15*)(S7825C22*)(S7825C39*), ABISELECT(504,256), "S7825C35");
    check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C15*)(S7825C22*)(S7825C39*), ABISELECT(520,264), "S7825C35");
    check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C15*)(S7825C22*)(S7825C39*), ABISELECT(520,264), "S7825C35");
    check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C15*)(S7825C22*)(S7825C39*), ABISELECT(520,264), "S7825C35");
    check_base_class_offset(lv, (S7825C5*)(S7825C15*)(S7825C22*)(S7825C39*), ABISELECT(520,264), "S7825C35");
    check_base_class_offset(lv, (S7825C15*)(S7825C22*)(S7825C39*), ABISELECT(488,248), "S7825C35");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C22*)(S7825C39*), ABISELECT(544,276), "S7825C35");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C22*)(S7825C39*), ABISELECT(544,276), "S7825C35");
    /*is_ambiguous_... S7825C22::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C14*)(S7825C22*)(S7825C39*), ABISELECT(544,276), "S7825C35");
    check_base_class_offset(lv, (S7825C22*)(S7825C39*), ABISELECT(472,240), "S7825C35");
    /*is_ambiguous_... S7825C39::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C39*), ABISELECT(560,284), "S7825C35");
    /*is_ambiguous_... S7825C39::S7825C5 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C39*), ABISELECT(560,284), "S7825C35");
    /*is_ambiguous_... S7825C39::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C39*), ABISELECT(560,284), "S7825C35");
    /*is_ambiguous_... S7825C39::S7825C5 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C39*), ABISELECT(560,284), "S7825C35");
    /*is_ambiguous_... S7825C20::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C14*)(S7825C20*), ABISELECT(600,308), "S7825C35");
    /*is_ambiguous_... S7825C20::S7825C14 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C14*)(S7825C20*), ABISELECT(600,308), "S7825C35");
    /*is_ambiguous_... S7825C20::S7825C14 */ AMB_check_base_class_offset(lv, (S7825C14*)(S7825C20*), ABISELECT(600,308), "S7825C35");
    /*is_ambiguous_... S7825C35::S7825C13 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C13*), ABISELECT(640,328), "S7825C35");
    /*is_ambiguous_... S7825C35::S7825C13 */ AMB_check_base_class_offset(lv, (S2407C30*)(S7825C5*)(S7825C13*), ABISELECT(616,316), "S7825C35");
    /*is_ambiguous_... S7825C35::S7825C13 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C5*)(S7825C13*), ABISELECT(616,316), "S7825C35");
    /*is_ambiguous_... S7825C35::S7825C13 */ AMB_check_base_class_offset(lv, (S7825C8_nt*)(S7825C5*)(S7825C13*), ABISELECT(616,316), "S7825C35");
    /*is_ambiguous_... S7825C35::S7825C13 */ AMB_check_base_class_offset(lv, (S7825C5*)(S7825C13*), ABISELECT(616,316), "S7825C35");
    check_base_class_offset(lv, (S7825C13*)(S7825C20*), ABISELECT(616,316), "S7825C35");
    check_base_class_offset(lv, (S7825C20*)(S7825C19*), ABISELECT(600,308), "S7825C35");
    check_base_class_offset(lv, (S7825C19*)(S7825C39*), ABISELECT(584,296), "S7825C35");
    /*is_ambiguous_... S7825C39::S2407C27 */ AMB_check_base_class_offset(lv, (S2407C27*)(S7825C39*), ABISELECT(472,240), "S7825C35");
    check_base_class_offset(lv, (S7825C40_nt*)(S7825C39*), 0, "S7825C35");
    check_base_class_offset(lv, (S7825C39*), ABISELECT(472,240), "S7825C35");
    check_field_offset(lv, s7825c35f0, ABISELECT(8,4), "S7825C35.s7825c35f0");
    test_class_info(&lv, &cd_S7825C35);
    dp->~S7825C35();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7825C35(Test_S7825C35, "S7825C35", ABISELECT(648,332));

#else // __cplusplus

extern void _ZN8S7825C35C1Ev();
extern void _ZN8S7825C35D2Ev();
Name_Map name_map_S7825C35[] = {
  NSPAIR(_ZN8S7825C35C1Ev),
  NSPAIR(_ZN8S7825C35D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S7825C23_nt;
extern VTBL_ENTRY _ZTI11S7825C23_nt[];
extern  VTBL_ENTRY _ZTV11S7825C23_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C13;
extern VTBL_ENTRY _ZTI8S7825C13[];
extern  VTBL_ENTRY _ZTV8S7825C13[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C12;
extern VTBL_ENTRY _ZTI8S7825C12[];
extern  VTBL_ENTRY _ZTV8S7825C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C12[];
extern Class_Descriptor cd_S7825C36;
extern VTBL_ENTRY _ZTI8S7825C36[];
extern  VTBL_ENTRY _ZTV8S7825C36[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C36[];
extern Class_Descriptor cd_S7825C32;
extern VTBL_ENTRY _ZTI8S7825C32[];
extern Class_Descriptor cd_S7825C34;
extern VTBL_ENTRY _ZTI8S7825C34[];
extern  VTBL_ENTRY _ZTV8S7825C34[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C34[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C13;
extern VTBL_ENTRY _ZTI8S7825C13[];
extern  VTBL_ENTRY _ZTV8S7825C13[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C13;
extern VTBL_ENTRY _ZTI8S7825C13[];
extern  VTBL_ENTRY _ZTV8S7825C13[];
extern Class_Descriptor cd_S7825C12;
extern VTBL_ENTRY _ZTI8S7825C12[];
extern  VTBL_ENTRY _ZTV8S7825C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C12[];
extern Class_Descriptor cd_S7825C23_nt;
extern VTBL_ENTRY _ZTI11S7825C23_nt[];
extern  VTBL_ENTRY _ZTV11S7825C23_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C15;
extern VTBL_ENTRY _ZTI8S7825C15[];
extern  VTBL_ENTRY _ZTV8S7825C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C15[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C22;
extern VTBL_ENTRY _ZTI8S7825C22[];
extern  VTBL_ENTRY _ZTV8S7825C22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C22[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C29;
extern VTBL_ENTRY _ZTI8S7825C29[];
extern  VTBL_ENTRY _ZTV8S7825C29[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C29[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C25;
extern VTBL_ENTRY _ZTI8S7825C25[];
extern  VTBL_ENTRY _ZTV8S7825C25[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C25[];
extern Class_Descriptor cd_S7825C23_nt;
extern VTBL_ENTRY _ZTI11S7825C23_nt[];
extern  VTBL_ENTRY _ZTV11S7825C23_nt[];
extern Class_Descriptor cd_S7825C24;
extern VTBL_ENTRY _ZTI8S7825C24[];
extern  VTBL_ENTRY _ZTV8S7825C24[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C24[];
extern Class_Descriptor cd_S7825C23_nt;
extern VTBL_ENTRY _ZTI11S7825C23_nt[];
extern  VTBL_ENTRY _ZTV11S7825C23_nt[];
extern Class_Descriptor cd_S7825C26;
extern VTBL_ENTRY _ZTI8S7825C26[];
extern  VTBL_ENTRY _ZTV8S7825C26[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C13;
extern VTBL_ENTRY _ZTI8S7825C13[];
extern  VTBL_ENTRY _ZTV8S7825C13[];
extern Class_Descriptor cd_S7825C12;
extern VTBL_ENTRY _ZTI8S7825C12[];
extern  VTBL_ENTRY _ZTV8S7825C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C12[];
extern Class_Descriptor cd_S7825C38;
extern VTBL_ENTRY _ZTI8S7825C38[];
extern  VTBL_ENTRY _ZTV8S7825C38[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C38[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C15;
extern VTBL_ENTRY _ZTI8S7825C15[];
extern  VTBL_ENTRY _ZTV8S7825C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C15[];
extern Class_Descriptor cd_S7825C37;
extern VTBL_ENTRY _ZTI8S7825C37[];
extern  VTBL_ENTRY _ZTV8S7825C37[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C37[];
extern Class_Descriptor cd_S7825C23_nt;
extern VTBL_ENTRY _ZTI11S7825C23_nt[];
extern  VTBL_ENTRY _ZTV11S7825C23_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C15;
extern VTBL_ENTRY _ZTI8S7825C15[];
extern  VTBL_ENTRY _ZTV8S7825C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C15[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S7825C22;
extern VTBL_ENTRY _ZTI8S7825C22[];
extern  VTBL_ENTRY _ZTV8S7825C22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C22[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C14;
extern VTBL_ENTRY _ZTI8S7825C14[];
extern  VTBL_ENTRY _ZTV8S7825C14[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C30;
extern VTBL_ENTRY _ZTI8S2407C30[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C8_nt;
extern VTBL_ENTRY _ZTI10S7825C8_nt[];
extern  VTBL_ENTRY _ZTV10S7825C8_nt[];
extern Class_Descriptor cd_S7825C5;
extern VTBL_ENTRY _ZTI7S7825C5[];
extern  VTBL_ENTRY _ZTV7S7825C5[];
extern Class_Descriptor cd_S7825C13;
extern VTBL_ENTRY _ZTI8S7825C13[];
extern  VTBL_ENTRY _ZTV8S7825C13[];
extern Class_Descriptor cd_S7825C20;
extern VTBL_ENTRY _ZTI8S7825C20[];
extern  VTBL_ENTRY _ZTV8S7825C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C20[];
extern Class_Descriptor cd_S7825C19;
extern VTBL_ENTRY _ZTI8S7825C19[];
extern  VTBL_ENTRY _ZTV8S7825C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C19[];
extern Class_Descriptor cd_S2407C27;
extern VTBL_ENTRY _ZTI8S2407C27[];
extern Class_Descriptor cd_S7825C40_nt;
extern VTBL_ENTRY _ZTI11S7825C40_nt[];
extern Class_Descriptor cd_S7825C39;
extern VTBL_ENTRY _ZTI8S7825C39[];
extern  VTBL_ENTRY _ZTV8S7825C39[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7825C39[];
static Base_Class bases_S7825C35[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2407C30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 1},
  {&cd_S7825C23_nt,    ABISELECT(48,24), //bcp->offset
    35, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    17, //immediately_derived
  0, 1},
  {&cd_S2407C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S2407C30,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7825C13,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(64,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(64,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(64,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(64,32), //bcp->offset
    40, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S7825C8_nt,    ABISELECT(88,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(88,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(88,44), //bcp->offset
    45, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S7825C12,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S7825C36,    ABISELECT(16,8), //bcp->offset
    23, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7825C32,    ABISELECT(136,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 1},
  {&cd_S7825C34,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    58, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    80, //immediately_derived
  0, 1},
  {&cd_S2407C30,    ABISELECT(128,64), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(104,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(104,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(104,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    48, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(104,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    49, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S7825C13,    ABISELECT(104,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    50, //init_seq
    80, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(360,184), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(336,172), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(336,172), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(336,172), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(336,172), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S7825C13,    ABISELECT(336,172), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S7825C12,    ABISELECT(336,172), //bcp->offset
    121, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    87, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    47, //immediately_derived
  0, 1},
  {&cd_S7825C23_nt,    ABISELECT(160,80), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    47, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(185,93), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(176,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(176,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(176,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(192,96), //bcp->offset
    86, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(208,104), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    42, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(208,104), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    42, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(208,104), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    42, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(208,104), //bcp->offset
    90, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S7825C15,    ABISELECT(176,88), //bcp->offset
    80, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    62, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    47, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(232,116), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    46, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(232,116), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    46, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(232,116), //bcp->offset
    94, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    47, //immediately_derived
  0, 0},
  {&cd_S7825C22,    ABISELECT(160,80), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    61, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    52, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(248,124), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    51, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(248,124), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    51, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(248,124), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    51, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(248,124), //bcp->offset
    98, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    52, //immediately_derived
  0, 0},
  {&cd_S7825C29,    ABISELECT(160,80), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    60, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    69, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(368,188), //bcp->offset
    129, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    57, //immediately_derived
  0, 1},
  {&cd_S7825C8_nt,    ABISELECT(272,136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    56, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(272,136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    56, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(272,136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    57, //immediately_derived
  0, 0},
  {&cd_S7825C25,    ABISELECT(272,136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    72, //bcp->base_subarray_index_in_construction_vtbl_array
    34, //init_seq
    59, //immediately_derived
  0, 0},
  {&cd_S7825C23_nt,    ABISELECT(288,144), //bcp->offset
    110, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    35, //init_seq
    59, //immediately_derived
  0, 0},
  {&cd_S7825C24,    ABISELECT(272,136), //bcp->offset
    102, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    71, //bcp->base_subarray_index_in_construction_vtbl_array
    36, //init_seq
    69, //immediately_derived
  0, 0},
  {&cd_S7825C23_nt,    ABISELECT(384,196), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    61, //immediately_derived
  0, 0},
  {&cd_S7825C26,    ABISELECT(384,196), //bcp->offset
    134, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    69, //immediately_derived
  0, 1},
  {&cd_S2407C30,    ABISELECT(328,164), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    67, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(304,152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    66, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(304,152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    66, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(304,152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    37, //init_seq
    66, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(304,152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    38, //init_seq
    67, //immediately_derived
  0, 0},
  {&cd_S7825C13,    ABISELECT(304,152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    39, //init_seq
    68, //immediately_derived
  0, 0},
  {&cd_S7825C12,    ABISELECT(304,152), //bcp->offset
    114, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    76, //bcp->base_subarray_index_in_construction_vtbl_array
    40, //init_seq
    69, //immediately_derived
  0, 0},
  {&cd_S7825C38,    ABISELECT(160,80), //bcp->offset
    66, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    59, //bcp->base_subarray_index_in_construction_vtbl_array
    41, //init_seq
    80, //immediately_derived
  0, 1},
  {&cd_S2407C27,    ABISELECT(425,217), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    79, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(416,212), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    42, //init_seq
    73, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(416,212), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    73, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(416,212), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    43, //init_seq
    79, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(432,220), //bcp->offset
    147, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    44, //init_seq
    79, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(448,228), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    78, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(448,228), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    78, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(448,228), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    45, //init_seq
    78, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(448,228), //bcp->offset
    151, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    46, //init_seq
    79, //immediately_derived
  0, 0},
  {&cd_S7825C15,    ABISELECT(416,212), //bcp->offset
    139, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    90, //bcp->base_subarray_index_in_construction_vtbl_array
    47, //init_seq
    80, //immediately_derived
  0, 1},
  {&cd_S7825C37,    ABISELECT(104,52), //bcp->offset
    50, //bcp->virtual_function_table_offset
    14, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    39, //bcp->base_subarray_index_in_construction_vtbl_array
    51, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7825C23_nt,    ABISELECT(472,240), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    59, //init_seq
    95, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(497,253), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    91, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(488,248), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    60, //init_seq
    85, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(488,248), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    85, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(488,248), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    61, //init_seq
    91, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(504,256), //bcp->offset
    177, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    62, //init_seq
    91, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(520,264), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    90, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(520,264), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    90, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(520,264), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    63, //init_seq
    90, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(520,264), //bcp->offset
    181, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    64, //init_seq
    91, //immediately_derived
  0, 0},
  {&cd_S7825C15,    ABISELECT(488,248), //bcp->offset
    171, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    93, //bcp->base_subarray_index_in_construction_vtbl_array
    65, //init_seq
    95, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(544,276), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    66, //init_seq
    94, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(544,276), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    94, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(544,276), //bcp->offset
    185, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    67, //init_seq
    95, //immediately_derived
  0, 0},
  {&cd_S7825C22,    ABISELECT(472,240), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    92, //bcp->base_subarray_index_in_construction_vtbl_array
    68, //init_seq
    113, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(560,284), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    99, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(560,284), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    99, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(560,284), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    69, //init_seq
    99, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(560,284), //bcp->offset
    189, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    70, //init_seq
    113, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(600,308), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    55, //init_seq
    102, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(600,308), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    102, //immediately_derived
  0, 0},
  {&cd_S7825C14,    ABISELECT(600,308), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    56, //init_seq
    109, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(640,328), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    108, //immediately_derived
  0, 0},
  {&cd_S2407C30,    ABISELECT(616,316), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    107, //immediately_derived
  0, 0},
  {&cd_S2407C27,    ABISELECT(616,316), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    107, //immediately_derived
  0, 0},
  {&cd_S7825C8_nt,    ABISELECT(616,316), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    52, //init_seq
    107, //immediately_derived
  0, 0},
  {&cd_S7825C5,    ABISELECT(616,316), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    53, //init_seq
    108, //immediately_derived
  0, 0},
  {&cd_S7825C13,    ABISELECT(616,316), //bcp->offset
    212, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    54, //init_seq
    109, //immediately_derived
  0, 1},
  {&cd_S7825C20,    ABISELECT(600,308), //bcp->offset
    203, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    114, //bcp->base_subarray_index_in_construction_vtbl_array
    57, //init_seq
    110, //immediately_derived
  0, 1},
  {&cd_S7825C19,    ABISELECT(584,296), //bcp->offset
    193, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    108, //bcp->base_subarray_index_in_construction_vtbl_array
    58, //init_seq
    113, //immediately_derived
  0, 1},
  {&cd_S2407C27,    ABISELECT(472,240), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    113, //immediately_derived
  0, 0},
  {&cd_S7825C40_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    113, //immediately_derived
  0, 1},
  {&cd_S7825C39,    ABISELECT(472,240), //bcp->offset
    155, //bcp->virtual_function_table_offset
    14, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    91, //bcp->base_subarray_index_in_construction_vtbl_array
    71, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7825C35[];
extern void _ZN8S7825C35D1Ev();
extern void _ZN8S7825C35D0Ev();
extern void ABISELECT(_ZTv0_n64_N8S7825C35D1Ev,_ZTv0_n32_N8S7825C35D1Ev)();
extern void ABISELECT(_ZThn16_N8S7825C35D1Ev,_ZThn8_N8S7825C35D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S7825C35D0Ev,_ZTv0_n32_N8S7825C35D0Ev)();
extern void ABISELECT(_ZThn16_N8S7825C35D0Ev,_ZThn8_N8S7825C35D0Ev)() __attribute__((weak));
extern void _ZN8S7825C362v3Ev();
extern void ABISELECT(_ZTv0_n24_N8S7825C35D1Ev,_ZTv0_n12_N8S7825C35D1Ev)();
extern void ABISELECT(_ZThn48_N8S7825C35D1Ev,_ZThn24_N8S7825C35D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C35D0Ev,_ZTv0_n12_N8S7825C35D0Ev)();
extern void ABISELECT(_ZThn48_N8S7825C35D0Ev,_ZThn24_N8S7825C35D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C35D1Ev,_ZTv0_n12_N8S7825C35D1Ev)();
extern void ABISELECT(_ZThn64_N8S7825C35D1Ev,_ZThn32_N8S7825C35D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C35D0Ev,_ZTv0_n12_N8S7825C35D0Ev)();
extern void ABISELECT(_ZThn64_N8S7825C35D0Ev,_ZThn32_N8S7825C35D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C35D1Ev,_ZTv0_n12_N8S7825C35D1Ev)();
extern void ABISELECT(_ZThn88_N8S7825C35D1Ev,_ZThn44_N8S7825C35D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C35D0Ev,_ZTv0_n12_N8S7825C35D0Ev)();
extern void ABISELECT(_ZThn88_N8S7825C35D0Ev,_ZThn44_N8S7825C35D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n112_N8S7825C35D1Ev,_ZTv0_n56_N8S7825C35D1Ev)();
extern void ABISELECT(_ZThn104_N8S7825C35D1Ev,_ZThn52_N8S7825C35D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n112_N8S7825C35D0Ev,_ZTv0_n56_N8S7825C35D0Ev)();
extern void ABISELECT(_ZThn104_N8S7825C35D0Ev,_ZThn52_N8S7825C35D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N8S7825C35D1Ev,_ZTv0_n40_N8S7825C35D1Ev)();
extern void ABISELECT(_ZThn160_N8S7825C35D1Ev,_ZThn80_N8S7825C35D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N8S7825C35D0Ev,_ZTv0_n40_N8S7825C35D0Ev)();
extern void ABISELECT(_ZThn160_N8S7825C35D0Ev,_ZThn80_N8S7825C35D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n80_N8S7825C35D1Ev,_ZTvn8_n40_N8S7825C35D1Ev)();
extern void ABISELECT(_ZTvn16_n80_N8S7825C35D0Ev,_ZTvn8_n40_N8S7825C35D0Ev)();
extern void _ZN8S7825C152v2Ev();
extern void ABISELECT(_ZTvn32_n80_N8S7825C35D1Ev,_ZTvn16_n40_N8S7825C35D1Ev)();
extern void ABISELECT(_ZTvn32_n80_N8S7825C35D0Ev,_ZTvn16_n40_N8S7825C35D0Ev)();
extern void ABISELECT(_ZTvn48_n80_N8S7825C35D1Ev,_ZTvn24_n40_N8S7825C35D1Ev)();
extern void ABISELECT(_ZTvn48_n80_N8S7825C35D0Ev,_ZTvn24_n40_N8S7825C35D0Ev)();
extern void ABISELECT(_ZTvn72_n80_N8S7825C35D1Ev,_ZTvn36_n40_N8S7825C35D1Ev)();
extern void ABISELECT(_ZTvn72_n80_N8S7825C35D0Ev,_ZTvn36_n40_N8S7825C35D0Ev)();
extern void ABISELECT(_ZTvn88_n80_N8S7825C35D1Ev,_ZTvn44_n40_N8S7825C35D1Ev)();
extern void ABISELECT(_ZTvn88_n80_N8S7825C35D0Ev,_ZTvn44_n40_N8S7825C35D0Ev)();
extern void ABISELECT(_ZTvn112_n80_N8S7825C35D1Ev,_ZTvn56_n40_N8S7825C35D1Ev)();
extern void ABISELECT(_ZTvn112_n80_N8S7825C35D0Ev,_ZTvn56_n40_N8S7825C35D0Ev)();
extern void _ZN8S7825C242v1Ev();
extern void ABISELECT(_ZTvn128_n80_N8S7825C35D1Ev,_ZTvn64_n40_N8S7825C35D1Ev)();
extern void ABISELECT(_ZTvn128_n80_N8S7825C35D0Ev,_ZTvn64_n40_N8S7825C35D0Ev)();
extern void ABISELECT(_ZTvn144_n80_N8S7825C35D1Ev,_ZTvn72_n40_N8S7825C35D1Ev)();
extern void ABISELECT(_ZTvn144_n80_N8S7825C35D0Ev,_ZTvn72_n40_N8S7825C35D0Ev)();
extern void ABISELECT(_ZTv0_n48_N8S7825C35D1Ev,_ZTv0_n24_N8S7825C35D1Ev)();
extern void ABISELECT(_ZThn336_N8S7825C35D1Ev,_ZThn172_N8S7825C35D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7825C35D0Ev,_ZTv0_n24_N8S7825C35D0Ev)();
extern void ABISELECT(_ZThn336_N8S7825C35D0Ev,_ZThn172_N8S7825C35D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C35D1Ev,_ZTv0_n12_N8S7825C35D1Ev)();
extern void ABISELECT(_ZThn368_N8S7825C35D1Ev,_ZThn188_N8S7825C35D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C35D0Ev,_ZTv0_n12_N8S7825C35D0Ev)();
extern void ABISELECT(_ZThn368_N8S7825C35D0Ev,_ZThn188_N8S7825C35D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C35D1Ev,_ZTv0_n12_N8S7825C35D1Ev)();
extern void ABISELECT(_ZThn384_N8S7825C35D1Ev,_ZThn196_N8S7825C35D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C35D0Ev,_ZTv0_n12_N8S7825C35D0Ev)();
extern void ABISELECT(_ZThn384_N8S7825C35D0Ev,_ZThn196_N8S7825C35D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7825C35D1Ev,_ZTv0_n16_N8S7825C35D1Ev)();
extern void ABISELECT(_ZThn416_N8S7825C35D1Ev,_ZThn212_N8S7825C35D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7825C35D0Ev,_ZTv0_n16_N8S7825C35D0Ev)();
extern void ABISELECT(_ZThn416_N8S7825C35D0Ev,_ZThn212_N8S7825C35D0Ev)() __attribute__((weak));
extern void _ZN8S7825C152v2Ev();
extern void ABISELECT(_ZTvn16_n32_N8S7825C35D1Ev,_ZTvn8_n16_N8S7825C35D1Ev)();
extern void ABISELECT(_ZTvn16_n32_N8S7825C35D0Ev,_ZTvn8_n16_N8S7825C35D0Ev)();
extern void ABISELECT(_ZTvn32_n32_N8S7825C35D1Ev,_ZTvn16_n16_N8S7825C35D1Ev)();
extern void ABISELECT(_ZTvn32_n32_N8S7825C35D0Ev,_ZTvn16_n16_N8S7825C35D0Ev)();
extern void ABISELECT(_ZTv0_n104_N8S7825C35D1Ev,_ZTv0_n52_N8S7825C35D1Ev)();
extern void ABISELECT(_ZThn472_N8S7825C35D1Ev,_ZThn240_N8S7825C35D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n104_N8S7825C35D0Ev,_ZTv0_n52_N8S7825C35D0Ev)();
extern void ABISELECT(_ZThn472_N8S7825C35D0Ev,_ZThn240_N8S7825C35D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n104_N8S7825C35D1Ev,_ZTvn8_n52_N8S7825C35D1Ev)();
extern void ABISELECT(_ZTvn16_n104_N8S7825C35D0Ev,_ZTvn8_n52_N8S7825C35D0Ev)();
extern void _ZN8S7825C152v2Ev();
extern void ABISELECT(_ZTvn32_n104_N8S7825C35D1Ev,_ZTvn16_n52_N8S7825C35D1Ev)();
extern void ABISELECT(_ZTvn32_n104_N8S7825C35D0Ev,_ZTvn16_n52_N8S7825C35D0Ev)();
extern void ABISELECT(_ZTvn48_n104_N8S7825C35D1Ev,_ZTvn24_n52_N8S7825C35D1Ev)();
extern void ABISELECT(_ZTvn48_n104_N8S7825C35D0Ev,_ZTvn24_n52_N8S7825C35D0Ev)();
extern void ABISELECT(_ZTvn72_n104_N8S7825C35D1Ev,_ZTvn36_n52_N8S7825C35D1Ev)();
extern void ABISELECT(_ZTvn72_n104_N8S7825C35D0Ev,_ZTvn36_n52_N8S7825C35D0Ev)();
extern void ABISELECT(_ZTvn88_n104_N8S7825C35D1Ev,_ZTvn44_n52_N8S7825C35D1Ev)();
extern void ABISELECT(_ZTvn88_n104_N8S7825C35D0Ev,_ZTvn44_n52_N8S7825C35D0Ev)();
extern void ABISELECT(_ZTv0_n64_N8S7825C35D1Ev,_ZTv0_n32_N8S7825C35D1Ev)();
extern void ABISELECT(_ZThn584_N8S7825C35D1Ev,_ZThn296_N8S7825C35D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S7825C35D0Ev,_ZTv0_n32_N8S7825C35D0Ev)();
extern void ABISELECT(_ZThn584_N8S7825C35D0Ev,_ZThn296_N8S7825C35D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7825C35D1Ev,_ZTv0_n28_N8S7825C35D1Ev)();
extern void ABISELECT(_ZThn600_N8S7825C35D1Ev,_ZThn308_N8S7825C35D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7825C35D0Ev,_ZTv0_n28_N8S7825C35D0Ev)();
extern void ABISELECT(_ZThn600_N8S7825C35D0Ev,_ZThn308_N8S7825C35D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C35D1Ev,_ZTv0_n12_N8S7825C35D1Ev)();
extern void ABISELECT(_ZThn616_N8S7825C35D1Ev,_ZThn316_N8S7825C35D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C35D0Ev,_ZTv0_n12_N8S7825C35D0Ev)();
extern void ABISELECT(_ZThn616_N8S7825C35D0Ev,_ZThn316_N8S7825C35D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7825C35[] = {
  0,
  ABISELECT(616,316),
  ABISELECT(600,308),
  ABISELECT(584,296),
  ABISELECT(472,240),
  ABISELECT(416,212),
  ABISELECT(384,196),
  ABISELECT(368,188),
  ABISELECT(336,172),
  ABISELECT(160,80),
  0,
  ABISELECT(104,52),
  ABISELECT(88,44),
  ABISELECT(64,32),
  ABISELECT(48,24),
  0,
  ABISELECT(16,8),
  0,
  ABISELECT(136,68),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C35[0]),
  (VTBL_ENTRY)&_ZN8S7825C35D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C35D0Ev,
  0,
  ABISELECT(-16,-8),
  ABISELECT(32,16),
  ABISELECT(-16,-8),
  ABISELECT(72,36),
  ABISELECT(48,24),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S7825C35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7825C35D1Ev,_ZTv0_n32_N8S7825C35D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7825C35D0Ev,_ZTv0_n32_N8S7825C35D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C362v3Ev,
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S7825C35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C35D1Ev,_ZTv0_n12_N8S7825C35D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C35D0Ev,_ZTv0_n12_N8S7825C35D0Ev),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI8S7825C35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C35D1Ev,_ZTv0_n12_N8S7825C35D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C35D0Ev,_ZTv0_n12_N8S7825C35D0Ev),
  ABISELECT(-88,-44),
  ABISELECT(-88,-44),
  (VTBL_ENTRY)&(_ZTI8S7825C35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C35D1Ev,_ZTv0_n12_N8S7825C35D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C35D0Ev,_ZTv0_n12_N8S7825C35D0Ev),
  ABISELECT(-104,-52),
  ABISELECT(312,160),
  ABISELECT(280,144),
  ABISELECT(264,136),
  ABISELECT(-104,-52),
  ABISELECT(-16,-8),
  ABISELECT(-40,-20),
  ABISELECT(232,120),
  ABISELECT(56,28),
  ABISELECT(-104,-52),
  ABISELECT(32,16),
  ABISELECT(-104,-52),
  ABISELECT(-104,-52),
  (VTBL_ENTRY)&(_ZTI8S7825C35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n112_N8S7825C35D1Ev,_ZTv0_n56_N8S7825C35D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n112_N8S7825C35D0Ev,_ZTv0_n56_N8S7825C35D0Ev),
  ABISELECT(112,56),
  ABISELECT(16,8),
  ABISELECT(-160,-80),
  ABISELECT(224,116),
  ABISELECT(208,108),
  ABISELECT(-160,-80),
  ABISELECT(-72,-36),
  ABISELECT(-160,-80),
  ABISELECT(176,92),
  ABISELECT(-96,-48),
  ABISELECT(-160,-80),
  (VTBL_ENTRY)&(_ZTI8S7825C35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S7825C35D1Ev,_ZTv0_n40_N8S7825C35D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S7825C35D0Ev,_ZTv0_n40_N8S7825C35D0Ev),
  ABISELECT(-176,-88),
  ABISELECT(-176,-88),
  (VTBL_ENTRY)&(_ZTI8S7825C35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n80_N8S7825C35D1Ev,_ZTvn8_n40_N8S7825C35D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n80_N8S7825C35D0Ev,_ZTvn8_n40_N8S7825C35D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
  ABISELECT(-192,-96),
  (VTBL_ENTRY)&(_ZTI8S7825C35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n80_N8S7825C35D1Ev,_ZTvn16_n40_N8S7825C35D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n80_N8S7825C35D0Ev,_ZTvn16_n40_N8S7825C35D0Ev),
  ABISELECT(-208,-104),
  (VTBL_ENTRY)&(_ZTI8S7825C35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn48_n80_N8S7825C35D1Ev,_ZTvn24_n40_N8S7825C35D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn48_n80_N8S7825C35D0Ev,_ZTvn24_n40_N8S7825C35D0Ev),
  ABISELECT(-232,-116),
  (VTBL_ENTRY)&(_ZTI8S7825C35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn72_n80_N8S7825C35D1Ev,_ZTvn36_n40_N8S7825C35D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn72_n80_N8S7825C35D0Ev,_ZTvn36_n40_N8S7825C35D0Ev),
  ABISELECT(-248,-124),
  (VTBL_ENTRY)&(_ZTI8S7825C35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn88_n80_N8S7825C35D1Ev,_ZTvn44_n40_N8S7825C35D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn88_n80_N8S7825C35D0Ev,_ZTvn44_n40_N8S7825C35D0Ev),
  ABISELECT(-208,-104),
  ABISELECT(-272,-136),
  ABISELECT(96,52),
  ABISELECT(-272,-136),
  (VTBL_ENTRY)&(_ZTI8S7825C35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n80_N8S7825C35D1Ev,_ZTvn56_n40_N8S7825C35D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n80_N8S7825C35D0Ev,_ZTvn56_n40_N8S7825C35D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C242v1Ev,
  ABISELECT(-288,-144),
  (VTBL_ENTRY)&(_ZTI8S7825C35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn128_n80_N8S7825C35D1Ev,_ZTvn64_n40_N8S7825C35D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn128_n80_N8S7825C35D0Ev,_ZTvn64_n40_N8S7825C35D0Ev),
  ABISELECT(-216,-108),
  ABISELECT(-240,-120),
  ABISELECT(-304,-152),
  ABISELECT(-304,-152),
  (VTBL_ENTRY)&(_ZTI8S7825C35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn144_n80_N8S7825C35D1Ev,_ZTvn72_n40_N8S7825C35D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn144_n80_N8S7825C35D0Ev,_ZTvn72_n40_N8S7825C35D0Ev),
  ABISELECT(-336,-172),
  ABISELECT(-248,-128),
  ABISELECT(-272,-140),
  ABISELECT(-336,-172),
  ABISELECT(-336,-172),
  (VTBL_ENTRY)&(_ZTI8S7825C35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C35D1Ev,_ZTv0_n24_N8S7825C35D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C35D0Ev,_ZTv0_n24_N8S7825C35D0Ev),
  ABISELECT(-368,-188),
  ABISELECT(-368,-188),
  (VTBL_ENTRY)&(_ZTI8S7825C35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C35D1Ev,_ZTv0_n12_N8S7825C35D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C35D0Ev,_ZTv0_n12_N8S7825C35D0Ev),
  ABISELECT(-384,-196),
  ABISELECT(-384,-196),
  (VTBL_ENTRY)&(_ZTI8S7825C35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C35D1Ev,_ZTv0_n12_N8S7825C35D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C35D0Ev,_ZTv0_n12_N8S7825C35D0Ev),
  0,
  ABISELECT(-416,-212),
  ABISELECT(-416,-212),
  ABISELECT(-416,-212),
  (VTBL_ENTRY)&(_ZTI8S7825C35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7825C35D1Ev,_ZTv0_n16_N8S7825C35D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7825C35D0Ev,_ZTv0_n16_N8S7825C35D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
  ABISELECT(-432,-220),
  (VTBL_ENTRY)&(_ZTI8S7825C35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n32_N8S7825C35D1Ev,_ZTvn8_n16_N8S7825C35D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n32_N8S7825C35D0Ev,_ZTvn8_n16_N8S7825C35D0Ev),
  ABISELECT(-448,-228),
  (VTBL_ENTRY)&(_ZTI8S7825C35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n32_N8S7825C35D1Ev,_ZTvn16_n16_N8S7825C35D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n32_N8S7825C35D0Ev,_ZTvn16_n16_N8S7825C35D0Ev),
  ABISELECT(16,8),
  ABISELECT(-472,-240),
  ABISELECT(-472,-240),
  ABISELECT(144,76),
  ABISELECT(-56,-28),
  ABISELECT(128,68),
  ABISELECT(112,56),
  ABISELECT(-472,-240),
  ABISELECT(-384,-196),
  ABISELECT(-472,-240),
  ABISELECT(-136,-68),
  ABISELECT(-408,-208),
  ABISELECT(-472,-240),
  (VTBL_ENTRY)&(_ZTI8S7825C35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n104_N8S7825C35D1Ev,_ZTv0_n52_N8S7825C35D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n104_N8S7825C35D0Ev,_ZTv0_n52_N8S7825C35D0Ev),
  ABISELECT(-488,-248),
  ABISELECT(-488,-248),
  (VTBL_ENTRY)&(_ZTI8S7825C35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n104_N8S7825C35D1Ev,_ZTvn8_n52_N8S7825C35D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n104_N8S7825C35D0Ev,_ZTvn8_n52_N8S7825C35D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
  ABISELECT(-504,-256),
  (VTBL_ENTRY)&(_ZTI8S7825C35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n104_N8S7825C35D1Ev,_ZTvn16_n52_N8S7825C35D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n104_N8S7825C35D0Ev,_ZTvn16_n52_N8S7825C35D0Ev),
  ABISELECT(-520,-264),
  (VTBL_ENTRY)&(_ZTI8S7825C35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn48_n104_N8S7825C35D1Ev,_ZTvn24_n52_N8S7825C35D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn48_n104_N8S7825C35D0Ev,_ZTvn24_n52_N8S7825C35D0Ev),
  ABISELECT(-544,-276),
  (VTBL_ENTRY)&(_ZTI8S7825C35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn72_n104_N8S7825C35D1Ev,_ZTvn36_n52_N8S7825C35D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn72_n104_N8S7825C35D0Ev,_ZTvn36_n52_N8S7825C35D0Ev),
  ABISELECT(-560,-284),
  (VTBL_ENTRY)&(_ZTI8S7825C35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn88_n104_N8S7825C35D1Ev,_ZTvn44_n52_N8S7825C35D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn88_n104_N8S7825C35D0Ev,_ZTvn44_n52_N8S7825C35D0Ev),
  ABISELECT(-584,-296),
  ABISELECT(32,20),
  ABISELECT(-584,-296),
  ABISELECT(-168,-84),
  ABISELECT(-584,-296),
  ABISELECT(16,12),
  ABISELECT(-584,-296),
  (VTBL_ENTRY)&(_ZTI8S7825C35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7825C35D1Ev,_ZTv0_n32_N8S7825C35D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S7825C35D0Ev,_ZTv0_n32_N8S7825C35D0Ev),
  ABISELECT(-600,-308),
  ABISELECT(16,8),
  ABISELECT(-600,-308),
  ABISELECT(-184,-96),
  ABISELECT(-600,-308),
  ABISELECT(-600,-308),
  (VTBL_ENTRY)&(_ZTI8S7825C35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7825C35D1Ev,_ZTv0_n28_N8S7825C35D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7825C35D0Ev,_ZTv0_n28_N8S7825C35D0Ev),
  ABISELECT(-616,-316),
  ABISELECT(-616,-316),
  (VTBL_ENTRY)&(_ZTI8S7825C35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C35D1Ev,_ZTv0_n12_N8S7825C35D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C35D0Ev,_ZTv0_n12_N8S7825C35D0Ev),
};
extern VTBL_ENTRY _ZTV8S7825C35[];
extern void _ZN8S7825C36D1Ev();
extern void _ZN8S7825C36D0Ev();
extern void _ZN8S7825C362v3Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C36__8S7825C35[] = {
  ABISELECT(32,16),
  ABISELECT(-16,-8),
  ABISELECT(72,36),
  ABISELECT(48,24),
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C36[0]),
  (VTBL_ENTRY)&_ZN8S7825C36D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C36D0Ev,
  (VTBL_ENTRY)&_ZN8S7825C362v3Ev,
};
extern void _ZN8S7825C12D1Ev();
extern void _ZN8S7825C12D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C128S7825C36__8S7825C35[] = {
  ABISELECT(72,36),
  ABISELECT(48,24),
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&_ZN8S7825C12D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C12D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZThn48_N8S7825C12D1Ev,_ZThn24_N8S7825C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
extern void ABISELECT(_ZThn48_N8S7825C12D0Ev,_ZThn24_N8S7825C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7825C5__A1__8S7825C128S7825C36__8S7825C35[] = {
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev)();
extern void ABISELECT(_ZThn72_N8S7825C12D1Ev,_ZThn36_N8S7825C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev)();
extern void ABISELECT(_ZThn72_N8S7825C12D0Ev,_ZThn36_N8S7825C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C14__8S7825C128S7825C36__8S7825C35[] = {
  ABISELECT(-72,-36),
  ABISELECT(-72,-36),
  (VTBL_ENTRY)&(_ZTI8S7825C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D1Ev,_ZTv0_n12_N8S7825C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C12D0Ev,_ZTv0_n12_N8S7825C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C36D1Ev,_ZTv0_n12_N8S7825C36D1Ev)();
extern void ABISELECT(_ZThn32_N8S7825C36D1Ev,_ZThn16_N8S7825C36D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C36D0Ev,_ZTv0_n12_N8S7825C36D0Ev)();
extern void ABISELECT(_ZThn32_N8S7825C36D0Ev,_ZThn16_N8S7825C36D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S7825C23_nt__8S7825C36__8S7825C35[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S7825C36[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C36D1Ev,_ZTv0_n12_N8S7825C36D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C36D0Ev,_ZTv0_n12_N8S7825C36D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C36D1Ev,_ZTv0_n12_N8S7825C36D1Ev)();
extern void ABISELECT(_ZThn48_N8S7825C36D1Ev,_ZThn24_N8S7825C36D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C36D0Ev,_ZTv0_n12_N8S7825C36D0Ev)();
extern void ABISELECT(_ZThn48_N8S7825C36D0Ev,_ZThn24_N8S7825C36D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7825C5__A1__8S7825C36__8S7825C35[] = {
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S7825C36[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C36D1Ev,_ZTv0_n12_N8S7825C36D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C36D0Ev,_ZTv0_n12_N8S7825C36D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C36D1Ev,_ZTv0_n12_N8S7825C36D1Ev)();
extern void ABISELECT(_ZThn72_N8S7825C36D1Ev,_ZThn36_N8S7825C36D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C36D0Ev,_ZTv0_n12_N8S7825C36D0Ev)();
extern void ABISELECT(_ZThn72_N8S7825C36D0Ev,_ZThn36_N8S7825C36D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C14__8S7825C36__8S7825C35[] = {
  ABISELECT(-72,-36),
  ABISELECT(-72,-36),
  (VTBL_ENTRY)&(_ZTI8S7825C36[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C36D1Ev,_ZTv0_n12_N8S7825C36D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C36D0Ev,_ZTv0_n12_N8S7825C36D0Ev),
};
extern void _ZN8S7825C37D1Ev();
extern void _ZN8S7825C37D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C37__8S7825C35[] = {
  ABISELECT(312,160),
  ABISELECT(280,144),
  ABISELECT(264,136),
  ABISELECT(-104,-52),
  ABISELECT(-16,-8),
  ABISELECT(-40,-20),
  ABISELECT(232,120),
  ABISELECT(56,28),
  ABISELECT(-104,-52),
  ABISELECT(32,16),
  ABISELECT(-104,-52),
  0,
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&_ZN8S7825C37D1Ev,
  (VTBL_ENTRY)&_ZN8S7825C37D0Ev,
};
static  VTBL_ENTRY _tg__ZTV8S7825C34__8S7825C37__8S7825C35[] = {
  0,
  ABISELECT(136,68),
  ABISELECT(104,52),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
};
extern void ABISELECT(_ZTv0_n80_N8S7825C37D1Ev,_ZTv0_n40_N8S7825C37D1Ev)();
extern void ABISELECT(_ZThn56_N8S7825C37D1Ev,_ZThn28_N8S7825C37D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N8S7825C37D0Ev,_ZTv0_n40_N8S7825C37D0Ev)();
extern void ABISELECT(_ZThn56_N8S7825C37D0Ev,_ZThn28_N8S7825C37D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C38__8S7825C37__8S7825C35[] = {
  ABISELECT(112,56),
  ABISELECT(16,8),
  ABISELECT(-56,-28),
  ABISELECT(224,116),
  ABISELECT(208,108),
  ABISELECT(-160,-80),
  ABISELECT(-72,-36),
  ABISELECT(-160,-80),
  ABISELECT(176,92),
  ABISELECT(-96,-48),
  ABISELECT(-56,-28),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S7825C37D1Ev,_ZTv0_n40_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S7825C37D0Ev,_ZTv0_n40_N8S7825C37D0Ev),
};
extern void ABISELECT(_ZTv0_n48_N8S7825C37D1Ev,_ZTv0_n24_N8S7825C37D1Ev)();
extern void ABISELECT(_ZThn232_N8S7825C37D1Ev,_ZThn120_N8S7825C37D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7825C37D0Ev,_ZTv0_n24_N8S7825C37D0Ev)();
extern void ABISELECT(_ZThn232_N8S7825C37D0Ev,_ZThn120_N8S7825C37D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C12__8S7825C37__8S7825C35[] = {
  ABISELECT(-232,-120),
  ABISELECT(-248,-128),
  ABISELECT(-272,-140),
  ABISELECT(-336,-172),
  ABISELECT(-232,-120),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C37D1Ev,_ZTv0_n24_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7825C37D0Ev,_ZTv0_n24_N8S7825C37D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C37D1Ev,_ZTv0_n12_N8S7825C37D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S7825C37D0Ev,_ZTv0_n12_N8S7825C37D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S7825C5__A2__8S7825C37__8S7825C35[] = {
  ABISELECT(40,20),
  ABISELECT(40,20),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C37D1Ev,_ZTv0_n12_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C37D0Ev,_ZTv0_n12_N8S7825C37D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C37D1Ev,_ZTv0_n12_N8S7825C37D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S7825C37D0Ev,_ZTv0_n12_N8S7825C37D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S7825C14__8S7825C37__8S7825C35[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C37D1Ev,_ZTv0_n12_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C37D0Ev,_ZTv0_n12_N8S7825C37D0Ev),
};
extern void ABISELECT(_ZTvn16_n80_N8S7825C37D1Ev,_ZTvn8_n40_N8S7825C37D1Ev)();
extern void ABISELECT(_ZTvn16_n80_N8S7825C37D0Ev,_ZTvn8_n40_N8S7825C37D0Ev)();
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C158S7825C228S7825C298S7825C38__8S7825C37__8S7825C35[] = {
  ABISELECT(-176,-88),
  ABISELECT(-72,-36),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n80_N8S7825C37D1Ev,_ZTvn8_n40_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n80_N8S7825C37D0Ev,_ZTvn8_n40_N8S7825C37D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
extern void ABISELECT(_ZTvn32_n80_N8S7825C37D1Ev,_ZTvn16_n40_N8S7825C37D1Ev)();
extern void ABISELECT(_ZTvn32_n80_N8S7825C37D0Ev,_ZTvn16_n40_N8S7825C37D0Ev)();
static  VTBL_ENTRY _tg__ZTV10S7825C8_nt8S7825C158S7825C228S7825C298S7825C38__A5__8S7825C37__8S7825C35[] = {
  ABISELECT(-88,-44),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n80_N8S7825C37D1Ev,_ZTvn16_n40_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n80_N8S7825C37D0Ev,_ZTvn16_n40_N8S7825C37D0Ev),
};
extern void ABISELECT(_ZTvn48_n80_N8S7825C37D1Ev,_ZTvn24_n40_N8S7825C37D1Ev)();
extern void ABISELECT(_ZTvn48_n80_N8S7825C37D0Ev,_ZTvn24_n40_N8S7825C37D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S7825C58S7825C158S7825C228S7825C298S7825C38__A3__8S7825C37__8S7825C35[] = {
  ABISELECT(-104,-52),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn48_n80_N8S7825C37D1Ev,_ZTvn24_n40_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn48_n80_N8S7825C37D0Ev,_ZTvn24_n40_N8S7825C37D0Ev),
};
extern void ABISELECT(_ZTvn72_n80_N8S7825C37D1Ev,_ZTvn36_n40_N8S7825C37D1Ev)();
extern void ABISELECT(_ZTvn72_n80_N8S7825C37D0Ev,_ZTvn36_n40_N8S7825C37D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S7825C148S7825C228S7825C298S7825C38__A2__8S7825C37__8S7825C35[] = {
  ABISELECT(-128,-64),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn72_n80_N8S7825C37D1Ev,_ZTvn36_n40_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn72_n80_N8S7825C37D0Ev,_ZTvn36_n40_N8S7825C37D0Ev),
};
extern void ABISELECT(_ZTvn88_n80_N8S7825C37D1Ev,_ZTvn44_n40_N8S7825C37D1Ev)();
extern void ABISELECT(_ZTvn88_n80_N8S7825C37D0Ev,_ZTvn44_n40_N8S7825C37D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S7825C58S7825C298S7825C38__A4__8S7825C37__8S7825C35[] = {
  ABISELECT(-144,-72),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn88_n80_N8S7825C37D1Ev,_ZTvn44_n40_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn88_n80_N8S7825C37D0Ev,_ZTvn44_n40_N8S7825C37D0Ev),
};
extern void ABISELECT(_ZTvn112_n80_N8S7825C37D1Ev,_ZTvn56_n40_N8S7825C37D1Ev)();
extern void ABISELECT(_ZTvn112_n80_N8S7825C37D0Ev,_ZTvn56_n40_N8S7825C37D0Ev)();
extern void _ZN8S7825C242v1Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C248S7825C38__8S7825C37__8S7825C35[] = {
  ABISELECT(-208,-104),
  ABISELECT(-272,-136),
  ABISELECT(96,52),
  ABISELECT(-168,-84),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n80_N8S7825C37D1Ev,_ZTvn56_n40_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n80_N8S7825C37D0Ev,_ZTvn56_n40_N8S7825C37D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C242v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7825C37D1Ev,_ZTv0_n12_N8S7825C37D1Ev)();
extern void ABISELECT(_ZThn264_N8S7825C37D1Ev,_ZThn136_N8S7825C37D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C37D0Ev,_ZTv0_n12_N8S7825C37D0Ev)();
extern void ABISELECT(_ZThn264_N8S7825C37D0Ev,_ZThn136_N8S7825C37D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV10S7825C8_nt__A9__8S7825C37__8S7825C35[] = {
  ABISELECT(-264,-136),
  ABISELECT(-264,-136),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C37D1Ev,_ZTv0_n12_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C37D0Ev,_ZTv0_n12_N8S7825C37D0Ev),
};
extern void ABISELECT(_ZTvn128_n80_N8S7825C37D1Ev,_ZTvn64_n40_N8S7825C37D1Ev)();
extern void ABISELECT(_ZTvn128_n80_N8S7825C37D0Ev,_ZTvn64_n40_N8S7825C37D0Ev)();
static  VTBL_ENTRY _tg__ZTV11S7825C23_nt8S7825C248S7825C38__A1__8S7825C37__8S7825C35[] = {
  ABISELECT(-184,-92),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn128_n80_N8S7825C37D1Ev,_ZTvn64_n40_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn128_n80_N8S7825C37D0Ev,_ZTvn64_n40_N8S7825C37D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S7825C37D1Ev,_ZTv0_n12_N8S7825C37D1Ev)();
extern void ABISELECT(_ZThn280_N8S7825C37D1Ev,_ZThn144_N8S7825C37D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7825C37D0Ev,_ZTv0_n12_N8S7825C37D0Ev)();
extern void ABISELECT(_ZThn280_N8S7825C37D0Ev,_ZThn144_N8S7825C37D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7825C26__8S7825C37__8S7825C35[] = {
  ABISELECT(-280,-144),
  ABISELECT(-280,-144),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C37D1Ev,_ZTv0_n12_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7825C37D0Ev,_ZTv0_n12_N8S7825C37D0Ev),
};
extern void ABISELECT(_ZTvn144_n80_N8S7825C37D1Ev,_ZTvn72_n40_N8S7825C37D1Ev)();
extern void ABISELECT(_ZTvn144_n80_N8S7825C37D0Ev,_ZTvn72_n40_N8S7825C37D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S7825C128S7825C38__A1__8S7825C37__8S7825C35[] = {
  ABISELECT(-216,-108),
  ABISELECT(-240,-120),
  ABISELECT(-304,-152),
  ABISELECT(-200,-100),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn144_n80_N8S7825C37D1Ev,_ZTvn72_n40_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn144_n80_N8S7825C37D0Ev,_ZTvn72_n40_N8S7825C37D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S7825C37D1Ev,_ZTv0_n16_N8S7825C37D1Ev)();
extern void ABISELECT(_ZThn312_N8S7825C37D1Ev,_ZThn160_N8S7825C37D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S7825C37D0Ev,_ZTv0_n16_N8S7825C37D0Ev)();
extern void ABISELECT(_ZThn312_N8S7825C37D0Ev,_ZThn160_N8S7825C37D0Ev)() __attribute__((weak));
extern void _ZN8S7825C152v2Ev();
static  VTBL_ENTRY _tg__ZTV8S7825C15__A1__8S7825C37__8S7825C35[] = {
  0,
  ABISELECT(-312,-160),
  ABISELECT(-416,-212),
  ABISELECT(-312,-160),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7825C37D1Ev,_ZTv0_n16_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S7825C37D0Ev,_ZTv0_n16_N8S7825C37D0Ev),
  (VTBL_ENTRY)&_ZN8S7825C152v2Ev,
};
extern void ABISELECT(_ZTvn16_n32_N8S7825C37D1Ev,_ZTvn8_n16_N8S7825C37D1Ev)();
extern void ABISELECT(_ZTvn16_n32_N8S7825C37D0Ev,_ZTvn8_n16_N8S7825C37D0Ev)();
static  VTBL_ENTRY _tg__ZTV10S7825C8_nt8S7825C15__A13__8S7825C37__8S7825C35[] = {
  ABISELECT(-328,-168),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n32_N8S7825C37D1Ev,_ZTvn8_n16_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n32_N8S7825C37D0Ev,_ZTvn8_n16_N8S7825C37D0Ev),
};
extern void ABISELECT(_ZTvn32_n32_N8S7825C37D1Ev,_ZTvn16_n16_N8S7825C37D1Ev)();
extern void ABISELECT(_ZTvn32_n32_N8S7825C37D0Ev,_ZTvn16_n16_N8S7825C37D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S7825C58S7825C15__A6__8S7825C37__8S7825C35[] = {
  ABISELECT(-344,-176),
  (VTBL_ENTRY)&(_ZTI8S7825C37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n32_N8S7825C37D1Ev,_ZTvn16_n16_N8S7825C37D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n32_N8S7825C37D0Ev,_ZTvn16_n16_N8S7825C37D0Ev),
};
static  VTBL_ENTRY _tg__ZTV8S7825C34__8S7825C35[] = {
  0,
  ABISELECT(