// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S836C8_nt  {
  void  mf836c8(); // _ZN9S836C8_nt7mf836c8Ev
};
//SIG(-1 S836C8_nt) C1{ m}


void  S836C8_nt ::mf836c8(){}

//skip512 S836C8_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S836C7_nt  {
  void *s836c7f0;
  int s836c7f1;
  ::S836C8_nt s836c7f2;
  ::S836C8_nt s836c7f3;
  void  mf836c7(); // _ZN9S836C7_nt7mf836c7Ev
};
//SIG(-1 S836C7_nt) C1{ m Fp Fi FC2{ m} FC2}


void  S836C7_nt ::mf836c7(){}

//skip512 S836C7_nt

#else // __cplusplus

Class_Descriptor cd_S836C7_nt = {  "S836C7_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S836C6_nt  : S836C7_nt {
};
//SIG(-1 S836C6_nt) C1{ BC2{ m Fp Fi FC3{ m} FC3}}



//skip512 S836C6_nt

#else // __cplusplus

extern Class_Descriptor cd_S836C7_nt;
static Base_Class bases_S836C6_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S836C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S836C5_nt  {
  void *s836c5f0;
  int s836c5f1;
  ::S836C6_nt s836c5f2;
  ::S836C6_nt s836c5f3;
  int s836c5f4;
  virtual  ~S836C5_nt(); // _ZN9S836C5_ntD1Ev
  virtual void  v1(); // _ZN9S836C5_nt2v1Ev
  virtual void  v2(); // _ZN9S836C5_nt2v2Ev
  virtual void  v3(); // _ZN9S836C5_nt2v3Ev
  virtual void  v4(); // _ZN9S836C5_nt2v4Ev
  virtual void  v5(); // _ZN9S836C5_nt2v5Ev
  virtual void  v6(); // _ZN9S836C5_nt2v6Ev
  virtual void  v7(); // _ZN9S836C5_nt2v7Ev
  virtual void  v8(); // _ZN9S836C5_nt2v8Ev
  virtual void  v9(); // _ZN9S836C5_nt2v9Ev
  virtual void  v10(); // _ZN9S836C5_nt3v10Ev
  virtual void  v11(); // _ZN9S836C5_nt3v11Ev
  virtual void  v12(); // _ZN9S836C5_nt3v12Ev
  virtual void  v13(); // _ZN9S836C5_nt3v13Ev
  virtual void  v14(); // _ZN9S836C5_nt3v14Ev
  virtual void  v15(); // _ZN9S836C5_nt3v15Ev
  virtual void  v16(); // _ZN9S836C5_nt3v16Ev
  virtual void  v17(); // _ZN9S836C5_nt3v17Ev
  virtual void  v18(); // _ZN9S836C5_nt3v18Ev
  virtual void  v19(); // _ZN9S836C5_nt3v19Ev
  virtual void  v20(); // _ZN9S836C5_nt3v20Ev
  virtual void  v21(); // _ZN9S836C5_nt3v21Ev
  virtual void  v22(); // _ZN9S836C5_nt3v22Ev
  virtual void  v23(); // _ZN9S836C5_nt3v23Ev
  S836C5_nt(); // tgen
};
//SIG(-1 S836C5_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC2{ BC3{ m Fp Fi FC4{ m} FC4}} FC2 Fi}


 S836C5_nt ::~S836C5_nt(){ note_dtor("S836C5_nt", this);}
void  S836C5_nt ::v1(){vfunc_called(this, "_ZN9S836C5_nt2v1Ev");}
void  S836C5_nt ::v2(){vfunc_called(this, "_ZN9S836C5_nt2v2Ev");}
void  S836C5_nt ::v3(){vfunc_called(this, "_ZN9S836C5_nt2v3Ev");}
void  S836C5_nt ::v4(){vfunc_called(this, "_ZN9S836C5_nt2v4Ev");}
void  S836C5_nt ::v5(){vfunc_called(this, "_ZN9S836C5_nt2v5Ev");}
void  S836C5_nt ::v6(){vfunc_called(this, "_ZN9S836C5_nt2v6Ev");}
void  S836C5_nt ::v7(){vfunc_called(this, "_ZN9S836C5_nt2v7Ev");}
void  S836C5_nt ::v8(){vfunc_called(this, "_ZN9S836C5_nt2v8Ev");}
void  S836C5_nt ::v9(){vfunc_called(this, "_ZN9S836C5_nt2v9Ev");}
void  S836C5_nt ::v10(){vfunc_called(this, "_ZN9S836C5_nt3v10Ev");}
void  S836C5_nt ::v11(){vfunc_called(this, "_ZN9S836C5_nt3v11Ev");}
void  S836C5_nt ::v12(){vfunc_called(this, "_ZN9S836C5_nt3v12Ev");}
void  S836C5_nt ::v13(){vfunc_called(this, "_ZN9S836C5_nt3v13Ev");}
void  S836C5_nt ::v14(){vfunc_called(this, "_ZN9S836C5_nt3v14Ev");}
void  S836C5_nt ::v15(){vfunc_called(this, "_ZN9S836C5_nt3v15Ev");}
void  S836C5_nt ::v16(){vfunc_called(this, "_ZN9S836C5_nt3v16Ev");}
void  S836C5_nt ::v17(){vfunc_called(this, "_ZN9S836C5_nt3v17Ev");}
void  S836C5_nt ::v18(){vfunc_called(this, "_ZN9S836C5_nt3v18Ev");}
void  S836C5_nt ::v19(){vfunc_called(this, "_ZN9S836C5_nt3v19Ev");}
void  S836C5_nt ::v20(){vfunc_called(this, "_ZN9S836C5_nt3v20Ev");}
void  S836C5_nt ::v21(){vfunc_called(this, "_ZN9S836C5_nt3v21Ev");}
void  S836C5_nt ::v22(){vfunc_called(this, "_ZN9S836C5_nt3v22Ev");}
void  S836C5_nt ::v23(){vfunc_called(this, "_ZN9S836C5_nt3v23Ev");}
S836C5_nt ::S836C5_nt(){ note_ctor("S836C5_nt", this);} // tgen

//skip512 S836C5_nt

#else // __cplusplus

extern void _ZN9S836C5_ntC1Ev();
extern void _ZN9S836C5_ntD1Ev();
Name_Map name_map_S836C5_nt[] = {
  NSPAIR(_ZN9S836C5_ntC1Ev),
  NSPAIR(_ZN9S836C5_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S836C5_nt[];
extern void _ZN9S836C5_ntD1Ev();
extern void _ZN9S836C5_ntD0Ev();
extern void _ZN9S836C5_nt2v1Ev();
extern void _ZN9S836C5_nt2v2Ev();
extern void _ZN9S836C5_nt2v3Ev();
extern void _ZN9S836C5_nt2v4Ev();
extern void _ZN9S836C5_nt2v5Ev();
extern void _ZN9S836C5_nt2v6Ev();
extern void _ZN9S836C5_nt2v7Ev();
extern void _ZN9S836C5_nt2v8Ev();
extern void _ZN9S836C5_nt2v9Ev();
extern void _ZN9S836C5_nt3v10Ev();
extern void _ZN9S836C5_nt3v11Ev();
extern void _ZN9S836C5_nt3v12Ev();
extern void _ZN9S836C5_nt3v13Ev();
extern void _ZN9S836C5_nt3v14Ev();
extern void _ZN9S836C5_nt3v15Ev();
extern void _ZN9S836C5_nt3v16Ev();
extern void _ZN9S836C5_nt3v17Ev();
extern void _ZN9S836C5_nt3v18Ev();
extern void _ZN9S836C5_nt3v19Ev();
extern void _ZN9S836C5_nt3v20Ev();
extern void _ZN9S836C5_nt3v21Ev();
extern void _ZN9S836C5_nt3v22Ev();
extern void _ZN9S836C5_nt3v23Ev();
static  VTBL_ENTRY vtc_S836C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S836C5_nt[0]),
  (VTBL_ENTRY)&_ZN9S836C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S836C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v2Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v3Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v4Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v23Ev,
};
extern VTBL_ENTRY _ZTI9S836C5_nt[];
VTBL_ENTRY *P__ZTI9S836C5_nt = _ZTI9S836C5_nt; 
extern  VTBL_ENTRY _ZTV9S836C5_nt[];
Class_Descriptor cd_S836C5_nt = {  "S836C5_nt", // class name
  0,0,//no base classes
  &(vtc_S836C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI9S836C5_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S836C5_nt),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S836C15_nt  {
  __tsi64 s836c15f0[2];
  void  mf836c15(); // _ZN10S836C15_nt8mf836c15Ev
};
//SIG(-1 S836C15_nt) C1{ m FL[2]}


void  S836C15_nt ::mf836c15(){}

//skip512 S836C15_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S836C14_nt  {
  ::S836C15_nt s836c14f0;
  void  mf836c14(); // _ZN10S836C14_nt8mf836c14Ev
};
//SIG(-1 S836C14_nt) C1{ m FC2{ m FL[2]}}


void  S836C14_nt ::mf836c14(){}

//skip512 S836C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S836C18_nt  {
  ::S836C14_nt s836c18f0;
  void  mf836c18(); // _ZN10S836C18_nt8mf836c18Ev
};
//SIG(-1 S836C18_nt) C1{ m FC2{ m FC3{ m FL[2]}}}


void  S836C18_nt ::mf836c18(){}

//skip512 S836C18_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S836C19_nt  {
  ::S836C14_nt s836c19f0;
  ::S836C14_nt s836c19f1;
  ::S836C14_nt s836c19f2;
  ::S836C14_nt s836c19f3;
  void  mf836c19(); // _ZN10S836C19_nt8mf836c19Ev
};
//SIG(-1 S836C19_nt) C1{ m FC2{ m FC3{ m FL[2]}} FC2 FC2 FC2}


void  S836C19_nt ::mf836c19(){}

//skip512 S836C19_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S836C22  {
  void  mf836c22(); // _ZN7S836C228mf836c22Ev
};
//SIG(-1 S836C22) C1{ m}


void  S836C22 ::mf836c22(){}

static void Test_S836C22()
{
  {
    init_simple_test("S836C22");
    S836C22 lv;
    check2(sizeof(lv), 1, "sizeof(S836C22)");
    check2(__alignof__(lv), 1, "__alignof__(S836C22)");
  }
}
static Arrange_To_Call_Me vS836C22(Test_S836C22, "S836C22", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S836C21_nt  {
  void *s836c21f0;
  int s836c21f1;
  ::S836C22 s836c21f2;
  void  mf836c21(); // _ZN10S836C21_nt8mf836c21Ev
};
//SIG(-1 S836C21_nt) C1{ m Fp Fi FC2{ m}}


void  S836C21_nt ::mf836c21(){}

//skip512 S836C21_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S836C20_nt  {
  ::S836C21_nt s836c20f0;
  int s836c20f1;
  void  mf836c20(); // _ZN10S836C20_nt8mf836c20Ev
};
//SIG(-1 S836C20_nt) C1{ m FC2{ m Fp Fi FC3{ m}} Fi}


void  S836C20_nt ::mf836c20(){}

//skip512 S836C20_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S836C25  {
  void  mf836c25(); // _ZN7S836C258mf836c25Ev
};
//SIG(-1 S836C25) C1{ m}


void  S836C25 ::mf836c25(){}

static void Test_S836C25()
{
  {
    init_simple_test("S836C25");
    S836C25 lv;
    check2(sizeof(lv), 1, "sizeof(S836C25)");
    check2(__alignof__(lv), 1, "__alignof__(S836C25)");
  }
}
static Arrange_To_Call_Me vS836C25(Test_S836C25, "S836C25", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S836C23  {
  void *s836c23f0;
  int s836c23f1;
  ::S836C22 s836c23f2;
  ::S836C25 s836c23f3;
  void  mf836c23(); // _ZN7S836C238mf836c23Ev
};
//SIG(-1 S836C23) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S836C23 ::mf836c23(){}

static void Test_S836C23()
{
  {
    init_simple_test("S836C23");
    S836C23 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S836C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S836C23)");
    check_field_offset(lv, s836c23f0, 0, "S836C23.s836c23f0");
    check_field_offset(lv, s836c23f1, ABISELECT(8,4), "S836C23.s836c23f1");
    check_field_offset(lv, s836c23f2, ABISELECT(12,8), "S836C23.s836c23f2");
    check_field_offset(lv, s836c23f3, ABISELECT(13,9), "S836C23.s836c23f3");
  }
}
static Arrange_To_Call_Me vS836C23(Test_S836C23, "S836C23", ABISELECT(16,12));

#else // __cplusplus

Class_Descriptor cd_S836C23 = {  "S836C23", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S836C29  {
  void  mf836c29(); // _ZN7S836C298mf836c29Ev
};
//SIG(-1 S836C29) C1{ m}


void  S836C29 ::mf836c29(){}

static void Test_S836C29()
{
  {
    init_simple_test("S836C29");
    S836C29 lv;
    check2(sizeof(lv), 1, "sizeof(S836C29)");
    check2(__alignof__(lv), 1, "__alignof__(S836C29)");
  }
}
static Arrange_To_Call_Me vS836C29(Test_S836C29, "S836C29", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI7S836C29[];
VTBL_ENTRY *P__ZTI7S836C29 = _ZTI7S836C29; 
Class_Descriptor cd_S836C29 = {  "S836C29", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI7S836C29),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S836C27  {
  void *s836c27f0;
  int s836c27f1;
  ::S836C25 s836c27f2;
  ::S836C29 s836c27f3;
  void  mf836c27(); // _ZN7S836C278mf836c27Ev
};
//SIG(-1 S836C27) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S836C27 ::mf836c27(){}

static void Test_S836C27()
{
  {
    init_simple_test("S836C27");
    S836C27 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S836C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S836C27)");
    check_field_offset(lv, s836c27f0, 0, "S836C27.s836c27f0");
    check_field_offset(lv, s836c27f1, ABISELECT(8,4), "S836C27.s836c27f1");
    check_field_offset(lv, s836c27f2, ABISELECT(12,8), "S836C27.s836c27f2");
    check_field_offset(lv, s836c27f3, ABISELECT(13,9), "S836C27.s836c27f3");
  }
}
static Arrange_To_Call_Me vS836C27(Test_S836C27, "S836C27", ABISELECT(16,12));

#else // __cplusplus

Class_Descriptor cd_S836C27 = {  "S836C27", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S836C26  : S836C27 {
};
//SIG(-1 S836C26) C1{ BC2{ m Fp Fi FC3{ m} FC4{ m}}}



static void Test_S836C26()
{
  extern Class_Descriptor cd_S836C26;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S836C26, buf);
    S836C26 &lv = *(new (buf) S836C26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S836C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S836C26)");
    check_base_class_offset(lv, (S836C27*), 0, "S836C26");
    test_class_info(&lv, &cd_S836C26);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS836C26(Test_S836C26, "S836C26", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S836C27;
static Base_Class bases_S836C26[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S836C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S836C26 = {  "S836C26", // class name
  bases_S836C26, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S836C30_nt  {
  void *s836c30f0;
  int s836c30f1[2];
  ::S836C29 s836c30f2;
  void  mf836c30(); // _ZN10S836C30_nt8mf836c30Ev
};
//SIG(-1 S836C30_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S836C30_nt ::mf836c30(){}

//skip512 S836C30_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S836C39  {
  void  mf836c39(); // _ZN7S836C398mf836c39Ev
};
//SIG(-1 S836C39) C1{ m}


void  S836C39 ::mf836c39(){}

static void Test_S836C39()
{
  {
    init_simple_test("S836C39");
    S836C39 lv;
    check2(sizeof(lv), 1, "sizeof(S836C39)");
    check2(__alignof__(lv), 1, "__alignof__(S836C39)");
  }
}
static Arrange_To_Call_Me vS836C39(Test_S836C39, "S836C39", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI7S836C39[];
VTBL_ENTRY *P__ZTI7S836C39 = _ZTI7S836C39; 
Class_Descriptor cd_S836C39 = {  "S836C39", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI7S836C39),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S836C38  {
  void *s836c38f0;
  int s836c38f1[2];
  ::S836C39 s836c38f2;
  void  mf836c38(); // _ZN7S836C388mf836c38Ev
};
//SIG(-1 S836C38) C1{ m Fp Fi[2] FC2{ m}}


void  S836C38 ::mf836c38(){}

static void Test_S836C38()
{
  {
    init_simple_test("S836C38");
    S836C38 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S836C38)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S836C38)");
    check_field_offset(lv, s836c38f0, 0, "S836C38.s836c38f0");
    check_field_offset(lv, s836c38f1, ABISELECT(8,4), "S836C38.s836c38f1");
    check_field_offset(lv, s836c38f2, ABISELECT(16,12), "S836C38.s836c38f2");
  }
}
static Arrange_To_Call_Me vS836C38(Test_S836C38, "S836C38", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S836C4_nt  : S836C5_nt {
  ::S836C14_nt s836c4f0;
  ::S836C14_nt s836c4f1;
  ::S836C14_nt s836c4f2;
  ::S836C14_nt s836c4f3;
  ::S836C18_nt s836c4f4;
  ::S836C19_nt s836c4f5;
  ::S836C19_nt s836c4f6;
  ::S836C14_nt s836c4f7;
  ::S836C14_nt s836c4f8;
  ::S836C14_nt s836c4f9;
  void *s836c4f10;
  ::S836C18_nt s836c4f11;
  ::S836C20_nt s836c4f12;
  int s836c4f13;
  void *s836c4f14[7];
  ::S836C23 s836c4f15;
  int s836c4f16:8;
  int s836c4f17:8;
  int s836c4f18:16;
  int s836c4f19:16;
  int s836c4f20:8;
  int s836c4f21:8;
  int s836c4f22:8;
  int s836c4f23:32;
  int s836c4f24:8;
  int s836c4f25:4;
  int s836c4f26:4;
  int s836c4f27:4;
  int s836c4f28:4;
  int s836c4f29:4;
  int s836c4f30:4;
  int s836c4f31:4;
  int s836c4f32:4;
  int s836c4f33:4;
  int s836c4f34:4;
  unsigned char s836c4f35:1;
  unsigned char s836c4f36:1;
  unsigned char s836c4f37:1;
  unsigned char s836c4f38:1;
  unsigned char s836c4f39:1;
  unsigned char s836c4f40:1;
  unsigned char s836c4f41:1;
  unsigned char s836c4f42:1;
  unsigned char s836c4f43:1;
  unsigned char s836c4f44:1;
  unsigned char s836c4f45:1;
  unsigned char s836c4f46:1;
  unsigned char s836c4f47:1;
  unsigned char s836c4f48:1;
  unsigned char s836c4f49:1;
  unsigned char s836c4f50:1;
  unsigned char s836c4f51:1;
  unsigned char s836c4f52:1;
  unsigned char s836c4f53:1;
  unsigned char s836c4f54:1;
  unsigned char s836c4f55:1;
  unsigned char s836c4f56:1;
  unsigned char s836c4f57:1;
  unsigned char s836c4f58:1;
  unsigned char s836c4f59:1;
  unsigned char s836c4f60:1;
  unsigned char s836c4f61:1;
  unsigned char s836c4f62:1;
  unsigned char s836c4f63:1;
  unsigned char s836c4f64:1;
  unsigned char s836c4f65:1;
  unsigned char s836c4f66:1;
  unsigned char s836c4f67:1;
  unsigned char s836c4f68:1;
  unsigned char s836c4f69:1;
  unsigned char s836c4f70:1;
  unsigned char s836c4f71:1;
  unsigned char s836c4f72:1;
  unsigned char s836c4f73:1;
  unsigned char s836c4f74:1;
  unsigned char s836c4f75:1;
  int s836c4f76[7];
  void *s836c4f77[6];
  int s836c4f78:8;
  int s836c4f79:8;
  int s836c4f80:8;
  int s836c4f81:8;
  int s836c4f82:8;
  int s836c4f83:8;
  ::S836C26 s836c4f84;
  void *s836c4f85[4];
  int s836c4f86:8;
  int s836c4f87:8;
  int s836c4f88:8;
  int s836c4f89:8;
  int s836c4f90:8;
  int s836c4f91:16;
  int s836c4f92:16;
  int s836c4f93:16;
  int s836c4f94:4;
  int s836c4f95:4;
  int s836c4f96:4;
  int s836c4f97:4;
  int s836c4f98:4;
  int s836c4f99:4;
  int s836c4f100:4;
  int s836c4f101:4;
  int s836c4f102:4;
  int s836c4f103:4;
  int s836c4f104:4;
  int s836c4f105:4;
  int s836c4f106:8;
  int s836c4f107:8;
  int s836c4f108:8;
  void *s836c4f109[7];
  ::S836C30_nt s836c4f110;
  void *s836c4f111[2];
  int s836c4f112:16;
  int s836c4f113:16;
  ::S836C26 s836c4f114;
  ::S836C30_nt s836c4f115;
  ::S836C38 s836c4f116;
  void *s836c4f117[2];
  int s836c4f118:24;
  int s836c4f119:8;
  void *s836c4f120;
  virtual  ~S836C4_nt(); // _ZN9S836C4_ntD1Ev
  virtual void  v24(); // _ZN9S836C4_nt3v24Ev
  virtual void  v25(); // _ZN9S836C4_nt3v25Ev
  virtual void  v26(); // _ZN9S836C4_nt3v26Ev
  virtual void  v27(); // _ZN9S836C4_nt3v27Ev
  virtual void  v28(); // _ZN9S836C4_nt3v28Ev
  virtual void  v29(); // _ZN9S836C4_nt3v29Ev
  virtual void  v30(); // _ZN9S836C4_nt3v30Ev
  virtual void  v31(); // _ZN9S836C4_nt3v31Ev
  virtual void  v32(); // _ZN9S836C4_nt3v32Ev
  virtual void  v33(); // _ZN9S836C4_nt3v33Ev
  virtual void  v34(); // _ZN9S836C4_nt3v34Ev
  virtual void  v35(); // _ZN9S836C4_nt3v35Ev
  virtual void  v36(); // _ZN9S836C4_nt3v36Ev
  virtual void  v37(); // _ZN9S836C4_nt3v37Ev
  virtual void  v38(); // _ZN9S836C4_nt3v38Ev
  virtual void  v39(); // _ZN9S836C4_nt3v39Ev
  virtual void  v40(); // _ZN9S836C4_nt3v40Ev
  virtual void  v41(); // _ZN9S836C4_nt3v41Ev
  virtual void  v42(); // _ZN9S836C4_nt3v42Ev
  virtual void  v43(); // _ZN9S836C4_nt3v43Ev
  virtual void  v44(); // _ZN9S836C4_nt3v44Ev
  virtual void  v45(); // _ZN9S836C4_nt3v45Ev
  virtual void  v46(); // _ZN9S836C4_nt3v46Ev
  virtual void  v47(); // _ZN9S836C4_nt3v47Ev
  virtual void  v48(); // _ZN9S836C4_nt3v48Ev
  virtual void  v49(); // _ZN9S836C4_nt3v49Ev
  virtual void  v50(); // _ZN9S836C4_nt3v50Ev
  virtual void  v51(); // _ZN9S836C4_nt3v51Ev
  virtual void  v52(); // _ZN9S836C4_nt3v52Ev
  virtual void  v53(); // _ZN9S836C4_nt3v53Ev
  virtual void  v54(); // _ZN9S836C4_nt3v54Ev
  virtual void  v55(); // _ZN9S836C4_nt3v55Ev
  virtual void  v56(); // _ZN9S836C4_nt3v56Ev
  virtual void  v57(); // _ZN9S836C4_nt3v57Ev
  virtual void  v58(); // _ZN9S836C4_nt3v58Ev
  virtual void  v59(); // _ZN9S836C4_nt3v59Ev
  virtual void  v60(); // _ZN9S836C4_nt3v60Ev
  virtual void  v61(); // _ZN9S836C4_nt3v61Ev
  virtual void  v62(); // _ZN9S836C4_nt3v62Ev
  virtual void  v63(); // _ZN9S836C4_nt3v63Ev
  virtual void  v64(); // _ZN9S836C4_nt3v64Ev
  virtual void  v65(); // _ZN9S836C4_nt3v65Ev
  virtual void  v66(); // _ZN9S836C4_nt3v66Ev
  virtual void  v67(); // _ZN9S836C4_nt3v67Ev
  virtual void  v68(); // _ZN9S836C4_nt3v68Ev
  virtual void  v69(); // _ZN9S836C4_nt3v69Ev
  virtual void  v70(); // _ZN9S836C4_nt3v70Ev
  virtual void  v71(); // _ZN9S836C4_nt3v71Ev
  virtual void  v72(); // _ZN9S836C4_nt3v72Ev
  virtual void  v73(); // _ZN9S836C4_nt3v73Ev
  virtual void  v74(); // _ZN9S836C4_nt3v74Ev
  virtual void  v75(); // _ZN9S836C4_nt3v75Ev
  virtual void  v76(); // _ZN9S836C4_nt3v76Ev
  virtual void  v77(); // _ZN9S836C4_nt3v77Ev
  virtual void  v78(); // _ZN9S836C4_nt3v78Ev
  virtual void  v79(); // _ZN9S836C4_nt3v79Ev
  virtual void  v80(); // _ZN9S836C4_nt3v80Ev
  virtual void  v81(); // _ZN9S836C4_nt3v81Ev
  virtual void  v82(); // _ZN9S836C4_nt3v82Ev
  virtual void  v83(); // _ZN9S836C4_nt3v83Ev
  virtual void  v84(); // _ZN9S836C4_nt3v84Ev
  virtual void  v85(); // _ZN9S836C4_nt3v85Ev
  virtual void  v86(); // _ZN9S836C4_nt3v86Ev
  virtual void  v87(); // _ZN9S836C4_nt3v87Ev
  virtual void  v88(); // _ZN9S836C4_nt3v88Ev
  virtual void  v89(); // _ZN9S836C4_nt3v89Ev
  virtual void  v90(); // _ZN9S836C4_nt3v90Ev
  virtual void  v91(); // _ZN9S836C4_nt3v91Ev
  virtual void  v92(); // _ZN9S836C4_nt3v92Ev
  virtual void  v93(); // _ZN9S836C4_nt3v93Ev
  virtual void  v94(); // _ZN9S836C4_nt3v94Ev
  virtual void  v95(); // _ZN9S836C4_nt3v95Ev
  virtual void  v96(); // _ZN9S836C4_nt3v96Ev
  virtual void  v97(); // _ZN9S836C4_nt3v97Ev
  virtual void  v98(); // _ZN9S836C4_nt3v98Ev
  virtual void  v99(); // _ZN9S836C4_nt3v99Ev
  virtual void  v100(); // _ZN9S836C4_nt4v100Ev
  virtual void  v101(); // _ZN9S836C4_nt4v101Ev
  S836C4_nt(); // tgen
};
//SIG(-1 S836C4_nt) C1{ BC2{ vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fp Fi FC3{ BC4{ m Fp Fi FC5{ m} FC5}} FC3 Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 FC6{ m FC7{ m FL[2]}} FC6 FC6 FC6 FC8{ m FC6} FC9{ m FC6 FC6 FC6 FC6} FC9 FC6 FC6 FC6 Fp FC8 FC10{ m FC11{ m Fp Fi FC12{ m}} Fi} Fi Fp[7] FC13{ m Fp Fi FC12 FC14{ m}} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC15{ BC16{ m Fp Fi FC14 FC17{ m}}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC18{ m Fp Fi[2] FC17} Fp[2] Fi:16 Fi:16 FC15 FC18 FC19{ m Fp Fi[2] FC20{ m}} Fp[2] Fi:24 Fi:8 Fp}


 S836C4_nt ::~S836C4_nt(){ note_dtor("S836C4_nt", this);}
void  S836C4_nt ::v24(){vfunc_called(this, "_ZN9S836C4_nt3v24Ev");}
void  S836C4_nt ::v25(){vfunc_called(this, "_ZN9S836C4_nt3v25Ev");}
void  S836C4_nt ::v26(){vfunc_called(this, "_ZN9S836C4_nt3v26Ev");}
void  S836C4_nt ::v27(){vfunc_called(this, "_ZN9S836C4_nt3v27Ev");}
void  S836C4_nt ::v28(){vfunc_called(this, "_ZN9S836C4_nt3v28Ev");}
void  S836C4_nt ::v29(){vfunc_called(this, "_ZN9S836C4_nt3v29Ev");}
void  S836C4_nt ::v30(){vfunc_called(this, "_ZN9S836C4_nt3v30Ev");}
void  S836C4_nt ::v31(){vfunc_called(this, "_ZN9S836C4_nt3v31Ev");}
void  S836C4_nt ::v32(){vfunc_called(this, "_ZN9S836C4_nt3v32Ev");}
void  S836C4_nt ::v33(){vfunc_called(this, "_ZN9S836C4_nt3v33Ev");}
void  S836C4_nt ::v34(){vfunc_called(this, "_ZN9S836C4_nt3v34Ev");}
void  S836C4_nt ::v35(){vfunc_called(this, "_ZN9S836C4_nt3v35Ev");}
void  S836C4_nt ::v36(){vfunc_called(this, "_ZN9S836C4_nt3v36Ev");}
void  S836C4_nt ::v37(){vfunc_called(this, "_ZN9S836C4_nt3v37Ev");}
void  S836C4_nt ::v38(){vfunc_called(this, "_ZN9S836C4_nt3v38Ev");}
void  S836C4_nt ::v39(){vfunc_called(this, "_ZN9S836C4_nt3v39Ev");}
void  S836C4_nt ::v40(){vfunc_called(this, "_ZN9S836C4_nt3v40Ev");}
void  S836C4_nt ::v41(){vfunc_called(this, "_ZN9S836C4_nt3v41Ev");}
void  S836C4_nt ::v42(){vfunc_called(this, "_ZN9S836C4_nt3v42Ev");}
void  S836C4_nt ::v43(){vfunc_called(this, "_ZN9S836C4_nt3v43Ev");}
void  S836C4_nt ::v44(){vfunc_called(this, "_ZN9S836C4_nt3v44Ev");}
void  S836C4_nt ::v45(){vfunc_called(this, "_ZN9S836C4_nt3v45Ev");}
void  S836C4_nt ::v46(){vfunc_called(this, "_ZN9S836C4_nt3v46Ev");}
void  S836C4_nt ::v47(){vfunc_called(this, "_ZN9S836C4_nt3v47Ev");}
void  S836C4_nt ::v48(){vfunc_called(this, "_ZN9S836C4_nt3v48Ev");}
void  S836C4_nt ::v49(){vfunc_called(this, "_ZN9S836C4_nt3v49Ev");}
void  S836C4_nt ::v50(){vfunc_called(this, "_ZN9S836C4_nt3v50Ev");}
void  S836C4_nt ::v51(){vfunc_called(this, "_ZN9S836C4_nt3v51Ev");}
void  S836C4_nt ::v52(){vfunc_called(this, "_ZN9S836C4_nt3v52Ev");}
void  S836C4_nt ::v53(){vfunc_called(this, "_ZN9S836C4_nt3v53Ev");}
void  S836C4_nt ::v54(){vfunc_called(this, "_ZN9S836C4_nt3v54Ev");}
void  S836C4_nt ::v55(){vfunc_called(this, "_ZN9S836C4_nt3v55Ev");}
void  S836C4_nt ::v56(){vfunc_called(this, "_ZN9S836C4_nt3v56Ev");}
void  S836C4_nt ::v57(){vfunc_called(this, "_ZN9S836C4_nt3v57Ev");}
void  S836C4_nt ::v58(){vfunc_called(this, "_ZN9S836C4_nt3v58Ev");}
void  S836C4_nt ::v59(){vfunc_called(this, "_ZN9S836C4_nt3v59Ev");}
void  S836C4_nt ::v60(){vfunc_called(this, "_ZN9S836C4_nt3v60Ev");}
void  S836C4_nt ::v61(){vfunc_called(this, "_ZN9S836C4_nt3v61Ev");}
void  S836C4_nt ::v62(){vfunc_called(this, "_ZN9S836C4_nt3v62Ev");}
void  S836C4_nt ::v63(){vfunc_called(this, "_ZN9S836C4_nt3v63Ev");}
void  S836C4_nt ::v64(){vfunc_called(this, "_ZN9S836C4_nt3v64Ev");}
void  S836C4_nt ::v65(){vfunc_called(this, "_ZN9S836C4_nt3v65Ev");}
void  S836C4_nt ::v66(){vfunc_called(this, "_ZN9S836C4_nt3v66Ev");}
void  S836C4_nt ::v67(){vfunc_called(this, "_ZN9S836C4_nt3v67Ev");}
void  S836C4_nt ::v68(){vfunc_called(this, "_ZN9S836C4_nt3v68Ev");}
void  S836C4_nt ::v69(){vfunc_called(this, "_ZN9S836C4_nt3v69Ev");}
void  S836C4_nt ::v70(){vfunc_called(this, "_ZN9S836C4_nt3v70Ev");}
void  S836C4_nt ::v71(){vfunc_called(this, "_ZN9S836C4_nt3v71Ev");}
void  S836C4_nt ::v72(){vfunc_called(this, "_ZN9S836C4_nt3v72Ev");}
void  S836C4_nt ::v73(){vfunc_called(this, "_ZN9S836C4_nt3v73Ev");}
void  S836C4_nt ::v74(){vfunc_called(this, "_ZN9S836C4_nt3v74Ev");}
void  S836C4_nt ::v75(){vfunc_called(this, "_ZN9S836C4_nt3v75Ev");}
void  S836C4_nt ::v76(){vfunc_called(this, "_ZN9S836C4_nt3v76Ev");}
void  S836C4_nt ::v77(){vfunc_called(this, "_ZN9S836C4_nt3v77Ev");}
void  S836C4_nt ::v78(){vfunc_called(this, "_ZN9S836C4_nt3v78Ev");}
void  S836C4_nt ::v79(){vfunc_called(this, "_ZN9S836C4_nt3v79Ev");}
void  S836C4_nt ::v80(){vfunc_called(this, "_ZN9S836C4_nt3v80Ev");}
void  S836C4_nt ::v81(){vfunc_called(this, "_ZN9S836C4_nt3v81Ev");}
void  S836C4_nt ::v82(){vfunc_called(this, "_ZN9S836C4_nt3v82Ev");}
void  S836C4_nt ::v83(){vfunc_called(this, "_ZN9S836C4_nt3v83Ev");}
void  S836C4_nt ::v84(){vfunc_called(this, "_ZN9S836C4_nt3v84Ev");}
void  S836C4_nt ::v85(){vfunc_called(this, "_ZN9S836C4_nt3v85Ev");}
void  S836C4_nt ::v86(){vfunc_called(this, "_ZN9S836C4_nt3v86Ev");}
void  S836C4_nt ::v87(){vfunc_called(this, "_ZN9S836C4_nt3v87Ev");}
void  S836C4_nt ::v88(){vfunc_called(this, "_ZN9S836C4_nt3v88Ev");}
void  S836C4_nt ::v89(){vfunc_called(this, "_ZN9S836C4_nt3v89Ev");}
void  S836C4_nt ::v90(){vfunc_called(this, "_ZN9S836C4_nt3v90Ev");}
void  S836C4_nt ::v91(){vfunc_called(this, "_ZN9S836C4_nt3v91Ev");}
void  S836C4_nt ::v92(){vfunc_called(this, "_ZN9S836C4_nt3v92Ev");}
void  S836C4_nt ::v93(){vfunc_called(this, "_ZN9S836C4_nt3v93Ev");}
void  S836C4_nt ::v94(){vfunc_called(this, "_ZN9S836C4_nt3v94Ev");}
void  S836C4_nt ::v95(){vfunc_called(this, "_ZN9S836C4_nt3v95Ev");}
void  S836C4_nt ::v96(){vfunc_called(this, "_ZN9S836C4_nt3v96Ev");}
void  S836C4_nt ::v97(){vfunc_called(this, "_ZN9S836C4_nt3v97Ev");}
void  S836C4_nt ::v98(){vfunc_called(this, "_ZN9S836C4_nt3v98Ev");}
void  S836C4_nt ::v99(){vfunc_called(this, "_ZN9S836C4_nt3v99Ev");}
void  S836C4_nt ::v100(){vfunc_called(this, "_ZN9S836C4_nt4v100Ev");}
void  S836C4_nt ::v101(){vfunc_called(this, "_ZN9S836C4_nt4v101Ev");}
S836C4_nt ::S836C4_nt(){ note_ctor("S836C4_nt", this);} // tgen

//skip512 S836C4_nt

#else // __cplusplus

extern void _ZN9S836C4_ntC1Ev();
extern void _ZN9S836C4_ntD1Ev();
Name_Map name_map_S836C4_nt[] = {
  NSPAIR(_ZN9S836C4_ntC1Ev),
  NSPAIR(_ZN9S836C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S836C5_nt;
extern VTBL_ENTRY _ZTI9S836C5_nt[];
extern  VTBL_ENTRY _ZTV9S836C5_nt[];
static Base_Class bases_S836C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S836C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S836C4_nt[];
extern void _ZN9S836C4_ntD1Ev();
extern void _ZN9S836C4_ntD0Ev();
extern void _ZN9S836C5_nt2v1Ev();
extern void _ZN9S836C5_nt2v2Ev();
extern void _ZN9S836C5_nt2v3Ev();
extern void _ZN9S836C5_nt2v4Ev();
extern void _ZN9S836C5_nt2v5Ev();
extern void _ZN9S836C5_nt2v6Ev();
extern void _ZN9S836C5_nt2v7Ev();
extern void _ZN9S836C5_nt2v8Ev();
extern void _ZN9S836C5_nt2v9Ev();
extern void _ZN9S836C5_nt3v10Ev();
extern void _ZN9S836C5_nt3v11Ev();
extern void _ZN9S836C5_nt3v12Ev();
extern void _ZN9S836C5_nt3v13Ev();
extern void _ZN9S836C5_nt3v14Ev();
extern void _ZN9S836C5_nt3v15Ev();
extern void _ZN9S836C5_nt3v16Ev();
extern void _ZN9S836C5_nt3v17Ev();
extern void _ZN9S836C5_nt3v18Ev();
extern void _ZN9S836C5_nt3v19Ev();
extern void _ZN9S836C5_nt3v20Ev();
extern void _ZN9S836C5_nt3v21Ev();
extern void _ZN9S836C5_nt3v22Ev();
extern void _ZN9S836C5_nt3v23Ev();
extern void _ZN9S836C4_nt3v24Ev();
extern void _ZN9S836C4_nt3v25Ev();
extern void _ZN9S836C4_nt3v26Ev();
extern void _ZN9S836C4_nt3v27Ev();
extern void _ZN9S836C4_nt3v28Ev();
extern void _ZN9S836C4_nt3v29Ev();
extern void _ZN9S836C4_nt3v30Ev();
extern void _ZN9S836C4_nt3v31Ev();
extern void _ZN9S836C4_nt3v32Ev();
extern void _ZN9S836C4_nt3v33Ev();
extern void _ZN9S836C4_nt3v34Ev();
extern void _ZN9S836C4_nt3v35Ev();
extern void _ZN9S836C4_nt3v36Ev();
extern void _ZN9S836C4_nt3v37Ev();
extern void _ZN9S836C4_nt3v38Ev();
extern void _ZN9S836C4_nt3v39Ev();
extern void _ZN9S836C4_nt3v40Ev();
extern void _ZN9S836C4_nt3v41Ev();
extern void _ZN9S836C4_nt3v42Ev();
extern void _ZN9S836C4_nt3v43Ev();
extern void _ZN9S836C4_nt3v44Ev();
extern void _ZN9S836C4_nt3v45Ev();
extern void _ZN9S836C4_nt3v46Ev();
extern void _ZN9S836C4_nt3v47Ev();
extern void _ZN9S836C4_nt3v48Ev();
extern void _ZN9S836C4_nt3v49Ev();
extern void _ZN9S836C4_nt3v50Ev();
extern void _ZN9S836C4_nt3v51Ev();
extern void _ZN9S836C4_nt3v52Ev();
extern void _ZN9S836C4_nt3v53Ev();
extern void _ZN9S836C4_nt3v54Ev();
extern void _ZN9S836C4_nt3v55Ev();
extern void _ZN9S836C4_nt3v56Ev();
extern void _ZN9S836C4_nt3v57Ev();
extern void _ZN9S836C4_nt3v58Ev();
extern void _ZN9S836C4_nt3v59Ev();
extern void _ZN9S836C4_nt3v60Ev();
extern void _ZN9S836C4_nt3v61Ev();
extern void _ZN9S836C4_nt3v62Ev();
extern void _ZN9S836C4_nt3v63Ev();
extern void _ZN9S836C4_nt3v64Ev();
extern void _ZN9S836C4_nt3v65Ev();
extern void _ZN9S836C4_nt3v66Ev();
extern void _ZN9S836C4_nt3v67Ev();
extern void _ZN9S836C4_nt3v68Ev();
extern void _ZN9S836C4_nt3v69Ev();
extern void _ZN9S836C4_nt3v70Ev();
extern void _ZN9S836C4_nt3v71Ev();
extern void _ZN9S836C4_nt3v72Ev();
extern void _ZN9S836C4_nt3v73Ev();
extern void _ZN9S836C4_nt3v74Ev();
extern void _ZN9S836C4_nt3v75Ev();
extern void _ZN9S836C4_nt3v76Ev();
extern void _ZN9S836C4_nt3v77Ev();
extern void _ZN9S836C4_nt3v78Ev();
extern void _ZN9S836C4_nt3v79Ev();
extern void _ZN9S836C4_nt3v80Ev();
extern void _ZN9S836C4_nt3v81Ev();
extern void _ZN9S836C4_nt3v82Ev();
extern void _ZN9S836C4_nt3v83Ev();
extern void _ZN9S836C4_nt3v84Ev();
extern void _ZN9S836C4_nt3v85Ev();
extern void _ZN9S836C4_nt3v86Ev();
extern void _ZN9S836C4_nt3v87Ev();
extern void _ZN9S836C4_nt3v88Ev();
extern void _ZN9S836C4_nt3v89Ev();
extern void _ZN9S836C4_nt3v90Ev();
extern void _ZN9S836C4_nt3v91Ev();
extern void _ZN9S836C4_nt3v92Ev();
extern void _ZN9S836C4_nt3v93Ev();
extern void _ZN9S836C4_nt3v94Ev();
extern void _ZN9S836C4_nt3v95Ev();
extern void _ZN9S836C4_nt3v96Ev();
extern void _ZN9S836C4_nt3v97Ev();
extern void _ZN9S836C4_nt3v98Ev();
extern void _ZN9S836C4_nt3v99Ev();
extern void _ZN9S836C4_nt4v100Ev();
extern void _ZN9S836C4_nt4v101Ev();
static  VTBL_ENTRY vtc_S836C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S836C4_nt[0]),
  (VTBL_ENTRY)&_ZN9S836C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S836C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v2Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v3Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v4Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt4v101Ev,
};
extern VTBL_ENTRY _ZTI9S836C4_nt[];
VTBL_ENTRY *P__ZTI9S836C4_nt = _ZTI9S836C4_nt; 
extern  VTBL_ENTRY _ZTV9S836C4_nt[];
Class_Descriptor cd_S836C4_nt = {  "S836C4_nt", // class name
  bases_S836C4_nt, 1,
  &(vtc_S836C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(832,632), // object size
  NSPAIRA(_ZTI9S836C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S836C4_nt),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S836C3_nt  : S836C4_nt {
  int s836c3f0[4];
  void *s836c3f1;
  unsigned char s836c3f2:1;
  unsigned char s836c3f3:1;
  unsigned char s836c3f4:1;
  unsigned char s836c3f5:1;
  unsigned char s836c3f6:1;
  unsigned char s836c3f7:1;
  int s836c3f8:8;
  int s836c3f9:16;
  int s836c3f10:16;
  int s836c3f11:16;
  int s836c3f12:16;
  int s836c3f13:16;
  int s836c3f14;
  ::S836C23 s836c3f15;
  unsigned char s836c3f16:1;
  unsigned char s836c3f17:1;
  virtual  ~S836C3_nt(); // _ZN9S836C3_ntD1Ev
  virtual void  v102(); // _ZN9S836C3_nt4v102Ev
  virtual void  v103(); // _ZN9S836C3_nt4v103Ev
  virtual void  v104(); // _ZN9S836C3_nt4v104Ev
  virtual void  v105(); // _ZN9S836C3_nt4v105Ev
  virtual void  v106(); // _ZN9S836C3_nt4v106Ev
  virtual void  v107(); // _ZN9S836C3_nt4v107Ev
  virtual void  v108(); // _ZN9S836C3_nt4v108Ev
  virtual void  v109(); // _ZN9S836C3_nt4v109Ev
  virtual void  v110(); // _ZN9S836C3_nt4v110Ev
  virtual void  v111(); // _ZN9S836C3_nt4v111Ev
  virtual void  v112(); // _ZN9S836C3_nt4v112Ev
  virtual void  v113(); // _ZN9S836C3_nt4v113Ev
  virtual void  v114(); // _ZN9S836C3_nt4v114Ev
  virtual void  v115(); // _ZN9S836C3_nt4v115Ev
  virtual void  v116(); // _ZN9S836C3_nt4v116Ev
  virtual void  v117(); // _ZN9S836C3_nt4v117Ev
  virtual void  v118(); // _ZN9S836C3_nt4v118Ev
  virtual void  v119(); // _ZN9S836C3_nt4v119Ev
  virtual void  v120(); // _ZN9S836C3_nt4v120Ev
  virtual void  v121(); // _ZN9S836C3_nt4v121Ev
  virtual void  v122(); // _ZN9S836C3_nt4v122Ev
  virtual void  v123(); // _ZN9S836C3_nt4v123Ev
  virtual void  v124(); // _ZN9S836C3_nt4v124Ev
  virtual void  v125(); // _ZN9S836C3_nt4v125Ev
  virtual void  v126(); // _ZN9S836C3_nt4v126Ev
  virtual void  v127(); // _ZN9S836C3_nt4v127Ev
  virtual void  v128(); // _ZN9S836C3_nt4v128Ev
  virtual void  v129(); // _ZN9S836C3_nt4v129Ev
  virtual void  v130(); // _ZN9S836C3_nt4v130Ev
  virtual void  v131(); // _ZN9S836C3_nt4v131Ev
  virtual void  v132(); // _ZN9S836C3_nt4v132Ev
  virtual void  v133(); // _ZN9S836C3_nt4v133Ev
  virtual void  v134(); // _ZN9S836C3_nt4v134Ev
  virtual void  v135(); // _ZN9S836C3_nt4v135Ev
  virtual void  v136(); // _ZN9S836C3_nt4v136Ev
  virtual void  v137(); // _ZN9S836C3_nt4v137Ev
  virtual void  v138(); // _ZN9S836C3_nt4v138Ev
  virtual void  v139(); // _ZN9S836C3_nt4v139Ev
  virtual void  v140(); // _ZN9S836C3_nt4v140Ev
  S836C3_nt(); // tgen
};
//SIG(-1 S836C3_nt) C1{ BC2{ BC3{ vd v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 Fp Fi FC4{ BC5{ m Fp Fi FC6{ m} FC6}} FC4 Fi} vd v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 FC7{ m FC8{ m FL[2]}} FC7 FC7 FC7 FC9{ m FC7} FC10{ m FC7 FC7 FC7 FC7} FC10 FC7 FC7 FC7 Fp FC9 FC11{ m FC12{ m Fp Fi FC13{ m}} Fi} Fi Fp[7] FC14{ m Fp Fi FC13 FC15{ m}} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC16{ BC17{ m Fp Fi FC15 FC18{ m}}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC19{ m Fp Fi[2] FC18} Fp[2] Fi:16 Fi:16 FC16 FC19 FC20{ m Fp Fi[2] FC21{ m}} Fp[2] Fi:24 Fi:8 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 Fi[4] Fp Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi:8 Fi:16 Fi:16 Fi:16 Fi:16 Fi:16 Fi FC14 Fc:1 Fc:1}


 S836C3_nt ::~S836C3_nt(){ note_dtor("S836C3_nt", this);}
void  S836C3_nt ::v102(){vfunc_called(this, "_ZN9S836C3_nt4v102Ev");}
void  S836C3_nt ::v103(){vfunc_called(this, "_ZN9S836C3_nt4v103Ev");}
void  S836C3_nt ::v104(){vfunc_called(this, "_ZN9S836C3_nt4v104Ev");}
void  S836C3_nt ::v105(){vfunc_called(this, "_ZN9S836C3_nt4v105Ev");}
void  S836C3_nt ::v106(){vfunc_called(this, "_ZN9S836C3_nt4v106Ev");}
void  S836C3_nt ::v107(){vfunc_called(this, "_ZN9S836C3_nt4v107Ev");}
void  S836C3_nt ::v108(){vfunc_called(this, "_ZN9S836C3_nt4v108Ev");}
void  S836C3_nt ::v109(){vfunc_called(this, "_ZN9S836C3_nt4v109Ev");}
void  S836C3_nt ::v110(){vfunc_called(this, "_ZN9S836C3_nt4v110Ev");}
void  S836C3_nt ::v111(){vfunc_called(this, "_ZN9S836C3_nt4v111Ev");}
void  S836C3_nt ::v112(){vfunc_called(this, "_ZN9S836C3_nt4v112Ev");}
void  S836C3_nt ::v113(){vfunc_called(this, "_ZN9S836C3_nt4v113Ev");}
void  S836C3_nt ::v114(){vfunc_called(this, "_ZN9S836C3_nt4v114Ev");}
void  S836C3_nt ::v115(){vfunc_called(this, "_ZN9S836C3_nt4v115Ev");}
void  S836C3_nt ::v116(){vfunc_called(this, "_ZN9S836C3_nt4v116Ev");}
void  S836C3_nt ::v117(){vfunc_called(this, "_ZN9S836C3_nt4v117Ev");}
void  S836C3_nt ::v118(){vfunc_called(this, "_ZN9S836C3_nt4v118Ev");}
void  S836C3_nt ::v119(){vfunc_called(this, "_ZN9S836C3_nt4v119Ev");}
void  S836C3_nt ::v120(){vfunc_called(this, "_ZN9S836C3_nt4v120Ev");}
void  S836C3_nt ::v121(){vfunc_called(this, "_ZN9S836C3_nt4v121Ev");}
void  S836C3_nt ::v122(){vfunc_called(this, "_ZN9S836C3_nt4v122Ev");}
void  S836C3_nt ::v123(){vfunc_called(this, "_ZN9S836C3_nt4v123Ev");}
void  S836C3_nt ::v124(){vfunc_called(this, "_ZN9S836C3_nt4v124Ev");}
void  S836C3_nt ::v125(){vfunc_called(this, "_ZN9S836C3_nt4v125Ev");}
void  S836C3_nt ::v126(){vfunc_called(this, "_ZN9S836C3_nt4v126Ev");}
void  S836C3_nt ::v127(){vfunc_called(this, "_ZN9S836C3_nt4v127Ev");}
void  S836C3_nt ::v128(){vfunc_called(this, "_ZN9S836C3_nt4v128Ev");}
void  S836C3_nt ::v129(){vfunc_called(this, "_ZN9S836C3_nt4v129Ev");}
void  S836C3_nt ::v130(){vfunc_called(this, "_ZN9S836C3_nt4v130Ev");}
void  S836C3_nt ::v131(){vfunc_called(this, "_ZN9S836C3_nt4v131Ev");}
void  S836C3_nt ::v132(){vfunc_called(this, "_ZN9S836C3_nt4v132Ev");}
void  S836C3_nt ::v133(){vfunc_called(this, "_ZN9S836C3_nt4v133Ev");}
void  S836C3_nt ::v134(){vfunc_called(this, "_ZN9S836C3_nt4v134Ev");}
void  S836C3_nt ::v135(){vfunc_called(this, "_ZN9S836C3_nt4v135Ev");}
void  S836C3_nt ::v136(){vfunc_called(this, "_ZN9S836C3_nt4v136Ev");}
void  S836C3_nt ::v137(){vfunc_called(this, "_ZN9S836C3_nt4v137Ev");}
void  S836C3_nt ::v138(){vfunc_called(this, "_ZN9S836C3_nt4v138Ev");}
void  S836C3_nt ::v139(){vfunc_called(this, "_ZN9S836C3_nt4v139Ev");}
void  S836C3_nt ::v140(){vfunc_called(this, "_ZN9S836C3_nt4v140Ev");}
S836C3_nt ::S836C3_nt(){ note_ctor("S836C3_nt", this);} // tgen

//skip512 S836C3_nt

#else // __cplusplus

extern void _ZN9S836C3_ntC1Ev();
extern void _ZN9S836C3_ntD1Ev();
Name_Map name_map_S836C3_nt[] = {
  NSPAIR(_ZN9S836C3_ntC1Ev),
  NSPAIR(_ZN9S836C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S836C5_nt;
extern VTBL_ENTRY _ZTI9S836C5_nt[];
extern  VTBL_ENTRY _ZTV9S836C5_nt[];
extern Class_Descriptor cd_S836C4_nt;
extern VTBL_ENTRY _ZTI9S836C4_nt[];
extern  VTBL_ENTRY _ZTV9S836C4_nt[];
static Base_Class bases_S836C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S836C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S836C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S836C3_nt[];
extern void _ZN9S836C3_ntD1Ev();
extern void _ZN9S836C3_ntD0Ev();
extern void _ZN9S836C5_nt2v1Ev();
extern void _ZN9S836C5_nt2v2Ev();
extern void _ZN9S836C5_nt2v3Ev();
extern void _ZN9S836C5_nt2v4Ev();
extern void _ZN9S836C5_nt2v5Ev();
extern void _ZN9S836C5_nt2v6Ev();
extern void _ZN9S836C5_nt2v7Ev();
extern void _ZN9S836C5_nt2v8Ev();
extern void _ZN9S836C5_nt2v9Ev();
extern void _ZN9S836C5_nt3v10Ev();
extern void _ZN9S836C5_nt3v11Ev();
extern void _ZN9S836C5_nt3v12Ev();
extern void _ZN9S836C5_nt3v13Ev();
extern void _ZN9S836C5_nt3v14Ev();
extern void _ZN9S836C5_nt3v15Ev();
extern void _ZN9S836C5_nt3v16Ev();
extern void _ZN9S836C5_nt3v17Ev();
extern void _ZN9S836C5_nt3v18Ev();
extern void _ZN9S836C5_nt3v19Ev();
extern void _ZN9S836C5_nt3v20Ev();
extern void _ZN9S836C5_nt3v21Ev();
extern void _ZN9S836C5_nt3v22Ev();
extern void _ZN9S836C5_nt3v23Ev();
extern void _ZN9S836C4_nt3v24Ev();
extern void _ZN9S836C4_nt3v25Ev();
extern void _ZN9S836C4_nt3v26Ev();
extern void _ZN9S836C4_nt3v27Ev();
extern void _ZN9S836C4_nt3v28Ev();
extern void _ZN9S836C4_nt3v29Ev();
extern void _ZN9S836C4_nt3v30Ev();
extern void _ZN9S836C4_nt3v31Ev();
extern void _ZN9S836C4_nt3v32Ev();
extern void _ZN9S836C4_nt3v33Ev();
extern void _ZN9S836C4_nt3v34Ev();
extern void _ZN9S836C4_nt3v35Ev();
extern void _ZN9S836C4_nt3v36Ev();
extern void _ZN9S836C4_nt3v37Ev();
extern void _ZN9S836C4_nt3v38Ev();
extern void _ZN9S836C4_nt3v39Ev();
extern void _ZN9S836C4_nt3v40Ev();
extern void _ZN9S836C4_nt3v41Ev();
extern void _ZN9S836C4_nt3v42Ev();
extern void _ZN9S836C4_nt3v43Ev();
extern void _ZN9S836C4_nt3v44Ev();
extern void _ZN9S836C4_nt3v45Ev();
extern void _ZN9S836C4_nt3v46Ev();
extern void _ZN9S836C4_nt3v47Ev();
extern void _ZN9S836C4_nt3v48Ev();
extern void _ZN9S836C4_nt3v49Ev();
extern void _ZN9S836C4_nt3v50Ev();
extern void _ZN9S836C4_nt3v51Ev();
extern void _ZN9S836C4_nt3v52Ev();
extern void _ZN9S836C4_nt3v53Ev();
extern void _ZN9S836C4_nt3v54Ev();
extern void _ZN9S836C4_nt3v55Ev();
extern void _ZN9S836C4_nt3v56Ev();
extern void _ZN9S836C4_nt3v57Ev();
extern void _ZN9S836C4_nt3v58Ev();
extern void _ZN9S836C4_nt3v59Ev();
extern void _ZN9S836C4_nt3v60Ev();
extern void _ZN9S836C4_nt3v61Ev();
extern void _ZN9S836C4_nt3v62Ev();
extern void _ZN9S836C4_nt3v63Ev();
extern void _ZN9S836C4_nt3v64Ev();
extern void _ZN9S836C4_nt3v65Ev();
extern void _ZN9S836C4_nt3v66Ev();
extern void _ZN9S836C4_nt3v67Ev();
extern void _ZN9S836C4_nt3v68Ev();
extern void _ZN9S836C4_nt3v69Ev();
extern void _ZN9S836C4_nt3v70Ev();
extern void _ZN9S836C4_nt3v71Ev();
extern void _ZN9S836C4_nt3v72Ev();
extern void _ZN9S836C4_nt3v73Ev();
extern void _ZN9S836C4_nt3v74Ev();
extern void _ZN9S836C4_nt3v75Ev();
extern void _ZN9S836C4_nt3v76Ev();
extern void _ZN9S836C4_nt3v77Ev();
extern void _ZN9S836C4_nt3v78Ev();
extern void _ZN9S836C4_nt3v79Ev();
extern void _ZN9S836C4_nt3v80Ev();
extern void _ZN9S836C4_nt3v81Ev();
extern void _ZN9S836C4_nt3v82Ev();
extern void _ZN9S836C4_nt3v83Ev();
extern void _ZN9S836C4_nt3v84Ev();
extern void _ZN9S836C4_nt3v85Ev();
extern void _ZN9S836C4_nt3v86Ev();
extern void _ZN9S836C4_nt3v87Ev();
extern void _ZN9S836C4_nt3v88Ev();
extern void _ZN9S836C4_nt3v89Ev();
extern void _ZN9S836C4_nt3v90Ev();
extern void _ZN9S836C4_nt3v91Ev();
extern void _ZN9S836C4_nt3v92Ev();
extern void _ZN9S836C4_nt3v93Ev();
extern void _ZN9S836C4_nt3v94Ev();
extern void _ZN9S836C4_nt3v95Ev();
extern void _ZN9S836C4_nt3v96Ev();
extern void _ZN9S836C4_nt3v97Ev();
extern void _ZN9S836C4_nt3v98Ev();
extern void _ZN9S836C4_nt3v99Ev();
extern void _ZN9S836C4_nt4v100Ev();
extern void _ZN9S836C4_nt4v101Ev();
extern void _ZN9S836C3_nt4v102Ev();
extern void _ZN9S836C3_nt4v103Ev();
extern void _ZN9S836C3_nt4v104Ev();
extern void _ZN9S836C3_nt4v105Ev();
extern void _ZN9S836C3_nt4v106Ev();
extern void _ZN9S836C3_nt4v107Ev();
extern void _ZN9S836C3_nt4v108Ev();
extern void _ZN9S836C3_nt4v109Ev();
extern void _ZN9S836C3_nt4v110Ev();
extern void _ZN9S836C3_nt4v111Ev();
extern void _ZN9S836C3_nt4v112Ev();
extern void _ZN9S836C3_nt4v113Ev();
extern void _ZN9S836C3_nt4v114Ev();
extern void _ZN9S836C3_nt4v115Ev();
extern void _ZN9S836C3_nt4v116Ev();
extern void _ZN9S836C3_nt4v117Ev();
extern void _ZN9S836C3_nt4v118Ev();
extern void _ZN9S836C3_nt4v119Ev();
extern void _ZN9S836C3_nt4v120Ev();
extern void _ZN9S836C3_nt4v121Ev();
extern void _ZN9S836C3_nt4v122Ev();
extern void _ZN9S836C3_nt4v123Ev();
extern void _ZN9S836C3_nt4v124Ev();
extern void _ZN9S836C3_nt4v125Ev();
extern void _ZN9S836C3_nt4v126Ev();
extern void _ZN9S836C3_nt4v127Ev();
extern void _ZN9S836C3_nt4v128Ev();
extern void _ZN9S836C3_nt4v129Ev();
extern void _ZN9S836C3_nt4v130Ev();
extern void _ZN9S836C3_nt4v131Ev();
extern void _ZN9S836C3_nt4v132Ev();
extern void _ZN9S836C3_nt4v133Ev();
extern void _ZN9S836C3_nt4v134Ev();
extern void _ZN9S836C3_nt4v135Ev();
extern void _ZN9S836C3_nt4v136Ev();
extern void _ZN9S836C3_nt4v137Ev();
extern void _ZN9S836C3_nt4v138Ev();
extern void _ZN9S836C3_nt4v139Ev();
extern void _ZN9S836C3_nt4v140Ev();
static  VTBL_ENTRY vtc_S836C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S836C3_nt[0]),
  (VTBL_ENTRY)&_ZN9S836C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S836C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v2Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v3Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v4Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v140Ev,
};
extern VTBL_ENTRY _ZTI9S836C3_nt[];
VTBL_ENTRY *P__ZTI9S836C3_nt = _ZTI9S836C3_nt; 
extern  VTBL_ENTRY _ZTV9S836C3_nt[];
Class_Descriptor cd_S836C3_nt = {  "S836C3_nt", // class name
  bases_S836C3_nt, 2,
  &(vtc_S836C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(896,684), // object size
  NSPAIRA(_ZTI9S836C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S836C3_nt),144, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S836C2_nt  : S836C3_nt {
  int s836c2f0:4;
  int s836c2f1:4;
  int s836c2f2:4;
  int s836c2f3[3];
  void *s836c2f4;
  virtual  ~S836C2_nt(); // _ZN9S836C2_ntD1Ev
  virtual void  v141(); // _ZN9S836C2_nt4v141Ev
  virtual void  v142(); // _ZN9S836C2_nt4v142Ev
  virtual void  v143(); // _ZN9S836C2_nt4v143Ev
  virtual void  v144(); // _ZN9S836C2_nt4v144Ev
  virtual void  v145(); // _ZN9S836C2_nt4v145Ev
  virtual void  v146(); // _ZN9S836C2_nt4v146Ev
  virtual void  v147(); // _ZN9S836C2_nt4v147Ev
  virtual void  v148(); // _ZN9S836C2_nt4v148Ev
  virtual void  v149(); // _ZN9S836C2_nt4v149Ev
  virtual void  v150(); // _ZN9S836C2_nt4v150Ev
  virtual void  v151(); // _ZN9S836C2_nt4v151Ev
  virtual void  v152(); // _ZN9S836C2_nt4v152Ev
  virtual void  v153(); // _ZN9S836C2_nt4v153Ev
  virtual void  v154(); // _ZN9S836C2_nt4v154Ev
  virtual void  v155(); // _ZN9S836C2_nt4v155Ev
  virtual void  v156(); // _ZN9S836C2_nt4v156Ev
  virtual void  v157(); // _ZN9S836C2_nt4v157Ev
  virtual void  v158(); // _ZN9S836C2_nt4v158Ev
  S836C2_nt(); // tgen
};
//SIG(-1 S836C2_nt) C1{ BC2{ BC3{ BC4{ vd v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 Fp Fi FC5{ BC6{ m Fp Fi FC7{ m} FC7}} FC5 Fi} vd v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8 FC10{ m FC8} FC11{ m FC8 FC8 FC8 FC8} FC11 FC8 FC8 FC8 Fp FC10 FC12{ m FC13{ m Fp Fi FC14{ m}} Fi} Fi Fp[7] FC15{ m Fp Fi FC14 FC16{ m}} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC17{ BC18{ m Fp Fi FC16 FC19{ m}}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC20{ m Fp Fi[2] FC19} Fp[2] Fi:16 Fi:16 FC17 FC20 FC21{ m Fp Fi[2] FC22{ m}} Fp[2] Fi:24 Fi:8 Fp} vd v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 Fi[4] Fp Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi:8 Fi:16 Fi:16 Fi:16 Fi:16 Fi:16 Fi FC15 Fc:1 Fc:1} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 Fi:4 Fi:4 Fi:4 Fi[3] Fp}


 S836C2_nt ::~S836C2_nt(){ note_dtor("S836C2_nt", this);}
void  S836C2_nt ::v141(){vfunc_called(this, "_ZN9S836C2_nt4v141Ev");}
void  S836C2_nt ::v142(){vfunc_called(this, "_ZN9S836C2_nt4v142Ev");}
void  S836C2_nt ::v143(){vfunc_called(this, "_ZN9S836C2_nt4v143Ev");}
void  S836C2_nt ::v144(){vfunc_called(this, "_ZN9S836C2_nt4v144Ev");}
void  S836C2_nt ::v145(){vfunc_called(this, "_ZN9S836C2_nt4v145Ev");}
void  S836C2_nt ::v146(){vfunc_called(this, "_ZN9S836C2_nt4v146Ev");}
void  S836C2_nt ::v147(){vfunc_called(this, "_ZN9S836C2_nt4v147Ev");}
void  S836C2_nt ::v148(){vfunc_called(this, "_ZN9S836C2_nt4v148Ev");}
void  S836C2_nt ::v149(){vfunc_called(this, "_ZN9S836C2_nt4v149Ev");}
void  S836C2_nt ::v150(){vfunc_called(this, "_ZN9S836C2_nt4v150Ev");}
void  S836C2_nt ::v151(){vfunc_called(this, "_ZN9S836C2_nt4v151Ev");}
void  S836C2_nt ::v152(){vfunc_called(this, "_ZN9S836C2_nt4v152Ev");}
void  S836C2_nt ::v153(){vfunc_called(this, "_ZN9S836C2_nt4v153Ev");}
void  S836C2_nt ::v154(){vfunc_called(this, "_ZN9S836C2_nt4v154Ev");}
void  S836C2_nt ::v155(){vfunc_called(this, "_ZN9S836C2_nt4v155Ev");}
void  S836C2_nt ::v156(){vfunc_called(this, "_ZN9S836C2_nt4v156Ev");}
void  S836C2_nt ::v157(){vfunc_called(this, "_ZN9S836C2_nt4v157Ev");}
void  S836C2_nt ::v158(){vfunc_called(this, "_ZN9S836C2_nt4v158Ev");}
S836C2_nt ::S836C2_nt(){ note_ctor("S836C2_nt", this);} // tgen

//skip512 S836C2_nt

#else // __cplusplus

extern void _ZN9S836C2_ntC1Ev();
extern void _ZN9S836C2_ntD1Ev();
Name_Map name_map_S836C2_nt[] = {
  NSPAIR(_ZN9S836C2_ntC1Ev),
  NSPAIR(_ZN9S836C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S836C5_nt;
extern VTBL_ENTRY _ZTI9S836C5_nt[];
extern  VTBL_ENTRY _ZTV9S836C5_nt[];
extern Class_Descriptor cd_S836C4_nt;
extern VTBL_ENTRY _ZTI9S836C4_nt[];
extern  VTBL_ENTRY _ZTV9S836C4_nt[];
extern Class_Descriptor cd_S836C3_nt;
extern VTBL_ENTRY _ZTI9S836C3_nt[];
extern  VTBL_ENTRY _ZTV9S836C3_nt[];
static Base_Class bases_S836C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S836C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S836C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S836C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S836C2_nt[];
extern void _ZN9S836C2_ntD1Ev();
extern void _ZN9S836C2_ntD0Ev();
extern void _ZN9S836C5_nt2v1Ev();
extern void _ZN9S836C5_nt2v2Ev();
extern void _ZN9S836C5_nt2v3Ev();
extern void _ZN9S836C5_nt2v4Ev();
extern void _ZN9S836C5_nt2v5Ev();
extern void _ZN9S836C5_nt2v6Ev();
extern void _ZN9S836C5_nt2v7Ev();
extern void _ZN9S836C5_nt2v8Ev();
extern void _ZN9S836C5_nt2v9Ev();
extern void _ZN9S836C5_nt3v10Ev();
extern void _ZN9S836C5_nt3v11Ev();
extern void _ZN9S836C5_nt3v12Ev();
extern void _ZN9S836C5_nt3v13Ev();
extern void _ZN9S836C5_nt3v14Ev();
extern void _ZN9S836C5_nt3v15Ev();
extern void _ZN9S836C5_nt3v16Ev();
extern void _ZN9S836C5_nt3v17Ev();
extern void _ZN9S836C5_nt3v18Ev();
extern void _ZN9S836C5_nt3v19Ev();
extern void _ZN9S836C5_nt3v20Ev();
extern void _ZN9S836C5_nt3v21Ev();
extern void _ZN9S836C5_nt3v22Ev();
extern void _ZN9S836C5_nt3v23Ev();
extern void _ZN9S836C4_nt3v24Ev();
extern void _ZN9S836C4_nt3v25Ev();
extern void _ZN9S836C4_nt3v26Ev();
extern void _ZN9S836C4_nt3v27Ev();
extern void _ZN9S836C4_nt3v28Ev();
extern void _ZN9S836C4_nt3v29Ev();
extern void _ZN9S836C4_nt3v30Ev();
extern void _ZN9S836C4_nt3v31Ev();
extern void _ZN9S836C4_nt3v32Ev();
extern void _ZN9S836C4_nt3v33Ev();
extern void _ZN9S836C4_nt3v34Ev();
extern void _ZN9S836C4_nt3v35Ev();
extern void _ZN9S836C4_nt3v36Ev();
extern void _ZN9S836C4_nt3v37Ev();
extern void _ZN9S836C4_nt3v38Ev();
extern void _ZN9S836C4_nt3v39Ev();
extern void _ZN9S836C4_nt3v40Ev();
extern void _ZN9S836C4_nt3v41Ev();
extern void _ZN9S836C4_nt3v42Ev();
extern void _ZN9S836C4_nt3v43Ev();
extern void _ZN9S836C4_nt3v44Ev();
extern void _ZN9S836C4_nt3v45Ev();
extern void _ZN9S836C4_nt3v46Ev();
extern void _ZN9S836C4_nt3v47Ev();
extern void _ZN9S836C4_nt3v48Ev();
extern void _ZN9S836C4_nt3v49Ev();
extern void _ZN9S836C4_nt3v50Ev();
extern void _ZN9S836C4_nt3v51Ev();
extern void _ZN9S836C4_nt3v52Ev();
extern void _ZN9S836C4_nt3v53Ev();
extern void _ZN9S836C4_nt3v54Ev();
extern void _ZN9S836C4_nt3v55Ev();
extern void _ZN9S836C4_nt3v56Ev();
extern void _ZN9S836C4_nt3v57Ev();
extern void _ZN9S836C4_nt3v58Ev();
extern void _ZN9S836C4_nt3v59Ev();
extern void _ZN9S836C4_nt3v60Ev();
extern void _ZN9S836C4_nt3v61Ev();
extern void _ZN9S836C4_nt3v62Ev();
extern void _ZN9S836C4_nt3v63Ev();
extern void _ZN9S836C4_nt3v64Ev();
extern void _ZN9S836C4_nt3v65Ev();
extern void _ZN9S836C4_nt3v66Ev();
extern void _ZN9S836C4_nt3v67Ev();
extern void _ZN9S836C4_nt3v68Ev();
extern void _ZN9S836C4_nt3v69Ev();
extern void _ZN9S836C4_nt3v70Ev();
extern void _ZN9S836C4_nt3v71Ev();
extern void _ZN9S836C4_nt3v72Ev();
extern void _ZN9S836C4_nt3v73Ev();
extern void _ZN9S836C4_nt3v74Ev();
extern void _ZN9S836C4_nt3v75Ev();
extern void _ZN9S836C4_nt3v76Ev();
extern void _ZN9S836C4_nt3v77Ev();
extern void _ZN9S836C4_nt3v78Ev();
extern void _ZN9S836C4_nt3v79Ev();
extern void _ZN9S836C4_nt3v80Ev();
extern void _ZN9S836C4_nt3v81Ev();
extern void _ZN9S836C4_nt3v82Ev();
extern void _ZN9S836C4_nt3v83Ev();
extern void _ZN9S836C4_nt3v84Ev();
extern void _ZN9S836C4_nt3v85Ev();
extern void _ZN9S836C4_nt3v86Ev();
extern void _ZN9S836C4_nt3v87Ev();
extern void _ZN9S836C4_nt3v88Ev();
extern void _ZN9S836C4_nt3v89Ev();
extern void _ZN9S836C4_nt3v90Ev();
extern void _ZN9S836C4_nt3v91Ev();
extern void _ZN9S836C4_nt3v92Ev();
extern void _ZN9S836C4_nt3v93Ev();
extern void _ZN9S836C4_nt3v94Ev();
extern void _ZN9S836C4_nt3v95Ev();
extern void _ZN9S836C4_nt3v96Ev();
extern void _ZN9S836C4_nt3v97Ev();
extern void _ZN9S836C4_nt3v98Ev();
extern void _ZN9S836C4_nt3v99Ev();
extern void _ZN9S836C4_nt4v100Ev();
extern void _ZN9S836C4_nt4v101Ev();
extern void _ZN9S836C3_nt4v102Ev();
extern void _ZN9S836C3_nt4v103Ev();
extern void _ZN9S836C3_nt4v104Ev();
extern void _ZN9S836C3_nt4v105Ev();
extern void _ZN9S836C3_nt4v106Ev();
extern void _ZN9S836C3_nt4v107Ev();
extern void _ZN9S836C3_nt4v108Ev();
extern void _ZN9S836C3_nt4v109Ev();
extern void _ZN9S836C3_nt4v110Ev();
extern void _ZN9S836C3_nt4v111Ev();
extern void _ZN9S836C3_nt4v112Ev();
extern void _ZN9S836C3_nt4v113Ev();
extern void _ZN9S836C3_nt4v114Ev();
extern void _ZN9S836C3_nt4v115Ev();
extern void _ZN9S836C3_nt4v116Ev();
extern void _ZN9S836C3_nt4v117Ev();
extern void _ZN9S836C3_nt4v118Ev();
extern void _ZN9S836C3_nt4v119Ev();
extern void _ZN9S836C3_nt4v120Ev();
extern void _ZN9S836C3_nt4v121Ev();
extern void _ZN9S836C3_nt4v122Ev();
extern void _ZN9S836C3_nt4v123Ev();
extern void _ZN9S836C3_nt4v124Ev();
extern void _ZN9S836C3_nt4v125Ev();
extern void _ZN9S836C3_nt4v126Ev();
extern void _ZN9S836C3_nt4v127Ev();
extern void _ZN9S836C3_nt4v128Ev();
extern void _ZN9S836C3_nt4v129Ev();
extern void _ZN9S836C3_nt4v130Ev();
extern void _ZN9S836C3_nt4v131Ev();
extern void _ZN9S836C3_nt4v132Ev();
extern void _ZN9S836C3_nt4v133Ev();
extern void _ZN9S836C3_nt4v134Ev();
extern void _ZN9S836C3_nt4v135Ev();
extern void _ZN9S836C3_nt4v136Ev();
extern void _ZN9S836C3_nt4v137Ev();
extern void _ZN9S836C3_nt4v138Ev();
extern void _ZN9S836C3_nt4v139Ev();
extern void _ZN9S836C3_nt4v140Ev();
extern void _ZN9S836C2_nt4v141Ev();
extern void _ZN9S836C2_nt4v142Ev();
extern void _ZN9S836C2_nt4v143Ev();
extern void _ZN9S836C2_nt4v144Ev();
extern void _ZN9S836C2_nt4v145Ev();
extern void _ZN9S836C2_nt4v146Ev();
extern void _ZN9S836C2_nt4v147Ev();
extern void _ZN9S836C2_nt4v148Ev();
extern void _ZN9S836C2_nt4v149Ev();
extern void _ZN9S836C2_nt4v150Ev();
extern void _ZN9S836C2_nt4v151Ev();
extern void _ZN9S836C2_nt4v152Ev();
extern void _ZN9S836C2_nt4v153Ev();
extern void _ZN9S836C2_nt4v154Ev();
extern void _ZN9S836C2_nt4v155Ev();
extern void _ZN9S836C2_nt4v156Ev();
extern void _ZN9S836C2_nt4v157Ev();
extern void _ZN9S836C2_nt4v158Ev();
static  VTBL_ENTRY vtc_S836C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S836C2_nt[0]),
  (VTBL_ENTRY)&_ZN9S836C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S836C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v2Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v3Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v4Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v147Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v148Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v149Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v150Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v151Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v152Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v153Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v154Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v155Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v156Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v157Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v158Ev,
};
extern VTBL_ENTRY _ZTI9S836C2_nt[];
VTBL_ENTRY *P__ZTI9S836C2_nt = _ZTI9S836C2_nt; 
extern  VTBL_ENTRY _ZTV9S836C2_nt[];
Class_Descriptor cd_S836C2_nt = {  "S836C2_nt", // class name
  bases_S836C2_nt, 3,
  &(vtc_S836C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(912,700), // object size
  NSPAIRA(_ZTI9S836C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S836C2_nt),162, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S836C1  : S836C2_nt {
  int s836c1f0[2];
  virtual  ~S836C1(); // _ZN6S836C1D1Ev
  S836C1(); // tgen
};
//SIG(1 S836C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC6{ BC7{ m Fp Fi FC8{ m} FC8}} FC6 Fi} vd v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 FC9{ m FC10{ m FL[2]}} FC9 FC9 FC9 FC11{ m FC9} FC12{ m FC9 FC9 FC9 FC9} FC12 FC9 FC9 FC9 Fp FC11 FC13{ m FC14{ m Fp Fi FC15{ m}} Fi} Fi Fp[7] FC16{ m Fp Fi FC15 FC17{ m}} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC18{ BC19{ m Fp Fi FC17 FC20{ m}}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC21{ m Fp Fi[2] FC20} Fp[2] Fi:16 Fi:16 FC18 FC21 FC22{ m Fp Fi[2] FC23{ m}} Fp[2] Fi:24 Fi:8 Fp} vd v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 Fi[4] Fp Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi:8 Fi:16 Fi:16 Fi:16 Fi:16 Fi:16 Fi FC16 Fc:1 Fc:1} vd v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 Fi:4 Fi:4 Fi:4 Fi[3] Fp} vd Fi[2]}


 S836C1 ::~S836C1(){ note_dtor("S836C1", this);}
S836C1 ::S836C1(){ note_ctor("S836C1", this);} // tgen

static void Test_S836C1()
{
  extern Class_Descriptor cd_S836C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(116,178)];
    init_test(&cd_S836C1, buf);
    S836C1 *dp, &lv = *(dp=new (buf) S836C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(920,708), "sizeof(S836C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S836C1)");
    check_base_class_offset(lv, (S836C5_nt*)(S836C4_nt*)(S836C3_nt*)(S836C2_nt*), 0, "S836C1");
    check_base_class_offset(lv, (S836C4_nt*)(S836C3_nt*)(S836C2_nt*), 0, "S836C1");
    check_base_class_offset(lv, (S836C3_nt*)(S836C2_nt*), 0, "S836C1");
    check_base_class_offset(lv, (S836C2_nt*), 0, "S836C1");
    check_field_offset(lv, s836c1f0, ABISELECT(912,700), "S836C1.s836c1f0");
    test_class_info(&lv, &cd_S836C1);
    dp->~S836C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS836C1(Test_S836C1, "S836C1", ABISELECT(920,708));

#else // __cplusplus

extern void _ZN6S836C1C1Ev();
extern void _ZN6S836C1D1Ev();
Name_Map name_map_S836C1[] = {
  NSPAIR(_ZN6S836C1C1Ev),
  NSPAIR(_ZN6S836C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S836C5_nt;
extern VTBL_ENTRY _ZTI9S836C5_nt[];
extern  VTBL_ENTRY _ZTV9S836C5_nt[];
extern Class_Descriptor cd_S836C4_nt;
extern VTBL_ENTRY _ZTI9S836C4_nt[];
extern  VTBL_ENTRY _ZTV9S836C4_nt[];
extern Class_Descriptor cd_S836C3_nt;
extern VTBL_ENTRY _ZTI9S836C3_nt[];
extern  VTBL_ENTRY _ZTV9S836C3_nt[];
extern Class_Descriptor cd_S836C2_nt;
extern VTBL_ENTRY _ZTI9S836C2_nt[];
extern  VTBL_ENTRY _ZTV9S836C2_nt[];
static Base_Class bases_S836C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S836C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S836C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S836C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S836C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S836C1[];
extern void _ZN6S836C1D1Ev();
extern void _ZN6S836C1D0Ev();
extern void _ZN9S836C5_nt2v1Ev();
extern void _ZN9S836C5_nt2v2Ev();
extern void _ZN9S836C5_nt2v3Ev();
extern void _ZN9S836C5_nt2v4Ev();
extern void _ZN9S836C5_nt2v5Ev();
extern void _ZN9S836C5_nt2v6Ev();
extern void _ZN9S836C5_nt2v7Ev();
extern void _ZN9S836C5_nt2v8Ev();
extern void _ZN9S836C5_nt2v9Ev();
extern void _ZN9S836C5_nt3v10Ev();
extern void _ZN9S836C5_nt3v11Ev();
extern void _ZN9S836C5_nt3v12Ev();
extern void _ZN9S836C5_nt3v13Ev();
extern void _ZN9S836C5_nt3v14Ev();
extern void _ZN9S836C5_nt3v15Ev();
extern void _ZN9S836C5_nt3v16Ev();
extern void _ZN9S836C5_nt3v17Ev();
extern void _ZN9S836C5_nt3v18Ev();
extern void _ZN9S836C5_nt3v19Ev();
extern void _ZN9S836C5_nt3v20Ev();
extern void _ZN9S836C5_nt3v21Ev();
extern void _ZN9S836C5_nt3v22Ev();
extern void _ZN9S836C5_nt3v23Ev();
extern void _ZN9S836C4_nt3v24Ev();
extern void _ZN9S836C4_nt3v25Ev();
extern void _ZN9S836C4_nt3v26Ev();
extern void _ZN9S836C4_nt3v27Ev();
extern void _ZN9S836C4_nt3v28Ev();
extern void _ZN9S836C4_nt3v29Ev();
extern void _ZN9S836C4_nt3v30Ev();
extern void _ZN9S836C4_nt3v31Ev();
extern void _ZN9S836C4_nt3v32Ev();
extern void _ZN9S836C4_nt3v33Ev();
extern void _ZN9S836C4_nt3v34Ev();
extern void _ZN9S836C4_nt3v35Ev();
extern void _ZN9S836C4_nt3v36Ev();
extern void _ZN9S836C4_nt3v37Ev();
extern void _ZN9S836C4_nt3v38Ev();
extern void _ZN9S836C4_nt3v39Ev();
extern void _ZN9S836C4_nt3v40Ev();
extern void _ZN9S836C4_nt3v41Ev();
extern void _ZN9S836C4_nt3v42Ev();
extern void _ZN9S836C4_nt3v43Ev();
extern void _ZN9S836C4_nt3v44Ev();
extern void _ZN9S836C4_nt3v45Ev();
extern void _ZN9S836C4_nt3v46Ev();
extern void _ZN9S836C4_nt3v47Ev();
extern void _ZN9S836C4_nt3v48Ev();
extern void _ZN9S836C4_nt3v49Ev();
extern void _ZN9S836C4_nt3v50Ev();
extern void _ZN9S836C4_nt3v51Ev();
extern void _ZN9S836C4_nt3v52Ev();
extern void _ZN9S836C4_nt3v53Ev();
extern void _ZN9S836C4_nt3v54Ev();
extern void _ZN9S836C4_nt3v55Ev();
extern void _ZN9S836C4_nt3v56Ev();
extern void _ZN9S836C4_nt3v57Ev();
extern void _ZN9S836C4_nt3v58Ev();
extern void _ZN9S836C4_nt3v59Ev();
extern void _ZN9S836C4_nt3v60Ev();
extern void _ZN9S836C4_nt3v61Ev();
extern void _ZN9S836C4_nt3v62Ev();
extern void _ZN9S836C4_nt3v63Ev();
extern void _ZN9S836C4_nt3v64Ev();
extern void _ZN9S836C4_nt3v65Ev();
extern void _ZN9S836C4_nt3v66Ev();
extern void _ZN9S836C4_nt3v67Ev();
extern void _ZN9S836C4_nt3v68Ev();
extern void _ZN9S836C4_nt3v69Ev();
extern void _ZN9S836C4_nt3v70Ev();
extern void _ZN9S836C4_nt3v71Ev();
extern void _ZN9S836C4_nt3v72Ev();
extern void _ZN9S836C4_nt3v73Ev();
extern void _ZN9S836C4_nt3v74Ev();
extern void _ZN9S836C4_nt3v75Ev();
extern void _ZN9S836C4_nt3v76Ev();
extern void _ZN9S836C4_nt3v77Ev();
extern void _ZN9S836C4_nt3v78Ev();
extern void _ZN9S836C4_nt3v79Ev();
extern void _ZN9S836C4_nt3v80Ev();
extern void _ZN9S836C4_nt3v81Ev();
extern void _ZN9S836C4_nt3v82Ev();
extern void _ZN9S836C4_nt3v83Ev();
extern void _ZN9S836C4_nt3v84Ev();
extern void _ZN9S836C4_nt3v85Ev();
extern void _ZN9S836C4_nt3v86Ev();
extern void _ZN9S836C4_nt3v87Ev();
extern void _ZN9S836C4_nt3v88Ev();
extern void _ZN9S836C4_nt3v89Ev();
extern void _ZN9S836C4_nt3v90Ev();
extern void _ZN9S836C4_nt3v91Ev();
extern void _ZN9S836C4_nt3v92Ev();
extern void _ZN9S836C4_nt3v93Ev();
extern void _ZN9S836C4_nt3v94Ev();
extern void _ZN9S836C4_nt3v95Ev();
extern void _ZN9S836C4_nt3v96Ev();
extern void _ZN9S836C4_nt3v97Ev();
extern void _ZN9S836C4_nt3v98Ev();
extern void _ZN9S836C4_nt3v99Ev();
extern void _ZN9S836C4_nt4v100Ev();
extern void _ZN9S836C4_nt4v101Ev();
extern void _ZN9S836C3_nt4v102Ev();
extern void _ZN9S836C3_nt4v103Ev();
extern void _ZN9S836C3_nt4v104Ev();
extern void _ZN9S836C3_nt4v105Ev();
extern void _ZN9S836C3_nt4v106Ev();
extern void _ZN9S836C3_nt4v107Ev();
extern void _ZN9S836C3_nt4v108Ev();
extern void _ZN9S836C3_nt4v109Ev();
extern void _ZN9S836C3_nt4v110Ev();
extern void _ZN9S836C3_nt4v111Ev();
extern void _ZN9S836C3_nt4v112Ev();
extern void _ZN9S836C3_nt4v113Ev();
extern void _ZN9S836C3_nt4v114Ev();
extern void _ZN9S836C3_nt4v115Ev();
extern void _ZN9S836C3_nt4v116Ev();
extern void _ZN9S836C3_nt4v117Ev();
extern void _ZN9S836C3_nt4v118Ev();
extern void _ZN9S836C3_nt4v119Ev();
extern void _ZN9S836C3_nt4v120Ev();
extern void _ZN9S836C3_nt4v121Ev();
extern void _ZN9S836C3_nt4v122Ev();
extern void _ZN9S836C3_nt4v123Ev();
extern void _ZN9S836C3_nt4v124Ev();
extern void _ZN9S836C3_nt4v125Ev();
extern void _ZN9S836C3_nt4v126Ev();
extern void _ZN9S836C3_nt4v127Ev();
extern void _ZN9S836C3_nt4v128Ev();
extern void _ZN9S836C3_nt4v129Ev();
extern void _ZN9S836C3_nt4v130Ev();
extern void _ZN9S836C3_nt4v131Ev();
extern void _ZN9S836C3_nt4v132Ev();
extern void _ZN9S836C3_nt4v133Ev();
extern void _ZN9S836C3_nt4v134Ev();
extern void _ZN9S836C3_nt4v135Ev();
extern void _ZN9S836C3_nt4v136Ev();
extern void _ZN9S836C3_nt4v137Ev();
extern void _ZN9S836C3_nt4v138Ev();
extern void _ZN9S836C3_nt4v139Ev();
extern void _ZN9S836C3_nt4v140Ev();
extern void _ZN9S836C2_nt4v141Ev();
extern void _ZN9S836C2_nt4v142Ev();
extern void _ZN9S836C2_nt4v143Ev();
extern void _ZN9S836C2_nt4v144Ev();
extern void _ZN9S836C2_nt4v145Ev();
extern void _ZN9S836C2_nt4v146Ev();
extern void _ZN9S836C2_nt4v147Ev();
extern void _ZN9S836C2_nt4v148Ev();
extern void _ZN9S836C2_nt4v149Ev();
extern void _ZN9S836C2_nt4v150Ev();
extern void _ZN9S836C2_nt4v151Ev();
extern void _ZN9S836C2_nt4v152Ev();
extern void _ZN9S836C2_nt4v153Ev();
extern void _ZN9S836C2_nt4v154Ev();
extern void _ZN9S836C2_nt4v155Ev();
extern void _ZN9S836C2_nt4v156Ev();
extern void _ZN9S836C2_nt4v157Ev();
extern void _ZN9S836C2_nt4v158Ev();
static  VTBL_ENTRY vtc_S836C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S836C1[0]),
  (VTBL_ENTRY)&_ZN6S836C1D1Ev,
  (VTBL_ENTRY)&_ZN6S836C1D0Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v2Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v3Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v4Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S836C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S836C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S836C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v147Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v148Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v149Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v150Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v151Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v152Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v153Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v154Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v155Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v156Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v157Ev,
  (VTBL_ENTRY)&_ZN9S836C2_nt4v158Ev,
};
extern VTBL_ENTRY _ZTI6S836C1[];
extern  VTBL_ENTRY _ZTV6S836C1[];
Class_Descriptor cd_S836C1 = {  "S836C1", // class name
  bases_S836C1, 4,
  &(vtc_S836C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(920,708), // object size
  NSPAIRA(_ZTI6S836C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S836C1),162, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2214C4  {
  void *s2214c4f0;
  int s2214c4f1;
  ::S836C26 s2214c4f2;
  ::S836C6_nt s2214c4f3;
  int s2214c4f4;
  virtual  ~S2214C4(); // _ZN7S2214C4D1Ev
  virtual void  v3(); // _ZN7S2214C42v3Ev
  virtual void  v4(); // _ZN7S2214C42v4Ev
  virtual void  v5(); // _ZN7S2214C42v5Ev
  virtual void  v6(); // _ZN7S2214C42v6Ev
  virtual void  v7(); // _ZN7S2214C42v7Ev
  virtual void  v8(); // _ZN7S2214C42v8Ev
  virtual void  v9(); // _ZN7S2214C42v9Ev
  virtual void  v10(); // _ZN7S2214C43v10Ev
  virtual void  v11(); // _ZN7S2214C43v11Ev
  virtual void  v12(); // _ZN7S2214C43v12Ev
  virtual void  v13(); // _ZN7S2214C43v13Ev
  virtual void  v14(); // _ZN7S2214C43v14Ev
  virtual void  v15(); // _ZN7S2214C43v15Ev
  virtual void  v16(); // _ZN7S2214C43v16Ev
  virtual void  v17(); // _ZN7S2214C43v17Ev
  virtual void  v18(); // _ZN7S2214C43v18Ev
  virtual void  v19(); // _ZN7S2214C43v19Ev
  virtual void  v20(); // _ZN7S2214C43v20Ev
  virtual void  v21(); // _ZN7S2214C43v21Ev
  virtual void  v22(); // _ZN7S2214C43v22Ev
  virtual void  v23(); // _ZN7S2214C43v23Ev
  virtual void  v24(); // _ZN7S2214C43v24Ev
  virtual void  v25(); // _ZN7S2214C43v25Ev
  S2214C4(); // tgen
};
//SIG(-1 S2214C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC2{ BC3{ m Fp Fi FC4{ m} FC5{ m}}} FC6{ BC7{ m Fp Fi FC8{ m} FC8}} Fi}


 S2214C4 ::~S2214C4(){ note_dtor("S2214C4", this);}
void  S2214C4 ::v3(){vfunc_called(this, "_ZN7S2214C42v3Ev");}
void  S2214C4 ::v4(){vfunc_called(this, "_ZN7S2214C42v4Ev");}
void  S2214C4 ::v5(){vfunc_called(this, "_ZN7S2214C42v5Ev");}
void  S2214C4 ::v6(){vfunc_called(this, "_ZN7S2214C42v6Ev");}
void  S2214C4 ::v7(){vfunc_called(this, "_ZN7S2214C42v7Ev");}
void  S2214C4 ::v8(){vfunc_called(this, "_ZN7S2214C42v8Ev");}
void  S2214C4 ::v9(){vfunc_called(this, "_ZN7S2214C42v9Ev");}
void  S2214C4 ::v10(){vfunc_called(this, "_ZN7S2214C43v10Ev");}
void  S2214C4 ::v11(){vfunc_called(this, "_ZN7S2214C43v11Ev");}
void  S2214C4 ::v12(){vfunc_called(this, "_ZN7S2214C43v12Ev");}
void  S2214C4 ::v13(){vfunc_called(this, "_ZN7S2214C43v13Ev");}
void  S2214C4 ::v14(){vfunc_called(this, "_ZN7S2214C43v14Ev");}
void  S2214C4 ::v15(){vfunc_called(this, "_ZN7S2214C43v15Ev");}
void  S2214C4 ::v16(){vfunc_called(this, "_ZN7S2214C43v16Ev");}
void  S2214C4 ::v17(){vfunc_called(this, "_ZN7S2214C43v17Ev");}
void  S2214C4 ::v18(){vfunc_called(this, "_ZN7S2214C43v18Ev");}
void  S2214C4 ::v19(){vfunc_called(this, "_ZN7S2214C43v19Ev");}
void  S2214C4 ::v20(){vfunc_called(this, "_ZN7S2214C43v20Ev");}
void  S2214C4 ::v21(){vfunc_called(this, "_ZN7S2214C43v21Ev");}
void  S2214C4 ::v22(){vfunc_called(this, "_ZN7S2214C43v22Ev");}
void  S2214C4 ::v23(){vfunc_called(this, "_ZN7S2214C43v23Ev");}
void  S2214C4 ::v24(){vfunc_called(this, "_ZN7S2214C43v24Ev");}
void  S2214C4 ::v25(){vfunc_called(this, "_ZN7S2214C43v25Ev");}
S2214C4 ::S2214C4(){ note_ctor("S2214C4", this);} // tgen

static void Test_S2214C4()
{
  extern Class_Descriptor cd_S2214C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,11)];
    init_test(&cd_S2214C4, buf);
    S2214C4 *dp, &lv = *(dp=new (buf) S2214C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,40), "sizeof(S2214C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2214C4)");
    check_field_offset(lv, s2214c4f0, ABISELECT(8,4), "S2214C4.s2214c4f0");
    check_field_offset(lv, s2214c4f1, ABISELECT(16,8), "S2214C4.s2214c4f1");
    check_field_offset(lv, s2214c4f2, ABISELECT(24,12), "S2214C4.s2214c4f2");
    check_field_offset(lv, s2214c4f3, ABISELECT(40,24), "S2214C4.s2214c4f3");
    check_field_offset(lv, s2214c4f4, ABISELECT(56,36), "S2214C4.s2214c4f4");
    test_class_info(&lv, &cd_S2214C4);
    dp->~S2214C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2214C4(Test_S2214C4, "S2214C4", ABISELECT(64,40));

#else // __cplusplus

extern void _ZN7S2214C4C1Ev();
extern void _ZN7S2214C4D1Ev();
Name_Map name_map_S2214C4[] = {
  NSPAIR(_ZN7S2214C4C1Ev),
  NSPAIR(_ZN7S2214C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2214C4[];
extern void _ZN7S2214C4D1Ev();
extern void _ZN7S2214C4D0Ev();
extern void _ZN7S2214C42v3Ev();
extern void _ZN7S2214C42v4Ev();
extern void _ZN7S2214C42v5Ev();
extern void _ZN7S2214C42v6Ev();
extern void _ZN7S2214C42v7Ev();
extern void _ZN7S2214C42v8Ev();
extern void _ZN7S2214C42v9Ev();
extern void _ZN7S2214C43v10Ev();
extern void _ZN7S2214C43v11Ev();
extern void _ZN7S2214C43v12Ev();
extern void _ZN7S2214C43v13Ev();
extern void _ZN7S2214C43v14Ev();
extern void _ZN7S2214C43v15Ev();
extern void _ZN7S2214C43v16Ev();
extern void _ZN7S2214C43v17Ev();
extern void _ZN7S2214C43v18Ev();
extern void _ZN7S2214C43v19Ev();
extern void _ZN7S2214C43v20Ev();
extern void _ZN7S2214C43v21Ev();
extern void _ZN7S2214C43v22Ev();
extern void _ZN7S2214C43v23Ev();
extern void _ZN7S2214C43v24Ev();
extern void _ZN7S2214C43v25Ev();
static  VTBL_ENTRY vtc_S2214C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2214C4[0]),
  (VTBL_ENTRY)&_ZN7S2214C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2214C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2214C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2214C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2214C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2214C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2214C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2214C42v8Ev,
  (VTBL_ENTRY)&_ZN7S2214C42v9Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v14Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v15Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v16Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v17Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v18Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v19Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v20Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v21Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v22Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v23Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v24Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v25Ev,
};
extern VTBL_ENTRY _ZTI7S2214C4[];
extern  VTBL_ENTRY _ZTV7S2214C4[];
Class_Descriptor cd_S2214C4 = {  "S2214C4", // class name
  0,0,//no base classes
  &(vtc_S2214C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI7S2214C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2214C4),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2214C15_nt  {
  ::S836C15_nt s2214c15f0;
  void  mf2214c15(); // _ZN11S2214C15_nt9mf2214c15Ev
};
//SIG(-1 S2214C15_nt) C1{ m FC2{ m FL[2]}}


void  S2214C15_nt ::mf2214c15(){}

//skip512 S2214C15_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2214C25_nt  : S836C23 {
};
//SIG(-1 S2214C25_nt) C1{ BC2{ m Fp Fi FC3{ m} FC4{ m}}}



//skip512 S2214C25_nt

#else // __cplusplus

extern Class_Descriptor cd_S836C23;
static Base_Class bases_S2214C25_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S836C23,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2214C37_nt  {
  void *s2214c37f0;
  int s2214c37f1[2];
  ::S836C39 s2214c37f2;
  void  mf2214c37(); // _ZN11S2214C37_nt9mf2214c37Ev
};
//SIG(-1 S2214C37_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S2214C37_nt ::mf2214c37(){}

//skip512 S2214C37_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2214C3  : S2214C4 {
  ::S836C14_nt s2214c3f0;
  ::S836C14_nt s2214c3f1;
  ::S836C14_nt s2214c3f2;
  ::S2214C15_nt s2214c3f3;
  ::S836C18_nt s2214c3f4;
  ::S836C19_nt s2214c3f5;
  ::S836C19_nt s2214c3f6;
  ::S836C14_nt s2214c3f7;
  ::S836C14_nt s2214c3f8;
  ::S836C14_nt s2214c3f9;
  void *s2214c3f10;
  ::S836C18_nt s2214c3f11;
  ::S836C20_nt s2214c3f12;
  int s2214c3f13;
  void *s2214c3f14[7];
  ::S836C27 s2214c3f15;
  int s2214c3f16:8;
  int s2214c3f17:8;
  int s2214c3f18:16;
  int s2214c3f19:16;
  int s2214c3f20:8;
  int s2214c3f21:8;
  int s2214c3f22:8;
  int s2214c3f23:32;
  int s2214c3f24:8;
  int s2214c3f25:4;
  int s2214c3f26:4;
  int s2214c3f27:4;
  int s2214c3f28:4;
  int s2214c3f29:4;
  int s2214c3f30:4;
  int s2214c3f31:4;
  int s2214c3f32:4;
  int s2214c3f33:4;
  int s2214c3f34:4;
  unsigned char s2214c3f35:1;
  unsigned char s2214c3f36:1;
  unsigned char s2214c3f37:1;
  unsigned char s2214c3f38:1;
  unsigned char s2214c3f39:1;
  unsigned char s2214c3f40:1;
  unsigned char s2214c3f41:1;
  unsigned char s2214c3f42:1;
  unsigned char s2214c3f43:1;
  unsigned char s2214c3f44:1;
  unsigned char s2214c3f45:1;
  unsigned char s2214c3f46:1;
  unsigned char s2214c3f47:1;
  unsigned char s2214c3f48:1;
  unsigned char s2214c3f49:1;
  unsigned char s2214c3f50:1;
  unsigned char s2214c3f51:1;
  unsigned char s2214c3f52:1;
  unsigned char s2214c3f53:1;
  unsigned char s2214c3f54:1;
  unsigned char s2214c3f55:1;
  unsigned char s2214c3f56:1;
  unsigned char s2214c3f57:1;
  unsigned char s2214c3f58:1;
  unsigned char s2214c3f59:1;
  unsigned char s2214c3f60:1;
  unsigned char s2214c3f61:1;
  unsigned char s2214c3f62:1;
  unsigned char s2214c3f63:1;
  unsigned char s2214c3f64:1;
  unsigned char s2214c3f65:1;
  unsigned char s2214c3f66:1;
  unsigned char s2214c3f67:1;
  unsigned char s2214c3f68:1;
  unsigned char s2214c3f69:1;
  unsigned char s2214c3f70:1;
  unsigned char s2214c3f71:1;
  unsigned char s2214c3f72:1;
  unsigned char s2214c3f73:1;
  unsigned char s2214c3f74:1;
  unsigned char s2214c3f75:1;
  int s2214c3f76[7];
  void *s2214c3f77[6];
  int s2214c3f78:8;
  int s2214c3f79:8;
  int s2214c3f80:8;
  int s2214c3f81:8;
  int s2214c3f82:8;
  int s2214c3f83:8;
  ::S2214C25_nt s2214c3f84;
  void *s2214c3f85[4];
  int s2214c3f86:8;
  int s2214c3f87:8;
  int s2214c3f88:8;
  int s2214c3f89:8;
  int s2214c3f90:8;
  int s2214c3f91:16;
  int s2214c3f92:16;
  int s2214c3f93:16;
  int s2214c3f94:4;
  int s2214c3f95:4;
  int s2214c3f96:4;
  int s2214c3f97:4;
  int s2214c3f98:4;
  int s2214c3f99:4;
  int s2214c3f100:4;
  int s2214c3f101:4;
  int s2214c3f102:4;
  int s2214c3f103:4;
  int s2214c3f104:4;
  int s2214c3f105:4;
  int s2214c3f106:8;
  int s2214c3f107:8;
  int s2214c3f108:8;
  void *s2214c3f109[7];
  ::S836C38 s2214c3f110;
  void *s2214c3f111[2];
  int s2214c3f112:16;
  int s2214c3f113:16;
  ::S2214C25_nt s2214c3f114;
  ::S836C30_nt s2214c3f115;
  ::S2214C37_nt s2214c3f116;
  void *s2214c3f117[2];
  int s2214c3f118:24;
  int s2214c3f119:8;
  void *s2214c3f120;
  virtual  ~S2214C3(); // _ZN7S2214C3D1Ev
  virtual void  v26(); // _ZN7S2214C33v26Ev
  virtual void  v27(); // _ZN7S2214C33v27Ev
  virtual void  v28(); // _ZN7S2214C33v28Ev
  virtual void  v29(); // _ZN7S2214C33v29Ev
  virtual void  v30(); // _ZN7S2214C33v30Ev
  virtual void  v31(); // _ZN7S2214C33v31Ev
  virtual void  v32(); // _ZN7S2214C33v32Ev
  virtual void  v33(); // _ZN7S2214C33v33Ev
  virtual void  v34(); // _ZN7S2214C33v34Ev
  virtual void  v35(); // _ZN7S2214C33v35Ev
  virtual void  v36(); // _ZN7S2214C33v36Ev
  virtual void  v37(); // _ZN7S2214C33v37Ev
  virtual void  v38(); // _ZN7S2214C33v38Ev
  virtual void  v39(); // _ZN7S2214C33v39Ev
  virtual void  v40(); // _ZN7S2214C33v40Ev
  virtual void  v41(); // _ZN7S2214C33v41Ev
  virtual void  v42(); // _ZN7S2214C33v42Ev
  virtual void  v43(); // _ZN7S2214C33v43Ev
  virtual void  v44(); // _ZN7S2214C33v44Ev
  virtual void  v45(); // _ZN7S2214C33v45Ev
  virtual void  v46(); // _ZN7S2214C33v46Ev
  virtual void  v47(); // _ZN7S2214C33v47Ev
  virtual void  v48(); // _ZN7S2214C33v48Ev
  virtual void  v49(); // _ZN7S2214C33v49Ev
  virtual void  v50(); // _ZN7S2214C33v50Ev
  virtual void  v51(); // _ZN7S2214C33v51Ev
  virtual void  v52(); // _ZN7S2214C33v52Ev
  virtual void  v53(); // _ZN7S2214C33v53Ev
  virtual void  v54(); // _ZN7S2214C33v54Ev
  virtual void  v55(); // _ZN7S2214C33v55Ev
  virtual void  v56(); // _ZN7S2214C33v56Ev
  virtual void  v57(); // _ZN7S2214C33v57Ev
  virtual void  v58(); // _ZN7S2214C33v58Ev
  virtual void  v59(); // _ZN7S2214C33v59Ev
  virtual void  v60(); // _ZN7S2214C33v60Ev
  virtual void  v61(); // _ZN7S2214C33v61Ev
  virtual void  v62(); // _ZN7S2214C33v62Ev
  virtual void  v63(); // _ZN7S2214C33v63Ev
  virtual void  v64(); // _ZN7S2214C33v64Ev
  virtual void  v65(); // _ZN7S2214C33v65Ev
  virtual void  v66(); // _ZN7S2214C33v66Ev
  virtual void  v67(); // _ZN7S2214C33v67Ev
  virtual void  v68(); // _ZN7S2214C33v68Ev
  virtual void  v69(); // _ZN7S2214C33v69Ev
  virtual void  v70(); // _ZN7S2214C33v70Ev
  virtual void  v71(); // _ZN7S2214C33v71Ev
  virtual void  v72(); // _ZN7S2214C33v72Ev
  virtual void  v73(); // _ZN7S2214C33v73Ev
  virtual void  v74(); // _ZN7S2214C33v74Ev
  virtual void  v75(); // _ZN7S2214C33v75Ev
  virtual void  v76(); // _ZN7S2214C33v76Ev
  virtual void  v77(); // _ZN7S2214C33v77Ev
  virtual void  v78(); // _ZN7S2214C33v78Ev
  virtual void  v79(); // _ZN7S2214C33v79Ev
  virtual void  v80(); // _ZN7S2214C33v80Ev
  virtual void  v81(); // _ZN7S2214C33v81Ev
  virtual void  v82(); // _ZN7S2214C33v82Ev
  virtual void  v83(); // _ZN7S2214C33v83Ev
  virtual void  v84(); // _ZN7S2214C33v84Ev
  virtual void  v85(); // _ZN7S2214C33v85Ev
  virtual void  v86(); // _ZN7S2214C33v86Ev
  virtual void  v87(); // _ZN7S2214C33v87Ev
  virtual void  v88(); // _ZN7S2214C33v88Ev
  virtual void  v89(); // _ZN7S2214C33v89Ev
  virtual void  v90(); // _ZN7S2214C33v90Ev
  virtual void  v91(); // _ZN7S2214C33v91Ev
  virtual void  v92(); // _ZN7S2214C33v92Ev
  virtual void  v93(); // _ZN7S2214C33v93Ev
  virtual void  v94(); // _ZN7S2214C33v94Ev
  virtual void  v95(); // _ZN7S2214C33v95Ev
  virtual void  v96(); // _ZN7S2214C33v96Ev
  virtual void  v97(); // _ZN7S2214C33v97Ev
  virtual void  v98(); // _ZN7S2214C33v98Ev
  virtual void  v99(); // _ZN7S2214C33v99Ev
  virtual void  v100(); // _ZN7S2214C34v100Ev
  virtual void  v101(); // _ZN7S2214C34v101Ev
  virtual void  v102(); // _ZN7S2214C34v102Ev
  virtual void  v103(); // _ZN7S2214C34v103Ev
  S2214C3(); // tgen
};
//SIG(-1 S2214C3) C1{ BC2{ vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fp Fi FC3{ BC4{ m Fp Fi FC5{ m} FC6{ m}}} FC7{ BC8{ m Fp Fi FC9{ m} FC9}} Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 FC10{ m FC11{ m FL[2]}} FC10 FC10 FC12{ m FC11} FC13{ m FC10} FC14{ m FC10 FC10 FC10 FC10} FC14 FC10 FC10 FC10 Fp FC13 FC15{ m FC16{ m Fp Fi FC17{ m}} Fi} Fi Fp[7] FC4 Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC18{ BC19{ m Fp Fi FC17 FC5}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC20{ m Fp Fi[2] FC21{ m}} Fp[2] Fi:16 Fi:16 FC18 FC22{ m Fp Fi[2] FC6} FC23{ m Fp Fi[2] FC21} Fp[2] Fi:24 Fi:8 Fp}


 S2214C3 ::~S2214C3(){ note_dtor("S2214C3", this);}
void  S2214C3 ::v26(){vfunc_called(this, "_ZN7S2214C33v26Ev");}
void  S2214C3 ::v27(){vfunc_called(this, "_ZN7S2214C33v27Ev");}
void  S2214C3 ::v28(){vfunc_called(this, "_ZN7S2214C33v28Ev");}
void  S2214C3 ::v29(){vfunc_called(this, "_ZN7S2214C33v29Ev");}
void  S2214C3 ::v30(){vfunc_called(this, "_ZN7S2214C33v30Ev");}
void  S2214C3 ::v31(){vfunc_called(this, "_ZN7S2214C33v31Ev");}
void  S2214C3 ::v32(){vfunc_called(this, "_ZN7S2214C33v32Ev");}
void  S2214C3 ::v33(){vfunc_called(this, "_ZN7S2214C33v33Ev");}
void  S2214C3 ::v34(){vfunc_called(this, "_ZN7S2214C33v34Ev");}
void  S2214C3 ::v35(){vfunc_called(this, "_ZN7S2214C33v35Ev");}
void  S2214C3 ::v36(){vfunc_called(this, "_ZN7S2214C33v36Ev");}
void  S2214C3 ::v37(){vfunc_called(this, "_ZN7S2214C33v37Ev");}
void  S2214C3 ::v38(){vfunc_called(this, "_ZN7S2214C33v38Ev");}
void  S2214C3 ::v39(){vfunc_called(this, "_ZN7S2214C33v39Ev");}
void  S2214C3 ::v40(){vfunc_called(this, "_ZN7S2214C33v40Ev");}
void  S2214C3 ::v41(){vfunc_called(this, "_ZN7S2214C33v41Ev");}
void  S2214C3 ::v42(){vfunc_called(this, "_ZN7S2214C33v42Ev");}
void  S2214C3 ::v43(){vfunc_called(this, "_ZN7S2214C33v43Ev");}
void  S2214C3 ::v44(){vfunc_called(this, "_ZN7S2214C33v44Ev");}
void  S2214C3 ::v45(){vfunc_called(this, "_ZN7S2214C33v45Ev");}
void  S2214C3 ::v46(){vfunc_called(this, "_ZN7S2214C33v46Ev");}
void  S2214C3 ::v47(){vfunc_called(this, "_ZN7S2214C33v47Ev");}
void  S2214C3 ::v48(){vfunc_called(this, "_ZN7S2214C33v48Ev");}
void  S2214C3 ::v49(){vfunc_called(this, "_ZN7S2214C33v49Ev");}
void  S2214C3 ::v50(){vfunc_called(this, "_ZN7S2214C33v50Ev");}
void  S2214C3 ::v51(){vfunc_called(this, "_ZN7S2214C33v51Ev");}
void  S2214C3 ::v52(){vfunc_called(this, "_ZN7S2214C33v52Ev");}
void  S2214C3 ::v53(){vfunc_called(this, "_ZN7S2214C33v53Ev");}
void  S2214C3 ::v54(){vfunc_called(this, "_ZN7S2214C33v54Ev");}
void  S2214C3 ::v55(){vfunc_called(this, "_ZN7S2214C33v55Ev");}
void  S2214C3 ::v56(){vfunc_called(this, "_ZN7S2214C33v56Ev");}
void  S2214C3 ::v57(){vfunc_called(this, "_ZN7S2214C33v57Ev");}
void  S2214C3 ::v58(){vfunc_called(this, "_ZN7S2214C33v58Ev");}
void  S2214C3 ::v59(){vfunc_called(this, "_ZN7S2214C33v59Ev");}
void  S2214C3 ::v60(){vfunc_called(this, "_ZN7S2214C33v60Ev");}
void  S2214C3 ::v61(){vfunc_called(this, "_ZN7S2214C33v61Ev");}
void  S2214C3 ::v62(){vfunc_called(this, "_ZN7S2214C33v62Ev");}
void  S2214C3 ::v63(){vfunc_called(this, "_ZN7S2214C33v63Ev");}
void  S2214C3 ::v64(){vfunc_called(this, "_ZN7S2214C33v64Ev");}
void  S2214C3 ::v65(){vfunc_called(this, "_ZN7S2214C33v65Ev");}
void  S2214C3 ::v66(){vfunc_called(this, "_ZN7S2214C33v66Ev");}
void  S2214C3 ::v67(){vfunc_called(this, "_ZN7S2214C33v67Ev");}
void  S2214C3 ::v68(){vfunc_called(this, "_ZN7S2214C33v68Ev");}
void  S2214C3 ::v69(){vfunc_called(this, "_ZN7S2214C33v69Ev");}
void  S2214C3 ::v70(){vfunc_called(this, "_ZN7S2214C33v70Ev");}
void  S2214C3 ::v71(){vfunc_called(this, "_ZN7S2214C33v71Ev");}
void  S2214C3 ::v72(){vfunc_called(this, "_ZN7S2214C33v72Ev");}
void  S2214C3 ::v73(){vfunc_called(this, "_ZN7S2214C33v73Ev");}
void  S2214C3 ::v74(){vfunc_called(this, "_ZN7S2214C33v74Ev");}
void  S2214C3 ::v75(){vfunc_called(this, "_ZN7S2214C33v75Ev");}
void  S2214C3 ::v76(){vfunc_called(this, "_ZN7S2214C33v76Ev");}
void  S2214C3 ::v77(){vfunc_called(this, "_ZN7S2214C33v77Ev");}
void  S2214C3 ::v78(){vfunc_called(this, "_ZN7S2214C33v78Ev");}
void  S2214C3 ::v79(){vfunc_called(this, "_ZN7S2214C33v79Ev");}
void  S2214C3 ::v80(){vfunc_called(this, "_ZN7S2214C33v80Ev");}
void  S2214C3 ::v81(){vfunc_called(this, "_ZN7S2214C33v81Ev");}
void  S2214C3 ::v82(){vfunc_called(this, "_ZN7S2214C33v82Ev");}
void  S2214C3 ::v83(){vfunc_called(this, "_ZN7S2214C33v83Ev");}
void  S2214C3 ::v84(){vfunc_called(this, "_ZN7S2214C33v84Ev");}
void  S2214C3 ::v85(){vfunc_called(this, "_ZN7S2214C33v85Ev");}
void  S2214C3 ::v86(){vfunc_called(this, "_ZN7S2214C33v86Ev");}
void  S2214C3 ::v87(){vfunc_called(this, "_ZN7S2214C33v87Ev");}
void  S2214C3 ::v88(){vfunc_called(this, "_ZN7S2214C33v88Ev");}
void  S2214C3 ::v89(){vfunc_called(this, "_ZN7S2214C33v89Ev");}
void  S2214C3 ::v90(){vfunc_called(this, "_ZN7S2214C33v90Ev");}
void  S2214C3 ::v91(){vfunc_called(this, "_ZN7S2214C33v91Ev");}
void  S2214C3 ::v92(){vfunc_called(this, "_ZN7S2214C33v92Ev");}
void  S2214C3 ::v93(){vfunc_called(this, "_ZN7S2214C33v93Ev");}
void  S2214C3 ::v94(){vfunc_called(this, "_ZN7S2214C33v94Ev");}
void  S2214C3 ::v95(){vfunc_called(this, "_ZN7S2214C33v95Ev");}
void  S2214C3 ::v96(){vfunc_called(this, "_ZN7S2214C33v96Ev");}
void  S2214C3 ::v97(){vfunc_called(this, "_ZN7S2214C33v97Ev");}
void  S2214C3 ::v98(){vfunc_called(this, "_ZN7S2214C33v98Ev");}
void  S2214C3 ::v99(){vfunc_called(this, "_ZN7S2214C33v99Ev");}
void  S2214C3 ::v100(){vfunc_called(this, "_ZN7S2214C34v100Ev");}
void  S2214C3 ::v101(){vfunc_called(this, "_ZN7S2214C34v101Ev");}
void  S2214C3 ::v102(){vfunc_called(this, "_ZN7S2214C34v102Ev");}
void  S2214C3 ::v103(){vfunc_called(this, "_ZN7S2214C34v103Ev");}
S2214C3 ::S2214C3(){ note_ctor("S2214C3", this);} // tgen

static void Test_S2214C3()
{
  extern Class_Descriptor cd_S2214C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(105,159)];
    init_test(&cd_S2214C3, buf);
    S2214C3 *dp, &lv = *(dp=new (buf) S2214C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(832,632), "sizeof(S2214C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2214C3)");
    check_base_class_offset(lv, (S2214C4*), 0, "S2214C3");
    check_field_offset(lv, s2214c3f0, ABISELECT(64,40), "S2214C3.s2214c3f0");
    check_field_offset(lv, s2214c3f1, ABISELECT(80,56), "S2214C3.s2214c3f1");
    check_field_offset(lv, s2214c3f2, ABISELECT(96,72), "S2214C3.s2214c3f2");
    check_field_offset(lv, s2214c3f3, ABISELECT(112,88), "S2214C3.s2214c3f3");
    check_field_offset(lv, s2214c3f4, ABISELECT(128,104), "S2214C3.s2214c3f4");
    check_field_offset(lv, s2214c3f5, ABISELECT(144,120), "S2214C3.s2214c3f5");
    check_field_offset(lv, s2214c3f6, ABISELECT(208,184), "S2214C3.s2214c3f6");
    check_field_offset(lv, s2214c3f7, ABISELECT(272,248), "S2214C3.s2214c3f7");
    check_field_offset(lv, s2214c3f8, ABISELECT(288,264), "S2214C3.s2214c3f8");
    check_field_offset(lv, s2214c3f9, ABISELECT(304,280), "S2214C3.s2214c3f9");
    check_field_offset(lv, s2214c3f10, ABISELECT(320,296), "S2214C3.s2214c3f10");
    check_field_offset(lv, s2214c3f11, ABISELECT(328,300), "S2214C3.s2214c3f11");
    check_field_offset(lv, s2214c3f12, ABISELECT(344,316), "S2214C3.s2214c3f12");
    check_field_offset(lv, s2214c3f13, ABISELECT(368,332), "S2214C3.s2214c3f13");
    check_field_offset(lv, s2214c3f14, ABISELECT(376,336), "S2214C3.s2214c3f14");
    check_field_offset(lv, s2214c3f15, ABISELECT(432,364), "S2214C3.s2214c3f15");
    set_bf_and_test(lv, s2214c3f16, ABISELECT(448,376), 0, 8, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f16, ABISELECT(448,376), 0, 8, hide_sll(1LL<<7), "S2214C3");
    set_bf_and_test(lv, s2214c3f17, ABISELECT(449,377), 0, 8, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f17, ABISELECT(449,377), 0, 8, hide_sll(1LL<<7), "S2214C3");
    set_bf_and_test(lv, s2214c3f18, ABISELECT(450,378), 0, 16, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f18, ABISELECT(450,378), 0, 16, hide_sll(1LL<<15), "S2214C3");
    set_bf_and_test(lv, s2214c3f19, ABISELECT(452,380), 0, 16, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f19, ABISELECT(452,380), 0, 16, hide_sll(1LL<<15), "S2214C3");
    set_bf_and_test(lv, s2214c3f20, ABISELECT(454,382), 0, 8, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f20, ABISELECT(454,382), 0, 8, hide_sll(1LL<<7), "S2214C3");
    set_bf_and_test(lv, s2214c3f21, ABISELECT(455,383), 0, 8, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f21, ABISELECT(455,383), 0, 8, hide_sll(1LL<<7), "S2214C3");
    set_bf_and_test(lv, s2214c3f22, ABISELECT(456,384), 0, 8, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f22, ABISELECT(456,384), 0, 8, hide_sll(1LL<<7), "S2214C3");
    set_bf_and_test(lv, s2214c3f23, ABISELECT(460,388), 0, 32, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f23, ABISELECT(460,388), 0, 32, hide_sll(1LL<<31), "S2214C3");
    set_bf_and_test(lv, s2214c3f24, ABISELECT(464,392), 0, 8, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f24, ABISELECT(464,392), 0, 8, hide_sll(1LL<<7), "S2214C3");
    set_bf_and_test(lv, s2214c3f25, ABISELECT(465,393), 0, 4, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f25, ABISELECT(465,393), 0, 4, hide_sll(1LL<<3), "S2214C3");
    set_bf_and_test(lv, s2214c3f26, ABISELECT(465,393), 4, 4, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f26, ABISELECT(465,393), 4, 4, hide_sll(1LL<<3), "S2214C3");
    set_bf_and_test(lv, s2214c3f27, ABISELECT(466,394), 0, 4, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f27, ABISELECT(466,394), 0, 4, hide_sll(1LL<<3), "S2214C3");
    set_bf_and_test(lv, s2214c3f28, ABISELECT(466,394), 4, 4, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f28, ABISELECT(466,394), 4, 4, hide_sll(1LL<<3), "S2214C3");
    set_bf_and_test(lv, s2214c3f29, ABISELECT(467,395), 0, 4, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f29, ABISELECT(467,395), 0, 4, hide_sll(1LL<<3), "S2214C3");
    set_bf_and_test(lv, s2214c3f30, ABISELECT(467,395), 4, 4, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f30, ABISELECT(467,395), 4, 4, hide_sll(1LL<<3), "S2214C3");
    set_bf_and_test(lv, s2214c3f31, ABISELECT(468,396), 0, 4, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f31, ABISELECT(468,396), 0, 4, hide_sll(1LL<<3), "S2214C3");
    set_bf_and_test(lv, s2214c3f32, ABISELECT(468,396), 4, 4, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f32, ABISELECT(468,396), 4, 4, hide_sll(1LL<<3), "S2214C3");
    set_bf_and_test(lv, s2214c3f33, ABISELECT(469,397), 0, 4, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f33, ABISELECT(469,397), 0, 4, hide_sll(1LL<<3), "S2214C3");
    set_bf_and_test(lv, s2214c3f34, ABISELECT(469,397), 4, 4, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f34, ABISELECT(469,397), 4, 4, hide_sll(1LL<<3), "S2214C3");
    set_bf_and_test(lv, s2214c3f35, ABISELECT(470,398), 0, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f36, ABISELECT(470,398), 1, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f37, ABISELECT(470,398), 2, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f38, ABISELECT(470,398), 3, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f39, ABISELECT(470,398), 4, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f40, ABISELECT(470,398), 5, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f41, ABISELECT(470,398), 6, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f42, ABISELECT(470,398), 7, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f43, ABISELECT(471,399), 0, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f44, ABISELECT(471,399), 1, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f45, ABISELECT(471,399), 2, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f46, ABISELECT(471,399), 3, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f47, ABISELECT(471,399), 4, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f48, ABISELECT(471,399), 5, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f49, ABISELECT(471,399), 6, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f50, ABISELECT(471,399), 7, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f51, ABISELECT(472,400), 0, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f52, ABISELECT(472,400), 1, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f53, ABISELECT(472,400), 2, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f54, ABISELECT(472,400), 3, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f55, ABISELECT(472,400), 4, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f56, ABISELECT(472,400), 5, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f57, ABISELECT(472,400), 6, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f58, ABISELECT(472,400), 7, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f59, ABISELECT(473,401), 0, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f60, ABISELECT(473,401), 1, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f61, ABISELECT(473,401), 2, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f62, ABISELECT(473,401), 3, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f63, ABISELECT(473,401), 4, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f64, ABISELECT(473,401), 5, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f65, ABISELECT(473,401), 6, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f66, ABISELECT(473,401), 7, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f67, ABISELECT(474,402), 0, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f68, ABISELECT(474,402), 1, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f69, ABISELECT(474,402), 2, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f70, ABISELECT(474,402), 3, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f71, ABISELECT(474,402), 4, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f72, ABISELECT(474,402), 5, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f73, ABISELECT(474,402), 6, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f74, ABISELECT(474,402), 7, 1, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f75, ABISELECT(475,403), 0, 1, 1, "S2214C3");
    check_field_offset(lv, s2214c3f76, ABISELECT(476,404), "S2214C3.s2214c3f76");
    check_field_offset(lv, s2214c3f77, ABISELECT(504,432), "S2214C3.s2214c3f77");
    set_bf_and_test(lv, s2214c3f78, ABISELECT(552,456), 0, 8, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f78, ABISELECT(552,456), 0, 8, hide_sll(1LL<<7), "S2214C3");
    set_bf_and_test(lv, s2214c3f79, ABISELECT(553,457), 0, 8, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f79, ABISELECT(553,457), 0, 8, hide_sll(1LL<<7), "S2214C3");
    set_bf_and_test(lv, s2214c3f80, ABISELECT(554,458), 0, 8, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f80, ABISELECT(554,458), 0, 8, hide_sll(1LL<<7), "S2214C3");
    set_bf_and_test(lv, s2214c3f81, ABISELECT(555,459), 0, 8, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f81, ABISELECT(555,459), 0, 8, hide_sll(1LL<<7), "S2214C3");
    set_bf_and_test(lv, s2214c3f82, ABISELECT(556,460), 0, 8, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f82, ABISELECT(556,460), 0, 8, hide_sll(1LL<<7), "S2214C3");
    set_bf_and_test(lv, s2214c3f83, ABISELECT(557,461), 0, 8, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f83, ABISELECT(557,461), 0, 8, hide_sll(1LL<<7), "S2214C3");
    check_field_offset(lv, s2214c3f84, ABISELECT(560,464), "S2214C3.s2214c3f84");
    check_field_offset(lv, s2214c3f85, ABISELECT(576,476), "S2214C3.s2214c3f85");
    set_bf_and_test(lv, s2214c3f86, ABISELECT(608,492), 0, 8, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f86, ABISELECT(608,492), 0, 8, hide_sll(1LL<<7), "S2214C3");
    set_bf_and_test(lv, s2214c3f87, ABISELECT(609,493), 0, 8, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f87, ABISELECT(609,493), 0, 8, hide_sll(1LL<<7), "S2214C3");
    set_bf_and_test(lv, s2214c3f88, ABISELECT(610,494), 0, 8, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f88, ABISELECT(610,494), 0, 8, hide_sll(1LL<<7), "S2214C3");
    set_bf_and_test(lv, s2214c3f89, ABISELECT(611,495), 0, 8, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f89, ABISELECT(611,495), 0, 8, hide_sll(1LL<<7), "S2214C3");
    set_bf_and_test(lv, s2214c3f90, ABISELECT(612,496), 0, 8, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f90, ABISELECT(612,496), 0, 8, hide_sll(1LL<<7), "S2214C3");
    set_bf_and_test(lv, s2214c3f91, ABISELECT(613,497), 0, 16, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f91, ABISELECT(613,497), 0, 16, hide_sll(1LL<<15), "S2214C3");
    set_bf_and_test(lv, s2214c3f92, ABISELECT(616,500), 0, 16, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f92, ABISELECT(616,500), 0, 16, hide_sll(1LL<<15), "S2214C3");
    set_bf_and_test(lv, s2214c3f93, ABISELECT(618,502), 0, 16, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f93, ABISELECT(618,502), 0, 16, hide_sll(1LL<<15), "S2214C3");
    set_bf_and_test(lv, s2214c3f94, ABISELECT(620,504), 0, 4, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f94, ABISELECT(620,504), 0, 4, hide_sll(1LL<<3), "S2214C3");
    set_bf_and_test(lv, s2214c3f95, ABISELECT(620,504), 4, 4, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f95, ABISELECT(620,504), 4, 4, hide_sll(1LL<<3), "S2214C3");
    set_bf_and_test(lv, s2214c3f96, ABISELECT(621,505), 0, 4, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f96, ABISELECT(621,505), 0, 4, hide_sll(1LL<<3), "S2214C3");
    set_bf_and_test(lv, s2214c3f97, ABISELECT(621,505), 4, 4, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f97, ABISELECT(621,505), 4, 4, hide_sll(1LL<<3), "S2214C3");
    set_bf_and_test(lv, s2214c3f98, ABISELECT(622,506), 0, 4, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f98, ABISELECT(622,506), 0, 4, hide_sll(1LL<<3), "S2214C3");
    set_bf_and_test(lv, s2214c3f99, ABISELECT(622,506), 4, 4, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f99, ABISELECT(622,506), 4, 4, hide_sll(1LL<<3), "S2214C3");
    set_bf_and_test(lv, s2214c3f100, ABISELECT(623,507), 0, 4, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f100, ABISELECT(623,507), 0, 4, hide_sll(1LL<<3), "S2214C3");
    set_bf_and_test(lv, s2214c3f101, ABISELECT(623,507), 4, 4, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f101, ABISELECT(623,507), 4, 4, hide_sll(1LL<<3), "S2214C3");
    set_bf_and_test(lv, s2214c3f102, ABISELECT(624,508), 0, 4, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f102, ABISELECT(624,508), 0, 4, hide_sll(1LL<<3), "S2214C3");
    set_bf_and_test(lv, s2214c3f103, ABISELECT(624,508), 4, 4, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f103, ABISELECT(624,508), 4, 4, hide_sll(1LL<<3), "S2214C3");
    set_bf_and_test(lv, s2214c3f104, ABISELECT(625,509), 0, 4, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f104, ABISELECT(625,509), 0, 4, hide_sll(1LL<<3), "S2214C3");
    set_bf_and_test(lv, s2214c3f105, ABISELECT(625,509), 4, 4, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f105, ABISELECT(625,509), 4, 4, hide_sll(1LL<<3), "S2214C3");
    set_bf_and_test(lv, s2214c3f106, ABISELECT(626,510), 0, 8, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f106, ABISELECT(626,510), 0, 8, hide_sll(1LL<<7), "S2214C3");
    set_bf_and_test(lv, s2214c3f107, ABISELECT(627,511), 0, 8, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f107, ABISELECT(627,511), 0, 8, hide_sll(1LL<<7), "S2214C3");
    set_bf_and_test(lv, s2214c3f108, ABISELECT(628,512), 0, 8, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f108, ABISELECT(628,512), 0, 8, hide_sll(1LL<<7), "S2214C3");
    check_field_offset(lv, s2214c3f109, ABISELECT(632,516), "S2214C3.s2214c3f109");
    check_field_offset(lv, s2214c3f110, ABISELECT(688,544), "S2214C3.s2214c3f110");
    check_field_offset(lv, s2214c3f111, ABISELECT(712,560), "S2214C3.s2214c3f111");
    set_bf_and_test(lv, s2214c3f112, ABISELECT(728,568), 0, 16, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f112, ABISELECT(728,568), 0, 16, hide_sll(1LL<<15), "S2214C3");
    set_bf_and_test(lv, s2214c3f113, ABISELECT(730,570), 0, 16, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f113, ABISELECT(730,570), 0, 16, hide_sll(1LL<<15), "S2214C3");
    check_field_offset(lv, s2214c3f114, ABISELECT(736,572), "S2214C3.s2214c3f114");
    check_field_offset(lv, s2214c3f115, ABISELECT(752,584), "S2214C3.s2214c3f115");
    check_field_offset(lv, s2214c3f116, ABISELECT(776,600), "S2214C3.s2214c3f116");
    check_field_offset(lv, s2214c3f117, ABISELECT(800,616), "S2214C3.s2214c3f117");
    set_bf_and_test(lv, s2214c3f118, ABISELECT(816,624), 0, 24, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f118, ABISELECT(816,624), 0, 24, hide_sll(1LL<<23), "S2214C3");
    set_bf_and_test(lv, s2214c3f119, ABISELECT(819,627), 0, 8, 1, "S2214C3");
    set_bf_and_test(lv, s2214c3f119, ABISELECT(819,627), 0, 8, hide_sll(1LL<<7), "S2214C3");
    check_field_offset(lv, s2214c3f120, ABISELECT(824,628), "S2214C3.s2214c3f120");
    test_class_info(&lv, &cd_S2214C3);
    dp->~S2214C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2214C3(Test_S2214C3, "S2214C3", ABISELECT(832,632));

#else // __cplusplus

extern void _ZN7S2214C3C1Ev();
extern void _ZN7S2214C3D1Ev();
Name_Map name_map_S2214C3[] = {
  NSPAIR(_ZN7S2214C3C1Ev),
  NSPAIR(_ZN7S2214C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2214C4;
extern VTBL_ENTRY _ZTI7S2214C4[];
extern  VTBL_ENTRY _ZTV7S2214C4[];
static Base_Class bases_S2214C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2214C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2214C3[];
extern void _ZN7S2214C3D1Ev();
extern void _ZN7S2214C3D0Ev();
extern void _ZN7S2214C42v3Ev();
extern void _ZN7S2214C42v4Ev();
extern void _ZN7S2214C42v5Ev();
extern void _ZN7S2214C42v6Ev();
extern void _ZN7S2214C42v7Ev();
extern void _ZN7S2214C42v8Ev();
extern void _ZN7S2214C42v9Ev();
extern void _ZN7S2214C43v10Ev();
extern void _ZN7S2214C43v11Ev();
extern void _ZN7S2214C43v12Ev();
extern void _ZN7S2214C43v13Ev();
extern void _ZN7S2214C43v14Ev();
extern void _ZN7S2214C43v15Ev();
extern void _ZN7S2214C43v16Ev();
extern void _ZN7S2214C43v17Ev();
extern void _ZN7S2214C43v18Ev();
extern void _ZN7S2214C43v19Ev();
extern void _ZN7S2214C43v20Ev();
extern void _ZN7S2214C43v21Ev();
extern void _ZN7S2214C43v22Ev();
extern void _ZN7S2214C43v23Ev();
extern void _ZN7S2214C43v24Ev();
extern void _ZN7S2214C43v25Ev();
extern void _ZN7S2214C33v26Ev();
extern void _ZN7S2214C33v27Ev();
extern void _ZN7S2214C33v28Ev();
extern void _ZN7S2214C33v29Ev();
extern void _ZN7S2214C33v30Ev();
extern void _ZN7S2214C33v31Ev();
extern void _ZN7S2214C33v32Ev();
extern void _ZN7S2214C33v33Ev();
extern void _ZN7S2214C33v34Ev();
extern void _ZN7S2214C33v35Ev();
extern void _ZN7S2214C33v36Ev();
extern void _ZN7S2214C33v37Ev();
extern void _ZN7S2214C33v38Ev();
extern void _ZN7S2214C33v39Ev();
extern void _ZN7S2214C33v40Ev();
extern void _ZN7S2214C33v41Ev();
extern void _ZN7S2214C33v42Ev();
extern void _ZN7S2214C33v43Ev();
extern void _ZN7S2214C33v44Ev();
extern void _ZN7S2214C33v45Ev();
extern void _ZN7S2214C33v46Ev();
extern void _ZN7S2214C33v47Ev();
extern void _ZN7S2214C33v48Ev();
extern void _ZN7S2214C33v49Ev();
extern void _ZN7S2214C33v50Ev();
extern void _ZN7S2214C33v51Ev();
extern void _ZN7S2214C33v52Ev();
extern void _ZN7S2214C33v53Ev();
extern void _ZN7S2214C33v54Ev();
extern void _ZN7S2214C33v55Ev();
extern void _ZN7S2214C33v56Ev();
extern void _ZN7S2214C33v57Ev();
extern void _ZN7S2214C33v58Ev();
extern void _ZN7S2214C33v59Ev();
extern void _ZN7S2214C33v60Ev();
extern void _ZN7S2214C33v61Ev();
extern void _ZN7S2214C33v62Ev();
extern void _ZN7S2214C33v63Ev();
extern void _ZN7S2214C33v64Ev();
extern void _ZN7S2214C33v65Ev();
extern void _ZN7S2214C33v66Ev();
extern void _ZN7S2214C33v67Ev();
extern void _ZN7S2214C33v68Ev();
extern void _ZN7S2214C33v69Ev();
extern void _ZN7S2214C33v70Ev();
extern void _ZN7S2214C33v71Ev();
extern void _ZN7S2214C33v72Ev();
extern void _ZN7S2214C33v73Ev();
extern void _ZN7S2214C33v74Ev();
extern void _ZN7S2214C33v75Ev();
extern void _ZN7S2214C33v76Ev();
extern void _ZN7S2214C33v77Ev();
extern void _ZN7S2214C33v78Ev();
extern void _ZN7S2214C33v79Ev();
extern void _ZN7S2214C33v80Ev();
extern void _ZN7S2214C33v81Ev();
extern void _ZN7S2214C33v82Ev();
extern void _ZN7S2214C33v83Ev();
extern void _ZN7S2214C33v84Ev();
extern void _ZN7S2214C33v85Ev();
extern void _ZN7S2214C33v86Ev();
extern void _ZN7S2214C33v87Ev();
extern void _ZN7S2214C33v88Ev();
extern void _ZN7S2214C33v89Ev();
extern void _ZN7S2214C33v90Ev();
extern void _ZN7S2214C33v91Ev();
extern void _ZN7S2214C33v92Ev();
extern void _ZN7S2214C33v93Ev();
extern void _ZN7S2214C33v94Ev();
extern void _ZN7S2214C33v95Ev();
extern void _ZN7S2214C33v96Ev();
extern void _ZN7S2214C33v97Ev();
extern void _ZN7S2214C33v98Ev();
extern void _ZN7S2214C33v99Ev();
extern void _ZN7S2214C34v100Ev();
extern void _ZN7S2214C34v101Ev();
extern void _ZN7S2214C34v102Ev();
extern void _ZN7S2214C34v103Ev();
static  VTBL_ENTRY vtc_S2214C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2214C3[0]),
  (VTBL_ENTRY)&_ZN7S2214C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2214C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2214C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2214C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2214C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2214C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2214C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2214C42v8Ev,
  (VTBL_ENTRY)&_ZN7S2214C42v9Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v14Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v15Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v16Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v17Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v18Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v19Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v20Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v21Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v22Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v23Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v24Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v25Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v26Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v27Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v28Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v29Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v30Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v31Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v32Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v33Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v34Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v35Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v36Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v37Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v38Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v39Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v40Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v41Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v42Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v43Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v44Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v45Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v46Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v47Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v48Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v49Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v50Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v51Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v52Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v53Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v54Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v55Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v56Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v57Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v58Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v59Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v60Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v61Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v62Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v63Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v64Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v65Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v66Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v67Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v68Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v69Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v70Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v71Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v72Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v73Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v74Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v75Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v76Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v77Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v78Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v79Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v80Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v81Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v82Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v83Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v84Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v85Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v86Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v87Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v88Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v89Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v90Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v91Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v92Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v93Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v94Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v95Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v96Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v97Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v98Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v99Ev,
  (VTBL_ENTRY)&_ZN7S2214C34v100Ev,
  (VTBL_ENTRY)&_ZN7S2214C34v101Ev,
  (VTBL_ENTRY)&_ZN7S2214C34v102Ev,
  (VTBL_ENTRY)&_ZN7S2214C34v103Ev,
};
extern VTBL_ENTRY _ZTI7S2214C3[];
extern  VTBL_ENTRY _ZTV7S2214C3[];
Class_Descriptor cd_S2214C3 = {  "S2214C3", // class name
  bases_S2214C3, 1,
  &(vtc_S2214C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(832,632), // object size
  NSPAIRA(_ZTI7S2214C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2214C3),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2214C2_nt  : S2214C3 {
  void *s2214c2f0;
  virtual  ~S2214C2_nt(); // _ZN10S2214C2_ntD1Ev
  virtual void  v104(); // _ZN10S2214C2_nt4v104Ev
  virtual void  v105(); // _ZN10S2214C2_nt4v105Ev
  virtual void  v106(); // _ZN10S2214C2_nt4v106Ev
  virtual void  v107(); // _ZN10S2214C2_nt4v107Ev
  virtual void  v108(); // _ZN10S2214C2_nt4v108Ev
  virtual void  v109(); // _ZN10S2214C2_nt4v109Ev
  virtual void  v110(); // _ZN10S2214C2_nt4v110Ev
  virtual void  v111(); // _ZN10S2214C2_nt4v111Ev
  virtual void  v112(); // _ZN10S2214C2_nt4v112Ev
  virtual void  v113(); // _ZN10S2214C2_nt4v113Ev
  S2214C2_nt(); // tgen
};
//SIG(-1 S2214C2_nt) C1{ BC2{ BC3{ vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 Fp Fi FC4{ BC5{ m Fp Fi FC6{ m} FC7{ m}}} FC8{ BC9{ m Fp Fi FC10{ m} FC10}} Fi} vd v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 FC11{ m FC12{ m FL[2]}} FC11 FC11 FC13{ m FC12} FC14{ m FC11} FC15{ m FC11 FC11 FC11 FC11} FC15 FC11 FC11 FC11 Fp FC14 FC16{ m FC17{ m Fp Fi FC18{ m}} Fi} Fi Fp[7] FC5 Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC19{ BC20{ m Fp Fi FC18 FC6}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC21{ m Fp Fi[2] FC22{ m}} Fp[2] Fi:16 Fi:16 FC19 FC23{ m Fp Fi[2] FC7} FC24{ m Fp Fi[2] FC22} Fp[2] Fi:24 Fi:8 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp}


 S2214C2_nt ::~S2214C2_nt(){ note_dtor("S2214C2_nt", this);}
void  S2214C2_nt ::v104(){vfunc_called(this, "_ZN10S2214C2_nt4v104Ev");}
void  S2214C2_nt ::v105(){vfunc_called(this, "_ZN10S2214C2_nt4v105Ev");}
void  S2214C2_nt ::v106(){vfunc_called(this, "_ZN10S2214C2_nt4v106Ev");}
void  S2214C2_nt ::v107(){vfunc_called(this, "_ZN10S2214C2_nt4v107Ev");}
void  S2214C2_nt ::v108(){vfunc_called(this, "_ZN10S2214C2_nt4v108Ev");}
void  S2214C2_nt ::v109(){vfunc_called(this, "_ZN10S2214C2_nt4v109Ev");}
void  S2214C2_nt ::v110(){vfunc_called(this, "_ZN10S2214C2_nt4v110Ev");}
void  S2214C2_nt ::v111(){vfunc_called(this, "_ZN10S2214C2_nt4v111Ev");}
void  S2214C2_nt ::v112(){vfunc_called(this, "_ZN10S2214C2_nt4v112Ev");}
void  S2214C2_nt ::v113(){vfunc_called(this, "_ZN10S2214C2_nt4v113Ev");}
S2214C2_nt ::S2214C2_nt(){ note_ctor("S2214C2_nt", this);} // tgen

//skip512 S2214C2_nt

#else // __cplusplus

extern void _ZN10S2214C2_ntC1Ev();
extern void _ZN10S2214C2_ntD1Ev();
Name_Map name_map_S2214C2_nt[] = {
  NSPAIR(_ZN10S2214C2_ntC1Ev),
  NSPAIR(_ZN10S2214C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2214C4;
extern VTBL_ENTRY _ZTI7S2214C4[];
extern  VTBL_ENTRY _ZTV7S2214C4[];
extern Class_Descriptor cd_S2214C3;
extern VTBL_ENTRY _ZTI7S2214C3[];
extern  VTBL_ENTRY _ZTV7S2214C3[];
static Base_Class bases_S2214C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2214C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2214C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S2214C2_nt[];
extern void _ZN10S2214C2_ntD1Ev();
extern void _ZN10S2214C2_ntD0Ev();
extern void _ZN7S2214C42v3Ev();
extern void _ZN7S2214C42v4Ev();
extern void _ZN7S2214C42v5Ev();
extern void _ZN7S2214C42v6Ev();
extern void _ZN7S2214C42v7Ev();
extern void _ZN7S2214C42v8Ev();
extern void _ZN7S2214C42v9Ev();
extern void _ZN7S2214C43v10Ev();
extern void _ZN7S2214C43v11Ev();
extern void _ZN7S2214C43v12Ev();
extern void _ZN7S2214C43v13Ev();
extern void _ZN7S2214C43v14Ev();
extern void _ZN7S2214C43v15Ev();
extern void _ZN7S2214C43v16Ev();
extern void _ZN7S2214C43v17Ev();
extern void _ZN7S2214C43v18Ev();
extern void _ZN7S2214C43v19Ev();
extern void _ZN7S2214C43v20Ev();
extern void _ZN7S2214C43v21Ev();
extern void _ZN7S2214C43v22Ev();
extern void _ZN7S2214C43v23Ev();
extern void _ZN7S2214C43v24Ev();
extern void _ZN7S2214C43v25Ev();
extern void _ZN7S2214C33v26Ev();
extern void _ZN7S2214C33v27Ev();
extern void _ZN7S2214C33v28Ev();
extern void _ZN7S2214C33v29Ev();
extern void _ZN7S2214C33v30Ev();
extern void _ZN7S2214C33v31Ev();
extern void _ZN7S2214C33v32Ev();
extern void _ZN7S2214C33v33Ev();
extern void _ZN7S2214C33v34Ev();
extern void _ZN7S2214C33v35Ev();
extern void _ZN7S2214C33v36Ev();
extern void _ZN7S2214C33v37Ev();
extern void _ZN7S2214C33v38Ev();
extern void _ZN7S2214C33v39Ev();
extern void _ZN7S2214C33v40Ev();
extern void _ZN7S2214C33v41Ev();
extern void _ZN7S2214C33v42Ev();
extern void _ZN7S2214C33v43Ev();
extern void _ZN7S2214C33v44Ev();
extern void _ZN7S2214C33v45Ev();
extern void _ZN7S2214C33v46Ev();
extern void _ZN7S2214C33v47Ev();
extern void _ZN7S2214C33v48Ev();
extern void _ZN7S2214C33v49Ev();
extern void _ZN7S2214C33v50Ev();
extern void _ZN7S2214C33v51Ev();
extern void _ZN7S2214C33v52Ev();
extern void _ZN7S2214C33v53Ev();
extern void _ZN7S2214C33v54Ev();
extern void _ZN7S2214C33v55Ev();
extern void _ZN7S2214C33v56Ev();
extern void _ZN7S2214C33v57Ev();
extern void _ZN7S2214C33v58Ev();
extern void _ZN7S2214C33v59Ev();
extern void _ZN7S2214C33v60Ev();
extern void _ZN7S2214C33v61Ev();
extern void _ZN7S2214C33v62Ev();
extern void _ZN7S2214C33v63Ev();
extern void _ZN7S2214C33v64Ev();
extern void _ZN7S2214C33v65Ev();
extern void _ZN7S2214C33v66Ev();
extern void _ZN7S2214C33v67Ev();
extern void _ZN7S2214C33v68Ev();
extern void _ZN7S2214C33v69Ev();
extern void _ZN7S2214C33v70Ev();
extern void _ZN7S2214C33v71Ev();
extern void _ZN7S2214C33v72Ev();
extern void _ZN7S2214C33v73Ev();
extern void _ZN7S2214C33v74Ev();
extern void _ZN7S2214C33v75Ev();
extern void _ZN7S2214C33v76Ev();
extern void _ZN7S2214C33v77Ev();
extern void _ZN7S2214C33v78Ev();
extern void _ZN7S2214C33v79Ev();
extern void _ZN7S2214C33v80Ev();
extern void _ZN7S2214C33v81Ev();
extern void _ZN7S2214C33v82Ev();
extern void _ZN7S2214C33v83Ev();
extern void _ZN7S2214C33v84Ev();
extern void _ZN7S2214C33v85Ev();
extern void _ZN7S2214C33v86Ev();
extern void _ZN7S2214C33v87Ev();
extern void _ZN7S2214C33v88Ev();
extern void _ZN7S2214C33v89Ev();
extern void _ZN7S2214C33v90Ev();
extern void _ZN7S2214C33v91Ev();
extern void _ZN7S2214C33v92Ev();
extern void _ZN7S2214C33v93Ev();
extern void _ZN7S2214C33v94Ev();
extern void _ZN7S2214C33v95Ev();
extern void _ZN7S2214C33v96Ev();
extern void _ZN7S2214C33v97Ev();
extern void _ZN7S2214C33v98Ev();
extern void _ZN7S2214C33v99Ev();
extern void _ZN7S2214C34v100Ev();
extern void _ZN7S2214C34v101Ev();
extern void _ZN7S2214C34v102Ev();
extern void _ZN7S2214C34v103Ev();
extern void _ZN10S2214C2_nt4v104Ev();
extern void _ZN10S2214C2_nt4v105Ev();
extern void _ZN10S2214C2_nt4v106Ev();
extern void _ZN10S2214C2_nt4v107Ev();
extern void _ZN10S2214C2_nt4v108Ev();
extern void _ZN10S2214C2_nt4v109Ev();
extern void _ZN10S2214C2_nt4v110Ev();
extern void _ZN10S2214C2_nt4v111Ev();
extern void _ZN10S2214C2_nt4v112Ev();
extern void _ZN10S2214C2_nt4v113Ev();
static  VTBL_ENTRY vtc_S2214C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2214C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S2214C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2214C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN7S2214C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2214C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2214C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2214C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2214C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2214C42v8Ev,
  (VTBL_ENTRY)&_ZN7S2214C42v9Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v14Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v15Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v16Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v17Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v18Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v19Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v20Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v21Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v22Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v23Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v24Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v25Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v26Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v27Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v28Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v29Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v30Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v31Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v32Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v33Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v34Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v35Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v36Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v37Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v38Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v39Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v40Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v41Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v42Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v43Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v44Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v45Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v46Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v47Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v48Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v49Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v50Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v51Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v52Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v53Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v54Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v55Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v56Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v57Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v58Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v59Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v60Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v61Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v62Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v63Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v64Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v65Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v66Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v67Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v68Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v69Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v70Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v71Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v72Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v73Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v74Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v75Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v76Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v77Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v78Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v79Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v80Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v81Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v82Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v83Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v84Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v85Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v86Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v87Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v88Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v89Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v90Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v91Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v92Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v93Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v94Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v95Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v96Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v97Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v98Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v99Ev,
  (VTBL_ENTRY)&_ZN7S2214C34v100Ev,
  (VTBL_ENTRY)&_ZN7S2214C34v101Ev,
  (VTBL_ENTRY)&_ZN7S2214C34v102Ev,
  (VTBL_ENTRY)&_ZN7S2214C34v103Ev,
  (VTBL_ENTRY)&_ZN10S2214C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S2214C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S2214C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S2214C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S2214C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S2214C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S2214C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S2214C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S2214C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S2214C2_nt4v113Ev,
};
extern VTBL_ENTRY _ZTI10S2214C2_nt[];
VTBL_ENTRY *P__ZTI10S2214C2_nt = _ZTI10S2214C2_nt; 
extern  VTBL_ENTRY _ZTV10S2214C2_nt[];
Class_Descriptor cd_S2214C2_nt = {  "S2214C2_nt", // class name
  bases_S2214C2_nt, 2,
  &(vtc_S2214C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(840,636), // object size
  NSPAIRA(_ZTI10S2214C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S2214C2_nt),115, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2214C39_nt  {
  void *s2214c39f0;
  void  mf2214c39(); // _ZN11S2214C39_nt9mf2214c39Ev
};
//SIG(-1 S2214C39_nt) C1{ m Fp}


void  S2214C39_nt ::mf2214c39(){}

//skip512 S2214C39_nt

#else // __cplusplus

Class_Descriptor cd_S2214C39_nt = {  "S2214C39_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(8,4), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2214C1  : S2214C2_nt {
  void *s2214c1f0;
  ::S2214C39_nt s2214c1f1;
  virtual  ~S2214C1(); // _ZN7S2214C1D1Ev
  virtual void  v1(); // _ZN7S2214C12v1Ev
  virtual void  v2(); // _ZN7S2214C12v2Ev
  S2214C1(); // tgen
};
//SIG(1 S2214C1) C1{ BC2{ BC3{ BC4{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 Fp Fi FC5{ BC6{ m Fp Fi FC7{ m} FC8{ m}}} FC9{ BC10{ m Fp Fi FC11{ m} FC11}} Fi} vd v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 FC12{ m FC13{ m FL[2]}} FC12 FC12 FC14{ m FC13} FC15{ m FC12} FC16{ m FC12 FC12 FC12 FC12} FC16 FC12 FC12 FC12 Fp FC15 FC17{ m FC18{ m Fp Fi FC19{ m}} Fi} Fi Fp[7] FC6 Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC20{ BC21{ m Fp Fi FC19 FC7}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC22{ m Fp Fi[2] FC23{ m}} Fp[2] Fi:16 Fi:16 FC20 FC24{ m Fp Fi[2] FC8} FC25{ m Fp Fi[2] FC23} Fp[2] Fi:24 Fi:8 Fp} vd v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 Fp} vd v1 v2 Fp FC26{ m Fp}}


 S2214C1 ::~S2214C1(){ note_dtor("S2214C1", this);}
void  S2214C1 ::v1(){vfunc_called(this, "_ZN7S2214C12v1Ev");}
void  S2214C1 ::v2(){vfunc_called(this, "_ZN7S2214C12v2Ev");}
S2214C1 ::S2214C1(){ note_ctor("S2214C1", this);} // tgen

static void Test_S2214C1()
{
  extern Class_Descriptor cd_S2214C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(108,162)];
    init_test(&cd_S2214C1, buf);
    S2214C1 *dp, &lv = *(dp=new (buf) S2214C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(856,644), "sizeof(S2214C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2214C1)");
    check_base_class_offset(lv, (S2214C4*)(S2214C3*)(S2214C2_nt*), 0, "S2214C1");
    check_base_class_offset(lv, (S2214C3*)(S2214C2_nt*), 0, "S2214C1");
    check_base_class_offset(lv, (S2214C2_nt*), 0, "S2214C1");
    check_field_offset(lv, s2214c1f0, ABISELECT(840,636), "S2214C1.s2214c1f0");
    check_field_offset(lv, s2214c1f1, ABISELECT(848,640), "S2214C1.s2214c1f1");
    test_class_info(&lv, &cd_S2214C1);
    dp->~S2214C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2214C1(Test_S2214C1, "S2214C1", ABISELECT(856,644));

#else // __cplusplus

extern void _ZN7S2214C1C1Ev();
extern void _ZN7S2214C1D1Ev();
Name_Map name_map_S2214C1[] = {
  NSPAIR(_ZN7S2214C1C1Ev),
  NSPAIR(_ZN7S2214C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2214C4;
extern VTBL_ENTRY _ZTI7S2214C4[];
extern  VTBL_ENTRY _ZTV7S2214C4[];
extern Class_Descriptor cd_S2214C3;
extern VTBL_ENTRY _ZTI7S2214C3[];
extern  VTBL_ENTRY _ZTV7S2214C3[];
extern Class_Descriptor cd_S2214C2_nt;
extern VTBL_ENTRY _ZTI10S2214C2_nt[];
extern  VTBL_ENTRY _ZTV10S2214C2_nt[];
static Base_Class bases_S2214C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2214C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2214C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2214C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2214C1[];
extern void _ZN7S2214C1D1Ev();
extern void _ZN7S2214C1D0Ev();
extern void _ZN7S2214C42v3Ev();
extern void _ZN7S2214C42v4Ev();
extern void _ZN7S2214C42v5Ev();
extern void _ZN7S2214C42v6Ev();
extern void _ZN7S2214C42v7Ev();
extern void _ZN7S2214C42v8Ev();
extern void _ZN7S2214C42v9Ev();
extern void _ZN7S2214C43v10Ev();
extern void _ZN7S2214C43v11Ev();
extern void _ZN7S2214C43v12Ev();
extern void _ZN7S2214C43v13Ev();
extern void _ZN7S2214C43v14Ev();
extern void _ZN7S2214C43v15Ev();
extern void _ZN7S2214C43v16Ev();
extern void _ZN7S2214C43v17Ev();
extern void _ZN7S2214C43v18Ev();
extern void _ZN7S2214C43v19Ev();
extern void _ZN7S2214C43v20Ev();
extern void _ZN7S2214C43v21Ev();
extern void _ZN7S2214C43v22Ev();
extern void _ZN7S2214C43v23Ev();
extern void _ZN7S2214C43v24Ev();
extern void _ZN7S2214C43v25Ev();
extern void _ZN7S2214C33v26Ev();
extern void _ZN7S2214C33v27Ev();
extern void _ZN7S2214C33v28Ev();
extern void _ZN7S2214C33v29Ev();
extern void _ZN7S2214C33v30Ev();
extern void _ZN7S2214C33v31Ev();
extern void _ZN7S2214C33v32Ev();
extern void _ZN7S2214C33v33Ev();
extern void _ZN7S2214C33v34Ev();
extern void _ZN7S2214C33v35Ev();
extern void _ZN7S2214C33v36Ev();
extern void _ZN7S2214C33v37Ev();
extern void _ZN7S2214C33v38Ev();
extern void _ZN7S2214C33v39Ev();
extern void _ZN7S2214C33v40Ev();
extern void _ZN7S2214C33v41Ev();
extern void _ZN7S2214C33v42Ev();
extern void _ZN7S2214C33v43Ev();
extern void _ZN7S2214C33v44Ev();
extern void _ZN7S2214C33v45Ev();
extern void _ZN7S2214C33v46Ev();
extern void _ZN7S2214C33v47Ev();
extern void _ZN7S2214C33v48Ev();
extern void _ZN7S2214C33v49Ev();
extern void _ZN7S2214C33v50Ev();
extern void _ZN7S2214C33v51Ev();
extern void _ZN7S2214C33v52Ev();
extern void _ZN7S2214C33v53Ev();
extern void _ZN7S2214C33v54Ev();
extern void _ZN7S2214C33v55Ev();
extern void _ZN7S2214C33v56Ev();
extern void _ZN7S2214C33v57Ev();
extern void _ZN7S2214C33v58Ev();
extern void _ZN7S2214C33v59Ev();
extern void _ZN7S2214C33v60Ev();
extern void _ZN7S2214C33v61Ev();
extern void _ZN7S2214C33v62Ev();
extern void _ZN7S2214C33v63Ev();
extern void _ZN7S2214C33v64Ev();
extern void _ZN7S2214C33v65Ev();
extern void _ZN7S2214C33v66Ev();
extern void _ZN7S2214C33v67Ev();
extern void _ZN7S2214C33v68Ev();
extern void _ZN7S2214C33v69Ev();
extern void _ZN7S2214C33v70Ev();
extern void _ZN7S2214C33v71Ev();
extern void _ZN7S2214C33v72Ev();
extern void _ZN7S2214C33v73Ev();
extern void _ZN7S2214C33v74Ev();
extern void _ZN7S2214C33v75Ev();
extern void _ZN7S2214C33v76Ev();
extern void _ZN7S2214C33v77Ev();
extern void _ZN7S2214C33v78Ev();
extern void _ZN7S2214C33v79Ev();
extern void _ZN7S2214C33v80Ev();
extern void _ZN7S2214C33v81Ev();
extern void _ZN7S2214C33v82Ev();
extern void _ZN7S2214C33v83Ev();
extern void _ZN7S2214C33v84Ev();
extern void _ZN7S2214C33v85Ev();
extern void _ZN7S2214C33v86Ev();
extern void _ZN7S2214C33v87Ev();
extern void _ZN7S2214C33v88Ev();
extern void _ZN7S2214C33v89Ev();
extern void _ZN7S2214C33v90Ev();
extern void _ZN7S2214C33v91Ev();
extern void _ZN7S2214C33v92Ev();
extern void _ZN7S2214C33v93Ev();
extern void _ZN7S2214C33v94Ev();
extern void _ZN7S2214C33v95Ev();
extern void _ZN7S2214C33v96Ev();
extern void _ZN7S2214C33v97Ev();
extern void _ZN7S2214C33v98Ev();
extern void _ZN7S2214C33v99Ev();
extern void _ZN7S2214C34v100Ev();
extern void _ZN7S2214C34v101Ev();
extern void _ZN7S2214C34v102Ev();
extern void _ZN7S2214C34v103Ev();
extern void _ZN10S2214C2_nt4v104Ev();
extern void _ZN10S2214C2_nt4v105Ev();
extern void _ZN10S2214C2_nt4v106Ev();
extern void _ZN10S2214C2_nt4v107Ev();
extern void _ZN10S2214C2_nt4v108Ev();
extern void _ZN10S2214C2_nt4v109Ev();
extern void _ZN10S2214C2_nt4v110Ev();
extern void _ZN10S2214C2_nt4v111Ev();
extern void _ZN10S2214C2_nt4v112Ev();
extern void _ZN10S2214C2_nt4v113Ev();
extern void _ZN7S2214C12v1Ev();
extern void _ZN7S2214C12v2Ev();
static  VTBL_ENTRY vtc_S2214C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2214C1[0]),
  (VTBL_ENTRY)&_ZN7S2214C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2214C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2214C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2214C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2214C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2214C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2214C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2214C42v8Ev,
  (VTBL_ENTRY)&_ZN7S2214C42v9Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v14Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v15Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v16Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v17Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v18Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v19Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v20Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v21Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v22Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v23Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v24Ev,
  (VTBL_ENTRY)&_ZN7S2214C43v25Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v26Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v27Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v28Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v29Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v30Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v31Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v32Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v33Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v34Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v35Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v36Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v37Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v38Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v39Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v40Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v41Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v42Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v43Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v44Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v45Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v46Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v47Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v48Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v49Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v50Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v51Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v52Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v53Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v54Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v55Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v56Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v57Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v58Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v59Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v60Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v61Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v62Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v63Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v64Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v65Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v66Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v67Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v68Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v69Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v70Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v71Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v72Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v73Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v74Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v75Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v76Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v77Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v78Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v79Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v80Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v81Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v82Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v83Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v84Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v85Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v86Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v87Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v88Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v89Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v90Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v91Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v92Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v93Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v94Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v95Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v96Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v97Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v98Ev,
  (VTBL_ENTRY)&_ZN7S2214C33v99Ev,
  (VTBL_ENTRY)&_ZN7S2214C34v100Ev,
  (VTBL_ENTRY)&_ZN7S2214C34v101Ev,
  (VTBL_ENTRY)&_ZN7S2214C34v102Ev,
  (VTBL_ENTRY)&_ZN7S2214C34v103Ev,
  (VTBL_ENTRY)&_ZN10S2214C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S2214C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S2214C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S2214C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S2214C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S2214C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S2214C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S2214C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S2214C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S2214C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN7S2214C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2214C12v2Ev,
};
extern VTBL_ENTRY _ZTI7S2214C1[];
extern  VTBL_ENTRY _ZTV7S2214C1[];
Class_Descriptor cd_S2214C1 = {  "S2214C1", // class name
  bases_S2214C1, 3,
  &(vtc_S2214C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(856,644), // object size
  NSPAIRA(_ZTI7S2214C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2214C1),117, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S235C7_nt  {
  int s235c7f0[2];
  void  mf235c7(); // _ZN9S235C7_nt7mf235c7Ev
};
//SIG(-1 S235C7_nt) C1{ m Fi[2]}


void  S235C7_nt ::mf235c7(){}

//skip512 S235C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S235C6_nt  {
  int s235c6f0;
  __tsi64 s235c6f1;
  void *s235c6f2[4];
  int s235c6f3[2];
  void *s235c6f4;
  ::S235C7_nt s235c6f5;
  void *s235c6f6[2];
  virtual  ~S235C6_nt(); // _ZN9S235C6_ntD1Ev
  virtual void  v5(); // _ZN9S235C6_nt2v5Ev
  virtual void  v6(); // _ZN9S235C6_nt2v6Ev
  virtual void  v7(); // _ZN9S235C6_nt2v7Ev
  virtual void  v8(); // _ZN9S235C6_nt2v8Ev
  virtual void  v9(); // _ZN9S235C6_nt2v9Ev
  virtual void  v10(); // _ZN9S235C6_nt3v10Ev
  virtual void  v11(); // _ZN9S235C6_nt3v11Ev
  virtual void  v12(); // _ZN9S235C6_nt3v12Ev
  virtual void  v13(); // _ZN9S235C6_nt3v13Ev
  virtual void  v14(); // _ZN9S235C6_nt3v14Ev
  virtual void  v15(); // _ZN9S235C6_nt3v15Ev
  virtual void  v16(); // _ZN9S235C6_nt3v16Ev
  virtual void  v17(); // _ZN9S235C6_nt3v17Ev
  virtual void  v18(); // _ZN9S235C6_nt3v18Ev
  virtual void  v19(); // _ZN9S235C6_nt3v19Ev
  virtual void  v20(); // _ZN9S235C6_nt3v20Ev
  virtual void  v21(); // _ZN9S235C6_nt3v21Ev
  virtual void  v22(); // _ZN9S235C6_nt3v22Ev
  virtual void  v23(); // _ZN9S235C6_nt3v23Ev
  virtual void  v24(); // _ZN9S235C6_nt3v24Ev
  virtual void  v25(); // _ZN9S235C6_nt3v25Ev
  virtual void  v26(); // _ZN9S235C6_nt3v26Ev
  virtual void  v27(); // _ZN9S235C6_nt3v27Ev
  virtual void  v28(); // _ZN9S235C6_nt3v28Ev
  virtual void  v29(); // _ZN9S235C6_nt3v29Ev
  virtual void  v30(); // _ZN9S235C6_nt3v30Ev
  virtual void  v31(); // _ZN9S235C6_nt3v31Ev
  virtual void  v32(); // _ZN9S235C6_nt3v32Ev
  virtual void  v33(); // _ZN9S235C6_nt3v33Ev
  virtual void  v34(); // _ZN9S235C6_nt3v34Ev
  virtual void  v35(); // _ZN9S235C6_nt3v35Ev
  virtual void  v36(); // _ZN9S235C6_nt3v36Ev
  virtual void  v37(); // _ZN9S235C6_nt3v37Ev
  virtual void  v38(); // _ZN9S235C6_nt3v38Ev
  virtual void  v39(); // _ZN9S235C6_nt3v39Ev
  virtual void  v40(); // _ZN9S235C6_nt3v40Ev
  virtual void  v41(); // _ZN9S235C6_nt3v41Ev
  virtual void  v42(); // _ZN9S235C6_nt3v42Ev
  virtual void  v43(); // _ZN9S235C6_nt3v43Ev
  virtual void  v44(); // _ZN9S235C6_nt3v44Ev
  virtual void  v45(); // _ZN9S235C6_nt3v45Ev
  virtual void  v46(); // _ZN9S235C6_nt3v46Ev
  virtual void  v47(); // _ZN9S235C6_nt3v47Ev
  virtual void  v48(); // _ZN9S235C6_nt3v48Ev
  virtual void  v49(); // _ZN9S235C6_nt3v49Ev
  virtual void  v50(); // _ZN9S235C6_nt3v50Ev
  virtual void  v51(); // _ZN9S235C6_nt3v51Ev
  virtual void  v52(); // _ZN9S235C6_nt3v52Ev
  virtual void  v53(); // _ZN9S235C6_nt3v53Ev
  virtual void  v54(); // _ZN9S235C6_nt3v54Ev
  virtual void  v55(); // _ZN9S235C6_nt3v55Ev
  virtual void  v56(); // _ZN9S235C6_nt3v56Ev
  virtual void  v57(); // _ZN9S235C6_nt3v57Ev
  virtual void  v58(); // _ZN9S235C6_nt3v58Ev
  virtual void  v59(); // _ZN9S235C6_nt3v59Ev
  virtual void  v60(); // _ZN9S235C6_nt3v60Ev
  virtual void  v61(); // _ZN9S235C6_nt3v61Ev
  virtual void  v62(); // _ZN9S235C6_nt3v62Ev
  virtual void  v63(); // _ZN9S235C6_nt3v63Ev
  virtual void  v64(); // _ZN9S235C6_nt3v64Ev
  virtual void  v65(); // _ZN9S235C6_nt3v65Ev
  virtual void  v66(); // _ZN9S235C6_nt3v66Ev
  virtual void  v67(); // _ZN9S235C6_nt3v67Ev
  virtual void  v68(); // _ZN9S235C6_nt3v68Ev
  S235C6_nt(); // tgen
};
//SIG(-1 S235C6_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S235C6_nt ::~S235C6_nt(){ note_dtor("S235C6_nt", this);}
void  S235C6_nt ::v5(){vfunc_called(this, "_ZN9S235C6_nt2v5Ev");}
void  S235C6_nt ::v6(){vfunc_called(this, "_ZN9S235C6_nt2v6Ev");}
void  S235C6_nt ::v7(){vfunc_called(this, "_ZN9S235C6_nt2v7Ev");}
void  S235C6_nt ::v8(){vfunc_called(this, "_ZN9S235C6_nt2v8Ev");}
void  S235C6_nt ::v9(){vfunc_called(this, "_ZN9S235C6_nt2v9Ev");}
void  S235C6_nt ::v10(){vfunc_called(this, "_ZN9S235C6_nt3v10Ev");}
void  S235C6_nt ::v11(){vfunc_called(this, "_ZN9S235C6_nt3v11Ev");}
void  S235C6_nt ::v12(){vfunc_called(this, "_ZN9S235C6_nt3v12Ev");}
void  S235C6_nt ::v13(){vfunc_called(this, "_ZN9S235C6_nt3v13Ev");}
void  S235C6_nt ::v14(){vfunc_called(this, "_ZN9S235C6_nt3v14Ev");}
void  S235C6_nt ::v15(){vfunc_called(this, "_ZN9S235C6_nt3v15Ev");}
void  S235C6_nt ::v16(){vfunc_called(this, "_ZN9S235C6_nt3v16Ev");}
void  S235C6_nt ::v17(){vfunc_called(this, "_ZN9S235C6_nt3v17Ev");}
void  S235C6_nt ::v18(){vfunc_called(this, "_ZN9S235C6_nt3v18Ev");}
void  S235C6_nt ::v19(){vfunc_called(this, "_ZN9S235C6_nt3v19Ev");}
void  S235C6_nt ::v20(){vfunc_called(this, "_ZN9S235C6_nt3v20Ev");}
void  S235C6_nt ::v21(){vfunc_called(this, "_ZN9S235C6_nt3v21Ev");}
void  S235C6_nt ::v22(){vfunc_called(this, "_ZN9S235C6_nt3v22Ev");}
void  S235C6_nt ::v23(){vfunc_called(this, "_ZN9S235C6_nt3v23Ev");}
void  S235C6_nt ::v24(){vfunc_called(this, "_ZN9S235C6_nt3v24Ev");}
void  S235C6_nt ::v25(){vfunc_called(this, "_ZN9S235C6_nt3v25Ev");}
void  S235C6_nt ::v26(){vfunc_called(this, "_ZN9S235C6_nt3v26Ev");}
void  S235C6_nt ::v27(){vfunc_called(this, "_ZN9S235C6_nt3v27Ev");}
void  S235C6_nt ::v28(){vfunc_called(this, "_ZN9S235C6_nt3v28Ev");}
void  S235C6_nt ::v29(){vfunc_called(this, "_ZN9S235C6_nt3v29Ev");}
void  S235C6_nt ::v30(){vfunc_called(this, "_ZN9S235C6_nt3v30Ev");}
void  S235C6_nt ::v31(){vfunc_called(this, "_ZN9S235C6_nt3v31Ev");}
void  S235C6_nt ::v32(){vfunc_called(this, "_ZN9S235C6_nt3v32Ev");}
void  S235C6_nt ::v33(){vfunc_called(this, "_ZN9S235C6_nt3v33Ev");}
void  S235C6_nt ::v34(){vfunc_called(this, "_ZN9S235C6_nt3v34Ev");}
void  S235C6_nt ::v35(){vfunc_called(this, "_ZN9S235C6_nt3v35Ev");}
void  S235C6_nt ::v36(){vfunc_called(this, "_ZN9S235C6_nt3v36Ev");}
void  S235C6_nt ::v37(){vfunc_called(this, "_ZN9S235C6_nt3v37Ev");}
void  S235C6_nt ::v38(){vfunc_called(this, "_ZN9S235C6_nt3v38Ev");}
void  S235C6_nt ::v39(){vfunc_called(this, "_ZN9S235C6_nt3v39Ev");}
void  S235C6_nt ::v40(){vfunc_called(this, "_ZN9S235C6_nt3v40Ev");}
void  S235C6_nt ::v41(){vfunc_called(this, "_ZN9S235C6_nt3v41Ev");}
void  S235C6_nt ::v42(){vfunc_called(this, "_ZN9S235C6_nt3v42Ev");}
void  S235C6_nt ::v43(){vfunc_called(this, "_ZN9S235C6_nt3v43Ev");}
void  S235C6_nt ::v44(){vfunc_called(this, "_ZN9S235C6_nt3v44Ev");}
void  S235C6_nt ::v45(){vfunc_called(this, "_ZN9S235C6_nt3v45Ev");}
void  S235C6_nt ::v46(){vfunc_called(this, "_ZN9S235C6_nt3v46Ev");}
void  S235C6_nt ::v47(){vfunc_called(this, "_ZN9S235C6_nt3v47Ev");}
void  S235C6_nt ::v48(){vfunc_called(this, "_ZN9S235C6_nt3v48Ev");}
void  S235C6_nt ::v49(){vfunc_called(this, "_ZN9S235C6_nt3v49Ev");}
void  S235C6_nt ::v50(){vfunc_called(this, "_ZN9S235C6_nt3v50Ev");}
void  S235C6_nt ::v51(){vfunc_called(this, "_ZN9S235C6_nt3v51Ev");}
void  S235C6_nt ::v52(){vfunc_called(this, "_ZN9S235C6_nt3v52Ev");}
void  S235C6_nt ::v53(){vfunc_called(this, "_ZN9S235C6_nt3v53Ev");}
void  S235C6_nt ::v54(){vfunc_called(this, "_ZN9S235C6_nt3v54Ev");}
void  S235C6_nt ::v55(){vfunc_called(this, "_ZN9S235C6_nt3v55Ev");}
void  S235C6_nt ::v56(){vfunc_called(this, "_ZN9S235C6_nt3v56Ev");}
void  S235C6_nt ::v57(){vfunc_called(this, "_ZN9S235C6_nt3v57Ev");}
void  S235C6_nt ::v58(){vfunc_called(this, "_ZN9S235C6_nt3v58Ev");}
void  S235C6_nt ::v59(){vfunc_called(this, "_ZN9S235C6_nt3v59Ev");}
void  S235C6_nt ::v60(){vfunc_called(this, "_ZN9S235C6_nt3v60Ev");}
void  S235C6_nt ::v61(){vfunc_called(this, "_ZN9S235C6_nt3v61Ev");}
void  S235C6_nt ::v62(){vfunc_called(this, "_ZN9S235C6_nt3v62Ev");}
void  S235C6_nt ::v63(){vfunc_called(this, "_ZN9S235C6_nt3v63Ev");}
void  S235C6_nt ::v64(){vfunc_called(this, "_ZN9S235C6_nt3v64Ev");}
void  S235C6_nt ::v65(){vfunc_called(this, "_ZN9S235C6_nt3v65Ev");}
void  S235C6_nt ::v66(){vfunc_called(this, "_ZN9S235C6_nt3v66Ev");}
void  S235C6_nt ::v67(){vfunc_called(this, "_ZN9S235C6_nt3v67Ev");}
void  S235C6_nt ::v68(){vfunc_called(this, "_ZN9S235C6_nt3v68Ev");}
S235C6_nt ::S235C6_nt(){ note_ctor("S235C6_nt", this);} // tgen

//skip512 S235C6_nt

#else // __cplusplus

extern void _ZN9S235C6_ntC1Ev();
extern void _ZN9S235C6_ntD1Ev();
Name_Map name_map_S235C6_nt[] = {
  NSPAIR(_ZN9S235C6_ntC1Ev),
  NSPAIR(_ZN9S235C6_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S235C6_nt[];
extern void _ZN9S235C6_ntD1Ev();
extern void _ZN9S235C6_ntD0Ev();
extern void _ZN9S235C6_nt2v5Ev();
extern void _ZN9S235C6_nt2v6Ev();
extern void _ZN9S235C6_nt2v7Ev();
extern void _ZN9S235C6_nt2v8Ev();
extern void _ZN9S235C6_nt2v9Ev();
extern void _ZN9S235C6_nt3v10Ev();
extern void _ZN9S235C6_nt3v11Ev();
extern void _ZN9S235C6_nt3v12Ev();
extern void _ZN9S235C6_nt3v13Ev();
extern void _ZN9S235C6_nt3v14Ev();
extern void _ZN9S235C6_nt3v15Ev();
extern void _ZN9S235C6_nt3v16Ev();
extern void _ZN9S235C6_nt3v17Ev();
extern void _ZN9S235C6_nt3v18Ev();
extern void _ZN9S235C6_nt3v19Ev();
extern void _ZN9S235C6_nt3v20Ev();
extern void _ZN9S235C6_nt3v21Ev();
extern void _ZN9S235C6_nt3v22Ev();
extern void _ZN9S235C6_nt3v23Ev();
extern void _ZN9S235C6_nt3v24Ev();
extern void _ZN9S235C6_nt3v25Ev();
extern void _ZN9S235C6_nt3v26Ev();
extern void _ZN9S235C6_nt3v27Ev();
extern void _ZN9S235C6_nt3v28Ev();
extern void _ZN9S235C6_nt3v29Ev();
extern void _ZN9S235C6_nt3v30Ev();
extern void _ZN9S235C6_nt3v31Ev();
extern void _ZN9S235C6_nt3v32Ev();
extern void _ZN9S235C6_nt3v33Ev();
extern void _ZN9S235C6_nt3v34Ev();
extern void _ZN9S235C6_nt3v35Ev();
extern void _ZN9S235C6_nt3v36Ev();
extern void _ZN9S235C6_nt3v37Ev();
extern void _ZN9S235C6_nt3v38Ev();
extern void _ZN9S235C6_nt3v39Ev();
extern void _ZN9S235C6_nt3v40Ev();
extern void _ZN9S235C6_nt3v41Ev();
extern void _ZN9S235C6_nt3v42Ev();
extern void _ZN9S235C6_nt3v43Ev();
extern void _ZN9S235C6_nt3v44Ev();
extern void _ZN9S235C6_nt3v45Ev();
extern void _ZN9S235C6_nt3v46Ev();
extern void _ZN9S235C6_nt3v47Ev();
extern void _ZN9S235C6_nt3v48Ev();
extern void _ZN9S235C6_nt3v49Ev();
extern void _ZN9S235C6_nt3v50Ev();
extern void _ZN9S235C6_nt3v51Ev();
extern void _ZN9S235C6_nt3v52Ev();
extern void _ZN9S235C6_nt3v53Ev();
extern void _ZN9S235C6_nt3v54Ev();
extern void _ZN9S235C6_nt3v55Ev();
extern void _ZN9S235C6_nt3v56Ev();
extern void _ZN9S235C6_nt3v57Ev();
extern void _ZN9S235C6_nt3v58Ev();
extern void _ZN9S235C6_nt3v59Ev();
extern void _ZN9S235C6_nt3v60Ev();
extern void _ZN9S235C6_nt3v61Ev();
extern void _ZN9S235C6_nt3v62Ev();
extern void _ZN9S235C6_nt3v63Ev();
extern void _ZN9S235C6_nt3v64Ev();
extern void _ZN9S235C6_nt3v65Ev();
extern void _ZN9S235C6_nt3v66Ev();
extern void _ZN9S235C6_nt3v67Ev();
extern void _ZN9S235C6_nt3v68Ev();
static  VTBL_ENTRY vtc_S235C6_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S235C6_nt[0]),
  (VTBL_ENTRY)&_ZN9S235C6_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S235C6_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v68Ev,
};
extern VTBL_ENTRY _ZTI9S235C6_nt[];
VTBL_ENTRY *P__ZTI9S235C6_nt = _ZTI9S235C6_nt; 
extern  VTBL_ENTRY _ZTV9S235C6_nt[];
Class_Descriptor cd_S235C6_nt = {  "S235C6_nt", // class name
  0,0,//no base classes
  &(vtc_S235C6_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI9S235C6_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S235C6_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S235C5_nt  : S235C6_nt {
  void *s235c5f0;
  ::S235C7_nt s235c5f1;
  virtual  ~S235C5_nt(); // _ZN9S235C5_ntD1Ev
  virtual void  v69(); // _ZN9S235C5_nt3v69Ev
  virtual void  v70(); // _ZN9S235C5_nt3v70Ev
  virtual void  v71(); // _ZN9S235C5_nt3v71Ev
  virtual void  v72(); // _ZN9S235C5_nt3v72Ev
  virtual void  v73(); // _ZN9S235C5_nt3v73Ev
  S235C5_nt(); // tgen
};
//SIG(-1 S235C5_nt) C1{ BC2{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 Fp FC3}


 S235C5_nt ::~S235C5_nt(){ note_dtor("S235C5_nt", this);}
void  S235C5_nt ::v69(){vfunc_called(this, "_ZN9S235C5_nt3v69Ev");}
void  S235C5_nt ::v70(){vfunc_called(this, "_ZN9S235C5_nt3v70Ev");}
void  S235C5_nt ::v71(){vfunc_called(this, "_ZN9S235C5_nt3v71Ev");}
void  S235C5_nt ::v72(){vfunc_called(this, "_ZN9S235C5_nt3v72Ev");}
void  S235C5_nt ::v73(){vfunc_called(this, "_ZN9S235C5_nt3v73Ev");}
S235C5_nt ::S235C5_nt(){ note_ctor("S235C5_nt", this);} // tgen

//skip512 S235C5_nt

#else // __cplusplus

extern void _ZN9S235C5_ntC1Ev();
extern void _ZN9S235C5_ntD1Ev();
Name_Map name_map_S235C5_nt[] = {
  NSPAIR(_ZN9S235C5_ntC1Ev),
  NSPAIR(_ZN9S235C5_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S235C6_nt;
extern VTBL_ENTRY _ZTI9S235C6_nt[];
extern  VTBL_ENTRY _ZTV9S235C6_nt[];
static Base_Class bases_S235C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S235C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S235C5_nt[];
extern void _ZN9S235C5_ntD1Ev();
extern void _ZN9S235C5_ntD0Ev();
extern void _ZN9S235C6_nt2v5Ev();
extern void _ZN9S235C6_nt2v6Ev();
extern void _ZN9S235C6_nt2v7Ev();
extern void _ZN9S235C6_nt2v8Ev();
extern void _ZN9S235C6_nt2v9Ev();
extern void _ZN9S235C6_nt3v10Ev();
extern void _ZN9S235C6_nt3v11Ev();
extern void _ZN9S235C6_nt3v12Ev();
extern void _ZN9S235C6_nt3v13Ev();
extern void _ZN9S235C6_nt3v14Ev();
extern void _ZN9S235C6_nt3v15Ev();
extern void _ZN9S235C6_nt3v16Ev();
extern void _ZN9S235C6_nt3v17Ev();
extern void _ZN9S235C6_nt3v18Ev();
extern void _ZN9S235C6_nt3v19Ev();
extern void _ZN9S235C6_nt3v20Ev();
extern void _ZN9S235C6_nt3v21Ev();
extern void _ZN9S235C6_nt3v22Ev();
extern void _ZN9S235C6_nt3v23Ev();
extern void _ZN9S235C6_nt3v24Ev();
extern void _ZN9S235C6_nt3v25Ev();
extern void _ZN9S235C6_nt3v26Ev();
extern void _ZN9S235C6_nt3v27Ev();
extern void _ZN9S235C6_nt3v28Ev();
extern void _ZN9S235C6_nt3v29Ev();
extern void _ZN9S235C6_nt3v30Ev();
extern void _ZN9S235C6_nt3v31Ev();
extern void _ZN9S235C6_nt3v32Ev();
extern void _ZN9S235C6_nt3v33Ev();
extern void _ZN9S235C6_nt3v34Ev();
extern void _ZN9S235C6_nt3v35Ev();
extern void _ZN9S235C6_nt3v36Ev();
extern void _ZN9S235C6_nt3v37Ev();
extern void _ZN9S235C6_nt3v38Ev();
extern void _ZN9S235C6_nt3v39Ev();
extern void _ZN9S235C6_nt3v40Ev();
extern void _ZN9S235C6_nt3v41Ev();
extern void _ZN9S235C6_nt3v42Ev();
extern void _ZN9S235C6_nt3v43Ev();
extern void _ZN9S235C6_nt3v44Ev();
extern void _ZN9S235C6_nt3v45Ev();
extern void _ZN9S235C6_nt3v46Ev();
extern void _ZN9S235C6_nt3v47Ev();
extern void _ZN9S235C6_nt3v48Ev();
extern void _ZN9S235C6_nt3v49Ev();
extern void _ZN9S235C6_nt3v50Ev();
extern void _ZN9S235C6_nt3v51Ev();
extern void _ZN9S235C6_nt3v52Ev();
extern void _ZN9S235C6_nt3v53Ev();
extern void _ZN9S235C6_nt3v54Ev();
extern void _ZN9S235C6_nt3v55Ev();
extern void _ZN9S235C6_nt3v56Ev();
extern void _ZN9S235C6_nt3v57Ev();
extern void _ZN9S235C6_nt3v58Ev();
extern void _ZN9S235C6_nt3v59Ev();
extern void _ZN9S235C6_nt3v60Ev();
extern void _ZN9S235C6_nt3v61Ev();
extern void _ZN9S235C6_nt3v62Ev();
extern void _ZN9S235C6_nt3v63Ev();
extern void _ZN9S235C6_nt3v64Ev();
extern void _ZN9S235C6_nt3v65Ev();
extern void _ZN9S235C6_nt3v66Ev();
extern void _ZN9S235C6_nt3v67Ev();
extern void _ZN9S235C6_nt3v68Ev();
extern void _ZN9S235C5_nt3v69Ev();
extern void _ZN9S235C5_nt3v70Ev();
extern void _ZN9S235C5_nt3v71Ev();
extern void _ZN9S235C5_nt3v72Ev();
extern void _ZN9S235C5_nt3v73Ev();
static  VTBL_ENTRY vtc_S235C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S235C5_nt[0]),
  (VTBL_ENTRY)&_ZN9S235C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S235C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S235C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S235C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S235C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S235C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S235C5_nt3v73Ev,
};
extern VTBL_ENTRY _ZTI9S235C5_nt[];
VTBL_ENTRY *P__ZTI9S235C5_nt = _ZTI9S235C5_nt; 
extern  VTBL_ENTRY _ZTV9S235C5_nt[];
Class_Descriptor cd_S235C5_nt = {  "S235C5_nt", // class name
  bases_S235C5_nt, 1,
  &(vtc_S235C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,72), // object size
  NSPAIRA(_ZTI9S235C5_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S235C5_nt),73, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S235C4_nt  : S235C5_nt {
  void *s235c4f0[2];
  unsigned int s235c4f1:1;
  unsigned int s235c4f2:1;
  unsigned int s235c4f3:1;
  unsigned int s235c4f4:1;
  char s235c4f5;
  virtual  ~S235C4_nt(); // _ZN9S235C4_ntD1Ev
  virtual void  v74(); // _ZN9S235C4_nt3v74Ev
  virtual void  v75(); // _ZN9S235C4_nt3v75Ev
  virtual void  v76(); // _ZN9S235C4_nt3v76Ev
  virtual void  v77(); // _ZN9S235C4_nt3v77Ev
  virtual void  v78(); // _ZN9S235C4_nt3v78Ev
  virtual void  v79(); // _ZN9S235C4_nt3v79Ev
  virtual void  v80(); // _ZN9S235C4_nt3v80Ev
  virtual void  v81(); // _ZN9S235C4_nt3v81Ev
  virtual void  v82(); // _ZN9S235C4_nt3v82Ev
  virtual void  v83(); // _ZN9S235C4_nt3v83Ev
  virtual void  v84(); // _ZN9S235C4_nt3v84Ev
  virtual void  v85(); // _ZN9S235C4_nt3v85Ev
  virtual void  v86(); // _ZN9S235C4_nt3v86Ev
  virtual void  v87(); // _ZN9S235C4_nt3v87Ev
  virtual void  v88(); // _ZN9S235C4_nt3v88Ev
  virtual void  v89(); // _ZN9S235C4_nt3v89Ev
  virtual void  v90(); // _ZN9S235C4_nt3v90Ev
  virtual void  v91(); // _ZN9S235C4_nt3v91Ev
  virtual void  v92(); // _ZN9S235C4_nt3v92Ev
  virtual void  v93(); // _ZN9S235C4_nt3v93Ev
  virtual void  v94(); // _ZN9S235C4_nt3v94Ev
  virtual void  v95(); // _ZN9S235C4_nt3v95Ev
  S235C4_nt(); // tgen
};
//SIG(-1 S235C4_nt) C1{ BC2{ BC3{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v87 v88 v89 v90 v91 Fp FC4} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc}


 S235C4_nt ::~S235C4_nt(){ note_dtor("S235C4_nt", this);}
void  S235C4_nt ::v74(){vfunc_called(this, "_ZN9S235C4_nt3v74Ev");}
void  S235C4_nt ::v75(){vfunc_called(this, "_ZN9S235C4_nt3v75Ev");}
void  S235C4_nt ::v76(){vfunc_called(this, "_ZN9S235C4_nt3v76Ev");}
void  S235C4_nt ::v77(){vfunc_called(this, "_ZN9S235C4_nt3v77Ev");}
void  S235C4_nt ::v78(){vfunc_called(this, "_ZN9S235C4_nt3v78Ev");}
void  S235C4_nt ::v79(){vfunc_called(this, "_ZN9S235C4_nt3v79Ev");}
void  S235C4_nt ::v80(){vfunc_called(this, "_ZN9S235C4_nt3v80Ev");}
void  S235C4_nt ::v81(){vfunc_called(this, "_ZN9S235C4_nt3v81Ev");}
void  S235C4_nt ::v82(){vfunc_called(this, "_ZN9S235C4_nt3v82Ev");}
void  S235C4_nt ::v83(){vfunc_called(this, "_ZN9S235C4_nt3v83Ev");}
void  S235C4_nt ::v84(){vfunc_called(this, "_ZN9S235C4_nt3v84Ev");}
void  S235C4_nt ::v85(){vfunc_called(this, "_ZN9S235C4_nt3v85Ev");}
void  S235C4_nt ::v86(){vfunc_called(this, "_ZN9S235C4_nt3v86Ev");}
void  S235C4_nt ::v87(){vfunc_called(this, "_ZN9S235C4_nt3v87Ev");}
void  S235C4_nt ::v88(){vfunc_called(this, "_ZN9S235C4_nt3v88Ev");}
void  S235C4_nt ::v89(){vfunc_called(this, "_ZN9S235C4_nt3v89Ev");}
void  S235C4_nt ::v90(){vfunc_called(this, "_ZN9S235C4_nt3v90Ev");}
void  S235C4_nt ::v91(){vfunc_called(this, "_ZN9S235C4_nt3v91Ev");}
void  S235C4_nt ::v92(){vfunc_called(this, "_ZN9S235C4_nt3v92Ev");}
void  S235C4_nt ::v93(){vfunc_called(this, "_ZN9S235C4_nt3v93Ev");}
void  S235C4_nt ::v94(){vfunc_called(this, "_ZN9S235C4_nt3v94Ev");}
void  S235C4_nt ::v95(){vfunc_called(this, "_ZN9S235C4_nt3v95Ev");}
S235C4_nt ::S235C4_nt(){ note_ctor("S235C4_nt", this);} // tgen

//skip512 S235C4_nt

#else // __cplusplus

extern void _ZN9S235C4_ntC1Ev();
extern void _ZN9S235C4_ntD1Ev();
Name_Map name_map_S235C4_nt[] = {
  NSPAIR(_ZN9S235C4_ntC1Ev),
  NSPAIR(_ZN9S235C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S235C6_nt;
extern VTBL_ENTRY _ZTI9S235C6_nt[];
extern  VTBL_ENTRY _ZTV9S235C6_nt[];
extern Class_Descriptor cd_S235C5_nt;
extern VTBL_ENTRY _ZTI9S235C5_nt[];
extern  VTBL_ENTRY _ZTV9S235C5_nt[];
static Base_Class bases_S235C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S235C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S235C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S235C4_nt[];
extern void _ZN9S235C4_ntD1Ev();
extern void _ZN9S235C4_ntD0Ev();
extern void _ZN9S235C6_nt2v5Ev();
extern void _ZN9S235C6_nt2v6Ev();
extern void _ZN9S235C6_nt2v7Ev();
extern void _ZN9S235C6_nt2v8Ev();
extern void _ZN9S235C6_nt2v9Ev();
extern void _ZN9S235C6_nt3v10Ev();
extern void _ZN9S235C6_nt3v11Ev();
extern void _ZN9S235C6_nt3v12Ev();
extern void _ZN9S235C6_nt3v13Ev();
extern void _ZN9S235C6_nt3v14Ev();
extern void _ZN9S235C6_nt3v15Ev();
extern void _ZN9S235C6_nt3v16Ev();
extern void _ZN9S235C6_nt3v17Ev();
extern void _ZN9S235C6_nt3v18Ev();
extern void _ZN9S235C6_nt3v19Ev();
extern void _ZN9S235C6_nt3v20Ev();
extern void _ZN9S235C6_nt3v21Ev();
extern void _ZN9S235C6_nt3v22Ev();
extern void _ZN9S235C6_nt3v23Ev();
extern void _ZN9S235C6_nt3v24Ev();
extern void _ZN9S235C6_nt3v25Ev();
extern void _ZN9S235C6_nt3v26Ev();
extern void _ZN9S235C6_nt3v27Ev();
extern void _ZN9S235C6_nt3v28Ev();
extern void _ZN9S235C6_nt3v29Ev();
extern void _ZN9S235C6_nt3v30Ev();
extern void _ZN9S235C6_nt3v31Ev();
extern void _ZN9S235C6_nt3v32Ev();
extern void _ZN9S235C6_nt3v33Ev();
extern void _ZN9S235C6_nt3v34Ev();
extern void _ZN9S235C6_nt3v35Ev();
extern void _ZN9S235C6_nt3v36Ev();
extern void _ZN9S235C6_nt3v37Ev();
extern void _ZN9S235C6_nt3v38Ev();
extern void _ZN9S235C6_nt3v39Ev();
extern void _ZN9S235C6_nt3v40Ev();
extern void _ZN9S235C6_nt3v41Ev();
extern void _ZN9S235C6_nt3v42Ev();
extern void _ZN9S235C6_nt3v43Ev();
extern void _ZN9S235C6_nt3v44Ev();
extern void _ZN9S235C6_nt3v45Ev();
extern void _ZN9S235C6_nt3v46Ev();
extern void _ZN9S235C6_nt3v47Ev();
extern void _ZN9S235C6_nt3v48Ev();
extern void _ZN9S235C6_nt3v49Ev();
extern void _ZN9S235C6_nt3v50Ev();
extern void _ZN9S235C6_nt3v51Ev();
extern void _ZN9S235C6_nt3v52Ev();
extern void _ZN9S235C6_nt3v53Ev();
extern void _ZN9S235C6_nt3v54Ev();
extern void _ZN9S235C6_nt3v55Ev();
extern void _ZN9S235C6_nt3v56Ev();
extern void _ZN9S235C6_nt3v57Ev();
extern void _ZN9S235C6_nt3v58Ev();
extern void _ZN9S235C6_nt3v59Ev();
extern void _ZN9S235C6_nt3v60Ev();
extern void _ZN9S235C6_nt3v61Ev();
extern void _ZN9S235C6_nt3v62Ev();
extern void _ZN9S235C6_nt3v63Ev();
extern void _ZN9S235C6_nt3v64Ev();
extern void _ZN9S235C6_nt3v65Ev();
extern void _ZN9S235C6_nt3v66Ev();
extern void _ZN9S235C6_nt3v67Ev();
extern void _ZN9S235C6_nt3v68Ev();
extern void _ZN9S235C5_nt3v69Ev();
extern void _ZN9S235C5_nt3v70Ev();
extern void _ZN9S235C5_nt3v71Ev();
extern void _ZN9S235C5_nt3v72Ev();
extern void _ZN9S235C5_nt3v73Ev();
extern void _ZN9S235C4_nt3v74Ev();
extern void _ZN9S235C4_nt3v75Ev();
extern void _ZN9S235C4_nt3v76Ev();
extern void _ZN9S235C4_nt3v77Ev();
extern void _ZN9S235C4_nt3v78Ev();
extern void _ZN9S235C4_nt3v79Ev();
extern void _ZN9S235C4_nt3v80Ev();
extern void _ZN9S235C4_nt3v81Ev();
extern void _ZN9S235C4_nt3v82Ev();
extern void _ZN9S235C4_nt3v83Ev();
extern void _ZN9S235C4_nt3v84Ev();
extern void _ZN9S235C4_nt3v85Ev();
extern void _ZN9S235C4_nt3v86Ev();
extern void _ZN9S235C4_nt3v87Ev();
extern void _ZN9S235C4_nt3v88Ev();
extern void _ZN9S235C4_nt3v89Ev();
extern void _ZN9S235C4_nt3v90Ev();
extern void _ZN9S235C4_nt3v91Ev();
extern void _ZN9S235C4_nt3v92Ev();
extern void _ZN9S235C4_nt3v93Ev();
extern void _ZN9S235C4_nt3v94Ev();
extern void _ZN9S235C4_nt3v95Ev();
static  VTBL_ENTRY vtc_S235C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S235C4_nt[0]),
  (VTBL_ENTRY)&_ZN9S235C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S235C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S235C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S235C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S235C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S235C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S235C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v95Ev,
};
extern VTBL_ENTRY _ZTI9S235C4_nt[];
VTBL_ENTRY *P__ZTI9S235C4_nt = _ZTI9S235C4_nt; 
extern  VTBL_ENTRY _ZTV9S235C4_nt[];
Class_Descriptor cd_S235C4_nt = {  "S235C4_nt", // class name
  bases_S235C4_nt, 2,
  &(vtc_S235C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,84), // object size
  NSPAIRA(_ZTI9S235C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S235C4_nt),95, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S235C9_nt  {
  int s235c9f0[4];
  void  mf235c9(); // _ZN9S235C9_nt7mf235c9Ev
};
//SIG(-1 S235C9_nt) C1{ m Fi[4]}


void  S235C9_nt ::mf235c9(){}

//skip512 S235C9_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S235C13_nt  {
  void *s235c13f0;
  int s235c13f1[2];
  void  mf235c13(); // _ZN10S235C13_nt8mf235c13Ev
};
//SIG(-1 S235C13_nt) C1{ m Fp Fi[2]}


void  S235C13_nt ::mf235c13(){}

//skip512 S235C13_nt

#else // __cplusplus

Class_Descriptor cd_S235C13_nt = {  "S235C13_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S235C12_nt  : S235C13_nt {
};
//SIG(-1 S235C12_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S235C12_nt

#else // __cplusplus

extern Class_Descriptor cd_S235C13_nt;
static Base_Class bases_S235C12_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S235C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S235C12_nt = {  "S235C12_nt", // class name
  bases_S235C12_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S235C11_nt  : S235C12_nt {
};
//SIG(-1 S235C11_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S235C11_nt

#else // __cplusplus

extern Class_Descriptor cd_S235C13_nt;
extern Class_Descriptor cd_S235C12_nt;
static Base_Class bases_S235C11_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S235C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S235C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S235C18  : S235C13_nt {
};
//SIG(-1 S235C18) C1{ BC2{ m Fp Fi[2]}}



static void Test_S235C18()
{
  extern Class_Descriptor cd_S235C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S235C18, buf);
    S235C18 &lv = *(new (buf) S235C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S235C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S235C18)");
    check_base_class_offset(lv, (S235C13_nt*), 0, "S235C18");
    test_class_info(&lv, &cd_S235C18);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS235C18(Test_S235C18, "S235C18", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S235C13_nt;
static Base_Class bases_S235C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S235C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S235C18 = {  "S235C18", // class name
  bases_S235C18, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S235C17  : S235C18 {
};
//SIG(-1 S235C17) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S235C17()
{
  extern Class_Descriptor cd_S235C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S235C17, buf);
    S235C17 &lv = *(new (buf) S235C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S235C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S235C17)");
    check_base_class_offset(lv, (S235C13_nt*)(S235C18*), 0, "S235C17");
    check_base_class_offset(lv, (S235C18*), 0, "S235C17");
    test_class_info(&lv, &cd_S235C17);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS235C17(Test_S235C17, "S235C17", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S235C13_nt;
extern Class_Descriptor cd_S235C18;
static Base_Class bases_S235C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S235C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S235C18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S235C17 = {  "S235C17", // class name
  bases_S235C17, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S235C3  : S235C4_nt {
  void *s235c3f0;
  ::S836C39 s235c3f1;
  ::S836C39 s235c3f2;
  ::S235C9_nt s235c3f3;
  ::S235C9_nt s235c3f4;
  int s235c3f5;
  ::S836C29 s235c3f6;
  void *s235c3f7;
  unsigned int s235c3f8:1;
  unsigned int s235c3f9:1;
  unsigned int s235c3f10:1;
  unsigned int s235c3f11:1;
  unsigned int s235c3f12:1;
  unsigned int s235c3f13:1;
  unsigned int s235c3f14:1;
  unsigned int s235c3f15:1;
  unsigned int s235c3f16:1;
  unsigned int s235c3f17:1;
  unsigned int s235c3f18:1;
  void *s235c3f19;
  ::S235C11_nt s235c3f20;
  ::S836C25 s235c3f21;
  unsigned int s235c3f22:1;
  ::S235C11_nt s235c3f23;
  ::S235C11_nt s235c3f24;
  ::S235C17 s235c3f25;
  ::S235C17 s235c3f26;
  char s235c3f27[2];
  ::S235C9_nt s235c3f28;
  int s235c3f29[3];
  char s235c3f30[2];
  int s235c3f31[2];
  virtual  ~S235C3(); // _ZN6S235C3D1Ev
  virtual void  v96(); // _ZN6S235C33v96Ev
  virtual void  v97(); // _ZN6S235C33v97Ev
  virtual void  v98(); // _ZN6S235C33v98Ev
  virtual void  v99(); // _ZN6S235C33v99Ev
  virtual void  v100(); // _ZN6S235C34v100Ev
  virtual void  v101(); // _ZN6S235C34v101Ev
  virtual void  v102(); // _ZN6S235C34v102Ev
  virtual void  v103(); // _ZN6S235C34v103Ev
  virtual void  v104(); // _ZN6S235C34v104Ev
  virtual void  v105(); // _ZN6S235C34v105Ev
  virtual void  v106(); // _ZN6S235C34v106Ev
  virtual void  v107(); // _ZN6S235C34v107Ev
  virtual void  v108(); // _ZN6S235C34v108Ev
  virtual void  v109(); // _ZN6S235C34v109Ev
  virtual void  v110(); // _ZN6S235C34v110Ev
  virtual void  v111(); // _ZN6S235C34v111Ev
  virtual void  v112(); // _ZN6S235C34v112Ev
  virtual void  v113(); // _ZN6S235C34v113Ev
  virtual void  v114(); // _ZN6S235C34v114Ev
  virtual void  v115(); // _ZN6S235C34v115Ev
  virtual void  v116(); // _ZN6S235C34v116Ev
  virtual void  v117(); // _ZN6S235C34v117Ev
  virtual void  v118(); // _ZN6S235C34v118Ev
  virtual void  v119(); // _ZN6S235C34v119Ev
  virtual void  v120(); // _ZN6S235C34v120Ev
  virtual void  v121(); // _ZN6S235C34v121Ev
  virtual void  v122(); // _ZN6S235C34v122Ev
  S235C3(); // tgen
};
//SIG(-1 S235C3) C1{ BC2{ BC3{ BC4{ vd v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v92 v93 v94 v95 v96 Fp FC5} vd v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 Fp FC6{ m} FC6 FC7{ m Fi[4]} FC7 Fi FC8{ m} Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp FC9{ BC10{ BC11{ m Fp Fi[2]}}} FC12{ m} Fi:1 FC9 FC9 FC13{ BC14{ BC11}} FC13 Fc[2] FC7 Fi[3] Fc[2] Fi[2]}


 S235C3 ::~S235C3(){ note_dtor("S235C3", this);}
void  S235C3 ::v96(){vfunc_called(this, "_ZN6S235C33v96Ev");}
void  S235C3 ::v97(){vfunc_called(this, "_ZN6S235C33v97Ev");}
void  S235C3 ::v98(){vfunc_called(this, "_ZN6S235C33v98Ev");}
void  S235C3 ::v99(){vfunc_called(this, "_ZN6S235C33v99Ev");}
void  S235C3 ::v100(){vfunc_called(this, "_ZN6S235C34v100Ev");}
void  S235C3 ::v101(){vfunc_called(this, "_ZN6S235C34v101Ev");}
void  S235C3 ::v102(){vfunc_called(this, "_ZN6S235C34v102Ev");}
void  S235C3 ::v103(){vfunc_called(this, "_ZN6S235C34v103Ev");}
void  S235C3 ::v104(){vfunc_called(this, "_ZN6S235C34v104Ev");}
void  S235C3 ::v105(){vfunc_called(this, "_ZN6S235C34v105Ev");}
void  S235C3 ::v106(){vfunc_called(this, "_ZN6S235C34v106Ev");}
void  S235C3 ::v107(){vfunc_called(this, "_ZN6S235C34v107Ev");}
void  S235C3 ::v108(){vfunc_called(this, "_ZN6S235C34v108Ev");}
void  S235C3 ::v109(){vfunc_called(this, "_ZN6S235C34v109Ev");}
void  S235C3 ::v110(){vfunc_called(this, "_ZN6S235C34v110Ev");}
void  S235C3 ::v111(){vfunc_called(this, "_ZN6S235C34v111Ev");}
void  S235C3 ::v112(){vfunc_called(this, "_ZN6S235C34v112Ev");}
void  S235C3 ::v113(){vfunc_called(this, "_ZN6S235C34v113Ev");}
void  S235C3 ::v114(){vfunc_called(this, "_ZN6S235C34v114Ev");}
void  S235C3 ::v115(){vfunc_called(this, "_ZN6S235C34v115Ev");}
void  S235C3 ::v116(){vfunc_called(this, "_ZN6S235C34v116Ev");}
void  S235C3 ::v117(){vfunc_called(this, "_ZN6S235C34v117Ev");}
void  S235C3 ::v118(){vfunc_called(this, "_ZN6S235C34v118Ev");}
void  S235C3 ::v119(){vfunc_called(this, "_ZN6S235C34v119Ev");}
void  S235C3 ::v120(){vfunc_called(this, "_ZN6S235C34v120Ev");}
void  S235C3 ::v121(){vfunc_called(this, "_ZN6S235C34v121Ev");}
void  S235C3 ::v122(){vfunc_called(this, "_ZN6S235C34v122Ev");}
S235C3 ::S235C3(){ note_ctor("S235C3", this);} // tgen

static void Test_S235C3()
{
  extern Class_Descriptor cd_S235C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(45,64)];
    init_test(&cd_S235C3, buf);
    S235C3 *dp, &lv = *(dp=new (buf) S235C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(352,252), "sizeof(S235C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S235C3)");
    check_base_class_offset(lv, (S235C6_nt*)(S235C5_nt*)(S235C4_nt*), 0, "S235C3");
    check_base_class_offset(lv, (S235C5_nt*)(S235C4_nt*), 0, "S235C3");
    check_base_class_offset(lv, (S235C4_nt*), 0, "S235C3");
    check_field_offset(lv, s235c3f0, ABISELECT(136,84), "S235C3.s235c3f0");
    check_field_offset(lv, s235c3f1, ABISELECT(144,88), "S235C3.s235c3f1");
    check_field_offset(lv, s235c3f2, ABISELECT(145,89), "S235C3.s235c3f2");
    check_field_offset(lv, s235c3f3, ABISELECT(148,92), "S235C3.s235c3f3");
    check_field_offset(lv, s235c3f4, ABISELECT(164,108), "S235C3.s235c3f4");
    check_field_offset(lv, s235c3f5, ABISELECT(180,124), "S235C3.s235c3f5");
    check_field_offset(lv, s235c3f6, ABISELECT(184,128), "S235C3.s235c3f6");
    check_field_offset(lv, s235c3f7, ABISELECT(192,132), "S235C3.s235c3f7");
    set_bf_and_test(lv, s235c3f8, ABISELECT(200,136), 0, 1, 1, "S235C3");
    set_bf_and_test(lv, s235c3f9, ABISELECT(200,136), 1, 1, 1, "S235C3");
    set_bf_and_test(lv, s235c3f10, ABISELECT(200,136), 2, 1, 1, "S235C3");
    set_bf_and_test(lv, s235c3f11, ABISELECT(200,136), 3, 1, 1, "S235C3");
    set_bf_and_test(lv, s235c3f12, ABISELECT(200,136), 4, 1, 1, "S235C3");
    set_bf_and_test(lv, s235c3f13, ABISELECT(200,136), 5, 1, 1, "S235C3");
    set_bf_and_test(lv, s235c3f14, ABISELECT(200,136), 6, 1, 1, "S235C3");
    set_bf_and_test(lv, s235c3f15, ABISELECT(200,136), 7, 1, 1, "S235C3");
    set_bf_and_test(lv, s235c3f16, ABISELECT(201,137), 0, 1, 1, "S235C3");
    set_bf_and_test(lv, s235c3f17, ABISELECT(201,137), 1, 1, 1, "S235C3");
    set_bf_and_test(lv, s235c3f18, ABISELECT(201,137), 2, 1, 1, "S235C3");
    check_field_offset(lv, s235c3f19, ABISELECT(208,140), "S235C3.s235c3f19");
    check_field_offset(lv, s235c3f20, ABISELECT(216,144), "S235C3.s235c3f20");
    check_field_offset(lv, s235c3f21, ABISELECT(232,156), "S235C3.s235c3f21");
    set_bf_and_test(lv, s235c3f22, ABISELECT(233,157), 0, 1, 1, "S235C3");
    check_field_offset(lv, s235c3f23, ABISELECT(240,160), "S235C3.s235c3f23");
    check_field_offset(lv, s235c3f24, ABISELECT(256,172), "S235C3.s235c3f24");
    check_field_offset(lv, s235c3f25, ABISELECT(272,184), "S235C3.s235c3f25");
    check_field_offset(lv, s235c3f26, ABISELECT(288,196), "S235C3.s235c3f26");
    check_field_offset(lv, s235c3f27, ABISELECT(304,208), "S235C3.s235c3f27");
    check_field_offset(lv, s235c3f28, ABISELECT(308,212), "S235C3.s235c3f28");
    check_field_offset(lv, s235c3f29, ABISELECT(324,228), "S235C3.s235c3f29");
    check_field_offset(lv, s235c3f30, ABISELECT(336,240), "S235C3.s235c3f30");
    check_field_offset(lv, s235c3f31, ABISELECT(340,244), "S235C3.s235c3f31");
    test_class_info(&lv, &cd_S235C3);
    dp->~S235C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS235C3(Test_S235C3, "S235C3", ABISELECT(352,252));

#else // __cplusplus

extern void _ZN6S235C3C1Ev();
extern void _ZN6S235C3D1Ev();
Name_Map name_map_S235C3[] = {
  NSPAIR(_ZN6S235C3C1Ev),
  NSPAIR(_ZN6S235C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S235C6_nt;
extern VTBL_ENTRY _ZTI9S235C6_nt[];
extern  VTBL_ENTRY _ZTV9S235C6_nt[];
extern Class_Descriptor cd_S235C5_nt;
extern VTBL_ENTRY _ZTI9S235C5_nt[];
extern  VTBL_ENTRY _ZTV9S235C5_nt[];
extern Class_Descriptor cd_S235C4_nt;
extern VTBL_ENTRY _ZTI9S235C4_nt[];
extern  VTBL_ENTRY _ZTV9S235C4_nt[];
static Base_Class bases_S235C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S235C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S235C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S235C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S235C3[];
extern void _ZN6S235C3D1Ev();
extern void _ZN6S235C3D0Ev();
extern void _ZN9S235C6_nt2v5Ev();
extern void _ZN9S235C6_nt2v6Ev();
extern void _ZN9S235C6_nt2v7Ev();
extern void _ZN9S235C6_nt2v8Ev();
extern void _ZN9S235C6_nt2v9Ev();
extern void _ZN9S235C6_nt3v10Ev();
extern void _ZN9S235C6_nt3v11Ev();
extern void _ZN9S235C6_nt3v12Ev();
extern void _ZN9S235C6_nt3v13Ev();
extern void _ZN9S235C6_nt3v14Ev();
extern void _ZN9S235C6_nt3v15Ev();
extern void _ZN9S235C6_nt3v16Ev();
extern void _ZN9S235C6_nt3v17Ev();
extern void _ZN9S235C6_nt3v18Ev();
extern void _ZN9S235C6_nt3v19Ev();
extern void _ZN9S235C6_nt3v20Ev();
extern void _ZN9S235C6_nt3v21Ev();
extern void _ZN9S235C6_nt3v22Ev();
extern void _ZN9S235C6_nt3v23Ev();
extern void _ZN9S235C6_nt3v24Ev();
extern void _ZN9S235C6_nt3v25Ev();
extern void _ZN9S235C6_nt3v26Ev();
extern void _ZN9S235C6_nt3v27Ev();
extern void _ZN9S235C6_nt3v28Ev();
extern void _ZN9S235C6_nt3v29Ev();
extern void _ZN9S235C6_nt3v30Ev();
extern void _ZN9S235C6_nt3v31Ev();
extern void _ZN9S235C6_nt3v32Ev();
extern void _ZN9S235C6_nt3v33Ev();
extern void _ZN9S235C6_nt3v34Ev();
extern void _ZN9S235C6_nt3v35Ev();
extern void _ZN9S235C6_nt3v36Ev();
extern void _ZN9S235C6_nt3v37Ev();
extern void _ZN9S235C6_nt3v38Ev();
extern void _ZN9S235C6_nt3v39Ev();
extern void _ZN9S235C6_nt3v40Ev();
extern void _ZN9S235C6_nt3v41Ev();
extern void _ZN9S235C6_nt3v42Ev();
extern void _ZN9S235C6_nt3v43Ev();
extern void _ZN9S235C6_nt3v44Ev();
extern void _ZN9S235C6_nt3v45Ev();
extern void _ZN9S235C6_nt3v46Ev();
extern void _ZN9S235C6_nt3v47Ev();
extern void _ZN9S235C6_nt3v48Ev();
extern void _ZN9S235C6_nt3v49Ev();
extern void _ZN9S235C6_nt3v50Ev();
extern void _ZN9S235C6_nt3v51Ev();
extern void _ZN9S235C6_nt3v52Ev();
extern void _ZN9S235C6_nt3v53Ev();
extern void _ZN9S235C6_nt3v54Ev();
extern void _ZN9S235C6_nt3v55Ev();
extern void _ZN9S235C6_nt3v56Ev();
extern void _ZN9S235C6_nt3v57Ev();
extern void _ZN9S235C6_nt3v58Ev();
extern void _ZN9S235C6_nt3v59Ev();
extern void _ZN9S235C6_nt3v60Ev();
extern void _ZN9S235C6_nt3v61Ev();
extern void _ZN9S235C6_nt3v62Ev();
extern void _ZN9S235C6_nt3v63Ev();
extern void _ZN9S235C6_nt3v64Ev();
extern void _ZN9S235C6_nt3v65Ev();
extern void _ZN9S235C6_nt3v66Ev();
extern void _ZN9S235C6_nt3v67Ev();
extern void _ZN9S235C6_nt3v68Ev();
extern void _ZN9S235C5_nt3v69Ev();
extern void _ZN9S235C5_nt3v70Ev();
extern void _ZN9S235C5_nt3v71Ev();
extern void _ZN9S235C5_nt3v72Ev();
extern void _ZN9S235C5_nt3v73Ev();
extern void _ZN9S235C4_nt3v74Ev();
extern void _ZN9S235C4_nt3v75Ev();
extern void _ZN9S235C4_nt3v76Ev();
extern void _ZN9S235C4_nt3v77Ev();
extern void _ZN9S235C4_nt3v78Ev();
extern void _ZN9S235C4_nt3v79Ev();
extern void _ZN9S235C4_nt3v80Ev();
extern void _ZN9S235C4_nt3v81Ev();
extern void _ZN9S235C4_nt3v82Ev();
extern void _ZN9S235C4_nt3v83Ev();
extern void _ZN9S235C4_nt3v84Ev();
extern void _ZN9S235C4_nt3v85Ev();
extern void _ZN9S235C4_nt3v86Ev();
extern void _ZN9S235C4_nt3v87Ev();
extern void _ZN9S235C4_nt3v88Ev();
extern void _ZN9S235C4_nt3v89Ev();
extern void _ZN9S235C4_nt3v90Ev();
extern void _ZN9S235C4_nt3v91Ev();
extern void _ZN9S235C4_nt3v92Ev();
extern void _ZN9S235C4_nt3v93Ev();
extern void _ZN9S235C4_nt3v94Ev();
extern void _ZN9S235C4_nt3v95Ev();
extern void _ZN6S235C33v96Ev();
extern void _ZN6S235C33v97Ev();
extern void _ZN6S235C33v98Ev();
extern void _ZN6S235C33v99Ev();
extern void _ZN6S235C34v100Ev();
extern void _ZN6S235C34v101Ev();
extern void _ZN6S235C34v102Ev();
extern void _ZN6S235C34v103Ev();
extern void _ZN6S235C34v104Ev();
extern void _ZN6S235C34v105Ev();
extern void _ZN6S235C34v106Ev();
extern void _ZN6S235C34v107Ev();
extern void _ZN6S235C34v108Ev();
extern void _ZN6S235C34v109Ev();
extern void _ZN6S235C34v110Ev();
extern void _ZN6S235C34v111Ev();
extern void _ZN6S235C34v112Ev();
extern void _ZN6S235C34v113Ev();
extern void _ZN6S235C34v114Ev();
extern void _ZN6S235C34v115Ev();
extern void _ZN6S235C34v116Ev();
extern void _ZN6S235C34v117Ev();
extern void _ZN6S235C34v118Ev();
extern void _ZN6S235C34v119Ev();
extern void _ZN6S235C34v120Ev();
extern void _ZN6S235C34v121Ev();
extern void _ZN6S235C34v122Ev();
static  VTBL_ENTRY vtc_S235C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S235C3[0]),
  (VTBL_ENTRY)&_ZN6S235C3D1Ev,
  (VTBL_ENTRY)&_ZN6S235C3D0Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S235C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S235C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S235C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S235C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S235C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN6S235C33v96Ev,
  (VTBL_ENTRY)&_ZN6S235C33v97Ev,
  (VTBL_ENTRY)&_ZN6S235C33v98Ev,
  (VTBL_ENTRY)&_ZN6S235C33v99Ev,
  (VTBL_ENTRY)&_ZN6S235C34v100Ev,
  (VTBL_ENTRY)&_ZN6S235C34v101Ev,
  (VTBL_ENTRY)&_ZN6S235C34v102Ev,
  (VTBL_ENTRY)&_ZN6S235C34v103Ev,
  (VTBL_ENTRY)&_ZN6S235C34v104Ev,
  (VTBL_ENTRY)&_ZN6S235C34v105Ev,
  (VTBL_ENTRY)&_ZN6S235C34v106Ev,
  (VTBL_ENTRY)&_ZN6S235C34v107Ev,
  (VTBL_ENTRY)&_ZN6S235C34v108Ev,
  (VTBL_ENTRY)&_ZN6S235C34v109Ev,
  (VTBL_ENTRY)&_ZN6S235C34v110Ev,
  (VTBL_ENTRY)&_ZN6S235C34v111Ev,
  (VTBL_ENTRY)&_ZN6S235C34v112Ev,
  (VTBL_ENTRY)&_ZN6S235C34v113Ev,
  (VTBL_ENTRY)&_ZN6S235C34v114Ev,
  (VTBL_ENTRY)&_ZN6S235C34v115Ev,
  (VTBL_ENTRY)&_ZN6S235C34v116Ev,
  (VTBL_ENTRY)&_ZN6S235C34v117Ev,
  (VTBL_ENTRY)&_ZN6S235C34v118Ev,
  (VTBL_ENTRY)&_ZN6S235C34v119Ev,
  (VTBL_ENTRY)&_ZN6S235C34v120Ev,
  (VTBL_ENTRY)&_ZN6S235C34v121Ev,
  (VTBL_ENTRY)&_ZN6S235C34v122Ev,
};
extern VTBL_ENTRY _ZTI6S235C3[];
extern  VTBL_ENTRY _ZTV6S235C3[];
Class_Descriptor cd_S235C3 = {  "S235C3", // class name
  bases_S235C3, 3,
  &(vtc_S235C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(352,252), // object size
  NSPAIRA(_ZTI6S235C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S235C3),122, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S235C20_nt  {
  int s235c20f0[3];
  void  mf235c20(); // _ZN10S235C20_nt8mf235c20Ev
};
//SIG(-1 S235C20_nt) C1{ m Fi[3]}


void  S235C20_nt ::mf235c20(){}

//skip512 S235C20_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S235C2  : S235C3 {
  int s235c2f0[4];
  ::S836C39 s235c2f1;
  ::S235C20_nt s235c2f2;
  void *s235c2f3;
  virtual  ~S235C2(); // _ZN6S235C2D1Ev
  virtual void  v123(); // _ZN6S235C24v123Ev
  virtual void  v124(); // _ZN6S235C24v124Ev
  virtual void  v125(); // _ZN6S235C24v125Ev
  virtual void  v126(); // _ZN6S235C24v126Ev
  virtual void  v127(); // _ZN6S235C24v127Ev
  virtual void  v128(); // _ZN6S235C24v128Ev
  virtual void  v129(); // _ZN6S235C24v129Ev
  virtual void  v130(); // _ZN6S235C24v130Ev
  virtual void  v131(); // _ZN6S235C24v131Ev
  virtual void  v132(); // _ZN6S235C24v132Ev
  virtual void  v133(); // _ZN6S235C24v133Ev
  virtual void  v134(); // _ZN6S235C24v134Ev
  virtual void  v135(); // _ZN6S235C24v135Ev
  virtual void  v136(); // _ZN6S235C24v136Ev
  S235C2(); // tgen
};
//SIG(-1 S235C2) C1{ BC2{ BC3{ BC4{ BC5{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v79 v80 v81 v82 v83 Fp FC6} vd v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 Fp FC7{ m} FC7 FC8{ m Fi[4]} FC8 Fi FC9{ m} Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp FC10{ BC11{ BC12{ m Fp Fi[2]}}} FC13{ m} Fi:1 FC10 FC10 FC14{ BC15{ BC12}} FC14 Fc[2] FC8 Fi[3] Fc[2] Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fi[4] FC7 FC16{ m Fi[3]} Fp}


 S235C2 ::~S235C2(){ note_dtor("S235C2", this);}
void  S235C2 ::v123(){vfunc_called(this, "_ZN6S235C24v123Ev");}
void  S235C2 ::v124(){vfunc_called(this, "_ZN6S235C24v124Ev");}
void  S235C2 ::v125(){vfunc_called(this, "_ZN6S235C24v125Ev");}
void  S235C2 ::v126(){vfunc_called(this, "_ZN6S235C24v126Ev");}
void  S235C2 ::v127(){vfunc_called(this, "_ZN6S235C24v127Ev");}
void  S235C2 ::v128(){vfunc_called(this, "_ZN6S235C24v128Ev");}
void  S235C2 ::v129(){vfunc_called(this, "_ZN6S235C24v129Ev");}
void  S235C2 ::v130(){vfunc_called(this, "_ZN6S235C24v130Ev");}
void  S235C2 ::v131(){vfunc_called(this, "_ZN6S235C24v131Ev");}
void  S235C2 ::v132(){vfunc_called(this, "_ZN6S235C24v132Ev");}
void  S235C2 ::v133(){vfunc_called(this, "_ZN6S235C24v133Ev");}
void  S235C2 ::v134(){vfunc_called(this, "_ZN6S235C24v134Ev");}
void  S235C2 ::v135(){vfunc_called(this, "_ZN6S235C24v135Ev");}
void  S235C2 ::v136(){vfunc_called(this, "_ZN6S235C24v136Ev");}
S235C2 ::S235C2(){ note_ctor("S235C2", this);} // tgen

static void Test_S235C2()
{
  extern Class_Descriptor cd_S235C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(50,73)];
    init_test(&cd_S235C2, buf);
    S235C2 *dp, &lv = *(dp=new (buf) S235C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(392,288), "sizeof(S235C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S235C2)");
    check_base_class_offset(lv, (S235C6_nt*)(S235C5_nt*)(S235C4_nt*)(S235C3*), 0, "S235C2");
    check_base_class_offset(lv, (S235C5_nt*)(S235C4_nt*)(S235C3*), 0, "S235C2");
    check_base_class_offset(lv, (S235C4_nt*)(S235C3*), 0, "S235C2");
    check_base_class_offset(lv, (S235C3*), 0, "S235C2");
    check_field_offset(lv, s235c2f0, ABISELECT(348,252), "S235C2.s235c2f0");
    check_field_offset(lv, s235c2f1, ABISELECT(364,268), "S235C2.s235c2f1");
    check_field_offset(lv, s235c2f2, ABISELECT(368,272), "S235C2.s235c2f2");
    check_field_offset(lv, s235c2f3, ABISELECT(384,284), "S235C2.s235c2f3");
    test_class_info(&lv, &cd_S235C2);
    dp->~S235C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS235C2(Test_S235C2, "S235C2", ABISELECT(392,288));

#else // __cplusplus

extern void _ZN6S235C2C1Ev();
extern void _ZN6S235C2D1Ev();
Name_Map name_map_S235C2[] = {
  NSPAIR(_ZN6S235C2C1Ev),
  NSPAIR(_ZN6S235C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S235C6_nt;
extern VTBL_ENTRY _ZTI9S235C6_nt[];
extern  VTBL_ENTRY _ZTV9S235C6_nt[];
extern Class_Descriptor cd_S235C5_nt;
extern VTBL_ENTRY _ZTI9S235C5_nt[];
extern  VTBL_ENTRY _ZTV9S235C5_nt[];
extern Class_Descriptor cd_S235C4_nt;
extern VTBL_ENTRY _ZTI9S235C4_nt[];
extern  VTBL_ENTRY _ZTV9S235C4_nt[];
extern Class_Descriptor cd_S235C3;
extern VTBL_ENTRY _ZTI6S235C3[];
extern  VTBL_ENTRY _ZTV6S235C3[];
static Base_Class bases_S235C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S235C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S235C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S235C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S235C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S235C2[];
extern void _ZN6S235C2D1Ev();
extern void _ZN6S235C2D0Ev();
extern void _ZN9S235C6_nt2v5Ev();
extern void _ZN9S235C6_nt2v6Ev();
extern void _ZN9S235C6_nt2v7Ev();
extern void _ZN9S235C6_nt2v8Ev();
extern void _ZN9S235C6_nt2v9Ev();
extern void _ZN9S235C6_nt3v10Ev();
extern void _ZN9S235C6_nt3v11Ev();
extern void _ZN9S235C6_nt3v12Ev();
extern void _ZN9S235C6_nt3v13Ev();
extern void _ZN9S235C6_nt3v14Ev();
extern void _ZN9S235C6_nt3v15Ev();
extern void _ZN9S235C6_nt3v16Ev();
extern void _ZN9S235C6_nt3v17Ev();
extern void _ZN9S235C6_nt3v18Ev();
extern void _ZN9S235C6_nt3v19Ev();
extern void _ZN9S235C6_nt3v20Ev();
extern void _ZN9S235C6_nt3v21Ev();
extern void _ZN9S235C6_nt3v22Ev();
extern void _ZN9S235C6_nt3v23Ev();
extern void _ZN9S235C6_nt3v24Ev();
extern void _ZN9S235C6_nt3v25Ev();
extern void _ZN9S235C6_nt3v26Ev();
extern void _ZN9S235C6_nt3v27Ev();
extern void _ZN9S235C6_nt3v28Ev();
extern void _ZN9S235C6_nt3v29Ev();
extern void _ZN9S235C6_nt3v30Ev();
extern void _ZN9S235C6_nt3v31Ev();
extern void _ZN9S235C6_nt3v32Ev();
extern void _ZN9S235C6_nt3v33Ev();
extern void _ZN9S235C6_nt3v34Ev();
extern void _ZN9S235C6_nt3v35Ev();
extern void _ZN9S235C6_nt3v36Ev();
extern void _ZN9S235C6_nt3v37Ev();
extern void _ZN9S235C6_nt3v38Ev();
extern void _ZN9S235C6_nt3v39Ev();
extern void _ZN9S235C6_nt3v40Ev();
extern void _ZN9S235C6_nt3v41Ev();
extern void _ZN9S235C6_nt3v42Ev();
extern void _ZN9S235C6_nt3v43Ev();
extern void _ZN9S235C6_nt3v44Ev();
extern void _ZN9S235C6_nt3v45Ev();
extern void _ZN9S235C6_nt3v46Ev();
extern void _ZN9S235C6_nt3v47Ev();
extern void _ZN9S235C6_nt3v48Ev();
extern void _ZN9S235C6_nt3v49Ev();
extern void _ZN9S235C6_nt3v50Ev();
extern void _ZN9S235C6_nt3v51Ev();
extern void _ZN9S235C6_nt3v52Ev();
extern void _ZN9S235C6_nt3v53Ev();
extern void _ZN9S235C6_nt3v54Ev();
extern void _ZN9S235C6_nt3v55Ev();
extern void _ZN9S235C6_nt3v56Ev();
extern void _ZN9S235C6_nt3v57Ev();
extern void _ZN9S235C6_nt3v58Ev();
extern void _ZN9S235C6_nt3v59Ev();
extern void _ZN9S235C6_nt3v60Ev();
extern void _ZN9S235C6_nt3v61Ev();
extern void _ZN9S235C6_nt3v62Ev();
extern void _ZN9S235C6_nt3v63Ev();
extern void _ZN9S235C6_nt3v64Ev();
extern void _ZN9S235C6_nt3v65Ev();
extern void _ZN9S235C6_nt3v66Ev();
extern void _ZN9S235C6_nt3v67Ev();
extern void _ZN9S235C6_nt3v68Ev();
extern void _ZN9S235C5_nt3v69Ev();
extern void _ZN9S235C5_nt3v70Ev();
extern void _ZN9S235C5_nt3v71Ev();
extern void _ZN9S235C5_nt3v72Ev();
extern void _ZN9S235C5_nt3v73Ev();
extern void _ZN9S235C4_nt3v74Ev();
extern void _ZN9S235C4_nt3v75Ev();
extern void _ZN9S235C4_nt3v76Ev();
extern void _ZN9S235C4_nt3v77Ev();
extern void _ZN9S235C4_nt3v78Ev();
extern void _ZN9S235C4_nt3v79Ev();
extern void _ZN9S235C4_nt3v80Ev();
extern void _ZN9S235C4_nt3v81Ev();
extern void _ZN9S235C4_nt3v82Ev();
extern void _ZN9S235C4_nt3v83Ev();
extern void _ZN9S235C4_nt3v84Ev();
extern void _ZN9S235C4_nt3v85Ev();
extern void _ZN9S235C4_nt3v86Ev();
extern void _ZN9S235C4_nt3v87Ev();
extern void _ZN9S235C4_nt3v88Ev();
extern void _ZN9S235C4_nt3v89Ev();
extern void _ZN9S235C4_nt3v90Ev();
extern void _ZN9S235C4_nt3v91Ev();
extern void _ZN9S235C4_nt3v92Ev();
extern void _ZN9S235C4_nt3v93Ev();
extern void _ZN9S235C4_nt3v94Ev();
extern void _ZN9S235C4_nt3v95Ev();
extern void _ZN6S235C33v96Ev();
extern void _ZN6S235C33v97Ev();
extern void _ZN6S235C33v98Ev();
extern void _ZN6S235C33v99Ev();
extern void _ZN6S235C34v100Ev();
extern void _ZN6S235C34v101Ev();
extern void _ZN6S235C34v102Ev();
extern void _ZN6S235C34v103Ev();
extern void _ZN6S235C34v104Ev();
extern void _ZN6S235C34v105Ev();
extern void _ZN6S235C34v106Ev();
extern void _ZN6S235C34v107Ev();
extern void _ZN6S235C34v108Ev();
extern void _ZN6S235C34v109Ev();
extern void _ZN6S235C34v110Ev();
extern void _ZN6S235C34v111Ev();
extern void _ZN6S235C34v112Ev();
extern void _ZN6S235C34v113Ev();
extern void _ZN6S235C34v114Ev();
extern void _ZN6S235C34v115Ev();
extern void _ZN6S235C34v116Ev();
extern void _ZN6S235C34v117Ev();
extern void _ZN6S235C34v118Ev();
extern void _ZN6S235C34v119Ev();
extern void _ZN6S235C34v120Ev();
extern void _ZN6S235C34v121Ev();
extern void _ZN6S235C34v122Ev();
extern void _ZN6S235C24v123Ev();
extern void _ZN6S235C24v124Ev();
extern void _ZN6S235C24v125Ev();
extern void _ZN6S235C24v126Ev();
extern void _ZN6S235C24v127Ev();
extern void _ZN6S235C24v128Ev();
extern void _ZN6S235C24v129Ev();
extern void _ZN6S235C24v130Ev();
extern void _ZN6S235C24v131Ev();
extern void _ZN6S235C24v132Ev();
extern void _ZN6S235C24v133Ev();
extern void _ZN6S235C24v134Ev();
extern void _ZN6S235C24v135Ev();
extern void _ZN6S235C24v136Ev();
static  VTBL_ENTRY vtc_S235C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S235C2[0]),
  (VTBL_ENTRY)&_ZN6S235C2D1Ev,
  (VTBL_ENTRY)&_ZN6S235C2D0Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S235C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S235C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S235C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S235C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S235C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN6S235C33v96Ev,
  (VTBL_ENTRY)&_ZN6S235C33v97Ev,
  (VTBL_ENTRY)&_ZN6S235C33v98Ev,
  (VTBL_ENTRY)&_ZN6S235C33v99Ev,
  (VTBL_ENTRY)&_ZN6S235C34v100Ev,
  (VTBL_ENTRY)&_ZN6S235C34v101Ev,
  (VTBL_ENTRY)&_ZN6S235C34v102Ev,
  (VTBL_ENTRY)&_ZN6S235C34v103Ev,
  (VTBL_ENTRY)&_ZN6S235C34v104Ev,
  (VTBL_ENTRY)&_ZN6S235C34v105Ev,
  (VTBL_ENTRY)&_ZN6S235C34v106Ev,
  (VTBL_ENTRY)&_ZN6S235C34v107Ev,
  (VTBL_ENTRY)&_ZN6S235C34v108Ev,
  (VTBL_ENTRY)&_ZN6S235C34v109Ev,
  (VTBL_ENTRY)&_ZN6S235C34v110Ev,
  (VTBL_ENTRY)&_ZN6S235C34v111Ev,
  (VTBL_ENTRY)&_ZN6S235C34v112Ev,
  (VTBL_ENTRY)&_ZN6S235C34v113Ev,
  (VTBL_ENTRY)&_ZN6S235C34v114Ev,
  (VTBL_ENTRY)&_ZN6S235C34v115Ev,
  (VTBL_ENTRY)&_ZN6S235C34v116Ev,
  (VTBL_ENTRY)&_ZN6S235C34v117Ev,
  (VTBL_ENTRY)&_ZN6S235C34v118Ev,
  (VTBL_ENTRY)&_ZN6S235C34v119Ev,
  (VTBL_ENTRY)&_ZN6S235C34v120Ev,
  (VTBL_ENTRY)&_ZN6S235C34v121Ev,
  (VTBL_ENTRY)&_ZN6S235C34v122Ev,
  (VTBL_ENTRY)&_ZN6S235C24v123Ev,
  (VTBL_ENTRY)&_ZN6S235C24v124Ev,
  (VTBL_ENTRY)&_ZN6S235C24v125Ev,
  (VTBL_ENTRY)&_ZN6S235C24v126Ev,
  (VTBL_ENTRY)&_ZN6S235C24v127Ev,
  (VTBL_ENTRY)&_ZN6S235C24v128Ev,
  (VTBL_ENTRY)&_ZN6S235C24v129Ev,
  (VTBL_ENTRY)&_ZN6S235C24v130Ev,
  (VTBL_ENTRY)&_ZN6S235C24v131Ev,
  (VTBL_ENTRY)&_ZN6S235C24v132Ev,
  (VTBL_ENTRY)&_ZN6S235C24v133Ev,
  (VTBL_ENTRY)&_ZN6S235C24v134Ev,
  (VTBL_ENTRY)&_ZN6S235C24v135Ev,
  (VTBL_ENTRY)&_ZN6S235C24v136Ev,
};
extern VTBL_ENTRY _ZTI6S235C2[];
extern  VTBL_ENTRY _ZTV6S235C2[];
Class_Descriptor cd_S235C2 = {  "S235C2", // class name
  bases_S235C2, 4,
  &(vtc_S235C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(392,288), // object size
  NSPAIRA(_ZTI6S235C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S235C2),136, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S235C23_nt  {
  void *s235c23f0;
  ::S235C7_nt s235c23f1;
  void  mf235c23(); // _ZN10S235C23_nt8mf235c23Ev
};
//SIG(-1 S235C23_nt) C1{ m Fp FC2{ m Fi[2]}}


void  S235C23_nt ::mf235c23(){}

//skip512 S235C23_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S235C1  : S235C2 {
  unsigned int s235c1f0:1;
  unsigned int s235c1f1:1;
  int s235c1f2[3];
  ::S235C17 s235c1f3;
  ::S235C23_nt s235c1f4;
  virtual  ~S235C1(); // _ZN6S235C1D1Ev
  virtual void  v1(); // _ZN6S235C12v1Ev
  virtual void  v2(); // _ZN6S235C12v2Ev
  virtual void  v3(); // _ZN6S235C12v3Ev
  virtual void  v4(); // _ZN6S235C12v4Ev
  S235C1(); // tgen
};
//SIG(1 S235C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 Fp FC7} vd v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 Fp FC8{ m} FC8 FC9{ m Fi[4]} FC9 Fi FC10{ m} Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp FC11{ BC12{ BC13{ m Fp Fi[2]}}} FC14{ m} Fi:1 FC11 FC11 FC15{ BC16{ BC13}} FC15 Fc[2] FC9 Fi[3] Fc[2] Fi[2]} vd v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 Fi[4] FC8 FC17{ m Fi[3]} Fp} vd v1 v2 v3 v4 Fi:1 Fi:1 Fi[3] FC15 FC18{ m Fp FC7}}


 S235C1 ::~S235C1(){ note_dtor("S235C1", this);}
void  S235C1 ::v1(){vfunc_called(this, "_ZN6S235C12v1Ev");}
void  S235C1 ::v2(){vfunc_called(this, "_ZN6S235C12v2Ev");}
void  S235C1 ::v3(){vfunc_called(this, "_ZN6S235C12v3Ev");}
void  S235C1 ::v4(){vfunc_called(this, "_ZN6S235C12v4Ev");}
S235C1 ::S235C1(){ note_ctor("S235C1", this);} // tgen

static void Test_S235C1()
{
  extern Class_Descriptor cd_S235C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(56,83)];
    init_test(&cd_S235C1, buf);
    S235C1 *dp, &lv = *(dp=new (buf) S235C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(440,328), "sizeof(S235C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S235C1)");
    check_base_class_offset(lv, (S235C6_nt*)(S235C5_nt*)(S235C4_nt*)(S235C3*)(S235C2*), 0, "S235C1");
    check_base_class_offset(lv, (S235C5_nt*)(S235C4_nt*)(S235C3*)(S235C2*), 0, "S235C1");
    check_base_class_offset(lv, (S235C4_nt*)(S235C3*)(S235C2*), 0, "S235C1");
    check_base_class_offset(lv, (S235C3*)(S235C2*), 0, "S235C1");
    check_base_class_offset(lv, (S235C2*), 0, "S235C1");
    set_bf_and_test(lv, s235c1f0, ABISELECT(392,288), 0, 1, 1, "S235C1");
    set_bf_and_test(lv, s235c1f1, ABISELECT(392,288), 1, 1, 1, "S235C1");
    check_field_offset(lv, s235c1f2, ABISELECT(396,292), "S235C1.s235c1f2");
    check_field_offset(lv, s235c1f3, ABISELECT(408,304), "S235C1.s235c1f3");
    check_field_offset(lv, s235c1f4, ABISELECT(424,316), "S235C1.s235c1f4");
    test_class_info(&lv, &cd_S235C1);
    dp->~S235C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS235C1(Test_S235C1, "S235C1", ABISELECT(440,328));

#else // __cplusplus

extern void _ZN6S235C1C1Ev();
extern void _ZN6S235C1D1Ev();
Name_Map name_map_S235C1[] = {
  NSPAIR(_ZN6S235C1C1Ev),
  NSPAIR(_ZN6S235C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S235C6_nt;
extern VTBL_ENTRY _ZTI9S235C6_nt[];
extern  VTBL_ENTRY _ZTV9S235C6_nt[];
extern Class_Descriptor cd_S235C5_nt;
extern VTBL_ENTRY _ZTI9S235C5_nt[];
extern  VTBL_ENTRY _ZTV9S235C5_nt[];
extern Class_Descriptor cd_S235C4_nt;
extern VTBL_ENTRY _ZTI9S235C4_nt[];
extern  VTBL_ENTRY _ZTV9S235C4_nt[];
extern Class_Descriptor cd_S235C3;
extern VTBL_ENTRY _ZTI6S235C3[];
extern  VTBL_ENTRY _ZTV6S235C3[];
extern Class_Descriptor cd_S235C2;
extern VTBL_ENTRY _ZTI6S235C2[];
extern  VTBL_ENTRY _ZTV6S235C2[];
static Base_Class bases_S235C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S235C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S235C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S235C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S235C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S235C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S235C1[];
extern void _ZN6S235C1D1Ev();
extern void _ZN6S235C1D0Ev();
extern void _ZN9S235C6_nt2v5Ev();
extern void _ZN9S235C6_nt2v6Ev();
extern void _ZN9S235C6_nt2v7Ev();
extern void _ZN9S235C6_nt2v8Ev();
extern void _ZN9S235C6_nt2v9Ev();
extern void _ZN9S235C6_nt3v10Ev();
extern void _ZN9S235C6_nt3v11Ev();
extern void _ZN9S235C6_nt3v12Ev();
extern void _ZN9S235C6_nt3v13Ev();
extern void _ZN9S235C6_nt3v14Ev();
extern void _ZN9S235C6_nt3v15Ev();
extern void _ZN9S235C6_nt3v16Ev();
extern void _ZN9S235C6_nt3v17Ev();
extern void _ZN9S235C6_nt3v18Ev();
extern void _ZN9S235C6_nt3v19Ev();
extern void _ZN9S235C6_nt3v20Ev();
extern void _ZN9S235C6_nt3v21Ev();
extern void _ZN9S235C6_nt3v22Ev();
extern void _ZN9S235C6_nt3v23Ev();
extern void _ZN9S235C6_nt3v24Ev();
extern void _ZN9S235C6_nt3v25Ev();
extern void _ZN9S235C6_nt3v26Ev();
extern void _ZN9S235C6_nt3v27Ev();
extern void _ZN9S235C6_nt3v28Ev();
extern void _ZN9S235C6_nt3v29Ev();
extern void _ZN9S235C6_nt3v30Ev();
extern void _ZN9S235C6_nt3v31Ev();
extern void _ZN9S235C6_nt3v32Ev();
extern void _ZN9S235C6_nt3v33Ev();
extern void _ZN9S235C6_nt3v34Ev();
extern void _ZN9S235C6_nt3v35Ev();
extern void _ZN9S235C6_nt3v36Ev();
extern void _ZN9S235C6_nt3v37Ev();
extern void _ZN9S235C6_nt3v38Ev();
extern void _ZN9S235C6_nt3v39Ev();
extern void _ZN9S235C6_nt3v40Ev();
extern void _ZN9S235C6_nt3v41Ev();
extern void _ZN9S235C6_nt3v42Ev();
extern void _ZN9S235C6_nt3v43Ev();
extern void _ZN9S235C6_nt3v44Ev();
extern void _ZN9S235C6_nt3v45Ev();
extern void _ZN9S235C6_nt3v46Ev();
extern void _ZN9S235C6_nt3v47Ev();
extern void _ZN9S235C6_nt3v48Ev();
extern void _ZN9S235C6_nt3v49Ev();
extern void _ZN9S235C6_nt3v50Ev();
extern void _ZN9S235C6_nt3v51Ev();
extern void _ZN9S235C6_nt3v52Ev();
extern void _ZN9S235C6_nt3v53Ev();
extern void _ZN9S235C6_nt3v54Ev();
extern void _ZN9S235C6_nt3v55Ev();
extern void _ZN9S235C6_nt3v56Ev();
extern void _ZN9S235C6_nt3v57Ev();
extern void _ZN9S235C6_nt3v58Ev();
extern void _ZN9S235C6_nt3v59Ev();
extern void _ZN9S235C6_nt3v60Ev();
extern void _ZN9S235C6_nt3v61Ev();
extern void _ZN9S235C6_nt3v62Ev();
extern void _ZN9S235C6_nt3v63Ev();
extern void _ZN9S235C6_nt3v64Ev();
extern void _ZN9S235C6_nt3v65Ev();
extern void _ZN9S235C6_nt3v66Ev();
extern void _ZN9S235C6_nt3v67Ev();
extern void _ZN9S235C6_nt3v68Ev();
extern void _ZN9S235C5_nt3v69Ev();
extern void _ZN9S235C5_nt3v70Ev();
extern void _ZN9S235C5_nt3v71Ev();
extern void _ZN9S235C5_nt3v72Ev();
extern void _ZN9S235C5_nt3v73Ev();
extern void _ZN9S235C4_nt3v74Ev();
extern void _ZN9S235C4_nt3v75Ev();
extern void _ZN9S235C4_nt3v76Ev();
extern void _ZN9S235C4_nt3v77Ev();
extern void _ZN9S235C4_nt3v78Ev();
extern void _ZN9S235C4_nt3v79Ev();
extern void _ZN9S235C4_nt3v80Ev();
extern void _ZN9S235C4_nt3v81Ev();
extern void _ZN9S235C4_nt3v82Ev();
extern void _ZN9S235C4_nt3v83Ev();
extern void _ZN9S235C4_nt3v84Ev();
extern void _ZN9S235C4_nt3v85Ev();
extern void _ZN9S235C4_nt3v86Ev();
extern void _ZN9S235C4_nt3v87Ev();
extern void _ZN9S235C4_nt3v88Ev();
extern void _ZN9S235C4_nt3v89Ev();
extern void _ZN9S235C4_nt3v90Ev();
extern void _ZN9S235C4_nt3v91Ev();
extern void _ZN9S235C4_nt3v92Ev();
extern void _ZN9S235C4_nt3v93Ev();
extern void _ZN9S235C4_nt3v94Ev();
extern void _ZN9S235C4_nt3v95Ev();
extern void _ZN6S235C33v96Ev();
extern void _ZN6S235C33v97Ev();
extern void _ZN6S235C33v98Ev();
extern void _ZN6S235C33v99Ev();
extern void _ZN6S235C34v100Ev();
extern void _ZN6S235C34v101Ev();
extern void _ZN6S235C34v102Ev();
extern void _ZN6S235C34v103Ev();
extern void _ZN6S235C34v104Ev();
extern void _ZN6S235C34v105Ev();
extern void _ZN6S235C34v106Ev();
extern void _ZN6S235C34v107Ev();
extern void _ZN6S235C34v108Ev();
extern void _ZN6S235C34v109Ev();
extern void _ZN6S235C34v110Ev();
extern void _ZN6S235C34v111Ev();
extern void _ZN6S235C34v112Ev();
extern void _ZN6S235C34v113Ev();
extern void _ZN6S235C34v114Ev();
extern void _ZN6S235C34v115Ev();
extern void _ZN6S235C34v116Ev();
extern void _ZN6S235C34v117Ev();
extern void _ZN6S235C34v118Ev();
extern void _ZN6S235C34v119Ev();
extern void _ZN6S235C34v120Ev();
extern void _ZN6S235C34v121Ev();
extern void _ZN6S235C34v122Ev();
extern void _ZN6S235C24v123Ev();
extern void _ZN6S235C24v124Ev();
extern void _ZN6S235C24v125Ev();
extern void _ZN6S235C24v126Ev();
extern void _ZN6S235C24v127Ev();
extern void _ZN6S235C24v128Ev();
extern void _ZN6S235C24v129Ev();
extern void _ZN6S235C24v130Ev();
extern void _ZN6S235C24v131Ev();
extern void _ZN6S235C24v132Ev();
extern void _ZN6S235C24v133Ev();
extern void _ZN6S235C24v134Ev();
extern void _ZN6S235C24v135Ev();
extern void _ZN6S235C24v136Ev();
extern void _ZN6S235C12v1Ev();
extern void _ZN6S235C12v2Ev();
extern void _ZN6S235C12v3Ev();
extern void _ZN6S235C12v4Ev();
static  VTBL_ENTRY vtc_S235C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S235C1[0]),
  (VTBL_ENTRY)&_ZN6S235C1D1Ev,
  (VTBL_ENTRY)&_ZN6S235C1D0Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S235C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S235C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S235C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S235C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S235C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S235C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S235C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN6S235C33v96Ev,
  (VTBL_ENTRY)&_ZN6S235C33v97Ev,
  (VTBL_ENTRY)&_ZN6S235C33v98Ev,
  (VTBL_ENTRY)&_ZN6S235C33v99Ev,
  (VTBL_ENTRY)&_ZN6S235C34v100Ev,
  (VTBL_ENTRY)&_ZN6S235C34v101Ev,
  (VTBL_ENTRY)&_ZN6S235C34v102Ev,
  (VTBL_ENTRY)&_ZN6S235C34v103Ev,
  (VTBL_ENTRY)&_ZN6S235C34v104Ev,
  (VTBL_ENTRY)&_ZN6S235C34v105Ev,
  (VTBL_ENTRY)&_ZN6S235C34v106Ev,
  (VTBL_ENTRY)&_ZN6S235C34v107Ev,
  (VTBL_ENTRY)&_ZN6S235C34v108Ev,
  (VTBL_ENTRY)&_ZN6S235C34v109Ev,
  (VTBL_ENTRY)&_ZN6S235C34v110Ev,
  (VTBL_ENTRY)&_ZN6S235C34v111Ev,
  (VTBL_ENTRY)&_ZN6S235C34v112Ev,
  (VTBL_ENTRY)&_ZN6S235C34v113Ev,
  (VTBL_ENTRY)&_ZN6S235C34v114Ev,
  (VTBL_ENTRY)&_ZN6S235C34v115Ev,
  (VTBL_ENTRY)&_ZN6S235C34v116Ev,
  (VTBL_ENTRY)&_ZN6S235C34v117Ev,
  (VTBL_ENTRY)&_ZN6S235C34v118Ev,
  (VTBL_ENTRY)&_ZN6S235C34v119Ev,
  (VTBL_ENTRY)&_ZN6S235C34v120Ev,
  (VTBL_ENTRY)&_ZN6S235C34v121Ev,
  (VTBL_ENTRY)&_ZN6S235C34v122Ev,
  (VTBL_ENTRY)&_ZN6S235C24v123Ev,
  (VTBL_ENTRY)&_ZN6S235C24v124Ev,
  (VTBL_ENTRY)&_ZN6S235C24v125Ev,
  (VTBL_ENTRY)&_ZN6S235C24v126Ev,
  (VTBL_ENTRY)&_ZN6S235C24v127Ev,
  (VTBL_ENTRY)&_ZN6S235C24v128Ev,
  (VTBL_ENTRY)&_ZN6S235C24v129Ev,
  (VTBL_ENTRY)&_ZN6S235C24v130Ev,
  (VTBL_ENTRY)&_ZN6S235C24v131Ev,
  (VTBL_ENTRY)&_ZN6S235C24v132Ev,
  (VTBL_ENTRY)&_ZN6S235C24v133Ev,
  (VTBL_ENTRY)&_ZN6S235C24v134Ev,
  (VTBL_ENTRY)&_ZN6S235C24v135Ev,
  (VTBL_ENTRY)&_ZN6S235C24v136Ev,
  (VTBL_ENTRY)&_ZN6S235C12v1Ev,
  (VTBL_ENTRY)&_ZN6S235C12v2Ev,
  (VTBL_ENTRY)&_ZN6S235C12v3Ev,
  (VTBL_ENTRY)&_ZN6S235C12v4Ev,
};
extern VTBL_ENTRY _ZTI6S235C1[];
extern  VTBL_ENTRY _ZTV6S235C1[];
Class_Descriptor cd_S235C1 = {  "S235C1", // class name
  bases_S235C1, 5,
  &(vtc_S235C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(440,328), // object size
  NSPAIRA(_ZTI6S235C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S235C1),140, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S285C6  {
  int s285c6f0;
  __tsi64 s285c6f1;
  void *s285c6f2[4];
  int s285c6f3[2];
  void *s285c6f4;
  ::S235C7_nt s285c6f5;
  void *s285c6f6[2];
  virtual  ~S285C6(); // _ZN6S285C6D1Ev
  virtual void  v9(); // _ZN6S285C62v9Ev
  virtual void  v10(); // _ZN6S285C63v10Ev
  virtual void  v11(); // _ZN6S285C63v11Ev
  virtual void  v12(); // _ZN6S285C63v12Ev
  virtual void  v13(); // _ZN6S285C63v13Ev
  virtual void  v14(); // _ZN6S285C63v14Ev
  virtual void  v15(); // _ZN6S285C63v15Ev
  virtual void  v16(); // _ZN6S285C63v16Ev
  virtual void  v17(); // _ZN6S285C63v17Ev
  virtual void  v18(); // _ZN6S285C63v18Ev
  virtual void  v19(); // _ZN6S285C63v19Ev
  virtual void  v20(); // _ZN6S285C63v20Ev
  virtual void  v21(); // _ZN6S285C63v21Ev
  virtual void  v22(); // _ZN6S285C63v22Ev
  virtual void  v23(); // _ZN6S285C63v23Ev
  virtual void  v24(); // _ZN6S285C63v24Ev
  virtual void  v25(); // _ZN6S285C63v25Ev
  virtual void  v26(); // _ZN6S285C63v26Ev
  virtual void  v27(); // _ZN6S285C63v27Ev
  virtual void  v28(); // _ZN6S285C63v28Ev
  virtual void  v29(); // _ZN6S285C63v29Ev
  virtual void  v30(); // _ZN6S285C63v30Ev
  virtual void  v31(); // _ZN6S285C63v31Ev
  virtual void  v32(); // _ZN6S285C63v32Ev
  virtual void  v33(); // _ZN6S285C63v33Ev
  virtual void  v34(); // _ZN6S285C63v34Ev
  virtual void  v35(); // _ZN6S285C63v35Ev
  virtual void  v36(); // _ZN6S285C63v36Ev
  virtual void  v37(); // _ZN6S285C63v37Ev
  virtual void  v38(); // _ZN6S285C63v38Ev
  virtual void  v39(); // _ZN6S285C63v39Ev
  virtual void  v40(); // _ZN6S285C63v40Ev
  virtual void  v41(); // _ZN6S285C63v41Ev
  virtual void  v42(); // _ZN6S285C63v42Ev
  virtual void  v43(); // _ZN6S285C63v43Ev
  virtual void  v44(); // _ZN6S285C63v44Ev
  virtual void  v45(); // _ZN6S285C63v45Ev
  virtual void  v46(); // _ZN6S285C63v46Ev
  virtual void  v47(); // _ZN6S285C63v47Ev
  virtual void  v48(); // _ZN6S285C63v48Ev
  virtual void  v49(); // _ZN6S285C63v49Ev
  virtual void  v50(); // _ZN6S285C63v50Ev
  virtual void  v51(); // _ZN6S285C63v51Ev
  virtual void  v52(); // _ZN6S285C63v52Ev
  virtual void  v53(); // _ZN6S285C63v53Ev
  virtual void  v54(); // _ZN6S285C63v54Ev
  virtual void  v55(); // _ZN6S285C63v55Ev
  virtual void  v56(); // _ZN6S285C63v56Ev
  virtual void  v57(); // _ZN6S285C63v57Ev
  virtual void  v58(); // _ZN6S285C63v58Ev
  virtual void  v59(); // _ZN6S285C63v59Ev
  virtual void  v60(); // _ZN6S285C63v60Ev
  virtual void  v61(); // _ZN6S285C63v61Ev
  virtual void  v62(); // _ZN6S285C63v62Ev
  virtual void  v63(); // _ZN6S285C63v63Ev
  virtual void  v64(); // _ZN6S285C63v64Ev
  virtual void  v65(); // _ZN6S285C63v65Ev
  virtual void  v66(); // _ZN6S285C63v66Ev
  virtual void  v67(); // _ZN6S285C63v67Ev
  virtual void  v68(); // _ZN6S285C63v68Ev
  virtual void  v69(); // _ZN6S285C63v69Ev
  virtual void  v70(); // _ZN6S285C63v70Ev
  virtual void  v71(); // _ZN6S285C63v71Ev
  virtual void  v72(); // _ZN6S285C63v72Ev
  S285C6(); // tgen
};
//SIG(-1 S285C6) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S285C6 ::~S285C6(){ note_dtor("S285C6", this);}
void  S285C6 ::v9(){vfunc_called(this, "_ZN6S285C62v9Ev");}
void  S285C6 ::v10(){vfunc_called(this, "_ZN6S285C63v10Ev");}
void  S285C6 ::v11(){vfunc_called(this, "_ZN6S285C63v11Ev");}
void  S285C6 ::v12(){vfunc_called(this, "_ZN6S285C63v12Ev");}
void  S285C6 ::v13(){vfunc_called(this, "_ZN6S285C63v13Ev");}
void  S285C6 ::v14(){vfunc_called(this, "_ZN6S285C63v14Ev");}
void  S285C6 ::v15(){vfunc_called(this, "_ZN6S285C63v15Ev");}
void  S285C6 ::v16(){vfunc_called(this, "_ZN6S285C63v16Ev");}
void  S285C6 ::v17(){vfunc_called(this, "_ZN6S285C63v17Ev");}
void  S285C6 ::v18(){vfunc_called(this, "_ZN6S285C63v18Ev");}
void  S285C6 ::v19(){vfunc_called(this, "_ZN6S285C63v19Ev");}
void  S285C6 ::v20(){vfunc_called(this, "_ZN6S285C63v20Ev");}
void  S285C6 ::v21(){vfunc_called(this, "_ZN6S285C63v21Ev");}
void  S285C6 ::v22(){vfunc_called(this, "_ZN6S285C63v22Ev");}
void  S285C6 ::v23(){vfunc_called(this, "_ZN6S285C63v23Ev");}
void  S285C6 ::v24(){vfunc_called(this, "_ZN6S285C63v24Ev");}
void  S285C6 ::v25(){vfunc_called(this, "_ZN6S285C63v25Ev");}
void  S285C6 ::v26(){vfunc_called(this, "_ZN6S285C63v26Ev");}
void  S285C6 ::v27(){vfunc_called(this, "_ZN6S285C63v27Ev");}
void  S285C6 ::v28(){vfunc_called(this, "_ZN6S285C63v28Ev");}
void  S285C6 ::v29(){vfunc_called(this, "_ZN6S285C63v29Ev");}
void  S285C6 ::v30(){vfunc_called(this, "_ZN6S285C63v30Ev");}
void  S285C6 ::v31(){vfunc_called(this, "_ZN6S285C63v31Ev");}
void  S285C6 ::v32(){vfunc_called(this, "_ZN6S285C63v32Ev");}
void  S285C6 ::v33(){vfunc_called(this, "_ZN6S285C63v33Ev");}
void  S285C6 ::v34(){vfunc_called(this, "_ZN6S285C63v34Ev");}
void  S285C6 ::v35(){vfunc_called(this, "_ZN6S285C63v35Ev");}
void  S285C6 ::v36(){vfunc_called(this, "_ZN6S285C63v36Ev");}
void  S285C6 ::v37(){vfunc_called(this, "_ZN6S285C63v37Ev");}
void  S285C6 ::v38(){vfunc_called(this, "_ZN6S285C63v38Ev");}
void  S285C6 ::v39(){vfunc_called(this, "_ZN6S285C63v39Ev");}
void  S285C6 ::v40(){vfunc_called(this, "_ZN6S285C63v40Ev");}
void  S285C6 ::v41(){vfunc_called(this, "_ZN6S285C63v41Ev");}
void  S285C6 ::v42(){vfunc_called(this, "_ZN6S285C63v42Ev");}
void  S285C6 ::v43(){vfunc_called(this, "_ZN6S285C63v43Ev");}
void  S285C6 ::v44(){vfunc_called(this, "_ZN6S285C63v44Ev");}
void  S285C6 ::v45(){vfunc_called(this, "_ZN6S285C63v45Ev");}
void  S285C6 ::v46(){vfunc_called(this, "_ZN6S285C63v46Ev");}
void  S285C6 ::v47(){vfunc_called(this, "_ZN6S285C63v47Ev");}
void  S285C6 ::v48(){vfunc_called(this, "_ZN6S285C63v48Ev");}
void  S285C6 ::v49(){vfunc_called(this, "_ZN6S285C63v49Ev");}
void  S285C6 ::v50(){vfunc_called(this, "_ZN6S285C63v50Ev");}
void  S285C6 ::v51(){vfunc_called(this, "_ZN6S285C63v51Ev");}
void  S285C6 ::v52(){vfunc_called(this, "_ZN6S285C63v52Ev");}
void  S285C6 ::v53(){vfunc_called(this, "_ZN6S285C63v53Ev");}
void  S285C6 ::v54(){vfunc_called(this, "_ZN6S285C63v54Ev");}
void  S285C6 ::v55(){vfunc_called(this, "_ZN6S285C63v55Ev");}
void  S285C6 ::v56(){vfunc_called(this, "_ZN6S285C63v56Ev");}
void  S285C6 ::v57(){vfunc_called(this, "_ZN6S285C63v57Ev");}
void  S285C6 ::v58(){vfunc_called(this, "_ZN6S285C63v58Ev");}
void  S285C6 ::v59(){vfunc_called(this, "_ZN6S285C63v59Ev");}
void  S285C6 ::v60(){vfunc_called(this, "_ZN6S285C63v60Ev");}
void  S285C6 ::v61(){vfunc_called(this, "_ZN6S285C63v61Ev");}
void  S285C6 ::v62(){vfunc_called(this, "_ZN6S285C63v62Ev");}
void  S285C6 ::v63(){vfunc_called(this, "_ZN6S285C63v63Ev");}
void  S285C6 ::v64(){vfunc_called(this, "_ZN6S285C63v64Ev");}
void  S285C6 ::v65(){vfunc_called(this, "_ZN6S285C63v65Ev");}
void  S285C6 ::v66(){vfunc_called(this, "_ZN6S285C63v66Ev");}
void  S285C6 ::v67(){vfunc_called(this, "_ZN6S285C63v67Ev");}
void  S285C6 ::v68(){vfunc_called(this, "_ZN6S285C63v68Ev");}
void  S285C6 ::v69(){vfunc_called(this, "_ZN6S285C63v69Ev");}
void  S285C6 ::v70(){vfunc_called(this, "_ZN6S285C63v70Ev");}
void  S285C6 ::v71(){vfunc_called(this, "_ZN6S285C63v71Ev");}
void  S285C6 ::v72(){vfunc_called(this, "_ZN6S285C63v72Ev");}
S285C6 ::S285C6(){ note_ctor("S285C6", this);} // tgen

static void Test_S285C6()
{
  extern Class_Descriptor cd_S285C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S285C6, buf);
    S285C6 *dp, &lv = *(dp=new (buf) S285C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S285C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S285C6)");
    check_field_offset(lv, s285c6f0, ABISELECT(8,4), "S285C6.s285c6f0");
    check_field_offset(lv, s285c6f1, ABISELECT(16,8), "S285C6.s285c6f1");
    check_field_offset(lv, s285c6f2, ABISELECT(24,16), "S285C6.s285c6f2");
    check_field_offset(lv, s285c6f3, ABISELECT(56,32), "S285C6.s285c6f3");
    check_field_offset(lv, s285c6f4, ABISELECT(64,40), "S285C6.s285c6f4");
    check_field_offset(lv, s285c6f5, ABISELECT(72,44), "S285C6.s285c6f5");
    check_field_offset(lv, s285c6f6, ABISELECT(80,52), "S285C6.s285c6f6");
    test_class_info(&lv, &cd_S285C6);
    dp->~S285C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS285C6(Test_S285C6, "S285C6", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S285C6C1Ev();
extern void _ZN6S285C6D1Ev();
Name_Map name_map_S285C6[] = {
  NSPAIR(_ZN6S285C6C1Ev),
  NSPAIR(_ZN6S285C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S285C6[];
extern void _ZN6S285C6D1Ev();
extern void _ZN6S285C6D0Ev();
extern void _ZN6S285C62v9Ev();
extern void _ZN6S285C63v10Ev();
extern void _ZN6S285C63v11Ev();
extern void _ZN6S285C63v12Ev();
extern void _ZN6S285C63v13Ev();
extern void _ZN6S285C63v14Ev();
extern void _ZN6S285C63v15Ev();
extern void _ZN6S285C63v16Ev();
extern void _ZN6S285C63v17Ev();
extern void _ZN6S285C63v18Ev();
extern void _ZN6S285C63v19Ev();
extern void _ZN6S285C63v20Ev();
extern void _ZN6S285C63v21Ev();
extern void _ZN6S285C63v22Ev();
extern void _ZN6S285C63v23Ev();
extern void _ZN6S285C63v24Ev();
extern void _ZN6S285C63v25Ev();
extern void _ZN6S285C63v26Ev();
extern void _ZN6S285C63v27Ev();
extern void _ZN6S285C63v28Ev();
extern void _ZN6S285C63v29Ev();
extern void _ZN6S285C63v30Ev();
extern void _ZN6S285C63v31Ev();
extern void _ZN6S285C63v32Ev();
extern void _ZN6S285C63v33Ev();
extern void _ZN6S285C63v34Ev();
extern void _ZN6S285C63v35Ev();
extern void _ZN6S285C63v36Ev();
extern void _ZN6S285C63v37Ev();
extern void _ZN6S285C63v38Ev();
extern void _ZN6S285C63v39Ev();
extern void _ZN6S285C63v40Ev();
extern void _ZN6S285C63v41Ev();
extern void _ZN6S285C63v42Ev();
extern void _ZN6S285C63v43Ev();
extern void _ZN6S285C63v44Ev();
extern void _ZN6S285C63v45Ev();
extern void _ZN6S285C63v46Ev();
extern void _ZN6S285C63v47Ev();
extern void _ZN6S285C63v48Ev();
extern void _ZN6S285C63v49Ev();
extern void _ZN6S285C63v50Ev();
extern void _ZN6S285C63v51Ev();
extern void _ZN6S285C63v52Ev();
extern void _ZN6S285C63v53Ev();
extern void _ZN6S285C63v54Ev();
extern void _ZN6S285C63v55Ev();
extern void _ZN6S285C63v56Ev();
extern void _ZN6S285C63v57Ev();
extern void _ZN6S285C63v58Ev();
extern void _ZN6S285C63v59Ev();
extern void _ZN6S285C63v60Ev();
extern void _ZN6S285C63v61Ev();
extern void _ZN6S285C63v62Ev();
extern void _ZN6S285C63v63Ev();
extern void _ZN6S285C63v64Ev();
extern void _ZN6S285C63v65Ev();
extern void _ZN6S285C63v66Ev();
extern void _ZN6S285C63v67Ev();
extern void _ZN6S285C63v68Ev();
extern void _ZN6S285C63v69Ev();
extern void _ZN6S285C63v70Ev();
extern void _ZN6S285C63v71Ev();
extern void _ZN6S285C63v72Ev();
static  VTBL_ENTRY vtc_S285C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S285C6[0]),
  (VTBL_ENTRY)&_ZN6S285C6D1Ev,
  (VTBL_ENTRY)&_ZN6S285C6D0Ev,
  (VTBL_ENTRY)&_ZN6S285C62v9Ev,
  (VTBL_ENTRY)&_ZN6S285C63v10Ev,
  (VTBL_ENTRY)&_ZN6S285C63v11Ev,
  (VTBL_ENTRY)&_ZN6S285C63v12Ev,
  (VTBL_ENTRY)&_ZN6S285C63v13Ev,
  (VTBL_ENTRY)&_ZN6S285C63v14Ev,
  (VTBL_ENTRY)&_ZN6S285C63v15Ev,
  (VTBL_ENTRY)&_ZN6S285C63v16Ev,
  (VTBL_ENTRY)&_ZN6S285C63v17Ev,
  (VTBL_ENTRY)&_ZN6S285C63v18Ev,
  (VTBL_ENTRY)&_ZN6S285C63v19Ev,
  (VTBL_ENTRY)&_ZN6S285C63v20Ev,
  (VTBL_ENTRY)&_ZN6S285C63v21Ev,
  (VTBL_ENTRY)&_ZN6S285C63v22Ev,
  (VTBL_ENTRY)&_ZN6S285C63v23Ev,
  (VTBL_ENTRY)&_ZN6S285C63v24Ev,
  (VTBL_ENTRY)&_ZN6S285C63v25Ev,
  (VTBL_ENTRY)&_ZN6S285C63v26Ev,
  (VTBL_ENTRY)&_ZN6S285C63v27Ev,
  (VTBL_ENTRY)&_ZN6S285C63v28Ev,
  (VTBL_ENTRY)&_ZN6S285C63v29Ev,
  (VTBL_ENTRY)&_ZN6S285C63v30Ev,
  (VTBL_ENTRY)&_ZN6S285C63v31Ev,
  (VTBL_ENTRY)&_ZN6S285C63v32Ev,
  (VTBL_ENTRY)&_ZN6S285C63v33Ev,
  (VTBL_ENTRY)&_ZN6S285C63v34Ev,
  (VTBL_ENTRY)&_ZN6S285C63v35Ev,
  (VTBL_ENTRY)&_ZN6S285C63v36Ev,
  (VTBL_ENTRY)&_ZN6S285C63v37Ev,
  (VTBL_ENTRY)&_ZN6S285C63v38Ev,
  (VTBL_ENTRY)&_ZN6S285C63v39Ev,
  (VTBL_ENTRY)&_ZN6S285C63v40Ev,
  (VTBL_ENTRY)&_ZN6S285C63v41Ev,
  (VTBL_ENTRY)&_ZN6S285C63v42Ev,
  (VTBL_ENTRY)&_ZN6S285C63v43Ev,
  (VTBL_ENTRY)&_ZN6S285C63v44Ev,
  (VTBL_ENTRY)&_ZN6S285C63v45Ev,
  (VTBL_ENTRY)&_ZN6S285C63v46Ev,
  (VTBL_ENTRY)&_ZN6S285C63v47Ev,
  (VTBL_ENTRY)&_ZN6S285C63v48Ev,
  (VTBL_ENTRY)&_ZN6S285C63v49Ev,
  (VTBL_ENTRY)&_ZN6S285C63v50Ev,
  (VTBL_ENTRY)&_ZN6S285C63v51Ev,
  (VTBL_ENTRY)&_ZN6S285C63v52Ev,
  (VTBL_ENTRY)&_ZN6S285C63v53Ev,
  (VTBL_ENTRY)&_ZN6S285C63v54Ev,
  (VTBL_ENTRY)&_ZN6S285C63v55Ev,
  (VTBL_ENTRY)&_ZN6S285C63v56Ev,
  (VTBL_ENTRY)&_ZN6S285C63v57Ev,
  (VTBL_ENTRY)&_ZN6S285C63v58Ev,
  (VTBL_ENTRY)&_ZN6S285C63v59Ev,
  (VTBL_ENTRY)&_ZN6S285C63v60Ev,
  (VTBL_ENTRY)&_ZN6S285C63v61Ev,
  (VTBL_ENTRY)&_ZN6S285C63v62Ev,
  (VTBL_ENTRY)&_ZN6S285C63v63Ev,
  (VTBL_ENTRY)&_ZN6S285C63v64Ev,
  (VTBL_ENTRY)&_ZN6S285C63v65Ev,
  (VTBL_ENTRY)&_ZN6S285C63v66Ev,
  (VTBL_ENTRY)&_ZN6S285C63v67Ev,
  (VTBL_ENTRY)&_ZN6S285C63v68Ev,
  (VTBL_ENTRY)&_ZN6S285C63v69Ev,
  (VTBL_ENTRY)&_ZN6S285C63v70Ev,
  (VTBL_ENTRY)&_ZN6S285C63v71Ev,
  (VTBL_ENTRY)&_ZN6S285C63v72Ev,
};
extern VTBL_ENTRY _ZTI6S285C6[];
extern  VTBL_ENTRY _ZTV6S285C6[];
Class_Descriptor cd_S285C6 = {  "S285C6", // class name
  0,0,//no base classes
  &(vtc_S285C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S285C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S285C6),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S285C5  : S285C6 {
  void *s285c5f0;
  ::S235C7_nt s285c5f1;
  virtual  ~S285C5(); // _ZN6S285C5D1Ev
  virtual void  v73(); // _ZN6S285C53v73Ev
  virtual void  v74(); // _ZN6S285C53v74Ev
  virtual void  v75(); // _ZN6S285C53v75Ev
  virtual void  v76(); // _ZN6S285C53v76Ev
  virtual void  v77(); // _ZN6S285C53v77Ev
  S285C5(); // tgen
};
//SIG(-1 S285C5) C1{ BC2{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 Fp FC3}


 S285C5 ::~S285C5(){ note_dtor("S285C5", this);}
void  S285C5 ::v73(){vfunc_called(this, "_ZN6S285C53v73Ev");}
void  S285C5 ::v74(){vfunc_called(this, "_ZN6S285C53v74Ev");}
void  S285C5 ::v75(){vfunc_called(this, "_ZN6S285C53v75Ev");}
void  S285C5 ::v76(){vfunc_called(this, "_ZN6S285C53v76Ev");}
void  S285C5 ::v77(){vfunc_called(this, "_ZN6S285C53v77Ev");}
S285C5 ::S285C5(){ note_ctor("S285C5", this);} // tgen

static void Test_S285C5()
{
  extern Class_Descriptor cd_S285C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,19)];
    init_test(&cd_S285C5, buf);
    S285C5 *dp, &lv = *(dp=new (buf) S285C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,72), "sizeof(S285C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S285C5)");
    check_base_class_offset(lv, (S285C6*), 0, "S285C5");
    check_field_offset(lv, s285c5f0, ABISELECT(96,60), "S285C5.s285c5f0");
    check_field_offset(lv, s285c5f1, ABISELECT(104,64), "S285C5.s285c5f1");
    test_class_info(&lv, &cd_S285C5);
    dp->~S285C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS285C5(Test_S285C5, "S285C5", ABISELECT(112,72));

#else // __cplusplus

extern void _ZN6S285C5C1Ev();
extern void _ZN6S285C5D1Ev();
Name_Map name_map_S285C5[] = {
  NSPAIR(_ZN6S285C5C1Ev),
  NSPAIR(_ZN6S285C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S285C6;
extern VTBL_ENTRY _ZTI6S285C6[];
extern  VTBL_ENTRY _ZTV6S285C6[];
static Base_Class bases_S285C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S285C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S285C5[];
extern void _ZN6S285C5D1Ev();
extern void _ZN6S285C5D0Ev();
extern void _ZN6S285C62v9Ev();
extern void _ZN6S285C63v10Ev();
extern void _ZN6S285C63v11Ev();
extern void _ZN6S285C63v12Ev();
extern void _ZN6S285C63v13Ev();
extern void _ZN6S285C63v14Ev();
extern void _ZN6S285C63v15Ev();
extern void _ZN6S285C63v16Ev();
extern void _ZN6S285C63v17Ev();
extern void _ZN6S285C63v18Ev();
extern void _ZN6S285C63v19Ev();
extern void _ZN6S285C63v20Ev();
extern void _ZN6S285C63v21Ev();
extern void _ZN6S285C63v22Ev();
extern void _ZN6S285C63v23Ev();
extern void _ZN6S285C63v24Ev();
extern void _ZN6S285C63v25Ev();
extern void _ZN6S285C63v26Ev();
extern void _ZN6S285C63v27Ev();
extern void _ZN6S285C63v28Ev();
extern void _ZN6S285C63v29Ev();
extern void _ZN6S285C63v30Ev();
extern void _ZN6S285C63v31Ev();
extern void _ZN6S285C63v32Ev();
extern void _ZN6S285C63v33Ev();
extern void _ZN6S285C63v34Ev();
extern void _ZN6S285C63v35Ev();
extern void _ZN6S285C63v36Ev();
extern void _ZN6S285C63v37Ev();
extern void _ZN6S285C63v38Ev();
extern void _ZN6S285C63v39Ev();
extern void _ZN6S285C63v40Ev();
extern void _ZN6S285C63v41Ev();
extern void _ZN6S285C63v42Ev();
extern void _ZN6S285C63v43Ev();
extern void _ZN6S285C63v44Ev();
extern void _ZN6S285C63v45Ev();
extern void _ZN6S285C63v46Ev();
extern void _ZN6S285C63v47Ev();
extern void _ZN6S285C63v48Ev();
extern void _ZN6S285C63v49Ev();
extern void _ZN6S285C63v50Ev();
extern void _ZN6S285C63v51Ev();
extern void _ZN6S285C63v52Ev();
extern void _ZN6S285C63v53Ev();
extern void _ZN6S285C63v54Ev();
extern void _ZN6S285C63v55Ev();
extern void _ZN6S285C63v56Ev();
extern void _ZN6S285C63v57Ev();
extern void _ZN6S285C63v58Ev();
extern void _ZN6S285C63v59Ev();
extern void _ZN6S285C63v60Ev();
extern void _ZN6S285C63v61Ev();
extern void _ZN6S285C63v62Ev();
extern void _ZN6S285C63v63Ev();
extern void _ZN6S285C63v64Ev();
extern void _ZN6S285C63v65Ev();
extern void _ZN6S285C63v66Ev();
extern void _ZN6S285C63v67Ev();
extern void _ZN6S285C63v68Ev();
extern void _ZN6S285C63v69Ev();
extern void _ZN6S285C63v70Ev();
extern void _ZN6S285C63v71Ev();
extern void _ZN6S285C63v72Ev();
extern void _ZN6S285C53v73Ev();
extern void _ZN6S285C53v74Ev();
extern void _ZN6S285C53v75Ev();
extern void _ZN6S285C53v76Ev();
extern void _ZN6S285C53v77Ev();
static  VTBL_ENTRY vtc_S285C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S285C5[0]),
  (VTBL_ENTRY)&_ZN6S285C5D1Ev,
  (VTBL_ENTRY)&_ZN6S285C5D0Ev,
  (VTBL_ENTRY)&_ZN6S285C62v9Ev,
  (VTBL_ENTRY)&_ZN6S285C63v10Ev,
  (VTBL_ENTRY)&_ZN6S285C63v11Ev,
  (VTBL_ENTRY)&_ZN6S285C63v12Ev,
  (VTBL_ENTRY)&_ZN6S285C63v13Ev,
  (VTBL_ENTRY)&_ZN6S285C63v14Ev,
  (VTBL_ENTRY)&_ZN6S285C63v15Ev,
  (VTBL_ENTRY)&_ZN6S285C63v16Ev,
  (VTBL_ENTRY)&_ZN6S285C63v17Ev,
  (VTBL_ENTRY)&_ZN6S285C63v18Ev,
  (VTBL_ENTRY)&_ZN6S285C63v19Ev,
  (VTBL_ENTRY)&_ZN6S285C63v20Ev,
  (VTBL_ENTRY)&_ZN6S285C63v21Ev,
  (VTBL_ENTRY)&_ZN6S285C63v22Ev,
  (VTBL_ENTRY)&_ZN6S285C63v23Ev,
  (VTBL_ENTRY)&_ZN6S285C63v24Ev,
  (VTBL_ENTRY)&_ZN6S285C63v25Ev,
  (VTBL_ENTRY)&_ZN6S285C63v26Ev,
  (VTBL_ENTRY)&_ZN6S285C63v27Ev,
  (VTBL_ENTRY)&_ZN6S285C63v28Ev,
  (VTBL_ENTRY)&_ZN6S285C63v29Ev,
  (VTBL_ENTRY)&_ZN6S285C63v30Ev,
  (VTBL_ENTRY)&_ZN6S285C63v31Ev,
  (VTBL_ENTRY)&_ZN6S285C63v32Ev,
  (VTBL_ENTRY)&_ZN6S285C63v33Ev,
  (VTBL_ENTRY)&_ZN6S285C63v34Ev,
  (VTBL_ENTRY)&_ZN6S285C63v35Ev,
  (VTBL_ENTRY)&_ZN6S285C63v36Ev,
  (VTBL_ENTRY)&_ZN6S285C63v37Ev,
  (VTBL_ENTRY)&_ZN6S285C63v38Ev,
  (VTBL_ENTRY)&_ZN6S285C63v39Ev,
  (VTBL_ENTRY)&_ZN6S285C63v40Ev,
  (VTBL_ENTRY)&_ZN6S285C63v41Ev,
  (VTBL_ENTRY)&_ZN6S285C63v42Ev,
  (VTBL_ENTRY)&_ZN6S285C63v43Ev,
  (VTBL_ENTRY)&_ZN6S285C63v44Ev,
  (VTBL_ENTRY)&_ZN6S285C63v45Ev,
  (VTBL_ENTRY)&_ZN6S285C63v46Ev,
  (VTBL_ENTRY)&_ZN6S285C63v47Ev,
  (VTBL_ENTRY)&_ZN6S285C63v48Ev,
  (VTBL_ENTRY)&_ZN6S285C63v49Ev,
  (VTBL_ENTRY)&_ZN6S285C63v50Ev,
  (VTBL_ENTRY)&_ZN6S285C63v51Ev,
  (VTBL_ENTRY)&_ZN6S285C63v52Ev,
  (VTBL_ENTRY)&_ZN6S285C63v53Ev,
  (VTBL_ENTRY)&_ZN6S285C63v54Ev,
  (VTBL_ENTRY)&_ZN6S285C63v55Ev,
  (VTBL_ENTRY)&_ZN6S285C63v56Ev,
  (VTBL_ENTRY)&_ZN6S285C63v57Ev,
  (VTBL_ENTRY)&_ZN6S285C63v58Ev,
  (VTBL_ENTRY)&_ZN6S285C63v59Ev,
  (VTBL_ENTRY)&_ZN6S285C63v60Ev,
  (VTBL_ENTRY)&_ZN6S285C63v61Ev,
  (VTBL_ENTRY)&_ZN6S285C63v62Ev,
  (VTBL_ENTRY)&_ZN6S285C63v63Ev,
  (VTBL_ENTRY)&_ZN6S285C63v64Ev,
  (VTBL_ENTRY)&_ZN6S285C63v65Ev,
  (VTBL_ENTRY)&_ZN6S285C63v66Ev,
  (VTBL_ENTRY)&_ZN6S285C63v67Ev,
  (VTBL_ENTRY)&_ZN6S285C63v68Ev,
  (VTBL_ENTRY)&_ZN6S285C63v69Ev,
  (VTBL_ENTRY)&_ZN6S285C63v70Ev,
  (VTBL_ENTRY)&_ZN6S285C63v71Ev,
  (VTBL_ENTRY)&_ZN6S285C63v72Ev,
  (VTBL_ENTRY)&_ZN6S285C53v73Ev,
  (VTBL_ENTRY)&_ZN6S285C53v74Ev,
  (VTBL_ENTRY)&_ZN6S285C53v75Ev,
  (VTBL_ENTRY)&_ZN6S285C53v76Ev,
  (VTBL_ENTRY)&_ZN6S285C53v77Ev,
};
extern VTBL_ENTRY _ZTI6S285C5[];
extern  VTBL_ENTRY _ZTV6S285C5[];
Class_Descriptor cd_S285C5 = {  "S285C5", // class name
  bases_S285C5, 1,
  &(vtc_S285C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,72), // object size
  NSPAIRA(_ZTI6S285C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S285C5),73, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S285C4  : S285C5 {
  void *s285c4f0[2];
  unsigned int s285c4f1:1;
  unsigned int s285c4f2:1;
  unsigned int s285c4f3:1;
  unsigned int s285c4f4:1;
  char s285c4f5;
  virtual  ~S285C4(); // _ZN6S285C4D1Ev
  virtual void  v78(); // _ZN6S285C43v78Ev
  virtual void  v79(); // _ZN6S285C43v79Ev
  virtual void  v80(); // _ZN6S285C43v80Ev
  virtual void  v81(); // _ZN6S285C43v81Ev
  virtual void  v82(); // _ZN6S285C43v82Ev
  virtual void  v83(); // _ZN6S285C43v83Ev
  virtual void  v84(); // _ZN6S285C43v84Ev
  virtual void  v85(); // _ZN6S285C43v85Ev
  virtual void  v86(); // _ZN6S285C43v86Ev
  virtual void  v87(); // _ZN6S285C43v87Ev
  virtual void  v88(); // _ZN6S285C43v88Ev
  virtual void  v89(); // _ZN6S285C43v89Ev
  virtual void  v90(); // _ZN6S285C43v90Ev
  virtual void  v91(); // _ZN6S285C43v91Ev
  virtual void  v92(); // _ZN6S285C43v92Ev
  virtual void  v93(); // _ZN6S285C43v93Ev
  virtual void  v94(); // _ZN6S285C43v94Ev
  virtual void  v95(); // _ZN6S285C43v95Ev
  virtual void  v96(); // _ZN6S285C43v96Ev
  virtual void  v97(); // _ZN6S285C43v97Ev
  virtual void  v98(); // _ZN6S285C43v98Ev
  virtual void  v99(); // _ZN6S285C43v99Ev
  S285C4(); // tgen
};
//SIG(-1 S285C4) C1{ BC2{ BC3{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v87 v88 v89 v90 v91 Fp FC4} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc}


 S285C4 ::~S285C4(){ note_dtor("S285C4", this);}
void  S285C4 ::v78(){vfunc_called(this, "_ZN6S285C43v78Ev");}
void  S285C4 ::v79(){vfunc_called(this, "_ZN6S285C43v79Ev");}
void  S285C4 ::v80(){vfunc_called(this, "_ZN6S285C43v80Ev");}
void  S285C4 ::v81(){vfunc_called(this, "_ZN6S285C43v81Ev");}
void  S285C4 ::v82(){vfunc_called(this, "_ZN6S285C43v82Ev");}
void  S285C4 ::v83(){vfunc_called(this, "_ZN6S285C43v83Ev");}
void  S285C4 ::v84(){vfunc_called(this, "_ZN6S285C43v84Ev");}
void  S285C4 ::v85(){vfunc_called(this, "_ZN6S285C43v85Ev");}
void  S285C4 ::v86(){vfunc_called(this, "_ZN6S285C43v86Ev");}
void  S285C4 ::v87(){vfunc_called(this, "_ZN6S285C43v87Ev");}
void  S285C4 ::v88(){vfunc_called(this, "_ZN6S285C43v88Ev");}
void  S285C4 ::v89(){vfunc_called(this, "_ZN6S285C43v89Ev");}
void  S285C4 ::v90(){vfunc_called(this, "_ZN6S285C43v90Ev");}
void  S285C4 ::v91(){vfunc_called(this, "_ZN6S285C43v91Ev");}
void  S285C4 ::v92(){vfunc_called(this, "_ZN6S285C43v92Ev");}
void  S285C4 ::v93(){vfunc_called(this, "_ZN6S285C43v93Ev");}
void  S285C4 ::v94(){vfunc_called(this, "_ZN6S285C43v94Ev");}
void  S285C4 ::v95(){vfunc_called(this, "_ZN6S285C43v95Ev");}
void  S285C4 ::v96(){vfunc_called(this, "_ZN6S285C43v96Ev");}
void  S285C4 ::v97(){vfunc_called(this, "_ZN6S285C43v97Ev");}
void  S285C4 ::v98(){vfunc_called(this, "_ZN6S285C43v98Ev");}
void  S285C4 ::v99(){vfunc_called(this, "_ZN6S285C43v99Ev");}
S285C4 ::S285C4(){ note_ctor("S285C4", this);} // tgen

static void Test_S285C4()
{
  extern Class_Descriptor cd_S285C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,22)];
    init_test(&cd_S285C4, buf);
    S285C4 *dp, &lv = *(dp=new (buf) S285C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,84), "sizeof(S285C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S285C4)");
    check_base_class_offset(lv, (S285C6*)(S285C5*), 0, "S285C4");
    check_base_class_offset(lv, (S285C5*), 0, "S285C4");
    check_field_offset(lv, s285c4f0, ABISELECT(112,72), "S285C4.s285c4f0");
    set_bf_and_test(lv, s285c4f1, ABISELECT(128,80), 0, 1, 1, "S285C4");
    set_bf_and_test(lv, s285c4f2, ABISELECT(128,80), 1, 1, 1, "S285C4");
    set_bf_and_test(lv, s285c4f3, ABISELECT(128,80), 2, 1, 1, "S285C4");
    set_bf_and_test(lv, s285c4f4, ABISELECT(128,80), 3, 1, 1, "S285C4");
    check_field_offset(lv, s285c4f5, ABISELECT(129,81), "S285C4.s285c4f5");
    test_class_info(&lv, &cd_S285C4);
    dp->~S285C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS285C4(Test_S285C4, "S285C4", ABISELECT(136,84));

#else // __cplusplus

extern void _ZN6S285C4C1Ev();
extern void _ZN6S285C4D1Ev();
Name_Map name_map_S285C4[] = {
  NSPAIR(_ZN6S285C4C1Ev),
  NSPAIR(_ZN6S285C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S285C6;
extern VTBL_ENTRY _ZTI6S285C6[];
extern  VTBL_ENTRY _ZTV6S285C6[];
extern Class_Descriptor cd_S285C5;
extern VTBL_ENTRY _ZTI6S285C5[];
extern  VTBL_ENTRY _ZTV6S285C5[];
static Base_Class bases_S285C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S285C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S285C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S285C4[];
extern void _ZN6S285C4D1Ev();
extern void _ZN6S285C4D0Ev();
extern void _ZN6S285C62v9Ev();
extern void _ZN6S285C63v10Ev();
extern void _ZN6S285C63v11Ev();
extern void _ZN6S285C63v12Ev();
extern void _ZN6S285C63v13Ev();
extern void _ZN6S285C63v14Ev();
extern void _ZN6S285C63v15Ev();
extern void _ZN6S285C63v16Ev();
extern void _ZN6S285C63v17Ev();
extern void _ZN6S285C63v18Ev();
extern void _ZN6S285C63v19Ev();
extern void _ZN6S285C63v20Ev();
extern void _ZN6S285C63v21Ev();
extern void _ZN6S285C63v22Ev();
extern void _ZN6S285C63v23Ev();
extern void _ZN6S285C63v24Ev();
extern void _ZN6S285C63v25Ev();
extern void _ZN6S285C63v26Ev();
extern void _ZN6S285C63v27Ev();
extern void _ZN6S285C63v28Ev();
extern void _ZN6S285C63v29Ev();
extern void _ZN6S285C63v30Ev();
extern void _ZN6S285C63v31Ev();
extern void _ZN6S285C63v32Ev();
extern void _ZN6S285C63v33Ev();
extern void _ZN6S285C63v34Ev();
extern void _ZN6S285C63v35Ev();
extern void _ZN6S285C63v36Ev();
extern void _ZN6S285C63v37Ev();
extern void _ZN6S285C63v38Ev();
extern void _ZN6S285C63v39Ev();
extern void _ZN6S285C63v40Ev();
extern void _ZN6S285C63v41Ev();
extern void _ZN6S285C63v42Ev();
extern void _ZN6S285C63v43Ev();
extern void _ZN6S285C63v44Ev();
extern void _ZN6S285C63v45Ev();
extern void _ZN6S285C63v46Ev();
extern void _ZN6S285C63v47Ev();
extern void _ZN6S285C63v48Ev();
extern void _ZN6S285C63v49Ev();
extern void _ZN6S285C63v50Ev();
extern void _ZN6S285C63v51Ev();
extern void _ZN6S285C63v52Ev();
extern void _ZN6S285C63v53Ev();
extern void _ZN6S285C63v54Ev();
extern void _ZN6S285C63v55Ev();
extern void _ZN6S285C63v56Ev();
extern void _ZN6S285C63v57Ev();
extern void _ZN6S285C63v58Ev();
extern void _ZN6S285C63v59Ev();
extern void _ZN6S285C63v60Ev();
extern void _ZN6S285C63v61Ev();
extern void _ZN6S285C63v62Ev();
extern void _ZN6S285C63v63Ev();
extern void _ZN6S285C63v64Ev();
extern void _ZN6S285C63v65Ev();
extern void _ZN6S285C63v66Ev();
extern void _ZN6S285C63v67Ev();
extern void _ZN6S285C63v68Ev();
extern void _ZN6S285C63v69Ev();
extern void _ZN6S285C63v70Ev();
extern void _ZN6S285C63v71Ev();
extern void _ZN6S285C63v72Ev();
extern void _ZN6S285C53v73Ev();
extern void _ZN6S285C53v74Ev();
extern void _ZN6S285C53v75Ev();
extern void _ZN6S285C53v76Ev();
extern void _ZN6S285C53v77Ev();
extern void _ZN6S285C43v78Ev();
extern void _ZN6S285C43v79Ev();
extern void _ZN6S285C43v80Ev();
extern void _ZN6S285C43v81Ev();
extern void _ZN6S285C43v82Ev();
extern void _ZN6S285C43v83Ev();
extern void _ZN6S285C43v84Ev();
extern void _ZN6S285C43v85Ev();
extern void _ZN6S285C43v86Ev();
extern void _ZN6S285C43v87Ev();
extern void _ZN6S285C43v88Ev();
extern void _ZN6S285C43v89Ev();
extern void _ZN6S285C43v90Ev();
extern void _ZN6S285C43v91Ev();
extern void _ZN6S285C43v92Ev();
extern void _ZN6S285C43v93Ev();
extern void _ZN6S285C43v94Ev();
extern void _ZN6S285C43v95Ev();
extern void _ZN6S285C43v96Ev();
extern void _ZN6S285C43v97Ev();
extern void _ZN6S285C43v98Ev();
extern void _ZN6S285C43v99Ev();
static  VTBL_ENTRY vtc_S285C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S285C4[0]),
  (VTBL_ENTRY)&_ZN6S285C4D1Ev,
  (VTBL_ENTRY)&_ZN6S285C4D0Ev,
  (VTBL_ENTRY)&_ZN6S285C62v9Ev,
  (VTBL_ENTRY)&_ZN6S285C63v10Ev,
  (VTBL_ENTRY)&_ZN6S285C63v11Ev,
  (VTBL_ENTRY)&_ZN6S285C63v12Ev,
  (VTBL_ENTRY)&_ZN6S285C63v13Ev,
  (VTBL_ENTRY)&_ZN6S285C63v14Ev,
  (VTBL_ENTRY)&_ZN6S285C63v15Ev,
  (VTBL_ENTRY)&_ZN6S285C63v16Ev,
  (VTBL_ENTRY)&_ZN6S285C63v17Ev,
  (VTBL_ENTRY)&_ZN6S285C63v18Ev,
  (VTBL_ENTRY)&_ZN6S285C63v19Ev,
  (VTBL_ENTRY)&_ZN6S285C63v20Ev,
  (VTBL_ENTRY)&_ZN6S285C63v21Ev,
  (VTBL_ENTRY)&_ZN6S285C63v22Ev,
  (VTBL_ENTRY)&_ZN6S285C63v23Ev,
  (VTBL_ENTRY)&_ZN6S285C63v24Ev,
  (VTBL_ENTRY)&_ZN6S285C63v25Ev,
  (VTBL_ENTRY)&_ZN6S285C63v26Ev,
  (VTBL_ENTRY)&_ZN6S285C63v27Ev,
  (VTBL_ENTRY)&_ZN6S285C63v28Ev,
  (VTBL_ENTRY)&_ZN6S285C63v29Ev,
  (VTBL_ENTRY)&_ZN6S285C63v30Ev,
  (VTBL_ENTRY)&_ZN6S285C63v31Ev,
  (VTBL_ENTRY)&_ZN6S285C63v32Ev,
  (VTBL_ENTRY)&_ZN6S285C63v33Ev,
  (VTBL_ENTRY)&_ZN6S285C63v34Ev,
  (VTBL_ENTRY)&_ZN6S285C63v35Ev,
  (VTBL_ENTRY)&_ZN6S285C63v36Ev,
  (VTBL_ENTRY)&_ZN6S285C63v37Ev,
  (VTBL_ENTRY)&_ZN6S285C63v38Ev,
  (VTBL_ENTRY)&_ZN6S285C63v39Ev,
  (VTBL_ENTRY)&_ZN6S285C63v40Ev,
  (VTBL_ENTRY)&_ZN6S285C63v41Ev,
  (VTBL_ENTRY)&_ZN6S285C63v42Ev,
  (VTBL_ENTRY)&_ZN6S285C63v43Ev,
  (VTBL_ENTRY)&_ZN6S285C63v44Ev,
  (VTBL_ENTRY)&_ZN6S285C63v45Ev,
  (VTBL_ENTRY)&_ZN6S285C63v46Ev,
  (VTBL_ENTRY)&_ZN6S285C63v47Ev,
  (VTBL_ENTRY)&_ZN6S285C63v48Ev,
  (VTBL_ENTRY)&_ZN6S285C63v49Ev,
  (VTBL_ENTRY)&_ZN6S285C63v50Ev,
  (VTBL_ENTRY)&_ZN6S285C63v51Ev,
  (VTBL_ENTRY)&_ZN6S285C63v52Ev,
  (VTBL_ENTRY)&_ZN6S285C63v53Ev,
  (VTBL_ENTRY)&_ZN6S285C63v54Ev,
  (VTBL_ENTRY)&_ZN6S285C63v55Ev,
  (VTBL_ENTRY)&_ZN6S285C63v56Ev,
  (VTBL_ENTRY)&_ZN6S285C63v57Ev,
  (VTBL_ENTRY)&_ZN6S285C63v58Ev,
  (VTBL_ENTRY)&_ZN6S285C63v59Ev,
  (VTBL_ENTRY)&_ZN6S285C63v60Ev,
  (VTBL_ENTRY)&_ZN6S285C63v61Ev,
  (VTBL_ENTRY)&_ZN6S285C63v62Ev,
  (VTBL_ENTRY)&_ZN6S285C63v63Ev,
  (VTBL_ENTRY)&_ZN6S285C63v64Ev,
  (VTBL_ENTRY)&_ZN6S285C63v65Ev,
  (VTBL_ENTRY)&_ZN6S285C63v66Ev,
  (VTBL_ENTRY)&_ZN6S285C63v67Ev,
  (VTBL_ENTRY)&_ZN6S285C63v68Ev,
  (VTBL_ENTRY)&_ZN6S285C63v69Ev,
  (VTBL_ENTRY)&_ZN6S285C63v70Ev,
  (VTBL_ENTRY)&_ZN6S285C63v71Ev,
  (VTBL_ENTRY)&_ZN6S285C63v72Ev,
  (VTBL_ENTRY)&_ZN6S285C53v73Ev,
  (VTBL_ENTRY)&_ZN6S285C53v74Ev,
  (VTBL_ENTRY)&_ZN6S285C53v75Ev,
  (VTBL_ENTRY)&_ZN6S285C53v76Ev,
  (VTBL_ENTRY)&_ZN6S285C53v77Ev,
  (VTBL_ENTRY)&_ZN6S285C43v78Ev,
  (VTBL_ENTRY)&_ZN6S285C43v79Ev,
  (VTBL_ENTRY)&_ZN6S285C43v80Ev,
  (VTBL_ENTRY)&_ZN6S285C43v81Ev,
  (VTBL_ENTRY)&_ZN6S285C43v82Ev,
  (VTBL_ENTRY)&_ZN6S285C43v83Ev,
  (VTBL_ENTRY)&_ZN6S285C43v84Ev,
  (VTBL_ENTRY)&_ZN6S285C43v85Ev,
  (VTBL_ENTRY)&_ZN6S285C43v86Ev,
  (VTBL_ENTRY)&_ZN6S285C43v87Ev,
  (VTBL_ENTRY)&_ZN6S285C43v88Ev,
  (VTBL_ENTRY)&_ZN6S285C43v89Ev,
  (VTBL_ENTRY)&_ZN6S285C43v90Ev,
  (VTBL_ENTRY)&_ZN6S285C43v91Ev,
  (VTBL_ENTRY)&_ZN6S285C43v92Ev,
  (VTBL_ENTRY)&_ZN6S285C43v93Ev,
  (VTBL_ENTRY)&_ZN6S285C43v94Ev,
  (VTBL_ENTRY)&_ZN6S285C43v95Ev,
  (VTBL_ENTRY)&_ZN6S285C43v96Ev,
  (VTBL_ENTRY)&_ZN6S285C43v97Ev,
  (VTBL_ENTRY)&_ZN6S285C43v98Ev,
  (VTBL_ENTRY)&_ZN6S285C43v99Ev,
};
extern VTBL_ENTRY _ZTI6S285C4[];
extern  VTBL_ENTRY _ZTV6S285C4[];
Class_Descriptor cd_S285C4 = {  "S285C4", // class name
  bases_S285C4, 2,
  &(vtc_S285C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,84), // object size
  NSPAIRA(_ZTI6S285C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S285C4),95, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S285C18  : S235C13_nt {
};
//SIG(-1 S285C18) C1{ BC2{ m Fp Fi[2]}}



static void Test_S285C18()
{
  extern Class_Descriptor cd_S285C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S285C18, buf);
    S285C18 &lv = *(new (buf) S285C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S285C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S285C18)");
    check_base_class_offset(lv, (S235C13_nt*), 0, "S285C18");
    test_class_info(&lv, &cd_S285C18);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS285C18(Test_S285C18, "S285C18", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S235C13_nt;
static Base_Class bases_S285C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S235C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S285C18 = {  "S285C18", // class name
  bases_S285C18, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S285C17  : S285C18 {
};
//SIG(-1 S285C17) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S285C17()
{
  extern Class_Descriptor cd_S285C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S285C17, buf);
    S285C17 &lv = *(new (buf) S285C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S285C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S285C17)");
    check_base_class_offset(lv, (S235C13_nt*)(S285C18*), 0, "S285C17");
    check_base_class_offset(lv, (S285C18*), 0, "S285C17");
    test_class_info(&lv, &cd_S285C17);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS285C17(Test_S285C17, "S285C17", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S235C13_nt;
extern Class_Descriptor cd_S285C18;
static Base_Class bases_S285C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S235C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S285C18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S285C17 = {  "S285C17", // class name
  bases_S285C17, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S285C19  {
  int s285c19f0[4];
  void  mf285c19(); // _ZN7S285C198mf285c19Ev
};
//SIG(-1 S285C19) C1{ m Fi[4]}


void  S285C19 ::mf285c19(){}

static void Test_S285C19()
{
  {
    init_simple_test("S285C19");
    S285C19 lv;
    check2(sizeof(lv), 16, "sizeof(S285C19)");
    check2(__alignof__(lv), 4, "__alignof__(S285C19)");
    check_field_offset(lv, s285c19f0, 0, "S285C19.s285c19f0");
  }
}
static Arrange_To_Call_Me vS285C19(Test_S285C19, "S285C19", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S285C3  : S285C4 {
  void *s285c3f0;
  ::S836C39 s285c3f1;
  ::S836C39 s285c3f2;
  ::S235C9_nt s285c3f3;
  ::S235C9_nt s285c3f4;
  int s285c3f5;
  ::S836C29 s285c3f6;
  void *s285c3f7;
  unsigned int s285c3f8:1;
  unsigned int s285c3f9:1;
  unsigned int s285c3f10:1;
  unsigned int s285c3f11:1;
  unsigned int s285c3f12:1;
  unsigned int s285c3f13:1;
  unsigned int s285c3f14:1;
  unsigned int s285c3f15:1;
  unsigned int s285c3f16:1;
  unsigned int s285c3f17:1;
  unsigned int s285c3f18:1;
  void *s285c3f19;
  ::S235C17 s285c3f20;
  ::S836C25 s285c3f21;
  unsigned int s285c3f22:1;
  ::S235C11_nt s285c3f23;
  ::S235C11_nt s285c3f24;
  ::S285C17 s285c3f25;
  ::S285C17 s285c3f26;
  char s285c3f27[2];
  ::S285C19 s285c3f28;
  int s285c3f29[3];
  char s285c3f30[2];
  int s285c3f31[2];
  virtual  ~S285C3(); // _ZN6S285C3D1Ev
  virtual void  v100(); // _ZN6S285C34v100Ev
  virtual void  v101(); // _ZN6S285C34v101Ev
  virtual void  v102(); // _ZN6S285C34v102Ev
  virtual void  v103(); // _ZN6S285C34v103Ev
  virtual void  v104(); // _ZN6S285C34v104Ev
  virtual void  v105(); // _ZN6S285C34v105Ev
  virtual void  v106(); // _ZN6S285C34v106Ev
  virtual void  v107(); // _ZN6S285C34v107Ev
  virtual void  v108(); // _ZN6S285C34v108Ev
  virtual void  v109(); // _ZN6S285C34v109Ev
  virtual void  v110(); // _ZN6S285C34v110Ev
  virtual void  v111(); // _ZN6S285C34v111Ev
  virtual void  v112(); // _ZN6S285C34v112Ev
  virtual void  v113(); // _ZN6S285C34v113Ev
  virtual void  v114(); // _ZN6S285C34v114Ev
  virtual void  v115(); // _ZN6S285C34v115Ev
  virtual void  v116(); // _ZN6S285C34v116Ev
  virtual void  v117(); // _ZN6S285C34v117Ev
  virtual void  v118(); // _ZN6S285C34v118Ev
  virtual void  v119(); // _ZN6S285C34v119Ev
  virtual void  v120(); // _ZN6S285C34v120Ev
  virtual void  v121(); // _ZN6S285C34v121Ev
  virtual void  v122(); // _ZN6S285C34v122Ev
  virtual void  v123(); // _ZN6S285C34v123Ev
  virtual void  v124(); // _ZN6S285C34v124Ev
  virtual void  v125(); // _ZN6S285C34v125Ev
  virtual void  v126(); // _ZN6S285C34v126Ev
  S285C3(); // tgen
};
//SIG(-1 S285C3) C1{ BC2{ BC3{ BC4{ vd v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v92 v93 v94 v95 v96 Fp FC5} vd v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 Fp FC6{ m} FC6 FC7{ m Fi[4]} FC7 Fi FC8{ m} Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp FC9{ BC10{ BC11{ m Fp Fi[2]}}} FC12{ m} Fi:1 FC13{ BC14{ BC11}} FC13 FC15{ BC16{ BC11}} FC15 Fc[2] FC17{ m Fi[4]} Fi[3] Fc[2] Fi[2]}


 S285C3 ::~S285C3(){ note_dtor("S285C3", this);}
void  S285C3 ::v100(){vfunc_called(this, "_ZN6S285C34v100Ev");}
void  S285C3 ::v101(){vfunc_called(this, "_ZN6S285C34v101Ev");}
void  S285C3 ::v102(){vfunc_called(this, "_ZN6S285C34v102Ev");}
void  S285C3 ::v103(){vfunc_called(this, "_ZN6S285C34v103Ev");}
void  S285C3 ::v104(){vfunc_called(this, "_ZN6S285C34v104Ev");}
void  S285C3 ::v105(){vfunc_called(this, "_ZN6S285C34v105Ev");}
void  S285C3 ::v106(){vfunc_called(this, "_ZN6S285C34v106Ev");}
void  S285C3 ::v107(){vfunc_called(this, "_ZN6S285C34v107Ev");}
void  S285C3 ::v108(){vfunc_called(this, "_ZN6S285C34v108Ev");}
void  S285C3 ::v109(){vfunc_called(this, "_ZN6S285C34v109Ev");}
void  S285C3 ::v110(){vfunc_called(this, "_ZN6S285C34v110Ev");}
void  S285C3 ::v111(){vfunc_called(this, "_ZN6S285C34v111Ev");}
void  S285C3 ::v112(){vfunc_called(this, "_ZN6S285C34v112Ev");}
void  S285C3 ::v113(){vfunc_called(this, "_ZN6S285C34v113Ev");}
void  S285C3 ::v114(){vfunc_called(this, "_ZN6S285C34v114Ev");}
void  S285C3 ::v115(){vfunc_called(this, "_ZN6S285C34v115Ev");}
void  S285C3 ::v116(){vfunc_called(this, "_ZN6S285C34v116Ev");}
void  S285C3 ::v117(){vfunc_called(this, "_ZN6S285C34v117Ev");}
void  S285C3 ::v118(){vfunc_called(this, "_ZN6S285C34v118Ev");}
void  S285C3 ::v119(){vfunc_called(this, "_ZN6S285C34v119Ev");}
void  S285C3 ::v120(){vfunc_called(this, "_ZN6S285C34v120Ev");}
void  S285C3 ::v121(){vfunc_called(this, "_ZN6S285C34v121Ev");}
void  S285C3 ::v122(){vfunc_called(this, "_ZN6S285C34v122Ev");}
void  S285C3 ::v123(){vfunc_called(this, "_ZN6S285C34v123Ev");}
void  S285C3 ::v124(){vfunc_called(this, "_ZN6S285C34v124Ev");}
void  S285C3 ::v125(){vfunc_called(this, "_ZN6S285C34v125Ev");}
void  S285C3 ::v126(){vfunc_called(this, "_ZN6S285C34v126Ev");}
S285C3 ::S285C3(){ note_ctor("S285C3", this);} // tgen

static void Test_S285C3()
{
  extern Class_Descriptor cd_S285C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(45,64)];
    init_test(&cd_S285C3, buf);
    S285C3 *dp, &lv = *(dp=new (buf) S285C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(352,252), "sizeof(S285C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S285C3)");
    check_base_class_offset(lv, (S285C6*)(S285C5*)(S285C4*), 0, "S285C3");
    check_base_class_offset(lv, (S285C5*)(S285C4*), 0, "S285C3");
    check_base_class_offset(lv, (S285C4*), 0, "S285C3");
    check_field_offset(lv, s285c3f0, ABISELECT(136,84), "S285C3.s285c3f0");
    check_field_offset(lv, s285c3f1, ABISELECT(144,88), "S285C3.s285c3f1");
    check_field_offset(lv, s285c3f2, ABISELECT(145,89), "S285C3.s285c3f2");
    check_field_offset(lv, s285c3f3, ABISELECT(148,92), "S285C3.s285c3f3");
    check_field_offset(lv, s285c3f4, ABISELECT(164,108), "S285C3.s285c3f4");
    check_field_offset(lv, s285c3f5, ABISELECT(180,124), "S285C3.s285c3f5");
    check_field_offset(lv, s285c3f6, ABISELECT(184,128), "S285C3.s285c3f6");
    check_field_offset(lv, s285c3f7, ABISELECT(192,132), "S285C3.s285c3f7");
    set_bf_and_test(lv, s285c3f8, ABISELECT(200,136), 0, 1, 1, "S285C3");
    set_bf_and_test(lv, s285c3f9, ABISELECT(200,136), 1, 1, 1, "S285C3");
    set_bf_and_test(lv, s285c3f10, ABISELECT(200,136), 2, 1, 1, "S285C3");
    set_bf_and_test(lv, s285c3f11, ABISELECT(200,136), 3, 1, 1, "S285C3");
    set_bf_and_test(lv, s285c3f12, ABISELECT(200,136), 4, 1, 1, "S285C3");
    set_bf_and_test(lv, s285c3f13, ABISELECT(200,136), 5, 1, 1, "S285C3");
    set_bf_and_test(lv, s285c3f14, ABISELECT(200,136), 6, 1, 1, "S285C3");
    set_bf_and_test(lv, s285c3f15, ABISELECT(200,136), 7, 1, 1, "S285C3");
    set_bf_and_test(lv, s285c3f16, ABISELECT(201,137), 0, 1, 1, "S285C3");
    set_bf_and_test(lv, s285c3f17, ABISELECT(201,137), 1, 1, 1, "S285C3");
    set_bf_and_test(lv, s285c3f18, ABISELECT(201,137), 2, 1, 1, "S285C3");
    check_field_offset(lv, s285c3f19, ABISELECT(208,140), "S285C3.s285c3f19");
    check_field_offset(lv, s285c3f20, ABISELECT(216,144), "S285C3.s285c3f20");
    check_field_offset(lv, s285c3f21, ABISELECT(232,156), "S285C3.s285c3f21");
    set_bf_and_test(lv, s285c3f22, ABISELECT(233,157), 0, 1, 1, "S285C3");
    check_field_offset(lv, s285c3f23, ABISELECT(240,160), "S285C3.s285c3f23");
    check_field_offset(lv, s285c3f24, ABISELECT(256,172), "S285C3.s285c3f24");
    check_field_offset(lv, s285c3f25, ABISELECT(272,184), "S285C3.s285c3f25");
    check_field_offset(lv, s285c3f26, ABISELECT(288,196), "S285C3.s285c3f26");
    check_field_offset(lv, s285c3f27, ABISELECT(304,208), "S285C3.s285c3f27");
    check_field_offset(lv, s285c3f28, ABISELECT(308,212), "S285C3.s285c3f28");
    check_field_offset(lv, s285c3f29, ABISELECT(324,228), "S285C3.s285c3f29");
    check_field_offset(lv, s285c3f30, ABISELECT(336,240), "S285C3.s285c3f30");
    check_field_offset(lv, s285c3f31, ABISELECT(340,244), "S285C3.s285c3f31");
    test_class_info(&lv, &cd_S285C3);
    dp->~S285C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS285C3(Test_S285C3, "S285C3", ABISELECT(352,252));

#else // __cplusplus

extern void _ZN6S285C3C1Ev();
extern void _ZN6S285C3D1Ev();
Name_Map name_map_S285C3[] = {
  NSPAIR(_ZN6S285C3C1Ev),
  NSPAIR(_ZN6S285C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S285C6;
extern VTBL_ENTRY _ZTI6S285C6[];
extern  VTBL_ENTRY _ZTV6S285C6[];
extern Class_Descriptor cd_S285C5;
extern VTBL_ENTRY _ZTI6S285C5[];
extern  VTBL_ENTRY _ZTV6S285C5[];
extern Class_Descriptor cd_S285C4;
extern VTBL_ENTRY _ZTI6S285C4[];
extern  VTBL_ENTRY _ZTV6S285C4[];
static Base_Class bases_S285C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S285C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S285C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S285C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S285C3[];
extern void _ZN6S285C3D1Ev();
extern void _ZN6S285C3D0Ev();
extern void _ZN6S285C62v9Ev();
extern void _ZN6S285C63v10Ev();
extern void _ZN6S285C63v11Ev();
extern void _ZN6S285C63v12Ev();
extern void _ZN6S285C63v13Ev();
extern void _ZN6S285C63v14Ev();
extern void _ZN6S285C63v15Ev();
extern void _ZN6S285C63v16Ev();
extern void _ZN6S285C63v17Ev();
extern void _ZN6S285C63v18Ev();
extern void _ZN6S285C63v19Ev();
extern void _ZN6S285C63v20Ev();
extern void _ZN6S285C63v21Ev();
extern void _ZN6S285C63v22Ev();
extern void _ZN6S285C63v23Ev();
extern void _ZN6S285C63v24Ev();
extern void _ZN6S285C63v25Ev();
extern void _ZN6S285C63v26Ev();
extern void _ZN6S285C63v27Ev();
extern void _ZN6S285C63v28Ev();
extern void _ZN6S285C63v29Ev();
extern void _ZN6S285C63v30Ev();
extern void _ZN6S285C63v31Ev();
extern void _ZN6S285C63v32Ev();
extern void _ZN6S285C63v33Ev();
extern void _ZN6S285C63v34Ev();
extern void _ZN6S285C63v35Ev();
extern void _ZN6S285C63v36Ev();
extern void _ZN6S285C63v37Ev();
extern void _ZN6S285C63v38Ev();
extern void _ZN6S285C63v39Ev();
extern void _ZN6S285C63v40Ev();
extern void _ZN6S285C63v41Ev();
extern void _ZN6S285C63v42Ev();
extern void _ZN6S285C63v43Ev();
extern void _ZN6S285C63v44Ev();
extern void _ZN6S285C63v45Ev();
extern void _ZN6S285C63v46Ev();
extern void _ZN6S285C63v47Ev();
extern void _ZN6S285C63v48Ev();
extern void _ZN6S285C63v49Ev();
extern void _ZN6S285C63v50Ev();
extern void _ZN6S285C63v51Ev();
extern void _ZN6S285C63v52Ev();
extern void _ZN6S285C63v53Ev();
extern void _ZN6S285C63v54Ev();
extern void _ZN6S285C63v55Ev();
extern void _ZN6S285C63v56Ev();
extern void _ZN6S285C63v57Ev();
extern void _ZN6S285C63v58Ev();
extern void _ZN6S285C63v59Ev();
extern void _ZN6S285C63v60Ev();
extern void _ZN6S285C63v61Ev();
extern void _ZN6S285C63v62Ev();
extern void _ZN6S285C63v63Ev();
extern void _ZN6S285C63v64Ev();
extern void _ZN6S285C63v65Ev();
extern void _ZN6S285C63v66Ev();
extern void _ZN6S285C63v67Ev();
extern void _ZN6S285C63v68Ev();
extern void _ZN6S285C63v69Ev();
extern void _ZN6S285C63v70Ev();
extern void _ZN6S285C63v71Ev();
extern void _ZN6S285C63v72Ev();
extern void _ZN6S285C53v73Ev();
extern void _ZN6S285C53v74Ev();
extern void _ZN6S285C53v75Ev();
extern void _ZN6S285C53v76Ev();
extern void _ZN6S285C53v77Ev();
extern void _ZN6S285C43v78Ev();
extern void _ZN6S285C43v79Ev();
extern void _ZN6S285C43v80Ev();
extern void _ZN6S285C43v81Ev();
extern void _ZN6S285C43v82Ev();
extern void _ZN6S285C43v83Ev();
extern void _ZN6S285C43v84Ev();
extern void _ZN6S285C43v85Ev();
extern void _ZN6S285C43v86Ev();
extern void _ZN6S285C43v87Ev();
extern void _ZN6S285C43v88Ev();
extern void _ZN6S285C43v89Ev();
extern void _ZN6S285C43v90Ev();
extern void _ZN6S285C43v91Ev();
extern void _ZN6S285C43v92Ev();
extern void _ZN6S285C43v93Ev();
extern void _ZN6S285C43v94Ev();
extern void _ZN6S285C43v95Ev();
extern void _ZN6S285C43v96Ev();
extern void _ZN6S285C43v97Ev();
extern void _ZN6S285C43v98Ev();
extern void _ZN6S285C43v99Ev();
extern void _ZN6S285C34v100Ev();
extern void _ZN6S285C34v101Ev();
extern void _ZN6S285C34v102Ev();
extern void _ZN6S285C34v103Ev();
extern void _ZN6S285C34v104Ev();
extern void _ZN6S285C34v105Ev();
extern void _ZN6S285C34v106Ev();
extern void _ZN6S285C34v107Ev();
extern void _ZN6S285C34v108Ev();
extern void _ZN6S285C34v109Ev();
extern void _ZN6S285C34v110Ev();
extern void _ZN6S285C34v111Ev();
extern void _ZN6S285C34v112Ev();
extern void _ZN6S285C34v113Ev();
extern void _ZN6S285C34v114Ev();
extern void _ZN6S285C34v115Ev();
extern void _ZN6S285C34v116Ev();
extern void _ZN6S285C34v117Ev();
extern void _ZN6S285C34v118Ev();
extern void _ZN6S285C34v119Ev();
extern void _ZN6S285C34v120Ev();
extern void _ZN6S285C34v121Ev();
extern void _ZN6S285C34v122Ev();
extern void _ZN6S285C34v123Ev();
extern void _ZN6S285C34v124Ev();
extern void _ZN6S285C34v125Ev();
extern void _ZN6S285C34v126Ev();
static  VTBL_ENTRY vtc_S285C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S285C3[0]),
  (VTBL_ENTRY)&_ZN6S285C3D1Ev,
  (VTBL_ENTRY)&_ZN6S285C3D0Ev,
  (VTBL_ENTRY)&_ZN6S285C62v9Ev,
  (VTBL_ENTRY)&_ZN6S285C63v10Ev,
  (VTBL_ENTRY)&_ZN6S285C63v11Ev,
  (VTBL_ENTRY)&_ZN6S285C63v12Ev,
  (VTBL_ENTRY)&_ZN6S285C63v13Ev,
  (VTBL_ENTRY)&_ZN6S285C63v14Ev,
  (VTBL_ENTRY)&_ZN6S285C63v15Ev,
  (VTBL_ENTRY)&_ZN6S285C63v16Ev,
  (VTBL_ENTRY)&_ZN6S285C63v17Ev,
  (VTBL_ENTRY)&_ZN6S285C63v18Ev,
  (VTBL_ENTRY)&_ZN6S285C63v19Ev,
  (VTBL_ENTRY)&_ZN6S285C63v20Ev,
  (VTBL_ENTRY)&_ZN6S285C63v21Ev,
  (VTBL_ENTRY)&_ZN6S285C63v22Ev,
  (VTBL_ENTRY)&_ZN6S285C63v23Ev,
  (VTBL_ENTRY)&_ZN6S285C63v24Ev,
  (VTBL_ENTRY)&_ZN6S285C63v25Ev,
  (VTBL_ENTRY)&_ZN6S285C63v26Ev,
  (VTBL_ENTRY)&_ZN6S285C63v27Ev,
  (VTBL_ENTRY)&_ZN6S285C63v28Ev,
  (VTBL_ENTRY)&_ZN6S285C63v29Ev,
  (VTBL_ENTRY)&_ZN6S285C63v30Ev,
  (VTBL_ENTRY)&_ZN6S285C63v31Ev,
  (VTBL_ENTRY)&_ZN6S285C63v32Ev,
  (VTBL_ENTRY)&_ZN6S285C63v33Ev,
  (VTBL_ENTRY)&_ZN6S285C63v34Ev,
  (VTBL_ENTRY)&_ZN6S285C63v35Ev,
  (VTBL_ENTRY)&_ZN6S285C63v36Ev,
  (VTBL_ENTRY)&_ZN6S285C63v37Ev,
  (VTBL_ENTRY)&_ZN6S285C63v38Ev,
  (VTBL_ENTRY)&_ZN6S285C63v39Ev,
  (VTBL_ENTRY)&_ZN6S285C63v40Ev,
  (VTBL_ENTRY)&_ZN6S285C63v41Ev,
  (VTBL_ENTRY)&_ZN6S285C63v42Ev,
  (VTBL_ENTRY)&_ZN6S285C63v43Ev,
  (VTBL_ENTRY)&_ZN6S285C63v44Ev,
  (VTBL_ENTRY)&_ZN6S285C63v45Ev,
  (VTBL_ENTRY)&_ZN6S285C63v46Ev,
  (VTBL_ENTRY)&_ZN6S285C63v47Ev,
  (VTBL_ENTRY)&_ZN6S285C63v48Ev,
  (VTBL_ENTRY)&_ZN6S285C63v49Ev,
  (VTBL_ENTRY)&_ZN6S285C63v50Ev,
  (VTBL_ENTRY)&_ZN6S285C63v51Ev,
  (VTBL_ENTRY)&_ZN6S285C63v52Ev,
  (VTBL_ENTRY)&_ZN6S285C63v53Ev,
  (VTBL_ENTRY)&_ZN6S285C63v54Ev,
  (VTBL_ENTRY)&_ZN6S285C63v55Ev,
  (VTBL_ENTRY)&_ZN6S285C63v56Ev,
  (VTBL_ENTRY)&_ZN6S285C63v57Ev,
  (VTBL_ENTRY)&_ZN6S285C63v58Ev,
  (VTBL_ENTRY)&_ZN6S285C63v59Ev,
  (VTBL_ENTRY)&_ZN6S285C63v60Ev,
  (VTBL_ENTRY)&_ZN6S285C63v61Ev,
  (VTBL_ENTRY)&_ZN6S285C63v62Ev,
  (VTBL_ENTRY)&_ZN6S285C63v63Ev,
  (VTBL_ENTRY)&_ZN6S285C63v64Ev,
  (VTBL_ENTRY)&_ZN6S285C63v65Ev,
  (VTBL_ENTRY)&_ZN6S285C63v66Ev,
  (VTBL_ENTRY)&_ZN6S285C63v67Ev,
  (VTBL_ENTRY)&_ZN6S285C63v68Ev,
  (VTBL_ENTRY)&_ZN6S285C63v69Ev,
  (VTBL_ENTRY)&_ZN6S285C63v70Ev,
  (VTBL_ENTRY)&_ZN6S285C63v71Ev,
  (VTBL_ENTRY)&_ZN6S285C63v72Ev,
  (VTBL_ENTRY)&_ZN6S285C53v73Ev,
  (VTBL_ENTRY)&_ZN6S285C53v74Ev,
  (VTBL_ENTRY)&_ZN6S285C53v75Ev,
  (VTBL_ENTRY)&_ZN6S285C53v76Ev,
  (VTBL_ENTRY)&_ZN6S285C53v77Ev,
  (VTBL_ENTRY)&_ZN6S285C43v78Ev,
  (VTBL_ENTRY)&_ZN6S285C43v79Ev,
  (VTBL_ENTRY)&_ZN6S285C43v80Ev,
  (VTBL_ENTRY)&_ZN6S285C43v81Ev,
  (VTBL_ENTRY)&_ZN6S285C43v82Ev,
  (VTBL_ENTRY)&_ZN6S285C43v83Ev,
  (VTBL_ENTRY)&_ZN6S285C43v84Ev,
  (VTBL_ENTRY)&_ZN6S285C43v85Ev,
  (VTBL_ENTRY)&_ZN6S285C43v86Ev,
  (VTBL_ENTRY)&_ZN6S285C43v87Ev,
  (VTBL_ENTRY)&_ZN6S285C43v88Ev,
  (VTBL_ENTRY)&_ZN6S285C43v89Ev,
  (VTBL_ENTRY)&_ZN6S285C43v90Ev,
  (VTBL_ENTRY)&_ZN6S285C43v91Ev,
  (VTBL_ENTRY)&_ZN6S285C43v92Ev,
  (VTBL_ENTRY)&_ZN6S285C43v93Ev,
  (VTBL_ENTRY)&_ZN6S285C43v94Ev,
  (VTBL_ENTRY)&_ZN6S285C43v95Ev,
  (VTBL_ENTRY)&_ZN6S285C43v96Ev,
  (VTBL_ENTRY)&_ZN6S285C43v97Ev,
  (VTBL_ENTRY)&_ZN6S285C43v98Ev,
  (VTBL_ENTRY)&_ZN6S285C43v99Ev,
  (VTBL_ENTRY)&_ZN6S285C34v100Ev,
  (VTBL_ENTRY)&_ZN6S285C34v101Ev,
  (VTBL_ENTRY)&_ZN6S285C34v102Ev,
  (VTBL_ENTRY)&_ZN6S285C34v103Ev,
  (VTBL_ENTRY)&_ZN6S285C34v104Ev,
  (VTBL_ENTRY)&_ZN6S285C34v105Ev,
  (VTBL_ENTRY)&_ZN6S285C34v106Ev,
  (VTBL_ENTRY)&_ZN6S285C34v107Ev,
  (VTBL_ENTRY)&_ZN6S285C34v108Ev,
  (VTBL_ENTRY)&_ZN6S285C34v109Ev,
  (VTBL_ENTRY)&_ZN6S285C34v110Ev,
  (VTBL_ENTRY)&_ZN6S285C34v111Ev,
  (VTBL_ENTRY)&_ZN6S285C34v112Ev,
  (VTBL_ENTRY)&_ZN6S285C34v113Ev,
  (VTBL_ENTRY)&_ZN6S285C34v114Ev,
  (VTBL_ENTRY)&_ZN6S285C34v115Ev,
  (VTBL_ENTRY)&_ZN6S285C34v116Ev,
  (VTBL_ENTRY)&_ZN6S285C34v117Ev,
  (VTBL_ENTRY)&_ZN6S285C34v118Ev,
  (VTBL_ENTRY)&_ZN6S285C34v119Ev,
  (VTBL_ENTRY)&_ZN6S285C34v120Ev,
  (VTBL_ENTRY)&_ZN6S285C34v121Ev,
  (VTBL_ENTRY)&_ZN6S285C34v122Ev,
  (VTBL_ENTRY)&_ZN6S285C34v123Ev,
  (VTBL_ENTRY)&_ZN6S285C34v124Ev,
  (VTBL_ENTRY)&_ZN6S285C34v125Ev,
  (VTBL_ENTRY)&_ZN6S285C34v126Ev,
};
extern VTBL_ENTRY _ZTI6S285C3[];
extern  VTBL_ENTRY _ZTV6S285C3[];
Class_Descriptor cd_S285C3 = {  "S285C3", // class name
  bases_S285C3, 3,
  &(vtc_S285C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(352,252), // object size
  NSPAIRA(_ZTI6S285C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S285C3),122, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S285C2  : S285C3 {
  int s285c2f0[4];
  ::S836C39 s285c2f1;
  ::S235C20_nt s285c2f2;
  void *s285c2f3;
  virtual  ~S285C2(); // _ZN6S285C2D1Ev
  virtual void  v127(); // _ZN6S285C24v127Ev
  virtual void  v128(); // _ZN6S285C24v128Ev
  virtual void  v129(); // _ZN6S285C24v129Ev
  virtual void  v130(); // _ZN6S285C24v130Ev
  virtual void  v131(); // _ZN6S285C24v131Ev
  virtual void  v132(); // _ZN6S285C24v132Ev
  virtual void  v133(); // _ZN6S285C24v133Ev
  virtual void  v134(); // _ZN6S285C24v134Ev
  virtual void  v135(); // _ZN6S285C24v135Ev
  virtual void  v136(); // _ZN6S285C24v136Ev
  virtual void  v137(); // _ZN6S285C24v137Ev
  virtual void  v138(); // _ZN6S285C24v138Ev
  virtual void  v139(); // _ZN6S285C24v139Ev
  virtual void  v140(); // _ZN6S285C24v140Ev
  S285C2(); // tgen
};
//SIG(-1 S285C2) C1{ BC2{ BC3{ BC4{ BC5{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v79 v80 v81 v82 v83 Fp FC6} vd v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 Fp FC7{ m} FC7 FC8{ m Fi[4]} FC8 Fi FC9{ m} Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp FC10{ BC11{ BC12{ m Fp Fi[2]}}} FC13{ m} Fi:1 FC14{ BC15{ BC12}} FC14 FC16{ BC17{ BC12}} FC16 Fc[2] FC18{ m Fi[4]} Fi[3] Fc[2] Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fi[4] FC7 FC19{ m Fi[3]} Fp}


 S285C2 ::~S285C2(){ note_dtor("S285C2", this);}
void  S285C2 ::v127(){vfunc_called(this, "_ZN6S285C24v127Ev");}
void  S285C2 ::v128(){vfunc_called(this, "_ZN6S285C24v128Ev");}
void  S285C2 ::v129(){vfunc_called(this, "_ZN6S285C24v129Ev");}
void  S285C2 ::v130(){vfunc_called(this, "_ZN6S285C24v130Ev");}
void  S285C2 ::v131(){vfunc_called(this, "_ZN6S285C24v131Ev");}
void  S285C2 ::v132(){vfunc_called(this, "_ZN6S285C24v132Ev");}
void  S285C2 ::v133(){vfunc_called(this, "_ZN6S285C24v133Ev");}
void  S285C2 ::v134(){vfunc_called(this, "_ZN6S285C24v134Ev");}
void  S285C2 ::v135(){vfunc_called(this, "_ZN6S285C24v135Ev");}
void  S285C2 ::v136(){vfunc_called(this, "_ZN6S285C24v136Ev");}
void  S285C2 ::v137(){vfunc_called(this, "_ZN6S285C24v137Ev");}
void  S285C2 ::v138(){vfunc_called(this, "_ZN6S285C24v138Ev");}
void  S285C2 ::v139(){vfunc_called(this, "_ZN6S285C24v139Ev");}
void  S285C2 ::v140(){vfunc_called(this, "_ZN6S285C24v140Ev");}
S285C2 ::S285C2(){ note_ctor("S285C2", this);} // tgen

static void Test_S285C2()
{
  extern Class_Descriptor cd_S285C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(50,73)];
    init_test(&cd_S285C2, buf);
    S285C2 *dp, &lv = *(dp=new (buf) S285C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(392,288), "sizeof(S285C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S285C2)");
    check_base_class_offset(lv, (S285C6*)(S285C5*)(S285C4*)(S285C3*), 0, "S285C2");
    check_base_class_offset(lv, (S285C5*)(S285C4*)(S285C3*), 0, "S285C2");
    check_base_class_offset(lv, (S285C4*)(S285C3*), 0, "S285C2");
    check_base_class_offset(lv, (S285C3*), 0, "S285C2");
    check_field_offset(lv, s285c2f0, ABISELECT(348,252), "S285C2.s285c2f0");
    check_field_offset(lv, s285c2f1, ABISELECT(364,268), "S285C2.s285c2f1");
    check_field_offset(lv, s285c2f2, ABISELECT(368,272), "S285C2.s285c2f2");
    check_field_offset(lv, s285c2f3, ABISELECT(384,284), "S285C2.s285c2f3");
    test_class_info(&lv, &cd_S285C2);
    dp->~S285C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS285C2(Test_S285C2, "S285C2", ABISELECT(392,288));

#else // __cplusplus

extern void _ZN6S285C2C1Ev();
extern void _ZN6S285C2D1Ev();
Name_Map name_map_S285C2[] = {
  NSPAIR(_ZN6S285C2C1Ev),
  NSPAIR(_ZN6S285C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S285C6;
extern VTBL_ENTRY _ZTI6S285C6[];
extern  VTBL_ENTRY _ZTV6S285C6[];
extern Class_Descriptor cd_S285C5;
extern VTBL_ENTRY _ZTI6S285C5[];
extern  VTBL_ENTRY _ZTV6S285C5[];
extern Class_Descriptor cd_S285C4;
extern VTBL_ENTRY _ZTI6S285C4[];
extern  VTBL_ENTRY _ZTV6S285C4[];
extern Class_Descriptor cd_S285C3;
extern VTBL_ENTRY _ZTI6S285C3[];
extern  VTBL_ENTRY _ZTV6S285C3[];
static Base_Class bases_S285C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S285C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S285C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S285C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S285C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S285C2[];
extern void _ZN6S285C2D1Ev();
extern void _ZN6S285C2D0Ev();
extern void _ZN6S285C62v9Ev();
extern void _ZN6S285C63v10Ev();
extern void _ZN6S285C63v11Ev();
extern void _ZN6S285C63v12Ev();
extern void _ZN6S285C63v13Ev();
extern void _ZN6S285C63v14Ev();
extern void _ZN6S285C63v15Ev();
extern void _ZN6S285C63v16Ev();
extern void _ZN6S285C63v17Ev();
extern void _ZN6S285C63v18Ev();
extern void _ZN6S285C63v19Ev();
extern void _ZN6S285C63v20Ev();
extern void _ZN6S285C63v21Ev();
extern void _ZN6S285C63v22Ev();
extern void _ZN6S285C63v23Ev();
extern void _ZN6S285C63v24Ev();
extern void _ZN6S285C63v25Ev();
extern void _ZN6S285C63v26Ev();
extern void _ZN6S285C63v27Ev();
extern void _ZN6S285C63v28Ev();
extern void _ZN6S285C63v29Ev();
extern void _ZN6S285C63v30Ev();
extern void _ZN6S285C63v31Ev();
extern void _ZN6S285C63v32Ev();
extern void _ZN6S285C63v33Ev();
extern void _ZN6S285C63v34Ev();
extern void _ZN6S285C63v35Ev();
extern void _ZN6S285C63v36Ev();
extern void _ZN6S285C63v37Ev();
extern void _ZN6S285C63v38Ev();
extern void _ZN6S285C63v39Ev();
extern void _ZN6S285C63v40Ev();
extern void _ZN6S285C63v41Ev();
extern void _ZN6S285C63v42Ev();
extern void _ZN6S285C63v43Ev();
extern void _ZN6S285C63v44Ev();
extern void _ZN6S285C63v45Ev();
extern void _ZN6S285C63v46Ev();
extern void _ZN6S285C63v47Ev();
extern void _ZN6S285C63v48Ev();
extern void _ZN6S285C63v49Ev();
extern void _ZN6S285C63v50Ev();
extern void _ZN6S285C63v51Ev();
extern void _ZN6S285C63v52Ev();
extern void _ZN6S285C63v53Ev();
extern void _ZN6S285C63v54Ev();
extern void _ZN6S285C63v55Ev();
extern void _ZN6S285C63v56Ev();
extern void _ZN6S285C63v57Ev();
extern void _ZN6S285C63v58Ev();
extern void _ZN6S285C63v59Ev();
extern void _ZN6S285C63v60Ev();
extern void _ZN6S285C63v61Ev();
extern void _ZN6S285C63v62Ev();
extern void _ZN6S285C63v63Ev();
extern void _ZN6S285C63v64Ev();
extern void _ZN6S285C63v65Ev();
extern void _ZN6S285C63v66Ev();
extern void _ZN6S285C63v67Ev();
extern void _ZN6S285C63v68Ev();
extern void _ZN6S285C63v69Ev();
extern void _ZN6S285C63v70Ev();
extern void _ZN6S285C63v71Ev();
extern void _ZN6S285C63v72Ev();
extern void _ZN6S285C53v73Ev();
extern void _ZN6S285C53v74Ev();
extern void _ZN6S285C53v75Ev();
extern void _ZN6S285C53v76Ev();
extern void _ZN6S285C53v77Ev();
extern void _ZN6S285C43v78Ev();
extern void _ZN6S285C43v79Ev();
extern void _ZN6S285C43v80Ev();
extern void _ZN6S285C43v81Ev();
extern void _ZN6S285C43v82Ev();
extern void _ZN6S285C43v83Ev();
extern void _ZN6S285C43v84Ev();
extern void _ZN6S285C43v85Ev();
extern void _ZN6S285C43v86Ev();
extern void _ZN6S285C43v87Ev();
extern void _ZN6S285C43v88Ev();
extern void _ZN6S285C43v89Ev();
extern void _ZN6S285C43v90Ev();
extern void _ZN6S285C43v91Ev();
extern void _ZN6S285C43v92Ev();
extern void _ZN6S285C43v93Ev();
extern void _ZN6S285C43v94Ev();
extern void _ZN6S285C43v95Ev();
extern void _ZN6S285C43v96Ev();
extern void _ZN6S285C43v97Ev();
extern void _ZN6S285C43v98Ev();
extern void _ZN6S285C43v99Ev();
extern void _ZN6S285C34v100Ev();
extern void _ZN6S285C34v101Ev();
extern void _ZN6S285C34v102Ev();
extern void _ZN6S285C34v103Ev();
extern void _ZN6S285C34v104Ev();
extern void _ZN6S285C34v105Ev();
extern void _ZN6S285C34v106Ev();
extern void _ZN6S285C34v107Ev();
extern void _ZN6S285C34v108Ev();
extern void _ZN6S285C34v109Ev();
extern void _ZN6S285C34v110Ev();
extern void _ZN6S285C34v111Ev();
extern void _ZN6S285C34v112Ev();
extern void _ZN6S285C34v113Ev();
extern void _ZN6S285C34v114Ev();
extern void _ZN6S285C34v115Ev();
extern void _ZN6S285C34v116Ev();
extern void _ZN6S285C34v117Ev();
extern void _ZN6S285C34v118Ev();
extern void _ZN6S285C34v119Ev();
extern void _ZN6S285C34v120Ev();
extern void _ZN6S285C34v121Ev();
extern void _ZN6S285C34v122Ev();
extern void _ZN6S285C34v123Ev();
extern void _ZN6S285C34v124Ev();
extern void _ZN6S285C34v125Ev();
extern void _ZN6S285C34v126Ev();
extern void _ZN6S285C24v127Ev();
extern void _ZN6S285C24v128Ev();
extern void _ZN6S285C24v129Ev();
extern void _ZN6S285C24v130Ev();
extern void _ZN6S285C24v131Ev();
extern void _ZN6S285C24v132Ev();
extern void _ZN6S285C24v133Ev();
extern void _ZN6S285C24v134Ev();
extern void _ZN6S285C24v135Ev();
extern void _ZN6S285C24v136Ev();
extern void _ZN6S285C24v137Ev();
extern void _ZN6S285C24v138Ev();
extern void _ZN6S285C24v139Ev();
extern void _ZN6S285C24v140Ev();
static  VTBL_ENTRY vtc_S285C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S285C2[0]),
  (VTBL_ENTRY)&_ZN6S285C2D1Ev,
  (VTBL_ENTRY)&_ZN6S285C2D0Ev,
  (VTBL_ENTRY)&_ZN6S285C62v9Ev,
  (VTBL_ENTRY)&_ZN6S285C63v10Ev,
  (VTBL_ENTRY)&_ZN6S285C63v11Ev,
  (VTBL_ENTRY)&_ZN6S285C63v12Ev,
  (VTBL_ENTRY)&_ZN6S285C63v13Ev,
  (VTBL_ENTRY)&_ZN6S285C63v14Ev,
  (VTBL_ENTRY)&_ZN6S285C63v15Ev,
  (VTBL_ENTRY)&_ZN6S285C63v16Ev,
  (VTBL_ENTRY)&_ZN6S285C63v17Ev,
  (VTBL_ENTRY)&_ZN6S285C63v18Ev,
  (VTBL_ENTRY)&_ZN6S285C63v19Ev,
  (VTBL_ENTRY)&_ZN6S285C63v20Ev,
  (VTBL_ENTRY)&_ZN6S285C63v21Ev,
  (VTBL_ENTRY)&_ZN6S285C63v22Ev,
  (VTBL_ENTRY)&_ZN6S285C63v23Ev,
  (VTBL_ENTRY)&_ZN6S285C63v24Ev,
  (VTBL_ENTRY)&_ZN6S285C63v25Ev,
  (VTBL_ENTRY)&_ZN6S285C63v26Ev,
  (VTBL_ENTRY)&_ZN6S285C63v27Ev,
  (VTBL_ENTRY)&_ZN6S285C63v28Ev,
  (VTBL_ENTRY)&_ZN6S285C63v29Ev,
  (VTBL_ENTRY)&_ZN6S285C63v30Ev,
  (VTBL_ENTRY)&_ZN6S285C63v31Ev,
  (VTBL_ENTRY)&_ZN6S285C63v32Ev,
  (VTBL_ENTRY)&_ZN6S285C63v33Ev,
  (VTBL_ENTRY)&_ZN6S285C63v34Ev,
  (VTBL_ENTRY)&_ZN6S285C63v35Ev,
  (VTBL_ENTRY)&_ZN6S285C63v36Ev,
  (VTBL_ENTRY)&_ZN6S285C63v37Ev,
  (VTBL_ENTRY)&_ZN6S285C63v38Ev,
  (VTBL_ENTRY)&_ZN6S285C63v39Ev,
  (VTBL_ENTRY)&_ZN6S285C63v40Ev,
  (VTBL_ENTRY)&_ZN6S285C63v41Ev,
  (VTBL_ENTRY)&_ZN6S285C63v42Ev,
  (VTBL_ENTRY)&_ZN6S285C63v43Ev,
  (VTBL_ENTRY)&_ZN6S285C63v44Ev,
  (VTBL_ENTRY)&_ZN6S285C63v45Ev,
  (VTBL_ENTRY)&_ZN6S285C63v46Ev,
  (VTBL_ENTRY)&_ZN6S285C63v47Ev,
  (VTBL_ENTRY)&_ZN6S285C63v48Ev,
  (VTBL_ENTRY)&_ZN6S285C63v49Ev,
  (VTBL_ENTRY)&_ZN6S285C63v50Ev,
  (VTBL_ENTRY)&_ZN6S285C63v51Ev,
  (VTBL_ENTRY)&_ZN6S285C63v52Ev,
  (VTBL_ENTRY)&_ZN6S285C63v53Ev,
  (VTBL_ENTRY)&_ZN6S285C63v54Ev,
  (VTBL_ENTRY)&_ZN6S285C63v55Ev,
  (VTBL_ENTRY)&_ZN6S285C63v56Ev,
  (VTBL_ENTRY)&_ZN6S285C63v57Ev,
  (VTBL_ENTRY)&_ZN6S285C63v58Ev,
  (VTBL_ENTRY)&_ZN6S285C63v59Ev,
  (VTBL_ENTRY)&_ZN6S285C63v60Ev,
  (VTBL_ENTRY)&_ZN6S285C63v61Ev,
  (VTBL_ENTRY)&_ZN6S285C63v62Ev,
  (VTBL_ENTRY)&_ZN6S285C63v63Ev,
  (VTBL_ENTRY)&_ZN6S285C63v64Ev,
  (VTBL_ENTRY)&_ZN6S285C63v65Ev,
  (VTBL_ENTRY)&_ZN6S285C63v66Ev,
  (VTBL_ENTRY)&_ZN6S285C63v67Ev,
  (VTBL_ENTRY)&_ZN6S285C63v68Ev,
  (VTBL_ENTRY)&_ZN6S285C63v69Ev,
  (VTBL_ENTRY)&_ZN6S285C63v70Ev,
  (VTBL_ENTRY)&_ZN6S285C63v71Ev,
  (VTBL_ENTRY)&_ZN6S285C63v72Ev,
  (VTBL_ENTRY)&_ZN6S285C53v73Ev,
  (VTBL_ENTRY)&_ZN6S285C53v74Ev,
  (VTBL_ENTRY)&_ZN6S285C53v75Ev,
  (VTBL_ENTRY)&_ZN6S285C53v76Ev,
  (VTBL_ENTRY)&_ZN6S285C53v77Ev,
  (VTBL_ENTRY)&_ZN6S285C43v78Ev,
  (VTBL_ENTRY)&_ZN6S285C43v79Ev,
  (VTBL_ENTRY)&_ZN6S285C43v80Ev,
  (VTBL_ENTRY)&_ZN6S285C43v81Ev,
  (VTBL_ENTRY)&_ZN6S285C43v82Ev,
  (VTBL_ENTRY)&_ZN6S285C43v83Ev,
  (VTBL_ENTRY)&_ZN6S285C43v84Ev,
  (VTBL_ENTRY)&_ZN6S285C43v85Ev,
  (VTBL_ENTRY)&_ZN6S285C43v86Ev,
  (VTBL_ENTRY)&_ZN6S285C43v87Ev,
  (VTBL_ENTRY)&_ZN6S285C43v88Ev,
  (VTBL_ENTRY)&_ZN6S285C43v89Ev,
  (VTBL_ENTRY)&_ZN6S285C43v90Ev,
  (VTBL_ENTRY)&_ZN6S285C43v91Ev,
  (VTBL_ENTRY)&_ZN6S285C43v92Ev,
  (VTBL_ENTRY)&_ZN6S285C43v93Ev,
  (VTBL_ENTRY)&_ZN6S285C43v94Ev,
  (VTBL_ENTRY)&_ZN6S285C43v95Ev,
  (VTBL_ENTRY)&_ZN6S285C43v96Ev,
  (VTBL_ENTRY)&_ZN6S285C43v97Ev,
  (VTBL_ENTRY)&_ZN6S285C43v98Ev,
  (VTBL_ENTRY)&_ZN6S285C43v99Ev,
  (VTBL_ENTRY)&_ZN6S285C34v100Ev,
  (VTBL_ENTRY)&_ZN6S285C34v101Ev,
  (VTBL_ENTRY)&_ZN6S285C34v102Ev,
  (VTBL_ENTRY)&_ZN6S285C34v103Ev,
  (VTBL_ENTRY)&_ZN6S285C34v104Ev,
  (VTBL_ENTRY)&_ZN6S285C34v105Ev,
  (VTBL_ENTRY)&_ZN6S285C34v106Ev,
  (VTBL_ENTRY)&_ZN6S285C34v107Ev,
  (VTBL_ENTRY)&_ZN6S285C34v108Ev,
  (VTBL_ENTRY)&_ZN6S285C34v109Ev,
  (VTBL_ENTRY)&_ZN6S285C34v110Ev,
  (VTBL_ENTRY)&_ZN6S285C34v111Ev,
  (VTBL_ENTRY)&_ZN6S285C34v112Ev,
  (VTBL_ENTRY)&_ZN6S285C34v113Ev,
  (VTBL_ENTRY)&_ZN6S285C34v114Ev,
  (VTBL_ENTRY)&_ZN6S285C34v115Ev,
  (VTBL_ENTRY)&_ZN6S285C34v116Ev,
  (VTBL_ENTRY)&_ZN6S285C34v117Ev,
  (VTBL_ENTRY)&_ZN6S285C34v118Ev,
  (VTBL_ENTRY)&_ZN6S285C34v119Ev,
  (VTBL_ENTRY)&_ZN6S285C34v120Ev,
  (VTBL_ENTRY)&_ZN6S285C34v121Ev,
  (VTBL_ENTRY)&_ZN6S285C34v122Ev,
  (VTBL_ENTRY)&_ZN6S285C34v123Ev,
  (VTBL_ENTRY)&_ZN6S285C34v124Ev,
  (VTBL_ENTRY)&_ZN6S285C34v125Ev,
  (VTBL_ENTRY)&_ZN6S285C34v126Ev,
  (VTBL_ENTRY)&_ZN6S285C24v127Ev,
  (VTBL_ENTRY)&_ZN6S285C24v128Ev,
  (VTBL_ENTRY)&_ZN6S285C24v129Ev,
  (VTBL_ENTRY)&_ZN6S285C24v130Ev,
  (VTBL_ENTRY)&_ZN6S285C24v131Ev,
  (VTBL_ENTRY)&_ZN6S285C24v132Ev,
  (VTBL_ENTRY)&_ZN6S285C24v133Ev,
  (VTBL_ENTRY)&_ZN6S285C24v134Ev,
  (VTBL_ENTRY)&_ZN6S285C24v135Ev,
  (VTBL_ENTRY)&_ZN6S285C24v136Ev,
  (VTBL_ENTRY)&_ZN6S285C24v137Ev,
  (VTBL_ENTRY)&_ZN6S285C24v138Ev,
  (VTBL_ENTRY)&_ZN6S285C24v139Ev,
  (VTBL_ENTRY)&_ZN6S285C24v140Ev,
};
extern VTBL_ENTRY _ZTI6S285C2[];
extern  VTBL_ENTRY _ZTV6S285C2[];
Class_Descriptor cd_S285C2 = {  "S285C2", // class name
  bases_S285C2, 4,
  &(vtc_S285C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(392,288), // object size
  NSPAIRA(_ZTI6S285C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S285C2),136, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S285C1  : S285C2 {
  int s285c1f0[2];
  void *s285c1f1[2];
  virtual  ~S285C1(); // _ZN6S285C1D1Ev
  virtual void  v1(); // _ZN6S285C12v1Ev
  virtual void  v2(); // _ZN6S285C12v2Ev
  virtual void  v3(); // _ZN6S285C12v3Ev
  virtual void  v4(); // _ZN6S285C12v4Ev
  virtual void  v5(); // _ZN6S285C12v5Ev
  virtual void  v6(); // _ZN6S285C12v6Ev
  virtual void  v7(); // _ZN6S285C12v7Ev
  virtual void  v8(); // _ZN6S285C12v8Ev
  S285C1(); // tgen
};
//SIG(1 S285C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v73 v74 v75 v76 v77 Fp FC7} vd v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 Fp FC8{ m} FC8 FC9{ m Fi[4]} FC9 Fi FC10{ m} Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp FC11{ BC12{ BC13{ m Fp Fi[2]}}} FC14{ m} Fi:1 FC15{ BC16{ BC13}} FC15 FC17{ BC18{ BC13}} FC17 Fc[2] FC19{ m Fi[4]} Fi[3] Fc[2] Fi[2]} vd v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 Fi[4] FC8 FC20{ m Fi[3]} Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 Fi[2] Fp[2]}


 S285C1 ::~S285C1(){ note_dtor("S285C1", this);}
void  S285C1 ::v1(){vfunc_called(this, "_ZN6S285C12v1Ev");}
void  S285C1 ::v2(){vfunc_called(this, "_ZN6S285C12v2Ev");}
void  S285C1 ::v3(){vfunc_called(this, "_ZN6S285C12v3Ev");}
void  S285C1 ::v4(){vfunc_called(this, "_ZN6S285C12v4Ev");}
void  S285C1 ::v5(){vfunc_called(this, "_ZN6S285C12v5Ev");}
void  S285C1 ::v6(){vfunc_called(this, "_ZN6S285C12v6Ev");}
void  S285C1 ::v7(){vfunc_called(this, "_ZN6S285C12v7Ev");}
void  S285C1 ::v8(){vfunc_called(this, "_ZN6S285C12v8Ev");}
S285C1 ::S285C1(){ note_ctor("S285C1", this);} // tgen

static void Test_S285C1()
{
  extern Class_Descriptor cd_S285C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(53,77)];
    init_test(&cd_S285C1, buf);
    S285C1 *dp, &lv = *(dp=new (buf) S285C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(416,304), "sizeof(S285C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S285C1)");
    check_base_class_offset(lv, (S285C6*)(S285C5*)(S285C4*)(S285C3*)(S285C2*), 0, "S285C1");
    check_base_class_offset(lv, (S285C5*)(S285C4*)(S285C3*)(S285C2*), 0, "S285C1");
    check_base_class_offset(lv, (S285C4*)(S285C3*)(S285C2*), 0, "S285C1");
    check_base_class_offset(lv, (S285C3*)(S285C2*), 0, "S285C1");
    check_base_class_offset(lv, (S285C2*), 0, "S285C1");
    check_field_offset(lv, s285c1f0, ABISELECT(392,288), "S285C1.s285c1f0");
    check_field_offset(lv, s285c1f1, ABISELECT(400,296), "S285C1.s285c1f1");
    test_class_info(&lv, &cd_S285C1);
    dp->~S285C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS285C1(Test_S285C1, "S285C1", ABISELECT(416,304));

#else // __cplusplus

extern void _ZN6S285C1C1Ev();
extern void _ZN6S285C1D1Ev();
Name_Map name_map_S285C1[] = {
  NSPAIR(_ZN6S285C1C1Ev),
  NSPAIR(_ZN6S285C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S285C6;
extern VTBL_ENTRY _ZTI6S285C6[];
extern  VTBL_ENTRY _ZTV6S285C6[];
extern Class_Descriptor cd_S285C5;
extern VTBL_ENTRY _ZTI6S285C5[];
extern  VTBL_ENTRY _ZTV6S285C5[];
extern Class_Descriptor cd_S285C4;
extern VTBL_ENTRY _ZTI6S285C4[];
extern  VTBL_ENTRY _ZTV6S285C4[];
extern Class_Descriptor cd_S285C3;
extern VTBL_ENTRY _ZTI6S285C3[];
extern  VTBL_ENTRY _ZTV6S285C3[];
extern Class_Descriptor cd_S285C2;
extern VTBL_ENTRY _ZTI6S285C2[];
extern  VTBL_ENTRY _ZTV6S285C2[];
static Base_Class bases_S285C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S285C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S285C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S285C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S285C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S285C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S285C1[];
extern void _ZN6S285C1D1Ev();
extern void _ZN6S285C1D0Ev();
extern void _ZN6S285C62v9Ev();
extern void _ZN6S285C63v10Ev();
extern void _ZN6S285C63v11Ev();
extern void _ZN6S285C63v12Ev();
extern void _ZN6S285C63v13Ev();
extern void _ZN6S285C63v14Ev();
extern void _ZN6S285C63v15Ev();
extern void _ZN6S285C63v16Ev();
extern void _ZN6S285C63v17Ev();
extern void _ZN6S285C63v18Ev();
extern void _ZN6S285C63v19Ev();
extern void _ZN6S285C63v20Ev();
extern void _ZN6S285C63v21Ev();
extern void _ZN6S285C63v22Ev();
extern void _ZN6S285C63v23Ev();
extern void _ZN6S285C63v24Ev();
extern void _ZN6S285C63v25Ev();
extern void _ZN6S285C63v26Ev();
extern void _ZN6S285C63v27Ev();
extern void _ZN6S285C63v28Ev();
extern void _ZN6S285C63v29Ev();
extern void _ZN6S285C63v30Ev();
extern void _ZN6S285C63v31Ev();
extern void _ZN6S285C63v32Ev();
extern void _ZN6S285C63v33Ev();
extern void _ZN6S285C63v34Ev();
extern void _ZN6S285C63v35Ev();
extern void _ZN6S285C63v36Ev();
extern void _ZN6S285C63v37Ev();
extern void _ZN6S285C63v38Ev();
extern void _ZN6S285C63v39Ev();
extern void _ZN6S285C63v40Ev();
extern void _ZN6S285C63v41Ev();
extern void _ZN6S285C63v42Ev();
extern void _ZN6S285C63v43Ev();
extern void _ZN6S285C63v44Ev();
extern void _ZN6S285C63v45Ev();
extern void _ZN6S285C63v46Ev();
extern void _ZN6S285C63v47Ev();
extern void _ZN6S285C63v48Ev();
extern void _ZN6S285C63v49Ev();
extern void _ZN6S285C63v50Ev();
extern void _ZN6S285C63v51Ev();
extern void _ZN6S285C63v52Ev();
extern void _ZN6S285C63v53Ev();
extern void _ZN6S285C63v54Ev();
extern void _ZN6S285C63v55Ev();
extern void _ZN6S285C63v56Ev();
extern void _ZN6S285C63v57Ev();
extern void _ZN6S285C63v58Ev();
extern void _ZN6S285C63v59Ev();
extern void _ZN6S285C63v60Ev();
extern void _ZN6S285C63v61Ev();
extern void _ZN6S285C63v62Ev();
extern void _ZN6S285C63v63Ev();
extern void _ZN6S285C63v64Ev();
extern void _ZN6S285C63v65Ev();
extern void _ZN6S285C63v66Ev();
extern void _ZN6S285C63v67Ev();
extern void _ZN6S285C63v68Ev();
extern void _ZN6S285C63v69Ev();
extern void _ZN6S285C63v70Ev();
extern void _ZN6S285C63v71Ev();
extern void _ZN6S285C63v72Ev();
extern void _ZN6S285C53v73Ev();
extern void _ZN6S285C53v74Ev();
extern void _ZN6S285C53v75Ev();
extern void _ZN6S285C53v76Ev();
extern void _ZN6S285C53v77Ev();
extern void _ZN6S285C43v78Ev();
extern void _ZN6S285C43v79Ev();
extern void _ZN6S285C43v80Ev();
extern void _ZN6S285C43v81Ev();
extern void _ZN6S285C43v82Ev();
extern void _ZN6S285C43v83Ev();
extern void _ZN6S285C43v84Ev();
extern void _ZN6S285C43v85Ev();
extern void _ZN6S285C43v86Ev();
extern void _ZN6S285C43v87Ev();
extern void _ZN6S285C43v88Ev();
extern void _ZN6S285C43v89Ev();
extern void _ZN6S285C43v90Ev();
extern void _ZN6S285C43v91Ev();
extern void _ZN6S285C43v92Ev();
extern void _ZN6S285C43v93Ev();
extern void _ZN6S285C43v94Ev();
extern void _ZN6S285C43v95Ev();
extern void _ZN6S285C43v96Ev();
extern void _ZN6S285C43v97Ev();
extern void _ZN6S285C43v98Ev();
extern void _ZN6S285C43v99Ev();
extern void _ZN6S285C34v100Ev();
extern void _ZN6S285C34v101Ev();
extern void _ZN6S285C34v102Ev();
extern void _ZN6S285C34v103Ev();
extern void _ZN6S285C34v104Ev();
extern void _ZN6S285C34v105Ev();
extern void _ZN6S285C34v106Ev();
extern void _ZN6S285C34v107Ev();
extern void _ZN6S285C34v108Ev();
extern void _ZN6S285C34v109Ev();
extern void _ZN6S285C34v110Ev();
extern void _ZN6S285C34v111Ev();
extern void _ZN6S285C34v112Ev();
extern void _ZN6S285C34v113Ev();
extern void _ZN6S285C34v114Ev();
extern void _ZN6S285C34v115Ev();
extern void _ZN6S285C34v116Ev();
extern void _ZN6S285C34v117Ev();
extern void _ZN6S285C34v118Ev();
extern void _ZN6S285C34v119Ev();
extern void _ZN6S285C34v120Ev();
extern void _ZN6S285C34v121Ev();
extern void _ZN6S285C34v122Ev();
extern void _ZN6S285C34v123Ev();
extern void _ZN6S285C34v124Ev();
extern void _ZN6S285C34v125Ev();
extern void _ZN6S285C34v126Ev();
extern void _ZN6S285C24v127Ev();
extern void _ZN6S285C24v128Ev();
extern void _ZN6S285C24v129Ev();
extern void _ZN6S285C24v130Ev();
extern void _ZN6S285C24v131Ev();
extern void _ZN6S285C24v132Ev();
extern void _ZN6S285C24v133Ev();
extern void _ZN6S285C24v134Ev();
extern void _ZN6S285C24v135Ev();
extern void _ZN6S285C24v136Ev();
extern void _ZN6S285C24v137Ev();
extern void _ZN6S285C24v138Ev();
extern void _ZN6S285C24v139Ev();
extern void _ZN6S285C24v140Ev();
extern void _ZN6S285C12v1Ev();
extern void _ZN6S285C12v2Ev();
extern void _ZN6S285C12v3Ev();
extern void _ZN6S285C12v4Ev();
extern void _ZN6S285C12v5Ev();
extern void _ZN6S285C12v6Ev();
extern void _ZN6S285C12v7Ev();
extern void _ZN6S285C12v8Ev();
static  VTBL_ENTRY vtc_S285C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S285C1[0]),
  (VTBL_ENTRY)&_ZN6S285C1D1Ev,
  (VTBL_ENTRY)&_ZN6S285C1D0Ev,
  (VTBL_ENTRY)&_ZN6S285C62v9Ev,
  (VTBL_ENTRY)&_ZN6S285C63v10Ev,
  (VTBL_ENTRY)&_ZN6S285C63v11Ev,
  (VTBL_ENTRY)&_ZN6S285C63v12Ev,
  (VTBL_ENTRY)&_ZN6S285C63v13Ev,
  (VTBL_ENTRY)&_ZN6S285C63v14Ev,
  (VTBL_ENTRY)&_ZN6S285C63v15Ev,
  (VTBL_ENTRY)&_ZN6S285C63v16Ev,
  (VTBL_ENTRY)&_ZN6S285C63v17Ev,
  (VTBL_ENTRY)&_ZN6S285C63v18Ev,
  (VTBL_ENTRY)&_ZN6S285C63v19Ev,
  (VTBL_ENTRY)&_ZN6S285C63v20Ev,
  (VTBL_ENTRY)&_ZN6S285C63v21Ev,
  (VTBL_ENTRY)&_ZN6S285C63v22Ev,
  (VTBL_ENTRY)&_ZN6S285C63v23Ev,
  (VTBL_ENTRY)&_ZN6S285C63v24Ev,
  (VTBL_ENTRY)&_ZN6S285C63v25Ev,
  (VTBL_ENTRY)&_ZN6S285C63v26Ev,
  (VTBL_ENTRY)&_ZN6S285C63v27Ev,
  (VTBL_ENTRY)&_ZN6S285C63v28Ev,
  (VTBL_ENTRY)&_ZN6S285C63v29Ev,
  (VTBL_ENTRY)&_ZN6S285C63v30Ev,
  (VTBL_ENTRY)&_ZN6S285C63v31Ev,
  (VTBL_ENTRY)&_ZN6S285C63v32Ev,
  (VTBL_ENTRY)&_ZN6S285C63v33Ev,
  (VTBL_ENTRY)&_ZN6S285C63v34Ev,
  (VTBL_ENTRY)&_ZN6S285C63v35Ev,
  (VTBL_ENTRY)&_ZN6S285C63v36Ev,
  (VTBL_ENTRY)&_ZN6S285C63v37Ev,
  (VTBL_ENTRY)&_ZN6S285C63v38Ev,
  (VTBL_ENTRY)&_ZN6S285C63v39Ev,
  (VTBL_ENTRY)&_ZN6S285C63v40Ev,
  (VTBL_ENTRY)&_ZN6S285C63v41Ev,
  (VTBL_ENTRY)&_ZN6S285C63v42Ev,
  (VTBL_ENTRY)&_ZN6S285C63v43Ev,
  (VTBL_ENTRY)&_ZN6S285C63v44Ev,
  (VTBL_ENTRY)&_ZN6S285C63v45Ev,
  (VTBL_ENTRY)&_ZN6S285C63v46Ev,
  (VTBL_ENTRY)&_ZN6S285C63v47Ev,
  (VTBL_ENTRY)&_ZN6S285C63v48Ev,
  (VTBL_ENTRY)&_ZN6S285C63v49Ev,
  (VTBL_ENTRY)&_ZN6S285C63v50Ev,
  (VTBL_ENTRY)&_ZN6S285C63v51Ev,
  (VTBL_ENTRY)&_ZN6S285C63v52Ev,
  (VTBL_ENTRY)&_ZN6S285C63v53Ev,
  (VTBL_ENTRY)&_ZN6S285C63v54Ev,
  (VTBL_ENTRY)&_ZN6S285C63v55Ev,
  (VTBL_ENTRY)&_ZN6S285C63v56Ev,
  (VTBL_ENTRY)&_ZN6S285C63v57Ev,
  (VTBL_ENTRY)&_ZN6S285C63v58Ev,
  (VTBL_ENTRY)&_ZN6S285C63v59Ev,
  (VTBL_ENTRY)&_ZN6S285C63v60Ev,
  (VTBL_ENTRY)&_ZN6S285C63v61Ev,
  (VTBL_ENTRY)&_ZN6S285C63v62Ev,
  (VTBL_ENTRY)&_ZN6S285C63v63Ev,
  (VTBL_ENTRY)&_ZN6S285C63v64Ev,
  (VTBL_ENTRY)&_ZN6S285C63v65Ev,
  (VTBL_ENTRY)&_ZN6S285C63v66Ev,
  (VTBL_ENTRY)&_ZN6S285C63v67Ev,
  (VTBL_ENTRY)&_ZN6S285C63v68Ev,
  (VTBL_ENTRY)&_ZN6S285C63v69Ev,
  (VTBL_ENTRY)&_ZN6S285C63v70Ev,
  (VTBL_ENTRY)&_ZN6S285C63v71Ev,
  (VTBL_ENTRY)&_ZN6S285C63v72Ev,
  (VTBL_ENTRY)&_ZN6S285C53v73Ev,
  (VTBL_ENTRY)&_ZN6S285C53v74Ev,
  (VTBL_ENTRY)&_ZN6S285C53v75Ev,
  (VTBL_ENTRY)&_ZN6S285C53v76Ev,
  (VTBL_ENTRY)&_ZN6S285C53v77Ev,
  (VTBL_ENTRY)&_ZN6S285C43v78Ev,
  (VTBL_ENTRY)&_ZN6S285C43v79Ev,
  (VTBL_ENTRY)&_ZN6S285C43v80Ev,
  (VTBL_ENTRY)&_ZN6S285C43v81Ev,
  (VTBL_ENTRY)&_ZN6S285C43v82Ev,
  (VTBL_ENTRY)&_ZN6S285C43v83Ev,
  (VTBL_ENTRY)&_ZN6S285C43v84Ev,
  (VTBL_ENTRY)&_ZN6S285C43v85Ev,
  (VTBL_ENTRY)&_ZN6S285C43v86Ev,
  (VTBL_ENTRY)&_ZN6S285C43v87Ev,
  (VTBL_ENTRY)&_ZN6S285C43v88Ev,
  (VTBL_ENTRY)&_ZN6S285C43v89Ev,
  (VTBL_ENTRY)&_ZN6S285C43v90Ev,
  (VTBL_ENTRY)&_ZN6S285C43v91Ev,
  (VTBL_ENTRY)&_ZN6S285C43v92Ev,
  (VTBL_ENTRY)&_ZN6S285C43v93Ev,
  (VTBL_ENTRY)&_ZN6S285C43v94Ev,
  (VTBL_ENTRY)&_ZN6S285C43v95Ev,
  (VTBL_ENTRY)&_ZN6S285C43v96Ev,
  (VTBL_ENTRY)&_ZN6S285C43v97Ev,
  (VTBL_ENTRY)&_ZN6S285C43v98Ev,
  (VTBL_ENTRY)&_ZN6S285C43v99Ev,
  (VTBL_ENTRY)&_ZN6S285C34v100Ev,
  (VTBL_ENTRY)&_ZN6S285C34v101Ev,
  (VTBL_ENTRY)&_ZN6S285C34v102Ev,
  (VTBL_ENTRY)&_ZN6S285C34v103Ev,
  (VTBL_ENTRY)&_ZN6S285C34v104Ev,
  (VTBL_ENTRY)&_ZN6S285C34v105Ev,
  (VTBL_ENTRY)&_ZN6S285C34v106Ev,
  (VTBL_ENTRY)&_ZN6S285C34v107Ev,
  (VTBL_ENTRY)&_ZN6S285C34v108Ev,
  (VTBL_ENTRY)&_ZN6S285C34v109Ev,
  (VTBL_ENTRY)&_ZN6S285C34v110Ev,
  (VTBL_ENTRY)&_ZN6S285C34v111Ev,
  (VTBL_ENTRY)&_ZN6S285C34v112Ev,
  (VTBL_ENTRY)&_ZN6S285C34v113Ev,
  (VTBL_ENTRY)&_ZN6S285C34v114Ev,
  (VTBL_ENTRY)&_ZN6S285C34v115Ev,
  (VTBL_ENTRY)&_ZN6S285C34v116Ev,
  (VTBL_ENTRY)&_ZN6S285C34v117Ev,
  (VTBL_ENTRY)&_ZN6S285C34v118Ev,
  (VTBL_ENTRY)&_ZN6S285C34v119Ev,
  (VTBL_ENTRY)&_ZN6S285C34v120Ev,
  (VTBL_ENTRY)&_ZN6S285C34v121Ev,
  (VTBL_ENTRY)&_ZN6S285C34v122Ev,
  (VTBL_ENTRY)&_ZN6S285C34v123Ev,
  (VTBL_ENTRY)&_ZN6S285C34v124Ev,
  (VTBL_ENTRY)&_ZN6S285C34v125Ev,
  (VTBL_ENTRY)&_ZN6S285C34v126Ev,
  (VTBL_ENTRY)&_ZN6S285C24v127Ev,
  (VTBL_ENTRY)&_ZN6S285C24v128Ev,
  (VTBL_ENTRY)&_ZN6S285C24v129Ev,
  (VTBL_ENTRY)&_ZN6S285C24v130Ev,
  (VTBL_ENTRY)&_ZN6S285C24v131Ev,
  (VTBL_ENTRY)&_ZN6S285C24v132Ev,
  (VTBL_ENTRY)&_ZN6S285C24v133Ev,
  (VTBL_ENTRY)&_ZN6S285C24v134Ev,
  (VTBL_ENTRY)&_ZN6S285C24v135Ev,
  (VTBL_ENTRY)&_ZN6S285C24v136Ev,
  (VTBL_ENTRY)&_ZN6S285C24v137Ev,
  (VTBL_ENTRY)&_ZN6S285C24v138Ev,
  (VTBL_ENTRY)&_ZN6S285C24v139Ev,
  (VTBL_ENTRY)&_ZN6S285C24v140Ev,
  (VTBL_ENTRY)&_ZN6S285C12v1Ev,
  (VTBL_ENTRY)&_ZN6S285C12v2Ev,
  (VTBL_ENTRY)&_ZN6S285C12v3Ev,
  (VTBL_ENTRY)&_ZN6S285C12v4Ev,
  (VTBL_ENTRY)&_ZN6S285C12v5Ev,
  (VTBL_ENTRY)&_ZN6S285C12v6Ev,
  (VTBL_ENTRY)&_ZN6S285C12v7Ev,
  (VTBL_ENTRY)&_ZN6S285C12v8Ev,
};
extern VTBL_ENTRY _ZTI6S285C1[];
extern  VTBL_ENTRY _ZTV6S285C1[];
Class_Descriptor cd_S285C1 = {  "S285C1", // class name
  bases_S285C1, 5,
  &(vtc_S285C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(416,304), // object size
  NSPAIRA(_ZTI6S285C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S285C1),144, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S704C5  {
  int s704c5f0;
  __tsi64 s704c5f1;
  void *s704c5f2[4];
  int s704c5f3[2];
  void *s704c5f4;
  ::S235C7_nt s704c5f5;
  void *s704c5f6[2];
  virtual  ~S704C5(); // _ZN6S704C5D1Ev
  virtual void  v8(); // _ZN6S704C52v8Ev
  virtual void  v9(); // _ZN6S704C52v9Ev
  virtual void  v10(); // _ZN6S704C53v10Ev
  virtual void  v11(); // _ZN6S704C53v11Ev
  virtual void  v12(); // _ZN6S704C53v12Ev
  virtual void  v13(); // _ZN6S704C53v13Ev
  virtual void  v14(); // _ZN6S704C53v14Ev
  virtual void  v15(); // _ZN6S704C53v15Ev
  virtual void  v16(); // _ZN6S704C53v16Ev
  virtual void  v17(); // _ZN6S704C53v17Ev
  virtual void  v18(); // _ZN6S704C53v18Ev
  virtual void  v19(); // _ZN6S704C53v19Ev
  virtual void  v20(); // _ZN6S704C53v20Ev
  virtual void  v21(); // _ZN6S704C53v21Ev
  virtual void  v22(); // _ZN6S704C53v22Ev
  virtual void  v23(); // _ZN6S704C53v23Ev
  virtual void  v24(); // _ZN6S704C53v24Ev
  virtual void  v25(); // _ZN6S704C53v25Ev
  virtual void  v26(); // _ZN6S704C53v26Ev
  virtual void  v27(); // _ZN6S704C53v27Ev
  virtual void  v28(); // _ZN6S704C53v28Ev
  virtual void  v29(); // _ZN6S704C53v29Ev
  virtual void  v30(); // _ZN6S704C53v30Ev
  virtual void  v31(); // _ZN6S704C53v31Ev
  virtual void  v32(); // _ZN6S704C53v32Ev
  virtual void  v33(); // _ZN6S704C53v33Ev
  virtual void  v34(); // _ZN6S704C53v34Ev
  virtual void  v35(); // _ZN6S704C53v35Ev
  virtual void  v36(); // _ZN6S704C53v36Ev
  virtual void  v37(); // _ZN6S704C53v37Ev
  virtual void  v38(); // _ZN6S704C53v38Ev
  virtual void  v39(); // _ZN6S704C53v39Ev
  virtual void  v40(); // _ZN6S704C53v40Ev
  virtual void  v41(); // _ZN6S704C53v41Ev
  virtual void  v42(); // _ZN6S704C53v42Ev
  virtual void  v43(); // _ZN6S704C53v43Ev
  virtual void  v44(); // _ZN6S704C53v44Ev
  virtual void  v45(); // _ZN6S704C53v45Ev
  virtual void  v46(); // _ZN6S704C53v46Ev
  virtual void  v47(); // _ZN6S704C53v47Ev
  virtual void  v48(); // _ZN6S704C53v48Ev
  virtual void  v49(); // _ZN6S704C53v49Ev
  virtual void  v50(); // _ZN6S704C53v50Ev
  virtual void  v51(); // _ZN6S704C53v51Ev
  virtual void  v52(); // _ZN6S704C53v52Ev
  virtual void  v53(); // _ZN6S704C53v53Ev
  virtual void  v54(); // _ZN6S704C53v54Ev
  virtual void  v55(); // _ZN6S704C53v55Ev
  virtual void  v56(); // _ZN6S704C53v56Ev
  virtual void  v57(); // _ZN6S704C53v57Ev
  virtual void  v58(); // _ZN6S704C53v58Ev
  virtual void  v59(); // _ZN6S704C53v59Ev
  virtual void  v60(); // _ZN6S704C53v60Ev
  virtual void  v61(); // _ZN6S704C53v61Ev
  virtual void  v62(); // _ZN6S704C53v62Ev
  virtual void  v63(); // _ZN6S704C53v63Ev
  virtual void  v64(); // _ZN6S704C53v64Ev
  virtual void  v65(); // _ZN6S704C53v65Ev
  virtual void  v66(); // _ZN6S704C53v66Ev
  virtual void  v67(); // _ZN6S704C53v67Ev
  virtual void  v68(); // _ZN6S704C53v68Ev
  virtual void  v69(); // _ZN6S704C53v69Ev
  virtual void  v70(); // _ZN6S704C53v70Ev
  virtual void  v71(); // _ZN6S704C53v71Ev
  S704C5(); // tgen
};
//SIG(-1 S704C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S704C5 ::~S704C5(){ note_dtor("S704C5", this);}
void  S704C5 ::v8(){vfunc_called(this, "_ZN6S704C52v8Ev");}
void  S704C5 ::v9(){vfunc_called(this, "_ZN6S704C52v9Ev");}
void  S704C5 ::v10(){vfunc_called(this, "_ZN6S704C53v10Ev");}
void  S704C5 ::v11(){vfunc_called(this, "_ZN6S704C53v11Ev");}
void  S704C5 ::v12(){vfunc_called(this, "_ZN6S704C53v12Ev");}
void  S704C5 ::v13(){vfunc_called(this, "_ZN6S704C53v13Ev");}
void  S704C5 ::v14(){vfunc_called(this, "_ZN6S704C53v14Ev");}
void  S704C5 ::v15(){vfunc_called(this, "_ZN6S704C53v15Ev");}
void  S704C5 ::v16(){vfunc_called(this, "_ZN6S704C53v16Ev");}
void  S704C5 ::v17(){vfunc_called(this, "_ZN6S704C53v17Ev");}
void  S704C5 ::v18(){vfunc_called(this, "_ZN6S704C53v18Ev");}
void  S704C5 ::v19(){vfunc_called(this, "_ZN6S704C53v19Ev");}
void  S704C5 ::v20(){vfunc_called(this, "_ZN6S704C53v20Ev");}
void  S704C5 ::v21(){vfunc_called(this, "_ZN6S704C53v21Ev");}
void  S704C5 ::v22(){vfunc_called(this, "_ZN6S704C53v22Ev");}
void  S704C5 ::v23(){vfunc_called(this, "_ZN6S704C53v23Ev");}
void  S704C5 ::v24(){vfunc_called(this, "_ZN6S704C53v24Ev");}
void  S704C5 ::v25(){vfunc_called(this, "_ZN6S704C53v25Ev");}
void  S704C5 ::v26(){vfunc_called(this, "_ZN6S704C53v26Ev");}
void  S704C5 ::v27(){vfunc_called(this, "_ZN6S704C53v27Ev");}
void  S704C5 ::v28(){vfunc_called(this, "_ZN6S704C53v28Ev");}
void  S704C5 ::v29(){vfunc_called(this, "_ZN6S704C53v29Ev");}
void  S704C5 ::v30(){vfunc_called(this, "_ZN6S704C53v30Ev");}
void  S704C5 ::v31(){vfunc_called(this, "_ZN6S704C53v31Ev");}
void  S704C5 ::v32(){vfunc_called(this, "_ZN6S704C53v32Ev");}
void  S704C5 ::v33(){vfunc_called(this, "_ZN6S704C53v33Ev");}
void  S704C5 ::v34(){vfunc_called(this, "_ZN6S704C53v34Ev");}
void  S704C5 ::v35(){vfunc_called(this, "_ZN6S704C53v35Ev");}
void  S704C5 ::v36(){vfunc_called(this, "_ZN6S704C53v36Ev");}
void  S704C5 ::v37(){vfunc_called(this, "_ZN6S704C53v37Ev");}
void  S704C5 ::v38(){vfunc_called(this, "_ZN6S704C53v38Ev");}
void  S704C5 ::v39(){vfunc_called(this, "_ZN6S704C53v39Ev");}
void  S704C5 ::v40(){vfunc_called(this, "_ZN6S704C53v40Ev");}
void  S704C5 ::v41(){vfunc_called(this, "_ZN6S704C53v41Ev");}
void  S704C5 ::v42(){vfunc_called(this, "_ZN6S704C53v42Ev");}
void  S704C5 ::v43(){vfunc_called(this, "_ZN6S704C53v43Ev");}
void  S704C5 ::v44(){vfunc_called(this, "_ZN6S704C53v44Ev");}
void  S704C5 ::v45(){vfunc_called(this, "_ZN6S704C53v45Ev");}
void  S704C5 ::v46(){vfunc_called(this, "_ZN6S704C53v46Ev");}
void  S704C5 ::v47(){vfunc_called(this, "_ZN6S704C53v47Ev");}
void  S704C5 ::v48(){vfunc_called(this, "_ZN6S704C53v48Ev");}
void  S704C5 ::v49(){vfunc_called(this, "_ZN6S704C53v49Ev");}
void  S704C5 ::v50(){vfunc_called(this, "_ZN6S704C53v50Ev");}
void  S704C5 ::v51(){vfunc_called(this, "_ZN6S704C53v51Ev");}
void  S704C5 ::v52(){vfunc_called(this, "_ZN6S704C53v52Ev");}
void  S704C5 ::v53(){vfunc_called(this, "_ZN6S704C53v53Ev");}
void  S704C5 ::v54(){vfunc_called(this, "_ZN6S704C53v54Ev");}
void  S704C5 ::v55(){vfunc_called(this, "_ZN6S704C53v55Ev");}
void  S704C5 ::v56(){vfunc_called(this, "_ZN6S704C53v56Ev");}
void  S704C5 ::v57(){vfunc_called(this, "_ZN6S704C53v57Ev");}
void  S704C5 ::v58(){vfunc_called(this, "_ZN6S704C53v58Ev");}
void  S704C5 ::v59(){vfunc_called(this, "_ZN6S704C53v59Ev");}
void  S704C5 ::v60(){vfunc_called(this, "_ZN6S704C53v60Ev");}
void  S704C5 ::v61(){vfunc_called(this, "_ZN6S704C53v61Ev");}
void  S704C5 ::v62(){vfunc_called(this, "_ZN6S704C53v62Ev");}
void  S704C5 ::v63(){vfunc_called(this, "_ZN6S704C53v63Ev");}
void  S704C5 ::v64(){vfunc_called(this, "_ZN6S704C53v64Ev");}
void  S704C5 ::v65(){vfunc_called(this, "_ZN6S704C53v65Ev");}
void  S704C5 ::v66(){vfunc_called(this, "_ZN6S704C53v66Ev");}
void  S704C5 ::v67(){vfunc_called(this, "_ZN6S704C53v67Ev");}
void  S704C5 ::v68(){vfunc_called(this, "_ZN6S704C53v68Ev");}
void  S704C5 ::v69(){vfunc_called(this, "_ZN6S704C53v69Ev");}
void  S704C5 ::v70(){vfunc_called(this, "_ZN6S704C53v70Ev");}
void  S704C5 ::v71(){vfunc_called(this, "_ZN6S704C53v71Ev");}
S704C5 ::S704C5(){ note_ctor("S704C5", this);} // tgen

static void Test_S704C5()
{
  extern Class_Descriptor cd_S704C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S704C5, buf);
    S704C5 *dp, &lv = *(dp=new (buf) S704C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S704C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S704C5)");
    check_field_offset(lv, s704c5f0, ABISELECT(8,4), "S704C5.s704c5f0");
    check_field_offset(lv, s704c5f1, ABISELECT(16,8), "S704C5.s704c5f1");
    check_field_offset(lv, s704c5f2, ABISELECT(24,16), "S704C5.s704c5f2");
    check_field_offset(lv, s704c5f3, ABISELECT(56,32), "S704C5.s704c5f3");
    check_field_offset(lv, s704c5f4, ABISELECT(64,40), "S704C5.s704c5f4");
    check_field_offset(lv, s704c5f5, ABISELECT(72,44), "S704C5.s704c5f5");
    check_field_offset(lv, s704c5f6, ABISELECT(80,52), "S704C5.s704c5f6");
    test_class_info(&lv, &cd_S704C5);
    dp->~S704C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS704C5(Test_S704C5, "S704C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S704C5C1Ev();
extern void _ZN6S704C5D1Ev();
Name_Map name_map_S704C5[] = {
  NSPAIR(_ZN6S704C5C1Ev),
  NSPAIR(_ZN6S704C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S704C5[];
extern void _ZN6S704C5D1Ev();
extern void _ZN6S704C5D0Ev();
extern void _ZN6S704C52v8Ev();
extern void _ZN6S704C52v9Ev();
extern void _ZN6S704C53v10Ev();
extern void _ZN6S704C53v11Ev();
extern void _ZN6S704C53v12Ev();
extern void _ZN6S704C53v13Ev();
extern void _ZN6S704C53v14Ev();
extern void _ZN6S704C53v15Ev();
extern void _ZN6S704C53v16Ev();
extern void _ZN6S704C53v17Ev();
extern void _ZN6S704C53v18Ev();
extern void _ZN6S704C53v19Ev();
extern void _ZN6S704C53v20Ev();
extern void _ZN6S704C53v21Ev();
extern void _ZN6S704C53v22Ev();
extern void _ZN6S704C53v23Ev();
extern void _ZN6S704C53v24Ev();
extern void _ZN6S704C53v25Ev();
extern void _ZN6S704C53v26Ev();
extern void _ZN6S704C53v27Ev();
extern void _ZN6S704C53v28Ev();
extern void _ZN6S704C53v29Ev();
extern void _ZN6S704C53v30Ev();
extern void _ZN6S704C53v31Ev();
extern void _ZN6S704C53v32Ev();
extern void _ZN6S704C53v33Ev();
extern void _ZN6S704C53v34Ev();
extern void _ZN6S704C53v35Ev();
extern void _ZN6S704C53v36Ev();
extern void _ZN6S704C53v37Ev();
extern void _ZN6S704C53v38Ev();
extern void _ZN6S704C53v39Ev();
extern void _ZN6S704C53v40Ev();
extern void _ZN6S704C53v41Ev();
extern void _ZN6S704C53v42Ev();
extern void _ZN6S704C53v43Ev();
extern void _ZN6S704C53v44Ev();
extern void _ZN6S704C53v45Ev();
extern void _ZN6S704C53v46Ev();
extern void _ZN6S704C53v47Ev();
extern void _ZN6S704C53v48Ev();
extern void _ZN6S704C53v49Ev();
extern void _ZN6S704C53v50Ev();
extern void _ZN6S704C53v51Ev();
extern void _ZN6S704C53v52Ev();
extern void _ZN6S704C53v53Ev();
extern void _ZN6S704C53v54Ev();
extern void _ZN6S704C53v55Ev();
extern void _ZN6S704C53v56Ev();
extern void _ZN6S704C53v57Ev();
extern void _ZN6S704C53v58Ev();
extern void _ZN6S704C53v59Ev();
extern void _ZN6S704C53v60Ev();
extern void _ZN6S704C53v61Ev();
extern void _ZN6S704C53v62Ev();
extern void _ZN6S704C53v63Ev();
extern void _ZN6S704C53v64Ev();
extern void _ZN6S704C53v65Ev();
extern void _ZN6S704C53v66Ev();
extern void _ZN6S704C53v67Ev();
extern void _ZN6S704C53v68Ev();
extern void _ZN6S704C53v69Ev();
extern void _ZN6S704C53v70Ev();
extern void _ZN6S704C53v71Ev();
static  VTBL_ENTRY vtc_S704C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S704C5[0]),
  (VTBL_ENTRY)&_ZN6S704C5D1Ev,
  (VTBL_ENTRY)&_ZN6S704C5D0Ev,
  (VTBL_ENTRY)&_ZN6S704C52v8Ev,
  (VTBL_ENTRY)&_ZN6S704C52v9Ev,
  (VTBL_ENTRY)&_ZN6S704C53v10Ev,
  (VTBL_ENTRY)&_ZN6S704C53v11Ev,
  (VTBL_ENTRY)&_ZN6S704C53v12Ev,
  (VTBL_ENTRY)&_ZN6S704C53v13Ev,
  (VTBL_ENTRY)&_ZN6S704C53v14Ev,
  (VTBL_ENTRY)&_ZN6S704C53v15Ev,
  (VTBL_ENTRY)&_ZN6S704C53v16Ev,
  (VTBL_ENTRY)&_ZN6S704C53v17Ev,
  (VTBL_ENTRY)&_ZN6S704C53v18Ev,
  (VTBL_ENTRY)&_ZN6S704C53v19Ev,
  (VTBL_ENTRY)&_ZN6S704C53v20Ev,
  (VTBL_ENTRY)&_ZN6S704C53v21Ev,
  (VTBL_ENTRY)&_ZN6S704C53v22Ev,
  (VTBL_ENTRY)&_ZN6S704C53v23Ev,
  (VTBL_ENTRY)&_ZN6S704C53v24Ev,
  (VTBL_ENTRY)&_ZN6S704C53v25Ev,
  (VTBL_ENTRY)&_ZN6S704C53v26Ev,
  (VTBL_ENTRY)&_ZN6S704C53v27Ev,
  (VTBL_ENTRY)&_ZN6S704C53v28Ev,
  (VTBL_ENTRY)&_ZN6S704C53v29Ev,
  (VTBL_ENTRY)&_ZN6S704C53v30Ev,
  (VTBL_ENTRY)&_ZN6S704C53v31Ev,
  (VTBL_ENTRY)&_ZN6S704C53v32Ev,
  (VTBL_ENTRY)&_ZN6S704C53v33Ev,
  (VTBL_ENTRY)&_ZN6S704C53v34Ev,
  (VTBL_ENTRY)&_ZN6S704C53v35Ev,
  (VTBL_ENTRY)&_ZN6S704C53v36Ev,
  (VTBL_ENTRY)&_ZN6S704C53v37Ev,
  (VTBL_ENTRY)&_ZN6S704C53v38Ev,
  (VTBL_ENTRY)&_ZN6S704C53v39Ev,
  (VTBL_ENTRY)&_ZN6S704C53v40Ev,
  (VTBL_ENTRY)&_ZN6S704C53v41Ev,
  (VTBL_ENTRY)&_ZN6S704C53v42Ev,
  (VTBL_ENTRY)&_ZN6S704C53v43Ev,
  (VTBL_ENTRY)&_ZN6S704C53v44Ev,
  (VTBL_ENTRY)&_ZN6S704C53v45Ev,
  (VTBL_ENTRY)&_ZN6S704C53v46Ev,
  (VTBL_ENTRY)&_ZN6S704C53v47Ev,
  (VTBL_ENTRY)&_ZN6S704C53v48Ev,
  (VTBL_ENTRY)&_ZN6S704C53v49Ev,
  (VTBL_ENTRY)&_ZN6S704C53v50Ev,
  (VTBL_ENTRY)&_ZN6S704C53v51Ev,
  (VTBL_ENTRY)&_ZN6S704C53v52Ev,
  (VTBL_ENTRY)&_ZN6S704C53v53Ev,
  (VTBL_ENTRY)&_ZN6S704C53v54Ev,
  (VTBL_ENTRY)&_ZN6S704C53v55Ev,
  (VTBL_ENTRY)&_ZN6S704C53v56Ev,
  (VTBL_ENTRY)&_ZN6S704C53v57Ev,
  (VTBL_ENTRY)&_ZN6S704C53v58Ev,
  (VTBL_ENTRY)&_ZN6S704C53v59Ev,
  (VTBL_ENTRY)&_ZN6S704C53v60Ev,
  (VTBL_ENTRY)&_ZN6S704C53v61Ev,
  (VTBL_ENTRY)&_ZN6S704C53v62Ev,
  (VTBL_ENTRY)&_ZN6S704C53v63Ev,
  (VTBL_ENTRY)&_ZN6S704C53v64Ev,
  (VTBL_ENTRY)&_ZN6S704C53v65Ev,
  (VTBL_ENTRY)&_ZN6S704C53v66Ev,
  (VTBL_ENTRY)&_ZN6S704C53v67Ev,
  (VTBL_ENTRY)&_ZN6S704C53v68Ev,
  (VTBL_ENTRY)&_ZN6S704C53v69Ev,
  (VTBL_ENTRY)&_ZN6S704C53v70Ev,
  (VTBL_ENTRY)&_ZN6S704C53v71Ev,
};
extern VTBL_ENTRY _ZTI6S704C5[];
extern  VTBL_ENTRY _ZTV6S704C5[];
Class_Descriptor cd_S704C5 = {  "S704C5", // class name
  0,0,//no base classes
  &(vtc_S704C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S704C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S704C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S704C4  : S704C5 {
  void *s704c4f0;
  ::S235C7_nt s704c4f1;
  virtual  ~S704C4(); // _ZN6S704C4D1Ev
  virtual void  v72(); // _ZN6S704C43v72Ev
  virtual void  v73(); // _ZN6S704C43v73Ev
  virtual void  v74(); // _ZN6S704C43v74Ev
  virtual void  v75(); // _ZN6S704C43v75Ev
  virtual void  v76(); // _ZN6S704C43v76Ev
  S704C4(); // tgen
};
//SIG(-1 S704C4) C1{ BC2{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 Fp FC3}


 S704C4 ::~S704C4(){ note_dtor("S704C4", this);}
void  S704C4 ::v72(){vfunc_called(this, "_ZN6S704C43v72Ev");}
void  S704C4 ::v73(){vfunc_called(this, "_ZN6S704C43v73Ev");}
void  S704C4 ::v74(){vfunc_called(this, "_ZN6S704C43v74Ev");}
void  S704C4 ::v75(){vfunc_called(this, "_ZN6S704C43v75Ev");}
void  S704C4 ::v76(){vfunc_called(this, "_ZN6S704C43v76Ev");}
S704C4 ::S704C4(){ note_ctor("S704C4", this);} // tgen

static void Test_S704C4()
{
  extern Class_Descriptor cd_S704C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,19)];
    init_test(&cd_S704C4, buf);
    S704C4 *dp, &lv = *(dp=new (buf) S704C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,72), "sizeof(S704C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S704C4)");
    check_base_class_offset(lv, (S704C5*), 0, "S704C4");
    check_field_offset(lv, s704c4f0, ABISELECT(96,60), "S704C4.s704c4f0");
    check_field_offset(lv, s704c4f1, ABISELECT(104,64), "S704C4.s704c4f1");
    test_class_info(&lv, &cd_S704C4);
    dp->~S704C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS704C4(Test_S704C4, "S704C4", ABISELECT(112,72));

#else // __cplusplus

extern void _ZN6S704C4C1Ev();
extern void _ZN6S704C4D1Ev();
Name_Map name_map_S704C4[] = {
  NSPAIR(_ZN6S704C4C1Ev),
  NSPAIR(_ZN6S704C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S704C5;
extern VTBL_ENTRY _ZTI6S704C5[];
extern  VTBL_ENTRY _ZTV6S704C5[];
static Base_Class bases_S704C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S704C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S704C4[];
extern void _ZN6S704C4D1Ev();
extern void _ZN6S704C4D0Ev();
extern void _ZN6S704C52v8Ev();
extern void _ZN6S704C52v9Ev();
extern void _ZN6S704C53v10Ev();
extern void _ZN6S704C53v11Ev();
extern void _ZN6S704C53v12Ev();
extern void _ZN6S704C53v13Ev();
extern void _ZN6S704C53v14Ev();
extern void _ZN6S704C53v15Ev();
extern void _ZN6S704C53v16Ev();
extern void _ZN6S704C53v17Ev();
extern void _ZN6S704C53v18Ev();
extern void _ZN6S704C53v19Ev();
extern void _ZN6S704C53v20Ev();
extern void _ZN6S704C53v21Ev();
extern void _ZN6S704C53v22Ev();
extern void _ZN6S704C53v23Ev();
extern void _ZN6S704C53v24Ev();
extern void _ZN6S704C53v25Ev();
extern void _ZN6S704C53v26Ev();
extern void _ZN6S704C53v27Ev();
extern void _ZN6S704C53v28Ev();
extern void _ZN6S704C53v29Ev();
extern void _ZN6S704C53v30Ev();
extern void _ZN6S704C53v31Ev();
extern void _ZN6S704C53v32Ev();
extern void _ZN6S704C53v33Ev();
extern void _ZN6S704C53v34Ev();
extern void _ZN6S704C53v35Ev();
extern void _ZN6S704C53v36Ev();
extern void _ZN6S704C53v37Ev();
extern void _ZN6S704C53v38Ev();
extern void _ZN6S704C53v39Ev();
extern void _ZN6S704C53v40Ev();
extern void _ZN6S704C53v41Ev();
extern void _ZN6S704C53v42Ev();
extern void _ZN6S704C53v43Ev();
extern void _ZN6S704C53v44Ev();
extern void _ZN6S704C53v45Ev();
extern void _ZN6S704C53v46Ev();
extern void _ZN6S704C53v47Ev();
extern void _ZN6S704C53v48Ev();
extern void _ZN6S704C53v49Ev();
extern void _ZN6S704C53v50Ev();
extern void _ZN6S704C53v51Ev();
extern void _ZN6S704C53v52Ev();
extern void _ZN6S704C53v53Ev();
extern void _ZN6S704C53v54Ev();
extern void _ZN6S704C53v55Ev();
extern void _ZN6S704C53v56Ev();
extern void _ZN6S704C53v57Ev();
extern void _ZN6S704C53v58Ev();
extern void _ZN6S704C53v59Ev();
extern void _ZN6S704C53v60Ev();
extern void _ZN6S704C53v61Ev();
extern void _ZN6S704C53v62Ev();
extern void _ZN6S704C53v63Ev();
extern void _ZN6S704C53v64Ev();
extern void _ZN6S704C53v65Ev();
extern void _ZN6S704C53v66Ev();
extern void _ZN6S704C53v67Ev();
extern void _ZN6S704C53v68Ev();
extern void _ZN6S704C53v69Ev();
extern void _ZN6S704C53v70Ev();
extern void _ZN6S704C53v71Ev();
extern void _ZN6S704C43v72Ev();
extern void _ZN6S704C43v73Ev();
extern void _ZN6S704C43v74Ev();
extern void _ZN6S704C43v75Ev();
extern void _ZN6S704C43v76Ev();
static  VTBL_ENTRY vtc_S704C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S704C4[0]),
  (VTBL_ENTRY)&_ZN6S704C4D1Ev,
  (VTBL_ENTRY)&_ZN6S704C4D0Ev,
  (VTBL_ENTRY)&_ZN6S704C52v8Ev,
  (VTBL_ENTRY)&_ZN6S704C52v9Ev,
  (VTBL_ENTRY)&_ZN6S704C53v10Ev,
  (VTBL_ENTRY)&_ZN6S704C53v11Ev,
  (VTBL_ENTRY)&_ZN6S704C53v12Ev,
  (VTBL_ENTRY)&_ZN6S704C53v13Ev,
  (VTBL_ENTRY)&_ZN6S704C53v14Ev,
  (VTBL_ENTRY)&_ZN6S704C53v15Ev,
  (VTBL_ENTRY)&_ZN6S704C53v16Ev,
  (VTBL_ENTRY)&_ZN6S704C53v17Ev,
  (VTBL_ENTRY)&_ZN6S704C53v18Ev,
  (VTBL_ENTRY)&_ZN6S704C53v19Ev,
  (VTBL_ENTRY)&_ZN6S704C53v20Ev,
  (VTBL_ENTRY)&_ZN6S704C53v21Ev,
  (VTBL_ENTRY)&_ZN6S704C53v22Ev,
  (VTBL_ENTRY)&_ZN6S704C53v23Ev,
  (VTBL_ENTRY)&_ZN6S704C53v24Ev,
  (VTBL_ENTRY)&_ZN6S704C53v25Ev,
  (VTBL_ENTRY)&_ZN6S704C53v26Ev,
  (VTBL_ENTRY)&_ZN6S704C53v27Ev,
  (VTBL_ENTRY)&_ZN6S704C53v28Ev,
  (VTBL_ENTRY)&_ZN6S704C53v29Ev,
  (VTBL_ENTRY)&_ZN6S704C53v30Ev,
  (VTBL_ENTRY)&_ZN6S704C53v31Ev,
  (VTBL_ENTRY)&_ZN6S704C53v32Ev,
  (VTBL_ENTRY)&_ZN6S704C53v33Ev,
  (VTBL_ENTRY)&_ZN6S704C53v34Ev,
  (VTBL_ENTRY)&_ZN6S704C53v35Ev,
  (VTBL_ENTRY)&_ZN6S704C53v36Ev,
  (VTBL_ENTRY)&_ZN6S704C53v37Ev,
  (VTBL_ENTRY)&_ZN6S704C53v38Ev,
  (VTBL_ENTRY)&_ZN6S704C53v39Ev,
  (VTBL_ENTRY)&_ZN6S704C53v40Ev,
  (VTBL_ENTRY)&_ZN6S704C53v41Ev,
  (VTBL_ENTRY)&_ZN6S704C53v42Ev,
  (VTBL_ENTRY)&_ZN6S704C53v43Ev,
  (VTBL_ENTRY)&_ZN6S704C53v44Ev,
  (VTBL_ENTRY)&_ZN6S704C53v45Ev,
  (VTBL_ENTRY)&_ZN6S704C53v46Ev,
  (VTBL_ENTRY)&_ZN6S704C53v47Ev,
  (VTBL_ENTRY)&_ZN6S704C53v48Ev,
  (VTBL_ENTRY)&_ZN6S704C53v49Ev,
  (VTBL_ENTRY)&_ZN6S704C53v50Ev,
  (VTBL_ENTRY)&_ZN6S704C53v51Ev,
  (VTBL_ENTRY)&_ZN6S704C53v52Ev,
  (VTBL_ENTRY)&_ZN6S704C53v53Ev,
  (VTBL_ENTRY)&_ZN6S704C53v54Ev,
  (VTBL_ENTRY)&_ZN6S704C53v55Ev,
  (VTBL_ENTRY)&_ZN6S704C53v56Ev,
  (VTBL_ENTRY)&_ZN6S704C53v57Ev,
  (VTBL_ENTRY)&_ZN6S704C53v58Ev,
  (VTBL_ENTRY)&_ZN6S704C53v59Ev,
  (VTBL_ENTRY)&_ZN6S704C53v60Ev,
  (VTBL_ENTRY)&_ZN6S704C53v61Ev,
  (VTBL_ENTRY)&_ZN6S704C53v62Ev,
  (VTBL_ENTRY)&_ZN6S704C53v63Ev,
  (VTBL_ENTRY)&_ZN6S704C53v64Ev,
  (VTBL_ENTRY)&_ZN6S704C53v65Ev,
  (VTBL_ENTRY)&_ZN6S704C53v66Ev,
  (VTBL_ENTRY)&_ZN6S704C53v67Ev,
  (VTBL_ENTRY)&_ZN6S704C53v68Ev,
  (VTBL_ENTRY)&_ZN6S704C53v69Ev,
  (VTBL_ENTRY)&_ZN6S704C53v70Ev,
  (VTBL_ENTRY)&_ZN6S704C53v71Ev,
  (VTBL_ENTRY)&_ZN6S704C43v72Ev,
  (VTBL_ENTRY)&_ZN6S704C43v73Ev,
  (VTBL_ENTRY)&_ZN6S704C43v74Ev,
  (VTBL_ENTRY)&_ZN6S704C43v75Ev,
  (VTBL_ENTRY)&_ZN6S704C43v76Ev,
};
extern VTBL_ENTRY _ZTI6S704C4[];
extern  VTBL_ENTRY _ZTV6S704C4[];
Class_Descriptor cd_S704C4 = {  "S704C4", // class name
  bases_S704C4, 1,
  &(vtc_S704C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,72), // object size
  NSPAIRA(_ZTI6S704C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S704C4),73, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S704C3  : S704C4 {
  void *s704c3f0[2];
  unsigned int s704c3f1:1;
  unsigned int s704c3f2:1;
  unsigned int s704c3f3:1;
  unsigned int s704c3f4:1;
  char s704c3f5;
  virtual  ~S704C3(); // _ZN6S704C3D1Ev
  virtual void  v77(); // _ZN6S704C33v77Ev
  virtual void  v78(); // _ZN6S704C33v78Ev
  virtual void  v79(); // _ZN6S704C33v79Ev
  virtual void  v80(); // _ZN6S704C33v80Ev
  virtual void  v81(); // _ZN6S704C33v81Ev
  virtual void  v82(); // _ZN6S704C33v82Ev
  virtual void  v83(); // _ZN6S704C33v83Ev
  virtual void  v84(); // _ZN6S704C33v84Ev
  virtual void  v85(); // _ZN6S704C33v85Ev
  virtual void  v86(); // _ZN6S704C33v86Ev
  virtual void  v87(); // _ZN6S704C33v87Ev
  virtual void  v88(); // _ZN6S704C33v88Ev
  virtual void  v89(); // _ZN6S704C33v89Ev
  virtual void  v90(); // _ZN6S704C33v90Ev
  virtual void  v91(); // _ZN6S704C33v91Ev
  virtual void  v92(); // _ZN6S704C33v92Ev
  virtual void  v93(); // _ZN6S704C33v93Ev
  virtual void  v94(); // _ZN6S704C33v94Ev
  virtual void  v95(); // _ZN6S704C33v95Ev
  virtual void  v96(); // _ZN6S704C33v96Ev
  virtual void  v97(); // _ZN6S704C33v97Ev
  virtual void  v98(); // _ZN6S704C33v98Ev
  S704C3(); // tgen
};
//SIG(-1 S704C3) C1{ BC2{ BC3{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v87 v88 v89 v90 v91 Fp FC4} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc}


 S704C3 ::~S704C3(){ note_dtor("S704C3", this);}
void  S704C3 ::v77(){vfunc_called(this, "_ZN6S704C33v77Ev");}
void  S704C3 ::v78(){vfunc_called(this, "_ZN6S704C33v78Ev");}
void  S704C3 ::v79(){vfunc_called(this, "_ZN6S704C33v79Ev");}
void  S704C3 ::v80(){vfunc_called(this, "_ZN6S704C33v80Ev");}
void  S704C3 ::v81(){vfunc_called(this, "_ZN6S704C33v81Ev");}
void  S704C3 ::v82(){vfunc_called(this, "_ZN6S704C33v82Ev");}
void  S704C3 ::v83(){vfunc_called(this, "_ZN6S704C33v83Ev");}
void  S704C3 ::v84(){vfunc_called(this, "_ZN6S704C33v84Ev");}
void  S704C3 ::v85(){vfunc_called(this, "_ZN6S704C33v85Ev");}
void  S704C3 ::v86(){vfunc_called(this, "_ZN6S704C33v86Ev");}
void  S704C3 ::v87(){vfunc_called(this, "_ZN6S704C33v87Ev");}
void  S704C3 ::v88(){vfunc_called(this, "_ZN6S704C33v88Ev");}
void  S704C3 ::v89(){vfunc_called(this, "_ZN6S704C33v89Ev");}
void  S704C3 ::v90(){vfunc_called(this, "_ZN6S704C33v90Ev");}
void  S704C3 ::v91(){vfunc_called(this, "_ZN6S704C33v91Ev");}
void  S704C3 ::v92(){vfunc_called(this, "_ZN6S704C33v92Ev");}
void  S704C3 ::v93(){vfunc_called(this, "_ZN6S704C33v93Ev");}
void  S704C3 ::v94(){vfunc_called(this, "_ZN6S704C33v94Ev");}
void  S704C3 ::v95(){vfunc_called(this, "_ZN6S704C33v95Ev");}
void  S704C3 ::v96(){vfunc_called(this, "_ZN6S704C33v96Ev");}
void  S704C3 ::v97(){vfunc_called(this, "_ZN6S704C33v97Ev");}
void  S704C3 ::v98(){vfunc_called(this, "_ZN6S704C33v98Ev");}
S704C3 ::S704C3(){ note_ctor("S704C3", this);} // tgen

static void Test_S704C3()
{
  extern Class_Descriptor cd_S704C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,22)];
    init_test(&cd_S704C3, buf);
    S704C3 *dp, &lv = *(dp=new (buf) S704C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,84), "sizeof(S704C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S704C3)");
    check_base_class_offset(lv, (S704C5*)(S704C4*), 0, "S704C3");
    check_base_class_offset(lv, (S704C4*), 0, "S704C3");
    check_field_offset(lv, s704c3f0, ABISELECT(112,72), "S704C3.s704c3f0");
    set_bf_and_test(lv, s704c3f1, ABISELECT(128,80), 0, 1, 1, "S704C3");
    set_bf_and_test(lv, s704c3f2, ABISELECT(128,80), 1, 1, 1, "S704C3");
    set_bf_and_test(lv, s704c3f3, ABISELECT(128,80), 2, 1, 1, "S704C3");
    set_bf_and_test(lv, s704c3f4, ABISELECT(128,80), 3, 1, 1, "S704C3");
    check_field_offset(lv, s704c3f5, ABISELECT(129,81), "S704C3.s704c3f5");
    test_class_info(&lv, &cd_S704C3);
    dp->~S704C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS704C3(Test_S704C3, "S704C3", ABISELECT(136,84));

#else // __cplusplus

extern void _ZN6S704C3C1Ev();
extern void _ZN6S704C3D1Ev();
Name_Map name_map_S704C3[] = {
  NSPAIR(_ZN6S704C3C1Ev),
  NSPAIR(_ZN6S704C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S704C5;
extern VTBL_ENTRY _ZTI6S704C5[];
extern  VTBL_ENTRY _ZTV6S704C5[];
extern Class_Descriptor cd_S704C4;
extern VTBL_ENTRY _ZTI6S704C4[];
extern  VTBL_ENTRY _ZTV6S704C4[];
static Base_Class bases_S704C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S704C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S704C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S704C3[];
extern void _ZN6S704C3D1Ev();
extern void _ZN6S704C3D0Ev();
extern void _ZN6S704C52v8Ev();
extern void _ZN6S704C52v9Ev();
extern void _ZN6S704C53v10Ev();
extern void _ZN6S704C53v11Ev();
extern void _ZN6S704C53v12Ev();
extern void _ZN6S704C53v13Ev();
extern void _ZN6S704C53v14Ev();
extern void _ZN6S704C53v15Ev();
extern void _ZN6S704C53v16Ev();
extern void _ZN6S704C53v17Ev();
extern void _ZN6S704C53v18Ev();
extern void _ZN6S704C53v19Ev();
extern void _ZN6S704C53v20Ev();
extern void _ZN6S704C53v21Ev();
extern void _ZN6S704C53v22Ev();
extern void _ZN6S704C53v23Ev();
extern void _ZN6S704C53v24Ev();
extern void _ZN6S704C53v25Ev();
extern void _ZN6S704C53v26Ev();
extern void _ZN6S704C53v27Ev();
extern void _ZN6S704C53v28Ev();
extern void _ZN6S704C53v29Ev();
extern void _ZN6S704C53v30Ev();
extern void _ZN6S704C53v31Ev();
extern void _ZN6S704C53v32Ev();
extern void _ZN6S704C53v33Ev();
extern void _ZN6S704C53v34Ev();
extern void _ZN6S704C53v35Ev();
extern void _ZN6S704C53v36Ev();
extern void _ZN6S704C53v37Ev();
extern void _ZN6S704C53v38Ev();
extern void _ZN6S704C53v39Ev();
extern void _ZN6S704C53v40Ev();
extern void _ZN6S704C53v41Ev();
extern void _ZN6S704C53v42Ev();
extern void _ZN6S704C53v43Ev();
extern void _ZN6S704C53v44Ev();
extern void _ZN6S704C53v45Ev();
extern void _ZN6S704C53v46Ev();
extern void _ZN6S704C53v47Ev();
extern void _ZN6S704C53v48Ev();
extern void _ZN6S704C53v49Ev();
extern void _ZN6S704C53v50Ev();
extern void _ZN6S704C53v51Ev();
extern void _ZN6S704C53v52Ev();
extern void _ZN6S704C53v53Ev();
extern void _ZN6S704C53v54Ev();
extern void _ZN6S704C53v55Ev();
extern void _ZN6S704C53v56Ev();
extern void _ZN6S704C53v57Ev();
extern void _ZN6S704C53v58Ev();
extern void _ZN6S704C53v59Ev();
extern void _ZN6S704C53v60Ev();
extern void _ZN6S704C53v61Ev();
extern void _ZN6S704C53v62Ev();
extern void _ZN6S704C53v63Ev();
extern void _ZN6S704C53v64Ev();
extern void _ZN6S704C53v65Ev();
extern void _ZN6S704C53v66Ev();
extern void _ZN6S704C53v67Ev();
extern void _ZN6S704C53v68Ev();
extern void _ZN6S704C53v69Ev();
extern void _ZN6S704C53v70Ev();
extern void _ZN6S704C53v71Ev();
extern void _ZN6S704C43v72Ev();
extern void _ZN6S704C43v73Ev();
extern void _ZN6S704C43v74Ev();
extern void _ZN6S704C43v75Ev();
extern void _ZN6S704C43v76Ev();
extern void _ZN6S704C33v77Ev();
extern void _ZN6S704C33v78Ev();
extern void _ZN6S704C33v79Ev();
extern void _ZN6S704C33v80Ev();
extern void _ZN6S704C33v81Ev();
extern void _ZN6S704C33v82Ev();
extern void _ZN6S704C33v83Ev();
extern void _ZN6S704C33v84Ev();
extern void _ZN6S704C33v85Ev();
extern void _ZN6S704C33v86Ev();
extern void _ZN6S704C33v87Ev();
extern void _ZN6S704C33v88Ev();
extern void _ZN6S704C33v89Ev();
extern void _ZN6S704C33v90Ev();
extern void _ZN6S704C33v91Ev();
extern void _ZN6S704C33v92Ev();
extern void _ZN6S704C33v93Ev();
extern void _ZN6S704C33v94Ev();
extern void _ZN6S704C33v95Ev();
extern void _ZN6S704C33v96Ev();
extern void _ZN6S704C33v97Ev();
extern void _ZN6S704C33v98Ev();
static  VTBL_ENTRY vtc_S704C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S704C3[0]),
  (VTBL_ENTRY)&_ZN6S704C3D1Ev,
  (VTBL_ENTRY)&_ZN6S704C3D0Ev,
  (VTBL_ENTRY)&_ZN6S704C52v8Ev,
  (VTBL_ENTRY)&_ZN6S704C52v9Ev,
  (VTBL_ENTRY)&_ZN6S704C53v10Ev,
  (VTBL_ENTRY)&_ZN6S704C53v11Ev,
  (VTBL_ENTRY)&_ZN6S704C53v12Ev,
  (VTBL_ENTRY)&_ZN6S704C53v13Ev,
  (VTBL_ENTRY)&_ZN6S704C53v14Ev,
  (VTBL_ENTRY)&_ZN6S704C53v15Ev,
  (VTBL_ENTRY)&_ZN6S704C53v16Ev,
  (VTBL_ENTRY)&_ZN6S704C53v17Ev,
  (VTBL_ENTRY)&_ZN6S704C53v18Ev,
  (VTBL_ENTRY)&_ZN6S704C53v19Ev,
  (VTBL_ENTRY)&_ZN6S704C53v20Ev,
  (VTBL_ENTRY)&_ZN6S704C53v21Ev,
  (VTBL_ENTRY)&_ZN6S704C53v22Ev,
  (VTBL_ENTRY)&_ZN6S704C53v23Ev,
  (VTBL_ENTRY)&_ZN6S704C53v24Ev,
  (VTBL_ENTRY)&_ZN6S704C53v25Ev,
  (VTBL_ENTRY)&_ZN6S704C53v26Ev,
  (VTBL_ENTRY)&_ZN6S704C53v27Ev,
  (VTBL_ENTRY)&_ZN6S704C53v28Ev,
  (VTBL_ENTRY)&_ZN6S704C53v29Ev,
  (VTBL_ENTRY)&_ZN6S704C53v30Ev,
  (VTBL_ENTRY)&_ZN6S704C53v31Ev,
  (VTBL_ENTRY)&_ZN6S704C53v32Ev,
  (VTBL_ENTRY)&_ZN6S704C53v33Ev,
  (VTBL_ENTRY)&_ZN6S704C53v34Ev,
  (VTBL_ENTRY)&_ZN6S704C53v35Ev,
  (VTBL_ENTRY)&_ZN6S704C53v36Ev,
  (VTBL_ENTRY)&_ZN6S704C53v37Ev,
  (VTBL_ENTRY)&_ZN6S704C53v38Ev,
  (VTBL_ENTRY)&_ZN6S704C53v39Ev,
  (VTBL_ENTRY)&_ZN6S704C53v40Ev,
  (VTBL_ENTRY)&_ZN6S704C53v41Ev,
  (VTBL_ENTRY)&_ZN6S704C53v42Ev,
  (VTBL_ENTRY)&_ZN6S704C53v43Ev,
  (VTBL_ENTRY)&_ZN6S704C53v44Ev,
  (VTBL_ENTRY)&_ZN6S704C53v45Ev,
  (VTBL_ENTRY)&_ZN6S704C53v46Ev,
  (VTBL_ENTRY)&_ZN6S704C53v47Ev,
  (VTBL_ENTRY)&_ZN6S704C53v48Ev,
  (VTBL_ENTRY)&_ZN6S704C53v49Ev,
  (VTBL_ENTRY)&_ZN6S704C53v50Ev,
  (VTBL_ENTRY)&_ZN6S704C53v51Ev,
  (VTBL_ENTRY)&_ZN6S704C53v52Ev,
  (VTBL_ENTRY)&_ZN6S704C53v53Ev,
  (VTBL_ENTRY)&_ZN6S704C53v54Ev,
  (VTBL_ENTRY)&_ZN6S704C53v55Ev,
  (VTBL_ENTRY)&_ZN6S704C53v56Ev,
  (VTBL_ENTRY)&_ZN6S704C53v57Ev,
  (VTBL_ENTRY)&_ZN6S704C53v58Ev,
  (VTBL_ENTRY)&_ZN6S704C53v59Ev,
  (VTBL_ENTRY)&_ZN6S704C53v60Ev,
  (VTBL_ENTRY)&_ZN6S704C53v61Ev,
  (VTBL_ENTRY)&_ZN6S704C53v62Ev,
  (VTBL_ENTRY)&_ZN6S704C53v63Ev,
  (VTBL_ENTRY)&_ZN6S704C53v64Ev,
  (VTBL_ENTRY)&_ZN6S704C53v65Ev,
  (VTBL_ENTRY)&_ZN6S704C53v66Ev,
  (VTBL_ENTRY)&_ZN6S704C53v67Ev,
  (VTBL_ENTRY)&_ZN6S704C53v68Ev,
  (VTBL_ENTRY)&_ZN6S704C53v69Ev,
  (VTBL_ENTRY)&_ZN6S704C53v70Ev,
  (VTBL_ENTRY)&_ZN6S704C53v71Ev,
  (VTBL_ENTRY)&_ZN6S704C43v72Ev,
  (VTBL_ENTRY)&_ZN6S704C43v73Ev,
  (VTBL_ENTRY)&_ZN6S704C43v74Ev,
  (VTBL_ENTRY)&_ZN6S704C43v75Ev,
  (VTBL_ENTRY)&_ZN6S704C43v76Ev,
  (VTBL_ENTRY)&_ZN6S704C33v77Ev,
  (VTBL_ENTRY)&_ZN6S704C33v78Ev,
  (VTBL_ENTRY)&_ZN6S704C33v79Ev,
  (VTBL_ENTRY)&_ZN6S704C33v80Ev,
  (VTBL_ENTRY)&_ZN6S704C33v81Ev,
  (VTBL_ENTRY)&_ZN6S704C33v82Ev,
  (VTBL_ENTRY)&_ZN6S704C33v83Ev,
  (VTBL_ENTRY)&_ZN6S704C33v84Ev,
  (VTBL_ENTRY)&_ZN6S704C33v85Ev,
  (VTBL_ENTRY)&_ZN6S704C33v86Ev,
  (VTBL_ENTRY)&_ZN6S704C33v87Ev,
  (VTBL_ENTRY)&_ZN6S704C33v88Ev,
  (VTBL_ENTRY)&_ZN6S704C33v89Ev,
  (VTBL_ENTRY)&_ZN6S704C33v90Ev,
  (VTBL_ENTRY)&_ZN6S704C33v91Ev,
  (VTBL_ENTRY)&_ZN6S704C33v92Ev,
  (VTBL_ENTRY)&_ZN6S704C33v93Ev,
  (VTBL_ENTRY)&_ZN6S704C33v94Ev,
  (VTBL_ENTRY)&_ZN6S704C33v95Ev,
  (VTBL_ENTRY)&_ZN6S704C33v96Ev,
  (VTBL_ENTRY)&_ZN6S704C33v97Ev,
  (VTBL_ENTRY)&_ZN6S704C33v98Ev,
};
extern VTBL_ENTRY _ZTI6S704C3[];
extern  VTBL_ENTRY _ZTV6S704C3[];
Class_Descriptor cd_S704C3 = {  "S704C3", // class name
  bases_S704C3, 2,
  &(vtc_S704C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,84), // object size
  NSPAIRA(_ZTI6S704C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S704C3),95, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S704C2  : S704C3 {
  void *s704c2f0;
  ::S836C39 s704c2f1;
  ::S836C39 s704c2f2;
  ::S285C19 s704c2f3;
  ::S285C19 s704c2f4;
  int s704c2f5;
  ::S836C29 s704c2f6;
  void *s704c2f7;
  unsigned int s704c2f8:1;
  unsigned int s704c2f9:1;
  unsigned int s704c2f10:1;
  unsigned int s704c2f11:1;
  unsigned int s704c2f12:1;
  unsigned int s704c2f13:1;
  unsigned int s704c2f14:1;
  unsigned int s704c2f15:1;
  unsigned int s704c2f16:1;
  unsigned int s704c2f17:1;
  unsigned int s704c2f18:1;
  void *s704c2f19;
  ::S285C17 s704c2f20;
  ::S836C25 s704c2f21;
  unsigned int s704c2f22:1;
  ::S235C17 s704c2f23;
  ::S235C17 s704c2f24;
  ::S235C11_nt s704c2f25;
  ::S235C11_nt s704c2f26;
  char s704c2f27[2];
  ::S235C9_nt s704c2f28;
  int s704c2f29[3];
  char s704c2f30[2];
  int s704c2f31[2];
  virtual  ~S704C2(); // _ZN6S704C2D1Ev
  virtual void  v99(); // _ZN6S704C23v99Ev
  virtual void  v100(); // _ZN6S704C24v100Ev
  virtual void  v101(); // _ZN6S704C24v101Ev
  virtual void  v102(); // _ZN6S704C24v102Ev
  virtual void  v103(); // _ZN6S704C24v103Ev
  virtual void  v104(); // _ZN6S704C24v104Ev
  virtual void  v105(); // _ZN6S704C24v105Ev
  virtual void  v106(); // _ZN6S704C24v106Ev
  virtual void  v107(); // _ZN6S704C24v107Ev
  virtual void  v108(); // _ZN6S704C24v108Ev
  virtual void  v109(); // _ZN6S704C24v109Ev
  virtual void  v110(); // _ZN6S704C24v110Ev
  virtual void  v111(); // _ZN6S704C24v111Ev
  virtual void  v112(); // _ZN6S704C24v112Ev
  virtual void  v113(); // _ZN6S704C24v113Ev
  virtual void  v114(); // _ZN6S704C24v114Ev
  virtual void  v115(); // _ZN6S704C24v115Ev
  virtual void  v116(); // _ZN6S704C24v116Ev
  virtual void  v117(); // _ZN6S704C24v117Ev
  virtual void  v118(); // _ZN6S704C24v118Ev
  virtual void  v119(); // _ZN6S704C24v119Ev
  virtual void  v120(); // _ZN6S704C24v120Ev
  virtual void  v121(); // _ZN6S704C24v121Ev
  virtual void  v122(); // _ZN6S704C24v122Ev
  virtual void  v123(); // _ZN6S704C24v123Ev
  virtual void  v124(); // _ZN6S704C24v124Ev
  virtual void  v125(); // _ZN6S704C24v125Ev
  S704C2(); // tgen
};
//SIG(-1 S704C2) C1{ BC2{ BC3{ BC4{ vd v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v92 v93 v94 v95 v96 Fp FC5} vd v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 Fp FC6{ m} FC6 FC7{ m Fi[4]} FC7 Fi FC8{ m} Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp FC9{ BC10{ BC11{ m Fp Fi[2]}}} FC12{ m} Fi:1 FC13{ BC14{ BC11}} FC13 FC15{ BC16{ BC11}} FC15 Fc[2] FC17{ m Fi[4]} Fi[3] Fc[2] Fi[2]}


 S704C2 ::~S704C2(){ note_dtor("S704C2", this);}
void  S704C2 ::v99(){vfunc_called(this, "_ZN6S704C23v99Ev");}
void  S704C2 ::v100(){vfunc_called(this, "_ZN6S704C24v100Ev");}
void  S704C2 ::v101(){vfunc_called(this, "_ZN6S704C24v101Ev");}
void  S704C2 ::v102(){vfunc_called(this, "_ZN6S704C24v102Ev");}
void  S704C2 ::v103(){vfunc_called(this, "_ZN6S704C24v103Ev");}
void  S704C2 ::v104(){vfunc_called(this, "_ZN6S704C24v104Ev");}
void  S704C2 ::v105(){vfunc_called(this, "_ZN6S704C24v105Ev");}
void  S704C2 ::v106(){vfunc_called(this, "_ZN6S704C24v106Ev");}
void  S704C2 ::v107(){vfunc_called(this, "_ZN6S704C24v107Ev");}
void  S704C2 ::v108(){vfunc_called(this, "_ZN6S704C24v108Ev");}
void  S704C2 ::v109(){vfunc_called(this, "_ZN6S704C24v109Ev");}
void  S704C2 ::v110(){vfunc_called(this, "_ZN6S704C24v110Ev");}
void  S704C2 ::v111(){vfunc_called(this, "_ZN6S704C24v111Ev");}
void  S704C2 ::v112(){vfunc_called(this, "_ZN6S704C24v112Ev");}
void  S704C2 ::v113(){vfunc_called(this, "_ZN6S704C24v113Ev");}
void  S704C2 ::v114(){vfunc_called(this, "_ZN6S704C24v114Ev");}
void  S704C2 ::v115(){vfunc_called(this, "_ZN6S704C24v115Ev");}
void  S704C2 ::v116(){vfunc_called(this, "_ZN6S704C24v116Ev");}
void  S704C2 ::v117(){vfunc_called(this, "_ZN6S704C24v117Ev");}
void  S704C2 ::v118(){vfunc_called(this, "_ZN6S704C24v118Ev");}
void  S704C2 ::v119(){vfunc_called(this, "_ZN6S704C24v119Ev");}
void  S704C2 ::v120(){vfunc_called(this, "_ZN6S704C24v120Ev");}
void  S704C2 ::v121(){vfunc_called(this, "_ZN6S704C24v121Ev");}
void  S704C2 ::v122(){vfunc_called(this, "_ZN6S704C24v122Ev");}
void  S704C2 ::v123(){vfunc_called(this, "_ZN6S704C24v123Ev");}
void  S704C2 ::v124(){vfunc_called(this, "_ZN6S704C24v124Ev");}
void  S704C2 ::v125(){vfunc_called(this, "_ZN6S704C24v125Ev");}
S704C2 ::S704C2(){ note_ctor("S704C2", this);} // tgen

static void Test_S704C2()
{
  extern Class_Descriptor cd_S704C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(45,64)];
    init_test(&cd_S704C2, buf);
    S704C2 *dp, &lv = *(dp=new (buf) S704C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(352,252), "sizeof(S704C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S704C2)");
    check_base_class_offset(lv, (S704C5*)(S704C4*)(S704C3*), 0, "S704C2");
    check_base_class_offset(lv, (S704C4*)(S704C3*), 0, "S704C2");
    check_base_class_offset(lv, (S704C3*), 0, "S704C2");
    check_field_offset(lv, s704c2f0, ABISELECT(136,84), "S704C2.s704c2f0");
    check_field_offset(lv, s704c2f1, ABISELECT(144,88), "S704C2.s704c2f1");
    check_field_offset(lv, s704c2f2, ABISELECT(145,89), "S704C2.s704c2f2");
    check_field_offset(lv, s704c2f3, ABISELECT(148,92), "S704C2.s704c2f3");
    check_field_offset(lv, s704c2f4, ABISELECT(164,108), "S704C2.s704c2f4");
    check_field_offset(lv, s704c2f5, ABISELECT(180,124), "S704C2.s704c2f5");
    check_field_offset(lv, s704c2f6, ABISELECT(184,128), "S704C2.s704c2f6");
    check_field_offset(lv, s704c2f7, ABISELECT(192,132), "S704C2.s704c2f7");
    set_bf_and_test(lv, s704c2f8, ABISELECT(200,136), 0, 1, 1, "S704C2");
    set_bf_and_test(lv, s704c2f9, ABISELECT(200,136), 1, 1, 1, "S704C2");
    set_bf_and_test(lv, s704c2f10, ABISELECT(200,136), 2, 1, 1, "S704C2");
    set_bf_and_test(lv, s704c2f11, ABISELECT(200,136), 3, 1, 1, "S704C2");
    set_bf_and_test(lv, s704c2f12, ABISELECT(200,136), 4, 1, 1, "S704C2");
    set_bf_and_test(lv, s704c2f13, ABISELECT(200,136), 5, 1, 1, "S704C2");
    set_bf_and_test(lv, s704c2f14, ABISELECT(200,136), 6, 1, 1, "S704C2");
    set_bf_and_test(lv, s704c2f15, ABISELECT(200,136), 7, 1, 1, "S704C2");
    set_bf_and_test(lv, s704c2f16, ABISELECT(201,137), 0, 1, 1, "S704C2");
    set_bf_and_test(lv, s704c2f17, ABISELECT(201,137), 1, 1, 1, "S704C2");
    set_bf_and_test(lv, s704c2f18, ABISELECT(201,137), 2, 1, 1, "S704C2");
    check_field_offset(lv, s704c2f19, ABISELECT(208,140), "S704C2.s704c2f19");
    check_field_offset(lv, s704c2f20, ABISELECT(216,144), "S704C2.s704c2f20");
    check_field_offset(lv, s704c2f21, ABISELECT(232,156), "S704C2.s704c2f21");
    set_bf_and_test(lv, s704c2f22, ABISELECT(233,157), 0, 1, 1, "S704C2");
    check_field_offset(lv, s704c2f23, ABISELECT(240,160), "S704C2.s704c2f23");
    check_field_offset(lv, s704c2f24, ABISELECT(256,172), "S704C2.s704c2f24");
    check_field_offset(lv, s704c2f25, ABISELECT(272,184), "S704C2.s704c2f25");
    check_field_offset(lv, s704c2f26, ABISELECT(288,196), "S704C2.s704c2f26");
    check_field_offset(lv, s704c2f27, ABISELECT(304,208), "S704C2.s704c2f27");
    check_field_offset(lv, s704c2f28, ABISELECT(308,212), "S704C2.s704c2f28");
    check_field_offset(lv, s704c2f29, ABISELECT(324,228), "S704C2.s704c2f29");
    check_field_offset(lv, s704c2f30, ABISELECT(336,240), "S704C2.s704c2f30");
    check_field_offset(lv, s704c2f31, ABISELECT(340,244), "S704C2.s704c2f31");
    test_class_info(&lv, &cd_S704C2);
    dp->~S704C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS704C2(Test_S704C2, "S704C2", ABISELECT(352,252));

#else // __cplusplus

extern void _ZN6S704C2C1Ev();
extern void _ZN6S704C2D1Ev();
Name_Map name_map_S704C2[] = {
  NSPAIR(_ZN6S704C2C1Ev),
  NSPAIR(_ZN6S704C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S704C5;
extern VTBL_ENTRY _ZTI6S704C5[];
extern  VTBL_ENTRY _ZTV6S704C5[];
extern Class_Descriptor cd_S704C4;
extern VTBL_ENTRY _ZTI6S704C4[];
extern  VTBL_ENTRY _ZTV6S704C4[];
extern Class_Descriptor cd_S704C3;
extern VTBL_ENTRY _ZTI6S704C3[];
extern  VTBL_ENTRY _ZTV6S704C3[];
static Base_Class bases_S704C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S704C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S704C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S704C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S704C2[];
extern void _ZN6S704C2D1Ev();
extern void _ZN6S704C2D0Ev();
extern void _ZN6S704C52v8Ev();
extern void _ZN6S704C52v9Ev();
extern void _ZN6S704C53v10Ev();
extern void _ZN6S704C53v11Ev();
extern void _ZN6S704C53v12Ev();
extern void _ZN6S704C53v13Ev();
extern void _ZN6S704C53v14Ev();
extern void _ZN6S704C53v15Ev();
extern void _ZN6S704C53v16Ev();
extern void _ZN6S704C53v17Ev();
extern void _ZN6S704C53v18Ev();
extern void _ZN6S704C53v19Ev();
extern void _ZN6S704C53v20Ev();
extern void _ZN6S704C53v21Ev();
extern void _ZN6S704C53v22Ev();
extern void _ZN6S704C53v23Ev();
extern void _ZN6S704C53v24Ev();
extern void _ZN6S704C53v25Ev();
extern void _ZN6S704C53v26Ev();
extern void _ZN6S704C53v27Ev();
extern void _ZN6S704C53v28Ev();
extern void _ZN6S704C53v29Ev();
extern void _ZN6S704C53v30Ev();
extern void _ZN6S704C53v31Ev();
extern void _ZN6S704C53v32Ev();
extern void _ZN6S704C53v33Ev();
extern void _ZN6S704C53v34Ev();
extern void _ZN6S704C53v35Ev();
extern void _ZN6S704C53v36Ev();
extern void _ZN6S704C53v37Ev();
extern void _ZN6S704C53v38Ev();
extern void _ZN6S704C53v39Ev();
extern void _ZN6S704C53v40Ev();
extern void _ZN6S704C53v41Ev();
extern void _ZN6S704C53v42Ev();
extern void _ZN6S704C53v43Ev();
extern void _ZN6S704C53v44Ev();
extern void _ZN6S704C53v45Ev();
extern void _ZN6S704C53v46Ev();
extern void _ZN6S704C53v47Ev();
extern void _ZN6S704C53v48Ev();
extern void _ZN6S704C53v49Ev();
extern void _ZN6S704C53v50Ev();
extern void _ZN6S704C53v51Ev();
extern void _ZN6S704C53v52Ev();
extern void _ZN6S704C53v53Ev();
extern void _ZN6S704C53v54Ev();
extern void _ZN6S704C53v55Ev();
extern void _ZN6S704C53v56Ev();
extern void _ZN6S704C53v57Ev();
extern void _ZN6S704C53v58Ev();
extern void _ZN6S704C53v59Ev();
extern void _ZN6S704C53v60Ev();
extern void _ZN6S704C53v61Ev();
extern void _ZN6S704C53v62Ev();
extern void _ZN6S704C53v63Ev();
extern void _ZN6S704C53v64Ev();
extern void _ZN6S704C53v65Ev();
extern void _ZN6S704C53v66Ev();
extern void _ZN6S704C53v67Ev();
extern void _ZN6S704C53v68Ev();
extern void _ZN6S704C53v69Ev();
extern void _ZN6S704C53v70Ev();
extern void _ZN6S704C53v71Ev();
extern void _ZN6S704C43v72Ev();
extern void _ZN6S704C43v73Ev();
extern void _ZN6S704C43v74Ev();
extern void _ZN6S704C43v75Ev();
extern void _ZN6S704C43v76Ev();
extern void _ZN6S704C33v77Ev();
extern void _ZN6S704C33v78Ev();
extern void _ZN6S704C33v79Ev();
extern void _ZN6S704C33v80Ev();
extern void _ZN6S704C33v81Ev();
extern void _ZN6S704C33v82Ev();
extern void _ZN6S704C33v83Ev();
extern void _ZN6S704C33v84Ev();
extern void _ZN6S704C33v85Ev();
extern void _ZN6S704C33v86Ev();
extern void _ZN6S704C33v87Ev();
extern void _ZN6S704C33v88Ev();
extern void _ZN6S704C33v89Ev();
extern void _ZN6S704C33v90Ev();
extern void _ZN6S704C33v91Ev();
extern void _ZN6S704C33v92Ev();
extern void _ZN6S704C33v93Ev();
extern void _ZN6S704C33v94Ev();
extern void _ZN6S704C33v95Ev();
extern void _ZN6S704C33v96Ev();
extern void _ZN6S704C33v97Ev();
extern void _ZN6S704C33v98Ev();
extern void _ZN6S704C23v99Ev();
extern void _ZN6S704C24v100Ev();
extern void _ZN6S704C24v101Ev();
extern void _ZN6S704C24v102Ev();
extern void _ZN6S704C24v103Ev();
extern void _ZN6S704C24v104Ev();
extern void _ZN6S704C24v105Ev();
extern void _ZN6S704C24v106Ev();
extern void _ZN6S704C24v107Ev();
extern void _ZN6S704C24v108Ev();
extern void _ZN6S704C24v109Ev();
extern void _ZN6S704C24v110Ev();
extern void _ZN6S704C24v111Ev();
extern void _ZN6S704C24v112Ev();
extern void _ZN6S704C24v113Ev();
extern void _ZN6S704C24v114Ev();
extern void _ZN6S704C24v115Ev();
extern void _ZN6S704C24v116Ev();
extern void _ZN6S704C24v117Ev();
extern void _ZN6S704C24v118Ev();
extern void _ZN6S704C24v119Ev();
extern void _ZN6S704C24v120Ev();
extern void _ZN6S704C24v121Ev();
extern void _ZN6S704C24v122Ev();
extern void _ZN6S704C24v123Ev();
extern void _ZN6S704C24v124Ev();
extern void _ZN6S704C24v125Ev();
static  VTBL_ENTRY vtc_S704C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S704C2[0]),
  (VTBL_ENTRY)&_ZN6S704C2D1Ev,
  (VTBL_ENTRY)&_ZN6S704C2D0Ev,
  (VTBL_ENTRY)&_ZN6S704C52v8Ev,
  (VTBL_ENTRY)&_ZN6S704C52v9Ev,
  (VTBL_ENTRY)&_ZN6S704C53v10Ev,
  (VTBL_ENTRY)&_ZN6S704C53v11Ev,
  (VTBL_ENTRY)&_ZN6S704C53v12Ev,
  (VTBL_ENTRY)&_ZN6S704C53v13Ev,
  (VTBL_ENTRY)&_ZN6S704C53v14Ev,
  (VTBL_ENTRY)&_ZN6S704C53v15Ev,
  (VTBL_ENTRY)&_ZN6S704C53v16Ev,
  (VTBL_ENTRY)&_ZN6S704C53v17Ev,
  (VTBL_ENTRY)&_ZN6S704C53v18Ev,
  (VTBL_ENTRY)&_ZN6S704C53v19Ev,
  (VTBL_ENTRY)&_ZN6S704C53v20Ev,
  (VTBL_ENTRY)&_ZN6S704C53v21Ev,
  (VTBL_ENTRY)&_ZN6S704C53v22Ev,
  (VTBL_ENTRY)&_ZN6S704C53v23Ev,
  (VTBL_ENTRY)&_ZN6S704C53v24Ev,
  (VTBL_ENTRY)&_ZN6S704C53v25Ev,
  (VTBL_ENTRY)&_ZN6S704C53v26Ev,
  (VTBL_ENTRY)&_ZN6S704C53v27Ev,
  (VTBL_ENTRY)&_ZN6S704C53v28Ev,
  (VTBL_ENTRY)&_ZN6S704C53v29Ev,
  (VTBL_ENTRY)&_ZN6S704C53v30Ev,
  (VTBL_ENTRY)&_ZN6S704C53v31Ev,
  (VTBL_ENTRY)&_ZN6S704C53v32Ev,
  (VTBL_ENTRY)&_ZN6S704C53v33Ev,
  (VTBL_ENTRY)&_ZN6S704C53v34Ev,
  (VTBL_ENTRY)&_ZN6S704C53v35Ev,
  (VTBL_ENTRY)&_ZN6S704C53v36Ev,
  (VTBL_ENTRY)&_ZN6S704C53v37Ev,
  (VTBL_ENTRY)&_ZN6S704C53v38Ev,
  (VTBL_ENTRY)&_ZN6S704C53v39Ev,
  (VTBL_ENTRY)&_ZN6S704C53v40Ev,
  (VTBL_ENTRY)&_ZN6S704C53v41Ev,
  (VTBL_ENTRY)&_ZN6S704C53v42Ev,
  (VTBL_ENTRY)&_ZN6S704C53v43Ev,
  (VTBL_ENTRY)&_ZN6S704C53v44Ev,
  (VTBL_ENTRY)&_ZN6S704C53v45Ev,
  (VTBL_ENTRY)&_ZN6S704C53v46Ev,
  (VTBL_ENTRY)&_ZN6S704C53v47Ev,
  (VTBL_ENTRY)&_ZN6S704C53v48Ev,
  (VTBL_ENTRY)&_ZN6S704C53v49Ev,
  (VTBL_ENTRY)&_ZN6S704C53v50Ev,
  (VTBL_ENTRY)&_ZN6S704C53v51Ev,
  (VTBL_ENTRY)&_ZN6S704C53v52Ev,
  (VTBL_ENTRY)&_ZN6S704C53v53Ev,
  (VTBL_ENTRY)&_ZN6S704C53v54Ev,
  (VTBL_ENTRY)&_ZN6S704C53v55Ev,
  (VTBL_ENTRY)&_ZN6S704C53v56Ev,
  (VTBL_ENTRY)&_ZN6S704C53v57Ev,
  (VTBL_ENTRY)&_ZN6S704C53v58Ev,
  (VTBL_ENTRY)&_ZN6S704C53v59Ev,
  (VTBL_ENTRY)&_ZN6S704C53v60Ev,
  (VTBL_ENTRY)&_ZN6S704C53v61Ev,
  (VTBL_ENTRY)&_ZN6S704C53v62Ev,
  (VTBL_ENTRY)&_ZN6S704C53v63Ev,
  (VTBL_ENTRY)&_ZN6S704C53v64Ev,
  (VTBL_ENTRY)&_ZN6S704C53v65Ev,
  (VTBL_ENTRY)&_ZN6S704C53v66Ev,
  (VTBL_ENTRY)&_ZN6S704C53v67Ev,
  (VTBL_ENTRY)&_ZN6S704C53v68Ev,
  (VTBL_ENTRY)&_ZN6S704C53v69Ev,
  (VTBL_ENTRY)&_ZN6S704C53v70Ev,
  (VTBL_ENTRY)&_ZN6S704C53v71Ev,
  (VTBL_ENTRY)&_ZN6S704C43v72Ev,
  (VTBL_ENTRY)&_ZN6S704C43v73Ev,
  (VTBL_ENTRY)&_ZN6S704C43v74Ev,
  (VTBL_ENTRY)&_ZN6S704C43v75Ev,
  (VTBL_ENTRY)&_ZN6S704C43v76Ev,
  (VTBL_ENTRY)&_ZN6S704C33v77Ev,
  (VTBL_ENTRY)&_ZN6S704C33v78Ev,
  (VTBL_ENTRY)&_ZN6S704C33v79Ev,
  (VTBL_ENTRY)&_ZN6S704C33v80Ev,
  (VTBL_ENTRY)&_ZN6S704C33v81Ev,
  (VTBL_ENTRY)&_ZN6S704C33v82Ev,
  (VTBL_ENTRY)&_ZN6S704C33v83Ev,
  (VTBL_ENTRY)&_ZN6S704C33v84Ev,
  (VTBL_ENTRY)&_ZN6S704C33v85Ev,
  (VTBL_ENTRY)&_ZN6S704C33v86Ev,
  (VTBL_ENTRY)&_ZN6S704C33v87Ev,
  (VTBL_ENTRY)&_ZN6S704C33v88Ev,
  (VTBL_ENTRY)&_ZN6S704C33v89Ev,
  (VTBL_ENTRY)&_ZN6S704C33v90Ev,
  (VTBL_ENTRY)&_ZN6S704C33v91Ev,
  (VTBL_ENTRY)&_ZN6S704C33v92Ev,
  (VTBL_ENTRY)&_ZN6S704C33v93Ev,
  (VTBL_ENTRY)&_ZN6S704C33v94Ev,
  (VTBL_ENTRY)&_ZN6S704C33v95Ev,
  (VTBL_ENTRY)&_ZN6S704C33v96Ev,
  (VTBL_ENTRY)&_ZN6S704C33v97Ev,
  (VTBL_ENTRY)&_ZN6S704C33v98Ev,
  (VTBL_ENTRY)&_ZN6S704C23v99Ev,
  (VTBL_ENTRY)&_ZN6S704C24v100Ev,
  (VTBL_ENTRY)&_ZN6S704C24v101Ev,
  (VTBL_ENTRY)&_ZN6S704C24v102Ev,
  (VTBL_ENTRY)&_ZN6S704C24v103Ev,
  (VTBL_ENTRY)&_ZN6S704C24v104Ev,
  (VTBL_ENTRY)&_ZN6S704C24v105Ev,
  (VTBL_ENTRY)&_ZN6S704C24v106Ev,
  (VTBL_ENTRY)&_ZN6S704C24v107Ev,
  (VTBL_ENTRY)&_ZN6S704C24v108Ev,
  (VTBL_ENTRY)&_ZN6S704C24v109Ev,
  (VTBL_ENTRY)&_ZN6S704C24v110Ev,
  (VTBL_ENTRY)&_ZN6S704C24v111Ev,
  (VTBL_ENTRY)&_ZN6S704C24v112Ev,
  (VTBL_ENTRY)&_ZN6S704C24v113Ev,
  (VTBL_ENTRY)&_ZN6S704C24v114Ev,
  (VTBL_ENTRY)&_ZN6S704C24v115Ev,
  (VTBL_ENTRY)&_ZN6S704C24v116Ev,
  (VTBL_ENTRY)&_ZN6S704C24v117Ev,
  (VTBL_ENTRY)&_ZN6S704C24v118Ev,
  (VTBL_ENTRY)&_ZN6S704C24v119Ev,
  (VTBL_ENTRY)&_ZN6S704C24v120Ev,
  (VTBL_ENTRY)&_ZN6S704C24v121Ev,
  (VTBL_ENTRY)&_ZN6S704C24v122Ev,
  (VTBL_ENTRY)&_ZN6S704C24v123Ev,
  (VTBL_ENTRY)&_ZN6S704C24v124Ev,
  (VTBL_ENTRY)&_ZN6S704C24v125Ev,
};
extern VTBL_ENTRY _ZTI6S704C2[];
extern  VTBL_ENTRY _ZTV6S704C2[];
Class_Descriptor cd_S704C2 = {  "S704C2", // class name
  bases_S704C2, 3,
  &(vtc_S704C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(352,252), // object size
  NSPAIRA(_ZTI6S704C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S704C2),122, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S704C1  : S704C2 {
  int s704c1f0;
  ::S836C29 s704c1f1;
  virtual  ~S704C1(); // _ZN6S704C1D1Ev
  virtual void  v1(); // _ZN6S704C12v1Ev
  virtual void  v2(); // _ZN6S704C12v2Ev
  virtual void  v3(); // _ZN6S704C12v3Ev
  virtual void  v4(); // _ZN6S704C12v4Ev
  virtual void  v5(); // _ZN6S704C12v5Ev
  virtual void  v6(); // _ZN6S704C12v6Ev
  virtual void  v7(); // _ZN6S704C12v7Ev
  S704C1(); // tgen
};
//SIG(1 S704C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v72 v73 v74 v75 v76 Fp FC6} vd v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 Fp FC7{ m} FC7 FC8{ m Fi[4]} FC8 Fi FC9{ m} Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp FC10{ BC11{ BC12{ m Fp Fi[2]}}} FC13{ m} Fi:1 FC14{ BC15{ BC12}} FC14 FC16{ BC17{ BC12}} FC16 Fc[2] FC18{ m Fi[4]} Fi[3] Fc[2] Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 Fi FC9}


 S704C1 ::~S704C1(){ note_dtor("S704C1", this);}
void  S704C1 ::v1(){vfunc_called(this, "_ZN6S704C12v1Ev");}
void  S704C1 ::v2(){vfunc_called(this, "_ZN6S704C12v2Ev");}
void  S704C1 ::v3(){vfunc_called(this, "_ZN6S704C12v3Ev");}
void  S704C1 ::v4(){vfunc_called(this, "_ZN6S704C12v4Ev");}
void  S704C1 ::v5(){vfunc_called(this, "_ZN6S704C12v5Ev");}
void  S704C1 ::v6(){vfunc_called(this, "_ZN6S704C12v6Ev");}
void  S704C1 ::v7(){vfunc_called(this, "_ZN6S704C12v7Ev");}
S704C1 ::S704C1(){ note_ctor("S704C1", this);} // tgen

static void Test_S704C1()
{
  extern Class_Descriptor cd_S704C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(46,66)];
    init_test(&cd_S704C1, buf);
    S704C1 *dp, &lv = *(dp=new (buf) S704C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(360,260), "sizeof(S704C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S704C1)");
    check_base_class_offset(lv, (S704C5*)(S704C4*)(S704C3*)(S704C2*), 0, "S704C1");
    check_base_class_offset(lv, (S704C4*)(S704C3*)(S704C2*), 0, "S704C1");
    check_base_class_offset(lv, (S704C3*)(S704C2*), 0, "S704C1");
    check_base_class_offset(lv, (S704C2*), 0, "S704C1");
    check_field_offset(lv, s704c1f0, ABISELECT(348,252), "S704C1.s704c1f0");
    check_field_offset(lv, s704c1f1, ABISELECT(352,256), "S704C1.s704c1f1");
    test_class_info(&lv, &cd_S704C1);
    dp->~S704C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS704C1(Test_S704C1, "S704C1", ABISELECT(360,260));

#else // __cplusplus

extern void _ZN6S704C1C1Ev();
extern void _ZN6S704C1D1Ev();
Name_Map name_map_S704C1[] = {
  NSPAIR(_ZN6S704C1C1Ev),
  NSPAIR(_ZN6S704C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S704C5;
extern VTBL_ENTRY _ZTI6S704C5[];
extern  VTBL_ENTRY _ZTV6S704C5[];
extern Class_Descriptor cd_S704C4;
extern VTBL_ENTRY _ZTI6S704C4[];
extern  VTBL_ENTRY _ZTV6S704C4[];
extern Class_Descriptor cd_S704C3;
extern VTBL_ENTRY _ZTI6S704C3[];
extern  VTBL_ENTRY _ZTV6S704C3[];
extern Class_Descriptor cd_S704C2;
extern VTBL_ENTRY _ZTI6S704C2[];
extern  VTBL_ENTRY _ZTV6S704C2[];
static Base_Class bases_S704C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S704C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S704C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S704C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S704C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S704C1[];
extern void _ZN6S704C1D1Ev();
extern void _ZN6S704C1D0Ev();
extern void _ZN6S704C52v8Ev();
extern void _ZN6S704C52v9Ev();
extern void _ZN6S704C53v10Ev();
extern void _ZN6S704C53v11Ev();
extern void _ZN6S704C53v12Ev();
extern void _ZN6S704C53v13Ev();
extern void _ZN6S704C53v14Ev();
extern void _ZN6S704C53v15Ev();
extern void _ZN6S704C53v16Ev();
extern void _ZN6S704C53v17Ev();
extern void _ZN6S704C53v18Ev();
extern void _ZN6S704C53v19Ev();
extern void _ZN6S704C53v20Ev();
extern void _ZN6S704C53v21Ev();
extern void _ZN6S704C53v22Ev();
extern void _ZN6S704C53v23Ev();
extern void _ZN6S704C53v24Ev();
extern void _ZN6S704C53v25Ev();
extern void _ZN6S704C53v26Ev();
extern void _ZN6S704C53v27Ev();
extern void _ZN6S704C53v28Ev();
extern void _ZN6S704C53v29Ev();
extern void _ZN6S704C53v30Ev();
extern void _ZN6S704C53v31Ev();
extern void _ZN6S704C53v32Ev();
extern void _ZN6S704C53v33Ev();
extern void _ZN6S704C53v34Ev();
extern void _ZN6S704C53v35Ev();
extern void _ZN6S704C53v36Ev();
extern void _ZN6S704C53v37Ev();
extern void _ZN6S704C53v38Ev();
extern void _ZN6S704C53v39Ev();
extern void _ZN6S704C53v40Ev();
extern void _ZN6S704C53v41Ev();
extern void _ZN6S704C53v42Ev();
extern void _ZN6S704C53v43Ev();
extern void _ZN6S704C53v44Ev();
extern void _ZN6S704C53v45Ev();
extern void _ZN6S704C53v46Ev();
extern void _ZN6S704C53v47Ev();
extern void _ZN6S704C53v48Ev();
extern void _ZN6S704C53v49Ev();
extern void _ZN6S704C53v50Ev();
extern void _ZN6S704C53v51Ev();
extern void _ZN6S704C53v52Ev();
extern void _ZN6S704C53v53Ev();
extern void _ZN6S704C53v54Ev();
extern void _ZN6S704C53v55Ev();
extern void _ZN6S704C53v56Ev();
extern void _ZN6S704C53v57Ev();
extern void _ZN6S704C53v58Ev();
extern void _ZN6S704C53v59Ev();
extern void _ZN6S704C53v60Ev();
extern void _ZN6S704C53v61Ev();
extern void _ZN6S704C53v62Ev();
extern void _ZN6S704C53v63Ev();
extern void _ZN6S704C53v64Ev();
extern void _ZN6S704C53v65Ev();
extern void _ZN6S704C53v66Ev();
extern void _ZN6S704C53v67Ev();
extern void _ZN6S704C53v68Ev();
extern void _ZN6S704C53v69Ev();
extern void _ZN6S704C53v70Ev();
extern void _ZN6S704C53v71Ev();
extern void _ZN6S704C43v72Ev();
extern void _ZN6S704C43v73Ev();
extern void _ZN6S704C43v74Ev();
extern void _ZN6S704C43v75Ev();
extern void _ZN6S704C43v76Ev();
extern void _ZN6S704C33v77Ev();
extern void _ZN6S704C33v78Ev();
extern void _ZN6S704C33v79Ev();
extern void _ZN6S704C33v80Ev();
extern void _ZN6S704C33v81Ev();
extern void _ZN6S704C33v82Ev();
extern void _ZN6S704C33v83Ev();
extern void _ZN6S704C33v84Ev();
extern void _ZN6S704C33v85Ev();
extern void _ZN6S704C33v86Ev();
extern void _ZN6S704C33v87Ev();
extern void _ZN6S704C33v88Ev();
extern void _ZN6S704C33v89Ev();
extern void _ZN6S704C33v90Ev();
extern void _ZN6S704C33v91Ev();
extern void _ZN6S704C33v92Ev();
extern void _ZN6S704C33v93Ev();
extern void _ZN6S704C33v94Ev();
extern void _ZN6S704C33v95Ev();
extern void _ZN6S704C33v96Ev();
extern void _ZN6S704C33v97Ev();
extern void _ZN6S704C33v98Ev();
extern void _ZN6S704C23v99Ev();
extern void _ZN6S704C24v100Ev();
extern void _ZN6S704C24v101Ev();
extern void _ZN6S704C24v102Ev();
extern void _ZN6S704C24v103Ev();
extern void _ZN6S704C24v104Ev();
extern void _ZN6S704C24v105Ev();
extern void _ZN6S704C24v106Ev();
extern void _ZN6S704C24v107Ev();
extern void _ZN6S704C24v108Ev();
extern void _ZN6S704C24v109Ev();
extern void _ZN6S704C24v110Ev();
extern void _ZN6S704C24v111Ev();
extern void _ZN6S704C24v112Ev();
extern void _ZN6S704C24v113Ev();
extern void _ZN6S704C24v114Ev();
extern void _ZN6S704C24v115Ev();
extern void _ZN6S704C24v116Ev();
extern void _ZN6S704C24v117Ev();
extern void _ZN6S704C24v118Ev();
extern void _ZN6S704C24v119Ev();
extern void _ZN6S704C24v120Ev();
extern void _ZN6S704C24v121Ev();
extern void _ZN6S704C24v122Ev();
extern void _ZN6S704C24v123Ev();
extern void _ZN6S704C24v124Ev();
extern void _ZN6S704C24v125Ev();
extern void _ZN6S704C12v1Ev();
extern void _ZN6S704C12v2Ev();
extern void _ZN6S704C12v3Ev();
extern void _ZN6S704C12v4Ev();
extern void _ZN6S704C12v5Ev();
extern void _ZN6S704C12v6Ev();
extern void _ZN6S704C12v7Ev();
static  VTBL_ENTRY vtc_S704C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S704C1[0]),
  (VTBL_ENTRY)&_ZN6S704C1D1Ev,
  (VTBL_ENTRY)&_ZN6S704C1D0Ev,
  (VTBL_ENTRY)&_ZN6S704C52v8Ev,
  (VTBL_ENTRY)&_ZN6S704C52v9Ev,
  (VTBL_ENTRY)&_ZN6S704C53v10Ev,
  (VTBL_ENTRY)&_ZN6S704C53v11Ev,
  (VTBL_ENTRY)&_ZN6S704C53v12Ev,
  (VTBL_ENTRY)&_ZN6S704C53v13Ev,
  (VTBL_ENTRY)&_ZN6S704C53v14Ev,
  (VTBL_ENTRY)&_ZN6S704C53v15Ev,
  (VTBL_ENTRY)&_ZN6S704C53v16Ev,
  (VTBL_ENTRY)&_ZN6S704C53v17Ev,
  (VTBL_ENTRY)&_ZN6S704C53v18Ev,
  (VTBL_ENTRY)&_ZN6S704C53v19Ev,
  (VTBL_ENTRY)&_ZN6S704C53v20Ev,
  (VTBL_ENTRY)&_ZN6S704C53v21Ev,
  (VTBL_ENTRY)&_ZN6S704C53v22Ev,
  (VTBL_ENTRY)&_ZN6S704C53v23Ev,
  (VTBL_ENTRY)&_ZN6S704C53v24Ev,
  (VTBL_ENTRY)&_ZN6S704C53v25Ev,
  (VTBL_ENTRY)&_ZN6S704C53v26Ev,
  (VTBL_ENTRY)&_ZN6S704C53v27Ev,
  (VTBL_ENTRY)&_ZN6S704C53v28Ev,
  (VTBL_ENTRY)&_ZN6S704C53v29Ev,
  (VTBL_ENTRY)&_ZN6S704C53v30Ev,
  (VTBL_ENTRY)&_ZN6S704C53v31Ev,
  (VTBL_ENTRY)&_ZN6S704C53v32Ev,
  (VTBL_ENTRY)&_ZN6S704C53v33Ev,
  (VTBL_ENTRY)&_ZN6S704C53v34Ev,
  (VTBL_ENTRY)&_ZN6S704C53v35Ev,
  (VTBL_ENTRY)&_ZN6S704C53v36Ev,
  (VTBL_ENTRY)&_ZN6S704C53v37Ev,
  (VTBL_ENTRY)&_ZN6S704C53v38Ev,
  (VTBL_ENTRY)&_ZN6S704C53v39Ev,
  (VTBL_ENTRY)&_ZN6S704C53v40Ev,
  (VTBL_ENTRY)&_ZN6S704C53v41Ev,
  (VTBL_ENTRY)&_ZN6S704C53v42Ev,
  (VTBL_ENTRY)&_ZN6S704C53v43Ev,
  (VTBL_ENTRY)&_ZN6S704C53v44Ev,
  (VTBL_ENTRY)&_ZN6S704C53v45Ev,
  (VTBL_ENTRY)&_ZN6S704C53v46Ev,
  (VTBL_ENTRY)&_ZN6S704C53v47Ev,
  (VTBL_ENTRY)&_ZN6S704C53v48Ev,
  (VTBL_ENTRY)&_ZN6S704C53v49Ev,
  (VTBL_ENTRY)&_ZN6S704C53v50Ev,
  (VTBL_ENTRY)&_ZN6S704C53v51Ev,
  (VTBL_ENTRY)&_ZN6S704C53v52Ev,
  (VTBL_ENTRY)&_ZN6S704C53v53Ev,
  (VTBL_ENTRY)&_ZN6S704C53v54Ev,
  (VTBL_ENTRY)&_ZN6S704C53v55Ev,
  (VTBL_ENTRY)&_ZN6S704C53v56Ev,
  (VTBL_ENTRY)&_ZN6S704C53v57Ev,
  (VTBL_ENTRY)&_ZN6S704C53v58Ev,
  (VTBL_ENTRY)&_ZN6S704C53v59Ev,
  (VTBL_ENTRY)&_ZN6S704C53v60Ev,
  (VTBL_ENTRY)&_ZN6S704C53v61Ev,
  (VTBL_ENTRY)&_ZN6S704C53v62Ev,
  (VTBL_ENTRY)&_ZN6S704C53v63Ev,
  (VTBL_ENTRY)&_ZN6S704C53v64Ev,
  (VTBL_ENTRY)&_ZN6S704C53v65Ev,
  (VTBL_ENTRY)&_ZN6S704C53v66Ev,
  (VTBL_ENTRY)&_ZN6S704C53v67Ev,
  (VTBL_ENTRY)&_ZN6S704C53v68Ev,
  (VTBL_ENTRY)&_ZN6S704C53v69Ev,
  (VTBL_ENTRY)&_ZN6S704C53v70Ev,
  (VTBL_ENTRY)&_ZN6S704C53v71Ev,
  (VTBL_ENTRY)&_ZN6S704C43v72Ev,
  (VTBL_ENTRY)&_ZN6S704C43v73Ev,
  (VTBL_ENTRY)&_ZN6S704C43v74Ev,
  (VTBL_ENTRY)&_ZN6S704C43v75Ev,
  (VTBL_ENTRY)&_ZN6S704C43v76Ev,
  (VTBL_ENTRY)&_ZN6S704C33v77Ev,
  (VTBL_ENTRY)&_ZN6S704C33v78Ev,
  (VTBL_ENTRY)&_ZN6S704C33v79Ev,
  (VTBL_ENTRY)&_ZN6S704C33v80Ev,
  (VTBL_ENTRY)&_ZN6S704C33v81Ev,
  (VTBL_ENTRY)&_ZN6S704C33v82Ev,
  (VTBL_ENTRY)&_ZN6S704C33v83Ev,
  (VTBL_ENTRY)&_ZN6S704C33v84Ev,
  (VTBL_ENTRY)&_ZN6S704C33v85Ev,
  (VTBL_ENTRY)&_ZN6S704C33v86Ev,
  (VTBL_ENTRY)&_ZN6S704C33v87Ev,
  (VTBL_ENTRY)&_ZN6S704C33v88Ev,
  (VTBL_ENTRY)&_ZN6S704C33v89Ev,
  (VTBL_ENTRY)&_ZN6S704C33v90Ev,
  (VTBL_ENTRY)&_ZN6S704C33v91Ev,
  (VTBL_ENTRY)&_ZN6S704C33v92Ev,
  (VTBL_ENTRY)&_ZN6S704C33v93Ev,
  (VTBL_ENTRY)&_ZN6S704C33v94Ev,
  (VTBL_ENTRY)&_ZN6S704C33v95Ev,
  (VTBL_ENTRY)&_ZN6S704C33v96Ev,
  (VTBL_ENTRY)&_ZN6S704C33v97Ev,
  (VTBL_ENTRY)&_ZN6S704C33v98Ev,
  (VTBL_ENTRY)&_ZN6S704C23v99Ev,
  (VTBL_ENTRY)&_ZN6S704C24v100Ev,
  (VTBL_ENTRY)&_ZN6S704C24v101Ev,
  (VTBL_ENTRY)&_ZN6S704C24v102Ev,
  (VTBL_ENTRY)&_ZN6S704C24v103Ev,
  (VTBL_ENTRY)&_ZN6S704C24v104Ev,
  (VTBL_ENTRY)&_ZN6S704C24v105Ev,
  (VTBL_ENTRY)&_ZN6S704C24v106Ev,
  (VTBL_ENTRY)&_ZN6S704C24v107Ev,
  (VTBL_ENTRY)&_ZN6S704C24v108Ev,
  (VTBL_ENTRY)&_ZN6S704C24v109Ev,
  (VTBL_ENTRY)&_ZN6S704C24v110Ev,
  (VTBL_ENTRY)&_ZN6S704C24v111Ev,
  (VTBL_ENTRY)&_ZN6S704C24v112Ev,
  (VTBL_ENTRY)&_ZN6S704C24v113Ev,
  (VTBL_ENTRY)&_ZN6S704C24v114Ev,
  (VTBL_ENTRY)&_ZN6S704C24v115Ev,
  (VTBL_ENTRY)&_ZN6S704C24v116Ev,
  (VTBL_ENTRY)&_ZN6S704C24v117Ev,
  (VTBL_ENTRY)&_ZN6S704C24v118Ev,
  (VTBL_ENTRY)&_ZN6S704C24v119Ev,
  (VTBL_ENTRY)&_ZN6S704C24v120Ev,
  (VTBL_ENTRY)&_ZN6S704C24v121Ev,
  (VTBL_ENTRY)&_ZN6S704C24v122Ev,
  (VTBL_ENTRY)&_ZN6S704C24v123Ev,
  (VTBL_ENTRY)&_ZN6S704C24v124Ev,
  (VTBL_ENTRY)&_ZN6S704C24v125Ev,
  (VTBL_ENTRY)&_ZN6S704C12v1Ev,
  (VTBL_ENTRY)&_ZN6S704C12v2Ev,
  (VTBL_ENTRY)&_ZN6S704C12v3Ev,
  (VTBL_ENTRY)&_ZN6S704C12v4Ev,
  (VTBL_ENTRY)&_ZN6S704C12v5Ev,
  (VTBL_ENTRY)&_ZN6S704C12v6Ev,
  (VTBL_ENTRY)&_ZN6S704C12v7Ev,
};
extern VTBL_ENTRY _ZTI6S704C1[];
extern  VTBL_ENTRY _ZTV6S704C1[];
Class_Descriptor cd_S704C1 = {  "S704C1", // class name
  bases_S704C1, 4,
  &(vtc_S704C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(360,260), // object size
  NSPAIRA(_ZTI6S704C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S704C1),129, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S661C5  {
  int s661c5f0;
  __tsi64 s661c5f1;
  void *s661c5f2[4];
  int s661c5f3[2];
  void *s661c5f4;
  ::S235C7_nt s661c5f5;
  void *s661c5f6[2];
  virtual  ~S661C5(); // _ZN6S661C5D1Ev
  virtual void  v6(); // _ZN6S661C52v6Ev
  virtual void  v7(); // _ZN6S661C52v7Ev
  virtual void  v8(); // _ZN6S661C52v8Ev
  virtual void  v9(); // _ZN6S661C52v9Ev
  virtual void  v10(); // _ZN6S661C53v10Ev
  virtual void  v11(); // _ZN6S661C53v11Ev
  virtual void  v12(); // _ZN6S661C53v12Ev
  virtual void  v13(); // _ZN6S661C53v13Ev
  virtual void  v14(); // _ZN6S661C53v14Ev
  virtual void  v15(); // _ZN6S661C53v15Ev
  virtual void  v16(); // _ZN6S661C53v16Ev
  virtual void  v17(); // _ZN6S661C53v17Ev
  virtual void  v18(); // _ZN6S661C53v18Ev
  virtual void  v19(); // _ZN6S661C53v19Ev
  virtual void  v20(); // _ZN6S661C53v20Ev
  virtual void  v21(); // _ZN6S661C53v21Ev
  virtual void  v22(); // _ZN6S661C53v22Ev
  virtual void  v23(); // _ZN6S661C53v23Ev
  virtual void  v24(); // _ZN6S661C53v24Ev
  virtual void  v25(); // _ZN6S661C53v25Ev
  virtual void  v26(); // _ZN6S661C53v26Ev
  virtual void  v27(); // _ZN6S661C53v27Ev
  virtual void  v28(); // _ZN6S661C53v28Ev
  virtual void  v29(); // _ZN6S661C53v29Ev
  virtual void  v30(); // _ZN6S661C53v30Ev
  virtual void  v31(); // _ZN6S661C53v31Ev
  virtual void  v32(); // _ZN6S661C53v32Ev
  virtual void  v33(); // _ZN6S661C53v33Ev
  virtual void  v34(); // _ZN6S661C53v34Ev
  virtual void  v35(); // _ZN6S661C53v35Ev
  virtual void  v36(); // _ZN6S661C53v36Ev
  virtual void  v37(); // _ZN6S661C53v37Ev
  virtual void  v38(); // _ZN6S661C53v38Ev
  virtual void  v39(); // _ZN6S661C53v39Ev
  virtual void  v40(); // _ZN6S661C53v40Ev
  virtual void  v41(); // _ZN6S661C53v41Ev
  virtual void  v42(); // _ZN6S661C53v42Ev
  virtual void  v43(); // _ZN6S661C53v43Ev
  virtual void  v44(); // _ZN6S661C53v44Ev
  virtual void  v45(); // _ZN6S661C53v45Ev
  virtual void  v46(); // _ZN6S661C53v46Ev
  virtual void  v47(); // _ZN6S661C53v47Ev
  virtual void  v48(); // _ZN6S661C53v48Ev
  virtual void  v49(); // _ZN6S661C53v49Ev
  virtual void  v50(); // _ZN6S661C53v50Ev
  virtual void  v51(); // _ZN6S661C53v51Ev
  virtual void  v52(); // _ZN6S661C53v52Ev
  virtual void  v53(); // _ZN6S661C53v53Ev
  virtual void  v54(); // _ZN6S661C53v54Ev
  virtual void  v55(); // _ZN6S661C53v55Ev
  virtual void  v56(); // _ZN6S661C53v56Ev
  virtual void  v57(); // _ZN6S661C53v57Ev
  virtual void  v58(); // _ZN6S661C53v58Ev
  virtual void  v59(); // _ZN6S661C53v59Ev
  virtual void  v60(); // _ZN6S661C53v60Ev
  virtual void  v61(); // _ZN6S661C53v61Ev
  virtual void  v62(); // _ZN6S661C53v62Ev
  virtual void  v63(); // _ZN6S661C53v63Ev
  virtual void  v64(); // _ZN6S661C53v64Ev
  virtual void  v65(); // _ZN6S661C53v65Ev
  virtual void  v66(); // _ZN6S661C53v66Ev
  virtual void  v67(); // _ZN6S661C53v67Ev
  virtual void  v68(); // _ZN6S661C53v68Ev
  virtual void  v69(); // _ZN6S661C53v69Ev
  S661C5(); // tgen
};
//SIG(-1 S661C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S661C5 ::~S661C5(){ note_dtor("S661C5", this);}
void  S661C5 ::v6(){vfunc_called(this, "_ZN6S661C52v6Ev");}
void  S661C5 ::v7(){vfunc_called(this, "_ZN6S661C52v7Ev");}
void  S661C5 ::v8(){vfunc_called(this, "_ZN6S661C52v8Ev");}
void  S661C5 ::v9(){vfunc_called(this, "_ZN6S661C52v9Ev");}
void  S661C5 ::v10(){vfunc_called(this, "_ZN6S661C53v10Ev");}
void  S661C5 ::v11(){vfunc_called(this, "_ZN6S661C53v11Ev");}
void  S661C5 ::v12(){vfunc_called(this, "_ZN6S661C53v12Ev");}
void  S661C5 ::v13(){vfunc_called(this, "_ZN6S661C53v13Ev");}
void  S661C5 ::v14(){vfunc_called(this, "_ZN6S661C53v14Ev");}
void  S661C5 ::v15(){vfunc_called(this, "_ZN6S661C53v15Ev");}
void  S661C5 ::v16(){vfunc_called(this, "_ZN6S661C53v16Ev");}
void  S661C5 ::v17(){vfunc_called(this, "_ZN6S661C53v17Ev");}
void  S661C5 ::v18(){vfunc_called(this, "_ZN6S661C53v18Ev");}
void  S661C5 ::v19(){vfunc_called(this, "_ZN6S661C53v19Ev");}
void  S661C5 ::v20(){vfunc_called(this, "_ZN6S661C53v20Ev");}
void  S661C5 ::v21(){vfunc_called(this, "_ZN6S661C53v21Ev");}
void  S661C5 ::v22(){vfunc_called(this, "_ZN6S661C53v22Ev");}
void  S661C5 ::v23(){vfunc_called(this, "_ZN6S661C53v23Ev");}
void  S661C5 ::v24(){vfunc_called(this, "_ZN6S661C53v24Ev");}
void  S661C5 ::v25(){vfunc_called(this, "_ZN6S661C53v25Ev");}
void  S661C5 ::v26(){vfunc_called(this, "_ZN6S661C53v26Ev");}
void  S661C5 ::v27(){vfunc_called(this, "_ZN6S661C53v27Ev");}
void  S661C5 ::v28(){vfunc_called(this, "_ZN6S661C53v28Ev");}
void  S661C5 ::v29(){vfunc_called(this, "_ZN6S661C53v29Ev");}
void  S661C5 ::v30(){vfunc_called(this, "_ZN6S661C53v30Ev");}
void  S661C5 ::v31(){vfunc_called(this, "_ZN6S661C53v31Ev");}
void  S661C5 ::v32(){vfunc_called(this, "_ZN6S661C53v32Ev");}
void  S661C5 ::v33(){vfunc_called(this, "_ZN6S661C53v33Ev");}
void  S661C5 ::v34(){vfunc_called(this, "_ZN6S661C53v34Ev");}
void  S661C5 ::v35(){vfunc_called(this, "_ZN6S661C53v35Ev");}
void  S661C5 ::v36(){vfunc_called(this, "_ZN6S661C53v36Ev");}
void  S661C5 ::v37(){vfunc_called(this, "_ZN6S661C53v37Ev");}
void  S661C5 ::v38(){vfunc_called(this, "_ZN6S661C53v38Ev");}
void  S661C5 ::v39(){vfunc_called(this, "_ZN6S661C53v39Ev");}
void  S661C5 ::v40(){vfunc_called(this, "_ZN6S661C53v40Ev");}
void  S661C5 ::v41(){vfunc_called(this, "_ZN6S661C53v41Ev");}
void  S661C5 ::v42(){vfunc_called(this, "_ZN6S661C53v42Ev");}
void  S661C5 ::v43(){vfunc_called(this, "_ZN6S661C53v43Ev");}
void  S661C5 ::v44(){vfunc_called(this, "_ZN6S661C53v44Ev");}
void  S661C5 ::v45(){vfunc_called(this, "_ZN6S661C53v45Ev");}
void  S661C5 ::v46(){vfunc_called(this, "_ZN6S661C53v46Ev");}
void  S661C5 ::v47(){vfunc_called(this, "_ZN6S661C53v47Ev");}
void  S661C5 ::v48(){vfunc_called(this, "_ZN6S661C53v48Ev");}
void  S661C5 ::v49(){vfunc_called(this, "_ZN6S661C53v49Ev");}
void  S661C5 ::v50(){vfunc_called(this, "_ZN6S661C53v50Ev");}
void  S661C5 ::v51(){vfunc_called(this, "_ZN6S661C53v51Ev");}
void  S661C5 ::v52(){vfunc_called(this, "_ZN6S661C53v52Ev");}
void  S661C5 ::v53(){vfunc_called(this, "_ZN6S661C53v53Ev");}
void  S661C5 ::v54(){vfunc_called(this, "_ZN6S661C53v54Ev");}
void  S661C5 ::v55(){vfunc_called(this, "_ZN6S661C53v55Ev");}
void  S661C5 ::v56(){vfunc_called(this, "_ZN6S661C53v56Ev");}
void  S661C5 ::v57(){vfunc_called(this, "_ZN6S661C53v57Ev");}
void  S661C5 ::v58(){vfunc_called(this, "_ZN6S661C53v58Ev");}
void  S661C5 ::v59(){vfunc_called(this, "_ZN6S661C53v59Ev");}
void  S661C5 ::v60(){vfunc_called(this, "_ZN6S661C53v60Ev");}
void  S661C5 ::v61(){vfunc_called(this, "_ZN6S661C53v61Ev");}
void  S661C5 ::v62(){vfunc_called(this, "_ZN6S661C53v62Ev");}
void  S661C5 ::v63(){vfunc_called(this, "_ZN6S661C53v63Ev");}
void  S661C5 ::v64(){vfunc_called(this, "_ZN6S661C53v64Ev");}
void  S661C5 ::v65(){vfunc_called(this, "_ZN6S661C53v65Ev");}
void  S661C5 ::v66(){vfunc_called(this, "_ZN6S661C53v66Ev");}
void  S661C5 ::v67(){vfunc_called(this, "_ZN6S661C53v67Ev");}
void  S661C5 ::v68(){vfunc_called(this, "_ZN6S661C53v68Ev");}
void  S661C5 ::v69(){vfunc_called(this, "_ZN6S661C53v69Ev");}
S661C5 ::S661C5(){ note_ctor("S661C5", this);} // tgen

static void Test_S661C5()
{
  extern Class_Descriptor cd_S661C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S661C5, buf);
    S661C5 *dp, &lv = *(dp=new (buf) S661C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S661C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S661C5)");
    check_field_offset(lv, s661c5f0, ABISELECT(8,4), "S661C5.s661c5f0");
    check_field_offset(lv, s661c5f1, ABISELECT(16,8), "S661C5.s661c5f1");
    check_field_offset(lv, s661c5f2, ABISELECT(24,16), "S661C5.s661c5f2");
    check_field_offset(lv, s661c5f3, ABISELECT(56,32), "S661C5.s661c5f3");
    check_field_offset(lv, s661c5f4, ABISELECT(64,40), "S661C5.s661c5f4");
    check_field_offset(lv, s661c5f5, ABISELECT(72,44), "S661C5.s661c5f5");
    check_field_offset(lv, s661c5f6, ABISELECT(80,52), "S661C5.s661c5f6");
    test_class_info(&lv, &cd_S661C5);
    dp->~S661C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS661C5(Test_S661C5, "S661C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S661C5C1Ev();
extern void _ZN6S661C5D1Ev();
Name_Map name_map_S661C5[] = {
  NSPAIR(_ZN6S661C5C1Ev),
  NSPAIR(_ZN6S661C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S661C5[];
extern void _ZN6S661C5D1Ev();
extern void _ZN6S661C5D0Ev();
extern void _ZN6S661C52v6Ev();
extern void _ZN6S661C52v7Ev();
extern void _ZN6S661C52v8Ev();
extern void _ZN6S661C52v9Ev();
extern void _ZN6S661C53v10Ev();
extern void _ZN6S661C53v11Ev();
extern void _ZN6S661C53v12Ev();
extern void _ZN6S661C53v13Ev();
extern void _ZN6S661C53v14Ev();
extern void _ZN6S661C53v15Ev();
extern void _ZN6S661C53v16Ev();
extern void _ZN6S661C53v17Ev();
extern void _ZN6S661C53v18Ev();
extern void _ZN6S661C53v19Ev();
extern void _ZN6S661C53v20Ev();
extern void _ZN6S661C53v21Ev();
extern void _ZN6S661C53v22Ev();
extern void _ZN6S661C53v23Ev();
extern void _ZN6S661C53v24Ev();
extern void _ZN6S661C53v25Ev();
extern void _ZN6S661C53v26Ev();
extern void _ZN6S661C53v27Ev();
extern void _ZN6S661C53v28Ev();
extern void _ZN6S661C53v29Ev();
extern void _ZN6S661C53v30Ev();
extern void _ZN6S661C53v31Ev();
extern void _ZN6S661C53v32Ev();
extern void _ZN6S661C53v33Ev();
extern void _ZN6S661C53v34Ev();
extern void _ZN6S661C53v35Ev();
extern void _ZN6S661C53v36Ev();
extern void _ZN6S661C53v37Ev();
extern void _ZN6S661C53v38Ev();
extern void _ZN6S661C53v39Ev();
extern void _ZN6S661C53v40Ev();
extern void _ZN6S661C53v41Ev();
extern void _ZN6S661C53v42Ev();
extern void _ZN6S661C53v43Ev();
extern void _ZN6S661C53v44Ev();
extern void _ZN6S661C53v45Ev();
extern void _ZN6S661C53v46Ev();
extern void _ZN6S661C53v47Ev();
extern void _ZN6S661C53v48Ev();
extern void _ZN6S661C53v49Ev();
extern void _ZN6S661C53v50Ev();
extern void _ZN6S661C53v51Ev();
extern void _ZN6S661C53v52Ev();
extern void _ZN6S661C53v53Ev();
extern void _ZN6S661C53v54Ev();
extern void _ZN6S661C53v55Ev();
extern void _ZN6S661C53v56Ev();
extern void _ZN6S661C53v57Ev();
extern void _ZN6S661C53v58Ev();
extern void _ZN6S661C53v59Ev();
extern void _ZN6S661C53v60Ev();
extern void _ZN6S661C53v61Ev();
extern void _ZN6S661C53v62Ev();
extern void _ZN6S661C53v63Ev();
extern void _ZN6S661C53v64Ev();
extern void _ZN6S661C53v65Ev();
extern void _ZN6S661C53v66Ev();
extern void _ZN6S661C53v67Ev();
extern void _ZN6S661C53v68Ev();
extern void _ZN6S661C53v69Ev();
static  VTBL_ENTRY vtc_S661C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S661C5[0]),
  (VTBL_ENTRY)&_ZN6S661C5D1Ev,
  (VTBL_ENTRY)&_ZN6S661C5D0Ev,
  (VTBL_ENTRY)&_ZN6S661C52v6Ev,
  (VTBL_ENTRY)&_ZN6S661C52v7Ev,
  (VTBL_ENTRY)&_ZN6S661C52v8Ev,
  (VTBL_ENTRY)&_ZN6S661C52v9Ev,
  (VTBL_ENTRY)&_ZN6S661C53v10Ev,
  (VTBL_ENTRY)&_ZN6S661C53v11Ev,
  (VTBL_ENTRY)&_ZN6S661C53v12Ev,
  (VTBL_ENTRY)&_ZN6S661C53v13Ev,
  (VTBL_ENTRY)&_ZN6S661C53v14Ev,
  (VTBL_ENTRY)&_ZN6S661C53v15Ev,
  (VTBL_ENTRY)&_ZN6S661C53v16Ev,
  (VTBL_ENTRY)&_ZN6S661C53v17Ev,
  (VTBL_ENTRY)&_ZN6S661C53v18Ev,
  (VTBL_ENTRY)&_ZN6S661C53v19Ev,
  (VTBL_ENTRY)&_ZN6S661C53v20Ev,
  (VTBL_ENTRY)&_ZN6S661C53v21Ev,
  (VTBL_ENTRY)&_ZN6S661C53v22Ev,
  (VTBL_ENTRY)&_ZN6S661C53v23Ev,
  (VTBL_ENTRY)&_ZN6S661C53v24Ev,
  (VTBL_ENTRY)&_ZN6S661C53v25Ev,
  (VTBL_ENTRY)&_ZN6S661C53v26Ev,
  (VTBL_ENTRY)&_ZN6S661C53v27Ev,
  (VTBL_ENTRY)&_ZN6S661C53v28Ev,
  (VTBL_ENTRY)&_ZN6S661C53v29Ev,
  (VTBL_ENTRY)&_ZN6S661C53v30Ev,
  (VTBL_ENTRY)&_ZN6S661C53v31Ev,
  (VTBL_ENTRY)&_ZN6S661C53v32Ev,
  (VTBL_ENTRY)&_ZN6S661C53v33Ev,
  (VTBL_ENTRY)&_ZN6S661C53v34Ev,
  (VTBL_ENTRY)&_ZN6S661C53v35Ev,
  (VTBL_ENTRY)&_ZN6S661C53v36Ev,
  (VTBL_ENTRY)&_ZN6S661C53v37Ev,
  (VTBL_ENTRY)&_ZN6S661C53v38Ev,
  (VTBL_ENTRY)&_ZN6S661C53v39Ev,
  (VTBL_ENTRY)&_ZN6S661C53v40Ev,
  (VTBL_ENTRY)&_ZN6S661C53v41Ev,
  (VTBL_ENTRY)&_ZN6S661C53v42Ev,
  (VTBL_ENTRY)&_ZN6S661C53v43Ev,
  (VTBL_ENTRY)&_ZN6S661C53v44Ev,
  (VTBL_ENTRY)&_ZN6S661C53v45Ev,
  (VTBL_ENTRY)&_ZN6S661C53v46Ev,
  (VTBL_ENTRY)&_ZN6S661C53v47Ev,
  (VTBL_ENTRY)&_ZN6S661C53v48Ev,
  (VTBL_ENTRY)&_ZN6S661C53v49Ev,
  (VTBL_ENTRY)&_ZN6S661C53v50Ev,
  (VTBL_ENTRY)&_ZN6S661C53v51Ev,
  (VTBL_ENTRY)&_ZN6S661C53v52Ev,
  (VTBL_ENTRY)&_ZN6S661C53v53Ev,
  (VTBL_ENTRY)&_ZN6S661C53v54Ev,
  (VTBL_ENTRY)&_ZN6S661C53v55Ev,
  (VTBL_ENTRY)&_ZN6S661C53v56Ev,
  (VTBL_ENTRY)&_ZN6S661C53v57Ev,
  (VTBL_ENTRY)&_ZN6S661C53v58Ev,
  (VTBL_ENTRY)&_ZN6S661C53v59Ev,
  (VTBL_ENTRY)&_ZN6S661C53v60Ev,
  (VTBL_ENTRY)&_ZN6S661C53v61Ev,
  (VTBL_ENTRY)&_ZN6S661C53v62Ev,
  (VTBL_ENTRY)&_ZN6S661C53v63Ev,
  (VTBL_ENTRY)&_ZN6S661C53v64Ev,
  (VTBL_ENTRY)&_ZN6S661C53v65Ev,
  (VTBL_ENTRY)&_ZN6S661C53v66Ev,
  (VTBL_ENTRY)&_ZN6S661C53v67Ev,
  (VTBL_ENTRY)&_ZN6S661C53v68Ev,
  (VTBL_ENTRY)&_ZN6S661C53v69Ev,
};
extern VTBL_ENTRY _ZTI6S661C5[];
extern  VTBL_ENTRY _ZTV6S661C5[];
Class_Descriptor cd_S661C5 = {  "S661C5", // class name
  0,0,//no base classes
  &(vtc_S661C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S661C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S661C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S661C4  : S661C5 {
  void *s661c4f0;
  ::S235C7_nt s661c4f1;
  virtual  ~S661C4(); // _ZN6S661C4D1Ev
  virtual void  v70(); // _ZN6S661C43v70Ev
  virtual void  v71(); // _ZN6S661C43v71Ev
  virtual void  v72(); // _ZN6S661C43v72Ev
  virtual void  v73(); // _ZN6S661C43v73Ev
  virtual void  v74(); // _ZN6S661C43v74Ev
  S661C4(); // tgen
};
//SIG(-1 S661C4) C1{ BC2{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 Fp FC3}


 S661C4 ::~S661C4(){ note_dtor("S661C4", this);}
void  S661C4 ::v70(){vfunc_called(this, "_ZN6S661C43v70Ev");}
void  S661C4 ::v71(){vfunc_called(this, "_ZN6S661C43v71Ev");}
void  S661C4 ::v72(){vfunc_called(this, "_ZN6S661C43v72Ev");}
void  S661C4 ::v73(){vfunc_called(this, "_ZN6S661C43v73Ev");}
void  S661C4 ::v74(){vfunc_called(this, "_ZN6S661C43v74Ev");}
S661C4 ::S661C4(){ note_ctor("S661C4", this);} // tgen

static void Test_S661C4()
{
  extern Class_Descriptor cd_S661C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,19)];
    init_test(&cd_S661C4, buf);
    S661C4 *dp, &lv = *(dp=new (buf) S661C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,72), "sizeof(S661C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S661C4)");
    check_base_class_offset(lv, (S661C5*), 0, "S661C4");
    check_field_offset(lv, s661c4f0, ABISELECT(96,60), "S661C4.s661c4f0");
    check_field_offset(lv, s661c4f1, ABISELECT(104,64), "S661C4.s661c4f1");
    test_class_info(&lv, &cd_S661C4);
    dp->~S661C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS661C4(Test_S661C4, "S661C4", ABISELECT(112,72));

#else // __cplusplus

extern void _ZN6S661C4C1Ev();
extern void _ZN6S661C4D1Ev();
Name_Map name_map_S661C4[] = {
  NSPAIR(_ZN6S661C4C1Ev),
  NSPAIR(_ZN6S661C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S661C5;
extern VTBL_ENTRY _ZTI6S661C5[];
extern  VTBL_ENTRY _ZTV6S661C5[];
static Base_Class bases_S661C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S661C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S661C4[];
extern void _ZN6S661C4D1Ev();
extern void _ZN6S661C4D0Ev();
extern void _ZN6S661C52v6Ev();
extern void _ZN6S661C52v7Ev();
extern void _ZN6S661C52v8Ev();
extern void _ZN6S661C52v9Ev();
extern void _ZN6S661C53v10Ev();
extern void _ZN6S661C53v11Ev();
extern void _ZN6S661C53v12Ev();
extern void _ZN6S661C53v13Ev();
extern void _ZN6S661C53v14Ev();
extern void _ZN6S661C53v15Ev();
extern void _ZN6S661C53v16Ev();
extern void _ZN6S661C53v17Ev();
extern void _ZN6S661C53v18Ev();
extern void _ZN6S661C53v19Ev();
extern void _ZN6S661C53v20Ev();
extern void _ZN6S661C53v21Ev();
extern void _ZN6S661C53v22Ev();
extern void _ZN6S661C53v23Ev();
extern void _ZN6S661C53v24Ev();
extern void _ZN6S661C53v25Ev();
extern void _ZN6S661C53v26Ev();
extern void _ZN6S661C53v27Ev();
extern void _ZN6S661C53v28Ev();
extern void _ZN6S661C53v29Ev();
extern void _ZN6S661C53v30Ev();
extern void _ZN6S661C53v31Ev();
extern void _ZN6S661C53v32Ev();
extern void _ZN6S661C53v33Ev();
extern void _ZN6S661C53v34Ev();
extern void _ZN6S661C53v35Ev();
extern void _ZN6S661C53v36Ev();
extern void _ZN6S661C53v37Ev();
extern void _ZN6S661C53v38Ev();
extern void _ZN6S661C53v39Ev();
extern void _ZN6S661C53v40Ev();
extern void _ZN6S661C53v41Ev();
extern void _ZN6S661C53v42Ev();
extern void _ZN6S661C53v43Ev();
extern void _ZN6S661C53v44Ev();
extern void _ZN6S661C53v45Ev();
extern void _ZN6S661C53v46Ev();
extern void _ZN6S661C53v47Ev();
extern void _ZN6S661C53v48Ev();
extern void _ZN6S661C53v49Ev();
extern void _ZN6S661C53v50Ev();
extern void _ZN6S661C53v51Ev();
extern void _ZN6S661C53v52Ev();
extern void _ZN6S661C53v53Ev();
extern void _ZN6S661C53v54Ev();
extern void _ZN6S661C53v55Ev();
extern void _ZN6S661C53v56Ev();
extern void _ZN6S661C53v57Ev();
extern void _ZN6S661C53v58Ev();
extern void _ZN6S661C53v59Ev();
extern void _ZN6S661C53v60Ev();
extern void _ZN6S661C53v61Ev();
extern void _ZN6S661C53v62Ev();
extern void _ZN6S661C53v63Ev();
extern void _ZN6S661C53v64Ev();
extern void _ZN6S661C53v65Ev();
extern void _ZN6S661C53v66Ev();
extern void _ZN6S661C53v67Ev();
extern void _ZN6S661C53v68Ev();
extern void _ZN6S661C53v69Ev();
extern void _ZN6S661C43v70Ev();
extern void _ZN6S661C43v71Ev();
extern void _ZN6S661C43v72Ev();
extern void _ZN6S661C43v73Ev();
extern void _ZN6S661C43v74Ev();
static  VTBL_ENTRY vtc_S661C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S661C4[0]),
  (VTBL_ENTRY)&_ZN6S661C4D1Ev,
  (VTBL_ENTRY)&_ZN6S661C4D0Ev,
  (VTBL_ENTRY)&_ZN6S661C52v6Ev,
  (VTBL_ENTRY)&_ZN6S661C52v7Ev,
  (VTBL_ENTRY)&_ZN6S661C52v8Ev,
  (VTBL_ENTRY)&_ZN6S661C52v9Ev,
  (VTBL_ENTRY)&_ZN6S661C53v10Ev,
  (VTBL_ENTRY)&_ZN6S661C53v11Ev,
  (VTBL_ENTRY)&_ZN6S661C53v12Ev,
  (VTBL_ENTRY)&_ZN6S661C53v13Ev,
  (VTBL_ENTRY)&_ZN6S661C53v14Ev,
  (VTBL_ENTRY)&_ZN6S661C53v15Ev,
  (VTBL_ENTRY)&_ZN6S661C53v16Ev,
  (VTBL_ENTRY)&_ZN6S661C53v17Ev,
  (VTBL_ENTRY)&_ZN6S661C53v18Ev,
  (VTBL_ENTRY)&_ZN6S661C53v19Ev,
  (VTBL_ENTRY)&_ZN6S661C53v20Ev,
  (VTBL_ENTRY)&_ZN6S661C53v21Ev,
  (VTBL_ENTRY)&_ZN6S661C53v22Ev,
  (VTBL_ENTRY)&_ZN6S661C53v23Ev,
  (VTBL_ENTRY)&_ZN6S661C53v24Ev,
  (VTBL_ENTRY)&_ZN6S661C53v25Ev,
  (VTBL_ENTRY)&_ZN6S661C53v26Ev,
  (VTBL_ENTRY)&_ZN6S661C53v27Ev,
  (VTBL_ENTRY)&_ZN6S661C53v28Ev,
  (VTBL_ENTRY)&_ZN6S661C53v29Ev,
  (VTBL_ENTRY)&_ZN6S661C53v30Ev,
  (VTBL_ENTRY)&_ZN6S661C53v31Ev,
  (VTBL_ENTRY)&_ZN6S661C53v32Ev,
  (VTBL_ENTRY)&_ZN6S661C53v33Ev,
  (VTBL_ENTRY)&_ZN6S661C53v34Ev,
  (VTBL_ENTRY)&_ZN6S661C53v35Ev,
  (VTBL_ENTRY)&_ZN6S661C53v36Ev,
  (VTBL_ENTRY)&_ZN6S661C53v37Ev,
  (VTBL_ENTRY)&_ZN6S661C53v38Ev,
  (VTBL_ENTRY)&_ZN6S661C53v39Ev,
  (VTBL_ENTRY)&_ZN6S661C53v40Ev,
  (VTBL_ENTRY)&_ZN6S661C53v41Ev,
  (VTBL_ENTRY)&_ZN6S661C53v42Ev,
  (VTBL_ENTRY)&_ZN6S661C53v43Ev,
  (VTBL_ENTRY)&_ZN6S661C53v44Ev,
  (VTBL_ENTRY)&_ZN6S661C53v45Ev,
  (VTBL_ENTRY)&_ZN6S661C53v46Ev,
  (VTBL_ENTRY)&_ZN6S661C53v47Ev,
  (VTBL_ENTRY)&_ZN6S661C53v48Ev,
  (VTBL_ENTRY)&_ZN6S661C53v49Ev,
  (VTBL_ENTRY)&_ZN6S661C53v50Ev,
  (VTBL_ENTRY)&_ZN6S661C53v51Ev,
  (VTBL_ENTRY)&_ZN6S661C53v52Ev,
  (VTBL_ENTRY)&_ZN6S661C53v53Ev,
  (VTBL_ENTRY)&_ZN6S661C53v54Ev,
  (VTBL_ENTRY)&_ZN6S661C53v55Ev,
  (VTBL_ENTRY)&_ZN6S661C53v56Ev,
  (VTBL_ENTRY)&_ZN6S661C53v57Ev,
  (VTBL_ENTRY)&_ZN6S661C53v58Ev,
  (VTBL_ENTRY)&_ZN6S661C53v59Ev,
  (VTBL_ENTRY)&_ZN6S661C53v60Ev,
  (VTBL_ENTRY)&_ZN6S661C53v61Ev,
  (VTBL_ENTRY)&_ZN6S661C53v62Ev,
  (VTBL_ENTRY)&_ZN6S661C53v63Ev,
  (VTBL_ENTRY)&_ZN6S661C53v64Ev,
  (VTBL_ENTRY)&_ZN6S661C53v65Ev,
  (VTBL_ENTRY)&_ZN6S661C53v66Ev,
  (VTBL_ENTRY)&_ZN6S661C53v67Ev,
  (VTBL_ENTRY)&_ZN6S661C53v68Ev,
  (VTBL_ENTRY)&_ZN6S661C53v69Ev,
  (VTBL_ENTRY)&_ZN6S661C43v70Ev,
  (VTBL_ENTRY)&_ZN6S661C43v71Ev,
  (VTBL_ENTRY)&_ZN6S661C43v72Ev,
  (VTBL_ENTRY)&_ZN6S661C43v73Ev,
  (VTBL_ENTRY)&_ZN6S661C43v74Ev,
};
extern VTBL_ENTRY _ZTI6S661C4[];
extern  VTBL_ENTRY _ZTV6S661C4[];
Class_Descriptor cd_S661C4 = {  "S661C4", // class name
  bases_S661C4, 1,
  &(vtc_S661C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,72), // object size
  NSPAIRA(_ZTI6S661C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S661C4),73, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S661C3  : S661C4 {
  void *s661c3f0[2];
  unsigned int s661c3f1:1;
  unsigned int s661c3f2:1;
  unsigned int s661c3f3:1;
  unsigned int s661c3f4:1;
  char s661c3f5;
  virtual  ~S661C3(); // _ZN6S661C3D1Ev
  virtual void  v75(); // _ZN6S661C33v75Ev
  virtual void  v76(); // _ZN6S661C33v76Ev
  virtual void  v77(); // _ZN6S661C33v77Ev
  virtual void  v78(); // _ZN6S661C33v78Ev
  virtual void  v79(); // _ZN6S661C33v79Ev
  virtual void  v80(); // _ZN6S661C33v80Ev
  virtual void  v81(); // _ZN6S661C33v81Ev
  virtual void  v82(); // _ZN6S661C33v82Ev
  virtual void  v83(); // _ZN6S661C33v83Ev
  virtual void  v84(); // _ZN6S661C33v84Ev
  virtual void  v85(); // _ZN6S661C33v85Ev
  virtual void  v86(); // _ZN6S661C33v86Ev
  virtual void  v87(); // _ZN6S661C33v87Ev
  virtual void  v88(); // _ZN6S661C33v88Ev
  virtual void  v89(); // _ZN6S661C33v89Ev
  virtual void  v90(); // _ZN6S661C33v90Ev
  virtual void  v91(); // _ZN6S661C33v91Ev
  virtual void  v92(); // _ZN6S661C33v92Ev
  virtual void  v93(); // _ZN6S661C33v93Ev
  virtual void  v94(); // _ZN6S661C33v94Ev
  virtual void  v95(); // _ZN6S661C33v95Ev
  virtual void  v96(); // _ZN6S661C33v96Ev
  S661C3(); // tgen
};
//SIG(-1 S661C3) C1{ BC2{ BC3{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v87 v88 v89 v90 v91 Fp FC4} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc}


 S661C3 ::~S661C3(){ note_dtor("S661C3", this);}
void  S661C3 ::v75(){vfunc_called(this, "_ZN6S661C33v75Ev");}
void  S661C3 ::v76(){vfunc_called(this, "_ZN6S661C33v76Ev");}
void  S661C3 ::v77(){vfunc_called(this, "_ZN6S661C33v77Ev");}
void  S661C3 ::v78(){vfunc_called(this, "_ZN6S661C33v78Ev");}
void  S661C3 ::v79(){vfunc_called(this, "_ZN6S661C33v79Ev");}
void  S661C3 ::v80(){vfunc_called(this, "_ZN6S661C33v80Ev");}
void  S661C3 ::v81(){vfunc_called(this, "_ZN6S661C33v81Ev");}
void  S661C3 ::v82(){vfunc_called(this, "_ZN6S661C33v82Ev");}
void  S661C3 ::v83(){vfunc_called(this, "_ZN6S661C33v83Ev");}
void  S661C3 ::v84(){vfunc_called(this, "_ZN6S661C33v84Ev");}
void  S661C3 ::v85(){vfunc_called(this, "_ZN6S661C33v85Ev");}
void  S661C3 ::v86(){vfunc_called(this, "_ZN6S661C33v86Ev");}
void  S661C3 ::v87(){vfunc_called(this, "_ZN6S661C33v87Ev");}
void  S661C3 ::v88(){vfunc_called(this, "_ZN6S661C33v88Ev");}
void  S661C3 ::v89(){vfunc_called(this, "_ZN6S661C33v89Ev");}
void  S661C3 ::v90(){vfunc_called(this, "_ZN6S661C33v90Ev");}
void  S661C3 ::v91(){vfunc_called(this, "_ZN6S661C33v91Ev");}
void  S661C3 ::v92(){vfunc_called(this, "_ZN6S661C33v92Ev");}
void  S661C3 ::v93(){vfunc_called(this, "_ZN6S661C33v93Ev");}
void  S661C3 ::v94(){vfunc_called(this, "_ZN6S661C33v94Ev");}
void  S661C3 ::v95(){vfunc_called(this, "_ZN6S661C33v95Ev");}
void  S661C3 ::v96(){vfunc_called(this, "_ZN6S661C33v96Ev");}
S661C3 ::S661C3(){ note_ctor("S661C3", this);} // tgen

static void Test_S661C3()
{
  extern Class_Descriptor cd_S661C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,22)];
    init_test(&cd_S661C3, buf);
    S661C3 *dp, &lv = *(dp=new (buf) S661C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,84), "sizeof(S661C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S661C3)");
    check_base_class_offset(lv, (S661C5*)(S661C4*), 0, "S661C3");
    check_base_class_offset(lv, (S661C4*), 0, "S661C3");
    check_field_offset(lv, s661c3f0, ABISELECT(112,72), "S661C3.s661c3f0");
    set_bf_and_test(lv, s661c3f1, ABISELECT(128,80), 0, 1, 1, "S661C3");
    set_bf_and_test(lv, s661c3f2, ABISELECT(128,80), 1, 1, 1, "S661C3");
    set_bf_and_test(lv, s661c3f3, ABISELECT(128,80), 2, 1, 1, "S661C3");
    set_bf_and_test(lv, s661c3f4, ABISELECT(128,80), 3, 1, 1, "S661C3");
    check_field_offset(lv, s661c3f5, ABISELECT(129,81), "S661C3.s661c3f5");
    test_class_info(&lv, &cd_S661C3);
    dp->~S661C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS661C3(Test_S661C3, "S661C3", ABISELECT(136,84));

#else // __cplusplus

extern void _ZN6S661C3C1Ev();
extern void _ZN6S661C3D1Ev();
Name_Map name_map_S661C3[] = {
  NSPAIR(_ZN6S661C3C1Ev),
  NSPAIR(_ZN6S661C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S661C5;
extern VTBL_ENTRY _ZTI6S661C5[];
extern  VTBL_ENTRY _ZTV6S661C5[];
extern Class_Descriptor cd_S661C4;
extern VTBL_ENTRY _ZTI6S661C4[];
extern  VTBL_ENTRY _ZTV6S661C4[];
static Base_Class bases_S661C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S661C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S661C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S661C3[];
extern void _ZN6S661C3D1Ev();
extern void _ZN6S661C3D0Ev();
extern void _ZN6S661C52v6Ev();
extern void _ZN6S661C52v7Ev();
extern void _ZN6S661C52v8Ev();
extern void _ZN6S661C52v9Ev();
extern void _ZN6S661C53v10Ev();
extern void _ZN6S661C53v11Ev();
extern void _ZN6S661C53v12Ev();
extern void _ZN6S661C53v13Ev();
extern void _ZN6S661C53v14Ev();
extern void _ZN6S661C53v15Ev();
extern void _ZN6S661C53v16Ev();
extern void _ZN6S661C53v17Ev();
extern void _ZN6S661C53v18Ev();
extern void _ZN6S661C53v19Ev();
extern void _ZN6S661C53v20Ev();
extern void _ZN6S661C53v21Ev();
extern void _ZN6S661C53v22Ev();
extern void _ZN6S661C53v23Ev();
extern void _ZN6S661C53v24Ev();
extern void _ZN6S661C53v25Ev();
extern void _ZN6S661C53v26Ev();
extern void _ZN6S661C53v27Ev();
extern void _ZN6S661C53v28Ev();
extern void _ZN6S661C53v29Ev();
extern void _ZN6S661C53v30Ev();
extern void _ZN6S661C53v31Ev();
extern void _ZN6S661C53v32Ev();
extern void _ZN6S661C53v33Ev();
extern void _ZN6S661C53v34Ev();
extern void _ZN6S661C53v35Ev();
extern void _ZN6S661C53v36Ev();
extern void _ZN6S661C53v37Ev();
extern void _ZN6S661C53v38Ev();
extern void _ZN6S661C53v39Ev();
extern void _ZN6S661C53v40Ev();
extern void _ZN6S661C53v41Ev();
extern void _ZN6S661C53v42Ev();
extern void _ZN6S661C53v43Ev();
extern void _ZN6S661C53v44Ev();
extern void _ZN6S661C53v45Ev();
extern void _ZN6S661C53v46Ev();
extern void _ZN6S661C53v47Ev();
extern void _ZN6S661C53v48Ev();
extern void _ZN6S661C53v49Ev();
extern void _ZN6S661C53v50Ev();
extern void _ZN6S661C53v51Ev();
extern void _ZN6S661C53v52Ev();
extern void _ZN6S661C53v53Ev();
extern void _ZN6S661C53v54Ev();
extern void _ZN6S661C53v55Ev();
extern void _ZN6S661C53v56Ev();
extern void _ZN6S661C53v57Ev();
extern void _ZN6S661C53v58Ev();
extern void _ZN6S661C53v59Ev();
extern void _ZN6S661C53v60Ev();
extern void _ZN6S661C53v61Ev();
extern void _ZN6S661C53v62Ev();
extern void _ZN6S661C53v63Ev();
extern void _ZN6S661C53v64Ev();
extern void _ZN6S661C53v65Ev();
extern void _ZN6S661C53v66Ev();
extern void _ZN6S661C53v67Ev();
extern void _ZN6S661C53v68Ev();
extern void _ZN6S661C53v69Ev();
extern void _ZN6S661C43v70Ev();
extern void _ZN6S661C43v71Ev();
extern void _ZN6S661C43v72Ev();
extern void _ZN6S661C43v73Ev();
extern void _ZN6S661C43v74Ev();
extern void _ZN6S661C33v75Ev();
extern void _ZN6S661C33v76Ev();
extern void _ZN6S661C33v77Ev();
extern void _ZN6S661C33v78Ev();
extern void _ZN6S661C33v79Ev();
extern void _ZN6S661C33v80Ev();
extern void _ZN6S661C33v81Ev();
extern void _ZN6S661C33v82Ev();
extern void _ZN6S661C33v83Ev();
extern void _ZN6S661C33v84Ev();
extern void _ZN6S661C33v85Ev();
extern void _ZN6S661C33v86Ev();
extern void _ZN6S661C33v87Ev();
extern void _ZN6S661C33v88Ev();
extern void _ZN6S661C33v89Ev();
extern void _ZN6S661C33v90Ev();
extern void _ZN6S661C33v91Ev();
extern void _ZN6S661C33v92Ev();
extern void _ZN6S661C33v93Ev();
extern void _ZN6S661C33v94Ev();
extern void _ZN6S661C33v95Ev();
extern void _ZN6S661C33v96Ev();
static  VTBL_ENTRY vtc_S661C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S661C3[0]),
  (VTBL_ENTRY)&_ZN6S661C3D1Ev,
  (VTBL_ENTRY)&_ZN6S661C3D0Ev,
  (VTBL_ENTRY)&_ZN6S661C52v6Ev,
  (VTBL_ENTRY)&_ZN6S661C52v7Ev,
  (VTBL_ENTRY)&_ZN6S661C52v8Ev,
  (VTBL_ENTRY)&_ZN6S661C52v9Ev,
  (VTBL_ENTRY)&_ZN6S661C53v10Ev,
  (VTBL_ENTRY)&_ZN6S661C53v11Ev,
  (VTBL_ENTRY)&_ZN6S661C53v12Ev,
  (VTBL_ENTRY)&_ZN6S661C53v13Ev,
  (VTBL_ENTRY)&_ZN6S661C53v14Ev,
  (VTBL_ENTRY)&_ZN6S661C53v15Ev,
  (VTBL_ENTRY)&_ZN6S661C53v16Ev,
  (VTBL_ENTRY)&_ZN6S661C53v17Ev,
  (VTBL_ENTRY)&_ZN6S661C53v18Ev,
  (VTBL_ENTRY)&_ZN6S661C53v19Ev,
  (VTBL_ENTRY)&_ZN6S661C53v20Ev,
  (VTBL_ENTRY)&_ZN6S661C53v21Ev,
  (VTBL_ENTRY)&_ZN6S661C53v22Ev,
  (VTBL_ENTRY)&_ZN6S661C53v23Ev,
  (VTBL_ENTRY)&_ZN6S661C53v24Ev,
  (VTBL_ENTRY)&_ZN6S661C53v25Ev,
  (VTBL_ENTRY)&_ZN6S661C53v26Ev,
  (VTBL_ENTRY)&_ZN6S661C53v27Ev,
  (VTBL_ENTRY)&_ZN6S661C53v28Ev,
  (VTBL_ENTRY)&_ZN6S661C53v29Ev,
  (VTBL_ENTRY)&_ZN6S661C53v30Ev,
  (VTBL_ENTRY)&_ZN6S661C53v31Ev,
  (VTBL_ENTRY)&_ZN6S661C53v32Ev,
  (VTBL_ENTRY)&_ZN6S661C53v33Ev,
  (VTBL_ENTRY)&_ZN6S661C53v34Ev,
  (VTBL_ENTRY)&_ZN6S661C53v35Ev,
  (VTBL_ENTRY)&_ZN6S661C53v36Ev,
  (VTBL_ENTRY)&_ZN6S661C53v37Ev,
  (VTBL_ENTRY)&_ZN6S661C53v38Ev,
  (VTBL_ENTRY)&_ZN6S661C53v39Ev,
  (VTBL_ENTRY)&_ZN6S661C53v40Ev,
  (VTBL_ENTRY)&_ZN6S661C53v41Ev,
  (VTBL_ENTRY)&_ZN6S661C53v42Ev,
  (VTBL_ENTRY)&_ZN6S661C53v43Ev,
  (VTBL_ENTRY)&_ZN6S661C53v44Ev,
  (VTBL_ENTRY)&_ZN6S661C53v45Ev,
  (VTBL_ENTRY)&_ZN6S661C53v46Ev,
  (VTBL_ENTRY)&_ZN6S661C53v47Ev,
  (VTBL_ENTRY)&_ZN6S661C53v48Ev,
  (VTBL_ENTRY)&_ZN6S661C53v49Ev,
  (VTBL_ENTRY)&_ZN6S661C53v50Ev,
  (VTBL_ENTRY)&_ZN6S661C53v51Ev,
  (VTBL_ENTRY)&_ZN6S661C53v52Ev,
  (VTBL_ENTRY)&_ZN6S661C53v53Ev,
  (VTBL_ENTRY)&_ZN6S661C53v54Ev,
  (VTBL_ENTRY)&_ZN6S661C53v55Ev,
  (VTBL_ENTRY)&_ZN6S661C53v56Ev,
  (VTBL_ENTRY)&_ZN6S661C53v57Ev,
  (VTBL_ENTRY)&_ZN6S661C53v58Ev,
  (VTBL_ENTRY)&_ZN6S661C53v59Ev,
  (VTBL_ENTRY)&_ZN6S661C53v60Ev,
  (VTBL_ENTRY)&_ZN6S661C53v61Ev,
  (VTBL_ENTRY)&_ZN6S661C53v62Ev,
  (VTBL_ENTRY)&_ZN6S661C53v63Ev,
  (VTBL_ENTRY)&_ZN6S661C53v64Ev,
  (VTBL_ENTRY)&_ZN6S661C53v65Ev,
  (VTBL_ENTRY)&_ZN6S661C53v66Ev,
  (VTBL_ENTRY)&_ZN6S661C53v67Ev,
  (VTBL_ENTRY)&_ZN6S661C53v68Ev,
  (VTBL_ENTRY)&_ZN6S661C53v69Ev,
  (VTBL_ENTRY)&_ZN6S661C43v70Ev,
  (VTBL_ENTRY)&_ZN6S661C43v71Ev,
  (VTBL_ENTRY)&_ZN6S661C43v72Ev,
  (VTBL_ENTRY)&_ZN6S661C43v73Ev,
  (VTBL_ENTRY)&_ZN6S661C43v74Ev,
  (VTBL_ENTRY)&_ZN6S661C33v75Ev,
  (VTBL_ENTRY)&_ZN6S661C33v76Ev,
  (VTBL_ENTRY)&_ZN6S661C33v77Ev,
  (VTBL_ENTRY)&_ZN6S661C33v78Ev,
  (VTBL_ENTRY)&_ZN6S661C33v79Ev,
  (VTBL_ENTRY)&_ZN6S661C33v80Ev,
  (VTBL_ENTRY)&_ZN6S661C33v81Ev,
  (VTBL_ENTRY)&_ZN6S661C33v82Ev,
  (VTBL_ENTRY)&_ZN6S661C33v83Ev,
  (VTBL_ENTRY)&_ZN6S661C33v84Ev,
  (VTBL_ENTRY)&_ZN6S661C33v85Ev,
  (VTBL_ENTRY)&_ZN6S661C33v86Ev,
  (VTBL_ENTRY)&_ZN6S661C33v87Ev,
  (VTBL_ENTRY)&_ZN6S661C33v88Ev,
  (VTBL_ENTRY)&_ZN6S661C33v89Ev,
  (VTBL_ENTRY)&_ZN6S661C33v90Ev,
  (VTBL_ENTRY)&_ZN6S661C33v91Ev,
  (VTBL_ENTRY)&_ZN6S661C33v92Ev,
  (VTBL_ENTRY)&_ZN6S661C33v93Ev,
  (VTBL_ENTRY)&_ZN6S661C33v94Ev,
  (VTBL_ENTRY)&_ZN6S661C33v95Ev,
  (VTBL_ENTRY)&_ZN6S661C33v96Ev,
};
extern VTBL_ENTRY _ZTI6S661C3[];
extern  VTBL_ENTRY _ZTV6S661C3[];
Class_Descriptor cd_S661C3 = {  "S661C3", // class name
  bases_S661C3, 2,
  &(vtc_S661C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,84), // object size
  NSPAIRA(_ZTI6S661C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S661C3),95, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S661C2  : S661C3 {
  void *s661c2f0;
  ::S836C39 s661c2f1;
  ::S836C39 s661c2f2;
  ::S285C19 s661c2f3;
  ::S285C19 s661c2f4;
  int s661c2f5;
  ::S836C29 s661c2f6;
  void *s661c2f7;
  unsigned int s661c2f8:1;
  unsigned int s661c2f9:1;
  unsigned int s661c2f10:1;
  unsigned int s661c2f11:1;
  unsigned int s661c2f12:1;
  unsigned int s661c2f13:1;
  unsigned int s661c2f14:1;
  unsigned int s661c2f15:1;
  unsigned int s661c2f16:1;
  unsigned int s661c2f17:1;
  unsigned int s661c2f18:1;
  void *s661c2f19;
  ::S285C17 s661c2f20;
  ::S836C25 s661c2f21;
  unsigned int s661c2f22:1;
  ::S235C17 s661c2f23;
  ::S235C17 s661c2f24;
  ::S235C11_nt s661c2f25;
  ::S235C11_nt s661c2f26;
  char s661c2f27[2];
  ::S235C9_nt s661c2f28;
  int s661c2f29[3];
  char s661c2f30[2];
  int s661c2f31[2];
  virtual  ~S661C2(); // _ZN6S661C2D1Ev
  virtual void  v97(); // _ZN6S661C23v97Ev
  virtual void  v98(); // _ZN6S661C23v98Ev
  virtual void  v99(); // _ZN6S661C23v99Ev
  virtual void  v100(); // _ZN6S661C24v100Ev
  virtual void  v101(); // _ZN6S661C24v101Ev
  virtual void  v102(); // _ZN6S661C24v102Ev
  virtual void  v103(); // _ZN6S661C24v103Ev
  virtual void  v104(); // _ZN6S661C24v104Ev
  virtual void  v105(); // _ZN6S661C24v105Ev
  virtual void  v106(); // _ZN6S661C24v106Ev
  virtual void  v107(); // _ZN6S661C24v107Ev
  virtual void  v108(); // _ZN6S661C24v108Ev
  virtual void  v109(); // _ZN6S661C24v109Ev
  virtual void  v110(); // _ZN6S661C24v110Ev
  virtual void  v111(); // _ZN6S661C24v111Ev
  virtual void  v112(); // _ZN6S661C24v112Ev
  virtual void  v113(); // _ZN6S661C24v113Ev
  virtual void  v114(); // _ZN6S661C24v114Ev
  virtual void  v115(); // _ZN6S661C24v115Ev
  virtual void  v116(); // _ZN6S661C24v116Ev
  virtual void  v117(); // _ZN6S661C24v117Ev
  virtual void  v118(); // _ZN6S661C24v118Ev
  virtual void  v119(); // _ZN6S661C24v119Ev
  virtual void  v120(); // _ZN6S661C24v120Ev
  virtual void  v121(); // _ZN6S661C24v121Ev
  virtual void  v122(); // _ZN6S661C24v122Ev
  virtual void  v123(); // _ZN6S661C24v123Ev
  S661C2(); // tgen
};
//SIG(-1 S661C2) C1{ BC2{ BC3{ BC4{ vd v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v92 v93 v94 v95 v96 Fp FC5} vd v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 Fp FC6{ m} FC6 FC7{ m Fi[4]} FC7 Fi FC8{ m} Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp FC9{ BC10{ BC11{ m Fp Fi[2]}}} FC12{ m} Fi:1 FC13{ BC14{ BC11}} FC13 FC15{ BC16{ BC11}} FC15 Fc[2] FC17{ m Fi[4]} Fi[3] Fc[2] Fi[2]}


 S661C2 ::~S661C2(){ note_dtor("S661C2", this);}
void  S661C2 ::v97(){vfunc_called(this, "_ZN6S661C23v97Ev");}
void  S661C2 ::v98(){vfunc_called(this, "_ZN6S661C23v98Ev");}
void  S661C2 ::v99(){vfunc_called(this, "_ZN6S661C23v99Ev");}
void  S661C2 ::v100(){vfunc_called(this, "_ZN6S661C24v100Ev");}
void  S661C2 ::v101(){vfunc_called(this, "_ZN6S661C24v101Ev");}
void  S661C2 ::v102(){vfunc_called(this, "_ZN6S661C24v102Ev");}
void  S661C2 ::v103(){vfunc_called(this, "_ZN6S661C24v103Ev");}
void  S661C2 ::v104(){vfunc_called(this, "_ZN6S661C24v104Ev");}
void  S661C2 ::v105(){vfunc_called(this, "_ZN6S661C24v105Ev");}
void  S661C2 ::v106(){vfunc_called(this, "_ZN6S661C24v106Ev");}
void  S661C2 ::v107(){vfunc_called(this, "_ZN6S661C24v107Ev");}
void  S661C2 ::v108(){vfunc_called(this, "_ZN6S661C24v108Ev");}
void  S661C2 ::v109(){vfunc_called(this, "_ZN6S661C24v109Ev");}
void  S661C2 ::v110(){vfunc_called(this, "_ZN6S661C24v110Ev");}
void  S661C2 ::v111(){vfunc_called(this, "_ZN6S661C24v111Ev");}
void  S661C2 ::v112(){vfunc_called(this, "_ZN6S661C24v112Ev");}
void  S661C2 ::v113(){vfunc_called(this, "_ZN6S661C24v113Ev");}
void  S661C2 ::v114(){vfunc_called(this, "_ZN6S661C24v114Ev");}
void  S661C2 ::v115(){vfunc_called(this, "_ZN6S661C24v115Ev");}
void  S661C2 ::v116(){vfunc_called(this, "_ZN6S661C24v116Ev");}
void  S661C2 ::v117(){vfunc_called(this, "_ZN6S661C24v117Ev");}
void  S661C2 ::v118(){vfunc_called(this, "_ZN6S661C24v118Ev");}
void  S661C2 ::v119(){vfunc_called(this, "_ZN6S661C24v119Ev");}
void  S661C2 ::v120(){vfunc_called(this, "_ZN6S661C24v120Ev");}
void  S661C2 ::v121(){vfunc_called(this, "_ZN6S661C24v121Ev");}
void  S661C2 ::v122(){vfunc_called(this, "_ZN6S661C24v122Ev");}
void  S661C2 ::v123(){vfunc_called(this, "_ZN6S661C24v123Ev");}
S661C2 ::S661C2(){ note_ctor("S661C2", this);} // tgen

static void Test_S661C2()
{
  extern Class_Descriptor cd_S661C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(45,64)];
    init_test(&cd_S661C2, buf);
    S661C2 *dp, &lv = *(dp=new (buf) S661C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(352,252), "sizeof(S661C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S661C2)");
    check_base_class_offset(lv, (S661C5*)(S661C4*)(S661C3*), 0, "S661C2");
    check_base_class_offset(lv, (S661C4*)(S661C3*), 0, "S661C2");
    check_base_class_offset(lv, (S661C3*), 0, "S661C2");
    check_field_offset(lv, s661c2f0, ABISELECT(136,84), "S661C2.s661c2f0");
    check_field_offset(lv, s661c2f1, ABISELECT(144,88), "S661C2.s661c2f1");
    check_field_offset(lv, s661c2f2, ABISELECT(145,89), "S661C2.s661c2f2");
    check_field_offset(lv, s661c2f3, ABISELECT(148,92), "S661C2.s661c2f3");
    check_field_offset(lv, s661c2f4, ABISELECT(164,108), "S661C2.s661c2f4");
    check_field_offset(lv, s661c2f5, ABISELECT(180,124), "S661C2.s661c2f5");
    check_field_offset(lv, s661c2f6, ABISELECT(184,128), "S661C2.s661c2f6");
    check_field_offset(lv, s661c2f7, ABISELECT(192,132), "S661C2.s661c2f7");
    set_bf_and_test(lv, s661c2f8, ABISELECT(200,136), 0, 1, 1, "S661C2");
    set_bf_and_test(lv, s661c2f9, ABISELECT(200,136), 1, 1, 1, "S661C2");
    set_bf_and_test(lv, s661c2f10, ABISELECT(200,136), 2, 1, 1, "S661C2");
    set_bf_and_test(lv, s661c2f11, ABISELECT(200,136), 3, 1, 1, "S661C2");
    set_bf_and_test(lv, s661c2f12, ABISELECT(200,136), 4, 1, 1, "S661C2");
    set_bf_and_test(lv, s661c2f13, ABISELECT(200,136), 5, 1, 1, "S661C2");
    set_bf_and_test(lv, s661c2f14, ABISELECT(200,136), 6, 1, 1, "S661C2");
    set_bf_and_test(lv, s661c2f15, ABISELECT(200,136), 7, 1, 1, "S661C2");
    set_bf_and_test(lv, s661c2f16, ABISELECT(201,137), 0, 1, 1, "S661C2");
    set_bf_and_test(lv, s661c2f17, ABISELECT(201,137), 1, 1, 1, "S661C2");
    set_bf_and_test(lv, s661c2f18, ABISELECT(201,137), 2, 1, 1, "S661C2");
    check_field_offset(lv, s661c2f19, ABISELECT(208,140), "S661C2.s661c2f19");
    check_field_offset(lv, s661c2f20, ABISELECT(216,144), "S661C2.s661c2f20");
    check_field_offset(lv, s661c2f21, ABISELECT(232,156), "S661C2.s661c2f21");
    set_bf_and_test(lv, s661c2f22, ABISELECT(233,157), 0, 1, 1, "S661C2");
    check_field_offset(lv, s661c2f23, ABISELECT(240,160), "S661C2.s661c2f23");
    check_field_offset(lv, s661c2f24, ABISELECT(256,172), "S661C2.s661c2f24");
    check_field_offset(lv, s661c2f25, ABISELECT(272,184), "S661C2.s661c2f25");
    check_field_offset(lv, s661c2f26, ABISELECT(288,196), "S661C2.s661c2f26");
    check_field_offset(lv, s661c2f27, ABISELECT(304,208), "S661C2.s661c2f27");
    check_field_offset(lv, s661c2f28, ABISELECT(308,212), "S661C2.s661c2f28");
    check_field_offset(lv, s661c2f29, ABISELECT(324,228), "S661C2.s661c2f29");
    check_field_offset(lv, s661c2f30, ABISELECT(336,240), "S661C2.s661c2f30");
    check_field_offset(lv, s661c2f31, ABISELECT(340,244), "S661C2.s661c2f31");
    test_class_info(&lv, &cd_S661C2);
    dp->~S661C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS661C2(Test_S661C2, "S661C2", ABISELECT(352,252));

#else // __cplusplus

extern void _ZN6S661C2C1Ev();
extern void _ZN6S661C2D1Ev();
Name_Map name_map_S661C2[] = {
  NSPAIR(_ZN6S661C2C1Ev),
  NSPAIR(_ZN6S661C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S661C5;
extern VTBL_ENTRY _ZTI6S661C5[];
extern  VTBL_ENTRY _ZTV6S661C5[];
extern Class_Descriptor cd_S661C4;
extern VTBL_ENTRY _ZTI6S661C4[];
extern  VTBL_ENTRY _ZTV6S661C4[];
extern Class_Descriptor cd_S661C3;
extern VTBL_ENTRY _ZTI6S661C3[];
extern  VTBL_ENTRY _ZTV6S661C3[];
static Base_Class bases_S661C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S661C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S661C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S661C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S661C2[];
extern void _ZN6S661C2D1Ev();
extern void _ZN6S661C2D0Ev();
extern void _ZN6S661C52v6Ev();
extern void _ZN6S661C52v7Ev();
extern void _ZN6S661C52v8Ev();
extern void _ZN6S661C52v9Ev();
extern void _ZN6S661C53v10Ev();
extern void _ZN6S661C53v11Ev();
extern void _ZN6S661C53v12Ev();
extern void _ZN6S661C53v13Ev();
extern void _ZN6S661C53v14Ev();
extern void _ZN6S661C53v15Ev();
extern void _ZN6S661C53v16Ev();
extern void _ZN6S661C53v17Ev();
extern void _ZN6S661C53v18Ev();
extern void _ZN6S661C53v19Ev();
extern void _ZN6S661C53v20Ev();
extern void _ZN6S661C53v21Ev();
extern void _ZN6S661C53v22Ev();
extern void _ZN6S661C53v23Ev();
extern void _ZN6S661C53v24Ev();
extern void _ZN6S661C53v25Ev();
extern void _ZN6S661C53v26Ev();
extern void _ZN6S661C53v27Ev();
extern void _ZN6S661C53v28Ev();
extern void _ZN6S661C53v29Ev();
extern void _ZN6S661C53v30Ev();
extern void _ZN6S661C53v31Ev();
extern void _ZN6S661C53v32Ev();
extern void _ZN6S661C53v33Ev();
extern void _ZN6S661C53v34Ev();
extern void _ZN6S661C53v35Ev();
extern void _ZN6S661C53v36Ev();
extern void _ZN6S661C53v37Ev();
extern void _ZN6S661C53v38Ev();
extern void _ZN6S661C53v39Ev();
extern void _ZN6S661C53v40Ev();
extern void _ZN6S661C53v41Ev();
extern void _ZN6S661C53v42Ev();
extern void _ZN6S661C53v43Ev();
extern void _ZN6S661C53v44Ev();
extern void _ZN6S661C53v45Ev();
extern void _ZN6S661C53v46Ev();
extern void _ZN6S661C53v47Ev();
extern void _ZN6S661C53v48Ev();
extern void _ZN6S661C53v49Ev();
extern void _ZN6S661C53v50Ev();
extern void _ZN6S661C53v51Ev();
extern void _ZN6S661C53v52Ev();
extern void _ZN6S661C53v53Ev();
extern void _ZN6S661C53v54Ev();
extern void _ZN6S661C53v55Ev();
extern void _ZN6S661C53v56Ev();
extern void _ZN6S661C53v57Ev();
extern void _ZN6S661C53v58Ev();
extern void _ZN6S661C53v59Ev();
extern void _ZN6S661C53v60Ev();
extern void _ZN6S661C53v61Ev();
extern void _ZN6S661C53v62Ev();
extern void _ZN6S661C53v63Ev();
extern void _ZN6S661C53v64Ev();
extern void _ZN6S661C53v65Ev();
extern void _ZN6S661C53v66Ev();
extern void _ZN6S661C53v67Ev();
extern void _ZN6S661C53v68Ev();
extern void _ZN6S661C53v69Ev();
extern void _ZN6S661C43v70Ev();
extern void _ZN6S661C43v71Ev();
extern void _ZN6S661C43v72Ev();
extern void _ZN6S661C43v73Ev();
extern void _ZN6S661C43v74Ev();
extern void _ZN6S661C33v75Ev();
extern void _ZN6S661C33v76Ev();
extern void _ZN6S661C33v77Ev();
extern void _ZN6S661C33v78Ev();
extern void _ZN6S661C33v79Ev();
extern void _ZN6S661C33v80Ev();
extern void _ZN6S661C33v81Ev();
extern void _ZN6S661C33v82Ev();
extern void _ZN6S661C33v83Ev();
extern void _ZN6S661C33v84Ev();
extern void _ZN6S661C33v85Ev();
extern void _ZN6S661C33v86Ev();
extern void _ZN6S661C33v87Ev();
extern void _ZN6S661C33v88Ev();
extern void _ZN6S661C33v89Ev();
extern void _ZN6S661C33v90Ev();
extern void _ZN6S661C33v91Ev();
extern void _ZN6S661C33v92Ev();
extern void _ZN6S661C33v93Ev();
extern void _ZN6S661C33v94Ev();
extern void _ZN6S661C33v95Ev();
extern void _ZN6S661C33v96Ev();
extern void _ZN6S661C23v97Ev();
extern void _ZN6S661C23v98Ev();
extern void _ZN6S661C23v99Ev();
extern void _ZN6S661C24v100Ev();
extern void _ZN6S661C24v101Ev();
extern void _ZN6S661C24v102Ev();
extern void _ZN6S661C24v103Ev();
extern void _ZN6S661C24v104Ev();
extern void _ZN6S661C24v105Ev();
extern void _ZN6S661C24v106Ev();
extern void _ZN6S661C24v107Ev();
extern void _ZN6S661C24v108Ev();
extern void _ZN6S661C24v109Ev();
extern void _ZN6S661C24v110Ev();
extern void _ZN6S661C24v111Ev();
extern void _ZN6S661C24v112Ev();
extern void _ZN6S661C24v113Ev();
extern void _ZN6S661C24v114Ev();
extern void _ZN6S661C24v115Ev();
extern void _ZN6S661C24v116Ev();
extern void _ZN6S661C24v117Ev();
extern void _ZN6S661C24v118Ev();
extern void _ZN6S661C24v119Ev();
extern void _ZN6S661C24v120Ev();
extern void _ZN6S661C24v121Ev();
extern void _ZN6S661C24v122Ev();
extern void _ZN6S661C24v123Ev();
static  VTBL_ENTRY vtc_S661C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S661C2[0]),
  (VTBL_ENTRY)&_ZN6S661C2D1Ev,
  (VTBL_ENTRY)&_ZN6S661C2D0Ev,
  (VTBL_ENTRY)&_ZN6S661C52v6Ev,
  (VTBL_ENTRY)&_ZN6S661C52v7Ev,
  (VTBL_ENTRY)&_ZN6S661C52v8Ev,
  (VTBL_ENTRY)&_ZN6S661C52v9Ev,
  (VTBL_ENTRY)&_ZN6S661C53v10Ev,
  (VTBL_ENTRY)&_ZN6S661C53v11Ev,
  (VTBL_ENTRY)&_ZN6S661C53v12Ev,
  (VTBL_ENTRY)&_ZN6S661C53v13Ev,
  (VTBL_ENTRY)&_ZN6S661C53v14Ev,
  (VTBL_ENTRY)&_ZN6S661C53v15Ev,
  (VTBL_ENTRY)&_ZN6S661C53v16Ev,
  (VTBL_ENTRY)&_ZN6S661C53v17Ev,
  (VTBL_ENTRY)&_ZN6S661C53v18Ev,
  (VTBL_ENTRY)&_ZN6S661C53v19Ev,
  (VTBL_ENTRY)&_ZN6S661C53v20Ev,
  (VTBL_ENTRY)&_ZN6S661C53v21Ev,
  (VTBL_ENTRY)&_ZN6S661C53v22Ev,
  (VTBL_ENTRY)&_ZN6S661C53v23Ev,
  (VTBL_ENTRY)&_ZN6S661C53v24Ev,
  (VTBL_ENTRY)&_ZN6S661C53v25Ev,
  (VTBL_ENTRY)&_ZN6S661C53v26Ev,
  (VTBL_ENTRY)&_ZN6S661C53v27Ev,
  (VTBL_ENTRY)&_ZN6S661C53v28Ev,
  (VTBL_ENTRY)&_ZN6S661C53v29Ev,
  (VTBL_ENTRY)&_ZN6S661C53v30Ev,
  (VTBL_ENTRY)&_ZN6S661C53v31Ev,
  (VTBL_ENTRY)&_ZN6S661C53v32Ev,
  (VTBL_ENTRY)&_ZN6S661C53v33Ev,
  (VTBL_ENTRY)&_ZN6S661C53v34Ev,
  (VTBL_ENTRY)&_ZN6S661C53v35Ev,
  (VTBL_ENTRY)&_ZN6S661C53v36Ev,
  (VTBL_ENTRY)&_ZN6S661C53v37Ev,
  (VTBL_ENTRY)&_ZN6S661C53v38Ev,
  (VTBL_ENTRY)&_ZN6S661C53v39Ev,
  (VTBL_ENTRY)&_ZN6S661C53v40Ev,
  (VTBL_ENTRY)&_ZN6S661C53v41Ev,
  (VTBL_ENTRY)&_ZN6S661C53v42Ev,
  (VTBL_ENTRY)&_ZN6S661C53v43Ev,
  (VTBL_ENTRY)&_ZN6S661C53v44Ev,
  (VTBL_ENTRY)&_ZN6S661C53v45Ev,
  (VTBL_ENTRY)&_ZN6S661C53v46Ev,
  (VTBL_ENTRY)&_ZN6S661C53v47Ev,
  (VTBL_ENTRY)&_ZN6S661C53v48Ev,
  (VTBL_ENTRY)&_ZN6S661C53v49Ev,
  (VTBL_ENTRY)&_ZN6S661C53v50Ev,
  (VTBL_ENTRY)&_ZN6S661C53v51Ev,
  (VTBL_ENTRY)&_ZN6S661C53v52Ev,
  (VTBL_ENTRY)&_ZN6S661C53v53Ev,
  (VTBL_ENTRY)&_ZN6S661C53v54Ev,
  (VTBL_ENTRY)&_ZN6S661C53v55Ev,
  (VTBL_ENTRY)&_ZN6S661C53v56Ev,
  (VTBL_ENTRY)&_ZN6S661C53v57Ev,
  (VTBL_ENTRY)&_ZN6S661C53v58Ev,
  (VTBL_ENTRY)&_ZN6S661C53v59Ev,
  (VTBL_ENTRY)&_ZN6S661C53v60Ev,
  (VTBL_ENTRY)&_ZN6S661C53v61Ev,
  (VTBL_ENTRY)&_ZN6S661C53v62Ev,
  (VTBL_ENTRY)&_ZN6S661C53v63Ev,
  (VTBL_ENTRY)&_ZN6S661C53v64Ev,
  (VTBL_ENTRY)&_ZN6S661C53v65Ev,
  (VTBL_ENTRY)&_ZN6S661C53v66Ev,
  (VTBL_ENTRY)&_ZN6S661C53v67Ev,
  (VTBL_ENTRY)&_ZN6S661C53v68Ev,
  (VTBL_ENTRY)&_ZN6S661C53v69Ev,
  (VTBL_ENTRY)&_ZN6S661C43v70Ev,
  (VTBL_ENTRY)&_ZN6S661C43v71Ev,
  (VTBL_ENTRY)&_ZN6S661C43v72Ev,
  (VTBL_ENTRY)&_ZN6S661C43v73Ev,
  (VTBL_ENTRY)&_ZN6S661C43v74Ev,
  (VTBL_ENTRY)&_ZN6S661C33v75Ev,
  (VTBL_ENTRY)&_ZN6S661C33v76Ev,
  (VTBL_ENTRY)&_ZN6S661C33v77Ev,
  (VTBL_ENTRY)&_ZN6S661C33v78Ev,
  (VTBL_ENTRY)&_ZN6S661C33v79Ev,
  (VTBL_ENTRY)&_ZN6S661C33v80Ev,
  (VTBL_ENTRY)&_ZN6S661C33v81Ev,
  (VTBL_ENTRY)&_ZN6S661C33v82Ev,
  (VTBL_ENTRY)&_ZN6S661C33v83Ev,
  (VTBL_ENTRY)&_ZN6S661C33v84Ev,
  (VTBL_ENTRY)&_ZN6S661C33v85Ev,
  (VTBL_ENTRY)&_ZN6S661C33v86Ev,
  (VTBL_ENTRY)&_ZN6S661C33v87Ev,
  (VTBL_ENTRY)&_ZN6S661C33v88Ev,
  (VTBL_ENTRY)&_ZN6S661C33v89Ev,
  (VTBL_ENTRY)&_ZN6S661C33v90Ev,
  (VTBL_ENTRY)&_ZN6S661C33v91Ev,
  (VTBL_ENTRY)&_ZN6S661C33v92Ev,
  (VTBL_ENTRY)&_ZN6S661C33v93Ev,
  (VTBL_ENTRY)&_ZN6S661C33v94Ev,
  (VTBL_ENTRY)&_ZN6S661C33v95Ev,
  (VTBL_ENTRY)&_ZN6S661C33v96Ev,
  (VTBL_ENTRY)&_ZN6S661C23v97Ev,
  (VTBL_ENTRY)&_ZN6S661C23v98Ev,
  (VTBL_ENTRY)&_ZN6S661C23v99Ev,
  (VTBL_ENTRY)&_ZN6S661C24v100Ev,
  (VTBL_ENTRY)&_ZN6S661C24v101Ev,
  (VTBL_ENTRY)&_ZN6S661C24v102Ev,
  (VTBL_ENTRY)&_ZN6S661C24v103Ev,
  (VTBL_ENTRY)&_ZN6S661C24v104Ev,
  (VTBL_ENTRY)&_ZN6S661C24v105Ev,
  (VTBL_ENTRY)&_ZN6S661C24v106Ev,
  (VTBL_ENTRY)&_ZN6S661C24v107Ev,
  (VTBL_ENTRY)&_ZN6S661C24v108Ev,
  (VTBL_ENTRY)&_ZN6S661C24v109Ev,
  (VTBL_ENTRY)&_ZN6S661C24v110Ev,
  (VTBL_ENTRY)&_ZN6S661C24v111Ev,
  (VTBL_ENTRY)&_ZN6S661C24v112Ev,
  (VTBL_ENTRY)&_ZN6S661C24v113Ev,
  (VTBL_ENTRY)&_ZN6S661C24v114Ev,
  (VTBL_ENTRY)&_ZN6S661C24v115Ev,
  (VTBL_ENTRY)&_ZN6S661C24v116Ev,
  (VTBL_ENTRY)&_ZN6S661C24v117Ev,
  (VTBL_ENTRY)&_ZN6S661C24v118Ev,
  (VTBL_ENTRY)&_ZN6S661C24v119Ev,
  (VTBL_ENTRY)&_ZN6S661C24v120Ev,
  (VTBL_ENTRY)&_ZN6S661C24v121Ev,
  (VTBL_ENTRY)&_ZN6S661C24v122Ev,
  (VTBL_ENTRY)&_ZN6S661C24v123Ev,
};
extern VTBL_ENTRY _ZTI6S661C2[];
extern  VTBL_ENTRY _ZTV6S661C2[];
Class_Descriptor cd_S661C2 = {  "S661C2", // class name
  bases_S661C2, 3,
  &(vtc_S661C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(352,252), // object size
  NSPAIRA(_ZTI6S661C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S661C2),122, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S661C1  : S661C2 {
  int s661c1f0;
  virtual  ~S661C1(); // _ZN6S661C1D1Ev
  virtual void  v1(); // _ZN6S661C12v1Ev
  virtual void  v2(); // _ZN6S661C12v2Ev
  virtual void  v3(); // _ZN6S661C12v3Ev
  virtual void  v4(); // _ZN6S661C12v4Ev
  virtual void  v5(); // _ZN6S661C12v5Ev
  S661C1(); // tgen
};
//SIG(1 S661C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v70 v71 v72 v73 v74 Fp FC6} vd v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 Fp FC7{ m} FC7 FC8{ m Fi[4]} FC8 Fi FC9{ m} Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp FC10{ BC11{ BC12{ m Fp Fi[2]}}} FC13{ m} Fi:1 FC14{ BC15{ BC12}} FC14 FC16{ BC17{ BC12}} FC16 Fc[2] FC18{ m Fi[4]} Fi[3] Fc[2] Fi[2]} vd v1 v2 v3 v4 v5 Fi}


 S661C1 ::~S661C1(){ note_dtor("S661C1", this);}
void  S661C1 ::v1(){vfunc_called(this, "_ZN6S661C12v1Ev");}
void  S661C1 ::v2(){vfunc_called(this, "_ZN6S661C12v2Ev");}
void  S661C1 ::v3(){vfunc_called(this, "_ZN6S661C12v3Ev");}
void  S661C1 ::v4(){vfunc_called(this, "_ZN6S661C12v4Ev");}
void  S661C1 ::v5(){vfunc_called(this, "_ZN6S661C12v5Ev");}
S661C1 ::S661C1(){ note_ctor("S661C1", this);} // tgen

static void Test_S661C1()
{
  extern Class_Descriptor cd_S661C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(45,65)];
    init_test(&cd_S661C1, buf);
    S661C1 *dp, &lv = *(dp=new (buf) S661C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(352,256), "sizeof(S661C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S661C1)");
    check_base_class_offset(lv, (S661C5*)(S661C4*)(S661C3*)(S661C2*), 0, "S661C1");
    check_base_class_offset(lv, (S661C4*)(S661C3*)(S661C2*), 0, "S661C1");
    check_base_class_offset(lv, (S661C3*)(S661C2*), 0, "S661C1");
    check_base_class_offset(lv, (S661C2*), 0, "S661C1");
    check_field_offset(lv, s661c1f0, ABISELECT(348,252), "S661C1.s661c1f0");
    test_class_info(&lv, &cd_S661C1);
    dp->~S661C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS661C1(Test_S661C1, "S661C1", ABISELECT(352,256));

#else // __cplusplus

extern void _ZN6S661C1C1Ev();
extern void _ZN6S661C1D1Ev();
Name_Map name_map_S661C1[] = {
  NSPAIR(_ZN6S661C1C1Ev),
  NSPAIR(_ZN6S661C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S661C5;
extern VTBL_ENTRY _ZTI6S661C5[];
extern  VTBL_ENTRY _ZTV6S661C5[];
extern Class_Descriptor cd_S661C4;
extern VTBL_ENTRY _ZTI6S661C4[];
extern  VTBL_ENTRY _ZTV6S661C4[];
extern Class_Descriptor cd_S661C3;
extern VTBL_ENTRY _ZTI6S661C3[];
extern  VTBL_ENTRY _ZTV6S661C3[];
extern Class_Descriptor cd_S661C2;
extern VTBL_ENTRY _ZTI6S661C2[];
extern  VTBL_ENTRY _ZTV6S661C2[];
static Base_Class bases_S661C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S661C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S661C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S661C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S661C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S661C1[];
extern void _ZN6S661C1D1Ev();
extern void _ZN6S661C1D0Ev();
extern void _ZN6S661C52v6Ev();
extern void _ZN6S661C52v7Ev();
extern void _ZN6S661C52v8Ev();
extern void _ZN6S661C52v9Ev();
extern void _ZN6S661C53v10Ev();
extern void _ZN6S661C53v11Ev();
extern void _ZN6S661C53v12Ev();
extern void _ZN6S661C53v13Ev();
extern void _ZN6S661C53v14Ev();
extern void _ZN6S661C53v15Ev();
extern void _ZN6S661C53v16Ev();
extern void _ZN6S661C53v17Ev();
extern void _ZN6S661C53v18Ev();
extern void _ZN6S661C53v19Ev();
extern void _ZN6S661C53v20Ev();
extern void _ZN6S661C53v21Ev();
extern void _ZN6S661C53v22Ev();
extern void _ZN6S661C53v23Ev();
extern void _ZN6S661C53v24Ev();
extern void _ZN6S661C53v25Ev();
extern void _ZN6S661C53v26Ev();
extern void _ZN6S661C53v27Ev();
extern void _ZN6S661C53v28Ev();
extern void _ZN6S661C53v29Ev();
extern void _ZN6S661C53v30Ev();
extern void _ZN6S661C53v31Ev();
extern void _ZN6S661C53v32Ev();
extern void _ZN6S661C53v33Ev();
extern void _ZN6S661C53v34Ev();
extern void _ZN6S661C53v35Ev();
extern void _ZN6S661C53v36Ev();
extern void _ZN6S661C53v37Ev();
extern void _ZN6S661C53v38Ev();
extern void _ZN6S661C53v39Ev();
extern void _ZN6S661C53v40Ev();
extern void _ZN6S661C53v41Ev();
extern void _ZN6S661C53v42Ev();
extern void _ZN6S661C53v43Ev();
extern void _ZN6S661C53v44Ev();
extern void _ZN6S661C53v45Ev();
extern void _ZN6S661C53v46Ev();
extern void _ZN6S661C53v47Ev();
extern void _ZN6S661C53v48Ev();
extern void _ZN6S661C53v49Ev();
extern void _ZN6S661C53v50Ev();
extern void _ZN6S661C53v51Ev();
extern void _ZN6S661C53v52Ev();
extern void _ZN6S661C53v53Ev();
extern void _ZN6S661C53v54Ev();
extern void _ZN6S661C53v55Ev();
extern void _ZN6S661C53v56Ev();
extern void _ZN6S661C53v57Ev();
extern void _ZN6S661C53v58Ev();
extern void _ZN6S661C53v59Ev();
extern void _ZN6S661C53v60Ev();
extern void _ZN6S661C53v61Ev();
extern void _ZN6S661C53v62Ev();
extern void _ZN6S661C53v63Ev();
extern void _ZN6S661C53v64Ev();
extern void _ZN6S661C53v65Ev();
extern void _ZN6S661C53v66Ev();
extern void _ZN6S661C53v67Ev();
extern void _ZN6S661C53v68Ev();
extern void _ZN6S661C53v69Ev();
extern void _ZN6S661C43v70Ev();
extern void _ZN6S661C43v71Ev();
extern void _ZN6S661C43v72Ev();
extern void _ZN6S661C43v73Ev();
extern void _ZN6S661C43v74Ev();
extern void _ZN6S661C33v75Ev();
extern void _ZN6S661C33v76Ev();
extern void _ZN6S661C33v77Ev();
extern void _ZN6S661C33v78Ev();
extern void _ZN6S661C33v79Ev();
extern void _ZN6S661C33v80Ev();
extern void _ZN6S661C33v81Ev();
extern void _ZN6S661C33v82Ev();
extern void _ZN6S661C33v83Ev();
extern void _ZN6S661C33v84Ev();
extern void _ZN6S661C33v85Ev();
extern void _ZN6S661C33v86Ev();
extern void _ZN6S661C33v87Ev();
extern void _ZN6S661C33v88Ev();
extern void _ZN6S661C33v89Ev();
extern void _ZN6S661C33v90Ev();
extern void _ZN6S661C33v91Ev();
extern void _ZN6S661C33v92Ev();
extern void _ZN6S661C33v93Ev();
extern void _ZN6S661C33v94Ev();
extern void _ZN6S661C33v95Ev();
extern void _ZN6S661C33v96Ev();
extern void _ZN6S661C23v97Ev();
extern void _ZN6S661C23v98Ev();
extern void _ZN6S661C23v99Ev();
extern void _ZN6S661C24v100Ev();
extern void _ZN6S661C24v101Ev();
extern void _ZN6S661C24v102Ev();
extern void _ZN6S661C24v103Ev();
extern void _ZN6S661C24v104Ev();
extern void _ZN6S661C24v105Ev();
extern void _ZN6S661C24v106Ev();
extern void _ZN6S661C24v107Ev();
extern void _ZN6S661C24v108Ev();
extern void _ZN6S661C24v109Ev();
extern void _ZN6S661C24v110Ev();
extern void _ZN6S661C24v111Ev();
extern void _ZN6S661C24v112Ev();
extern void _ZN6S661C24v113Ev();
extern void _ZN6S661C24v114Ev();
extern void _ZN6S661C24v115Ev();
extern void _ZN6S661C24v116Ev();
extern void _ZN6S661C24v117Ev();
extern void _ZN6S661C24v118Ev();
extern void _ZN6S661C24v119Ev();
extern void _ZN6S661C24v120Ev();
extern void _ZN6S661C24v121Ev();
extern void _ZN6S661C24v122Ev();
extern void _ZN6S661C24v123Ev();
extern void _ZN6S661C12v1Ev();
extern void _ZN6S661C12v2Ev();
extern void _ZN6S661C12v3Ev();
extern void _ZN6S661C12v4Ev();
extern void _ZN6S661C12v5Ev();
static  VTBL_ENTRY vtc_S661C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S661C1[0]),
  (VTBL_ENTRY)&_ZN6S661C1D1Ev,
  (VTBL_ENTRY)&_ZN6S661C1D0Ev,
  (VTBL_ENTRY)&_ZN6S661C52v6Ev,
  (VTBL_ENTRY)&_ZN6S661C52v7Ev,
  (VTBL_ENTRY)&_ZN6S661C52v8Ev,
  (VTBL_ENTRY)&_ZN6S661C52v9Ev,
  (VTBL_ENTRY)&_ZN6S661C53v10Ev,
  (VTBL_ENTRY)&_ZN6S661C53v11Ev,
  (VTBL_ENTRY)&_ZN6S661C53v12Ev,
  (VTBL_ENTRY)&_ZN6S661C53v13Ev,
  (VTBL_ENTRY)&_ZN6S661C53v14Ev,
  (VTBL_ENTRY)&_ZN6S661C53v15Ev,
  (VTBL_ENTRY)&_ZN6S661C53v16Ev,
  (VTBL_ENTRY)&_ZN6S661C53v17Ev,
  (VTBL_ENTRY)&_ZN6S661C53v18Ev,
  (VTBL_ENTRY)&_ZN6S661C53v19Ev,
  (VTBL_ENTRY)&_ZN6S661C53v20Ev,
  (VTBL_ENTRY)&_ZN6S661C53v21Ev,
  (VTBL_ENTRY)&_ZN6S661C53v22Ev,
  (VTBL_ENTRY)&_ZN6S661C53v23Ev,
  (VTBL_ENTRY)&_ZN6S661C53v24Ev,
  (VTBL_ENTRY)&_ZN6S661C53v25Ev,
  (VTBL_ENTRY)&_ZN6S661C53v26Ev,
  (VTBL_ENTRY)&_ZN6S661C53v27Ev,
  (VTBL_ENTRY)&_ZN6S661C53v28Ev,
  (VTBL_ENTRY)&_ZN6S661C53v29Ev,
  (VTBL_ENTRY)&_ZN6S661C53v30Ev,
  (VTBL_ENTRY)&_ZN6S661C53v31Ev,
  (VTBL_ENTRY)&_ZN6S661C53v32Ev,
  (VTBL_ENTRY)&_ZN6S661C53v33Ev,
  (VTBL_ENTRY)&_ZN6S661C53v34Ev,
  (VTBL_ENTRY)&_ZN6S661C53v35Ev,
  (VTBL_ENTRY)&_ZN6S661C53v36Ev,
  (VTBL_ENTRY)&_ZN6S661C53v37Ev,
  (VTBL_ENTRY)&_ZN6S661C53v38Ev,
  (VTBL_ENTRY)&_ZN6S661C53v39Ev,
  (VTBL_ENTRY)&_ZN6S661C53v40Ev,
  (VTBL_ENTRY)&_ZN6S661C53v41Ev,
  (VTBL_ENTRY)&_ZN6S661C53v42Ev,
  (VTBL_ENTRY)&_ZN6S661C53v43Ev,
  (VTBL_ENTRY)&_ZN6S661C53v44Ev,
  (VTBL_ENTRY)&_ZN6S661C53v45Ev,
  (VTBL_ENTRY)&_ZN6S661C53v46Ev,
  (VTBL_ENTRY)&_ZN6S661C53v47Ev,
  (VTBL_ENTRY)&_ZN6S661C53v48Ev,
  (VTBL_ENTRY)&_ZN6S661C53v49Ev,
  (VTBL_ENTRY)&_ZN6S661C53v50Ev,
  (VTBL_ENTRY)&_ZN6S661C53v51Ev,
  (VTBL_ENTRY)&_ZN6S661C53v52Ev,
  (VTBL_ENTRY)&_ZN6S661C53v53Ev,
  (VTBL_ENTRY)&_ZN6S661C53v54Ev,
  (VTBL_ENTRY)&_ZN6S661C53v55Ev,
  (VTBL_ENTRY)&_ZN6S661C53v56Ev,
  (VTBL_ENTRY)&_ZN6S661C53v57Ev,
  (VTBL_ENTRY)&_ZN6S661C53v58Ev,
  (VTBL_ENTRY)&_ZN6S661C53v59Ev,
  (VTBL_ENTRY)&_ZN6S661C53v60Ev,
  (VTBL_ENTRY)&_ZN6S661C53v61Ev,
  (VTBL_ENTRY)&_ZN6S661C53v62Ev,
  (VTBL_ENTRY)&_ZN6S661C53v63Ev,
  (VTBL_ENTRY)&_ZN6S661C53v64Ev,
  (VTBL_ENTRY)&_ZN6S661C53v65Ev,
  (VTBL_ENTRY)&_ZN6S661C53v66Ev,
  (VTBL_ENTRY)&_ZN6S661C53v67Ev,
  (VTBL_ENTRY)&_ZN6S661C53v68Ev,
  (VTBL_ENTRY)&_ZN6S661C53v69Ev,
  (VTBL_ENTRY)&_ZN6S661C43v70Ev,
  (VTBL_ENTRY)&_ZN6S661C43v71Ev,
  (VTBL_ENTRY)&_ZN6S661C43v72Ev,
  (VTBL_ENTRY)&_ZN6S661C43v73Ev,
  (VTBL_ENTRY)&_ZN6S661C43v74Ev,
  (VTBL_ENTRY)&_ZN6S661C33v75Ev,
  (VTBL_ENTRY)&_ZN6S661C33v76Ev,
  (VTBL_ENTRY)&_ZN6S661C33v77Ev,
  (VTBL_ENTRY)&_ZN6S661C33v78Ev,
  (VTBL_ENTRY)&_ZN6S661C33v79Ev,
  (VTBL_ENTRY)&_ZN6S661C33v80Ev,
  (VTBL_ENTRY)&_ZN6S661C33v81Ev,
  (VTBL_ENTRY)&_ZN6S661C33v82Ev,
  (VTBL_ENTRY)&_ZN6S661C33v83Ev,
  (VTBL_ENTRY)&_ZN6S661C33v84Ev,
  (VTBL_ENTRY)&_ZN6S661C33v85Ev,
  (VTBL_ENTRY)&_ZN6S661C33v86Ev,
  (VTBL_ENTRY)&_ZN6S661C33v87Ev,
  (VTBL_ENTRY)&_ZN6S661C33v88Ev,
  (VTBL_ENTRY)&_ZN6S661C33v89Ev,
  (VTBL_ENTRY)&_ZN6S661C33v90Ev,
  (VTBL_ENTRY)&_ZN6S661C33v91Ev,
  (VTBL_ENTRY)&_ZN6S661C33v92Ev,
  (VTBL_ENTRY)&_ZN6S661C33v93Ev,
  (VTBL_ENTRY)&_ZN6S661C33v94Ev,
  (VTBL_ENTRY)&_ZN6S661C33v95Ev,
  (VTBL_ENTRY)&_ZN6S661C33v96Ev,
  (VTBL_ENTRY)&_ZN6S661C23v97Ev,
  (VTBL_ENTRY)&_ZN6S661C23v98Ev,
  (VTBL_ENTRY)&_ZN6S661C23v99Ev,
  (VTBL_ENTRY)&_ZN6S661C24v100Ev,
  (VTBL_ENTRY)&_ZN6S661C24v101Ev,
  (VTBL_ENTRY)&_ZN6S661C24v102Ev,
  (VTBL_ENTRY)&_ZN6S661C24v103Ev,
  (VTBL_ENTRY)&_ZN6S661C24v104Ev,
  (VTBL_ENTRY)&_ZN6S661C24v105Ev,
  (VTBL_ENTRY)&_ZN6S661C24v106Ev,
  (VTBL_ENTRY)&_ZN6S661C24v107Ev,
  (VTBL_ENTRY)&_ZN6S661C24v108Ev,
  (VTBL_ENTRY)&_ZN6S661C24v109Ev,
  (VTBL_ENTRY)&_ZN6S661C24v110Ev,
  (VTBL_ENTRY)&_ZN6S661C24v111Ev,
  (VTBL_ENTRY)&_ZN6S661C24v112Ev,
  (VTBL_ENTRY)&_ZN6S661C24v113Ev,
  (VTBL_ENTRY)&_ZN6S661C24v114Ev,
  (VTBL_ENTRY)&_ZN6S661C24v115Ev,
  (VTBL_ENTRY)&_ZN6S661C24v116Ev,
  (VTBL_ENTRY)&_ZN6S661C24v117Ev,
  (VTBL_ENTRY)&_ZN6S661C24v118Ev,
  (VTBL_ENTRY)&_ZN6S661C24v119Ev,
  (VTBL_ENTRY)&_ZN6S661C24v120Ev,
  (VTBL_ENTRY)&_ZN6S661C24v121Ev,
  (VTBL_ENTRY)&_ZN6S661C24v122Ev,
  (VTBL_ENTRY)&_ZN6S661C24v123Ev,
  (VTBL_ENTRY)&_ZN6S661C12v1Ev,
  (VTBL_ENTRY)&_ZN6S661C12v2Ev,
  (VTBL_ENTRY)&_ZN6S661C12v3Ev,
  (VTBL_ENTRY)&_ZN6S661C12v4Ev,
  (VTBL_ENTRY)&_ZN6S661C12v5Ev,
};
extern VTBL_ENTRY _ZTI6S661C1[];
extern  VTBL_ENTRY _ZTV6S661C1[];
Class_Descriptor cd_S661C1 = {  "S661C1", // class name
  bases_S661C1, 4,
  &(vtc_S661C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(352,256), // object size
  NSPAIRA(_ZTI6S661C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S661C1),127, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2226C4_nt  {
  virtual  ~S2226C4_nt(); // _ZN10S2226C4_ntD1Ev
  virtual void  v38(); // _ZN10S2226C4_nt3v38Ev
  virtual void  v39(); // _ZN10S2226C4_nt3v39Ev
  virtual void  v40(); // _ZN10S2226C4_nt3v40Ev
  virtual void  v41(); // _ZN10S2226C4_nt3v41Ev
  S2226C4_nt(); // tgen
};
//SIG(-1 S2226C4_nt) C1{ vd v1 v2 v3 v4}


 S2226C4_nt ::~S2226C4_nt(){ note_dtor("S2226C4_nt", this);}
void  S2226C4_nt ::v38(){vfunc_called(this, "_ZN10S2226C4_nt3v38Ev");}
void  S2226C4_nt ::v39(){vfunc_called(this, "_ZN10S2226C4_nt3v39Ev");}
void  S2226C4_nt ::v40(){vfunc_called(this, "_ZN10S2226C4_nt3v40Ev");}
void  S2226C4_nt ::v41(){vfunc_called(this, "_ZN10S2226C4_nt3v41Ev");}
S2226C4_nt ::S2226C4_nt(){ note_ctor("S2226C4_nt", this);} // tgen

//skip512 S2226C4_nt

#else // __cplusplus

extern void _ZN10S2226C4_ntC1Ev();
extern void _ZN10S2226C4_ntD1Ev();
Name_Map name_map_S2226C4_nt[] = {
  NSPAIR(_ZN10S2226C4_ntC1Ev),
  NSPAIR(_ZN10S2226C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S2226C4_nt[];
extern void _ZN10S2226C4_ntD1Ev();
extern void _ZN10S2226C4_ntD0Ev();
extern void _ZN10S2226C4_nt3v38Ev();
extern void _ZN10S2226C4_nt3v39Ev();
extern void _ZN10S2226C4_nt3v40Ev();
extern void _ZN10S2226C4_nt3v41Ev();
static  VTBL_ENTRY vtc_S2226C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2226C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S2226C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2226C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2226C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2226C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2226C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2226C4_nt3v41Ev,
};
extern VTBL_ENTRY _ZTI10S2226C4_nt[];
VTBL_ENTRY *P__ZTI10S2226C4_nt = _ZTI10S2226C4_nt; 
extern  VTBL_ENTRY _ZTV10S2226C4_nt[];
Class_Descriptor cd_S2226C4_nt = {  "S2226C4_nt", // class name
  0,0,//no base classes
  &(vtc_S2226C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S2226C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S2226C4_nt),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2226C3  : S2226C4_nt {
  virtual  ~S2226C3(); // _ZN7S2226C3D1Ev
  virtual void  v42(); // _ZN7S2226C33v42Ev
  virtual void  v43(); // _ZN7S2226C33v43Ev
  virtual void  v44(); // _ZN7S2226C33v44Ev
  virtual void  v45(); // _ZN7S2226C33v45Ev
  virtual void  v46(); // _ZN7S2226C33v46Ev
  S2226C3(); // tgen
};
//SIG(-1 S2226C3) C1{ BC2{ vd v6 v7 v8 v9} vd v1 v2 v3 v4 v5}


 S2226C3 ::~S2226C3(){ note_dtor("S2226C3", this);}
void  S2226C3 ::v42(){vfunc_called(this, "_ZN7S2226C33v42Ev");}
void  S2226C3 ::v43(){vfunc_called(this, "_ZN7S2226C33v43Ev");}
void  S2226C3 ::v44(){vfunc_called(this, "_ZN7S2226C33v44Ev");}
void  S2226C3 ::v45(){vfunc_called(this, "_ZN7S2226C33v45Ev");}
void  S2226C3 ::v46(){vfunc_called(this, "_ZN7S2226C33v46Ev");}
S2226C3 ::S2226C3(){ note_ctor("S2226C3", this);} // tgen

static void Test_S2226C3()
{
  extern Class_Descriptor cd_S2226C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2226C3, buf);
    S2226C3 *dp, &lv = *(dp=new (buf) S2226C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2226C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2226C3)");
    check_base_class_offset(lv, (S2226C4_nt*), 0, "S2226C3");
    test_class_info(&lv, &cd_S2226C3);
    dp->~S2226C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2226C3(Test_S2226C3, "S2226C3", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2226C3C1Ev();
extern void _ZN7S2226C3D1Ev();
Name_Map name_map_S2226C3[] = {
  NSPAIR(_ZN7S2226C3C1Ev),
  NSPAIR(_ZN7S2226C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2226C4_nt;
extern VTBL_ENTRY _ZTI10S2226C4_nt[];
extern  VTBL_ENTRY _ZTV10S2226C4_nt[];
static Base_Class bases_S2226C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2226C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2226C3[];
extern void _ZN7S2226C3D1Ev();
extern void _ZN7S2226C3D0Ev();
extern void _ZN10S2226C4_nt3v38Ev();
extern void _ZN10S2226C4_nt3v39Ev();
extern void _ZN10S2226C4_nt3v40Ev();
extern void _ZN10S2226C4_nt3v41Ev();
extern void _ZN7S2226C33v42Ev();
extern void _ZN7S2226C33v43Ev();
extern void _ZN7S2226C33v44Ev();
extern void _ZN7S2226C33v45Ev();
extern void _ZN7S2226C33v46Ev();
static  VTBL_ENTRY vtc_S2226C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2226C3[0]),
  (VTBL_ENTRY)&_ZN7S2226C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2226C3D0Ev,
  (VTBL_ENTRY)&_ZN10S2226C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2226C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2226C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2226C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN7S2226C33v42Ev,
  (VTBL_ENTRY)&_ZN7S2226C33v43Ev,
  (VTBL_ENTRY)&_ZN7S2226C33v44Ev,
  (VTBL_ENTRY)&_ZN7S2226C33v45Ev,
  (VTBL_ENTRY)&_ZN7S2226C33v46Ev,
};
extern VTBL_ENTRY _ZTI7S2226C3[];
extern  VTBL_ENTRY _ZTV7S2226C3[];
Class_Descriptor cd_S2226C3 = {  "S2226C3", // class name
  bases_S2226C3, 1,
  &(vtc_S2226C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2226C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2226C3),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2226C6  {
  char s2226c6f0[1024];
  int s2226c6f1[2];
  virtual  ~S2226C6(); // _ZN7S2226C6D1Ev
  virtual void  v47(); // _ZN7S2226C63v47Ev
  virtual void  v48(); // _ZN7S2226C63v48Ev
  virtual void  v49(); // _ZN7S2226C63v49Ev
  virtual void  v50(); // _ZN7S2226C63v50Ev
  virtual void  v51(); // _ZN7S2226C63v51Ev
  virtual void  v52(); // _ZN7S2226C63v52Ev
  virtual void  v53(); // _ZN7S2226C63v53Ev
  virtual void  v54(); // _ZN7S2226C63v54Ev
  virtual void  v55(); // _ZN7S2226C63v55Ev
  virtual void  v56(); // _ZN7S2226C63v56Ev
  virtual void  v57(); // _ZN7S2226C63v57Ev
  virtual void  v58(); // _ZN7S2226C63v58Ev
  virtual void  v59(); // _ZN7S2226C63v59Ev
  S2226C6(); // tgen
};
//SIG(-1 S2226C6) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 Fc[1024] Fi[2]}


 S2226C6 ::~S2226C6(){ note_dtor("S2226C6", this);}
void  S2226C6 ::v47(){vfunc_called(this, "_ZN7S2226C63v47Ev");}
void  S2226C6 ::v48(){vfunc_called(this, "_ZN7S2226C63v48Ev");}
void  S2226C6 ::v49(){vfunc_called(this, "_ZN7S2226C63v49Ev");}
void  S2226C6 ::v50(){vfunc_called(this, "_ZN7S2226C63v50Ev");}
void  S2226C6 ::v51(){vfunc_called(this, "_ZN7S2226C63v51Ev");}
void  S2226C6 ::v52(){vfunc_called(this, "_ZN7S2226C63v52Ev");}
void  S2226C6 ::v53(){vfunc_called(this, "_ZN7S2226C63v53Ev");}
void  S2226C6 ::v54(){vfunc_called(this, "_ZN7S2226C63v54Ev");}
void  S2226C6 ::v55(){vfunc_called(this, "_ZN7S2226C63v55Ev");}
void  S2226C6 ::v56(){vfunc_called(this, "_ZN7S2226C63v56Ev");}
void  S2226C6 ::v57(){vfunc_called(this, "_ZN7S2226C63v57Ev");}
void  S2226C6 ::v58(){vfunc_called(this, "_ZN7S2226C63v58Ev");}
void  S2226C6 ::v59(){vfunc_called(this, "_ZN7S2226C63v59Ev");}
S2226C6 ::S2226C6(){ note_ctor("S2226C6", this);} // tgen

static void Test_S2226C6()
{
  extern Class_Descriptor cd_S2226C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(131,260)];
    init_test(&cd_S2226C6, buf);
    S2226C6 *dp, &lv = *(dp=new (buf) S2226C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1040,1036), "sizeof(S2226C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2226C6)");
    check_field_offset(lv, s2226c6f0, ABISELECT(8,4), "S2226C6.s2226c6f0");
    check_field_offset(lv, s2226c6f1, ABISELECT(1032,1028), "S2226C6.s2226c6f1");
    test_class_info(&lv, &cd_S2226C6);
    dp->~S2226C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2226C6(Test_S2226C6, "S2226C6", ABISELECT(1040,1036));

#else // __cplusplus

extern void _ZN7S2226C6C1Ev();
extern void _ZN7S2226C6D1Ev();
Name_Map name_map_S2226C6[] = {
  NSPAIR(_ZN7S2226C6C1Ev),
  NSPAIR(_ZN7S2226C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2226C6[];
extern void _ZN7S2226C6D1Ev();
extern void _ZN7S2226C6D0Ev();
extern void _ZN7S2226C63v47Ev();
extern void _ZN7S2226C63v48Ev();
extern void _ZN7S2226C63v49Ev();
extern void _ZN7S2226C63v50Ev();
extern void _ZN7S2226C63v51Ev();
extern void _ZN7S2226C63v52Ev();
extern void _ZN7S2226C63v53Ev();
extern void _ZN7S2226C63v54Ev();
extern void _ZN7S2226C63v55Ev();
extern void _ZN7S2226C63v56Ev();
extern void _ZN7S2226C63v57Ev();
extern void _ZN7S2226C63v58Ev();
extern void _ZN7S2226C63v59Ev();
static  VTBL_ENTRY vtc_S2226C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2226C6[0]),
  (VTBL_ENTRY)&_ZN7S2226C6D1Ev,
  (VTBL_ENTRY)&_ZN7S2226C6D0Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v47Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v48Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v49Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v50Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v51Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v52Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v53Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v54Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v55Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v56Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v57Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v58Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v59Ev,
};
extern VTBL_ENTRY _ZTI7S2226C6[];
extern  VTBL_ENTRY _ZTV7S2226C6[];
Class_Descriptor cd_S2226C6 = {  "S2226C6", // class name
  0,0,//no base classes
  &(vtc_S2226C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1040,1036), // object size
  NSPAIRA(_ZTI7S2226C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2226C6),17, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2226C5  : S2226C6 {
  virtual  ~S2226C5(); // _ZN7S2226C5D1Ev
  virtual void  v60(); // _ZN7S2226C53v60Ev
  virtual void  v61(); // _ZN7S2226C53v61Ev
  virtual void  v62(); // _ZN7S2226C53v62Ev
  virtual void  v63(); // _ZN7S2226C53v63Ev
  S2226C5(); // tgen
};
//SIG(-1 S2226C5) C1{ BC2{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 Fc[1024] Fi[2]} vd v1 v2 v3 v4}


 S2226C5 ::~S2226C5(){ note_dtor("S2226C5", this);}
void  S2226C5 ::v60(){vfunc_called(this, "_ZN7S2226C53v60Ev");}
void  S2226C5 ::v61(){vfunc_called(this, "_ZN7S2226C53v61Ev");}
void  S2226C5 ::v62(){vfunc_called(this, "_ZN7S2226C53v62Ev");}
void  S2226C5 ::v63(){vfunc_called(this, "_ZN7S2226C53v63Ev");}
S2226C5 ::S2226C5(){ note_ctor("S2226C5", this);} // tgen

static void Test_S2226C5()
{
  extern Class_Descriptor cd_S2226C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(131,260)];
    init_test(&cd_S2226C5, buf);
    S2226C5 *dp, &lv = *(dp=new (buf) S2226C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1040,1036), "sizeof(S2226C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2226C5)");
    check_base_class_offset(lv, (S2226C6*), 0, "S2226C5");
    test_class_info(&lv, &cd_S2226C5);
    dp->~S2226C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2226C5(Test_S2226C5, "S2226C5", ABISELECT(1040,1036));

#else // __cplusplus

extern void _ZN7S2226C5C1Ev();
extern void _ZN7S2226C5D1Ev();
Name_Map name_map_S2226C5[] = {
  NSPAIR(_ZN7S2226C5C1Ev),
  NSPAIR(_ZN7S2226C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2226C6;
extern VTBL_ENTRY _ZTI7S2226C6[];
extern  VTBL_ENTRY _ZTV7S2226C6[];
static Base_Class bases_S2226C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2226C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2226C5[];
extern void _ZN7S2226C5D1Ev();
extern void _ZN7S2226C5D0Ev();
extern void _ZN7S2226C63v47Ev();
extern void _ZN7S2226C63v48Ev();
extern void _ZN7S2226C63v49Ev();
extern void _ZN7S2226C63v50Ev();
extern void _ZN7S2226C63v51Ev();
extern void _ZN7S2226C63v52Ev();
extern void _ZN7S2226C63v53Ev();
extern void _ZN7S2226C63v54Ev();
extern void _ZN7S2226C63v55Ev();
extern void _ZN7S2226C63v56Ev();
extern void _ZN7S2226C63v57Ev();
extern void _ZN7S2226C63v58Ev();
extern void _ZN7S2226C63v59Ev();
extern void _ZN7S2226C53v60Ev();
extern void _ZN7S2226C53v61Ev();
extern void _ZN7S2226C53v62Ev();
extern void _ZN7S2226C53v63Ev();
static  VTBL_ENTRY vtc_S2226C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2226C5[0]),
  (VTBL_ENTRY)&_ZN7S2226C5D1Ev,
  (VTBL_ENTRY)&_ZN7S2226C5D0Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v47Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v48Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v49Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v50Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v51Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v52Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v53Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v54Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v55Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v56Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v57Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v58Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v59Ev,
  (VTBL_ENTRY)&_ZN7S2226C53v60Ev,
  (VTBL_ENTRY)&_ZN7S2226C53v61Ev,
  (VTBL_ENTRY)&_ZN7S2226C53v62Ev,
  (VTBL_ENTRY)&_ZN7S2226C53v63Ev,
};
extern VTBL_ENTRY _ZTI7S2226C5[];
extern  VTBL_ENTRY _ZTV7S2226C5[];
Class_Descriptor cd_S2226C5 = {  "S2226C5", // class name
  bases_S2226C5, 1,
  &(vtc_S2226C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1040,1036), // object size
  NSPAIRA(_ZTI7S2226C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2226C5),21, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2226C2  : S2226C3 , S2226C5 {
  virtual  ~S2226C2(); // _ZN7S2226C2D1Ev
  virtual void  v64(); // _ZN7S2226C23v64Ev
  virtual void  v65(); // _ZN7S2226C23v65Ev
  virtual void  v66(); // _ZN7S2226C23v66Ev
  virtual void  v67(); // _ZN7S2226C23v67Ev
  virtual void  v68(); // _ZN7S2226C23v68Ev
  virtual void  v69(); // _ZN7S2226C23v69Ev
  virtual void  v70(); // _ZN7S2226C23v70Ev
  virtual void  v71(); // _ZN7S2226C23v71Ev
  virtual void  v72(); // _ZN7S2226C23v72Ev
  virtual void  v73(); // _ZN7S2226C23v73Ev
  S2226C2(); // tgen
};
//SIG(-1 S2226C2) C1{ BC2{ BC3{ vd v11 v12 v13 v14} vd v15 v16 v17 v18 v19} BC4{ BC5{ vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 Fc[1024] Fi[2]} vd v33 v34 v35 v36} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10}


 S2226C2 ::~S2226C2(){ note_dtor("S2226C2", this);}
void  S2226C2 ::v64(){vfunc_called(this, "_ZN7S2226C23v64Ev");}
void  S2226C2 ::v65(){vfunc_called(this, "_ZN7S2226C23v65Ev");}
void  S2226C2 ::v66(){vfunc_called(this, "_ZN7S2226C23v66Ev");}
void  S2226C2 ::v67(){vfunc_called(this, "_ZN7S2226C23v67Ev");}
void  S2226C2 ::v68(){vfunc_called(this, "_ZN7S2226C23v68Ev");}
void  S2226C2 ::v69(){vfunc_called(this, "_ZN7S2226C23v69Ev");}
void  S2226C2 ::v70(){vfunc_called(this, "_ZN7S2226C23v70Ev");}
void  S2226C2 ::v71(){vfunc_called(this, "_ZN7S2226C23v71Ev");}
void  S2226C2 ::v72(){vfunc_called(this, "_ZN7S2226C23v72Ev");}
void  S2226C2 ::v73(){vfunc_called(this, "_ZN7S2226C23v73Ev");}
S2226C2 ::S2226C2(){ note_ctor("S2226C2", this);} // tgen

static void Test_S2226C2()
{
  extern Class_Descriptor cd_S2226C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(132,261)];
    init_test(&cd_S2226C2, buf);
    S2226C2 *dp, &lv = *(dp=new (buf) S2226C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1048,1040), "sizeof(S2226C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2226C2)");
    check_base_class_offset(lv, (S2226C4_nt*)(S2226C3*), 0, "S2226C2");
    check_base_class_offset(lv, (S2226C3*), 0, "S2226C2");
    check_base_class_offset(lv, (S2226C6*)(S2226C5*), ABISELECT(8,4), "S2226C2");
    check_base_class_offset(lv, (S2226C5*), ABISELECT(8,4), "S2226C2");
    test_class_info(&lv, &cd_S2226C2);
    dp->~S2226C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2226C2(Test_S2226C2, "S2226C2", ABISELECT(1048,1040));

#else // __cplusplus

extern void _ZN7S2226C2C1Ev();
extern void _ZN7S2226C2D1Ev();
Name_Map name_map_S2226C2[] = {
  NSPAIR(_ZN7S2226C2C1Ev),
  NSPAIR(_ZN7S2226C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2226C4_nt;
extern VTBL_ENTRY _ZTI10S2226C4_nt[];
extern  VTBL_ENTRY _ZTV10S2226C4_nt[];
extern Class_Descriptor cd_S2226C3;
extern VTBL_ENTRY _ZTI7S2226C3[];
extern  VTBL_ENTRY _ZTV7S2226C3[];
extern Class_Descriptor cd_S2226C6;
extern VTBL_ENTRY _ZTI7S2226C6[];
extern  VTBL_ENTRY _ZTV7S2226C6[];
extern Class_Descriptor cd_S2226C5;
extern VTBL_ENTRY _ZTI7S2226C5[];
extern  VTBL_ENTRY _ZTV7S2226C5[];
static Base_Class bases_S2226C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2226C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2226C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2226C6,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2226C5,    ABISELECT(8,4), //bcp->offset
    23, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2226C2[];
extern void _ZN7S2226C2D1Ev();
extern void _ZN7S2226C2D0Ev();
extern void _ZN10S2226C4_nt3v38Ev();
extern void _ZN10S2226C4_nt3v39Ev();
extern void _ZN10S2226C4_nt3v40Ev();
extern void _ZN10S2226C4_nt3v41Ev();
extern void _ZN7S2226C33v42Ev();
extern void _ZN7S2226C33v43Ev();
extern void _ZN7S2226C33v44Ev();
extern void _ZN7S2226C33v45Ev();
extern void _ZN7S2226C33v46Ev();
extern void _ZN7S2226C23v64Ev();
extern void _ZN7S2226C23v65Ev();
extern void _ZN7S2226C23v66Ev();
extern void _ZN7S2226C23v67Ev();
extern void _ZN7S2226C23v68Ev();
extern void _ZN7S2226C23v69Ev();
extern void _ZN7S2226C23v70Ev();
extern void _ZN7S2226C23v71Ev();
extern void _ZN7S2226C23v72Ev();
extern void _ZN7S2226C23v73Ev();
extern void ABISELECT(_ZThn8_N7S2226C2D1Ev,_ZThn4_N7S2226C2D1Ev)();
extern void ABISELECT(_ZThn8_N7S2226C2D0Ev,_ZThn4_N7S2226C2D0Ev)();
extern void _ZN7S2226C63v47Ev();
extern void _ZN7S2226C63v48Ev();
extern void _ZN7S2226C63v49Ev();
extern void _ZN7S2226C63v50Ev();
extern void _ZN7S2226C63v51Ev();
extern void _ZN7S2226C63v52Ev();
extern void _ZN7S2226C63v53Ev();
extern void _ZN7S2226C63v54Ev();
extern void _ZN7S2226C63v55Ev();
extern void _ZN7S2226C63v56Ev();
extern void _ZN7S2226C63v57Ev();
extern void _ZN7S2226C63v58Ev();
extern void _ZN7S2226C63v59Ev();
extern void _ZN7S2226C53v60Ev();
extern void _ZN7S2226C53v61Ev();
extern void _ZN7S2226C53v62Ev();
extern void _ZN7S2226C53v63Ev();
static  VTBL_ENTRY vtc_S2226C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2226C2[0]),
  (VTBL_ENTRY)&_ZN7S2226C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2226C2D0Ev,
  (VTBL_ENTRY)&_ZN10S2226C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2226C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2226C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2226C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN7S2226C33v42Ev,
  (VTBL_ENTRY)&_ZN7S2226C33v43Ev,
  (VTBL_ENTRY)&_ZN7S2226C33v44Ev,
  (VTBL_ENTRY)&_ZN7S2226C33v45Ev,
  (VTBL_ENTRY)&_ZN7S2226C33v46Ev,
  (VTBL_ENTRY)&_ZN7S2226C23v64Ev,
  (VTBL_ENTRY)&_ZN7S2226C23v65Ev,
  (VTBL_ENTRY)&_ZN7S2226C23v66Ev,
  (VTBL_ENTRY)&_ZN7S2226C23v67Ev,
  (VTBL_ENTRY)&_ZN7S2226C23v68Ev,
  (VTBL_ENTRY)&_ZN7S2226C23v69Ev,
  (VTBL_ENTRY)&_ZN7S2226C23v70Ev,
  (VTBL_ENTRY)&_ZN7S2226C23v71Ev,
  (VTBL_ENTRY)&_ZN7S2226C23v72Ev,
  (VTBL_ENTRY)&_ZN7S2226C23v73Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S2226C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S2226C2D1Ev,_ZThn4_N7S2226C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S2226C2D0Ev,_ZThn4_N7S2226C2D0Ev),
  (VTBL_ENTRY)&_ZN7S2226C63v47Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v48Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v49Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v50Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v51Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v52Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v53Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v54Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v55Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v56Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v57Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v58Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v59Ev,
  (VTBL_ENTRY)&_ZN7S2226C53v60Ev,
  (VTBL_ENTRY)&_ZN7S2226C53v61Ev,
  (VTBL_ENTRY)&_ZN7S2226C53v62Ev,
  (VTBL_ENTRY)&_ZN7S2226C53v63Ev,
};
extern VTBL_ENTRY _ZTI7S2226C2[];
extern  VTBL_ENTRY _ZTV7S2226C2[];
Class_Descriptor cd_S2226C2 = {  "S2226C2", // class name
  bases_S2226C2, 4,
  &(vtc_S2226C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1048,1040), // object size
  NSPAIRA(_ZTI7S2226C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2226C2),44, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2226C7_nt  {
  virtual  ~S2226C7_nt(); // _ZN10S2226C7_ntD1Ev
  virtual void  v74(); // _ZN10S2226C7_nt3v74Ev
  virtual void  v75(); // _ZN10S2226C7_nt3v75Ev
  S2226C7_nt(); // tgen
};
//SIG(-1 S2226C7_nt) C1{ vd v1 v2}


 S2226C7_nt ::~S2226C7_nt(){ note_dtor("S2226C7_nt", this);}
void  S2226C7_nt ::v74(){vfunc_called(this, "_ZN10S2226C7_nt3v74Ev");}
void  S2226C7_nt ::v75(){vfunc_called(this, "_ZN10S2226C7_nt3v75Ev");}
S2226C7_nt ::S2226C7_nt(){ note_ctor("S2226C7_nt", this);} // tgen

//skip512 S2226C7_nt

#else // __cplusplus

extern void _ZN10S2226C7_ntC1Ev();
extern void _ZN10S2226C7_ntD1Ev();
Name_Map name_map_S2226C7_nt[] = {
  NSPAIR(_ZN10S2226C7_ntC1Ev),
  NSPAIR(_ZN10S2226C7_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S2226C7_nt[];
extern void _ZN10S2226C7_ntD1Ev();
extern void _ZN10S2226C7_ntD0Ev();
extern void _ZN10S2226C7_nt3v74Ev();
extern void _ZN10S2226C7_nt3v75Ev();
static  VTBL_ENTRY vtc_S2226C7_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2226C7_nt[0]),
  (VTBL_ENTRY)&_ZN10S2226C7_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2226C7_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2226C7_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2226C7_nt3v75Ev,
};
extern VTBL_ENTRY _ZTI10S2226C7_nt[];
VTBL_ENTRY *P__ZTI10S2226C7_nt = _ZTI10S2226C7_nt; 
extern  VTBL_ENTRY _ZTV10S2226C7_nt[];
Class_Descriptor cd_S2226C7_nt = {  "S2226C7_nt", // class name
  0,0,//no base classes
  &(vtc_S2226C7_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S2226C7_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S2226C7_nt),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2226C8  {
  virtual  ~S2226C8(); // _ZN7S2226C8D1Ev
  virtual void  v76(); // _ZN7S2226C83v76Ev
  virtual void  v77(); // _ZN7S2226C83v77Ev
  S2226C8(); // tgen
};
//SIG(-1 S2226C8) C1{ vd v1 v2}


 S2226C8 ::~S2226C8(){ note_dtor("S2226C8", this);}
void  S2226C8 ::v76(){vfunc_called(this, "_ZN7S2226C83v76Ev");}
void  S2226C8 ::v77(){vfunc_called(this, "_ZN7S2226C83v77Ev");}
S2226C8 ::S2226C8(){ note_ctor("S2226C8", this);} // tgen

static void Test_S2226C8()
{
  extern Class_Descriptor cd_S2226C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2226C8, buf);
    S2226C8 *dp, &lv = *(dp=new (buf) S2226C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2226C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2226C8)");
    test_class_info(&lv, &cd_S2226C8);
    dp->~S2226C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2226C8(Test_S2226C8, "S2226C8", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2226C8C1Ev();
extern void _ZN7S2226C8D1Ev();
Name_Map name_map_S2226C8[] = {
  NSPAIR(_ZN7S2226C8C1Ev),
  NSPAIR(_ZN7S2226C8D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2226C8[];
extern void _ZN7S2226C8D1Ev();
extern void _ZN7S2226C8D0Ev();
extern void _ZN7S2226C83v76Ev();
extern void _ZN7S2226C83v77Ev();
static  VTBL_ENTRY vtc_S2226C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2226C8[0]),
  (VTBL_ENTRY)&_ZN7S2226C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2226C8D0Ev,
  (VTBL_ENTRY)&_ZN7S2226C83v76Ev,
  (VTBL_ENTRY)&_ZN7S2226C83v77Ev,
};
extern VTBL_ENTRY _ZTI7S2226C8[];
extern  VTBL_ENTRY _ZTV7S2226C8[];
Class_Descriptor cd_S2226C8 = {  "S2226C8", // class name
  0,0,//no base classes
  &(vtc_S2226C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2226C8),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2226C8),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2226C10  {
  __tsi64 s2226c10f0;
  __tsi64 s2226c10f1;
  int s2226c10f2;
  int s2226c10f3;
  void  mf2226c10(); // _ZN8S2226C109mf2226c10Ev
};
//SIG(-1 S2226C10) C1{ m FL[2] Fi[2]}


void  S2226C10 ::mf2226c10(){}

static void Test_S2226C10()
{
  {
    init_simple_test("S2226C10");
    S2226C10 lv;
    check2(sizeof(lv), 24, "sizeof(S2226C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2226C10)");
    check_field_offset(lv, s2226c10f0, 0, "S2226C10.s2226c10f0");
    check_field_offset(lv, s2226c10f1, 8, "S2226C10.s2226c10f1");
    check_field_offset(lv, s2226c10f2, 16, "S2226C10.s2226c10f2");
    check_field_offset(lv, s2226c10f3, 20, "S2226C10.s2226c10f3");
  }
}
static Arrange_To_Call_Me vS2226C10(Test_S2226C10, "S2226C10", 24);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2226C11  {
  char s2226c11f0[8];
  __tsi64 s2226c11f1;
  __tsi64 s2226c11f2;
  __tsi64 s2226c11f3;
  __tsi64 s2226c11f4;
  __tsi64 s2226c11f5;
  int s2226c11f6;
  int s2226c11f7;
  void  mf2226c11(); // _ZN8S2226C119mf2226c11Ev
};
//SIG(-1 S2226C11) C1{ m Fc[8] FL[5] Fi[2]}


void  S2226C11 ::mf2226c11(){}

static void Test_S2226C11()
{
  {
    init_simple_test("S2226C11");
    S2226C11 lv;
    check2(sizeof(lv), 56, "sizeof(S2226C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2226C11)");
    check_field_offset(lv, s2226c11f0, 0, "S2226C11.s2226c11f0");
    check_field_offset(lv, s2226c11f1, 8, "S2226C11.s2226c11f1");
    check_field_offset(lv, s2226c11f2, 16, "S2226C11.s2226c11f2");
    check_field_offset(lv, s2226c11f3, 24, "S2226C11.s2226c11f3");
    check_field_offset(lv, s2226c11f4, 32, "S2226C11.s2226c11f4");
    check_field_offset(lv, s2226c11f5, 40, "S2226C11.s2226c11f5");
    check_field_offset(lv, s2226c11f6, 48, "S2226C11.s2226c11f6");
    check_field_offset(lv, s2226c11f7, 52, "S2226C11.s2226c11f7");
  }
}
static Arrange_To_Call_Me vS2226C11(Test_S2226C11, "S2226C11", 56);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2226C9  {
  char s2226c9f0[2];
  void *s2226c9f1;
  __tsi64 s2226c9f2;
  ::S2226C10 s2226c9f3;
  __tsi64 s2226c9f4[4];
  ::S2226C10 s2226c9f5;
  __tsi64 s2226c9f6;
  ::S2226C10 s2226c9f7;
  char s2226c9f8;
  ::S2226C11 s2226c9f9;
  int s2226c9f10;
  void  mf2226c9(); // _ZN7S2226C98mf2226c9Ev
  virtual  ~S2226C9(); // _ZN7S2226C9D1Ev
  S2226C9(); // tgen
};
//SIG(-1 S2226C9) C1{ vd m Fc[2] Fp FL FC2{ m FL[2] Fi[2]} FL[4] FC2 FL FC2 Fc FC3{ m Fc[8] FL[5] Fi[2]} Fi}


void  S2226C9 ::mf2226c9(){}
 S2226C9 ::~S2226C9(){ note_dtor("S2226C9", this);}
S2226C9 ::S2226C9(){ note_ctor("S2226C9", this);} // tgen

static void Test_S2226C9()
{
  extern Class_Descriptor cd_S2226C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(28,50)];
    init_test(&cd_S2226C9, buf);
    S2226C9 *dp, &lv = *(dp=new (buf) S2226C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(216,196), "sizeof(S2226C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2226C9)");
    check_field_offset(lv, s2226c9f0, ABISELECT(8,4), "S2226C9.s2226c9f0");
    check_field_offset(lv, s2226c9f1, ABISELECT(16,8), "S2226C9.s2226c9f1");
    check_field_offset(lv, s2226c9f2, ABISELECT(24,12), "S2226C9.s2226c9f2");
    check_field_offset(lv, s2226c9f3, ABISELECT(32,20), "S2226C9.s2226c9f3");
    check_field_offset(lv, s2226c9f4, ABISELECT(56,44), "S2226C9.s2226c9f4");
    check_field_offset(lv, s2226c9f5, ABISELECT(88,76), "S2226C9.s2226c9f5");
    check_field_offset(lv, s2226c9f6, ABISELECT(112,100), "S2226C9.s2226c9f6");
    check_field_offset(lv, s2226c9f7, ABISELECT(120,108), "S2226C9.s2226c9f7");
    check_field_offset(lv, s2226c9f8, ABISELECT(144,132), "S2226C9.s2226c9f8");
    check_field_offset(lv, s2226c9f9, ABISELECT(152,136), "S2226C9.s2226c9f9");
    check_field_offset(lv, s2226c9f10, ABISELECT(208,192), "S2226C9.s2226c9f10");
    test_class_info(&lv, &cd_S2226C9);
    dp->~S2226C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2226C9(Test_S2226C9, "S2226C9", ABISELECT(216,196));

#else // __cplusplus

extern void _ZN7S2226C9C1Ev();
extern void _ZN7S2226C9D1Ev();
Name_Map name_map_S2226C9[] = {
  NSPAIR(_ZN7S2226C9C1Ev),
  NSPAIR(_ZN7S2226C9D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2226C9[];
extern void _ZN7S2226C9D1Ev();
extern void _ZN7S2226C9D0Ev();
static  VTBL_ENTRY vtc_S2226C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2226C9[0]),
  (VTBL_ENTRY)&_ZN7S2226C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2226C9D0Ev,
};
extern VTBL_ENTRY _ZTI7S2226C9[];
extern  VTBL_ENTRY _ZTV7S2226C9[];
Class_Descriptor cd_S2226C9 = {  "S2226C9", // class name
  0,0,//no base classes
  &(vtc_S2226C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(216,196), // object size
  NSPAIRA(_ZTI7S2226C9),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2226C9),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2226C12  {
  void *s2226c12f0[2];
  int s2226c12f1;
  void *s2226c12f2;
  int s2226c12f3[2];
  char s2226c12f4[256];
  int s2226c12f5;
  char s2226c12f6[3];
  int s2226c12f7;
  char s2226c12f8;
  void  mf2226c12(); // _ZN8S2226C129mf2226c12Ev
};
//SIG(-1 S2226C12) C1{ m Fp[2] Fi Fp Fi[2] Fc[256] Fi Fc[3] Fi Fc}


void  S2226C12 ::mf2226c12(){}

static void Test_S2226C12()
{
  {
    init_simple_test("S2226C12");
    S2226C12 lv;
    check2(sizeof(lv), ABISELECT(312,296), "sizeof(S2226C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2226C12)");
    check_field_offset(lv, s2226c12f0, 0, "S2226C12.s2226c12f0");
    check_field_offset(lv, s2226c12f1, ABISELECT(16,8), "S2226C12.s2226c12f1");
    check_field_offset(lv, s2226c12f2, ABISELECT(24,12), "S2226C12.s2226c12f2");
    check_field_offset(lv, s2226c12f3, ABISELECT(32,16), "S2226C12.s2226c12f3");
    check_field_offset(lv, s2226c12f4, ABISELECT(40,24), "S2226C12.s2226c12f4");
    check_field_offset(lv, s2226c12f5, ABISELECT(296,280), "S2226C12.s2226c12f5");
    check_field_offset(lv, s2226c12f6, ABISELECT(300,284), "S2226C12.s2226c12f6");
    check_field_offset(lv, s2226c12f7, ABISELECT(304,288), "S2226C12.s2226c12f7");
    check_field_offset(lv, s2226c12f8, ABISELECT(308,292), "S2226C12.s2226c12f8");
  }
}
static Arrange_To_Call_Me vS2226C12(Test_S2226C12, "S2226C12", ABISELECT(312,296));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2226C14  {
  ::S2226C10 s2226c14f0;
  int s2226c14f1[2];
  void  mf2226c14(); // _ZN8S2226C149mf2226c14Ev
};
//SIG(-1 S2226C14) C1{ m FC2{ m FL[2] Fi[2]} Fi[2]}


void  S2226C14 ::mf2226c14(){}

static void Test_S2226C14()
{
  {
    init_simple_test("S2226C14");
    S2226C14 lv;
    check2(sizeof(lv), 32, "sizeof(S2226C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2226C14)");
    check_field_offset(lv, s2226c14f0, 0, "S2226C14.s2226c14f0");
    check_field_offset(lv, s2226c14f1, 24, "S2226C14.s2226c14f1");
  }
}
static Arrange_To_Call_Me vS2226C14(Test_S2226C14, "S2226C14", 32);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2226C13  {
  void *s2226c13f0;
  int s2226c13f1[3];
  ::S2226C14 s2226c13f2;
  ::S2226C14 s2226c13f3;
  void  mf2226c13(); // _ZN8S2226C139mf2226c13Ev
  virtual  ~S2226C13(); // _ZN8S2226C13D1Ev
  S2226C13(); // tgen
};
//SIG(-1 S2226C13) C1{ vd m Fp Fi[3] FC2{ m FC3{ m FL[2] Fi[2]} Fi[2]} FC2}


void  S2226C13 ::mf2226c13(){}
 S2226C13 ::~S2226C13(){ note_dtor("S2226C13", this);}
S2226C13 ::S2226C13(){ note_ctor("S2226C13", this);} // tgen

static void Test_S2226C13()
{
  extern Class_Descriptor cd_S2226C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,22)];
    init_test(&cd_S2226C13, buf);
    S2226C13 *dp, &lv = *(dp=new (buf) S2226C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,84), "sizeof(S2226C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2226C13)");
    check_field_offset(lv, s2226c13f0, ABISELECT(8,4), "S2226C13.s2226c13f0");
    check_field_offset(lv, s2226c13f1, ABISELECT(16,8), "S2226C13.s2226c13f1");
    check_field_offset(lv, s2226c13f2, ABISELECT(32,20), "S2226C13.s2226c13f2");
    check_field_offset(lv, s2226c13f3, ABISELECT(64,52), "S2226C13.s2226c13f3");
    test_class_info(&lv, &cd_S2226C13);
    dp->~S2226C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2226C13(Test_S2226C13, "S2226C13", ABISELECT(96,84));

#else // __cplusplus

extern void _ZN8S2226C13C1Ev();
extern void _ZN8S2226C13D1Ev();
Name_Map name_map_S2226C13[] = {
  NSPAIR(_ZN8S2226C13C1Ev),
  NSPAIR(_ZN8S2226C13D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2226C13[];
extern void _ZN8S2226C13D1Ev();
extern void _ZN8S2226C13D0Ev();
static  VTBL_ENTRY vtc_S2226C13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2226C13[0]),
  (VTBL_ENTRY)&_ZN8S2226C13D1Ev,
  (VTBL_ENTRY)&_ZN8S2226C13D0Ev,
};
extern VTBL_ENTRY _ZTI8S2226C13[];
extern  VTBL_ENTRY _ZTV8S2226C13[];
Class_Descriptor cd_S2226C13 = {  "S2226C13", // class name
  0,0,//no base classes
  &(vtc_S2226C13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,84), // object size
  NSPAIRA(_ZTI8S2226C13),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2226C13),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2226C16  {
  int s2226c16f0;
  int s2226c16f1;
};
//SIG(1 S2226C16) C1{ Fi[2]}



static void Test_S2226C16()
{
  {
    init_simple_test("S2226C16");
    S2226C16 lv;
    check2(sizeof(lv), 8, "sizeof(S2226C16)");
    check2(__alignof__(lv), 4, "__alignof__(S2226C16)");
    check_field_offset(lv, s2226c16f0, 0, "S2226C16.s2226c16f0");
    check_field_offset(lv, s2226c16f1, 4, "S2226C16.s2226c16f1");
  }
}
static Arrange_To_Call_Me vS2226C16(Test_S2226C16, "S2226C16", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S2226C15  {
  ::S2226C16 s2226c15f0;
  __tsi64 s2226c15f1;
};
//SIG(1 S2226C15) U1{ FC2{ Fi Fi} FL}

#endif // __cplusplus
#ifdef __cplusplus

struct  S2226C17  {
  ::S2226C10 s2226c17f0;
  int s2226c17f1;
  void  mf2226c17(); // _ZN8S2226C179mf2226c17Ev
};
//SIG(-1 S2226C17) C1{ m FC2{ m FL[2] Fi[2]} Fi}


void  S2226C17 ::mf2226c17(){}

static void Test_S2226C17()
{
  {
    init_simple_test("S2226C17");
    S2226C17 lv;
    check2(sizeof(lv), ABISELECT(32,28), "sizeof(S2226C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2226C17)");
    check_field_offset(lv, s2226c17f0, 0, "S2226C17.s2226c17f0");
    check_field_offset(lv, s2226c17f1, 24, "S2226C17.s2226c17f1");
  }
}
static Arrange_To_Call_Me vS2226C17(Test_S2226C17, "S2226C17", ABISELECT(32,28));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2226C1  : S2226C2 , S2226C7_nt , S2226C8 {
  void *s2226c1f0;
  ::S2226C9 s2226c1f1;
  int s2226c1f2;
  char s2226c1f3;
  void *s2226c1f4;
  ::S2226C12 s2226c1f5;
  int s2226c1f6[2];
  __tsi64 s2226c1f7;
  int s2226c1f8;
  __tsi64 s2226c1f9;
  char s2226c1f10[2];
  int s2226c1f11[3];
  ::S2226C13 s2226c1f12;
  int s2226c1f13;
  ::S2226C15 s2226c1f14;
  void *s2226c1f15;
  char s2226c1f16;
  ::S2226C17 s2226c1f17;
  virtual  ~S2226C1(); // _ZN7S2226C1D1Ev
  virtual void  v1(); // _ZN7S2226C12v1Ev
  virtual void  v2(); // _ZN7S2226C12v2Ev
  virtual void  v3(); // _ZN7S2226C12v3Ev
  virtual void  v4(); // _ZN7S2226C12v4Ev
  virtual void  v5(); // _ZN7S2226C12v5Ev
  virtual void  v6(); // _ZN7S2226C12v6Ev
  virtual void  v7(); // _ZN7S2226C12v7Ev
  virtual void  v8(); // _ZN7S2226C12v8Ev
  virtual void  v9(); // _ZN7S2226C12v9Ev
  virtual void  v10(); // _ZN7S2226C13v10Ev
  virtual void  v11(); // _ZN7S2226C13v11Ev
  virtual void  v12(); // _ZN7S2226C13v12Ev
  virtual void  v13(); // _ZN7S2226C13v13Ev
  virtual void  v14(); // _ZN7S2226C13v14Ev
  virtual void  v15(); // _ZN7S2226C13v15Ev
  virtual void  v16(); // _ZN7S2226C13v16Ev
  virtual void  v17(); // _ZN7S2226C13v17Ev
  virtual void  v18(); // _ZN7S2226C13v18Ev
  virtual void  v19(); // _ZN7S2226C13v19Ev
  virtual void  v20(); // _ZN7S2226C13v20Ev
  virtual void  v21(); // _ZN7S2226C13v21Ev
  virtual void  v22(); // _ZN7S2226C13v22Ev
  virtual void  v23(); // _ZN7S2226C13v23Ev
  virtual void  v24(); // _ZN7S2226C13v24Ev
  virtual void  v25(); // _ZN7S2226C13v25Ev
  virtual void  v26(); // _ZN7S2226C13v26Ev
  virtual void  v27(); // _ZN7S2226C13v27Ev
  virtual void  v28(); // _ZN7S2226C13v28Ev
  virtual void  v29(); // _ZN7S2226C13v29Ev
  virtual void  v30(); // _ZN7S2226C13v30Ev
  virtual void  v31(); // _ZN7S2226C13v31Ev
  virtual void  v32(); // _ZN7S2226C13v32Ev
  virtual void  v33(); // _ZN7S2226C13v33Ev
  virtual void  v34(); // _ZN7S2226C13v34Ev
  virtual void  v35(); // _ZN7S2226C13v35Ev
  virtual void  v36(); // _ZN7S2226C13v36Ev
  virtual void  v37(); // _ZN7S2226C13v37Ev
  S2226C1(); // tgen
};
//SIG(1 S2226C1) C1{ BC2{ BC3{ BC4{ vd v38 v39 v40 v41} vd v42 v43 v44 v45 v46} BC5{ BC6{ vd v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 Fc[1024] Fi[2]} vd v60 v61 v62 v63} vd v64 v65 v66 v67 v68 v69 v70 v71 v72 v73} BC7{ vd v74 v75} BC8{ vd v76 v77} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 Fp FC9{ vd m Fc[2] Fp FL FC10{ m FL[2] Fi[2]} FL[4] FC10 FL FC10 Fc FC11{ m Fc[8] FL[5] Fi[2]} Fi} Fi Fc Fp FC12{ m Fp[2] Fi Fp Fi[2] Fc[256] Fi Fc[3] Fi Fc} Fi[2] FL Fi FL Fc[2] Fi[3] FC13{ vd m Fp Fi[3] FC14{ m FC10 Fi[2]} FC14} Fi FU15{ FC16{ Fi Fi} FL} Fp Fc FC17{ m FC10 Fi}}


 S2226C1 ::~S2226C1(){ note_dtor("S2226C1", this);}
void  S2226C1 ::v1(){vfunc_called(this, "_ZN7S2226C12v1Ev");}
void  S2226C1 ::v2(){vfunc_called(this, "_ZN7S2226C12v2Ev");}
void  S2226C1 ::v3(){vfunc_called(this, "_ZN7S2226C12v3Ev");}
void  S2226C1 ::v4(){vfunc_called(this, "_ZN7S2226C12v4Ev");}
void  S2226C1 ::v5(){vfunc_called(this, "_ZN7S2226C12v5Ev");}
void  S2226C1 ::v6(){vfunc_called(this, "_ZN7S2226C12v6Ev");}
void  S2226C1 ::v7(){vfunc_called(this, "_ZN7S2226C12v7Ev");}
void  S2226C1 ::v8(){vfunc_called(this, "_ZN7S2226C12v8Ev");}
void  S2226C1 ::v9(){vfunc_called(this, "_ZN7S2226C12v9Ev");}
void  S2226C1 ::v10(){vfunc_called(this, "_ZN7S2226C13v10Ev");}
void  S2226C1 ::v11(){vfunc_called(this, "_ZN7S2226C13v11Ev");}
void  S2226C1 ::v12(){vfunc_called(this, "_ZN7S2226C13v12Ev");}
void  S2226C1 ::v13(){vfunc_called(this, "_ZN7S2226C13v13Ev");}
void  S2226C1 ::v14(){vfunc_called(this, "_ZN7S2226C13v14Ev");}
void  S2226C1 ::v15(){vfunc_called(this, "_ZN7S2226C13v15Ev");}
void  S2226C1 ::v16(){vfunc_called(this, "_ZN7S2226C13v16Ev");}
void  S2226C1 ::v17(){vfunc_called(this, "_ZN7S2226C13v17Ev");}
void  S2226C1 ::v18(){vfunc_called(this, "_ZN7S2226C13v18Ev");}
void  S2226C1 ::v19(){vfunc_called(this, "_ZN7S2226C13v19Ev");}
void  S2226C1 ::v20(){vfunc_called(this, "_ZN7S2226C13v20Ev");}
void  S2226C1 ::v21(){vfunc_called(this, "_ZN7S2226C13v21Ev");}
void  S2226C1 ::v22(){vfunc_called(this, "_ZN7S2226C13v22Ev");}
void  S2226C1 ::v23(){vfunc_called(this, "_ZN7S2226C13v23Ev");}
void  S2226C1 ::v24(){vfunc_called(this, "_ZN7S2226C13v24Ev");}
void  S2226C1 ::v25(){vfunc_called(this, "_ZN7S2226C13v25Ev");}
void  S2226C1 ::v26(){vfunc_called(this, "_ZN7S2226C13v26Ev");}
void  S2226C1 ::v27(){vfunc_called(this, "_ZN7S2226C13v27Ev");}
void  S2226C1 ::v28(){vfunc_called(this, "_ZN7S2226C13v28Ev");}
void  S2226C1 ::v29(){vfunc_called(this, "_ZN7S2226C13v29Ev");}
void  S2226C1 ::v30(){vfunc_called(this, "_ZN7S2226C13v30Ev");}
void  S2226C1 ::v31(){vfunc_called(this, "_ZN7S2226C13v31Ev");}
void  S2226C1 ::v32(){vfunc_called(this, "_ZN7S2226C13v32Ev");}
void  S2226C1 ::v33(){vfunc_called(this, "_ZN7S2226C13v33Ev");}
void  S2226C1 ::v34(){vfunc_called(this, "_ZN7S2226C13v34Ev");}
void  S2226C1 ::v35(){vfunc_called(this, "_ZN7S2226C13v35Ev");}
void  S2226C1 ::v36(){vfunc_called(this, "_ZN7S2226C13v36Ev");}
void  S2226C1 ::v37(){vfunc_called(this, "_ZN7S2226C13v37Ev");}
S2226C1 ::S2226C1(){ note_ctor("S2226C1", this);} // tgen

static void Test_S2226C1()
{
  extern Class_Descriptor cd_S2226C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(229,434)];
    init_test(&cd_S2226C1, buf);
    S2226C1 *dp, &lv = *(dp=new (buf) S2226C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1824,1732), "sizeof(S2226C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2226C1)");
    check_base_class_offset(lv, (S2226C4_nt*)(S2226C3*)(S2226C2*), 0, "S2226C1");
    check_base_class_offset(lv, (S2226C3*)(S2226C2*), 0, "S2226C1");
    check_base_class_offset(lv, (S2226C6*)(S2226C5*)(S2226C2*), ABISELECT(8,4), "S2226C1");
    check_base_class_offset(lv, (S2226C5*)(S2226C2*), ABISELECT(8,4), "S2226C1");
    check_base_class_offset(lv, (S2226C2*), 0, "S2226C1");
    check_base_class_offset(lv, (S2226C7_nt*), ABISELECT(1048,1040), "S2226C1");
    check_base_class_offset(lv, (S2226C8*), ABISELECT(1056,1044), "S2226C1");
    check_field_offset(lv, s2226c1f0, ABISELECT(1064,1048), "S2226C1.s2226c1f0");
    check_field_offset(lv, s2226c1f1, ABISELECT(1072,1052), "S2226C1.s2226c1f1");
    check_field_offset(lv, s2226c1f2, ABISELECT(1288,1248), "S2226C1.s2226c1f2");
    check_field_offset(lv, s2226c1f3, ABISELECT(1292,1252), "S2226C1.s2226c1f3");
    check_field_offset(lv, s2226c1f4, ABISELECT(1296,1256), "S2226C1.s2226c1f4");
    check_field_offset(lv, s2226c1f5, ABISELECT(1304,1260), "S2226C1.s2226c1f5");
    check_field_offset(lv, s2226c1f6, ABISELECT(1616,1556), "S2226C1.s2226c1f6");
    check_field_offset(lv, s2226c1f7, ABISELECT(1624,1564), "S2226C1.s2226c1f7");
    check_field_offset(lv, s2226c1f8, ABISELECT(1632,1572), "S2226C1.s2226c1f8");
    check_field_offset(lv, s2226c1f9, ABISELECT(1640,1576), "S2226C1.s2226c1f9");
    check_field_offset(lv, s2226c1f10, ABISELECT(1648,1584), "S2226C1.s2226c1f10");
    check_field_offset(lv, s2226c1f11, ABISELECT(1652,1588), "S2226C1.s2226c1f11");
    check_field_offset(lv, s2226c1f12, ABISELECT(1664,1600), "S2226C1.s2226c1f12");
    check_field_offset(lv, s2226c1f13, ABISELECT(1760,1684), "S2226C1.s2226c1f13");
    check_field_offset(lv, s2226c1f14, ABISELECT(1768,1688), "S2226C1.s2226c1f14");
    check_field_offset(lv, s2226c1f15, ABISELECT(1776,1696), "S2226C1.s2226c1f15");
    check_field_offset(lv, s2226c1f16, ABISELECT(1784,1700), "S2226C1.s2226c1f16");
    check_field_offset(lv, s2226c1f17, ABISELECT(1792,1704), "S2226C1.s2226c1f17");
    test_class_info(&lv, &cd_S2226C1);
    dp->~S2226C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2226C1(Test_S2226C1, "S2226C1", ABISELECT(1824,1732));

#else // __cplusplus

extern void _ZN7S2226C1C1Ev();
extern void _ZN7S2226C1D1Ev();
Name_Map name_map_S2226C1[] = {
  NSPAIR(_ZN7S2226C1C1Ev),
  NSPAIR(_ZN7S2226C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2226C4_nt;
extern VTBL_ENTRY _ZTI10S2226C4_nt[];
extern  VTBL_ENTRY _ZTV10S2226C4_nt[];
extern Class_Descriptor cd_S2226C3;
extern VTBL_ENTRY _ZTI7S2226C3[];
extern  VTBL_ENTRY _ZTV7S2226C3[];
extern Class_Descriptor cd_S2226C6;
extern VTBL_ENTRY _ZTI7S2226C6[];
extern  VTBL_ENTRY _ZTV7S2226C6[];
extern Class_Descriptor cd_S2226C5;
extern VTBL_ENTRY _ZTI7S2226C5[];
extern  VTBL_ENTRY _ZTV7S2226C5[];
extern Class_Descriptor cd_S2226C2;
extern VTBL_ENTRY _ZTI7S2226C2[];
extern  VTBL_ENTRY _ZTV7S2226C2[];
extern Class_Descriptor cd_S2226C7_nt;
extern VTBL_ENTRY _ZTI10S2226C7_nt[];
extern  VTBL_ENTRY _ZTV10S2226C7_nt[];
extern Class_Descriptor cd_S2226C8;
extern VTBL_ENTRY _ZTI7S2226C8[];
extern  VTBL_ENTRY _ZTV7S2226C8[];
static Base_Class bases_S2226C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2226C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2226C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2226C6,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2226C5,    ABISELECT(8,4), //bcp->offset
    60, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2226C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2226C7_nt,    ABISELECT(1048,1040), //bcp->offset
    81, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2226C8,    ABISELECT(1056,1044), //bcp->offset
    87, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2226C1[];
extern void _ZN7S2226C1D1Ev();
extern void _ZN7S2226C1D0Ev();
extern void _ZN10S2226C4_nt3v38Ev();
extern void _ZN10S2226C4_nt3v39Ev();
extern void _ZN10S2226C4_nt3v40Ev();
extern void _ZN10S2226C4_nt3v41Ev();
extern void _ZN7S2226C33v42Ev();
extern void _ZN7S2226C33v43Ev();
extern void _ZN7S2226C33v44Ev();
extern void _ZN7S2226C33v45Ev();
extern void _ZN7S2226C33v46Ev();
extern void _ZN7S2226C23v64Ev();
extern void _ZN7S2226C23v65Ev();
extern void _ZN7S2226C23v66Ev();
extern void _ZN7S2226C23v67Ev();
extern void _ZN7S2226C23v68Ev();
extern void _ZN7S2226C23v69Ev();
extern void _ZN7S2226C23v70Ev();
extern void _ZN7S2226C23v71Ev();
extern void _ZN7S2226C23v72Ev();
extern void _ZN7S2226C23v73Ev();
extern void _ZN7S2226C12v1Ev();
extern void _ZN7S2226C12v2Ev();
extern void _ZN7S2226C12v3Ev();
extern void _ZN7S2226C12v4Ev();
extern void _ZN7S2226C12v5Ev();
extern void _ZN7S2226C12v6Ev();
extern void _ZN7S2226C12v7Ev();
extern void _ZN7S2226C12v8Ev();
extern void _ZN7S2226C12v9Ev();
extern void _ZN7S2226C13v10Ev();
extern void _ZN7S2226C13v11Ev();
extern void _ZN7S2226C13v12Ev();
extern void _ZN7S2226C13v13Ev();
extern void _ZN7S2226C13v14Ev();
extern void _ZN7S2226C13v15Ev();
extern void _ZN7S2226C13v16Ev();
extern void _ZN7S2226C13v17Ev();
extern void _ZN7S2226C13v18Ev();
extern void _ZN7S2226C13v19Ev();
extern void _ZN7S2226C13v20Ev();
extern void _ZN7S2226C13v21Ev();
extern void _ZN7S2226C13v22Ev();
extern void _ZN7S2226C13v23Ev();
extern void _ZN7S2226C13v24Ev();
extern void _ZN7S2226C13v25Ev();
extern void _ZN7S2226C13v26Ev();
extern void _ZN7S2226C13v27Ev();
extern void _ZN7S2226C13v28Ev();
extern void _ZN7S2226C13v29Ev();
extern void _ZN7S2226C13v30Ev();
extern void _ZN7S2226C13v31Ev();
extern void _ZN7S2226C13v32Ev();
extern void _ZN7S2226C13v33Ev();
extern void _ZN7S2226C13v34Ev();
extern void _ZN7S2226C13v35Ev();
extern void _ZN7S2226C13v36Ev();
extern void _ZN7S2226C13v37Ev();
extern void ABISELECT(_ZThn8_N7S2226C1D1Ev,_ZThn4_N7S2226C1D1Ev)();
extern void ABISELECT(_ZThn8_N7S2226C1D0Ev,_ZThn4_N7S2226C1D0Ev)();
extern void _ZN7S2226C63v47Ev();
extern void _ZN7S2226C63v48Ev();
extern void _ZN7S2226C63v49Ev();
extern void _ZN7S2226C63v50Ev();
extern void _ZN7S2226C63v51Ev();
extern void _ZN7S2226C63v52Ev();
extern void _ZN7S2226C63v53Ev();
extern void _ZN7S2226C63v54Ev();
extern void _ZN7S2226C63v55Ev();
extern void _ZN7S2226C63v56Ev();
extern void _ZN7S2226C63v57Ev();
extern void _ZN7S2226C63v58Ev();
extern void _ZN7S2226C63v59Ev();
extern void _ZN7S2226C53v60Ev();
extern void _ZN7S2226C53v61Ev();
extern void _ZN7S2226C53v62Ev();
extern void _ZN7S2226C53v63Ev();
extern void ABISELECT(_ZThn1048_N7S2226C1D1Ev,_ZThn1040_N7S2226C1D1Ev)();
extern void ABISELECT(_ZThn1048_N7S2226C1D0Ev,_ZThn1040_N7S2226C1D0Ev)();
extern void _ZN10S2226C7_nt3v74Ev();
extern void _ZN10S2226C7_nt3v75Ev();
extern void ABISELECT(_ZThn1056_N7S2226C1D1Ev,_ZThn1044_N7S2226C1D1Ev)();
extern void ABISELECT(_ZThn1056_N7S2226C1D0Ev,_ZThn1044_N7S2226C1D0Ev)();
extern void _ZN7S2226C83v76Ev();
extern void _ZN7S2226C83v77Ev();
static  VTBL_ENTRY vtc_S2226C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2226C1[0]),
  (VTBL_ENTRY)&_ZN7S2226C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2226C1D0Ev,
  (VTBL_ENTRY)&_ZN10S2226C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2226C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2226C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2226C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN7S2226C33v42Ev,
  (VTBL_ENTRY)&_ZN7S2226C33v43Ev,
  (VTBL_ENTRY)&_ZN7S2226C33v44Ev,
  (VTBL_ENTRY)&_ZN7S2226C33v45Ev,
  (VTBL_ENTRY)&_ZN7S2226C33v46Ev,
  (VTBL_ENTRY)&_ZN7S2226C23v64Ev,
  (VTBL_ENTRY)&_ZN7S2226C23v65Ev,
  (VTBL_ENTRY)&_ZN7S2226C23v66Ev,
  (VTBL_ENTRY)&_ZN7S2226C23v67Ev,
  (VTBL_ENTRY)&_ZN7S2226C23v68Ev,
  (VTBL_ENTRY)&_ZN7S2226C23v69Ev,
  (VTBL_ENTRY)&_ZN7S2226C23v70Ev,
  (VTBL_ENTRY)&_ZN7S2226C23v71Ev,
  (VTBL_ENTRY)&_ZN7S2226C23v72Ev,
  (VTBL_ENTRY)&_ZN7S2226C23v73Ev,
  (VTBL_ENTRY)&_ZN7S2226C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2226C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2226C12v3Ev,
  (VTBL_ENTRY)&_ZN7S2226C12v4Ev,
  (VTBL_ENTRY)&_ZN7S2226C12v5Ev,
  (VTBL_ENTRY)&_ZN7S2226C12v6Ev,
  (VTBL_ENTRY)&_ZN7S2226C12v7Ev,
  (VTBL_ENTRY)&_ZN7S2226C12v8Ev,
  (VTBL_ENTRY)&_ZN7S2226C12v9Ev,
  (VTBL_ENTRY)&_ZN7S2226C13v10Ev,
  (VTBL_ENTRY)&_ZN7S2226C13v11Ev,
  (VTBL_ENTRY)&_ZN7S2226C13v12Ev,
  (VTBL_ENTRY)&_ZN7S2226C13v13Ev,
  (VTBL_ENTRY)&_ZN7S2226C13v14Ev,
  (VTBL_ENTRY)&_ZN7S2226C13v15Ev,
  (VTBL_ENTRY)&_ZN7S2226C13v16Ev,
  (VTBL_ENTRY)&_ZN7S2226C13v17Ev,
  (VTBL_ENTRY)&_ZN7S2226C13v18Ev,
  (VTBL_ENTRY)&_ZN7S2226C13v19Ev,
  (VTBL_ENTRY)&_ZN7S2226C13v20Ev,
  (VTBL_ENTRY)&_ZN7S2226C13v21Ev,
  (VTBL_ENTRY)&_ZN7S2226C13v22Ev,
  (VTBL_ENTRY)&_ZN7S2226C13v23Ev,
  (VTBL_ENTRY)&_ZN7S2226C13v24Ev,
  (VTBL_ENTRY)&_ZN7S2226C13v25Ev,
  (VTBL_ENTRY)&_ZN7S2226C13v26Ev,
  (VTBL_ENTRY)&_ZN7S2226C13v27Ev,
  (VTBL_ENTRY)&_ZN7S2226C13v28Ev,
  (VTBL_ENTRY)&_ZN7S2226C13v29Ev,
  (VTBL_ENTRY)&_ZN7S2226C13v30Ev,
  (VTBL_ENTRY)&_ZN7S2226C13v31Ev,
  (VTBL_ENTRY)&_ZN7S2226C13v32Ev,
  (VTBL_ENTRY)&_ZN7S2226C13v33Ev,
  (VTBL_ENTRY)&_ZN7S2226C13v34Ev,
  (VTBL_ENTRY)&_ZN7S2226C13v35Ev,
  (VTBL_ENTRY)&_ZN7S2226C13v36Ev,
  (VTBL_ENTRY)&_ZN7S2226C13v37Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S2226C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S2226C1D1Ev,_ZThn4_N7S2226C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S2226C1D0Ev,_ZThn4_N7S2226C1D0Ev),
  (VTBL_ENTRY)&_ZN7S2226C63v47Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v48Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v49Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v50Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v51Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v52Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v53Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v54Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v55Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v56Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v57Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v58Ev,
  (VTBL_ENTRY)&_ZN7S2226C63v59Ev,
  (VTBL_ENTRY)&_ZN7S2226C53v60Ev,
  (VTBL_ENTRY)&_ZN7S2226C53v61Ev,
  (VTBL_ENTRY)&_ZN7S2226C53v62Ev,
  (VTBL_ENTRY)&_ZN7S2226C53v63Ev,
  ABISELECT(-1048,-1040),
  (VTBL_ENTRY)&(_ZTI7S2226C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1048_N7S2226C1D1Ev,_ZThn1040_N7S2226C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1048_N7S2226C1D0Ev,_ZThn1040_N7S2226C1D0Ev),
  (VTBL_ENTRY)&_ZN10S2226C7_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2226C7_nt3v75Ev,
  ABISELECT(-1056,-1044),
  (VTBL_ENTRY)&(_ZTI7S2226C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1056_N7S2226C1D1Ev,_ZThn1044_N7S2226C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1056_N7S2226C1D0Ev,_ZThn1044_N7S2226C1D0Ev),
  (VTBL_ENTRY)&_ZN7S2226C83v76Ev,
  (VTBL_ENTRY)&_ZN7S2226C83v77Ev,
};
extern VTBL_ENTRY _ZTI7S2226C1[];
extern  VTBL_ENTRY _ZTV7S2226C1[];
Class_Descriptor cd_S2226C1 = {  "S2226C1", // class name
  bases_S2226C1, 7,
  &(vtc_S2226C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1824,1732), // object size
  NSPAIRA(_ZTI7S2226C1),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S2226C1),93, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  7, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20956C5  {
  __tsi64 s20956c5f0;
  int s20956c5f1[4];
  char s20956c5f2;
  __tsi64 s20956c5f3;
  void *s20956c5f4[2];
  void  mf20956c5(); // _ZN8S20956C59mf20956c5Ev
};
//SIG(-1 S20956C5) C1{ m FL Fi[4] Fc FL Fp[2]}


void  S20956C5 ::mf20956c5(){}

static void Test_S20956C5()
{
  {
    init_simple_test("S20956C5");
    S20956C5 lv;
    check2(sizeof(lv), ABISELECT(56,44), "sizeof(S20956C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20956C5)");
    check_field_offset(lv, s20956c5f0, 0, "S20956C5.s20956c5f0");
    check_field_offset(lv, s20956c5f1, 8, "S20956C5.s20956c5f1");
    check_field_offset(lv, s20956c5f2, 24, "S20956C5.s20956c5f2");
    check_field_offset(lv, s20956c5f3, ABISELECT(32,28), "S20956C5.s20956c5f3");
    check_field_offset(lv, s20956c5f4, ABISELECT(40,36), "S20956C5.s20956c5f4");
  }
}
static Arrange_To_Call_Me vS20956C5(Test_S20956C5, "S20956C5", ABISELECT(56,44));

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S20956C5[];
VTBL_ENTRY *P__ZTI8S20956C5 = _ZTI8S20956C5; 
Class_Descriptor cd_S20956C5 = {  "S20956C5", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(56,44), // object size
  NSPAIRA(_ZTI8S20956C5),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20956C4  : S20956C5 {
  int s20956c4f0;
  ::S20956C5 s20956c4f1;
  ::S20956C5 s20956c4f2;
  int s20956c4f3;
  void *s20956c4f4;
  __tsi64 s20956c4f5[6];
  void *s20956c4f6;
};
//SIG(-1 S20956C4) C1{ BC2{ m FL Fi[4] Fc FL Fp[2]} Fi FC2 FC2 Fi Fp FL[6] Fp}



static void Test_S20956C4()
{
  extern Class_Descriptor cd_S20956C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(32,50)];
    init_test(&cd_S20956C4, buf);
    S20956C4 &lv = *(new (buf) S20956C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(248,196), "sizeof(S20956C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20956C4)");
    check_base_class_offset(lv, (S20956C5*), 0, "S20956C4");
    check_field_offset(lv, s20956c4f0, ABISELECT(56,44), "S20956C4.s20956c4f0");
    check_field_offset(lv, s20956c4f1, ABISELECT(64,48), "S20956C4.s20956c4f1");
    check_field_offset(lv, s20956c4f2, ABISELECT(120,92), "S20956C4.s20956c4f2");
    check_field_offset(lv, s20956c4f3, ABISELECT(176,136), "S20956C4.s20956c4f3");
    check_field_offset(lv, s20956c4f4, ABISELECT(184,140), "S20956C4.s20956c4f4");
    check_field_offset(lv, s20956c4f5, ABISELECT(192,144), "S20956C4.s20956c4f5");
    check_field_offset(lv, s20956c4f6, ABISELECT(240,192), "S20956C4.s20956c4f6");
    test_class_info(&lv, &cd_S20956C4);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20956C4(Test_S20956C4, "S20956C4", ABISELECT(248,196));

#else // __cplusplus

extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
static Base_Class bases_S20956C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20956C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20956C4[];
Class_Descriptor cd_S20956C4 = {  "S20956C4", // class name
  bases_S20956C4, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(248,196), // object size
  NSPAIRA(_ZTI8S20956C4),ABISELECT(24,12), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20956C3  : virtual S20956C4 , virtual S20956C5 {
  ::S20956C5 s20956c3f0;
  short s20956c3f1;
  int s20956c3f2;
  ::S20956C4 s20956c3f3;
  __tsi64 s20956c3f4[4];
  ::S20956C4 s20956c3f5;
  ~S20956C3(); // tgen
  S20956C3(); // tgen
};
//SIG(-1 S20956C3) C1{ VBC2{ BC3{ m FL Fi[4] Fc FL Fp[2]} Fi FC3 FC3 Fi Fp FL[6] Fp} VBC3 FC3 Fs Fi FC2 FL[4] FC2}


S20956C3 ::~S20956C3(){ note_dtor("S20956C3", this);} // tgen
S20956C3 ::S20956C3(){ note_ctor("S20956C3", this);} // tgen

static void Test_S20956C3()
{
  extern Class_Descriptor cd_S20956C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(114,181)];
    init_test(&cd_S20956C3, buf);
    S20956C3 *dp, &lv = *(dp=new (buf) S20956C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(904,720), "sizeof(S20956C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20956C3)");
    check_base_class_offset(lv, (S20956C5*)(S20956C4*), ABISELECT(600,480), "S20956C3");
    check_base_class_offset(lv, (S20956C4*), ABISELECT(600,480), "S20956C3");
    /*is_ambiguous_... S20956C3::S20956C5 */ AMB_check_base_class_offset(lv, (S20956C5*), ABISELECT(848,676), "S20956C3");
    check_field_offset(lv, s20956c3f0, ABISELECT(8,4), "S20956C3.s20956c3f0");
    check_field_offset(lv, s20956c3f1, ABISELECT(64,48), "S20956C3.s20956c3f1");
    check_field_offset(lv, s20956c3f2, ABISELECT(68,52), "S20956C3.s20956c3f2");
    check_field_offset(lv, s20956c3f3, ABISELECT(72,56), "S20956C3.s20956c3f3");
    check_field_offset(lv, s20956c3f4, ABISELECT(320,252), "S20956C3.s20956c3f4");
    check_field_offset(lv, s20956c3f5, ABISELECT(352,284), "S20956C3.s20956c3f5");
    test_class_info(&lv, &cd_S20956C3);
    dp->~S20956C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20956C3(Test_S20956C3, "S20956C3", ABISELECT(904,720));

#else // __cplusplus

extern void _ZN8S20956C3C1Ev();
extern void _ZN8S20956C3D1Ev();
Name_Map name_map_S20956C3[] = {
  NSPAIR(_ZN8S20956C3C1Ev),
  NSPAIR(_ZN8S20956C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C4;
extern VTBL_ENTRY _ZTI8S20956C4[];
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
static Base_Class bases_S20956C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20956C5,    ABISELECT(600,480), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20956C4,    ABISELECT(600,480), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20956C5,    ABISELECT(848,676), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20956C3[];
static  VTBL_ENTRY vtc_S20956C3[] = {
  ABISELECT(848,676),
  ABISELECT(600,480),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C3[0]),
};
extern VTBL_ENTRY _ZTV8S20956C3[];
static  VTT_ENTRY vtt_S20956C3[] = {
  {&(_ZTV8S20956C3[4]),  4,4},
};
extern VTBL_ENTRY _ZTI8S20956C3[];
extern  VTBL_ENTRY _ZTV8S20956C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C3[];
Class_Descriptor cd_S20956C3 = {  "S20956C3", // class name
  bases_S20956C3, 3,
  &(vtc_S20956C3[0]), // expected_vtbl_contents
  &(vtt_S20956C3[0]), // expected_vtt_contents
  ABISELECT(904,720), // object size
  NSPAIRA(_ZTI8S20956C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S20956C3),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20956C3),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S20956C6  {
  int s20956c6f0[8];
  void *s20956c6f1;
  __tsi64 s20956c6f2;
  char s20956c6f3;
  void *s20956c6f4[5];
  long double s20956c6f5;
  char s20956c6f6[7];
  void *s20956c6f7;
  unsigned char s20956c6f8:1;
  int s20956c6f9;
  void  mf20956c6(); // _ZN8S20956C69mf20956c6Ev
};
//SIG(1 S20956C6) U1{ m Fi[8] Fp FL Fc Fp[5] FD Fc[7] Fp Fc:1 Fi}

#endif // __cplusplus
#ifdef __cplusplus

struct  S20956C2  : virtual S20956C3 , S20956C4 {
  int s20956c2f0[2];
  ::S20956C4 s20956c2f1;
  ::S20956C4 s20956c2f2[5];
  ::S20956C6 s20956c2f3;
  int s20956c2f4;
  ~S20956C2(); // tgen
  S20956C2(); // tgen
};
//SIG(-1 S20956C2) C1{ VBC2{ VBC3{ BC4{ m FL Fi[4] Fc FL Fp[2]} Fi FC4 FC4 Fi Fp FL[6] Fp} VBC4 FC4 Fs Fi FC3 FL[4] FC3} BC3 Fi[2] FC3 FC3[5] FU5{ m Fi[8] Fp FL Fc Fp[5] FD Fc[7] Fp Fc:1 Fi} Fi}


S20956C2 ::~S20956C2(){ note_dtor("S20956C2", this);} // tgen
S20956C2 ::S20956C2(){ note_ctor("S20956C2", this);} // tgen

static void Test_S20956C2()
{
  extern Class_Descriptor cd_S20956C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(171,536)];
    init_test(&cd_S20956C2, buf);
    S20956C2 *dp, &lv = *(dp=new (buf) S20956C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2720,2140), "sizeof(S20956C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20956C2)");
    /*is_ambiguous_... S20956C2::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C4*), ABISELECT(2416,1900), "S20956C2");
    check_base_class_offset(lv, (S20956C4*)(S20956C3*), ABISELECT(2416,1900), "S20956C2");
    /*is_ambiguous_... S20956C3::S20956C5 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C3*), ABISELECT(2664,2096), "S20956C2");
    check_base_class_offset(lv, (S20956C3*), ABISELECT(1816,1420), "S20956C2");
    /*is_ambiguous_... S20956C2::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C4*), ABISELECT(8,4), "S20956C2");
    /*is_ambiguous_... S20956C2::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C4*), ABISELECT(8,4), "S20956C2");
    check_field_offset(lv, s20956c2f0, ABISELECT(256,200), "S20956C2.s20956c2f0");
    check_field_offset(lv, s20956c2f1, ABISELECT(264,208), "S20956C2.s20956c2f1");
    check_field_offset(lv, s20956c2f2, ABISELECT(512,404), "S20956C2.s20956c2f2");
    check_field_offset(lv, s20956c2f3, ABISELECT(1760,1384), "S20956C2.s20956c2f3");
    check_field_offset(lv, s20956c2f4, ABISELECT(1808,1416), "S20956C2.s20956c2f4");
    test_class_info(&lv, &cd_S20956C2);
    dp->~S20956C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20956C2(Test_S20956C2, "S20956C2", ABISELECT(2720,2140));

#else // __cplusplus

extern void _ZN8S20956C2C1Ev();
extern void _ZN8S20956C2D1Ev();
Name_Map name_map_S20956C2[] = {
  NSPAIR(_ZN8S20956C2C1Ev),
  NSPAIR(_ZN8S20956C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C4;
extern VTBL_ENTRY _ZTI8S20956C4[];
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C3;
extern VTBL_ENTRY _ZTI8S20956C3[];
extern  VTBL_ENTRY _ZTV8S20956C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C3[];
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C4;
extern VTBL_ENTRY _ZTI8S20956C4[];
static Base_Class bases_S20956C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20956C5,    ABISELECT(2416,1900), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20956C4,    ABISELECT(2416,1900), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20956C5,    ABISELECT(2664,2096), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20956C3,    ABISELECT(1816,1420), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20956C5,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20956C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20956C2[];
static  VTBL_ENTRY vtc_S20956C2[] = {
  ABISELECT(2664,2096),
  ABISELECT(2416,1900),
  ABISELECT(1816,1420),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C2[0]),
  ABISELECT(848,676),
  ABISELECT(600,480),
  ABISELECT(-1816,-1420),
  (VTBL_ENTRY)&(_ZTI8S20956C2[0]),
};
extern VTBL_ENTRY _ZTV8S20956C2[];
static  VTBL_ENTRY _tg__ZTV8S20956C3__8S20956C2[] = {
  ABISELECT(848,676),
  ABISELECT(600,480),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C3[0]),
};
static  VTT_ENTRY vtt_S20956C2[] = {
  {&(_ZTV8S20956C2[5]),  5,9},
  {&(_ZTV8S20956C2[9]),  9,9},
  {&(_tg__ZTV8S20956C3__8S20956C2[4]),  4,4},
};
extern VTBL_ENTRY _ZTI8S20956C2[];
extern  VTBL_ENTRY _ZTV8S20956C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C2[];
Class_Descriptor cd_S20956C2 = {  "S20956C2", // class name
  bases_S20956C2, 6,
  &(vtc_S20956C2[0]), // expected_vtbl_contents
  &(vtt_S20956C2[0]), // expected_vtt_contents
  ABISELECT(2720,2140), // object size
  NSPAIRA(_ZTI8S20956C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S20956C2),9, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20956C2),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20956C8  : S20956C4 , virtual S20956C2 {
  ::S20956C2 s20956c8f0;
  ~S20956C8(); // tgen
  S20956C8(); // tgen
};
//SIG(-1 S20956C8) C1{ BC2{ BC3{ m FL Fi[4] Fc FL Fp[2]} Fi FC3 FC3 Fi Fp FL[6] Fp} VBC4{ VBC5{ VBC2 VBC3 FC3 Fs Fi FC2 FL[4] FC2} BC2 Fi[2] FC2 FC2[5] FU6{ m Fi[8] Fp FL Fc Fp[5] FD Fc[7] Fp Fc:1 Fi} Fi} FC4}


S20956C8 ::~S20956C8(){ note_dtor("S20956C8", this);} // tgen
S20956C8 ::S20956C8(){ note_ctor("S20956C8", this);} // tgen

static void Test_S20956C8()
{
  extern Class_Descriptor cd_S20956C8;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(357,1121)];
    init_test(&cd_S20956C8, buf);
    S20956C8 *dp, &lv = *(dp=new (buf) S20956C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(5696,4480), "sizeof(S20956C8)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20956C8)");
    /*is_ambiguous_... S20956C8::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C4*), ABISELECT(8,4), "S20956C8");
    /*is_ambiguous_... S20956C8::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C4*), ABISELECT(8,4), "S20956C8");
    /*is_ambiguous_... S20956C8::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C4*), ABISELECT(5392,4240), "S20956C8");
    check_base_class_offset(lv, (S20956C4*)(S20956C3*), ABISELECT(5392,4240), "S20956C8");
    /*is_ambiguous_... S20956C3::S20956C5 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C3*), ABISELECT(5640,4436), "S20956C8");
    check_base_class_offset(lv, (S20956C3*)(S20956C2*), ABISELECT(4792,3760), "S20956C8");
    /*is_ambiguous_... S20956C2::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C4*)(S20956C2*), ABISELECT(2984,2344), "S20956C8");
    /*is_ambiguous_... S20956C2::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C4*)(S20956C2*), ABISELECT(2984,2344), "S20956C8");
    check_base_class_offset(lv, (S20956C2*), ABISELECT(2976,2340), "S20956C8");
    check_field_offset(lv, s20956c8f0, ABISELECT(256,200), "S20956C8.s20956c8f0");
    test_class_info(&lv, &cd_S20956C8);
    dp->~S20956C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20956C8(Test_S20956C8, "S20956C8", ABISELECT(5696,4480));

#else // __cplusplus

extern void _ZN8S20956C8C1Ev();
extern void _ZN8S20956C8D1Ev();
Name_Map name_map_S20956C8[] = {
  NSPAIR(_ZN8S20956C8C1Ev),
  NSPAIR(_ZN8S20956C8D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C4;
extern VTBL_ENTRY _ZTI8S20956C4[];
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C4;
extern VTBL_ENTRY _ZTI8S20956C4[];
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C3;
extern VTBL_ENTRY _ZTI8S20956C3[];
extern  VTBL_ENTRY _ZTV8S20956C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C3[];
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C4;
extern VTBL_ENTRY _ZTI8S20956C4[];
extern Class_Descriptor cd_S20956C2;
extern VTBL_ENTRY _ZTI8S20956C2[];
extern  VTBL_ENTRY _ZTV8S20956C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C2[];
static Base_Class bases_S20956C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20956C5,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20956C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20956C5,    ABISELECT(5392,4240), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20956C4,    ABISELECT(5392,4240), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S20956C5,    ABISELECT(5640,4436), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S20956C3,    ABISELECT(4792,3760), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S20956C5,    ABISELECT(2984,2344), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20956C4,    ABISELECT(2984,2344), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20956C2,    ABISELECT(2976,2340), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20956C8[];
static  VTBL_ENTRY vtc_S20956C8[] = {
  ABISELECT(5640,4436),
  ABISELECT(5392,4240),
  ABISELECT(4792,3760),
  ABISELECT(2976,2340),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C8[0]),
  ABISELECT(2664,2096),
  ABISELECT(2416,1900),
  ABISELECT(1816,1420),
  ABISELECT(-2976,-2340),
  (VTBL_ENTRY)&(_ZTI8S20956C8[0]),
  ABISELECT(848,676),
  ABISELECT(600,480),
  ABISELECT(-4792,-3760),
  (VTBL_ENTRY)&(_ZTI8S20956C8[0]),
};
extern VTBL_ENTRY _ZTV8S20956C8[];
static  VTBL_ENTRY _tg__ZTV8S20956C2__8S20956C8[] = {
  ABISELECT(2664,2096),
  ABISELECT(2416,1900),
  ABISELECT(1816,1420),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C2[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20956C3__8S20956C2__8S20956C8[] = {
  ABISELECT(848,676),
  ABISELECT(600,480),
  ABISELECT(-1816,-1420),
  (VTBL_ENTRY)&(_ZTI8S20956C2[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20956C3__8S20956C8[] = {
  ABISELECT(848,676),
  ABISELECT(600,480),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C3[0]),
};
static  VTT_ENTRY vtt_S20956C8[] = {
  {&(_ZTV8S20956C8[6]),  6,15},
  {&(_ZTV8S20956C8[11]),  11,15},
  {&(_ZTV8S20956C8[15]),  15,15},
  {&(_tg__ZTV8S20956C2__8S20956C8[5]),  5,5},
  {&(_tg__ZTV8S20956C3__8S20956C2__8S20956C8[4]),  4,4},
  {&(_tg__ZTV8S20956C3__8S20956C8[4]),  4,4},
};
extern VTBL_ENTRY _ZTI8S20956C8[];
extern  VTBL_ENTRY _ZTV8S20956C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C8[];
Class_Descriptor cd_S20956C8 = {  "S20956C8", // class name
  bases_S20956C8, 9,
  &(vtc_S20956C8[0]), // expected_vtbl_contents
  &(vtt_S20956C8[0]), // expected_vtt_contents
  ABISELECT(5696,4480), // object size
  NSPAIRA(_ZTI8S20956C8),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S20956C8),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20956C8),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20956C9  : virtual S20956C5 {
  int s20956c9f0;
  int s20956c9f1;
  ::S20956C5 s20956c9f2;
  int s20956c9f3;
  ::S20956C4 s20956c9f4;
  void *s20956c9f5;
  ::S20956C5 s20956c9f6;
  char s20956c9f7:3;
  virtual  ~S20956C9(); // _ZN8S20956C9D2Ev
  virtual void  v3(); // _ZN8S20956C92v3Ev
  virtual void  v4(); // _ZN8S20956C92v4Ev
  virtual void  v5(); // _ZN8S20956C92v5Ev
  S20956C9(); // tgen
};
//SIG(-1 S20956C9) C1{ VBC2{ m FL Fi[4] Fc FL Fp[2]} vd v1 v2 v3 Fi[2] FC2 Fi FC3{ BC2 Fi FC2 FC2 Fi Fp FL[6] Fp} Fp FC2 Fc:3}


 S20956C9 ::~S20956C9(){ note_dtor("S20956C9", this);}
void  S20956C9 ::v3(){vfunc_called(this, "_ZN8S20956C92v3Ev");}
void  S20956C9 ::v4(){vfunc_called(this, "_ZN8S20956C92v4Ev");}
void  S20956C9 ::v5(){vfunc_called(this, "_ZN8S20956C92v5Ev");}
S20956C9 ::S20956C9(){ note_ctor("S20956C9", this);} // tgen

static void Test_S20956C9()
{
  extern Class_Descriptor cd_S20956C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(58,89)];
    init_test(&cd_S20956C9, buf);
    S20956C9 *dp, &lv = *(dp=new (buf) S20956C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(456,352), "sizeof(S20956C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20956C9)");
    check_base_class_offset(lv, (S20956C5*), ABISELECT(400,308), "S20956C9");
    check_field_offset(lv, s20956c9f0, ABISELECT(8,4), "S20956C9.s20956c9f0");
    check_field_offset(lv, s20956c9f1, ABISELECT(12,8), "S20956C9.s20956c9f1");
    check_field_offset(lv, s20956c9f2, ABISELECT(16,12), "S20956C9.s20956c9f2");
    check_field_offset(lv, s20956c9f3, ABISELECT(72,56), "S20956C9.s20956c9f3");
    check_field_offset(lv, s20956c9f4, ABISELECT(80,60), "S20956C9.s20956c9f4");
    check_field_offset(lv, s20956c9f5, ABISELECT(328,256), "S20956C9.s20956c9f5");
    check_field_offset(lv, s20956c9f6, ABISELECT(336,260), "S20956C9.s20956c9f6");
    set_bf_and_test(lv, s20956c9f7, ABISELECT(392,304), 0, 3, 1, "S20956C9");
    set_bf_and_test(lv, s20956c9f7, ABISELECT(392,304), 0, 3, hide_sll(1LL<<2), "S20956C9");
    test_class_info(&lv, &cd_S20956C9);
    dp->~S20956C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20956C9(Test_S20956C9, "S20956C9", ABISELECT(456,352));

#else // __cplusplus

extern void _ZN8S20956C9C1Ev();
extern void _ZN8S20956C9D2Ev();
Name_Map name_map_S20956C9[] = {
  NSPAIR(_ZN8S20956C9C1Ev),
  NSPAIR(_ZN8S20956C9D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
static Base_Class bases_S20956C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20956C5,    ABISELECT(400,308), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20956C9[];
extern void _ZN8S20956C9D1Ev();
extern void _ZN8S20956C9D0Ev();
extern void _ZN8S20956C92v3Ev();
extern void _ZN8S20956C92v4Ev();
extern void _ZN8S20956C92v5Ev();
static  VTBL_ENTRY vtc_S20956C9[] = {
  ABISELECT(400,308),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C9[0]),
  (VTBL_ENTRY)&_ZN8S20956C9D1Ev,
  (VTBL_ENTRY)&_ZN8S20956C9D0Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v3Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v4Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v5Ev,
};
extern VTBL_ENTRY _ZTV8S20956C9[];
static  VTT_ENTRY vtt_S20956C9[] = {
  {&(_ZTV8S20956C9[3]),  3,8},
};
extern VTBL_ENTRY _ZTI8S20956C9[];
extern  VTBL_ENTRY _ZTV8S20956C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C9[];
Class_Descriptor cd_S20956C9 = {  "S20956C9", // class name
  bases_S20956C9, 1,
  &(vtc_S20956C9[0]), // expected_vtbl_contents
  &(vtt_S20956C9[0]), // expected_vtt_contents
  ABISELECT(456,352), // object size
  NSPAIRA(_ZTI8S20956C9),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S20956C9),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20956C9),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S20956C10  {
  void *s20956c10f0;
  __tsi64 s20956c10f1;
  int s20956c10f2;
  char s20956c10f3;
  int s20956c10f4;
  __tsi64 s20956c10f5;
  long s20956c10f6;
  __tsi64 s20956c10f7;
  short s20956c10f8;
  void *s20956c10f9;
  long double s20956c10f10;
  char s20956c10f11[6];
  void  mf20956c10(); // _ZN9S20956C1010mf20956c10Ev
};
//SIG(1 S20956C10) U1{ m Fp FL Fi Fc Fi FL Fl FL Fs Fp FD Fc[6]}

#endif // __cplusplus
#ifdef __cplusplus

struct  S20956C7  : virtual S20956C8 {
  int s20956c7f0;
  ::S20956C9 s20956c7f1[2];
  ::S20956C10 s20956c7f2[8];
  ~S20956C7(); // tgen
  S20956C7(); // tgen
};
//SIG(-1 S20956C7) C1{ VBC2{ BC3{ BC4{ m FL Fi[4] Fc FL Fp[2]} Fi FC4 FC4 Fi Fp FL[6] Fp} VBC5{ VBC6{ VBC3 VBC4 FC4 Fs Fi FC3 FL[4] FC3} BC3 Fi[2] FC3 FC3[5] FU7{ m Fi[8] Fp FL Fc Fp[5] FD Fc[7] Fp Fc:1 Fi} Fi} FC5} Fi FC8{ VBC4 vd v1 v2 v3 Fi Fi FC4 Fi FC3 Fp FC4 Fc:3}[2] FU9{ m Fp FL Fi Fc Fi FL Fl FL Fs Fp FD Fc[6]}[8]}


S20956C7 ::~S20956C7(){ note_dtor("S20956C7", this);} // tgen
S20956C7 ::S20956C7(){ note_ctor("S20956C7", this);} // tgen

static void Test_S20956C7()
{
  extern Class_Descriptor cd_S20956C7;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(423,1323)];
    init_test(&cd_S20956C7, buf);
    S20956C7 *dp, &lv = *(dp=new (buf) S20956C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(6752,5288), "sizeof(S20956C7)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20956C7)");
    /*is_ambiguous_... S20956C8::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C4*)(S20956C8*), ABISELECT(1064,812), "S20956C7");
    /*is_ambiguous_... S20956C8::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C4*)(S20956C8*), ABISELECT(1064,812), "S20956C7");
    /*is_ambiguous_... S20956C7::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C4*), ABISELECT(6448,5048), "S20956C7");
    check_base_class_offset(lv, (S20956C4*)(S20956C3*), ABISELECT(6448,5048), "S20956C7");
    /*is_ambiguous_... S20956C3::S20956C5 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C3*), ABISELECT(6696,5244), "S20956C7");
    check_base_class_offset(lv, (S20956C3*)(S20956C2*), ABISELECT(5848,4568), "S20956C7");
    /*is_ambiguous_... S20956C2::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C4*)(S20956C2*), ABISELECT(4040,3152), "S20956C7");
    /*is_ambiguous_... S20956C2::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C4*)(S20956C2*), ABISELECT(4040,3152), "S20956C7");
    check_base_class_offset(lv, (S20956C2*)(S20956C8*), ABISELECT(4032,3148), "S20956C7");
    check_base_class_offset(lv, (S20956C8*), ABISELECT(1056,808), "S20956C7");
    check_field_offset(lv, s20956c7f0, ABISELECT(8,4), "S20956C7.s20956c7f0");
    check_field_offset(lv, s20956c7f1, ABISELECT(16,8), "S20956C7.s20956c7f1");
    check_field_offset(lv, s20956c7f2, ABISELECT(928,712), "S20956C7.s20956c7f2");
    test_class_info(&lv, &cd_S20956C7);
    dp->~S20956C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20956C7(Test_S20956C7, "S20956C7", ABISELECT(6752,5288));

#else // __cplusplus

extern void _ZN8S20956C7C1Ev();
extern void _ZN8S20956C7D1Ev();
Name_Map name_map_S20956C7[] = {
  NSPAIR(_ZN8S20956C7C1Ev),
  NSPAIR(_ZN8S20956C7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C4;
extern VTBL_ENTRY _ZTI8S20956C4[];
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C4;
extern VTBL_ENTRY _ZTI8S20956C4[];
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C3;
extern VTBL_ENTRY _ZTI8S20956C3[];
extern  VTBL_ENTRY _ZTV8S20956C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C3[];
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C4;
extern VTBL_ENTRY _ZTI8S20956C4[];
extern Class_Descriptor cd_S20956C2;
extern VTBL_ENTRY _ZTI8S20956C2[];
extern  VTBL_ENTRY _ZTV8S20956C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C2[];
extern Class_Descriptor cd_S20956C8;
extern VTBL_ENTRY _ZTI8S20956C8[];
extern  VTBL_ENTRY _ZTV8S20956C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C8[];
static Base_Class bases_S20956C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20956C5,    ABISELECT(1064,812), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20956C4,    ABISELECT(1064,812), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20956C5,    ABISELECT(6448,5048), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20956C4,    ABISELECT(6448,5048), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S20956C5,    ABISELECT(6696,5244), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S20956C3,    ABISELECT(5848,4568), //bcp->offset
    18, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S20956C5,    ABISELECT(4040,3152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20956C4,    ABISELECT(4040,3152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20956C2,    ABISELECT(4032,3148), //bcp->offset
    13, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S20956C8,    ABISELECT(1056,808), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20956C7[];
static  VTBL_ENTRY vtc_S20956C7[] = {
  ABISELECT(6696,5244),
  ABISELECT(6448,5048),
  ABISELECT(5848,4568),
  ABISELECT(4032,3148),
  ABISELECT(1056,808),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C7[0]),
  ABISELECT(5640,4436),
  ABISELECT(5392,4240),
  ABISELECT(4792,3760),
  ABISELECT(2976,2340),
  ABISELECT(-1056,-808),
  (VTBL_ENTRY)&(_ZTI8S20956C7[0]),
  ABISELECT(2664,2096),
  ABISELECT(2416,1900),
  ABISELECT(1816,1420),
  ABISELECT(-4032,-3148),
  (VTBL_ENTRY)&(_ZTI8S20956C7[0]),
  ABISELECT(848,676),
  ABISELECT(600,480),
  ABISELECT(-5848,-4568),
  (VTBL_ENTRY)&(_ZTI8S20956C7[0]),
};
extern VTBL_ENTRY _ZTV8S20956C7[];
static  VTBL_ENTRY _tg__ZTV8S20956C8__8S20956C7[] = {
  ABISELECT(5640,4436),
  ABISELECT(5392,4240),
  ABISELECT(4792,3760),
  ABISELECT(2976,2340),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C8[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20956C2__8S20956C8__8S20956C7[] = {
  ABISELECT(2664,2096),
  ABISELECT(2416,1900),
  ABISELECT(1816,1420),
  ABISELECT(-2976,-2340),
  (VTBL_ENTRY)&(_ZTI8S20956C8[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20956C3__8S20956C8__8S20956C7[] = {
  ABISELECT(848,676),
  ABISELECT(600,480),
  ABISELECT(-4792,-3760),
  (VTBL_ENTRY)&(_ZTI8S20956C8[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20956C2__8S20956C7[] = {
  ABISELECT(2664,2096),
  ABISELECT(2416,1900),
  ABISELECT(1816,1420),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C2[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20956C3__8S20956C2__8S20956C7[] = {
  ABISELECT(848,676),
  ABISELECT(600,480),
  ABISELECT(-1816,-1420),
  (VTBL_ENTRY)&(_ZTI8S20956C2[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20956C3__8S20956C7[] = {
  ABISELECT(848,676),
  ABISELECT(600,480),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C3[0]),
};
static  VTT_ENTRY vtt_S20956C7[] = {
  {&(_ZTV8S20956C7[7]),  7,22},
  {&(_ZTV8S20956C7[13]),  13,22},
  {&(_ZTV8S20956C7[18]),  18,22},
  {&(_ZTV8S20956C7[22]),  22,22},
  {&(_tg__ZTV8S20956C8__8S20956C7[6]),  6,6},
  {&(_tg__ZTV8S20956C2__8S20956C8__8S20956C7[5]),  5,5},
  {&(_tg__ZTV8S20956C3__8S20956C8__8S20956C7[4]),  4,4},
  {&(_tg__ZTV8S20956C2__8S20956C7[5]),  5,5},
  {&(_tg__ZTV8S20956C3__8S20956C2__8S20956C7[4]),  4,4},
  {&(_tg__ZTV8S20956C3__8S20956C7[4]),  4,4},
};
extern VTBL_ENTRY _ZTI8S20956C7[];
extern  VTBL_ENTRY _ZTV8S20956C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C7[];
Class_Descriptor cd_S20956C7 = {  "S20956C7", // class name
  bases_S20956C7, 10,
  &(vtc_S20956C7[0]), // expected_vtbl_contents
  &(vtt_S20956C7[0]), // expected_vtt_contents
  ABISELECT(6752,5288), // object size
  NSPAIRA(_ZTI8S20956C7),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S20956C7),22, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20956C7),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20956C12  {
  int s20956c12f0;
  ::S20956C9 s20956c12f1[2];
  char s20956c12f2;
  void  mf20956c12(); // _ZN9S20956C1210mf20956c12Ev
};
//SIG(-1 S20956C12) C1{ m Fi FC2{ VBC3{ m FL Fi[4] Fc FL Fp[2]} vd v1 v2 v3 Fi[2] FC3 Fi FC4{ BC3 Fi FC3 FC3 Fi Fp FL[6] Fp} Fp FC3 Fc:3}[2] Fc}


void  S20956C12 ::mf20956c12(){}

static void Test_S20956C12()
{
  {
    init_simple_test("S20956C12");
    static S20956C12 lv;
    check2(sizeof(lv), ABISELECT(928,712), "sizeof(S20956C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20956C12)");
    check_field_offset(lv, s20956c12f0, 0, "S20956C12.s20956c12f0");
    check_field_offset(lv, s20956c12f1, ABISELECT(8,4), "S20956C12.s20956c12f1");
    check_field_offset(lv, s20956c12f2, ABISELECT(920,708), "S20956C12.s20956c12f2");
  }
}
static Arrange_To_Call_Me vS20956C12(Test_S20956C12, "S20956C12", ABISELECT(928,712));

#else // __cplusplus

extern VTBL_ENTRY _ZTI9S20956C12[];
VTBL_ENTRY *P__ZTI9S20956C12 = _ZTI9S20956C12; 
Class_Descriptor cd_S20956C12 = {  "S20956C12", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(928,712), // object size
  NSPAIRA(_ZTI9S20956C12),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20956C14_nt  {
};
//SIG(-1 S20956C14_nt) C1{}



//skip512 S20956C14_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI12S20956C14_nt[];
VTBL_ENTRY *P__ZTI12S20956C14_nt = _ZTI12S20956C14_nt; 
Class_Descriptor cd_S20956C14_nt = {  "S20956C14_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI12S20956C14_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20956C13  : S20956C4 , virtual S20956C5 , virtual S20956C9 , virtual S20956C3 {
  int s20956c13f0;
  ::S20956C14_nt s20956c13f1;
  long double s20956c13f2;
  void *s20956c13f3;
  ::S20956C9 s20956c13f4[2];
  long double s20956c13f5;
  __tsi64 s20956c13f6;
  int s20956c13f7;
  ::S20956C3 s20956c13f8;
  virtual  ~S20956C13(); // _ZN9S20956C13D2Ev
  virtual void  v6(); // _ZN9S20956C132v6Ev
  virtual void  v7(); // _ZN9S20956C132v7Ev
  S20956C13(); // tgen
};
//SIG(-1 S20956C13) C1{ BC2{ BC3{ m FL Fi[4] Fc FL Fp[2]} Fi FC3 FC3 Fi Fp FL[6] Fp} VBC3 VBC4{ VBC3 vd v3 v4 v5 Fi[2] FC3 Fi FC2 Fp FC3 Fc:3} VBC5{ VBC2 VBC3 FC3 Fs Fi FC2 FL[4] FC2} vd v1 v2 Fi FC6{} FD Fp FC4[2] FD FL Fi FC5}


 S20956C13 ::~S20956C13(){ note_dtor("S20956C13", this);}
void  S20956C13 ::v6(){vfunc_called(this, "_ZN9S20956C132v6Ev");}
void  S20956C13 ::v7(){vfunc_called(this, "_ZN9S20956C132v7Ev");}
S20956C13 ::S20956C13(){ note_ctor("S20956C13", this);} // tgen

static void Test_S20956C13()
{
  extern Class_Descriptor cd_S20956C13;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(217,676)];
    init_test(&cd_S20956C13, buf);
    S20956C13 *dp, &lv = *(dp=new (buf) S20956C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(3456,2700), "sizeof(S20956C13)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20956C13)");
    /*is_ambiguous_... S20956C13::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C4*), ABISELECT(8,4), "S20956C13");
    /*is_ambiguous_... S20956C13::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C4*), ABISELECT(8,4), "S20956C13");
    /*is_ambiguous_... S20956C13::S20956C5 */ AMB_check_base_class_offset(lv, (S20956C5*), ABISELECT(2152,1672), "S20956C13");
    check_base_class_offset(lv, (S20956C5*)(S20956C9*), ABISELECT(2152,1672), "S20956C13");
    /*is_ambiguous_... S20956C3::S20956C5 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C3*), ABISELECT(2152,1672), "S20956C13");
    check_base_class_offset(lv, (S20956C9*), ABISELECT(2208,1716), "S20956C13");
    /*is_ambiguous_... S20956C13::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C4*), ABISELECT(3208,2504), "S20956C13");
    check_base_class_offset(lv, (S20956C4*)(S20956C3*), ABISELECT(3208,2504), "S20956C13");
    check_base_class_offset(lv, (S20956C3*), ABISELECT(2608,2024), "S20956C13");
    check_field_offset(lv, s20956c13f0, ABISELECT(256,200), "S20956C13.s20956c13f0");
    check_field_offset(lv, s20956c13f1, ABISELECT(260,204), "S20956C13.s20956c13f1");
    check_field_offset(lv, s20956c13f2, ABISELECT(272,208), "S20956C13.s20956c13f2");
    check_field_offset(lv, s20956c13f3, ABISELECT(288,220), "S20956C13.s20956c13f3");
    check_field_offset(lv, s20956c13f4, ABISELECT(296,224), "S20956C13.s20956c13f4");
    check_field_offset(lv, s20956c13f5, ABISELECT(1216,928), "S20956C13.s20956c13f5");
    check_field_offset(lv, s20956c13f6, ABISELECT(1232,940), "S20956C13.s20956c13f6");
    check_field_offset(lv, s20956c13f7, ABISELECT(1240,948), "S20956C13.s20956c13f7");
    check_field_offset(lv, s20956c13f8, ABISELECT(1248,952), "S20956C13.s20956c13f8");
    test_class_info(&lv, &cd_S20956C13);
    dp->~S20956C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20956C13(Test_S20956C13, "S20956C13", ABISELECT(3456,2700));

#else // __cplusplus

extern void _ZN9S20956C13C1Ev();
extern void _ZN9S20956C13D2Ev();
Name_Map name_map_S20956C13[] = {
  NSPAIR(_ZN9S20956C13C1Ev),
  NSPAIR(_ZN9S20956C13D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C4;
extern VTBL_ENTRY _ZTI8S20956C4[];
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C9;
extern VTBL_ENTRY _ZTI8S20956C9[];
extern  VTBL_ENTRY _ZTV8S20956C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C9[];
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C4;
extern VTBL_ENTRY _ZTI8S20956C4[];
extern Class_Descriptor cd_S20956C3;
extern VTBL_ENTRY _ZTI8S20956C3[];
extern  VTBL_ENTRY _ZTV8S20956C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C3[];
static Base_Class bases_S20956C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20956C5,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20956C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20956C5,    ABISELECT(2152,1672), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20956C9,    ABISELECT(2208,1716), //bcp->offset
    10, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20956C5,    ABISELECT(3208,2504), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20956C4,    ABISELECT(3208,2504), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20956C3,    ABISELECT(2608,2024), //bcp->offset
    22, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20956C13[];
extern void _ZN9S20956C13D1Ev();
extern void _ZN9S20956C13D0Ev();
extern void _ZN9S20956C132v6Ev();
extern void _ZN9S20956C132v7Ev();
extern void ABISELECT(_ZTv0_n32_N9S20956C13D1Ev,_ZTv0_n16_N9S20956C13D1Ev)();
extern void ABISELECT(_ZThn2208_N9S20956C13D1Ev,_ZThn1716_N9S20956C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20956C13D0Ev,_ZTv0_n16_N9S20956C13D0Ev)();
extern void ABISELECT(_ZThn2208_N9S20956C13D0Ev,_ZThn1716_N9S20956C13D0Ev)() __attribute__((weak));
extern void _ZN8S20956C92v3Ev();
extern void _ZN8S20956C92v4Ev();
extern void _ZN8S20956C92v5Ev();
static  VTBL_ENTRY vtc_S20956C13[] = {
  ABISELECT(3208,2504),
  ABISELECT(2608,2024),
  ABISELECT(2208,1716),
  ABISELECT(2152,1672),
  0,
  (VTBL_ENTRY)&(_ZTI9S20956C13[0]),
  (VTBL_ENTRY)&_ZN9S20956C13D1Ev,
  (VTBL_ENTRY)&_ZN9S20956C13D0Ev,
  (VTBL_ENTRY)&_ZN9S20956C132v6Ev,
  (VTBL_ENTRY)&_ZN9S20956C132v7Ev,
  0,
  0,
  0,
  ABISELECT(-2208,-1716),
  ABISELECT(-56,-44),
  ABISELECT(-2208,-1716),
  (VTBL_ENTRY)&(_ZTI9S20956C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C13D1Ev,_ZTv0_n16_N9S20956C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C13D0Ev,_ZTv0_n16_N9S20956C13D0Ev),
  (VTBL_ENTRY)&_ZN8S20956C92v3Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v4Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v5Ev,
  ABISELECT(-456,-352),
  ABISELECT(600,480),
  ABISELECT(-2608,-2024),
  (VTBL_ENTRY)&(_ZTI9S20956C13[0]),
};
extern VTBL_ENTRY _ZTV9S20956C13[];
extern void _ZN8S20956C9D1Ev();
extern void _ZN8S20956C9D0Ev();
extern void _ZN8S20956C92v3Ev();
extern void _ZN8S20956C92v4Ev();
extern void _ZN8S20956C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20956C9__9S20956C13[] = {
  ABISELECT(-56,-44),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C9[0]),
  (VTBL_ENTRY)&_ZN8S20956C9D1Ev,
  (VTBL_ENTRY)&_ZN8S20956C9D0Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v3Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v4Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20956C3__9S20956C13[] = {
  ABISELECT(-456,-352),
  ABISELECT(600,480),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C3[0]),
};
static  VTT_ENTRY vtt_S20956C13[] = {
  {&(_ZTV9S20956C13[6]),  6,26},
  {&(_ZTV9S20956C13[17]),  17,26},
  {&(_ZTV9S20956C13[26]),  26,26},
  {&(_tg__ZTV8S20956C9__9S20956C13[3]),  3,8},
  {&(_tg__ZTV8S20956C3__9S20956C13[4]),  4,4},
};
extern VTBL_ENTRY _ZTI9S20956C13[];
extern  VTBL_ENTRY _ZTV9S20956C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20956C13[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20956C13D0Ev,_ZTv0_n16_N9S20956C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2208_N9S20956C13D0Ev,_ZThn1716_N9S20956C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20956C13D1Ev,_ZTv0_n16_N9S20956C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2208_N9S20956C13D1Ev,_ZThn1716_N9S20956C13D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20956C13 = {  "S20956C13", // class name
  bases_S20956C13, 7,
  &(vtc_S20956C13[0]), // expected_vtbl_contents
  &(vtt_S20956C13[0]), // expected_vtt_contents
  ABISELECT(3456,2700), // object size
  NSPAIRA(_ZTI9S20956C13),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S20956C13),26, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20956C13),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20956C11  : S20956C12 , S20956C13 {
  void *s20956c11f0[2];
  ::S20956C10 s20956c11f1;
  long s20956c11f2;
  void *s20956c11f3;
  virtual  ~S20956C11(); // _ZN9S20956C11D2Ev
  S20956C11(); // tgen
};
//SIG(-1 S20956C11) C1{ BC2{ m Fi FC3{ VBC4{ m FL Fi[4] Fc FL Fp[2]} vd v1 v2 v3 Fi[2] FC4 Fi FC5{ BC4 Fi FC4 FC4 Fi Fp FL[6] Fp} Fp FC4 Fc:3}[2] Fc} BC6{ BC5 VBC4 VBC3 VBC7{ VBC5 VBC4 FC4 Fs Fi FC5 FL[4] FC5} vd v4 v5 Fi FC8{} FD Fp FC3[2] FD FL Fi FC7} vd Fp[2] FU9{ m Fp FL Fi Fc Fi FL Fl FL Fs Fp FD Fc[6]} Fl Fp}


 S20956C11 ::~S20956C11(){ note_dtor("S20956C11", this);}
S20956C11 ::S20956C11(){ note_ctor("S20956C11", this);} // tgen

static void Test_S20956C11()
{
  extern Class_Descriptor cd_S20956C11;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(279,861)];
    init_test(&cd_S20956C11, buf);
    S20956C11 *dp, &lv = *(dp=new (buf) S20956C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(4448,3440), "sizeof(S20956C11)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20956C11)");
    check_base_class_offset(lv, (S20956C12*), ABISELECT(2152,1672), "S20956C11");
    /*is_ambiguous_... S20956C13::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C4*)(S20956C13*), ABISELECT(8,4), "S20956C11");
    /*is_ambiguous_... S20956C13::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C4*)(S20956C13*), ABISELECT(8,4), "S20956C11");
    /*is_ambiguous_... S20956C13::S20956C5 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C13*), ABISELECT(3136,2412), "S20956C11");
    check_base_class_offset(lv, (S20956C5*)(S20956C9*), ABISELECT(3136,2412), "S20956C11");
    /*is_ambiguous_... S20956C3::S20956C5 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C3*), ABISELECT(3136,2412), "S20956C11");
    check_base_class_offset(lv, (S20956C9*)(S20956C13*), ABISELECT(3192,2456), "S20956C11");
    /*is_ambiguous_... S20956C11::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C4*), ABISELECT(4192,3244), "S20956C11");
    check_base_class_offset(lv, (S20956C4*)(S20956C3*), ABISELECT(4192,3244), "S20956C11");
    check_base_class_offset(lv, (S20956C3*)(S20956C13*), ABISELECT(3592,2764), "S20956C11");
    check_base_class_offset(lv, (S20956C13*), 0, "S20956C11");
    check_field_offset(lv, s20956c11f0, ABISELECT(3080,2384), "S20956C11.s20956c11f0");
    check_field_offset(lv, s20956c11f1, ABISELECT(3104,2392), "S20956C11.s20956c11f1");
    check_field_offset(lv, s20956c11f2, ABISELECT(3120,2404), "S20956C11.s20956c11f2");
    check_field_offset(lv, s20956c11f3, ABISELECT(3128,2408), "S20956C11.s20956c11f3");
    test_class_info(&lv, &cd_S20956C11);
    dp->~S20956C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20956C11(Test_S20956C11, "S20956C11", ABISELECT(4448,3440));

#else // __cplusplus

extern void _ZN9S20956C11C1Ev();
extern void _ZN9S20956C11D2Ev();
Name_Map name_map_S20956C11[] = {
  NSPAIR(_ZN9S20956C11C1Ev),
  NSPAIR(_ZN9S20956C11D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20956C12;
extern VTBL_ENTRY _ZTI9S20956C12[];
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C4;
extern VTBL_ENTRY _ZTI8S20956C4[];
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C9;
extern VTBL_ENTRY _ZTI8S20956C9[];
extern  VTBL_ENTRY _ZTV8S20956C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C9[];
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C4;
extern VTBL_ENTRY _ZTI8S20956C4[];
extern Class_Descriptor cd_S20956C3;
extern VTBL_ENTRY _ZTI8S20956C3[];
extern  VTBL_ENTRY _ZTV8S20956C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C3[];
extern Class_Descriptor cd_S20956C13;
extern VTBL_ENTRY _ZTI9S20956C13[];
extern  VTBL_ENTRY _ZTV9S20956C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20956C13[];
static Base_Class bases_S20956C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20956C12,    ABISELECT(2152,1672), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20956C5,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20956C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20956C5,    ABISELECT(3136,2412), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S20956C9,    ABISELECT(3192,2456), //bcp->offset
    10, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S20956C5,    ABISELECT(4192,3244), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20956C4,    ABISELECT(4192,3244), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S20956C3,    ABISELECT(3592,2764), //bcp->offset
    22, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S20956C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20956C11[];
extern void _ZN9S20956C11D1Ev();
extern void _ZN9S20956C11D0Ev();
extern void _ZN9S20956C132v6Ev();
extern void _ZN9S20956C132v7Ev();
extern void ABISELECT(_ZTv0_n32_N9S20956C11D1Ev,_ZTv0_n16_N9S20956C11D1Ev)();
extern void ABISELECT(_ZThn3192_N9S20956C11D1Ev,_ZThn2456_N9S20956C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20956C11D0Ev,_ZTv0_n16_N9S20956C11D0Ev)();
extern void ABISELECT(_ZThn3192_N9S20956C11D0Ev,_ZThn2456_N9S20956C11D0Ev)() __attribute__((weak));
extern void _ZN8S20956C92v3Ev();
extern void _ZN8S20956C92v4Ev();
extern void _ZN8S20956C92v5Ev();
static  VTBL_ENTRY vtc_S20956C11[] = {
  ABISELECT(4192,3244),
  ABISELECT(3592,2764),
  ABISELECT(3192,2456),
  ABISELECT(3136,2412),
  0,
  (VTBL_ENTRY)&(_ZTI9S20956C11[0]),
  (VTBL_ENTRY)&_ZN9S20956C11D1Ev,
  (VTBL_ENTRY)&_ZN9S20956C11D0Ev,
  (VTBL_ENTRY)&_ZN9S20956C132v6Ev,
  (VTBL_ENTRY)&_ZN9S20956C132v7Ev,
  0,
  0,
  0,
  ABISELECT(-3192,-2456),
  ABISELECT(-56,-44),
  ABISELECT(-3192,-2456),
  (VTBL_ENTRY)&(_ZTI9S20956C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C11D1Ev,_ZTv0_n16_N9S20956C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C11D0Ev,_ZTv0_n16_N9S20956C11D0Ev),
  (VTBL_ENTRY)&_ZN8S20956C92v3Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v4Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v5Ev,
  ABISELECT(-456,-352),
  ABISELECT(600,480),
  ABISELECT(-3592,-2764),
  (VTBL_ENTRY)&(_ZTI9S20956C11[0]),
};
extern VTBL_ENTRY _ZTV9S20956C11[];
extern void _ZN9S20956C13D1Ev();
extern void _ZN9S20956C13D0Ev();
extern void _ZN9S20956C132v6Ev();
extern void _ZN9S20956C132v7Ev();
static  VTBL_ENTRY _tg__ZTV9S20956C13__9S20956C11[] = {
  ABISELECT(4192,3244),
  ABISELECT(3592,2764),
  ABISELECT(3192,2456),
  ABISELECT(3136,2412),
  0,
  (VTBL_ENTRY)&(_ZTI9S20956C13[0]),
  (VTBL_ENTRY)&_ZN9S20956C13D1Ev,
  (VTBL_ENTRY)&_ZN9S20956C13D0Ev,
  (VTBL_ENTRY)&_ZN9S20956C132v6Ev,
  (VTBL_ENTRY)&_ZN9S20956C132v7Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20956C13D1Ev,_ZTv0_n16_N9S20956C13D1Ev)();
extern void ABISELECT(_ZThn3192_N9S20956C13D1Ev,_ZThn2456_N9S20956C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20956C13D0Ev,_ZTv0_n16_N9S20956C13D0Ev)();
extern void ABISELECT(_ZThn3192_N9S20956C13D0Ev,_ZThn2456_N9S20956C13D0Ev)() __attribute__((weak));
extern void _ZN8S20956C92v3Ev();
extern void _ZN8S20956C92v4Ev();
extern void _ZN8S20956C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20956C9__9S20956C13__9S20956C11[] = {
  0,
  0,
  0,
  ABISELECT(-3192,-2456),
  ABISELECT(-56,-44),
  ABISELECT(-3192,-2456),
  (VTBL_ENTRY)&(_ZTI9S20956C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C13D1Ev,_ZTv0_n16_N9S20956C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C13D0Ev,_ZTv0_n16_N9S20956C13D0Ev),
  (VTBL_ENTRY)&_ZN8S20956C92v3Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v4Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20956C3__9S20956C13__9S20956C11[] = {
  ABISELECT(-456,-352),
  ABISELECT(600,480),
  ABISELECT(-3592,-2764),
  (VTBL_ENTRY)&(_ZTI9S20956C13[0]),
};
extern void _ZN8S20956C9D1Ev();
extern void _ZN8S20956C9D0Ev();
extern void _ZN8S20956C92v3Ev();
extern void _ZN8S20956C92v4Ev();
extern void _ZN8S20956C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20956C9__9S20956C11[] = {
  ABISELECT(-56,-44),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C9[0]),
  (VTBL_ENTRY)&_ZN8S20956C9D1Ev,
  (VTBL_ENTRY)&_ZN8S20956C9D0Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v3Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v4Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20956C3__9S20956C11[] = {
  ABISELECT(-456,-352),
  ABISELECT(600,480),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C3[0]),
};
static  VTT_ENTRY vtt_S20956C11[] = {
  {&(_ZTV9S20956C11[6]),  6,26},
  {&(_tg__ZTV9S20956C13__9S20956C11[6]),  6,10},
  {&(_tg__ZTV8S20956C9__9S20956C13__9S20956C11[7]),  7,12},
  {&(_tg__ZTV8S20956C3__9S20956C13__9S20956C11[4]),  4,4},
  {&(_ZTV9S20956C11[17]),  17,26},
  {&(_ZTV9S20956C11[26]),  26,26},
  {&(_tg__ZTV8S20956C9__9S20956C11[3]),  3,8},
  {&(_tg__ZTV8S20956C3__9S20956C11[4]),  4,4},
};
extern VTBL_ENTRY _ZTI9S20956C11[];
extern  VTBL_ENTRY _ZTV9S20956C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20956C11[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20956C13D0Ev,_ZTv0_n16_N9S20956C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3192_N9S20956C13D0Ev,_ZThn2456_N9S20956C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20956C13D1Ev,_ZTv0_n16_N9S20956C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3192_N9S20956C13D1Ev,_ZThn2456_N9S20956C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20956C11D0Ev,_ZTv0_n16_N9S20956C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3192_N9S20956C11D0Ev,_ZThn2456_N9S20956C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20956C11D1Ev,_ZTv0_n16_N9S20956C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3192_N9S20956C11D1Ev,_ZThn2456_N9S20956C11D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20956C11 = {  "S20956C11", // class name
  bases_S20956C11, 9,
  &(vtc_S20956C11[0]), // expected_vtbl_contents
  &(vtt_S20956C11[0]), // expected_vtt_contents
  ABISELECT(4448,3440), // object size
  NSPAIRA(_ZTI9S20956C11),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S20956C11),26, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20956C11),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20956C18  : virtual S20956C5 , S20956C3 {
  void *s20956c18f0;
  char s20956c18f1[9];
  ::S20956C3 s20956c18f2;
  ::S20956C4 s20956c18f3;
  __tsi64 s20956c18f4:37;
  char s20956c18f5;
  ::S20956C4 s20956c18f6;
  char s20956c18f7:8;
  void *s20956c18f8;
  char s20956c18f9;
  int s20956c18f10;
  int s20956c18f11;
  ~S20956C18(); // tgen
  S20956C18(); // tgen
};
//SIG(-1 S20956C18) C1{ VBC2{ m FL Fi[4] Fc FL Fp[2]} BC3{ VBC4{ BC2 Fi FC2 FC2 Fi Fp FL[6] Fp} VBC2 FC2 Fs Fi FC4 FL[4] FC4} Fp Fc[9] FC3 FC4 FL:37 Fc FC4 Fc:8 Fp Fc Fi[2]}


S20956C18 ::~S20956C18(){ note_dtor("S20956C18", this);} // tgen
S20956C18 ::S20956C18(){ note_ctor("S20956C18", this);} // tgen

static void Test_S20956C18()
{
  extern Class_Descriptor cd_S20956C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(297,470)];
    init_test(&cd_S20956C18, buf);
    S20956C18 *dp, &lv = *(dp=new (buf) S20956C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2368,1876), "sizeof(S20956C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20956C18)");
    /*is_ambiguous_... S20956C18::S20956C5 */ AMB_check_base_class_offset(lv, (S20956C5*), ABISELECT(2064,1636), "S20956C18");
    /*is_ambiguous_... S20956C3::S20956C5 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C3*), ABISELECT(2064,1636), "S20956C18");
    check_base_class_offset(lv, (S20956C5*)(S20956C4*), ABISELECT(2120,1680), "S20956C18");
    check_base_class_offset(lv, (S20956C4*)(S20956C3*), ABISELECT(2120,1680), "S20956C18");
    check_base_class_offset(lv, (S20956C3*), 0, "S20956C18");
    check_field_offset(lv, s20956c18f0, ABISELECT(600,480), "S20956C18.s20956c18f0");
    check_field_offset(lv, s20956c18f1, ABISELECT(608,484), "S20956C18.s20956c18f1");
    check_field_offset(lv, s20956c18f2, ABISELECT(624,496), "S20956C18.s20956c18f2");
    check_field_offset(lv, s20956c18f3, ABISELECT(1528,1216), "S20956C18.s20956c18f3");
    set_bf_and_test(lv, s20956c18f4, ABISELECT(1776,1412), 0, 37, 1, "S20956C18");
    set_bf_and_test(lv, s20956c18f4, ABISELECT(1776,1412), 0, 37, hide_sll(1LL<<36), "S20956C18");
    check_field_offset(lv, s20956c18f5, ABISELECT(1781,1417), "S20956C18.s20956c18f5");
    check_field_offset(lv, s20956c18f6, ABISELECT(1784,1420), "S20956C18.s20956c18f6");
    set_bf_and_test(lv, s20956c18f7, ABISELECT(2032,1616), 0, 8, 1, "S20956C18");
    set_bf_and_test(lv, s20956c18f7, ABISELECT(2032,1616), 0, 8, hide_sll(1LL<<7), "S20956C18");
    check_field_offset(lv, s20956c18f8, ABISELECT(2040,1620), "S20956C18.s20956c18f8");
    check_field_offset(lv, s20956c18f9, ABISELECT(2048,1624), "S20956C18.s20956c18f9");
    check_field_offset(lv, s20956c18f10, ABISELECT(2052,1628), "S20956C18.s20956c18f10");
    check_field_offset(lv, s20956c18f11, ABISELECT(2056,1632), "S20956C18.s20956c18f11");
    test_class_info(&lv, &cd_S20956C18);
    dp->~S20956C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20956C18(Test_S20956C18, "S20956C18", ABISELECT(2368,1876));

#else // __cplusplus

extern void _ZN9S20956C18C1Ev();
extern void _ZN9S20956C18D1Ev();
Name_Map name_map_S20956C18[] = {
  NSPAIR(_ZN9S20956C18C1Ev),
  NSPAIR(_ZN9S20956C18D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C4;
extern VTBL_ENTRY _ZTI8S20956C4[];
extern Class_Descriptor cd_S20956C3;
extern VTBL_ENTRY _ZTI8S20956C3[];
extern  VTBL_ENTRY _ZTV8S20956C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C3[];
static Base_Class bases_S20956C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20956C5,    ABISELECT(2064,1636), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20956C5,    ABISELECT(2120,1680), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20956C4,    ABISELECT(2120,1680), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20956C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20956C18[];
static  VTBL_ENTRY vtc_S20956C18[] = {
  ABISELECT(2064,1636),
  ABISELECT(2120,1680),
  0,
  (VTBL_ENTRY)&(_ZTI9S20956C18[0]),
};
extern VTBL_ENTRY _ZTV9S20956C18[];
static  VTBL_ENTRY _tg__ZTV8S20956C3__9S20956C18[] = {
  ABISELECT(2064,1636),
  ABISELECT(2120,1680),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C3[0]),
};
static  VTT_ENTRY vtt_S20956C18[] = {
  {&(_ZTV9S20956C18[4]),  4,4},
  {&(_tg__ZTV8S20956C3__9S20956C18[4]),  4,4},
};
extern VTBL_ENTRY _ZTI9S20956C18[];
extern  VTBL_ENTRY _ZTV9S20956C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20956C18[];
Class_Descriptor cd_S20956C18 = {  "S20956C18", // class name
  bases_S20956C18, 4,
  &(vtc_S20956C18[0]), // expected_vtbl_contents
  &(vtt_S20956C18[0]), // expected_vtt_contents
  ABISELECT(2368,1876), // object size
  NSPAIRA(_ZTI9S20956C18),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S20956C18),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20956C18),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20956C17  : virtual S20956C13 , S20956C18 {
  int s20956c17f0;
  int s20956c17f1;
  short s20956c17f2;
  ::S20956C10 s20956c17f3;
  int s20956c17f4;
  int s20956c17f5;
  short s20956c17f6;
  int s20956c17f7;
  int s20956c17f8;
  virtual void  v8(); // _ZN9S20956C172v8Ev
  virtual void  v9(); // _ZN9S20956C172v9Ev
  ~S20956C17(); // tgen
  S20956C17(); // tgen
};
//SIG(-1 S20956C17) C1{ VBC2{ BC3{ BC4{ m FL Fi[4] Fc FL Fp[2]} Fi FC4 FC4 Fi Fp FL[6] Fp} VBC4 VBC5{ VBC4 vd v3 v4 v5 Fi[2] FC4 Fi FC3 Fp FC4 Fc:3} VBC6{ VBC3 VBC4 FC4 Fs Fi FC3 FL[4] FC3} vd v6 v7 Fi FC7{} FD Fp FC5[2] FD FL Fi FC6} BC8{ VBC4 BC6 Fp Fc[9] FC6 FC3 FL:37 Fc FC3 Fc:8 Fp Fc Fi[2]} v1 v2 Fi[2] Fs FU9{ m Fp FL Fi Fc Fi FL Fl FL Fs Fp FD Fc[6]} Fi Fi Fs Fi Fi}


void  S20956C17 ::v8(){vfunc_called(this, "_ZN9S20956C172v8Ev");}
void  S20956C17 ::v9(){vfunc_called(this, "_ZN9S20956C172v9Ev");}
S20956C17 ::~S20956C17(){ note_dtor("S20956C17", this);} // tgen
S20956C17 ::S20956C17(){ note_ctor("S20956C17", this);} // tgen

static void Test_S20956C17()
{
  extern Class_Descriptor cd_S20956C17;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(350,1096)];
    init_test(&cd_S20956C17, buf);
    S20956C17 *dp, &lv = *(dp=new (buf) S20956C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(5584,4380), "sizeof(S20956C17)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20956C17)");
    /*is_ambiguous_... S20956C13::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C4*)(S20956C13*), ABISELECT(2136,1684), "S20956C17");
    /*is_ambiguous_... S20956C13::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C4*)(S20956C13*), ABISELECT(2136,1684), "S20956C17");
    /*is_ambiguous_... S20956C13::S20956C5 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C13*), ABISELECT(4280,3352), "S20956C17");
    check_base_class_offset(lv, (S20956C5*)(S20956C9*), ABISELECT(4280,3352), "S20956C17");
    /*is_ambiguous_... S20956C17::S20956C3 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C3*), ABISELECT(4280,3352), "S20956C17");
    /*is_ambiguous_... S20956C18::S20956C5 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C18*), ABISELECT(4280,3352), "S20956C17");
    /*is_ambiguous_... S20956C3::S20956C5 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C3*)(S20956C18*), ABISELECT(4280,3352), "S20956C17");
    check_base_class_offset(lv, (S20956C9*)(S20956C13*), ABISELECT(4336,3396), "S20956C17");
    /*is_ambiguous_... S20956C17::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C4*), ABISELECT(5336,4184), "S20956C17");
    /*is_ambiguous_... S20956C17::S20956C3 */ AMB_check_base_class_offset(lv, (S20956C4*)(S20956C3*), ABISELECT(5336,4184), "S20956C17");
    check_base_class_offset(lv, (S20956C4*)(S20956C3*)(S20956C18*), ABISELECT(5336,4184), "S20956C17");
    check_base_class_offset(lv, (S20956C3*)(S20956C13*), ABISELECT(4736,3704), "S20956C17");
    check_base_class_offset(lv, (S20956C13*), ABISELECT(2128,1680), "S20956C17");
    check_base_class_offset(lv, (S20956C3*)(S20956C18*), 0, "S20956C17");
    check_base_class_offset(lv, (S20956C18*), 0, "S20956C17");
    check_field_offset(lv, s20956c17f0, ABISELECT(2060,1636), "S20956C17.s20956c17f0");
    check_field_offset(lv, s20956c17f1, ABISELECT(2064,1640), "S20956C17.s20956c17f1");
    check_field_offset(lv, s20956c17f2, ABISELECT(2068,1644), "S20956C17.s20956c17f2");
    check_field_offset(lv, s20956c17f3, ABISELECT(2080,1648), "S20956C17.s20956c17f3");
    check_field_offset(lv, s20956c17f4, ABISELECT(2096,1660), "S20956C17.s20956c17f4");
    check_field_offset(lv, s20956c17f5, ABISELECT(2100,1664), "S20956C17.s20956c17f5");
    check_field_offset(lv, s20956c17f6, ABISELECT(2104,1668), "S20956C17.s20956c17f6");
    check_field_offset(lv, s20956c17f7, ABISELECT(2108,1672), "S20956C17.s20956c17f7");
    check_field_offset(lv, s20956c17f8, ABISELECT(2112,1676), "S20956C17.s20956c17f8");
    test_class_info(&lv, &cd_S20956C17);
    dp->~S20956C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20956C17(Test_S20956C17, "S20956C17", ABISELECT(5584,4380));

#else // __cplusplus

extern void _ZN9S20956C17C1Ev();
extern void _ZN9S20956C17D1Ev();
Name_Map name_map_S20956C17[] = {
  NSPAIR(_ZN9S20956C17C1Ev),
  NSPAIR(_ZN9S20956C17D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C4;
extern VTBL_ENTRY _ZTI8S20956C4[];
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C9;
extern VTBL_ENTRY _ZTI8S20956C9[];
extern  VTBL_ENTRY _ZTV8S20956C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C9[];
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C4;
extern VTBL_ENTRY _ZTI8S20956C4[];
extern Class_Descriptor cd_S20956C3;
extern VTBL_ENTRY _ZTI8S20956C3[];
extern  VTBL_ENTRY _ZTV8S20956C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C3[];
extern Class_Descriptor cd_S20956C13;
extern VTBL_ENTRY _ZTI9S20956C13[];
extern  VTBL_ENTRY _ZTV9S20956C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20956C13[];
extern Class_Descriptor cd_S20956C3;
extern VTBL_ENTRY _ZTI8S20956C3[];
extern  VTBL_ENTRY _ZTV8S20956C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C3[];
extern Class_Descriptor cd_S20956C18;
extern VTBL_ENTRY _ZTI9S20956C18[];
extern  VTBL_ENTRY _ZTV9S20956C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20956C18[];
static Base_Class bases_S20956C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20956C5,    ABISELECT(2136,1684), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20956C4,    ABISELECT(2136,1684), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20956C5,    ABISELECT(4280,3352), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20956C9,    ABISELECT(4336,3396), //bcp->offset
    24, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S20956C5,    ABISELECT(5336,4184), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20956C4,    ABISELECT(5336,4184), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20956C3,    ABISELECT(4736,3704), //bcp->offset
    36, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S20956C13,    ABISELECT(2128,1680), //bcp->offset
    11, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20956C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20956C18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20956C17[];
extern void _ZN9S20956C172v8Ev();
extern void _ZN9S20956C172v9Ev();
extern void _ZN9S20956C17D1Ev();
extern void _ZN9S20956C17D0Ev();
extern void ABISELECT(_ZTv0_n56_N9S20956C17D1Ev,_ZTv0_n28_N9S20956C17D1Ev)();
extern void ABISELECT(_ZThn2128_N9S20956C17D1Ev,_ZThn1680_N9S20956C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S20956C17D0Ev,_ZTv0_n28_N9S20956C17D0Ev)();
extern void ABISELECT(_ZThn2128_N9S20956C17D0Ev,_ZThn1680_N9S20956C17D0Ev)() __attribute__((weak));
extern void _ZN9S20956C132v6Ev();
extern void _ZN9S20956C132v7Ev();
extern void ABISELECT(_ZTv0_n32_N9S20956C17D1Ev,_ZTv0_n16_N9S20956C17D1Ev)();
extern void ABISELECT(_ZThn4336_N9S20956C17D1Ev,_ZThn3396_N9S20956C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20956C17D0Ev,_ZTv0_n16_N9S20956C17D0Ev)();
extern void ABISELECT(_ZThn4336_N9S20956C17D0Ev,_ZThn3396_N9S20956C17D0Ev)() __attribute__((weak));
extern void _ZN8S20956C92v3Ev();
extern void _ZN8S20956C92v4Ev();
extern void _ZN8S20956C92v5Ev();
static  VTBL_ENTRY vtc_S20956C17[] = {
  ABISELECT(4736,3704),
  ABISELECT(4336,3396),
  ABISELECT(2128,1680),
  ABISELECT(4280,3352),
  ABISELECT(5336,4184),
  0,
  (VTBL_ENTRY)&(_ZTI9S20956C17[0]),
  (VTBL_ENTRY)&_ZN9S20956C172v8Ev,
  (VTBL_ENTRY)&_ZN9S20956C172v9Ev,
  (VTBL_ENTRY)&_ZN9S20956C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20956C17D0Ev,
  0,
  0,
  ABISELECT(-2128,-1680),
  ABISELECT(3208,2504),
  ABISELECT(2608,2024),
  ABISELECT(2208,1716),
  ABISELECT(2152,1672),
  ABISELECT(-2128,-1680),
  (VTBL_ENTRY)&(_ZTI9S20956C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20956C17D1Ev,_ZTv0_n28_N9S20956C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20956C17D0Ev,_ZTv0_n28_N9S20956C17D0Ev),
  (VTBL_ENTRY)&_ZN9S20956C132v6Ev,
  (VTBL_ENTRY)&_ZN9S20956C132v7Ev,
  0,
  0,
  0,
  ABISELECT(-4336,-3396),
  ABISELECT(-56,-44),
  ABISELECT(-4336,-3396),
  (VTBL_ENTRY)&(_ZTI9S20956C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C17D1Ev,_ZTv0_n16_N9S20956C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C17D0Ev,_ZTv0_n16_N9S20956C17D0Ev),
  (VTBL_ENTRY)&_ZN8S20956C92v3Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v4Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v5Ev,
  ABISELECT(-456,-352),
  ABISELECT(600,480),
  ABISELECT(-4736,-3704),
  (VTBL_ENTRY)&(_ZTI9S20956C17[0]),
};
extern VTBL_ENTRY _ZTV9S20956C17[];
static  VTBL_ENTRY _tg__ZTV9S20956C18__9S20956C17[] = {
  ABISELECT(4280,3352),
  ABISELECT(5336,4184),
  0,
  (VTBL_ENTRY)&(_ZTI9S20956C18[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20956C39S20956C18__A1__9S20956C17[] = {
  ABISELECT(4280,3352),
  ABISELECT(5336,4184),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C3[0]),
};
extern void _ZN9S20956C13D1Ev();
extern void _ZN9S20956C13D0Ev();
extern void _ZN9S20956C132v6Ev();
extern void _ZN9S20956C132v7Ev();
static  VTBL_ENTRY _tg__ZTV9S20956C13__9S20956C17[] = {
  ABISELECT(3208,2504),
  ABISELECT(2608,2024),
  ABISELECT(2208,1716),
  ABISELECT(2152,1672),
  0,
  (VTBL_ENTRY)&(_ZTI9S20956C13[0]),
  (VTBL_ENTRY)&_ZN9S20956C13D1Ev,
  (VTBL_ENTRY)&_ZN9S20956C13D0Ev,
  (VTBL_ENTRY)&_ZN9S20956C132v6Ev,
  (VTBL_ENTRY)&_ZN9S20956C132v7Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20956C13D1Ev,_ZTv0_n16_N9S20956C13D1Ev)();
extern void ABISELECT(_ZThn2208_N9S20956C13D1Ev,_ZThn1716_N9S20956C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20956C13D0Ev,_ZTv0_n16_N9S20956C13D0Ev)();
extern void ABISELECT(_ZThn2208_N9S20956C13D0Ev,_ZThn1716_N9S20956C13D0Ev)() __attribute__((weak));
extern void _ZN8S20956C92v3Ev();
extern void _ZN8S20956C92v4Ev();
extern void _ZN8S20956C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20956C9__9S20956C13__9S20956C17[] = {
  0,
  0,
  0,
  ABISELECT(-2208,-1716),
  ABISELECT(-56,-44),
  ABISELECT(-2208,-1716),
  (VTBL_ENTRY)&(_ZTI9S20956C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C13D1Ev,_ZTv0_n16_N9S20956C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C13D0Ev,_ZTv0_n16_N9S20956C13D0Ev),
  (VTBL_ENTRY)&_ZN8S20956C92v3Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v4Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20956C3__9S20956C13__9S20956C17[] = {
  ABISELECT(-456,-352),
  ABISELECT(600,480),
  ABISELECT(-2608,-2024),
  (VTBL_ENTRY)&(_ZTI9S20956C13[0]),
};
extern void _ZN8S20956C9D1Ev();
extern void _ZN8S20956C9D0Ev();
extern void _ZN8S20956C92v3Ev();
extern void _ZN8S20956C92v4Ev();
extern void _ZN8S20956C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20956C9__9S20956C17[] = {
  ABISELECT(-56,-44),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C9[0]),
  (VTBL_ENTRY)&_ZN8S20956C9D1Ev,
  (VTBL_ENTRY)&_ZN8S20956C9D0Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v3Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v4Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20956C3__9S20956C17[] = {
  ABISELECT(-456,-352),
  ABISELECT(600,480),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C3[0]),
};
static  VTT_ENTRY vtt_S20956C17[] = {
  {&(_ZTV9S20956C17[7]),  7,40},
  {&(_tg__ZTV9S20956C18__9S20956C17[4]),  4,4},
  {&(_tg__ZTV8S20956C39S20956C18__A1__9S20956C17[4]),  4,4},
  {&(_ZTV9S20956C17[20]),  20,40},
  {&(_ZTV9S20956C17[31]),  31,40},
  {&(_ZTV9S20956C17[40]),  40,40},
  {&(_tg__ZTV9S20956C13__9S20956C17[6]),  6,10},
  {&(_tg__ZTV8S20956C9__9S20956C13__9S20956C17[7]),  7,12},
  {&(_tg__ZTV8S20956C3__9S20956C13__9S20956C17[4]),  4,4},
  {&(_tg__ZTV8S20956C9__9S20956C17[3]),  3,8},
  {&(_tg__ZTV8S20956C3__9S20956C17[4]),  4,4},
};
extern VTBL_ENTRY _ZTI9S20956C17[];
extern  VTBL_ENTRY _ZTV9S20956C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20956C17[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20956C13D0Ev,_ZTv0_n16_N9S20956C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2208_N9S20956C13D0Ev,_ZThn1716_N9S20956C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20956C13D1Ev,_ZTv0_n16_N9S20956C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2208_N9S20956C13D1Ev,_ZThn1716_N9S20956C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20956C17D0Ev,_ZTv0_n16_N9S20956C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4336_N9S20956C17D0Ev,_ZThn3396_N9S20956C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20956C17D1Ev,_ZTv0_n16_N9S20956C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4336_N9S20956C17D1Ev,_ZThn3396_N9S20956C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20956C17D0Ev,_ZTv0_n28_N9S20956C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2128_N9S20956C17D0Ev,_ZThn1680_N9S20956C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20956C17D1Ev,_ZTv0_n28_N9S20956C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2128_N9S20956C17D1Ev,_ZThn1680_N9S20956C17D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20956C17 = {  "S20956C17", // class name
  bases_S20956C17, 10,
  &(vtc_S20956C17[0]), // expected_vtbl_contents
  &(vtt_S20956C17[0]), // expected_vtt_contents
  ABISELECT(5584,4380), // object size
  NSPAIRA(_ZTI9S20956C17),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S20956C17),40, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20956C17),11, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20956C16  : virtual S20956C17 {
  ::S20956C9 s20956c16f0[2];
  long double s20956c16f1;
  __tsi64 s20956c16f2;
  ::S20956C5 s20956c16f3;
  void *s20956c16f4;
  virtual  ~S20956C16(); // _ZN9S20956C16D2Ev
  S20956C16(); // tgen
};
//SIG(-1 S20956C16) C1{ VBC2{ VBC3{ BC4{ BC5{ m FL Fi[4] Fc FL Fp[2]} Fi FC5 FC5 Fi Fp FL[6] Fp} VBC5 VBC6{ VBC5 vd v1 v2 v3 Fi[2] FC5 Fi FC4 Fp FC5 Fc:3} VBC7{ VBC4 VBC5 FC5 Fs Fi FC4 FL[4] FC4} vd v4 v5 Fi FC8{} FD Fp FC6[2] FD FL Fi FC7} BC9{ VBC5 BC7 Fp Fc[9] FC7 FC4 FL:37 Fc FC4 Fc:8 Fp Fc Fi[2]} v6 v7 Fi[2] Fs FU10{ m Fp FL Fi Fc Fi FL Fl FL Fs Fp FD Fc[6]} Fi Fi Fs Fi Fi} vd FC6[2] FD FL FC5 Fp}


 S20956C16 ::~S20956C16(){ note_dtor("S20956C16", this);}
S20956C16 ::S20956C16(){ note_ctor("S20956C16", this);} // tgen

static void Test_S20956C16()
{
  extern Class_Descriptor cd_S20956C16;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(414,1290)];
    init_test(&cd_S20956C16, buf);
    S20956C16 *dp, &lv = *(dp=new (buf) S20956C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(6608,5156), "sizeof(S20956C16)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20956C16)");
    /*is_ambiguous_... S20956C13::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C4*)(S20956C13*), ABISELECT(3160,2460), "S20956C16");
    /*is_ambiguous_... S20956C13::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C4*)(S20956C13*), ABISELECT(3160,2460), "S20956C16");
    /*is_ambiguous_... S20956C13::S20956C5 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C13*), ABISELECT(5304,4128), "S20956C16");
    check_base_class_offset(lv, (S20956C5*)(S20956C9*), ABISELECT(5304,4128), "S20956C16");
    /*is_ambiguous_... S20956C16::S20956C3 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C3*), ABISELECT(5304,4128), "S20956C16");
    /*is_ambiguous_... S20956C18::S20956C5 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C18*)(S20956C17*), ABISELECT(5304,4128), "S20956C16");
    /*is_ambiguous_... S20956C3::S20956C5 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C3*)(S20956C18*)(S20956C17*), ABISELECT(5304,4128), "S20956C16");
    check_base_class_offset(lv, (S20956C9*)(S20956C13*), ABISELECT(5360,4172), "S20956C16");
    /*is_ambiguous_... S20956C16::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C4*), ABISELECT(6360,4960), "S20956C16");
    /*is_ambiguous_... S20956C16::S20956C3 */ AMB_check_base_class_offset(lv, (S20956C4*)(S20956C3*), ABISELECT(6360,4960), "S20956C16");
    check_base_class_offset(lv, (S20956C4*)(S20956C3*)(S20956C18*)(S20956C17*), ABISELECT(6360,4960), "S20956C16");
    check_base_class_offset(lv, (S20956C3*)(S20956C13*), ABISELECT(5760,4480), "S20956C16");
    check_base_class_offset(lv, (S20956C13*)(S20956C17*), ABISELECT(3152,2456), "S20956C16");
    check_base_class_offset(lv, (S20956C3*)(S20956C18*)(S20956C17*), ABISELECT(1024,776), "S20956C16");
    check_base_class_offset(lv, (S20956C18*)(S20956C17*), ABISELECT(1024,776), "S20956C16");
    check_base_class_offset(lv, (S20956C17*), ABISELECT(1024,776), "S20956C16");
    check_field_offset(lv, s20956c16f0, ABISELECT(8,4), "S20956C16.s20956c16f0");
    check_field_offset(lv, s20956c16f1, ABISELECT(928,708), "S20956C16.s20956c16f1");
    check_field_offset(lv, s20956c16f2, ABISELECT(944,720), "S20956C16.s20956c16f2");
    check_field_offset(lv, s20956c16f3, ABISELECT(952,728), "S20956C16.s20956c16f3");
    check_field_offset(lv, s20956c16f4, ABISELECT(1008,772), "S20956C16.s20956c16f4");
    test_class_info(&lv, &cd_S20956C16);
    dp->~S20956C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20956C16(Test_S20956C16, "S20956C16", ABISELECT(6608,5156));

#else // __cplusplus

extern void _ZN9S20956C16C1Ev();
extern void _ZN9S20956C16D2Ev();
Name_Map name_map_S20956C16[] = {
  NSPAIR(_ZN9S20956C16C1Ev),
  NSPAIR(_ZN9S20956C16D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C4;
extern VTBL_ENTRY _ZTI8S20956C4[];
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C9;
extern VTBL_ENTRY _ZTI8S20956C9[];
extern  VTBL_ENTRY _ZTV8S20956C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C9[];
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C4;
extern VTBL_ENTRY _ZTI8S20956C4[];
extern Class_Descriptor cd_S20956C3;
extern VTBL_ENTRY _ZTI8S20956C3[];
extern  VTBL_ENTRY _ZTV8S20956C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C3[];
extern Class_Descriptor cd_S20956C13;
extern VTBL_ENTRY _ZTI9S20956C13[];
extern  VTBL_ENTRY _ZTV9S20956C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20956C13[];
extern Class_Descriptor cd_S20956C3;
extern VTBL_ENTRY _ZTI8S20956C3[];
extern  VTBL_ENTRY _ZTV8S20956C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C3[];
extern Class_Descriptor cd_S20956C18;
extern VTBL_ENTRY _ZTI9S20956C18[];
extern  VTBL_ENTRY _ZTV9S20956C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20956C18[];
extern Class_Descriptor cd_S20956C17;
extern VTBL_ENTRY _ZTI9S20956C17[];
extern  VTBL_ENTRY _ZTV9S20956C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20956C17[];
static Base_Class bases_S20956C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20956C5,    ABISELECT(3160,2460), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20956C4,    ABISELECT(3160,2460), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20956C5,    ABISELECT(5304,4128), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20956C9,    ABISELECT(5360,4172), //bcp->offset
    37, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S20956C5,    ABISELECT(6360,4960), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20956C4,    ABISELECT(6360,4960), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20956C3,    ABISELECT(5760,4480), //bcp->offset
    49, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S20956C13,    ABISELECT(3152,2456), //bcp->offset
    24, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S20956C3,    ABISELECT(1024,776), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20956C18,    ABISELECT(1024,776), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20956C17,    ABISELECT(1024,776), //bcp->offset
    10, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20956C16[];
extern void _ZN9S20956C16D1Ev();
extern void _ZN9S20956C16D0Ev();
extern void _ZN9S20956C172v8Ev();
extern void _ZN9S20956C172v9Ev();
extern void ABISELECT(_ZTv0_n80_N9S20956C16D1Ev,_ZTv0_n40_N9S20956C16D1Ev)();
extern void ABISELECT(_ZThn1024_N9S20956C16D1Ev,_ZThn776_N9S20956C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S20956C16D0Ev,_ZTv0_n40_N9S20956C16D0Ev)();
extern void ABISELECT(_ZThn1024_N9S20956C16D0Ev,_ZThn776_N9S20956C16D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S20956C16D1Ev,_ZTv0_n28_N9S20956C16D1Ev)();
extern void ABISELECT(_ZThn3152_N9S20956C16D1Ev,_ZThn2456_N9S20956C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S20956C16D0Ev,_ZTv0_n28_N9S20956C16D0Ev)();
extern void ABISELECT(_ZThn3152_N9S20956C16D0Ev,_ZThn2456_N9S20956C16D0Ev)() __attribute__((weak));
extern void _ZN9S20956C132v6Ev();
extern void _ZN9S20956C132v7Ev();
extern void ABISELECT(_ZTv0_n32_N9S20956C16D1Ev,_ZTv0_n16_N9S20956C16D1Ev)();
extern void ABISELECT(_ZThn5360_N9S20956C16D1Ev,_ZThn4172_N9S20956C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20956C16D0Ev,_ZTv0_n16_N9S20956C16D0Ev)();
extern void ABISELECT(_ZThn5360_N9S20956C16D0Ev,_ZThn4172_N9S20956C16D0Ev)() __attribute__((weak));
extern void _ZN8S20956C92v3Ev();
extern void _ZN8S20956C92v4Ev();
extern void _ZN8S20956C92v5Ev();
static  VTBL_ENTRY vtc_S20956C16[] = {
  ABISELECT(6360,4960),
  ABISELECT(5760,4480),
  ABISELECT(5360,4172),
  ABISELECT(5304,4128),
  ABISELECT(3152,2456),
  ABISELECT(1024,776),
  0,
  (VTBL_ENTRY)&(_ZTI9S20956C16[0]),
  (VTBL_ENTRY)&_ZN9S20956C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20956C16D0Ev,
  ABISELECT(-1024,-776),
  0,
  0,
  ABISELECT(4736,3704),
  ABISELECT(4336,3396),
  ABISELECT(2128,1680),
  ABISELECT(4280,3352),
  ABISELECT(5336,4184),
  ABISELECT(-1024,-776),
  (VTBL_ENTRY)&(_ZTI9S20956C16[0]),
  (VTBL_ENTRY)&_ZN9S20956C172v8Ev,
  (VTBL_ENTRY)&_ZN9S20956C172v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S20956C16D1Ev,_ZTv0_n40_N9S20956C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S20956C16D0Ev,_ZTv0_n40_N9S20956C16D0Ev),
  0,
  0,
  ABISELECT(-3152,-2456),
  ABISELECT(3208,2504),
  ABISELECT(2608,2024),
  ABISELECT(2208,1716),
  ABISELECT(2152,1672),
  ABISELECT(-3152,-2456),
  (VTBL_ENTRY)&(_ZTI9S20956C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20956C16D1Ev,_ZTv0_n28_N9S20956C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20956C16D0Ev,_ZTv0_n28_N9S20956C16D0Ev),
  (VTBL_ENTRY)&_ZN9S20956C132v6Ev,
  (VTBL_ENTRY)&_ZN9S20956C132v7Ev,
  0,
  0,
  0,
  ABISELECT(-5360,-4172),
  ABISELECT(-56,-44),
  ABISELECT(-5360,-4172),
  (VTBL_ENTRY)&(_ZTI9S20956C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C16D1Ev,_ZTv0_n16_N9S20956C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C16D0Ev,_ZTv0_n16_N9S20956C16D0Ev),
  (VTBL_ENTRY)&_ZN8S20956C92v3Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v4Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v5Ev,
  ABISELECT(-456,-352),
  ABISELECT(600,480),
  ABISELECT(-5760,-4480),
  (VTBL_ENTRY)&(_ZTI9S20956C16[0]),
};
extern VTBL_ENTRY _ZTV9S20956C16[];
extern void _ZN9S20956C172v8Ev();
extern void _ZN9S20956C172v9Ev();
extern void _ZN9S20956C17D1Ev();
extern void _ZN9S20956C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20956C17__9S20956C16[] = {
  ABISELECT(4736,3704),
  ABISELECT(4336,3396),
  ABISELECT(2128,1680),
  ABISELECT(4280,3352),
  ABISELECT(5336,4184),
  0,
  (VTBL_ENTRY)&(_ZTI9S20956C17[0]),
  (VTBL_ENTRY)&_ZN9S20956C172v8Ev,
  (VTBL_ENTRY)&_ZN9S20956C172v9Ev,
  (VTBL_ENTRY)&_ZN9S20956C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20956C17D0Ev,
};
static  VTBL_ENTRY _tg__ZTV9S20956C189S20956C17__9S20956C16[] = {
  ABISELECT(4280,3352),
  ABISELECT(5336,4184),
  0,
  (VTBL_ENTRY)&(_ZTI9S20956C18[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20956C39S20956C189S20956C17__A1__9S20956C16[] = {
  ABISELECT(4280,3352),
  ABISELECT(5336,4184),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C3[0]),
};
extern void ABISELECT(_ZTv0_n56_N9S20956C17D1Ev,_ZTv0_n28_N9S20956C17D1Ev)();
extern void ABISELECT(_ZThn2128_N9S20956C17D1Ev,_ZThn1680_N9S20956C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S20956C17D0Ev,_ZTv0_n28_N9S20956C17D0Ev)();
extern void ABISELECT(_ZThn2128_N9S20956C17D0Ev,_ZThn1680_N9S20956C17D0Ev)() __attribute__((weak));
extern void _ZN9S20956C132v6Ev();
extern void _ZN9S20956C132v7Ev();
static  VTBL_ENTRY _tg__ZTV9S20956C13__9S20956C17__9S20956C16[] = {
  0,
  0,
  ABISELECT(-2128,-1680),
  ABISELECT(3208,2504),
  ABISELECT(2608,2024),
  ABISELECT(2208,1716),
  ABISELECT(2152,1672),
  ABISELECT(-2128,-1680),
  (VTBL_ENTRY)&(_ZTI9S20956C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20956C17D1Ev,_ZTv0_n28_N9S20956C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20956C17D0Ev,_ZTv0_n28_N9S20956C17D0Ev),
  (VTBL_ENTRY)&_ZN9S20956C132v6Ev,
  (VTBL_ENTRY)&_ZN9S20956C132v7Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20956C17D1Ev,_ZTv0_n16_N9S20956C17D1Ev)();
extern void ABISELECT(_ZThn4336_N9S20956C17D1Ev,_ZThn3396_N9S20956C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20956C17D0Ev,_ZTv0_n16_N9S20956C17D0Ev)();
extern void ABISELECT(_ZThn4336_N9S20956C17D0Ev,_ZThn3396_N9S20956C17D0Ev)() __attribute__((weak));
extern void _ZN8S20956C92v3Ev();
extern void _ZN8S20956C92v4Ev();
extern void _ZN8S20956C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20956C9__9S20956C17__9S20956C16[] = {
  0,
  0,
  0,
  ABISELECT(-4336,-3396),
  ABISELECT(-56,-44),
  ABISELECT(-4336,-3396),
  (VTBL_ENTRY)&(_ZTI9S20956C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C17D1Ev,_ZTv0_n16_N9S20956C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C17D0Ev,_ZTv0_n16_N9S20956C17D0Ev),
  (VTBL_ENTRY)&_ZN8S20956C92v3Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v4Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20956C3__9S20956C17__9S20956C16[] = {
  ABISELECT(-456,-352),
  ABISELECT(600,480),
  ABISELECT(-4736,-3704),
  (VTBL_ENTRY)&(_ZTI9S20956C17[0]),
};
extern void _ZN9S20956C13D1Ev();
extern void _ZN9S20956C13D0Ev();
extern void _ZN9S20956C132v6Ev();
extern void _ZN9S20956C132v7Ev();
static  VTBL_ENTRY _tg__ZTV9S20956C13__9S20956C16[] = {
  ABISELECT(3208,2504),
  ABISELECT(2608,2024),
  ABISELECT(2208,1716),
  ABISELECT(2152,1672),
  0,
  (VTBL_ENTRY)&(_ZTI9S20956C13[0]),
  (VTBL_ENTRY)&_ZN9S20956C13D1Ev,
  (VTBL_ENTRY)&_ZN9S20956C13D0Ev,
  (VTBL_ENTRY)&_ZN9S20956C132v6Ev,
  (VTBL_ENTRY)&_ZN9S20956C132v7Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20956C13D1Ev,_ZTv0_n16_N9S20956C13D1Ev)();
extern void ABISELECT(_ZThn2208_N9S20956C13D1Ev,_ZThn1716_N9S20956C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20956C13D0Ev,_ZTv0_n16_N9S20956C13D0Ev)();
extern void ABISELECT(_ZThn2208_N9S20956C13D0Ev,_ZThn1716_N9S20956C13D0Ev)() __attribute__((weak));
extern void _ZN8S20956C92v3Ev();
extern void _ZN8S20956C92v4Ev();
extern void _ZN8S20956C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20956C9__9S20956C13__9S20956C16[] = {
  0,
  0,
  0,
  ABISELECT(-2208,-1716),
  ABISELECT(-56,-44),
  ABISELECT(-2208,-1716),
  (VTBL_ENTRY)&(_ZTI9S20956C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C13D1Ev,_ZTv0_n16_N9S20956C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C13D0Ev,_ZTv0_n16_N9S20956C13D0Ev),
  (VTBL_ENTRY)&_ZN8S20956C92v3Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v4Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20956C3__9S20956C13__9S20956C16[] = {
  ABISELECT(-456,-352),
  ABISELECT(600,480),
  ABISELECT(-2608,-2024),
  (VTBL_ENTRY)&(_ZTI9S20956C13[0]),
};
extern void _ZN8S20956C9D1Ev();
extern void _ZN8S20956C9D0Ev();
extern void _ZN8S20956C92v3Ev();
extern void _ZN8S20956C92v4Ev();
extern void _ZN8S20956C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20956C9__9S20956C16[] = {
  ABISELECT(-56,-44),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C9[0]),
  (VTBL_ENTRY)&_ZN8S20956C9D1Ev,
  (VTBL_ENTRY)&_ZN8S20956C9D0Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v3Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v4Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20956C3__9S20956C16[] = {
  ABISELECT(-456,-352),
  ABISELECT(600,480),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C3[0]),
};
static  VTT_ENTRY vtt_S20956C16[] = {
  {&(_ZTV9S20956C16[8]),  8,53},
  {&(_ZTV9S20956C16[20]),  20,53},
  {&(_ZTV9S20956C16[33]),  33,53},
  {&(_ZTV9S20956C16[44]),  44,53},
  {&(_ZTV9S20956C16[53]),  53,53},
  {&(_tg__ZTV9S20956C17__9S20956C16[7]),  7,11},
  {&(_tg__ZTV9S20956C189S20956C17__9S20956C16[4]),  4,4},
  {&(_tg__ZTV8S20956C39S20956C189S20956C17__A1__9S20956C16[4]),  4,4},
  {&(_tg__ZTV9S20956C13__9S20956C17__9S20956C16[9]),  9,13},
  {&(_tg__ZTV8S20956C9__9S20956C17__9S20956C16[7]),  7,12},
  {&(_tg__ZTV8S20956C3__9S20956C17__9S20956C16[4]),  4,4},
  {&(_tg__ZTV9S20956C13__9S20956C16[6]),  6,10},
  {&(_tg__ZTV8S20956C9__9S20956C13__9S20956C16[7]),  7,12},
  {&(_tg__ZTV8S20956C3__9S20956C13__9S20956C16[4]),  4,4},
  {&(_tg__ZTV8S20956C9__9S20956C16[3]),  3,8},
  {&(_tg__ZTV8S20956C3__9S20956C16[4]),  4,4},
};
extern VTBL_ENTRY _ZTI9S20956C16[];
extern  VTBL_ENTRY _ZTV9S20956C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20956C16[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20956C13D0Ev,_ZTv0_n16_N9S20956C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2208_N9S20956C13D0Ev,_ZThn1716_N9S20956C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20956C13D1Ev,_ZTv0_n16_N9S20956C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2208_N9S20956C13D1Ev,_ZThn1716_N9S20956C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20956C17D0Ev,_ZTv0_n16_N9S20956C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4336_N9S20956C17D0Ev,_ZThn3396_N9S20956C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20956C17D1Ev,_ZTv0_n16_N9S20956C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4336_N9S20956C17D1Ev,_ZThn3396_N9S20956C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20956C17D0Ev,_ZTv0_n28_N9S20956C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2128_N9S20956C17D0Ev,_ZThn1680_N9S20956C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20956C17D1Ev,_ZTv0_n28_N9S20956C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2128_N9S20956C17D1Ev,_ZThn1680_N9S20956C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20956C16D0Ev,_ZTv0_n16_N9S20956C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5360_N9S20956C16D0Ev,_ZThn4172_N9S20956C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20956C16D1Ev,_ZTv0_n16_N9S20956C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5360_N9S20956C16D1Ev,_ZThn4172_N9S20956C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20956C16D0Ev,_ZTv0_n28_N9S20956C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3152_N9S20956C16D0Ev,_ZThn2456_N9S20956C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20956C16D1Ev,_ZTv0_n28_N9S20956C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3152_N9S20956C16D1Ev,_ZThn2456_N9S20956C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S20956C16D0Ev,_ZTv0_n40_N9S20956C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1024_N9S20956C16D0Ev,_ZThn776_N9S20956C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S20956C16D1Ev,_ZTv0_n40_N9S20956C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1024_N9S20956C16D1Ev,_ZThn776_N9S20956C16D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20956C16 = {  "S20956C16", // class name
  bases_S20956C16, 11,
  &(vtc_S20956C16[0]), // expected_vtbl_contents
  &(vtt_S20956C16[0]), // expected_vtt_contents
  ABISELECT(6608,5156), // object size
  NSPAIRA(_ZTI9S20956C16),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV9S20956C16),53, //virtual function table var
  8, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20956C16),16, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20956C15  : S20956C2 , virtual S20956C16 {
  int s20956c15f0;
  int s20956c15f1[7];
  virtual  ~S20956C15(); // _ZN9S20956C15D2Ev
  virtual void  v10(); // _ZN9S20956C153v10Ev
  S20956C15(); // tgen
};
//SIG(-1 S20956C15) C1{ BC2{ VBC3{ VBC4{ BC5{ m FL Fi[4] Fc FL Fp[2]} Fi FC5 FC5 Fi Fp FL[6] Fp} VBC5 FC5 Fs Fi FC4 FL[4] FC4} BC4 Fi[2] FC4 FC4[5] FU6{ m Fi[8] Fp FL Fc Fp[5] FD Fc[7] Fp Fc:1 Fi} Fi} VBC7{ VBC8{ VBC9{ BC4 VBC5 VBC10{ VBC5 vd v2 v3 v4 Fi Fi FC5 Fi FC4 Fp FC5 Fc:3} VBC3 vd v5 v6 Fi FC11{} FD Fp FC10[2] FD FL Fi FC3} BC12{ VBC5 BC3 Fp Fc[9] FC3 FC4 FL:37 Fc FC4 Fc:8 Fp Fc Fi Fi} v7 v8 Fi Fi Fs FU13{ m Fp FL Fi Fc Fi FL Fl FL Fs Fp FD Fc[6]} Fi Fi Fs Fi Fi} vd FC10[2] FD FL FC5 Fp} vd v1 Fi Fi[7]}


 S20956C15 ::~S20956C15(){ note_dtor("S20956C15", this);}
void  S20956C15 ::v10(){vfunc_called(this, "_ZN9S20956C153v10Ev");}
S20956C15 ::S20956C15(){ note_ctor("S20956C15", this);} // tgen

static void Test_S20956C15()
{
  extern Class_Descriptor cd_S20956C15;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(530,1653)];
    init_test(&cd_S20956C15, buf);
    S20956C15 *dp, &lv = *(dp=new (buf) S20956C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8464,6608), "sizeof(S20956C15)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20956C15)");
    /*is_ambiguous_... S20956C15::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C4*), ABISELECT(2448,1932), "S20956C15");
    /*is_ambiguous_... S20956C15::S20956C3 */ AMB_check_base_class_offset(lv, (S20956C4*)(S20956C3*), ABISELECT(2448,1932), "S20956C15");
    check_base_class_offset(lv, (S20956C4*)(S20956C3*)(S20956C18*)(S20956C17*), ABISELECT(2448,1932), "S20956C15");
    /*is_ambiguous_... S20956C15::S20956C3 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C3*), ABISELECT(2696,2128), "S20956C15");
    /*is_ambiguous_... S20956C13::S20956C5 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C13*), ABISELECT(2696,2128), "S20956C15");
    check_base_class_offset(lv, (S20956C5*)(S20956C9*), ABISELECT(2696,2128), "S20956C15");
    /*is_ambiguous_... S20956C18::S20956C5 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C18*)(S20956C17*), ABISELECT(2696,2128), "S20956C15");
    /*is_ambiguous_... S20956C3::S20956C5 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C3*)(S20956C18*)(S20956C17*), ABISELECT(2696,2128), "S20956C15");
    check_base_class_offset(lv, (S20956C3*)(S20956C2*), ABISELECT(1848,1452), "S20956C15");
    check_base_class_offset(lv, (S20956C3*)(S20956C13*), ABISELECT(1848,1452), "S20956C15");
    /*is_ambiguous_... S20956C2::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C4*)(S20956C2*), ABISELECT(8,4), "S20956C15");
    /*is_ambiguous_... S20956C2::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C4*)(S20956C2*), ABISELECT(8,4), "S20956C15");
    check_base_class_offset(lv, (S20956C2*), 0, "S20956C15");
    /*is_ambiguous_... S20956C13::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C4*)(S20956C13*), ABISELECT(5912,4632), "S20956C15");
    /*is_ambiguous_... S20956C13::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C4*)(S20956C13*), ABISELECT(5912,4632), "S20956C15");
    check_base_class_offset(lv, (S20956C9*)(S20956C13*), ABISELECT(8056,6300), "S20956C15");
    check_base_class_offset(lv, (S20956C13*)(S20956C17*), ABISELECT(5904,4628), "S20956C15");
    check_base_class_offset(lv, (S20956C3*)(S20956C18*)(S20956C17*), ABISELECT(3776,2948), "S20956C15");
    check_base_class_offset(lv, (S20956C18*)(S20956C17*), ABISELECT(3776,2948), "S20956C15");
    check_base_class_offset(lv, (S20956C17*)(S20956C16*), ABISELECT(3776,2948), "S20956C15");
    check_base_class_offset(lv, (S20956C16*), ABISELECT(2752,2172), "S20956C15");
    check_field_offset(lv, s20956c15f0, ABISELECT(1812,1420), "S20956C15.s20956c15f0");
    check_field_offset(lv, s20956c15f1, ABISELECT(1816,1424), "S20956C15.s20956c15f1");
    test_class_info(&lv, &cd_S20956C15);
    dp->~S20956C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20956C15(Test_S20956C15, "S20956C15", ABISELECT(8464,6608));

#else // __cplusplus

extern void _ZN9S20956C15C1Ev();
extern void _ZN9S20956C15D2Ev();
Name_Map name_map_S20956C15[] = {
  NSPAIR(_ZN9S20956C15C1Ev),
  NSPAIR(_ZN9S20956C15D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C4;
extern VTBL_ENTRY _ZTI8S20956C4[];
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C3;
extern VTBL_ENTRY _ZTI8S20956C3[];
extern  VTBL_ENTRY _ZTV8S20956C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C3[];
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C4;
extern VTBL_ENTRY _ZTI8S20956C4[];
extern Class_Descriptor cd_S20956C2;
extern VTBL_ENTRY _ZTI8S20956C2[];
extern  VTBL_ENTRY _ZTV8S20956C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C2[];
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C4;
extern VTBL_ENTRY _ZTI8S20956C4[];
extern Class_Descriptor cd_S20956C9;
extern VTBL_ENTRY _ZTI8S20956C9[];
extern  VTBL_ENTRY _ZTV8S20956C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C9[];
extern Class_Descriptor cd_S20956C13;
extern VTBL_ENTRY _ZTI9S20956C13[];
extern  VTBL_ENTRY _ZTV9S20956C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20956C13[];
extern Class_Descriptor cd_S20956C3;
extern VTBL_ENTRY _ZTI8S20956C3[];
extern  VTBL_ENTRY _ZTV8S20956C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C3[];
extern Class_Descriptor cd_S20956C18;
extern VTBL_ENTRY _ZTI9S20956C18[];
extern  VTBL_ENTRY _ZTV9S20956C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20956C18[];
extern Class_Descriptor cd_S20956C17;
extern VTBL_ENTRY _ZTI9S20956C17[];
extern  VTBL_ENTRY _ZTV9S20956C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20956C17[];
extern Class_Descriptor cd_S20956C16;
extern VTBL_ENTRY _ZTI9S20956C16[];
extern  VTBL_ENTRY _ZTV9S20956C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20956C16[];
static Base_Class bases_S20956C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20956C5,    ABISELECT(2448,1932), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20956C4,    ABISELECT(2448,1932), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20956C5,    ABISELECT(2696,2128), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20956C3,    ABISELECT(1848,1452), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20956C5,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20956C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20956C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20956C5,    ABISELECT(5912,4632), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20956C4,    ABISELECT(5912,4632), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20956C9,    ABISELECT(8056,6300), //bcp->offset
    54, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S20956C13,    ABISELECT(5904,4628), //bcp->offset
    41, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S20956C3,    ABISELECT(3776,2948), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20956C18,    ABISELECT(3776,2948), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S20956C17,    ABISELECT(3776,2948), //bcp->offset
    27, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S20956C16,    ABISELECT(2752,2172), //bcp->offset
    16, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20956C15[];
extern void _ZN9S20956C15D1Ev();
extern void _ZN9S20956C15D0Ev();
extern void _ZN9S20956C153v10Ev();
extern void ABISELECT(_ZTv0_n72_N9S20956C15D1Ev,_ZTv0_n36_N9S20956C15D1Ev)();
extern void ABISELECT(_ZThn2752_N9S20956C15D1Ev,_ZThn2172_N9S20956C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S20956C15D0Ev,_ZTv0_n36_N9S20956C15D0Ev)();
extern void ABISELECT(_ZThn2752_N9S20956C15D0Ev,_ZThn2172_N9S20956C15D0Ev)() __attribute__((weak));
extern void _ZN9S20956C172v8Ev();
extern void _ZN9S20956C172v9Ev();
extern void ABISELECT(_ZTv0_n80_N9S20956C15D1Ev,_ZTv0_n40_N9S20956C15D1Ev)();
extern void ABISELECT(_ZThn3776_N9S20956C15D1Ev,_ZThn2948_N9S20956C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S20956C15D0Ev,_ZTv0_n40_N9S20956C15D0Ev)();
extern void ABISELECT(_ZThn3776_N9S20956C15D0Ev,_ZThn2948_N9S20956C15D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S20956C15D1Ev,_ZTv0_n28_N9S20956C15D1Ev)();
extern void ABISELECT(_ZThn5904_N9S20956C15D1Ev,_ZThn4628_N9S20956C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S20956C15D0Ev,_ZTv0_n28_N9S20956C15D0Ev)();
extern void ABISELECT(_ZThn5904_N9S20956C15D0Ev,_ZThn4628_N9S20956C15D0Ev)() __attribute__((weak));
extern void _ZN9S20956C132v6Ev();
extern void _ZN9S20956C132v7Ev();
extern void ABISELECT(_ZTv0_n32_N9S20956C15D1Ev,_ZTv0_n16_N9S20956C15D1Ev)();
extern void ABISELECT(_ZThn8056_N9S20956C15D1Ev,_ZThn6300_N9S20956C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20956C15D0Ev,_ZTv0_n16_N9S20956C15D0Ev)();
extern void ABISELECT(_ZThn8056_N9S20956C15D0Ev,_ZThn6300_N9S20956C15D0Ev)() __attribute__((weak));
extern void _ZN8S20956C92v3Ev();
extern void _ZN8S20956C92v4Ev();
extern void _ZN8S20956C92v5Ev();
static  VTBL_ENTRY vtc_S20956C15[] = {
  ABISELECT(8056,6300),
  ABISELECT(5904,4628),
  ABISELECT(3776,2948),
  ABISELECT(2752,2172),
  ABISELECT(2696,2128),
  ABISELECT(2448,1932),
  ABISELECT(1848,1452),
  0,
  (VTBL_ENTRY)&(_ZTI9S20956C15[0]),
  (VTBL_ENTRY)&_ZN9S20956C15D1Ev,
  (VTBL_ENTRY)&_ZN9S20956C15D0Ev,
  (VTBL_ENTRY)&_ZN9S20956C153v10Ev,
  ABISELECT(848,676),
  ABISELECT(600,480),
  ABISELECT(-1848,-1452),
  (VTBL_ENTRY)&(_ZTI9S20956C15[0]),
  ABISELECT(-2752,-2172),
  ABISELECT(-304,-240),
  ABISELECT(-904,-720),
  ABISELECT(5304,4128),
  ABISELECT(-56,-44),
  ABISELECT(3152,2456),
  ABISELECT(1024,776),
  ABISELECT(-2752,-2172),
  (VTBL_ENTRY)&(_ZTI9S20956C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20956C15D1Ev,_ZTv0_n36_N9S20956C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20956C15D0Ev,_ZTv0_n36_N9S20956C15D0Ev),
  ABISELECT(-3776,-2948),
  0,
  0,
  ABISELECT(-1928,-1496),
  ABISELECT(4280,3352),
  ABISELECT(2128,1680),
  ABISELECT(-1080,-820),
  ABISELECT(-1328,-1016),
  ABISELECT(-3776,-2948),
  (VTBL_ENTRY)&(_ZTI9S20956C15[0]),
  (VTBL_ENTRY)&_ZN9S20956C172v8Ev,
  (VTBL_ENTRY)&_ZN9S20956C172v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S20956C15D1Ev,_ZTv0_n40_N9S20956C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S20956C15D0Ev,_ZTv0_n40_N9S20956C15D0Ev),
  0,
  0,
  ABISELECT(-5904,-4628),
  ABISELECT(-3456,-2696),
  ABISELECT(-4056,-3176),
  ABISELECT(2152,1672),
  ABISELECT(-3208,-2500),
  ABISELECT(-5904,-4628),
  (VTBL_ENTRY)&(_ZTI9S20956C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20956C15D1Ev,_ZTv0_n28_N9S20956C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20956C15D0Ev,_ZTv0_n28_N9S20956C15D0Ev),
  (VTBL_ENTRY)&_ZN9S20956C132v6Ev,
  (VTBL_ENTRY)&_ZN9S20956C132v7Ev,
  0,
  0,
  0,
  ABISELECT(-8056,-6300),
  ABISELECT(-5360,-4172),
  ABISELECT(-8056,-6300),
  (VTBL_ENTRY)&(_ZTI9S20956C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C15D1Ev,_ZTv0_n16_N9S20956C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C15D0Ev,_ZTv0_n16_N9S20956C15D0Ev),
  (VTBL_ENTRY)&_ZN8S20956C92v3Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v4Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v5Ev,
};
extern VTBL_ENTRY _ZTV9S20956C15[];
static  VTBL_ENTRY _tg__ZTV8S20956C2__9S20956C15[] = {
  ABISELECT(2696,2128),
  ABISELECT(2448,1932),
  ABISELECT(1848,1452),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C2[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20956C3__8S20956C2__9S20956C15[] = {
  ABISELECT(848,676),
  ABISELECT(600,480),
  ABISELECT(-1848,-1452),
  (VTBL_ENTRY)&(_ZTI8S20956C2[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20956C3__9S20956C15[] = {
  ABISELECT(848,676),
  ABISELECT(600,480),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C3[0]),
};
extern void _ZN9S20956C16D1Ev();
extern void _ZN9S20956C16D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20956C16__9S20956C15[] = {
  ABISELECT(-304,-240),
  ABISELECT(-904,-720),
  ABISELECT(5304,4128),
  ABISELECT(-56,-44),
  ABISELECT(3152,2456),
  ABISELECT(1024,776),
  0,
  (VTBL_ENTRY)&(_ZTI9S20956C16[0]),
  (VTBL_ENTRY)&_ZN9S20956C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20956C16D0Ev,
};
extern void _ZN9S20956C172v8Ev();
extern void _ZN9S20956C172v9Ev();
extern void ABISELECT(_ZTv0_n80_N9S20956C16D1Ev,_ZTv0_n40_N9S20956C16D1Ev)();
extern void ABISELECT(_ZThn1024_N9S20956C16D1Ev,_ZThn776_N9S20956C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S20956C16D0Ev,_ZTv0_n40_N9S20956C16D0Ev)();
extern void ABISELECT(_ZThn1024_N9S20956C16D0Ev,_ZThn776_N9S20956C16D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20956C17__9S20956C16__9S20956C15[] = {
  ABISELECT(-1024,-776),
  0,
  0,
  ABISELECT(-1928,-1496),
  ABISELECT(4280,3352),
  ABISELECT(2128,1680),
  ABISELECT(-1080,-820),
  ABISELECT(-1328,-1016),
  ABISELECT(-1024,-776),
  (VTBL_ENTRY)&(_ZTI9S20956C16[0]),
  (VTBL_ENTRY)&_ZN9S20956C172v8Ev,
  (VTBL_ENTRY)&_ZN9S20956C172v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S20956C16D1Ev,_ZTv0_n40_N9S20956C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S20956C16D0Ev,_ZTv0_n40_N9S20956C16D0Ev),
};
extern void ABISELECT(_ZTv0_n56_N9S20956C16D1Ev,_ZTv0_n28_N9S20956C16D1Ev)();
extern void ABISELECT(_ZThn3152_N9S20956C16D1Ev,_ZThn2456_N9S20956C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S20956C16D0Ev,_ZTv0_n28_N9S20956C16D0Ev)();
extern void ABISELECT(_ZThn3152_N9S20956C16D0Ev,_ZThn2456_N9S20956C16D0Ev)() __attribute__((weak));
extern void _ZN9S20956C132v6Ev();
extern void _ZN9S20956C132v7Ev();
static  VTBL_ENTRY _tg__ZTV9S20956C13__9S20956C16__9S20956C15[] = {
  0,
  0,
  ABISELECT(-3152,-2456),
  ABISELECT(-3456,-2696),
  ABISELECT(-4056,-3176),
  ABISELECT(2152,1672),
  ABISELECT(-3208,-2500),
  ABISELECT(-3152,-2456),
  (VTBL_ENTRY)&(_ZTI9S20956C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20956C16D1Ev,_ZTv0_n28_N9S20956C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20956C16D0Ev,_ZTv0_n28_N9S20956C16D0Ev),
  (VTBL_ENTRY)&_ZN9S20956C132v6Ev,
  (VTBL_ENTRY)&_ZN9S20956C132v7Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20956C16D1Ev,_ZTv0_n16_N9S20956C16D1Ev)();
extern void ABISELECT(_ZThn5304_N9S20956C16D1Ev,_ZThn4128_N9S20956C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20956C16D0Ev,_ZTv0_n16_N9S20956C16D0Ev)();
extern void ABISELECT(_ZThn5304_N9S20956C16D0Ev,_ZThn4128_N9S20956C16D0Ev)() __attribute__((weak));
extern void _ZN8S20956C92v3Ev();
extern void _ZN8S20956C92v4Ev();
extern void _ZN8S20956C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20956C9__9S20956C16__9S20956C15[] = {
  0,
  0,
  0,
  ABISELECT(-5304,-4128),
  ABISELECT(-5360,-4172),
  ABISELECT(-5304,-4128),
  (VTBL_ENTRY)&(_ZTI9S20956C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C16D1Ev,_ZTv0_n16_N9S20956C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C16D0Ev,_ZTv0_n16_N9S20956C16D0Ev),
  (VTBL_ENTRY)&_ZN8S20956C92v3Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v4Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20956C3__9S20956C16__9S20956C15[] = {
  ABISELECT(848,676),
  ABISELECT(600,480),
  ABISELECT(904,720),
  (VTBL_ENTRY)&(_ZTI9S20956C16[0]),
};
extern void _ZN9S20956C172v8Ev();
extern void _ZN9S20956C172v9Ev();
extern void _ZN9S20956C17D1Ev();
extern void _ZN9S20956C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20956C17__9S20956C15[] = {
  ABISELECT(-1928,-1496),
  ABISELECT(4280,3352),
  ABISELECT(2128,1680),
  ABISELECT(-1080,-820),
  ABISELECT(-1328,-1016),
  0,
  (VTBL_ENTRY)&(_ZTI9S20956C17[0]),
  (VTBL_ENTRY)&_ZN9S20956C172v8Ev,
  (VTBL_ENTRY)&_ZN9S20956C172v9Ev,
  (VTBL_ENTRY)&_ZN9S20956C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20956C17D0Ev,
};
static  VTBL_ENTRY _tg__ZTV9S20956C189S20956C17__9S20956C15[] = {
  ABISELECT(-1080,-820),
  ABISELECT(-1328,-1016),
  0,
  (VTBL_ENTRY)&(_ZTI9S20956C18[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20956C39S20956C189S20956C17__A1__9S20956C15[] = {
  ABISELECT(-1080,-820),
  ABISELECT(-1328,-1016),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C3[0]),
};
extern void ABISELECT(_ZTv0_n56_N9S20956C17D1Ev,_ZTv0_n28_N9S20956C17D1Ev)();
extern void ABISELECT(_ZThn2128_N9S20956C17D1Ev,_ZThn1680_N9S20956C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S20956C17D0Ev,_ZTv0_n28_N9S20956C17D0Ev)();
extern void ABISELECT(_ZThn2128_N9S20956C17D0Ev,_ZThn1680_N9S20956C17D0Ev)() __attribute__((weak));
extern void _ZN9S20956C132v6Ev();
extern void _ZN9S20956C132v7Ev();
static  VTBL_ENTRY _tg__ZTV9S20956C13__9S20956C17__9S20956C15[] = {
  0,
  0,
  ABISELECT(-2128,-1680),
  ABISELECT(-3456,-2696),
  ABISELECT(-4056,-3176),
  ABISELECT(2152,1672),
  ABISELECT(-3208,-2500),
  ABISELECT(-2128,-1680),
  (VTBL_ENTRY)&(_ZTI9S20956C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20956C17D1Ev,_ZTv0_n28_N9S20956C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20956C17D0Ev,_ZTv0_n28_N9S20956C17D0Ev),
  (VTBL_ENTRY)&_ZN9S20956C132v6Ev,
  (VTBL_ENTRY)&_ZN9S20956C132v7Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20956C17D1Ev,_ZTv0_n16_N9S20956C17D1Ev)();
extern void ABISELECT(_ZThn4280_N9S20956C17D1Ev,_ZThn3352_N9S20956C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20956C17D0Ev,_ZTv0_n16_N9S20956C17D0Ev)();
extern void ABISELECT(_ZThn4280_N9S20956C17D0Ev,_ZThn3352_N9S20956C17D0Ev)() __attribute__((weak));
extern void _ZN8S20956C92v3Ev();
extern void _ZN8S20956C92v4Ev();
extern void _ZN8S20956C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20956C9__9S20956C17__9S20956C15[] = {
  0,
  0,
  0,
  ABISELECT(-4280,-3352),
  ABISELECT(-5360,-4172),
  ABISELECT(-4280,-3352),
  (VTBL_ENTRY)&(_ZTI9S20956C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C17D1Ev,_ZTv0_n16_N9S20956C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C17D0Ev,_ZTv0_n16_N9S20956C17D0Ev),
  (VTBL_ENTRY)&_ZN8S20956C92v3Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v4Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20956C3__9S20956C17__9S20956C15[] = {
  ABISELECT(848,676),
  ABISELECT(600,480),
  ABISELECT(1928,1496),
  (VTBL_ENTRY)&(_ZTI9S20956C17[0]),
};
extern void _ZN9S20956C13D1Ev();
extern void _ZN9S20956C13D0Ev();
extern void _ZN9S20956C132v6Ev();
extern void _ZN9S20956C132v7Ev();
static  VTBL_ENTRY _tg__ZTV9S20956C13__9S20956C15[] = {
  ABISELECT(-3456,-2696),
  ABISELECT(-4056,-3176),
  ABISELECT(2152,1672),
  ABISELECT(-3208,-2500),
  0,
  (VTBL_ENTRY)&(_ZTI9S20956C13[0]),
  (VTBL_ENTRY)&_ZN9S20956C13D1Ev,
  (VTBL_ENTRY)&_ZN9S20956C13D0Ev,
  (VTBL_ENTRY)&_ZN9S20956C132v6Ev,
  (VTBL_ENTRY)&_ZN9S20956C132v7Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20956C13D1Ev,_ZTv0_n16_N9S20956C13D1Ev)();
extern void ABISELECT(_ZThn2152_N9S20956C13D1Ev,_ZThn1672_N9S20956C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20956C13D0Ev,_ZTv0_n16_N9S20956C13D0Ev)();
extern void ABISELECT(_ZThn2152_N9S20956C13D0Ev,_ZThn1672_N9S20956C13D0Ev)() __attribute__((weak));
extern void _ZN8S20956C92v3Ev();
extern void _ZN8S20956C92v4Ev();
extern void _ZN8S20956C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20956C9__9S20956C13__9S20956C15[] = {
  0,
  0,
  0,
  ABISELECT(-2152,-1672),
  ABISELECT(-5360,-4172),
  ABISELECT(-2152,-1672),
  (VTBL_ENTRY)&(_ZTI9S20956C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C13D1Ev,_ZTv0_n16_N9S20956C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C13D0Ev,_ZTv0_n16_N9S20956C13D0Ev),
  (VTBL_ENTRY)&_ZN8S20956C92v3Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v4Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20956C3__9S20956C13__9S20956C15[] = {
  ABISELECT(848,676),
  ABISELECT(600,480),
  ABISELECT(4056,3176),
  (VTBL_ENTRY)&(_ZTI9S20956C13[0]),
};
extern void _ZN8S20956C9D1Ev();
extern void _ZN8S20956C9D0Ev();
extern void _ZN8S20956C92v3Ev();
extern void _ZN8S20956C92v4Ev();
extern void _ZN8S20956C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20956C9__9S20956C15[] = {
  ABISELECT(-5360,-4172),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C9[0]),
  (VTBL_ENTRY)&_ZN8S20956C9D1Ev,
  (VTBL_ENTRY)&_ZN8S20956C9D0Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v3Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v4Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v5Ev,
};
static  VTT_ENTRY vtt_S20956C15[] = {
  {&(_ZTV9S20956C15[9]),  9,66},
  {&(_tg__ZTV8S20956C2__9S20956C15[5]),  5,5},
  {&(_tg__ZTV8S20956C3__8S20956C2__9S20956C15[4]),  4,4},
  {&(_ZTV9S20956C15[16]),  16,66},
  {&(_ZTV9S20956C15[25]),  25,66},
  {&(_ZTV9S20956C15[37]),  37,66},
  {&(_ZTV9S20956C15[50]),  50,66},
  {&(_ZTV9S20956C15[61]),  61,66},
  {&(_tg__ZTV8S20956C3__9S20956C15[4]),  4,4},
  {&(_tg__ZTV9S20956C16__9S20956C15[8]),  8,10},
  {&(_tg__ZTV9S20956C17__9S20956C16__9S20956C15[10]),  10,14},
  {&(_tg__ZTV9S20956C13__9S20956C16__9S20956C15[9]),  9,13},
  {&(_tg__ZTV8S20956C9__9S20956C16__9S20956C15[7]),  7,12},
  {&(_tg__ZTV8S20956C3__9S20956C16__9S20956C15[4]),  4,4},
  {&(_tg__ZTV9S20956C17__9S20956C15[7]),  7,11},
  {&(_tg__ZTV9S20956C189S20956C17__9S20956C15[4]),  4,4},
  {&(_tg__ZTV8S20956C39S20956C189S20956C17__A1__9S20956C15[4]),  4,4},
  {&(_tg__ZTV9S20956C13__9S20956C17__9S20956C15[9]),  9,13},
  {&(_tg__ZTV8S20956C9__9S20956C17__9S20956C15[7]),  7,12},
  {&(_tg__ZTV8S20956C3__9S20956C17__9S20956C15[4]),  4,4},
  {&(_tg__ZTV9S20956C13__9S20956C15[6]),  6,10},
  {&(_tg__ZTV8S20956C9__9S20956C13__9S20956C15[7]),  7,12},
  {&(_tg__ZTV8S20956C3__9S20956C13__9S20956C15[4]),  4,4},
  {&(_tg__ZTV8S20956C9__9S20956C15[3]),  3,8},
};
extern VTBL_ENTRY _ZTI9S20956C15[];
extern  VTBL_ENTRY _ZTV9S20956C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20956C15[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20956C13D0Ev,_ZTv0_n16_N9S20956C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2152_N9S20956C13D0Ev,_ZThn1672_N9S20956C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20956C13D1Ev,_ZTv0_n16_N9S20956C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2152_N9S20956C13D1Ev,_ZThn1672_N9S20956C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20956C17D0Ev,_ZTv0_n16_N9S20956C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4280_N9S20956C17D0Ev,_ZThn3352_N9S20956C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20956C17D1Ev,_ZTv0_n16_N9S20956C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4280_N9S20956C17D1Ev,_ZThn3352_N9S20956C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20956C17D0Ev,_ZTv0_n28_N9S20956C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2128_N9S20956C17D0Ev,_ZThn1680_N9S20956C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20956C17D1Ev,_ZTv0_n28_N9S20956C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2128_N9S20956C17D1Ev,_ZThn1680_N9S20956C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20956C16D0Ev,_ZTv0_n16_N9S20956C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5304_N9S20956C16D0Ev,_ZThn4128_N9S20956C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20956C16D1Ev,_ZTv0_n16_N9S20956C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5304_N9S20956C16D1Ev,_ZThn4128_N9S20956C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20956C16D0Ev,_ZTv0_n28_N9S20956C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3152_N9S20956C16D0Ev,_ZThn2456_N9S20956C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20956C16D1Ev,_ZTv0_n28_N9S20956C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3152_N9S20956C16D1Ev,_ZThn2456_N9S20956C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S20956C16D0Ev,_ZTv0_n40_N9S20956C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1024_N9S20956C16D0Ev,_ZThn776_N9S20956C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S20956C16D1Ev,_ZTv0_n40_N9S20956C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1024_N9S20956C16D1Ev,_ZThn776_N9S20956C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20956C15D0Ev,_ZTv0_n16_N9S20956C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8056_N9S20956C15D0Ev,_ZThn6300_N9S20956C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20956C15D1Ev,_ZTv0_n16_N9S20956C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8056_N9S20956C15D1Ev,_ZThn6300_N9S20956C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20956C15D0Ev,_ZTv0_n28_N9S20956C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5904_N9S20956C15D0Ev,_ZThn4628_N9S20956C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20956C15D1Ev,_ZTv0_n28_N9S20956C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5904_N9S20956C15D1Ev,_ZThn4628_N9S20956C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S20956C15D0Ev,_ZTv0_n40_N9S20956C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3776_N9S20956C15D0Ev,_ZThn2948_N9S20956C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S20956C15D1Ev,_ZTv0_n40_N9S20956C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3776_N9S20956C15D1Ev,_ZThn2948_N9S20956C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S20956C15D0Ev,_ZTv0_n36_N9S20956C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2752_N9S20956C15D0Ev,_ZThn2172_N9S20956C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S20956C15D1Ev,_ZTv0_n36_N9S20956C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2752_N9S20956C15D1Ev,_ZThn2172_N9S20956C15D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20956C15 = {  "S20956C15", // class name
  bases_S20956C15, 15,
  &(vtc_S20956C15[0]), // expected_vtbl_contents
  &(vtt_S20956C15[0]), // expected_vtt_contents
  ABISELECT(8464,6608), // object size
  NSPAIRA(_ZTI9S20956C15),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S20956C15),66, //virtual function table var
  9, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20956C15),24, //virtual table table var
  8, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20956C1  : virtual S20956C2 , virtual S20956C7 , S20956C11 , virtual S20956C15 {
  long double s20956c1f0;
  ::S20956C9 s20956c1f1[2];
  ::S20956C9 s20956c1f2[2];
  ::S20956C10 s20956c1f3;
  int s20956c1f4;
  long double s20956c1f5;
  virtual  ~S20956C1(); // _ZN8S20956C1D2Ev
  virtual void  v1(); // _ZN8S20956C12v1Ev
  virtual void  v2(); // _ZN8S20956C12v2Ev
  S20956C1(); // tgen
};
//SIG(1 S20956C1) C1{ VBC2{ VBC3{ VBC4{ BC5{ m FL Fi[4] Fc FL Fp[2]} Fi FC5 FC5 Fi Fp FL[6] Fp} VBC5 FC5 Fs Fi FC4 FL[4] FC4} BC4 Fi[2] FC4 FC4[5] FU6{ m Fi[8] Fp FL Fc Fp[5] FD Fc[7] Fp Fc:1 Fi} Fi} VBC7{ VBC8{ BC4 VBC2 FC2} Fi FC9{ VBC5 vd v3 v4 v5 Fi Fi FC5 Fi FC4 Fp FC5 Fc:3}[2] FU10{ m Fp FL Fi Fc Fi FL Fl FL Fs Fp FD Fc[6]}[8]} BC11{ BC12{ m Fi FC9[2] Fc} BC13{ BC4 VBC5 VBC9 VBC3 vd v6 v7 Fi FC14{} FD Fp FC9[2] FD FL Fi FC3} vd Fp[2] FU10 Fl Fp} VBC15{ BC2 VBC16{ VBC17{ VBC13 BC18{ VBC5 BC3 Fp Fc[9] FC3 FC4 FL:37 Fc FC4 Fc:8 Fp Fc Fi Fi} v8 v9 Fi Fi Fs FU10 Fi Fi Fs Fi Fi} vd FC9[2] FD FL FC5 Fp} vd v10 Fi Fi[7]} vd v1 v2 FD FC9[2] FC9[2] FU10 Fi FD}


 S20956C1 ::~S20956C1(){ note_dtor("S20956C1", this);}
void  S20956C1 ::v1(){vfunc_called(this, "_ZN8S20956C12v1Ev");}
void  S20956C1 ::v2(){vfunc_called(this, "_ZN8S20956C12v2Ev");}
S20956C1 ::S20956C1(){ note_ctor("S20956C1", this);} // tgen

static void Test_S20956C1()
{
  extern Class_Descriptor cd_S20956C1;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1210,3760)];
    init_test(&cd_S20956C1, buf);
    S20956C1 *dp, &lv = *(dp=new (buf) S20956C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(19344,15036), "sizeof(S20956C1)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20956C1)");
    /*is_ambiguous_... S20956C1::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C4*), ABISELECT(7440,5760), "S20956C1");
    /*is_ambiguous_... S20956C1::S20956C3 */ AMB_check_base_class_offset(lv, (S20956C4*)(S20956C3*), ABISELECT(7440,5760), "S20956C1");
    check_base_class_offset(lv, (S20956C4*)(S20956C3*)(S20956C18*)(S20956C17*), ABISELECT(7440,5760), "S20956C1");
    /*is_ambiguous_... S20956C1::S20956C3 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C3*), ABISELECT(7688,5956), "S20956C1");
    /*is_ambiguous_... S20956C13::S20956C5 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C13*)(S20956C11*), ABISELECT(7688,5956), "S20956C1");
    check_base_class_offset(lv, (S20956C5*)(S20956C9*), ABISELECT(7688,5956), "S20956C1");
    /*is_ambiguous_... S20956C1::S20956C13 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C13*), ABISELECT(7688,5956), "S20956C1");
    /*is_ambiguous_... S20956C18::S20956C5 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C18*)(S20956C17*), ABISELECT(7688,5956), "S20956C1");
    /*is_ambiguous_... S20956C3::S20956C5 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C3*)(S20956C18*)(S20956C17*), ABISELECT(7688,5956), "S20956C1");
    /*is_ambiguous_... S20956C1::S20956C2 */ AMB_check_base_class_offset(lv, (S20956C3*)(S20956C2*), ABISELECT(6840,5280), "S20956C1");
    check_base_class_offset(lv, (S20956C3*)(S20956C13*)(S20956C11*), ABISELECT(6840,5280), "S20956C1");
    check_base_class_offset(lv, (S20956C3*)(S20956C2*)(S20956C15*), ABISELECT(6840,5280), "S20956C1");
    /*is_ambiguous_... S20956C1::S20956C13 */ AMB_check_base_class_offset(lv, (S20956C3*)(S20956C13*), ABISELECT(6840,5280), "S20956C1");
    /*is_ambiguous_... S20956C1::S20956C2 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C4*)(S20956C2*), ABISELECT(5032,3864), "S20956C1");
    /*is_ambiguous_... S20956C1::S20956C2 */ AMB_check_base_class_offset(lv, (S20956C4*)(S20956C2*), ABISELECT(5032,3864), "S20956C1");
    /*is_ambiguous_... S20956C1::S20956C2 */ AMB_check_base_class_offset(lv, (S20956C2*), ABISELECT(5024,3860), "S20956C1");
    check_base_class_offset(lv, (S20956C2*)(S20956C8*), ABISELECT(5024,3860), "S20956C1");
    /*is_ambiguous_... S20956C8::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C4*)(S20956C8*), ABISELECT(8808,6812), "S20956C1");
    /*is_ambiguous_... S20956C8::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C4*)(S20956C8*), ABISELECT(8808,6812), "S20956C1");
    check_base_class_offset(lv, (S20956C8*)(S20956C7*), ABISELECT(8800,6808), "S20956C1");
    check_base_class_offset(lv, (S20956C7*), ABISELECT(7744,6000), "S20956C1");
    check_base_class_offset(lv, (S20956C12*)(S20956C11*), ABISELECT(2152,1672), "S20956C1");
    /*is_ambiguous_... S20956C13::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C4*)(S20956C13*)(S20956C11*), ABISELECT(8,4), "S20956C1");
    /*is_ambiguous_... S20956C13::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C4*)(S20956C13*)(S20956C11*), ABISELECT(8,4), "S20956C1");
    check_base_class_offset(lv, (S20956C9*)(S20956C13*)(S20956C11*), ABISELECT(11776,9148), "S20956C1");
    /*is_ambiguous_... S20956C1::S20956C13 */ AMB_check_base_class_offset(lv, (S20956C9*)(S20956C13*), ABISELECT(11776,9148), "S20956C1");
    check_base_class_offset(lv, (S20956C13*)(S20956C11*), 0, "S20956C1");
    check_base_class_offset(lv, (S20956C11*), 0, "S20956C1");
    /*is_ambiguous_... S20956C2::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C4*)(S20956C2*)(S20956C15*), ABISELECT(12184,9460), "S20956C1");
    /*is_ambiguous_... S20956C2::S20956C4 */ AMB_check_base_class_offset(lv, (S20956C4*)(S20956C2*)(S20956C15*), ABISELECT(12184,9460), "S20956C1");
    check_base_class_offset(lv, (S20956C2*)(S20956C15*), ABISELECT(12176,9456), "S20956C1");
    /*is_ambiguous_... S20956C1::S20956C13 */ AMB_check_base_class_offset(lv, (S20956C5*)(S20956C4*)(S20956C13*), ABISELECT(17192,13368), "S20956C1");
    /*is_ambiguous_... S20956C1::S20956C13 */ AMB_check_base_class_offset(lv, (S20956C4*)(S20956C13*), ABISELECT(17192,13368), "S20956C1");
    check_base_class_offset(lv, (S20956C13*)(S20956C17*), ABISELECT(17184,13364), "S20956C1");
    check_base_class_offset(lv, (S20956C3*)(S20956C18*)(S20956C17*), ABISELECT(15056,11684), "S20956C1");
    check_base_class_offset(lv, (S20956C18*)(S20956C17*), ABISELECT(15056,11684), "S20956C1");
    check_base_class_offset(lv, (S20956C17*)(S20956C16*), ABISELECT(15056,11684), "S20956C1");
    check_base_class_offset(lv, (S20956C16*)(S20956C15*), ABISELECT(14032,10908), "S20956C1");
    check_base_class_offset(lv, (S20956C15*), ABISELECT(12176,9456), "S20956C1");
    check_field_offset(lv, s20956c1f0, ABISELECT(3136,2412), "S20956C1.s20956c1f0");
    check_field_offset(lv, s20956c1f1, ABISELECT(3152,2424), "S20956C1.s20956c1f1");
    check_field_offset(lv, s20956c1f2, ABISELECT(4064,3128), "S20956C1.s20956c1f2");
    check_field_offset(lv, s20956c1f3, ABISELECT(4976,3832), "S20956C1.s20956c1f3");
    check_field_offset(lv, s20956c1f4, ABISELECT(4992,3844), "S20956C1.s20956c1f4");
    check_field_offset(lv, s20956c1f5, ABISELECT(5008,3848), "S20956C1.s20956c1f5");
    test_class_info(&lv, &cd_S20956C1);
    dp->~S20956C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20956C1(Test_S20956C1, "S20956C1", ABISELECT(19344,15036));

#else // __cplusplus

extern void _ZN8S20956C1C1Ev();
extern void _ZN8S20956C1D2Ev();
Name_Map name_map_S20956C1[] = {
  NSPAIR(_ZN8S20956C1C1Ev),
  NSPAIR(_ZN8S20956C1D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C4;
extern VTBL_ENTRY _ZTI8S20956C4[];
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C3;
extern VTBL_ENTRY _ZTI8S20956C3[];
extern  VTBL_ENTRY _ZTV8S20956C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C3[];
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C4;
extern VTBL_ENTRY _ZTI8S20956C4[];
extern Class_Descriptor cd_S20956C2;
extern VTBL_ENTRY _ZTI8S20956C2[];
extern  VTBL_ENTRY _ZTV8S20956C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C2[];
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C4;
extern VTBL_ENTRY _ZTI8S20956C4[];
extern Class_Descriptor cd_S20956C8;
extern VTBL_ENTRY _ZTI8S20956C8[];
extern  VTBL_ENTRY _ZTV8S20956C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C8[];
extern Class_Descriptor cd_S20956C7;
extern VTBL_ENTRY _ZTI8S20956C7[];
extern  VTBL_ENTRY _ZTV8S20956C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C7[];
extern Class_Descriptor cd_S20956C12;
extern VTBL_ENTRY _ZTI9S20956C12[];
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C4;
extern VTBL_ENTRY _ZTI8S20956C4[];
extern Class_Descriptor cd_S20956C9;
extern VTBL_ENTRY _ZTI8S20956C9[];
extern  VTBL_ENTRY _ZTV8S20956C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C9[];
extern Class_Descriptor cd_S20956C13;
extern VTBL_ENTRY _ZTI9S20956C13[];
extern  VTBL_ENTRY _ZTV9S20956C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20956C13[];
extern Class_Descriptor cd_S20956C11;
extern VTBL_ENTRY _ZTI9S20956C11[];
extern  VTBL_ENTRY _ZTV9S20956C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20956C11[];
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C4;
extern VTBL_ENTRY _ZTI8S20956C4[];
extern Class_Descriptor cd_S20956C2;
extern VTBL_ENTRY _ZTI8S20956C2[];
extern  VTBL_ENTRY _ZTV8S20956C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C2[];
extern Class_Descriptor cd_S20956C5;
extern VTBL_ENTRY _ZTI8S20956C5[];
extern Class_Descriptor cd_S20956C4;
extern VTBL_ENTRY _ZTI8S20956C4[];
extern Class_Descriptor cd_S20956C13;
extern VTBL_ENTRY _ZTI9S20956C13[];
extern  VTBL_ENTRY _ZTV9S20956C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20956C13[];
extern Class_Descriptor cd_S20956C3;
extern VTBL_ENTRY _ZTI8S20956C3[];
extern  VTBL_ENTRY _ZTV8S20956C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C3[];
extern Class_Descriptor cd_S20956C18;
extern VTBL_ENTRY _ZTI9S20956C18[];
extern  VTBL_ENTRY _ZTV9S20956C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20956C18[];
extern Class_Descriptor cd_S20956C17;
extern VTBL_ENTRY _ZTI9S20956C17[];
extern  VTBL_ENTRY _ZTV9S20956C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20956C17[];
extern Class_Descriptor cd_S20956C16;
extern VTBL_ENTRY _ZTI9S20956C16[];
extern  VTBL_ENTRY _ZTV9S20956C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20956C16[];
extern Class_Descriptor cd_S20956C15;
extern VTBL_ENTRY _ZTI9S20956C15[];
extern  VTBL_ENTRY _ZTV9S20956C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20956C15[];
static Base_Class bases_S20956C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20956C5,    ABISELECT(7440,5760), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20956C4,    ABISELECT(7440,5760), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20956C5,    ABISELECT(7688,5956), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20956C3,    ABISELECT(6840,5280), //bcp->offset
    24, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20956C5,    ABISELECT(5032,3864), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20956C4,    ABISELECT(5032,3864), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20956C2,    ABISELECT(5024,3860), //bcp->offset
    19, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20956C5,    ABISELECT(8808,6812), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20956C4,    ABISELECT(8808,6812), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20956C8,    ABISELECT(8800,6808), //bcp->offset
    35, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S20956C7,    ABISELECT(7744,6000), //bcp->offset
    28, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20956C12,    ABISELECT(2152,1672), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20956C5,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S20956C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S20956C9,    ABISELECT(11776,9148), //bcp->offset
    41, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    27, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    15, //immediately_derived
  0, 1},
  {&cd_S20956C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20956C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20956C5,    ABISELECT(12184,9460), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20956C4,    ABISELECT(12184,9460), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S20956C2,    ABISELECT(12176,9456), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    29, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S20956C5,    ABISELECT(17192,13368), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S20956C4,    ABISELECT(17192,13368), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S20956C13,    ABISELECT(17184,13364), //bcp->offset
    92, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    47, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    25, //immediately_derived
  0, 1},
  {&cd_S20956C3,    ABISELECT(15056,11684), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    43, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S20956C18,    ABISELECT(15056,11684), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    42, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S20956C17,    ABISELECT(15056,11684), //bcp->offset
    78, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    41, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    26, //immediately_derived
  0, 1},
  {&cd_S20956C16,    ABISELECT(14032,10908), //bcp->offset
    67, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    36, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    27, //immediately_derived
  0, 1},
  {&cd_S20956C15,    ABISELECT(12176,9456), //bcp->offset
    53, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20956C1[];
extern void _ZN8S20956C1D1Ev();
extern void _ZN8S20956C1D0Ev();
extern void _ZN9S20956C132v6Ev();
extern void _ZN9S20956C132v7Ev();
extern void _ZN8S20956C12v1Ev();
extern void _ZN8S20956C12v2Ev();
extern void ABISELECT(_ZTv0_n32_N8S20956C1D1Ev,_ZTv0_n16_N8S20956C1D1Ev)();
extern void ABISELECT(_ZThn11776_N8S20956C1D1Ev,_ZThn9148_N8S20956C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20956C1D0Ev,_ZTv0_n16_N8S20956C1D0Ev)();
extern void ABISELECT(_ZThn11776_N8S20956C1D0Ev,_ZThn9148_N8S20956C1D0Ev)() __attribute__((weak));
extern void _ZN8S20956C92v3Ev();
extern void _ZN8S20956C92v4Ev();
extern void _ZN8S20956C92v5Ev();
extern void ABISELECT(_ZTv0_n80_N8S20956C1D1Ev,_ZTv0_n40_N8S20956C1D1Ev)();
extern void ABISELECT(_ZThn12176_N8S20956C1D1Ev,_ZThn9456_N8S20956C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N8S20956C1D0Ev,_ZTv0_n40_N8S20956C1D0Ev)();
extern void ABISELECT(_ZThn12176_N8S20956C1D0Ev,_ZThn9456_N8S20956C1D0Ev)() __attribute__((weak));
extern void _ZN9S20956C153v10Ev();
extern void ABISELECT(_ZTv0_n72_N8S20956C1D1Ev,_ZTv0_n36_N8S20956C1D1Ev)();
extern void ABISELECT(_ZThn14032_N8S20956C1D1Ev,_ZThn10908_N8S20956C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S20956C1D0Ev,_ZTv0_n36_N8S20956C1D0Ev)();
extern void ABISELECT(_ZThn14032_N8S20956C1D0Ev,_ZThn10908_N8S20956C1D0Ev)() __attribute__((weak));
extern void _ZN9S20956C172v8Ev();
extern void _ZN9S20956C172v9Ev();
extern void ABISELECT(_ZTv0_n80_N8S20956C1D1Ev,_ZTv0_n40_N8S20956C1D1Ev)();
extern void ABISELECT(_ZThn15056_N8S20956C1D1Ev,_ZThn11684_N8S20956C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N8S20956C1D0Ev,_ZTv0_n40_N8S20956C1D0Ev)();
extern void ABISELECT(_ZThn15056_N8S20956C1D0Ev,_ZThn11684_N8S20956C1D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S20956C1D1Ev,_ZTv0_n28_N8S20956C1D1Ev)();
extern void ABISELECT(_ZThn17184_N8S20956C1D1Ev,_ZThn13364_N8S20956C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S20956C1D0Ev,_ZTv0_n28_N8S20956C1D0Ev)();
extern void ABISELECT(_ZThn17184_N8S20956C1D0Ev,_ZThn13364_N8S20956C1D0Ev)() __attribute__((weak));
extern void _ZN9S20956C132v6Ev();
extern void _ZN9S20956C132v7Ev();
static  VTBL_ENTRY vtc_S20956C1[] = {
  ABISELECT(17184,13364),
  ABISELECT(15056,11684),
  ABISELECT(14032,10908),
  ABISELECT(12176,9456),
  ABISELECT(8800,6808),
  ABISELECT(7744,6000),
  ABISELECT(5024,3860),
  ABISELECT(7440,5760),
  ABISELECT(6840,5280),
  ABISELECT(11776,9148),
  ABISELECT(7688,5956),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C1[0]),
  (VTBL_ENTRY)&_ZN8S20956C1D1Ev,
  (VTBL_ENTRY)&_ZN8S20956C1D0Ev,
  (VTBL_ENTRY)&_ZN9S20956C132v6Ev,
  (VTBL_ENTRY)&_ZN9S20956C132v7Ev,
  (VTBL_ENTRY)&_ZN8S20956C12v1Ev,
  (VTBL_ENTRY)&_ZN8S20956C12v2Ev,
  ABISELECT(2664,2096),
  ABISELECT(2416,1900),
  ABISELECT(1816,1420),
  ABISELECT(-5024,-3860),
  (VTBL_ENTRY)&(_ZTI8S20956C1[0]),
  ABISELECT(848,676),
  ABISELECT(600,480),
  ABISELECT(-6840,-5280),
  (VTBL_ENTRY)&(_ZTI8S20956C1[0]),
  ABISELECT(-56,-44),
  ABISELECT(-304,-240),
  ABISELECT(-904,-720),
  ABISELECT(-2720,-2140),
  ABISELECT(1056,808),
  ABISELECT(-7744,-6000),
  (VTBL_ENTRY)&(_ZTI8S20956C1[0]),
  ABISELECT(-1112,-852),
  ABISELECT(-1360,-1048),
  ABISELECT(-1960,-1528),
  ABISELECT(-3776,-2948),
  ABISELECT(-8800,-6808),
  (VTBL_ENTRY)&(_ZTI8S20956C1[0]),
  0,
  0,
  0,
  ABISELECT(-11776,-9148),
  ABISELECT(-4088,-3192),
  ABISELECT(-11776,-9148),
  (VTBL_ENTRY)&(_ZTI8S20956C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20956C1D1Ev,_ZTv0_n16_N8S20956C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20956C1D0Ev,_ZTv0_n16_N8S20956C1D0Ev),
  (VTBL_ENTRY)&_ZN8S20956C92v3Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v4Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v5Ev,
  0,
  ABISELECT(-12176,-9456),
  ABISELECT(-400,-308),
  ABISELECT(5008,3908),
  ABISELECT(2880,2228),
  ABISELECT(1856,1452),
  ABISELECT(-4488,-3500),
  ABISELECT(-4736,-3696),
  ABISELECT(-5336,-4176),
  ABISELECT(-12176,-9456),
  (VTBL_ENTRY)&(_ZTI8S20956C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S20956C1D1Ev,_ZTv0_n40_N8S20956C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S20956C1D0Ev,_ZTv0_n40_N8S20956C1D0Ev),
  (VTBL_ENTRY)&_ZN9S20956C153v10Ev,
  ABISELECT(-14032,-10908),
  ABISELECT(-6592,-5148),
  ABISELECT(-7192,-5628),
  ABISELECT(-2256,-1760),
  ABISELECT(-6344,-4952),
  ABISELECT(3152,2456),
  ABISELECT(1024,776),
  ABISELECT(-14032,-10908),
  (VTBL_ENTRY)&(_ZTI8S20956C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S20956C1D1Ev,_ZTv0_n36_N8S20956C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S20956C1D0Ev,_ZTv0_n36_N8S20956C1D0Ev),
  ABISELECT(-15056,-11684),
  0,
  0,
  ABISELECT(-8216,-6404),
  ABISELECT(-3280,-2536),
  ABISELECT(2128,1680),
  ABISELECT(-7368,-5728),
  ABISELECT(-7616,-5924),
  ABISELECT(-15056,-11684),
  (VTBL_ENTRY)&(_ZTI8S20956C1[0]),
  (VTBL_ENTRY)&_ZN9S20956C172v8Ev,
  (VTBL_ENTRY)&_ZN9S20956C172v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S20956C1D1Ev,_ZTv0_n40_N8S20956C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S20956C1D0Ev,_ZTv0_n40_N8S20956C1D0Ev),
  0,
  0,
  ABISELECT(-17184,-13364),
  ABISELECT(-9744,-7604),
  ABISELECT(-10344,-8084),
  ABISELECT(-5408,-4216),
  ABISELECT(-9496,-7408),
  ABISELECT(-17184,-13364),
  (VTBL_ENTRY)&(_ZTI8S20956C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S20956C1D1Ev,_ZTv0_n28_N8S20956C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S20956C1D0Ev,_ZTv0_n28_N8S20956C1D0Ev),
  (VTBL_ENTRY)&_ZN9S20956C132v6Ev,
  (VTBL_ENTRY)&_ZN9S20956C132v7Ev,
};
extern VTBL_ENTRY _ZTV8S20956C1[];
extern void _ZN9S20956C11D1Ev();
extern void _ZN9S20956C11D0Ev();
extern void _ZN9S20956C132v6Ev();
extern void _ZN9S20956C132v7Ev();
static  VTBL_ENTRY _tg__ZTV9S20956C11__8S20956C1[] = {
  ABISELECT(7440,5760),
  ABISELECT(6840,5280),
  ABISELECT(11776,9148),
  ABISELECT(7688,5956),
  0,
  (VTBL_ENTRY)&(_ZTI9S20956C11[0]),
  (VTBL_ENTRY)&_ZN9S20956C11D1Ev,
  (VTBL_ENTRY)&_ZN9S20956C11D0Ev,
  (VTBL_ENTRY)&_ZN9S20956C132v6Ev,
  (VTBL_ENTRY)&_ZN9S20956C132v7Ev,
};
extern void _ZN9S20956C13D1Ev();
extern void _ZN9S20956C13D0Ev();
extern void _ZN9S20956C132v6Ev();
extern void _ZN9S20956C132v7Ev();
static  VTBL_ENTRY _tg__ZTV9S20956C139S20956C11__8S20956C1[] = {
  ABISELECT(7440,5760),
  ABISELECT(6840,5280),
  ABISELECT(11776,9148),
  ABISELECT(7688,5956),
  0,
  (VTBL_ENTRY)&(_ZTI9S20956C13[0]),
  (VTBL_ENTRY)&_ZN9S20956C13D1Ev,
  (VTBL_ENTRY)&_ZN9S20956C13D0Ev,
  (VTBL_ENTRY)&_ZN9S20956C132v6Ev,
  (VTBL_ENTRY)&_ZN9S20956C132v7Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20956C13D1Ev,_ZTv0_n16_N9S20956C13D1Ev)();
extern void ABISELECT(_ZThn11776_N9S20956C13D1Ev,_ZThn9148_N9S20956C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20956C13D0Ev,_ZTv0_n16_N9S20956C13D0Ev)();
extern void ABISELECT(_ZThn11776_N9S20956C13D0Ev,_ZThn9148_N9S20956C13D0Ev)() __attribute__((weak));
extern void _ZN8S20956C92v3Ev();
extern void _ZN8S20956C92v4Ev();
extern void _ZN8S20956C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20956C9__9S20956C139S20956C11__8S20956C1[] = {
  0,
  0,
  0,
  ABISELECT(-11776,-9148),
  ABISELECT(-4088,-3192),
  ABISELECT(-11776,-9148),
  (VTBL_ENTRY)&(_ZTI9S20956C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C13D1Ev,_ZTv0_n16_N9S20956C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C13D0Ev,_ZTv0_n16_N9S20956C13D0Ev),
  (VTBL_ENTRY)&_ZN8S20956C92v3Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v4Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20956C3__9S20956C139S20956C11__8S20956C1[] = {
  ABISELECT(848,676),
  ABISELECT(600,480),
  ABISELECT(-6840,-5280),
  (VTBL_ENTRY)&(_ZTI9S20956C13[0]),
};
extern void ABISELECT(_ZTv0_n32_N9S20956C11D1Ev,_ZTv0_n16_N9S20956C11D1Ev)();
extern void ABISELECT(_ZThn11776_N9S20956C11D1Ev,_ZThn9148_N9S20956C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20956C11D0Ev,_ZTv0_n16_N9S20956C11D0Ev)();
extern void ABISELECT(_ZThn11776_N9S20956C11D0Ev,_ZThn9148_N9S20956C11D0Ev)() __attribute__((weak));
extern void _ZN8S20956C92v3Ev();
extern void _ZN8S20956C92v4Ev();
extern void _ZN8S20956C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20956C9__9S20956C11__8S20956C1[] = {
  0,
  0,
  0,
  ABISELECT(-11776,-9148),
  ABISELECT(-4088,-3192),
  ABISELECT(-11776,-9148),
  (VTBL_ENTRY)&(_ZTI9S20956C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C11D1Ev,_ZTv0_n16_N9S20956C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C11D0Ev,_ZTv0_n16_N9S20956C11D0Ev),
  (VTBL_ENTRY)&_ZN8S20956C92v3Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v4Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20956C3__9S20956C11__8S20956C1[] = {
  ABISELECT(848,676),
  ABISELECT(600,480),
  ABISELECT(-6840,-5280),
  (VTBL_ENTRY)&(_ZTI9S20956C11[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20956C2__8S20956C1[] = {
  ABISELECT(2664,2096),
  ABISELECT(2416,1900),
  ABISELECT(1816,1420),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C2[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20956C3__8S20956C2__8S20956C1[] = {
  ABISELECT(848,676),
  ABISELECT(600,480),
  ABISELECT(-1816,-1420),
  (VTBL_ENTRY)&(_ZTI8S20956C2[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20956C3__8S20956C1[] = {
  ABISELECT(848,676),
  ABISELECT(600,480),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C3[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20956C7__8S20956C1[] = {
  ABISELECT(-56,-44),
  ABISELECT(-304,-240),
  ABISELECT(-904,-720),
  ABISELECT(-2720,-2140),
  ABISELECT(1056,808),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C7[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20956C8__8S20956C7__8S20956C1[] = {
  ABISELECT(-1112,-852),
  ABISELECT(-1360,-1048),
  ABISELECT(-1960,-1528),
  ABISELECT(-3776,-2948),
  ABISELECT(-1056,-808),
  (VTBL_ENTRY)&(_ZTI8S20956C7[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20956C2__8S20956C7__8S20956C1[] = {
  ABISELECT(2664,2096),
  ABISELECT(2416,1900),
  ABISELECT(1816,1420),
  ABISELECT(2720,2140),
  (VTBL_ENTRY)&(_ZTI8S20956C7[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20956C3__8S20956C7__8S20956C1[] = {
  ABISELECT(848,676),
  ABISELECT(600,480),
  ABISELECT(904,720),
  (VTBL_ENTRY)&(_ZTI8S20956C7[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20956C8__8S20956C1[] = {
  ABISELECT(-1112,-852),
  ABISELECT(-1360,-1048),
  ABISELECT(-1960,-1528),
  ABISELECT(-3776,-2948),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C8[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20956C2__8S20956C8__8S20956C1[] = {
  ABISELECT(2664,2096),
  ABISELECT(2416,1900),
  ABISELECT(1816,1420),
  ABISELECT(3776,2948),
  (VTBL_ENTRY)&(_ZTI8S20956C8[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20956C3__8S20956C8__8S20956C1[] = {
  ABISELECT(848,676),
  ABISELECT(600,480),
  ABISELECT(1960,1528),
  (VTBL_ENTRY)&(_ZTI8S20956C8[0]),
};
extern void _ZN8S20956C9D1Ev();
extern void _ZN8S20956C9D0Ev();
extern void _ZN8S20956C92v3Ev();
extern void _ZN8S20956C92v4Ev();
extern void _ZN8S20956C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20956C9__8S20956C1[] = {
  ABISELECT(-4088,-3192),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C9[0]),
  (VTBL_ENTRY)&_ZN8S20956C9D1Ev,
  (VTBL_ENTRY)&_ZN8S20956C9D0Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v3Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v4Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v5Ev,
};
extern void _ZN9S20956C15D1Ev();
extern void _ZN9S20956C15D0Ev();
extern void _ZN9S20956C153v10Ev();
static  VTBL_ENTRY _tg__ZTV9S20956C15__8S20956C1[] = {
  ABISELECT(-400,-308),
  ABISELECT(5008,3908),
  ABISELECT(2880,2228),
  ABISELECT(1856,1452),
  ABISELECT(-4488,-3500),
  ABISELECT(-4736,-3696),
  ABISELECT(-5336,-4176),
  0,
  (VTBL_ENTRY)&(_ZTI9S20956C15[0]),
  (VTBL_ENTRY)&_ZN9S20956C15D1Ev,
  (VTBL_ENTRY)&_ZN9S20956C15D0Ev,
  (VTBL_ENTRY)&_ZN9S20956C153v10Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20956C29S20956C15__A1__8S20956C1[] = {
  ABISELECT(-4488,-3500),
  ABISELECT(-4736,-3696),
  ABISELECT(-5336,-4176),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C2[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20956C3__8S20956C29S20956C15__A1__8S20956C1[] = {
  ABISELECT(848,676),
  ABISELECT(600,480),
  ABISELECT(5336,4176),
  (VTBL_ENTRY)&(_ZTI8S20956C2[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20956C3__9S20956C15__8S20956C1[] = {
  ABISELECT(848,676),
  ABISELECT(600,480),
  ABISELECT(5336,4176),
  (VTBL_ENTRY)&(_ZTI9S20956C15[0]),
};
extern void ABISELECT(_ZTv0_n72_N9S20956C15D1Ev,_ZTv0_n36_N9S20956C15D1Ev)();
extern void ABISELECT(_ZThn1856_N9S20956C15D1Ev,_ZThn1452_N9S20956C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S20956C15D0Ev,_ZTv0_n36_N9S20956C15D0Ev)();
extern void ABISELECT(_ZThn1856_N9S20956C15D0Ev,_ZThn1452_N9S20956C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20956C16__9S20956C15__8S20956C1[] = {
  ABISELECT(-1856,-1452),
  ABISELECT(-6592,-5148),
  ABISELECT(-7192,-5628),
  ABISELECT(-2256,-1760),
  ABISELECT(-6344,-4952),
  ABISELECT(3152,2456),
  ABISELECT(1024,776),
  ABISELECT(-1856,-1452),
  (VTBL_ENTRY)&(_ZTI9S20956C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20956C15D1Ev,_ZTv0_n36_N9S20956C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20956C15D0Ev,_ZTv0_n36_N9S20956C15D0Ev),
};
extern void _ZN9S20956C172v8Ev();
extern void _ZN9S20956C172v9Ev();
extern void ABISELECT(_ZTv0_n80_N9S20956C15D1Ev,_ZTv0_n40_N9S20956C15D1Ev)();
extern void ABISELECT(_ZThn2880_N9S20956C15D1Ev,_ZThn2228_N9S20956C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S20956C15D0Ev,_ZTv0_n40_N9S20956C15D0Ev)();
extern void ABISELECT(_ZThn2880_N9S20956C15D0Ev,_ZThn2228_N9S20956C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20956C17__9S20956C15__8S20956C1[] = {
  ABISELECT(-2880,-2228),
  0,
  0,
  ABISELECT(-8216,-6404),
  ABISELECT(-3280,-2536),
  ABISELECT(2128,1680),
  ABISELECT(-7368,-5728),
  ABISELECT(-7616,-5924),
  ABISELECT(-2880,-2228),
  (VTBL_ENTRY)&(_ZTI9S20956C15[0]),
  (VTBL_ENTRY)&_ZN9S20956C172v8Ev,
  (VTBL_ENTRY)&_ZN9S20956C172v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S20956C15D1Ev,_ZTv0_n40_N9S20956C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S20956C15D0Ev,_ZTv0_n40_N9S20956C15D0Ev),
};
extern void ABISELECT(_ZTv0_n56_N9S20956C15D1Ev,_ZTv0_n28_N9S20956C15D1Ev)();
extern void ABISELECT(_ZThn5008_N9S20956C15D1Ev,_ZThn3908_N9S20956C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S20956C15D0Ev,_ZTv0_n28_N9S20956C15D0Ev)();
extern void ABISELECT(_ZThn5008_N9S20956C15D0Ev,_ZThn3908_N9S20956C15D0Ev)() __attribute__((weak));
extern void _ZN9S20956C132v6Ev();
extern void _ZN9S20956C132v7Ev();
static  VTBL_ENTRY _tg__ZTV9S20956C13__9S20956C15__8S20956C1[] = {
  0,
  0,
  ABISELECT(-5008,-3908),
  ABISELECT(-9744,-7604),
  ABISELECT(-10344,-8084),
  ABISELECT(-5408,-4216),
  ABISELECT(-9496,-7408),
  ABISELECT(-5008,-3908),
  (VTBL_ENTRY)&(_ZTI9S20956C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20956C15D1Ev,_ZTv0_n28_N9S20956C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20956C15D0Ev,_ZTv0_n28_N9S20956C15D0Ev),
  (VTBL_ENTRY)&_ZN9S20956C132v6Ev,
  (VTBL_ENTRY)&_ZN9S20956C132v7Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20956C15D1Ev,_ZTv0_n16_N9S20956C15D1Ev)();
extern void ABISELECT(_ZTv0_n32_N9S20956C15D0Ev,_ZTv0_n16_N9S20956C15D0Ev)();
extern void _ZN8S20956C92v3Ev();
extern void _ZN8S20956C92v4Ev();
extern void _ZN8S20956C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20956C9__9S20956C15__8S20956C1[] = {
  0,
  0,
  0,
  ABISELECT(400,308),
  ABISELECT(-4088,-3192),
  ABISELECT(400,308),
  (VTBL_ENTRY)&(_ZTI9S20956C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C15D1Ev,_ZTv0_n16_N9S20956C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C15D0Ev,_ZTv0_n16_N9S20956C15D0Ev),
  (VTBL_ENTRY)&_ZN8S20956C92v3Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v4Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v5Ev,
};
extern void _ZN9S20956C16D1Ev();
extern void _ZN9S20956C16D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20956C16__8S20956C1[] = {
  ABISELECT(-6592,-5148),
  ABISELECT(-7192,-5628),
  ABISELECT(-2256,-1760),
  ABISELECT(-6344,-4952),
  ABISELECT(3152,2456),
  ABISELECT(1024,776),
  0,
  (VTBL_ENTRY)&(_ZTI9S20956C16[0]),
  (VTBL_ENTRY)&_ZN9S20956C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20956C16D0Ev,
};
extern void _ZN9S20956C172v8Ev();
extern void _ZN9S20956C172v9Ev();
extern void ABISELECT(_ZTv0_n80_N9S20956C16D1Ev,_ZTv0_n40_N9S20956C16D1Ev)();
extern void ABISELECT(_ZThn1024_N9S20956C16D1Ev,_ZThn776_N9S20956C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S20956C16D0Ev,_ZTv0_n40_N9S20956C16D0Ev)();
extern void ABISELECT(_ZThn1024_N9S20956C16D0Ev,_ZThn776_N9S20956C16D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20956C17__9S20956C16__8S20956C1[] = {
  ABISELECT(-1024,-776),
  0,
  0,
  ABISELECT(-8216,-6404),
  ABISELECT(-3280,-2536),
  ABISELECT(2128,1680),
  ABISELECT(-7368,-5728),
  ABISELECT(-7616,-5924),
  ABISELECT(-1024,-776),
  (VTBL_ENTRY)&(_ZTI9S20956C16[0]),
  (VTBL_ENTRY)&_ZN9S20956C172v8Ev,
  (VTBL_ENTRY)&_ZN9S20956C172v9Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S20956C16D1Ev,_ZTv0_n40_N9S20956C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S20956C16D0Ev,_ZTv0_n40_N9S20956C16D0Ev),
};
extern void ABISELECT(_ZTv0_n56_N9S20956C16D1Ev,_ZTv0_n28_N9S20956C16D1Ev)();
extern void ABISELECT(_ZThn3152_N9S20956C16D1Ev,_ZThn2456_N9S20956C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S20956C16D0Ev,_ZTv0_n28_N9S20956C16D0Ev)();
extern void ABISELECT(_ZThn3152_N9S20956C16D0Ev,_ZThn2456_N9S20956C16D0Ev)() __attribute__((weak));
extern void _ZN9S20956C132v6Ev();
extern void _ZN9S20956C132v7Ev();
static  VTBL_ENTRY _tg__ZTV9S20956C13__9S20956C16__8S20956C1[] = {
  0,
  0,
  ABISELECT(-3152,-2456),
  ABISELECT(-9744,-7604),
  ABISELECT(-10344,-8084),
  ABISELECT(-5408,-4216),
  ABISELECT(-9496,-7408),
  ABISELECT(-3152,-2456),
  (VTBL_ENTRY)&(_ZTI9S20956C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20956C16D1Ev,_ZTv0_n28_N9S20956C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20956C16D0Ev,_ZTv0_n28_N9S20956C16D0Ev),
  (VTBL_ENTRY)&_ZN9S20956C132v6Ev,
  (VTBL_ENTRY)&_ZN9S20956C132v7Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20956C16D1Ev,_ZTv0_n16_N9S20956C16D1Ev)();
extern void ABISELECT(_ZTv0_n32_N9S20956C16D0Ev,_ZTv0_n16_N9S20956C16D0Ev)();
extern void _ZN8S20956C92v3Ev();
extern void _ZN8S20956C92v4Ev();
extern void _ZN8S20956C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20956C9__9S20956C16__8S20956C1[] = {
  0,
  0,
  0,
  ABISELECT(2256,1760),
  ABISELECT(-4088,-3192),
  ABISELECT(2256,1760),
  (VTBL_ENTRY)&(_ZTI9S20956C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C16D1Ev,_ZTv0_n16_N9S20956C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C16D0Ev,_ZTv0_n16_N9S20956C16D0Ev),
  (VTBL_ENTRY)&_ZN8S20956C92v3Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v4Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20956C3__9S20956C16__8S20956C1[] = {
  ABISELECT(848,676),
  ABISELECT(600,480),
  ABISELECT(7192,5628),
  (VTBL_ENTRY)&(_ZTI9S20956C16[0]),
};
extern void _ZN9S20956C172v8Ev();
extern void _ZN9S20956C172v9Ev();
extern void _ZN9S20956C17D1Ev();
extern void _ZN9S20956C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20956C17__8S20956C1[] = {
  ABISELECT(-8216,-6404),
  ABISELECT(-3280,-2536),
  ABISELECT(2128,1680),
  ABISELECT(-7368,-5728),
  ABISELECT(-7616,-5924),
  0,
  (VTBL_ENTRY)&(_ZTI9S20956C17[0]),
  (VTBL_ENTRY)&_ZN9S20956C172v8Ev,
  (VTBL_ENTRY)&_ZN9S20956C172v9Ev,
  (VTBL_ENTRY)&_ZN9S20956C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20956C17D0Ev,
};
static  VTBL_ENTRY _tg__ZTV9S20956C189S20956C17__8S20956C1[] = {
  ABISELECT(-7368,-5728),
  ABISELECT(-7616,-5924),
  0,
  (VTBL_ENTRY)&(_ZTI9S20956C18[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20956C39S20956C189S20956C17__A1__8S20956C1[] = {
  ABISELECT(-7368,-5728),
  ABISELECT(-7616,-5924),
  0,
  (VTBL_ENTRY)&(_ZTI8S20956C3[0]),
};
extern void ABISELECT(_ZTv0_n56_N9S20956C17D1Ev,_ZTv0_n28_N9S20956C17D1Ev)();
extern void ABISELECT(_ZThn2128_N9S20956C17D1Ev,_ZThn1680_N9S20956C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S20956C17D0Ev,_ZTv0_n28_N9S20956C17D0Ev)();
extern void ABISELECT(_ZThn2128_N9S20956C17D0Ev,_ZThn1680_N9S20956C17D0Ev)() __attribute__((weak));
extern void _ZN9S20956C132v6Ev();
extern void _ZN9S20956C132v7Ev();
static  VTBL_ENTRY _tg__ZTV9S20956C13__9S20956C17__8S20956C1[] = {
  0,
  0,
  ABISELECT(-2128,-1680),
  ABISELECT(-9744,-7604),
  ABISELECT(-10344,-8084),
  ABISELECT(-5408,-4216),
  ABISELECT(-9496,-7408),
  ABISELECT(-2128,-1680),
  (VTBL_ENTRY)&(_ZTI9S20956C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20956C17D1Ev,_ZTv0_n28_N9S20956C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20956C17D0Ev,_ZTv0_n28_N9S20956C17D0Ev),
  (VTBL_ENTRY)&_ZN9S20956C132v6Ev,
  (VTBL_ENTRY)&_ZN9S20956C132v7Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20956C17D1Ev,_ZTv0_n16_N9S20956C17D1Ev)();
extern void ABISELECT(_ZTv0_n32_N9S20956C17D0Ev,_ZTv0_n16_N9S20956C17D0Ev)();
extern void _ZN8S20956C92v3Ev();
extern void _ZN8S20956C92v4Ev();
extern void _ZN8S20956C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20956C9__9S20956C17__8S20956C1[] = {
  0,
  0,
  0,
  ABISELECT(3280,2536),
  ABISELECT(-4088,-3192),
  ABISELECT(3280,2536),
  (VTBL_ENTRY)&(_ZTI9S20956C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C17D1Ev,_ZTv0_n16_N9S20956C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C17D0Ev,_ZTv0_n16_N9S20956C17D0Ev),
  (VTBL_ENTRY)&_ZN8S20956C92v3Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v4Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20956C3__9S20956C17__8S20956C1[] = {
  ABISELECT(848,676),
  ABISELECT(600,480),
  ABISELECT(8216,6404),
  (VTBL_ENTRY)&(_ZTI9S20956C17[0]),
};
extern void _ZN9S20956C13D1Ev();
extern void _ZN9S20956C13D0Ev();
extern void _ZN9S20956C132v6Ev();
extern void _ZN9S20956C132v7Ev();
static  VTBL_ENTRY _tg__ZTV9S20956C13__A1__8S20956C1[] = {
  ABISELECT(-9744,-7604),
  ABISELECT(-10344,-8084),
  ABISELECT(-5408,-4216),
  ABISELECT(-9496,-7408),
  0,
  (VTBL_ENTRY)&(_ZTI9S20956C13[0]),
  (VTBL_ENTRY)&_ZN9S20956C13D1Ev,
  (VTBL_ENTRY)&_ZN9S20956C13D0Ev,
  (VTBL_ENTRY)&_ZN9S20956C132v6Ev,
  (VTBL_ENTRY)&_ZN9S20956C132v7Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20956C13D1Ev,_ZTv0_n16_N9S20956C13D1Ev)();
extern void ABISELECT(_ZTv0_n32_N9S20956C13D0Ev,_ZTv0_n16_N9S20956C13D0Ev)();
extern void _ZN8S20956C92v3Ev();
extern void _ZN8S20956C92v4Ev();
extern void _ZN8S20956C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20956C9__9S20956C13__A1__8S20956C1[] = {
  0,
  0,
  0,
  ABISELECT(5408,4216),
  ABISELECT(-4088,-3192),
  ABISELECT(5408,4216),
  (VTBL_ENTRY)&(_ZTI9S20956C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C13D1Ev,_ZTv0_n16_N9S20956C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20956C13D0Ev,_ZTv0_n16_N9S20956C13D0Ev),
  (VTBL_ENTRY)&_ZN8S20956C92v3Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v4Ev,
  (VTBL_ENTRY)&_ZN8S20956C92v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20956C3__9S20956C13__A1__8S20956C1[] = {
  ABISELECT(848,676),
  ABISELECT(600,480),
  ABISELECT(10344,8084),
  (VTBL_ENTRY)&(_ZTI9S20956C13[0]),
};
static  VTT_ENTRY vtt_S20956C1[] = {
  {&(_ZTV8S20956C1[13]),  13,105},
  {&(_tg__ZTV9S20956C11__8S20956C1[6]),  6,10},
  {&(_tg__ZTV9S20956C139S20956C11__8S20956C1[6]),  6,10},
  {&(_tg__ZTV8S20956C9__9S20956C139S20956C11__8S20956C1[7]),  7,12},
  {&(_tg__ZTV8S20956C3__9S20956C139S20956C11__8S20956C1[4]),  4,4},
  {&(_tg__ZTV8S20956C9__9S20956C11__8S20956C1[7]),  7,12},
  {&(_tg__ZTV8S20956C3__9S20956C11__8S20956C1[4]),  4,4},
  {&(_ZTV8S20956C1[24]),  24,105},
  {&(_ZTV8S20956C1[28]),  28,105},
  {&(_ZTV8S20956C1[35]),  35,105},
  {&(_ZTV8S20956C1[41]),  41,105},
  {&(_ZTV8S20956C1[48]),  48,105},
  {&(_ZTV8S20956C1[64]),  64,105},
  {&(_ZTV8S20956C1[76]),  76,105},
  {&(_ZTV8S20956C1[88]),  88,105},
  {&(_ZTV8S20956C1[101]),  101,105},
  {&(_tg__ZTV8S20956C2__8S20956C1[5]),  5,5},
  {&(_tg__ZTV8S20956C3__8S20956C2__8S20956C1[4]),  4,4},
  {&(_tg__ZTV8S20956C3__8S20956C1[4]),  4,4},
  {&(_tg__ZTV8S20956C7__8S20956C1[7]),  7,7},
  {&(_tg__ZTV8S20956C8__8S20956C7__8S20956C1[6]),  6,6},
  {&(_tg__ZTV8S20956C2__8S20956C7__8S20956C1[5]),  5,5},
  {&(_tg__ZTV8S20956C3__8S20956C7__8S20956C1[4]),  4,4},
  {&(_tg__ZTV8S20956C8__8S20956C1[6]),  6,6},
  {&(_tg__ZTV8S20956C2__8S20956C8__8S20956C1[5]),  5,5},
  {&(_tg__ZTV8S20956C3__8S20956C8__8S20956C1[4]),  4,4},
  {&(_tg__ZTV8S20956C9__8S20956C1[3]),  3,8},
  {&(_tg__ZTV9S20956C15__8S20956C1[9]),  9,12},
  {&(_tg__ZTV8S20956C29S20956C15__A1__8S20956C1[5]),  5,5},
  {&(_tg__ZTV8S20956C3__8S20956C29S20956C15__A1__8S20956C1[4]),  4,4},
  {&(_tg__ZTV8S20956C3__9S20956C15__8S20956C1[4]),  4,4},
  {&(_tg__ZTV9S20956C16__9S20956C15__8S20956C1[9]),  9,11},
  {&(_tg__ZTV9S20956C17__9S20956C15__8S20956C1[10]),  10,14},
  {&(_tg__ZTV9S20956C13__9S20956C15__8S20956C1[9]),  9,13},
  {&(_tg__ZTV8S20956C9__9S20956C15__8S20956C1[7]),  7,12},
  {&(_tg__ZTV9S20956C16__8S20956C1[8]),  8,10},
  {&(_tg__ZTV9S20956C17__9S20956C16__8S20956C1[10]),  10,14},
  {&(_tg__ZTV9S20956C13__9S20956C16__8S20956C1[9]),  9,13},
  {&(_tg__ZTV8S20956C9__9S20956C16__8S20956C1[7]),  7,12},
  {&(_tg__ZTV8S20956C3__9S20956C16__8S20956C1[4]),  4,4},
  {&(_tg__ZTV9S20956C17__8S20956C1[7]),  7,11},
  {&(_tg__ZTV9S20956C189S20956C17__8S20956C1[4]),  4,4},
  {&(_tg__ZTV8S20956C39S20956C189S20956C17__A1__8S20956C1[4]),  4,4},
  {&(_tg__ZTV9S20956C13__9S20956C17__8S20956C1[9]),  9,13},
  {&(_tg__ZTV8S20956C9__9S20956C17__8S20956C1[7]),  7,12},
  {&(_tg__ZTV8S20956C3__9S20956C17__8S20956C1[4]),  4,4},
  {&(_tg__ZTV9S20956C13__A1__8S20956C1[6]),  6,10},
  {&(_tg__ZTV8S20956C9__9S20956C13__A1__8S20956C1[7]),  7,12},
  {&(_tg__ZTV8S20956C3__9S20956C13__A1__8S20956C1[4]),  4,4},
};
extern VTBL_ENTRY _ZTI8S20956C1[];
extern  VTBL_ENTRY _ZTV8S20956C1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20956C1[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20956C17D0Ev,_ZTv0_n28_N9S20956C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2128_N9S20956C17D0Ev,_ZThn1680_N9S20956C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20956C17D1Ev,_ZTv0_n28_N9S20956C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2128_N9S20956C17D1Ev,_ZThn1680_N9S20956C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20956C16D0Ev,_ZTv0_n28_N9S20956C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3152_N9S20956C16D0Ev,_ZThn2456_N9S20956C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20956C16D1Ev,_ZTv0_n28_N9S20956C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3152_N9S20956C16D1Ev,_ZThn2456_N9S20956C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S20956C16D0Ev,_ZTv0_n40_N9S20956C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1024_N9S20956C16D0Ev,_ZThn776_N9S20956C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S20956C16D1Ev,_ZTv0_n40_N9S20956C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1024_N9S20956C16D1Ev,_ZThn776_N9S20956C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20956C15D0Ev,_ZTv0_n28_N9S20956C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5008_N9S20956C15D0Ev,_ZThn3908_N9S20956C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20956C15D1Ev,_ZTv0_n28_N9S20956C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5008_N9S20956C15D1Ev,_ZThn3908_N9S20956C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S20956C15D0Ev,_ZTv0_n40_N9S20956C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2880_N9S20956C15D0Ev,_ZThn2228_N9S20956C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S20956C15D1Ev,_ZTv0_n40_N9S20956C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2880_N9S20956C15D1Ev,_ZThn2228_N9S20956C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S20956C15D0Ev,_ZTv0_n36_N9S20956C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1856_N9S20956C15D0Ev,_ZThn1452_N9S20956C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S20956C15D1Ev,_ZTv0_n36_N9S20956C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1856_N9S20956C15D1Ev,_ZThn1452_N9S20956C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20956C11D0Ev,_ZTv0_n16_N9S20956C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11776_N9S20956C11D0Ev,_ZThn9148_N9S20956C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20956C11D1Ev,_ZTv0_n16_N9S20956C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11776_N9S20956C11D1Ev,_ZThn9148_N9S20956C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20956C13D0Ev,_ZTv0_n16_N9S20956C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11776_N9S20956C13D0Ev,_ZThn9148_N9S20956C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20956C13D1Ev,_ZTv0_n16_N9S20956C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11776_N9S20956C13D1Ev,_ZThn9148_N9S20956C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S20956C1D0Ev,_ZTv0_n28_N8S20956C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17184_N8S20956C1D0Ev,_ZThn13364_N8S20956C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S20956C1D1Ev,_ZTv0_n28_N8S20956C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17184_N8S20956C1D1Ev,_ZThn13364_N8S20956C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S20956C1D0Ev,_ZTv0_n36_N8S20956C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14032_N8S20956C1D0Ev,_ZThn10908_N8S20956C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S20956C1D1Ev,_ZTv0_n36_N8S20956C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14032_N8S20956C1D1Ev,_ZThn10908_N8S20956C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S20956C1D0Ev,_ZTv0_n40_N8S20956C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15056_N8S20956C1D0Ev,_ZThn11684_N8S20956C1D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn12176_N8S20956C1D0Ev,_ZThn9456_N8S20956C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S20956C1D1Ev,_ZTv0_n40_N8S20956C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15056_N8S20956C1D1Ev,_ZThn11684_N8S20956C1D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn12176_N8S20956C1D1Ev,_ZThn9456_N8S20956C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S20956C1D0Ev,_ZTv0_n16_N8S20956C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11776_N8S20956C1D0Ev,_ZThn9148_N8S20956C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S20956C1D1Ev,_ZTv0_n16_N8S20956C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11776_N8S20956C1D1Ev,_ZThn9148_N8S20956C1D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20956C1 = {  "S20956C1", // class name
  bases_S20956C1, 28,
  &(vtc_S20956C1[0]), // expected_vtbl_contents
  &(vtt_S20956C1[0]), // expected_vtt_contents
  ABISELECT(19344,15036), // object size
  NSPAIRA(_ZTI8S20956C1),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S20956C1),105, //virtual function table var
  13, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20956C1),49, //virtual table table var
  14, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2423C4_nt  {
  virtual  ~S2423C4_nt(); // _ZN10S2423C4_ntD1Ev
  virtual void  v7(); // _ZN10S2423C4_nt2v7Ev
  virtual void  v8(); // _ZN10S2423C4_nt2v8Ev
  virtual void  v9(); // _ZN10S2423C4_nt2v9Ev
  virtual void  v10(); // _ZN10S2423C4_nt3v10Ev
  virtual void  v11(); // _ZN10S2423C4_nt3v11Ev
  virtual void  v12(); // _ZN10S2423C4_nt3v12Ev
  virtual void  v13(); // _ZN10S2423C4_nt3v13Ev
  virtual void  v14(); // _ZN10S2423C4_nt3v14Ev
  virtual void  v15(); // _ZN10S2423C4_nt3v15Ev
  virtual void  v16(); // _ZN10S2423C4_nt3v16Ev
  virtual void  v17(); // _ZN10S2423C4_nt3v17Ev
  virtual void  v18(); // _ZN10S2423C4_nt3v18Ev
  virtual void  v19(); // _ZN10S2423C4_nt3v19Ev
  virtual void  v20(); // _ZN10S2423C4_nt3v20Ev
  virtual void  v21(); // _ZN10S2423C4_nt3v21Ev
  virtual void  v22(); // _ZN10S2423C4_nt3v22Ev
  virtual void  v23(); // _ZN10S2423C4_nt3v23Ev
  virtual void  v24(); // _ZN10S2423C4_nt3v24Ev
  virtual void  v25(); // _ZN10S2423C4_nt3v25Ev
  virtual void  v26(); // _ZN10S2423C4_nt3v26Ev
  virtual void  v27(); // _ZN10S2423C4_nt3v27Ev
  virtual void  v28(); // _ZN10S2423C4_nt3v28Ev
  virtual void  v29(); // _ZN10S2423C4_nt3v29Ev
  virtual void  v30(); // _ZN10S2423C4_nt3v30Ev
  virtual void  v31(); // _ZN10S2423C4_nt3v31Ev
  virtual void  v32(); // _ZN10S2423C4_nt3v32Ev
  S2423C4_nt(); // tgen
};
//SIG(-1 S2423C4_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26}


 S2423C4_nt ::~S2423C4_nt(){ note_dtor("S2423C4_nt", this);}
void  S2423C4_nt ::v7(){vfunc_called(this, "_ZN10S2423C4_nt2v7Ev");}
void  S2423C4_nt ::v8(){vfunc_called(this, "_ZN10S2423C4_nt2v8Ev");}
void  S2423C4_nt ::v9(){vfunc_called(this, "_ZN10S2423C4_nt2v9Ev");}
void  S2423C4_nt ::v10(){vfunc_called(this, "_ZN10S2423C4_nt3v10Ev");}
void  S2423C4_nt ::v11(){vfunc_called(this, "_ZN10S2423C4_nt3v11Ev");}
void  S2423C4_nt ::v12(){vfunc_called(this, "_ZN10S2423C4_nt3v12Ev");}
void  S2423C4_nt ::v13(){vfunc_called(this, "_ZN10S2423C4_nt3v13Ev");}
void  S2423C4_nt ::v14(){vfunc_called(this, "_ZN10S2423C4_nt3v14Ev");}
void  S2423C4_nt ::v15(){vfunc_called(this, "_ZN10S2423C4_nt3v15Ev");}
void  S2423C4_nt ::v16(){vfunc_called(this, "_ZN10S2423C4_nt3v16Ev");}
void  S2423C4_nt ::v17(){vfunc_called(this, "_ZN10S2423C4_nt3v17Ev");}
void  S2423C4_nt ::v18(){vfunc_called(this, "_ZN10S2423C4_nt3v18Ev");}
void  S2423C4_nt ::v19(){vfunc_called(this, "_ZN10S2423C4_nt3v19Ev");}
void  S2423C4_nt ::v20(){vfunc_called(this, "_ZN10S2423C4_nt3v20Ev");}
void  S2423C4_nt ::v21(){vfunc_called(this, "_ZN10S2423C4_nt3v21Ev");}
void  S2423C4_nt ::v22(){vfunc_called(this, "_ZN10S2423C4_nt3v22Ev");}
void  S2423C4_nt ::v23(){vfunc_called(this, "_ZN10S2423C4_nt3v23Ev");}
void  S2423C4_nt ::v24(){vfunc_called(this, "_ZN10S2423C4_nt3v24Ev");}
void  S2423C4_nt ::v25(){vfunc_called(this, "_ZN10S2423C4_nt3v25Ev");}
void  S2423C4_nt ::v26(){vfunc_called(this, "_ZN10S2423C4_nt3v26Ev");}
void  S2423C4_nt ::v27(){vfunc_called(this, "_ZN10S2423C4_nt3v27Ev");}
void  S2423C4_nt ::v28(){vfunc_called(this, "_ZN10S2423C4_nt3v28Ev");}
void  S2423C4_nt ::v29(){vfunc_called(this, "_ZN10S2423C4_nt3v29Ev");}
void  S2423C4_nt ::v30(){vfunc_called(this, "_ZN10S2423C4_nt3v30Ev");}
void  S2423C4_nt ::v31(){vfunc_called(this, "_ZN10S2423C4_nt3v31Ev");}
void  S2423C4_nt ::v32(){vfunc_called(this, "_ZN10S2423C4_nt3v32Ev");}
S2423C4_nt ::S2423C4_nt(){ note_ctor("S2423C4_nt", this);} // tgen

//skip512 S2423C4_nt

#else // __cplusplus

extern void _ZN10S2423C4_ntC1Ev();
extern void _ZN10S2423C4_ntD1Ev();
Name_Map name_map_S2423C4_nt[] = {
  NSPAIR(_ZN10S2423C4_ntC1Ev),
  NSPAIR(_ZN10S2423C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S2423C4_nt[];
extern void _ZN10S2423C4_ntD1Ev();
extern void _ZN10S2423C4_ntD0Ev();
extern void _ZN10S2423C4_nt2v7Ev();
extern void _ZN10S2423C4_nt2v8Ev();
extern void _ZN10S2423C4_nt2v9Ev();
extern void _ZN10S2423C4_nt3v10Ev();
extern void _ZN10S2423C4_nt3v11Ev();
extern void _ZN10S2423C4_nt3v12Ev();
extern void _ZN10S2423C4_nt3v13Ev();
extern void _ZN10S2423C4_nt3v14Ev();
extern void _ZN10S2423C4_nt3v15Ev();
extern void _ZN10S2423C4_nt3v16Ev();
extern void _ZN10S2423C4_nt3v17Ev();
extern void _ZN10S2423C4_nt3v18Ev();
extern void _ZN10S2423C4_nt3v19Ev();
extern void _ZN10S2423C4_nt3v20Ev();
extern void _ZN10S2423C4_nt3v21Ev();
extern void _ZN10S2423C4_nt3v22Ev();
extern void _ZN10S2423C4_nt3v23Ev();
extern void _ZN10S2423C4_nt3v24Ev();
extern void _ZN10S2423C4_nt3v25Ev();
extern void _ZN10S2423C4_nt3v26Ev();
extern void _ZN10S2423C4_nt3v27Ev();
extern void _ZN10S2423C4_nt3v28Ev();
extern void _ZN10S2423C4_nt3v29Ev();
extern void _ZN10S2423C4_nt3v30Ev();
extern void _ZN10S2423C4_nt3v31Ev();
extern void _ZN10S2423C4_nt3v32Ev();
static  VTBL_ENTRY vtc_S2423C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2423C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S2423C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v32Ev,
};
extern VTBL_ENTRY _ZTI10S2423C4_nt[];
VTBL_ENTRY *P__ZTI10S2423C4_nt = _ZTI10S2423C4_nt; 
extern  VTBL_ENTRY _ZTV10S2423C4_nt[];
Class_Descriptor cd_S2423C4_nt = {  "S2423C4_nt", // class name
  0,0,//no base classes
  &(vtc_S2423C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S2423C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S2423C4_nt),30, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2423C5_nt  {
  int s2423c5f0[2];
};
//SIG(-1 S2423C5_nt) C1{ Fi[2]}



//skip512 S2423C5_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2423C3  : S2423C4_nt {
  void *s2423c3f0[2];
  int s2423c3f1[4];
  ::S2423C5_nt s2423c3f2;
  void *s2423c3f3;
  char s2423c3f4;
  void *s2423c3f5;
  virtual  ~S2423C3(); // _ZN7S2423C3D1Ev
  virtual void  v33(); // _ZN7S2423C33v33Ev
  virtual void  v34(); // _ZN7S2423C33v34Ev
  virtual void  v35(); // _ZN7S2423C33v35Ev
  virtual void  v36(); // _ZN7S2423C33v36Ev
  virtual void  v37(); // _ZN7S2423C33v37Ev
  virtual void  v38(); // _ZN7S2423C33v38Ev
  virtual void  v39(); // _ZN7S2423C33v39Ev
  virtual void  v40(); // _ZN7S2423C33v40Ev
  virtual void  v41(); // _ZN7S2423C33v41Ev
  virtual void  v42(); // _ZN7S2423C33v42Ev
  virtual void  v43(); // _ZN7S2423C33v43Ev
  virtual void  v44(); // _ZN7S2423C33v44Ev
  virtual void  v45(); // _ZN7S2423C33v45Ev
  virtual void  v46(); // _ZN7S2423C33v46Ev
  S2423C3(); // tgen
};
//SIG(-1 S2423C3) C1{ BC2{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] Fi[4] FC3{ Fi[2]} Fp Fc Fp}


 S2423C3 ::~S2423C3(){ note_dtor("S2423C3", this);}
void  S2423C3 ::v33(){vfunc_called(this, "_ZN7S2423C33v33Ev");}
void  S2423C3 ::v34(){vfunc_called(this, "_ZN7S2423C33v34Ev");}
void  S2423C3 ::v35(){vfunc_called(this, "_ZN7S2423C33v35Ev");}
void  S2423C3 ::v36(){vfunc_called(this, "_ZN7S2423C33v36Ev");}
void  S2423C3 ::v37(){vfunc_called(this, "_ZN7S2423C33v37Ev");}
void  S2423C3 ::v38(){vfunc_called(this, "_ZN7S2423C33v38Ev");}
void  S2423C3 ::v39(){vfunc_called(this, "_ZN7S2423C33v39Ev");}
void  S2423C3 ::v40(){vfunc_called(this, "_ZN7S2423C33v40Ev");}
void  S2423C3 ::v41(){vfunc_called(this, "_ZN7S2423C33v41Ev");}
void  S2423C3 ::v42(){vfunc_called(this, "_ZN7S2423C33v42Ev");}
void  S2423C3 ::v43(){vfunc_called(this, "_ZN7S2423C33v43Ev");}
void  S2423C3 ::v44(){vfunc_called(this, "_ZN7S2423C33v44Ev");}
void  S2423C3 ::v45(){vfunc_called(this, "_ZN7S2423C33v45Ev");}
void  S2423C3 ::v46(){vfunc_called(this, "_ZN7S2423C33v46Ev");}
S2423C3 ::S2423C3(){ note_ctor("S2423C3", this);} // tgen

static void Test_S2423C3()
{
  extern Class_Descriptor cd_S2423C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,13)];
    init_test(&cd_S2423C3, buf);
    S2423C3 *dp, &lv = *(dp=new (buf) S2423C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,48), "sizeof(S2423C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2423C3)");
    check_base_class_offset(lv, (S2423C4_nt*), 0, "S2423C3");
    check_field_offset(lv, s2423c3f0, ABISELECT(8,4), "S2423C3.s2423c3f0");
    check_field_offset(lv, s2423c3f1, ABISELECT(24,12), "S2423C3.s2423c3f1");
    check_field_offset(lv, s2423c3f2, ABISELECT(40,28), "S2423C3.s2423c3f2");
    check_field_offset(lv, s2423c3f3, ABISELECT(48,36), "S2423C3.s2423c3f3");
    check_field_offset(lv, s2423c3f4, ABISELECT(56,40), "S2423C3.s2423c3f4");
    check_field_offset(lv, s2423c3f5, ABISELECT(64,44), "S2423C3.s2423c3f5");
    test_class_info(&lv, &cd_S2423C3);
    dp->~S2423C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2423C3(Test_S2423C3, "S2423C3", ABISELECT(72,48));

#else // __cplusplus

extern void _ZN7S2423C3C1Ev();
extern void _ZN7S2423C3D1Ev();
Name_Map name_map_S2423C3[] = {
  NSPAIR(_ZN7S2423C3C1Ev),
  NSPAIR(_ZN7S2423C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2423C4_nt;
extern VTBL_ENTRY _ZTI10S2423C4_nt[];
extern  VTBL_ENTRY _ZTV10S2423C4_nt[];
static Base_Class bases_S2423C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2423C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2423C3[];
extern void _ZN7S2423C3D1Ev();
extern void _ZN7S2423C3D0Ev();
extern void _ZN10S2423C4_nt2v7Ev();
extern void _ZN10S2423C4_nt2v8Ev();
extern void _ZN10S2423C4_nt2v9Ev();
extern void _ZN10S2423C4_nt3v10Ev();
extern void _ZN10S2423C4_nt3v11Ev();
extern void _ZN10S2423C4_nt3v12Ev();
extern void _ZN10S2423C4_nt3v13Ev();
extern void _ZN10S2423C4_nt3v14Ev();
extern void _ZN10S2423C4_nt3v15Ev();
extern void _ZN10S2423C4_nt3v16Ev();
extern void _ZN10S2423C4_nt3v17Ev();
extern void _ZN10S2423C4_nt3v18Ev();
extern void _ZN10S2423C4_nt3v19Ev();
extern void _ZN10S2423C4_nt3v20Ev();
extern void _ZN10S2423C4_nt3v21Ev();
extern void _ZN10S2423C4_nt3v22Ev();
extern void _ZN10S2423C4_nt3v23Ev();
extern void _ZN10S2423C4_nt3v24Ev();
extern void _ZN10S2423C4_nt3v25Ev();
extern void _ZN10S2423C4_nt3v26Ev();
extern void _ZN10S2423C4_nt3v27Ev();
extern void _ZN10S2423C4_nt3v28Ev();
extern void _ZN10S2423C4_nt3v29Ev();
extern void _ZN10S2423C4_nt3v30Ev();
extern void _ZN10S2423C4_nt3v31Ev();
extern void _ZN10S2423C4_nt3v32Ev();
extern void _ZN7S2423C33v33Ev();
extern void _ZN7S2423C33v34Ev();
extern void _ZN7S2423C33v35Ev();
extern void _ZN7S2423C33v36Ev();
extern void _ZN7S2423C33v37Ev();
extern void _ZN7S2423C33v38Ev();
extern void _ZN7S2423C33v39Ev();
extern void _ZN7S2423C33v40Ev();
extern void _ZN7S2423C33v41Ev();
extern void _ZN7S2423C33v42Ev();
extern void _ZN7S2423C33v43Ev();
extern void _ZN7S2423C33v44Ev();
extern void _ZN7S2423C33v45Ev();
extern void _ZN7S2423C33v46Ev();
static  VTBL_ENTRY vtc_S2423C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2423C3[0]),
  (VTBL_ENTRY)&_ZN7S2423C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2423C3D0Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v33Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v34Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v35Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v36Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v37Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v38Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v39Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v40Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v41Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v42Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v43Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v44Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v45Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v46Ev,
};
extern VTBL_ENTRY _ZTI7S2423C3[];
extern  VTBL_ENTRY _ZTV7S2423C3[];
Class_Descriptor cd_S2423C3 = {  "S2423C3", // class name
  bases_S2423C3, 1,
  &(vtc_S2423C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,48), // object size
  NSPAIRA(_ZTI7S2423C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2423C3),44, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2423C6  {
  void *s2423c6f0;
  char s2423c6f1[32];
  int s2423c6f2[6];
  char s2423c6f3;
  int s2423c6f4[2];
  virtual  ~S2423C6(); // _ZN7S2423C6D1Ev
  virtual void  v47(); // _ZN7S2423C63v47Ev
  virtual void  v48(); // _ZN7S2423C63v48Ev
  S2423C6(); // tgen
};
//SIG(-1 S2423C6) C1{ vd v1 v2 Fp Fc[32] Fi[6] Fc Fi[2]}


 S2423C6 ::~S2423C6(){ note_dtor("S2423C6", this);}
void  S2423C6 ::v47(){vfunc_called(this, "_ZN7S2423C63v47Ev");}
void  S2423C6 ::v48(){vfunc_called(this, "_ZN7S2423C63v48Ev");}
S2423C6 ::S2423C6(){ note_ctor("S2423C6", this);} // tgen

static void Test_S2423C6()
{
  extern Class_Descriptor cd_S2423C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(12,20)];
    init_test(&cd_S2423C6, buf);
    S2423C6 *dp, &lv = *(dp=new (buf) S2423C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(88,76), "sizeof(S2423C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2423C6)");
    check_field_offset(lv, s2423c6f0, ABISELECT(8,4), "S2423C6.s2423c6f0");
    check_field_offset(lv, s2423c6f1, ABISELECT(16,8), "S2423C6.s2423c6f1");
    check_field_offset(lv, s2423c6f2, ABISELECT(48,40), "S2423C6.s2423c6f2");
    check_field_offset(lv, s2423c6f3, ABISELECT(72,64), "S2423C6.s2423c6f3");
    check_field_offset(lv, s2423c6f4, ABISELECT(76,68), "S2423C6.s2423c6f4");
    test_class_info(&lv, &cd_S2423C6);
    dp->~S2423C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2423C6(Test_S2423C6, "S2423C6", ABISELECT(88,76));

#else // __cplusplus

extern void _ZN7S2423C6C1Ev();
extern void _ZN7S2423C6D1Ev();
Name_Map name_map_S2423C6[] = {
  NSPAIR(_ZN7S2423C6C1Ev),
  NSPAIR(_ZN7S2423C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2423C6[];
extern void _ZN7S2423C6D1Ev();
extern void _ZN7S2423C6D0Ev();
extern void _ZN7S2423C63v47Ev();
extern void _ZN7S2423C63v48Ev();
static  VTBL_ENTRY vtc_S2423C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2423C6[0]),
  (VTBL_ENTRY)&_ZN7S2423C6D1Ev,
  (VTBL_ENTRY)&_ZN7S2423C6D0Ev,
  (VTBL_ENTRY)&_ZN7S2423C63v47Ev,
  (VTBL_ENTRY)&_ZN7S2423C63v48Ev,
};
extern VTBL_ENTRY _ZTI7S2423C6[];
extern  VTBL_ENTRY _ZTV7S2423C6[];
Class_Descriptor cd_S2423C6 = {  "S2423C6", // class name
  0,0,//no base classes
  &(vtc_S2423C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(88,76), // object size
  NSPAIRA(_ZTI7S2423C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2423C6),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2423C2  : S2423C3 , S2423C6 {
  void *s2423c2f0;
  long s2423c2f1[2];
  __tsi64 s2423c2f2[2];
  long s2423c2f3;
  char s2423c2f4;
  int s2423c2f5;
  __tsi64 s2423c2f6;
  int s2423c2f7;
  void *s2423c2f8[4];
  long s2423c2f9[2];
  void *s2423c2f10;
  virtual  ~S2423C2(); // _ZN7S2423C2D1Ev
  virtual void  v49(); // _ZN7S2423C23v49Ev
  virtual void  v50(); // _ZN7S2423C23v50Ev
  virtual void  v51(); // _ZN7S2423C23v51Ev
  virtual void  v52(); // _ZN7S2423C23v52Ev
  virtual void  v53(); // _ZN7S2423C23v53Ev
  virtual void  v54(); // _ZN7S2423C23v54Ev
  virtual void  v55(); // _ZN7S2423C23v55Ev
  virtual void  v56(); // _ZN7S2423C23v56Ev
  virtual void  v57(); // _ZN7S2423C23v57Ev
  virtual void  v58(); // _ZN7S2423C23v58Ev
  virtual void  v59(); // _ZN7S2423C23v59Ev
  virtual void  v60(); // _ZN7S2423C23v60Ev
  virtual void  v61(); // _ZN7S2423C23v61Ev
  virtual void  v62(); // _ZN7S2423C23v62Ev
  virtual void  v63(); // _ZN7S2423C23v63Ev
  virtual void  v64(); // _ZN7S2423C23v64Ev
  virtual void  v65(); // _ZN7S2423C23v65Ev
  virtual void  v66(); // _ZN7S2423C23v66Ev
  virtual void  v67(); // _ZN7S2423C23v67Ev
  S2423C2(); // tgen
};
//SIG(-1 S2423C2) C1{ BC2{ BC3{ vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45} vd v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 Fp[2] Fi[4] FC4{ Fi[2]} Fp Fc Fp} BC5{ vd v60 v61 Fp Fc[32] Fi[6] Fc Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 Fp Fl[2] FL[2] Fl Fc Fi FL Fi Fp[4] Fl[2] Fp}


 S2423C2 ::~S2423C2(){ note_dtor("S2423C2", this);}
void  S2423C2 ::v49(){vfunc_called(this, "_ZN7S2423C23v49Ev");}
void  S2423C2 ::v50(){vfunc_called(this, "_ZN7S2423C23v50Ev");}
void  S2423C2 ::v51(){vfunc_called(this, "_ZN7S2423C23v51Ev");}
void  S2423C2 ::v52(){vfunc_called(this, "_ZN7S2423C23v52Ev");}
void  S2423C2 ::v53(){vfunc_called(this, "_ZN7S2423C23v53Ev");}
void  S2423C2 ::v54(){vfunc_called(this, "_ZN7S2423C23v54Ev");}
void  S2423C2 ::v55(){vfunc_called(this, "_ZN7S2423C23v55Ev");}
void  S2423C2 ::v56(){vfunc_called(this, "_ZN7S2423C23v56Ev");}
void  S2423C2 ::v57(){vfunc_called(this, "_ZN7S2423C23v57Ev");}
void  S2423C2 ::v58(){vfunc_called(this, "_ZN7S2423C23v58Ev");}
void  S2423C2 ::v59(){vfunc_called(this, "_ZN7S2423C23v59Ev");}
void  S2423C2 ::v60(){vfunc_called(this, "_ZN7S2423C23v60Ev");}
void  S2423C2 ::v61(){vfunc_called(this, "_ZN7S2423C23v61Ev");}
void  S2423C2 ::v62(){vfunc_called(this, "_ZN7S2423C23v62Ev");}
void  S2423C2 ::v63(){vfunc_called(this, "_ZN7S2423C23v63Ev");}
void  S2423C2 ::v64(){vfunc_called(this, "_ZN7S2423C23v64Ev");}
void  S2423C2 ::v65(){vfunc_called(this, "_ZN7S2423C23v65Ev");}
void  S2423C2 ::v66(){vfunc_called(this, "_ZN7S2423C23v66Ev");}
void  S2423C2 ::v67(){vfunc_called(this, "_ZN7S2423C23v67Ev");}
S2423C2 ::S2423C2(){ note_ctor("S2423C2", this);} // tgen

static void Test_S2423C2()
{
  extern Class_Descriptor cd_S2423C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(37,52)];
    init_test(&cd_S2423C2, buf);
    S2423C2 *dp, &lv = *(dp=new (buf) S2423C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(288,204), "sizeof(S2423C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2423C2)");
    check_base_class_offset(lv, (S2423C4_nt*)(S2423C3*), 0, "S2423C2");
    check_base_class_offset(lv, (S2423C3*), 0, "S2423C2");
    check_base_class_offset(lv, (S2423C6*), ABISELECT(72,48), "S2423C2");
    check_field_offset(lv, s2423c2f0, ABISELECT(160,124), "S2423C2.s2423c2f0");
    check_field_offset(lv, s2423c2f1, ABISELECT(168,128), "S2423C2.s2423c2f1");
    check_field_offset(lv, s2423c2f2, ABISELECT(184,136), "S2423C2.s2423c2f2");
    check_field_offset(lv, s2423c2f3, ABISELECT(200,152), "S2423C2.s2423c2f3");
    check_field_offset(lv, s2423c2f4, ABISELECT(208,156), "S2423C2.s2423c2f4");
    check_field_offset(lv, s2423c2f5, ABISELECT(212,160), "S2423C2.s2423c2f5");
    check_field_offset(lv, s2423c2f6, ABISELECT(216,164), "S2423C2.s2423c2f6");
    check_field_offset(lv, s2423c2f7, ABISELECT(224,172), "S2423C2.s2423c2f7");
    check_field_offset(lv, s2423c2f8, ABISELECT(232,176), "S2423C2.s2423c2f8");
    check_field_offset(lv, s2423c2f9, ABISELECT(264,192), "S2423C2.s2423c2f9");
    check_field_offset(lv, s2423c2f10, ABISELECT(280,200), "S2423C2.s2423c2f10");
    test_class_info(&lv, &cd_S2423C2);
    dp->~S2423C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2423C2(Test_S2423C2, "S2423C2", ABISELECT(288,204));

#else // __cplusplus

extern void _ZN7S2423C2C1Ev();
extern void _ZN7S2423C2D1Ev();
Name_Map name_map_S2423C2[] = {
  NSPAIR(_ZN7S2423C2C1Ev),
  NSPAIR(_ZN7S2423C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2423C4_nt;
extern VTBL_ENTRY _ZTI10S2423C4_nt[];
extern  VTBL_ENTRY _ZTV10S2423C4_nt[];
extern Class_Descriptor cd_S2423C3;
extern VTBL_ENTRY _ZTI7S2423C3[];
extern  VTBL_ENTRY _ZTV7S2423C3[];
extern Class_Descriptor cd_S2423C6;
extern VTBL_ENTRY _ZTI7S2423C6[];
extern  VTBL_ENTRY _ZTV7S2423C6[];
static Base_Class bases_S2423C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2423C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2423C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2423C6,    ABISELECT(72,48), //bcp->offset
    63, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2423C2[];
extern void _ZN7S2423C2D1Ev();
extern void _ZN7S2423C2D0Ev();
extern void _ZN10S2423C4_nt2v7Ev();
extern void _ZN10S2423C4_nt2v8Ev();
extern void _ZN10S2423C4_nt2v9Ev();
extern void _ZN10S2423C4_nt3v10Ev();
extern void _ZN10S2423C4_nt3v11Ev();
extern void _ZN10S2423C4_nt3v12Ev();
extern void _ZN10S2423C4_nt3v13Ev();
extern void _ZN10S2423C4_nt3v14Ev();
extern void _ZN10S2423C4_nt3v15Ev();
extern void _ZN10S2423C4_nt3v16Ev();
extern void _ZN10S2423C4_nt3v17Ev();
extern void _ZN10S2423C4_nt3v18Ev();
extern void _ZN10S2423C4_nt3v19Ev();
extern void _ZN10S2423C4_nt3v20Ev();
extern void _ZN10S2423C4_nt3v21Ev();
extern void _ZN10S2423C4_nt3v22Ev();
extern void _ZN10S2423C4_nt3v23Ev();
extern void _ZN10S2423C4_nt3v24Ev();
extern void _ZN10S2423C4_nt3v25Ev();
extern void _ZN10S2423C4_nt3v26Ev();
extern void _ZN10S2423C4_nt3v27Ev();
extern void _ZN10S2423C4_nt3v28Ev();
extern void _ZN10S2423C4_nt3v29Ev();
extern void _ZN10S2423C4_nt3v30Ev();
extern void _ZN10S2423C4_nt3v31Ev();
extern void _ZN10S2423C4_nt3v32Ev();
extern void _ZN7S2423C33v33Ev();
extern void _ZN7S2423C33v34Ev();
extern void _ZN7S2423C33v35Ev();
extern void _ZN7S2423C33v36Ev();
extern void _ZN7S2423C33v37Ev();
extern void _ZN7S2423C33v38Ev();
extern void _ZN7S2423C33v39Ev();
extern void _ZN7S2423C33v40Ev();
extern void _ZN7S2423C33v41Ev();
extern void _ZN7S2423C33v42Ev();
extern void _ZN7S2423C33v43Ev();
extern void _ZN7S2423C33v44Ev();
extern void _ZN7S2423C33v45Ev();
extern void _ZN7S2423C33v46Ev();
extern void _ZN7S2423C23v49Ev();
extern void _ZN7S2423C23v50Ev();
extern void _ZN7S2423C23v51Ev();
extern void _ZN7S2423C23v52Ev();
extern void _ZN7S2423C23v53Ev();
extern void _ZN7S2423C23v54Ev();
extern void _ZN7S2423C23v55Ev();
extern void _ZN7S2423C23v56Ev();
extern void _ZN7S2423C23v57Ev();
extern void _ZN7S2423C23v58Ev();
extern void _ZN7S2423C23v59Ev();
extern void _ZN7S2423C23v60Ev();
extern void _ZN7S2423C23v61Ev();
extern void _ZN7S2423C23v62Ev();
extern void _ZN7S2423C23v63Ev();
extern void _ZN7S2423C23v64Ev();
extern void _ZN7S2423C23v65Ev();
extern void _ZN7S2423C23v66Ev();
extern void _ZN7S2423C23v67Ev();
extern void ABISELECT(_ZThn72_N7S2423C2D1Ev,_ZThn48_N7S2423C2D1Ev)();
extern void ABISELECT(_ZThn72_N7S2423C2D0Ev,_ZThn48_N7S2423C2D0Ev)();
extern void _ZN7S2423C63v47Ev();
extern void _ZN7S2423C63v48Ev();
static  VTBL_ENTRY vtc_S2423C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2423C2[0]),
  (VTBL_ENTRY)&_ZN7S2423C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2423C2D0Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v33Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v34Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v35Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v36Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v37Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v38Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v39Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v40Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v41Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v42Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v43Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v44Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v45Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v46Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v49Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v50Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v51Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v52Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v53Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v54Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v55Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v56Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v57Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v58Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v59Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v60Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v61Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v62Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v63Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v64Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v65Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v66Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v67Ev,
  ABISELECT(-72,-48),
  (VTBL_ENTRY)&(_ZTI7S2423C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S2423C2D1Ev,_ZThn48_N7S2423C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S2423C2D0Ev,_ZThn48_N7S2423C2D0Ev),
  (VTBL_ENTRY)&_ZN7S2423C63v47Ev,
  (VTBL_ENTRY)&_ZN7S2423C63v48Ev,
};
extern VTBL_ENTRY _ZTI7S2423C2[];
extern  VTBL_ENTRY _ZTV7S2423C2[];
Class_Descriptor cd_S2423C2 = {  "S2423C2", // class name
  bases_S2423C2, 3,
  &(vtc_S2423C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(288,204), // object size
  NSPAIRA(_ZTI7S2423C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2423C2),69, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2423C8_nt  {
  void *s2423c8f0;
  int s2423c8f1;
};
//SIG(-1 S2423C8_nt) C1{ Fp Fi}



//skip512 S2423C8_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2423C7_nt  {
  int s2423c7f0;
  ::S2423C8_nt s2423c7f1;
};
//SIG(-1 S2423C7_nt) C1{ Fi FC2{ Fp Fi}}



//skip512 S2423C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2423C9_nt  {
  int s2423c9f0[3];
};
//SIG(-1 S2423C9_nt) C1{ Fi[3]}



//skip512 S2423C9_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2423C10  {
  ::S2423C5_nt s2423c10f0;
  ::S2423C5_nt s2423c10f1;
  ::S2423C8_nt s2423c10f2;
};
//SIG(-1 S2423C10) C1{ FC2{ Fi[2]} FC2 FC3{ Fp Fi}}



static void Test_S2423C10()
{
  {
    init_simple_test("S2423C10");
    S2423C10 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(S2423C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2423C10)");
    check_field_offset(lv, s2423c10f0, 0, "S2423C10.s2423c10f0");
    check_field_offset(lv, s2423c10f1, 8, "S2423C10.s2423c10f1");
    check_field_offset(lv, s2423c10f2, 16, "S2423C10.s2423c10f2");
  }
}
static Arrange_To_Call_Me vS2423C10(Test_S2423C10, "S2423C10", ABISELECT(32,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2423C15  {
  char s2423c15f0;
  char s2423c15f1;
  char s2423c15f2[14];
};
//SIG(1 S2423C15) C1{ Fc[16]}



static void Test_S2423C15()
{
  {
    init_simple_test("S2423C15");
    S2423C15 lv;
    check2(sizeof(lv), 16, "sizeof(S2423C15)");
    check2(__alignof__(lv), 1, "__alignof__(S2423C15)");
    check_field_offset(lv, s2423c15f0, 0, "S2423C15.s2423c15f0");
    check_field_offset(lv, s2423c15f1, 1, "S2423C15.s2423c15f1");
    check_field_offset(lv, s2423c15f2, 2, "S2423C15.s2423c15f2");
  }
}
static Arrange_To_Call_Me vS2423C15(Test_S2423C15, "S2423C15", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S2423C14  {
  char s2423c14f0[16];
  ::S2423C15 s2423c14f1;
};
//SIG(1 S2423C14) U1{ Fc[16] FC2{ Fc Fc Fc[14]}}

#endif // __cplusplus
#ifdef __cplusplus

struct  S2423C13  {
  int s2423c13f0[10];
  ::S2423C14 s2423c13f1;
  void *s2423c13f2[2];
};
//SIG(-1 S2423C13) C1{ Fi[10] FU2{ Fc[16] FC3{ Fc Fc Fc[14]}} Fp[2]}



static void Test_S2423C13()
{
  {
    init_simple_test("S2423C13");
    S2423C13 lv;
    check2(sizeof(lv), ABISELECT(72,64), "sizeof(S2423C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2423C13)");
    check_field_offset(lv, s2423c13f0, 0, "S2423C13.s2423c13f0");
    check_field_offset(lv, s2423c13f1, 40, "S2423C13.s2423c13f1");
    check_field_offset(lv, s2423c13f2, 56, "S2423C13.s2423c13f2");
  }
}
static Arrange_To_Call_Me vS2423C13(Test_S2423C13, "S2423C13", ABISELECT(72,64));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2423C16  {
  int s2423c16f0;
  char s2423c16f1;
  char s2423c16f2;
  short s2423c16f3;
  short s2423c16f4;
  char s2423c16f5;
  char s2423c16f6[2];
  char s2423c16f7;
  char s2423c16f8;
  char s2423c16f9;
  ::S2423C5_nt s2423c16f10;
};
//SIG(-1 S2423C16) C1{ Fi Fc[2] Fs[2] Fc[6] FC2{ Fi[2]}}



static void Test_S2423C16()
{
  {
    init_simple_test("S2423C16");
    S2423C16 lv;
    check2(sizeof(lv), 24, "sizeof(S2423C16)");
    check2(__alignof__(lv), 4, "__alignof__(S2423C16)");
    check_field_offset(lv, s2423c16f0, 0, "S2423C16.s2423c16f0");
    check_field_offset(lv, s2423c16f1, 4, "S2423C16.s2423c16f1");
    check_field_offset(lv, s2423c16f2, 5, "S2423C16.s2423c16f2");
    check_field_offset(lv, s2423c16f3, 6, "S2423C16.s2423c16f3");
    check_field_offset(lv, s2423c16f4, 8, "S2423C16.s2423c16f4");
    check_field_offset(lv, s2423c16f5, 10, "S2423C16.s2423c16f5");
    check_field_offset(lv, s2423c16f6, 11, "S2423C16.s2423c16f6");
    check_field_offset(lv, s2423c16f7, 13, "S2423C16.s2423c16f7");
    check_field_offset(lv, s2423c16f8, 14, "S2423C16.s2423c16f8");
    check_field_offset(lv, s2423c16f9, 15, "S2423C16.s2423c16f9");
    check_field_offset(lv, s2423c16f10, 16, "S2423C16.s2423c16f10");
  }
}
static Arrange_To_Call_Me vS2423C16(Test_S2423C16, "S2423C16", 24);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2423C12  {
  int s2423c12f0;
  ::S2423C13 s2423c12f1;
  ::S2423C16 s2423c12f2;
};
//SIG(-1 S2423C12) C1{ Fi FC2{ Fi[10] FU3{ Fc[16] FC4{ Fc Fc Fc[14]}} Fp[2]} FC5{ Fi Fc Fc Fs Fs Fc Fc[2] Fc Fc Fc FC6{ Fi[2]}}}



static void Test_S2423C12()
{
  {
    init_simple_test("S2423C12");
    S2423C12 lv;
    check2(sizeof(lv), ABISELECT(104,92), "sizeof(S2423C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2423C12)");
    check_field_offset(lv, s2423c12f0, 0, "S2423C12.s2423c12f0");
    check_field_offset(lv, s2423c12f1, ABISELECT(8,4), "S2423C12.s2423c12f1");
    check_field_offset(lv, s2423c12f2, ABISELECT(80,68), "S2423C12.s2423c12f2");
  }
}
static Arrange_To_Call_Me vS2423C12(Test_S2423C12, "S2423C12", ABISELECT(104,92));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2423C17_nt  {
  int s2423c17f0;
  int s2423c17f1;
  void *s2423c17f2;
};
//SIG(-1 S2423C17_nt) C1{ Fi[2] Fp}



//skip512 S2423C17_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2423C1  : S2423C2 {
  void *s2423c1f0;
  long s2423c1f1;
  char s2423c1f2;
  void *s2423c1f3;
  char s2423c1f4;
  void *s2423c1f5;
  int s2423c1f6[2];
  ::S2423C7_nt s2423c1f7;
  ::S2423C9_nt s2423c1f8;
  ::S2423C10 s2423c1f9;
  ::S2423C12 s2423c1f10;
  void *s2423c1f11;
  ::S2423C17_nt s2423c1f12;
  virtual  ~S2423C1(); // _ZN7S2423C1D1Ev
  virtual void  v1(); // _ZN7S2423C12v1Ev
  virtual void  v2(); // _ZN7S2423C12v2Ev
  virtual void  v3(); // _ZN7S2423C12v3Ev
  virtual void  v4(); // _ZN7S2423C12v4Ev
  virtual void  v5(); // _ZN7S2423C12v5Ev
  virtual void  v6(); // _ZN7S2423C12v6Ev
  S2423C1(); // tgen
};
//SIG(1 S2423C1) C1{ BC2{ BC3{ BC4{ vd v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32} vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 Fp[2] Fi[4] FC5{ Fi[2]} Fp Fc Fp} BC6{ vd v47 v48 Fp Fc[32] Fi[6] Fc Fi[2]} vd v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fp Fl[2] FL[2] Fl Fc Fi FL Fi Fp[4] Fl[2] Fp} vd v1 v2 v3 v4 v5 v6 Fp Fl Fc Fp Fc Fp Fi[2] FC7{ Fi FC8{ Fp Fi}} FC9{ Fi[3]} FC10{ FC5 FC5 FC8} FC11{ Fi FC12{ Fi[10] FU13{ Fc[16] FC14{ Fc Fc Fc[14]}} Fp[2]} FC15{ Fi Fc Fc Fs Fs Fc Fc[2] Fc Fc Fc FC5}} Fp FC16{ Fi Fi Fp}}


 S2423C1 ::~S2423C1(){ note_dtor("S2423C1", this);}
void  S2423C1 ::v1(){vfunc_called(this, "_ZN7S2423C12v1Ev");}
void  S2423C1 ::v2(){vfunc_called(this, "_ZN7S2423C12v2Ev");}
void  S2423C1 ::v3(){vfunc_called(this, "_ZN7S2423C12v3Ev");}
void  S2423C1 ::v4(){vfunc_called(this, "_ZN7S2423C12v4Ev");}
void  S2423C1 ::v5(){vfunc_called(this, "_ZN7S2423C12v5Ev");}
void  S2423C1 ::v6(){vfunc_called(this, "_ZN7S2423C12v6Ev");}
S2423C1 ::S2423C1(){ note_ctor("S2423C1", this);} // tgen

static void Test_S2423C1()
{
  extern Class_Descriptor cd_S2423C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(69,99)];
    init_test(&cd_S2423C1, buf);
    S2423C1 *dp, &lv = *(dp=new (buf) S2423C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(544,392), "sizeof(S2423C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2423C1)");
    check_base_class_offset(lv, (S2423C4_nt*)(S2423C3*)(S2423C2*), 0, "S2423C1");
    check_base_class_offset(lv, (S2423C3*)(S2423C2*), 0, "S2423C1");
    check_base_class_offset(lv, (S2423C6*)(S2423C2*), ABISELECT(72,48), "S2423C1");
    check_base_class_offset(lv, (S2423C2*), 0, "S2423C1");
    check_field_offset(lv, s2423c1f0, ABISELECT(288,204), "S2423C1.s2423c1f0");
    check_field_offset(lv, s2423c1f1, ABISELECT(296,208), "S2423C1.s2423c1f1");
    check_field_offset(lv, s2423c1f2, ABISELECT(304,212), "S2423C1.s2423c1f2");
    check_field_offset(lv, s2423c1f3, ABISELECT(312,216), "S2423C1.s2423c1f3");
    check_field_offset(lv, s2423c1f4, ABISELECT(320,220), "S2423C1.s2423c1f4");
    check_field_offset(lv, s2423c1f5, ABISELECT(328,224), "S2423C1.s2423c1f5");
    check_field_offset(lv, s2423c1f6, ABISELECT(336,228), "S2423C1.s2423c1f6");
    check_field_offset(lv, s2423c1f7, ABISELECT(344,236), "S2423C1.s2423c1f7");
    check_field_offset(lv, s2423c1f8, ABISELECT(368,248), "S2423C1.s2423c1f8");
    check_field_offset(lv, s2423c1f9, ABISELECT(384,260), "S2423C1.s2423c1f9");
    check_field_offset(lv, s2423c1f10, ABISELECT(416,284), "S2423C1.s2423c1f10");
    check_field_offset(lv, s2423c1f11, ABISELECT(520,376), "S2423C1.s2423c1f11");
    check_field_offset(lv, s2423c1f12, ABISELECT(528,380), "S2423C1.s2423c1f12");
    test_class_info(&lv, &cd_S2423C1);
    dp->~S2423C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2423C1(Test_S2423C1, "S2423C1", ABISELECT(544,392));

#else // __cplusplus

extern void _ZN7S2423C1C1Ev();
extern void _ZN7S2423C1D1Ev();
Name_Map name_map_S2423C1[] = {
  NSPAIR(_ZN7S2423C1C1Ev),
  NSPAIR(_ZN7S2423C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2423C4_nt;
extern VTBL_ENTRY _ZTI10S2423C4_nt[];
extern  VTBL_ENTRY _ZTV10S2423C4_nt[];
extern Class_Descriptor cd_S2423C3;
extern VTBL_ENTRY _ZTI7S2423C3[];
extern  VTBL_ENTRY _ZTV7S2423C3[];
extern Class_Descriptor cd_S2423C6;
extern VTBL_ENTRY _ZTI7S2423C6[];
extern  VTBL_ENTRY _ZTV7S2423C6[];
extern Class_Descriptor cd_S2423C2;
extern VTBL_ENTRY _ZTI7S2423C2[];
extern  VTBL_ENTRY _ZTV7S2423C2[];
static Base_Class bases_S2423C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2423C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2423C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2423C6,    ABISELECT(72,48), //bcp->offset
    69, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2423C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2423C1[];
extern void _ZN7S2423C1D1Ev();
extern void _ZN7S2423C1D0Ev();
extern void _ZN10S2423C4_nt2v7Ev();
extern void _ZN10S2423C4_nt2v8Ev();
extern void _ZN10S2423C4_nt2v9Ev();
extern void _ZN10S2423C4_nt3v10Ev();
extern void _ZN10S2423C4_nt3v11Ev();
extern void _ZN10S2423C4_nt3v12Ev();
extern void _ZN10S2423C4_nt3v13Ev();
extern void _ZN10S2423C4_nt3v14Ev();
extern void _ZN10S2423C4_nt3v15Ev();
extern void _ZN10S2423C4_nt3v16Ev();
extern void _ZN10S2423C4_nt3v17Ev();
extern void _ZN10S2423C4_nt3v18Ev();
extern void _ZN10S2423C4_nt3v19Ev();
extern void _ZN10S2423C4_nt3v20Ev();
extern void _ZN10S2423C4_nt3v21Ev();
extern void _ZN10S2423C4_nt3v22Ev();
extern void _ZN10S2423C4_nt3v23Ev();
extern void _ZN10S2423C4_nt3v24Ev();
extern void _ZN10S2423C4_nt3v25Ev();
extern void _ZN10S2423C4_nt3v26Ev();
extern void _ZN10S2423C4_nt3v27Ev();
extern void _ZN10S2423C4_nt3v28Ev();
extern void _ZN10S2423C4_nt3v29Ev();
extern void _ZN10S2423C4_nt3v30Ev();
extern void _ZN10S2423C4_nt3v31Ev();
extern void _ZN10S2423C4_nt3v32Ev();
extern void _ZN7S2423C33v33Ev();
extern void _ZN7S2423C33v34Ev();
extern void _ZN7S2423C33v35Ev();
extern void _ZN7S2423C33v36Ev();
extern void _ZN7S2423C33v37Ev();
extern void _ZN7S2423C33v38Ev();
extern void _ZN7S2423C33v39Ev();
extern void _ZN7S2423C33v40Ev();
extern void _ZN7S2423C33v41Ev();
extern void _ZN7S2423C33v42Ev();
extern void _ZN7S2423C33v43Ev();
extern void _ZN7S2423C33v44Ev();
extern void _ZN7S2423C33v45Ev();
extern void _ZN7S2423C33v46Ev();
extern void _ZN7S2423C23v49Ev();
extern void _ZN7S2423C23v50Ev();
extern void _ZN7S2423C23v51Ev();
extern void _ZN7S2423C23v52Ev();
extern void _ZN7S2423C23v53Ev();
extern void _ZN7S2423C23v54Ev();
extern void _ZN7S2423C23v55Ev();
extern void _ZN7S2423C23v56Ev();
extern void _ZN7S2423C23v57Ev();
extern void _ZN7S2423C23v58Ev();
extern void _ZN7S2423C23v59Ev();
extern void _ZN7S2423C23v60Ev();
extern void _ZN7S2423C23v61Ev();
extern void _ZN7S2423C23v62Ev();
extern void _ZN7S2423C23v63Ev();
extern void _ZN7S2423C23v64Ev();
extern void _ZN7S2423C23v65Ev();
extern void _ZN7S2423C23v66Ev();
extern void _ZN7S2423C23v67Ev();
extern void _ZN7S2423C12v1Ev();
extern void _ZN7S2423C12v2Ev();
extern void _ZN7S2423C12v3Ev();
extern void _ZN7S2423C12v4Ev();
extern void _ZN7S2423C12v5Ev();
extern void _ZN7S2423C12v6Ev();
extern void ABISELECT(_ZThn72_N7S2423C1D1Ev,_ZThn48_N7S2423C1D1Ev)();
extern void ABISELECT(_ZThn72_N7S2423C1D0Ev,_ZThn48_N7S2423C1D0Ev)();
extern void _ZN7S2423C63v47Ev();
extern void _ZN7S2423C63v48Ev();
static  VTBL_ENTRY vtc_S2423C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2423C1[0]),
  (VTBL_ENTRY)&_ZN7S2423C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2423C1D0Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2423C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v33Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v34Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v35Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v36Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v37Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v38Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v39Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v40Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v41Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v42Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v43Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v44Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v45Ev,
  (VTBL_ENTRY)&_ZN7S2423C33v46Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v49Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v50Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v51Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v52Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v53Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v54Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v55Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v56Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v57Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v58Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v59Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v60Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v61Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v62Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v63Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v64Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v65Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v66Ev,
  (VTBL_ENTRY)&_ZN7S2423C23v67Ev,
  (VTBL_ENTRY)&_ZN7S2423C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2423C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2423C12v3Ev,
  (VTBL_ENTRY)&_ZN7S2423C12v4Ev,
  (VTBL_ENTRY)&_ZN7S2423C12v5Ev,
  (VTBL_ENTRY)&_ZN7S2423C12v6Ev,
  ABISELECT(-72,-48),
  (VTBL_ENTRY)&(_ZTI7S2423C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S2423C1D1Ev,_ZThn48_N7S2423C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S2423C1D0Ev,_ZThn48_N7S2423C1D0Ev),
  (VTBL_ENTRY)&_ZN7S2423C63v47Ev,
  (VTBL_ENTRY)&_ZN7S2423C63v48Ev,
};
extern VTBL_ENTRY _ZTI7S2423C1[];
extern  VTBL_ENTRY _ZTV7S2423C1[];
Class_Descriptor cd_S2423C1 = {  "S2423C1", // class name
  bases_S2423C1, 4,
  &(vtc_S2423C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(544,392), // object size
  NSPAIRA(_ZTI7S2423C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2423C1),75, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7682C3  {
  short s7682c3f0:13;
  void *s7682c3f1;
  long double s7682c3f2[8];
  virtual void  v8(); // _ZN7S7682C32v8Ev
  virtual void  v9(); // _ZN7S7682C32v9Ev
  virtual void  v10(); // _ZN7S7682C33v10Ev
  virtual void  v11(); // _ZN7S7682C33v11Ev
  ~S7682C3(); // tgen
  S7682C3(); // tgen
};
//SIG(-1 S7682C3) C1{ v1 v2 v3 v4 Fs:13 Fp FD[8]}


void  S7682C3 ::v8(){vfunc_called(this, "_ZN7S7682C32v8Ev");}
void  S7682C3 ::v9(){vfunc_called(this, "_ZN7S7682C32v9Ev");}
void  S7682C3 ::v10(){vfunc_called(this, "_ZN7S7682C33v10Ev");}
void  S7682C3 ::v11(){vfunc_called(this, "_ZN7S7682C33v11Ev");}
S7682C3 ::~S7682C3(){ note_dtor("S7682C3", this);} // tgen
S7682C3 ::S7682C3(){ note_ctor("S7682C3", this);} // tgen

static void Test_S7682C3()
{
  extern Class_Descriptor cd_S7682C3;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(11,28)];
    init_test(&cd_S7682C3, buf);
    S7682C3 *dp, &lv = *(dp=new (buf) S7682C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(160,108), "sizeof(S7682C3)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7682C3)");
    set_bf_and_test(lv, s7682c3f0, ABISELECT(8,4), 0, 13, 1, "S7682C3");
    set_bf_and_test(lv, s7682c3f0, ABISELECT(8,4), 0, 13, hide_sll(1LL<<12), "S7682C3");
    check_field_offset(lv, s7682c3f1, ABISELECT(16,8), "S7682C3.s7682c3f1");
    check_field_offset(lv, s7682c3f2, ABISELECT(32,12), "S7682C3.s7682c3f2");
    test_class_info(&lv, &cd_S7682C3);
    dp->~S7682C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7682C3(Test_S7682C3, "S7682C3", ABISELECT(160,108));

#else // __cplusplus

extern void _ZN7S7682C3C1Ev();
extern void _ZN7S7682C3D1Ev();
Name_Map name_map_S7682C3[] = {
  NSPAIR(_ZN7S7682C3C1Ev),
  NSPAIR(_ZN7S7682C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S7682C3[];
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY vtc_S7682C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S7682C3[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
Class_Descriptor cd_S7682C3 = {  "S7682C3", // class name
  0,0,//no base classes
  &(vtc_S7682C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(160,108), // object size
  NSPAIRA(_ZTI7S7682C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S7682C3),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7682C4  : S7682C3 {
  void *s7682c4f0[6];
  virtual void  v12(); // _ZN7S7682C43v12Ev
  virtual void  v13(); // _ZN7S7682C43v13Ev
  virtual void  v14(); // _ZN7S7682C43v14Ev
  ~S7682C4(); // tgen
  S7682C4(); // tgen
};
//SIG(-1 S7682C4) C1{ BC2{ v4 v5 v6 v7 Fs:13 Fp FD[8]} v1 v2 v3 Fp[6]}


void  S7682C4 ::v12(){vfunc_called(this, "_ZN7S7682C43v12Ev");}
void  S7682C4 ::v13(){vfunc_called(this, "_ZN7S7682C43v13Ev");}
void  S7682C4 ::v14(){vfunc_called(this, "_ZN7S7682C43v14Ev");}
S7682C4 ::~S7682C4(){ note_dtor("S7682C4", this);} // tgen
S7682C4 ::S7682C4(){ note_ctor("S7682C4", this);} // tgen

static void Test_S7682C4()
{
  extern Class_Descriptor cd_S7682C4;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(14,34)];
    init_test(&cd_S7682C4, buf);
    S7682C4 *dp, &lv = *(dp=new (buf) S7682C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,132), "sizeof(S7682C4)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7682C4)");
    check_base_class_offset(lv, (S7682C3*), 0, "S7682C4");
    check_field_offset(lv, s7682c4f0, ABISELECT(160,108), "S7682C4.s7682c4f0");
    test_class_info(&lv, &cd_S7682C4);
    dp->~S7682C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7682C4(Test_S7682C4, "S7682C4", ABISELECT(208,132));

#else // __cplusplus

extern void _ZN7S7682C4C1Ev();
extern void _ZN7S7682C4D1Ev();
Name_Map name_map_S7682C4[] = {
  NSPAIR(_ZN7S7682C4C1Ev),
  NSPAIR(_ZN7S7682C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
static Base_Class bases_S7682C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7682C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S7682C4[];
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
static  VTBL_ENTRY vtc_S7682C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S7682C4[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
};
extern VTBL_ENTRY _ZTI7S7682C4[];
extern  VTBL_ENTRY _ZTV7S7682C4[];
Class_Descriptor cd_S7682C4 = {  "S7682C4", // class name
  bases_S7682C4, 1,
  &(vtc_S7682C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(208,132), // object size
  NSPAIRA(_ZTI7S7682C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S7682C4),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7682C2  : virtual S7682C3 , S7682C4 {
  void *s7682c2f0;
  virtual void  v15(); // _ZN7S7682C23v15Ev
  virtual void  v16(); // _ZN7S7682C23v16Ev
  virtual void  v17(); // _ZN7S7682C23v17Ev
  virtual void  v18(); // _ZN7S7682C23v18Ev
  ~S7682C2(); // tgen
  S7682C2(); // tgen
};
//SIG(-1 S7682C2) C1{ VBC2{ v5 v6 v7 v8 Fs:13 Fp FD[8]} BC3{ BC2 v9 v10 v11 Fp[6]} v1 v2 v3 v4 Fp}


void  S7682C2 ::v15(){vfunc_called(this, "_ZN7S7682C23v15Ev");}
void  S7682C2 ::v16(){vfunc_called(this, "_ZN7S7682C23v16Ev");}
void  S7682C2 ::v17(){vfunc_called(this, "_ZN7S7682C23v17Ev");}
void  S7682C2 ::v18(){vfunc_called(this, "_ZN7S7682C23v18Ev");}
S7682C2 ::~S7682C2(){ note_dtor("S7682C2", this);} // tgen
S7682C2 ::S7682C2(){ note_ctor("S7682C2", this);} // tgen

static void Test_S7682C2()
{
  extern Class_Descriptor cd_S7682C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(25,62)];
    init_test(&cd_S7682C2, buf);
    S7682C2 *dp, &lv = *(dp=new (buf) S7682C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(384,244), "sizeof(S7682C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7682C2)");
    /*is_ambiguous_... S7682C2::S7682C3 */ AMB_check_base_class_offset(lv, (S7682C3*), ABISELECT(224,136), "S7682C2");
    check_base_class_offset(lv, (S7682C3*)(S7682C4*), 0, "S7682C2");
    check_base_class_offset(lv, (S7682C4*), 0, "S7682C2");
    check_field_offset(lv, s7682c2f0, ABISELECT(208,132), "S7682C2.s7682c2f0");
    test_class_info(&lv, &cd_S7682C2);
    dp->~S7682C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7682C2(Test_S7682C2, "S7682C2", ABISELECT(384,244));

#else // __cplusplus

extern void _ZN7S7682C2C1Ev();
extern void _ZN7S7682C2D1Ev();
Name_Map name_map_S7682C2[] = {
  NSPAIR(_ZN7S7682C2C1Ev),
  NSPAIR(_ZN7S7682C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C4;
extern VTBL_ENTRY _ZTI7S7682C4[];
extern  VTBL_ENTRY _ZTV7S7682C4[];
static Base_Class bases_S7682C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7682C3,    ABISELECT(224,136), //bcp->offset
    14, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7682C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S7682C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S7682C2[];
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY vtc_S7682C2[] = {
  ABISELECT(224,136),
  0,
  (VTBL_ENTRY)&(_ZTI7S7682C2[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-224,-136),
  (VTBL_ENTRY)&(_ZTI7S7682C2[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern VTBL_ENTRY _ZTV7S7682C2[];
static  VTT_ENTRY vtt_S7682C2[] = {
  {&(_ZTV7S7682C2[3]),  3,24},
  {&(_ZTV7S7682C2[20]),  20,24},
};
extern VTBL_ENTRY _ZTI7S7682C2[];
extern  VTBL_ENTRY _ZTV7S7682C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7682C2[];
Class_Descriptor cd_S7682C2 = {  "S7682C2", // class name
  bases_S7682C2, 3,
  &(vtc_S7682C2[0]), // expected_vtbl_contents
  &(vtt_S7682C2[0]), // expected_vtt_contents
  ABISELECT(384,244), // object size
  NSPAIRA(_ZTI7S7682C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S7682C2),24, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7682C2),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7682C6  : virtual S7682C2 {
  virtual  ~S7682C6(); // _ZN7S7682C6D2Ev
  virtual void  v19(); // _ZN7S7682C63v19Ev
  virtual void  v20(); // _ZN7S7682C63v20Ev
  virtual void  v21(); // _ZN7S7682C63v21Ev
  virtual void  v22(); // _ZN7S7682C63v22Ev
  S7682C6(); // tgen
};
//SIG(-1 S7682C6) C1{ VBC2{ VBC3{ v5 v6 v7 v8 Fs:13 Fp FD[8]} BC4{ BC3 v9 v10 v11 Fp[6]} v12 v13 v14 v15 Fp} vd v1 v2 v3 v4}


 S7682C6 ::~S7682C6(){ note_dtor("S7682C6", this);}
void  S7682C6 ::v19(){vfunc_called(this, "_ZN7S7682C63v19Ev");}
void  S7682C6 ::v20(){vfunc_called(this, "_ZN7S7682C63v20Ev");}
void  S7682C6 ::v21(){vfunc_called(this, "_ZN7S7682C63v21Ev");}
void  S7682C6 ::v22(){vfunc_called(this, "_ZN7S7682C63v22Ev");}
S7682C6 ::S7682C6(){ note_ctor("S7682C6", this);} // tgen

static void Test_S7682C6()
{
  extern Class_Descriptor cd_S7682C6;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(26,63)];
    init_test(&cd_S7682C6, buf);
    S7682C6 *dp, &lv = *(dp=new (buf) S7682C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(400,248), "sizeof(S7682C6)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7682C6)");
    /*is_ambiguous_... S7682C2::S7682C3 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C2*), ABISELECT(240,140), "S7682C6");
    check_base_class_offset(lv, (S7682C3*)(S7682C4*)(S7682C2*), ABISELECT(16,4), "S7682C6");
    check_base_class_offset(lv, (S7682C4*)(S7682C2*), ABISELECT(16,4), "S7682C6");
    check_base_class_offset(lv, (S7682C2*), ABISELECT(16,4), "S7682C6");
    test_class_info(&lv, &cd_S7682C6);
    dp->~S7682C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7682C6(Test_S7682C6, "S7682C6", ABISELECT(400,248));

#else // __cplusplus

extern void _ZN7S7682C6C1Ev();
extern void _ZN7S7682C6D2Ev();
Name_Map name_map_S7682C6[] = {
  NSPAIR(_ZN7S7682C6C1Ev),
  NSPAIR(_ZN7S7682C6D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C4;
extern VTBL_ENTRY _ZTI7S7682C4[];
extern  VTBL_ENTRY _ZTV7S7682C4[];
extern Class_Descriptor cd_S7682C2;
extern VTBL_ENTRY _ZTI7S7682C2[];
extern  VTBL_ENTRY _ZTV7S7682C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7682C2[];
static Base_Class bases_S7682C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7682C3,    ABISELECT(240,140), //bcp->offset
    35, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S7682C3,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S7682C4,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S7682C2,    ABISELECT(16,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    14, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S7682C6[];
extern void _ZN7S7682C6D1Ev();
extern void _ZN7S7682C6D0Ev();
extern void _ZN7S7682C63v19Ev();
extern void _ZN7S7682C63v20Ev();
extern void _ZN7S7682C63v21Ev();
extern void _ZN7S7682C63v22Ev();
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY vtc_S7682C6[] = {
  ABISELECT(240,140),
  ABISELECT(16,4),
  0,
  (VTBL_ENTRY)&(_ZTI7S7682C6[0]),
  (VTBL_ENTRY)&_ZN7S7682C6D1Ev,
  (VTBL_ENTRY)&_ZN7S7682C6D0Ev,
  (VTBL_ENTRY)&_ZN7S7682C63v19Ev,
  (VTBL_ENTRY)&_ZN7S7682C63v20Ev,
  (VTBL_ENTRY)&_ZN7S7682C63v21Ev,
  (VTBL_ENTRY)&_ZN7S7682C63v22Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(224,136),
  ABISELECT(-16,-4),
  (VTBL_ENTRY)&(_ZTI7S7682C6[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-240,-140),
  (VTBL_ENTRY)&(_ZTI7S7682C6[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern VTBL_ENTRY _ZTV7S7682C6[];
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C2__7S7682C6[] = {
  ABISELECT(224,136),
  0,
  (VTBL_ENTRY)&(_ZTI7S7682C2[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__7S7682C2__7S7682C6[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-224,-136),
  (VTBL_ENTRY)&(_ZTI7S7682C2[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
static  VTT_ENTRY vtt_S7682C6[] = {
  {&(_ZTV7S7682C6[4]),  4,45},
  {&(_ZTV7S7682C6[24]),  24,45},
  {&(_ZTV7S7682C6[41]),  41,45},
  {&(_tg__ZTV7S7682C2__7S7682C6[3]),  3,14},
  {&(_tg__ZTV7S7682C3__7S7682C2__7S7682C6[6]),  6,10},
};
extern VTBL_ENTRY _ZTI7S7682C6[];
extern  VTBL_ENTRY _ZTV7S7682C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7682C6[];
Class_Descriptor cd_S7682C6 = {  "S7682C6", // class name
  bases_S7682C6, 4,
  &(vtc_S7682C6[0]), // expected_vtbl_contents
  &(vtt_S7682C6[0]), // expected_vtt_contents
  ABISELECT(400,248), // object size
  NSPAIRA(_ZTI7S7682C6),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7S7682C6),45, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7682C6),5, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7682C5  : S7682C6 {
  long double s7682c5f0;
  virtual void  v23(); // _ZN7S7682C53v23Ev
  virtual void  v24(); // _ZN7S7682C53v24Ev
  virtual void  v25(); // _ZN7S7682C53v25Ev
  virtual void  v26(); // _ZN7S7682C53v26Ev
  virtual void  v27(); // _ZN7S7682C53v27Ev
  virtual void  v28(); // _ZN7S7682C53v28Ev
  ~S7682C5(); // tgen
  S7682C5(); // tgen
};
//SIG(-1 S7682C5) C1{ BC2{ VBC3{ VBC4{ v7 v8 v9 v10 Fs:13 Fp FD[8]} BC5{ BC4 v11 v12 v13 Fp[6]} v14 v15 v16 v17 Fp} vd v18 v19 v20 v21} v1 v2 v3 v4 v5 v6 FD}


void  S7682C5 ::v23(){vfunc_called(this, "_ZN7S7682C53v23Ev");}
void  S7682C5 ::v24(){vfunc_called(this, "_ZN7S7682C53v24Ev");}
void  S7682C5 ::v25(){vfunc_called(this, "_ZN7S7682C53v25Ev");}
void  S7682C5 ::v26(){vfunc_called(this, "_ZN7S7682C53v26Ev");}
void  S7682C5 ::v27(){vfunc_called(this, "_ZN7S7682C53v27Ev");}
void  S7682C5 ::v28(){vfunc_called(this, "_ZN7S7682C53v28Ev");}
S7682C5 ::~S7682C5(){ note_dtor("S7682C5", this);} // tgen
S7682C5 ::S7682C5(){ note_ctor("S7682C5", this);} // tgen

static void Test_S7682C5()
{
  extern Class_Descriptor cd_S7682C5;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(27,66)];
    init_test(&cd_S7682C5, buf);
    S7682C5 *dp, &lv = *(dp=new (buf) S7682C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(416,260), "sizeof(S7682C5)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7682C5)");
    /*is_ambiguous_... S7682C2::S7682C3 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C2*), ABISELECT(256,152), "S7682C5");
    check_base_class_offset(lv, (S7682C3*)(S7682C4*)(S7682C2*), ABISELECT(32,16), "S7682C5");
    check_base_class_offset(lv, (S7682C4*)(S7682C2*), ABISELECT(32,16), "S7682C5");
    check_base_class_offset(lv, (S7682C2*)(S7682C6*), ABISELECT(32,16), "S7682C5");
    check_base_class_offset(lv, (S7682C6*), 0, "S7682C5");
    check_field_offset(lv, s7682c5f0, ABISELECT(16,4), "S7682C5.s7682c5f0");
    test_class_info(&lv, &cd_S7682C5);
    dp->~S7682C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7682C5(Test_S7682C5, "S7682C5", ABISELECT(416,260));

#else // __cplusplus

extern void _ZN7S7682C5C1Ev();
extern void _ZN7S7682C5D1Ev();
Name_Map name_map_S7682C5[] = {
  NSPAIR(_ZN7S7682C5C1Ev),
  NSPAIR(_ZN7S7682C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C4;
extern VTBL_ENTRY _ZTI7S7682C4[];
extern  VTBL_ENTRY _ZTV7S7682C4[];
extern Class_Descriptor cd_S7682C2;
extern VTBL_ENTRY _ZTI7S7682C2[];
extern  VTBL_ENTRY _ZTV7S7682C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7682C2[];
extern Class_Descriptor cd_S7682C6;
extern VTBL_ENTRY _ZTI7S7682C6[];
extern  VTBL_ENTRY _ZTV7S7682C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7682C6[];
static Base_Class bases_S7682C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7682C3,    ABISELECT(256,152), //bcp->offset
    41, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S7682C3,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S7682C4,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S7682C2,    ABISELECT(32,16), //bcp->offset
    16, //bcp->virtual_function_table_offset
    14, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S7682C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S7682C5[];
extern void _ZN7S7682C5D1Ev();
extern void _ZN7S7682C5D0Ev();
extern void _ZN7S7682C63v19Ev();
extern void _ZN7S7682C63v20Ev();
extern void _ZN7S7682C63v21Ev();
extern void _ZN7S7682C63v22Ev();
extern void _ZN7S7682C53v23Ev();
extern void _ZN7S7682C53v24Ev();
extern void _ZN7S7682C53v25Ev();
extern void _ZN7S7682C53v26Ev();
extern void _ZN7S7682C53v27Ev();
extern void _ZN7S7682C53v28Ev();
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY vtc_S7682C5[] = {
  ABISELECT(256,152),
  ABISELECT(32,16),
  0,
  (VTBL_ENTRY)&(_ZTI7S7682C5[0]),
  (VTBL_ENTRY)&_ZN7S7682C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7682C5D0Ev,
  (VTBL_ENTRY)&_ZN7S7682C63v19Ev,
  (VTBL_ENTRY)&_ZN7S7682C63v20Ev,
  (VTBL_ENTRY)&_ZN7S7682C63v21Ev,
  (VTBL_ENTRY)&_ZN7S7682C63v22Ev,
  (VTBL_ENTRY)&_ZN7S7682C53v23Ev,
  (VTBL_ENTRY)&_ZN7S7682C53v24Ev,
  (VTBL_ENTRY)&_ZN7S7682C53v25Ev,
  (VTBL_ENTRY)&_ZN7S7682C53v26Ev,
  (VTBL_ENTRY)&_ZN7S7682C53v27Ev,
  (VTBL_ENTRY)&_ZN7S7682C53v28Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(224,136),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7S7682C5[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-256,-152),
  (VTBL_ENTRY)&(_ZTI7S7682C5[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern VTBL_ENTRY _ZTV7S7682C5[];
extern void _ZN7S7682C6D1Ev();
extern void _ZN7S7682C6D0Ev();
extern void _ZN7S7682C63v19Ev();
extern void _ZN7S7682C63v20Ev();
extern void _ZN7S7682C63v21Ev();
extern void _ZN7S7682C63v22Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C6__7S7682C5[] = {
  ABISELECT(256,152),
  ABISELECT(32,16),
  0,
  (VTBL_ENTRY)&(_ZTI7S7682C6[0]),
  (VTBL_ENTRY)&_ZN7S7682C6D1Ev,
  (VTBL_ENTRY)&_ZN7S7682C6D0Ev,
  (VTBL_ENTRY)&_ZN7S7682C63v19Ev,
  (VTBL_ENTRY)&_ZN7S7682C63v20Ev,
  (VTBL_ENTRY)&_ZN7S7682C63v21Ev,
  (VTBL_ENTRY)&_ZN7S7682C63v22Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C2__7S7682C6__7S7682C5[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(224,136),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7S7682C6[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__7S7682C6__7S7682C5[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-256,-152),
  (VTBL_ENTRY)&(_ZTI7S7682C6[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C2__7S7682C5[] = {
  ABISELECT(224,136),
  0,
  (VTBL_ENTRY)&(_ZTI7S7682C2[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__7S7682C2__7S7682C5[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-224,-136),
  (VTBL_ENTRY)&(_ZTI7S7682C2[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
static  VTT_ENTRY vtt_S7682C5[] = {
  {&(_ZTV7S7682C5[4]),  4,51},
  {&(_tg__ZTV7S7682C6__7S7682C5[4]),  4,10},
  {&(_tg__ZTV7S7682C2__7S7682C6__7S7682C5[14]),  14,25},
  {&(_tg__ZTV7S7682C3__7S7682C6__7S7682C5[6]),  6,10},
  {&(_ZTV7S7682C5[30]),  30,51},
  {&(_ZTV7S7682C5[47]),  47,51},
  {&(_tg__ZTV7S7682C2__7S7682C5[3]),  3,14},
  {&(_tg__ZTV7S7682C3__7S7682C2__7S7682C5[6]),  6,10},
};
extern VTBL_ENTRY _ZTI7S7682C5[];
extern  VTBL_ENTRY _ZTV7S7682C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7682C5[];
Class_Descriptor cd_S7682C5 = {  "S7682C5", // class name
  bases_S7682C5, 5,
  &(vtc_S7682C5[0]), // expected_vtbl_contents
  &(vtt_S7682C5[0]), // expected_vtt_contents
  ABISELECT(416,260), // object size
  NSPAIRA(_ZTI7S7682C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S7682C5),51, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7682C5),8, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7682C8_nt  {
  virtual void  v29(); // _ZN10S7682C8_nt3v29Ev
  virtual void  v30(); // _ZN10S7682C8_nt3v30Ev
  virtual void  v31(); // _ZN10S7682C8_nt3v31Ev
  virtual void  v32(); // _ZN10S7682C8_nt3v32Ev
  ~S7682C8_nt(); // tgen
  S7682C8_nt(); // tgen
};
//SIG(-1 S7682C8_nt) C1{ v1 v2 v3 v4}


void  S7682C8_nt ::v29(){vfunc_called(this, "_ZN10S7682C8_nt3v29Ev");}
void  S7682C8_nt ::v30(){vfunc_called(this, "_ZN10S7682C8_nt3v30Ev");}
void  S7682C8_nt ::v31(){vfunc_called(this, "_ZN10S7682C8_nt3v31Ev");}
void  S7682C8_nt ::v32(){vfunc_called(this, "_ZN10S7682C8_nt3v32Ev");}
S7682C8_nt ::~S7682C8_nt(){ note_dtor("S7682C8_nt", this);} // tgen
S7682C8_nt ::S7682C8_nt(){ note_ctor("S7682C8_nt", this);} // tgen

//skip512 S7682C8_nt

#else // __cplusplus

extern void _ZN10S7682C8_ntC1Ev();
extern void _ZN10S7682C8_ntD1Ev();
Name_Map name_map_S7682C8_nt[] = {
  NSPAIR(_ZN10S7682C8_ntC1Ev),
  NSPAIR(_ZN10S7682C8_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S7682C8_nt[];
extern void _ZN10S7682C8_nt3v29Ev();
extern void _ZN10S7682C8_nt3v30Ev();
extern void _ZN10S7682C8_nt3v31Ev();
extern void _ZN10S7682C8_nt3v32Ev();
static  VTBL_ENTRY vtc_S7682C8_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S7682C8_nt[0]),
  (VTBL_ENTRY)&_ZN10S7682C8_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S7682C8_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S7682C8_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S7682C8_nt3v32Ev,
};
extern VTBL_ENTRY _ZTI10S7682C8_nt[];
VTBL_ENTRY *P__ZTI10S7682C8_nt = _ZTI10S7682C8_nt; 
extern  VTBL_ENTRY _ZTV10S7682C8_nt[];
Class_Descriptor cd_S7682C8_nt = {  "S7682C8_nt", // class name
  0,0,//no base classes
  &(vtc_S7682C8_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S7682C8_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S7682C8_nt),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7682C9  {
  ::S7682C4 s7682c9f0[7];
  virtual void  v33(); // _ZN7S7682C93v33Ev
  virtual void  v34(); // _ZN7S7682C93v34Ev
  virtual void  v35(); // _ZN7S7682C93v35Ev
  virtual void  v36(); // _ZN7S7682C93v36Ev
  virtual void  v37(); // _ZN7S7682C93v37Ev
  virtual void  v38(); // _ZN7S7682C93v38Ev
  virtual void  v39(); // _ZN7S7682C93v39Ev
  virtual void  v40(); // _ZN7S7682C93v40Ev
  virtual void  v41(); // _ZN7S7682C93v41Ev
  ~S7682C9(); // tgen
  S7682C9(); // tgen
};
//SIG(-1 S7682C9) C1{ v1 v2 v3 v4 v5 v6 v7 v8 v9 FC2{ BC3{ v13 v14 v15 v16 Fs:13 Fp FD[8]} v10 v11 v12 Fp[6]}[7]}


void  S7682C9 ::v33(){vfunc_called(this, "_ZN7S7682C93v33Ev");}
void  S7682C9 ::v34(){vfunc_called(this, "_ZN7S7682C93v34Ev");}
void  S7682C9 ::v35(){vfunc_called(this, "_ZN7S7682C93v35Ev");}
void  S7682C9 ::v36(){vfunc_called(this, "_ZN7S7682C93v36Ev");}
void  S7682C9 ::v37(){vfunc_called(this, "_ZN7S7682C93v37Ev");}
void  S7682C9 ::v38(){vfunc_called(this, "_ZN7S7682C93v38Ev");}
void  S7682C9 ::v39(){vfunc_called(this, "_ZN7S7682C93v39Ev");}
void  S7682C9 ::v40(){vfunc_called(this, "_ZN7S7682C93v40Ev");}
void  S7682C9 ::v41(){vfunc_called(this, "_ZN7S7682C93v41Ev");}
S7682C9 ::~S7682C9(){ note_dtor("S7682C9", this);} // tgen
S7682C9 ::S7682C9(){ note_ctor("S7682C9", this);} // tgen

static void Test_S7682C9()
{
  extern Class_Descriptor cd_S7682C9;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(93,233)];
    init_test(&cd_S7682C9, buf);
    S7682C9 *dp, &lv = *(dp=new (buf) S7682C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1472,928), "sizeof(S7682C9)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7682C9)");
    check_field_offset(lv, s7682c9f0, ABISELECT(16,4), "S7682C9.s7682c9f0");
    test_class_info(&lv, &cd_S7682C9);
    dp->~S7682C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7682C9(Test_S7682C9, "S7682C9", ABISELECT(1472,928));

#else // __cplusplus

extern void _ZN7S7682C9C1Ev();
extern void _ZN7S7682C9D1Ev();
Name_Map name_map_S7682C9[] = {
  NSPAIR(_ZN7S7682C9C1Ev),
  NSPAIR(_ZN7S7682C9D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S7682C9[];
extern void _ZN7S7682C93v33Ev();
extern void _ZN7S7682C93v34Ev();
extern void _ZN7S7682C93v35Ev();
extern void _ZN7S7682C93v36Ev();
extern void _ZN7S7682C93v37Ev();
extern void _ZN7S7682C93v38Ev();
extern void _ZN7S7682C93v39Ev();
extern void _ZN7S7682C93v40Ev();
extern void _ZN7S7682C93v41Ev();
static  VTBL_ENTRY vtc_S7682C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S7682C9[0]),
  (VTBL_ENTRY)&_ZN7S7682C93v33Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v34Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v35Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v36Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v37Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v38Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v39Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v40Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v41Ev,
};
extern VTBL_ENTRY _ZTI7S7682C9[];
extern  VTBL_ENTRY _ZTV7S7682C9[];
Class_Descriptor cd_S7682C9 = {  "S7682C9", // class name
  0,0,//no base classes
  &(vtc_S7682C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1472,928), // object size
  NSPAIRA(_ZTI7S7682C9),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S7682C9),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7682C13  : virtual S7682C3 , virtual S7682C4 {
  void *s7682c13f0[2];
  virtual void  v42(); // _ZN8S7682C133v42Ev
  virtual void  v43(); // _ZN8S7682C133v43Ev
  virtual void  v44(); // _ZN8S7682C133v44Ev
  virtual void  v45(); // _ZN8S7682C133v45Ev
  virtual void  v46(); // _ZN8S7682C133v46Ev
  ~S7682C13(); // tgen
  S7682C13(); // tgen
};
//SIG(-1 S7682C13) C1{ VBC2{ v6 v7 v8 v9 Fs:13 Fp FD[8]} VBC3{ BC2 v10 v11 v12 Fp[6]} v1 v2 v3 v4 v5 Fp[2]}


void  S7682C13 ::v42(){vfunc_called(this, "_ZN8S7682C133v42Ev");}
void  S7682C13 ::v43(){vfunc_called(this, "_ZN8S7682C133v43Ev");}
void  S7682C13 ::v44(){vfunc_called(this, "_ZN8S7682C133v44Ev");}
void  S7682C13 ::v45(){vfunc_called(this, "_ZN8S7682C133v45Ev");}
void  S7682C13 ::v46(){vfunc_called(this, "_ZN8S7682C133v46Ev");}
S7682C13 ::~S7682C13(){ note_dtor("S7682C13", this);} // tgen
S7682C13 ::S7682C13(){ note_ctor("S7682C13", this);} // tgen

static void Test_S7682C13()
{
  extern Class_Descriptor cd_S7682C13;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(26,64)];
    init_test(&cd_S7682C13, buf);
    S7682C13 *dp, &lv = *(dp=new (buf) S7682C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(400,252), "sizeof(S7682C13)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7682C13)");
    /*is_ambiguous_... S7682C13::S7682C3 */ AMB_check_base_class_offset(lv, (S7682C3*), ABISELECT(32,12), "S7682C13");
    check_base_class_offset(lv, (S7682C3*)(S7682C4*), ABISELECT(192,120), "S7682C13");
    check_base_class_offset(lv, (S7682C4*), ABISELECT(192,120), "S7682C13");
    check_field_offset(lv, s7682c13f0, ABISELECT(8,4), "S7682C13.s7682c13f0");
    test_class_info(&lv, &cd_S7682C13);
    dp->~S7682C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7682C13(Test_S7682C13, "S7682C13", ABISELECT(400,252));

#else // __cplusplus

extern void _ZN8S7682C13C1Ev();
extern void _ZN8S7682C13D1Ev();
Name_Map name_map_S7682C13[] = {
  NSPAIR(_ZN8S7682C13C1Ev),
  NSPAIR(_ZN8S7682C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C4;
extern VTBL_ENTRY _ZTI7S7682C4[];
extern  VTBL_ENTRY _ZTV7S7682C4[];
static Base_Class bases_S7682C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7682C3,    ABISELECT(32,12), //bcp->offset
    9, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7682C3,    ABISELECT(192,120), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S7682C4,    ABISELECT(192,120), //bcp->offset
    19, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7682C13[];
extern void _ZN8S7682C133v42Ev();
extern void _ZN8S7682C133v43Ev();
extern void _ZN8S7682C133v44Ev();
extern void _ZN8S7682C133v45Ev();
extern void _ZN8S7682C133v46Ev();
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
static  VTBL_ENTRY vtc_S7682C13[] = {
  ABISELECT(192,120),
  ABISELECT(32,12),
  0,
  (VTBL_ENTRY)&(_ZTI8S7682C13[0]),
  (VTBL_ENTRY)&_ZN8S7682C133v42Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v43Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v44Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v45Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v46Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-12),
  (VTBL_ENTRY)&(_ZTI8S7682C13[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-192,-120),
  (VTBL_ENTRY)&(_ZTI8S7682C13[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
};
extern VTBL_ENTRY _ZTV8S7682C13[];
static  VTT_ENTRY vtt_S7682C13[] = {
  {&(_ZTV8S7682C13[4]),  4,35},
  {&(_ZTV8S7682C13[15]),  15,35},
  {&(_ZTV8S7682C13[28]),  28,35},
};
extern VTBL_ENTRY _ZTI8S7682C13[];
extern  VTBL_ENTRY _ZTV8S7682C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7682C13[];
Class_Descriptor cd_S7682C13 = {  "S7682C13", // class name
  bases_S7682C13, 3,
  &(vtc_S7682C13[0]), // expected_vtbl_contents
  &(vtt_S7682C13[0]), // expected_vtt_contents
  ABISELECT(400,252), // object size
  NSPAIRA(_ZTI8S7682C13),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S7682C13),35, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7682C13),3, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7682C12  : virtual S7682C13 , S7682C2 {
  __tsi64 s7682c12f0[5];
  ::S20956C14_nt s7682c12f1;
  long double s7682c12f2;
  virtual void  v47(); // _ZN8S7682C123v47Ev
  virtual void  v48(); // _ZN8S7682C123v48Ev
  virtual void  v49(); // _ZN8S7682C123v49Ev
  virtual void  v50(); // _ZN8S7682C123v50Ev
  ~S7682C12(); // tgen
  S7682C12(); // tgen
};
//SIG(-1 S7682C12) C1{ VBC2{ VBC3{ v5 v6 v7 v8 Fs:13 Fp FD[8]} VBC4{ BC3 v9 v10 v11 Fp[6]} v12 v13 v14 v15 v16 Fp[2]} BC5{ VBC3 BC4 v17 v18 v19 v20 Fp} v1 v2 v3 v4 FL[5] FC6{} FD}


void  S7682C12 ::v47(){vfunc_called(this, "_ZN8S7682C123v47Ev");}
void  S7682C12 ::v48(){vfunc_called(this, "_ZN8S7682C123v48Ev");}
void  S7682C12 ::v49(){vfunc_called(this, "_ZN8S7682C123v49Ev");}
void  S7682C12 ::v50(){vfunc_called(this, "_ZN8S7682C123v50Ev");}
S7682C12 ::~S7682C12(){ note_dtor("S7682C12", this);} // tgen
S7682C12 ::S7682C12(){ note_ctor("S7682C12", this);} // tgen

static void Test_S7682C12()
{
  extern Class_Descriptor cd_S7682C12;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(44,112)];
    init_test(&cd_S7682C12, buf);
    S7682C12 *dp, &lv = *(dp=new (buf) S7682C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(688,444), "sizeof(S7682C12)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7682C12)");
    /*is_ambiguous_... S7682C13::S7682C3 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C13*), ABISELECT(320,204), "S7682C12");
    /*is_ambiguous_... S7682C2::S7682C3 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C2*), ABISELECT(320,204), "S7682C12");
    /*is_ambiguous_... S7682C12::S7682C4 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C4*), ABISELECT(480,312), "S7682C12");
    check_base_class_offset(lv, (S7682C4*)(S7682C13*), ABISELECT(480,312), "S7682C12");
    check_base_class_offset(lv, (S7682C13*), ABISELECT(288,192), "S7682C12");
    check_base_class_offset(lv, (S7682C3*)(S7682C4*)(S7682C2*), 0, "S7682C12");
    check_base_class_offset(lv, (S7682C4*)(S7682C2*), 0, "S7682C12");
    check_base_class_offset(lv, (S7682C2*), 0, "S7682C12");
    check_field_offset(lv, s7682c12f0, ABISELECT(216,136), "S7682C12.s7682c12f0");
    check_field_offset(lv, s7682c12f1, ABISELECT(256,176), "S7682C12.s7682c12f1");
    check_field_offset(lv, s7682c12f2, ABISELECT(272,180), "S7682C12.s7682c12f2");
    test_class_info(&lv, &cd_S7682C12);
    dp->~S7682C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7682C12(Test_S7682C12, "S7682C12", ABISELECT(688,444));

#else // __cplusplus

extern void _ZN8S7682C12C1Ev();
extern void _ZN8S7682C12D1Ev();
Name_Map name_map_S7682C12[] = {
  NSPAIR(_ZN8S7682C12C1Ev),
  NSPAIR(_ZN8S7682C12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C4;
extern VTBL_ENTRY _ZTI7S7682C4[];
extern  VTBL_ENTRY _ZTV7S7682C4[];
extern Class_Descriptor cd_S7682C13;
extern VTBL_ENTRY _ZTI8S7682C13[];
extern  VTBL_ENTRY _ZTV8S7682C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7682C13[];
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C4;
extern VTBL_ENTRY _ZTI7S7682C4[];
extern  VTBL_ENTRY _ZTV7S7682C4[];
extern Class_Descriptor cd_S7682C2;
extern VTBL_ENTRY _ZTI7S7682C2[];
extern  VTBL_ENTRY _ZTV7S7682C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7682C2[];
static Base_Class bases_S7682C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7682C3,    ABISELECT(320,204), //bcp->offset
    34, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S7682C3,    ABISELECT(480,312), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S7682C4,    ABISELECT(480,312), //bcp->offset
    44, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S7682C13,    ABISELECT(288,192), //bcp->offset
    20, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7682C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7682C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S7682C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7682C12[];
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
extern void _ZN8S7682C123v47Ev();
extern void _ZN8S7682C123v48Ev();
extern void _ZN8S7682C123v49Ev();
extern void _ZN8S7682C123v50Ev();
extern void _ZN8S7682C133v42Ev();
extern void _ZN8S7682C133v43Ev();
extern void _ZN8S7682C133v44Ev();
extern void _ZN8S7682C133v45Ev();
extern void _ZN8S7682C133v46Ev();
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
static  VTBL_ENTRY vtc_S7682C12[] = {
  ABISELECT(480,312),
  ABISELECT(288,192),
  ABISELECT(320,204),
  0,
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v47Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v48Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v49Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v50Ev,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(192,120),
  ABISELECT(32,12),
  ABISELECT(-288,-192),
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN8S7682C133v42Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v43Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v44Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v45Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v46Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-320,-204),
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-480,-312),
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
};
extern VTBL_ENTRY _ZTV8S7682C12[];
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C2__8S7682C12[] = {
  ABISELECT(320,204),
  0,
  (VTBL_ENTRY)&(_ZTI7S7682C2[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__7S7682C2__8S7682C12[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-320,-204),
  (VTBL_ENTRY)&(_ZTI7S7682C2[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern void _ZN8S7682C133v42Ev();
extern void _ZN8S7682C133v43Ev();
extern void _ZN8S7682C133v44Ev();
extern void _ZN8S7682C133v45Ev();
extern void _ZN8S7682C133v46Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C13__8S7682C12[] = {
  ABISELECT(192,120),
  ABISELECT(32,12),
  0,
  (VTBL_ENTRY)&(_ZTI8S7682C13[0]),
  (VTBL_ENTRY)&_ZN8S7682C133v42Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v43Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v44Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v45Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v46Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__8S7682C13__8S7682C12[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-32,-12),
  (VTBL_ENTRY)&(_ZTI8S7682C13[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C4__8S7682C13__8S7682C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-192,-120),
  (VTBL_ENTRY)&(_ZTI8S7682C13[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
};
static  VTT_ENTRY vtt_S7682C12[] = {
  {&(_ZTV8S7682C12[5]),  5,60},
  {&(_tg__ZTV7S7682C2__8S7682C12[3]),  3,14},
  {&(_tg__ZTV7S7682C3__7S7682C2__8S7682C12[6]),  6,10},
  {&(_ZTV8S7682C12[29]),  29,60},
  {&(_ZTV8S7682C12[40]),  40,60},
  {&(_ZTV8S7682C12[53]),  53,60},
  {&(_tg__ZTV8S7682C13__8S7682C12[4]),  4,9},
  {&(_tg__ZTV7S7682C3__8S7682C13__8S7682C12[6]),  6,10},
  {&(_tg__ZTV7S7682C4__8S7682C13__8S7682C12[9]),  9,16},
};
extern VTBL_ENTRY _ZTI8S7682C12[];
extern  VTBL_ENTRY _ZTV8S7682C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7682C12[];
Class_Descriptor cd_S7682C12 = {  "S7682C12", // class name
  bases_S7682C12, 7,
  &(vtc_S7682C12[0]), // expected_vtbl_contents
  &(vtt_S7682C12[0]), // expected_vtt_contents
  ABISELECT(688,444), // object size
  NSPAIRA(_ZTI8S7682C12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S7682C12),60, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7682C12),9, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7682C11  : virtual S7682C12 {
  virtual  ~S7682C11(); // _ZN8S7682C11D2Ev
  virtual void  v51(); // _ZN8S7682C113v51Ev
  virtual void  v52(); // _ZN8S7682C113v52Ev
  S7682C11(); // tgen
};
//SIG(-1 S7682C11) C1{ VBC2{ VBC3{ VBC4{ v3 v4 v5 v6 Fs:13 Fp FD[8]} VBC5{ BC4 v7 v8 v9 Fp[6]} v10 v11 v12 v13 v14 Fp[2]} BC6{ VBC4 BC5 v15 v16 v17 v18 Fp} v19 v20 v21 v22 FL[5] FC7{} FD} vd v1 v2}


 S7682C11 ::~S7682C11(){ note_dtor("S7682C11", this);}
void  S7682C11 ::v51(){vfunc_called(this, "_ZN8S7682C113v51Ev");}
void  S7682C11 ::v52(){vfunc_called(this, "_ZN8S7682C113v52Ev");}
S7682C11 ::S7682C11(){ note_ctor("S7682C11", this);} // tgen

static void Test_S7682C11()
{
  extern Class_Descriptor cd_S7682C11;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(45,113)];
    init_test(&cd_S7682C11, buf);
    S7682C11 *dp, &lv = *(dp=new (buf) S7682C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(704,448), "sizeof(S7682C11)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7682C11)");
    /*is_ambiguous_... S7682C13::S7682C3 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C13*), ABISELECT(336,208), "S7682C11");
    /*is_ambiguous_... S7682C2::S7682C3 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C2*)(S7682C12*), ABISELECT(336,208), "S7682C11");
    /*is_ambiguous_... S7682C11::S7682C4 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C4*), ABISELECT(496,316), "S7682C11");
    check_base_class_offset(lv, (S7682C4*)(S7682C13*), ABISELECT(496,316), "S7682C11");
    check_base_class_offset(lv, (S7682C13*)(S7682C12*), ABISELECT(304,196), "S7682C11");
    check_base_class_offset(lv, (S7682C3*)(S7682C4*)(S7682C2*)(S7682C12*), ABISELECT(16,4), "S7682C11");
    check_base_class_offset(lv, (S7682C4*)(S7682C2*)(S7682C12*), ABISELECT(16,4), "S7682C11");
    check_base_class_offset(lv, (S7682C2*)(S7682C12*), ABISELECT(16,4), "S7682C11");
    check_base_class_offset(lv, (S7682C12*), ABISELECT(16,4), "S7682C11");
    test_class_info(&lv, &cd_S7682C11);
    dp->~S7682C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7682C11(Test_S7682C11, "S7682C11", ABISELECT(704,448));

#else // __cplusplus

extern void _ZN8S7682C11C1Ev();
extern void _ZN8S7682C11D2Ev();
Name_Map name_map_S7682C11[] = {
  NSPAIR(_ZN8S7682C11C1Ev),
  NSPAIR(_ZN8S7682C11D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C4;
extern VTBL_ENTRY _ZTI7S7682C4[];
extern  VTBL_ENTRY _ZTV7S7682C4[];
extern Class_Descriptor cd_S7682C13;
extern VTBL_ENTRY _ZTI8S7682C13[];
extern  VTBL_ENTRY _ZTV8S7682C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7682C13[];
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C4;
extern VTBL_ENTRY _ZTI7S7682C4[];
extern  VTBL_ENTRY _ZTV7S7682C4[];
extern Class_Descriptor cd_S7682C2;
extern VTBL_ENTRY _ZTI7S7682C2[];
extern  VTBL_ENTRY _ZTV7S7682C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7682C2[];
extern Class_Descriptor cd_S7682C12;
extern VTBL_ENTRY _ZTI8S7682C12[];
extern  VTBL_ENTRY _ZTV8S7682C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7682C12[];
static Base_Class bases_S7682C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7682C3,    ABISELECT(336,208), //bcp->offset
    59, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S7682C3,    ABISELECT(496,316), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S7682C4,    ABISELECT(496,316), //bcp->offset
    69, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S7682C13,    ABISELECT(304,196), //bcp->offset
    45, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S7682C3,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7682C4,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S7682C2,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S7682C12,    ABISELECT(16,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    20, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7682C11[];
extern void _ZN8S7682C11D1Ev();
extern void _ZN8S7682C11D0Ev();
extern void _ZN8S7682C113v51Ev();
extern void _ZN8S7682C113v52Ev();
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
extern void _ZN8S7682C123v47Ev();
extern void _ZN8S7682C123v48Ev();
extern void _ZN8S7682C123v49Ev();
extern void _ZN8S7682C123v50Ev();
extern void _ZN8S7682C133v42Ev();
extern void _ZN8S7682C133v43Ev();
extern void _ZN8S7682C133v44Ev();
extern void _ZN8S7682C133v45Ev();
extern void _ZN8S7682C133v46Ev();
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
static  VTBL_ENTRY vtc_S7682C11[] = {
  ABISELECT(496,316),
  ABISELECT(336,208),
  ABISELECT(304,196),
  ABISELECT(16,4),
  0,
  (VTBL_ENTRY)&(_ZTI8S7682C11[0]),
  (VTBL_ENTRY)&_ZN8S7682C11D1Ev,
  (VTBL_ENTRY)&_ZN8S7682C11D0Ev,
  (VTBL_ENTRY)&_ZN8S7682C113v51Ev,
  (VTBL_ENTRY)&_ZN8S7682C113v52Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(480,312),
  ABISELECT(288,192),
  ABISELECT(320,204),
  ABISELECT(-16,-4),
  (VTBL_ENTRY)&(_ZTI8S7682C11[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v47Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v48Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v49Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v50Ev,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(192,120),
  ABISELECT(32,12),
  ABISELECT(-304,-196),
  (VTBL_ENTRY)&(_ZTI8S7682C11[0]),
  (VTBL_ENTRY)&_ZN8S7682C133v42Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v43Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v44Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v45Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v46Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-336,-208),
  (VTBL_ENTRY)&(_ZTI8S7682C11[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-496,-316),
  (VTBL_ENTRY)&(_ZTI8S7682C11[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
};
extern VTBL_ENTRY _ZTV8S7682C11[];
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
extern void _ZN8S7682C123v47Ev();
extern void _ZN8S7682C123v48Ev();
extern void _ZN8S7682C123v49Ev();
extern void _ZN8S7682C123v50Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C12__8S7682C11[] = {
  ABISELECT(480,312),
  ABISELECT(288,192),
  ABISELECT(320,204),
  0,
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v47Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v48Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v49Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v50Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C28S7682C12__8S7682C11[] = {
  ABISELECT(320,204),
  0,
  (VTBL_ENTRY)&(_ZTI7S7682C2[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__7S7682C28S7682C12__8S7682C11[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-320,-204),
  (VTBL_ENTRY)&(_ZTI7S7682C2[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern void _ZN8S7682C133v42Ev();
extern void _ZN8S7682C133v43Ev();
extern void _ZN8S7682C133v44Ev();
extern void _ZN8S7682C133v45Ev();
extern void _ZN8S7682C133v46Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C13__8S7682C12__8S7682C11[] = {
  0,
  0,
  0,
  0,
  0,
  ABISELECT(192,120),
  ABISELECT(32,12),
  ABISELECT(-288,-192),
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN8S7682C133v42Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v43Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v44Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v45Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v46Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__8S7682C12__8S7682C11[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-320,-204),
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C4__8S7682C12__8S7682C11[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-480,-312),
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
};
extern void _ZN8S7682C133v42Ev();
extern void _ZN8S7682C133v43Ev();
extern void _ZN8S7682C133v44Ev();
extern void _ZN8S7682C133v45Ev();
extern void _ZN8S7682C133v46Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C13__8S7682C11[] = {
  ABISELECT(192,120),
  ABISELECT(32,12),
  0,
  (VTBL_ENTRY)&(_ZTI8S7682C13[0]),
  (VTBL_ENTRY)&_ZN8S7682C133v42Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v43Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v44Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v45Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v46Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__8S7682C13__8S7682C11[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-32,-12),
  (VTBL_ENTRY)&(_ZTI8S7682C13[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C4__8S7682C13__8S7682C11[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-192,-120),
  (VTBL_ENTRY)&(_ZTI8S7682C13[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
};
static  VTT_ENTRY vtt_S7682C11[] = {
  {&(_ZTV8S7682C11[6]),  6,85},
  {&(_ZTV8S7682C11[30]),  30,85},
  {&(_ZTV8S7682C11[54]),  54,85},
  {&(_ZTV8S7682C11[65]),  65,85},
  {&(_ZTV8S7682C11[78]),  78,85},
  {&(_tg__ZTV8S7682C12__8S7682C11[5]),  5,20},
  {&(_tg__ZTV7S7682C28S7682C12__8S7682C11[3]),  3,14},
  {&(_tg__ZTV7S7682C3__7S7682C28S7682C12__8S7682C11[6]),  6,10},
  {&(_tg__ZTV8S7682C13__8S7682C12__8S7682C11[9]),  9,14},
  {&(_tg__ZTV7S7682C3__8S7682C12__8S7682C11[6]),  6,10},
  {&(_tg__ZTV7S7682C4__8S7682C12__8S7682C11[9]),  9,16},
  {&(_tg__ZTV8S7682C13__8S7682C11[4]),  4,9},
  {&(_tg__ZTV7S7682C3__8S7682C13__8S7682C11[6]),  6,10},
  {&(_tg__ZTV7S7682C4__8S7682C13__8S7682C11[9]),  9,16},
};
extern VTBL_ENTRY _ZTI8S7682C11[];
extern  VTBL_ENTRY _ZTV8S7682C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7682C11[];
Class_Descriptor cd_S7682C11 = {  "S7682C11", // class name
  bases_S7682C11, 8,
  &(vtc_S7682C11[0]), // expected_vtbl_contents
  &(vtt_S7682C11[0]), // expected_vtt_contents
  ABISELECT(704,448), // object size
  NSPAIRA(_ZTI8S7682C11),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S7682C11),85, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7682C11),14, //virtual table table var
  8, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7682C15  : virtual S7682C3 , virtual S7682C13 , virtual S7682C9 , S7682C4 {
  int s7682c15f0;
  virtual  ~S7682C15(); // _ZN8S7682C15D2Ev
  virtual void  v53(); // _ZN8S7682C153v53Ev
  virtual void  v54(); // _ZN8S7682C153v54Ev
  virtual void  v55(); // _ZN8S7682C153v55Ev
  virtual void  v56(); // _ZN8S7682C153v56Ev
  S7682C15(); // tgen
};
//SIG(-1 S7682C15) C1{ VBC2{ v5 v6 v7 v8 Fs:13 Fp FD[8]} VBC3{ VBC2 VBC4{ BC2 v9 v10 v11 Fp[6]} v12 v13 v14 v15 v16 Fp[2]} VBC5{ v17 v18 v19 v20 v21 v22 v23 v24 v25 FC4[7]} BC4 vd v1 v2 v3 v4 Fi}


 S7682C15 ::~S7682C15(){ note_dtor("S7682C15", this);}
void  S7682C15 ::v53(){vfunc_called(this, "_ZN8S7682C153v53Ev");}
void  S7682C15 ::v54(){vfunc_called(this, "_ZN8S7682C153v54Ev");}
void  S7682C15 ::v55(){vfunc_called(this, "_ZN8S7682C153v55Ev");}
void  S7682C15 ::v56(){vfunc_called(this, "_ZN8S7682C153v56Ev");}
S7682C15 ::S7682C15(){ note_ctor("S7682C15", this);} // tgen

static void Test_S7682C15()
{
  extern Class_Descriptor cd_S7682C15;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(132,330)];
    init_test(&cd_S7682C15, buf);
    S7682C15 *dp, &lv = *(dp=new (buf) S7682C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2096,1316), "sizeof(S7682C15)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7682C15)");
    /*is_ambiguous_... S7682C15::S7682C3 */ AMB_check_base_class_offset(lv, (S7682C3*), ABISELECT(224,136), "S7682C15");
    /*is_ambiguous_... S7682C13::S7682C3 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C13*), ABISELECT(224,136), "S7682C15");
    /*is_ambiguous_... S7682C15::S7682C4 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C4*), ABISELECT(416,256), "S7682C15");
    check_base_class_offset(lv, (S7682C4*)(S7682C13*), ABISELECT(416,256), "S7682C15");
    check_base_class_offset(lv, (S7682C13*), ABISELECT(384,244), "S7682C15");
    check_base_class_offset(lv, (S7682C9*), ABISELECT(624,388), "S7682C15");
    /*is_ambiguous_... S7682C15::S7682C4 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C4*), 0, "S7682C15");
    /*is_ambiguous_... S7682C15::S7682C4 */ AMB_check_base_class_offset(lv, (S7682C4*), 0, "S7682C15");
    check_field_offset(lv, s7682c15f0, ABISELECT(208,132), "S7682C15.s7682c15f0");
    test_class_info(&lv, &cd_S7682C15);
    dp->~S7682C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7682C15(Test_S7682C15, "S7682C15", ABISELECT(2096,1316));

#else // __cplusplus

extern void _ZN8S7682C15C1Ev();
extern void _ZN8S7682C15D2Ev();
Name_Map name_map_S7682C15[] = {
  NSPAIR(_ZN8S7682C15C1Ev),
  NSPAIR(_ZN8S7682C15D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C4;
extern VTBL_ENTRY _ZTI7S7682C4[];
extern  VTBL_ENTRY _ZTV7S7682C4[];
extern Class_Descriptor cd_S7682C13;
extern VTBL_ENTRY _ZTI8S7682C13[];
extern  VTBL_ENTRY _ZTV8S7682C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7682C13[];
extern Class_Descriptor cd_S7682C9;
extern VTBL_ENTRY _ZTI7S7682C9[];
extern  VTBL_ENTRY _ZTV7S7682C9[];
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C4;
extern VTBL_ENTRY _ZTI7S7682C4[];
extern  VTBL_ENTRY _ZTV7S7682C4[];
static Base_Class bases_S7682C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7682C3,    ABISELECT(224,136), //bcp->offset
    19, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7682C3,    ABISELECT(416,256), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S7682C4,    ABISELECT(416,256), //bcp->offset
    43, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S7682C13,    ABISELECT(384,244), //bcp->offset
    29, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7682C9,    ABISELECT(624,388), //bcp->offset
    59, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7682C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S7682C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7682C15[];
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN8S7682C15D1Ev();
extern void _ZN8S7682C15D0Ev();
extern void _ZN8S7682C153v53Ev();
extern void _ZN8S7682C153v54Ev();
extern void _ZN8S7682C153v55Ev();
extern void _ZN8S7682C153v56Ev();
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN8S7682C133v42Ev();
extern void _ZN8S7682C133v43Ev();
extern void _ZN8S7682C133v44Ev();
extern void _ZN8S7682C133v45Ev();
extern void _ZN8S7682C133v46Ev();
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C93v33Ev();
extern void _ZN7S7682C93v34Ev();
extern void _ZN7S7682C93v35Ev();
extern void _ZN7S7682C93v36Ev();
extern void _ZN7S7682C93v37Ev();
extern void _ZN7S7682C93v38Ev();
extern void _ZN7S7682C93v39Ev();
extern void _ZN7S7682C93v40Ev();
extern void _ZN7S7682C93v41Ev();
static  VTBL_ENTRY vtc_S7682C15[] = {
  ABISELECT(624,388),
  ABISELECT(416,256),
  ABISELECT(384,244),
  ABISELECT(224,136),
  0,
  (VTBL_ENTRY)&(_ZTI8S7682C15[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN8S7682C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7682C15D0Ev,
  (VTBL_ENTRY)&_ZN8S7682C153v53Ev,
  (VTBL_ENTRY)&_ZN8S7682C153v54Ev,
  (VTBL_ENTRY)&_ZN8S7682C153v55Ev,
  (VTBL_ENTRY)&_ZN8S7682C153v56Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-224,-136),
  (VTBL_ENTRY)&(_ZTI8S7682C15[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(32,12),
  ABISELECT(-160,-108),
  ABISELECT(-384,-244),
  (VTBL_ENTRY)&(_ZTI8S7682C15[0]),
  (VTBL_ENTRY)&_ZN8S7682C133v42Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v43Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v44Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v45Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v46Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-416,-256),
  (VTBL_ENTRY)&(_ZTI8S7682C15[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-624,-388),
  (VTBL_ENTRY)&(_ZTI8S7682C15[0]),
  (VTBL_ENTRY)&_ZN7S7682C93v33Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v34Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v35Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v36Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v37Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v38Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v39Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v40Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v41Ev,
};
extern VTBL_ENTRY _ZTV8S7682C15[];
extern void _ZN8S7682C133v42Ev();
extern void _ZN8S7682C133v43Ev();
extern void _ZN8S7682C133v44Ev();
extern void _ZN8S7682C133v45Ev();
extern void _ZN8S7682C133v46Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C13__8S7682C15[] = {
  ABISELECT(32,12),
  ABISELECT(-160,-108),
  0,
  (VTBL_ENTRY)&(_ZTI8S7682C13[0]),
  (VTBL_ENTRY)&_ZN8S7682C133v42Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v43Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v44Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v45Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v46Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__8S7682C13__8S7682C15[] = {
  0,
  0,
  0,
  0,
  ABISELECT(160,108),
  (VTBL_ENTRY)&(_ZTI8S7682C13[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C4__8S7682C13__8S7682C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-12),
  (VTBL_ENTRY)&(_ZTI8S7682C13[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
};
static  VTT_ENTRY vtt_S7682C15[] = {
  {&(_ZTV8S7682C15[6]),  6,79},
  {&(_ZTV8S7682C15[25]),  25,79},
  {&(_ZTV8S7682C15[38]),  38,79},
  {&(_ZTV8S7682C15[52]),  52,79},
  {&(_ZTV8S7682C15[70]),  70,79},
  {&(_tg__ZTV8S7682C13__8S7682C15[4]),  4,9},
  {&(_tg__ZTV7S7682C3__8S7682C13__8S7682C15[6]),  6,10},
  {&(_tg__ZTV7S7682C4__8S7682C13__8S7682C15[9]),  9,16},
};
extern VTBL_ENTRY _ZTI8S7682C15[];
extern  VTBL_ENTRY _ZTV8S7682C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7682C15[];
Class_Descriptor cd_S7682C15 = {  "S7682C15", // class name
  bases_S7682C15, 7,
  &(vtc_S7682C15[0]), // expected_vtbl_contents
  &(vtt_S7682C15[0]), // expected_vtt_contents
  ABISELECT(2096,1316), // object size
  NSPAIRA(_ZTI8S7682C15),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S7682C15),79, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7682C15),8, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7682C10  : virtual S7682C8_nt , virtual S7682C11 , S7682C12 , S7682C15 {
  int s7682c10f0[8];
  char s7682c10f1;
  __tsi64 s7682c10f2;
  virtual  ~S7682C10(); // _ZN8S7682C10D2Ev
  virtual void  v57(); // _ZN8S7682C103v57Ev
  virtual void  v58(); // _ZN8S7682C103v58Ev
  virtual void  v59(); // _ZN8S7682C103v59Ev
  virtual void  v60(); // _ZN8S7682C103v60Ev
  virtual void  v61(); // _ZN8S7682C103v61Ev
  virtual void  v62(); // _ZN8S7682C103v62Ev
  virtual void  v63(); // _ZN8S7682C103v63Ev
  virtual void  v64(); // _ZN8S7682C103v64Ev
  S7682C10(); // tgen
};
//SIG(-1 S7682C10) C1{ VBC2{ v9 v10 v11 v12} VBC3{ VBC4{ VBC5{ VBC6{ v13 v14 v15 v16 Fs:13 Fp FD[8]} VBC7{ BC6 v17 v18 v19 Fp[6]} v20 v21 v22 v23 v24 Fp[2]} BC8{ VBC6 BC7 v25 v26 v27 v28 Fp} v29 v30 v31 v32 FL[5] FC9{} FD} vd v33 v34} BC4 BC10{ VBC6 VBC5 VBC11{ v35 v36 v37 v38 v39 v40 v41 v42 v43 FC7[7]} BC7 vd v44 v45 v46 v47 Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 Fi[8] Fc FL}


 S7682C10 ::~S7682C10(){ note_dtor("S7682C10", this);}
void  S7682C10 ::v57(){vfunc_called(this, "_ZN8S7682C103v57Ev");}
void  S7682C10 ::v58(){vfunc_called(this, "_ZN8S7682C103v58Ev");}
void  S7682C10 ::v59(){vfunc_called(this, "_ZN8S7682C103v59Ev");}
void  S7682C10 ::v60(){vfunc_called(this, "_ZN8S7682C103v60Ev");}
void  S7682C10 ::v61(){vfunc_called(this, "_ZN8S7682C103v61Ev");}
void  S7682C10 ::v62(){vfunc_called(this, "_ZN8S7682C103v62Ev");}
void  S7682C10 ::v63(){vfunc_called(this, "_ZN8S7682C103v63Ev");}
void  S7682C10 ::v64(){vfunc_called(this, "_ZN8S7682C103v64Ev");}
S7682C10 ::S7682C10(){ note_ctor("S7682C10", this);} // tgen

static void Test_S7682C10()
{
  extern Class_Descriptor cd_S7682C10;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(171,439)];
    init_test(&cd_S7682C10, buf);
    S7682C10 *dp, &lv = *(dp=new (buf) S7682C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2720,1752), "sizeof(S7682C10)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7682C10)");
    check_base_class_offset(lv, (S7682C8_nt*), ABISELECT(544,372), "S7682C10");
    /*is_ambiguous_... S7682C13::S7682C3 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C13*), ABISELECT(880,584), "S7682C10");
    /*is_ambiguous_... S7682C10::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C2*)(S7682C12*), ABISELECT(880,584), "S7682C10");
    /*is_ambiguous_... S7682C10::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C2*)(S7682C12*), ABISELECT(880,584), "S7682C10");
    /*is_ambiguous_... S7682C15::S7682C3 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C15*), ABISELECT(880,584), "S7682C10");
    /*is_ambiguous_... S7682C10::S7682C4 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C4*), ABISELECT(1040,692), "S7682C10");
    check_base_class_offset(lv, (S7682C4*)(S7682C13*), ABISELECT(1040,692), "S7682C10");
    /*is_ambiguous_... S7682C10::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C13*)(S7682C12*), ABISELECT(848,572), "S7682C10");
    /*is_ambiguous_... S7682C10::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C13*)(S7682C12*), ABISELECT(848,572), "S7682C10");
    check_base_class_offset(lv, (S7682C13*)(S7682C15*), ABISELECT(848,572), "S7682C10");
    /*is_ambiguous_... S7682C10::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C4*)(S7682C2*)(S7682C12*), ABISELECT(560,380), "S7682C10");
    /*is_ambiguous_... S7682C10::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C4*)(S7682C2*)(S7682C12*), ABISELECT(560,380), "S7682C10");
    /*is_ambiguous_... S7682C10::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C2*)(S7682C12*), ABISELECT(560,380), "S7682C10");
    check_base_class_offset(lv, (S7682C12*)(S7682C11*), ABISELECT(560,380), "S7682C10");
    check_base_class_offset(lv, (S7682C11*), ABISELECT(552,376), "S7682C10");
    /*is_ambiguous_... S7682C10::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C4*)(S7682C2*)(S7682C12*), 0, "S7682C10");
    /*is_ambiguous_... S7682C10::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C4*)(S7682C2*)(S7682C12*), 0, "S7682C10");
    /*is_ambiguous_... S7682C10::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C2*)(S7682C12*), 0, "S7682C10");
    /*is_ambiguous_... S7682C10::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C12*), 0, "S7682C10");
    check_base_class_offset(lv, (S7682C9*)(S7682C15*), ABISELECT(1248,824), "S7682C10");
    /*is_ambiguous_... S7682C15::S7682C4 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C4*)(S7682C15*), ABISELECT(288,192), "S7682C10");
    /*is_ambiguous_... S7682C15::S7682C4 */ AMB_check_base_class_offset(lv, (S7682C4*)(S7682C15*), ABISELECT(288,192), "S7682C10");
    check_base_class_offset(lv, (S7682C15*), ABISELECT(288,192), "S7682C10");
    check_field_offset(lv, s7682c10f0, ABISELECT(500,328), "S7682C10.s7682c10f0");
    check_field_offset(lv, s7682c10f1, ABISELECT(532,360), "S7682C10.s7682c10f1");
    check_field_offset(lv, s7682c10f2, ABISELECT(536,364), "S7682C10.s7682c10f2");
    test_class_info(&lv, &cd_S7682C10);
    dp->~S7682C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7682C10(Test_S7682C10, "S7682C10", ABISELECT(2720,1752));

#else // __cplusplus

extern void _ZN8S7682C10C1Ev();
extern void _ZN8S7682C10D2Ev();
Name_Map name_map_S7682C10[] = {
  NSPAIR(_ZN8S7682C10C1Ev),
  NSPAIR(_ZN8S7682C10D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7682C8_nt;
extern VTBL_ENTRY _ZTI10S7682C8_nt[];
extern  VTBL_ENTRY _ZTV10S7682C8_nt[];
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C4;
extern VTBL_ENTRY _ZTI7S7682C4[];
extern  VTBL_ENTRY _ZTV7S7682C4[];
extern Class_Descriptor cd_S7682C13;
extern VTBL_ENTRY _ZTI8S7682C13[];
extern  VTBL_ENTRY _ZTV8S7682C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7682C13[];
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C4;
extern VTBL_ENTRY _ZTI7S7682C4[];
extern  VTBL_ENTRY _ZTV7S7682C4[];
extern Class_Descriptor cd_S7682C2;
extern VTBL_ENTRY _ZTI7S7682C2[];
extern  VTBL_ENTRY _ZTV7S7682C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7682C2[];
extern Class_Descriptor cd_S7682C12;
extern VTBL_ENTRY _ZTI8S7682C12[];
extern  VTBL_ENTRY _ZTV8S7682C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7682C12[];
extern Class_Descriptor cd_S7682C11;
extern VTBL_ENTRY _ZTI8S7682C11[];
extern  VTBL_ENTRY _ZTV8S7682C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7682C11[];
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C4;
extern VTBL_ENTRY _ZTI7S7682C4[];
extern  VTBL_ENTRY _ZTV7S7682C4[];
extern Class_Descriptor cd_S7682C2;
extern VTBL_ENTRY _ZTI7S7682C2[];
extern  VTBL_ENTRY _ZTV7S7682C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7682C2[];
extern Class_Descriptor cd_S7682C12;
extern VTBL_ENTRY _ZTI8S7682C12[];
extern  VTBL_ENTRY _ZTV8S7682C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7682C12[];
extern Class_Descriptor cd_S7682C9;
extern VTBL_ENTRY _ZTI7S7682C9[];
extern  VTBL_ENTRY _ZTV7S7682C9[];
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C4;
extern VTBL_ENTRY _ZTI7S7682C4[];
extern  VTBL_ENTRY _ZTV7S7682C4[];
extern Class_Descriptor cd_S7682C15;
extern VTBL_ENTRY _ZTI8S7682C15[];
extern  VTBL_ENTRY _ZTV8S7682C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7682C15[];
static Base_Class bases_S7682C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7682C8_nt,    ABISELECT(544,372), //bcp->offset
    53, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7682C3,    ABISELECT(880,584), //bcp->offset
    125, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S7682C3,    ABISELECT(1040,692), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S7682C4,    ABISELECT(1040,692), //bcp->offset
    135, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S7682C13,    ABISELECT(848,572), //bcp->offset
    111, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S7682C3,    ABISELECT(560,380), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S7682C4,    ABISELECT(560,380), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S7682C2,    ABISELECT(560,380), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    27, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7682C12,    ABISELECT(560,380), //bcp->offset
    76, //bcp->virtual_function_table_offset
    20, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S7682C11,    ABISELECT(552,376), //bcp->offset
    63, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7682C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S7682C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S7682C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S7682C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7682C9,    ABISELECT(1248,824), //bcp->offset
    151, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    17, //immediately_derived
  0, 1},
  {&cd_S7682C3,    ABISELECT(288,192), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S7682C4,    ABISELECT(288,192), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S7682C15,    ABISELECT(288,192), //bcp->offset
    34, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7682C10[];
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
extern void _ZN8S7682C123v47Ev();
extern void _ZN8S7682C123v48Ev();
extern void _ZN8S7682C123v49Ev();
extern void _ZN8S7682C123v50Ev();
extern void _ZN8S7682C10D1Ev();
extern void _ZN8S7682C10D0Ev();
extern void _ZN8S7682C103v57Ev();
extern void _ZN8S7682C103v58Ev();
extern void _ZN8S7682C103v59Ev();
extern void _ZN8S7682C103v60Ev();
extern void _ZN8S7682C103v61Ev();
extern void _ZN8S7682C103v62Ev();
extern void _ZN8S7682C103v63Ev();
extern void _ZN8S7682C103v64Ev();
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void ABISELECT(_ZThn288_N8S7682C10D1Ev,_ZThn192_N8S7682C10D1Ev)();
extern void ABISELECT(_ZThn288_N8S7682C10D0Ev,_ZThn192_N8S7682C10D0Ev)();
extern void _ZN8S7682C153v53Ev();
extern void _ZN8S7682C153v54Ev();
extern void _ZN8S7682C153v55Ev();
extern void _ZN8S7682C153v56Ev();
extern void _ZN10S7682C8_nt3v29Ev();
extern void _ZN10S7682C8_nt3v30Ev();
extern void _ZN10S7682C8_nt3v31Ev();
extern void _ZN10S7682C8_nt3v32Ev();
extern void ABISELECT(_ZTv0_n56_N8S7682C10D1Ev,_ZTv0_n28_N8S7682C10D1Ev)();
extern void ABISELECT(_ZThn552_N8S7682C10D1Ev,_ZThn376_N8S7682C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7682C10D0Ev,_ZTv0_n28_N8S7682C10D0Ev)();
extern void ABISELECT(_ZThn552_N8S7682C10D0Ev,_ZThn376_N8S7682C10D0Ev)() __attribute__((weak));
extern void _ZN8S7682C113v51Ev();
extern void _ZN8S7682C113v52Ev();
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
extern void _ZN8S7682C123v47Ev();
extern void _ZN8S7682C123v48Ev();
extern void _ZN8S7682C123v49Ev();
extern void _ZN8S7682C123v50Ev();
extern void _ZN8S7682C133v42Ev();
extern void _ZN8S7682C133v43Ev();
extern void _ZN8S7682C133v44Ev();
extern void _ZN8S7682C133v45Ev();
extern void _ZN8S7682C133v46Ev();
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C93v33Ev();
extern void _ZN7S7682C93v34Ev();
extern void _ZN7S7682C93v35Ev();
extern void _ZN7S7682C93v36Ev();
extern void _ZN7S7682C93v37Ev();
extern void _ZN7S7682C93v38Ev();
extern void _ZN7S7682C93v39Ev();
extern void _ZN7S7682C93v40Ev();
extern void _ZN7S7682C93v41Ev();
static  VTBL_ENTRY vtc_S7682C10[] = {
  ABISELECT(1248,824),
  ABISELECT(560,380),
  ABISELECT(552,376),
  ABISELECT(544,372),
  ABISELECT(1040,692),
  ABISELECT(848,572),
  ABISELECT(880,584),
  0,
  (VTBL_ENTRY)&(_ZTI8S7682C10[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v47Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v48Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v49Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v50Ev,
  (VTBL_ENTRY)&_ZN8S7682C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7682C10D0Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v57Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v58Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v59Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v60Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v61Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v62Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v63Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v64Ev,
  ABISELECT(960,632),
  ABISELECT(752,500),
  ABISELECT(560,380),
  ABISELECT(592,392),
  ABISELECT(-288,-192),
  (VTBL_ENTRY)&(_ZTI8S7682C10[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn288_N8S7682C10D1Ev,_ZThn192_N8S7682C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn288_N8S7682C10D0Ev,_ZThn192_N8S7682C10D0Ev),
  (VTBL_ENTRY)&_ZN8S7682C153v53Ev,
  (VTBL_ENTRY)&_ZN8S7682C153v54Ev,
  (VTBL_ENTRY)&_ZN8S7682C153v55Ev,
  (VTBL_ENTRY)&_ZN8S7682C153v56Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-544,-372),
  (VTBL_ENTRY)&(_ZTI8S7682C10[0]),
  (VTBL_ENTRY)&_ZN10S7682C8_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S7682C8_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S7682C8_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S7682C8_nt3v32Ev,
  0,
  0,
  ABISELECT(-552,-376),
  ABISELECT(488,316),
  ABISELECT(328,208),
  ABISELECT(296,196),
  ABISELECT(8,4),
  ABISELECT(-552,-376),
  (VTBL_ENTRY)&(_ZTI8S7682C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7682C10D1Ev,_ZTv0_n28_N8S7682C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7682C10D0Ev,_ZTv0_n28_N8S7682C10D0Ev),
  (VTBL_ENTRY)&_ZN8S7682C113v51Ev,
  (VTBL_ENTRY)&_ZN8S7682C113v52Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(480,312),
  ABISELECT(288,192),
  ABISELECT(320,204),
  ABISELECT(-560,-380),
  (VTBL_ENTRY)&(_ZTI8S7682C10[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v47Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v48Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v49Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v50Ev,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(192,120),
  ABISELECT(32,12),
  ABISELECT(-848,-572),
  (VTBL_ENTRY)&(_ZTI8S7682C10[0]),
  (VTBL_ENTRY)&_ZN8S7682C133v42Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v43Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v44Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v45Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v46Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-880,-584),
  (VTBL_ENTRY)&(_ZTI8S7682C10[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-1040,-692),
  (VTBL_ENTRY)&(_ZTI8S7682C10[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-1248,-824),
  (VTBL_ENTRY)&(_ZTI8S7682C10[0]),
  (VTBL_ENTRY)&_ZN7S7682C93v33Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v34Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v35Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v36Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v37Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v38Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v39Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v40Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v41Ev,
};
extern VTBL_ENTRY _ZTV8S7682C10[];
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
extern void _ZN8S7682C123v47Ev();
extern void _ZN8S7682C123v48Ev();
extern void _ZN8S7682C123v49Ev();
extern void _ZN8S7682C123v50Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C12__A__8S7682C10[] = {
  ABISELECT(1040,692),
  ABISELECT(848,572),
  ABISELECT(880,584),
  0,
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v47Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v48Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v49Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v50Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C28S7682C12__A1__8S7682C10[] = {
  ABISELECT(880,584),
  0,
  (VTBL_ENTRY)&(_ZTI7S7682C2[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__7S7682C28S7682C12__A1__8S7682C10[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-880,-584),
  (VTBL_ENTRY)&(_ZTI7S7682C2[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern void _ZN8S7682C133v42Ev();
extern void _ZN8S7682C133v43Ev();
extern void _ZN8S7682C133v44Ev();
extern void _ZN8S7682C133v45Ev();
extern void _ZN8S7682C133v46Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C13__8S7682C12__A__8S7682C10[] = {
  0,
  0,
  0,
  0,
  0,
  ABISELECT(192,120),
  ABISELECT(32,12),
  ABISELECT(-848,-572),
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN8S7682C133v42Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v43Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v44Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v45Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v46Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__8S7682C12__A__8S7682C10[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-880,-584),
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C4__8S7682C12__A__8S7682C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-1040,-692),
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN8S7682C15D1Ev();
extern void _ZN8S7682C15D0Ev();
extern void _ZN8S7682C153v53Ev();
extern void _ZN8S7682C153v54Ev();
extern void _ZN8S7682C153v55Ev();
extern void _ZN8S7682C153v56Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C15__8S7682C10[] = {
  ABISELECT(960,632),
  ABISELECT(752,500),
  ABISELECT(560,380),
  ABISELECT(592,392),
  0,
  (VTBL_ENTRY)&(_ZTI8S7682C15[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN8S7682C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7682C15D0Ev,
  (VTBL_ENTRY)&_ZN8S7682C153v53Ev,
  (VTBL_ENTRY)&_ZN8S7682C153v54Ev,
  (VTBL_ENTRY)&_ZN8S7682C153v55Ev,
  (VTBL_ENTRY)&_ZN8S7682C153v56Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__8S7682C15__8S7682C10[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-592,-392),
  (VTBL_ENTRY)&(_ZTI8S7682C15[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern void _ZN8S7682C133v42Ev();
extern void _ZN8S7682C133v43Ev();
extern void _ZN8S7682C133v44Ev();
extern void _ZN8S7682C133v45Ev();
extern void _ZN8S7682C133v46Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C13__8S7682C15__8S7682C10[] = {
  0,
  0,
  0,
  0,
  0,
  ABISELECT(192,120),
  ABISELECT(32,12),
  ABISELECT(-560,-380),
  (VTBL_ENTRY)&(_ZTI8S7682C15[0]),
  (VTBL_ENTRY)&_ZN8S7682C133v42Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v43Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v44Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v45Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v46Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C4__8S7682C15__8S7682C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-752,-500),
  (VTBL_ENTRY)&(_ZTI8S7682C15[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
};
extern void _ZN7S7682C93v33Ev();
extern void _ZN7S7682C93v34Ev();
extern void _ZN7S7682C93v35Ev();
extern void _ZN7S7682C93v36Ev();
extern void _ZN7S7682C93v37Ev();
extern void _ZN7S7682C93v38Ev();
extern void _ZN7S7682C93v39Ev();
extern void _ZN7S7682C93v40Ev();
extern void _ZN7S7682C93v41Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C9__8S7682C15__8S7682C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-960,-632),
  (VTBL_ENTRY)&(_ZTI8S7682C15[0]),
  (VTBL_ENTRY)&_ZN7S7682C93v33Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v34Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v35Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v36Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v37Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v38Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v39Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v40Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v41Ev,
};
extern void _ZN8S7682C11D1Ev();
extern void _ZN8S7682C11D0Ev();
extern void _ZN8S7682C113v51Ev();
extern void _ZN8S7682C113v52Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C11__8S7682C10[] = {
  ABISELECT(488,316),
  ABISELECT(328,208),
  ABISELECT(296,196),
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI8S7682C11[0]),
  (VTBL_ENTRY)&_ZN8S7682C11D1Ev,
  (VTBL_ENTRY)&_ZN8S7682C11D0Ev,
  (VTBL_ENTRY)&_ZN8S7682C113v51Ev,
  (VTBL_ENTRY)&_ZN8S7682C113v52Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
extern void _ZN8S7682C123v47Ev();
extern void _ZN8S7682C123v48Ev();
extern void _ZN8S7682C123v49Ev();
extern void _ZN8S7682C123v50Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C12__8S7682C11__8S7682C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(480,312),
  ABISELECT(288,192),
  ABISELECT(320,204),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S7682C11[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v47Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v48Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v49Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v50Ev,
};
extern void _ZN8S7682C133v42Ev();
extern void _ZN8S7682C133v43Ev();
extern void _ZN8S7682C133v44Ev();
extern void _ZN8S7682C133v45Ev();
extern void _ZN8S7682C133v46Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C13__8S7682C11__8S7682C10[] = {
  0,
  0,
  0,
  0,
  0,
  ABISELECT(192,120),
  ABISELECT(32,12),
  ABISELECT(-296,-196),
  (VTBL_ENTRY)&(_ZTI8S7682C11[0]),
  (VTBL_ENTRY)&_ZN8S7682C133v42Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v43Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v44Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v45Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v46Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__8S7682C11__8S7682C10[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-328,-208),
  (VTBL_ENTRY)&(_ZTI8S7682C11[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C4__8S7682C11__8S7682C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-488,-316),
  (VTBL_ENTRY)&(_ZTI8S7682C11[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
extern void _ZN8S7682C123v47Ev();
extern void _ZN8S7682C123v48Ev();
extern void _ZN8S7682C123v49Ev();
extern void _ZN8S7682C123v50Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C12__8S7682C10[] = {
  ABISELECT(480,312),
  ABISELECT(288,192),
  ABISELECT(320,204),
  0,
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v47Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v48Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v49Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v50Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C28S7682C12__8S7682C10[] = {
  ABISELECT(320,204),
  0,
  (VTBL_ENTRY)&(_ZTI7S7682C2[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__7S7682C28S7682C12__8S7682C10[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-320,-204),
  (VTBL_ENTRY)&(_ZTI7S7682C2[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern void _ZN8S7682C133v42Ev();
extern void _ZN8S7682C133v43Ev();
extern void _ZN8S7682C133v44Ev();
extern void _ZN8S7682C133v45Ev();
extern void _ZN8S7682C133v46Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C13__8S7682C12__8S7682C10[] = {
  0,
  0,
  0,
  0,
  0,
  ABISELECT(192,120),
  ABISELECT(32,12),
  ABISELECT(-288,-192),
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN8S7682C133v42Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v43Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v44Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v45Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v46Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__8S7682C12__8S7682C10[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-320,-204),
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C4__8S7682C12__8S7682C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-480,-312),
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
};
extern void _ZN8S7682C133v42Ev();
extern void _ZN8S7682C133v43Ev();
extern void _ZN8S7682C133v44Ev();
extern void _ZN8S7682C133v45Ev();
extern void _ZN8S7682C133v46Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C13__8S7682C10[] = {
  ABISELECT(192,120),
  ABISELECT(32,12),
  0,
  (VTBL_ENTRY)&(_ZTI8S7682C13[0]),
  (VTBL_ENTRY)&_ZN8S7682C133v42Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v43Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v44Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v45Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v46Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__8S7682C13__8S7682C10[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-32,-12),
  (VTBL_ENTRY)&(_ZTI8S7682C13[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C4__8S7682C13__8S7682C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-192,-120),
  (VTBL_ENTRY)&(_ZTI8S7682C13[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
};
static  VTT_ENTRY vtt_S7682C10[] = {
  {&(_ZTV8S7682C10[9]),  9,171},
  {&(_tg__ZTV8S7682C12__A__8S7682C10[5]),  5,20},
  {&(_tg__ZTV7S7682C28S7682C12__A1__8S7682C10[3]),  3,14},
  {&(_tg__ZTV7S7682C3__7S7682C28S7682C12__A1__8S7682C10[6]),  6,10},
  {&(_tg__ZTV8S7682C13__8S7682C12__A__8S7682C10[9]),  9,14},
  {&(_tg__ZTV7S7682C3__8S7682C12__A__8S7682C10[6]),  6,10},
  {&(_tg__ZTV7S7682C4__8S7682C12__A__8S7682C10[9]),  9,16},
  {&(_tg__ZTV8S7682C15__8S7682C10[6]),  6,19},
  {&(_tg__ZTV7S7682C3__8S7682C15__8S7682C10[6]),  6,10},
  {&(_tg__ZTV8S7682C13__8S7682C15__8S7682C10[9]),  9,14},
  {&(_tg__ZTV7S7682C4__8S7682C15__8S7682C10[9]),  9,16},
  {&(_tg__ZTV7S7682C9__8S7682C15__8S7682C10[11]),  11,20},
  {&(_ZTV8S7682C10[59]),  59,171},
  {&(_ZTV8S7682C10[72]),  72,171},
  {&(_ZTV8S7682C10[96]),  96,171},
  {&(_ZTV8S7682C10[120]),  120,171},
  {&(_ZTV8S7682C10[131]),  131,171},
  {&(_ZTV8S7682C10[144]),  144,171},
  {&(_ZTV8S7682C10[40]),  40,171},
  {&(_ZTV8S7682C10[162]),  162,171},
  {&(_tg__ZTV8S7682C11__8S7682C10[6]),  6,10},
  {&(_tg__ZTV8S7682C12__8S7682C11__8S7682C10[20]),  20,35},
  {&(_tg__ZTV8S7682C13__8S7682C11__8S7682C10[9]),  9,14},
  {&(_tg__ZTV7S7682C3__8S7682C11__8S7682C10[6]),  6,10},
  {&(_tg__ZTV7S7682C4__8S7682C11__8S7682C10[9]),  9,16},
  {&(_tg__ZTV8S7682C12__8S7682C10[5]),  5,20},
  {&(_tg__ZTV7S7682C28S7682C12__8S7682C10[3]),  3,14},
  {&(_tg__ZTV7S7682C3__7S7682C28S7682C12__8S7682C10[6]),  6,10},
  {&(_tg__ZTV8S7682C13__8S7682C12__8S7682C10[9]),  9,14},
  {&(_tg__ZTV7S7682C3__8S7682C12__8S7682C10[6]),  6,10},
  {&(_tg__ZTV7S7682C4__8S7682C12__8S7682C10[9]),  9,16},
  {&(_tg__ZTV8S7682C13__8S7682C10[4]),  4,9},
  {&(_tg__ZTV7S7682C3__8S7682C13__8S7682C10[6]),  6,10},
  {&(_tg__ZTV7S7682C4__8S7682C13__8S7682C10[9]),  9,16},
};
extern VTBL_ENTRY _ZTI8S7682C10[];
extern  VTBL_ENTRY _ZTV8S7682C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7682C10[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7682C10D0Ev,_ZTv0_n28_N8S7682C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn552_N8S7682C10D0Ev,_ZThn376_N8S7682C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7682C10D1Ev,_ZTv0_n28_N8S7682C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn552_N8S7682C10D1Ev,_ZThn376_N8S7682C10D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7682C10 = {  "S7682C10", // class name
  bases_S7682C10, 18,
  &(vtc_S7682C10[0]), // expected_vtbl_contents
  &(vtt_S7682C10[0]), // expected_vtt_contents
  ABISELECT(2720,1752), // object size
  NSPAIRA(_ZTI8S7682C10),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S7682C10),171, //virtual function table var
  9, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7682C10),34, //virtual table table var
  18, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7682C7  : virtual S7682C8_nt , S7682C9 , S7682C10 {
  int s7682c7f0[5];
  int s7682c7f1:15;
  virtual  ~S7682C7(); // _ZN7S7682C7D2Ev
  S7682C7(); // tgen
};
//SIG(-1 S7682C7) C1{ VBC2{ v1 v2 v3 v4} BC3{ v5 v6 v7 v8 v9 v10 v11 v12 v13 FC4{ BC5{ v14 v15 v16 v17 Fs:13 Fp FD[8]} v18 v19 v20 Fp[6]}[7]} BC6{ VBC2 VBC7{ VBC8{ VBC9{ VBC5 VBC4 v21 v22 v23 v24 v25 Fp[2]} BC10{ VBC5 BC4 v26 v27 v28 v29 Fp} v30 v31 v32 v33 FL[5] FC11{} FD} vd v34 v35} BC8 BC12{ VBC5 VBC9 VBC3 BC4 vd v36 v37 v38 v39 Fi} vd v40 v41 v42 v43 v44 v45 v46 v47 Fi[8] Fc FL} vd Fi[5] Fi:15}


 S7682C7 ::~S7682C7(){ note_dtor("S7682C7", this);}
S7682C7 ::S7682C7(){ note_ctor("S7682C7", this);} // tgen

static void Test_S7682C7()
{
  extern Class_Descriptor cd_S7682C7;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(265,677)];
    init_test(&cd_S7682C7, buf);
    S7682C7 *dp, &lv = *(dp=new (buf) S7682C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(4224,2704), "sizeof(S7682C7)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7682C7)");
    check_base_class_offset(lv, (S7682C8_nt*), ABISELECT(2040,1324), "S7682C7");
    check_base_class_offset(lv, (S7682C8_nt*)(S7682C10*), ABISELECT(2040,1324), "S7682C7");
    /*is_ambiguous_... S7682C7::S7682C9 */ AMB_check_base_class_offset(lv, (S7682C9*), 0, "S7682C7");
    /*is_ambiguous_... S7682C13::S7682C3 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C13*), ABISELECT(2384,1536), "S7682C7");
    /*is_ambiguous_... S7682C7::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C2*)(S7682C12*), ABISELECT(2384,1536), "S7682C7");
    /*is_ambiguous_... S7682C10::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C2*)(S7682C12*)(S7682C10*), ABISELECT(2384,1536), "S7682C7");
    /*is_ambiguous_... S7682C15::S7682C3 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C15*)(S7682C10*), ABISELECT(2384,1536), "S7682C7");
    /*is_ambiguous_... S7682C7::S7682C4 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C4*), ABISELECT(2544,1644), "S7682C7");
    check_base_class_offset(lv, (S7682C4*)(S7682C13*), ABISELECT(2544,1644), "S7682C7");
    /*is_ambiguous_... S7682C7::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C13*)(S7682C12*), ABISELECT(2352,1524), "S7682C7");
    /*is_ambiguous_... S7682C10::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C13*)(S7682C12*)(S7682C10*), ABISELECT(2352,1524), "S7682C7");
    check_base_class_offset(lv, (S7682C13*)(S7682C15*)(S7682C10*), ABISELECT(2352,1524), "S7682C7");
    /*is_ambiguous_... S7682C7::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C4*)(S7682C2*)(S7682C12*), ABISELECT(2064,1332), "S7682C7");
    /*is_ambiguous_... S7682C7::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C4*)(S7682C2*)(S7682C12*), ABISELECT(2064,1332), "S7682C7");
    /*is_ambiguous_... S7682C7::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C2*)(S7682C12*), ABISELECT(2064,1332), "S7682C7");
    check_base_class_offset(lv, (S7682C12*)(S7682C11*), ABISELECT(2064,1332), "S7682C7");
    check_base_class_offset(lv, (S7682C11*)(S7682C10*), ABISELECT(2048,1328), "S7682C7");
    /*is_ambiguous_... S7682C10::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C4*)(S7682C2*)(S7682C12*)(S7682C10*), ABISELECT(1472,928), "S7682C7");
    /*is_ambiguous_... S7682C10::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C4*)(S7682C2*)(S7682C12*)(S7682C10*), ABISELECT(1472,928), "S7682C7");
    /*is_ambiguous_... S7682C10::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C2*)(S7682C12*)(S7682C10*), ABISELECT(1472,928), "S7682C7");
    /*is_ambiguous_... S7682C10::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C12*)(S7682C10*), ABISELECT(1472,928), "S7682C7");
    check_base_class_offset(lv, (S7682C9*)(S7682C15*)(S7682C10*), ABISELECT(2752,1776), "S7682C7");
    /*is_ambiguous_... S7682C15::S7682C4 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C4*)(S7682C15*)(S7682C10*), ABISELECT(1760,1120), "S7682C7");
    /*is_ambiguous_... S7682C15::S7682C4 */ AMB_check_base_class_offset(lv, (S7682C4*)(S7682C15*)(S7682C10*), ABISELECT(1760,1120), "S7682C7");
    check_base_class_offset(lv, (S7682C15*)(S7682C10*), ABISELECT(1760,1120), "S7682C7");
    check_base_class_offset(lv, (S7682C10*), ABISELECT(1472,928), "S7682C7");
    check_field_offset(lv, s7682c7f0, ABISELECT(2016,1300), "S7682C7.s7682c7f0");
    set_bf_and_test(lv, s7682c7f1, ABISELECT(2036,1320), 0, 15, 1, "S7682C7");
    set_bf_and_test(lv, s7682c7f1, ABISELECT(2036,1320), 0, 15, hide_sll(1LL<<14), "S7682C7");
    test_class_info(&lv, &cd_S7682C7);
    dp->~S7682C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7682C7(Test_S7682C7, "S7682C7", ABISELECT(4224,2704));

#else // __cplusplus

extern void _ZN7S7682C7C1Ev();
extern void _ZN7S7682C7D2Ev();
Name_Map name_map_S7682C7[] = {
  NSPAIR(_ZN7S7682C7C1Ev),
  NSPAIR(_ZN7S7682C7D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7682C8_nt;
extern VTBL_ENTRY _ZTI10S7682C8_nt[];
extern  VTBL_ENTRY _ZTV10S7682C8_nt[];
extern Class_Descriptor cd_S7682C9;
extern VTBL_ENTRY _ZTI7S7682C9[];
extern  VTBL_ENTRY _ZTV7S7682C9[];
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C4;
extern VTBL_ENTRY _ZTI7S7682C4[];
extern  VTBL_ENTRY _ZTV7S7682C4[];
extern Class_Descriptor cd_S7682C13;
extern VTBL_ENTRY _ZTI8S7682C13[];
extern  VTBL_ENTRY _ZTV8S7682C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7682C13[];
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C4;
extern VTBL_ENTRY _ZTI7S7682C4[];
extern  VTBL_ENTRY _ZTV7S7682C4[];
extern Class_Descriptor cd_S7682C2;
extern VTBL_ENTRY _ZTI7S7682C2[];
extern  VTBL_ENTRY _ZTV7S7682C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7682C2[];
extern Class_Descriptor cd_S7682C12;
extern VTBL_ENTRY _ZTI8S7682C12[];
extern  VTBL_ENTRY _ZTV8S7682C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7682C12[];
extern Class_Descriptor cd_S7682C11;
extern VTBL_ENTRY _ZTI8S7682C11[];
extern  VTBL_ENTRY _ZTV8S7682C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7682C11[];
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C4;
extern VTBL_ENTRY _ZTI7S7682C4[];
extern  VTBL_ENTRY _ZTV7S7682C4[];
extern Class_Descriptor cd_S7682C2;
extern VTBL_ENTRY _ZTI7S7682C2[];
extern  VTBL_ENTRY _ZTV7S7682C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7682C2[];
extern Class_Descriptor cd_S7682C12;
extern VTBL_ENTRY _ZTI8S7682C12[];
extern  VTBL_ENTRY _ZTV8S7682C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7682C12[];
extern Class_Descriptor cd_S7682C9;
extern VTBL_ENTRY _ZTI7S7682C9[];
extern  VTBL_ENTRY _ZTV7S7682C9[];
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C4;
extern VTBL_ENTRY _ZTI7S7682C4[];
extern  VTBL_ENTRY _ZTV7S7682C4[];
extern Class_Descriptor cd_S7682C15;
extern VTBL_ENTRY _ZTI8S7682C15[];
extern  VTBL_ENTRY _ZTV8S7682C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7682C15[];
extern Class_Descriptor cd_S7682C10;
extern VTBL_ENTRY _ZTI8S7682C10[];
extern  VTBL_ENTRY _ZTV8S7682C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7682C10[];
static Base_Class bases_S7682C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7682C8_nt,    ABISELECT(2040,1324), //bcp->offset
    73, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7682C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7682C3,    ABISELECT(2384,1536), //bcp->offset
    145, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S7682C3,    ABISELECT(2544,1644), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7682C4,    ABISELECT(2544,1644), //bcp->offset
    155, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S7682C13,    ABISELECT(2352,1524), //bcp->offset
    131, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    42, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S7682C3,    ABISELECT(2064,1332), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S7682C4,    ABISELECT(2064,1332), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7682C2,    ABISELECT(2064,1332), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    37, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S7682C12,    ABISELECT(2064,1332), //bcp->offset
    96, //bcp->virtual_function_table_offset
    20, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    36, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S7682C11,    ABISELECT(2048,1328), //bcp->offset
    83, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    31, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    19, //immediately_derived
  0, 1},
  {&cd_S7682C3,    ABISELECT(1472,928), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S7682C4,    ABISELECT(1472,928), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S7682C2,    ABISELECT(1472,928), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S7682C12,    ABISELECT(1472,928), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S7682C9,    ABISELECT(2752,1776), //bcp->offset
    171, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    18, //immediately_derived
  0, 1},
  {&cd_S7682C3,    ABISELECT(1760,1120), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S7682C4,    ABISELECT(1760,1120), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S7682C15,    ABISELECT(1760,1120), //bcp->offset
    54, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S7682C10,    ABISELECT(1472,928), //bcp->offset
    20, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S7682C7[];
extern void _ZN7S7682C93v33Ev();
extern void _ZN7S7682C93v34Ev();
extern void _ZN7S7682C93v35Ev();
extern void _ZN7S7682C93v36Ev();
extern void _ZN7S7682C93v37Ev();
extern void _ZN7S7682C93v38Ev();
extern void _ZN7S7682C93v39Ev();
extern void _ZN7S7682C93v40Ev();
extern void _ZN7S7682C93v41Ev();
extern void _ZN7S7682C7D1Ev();
extern void _ZN7S7682C7D0Ev();
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
extern void _ZN8S7682C123v47Ev();
extern void _ZN8S7682C123v48Ev();
extern void _ZN8S7682C123v49Ev();
extern void _ZN8S7682C123v50Ev();
extern void ABISELECT(_ZThn1472_N7S7682C7D1Ev,_ZThn928_N7S7682C7D1Ev)();
extern void ABISELECT(_ZThn1472_N7S7682C7D0Ev,_ZThn928_N7S7682C7D0Ev)();
extern void _ZN8S7682C103v57Ev();
extern void _ZN8S7682C103v58Ev();
extern void _ZN8S7682C103v59Ev();
extern void _ZN8S7682C103v60Ev();
extern void _ZN8S7682C103v61Ev();
extern void _ZN8S7682C103v62Ev();
extern void _ZN8S7682C103v63Ev();
extern void _ZN8S7682C103v64Ev();
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void ABISELECT(_ZThn1760_N7S7682C7D1Ev,_ZThn1120_N7S7682C7D1Ev)();
extern void ABISELECT(_ZThn1760_N7S7682C7D0Ev,_ZThn1120_N7S7682C7D0Ev)();
extern void _ZN8S7682C153v53Ev();
extern void _ZN8S7682C153v54Ev();
extern void _ZN8S7682C153v55Ev();
extern void _ZN8S7682C153v56Ev();
extern void _ZN10S7682C8_nt3v29Ev();
extern void _ZN10S7682C8_nt3v30Ev();
extern void _ZN10S7682C8_nt3v31Ev();
extern void _ZN10S7682C8_nt3v32Ev();
extern void ABISELECT(_ZTv0_n56_N7S7682C7D1Ev,_ZTv0_n28_N7S7682C7D1Ev)();
extern void ABISELECT(_ZThn2048_N7S7682C7D1Ev,_ZThn1328_N7S7682C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N7S7682C7D0Ev,_ZTv0_n28_N7S7682C7D0Ev)();
extern void ABISELECT(_ZThn2048_N7S7682C7D0Ev,_ZThn1328_N7S7682C7D0Ev)() __attribute__((weak));
extern void _ZN8S7682C113v51Ev();
extern void _ZN8S7682C113v52Ev();
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
extern void _ZN8S7682C123v47Ev();
extern void _ZN8S7682C123v48Ev();
extern void _ZN8S7682C123v49Ev();
extern void _ZN8S7682C123v50Ev();
extern void _ZN8S7682C133v42Ev();
extern void _ZN8S7682C133v43Ev();
extern void _ZN8S7682C133v44Ev();
extern void _ZN8S7682C133v45Ev();
extern void _ZN8S7682C133v46Ev();
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C93v33Ev();
extern void _ZN7S7682C93v34Ev();
extern void _ZN7S7682C93v35Ev();
extern void _ZN7S7682C93v36Ev();
extern void _ZN7S7682C93v37Ev();
extern void _ZN7S7682C93v38Ev();
extern void _ZN7S7682C93v39Ev();
extern void _ZN7S7682C93v40Ev();
extern void _ZN7S7682C93v41Ev();
static  VTBL_ENTRY vtc_S7682C7[] = {
  ABISELECT(2752,1776),
  ABISELECT(2544,1644),
  ABISELECT(2384,1536),
  ABISELECT(2352,1524),
  ABISELECT(2064,1332),
  ABISELECT(2048,1328),
  ABISELECT(2040,1324),
  0,
  (VTBL_ENTRY)&(_ZTI7S7682C7[0]),
  (VTBL_ENTRY)&_ZN7S7682C93v33Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v34Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v35Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v36Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v37Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v38Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v39Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v40Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v41Ev,
  (VTBL_ENTRY)&_ZN7S7682C7D1Ev,
  (VTBL_ENTRY)&_ZN7S7682C7D0Ev,
  ABISELECT(1280,848),
  ABISELECT(592,404),
  ABISELECT(576,400),
  ABISELECT(568,396),
  ABISELECT(1072,716),
  ABISELECT(880,596),
  ABISELECT(912,608),
  ABISELECT(-1472,-928),
  (VTBL_ENTRY)&(_ZTI7S7682C7[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v47Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v48Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v49Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v50Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn1472_N7S7682C7D1Ev,_ZThn928_N7S7682C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1472_N7S7682C7D0Ev,_ZThn928_N7S7682C7D0Ev),
  (VTBL_ENTRY)&_ZN8S7682C103v57Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v58Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v59Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v60Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v61Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v62Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v63Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v64Ev,
  ABISELECT(992,656),
  ABISELECT(784,524),
  ABISELECT(592,404),
  ABISELECT(624,416),
  ABISELECT(-1760,-1120),
  (VTBL_ENTRY)&(_ZTI7S7682C7[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn1760_N7S7682C7D1Ev,_ZThn1120_N7S7682C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1760_N7S7682C7D0Ev,_ZThn1120_N7S7682C7D0Ev),
  (VTBL_ENTRY)&_ZN8S7682C153v53Ev,
  (VTBL_ENTRY)&_ZN8S7682C153v54Ev,
  (VTBL_ENTRY)&_ZN8S7682C153v55Ev,
  (VTBL_ENTRY)&_ZN8S7682C153v56Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-2040,-1324),
  (VTBL_ENTRY)&(_ZTI7S7682C7[0]),
  (VTBL_ENTRY)&_ZN10S7682C8_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S7682C8_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S7682C8_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S7682C8_nt3v32Ev,
  0,
  0,
  ABISELECT(-2048,-1328),
  ABISELECT(496,316),
  ABISELECT(336,208),
  ABISELECT(304,196),
  ABISELECT(16,4),
  ABISELECT(-2048,-1328),
  (VTBL_ENTRY)&(_ZTI7S7682C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7682C7D1Ev,_ZTv0_n28_N7S7682C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7682C7D0Ev,_ZTv0_n28_N7S7682C7D0Ev),
  (VTBL_ENTRY)&_ZN8S7682C113v51Ev,
  (VTBL_ENTRY)&_ZN8S7682C113v52Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(480,312),
  ABISELECT(288,192),
  ABISELECT(320,204),
  ABISELECT(-2064,-1332),
  (VTBL_ENTRY)&(_ZTI7S7682C7[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v47Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v48Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v49Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v50Ev,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(192,120),
  ABISELECT(32,12),
  ABISELECT(-2352,-1524),
  (VTBL_ENTRY)&(_ZTI7S7682C7[0]),
  (VTBL_ENTRY)&_ZN8S7682C133v42Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v43Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v44Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v45Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v46Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-2384,-1536),
  (VTBL_ENTRY)&(_ZTI7S7682C7[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-2544,-1644),
  (VTBL_ENTRY)&(_ZTI7S7682C7[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-2752,-1776),
  (VTBL_ENTRY)&(_ZTI7S7682C7[0]),
  (VTBL_ENTRY)&_ZN7S7682C93v33Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v34Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v35Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v36Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v37Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v38Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v39Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v40Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v41Ev,
};
extern VTBL_ENTRY _ZTV7S7682C7[];
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
extern void _ZN8S7682C123v47Ev();
extern void _ZN8S7682C123v48Ev();
extern void _ZN8S7682C123v49Ev();
extern void _ZN8S7682C123v50Ev();
extern void _ZN8S7682C10D1Ev();
extern void _ZN8S7682C10D0Ev();
extern void _ZN8S7682C103v57Ev();
extern void _ZN8S7682C103v58Ev();
extern void _ZN8S7682C103v59Ev();
extern void _ZN8S7682C103v60Ev();
extern void _ZN8S7682C103v61Ev();
extern void _ZN8S7682C103v62Ev();
extern void _ZN8S7682C103v63Ev();
extern void _ZN8S7682C103v64Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C10__7S7682C7[] = {
  ABISELECT(1280,848),
  ABISELECT(592,404),
  ABISELECT(576,400),
  ABISELECT(568,396),
  ABISELECT(1072,716),
  ABISELECT(880,596),
  ABISELECT(912,608),
  0,
  (VTBL_ENTRY)&(_ZTI8S7682C10[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v47Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v48Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v49Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v50Ev,
  (VTBL_ENTRY)&_ZN8S7682C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7682C10D0Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v57Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v58Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v59Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v60Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v61Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v62Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v63Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v64Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
extern void _ZN8S7682C123v47Ev();
extern void _ZN8S7682C123v48Ev();
extern void _ZN8S7682C123v49Ev();
extern void _ZN8S7682C123v50Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C128S7682C10__A1__7S7682C7[] = {
  ABISELECT(1072,716),
  ABISELECT(880,596),
  ABISELECT(912,608),
  0,
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v47Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v48Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v49Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v50Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C28S7682C128S7682C10__A1__7S7682C7[] = {
  ABISELECT(912,608),
  0,
  (VTBL_ENTRY)&(_ZTI7S7682C2[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__7S7682C28S7682C128S7682C10__A1__7S7682C7[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-912,-608),
  (VTBL_ENTRY)&(_ZTI7S7682C2[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern void _ZN8S7682C133v42Ev();
extern void _ZN8S7682C133v43Ev();
extern void _ZN8S7682C133v44Ev();
extern void _ZN8S7682C133v45Ev();
extern void _ZN8S7682C133v46Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C13__8S7682C128S7682C10__A1__7S7682C7[] = {
  0,
  0,
  0,
  0,
  0,
  ABISELECT(192,120),
  ABISELECT(32,12),
  ABISELECT(-880,-596),
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN8S7682C133v42Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v43Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v44Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v45Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v46Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__8S7682C128S7682C10__A1__7S7682C7[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-912,-608),
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C4__8S7682C128S7682C10__A1__7S7682C7[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-1072,-716),
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN8S7682C15D1Ev();
extern void _ZN8S7682C15D0Ev();
extern void _ZN8S7682C153v53Ev();
extern void _ZN8S7682C153v54Ev();
extern void _ZN8S7682C153v55Ev();
extern void _ZN8S7682C153v56Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C158S7682C10__7S7682C7[] = {
  ABISELECT(992,656),
  ABISELECT(784,524),
  ABISELECT(592,404),
  ABISELECT(624,416),
  0,
  (VTBL_ENTRY)&(_ZTI8S7682C15[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN8S7682C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7682C15D0Ev,
  (VTBL_ENTRY)&_ZN8S7682C153v53Ev,
  (VTBL_ENTRY)&_ZN8S7682C153v54Ev,
  (VTBL_ENTRY)&_ZN8S7682C153v55Ev,
  (VTBL_ENTRY)&_ZN8S7682C153v56Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__8S7682C158S7682C10__7S7682C7[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-624,-416),
  (VTBL_ENTRY)&(_ZTI8S7682C15[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern void _ZN8S7682C133v42Ev();
extern void _ZN8S7682C133v43Ev();
extern void _ZN8S7682C133v44Ev();
extern void _ZN8S7682C133v45Ev();
extern void _ZN8S7682C133v46Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C13__8S7682C158S7682C10__7S7682C7[] = {
  0,
  0,
  0,
  0,
  0,
  ABISELECT(192,120),
  ABISELECT(32,12),
  ABISELECT(-592,-404),
  (VTBL_ENTRY)&(_ZTI8S7682C15[0]),
  (VTBL_ENTRY)&_ZN8S7682C133v42Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v43Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v44Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v45Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v46Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C4__8S7682C158S7682C10__7S7682C7[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-784,-524),
  (VTBL_ENTRY)&(_ZTI8S7682C15[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
};
extern void _ZN7S7682C93v33Ev();
extern void _ZN7S7682C93v34Ev();
extern void _ZN7S7682C93v35Ev();
extern void _ZN7S7682C93v36Ev();
extern void _ZN7S7682C93v37Ev();
extern void _ZN7S7682C93v38Ev();
extern void _ZN7S7682C93v39Ev();
extern void _ZN7S7682C93v40Ev();
extern void _ZN7S7682C93v41Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C9__8S7682C158S7682C10__7S7682C7[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-992,-656),
  (VTBL_ENTRY)&(_ZTI8S7682C15[0]),
  (VTBL_ENTRY)&_ZN7S7682C93v33Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v34Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v35Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v36Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v37Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v38Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v39Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v40Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v41Ev,
};
extern void _ZN10S7682C8_nt3v29Ev();
extern void _ZN10S7682C8_nt3v30Ev();
extern void _ZN10S7682C8_nt3v31Ev();
extern void _ZN10S7682C8_nt3v32Ev();
static  VTBL_ENTRY _tg__ZTV10S7682C8_nt__8S7682C10__7S7682C7[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-568,-396),
  (VTBL_ENTRY)&(_ZTI8S7682C10[0]),
  (VTBL_ENTRY)&_ZN10S7682C8_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S7682C8_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S7682C8_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S7682C8_nt3v32Ev,
};
extern void ABISELECT(_ZTv0_n56_N8S7682C10D1Ev,_ZTv0_n28_N8S7682C10D1Ev)();
extern void ABISELECT(_ZThn576_N8S7682C10D1Ev,_ZThn400_N8S7682C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7682C10D0Ev,_ZTv0_n28_N8S7682C10D0Ev)();
extern void ABISELECT(_ZThn576_N8S7682C10D0Ev,_ZThn400_N8S7682C10D0Ev)() __attribute__((weak));
extern void _ZN8S7682C113v51Ev();
extern void _ZN8S7682C113v52Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C11__8S7682C10__7S7682C7[] = {
  0,
  0,
  ABISELECT(-576,-400),
  ABISELECT(496,316),
  ABISELECT(336,208),
  ABISELECT(304,196),
  ABISELECT(16,4),
  ABISELECT(-576,-400),
  (VTBL_ENTRY)&(_ZTI8S7682C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7682C10D1Ev,_ZTv0_n28_N8S7682C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7682C10D0Ev,_ZTv0_n28_N8S7682C10D0Ev),
  (VTBL_ENTRY)&_ZN8S7682C113v51Ev,
  (VTBL_ENTRY)&_ZN8S7682C113v52Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
extern void _ZN8S7682C123v47Ev();
extern void _ZN8S7682C123v48Ev();
extern void _ZN8S7682C123v49Ev();
extern void _ZN8S7682C123v50Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C12__8S7682C10__7S7682C7[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(480,312),
  ABISELECT(288,192),
  ABISELECT(320,204),
  ABISELECT(-592,-404),
  (VTBL_ENTRY)&(_ZTI8S7682C10[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v47Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v48Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v49Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v50Ev,
};
extern void _ZN8S7682C133v42Ev();
extern void _ZN8S7682C133v43Ev();
extern void _ZN8S7682C133v44Ev();
extern void _ZN8S7682C133v45Ev();
extern void _ZN8S7682C133v46Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C13__8S7682C10__7S7682C7[] = {
  0,
  0,
  0,
  0,
  0,
  ABISELECT(192,120),
  ABISELECT(32,12),
  ABISELECT(-880,-596),
  (VTBL_ENTRY)&(_ZTI8S7682C10[0]),
  (VTBL_ENTRY)&_ZN8S7682C133v42Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v43Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v44Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v45Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v46Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__8S7682C10__7S7682C7[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-912,-608),
  (VTBL_ENTRY)&(_ZTI8S7682C10[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C4__8S7682C10__7S7682C7[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-1072,-716),
  (VTBL_ENTRY)&(_ZTI8S7682C10[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void ABISELECT(_ZThn288_N8S7682C10D1Ev,_ZThn192_N8S7682C10D1Ev)();
extern void ABISELECT(_ZThn288_N8S7682C10D0Ev,_ZThn192_N8S7682C10D0Ev)();
extern void _ZN8S7682C153v53Ev();
extern void _ZN8S7682C153v54Ev();
extern void _ZN8S7682C153v55Ev();
extern void _ZN8S7682C153v56Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C15__8S7682C10__7S7682C7[] = {
  ABISELECT(992,656),
  ABISELECT(784,524),
  ABISELECT(592,404),
  ABISELECT(624,416),
  ABISELECT(-288,-192),
  (VTBL_ENTRY)&(_ZTI8S7682C10[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn288_N8S7682C10D1Ev,_ZThn192_N8S7682C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn288_N8S7682C10D0Ev,_ZThn192_N8S7682C10D0Ev),
  (VTBL_ENTRY)&_ZN8S7682C153v53Ev,
  (VTBL_ENTRY)&_ZN8S7682C153v54Ev,
  (VTBL_ENTRY)&_ZN8S7682C153v55Ev,
  (VTBL_ENTRY)&_ZN8S7682C153v56Ev,
};
extern void _ZN7S7682C93v33Ev();
extern void _ZN7S7682C93v34Ev();
extern void _ZN7S7682C93v35Ev();
extern void _ZN7S7682C93v36Ev();
extern void _ZN7S7682C93v37Ev();
extern void _ZN7S7682C93v38Ev();
extern void _ZN7S7682C93v39Ev();
extern void _ZN7S7682C93v40Ev();
extern void _ZN7S7682C93v41Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C9__8S7682C10__7S7682C7[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-1280,-848),
  (VTBL_ENTRY)&(_ZTI8S7682C10[0]),
  (VTBL_ENTRY)&_ZN7S7682C93v33Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v34Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v35Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v36Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v37Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v38Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v39Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v40Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v41Ev,
};
extern void _ZN8S7682C11D1Ev();
extern void _ZN8S7682C11D0Ev();
extern void _ZN8S7682C113v51Ev();
extern void _ZN8S7682C113v52Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C11__7S7682C7[] = {
  ABISELECT(496,316),
  ABISELECT(336,208),
  ABISELECT(304,196),
  ABISELECT(16,4),
  0,
  (VTBL_ENTRY)&(_ZTI8S7682C11[0]),
  (VTBL_ENTRY)&_ZN8S7682C11D1Ev,
  (VTBL_ENTRY)&_ZN8S7682C11D0Ev,
  (VTBL_ENTRY)&_ZN8S7682C113v51Ev,
  (VTBL_ENTRY)&_ZN8S7682C113v52Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
extern void _ZN8S7682C123v47Ev();
extern void _ZN8S7682C123v48Ev();
extern void _ZN8S7682C123v49Ev();
extern void _ZN8S7682C123v50Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C12__8S7682C11__7S7682C7[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(480,312),
  ABISELECT(288,192),
  ABISELECT(320,204),
  ABISELECT(-16,-4),
  (VTBL_ENTRY)&(_ZTI8S7682C11[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v47Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v48Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v49Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v50Ev,
};
extern void _ZN8S7682C133v42Ev();
extern void _ZN8S7682C133v43Ev();
extern void _ZN8S7682C133v44Ev();
extern void _ZN8S7682C133v45Ev();
extern void _ZN8S7682C133v46Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C13__8S7682C11__7S7682C7[] = {
  0,
  0,
  0,
  0,
  0,
  ABISELECT(192,120),
  ABISELECT(32,12),
  ABISELECT(-304,-196),
  (VTBL_ENTRY)&(_ZTI8S7682C11[0]),
  (VTBL_ENTRY)&_ZN8S7682C133v42Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v43Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v44Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v45Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v46Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__8S7682C11__7S7682C7[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-336,-208),
  (VTBL_ENTRY)&(_ZTI8S7682C11[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C4__8S7682C11__7S7682C7[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-496,-316),
  (VTBL_ENTRY)&(_ZTI8S7682C11[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
extern void _ZN8S7682C123v47Ev();
extern void _ZN8S7682C123v48Ev();
extern void _ZN8S7682C123v49Ev();
extern void _ZN8S7682C123v50Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C12__7S7682C7[] = {
  ABISELECT(480,312),
  ABISELECT(288,192),
  ABISELECT(320,204),
  0,
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v47Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v48Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v49Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v50Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C28S7682C12__7S7682C7[] = {
  ABISELECT(320,204),
  0,
  (VTBL_ENTRY)&(_ZTI7S7682C2[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__7S7682C28S7682C12__7S7682C7[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-320,-204),
  (VTBL_ENTRY)&(_ZTI7S7682C2[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern void _ZN8S7682C133v42Ev();
extern void _ZN8S7682C133v43Ev();
extern void _ZN8S7682C133v44Ev();
extern void _ZN8S7682C133v45Ev();
extern void _ZN8S7682C133v46Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C13__8S7682C12__7S7682C7[] = {
  0,
  0,
  0,
  0,
  0,
  ABISELECT(192,120),
  ABISELECT(32,12),
  ABISELECT(-288,-192),
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN8S7682C133v42Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v43Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v44Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v45Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v46Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__8S7682C12__7S7682C7[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-320,-204),
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C4__8S7682C12__7S7682C7[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-480,-312),
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
};
extern void _ZN8S7682C133v42Ev();
extern void _ZN8S7682C133v43Ev();
extern void _ZN8S7682C133v44Ev();
extern void _ZN8S7682C133v45Ev();
extern void _ZN8S7682C133v46Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C13__7S7682C7[] = {
  ABISELECT(192,120),
  ABISELECT(32,12),
  0,
  (VTBL_ENTRY)&(_ZTI8S7682C13[0]),
  (VTBL_ENTRY)&_ZN8S7682C133v42Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v43Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v44Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v45Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v46Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__8S7682C13__7S7682C7[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-32,-12),
  (VTBL_ENTRY)&(_ZTI8S7682C13[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C4__8S7682C13__7S7682C7[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-192,-120),
  (VTBL_ENTRY)&(_ZTI8S7682C13[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
};
static  VTT_ENTRY vtt_S7682C7[] = {
  {&(_ZTV7S7682C7[9]),  9,191},
  {&(_tg__ZTV8S7682C10__7S7682C7[9]),  9,34},
  {&(_tg__ZTV8S7682C128S7682C10__A1__7S7682C7[5]),  5,20},
  {&(_tg__ZTV7S7682C28S7682C128S7682C10__A1__7S7682C7[3]),  3,14},
  {&(_tg__ZTV7S7682C3__7S7682C28S7682C128S7682C10__A1__7S7682C7[6]),  6,10},
  {&(_tg__ZTV8S7682C13__8S7682C128S7682C10__A1__7S7682C7[9]),  9,14},
  {&(_tg__ZTV7S7682C3__8S7682C128S7682C10__A1__7S7682C7[6]),  6,10},
  {&(_tg__ZTV7S7682C4__8S7682C128S7682C10__A1__7S7682C7[9]),  9,16},
  {&(_tg__ZTV8S7682C158S7682C10__7S7682C7[6]),  6,19},
  {&(_tg__ZTV7S7682C3__8S7682C158S7682C10__7S7682C7[6]),  6,10},
  {&(_tg__ZTV8S7682C13__8S7682C158S7682C10__7S7682C7[9]),  9,14},
  {&(_tg__ZTV7S7682C4__8S7682C158S7682C10__7S7682C7[9]),  9,16},
  {&(_tg__ZTV7S7682C9__8S7682C158S7682C10__7S7682C7[11]),  11,20},
  {&(_tg__ZTV10S7682C8_nt__8S7682C10__7S7682C7[6]),  6,10},
  {&(_tg__ZTV8S7682C11__8S7682C10__7S7682C7[9]),  9,13},
  {&(_tg__ZTV8S7682C12__8S7682C10__7S7682C7[20]),  20,35},
  {&(_tg__ZTV8S7682C13__8S7682C10__7S7682C7[9]),  9,14},
  {&(_tg__ZTV7S7682C3__8S7682C10__7S7682C7[6]),  6,10},
  {&(_tg__ZTV7S7682C4__8S7682C10__7S7682C7[9]),  9,16},
  {&(_tg__ZTV8S7682C15__8S7682C10__7S7682C7[6]),  6,19},
  {&(_tg__ZTV7S7682C9__8S7682C10__7S7682C7[11]),  11,20},
  {&(_ZTV7S7682C7[79]),  79,191},
  {&(_ZTV7S7682C7[29]),  29,191},
  {&(_ZTV7S7682C7[92]),  92,191},
  {&(_ZTV7S7682C7[116]),  116,191},
  {&(_ZTV7S7682C7[140]),  140,191},
  {&(_ZTV7S7682C7[151]),  151,191},
  {&(_ZTV7S7682C7[164]),  164,191},
  {&(_ZTV7S7682C7[60]),  60,191},
  {&(_ZTV7S7682C7[182]),  182,191},
  {&(_tg__ZTV8S7682C11__7S7682C7[6]),  6,10},
  {&(_tg__ZTV8S7682C12__8S7682C11__7S7682C7[20]),  20,35},
  {&(_tg__ZTV8S7682C13__8S7682C11__7S7682C7[9]),  9,14},
  {&(_tg__ZTV7S7682C3__8S7682C11__7S7682C7[6]),  6,10},
  {&(_tg__ZTV7S7682C4__8S7682C11__7S7682C7[9]),  9,16},
  {&(_tg__ZTV8S7682C12__7S7682C7[5]),  5,20},
  {&(_tg__ZTV7S7682C28S7682C12__7S7682C7[3]),  3,14},
  {&(_tg__ZTV7S7682C3__7S7682C28S7682C12__7S7682C7[6]),  6,10},
  {&(_tg__ZTV8S7682C13__8S7682C12__7S7682C7[9]),  9,14},
  {&(_tg__ZTV7S7682C3__8S7682C12__7S7682C7[6]),  6,10},
  {&(_tg__ZTV7S7682C4__8S7682C12__7S7682C7[9]),  9,16},
  {&(_tg__ZTV8S7682C13__7S7682C7[4]),  4,9},
  {&(_tg__ZTV7S7682C3__8S7682C13__7S7682C7[6]),  6,10},
  {&(_tg__ZTV7S7682C4__8S7682C13__7S7682C7[9]),  9,16},
};
extern VTBL_ENTRY _ZTI7S7682C7[];
extern  VTBL_ENTRY _ZTV7S7682C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7682C7[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7682C10D0Ev,_ZTv0_n28_N8S7682C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn576_N8S7682C10D0Ev,_ZThn400_N8S7682C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7682C10D1Ev,_ZTv0_n28_N8S7682C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn576_N8S7682C10D1Ev,_ZThn400_N8S7682C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7682C7D0Ev,_ZTv0_n28_N7S7682C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2048_N7S7682C7D0Ev,_ZThn1328_N7S7682C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7682C7D1Ev,_ZTv0_n28_N7S7682C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2048_N7S7682C7D1Ev,_ZThn1328_N7S7682C7D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7682C7 = {  "S7682C7", // class name
  bases_S7682C7, 20,
  &(vtc_S7682C7[0]), // expected_vtbl_contents
  &(vtt_S7682C7[0]), // expected_vtt_contents
  ABISELECT(4224,2704), // object size
  NSPAIRA(_ZTI7S7682C7),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S7682C7),191, //virtual function table var
  9, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7682C7),44, //virtual table table var
  20, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7682C16  : S7682C8_nt , virtual S7682C3 , virtual S7682C13 , virtual S7682C10 , S7682C6 {
  void *s7682c16f0[2];
  virtual  ~S7682C16(); // _ZN8S7682C16D2Ev
  virtual void  v65(); // _ZN8S7682C163v65Ev
  virtual void  v66(); // _ZN8S7682C163v66Ev
  virtual void  v67(); // _ZN8S7682C163v67Ev
  virtual void  v68(); // _ZN8S7682C163v68Ev
  virtual void  v69(); // _ZN8S7682C163v69Ev
  virtual void  v70(); // _ZN8S7682C163v70Ev
  virtual void  v71(); // _ZN8S7682C163v71Ev
  S7682C16(); // tgen
};
//SIG(-1 S7682C16) C1{ BC2{ v8 v9 v10 v11} VBC3{ v12 v13 v14 v15 Fs:13 Fp FD[8]} VBC4{ VBC3 VBC5{ BC3 v16 v17 v18 Fp[6]} v19 v20 v21 v22 v23 Fp[2]} VBC6{ VBC2 VBC7{ VBC8{ VBC4 BC9{ VBC3 BC5 v24 v25 v26 v27 Fp} v28 v29 v30 v31 FL[5] FC10{} FD} vd v32 v33} BC8 BC11{ VBC3 VBC4 VBC12{ v34 v35 v36 v37 v38 v39 v40 v41 v42 FC5[7]} BC5 vd v43 v44 v45 v46 Fi} vd v47 v48 v49 v50 v51 v52 v53 v54 Fi[8] Fc FL} BC13{ VBC9 vd v55 v56 v57 v58} vd v1 v2 v3 v4 v5 v6 v7 Fp[2]}


 S7682C16 ::~S7682C16(){ note_dtor("S7682C16", this);}
void  S7682C16 ::v65(){vfunc_called(this, "_ZN8S7682C163v65Ev");}
void  S7682C16 ::v66(){vfunc_called(this, "_ZN8S7682C163v66Ev");}
void  S7682C16 ::v67(){vfunc_called(this, "_ZN8S7682C163v67Ev");}
void  S7682C16 ::v68(){vfunc_called(this, "_ZN8S7682C163v68Ev");}
void  S7682C16 ::v69(){vfunc_called(this, "_ZN8S7682C163v69Ev");}
void  S7682C16 ::v70(){vfunc_called(this, "_ZN8S7682C163v70Ev");}
void  S7682C16 ::v71(){vfunc_called(this, "_ZN8S7682C163v71Ev");}
S7682C16 ::S7682C16(){ note_ctor("S7682C16", this);} // tgen

static void Test_S7682C16()
{
  extern Class_Descriptor cd_S7682C16;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(187,477)];
    init_test(&cd_S7682C16, buf);
    S7682C16 *dp, &lv = *(dp=new (buf) S7682C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2976,1904), "sizeof(S7682C16)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7682C16)");
    /*is_ambiguous_... S7682C16::S7682C8_nt */ AMB_check_base_class_offset(lv, (S7682C8_nt*), 0, "S7682C16");
    /*is_ambiguous_... S7682C16::S7682C3 */ AMB_check_base_class_offset(lv, (S7682C3*), ABISELECT(32,16), "S7682C16");
    /*is_ambiguous_... S7682C13::S7682C3 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C13*), ABISELECT(32,16), "S7682C16");
    /*is_ambiguous_... S7682C16::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C2*)(S7682C12*), ABISELECT(32,16), "S7682C16");
    /*is_ambiguous_... S7682C10::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C2*)(S7682C12*)(S7682C10*), ABISELECT(32,16), "S7682C16");
    /*is_ambiguous_... S7682C15::S7682C3 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C15*)(S7682C10*), ABISELECT(32,16), "S7682C16");
    /*is_ambiguous_... S7682C16::S7682C2 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C2*), ABISELECT(32,16), "S7682C16");
    /*is_ambiguous_... S7682C16::S7682C4 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C4*), ABISELECT(224,136), "S7682C16");
    check_base_class_offset(lv, (S7682C4*)(S7682C13*), ABISELECT(224,136), "S7682C16");
    check_base_class_offset(lv, (S7682C13*), ABISELECT(192,124), "S7682C16");
    /*is_ambiguous_... S7682C16::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C13*)(S7682C12*), ABISELECT(192,124), "S7682C16");
    /*is_ambiguous_... S7682C10::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C13*)(S7682C12*)(S7682C10*), ABISELECT(192,124), "S7682C16");
    check_base_class_offset(lv, (S7682C13*)(S7682C15*)(S7682C10*), ABISELECT(192,124), "S7682C16");
    check_base_class_offset(lv, (S7682C8_nt*)(S7682C10*), ABISELECT(976,640), "S7682C16");
    /*is_ambiguous_... S7682C16::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C4*)(S7682C2*)(S7682C12*), ABISELECT(992,648), "S7682C16");
    /*is_ambiguous_... S7682C16::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C4*)(S7682C2*)(S7682C12*), ABISELECT(992,648), "S7682C16");
    /*is_ambiguous_... S7682C16::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C2*)(S7682C12*), ABISELECT(992,648), "S7682C16");
    check_base_class_offset(lv, (S7682C12*)(S7682C11*), ABISELECT(992,648), "S7682C16");
    check_base_class_offset(lv, (S7682C11*)(S7682C10*), ABISELECT(984,644), "S7682C16");
    /*is_ambiguous_... S7682C10::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C4*)(S7682C2*)(S7682C12*)(S7682C10*), ABISELECT(432,268), "S7682C16");
    /*is_ambiguous_... S7682C10::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C4*)(S7682C2*)(S7682C12*)(S7682C10*), ABISELECT(432,268), "S7682C16");
    /*is_ambiguous_... S7682C10::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C2*)(S7682C12*)(S7682C10*), ABISELECT(432,268), "S7682C16");
    /*is_ambiguous_... S7682C10::S7682C12 */ AMB_check_base_class_offset(lv, (S7682C12*)(S7682C10*), ABISELECT(432,268), "S7682C16");
    check_base_class_offset(lv, (S7682C9*)(S7682C15*)(S7682C10*), ABISELECT(1280,840), "S7682C16");
    /*is_ambiguous_... S7682C15::S7682C4 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C4*)(S7682C15*)(S7682C10*), ABISELECT(720,460), "S7682C16");
    /*is_ambiguous_... S7682C15::S7682C4 */ AMB_check_base_class_offset(lv, (S7682C4*)(S7682C15*)(S7682C10*), ABISELECT(720,460), "S7682C16");
    check_base_class_offset(lv, (S7682C15*)(S7682C10*), ABISELECT(720,460), "S7682C16");
    check_base_class_offset(lv, (S7682C10*), ABISELECT(432,268), "S7682C16");
    /*is_ambiguous_... S7682C16::S7682C2 */ AMB_check_base_class_offset(lv, (S7682C3*)(S7682C4*)(S7682C2*), ABISELECT(2752,1768), "S7682C16");
    /*is_ambiguous_... S7682C16::S7682C2 */ AMB_check_base_class_offset(lv, (S7682C4*)(S7682C2*), ABISELECT(2752,1768), "S7682C16");
    check_base_class_offset(lv, (S7682C2*)(S7682C6*), ABISELECT(2752,1768), "S7682C16");
    check_base_class_offset(lv, (S7682C6*), ABISELECT(8,4), "S7682C16");
    check_field_offset(lv, s7682c16f0, ABISELECT(16,8), "S7682C16.s7682c16f0");
    test_class_info(&lv, &cd_S7682C16);
    dp->~S7682C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7682C16(Test_S7682C16, "S7682C16", ABISELECT(2976,1904));

#else // __cplusplus

extern void _ZN8S7682C16C1Ev();
extern void _ZN8S7682C16D2Ev();
Name_Map name_map_S7682C16[] = {
  NSPAIR(_ZN8S7682C16C1Ev),
  NSPAIR(_ZN8S7682C16D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7682C8_nt;
extern VTBL_ENTRY _ZTI10S7682C8_nt[];
extern  VTBL_ENTRY _ZTV10S7682C8_nt[];
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C4;
extern VTBL_ENTRY _ZTI7S7682C4[];
extern  VTBL_ENTRY _ZTV7S7682C4[];
extern Class_Descriptor cd_S7682C13;
extern VTBL_ENTRY _ZTI8S7682C13[];
extern  VTBL_ENTRY _ZTV8S7682C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7682C13[];
extern Class_Descriptor cd_S7682C8_nt;
extern VTBL_ENTRY _ZTI10S7682C8_nt[];
extern  VTBL_ENTRY _ZTV10S7682C8_nt[];
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C4;
extern VTBL_ENTRY _ZTI7S7682C4[];
extern  VTBL_ENTRY _ZTV7S7682C4[];
extern Class_Descriptor cd_S7682C2;
extern VTBL_ENTRY _ZTI7S7682C2[];
extern  VTBL_ENTRY _ZTV7S7682C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7682C2[];
extern Class_Descriptor cd_S7682C12;
extern VTBL_ENTRY _ZTI8S7682C12[];
extern  VTBL_ENTRY _ZTV8S7682C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7682C12[];
extern Class_Descriptor cd_S7682C11;
extern VTBL_ENTRY _ZTI8S7682C11[];
extern  VTBL_ENTRY _ZTV8S7682C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7682C11[];
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C4;
extern VTBL_ENTRY _ZTI7S7682C4[];
extern  VTBL_ENTRY _ZTV7S7682C4[];
extern Class_Descriptor cd_S7682C2;
extern VTBL_ENTRY _ZTI7S7682C2[];
extern  VTBL_ENTRY _ZTV7S7682C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7682C2[];
extern Class_Descriptor cd_S7682C12;
extern VTBL_ENTRY _ZTI8S7682C12[];
extern  VTBL_ENTRY _ZTV8S7682C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7682C12[];
extern Class_Descriptor cd_S7682C9;
extern VTBL_ENTRY _ZTI7S7682C9[];
extern  VTBL_ENTRY _ZTV7S7682C9[];
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C4;
extern VTBL_ENTRY _ZTI7S7682C4[];
extern  VTBL_ENTRY _ZTV7S7682C4[];
extern Class_Descriptor cd_S7682C15;
extern VTBL_ENTRY _ZTI8S7682C15[];
extern  VTBL_ENTRY _ZTV8S7682C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7682C15[];
extern Class_Descriptor cd_S7682C10;
extern VTBL_ENTRY _ZTI8S7682C10[];
extern  VTBL_ENTRY _ZTV8S7682C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7682C10[];
extern Class_Descriptor cd_S7682C3;
extern VTBL_ENTRY _ZTI7S7682C3[];
extern  VTBL_ENTRY _ZTV7S7682C3[];
extern Class_Descriptor cd_S7682C4;
extern VTBL_ENTRY _ZTI7S7682C4[];
extern  VTBL_ENTRY _ZTV7S7682C4[];
extern Class_Descriptor cd_S7682C2;
extern VTBL_ENTRY _ZTI7S7682C2[];
extern  VTBL_ENTRY _ZTV7S7682C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7682C2[];
extern Class_Descriptor cd_S7682C6;
extern VTBL_ENTRY _ZTI7S7682C6[];
extern  VTBL_ENTRY _ZTV7S7682C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7682C6[];
static Base_Class bases_S7682C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7682C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7682C3,    ABISELECT(32,16), //bcp->offset
    34, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7682C3,    ABISELECT(224,136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S7682C4,    ABISELECT(224,136), //bcp->offset
    58, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S7682C13,    ABISELECT(192,124), //bcp->offset
    44, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7682C8_nt,    ABISELECT(976,640), //bcp->offset
    155, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    19, //immediately_derived
  0, 1},
  {&cd_S7682C3,    ABISELECT(992,648), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S7682C4,    ABISELECT(992,648), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7682C2,    ABISELECT(992,648), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    45, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S7682C12,    ABISELECT(992,648), //bcp->offset
    178, //bcp->virtual_function_table_offset
    20, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    44, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S7682C11,    ABISELECT(984,644), //bcp->offset
    165, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    39, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    19, //immediately_derived
  0, 1},
  {&cd_S7682C3,    ABISELECT(432,268), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S7682C4,    ABISELECT(432,268), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S7682C2,    ABISELECT(432,268), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S7682C12,    ABISELECT(432,268), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S7682C9,    ABISELECT(1280,840), //bcp->offset
    213, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    18, //immediately_derived
  0, 1},
  {&cd_S7682C3,    ABISELECT(720,460), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S7682C4,    ABISELECT(720,460), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S7682C15,    ABISELECT(720,460), //bcp->offset
    136, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S7682C10,    ABISELECT(432,268), //bcp->offset
    74, //bcp->virtual_function_table_offset
    37, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7682C3,    ABISELECT(2752,1768), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S7682C4,    ABISELECT(2752,1768), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S7682C2,    ABISELECT(2752,1768), //bcp->offset
    233, //bcp->virtual_function_table_offset
    14, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    50, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    23, //immediately_derived
  0, 1},
  {&cd_S7682C6,    ABISELECT(8,4), //bcp->offset
    24, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7682C16[];
extern void _ZN10S7682C8_nt3v29Ev();
extern void _ZN10S7682C8_nt3v30Ev();
extern void _ZN10S7682C8_nt3v31Ev();
extern void _ZN10S7682C8_nt3v32Ev();
extern void _ZN8S7682C16D1Ev();
extern void _ZN8S7682C16D0Ev();
extern void _ZN8S7682C163v65Ev();
extern void _ZN8S7682C163v66Ev();
extern void _ZN8S7682C163v67Ev();
extern void _ZN8S7682C163v68Ev();
extern void _ZN8S7682C163v69Ev();
extern void _ZN8S7682C163v70Ev();
extern void _ZN8S7682C163v71Ev();
extern void ABISELECT(_ZThn8_N8S7682C16D1Ev,_ZThn4_N8S7682C16D1Ev)();
extern void ABISELECT(_ZThn8_N8S7682C16D0Ev,_ZThn4_N8S7682C16D0Ev)();
extern void _ZN7S7682C63v19Ev();
extern void _ZN7S7682C63v20Ev();
extern void _ZN7S7682C63v21Ev();
extern void _ZN7S7682C63v22Ev();
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN8S7682C133v42Ev();
extern void _ZN8S7682C133v43Ev();
extern void _ZN8S7682C133v44Ev();
extern void _ZN8S7682C133v45Ev();
extern void _ZN8S7682C133v46Ev();
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
extern void _ZN8S7682C123v47Ev();
extern void _ZN8S7682C123v48Ev();
extern void _ZN8S7682C123v49Ev();
extern void _ZN8S7682C123v50Ev();
extern void ABISELECT(_ZTv0_n200_N8S7682C16D1Ev,_ZTv0_n100_N8S7682C16D1Ev)();
extern void ABISELECT(_ZThn432_N8S7682C16D1Ev,_ZThn268_N8S7682C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n200_N8S7682C16D0Ev,_ZTv0_n100_N8S7682C16D0Ev)();
extern void ABISELECT(_ZThn432_N8S7682C16D0Ev,_ZThn268_N8S7682C16D0Ev)() __attribute__((weak));
extern void _ZN8S7682C103v57Ev();
extern void _ZN8S7682C103v58Ev();
extern void _ZN8S7682C103v59Ev();
extern void _ZN8S7682C103v60Ev();
extern void _ZN8S7682C103v61Ev();
extern void _ZN8S7682C103v62Ev();
extern void _ZN8S7682C103v63Ev();
extern void _ZN8S7682C103v64Ev();
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void ABISELECT(_ZTvn288_n200_N8S7682C16D1Ev,_ZTvn192_n100_N8S7682C16D1Ev)();
extern void ABISELECT(_ZTvn288_n200_N8S7682C16D0Ev,_ZTvn192_n100_N8S7682C16D0Ev)();
extern void _ZN8S7682C153v53Ev();
extern void _ZN8S7682C153v54Ev();
extern void _ZN8S7682C153v55Ev();
extern void _ZN8S7682C153v56Ev();
extern void _ZN10S7682C8_nt3v29Ev();
extern void _ZN10S7682C8_nt3v30Ev();
extern void _ZN10S7682C8_nt3v31Ev();
extern void _ZN10S7682C8_nt3v32Ev();
extern void ABISELECT(_ZTv0_n56_N8S7682C16D1Ev,_ZTv0_n28_N8S7682C16D1Ev)();
extern void ABISELECT(_ZThn984_N8S7682C16D1Ev,_ZThn644_N8S7682C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7682C16D0Ev,_ZTv0_n28_N8S7682C16D0Ev)();
extern void ABISELECT(_ZThn984_N8S7682C16D0Ev,_ZThn644_N8S7682C16D0Ev)() __attribute__((weak));
extern void _ZN8S7682C113v51Ev();
extern void _ZN8S7682C113v52Ev();
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
extern void _ZN8S7682C123v47Ev();
extern void _ZN8S7682C123v48Ev();
extern void _ZN8S7682C123v49Ev();
extern void _ZN8S7682C123v50Ev();
extern void _ZN7S7682C93v33Ev();
extern void _ZN7S7682C93v34Ev();
extern void _ZN7S7682C93v35Ev();
extern void _ZN7S7682C93v36Ev();
extern void _ZN7S7682C93v37Ev();
extern void _ZN7S7682C93v38Ev();
extern void _ZN7S7682C93v39Ev();
extern void _ZN7S7682C93v40Ev();
extern void _ZN7S7682C93v41Ev();
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
static  VTBL_ENTRY vtc_S7682C16[] = {
  ABISELECT(2752,1768),
  ABISELECT(1280,840),
  ABISELECT(992,648),
  ABISELECT(984,644),
  ABISELECT(976,640),
  ABISELECT(432,268),
  ABISELECT(224,136),
  ABISELECT(192,124),
  ABISELECT(32,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S7682C16[0]),
  (VTBL_ENTRY)&_ZN10S7682C8_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S7682C8_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S7682C8_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S7682C8_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S7682C16D1Ev,
  (VTBL_ENTRY)&_ZN8S7682C16D0Ev,
  (VTBL_ENTRY)&_ZN8S7682C163v65Ev,
  (VTBL_ENTRY)&_ZN8S7682C163v66Ev,
  (VTBL_ENTRY)&_ZN8S7682C163v67Ev,
  (VTBL_ENTRY)&_ZN8S7682C163v68Ev,
  (VTBL_ENTRY)&_ZN8S7682C163v69Ev,
  (VTBL_ENTRY)&_ZN8S7682C163v70Ev,
  (VTBL_ENTRY)&_ZN8S7682C163v71Ev,
  ABISELECT(24,12),
  ABISELECT(2744,1764),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S7682C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S7682C16D1Ev,_ZThn4_N8S7682C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S7682C16D0Ev,_ZThn4_N8S7682C16D0Ev),
  (VTBL_ENTRY)&_ZN7S7682C63v19Ev,
  (VTBL_ENTRY)&_ZN7S7682C63v20Ev,
  (VTBL_ENTRY)&_ZN7S7682C63v21Ev,
  (VTBL_ENTRY)&_ZN7S7682C63v22Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S7682C16[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(32,12),
  ABISELECT(-160,-108),
  ABISELECT(-192,-124),
  (VTBL_ENTRY)&(_ZTI8S7682C16[0]),
  (VTBL_ENTRY)&_ZN8S7682C133v42Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v43Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v44Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v45Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v46Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-224,-136),
  (VTBL_ENTRY)&(_ZTI8S7682C16[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  ABISELECT(288,192),
  ABISELECT(288,192),
  ABISELECT(288,192),
  ABISELECT(288,192),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-432,-268),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(848,572),
  ABISELECT(560,380),
  ABISELECT(552,376),
  ABISELECT(544,372),
  ABISELECT(-208,-132),
  ABISELECT(-240,-144),
  ABISELECT(-400,-252),
  ABISELECT(-432,-268),
  (VTBL_ENTRY)&(_ZTI8S7682C16[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v47Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v48Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v49Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v50Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n200_N8S7682C16D1Ev,_ZTv0_n100_N8S7682C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n200_N8S7682C16D0Ev,_ZTv0_n100_N8S7682C16D0Ev),
  (VTBL_ENTRY)&_ZN8S7682C103v57Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v58Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v59Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v60Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v61Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v62Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v63Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v64Ev,
  ABISELECT(560,380),
  ABISELECT(-496,-324),
  ABISELECT(-528,-336),
  ABISELECT(-688,-444),
  ABISELECT(-720,-460),
  (VTBL_ENTRY)&(_ZTI8S7682C16[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn288_n200_N8S7682C16D1Ev,_ZTvn192_n100_N8S7682C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn288_n200_N8S7682C16D0Ev,_ZTvn192_n100_N8S7682C16D0Ev),
  (VTBL_ENTRY)&_ZN8S7682C153v53Ev,
  (VTBL_ENTRY)&_ZN8S7682C153v54Ev,
  (VTBL_ENTRY)&_ZN8S7682C153v55Ev,
  (VTBL_ENTRY)&_ZN8S7682C153v56Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-976,-640),
  (VTBL_ENTRY)&(_ZTI8S7682C16[0]),
  (VTBL_ENTRY)&_ZN10S7682C8_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S7682C8_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S7682C8_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S7682C8_nt3v32Ev,
  0,
  0,
  ABISELECT(-984,-644),
  ABISELECT(-760,-508),
  ABISELECT(-952,-628),
  ABISELECT(-792,-520),
  ABISELECT(8,4),
  ABISELECT(-984,-644),
  (VTBL_ENTRY)&(_ZTI8S7682C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7682C16D1Ev,_ZTv0_n28_N8S7682C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7682C16D0Ev,_ZTv0_n28_N8S7682C16D0Ev),
  (VTBL_ENTRY)&_ZN8S7682C113v51Ev,
  (VTBL_ENTRY)&_ZN8S7682C113v52Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-768,-512),
  ABISELECT(-800,-524),
  ABISELECT(-960,-632),
  ABISELECT(-992,-648),
  (VTBL_ENTRY)&(_ZTI8S7682C16[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v47Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v48Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v49Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v50Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-1280,-840),
  (VTBL_ENTRY)&(_ZTI8S7682C16[0]),
  (VTBL_ENTRY)&_ZN7S7682C93v33Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v34Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v35Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v36Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v37Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v38Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v39Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v40Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v41Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-2720,-1752),
  ABISELECT(-2752,-1768),
  (VTBL_ENTRY)&(_ZTI8S7682C16[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
};
extern VTBL_ENTRY _ZTV8S7682C16[];
extern void _ZN7S7682C6D1Ev();
extern void _ZN7S7682C6D0Ev();
extern void _ZN7S7682C63v19Ev();
extern void _ZN7S7682C63v20Ev();
extern void _ZN7S7682C63v21Ev();
extern void _ZN7S7682C63v22Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C6__8S7682C16[] = {
  ABISELECT(24,12),
  ABISELECT(2744,1764),
  0,
  (VTBL_ENTRY)&(_ZTI7S7682C6[0]),
  (VTBL_ENTRY)&_ZN7S7682C6D1Ev,
  (VTBL_ENTRY)&_ZN7S7682C6D0Ev,
  (VTBL_ENTRY)&_ZN7S7682C63v19Ev,
  (VTBL_ENTRY)&_ZN7S7682C63v20Ev,
  (VTBL_ENTRY)&_ZN7S7682C63v21Ev,
  (VTBL_ENTRY)&_ZN7S7682C63v22Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C2__7S7682C6__8S7682C16[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-2720,-1752),
  ABISELECT(-2744,-1764),
  (VTBL_ENTRY)&(_ZTI7S7682C6[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__7S7682C6__8S7682C16[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI7S7682C6[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern void _ZN8S7682C133v42Ev();
extern void _ZN8S7682C133v43Ev();
extern void _ZN8S7682C133v44Ev();
extern void _ZN8S7682C133v45Ev();
extern void _ZN8S7682C133v46Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C13__8S7682C16[] = {
  ABISELECT(32,12),
  ABISELECT(-160,-108),
  0,
  (VTBL_ENTRY)&(_ZTI8S7682C13[0]),
  (VTBL_ENTRY)&_ZN8S7682C133v42Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v43Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v44Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v45Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v46Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__8S7682C13__8S7682C16[] = {
  0,
  0,
  0,
  0,
  ABISELECT(160,108),
  (VTBL_ENTRY)&(_ZTI8S7682C13[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C4__8S7682C13__8S7682C16[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-12),
  (VTBL_ENTRY)&(_ZTI8S7682C13[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
extern void _ZN8S7682C123v47Ev();
extern void _ZN8S7682C123v48Ev();
extern void _ZN8S7682C123v49Ev();
extern void _ZN8S7682C123v50Ev();
extern void _ZN8S7682C10D1Ev();
extern void _ZN8S7682C10D0Ev();
extern void _ZN8S7682C103v57Ev();
extern void _ZN8S7682C103v58Ev();
extern void _ZN8S7682C103v59Ev();
extern void _ZN8S7682C103v60Ev();
extern void _ZN8S7682C103v61Ev();
extern void _ZN8S7682C103v62Ev();
extern void _ZN8S7682C103v63Ev();
extern void _ZN8S7682C103v64Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C10__8S7682C16[] = {
  ABISELECT(848,572),
  ABISELECT(560,380),
  ABISELECT(552,376),
  ABISELECT(544,372),
  ABISELECT(-208,-132),
  ABISELECT(-240,-144),
  ABISELECT(-400,-252),
  0,
  (VTBL_ENTRY)&(_ZTI8S7682C10[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v47Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v48Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v49Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v50Ev,
  (VTBL_ENTRY)&_ZN8S7682C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7682C10D0Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v57Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v58Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v59Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v60Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v61Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v62Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v63Ev,
  (VTBL_ENTRY)&_ZN8S7682C103v64Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
extern void _ZN8S7682C123v47Ev();
extern void _ZN8S7682C123v48Ev();
extern void _ZN8S7682C123v49Ev();
extern void _ZN8S7682C123v50Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C128S7682C10__A1__8S7682C16[] = {
  ABISELECT(-208,-132),
  ABISELECT(-240,-144),
  ABISELECT(-400,-252),
  0,
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v47Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v48Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v49Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v50Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C28S7682C128S7682C10__A1__8S7682C16[] = {
  ABISELECT(-400,-252),
  0,
  (VTBL_ENTRY)&(_ZTI7S7682C2[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__7S7682C28S7682C128S7682C10__A1__8S7682C16[] = {
  0,
  0,
  0,
  0,
  ABISELECT(400,252),
  (VTBL_ENTRY)&(_ZTI7S7682C2[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern void _ZN8S7682C133v42Ev();
extern void _ZN8S7682C133v43Ev();
extern void _ZN8S7682C133v44Ev();
extern void _ZN8S7682C133v45Ev();
extern void _ZN8S7682C133v46Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C13__8S7682C128S7682C10__A1__8S7682C16[] = {
  0,
  0,
  0,
  0,
  0,
  ABISELECT(32,12),
  ABISELECT(-160,-108),
  ABISELECT(240,144),
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN8S7682C133v42Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v43Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v44Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v45Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v46Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__8S7682C128S7682C10__A1__8S7682C16[] = {
  0,
  0,
  0,
  0,
  ABISELECT(400,252),
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C4__8S7682C128S7682C10__A1__8S7682C16[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(208,132),
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN8S7682C15D1Ev();
extern void _ZN8S7682C15D0Ev();
extern void _ZN8S7682C153v53Ev();
extern void _ZN8S7682C153v54Ev();
extern void _ZN8S7682C153v55Ev();
extern void _ZN8S7682C153v56Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C158S7682C10__8S7682C16[] = {
  ABISELECT(560,380),
  ABISELECT(-496,-324),
  ABISELECT(-528,-336),
  ABISELECT(-688,-444),
  0,
  (VTBL_ENTRY)&(_ZTI8S7682C15[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN8S7682C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7682C15D0Ev,
  (VTBL_ENTRY)&_ZN8S7682C153v53Ev,
  (VTBL_ENTRY)&_ZN8S7682C153v54Ev,
  (VTBL_ENTRY)&_ZN8S7682C153v55Ev,
  (VTBL_ENTRY)&_ZN8S7682C153v56Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__8S7682C158S7682C10__8S7682C16[] = {
  0,
  0,
  0,
  0,
  ABISELECT(688,444),
  (VTBL_ENTRY)&(_ZTI8S7682C15[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern void _ZN8S7682C133v42Ev();
extern void _ZN8S7682C133v43Ev();
extern void _ZN8S7682C133v44Ev();
extern void _ZN8S7682C133v45Ev();
extern void _ZN8S7682C133v46Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C13__8S7682C158S7682C10__8S7682C16[] = {
  0,
  0,
  0,
  0,
  0,
  ABISELECT(32,12),
  ABISELECT(-160,-108),
  ABISELECT(528,336),
  (VTBL_ENTRY)&(_ZTI8S7682C15[0]),
  (VTBL_ENTRY)&_ZN8S7682C133v42Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v43Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v44Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v45Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v46Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C4__8S7682C158S7682C10__8S7682C16[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(496,324),
  (VTBL_ENTRY)&(_ZTI8S7682C15[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
};
extern void _ZN7S7682C93v33Ev();
extern void _ZN7S7682C93v34Ev();
extern void _ZN7S7682C93v35Ev();
extern void _ZN7S7682C93v36Ev();
extern void _ZN7S7682C93v37Ev();
extern void _ZN7S7682C93v38Ev();
extern void _ZN7S7682C93v39Ev();
extern void _ZN7S7682C93v40Ev();
extern void _ZN7S7682C93v41Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C9__8S7682C158S7682C10__8S7682C16[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-560,-380),
  (VTBL_ENTRY)&(_ZTI8S7682C15[0]),
  (VTBL_ENTRY)&_ZN7S7682C93v33Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v34Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v35Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v36Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v37Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v38Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v39Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v40Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v41Ev,
};
extern void _ZN10S7682C8_nt3v29Ev();
extern void _ZN10S7682C8_nt3v30Ev();
extern void _ZN10S7682C8_nt3v31Ev();
extern void _ZN10S7682C8_nt3v32Ev();
static  VTBL_ENTRY _tg__ZTV10S7682C8_nt__8S7682C10__8S7682C16[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-544,-372),
  (VTBL_ENTRY)&(_ZTI8S7682C10[0]),
  (VTBL_ENTRY)&_ZN10S7682C8_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S7682C8_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S7682C8_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S7682C8_nt3v32Ev,
};
extern void ABISELECT(_ZTv0_n56_N8S7682C10D1Ev,_ZTv0_n28_N8S7682C10D1Ev)();
extern void ABISELECT(_ZThn552_N8S7682C10D1Ev,_ZThn376_N8S7682C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7682C10D0Ev,_ZTv0_n28_N8S7682C10D0Ev)();
extern void ABISELECT(_ZThn552_N8S7682C10D0Ev,_ZThn376_N8S7682C10D0Ev)() __attribute__((weak));
extern void _ZN8S7682C113v51Ev();
extern void _ZN8S7682C113v52Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C11__8S7682C10__8S7682C16[] = {
  0,
  0,
  ABISELECT(-552,-376),
  ABISELECT(-760,-508),
  ABISELECT(-952,-628),
  ABISELECT(-792,-520),
  ABISELECT(8,4),
  ABISELECT(-552,-376),
  (VTBL_ENTRY)&(_ZTI8S7682C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7682C10D1Ev,_ZTv0_n28_N8S7682C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7682C10D0Ev,_ZTv0_n28_N8S7682C10D0Ev),
  (VTBL_ENTRY)&_ZN8S7682C113v51Ev,
  (VTBL_ENTRY)&_ZN8S7682C113v52Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
extern void _ZN8S7682C123v47Ev();
extern void _ZN8S7682C123v48Ev();
extern void _ZN8S7682C123v49Ev();
extern void _ZN8S7682C123v50Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C12__8S7682C10__8S7682C16[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-768,-512),
  ABISELECT(-800,-524),
  ABISELECT(-960,-632),
  ABISELECT(-560,-380),
  (VTBL_ENTRY)&(_ZTI8S7682C10[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v47Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v48Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v49Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v50Ev,
};
extern void _ZN8S7682C133v42Ev();
extern void _ZN8S7682C133v43Ev();
extern void _ZN8S7682C133v44Ev();
extern void _ZN8S7682C133v45Ev();
extern void _ZN8S7682C133v46Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C13__8S7682C10__8S7682C16[] = {
  0,
  0,
  0,
  0,
  0,
  ABISELECT(32,12),
  ABISELECT(-160,-108),
  ABISELECT(240,144),
  (VTBL_ENTRY)&(_ZTI8S7682C10[0]),
  (VTBL_ENTRY)&_ZN8S7682C133v42Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v43Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v44Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v45Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v46Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__8S7682C10__8S7682C16[] = {
  0,
  0,
  0,
  0,
  ABISELECT(400,252),
  (VTBL_ENTRY)&(_ZTI8S7682C10[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C4__8S7682C10__8S7682C16[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(208,132),
  (VTBL_ENTRY)&(_ZTI8S7682C10[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void ABISELECT(_ZThn288_N8S7682C10D1Ev,_ZThn192_N8S7682C10D1Ev)();
extern void ABISELECT(_ZThn288_N8S7682C10D0Ev,_ZThn192_N8S7682C10D0Ev)();
extern void _ZN8S7682C153v53Ev();
extern void _ZN8S7682C153v54Ev();
extern void _ZN8S7682C153v55Ev();
extern void _ZN8S7682C153v56Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C15__8S7682C10__8S7682C16[] = {
  ABISELECT(560,380),
  ABISELECT(-496,-324),
  ABISELECT(-528,-336),
  ABISELECT(-688,-444),
  ABISELECT(-288,-192),
  (VTBL_ENTRY)&(_ZTI8S7682C10[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn288_N8S7682C10D1Ev,_ZThn192_N8S7682C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn288_N8S7682C10D0Ev,_ZThn192_N8S7682C10D0Ev),
  (VTBL_ENTRY)&_ZN8S7682C153v53Ev,
  (VTBL_ENTRY)&_ZN8S7682C153v54Ev,
  (VTBL_ENTRY)&_ZN8S7682C153v55Ev,
  (VTBL_ENTRY)&_ZN8S7682C153v56Ev,
};
extern void _ZN7S7682C93v33Ev();
extern void _ZN7S7682C93v34Ev();
extern void _ZN7S7682C93v35Ev();
extern void _ZN7S7682C93v36Ev();
extern void _ZN7S7682C93v37Ev();
extern void _ZN7S7682C93v38Ev();
extern void _ZN7S7682C93v39Ev();
extern void _ZN7S7682C93v40Ev();
extern void _ZN7S7682C93v41Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C9__8S7682C10__8S7682C16[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-848,-572),
  (VTBL_ENTRY)&(_ZTI8S7682C10[0]),
  (VTBL_ENTRY)&_ZN7S7682C93v33Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v34Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v35Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v36Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v37Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v38Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v39Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v40Ev,
  (VTBL_ENTRY)&_ZN7S7682C93v41Ev,
};
extern void _ZN8S7682C11D1Ev();
extern void _ZN8S7682C11D0Ev();
extern void _ZN8S7682C113v51Ev();
extern void _ZN8S7682C113v52Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C11__8S7682C16[] = {
  ABISELECT(-760,-508),
  ABISELECT(-952,-628),
  ABISELECT(-792,-520),
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI8S7682C11[0]),
  (VTBL_ENTRY)&_ZN8S7682C11D1Ev,
  (VTBL_ENTRY)&_ZN8S7682C11D0Ev,
  (VTBL_ENTRY)&_ZN8S7682C113v51Ev,
  (VTBL_ENTRY)&_ZN8S7682C113v52Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
extern void _ZN8S7682C123v47Ev();
extern void _ZN8S7682C123v48Ev();
extern void _ZN8S7682C123v49Ev();
extern void _ZN8S7682C123v50Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C12__8S7682C11__8S7682C16[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-768,-512),
  ABISELECT(-800,-524),
  ABISELECT(-960,-632),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S7682C11[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v47Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v48Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v49Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v50Ev,
};
extern void _ZN8S7682C133v42Ev();
extern void _ZN8S7682C133v43Ev();
extern void _ZN8S7682C133v44Ev();
extern void _ZN8S7682C133v45Ev();
extern void _ZN8S7682C133v46Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C13__8S7682C11__8S7682C16[] = {
  0,
  0,
  0,
  0,
  0,
  ABISELECT(32,12),
  ABISELECT(-160,-108),
  ABISELECT(792,520),
  (VTBL_ENTRY)&(_ZTI8S7682C11[0]),
  (VTBL_ENTRY)&_ZN8S7682C133v42Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v43Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v44Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v45Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v46Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__8S7682C11__8S7682C16[] = {
  0,
  0,
  0,
  0,
  ABISELECT(952,628),
  (VTBL_ENTRY)&(_ZTI8S7682C11[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C4__8S7682C11__8S7682C16[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(760,508),
  (VTBL_ENTRY)&(_ZTI8S7682C11[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
extern void _ZN8S7682C123v47Ev();
extern void _ZN8S7682C123v48Ev();
extern void _ZN8S7682C123v49Ev();
extern void _ZN8S7682C123v50Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C12__8S7682C16[] = {
  ABISELECT(-768,-512),
  ABISELECT(-800,-524),
  ABISELECT(-960,-632),
  0,
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v47Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v48Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v49Ev,
  (VTBL_ENTRY)&_ZN8S7682C123v50Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C28S7682C12__8S7682C16[] = {
  ABISELECT(-960,-632),
  0,
  (VTBL_ENTRY)&(_ZTI7S7682C2[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__7S7682C28S7682C12__8S7682C16[] = {
  0,
  0,
  0,
  0,
  ABISELECT(960,632),
  (VTBL_ENTRY)&(_ZTI7S7682C2[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern void _ZN8S7682C133v42Ev();
extern void _ZN8S7682C133v43Ev();
extern void _ZN8S7682C133v44Ev();
extern void _ZN8S7682C133v45Ev();
extern void _ZN8S7682C133v46Ev();
static  VTBL_ENTRY _tg__ZTV8S7682C13__8S7682C12__8S7682C16[] = {
  0,
  0,
  0,
  0,
  0,
  ABISELECT(32,12),
  ABISELECT(-160,-108),
  ABISELECT(800,524),
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN8S7682C133v42Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v43Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v44Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v45Ev,
  (VTBL_ENTRY)&_ZN8S7682C133v46Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__8S7682C12__8S7682C16[] = {
  0,
  0,
  0,
  0,
  ABISELECT(960,632),
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C4__8S7682C12__8S7682C16[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(768,512),
  (VTBL_ENTRY)&(_ZTI8S7682C12[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
extern void _ZN7S7682C43v12Ev();
extern void _ZN7S7682C43v13Ev();
extern void _ZN7S7682C43v14Ev();
extern void _ZN7S7682C23v15Ev();
extern void _ZN7S7682C23v16Ev();
extern void _ZN7S7682C23v17Ev();
extern void _ZN7S7682C23v18Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C2__A2__8S7682C16[] = {
  ABISELECT(-2720,-1752),
  0,
  (VTBL_ENTRY)&(_ZTI7S7682C2[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v12Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v13Ev,
  (VTBL_ENTRY)&_ZN7S7682C43v14Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v15Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v16Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v17Ev,
  (VTBL_ENTRY)&_ZN7S7682C23v18Ev,
};
extern void _ZN7S7682C32v8Ev();
extern void _ZN7S7682C32v9Ev();
extern void _ZN7S7682C33v10Ev();
extern void _ZN7S7682C33v11Ev();
static  VTBL_ENTRY _tg__ZTV7S7682C3__7S7682C2__A2__8S7682C16[] = {
  0,
  0,
  0,
  0,
  ABISELECT(2720,1752),
  (VTBL_ENTRY)&(_ZTI7S7682C2[0]),
  (VTBL_ENTRY)&_ZN7S7682C32v8Ev,
  (VTBL_ENTRY)&_ZN7S7682C32v9Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v10Ev,
  (VTBL_ENTRY)&_ZN7S7682C33v11Ev,
};
static  VTT_ENTRY vtt_S7682C16[] = {
  {&(_ZTV8S7682C16[11]),  11,258},
  {&(_tg__ZTV7S7682C6__8S7682C16[4]),  4,10},
  {&(_tg__ZTV7S7682C2__7S7682C6__8S7682C16[14]),  14,25},
  {&(_tg__ZTV7S7682C3__7S7682C6__8S7682C16[6]),  6,10},
  {&(_ZTV8S7682C16[40]),  40,258},
  {&(_ZTV8S7682C16[53]),  53,258},
  {&(_ZTV8S7682C16[67]),  67,258},
  {&(_ZTV8S7682C16[111]),  111,258},
  {&(_ZTV8S7682C16[161]),  161,258},
  {&(_ZTV8S7682C16[174]),  174,258},
  {&(_ZTV8S7682C16[198]),  198,258},
  {&(_ZTV8S7682C16[142]),  142,258},
  {&(_ZTV8S7682C16[224]),  224,258},
  {&(_ZTV8S7682C16[28]),  28,258},
  {&(_ZTV8S7682C16[247]),  247,258},
  {&(_tg__ZTV8S7682C13__8S7682C16[4]),  4,9},
  {&(_tg__ZTV7S7682C3__8S7682C13__8S7682C16[6]),  6,10},
  {&(_tg__ZTV7S7682C4__8S7682C13__8S7682C16[9]),  9,16},
  {&(_tg__ZTV8S7682C10__8S7682C16[9]),  9,34},
  {&(_tg__ZTV8S7682C128S7682C10__A1__8S7682C16[5]),  5,20},
  {&(_tg__ZTV7S7682C28S7682C128S7682C10__A1__8S7682C16[3]),  3,14},
  {&(_tg__ZTV7S7682C3__7S7682C28S7682C128S7682C10__A1__8S7682C16[6]),  6,10},
  {&(_tg__ZTV8S7682C13__8S7682C128S7682C10__A1__8S7682C16[9]),  9,14},
  {&(_tg__ZTV7S7682C3__8S7682C128S7682C10__A1__8S7682C16[6]),  6,10},
  {&(_tg__ZTV7S7682C4__8S7682C128S7682C10__A1__8S7682C16[9]),  9,16},
  {&(_tg__ZTV8S7682C158S7682C10__8S7682C16[6]),  6,19},
  {&(_tg__ZTV7S7682C3__8S7682C158S7682C10__8S7682C16[6]),  6,10},
  {&(_tg__ZTV8S7682C13__8S7682C158S7682C10__8S7682C16[9]),  9,14},
  {&(_tg__ZTV7S7682C4__8S7682C158S7682C10__8S7682C16[9]),  9,16},
  {&(_tg__ZTV7S7682C9__8S7682C158S7682C10__8S7682C16[11]),  11,20},
  {&(_tg__ZTV10S7682C8_nt__8S7682C10__8S7682C16[6]),  6,10},
  {&(_tg__ZTV8S7682C11__8S7682C10__8S7682C16[9]),  9,13},
  {&(_tg__ZTV8S7682C12__8S7682C10__8S7682C16[20]),  20,35},
  {&(_tg__ZTV8S7682C13__8S7682C10__8S7682C16[9]),  9,14},
  {&(_tg__ZTV7S7682C3__8S7682C10__8S7682C16[6]),  6,10},
  {&(_tg__ZTV7S7682C4__8S7682C10__8S7682C16[9]),  9,16},
  {&(_tg__ZTV8S7682C15__8S7682C10__8S7682C16[6]),  6,19},
  {&(_tg__ZTV7S7682C9__8S7682C10__8S7682C16[11]),  11,20},
  {&(_tg__ZTV8S7682C11__8S7682C16[6]),  6,10},
  {&(_tg__ZTV8S7682C12__8S7682C11__8S7682C16[20]),  20,35},
  {&(_tg__ZTV8S7682C13__8S7682C11__8S7682C16[9]),  9,14},
  {&(_tg__ZTV7S7682C3__8S7682C11__8S7682C16[6]),  6,10},
  {&(_tg__ZTV7S7682C4__8S7682C11__8S7682C16[9]),  9,16},
  {&(_tg__ZTV8S7682C12__8S7682C16[5]),  5,20},
  {&(_tg__ZTV7S7682C28S7682C12__8S7682C16[3]),  3,14},
  {&(_tg__ZTV7S7682C3__7S7682C28S7682C12__8S7682C16[6]),  6,10},
  {&(_tg__ZTV8S7682C13__8S7682C12__8S7682C16[9]),  9,14},
  {&(_tg__ZTV7S7682C3__8S7682C12__8S7682C16[6]),  6,10},
  {&(_tg__ZTV7S7682C4__8S7682C12__8S7682C16[9]),  9,16},
  {&(_tg__ZTV7S7682C2__A2__8S7682C16[3]),  3,14},
  {&(_tg__ZTV7S7682C3__7S7682C2__A2__8S7682C16[6]),  6,10},
};
extern VTBL_ENTRY _ZTI8S7682C16[];
extern  VTBL_ENTRY _ZTV8S7682C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7682C16[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7682C10D0Ev,_ZTv0_n28_N8S7682C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn552_N8S7682C10D0Ev,_ZThn376_N8S7682C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7682C10D1Ev,_ZTv0_n28_N8S7682C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn552_N8S7682C10D1Ev,_ZThn376_N8S7682C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7682C16D0Ev,_ZTv0_n28_N8S7682C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn984_N8S7682C16D0Ev,_ZThn644_N8S7682C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7682C16D1Ev,_ZTv0_n28_N8S7682C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn984_N8S7682C16D1Ev,_ZThn644_N8S7682C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n200_N8S7682C16D0Ev,_ZTv0_n100_N8S7682C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn432_N8S7682C16D0Ev,_ZThn268_N8S7682C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n200_N8S7682C16D1Ev,_ZTv0_n100_N8S7682C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn432_N8S7682C16D1Ev,_ZThn268_N8S7682C16D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7682C16 = {  "S7682C16", // class name
  bases_S7682C16, 24,
  &(vtc_S7682C16[0]), // expected_vtbl_contents
  &(vtt_S7682C16[0]), // expected_vtt_contents
  ABISELECT(2976,1904), // object size
  NSPAIRA(_ZTI8S7682C16),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S7682C16),258, //virtual function table var
  11, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7682C16),51, //virtual table table var
  24, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7682C17  {
  ::S7682C3 s7682c17f0;
  long double s7682c17f1;
  virtual void  v72(); // _ZN8S7682C173v72Ev
  virtual void  v73(); // _ZN8S7682C173v73Ev
  virtual void  v74(); // _ZN8S7682C173v74Ev
  virtual void  v75(); // _ZN8S7682C173v75Ev
  virtual void  v76(); // _ZN8S7682C173v76Ev
  virtual void  v77(); // _ZN8S7682C173v77Ev
  ~S7682C17(); // tgen
  S7682C17(); // tgen
};
//SIG(-1 S7682C17) C1{ v1 v2 v3 v4 v5 v6 FC2{ v7 v8 v9 v10 Fs:13 Fp FD[8]} FD}


void  S7682C17 ::v72(){vfunc_called(this, "_ZN8S7682C173v72Ev");}
void  S7682C17 ::v73(){vfunc_called(this, "_ZN8S7682C173v73Ev");}
void  S7682C17 ::v74(){vfunc_called(this, "_ZN8S7682C173v74Ev");}
void  S7682C17 ::v75(){vfunc_called(this, "_ZN8S7682C173v75Ev");}
void  S7682C17 ::v76(){vfunc_called(this, "_ZN8S7682C173v76Ev");}
void  S7682C17 ::v77(){vfunc_called(this, "_ZN8S7682C173v77Ev");}
S7682C17 ::~S7682C17(){ note_dtor("S7682C17", this);} // tgen
S7682C17 ::S7682C17(){ note_ctor("S7682C17", this);} // tgen

static void Test_S7682C17()
{
  extern Class_Descriptor cd_S7682C17;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(13,32)];
    init_test(&cd_S7682C17, buf);
    S7682C17 *dp, &lv = *(dp=new (buf) S7682C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,124), "sizeof(S7682C17)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7682C17)");
    check_field_offset(lv, s7682c17f0, ABISELECT(16,4), "S7682C17.s7682c17f0");
    check_field_offset(lv, s7682c17f1, ABISELECT(176,112), "S7682C17.s7682c17f1");
    test_class_info(&lv, &cd_S7682C17);
    dp->~S7682C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7682C17(Test_S7682C17, "S7682C17", ABISELECT(192,124));

#else // __cplusplus

extern void _ZN8S7682C17C1Ev();
extern void _ZN8S7682C17D1Ev();
Name_Map name_map_S7682C17[] = {
  NSPAIR(_ZN8S7682C17C1Ev),
  NSPAIR(_ZN8S7682C17D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S7682C17[];
extern void _ZN8S7682C173v72Ev();
extern void _ZN8S7682C173v73Ev();
extern void _ZN8S7682C173v74Ev();
extern void _ZN8S7682C173v75Ev();
extern void _ZN8S7682C173v76Ev();
extern void _ZN8S7682C173v77Ev();
static  VTBL_ENTRY vtc_S7682C17[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7682C17[0]),
  (VTBL_ENTRY)&_ZN8S7682C173v72Ev,
  (VTBL_ENTRY)&_ZN8S7682C173v73Ev,
  (VTBL_ENTRY)&_ZN8S7682C173v74Ev,
  (VTBL_ENTRY)&_ZN8S7682C173v75Ev,
  (VTBL_ENTRY)&_ZN8S7682C173v76Ev,
  (VTBL_ENTRY)&_ZN8S7682C173v77Ev,
};
extern VTBL_ENTRY _ZTI8S7682C17[];
extern  VTBL_ENTRY _ZTV8S7682C17[];
Class_Descriptor cd_S7682C17 = {  "S7682C17", // class name
  0,0,//no base classes
  &(vtc_S7682C17[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,124), // object size
  NSPAIRA(_ZTI8S7682C17),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S7682C17),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7682C1  : S7682C2 , S7682C5 , virtual S7682C7 , S7682C16 , S7682C10 {
  ::S7682C17 s7682c1f0;
  virtual void  v1(); // _ZN7S7682C12v1Ev
  virtual void  v2(); // _ZN7S7682C12v2Ev
  virtual void  v3(); // _ZN7S7682C12v3Ev
  virtual void  v4(); // _ZN7S7682C12v4Ev
  virtual void  v5(); // _ZN7S7682C12v5Ev
  virtual void  v6(); // _ZN7S7682C12v6Ev
  virtual void  v7(); // _ZN7S7682C12v7Ev
  ~S7682C1(); // tgen
  S7682C1(); // tgen
};
//SIG(1 S7682C1) C1{ BC2{ VBC3{ v8 v9 v10 v11 Fs:13 Fp FD[8]} BC4{ BC3 v12 v13 v14 Fp[6]} v15 v16 v17 v18 Fp} BC5{ BC6{ VBC2 vd v19 v20 v21 v22} v23 v24 v25 v26 v27 v28 FD} VBC7{ VBC8{ v29 v30 v31 v32} BC9{ v33 v34 v35 v36 v37 v38 v39 v40 v41 FC4[7]} BC10{ VBC8 VBC11{ VBC12{ VBC13{ VBC3 VBC4 v42 v43 v44 v45 v46 Fp[2]} BC2 v47 v48 v49 v50 FL[5] FC14{} FD} vd v51 v52} BC12 BC15{ VBC3 VBC13 VBC9 BC4 vd v53 v54 v55 v56 Fi} vd v57 v58 v59 v60 v61 v62 v63 v64 Fi[8] Fc FL}