// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S1409C5_nt  {
  int s1409c5f0[2];
  void  mf1409c5(); // _ZN10S1409C5_nt8mf1409c5Ev
};
//SIG(-1 S1409C5_nt) C1{ m Fi[2]}


void  S1409C5_nt ::mf1409c5(){}

//skip512 S1409C5_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1409C4_nt  {
  int s1409c4f0;
  __tsi64 s1409c4f1;
  void *s1409c4f2[4];
  int s1409c4f3[2];
  void *s1409c4f4;
  ::S1409C5_nt s1409c4f5;
  void *s1409c4f6[2];
  virtual  ~S1409C4_nt(); // _ZN10S1409C4_ntD1Ev
  virtual void  v4(); // _ZN10S1409C4_nt2v4Ev
  virtual void  v5(); // _ZN10S1409C4_nt2v5Ev
  virtual void  v6(); // _ZN10S1409C4_nt2v6Ev
  virtual void  v7(); // _ZN10S1409C4_nt2v7Ev
  virtual void  v8(); // _ZN10S1409C4_nt2v8Ev
  virtual void  v9(); // _ZN10S1409C4_nt2v9Ev
  virtual void  v10(); // _ZN10S1409C4_nt3v10Ev
  virtual void  v11(); // _ZN10S1409C4_nt3v11Ev
  virtual void  v12(); // _ZN10S1409C4_nt3v12Ev
  virtual void  v13(); // _ZN10S1409C4_nt3v13Ev
  virtual void  v14(); // _ZN10S1409C4_nt3v14Ev
  virtual void  v15(); // _ZN10S1409C4_nt3v15Ev
  virtual void  v16(); // _ZN10S1409C4_nt3v16Ev
  virtual void  v17(); // _ZN10S1409C4_nt3v17Ev
  virtual void  v18(); // _ZN10S1409C4_nt3v18Ev
  virtual void  v19(); // _ZN10S1409C4_nt3v19Ev
  virtual void  v20(); // _ZN10S1409C4_nt3v20Ev
  virtual void  v21(); // _ZN10S1409C4_nt3v21Ev
  virtual void  v22(); // _ZN10S1409C4_nt3v22Ev
  virtual void  v23(); // _ZN10S1409C4_nt3v23Ev
  virtual void  v24(); // _ZN10S1409C4_nt3v24Ev
  virtual void  v25(); // _ZN10S1409C4_nt3v25Ev
  virtual void  v26(); // _ZN10S1409C4_nt3v26Ev
  virtual void  v27(); // _ZN10S1409C4_nt3v27Ev
  virtual void  v28(); // _ZN10S1409C4_nt3v28Ev
  virtual void  v29(); // _ZN10S1409C4_nt3v29Ev
  virtual void  v30(); // _ZN10S1409C4_nt3v30Ev
  virtual void  v31(); // _ZN10S1409C4_nt3v31Ev
  virtual void  v32(); // _ZN10S1409C4_nt3v32Ev
  virtual void  v33(); // _ZN10S1409C4_nt3v33Ev
  virtual void  v34(); // _ZN10S1409C4_nt3v34Ev
  virtual void  v35(); // _ZN10S1409C4_nt3v35Ev
  virtual void  v36(); // _ZN10S1409C4_nt3v36Ev
  virtual void  v37(); // _ZN10S1409C4_nt3v37Ev
  virtual void  v38(); // _ZN10S1409C4_nt3v38Ev
  virtual void  v39(); // _ZN10S1409C4_nt3v39Ev
  virtual void  v40(); // _ZN10S1409C4_nt3v40Ev
  virtual void  v41(); // _ZN10S1409C4_nt3v41Ev
  virtual void  v42(); // _ZN10S1409C4_nt3v42Ev
  virtual void  v43(); // _ZN10S1409C4_nt3v43Ev
  virtual void  v44(); // _ZN10S1409C4_nt3v44Ev
  virtual void  v45(); // _ZN10S1409C4_nt3v45Ev
  virtual void  v46(); // _ZN10S1409C4_nt3v46Ev
  virtual void  v47(); // _ZN10S1409C4_nt3v47Ev
  virtual void  v48(); // _ZN10S1409C4_nt3v48Ev
  virtual void  v49(); // _ZN10S1409C4_nt3v49Ev
  virtual void  v50(); // _ZN10S1409C4_nt3v50Ev
  virtual void  v51(); // _ZN10S1409C4_nt3v51Ev
  virtual void  v52(); // _ZN10S1409C4_nt3v52Ev
  virtual void  v53(); // _ZN10S1409C4_nt3v53Ev
  virtual void  v54(); // _ZN10S1409C4_nt3v54Ev
  virtual void  v55(); // _ZN10S1409C4_nt3v55Ev
  virtual void  v56(); // _ZN10S1409C4_nt3v56Ev
  virtual void  v57(); // _ZN10S1409C4_nt3v57Ev
  virtual void  v58(); // _ZN10S1409C4_nt3v58Ev
  virtual void  v59(); // _ZN10S1409C4_nt3v59Ev
  virtual void  v60(); // _ZN10S1409C4_nt3v60Ev
  virtual void  v61(); // _ZN10S1409C4_nt3v61Ev
  virtual void  v62(); // _ZN10S1409C4_nt3v62Ev
  virtual void  v63(); // _ZN10S1409C4_nt3v63Ev
  virtual void  v64(); // _ZN10S1409C4_nt3v64Ev
  virtual void  v65(); // _ZN10S1409C4_nt3v65Ev
  virtual void  v66(); // _ZN10S1409C4_nt3v66Ev
  virtual void  v67(); // _ZN10S1409C4_nt3v67Ev
  S1409C4_nt(); // tgen
};
//SIG(-1 S1409C4_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1409C4_nt ::~S1409C4_nt(){ note_dtor("S1409C4_nt", this);}
void  S1409C4_nt ::v4(){vfunc_called(this, "_ZN10S1409C4_nt2v4Ev");}
void  S1409C4_nt ::v5(){vfunc_called(this, "_ZN10S1409C4_nt2v5Ev");}
void  S1409C4_nt ::v6(){vfunc_called(this, "_ZN10S1409C4_nt2v6Ev");}
void  S1409C4_nt ::v7(){vfunc_called(this, "_ZN10S1409C4_nt2v7Ev");}
void  S1409C4_nt ::v8(){vfunc_called(this, "_ZN10S1409C4_nt2v8Ev");}
void  S1409C4_nt ::v9(){vfunc_called(this, "_ZN10S1409C4_nt2v9Ev");}
void  S1409C4_nt ::v10(){vfunc_called(this, "_ZN10S1409C4_nt3v10Ev");}
void  S1409C4_nt ::v11(){vfunc_called(this, "_ZN10S1409C4_nt3v11Ev");}
void  S1409C4_nt ::v12(){vfunc_called(this, "_ZN10S1409C4_nt3v12Ev");}
void  S1409C4_nt ::v13(){vfunc_called(this, "_ZN10S1409C4_nt3v13Ev");}
void  S1409C4_nt ::v14(){vfunc_called(this, "_ZN10S1409C4_nt3v14Ev");}
void  S1409C4_nt ::v15(){vfunc_called(this, "_ZN10S1409C4_nt3v15Ev");}
void  S1409C4_nt ::v16(){vfunc_called(this, "_ZN10S1409C4_nt3v16Ev");}
void  S1409C4_nt ::v17(){vfunc_called(this, "_ZN10S1409C4_nt3v17Ev");}
void  S1409C4_nt ::v18(){vfunc_called(this, "_ZN10S1409C4_nt3v18Ev");}
void  S1409C4_nt ::v19(){vfunc_called(this, "_ZN10S1409C4_nt3v19Ev");}
void  S1409C4_nt ::v20(){vfunc_called(this, "_ZN10S1409C4_nt3v20Ev");}
void  S1409C4_nt ::v21(){vfunc_called(this, "_ZN10S1409C4_nt3v21Ev");}
void  S1409C4_nt ::v22(){vfunc_called(this, "_ZN10S1409C4_nt3v22Ev");}
void  S1409C4_nt ::v23(){vfunc_called(this, "_ZN10S1409C4_nt3v23Ev");}
void  S1409C4_nt ::v24(){vfunc_called(this, "_ZN10S1409C4_nt3v24Ev");}
void  S1409C4_nt ::v25(){vfunc_called(this, "_ZN10S1409C4_nt3v25Ev");}
void  S1409C4_nt ::v26(){vfunc_called(this, "_ZN10S1409C4_nt3v26Ev");}
void  S1409C4_nt ::v27(){vfunc_called(this, "_ZN10S1409C4_nt3v27Ev");}
void  S1409C4_nt ::v28(){vfunc_called(this, "_ZN10S1409C4_nt3v28Ev");}
void  S1409C4_nt ::v29(){vfunc_called(this, "_ZN10S1409C4_nt3v29Ev");}
void  S1409C4_nt ::v30(){vfunc_called(this, "_ZN10S1409C4_nt3v30Ev");}
void  S1409C4_nt ::v31(){vfunc_called(this, "_ZN10S1409C4_nt3v31Ev");}
void  S1409C4_nt ::v32(){vfunc_called(this, "_ZN10S1409C4_nt3v32Ev");}
void  S1409C4_nt ::v33(){vfunc_called(this, "_ZN10S1409C4_nt3v33Ev");}
void  S1409C4_nt ::v34(){vfunc_called(this, "_ZN10S1409C4_nt3v34Ev");}
void  S1409C4_nt ::v35(){vfunc_called(this, "_ZN10S1409C4_nt3v35Ev");}
void  S1409C4_nt ::v36(){vfunc_called(this, "_ZN10S1409C4_nt3v36Ev");}
void  S1409C4_nt ::v37(){vfunc_called(this, "_ZN10S1409C4_nt3v37Ev");}
void  S1409C4_nt ::v38(){vfunc_called(this, "_ZN10S1409C4_nt3v38Ev");}
void  S1409C4_nt ::v39(){vfunc_called(this, "_ZN10S1409C4_nt3v39Ev");}
void  S1409C4_nt ::v40(){vfunc_called(this, "_ZN10S1409C4_nt3v40Ev");}
void  S1409C4_nt ::v41(){vfunc_called(this, "_ZN10S1409C4_nt3v41Ev");}
void  S1409C4_nt ::v42(){vfunc_called(this, "_ZN10S1409C4_nt3v42Ev");}
void  S1409C4_nt ::v43(){vfunc_called(this, "_ZN10S1409C4_nt3v43Ev");}
void  S1409C4_nt ::v44(){vfunc_called(this, "_ZN10S1409C4_nt3v44Ev");}
void  S1409C4_nt ::v45(){vfunc_called(this, "_ZN10S1409C4_nt3v45Ev");}
void  S1409C4_nt ::v46(){vfunc_called(this, "_ZN10S1409C4_nt3v46Ev");}
void  S1409C4_nt ::v47(){vfunc_called(this, "_ZN10S1409C4_nt3v47Ev");}
void  S1409C4_nt ::v48(){vfunc_called(this, "_ZN10S1409C4_nt3v48Ev");}
void  S1409C4_nt ::v49(){vfunc_called(this, "_ZN10S1409C4_nt3v49Ev");}
void  S1409C4_nt ::v50(){vfunc_called(this, "_ZN10S1409C4_nt3v50Ev");}
void  S1409C4_nt ::v51(){vfunc_called(this, "_ZN10S1409C4_nt3v51Ev");}
void  S1409C4_nt ::v52(){vfunc_called(this, "_ZN10S1409C4_nt3v52Ev");}
void  S1409C4_nt ::v53(){vfunc_called(this, "_ZN10S1409C4_nt3v53Ev");}
void  S1409C4_nt ::v54(){vfunc_called(this, "_ZN10S1409C4_nt3v54Ev");}
void  S1409C4_nt ::v55(){vfunc_called(this, "_ZN10S1409C4_nt3v55Ev");}
void  S1409C4_nt ::v56(){vfunc_called(this, "_ZN10S1409C4_nt3v56Ev");}
void  S1409C4_nt ::v57(){vfunc_called(this, "_ZN10S1409C4_nt3v57Ev");}
void  S1409C4_nt ::v58(){vfunc_called(this, "_ZN10S1409C4_nt3v58Ev");}
void  S1409C4_nt ::v59(){vfunc_called(this, "_ZN10S1409C4_nt3v59Ev");}
void  S1409C4_nt ::v60(){vfunc_called(this, "_ZN10S1409C4_nt3v60Ev");}
void  S1409C4_nt ::v61(){vfunc_called(this, "_ZN10S1409C4_nt3v61Ev");}
void  S1409C4_nt ::v62(){vfunc_called(this, "_ZN10S1409C4_nt3v62Ev");}
void  S1409C4_nt ::v63(){vfunc_called(this, "_ZN10S1409C4_nt3v63Ev");}
void  S1409C4_nt ::v64(){vfunc_called(this, "_ZN10S1409C4_nt3v64Ev");}
void  S1409C4_nt ::v65(){vfunc_called(this, "_ZN10S1409C4_nt3v65Ev");}
void  S1409C4_nt ::v66(){vfunc_called(this, "_ZN10S1409C4_nt3v66Ev");}
void  S1409C4_nt ::v67(){vfunc_called(this, "_ZN10S1409C4_nt3v67Ev");}
S1409C4_nt ::S1409C4_nt(){ note_ctor("S1409C4_nt", this);} // tgen

//skip512 S1409C4_nt

#else // __cplusplus

extern void _ZN10S1409C4_ntC1Ev();
extern void _ZN10S1409C4_ntD1Ev();
Name_Map name_map_S1409C4_nt[] = {
  NSPAIR(_ZN10S1409C4_ntC1Ev),
  NSPAIR(_ZN10S1409C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S1409C4_nt[];
extern void _ZN10S1409C4_ntD1Ev();
extern void _ZN10S1409C4_ntD0Ev();
extern void _ZN10S1409C4_nt2v4Ev();
extern void _ZN10S1409C4_nt2v5Ev();
extern void _ZN10S1409C4_nt2v6Ev();
extern void _ZN10S1409C4_nt2v7Ev();
extern void _ZN10S1409C4_nt2v8Ev();
extern void _ZN10S1409C4_nt2v9Ev();
extern void _ZN10S1409C4_nt3v10Ev();
extern void _ZN10S1409C4_nt3v11Ev();
extern void _ZN10S1409C4_nt3v12Ev();
extern void _ZN10S1409C4_nt3v13Ev();
extern void _ZN10S1409C4_nt3v14Ev();
extern void _ZN10S1409C4_nt3v15Ev();
extern void _ZN10S1409C4_nt3v16Ev();
extern void _ZN10S1409C4_nt3v17Ev();
extern void _ZN10S1409C4_nt3v18Ev();
extern void _ZN10S1409C4_nt3v19Ev();
extern void _ZN10S1409C4_nt3v20Ev();
extern void _ZN10S1409C4_nt3v21Ev();
extern void _ZN10S1409C4_nt3v22Ev();
extern void _ZN10S1409C4_nt3v23Ev();
extern void _ZN10S1409C4_nt3v24Ev();
extern void _ZN10S1409C4_nt3v25Ev();
extern void _ZN10S1409C4_nt3v26Ev();
extern void _ZN10S1409C4_nt3v27Ev();
extern void _ZN10S1409C4_nt3v28Ev();
extern void _ZN10S1409C4_nt3v29Ev();
extern void _ZN10S1409C4_nt3v30Ev();
extern void _ZN10S1409C4_nt3v31Ev();
extern void _ZN10S1409C4_nt3v32Ev();
extern void _ZN10S1409C4_nt3v33Ev();
extern void _ZN10S1409C4_nt3v34Ev();
extern void _ZN10S1409C4_nt3v35Ev();
extern void _ZN10S1409C4_nt3v36Ev();
extern void _ZN10S1409C4_nt3v37Ev();
extern void _ZN10S1409C4_nt3v38Ev();
extern void _ZN10S1409C4_nt3v39Ev();
extern void _ZN10S1409C4_nt3v40Ev();
extern void _ZN10S1409C4_nt3v41Ev();
extern void _ZN10S1409C4_nt3v42Ev();
extern void _ZN10S1409C4_nt3v43Ev();
extern void _ZN10S1409C4_nt3v44Ev();
extern void _ZN10S1409C4_nt3v45Ev();
extern void _ZN10S1409C4_nt3v46Ev();
extern void _ZN10S1409C4_nt3v47Ev();
extern void _ZN10S1409C4_nt3v48Ev();
extern void _ZN10S1409C4_nt3v49Ev();
extern void _ZN10S1409C4_nt3v50Ev();
extern void _ZN10S1409C4_nt3v51Ev();
extern void _ZN10S1409C4_nt3v52Ev();
extern void _ZN10S1409C4_nt3v53Ev();
extern void _ZN10S1409C4_nt3v54Ev();
extern void _ZN10S1409C4_nt3v55Ev();
extern void _ZN10S1409C4_nt3v56Ev();
extern void _ZN10S1409C4_nt3v57Ev();
extern void _ZN10S1409C4_nt3v58Ev();
extern void _ZN10S1409C4_nt3v59Ev();
extern void _ZN10S1409C4_nt3v60Ev();
extern void _ZN10S1409C4_nt3v61Ev();
extern void _ZN10S1409C4_nt3v62Ev();
extern void _ZN10S1409C4_nt3v63Ev();
extern void _ZN10S1409C4_nt3v64Ev();
extern void _ZN10S1409C4_nt3v65Ev();
extern void _ZN10S1409C4_nt3v66Ev();
extern void _ZN10S1409C4_nt3v67Ev();
static  VTBL_ENTRY vtc_S1409C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1409C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S1409C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v67Ev,
};
extern VTBL_ENTRY _ZTI10S1409C4_nt[];
VTBL_ENTRY *P__ZTI10S1409C4_nt = _ZTI10S1409C4_nt; 
extern  VTBL_ENTRY _ZTV10S1409C4_nt[];
Class_Descriptor cd_S1409C4_nt = {  "S1409C4_nt", // class name
  0,0,//no base classes
  &(vtc_S1409C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI10S1409C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S1409C4_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1409C8_nt  {
  void *s1409c8f0;
  int s1409c8f1[2];
  void  mf1409c8(); // _ZN10S1409C8_nt8mf1409c8Ev
};
//SIG(-1 S1409C8_nt) C1{ m Fp Fi[2]}


void  S1409C8_nt ::mf1409c8(){}

//skip512 S1409C8_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S1409C8_nt[];
VTBL_ENTRY *P__ZTI10S1409C8_nt = _ZTI10S1409C8_nt; 
Class_Descriptor cd_S1409C8_nt = {  "S1409C8_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  NSPAIRA(_ZTI10S1409C8_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1409C7_nt  : S1409C8_nt {
};
//SIG(-1 S1409C7_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S1409C7_nt

#else // __cplusplus

extern Class_Descriptor cd_S1409C8_nt;
extern VTBL_ENTRY _ZTI10S1409C8_nt[];
static Base_Class bases_S1409C7_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1409C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1409C7_nt = {  "S1409C7_nt", // class name
  bases_S1409C7_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1409C6_nt  : S1409C7_nt {
};
//SIG(-1 S1409C6_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S1409C6_nt

#else // __cplusplus

extern Class_Descriptor cd_S1409C8_nt;
extern VTBL_ENTRY _ZTI10S1409C8_nt[];
extern Class_Descriptor cd_S1409C7_nt;
static Base_Class bases_S1409C6_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1409C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1409C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1409C9_nt  {
  int s1409c9f0;
  void  mf1409c9(); // _ZN10S1409C9_nt8mf1409c9Ev
};
//SIG(-1 S1409C9_nt) C1{ m Fi}


void  S1409C9_nt ::mf1409c9(){}

//skip512 S1409C9_nt

#else // __cplusplus

Class_Descriptor cd_S1409C9_nt = {  "S1409C9_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1409C13  : S1409C8_nt {
};
//SIG(-1 S1409C13) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1409C13()
{
  extern Class_Descriptor cd_S1409C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1409C13, buf);
    S1409C13 &lv = *(new (buf) S1409C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1409C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1409C13)");
    check_base_class_offset(lv, (S1409C8_nt*), 0, "S1409C13");
    test_class_info(&lv, &cd_S1409C13);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1409C13(Test_S1409C13, "S1409C13", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1409C8_nt;
extern VTBL_ENTRY _ZTI10S1409C8_nt[];
static Base_Class bases_S1409C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1409C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1409C13 = {  "S1409C13", // class name
  bases_S1409C13, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1409C12  : S1409C13 {
};
//SIG(-1 S1409C12) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1409C12()
{
  extern Class_Descriptor cd_S1409C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1409C12, buf);
    S1409C12 &lv = *(new (buf) S1409C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1409C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1409C12)");
    check_base_class_offset(lv, (S1409C8_nt*)(S1409C13*), 0, "S1409C12");
    check_base_class_offset(lv, (S1409C13*), 0, "S1409C12");
    test_class_info(&lv, &cd_S1409C12);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1409C12(Test_S1409C12, "S1409C12", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1409C8_nt;
extern VTBL_ENTRY _ZTI10S1409C8_nt[];
extern Class_Descriptor cd_S1409C13;
static Base_Class bases_S1409C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1409C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1409C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1409C12 = {  "S1409C12", // class name
  bases_S1409C12, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1409C14_nt  {
  int s1409c14f0[3];
  void  mf1409c14(); // _ZN11S1409C14_nt9mf1409c14Ev
};
//SIG(-1 S1409C14_nt) C1{ m Fi[3]}


void  S1409C14_nt ::mf1409c14(){}

//skip512 S1409C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1409C19  : S1409C8_nt {
};
//SIG(-1 S1409C19) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1409C19()
{
  extern Class_Descriptor cd_S1409C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1409C19, buf);
    S1409C19 &lv = *(new (buf) S1409C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1409C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1409C19)");
    check_base_class_offset(lv, (S1409C8_nt*), 0, "S1409C19");
    test_class_info(&lv, &cd_S1409C19);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1409C19(Test_S1409C19, "S1409C19", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1409C8_nt;
extern VTBL_ENTRY _ZTI10S1409C8_nt[];
static Base_Class bases_S1409C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1409C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1409C19 = {  "S1409C19", // class name
  bases_S1409C19, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1409C18  : S1409C19 {
};
//SIG(-1 S1409C18) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1409C18()
{
  extern Class_Descriptor cd_S1409C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1409C18, buf);
    S1409C18 &lv = *(new (buf) S1409C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1409C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1409C18)");
    check_base_class_offset(lv, (S1409C8_nt*)(S1409C19*), 0, "S1409C18");
    check_base_class_offset(lv, (S1409C19*), 0, "S1409C18");
    test_class_info(&lv, &cd_S1409C18);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1409C18(Test_S1409C18, "S1409C18", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1409C8_nt;
extern VTBL_ENTRY _ZTI10S1409C8_nt[];
extern Class_Descriptor cd_S1409C19;
static Base_Class bases_S1409C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1409C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1409C19,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1409C18 = {  "S1409C18", // class name
  bases_S1409C18, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1409C3_nt  : S1409C4_nt {
  ::S1409C6_nt s1409c3f0;
  ::S1409C6_nt s1409c3f1;
  ::S1409C9_nt s1409c3f2;
  int s1409c3f3;
  char s1409c3f4[4];
  void *s1409c3f5[2];
  ::S1409C6_nt s1409c3f6;
  unsigned int s1409c3f7:1;
  unsigned int s1409c3f8:1;
  unsigned int s1409c3f9:1;
  unsigned int s1409c3f10:1;
  unsigned int s1409c3f11:1;
  unsigned int s1409c3f12:1;
  unsigned int s1409c3f13:1;
  unsigned int s1409c3f14:1;
  unsigned int s1409c3f15:1;
  unsigned int s1409c3f16:1;
  unsigned int s1409c3f17:1;
  unsigned int s1409c3f18:1;
  unsigned int s1409c3f19:1;
  unsigned int s1409c3f20:1;
  unsigned int s1409c3f21:1;
  unsigned int s1409c3f22:1;
  unsigned int s1409c3f23:1;
  unsigned int s1409c3f24:1;
  unsigned int s1409c3f25:1;
  unsigned int s1409c3f26:1;
  unsigned int s1409c3f27:1;
  unsigned int s1409c3f28:1;
  unsigned int s1409c3f29:1;
  unsigned int s1409c3f30:1;
  unsigned int s1409c3f31:1;
  unsigned int s1409c3f32:1;
  unsigned int s1409c3f33:1;
  unsigned int s1409c3f34:1;
  unsigned int s1409c3f35:1;
  unsigned int s1409c3f36:1;
  unsigned int s1409c3f37:1;
  unsigned int s1409c3f38:1;
  unsigned int s1409c3f39:1;
  unsigned int s1409c3f40:1;
  unsigned int s1409c3f41:1;
  unsigned int s1409c3f42:1;
  unsigned int s1409c3f43:1;
  unsigned int s1409c3f44:1;
  unsigned int s1409c3f45:1;
  unsigned int s1409c3f46:1;
  unsigned int s1409c3f47:1;
  unsigned int s1409c3f48:1;
  unsigned int s1409c3f49:1;
  unsigned int s1409c3f50:1;
  unsigned int s1409c3f51:1;
  unsigned int s1409c3f52:1;
  unsigned int s1409c3f53:1;
  unsigned int s1409c3f54:1;
  unsigned int s1409c3f55:1;
  unsigned int s1409c3f56:1;
  unsigned int s1409c3f57:1;
  unsigned int s1409c3f58:1;
  unsigned int s1409c3f59:1;
  unsigned int s1409c3f60:1;
  unsigned int s1409c3f61:1;
  unsigned int s1409c3f62:1;
  unsigned int s1409c3f63:1;
  unsigned int s1409c3f64:1;
  unsigned int s1409c3f65:1;
  unsigned int s1409c3f66:1;
  unsigned int s1409c3f67:1;
  unsigned int s1409c3f68:1;
  unsigned int s1409c3f69:1;
  unsigned int s1409c3f70:1;
  unsigned int s1409c3f71:1;
  unsigned int s1409c3f72:1;
  unsigned int s1409c3f73:1;
  unsigned int s1409c3f74:1;
  unsigned int s1409c3f75:1;
  unsigned int s1409c3f76:1;
  unsigned int s1409c3f77:1;
  unsigned int s1409c3f78:1;
  unsigned int s1409c3f79:1;
  unsigned int s1409c3f80:1;
  unsigned int s1409c3f81:1;
  unsigned int s1409c3f82:1;
  unsigned int s1409c3f83:1;
  int s1409c3f84[5];
  void *s1409c3f85[2];
  int s1409c3f86[3];
  ::S1409C5_nt s1409c3f87;
  ::S1409C5_nt s1409c3f88;
  ::S1409C5_nt s1409c3f89;
  ::S1409C12 s1409c3f90;
  ::S1409C12 s1409c3f91;
  int s1409c3f92;
  void *s1409c3f93[2];
  ::S1409C14_nt s1409c3f94;
  ::S1409C14_nt s1409c3f95;
  ::S1409C14_nt s1409c3f96;
  ::S1409C14_nt s1409c3f97;
  void *s1409c3f98;
  ::S1409C5_nt s1409c3f99;
  ::S1409C12 s1409c3f100;
  ::S1409C14_nt s1409c3f101;
  ::S1409C14_nt s1409c3f102;
  int s1409c3f103;
  ::S1409C14_nt s1409c3f104;
  ::S1409C14_nt s1409c3f105;
  void *s1409c3f106;
  int s1409c3f107;
  char s1409c3f108;
  ::S1409C14_nt s1409c3f109;
  ::S1409C14_nt s1409c3f110;
  void *s1409c3f111;
  int s1409c3f112;
  void *s1409c3f113;
  ::S1409C12 s1409c3f114;
  ::S1409C18 s1409c3f115;
  ::S1409C18 s1409c3f116;
  virtual  ~S1409C3_nt(); // _ZN10S1409C3_ntD1Ev
  virtual void  v68(); // _ZN10S1409C3_nt3v68Ev
  virtual void  v69(); // _ZN10S1409C3_nt3v69Ev
  virtual void  v70(); // _ZN10S1409C3_nt3v70Ev
  virtual void  v71(); // _ZN10S1409C3_nt3v71Ev
  virtual void  v72(); // _ZN10S1409C3_nt3v72Ev
  virtual void  v73(); // _ZN10S1409C3_nt3v73Ev
  virtual void  v74(); // _ZN10S1409C3_nt3v74Ev
  virtual void  v75(); // _ZN10S1409C3_nt3v75Ev
  virtual void  v76(); // _ZN10S1409C3_nt3v76Ev
  virtual void  v77(); // _ZN10S1409C3_nt3v77Ev
  virtual void  v78(); // _ZN10S1409C3_nt3v78Ev
  virtual void  v79(); // _ZN10S1409C3_nt3v79Ev
  virtual void  v80(); // _ZN10S1409C3_nt3v80Ev
  virtual void  v81(); // _ZN10S1409C3_nt3v81Ev
  virtual void  v82(); // _ZN10S1409C3_nt3v82Ev
  virtual void  v83(); // _ZN10S1409C3_nt3v83Ev
  virtual void  v84(); // _ZN10S1409C3_nt3v84Ev
  virtual void  v85(); // _ZN10S1409C3_nt3v85Ev
  virtual void  v86(); // _ZN10S1409C3_nt3v86Ev
  virtual void  v87(); // _ZN10S1409C3_nt3v87Ev
  virtual void  v88(); // _ZN10S1409C3_nt3v88Ev
  virtual void  v89(); // _ZN10S1409C3_nt3v89Ev
  virtual void  v90(); // _ZN10S1409C3_nt3v90Ev
  virtual void  v91(); // _ZN10S1409C3_nt3v91Ev
  virtual void  v92(); // _ZN10S1409C3_nt3v92Ev
  virtual void  v93(); // _ZN10S1409C3_nt3v93Ev
  virtual void  v94(); // _ZN10S1409C3_nt3v94Ev
  virtual void  v95(); // _ZN10S1409C3_nt3v95Ev
  virtual void  v96(); // _ZN10S1409C3_nt3v96Ev
  virtual void  v97(); // _ZN10S1409C3_nt3v97Ev
  virtual void  v98(); // _ZN10S1409C3_nt3v98Ev
  virtual void  v99(); // _ZN10S1409C3_nt3v99Ev
  virtual void  v100(); // _ZN10S1409C3_nt4v100Ev
  virtual void  v101(); // _ZN10S1409C3_nt4v101Ev
  virtual void  v102(); // _ZN10S1409C3_nt4v102Ev
  virtual void  v103(); // _ZN10S1409C3_nt4v103Ev
  virtual void  v104(); // _ZN10S1409C3_nt4v104Ev
  virtual void  v105(); // _ZN10S1409C3_nt4v105Ev
  virtual void  v106(); // _ZN10S1409C3_nt4v106Ev
  virtual void  v107(); // _ZN10S1409C3_nt4v107Ev
  virtual void  v108(); // _ZN10S1409C3_nt4v108Ev
  virtual void  v109(); // _ZN10S1409C3_nt4v109Ev
  virtual void  v110(); // _ZN10S1409C3_nt4v110Ev
  virtual void  v111(); // _ZN10S1409C3_nt4v111Ev
  virtual void  v112(); // _ZN10S1409C3_nt4v112Ev
  virtual void  v113(); // _ZN10S1409C3_nt4v113Ev
  virtual void  v114(); // _ZN10S1409C3_nt4v114Ev
  virtual void  v115(); // _ZN10S1409C3_nt4v115Ev
  virtual void  v116(); // _ZN10S1409C3_nt4v116Ev
  virtual void  v117(); // _ZN10S1409C3_nt4v117Ev
  virtual void  v118(); // _ZN10S1409C3_nt4v118Ev
  virtual void  v119(); // _ZN10S1409C3_nt4v119Ev
  virtual void  v120(); // _ZN10S1409C3_nt4v120Ev
  virtual void  v121(); // _ZN10S1409C3_nt4v121Ev
  virtual void  v122(); // _ZN10S1409C3_nt4v122Ev
  virtual void  v123(); // _ZN10S1409C3_nt4v123Ev
  virtual void  v124(); // _ZN10S1409C3_nt4v124Ev
  virtual void  v125(); // _ZN10S1409C3_nt4v125Ev
  virtual void  v126(); // _ZN10S1409C3_nt4v126Ev
  virtual void  v127(); // _ZN10S1409C3_nt4v127Ev
  virtual void  v128(); // _ZN10S1409C3_nt4v128Ev
  virtual void  v129(); // _ZN10S1409C3_nt4v129Ev
  virtual void  v130(); // _ZN10S1409C3_nt4v130Ev
  virtual void  v131(); // _ZN10S1409C3_nt4v131Ev
  virtual void  v132(); // _ZN10S1409C3_nt4v132Ev
  virtual void  v133(); // _ZN10S1409C3_nt4v133Ev
  virtual void  v134(); // _ZN10S1409C3_nt4v134Ev
  virtual void  v135(); // _ZN10S1409C3_nt4v135Ev
  virtual void  v136(); // _ZN10S1409C3_nt4v136Ev
  virtual void  v137(); // _ZN10S1409C3_nt4v137Ev
  virtual void  v138(); // _ZN10S1409C3_nt4v138Ev
  virtual void  v139(); // _ZN10S1409C3_nt4v139Ev
  virtual void  v140(); // _ZN10S1409C3_nt4v140Ev
  virtual void  v141(); // _ZN10S1409C3_nt4v141Ev
  virtual void  v142(); // _ZN10S1409C3_nt4v142Ev
  virtual void  v143(); // _ZN10S1409C3_nt4v143Ev
  virtual void  v144(); // _ZN10S1409C3_nt4v144Ev
  virtual void  v145(); // _ZN10S1409C3_nt4v145Ev
  virtual void  v146(); // _ZN10S1409C3_nt4v146Ev
  virtual void  v147(); // _ZN10S1409C3_nt4v147Ev
  virtual void  v148(); // _ZN10S1409C3_nt4v148Ev
  virtual void  v149(); // _ZN10S1409C3_nt4v149Ev
  virtual void  v150(); // _ZN10S1409C3_nt4v150Ev
  virtual void  v151(); // _ZN10S1409C3_nt4v151Ev
  virtual void  v152(); // _ZN10S1409C3_nt4v152Ev
  virtual void  v153(); // _ZN10S1409C3_nt4v153Ev
  virtual void  v154(); // _ZN10S1409C3_nt4v154Ev
  virtual void  v155(); // _ZN10S1409C3_nt4v155Ev
  virtual void  v156(); // _ZN10S1409C3_nt4v156Ev
  virtual void  v157(); // _ZN10S1409C3_nt4v157Ev
  virtual void  v158(); // _ZN10S1409C3_nt4v158Ev
  virtual void  v159(); // _ZN10S1409C3_nt4v159Ev
  virtual void  v160(); // _ZN10S1409C3_nt4v160Ev
  virtual void  v161(); // _ZN10S1409C3_nt4v161Ev
  virtual void  v162(); // _ZN10S1409C3_nt4v162Ev
  virtual void  v163(); // _ZN10S1409C3_nt4v163Ev
  virtual void  v164(); // _ZN10S1409C3_nt4v164Ev
  virtual void  v165(); // _ZN10S1409C3_nt4v165Ev
  virtual void  v166(); // _ZN10S1409C3_nt4v166Ev
  virtual void  v167(); // _ZN10S1409C3_nt4v167Ev
  virtual void  v168(); // _ZN10S1409C3_nt4v168Ev
  virtual void  v169(); // _ZN10S1409C3_nt4v169Ev
  virtual void  v170(); // _ZN10S1409C3_nt4v170Ev
  virtual void  v171(); // _ZN10S1409C3_nt4v171Ev
  virtual void  v172(); // _ZN10S1409C3_nt4v172Ev
  virtual void  v173(); // _ZN10S1409C3_nt4v173Ev
  virtual void  v174(); // _ZN10S1409C3_nt4v174Ev
  virtual void  v175(); // _ZN10S1409C3_nt4v175Ev
  virtual void  v176(); // _ZN10S1409C3_nt4v176Ev
  virtual void  v177(); // _ZN10S1409C3_nt4v177Ev
  virtual void  v178(); // _ZN10S1409C3_nt4v178Ev
  virtual void  v179(); // _ZN10S1409C3_nt4v179Ev
  virtual void  v180(); // _ZN10S1409C3_nt4v180Ev
  virtual void  v181(); // _ZN10S1409C3_nt4v181Ev
  virtual void  v182(); // _ZN10S1409C3_nt4v182Ev
  virtual void  v183(); // _ZN10S1409C3_nt4v183Ev
  virtual void  v184(); // _ZN10S1409C3_nt4v184Ev
  virtual void  v185(); // _ZN10S1409C3_nt4v185Ev
  virtual void  v186(); // _ZN10S1409C3_nt4v186Ev
  virtual void  v187(); // _ZN10S1409C3_nt4v187Ev
  virtual void  v188(); // _ZN10S1409C3_nt4v188Ev
  virtual void  v189(); // _ZN10S1409C3_nt4v189Ev
  virtual void  v190(); // _ZN10S1409C3_nt4v190Ev
  virtual void  v191(); // _ZN10S1409C3_nt4v191Ev
  virtual void  v192(); // _ZN10S1409C3_nt4v192Ev
  virtual void  v193(); // _ZN10S1409C3_nt4v193Ev
  virtual void  v194(); // _ZN10S1409C3_nt4v194Ev
  virtual void  v195(); // _ZN10S1409C3_nt4v195Ev
  virtual void  v196(); // _ZN10S1409C3_nt4v196Ev
  virtual void  v197(); // _ZN10S1409C3_nt4v197Ev
  virtual void  v198(); // _ZN10S1409C3_nt4v198Ev
  virtual void  v199(); // _ZN10S1409C3_nt4v199Ev
  virtual void  v200(); // _ZN10S1409C3_nt4v200Ev
  virtual void  v201(); // _ZN10S1409C3_nt4v201Ev
  virtual void  v202(); // _ZN10S1409C3_nt4v202Ev
  virtual void  v203(); // _ZN10S1409C3_nt4v203Ev
  virtual void  v204(); // _ZN10S1409C3_nt4v204Ev
  virtual void  v205(); // _ZN10S1409C3_nt4v205Ev
  virtual void  v206(); // _ZN10S1409C3_nt4v206Ev
  virtual void  v207(); // _ZN10S1409C3_nt4v207Ev
  virtual void  v208(); // _ZN10S1409C3_nt4v208Ev
  virtual void  v209(); // _ZN10S1409C3_nt4v209Ev
  virtual void  v210(); // _ZN10S1409C3_nt4v210Ev
  S1409C3_nt(); // tgen
};
//SIG(-1 S1409C3_nt) C1{ BC2{ vd v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 FC4{ BC5{ BC6{ m Fp Fi[2]}}} FC4 FC7{ m Fi} Fi Fc[4] Fp[2] FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC3 FC3 FC3 FC8{ BC9{ BC6}} FC8 Fi Fp[2] FC10{ m Fi[3]} FC10 FC10 FC10 Fp FC3 FC8 FC10 FC10 Fi FC10 FC10 Fp Fi Fc FC10 FC10 Fp Fi Fp FC8 FC11{ BC12{ BC6}} FC11}


 S1409C3_nt ::~S1409C3_nt(){ note_dtor("S1409C3_nt", this);}
void  S1409C3_nt ::v68(){vfunc_called(this, "_ZN10S1409C3_nt3v68Ev");}
void  S1409C3_nt ::v69(){vfunc_called(this, "_ZN10S1409C3_nt3v69Ev");}
void  S1409C3_nt ::v70(){vfunc_called(this, "_ZN10S1409C3_nt3v70Ev");}
void  S1409C3_nt ::v71(){vfunc_called(this, "_ZN10S1409C3_nt3v71Ev");}
void  S1409C3_nt ::v72(){vfunc_called(this, "_ZN10S1409C3_nt3v72Ev");}
void  S1409C3_nt ::v73(){vfunc_called(this, "_ZN10S1409C3_nt3v73Ev");}
void  S1409C3_nt ::v74(){vfunc_called(this, "_ZN10S1409C3_nt3v74Ev");}
void  S1409C3_nt ::v75(){vfunc_called(this, "_ZN10S1409C3_nt3v75Ev");}
void  S1409C3_nt ::v76(){vfunc_called(this, "_ZN10S1409C3_nt3v76Ev");}
void  S1409C3_nt ::v77(){vfunc_called(this, "_ZN10S1409C3_nt3v77Ev");}
void  S1409C3_nt ::v78(){vfunc_called(this, "_ZN10S1409C3_nt3v78Ev");}
void  S1409C3_nt ::v79(){vfunc_called(this, "_ZN10S1409C3_nt3v79Ev");}
void  S1409C3_nt ::v80(){vfunc_called(this, "_ZN10S1409C3_nt3v80Ev");}
void  S1409C3_nt ::v81(){vfunc_called(this, "_ZN10S1409C3_nt3v81Ev");}
void  S1409C3_nt ::v82(){vfunc_called(this, "_ZN10S1409C3_nt3v82Ev");}
void  S1409C3_nt ::v83(){vfunc_called(this, "_ZN10S1409C3_nt3v83Ev");}
void  S1409C3_nt ::v84(){vfunc_called(this, "_ZN10S1409C3_nt3v84Ev");}
void  S1409C3_nt ::v85(){vfunc_called(this, "_ZN10S1409C3_nt3v85Ev");}
void  S1409C3_nt ::v86(){vfunc_called(this, "_ZN10S1409C3_nt3v86Ev");}
void  S1409C3_nt ::v87(){vfunc_called(this, "_ZN10S1409C3_nt3v87Ev");}
void  S1409C3_nt ::v88(){vfunc_called(this, "_ZN10S1409C3_nt3v88Ev");}
void  S1409C3_nt ::v89(){vfunc_called(this, "_ZN10S1409C3_nt3v89Ev");}
void  S1409C3_nt ::v90(){vfunc_called(this, "_ZN10S1409C3_nt3v90Ev");}
void  S1409C3_nt ::v91(){vfunc_called(this, "_ZN10S1409C3_nt3v91Ev");}
void  S1409C3_nt ::v92(){vfunc_called(this, "_ZN10S1409C3_nt3v92Ev");}
void  S1409C3_nt ::v93(){vfunc_called(this, "_ZN10S1409C3_nt3v93Ev");}
void  S1409C3_nt ::v94(){vfunc_called(this, "_ZN10S1409C3_nt3v94Ev");}
void  S1409C3_nt ::v95(){vfunc_called(this, "_ZN10S1409C3_nt3v95Ev");}
void  S1409C3_nt ::v96(){vfunc_called(this, "_ZN10S1409C3_nt3v96Ev");}
void  S1409C3_nt ::v97(){vfunc_called(this, "_ZN10S1409C3_nt3v97Ev");}
void  S1409C3_nt ::v98(){vfunc_called(this, "_ZN10S1409C3_nt3v98Ev");}
void  S1409C3_nt ::v99(){vfunc_called(this, "_ZN10S1409C3_nt3v99Ev");}
void  S1409C3_nt ::v100(){vfunc_called(this, "_ZN10S1409C3_nt4v100Ev");}
void  S1409C3_nt ::v101(){vfunc_called(this, "_ZN10S1409C3_nt4v101Ev");}
void  S1409C3_nt ::v102(){vfunc_called(this, "_ZN10S1409C3_nt4v102Ev");}
void  S1409C3_nt ::v103(){vfunc_called(this, "_ZN10S1409C3_nt4v103Ev");}
void  S1409C3_nt ::v104(){vfunc_called(this, "_ZN10S1409C3_nt4v104Ev");}
void  S1409C3_nt ::v105(){vfunc_called(this, "_ZN10S1409C3_nt4v105Ev");}
void  S1409C3_nt ::v106(){vfunc_called(this, "_ZN10S1409C3_nt4v106Ev");}
void  S1409C3_nt ::v107(){vfunc_called(this, "_ZN10S1409C3_nt4v107Ev");}
void  S1409C3_nt ::v108(){vfunc_called(this, "_ZN10S1409C3_nt4v108Ev");}
void  S1409C3_nt ::v109(){vfunc_called(this, "_ZN10S1409C3_nt4v109Ev");}
void  S1409C3_nt ::v110(){vfunc_called(this, "_ZN10S1409C3_nt4v110Ev");}
void  S1409C3_nt ::v111(){vfunc_called(this, "_ZN10S1409C3_nt4v111Ev");}
void  S1409C3_nt ::v112(){vfunc_called(this, "_ZN10S1409C3_nt4v112Ev");}
void  S1409C3_nt ::v113(){vfunc_called(this, "_ZN10S1409C3_nt4v113Ev");}
void  S1409C3_nt ::v114(){vfunc_called(this, "_ZN10S1409C3_nt4v114Ev");}
void  S1409C3_nt ::v115(){vfunc_called(this, "_ZN10S1409C3_nt4v115Ev");}
void  S1409C3_nt ::v116(){vfunc_called(this, "_ZN10S1409C3_nt4v116Ev");}
void  S1409C3_nt ::v117(){vfunc_called(this, "_ZN10S1409C3_nt4v117Ev");}
void  S1409C3_nt ::v118(){vfunc_called(this, "_ZN10S1409C3_nt4v118Ev");}
void  S1409C3_nt ::v119(){vfunc_called(this, "_ZN10S1409C3_nt4v119Ev");}
void  S1409C3_nt ::v120(){vfunc_called(this, "_ZN10S1409C3_nt4v120Ev");}
void  S1409C3_nt ::v121(){vfunc_called(this, "_ZN10S1409C3_nt4v121Ev");}
void  S1409C3_nt ::v122(){vfunc_called(this, "_ZN10S1409C3_nt4v122Ev");}
void  S1409C3_nt ::v123(){vfunc_called(this, "_ZN10S1409C3_nt4v123Ev");}
void  S1409C3_nt ::v124(){vfunc_called(this, "_ZN10S1409C3_nt4v124Ev");}
void  S1409C3_nt ::v125(){vfunc_called(this, "_ZN10S1409C3_nt4v125Ev");}
void  S1409C3_nt ::v126(){vfunc_called(this, "_ZN10S1409C3_nt4v126Ev");}
void  S1409C3_nt ::v127(){vfunc_called(this, "_ZN10S1409C3_nt4v127Ev");}
void  S1409C3_nt ::v128(){vfunc_called(this, "_ZN10S1409C3_nt4v128Ev");}
void  S1409C3_nt ::v129(){vfunc_called(this, "_ZN10S1409C3_nt4v129Ev");}
void  S1409C3_nt ::v130(){vfunc_called(this, "_ZN10S1409C3_nt4v130Ev");}
void  S1409C3_nt ::v131(){vfunc_called(this, "_ZN10S1409C3_nt4v131Ev");}
void  S1409C3_nt ::v132(){vfunc_called(this, "_ZN10S1409C3_nt4v132Ev");}
void  S1409C3_nt ::v133(){vfunc_called(this, "_ZN10S1409C3_nt4v133Ev");}
void  S1409C3_nt ::v134(){vfunc_called(this, "_ZN10S1409C3_nt4v134Ev");}
void  S1409C3_nt ::v135(){vfunc_called(this, "_ZN10S1409C3_nt4v135Ev");}
void  S1409C3_nt ::v136(){vfunc_called(this, "_ZN10S1409C3_nt4v136Ev");}
void  S1409C3_nt ::v137(){vfunc_called(this, "_ZN10S1409C3_nt4v137Ev");}
void  S1409C3_nt ::v138(){vfunc_called(this, "_ZN10S1409C3_nt4v138Ev");}
void  S1409C3_nt ::v139(){vfunc_called(this, "_ZN10S1409C3_nt4v139Ev");}
void  S1409C3_nt ::v140(){vfunc_called(this, "_ZN10S1409C3_nt4v140Ev");}
void  S1409C3_nt ::v141(){vfunc_called(this, "_ZN10S1409C3_nt4v141Ev");}
void  S1409C3_nt ::v142(){vfunc_called(this, "_ZN10S1409C3_nt4v142Ev");}
void  S1409C3_nt ::v143(){vfunc_called(this, "_ZN10S1409C3_nt4v143Ev");}
void  S1409C3_nt ::v144(){vfunc_called(this, "_ZN10S1409C3_nt4v144Ev");}
void  S1409C3_nt ::v145(){vfunc_called(this, "_ZN10S1409C3_nt4v145Ev");}
void  S1409C3_nt ::v146(){vfunc_called(this, "_ZN10S1409C3_nt4v146Ev");}
void  S1409C3_nt ::v147(){vfunc_called(this, "_ZN10S1409C3_nt4v147Ev");}
void  S1409C3_nt ::v148(){vfunc_called(this, "_ZN10S1409C3_nt4v148Ev");}
void  S1409C3_nt ::v149(){vfunc_called(this, "_ZN10S1409C3_nt4v149Ev");}
void  S1409C3_nt ::v150(){vfunc_called(this, "_ZN10S1409C3_nt4v150Ev");}
void  S1409C3_nt ::v151(){vfunc_called(this, "_ZN10S1409C3_nt4v151Ev");}
void  S1409C3_nt ::v152(){vfunc_called(this, "_ZN10S1409C3_nt4v152Ev");}
void  S1409C3_nt ::v153(){vfunc_called(this, "_ZN10S1409C3_nt4v153Ev");}
void  S1409C3_nt ::v154(){vfunc_called(this, "_ZN10S1409C3_nt4v154Ev");}
void  S1409C3_nt ::v155(){vfunc_called(this, "_ZN10S1409C3_nt4v155Ev");}
void  S1409C3_nt ::v156(){vfunc_called(this, "_ZN10S1409C3_nt4v156Ev");}
void  S1409C3_nt ::v157(){vfunc_called(this, "_ZN10S1409C3_nt4v157Ev");}
void  S1409C3_nt ::v158(){vfunc_called(this, "_ZN10S1409C3_nt4v158Ev");}
void  S1409C3_nt ::v159(){vfunc_called(this, "_ZN10S1409C3_nt4v159Ev");}
void  S1409C3_nt ::v160(){vfunc_called(this, "_ZN10S1409C3_nt4v160Ev");}
void  S1409C3_nt ::v161(){vfunc_called(this, "_ZN10S1409C3_nt4v161Ev");}
void  S1409C3_nt ::v162(){vfunc_called(this, "_ZN10S1409C3_nt4v162Ev");}
void  S1409C3_nt ::v163(){vfunc_called(this, "_ZN10S1409C3_nt4v163Ev");}
void  S1409C3_nt ::v164(){vfunc_called(this, "_ZN10S1409C3_nt4v164Ev");}
void  S1409C3_nt ::v165(){vfunc_called(this, "_ZN10S1409C3_nt4v165Ev");}
void  S1409C3_nt ::v166(){vfunc_called(this, "_ZN10S1409C3_nt4v166Ev");}
void  S1409C3_nt ::v167(){vfunc_called(this, "_ZN10S1409C3_nt4v167Ev");}
void  S1409C3_nt ::v168(){vfunc_called(this, "_ZN10S1409C3_nt4v168Ev");}
void  S1409C3_nt ::v169(){vfunc_called(this, "_ZN10S1409C3_nt4v169Ev");}
void  S1409C3_nt ::v170(){vfunc_called(this, "_ZN10S1409C3_nt4v170Ev");}
void  S1409C3_nt ::v171(){vfunc_called(this, "_ZN10S1409C3_nt4v171Ev");}
void  S1409C3_nt ::v172(){vfunc_called(this, "_ZN10S1409C3_nt4v172Ev");}
void  S1409C3_nt ::v173(){vfunc_called(this, "_ZN10S1409C3_nt4v173Ev");}
void  S1409C3_nt ::v174(){vfunc_called(this, "_ZN10S1409C3_nt4v174Ev");}
void  S1409C3_nt ::v175(){vfunc_called(this, "_ZN10S1409C3_nt4v175Ev");}
void  S1409C3_nt ::v176(){vfunc_called(this, "_ZN10S1409C3_nt4v176Ev");}
void  S1409C3_nt ::v177(){vfunc_called(this, "_ZN10S1409C3_nt4v177Ev");}
void  S1409C3_nt ::v178(){vfunc_called(this, "_ZN10S1409C3_nt4v178Ev");}
void  S1409C3_nt ::v179(){vfunc_called(this, "_ZN10S1409C3_nt4v179Ev");}
void  S1409C3_nt ::v180(){vfunc_called(this, "_ZN10S1409C3_nt4v180Ev");}
void  S1409C3_nt ::v181(){vfunc_called(this, "_ZN10S1409C3_nt4v181Ev");}
void  S1409C3_nt ::v182(){vfunc_called(this, "_ZN10S1409C3_nt4v182Ev");}
void  S1409C3_nt ::v183(){vfunc_called(this, "_ZN10S1409C3_nt4v183Ev");}
void  S1409C3_nt ::v184(){vfunc_called(this, "_ZN10S1409C3_nt4v184Ev");}
void  S1409C3_nt ::v185(){vfunc_called(this, "_ZN10S1409C3_nt4v185Ev");}
void  S1409C3_nt ::v186(){vfunc_called(this, "_ZN10S1409C3_nt4v186Ev");}
void  S1409C3_nt ::v187(){vfunc_called(this, "_ZN10S1409C3_nt4v187Ev");}
void  S1409C3_nt ::v188(){vfunc_called(this, "_ZN10S1409C3_nt4v188Ev");}
void  S1409C3_nt ::v189(){vfunc_called(this, "_ZN10S1409C3_nt4v189Ev");}
void  S1409C3_nt ::v190(){vfunc_called(this, "_ZN10S1409C3_nt4v190Ev");}
void  S1409C3_nt ::v191(){vfunc_called(this, "_ZN10S1409C3_nt4v191Ev");}
void  S1409C3_nt ::v192(){vfunc_called(this, "_ZN10S1409C3_nt4v192Ev");}
void  S1409C3_nt ::v193(){vfunc_called(this, "_ZN10S1409C3_nt4v193Ev");}
void  S1409C3_nt ::v194(){vfunc_called(this, "_ZN10S1409C3_nt4v194Ev");}
void  S1409C3_nt ::v195(){vfunc_called(this, "_ZN10S1409C3_nt4v195Ev");}
void  S1409C3_nt ::v196(){vfunc_called(this, "_ZN10S1409C3_nt4v196Ev");}
void  S1409C3_nt ::v197(){vfunc_called(this, "_ZN10S1409C3_nt4v197Ev");}
void  S1409C3_nt ::v198(){vfunc_called(this, "_ZN10S1409C3_nt4v198Ev");}
void  S1409C3_nt ::v199(){vfunc_called(this, "_ZN10S1409C3_nt4v199Ev");}
void  S1409C3_nt ::v200(){vfunc_called(this, "_ZN10S1409C3_nt4v200Ev");}
void  S1409C3_nt ::v201(){vfunc_called(this, "_ZN10S1409C3_nt4v201Ev");}
void  S1409C3_nt ::v202(){vfunc_called(this, "_ZN10S1409C3_nt4v202Ev");}
void  S1409C3_nt ::v203(){vfunc_called(this, "_ZN10S1409C3_nt4v203Ev");}
void  S1409C3_nt ::v204(){vfunc_called(this, "_ZN10S1409C3_nt4v204Ev");}
void  S1409C3_nt ::v205(){vfunc_called(this, "_ZN10S1409C3_nt4v205Ev");}
void  S1409C3_nt ::v206(){vfunc_called(this, "_ZN10S1409C3_nt4v206Ev");}
void  S1409C3_nt ::v207(){vfunc_called(this, "_ZN10S1409C3_nt4v207Ev");}
void  S1409C3_nt ::v208(){vfunc_called(this, "_ZN10S1409C3_nt4v208Ev");}
void  S1409C3_nt ::v209(){vfunc_called(this, "_ZN10S1409C3_nt4v209Ev");}
void  S1409C3_nt ::v210(){vfunc_called(this, "_ZN10S1409C3_nt4v210Ev");}
S1409C3_nt ::S1409C3_nt(){ note_ctor("S1409C3_nt", this);} // tgen

//skip512 S1409C3_nt

#else // __cplusplus

extern void _ZN10S1409C3_ntC1Ev();
extern void _ZN10S1409C3_ntD1Ev();
Name_Map name_map_S1409C3_nt[] = {
  NSPAIR(_ZN10S1409C3_ntC1Ev),
  NSPAIR(_ZN10S1409C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1409C4_nt;
extern VTBL_ENTRY _ZTI10S1409C4_nt[];
extern  VTBL_ENTRY _ZTV10S1409C4_nt[];
static Base_Class bases_S1409C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1409C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S1409C3_nt[];
extern void _ZN10S1409C3_ntD1Ev();
extern void _ZN10S1409C3_ntD0Ev();
extern void _ZN10S1409C4_nt2v4Ev();
extern void _ZN10S1409C4_nt2v5Ev();
extern void _ZN10S1409C4_nt2v6Ev();
extern void _ZN10S1409C4_nt2v7Ev();
extern void _ZN10S1409C4_nt2v8Ev();
extern void _ZN10S1409C4_nt2v9Ev();
extern void _ZN10S1409C4_nt3v10Ev();
extern void _ZN10S1409C4_nt3v11Ev();
extern void _ZN10S1409C4_nt3v12Ev();
extern void _ZN10S1409C4_nt3v13Ev();
extern void _ZN10S1409C4_nt3v14Ev();
extern void _ZN10S1409C4_nt3v15Ev();
extern void _ZN10S1409C4_nt3v16Ev();
extern void _ZN10S1409C4_nt3v17Ev();
extern void _ZN10S1409C4_nt3v18Ev();
extern void _ZN10S1409C4_nt3v19Ev();
extern void _ZN10S1409C4_nt3v20Ev();
extern void _ZN10S1409C4_nt3v21Ev();
extern void _ZN10S1409C4_nt3v22Ev();
extern void _ZN10S1409C4_nt3v23Ev();
extern void _ZN10S1409C4_nt3v24Ev();
extern void _ZN10S1409C4_nt3v25Ev();
extern void _ZN10S1409C4_nt3v26Ev();
extern void _ZN10S1409C4_nt3v27Ev();
extern void _ZN10S1409C4_nt3v28Ev();
extern void _ZN10S1409C4_nt3v29Ev();
extern void _ZN10S1409C4_nt3v30Ev();
extern void _ZN10S1409C4_nt3v31Ev();
extern void _ZN10S1409C4_nt3v32Ev();
extern void _ZN10S1409C4_nt3v33Ev();
extern void _ZN10S1409C4_nt3v34Ev();
extern void _ZN10S1409C4_nt3v35Ev();
extern void _ZN10S1409C4_nt3v36Ev();
extern void _ZN10S1409C4_nt3v37Ev();
extern void _ZN10S1409C4_nt3v38Ev();
extern void _ZN10S1409C4_nt3v39Ev();
extern void _ZN10S1409C4_nt3v40Ev();
extern void _ZN10S1409C4_nt3v41Ev();
extern void _ZN10S1409C4_nt3v42Ev();
extern void _ZN10S1409C4_nt3v43Ev();
extern void _ZN10S1409C4_nt3v44Ev();
extern void _ZN10S1409C4_nt3v45Ev();
extern void _ZN10S1409C4_nt3v46Ev();
extern void _ZN10S1409C4_nt3v47Ev();
extern void _ZN10S1409C4_nt3v48Ev();
extern void _ZN10S1409C4_nt3v49Ev();
extern void _ZN10S1409C4_nt3v50Ev();
extern void _ZN10S1409C4_nt3v51Ev();
extern void _ZN10S1409C4_nt3v52Ev();
extern void _ZN10S1409C4_nt3v53Ev();
extern void _ZN10S1409C4_nt3v54Ev();
extern void _ZN10S1409C4_nt3v55Ev();
extern void _ZN10S1409C4_nt3v56Ev();
extern void _ZN10S1409C4_nt3v57Ev();
extern void _ZN10S1409C4_nt3v58Ev();
extern void _ZN10S1409C4_nt3v59Ev();
extern void _ZN10S1409C4_nt3v60Ev();
extern void _ZN10S1409C4_nt3v61Ev();
extern void _ZN10S1409C4_nt3v62Ev();
extern void _ZN10S1409C4_nt3v63Ev();
extern void _ZN10S1409C4_nt3v64Ev();
extern void _ZN10S1409C4_nt3v65Ev();
extern void _ZN10S1409C4_nt3v66Ev();
extern void _ZN10S1409C4_nt3v67Ev();
extern void _ZN10S1409C3_nt3v68Ev();
extern void _ZN10S1409C3_nt3v69Ev();
extern void _ZN10S1409C3_nt3v70Ev();
extern void _ZN10S1409C3_nt3v71Ev();
extern void _ZN10S1409C3_nt3v72Ev();
extern void _ZN10S1409C3_nt3v73Ev();
extern void _ZN10S1409C3_nt3v74Ev();
extern void _ZN10S1409C3_nt3v75Ev();
extern void _ZN10S1409C3_nt3v76Ev();
extern void _ZN10S1409C3_nt3v77Ev();
extern void _ZN10S1409C3_nt3v78Ev();
extern void _ZN10S1409C3_nt3v79Ev();
extern void _ZN10S1409C3_nt3v80Ev();
extern void _ZN10S1409C3_nt3v81Ev();
extern void _ZN10S1409C3_nt3v82Ev();
extern void _ZN10S1409C3_nt3v83Ev();
extern void _ZN10S1409C3_nt3v84Ev();
extern void _ZN10S1409C3_nt3v85Ev();
extern void _ZN10S1409C3_nt3v86Ev();
extern void _ZN10S1409C3_nt3v87Ev();
extern void _ZN10S1409C3_nt3v88Ev();
extern void _ZN10S1409C3_nt3v89Ev();
extern void _ZN10S1409C3_nt3v90Ev();
extern void _ZN10S1409C3_nt3v91Ev();
extern void _ZN10S1409C3_nt3v92Ev();
extern void _ZN10S1409C3_nt3v93Ev();
extern void _ZN10S1409C3_nt3v94Ev();
extern void _ZN10S1409C3_nt3v95Ev();
extern void _ZN10S1409C3_nt3v96Ev();
extern void _ZN10S1409C3_nt3v97Ev();
extern void _ZN10S1409C3_nt3v98Ev();
extern void _ZN10S1409C3_nt3v99Ev();
extern void _ZN10S1409C3_nt4v100Ev();
extern void _ZN10S1409C3_nt4v101Ev();
extern void _ZN10S1409C3_nt4v102Ev();
extern void _ZN10S1409C3_nt4v103Ev();
extern void _ZN10S1409C3_nt4v104Ev();
extern void _ZN10S1409C3_nt4v105Ev();
extern void _ZN10S1409C3_nt4v106Ev();
extern void _ZN10S1409C3_nt4v107Ev();
extern void _ZN10S1409C3_nt4v108Ev();
extern void _ZN10S1409C3_nt4v109Ev();
extern void _ZN10S1409C3_nt4v110Ev();
extern void _ZN10S1409C3_nt4v111Ev();
extern void _ZN10S1409C3_nt4v112Ev();
extern void _ZN10S1409C3_nt4v113Ev();
extern void _ZN10S1409C3_nt4v114Ev();
extern void _ZN10S1409C3_nt4v115Ev();
extern void _ZN10S1409C3_nt4v116Ev();
extern void _ZN10S1409C3_nt4v117Ev();
extern void _ZN10S1409C3_nt4v118Ev();
extern void _ZN10S1409C3_nt4v119Ev();
extern void _ZN10S1409C3_nt4v120Ev();
extern void _ZN10S1409C3_nt4v121Ev();
extern void _ZN10S1409C3_nt4v122Ev();
extern void _ZN10S1409C3_nt4v123Ev();
extern void _ZN10S1409C3_nt4v124Ev();
extern void _ZN10S1409C3_nt4v125Ev();
extern void _ZN10S1409C3_nt4v126Ev();
extern void _ZN10S1409C3_nt4v127Ev();
extern void _ZN10S1409C3_nt4v128Ev();
extern void _ZN10S1409C3_nt4v129Ev();
extern void _ZN10S1409C3_nt4v130Ev();
extern void _ZN10S1409C3_nt4v131Ev();
extern void _ZN10S1409C3_nt4v132Ev();
extern void _ZN10S1409C3_nt4v133Ev();
extern void _ZN10S1409C3_nt4v134Ev();
extern void _ZN10S1409C3_nt4v135Ev();
extern void _ZN10S1409C3_nt4v136Ev();
extern void _ZN10S1409C3_nt4v137Ev();
extern void _ZN10S1409C3_nt4v138Ev();
extern void _ZN10S1409C3_nt4v139Ev();
extern void _ZN10S1409C3_nt4v140Ev();
extern void _ZN10S1409C3_nt4v141Ev();
extern void _ZN10S1409C3_nt4v142Ev();
extern void _ZN10S1409C3_nt4v143Ev();
extern void _ZN10S1409C3_nt4v144Ev();
extern void _ZN10S1409C3_nt4v145Ev();
extern void _ZN10S1409C3_nt4v146Ev();
extern void _ZN10S1409C3_nt4v147Ev();
extern void _ZN10S1409C3_nt4v148Ev();
extern void _ZN10S1409C3_nt4v149Ev();
extern void _ZN10S1409C3_nt4v150Ev();
extern void _ZN10S1409C3_nt4v151Ev();
extern void _ZN10S1409C3_nt4v152Ev();
extern void _ZN10S1409C3_nt4v153Ev();
extern void _ZN10S1409C3_nt4v154Ev();
extern void _ZN10S1409C3_nt4v155Ev();
extern void _ZN10S1409C3_nt4v156Ev();
extern void _ZN10S1409C3_nt4v157Ev();
extern void _ZN10S1409C3_nt4v158Ev();
extern void _ZN10S1409C3_nt4v159Ev();
extern void _ZN10S1409C3_nt4v160Ev();
extern void _ZN10S1409C3_nt4v161Ev();
extern void _ZN10S1409C3_nt4v162Ev();
extern void _ZN10S1409C3_nt4v163Ev();
extern void _ZN10S1409C3_nt4v164Ev();
extern void _ZN10S1409C3_nt4v165Ev();
extern void _ZN10S1409C3_nt4v166Ev();
extern void _ZN10S1409C3_nt4v167Ev();
extern void _ZN10S1409C3_nt4v168Ev();
extern void _ZN10S1409C3_nt4v169Ev();
extern void _ZN10S1409C3_nt4v170Ev();
extern void _ZN10S1409C3_nt4v171Ev();
extern void _ZN10S1409C3_nt4v172Ev();
extern void _ZN10S1409C3_nt4v173Ev();
extern void _ZN10S1409C3_nt4v174Ev();
extern void _ZN10S1409C3_nt4v175Ev();
extern void _ZN10S1409C3_nt4v176Ev();
extern void _ZN10S1409C3_nt4v177Ev();
extern void _ZN10S1409C3_nt4v178Ev();
extern void _ZN10S1409C3_nt4v179Ev();
extern void _ZN10S1409C3_nt4v180Ev();
extern void _ZN10S1409C3_nt4v181Ev();
extern void _ZN10S1409C3_nt4v182Ev();
extern void _ZN10S1409C3_nt4v183Ev();
extern void _ZN10S1409C3_nt4v184Ev();
extern void _ZN10S1409C3_nt4v185Ev();
extern void _ZN10S1409C3_nt4v186Ev();
extern void _ZN10S1409C3_nt4v187Ev();
extern void _ZN10S1409C3_nt4v188Ev();
extern void _ZN10S1409C3_nt4v189Ev();
extern void _ZN10S1409C3_nt4v190Ev();
extern void _ZN10S1409C3_nt4v191Ev();
extern void _ZN10S1409C3_nt4v192Ev();
extern void _ZN10S1409C3_nt4v193Ev();
extern void _ZN10S1409C3_nt4v194Ev();
extern void _ZN10S1409C3_nt4v195Ev();
extern void _ZN10S1409C3_nt4v196Ev();
extern void _ZN10S1409C3_nt4v197Ev();
extern void _ZN10S1409C3_nt4v198Ev();
extern void _ZN10S1409C3_nt4v199Ev();
extern void _ZN10S1409C3_nt4v200Ev();
extern void _ZN10S1409C3_nt4v201Ev();
extern void _ZN10S1409C3_nt4v202Ev();
extern void _ZN10S1409C3_nt4v203Ev();
extern void _ZN10S1409C3_nt4v204Ev();
extern void _ZN10S1409C3_nt4v205Ev();
extern void _ZN10S1409C3_nt4v206Ev();
extern void _ZN10S1409C3_nt4v207Ev();
extern void _ZN10S1409C3_nt4v208Ev();
extern void _ZN10S1409C3_nt4v209Ev();
extern void _ZN10S1409C3_nt4v210Ev();
static  VTBL_ENTRY vtc_S1409C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1409C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S1409C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v210Ev,
};
extern VTBL_ENTRY _ZTI10S1409C3_nt[];
VTBL_ENTRY *P__ZTI10S1409C3_nt = _ZTI10S1409C3_nt; 
extern  VTBL_ENTRY _ZTV10S1409C3_nt[];
Class_Descriptor cd_S1409C3_nt = {  "S1409C3_nt", // class name
  bases_S1409C3_nt, 1,
  &(vtc_S1409C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(568,436), // object size
  NSPAIRA(_ZTI10S1409C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S1409C3_nt),211, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1409C23  : S1409C8_nt {
};
//SIG(-1 S1409C23) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1409C23()
{
  extern Class_Descriptor cd_S1409C23;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1409C23, buf);
    S1409C23 &lv = *(new (buf) S1409C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1409C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1409C23)");
    check_base_class_offset(lv, (S1409C8_nt*), 0, "S1409C23");
    test_class_info(&lv, &cd_S1409C23);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1409C23(Test_S1409C23, "S1409C23", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1409C8_nt;
extern VTBL_ENTRY _ZTI10S1409C8_nt[];
static Base_Class bases_S1409C23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1409C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1409C23 = {  "S1409C23", // class name
  bases_S1409C23, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1409C22  : S1409C23 {
};
//SIG(-1 S1409C22) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1409C22()
{
  extern Class_Descriptor cd_S1409C22;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1409C22, buf);
    S1409C22 &lv = *(new (buf) S1409C22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1409C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1409C22)");
    check_base_class_offset(lv, (S1409C8_nt*)(S1409C23*), 0, "S1409C22");
    check_base_class_offset(lv, (S1409C23*), 0, "S1409C22");
    test_class_info(&lv, &cd_S1409C22);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1409C22(Test_S1409C22, "S1409C22", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1409C8_nt;
extern VTBL_ENTRY _ZTI10S1409C8_nt[];
extern Class_Descriptor cd_S1409C23;
static Base_Class bases_S1409C22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1409C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1409C23,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1409C22 = {  "S1409C22", // class name
  bases_S1409C22, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1409C27  : S1409C8_nt {
};
//SIG(-1 S1409C27) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1409C27()
{
  extern Class_Descriptor cd_S1409C27;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1409C27, buf);
    S1409C27 &lv = *(new (buf) S1409C27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1409C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1409C27)");
    check_base_class_offset(lv, (S1409C8_nt*), 0, "S1409C27");
    test_class_info(&lv, &cd_S1409C27);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1409C27(Test_S1409C27, "S1409C27", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1409C8_nt;
extern VTBL_ENTRY _ZTI10S1409C8_nt[];
static Base_Class bases_S1409C27[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1409C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1409C27 = {  "S1409C27", // class name
  bases_S1409C27, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1409C26  : S1409C27 {
};
//SIG(-1 S1409C26) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1409C26()
{
  extern Class_Descriptor cd_S1409C26;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1409C26, buf);
    S1409C26 &lv = *(new (buf) S1409C26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1409C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1409C26)");
    check_base_class_offset(lv, (S1409C8_nt*)(S1409C27*), 0, "S1409C26");
    check_base_class_offset(lv, (S1409C27*), 0, "S1409C26");
    test_class_info(&lv, &cd_S1409C26);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1409C26(Test_S1409C26, "S1409C26", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1409C8_nt;
extern VTBL_ENTRY _ZTI10S1409C8_nt[];
extern Class_Descriptor cd_S1409C27;
static Base_Class bases_S1409C26[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1409C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1409C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1409C26 = {  "S1409C26", // class name
  bases_S1409C26, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1409C2  : S1409C3_nt {
  void *s1409c2f0;
  ::S1409C22 s1409c2f1;
  ::S1409C22 s1409c2f2;
  int s1409c2f3;
  unsigned int s1409c2f4:1;
  unsigned int s1409c2f5:1;
  ::S1409C22 s1409c2f6;
  int s1409c2f7[4];
  ::S1409C26 s1409c2f8;
  ::S1409C26 s1409c2f9;
  virtual  ~S1409C2(); // _ZN7S1409C2D1Ev
  virtual void  v211(); // _ZN7S1409C24v211Ev
  virtual void  v212(); // _ZN7S1409C24v212Ev
  virtual void  v213(); // _ZN7S1409C24v213Ev
  S1409C2(); // tgen
};
//SIG(-1 S1409C2) C1{ BC2{ BC3{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC5 FC8{ m Fi} Fi Fc[4] Fp[2] FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC4 FC4 FC4 FC9{ BC10{ BC7}} FC9 Fi Fp[2] FC11{ m Fi[3]} FC11 FC11 FC11 Fp FC4 FC9 FC11 FC11 Fi FC11 FC11 Fp Fi Fc FC11 FC11 Fp Fi Fp FC9 FC12{ BC13{ BC7}} FC12} vd v1 v2 v3 Fp FC14{ BC15{ BC7}} FC14 Fi Fi:1 Fi:1 FC14 Fi[4] FC16{ BC17{ BC7}} FC16}


 S1409C2 ::~S1409C2(){ note_dtor("S1409C2", this);}
void  S1409C2 ::v211(){vfunc_called(this, "_ZN7S1409C24v211Ev");}
void  S1409C2 ::v212(){vfunc_called(this, "_ZN7S1409C24v212Ev");}
void  S1409C2 ::v213(){vfunc_called(this, "_ZN7S1409C24v213Ev");}
S1409C2 ::S1409C2(){ note_ctor("S1409C2", this);} // tgen

static void Test_S1409C2()
{
  extern Class_Descriptor cd_S1409C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(86,132)];
    init_test(&cd_S1409C2, buf);
    S1409C2 *dp, &lv = *(dp=new (buf) S1409C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(680,524), "sizeof(S1409C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1409C2)");
    check_base_class_offset(lv, (S1409C4_nt*)(S1409C3_nt*), 0, "S1409C2");
    check_base_class_offset(lv, (S1409C3_nt*), 0, "S1409C2");
    check_field_offset(lv, s1409c2f0, ABISELECT(568,436), "S1409C2.s1409c2f0");
    check_field_offset(lv, s1409c2f1, ABISELECT(576,440), "S1409C2.s1409c2f1");
    check_field_offset(lv, s1409c2f2, ABISELECT(592,452), "S1409C2.s1409c2f2");
    check_field_offset(lv, s1409c2f3, ABISELECT(608,464), "S1409C2.s1409c2f3");
    set_bf_and_test(lv, s1409c2f4, ABISELECT(612,468), 0, 1, 1, "S1409C2");
    set_bf_and_test(lv, s1409c2f5, ABISELECT(612,468), 1, 1, 1, "S1409C2");
    check_field_offset(lv, s1409c2f6, ABISELECT(616,472), "S1409C2.s1409c2f6");
    check_field_offset(lv, s1409c2f7, ABISELECT(632,484), "S1409C2.s1409c2f7");
    check_field_offset(lv, s1409c2f8, ABISELECT(648,500), "S1409C2.s1409c2f8");
    check_field_offset(lv, s1409c2f9, ABISELECT(664,512), "S1409C2.s1409c2f9");
    test_class_info(&lv, &cd_S1409C2);
    dp->~S1409C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1409C2(Test_S1409C2, "S1409C2", ABISELECT(680,524));

#else // __cplusplus

extern void _ZN7S1409C2C1Ev();
extern void _ZN7S1409C2D1Ev();
Name_Map name_map_S1409C2[] = {
  NSPAIR(_ZN7S1409C2C1Ev),
  NSPAIR(_ZN7S1409C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1409C4_nt;
extern VTBL_ENTRY _ZTI10S1409C4_nt[];
extern  VTBL_ENTRY _ZTV10S1409C4_nt[];
extern Class_Descriptor cd_S1409C3_nt;
extern VTBL_ENTRY _ZTI10S1409C3_nt[];
extern  VTBL_ENTRY _ZTV10S1409C3_nt[];
static Base_Class bases_S1409C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1409C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1409C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1409C2[];
extern void _ZN7S1409C2D1Ev();
extern void _ZN7S1409C2D0Ev();
extern void _ZN10S1409C4_nt2v4Ev();
extern void _ZN10S1409C4_nt2v5Ev();
extern void _ZN10S1409C4_nt2v6Ev();
extern void _ZN10S1409C4_nt2v7Ev();
extern void _ZN10S1409C4_nt2v8Ev();
extern void _ZN10S1409C4_nt2v9Ev();
extern void _ZN10S1409C4_nt3v10Ev();
extern void _ZN10S1409C4_nt3v11Ev();
extern void _ZN10S1409C4_nt3v12Ev();
extern void _ZN10S1409C4_nt3v13Ev();
extern void _ZN10S1409C4_nt3v14Ev();
extern void _ZN10S1409C4_nt3v15Ev();
extern void _ZN10S1409C4_nt3v16Ev();
extern void _ZN10S1409C4_nt3v17Ev();
extern void _ZN10S1409C4_nt3v18Ev();
extern void _ZN10S1409C4_nt3v19Ev();
extern void _ZN10S1409C4_nt3v20Ev();
extern void _ZN10S1409C4_nt3v21Ev();
extern void _ZN10S1409C4_nt3v22Ev();
extern void _ZN10S1409C4_nt3v23Ev();
extern void _ZN10S1409C4_nt3v24Ev();
extern void _ZN10S1409C4_nt3v25Ev();
extern void _ZN10S1409C4_nt3v26Ev();
extern void _ZN10S1409C4_nt3v27Ev();
extern void _ZN10S1409C4_nt3v28Ev();
extern void _ZN10S1409C4_nt3v29Ev();
extern void _ZN10S1409C4_nt3v30Ev();
extern void _ZN10S1409C4_nt3v31Ev();
extern void _ZN10S1409C4_nt3v32Ev();
extern void _ZN10S1409C4_nt3v33Ev();
extern void _ZN10S1409C4_nt3v34Ev();
extern void _ZN10S1409C4_nt3v35Ev();
extern void _ZN10S1409C4_nt3v36Ev();
extern void _ZN10S1409C4_nt3v37Ev();
extern void _ZN10S1409C4_nt3v38Ev();
extern void _ZN10S1409C4_nt3v39Ev();
extern void _ZN10S1409C4_nt3v40Ev();
extern void _ZN10S1409C4_nt3v41Ev();
extern void _ZN10S1409C4_nt3v42Ev();
extern void _ZN10S1409C4_nt3v43Ev();
extern void _ZN10S1409C4_nt3v44Ev();
extern void _ZN10S1409C4_nt3v45Ev();
extern void _ZN10S1409C4_nt3v46Ev();
extern void _ZN10S1409C4_nt3v47Ev();
extern void _ZN10S1409C4_nt3v48Ev();
extern void _ZN10S1409C4_nt3v49Ev();
extern void _ZN10S1409C4_nt3v50Ev();
extern void _ZN10S1409C4_nt3v51Ev();
extern void _ZN10S1409C4_nt3v52Ev();
extern void _ZN10S1409C4_nt3v53Ev();
extern void _ZN10S1409C4_nt3v54Ev();
extern void _ZN10S1409C4_nt3v55Ev();
extern void _ZN10S1409C4_nt3v56Ev();
extern void _ZN10S1409C4_nt3v57Ev();
extern void _ZN10S1409C4_nt3v58Ev();
extern void _ZN10S1409C4_nt3v59Ev();
extern void _ZN10S1409C4_nt3v60Ev();
extern void _ZN10S1409C4_nt3v61Ev();
extern void _ZN10S1409C4_nt3v62Ev();
extern void _ZN10S1409C4_nt3v63Ev();
extern void _ZN10S1409C4_nt3v64Ev();
extern void _ZN10S1409C4_nt3v65Ev();
extern void _ZN10S1409C4_nt3v66Ev();
extern void _ZN10S1409C4_nt3v67Ev();
extern void _ZN10S1409C3_nt3v68Ev();
extern void _ZN10S1409C3_nt3v69Ev();
extern void _ZN10S1409C3_nt3v70Ev();
extern void _ZN10S1409C3_nt3v71Ev();
extern void _ZN10S1409C3_nt3v72Ev();
extern void _ZN10S1409C3_nt3v73Ev();
extern void _ZN10S1409C3_nt3v74Ev();
extern void _ZN10S1409C3_nt3v75Ev();
extern void _ZN10S1409C3_nt3v76Ev();
extern void _ZN10S1409C3_nt3v77Ev();
extern void _ZN10S1409C3_nt3v78Ev();
extern void _ZN10S1409C3_nt3v79Ev();
extern void _ZN10S1409C3_nt3v80Ev();
extern void _ZN10S1409C3_nt3v81Ev();
extern void _ZN10S1409C3_nt3v82Ev();
extern void _ZN10S1409C3_nt3v83Ev();
extern void _ZN10S1409C3_nt3v84Ev();
extern void _ZN10S1409C3_nt3v85Ev();
extern void _ZN10S1409C3_nt3v86Ev();
extern void _ZN10S1409C3_nt3v87Ev();
extern void _ZN10S1409C3_nt3v88Ev();
extern void _ZN10S1409C3_nt3v89Ev();
extern void _ZN10S1409C3_nt3v90Ev();
extern void _ZN10S1409C3_nt3v91Ev();
extern void _ZN10S1409C3_nt3v92Ev();
extern void _ZN10S1409C3_nt3v93Ev();
extern void _ZN10S1409C3_nt3v94Ev();
extern void _ZN10S1409C3_nt3v95Ev();
extern void _ZN10S1409C3_nt3v96Ev();
extern void _ZN10S1409C3_nt3v97Ev();
extern void _ZN10S1409C3_nt3v98Ev();
extern void _ZN10S1409C3_nt3v99Ev();
extern void _ZN10S1409C3_nt4v100Ev();
extern void _ZN10S1409C3_nt4v101Ev();
extern void _ZN10S1409C3_nt4v102Ev();
extern void _ZN10S1409C3_nt4v103Ev();
extern void _ZN10S1409C3_nt4v104Ev();
extern void _ZN10S1409C3_nt4v105Ev();
extern void _ZN10S1409C3_nt4v106Ev();
extern void _ZN10S1409C3_nt4v107Ev();
extern void _ZN10S1409C3_nt4v108Ev();
extern void _ZN10S1409C3_nt4v109Ev();
extern void _ZN10S1409C3_nt4v110Ev();
extern void _ZN10S1409C3_nt4v111Ev();
extern void _ZN10S1409C3_nt4v112Ev();
extern void _ZN10S1409C3_nt4v113Ev();
extern void _ZN10S1409C3_nt4v114Ev();
extern void _ZN10S1409C3_nt4v115Ev();
extern void _ZN10S1409C3_nt4v116Ev();
extern void _ZN10S1409C3_nt4v117Ev();
extern void _ZN10S1409C3_nt4v118Ev();
extern void _ZN10S1409C3_nt4v119Ev();
extern void _ZN10S1409C3_nt4v120Ev();
extern void _ZN10S1409C3_nt4v121Ev();
extern void _ZN10S1409C3_nt4v122Ev();
extern void _ZN10S1409C3_nt4v123Ev();
extern void _ZN10S1409C3_nt4v124Ev();
extern void _ZN10S1409C3_nt4v125Ev();
extern void _ZN10S1409C3_nt4v126Ev();
extern void _ZN10S1409C3_nt4v127Ev();
extern void _ZN10S1409C3_nt4v128Ev();
extern void _ZN10S1409C3_nt4v129Ev();
extern void _ZN10S1409C3_nt4v130Ev();
extern void _ZN10S1409C3_nt4v131Ev();
extern void _ZN10S1409C3_nt4v132Ev();
extern void _ZN10S1409C3_nt4v133Ev();
extern void _ZN10S1409C3_nt4v134Ev();
extern void _ZN10S1409C3_nt4v135Ev();
extern void _ZN10S1409C3_nt4v136Ev();
extern void _ZN10S1409C3_nt4v137Ev();
extern void _ZN10S1409C3_nt4v138Ev();
extern void _ZN10S1409C3_nt4v139Ev();
extern void _ZN10S1409C3_nt4v140Ev();
extern void _ZN10S1409C3_nt4v141Ev();
extern void _ZN10S1409C3_nt4v142Ev();
extern void _ZN10S1409C3_nt4v143Ev();
extern void _ZN10S1409C3_nt4v144Ev();
extern void _ZN10S1409C3_nt4v145Ev();
extern void _ZN10S1409C3_nt4v146Ev();
extern void _ZN10S1409C3_nt4v147Ev();
extern void _ZN10S1409C3_nt4v148Ev();
extern void _ZN10S1409C3_nt4v149Ev();
extern void _ZN10S1409C3_nt4v150Ev();
extern void _ZN10S1409C3_nt4v151Ev();
extern void _ZN10S1409C3_nt4v152Ev();
extern void _ZN10S1409C3_nt4v153Ev();
extern void _ZN10S1409C3_nt4v154Ev();
extern void _ZN10S1409C3_nt4v155Ev();
extern void _ZN10S1409C3_nt4v156Ev();
extern void _ZN10S1409C3_nt4v157Ev();
extern void _ZN10S1409C3_nt4v158Ev();
extern void _ZN10S1409C3_nt4v159Ev();
extern void _ZN10S1409C3_nt4v160Ev();
extern void _ZN10S1409C3_nt4v161Ev();
extern void _ZN10S1409C3_nt4v162Ev();
extern void _ZN10S1409C3_nt4v163Ev();
extern void _ZN10S1409C3_nt4v164Ev();
extern void _ZN10S1409C3_nt4v165Ev();
extern void _ZN10S1409C3_nt4v166Ev();
extern void _ZN10S1409C3_nt4v167Ev();
extern void _ZN10S1409C3_nt4v168Ev();
extern void _ZN10S1409C3_nt4v169Ev();
extern void _ZN10S1409C3_nt4v170Ev();
extern void _ZN10S1409C3_nt4v171Ev();
extern void _ZN10S1409C3_nt4v172Ev();
extern void _ZN10S1409C3_nt4v173Ev();
extern void _ZN10S1409C3_nt4v174Ev();
extern void _ZN10S1409C3_nt4v175Ev();
extern void _ZN10S1409C3_nt4v176Ev();
extern void _ZN10S1409C3_nt4v177Ev();
extern void _ZN10S1409C3_nt4v178Ev();
extern void _ZN10S1409C3_nt4v179Ev();
extern void _ZN10S1409C3_nt4v180Ev();
extern void _ZN10S1409C3_nt4v181Ev();
extern void _ZN10S1409C3_nt4v182Ev();
extern void _ZN10S1409C3_nt4v183Ev();
extern void _ZN10S1409C3_nt4v184Ev();
extern void _ZN10S1409C3_nt4v185Ev();
extern void _ZN10S1409C3_nt4v186Ev();
extern void _ZN10S1409C3_nt4v187Ev();
extern void _ZN10S1409C3_nt4v188Ev();
extern void _ZN10S1409C3_nt4v189Ev();
extern void _ZN10S1409C3_nt4v190Ev();
extern void _ZN10S1409C3_nt4v191Ev();
extern void _ZN10S1409C3_nt4v192Ev();
extern void _ZN10S1409C3_nt4v193Ev();
extern void _ZN10S1409C3_nt4v194Ev();
extern void _ZN10S1409C3_nt4v195Ev();
extern void _ZN10S1409C3_nt4v196Ev();
extern void _ZN10S1409C3_nt4v197Ev();
extern void _ZN10S1409C3_nt4v198Ev();
extern void _ZN10S1409C3_nt4v199Ev();
extern void _ZN10S1409C3_nt4v200Ev();
extern void _ZN10S1409C3_nt4v201Ev();
extern void _ZN10S1409C3_nt4v202Ev();
extern void _ZN10S1409C3_nt4v203Ev();
extern void _ZN10S1409C3_nt4v204Ev();
extern void _ZN10S1409C3_nt4v205Ev();
extern void _ZN10S1409C3_nt4v206Ev();
extern void _ZN10S1409C3_nt4v207Ev();
extern void _ZN10S1409C3_nt4v208Ev();
extern void _ZN10S1409C3_nt4v209Ev();
extern void _ZN10S1409C3_nt4v210Ev();
extern void _ZN7S1409C24v211Ev();
extern void _ZN7S1409C24v212Ev();
extern void _ZN7S1409C24v213Ev();
static  VTBL_ENTRY vtc_S1409C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1409C2[0]),
  (VTBL_ENTRY)&_ZN7S1409C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1409C2D0Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN7S1409C24v211Ev,
  (VTBL_ENTRY)&_ZN7S1409C24v212Ev,
  (VTBL_ENTRY)&_ZN7S1409C24v213Ev,
};
extern VTBL_ENTRY _ZTI7S1409C2[];
extern  VTBL_ENTRY _ZTV7S1409C2[];
Class_Descriptor cd_S1409C2 = {  "S1409C2", // class name
  bases_S1409C2, 2,
  &(vtc_S1409C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(680,524), // object size
  NSPAIRA(_ZTI7S1409C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1409C2),214, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1409C31  : S1409C8_nt {
};
//SIG(-1 S1409C31) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1409C31()
{
  extern Class_Descriptor cd_S1409C31;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1409C31, buf);
    S1409C31 &lv = *(new (buf) S1409C31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1409C31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1409C31)");
    check_base_class_offset(lv, (S1409C8_nt*), 0, "S1409C31");
    test_class_info(&lv, &cd_S1409C31);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1409C31(Test_S1409C31, "S1409C31", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1409C8_nt;
extern VTBL_ENTRY _ZTI10S1409C8_nt[];
static Base_Class bases_S1409C31[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1409C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1409C31 = {  "S1409C31", // class name
  bases_S1409C31, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1409C30  : S1409C31 {
};
//SIG(-1 S1409C30) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1409C30()
{
  extern Class_Descriptor cd_S1409C30;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1409C30, buf);
    S1409C30 &lv = *(new (buf) S1409C30());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1409C30)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1409C30)");
    check_base_class_offset(lv, (S1409C8_nt*)(S1409C31*), 0, "S1409C30");
    check_base_class_offset(lv, (S1409C31*), 0, "S1409C30");
    test_class_info(&lv, &cd_S1409C30);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1409C30(Test_S1409C30, "S1409C30", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1409C8_nt;
extern VTBL_ENTRY _ZTI10S1409C8_nt[];
extern Class_Descriptor cd_S1409C31;
static Base_Class bases_S1409C30[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1409C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1409C31,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1409C30 = {  "S1409C30", // class name
  bases_S1409C30, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1409C1  : S1409C2 {
  ::S1409C30 s1409c1f0;
  virtual  ~S1409C1(); // _ZN7S1409C1D1Ev
  virtual void  v1(); // _ZN7S1409C12v1Ev
  virtual void  v2(); // _ZN7S1409C12v2Ev
  virtual void  v3(); // _ZN7S1409C12v3Ev
  S1409C1(); // tgen
};
//SIG(1 S1409C1) C1{ BC2{ BC3{ BC4{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC6 FC9{ m Fi} Fi Fc[4] Fp[2] FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC5 FC5 FC5 FC10{ BC11{ BC8}} FC10 Fi Fp[2] FC12{ m Fi[3]} FC12 FC12 FC12 Fp FC5 FC10 FC12 FC12 Fi FC12 FC12 Fp Fi Fc FC12 FC12 Fp Fi Fp FC10 FC13{ BC14{ BC8}} FC13} vd v211 v212 v213 Fp FC15{ BC16{ BC8}} FC15 Fi Fi:1 Fi:1 FC15 Fi[4] FC17{ BC18{ BC8}} FC17} vd v1 v2 v3 FC19{ BC20{ BC8}}}


 S1409C1 ::~S1409C1(){ note_dtor("S1409C1", this);}
void  S1409C1 ::v1(){vfunc_called(this, "_ZN7S1409C12v1Ev");}
void  S1409C1 ::v2(){vfunc_called(this, "_ZN7S1409C12v2Ev");}
void  S1409C1 ::v3(){vfunc_called(this, "_ZN7S1409C12v3Ev");}
S1409C1 ::S1409C1(){ note_ctor("S1409C1", this);} // tgen

static void Test_S1409C1()
{
  extern Class_Descriptor cd_S1409C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(88,135)];
    init_test(&cd_S1409C1, buf);
    S1409C1 *dp, &lv = *(dp=new (buf) S1409C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(696,536), "sizeof(S1409C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1409C1)");
    check_base_class_offset(lv, (S1409C4_nt*)(S1409C3_nt*)(S1409C2*), 0, "S1409C1");
    check_base_class_offset(lv, (S1409C3_nt*)(S1409C2*), 0, "S1409C1");
    check_base_class_offset(lv, (S1409C2*), 0, "S1409C1");
    check_field_offset(lv, s1409c1f0, ABISELECT(680,524), "S1409C1.s1409c1f0");
    test_class_info(&lv, &cd_S1409C1);
    dp->~S1409C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1409C1(Test_S1409C1, "S1409C1", ABISELECT(696,536));

#else // __cplusplus

extern void _ZN7S1409C1C1Ev();
extern void _ZN7S1409C1D1Ev();
Name_Map name_map_S1409C1[] = {
  NSPAIR(_ZN7S1409C1C1Ev),
  NSPAIR(_ZN7S1409C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1409C4_nt;
extern VTBL_ENTRY _ZTI10S1409C4_nt[];
extern  VTBL_ENTRY _ZTV10S1409C4_nt[];
extern Class_Descriptor cd_S1409C3_nt;
extern VTBL_ENTRY _ZTI10S1409C3_nt[];
extern  VTBL_ENTRY _ZTV10S1409C3_nt[];
extern Class_Descriptor cd_S1409C2;
extern VTBL_ENTRY _ZTI7S1409C2[];
extern  VTBL_ENTRY _ZTV7S1409C2[];
static Base_Class bases_S1409C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1409C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1409C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1409C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1409C1[];
extern void _ZN7S1409C1D1Ev();
extern void _ZN7S1409C1D0Ev();
extern void _ZN10S1409C4_nt2v4Ev();
extern void _ZN10S1409C4_nt2v5Ev();
extern void _ZN10S1409C4_nt2v6Ev();
extern void _ZN10S1409C4_nt2v7Ev();
extern void _ZN10S1409C4_nt2v8Ev();
extern void _ZN10S1409C4_nt2v9Ev();
extern void _ZN10S1409C4_nt3v10Ev();
extern void _ZN10S1409C4_nt3v11Ev();
extern void _ZN10S1409C4_nt3v12Ev();
extern void _ZN10S1409C4_nt3v13Ev();
extern void _ZN10S1409C4_nt3v14Ev();
extern void _ZN10S1409C4_nt3v15Ev();
extern void _ZN10S1409C4_nt3v16Ev();
extern void _ZN10S1409C4_nt3v17Ev();
extern void _ZN10S1409C4_nt3v18Ev();
extern void _ZN10S1409C4_nt3v19Ev();
extern void _ZN10S1409C4_nt3v20Ev();
extern void _ZN10S1409C4_nt3v21Ev();
extern void _ZN10S1409C4_nt3v22Ev();
extern void _ZN10S1409C4_nt3v23Ev();
extern void _ZN10S1409C4_nt3v24Ev();
extern void _ZN10S1409C4_nt3v25Ev();
extern void _ZN10S1409C4_nt3v26Ev();
extern void _ZN10S1409C4_nt3v27Ev();
extern void _ZN10S1409C4_nt3v28Ev();
extern void _ZN10S1409C4_nt3v29Ev();
extern void _ZN10S1409C4_nt3v30Ev();
extern void _ZN10S1409C4_nt3v31Ev();
extern void _ZN10S1409C4_nt3v32Ev();
extern void _ZN10S1409C4_nt3v33Ev();
extern void _ZN10S1409C4_nt3v34Ev();
extern void _ZN10S1409C4_nt3v35Ev();
extern void _ZN10S1409C4_nt3v36Ev();
extern void _ZN10S1409C4_nt3v37Ev();
extern void _ZN10S1409C4_nt3v38Ev();
extern void _ZN10S1409C4_nt3v39Ev();
extern void _ZN10S1409C4_nt3v40Ev();
extern void _ZN10S1409C4_nt3v41Ev();
extern void _ZN10S1409C4_nt3v42Ev();
extern void _ZN10S1409C4_nt3v43Ev();
extern void _ZN10S1409C4_nt3v44Ev();
extern void _ZN10S1409C4_nt3v45Ev();
extern void _ZN10S1409C4_nt3v46Ev();
extern void _ZN10S1409C4_nt3v47Ev();
extern void _ZN10S1409C4_nt3v48Ev();
extern void _ZN10S1409C4_nt3v49Ev();
extern void _ZN10S1409C4_nt3v50Ev();
extern void _ZN10S1409C4_nt3v51Ev();
extern void _ZN10S1409C4_nt3v52Ev();
extern void _ZN10S1409C4_nt3v53Ev();
extern void _ZN10S1409C4_nt3v54Ev();
extern void _ZN10S1409C4_nt3v55Ev();
extern void _ZN10S1409C4_nt3v56Ev();
extern void _ZN10S1409C4_nt3v57Ev();
extern void _ZN10S1409C4_nt3v58Ev();
extern void _ZN10S1409C4_nt3v59Ev();
extern void _ZN10S1409C4_nt3v60Ev();
extern void _ZN10S1409C4_nt3v61Ev();
extern void _ZN10S1409C4_nt3v62Ev();
extern void _ZN10S1409C4_nt3v63Ev();
extern void _ZN10S1409C4_nt3v64Ev();
extern void _ZN10S1409C4_nt3v65Ev();
extern void _ZN10S1409C4_nt3v66Ev();
extern void _ZN10S1409C4_nt3v67Ev();
extern void _ZN10S1409C3_nt3v68Ev();
extern void _ZN10S1409C3_nt3v69Ev();
extern void _ZN10S1409C3_nt3v70Ev();
extern void _ZN10S1409C3_nt3v71Ev();
extern void _ZN10S1409C3_nt3v72Ev();
extern void _ZN10S1409C3_nt3v73Ev();
extern void _ZN10S1409C3_nt3v74Ev();
extern void _ZN10S1409C3_nt3v75Ev();
extern void _ZN10S1409C3_nt3v76Ev();
extern void _ZN10S1409C3_nt3v77Ev();
extern void _ZN10S1409C3_nt3v78Ev();
extern void _ZN10S1409C3_nt3v79Ev();
extern void _ZN10S1409C3_nt3v80Ev();
extern void _ZN10S1409C3_nt3v81Ev();
extern void _ZN10S1409C3_nt3v82Ev();
extern void _ZN10S1409C3_nt3v83Ev();
extern void _ZN10S1409C3_nt3v84Ev();
extern void _ZN10S1409C3_nt3v85Ev();
extern void _ZN10S1409C3_nt3v86Ev();
extern void _ZN10S1409C3_nt3v87Ev();
extern void _ZN10S1409C3_nt3v88Ev();
extern void _ZN10S1409C3_nt3v89Ev();
extern void _ZN10S1409C3_nt3v90Ev();
extern void _ZN10S1409C3_nt3v91Ev();
extern void _ZN10S1409C3_nt3v92Ev();
extern void _ZN10S1409C3_nt3v93Ev();
extern void _ZN10S1409C3_nt3v94Ev();
extern void _ZN10S1409C3_nt3v95Ev();
extern void _ZN10S1409C3_nt3v96Ev();
extern void _ZN10S1409C3_nt3v97Ev();
extern void _ZN10S1409C3_nt3v98Ev();
extern void _ZN10S1409C3_nt3v99Ev();
extern void _ZN10S1409C3_nt4v100Ev();
extern void _ZN10S1409C3_nt4v101Ev();
extern void _ZN10S1409C3_nt4v102Ev();
extern void _ZN10S1409C3_nt4v103Ev();
extern void _ZN10S1409C3_nt4v104Ev();
extern void _ZN10S1409C3_nt4v105Ev();
extern void _ZN10S1409C3_nt4v106Ev();
extern void _ZN10S1409C3_nt4v107Ev();
extern void _ZN10S1409C3_nt4v108Ev();
extern void _ZN10S1409C3_nt4v109Ev();
extern void _ZN10S1409C3_nt4v110Ev();
extern void _ZN10S1409C3_nt4v111Ev();
extern void _ZN10S1409C3_nt4v112Ev();
extern void _ZN10S1409C3_nt4v113Ev();
extern void _ZN10S1409C3_nt4v114Ev();
extern void _ZN10S1409C3_nt4v115Ev();
extern void _ZN10S1409C3_nt4v116Ev();
extern void _ZN10S1409C3_nt4v117Ev();
extern void _ZN10S1409C3_nt4v118Ev();
extern void _ZN10S1409C3_nt4v119Ev();
extern void _ZN10S1409C3_nt4v120Ev();
extern void _ZN10S1409C3_nt4v121Ev();
extern void _ZN10S1409C3_nt4v122Ev();
extern void _ZN10S1409C3_nt4v123Ev();
extern void _ZN10S1409C3_nt4v124Ev();
extern void _ZN10S1409C3_nt4v125Ev();
extern void _ZN10S1409C3_nt4v126Ev();
extern void _ZN10S1409C3_nt4v127Ev();
extern void _ZN10S1409C3_nt4v128Ev();
extern void _ZN10S1409C3_nt4v129Ev();
extern void _ZN10S1409C3_nt4v130Ev();
extern void _ZN10S1409C3_nt4v131Ev();
extern void _ZN10S1409C3_nt4v132Ev();
extern void _ZN10S1409C3_nt4v133Ev();
extern void _ZN10S1409C3_nt4v134Ev();
extern void _ZN10S1409C3_nt4v135Ev();
extern void _ZN10S1409C3_nt4v136Ev();
extern void _ZN10S1409C3_nt4v137Ev();
extern void _ZN10S1409C3_nt4v138Ev();
extern void _ZN10S1409C3_nt4v139Ev();
extern void _ZN10S1409C3_nt4v140Ev();
extern void _ZN10S1409C3_nt4v141Ev();
extern void _ZN10S1409C3_nt4v142Ev();
extern void _ZN10S1409C3_nt4v143Ev();
extern void _ZN10S1409C3_nt4v144Ev();
extern void _ZN10S1409C3_nt4v145Ev();
extern void _ZN10S1409C3_nt4v146Ev();
extern void _ZN10S1409C3_nt4v147Ev();
extern void _ZN10S1409C3_nt4v148Ev();
extern void _ZN10S1409C3_nt4v149Ev();
extern void _ZN10S1409C3_nt4v150Ev();
extern void _ZN10S1409C3_nt4v151Ev();
extern void _ZN10S1409C3_nt4v152Ev();
extern void _ZN10S1409C3_nt4v153Ev();
extern void _ZN10S1409C3_nt4v154Ev();
extern void _ZN10S1409C3_nt4v155Ev();
extern void _ZN10S1409C3_nt4v156Ev();
extern void _ZN10S1409C3_nt4v157Ev();
extern void _ZN10S1409C3_nt4v158Ev();
extern void _ZN10S1409C3_nt4v159Ev();
extern void _ZN10S1409C3_nt4v160Ev();
extern void _ZN10S1409C3_nt4v161Ev();
extern void _ZN10S1409C3_nt4v162Ev();
extern void _ZN10S1409C3_nt4v163Ev();
extern void _ZN10S1409C3_nt4v164Ev();
extern void _ZN10S1409C3_nt4v165Ev();
extern void _ZN10S1409C3_nt4v166Ev();
extern void _ZN10S1409C3_nt4v167Ev();
extern void _ZN10S1409C3_nt4v168Ev();
extern void _ZN10S1409C3_nt4v169Ev();
extern void _ZN10S1409C3_nt4v170Ev();
extern void _ZN10S1409C3_nt4v171Ev();
extern void _ZN10S1409C3_nt4v172Ev();
extern void _ZN10S1409C3_nt4v173Ev();
extern void _ZN10S1409C3_nt4v174Ev();
extern void _ZN10S1409C3_nt4v175Ev();
extern void _ZN10S1409C3_nt4v176Ev();
extern void _ZN10S1409C3_nt4v177Ev();
extern void _ZN10S1409C3_nt4v178Ev();
extern void _ZN10S1409C3_nt4v179Ev();
extern void _ZN10S1409C3_nt4v180Ev();
extern void _ZN10S1409C3_nt4v181Ev();
extern void _ZN10S1409C3_nt4v182Ev();
extern void _ZN10S1409C3_nt4v183Ev();
extern void _ZN10S1409C3_nt4v184Ev();
extern void _ZN10S1409C3_nt4v185Ev();
extern void _ZN10S1409C3_nt4v186Ev();
extern void _ZN10S1409C3_nt4v187Ev();
extern void _ZN10S1409C3_nt4v188Ev();
extern void _ZN10S1409C3_nt4v189Ev();
extern void _ZN10S1409C3_nt4v190Ev();
extern void _ZN10S1409C3_nt4v191Ev();
extern void _ZN10S1409C3_nt4v192Ev();
extern void _ZN10S1409C3_nt4v193Ev();
extern void _ZN10S1409C3_nt4v194Ev();
extern void _ZN10S1409C3_nt4v195Ev();
extern void _ZN10S1409C3_nt4v196Ev();
extern void _ZN10S1409C3_nt4v197Ev();
extern void _ZN10S1409C3_nt4v198Ev();
extern void _ZN10S1409C3_nt4v199Ev();
extern void _ZN10S1409C3_nt4v200Ev();
extern void _ZN10S1409C3_nt4v201Ev();
extern void _ZN10S1409C3_nt4v202Ev();
extern void _ZN10S1409C3_nt4v203Ev();
extern void _ZN10S1409C3_nt4v204Ev();
extern void _ZN10S1409C3_nt4v205Ev();
extern void _ZN10S1409C3_nt4v206Ev();
extern void _ZN10S1409C3_nt4v207Ev();
extern void _ZN10S1409C3_nt4v208Ev();
extern void _ZN10S1409C3_nt4v209Ev();
extern void _ZN10S1409C3_nt4v210Ev();
extern void _ZN7S1409C24v211Ev();
extern void _ZN7S1409C24v212Ev();
extern void _ZN7S1409C24v213Ev();
extern void _ZN7S1409C12v1Ev();
extern void _ZN7S1409C12v2Ev();
extern void _ZN7S1409C12v3Ev();
static  VTBL_ENTRY vtc_S1409C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1409C1[0]),
  (VTBL_ENTRY)&_ZN7S1409C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1409C1D0Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1409C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S1409C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN7S1409C24v211Ev,
  (VTBL_ENTRY)&_ZN7S1409C24v212Ev,
  (VTBL_ENTRY)&_ZN7S1409C24v213Ev,
  (VTBL_ENTRY)&_ZN7S1409C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1409C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1409C12v3Ev,
};
extern VTBL_ENTRY _ZTI7S1409C1[];
extern  VTBL_ENTRY _ZTV7S1409C1[];
Class_Descriptor cd_S1409C1 = {  "S1409C1", // class name
  bases_S1409C1, 3,
  &(vtc_S1409C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(696,536), // object size
  NSPAIRA(_ZTI7S1409C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1409C1),217, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2265C7_nt  {
  void  mf2265c7(); // _ZN10S2265C7_nt8mf2265c7Ev
};
//SIG(-1 S2265C7_nt) C1{ m}


void  S2265C7_nt ::mf2265c7(){}

//skip512 S2265C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2265C6_nt  {
  void *s2265c6f0;
  int s2265c6f1;
  ::S2265C7_nt s2265c6f2;
  ::S2265C7_nt s2265c6f3;
  void  mf2265c6(); // _ZN10S2265C6_nt8mf2265c6Ev
};
//SIG(-1 S2265C6_nt) C1{ m Fp Fi FC2{ m} FC2}


void  S2265C6_nt ::mf2265c6(){}

//skip512 S2265C6_nt

#else // __cplusplus

Class_Descriptor cd_S2265C6_nt = {  "S2265C6_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2265C5_nt  : S2265C6_nt {
};
//SIG(-1 S2265C5_nt) C1{ BC2{ m Fp Fi FC3{ m} FC3}}



//skip512 S2265C5_nt

#else // __cplusplus

extern Class_Descriptor cd_S2265C6_nt;
static Base_Class bases_S2265C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2265C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2265C4_nt  {
  void *s2265c4f0;
  int s2265c4f1;
  ::S2265C5_nt s2265c4f2;
  ::S2265C5_nt s2265c4f3;
  int s2265c4f4;
  virtual  ~S2265C4_nt(); // _ZN10S2265C4_ntD1Ev
  virtual void  v4(); // _ZN10S2265C4_nt2v4Ev
  virtual void  v5(); // _ZN10S2265C4_nt2v5Ev
  virtual void  v6(); // _ZN10S2265C4_nt2v6Ev
  virtual void  v7(); // _ZN10S2265C4_nt2v7Ev
  virtual void  v8(); // _ZN10S2265C4_nt2v8Ev
  virtual void  v9(); // _ZN10S2265C4_nt2v9Ev
  virtual void  v10(); // _ZN10S2265C4_nt3v10Ev
  virtual void  v11(); // _ZN10S2265C4_nt3v11Ev
  virtual void  v12(); // _ZN10S2265C4_nt3v12Ev
  virtual void  v13(); // _ZN10S2265C4_nt3v13Ev
  virtual void  v14(); // _ZN10S2265C4_nt3v14Ev
  virtual void  v15(); // _ZN10S2265C4_nt3v15Ev
  virtual void  v16(); // _ZN10S2265C4_nt3v16Ev
  virtual void  v17(); // _ZN10S2265C4_nt3v17Ev
  virtual void  v18(); // _ZN10S2265C4_nt3v18Ev
  virtual void  v19(); // _ZN10S2265C4_nt3v19Ev
  virtual void  v20(); // _ZN10S2265C4_nt3v20Ev
  virtual void  v21(); // _ZN10S2265C4_nt3v21Ev
  virtual void  v22(); // _ZN10S2265C4_nt3v22Ev
  virtual void  v23(); // _ZN10S2265C4_nt3v23Ev
  virtual void  v24(); // _ZN10S2265C4_nt3v24Ev
  virtual void  v25(); // _ZN10S2265C4_nt3v25Ev
  virtual void  v26(); // _ZN10S2265C4_nt3v26Ev
  S2265C4_nt(); // tgen
};
//SIG(-1 S2265C4_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC2{ BC3{ m Fp Fi FC4{ m} FC4}} FC2 Fi}


 S2265C4_nt ::~S2265C4_nt(){ note_dtor("S2265C4_nt", this);}
void  S2265C4_nt ::v4(){vfunc_called(this, "_ZN10S2265C4_nt2v4Ev");}
void  S2265C4_nt ::v5(){vfunc_called(this, "_ZN10S2265C4_nt2v5Ev");}
void  S2265C4_nt ::v6(){vfunc_called(this, "_ZN10S2265C4_nt2v6Ev");}
void  S2265C4_nt ::v7(){vfunc_called(this, "_ZN10S2265C4_nt2v7Ev");}
void  S2265C4_nt ::v8(){vfunc_called(this, "_ZN10S2265C4_nt2v8Ev");}
void  S2265C4_nt ::v9(){vfunc_called(this, "_ZN10S2265C4_nt2v9Ev");}
void  S2265C4_nt ::v10(){vfunc_called(this, "_ZN10S2265C4_nt3v10Ev");}
void  S2265C4_nt ::v11(){vfunc_called(this, "_ZN10S2265C4_nt3v11Ev");}
void  S2265C4_nt ::v12(){vfunc_called(this, "_ZN10S2265C4_nt3v12Ev");}
void  S2265C4_nt ::v13(){vfunc_called(this, "_ZN10S2265C4_nt3v13Ev");}
void  S2265C4_nt ::v14(){vfunc_called(this, "_ZN10S2265C4_nt3v14Ev");}
void  S2265C4_nt ::v15(){vfunc_called(this, "_ZN10S2265C4_nt3v15Ev");}
void  S2265C4_nt ::v16(){vfunc_called(this, "_ZN10S2265C4_nt3v16Ev");}
void  S2265C4_nt ::v17(){vfunc_called(this, "_ZN10S2265C4_nt3v17Ev");}
void  S2265C4_nt ::v18(){vfunc_called(this, "_ZN10S2265C4_nt3v18Ev");}
void  S2265C4_nt ::v19(){vfunc_called(this, "_ZN10S2265C4_nt3v19Ev");}
void  S2265C4_nt ::v20(){vfunc_called(this, "_ZN10S2265C4_nt3v20Ev");}
void  S2265C4_nt ::v21(){vfunc_called(this, "_ZN10S2265C4_nt3v21Ev");}
void  S2265C4_nt ::v22(){vfunc_called(this, "_ZN10S2265C4_nt3v22Ev");}
void  S2265C4_nt ::v23(){vfunc_called(this, "_ZN10S2265C4_nt3v23Ev");}
void  S2265C4_nt ::v24(){vfunc_called(this, "_ZN10S2265C4_nt3v24Ev");}
void  S2265C4_nt ::v25(){vfunc_called(this, "_ZN10S2265C4_nt3v25Ev");}
void  S2265C4_nt ::v26(){vfunc_called(this, "_ZN10S2265C4_nt3v26Ev");}
S2265C4_nt ::S2265C4_nt(){ note_ctor("S2265C4_nt", this);} // tgen

//skip512 S2265C4_nt

#else // __cplusplus

extern void _ZN10S2265C4_ntC1Ev();
extern void _ZN10S2265C4_ntD1Ev();
Name_Map name_map_S2265C4_nt[] = {
  NSPAIR(_ZN10S2265C4_ntC1Ev),
  NSPAIR(_ZN10S2265C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S2265C4_nt[];
extern void _ZN10S2265C4_ntD1Ev();
extern void _ZN10S2265C4_ntD0Ev();
extern void _ZN10S2265C4_nt2v4Ev();
extern void _ZN10S2265C4_nt2v5Ev();
extern void _ZN10S2265C4_nt2v6Ev();
extern void _ZN10S2265C4_nt2v7Ev();
extern void _ZN10S2265C4_nt2v8Ev();
extern void _ZN10S2265C4_nt2v9Ev();
extern void _ZN10S2265C4_nt3v10Ev();
extern void _ZN10S2265C4_nt3v11Ev();
extern void _ZN10S2265C4_nt3v12Ev();
extern void _ZN10S2265C4_nt3v13Ev();
extern void _ZN10S2265C4_nt3v14Ev();
extern void _ZN10S2265C4_nt3v15Ev();
extern void _ZN10S2265C4_nt3v16Ev();
extern void _ZN10S2265C4_nt3v17Ev();
extern void _ZN10S2265C4_nt3v18Ev();
extern void _ZN10S2265C4_nt3v19Ev();
extern void _ZN10S2265C4_nt3v20Ev();
extern void _ZN10S2265C4_nt3v21Ev();
extern void _ZN10S2265C4_nt3v22Ev();
extern void _ZN10S2265C4_nt3v23Ev();
extern void _ZN10S2265C4_nt3v24Ev();
extern void _ZN10S2265C4_nt3v25Ev();
extern void _ZN10S2265C4_nt3v26Ev();
static  VTBL_ENTRY vtc_S2265C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2265C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S2265C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v26Ev,
};
extern VTBL_ENTRY _ZTI10S2265C4_nt[];
VTBL_ENTRY *P__ZTI10S2265C4_nt = _ZTI10S2265C4_nt; 
extern  VTBL_ENTRY _ZTV10S2265C4_nt[];
Class_Descriptor cd_S2265C4_nt = {  "S2265C4_nt", // class name
  0,0,//no base classes
  &(vtc_S2265C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI10S2265C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S2265C4_nt),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2265C14_nt  {
  __tsi64 s2265c14f0[2];
  void  mf2265c14(); // _ZN11S2265C14_nt9mf2265c14Ev
};
//SIG(-1 S2265C14_nt) C1{ m FL[2]}


void  S2265C14_nt ::mf2265c14(){}

//skip512 S2265C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2265C13_nt  {
  ::S2265C14_nt s2265c13f0;
  void  mf2265c13(); // _ZN11S2265C13_nt9mf2265c13Ev
};
//SIG(-1 S2265C13_nt) C1{ m FC2{ m FL[2]}}


void  S2265C13_nt ::mf2265c13(){}

//skip512 S2265C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2265C17_nt  {
  ::S2265C13_nt s2265c17f0;
  void  mf2265c17(); // _ZN11S2265C17_nt9mf2265c17Ev
};
//SIG(-1 S2265C17_nt) C1{ m FC2{ m FC3{ m FL[2]}}}


void  S2265C17_nt ::mf2265c17(){}

//skip512 S2265C17_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2265C18_nt  {
  ::S2265C13_nt s2265c18f0;
  ::S2265C13_nt s2265c18f1;
  ::S2265C13_nt s2265c18f2;
  ::S2265C13_nt s2265c18f3;
  void  mf2265c18(); // _ZN11S2265C18_nt9mf2265c18Ev
};
//SIG(-1 S2265C18_nt) C1{ m FC2{ m FC3{ m FL[2]}} FC2 FC2 FC2}


void  S2265C18_nt ::mf2265c18(){}

//skip512 S2265C18_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2265C21  {
  void  mf2265c21(); // _ZN8S2265C219mf2265c21Ev
};
//SIG(-1 S2265C21) C1{ m}


void  S2265C21 ::mf2265c21(){}

static void Test_S2265C21()
{
  {
    init_simple_test("S2265C21");
    S2265C21 lv;
    check2(sizeof(lv), 1, "sizeof(S2265C21)");
    check2(__alignof__(lv), 1, "__alignof__(S2265C21)");
  }
}
static Arrange_To_Call_Me vS2265C21(Test_S2265C21, "S2265C21", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S2265C21[];
VTBL_ENTRY *P__ZTI8S2265C21 = _ZTI8S2265C21; 
Class_Descriptor cd_S2265C21 = {  "S2265C21", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S2265C21),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2265C20_nt  {
  void *s2265c20f0;
  int s2265c20f1;
  ::S2265C21 s2265c20f2;
  void  mf2265c20(); // _ZN11S2265C20_nt9mf2265c20Ev
};
//SIG(-1 S2265C20_nt) C1{ m Fp Fi FC2{ m}}


void  S2265C20_nt ::mf2265c20(){}

//skip512 S2265C20_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2265C19_nt  {
  ::S2265C20_nt s2265c19f0;
  int s2265c19f1;
  void  mf2265c19(); // _ZN11S2265C19_nt9mf2265c19Ev
};
//SIG(-1 S2265C19_nt) C1{ m FC2{ m Fp Fi FC3{ m}} Fi}


void  S2265C19_nt ::mf2265c19(){}

//skip512 S2265C19_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2265C24  {
  void  mf2265c24(); // _ZN8S2265C249mf2265c24Ev
};
//SIG(-1 S2265C24) C1{ m}


void  S2265C24 ::mf2265c24(){}

static void Test_S2265C24()
{
  {
    init_simple_test("S2265C24");
    S2265C24 lv;
    check2(sizeof(lv), 1, "sizeof(S2265C24)");
    check2(__alignof__(lv), 1, "__alignof__(S2265C24)");
  }
}
static Arrange_To_Call_Me vS2265C24(Test_S2265C24, "S2265C24", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S2265C24[];
VTBL_ENTRY *P__ZTI8S2265C24 = _ZTI8S2265C24; 
Class_Descriptor cd_S2265C24 = {  "S2265C24", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S2265C24),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2265C22  {
  void *s2265c22f0;
  int s2265c22f1;
  ::S2265C21 s2265c22f2;
  ::S2265C24 s2265c22f3;
  void  mf2265c22(); // _ZN8S2265C229mf2265c22Ev
};
//SIG(-1 S2265C22) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S2265C22 ::mf2265c22(){}

static void Test_S2265C22()
{
  {
    init_simple_test("S2265C22");
    S2265C22 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2265C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2265C22)");
    check_field_offset(lv, s2265c22f0, 0, "S2265C22.s2265c22f0");
    check_field_offset(lv, s2265c22f1, ABISELECT(8,4), "S2265C22.s2265c22f1");
    check_field_offset(lv, s2265c22f2, ABISELECT(12,8), "S2265C22.s2265c22f2");
    check_field_offset(lv, s2265c22f3, ABISELECT(13,9), "S2265C22.s2265c22f3");
  }
}
static Arrange_To_Call_Me vS2265C22(Test_S2265C22, "S2265C22", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2265C28  {
  void  mf2265c28(); // _ZN8S2265C289mf2265c28Ev
};
//SIG(-1 S2265C28) C1{ m}


void  S2265C28 ::mf2265c28(){}

static void Test_S2265C28()
{
  {
    init_simple_test("S2265C28");
    S2265C28 lv;
    check2(sizeof(lv), 1, "sizeof(S2265C28)");
    check2(__alignof__(lv), 1, "__alignof__(S2265C28)");
  }
}
static Arrange_To_Call_Me vS2265C28(Test_S2265C28, "S2265C28", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S2265C28[];
VTBL_ENTRY *P__ZTI8S2265C28 = _ZTI8S2265C28; 
Class_Descriptor cd_S2265C28 = {  "S2265C28", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S2265C28),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2265C26  {
  void *s2265c26f0;
  int s2265c26f1;
  ::S2265C24 s2265c26f2;
  ::S2265C28 s2265c26f3;
  void  mf2265c26(); // _ZN8S2265C269mf2265c26Ev
};
//SIG(-1 S2265C26) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S2265C26 ::mf2265c26(){}

static void Test_S2265C26()
{
  {
    init_simple_test("S2265C26");
    S2265C26 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2265C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2265C26)");
    check_field_offset(lv, s2265c26f0, 0, "S2265C26.s2265c26f0");
    check_field_offset(lv, s2265c26f1, ABISELECT(8,4), "S2265C26.s2265c26f1");
    check_field_offset(lv, s2265c26f2, ABISELECT(12,8), "S2265C26.s2265c26f2");
    check_field_offset(lv, s2265c26f3, ABISELECT(13,9), "S2265C26.s2265c26f3");
  }
}
static Arrange_To_Call_Me vS2265C26(Test_S2265C26, "S2265C26", ABISELECT(16,12));

#else // __cplusplus

Class_Descriptor cd_S2265C26 = {  "S2265C26", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2265C25  : S2265C26 {
};
//SIG(-1 S2265C25) C1{ BC2{ m Fp Fi FC3{ m} FC4{ m}}}



static void Test_S2265C25()
{
  extern Class_Descriptor cd_S2265C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S2265C25, buf);
    S2265C25 &lv = *(new (buf) S2265C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2265C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2265C25)");
    check_base_class_offset(lv, (S2265C26*), 0, "S2265C25");
    test_class_info(&lv, &cd_S2265C25);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2265C25(Test_S2265C25, "S2265C25", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S2265C26;
static Base_Class bases_S2265C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2265C26,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S2265C25 = {  "S2265C25", // class name
  bases_S2265C25, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2265C29_nt  {
  void *s2265c29f0;
  int s2265c29f1[2];
  ::S2265C28 s2265c29f2;
  void  mf2265c29(); // _ZN11S2265C29_nt9mf2265c29Ev
};
//SIG(-1 S2265C29_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S2265C29_nt ::mf2265c29(){}

//skip512 S2265C29_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2265C38  {
  void  mf2265c38(); // _ZN8S2265C389mf2265c38Ev
};
//SIG(-1 S2265C38) C1{ m}


void  S2265C38 ::mf2265c38(){}

static void Test_S2265C38()
{
  {
    init_simple_test("S2265C38");
    S2265C38 lv;
    check2(sizeof(lv), 1, "sizeof(S2265C38)");
    check2(__alignof__(lv), 1, "__alignof__(S2265C38)");
  }
}
static Arrange_To_Call_Me vS2265C38(Test_S2265C38, "S2265C38", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S2265C38[];
VTBL_ENTRY *P__ZTI8S2265C38 = _ZTI8S2265C38; 
Class_Descriptor cd_S2265C38 = {  "S2265C38", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S2265C38),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2265C37  {
  void *s2265c37f0;
  int s2265c37f1[2];
  ::S2265C38 s2265c37f2;
  void  mf2265c37(); // _ZN8S2265C379mf2265c37Ev
};
//SIG(-1 S2265C37) C1{ m Fp Fi[2] FC2{ m}}


void  S2265C37 ::mf2265c37(){}

static void Test_S2265C37()
{
  {
    init_simple_test("S2265C37");
    S2265C37 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S2265C37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2265C37)");
    check_field_offset(lv, s2265c37f0, 0, "S2265C37.s2265c37f0");
    check_field_offset(lv, s2265c37f1, ABISELECT(8,4), "S2265C37.s2265c37f1");
    check_field_offset(lv, s2265c37f2, ABISELECT(16,12), "S2265C37.s2265c37f2");
  }
}
static Arrange_To_Call_Me vS2265C37(Test_S2265C37, "S2265C37", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2265C3_nt  : S2265C4_nt {
  ::S2265C13_nt s2265c3f0;
  ::S2265C13_nt s2265c3f1;
  ::S2265C13_nt s2265c3f2;
  ::S2265C13_nt s2265c3f3;
  ::S2265C17_nt s2265c3f4;
  ::S2265C18_nt s2265c3f5;
  ::S2265C18_nt s2265c3f6;
  ::S2265C13_nt s2265c3f7;
  ::S2265C13_nt s2265c3f8;
  ::S2265C13_nt s2265c3f9;
  void *s2265c3f10;
  ::S2265C17_nt s2265c3f11;
  ::S2265C19_nt s2265c3f12;
  int s2265c3f13;
  void *s2265c3f14[7];
  ::S2265C22 s2265c3f15;
  int s2265c3f16:8;
  int s2265c3f17:8;
  int s2265c3f18:16;
  int s2265c3f19:16;
  int s2265c3f20:8;
  int s2265c3f21:8;
  int s2265c3f22:8;
  int s2265c3f23:32;
  int s2265c3f24:8;
  int s2265c3f25:4;
  int s2265c3f26:4;
  int s2265c3f27:4;
  int s2265c3f28:4;
  int s2265c3f29:4;
  int s2265c3f30:4;
  int s2265c3f31:4;
  int s2265c3f32:4;
  int s2265c3f33:4;
  int s2265c3f34:4;
  unsigned char s2265c3f35:1;
  unsigned char s2265c3f36:1;
  unsigned char s2265c3f37:1;
  unsigned char s2265c3f38:1;
  unsigned char s2265c3f39:1;
  unsigned char s2265c3f40:1;
  unsigned char s2265c3f41:1;
  unsigned char s2265c3f42:1;
  unsigned char s2265c3f43:1;
  unsigned char s2265c3f44:1;
  unsigned char s2265c3f45:1;
  unsigned char s2265c3f46:1;
  unsigned char s2265c3f47:1;
  unsigned char s2265c3f48:1;
  unsigned char s2265c3f49:1;
  unsigned char s2265c3f50:1;
  unsigned char s2265c3f51:1;
  unsigned char s2265c3f52:1;
  unsigned char s2265c3f53:1;
  unsigned char s2265c3f54:1;
  unsigned char s2265c3f55:1;
  unsigned char s2265c3f56:1;
  unsigned char s2265c3f57:1;
  unsigned char s2265c3f58:1;
  unsigned char s2265c3f59:1;
  unsigned char s2265c3f60:1;
  unsigned char s2265c3f61:1;
  unsigned char s2265c3f62:1;
  unsigned char s2265c3f63:1;
  unsigned char s2265c3f64:1;
  unsigned char s2265c3f65:1;
  unsigned char s2265c3f66:1;
  unsigned char s2265c3f67:1;
  unsigned char s2265c3f68:1;
  unsigned char s2265c3f69:1;
  unsigned char s2265c3f70:1;
  unsigned char s2265c3f71:1;
  unsigned char s2265c3f72:1;
  unsigned char s2265c3f73:1;
  unsigned char s2265c3f74:1;
  unsigned char s2265c3f75:1;
  int s2265c3f76[7];
  void *s2265c3f77[6];
  int s2265c3f78:8;
  int s2265c3f79:8;
  int s2265c3f80:8;
  int s2265c3f81:8;
  int s2265c3f82:8;
  int s2265c3f83:8;
  ::S2265C25 s2265c3f84;
  void *s2265c3f85[4];
  int s2265c3f86:8;
  int s2265c3f87:8;
  int s2265c3f88:8;
  int s2265c3f89:8;
  int s2265c3f90:8;
  int s2265c3f91:16;
  int s2265c3f92:16;
  int s2265c3f93:16;
  int s2265c3f94:4;
  int s2265c3f95:4;
  int s2265c3f96:4;
  int s2265c3f97:4;
  int s2265c3f98:4;
  int s2265c3f99:4;
  int s2265c3f100:4;
  int s2265c3f101:4;
  int s2265c3f102:4;
  int s2265c3f103:4;
  int s2265c3f104:4;
  int s2265c3f105:4;
  int s2265c3f106:8;
  int s2265c3f107:8;
  int s2265c3f108:8;
  void *s2265c3f109[7];
  ::S2265C29_nt s2265c3f110;
  void *s2265c3f111[2];
  int s2265c3f112:16;
  int s2265c3f113:16;
  ::S2265C25 s2265c3f114;
  ::S2265C29_nt s2265c3f115;
  ::S2265C37 s2265c3f116;
  void *s2265c3f117[2];
  int s2265c3f118:24;
  int s2265c3f119:8;
  void *s2265c3f120;
  virtual  ~S2265C3_nt(); // _ZN10S2265C3_ntD1Ev
  virtual void  v27(); // _ZN10S2265C3_nt3v27Ev
  virtual void  v28(); // _ZN10S2265C3_nt3v28Ev
  virtual void  v29(); // _ZN10S2265C3_nt3v29Ev
  virtual void  v30(); // _ZN10S2265C3_nt3v30Ev
  virtual void  v31(); // _ZN10S2265C3_nt3v31Ev
  virtual void  v32(); // _ZN10S2265C3_nt3v32Ev
  virtual void  v33(); // _ZN10S2265C3_nt3v33Ev
  virtual void  v34(); // _ZN10S2265C3_nt3v34Ev
  virtual void  v35(); // _ZN10S2265C3_nt3v35Ev
  virtual void  v36(); // _ZN10S2265C3_nt3v36Ev
  virtual void  v37(); // _ZN10S2265C3_nt3v37Ev
  virtual void  v38(); // _ZN10S2265C3_nt3v38Ev
  virtual void  v39(); // _ZN10S2265C3_nt3v39Ev
  virtual void  v40(); // _ZN10S2265C3_nt3v40Ev
  virtual void  v41(); // _ZN10S2265C3_nt3v41Ev
  virtual void  v42(); // _ZN10S2265C3_nt3v42Ev
  virtual void  v43(); // _ZN10S2265C3_nt3v43Ev
  virtual void  v44(); // _ZN10S2265C3_nt3v44Ev
  virtual void  v45(); // _ZN10S2265C3_nt3v45Ev
  virtual void  v46(); // _ZN10S2265C3_nt3v46Ev
  virtual void  v47(); // _ZN10S2265C3_nt3v47Ev
  virtual void  v48(); // _ZN10S2265C3_nt3v48Ev
  virtual void  v49(); // _ZN10S2265C3_nt3v49Ev
  virtual void  v50(); // _ZN10S2265C3_nt3v50Ev
  virtual void  v51(); // _ZN10S2265C3_nt3v51Ev
  virtual void  v52(); // _ZN10S2265C3_nt3v52Ev
  virtual void  v53(); // _ZN10S2265C3_nt3v53Ev
  virtual void  v54(); // _ZN10S2265C3_nt3v54Ev
  virtual void  v55(); // _ZN10S2265C3_nt3v55Ev
  virtual void  v56(); // _ZN10S2265C3_nt3v56Ev
  virtual void  v57(); // _ZN10S2265C3_nt3v57Ev
  virtual void  v58(); // _ZN10S2265C3_nt3v58Ev
  virtual void  v59(); // _ZN10S2265C3_nt3v59Ev
  virtual void  v60(); // _ZN10S2265C3_nt3v60Ev
  virtual void  v61(); // _ZN10S2265C3_nt3v61Ev
  virtual void  v62(); // _ZN10S2265C3_nt3v62Ev
  virtual void  v63(); // _ZN10S2265C3_nt3v63Ev
  virtual void  v64(); // _ZN10S2265C3_nt3v64Ev
  virtual void  v65(); // _ZN10S2265C3_nt3v65Ev
  virtual void  v66(); // _ZN10S2265C3_nt3v66Ev
  virtual void  v67(); // _ZN10S2265C3_nt3v67Ev
  virtual void  v68(); // _ZN10S2265C3_nt3v68Ev
  virtual void  v69(); // _ZN10S2265C3_nt3v69Ev
  virtual void  v70(); // _ZN10S2265C3_nt3v70Ev
  virtual void  v71(); // _ZN10S2265C3_nt3v71Ev
  virtual void  v72(); // _ZN10S2265C3_nt3v72Ev
  virtual void  v73(); // _ZN10S2265C3_nt3v73Ev
  virtual void  v74(); // _ZN10S2265C3_nt3v74Ev
  virtual void  v75(); // _ZN10S2265C3_nt3v75Ev
  virtual void  v76(); // _ZN10S2265C3_nt3v76Ev
  virtual void  v77(); // _ZN10S2265C3_nt3v77Ev
  virtual void  v78(); // _ZN10S2265C3_nt3v78Ev
  virtual void  v79(); // _ZN10S2265C3_nt3v79Ev
  virtual void  v80(); // _ZN10S2265C3_nt3v80Ev
  virtual void  v81(); // _ZN10S2265C3_nt3v81Ev
  virtual void  v82(); // _ZN10S2265C3_nt3v82Ev
  virtual void  v83(); // _ZN10S2265C3_nt3v83Ev
  virtual void  v84(); // _ZN10S2265C3_nt3v84Ev
  virtual void  v85(); // _ZN10S2265C3_nt3v85Ev
  virtual void  v86(); // _ZN10S2265C3_nt3v86Ev
  virtual void  v87(); // _ZN10S2265C3_nt3v87Ev
  virtual void  v88(); // _ZN10S2265C3_nt3v88Ev
  virtual void  v89(); // _ZN10S2265C3_nt3v89Ev
  virtual void  v90(); // _ZN10S2265C3_nt3v90Ev
  virtual void  v91(); // _ZN10S2265C3_nt3v91Ev
  virtual void  v92(); // _ZN10S2265C3_nt3v92Ev
  virtual void  v93(); // _ZN10S2265C3_nt3v93Ev
  virtual void  v94(); // _ZN10S2265C3_nt3v94Ev
  virtual void  v95(); // _ZN10S2265C3_nt3v95Ev
  virtual void  v96(); // _ZN10S2265C3_nt3v96Ev
  virtual void  v97(); // _ZN10S2265C3_nt3v97Ev
  virtual void  v98(); // _ZN10S2265C3_nt3v98Ev
  virtual void  v99(); // _ZN10S2265C3_nt3v99Ev
  virtual void  v100(); // _ZN10S2265C3_nt4v100Ev
  virtual void  v101(); // _ZN10S2265C3_nt4v101Ev
  virtual void  v102(); // _ZN10S2265C3_nt4v102Ev
  virtual void  v103(); // _ZN10S2265C3_nt4v103Ev
  virtual void  v104(); // _ZN10S2265C3_nt4v104Ev
  S2265C3_nt(); // tgen
};
//SIG(-1 S2265C3_nt) C1{ BC2{ vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fp Fi FC3{ BC4{ m Fp Fi FC5{ m} FC5}} FC3 Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 FC6{ m FC7{ m FL[2]}} FC6 FC6 FC6 FC8{ m FC6} FC9{ m FC6 FC6 FC6 FC6} FC9 FC6 FC6 FC6 Fp FC8 FC10{ m FC11{ m Fp Fi FC12{ m}} Fi} Fi Fp[7] FC13{ m Fp Fi FC12 FC14{ m}} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC15{ BC16{ m Fp Fi FC14 FC17{ m}}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC18{ m Fp Fi[2] FC17} Fp[2] Fi:16 Fi:16 FC15 FC18 FC19{ m Fp Fi[2] FC20{ m}} Fp[2] Fi:24 Fi:8 Fp}


 S2265C3_nt ::~S2265C3_nt(){ note_dtor("S2265C3_nt", this);}
void  S2265C3_nt ::v27(){vfunc_called(this, "_ZN10S2265C3_nt3v27Ev");}
void  S2265C3_nt ::v28(){vfunc_called(this, "_ZN10S2265C3_nt3v28Ev");}
void  S2265C3_nt ::v29(){vfunc_called(this, "_ZN10S2265C3_nt3v29Ev");}
void  S2265C3_nt ::v30(){vfunc_called(this, "_ZN10S2265C3_nt3v30Ev");}
void  S2265C3_nt ::v31(){vfunc_called(this, "_ZN10S2265C3_nt3v31Ev");}
void  S2265C3_nt ::v32(){vfunc_called(this, "_ZN10S2265C3_nt3v32Ev");}
void  S2265C3_nt ::v33(){vfunc_called(this, "_ZN10S2265C3_nt3v33Ev");}
void  S2265C3_nt ::v34(){vfunc_called(this, "_ZN10S2265C3_nt3v34Ev");}
void  S2265C3_nt ::v35(){vfunc_called(this, "_ZN10S2265C3_nt3v35Ev");}
void  S2265C3_nt ::v36(){vfunc_called(this, "_ZN10S2265C3_nt3v36Ev");}
void  S2265C3_nt ::v37(){vfunc_called(this, "_ZN10S2265C3_nt3v37Ev");}
void  S2265C3_nt ::v38(){vfunc_called(this, "_ZN10S2265C3_nt3v38Ev");}
void  S2265C3_nt ::v39(){vfunc_called(this, "_ZN10S2265C3_nt3v39Ev");}
void  S2265C3_nt ::v40(){vfunc_called(this, "_ZN10S2265C3_nt3v40Ev");}
void  S2265C3_nt ::v41(){vfunc_called(this, "_ZN10S2265C3_nt3v41Ev");}
void  S2265C3_nt ::v42(){vfunc_called(this, "_ZN10S2265C3_nt3v42Ev");}
void  S2265C3_nt ::v43(){vfunc_called(this, "_ZN10S2265C3_nt3v43Ev");}
void  S2265C3_nt ::v44(){vfunc_called(this, "_ZN10S2265C3_nt3v44Ev");}
void  S2265C3_nt ::v45(){vfunc_called(this, "_ZN10S2265C3_nt3v45Ev");}
void  S2265C3_nt ::v46(){vfunc_called(this, "_ZN10S2265C3_nt3v46Ev");}
void  S2265C3_nt ::v47(){vfunc_called(this, "_ZN10S2265C3_nt3v47Ev");}
void  S2265C3_nt ::v48(){vfunc_called(this, "_ZN10S2265C3_nt3v48Ev");}
void  S2265C3_nt ::v49(){vfunc_called(this, "_ZN10S2265C3_nt3v49Ev");}
void  S2265C3_nt ::v50(){vfunc_called(this, "_ZN10S2265C3_nt3v50Ev");}
void  S2265C3_nt ::v51(){vfunc_called(this, "_ZN10S2265C3_nt3v51Ev");}
void  S2265C3_nt ::v52(){vfunc_called(this, "_ZN10S2265C3_nt3v52Ev");}
void  S2265C3_nt ::v53(){vfunc_called(this, "_ZN10S2265C3_nt3v53Ev");}
void  S2265C3_nt ::v54(){vfunc_called(this, "_ZN10S2265C3_nt3v54Ev");}
void  S2265C3_nt ::v55(){vfunc_called(this, "_ZN10S2265C3_nt3v55Ev");}
void  S2265C3_nt ::v56(){vfunc_called(this, "_ZN10S2265C3_nt3v56Ev");}
void  S2265C3_nt ::v57(){vfunc_called(this, "_ZN10S2265C3_nt3v57Ev");}
void  S2265C3_nt ::v58(){vfunc_called(this, "_ZN10S2265C3_nt3v58Ev");}
void  S2265C3_nt ::v59(){vfunc_called(this, "_ZN10S2265C3_nt3v59Ev");}
void  S2265C3_nt ::v60(){vfunc_called(this, "_ZN10S2265C3_nt3v60Ev");}
void  S2265C3_nt ::v61(){vfunc_called(this, "_ZN10S2265C3_nt3v61Ev");}
void  S2265C3_nt ::v62(){vfunc_called(this, "_ZN10S2265C3_nt3v62Ev");}
void  S2265C3_nt ::v63(){vfunc_called(this, "_ZN10S2265C3_nt3v63Ev");}
void  S2265C3_nt ::v64(){vfunc_called(this, "_ZN10S2265C3_nt3v64Ev");}
void  S2265C3_nt ::v65(){vfunc_called(this, "_ZN10S2265C3_nt3v65Ev");}
void  S2265C3_nt ::v66(){vfunc_called(this, "_ZN10S2265C3_nt3v66Ev");}
void  S2265C3_nt ::v67(){vfunc_called(this, "_ZN10S2265C3_nt3v67Ev");}
void  S2265C3_nt ::v68(){vfunc_called(this, "_ZN10S2265C3_nt3v68Ev");}
void  S2265C3_nt ::v69(){vfunc_called(this, "_ZN10S2265C3_nt3v69Ev");}
void  S2265C3_nt ::v70(){vfunc_called(this, "_ZN10S2265C3_nt3v70Ev");}
void  S2265C3_nt ::v71(){vfunc_called(this, "_ZN10S2265C3_nt3v71Ev");}
void  S2265C3_nt ::v72(){vfunc_called(this, "_ZN10S2265C3_nt3v72Ev");}
void  S2265C3_nt ::v73(){vfunc_called(this, "_ZN10S2265C3_nt3v73Ev");}
void  S2265C3_nt ::v74(){vfunc_called(this, "_ZN10S2265C3_nt3v74Ev");}
void  S2265C3_nt ::v75(){vfunc_called(this, "_ZN10S2265C3_nt3v75Ev");}
void  S2265C3_nt ::v76(){vfunc_called(this, "_ZN10S2265C3_nt3v76Ev");}
void  S2265C3_nt ::v77(){vfunc_called(this, "_ZN10S2265C3_nt3v77Ev");}
void  S2265C3_nt ::v78(){vfunc_called(this, "_ZN10S2265C3_nt3v78Ev");}
void  S2265C3_nt ::v79(){vfunc_called(this, "_ZN10S2265C3_nt3v79Ev");}
void  S2265C3_nt ::v80(){vfunc_called(this, "_ZN10S2265C3_nt3v80Ev");}
void  S2265C3_nt ::v81(){vfunc_called(this, "_ZN10S2265C3_nt3v81Ev");}
void  S2265C3_nt ::v82(){vfunc_called(this, "_ZN10S2265C3_nt3v82Ev");}
void  S2265C3_nt ::v83(){vfunc_called(this, "_ZN10S2265C3_nt3v83Ev");}
void  S2265C3_nt ::v84(){vfunc_called(this, "_ZN10S2265C3_nt3v84Ev");}
void  S2265C3_nt ::v85(){vfunc_called(this, "_ZN10S2265C3_nt3v85Ev");}
void  S2265C3_nt ::v86(){vfunc_called(this, "_ZN10S2265C3_nt3v86Ev");}
void  S2265C3_nt ::v87(){vfunc_called(this, "_ZN10S2265C3_nt3v87Ev");}
void  S2265C3_nt ::v88(){vfunc_called(this, "_ZN10S2265C3_nt3v88Ev");}
void  S2265C3_nt ::v89(){vfunc_called(this, "_ZN10S2265C3_nt3v89Ev");}
void  S2265C3_nt ::v90(){vfunc_called(this, "_ZN10S2265C3_nt3v90Ev");}
void  S2265C3_nt ::v91(){vfunc_called(this, "_ZN10S2265C3_nt3v91Ev");}
void  S2265C3_nt ::v92(){vfunc_called(this, "_ZN10S2265C3_nt3v92Ev");}
void  S2265C3_nt ::v93(){vfunc_called(this, "_ZN10S2265C3_nt3v93Ev");}
void  S2265C3_nt ::v94(){vfunc_called(this, "_ZN10S2265C3_nt3v94Ev");}
void  S2265C3_nt ::v95(){vfunc_called(this, "_ZN10S2265C3_nt3v95Ev");}
void  S2265C3_nt ::v96(){vfunc_called(this, "_ZN10S2265C3_nt3v96Ev");}
void  S2265C3_nt ::v97(){vfunc_called(this, "_ZN10S2265C3_nt3v97Ev");}
void  S2265C3_nt ::v98(){vfunc_called(this, "_ZN10S2265C3_nt3v98Ev");}
void  S2265C3_nt ::v99(){vfunc_called(this, "_ZN10S2265C3_nt3v99Ev");}
void  S2265C3_nt ::v100(){vfunc_called(this, "_ZN10S2265C3_nt4v100Ev");}
void  S2265C3_nt ::v101(){vfunc_called(this, "_ZN10S2265C3_nt4v101Ev");}
void  S2265C3_nt ::v102(){vfunc_called(this, "_ZN10S2265C3_nt4v102Ev");}
void  S2265C3_nt ::v103(){vfunc_called(this, "_ZN10S2265C3_nt4v103Ev");}
void  S2265C3_nt ::v104(){vfunc_called(this, "_ZN10S2265C3_nt4v104Ev");}
S2265C3_nt ::S2265C3_nt(){ note_ctor("S2265C3_nt", this);} // tgen

//skip512 S2265C3_nt

#else // __cplusplus

extern void _ZN10S2265C3_ntC1Ev();
extern void _ZN10S2265C3_ntD1Ev();
Name_Map name_map_S2265C3_nt[] = {
  NSPAIR(_ZN10S2265C3_ntC1Ev),
  NSPAIR(_ZN10S2265C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2265C4_nt;
extern VTBL_ENTRY _ZTI10S2265C4_nt[];
extern  VTBL_ENTRY _ZTV10S2265C4_nt[];
static Base_Class bases_S2265C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2265C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S2265C3_nt[];
extern void _ZN10S2265C3_ntD1Ev();
extern void _ZN10S2265C3_ntD0Ev();
extern void _ZN10S2265C4_nt2v4Ev();
extern void _ZN10S2265C4_nt2v5Ev();
extern void _ZN10S2265C4_nt2v6Ev();
extern void _ZN10S2265C4_nt2v7Ev();
extern void _ZN10S2265C4_nt2v8Ev();
extern void _ZN10S2265C4_nt2v9Ev();
extern void _ZN10S2265C4_nt3v10Ev();
extern void _ZN10S2265C4_nt3v11Ev();
extern void _ZN10S2265C4_nt3v12Ev();
extern void _ZN10S2265C4_nt3v13Ev();
extern void _ZN10S2265C4_nt3v14Ev();
extern void _ZN10S2265C4_nt3v15Ev();
extern void _ZN10S2265C4_nt3v16Ev();
extern void _ZN10S2265C4_nt3v17Ev();
extern void _ZN10S2265C4_nt3v18Ev();
extern void _ZN10S2265C4_nt3v19Ev();
extern void _ZN10S2265C4_nt3v20Ev();
extern void _ZN10S2265C4_nt3v21Ev();
extern void _ZN10S2265C4_nt3v22Ev();
extern void _ZN10S2265C4_nt3v23Ev();
extern void _ZN10S2265C4_nt3v24Ev();
extern void _ZN10S2265C4_nt3v25Ev();
extern void _ZN10S2265C4_nt3v26Ev();
extern void _ZN10S2265C3_nt3v27Ev();
extern void _ZN10S2265C3_nt3v28Ev();
extern void _ZN10S2265C3_nt3v29Ev();
extern void _ZN10S2265C3_nt3v30Ev();
extern void _ZN10S2265C3_nt3v31Ev();
extern void _ZN10S2265C3_nt3v32Ev();
extern void _ZN10S2265C3_nt3v33Ev();
extern void _ZN10S2265C3_nt3v34Ev();
extern void _ZN10S2265C3_nt3v35Ev();
extern void _ZN10S2265C3_nt3v36Ev();
extern void _ZN10S2265C3_nt3v37Ev();
extern void _ZN10S2265C3_nt3v38Ev();
extern void _ZN10S2265C3_nt3v39Ev();
extern void _ZN10S2265C3_nt3v40Ev();
extern void _ZN10S2265C3_nt3v41Ev();
extern void _ZN10S2265C3_nt3v42Ev();
extern void _ZN10S2265C3_nt3v43Ev();
extern void _ZN10S2265C3_nt3v44Ev();
extern void _ZN10S2265C3_nt3v45Ev();
extern void _ZN10S2265C3_nt3v46Ev();
extern void _ZN10S2265C3_nt3v47Ev();
extern void _ZN10S2265C3_nt3v48Ev();
extern void _ZN10S2265C3_nt3v49Ev();
extern void _ZN10S2265C3_nt3v50Ev();
extern void _ZN10S2265C3_nt3v51Ev();
extern void _ZN10S2265C3_nt3v52Ev();
extern void _ZN10S2265C3_nt3v53Ev();
extern void _ZN10S2265C3_nt3v54Ev();
extern void _ZN10S2265C3_nt3v55Ev();
extern void _ZN10S2265C3_nt3v56Ev();
extern void _ZN10S2265C3_nt3v57Ev();
extern void _ZN10S2265C3_nt3v58Ev();
extern void _ZN10S2265C3_nt3v59Ev();
extern void _ZN10S2265C3_nt3v60Ev();
extern void _ZN10S2265C3_nt3v61Ev();
extern void _ZN10S2265C3_nt3v62Ev();
extern void _ZN10S2265C3_nt3v63Ev();
extern void _ZN10S2265C3_nt3v64Ev();
extern void _ZN10S2265C3_nt3v65Ev();
extern void _ZN10S2265C3_nt3v66Ev();
extern void _ZN10S2265C3_nt3v67Ev();
extern void _ZN10S2265C3_nt3v68Ev();
extern void _ZN10S2265C3_nt3v69Ev();
extern void _ZN10S2265C3_nt3v70Ev();
extern void _ZN10S2265C3_nt3v71Ev();
extern void _ZN10S2265C3_nt3v72Ev();
extern void _ZN10S2265C3_nt3v73Ev();
extern void _ZN10S2265C3_nt3v74Ev();
extern void _ZN10S2265C3_nt3v75Ev();
extern void _ZN10S2265C3_nt3v76Ev();
extern void _ZN10S2265C3_nt3v77Ev();
extern void _ZN10S2265C3_nt3v78Ev();
extern void _ZN10S2265C3_nt3v79Ev();
extern void _ZN10S2265C3_nt3v80Ev();
extern void _ZN10S2265C3_nt3v81Ev();
extern void _ZN10S2265C3_nt3v82Ev();
extern void _ZN10S2265C3_nt3v83Ev();
extern void _ZN10S2265C3_nt3v84Ev();
extern void _ZN10S2265C3_nt3v85Ev();
extern void _ZN10S2265C3_nt3v86Ev();
extern void _ZN10S2265C3_nt3v87Ev();
extern void _ZN10S2265C3_nt3v88Ev();
extern void _ZN10S2265C3_nt3v89Ev();
extern void _ZN10S2265C3_nt3v90Ev();
extern void _ZN10S2265C3_nt3v91Ev();
extern void _ZN10S2265C3_nt3v92Ev();
extern void _ZN10S2265C3_nt3v93Ev();
extern void _ZN10S2265C3_nt3v94Ev();
extern void _ZN10S2265C3_nt3v95Ev();
extern void _ZN10S2265C3_nt3v96Ev();
extern void _ZN10S2265C3_nt3v97Ev();
extern void _ZN10S2265C3_nt3v98Ev();
extern void _ZN10S2265C3_nt3v99Ev();
extern void _ZN10S2265C3_nt4v100Ev();
extern void _ZN10S2265C3_nt4v101Ev();
extern void _ZN10S2265C3_nt4v102Ev();
extern void _ZN10S2265C3_nt4v103Ev();
extern void _ZN10S2265C3_nt4v104Ev();
static  VTBL_ENTRY vtc_S2265C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2265C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S2265C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt4v104Ev,
};
extern VTBL_ENTRY _ZTI10S2265C3_nt[];
VTBL_ENTRY *P__ZTI10S2265C3_nt = _ZTI10S2265C3_nt; 
extern  VTBL_ENTRY _ZTV10S2265C3_nt[];
Class_Descriptor cd_S2265C3_nt = {  "S2265C3_nt", // class name
  bases_S2265C3_nt, 1,
  &(vtc_S2265C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(832,632), // object size
  NSPAIRA(_ZTI10S2265C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S2265C3_nt),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2265C2_nt  : S2265C3_nt {
  void *s2265c2f0;
  virtual  ~S2265C2_nt(); // _ZN10S2265C2_ntD1Ev
  virtual void  v105(); // _ZN10S2265C2_nt4v105Ev
  virtual void  v106(); // _ZN10S2265C2_nt4v106Ev
  virtual void  v107(); // _ZN10S2265C2_nt4v107Ev
  virtual void  v108(); // _ZN10S2265C2_nt4v108Ev
  virtual void  v109(); // _ZN10S2265C2_nt4v109Ev
  virtual void  v110(); // _ZN10S2265C2_nt4v110Ev
  virtual void  v111(); // _ZN10S2265C2_nt4v111Ev
  virtual void  v112(); // _ZN10S2265C2_nt4v112Ev
  virtual void  v113(); // _ZN10S2265C2_nt4v113Ev
  virtual void  v114(); // _ZN10S2265C2_nt4v114Ev
  S2265C2_nt(); // tgen
};
//SIG(-1 S2265C2_nt) C1{ BC2{ BC3{ vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 Fp Fi FC4{ BC5{ m Fp Fi FC6{ m} FC6}} FC4 Fi} vd v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 FC7{ m FC8{ m FL[2]}} FC7 FC7 FC7 FC9{ m FC7} FC10{ m FC7 FC7 FC7 FC7} FC10 FC7 FC7 FC7 Fp FC9 FC11{ m FC12{ m Fp Fi FC13{ m}} Fi} Fi Fp[7] FC14{ m Fp Fi FC13 FC15{ m}} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC16{ BC17{ m Fp Fi FC15 FC18{ m}}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC19{ m Fp Fi[2] FC18} Fp[2] Fi:16 Fi:16 FC16 FC19 FC20{ m Fp Fi[2] FC21{ m}} Fp[2] Fi:24 Fi:8 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp}


 S2265C2_nt ::~S2265C2_nt(){ note_dtor("S2265C2_nt", this);}
void  S2265C2_nt ::v105(){vfunc_called(this, "_ZN10S2265C2_nt4v105Ev");}
void  S2265C2_nt ::v106(){vfunc_called(this, "_ZN10S2265C2_nt4v106Ev");}
void  S2265C2_nt ::v107(){vfunc_called(this, "_ZN10S2265C2_nt4v107Ev");}
void  S2265C2_nt ::v108(){vfunc_called(this, "_ZN10S2265C2_nt4v108Ev");}
void  S2265C2_nt ::v109(){vfunc_called(this, "_ZN10S2265C2_nt4v109Ev");}
void  S2265C2_nt ::v110(){vfunc_called(this, "_ZN10S2265C2_nt4v110Ev");}
void  S2265C2_nt ::v111(){vfunc_called(this, "_ZN10S2265C2_nt4v111Ev");}
void  S2265C2_nt ::v112(){vfunc_called(this, "_ZN10S2265C2_nt4v112Ev");}
void  S2265C2_nt ::v113(){vfunc_called(this, "_ZN10S2265C2_nt4v113Ev");}
void  S2265C2_nt ::v114(){vfunc_called(this, "_ZN10S2265C2_nt4v114Ev");}
S2265C2_nt ::S2265C2_nt(){ note_ctor("S2265C2_nt", this);} // tgen

//skip512 S2265C2_nt

#else // __cplusplus

extern void _ZN10S2265C2_ntC1Ev();
extern void _ZN10S2265C2_ntD1Ev();
Name_Map name_map_S2265C2_nt[] = {
  NSPAIR(_ZN10S2265C2_ntC1Ev),
  NSPAIR(_ZN10S2265C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2265C4_nt;
extern VTBL_ENTRY _ZTI10S2265C4_nt[];
extern  VTBL_ENTRY _ZTV10S2265C4_nt[];
extern Class_Descriptor cd_S2265C3_nt;
extern VTBL_ENTRY _ZTI10S2265C3_nt[];
extern  VTBL_ENTRY _ZTV10S2265C3_nt[];
static Base_Class bases_S2265C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2265C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2265C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S2265C2_nt[];
extern void _ZN10S2265C2_ntD1Ev();
extern void _ZN10S2265C2_ntD0Ev();
extern void _ZN10S2265C4_nt2v4Ev();
extern void _ZN10S2265C4_nt2v5Ev();
extern void _ZN10S2265C4_nt2v6Ev();
extern void _ZN10S2265C4_nt2v7Ev();
extern void _ZN10S2265C4_nt2v8Ev();
extern void _ZN10S2265C4_nt2v9Ev();
extern void _ZN10S2265C4_nt3v10Ev();
extern void _ZN10S2265C4_nt3v11Ev();
extern void _ZN10S2265C4_nt3v12Ev();
extern void _ZN10S2265C4_nt3v13Ev();
extern void _ZN10S2265C4_nt3v14Ev();
extern void _ZN10S2265C4_nt3v15Ev();
extern void _ZN10S2265C4_nt3v16Ev();
extern void _ZN10S2265C4_nt3v17Ev();
extern void _ZN10S2265C4_nt3v18Ev();
extern void _ZN10S2265C4_nt3v19Ev();
extern void _ZN10S2265C4_nt3v20Ev();
extern void _ZN10S2265C4_nt3v21Ev();
extern void _ZN10S2265C4_nt3v22Ev();
extern void _ZN10S2265C4_nt3v23Ev();
extern void _ZN10S2265C4_nt3v24Ev();
extern void _ZN10S2265C4_nt3v25Ev();
extern void _ZN10S2265C4_nt3v26Ev();
extern void _ZN10S2265C3_nt3v27Ev();
extern void _ZN10S2265C3_nt3v28Ev();
extern void _ZN10S2265C3_nt3v29Ev();
extern void _ZN10S2265C3_nt3v30Ev();
extern void _ZN10S2265C3_nt3v31Ev();
extern void _ZN10S2265C3_nt3v32Ev();
extern void _ZN10S2265C3_nt3v33Ev();
extern void _ZN10S2265C3_nt3v34Ev();
extern void _ZN10S2265C3_nt3v35Ev();
extern void _ZN10S2265C3_nt3v36Ev();
extern void _ZN10S2265C3_nt3v37Ev();
extern void _ZN10S2265C3_nt3v38Ev();
extern void _ZN10S2265C3_nt3v39Ev();
extern void _ZN10S2265C3_nt3v40Ev();
extern void _ZN10S2265C3_nt3v41Ev();
extern void _ZN10S2265C3_nt3v42Ev();
extern void _ZN10S2265C3_nt3v43Ev();
extern void _ZN10S2265C3_nt3v44Ev();
extern void _ZN10S2265C3_nt3v45Ev();
extern void _ZN10S2265C3_nt3v46Ev();
extern void _ZN10S2265C3_nt3v47Ev();
extern void _ZN10S2265C3_nt3v48Ev();
extern void _ZN10S2265C3_nt3v49Ev();
extern void _ZN10S2265C3_nt3v50Ev();
extern void _ZN10S2265C3_nt3v51Ev();
extern void _ZN10S2265C3_nt3v52Ev();
extern void _ZN10S2265C3_nt3v53Ev();
extern void _ZN10S2265C3_nt3v54Ev();
extern void _ZN10S2265C3_nt3v55Ev();
extern void _ZN10S2265C3_nt3v56Ev();
extern void _ZN10S2265C3_nt3v57Ev();
extern void _ZN10S2265C3_nt3v58Ev();
extern void _ZN10S2265C3_nt3v59Ev();
extern void _ZN10S2265C3_nt3v60Ev();
extern void _ZN10S2265C3_nt3v61Ev();
extern void _ZN10S2265C3_nt3v62Ev();
extern void _ZN10S2265C3_nt3v63Ev();
extern void _ZN10S2265C3_nt3v64Ev();
extern void _ZN10S2265C3_nt3v65Ev();
extern void _ZN10S2265C3_nt3v66Ev();
extern void _ZN10S2265C3_nt3v67Ev();
extern void _ZN10S2265C3_nt3v68Ev();
extern void _ZN10S2265C3_nt3v69Ev();
extern void _ZN10S2265C3_nt3v70Ev();
extern void _ZN10S2265C3_nt3v71Ev();
extern void _ZN10S2265C3_nt3v72Ev();
extern void _ZN10S2265C3_nt3v73Ev();
extern void _ZN10S2265C3_nt3v74Ev();
extern void _ZN10S2265C3_nt3v75Ev();
extern void _ZN10S2265C3_nt3v76Ev();
extern void _ZN10S2265C3_nt3v77Ev();
extern void _ZN10S2265C3_nt3v78Ev();
extern void _ZN10S2265C3_nt3v79Ev();
extern void _ZN10S2265C3_nt3v80Ev();
extern void _ZN10S2265C3_nt3v81Ev();
extern void _ZN10S2265C3_nt3v82Ev();
extern void _ZN10S2265C3_nt3v83Ev();
extern void _ZN10S2265C3_nt3v84Ev();
extern void _ZN10S2265C3_nt3v85Ev();
extern void _ZN10S2265C3_nt3v86Ev();
extern void _ZN10S2265C3_nt3v87Ev();
extern void _ZN10S2265C3_nt3v88Ev();
extern void _ZN10S2265C3_nt3v89Ev();
extern void _ZN10S2265C3_nt3v90Ev();
extern void _ZN10S2265C3_nt3v91Ev();
extern void _ZN10S2265C3_nt3v92Ev();
extern void _ZN10S2265C3_nt3v93Ev();
extern void _ZN10S2265C3_nt3v94Ev();
extern void _ZN10S2265C3_nt3v95Ev();
extern void _ZN10S2265C3_nt3v96Ev();
extern void _ZN10S2265C3_nt3v97Ev();
extern void _ZN10S2265C3_nt3v98Ev();
extern void _ZN10S2265C3_nt3v99Ev();
extern void _ZN10S2265C3_nt4v100Ev();
extern void _ZN10S2265C3_nt4v101Ev();
extern void _ZN10S2265C3_nt4v102Ev();
extern void _ZN10S2265C3_nt4v103Ev();
extern void _ZN10S2265C3_nt4v104Ev();
extern void _ZN10S2265C2_nt4v105Ev();
extern void _ZN10S2265C2_nt4v106Ev();
extern void _ZN10S2265C2_nt4v107Ev();
extern void _ZN10S2265C2_nt4v108Ev();
extern void _ZN10S2265C2_nt4v109Ev();
extern void _ZN10S2265C2_nt4v110Ev();
extern void _ZN10S2265C2_nt4v111Ev();
extern void _ZN10S2265C2_nt4v112Ev();
extern void _ZN10S2265C2_nt4v113Ev();
extern void _ZN10S2265C2_nt4v114Ev();
static  VTBL_ENTRY vtc_S2265C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2265C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S2265C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2265C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S2265C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S2265C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S2265C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S2265C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S2265C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S2265C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S2265C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S2265C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S2265C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S2265C2_nt4v114Ev,
};
extern VTBL_ENTRY _ZTI10S2265C2_nt[];
VTBL_ENTRY *P__ZTI10S2265C2_nt = _ZTI10S2265C2_nt; 
extern  VTBL_ENTRY _ZTV10S2265C2_nt[];
Class_Descriptor cd_S2265C2_nt = {  "S2265C2_nt", // class name
  bases_S2265C2_nt, 2,
  &(vtc_S2265C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(840,636), // object size
  NSPAIRA(_ZTI10S2265C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S2265C2_nt),115, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2265C1  : S2265C2_nt {
  int s2265c1f0;
  virtual  ~S2265C1(); // _ZN7S2265C1D1Ev
  virtual void  v1(); // _ZN7S2265C12v1Ev
  virtual void  v2(); // _ZN7S2265C12v2Ev
  virtual void  v3(); // _ZN7S2265C12v3Ev
  S2265C1(); // tgen
};
//SIG(1 S2265C1) C1{ BC2{ BC3{ BC4{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 Fp Fi FC5{ BC6{ m Fp Fi FC7{ m} FC7}} FC5 Fi} vd v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8 FC10{ m FC8} FC11{ m FC8 FC8 FC8 FC8} FC11 FC8 FC8 FC8 Fp FC10 FC12{ m FC13{ m Fp Fi FC14{ m}} Fi} Fi Fp[7] FC15{ m Fp Fi FC14 FC16{ m}} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC17{ BC18{ m Fp Fi FC16 FC19{ m}}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC20{ m Fp Fi[2] FC19} Fp[2] Fi:16 Fi:16 FC17 FC20 FC21{ m Fp Fi[2] FC22{ m}} Fp[2] Fi:24 Fi:8 Fp} vd v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 Fp} vd v1 v2 v3 Fi}


 S2265C1 ::~S2265C1(){ note_dtor("S2265C1", this);}
void  S2265C1 ::v1(){vfunc_called(this, "_ZN7S2265C12v1Ev");}
void  S2265C1 ::v2(){vfunc_called(this, "_ZN7S2265C12v2Ev");}
void  S2265C1 ::v3(){vfunc_called(this, "_ZN7S2265C12v3Ev");}
S2265C1 ::S2265C1(){ note_ctor("S2265C1", this);} // tgen

static void Test_S2265C1()
{
  extern Class_Descriptor cd_S2265C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(107,161)];
    init_test(&cd_S2265C1, buf);
    S2265C1 *dp, &lv = *(dp=new (buf) S2265C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(848,640), "sizeof(S2265C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2265C1)");
    check_base_class_offset(lv, (S2265C4_nt*)(S2265C3_nt*)(S2265C2_nt*), 0, "S2265C1");
    check_base_class_offset(lv, (S2265C3_nt*)(S2265C2_nt*), 0, "S2265C1");
    check_base_class_offset(lv, (S2265C2_nt*), 0, "S2265C1");
    check_field_offset(lv, s2265c1f0, ABISELECT(840,636), "S2265C1.s2265c1f0");
    test_class_info(&lv, &cd_S2265C1);
    dp->~S2265C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2265C1(Test_S2265C1, "S2265C1", ABISELECT(848,640));

#else // __cplusplus

extern void _ZN7S2265C1C1Ev();
extern void _ZN7S2265C1D1Ev();
Name_Map name_map_S2265C1[] = {
  NSPAIR(_ZN7S2265C1C1Ev),
  NSPAIR(_ZN7S2265C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2265C4_nt;
extern VTBL_ENTRY _ZTI10S2265C4_nt[];
extern  VTBL_ENTRY _ZTV10S2265C4_nt[];
extern Class_Descriptor cd_S2265C3_nt;
extern VTBL_ENTRY _ZTI10S2265C3_nt[];
extern  VTBL_ENTRY _ZTV10S2265C3_nt[];
extern Class_Descriptor cd_S2265C2_nt;
extern VTBL_ENTRY _ZTI10S2265C2_nt[];
extern  VTBL_ENTRY _ZTV10S2265C2_nt[];
static Base_Class bases_S2265C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2265C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2265C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2265C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2265C1[];
extern void _ZN7S2265C1D1Ev();
extern void _ZN7S2265C1D0Ev();
extern void _ZN10S2265C4_nt2v4Ev();
extern void _ZN10S2265C4_nt2v5Ev();
extern void _ZN10S2265C4_nt2v6Ev();
extern void _ZN10S2265C4_nt2v7Ev();
extern void _ZN10S2265C4_nt2v8Ev();
extern void _ZN10S2265C4_nt2v9Ev();
extern void _ZN10S2265C4_nt3v10Ev();
extern void _ZN10S2265C4_nt3v11Ev();
extern void _ZN10S2265C4_nt3v12Ev();
extern void _ZN10S2265C4_nt3v13Ev();
extern void _ZN10S2265C4_nt3v14Ev();
extern void _ZN10S2265C4_nt3v15Ev();
extern void _ZN10S2265C4_nt3v16Ev();
extern void _ZN10S2265C4_nt3v17Ev();
extern void _ZN10S2265C4_nt3v18Ev();
extern void _ZN10S2265C4_nt3v19Ev();
extern void _ZN10S2265C4_nt3v20Ev();
extern void _ZN10S2265C4_nt3v21Ev();
extern void _ZN10S2265C4_nt3v22Ev();
extern void _ZN10S2265C4_nt3v23Ev();
extern void _ZN10S2265C4_nt3v24Ev();
extern void _ZN10S2265C4_nt3v25Ev();
extern void _ZN10S2265C4_nt3v26Ev();
extern void _ZN10S2265C3_nt3v27Ev();
extern void _ZN10S2265C3_nt3v28Ev();
extern void _ZN10S2265C3_nt3v29Ev();
extern void _ZN10S2265C3_nt3v30Ev();
extern void _ZN10S2265C3_nt3v31Ev();
extern void _ZN10S2265C3_nt3v32Ev();
extern void _ZN10S2265C3_nt3v33Ev();
extern void _ZN10S2265C3_nt3v34Ev();
extern void _ZN10S2265C3_nt3v35Ev();
extern void _ZN10S2265C3_nt3v36Ev();
extern void _ZN10S2265C3_nt3v37Ev();
extern void _ZN10S2265C3_nt3v38Ev();
extern void _ZN10S2265C3_nt3v39Ev();
extern void _ZN10S2265C3_nt3v40Ev();
extern void _ZN10S2265C3_nt3v41Ev();
extern void _ZN10S2265C3_nt3v42Ev();
extern void _ZN10S2265C3_nt3v43Ev();
extern void _ZN10S2265C3_nt3v44Ev();
extern void _ZN10S2265C3_nt3v45Ev();
extern void _ZN10S2265C3_nt3v46Ev();
extern void _ZN10S2265C3_nt3v47Ev();
extern void _ZN10S2265C3_nt3v48Ev();
extern void _ZN10S2265C3_nt3v49Ev();
extern void _ZN10S2265C3_nt3v50Ev();
extern void _ZN10S2265C3_nt3v51Ev();
extern void _ZN10S2265C3_nt3v52Ev();
extern void _ZN10S2265C3_nt3v53Ev();
extern void _ZN10S2265C3_nt3v54Ev();
extern void _ZN10S2265C3_nt3v55Ev();
extern void _ZN10S2265C3_nt3v56Ev();
extern void _ZN10S2265C3_nt3v57Ev();
extern void _ZN10S2265C3_nt3v58Ev();
extern void _ZN10S2265C3_nt3v59Ev();
extern void _ZN10S2265C3_nt3v60Ev();
extern void _ZN10S2265C3_nt3v61Ev();
extern void _ZN10S2265C3_nt3v62Ev();
extern void _ZN10S2265C3_nt3v63Ev();
extern void _ZN10S2265C3_nt3v64Ev();
extern void _ZN10S2265C3_nt3v65Ev();
extern void _ZN10S2265C3_nt3v66Ev();
extern void _ZN10S2265C3_nt3v67Ev();
extern void _ZN10S2265C3_nt3v68Ev();
extern void _ZN10S2265C3_nt3v69Ev();
extern void _ZN10S2265C3_nt3v70Ev();
extern void _ZN10S2265C3_nt3v71Ev();
extern void _ZN10S2265C3_nt3v72Ev();
extern void _ZN10S2265C3_nt3v73Ev();
extern void _ZN10S2265C3_nt3v74Ev();
extern void _ZN10S2265C3_nt3v75Ev();
extern void _ZN10S2265C3_nt3v76Ev();
extern void _ZN10S2265C3_nt3v77Ev();
extern void _ZN10S2265C3_nt3v78Ev();
extern void _ZN10S2265C3_nt3v79Ev();
extern void _ZN10S2265C3_nt3v80Ev();
extern void _ZN10S2265C3_nt3v81Ev();
extern void _ZN10S2265C3_nt3v82Ev();
extern void _ZN10S2265C3_nt3v83Ev();
extern void _ZN10S2265C3_nt3v84Ev();
extern void _ZN10S2265C3_nt3v85Ev();
extern void _ZN10S2265C3_nt3v86Ev();
extern void _ZN10S2265C3_nt3v87Ev();
extern void _ZN10S2265C3_nt3v88Ev();
extern void _ZN10S2265C3_nt3v89Ev();
extern void _ZN10S2265C3_nt3v90Ev();
extern void _ZN10S2265C3_nt3v91Ev();
extern void _ZN10S2265C3_nt3v92Ev();
extern void _ZN10S2265C3_nt3v93Ev();
extern void _ZN10S2265C3_nt3v94Ev();
extern void _ZN10S2265C3_nt3v95Ev();
extern void _ZN10S2265C3_nt3v96Ev();
extern void _ZN10S2265C3_nt3v97Ev();
extern void _ZN10S2265C3_nt3v98Ev();
extern void _ZN10S2265C3_nt3v99Ev();
extern void _ZN10S2265C3_nt4v100Ev();
extern void _ZN10S2265C3_nt4v101Ev();
extern void _ZN10S2265C3_nt4v102Ev();
extern void _ZN10S2265C3_nt4v103Ev();
extern void _ZN10S2265C3_nt4v104Ev();
extern void _ZN10S2265C2_nt4v105Ev();
extern void _ZN10S2265C2_nt4v106Ev();
extern void _ZN10S2265C2_nt4v107Ev();
extern void _ZN10S2265C2_nt4v108Ev();
extern void _ZN10S2265C2_nt4v109Ev();
extern void _ZN10S2265C2_nt4v110Ev();
extern void _ZN10S2265C2_nt4v111Ev();
extern void _ZN10S2265C2_nt4v112Ev();
extern void _ZN10S2265C2_nt4v113Ev();
extern void _ZN10S2265C2_nt4v114Ev();
extern void _ZN7S2265C12v1Ev();
extern void _ZN7S2265C12v2Ev();
extern void _ZN7S2265C12v3Ev();
static  VTBL_ENTRY vtc_S2265C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2265C1[0]),
  (VTBL_ENTRY)&_ZN7S2265C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2265C1D0Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2265C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S2265C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S2265C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S2265C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S2265C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S2265C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S2265C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S2265C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S2265C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S2265C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S2265C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S2265C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN7S2265C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2265C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2265C12v3Ev,
};
extern VTBL_ENTRY _ZTI7S2265C1[];
extern  VTBL_ENTRY _ZTV7S2265C1[];
Class_Descriptor cd_S2265C1 = {  "S2265C1", // class name
  bases_S2265C1, 3,
  &(vtc_S2265C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(848,640), // object size
  NSPAIRA(_ZTI7S2265C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2265C1),118, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C3  {
  char s5217c3f0[12];
  void *s5217c3f1[3];
  int s5217c3f2;
  virtual  ~S5217C3(); // _ZN7S5217C3D1Ev
  virtual void  v5(); // _ZN7S5217C32v5Ev
  S5217C3(); // tgen
};
//SIG(-1 S5217C3) C1{ vd v1 Fc[12] Fp[3] Fi}


 S5217C3 ::~S5217C3(){ note_dtor("S5217C3", this);}
void  S5217C3 ::v5(){vfunc_called(this, "_ZN7S5217C32v5Ev");}
S5217C3 ::S5217C3(){ note_ctor("S5217C3", this);} // tgen

static void Test_S5217C3()
{
  extern Class_Descriptor cd_S5217C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_S5217C3, buf);
    S5217C3 *dp, &lv = *(dp=new (buf) S5217C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S5217C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S5217C3)");
    check_field_offset(lv, s5217c3f0, ABISELECT(8,4), "S5217C3.s5217c3f0");
    check_field_offset(lv, s5217c3f1, ABISELECT(24,16), "S5217C3.s5217c3f1");
    check_field_offset(lv, s5217c3f2, ABISELECT(48,28), "S5217C3.s5217c3f2");
    test_class_info(&lv, &cd_S5217C3);
    dp->~S5217C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS5217C3(Test_S5217C3, "S5217C3", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7S5217C3C1Ev();
extern void _ZN7S5217C3D1Ev();
Name_Map name_map_S5217C3[] = {
  NSPAIR(_ZN7S5217C3C1Ev),
  NSPAIR(_ZN7S5217C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S5217C3[];
extern void _ZN7S5217C3D1Ev();
extern void _ZN7S5217C3D0Ev();
extern void _ZN7S5217C32v5Ev();
static  VTBL_ENTRY vtc_S5217C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S5217C3[0]),
  (VTBL_ENTRY)&_ZN7S5217C3D1Ev,
  (VTBL_ENTRY)&_ZN7S5217C3D0Ev,
  (VTBL_ENTRY)&_ZN7S5217C32v5Ev,
};
extern VTBL_ENTRY _ZTI7S5217C3[];
extern  VTBL_ENTRY _ZTV7S5217C3[];
Class_Descriptor cd_S5217C3 = {  "S5217C3", // class name
  0,0,//no base classes
  &(vtc_S5217C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7S5217C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S5217C3),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C7_nt  {
};
//SIG(-1 S5217C7_nt) C1{}



//skip512 S5217C7_nt

#else // __cplusplus

Class_Descriptor cd_S5217C7_nt = {  "S5217C7_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C6_nt  : S5217C7_nt {
};
//SIG(-1 S5217C6_nt) C1{ BC2{}}



//skip512 S5217C6_nt

#else // __cplusplus

extern Class_Descriptor cd_S5217C7_nt;
static Base_Class bases_S5217C6_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5217C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S5217C6_nt = {  "S5217C6_nt", // class name
  bases_S5217C6_nt, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C9  {
};
//SIG(-1 S5217C9) C1{}



static void Test_S5217C9()
{
  {
    init_simple_test("S5217C9");
    S5217C9 lv;
    check2(sizeof(lv), 1, "sizeof(S5217C9)");
    check2(__alignof__(lv), 1, "__alignof__(S5217C9)");
  }
}
static Arrange_To_Call_Me vS5217C9(Test_S5217C9, "S5217C9", 1);

#else // __cplusplus

Class_Descriptor cd_S5217C9 = {  "S5217C9", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C8  : S5217C9 {
};
//SIG(-1 S5217C8) C1{ BC2{}}



static void Test_S5217C8()
{
  extern Class_Descriptor cd_S5217C8;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S5217C8, buf);
    S5217C8 &lv = *(new (buf) S5217C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S5217C8)");
    check2(__alignof__(lv), 1, "__alignof__(S5217C8)");
    check_base_class_offset(lv, (S5217C9*), 0, "S5217C8");
    test_class_info(&lv, &cd_S5217C8);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS5217C8(Test_S5217C8, "S5217C8", 1);

#else // __cplusplus

extern Class_Descriptor cd_S5217C9;
static Base_Class bases_S5217C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5217C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S5217C8 = {  "S5217C8", // class name
  bases_S5217C8, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C5_nt  : S5217C6_nt {
  ::S5217C8 s5217c5f0;
};
//SIG(-1 S5217C5_nt) C1{ BC2{ BC3{}} FC4{ BC5{}}}



//skip512 S5217C5_nt

#else // __cplusplus

extern Class_Descriptor cd_S5217C7_nt;
extern Class_Descriptor cd_S5217C6_nt;
static Base_Class bases_S5217C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5217C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S5217C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S5217C5_nt = {  "S5217C5_nt", // class name
  bases_S5217C5_nt, 2,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S5217C10_nt  {
  char s5217c10f0[16];
  void *s5217c10f1;
};
//SIG(1 S5217C10_nt) U1{ Fc[16] Fp}

#endif // __cplusplus
#ifdef __cplusplus

struct  S5217C4_nt  : S5217C5_nt {
  ::S5217C10_nt s5217c4f0;
  int s5217c4f1;
  int s5217c4f2;
};
//SIG(-1 S5217C4_nt) C1{ BC2{ BC3{ BC4{}} FC5{ BC6{}}} FU7{ Fc[16] Fp} Fi Fi}



//skip512 S5217C4_nt

#else // __cplusplus

extern Class_Descriptor cd_S5217C7_nt;
extern Class_Descriptor cd_S5217C6_nt;
extern Class_Descriptor cd_S5217C5_nt;
static Base_Class bases_S5217C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5217C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S5217C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S5217C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C2  : S5217C3 {
  char s5217c2f0[12];
  int s5217c2f1;
  ::S5217C4_nt s5217c2f2;
  virtual  ~S5217C2(); // _ZN7S5217C2D1Ev
  virtual void  v6(); // _ZN7S5217C22v6Ev
  S5217C2(); // tgen
};
//SIG(-1 S5217C2) C1{ BC2{ vd v2 Fc[12] Fp[3] Fi} vd v1 Fc[12] Fi FC3{ BC4{ BC5{ BC6{}} FC7{ BC8{}}} FU9{ Fc[16] Fp} Fi Fi}}


 S5217C2 ::~S5217C2(){ note_dtor("S5217C2", this);}
void  S5217C2 ::v6(){vfunc_called(this, "_ZN7S5217C22v6Ev");}
S5217C2 ::S5217C2(){ note_ctor("S5217C2", this);} // tgen

static void Test_S5217C2()
{
  extern Class_Descriptor cd_S5217C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,20)];
    init_test(&cd_S5217C2, buf);
    S5217C2 *dp, &lv = *(dp=new (buf) S5217C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,76), "sizeof(S5217C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S5217C2)");
    check_base_class_offset(lv, (S5217C3*), 0, "S5217C2");
    check_field_offset(lv, s5217c2f0, ABISELECT(52,32), "S5217C2.s5217c2f0");
    check_field_offset(lv, s5217c2f1, ABISELECT(64,44), "S5217C2.s5217c2f1");
    check_field_offset(lv, s5217c2f2, ABISELECT(72,48), "S5217C2.s5217c2f2");
    test_class_info(&lv, &cd_S5217C2);
    dp->~S5217C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS5217C2(Test_S5217C2, "S5217C2", ABISELECT(104,76));

#else // __cplusplus

extern void _ZN7S5217C2C1Ev();
extern void _ZN7S5217C2D1Ev();
Name_Map name_map_S5217C2[] = {
  NSPAIR(_ZN7S5217C2C1Ev),
  NSPAIR(_ZN7S5217C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S5217C3;
extern VTBL_ENTRY _ZTI7S5217C3[];
extern  VTBL_ENTRY _ZTV7S5217C3[];
static Base_Class bases_S5217C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5217C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S5217C2[];
extern void _ZN7S5217C2D1Ev();
extern void _ZN7S5217C2D0Ev();
extern void _ZN7S5217C32v5Ev();
extern void _ZN7S5217C22v6Ev();
static  VTBL_ENTRY vtc_S5217C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S5217C2[0]),
  (VTBL_ENTRY)&_ZN7S5217C2D1Ev,
  (VTBL_ENTRY)&_ZN7S5217C2D0Ev,
  (VTBL_ENTRY)&_ZN7S5217C32v5Ev,
  (VTBL_ENTRY)&_ZN7S5217C22v6Ev,
};
extern VTBL_ENTRY _ZTI7S5217C2[];
extern  VTBL_ENTRY _ZTV7S5217C2[];
Class_Descriptor cd_S5217C2 = {  "S5217C2", // class name
  bases_S5217C2, 1,
  &(vtc_S5217C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,76), // object size
  NSPAIRA(_ZTI7S5217C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S5217C2),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C11_nt  {
  virtual  ~S5217C11_nt(); // _ZN11S5217C11_ntD1Ev
  virtual void  v7(); // _ZN11S5217C11_nt2v7Ev
  S5217C11_nt(); // tgen
};
//SIG(-1 S5217C11_nt) C1{ vd v1}


 S5217C11_nt ::~S5217C11_nt(){ note_dtor("S5217C11_nt", this);}
void  S5217C11_nt ::v7(){vfunc_called(this, "_ZN11S5217C11_nt2v7Ev");}
S5217C11_nt ::S5217C11_nt(){ note_ctor("S5217C11_nt", this);} // tgen

//skip512 S5217C11_nt

#else // __cplusplus

extern void _ZN11S5217C11_ntC1Ev();
extern void _ZN11S5217C11_ntD1Ev();
Name_Map name_map_S5217C11_nt[] = {
  NSPAIR(_ZN11S5217C11_ntC1Ev),
  NSPAIR(_ZN11S5217C11_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S5217C11_nt[];
extern void _ZN11S5217C11_ntD1Ev();
extern void _ZN11S5217C11_ntD0Ev();
extern void _ZN11S5217C11_nt2v7Ev();
static  VTBL_ENTRY vtc_S5217C11_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S5217C11_nt[0]),
  (VTBL_ENTRY)&_ZN11S5217C11_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S5217C11_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S5217C11_nt2v7Ev,
};
extern VTBL_ENTRY _ZTI11S5217C11_nt[];
VTBL_ENTRY *P__ZTI11S5217C11_nt = _ZTI11S5217C11_nt; 
extern  VTBL_ENTRY _ZTV11S5217C11_nt[];
Class_Descriptor cd_S5217C11_nt = {  "S5217C11_nt", // class name
  0,0,//no base classes
  &(vtc_S5217C11_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S5217C11_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S5217C11_nt),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C12_nt  {
  virtual  ~S5217C12_nt(); // _ZN11S5217C12_ntD1Ev
  virtual void  v8(); // _ZN11S5217C12_nt2v8Ev
  virtual void  v9(); // _ZN11S5217C12_nt2v9Ev
  virtual void  v10(); // _ZN11S5217C12_nt3v10Ev
  virtual void  v11(); // _ZN11S5217C12_nt3v11Ev
  virtual void  v12(); // _ZN11S5217C12_nt3v12Ev
  S5217C12_nt(); // tgen
};
//SIG(-1 S5217C12_nt) C1{ vd v1 v2 v3 v4 v5}


 S5217C12_nt ::~S5217C12_nt(){ note_dtor("S5217C12_nt", this);}
void  S5217C12_nt ::v8(){vfunc_called(this, "_ZN11S5217C12_nt2v8Ev");}
void  S5217C12_nt ::v9(){vfunc_called(this, "_ZN11S5217C12_nt2v9Ev");}
void  S5217C12_nt ::v10(){vfunc_called(this, "_ZN11S5217C12_nt3v10Ev");}
void  S5217C12_nt ::v11(){vfunc_called(this, "_ZN11S5217C12_nt3v11Ev");}
void  S5217C12_nt ::v12(){vfunc_called(this, "_ZN11S5217C12_nt3v12Ev");}
S5217C12_nt ::S5217C12_nt(){ note_ctor("S5217C12_nt", this);} // tgen

//skip512 S5217C12_nt

#else // __cplusplus

extern void _ZN11S5217C12_ntC1Ev();
extern void _ZN11S5217C12_ntD1Ev();
Name_Map name_map_S5217C12_nt[] = {
  NSPAIR(_ZN11S5217C12_ntC1Ev),
  NSPAIR(_ZN11S5217C12_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S5217C12_nt[];
extern void _ZN11S5217C12_ntD1Ev();
extern void _ZN11S5217C12_ntD0Ev();
extern void _ZN11S5217C12_nt2v8Ev();
extern void _ZN11S5217C12_nt2v9Ev();
extern void _ZN11S5217C12_nt3v10Ev();
extern void _ZN11S5217C12_nt3v11Ev();
extern void _ZN11S5217C12_nt3v12Ev();
static  VTBL_ENTRY vtc_S5217C12_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S5217C12_nt[0]),
  (VTBL_ENTRY)&_ZN11S5217C12_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S5217C12_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S5217C12_nt2v8Ev,
  (VTBL_ENTRY)&_ZN11S5217C12_nt2v9Ev,
  (VTBL_ENTRY)&_ZN11S5217C12_nt3v10Ev,
  (VTBL_ENTRY)&_ZN11S5217C12_nt3v11Ev,
  (VTBL_ENTRY)&_ZN11S5217C12_nt3v12Ev,
};
extern VTBL_ENTRY _ZTI11S5217C12_nt[];
VTBL_ENTRY *P__ZTI11S5217C12_nt = _ZTI11S5217C12_nt; 
extern  VTBL_ENTRY _ZTV11S5217C12_nt[];
Class_Descriptor cd_S5217C12_nt = {  "S5217C12_nt", // class name
  0,0,//no base classes
  &(vtc_S5217C12_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S5217C12_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S5217C12_nt),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C15_nt  {
  char s5217c15f0;
  char s5217c15f1[15];
  void  mf5217c15(); // _ZN11S5217C15_nt9mf5217c15Ev
};
//SIG(-1 S5217C15_nt) C1{ m Fc[16]}


void  S5217C15_nt ::mf5217c15(){}

//skip512 S5217C15_nt

#else // __cplusplus

Class_Descriptor cd_S5217C15_nt = {  "S5217C15_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C14_nt  : S5217C15_nt {
};
//SIG(-1 S5217C14_nt) C1{ BC2{ m Fc[16]}}



//skip512 S5217C14_nt

#else // __cplusplus

extern Class_Descriptor cd_S5217C15_nt;
static Base_Class bases_S5217C14_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5217C15_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C13  {
  ::S5217C14_nt s5217c13f0;
  int s5217c13f1;
  int s5217c13f2;
  int s5217c13f3;
  int s5217c13f4;
};
//SIG(1 S5217C13) C1{ FC2{ BC3{ m Fc[16]}} Fi[4]}



static void Test_S5217C13()
{
  {
    init_simple_test("S5217C13");
    S5217C13 lv;
    check2(sizeof(lv), 32, "sizeof(S5217C13)");
    check2(__alignof__(lv), 4, "__alignof__(S5217C13)");
    check_field_offset(lv, s5217c13f0, 0, "S5217C13.s5217c13f0");
    check_field_offset(lv, s5217c13f1, 16, "S5217C13.s5217c13f1");
    check_field_offset(lv, s5217c13f2, 20, "S5217C13.s5217c13f2");
    check_field_offset(lv, s5217c13f3, 24, "S5217C13.s5217c13f3");
    check_field_offset(lv, s5217c13f4, 28, "S5217C13.s5217c13f4");
  }
}
static Arrange_To_Call_Me vS5217C13(Test_S5217C13, "S5217C13", 32);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C17_nt  : S5217C7_nt {
  ::S5217C8 s5217c17f0;
};
//SIG(-1 S5217C17_nt) C1{ BC2{} FC3{ BC4{}}}



//skip512 S5217C17_nt

#else // __cplusplus

extern Class_Descriptor cd_S5217C7_nt;
static Base_Class bases_S5217C17_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5217C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S5217C17_nt = {  "S5217C17_nt", // class name
  bases_S5217C17_nt, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C16_nt  : S5217C17_nt {
  void *s5217c16f0;
  void *s5217c16f1;
  void *s5217c16f2;
};
//SIG(-1 S5217C16_nt) C1{ BC2{ BC3{} FC4{ BC5{}}} Fp[3]}



//skip512 S5217C16_nt

#else // __cplusplus

extern Class_Descriptor cd_S5217C7_nt;
extern Class_Descriptor cd_S5217C17_nt;
static Base_Class bases_S5217C16_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5217C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S5217C17_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C31  {
};
//SIG(-1 S5217C31) C1{}



static void Test_S5217C31()
{
  {
    init_simple_test("S5217C31");
    S5217C31 lv;
    check2(sizeof(lv), 1, "sizeof(S5217C31)");
    check2(__alignof__(lv), 1, "__alignof__(S5217C31)");
  }
}
static Arrange_To_Call_Me vS5217C31(Test_S5217C31, "S5217C31", 1);

#else // __cplusplus

Class_Descriptor cd_S5217C31 = {  "S5217C31", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C30  : S5217C31 {
};
//SIG(-1 S5217C30) C1{ BC2{}}



static void Test_S5217C30()
{
  extern Class_Descriptor cd_S5217C30;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S5217C30, buf);
    S5217C30 &lv = *(new (buf) S5217C30());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S5217C30)");
    check2(__alignof__(lv), 1, "__alignof__(S5217C30)");
    check_base_class_offset(lv, (S5217C31*), 0, "S5217C30");
    test_class_info(&lv, &cd_S5217C30);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS5217C30(Test_S5217C30, "S5217C30", 1);

#else // __cplusplus

extern Class_Descriptor cd_S5217C31;
static Base_Class bases_S5217C30[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5217C31,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S5217C30 = {  "S5217C30", // class name
  bases_S5217C30, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C29  : S5217C7_nt {
  ::S5217C30 s5217c29f0;
};
//SIG(-1 S5217C29) C1{ BC2{} FC3{ BC4{}}}



static void Test_S5217C29()
{
  extern Class_Descriptor cd_S5217C29;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S5217C29, buf);
    S5217C29 &lv = *(new (buf) S5217C29());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S5217C29)");
    check2(__alignof__(lv), 1, "__alignof__(S5217C29)");
    check_base_class_offset(lv, (S5217C7_nt*), 0, "S5217C29");
    check_field_offset(lv, s5217c29f0, 0, "S5217C29.s5217c29f0");
    test_class_info(&lv, &cd_S5217C29);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS5217C29(Test_S5217C29, "S5217C29", 1);

#else // __cplusplus

extern Class_Descriptor cd_S5217C7_nt;
static Base_Class bases_S5217C29[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5217C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S5217C29 = {  "S5217C29", // class name
  bases_S5217C29, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C28_nt  : S5217C29 {
  ::S5217C30 s5217c28f0;
};
//SIG(-1 S5217C28_nt) C1{ BC2{ BC3{} FC4{ BC5{}}} FC4}



//skip512 S5217C28_nt

#else // __cplusplus

extern Class_Descriptor cd_S5217C7_nt;
extern Class_Descriptor cd_S5217C29;
static Base_Class bases_S5217C28_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5217C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S5217C29,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S5217C28_nt = {  "S5217C28_nt", // class name
  bases_S5217C28_nt, 2,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C35  {
};
//SIG(-1 S5217C35) C1{}



static void Test_S5217C35()
{
  {
    init_simple_test("S5217C35");
    S5217C35 lv;
    check2(sizeof(lv), 1, "sizeof(S5217C35)");
    check2(__alignof__(lv), 1, "__alignof__(S5217C35)");
  }
}
static Arrange_To_Call_Me vS5217C35(Test_S5217C35, "S5217C35", 1);

#else // __cplusplus

Class_Descriptor cd_S5217C35 = {  "S5217C35", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C34  : S5217C35 {
};
//SIG(-1 S5217C34) C1{ BC2{}}



static void Test_S5217C34()
{
  extern Class_Descriptor cd_S5217C34;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S5217C34, buf);
    S5217C34 &lv = *(new (buf) S5217C34());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S5217C34)");
    check2(__alignof__(lv), 1, "__alignof__(S5217C34)");
    check_base_class_offset(lv, (S5217C35*), 0, "S5217C34");
    test_class_info(&lv, &cd_S5217C34);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS5217C34(Test_S5217C34, "S5217C34", 1);

#else // __cplusplus

extern Class_Descriptor cd_S5217C35;
static Base_Class bases_S5217C34[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5217C35,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S5217C34 = {  "S5217C34", // class name
  bases_S5217C34, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C27_nt  : S5217C28_nt {
  ::S5217C34 s5217c27f0;
};
//SIG(-1 S5217C27_nt) C1{ BC2{ BC3{ BC4{} FC5{ BC6{}}} FC5} FC7{ BC8{}}}



//skip512 S5217C27_nt

#else // __cplusplus

extern Class_Descriptor cd_S5217C7_nt;
extern Class_Descriptor cd_S5217C29;
extern Class_Descriptor cd_S5217C28_nt;
static Base_Class bases_S5217C27_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5217C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S5217C29,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S5217C28_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S5217C27_nt = {  "S5217C27_nt", // class name
  bases_S5217C27_nt, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C26_nt  : S5217C27_nt {
  ::S5217C34 s5217c26f0;
};
//SIG(-1 S5217C26_nt) C1{ BC2{ BC3{ BC4{ BC5{} FC6{ BC7{}}} FC6} FC8{ BC9{}}} FC8}



//skip512 S5217C26_nt

#else // __cplusplus

extern Class_Descriptor cd_S5217C7_nt;
extern Class_Descriptor cd_S5217C29;
extern Class_Descriptor cd_S5217C28_nt;
extern Class_Descriptor cd_S5217C27_nt;
static Base_Class bases_S5217C26_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5217C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S5217C29,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S5217C28_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S5217C27_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S5217C26_nt = {  "S5217C26_nt", // class name
  bases_S5217C26_nt, 4,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C25_nt  : S5217C26_nt {
  void *s5217c25f0;
  int s5217c25f1;
};
//SIG(-1 S5217C25_nt) C1{ BC2{ BC3{ BC4{ BC5{ BC6{} FC7{ BC8{}}} FC7} FC9{ BC10{}}} FC9} Fp Fi}



//skip512 S5217C25_nt

#else // __cplusplus

extern Class_Descriptor cd_S5217C7_nt;
extern Class_Descriptor cd_S5217C29;
extern Class_Descriptor cd_S5217C28_nt;
extern Class_Descriptor cd_S5217C27_nt;
extern Class_Descriptor cd_S5217C26_nt;
static Base_Class bases_S5217C25_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5217C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S5217C29,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S5217C28_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S5217C27_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S5217C26_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S5217C25_nt = {  "S5217C25_nt", // class name
  bases_S5217C25_nt, 5,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C24_nt  : S5217C25_nt {
};
//SIG(-1 S5217C24_nt) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{} FC8{ BC9{}}} FC8} FC10{ BC11{}}} FC10} Fp Fi}}



//skip512 S5217C24_nt

#else // __cplusplus

extern Class_Descriptor cd_S5217C7_nt;
extern Class_Descriptor cd_S5217C29;
extern Class_Descriptor cd_S5217C28_nt;
extern Class_Descriptor cd_S5217C27_nt;
extern Class_Descriptor cd_S5217C26_nt;
extern Class_Descriptor cd_S5217C25_nt;
static Base_Class bases_S5217C24_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5217C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S5217C29,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S5217C28_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S5217C27_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S5217C26_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S5217C25_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C39_nt  {
  __tsi64 s5217c39f0;
  void  mf5217c39(); // _ZN11S5217C39_nt9mf5217c39Ev
};
//SIG(-1 S5217C39_nt) C1{ m FL}


void  S5217C39_nt ::mf5217c39(){}

//skip512 S5217C39_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C38  {
  void *s5217c38f0;
  char s5217c38f1;
  int s5217c38f2;
  ::S5217C39_nt s5217c38f3;
};
//SIG(1 S5217C38) C1{ Fp Fc Fi FC2{ m FL}}



static void Test_S5217C38()
{
  {
    init_simple_test("S5217C38");
    S5217C38 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(S5217C38)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S5217C38)");
    check_field_offset(lv, s5217c38f0, 0, "S5217C38.s5217c38f0");
    check_field_offset(lv, s5217c38f1, ABISELECT(8,4), "S5217C38.s5217c38f1");
    check_field_offset(lv, s5217c38f2, ABISELECT(12,8), "S5217C38.s5217c38f2");
    check_field_offset(lv, s5217c38f3, ABISELECT(16,12), "S5217C38.s5217c38f3");
  }
}
static Arrange_To_Call_Me vS5217C38(Test_S5217C38, "S5217C38", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C40  {
  void *s5217c40f0;
  int s5217c40f1;
  int s5217c40f2;
  void  mf5217c40(); // _ZN8S5217C409mf5217c40Ev
};
//SIG(-1 S5217C40) C1{ m Fp Fi[2]}


void  S5217C40 ::mf5217c40(){}

static void Test_S5217C40()
{
  {
    init_simple_test("S5217C40");
    S5217C40 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S5217C40)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S5217C40)");
    check_field_offset(lv, s5217c40f0, 0, "S5217C40.s5217c40f0");
    check_field_offset(lv, s5217c40f1, ABISELECT(8,4), "S5217C40.s5217c40f1");
    check_field_offset(lv, s5217c40f2, ABISELECT(12,8), "S5217C40.s5217c40f2");
  }
}
static Arrange_To_Call_Me vS5217C40(Test_S5217C40, "S5217C40", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C45  {
};
//SIG(-1 S5217C45) C1{}



static void Test_S5217C45()
{
  {
    init_simple_test("S5217C45");
    S5217C45 lv;
    check2(sizeof(lv), 1, "sizeof(S5217C45)");
    check2(__alignof__(lv), 1, "__alignof__(S5217C45)");
  }
}
static Arrange_To_Call_Me vS5217C45(Test_S5217C45, "S5217C45", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S5217C45[];
VTBL_ENTRY *P__ZTI8S5217C45 = _ZTI8S5217C45; 
Class_Descriptor cd_S5217C45 = {  "S5217C45", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S5217C45),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C44  : S5217C45 {
};
//SIG(-1 S5217C44) C1{ BC2{}}



static void Test_S5217C44()
{
  extern Class_Descriptor cd_S5217C44;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S5217C44, buf);
    S5217C44 &lv = *(new (buf) S5217C44());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S5217C44)");
    check2(__alignof__(lv), 1, "__alignof__(S5217C44)");
    check_base_class_offset(lv, (S5217C45*), 0, "S5217C44");
    test_class_info(&lv, &cd_S5217C44);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS5217C44(Test_S5217C44, "S5217C44", 1);

#else // __cplusplus

extern Class_Descriptor cd_S5217C45;
extern VTBL_ENTRY _ZTI8S5217C45[];
static Base_Class bases_S5217C44[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5217C45,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S5217C44 = {  "S5217C44", // class name
  bases_S5217C44, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C43  : S5217C7_nt {
  ::S5217C44 s5217c43f0;
};
//SIG(-1 S5217C43) C1{ BC2{} FC3{ BC4{}}}



static void Test_S5217C43()
{
  extern Class_Descriptor cd_S5217C43;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S5217C43, buf);
    S5217C43 &lv = *(new (buf) S5217C43());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S5217C43)");
    check2(__alignof__(lv), 1, "__alignof__(S5217C43)");
    check_base_class_offset(lv, (S5217C7_nt*), 0, "S5217C43");
    check_field_offset(lv, s5217c43f0, 0, "S5217C43.s5217c43f0");
    test_class_info(&lv, &cd_S5217C43);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS5217C43(Test_S5217C43, "S5217C43", 1);

#else // __cplusplus

extern Class_Descriptor cd_S5217C7_nt;
static Base_Class bases_S5217C43[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5217C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S5217C43 = {  "S5217C43", // class name
  bases_S5217C43, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C42  : S5217C43 {
  void *s5217c42f0;
  void *s5217c42f1;
  void *s5217c42f2;
};
//SIG(-1 S5217C42) C1{ BC2{ BC3{} FC4{ BC5{}}} Fp[3]}



static void Test_S5217C42()
{
  extern Class_Descriptor cd_S5217C42;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S5217C42, buf);
    S5217C42 &lv = *(new (buf) S5217C42());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S5217C42)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S5217C42)");
    check_base_class_offset(lv, (S5217C7_nt*)(S5217C43*), 0, "S5217C42");
    check_base_class_offset(lv, (S5217C43*), 0, "S5217C42");
    check_field_offset(lv, s5217c42f0, ABISELECT(8,4), "S5217C42.s5217c42f0");
    check_field_offset(lv, s5217c42f1, ABISELECT(16,8), "S5217C42.s5217c42f1");
    check_field_offset(lv, s5217c42f2, ABISELECT(24,12), "S5217C42.s5217c42f2");
    test_class_info(&lv, &cd_S5217C42);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS5217C42(Test_S5217C42, "S5217C42", ABISELECT(32,16));

#else // __cplusplus

extern Class_Descriptor cd_S5217C7_nt;
extern Class_Descriptor cd_S5217C43;
static Base_Class bases_S5217C42[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5217C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S5217C43,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S5217C42 = {  "S5217C42", // class name
  bases_S5217C42, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C51  {
  char s5217c51f0;
  char s5217c51f1[15];
  void  mf5217c51(); // _ZN8S5217C519mf5217c51Ev
};
//SIG(-1 S5217C51) C1{ m Fc[16]}


void  S5217C51 ::mf5217c51(){}

static void Test_S5217C51()
{
  {
    init_simple_test("S5217C51");
    S5217C51 lv;
    check2(sizeof(lv), 16, "sizeof(S5217C51)");
    check2(__alignof__(lv), 1, "__alignof__(S5217C51)");
    check_field_offset(lv, s5217c51f0, 0, "S5217C51.s5217c51f0");
    check_field_offset(lv, s5217c51f1, 1, "S5217C51.s5217c51f1");
  }
}
static Arrange_To_Call_Me vS5217C51(Test_S5217C51, "S5217C51", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C50  {
  ::S5217C51 s5217c50f0;
  ::S5217C51 s5217c50f1;
};
//SIG(1 S5217C50) C1{ FC2{ m Fc[16]} FC2}



static void Test_S5217C50()
{
  {
    init_simple_test("S5217C50");
    S5217C50 lv;
    check2(sizeof(lv), 32, "sizeof(S5217C50)");
    check2(__alignof__(lv), 1, "__alignof__(S5217C50)");
    check_field_offset(lv, s5217c50f0, 0, "S5217C50.s5217c50f0");
    check_field_offset(lv, s5217c50f1, 16, "S5217C50.s5217c50f1");
  }
}
static Arrange_To_Call_Me vS5217C50(Test_S5217C50, "S5217C50", 32);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C53  : S5217C7_nt {
  ::S5217C44 s5217c53f0;
};
//SIG(-1 S5217C53) C1{ BC2{} FC3{ BC4{}}}



static void Test_S5217C53()
{
  extern Class_Descriptor cd_S5217C53;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S5217C53, buf);
    S5217C53 &lv = *(new (buf) S5217C53());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S5217C53)");
    check2(__alignof__(lv), 1, "__alignof__(S5217C53)");
    check_base_class_offset(lv, (S5217C7_nt*), 0, "S5217C53");
    check_field_offset(lv, s5217c53f0, 0, "S5217C53.s5217c53f0");
    test_class_info(&lv, &cd_S5217C53);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS5217C53(Test_S5217C53, "S5217C53", 1);

#else // __cplusplus

extern Class_Descriptor cd_S5217C7_nt;
static Base_Class bases_S5217C53[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5217C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S5217C53 = {  "S5217C53", // class name
  bases_S5217C53, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C52  : S5217C53 {
  void *s5217c52f0;
  void *s5217c52f1;
  void *s5217c52f2;
};
//SIG(-1 S5217C52) C1{ BC2{ BC3{} FC4{ BC5{}}} Fp[3]}



static void Test_S5217C52()
{
  extern Class_Descriptor cd_S5217C52;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S5217C52, buf);
    S5217C52 &lv = *(new (buf) S5217C52());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S5217C52)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S5217C52)");
    check_base_class_offset(lv, (S5217C7_nt*)(S5217C53*), 0, "S5217C52");
    check_base_class_offset(lv, (S5217C53*), 0, "S5217C52");
    check_field_offset(lv, s5217c52f0, ABISELECT(8,4), "S5217C52.s5217c52f0");
    check_field_offset(lv, s5217c52f1, ABISELECT(16,8), "S5217C52.s5217c52f1");
    check_field_offset(lv, s5217c52f2, ABISELECT(24,12), "S5217C52.s5217c52f2");
    test_class_info(&lv, &cd_S5217C52);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS5217C52(Test_S5217C52, "S5217C52", ABISELECT(32,16));

#else // __cplusplus

extern Class_Descriptor cd_S5217C7_nt;
extern Class_Descriptor cd_S5217C53;
static Base_Class bases_S5217C52[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5217C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S5217C53,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S5217C52 = {  "S5217C52", // class name
  bases_S5217C52, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C60_nt  {
  void *s5217c60f0;
  void  mf5217c60(); // _ZN11S5217C60_nt9mf5217c60Ev
};
//SIG(-1 S5217C60_nt) C1{ m Fp}


void  S5217C60_nt ::mf5217c60(){}

//skip512 S5217C60_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI11S5217C60_nt[];
VTBL_ENTRY *P__ZTI11S5217C60_nt = _ZTI11S5217C60_nt; 
Class_Descriptor cd_S5217C60_nt = {  "S5217C60_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S5217C60_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C62  {
  int s5217c62f0;
  int s5217c62f1;
  int s5217c62f2;
  int s5217c62f3;
  int s5217c62f4;
  int s5217c62f5;
  int s5217c62f6;
  char s5217c62f7;
  char s5217c62f8;
  char s5217c62f9;
  int s5217c62f10;
  void  mf5217c62(); // _ZN8S5217C629mf5217c62Ev
};
//SIG(-1 S5217C62) C1{ m Fi[7] Fc[3] Fi}


void  S5217C62 ::mf5217c62(){}

static void Test_S5217C62()
{
  {
    init_simple_test("S5217C62");
    S5217C62 lv;
    check2(sizeof(lv), 36, "sizeof(S5217C62)");
    check2(__alignof__(lv), 4, "__alignof__(S5217C62)");
    check_field_offset(lv, s5217c62f0, 0, "S5217C62.s5217c62f0");
    check_field_offset(lv, s5217c62f1, 4, "S5217C62.s5217c62f1");
    check_field_offset(lv, s5217c62f2, 8, "S5217C62.s5217c62f2");
    check_field_offset(lv, s5217c62f3, 12, "S5217C62.s5217c62f3");
    check_field_offset(lv, s5217c62f4, 16, "S5217C62.s5217c62f4");
    check_field_offset(lv, s5217c62f5, 20, "S5217C62.s5217c62f5");
    check_field_offset(lv, s5217c62f6, 24, "S5217C62.s5217c62f6");
    check_field_offset(lv, s5217c62f7, 28, "S5217C62.s5217c62f7");
    check_field_offset(lv, s5217c62f8, 29, "S5217C62.s5217c62f8");
    check_field_offset(lv, s5217c62f9, 30, "S5217C62.s5217c62f9");
    check_field_offset(lv, s5217c62f10, 32, "S5217C62.s5217c62f10");
  }
}
static Arrange_To_Call_Me vS5217C62(Test_S5217C62, "S5217C62", 36);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C61  {
  ::S5217C62 s5217c61f0;
  char s5217c61f1;
  void  mf5217c61(); // _ZN8S5217C619mf5217c61Ev
};
//SIG(1 S5217C61) C1{ m FC2{ m Fi[7] Fc[3] Fi} Fc}


void  S5217C61 ::mf5217c61(){}

static void Test_S5217C61()
{
  {
    init_simple_test("S5217C61");
    S5217C61 lv;
    check2(sizeof(lv), 40, "sizeof(S5217C61)");
    check2(__alignof__(lv), 4, "__alignof__(S5217C61)");
    check_field_offset(lv, s5217c61f0, 0, "S5217C61.s5217c61f0");
    check_field_offset(lv, s5217c61f1, 36, "S5217C61.s5217c61f1");
  }
}
static Arrange_To_Call_Me vS5217C61(Test_S5217C61, "S5217C61", 40);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C64_nt  {
  int s5217c64f0;
  int s5217c64f1;
  int s5217c64f2;
  int s5217c64f3;
  int s5217c64f4;
  char s5217c64f5;
  int s5217c64f6;
  int s5217c64f7;
  void  mf5217c64(); // _ZN11S5217C64_nt9mf5217c64Ev
};
//SIG(-1 S5217C64_nt) C1{ m Fi[5] Fc Fi[2]}


void  S5217C64_nt ::mf5217c64(){}

//skip512 S5217C64_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C63  {
  char s5217c63f0;
  char s5217c63f1;
  int s5217c63f2;
  int s5217c63f3;
  int s5217c63f4;
  int s5217c63f5;
  ::S5217C39_nt s5217c63f6;
  int s5217c63f7;
  int s5217c63f8;
  int s5217c63f9;
  int s5217c63f10;
  int s5217c63f11;
  int s5217c63f12;
  ::S5217C64_nt s5217c63f13;
  void  mf5217c63(); // _ZN8S5217C639mf5217c63Ev
};
//SIG(-1 S5217C63) C1{ m Fc[2] Fi[4] FC2{ m FL} Fi[6] FC3{ m Fi[5] Fc Fi[2]}}


void  S5217C63 ::mf5217c63(){}

static void Test_S5217C63()
{
  {
    init_simple_test("S5217C63");
    S5217C63 lv;
    check2(sizeof(lv), ABISELECT(88,84), "sizeof(S5217C63)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S5217C63)");
    check_field_offset(lv, s5217c63f0, 0, "S5217C63.s5217c63f0");
    check_field_offset(lv, s5217c63f1, 1, "S5217C63.s5217c63f1");
    check_field_offset(lv, s5217c63f2, 4, "S5217C63.s5217c63f2");
    check_field_offset(lv, s5217c63f3, 8, "S5217C63.s5217c63f3");
    check_field_offset(lv, s5217c63f4, 12, "S5217C63.s5217c63f4");
    check_field_offset(lv, s5217c63f5, 16, "S5217C63.s5217c63f5");
    check_field_offset(lv, s5217c63f6, ABISELECT(24,20), "S5217C63.s5217c63f6");
    check_field_offset(lv, s5217c63f7, ABISELECT(32,28), "S5217C63.s5217c63f7");
    check_field_offset(lv, s5217c63f8, ABISELECT(36,32), "S5217C63.s5217c63f8");
    check_field_offset(lv, s5217c63f9, ABISELECT(40,36), "S5217C63.s5217c63f9");
    check_field_offset(lv, s5217c63f10, ABISELECT(44,40), "S5217C63.s5217c63f10");
    check_field_offset(lv, s5217c63f11, ABISELECT(48,44), "S5217C63.s5217c63f11");
    check_field_offset(lv, s5217c63f12, ABISELECT(52,48), "S5217C63.s5217c63f12");
    check_field_offset(lv, s5217c63f13, ABISELECT(56,52), "S5217C63.s5217c63f13");
  }
}
static Arrange_To_Call_Me vS5217C63(Test_S5217C63, "S5217C63", ABISELECT(88,84));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C65  {
  ::S5217C14_nt s5217c65f0;
  ::S5217C14_nt s5217c65f1;
  ::S5217C14_nt s5217c65f2;
  ::S5217C14_nt s5217c65f3;
  int s5217c65f4;
  int s5217c65f5;
  int s5217c65f6;
  int s5217c65f7;
  int s5217c65f8;
  int s5217c65f9;
  int s5217c65f10;
  char s5217c65f11;
  char s5217c65f12[3];
  void  mf5217c65(); // _ZN8S5217C659mf5217c65Ev
};
//SIG(-1 S5217C65) C1{ m FC2{ BC3{ m Fc[16]}} FC2 FC2 FC2 Fi[7] Fc[4]}


void  S5217C65 ::mf5217c65(){}

static void Test_S5217C65()
{
  {
    init_simple_test("S5217C65");
    S5217C65 lv;
    check2(sizeof(lv), 96, "sizeof(S5217C65)");
    check2(__alignof__(lv), 4, "__alignof__(S5217C65)");
    check_field_offset(lv, s5217c65f0, 0, "S5217C65.s5217c65f0");
    check_field_offset(lv, s5217c65f1, 16, "S5217C65.s5217c65f1");
    check_field_offset(lv, s5217c65f2, 32, "S5217C65.s5217c65f2");
    check_field_offset(lv, s5217c65f3, 48, "S5217C65.s5217c65f3");
    check_field_offset(lv, s5217c65f4, 64, "S5217C65.s5217c65f4");
    check_field_offset(lv, s5217c65f5, 68, "S5217C65.s5217c65f5");
    check_field_offset(lv, s5217c65f6, 72, "S5217C65.s5217c65f6");
    check_field_offset(lv, s5217c65f7, 76, "S5217C65.s5217c65f7");
    check_field_offset(lv, s5217c65f8, 80, "S5217C65.s5217c65f8");
    check_field_offset(lv, s5217c65f9, 84, "S5217C65.s5217c65f9");
    check_field_offset(lv, s5217c65f10, 88, "S5217C65.s5217c65f10");
    check_field_offset(lv, s5217c65f11, 92, "S5217C65.s5217c65f11");
    check_field_offset(lv, s5217c65f12, 93, "S5217C65.s5217c65f12");
  }
}
static Arrange_To_Call_Me vS5217C65(Test_S5217C65, "S5217C65", 96);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5217C1  : S5217C2 , S5217C11_nt , S5217C12_nt {
  char s5217c1f0[12];
  ::S5217C13 s5217c1f1[4];
  char s5217c1f2;
  char s5217c1f3;
  char s5217c1f4;
  char s5217c1f5;
  int s5217c1f6;
  ::S5217C4_nt s5217c1f7;
  char s5217c1f8;
  char s5217c1f9;
  char s5217c1f10;
  char s5217c1f11;
  int s5217c1f12;
  int s5217c1f13;
  int s5217c1f14;
  int s5217c1f15;
  char s5217c1f16[6];
  char s5217c1f17[6];
  char s5217c1f18;
  void *s5217c1f19;
  char s5217c1f20;
  char s5217c1f21;
  char s5217c1f22;
  ::S5217C16_nt s5217c1f23;
  ::S5217C16_nt s5217c1f24;
  ::S5217C24_nt s5217c1f25;
  ::S5217C38 s5217c1f26[4];
  int s5217c1f27[4];
  int s5217c1f28;
  ::S5217C40 s5217c1f29;
  int s5217c1f30;
  ::S5217C40 s5217c1f31;
  ::S5217C42 s5217c1f32;
  ::S5217C42 s5217c1f33;
  int s5217c1f34;
  int s5217c1f35;
  int s5217c1f36;
  int s5217c1f37;
  int s5217c1f38;
  char s5217c1f39;
  int s5217c1f40;
  ::S5217C50 s5217c1f41[10];
  int s5217c1f42;
  int s5217c1f43;
  int s5217c1f44[4];
  ::S5217C52 s5217c1f45;
  ::S5217C52 s5217c1f46;
  ::S5217C60_nt s5217c1f47;
  void *s5217c1f48;
  void *s5217c1f49;
  int s5217c1f50;
  int s5217c1f51;
  int s5217c1f52;
  ::S5217C39_nt s5217c1f53;
  int s5217c1f54;
  int s5217c1f55;
  int s5217c1f56;
  ::S5217C61 s5217c1f57[2];
  int s5217c1f58;
  ::S5217C63 s5217c1f59;
  int s5217c1f60;
  char s5217c1f61;
  int s5217c1f62;
  ::S5217C65 s5217c1f63;
  int s5217c1f64;
  virtual  ~S5217C1(); // _ZN7S5217C1D1Ev
  virtual void  v1(); // _ZN7S5217C12v1Ev
  virtual void  v2(); // _ZN7S5217C12v2Ev
  virtual void  v3(); // _ZN7S5217C12v3Ev
  virtual void  v4(); // _ZN7S5217C12v4Ev
  S5217C1(); // tgen
};
//SIG(1 S5217C1) C1{ BC2{ BC3{ vd v5 Fc[12] Fp[3] Fi} vd v6 Fc[12] Fi FC4{ BC5{ BC6{ BC7{}} FC8{ BC9{}}} FU10{ Fc[16] Fp} Fi Fi}} BC11{ vd v7} BC12{ vd v8 v9 v10 v11 v12} vd v1 v2 v3 v4 Fc[12] FC13{ FC14{ BC15{ m Fc Fc[15]}} Fi Fi Fi Fi}[4] Fc Fc Fc Fc Fi FC4 Fc Fc Fc Fc Fi Fi Fi Fi Fc[6] Fc[6] Fc Fp Fc Fc Fc FC16{ BC17{ BC7 FC8} Fp Fp Fp} FC16 FC18{ BC19{ BC20{ BC21{ BC22{ BC23{ BC7 FC24{ BC25{}}} FC24} FC26{ BC27{}}} FC26} Fp Fi}} FC28{ Fp Fc Fi FC29{ m FL}}[4] Fi[4] Fi FC30{ m Fp Fi Fi} Fi FC30 FC31{ BC32{ BC7 FC33{ BC34{}}} Fp Fp Fp} FC31 Fi Fi Fi Fi Fi Fc Fi FC35{ FC36{ m Fc Fc[15]} FC36}[10] Fi Fi Fi[4] FC37{ BC38{ BC7 FC33} Fp Fp Fp} FC37 FC39{ m Fp} Fp Fp Fi Fi Fi FC29 Fi Fi Fi FC40{ m FC41{ m Fi Fi Fi Fi Fi Fi Fi Fc Fc Fc Fi} Fc}[2] Fi FC42{ m Fc Fc Fi Fi Fi Fi FC29 Fi Fi Fi Fi Fi Fi FC43{ m Fi Fi Fi Fi Fi Fc Fi Fi}} Fi Fc Fi FC44{ m FC14 FC14 FC14 FC14 Fi Fi Fi Fi Fi Fi Fi Fc Fc[3]} Fi}


 S5217C1 ::~S5217C1(){ note_dtor("S5217C1", this);}
void  S5217C1 ::v1(){vfunc_called(this, "_ZN7S5217C12v1Ev");}
void  S5217C1 ::v2(){vfunc_called(this, "_ZN7S5217C12v2Ev");}
void  S5217C1 ::v3(){vfunc_called(this, "_ZN7S5217C12v3Ev");}
void  S5217C1 ::v4(){vfunc_called(this, "_ZN7S5217C12v4Ev");}
S5217C1 ::S5217C1(){ note_ctor("S5217C1", this);} // tgen

static void Test_S5217C1()
{
  extern Class_Descriptor cd_S5217C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(183,310)];
    init_test(&cd_S5217C1, buf);
    S5217C1 *dp, &lv = *(dp=new (buf) S5217C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1456,1236), "sizeof(S5217C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S5217C1)");
    check_base_class_offset(lv, (S5217C3*)(S5217C2*), 0, "S5217C1");
    check_base_class_offset(lv, (S5217C2*), 0, "S5217C1");
    check_base_class_offset(lv, (S5217C11_nt*), ABISELECT(104,76), "S5217C1");
    check_base_class_offset(lv, (S5217C12_nt*), ABISELECT(112,80), "S5217C1");
    check_field_offset(lv, s5217c1f0, ABISELECT(120,84), "S5217C1.s5217c1f0");
    check_field_offset(lv, s5217c1f1, ABISELECT(132,96), "S5217C1.s5217c1f1");
    check_field_offset(lv, s5217c1f2, ABISELECT(260,224), "S5217C1.s5217c1f2");
    check_field_offset(lv, s5217c1f3, ABISELECT(261,225), "S5217C1.s5217c1f3");
    check_field_offset(lv, s5217c1f4, ABISELECT(262,226), "S5217C1.s5217c1f4");
    check_field_offset(lv, s5217c1f5, ABISELECT(263,227), "S5217C1.s5217c1f5");
    check_field_offset(lv, s5217c1f6, ABISELECT(264,228), "S5217C1.s5217c1f6");
    check_field_offset(lv, s5217c1f7, ABISELECT(272,232), "S5217C1.s5217c1f7");
    check_field_offset(lv, s5217c1f8, ABISELECT(304,260), "S5217C1.s5217c1f8");
    check_field_offset(lv, s5217c1f9, ABISELECT(305,261), "S5217C1.s5217c1f9");
    check_field_offset(lv, s5217c1f10, ABISELECT(306,262), "S5217C1.s5217c1f10");
    check_field_offset(lv, s5217c1f11, ABISELECT(307,263), "S5217C1.s5217c1f11");
    check_field_offset(lv, s5217c1f12, ABISELECT(308,264), "S5217C1.s5217c1f12");
    check_field_offset(lv, s5217c1f13, ABISELECT(312,268), "S5217C1.s5217c1f13");
    check_field_offset(lv, s5217c1f14, ABISELECT(316,272), "S5217C1.s5217c1f14");
    check_field_offset(lv, s5217c1f15, ABISELECT(320,276), "S5217C1.s5217c1f15");
    check_field_offset(lv, s5217c1f16, ABISELECT(324,280), "S5217C1.s5217c1f16");
    check_field_offset(lv, s5217c1f17, ABISELECT(330,286), "S5217C1.s5217c1f17");
    check_field_offset(lv, s5217c1f18, ABISELECT(336,292), "S5217C1.s5217c1f18");
    check_field_offset(lv, s5217c1f19, ABISELECT(344,296), "S5217C1.s5217c1f19");
    check_field_offset(lv, s5217c1f20, ABISELECT(352,300), "S5217C1.s5217c1f20");
    check_field_offset(lv, s5217c1f21, ABISELECT(353,301), "S5217C1.s5217c1f21");
    check_field_offset(lv, s5217c1f22, ABISELECT(354,302), "S5217C1.s5217c1f22");
    check_field_offset(lv, s5217c1f23, ABISELECT(360,304), "S5217C1.s5217c1f23");
    check_field_offset(lv, s5217c1f24, ABISELECT(392,320), "S5217C1.s5217c1f24");
    check_field_offset(lv, s5217c1f25, ABISELECT(424,336), "S5217C1.s5217c1f25");
    check_field_offset(lv, s5217c1f26, ABISELECT(448,348), "S5217C1.s5217c1f26");
    check_field_offset(lv, s5217c1f27, ABISELECT(544,428), "S5217C1.s5217c1f27");
    check_field_offset(lv, s5217c1f28, ABISELECT(560,444), "S5217C1.s5217c1f28");
    check_field_offset(lv, s5217c1f29, ABISELECT(568,448), "S5217C1.s5217c1f29");
    check_field_offset(lv, s5217c1f30, ABISELECT(584,460), "S5217C1.s5217c1f30");
    check_field_offset(lv, s5217c1f31, ABISELECT(592,464), "S5217C1.s5217c1f31");
    check_field_offset(lv, s5217c1f32, ABISELECT(608,476), "S5217C1.s5217c1f32");
    check_field_offset(lv, s5217c1f33, ABISELECT(640,492), "S5217C1.s5217c1f33");
    check_field_offset(lv, s5217c1f34, ABISELECT(672,508), "S5217C1.s5217c1f34");
    check_field_offset(lv, s5217c1f35, ABISELECT(676,512), "S5217C1.s5217c1f35");
    check_field_offset(lv, s5217c1f36, ABISELECT(680,516), "S5217C1.s5217c1f36");
    check_field_offset(lv, s5217c1f37, ABISELECT(684,520), "S5217C1.s5217c1f37");
    check_field_offset(lv, s5217c1f38, ABISELECT(688,524), "S5217C1.s5217c1f38");
    check_field_offset(lv, s5217c1f39, ABISELECT(692,528), "S5217C1.s5217c1f39");
    check_field_offset(lv, s5217c1f40, ABISELECT(696,532), "S5217C1.s5217c1f40");
    check_field_offset(lv, s5217c1f41, ABISELECT(700,536), "S5217C1.s5217c1f41");
    check_field_offset(lv, s5217c1f42, ABISELECT(1020,856), "S5217C1.s5217c1f42");
    check_field_offset(lv, s5217c1f43, ABISELECT(1024,860), "S5217C1.s5217c1f43");
    check_field_offset(lv, s5217c1f44, ABISELECT(1028,864), "S5217C1.s5217c1f44");
    check_field_offset(lv, s5217c1f45, ABISELECT(1048,880), "S5217C1.s5217c1f45");
    check_field_offset(lv, s5217c1f46, ABISELECT(1080,896), "S5217C1.s5217c1f46");
    check_field_offset(lv, s5217c1f47, ABISELECT(1112,912), "S5217C1.s5217c1f47");
    check_field_offset(lv, s5217c1f48, ABISELECT(1120,916), "S5217C1.s5217c1f48");
    check_field_offset(lv, s5217c1f49, ABISELECT(1128,920), "S5217C1.s5217c1f49");
    check_field_offset(lv, s5217c1f50, ABISELECT(1136,924), "S5217C1.s5217c1f50");
    check_field_offset(lv, s5217c1f51, ABISELECT(1140,928), "S5217C1.s5217c1f51");
    check_field_offset(lv, s5217c1f52, ABISELECT(1144,932), "S5217C1.s5217c1f52");
    check_field_offset(lv, s5217c1f53, ABISELECT(1152,936), "S5217C1.s5217c1f53");
    check_field_offset(lv, s5217c1f54, ABISELECT(1160,944), "S5217C1.s5217c1f54");
    check_field_offset(lv, s5217c1f55, ABISELECT(1164,948), "S5217C1.s5217c1f55");
    check_field_offset(lv, s5217c1f56, ABISELECT(1168,952), "S5217C1.s5217c1f56");
    check_field_offset(lv, s5217c1f57, ABISELECT(1172,956), "S5217C1.s5217c1f57");
    check_field_offset(lv, s5217c1f58, ABISELECT(1252,1036), "S5217C1.s5217c1f58");
    check_field_offset(lv, s5217c1f59, ABISELECT(1256,1040), "S5217C1.s5217c1f59");
    check_field_offset(lv, s5217c1f60, ABISELECT(1344,1124), "S5217C1.s5217c1f60");
    check_field_offset(lv, s5217c1f61, ABISELECT(1348,1128), "S5217C1.s5217c1f61");
    check_field_offset(lv, s5217c1f62, ABISELECT(1352,1132), "S5217C1.s5217c1f62");
    check_field_offset(lv, s5217c1f63, ABISELECT(1356,1136), "S5217C1.s5217c1f63");
    check_field_offset(lv, s5217c1f64, ABISELECT(1452,1232), "S5217C1.s5217c1f64");
    test_class_info(&lv, &cd_S5217C1);
    dp->~S5217C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS5217C1(Test_S5217C1, "S5217C1", ABISELECT(1456,1236));

#else // __cplusplus

extern void _ZN7S5217C1C1Ev();
extern void _ZN7S5217C1D1Ev();
Name_Map name_map_S5217C1[] = {
  NSPAIR(_ZN7S5217C1C1Ev),
  NSPAIR(_ZN7S5217C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S5217C3;
extern VTBL_ENTRY _ZTI7S5217C3[];
extern  VTBL_ENTRY _ZTV7S5217C3[];
extern Class_Descriptor cd_S5217C2;
extern VTBL_ENTRY _ZTI7S5217C2[];
extern  VTBL_ENTRY _ZTV7S5217C2[];
extern Class_Descriptor cd_S5217C11_nt;
extern VTBL_ENTRY _ZTI11S5217C11_nt[];
extern  VTBL_ENTRY _ZTV11S5217C11_nt[];
extern Class_Descriptor cd_S5217C12_nt;
extern VTBL_ENTRY _ZTI11S5217C12_nt[];
extern  VTBL_ENTRY _ZTV11S5217C12_nt[];
static Base_Class bases_S5217C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5217C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S5217C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S5217C11_nt,    ABISELECT(104,76), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S5217C12_nt,    ABISELECT(112,80), //bcp->offset
    15, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S5217C1[];
extern void _ZN7S5217C1D1Ev();
extern void _ZN7S5217C1D0Ev();
extern void _ZN7S5217C32v5Ev();
extern void _ZN7S5217C22v6Ev();
extern void _ZN7S5217C12v1Ev();
extern void _ZN7S5217C12v2Ev();
extern void _ZN7S5217C12v3Ev();
extern void _ZN7S5217C12v4Ev();
extern void ABISELECT(_ZThn104_N7S5217C1D1Ev,_ZThn76_N7S5217C1D1Ev)();
extern void ABISELECT(_ZThn104_N7S5217C1D0Ev,_ZThn76_N7S5217C1D0Ev)();
extern void _ZN11S5217C11_nt2v7Ev();
extern void ABISELECT(_ZThn112_N7S5217C1D1Ev,_ZThn80_N7S5217C1D1Ev)();
extern void ABISELECT(_ZThn112_N7S5217C1D0Ev,_ZThn80_N7S5217C1D0Ev)();
extern void _ZN11S5217C12_nt2v8Ev();
extern void _ZN11S5217C12_nt2v9Ev();
extern void _ZN11S5217C12_nt3v10Ev();
extern void _ZN11S5217C12_nt3v11Ev();
extern void _ZN11S5217C12_nt3v12Ev();
static  VTBL_ENTRY vtc_S5217C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S5217C1[0]),
  (VTBL_ENTRY)&_ZN7S5217C1D1Ev,
  (VTBL_ENTRY)&_ZN7S5217C1D0Ev,
  (VTBL_ENTRY)&_ZN7S5217C32v5Ev,
  (VTBL_ENTRY)&_ZN7S5217C22v6Ev,
  (VTBL_ENTRY)&_ZN7S5217C12v1Ev,
  (VTBL_ENTRY)&_ZN7S5217C12v2Ev,
  (VTBL_ENTRY)&_ZN7S5217C12v3Ev,
  (VTBL_ENTRY)&_ZN7S5217C12v4Ev,
  ABISELECT(-104,-76),
  (VTBL_ENTRY)&(_ZTI7S5217C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N7S5217C1D1Ev,_ZThn76_N7S5217C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N7S5217C1D0Ev,_ZThn76_N7S5217C1D0Ev),
  (VTBL_ENTRY)&_ZN11S5217C11_nt2v7Ev,
  ABISELECT(-112,-80),
  (VTBL_ENTRY)&(_ZTI7S5217C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N7S5217C1D1Ev,_ZThn80_N7S5217C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N7S5217C1D0Ev,_ZThn80_N7S5217C1D0Ev),
  (VTBL_ENTRY)&_ZN11S5217C12_nt2v8Ev,
  (VTBL_ENTRY)&_ZN11S5217C12_nt2v9Ev,
  (VTBL_ENTRY)&_ZN11S5217C12_nt3v10Ev,
  (VTBL_ENTRY)&_ZN11S5217C12_nt3v11Ev,
  (VTBL_ENTRY)&_ZN11S5217C12_nt3v12Ev,
};
extern VTBL_ENTRY _ZTI7S5217C1[];
extern  VTBL_ENTRY _ZTV7S5217C1[];
Class_Descriptor cd_S5217C1 = {  "S5217C1", // class name
  bases_S5217C1, 4,
  &(vtc_S5217C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1456,1236), // object size
  NSPAIRA(_ZTI7S5217C1),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S5217C1),24, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S74C7  {
  int s74c7f0;
  __tsi64 s74c7f1;
  void *s74c7f2[4];
  int s74c7f3[2];
  void *s74c7f4;
  ::S1409C5_nt s74c7f5;
  void *s74c7f6[2];
  virtual  ~S74C7(); // _ZN5S74C7D1Ev
  virtual void  v4(); // _ZN5S74C72v4Ev
  virtual void  v5(); // _ZN5S74C72v5Ev
  virtual void  v6(); // _ZN5S74C72v6Ev
  virtual void  v7(); // _ZN5S74C72v7Ev
  virtual void  v8(); // _ZN5S74C72v8Ev
  virtual void  v9(); // _ZN5S74C72v9Ev
  virtual void  v10(); // _ZN5S74C73v10Ev
  virtual void  v11(); // _ZN5S74C73v11Ev
  virtual void  v12(); // _ZN5S74C73v12Ev
  virtual void  v13(); // _ZN5S74C73v13Ev
  virtual void  v14(); // _ZN5S74C73v14Ev
  virtual void  v15(); // _ZN5S74C73v15Ev
  virtual void  v16(); // _ZN5S74C73v16Ev
  virtual void  v17(); // _ZN5S74C73v17Ev
  virtual void  v18(); // _ZN5S74C73v18Ev
  virtual void  v19(); // _ZN5S74C73v19Ev
  virtual void  v20(); // _ZN5S74C73v20Ev
  virtual void  v21(); // _ZN5S74C73v21Ev
  virtual void  v22(); // _ZN5S74C73v22Ev
  virtual void  v23(); // _ZN5S74C73v23Ev
  virtual void  v24(); // _ZN5S74C73v24Ev
  virtual void  v25(); // _ZN5S74C73v25Ev
  virtual void  v26(); // _ZN5S74C73v26Ev
  virtual void  v27(); // _ZN5S74C73v27Ev
  virtual void  v28(); // _ZN5S74C73v28Ev
  virtual void  v29(); // _ZN5S74C73v29Ev
  virtual void  v30(); // _ZN5S74C73v30Ev
  virtual void  v31(); // _ZN5S74C73v31Ev
  virtual void  v32(); // _ZN5S74C73v32Ev
  virtual void  v33(); // _ZN5S74C73v33Ev
  virtual void  v34(); // _ZN5S74C73v34Ev
  virtual void  v35(); // _ZN5S74C73v35Ev
  virtual void  v36(); // _ZN5S74C73v36Ev
  virtual void  v37(); // _ZN5S74C73v37Ev
  virtual void  v38(); // _ZN5S74C73v38Ev
  virtual void  v39(); // _ZN5S74C73v39Ev
  virtual void  v40(); // _ZN5S74C73v40Ev
  virtual void  v41(); // _ZN5S74C73v41Ev
  virtual void  v42(); // _ZN5S74C73v42Ev
  virtual void  v43(); // _ZN5S74C73v43Ev
  virtual void  v44(); // _ZN5S74C73v44Ev
  virtual void  v45(); // _ZN5S74C73v45Ev
  virtual void  v46(); // _ZN5S74C73v46Ev
  virtual void  v47(); // _ZN5S74C73v47Ev
  virtual void  v48(); // _ZN5S74C73v48Ev
  virtual void  v49(); // _ZN5S74C73v49Ev
  virtual void  v50(); // _ZN5S74C73v50Ev
  virtual void  v51(); // _ZN5S74C73v51Ev
  virtual void  v52(); // _ZN5S74C73v52Ev
  virtual void  v53(); // _ZN5S74C73v53Ev
  virtual void  v54(); // _ZN5S74C73v54Ev
  virtual void  v55(); // _ZN5S74C73v55Ev
  virtual void  v56(); // _ZN5S74C73v56Ev
  virtual void  v57(); // _ZN5S74C73v57Ev
  virtual void  v58(); // _ZN5S74C73v58Ev
  virtual void  v59(); // _ZN5S74C73v59Ev
  virtual void  v60(); // _ZN5S74C73v60Ev
  virtual void  v61(); // _ZN5S74C73v61Ev
  virtual void  v62(); // _ZN5S74C73v62Ev
  virtual void  v63(); // _ZN5S74C73v63Ev
  virtual void  v64(); // _ZN5S74C73v64Ev
  virtual void  v65(); // _ZN5S74C73v65Ev
  virtual void  v66(); // _ZN5S74C73v66Ev
  virtual void  v67(); // _ZN5S74C73v67Ev
  S74C7(); // tgen
};
//SIG(-1 S74C7) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S74C7 ::~S74C7(){ note_dtor("S74C7", this);}
void  S74C7 ::v4(){vfunc_called(this, "_ZN5S74C72v4Ev");}
void  S74C7 ::v5(){vfunc_called(this, "_ZN5S74C72v5Ev");}
void  S74C7 ::v6(){vfunc_called(this, "_ZN5S74C72v6Ev");}
void  S74C7 ::v7(){vfunc_called(this, "_ZN5S74C72v7Ev");}
void  S74C7 ::v8(){vfunc_called(this, "_ZN5S74C72v8Ev");}
void  S74C7 ::v9(){vfunc_called(this, "_ZN5S74C72v9Ev");}
void  S74C7 ::v10(){vfunc_called(this, "_ZN5S74C73v10Ev");}
void  S74C7 ::v11(){vfunc_called(this, "_ZN5S74C73v11Ev");}
void  S74C7 ::v12(){vfunc_called(this, "_ZN5S74C73v12Ev");}
void  S74C7 ::v13(){vfunc_called(this, "_ZN5S74C73v13Ev");}
void  S74C7 ::v14(){vfunc_called(this, "_ZN5S74C73v14Ev");}
void  S74C7 ::v15(){vfunc_called(this, "_ZN5S74C73v15Ev");}
void  S74C7 ::v16(){vfunc_called(this, "_ZN5S74C73v16Ev");}
void  S74C7 ::v17(){vfunc_called(this, "_ZN5S74C73v17Ev");}
void  S74C7 ::v18(){vfunc_called(this, "_ZN5S74C73v18Ev");}
void  S74C7 ::v19(){vfunc_called(this, "_ZN5S74C73v19Ev");}
void  S74C7 ::v20(){vfunc_called(this, "_ZN5S74C73v20Ev");}
void  S74C7 ::v21(){vfunc_called(this, "_ZN5S74C73v21Ev");}
void  S74C7 ::v22(){vfunc_called(this, "_ZN5S74C73v22Ev");}
void  S74C7 ::v23(){vfunc_called(this, "_ZN5S74C73v23Ev");}
void  S74C7 ::v24(){vfunc_called(this, "_ZN5S74C73v24Ev");}
void  S74C7 ::v25(){vfunc_called(this, "_ZN5S74C73v25Ev");}
void  S74C7 ::v26(){vfunc_called(this, "_ZN5S74C73v26Ev");}
void  S74C7 ::v27(){vfunc_called(this, "_ZN5S74C73v27Ev");}
void  S74C7 ::v28(){vfunc_called(this, "_ZN5S74C73v28Ev");}
void  S74C7 ::v29(){vfunc_called(this, "_ZN5S74C73v29Ev");}
void  S74C7 ::v30(){vfunc_called(this, "_ZN5S74C73v30Ev");}
void  S74C7 ::v31(){vfunc_called(this, "_ZN5S74C73v31Ev");}
void  S74C7 ::v32(){vfunc_called(this, "_ZN5S74C73v32Ev");}
void  S74C7 ::v33(){vfunc_called(this, "_ZN5S74C73v33Ev");}
void  S74C7 ::v34(){vfunc_called(this, "_ZN5S74C73v34Ev");}
void  S74C7 ::v35(){vfunc_called(this, "_ZN5S74C73v35Ev");}
void  S74C7 ::v36(){vfunc_called(this, "_ZN5S74C73v36Ev");}
void  S74C7 ::v37(){vfunc_called(this, "_ZN5S74C73v37Ev");}
void  S74C7 ::v38(){vfunc_called(this, "_ZN5S74C73v38Ev");}
void  S74C7 ::v39(){vfunc_called(this, "_ZN5S74C73v39Ev");}
void  S74C7 ::v40(){vfunc_called(this, "_ZN5S74C73v40Ev");}
void  S74C7 ::v41(){vfunc_called(this, "_ZN5S74C73v41Ev");}
void  S74C7 ::v42(){vfunc_called(this, "_ZN5S74C73v42Ev");}
void  S74C7 ::v43(){vfunc_called(this, "_ZN5S74C73v43Ev");}
void  S74C7 ::v44(){vfunc_called(this, "_ZN5S74C73v44Ev");}
void  S74C7 ::v45(){vfunc_called(this, "_ZN5S74C73v45Ev");}
void  S74C7 ::v46(){vfunc_called(this, "_ZN5S74C73v46Ev");}
void  S74C7 ::v47(){vfunc_called(this, "_ZN5S74C73v47Ev");}
void  S74C7 ::v48(){vfunc_called(this, "_ZN5S74C73v48Ev");}
void  S74C7 ::v49(){vfunc_called(this, "_ZN5S74C73v49Ev");}
void  S74C7 ::v50(){vfunc_called(this, "_ZN5S74C73v50Ev");}
void  S74C7 ::v51(){vfunc_called(this, "_ZN5S74C73v51Ev");}
void  S74C7 ::v52(){vfunc_called(this, "_ZN5S74C73v52Ev");}
void  S74C7 ::v53(){vfunc_called(this, "_ZN5S74C73v53Ev");}
void  S74C7 ::v54(){vfunc_called(this, "_ZN5S74C73v54Ev");}
void  S74C7 ::v55(){vfunc_called(this, "_ZN5S74C73v55Ev");}
void  S74C7 ::v56(){vfunc_called(this, "_ZN5S74C73v56Ev");}
void  S74C7 ::v57(){vfunc_called(this, "_ZN5S74C73v57Ev");}
void  S74C7 ::v58(){vfunc_called(this, "_ZN5S74C73v58Ev");}
void  S74C7 ::v59(){vfunc_called(this, "_ZN5S74C73v59Ev");}
void  S74C7 ::v60(){vfunc_called(this, "_ZN5S74C73v60Ev");}
void  S74C7 ::v61(){vfunc_called(this, "_ZN5S74C73v61Ev");}
void  S74C7 ::v62(){vfunc_called(this, "_ZN5S74C73v62Ev");}
void  S74C7 ::v63(){vfunc_called(this, "_ZN5S74C73v63Ev");}
void  S74C7 ::v64(){vfunc_called(this, "_ZN5S74C73v64Ev");}
void  S74C7 ::v65(){vfunc_called(this, "_ZN5S74C73v65Ev");}
void  S74C7 ::v66(){vfunc_called(this, "_ZN5S74C73v66Ev");}
void  S74C7 ::v67(){vfunc_called(this, "_ZN5S74C73v67Ev");}
S74C7 ::S74C7(){ note_ctor("S74C7", this);} // tgen

static void Test_S74C7()
{
  extern Class_Descriptor cd_S74C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S74C7, buf);
    S74C7 *dp, &lv = *(dp=new (buf) S74C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S74C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S74C7)");
    check_field_offset(lv, s74c7f0, ABISELECT(8,4), "S74C7.s74c7f0");
    check_field_offset(lv, s74c7f1, ABISELECT(16,8), "S74C7.s74c7f1");
    check_field_offset(lv, s74c7f2, ABISELECT(24,16), "S74C7.s74c7f2");
    check_field_offset(lv, s74c7f3, ABISELECT(56,32), "S74C7.s74c7f3");
    check_field_offset(lv, s74c7f4, ABISELECT(64,40), "S74C7.s74c7f4");
    check_field_offset(lv, s74c7f5, ABISELECT(72,44), "S74C7.s74c7f5");
    check_field_offset(lv, s74c7f6, ABISELECT(80,52), "S74C7.s74c7f6");
    test_class_info(&lv, &cd_S74C7);
    dp->~S74C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS74C7(Test_S74C7, "S74C7", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN5S74C7C1Ev();
extern void _ZN5S74C7D1Ev();
Name_Map name_map_S74C7[] = {
  NSPAIR(_ZN5S74C7C1Ev),
  NSPAIR(_ZN5S74C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI5S74C7[];
extern void _ZN5S74C7D1Ev();
extern void _ZN5S74C7D0Ev();
extern void _ZN5S74C72v4Ev();
extern void _ZN5S74C72v5Ev();
extern void _ZN5S74C72v6Ev();
extern void _ZN5S74C72v7Ev();
extern void _ZN5S74C72v8Ev();
extern void _ZN5S74C72v9Ev();
extern void _ZN5S74C73v10Ev();
extern void _ZN5S74C73v11Ev();
extern void _ZN5S74C73v12Ev();
extern void _ZN5S74C73v13Ev();
extern void _ZN5S74C73v14Ev();
extern void _ZN5S74C73v15Ev();
extern void _ZN5S74C73v16Ev();
extern void _ZN5S74C73v17Ev();
extern void _ZN5S74C73v18Ev();
extern void _ZN5S74C73v19Ev();
extern void _ZN5S74C73v20Ev();
extern void _ZN5S74C73v21Ev();
extern void _ZN5S74C73v22Ev();
extern void _ZN5S74C73v23Ev();
extern void _ZN5S74C73v24Ev();
extern void _ZN5S74C73v25Ev();
extern void _ZN5S74C73v26Ev();
extern void _ZN5S74C73v27Ev();
extern void _ZN5S74C73v28Ev();
extern void _ZN5S74C73v29Ev();
extern void _ZN5S74C73v30Ev();
extern void _ZN5S74C73v31Ev();
extern void _ZN5S74C73v32Ev();
extern void _ZN5S74C73v33Ev();
extern void _ZN5S74C73v34Ev();
extern void _ZN5S74C73v35Ev();
extern void _ZN5S74C73v36Ev();
extern void _ZN5S74C73v37Ev();
extern void _ZN5S74C73v38Ev();
extern void _ZN5S74C73v39Ev();
extern void _ZN5S74C73v40Ev();
extern void _ZN5S74C73v41Ev();
extern void _ZN5S74C73v42Ev();
extern void _ZN5S74C73v43Ev();
extern void _ZN5S74C73v44Ev();
extern void _ZN5S74C73v45Ev();
extern void _ZN5S74C73v46Ev();
extern void _ZN5S74C73v47Ev();
extern void _ZN5S74C73v48Ev();
extern void _ZN5S74C73v49Ev();
extern void _ZN5S74C73v50Ev();
extern void _ZN5S74C73v51Ev();
extern void _ZN5S74C73v52Ev();
extern void _ZN5S74C73v53Ev();
extern void _ZN5S74C73v54Ev();
extern void _ZN5S74C73v55Ev();
extern void _ZN5S74C73v56Ev();
extern void _ZN5S74C73v57Ev();
extern void _ZN5S74C73v58Ev();
extern void _ZN5S74C73v59Ev();
extern void _ZN5S74C73v60Ev();
extern void _ZN5S74C73v61Ev();
extern void _ZN5S74C73v62Ev();
extern void _ZN5S74C73v63Ev();
extern void _ZN5S74C73v64Ev();
extern void _ZN5S74C73v65Ev();
extern void _ZN5S74C73v66Ev();
extern void _ZN5S74C73v67Ev();
static  VTBL_ENTRY vtc_S74C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S74C7[0]),
  (VTBL_ENTRY)&_ZN5S74C7D1Ev,
  (VTBL_ENTRY)&_ZN5S74C7D0Ev,
  (VTBL_ENTRY)&_ZN5S74C72v4Ev,
  (VTBL_ENTRY)&_ZN5S74C72v5Ev,
  (VTBL_ENTRY)&_ZN5S74C72v6Ev,
  (VTBL_ENTRY)&_ZN5S74C72v7Ev,
  (VTBL_ENTRY)&_ZN5S74C72v8Ev,
  (VTBL_ENTRY)&_ZN5S74C72v9Ev,
  (VTBL_ENTRY)&_ZN5S74C73v10Ev,
  (VTBL_ENTRY)&_ZN5S74C73v11Ev,
  (VTBL_ENTRY)&_ZN5S74C73v12Ev,
  (VTBL_ENTRY)&_ZN5S74C73v13Ev,
  (VTBL_ENTRY)&_ZN5S74C73v14Ev,
  (VTBL_ENTRY)&_ZN5S74C73v15Ev,
  (VTBL_ENTRY)&_ZN5S74C73v16Ev,
  (VTBL_ENTRY)&_ZN5S74C73v17Ev,
  (VTBL_ENTRY)&_ZN5S74C73v18Ev,
  (VTBL_ENTRY)&_ZN5S74C73v19Ev,
  (VTBL_ENTRY)&_ZN5S74C73v20Ev,
  (VTBL_ENTRY)&_ZN5S74C73v21Ev,
  (VTBL_ENTRY)&_ZN5S74C73v22Ev,
  (VTBL_ENTRY)&_ZN5S74C73v23Ev,
  (VTBL_ENTRY)&_ZN5S74C73v24Ev,
  (VTBL_ENTRY)&_ZN5S74C73v25Ev,
  (VTBL_ENTRY)&_ZN5S74C73v26Ev,
  (VTBL_ENTRY)&_ZN5S74C73v27Ev,
  (VTBL_ENTRY)&_ZN5S74C73v28Ev,
  (VTBL_ENTRY)&_ZN5S74C73v29Ev,
  (VTBL_ENTRY)&_ZN5S74C73v30Ev,
  (VTBL_ENTRY)&_ZN5S74C73v31Ev,
  (VTBL_ENTRY)&_ZN5S74C73v32Ev,
  (VTBL_ENTRY)&_ZN5S74C73v33Ev,
  (VTBL_ENTRY)&_ZN5S74C73v34Ev,
  (VTBL_ENTRY)&_ZN5S74C73v35Ev,
  (VTBL_ENTRY)&_ZN5S74C73v36Ev,
  (VTBL_ENTRY)&_ZN5S74C73v37Ev,
  (VTBL_ENTRY)&_ZN5S74C73v38Ev,
  (VTBL_ENTRY)&_ZN5S74C73v39Ev,
  (VTBL_ENTRY)&_ZN5S74C73v40Ev,
  (VTBL_ENTRY)&_ZN5S74C73v41Ev,
  (VTBL_ENTRY)&_ZN5S74C73v42Ev,
  (VTBL_ENTRY)&_ZN5S74C73v43Ev,
  (VTBL_ENTRY)&_ZN5S74C73v44Ev,
  (VTBL_ENTRY)&_ZN5S74C73v45Ev,
  (VTBL_ENTRY)&_ZN5S74C73v46Ev,
  (VTBL_ENTRY)&_ZN5S74C73v47Ev,
  (VTBL_ENTRY)&_ZN5S74C73v48Ev,
  (VTBL_ENTRY)&_ZN5S74C73v49Ev,
  (VTBL_ENTRY)&_ZN5S74C73v50Ev,
  (VTBL_ENTRY)&_ZN5S74C73v51Ev,
  (VTBL_ENTRY)&_ZN5S74C73v52Ev,
  (VTBL_ENTRY)&_ZN5S74C73v53Ev,
  (VTBL_ENTRY)&_ZN5S74C73v54Ev,
  (VTBL_ENTRY)&_ZN5S74C73v55Ev,
  (VTBL_ENTRY)&_ZN5S74C73v56Ev,
  (VTBL_ENTRY)&_ZN5S74C73v57Ev,
  (VTBL_ENTRY)&_ZN5S74C73v58Ev,
  (VTBL_ENTRY)&_ZN5S74C73v59Ev,
  (VTBL_ENTRY)&_ZN5S74C73v60Ev,
  (VTBL_ENTRY)&_ZN5S74C73v61Ev,
  (VTBL_ENTRY)&_ZN5S74C73v62Ev,
  (VTBL_ENTRY)&_ZN5S74C73v63Ev,
  (VTBL_ENTRY)&_ZN5S74C73v64Ev,
  (VTBL_ENTRY)&_ZN5S74C73v65Ev,
  (VTBL_ENTRY)&_ZN5S74C73v66Ev,
  (VTBL_ENTRY)&_ZN5S74C73v67Ev,
};
extern VTBL_ENTRY _ZTI5S74C7[];
extern  VTBL_ENTRY _ZTV5S74C7[];
Class_Descriptor cd_S74C7 = {  "S74C7", // class name
  0,0,//no base classes
  &(vtc_S74C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI5S74C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV5S74C7),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S74C11  : S1409C8_nt {
};
//SIG(-1 S74C11) C1{ BC2{ m Fp Fi[2]}}



static void Test_S74C11()
{
  extern Class_Descriptor cd_S74C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S74C11, buf);
    S74C11 &lv = *(new (buf) S74C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S74C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S74C11)");
    check_base_class_offset(lv, (S1409C8_nt*), 0, "S74C11");
    test_class_info(&lv, &cd_S74C11);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS74C11(Test_S74C11, "S74C11", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1409C8_nt;
extern VTBL_ENTRY _ZTI10S1409C8_nt[];
static Base_Class bases_S74C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1409C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S74C11 = {  "S74C11", // class name
  bases_S74C11, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S74C10  : S74C11 {
};
//SIG(-1 S74C10) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S74C10()
{
  extern Class_Descriptor cd_S74C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S74C10, buf);
    S74C10 &lv = *(new (buf) S74C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S74C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S74C10)");
    check_base_class_offset(lv, (S1409C8_nt*)(S74C11*), 0, "S74C10");
    check_base_class_offset(lv, (S74C11*), 0, "S74C10");
    test_class_info(&lv, &cd_S74C10);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS74C10(Test_S74C10, "S74C10", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1409C8_nt;
extern VTBL_ENTRY _ZTI10S1409C8_nt[];
extern Class_Descriptor cd_S74C11;
static Base_Class bases_S74C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1409C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S74C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S74C10 = {  "S74C10", // class name
  bases_S74C10, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S74C9_nt  : S74C10 {
};
//SIG(-1 S74C9_nt) C1{ BC2{ BC3{ BC4{ m Fp Fi[2]}}}}



//skip512 S74C9_nt

#else // __cplusplus

extern Class_Descriptor cd_S1409C8_nt;
extern VTBL_ENTRY _ZTI10S1409C8_nt[];
extern Class_Descriptor cd_S74C11;
extern Class_Descriptor cd_S74C10;
static Base_Class bases_S74C9_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1409C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S74C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S74C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S74C6_nt  : S74C7 {
  int s74c6f0[2];
  void *s74c6f1;
  int s74c6f2[2];
  ::S74C9_nt s74c6f3;
  ::S74C9_nt s74c6f4;
  ::S2265C38 s74c6f5;
  ::S74C9_nt s74c6f6;
  unsigned int s74c6f7:1;
  unsigned int s74c6f8:1;
  unsigned int s74c6f9:1;
  unsigned int s74c6f10:1;
  unsigned int s74c6f11:1;
  int s74c6f12[2];
  virtual  ~S74C6_nt(); // _ZN8S74C6_ntD1Ev
  virtual void  v68(); // _ZN8S74C6_nt3v68Ev
  virtual void  v69(); // _ZN8S74C6_nt3v69Ev
  virtual void  v70(); // _ZN8S74C6_nt3v70Ev
  virtual void  v71(); // _ZN8S74C6_nt3v71Ev
  virtual void  v72(); // _ZN8S74C6_nt3v72Ev
  virtual void  v73(); // _ZN8S74C6_nt3v73Ev
  virtual void  v74(); // _ZN8S74C6_nt3v74Ev
  virtual void  v75(); // _ZN8S74C6_nt3v75Ev
  virtual void  v76(); // _ZN8S74C6_nt3v76Ev
  virtual void  v77(); // _ZN8S74C6_nt3v77Ev
  virtual void  v78(); // _ZN8S74C6_nt3v78Ev
  virtual void  v79(); // _ZN8S74C6_nt3v79Ev
  virtual void  v80(); // _ZN8S74C6_nt3v80Ev
  virtual void  v81(); // _ZN8S74C6_nt3v81Ev
  virtual void  v82(); // _ZN8S74C6_nt3v82Ev
  virtual void  v83(); // _ZN8S74C6_nt3v83Ev
  virtual void  v84(); // _ZN8S74C6_nt3v84Ev
  virtual void  v85(); // _ZN8S74C6_nt3v85Ev
  virtual void  v86(); // _ZN8S74C6_nt3v86Ev
  virtual void  v87(); // _ZN8S74C6_nt3v87Ev
  virtual void  v88(); // _ZN8S74C6_nt3v88Ev
  virtual void  v89(); // _ZN8S74C6_nt3v89Ev
  S74C6_nt(); // tgen
};
//SIG(-1 S74C6_nt) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S74C6_nt ::~S74C6_nt(){ note_dtor("S74C6_nt", this);}
void  S74C6_nt ::v68(){vfunc_called(this, "_ZN8S74C6_nt3v68Ev");}
void  S74C6_nt ::v69(){vfunc_called(this, "_ZN8S74C6_nt3v69Ev");}
void  S74C6_nt ::v70(){vfunc_called(this, "_ZN8S74C6_nt3v70Ev");}
void  S74C6_nt ::v71(){vfunc_called(this, "_ZN8S74C6_nt3v71Ev");}
void  S74C6_nt ::v72(){vfunc_called(this, "_ZN8S74C6_nt3v72Ev");}
void  S74C6_nt ::v73(){vfunc_called(this, "_ZN8S74C6_nt3v73Ev");}
void  S74C6_nt ::v74(){vfunc_called(this, "_ZN8S74C6_nt3v74Ev");}
void  S74C6_nt ::v75(){vfunc_called(this, "_ZN8S74C6_nt3v75Ev");}
void  S74C6_nt ::v76(){vfunc_called(this, "_ZN8S74C6_nt3v76Ev");}
void  S74C6_nt ::v77(){vfunc_called(this, "_ZN8S74C6_nt3v77Ev");}
void  S74C6_nt ::v78(){vfunc_called(this, "_ZN8S74C6_nt3v78Ev");}
void  S74C6_nt ::v79(){vfunc_called(this, "_ZN8S74C6_nt3v79Ev");}
void  S74C6_nt ::v80(){vfunc_called(this, "_ZN8S74C6_nt3v80Ev");}
void  S74C6_nt ::v81(){vfunc_called(this, "_ZN8S74C6_nt3v81Ev");}
void  S74C6_nt ::v82(){vfunc_called(this, "_ZN8S74C6_nt3v82Ev");}
void  S74C6_nt ::v83(){vfunc_called(this, "_ZN8S74C6_nt3v83Ev");}
void  S74C6_nt ::v84(){vfunc_called(this, "_ZN8S74C6_nt3v84Ev");}
void  S74C6_nt ::v85(){vfunc_called(this, "_ZN8S74C6_nt3v85Ev");}
void  S74C6_nt ::v86(){vfunc_called(this, "_ZN8S74C6_nt3v86Ev");}
void  S74C6_nt ::v87(){vfunc_called(this, "_ZN8S74C6_nt3v87Ev");}
void  S74C6_nt ::v88(){vfunc_called(this, "_ZN8S74C6_nt3v88Ev");}
void  S74C6_nt ::v89(){vfunc_called(this, "_ZN8S74C6_nt3v89Ev");}
S74C6_nt ::S74C6_nt(){ note_ctor("S74C6_nt", this);} // tgen

//skip512 S74C6_nt

#else // __cplusplus

extern void _ZN8S74C6_ntC1Ev();
extern void _ZN8S74C6_ntD1Ev();
Name_Map name_map_S74C6_nt[] = {
  NSPAIR(_ZN8S74C6_ntC1Ev),
  NSPAIR(_ZN8S74C6_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S74C7;
extern VTBL_ENTRY _ZTI5S74C7[];
extern  VTBL_ENTRY _ZTV5S74C7[];
static Base_Class bases_S74C6_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S74C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S74C6_nt[];
extern void _ZN8S74C6_ntD1Ev();
extern void _ZN8S74C6_ntD0Ev();
extern void _ZN5S74C72v4Ev();
extern void _ZN5S74C72v5Ev();
extern void _ZN5S74C72v6Ev();
extern void _ZN5S74C72v7Ev();
extern void _ZN5S74C72v8Ev();
extern void _ZN5S74C72v9Ev();
extern void _ZN5S74C73v10Ev();
extern void _ZN5S74C73v11Ev();
extern void _ZN5S74C73v12Ev();
extern void _ZN5S74C73v13Ev();
extern void _ZN5S74C73v14Ev();
extern void _ZN5S74C73v15Ev();
extern void _ZN5S74C73v16Ev();
extern void _ZN5S74C73v17Ev();
extern void _ZN5S74C73v18Ev();
extern void _ZN5S74C73v19Ev();
extern void _ZN5S74C73v20Ev();
extern void _ZN5S74C73v21Ev();
extern void _ZN5S74C73v22Ev();
extern void _ZN5S74C73v23Ev();
extern void _ZN5S74C73v24Ev();
extern void _ZN5S74C73v25Ev();
extern void _ZN5S74C73v26Ev();
extern void _ZN5S74C73v27Ev();
extern void _ZN5S74C73v28Ev();
extern void _ZN5S74C73v29Ev();
extern void _ZN5S74C73v30Ev();
extern void _ZN5S74C73v31Ev();
extern void _ZN5S74C73v32Ev();
extern void _ZN5S74C73v33Ev();
extern void _ZN5S74C73v34Ev();
extern void _ZN5S74C73v35Ev();
extern void _ZN5S74C73v36Ev();
extern void _ZN5S74C73v37Ev();
extern void _ZN5S74C73v38Ev();
extern void _ZN5S74C73v39Ev();
extern void _ZN5S74C73v40Ev();
extern void _ZN5S74C73v41Ev();
extern void _ZN5S74C73v42Ev();
extern void _ZN5S74C73v43Ev();
extern void _ZN5S74C73v44Ev();
extern void _ZN5S74C73v45Ev();
extern void _ZN5S74C73v46Ev();
extern void _ZN5S74C73v47Ev();
extern void _ZN5S74C73v48Ev();
extern void _ZN5S74C73v49Ev();
extern void _ZN5S74C73v50Ev();
extern void _ZN5S74C73v51Ev();
extern void _ZN5S74C73v52Ev();
extern void _ZN5S74C73v53Ev();
extern void _ZN5S74C73v54Ev();
extern void _ZN5S74C73v55Ev();
extern void _ZN5S74C73v56Ev();
extern void _ZN5S74C73v57Ev();
extern void _ZN5S74C73v58Ev();
extern void _ZN5S74C73v59Ev();
extern void _ZN5S74C73v60Ev();
extern void _ZN5S74C73v61Ev();
extern void _ZN5S74C73v62Ev();
extern void _ZN5S74C73v63Ev();
extern void _ZN5S74C73v64Ev();
extern void _ZN5S74C73v65Ev();
extern void _ZN5S74C73v66Ev();
extern void _ZN5S74C73v67Ev();
extern void _ZN8S74C6_nt3v68Ev();
extern void _ZN8S74C6_nt3v69Ev();
extern void _ZN8S74C6_nt3v70Ev();
extern void _ZN8S74C6_nt3v71Ev();
extern void _ZN8S74C6_nt3v72Ev();
extern void _ZN8S74C6_nt3v73Ev();
extern void _ZN8S74C6_nt3v74Ev();
extern void _ZN8S74C6_nt3v75Ev();
extern void _ZN8S74C6_nt3v76Ev();
extern void _ZN8S74C6_nt3v77Ev();
extern void _ZN8S74C6_nt3v78Ev();
extern void _ZN8S74C6_nt3v79Ev();
extern void _ZN8S74C6_nt3v80Ev();
extern void _ZN8S74C6_nt3v81Ev();
extern void _ZN8S74C6_nt3v82Ev();
extern void _ZN8S74C6_nt3v83Ev();
extern void _ZN8S74C6_nt3v84Ev();
extern void _ZN8S74C6_nt3v85Ev();
extern void _ZN8S74C6_nt3v86Ev();
extern void _ZN8S74C6_nt3v87Ev();
extern void _ZN8S74C6_nt3v88Ev();
extern void _ZN8S74C6_nt3v89Ev();
static  VTBL_ENTRY vtc_S74C6_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S74C6_nt[0]),
  (VTBL_ENTRY)&_ZN8S74C6_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S74C6_ntD0Ev,
  (VTBL_ENTRY)&_ZN5S74C72v4Ev,
  (VTBL_ENTRY)&_ZN5S74C72v5Ev,
  (VTBL_ENTRY)&_ZN5S74C72v6Ev,
  (VTBL_ENTRY)&_ZN5S74C72v7Ev,
  (VTBL_ENTRY)&_ZN5S74C72v8Ev,
  (VTBL_ENTRY)&_ZN5S74C72v9Ev,
  (VTBL_ENTRY)&_ZN5S74C73v10Ev,
  (VTBL_ENTRY)&_ZN5S74C73v11Ev,
  (VTBL_ENTRY)&_ZN5S74C73v12Ev,
  (VTBL_ENTRY)&_ZN5S74C73v13Ev,
  (VTBL_ENTRY)&_ZN5S74C73v14Ev,
  (VTBL_ENTRY)&_ZN5S74C73v15Ev,
  (VTBL_ENTRY)&_ZN5S74C73v16Ev,
  (VTBL_ENTRY)&_ZN5S74C73v17Ev,
  (VTBL_ENTRY)&_ZN5S74C73v18Ev,
  (VTBL_ENTRY)&_ZN5S74C73v19Ev,
  (VTBL_ENTRY)&_ZN5S74C73v20Ev,
  (VTBL_ENTRY)&_ZN5S74C73v21Ev,
  (VTBL_ENTRY)&_ZN5S74C73v22Ev,
  (VTBL_ENTRY)&_ZN5S74C73v23Ev,
  (VTBL_ENTRY)&_ZN5S74C73v24Ev,
  (VTBL_ENTRY)&_ZN5S74C73v25Ev,
  (VTBL_ENTRY)&_ZN5S74C73v26Ev,
  (VTBL_ENTRY)&_ZN5S74C73v27Ev,
  (VTBL_ENTRY)&_ZN5S74C73v28Ev,
  (VTBL_ENTRY)&_ZN5S74C73v29Ev,
  (VTBL_ENTRY)&_ZN5S74C73v30Ev,
  (VTBL_ENTRY)&_ZN5S74C73v31Ev,
  (VTBL_ENTRY)&_ZN5S74C73v32Ev,
  (VTBL_ENTRY)&_ZN5S74C73v33Ev,
  (VTBL_ENTRY)&_ZN5S74C73v34Ev,
  (VTBL_ENTRY)&_ZN5S74C73v35Ev,
  (VTBL_ENTRY)&_ZN5S74C73v36Ev,
  (VTBL_ENTRY)&_ZN5S74C73v37Ev,
  (VTBL_ENTRY)&_ZN5S74C73v38Ev,
  (VTBL_ENTRY)&_ZN5S74C73v39Ev,
  (VTBL_ENTRY)&_ZN5S74C73v40Ev,
  (VTBL_ENTRY)&_ZN5S74C73v41Ev,
  (VTBL_ENTRY)&_ZN5S74C73v42Ev,
  (VTBL_ENTRY)&_ZN5S74C73v43Ev,
  (VTBL_ENTRY)&_ZN5S74C73v44Ev,
  (VTBL_ENTRY)&_ZN5S74C73v45Ev,
  (VTBL_ENTRY)&_ZN5S74C73v46Ev,
  (VTBL_ENTRY)&_ZN5S74C73v47Ev,
  (VTBL_ENTRY)&_ZN5S74C73v48Ev,
  (VTBL_ENTRY)&_ZN5S74C73v49Ev,
  (VTBL_ENTRY)&_ZN5S74C73v50Ev,
  (VTBL_ENTRY)&_ZN5S74C73v51Ev,
  (VTBL_ENTRY)&_ZN5S74C73v52Ev,
  (VTBL_ENTRY)&_ZN5S74C73v53Ev,
  (VTBL_ENTRY)&_ZN5S74C73v54Ev,
  (VTBL_ENTRY)&_ZN5S74C73v55Ev,
  (VTBL_ENTRY)&_ZN5S74C73v56Ev,
  (VTBL_ENTRY)&_ZN5S74C73v57Ev,
  (VTBL_ENTRY)&_ZN5S74C73v58Ev,
  (VTBL_ENTRY)&_ZN5S74C73v59Ev,
  (VTBL_ENTRY)&_ZN5S74C73v60Ev,
  (VTBL_ENTRY)&_ZN5S74C73v61Ev,
  (VTBL_ENTRY)&_ZN5S74C73v62Ev,
  (VTBL_ENTRY)&_ZN5S74C73v63Ev,
  (VTBL_ENTRY)&_ZN5S74C73v64Ev,
  (VTBL_ENTRY)&_ZN5S74C73v65Ev,
  (VTBL_ENTRY)&_ZN5S74C73v66Ev,
  (VTBL_ENTRY)&_ZN5S74C73v67Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v89Ev,
};
extern VTBL_ENTRY _ZTI8S74C6_nt[];
VTBL_ENTRY *P__ZTI8S74C6_nt = _ZTI8S74C6_nt; 
extern  VTBL_ENTRY _ZTV8S74C6_nt[];
Class_Descriptor cd_S74C6_nt = {  "S74C6_nt", // class name
  bases_S74C6_nt, 1,
  &(vtc_S74C6_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI8S74C6_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S74C6_nt),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S74C5_nt  : S74C6_nt {
  unsigned int s74c5f0:1;
  unsigned int s74c5f1:1;
  unsigned int s74c5f2:1;
  ::S1409C30 s74c5f3;
  ::S1409C26 s74c5f4;
  ::S1409C22 s74c5f5;
  ::S1409C18 s74c5f6;
  int s74c5f7[3];
  virtual  ~S74C5_nt(); // _ZN8S74C5_ntD1Ev
  virtual void  v90(); // _ZN8S74C5_nt3v90Ev
  virtual void  v91(); // _ZN8S74C5_nt3v91Ev
  virtual void  v92(); // _ZN8S74C5_nt3v92Ev
  virtual void  v93(); // _ZN8S74C5_nt3v93Ev
  virtual void  v94(); // _ZN8S74C5_nt3v94Ev
  virtual void  v95(); // _ZN8S74C5_nt3v95Ev
  virtual void  v96(); // _ZN8S74C5_nt3v96Ev
  virtual void  v97(); // _ZN8S74C5_nt3v97Ev
  virtual void  v98(); // _ZN8S74C5_nt3v98Ev
  virtual void  v99(); // _ZN8S74C5_nt3v99Ev
  virtual void  v100(); // _ZN8S74C5_nt4v100Ev
  virtual void  v101(); // _ZN8S74C5_nt4v101Ev
  virtual void  v102(); // _ZN8S74C5_nt4v102Ev
  virtual void  v103(); // _ZN8S74C5_nt4v103Ev
  virtual void  v104(); // _ZN8S74C5_nt4v104Ev
  virtual void  v105(); // _ZN8S74C5_nt4v105Ev
  virtual void  v106(); // _ZN8S74C5_nt4v106Ev
  virtual void  v107(); // _ZN8S74C5_nt4v107Ev
  virtual void  v108(); // _ZN8S74C5_nt4v108Ev
  virtual void  v109(); // _ZN8S74C5_nt4v109Ev
  S74C5_nt(); // tgen
};
//SIG(-1 S74C5_nt) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} FC16{ BC17{ BC8}} Fi[3]}


 S74C5_nt ::~S74C5_nt(){ note_dtor("S74C5_nt", this);}
void  S74C5_nt ::v90(){vfunc_called(this, "_ZN8S74C5_nt3v90Ev");}
void  S74C5_nt ::v91(){vfunc_called(this, "_ZN8S74C5_nt3v91Ev");}
void  S74C5_nt ::v92(){vfunc_called(this, "_ZN8S74C5_nt3v92Ev");}
void  S74C5_nt ::v93(){vfunc_called(this, "_ZN8S74C5_nt3v93Ev");}
void  S74C5_nt ::v94(){vfunc_called(this, "_ZN8S74C5_nt3v94Ev");}
void  S74C5_nt ::v95(){vfunc_called(this, "_ZN8S74C5_nt3v95Ev");}
void  S74C5_nt ::v96(){vfunc_called(this, "_ZN8S74C5_nt3v96Ev");}
void  S74C5_nt ::v97(){vfunc_called(this, "_ZN8S74C5_nt3v97Ev");}
void  S74C5_nt ::v98(){vfunc_called(this, "_ZN8S74C5_nt3v98Ev");}
void  S74C5_nt ::v99(){vfunc_called(this, "_ZN8S74C5_nt3v99Ev");}
void  S74C5_nt ::v100(){vfunc_called(this, "_ZN8S74C5_nt4v100Ev");}
void  S74C5_nt ::v101(){vfunc_called(this, "_ZN8S74C5_nt4v101Ev");}
void  S74C5_nt ::v102(){vfunc_called(this, "_ZN8S74C5_nt4v102Ev");}
void  S74C5_nt ::v103(){vfunc_called(this, "_ZN8S74C5_nt4v103Ev");}
void  S74C5_nt ::v104(){vfunc_called(this, "_ZN8S74C5_nt4v104Ev");}
void  S74C5_nt ::v105(){vfunc_called(this, "_ZN8S74C5_nt4v105Ev");}
void  S74C5_nt ::v106(){vfunc_called(this, "_ZN8S74C5_nt4v106Ev");}
void  S74C5_nt ::v107(){vfunc_called(this, "_ZN8S74C5_nt4v107Ev");}
void  S74C5_nt ::v108(){vfunc_called(this, "_ZN8S74C5_nt4v108Ev");}
void  S74C5_nt ::v109(){vfunc_called(this, "_ZN8S74C5_nt4v109Ev");}
S74C5_nt ::S74C5_nt(){ note_ctor("S74C5_nt", this);} // tgen

//skip512 S74C5_nt

#else // __cplusplus

extern void _ZN8S74C5_ntC1Ev();
extern void _ZN8S74C5_ntD1Ev();
Name_Map name_map_S74C5_nt[] = {
  NSPAIR(_ZN8S74C5_ntC1Ev),
  NSPAIR(_ZN8S74C5_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S74C7;
extern VTBL_ENTRY _ZTI5S74C7[];
extern  VTBL_ENTRY _ZTV5S74C7[];
extern Class_Descriptor cd_S74C6_nt;
extern VTBL_ENTRY _ZTI8S74C6_nt[];
extern  VTBL_ENTRY _ZTV8S74C6_nt[];
static Base_Class bases_S74C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S74C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S74C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S74C5_nt[];
extern void _ZN8S74C5_ntD1Ev();
extern void _ZN8S74C5_ntD0Ev();
extern void _ZN5S74C72v4Ev();
extern void _ZN5S74C72v5Ev();
extern void _ZN5S74C72v6Ev();
extern void _ZN5S74C72v7Ev();
extern void _ZN5S74C72v8Ev();
extern void _ZN5S74C72v9Ev();
extern void _ZN5S74C73v10Ev();
extern void _ZN5S74C73v11Ev();
extern void _ZN5S74C73v12Ev();
extern void _ZN5S74C73v13Ev();
extern void _ZN5S74C73v14Ev();
extern void _ZN5S74C73v15Ev();
extern void _ZN5S74C73v16Ev();
extern void _ZN5S74C73v17Ev();
extern void _ZN5S74C73v18Ev();
extern void _ZN5S74C73v19Ev();
extern void _ZN5S74C73v20Ev();
extern void _ZN5S74C73v21Ev();
extern void _ZN5S74C73v22Ev();
extern void _ZN5S74C73v23Ev();
extern void _ZN5S74C73v24Ev();
extern void _ZN5S74C73v25Ev();
extern void _ZN5S74C73v26Ev();
extern void _ZN5S74C73v27Ev();
extern void _ZN5S74C73v28Ev();
extern void _ZN5S74C73v29Ev();
extern void _ZN5S74C73v30Ev();
extern void _ZN5S74C73v31Ev();
extern void _ZN5S74C73v32Ev();
extern void _ZN5S74C73v33Ev();
extern void _ZN5S74C73v34Ev();
extern void _ZN5S74C73v35Ev();
extern void _ZN5S74C73v36Ev();
extern void _ZN5S74C73v37Ev();
extern void _ZN5S74C73v38Ev();
extern void _ZN5S74C73v39Ev();
extern void _ZN5S74C73v40Ev();
extern void _ZN5S74C73v41Ev();
extern void _ZN5S74C73v42Ev();
extern void _ZN5S74C73v43Ev();
extern void _ZN5S74C73v44Ev();
extern void _ZN5S74C73v45Ev();
extern void _ZN5S74C73v46Ev();
extern void _ZN5S74C73v47Ev();
extern void _ZN5S74C73v48Ev();
extern void _ZN5S74C73v49Ev();
extern void _ZN5S74C73v50Ev();
extern void _ZN5S74C73v51Ev();
extern void _ZN5S74C73v52Ev();
extern void _ZN5S74C73v53Ev();
extern void _ZN5S74C73v54Ev();
extern void _ZN5S74C73v55Ev();
extern void _ZN5S74C73v56Ev();
extern void _ZN5S74C73v57Ev();
extern void _ZN5S74C73v58Ev();
extern void _ZN5S74C73v59Ev();
extern void _ZN5S74C73v60Ev();
extern void _ZN5S74C73v61Ev();
extern void _ZN5S74C73v62Ev();
extern void _ZN5S74C73v63Ev();
extern void _ZN5S74C73v64Ev();
extern void _ZN5S74C73v65Ev();
extern void _ZN5S74C73v66Ev();
extern void _ZN5S74C73v67Ev();
extern void _ZN8S74C6_nt3v68Ev();
extern void _ZN8S74C6_nt3v69Ev();
extern void _ZN8S74C6_nt3v70Ev();
extern void _ZN8S74C6_nt3v71Ev();
extern void _ZN8S74C6_nt3v72Ev();
extern void _ZN8S74C6_nt3v73Ev();
extern void _ZN8S74C6_nt3v74Ev();
extern void _ZN8S74C6_nt3v75Ev();
extern void _ZN8S74C6_nt3v76Ev();
extern void _ZN8S74C6_nt3v77Ev();
extern void _ZN8S74C6_nt3v78Ev();
extern void _ZN8S74C6_nt3v79Ev();
extern void _ZN8S74C6_nt3v80Ev();
extern void _ZN8S74C6_nt3v81Ev();
extern void _ZN8S74C6_nt3v82Ev();
extern void _ZN8S74C6_nt3v83Ev();
extern void _ZN8S74C6_nt3v84Ev();
extern void _ZN8S74C6_nt3v85Ev();
extern void _ZN8S74C6_nt3v86Ev();
extern void _ZN8S74C6_nt3v87Ev();
extern void _ZN8S74C6_nt3v88Ev();
extern void _ZN8S74C6_nt3v89Ev();
extern void _ZN8S74C5_nt3v90Ev();
extern void _ZN8S74C5_nt3v91Ev();
extern void _ZN8S74C5_nt3v92Ev();
extern void _ZN8S74C5_nt3v93Ev();
extern void _ZN8S74C5_nt3v94Ev();
extern void _ZN8S74C5_nt3v95Ev();
extern void _ZN8S74C5_nt3v96Ev();
extern void _ZN8S74C5_nt3v97Ev();
extern void _ZN8S74C5_nt3v98Ev();
extern void _ZN8S74C5_nt3v99Ev();
extern void _ZN8S74C5_nt4v100Ev();
extern void _ZN8S74C5_nt4v101Ev();
extern void _ZN8S74C5_nt4v102Ev();
extern void _ZN8S74C5_nt4v103Ev();
extern void _ZN8S74C5_nt4v104Ev();
extern void _ZN8S74C5_nt4v105Ev();
extern void _ZN8S74C5_nt4v106Ev();
extern void _ZN8S74C5_nt4v107Ev();
extern void _ZN8S74C5_nt4v108Ev();
extern void _ZN8S74C5_nt4v109Ev();
static  VTBL_ENTRY vtc_S74C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S74C5_nt[0]),
  (VTBL_ENTRY)&_ZN8S74C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S74C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN5S74C72v4Ev,
  (VTBL_ENTRY)&_ZN5S74C72v5Ev,
  (VTBL_ENTRY)&_ZN5S74C72v6Ev,
  (VTBL_ENTRY)&_ZN5S74C72v7Ev,
  (VTBL_ENTRY)&_ZN5S74C72v8Ev,
  (VTBL_ENTRY)&_ZN5S74C72v9Ev,
  (VTBL_ENTRY)&_ZN5S74C73v10Ev,
  (VTBL_ENTRY)&_ZN5S74C73v11Ev,
  (VTBL_ENTRY)&_ZN5S74C73v12Ev,
  (VTBL_ENTRY)&_ZN5S74C73v13Ev,
  (VTBL_ENTRY)&_ZN5S74C73v14Ev,
  (VTBL_ENTRY)&_ZN5S74C73v15Ev,
  (VTBL_ENTRY)&_ZN5S74C73v16Ev,
  (VTBL_ENTRY)&_ZN5S74C73v17Ev,
  (VTBL_ENTRY)&_ZN5S74C73v18Ev,
  (VTBL_ENTRY)&_ZN5S74C73v19Ev,
  (VTBL_ENTRY)&_ZN5S74C73v20Ev,
  (VTBL_ENTRY)&_ZN5S74C73v21Ev,
  (VTBL_ENTRY)&_ZN5S74C73v22Ev,
  (VTBL_ENTRY)&_ZN5S74C73v23Ev,
  (VTBL_ENTRY)&_ZN5S74C73v24Ev,
  (VTBL_ENTRY)&_ZN5S74C73v25Ev,
  (VTBL_ENTRY)&_ZN5S74C73v26Ev,
  (VTBL_ENTRY)&_ZN5S74C73v27Ev,
  (VTBL_ENTRY)&_ZN5S74C73v28Ev,
  (VTBL_ENTRY)&_ZN5S74C73v29Ev,
  (VTBL_ENTRY)&_ZN5S74C73v30Ev,
  (VTBL_ENTRY)&_ZN5S74C73v31Ev,
  (VTBL_ENTRY)&_ZN5S74C73v32Ev,
  (VTBL_ENTRY)&_ZN5S74C73v33Ev,
  (VTBL_ENTRY)&_ZN5S74C73v34Ev,
  (VTBL_ENTRY)&_ZN5S74C73v35Ev,
  (VTBL_ENTRY)&_ZN5S74C73v36Ev,
  (VTBL_ENTRY)&_ZN5S74C73v37Ev,
  (VTBL_ENTRY)&_ZN5S74C73v38Ev,
  (VTBL_ENTRY)&_ZN5S74C73v39Ev,
  (VTBL_ENTRY)&_ZN5S74C73v40Ev,
  (VTBL_ENTRY)&_ZN5S74C73v41Ev,
  (VTBL_ENTRY)&_ZN5S74C73v42Ev,
  (VTBL_ENTRY)&_ZN5S74C73v43Ev,
  (VTBL_ENTRY)&_ZN5S74C73v44Ev,
  (VTBL_ENTRY)&_ZN5S74C73v45Ev,
  (VTBL_ENTRY)&_ZN5S74C73v46Ev,
  (VTBL_ENTRY)&_ZN5S74C73v47Ev,
  (VTBL_ENTRY)&_ZN5S74C73v48Ev,
  (VTBL_ENTRY)&_ZN5S74C73v49Ev,
  (VTBL_ENTRY)&_ZN5S74C73v50Ev,
  (VTBL_ENTRY)&_ZN5S74C73v51Ev,
  (VTBL_ENTRY)&_ZN5S74C73v52Ev,
  (VTBL_ENTRY)&_ZN5S74C73v53Ev,
  (VTBL_ENTRY)&_ZN5S74C73v54Ev,
  (VTBL_ENTRY)&_ZN5S74C73v55Ev,
  (VTBL_ENTRY)&_ZN5S74C73v56Ev,
  (VTBL_ENTRY)&_ZN5S74C73v57Ev,
  (VTBL_ENTRY)&_ZN5S74C73v58Ev,
  (VTBL_ENTRY)&_ZN5S74C73v59Ev,
  (VTBL_ENTRY)&_ZN5S74C73v60Ev,
  (VTBL_ENTRY)&_ZN5S74C73v61Ev,
  (VTBL_ENTRY)&_ZN5S74C73v62Ev,
  (VTBL_ENTRY)&_ZN5S74C73v63Ev,
  (VTBL_ENTRY)&_ZN5S74C73v64Ev,
  (VTBL_ENTRY)&_ZN5S74C73v65Ev,
  (VTBL_ENTRY)&_ZN5S74C73v66Ev,
  (VTBL_ENTRY)&_ZN5S74C73v67Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v109Ev,
};
extern VTBL_ENTRY _ZTI8S74C5_nt[];
VTBL_ENTRY *P__ZTI8S74C5_nt = _ZTI8S74C5_nt; 
extern  VTBL_ENTRY _ZTV8S74C5_nt[];
Class_Descriptor cd_S74C5_nt = {  "S74C5_nt", // class name
  bases_S74C5_nt, 2,
  &(vtc_S74C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI8S74C5_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S74C5_nt),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S74C4_nt  : S74C5_nt {
  ::S1409C5_nt s74c4f0;
  unsigned int s74c4f1:1;
  ::S1409C12 s74c4f2;
  virtual  ~S74C4_nt(); // _ZN8S74C4_ntD1Ev
  virtual void  v110(); // _ZN8S74C4_nt4v110Ev
  virtual void  v111(); // _ZN8S74C4_nt4v111Ev
  virtual void  v112(); // _ZN8S74C4_nt4v112Ev
  virtual void  v113(); // _ZN8S74C4_nt4v113Ev
  S74C4_nt(); // tgen
};
//SIG(-1 S74C4_nt) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} FC17{ BC18{ BC9}} Fi[3]} vd v1 v2 v3 v4 FC5 Fi:1 FC19{ BC20{ BC9}}}


 S74C4_nt ::~S74C4_nt(){ note_dtor("S74C4_nt", this);}
void  S74C4_nt ::v110(){vfunc_called(this, "_ZN8S74C4_nt4v110Ev");}
void  S74C4_nt ::v111(){vfunc_called(this, "_ZN8S74C4_nt4v111Ev");}
void  S74C4_nt ::v112(){vfunc_called(this, "_ZN8S74C4_nt4v112Ev");}
void  S74C4_nt ::v113(){vfunc_called(this, "_ZN8S74C4_nt4v113Ev");}
S74C4_nt ::S74C4_nt(){ note_ctor("S74C4_nt", this);} // tgen

//skip512 S74C4_nt

#else // __cplusplus

extern void _ZN8S74C4_ntC1Ev();
extern void _ZN8S74C4_ntD1Ev();
Name_Map name_map_S74C4_nt[] = {
  NSPAIR(_ZN8S74C4_ntC1Ev),
  NSPAIR(_ZN8S74C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S74C7;
extern VTBL_ENTRY _ZTI5S74C7[];
extern  VTBL_ENTRY _ZTV5S74C7[];
extern Class_Descriptor cd_S74C6_nt;
extern VTBL_ENTRY _ZTI8S74C6_nt[];
extern  VTBL_ENTRY _ZTV8S74C6_nt[];
extern Class_Descriptor cd_S74C5_nt;
extern VTBL_ENTRY _ZTI8S74C5_nt[];
extern  VTBL_ENTRY _ZTV8S74C5_nt[];
static Base_Class bases_S74C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S74C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S74C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S74C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S74C4_nt[];
extern void _ZN8S74C4_ntD1Ev();
extern void _ZN8S74C4_ntD0Ev();
extern void _ZN5S74C72v4Ev();
extern void _ZN5S74C72v5Ev();
extern void _ZN5S74C72v6Ev();
extern void _ZN5S74C72v7Ev();
extern void _ZN5S74C72v8Ev();
extern void _ZN5S74C72v9Ev();
extern void _ZN5S74C73v10Ev();
extern void _ZN5S74C73v11Ev();
extern void _ZN5S74C73v12Ev();
extern void _ZN5S74C73v13Ev();
extern void _ZN5S74C73v14Ev();
extern void _ZN5S74C73v15Ev();
extern void _ZN5S74C73v16Ev();
extern void _ZN5S74C73v17Ev();
extern void _ZN5S74C73v18Ev();
extern void _ZN5S74C73v19Ev();
extern void _ZN5S74C73v20Ev();
extern void _ZN5S74C73v21Ev();
extern void _ZN5S74C73v22Ev();
extern void _ZN5S74C73v23Ev();
extern void _ZN5S74C73v24Ev();
extern void _ZN5S74C73v25Ev();
extern void _ZN5S74C73v26Ev();
extern void _ZN5S74C73v27Ev();
extern void _ZN5S74C73v28Ev();
extern void _ZN5S74C73v29Ev();
extern void _ZN5S74C73v30Ev();
extern void _ZN5S74C73v31Ev();
extern void _ZN5S74C73v32Ev();
extern void _ZN5S74C73v33Ev();
extern void _ZN5S74C73v34Ev();
extern void _ZN5S74C73v35Ev();
extern void _ZN5S74C73v36Ev();
extern void _ZN5S74C73v37Ev();
extern void _ZN5S74C73v38Ev();
extern void _ZN5S74C73v39Ev();
extern void _ZN5S74C73v40Ev();
extern void _ZN5S74C73v41Ev();
extern void _ZN5S74C73v42Ev();
extern void _ZN5S74C73v43Ev();
extern void _ZN5S74C73v44Ev();
extern void _ZN5S74C73v45Ev();
extern void _ZN5S74C73v46Ev();
extern void _ZN5S74C73v47Ev();
extern void _ZN5S74C73v48Ev();
extern void _ZN5S74C73v49Ev();
extern void _ZN5S74C73v50Ev();
extern void _ZN5S74C73v51Ev();
extern void _ZN5S74C73v52Ev();
extern void _ZN5S74C73v53Ev();
extern void _ZN5S74C73v54Ev();
extern void _ZN5S74C73v55Ev();
extern void _ZN5S74C73v56Ev();
extern void _ZN5S74C73v57Ev();
extern void _ZN5S74C73v58Ev();
extern void _ZN5S74C73v59Ev();
extern void _ZN5S74C73v60Ev();
extern void _ZN5S74C73v61Ev();
extern void _ZN5S74C73v62Ev();
extern void _ZN5S74C73v63Ev();
extern void _ZN5S74C73v64Ev();
extern void _ZN5S74C73v65Ev();
extern void _ZN5S74C73v66Ev();
extern void _ZN5S74C73v67Ev();
extern void _ZN8S74C6_nt3v68Ev();
extern void _ZN8S74C6_nt3v69Ev();
extern void _ZN8S74C6_nt3v70Ev();
extern void _ZN8S74C6_nt3v71Ev();
extern void _ZN8S74C6_nt3v72Ev();
extern void _ZN8S74C6_nt3v73Ev();
extern void _ZN8S74C6_nt3v74Ev();
extern void _ZN8S74C6_nt3v75Ev();
extern void _ZN8S74C6_nt3v76Ev();
extern void _ZN8S74C6_nt3v77Ev();
extern void _ZN8S74C6_nt3v78Ev();
extern void _ZN8S74C6_nt3v79Ev();
extern void _ZN8S74C6_nt3v80Ev();
extern void _ZN8S74C6_nt3v81Ev();
extern void _ZN8S74C6_nt3v82Ev();
extern void _ZN8S74C6_nt3v83Ev();
extern void _ZN8S74C6_nt3v84Ev();
extern void _ZN8S74C6_nt3v85Ev();
extern void _ZN8S74C6_nt3v86Ev();
extern void _ZN8S74C6_nt3v87Ev();
extern void _ZN8S74C6_nt3v88Ev();
extern void _ZN8S74C6_nt3v89Ev();
extern void _ZN8S74C5_nt3v90Ev();
extern void _ZN8S74C5_nt3v91Ev();
extern void _ZN8S74C5_nt3v92Ev();
extern void _ZN8S74C5_nt3v93Ev();
extern void _ZN8S74C5_nt3v94Ev();
extern void _ZN8S74C5_nt3v95Ev();
extern void _ZN8S74C5_nt3v96Ev();
extern void _ZN8S74C5_nt3v97Ev();
extern void _ZN8S74C5_nt3v98Ev();
extern void _ZN8S74C5_nt3v99Ev();
extern void _ZN8S74C5_nt4v100Ev();
extern void _ZN8S74C5_nt4v101Ev();
extern void _ZN8S74C5_nt4v102Ev();
extern void _ZN8S74C5_nt4v103Ev();
extern void _ZN8S74C5_nt4v104Ev();
extern void _ZN8S74C5_nt4v105Ev();
extern void _ZN8S74C5_nt4v106Ev();
extern void _ZN8S74C5_nt4v107Ev();
extern void _ZN8S74C5_nt4v108Ev();
extern void _ZN8S74C5_nt4v109Ev();
extern void _ZN8S74C4_nt4v110Ev();
extern void _ZN8S74C4_nt4v111Ev();
extern void _ZN8S74C4_nt4v112Ev();
extern void _ZN8S74C4_nt4v113Ev();
static  VTBL_ENTRY vtc_S74C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S74C4_nt[0]),
  (VTBL_ENTRY)&_ZN8S74C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S74C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN5S74C72v4Ev,
  (VTBL_ENTRY)&_ZN5S74C72v5Ev,
  (VTBL_ENTRY)&_ZN5S74C72v6Ev,
  (VTBL_ENTRY)&_ZN5S74C72v7Ev,
  (VTBL_ENTRY)&_ZN5S74C72v8Ev,
  (VTBL_ENTRY)&_ZN5S74C72v9Ev,
  (VTBL_ENTRY)&_ZN5S74C73v10Ev,
  (VTBL_ENTRY)&_ZN5S74C73v11Ev,
  (VTBL_ENTRY)&_ZN5S74C73v12Ev,
  (VTBL_ENTRY)&_ZN5S74C73v13Ev,
  (VTBL_ENTRY)&_ZN5S74C73v14Ev,
  (VTBL_ENTRY)&_ZN5S74C73v15Ev,
  (VTBL_ENTRY)&_ZN5S74C73v16Ev,
  (VTBL_ENTRY)&_ZN5S74C73v17Ev,
  (VTBL_ENTRY)&_ZN5S74C73v18Ev,
  (VTBL_ENTRY)&_ZN5S74C73v19Ev,
  (VTBL_ENTRY)&_ZN5S74C73v20Ev,
  (VTBL_ENTRY)&_ZN5S74C73v21Ev,
  (VTBL_ENTRY)&_ZN5S74C73v22Ev,
  (VTBL_ENTRY)&_ZN5S74C73v23Ev,
  (VTBL_ENTRY)&_ZN5S74C73v24Ev,
  (VTBL_ENTRY)&_ZN5S74C73v25Ev,
  (VTBL_ENTRY)&_ZN5S74C73v26Ev,
  (VTBL_ENTRY)&_ZN5S74C73v27Ev,
  (VTBL_ENTRY)&_ZN5S74C73v28Ev,
  (VTBL_ENTRY)&_ZN5S74C73v29Ev,
  (VTBL_ENTRY)&_ZN5S74C73v30Ev,
  (VTBL_ENTRY)&_ZN5S74C73v31Ev,
  (VTBL_ENTRY)&_ZN5S74C73v32Ev,
  (VTBL_ENTRY)&_ZN5S74C73v33Ev,
  (VTBL_ENTRY)&_ZN5S74C73v34Ev,
  (VTBL_ENTRY)&_ZN5S74C73v35Ev,
  (VTBL_ENTRY)&_ZN5S74C73v36Ev,
  (VTBL_ENTRY)&_ZN5S74C73v37Ev,
  (VTBL_ENTRY)&_ZN5S74C73v38Ev,
  (VTBL_ENTRY)&_ZN5S74C73v39Ev,
  (VTBL_ENTRY)&_ZN5S74C73v40Ev,
  (VTBL_ENTRY)&_ZN5S74C73v41Ev,
  (VTBL_ENTRY)&_ZN5S74C73v42Ev,
  (VTBL_ENTRY)&_ZN5S74C73v43Ev,
  (VTBL_ENTRY)&_ZN5S74C73v44Ev,
  (VTBL_ENTRY)&_ZN5S74C73v45Ev,
  (VTBL_ENTRY)&_ZN5S74C73v46Ev,
  (VTBL_ENTRY)&_ZN5S74C73v47Ev,
  (VTBL_ENTRY)&_ZN5S74C73v48Ev,
  (VTBL_ENTRY)&_ZN5S74C73v49Ev,
  (VTBL_ENTRY)&_ZN5S74C73v50Ev,
  (VTBL_ENTRY)&_ZN5S74C73v51Ev,
  (VTBL_ENTRY)&_ZN5S74C73v52Ev,
  (VTBL_ENTRY)&_ZN5S74C73v53Ev,
  (VTBL_ENTRY)&_ZN5S74C73v54Ev,
  (VTBL_ENTRY)&_ZN5S74C73v55Ev,
  (VTBL_ENTRY)&_ZN5S74C73v56Ev,
  (VTBL_ENTRY)&_ZN5S74C73v57Ev,
  (VTBL_ENTRY)&_ZN5S74C73v58Ev,
  (VTBL_ENTRY)&_ZN5S74C73v59Ev,
  (VTBL_ENTRY)&_ZN5S74C73v60Ev,
  (VTBL_ENTRY)&_ZN5S74C73v61Ev,
  (VTBL_ENTRY)&_ZN5S74C73v62Ev,
  (VTBL_ENTRY)&_ZN5S74C73v63Ev,
  (VTBL_ENTRY)&_ZN5S74C73v64Ev,
  (VTBL_ENTRY)&_ZN5S74C73v65Ev,
  (VTBL_ENTRY)&_ZN5S74C73v66Ev,
  (VTBL_ENTRY)&_ZN5S74C73v67Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S74C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S74C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S74C4_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S74C4_nt4v113Ev,
};
extern VTBL_ENTRY _ZTI8S74C4_nt[];
VTBL_ENTRY *P__ZTI8S74C4_nt = _ZTI8S74C4_nt; 
extern  VTBL_ENTRY _ZTV8S74C4_nt[];
Class_Descriptor cd_S74C4_nt = {  "S74C4_nt", // class name
  bases_S74C4_nt, 3,
  &(vtc_S74C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,220), // object size
  NSPAIRA(_ZTI8S74C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S74C4_nt),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S74C3_nt  : S74C4_nt {
  int s74c3f0;
  unsigned int s74c3f1:1;
  virtual  ~S74C3_nt(); // _ZN8S74C3_ntD1Ev
  virtual void  v114(); // _ZN8S74C3_nt4v114Ev
  virtual void  v115(); // _ZN8S74C3_nt4v115Ev
  virtual void  v116(); // _ZN8S74C3_nt4v116Ev
  virtual void  v117(); // _ZN8S74C3_nt4v117Ev
  virtual void  v118(); // _ZN8S74C3_nt4v118Ev
  virtual void  v119(); // _ZN8S74C3_nt4v119Ev
  virtual void  v120(); // _ZN8S74C3_nt4v120Ev
  virtual void  v121(); // _ZN8S74C3_nt4v121Ev
  S74C3_nt(); // tgen
};
//SIG(-1 S74C3_nt) C1{ BC2{ BC3{ BC4{ BC5{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} FC18{ BC19{ BC10}} Fi[3]} vd v115 v116 v117 v118 FC6 Fi:1 FC20{ BC21{ BC10}}} vd v1 v2 v3 v4 v5 v6 v7 v8 Fi Fi:1}


 S74C3_nt ::~S74C3_nt(){ note_dtor("S74C3_nt", this);}
void  S74C3_nt ::v114(){vfunc_called(this, "_ZN8S74C3_nt4v114Ev");}
void  S74C3_nt ::v115(){vfunc_called(this, "_ZN8S74C3_nt4v115Ev");}
void  S74C3_nt ::v116(){vfunc_called(this, "_ZN8S74C3_nt4v116Ev");}
void  S74C3_nt ::v117(){vfunc_called(this, "_ZN8S74C3_nt4v117Ev");}
void  S74C3_nt ::v118(){vfunc_called(this, "_ZN8S74C3_nt4v118Ev");}
void  S74C3_nt ::v119(){vfunc_called(this, "_ZN8S74C3_nt4v119Ev");}
void  S74C3_nt ::v120(){vfunc_called(this, "_ZN8S74C3_nt4v120Ev");}
void  S74C3_nt ::v121(){vfunc_called(this, "_ZN8S74C3_nt4v121Ev");}
S74C3_nt ::S74C3_nt(){ note_ctor("S74C3_nt", this);} // tgen

//skip512 S74C3_nt

#else // __cplusplus

extern void _ZN8S74C3_ntC1Ev();
extern void _ZN8S74C3_ntD1Ev();
Name_Map name_map_S74C3_nt[] = {
  NSPAIR(_ZN8S74C3_ntC1Ev),
  NSPAIR(_ZN8S74C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S74C7;
extern VTBL_ENTRY _ZTI5S74C7[];
extern  VTBL_ENTRY _ZTV5S74C7[];
extern Class_Descriptor cd_S74C6_nt;
extern VTBL_ENTRY _ZTI8S74C6_nt[];
extern  VTBL_ENTRY _ZTV8S74C6_nt[];
extern Class_Descriptor cd_S74C5_nt;
extern VTBL_ENTRY _ZTI8S74C5_nt[];
extern  VTBL_ENTRY _ZTV8S74C5_nt[];
extern Class_Descriptor cd_S74C4_nt;
extern VTBL_ENTRY _ZTI8S74C4_nt[];
extern  VTBL_ENTRY _ZTV8S74C4_nt[];
static Base_Class bases_S74C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S74C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S74C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S74C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S74C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S74C3_nt[];
extern void _ZN8S74C3_ntD1Ev();
extern void _ZN8S74C3_ntD0Ev();
extern void _ZN5S74C72v4Ev();
extern void _ZN5S74C72v5Ev();
extern void _ZN5S74C72v6Ev();
extern void _ZN5S74C72v7Ev();
extern void _ZN5S74C72v8Ev();
extern void _ZN5S74C72v9Ev();
extern void _ZN5S74C73v10Ev();
extern void _ZN5S74C73v11Ev();
extern void _ZN5S74C73v12Ev();
extern void _ZN5S74C73v13Ev();
extern void _ZN5S74C73v14Ev();
extern void _ZN5S74C73v15Ev();
extern void _ZN5S74C73v16Ev();
extern void _ZN5S74C73v17Ev();
extern void _ZN5S74C73v18Ev();
extern void _ZN5S74C73v19Ev();
extern void _ZN5S74C73v20Ev();
extern void _ZN5S74C73v21Ev();
extern void _ZN5S74C73v22Ev();
extern void _ZN5S74C73v23Ev();
extern void _ZN5S74C73v24Ev();
extern void _ZN5S74C73v25Ev();
extern void _ZN5S74C73v26Ev();
extern void _ZN5S74C73v27Ev();
extern void _ZN5S74C73v28Ev();
extern void _ZN5S74C73v29Ev();
extern void _ZN5S74C73v30Ev();
extern void _ZN5S74C73v31Ev();
extern void _ZN5S74C73v32Ev();
extern void _ZN5S74C73v33Ev();
extern void _ZN5S74C73v34Ev();
extern void _ZN5S74C73v35Ev();
extern void _ZN5S74C73v36Ev();
extern void _ZN5S74C73v37Ev();
extern void _ZN5S74C73v38Ev();
extern void _ZN5S74C73v39Ev();
extern void _ZN5S74C73v40Ev();
extern void _ZN5S74C73v41Ev();
extern void _ZN5S74C73v42Ev();
extern void _ZN5S74C73v43Ev();
extern void _ZN5S74C73v44Ev();
extern void _ZN5S74C73v45Ev();
extern void _ZN5S74C73v46Ev();
extern void _ZN5S74C73v47Ev();
extern void _ZN5S74C73v48Ev();
extern void _ZN5S74C73v49Ev();
extern void _ZN5S74C73v50Ev();
extern void _ZN5S74C73v51Ev();
extern void _ZN5S74C73v52Ev();
extern void _ZN5S74C73v53Ev();
extern void _ZN5S74C73v54Ev();
extern void _ZN5S74C73v55Ev();
extern void _ZN5S74C73v56Ev();
extern void _ZN5S74C73v57Ev();
extern void _ZN5S74C73v58Ev();
extern void _ZN5S74C73v59Ev();
extern void _ZN5S74C73v60Ev();
extern void _ZN5S74C73v61Ev();
extern void _ZN5S74C73v62Ev();
extern void _ZN5S74C73v63Ev();
extern void _ZN5S74C73v64Ev();
extern void _ZN5S74C73v65Ev();
extern void _ZN5S74C73v66Ev();
extern void _ZN5S74C73v67Ev();
extern void _ZN8S74C6_nt3v68Ev();
extern void _ZN8S74C6_nt3v69Ev();
extern void _ZN8S74C6_nt3v70Ev();
extern void _ZN8S74C6_nt3v71Ev();
extern void _ZN8S74C6_nt3v72Ev();
extern void _ZN8S74C6_nt3v73Ev();
extern void _ZN8S74C6_nt3v74Ev();
extern void _ZN8S74C6_nt3v75Ev();
extern void _ZN8S74C6_nt3v76Ev();
extern void _ZN8S74C6_nt3v77Ev();
extern void _ZN8S74C6_nt3v78Ev();
extern void _ZN8S74C6_nt3v79Ev();
extern void _ZN8S74C6_nt3v80Ev();
extern void _ZN8S74C6_nt3v81Ev();
extern void _ZN8S74C6_nt3v82Ev();
extern void _ZN8S74C6_nt3v83Ev();
extern void _ZN8S74C6_nt3v84Ev();
extern void _ZN8S74C6_nt3v85Ev();
extern void _ZN8S74C6_nt3v86Ev();
extern void _ZN8S74C6_nt3v87Ev();
extern void _ZN8S74C6_nt3v88Ev();
extern void _ZN8S74C6_nt3v89Ev();
extern void _ZN8S74C5_nt3v90Ev();
extern void _ZN8S74C5_nt3v91Ev();
extern void _ZN8S74C5_nt3v92Ev();
extern void _ZN8S74C5_nt3v93Ev();
extern void _ZN8S74C5_nt3v94Ev();
extern void _ZN8S74C5_nt3v95Ev();
extern void _ZN8S74C5_nt3v96Ev();
extern void _ZN8S74C5_nt3v97Ev();
extern void _ZN8S74C5_nt3v98Ev();
extern void _ZN8S74C5_nt3v99Ev();
extern void _ZN8S74C5_nt4v100Ev();
extern void _ZN8S74C5_nt4v101Ev();
extern void _ZN8S74C5_nt4v102Ev();
extern void _ZN8S74C5_nt4v103Ev();
extern void _ZN8S74C5_nt4v104Ev();
extern void _ZN8S74C5_nt4v105Ev();
extern void _ZN8S74C5_nt4v106Ev();
extern void _ZN8S74C5_nt4v107Ev();
extern void _ZN8S74C5_nt4v108Ev();
extern void _ZN8S74C5_nt4v109Ev();
extern void _ZN8S74C4_nt4v110Ev();
extern void _ZN8S74C4_nt4v111Ev();
extern void _ZN8S74C4_nt4v112Ev();
extern void _ZN8S74C4_nt4v113Ev();
extern void _ZN8S74C3_nt4v114Ev();
extern void _ZN8S74C3_nt4v115Ev();
extern void _ZN8S74C3_nt4v116Ev();
extern void _ZN8S74C3_nt4v117Ev();
extern void _ZN8S74C3_nt4v118Ev();
extern void _ZN8S74C3_nt4v119Ev();
extern void _ZN8S74C3_nt4v120Ev();
extern void _ZN8S74C3_nt4v121Ev();
static  VTBL_ENTRY vtc_S74C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S74C3_nt[0]),
  (VTBL_ENTRY)&_ZN8S74C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S74C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN5S74C72v4Ev,
  (VTBL_ENTRY)&_ZN5S74C72v5Ev,
  (VTBL_ENTRY)&_ZN5S74C72v6Ev,
  (VTBL_ENTRY)&_ZN5S74C72v7Ev,
  (VTBL_ENTRY)&_ZN5S74C72v8Ev,
  (VTBL_ENTRY)&_ZN5S74C72v9Ev,
  (VTBL_ENTRY)&_ZN5S74C73v10Ev,
  (VTBL_ENTRY)&_ZN5S74C73v11Ev,
  (VTBL_ENTRY)&_ZN5S74C73v12Ev,
  (VTBL_ENTRY)&_ZN5S74C73v13Ev,
  (VTBL_ENTRY)&_ZN5S74C73v14Ev,
  (VTBL_ENTRY)&_ZN5S74C73v15Ev,
  (VTBL_ENTRY)&_ZN5S74C73v16Ev,
  (VTBL_ENTRY)&_ZN5S74C73v17Ev,
  (VTBL_ENTRY)&_ZN5S74C73v18Ev,
  (VTBL_ENTRY)&_ZN5S74C73v19Ev,
  (VTBL_ENTRY)&_ZN5S74C73v20Ev,
  (VTBL_ENTRY)&_ZN5S74C73v21Ev,
  (VTBL_ENTRY)&_ZN5S74C73v22Ev,
  (VTBL_ENTRY)&_ZN5S74C73v23Ev,
  (VTBL_ENTRY)&_ZN5S74C73v24Ev,
  (VTBL_ENTRY)&_ZN5S74C73v25Ev,
  (VTBL_ENTRY)&_ZN5S74C73v26Ev,
  (VTBL_ENTRY)&_ZN5S74C73v27Ev,
  (VTBL_ENTRY)&_ZN5S74C73v28Ev,
  (VTBL_ENTRY)&_ZN5S74C73v29Ev,
  (VTBL_ENTRY)&_ZN5S74C73v30Ev,
  (VTBL_ENTRY)&_ZN5S74C73v31Ev,
  (VTBL_ENTRY)&_ZN5S74C73v32Ev,
  (VTBL_ENTRY)&_ZN5S74C73v33Ev,
  (VTBL_ENTRY)&_ZN5S74C73v34Ev,
  (VTBL_ENTRY)&_ZN5S74C73v35Ev,
  (VTBL_ENTRY)&_ZN5S74C73v36Ev,
  (VTBL_ENTRY)&_ZN5S74C73v37Ev,
  (VTBL_ENTRY)&_ZN5S74C73v38Ev,
  (VTBL_ENTRY)&_ZN5S74C73v39Ev,
  (VTBL_ENTRY)&_ZN5S74C73v40Ev,
  (VTBL_ENTRY)&_ZN5S74C73v41Ev,
  (VTBL_ENTRY)&_ZN5S74C73v42Ev,
  (VTBL_ENTRY)&_ZN5S74C73v43Ev,
  (VTBL_ENTRY)&_ZN5S74C73v44Ev,
  (VTBL_ENTRY)&_ZN5S74C73v45Ev,
  (VTBL_ENTRY)&_ZN5S74C73v46Ev,
  (VTBL_ENTRY)&_ZN5S74C73v47Ev,
  (VTBL_ENTRY)&_ZN5S74C73v48Ev,
  (VTBL_ENTRY)&_ZN5S74C73v49Ev,
  (VTBL_ENTRY)&_ZN5S74C73v50Ev,
  (VTBL_ENTRY)&_ZN5S74C73v51Ev,
  (VTBL_ENTRY)&_ZN5S74C73v52Ev,
  (VTBL_ENTRY)&_ZN5S74C73v53Ev,
  (VTBL_ENTRY)&_ZN5S74C73v54Ev,
  (VTBL_ENTRY)&_ZN5S74C73v55Ev,
  (VTBL_ENTRY)&_ZN5S74C73v56Ev,
  (VTBL_ENTRY)&_ZN5S74C73v57Ev,
  (VTBL_ENTRY)&_ZN5S74C73v58Ev,
  (VTBL_ENTRY)&_ZN5S74C73v59Ev,
  (VTBL_ENTRY)&_ZN5S74C73v60Ev,
  (VTBL_ENTRY)&_ZN5S74C73v61Ev,
  (VTBL_ENTRY)&_ZN5S74C73v62Ev,
  (VTBL_ENTRY)&_ZN5S74C73v63Ev,
  (VTBL_ENTRY)&_ZN5S74C73v64Ev,
  (VTBL_ENTRY)&_ZN5S74C73v65Ev,
  (VTBL_ENTRY)&_ZN5S74C73v66Ev,
  (VTBL_ENTRY)&_ZN5S74C73v67Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S74C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S74C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S74C4_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S74C4_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S74C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S74C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S74C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S74C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S74C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S74C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S74C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S74C3_nt4v121Ev,
};
extern VTBL_ENTRY _ZTI8S74C3_nt[];
VTBL_ENTRY *P__ZTI8S74C3_nt = _ZTI8S74C3_nt; 
extern  VTBL_ENTRY _ZTV8S74C3_nt[];
Class_Descriptor cd_S74C3_nt = {  "S74C3_nt", // class name
  bases_S74C3_nt, 4,
  &(vtc_S74C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,228), // object size
  NSPAIRA(_ZTI8S74C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S74C3_nt),122, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S74C2  : S74C3_nt {
  void *s74c2f0[2];
  unsigned int s74c2f1:1;
  virtual  ~S74C2(); // _ZN5S74C2D1Ev
  virtual void  v122(); // _ZN5S74C24v122Ev
  virtual void  v123(); // _ZN5S74C24v123Ev
  S74C2(); // tgen
};
//SIG(-1 S74C2) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi[2] Fp Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 FC12{ m} FC8 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 Fi:1 Fi:1 Fi:1 FC13{ BC14{ BC11}} FC15{ BC16{ BC11}} FC17{ BC18{ BC11}} FC19{ BC20{ BC11}} Fi[3]} vd v109 v110 v111 v112 FC7 Fi:1 FC21{ BC22{ BC11}}} vd v113 v114 v115 v116 v117 v118 v119 v120 Fi Fi:1} vd v1 v2 Fp[2] Fi:1}


 S74C2 ::~S74C2(){ note_dtor("S74C2", this);}
void  S74C2 ::v122(){vfunc_called(this, "_ZN5S74C24v122Ev");}
void  S74C2 ::v123(){vfunc_called(this, "_ZN5S74C24v123Ev");}
S74C2 ::S74C2(){ note_ctor("S74C2", this);} // tgen

static void Test_S74C2()
{
  extern Class_Descriptor cd_S74C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(42,61)];
    init_test(&cd_S74C2, buf);
    S74C2 *dp, &lv = *(dp=new (buf) S74C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(328,240), "sizeof(S74C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S74C2)");
    check_base_class_offset(lv, (S74C7*)(S74C6_nt*)(S74C5_nt*)(S74C4_nt*)(S74C3_nt*), 0, "S74C2");
    check_base_class_offset(lv, (S74C6_nt*)(S74C5_nt*)(S74C4_nt*)(S74C3_nt*), 0, "S74C2");
    check_base_class_offset(lv, (S74C5_nt*)(S74C4_nt*)(S74C3_nt*), 0, "S74C2");
    check_base_class_offset(lv, (S74C4_nt*)(S74C3_nt*), 0, "S74C2");
    check_base_class_offset(lv, (S74C3_nt*), 0, "S74C2");
    check_field_offset(lv, s74c2f0, ABISELECT(304,228), "S74C2.s74c2f0");
    set_bf_and_test(lv, s74c2f1, ABISELECT(320,236), 0, 1, 1, "S74C2");
    test_class_info(&lv, &cd_S74C2);
    dp->~S74C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS74C2(Test_S74C2, "S74C2", ABISELECT(328,240));

#else // __cplusplus

extern void _ZN5S74C2C1Ev();
extern void _ZN5S74C2D1Ev();
Name_Map name_map_S74C2[] = {
  NSPAIR(_ZN5S74C2C1Ev),
  NSPAIR(_ZN5S74C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S74C7;
extern VTBL_ENTRY _ZTI5S74C7[];
extern  VTBL_ENTRY _ZTV5S74C7[];
extern Class_Descriptor cd_S74C6_nt;
extern VTBL_ENTRY _ZTI8S74C6_nt[];
extern  VTBL_ENTRY _ZTV8S74C6_nt[];
extern Class_Descriptor cd_S74C5_nt;
extern VTBL_ENTRY _ZTI8S74C5_nt[];
extern  VTBL_ENTRY _ZTV8S74C5_nt[];
extern Class_Descriptor cd_S74C4_nt;
extern VTBL_ENTRY _ZTI8S74C4_nt[];
extern  VTBL_ENTRY _ZTV8S74C4_nt[];
extern Class_Descriptor cd_S74C3_nt;
extern VTBL_ENTRY _ZTI8S74C3_nt[];
extern  VTBL_ENTRY _ZTV8S74C3_nt[];
static Base_Class bases_S74C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S74C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S74C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S74C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S74C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S74C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S74C2[];
extern void _ZN5S74C2D1Ev();
extern void _ZN5S74C2D0Ev();
extern void _ZN5S74C72v4Ev();
extern void _ZN5S74C72v5Ev();
extern void _ZN5S74C72v6Ev();
extern void _ZN5S74C72v7Ev();
extern void _ZN5S74C72v8Ev();
extern void _ZN5S74C72v9Ev();
extern void _ZN5S74C73v10Ev();
extern void _ZN5S74C73v11Ev();
extern void _ZN5S74C73v12Ev();
extern void _ZN5S74C73v13Ev();
extern void _ZN5S74C73v14Ev();
extern void _ZN5S74C73v15Ev();
extern void _ZN5S74C73v16Ev();
extern void _ZN5S74C73v17Ev();
extern void _ZN5S74C73v18Ev();
extern void _ZN5S74C73v19Ev();
extern void _ZN5S74C73v20Ev();
extern void _ZN5S74C73v21Ev();
extern void _ZN5S74C73v22Ev();
extern void _ZN5S74C73v23Ev();
extern void _ZN5S74C73v24Ev();
extern void _ZN5S74C73v25Ev();
extern void _ZN5S74C73v26Ev();
extern void _ZN5S74C73v27Ev();
extern void _ZN5S74C73v28Ev();
extern void _ZN5S74C73v29Ev();
extern void _ZN5S74C73v30Ev();
extern void _ZN5S74C73v31Ev();
extern void _ZN5S74C73v32Ev();
extern void _ZN5S74C73v33Ev();
extern void _ZN5S74C73v34Ev();
extern void _ZN5S74C73v35Ev();
extern void _ZN5S74C73v36Ev();
extern void _ZN5S74C73v37Ev();
extern void _ZN5S74C73v38Ev();
extern void _ZN5S74C73v39Ev();
extern void _ZN5S74C73v40Ev();
extern void _ZN5S74C73v41Ev();
extern void _ZN5S74C73v42Ev();
extern void _ZN5S74C73v43Ev();
extern void _ZN5S74C73v44Ev();
extern void _ZN5S74C73v45Ev();
extern void _ZN5S74C73v46Ev();
extern void _ZN5S74C73v47Ev();
extern void _ZN5S74C73v48Ev();
extern void _ZN5S74C73v49Ev();
extern void _ZN5S74C73v50Ev();
extern void _ZN5S74C73v51Ev();
extern void _ZN5S74C73v52Ev();
extern void _ZN5S74C73v53Ev();
extern void _ZN5S74C73v54Ev();
extern void _ZN5S74C73v55Ev();
extern void _ZN5S74C73v56Ev();
extern void _ZN5S74C73v57Ev();
extern void _ZN5S74C73v58Ev();
extern void _ZN5S74C73v59Ev();
extern void _ZN5S74C73v60Ev();
extern void _ZN5S74C73v61Ev();
extern void _ZN5S74C73v62Ev();
extern void _ZN5S74C73v63Ev();
extern void _ZN5S74C73v64Ev();
extern void _ZN5S74C73v65Ev();
extern void _ZN5S74C73v66Ev();
extern void _ZN5S74C73v67Ev();
extern void _ZN8S74C6_nt3v68Ev();
extern void _ZN8S74C6_nt3v69Ev();
extern void _ZN8S74C6_nt3v70Ev();
extern void _ZN8S74C6_nt3v71Ev();
extern void _ZN8S74C6_nt3v72Ev();
extern void _ZN8S74C6_nt3v73Ev();
extern void _ZN8S74C6_nt3v74Ev();
extern void _ZN8S74C6_nt3v75Ev();
extern void _ZN8S74C6_nt3v76Ev();
extern void _ZN8S74C6_nt3v77Ev();
extern void _ZN8S74C6_nt3v78Ev();
extern void _ZN8S74C6_nt3v79Ev();
extern void _ZN8S74C6_nt3v80Ev();
extern void _ZN8S74C6_nt3v81Ev();
extern void _ZN8S74C6_nt3v82Ev();
extern void _ZN8S74C6_nt3v83Ev();
extern void _ZN8S74C6_nt3v84Ev();
extern void _ZN8S74C6_nt3v85Ev();
extern void _ZN8S74C6_nt3v86Ev();
extern void _ZN8S74C6_nt3v87Ev();
extern void _ZN8S74C6_nt3v88Ev();
extern void _ZN8S74C6_nt3v89Ev();
extern void _ZN8S74C5_nt3v90Ev();
extern void _ZN8S74C5_nt3v91Ev();
extern void _ZN8S74C5_nt3v92Ev();
extern void _ZN8S74C5_nt3v93Ev();
extern void _ZN8S74C5_nt3v94Ev();
extern void _ZN8S74C5_nt3v95Ev();
extern void _ZN8S74C5_nt3v96Ev();
extern void _ZN8S74C5_nt3v97Ev();
extern void _ZN8S74C5_nt3v98Ev();
extern void _ZN8S74C5_nt3v99Ev();
extern void _ZN8S74C5_nt4v100Ev();
extern void _ZN8S74C5_nt4v101Ev();
extern void _ZN8S74C5_nt4v102Ev();
extern void _ZN8S74C5_nt4v103Ev();
extern void _ZN8S74C5_nt4v104Ev();
extern void _ZN8S74C5_nt4v105Ev();
extern void _ZN8S74C5_nt4v106Ev();
extern void _ZN8S74C5_nt4v107Ev();
extern void _ZN8S74C5_nt4v108Ev();
extern void _ZN8S74C5_nt4v109Ev();
extern void _ZN8S74C4_nt4v110Ev();
extern void _ZN8S74C4_nt4v111Ev();
extern void _ZN8S74C4_nt4v112Ev();
extern void _ZN8S74C4_nt4v113Ev();
extern void _ZN8S74C3_nt4v114Ev();
extern void _ZN8S74C3_nt4v115Ev();
extern void _ZN8S74C3_nt4v116Ev();
extern void _ZN8S74C3_nt4v117Ev();
extern void _ZN8S74C3_nt4v118Ev();
extern void _ZN8S74C3_nt4v119Ev();
extern void _ZN8S74C3_nt4v120Ev();
extern void _ZN8S74C3_nt4v121Ev();
extern void _ZN5S74C24v122Ev();
extern void _ZN5S74C24v123Ev();
static  VTBL_ENTRY vtc_S74C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S74C2[0]),
  (VTBL_ENTRY)&_ZN5S74C2D1Ev,
  (VTBL_ENTRY)&_ZN5S74C2D0Ev,
  (VTBL_ENTRY)&_ZN5S74C72v4Ev,
  (VTBL_ENTRY)&_ZN5S74C72v5Ev,
  (VTBL_ENTRY)&_ZN5S74C72v6Ev,
  (VTBL_ENTRY)&_ZN5S74C72v7Ev,
  (VTBL_ENTRY)&_ZN5S74C72v8Ev,
  (VTBL_ENTRY)&_ZN5S74C72v9Ev,
  (VTBL_ENTRY)&_ZN5S74C73v10Ev,
  (VTBL_ENTRY)&_ZN5S74C73v11Ev,
  (VTBL_ENTRY)&_ZN5S74C73v12Ev,
  (VTBL_ENTRY)&_ZN5S74C73v13Ev,
  (VTBL_ENTRY)&_ZN5S74C73v14Ev,
  (VTBL_ENTRY)&_ZN5S74C73v15Ev,
  (VTBL_ENTRY)&_ZN5S74C73v16Ev,
  (VTBL_ENTRY)&_ZN5S74C73v17Ev,
  (VTBL_ENTRY)&_ZN5S74C73v18Ev,
  (VTBL_ENTRY)&_ZN5S74C73v19Ev,
  (VTBL_ENTRY)&_ZN5S74C73v20Ev,
  (VTBL_ENTRY)&_ZN5S74C73v21Ev,
  (VTBL_ENTRY)&_ZN5S74C73v22Ev,
  (VTBL_ENTRY)&_ZN5S74C73v23Ev,
  (VTBL_ENTRY)&_ZN5S74C73v24Ev,
  (VTBL_ENTRY)&_ZN5S74C73v25Ev,
  (VTBL_ENTRY)&_ZN5S74C73v26Ev,
  (VTBL_ENTRY)&_ZN5S74C73v27Ev,
  (VTBL_ENTRY)&_ZN5S74C73v28Ev,
  (VTBL_ENTRY)&_ZN5S74C73v29Ev,
  (VTBL_ENTRY)&_ZN5S74C73v30Ev,
  (VTBL_ENTRY)&_ZN5S74C73v31Ev,
  (VTBL_ENTRY)&_ZN5S74C73v32Ev,
  (VTBL_ENTRY)&_ZN5S74C73v33Ev,
  (VTBL_ENTRY)&_ZN5S74C73v34Ev,
  (VTBL_ENTRY)&_ZN5S74C73v35Ev,
  (VTBL_ENTRY)&_ZN5S74C73v36Ev,
  (VTBL_ENTRY)&_ZN5S74C73v37Ev,
  (VTBL_ENTRY)&_ZN5S74C73v38Ev,
  (VTBL_ENTRY)&_ZN5S74C73v39Ev,
  (VTBL_ENTRY)&_ZN5S74C73v40Ev,
  (VTBL_ENTRY)&_ZN5S74C73v41Ev,
  (VTBL_ENTRY)&_ZN5S74C73v42Ev,
  (VTBL_ENTRY)&_ZN5S74C73v43Ev,
  (VTBL_ENTRY)&_ZN5S74C73v44Ev,
  (VTBL_ENTRY)&_ZN5S74C73v45Ev,
  (VTBL_ENTRY)&_ZN5S74C73v46Ev,
  (VTBL_ENTRY)&_ZN5S74C73v47Ev,
  (VTBL_ENTRY)&_ZN5S74C73v48Ev,
  (VTBL_ENTRY)&_ZN5S74C73v49Ev,
  (VTBL_ENTRY)&_ZN5S74C73v50Ev,
  (VTBL_ENTRY)&_ZN5S74C73v51Ev,
  (VTBL_ENTRY)&_ZN5S74C73v52Ev,
  (VTBL_ENTRY)&_ZN5S74C73v53Ev,
  (VTBL_ENTRY)&_ZN5S74C73v54Ev,
  (VTBL_ENTRY)&_ZN5S74C73v55Ev,
  (VTBL_ENTRY)&_ZN5S74C73v56Ev,
  (VTBL_ENTRY)&_ZN5S74C73v57Ev,
  (VTBL_ENTRY)&_ZN5S74C73v58Ev,
  (VTBL_ENTRY)&_ZN5S74C73v59Ev,
  (VTBL_ENTRY)&_ZN5S74C73v60Ev,
  (VTBL_ENTRY)&_ZN5S74C73v61Ev,
  (VTBL_ENTRY)&_ZN5S74C73v62Ev,
  (VTBL_ENTRY)&_ZN5S74C73v63Ev,
  (VTBL_ENTRY)&_ZN5S74C73v64Ev,
  (VTBL_ENTRY)&_ZN5S74C73v65Ev,
  (VTBL_ENTRY)&_ZN5S74C73v66Ev,
  (VTBL_ENTRY)&_ZN5S74C73v67Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S74C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S74C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S74C4_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S74C4_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S74C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S74C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S74C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S74C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S74C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S74C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S74C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S74C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN5S74C24v122Ev,
  (VTBL_ENTRY)&_ZN5S74C24v123Ev,
};
extern VTBL_ENTRY _ZTI5S74C2[];
extern  VTBL_ENTRY _ZTV5S74C2[];
Class_Descriptor cd_S74C2 = {  "S74C2", // class name
  bases_S74C2, 5,
  &(vtc_S74C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(328,240), // object size
  NSPAIRA(_ZTI5S74C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S74C2),124, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S74C1  : S74C2 {
  virtual  ~S74C1(); // _ZN5S74C1D1Ev
  virtual void  v1(); // _ZN5S74C12v1Ev
  virtual void  v2(); // _ZN5S74C12v2Ev
  virtual void  v3(); // _ZN5S74C12v3Ev
  S74C1(); // tgen
};
//SIG(1 S74C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC8{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 Fi[2] Fp Fi[2] FC9{ BC10{ BC11{ BC12{ m Fp Fi[2]}}}} FC9 FC13{ m} FC9 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 Fi:1 Fi:1 Fi:1 FC14{ BC15{ BC12}} FC16{ BC17{ BC12}} FC18{ BC19{ BC12}} FC20{ BC21{ BC12}} Fi[3]} vd v110 v111 v112 v113 FC8 Fi:1 FC22{ BC23{ BC12}}} vd v114 v115 v116 v117 v118 v119 v120 v121 Fi Fi:1} vd v122 v123 Fp[2] Fi:1} vd v1 v2 v3}


 S74C1 ::~S74C1(){ note_dtor("S74C1", this);}
void  S74C1 ::v1(){vfunc_called(this, "_ZN5S74C12v1Ev");}
void  S74C1 ::v2(){vfunc_called(this, "_ZN5S74C12v2Ev");}
void  S74C1 ::v3(){vfunc_called(this, "_ZN5S74C12v3Ev");}
S74C1 ::S74C1(){ note_ctor("S74C1", this);} // tgen

static void Test_S74C1()
{
  extern Class_Descriptor cd_S74C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(42,61)];
    init_test(&cd_S74C1, buf);
    S74C1 *dp, &lv = *(dp=new (buf) S74C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(328,240), "sizeof(S74C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S74C1)");
    check_base_class_offset(lv, (S74C7*)(S74C6_nt*)(S74C5_nt*)(S74C4_nt*)(S74C3_nt*)(S74C2*), 0, "S74C1");
    check_base_class_offset(lv, (S74C6_nt*)(S74C5_nt*)(S74C4_nt*)(S74C3_nt*)(S74C2*), 0, "S74C1");
    check_base_class_offset(lv, (S74C5_nt*)(S74C4_nt*)(S74C3_nt*)(S74C2*), 0, "S74C1");
    check_base_class_offset(lv, (S74C4_nt*)(S74C3_nt*)(S74C2*), 0, "S74C1");
    check_base_class_offset(lv, (S74C3_nt*)(S74C2*), 0, "S74C1");
    check_base_class_offset(lv, (S74C2*), 0, "S74C1");
    test_class_info(&lv, &cd_S74C1);
    dp->~S74C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS74C1(Test_S74C1, "S74C1", ABISELECT(328,240));

#else // __cplusplus

extern void _ZN5S74C1C1Ev();
extern void _ZN5S74C1D1Ev();
Name_Map name_map_S74C1[] = {
  NSPAIR(_ZN5S74C1C1Ev),
  NSPAIR(_ZN5S74C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S74C7;
extern VTBL_ENTRY _ZTI5S74C7[];
extern  VTBL_ENTRY _ZTV5S74C7[];
extern Class_Descriptor cd_S74C6_nt;
extern VTBL_ENTRY _ZTI8S74C6_nt[];
extern  VTBL_ENTRY _ZTV8S74C6_nt[];
extern Class_Descriptor cd_S74C5_nt;
extern VTBL_ENTRY _ZTI8S74C5_nt[];
extern  VTBL_ENTRY _ZTV8S74C5_nt[];
extern Class_Descriptor cd_S74C4_nt;
extern VTBL_ENTRY _ZTI8S74C4_nt[];
extern  VTBL_ENTRY _ZTV8S74C4_nt[];
extern Class_Descriptor cd_S74C3_nt;
extern VTBL_ENTRY _ZTI8S74C3_nt[];
extern  VTBL_ENTRY _ZTV8S74C3_nt[];
extern Class_Descriptor cd_S74C2;
extern VTBL_ENTRY _ZTI5S74C2[];
extern  VTBL_ENTRY _ZTV5S74C2[];
static Base_Class bases_S74C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S74C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S74C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S74C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S74C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S74C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S74C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S74C1[];
extern void _ZN5S74C1D1Ev();
extern void _ZN5S74C1D0Ev();
extern void _ZN5S74C72v4Ev();
extern void _ZN5S74C72v5Ev();
extern void _ZN5S74C72v6Ev();
extern void _ZN5S74C72v7Ev();
extern void _ZN5S74C72v8Ev();
extern void _ZN5S74C72v9Ev();
extern void _ZN5S74C73v10Ev();
extern void _ZN5S74C73v11Ev();
extern void _ZN5S74C73v12Ev();
extern void _ZN5S74C73v13Ev();
extern void _ZN5S74C73v14Ev();
extern void _ZN5S74C73v15Ev();
extern void _ZN5S74C73v16Ev();
extern void _ZN5S74C73v17Ev();
extern void _ZN5S74C73v18Ev();
extern void _ZN5S74C73v19Ev();
extern void _ZN5S74C73v20Ev();
extern void _ZN5S74C73v21Ev();
extern void _ZN5S74C73v22Ev();
extern void _ZN5S74C73v23Ev();
extern void _ZN5S74C73v24Ev();
extern void _ZN5S74C73v25Ev();
extern void _ZN5S74C73v26Ev();
extern void _ZN5S74C73v27Ev();
extern void _ZN5S74C73v28Ev();
extern void _ZN5S74C73v29Ev();
extern void _ZN5S74C73v30Ev();
extern void _ZN5S74C73v31Ev();
extern void _ZN5S74C73v32Ev();
extern void _ZN5S74C73v33Ev();
extern void _ZN5S74C73v34Ev();
extern void _ZN5S74C73v35Ev();
extern void _ZN5S74C73v36Ev();
extern void _ZN5S74C73v37Ev();
extern void _ZN5S74C73v38Ev();
extern void _ZN5S74C73v39Ev();
extern void _ZN5S74C73v40Ev();
extern void _ZN5S74C73v41Ev();
extern void _ZN5S74C73v42Ev();
extern void _ZN5S74C73v43Ev();
extern void _ZN5S74C73v44Ev();
extern void _ZN5S74C73v45Ev();
extern void _ZN5S74C73v46Ev();
extern void _ZN5S74C73v47Ev();
extern void _ZN5S74C73v48Ev();
extern void _ZN5S74C73v49Ev();
extern void _ZN5S74C73v50Ev();
extern void _ZN5S74C73v51Ev();
extern void _ZN5S74C73v52Ev();
extern void _ZN5S74C73v53Ev();
extern void _ZN5S74C73v54Ev();
extern void _ZN5S74C73v55Ev();
extern void _ZN5S74C73v56Ev();
extern void _ZN5S74C73v57Ev();
extern void _ZN5S74C73v58Ev();
extern void _ZN5S74C73v59Ev();
extern void _ZN5S74C73v60Ev();
extern void _ZN5S74C73v61Ev();
extern void _ZN5S74C73v62Ev();
extern void _ZN5S74C73v63Ev();
extern void _ZN5S74C73v64Ev();
extern void _ZN5S74C73v65Ev();
extern void _ZN5S74C73v66Ev();
extern void _ZN5S74C73v67Ev();
extern void _ZN8S74C6_nt3v68Ev();
extern void _ZN8S74C6_nt3v69Ev();
extern void _ZN8S74C6_nt3v70Ev();
extern void _ZN8S74C6_nt3v71Ev();
extern void _ZN8S74C6_nt3v72Ev();
extern void _ZN8S74C6_nt3v73Ev();
extern void _ZN8S74C6_nt3v74Ev();
extern void _ZN8S74C6_nt3v75Ev();
extern void _ZN8S74C6_nt3v76Ev();
extern void _ZN8S74C6_nt3v77Ev();
extern void _ZN8S74C6_nt3v78Ev();
extern void _ZN8S74C6_nt3v79Ev();
extern void _ZN8S74C6_nt3v80Ev();
extern void _ZN8S74C6_nt3v81Ev();
extern void _ZN8S74C6_nt3v82Ev();
extern void _ZN8S74C6_nt3v83Ev();
extern void _ZN8S74C6_nt3v84Ev();
extern void _ZN8S74C6_nt3v85Ev();
extern void _ZN8S74C6_nt3v86Ev();
extern void _ZN8S74C6_nt3v87Ev();
extern void _ZN8S74C6_nt3v88Ev();
extern void _ZN8S74C6_nt3v89Ev();
extern void _ZN8S74C5_nt3v90Ev();
extern void _ZN8S74C5_nt3v91Ev();
extern void _ZN8S74C5_nt3v92Ev();
extern void _ZN8S74C5_nt3v93Ev();
extern void _ZN8S74C5_nt3v94Ev();
extern void _ZN8S74C5_nt3v95Ev();
extern void _ZN8S74C5_nt3v96Ev();
extern void _ZN8S74C5_nt3v97Ev();
extern void _ZN8S74C5_nt3v98Ev();
extern void _ZN8S74C5_nt3v99Ev();
extern void _ZN8S74C5_nt4v100Ev();
extern void _ZN8S74C5_nt4v101Ev();
extern void _ZN8S74C5_nt4v102Ev();
extern void _ZN8S74C5_nt4v103Ev();
extern void _ZN8S74C5_nt4v104Ev();
extern void _ZN8S74C5_nt4v105Ev();
extern void _ZN8S74C5_nt4v106Ev();
extern void _ZN8S74C5_nt4v107Ev();
extern void _ZN8S74C5_nt4v108Ev();
extern void _ZN8S74C5_nt4v109Ev();
extern void _ZN8S74C4_nt4v110Ev();
extern void _ZN8S74C4_nt4v111Ev();
extern void _ZN8S74C4_nt4v112Ev();
extern void _ZN8S74C4_nt4v113Ev();
extern void _ZN8S74C3_nt4v114Ev();
extern void _ZN8S74C3_nt4v115Ev();
extern void _ZN8S74C3_nt4v116Ev();
extern void _ZN8S74C3_nt4v117Ev();
extern void _ZN8S74C3_nt4v118Ev();
extern void _ZN8S74C3_nt4v119Ev();
extern void _ZN8S74C3_nt4v120Ev();
extern void _ZN8S74C3_nt4v121Ev();
extern void _ZN5S74C24v122Ev();
extern void _ZN5S74C24v123Ev();
extern void _ZN5S74C12v1Ev();
extern void _ZN5S74C12v2Ev();
extern void _ZN5S74C12v3Ev();
static  VTBL_ENTRY vtc_S74C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S74C1[0]),
  (VTBL_ENTRY)&_ZN5S74C1D1Ev,
  (VTBL_ENTRY)&_ZN5S74C1D0Ev,
  (VTBL_ENTRY)&_ZN5S74C72v4Ev,
  (VTBL_ENTRY)&_ZN5S74C72v5Ev,
  (VTBL_ENTRY)&_ZN5S74C72v6Ev,
  (VTBL_ENTRY)&_ZN5S74C72v7Ev,
  (VTBL_ENTRY)&_ZN5S74C72v8Ev,
  (VTBL_ENTRY)&_ZN5S74C72v9Ev,
  (VTBL_ENTRY)&_ZN5S74C73v10Ev,
  (VTBL_ENTRY)&_ZN5S74C73v11Ev,
  (VTBL_ENTRY)&_ZN5S74C73v12Ev,
  (VTBL_ENTRY)&_ZN5S74C73v13Ev,
  (VTBL_ENTRY)&_ZN5S74C73v14Ev,
  (VTBL_ENTRY)&_ZN5S74C73v15Ev,
  (VTBL_ENTRY)&_ZN5S74C73v16Ev,
  (VTBL_ENTRY)&_ZN5S74C73v17Ev,
  (VTBL_ENTRY)&_ZN5S74C73v18Ev,
  (VTBL_ENTRY)&_ZN5S74C73v19Ev,
  (VTBL_ENTRY)&_ZN5S74C73v20Ev,
  (VTBL_ENTRY)&_ZN5S74C73v21Ev,
  (VTBL_ENTRY)&_ZN5S74C73v22Ev,
  (VTBL_ENTRY)&_ZN5S74C73v23Ev,
  (VTBL_ENTRY)&_ZN5S74C73v24Ev,
  (VTBL_ENTRY)&_ZN5S74C73v25Ev,
  (VTBL_ENTRY)&_ZN5S74C73v26Ev,
  (VTBL_ENTRY)&_ZN5S74C73v27Ev,
  (VTBL_ENTRY)&_ZN5S74C73v28Ev,
  (VTBL_ENTRY)&_ZN5S74C73v29Ev,
  (VTBL_ENTRY)&_ZN5S74C73v30Ev,
  (VTBL_ENTRY)&_ZN5S74C73v31Ev,
  (VTBL_ENTRY)&_ZN5S74C73v32Ev,
  (VTBL_ENTRY)&_ZN5S74C73v33Ev,
  (VTBL_ENTRY)&_ZN5S74C73v34Ev,
  (VTBL_ENTRY)&_ZN5S74C73v35Ev,
  (VTBL_ENTRY)&_ZN5S74C73v36Ev,
  (VTBL_ENTRY)&_ZN5S74C73v37Ev,
  (VTBL_ENTRY)&_ZN5S74C73v38Ev,
  (VTBL_ENTRY)&_ZN5S74C73v39Ev,
  (VTBL_ENTRY)&_ZN5S74C73v40Ev,
  (VTBL_ENTRY)&_ZN5S74C73v41Ev,
  (VTBL_ENTRY)&_ZN5S74C73v42Ev,
  (VTBL_ENTRY)&_ZN5S74C73v43Ev,
  (VTBL_ENTRY)&_ZN5S74C73v44Ev,
  (VTBL_ENTRY)&_ZN5S74C73v45Ev,
  (VTBL_ENTRY)&_ZN5S74C73v46Ev,
  (VTBL_ENTRY)&_ZN5S74C73v47Ev,
  (VTBL_ENTRY)&_ZN5S74C73v48Ev,
  (VTBL_ENTRY)&_ZN5S74C73v49Ev,
  (VTBL_ENTRY)&_ZN5S74C73v50Ev,
  (VTBL_ENTRY)&_ZN5S74C73v51Ev,
  (VTBL_ENTRY)&_ZN5S74C73v52Ev,
  (VTBL_ENTRY)&_ZN5S74C73v53Ev,
  (VTBL_ENTRY)&_ZN5S74C73v54Ev,
  (VTBL_ENTRY)&_ZN5S74C73v55Ev,
  (VTBL_ENTRY)&_ZN5S74C73v56Ev,
  (VTBL_ENTRY)&_ZN5S74C73v57Ev,
  (VTBL_ENTRY)&_ZN5S74C73v58Ev,
  (VTBL_ENTRY)&_ZN5S74C73v59Ev,
  (VTBL_ENTRY)&_ZN5S74C73v60Ev,
  (VTBL_ENTRY)&_ZN5S74C73v61Ev,
  (VTBL_ENTRY)&_ZN5S74C73v62Ev,
  (VTBL_ENTRY)&_ZN5S74C73v63Ev,
  (VTBL_ENTRY)&_ZN5S74C73v64Ev,
  (VTBL_ENTRY)&_ZN5S74C73v65Ev,
  (VTBL_ENTRY)&_ZN5S74C73v66Ev,
  (VTBL_ENTRY)&_ZN5S74C73v67Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S74C6_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S74C5_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S74C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S74C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S74C4_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S74C4_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S74C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S74C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S74C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S74C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S74C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S74C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S74C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S74C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN5S74C24v122Ev,
  (VTBL_ENTRY)&_ZN5S74C24v123Ev,
  (VTBL_ENTRY)&_ZN5S74C12v1Ev,
  (VTBL_ENTRY)&_ZN5S74C12v2Ev,
  (VTBL_ENTRY)&_ZN5S74C12v3Ev,
};
extern VTBL_ENTRY _ZTI5S74C1[];
extern  VTBL_ENTRY _ZTV5S74C1[];
Class_Descriptor cd_S74C1 = {  "S74C1", // class name
  bases_S74C1, 6,
  &(vtc_S74C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(328,240), // object size
  NSPAIRA(_ZTI5S74C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S74C1),127, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S206C6  {
  int s206c6f0;
  __tsi64 s206c6f1;
  void *s206c6f2[4];
  int s206c6f3[2];
  void *s206c6f4;
  ::S1409C5_nt s206c6f5;
  void *s206c6f6[2];
  virtual  ~S206C6(); // _ZN6S206C6D1Ev
  virtual void  v4(); // _ZN6S206C62v4Ev
  virtual void  v5(); // _ZN6S206C62v5Ev
  virtual void  v6(); // _ZN6S206C62v6Ev
  virtual void  v7(); // _ZN6S206C62v7Ev
  virtual void  v8(); // _ZN6S206C62v8Ev
  virtual void  v9(); // _ZN6S206C62v9Ev
  virtual void  v10(); // _ZN6S206C63v10Ev
  virtual void  v11(); // _ZN6S206C63v11Ev
  virtual void  v12(); // _ZN6S206C63v12Ev
  virtual void  v13(); // _ZN6S206C63v13Ev
  virtual void  v14(); // _ZN6S206C63v14Ev
  virtual void  v15(); // _ZN6S206C63v15Ev
  virtual void  v16(); // _ZN6S206C63v16Ev
  virtual void  v17(); // _ZN6S206C63v17Ev
  virtual void  v18(); // _ZN6S206C63v18Ev
  virtual void  v19(); // _ZN6S206C63v19Ev
  virtual void  v20(); // _ZN6S206C63v20Ev
  virtual void  v21(); // _ZN6S206C63v21Ev
  virtual void  v22(); // _ZN6S206C63v22Ev
  virtual void  v23(); // _ZN6S206C63v23Ev
  virtual void  v24(); // _ZN6S206C63v24Ev
  virtual void  v25(); // _ZN6S206C63v25Ev
  virtual void  v26(); // _ZN6S206C63v26Ev
  virtual void  v27(); // _ZN6S206C63v27Ev
  virtual void  v28(); // _ZN6S206C63v28Ev
  virtual void  v29(); // _ZN6S206C63v29Ev
  virtual void  v30(); // _ZN6S206C63v30Ev
  virtual void  v31(); // _ZN6S206C63v31Ev
  virtual void  v32(); // _ZN6S206C63v32Ev
  virtual void  v33(); // _ZN6S206C63v33Ev
  virtual void  v34(); // _ZN6S206C63v34Ev
  virtual void  v35(); // _ZN6S206C63v35Ev
  virtual void  v36(); // _ZN6S206C63v36Ev
  virtual void  v37(); // _ZN6S206C63v37Ev
  virtual void  v38(); // _ZN6S206C63v38Ev
  virtual void  v39(); // _ZN6S206C63v39Ev
  virtual void  v40(); // _ZN6S206C63v40Ev
  virtual void  v41(); // _ZN6S206C63v41Ev
  virtual void  v42(); // _ZN6S206C63v42Ev
  virtual void  v43(); // _ZN6S206C63v43Ev
  virtual void  v44(); // _ZN6S206C63v44Ev
  virtual void  v45(); // _ZN6S206C63v45Ev
  virtual void  v46(); // _ZN6S206C63v46Ev
  virtual void  v47(); // _ZN6S206C63v47Ev
  virtual void  v48(); // _ZN6S206C63v48Ev
  virtual void  v49(); // _ZN6S206C63v49Ev
  virtual void  v50(); // _ZN6S206C63v50Ev
  virtual void  v51(); // _ZN6S206C63v51Ev
  virtual void  v52(); // _ZN6S206C63v52Ev
  virtual void  v53(); // _ZN6S206C63v53Ev
  virtual void  v54(); // _ZN6S206C63v54Ev
  virtual void  v55(); // _ZN6S206C63v55Ev
  virtual void  v56(); // _ZN6S206C63v56Ev
  virtual void  v57(); // _ZN6S206C63v57Ev
  virtual void  v58(); // _ZN6S206C63v58Ev
  virtual void  v59(); // _ZN6S206C63v59Ev
  virtual void  v60(); // _ZN6S206C63v60Ev
  virtual void  v61(); // _ZN6S206C63v61Ev
  virtual void  v62(); // _ZN6S206C63v62Ev
  virtual void  v63(); // _ZN6S206C63v63Ev
  virtual void  v64(); // _ZN6S206C63v64Ev
  virtual void  v65(); // _ZN6S206C63v65Ev
  virtual void  v66(); // _ZN6S206C63v66Ev
  virtual void  v67(); // _ZN6S206C63v67Ev
  S206C6(); // tgen
};
//SIG(-1 S206C6) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S206C6 ::~S206C6(){ note_dtor("S206C6", this);}
void  S206C6 ::v4(){vfunc_called(this, "_ZN6S206C62v4Ev");}
void  S206C6 ::v5(){vfunc_called(this, "_ZN6S206C62v5Ev");}
void  S206C6 ::v6(){vfunc_called(this, "_ZN6S206C62v6Ev");}
void  S206C6 ::v7(){vfunc_called(this, "_ZN6S206C62v7Ev");}
void  S206C6 ::v8(){vfunc_called(this, "_ZN6S206C62v8Ev");}
void  S206C6 ::v9(){vfunc_called(this, "_ZN6S206C62v9Ev");}
void  S206C6 ::v10(){vfunc_called(this, "_ZN6S206C63v10Ev");}
void  S206C6 ::v11(){vfunc_called(this, "_ZN6S206C63v11Ev");}
void  S206C6 ::v12(){vfunc_called(this, "_ZN6S206C63v12Ev");}
void  S206C6 ::v13(){vfunc_called(this, "_ZN6S206C63v13Ev");}
void  S206C6 ::v14(){vfunc_called(this, "_ZN6S206C63v14Ev");}
void  S206C6 ::v15(){vfunc_called(this, "_ZN6S206C63v15Ev");}
void  S206C6 ::v16(){vfunc_called(this, "_ZN6S206C63v16Ev");}
void  S206C6 ::v17(){vfunc_called(this, "_ZN6S206C63v17Ev");}
void  S206C6 ::v18(){vfunc_called(this, "_ZN6S206C63v18Ev");}
void  S206C6 ::v19(){vfunc_called(this, "_ZN6S206C63v19Ev");}
void  S206C6 ::v20(){vfunc_called(this, "_ZN6S206C63v20Ev");}
void  S206C6 ::v21(){vfunc_called(this, "_ZN6S206C63v21Ev");}
void  S206C6 ::v22(){vfunc_called(this, "_ZN6S206C63v22Ev");}
void  S206C6 ::v23(){vfunc_called(this, "_ZN6S206C63v23Ev");}
void  S206C6 ::v24(){vfunc_called(this, "_ZN6S206C63v24Ev");}
void  S206C6 ::v25(){vfunc_called(this, "_ZN6S206C63v25Ev");}
void  S206C6 ::v26(){vfunc_called(this, "_ZN6S206C63v26Ev");}
void  S206C6 ::v27(){vfunc_called(this, "_ZN6S206C63v27Ev");}
void  S206C6 ::v28(){vfunc_called(this, "_ZN6S206C63v28Ev");}
void  S206C6 ::v29(){vfunc_called(this, "_ZN6S206C63v29Ev");}
void  S206C6 ::v30(){vfunc_called(this, "_ZN6S206C63v30Ev");}
void  S206C6 ::v31(){vfunc_called(this, "_ZN6S206C63v31Ev");}
void  S206C6 ::v32(){vfunc_called(this, "_ZN6S206C63v32Ev");}
void  S206C6 ::v33(){vfunc_called(this, "_ZN6S206C63v33Ev");}
void  S206C6 ::v34(){vfunc_called(this, "_ZN6S206C63v34Ev");}
void  S206C6 ::v35(){vfunc_called(this, "_ZN6S206C63v35Ev");}
void  S206C6 ::v36(){vfunc_called(this, "_ZN6S206C63v36Ev");}
void  S206C6 ::v37(){vfunc_called(this, "_ZN6S206C63v37Ev");}
void  S206C6 ::v38(){vfunc_called(this, "_ZN6S206C63v38Ev");}
void  S206C6 ::v39(){vfunc_called(this, "_ZN6S206C63v39Ev");}
void  S206C6 ::v40(){vfunc_called(this, "_ZN6S206C63v40Ev");}
void  S206C6 ::v41(){vfunc_called(this, "_ZN6S206C63v41Ev");}
void  S206C6 ::v42(){vfunc_called(this, "_ZN6S206C63v42Ev");}
void  S206C6 ::v43(){vfunc_called(this, "_ZN6S206C63v43Ev");}
void  S206C6 ::v44(){vfunc_called(this, "_ZN6S206C63v44Ev");}
void  S206C6 ::v45(){vfunc_called(this, "_ZN6S206C63v45Ev");}
void  S206C6 ::v46(){vfunc_called(this, "_ZN6S206C63v46Ev");}
void  S206C6 ::v47(){vfunc_called(this, "_ZN6S206C63v47Ev");}
void  S206C6 ::v48(){vfunc_called(this, "_ZN6S206C63v48Ev");}
void  S206C6 ::v49(){vfunc_called(this, "_ZN6S206C63v49Ev");}
void  S206C6 ::v50(){vfunc_called(this, "_ZN6S206C63v50Ev");}
void  S206C6 ::v51(){vfunc_called(this, "_ZN6S206C63v51Ev");}
void  S206C6 ::v52(){vfunc_called(this, "_ZN6S206C63v52Ev");}
void  S206C6 ::v53(){vfunc_called(this, "_ZN6S206C63v53Ev");}
void  S206C6 ::v54(){vfunc_called(this, "_ZN6S206C63v54Ev");}
void  S206C6 ::v55(){vfunc_called(this, "_ZN6S206C63v55Ev");}
void  S206C6 ::v56(){vfunc_called(this, "_ZN6S206C63v56Ev");}
void  S206C6 ::v57(){vfunc_called(this, "_ZN6S206C63v57Ev");}
void  S206C6 ::v58(){vfunc_called(this, "_ZN6S206C63v58Ev");}
void  S206C6 ::v59(){vfunc_called(this, "_ZN6S206C63v59Ev");}
void  S206C6 ::v60(){vfunc_called(this, "_ZN6S206C63v60Ev");}
void  S206C6 ::v61(){vfunc_called(this, "_ZN6S206C63v61Ev");}
void  S206C6 ::v62(){vfunc_called(this, "_ZN6S206C63v62Ev");}
void  S206C6 ::v63(){vfunc_called(this, "_ZN6S206C63v63Ev");}
void  S206C6 ::v64(){vfunc_called(this, "_ZN6S206C63v64Ev");}
void  S206C6 ::v65(){vfunc_called(this, "_ZN6S206C63v65Ev");}
void  S206C6 ::v66(){vfunc_called(this, "_ZN6S206C63v66Ev");}
void  S206C6 ::v67(){vfunc_called(this, "_ZN6S206C63v67Ev");}
S206C6 ::S206C6(){ note_ctor("S206C6", this);} // tgen

static void Test_S206C6()
{
  extern Class_Descriptor cd_S206C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S206C6, buf);
    S206C6 *dp, &lv = *(dp=new (buf) S206C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S206C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S206C6)");
    check_field_offset(lv, s206c6f0, ABISELECT(8,4), "S206C6.s206c6f0");
    check_field_offset(lv, s206c6f1, ABISELECT(16,8), "S206C6.s206c6f1");
    check_field_offset(lv, s206c6f2, ABISELECT(24,16), "S206C6.s206c6f2");
    check_field_offset(lv, s206c6f3, ABISELECT(56,32), "S206C6.s206c6f3");
    check_field_offset(lv, s206c6f4, ABISELECT(64,40), "S206C6.s206c6f4");
    check_field_offset(lv, s206c6f5, ABISELECT(72,44), "S206C6.s206c6f5");
    check_field_offset(lv, s206c6f6, ABISELECT(80,52), "S206C6.s206c6f6");
    test_class_info(&lv, &cd_S206C6);
    dp->~S206C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS206C6(Test_S206C6, "S206C6", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S206C6C1Ev();
extern void _ZN6S206C6D1Ev();
Name_Map name_map_S206C6[] = {
  NSPAIR(_ZN6S206C6C1Ev),
  NSPAIR(_ZN6S206C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S206C6[];
extern void _ZN6S206C6D1Ev();
extern void _ZN6S206C6D0Ev();
extern void _ZN6S206C62v4Ev();
extern void _ZN6S206C62v5Ev();
extern void _ZN6S206C62v6Ev();
extern void _ZN6S206C62v7Ev();
extern void _ZN6S206C62v8Ev();
extern void _ZN6S206C62v9Ev();
extern void _ZN6S206C63v10Ev();
extern void _ZN6S206C63v11Ev();
extern void _ZN6S206C63v12Ev();
extern void _ZN6S206C63v13Ev();
extern void _ZN6S206C63v14Ev();
extern void _ZN6S206C63v15Ev();
extern void _ZN6S206C63v16Ev();
extern void _ZN6S206C63v17Ev();
extern void _ZN6S206C63v18Ev();
extern void _ZN6S206C63v19Ev();
extern void _ZN6S206C63v20Ev();
extern void _ZN6S206C63v21Ev();
extern void _ZN6S206C63v22Ev();
extern void _ZN6S206C63v23Ev();
extern void _ZN6S206C63v24Ev();
extern void _ZN6S206C63v25Ev();
extern void _ZN6S206C63v26Ev();
extern void _ZN6S206C63v27Ev();
extern void _ZN6S206C63v28Ev();
extern void _ZN6S206C63v29Ev();
extern void _ZN6S206C63v30Ev();
extern void _ZN6S206C63v31Ev();
extern void _ZN6S206C63v32Ev();
extern void _ZN6S206C63v33Ev();
extern void _ZN6S206C63v34Ev();
extern void _ZN6S206C63v35Ev();
extern void _ZN6S206C63v36Ev();
extern void _ZN6S206C63v37Ev();
extern void _ZN6S206C63v38Ev();
extern void _ZN6S206C63v39Ev();
extern void _ZN6S206C63v40Ev();
extern void _ZN6S206C63v41Ev();
extern void _ZN6S206C63v42Ev();
extern void _ZN6S206C63v43Ev();
extern void _ZN6S206C63v44Ev();
extern void _ZN6S206C63v45Ev();
extern void _ZN6S206C63v46Ev();
extern void _ZN6S206C63v47Ev();
extern void _ZN6S206C63v48Ev();
extern void _ZN6S206C63v49Ev();
extern void _ZN6S206C63v50Ev();
extern void _ZN6S206C63v51Ev();
extern void _ZN6S206C63v52Ev();
extern void _ZN6S206C63v53Ev();
extern void _ZN6S206C63v54Ev();
extern void _ZN6S206C63v55Ev();
extern void _ZN6S206C63v56Ev();
extern void _ZN6S206C63v57Ev();
extern void _ZN6S206C63v58Ev();
extern void _ZN6S206C63v59Ev();
extern void _ZN6S206C63v60Ev();
extern void _ZN6S206C63v61Ev();
extern void _ZN6S206C63v62Ev();
extern void _ZN6S206C63v63Ev();
extern void _ZN6S206C63v64Ev();
extern void _ZN6S206C63v65Ev();
extern void _ZN6S206C63v66Ev();
extern void _ZN6S206C63v67Ev();
static  VTBL_ENTRY vtc_S206C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S206C6[0]),
  (VTBL_ENTRY)&_ZN6S206C6D1Ev,
  (VTBL_ENTRY)&_ZN6S206C6D0Ev,
  (VTBL_ENTRY)&_ZN6S206C62v4Ev,
  (VTBL_ENTRY)&_ZN6S206C62v5Ev,
  (VTBL_ENTRY)&_ZN6S206C62v6Ev,
  (VTBL_ENTRY)&_ZN6S206C62v7Ev,
  (VTBL_ENTRY)&_ZN6S206C62v8Ev,
  (VTBL_ENTRY)&_ZN6S206C62v9Ev,
  (VTBL_ENTRY)&_ZN6S206C63v10Ev,
  (VTBL_ENTRY)&_ZN6S206C63v11Ev,
  (VTBL_ENTRY)&_ZN6S206C63v12Ev,
  (VTBL_ENTRY)&_ZN6S206C63v13Ev,
  (VTBL_ENTRY)&_ZN6S206C63v14Ev,
  (VTBL_ENTRY)&_ZN6S206C63v15Ev,
  (VTBL_ENTRY)&_ZN6S206C63v16Ev,
  (VTBL_ENTRY)&_ZN6S206C63v17Ev,
  (VTBL_ENTRY)&_ZN6S206C63v18Ev,
  (VTBL_ENTRY)&_ZN6S206C63v19Ev,
  (VTBL_ENTRY)&_ZN6S206C63v20Ev,
  (VTBL_ENTRY)&_ZN6S206C63v21Ev,
  (VTBL_ENTRY)&_ZN6S206C63v22Ev,
  (VTBL_ENTRY)&_ZN6S206C63v23Ev,
  (VTBL_ENTRY)&_ZN6S206C63v24Ev,
  (VTBL_ENTRY)&_ZN6S206C63v25Ev,
  (VTBL_ENTRY)&_ZN6S206C63v26Ev,
  (VTBL_ENTRY)&_ZN6S206C63v27Ev,
  (VTBL_ENTRY)&_ZN6S206C63v28Ev,
  (VTBL_ENTRY)&_ZN6S206C63v29Ev,
  (VTBL_ENTRY)&_ZN6S206C63v30Ev,
  (VTBL_ENTRY)&_ZN6S206C63v31Ev,
  (VTBL_ENTRY)&_ZN6S206C63v32Ev,
  (VTBL_ENTRY)&_ZN6S206C63v33Ev,
  (VTBL_ENTRY)&_ZN6S206C63v34Ev,
  (VTBL_ENTRY)&_ZN6S206C63v35Ev,
  (VTBL_ENTRY)&_ZN6S206C63v36Ev,
  (VTBL_ENTRY)&_ZN6S206C63v37Ev,
  (VTBL_ENTRY)&_ZN6S206C63v38Ev,
  (VTBL_ENTRY)&_ZN6S206C63v39Ev,
  (VTBL_ENTRY)&_ZN6S206C63v40Ev,
  (VTBL_ENTRY)&_ZN6S206C63v41Ev,
  (VTBL_ENTRY)&_ZN6S206C63v42Ev,
  (VTBL_ENTRY)&_ZN6S206C63v43Ev,
  (VTBL_ENTRY)&_ZN6S206C63v44Ev,
  (VTBL_ENTRY)&_ZN6S206C63v45Ev,
  (VTBL_ENTRY)&_ZN6S206C63v46Ev,
  (VTBL_ENTRY)&_ZN6S206C63v47Ev,
  (VTBL_ENTRY)&_ZN6S206C63v48Ev,
  (VTBL_ENTRY)&_ZN6S206C63v49Ev,
  (VTBL_ENTRY)&_ZN6S206C63v50Ev,
  (VTBL_ENTRY)&_ZN6S206C63v51Ev,
  (VTBL_ENTRY)&_ZN6S206C63v52Ev,
  (VTBL_ENTRY)&_ZN6S206C63v53Ev,
  (VTBL_ENTRY)&_ZN6S206C63v54Ev,
  (VTBL_ENTRY)&_ZN6S206C63v55Ev,
  (VTBL_ENTRY)&_ZN6S206C63v56Ev,
  (VTBL_ENTRY)&_ZN6S206C63v57Ev,
  (VTBL_ENTRY)&_ZN6S206C63v58Ev,
  (VTBL_ENTRY)&_ZN6S206C63v59Ev,
  (VTBL_ENTRY)&_ZN6S206C63v60Ev,
  (VTBL_ENTRY)&_ZN6S206C63v61Ev,
  (VTBL_ENTRY)&_ZN6S206C63v62Ev,
  (VTBL_ENTRY)&_ZN6S206C63v63Ev,
  (VTBL_ENTRY)&_ZN6S206C63v64Ev,
  (VTBL_ENTRY)&_ZN6S206C63v65Ev,
  (VTBL_ENTRY)&_ZN6S206C63v66Ev,
  (VTBL_ENTRY)&_ZN6S206C63v67Ev,
};
extern VTBL_ENTRY _ZTI6S206C6[];
extern  VTBL_ENTRY _ZTV6S206C6[];
Class_Descriptor cd_S206C6 = {  "S206C6", // class name
  0,0,//no base classes
  &(vtc_S206C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S206C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S206C6),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S206C5  : S206C6 {
  int s206c5f0[2];
  void *s206c5f1;
  int s206c5f2[2];
  ::S74C9_nt s206c5f3;
  ::S74C9_nt s206c5f4;
  ::S2265C38 s206c5f5;
  ::S74C9_nt s206c5f6;
  unsigned int s206c5f7:1;
  unsigned int s206c5f8:1;
  unsigned int s206c5f9:1;
  unsigned int s206c5f10:1;
  unsigned int s206c5f11:1;
  int s206c5f12[2];
  virtual  ~S206C5(); // _ZN6S206C5D1Ev
  virtual void  v68(); // _ZN6S206C53v68Ev
  virtual void  v69(); // _ZN6S206C53v69Ev
  virtual void  v70(); // _ZN6S206C53v70Ev
  virtual void  v71(); // _ZN6S206C53v71Ev
  virtual void  v72(); // _ZN6S206C53v72Ev
  virtual void  v73(); // _ZN6S206C53v73Ev
  virtual void  v74(); // _ZN6S206C53v74Ev
  virtual void  v75(); // _ZN6S206C53v75Ev
  virtual void  v76(); // _ZN6S206C53v76Ev
  virtual void  v77(); // _ZN6S206C53v77Ev
  virtual void  v78(); // _ZN6S206C53v78Ev
  virtual void  v79(); // _ZN6S206C53v79Ev
  virtual void  v80(); // _ZN6S206C53v80Ev
  virtual void  v81(); // _ZN6S206C53v81Ev
  virtual void  v82(); // _ZN6S206C53v82Ev
  virtual void  v83(); // _ZN6S206C53v83Ev
  virtual void  v84(); // _ZN6S206C53v84Ev
  virtual void  v85(); // _ZN6S206C53v85Ev
  virtual void  v86(); // _ZN6S206C53v86Ev
  virtual void  v87(); // _ZN6S206C53v87Ev
  virtual void  v88(); // _ZN6S206C53v88Ev
  virtual void  v89(); // _ZN6S206C53v89Ev
  S206C5(); // tgen
};
//SIG(-1 S206C5) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S206C5 ::~S206C5(){ note_dtor("S206C5", this);}
void  S206C5 ::v68(){vfunc_called(this, "_ZN6S206C53v68Ev");}
void  S206C5 ::v69(){vfunc_called(this, "_ZN6S206C53v69Ev");}
void  S206C5 ::v70(){vfunc_called(this, "_ZN6S206C53v70Ev");}
void  S206C5 ::v71(){vfunc_called(this, "_ZN6S206C53v71Ev");}
void  S206C5 ::v72(){vfunc_called(this, "_ZN6S206C53v72Ev");}
void  S206C5 ::v73(){vfunc_called(this, "_ZN6S206C53v73Ev");}
void  S206C5 ::v74(){vfunc_called(this, "_ZN6S206C53v74Ev");}
void  S206C5 ::v75(){vfunc_called(this, "_ZN6S206C53v75Ev");}
void  S206C5 ::v76(){vfunc_called(this, "_ZN6S206C53v76Ev");}
void  S206C5 ::v77(){vfunc_called(this, "_ZN6S206C53v77Ev");}
void  S206C5 ::v78(){vfunc_called(this, "_ZN6S206C53v78Ev");}
void  S206C5 ::v79(){vfunc_called(this, "_ZN6S206C53v79Ev");}
void  S206C5 ::v80(){vfunc_called(this, "_ZN6S206C53v80Ev");}
void  S206C5 ::v81(){vfunc_called(this, "_ZN6S206C53v81Ev");}
void  S206C5 ::v82(){vfunc_called(this, "_ZN6S206C53v82Ev");}
void  S206C5 ::v83(){vfunc_called(this, "_ZN6S206C53v83Ev");}
void  S206C5 ::v84(){vfunc_called(this, "_ZN6S206C53v84Ev");}
void  S206C5 ::v85(){vfunc_called(this, "_ZN6S206C53v85Ev");}
void  S206C5 ::v86(){vfunc_called(this, "_ZN6S206C53v86Ev");}
void  S206C5 ::v87(){vfunc_called(this, "_ZN6S206C53v87Ev");}
void  S206C5 ::v88(){vfunc_called(this, "_ZN6S206C53v88Ev");}
void  S206C5 ::v89(){vfunc_called(this, "_ZN6S206C53v89Ev");}
S206C5 ::S206C5(){ note_ctor("S206C5", this);} // tgen

static void Test_S206C5()
{
  extern Class_Descriptor cd_S206C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S206C5, buf);
    S206C5 *dp, &lv = *(dp=new (buf) S206C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S206C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S206C5)");
    check_base_class_offset(lv, (S206C6*), 0, "S206C5");
    check_field_offset(lv, s206c5f0, ABISELECT(96,60), "S206C5.s206c5f0");
    check_field_offset(lv, s206c5f1, ABISELECT(104,68), "S206C5.s206c5f1");
    check_field_offset(lv, s206c5f2, ABISELECT(112,72), "S206C5.s206c5f2");
    check_field_offset(lv, s206c5f3, ABISELECT(120,80), "S206C5.s206c5f3");
    check_field_offset(lv, s206c5f4, ABISELECT(136,92), "S206C5.s206c5f4");
    check_field_offset(lv, s206c5f5, ABISELECT(152,104), "S206C5.s206c5f5");
    check_field_offset(lv, s206c5f6, ABISELECT(160,108), "S206C5.s206c5f6");
    set_bf_and_test(lv, s206c5f7, ABISELECT(176,120), 0, 1, 1, "S206C5");
    set_bf_and_test(lv, s206c5f8, ABISELECT(176,120), 1, 1, 1, "S206C5");
    set_bf_and_test(lv, s206c5f9, ABISELECT(176,120), 2, 1, 1, "S206C5");
    set_bf_and_test(lv, s206c5f10, ABISELECT(176,120), 3, 1, 1, "S206C5");
    set_bf_and_test(lv, s206c5f11, ABISELECT(176,120), 4, 1, 1, "S206C5");
    check_field_offset(lv, s206c5f12, ABISELECT(180,124), "S206C5.s206c5f12");
    test_class_info(&lv, &cd_S206C5);
    dp->~S206C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS206C5(Test_S206C5, "S206C5", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN6S206C5C1Ev();
extern void _ZN6S206C5D1Ev();
Name_Map name_map_S206C5[] = {
  NSPAIR(_ZN6S206C5C1Ev),
  NSPAIR(_ZN6S206C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S206C6;
extern VTBL_ENTRY _ZTI6S206C6[];
extern  VTBL_ENTRY _ZTV6S206C6[];
static Base_Class bases_S206C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S206C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S206C5[];
extern void _ZN6S206C5D1Ev();
extern void _ZN6S206C5D0Ev();
extern void _ZN6S206C62v4Ev();
extern void _ZN6S206C62v5Ev();
extern void _ZN6S206C62v6Ev();
extern void _ZN6S206C62v7Ev();
extern void _ZN6S206C62v8Ev();
extern void _ZN6S206C62v9Ev();
extern void _ZN6S206C63v10Ev();
extern void _ZN6S206C63v11Ev();
extern void _ZN6S206C63v12Ev();
extern void _ZN6S206C63v13Ev();
extern void _ZN6S206C63v14Ev();
extern void _ZN6S206C63v15Ev();
extern void _ZN6S206C63v16Ev();
extern void _ZN6S206C63v17Ev();
extern void _ZN6S206C63v18Ev();
extern void _ZN6S206C63v19Ev();
extern void _ZN6S206C63v20Ev();
extern void _ZN6S206C63v21Ev();
extern void _ZN6S206C63v22Ev();
extern void _ZN6S206C63v23Ev();
extern void _ZN6S206C63v24Ev();
extern void _ZN6S206C63v25Ev();
extern void _ZN6S206C63v26Ev();
extern void _ZN6S206C63v27Ev();
extern void _ZN6S206C63v28Ev();
extern void _ZN6S206C63v29Ev();
extern void _ZN6S206C63v30Ev();
extern void _ZN6S206C63v31Ev();
extern void _ZN6S206C63v32Ev();
extern void _ZN6S206C63v33Ev();
extern void _ZN6S206C63v34Ev();
extern void _ZN6S206C63v35Ev();
extern void _ZN6S206C63v36Ev();
extern void _ZN6S206C63v37Ev();
extern void _ZN6S206C63v38Ev();
extern void _ZN6S206C63v39Ev();
extern void _ZN6S206C63v40Ev();
extern void _ZN6S206C63v41Ev();
extern void _ZN6S206C63v42Ev();
extern void _ZN6S206C63v43Ev();
extern void _ZN6S206C63v44Ev();
extern void _ZN6S206C63v45Ev();
extern void _ZN6S206C63v46Ev();
extern void _ZN6S206C63v47Ev();
extern void _ZN6S206C63v48Ev();
extern void _ZN6S206C63v49Ev();
extern void _ZN6S206C63v50Ev();
extern void _ZN6S206C63v51Ev();
extern void _ZN6S206C63v52Ev();
extern void _ZN6S206C63v53Ev();
extern void _ZN6S206C63v54Ev();
extern void _ZN6S206C63v55Ev();
extern void _ZN6S206C63v56Ev();
extern void _ZN6S206C63v57Ev();
extern void _ZN6S206C63v58Ev();
extern void _ZN6S206C63v59Ev();
extern void _ZN6S206C63v60Ev();
extern void _ZN6S206C63v61Ev();
extern void _ZN6S206C63v62Ev();
extern void _ZN6S206C63v63Ev();
extern void _ZN6S206C63v64Ev();
extern void _ZN6S206C63v65Ev();
extern void _ZN6S206C63v66Ev();
extern void _ZN6S206C63v67Ev();
extern void _ZN6S206C53v68Ev();
extern void _ZN6S206C53v69Ev();
extern void _ZN6S206C53v70Ev();
extern void _ZN6S206C53v71Ev();
extern void _ZN6S206C53v72Ev();
extern void _ZN6S206C53v73Ev();
extern void _ZN6S206C53v74Ev();
extern void _ZN6S206C53v75Ev();
extern void _ZN6S206C53v76Ev();
extern void _ZN6S206C53v77Ev();
extern void _ZN6S206C53v78Ev();
extern void _ZN6S206C53v79Ev();
extern void _ZN6S206C53v80Ev();
extern void _ZN6S206C53v81Ev();
extern void _ZN6S206C53v82Ev();
extern void _ZN6S206C53v83Ev();
extern void _ZN6S206C53v84Ev();
extern void _ZN6S206C53v85Ev();
extern void _ZN6S206C53v86Ev();
extern void _ZN6S206C53v87Ev();
extern void _ZN6S206C53v88Ev();
extern void _ZN6S206C53v89Ev();
static  VTBL_ENTRY vtc_S206C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S206C5[0]),
  (VTBL_ENTRY)&_ZN6S206C5D1Ev,
  (VTBL_ENTRY)&_ZN6S206C5D0Ev,
  (VTBL_ENTRY)&_ZN6S206C62v4Ev,
  (VTBL_ENTRY)&_ZN6S206C62v5Ev,
  (VTBL_ENTRY)&_ZN6S206C62v6Ev,
  (VTBL_ENTRY)&_ZN6S206C62v7Ev,
  (VTBL_ENTRY)&_ZN6S206C62v8Ev,
  (VTBL_ENTRY)&_ZN6S206C62v9Ev,
  (VTBL_ENTRY)&_ZN6S206C63v10Ev,
  (VTBL_ENTRY)&_ZN6S206C63v11Ev,
  (VTBL_ENTRY)&_ZN6S206C63v12Ev,
  (VTBL_ENTRY)&_ZN6S206C63v13Ev,
  (VTBL_ENTRY)&_ZN6S206C63v14Ev,
  (VTBL_ENTRY)&_ZN6S206C63v15Ev,
  (VTBL_ENTRY)&_ZN6S206C63v16Ev,
  (VTBL_ENTRY)&_ZN6S206C63v17Ev,
  (VTBL_ENTRY)&_ZN6S206C63v18Ev,
  (VTBL_ENTRY)&_ZN6S206C63v19Ev,
  (VTBL_ENTRY)&_ZN6S206C63v20Ev,
  (VTBL_ENTRY)&_ZN6S206C63v21Ev,
  (VTBL_ENTRY)&_ZN6S206C63v22Ev,
  (VTBL_ENTRY)&_ZN6S206C63v23Ev,
  (VTBL_ENTRY)&_ZN6S206C63v24Ev,
  (VTBL_ENTRY)&_ZN6S206C63v25Ev,
  (VTBL_ENTRY)&_ZN6S206C63v26Ev,
  (VTBL_ENTRY)&_ZN6S206C63v27Ev,
  (VTBL_ENTRY)&_ZN6S206C63v28Ev,
  (VTBL_ENTRY)&_ZN6S206C63v29Ev,
  (VTBL_ENTRY)&_ZN6S206C63v30Ev,
  (VTBL_ENTRY)&_ZN6S206C63v31Ev,
  (VTBL_ENTRY)&_ZN6S206C63v32Ev,
  (VTBL_ENTRY)&_ZN6S206C63v33Ev,
  (VTBL_ENTRY)&_ZN6S206C63v34Ev,
  (VTBL_ENTRY)&_ZN6S206C63v35Ev,
  (VTBL_ENTRY)&_ZN6S206C63v36Ev,
  (VTBL_ENTRY)&_ZN6S206C63v37Ev,
  (VTBL_ENTRY)&_ZN6S206C63v38Ev,
  (VTBL_ENTRY)&_ZN6S206C63v39Ev,
  (VTBL_ENTRY)&_ZN6S206C63v40Ev,
  (VTBL_ENTRY)&_ZN6S206C63v41Ev,
  (VTBL_ENTRY)&_ZN6S206C63v42Ev,
  (VTBL_ENTRY)&_ZN6S206C63v43Ev,
  (VTBL_ENTRY)&_ZN6S206C63v44Ev,
  (VTBL_ENTRY)&_ZN6S206C63v45Ev,
  (VTBL_ENTRY)&_ZN6S206C63v46Ev,
  (VTBL_ENTRY)&_ZN6S206C63v47Ev,
  (VTBL_ENTRY)&_ZN6S206C63v48Ev,
  (VTBL_ENTRY)&_ZN6S206C63v49Ev,
  (VTBL_ENTRY)&_ZN6S206C63v50Ev,
  (VTBL_ENTRY)&_ZN6S206C63v51Ev,
  (VTBL_ENTRY)&_ZN6S206C63v52Ev,
  (VTBL_ENTRY)&_ZN6S206C63v53Ev,
  (VTBL_ENTRY)&_ZN6S206C63v54Ev,
  (VTBL_ENTRY)&_ZN6S206C63v55Ev,
  (VTBL_ENTRY)&_ZN6S206C63v56Ev,
  (VTBL_ENTRY)&_ZN6S206C63v57Ev,
  (VTBL_ENTRY)&_ZN6S206C63v58Ev,
  (VTBL_ENTRY)&_ZN6S206C63v59Ev,
  (VTBL_ENTRY)&_ZN6S206C63v60Ev,
  (VTBL_ENTRY)&_ZN6S206C63v61Ev,
  (VTBL_ENTRY)&_ZN6S206C63v62Ev,
  (VTBL_ENTRY)&_ZN6S206C63v63Ev,
  (VTBL_ENTRY)&_ZN6S206C63v64Ev,
  (VTBL_ENTRY)&_ZN6S206C63v65Ev,
  (VTBL_ENTRY)&_ZN6S206C63v66Ev,
  (VTBL_ENTRY)&_ZN6S206C63v67Ev,
  (VTBL_ENTRY)&_ZN6S206C53v68Ev,
  (VTBL_ENTRY)&_ZN6S206C53v69Ev,
  (VTBL_ENTRY)&_ZN6S206C53v70Ev,
  (VTBL_ENTRY)&_ZN6S206C53v71Ev,
  (VTBL_ENTRY)&_ZN6S206C53v72Ev,
  (VTBL_ENTRY)&_ZN6S206C53v73Ev,
  (VTBL_ENTRY)&_ZN6S206C53v74Ev,
  (VTBL_ENTRY)&_ZN6S206C53v75Ev,
  (VTBL_ENTRY)&_ZN6S206C53v76Ev,
  (VTBL_ENTRY)&_ZN6S206C53v77Ev,
  (VTBL_ENTRY)&_ZN6S206C53v78Ev,
  (VTBL_ENTRY)&_ZN6S206C53v79Ev,
  (VTBL_ENTRY)&_ZN6S206C53v80Ev,
  (VTBL_ENTRY)&_ZN6S206C53v81Ev,
  (VTBL_ENTRY)&_ZN6S206C53v82Ev,
  (VTBL_ENTRY)&_ZN6S206C53v83Ev,
  (VTBL_ENTRY)&_ZN6S206C53v84Ev,
  (VTBL_ENTRY)&_ZN6S206C53v85Ev,
  (VTBL_ENTRY)&_ZN6S206C53v86Ev,
  (VTBL_ENTRY)&_ZN6S206C53v87Ev,
  (VTBL_ENTRY)&_ZN6S206C53v88Ev,
  (VTBL_ENTRY)&_ZN6S206C53v89Ev,
};
extern VTBL_ENTRY _ZTI6S206C5[];
extern  VTBL_ENTRY _ZTV6S206C5[];
Class_Descriptor cd_S206C5 = {  "S206C5", // class name
  bases_S206C5, 1,
  &(vtc_S206C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI6S206C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S206C5),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S206C4  : S206C5 {
  unsigned int s206c4f0:1;
  unsigned int s206c4f1:1;
  unsigned int s206c4f2:1;
  ::S1409C30 s206c4f3;
  ::S1409C26 s206c4f4;
  ::S1409C22 s206c4f5;
  ::S1409C18 s206c4f6;
  int s206c4f7[3];
  virtual  ~S206C4(); // _ZN6S206C4D1Ev
  virtual void  v90(); // _ZN6S206C43v90Ev
  virtual void  v91(); // _ZN6S206C43v91Ev
  virtual void  v92(); // _ZN6S206C43v92Ev
  virtual void  v93(); // _ZN6S206C43v93Ev
  virtual void  v94(); // _ZN6S206C43v94Ev
  virtual void  v95(); // _ZN6S206C43v95Ev
  virtual void  v96(); // _ZN6S206C43v96Ev
  virtual void  v97(); // _ZN6S206C43v97Ev
  virtual void  v98(); // _ZN6S206C43v98Ev
  virtual void  v99(); // _ZN6S206C43v99Ev
  virtual void  v100(); // _ZN6S206C44v100Ev
  virtual void  v101(); // _ZN6S206C44v101Ev
  virtual void  v102(); // _ZN6S206C44v102Ev
  virtual void  v103(); // _ZN6S206C44v103Ev
  virtual void  v104(); // _ZN6S206C44v104Ev
  virtual void  v105(); // _ZN6S206C44v105Ev
  virtual void  v106(); // _ZN6S206C44v106Ev
  virtual void  v107(); // _ZN6S206C44v107Ev
  virtual void  v108(); // _ZN6S206C44v108Ev
  virtual void  v109(); // _ZN6S206C44v109Ev
  S206C4(); // tgen
};
//SIG(-1 S206C4) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} FC16{ BC17{ BC8}} Fi[3]}


 S206C4 ::~S206C4(){ note_dtor("S206C4", this);}
void  S206C4 ::v90(){vfunc_called(this, "_ZN6S206C43v90Ev");}
void  S206C4 ::v91(){vfunc_called(this, "_ZN6S206C43v91Ev");}
void  S206C4 ::v92(){vfunc_called(this, "_ZN6S206C43v92Ev");}
void  S206C4 ::v93(){vfunc_called(this, "_ZN6S206C43v93Ev");}
void  S206C4 ::v94(){vfunc_called(this, "_ZN6S206C43v94Ev");}
void  S206C4 ::v95(){vfunc_called(this, "_ZN6S206C43v95Ev");}
void  S206C4 ::v96(){vfunc_called(this, "_ZN6S206C43v96Ev");}
void  S206C4 ::v97(){vfunc_called(this, "_ZN6S206C43v97Ev");}
void  S206C4 ::v98(){vfunc_called(this, "_ZN6S206C43v98Ev");}
void  S206C4 ::v99(){vfunc_called(this, "_ZN6S206C43v99Ev");}
void  S206C4 ::v100(){vfunc_called(this, "_ZN6S206C44v100Ev");}
void  S206C4 ::v101(){vfunc_called(this, "_ZN6S206C44v101Ev");}
void  S206C4 ::v102(){vfunc_called(this, "_ZN6S206C44v102Ev");}
void  S206C4 ::v103(){vfunc_called(this, "_ZN6S206C44v103Ev");}
void  S206C4 ::v104(){vfunc_called(this, "_ZN6S206C44v104Ev");}
void  S206C4 ::v105(){vfunc_called(this, "_ZN6S206C44v105Ev");}
void  S206C4 ::v106(){vfunc_called(this, "_ZN6S206C44v106Ev");}
void  S206C4 ::v107(){vfunc_called(this, "_ZN6S206C44v107Ev");}
void  S206C4 ::v108(){vfunc_called(this, "_ZN6S206C44v108Ev");}
void  S206C4 ::v109(){vfunc_called(this, "_ZN6S206C44v109Ev");}
S206C4 ::S206C4(){ note_ctor("S206C4", this);} // tgen

static void Test_S206C4()
{
  extern Class_Descriptor cd_S206C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(35,50)];
    init_test(&cd_S206C4, buf);
    S206C4 *dp, &lv = *(dp=new (buf) S206C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,196), "sizeof(S206C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S206C4)");
    check_base_class_offset(lv, (S206C6*)(S206C5*), 0, "S206C4");
    check_base_class_offset(lv, (S206C5*), 0, "S206C4");
    set_bf_and_test(lv, s206c4f0, ABISELECT(188,132), 0, 1, 1, "S206C4");
    set_bf_and_test(lv, s206c4f1, ABISELECT(188,132), 1, 1, 1, "S206C4");
    set_bf_and_test(lv, s206c4f2, ABISELECT(188,132), 2, 1, 1, "S206C4");
    check_field_offset(lv, s206c4f3, ABISELECT(192,136), "S206C4.s206c4f3");
    check_field_offset(lv, s206c4f4, ABISELECT(208,148), "S206C4.s206c4f4");
    check_field_offset(lv, s206c4f5, ABISELECT(224,160), "S206C4.s206c4f5");
    check_field_offset(lv, s206c4f6, ABISELECT(240,172), "S206C4.s206c4f6");
    check_field_offset(lv, s206c4f7, ABISELECT(256,184), "S206C4.s206c4f7");
    test_class_info(&lv, &cd_S206C4);
    dp->~S206C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS206C4(Test_S206C4, "S206C4", ABISELECT(272,196));

#else // __cplusplus

extern void _ZN6S206C4C1Ev();
extern void _ZN6S206C4D1Ev();
Name_Map name_map_S206C4[] = {
  NSPAIR(_ZN6S206C4C1Ev),
  NSPAIR(_ZN6S206C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S206C6;
extern VTBL_ENTRY _ZTI6S206C6[];
extern  VTBL_ENTRY _ZTV6S206C6[];
extern Class_Descriptor cd_S206C5;
extern VTBL_ENTRY _ZTI6S206C5[];
extern  VTBL_ENTRY _ZTV6S206C5[];
static Base_Class bases_S206C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S206C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S206C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S206C4[];
extern void _ZN6S206C4D1Ev();
extern void _ZN6S206C4D0Ev();
extern void _ZN6S206C62v4Ev();
extern void _ZN6S206C62v5Ev();
extern void _ZN6S206C62v6Ev();
extern void _ZN6S206C62v7Ev();
extern void _ZN6S206C62v8Ev();
extern void _ZN6S206C62v9Ev();
extern void _ZN6S206C63v10Ev();
extern void _ZN6S206C63v11Ev();
extern void _ZN6S206C63v12Ev();
extern void _ZN6S206C63v13Ev();
extern void _ZN6S206C63v14Ev();
extern void _ZN6S206C63v15Ev();
extern void _ZN6S206C63v16Ev();
extern void _ZN6S206C63v17Ev();
extern void _ZN6S206C63v18Ev();
extern void _ZN6S206C63v19Ev();
extern void _ZN6S206C63v20Ev();
extern void _ZN6S206C63v21Ev();
extern void _ZN6S206C63v22Ev();
extern void _ZN6S206C63v23Ev();
extern void _ZN6S206C63v24Ev();
extern void _ZN6S206C63v25Ev();
extern void _ZN6S206C63v26Ev();
extern void _ZN6S206C63v27Ev();
extern void _ZN6S206C63v28Ev();
extern void _ZN6S206C63v29Ev();
extern void _ZN6S206C63v30Ev();
extern void _ZN6S206C63v31Ev();
extern void _ZN6S206C63v32Ev();
extern void _ZN6S206C63v33Ev();
extern void _ZN6S206C63v34Ev();
extern void _ZN6S206C63v35Ev();
extern void _ZN6S206C63v36Ev();
extern void _ZN6S206C63v37Ev();
extern void _ZN6S206C63v38Ev();
extern void _ZN6S206C63v39Ev();
extern void _ZN6S206C63v40Ev();
extern void _ZN6S206C63v41Ev();
extern void _ZN6S206C63v42Ev();
extern void _ZN6S206C63v43Ev();
extern void _ZN6S206C63v44Ev();
extern void _ZN6S206C63v45Ev();
extern void _ZN6S206C63v46Ev();
extern void _ZN6S206C63v47Ev();
extern void _ZN6S206C63v48Ev();
extern void _ZN6S206C63v49Ev();
extern void _ZN6S206C63v50Ev();
extern void _ZN6S206C63v51Ev();
extern void _ZN6S206C63v52Ev();
extern void _ZN6S206C63v53Ev();
extern void _ZN6S206C63v54Ev();
extern void _ZN6S206C63v55Ev();
extern void _ZN6S206C63v56Ev();
extern void _ZN6S206C63v57Ev();
extern void _ZN6S206C63v58Ev();
extern void _ZN6S206C63v59Ev();
extern void _ZN6S206C63v60Ev();
extern void _ZN6S206C63v61Ev();
extern void _ZN6S206C63v62Ev();
extern void _ZN6S206C63v63Ev();
extern void _ZN6S206C63v64Ev();
extern void _ZN6S206C63v65Ev();
extern void _ZN6S206C63v66Ev();
extern void _ZN6S206C63v67Ev();
extern void _ZN6S206C53v68Ev();
extern void _ZN6S206C53v69Ev();
extern void _ZN6S206C53v70Ev();
extern void _ZN6S206C53v71Ev();
extern void _ZN6S206C53v72Ev();
extern void _ZN6S206C53v73Ev();
extern void _ZN6S206C53v74Ev();
extern void _ZN6S206C53v75Ev();
extern void _ZN6S206C53v76Ev();
extern void _ZN6S206C53v77Ev();
extern void _ZN6S206C53v78Ev();
extern void _ZN6S206C53v79Ev();
extern void _ZN6S206C53v80Ev();
extern void _ZN6S206C53v81Ev();
extern void _ZN6S206C53v82Ev();
extern void _ZN6S206C53v83Ev();
extern void _ZN6S206C53v84Ev();
extern void _ZN6S206C53v85Ev();
extern void _ZN6S206C53v86Ev();
extern void _ZN6S206C53v87Ev();
extern void _ZN6S206C53v88Ev();
extern void _ZN6S206C53v89Ev();
extern void _ZN6S206C43v90Ev();
extern void _ZN6S206C43v91Ev();
extern void _ZN6S206C43v92Ev();
extern void _ZN6S206C43v93Ev();
extern void _ZN6S206C43v94Ev();
extern void _ZN6S206C43v95Ev();
extern void _ZN6S206C43v96Ev();
extern void _ZN6S206C43v97Ev();
extern void _ZN6S206C43v98Ev();
extern void _ZN6S206C43v99Ev();
extern void _ZN6S206C44v100Ev();
extern void _ZN6S206C44v101Ev();
extern void _ZN6S206C44v102Ev();
extern void _ZN6S206C44v103Ev();
extern void _ZN6S206C44v104Ev();
extern void _ZN6S206C44v105Ev();
extern void _ZN6S206C44v106Ev();
extern void _ZN6S206C44v107Ev();
extern void _ZN6S206C44v108Ev();
extern void _ZN6S206C44v109Ev();
static  VTBL_ENTRY vtc_S206C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S206C4[0]),
  (VTBL_ENTRY)&_ZN6S206C4D1Ev,
  (VTBL_ENTRY)&_ZN6S206C4D0Ev,
  (VTBL_ENTRY)&_ZN6S206C62v4Ev,
  (VTBL_ENTRY)&_ZN6S206C62v5Ev,
  (VTBL_ENTRY)&_ZN6S206C62v6Ev,
  (VTBL_ENTRY)&_ZN6S206C62v7Ev,
  (VTBL_ENTRY)&_ZN6S206C62v8Ev,
  (VTBL_ENTRY)&_ZN6S206C62v9Ev,
  (VTBL_ENTRY)&_ZN6S206C63v10Ev,
  (VTBL_ENTRY)&_ZN6S206C63v11Ev,
  (VTBL_ENTRY)&_ZN6S206C63v12Ev,
  (VTBL_ENTRY)&_ZN6S206C63v13Ev,
  (VTBL_ENTRY)&_ZN6S206C63v14Ev,
  (VTBL_ENTRY)&_ZN6S206C63v15Ev,
  (VTBL_ENTRY)&_ZN6S206C63v16Ev,
  (VTBL_ENTRY)&_ZN6S206C63v17Ev,
  (VTBL_ENTRY)&_ZN6S206C63v18Ev,
  (VTBL_ENTRY)&_ZN6S206C63v19Ev,
  (VTBL_ENTRY)&_ZN6S206C63v20Ev,
  (VTBL_ENTRY)&_ZN6S206C63v21Ev,
  (VTBL_ENTRY)&_ZN6S206C63v22Ev,
  (VTBL_ENTRY)&_ZN6S206C63v23Ev,
  (VTBL_ENTRY)&_ZN6S206C63v24Ev,
  (VTBL_ENTRY)&_ZN6S206C63v25Ev,
  (VTBL_ENTRY)&_ZN6S206C63v26Ev,
  (VTBL_ENTRY)&_ZN6S206C63v27Ev,
  (VTBL_ENTRY)&_ZN6S206C63v28Ev,
  (VTBL_ENTRY)&_ZN6S206C63v29Ev,
  (VTBL_ENTRY)&_ZN6S206C63v30Ev,
  (VTBL_ENTRY)&_ZN6S206C63v31Ev,
  (VTBL_ENTRY)&_ZN6S206C63v32Ev,
  (VTBL_ENTRY)&_ZN6S206C63v33Ev,
  (VTBL_ENTRY)&_ZN6S206C63v34Ev,
  (VTBL_ENTRY)&_ZN6S206C63v35Ev,
  (VTBL_ENTRY)&_ZN6S206C63v36Ev,
  (VTBL_ENTRY)&_ZN6S206C63v37Ev,
  (VTBL_ENTRY)&_ZN6S206C63v38Ev,
  (VTBL_ENTRY)&_ZN6S206C63v39Ev,
  (VTBL_ENTRY)&_ZN6S206C63v40Ev,
  (VTBL_ENTRY)&_ZN6S206C63v41Ev,
  (VTBL_ENTRY)&_ZN6S206C63v42Ev,
  (VTBL_ENTRY)&_ZN6S206C63v43Ev,
  (VTBL_ENTRY)&_ZN6S206C63v44Ev,
  (VTBL_ENTRY)&_ZN6S206C63v45Ev,
  (VTBL_ENTRY)&_ZN6S206C63v46Ev,
  (VTBL_ENTRY)&_ZN6S206C63v47Ev,
  (VTBL_ENTRY)&_ZN6S206C63v48Ev,
  (VTBL_ENTRY)&_ZN6S206C63v49Ev,
  (VTBL_ENTRY)&_ZN6S206C63v50Ev,
  (VTBL_ENTRY)&_ZN6S206C63v51Ev,
  (VTBL_ENTRY)&_ZN6S206C63v52Ev,
  (VTBL_ENTRY)&_ZN6S206C63v53Ev,
  (VTBL_ENTRY)&_ZN6S206C63v54Ev,
  (VTBL_ENTRY)&_ZN6S206C63v55Ev,
  (VTBL_ENTRY)&_ZN6S206C63v56Ev,
  (VTBL_ENTRY)&_ZN6S206C63v57Ev,
  (VTBL_ENTRY)&_ZN6S206C63v58Ev,
  (VTBL_ENTRY)&_ZN6S206C63v59Ev,
  (VTBL_ENTRY)&_ZN6S206C63v60Ev,
  (VTBL_ENTRY)&_ZN6S206C63v61Ev,
  (VTBL_ENTRY)&_ZN6S206C63v62Ev,
  (VTBL_ENTRY)&_ZN6S206C63v63Ev,
  (VTBL_ENTRY)&_ZN6S206C63v64Ev,
  (VTBL_ENTRY)&_ZN6S206C63v65Ev,
  (VTBL_ENTRY)&_ZN6S206C63v66Ev,
  (VTBL_ENTRY)&_ZN6S206C63v67Ev,
  (VTBL_ENTRY)&_ZN6S206C53v68Ev,
  (VTBL_ENTRY)&_ZN6S206C53v69Ev,
  (VTBL_ENTRY)&_ZN6S206C53v70Ev,
  (VTBL_ENTRY)&_ZN6S206C53v71Ev,
  (VTBL_ENTRY)&_ZN6S206C53v72Ev,
  (VTBL_ENTRY)&_ZN6S206C53v73Ev,
  (VTBL_ENTRY)&_ZN6S206C53v74Ev,
  (VTBL_ENTRY)&_ZN6S206C53v75Ev,
  (VTBL_ENTRY)&_ZN6S206C53v76Ev,
  (VTBL_ENTRY)&_ZN6S206C53v77Ev,
  (VTBL_ENTRY)&_ZN6S206C53v78Ev,
  (VTBL_ENTRY)&_ZN6S206C53v79Ev,
  (VTBL_ENTRY)&_ZN6S206C53v80Ev,
  (VTBL_ENTRY)&_ZN6S206C53v81Ev,
  (VTBL_ENTRY)&_ZN6S206C53v82Ev,
  (VTBL_ENTRY)&_ZN6S206C53v83Ev,
  (VTBL_ENTRY)&_ZN6S206C53v84Ev,
  (VTBL_ENTRY)&_ZN6S206C53v85Ev,
  (VTBL_ENTRY)&_ZN6S206C53v86Ev,
  (VTBL_ENTRY)&_ZN6S206C53v87Ev,
  (VTBL_ENTRY)&_ZN6S206C53v88Ev,
  (VTBL_ENTRY)&_ZN6S206C53v89Ev,
  (VTBL_ENTRY)&_ZN6S206C43v90Ev,
  (VTBL_ENTRY)&_ZN6S206C43v91Ev,
  (VTBL_ENTRY)&_ZN6S206C43v92Ev,
  (VTBL_ENTRY)&_ZN6S206C43v93Ev,
  (VTBL_ENTRY)&_ZN6S206C43v94Ev,
  (VTBL_ENTRY)&_ZN6S206C43v95Ev,
  (VTBL_ENTRY)&_ZN6S206C43v96Ev,
  (VTBL_ENTRY)&_ZN6S206C43v97Ev,
  (VTBL_ENTRY)&_ZN6S206C43v98Ev,
  (VTBL_ENTRY)&_ZN6S206C43v99Ev,
  (VTBL_ENTRY)&_ZN6S206C44v100Ev,
  (VTBL_ENTRY)&_ZN6S206C44v101Ev,
  (VTBL_ENTRY)&_ZN6S206C44v102Ev,
  (VTBL_ENTRY)&_ZN6S206C44v103Ev,
  (VTBL_ENTRY)&_ZN6S206C44v104Ev,
  (VTBL_ENTRY)&_ZN6S206C44v105Ev,
  (VTBL_ENTRY)&_ZN6S206C44v106Ev,
  (VTBL_ENTRY)&_ZN6S206C44v107Ev,
  (VTBL_ENTRY)&_ZN6S206C44v108Ev,
  (VTBL_ENTRY)&_ZN6S206C44v109Ev,
};
extern VTBL_ENTRY _ZTI6S206C4[];
extern  VTBL_ENTRY _ZTV6S206C4[];
Class_Descriptor cd_S206C4 = {  "S206C4", // class name
  bases_S206C4, 2,
  &(vtc_S206C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI6S206C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S206C4),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S206C3  : S206C4 {
  ::S1409C5_nt s206c3f0;
  unsigned int s206c3f1:1;
  ::S1409C12 s206c3f2;
  virtual  ~S206C3(); // _ZN6S206C3D1Ev
  virtual void  v110(); // _ZN6S206C34v110Ev
  virtual void  v111(); // _ZN6S206C34v111Ev
  virtual void  v112(); // _ZN6S206C34v112Ev
  virtual void  v113(); // _ZN6S206C34v113Ev
  S206C3(); // tgen
};
//SIG(-1 S206C3) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} FC17{ BC18{ BC9}} Fi[3]} vd v1 v2 v3 v4 FC5 Fi:1 FC19{ BC20{ BC9}}}


 S206C3 ::~S206C3(){ note_dtor("S206C3", this);}
void  S206C3 ::v110(){vfunc_called(this, "_ZN6S206C34v110Ev");}
void  S206C3 ::v111(){vfunc_called(this, "_ZN6S206C34v111Ev");}
void  S206C3 ::v112(){vfunc_called(this, "_ZN6S206C34v112Ev");}
void  S206C3 ::v113(){vfunc_called(this, "_ZN6S206C34v113Ev");}
S206C3 ::S206C3(){ note_ctor("S206C3", this);} // tgen

static void Test_S206C3()
{
  extern Class_Descriptor cd_S206C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(38,56)];
    init_test(&cd_S206C3, buf);
    S206C3 *dp, &lv = *(dp=new (buf) S206C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(296,220), "sizeof(S206C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S206C3)");
    check_base_class_offset(lv, (S206C6*)(S206C5*)(S206C4*), 0, "S206C3");
    check_base_class_offset(lv, (S206C5*)(S206C4*), 0, "S206C3");
    check_base_class_offset(lv, (S206C4*), 0, "S206C3");
    check_field_offset(lv, s206c3f0, ABISELECT(268,196), "S206C3.s206c3f0");
    set_bf_and_test(lv, s206c3f1, ABISELECT(276,204), 0, 1, 1, "S206C3");
    check_field_offset(lv, s206c3f2, ABISELECT(280,208), "S206C3.s206c3f2");
    test_class_info(&lv, &cd_S206C3);
    dp->~S206C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS206C3(Test_S206C3, "S206C3", ABISELECT(296,220));

#else // __cplusplus

extern void _ZN6S206C3C1Ev();
extern void _ZN6S206C3D1Ev();
Name_Map name_map_S206C3[] = {
  NSPAIR(_ZN6S206C3C1Ev),
  NSPAIR(_ZN6S206C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S206C6;
extern VTBL_ENTRY _ZTI6S206C6[];
extern  VTBL_ENTRY _ZTV6S206C6[];
extern Class_Descriptor cd_S206C5;
extern VTBL_ENTRY _ZTI6S206C5[];
extern  VTBL_ENTRY _ZTV6S206C5[];
extern Class_Descriptor cd_S206C4;
extern VTBL_ENTRY _ZTI6S206C4[];
extern  VTBL_ENTRY _ZTV6S206C4[];
static Base_Class bases_S206C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S206C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S206C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S206C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S206C3[];
extern void _ZN6S206C3D1Ev();
extern void _ZN6S206C3D0Ev();
extern void _ZN6S206C62v4Ev();
extern void _ZN6S206C62v5Ev();
extern void _ZN6S206C62v6Ev();
extern void _ZN6S206C62v7Ev();
extern void _ZN6S206C62v8Ev();
extern void _ZN6S206C62v9Ev();
extern void _ZN6S206C63v10Ev();
extern void _ZN6S206C63v11Ev();
extern void _ZN6S206C63v12Ev();
extern void _ZN6S206C63v13Ev();
extern void _ZN6S206C63v14Ev();
extern void _ZN6S206C63v15Ev();
extern void _ZN6S206C63v16Ev();
extern void _ZN6S206C63v17Ev();
extern void _ZN6S206C63v18Ev();
extern void _ZN6S206C63v19Ev();
extern void _ZN6S206C63v20Ev();
extern void _ZN6S206C63v21Ev();
extern void _ZN6S206C63v22Ev();
extern void _ZN6S206C63v23Ev();
extern void _ZN6S206C63v24Ev();
extern void _ZN6S206C63v25Ev();
extern void _ZN6S206C63v26Ev();
extern void _ZN6S206C63v27Ev();
extern void _ZN6S206C63v28Ev();
extern void _ZN6S206C63v29Ev();
extern void _ZN6S206C63v30Ev();
extern void _ZN6S206C63v31Ev();
extern void _ZN6S206C63v32Ev();
extern void _ZN6S206C63v33Ev();
extern void _ZN6S206C63v34Ev();
extern void _ZN6S206C63v35Ev();
extern void _ZN6S206C63v36Ev();
extern void _ZN6S206C63v37Ev();
extern void _ZN6S206C63v38Ev();
extern void _ZN6S206C63v39Ev();
extern void _ZN6S206C63v40Ev();
extern void _ZN6S206C63v41Ev();
extern void _ZN6S206C63v42Ev();
extern void _ZN6S206C63v43Ev();
extern void _ZN6S206C63v44Ev();
extern void _ZN6S206C63v45Ev();
extern void _ZN6S206C63v46Ev();
extern void _ZN6S206C63v47Ev();
extern void _ZN6S206C63v48Ev();
extern void _ZN6S206C63v49Ev();
extern void _ZN6S206C63v50Ev();
extern void _ZN6S206C63v51Ev();
extern void _ZN6S206C63v52Ev();
extern void _ZN6S206C63v53Ev();
extern void _ZN6S206C63v54Ev();
extern void _ZN6S206C63v55Ev();
extern void _ZN6S206C63v56Ev();
extern void _ZN6S206C63v57Ev();
extern void _ZN6S206C63v58Ev();
extern void _ZN6S206C63v59Ev();
extern void _ZN6S206C63v60Ev();
extern void _ZN6S206C63v61Ev();
extern void _ZN6S206C63v62Ev();
extern void _ZN6S206C63v63Ev();
extern void _ZN6S206C63v64Ev();
extern void _ZN6S206C63v65Ev();
extern void _ZN6S206C63v66Ev();
extern void _ZN6S206C63v67Ev();
extern void _ZN6S206C53v68Ev();
extern void _ZN6S206C53v69Ev();
extern void _ZN6S206C53v70Ev();
extern void _ZN6S206C53v71Ev();
extern void _ZN6S206C53v72Ev();
extern void _ZN6S206C53v73Ev();
extern void _ZN6S206C53v74Ev();
extern void _ZN6S206C53v75Ev();
extern void _ZN6S206C53v76Ev();
extern void _ZN6S206C53v77Ev();
extern void _ZN6S206C53v78Ev();
extern void _ZN6S206C53v79Ev();
extern void _ZN6S206C53v80Ev();
extern void _ZN6S206C53v81Ev();
extern void _ZN6S206C53v82Ev();
extern void _ZN6S206C53v83Ev();
extern void _ZN6S206C53v84Ev();
extern void _ZN6S206C53v85Ev();
extern void _ZN6S206C53v86Ev();
extern void _ZN6S206C53v87Ev();
extern void _ZN6S206C53v88Ev();
extern void _ZN6S206C53v89Ev();
extern void _ZN6S206C43v90Ev();
extern void _ZN6S206C43v91Ev();
extern void _ZN6S206C43v92Ev();
extern void _ZN6S206C43v93Ev();
extern void _ZN6S206C43v94Ev();
extern void _ZN6S206C43v95Ev();
extern void _ZN6S206C43v96Ev();
extern void _ZN6S206C43v97Ev();
extern void _ZN6S206C43v98Ev();
extern void _ZN6S206C43v99Ev();
extern void _ZN6S206C44v100Ev();
extern void _ZN6S206C44v101Ev();
extern void _ZN6S206C44v102Ev();
extern void _ZN6S206C44v103Ev();
extern void _ZN6S206C44v104Ev();
extern void _ZN6S206C44v105Ev();
extern void _ZN6S206C44v106Ev();
extern void _ZN6S206C44v107Ev();
extern void _ZN6S206C44v108Ev();
extern void _ZN6S206C44v109Ev();
extern void _ZN6S206C34v110Ev();
extern void _ZN6S206C34v111Ev();
extern void _ZN6S206C34v112Ev();
extern void _ZN6S206C34v113Ev();
static  VTBL_ENTRY vtc_S206C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S206C3[0]),
  (VTBL_ENTRY)&_ZN6S206C3D1Ev,
  (VTBL_ENTRY)&_ZN6S206C3D0Ev,
  (VTBL_ENTRY)&_ZN6S206C62v4Ev,
  (VTBL_ENTRY)&_ZN6S206C62v5Ev,
  (VTBL_ENTRY)&_ZN6S206C62v6Ev,
  (VTBL_ENTRY)&_ZN6S206C62v7Ev,
  (VTBL_ENTRY)&_ZN6S206C62v8Ev,
  (VTBL_ENTRY)&_ZN6S206C62v9Ev,
  (VTBL_ENTRY)&_ZN6S206C63v10Ev,
  (VTBL_ENTRY)&_ZN6S206C63v11Ev,
  (VTBL_ENTRY)&_ZN6S206C63v12Ev,
  (VTBL_ENTRY)&_ZN6S206C63v13Ev,
  (VTBL_ENTRY)&_ZN6S206C63v14Ev,
  (VTBL_ENTRY)&_ZN6S206C63v15Ev,
  (VTBL_ENTRY)&_ZN6S206C63v16Ev,
  (VTBL_ENTRY)&_ZN6S206C63v17Ev,
  (VTBL_ENTRY)&_ZN6S206C63v18Ev,
  (VTBL_ENTRY)&_ZN6S206C63v19Ev,
  (VTBL_ENTRY)&_ZN6S206C63v20Ev,
  (VTBL_ENTRY)&_ZN6S206C63v21Ev,
  (VTBL_ENTRY)&_ZN6S206C63v22Ev,
  (VTBL_ENTRY)&_ZN6S206C63v23Ev,
  (VTBL_ENTRY)&_ZN6S206C63v24Ev,
  (VTBL_ENTRY)&_ZN6S206C63v25Ev,
  (VTBL_ENTRY)&_ZN6S206C63v26Ev,
  (VTBL_ENTRY)&_ZN6S206C63v27Ev,
  (VTBL_ENTRY)&_ZN6S206C63v28Ev,
  (VTBL_ENTRY)&_ZN6S206C63v29Ev,
  (VTBL_ENTRY)&_ZN6S206C63v30Ev,
  (VTBL_ENTRY)&_ZN6S206C63v31Ev,
  (VTBL_ENTRY)&_ZN6S206C63v32Ev,
  (VTBL_ENTRY)&_ZN6S206C63v33Ev,
  (VTBL_ENTRY)&_ZN6S206C63v34Ev,
  (VTBL_ENTRY)&_ZN6S206C63v35Ev,
  (VTBL_ENTRY)&_ZN6S206C63v36Ev,
  (VTBL_ENTRY)&_ZN6S206C63v37Ev,
  (VTBL_ENTRY)&_ZN6S206C63v38Ev,
  (VTBL_ENTRY)&_ZN6S206C63v39Ev,
  (VTBL_ENTRY)&_ZN6S206C63v40Ev,
  (VTBL_ENTRY)&_ZN6S206C63v41Ev,
  (VTBL_ENTRY)&_ZN6S206C63v42Ev,
  (VTBL_ENTRY)&_ZN6S206C63v43Ev,
  (VTBL_ENTRY)&_ZN6S206C63v44Ev,
  (VTBL_ENTRY)&_ZN6S206C63v45Ev,
  (VTBL_ENTRY)&_ZN6S206C63v46Ev,
  (VTBL_ENTRY)&_ZN6S206C63v47Ev,
  (VTBL_ENTRY)&_ZN6S206C63v48Ev,
  (VTBL_ENTRY)&_ZN6S206C63v49Ev,
  (VTBL_ENTRY)&_ZN6S206C63v50Ev,
  (VTBL_ENTRY)&_ZN6S206C63v51Ev,
  (VTBL_ENTRY)&_ZN6S206C63v52Ev,
  (VTBL_ENTRY)&_ZN6S206C63v53Ev,
  (VTBL_ENTRY)&_ZN6S206C63v54Ev,
  (VTBL_ENTRY)&_ZN6S206C63v55Ev,
  (VTBL_ENTRY)&_ZN6S206C63v56Ev,
  (VTBL_ENTRY)&_ZN6S206C63v57Ev,
  (VTBL_ENTRY)&_ZN6S206C63v58Ev,
  (VTBL_ENTRY)&_ZN6S206C63v59Ev,
  (VTBL_ENTRY)&_ZN6S206C63v60Ev,
  (VTBL_ENTRY)&_ZN6S206C63v61Ev,
  (VTBL_ENTRY)&_ZN6S206C63v62Ev,
  (VTBL_ENTRY)&_ZN6S206C63v63Ev,
  (VTBL_ENTRY)&_ZN6S206C63v64Ev,
  (VTBL_ENTRY)&_ZN6S206C63v65Ev,
  (VTBL_ENTRY)&_ZN6S206C63v66Ev,
  (VTBL_ENTRY)&_ZN6S206C63v67Ev,
  (VTBL_ENTRY)&_ZN6S206C53v68Ev,
  (VTBL_ENTRY)&_ZN6S206C53v69Ev,
  (VTBL_ENTRY)&_ZN6S206C53v70Ev,
  (VTBL_ENTRY)&_ZN6S206C53v71Ev,
  (VTBL_ENTRY)&_ZN6S206C53v72Ev,
  (VTBL_ENTRY)&_ZN6S206C53v73Ev,
  (VTBL_ENTRY)&_ZN6S206C53v74Ev,
  (VTBL_ENTRY)&_ZN6S206C53v75Ev,
  (VTBL_ENTRY)&_ZN6S206C53v76Ev,
  (VTBL_ENTRY)&_ZN6S206C53v77Ev,
  (VTBL_ENTRY)&_ZN6S206C53v78Ev,
  (VTBL_ENTRY)&_ZN6S206C53v79Ev,
  (VTBL_ENTRY)&_ZN6S206C53v80Ev,
  (VTBL_ENTRY)&_ZN6S206C53v81Ev,
  (VTBL_ENTRY)&_ZN6S206C53v82Ev,
  (VTBL_ENTRY)&_ZN6S206C53v83Ev,
  (VTBL_ENTRY)&_ZN6S206C53v84Ev,
  (VTBL_ENTRY)&_ZN6S206C53v85Ev,
  (VTBL_ENTRY)&_ZN6S206C53v86Ev,
  (VTBL_ENTRY)&_ZN6S206C53v87Ev,
  (VTBL_ENTRY)&_ZN6S206C53v88Ev,
  (VTBL_ENTRY)&_ZN6S206C53v89Ev,
  (VTBL_ENTRY)&_ZN6S206C43v90Ev,
  (VTBL_ENTRY)&_ZN6S206C43v91Ev,
  (VTBL_ENTRY)&_ZN6S206C43v92Ev,
  (VTBL_ENTRY)&_ZN6S206C43v93Ev,
  (VTBL_ENTRY)&_ZN6S206C43v94Ev,
  (VTBL_ENTRY)&_ZN6S206C43v95Ev,
  (VTBL_ENTRY)&_ZN6S206C43v96Ev,
  (VTBL_ENTRY)&_ZN6S206C43v97Ev,
  (VTBL_ENTRY)&_ZN6S206C43v98Ev,
  (VTBL_ENTRY)&_ZN6S206C43v99Ev,
  (VTBL_ENTRY)&_ZN6S206C44v100Ev,
  (VTBL_ENTRY)&_ZN6S206C44v101Ev,
  (VTBL_ENTRY)&_ZN6S206C44v102Ev,
  (VTBL_ENTRY)&_ZN6S206C44v103Ev,
  (VTBL_ENTRY)&_ZN6S206C44v104Ev,
  (VTBL_ENTRY)&_ZN6S206C44v105Ev,
  (VTBL_ENTRY)&_ZN6S206C44v106Ev,
  (VTBL_ENTRY)&_ZN6S206C44v107Ev,
  (VTBL_ENTRY)&_ZN6S206C44v108Ev,
  (VTBL_ENTRY)&_ZN6S206C44v109Ev,
  (VTBL_ENTRY)&_ZN6S206C34v110Ev,
  (VTBL_ENTRY)&_ZN6S206C34v111Ev,
  (VTBL_ENTRY)&_ZN6S206C34v112Ev,
  (VTBL_ENTRY)&_ZN6S206C34v113Ev,
};
extern VTBL_ENTRY _ZTI6S206C3[];
extern  VTBL_ENTRY _ZTV6S206C3[];
Class_Descriptor cd_S206C3 = {  "S206C3", // class name
  bases_S206C3, 3,
  &(vtc_S206C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,220), // object size
  NSPAIRA(_ZTI6S206C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S206C3),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S206C2  : S206C3 {
  int s206c2f0;
  unsigned int s206c2f1:1;
  virtual  ~S206C2(); // _ZN6S206C2D1Ev
  virtual void  v114(); // _ZN6S206C24v114Ev
  virtual void  v115(); // _ZN6S206C24v115Ev
  virtual void  v116(); // _ZN6S206C24v116Ev
  virtual void  v117(); // _ZN6S206C24v117Ev
  virtual void  v118(); // _ZN6S206C24v118Ev
  virtual void  v119(); // _ZN6S206C24v119Ev
  virtual void  v120(); // _ZN6S206C24v120Ev
  virtual void  v121(); // _ZN6S206C24v121Ev
  S206C2(); // tgen
};
//SIG(-1 S206C2) C1{ BC2{ BC3{ BC4{ BC5{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} FC18{ BC19{ BC10}} Fi[3]} vd v115 v116 v117 v118 FC6 Fi:1 FC20{ BC21{ BC10}}} vd v1 v2 v3 v4 v5 v6 v7 v8 Fi Fi:1}


 S206C2 ::~S206C2(){ note_dtor("S206C2", this);}
void  S206C2 ::v114(){vfunc_called(this, "_ZN6S206C24v114Ev");}
void  S206C2 ::v115(){vfunc_called(this, "_ZN6S206C24v115Ev");}
void  S206C2 ::v116(){vfunc_called(this, "_ZN6S206C24v116Ev");}
void  S206C2 ::v117(){vfunc_called(this, "_ZN6S206C24v117Ev");}
void  S206C2 ::v118(){vfunc_called(this, "_ZN6S206C24v118Ev");}
void  S206C2 ::v119(){vfunc_called(this, "_ZN6S206C24v119Ev");}
void  S206C2 ::v120(){vfunc_called(this, "_ZN6S206C24v120Ev");}
void  S206C2 ::v121(){vfunc_called(this, "_ZN6S206C24v121Ev");}
S206C2 ::S206C2(){ note_ctor("S206C2", this);} // tgen

static void Test_S206C2()
{
  extern Class_Descriptor cd_S206C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(39,58)];
    init_test(&cd_S206C2, buf);
    S206C2 *dp, &lv = *(dp=new (buf) S206C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,228), "sizeof(S206C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S206C2)");
    check_base_class_offset(lv, (S206C6*)(S206C5*)(S206C4*)(S206C3*), 0, "S206C2");
    check_base_class_offset(lv, (S206C5*)(S206C4*)(S206C3*), 0, "S206C2");
    check_base_class_offset(lv, (S206C4*)(S206C3*), 0, "S206C2");
    check_base_class_offset(lv, (S206C3*), 0, "S206C2");
    check_field_offset(lv, s206c2f0, ABISELECT(296,220), "S206C2.s206c2f0");
    set_bf_and_test(lv, s206c2f1, ABISELECT(300,224), 0, 1, 1, "S206C2");
    test_class_info(&lv, &cd_S206C2);
    dp->~S206C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS206C2(Test_S206C2, "S206C2", ABISELECT(304,228));

#else // __cplusplus

extern void _ZN6S206C2C1Ev();
extern void _ZN6S206C2D1Ev();
Name_Map name_map_S206C2[] = {
  NSPAIR(_ZN6S206C2C1Ev),
  NSPAIR(_ZN6S206C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S206C6;
extern VTBL_ENTRY _ZTI6S206C6[];
extern  VTBL_ENTRY _ZTV6S206C6[];
extern Class_Descriptor cd_S206C5;
extern VTBL_ENTRY _ZTI6S206C5[];
extern  VTBL_ENTRY _ZTV6S206C5[];
extern Class_Descriptor cd_S206C4;
extern VTBL_ENTRY _ZTI6S206C4[];
extern  VTBL_ENTRY _ZTV6S206C4[];
extern Class_Descriptor cd_S206C3;
extern VTBL_ENTRY _ZTI6S206C3[];
extern  VTBL_ENTRY _ZTV6S206C3[];
static Base_Class bases_S206C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S206C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S206C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S206C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S206C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S206C2[];
extern void _ZN6S206C2D1Ev();
extern void _ZN6S206C2D0Ev();
extern void _ZN6S206C62v4Ev();
extern void _ZN6S206C62v5Ev();
extern void _ZN6S206C62v6Ev();
extern void _ZN6S206C62v7Ev();
extern void _ZN6S206C62v8Ev();
extern void _ZN6S206C62v9Ev();
extern void _ZN6S206C63v10Ev();
extern void _ZN6S206C63v11Ev();
extern void _ZN6S206C63v12Ev();
extern void _ZN6S206C63v13Ev();
extern void _ZN6S206C63v14Ev();
extern void _ZN6S206C63v15Ev();
extern void _ZN6S206C63v16Ev();
extern void _ZN6S206C63v17Ev();
extern void _ZN6S206C63v18Ev();
extern void _ZN6S206C63v19Ev();
extern void _ZN6S206C63v20Ev();
extern void _ZN6S206C63v21Ev();
extern void _ZN6S206C63v22Ev();
extern void _ZN6S206C63v23Ev();
extern void _ZN6S206C63v24Ev();
extern void _ZN6S206C63v25Ev();
extern void _ZN6S206C63v26Ev();
extern void _ZN6S206C63v27Ev();
extern void _ZN6S206C63v28Ev();
extern void _ZN6S206C63v29Ev();
extern void _ZN6S206C63v30Ev();
extern void _ZN6S206C63v31Ev();
extern void _ZN6S206C63v32Ev();
extern void _ZN6S206C63v33Ev();
extern void _ZN6S206C63v34Ev();
extern void _ZN6S206C63v35Ev();
extern void _ZN6S206C63v36Ev();
extern void _ZN6S206C63v37Ev();
extern void _ZN6S206C63v38Ev();
extern void _ZN6S206C63v39Ev();
extern void _ZN6S206C63v40Ev();
extern void _ZN6S206C63v41Ev();
extern void _ZN6S206C63v42Ev();
extern void _ZN6S206C63v43Ev();
extern void _ZN6S206C63v44Ev();
extern void _ZN6S206C63v45Ev();
extern void _ZN6S206C63v46Ev();
extern void _ZN6S206C63v47Ev();
extern void _ZN6S206C63v48Ev();
extern void _ZN6S206C63v49Ev();
extern void _ZN6S206C63v50Ev();
extern void _ZN6S206C63v51Ev();
extern void _ZN6S206C63v52Ev();
extern void _ZN6S206C63v53Ev();
extern void _ZN6S206C63v54Ev();
extern void _ZN6S206C63v55Ev();
extern void _ZN6S206C63v56Ev();
extern void _ZN6S206C63v57Ev();
extern void _ZN6S206C63v58Ev();
extern void _ZN6S206C63v59Ev();
extern void _ZN6S206C63v60Ev();
extern void _ZN6S206C63v61Ev();
extern void _ZN6S206C63v62Ev();
extern void _ZN6S206C63v63Ev();
extern void _ZN6S206C63v64Ev();
extern void _ZN6S206C63v65Ev();
extern void _ZN6S206C63v66Ev();
extern void _ZN6S206C63v67Ev();
extern void _ZN6S206C53v68Ev();
extern void _ZN6S206C53v69Ev();
extern void _ZN6S206C53v70Ev();
extern void _ZN6S206C53v71Ev();
extern void _ZN6S206C53v72Ev();
extern void _ZN6S206C53v73Ev();
extern void _ZN6S206C53v74Ev();
extern void _ZN6S206C53v75Ev();
extern void _ZN6S206C53v76Ev();
extern void _ZN6S206C53v77Ev();
extern void _ZN6S206C53v78Ev();
extern void _ZN6S206C53v79Ev();
extern void _ZN6S206C53v80Ev();
extern void _ZN6S206C53v81Ev();
extern void _ZN6S206C53v82Ev();
extern void _ZN6S206C53v83Ev();
extern void _ZN6S206C53v84Ev();
extern void _ZN6S206C53v85Ev();
extern void _ZN6S206C53v86Ev();
extern void _ZN6S206C53v87Ev();
extern void _ZN6S206C53v88Ev();
extern void _ZN6S206C53v89Ev();
extern void _ZN6S206C43v90Ev();
extern void _ZN6S206C43v91Ev();
extern void _ZN6S206C43v92Ev();
extern void _ZN6S206C43v93Ev();
extern void _ZN6S206C43v94Ev();
extern void _ZN6S206C43v95Ev();
extern void _ZN6S206C43v96Ev();
extern void _ZN6S206C43v97Ev();
extern void _ZN6S206C43v98Ev();
extern void _ZN6S206C43v99Ev();
extern void _ZN6S206C44v100Ev();
extern void _ZN6S206C44v101Ev();
extern void _ZN6S206C44v102Ev();
extern void _ZN6S206C44v103Ev();
extern void _ZN6S206C44v104Ev();
extern void _ZN6S206C44v105Ev();
extern void _ZN6S206C44v106Ev();
extern void _ZN6S206C44v107Ev();
extern void _ZN6S206C44v108Ev();
extern void _ZN6S206C44v109Ev();
extern void _ZN6S206C34v110Ev();
extern void _ZN6S206C34v111Ev();
extern void _ZN6S206C34v112Ev();
extern void _ZN6S206C34v113Ev();
extern void _ZN6S206C24v114Ev();
extern void _ZN6S206C24v115Ev();
extern void _ZN6S206C24v116Ev();
extern void _ZN6S206C24v117Ev();
extern void _ZN6S206C24v118Ev();
extern void _ZN6S206C24v119Ev();
extern void _ZN6S206C24v120Ev();
extern void _ZN6S206C24v121Ev();
static  VTBL_ENTRY vtc_S206C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S206C2[0]),
  (VTBL_ENTRY)&_ZN6S206C2D1Ev,
  (VTBL_ENTRY)&_ZN6S206C2D0Ev,
  (VTBL_ENTRY)&_ZN6S206C62v4Ev,
  (VTBL_ENTRY)&_ZN6S206C62v5Ev,
  (VTBL_ENTRY)&_ZN6S206C62v6Ev,
  (VTBL_ENTRY)&_ZN6S206C62v7Ev,
  (VTBL_ENTRY)&_ZN6S206C62v8Ev,
  (VTBL_ENTRY)&_ZN6S206C62v9Ev,
  (VTBL_ENTRY)&_ZN6S206C63v10Ev,
  (VTBL_ENTRY)&_ZN6S206C63v11Ev,
  (VTBL_ENTRY)&_ZN6S206C63v12Ev,
  (VTBL_ENTRY)&_ZN6S206C63v13Ev,
  (VTBL_ENTRY)&_ZN6S206C63v14Ev,
  (VTBL_ENTRY)&_ZN6S206C63v15Ev,
  (VTBL_ENTRY)&_ZN6S206C63v16Ev,
  (VTBL_ENTRY)&_ZN6S206C63v17Ev,
  (VTBL_ENTRY)&_ZN6S206C63v18Ev,
  (VTBL_ENTRY)&_ZN6S206C63v19Ev,
  (VTBL_ENTRY)&_ZN6S206C63v20Ev,
  (VTBL_ENTRY)&_ZN6S206C63v21Ev,
  (VTBL_ENTRY)&_ZN6S206C63v22Ev,
  (VTBL_ENTRY)&_ZN6S206C63v23Ev,
  (VTBL_ENTRY)&_ZN6S206C63v24Ev,
  (VTBL_ENTRY)&_ZN6S206C63v25Ev,
  (VTBL_ENTRY)&_ZN6S206C63v26Ev,
  (VTBL_ENTRY)&_ZN6S206C63v27Ev,
  (VTBL_ENTRY)&_ZN6S206C63v28Ev,
  (VTBL_ENTRY)&_ZN6S206C63v29Ev,
  (VTBL_ENTRY)&_ZN6S206C63v30Ev,
  (VTBL_ENTRY)&_ZN6S206C63v31Ev,
  (VTBL_ENTRY)&_ZN6S206C63v32Ev,
  (VTBL_ENTRY)&_ZN6S206C63v33Ev,
  (VTBL_ENTRY)&_ZN6S206C63v34Ev,
  (VTBL_ENTRY)&_ZN6S206C63v35Ev,
  (VTBL_ENTRY)&_ZN6S206C63v36Ev,
  (VTBL_ENTRY)&_ZN6S206C63v37Ev,
  (VTBL_ENTRY)&_ZN6S206C63v38Ev,
  (VTBL_ENTRY)&_ZN6S206C63v39Ev,
  (VTBL_ENTRY)&_ZN6S206C63v40Ev,
  (VTBL_ENTRY)&_ZN6S206C63v41Ev,
  (VTBL_ENTRY)&_ZN6S206C63v42Ev,
  (VTBL_ENTRY)&_ZN6S206C63v43Ev,
  (VTBL_ENTRY)&_ZN6S206C63v44Ev,
  (VTBL_ENTRY)&_ZN6S206C63v45Ev,
  (VTBL_ENTRY)&_ZN6S206C63v46Ev,
  (VTBL_ENTRY)&_ZN6S206C63v47Ev,
  (VTBL_ENTRY)&_ZN6S206C63v48Ev,
  (VTBL_ENTRY)&_ZN6S206C63v49Ev,
  (VTBL_ENTRY)&_ZN6S206C63v50Ev,
  (VTBL_ENTRY)&_ZN6S206C63v51Ev,
  (VTBL_ENTRY)&_ZN6S206C63v52Ev,
  (VTBL_ENTRY)&_ZN6S206C63v53Ev,
  (VTBL_ENTRY)&_ZN6S206C63v54Ev,
  (VTBL_ENTRY)&_ZN6S206C63v55Ev,
  (VTBL_ENTRY)&_ZN6S206C63v56Ev,
  (VTBL_ENTRY)&_ZN6S206C63v57Ev,
  (VTBL_ENTRY)&_ZN6S206C63v58Ev,
  (VTBL_ENTRY)&_ZN6S206C63v59Ev,
  (VTBL_ENTRY)&_ZN6S206C63v60Ev,
  (VTBL_ENTRY)&_ZN6S206C63v61Ev,
  (VTBL_ENTRY)&_ZN6S206C63v62Ev,
  (VTBL_ENTRY)&_ZN6S206C63v63Ev,
  (VTBL_ENTRY)&_ZN6S206C63v64Ev,
  (VTBL_ENTRY)&_ZN6S206C63v65Ev,
  (VTBL_ENTRY)&_ZN6S206C63v66Ev,
  (VTBL_ENTRY)&_ZN6S206C63v67Ev,
  (VTBL_ENTRY)&_ZN6S206C53v68Ev,
  (VTBL_ENTRY)&_ZN6S206C53v69Ev,
  (VTBL_ENTRY)&_ZN6S206C53v70Ev,
  (VTBL_ENTRY)&_ZN6S206C53v71Ev,
  (VTBL_ENTRY)&_ZN6S206C53v72Ev,
  (VTBL_ENTRY)&_ZN6S206C53v73Ev,
  (VTBL_ENTRY)&_ZN6S206C53v74Ev,
  (VTBL_ENTRY)&_ZN6S206C53v75Ev,
  (VTBL_ENTRY)&_ZN6S206C53v76Ev,
  (VTBL_ENTRY)&_ZN6S206C53v77Ev,
  (VTBL_ENTRY)&_ZN6S206C53v78Ev,
  (VTBL_ENTRY)&_ZN6S206C53v79Ev,
  (VTBL_ENTRY)&_ZN6S206C53v80Ev,
  (VTBL_ENTRY)&_ZN6S206C53v81Ev,
  (VTBL_ENTRY)&_ZN6S206C53v82Ev,
  (VTBL_ENTRY)&_ZN6S206C53v83Ev,
  (VTBL_ENTRY)&_ZN6S206C53v84Ev,
  (VTBL_ENTRY)&_ZN6S206C53v85Ev,
  (VTBL_ENTRY)&_ZN6S206C53v86Ev,
  (VTBL_ENTRY)&_ZN6S206C53v87Ev,
  (VTBL_ENTRY)&_ZN6S206C53v88Ev,
  (VTBL_ENTRY)&_ZN6S206C53v89Ev,
  (VTBL_ENTRY)&_ZN6S206C43v90Ev,
  (VTBL_ENTRY)&_ZN6S206C43v91Ev,
  (VTBL_ENTRY)&_ZN6S206C43v92Ev,
  (VTBL_ENTRY)&_ZN6S206C43v93Ev,
  (VTBL_ENTRY)&_ZN6S206C43v94Ev,
  (VTBL_ENTRY)&_ZN6S206C43v95Ev,
  (VTBL_ENTRY)&_ZN6S206C43v96Ev,
  (VTBL_ENTRY)&_ZN6S206C43v97Ev,
  (VTBL_ENTRY)&_ZN6S206C43v98Ev,
  (VTBL_ENTRY)&_ZN6S206C43v99Ev,
  (VTBL_ENTRY)&_ZN6S206C44v100Ev,
  (VTBL_ENTRY)&_ZN6S206C44v101Ev,
  (VTBL_ENTRY)&_ZN6S206C44v102Ev,
  (VTBL_ENTRY)&_ZN6S206C44v103Ev,
  (VTBL_ENTRY)&_ZN6S206C44v104Ev,
  (VTBL_ENTRY)&_ZN6S206C44v105Ev,
  (VTBL_ENTRY)&_ZN6S206C44v106Ev,
  (VTBL_ENTRY)&_ZN6S206C44v107Ev,
  (VTBL_ENTRY)&_ZN6S206C44v108Ev,
  (VTBL_ENTRY)&_ZN6S206C44v109Ev,
  (VTBL_ENTRY)&_ZN6S206C34v110Ev,
  (VTBL_ENTRY)&_ZN6S206C34v111Ev,
  (VTBL_ENTRY)&_ZN6S206C34v112Ev,
  (VTBL_ENTRY)&_ZN6S206C34v113Ev,
  (VTBL_ENTRY)&_ZN6S206C24v114Ev,
  (VTBL_ENTRY)&_ZN6S206C24v115Ev,
  (VTBL_ENTRY)&_ZN6S206C24v116Ev,
  (VTBL_ENTRY)&_ZN6S206C24v117Ev,
  (VTBL_ENTRY)&_ZN6S206C24v118Ev,
  (VTBL_ENTRY)&_ZN6S206C24v119Ev,
  (VTBL_ENTRY)&_ZN6S206C24v120Ev,
  (VTBL_ENTRY)&_ZN6S206C24v121Ev,
};
extern VTBL_ENTRY _ZTI6S206C2[];
extern  VTBL_ENTRY _ZTV6S206C2[];
Class_Descriptor cd_S206C2 = {  "S206C2", // class name
  bases_S206C2, 4,
  &(vtc_S206C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,228), // object size
  NSPAIRA(_ZTI6S206C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S206C2),122, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S206C1  : S206C2 {
  int s206c1f0;
  virtual  ~S206C1(); // _ZN6S206C1D1Ev
  virtual void  v1(); // _ZN6S206C12v1Ev
  virtual void  v2(); // _ZN6S206C12v2Ev
  virtual void  v3(); // _ZN6S206C12v3Ev
  S206C1(); // tgen
};
//SIG(1 S206C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 Fi[2] Fp Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 FC12{ m} FC8 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 Fi:1 Fi:1 Fi:1 FC13{ BC14{ BC11}} FC15{ BC16{ BC11}} FC17{ BC18{ BC11}} FC19{ BC20{ BC11}} Fi[3]} vd v110 v111 v112 v113 FC7 Fi:1 FC21{ BC22{ BC11}}} vd v114 v115 v116 v117 v118 v119 v120 v121 Fi Fi:1} vd v1 v2 v3 Fi}


 S206C1 ::~S206C1(){ note_dtor("S206C1", this);}
void  S206C1 ::v1(){vfunc_called(this, "_ZN6S206C12v1Ev");}
void  S206C1 ::v2(){vfunc_called(this, "_ZN6S206C12v2Ev");}
void  S206C1 ::v3(){vfunc_called(this, "_ZN6S206C12v3Ev");}
S206C1 ::S206C1(){ note_ctor("S206C1", this);} // tgen

static void Test_S206C1()
{
  extern Class_Descriptor cd_S206C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(40,59)];
    init_test(&cd_S206C1, buf);
    S206C1 *dp, &lv = *(dp=new (buf) S206C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(312,232), "sizeof(S206C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S206C1)");
    check_base_class_offset(lv, (S206C6*)(S206C5*)(S206C4*)(S206C3*)(S206C2*), 0, "S206C1");
    check_base_class_offset(lv, (S206C5*)(S206C4*)(S206C3*)(S206C2*), 0, "S206C1");
    check_base_class_offset(lv, (S206C4*)(S206C3*)(S206C2*), 0, "S206C1");
    check_base_class_offset(lv, (S206C3*)(S206C2*), 0, "S206C1");
    check_base_class_offset(lv, (S206C2*), 0, "S206C1");
    check_field_offset(lv, s206c1f0, ABISELECT(304,228), "S206C1.s206c1f0");
    test_class_info(&lv, &cd_S206C1);
    dp->~S206C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS206C1(Test_S206C1, "S206C1", ABISELECT(312,232));

#else // __cplusplus

extern void _ZN6S206C1C1Ev();
extern void _ZN6S206C1D1Ev();
Name_Map name_map_S206C1[] = {
  NSPAIR(_ZN6S206C1C1Ev),
  NSPAIR(_ZN6S206C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S206C6;
extern VTBL_ENTRY _ZTI6S206C6[];
extern  VTBL_ENTRY _ZTV6S206C6[];
extern Class_Descriptor cd_S206C5;
extern VTBL_ENTRY _ZTI6S206C5[];
extern  VTBL_ENTRY _ZTV6S206C5[];
extern Class_Descriptor cd_S206C4;
extern VTBL_ENTRY _ZTI6S206C4[];
extern  VTBL_ENTRY _ZTV6S206C4[];
extern Class_Descriptor cd_S206C3;
extern VTBL_ENTRY _ZTI6S206C3[];
extern  VTBL_ENTRY _ZTV6S206C3[];
extern Class_Descriptor cd_S206C2;
extern VTBL_ENTRY _ZTI6S206C2[];
extern  VTBL_ENTRY _ZTV6S206C2[];
static Base_Class bases_S206C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S206C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S206C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S206C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S206C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S206C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S206C1[];
extern void _ZN6S206C1D1Ev();
extern void _ZN6S206C1D0Ev();
extern void _ZN6S206C62v4Ev();
extern void _ZN6S206C62v5Ev();
extern void _ZN6S206C62v6Ev();
extern void _ZN6S206C62v7Ev();
extern void _ZN6S206C62v8Ev();
extern void _ZN6S206C62v9Ev();
extern void _ZN6S206C63v10Ev();
extern void _ZN6S206C63v11Ev();
extern void _ZN6S206C63v12Ev();
extern void _ZN6S206C63v13Ev();
extern void _ZN6S206C63v14Ev();
extern void _ZN6S206C63v15Ev();
extern void _ZN6S206C63v16Ev();
extern void _ZN6S206C63v17Ev();
extern void _ZN6S206C63v18Ev();
extern void _ZN6S206C63v19Ev();
extern void _ZN6S206C63v20Ev();
extern void _ZN6S206C63v21Ev();
extern void _ZN6S206C63v22Ev();
extern void _ZN6S206C63v23Ev();
extern void _ZN6S206C63v24Ev();
extern void _ZN6S206C63v25Ev();
extern void _ZN6S206C63v26Ev();
extern void _ZN6S206C63v27Ev();
extern void _ZN6S206C63v28Ev();
extern void _ZN6S206C63v29Ev();
extern void _ZN6S206C63v30Ev();
extern void _ZN6S206C63v31Ev();
extern void _ZN6S206C63v32Ev();
extern void _ZN6S206C63v33Ev();
extern void _ZN6S206C63v34Ev();
extern void _ZN6S206C63v35Ev();
extern void _ZN6S206C63v36Ev();
extern void _ZN6S206C63v37Ev();
extern void _ZN6S206C63v38Ev();
extern void _ZN6S206C63v39Ev();
extern void _ZN6S206C63v40Ev();
extern void _ZN6S206C63v41Ev();
extern void _ZN6S206C63v42Ev();
extern void _ZN6S206C63v43Ev();
extern void _ZN6S206C63v44Ev();
extern void _ZN6S206C63v45Ev();
extern void _ZN6S206C63v46Ev();
extern void _ZN6S206C63v47Ev();
extern void _ZN6S206C63v48Ev();
extern void _ZN6S206C63v49Ev();
extern void _ZN6S206C63v50Ev();
extern void _ZN6S206C63v51Ev();
extern void _ZN6S206C63v52Ev();
extern void _ZN6S206C63v53Ev();
extern void _ZN6S206C63v54Ev();
extern void _ZN6S206C63v55Ev();
extern void _ZN6S206C63v56Ev();
extern void _ZN6S206C63v57Ev();
extern void _ZN6S206C63v58Ev();
extern void _ZN6S206C63v59Ev();
extern void _ZN6S206C63v60Ev();
extern void _ZN6S206C63v61Ev();
extern void _ZN6S206C63v62Ev();
extern void _ZN6S206C63v63Ev();
extern void _ZN6S206C63v64Ev();
extern void _ZN6S206C63v65Ev();
extern void _ZN6S206C63v66Ev();
extern void _ZN6S206C63v67Ev();
extern void _ZN6S206C53v68Ev();
extern void _ZN6S206C53v69Ev();
extern void _ZN6S206C53v70Ev();
extern void _ZN6S206C53v71Ev();
extern void _ZN6S206C53v72Ev();
extern void _ZN6S206C53v73Ev();
extern void _ZN6S206C53v74Ev();
extern void _ZN6S206C53v75Ev();
extern void _ZN6S206C53v76Ev();
extern void _ZN6S206C53v77Ev();
extern void _ZN6S206C53v78Ev();
extern void _ZN6S206C53v79Ev();
extern void _ZN6S206C53v80Ev();
extern void _ZN6S206C53v81Ev();
extern void _ZN6S206C53v82Ev();
extern void _ZN6S206C53v83Ev();
extern void _ZN6S206C53v84Ev();
extern void _ZN6S206C53v85Ev();
extern void _ZN6S206C53v86Ev();
extern void _ZN6S206C53v87Ev();
extern void _ZN6S206C53v88Ev();
extern void _ZN6S206C53v89Ev();
extern void _ZN6S206C43v90Ev();
extern void _ZN6S206C43v91Ev();
extern void _ZN6S206C43v92Ev();
extern void _ZN6S206C43v93Ev();
extern void _ZN6S206C43v94Ev();
extern void _ZN6S206C43v95Ev();
extern void _ZN6S206C43v96Ev();
extern void _ZN6S206C43v97Ev();
extern void _ZN6S206C43v98Ev();
extern void _ZN6S206C43v99Ev();
extern void _ZN6S206C44v100Ev();
extern void _ZN6S206C44v101Ev();
extern void _ZN6S206C44v102Ev();
extern void _ZN6S206C44v103Ev();
extern void _ZN6S206C44v104Ev();
extern void _ZN6S206C44v105Ev();
extern void _ZN6S206C44v106Ev();
extern void _ZN6S206C44v107Ev();
extern void _ZN6S206C44v108Ev();
extern void _ZN6S206C44v109Ev();
extern void _ZN6S206C34v110Ev();
extern void _ZN6S206C34v111Ev();
extern void _ZN6S206C34v112Ev();
extern void _ZN6S206C34v113Ev();
extern void _ZN6S206C24v114Ev();
extern void _ZN6S206C24v115Ev();
extern void _ZN6S206C24v116Ev();
extern void _ZN6S206C24v117Ev();
extern void _ZN6S206C24v118Ev();
extern void _ZN6S206C24v119Ev();
extern void _ZN6S206C24v120Ev();
extern void _ZN6S206C24v121Ev();
extern void _ZN6S206C12v1Ev();
extern void _ZN6S206C12v2Ev();
extern void _ZN6S206C12v3Ev();
static  VTBL_ENTRY vtc_S206C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S206C1[0]),
  (VTBL_ENTRY)&_ZN6S206C1D1Ev,
  (VTBL_ENTRY)&_ZN6S206C1D0Ev,
  (VTBL_ENTRY)&_ZN6S206C62v4Ev,
  (VTBL_ENTRY)&_ZN6S206C62v5Ev,
  (VTBL_ENTRY)&_ZN6S206C62v6Ev,
  (VTBL_ENTRY)&_ZN6S206C62v7Ev,
  (VTBL_ENTRY)&_ZN6S206C62v8Ev,
  (VTBL_ENTRY)&_ZN6S206C62v9Ev,
  (VTBL_ENTRY)&_ZN6S206C63v10Ev,
  (VTBL_ENTRY)&_ZN6S206C63v11Ev,
  (VTBL_ENTRY)&_ZN6S206C63v12Ev,
  (VTBL_ENTRY)&_ZN6S206C63v13Ev,
  (VTBL_ENTRY)&_ZN6S206C63v14Ev,
  (VTBL_ENTRY)&_ZN6S206C63v15Ev,
  (VTBL_ENTRY)&_ZN6S206C63v16Ev,
  (VTBL_ENTRY)&_ZN6S206C63v17Ev,
  (VTBL_ENTRY)&_ZN6S206C63v18Ev,
  (VTBL_ENTRY)&_ZN6S206C63v19Ev,
  (VTBL_ENTRY)&_ZN6S206C63v20Ev,
  (VTBL_ENTRY)&_ZN6S206C63v21Ev,
  (VTBL_ENTRY)&_ZN6S206C63v22Ev,
  (VTBL_ENTRY)&_ZN6S206C63v23Ev,
  (VTBL_ENTRY)&_ZN6S206C63v24Ev,
  (VTBL_ENTRY)&_ZN6S206C63v25Ev,
  (VTBL_ENTRY)&_ZN6S206C63v26Ev,
  (VTBL_ENTRY)&_ZN6S206C63v27Ev,
  (VTBL_ENTRY)&_ZN6S206C63v28Ev,
  (VTBL_ENTRY)&_ZN6S206C63v29Ev,
  (VTBL_ENTRY)&_ZN6S206C63v30Ev,
  (VTBL_ENTRY)&_ZN6S206C63v31Ev,
  (VTBL_ENTRY)&_ZN6S206C63v32Ev,
  (VTBL_ENTRY)&_ZN6S206C63v33Ev,
  (VTBL_ENTRY)&_ZN6S206C63v34Ev,
  (VTBL_ENTRY)&_ZN6S206C63v35Ev,
  (VTBL_ENTRY)&_ZN6S206C63v36Ev,
  (VTBL_ENTRY)&_ZN6S206C63v37Ev,
  (VTBL_ENTRY)&_ZN6S206C63v38Ev,
  (VTBL_ENTRY)&_ZN6S206C63v39Ev,
  (VTBL_ENTRY)&_ZN6S206C63v40Ev,
  (VTBL_ENTRY)&_ZN6S206C63v41Ev,
  (VTBL_ENTRY)&_ZN6S206C63v42Ev,
  (VTBL_ENTRY)&_ZN6S206C63v43Ev,
  (VTBL_ENTRY)&_ZN6S206C63v44Ev,
  (VTBL_ENTRY)&_ZN6S206C63v45Ev,
  (VTBL_ENTRY)&_ZN6S206C63v46Ev,
  (VTBL_ENTRY)&_ZN6S206C63v47Ev,
  (VTBL_ENTRY)&_ZN6S206C63v48Ev,
  (VTBL_ENTRY)&_ZN6S206C63v49Ev,
  (VTBL_ENTRY)&_ZN6S206C63v50Ev,
  (VTBL_ENTRY)&_ZN6S206C63v51Ev,
  (VTBL_ENTRY)&_ZN6S206C63v52Ev,
  (VTBL_ENTRY)&_ZN6S206C63v53Ev,
  (VTBL_ENTRY)&_ZN6S206C63v54Ev,
  (VTBL_ENTRY)&_ZN6S206C63v55Ev,
  (VTBL_ENTRY)&_ZN6S206C63v56Ev,
  (VTBL_ENTRY)&_ZN6S206C63v57Ev,
  (VTBL_ENTRY)&_ZN6S206C63v58Ev,
  (VTBL_ENTRY)&_ZN6S206C63v59Ev,
  (VTBL_ENTRY)&_ZN6S206C63v60Ev,
  (VTBL_ENTRY)&_ZN6S206C63v61Ev,
  (VTBL_ENTRY)&_ZN6S206C63v62Ev,
  (VTBL_ENTRY)&_ZN6S206C63v63Ev,
  (VTBL_ENTRY)&_ZN6S206C63v64Ev,
  (VTBL_ENTRY)&_ZN6S206C63v65Ev,
  (VTBL_ENTRY)&_ZN6S206C63v66Ev,
  (VTBL_ENTRY)&_ZN6S206C63v67Ev,
  (VTBL_ENTRY)&_ZN6S206C53v68Ev,
  (VTBL_ENTRY)&_ZN6S206C53v69Ev,
  (VTBL_ENTRY)&_ZN6S206C53v70Ev,
  (VTBL_ENTRY)&_ZN6S206C53v71Ev,
  (VTBL_ENTRY)&_ZN6S206C53v72Ev,
  (VTBL_ENTRY)&_ZN6S206C53v73Ev,
  (VTBL_ENTRY)&_ZN6S206C53v74Ev,
  (VTBL_ENTRY)&_ZN6S206C53v75Ev,
  (VTBL_ENTRY)&_ZN6S206C53v76Ev,
  (VTBL_ENTRY)&_ZN6S206C53v77Ev,
  (VTBL_ENTRY)&_ZN6S206C53v78Ev,
  (VTBL_ENTRY)&_ZN6S206C53v79Ev,
  (VTBL_ENTRY)&_ZN6S206C53v80Ev,
  (VTBL_ENTRY)&_ZN6S206C53v81Ev,
  (VTBL_ENTRY)&_ZN6S206C53v82Ev,
  (VTBL_ENTRY)&_ZN6S206C53v83Ev,
  (VTBL_ENTRY)&_ZN6S206C53v84Ev,
  (VTBL_ENTRY)&_ZN6S206C53v85Ev,
  (VTBL_ENTRY)&_ZN6S206C53v86Ev,
  (VTBL_ENTRY)&_ZN6S206C53v87Ev,
  (VTBL_ENTRY)&_ZN6S206C53v88Ev,
  (VTBL_ENTRY)&_ZN6S206C53v89Ev,
  (VTBL_ENTRY)&_ZN6S206C43v90Ev,
  (VTBL_ENTRY)&_ZN6S206C43v91Ev,
  (VTBL_ENTRY)&_ZN6S206C43v92Ev,
  (VTBL_ENTRY)&_ZN6S206C43v93Ev,
  (VTBL_ENTRY)&_ZN6S206C43v94Ev,
  (VTBL_ENTRY)&_ZN6S206C43v95Ev,
  (VTBL_ENTRY)&_ZN6S206C43v96Ev,
  (VTBL_ENTRY)&_ZN6S206C43v97Ev,
  (VTBL_ENTRY)&_ZN6S206C43v98Ev,
  (VTBL_ENTRY)&_ZN6S206C43v99Ev,
  (VTBL_ENTRY)&_ZN6S206C44v100Ev,
  (VTBL_ENTRY)&_ZN6S206C44v101Ev,
  (VTBL_ENTRY)&_ZN6S206C44v102Ev,
  (VTBL_ENTRY)&_ZN6S206C44v103Ev,
  (VTBL_ENTRY)&_ZN6S206C44v104Ev,
  (VTBL_ENTRY)&_ZN6S206C44v105Ev,
  (VTBL_ENTRY)&_ZN6S206C44v106Ev,
  (VTBL_ENTRY)&_ZN6S206C44v107Ev,
  (VTBL_ENTRY)&_ZN6S206C44v108Ev,
  (VTBL_ENTRY)&_ZN6S206C44v109Ev,
  (VTBL_ENTRY)&_ZN6S206C34v110Ev,
  (VTBL_ENTRY)&_ZN6S206C34v111Ev,
  (VTBL_ENTRY)&_ZN6S206C34v112Ev,
  (VTBL_ENTRY)&_ZN6S206C34v113Ev,
  (VTBL_ENTRY)&_ZN6S206C24v114Ev,
  (VTBL_ENTRY)&_ZN6S206C24v115Ev,
  (VTBL_ENTRY)&_ZN6S206C24v116Ev,
  (VTBL_ENTRY)&_ZN6S206C24v117Ev,
  (VTBL_ENTRY)&_ZN6S206C24v118Ev,
  (VTBL_ENTRY)&_ZN6S206C24v119Ev,
  (VTBL_ENTRY)&_ZN6S206C24v120Ev,
  (VTBL_ENTRY)&_ZN6S206C24v121Ev,
  (VTBL_ENTRY)&_ZN6S206C12v1Ev,
  (VTBL_ENTRY)&_ZN6S206C12v2Ev,
  (VTBL_ENTRY)&_ZN6S206C12v3Ev,
};
extern VTBL_ENTRY _ZTI6S206C1[];
extern  VTBL_ENTRY _ZTV6S206C1[];
Class_Descriptor cd_S206C1 = {  "S206C1", // class name
  bases_S206C1, 5,
  &(vtc_S206C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(312,232), // object size
  NSPAIRA(_ZTI6S206C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S206C1),125, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1288C4  {
  int s1288c4f0;
  __tsi64 s1288c4f1;
  void *s1288c4f2[4];
  int s1288c4f3[2];
  void *s1288c4f4;
  ::S1409C5_nt s1288c4f5;
  void *s1288c4f6[2];
  virtual  ~S1288C4(); // _ZN7S1288C4D1Ev
  virtual void  v10(); // _ZN7S1288C43v10Ev
  virtual void  v11(); // _ZN7S1288C43v11Ev
  virtual void  v12(); // _ZN7S1288C43v12Ev
  virtual void  v13(); // _ZN7S1288C43v13Ev
  virtual void  v14(); // _ZN7S1288C43v14Ev
  virtual void  v15(); // _ZN7S1288C43v15Ev
  virtual void  v16(); // _ZN7S1288C43v16Ev
  virtual void  v17(); // _ZN7S1288C43v17Ev
  virtual void  v18(); // _ZN7S1288C43v18Ev
  virtual void  v19(); // _ZN7S1288C43v19Ev
  virtual void  v20(); // _ZN7S1288C43v20Ev
  virtual void  v21(); // _ZN7S1288C43v21Ev
  virtual void  v22(); // _ZN7S1288C43v22Ev
  virtual void  v23(); // _ZN7S1288C43v23Ev
  virtual void  v24(); // _ZN7S1288C43v24Ev
  virtual void  v25(); // _ZN7S1288C43v25Ev
  virtual void  v26(); // _ZN7S1288C43v26Ev
  virtual void  v27(); // _ZN7S1288C43v27Ev
  virtual void  v28(); // _ZN7S1288C43v28Ev
  virtual void  v29(); // _ZN7S1288C43v29Ev
  virtual void  v30(); // _ZN7S1288C43v30Ev
  virtual void  v31(); // _ZN7S1288C43v31Ev
  virtual void  v32(); // _ZN7S1288C43v32Ev
  virtual void  v33(); // _ZN7S1288C43v33Ev
  virtual void  v34(); // _ZN7S1288C43v34Ev
  virtual void  v35(); // _ZN7S1288C43v35Ev
  virtual void  v36(); // _ZN7S1288C43v36Ev
  virtual void  v37(); // _ZN7S1288C43v37Ev
  virtual void  v38(); // _ZN7S1288C43v38Ev
  virtual void  v39(); // _ZN7S1288C43v39Ev
  virtual void  v40(); // _ZN7S1288C43v40Ev
  virtual void  v41(); // _ZN7S1288C43v41Ev
  virtual void  v42(); // _ZN7S1288C43v42Ev
  virtual void  v43(); // _ZN7S1288C43v43Ev
  virtual void  v44(); // _ZN7S1288C43v44Ev
  virtual void  v45(); // _ZN7S1288C43v45Ev
  virtual void  v46(); // _ZN7S1288C43v46Ev
  virtual void  v47(); // _ZN7S1288C43v47Ev
  virtual void  v48(); // _ZN7S1288C43v48Ev
  virtual void  v49(); // _ZN7S1288C43v49Ev
  virtual void  v50(); // _ZN7S1288C43v50Ev
  virtual void  v51(); // _ZN7S1288C43v51Ev
  virtual void  v52(); // _ZN7S1288C43v52Ev
  virtual void  v53(); // _ZN7S1288C43v53Ev
  virtual void  v54(); // _ZN7S1288C43v54Ev
  virtual void  v55(); // _ZN7S1288C43v55Ev
  virtual void  v56(); // _ZN7S1288C43v56Ev
  virtual void  v57(); // _ZN7S1288C43v57Ev
  virtual void  v58(); // _ZN7S1288C43v58Ev
  virtual void  v59(); // _ZN7S1288C43v59Ev
  virtual void  v60(); // _ZN7S1288C43v60Ev
  virtual void  v61(); // _ZN7S1288C43v61Ev
  virtual void  v62(); // _ZN7S1288C43v62Ev
  virtual void  v63(); // _ZN7S1288C43v63Ev
  virtual void  v64(); // _ZN7S1288C43v64Ev
  virtual void  v65(); // _ZN7S1288C43v65Ev
  virtual void  v66(); // _ZN7S1288C43v66Ev
  virtual void  v67(); // _ZN7S1288C43v67Ev
  virtual void  v68(); // _ZN7S1288C43v68Ev
  virtual void  v69(); // _ZN7S1288C43v69Ev
  virtual void  v70(); // _ZN7S1288C43v70Ev
  virtual void  v71(); // _ZN7S1288C43v71Ev
  virtual void  v72(); // _ZN7S1288C43v72Ev
  virtual void  v73(); // _ZN7S1288C43v73Ev
  S1288C4(); // tgen
};
//SIG(-1 S1288C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1288C4 ::~S1288C4(){ note_dtor("S1288C4", this);}
void  S1288C4 ::v10(){vfunc_called(this, "_ZN7S1288C43v10Ev");}
void  S1288C4 ::v11(){vfunc_called(this, "_ZN7S1288C43v11Ev");}
void  S1288C4 ::v12(){vfunc_called(this, "_ZN7S1288C43v12Ev");}
void  S1288C4 ::v13(){vfunc_called(this, "_ZN7S1288C43v13Ev");}
void  S1288C4 ::v14(){vfunc_called(this, "_ZN7S1288C43v14Ev");}
void  S1288C4 ::v15(){vfunc_called(this, "_ZN7S1288C43v15Ev");}
void  S1288C4 ::v16(){vfunc_called(this, "_ZN7S1288C43v16Ev");}
void  S1288C4 ::v17(){vfunc_called(this, "_ZN7S1288C43v17Ev");}
void  S1288C4 ::v18(){vfunc_called(this, "_ZN7S1288C43v18Ev");}
void  S1288C4 ::v19(){vfunc_called(this, "_ZN7S1288C43v19Ev");}
void  S1288C4 ::v20(){vfunc_called(this, "_ZN7S1288C43v20Ev");}
void  S1288C4 ::v21(){vfunc_called(this, "_ZN7S1288C43v21Ev");}
void  S1288C4 ::v22(){vfunc_called(this, "_ZN7S1288C43v22Ev");}
void  S1288C4 ::v23(){vfunc_called(this, "_ZN7S1288C43v23Ev");}
void  S1288C4 ::v24(){vfunc_called(this, "_ZN7S1288C43v24Ev");}
void  S1288C4 ::v25(){vfunc_called(this, "_ZN7S1288C43v25Ev");}
void  S1288C4 ::v26(){vfunc_called(this, "_ZN7S1288C43v26Ev");}
void  S1288C4 ::v27(){vfunc_called(this, "_ZN7S1288C43v27Ev");}
void  S1288C4 ::v28(){vfunc_called(this, "_ZN7S1288C43v28Ev");}
void  S1288C4 ::v29(){vfunc_called(this, "_ZN7S1288C43v29Ev");}
void  S1288C4 ::v30(){vfunc_called(this, "_ZN7S1288C43v30Ev");}
void  S1288C4 ::v31(){vfunc_called(this, "_ZN7S1288C43v31Ev");}
void  S1288C4 ::v32(){vfunc_called(this, "_ZN7S1288C43v32Ev");}
void  S1288C4 ::v33(){vfunc_called(this, "_ZN7S1288C43v33Ev");}
void  S1288C4 ::v34(){vfunc_called(this, "_ZN7S1288C43v34Ev");}
void  S1288C4 ::v35(){vfunc_called(this, "_ZN7S1288C43v35Ev");}
void  S1288C4 ::v36(){vfunc_called(this, "_ZN7S1288C43v36Ev");}
void  S1288C4 ::v37(){vfunc_called(this, "_ZN7S1288C43v37Ev");}
void  S1288C4 ::v38(){vfunc_called(this, "_ZN7S1288C43v38Ev");}
void  S1288C4 ::v39(){vfunc_called(this, "_ZN7S1288C43v39Ev");}
void  S1288C4 ::v40(){vfunc_called(this, "_ZN7S1288C43v40Ev");}
void  S1288C4 ::v41(){vfunc_called(this, "_ZN7S1288C43v41Ev");}
void  S1288C4 ::v42(){vfunc_called(this, "_ZN7S1288C43v42Ev");}
void  S1288C4 ::v43(){vfunc_called(this, "_ZN7S1288C43v43Ev");}
void  S1288C4 ::v44(){vfunc_called(this, "_ZN7S1288C43v44Ev");}
void  S1288C4 ::v45(){vfunc_called(this, "_ZN7S1288C43v45Ev");}
void  S1288C4 ::v46(){vfunc_called(this, "_ZN7S1288C43v46Ev");}
void  S1288C4 ::v47(){vfunc_called(this, "_ZN7S1288C43v47Ev");}
void  S1288C4 ::v48(){vfunc_called(this, "_ZN7S1288C43v48Ev");}
void  S1288C4 ::v49(){vfunc_called(this, "_ZN7S1288C43v49Ev");}
void  S1288C4 ::v50(){vfunc_called(this, "_ZN7S1288C43v50Ev");}
void  S1288C4 ::v51(){vfunc_called(this, "_ZN7S1288C43v51Ev");}
void  S1288C4 ::v52(){vfunc_called(this, "_ZN7S1288C43v52Ev");}
void  S1288C4 ::v53(){vfunc_called(this, "_ZN7S1288C43v53Ev");}
void  S1288C4 ::v54(){vfunc_called(this, "_ZN7S1288C43v54Ev");}
void  S1288C4 ::v55(){vfunc_called(this, "_ZN7S1288C43v55Ev");}
void  S1288C4 ::v56(){vfunc_called(this, "_ZN7S1288C43v56Ev");}
void  S1288C4 ::v57(){vfunc_called(this, "_ZN7S1288C43v57Ev");}
void  S1288C4 ::v58(){vfunc_called(this, "_ZN7S1288C43v58Ev");}
void  S1288C4 ::v59(){vfunc_called(this, "_ZN7S1288C43v59Ev");}
void  S1288C4 ::v60(){vfunc_called(this, "_ZN7S1288C43v60Ev");}
void  S1288C4 ::v61(){vfunc_called(this, "_ZN7S1288C43v61Ev");}
void  S1288C4 ::v62(){vfunc_called(this, "_ZN7S1288C43v62Ev");}
void  S1288C4 ::v63(){vfunc_called(this, "_ZN7S1288C43v63Ev");}
void  S1288C4 ::v64(){vfunc_called(this, "_ZN7S1288C43v64Ev");}
void  S1288C4 ::v65(){vfunc_called(this, "_ZN7S1288C43v65Ev");}
void  S1288C4 ::v66(){vfunc_called(this, "_ZN7S1288C43v66Ev");}
void  S1288C4 ::v67(){vfunc_called(this, "_ZN7S1288C43v67Ev");}
void  S1288C4 ::v68(){vfunc_called(this, "_ZN7S1288C43v68Ev");}
void  S1288C4 ::v69(){vfunc_called(this, "_ZN7S1288C43v69Ev");}
void  S1288C4 ::v70(){vfunc_called(this, "_ZN7S1288C43v70Ev");}
void  S1288C4 ::v71(){vfunc_called(this, "_ZN7S1288C43v71Ev");}
void  S1288C4 ::v72(){vfunc_called(this, "_ZN7S1288C43v72Ev");}
void  S1288C4 ::v73(){vfunc_called(this, "_ZN7S1288C43v73Ev");}
S1288C4 ::S1288C4(){ note_ctor("S1288C4", this);} // tgen

static void Test_S1288C4()
{
  extern Class_Descriptor cd_S1288C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1288C4, buf);
    S1288C4 *dp, &lv = *(dp=new (buf) S1288C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1288C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1288C4)");
    check_field_offset(lv, s1288c4f0, ABISELECT(8,4), "S1288C4.s1288c4f0");
    check_field_offset(lv, s1288c4f1, ABISELECT(16,8), "S1288C4.s1288c4f1");
    check_field_offset(lv, s1288c4f2, ABISELECT(24,16), "S1288C4.s1288c4f2");
    check_field_offset(lv, s1288c4f3, ABISELECT(56,32), "S1288C4.s1288c4f3");
    check_field_offset(lv, s1288c4f4, ABISELECT(64,40), "S1288C4.s1288c4f4");
    check_field_offset(lv, s1288c4f5, ABISELECT(72,44), "S1288C4.s1288c4f5");
    check_field_offset(lv, s1288c4f6, ABISELECT(80,52), "S1288C4.s1288c4f6");
    test_class_info(&lv, &cd_S1288C4);
    dp->~S1288C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1288C4(Test_S1288C4, "S1288C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1288C4C1Ev();
extern void _ZN7S1288C4D1Ev();
Name_Map name_map_S1288C4[] = {
  NSPAIR(_ZN7S1288C4C1Ev),
  NSPAIR(_ZN7S1288C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1288C4[];
extern void _ZN7S1288C4D1Ev();
extern void _ZN7S1288C4D0Ev();
extern void _ZN7S1288C43v10Ev();
extern void _ZN7S1288C43v11Ev();
extern void _ZN7S1288C43v12Ev();
extern void _ZN7S1288C43v13Ev();
extern void _ZN7S1288C43v14Ev();
extern void _ZN7S1288C43v15Ev();
extern void _ZN7S1288C43v16Ev();
extern void _ZN7S1288C43v17Ev();
extern void _ZN7S1288C43v18Ev();
extern void _ZN7S1288C43v19Ev();
extern void _ZN7S1288C43v20Ev();
extern void _ZN7S1288C43v21Ev();
extern void _ZN7S1288C43v22Ev();
extern void _ZN7S1288C43v23Ev();
extern void _ZN7S1288C43v24Ev();
extern void _ZN7S1288C43v25Ev();
extern void _ZN7S1288C43v26Ev();
extern void _ZN7S1288C43v27Ev();
extern void _ZN7S1288C43v28Ev();
extern void _ZN7S1288C43v29Ev();
extern void _ZN7S1288C43v30Ev();
extern void _ZN7S1288C43v31Ev();
extern void _ZN7S1288C43v32Ev();
extern void _ZN7S1288C43v33Ev();
extern void _ZN7S1288C43v34Ev();
extern void _ZN7S1288C43v35Ev();
extern void _ZN7S1288C43v36Ev();
extern void _ZN7S1288C43v37Ev();
extern void _ZN7S1288C43v38Ev();
extern void _ZN7S1288C43v39Ev();
extern void _ZN7S1288C43v40Ev();
extern void _ZN7S1288C43v41Ev();
extern void _ZN7S1288C43v42Ev();
extern void _ZN7S1288C43v43Ev();
extern void _ZN7S1288C43v44Ev();
extern void _ZN7S1288C43v45Ev();
extern void _ZN7S1288C43v46Ev();
extern void _ZN7S1288C43v47Ev();
extern void _ZN7S1288C43v48Ev();
extern void _ZN7S1288C43v49Ev();
extern void _ZN7S1288C43v50Ev();
extern void _ZN7S1288C43v51Ev();
extern void _ZN7S1288C43v52Ev();
extern void _ZN7S1288C43v53Ev();
extern void _ZN7S1288C43v54Ev();
extern void _ZN7S1288C43v55Ev();
extern void _ZN7S1288C43v56Ev();
extern void _ZN7S1288C43v57Ev();
extern void _ZN7S1288C43v58Ev();
extern void _ZN7S1288C43v59Ev();
extern void _ZN7S1288C43v60Ev();
extern void _ZN7S1288C43v61Ev();
extern void _ZN7S1288C43v62Ev();
extern void _ZN7S1288C43v63Ev();
extern void _ZN7S1288C43v64Ev();
extern void _ZN7S1288C43v65Ev();
extern void _ZN7S1288C43v66Ev();
extern void _ZN7S1288C43v67Ev();
extern void _ZN7S1288C43v68Ev();
extern void _ZN7S1288C43v69Ev();
extern void _ZN7S1288C43v70Ev();
extern void _ZN7S1288C43v71Ev();
extern void _ZN7S1288C43v72Ev();
extern void _ZN7S1288C43v73Ev();
static  VTBL_ENTRY vtc_S1288C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1288C4[0]),
  (VTBL_ENTRY)&_ZN7S1288C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1288C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v73Ev,
};
extern VTBL_ENTRY _ZTI7S1288C4[];
extern  VTBL_ENTRY _ZTV7S1288C4[];
Class_Descriptor cd_S1288C4 = {  "S1288C4", // class name
  0,0,//no base classes
  &(vtc_S1288C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1288C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1288C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1288C3_nt  : S1288C4 {
  void *s1288c3f0;
  ::S1409C5_nt s1288c3f1;
  virtual  ~S1288C3_nt(); // _ZN10S1288C3_ntD1Ev
  virtual void  v74(); // _ZN10S1288C3_nt3v74Ev
  virtual void  v75(); // _ZN10S1288C3_nt3v75Ev
  virtual void  v76(); // _ZN10S1288C3_nt3v76Ev
  virtual void  v77(); // _ZN10S1288C3_nt3v77Ev
  virtual void  v78(); // _ZN10S1288C3_nt3v78Ev
  S1288C3_nt(); // tgen
};
//SIG(-1 S1288C3_nt) C1{ BC2{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 Fp FC3}


 S1288C3_nt ::~S1288C3_nt(){ note_dtor("S1288C3_nt", this);}
void  S1288C3_nt ::v74(){vfunc_called(this, "_ZN10S1288C3_nt3v74Ev");}
void  S1288C3_nt ::v75(){vfunc_called(this, "_ZN10S1288C3_nt3v75Ev");}
void  S1288C3_nt ::v76(){vfunc_called(this, "_ZN10S1288C3_nt3v76Ev");}
void  S1288C3_nt ::v77(){vfunc_called(this, "_ZN10S1288C3_nt3v77Ev");}
void  S1288C3_nt ::v78(){vfunc_called(this, "_ZN10S1288C3_nt3v78Ev");}
S1288C3_nt ::S1288C3_nt(){ note_ctor("S1288C3_nt", this);} // tgen

//skip512 S1288C3_nt

#else // __cplusplus

extern void _ZN10S1288C3_ntC1Ev();
extern void _ZN10S1288C3_ntD1Ev();
Name_Map name_map_S1288C3_nt[] = {
  NSPAIR(_ZN10S1288C3_ntC1Ev),
  NSPAIR(_ZN10S1288C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1288C4;
extern VTBL_ENTRY _ZTI7S1288C4[];
extern  VTBL_ENTRY _ZTV7S1288C4[];
static Base_Class bases_S1288C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1288C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S1288C3_nt[];
extern void _ZN10S1288C3_ntD1Ev();
extern void _ZN10S1288C3_ntD0Ev();
extern void _ZN7S1288C43v10Ev();
extern void _ZN7S1288C43v11Ev();
extern void _ZN7S1288C43v12Ev();
extern void _ZN7S1288C43v13Ev();
extern void _ZN7S1288C43v14Ev();
extern void _ZN7S1288C43v15Ev();
extern void _ZN7S1288C43v16Ev();
extern void _ZN7S1288C43v17Ev();
extern void _ZN7S1288C43v18Ev();
extern void _ZN7S1288C43v19Ev();
extern void _ZN7S1288C43v20Ev();
extern void _ZN7S1288C43v21Ev();
extern void _ZN7S1288C43v22Ev();
extern void _ZN7S1288C43v23Ev();
extern void _ZN7S1288C43v24Ev();
extern void _ZN7S1288C43v25Ev();
extern void _ZN7S1288C43v26Ev();
extern void _ZN7S1288C43v27Ev();
extern void _ZN7S1288C43v28Ev();
extern void _ZN7S1288C43v29Ev();
extern void _ZN7S1288C43v30Ev();
extern void _ZN7S1288C43v31Ev();
extern void _ZN7S1288C43v32Ev();
extern void _ZN7S1288C43v33Ev();
extern void _ZN7S1288C43v34Ev();
extern void _ZN7S1288C43v35Ev();
extern void _ZN7S1288C43v36Ev();
extern void _ZN7S1288C43v37Ev();
extern void _ZN7S1288C43v38Ev();
extern void _ZN7S1288C43v39Ev();
extern void _ZN7S1288C43v40Ev();
extern void _ZN7S1288C43v41Ev();
extern void _ZN7S1288C43v42Ev();
extern void _ZN7S1288C43v43Ev();
extern void _ZN7S1288C43v44Ev();
extern void _ZN7S1288C43v45Ev();
extern void _ZN7S1288C43v46Ev();
extern void _ZN7S1288C43v47Ev();
extern void _ZN7S1288C43v48Ev();
extern void _ZN7S1288C43v49Ev();
extern void _ZN7S1288C43v50Ev();
extern void _ZN7S1288C43v51Ev();
extern void _ZN7S1288C43v52Ev();
extern void _ZN7S1288C43v53Ev();
extern void _ZN7S1288C43v54Ev();
extern void _ZN7S1288C43v55Ev();
extern void _ZN7S1288C43v56Ev();
extern void _ZN7S1288C43v57Ev();
extern void _ZN7S1288C43v58Ev();
extern void _ZN7S1288C43v59Ev();
extern void _ZN7S1288C43v60Ev();
extern void _ZN7S1288C43v61Ev();
extern void _ZN7S1288C43v62Ev();
extern void _ZN7S1288C43v63Ev();
extern void _ZN7S1288C43v64Ev();
extern void _ZN7S1288C43v65Ev();
extern void _ZN7S1288C43v66Ev();
extern void _ZN7S1288C43v67Ev();
extern void _ZN7S1288C43v68Ev();
extern void _ZN7S1288C43v69Ev();
extern void _ZN7S1288C43v70Ev();
extern void _ZN7S1288C43v71Ev();
extern void _ZN7S1288C43v72Ev();
extern void _ZN7S1288C43v73Ev();
extern void _ZN10S1288C3_nt3v74Ev();
extern void _ZN10S1288C3_nt3v75Ev();
extern void _ZN10S1288C3_nt3v76Ev();
extern void _ZN10S1288C3_nt3v77Ev();
extern void _ZN10S1288C3_nt3v78Ev();
static  VTBL_ENTRY vtc_S1288C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1288C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S1288C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1288C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v73Ev,
  (VTBL_ENTRY)&_ZN10S1288C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1288C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1288C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1288C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1288C3_nt3v78Ev,
};
extern VTBL_ENTRY _ZTI10S1288C3_nt[];
VTBL_ENTRY *P__ZTI10S1288C3_nt = _ZTI10S1288C3_nt; 
extern  VTBL_ENTRY _ZTV10S1288C3_nt[];
Class_Descriptor cd_S1288C3_nt = {  "S1288C3_nt", // class name
  bases_S1288C3_nt, 1,
  &(vtc_S1288C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,72), // object size
  NSPAIRA(_ZTI10S1288C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S1288C3_nt),73, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1288C2_nt  : S1288C3_nt {
  void *s1288c2f0[2];
  unsigned int s1288c2f1:1;
  unsigned int s1288c2f2:1;
  unsigned int s1288c2f3:1;
  unsigned int s1288c2f4:1;
  char s1288c2f5;
  virtual  ~S1288C2_nt(); // _ZN10S1288C2_ntD1Ev
  virtual void  v79(); // _ZN10S1288C2_nt3v79Ev
  virtual void  v80(); // _ZN10S1288C2_nt3v80Ev
  virtual void  v81(); // _ZN10S1288C2_nt3v81Ev
  virtual void  v82(); // _ZN10S1288C2_nt3v82Ev
  virtual void  v83(); // _ZN10S1288C2_nt3v83Ev
  virtual void  v84(); // _ZN10S1288C2_nt3v84Ev
  virtual void  v85(); // _ZN10S1288C2_nt3v85Ev
  virtual void  v86(); // _ZN10S1288C2_nt3v86Ev
  virtual void  v87(); // _ZN10S1288C2_nt3v87Ev
  virtual void  v88(); // _ZN10S1288C2_nt3v88Ev
  virtual void  v89(); // _ZN10S1288C2_nt3v89Ev
  virtual void  v90(); // _ZN10S1288C2_nt3v90Ev
  virtual void  v91(); // _ZN10S1288C2_nt3v91Ev
  virtual void  v92(); // _ZN10S1288C2_nt3v92Ev
  virtual void  v93(); // _ZN10S1288C2_nt3v93Ev
  virtual void  v94(); // _ZN10S1288C2_nt3v94Ev
  virtual void  v95(); // _ZN10S1288C2_nt3v95Ev
  virtual void  v96(); // _ZN10S1288C2_nt3v96Ev
  virtual void  v97(); // _ZN10S1288C2_nt3v97Ev
  virtual void  v98(); // _ZN10S1288C2_nt3v98Ev
  virtual void  v99(); // _ZN10S1288C2_nt3v99Ev
  virtual void  v100(); // _ZN10S1288C2_nt4v100Ev
  S1288C2_nt(); // tgen
};
//SIG(-1 S1288C2_nt) C1{ BC2{ BC3{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v87 v88 v89 v90 v91 Fp FC4} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc}


 S1288C2_nt ::~S1288C2_nt(){ note_dtor("S1288C2_nt", this);}
void  S1288C2_nt ::v79(){vfunc_called(this, "_ZN10S1288C2_nt3v79Ev");}
void  S1288C2_nt ::v80(){vfunc_called(this, "_ZN10S1288C2_nt3v80Ev");}
void  S1288C2_nt ::v81(){vfunc_called(this, "_ZN10S1288C2_nt3v81Ev");}
void  S1288C2_nt ::v82(){vfunc_called(this, "_ZN10S1288C2_nt3v82Ev");}
void  S1288C2_nt ::v83(){vfunc_called(this, "_ZN10S1288C2_nt3v83Ev");}
void  S1288C2_nt ::v84(){vfunc_called(this, "_ZN10S1288C2_nt3v84Ev");}
void  S1288C2_nt ::v85(){vfunc_called(this, "_ZN10S1288C2_nt3v85Ev");}
void  S1288C2_nt ::v86(){vfunc_called(this, "_ZN10S1288C2_nt3v86Ev");}
void  S1288C2_nt ::v87(){vfunc_called(this, "_ZN10S1288C2_nt3v87Ev");}
void  S1288C2_nt ::v88(){vfunc_called(this, "_ZN10S1288C2_nt3v88Ev");}
void  S1288C2_nt ::v89(){vfunc_called(this, "_ZN10S1288C2_nt3v89Ev");}
void  S1288C2_nt ::v90(){vfunc_called(this, "_ZN10S1288C2_nt3v90Ev");}
void  S1288C2_nt ::v91(){vfunc_called(this, "_ZN10S1288C2_nt3v91Ev");}
void  S1288C2_nt ::v92(){vfunc_called(this, "_ZN10S1288C2_nt3v92Ev");}
void  S1288C2_nt ::v93(){vfunc_called(this, "_ZN10S1288C2_nt3v93Ev");}
void  S1288C2_nt ::v94(){vfunc_called(this, "_ZN10S1288C2_nt3v94Ev");}
void  S1288C2_nt ::v95(){vfunc_called(this, "_ZN10S1288C2_nt3v95Ev");}
void  S1288C2_nt ::v96(){vfunc_called(this, "_ZN10S1288C2_nt3v96Ev");}
void  S1288C2_nt ::v97(){vfunc_called(this, "_ZN10S1288C2_nt3v97Ev");}
void  S1288C2_nt ::v98(){vfunc_called(this, "_ZN10S1288C2_nt3v98Ev");}
void  S1288C2_nt ::v99(){vfunc_called(this, "_ZN10S1288C2_nt3v99Ev");}
void  S1288C2_nt ::v100(){vfunc_called(this, "_ZN10S1288C2_nt4v100Ev");}
S1288C2_nt ::S1288C2_nt(){ note_ctor("S1288C2_nt", this);} // tgen

//skip512 S1288C2_nt

#else // __cplusplus

extern void _ZN10S1288C2_ntC1Ev();
extern void _ZN10S1288C2_ntD1Ev();
Name_Map name_map_S1288C2_nt[] = {
  NSPAIR(_ZN10S1288C2_ntC1Ev),
  NSPAIR(_ZN10S1288C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1288C4;
extern VTBL_ENTRY _ZTI7S1288C4[];
extern  VTBL_ENTRY _ZTV7S1288C4[];
extern Class_Descriptor cd_S1288C3_nt;
extern VTBL_ENTRY _ZTI10S1288C3_nt[];
extern  VTBL_ENTRY _ZTV10S1288C3_nt[];
static Base_Class bases_S1288C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1288C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1288C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S1288C2_nt[];
extern void _ZN10S1288C2_ntD1Ev();
extern void _ZN10S1288C2_ntD0Ev();
extern void _ZN7S1288C43v10Ev();
extern void _ZN7S1288C43v11Ev();
extern void _ZN7S1288C43v12Ev();
extern void _ZN7S1288C43v13Ev();
extern void _ZN7S1288C43v14Ev();
extern void _ZN7S1288C43v15Ev();
extern void _ZN7S1288C43v16Ev();
extern void _ZN7S1288C43v17Ev();
extern void _ZN7S1288C43v18Ev();
extern void _ZN7S1288C43v19Ev();
extern void _ZN7S1288C43v20Ev();
extern void _ZN7S1288C43v21Ev();
extern void _ZN7S1288C43v22Ev();
extern void _ZN7S1288C43v23Ev();
extern void _ZN7S1288C43v24Ev();
extern void _ZN7S1288C43v25Ev();
extern void _ZN7S1288C43v26Ev();
extern void _ZN7S1288C43v27Ev();
extern void _ZN7S1288C43v28Ev();
extern void _ZN7S1288C43v29Ev();
extern void _ZN7S1288C43v30Ev();
extern void _ZN7S1288C43v31Ev();
extern void _ZN7S1288C43v32Ev();
extern void _ZN7S1288C43v33Ev();
extern void _ZN7S1288C43v34Ev();
extern void _ZN7S1288C43v35Ev();
extern void _ZN7S1288C43v36Ev();
extern void _ZN7S1288C43v37Ev();
extern void _ZN7S1288C43v38Ev();
extern void _ZN7S1288C43v39Ev();
extern void _ZN7S1288C43v40Ev();
extern void _ZN7S1288C43v41Ev();
extern void _ZN7S1288C43v42Ev();
extern void _ZN7S1288C43v43Ev();
extern void _ZN7S1288C43v44Ev();
extern void _ZN7S1288C43v45Ev();
extern void _ZN7S1288C43v46Ev();
extern void _ZN7S1288C43v47Ev();
extern void _ZN7S1288C43v48Ev();
extern void _ZN7S1288C43v49Ev();
extern void _ZN7S1288C43v50Ev();
extern void _ZN7S1288C43v51Ev();
extern void _ZN7S1288C43v52Ev();
extern void _ZN7S1288C43v53Ev();
extern void _ZN7S1288C43v54Ev();
extern void _ZN7S1288C43v55Ev();
extern void _ZN7S1288C43v56Ev();
extern void _ZN7S1288C43v57Ev();
extern void _ZN7S1288C43v58Ev();
extern void _ZN7S1288C43v59Ev();
extern void _ZN7S1288C43v60Ev();
extern void _ZN7S1288C43v61Ev();
extern void _ZN7S1288C43v62Ev();
extern void _ZN7S1288C43v63Ev();
extern void _ZN7S1288C43v64Ev();
extern void _ZN7S1288C43v65Ev();
extern void _ZN7S1288C43v66Ev();
extern void _ZN7S1288C43v67Ev();
extern void _ZN7S1288C43v68Ev();
extern void _ZN7S1288C43v69Ev();
extern void _ZN7S1288C43v70Ev();
extern void _ZN7S1288C43v71Ev();
extern void _ZN7S1288C43v72Ev();
extern void _ZN7S1288C43v73Ev();
extern void _ZN10S1288C3_nt3v74Ev();
extern void _ZN10S1288C3_nt3v75Ev();
extern void _ZN10S1288C3_nt3v76Ev();
extern void _ZN10S1288C3_nt3v77Ev();
extern void _ZN10S1288C3_nt3v78Ev();
extern void _ZN10S1288C2_nt3v79Ev();
extern void _ZN10S1288C2_nt3v80Ev();
extern void _ZN10S1288C2_nt3v81Ev();
extern void _ZN10S1288C2_nt3v82Ev();
extern void _ZN10S1288C2_nt3v83Ev();
extern void _ZN10S1288C2_nt3v84Ev();
extern void _ZN10S1288C2_nt3v85Ev();
extern void _ZN10S1288C2_nt3v86Ev();
extern void _ZN10S1288C2_nt3v87Ev();
extern void _ZN10S1288C2_nt3v88Ev();
extern void _ZN10S1288C2_nt3v89Ev();
extern void _ZN10S1288C2_nt3v90Ev();
extern void _ZN10S1288C2_nt3v91Ev();
extern void _ZN10S1288C2_nt3v92Ev();
extern void _ZN10S1288C2_nt3v93Ev();
extern void _ZN10S1288C2_nt3v94Ev();
extern void _ZN10S1288C2_nt3v95Ev();
extern void _ZN10S1288C2_nt3v96Ev();
extern void _ZN10S1288C2_nt3v97Ev();
extern void _ZN10S1288C2_nt3v98Ev();
extern void _ZN10S1288C2_nt3v99Ev();
extern void _ZN10S1288C2_nt4v100Ev();
static  VTBL_ENTRY vtc_S1288C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1288C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S1288C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v73Ev,
  (VTBL_ENTRY)&_ZN10S1288C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1288C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1288C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1288C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1288C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt4v100Ev,
};
extern VTBL_ENTRY _ZTI10S1288C2_nt[];
VTBL_ENTRY *P__ZTI10S1288C2_nt = _ZTI10S1288C2_nt; 
extern  VTBL_ENTRY _ZTV10S1288C2_nt[];
Class_Descriptor cd_S1288C2_nt = {  "S1288C2_nt", // class name
  bases_S1288C2_nt, 2,
  &(vtc_S1288C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,84), // object size
  NSPAIRA(_ZTI10S1288C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S1288C2_nt),95, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1288C11_nt  {
  ::S1409C19 s1288c11f0;
  void *s1288c11f1;
  int s1288c11f2;
  void  mf1288c11(); // _ZN11S1288C11_nt9mf1288c11Ev
};
//SIG(-1 S1288C11_nt) C1{ m FC2{ BC3{ m Fp Fi[2]}} Fp Fi}


void  S1288C11_nt ::mf1288c11(){}

//skip512 S1288C11_nt

#else // __cplusplus

Class_Descriptor cd_S1288C11_nt = {  "S1288C11_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1288C10_nt  : S1288C11_nt {
};
//SIG(-1 S1288C10_nt) C1{ BC2{ m FC3{ BC4{ m Fp Fi[2]}} Fp Fi}}



//skip512 S1288C10_nt

#else // __cplusplus

extern Class_Descriptor cd_S1288C11_nt;
static Base_Class bases_S1288C10_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1288C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1288C17_nt  {
  void *s1288c17f0;
  ::S1409C5_nt s1288c17f1;
  void  mf1288c17(); // _ZN11S1288C17_nt9mf1288c17Ev
};
//SIG(-1 S1288C17_nt) C1{ m Fp FC2{ m Fi[2]}}


void  S1288C17_nt ::mf1288c17(){}

//skip512 S1288C17_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1288C1  : S1288C2_nt {
  void *s1288c1f0[2];
  ::S1409C31 s1288c1f1;
  unsigned int s1288c1f2:1;
  unsigned int s1288c1f3:1;
  unsigned int s1288c1f4:1;
  unsigned int s1288c1f5:1;
  unsigned int s1288c1f6:1;
  unsigned int s1288c1f7:1;
  unsigned int s1288c1f8:1;
  unsigned int s1288c1f9:1;
  unsigned int s1288c1f10:1;
  unsigned int s1288c1f11:1;
  unsigned int s1288c1f12:1;
  unsigned int s1288c1f13:1;
  unsigned int s1288c1f14:1;
  unsigned int s1288c1f15:1;
  unsigned int s1288c1f16:1;
  unsigned int s1288c1f17:1;
  ::S1409C27 s1288c1f18;
  ::S1409C23 s1288c1f19;
  ::S1288C10_nt s1288c1f20;
  ::S1288C10_nt s1288c1f21;
  void *s1288c1f22;
  int s1288c1f23;
  void *s1288c1f24;
  ::S1409C14_nt s1288c1f25;
  ::S1409C14_nt s1288c1f26;
  int s1288c1f27[11];
  void *s1288c1f28;
  ::S1409C14_nt s1288c1f29;
  int s1288c1f30[13];
  void *s1288c1f31;
  ::S1288C17_nt s1288c1f32;
  virtual  ~S1288C1(); // _ZN7S1288C1D1Ev
  virtual void  v1(); // _ZN7S1288C12v1Ev
  virtual void  v2(); // _ZN7S1288C12v2Ev
  virtual void  v3(); // _ZN7S1288C12v3Ev
  virtual void  v4(); // _ZN7S1288C12v4Ev
  virtual void  v5(); // _ZN7S1288C12v5Ev
  virtual void  v6(); // _ZN7S1288C12v6Ev
  virtual void  v7(); // _ZN7S1288C12v7Ev
  virtual void  v8(); // _ZN7S1288C12v8Ev
  virtual void  v9(); // _ZN7S1288C12v9Ev
  S1288C1(); // tgen
};
//SIG(1 S1288C1) C1{ BC2{ BC3{ BC4{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v74 v75 v76 v77 v78 Fp FC5} vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fp[2] FC6{ BC7{ m Fp Fi[2]}} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC8{ BC7} FC9{ BC7} FC10{ BC11{ m FC12{ BC7} Fp Fi}} FC10 Fp Fi Fp FC13{ m Fi[3]} FC13 Fi[11] Fp FC13 Fi[13] Fp FC14{ m Fp FC5}}


 S1288C1 ::~S1288C1(){ note_dtor("S1288C1", this);}
void  S1288C1 ::v1(){vfunc_called(this, "_ZN7S1288C12v1Ev");}
void  S1288C1 ::v2(){vfunc_called(this, "_ZN7S1288C12v2Ev");}
void  S1288C1 ::v3(){vfunc_called(this, "_ZN7S1288C12v3Ev");}
void  S1288C1 ::v4(){vfunc_called(this, "_ZN7S1288C12v4Ev");}
void  S1288C1 ::v5(){vfunc_called(this, "_ZN7S1288C12v5Ev");}
void  S1288C1 ::v6(){vfunc_called(this, "_ZN7S1288C12v6Ev");}
void  S1288C1 ::v7(){vfunc_called(this, "_ZN7S1288C12v7Ev");}
void  S1288C1 ::v8(){vfunc_called(this, "_ZN7S1288C12v8Ev");}
void  S1288C1 ::v9(){vfunc_called(this, "_ZN7S1288C12v9Ev");}
S1288C1 ::S1288C1(){ note_ctor("S1288C1", this);} // tgen

static void Test_S1288C1()
{
  extern Class_Descriptor cd_S1288C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(59,85)];
    init_test(&cd_S1288C1, buf);
    S1288C1 *dp, &lv = *(dp=new (buf) S1288C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(464,336), "sizeof(S1288C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1288C1)");
    check_base_class_offset(lv, (S1288C4*)(S1288C3_nt*)(S1288C2_nt*), 0, "S1288C1");
    check_base_class_offset(lv, (S1288C3_nt*)(S1288C2_nt*), 0, "S1288C1");
    check_base_class_offset(lv, (S1288C2_nt*), 0, "S1288C1");
    check_field_offset(lv, s1288c1f0, ABISELECT(136,84), "S1288C1.s1288c1f0");
    check_field_offset(lv, s1288c1f1, ABISELECT(152,92), "S1288C1.s1288c1f1");
    set_bf_and_test(lv, s1288c1f2, ABISELECT(168,104), 0, 1, 1, "S1288C1");
    set_bf_and_test(lv, s1288c1f3, ABISELECT(168,104), 1, 1, 1, "S1288C1");
    set_bf_and_test(lv, s1288c1f4, ABISELECT(168,104), 2, 1, 1, "S1288C1");
    set_bf_and_test(lv, s1288c1f5, ABISELECT(168,104), 3, 1, 1, "S1288C1");
    set_bf_and_test(lv, s1288c1f6, ABISELECT(168,104), 4, 1, 1, "S1288C1");
    set_bf_and_test(lv, s1288c1f7, ABISELECT(168,104), 5, 1, 1, "S1288C1");
    set_bf_and_test(lv, s1288c1f8, ABISELECT(168,104), 6, 1, 1, "S1288C1");
    set_bf_and_test(lv, s1288c1f9, ABISELECT(168,104), 7, 1, 1, "S1288C1");
    set_bf_and_test(lv, s1288c1f10, ABISELECT(169,105), 0, 1, 1, "S1288C1");
    set_bf_and_test(lv, s1288c1f11, ABISELECT(169,105), 1, 1, 1, "S1288C1");
    set_bf_and_test(lv, s1288c1f12, ABISELECT(169,105), 2, 1, 1, "S1288C1");
    set_bf_and_test(lv, s1288c1f13, ABISELECT(169,105), 3, 1, 1, "S1288C1");
    set_bf_and_test(lv, s1288c1f14, ABISELECT(169,105), 4, 1, 1, "S1288C1");
    set_bf_and_test(lv, s1288c1f15, ABISELECT(169,105), 5, 1, 1, "S1288C1");
    set_bf_and_test(lv, s1288c1f16, ABISELECT(169,105), 6, 1, 1, "S1288C1");
    set_bf_and_test(lv, s1288c1f17, ABISELECT(169,105), 7, 1, 1, "S1288C1");
    check_field_offset(lv, s1288c1f18, ABISELECT(176,108), "S1288C1.s1288c1f18");
    check_field_offset(lv, s1288c1f19, ABISELECT(192,120), "S1288C1.s1288c1f19");
    check_field_offset(lv, s1288c1f20, ABISELECT(208,132), "S1288C1.s1288c1f20");
    check_field_offset(lv, s1288c1f21, ABISELECT(240,152), "S1288C1.s1288c1f21");
    check_field_offset(lv, s1288c1f22, ABISELECT(272,172), "S1288C1.s1288c1f22");
    check_field_offset(lv, s1288c1f23, ABISELECT(280,176), "S1288C1.s1288c1f23");
    check_field_offset(lv, s1288c1f24, ABISELECT(288,180), "S1288C1.s1288c1f24");
    check_field_offset(lv, s1288c1f25, ABISELECT(296,184), "S1288C1.s1288c1f25");
    check_field_offset(lv, s1288c1f26, ABISELECT(308,196), "S1288C1.s1288c1f26");
    check_field_offset(lv, s1288c1f27, ABISELECT(320,208), "S1288C1.s1288c1f27");
    check_field_offset(lv, s1288c1f28, ABISELECT(368,252), "S1288C1.s1288c1f28");
    check_field_offset(lv, s1288c1f29, ABISELECT(376,256), "S1288C1.s1288c1f29");
    check_field_offset(lv, s1288c1f30, ABISELECT(388,268), "S1288C1.s1288c1f30");
    check_field_offset(lv, s1288c1f31, ABISELECT(440,320), "S1288C1.s1288c1f31");
    check_field_offset(lv, s1288c1f32, ABISELECT(448,324), "S1288C1.s1288c1f32");
    test_class_info(&lv, &cd_S1288C1);
    dp->~S1288C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1288C1(Test_S1288C1, "S1288C1", ABISELECT(464,336));

#else // __cplusplus

extern void _ZN7S1288C1C1Ev();
extern void _ZN7S1288C1D1Ev();
Name_Map name_map_S1288C1[] = {
  NSPAIR(_ZN7S1288C1C1Ev),
  NSPAIR(_ZN7S1288C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1288C4;
extern VTBL_ENTRY _ZTI7S1288C4[];
extern  VTBL_ENTRY _ZTV7S1288C4[];
extern Class_Descriptor cd_S1288C3_nt;
extern VTBL_ENTRY _ZTI10S1288C3_nt[];
extern  VTBL_ENTRY _ZTV10S1288C3_nt[];
extern Class_Descriptor cd_S1288C2_nt;
extern VTBL_ENTRY _ZTI10S1288C2_nt[];
extern  VTBL_ENTRY _ZTV10S1288C2_nt[];
static Base_Class bases_S1288C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1288C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1288C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1288C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1288C1[];
extern void _ZN7S1288C1D1Ev();
extern void _ZN7S1288C1D0Ev();
extern void _ZN7S1288C43v10Ev();
extern void _ZN7S1288C43v11Ev();
extern void _ZN7S1288C43v12Ev();
extern void _ZN7S1288C43v13Ev();
extern void _ZN7S1288C43v14Ev();
extern void _ZN7S1288C43v15Ev();
extern void _ZN7S1288C43v16Ev();
extern void _ZN7S1288C43v17Ev();
extern void _ZN7S1288C43v18Ev();
extern void _ZN7S1288C43v19Ev();
extern void _ZN7S1288C43v20Ev();
extern void _ZN7S1288C43v21Ev();
extern void _ZN7S1288C43v22Ev();
extern void _ZN7S1288C43v23Ev();
extern void _ZN7S1288C43v24Ev();
extern void _ZN7S1288C43v25Ev();
extern void _ZN7S1288C43v26Ev();
extern void _ZN7S1288C43v27Ev();
extern void _ZN7S1288C43v28Ev();
extern void _ZN7S1288C43v29Ev();
extern void _ZN7S1288C43v30Ev();
extern void _ZN7S1288C43v31Ev();
extern void _ZN7S1288C43v32Ev();
extern void _ZN7S1288C43v33Ev();
extern void _ZN7S1288C43v34Ev();
extern void _ZN7S1288C43v35Ev();
extern void _ZN7S1288C43v36Ev();
extern void _ZN7S1288C43v37Ev();
extern void _ZN7S1288C43v38Ev();
extern void _ZN7S1288C43v39Ev();
extern void _ZN7S1288C43v40Ev();
extern void _ZN7S1288C43v41Ev();
extern void _ZN7S1288C43v42Ev();
extern void _ZN7S1288C43v43Ev();
extern void _ZN7S1288C43v44Ev();
extern void _ZN7S1288C43v45Ev();
extern void _ZN7S1288C43v46Ev();
extern void _ZN7S1288C43v47Ev();
extern void _ZN7S1288C43v48Ev();
extern void _ZN7S1288C43v49Ev();
extern void _ZN7S1288C43v50Ev();
extern void _ZN7S1288C43v51Ev();
extern void _ZN7S1288C43v52Ev();
extern void _ZN7S1288C43v53Ev();
extern void _ZN7S1288C43v54Ev();
extern void _ZN7S1288C43v55Ev();
extern void _ZN7S1288C43v56Ev();
extern void _ZN7S1288C43v57Ev();
extern void _ZN7S1288C43v58Ev();
extern void _ZN7S1288C43v59Ev();
extern void _ZN7S1288C43v60Ev();
extern void _ZN7S1288C43v61Ev();
extern void _ZN7S1288C43v62Ev();
extern void _ZN7S1288C43v63Ev();
extern void _ZN7S1288C43v64Ev();
extern void _ZN7S1288C43v65Ev();
extern void _ZN7S1288C43v66Ev();
extern void _ZN7S1288C43v67Ev();
extern void _ZN7S1288C43v68Ev();
extern void _ZN7S1288C43v69Ev();
extern void _ZN7S1288C43v70Ev();
extern void _ZN7S1288C43v71Ev();
extern void _ZN7S1288C43v72Ev();
extern void _ZN7S1288C43v73Ev();
extern void _ZN10S1288C3_nt3v74Ev();
extern void _ZN10S1288C3_nt3v75Ev();
extern void _ZN10S1288C3_nt3v76Ev();
extern void _ZN10S1288C3_nt3v77Ev();
extern void _ZN10S1288C3_nt3v78Ev();
extern void _ZN10S1288C2_nt3v79Ev();
extern void _ZN10S1288C2_nt3v80Ev();
extern void _ZN10S1288C2_nt3v81Ev();
extern void _ZN10S1288C2_nt3v82Ev();
extern void _ZN10S1288C2_nt3v83Ev();
extern void _ZN10S1288C2_nt3v84Ev();
extern void _ZN10S1288C2_nt3v85Ev();
extern void _ZN10S1288C2_nt3v86Ev();
extern void _ZN10S1288C2_nt3v87Ev();
extern void _ZN10S1288C2_nt3v88Ev();
extern void _ZN10S1288C2_nt3v89Ev();
extern void _ZN10S1288C2_nt3v90Ev();
extern void _ZN10S1288C2_nt3v91Ev();
extern void _ZN10S1288C2_nt3v92Ev();
extern void _ZN10S1288C2_nt3v93Ev();
extern void _ZN10S1288C2_nt3v94Ev();
extern void _ZN10S1288C2_nt3v95Ev();
extern void _ZN10S1288C2_nt3v96Ev();
extern void _ZN10S1288C2_nt3v97Ev();
extern void _ZN10S1288C2_nt3v98Ev();
extern void _ZN10S1288C2_nt3v99Ev();
extern void _ZN10S1288C2_nt4v100Ev();
extern void _ZN7S1288C12v1Ev();
extern void _ZN7S1288C12v2Ev();
extern void _ZN7S1288C12v3Ev();
extern void _ZN7S1288C12v4Ev();
extern void _ZN7S1288C12v5Ev();
extern void _ZN7S1288C12v6Ev();
extern void _ZN7S1288C12v7Ev();
extern void _ZN7S1288C12v8Ev();
extern void _ZN7S1288C12v9Ev();
static  VTBL_ENTRY vtc_S1288C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1288C1[0]),
  (VTBL_ENTRY)&_ZN7S1288C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1288C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1288C43v73Ev,
  (VTBL_ENTRY)&_ZN10S1288C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1288C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1288C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1288C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1288C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1288C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN7S1288C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1288C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1288C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1288C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1288C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1288C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1288C12v7Ev,
  (VTBL_ENTRY)&_ZN7S1288C12v8Ev,
  (VTBL_ENTRY)&_ZN7S1288C12v9Ev,
};
extern VTBL_ENTRY _ZTI7S1288C1[];
extern  VTBL_ENTRY _ZTV7S1288C1[];
Class_Descriptor cd_S1288C1 = {  "S1288C1", // class name
  bases_S1288C1, 3,
  &(vtc_S1288C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(464,336), // object size
  NSPAIRA(_ZTI7S1288C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1288C1),104, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3046C3  {
  int s3046c3f0;
  __tsi64 s3046c3f1;
  void *s3046c3f2[4];
  int s3046c3f3[2];
  void *s3046c3f4;
  ::S1409C5_nt s3046c3f5;
  void *s3046c3f6[2];
  virtual  ~S3046C3(); // _ZN7S3046C3D1Ev
  virtual void  v18(); // _ZN7S3046C33v18Ev
  virtual void  v19(); // _ZN7S3046C33v19Ev
  virtual void  v20(); // _ZN7S3046C33v20Ev
  virtual void  v21(); // _ZN7S3046C33v21Ev
  virtual void  v22(); // _ZN7S3046C33v22Ev
  virtual void  v23(); // _ZN7S3046C33v23Ev
  virtual void  v24(); // _ZN7S3046C33v24Ev
  virtual void  v25(); // _ZN7S3046C33v25Ev
  virtual void  v26(); // _ZN7S3046C33v26Ev
  virtual void  v27(); // _ZN7S3046C33v27Ev
  virtual void  v28(); // _ZN7S3046C33v28Ev
  virtual void  v29(); // _ZN7S3046C33v29Ev
  virtual void  v30(); // _ZN7S3046C33v30Ev
  virtual void  v31(); // _ZN7S3046C33v31Ev
  virtual void  v32(); // _ZN7S3046C33v32Ev
  virtual void  v33(); // _ZN7S3046C33v33Ev
  virtual void  v34(); // _ZN7S3046C33v34Ev
  virtual void  v35(); // _ZN7S3046C33v35Ev
  virtual void  v36(); // _ZN7S3046C33v36Ev
  virtual void  v37(); // _ZN7S3046C33v37Ev
  virtual void  v38(); // _ZN7S3046C33v38Ev
  virtual void  v39(); // _ZN7S3046C33v39Ev
  virtual void  v40(); // _ZN7S3046C33v40Ev
  virtual void  v41(); // _ZN7S3046C33v41Ev
  virtual void  v42(); // _ZN7S3046C33v42Ev
  virtual void  v43(); // _ZN7S3046C33v43Ev
  virtual void  v44(); // _ZN7S3046C33v44Ev
  virtual void  v45(); // _ZN7S3046C33v45Ev
  virtual void  v46(); // _ZN7S3046C33v46Ev
  virtual void  v47(); // _ZN7S3046C33v47Ev
  virtual void  v48(); // _ZN7S3046C33v48Ev
  virtual void  v49(); // _ZN7S3046C33v49Ev
  virtual void  v50(); // _ZN7S3046C33v50Ev
  virtual void  v51(); // _ZN7S3046C33v51Ev
  virtual void  v52(); // _ZN7S3046C33v52Ev
  virtual void  v53(); // _ZN7S3046C33v53Ev
  virtual void  v54(); // _ZN7S3046C33v54Ev
  virtual void  v55(); // _ZN7S3046C33v55Ev
  virtual void  v56(); // _ZN7S3046C33v56Ev
  virtual void  v57(); // _ZN7S3046C33v57Ev
  virtual void  v58(); // _ZN7S3046C33v58Ev
  virtual void  v59(); // _ZN7S3046C33v59Ev
  virtual void  v60(); // _ZN7S3046C33v60Ev
  virtual void  v61(); // _ZN7S3046C33v61Ev
  virtual void  v62(); // _ZN7S3046C33v62Ev
  virtual void  v63(); // _ZN7S3046C33v63Ev
  virtual void  v64(); // _ZN7S3046C33v64Ev
  virtual void  v65(); // _ZN7S3046C33v65Ev
  virtual void  v66(); // _ZN7S3046C33v66Ev
  virtual void  v67(); // _ZN7S3046C33v67Ev
  virtual void  v68(); // _ZN7S3046C33v68Ev
  virtual void  v69(); // _ZN7S3046C33v69Ev
  virtual void  v70(); // _ZN7S3046C33v70Ev
  virtual void  v71(); // _ZN7S3046C33v71Ev
  virtual void  v72(); // _ZN7S3046C33v72Ev
  virtual void  v73(); // _ZN7S3046C33v73Ev
  virtual void  v74(); // _ZN7S3046C33v74Ev
  virtual void  v75(); // _ZN7S3046C33v75Ev
  virtual void  v76(); // _ZN7S3046C33v76Ev
  virtual void  v77(); // _ZN7S3046C33v77Ev
  virtual void  v78(); // _ZN7S3046C33v78Ev
  virtual void  v79(); // _ZN7S3046C33v79Ev
  virtual void  v80(); // _ZN7S3046C33v80Ev
  virtual void  v81(); // _ZN7S3046C33v81Ev
  S3046C3(); // tgen
};
//SIG(-1 S3046C3) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S3046C3 ::~S3046C3(){ note_dtor("S3046C3", this);}
void  S3046C3 ::v18(){vfunc_called(this, "_ZN7S3046C33v18Ev");}
void  S3046C3 ::v19(){vfunc_called(this, "_ZN7S3046C33v19Ev");}
void  S3046C3 ::v20(){vfunc_called(this, "_ZN7S3046C33v20Ev");}
void  S3046C3 ::v21(){vfunc_called(this, "_ZN7S3046C33v21Ev");}
void  S3046C3 ::v22(){vfunc_called(this, "_ZN7S3046C33v22Ev");}
void  S3046C3 ::v23(){vfunc_called(this, "_ZN7S3046C33v23Ev");}
void  S3046C3 ::v24(){vfunc_called(this, "_ZN7S3046C33v24Ev");}
void  S3046C3 ::v25(){vfunc_called(this, "_ZN7S3046C33v25Ev");}
void  S3046C3 ::v26(){vfunc_called(this, "_ZN7S3046C33v26Ev");}
void  S3046C3 ::v27(){vfunc_called(this, "_ZN7S3046C33v27Ev");}
void  S3046C3 ::v28(){vfunc_called(this, "_ZN7S3046C33v28Ev");}
void  S3046C3 ::v29(){vfunc_called(this, "_ZN7S3046C33v29Ev");}
void  S3046C3 ::v30(){vfunc_called(this, "_ZN7S3046C33v30Ev");}
void  S3046C3 ::v31(){vfunc_called(this, "_ZN7S3046C33v31Ev");}
void  S3046C3 ::v32(){vfunc_called(this, "_ZN7S3046C33v32Ev");}
void  S3046C3 ::v33(){vfunc_called(this, "_ZN7S3046C33v33Ev");}
void  S3046C3 ::v34(){vfunc_called(this, "_ZN7S3046C33v34Ev");}
void  S3046C3 ::v35(){vfunc_called(this, "_ZN7S3046C33v35Ev");}
void  S3046C3 ::v36(){vfunc_called(this, "_ZN7S3046C33v36Ev");}
void  S3046C3 ::v37(){vfunc_called(this, "_ZN7S3046C33v37Ev");}
void  S3046C3 ::v38(){vfunc_called(this, "_ZN7S3046C33v38Ev");}
void  S3046C3 ::v39(){vfunc_called(this, "_ZN7S3046C33v39Ev");}
void  S3046C3 ::v40(){vfunc_called(this, "_ZN7S3046C33v40Ev");}
void  S3046C3 ::v41(){vfunc_called(this, "_ZN7S3046C33v41Ev");}
void  S3046C3 ::v42(){vfunc_called(this, "_ZN7S3046C33v42Ev");}
void  S3046C3 ::v43(){vfunc_called(this, "_ZN7S3046C33v43Ev");}
void  S3046C3 ::v44(){vfunc_called(this, "_ZN7S3046C33v44Ev");}
void  S3046C3 ::v45(){vfunc_called(this, "_ZN7S3046C33v45Ev");}
void  S3046C3 ::v46(){vfunc_called(this, "_ZN7S3046C33v46Ev");}
void  S3046C3 ::v47(){vfunc_called(this, "_ZN7S3046C33v47Ev");}
void  S3046C3 ::v48(){vfunc_called(this, "_ZN7S3046C33v48Ev");}
void  S3046C3 ::v49(){vfunc_called(this, "_ZN7S3046C33v49Ev");}
void  S3046C3 ::v50(){vfunc_called(this, "_ZN7S3046C33v50Ev");}
void  S3046C3 ::v51(){vfunc_called(this, "_ZN7S3046C33v51Ev");}
void  S3046C3 ::v52(){vfunc_called(this, "_ZN7S3046C33v52Ev");}
void  S3046C3 ::v53(){vfunc_called(this, "_ZN7S3046C33v53Ev");}
void  S3046C3 ::v54(){vfunc_called(this, "_ZN7S3046C33v54Ev");}
void  S3046C3 ::v55(){vfunc_called(this, "_ZN7S3046C33v55Ev");}
void  S3046C3 ::v56(){vfunc_called(this, "_ZN7S3046C33v56Ev");}
void  S3046C3 ::v57(){vfunc_called(this, "_ZN7S3046C33v57Ev");}
void  S3046C3 ::v58(){vfunc_called(this, "_ZN7S3046C33v58Ev");}
void  S3046C3 ::v59(){vfunc_called(this, "_ZN7S3046C33v59Ev");}
void  S3046C3 ::v60(){vfunc_called(this, "_ZN7S3046C33v60Ev");}
void  S3046C3 ::v61(){vfunc_called(this, "_ZN7S3046C33v61Ev");}
void  S3046C3 ::v62(){vfunc_called(this, "_ZN7S3046C33v62Ev");}
void  S3046C3 ::v63(){vfunc_called(this, "_ZN7S3046C33v63Ev");}
void  S3046C3 ::v64(){vfunc_called(this, "_ZN7S3046C33v64Ev");}
void  S3046C3 ::v65(){vfunc_called(this, "_ZN7S3046C33v65Ev");}
void  S3046C3 ::v66(){vfunc_called(this, "_ZN7S3046C33v66Ev");}
void  S3046C3 ::v67(){vfunc_called(this, "_ZN7S3046C33v67Ev");}
void  S3046C3 ::v68(){vfunc_called(this, "_ZN7S3046C33v68Ev");}
void  S3046C3 ::v69(){vfunc_called(this, "_ZN7S3046C33v69Ev");}
void  S3046C3 ::v70(){vfunc_called(this, "_ZN7S3046C33v70Ev");}
void  S3046C3 ::v71(){vfunc_called(this, "_ZN7S3046C33v71Ev");}
void  S3046C3 ::v72(){vfunc_called(this, "_ZN7S3046C33v72Ev");}
void  S3046C3 ::v73(){vfunc_called(this, "_ZN7S3046C33v73Ev");}
void  S3046C3 ::v74(){vfunc_called(this, "_ZN7S3046C33v74Ev");}
void  S3046C3 ::v75(){vfunc_called(this, "_ZN7S3046C33v75Ev");}
void  S3046C3 ::v76(){vfunc_called(this, "_ZN7S3046C33v76Ev");}
void  S3046C3 ::v77(){vfunc_called(this, "_ZN7S3046C33v77Ev");}
void  S3046C3 ::v78(){vfunc_called(this, "_ZN7S3046C33v78Ev");}
void  S3046C3 ::v79(){vfunc_called(this, "_ZN7S3046C33v79Ev");}
void  S3046C3 ::v80(){vfunc_called(this, "_ZN7S3046C33v80Ev");}
void  S3046C3 ::v81(){vfunc_called(this, "_ZN7S3046C33v81Ev");}
S3046C3 ::S3046C3(){ note_ctor("S3046C3", this);} // tgen

static void Test_S3046C3()
{
  extern Class_Descriptor cd_S3046C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S3046C3, buf);
    S3046C3 *dp, &lv = *(dp=new (buf) S3046C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S3046C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3046C3)");
    check_field_offset(lv, s3046c3f0, ABISELECT(8,4), "S3046C3.s3046c3f0");
    check_field_offset(lv, s3046c3f1, ABISELECT(16,8), "S3046C3.s3046c3f1");
    check_field_offset(lv, s3046c3f2, ABISELECT(24,16), "S3046C3.s3046c3f2");
    check_field_offset(lv, s3046c3f3, ABISELECT(56,32), "S3046C3.s3046c3f3");
    check_field_offset(lv, s3046c3f4, ABISELECT(64,40), "S3046C3.s3046c3f4");
    check_field_offset(lv, s3046c3f5, ABISELECT(72,44), "S3046C3.s3046c3f5");
    check_field_offset(lv, s3046c3f6, ABISELECT(80,52), "S3046C3.s3046c3f6");
    test_class_info(&lv, &cd_S3046C3);
    dp->~S3046C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3046C3(Test_S3046C3, "S3046C3", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S3046C3C1Ev();
extern void _ZN7S3046C3D1Ev();
Name_Map name_map_S3046C3[] = {
  NSPAIR(_ZN7S3046C3C1Ev),
  NSPAIR(_ZN7S3046C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S3046C3[];
extern void _ZN7S3046C3D1Ev();
extern void _ZN7S3046C3D0Ev();
extern void _ZN7S3046C33v18Ev();
extern void _ZN7S3046C33v19Ev();
extern void _ZN7S3046C33v20Ev();
extern void _ZN7S3046C33v21Ev();
extern void _ZN7S3046C33v22Ev();
extern void _ZN7S3046C33v23Ev();
extern void _ZN7S3046C33v24Ev();
extern void _ZN7S3046C33v25Ev();
extern void _ZN7S3046C33v26Ev();
extern void _ZN7S3046C33v27Ev();
extern void _ZN7S3046C33v28Ev();
extern void _ZN7S3046C33v29Ev();
extern void _ZN7S3046C33v30Ev();
extern void _ZN7S3046C33v31Ev();
extern void _ZN7S3046C33v32Ev();
extern void _ZN7S3046C33v33Ev();
extern void _ZN7S3046C33v34Ev();
extern void _ZN7S3046C33v35Ev();
extern void _ZN7S3046C33v36Ev();
extern void _ZN7S3046C33v37Ev();
extern void _ZN7S3046C33v38Ev();
extern void _ZN7S3046C33v39Ev();
extern void _ZN7S3046C33v40Ev();
extern void _ZN7S3046C33v41Ev();
extern void _ZN7S3046C33v42Ev();
extern void _ZN7S3046C33v43Ev();
extern void _ZN7S3046C33v44Ev();
extern void _ZN7S3046C33v45Ev();
extern void _ZN7S3046C33v46Ev();
extern void _ZN7S3046C33v47Ev();
extern void _ZN7S3046C33v48Ev();
extern void _ZN7S3046C33v49Ev();
extern void _ZN7S3046C33v50Ev();
extern void _ZN7S3046C33v51Ev();
extern void _ZN7S3046C33v52Ev();
extern void _ZN7S3046C33v53Ev();
extern void _ZN7S3046C33v54Ev();
extern void _ZN7S3046C33v55Ev();
extern void _ZN7S3046C33v56Ev();
extern void _ZN7S3046C33v57Ev();
extern void _ZN7S3046C33v58Ev();
extern void _ZN7S3046C33v59Ev();
extern void _ZN7S3046C33v60Ev();
extern void _ZN7S3046C33v61Ev();
extern void _ZN7S3046C33v62Ev();
extern void _ZN7S3046C33v63Ev();
extern void _ZN7S3046C33v64Ev();
extern void _ZN7S3046C33v65Ev();
extern void _ZN7S3046C33v66Ev();
extern void _ZN7S3046C33v67Ev();
extern void _ZN7S3046C33v68Ev();
extern void _ZN7S3046C33v69Ev();
extern void _ZN7S3046C33v70Ev();
extern void _ZN7S3046C33v71Ev();
extern void _ZN7S3046C33v72Ev();
extern void _ZN7S3046C33v73Ev();
extern void _ZN7S3046C33v74Ev();
extern void _ZN7S3046C33v75Ev();
extern void _ZN7S3046C33v76Ev();
extern void _ZN7S3046C33v77Ev();
extern void _ZN7S3046C33v78Ev();
extern void _ZN7S3046C33v79Ev();
extern void _ZN7S3046C33v80Ev();
extern void _ZN7S3046C33v81Ev();
static  VTBL_ENTRY vtc_S3046C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3046C3[0]),
  (VTBL_ENTRY)&_ZN7S3046C3D1Ev,
  (VTBL_ENTRY)&_ZN7S3046C3D0Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v18Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v19Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v20Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v21Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v22Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v23Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v24Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v25Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v26Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v27Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v28Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v29Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v30Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v31Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v32Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v33Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v34Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v35Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v36Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v37Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v38Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v39Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v40Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v41Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v42Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v43Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v44Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v45Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v46Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v47Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v48Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v49Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v50Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v51Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v52Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v53Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v54Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v55Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v56Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v57Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v58Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v59Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v60Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v61Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v62Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v63Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v64Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v65Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v66Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v67Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v68Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v69Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v70Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v71Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v72Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v73Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v74Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v75Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v76Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v77Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v78Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v79Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v80Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v81Ev,
};
extern VTBL_ENTRY _ZTI7S3046C3[];
extern  VTBL_ENTRY _ZTV7S3046C3[];
Class_Descriptor cd_S3046C3 = {  "S3046C3", // class name
  0,0,//no base classes
  &(vtc_S3046C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S3046C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S3046C3),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3046C2  : S3046C3 {
  int s3046c2f0;
  ::S1409C30 s3046c2f1;
  virtual  ~S3046C2(); // _ZN7S3046C2D1Ev
  virtual void  v82(); // _ZN7S3046C23v82Ev
  virtual void  v83(); // _ZN7S3046C23v83Ev
  virtual void  v84(); // _ZN7S3046C23v84Ev
  virtual void  v85(); // _ZN7S3046C23v85Ev
  virtual void  v86(); // _ZN7S3046C23v86Ev
  virtual void  v87(); // _ZN7S3046C23v87Ev
  virtual void  v88(); // _ZN7S3046C23v88Ev
  virtual void  v89(); // _ZN7S3046C23v89Ev
  virtual void  v90(); // _ZN7S3046C23v90Ev
  virtual void  v91(); // _ZN7S3046C23v91Ev
  virtual void  v92(); // _ZN7S3046C23v92Ev
  virtual void  v93(); // _ZN7S3046C23v93Ev
  virtual void  v94(); // _ZN7S3046C23v94Ev
  virtual void  v95(); // _ZN7S3046C23v95Ev
  virtual void  v96(); // _ZN7S3046C23v96Ev
  virtual void  v97(); // _ZN7S3046C23v97Ev
  virtual void  v98(); // _ZN7S3046C23v98Ev
  virtual void  v99(); // _ZN7S3046C23v99Ev
  S3046C2(); // tgen
};
//SIG(-1 S3046C2) C1{ BC2{ vd v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 Fi FC4{ BC5{ BC6{ m Fp Fi[2]}}}}


 S3046C2 ::~S3046C2(){ note_dtor("S3046C2", this);}
void  S3046C2 ::v82(){vfunc_called(this, "_ZN7S3046C23v82Ev");}
void  S3046C2 ::v83(){vfunc_called(this, "_ZN7S3046C23v83Ev");}
void  S3046C2 ::v84(){vfunc_called(this, "_ZN7S3046C23v84Ev");}
void  S3046C2 ::v85(){vfunc_called(this, "_ZN7S3046C23v85Ev");}
void  S3046C2 ::v86(){vfunc_called(this, "_ZN7S3046C23v86Ev");}
void  S3046C2 ::v87(){vfunc_called(this, "_ZN7S3046C23v87Ev");}
void  S3046C2 ::v88(){vfunc_called(this, "_ZN7S3046C23v88Ev");}
void  S3046C2 ::v89(){vfunc_called(this, "_ZN7S3046C23v89Ev");}
void  S3046C2 ::v90(){vfunc_called(this, "_ZN7S3046C23v90Ev");}
void  S3046C2 ::v91(){vfunc_called(this, "_ZN7S3046C23v91Ev");}
void  S3046C2 ::v92(){vfunc_called(this, "_ZN7S3046C23v92Ev");}
void  S3046C2 ::v93(){vfunc_called(this, "_ZN7S3046C23v93Ev");}
void  S3046C2 ::v94(){vfunc_called(this, "_ZN7S3046C23v94Ev");}
void  S3046C2 ::v95(){vfunc_called(this, "_ZN7S3046C23v95Ev");}
void  S3046C2 ::v96(){vfunc_called(this, "_ZN7S3046C23v96Ev");}
void  S3046C2 ::v97(){vfunc_called(this, "_ZN7S3046C23v97Ev");}
void  S3046C2 ::v98(){vfunc_called(this, "_ZN7S3046C23v98Ev");}
void  S3046C2 ::v99(){vfunc_called(this, "_ZN7S3046C23v99Ev");}
S3046C2 ::S3046C2(){ note_ctor("S3046C2", this);} // tgen

static void Test_S3046C2()
{
  extern Class_Descriptor cd_S3046C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(16,20)];
    init_test(&cd_S3046C2, buf);
    S3046C2 *dp, &lv = *(dp=new (buf) S3046C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(120,76), "sizeof(S3046C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3046C2)");
    check_base_class_offset(lv, (S3046C3*), 0, "S3046C2");
    check_field_offset(lv, s3046c2f0, ABISELECT(96,60), "S3046C2.s3046c2f0");
    check_field_offset(lv, s3046c2f1, ABISELECT(104,64), "S3046C2.s3046c2f1");
    test_class_info(&lv, &cd_S3046C2);
    dp->~S3046C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3046C2(Test_S3046C2, "S3046C2", ABISELECT(120,76));

#else // __cplusplus

extern void _ZN7S3046C2C1Ev();
extern void _ZN7S3046C2D1Ev();
Name_Map name_map_S3046C2[] = {
  NSPAIR(_ZN7S3046C2C1Ev),
  NSPAIR(_ZN7S3046C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3046C3;
extern VTBL_ENTRY _ZTI7S3046C3[];
extern  VTBL_ENTRY _ZTV7S3046C3[];
static Base_Class bases_S3046C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3046C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3046C2[];
extern void _ZN7S3046C2D1Ev();
extern void _ZN7S3046C2D0Ev();
extern void _ZN7S3046C33v18Ev();
extern void _ZN7S3046C33v19Ev();
extern void _ZN7S3046C33v20Ev();
extern void _ZN7S3046C33v21Ev();
extern void _ZN7S3046C33v22Ev();
extern void _ZN7S3046C33v23Ev();
extern void _ZN7S3046C33v24Ev();
extern void _ZN7S3046C33v25Ev();
extern void _ZN7S3046C33v26Ev();
extern void _ZN7S3046C33v27Ev();
extern void _ZN7S3046C33v28Ev();
extern void _ZN7S3046C33v29Ev();
extern void _ZN7S3046C33v30Ev();
extern void _ZN7S3046C33v31Ev();
extern void _ZN7S3046C33v32Ev();
extern void _ZN7S3046C33v33Ev();
extern void _ZN7S3046C33v34Ev();
extern void _ZN7S3046C33v35Ev();
extern void _ZN7S3046C33v36Ev();
extern void _ZN7S3046C33v37Ev();
extern void _ZN7S3046C33v38Ev();
extern void _ZN7S3046C33v39Ev();
extern void _ZN7S3046C33v40Ev();
extern void _ZN7S3046C33v41Ev();
extern void _ZN7S3046C33v42Ev();
extern void _ZN7S3046C33v43Ev();
extern void _ZN7S3046C33v44Ev();
extern void _ZN7S3046C33v45Ev();
extern void _ZN7S3046C33v46Ev();
extern void _ZN7S3046C33v47Ev();
extern void _ZN7S3046C33v48Ev();
extern void _ZN7S3046C33v49Ev();
extern void _ZN7S3046C33v50Ev();
extern void _ZN7S3046C33v51Ev();
extern void _ZN7S3046C33v52Ev();
extern void _ZN7S3046C33v53Ev();
extern void _ZN7S3046C33v54Ev();
extern void _ZN7S3046C33v55Ev();
extern void _ZN7S3046C33v56Ev();
extern void _ZN7S3046C33v57Ev();
extern void _ZN7S3046C33v58Ev();
extern void _ZN7S3046C33v59Ev();
extern void _ZN7S3046C33v60Ev();
extern void _ZN7S3046C33v61Ev();
extern void _ZN7S3046C33v62Ev();
extern void _ZN7S3046C33v63Ev();
extern void _ZN7S3046C33v64Ev();
extern void _ZN7S3046C33v65Ev();
extern void _ZN7S3046C33v66Ev();
extern void _ZN7S3046C33v67Ev();
extern void _ZN7S3046C33v68Ev();
extern void _ZN7S3046C33v69Ev();
extern void _ZN7S3046C33v70Ev();
extern void _ZN7S3046C33v71Ev();
extern void _ZN7S3046C33v72Ev();
extern void _ZN7S3046C33v73Ev();
extern void _ZN7S3046C33v74Ev();
extern void _ZN7S3046C33v75Ev();
extern void _ZN7S3046C33v76Ev();
extern void _ZN7S3046C33v77Ev();
extern void _ZN7S3046C33v78Ev();
extern void _ZN7S3046C33v79Ev();
extern void _ZN7S3046C33v80Ev();
extern void _ZN7S3046C33v81Ev();
extern void _ZN7S3046C23v82Ev();
extern void _ZN7S3046C23v83Ev();
extern void _ZN7S3046C23v84Ev();
extern void _ZN7S3046C23v85Ev();
extern void _ZN7S3046C23v86Ev();
extern void _ZN7S3046C23v87Ev();
extern void _ZN7S3046C23v88Ev();
extern void _ZN7S3046C23v89Ev();
extern void _ZN7S3046C23v90Ev();
extern void _ZN7S3046C23v91Ev();
extern void _ZN7S3046C23v92Ev();
extern void _ZN7S3046C23v93Ev();
extern void _ZN7S3046C23v94Ev();
extern void _ZN7S3046C23v95Ev();
extern void _ZN7S3046C23v96Ev();
extern void _ZN7S3046C23v97Ev();
extern void _ZN7S3046C23v98Ev();
extern void _ZN7S3046C23v99Ev();
static  VTBL_ENTRY vtc_S3046C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3046C2[0]),
  (VTBL_ENTRY)&_ZN7S3046C2D1Ev,
  (VTBL_ENTRY)&_ZN7S3046C2D0Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v18Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v19Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v20Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v21Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v22Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v23Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v24Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v25Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v26Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v27Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v28Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v29Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v30Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v31Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v32Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v33Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v34Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v35Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v36Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v37Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v38Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v39Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v40Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v41Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v42Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v43Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v44Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v45Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v46Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v47Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v48Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v49Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v50Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v51Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v52Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v53Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v54Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v55Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v56Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v57Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v58Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v59Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v60Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v61Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v62Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v63Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v64Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v65Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v66Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v67Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v68Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v69Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v70Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v71Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v72Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v73Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v74Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v75Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v76Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v77Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v78Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v79Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v80Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v81Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v82Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v83Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v84Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v85Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v86Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v87Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v88Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v89Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v90Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v91Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v92Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v93Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v94Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v95Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v96Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v97Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v98Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v99Ev,
};
extern VTBL_ENTRY _ZTI7S3046C2[];
extern  VTBL_ENTRY _ZTV7S3046C2[];
Class_Descriptor cd_S3046C2 = {  "S3046C2", // class name
  bases_S3046C2, 1,
  &(vtc_S3046C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(120,76), // object size
  NSPAIRA(_ZTI7S3046C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3046C2),86, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3046C14_nt  {
  int s3046c14f0[8];
  void *s3046c14f1;
  int s3046c14f2;
  void *s3046c14f3;
  virtual  ~S3046C14_nt(); // _ZN11S3046C14_ntD1Ev
  virtual void  v102(); // _ZN11S3046C14_nt4v102Ev
  virtual void  v103(); // _ZN11S3046C14_nt4v103Ev
  virtual void  v104(); // _ZN11S3046C14_nt4v104Ev
  virtual void  v105(); // _ZN11S3046C14_nt4v105Ev
  virtual void  v106(); // _ZN11S3046C14_nt4v106Ev
  S3046C14_nt(); // tgen
};
//SIG(-1 S3046C14_nt) C1{ vd v1 v2 v3 v4 v5 Fi[8] Fp Fi Fp}


 S3046C14_nt ::~S3046C14_nt(){ note_dtor("S3046C14_nt", this);}
void  S3046C14_nt ::v102(){vfunc_called(this, "_ZN11S3046C14_nt4v102Ev");}
void  S3046C14_nt ::v103(){vfunc_called(this, "_ZN11S3046C14_nt4v103Ev");}
void  S3046C14_nt ::v104(){vfunc_called(this, "_ZN11S3046C14_nt4v104Ev");}
void  S3046C14_nt ::v105(){vfunc_called(this, "_ZN11S3046C14_nt4v105Ev");}
void  S3046C14_nt ::v106(){vfunc_called(this, "_ZN11S3046C14_nt4v106Ev");}
S3046C14_nt ::S3046C14_nt(){ note_ctor("S3046C14_nt", this);} // tgen

//skip512 S3046C14_nt

#else // __cplusplus

extern void _ZN11S3046C14_ntC1Ev();
extern void _ZN11S3046C14_ntD1Ev();
Name_Map name_map_S3046C14_nt[] = {
  NSPAIR(_ZN11S3046C14_ntC1Ev),
  NSPAIR(_ZN11S3046C14_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S3046C14_nt[];
extern void _ZN11S3046C14_ntD1Ev();
extern void _ZN11S3046C14_ntD0Ev();
extern void _ZN11S3046C14_nt4v102Ev();
extern void _ZN11S3046C14_nt4v103Ev();
extern void _ZN11S3046C14_nt4v104Ev();
extern void _ZN11S3046C14_nt4v105Ev();
extern void _ZN11S3046C14_nt4v106Ev();
static  VTBL_ENTRY vtc_S3046C14_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S3046C14_nt[0]),
  (VTBL_ENTRY)&_ZN11S3046C14_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S3046C14_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S3046C14_nt4v102Ev,
  (VTBL_ENTRY)&_ZN11S3046C14_nt4v103Ev,
  (VTBL_ENTRY)&_ZN11S3046C14_nt4v104Ev,
  (VTBL_ENTRY)&_ZN11S3046C14_nt4v105Ev,
  (VTBL_ENTRY)&_ZN11S3046C14_nt4v106Ev,
};
extern VTBL_ENTRY _ZTI11S3046C14_nt[];
VTBL_ENTRY *P__ZTI11S3046C14_nt = _ZTI11S3046C14_nt; 
extern  VTBL_ENTRY _ZTV11S3046C14_nt[];
Class_Descriptor cd_S3046C14_nt = {  "S3046C14_nt", // class name
  0,0,//no base classes
  &(vtc_S3046C14_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,48), // object size
  NSPAIRA(_ZTI11S3046C14_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S3046C14_nt),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3046C13_nt  : S3046C14_nt {
  virtual void  v100(); // _ZN11S3046C13_nt4v100Ev
  virtual void  v101(); // _ZN11S3046C13_nt4v101Ev
  ~S3046C13_nt(); // tgen
  S3046C13_nt(); // tgen
};
//SIG(-1 S3046C13_nt) C1{ BC2{ vd v3 v4 v5 v6 v7 Fi[8] Fp Fi Fp} v1 v2}


void  S3046C13_nt ::v100(){vfunc_called(this, "_ZN11S3046C13_nt4v100Ev");}
void  S3046C13_nt ::v101(){vfunc_called(this, "_ZN11S3046C13_nt4v101Ev");}
S3046C13_nt ::~S3046C13_nt(){ note_dtor("S3046C13_nt", this);} // tgen
S3046C13_nt ::S3046C13_nt(){ note_ctor("S3046C13_nt", this);} // tgen

//skip512 S3046C13_nt

#else // __cplusplus

extern void _ZN11S3046C13_ntC1Ev();
extern void _ZN11S3046C13_ntD1Ev();
Name_Map name_map_S3046C13_nt[] = {
  NSPAIR(_ZN11S3046C13_ntC1Ev),
  NSPAIR(_ZN11S3046C13_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3046C14_nt;
extern VTBL_ENTRY _ZTI11S3046C14_nt[];
extern  VTBL_ENTRY _ZTV11S3046C14_nt[];
static Base_Class bases_S3046C13_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3046C14_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI11S3046C13_nt[];
extern void _ZN11S3046C13_ntD1Ev();
extern void _ZN11S3046C13_ntD0Ev();
extern void _ZN11S3046C14_nt4v102Ev();
extern void _ZN11S3046C14_nt4v103Ev();
extern void _ZN11S3046C14_nt4v104Ev();
extern void _ZN11S3046C14_nt4v105Ev();
extern void _ZN11S3046C14_nt4v106Ev();
extern void _ZN11S3046C13_nt4v100Ev();
extern void _ZN11S3046C13_nt4v101Ev();
static  VTBL_ENTRY vtc_S3046C13_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S3046C13_nt[0]),
  (VTBL_ENTRY)&_ZN11S3046C13_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S3046C13_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S3046C14_nt4v102Ev,
  (VTBL_ENTRY)&_ZN11S3046C14_nt4v103Ev,
  (VTBL_ENTRY)&_ZN11S3046C14_nt4v104Ev,
  (VTBL_ENTRY)&_ZN11S3046C14_nt4v105Ev,
  (VTBL_ENTRY)&_ZN11S3046C14_nt4v106Ev,
  (VTBL_ENTRY)&_ZN11S3046C13_nt4v100Ev,
  (VTBL_ENTRY)&_ZN11S3046C13_nt4v101Ev,
};
extern VTBL_ENTRY _ZTI11S3046C13_nt[];
VTBL_ENTRY *P__ZTI11S3046C13_nt = _ZTI11S3046C13_nt; 
extern  VTBL_ENTRY _ZTV11S3046C13_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3046C1  : S3046C2 {
  int s3046c1f0;
  unsigned int s3046c1f1:1;
  unsigned int s3046c1f2:1;
  unsigned int s3046c1f3:1;
  unsigned int s3046c1f4:1;
  unsigned int s3046c1f5:1;
  unsigned int s3046c1f6:1;
  unsigned int s3046c1f7:1;
  char s3046c1f8;
  ::S74C9_nt s3046c1f9;
  int s3046c1f10[6];
  ::S1409C26 s3046c1f11;
  ::S1409C26 s3046c1f12;
  ::S3046C13_nt s3046c1f13;
  void *s3046c1f14;
  char s3046c1f15;
  ::S1409C22 s3046c1f16;
  void *s3046c1f17;
  ::S3046C13_nt s3046c1f18;
  ::S3046C13_nt s3046c1f19;
  ::S3046C13_nt s3046c1f20;
  int s3046c1f21[2];
  void *s3046c1f22;
  ::S1409C18 s3046c1f23;
  ::S74C9_nt s3046c1f24;
  virtual  ~S3046C1(); // _ZN7S3046C1D1Ev
  virtual void  v1(); // _ZN7S3046C12v1Ev
  virtual void  v2(); // _ZN7S3046C12v2Ev
  virtual void  v3(); // _ZN7S3046C12v3Ev
  virtual void  v4(); // _ZN7S3046C12v4Ev
  virtual void  v5(); // _ZN7S3046C12v5Ev
  virtual void  v6(); // _ZN7S3046C12v6Ev
  virtual void  v7(); // _ZN7S3046C12v7Ev
  virtual void  v8(); // _ZN7S3046C12v8Ev
  virtual void  v9(); // _ZN7S3046C12v9Ev
  virtual void  v10(); // _ZN7S3046C13v10Ev
  virtual void  v11(); // _ZN7S3046C13v11Ev
  virtual void  v12(); // _ZN7S3046C13v12Ev
  virtual void  v13(); // _ZN7S3046C13v13Ev
  virtual void  v14(); // _ZN7S3046C13v14Ev
  virtual void  v15(); // _ZN7S3046C13v15Ev
  virtual void  v16(); // _ZN7S3046C13v16Ev
  virtual void  v17(); // _ZN7S3046C13v17Ev
  S3046C1(); // tgen
};
//SIG(1 S3046C1) C1{ BC2{ BC3{ vd v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 Fi FC5{ BC6{ BC7{ m Fp Fi[2]}}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc FC8{ BC9{ BC10{ BC7}}} Fi[6] FC11{ BC12{ BC7}} FC11 FC13{ BC14{ vd v102 v103 v104 v105 v106 Fi[8] Fp Fi Fp} v100 v101} Fp Fc FC15{ BC16{ BC7}} Fp FC13 FC13 FC13 Fi[2] Fp FC17{ BC18{ BC7}} FC8}


 S3046C1 ::~S3046C1(){ note_dtor("S3046C1", this);}
void  S3046C1 ::v1(){vfunc_called(this, "_ZN7S3046C12v1Ev");}
void  S3046C1 ::v2(){vfunc_called(this, "_ZN7S3046C12v2Ev");}
void  S3046C1 ::v3(){vfunc_called(this, "_ZN7S3046C12v3Ev");}
void  S3046C1 ::v4(){vfunc_called(this, "_ZN7S3046C12v4Ev");}
void  S3046C1 ::v5(){vfunc_called(this, "_ZN7S3046C12v5Ev");}
void  S3046C1 ::v6(){vfunc_called(this, "_ZN7S3046C12v6Ev");}
void  S3046C1 ::v7(){vfunc_called(this, "_ZN7S3046C12v7Ev");}
void  S3046C1 ::v8(){vfunc_called(this, "_ZN7S3046C12v8Ev");}
void  S3046C1 ::v9(){vfunc_called(this, "_ZN7S3046C12v9Ev");}
void  S3046C1 ::v10(){vfunc_called(this, "_ZN7S3046C13v10Ev");}
void  S3046C1 ::v11(){vfunc_called(this, "_ZN7S3046C13v11Ev");}
void  S3046C1 ::v12(){vfunc_called(this, "_ZN7S3046C13v12Ev");}
void  S3046C1 ::v13(){vfunc_called(this, "_ZN7S3046C13v13Ev");}
void  S3046C1 ::v14(){vfunc_called(this, "_ZN7S3046C13v14Ev");}
void  S3046C1 ::v15(){vfunc_called(this, "_ZN7S3046C13v15Ev");}
void  S3046C1 ::v16(){vfunc_called(this, "_ZN7S3046C13v16Ev");}
void  S3046C1 ::v17(){vfunc_called(this, "_ZN7S3046C13v17Ev");}
S3046C1 ::S3046C1(){ note_ctor("S3046C1", this);} // tgen

static void Test_S3046C1()
{
  extern Class_Descriptor cd_S3046C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(69,100)];
    init_test(&cd_S3046C1, buf);
    S3046C1 *dp, &lv = *(dp=new (buf) S3046C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(544,396), "sizeof(S3046C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3046C1)");
    check_base_class_offset(lv, (S3046C3*)(S3046C2*), 0, "S3046C1");
    check_base_class_offset(lv, (S3046C2*), 0, "S3046C1");
    check_field_offset(lv, s3046c1f0, ABISELECT(120,76), "S3046C1.s3046c1f0");
    set_bf_and_test(lv, s3046c1f1, ABISELECT(124,80), 0, 1, 1, "S3046C1");
    set_bf_and_test(lv, s3046c1f2, ABISELECT(124,80), 1, 1, 1, "S3046C1");
    set_bf_and_test(lv, s3046c1f3, ABISELECT(124,80), 2, 1, 1, "S3046C1");
    set_bf_and_test(lv, s3046c1f4, ABISELECT(124,80), 3, 1, 1, "S3046C1");
    set_bf_and_test(lv, s3046c1f5, ABISELECT(124,80), 4, 1, 1, "S3046C1");
    set_bf_and_test(lv, s3046c1f6, ABISELECT(124,80), 5, 1, 1, "S3046C1");
    set_bf_and_test(lv, s3046c1f7, ABISELECT(124,80), 6, 1, 1, "S3046C1");
    check_field_offset(lv, s3046c1f8, ABISELECT(125,81), "S3046C1.s3046c1f8");
    check_field_offset(lv, s3046c1f9, ABISELECT(128,84), "S3046C1.s3046c1f9");
    check_field_offset(lv, s3046c1f10, ABISELECT(144,96), "S3046C1.s3046c1f10");
    check_field_offset(lv, s3046c1f11, ABISELECT(168,120), "S3046C1.s3046c1f11");
    check_field_offset(lv, s3046c1f12, ABISELECT(184,132), "S3046C1.s3046c1f12");
    check_field_offset(lv, s3046c1f13, ABISELECT(200,144), "S3046C1.s3046c1f13");
    check_field_offset(lv, s3046c1f14, ABISELECT(264,192), "S3046C1.s3046c1f14");
    check_field_offset(lv, s3046c1f15, ABISELECT(272,196), "S3046C1.s3046c1f15");
    check_field_offset(lv, s3046c1f16, ABISELECT(280,200), "S3046C1.s3046c1f16");
    check_field_offset(lv, s3046c1f17, ABISELECT(296,212), "S3046C1.s3046c1f17");
    check_field_offset(lv, s3046c1f18, ABISELECT(304,216), "S3046C1.s3046c1f18");
    check_field_offset(lv, s3046c1f19, ABISELECT(368,264), "S3046C1.s3046c1f19");
    check_field_offset(lv, s3046c1f20, ABISELECT(432,312), "S3046C1.s3046c1f20");
    check_field_offset(lv, s3046c1f21, ABISELECT(496,360), "S3046C1.s3046c1f21");
    check_field_offset(lv, s3046c1f22, ABISELECT(504,368), "S3046C1.s3046c1f22");
    check_field_offset(lv, s3046c1f23, ABISELECT(512,372), "S3046C1.s3046c1f23");
    check_field_offset(lv, s3046c1f24, ABISELECT(528,384), "S3046C1.s3046c1f24");
    test_class_info(&lv, &cd_S3046C1);
    dp->~S3046C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3046C1(Test_S3046C1, "S3046C1", ABISELECT(544,396));

#else // __cplusplus

extern void _ZN7S3046C1C1Ev();
extern void _ZN7S3046C1D1Ev();
Name_Map name_map_S3046C1[] = {
  NSPAIR(_ZN7S3046C1C1Ev),
  NSPAIR(_ZN7S3046C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3046C3;
extern VTBL_ENTRY _ZTI7S3046C3[];
extern  VTBL_ENTRY _ZTV7S3046C3[];
extern Class_Descriptor cd_S3046C2;
extern VTBL_ENTRY _ZTI7S3046C2[];
extern  VTBL_ENTRY _ZTV7S3046C2[];
static Base_Class bases_S3046C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3046C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3046C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3046C1[];
extern void _ZN7S3046C1D1Ev();
extern void _ZN7S3046C1D0Ev();
extern void _ZN7S3046C33v18Ev();
extern void _ZN7S3046C33v19Ev();
extern void _ZN7S3046C33v20Ev();
extern void _ZN7S3046C33v21Ev();
extern void _ZN7S3046C33v22Ev();
extern void _ZN7S3046C33v23Ev();
extern void _ZN7S3046C33v24Ev();
extern void _ZN7S3046C33v25Ev();
extern void _ZN7S3046C33v26Ev();
extern void _ZN7S3046C33v27Ev();
extern void _ZN7S3046C33v28Ev();
extern void _ZN7S3046C33v29Ev();
extern void _ZN7S3046C33v30Ev();
extern void _ZN7S3046C33v31Ev();
extern void _ZN7S3046C33v32Ev();
extern void _ZN7S3046C33v33Ev();
extern void _ZN7S3046C33v34Ev();
extern void _ZN7S3046C33v35Ev();
extern void _ZN7S3046C33v36Ev();
extern void _ZN7S3046C33v37Ev();
extern void _ZN7S3046C33v38Ev();
extern void _ZN7S3046C33v39Ev();
extern void _ZN7S3046C33v40Ev();
extern void _ZN7S3046C33v41Ev();
extern void _ZN7S3046C33v42Ev();
extern void _ZN7S3046C33v43Ev();
extern void _ZN7S3046C33v44Ev();
extern void _ZN7S3046C33v45Ev();
extern void _ZN7S3046C33v46Ev();
extern void _ZN7S3046C33v47Ev();
extern void _ZN7S3046C33v48Ev();
extern void _ZN7S3046C33v49Ev();
extern void _ZN7S3046C33v50Ev();
extern void _ZN7S3046C33v51Ev();
extern void _ZN7S3046C33v52Ev();
extern void _ZN7S3046C33v53Ev();
extern void _ZN7S3046C33v54Ev();
extern void _ZN7S3046C33v55Ev();
extern void _ZN7S3046C33v56Ev();
extern void _ZN7S3046C33v57Ev();
extern void _ZN7S3046C33v58Ev();
extern void _ZN7S3046C33v59Ev();
extern void _ZN7S3046C33v60Ev();
extern void _ZN7S3046C33v61Ev();
extern void _ZN7S3046C33v62Ev();
extern void _ZN7S3046C33v63Ev();
extern void _ZN7S3046C33v64Ev();
extern void _ZN7S3046C33v65Ev();
extern void _ZN7S3046C33v66Ev();
extern void _ZN7S3046C33v67Ev();
extern void _ZN7S3046C33v68Ev();
extern void _ZN7S3046C33v69Ev();
extern void _ZN7S3046C33v70Ev();
extern void _ZN7S3046C33v71Ev();
extern void _ZN7S3046C33v72Ev();
extern void _ZN7S3046C33v73Ev();
extern void _ZN7S3046C33v74Ev();
extern void _ZN7S3046C33v75Ev();
extern void _ZN7S3046C33v76Ev();
extern void _ZN7S3046C33v77Ev();
extern void _ZN7S3046C33v78Ev();
extern void _ZN7S3046C33v79Ev();
extern void _ZN7S3046C33v80Ev();
extern void _ZN7S3046C33v81Ev();
extern void _ZN7S3046C23v82Ev();
extern void _ZN7S3046C23v83Ev();
extern void _ZN7S3046C23v84Ev();
extern void _ZN7S3046C23v85Ev();
extern void _ZN7S3046C23v86Ev();
extern void _ZN7S3046C23v87Ev();
extern void _ZN7S3046C23v88Ev();
extern void _ZN7S3046C23v89Ev();
extern void _ZN7S3046C23v90Ev();
extern void _ZN7S3046C23v91Ev();
extern void _ZN7S3046C23v92Ev();
extern void _ZN7S3046C23v93Ev();
extern void _ZN7S3046C23v94Ev();
extern void _ZN7S3046C23v95Ev();
extern void _ZN7S3046C23v96Ev();
extern void _ZN7S3046C23v97Ev();
extern void _ZN7S3046C23v98Ev();
extern void _ZN7S3046C23v99Ev();
extern void _ZN7S3046C12v1Ev();
extern void _ZN7S3046C12v2Ev();
extern void _ZN7S3046C12v3Ev();
extern void _ZN7S3046C12v4Ev();
extern void _ZN7S3046C12v5Ev();
extern void _ZN7S3046C12v6Ev();
extern void _ZN7S3046C12v7Ev();
extern void _ZN7S3046C12v8Ev();
extern void _ZN7S3046C12v9Ev();
extern void _ZN7S3046C13v10Ev();
extern void _ZN7S3046C13v11Ev();
extern void _ZN7S3046C13v12Ev();
extern void _ZN7S3046C13v13Ev();
extern void _ZN7S3046C13v14Ev();
extern void _ZN7S3046C13v15Ev();
extern void _ZN7S3046C13v16Ev();
extern void _ZN7S3046C13v17Ev();
static  VTBL_ENTRY vtc_S3046C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3046C1[0]),
  (VTBL_ENTRY)&_ZN7S3046C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3046C1D0Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v18Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v19Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v20Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v21Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v22Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v23Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v24Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v25Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v26Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v27Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v28Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v29Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v30Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v31Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v32Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v33Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v34Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v35Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v36Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v37Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v38Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v39Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v40Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v41Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v42Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v43Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v44Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v45Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v46Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v47Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v48Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v49Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v50Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v51Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v52Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v53Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v54Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v55Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v56Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v57Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v58Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v59Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v60Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v61Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v62Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v63Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v64Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v65Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v66Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v67Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v68Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v69Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v70Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v71Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v72Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v73Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v74Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v75Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v76Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v77Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v78Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v79Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v80Ev,
  (VTBL_ENTRY)&_ZN7S3046C33v81Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v82Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v83Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v84Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v85Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v86Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v87Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v88Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v89Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v90Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v91Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v92Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v93Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v94Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v95Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v96Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v97Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v98Ev,
  (VTBL_ENTRY)&_ZN7S3046C23v99Ev,
  (VTBL_ENTRY)&_ZN7S3046C12v1Ev,
  (VTBL_ENTRY)&_ZN7S3046C12v2Ev,
  (VTBL_ENTRY)&_ZN7S3046C12v3Ev,
  (VTBL_ENTRY)&_ZN7S3046C12v4Ev,
  (VTBL_ENTRY)&_ZN7S3046C12v5Ev,
  (VTBL_ENTRY)&_ZN7S3046C12v6Ev,
  (VTBL_ENTRY)&_ZN7S3046C12v7Ev,
  (VTBL_ENTRY)&_ZN7S3046C12v8Ev,
  (VTBL_ENTRY)&_ZN7S3046C12v9Ev,
  (VTBL_ENTRY)&_ZN7S3046C13v10Ev,
  (VTBL_ENTRY)&_ZN7S3046C13v11Ev,
  (VTBL_ENTRY)&_ZN7S3046C13v12Ev,
  (VTBL_ENTRY)&_ZN7S3046C13v13Ev,
  (VTBL_ENTRY)&_ZN7S3046C13v14Ev,
  (VTBL_ENTRY)&_ZN7S3046C13v15Ev,
  (VTBL_ENTRY)&_ZN7S3046C13v16Ev,
  (VTBL_ENTRY)&_ZN7S3046C13v17Ev,
};
extern VTBL_ENTRY _ZTI7S3046C1[];
extern  VTBL_ENTRY _ZTV7S3046C1[];
Class_Descriptor cd_S3046C1 = {  "S3046C1", // class name
  bases_S3046C1, 2,
  &(vtc_S3046C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(544,396), // object size
  NSPAIRA(_ZTI7S3046C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3046C1),103, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20570C5  {
  char s20570c5f0;
  void *s20570c5f1;
  int s20570c5f2;
  __tsi64 s20570c5f3;
  int s20570c5f4[7];
  short s20570c5f5:3;
  __tsi64 s20570c5f6;
  long double s20570c5f7[9];
  void  mf20570c5(); // _ZN8S20570C59mf20570c5Ev
};
//SIG(-1 S20570C5) C1{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]}


void  S20570C5 ::mf20570c5(){}

static void Test_S20570C5()
{
  {
    init_simple_test("S20570C5");
    static S20570C5 lv;
    check2(sizeof(lv), ABISELECT(224,168), "sizeof(S20570C5)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20570C5)");
    check_field_offset(lv, s20570c5f0, 0, "S20570C5.s20570c5f0");
    check_field_offset(lv, s20570c5f1, ABISELECT(8,4), "S20570C5.s20570c5f1");
    check_field_offset(lv, s20570c5f2, ABISELECT(16,8), "S20570C5.s20570c5f2");
    check_field_offset(lv, s20570c5f3, ABISELECT(24,12), "S20570C5.s20570c5f3");
    check_field_offset(lv, s20570c5f4, ABISELECT(32,20), "S20570C5.s20570c5f4");
    set_bf_and_test(lv, s20570c5f5, ABISELECT(60,48), 0, 3, 1, "S20570C5");
    set_bf_and_test(lv, s20570c5f5, ABISELECT(60,48), 0, 3, hide_sll(1LL<<2), "S20570C5");
    check_field_offset(lv, s20570c5f6, ABISELECT(64,52), "S20570C5.s20570c5f6");
    check_field_offset(lv, s20570c5f7, ABISELECT(80,60), "S20570C5.s20570c5f7");
  }
}
static Arrange_To_Call_Me vS20570C5(Test_S20570C5, "S20570C5", ABISELECT(224,168));

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S20570C5[];
VTBL_ENTRY *P__ZTI8S20570C5 = _ZTI8S20570C5; 
Class_Descriptor cd_S20570C5 = {  "S20570C5", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(224,168), // object size
  NSPAIRA(_ZTI8S20570C5),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20570C4  : virtual S20570C5 {
  long s20570c4f0[3];
  __tsi64 s20570c4f1;
  short s20570c4f2;
  int s20570c4f3;
  __tsi64 s20570c4f4;
  int s20570c4f5;
  virtual  ~S20570C4(); // _ZN8S20570C4D2Ev
  virtual void  v4(); // _ZN8S20570C42v4Ev
  S20570C4(); // tgen
};
//SIG(-1 S20570C4) C1{ VBC2{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} vd v1 Fl[3] FL Fs Fi FL Fi}


 S20570C4 ::~S20570C4(){ note_dtor("S20570C4", this);}
void  S20570C4 ::v4(){vfunc_called(this, "_ZN8S20570C42v4Ev");}
S20570C4 ::S20570C4(){ note_ctor("S20570C4", this);} // tgen

static void Test_S20570C4()
{
  extern Class_Descriptor cd_S20570C4;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(19,54)];
    init_test(&cd_S20570C4, buf);
    S20570C4 *dp, &lv = *(dp=new (buf) S20570C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(288,212), "sizeof(S20570C4)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20570C4)");
    check_base_class_offset(lv, (S20570C5*), ABISELECT(64,44), "S20570C4");
    check_field_offset(lv, s20570c4f0, ABISELECT(8,4), "S20570C4.s20570c4f0");
    check_field_offset(lv, s20570c4f1, ABISELECT(32,16), "S20570C4.s20570c4f1");
    check_field_offset(lv, s20570c4f2, ABISELECT(40,24), "S20570C4.s20570c4f2");
    check_field_offset(lv, s20570c4f3, ABISELECT(44,28), "S20570C4.s20570c4f3");
    check_field_offset(lv, s20570c4f4, ABISELECT(48,32), "S20570C4.s20570c4f4");
    check_field_offset(lv, s20570c4f5, ABISELECT(56,40), "S20570C4.s20570c4f5");
    test_class_info(&lv, &cd_S20570C4);
    dp->~S20570C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20570C4(Test_S20570C4, "S20570C4", ABISELECT(288,212));

#else // __cplusplus

extern void _ZN8S20570C4C1Ev();
extern void _ZN8S20570C4D2Ev();
Name_Map name_map_S20570C4[] = {
  NSPAIR(_ZN8S20570C4C1Ev),
  NSPAIR(_ZN8S20570C4D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
static Base_Class bases_S20570C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20570C4[];
extern void _ZN8S20570C4D1Ev();
extern void _ZN8S20570C4D0Ev();
extern void _ZN8S20570C42v4Ev();
static  VTBL_ENTRY vtc_S20570C4[] = {
  ABISELECT(64,44),
  0,
  (VTBL_ENTRY)&(_ZTI8S20570C4[0]),
  (VTBL_ENTRY)&_ZN8S20570C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20570C4D0Ev,
  (VTBL_ENTRY)&_ZN8S20570C42v4Ev,
};
extern VTBL_ENTRY _ZTV8S20570C4[];
static  VTT_ENTRY vtt_S20570C4[] = {
  {&(_ZTV8S20570C4[3]),  3,6},
};
extern VTBL_ENTRY _ZTI8S20570C4[];
extern  VTBL_ENTRY _ZTV8S20570C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20570C4[];
Class_Descriptor cd_S20570C4 = {  "S20570C4", // class name
  bases_S20570C4, 1,
  &(vtc_S20570C4[0]), // expected_vtbl_contents
  &(vtt_S20570C4[0]), // expected_vtt_contents
  ABISELECT(288,212), // object size
  NSPAIRA(_ZTI8S20570C4),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S20570C4),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20570C4),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20570C3  : S20570C4 {
  int s20570c3f0;
  void *s20570c3f1;
  int s20570c3f2;
  long double s20570c3f3[9];
  long s20570c3f4;
  int s20570c3f5;
  __tsi64 s20570c3f6;
  void *s20570c3f7[5];
  __tsi64 s20570c3f8;
  virtual void  v5(); // _ZN8S20570C32v5Ev
  virtual void  v6(); // _ZN8S20570C32v6Ev
  ~S20570C3(); // tgen
  S20570C3(); // tgen
};
//SIG(-1 S20570C3) C1{ BC2{ VBC3{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} vd v3 Fl[3] FL Fs Fi FL Fi} v1 v2 Fi Fp Fi FD[9] Fl Fi FL Fp[5] FL}


void  S20570C3 ::v5(){vfunc_called(this, "_ZN8S20570C32v5Ev");}
void  S20570C3 ::v6(){vfunc_called(this, "_ZN8S20570C32v6Ev");}
S20570C3 ::~S20570C3(){ note_dtor("S20570C3", this);} // tgen
S20570C3 ::S20570C3(){ note_ctor("S20570C3", this);} // tgen

static void Test_S20570C3()
{
  extern Class_Descriptor cd_S20570C3;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(34,95)];
    init_test(&cd_S20570C3, buf);
    S20570C3 *dp, &lv = *(dp=new (buf) S20570C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(528,376), "sizeof(S20570C3)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20570C3)");
    check_base_class_offset(lv, (S20570C5*)(S20570C4*), ABISELECT(304,208), "S20570C3");
    check_base_class_offset(lv, (S20570C4*), 0, "S20570C3");
    check_field_offset(lv, s20570c3f0, ABISELECT(60,44), "S20570C3.s20570c3f0");
    check_field_offset(lv, s20570c3f1, ABISELECT(64,48), "S20570C3.s20570c3f1");
    check_field_offset(lv, s20570c3f2, ABISELECT(72,52), "S20570C3.s20570c3f2");
    check_field_offset(lv, s20570c3f3, ABISELECT(80,56), "S20570C3.s20570c3f3");
    check_field_offset(lv, s20570c3f4, ABISELECT(224,164), "S20570C3.s20570c3f4");
    check_field_offset(lv, s20570c3f5, ABISELECT(232,168), "S20570C3.s20570c3f5");
    check_field_offset(lv, s20570c3f6, ABISELECT(240,172), "S20570C3.s20570c3f6");
    check_field_offset(lv, s20570c3f7, ABISELECT(248,180), "S20570C3.s20570c3f7");
    check_field_offset(lv, s20570c3f8, ABISELECT(288,200), "S20570C3.s20570c3f8");
    test_class_info(&lv, &cd_S20570C3);
    dp->~S20570C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20570C3(Test_S20570C3, "S20570C3", ABISELECT(528,376));

#else // __cplusplus

extern void _ZN8S20570C3C1Ev();
extern void _ZN8S20570C3D1Ev();
Name_Map name_map_S20570C3[] = {
  NSPAIR(_ZN8S20570C3C1Ev),
  NSPAIR(_ZN8S20570C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C4;
extern VTBL_ENTRY _ZTI8S20570C4[];
extern  VTBL_ENTRY _ZTV8S20570C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20570C4[];
static Base_Class bases_S20570C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(304,208), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20570C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20570C3[];
extern void _ZN8S20570C3D1Ev();
extern void _ZN8S20570C3D0Ev();
extern void _ZN8S20570C42v4Ev();
extern void _ZN8S20570C32v5Ev();
extern void _ZN8S20570C32v6Ev();
static  VTBL_ENTRY vtc_S20570C3[] = {
  ABISELECT(304,208),
  0,
  (VTBL_ENTRY)&(_ZTI8S20570C3[0]),
  (VTBL_ENTRY)&_ZN8S20570C3D1Ev,
  (VTBL_ENTRY)&_ZN8S20570C3D0Ev,
  (VTBL_ENTRY)&_ZN8S20570C42v4Ev,
  (VTBL_ENTRY)&_ZN8S20570C32v5Ev,
  (VTBL_ENTRY)&_ZN8S20570C32v6Ev,
};
extern VTBL_ENTRY _ZTV8S20570C3[];
extern void _ZN8S20570C4D1Ev();
extern void _ZN8S20570C4D0Ev();
extern void _ZN8S20570C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20570C4__8S20570C3[] = {
  ABISELECT(304,208),
  0,
  (VTBL_ENTRY)&(_ZTI8S20570C4[0]),
  (VTBL_ENTRY)&_ZN8S20570C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20570C4D0Ev,
  (VTBL_ENTRY)&_ZN8S20570C42v4Ev,
};
static  VTT_ENTRY vtt_S20570C3[] = {
  {&(_ZTV8S20570C3[3]),  3,8},
  {&(_tg__ZTV8S20570C4__8S20570C3[3]),  3,6},
};
extern VTBL_ENTRY _ZTI8S20570C3[];
extern  VTBL_ENTRY _ZTV8S20570C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20570C3[];
Class_Descriptor cd_S20570C3 = {  "S20570C3", // class name
  bases_S20570C3, 2,
  &(vtc_S20570C3[0]), // expected_vtbl_contents
  &(vtt_S20570C3[0]), // expected_vtt_contents
  ABISELECT(528,376), // object size
  NSPAIRA(_ZTI8S20570C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S20570C3),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20570C3),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20570C2  : virtual S20570C3 {
  int s20570c2f0:26;
  char s20570c2f1[2];
  virtual  ~S20570C2(); // _ZN8S20570C2D2Ev
  virtual void  v7(); // _ZN8S20570C22v7Ev
  S20570C2(); // tgen
};
//SIG(-1 S20570C2) C1{ VBC2{ BC3{ VBC4{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} vd v2 Fl[3] FL Fs Fi FL Fi} v3 v4 Fi Fp Fi FD[9] Fl Fi FL Fp[5] FL} vd v1 Fi:26 Fc[2]}


 S20570C2 ::~S20570C2(){ note_dtor("S20570C2", this);}
void  S20570C2 ::v7(){vfunc_called(this, "_ZN8S20570C22v7Ev");}
S20570C2 ::S20570C2(){ note_ctor("S20570C2", this);} // tgen

static void Test_S20570C2()
{
  extern Class_Descriptor cd_S20570C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(35,98)];
    init_test(&cd_S20570C2, buf);
    S20570C2 *dp, &lv = *(dp=new (buf) S20570C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(544,388), "sizeof(S20570C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20570C2)");
    check_base_class_offset(lv, (S20570C5*)(S20570C4*)(S20570C3*), ABISELECT(320,220), "S20570C2");
    check_base_class_offset(lv, (S20570C4*)(S20570C3*), ABISELECT(16,12), "S20570C2");
    check_base_class_offset(lv, (S20570C3*), ABISELECT(16,12), "S20570C2");
    set_bf_and_test(lv, s20570c2f0, ABISELECT(8,4), 0, 26, 1, "S20570C2");
    set_bf_and_test(lv, s20570c2f0, ABISELECT(8,4), 0, 26, hide_sll(1LL<<25), "S20570C2");
    check_field_offset(lv, s20570c2f1, ABISELECT(12,8), "S20570C2.s20570c2f1");
    test_class_info(&lv, &cd_S20570C2);
    dp->~S20570C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20570C2(Test_S20570C2, "S20570C2", ABISELECT(544,388));

#else // __cplusplus

extern void _ZN8S20570C2C1Ev();
extern void _ZN8S20570C2D2Ev();
Name_Map name_map_S20570C2[] = {
  NSPAIR(_ZN8S20570C2C1Ev),
  NSPAIR(_ZN8S20570C2D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C4;
extern VTBL_ENTRY _ZTI8S20570C4[];
extern  VTBL_ENTRY _ZTV8S20570C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20570C4[];
extern Class_Descriptor cd_S20570C3;
extern VTBL_ENTRY _ZTI8S20570C3[];
extern  VTBL_ENTRY _ZTV8S20570C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20570C3[];
static Base_Class bases_S20570C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(320,220), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20570C4,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20570C3,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20570C2[];
extern void _ZN8S20570C2D1Ev();
extern void _ZN8S20570C2D0Ev();
extern void _ZN8S20570C22v7Ev();
extern void ABISELECT(_ZTv0_n32_N8S20570C2D1Ev,_ZTv0_n16_N8S20570C2D1Ev)();
extern void ABISELECT(_ZThn16_N8S20570C2D1Ev,_ZThn12_N8S20570C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20570C2D0Ev,_ZTv0_n16_N8S20570C2D0Ev)();
extern void ABISELECT(_ZThn16_N8S20570C2D0Ev,_ZThn12_N8S20570C2D0Ev)() __attribute__((weak));
extern void _ZN8S20570C42v4Ev();
extern void _ZN8S20570C32v5Ev();
extern void _ZN8S20570C32v6Ev();
static  VTBL_ENTRY vtc_S20570C2[] = {
  ABISELECT(320,220),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI8S20570C2[0]),
  (VTBL_ENTRY)&_ZN8S20570C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20570C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20570C22v7Ev,
  0,
  0,
  0,
  ABISELECT(-16,-12),
  ABISELECT(304,208),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8S20570C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20570C2D1Ev,_ZTv0_n16_N8S20570C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20570C2D0Ev,_ZTv0_n16_N8S20570C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20570C42v4Ev,
  (VTBL_ENTRY)&_ZN8S20570C32v5Ev,
  (VTBL_ENTRY)&_ZN8S20570C32v6Ev,
};
extern VTBL_ENTRY _ZTV8S20570C2[];
extern void _ZN8S20570C3D1Ev();
extern void _ZN8S20570C3D0Ev();
extern void _ZN8S20570C42v4Ev();
extern void _ZN8S20570C32v5Ev();
extern void _ZN8S20570C32v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20570C3__8S20570C2[] = {
  ABISELECT(304,208),
  0,
  (VTBL_ENTRY)&(_ZTI8S20570C3[0]),
  (VTBL_ENTRY)&_ZN8S20570C3D1Ev,
  (VTBL_ENTRY)&_ZN8S20570C3D0Ev,
  (VTBL_ENTRY)&_ZN8S20570C42v4Ev,
  (VTBL_ENTRY)&_ZN8S20570C32v5Ev,
  (VTBL_ENTRY)&_ZN8S20570C32v6Ev,
};
extern void _ZN8S20570C4D1Ev();
extern void _ZN8S20570C4D0Ev();
extern void _ZN8S20570C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20570C48S20570C3__8S20570C2[] = {
  ABISELECT(304,208),
  0,
  (VTBL_ENTRY)&(_ZTI8S20570C4[0]),
  (VTBL_ENTRY)&_ZN8S20570C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20570C4D0Ev,
  (VTBL_ENTRY)&_ZN8S20570C42v4Ev,
};
static  VTT_ENTRY vtt_S20570C2[] = {
  {&(_ZTV8S20570C2[4]),  4,19},
  {&(_ZTV8S20570C2[14]),  14,19},
  {&(_tg__ZTV8S20570C3__8S20570C2[3]),  3,8},
  {&(_tg__ZTV8S20570C48S20570C3__8S20570C2[3]),  3,6},
};
extern VTBL_ENTRY _ZTI8S20570C2[];
extern  VTBL_ENTRY _ZTV8S20570C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20570C2[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S20570C2D0Ev,_ZTv0_n16_N8S20570C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S20570C2D0Ev,_ZThn12_N8S20570C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S20570C2D1Ev,_ZTv0_n16_N8S20570C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S20570C2D1Ev,_ZThn12_N8S20570C2D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20570C2 = {  "S20570C2", // class name
  bases_S20570C2, 3,
  &(vtc_S20570C2[0]), // expected_vtbl_contents
  &(vtt_S20570C2[0]), // expected_vtt_contents
  ABISELECT(544,388), // object size
  NSPAIRA(_ZTI8S20570C2),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S20570C2),19, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20570C2),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20570C7  : S20570C5 {
  long double s20570c7f0;
  short s20570c7f1:16;
  int s20570c7f2[7];
  long double s20570c7f3;
  char s20570c7f4:6;
  __tsi64 s20570c7f5:64;
  __tsi64 s20570c7f6[2];
  int s20570c7f7;
  virtual void  v9(); // _ZN8S20570C72v9Ev
  virtual void  v10(); // _ZN8S20570C73v10Ev
  virtual void  v11(); // _ZN8S20570C73v11Ev
  ~S20570C7(); // tgen
  S20570C7(); // tgen
};
//SIG(-1 S20570C7) C1{ BC2{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} v1 v2 v3 FD Fs:16 Fi[7] FD Fc:6 FL:64 FL[2] Fi}


void  S20570C7 ::v9(){vfunc_called(this, "_ZN8S20570C72v9Ev");}
void  S20570C7 ::v10(){vfunc_called(this, "_ZN8S20570C73v10Ev");}
void  S20570C7 ::v11(){vfunc_called(this, "_ZN8S20570C73v11Ev");}
S20570C7 ::~S20570C7(){ note_dtor("S20570C7", this);} // tgen
S20570C7 ::S20570C7(){ note_ctor("S20570C7", this);} // tgen

static void Test_S20570C7()
{
  extern Class_Descriptor cd_S20570C7;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(23,66)];
    init_test(&cd_S20570C7, buf);
    S20570C7 *dp, &lv = *(dp=new (buf) S20570C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(352,260), "sizeof(S20570C7)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20570C7)");
    check_base_class_offset(lv, (S20570C5*), ABISELECT(16,4), "S20570C7");
    check_field_offset(lv, s20570c7f0, ABISELECT(240,172), "S20570C7.s20570c7f0");
    set_bf_and_test(lv, s20570c7f1, ABISELECT(256,184), 0, 16, 1, "S20570C7");
    set_bf_and_test(lv, s20570c7f1, ABISELECT(256,184), 0, 16, hide_sll(1LL<<15), "S20570C7");
    check_field_offset(lv, s20570c7f2, ABISELECT(260,188), "S20570C7.s20570c7f2");
    check_field_offset(lv, s20570c7f3, ABISELECT(288,216), "S20570C7.s20570c7f3");
    set_bf_and_test(lv, s20570c7f4, ABISELECT(304,228), 0, 6, 1, "S20570C7");
    set_bf_and_test(lv, s20570c7f4, ABISELECT(304,228), 0, 6, hide_sll(1LL<<5), "S20570C7");
    set_bf_and_test(lv, s20570c7f5, ABISELECT(312,232), 0, 64, 1, "S20570C7");
    set_bf_and_test(lv, s20570c7f5, ABISELECT(312,232), 0, 64, hide_sll(1LL<<63), "S20570C7");
    check_field_offset(lv, s20570c7f6, ABISELECT(320,240), "S20570C7.s20570c7f6");
    check_field_offset(lv, s20570c7f7, ABISELECT(336,256), "S20570C7.s20570c7f7");
    test_class_info(&lv, &cd_S20570C7);
    dp->~S20570C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20570C7(Test_S20570C7, "S20570C7", ABISELECT(352,260));

#else // __cplusplus

extern void _ZN8S20570C7C1Ev();
extern void _ZN8S20570C7D1Ev();
Name_Map name_map_S20570C7[] = {
  NSPAIR(_ZN8S20570C7C1Ev),
  NSPAIR(_ZN8S20570C7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
static Base_Class bases_S20570C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20570C7[];
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
static  VTBL_ENTRY vtc_S20570C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S20570C7[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
};
extern VTBL_ENTRY _ZTI8S20570C7[];
extern  VTBL_ENTRY _ZTV8S20570C7[];
Class_Descriptor cd_S20570C7 = {  "S20570C7", // class name
  bases_S20570C7, 1,
  &(vtc_S20570C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(352,260), // object size
  NSPAIRA(_ZTI8S20570C7),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S20570C7),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20570C6  : virtual S20570C5 {
  void *s20570c6f0;
  int s20570c6f1;
  ::S20570C7 s20570c6f2;
  int s20570c6f3;
  void *s20570c6f4;
  ~S20570C6(); // tgen
  S20570C6(); // tgen
};
//SIG(-1 S20570C6) C1{ VBC2{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} Fp Fi FC3{ BC2 v1 v2 v3 FD Fs:16 Fi[7] FD Fc:6 FL:64 FL[2] Fi} Fi Fp}


S20570C6 ::~S20570C6(){ note_dtor("S20570C6", this);} // tgen
S20570C6 ::S20570C6(){ note_ctor("S20570C6", this);} // tgen

static void Test_S20570C6()
{
  extern Class_Descriptor cd_S20570C6;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(40,113)];
    init_test(&cd_S20570C6, buf);
    S20570C6 *dp, &lv = *(dp=new (buf) S20570C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(624,448), "sizeof(S20570C6)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20570C6)");
    check_base_class_offset(lv, (S20570C5*), ABISELECT(400,280), "S20570C6");
    check_field_offset(lv, s20570c6f0, ABISELECT(8,4), "S20570C6.s20570c6f0");
    check_field_offset(lv, s20570c6f1, ABISELECT(16,8), "S20570C6.s20570c6f1");
    check_field_offset(lv, s20570c6f2, ABISELECT(32,12), "S20570C6.s20570c6f2");
    check_field_offset(lv, s20570c6f3, ABISELECT(384,272), "S20570C6.s20570c6f3");
    check_field_offset(lv, s20570c6f4, ABISELECT(392,276), "S20570C6.s20570c6f4");
    test_class_info(&lv, &cd_S20570C6);
    dp->~S20570C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20570C6(Test_S20570C6, "S20570C6", ABISELECT(624,448));

#else // __cplusplus

extern void _ZN8S20570C6C1Ev();
extern void _ZN8S20570C6D1Ev();
Name_Map name_map_S20570C6[] = {
  NSPAIR(_ZN8S20570C6C1Ev),
  NSPAIR(_ZN8S20570C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
static Base_Class bases_S20570C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(400,280), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20570C6[];
static  VTBL_ENTRY vtc_S20570C6[] = {
  ABISELECT(400,280),
  0,
  (VTBL_ENTRY)&(_ZTI8S20570C6[0]),
};
extern VTBL_ENTRY _ZTV8S20570C6[];
static  VTT_ENTRY vtt_S20570C6[] = {
  {&(_ZTV8S20570C6[3]),  3,3},
};
extern VTBL_ENTRY _ZTI8S20570C6[];
extern  VTBL_ENTRY _ZTV8S20570C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20570C6[];
Class_Descriptor cd_S20570C6 = {  "S20570C6", // class name
  bases_S20570C6, 1,
  &(vtc_S20570C6[0]), // expected_vtbl_contents
  &(vtt_S20570C6[0]), // expected_vtt_contents
  ABISELECT(624,448), // object size
  NSPAIRA(_ZTI8S20570C6),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S20570C6),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20570C6),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20570C10  : virtual S20570C5 {
  ::S20570C5 s20570c10f0[5];
  __tsi64 s20570c10f1;
  short s20570c10f2:5;
  char  :0;
  void *s20570c10f4[2];
  int s20570c10f5;
  __tsi64 s20570c10f6;
  virtual  ~S20570C10(); // _ZN9S20570C10D2Ev
  virtual void  v8(); // _ZN9S20570C102v8Ev
  S20570C10(); // tgen
};
//SIG(-1 S20570C10) C1{ VBC2{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} vd v1 FC2[5] FL Fs:5 Fc:0 Fp[2] Fi FL}


 S20570C10 ::~S20570C10(){ note_dtor("S20570C10", this);}
void  S20570C10 ::v8(){vfunc_called(this, "_ZN9S20570C102v8Ev");}
S20570C10 ::S20570C10(){ note_ctor("S20570C10", this);} // tgen

static void Test_S20570C10()
{
  extern Class_Descriptor cd_S20570C10;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(89,262)];
    init_test(&cd_S20570C10, buf);
    S20570C10 *dp, &lv = *(dp=new (buf) S20570C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1408,1044), "sizeof(S20570C10)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20570C10)");
    check_base_class_offset(lv, (S20570C5*), ABISELECT(1184,876), "S20570C10");
    check_field_offset(lv, s20570c10f0, ABISELECT(16,4), "S20570C10.s20570c10f0");
    check_field_offset(lv, s20570c10f1, ABISELECT(1136,844), "S20570C10.s20570c10f1");
    set_bf_and_test(lv, s20570c10f2, ABISELECT(1144,852), 0, 5, 1, "S20570C10");
    set_bf_and_test(lv, s20570c10f2, ABISELECT(1144,852), 0, 5, hide_sll(1LL<<4), "S20570C10");
    check_field_offset(lv, s20570c10f4, ABISELECT(1152,856), "S20570C10.s20570c10f4");
    check_field_offset(lv, s20570c10f5, ABISELECT(1168,864), "S20570C10.s20570c10f5");
    check_field_offset(lv, s20570c10f6, ABISELECT(1176,868), "S20570C10.s20570c10f6");
    test_class_info(&lv, &cd_S20570C10);
    dp->~S20570C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20570C10(Test_S20570C10, "S20570C10", ABISELECT(1408,1044));

#else // __cplusplus

extern void _ZN9S20570C10C1Ev();
extern void _ZN9S20570C10D2Ev();
Name_Map name_map_S20570C10[] = {
  NSPAIR(_ZN9S20570C10C1Ev),
  NSPAIR(_ZN9S20570C10D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
static Base_Class bases_S20570C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(1184,876), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20570C10[];
extern void _ZN9S20570C10D1Ev();
extern void _ZN9S20570C10D0Ev();
extern void _ZN9S20570C102v8Ev();
static  VTBL_ENTRY vtc_S20570C10[] = {
  ABISELECT(1184,876),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C10[0]),
  (VTBL_ENTRY)&_ZN9S20570C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20570C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
};
extern VTBL_ENTRY _ZTV9S20570C10[];
static  VTT_ENTRY vtt_S20570C10[] = {
  {&(_ZTV9S20570C10[3]),  3,6},
};
extern VTBL_ENTRY _ZTI9S20570C10[];
extern  VTBL_ENTRY _ZTV9S20570C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C10[];
Class_Descriptor cd_S20570C10 = {  "S20570C10", // class name
  bases_S20570C10, 1,
  &(vtc_S20570C10[0]), // expected_vtbl_contents
  &(vtt_S20570C10[0]), // expected_vtt_contents
  ABISELECT(1408,1044), // object size
  NSPAIRA(_ZTI9S20570C10),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV9S20570C10),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20570C10),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20570C9  : S20570C10 , S20570C5 , S20570C7 {
  long double s20570c9f0;
  void *s20570c9f1;
  short s20570c9f2[6];
  void *s20570c9f3;
  int s20570c9f4;
  long double s20570c9f5;
  int s20570c9f6;
  virtual void  v12(); // _ZN8S20570C93v12Ev
  ~S20570C9(); // tgen
  S20570C9(); // tgen
};
//SIG(-1 S20570C9) C1{ BC2{ VBC3{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} vd v2 FC3[5] FL Fs:5 Fc:0 Fp[2] Fi FL} BC3 BC4{ BC3 v3 v4 v5 FD Fs:16 Fi[7] FD Fc:6 FL:64 FL[2] Fi} v1 FD Fp Fs[6] Fp Fi FD Fi}


void  S20570C9 ::v12(){vfunc_called(this, "_ZN8S20570C93v12Ev");}
S20570C9 ::~S20570C9(){ note_dtor("S20570C9", this);} // tgen
S20570C9 ::S20570C9(){ note_ctor("S20570C9", this);} // tgen

static void Test_S20570C9()
{
  extern Class_Descriptor cd_S20570C9;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(131,382)];
    init_test(&cd_S20570C9, buf);
    S20570C9 *dp, &lv = *(dp=new (buf) S20570C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2080,1524), "sizeof(S20570C9)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20570C9)");
    check_base_class_offset(lv, (S20570C5*)(S20570C10*), ABISELECT(1856,1356), "S20570C9");
    check_base_class_offset(lv, (S20570C10*), 0, "S20570C9");
    /*is_ambiguous_... S20570C9::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*), ABISELECT(1184,876), "S20570C9");
    check_base_class_offset(lv, (S20570C5*)(S20570C7*), ABISELECT(1424,1048), "S20570C9");
    check_base_class_offset(lv, (S20570C7*), ABISELECT(1408,1044), "S20570C9");
    check_field_offset(lv, s20570c9f0, ABISELECT(1760,1304), "S20570C9.s20570c9f0");
    check_field_offset(lv, s20570c9f1, ABISELECT(1776,1316), "S20570C9.s20570c9f1");
    check_field_offset(lv, s20570c9f2, ABISELECT(1784,1320), "S20570C9.s20570c9f2");
    check_field_offset(lv, s20570c9f3, ABISELECT(1800,1332), "S20570C9.s20570c9f3");
    check_field_offset(lv, s20570c9f4, ABISELECT(1808,1336), "S20570C9.s20570c9f4");
    check_field_offset(lv, s20570c9f5, ABISELECT(1824,1340), "S20570C9.s20570c9f5");
    check_field_offset(lv, s20570c9f6, ABISELECT(1840,1352), "S20570C9.s20570c9f6");
    test_class_info(&lv, &cd_S20570C9);
    dp->~S20570C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20570C9(Test_S20570C9, "S20570C9", ABISELECT(2080,1524));

#else // __cplusplus

extern void _ZN8S20570C9C1Ev();
extern void _ZN8S20570C9D1Ev();
Name_Map name_map_S20570C9[] = {
  NSPAIR(_ZN8S20570C9C1Ev),
  NSPAIR(_ZN8S20570C9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C10;
extern VTBL_ENTRY _ZTI9S20570C10[];
extern  VTBL_ENTRY _ZTV9S20570C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C10[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C7;
extern VTBL_ENTRY _ZTI8S20570C7[];
extern  VTBL_ENTRY _ZTV8S20570C7[];
static Base_Class bases_S20570C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(1856,1356), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20570C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20570C5,    ABISELECT(1184,876), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20570C5,    ABISELECT(1424,1048), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20570C7,    ABISELECT(1408,1044), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20570C9[];
extern void _ZN8S20570C9D1Ev();
extern void _ZN8S20570C9D0Ev();
extern void _ZN9S20570C102v8Ev();
extern void _ZN8S20570C93v12Ev();
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
static  VTBL_ENTRY vtc_S20570C9[] = {
  ABISELECT(1856,1356),
  0,
  (VTBL_ENTRY)&(_ZTI8S20570C9[0]),
  (VTBL_ENTRY)&_ZN8S20570C9D1Ev,
  (VTBL_ENTRY)&_ZN8S20570C9D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20570C93v12Ev,
  ABISELECT(-1408,-1044),
  (VTBL_ENTRY)&(_ZTI8S20570C9[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
};
extern VTBL_ENTRY _ZTV8S20570C9[];
extern void _ZN9S20570C10D1Ev();
extern void _ZN9S20570C10D0Ev();
extern void _ZN9S20570C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C10__8S20570C9[] = {
  ABISELECT(1856,1356),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C10[0]),
  (VTBL_ENTRY)&_ZN9S20570C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20570C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
};
static  VTT_ENTRY vtt_S20570C9[] = {
  {&(_ZTV8S20570C9[3]),  3,12},
  {&(_tg__ZTV9S20570C10__8S20570C9[3]),  3,6},
};
extern VTBL_ENTRY _ZTI8S20570C9[];
extern  VTBL_ENTRY _ZTV8S20570C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20570C9[];
Class_Descriptor cd_S20570C9 = {  "S20570C9", // class name
  bases_S20570C9, 5,
  &(vtc_S20570C9[0]), // expected_vtbl_contents
  &(vtt_S20570C9[0]), // expected_vtt_contents
  ABISELECT(2080,1524), // object size
  NSPAIRA(_ZTI8S20570C9),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S20570C9),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20570C9),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20570C8  : virtual S20570C5 , S20570C9 , S20570C10 {
  long double s20570c8f0[9];
  short s20570c8f1;
  virtual  ~S20570C8(); // _ZN8S20570C8D2Ev
  S20570C8(); // tgen
};
//SIG(-1 S20570C8) C1{ VBC2{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} BC3{ BC4{ VBC2 vd v1 FC2[5] FL Fs:5 Fc:0 Fp[2] Fi FL} BC2 BC5{ BC2 v2 v3 v4 FD Fs:16 Fi[7] FD Fc:6 FL:64 FL[2] Fi} v5 FD Fp Fs[6] Fp Fi FD Fi} BC4 vd FD[9] Fs}


 S20570C8 ::~S20570C8(){ note_dtor("S20570C8", this);}
S20570C8 ::S20570C8(){ note_ctor("S20570C8", this);} // tgen

static void Test_S20570C8()
{
  extern Class_Descriptor cd_S20570C8;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(215,629)];
    init_test(&cd_S20570C8, buf);
    S20570C8 *dp, &lv = *(dp=new (buf) S20570C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(3424,2512), "sizeof(S20570C8)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20570C8)");
    /*is_ambiguous_... S20570C8::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*), ABISELECT(3200,2344), "S20570C8");
    check_base_class_offset(lv, (S20570C5*)(S20570C10*)(S20570C9*), ABISELECT(3200,2344), "S20570C8");
    /*is_ambiguous_... S20570C8::S20570C10 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20570C10*), ABISELECT(3200,2344), "S20570C8");
    check_base_class_offset(lv, (S20570C10*)(S20570C9*), 0, "S20570C8");
    /*is_ambiguous_... S20570C9::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20570C9*), ABISELECT(1184,876), "S20570C8");
    check_base_class_offset(lv, (S20570C5*)(S20570C7*)(S20570C9*), ABISELECT(1424,1048), "S20570C8");
    check_base_class_offset(lv, (S20570C7*)(S20570C9*), ABISELECT(1408,1044), "S20570C8");
    check_base_class_offset(lv, (S20570C9*), 0, "S20570C8");
    /*is_ambiguous_... S20570C8::S20570C10 */ AMB_check_base_class_offset(lv, (S20570C10*), ABISELECT(1856,1356), "S20570C8");
    check_field_offset(lv, s20570c8f0, ABISELECT(3040,2232), "S20570C8.s20570c8f0");
    check_field_offset(lv, s20570c8f1, ABISELECT(3184,2340), "S20570C8.s20570c8f1");
    test_class_info(&lv, &cd_S20570C8);
    dp->~S20570C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20570C8(Test_S20570C8, "S20570C8", ABISELECT(3424,2512));

#else // __cplusplus

extern void _ZN8S20570C8C1Ev();
extern void _ZN8S20570C8D2Ev();
Name_Map name_map_S20570C8[] = {
  NSPAIR(_ZN8S20570C8C1Ev),
  NSPAIR(_ZN8S20570C8D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C10;
extern VTBL_ENTRY _ZTI9S20570C10[];
extern  VTBL_ENTRY _ZTV9S20570C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C10[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C7;
extern VTBL_ENTRY _ZTI8S20570C7[];
extern  VTBL_ENTRY _ZTV8S20570C7[];
extern Class_Descriptor cd_S20570C9;
extern VTBL_ENTRY _ZTI8S20570C9[];
extern  VTBL_ENTRY _ZTV8S20570C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20570C9[];
extern Class_Descriptor cd_S20570C10;
extern VTBL_ENTRY _ZTI9S20570C10[];
extern  VTBL_ENTRY _ZTV9S20570C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C10[];
static Base_Class bases_S20570C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(3200,2344), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20570C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(1184,876), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(1424,1048), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20570C7,    ABISELECT(1408,1044), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20570C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20570C10,    ABISELECT(1856,1356), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20570C8[];
extern void _ZN8S20570C8D1Ev();
extern void _ZN8S20570C8D0Ev();
extern void _ZN9S20570C102v8Ev();
extern void _ZN8S20570C93v12Ev();
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
extern void ABISELECT(_ZThn1856_N8S20570C8D1Ev,_ZThn1356_N8S20570C8D1Ev)();
extern void ABISELECT(_ZThn1856_N8S20570C8D0Ev,_ZThn1356_N8S20570C8D0Ev)();
extern void _ZN9S20570C102v8Ev();
static  VTBL_ENTRY vtc_S20570C8[] = {
  ABISELECT(3200,2344),
  0,
  (VTBL_ENTRY)&(_ZTI8S20570C8[0]),
  (VTBL_ENTRY)&_ZN8S20570C8D1Ev,
  (VTBL_ENTRY)&_ZN8S20570C8D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20570C93v12Ev,
  ABISELECT(-1408,-1044),
  (VTBL_ENTRY)&(_ZTI8S20570C8[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
  ABISELECT(1344,988),
  ABISELECT(-1856,-1356),
  (VTBL_ENTRY)&(_ZTI8S20570C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1856_N8S20570C8D1Ev,_ZThn1356_N8S20570C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1856_N8S20570C8D0Ev,_ZThn1356_N8S20570C8D0Ev),
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
};
extern VTBL_ENTRY _ZTV8S20570C8[];
extern void _ZN8S20570C9D1Ev();
extern void _ZN8S20570C9D0Ev();
extern void _ZN9S20570C102v8Ev();
extern void _ZN8S20570C93v12Ev();
static  VTBL_ENTRY _tg__ZTV8S20570C9__8S20570C8[] = {
  ABISELECT(3200,2344),
  0,
  (VTBL_ENTRY)&(_ZTI8S20570C9[0]),
  (VTBL_ENTRY)&_ZN8S20570C9D1Ev,
  (VTBL_ENTRY)&_ZN8S20570C9D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20570C93v12Ev,
};
extern void _ZN9S20570C10D1Ev();
extern void _ZN9S20570C10D0Ev();
extern void _ZN9S20570C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C108S20570C9__8S20570C8[] = {
  ABISELECT(3200,2344),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C10[0]),
  (VTBL_ENTRY)&_ZN9S20570C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20570C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
};
extern void _ZN9S20570C10D1Ev();
extern void _ZN9S20570C10D0Ev();
extern void _ZN9S20570C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C10__A1__8S20570C8[] = {
  ABISELECT(1344,988),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C10[0]),
  (VTBL_ENTRY)&_ZN9S20570C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20570C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
};
static  VTT_ENTRY vtt_S20570C8[] = {
  {&(_ZTV8S20570C8[3]),  3,18},
  {&(_tg__ZTV8S20570C9__8S20570C8[3]),  3,7},
  {&(_tg__ZTV9S20570C108S20570C9__8S20570C8[3]),  3,6},
  {&(_tg__ZTV9S20570C10__A1__8S20570C8[3]),  3,6},
  {&(_ZTV8S20570C8[15]),  15,18},
};
extern VTBL_ENTRY _ZTI8S20570C8[];
extern  VTBL_ENTRY _ZTV8S20570C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20570C8[];
Class_Descriptor cd_S20570C8 = {  "S20570C8", // class name
  bases_S20570C8, 7,
  &(vtc_S20570C8[0]), // expected_vtbl_contents
  &(vtt_S20570C8[0]), // expected_vtt_contents
  ABISELECT(3424,2512), // object size
  NSPAIRA(_ZTI8S20570C8),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S20570C8),18, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20570C8),5, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20570C12  : S20570C7 , virtual S20570C5 {
  ::S5217C45 s20570c12f0;
  __tsi64 s20570c12f1;
  int s20570c12f2:23;
  short s20570c12f3;
  int s20570c12f4;
  long s20570c12f5[2];
  ~S20570C12(); // tgen
  S20570C12(); // tgen
};
//SIG(-1 S20570C12) C1{ BC2{ BC3{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} v1 v2 v3 FD Fs:16 Fi[7] FD Fc:6 FL:64 FL[2] Fi} VBC3 FC4{} FL Fi:23 Fs Fi Fl[2]}


S20570C12 ::~S20570C12(){ note_dtor("S20570C12", this);} // tgen
S20570C12 ::S20570C12(){ note_ctor("S20570C12", this);} // tgen

static void Test_S20570C12()
{
  extern Class_Descriptor cd_S20570C12;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(39,116)];
    init_test(&cd_S20570C12, buf);
    S20570C12 *dp, &lv = *(dp=new (buf) S20570C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(608,460), "sizeof(S20570C12)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20570C12)");
    check_base_class_offset(lv, (S20570C5*)(S20570C7*), ABISELECT(16,4), "S20570C12");
    check_base_class_offset(lv, (S20570C7*), 0, "S20570C12");
    /*is_ambiguous_... S20570C12::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*), ABISELECT(384,292), "S20570C12");
    check_field_offset(lv, s20570c12f0, ABISELECT(340,260), "S20570C12.s20570c12f0");
    check_field_offset(lv, s20570c12f1, ABISELECT(344,264), "S20570C12.s20570c12f1");
    set_bf_and_test(lv, s20570c12f2, ABISELECT(352,272), 0, 23, 1, "S20570C12");
    set_bf_and_test(lv, s20570c12f2, ABISELECT(352,272), 0, 23, hide_sll(1LL<<22), "S20570C12");
    check_field_offset(lv, s20570c12f3, ABISELECT(356,276), "S20570C12.s20570c12f3");
    check_field_offset(lv, s20570c12f4, ABISELECT(360,280), "S20570C12.s20570c12f4");
    check_field_offset(lv, s20570c12f5, ABISELECT(368,284), "S20570C12.s20570c12f5");
    test_class_info(&lv, &cd_S20570C12);
    dp->~S20570C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20570C12(Test_S20570C12, "S20570C12", ABISELECT(608,460));

#else // __cplusplus

extern void _ZN9S20570C12C1Ev();
extern void _ZN9S20570C12D1Ev();
Name_Map name_map_S20570C12[] = {
  NSPAIR(_ZN9S20570C12C1Ev),
  NSPAIR(_ZN9S20570C12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C7;
extern VTBL_ENTRY _ZTI8S20570C7[];
extern  VTBL_ENTRY _ZTV8S20570C7[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
static Base_Class bases_S20570C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20570C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20570C5,    ABISELECT(384,292), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20570C12[];
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
static  VTBL_ENTRY vtc_S20570C12[] = {
  ABISELECT(384,292),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C12[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
};
extern VTBL_ENTRY _ZTV9S20570C12[];
static  VTT_ENTRY vtt_S20570C12[] = {
  {&(_ZTV9S20570C12[3]),  3,6},
};
extern VTBL_ENTRY _ZTI9S20570C12[];
extern  VTBL_ENTRY _ZTV9S20570C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C12[];
Class_Descriptor cd_S20570C12 = {  "S20570C12", // class name
  bases_S20570C12, 3,
  &(vtc_S20570C12[0]), // expected_vtbl_contents
  &(vtt_S20570C12[0]), // expected_vtt_contents
  ABISELECT(608,460), // object size
  NSPAIRA(_ZTI9S20570C12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S20570C12),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20570C12),1, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20570C14  : S20570C10 , S20570C12 , S20570C4 {
  int  :0;
  ~S20570C14(); // tgen
  S20570C14(); // tgen
};
//SIG(-1 S20570C14) C1{ BC2{ VBC3{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} vd v1 FC3[5] FL Fs:5 Fc:0 Fp[2] Fi FL} BC4{ BC5{ BC3 v2 v3 v4 FD Fs:16 Fi[7] FD Fc:6 FL:64 FL[2] Fi} VBC3 FC6{} FL Fi:23 Fs Fi Fl[2]} BC7{ VBC3 vd v5 Fl[3] FL Fs Fi FL Fi} Fi:0}


S20570C14 ::~S20570C14(){ note_dtor("S20570C14", this);} // tgen
S20570C14 ::S20570C14(){ note_ctor("S20570C14", this);} // tgen

static void Test_S20570C14()
{
  extern Class_Descriptor cd_S20570C14;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(117,346)];
    init_test(&cd_S20570C14, buf);
    S20570C14 *dp, &lv = *(dp=new (buf) S20570C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1856,1380), "sizeof(S20570C14)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20570C14)");
    check_base_class_offset(lv, (S20570C5*)(S20570C10*), ABISELECT(1632,1212), "S20570C14");
    /*is_ambiguous_... S20570C12::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20570C12*), ABISELECT(1632,1212), "S20570C14");
    check_base_class_offset(lv, (S20570C5*)(S20570C4*), ABISELECT(1632,1212), "S20570C14");
    check_base_class_offset(lv, (S20570C10*), 0, "S20570C14");
    check_base_class_offset(lv, (S20570C5*)(S20570C7*)(S20570C12*), ABISELECT(1200,880), "S20570C14");
    check_base_class_offset(lv, (S20570C7*)(S20570C12*), ABISELECT(1184,876), "S20570C14");
    check_base_class_offset(lv, (S20570C12*), ABISELECT(1184,876), "S20570C14");
    check_base_class_offset(lv, (S20570C4*), ABISELECT(1568,1168), "S20570C14");
    test_class_info(&lv, &cd_S20570C14);
    dp->~S20570C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20570C14(Test_S20570C14, "S20570C14", ABISELECT(1856,1380));

#else // __cplusplus

extern void _ZN9S20570C14C1Ev();
extern void _ZN9S20570C14D1Ev();
Name_Map name_map_S20570C14[] = {
  NSPAIR(_ZN9S20570C14C1Ev),
  NSPAIR(_ZN9S20570C14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C10;
extern VTBL_ENTRY _ZTI9S20570C10[];
extern  VTBL_ENTRY _ZTV9S20570C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C10[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C7;
extern VTBL_ENTRY _ZTI8S20570C7[];
extern  VTBL_ENTRY _ZTV8S20570C7[];
extern Class_Descriptor cd_S20570C12;
extern VTBL_ENTRY _ZTI9S20570C12[];
extern  VTBL_ENTRY _ZTV9S20570C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C12[];
extern Class_Descriptor cd_S20570C4;
extern VTBL_ENTRY _ZTI8S20570C4[];
extern  VTBL_ENTRY _ZTV8S20570C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20570C4[];
static Base_Class bases_S20570C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(1632,1212), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20570C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20570C5,    ABISELECT(1200,880), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20570C7,    ABISELECT(1184,876), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20570C12,    ABISELECT(1184,876), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20570C4,    ABISELECT(1568,1168), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20570C14[];
extern void _ZN9S20570C14D1Ev();
extern void _ZN9S20570C14D0Ev();
extern void _ZN9S20570C102v8Ev();
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
extern void ABISELECT(_ZThn1568_N9S20570C14D1Ev,_ZThn1168_N9S20570C14D1Ev)();
extern void ABISELECT(_ZThn1568_N9S20570C14D0Ev,_ZThn1168_N9S20570C14D0Ev)();
extern void _ZN8S20570C42v4Ev();
static  VTBL_ENTRY vtc_S20570C14[] = {
  ABISELECT(1632,1212),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C14[0]),
  (VTBL_ENTRY)&_ZN9S20570C14D1Ev,
  (VTBL_ENTRY)&_ZN9S20570C14D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
  ABISELECT(448,336),
  ABISELECT(-1184,-876),
  (VTBL_ENTRY)&(_ZTI9S20570C14[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
  ABISELECT(64,44),
  ABISELECT(-1568,-1168),
  (VTBL_ENTRY)&(_ZTI9S20570C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1568_N9S20570C14D1Ev,_ZThn1168_N9S20570C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1568_N9S20570C14D0Ev,_ZThn1168_N9S20570C14D0Ev),
  (VTBL_ENTRY)&_ZN8S20570C42v4Ev,
};
extern VTBL_ENTRY _ZTV9S20570C14[];
extern void _ZN9S20570C10D1Ev();
extern void _ZN9S20570C10D0Ev();
extern void _ZN9S20570C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C10__9S20570C14[] = {
  ABISELECT(1632,1212),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C10[0]),
  (VTBL_ENTRY)&_ZN9S20570C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20570C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
};
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C12__9S20570C14[] = {
  ABISELECT(448,336),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C12[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
};
extern void _ZN8S20570C4D1Ev();
extern void _ZN8S20570C4D0Ev();
extern void _ZN8S20570C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20570C4__9S20570C14[] = {
  ABISELECT(64,44),
  0,
  (VTBL_ENTRY)&(_ZTI8S20570C4[0]),
  (VTBL_ENTRY)&_ZN8S20570C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20570C4D0Ev,
  (VTBL_ENTRY)&_ZN8S20570C42v4Ev,
};
static  VTT_ENTRY vtt_S20570C14[] = {
  {&(_ZTV9S20570C14[3]),  3,18},
  {&(_tg__ZTV9S20570C10__9S20570C14[3]),  3,6},
  {&(_tg__ZTV9S20570C12__9S20570C14[3]),  3,6},
  {&(_tg__ZTV8S20570C4__9S20570C14[3]),  3,6},
  {&(_ZTV9S20570C14[9]),  9,18},
  {&(_ZTV9S20570C14[15]),  15,18},
};
extern VTBL_ENTRY _ZTI9S20570C14[];
extern  VTBL_ENTRY _ZTV9S20570C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C14[];
Class_Descriptor cd_S20570C14 = {  "S20570C14", // class name
  bases_S20570C14, 6,
  &(vtc_S20570C14[0]), // expected_vtbl_contents
  &(vtt_S20570C14[0]), // expected_vtt_contents
  ABISELECT(1856,1380), // object size
  NSPAIRA(_ZTI9S20570C14),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S20570C14),18, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20570C14),6, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20570C11  : S20570C10 , S20570C12 {
  void *s20570c11f0[13];
  int s20570c11f1[2];
  long s20570c11f2;
  void *s20570c11f3[2];
  short s20570c11f4;
  ::S20570C14 s20570c11f5;
  int s20570c11f6;
  ~S20570C11(); // tgen
  S20570C11(); // tgen
};
//SIG(-1 S20570C11) C1{ BC2{ VBC3{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} vd v1 FC3[5] FL Fs:5 Fc:0 Fp[2] Fi FL} BC4{ BC5{ BC3 v2 v3 v4 FD Fs:16 Fi[7] FD Fc:6 FL:64 FL[2] Fi} VBC3 FC6{} FL Fi:23 Fs Fi Fl[2]} Fp[13] Fi[2] Fl Fp[2] Fs FC7{ BC2 BC4 BC8{ VBC3 vd v5 Fl[3] FL Fs Fi FL Fi} Fi:0} Fi}


S20570C11 ::~S20570C11(){ note_dtor("S20570C11", this);} // tgen
S20570C11 ::S20570C11(){ note_ctor("S20570C11", this);} // tgen

static void Test_S20570C11()
{
  extern Class_Descriptor cd_S20570C11;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(239,700)];
    init_test(&cd_S20570C11, buf);
    S20570C11 *dp, &lv = *(dp=new (buf) S20570C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(3808,2796), "sizeof(S20570C11)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20570C11)");
    check_base_class_offset(lv, (S20570C5*)(S20570C10*), ABISELECT(3584,2628), "S20570C11");
    /*is_ambiguous_... S20570C12::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20570C12*), ABISELECT(3584,2628), "S20570C11");
    check_base_class_offset(lv, (S20570C10*), 0, "S20570C11");
    check_base_class_offset(lv, (S20570C5*)(S20570C7*)(S20570C12*), ABISELECT(1200,880), "S20570C11");
    check_base_class_offset(lv, (S20570C7*)(S20570C12*), ABISELECT(1184,876), "S20570C11");
    check_base_class_offset(lv, (S20570C12*), ABISELECT(1184,876), "S20570C11");
    check_field_offset(lv, s20570c11f0, ABISELECT(1568,1168), "S20570C11.s20570c11f0");
    check_field_offset(lv, s20570c11f1, ABISELECT(1672,1220), "S20570C11.s20570c11f1");
    check_field_offset(lv, s20570c11f2, ABISELECT(1680,1228), "S20570C11.s20570c11f2");
    check_field_offset(lv, s20570c11f3, ABISELECT(1688,1232), "S20570C11.s20570c11f3");
    check_field_offset(lv, s20570c11f4, ABISELECT(1704,1240), "S20570C11.s20570c11f4");
    check_field_offset(lv, s20570c11f5, ABISELECT(1712,1244), "S20570C11.s20570c11f5");
    check_field_offset(lv, s20570c11f6, ABISELECT(3568,2624), "S20570C11.s20570c11f6");
    test_class_info(&lv, &cd_S20570C11);
    dp->~S20570C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20570C11(Test_S20570C11, "S20570C11", ABISELECT(3808,2796));

#else // __cplusplus

extern void _ZN9S20570C11C1Ev();
extern void _ZN9S20570C11D1Ev();
Name_Map name_map_S20570C11[] = {
  NSPAIR(_ZN9S20570C11C1Ev),
  NSPAIR(_ZN9S20570C11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C10;
extern VTBL_ENTRY _ZTI9S20570C10[];
extern  VTBL_ENTRY _ZTV9S20570C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C10[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C7;
extern VTBL_ENTRY _ZTI8S20570C7[];
extern  VTBL_ENTRY _ZTV8S20570C7[];
extern Class_Descriptor cd_S20570C12;
extern VTBL_ENTRY _ZTI9S20570C12[];
extern  VTBL_ENTRY _ZTV9S20570C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C12[];
static Base_Class bases_S20570C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(3584,2628), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20570C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20570C5,    ABISELECT(1200,880), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20570C7,    ABISELECT(1184,876), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20570C12,    ABISELECT(1184,876), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20570C11[];
extern void _ZN9S20570C11D1Ev();
extern void _ZN9S20570C11D0Ev();
extern void _ZN9S20570C102v8Ev();
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
static  VTBL_ENTRY vtc_S20570C11[] = {
  ABISELECT(3584,2628),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C11[0]),
  (VTBL_ENTRY)&_ZN9S20570C11D1Ev,
  (VTBL_ENTRY)&_ZN9S20570C11D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
  ABISELECT(2400,1752),
  ABISELECT(-1184,-876),
  (VTBL_ENTRY)&(_ZTI9S20570C11[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
};
extern VTBL_ENTRY _ZTV9S20570C11[];
extern void _ZN9S20570C10D1Ev();
extern void _ZN9S20570C10D0Ev();
extern void _ZN9S20570C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C10__9S20570C11[] = {
  ABISELECT(3584,2628),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C10[0]),
  (VTBL_ENTRY)&_ZN9S20570C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20570C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
};
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C12__9S20570C11[] = {
  ABISELECT(2400,1752),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C12[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
};
static  VTT_ENTRY vtt_S20570C11[] = {
  {&(_ZTV9S20570C11[3]),  3,12},
  {&(_tg__ZTV9S20570C10__9S20570C11[3]),  3,6},
  {&(_tg__ZTV9S20570C12__9S20570C11[3]),  3,6},
  {&(_ZTV9S20570C11[9]),  9,12},
};
extern VTBL_ENTRY _ZTI9S20570C11[];
extern  VTBL_ENTRY _ZTV9S20570C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C11[];
Class_Descriptor cd_S20570C11 = {  "S20570C11", // class name
  bases_S20570C11, 5,
  &(vtc_S20570C11[0]), // expected_vtbl_contents
  &(vtt_S20570C11[0]), // expected_vtt_contents
  ABISELECT(3808,2796), // object size
  NSPAIRA(_ZTI9S20570C11),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S20570C11),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20570C11),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20570C17  {
  void *s20570c17f0;
  long s20570c17f1;
  int s20570c17f2;
  void *s20570c17f3;
  void  mf20570c17(); // _ZN9S20570C1710mf20570c17Ev
  virtual  ~S20570C17(); // _ZN9S20570C17D1Ev
  S20570C17(); // tgen
};
//SIG(-1 S20570C17) C1{ vd m Fp Fl Fi Fp}


void  S20570C17 ::mf20570c17(){}
 S20570C17 ::~S20570C17(){ note_dtor("S20570C17", this);}
S20570C17 ::S20570C17(){ note_ctor("S20570C17", this);} // tgen

static void Test_S20570C17()
{
  extern Class_Descriptor cd_S20570C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[6];
    init_test(&cd_S20570C17, buf);
    S20570C17 *dp, &lv = *(dp=new (buf) S20570C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,20), "sizeof(S20570C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20570C17)");
    check_field_offset(lv, s20570c17f0, ABISELECT(8,4), "S20570C17.s20570c17f0");
    check_field_offset(lv, s20570c17f1, ABISELECT(16,8), "S20570C17.s20570c17f1");
    check_field_offset(lv, s20570c17f2, ABISELECT(24,12), "S20570C17.s20570c17f2");
    check_field_offset(lv, s20570c17f3, ABISELECT(32,16), "S20570C17.s20570c17f3");
    test_class_info(&lv, &cd_S20570C17);
    dp->~S20570C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20570C17(Test_S20570C17, "S20570C17", ABISELECT(40,20));

#else // __cplusplus

extern void _ZN9S20570C17C1Ev();
extern void _ZN9S20570C17D1Ev();
Name_Map name_map_S20570C17[] = {
  NSPAIR(_ZN9S20570C17C1Ev),
  NSPAIR(_ZN9S20570C17D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S20570C17[];
extern void _ZN9S20570C17D1Ev();
extern void _ZN9S20570C17D0Ev();
static  VTBL_ENTRY vtc_S20570C17[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C17[0]),
  (VTBL_ENTRY)&_ZN9S20570C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20570C17D0Ev,
};
extern VTBL_ENTRY _ZTI9S20570C17[];
extern  VTBL_ENTRY _ZTV9S20570C17[];
Class_Descriptor cd_S20570C17 = {  "S20570C17", // class name
  0,0,//no base classes
  &(vtc_S20570C17[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,20), // object size
  NSPAIRA(_ZTI9S20570C17),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S20570C17),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20570C16  : virtual S20570C7 , virtual S20570C12 , S20570C9 , virtual S20570C6 {
  char s20570c16f0:5;
  long s20570c16f1[4];
  char s20570c16f2[6];
  ::S20570C17 s20570c16f3;
  virtual  ~S20570C16(); // _ZN9S20570C16D2Ev
  S20570C16(); // tgen
};
//SIG(-1 S20570C16) C1{ VBC2{ BC3{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} v1 v2 v3 FD Fs:16 Fi[7] FD Fc:6 FL:64 FL[2] Fi} VBC4{ BC2 VBC3 FC5{} FL Fi:23 Fs Fi Fl[2]} BC6{ BC7{ VBC3 vd v4 FC3[5] FL Fs:5 Fc:0 Fp[2] Fi FL} BC3 BC2 v5 FD Fp Fs[6] Fp Fi FD Fi} VBC8{ VBC3 Fp Fi FC2 Fi Fp} vd Fc:5 Fl[4] Fc[6] FC9{ vd m Fp Fl Fi Fp}}


 S20570C16 ::~S20570C16(){ note_dtor("S20570C16", this);}
S20570C16 ::S20570C16(){ note_ctor("S20570C16", this);} // tgen

static void Test_S20570C16()
{
  extern Class_Descriptor cd_S20570C16;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(207,602)];
    init_test(&cd_S20570C16, buf);
    S20570C16 *dp, &lv = *(dp=new (buf) S20570C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(3296,2404), "sizeof(S20570C16)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20570C16)");
    /*is_ambiguous_... S20570C16::S20570C7 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20570C7*), ABISELECT(1952,1408), "S20570C16");
    /*is_ambiguous_... S20570C16::S20570C7 */ AMB_check_base_class_offset(lv, (S20570C7*), ABISELECT(1936,1404), "S20570C16");
    check_base_class_offset(lv, (S20570C5*)(S20570C7*)(S20570C12*), ABISELECT(2304,1668), "S20570C16");
    check_base_class_offset(lv, (S20570C7*)(S20570C12*), ABISELECT(2288,1664), "S20570C16");
    /*is_ambiguous_... S20570C12::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20570C12*), ABISELECT(2672,1956), "S20570C16");
    check_base_class_offset(lv, (S20570C5*)(S20570C10*)(S20570C9*), ABISELECT(2672,1956), "S20570C16");
    check_base_class_offset(lv, (S20570C5*)(S20570C6*), ABISELECT(2672,1956), "S20570C16");
    check_base_class_offset(lv, (S20570C12*), ABISELECT(2288,1664), "S20570C16");
    check_base_class_offset(lv, (S20570C10*)(S20570C9*), 0, "S20570C16");
    /*is_ambiguous_... S20570C9::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20570C9*), ABISELECT(1184,876), "S20570C16");
    check_base_class_offset(lv, (S20570C5*)(S20570C7*)(S20570C9*), ABISELECT(1424,1048), "S20570C16");
    check_base_class_offset(lv, (S20570C7*)(S20570C9*), ABISELECT(1408,1044), "S20570C16");
    check_base_class_offset(lv, (S20570C9*), 0, "S20570C16");
    check_base_class_offset(lv, (S20570C6*), ABISELECT(2896,2124), "S20570C16");
    set_bf_and_test(lv, s20570c16f0, ABISELECT(1844,1356), 0, 5, 1, "S20570C16");
    set_bf_and_test(lv, s20570c16f0, ABISELECT(1844,1356), 0, 5, hide_sll(1LL<<4), "S20570C16");
    check_field_offset(lv, s20570c16f1, ABISELECT(1848,1360), "S20570C16.s20570c16f1");
    check_field_offset(lv, s20570c16f2, ABISELECT(1880,1376), "S20570C16.s20570c16f2");
    check_field_offset(lv, s20570c16f3, ABISELECT(1888,1384), "S20570C16.s20570c16f3");
    test_class_info(&lv, &cd_S20570C16);
    dp->~S20570C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20570C16(Test_S20570C16, "S20570C16", ABISELECT(3296,2404));

#else // __cplusplus

extern void _ZN9S20570C16C1Ev();
extern void _ZN9S20570C16D2Ev();
Name_Map name_map_S20570C16[] = {
  NSPAIR(_ZN9S20570C16C1Ev),
  NSPAIR(_ZN9S20570C16D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C7;
extern VTBL_ENTRY _ZTI8S20570C7[];
extern  VTBL_ENTRY _ZTV8S20570C7[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C7;
extern VTBL_ENTRY _ZTI8S20570C7[];
extern  VTBL_ENTRY _ZTV8S20570C7[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C12;
extern VTBL_ENTRY _ZTI9S20570C12[];
extern  VTBL_ENTRY _ZTV9S20570C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C12[];
extern Class_Descriptor cd_S20570C10;
extern VTBL_ENTRY _ZTI9S20570C10[];
extern  VTBL_ENTRY _ZTV9S20570C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C10[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C7;
extern VTBL_ENTRY _ZTI8S20570C7[];
extern  VTBL_ENTRY _ZTV8S20570C7[];
extern Class_Descriptor cd_S20570C9;
extern VTBL_ENTRY _ZTI8S20570C9[];
extern  VTBL_ENTRY _ZTV8S20570C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20570C9[];
extern Class_Descriptor cd_S20570C6;
extern VTBL_ENTRY _ZTI8S20570C6[];
extern  VTBL_ENTRY _ZTV8S20570C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20570C6[];
static Base_Class bases_S20570C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(1952,1408), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20570C7,    ABISELECT(1936,1404), //bcp->offset
    15, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20570C5,    ABISELECT(2304,1668), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20570C7,    ABISELECT(2288,1664), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(2672,1956), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S20570C12,    ABISELECT(2288,1664), //bcp->offset
    23, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20570C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(1184,876), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(1424,1048), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20570C7,    ABISELECT(1408,1044), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20570C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20570C6,    ABISELECT(2896,2124), //bcp->offset
    32, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20570C16[];
extern void _ZN9S20570C16D1Ev();
extern void _ZN9S20570C16D0Ev();
extern void _ZN9S20570C102v8Ev();
extern void _ZN8S20570C93v12Ev();
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
static  VTBL_ENTRY vtc_S20570C16[] = {
  ABISELECT(2896,2124),
  ABISELECT(2288,1664),
  ABISELECT(1936,1404),
  ABISELECT(2672,1956),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C16[0]),
  (VTBL_ENTRY)&_ZN9S20570C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20570C16D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20570C93v12Ev,
  ABISELECT(-1408,-1044),
  (VTBL_ENTRY)&(_ZTI9S20570C16[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
  0,
  0,
  0,
  ABISELECT(-1936,-1404),
  (VTBL_ENTRY)&(_ZTI9S20570C16[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
  0,
  0,
  0,
  ABISELECT(384,292),
  ABISELECT(-2288,-1664),
  (VTBL_ENTRY)&(_ZTI9S20570C16[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
  ABISELECT(-224,-168),
  ABISELECT(-2896,-2124),
  (VTBL_ENTRY)&(_ZTI9S20570C16[0]),
};
extern VTBL_ENTRY _ZTV9S20570C16[];
extern void _ZN8S20570C9D1Ev();
extern void _ZN8S20570C9D0Ev();
extern void _ZN9S20570C102v8Ev();
extern void _ZN8S20570C93v12Ev();
static  VTBL_ENTRY _tg__ZTV8S20570C9__9S20570C16[] = {
  ABISELECT(2672,1956),
  0,
  (VTBL_ENTRY)&(_ZTI8S20570C9[0]),
  (VTBL_ENTRY)&_ZN8S20570C9D1Ev,
  (VTBL_ENTRY)&_ZN8S20570C9D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20570C93v12Ev,
};
extern void _ZN9S20570C10D1Ev();
extern void _ZN9S20570C10D0Ev();
extern void _ZN9S20570C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C108S20570C9__9S20570C16[] = {
  ABISELECT(2672,1956),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C10[0]),
  (VTBL_ENTRY)&_ZN9S20570C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20570C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
};
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C12__9S20570C16[] = {
  ABISELECT(384,292),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C12[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20570C6__9S20570C16[] = {
  ABISELECT(-224,-168),
  0,
  (VTBL_ENTRY)&(_ZTI8S20570C6[0]),
};
static  VTT_ENTRY vtt_S20570C16[] = {
  {&(_ZTV9S20570C16[6]),  6,35},
  {&(_tg__ZTV8S20570C9__9S20570C16[3]),  3,7},
  {&(_tg__ZTV9S20570C108S20570C9__9S20570C16[3]),  3,6},
  {&(_ZTV9S20570C16[20]),  20,35},
  {&(_ZTV9S20570C16[29]),  29,35},
  {&(_ZTV9S20570C16[35]),  35,35},
  {&(_tg__ZTV9S20570C12__9S20570C16[3]),  3,6},
  {&(_tg__ZTV8S20570C6__9S20570C16[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20570C16[];
extern  VTBL_ENTRY _ZTV9S20570C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C16[];
Class_Descriptor cd_S20570C16 = {  "S20570C16", // class name
  bases_S20570C16, 12,
  &(vtc_S20570C16[0]), // expected_vtbl_contents
  &(vtt_S20570C16[0]), // expected_vtt_contents
  ABISELECT(3296,2404), // object size
  NSPAIRA(_ZTI9S20570C16),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S20570C16),35, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20570C16),8, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20570C18  : S20570C16 , virtual S20570C4 {
  short s20570c18f0;
  char s20570c18f1;
  short s20570c18f2[5];
  ::S20570C10 s20570c18f3;
  short s20570c18f4:16;
  int s20570c18f5;
  virtual void  v14(); // _ZN9S20570C183v14Ev
  virtual void  v15(); // _ZN9S20570C183v15Ev
  virtual void  v16(); // _ZN9S20570C183v16Ev
  virtual void  v17(); // _ZN9S20570C183v17Ev
  virtual void  v18(); // _ZN9S20570C183v18Ev
  ~S20570C18(); // tgen
  S20570C18(); // tgen
};
//SIG(-1 S20570C18) C1{ BC2{ VBC3{ BC4{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} v6 v7 v8 FD Fs:16 Fi[7] FD Fc:6 FL:64 FL[2] Fi} VBC5{ BC3 VBC4 FC6{} FL Fi:23 Fs Fi Fl[2]} BC7{ BC8{ VBC4 vd v9 FC4[5] FL Fs:5 Fc:0 Fp[2] Fi FL} BC4 BC3 v10 FD Fp Fs[6] Fp Fi FD Fi} VBC9{ VBC4 Fp Fi FC3 Fi Fp} vd Fc:5 Fl[4] Fc[6] FC10{ vd m Fp Fl Fi Fp}} VBC11{ VBC4 vd v11 Fl[3] FL Fs Fi FL Fi} v1 v2 v3 v4 v5 Fs Fc Fs[5] FC8 Fs:16 Fi}


void  S20570C18 ::v14(){vfunc_called(this, "_ZN9S20570C183v14Ev");}
void  S20570C18 ::v15(){vfunc_called(this, "_ZN9S20570C183v15Ev");}
void  S20570C18 ::v16(){vfunc_called(this, "_ZN9S20570C183v16Ev");}
void  S20570C18 ::v17(){vfunc_called(this, "_ZN9S20570C183v17Ev");}
void  S20570C18 ::v18(){vfunc_called(this, "_ZN9S20570C183v18Ev");}
S20570C18 ::~S20570C18(){ note_dtor("S20570C18", this);} // tgen
S20570C18 ::S20570C18(){ note_ctor("S20570C18", this);} // tgen

static void Test_S20570C18()
{
  extern Class_Descriptor cd_S20570C18;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(301,880)];
    init_test(&cd_S20570C18, buf);
    S20570C18 *dp, &lv = *(dp=new (buf) S20570C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(4800,3516), "sizeof(S20570C18)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20570C18)");
    /*is_ambiguous_... S20570C18::S20570C7 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20570C7*), ABISELECT(3392,2476), "S20570C18");
    /*is_ambiguous_... S20570C16::S20570C7 */ AMB_check_base_class_offset(lv, (S20570C7*)(S20570C16*), ABISELECT(3376,2472), "S20570C18");
    check_base_class_offset(lv, (S20570C5*)(S20570C7*)(S20570C12*), ABISELECT(3744,2736), "S20570C18");
    check_base_class_offset(lv, (S20570C7*)(S20570C12*), ABISELECT(3728,2732), "S20570C18");
    /*is_ambiguous_... S20570C12::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20570C12*), ABISELECT(4112,3024), "S20570C18");
    check_base_class_offset(lv, (S20570C5*)(S20570C10*)(S20570C9*)(S20570C16*), ABISELECT(4112,3024), "S20570C18");
    check_base_class_offset(lv, (S20570C5*)(S20570C6*), ABISELECT(4112,3024), "S20570C18");
    check_base_class_offset(lv, (S20570C5*)(S20570C4*), ABISELECT(4112,3024), "S20570C18");
    check_base_class_offset(lv, (S20570C12*)(S20570C16*), ABISELECT(3728,2732), "S20570C18");
    check_base_class_offset(lv, (S20570C10*)(S20570C9*)(S20570C16*), 0, "S20570C18");
    /*is_ambiguous_... S20570C9::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20570C9*)(S20570C16*), ABISELECT(1184,876), "S20570C18");
    check_base_class_offset(lv, (S20570C5*)(S20570C7*)(S20570C9*)(S20570C16*), ABISELECT(1424,1048), "S20570C18");
    check_base_class_offset(lv, (S20570C7*)(S20570C9*)(S20570C16*), ABISELECT(1408,1044), "S20570C18");
    check_base_class_offset(lv, (S20570C9*)(S20570C16*), 0, "S20570C18");
    check_base_class_offset(lv, (S20570C6*)(S20570C16*), ABISELECT(4336,3192), "S20570C18");
    check_base_class_offset(lv, (S20570C16*), 0, "S20570C18");
    check_base_class_offset(lv, (S20570C4*), ABISELECT(4736,3472), "S20570C18");
    check_field_offset(lv, s20570c18f0, ABISELECT(1928,1404), "S20570C18.s20570c18f0");
    check_field_offset(lv, s20570c18f1, ABISELECT(1930,1406), "S20570C18.s20570c18f1");
    check_field_offset(lv, s20570c18f2, ABISELECT(1932,1408), "S20570C18.s20570c18f2");
    check_field_offset(lv, s20570c18f3, ABISELECT(1952,1420), "S20570C18.s20570c18f3");
    set_bf_and_test(lv, s20570c18f4, ABISELECT(3360,2464), 0, 16, 1, "S20570C18");
    set_bf_and_test(lv, s20570c18f4, ABISELECT(3360,2464), 0, 16, hide_sll(1LL<<15), "S20570C18");
    check_field_offset(lv, s20570c18f5, ABISELECT(3364,2468), "S20570C18.s20570c18f5");
    test_class_info(&lv, &cd_S20570C18);
    dp->~S20570C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20570C18(Test_S20570C18, "S20570C18", ABISELECT(4800,3516));

#else // __cplusplus

extern void _ZN9S20570C18C1Ev();
extern void _ZN9S20570C18D1Ev();
Name_Map name_map_S20570C18[] = {
  NSPAIR(_ZN9S20570C18C1Ev),
  NSPAIR(_ZN9S20570C18D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C7;
extern VTBL_ENTRY _ZTI8S20570C7[];
extern  VTBL_ENTRY _ZTV8S20570C7[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C7;
extern VTBL_ENTRY _ZTI8S20570C7[];
extern  VTBL_ENTRY _ZTV8S20570C7[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C12;
extern VTBL_ENTRY _ZTI9S20570C12[];
extern  VTBL_ENTRY _ZTV9S20570C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C12[];
extern Class_Descriptor cd_S20570C10;
extern VTBL_ENTRY _ZTI9S20570C10[];
extern  VTBL_ENTRY _ZTV9S20570C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C10[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C7;
extern VTBL_ENTRY _ZTI8S20570C7[];
extern  VTBL_ENTRY _ZTV8S20570C7[];
extern Class_Descriptor cd_S20570C9;
extern VTBL_ENTRY _ZTI8S20570C9[];
extern  VTBL_ENTRY _ZTV8S20570C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20570C9[];
extern Class_Descriptor cd_S20570C6;
extern VTBL_ENTRY _ZTI8S20570C6[];
extern  VTBL_ENTRY _ZTV8S20570C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20570C6[];
extern Class_Descriptor cd_S20570C16;
extern VTBL_ENTRY _ZTI9S20570C16[];
extern  VTBL_ENTRY _ZTV9S20570C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C16[];
extern Class_Descriptor cd_S20570C4;
extern VTBL_ENTRY _ZTI8S20570C4[];
extern  VTBL_ENTRY _ZTV8S20570C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20570C4[];
static Base_Class bases_S20570C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(3392,2476), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20570C7,    ABISELECT(3376,2472), //bcp->offset
    21, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S20570C5,    ABISELECT(3744,2736), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20570C7,    ABISELECT(3728,2732), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(4112,3024), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S20570C12,    ABISELECT(3728,2732), //bcp->offset
    29, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S20570C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(1184,876), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(1424,1048), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20570C7,    ABISELECT(1408,1044), //bcp->offset
    16, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20570C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20570C6,    ABISELECT(4336,3192), //bcp->offset
    38, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S20570C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20570C4,    ABISELECT(4736,3472), //bcp->offset
    41, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20570C18[];
extern void _ZN9S20570C18D1Ev();
extern void _ZN9S20570C18D0Ev();
extern void _ZN9S20570C102v8Ev();
extern void _ZN8S20570C93v12Ev();
extern void _ZN9S20570C183v14Ev();
extern void _ZN9S20570C183v15Ev();
extern void _ZN9S20570C183v16Ev();
extern void _ZN9S20570C183v17Ev();
extern void _ZN9S20570C183v18Ev();
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
extern void ABISELECT(_ZTv0_n32_N9S20570C18D1Ev,_ZTv0_n16_N9S20570C18D1Ev)();
extern void ABISELECT(_ZThn4736_N9S20570C18D1Ev,_ZThn3472_N9S20570C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20570C18D0Ev,_ZTv0_n16_N9S20570C18D0Ev)();
extern void ABISELECT(_ZThn4736_N9S20570C18D0Ev,_ZThn3472_N9S20570C18D0Ev)() __attribute__((weak));
extern void _ZN8S20570C42v4Ev();
static  VTBL_ENTRY vtc_S20570C18[] = {
  ABISELECT(4736,3472),
  ABISELECT(4336,3192),
  ABISELECT(3728,2732),
  ABISELECT(3376,2472),
  ABISELECT(4112,3024),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C18[0]),
  (VTBL_ENTRY)&_ZN9S20570C18D1Ev,
  (VTBL_ENTRY)&_ZN9S20570C18D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20570C93v12Ev,
  (VTBL_ENTRY)&_ZN9S20570C183v14Ev,
  (VTBL_ENTRY)&_ZN9S20570C183v15Ev,
  (VTBL_ENTRY)&_ZN9S20570C183v16Ev,
  (VTBL_ENTRY)&_ZN9S20570C183v17Ev,
  (VTBL_ENTRY)&_ZN9S20570C183v18Ev,
  ABISELECT(-1408,-1044),
  (VTBL_ENTRY)&(_ZTI9S20570C18[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
  0,
  0,
  0,
  ABISELECT(-3376,-2472),
  (VTBL_ENTRY)&(_ZTI9S20570C18[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
  0,
  0,
  0,
  ABISELECT(384,292),
  ABISELECT(-3728,-2732),
  (VTBL_ENTRY)&(_ZTI9S20570C18[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
  ABISELECT(-224,-168),
  ABISELECT(-4336,-3192),
  (VTBL_ENTRY)&(_ZTI9S20570C18[0]),
  0,
  ABISELECT(-4736,-3472),
  ABISELECT(-624,-448),
  ABISELECT(-4736,-3472),
  (VTBL_ENTRY)&(_ZTI9S20570C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20570C18D1Ev,_ZTv0_n16_N9S20570C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20570C18D0Ev,_ZTv0_n16_N9S20570C18D0Ev),
  (VTBL_ENTRY)&_ZN8S20570C42v4Ev,
};
extern VTBL_ENTRY _ZTV9S20570C18[];
extern void _ZN9S20570C16D1Ev();
extern void _ZN9S20570C16D0Ev();
extern void _ZN9S20570C102v8Ev();
extern void _ZN8S20570C93v12Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C16__9S20570C18[] = {
  ABISELECT(4336,3192),
  ABISELECT(3728,2732),
  ABISELECT(3376,2472),
  ABISELECT(4112,3024),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C16[0]),
  (VTBL_ENTRY)&_ZN9S20570C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20570C16D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20570C93v12Ev,
};
extern void _ZN8S20570C9D1Ev();
extern void _ZN8S20570C9D0Ev();
extern void _ZN9S20570C102v8Ev();
extern void _ZN8S20570C93v12Ev();
static  VTBL_ENTRY _tg__ZTV8S20570C99S20570C16__9S20570C18[] = {
  ABISELECT(4112,3024),
  0,
  (VTBL_ENTRY)&(_ZTI8S20570C9[0]),
  (VTBL_ENTRY)&_ZN8S20570C9D1Ev,
  (VTBL_ENTRY)&_ZN8S20570C9D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20570C93v12Ev,
};
extern void _ZN9S20570C10D1Ev();
extern void _ZN9S20570C10D0Ev();
extern void _ZN9S20570C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C108S20570C99S20570C16__9S20570C18[] = {
  ABISELECT(4112,3024),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C10[0]),
  (VTBL_ENTRY)&_ZN9S20570C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20570C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
};
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
static  VTBL_ENTRY _tg__ZTV8S20570C7__9S20570C16__9S20570C18[] = {
  0,
  0,
  0,
  ABISELECT(-3376,-2472),
  (VTBL_ENTRY)&(_ZTI9S20570C16[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
};
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C12__9S20570C16__9S20570C18[] = {
  0,
  0,
  0,
  ABISELECT(384,292),
  ABISELECT(-3728,-2732),
  (VTBL_ENTRY)&(_ZTI9S20570C16[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20570C6__9S20570C16__9S20570C18[] = {
  ABISELECT(-224,-168),
  ABISELECT(-4336,-3192),
  (VTBL_ENTRY)&(_ZTI9S20570C16[0]),
};
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C12__9S20570C18[] = {
  ABISELECT(384,292),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C12[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20570C6__9S20570C18[] = {
  ABISELECT(-224,-168),
  0,
  (VTBL_ENTRY)&(_ZTI8S20570C6[0]),
};
extern void _ZN8S20570C4D1Ev();
extern void _ZN8S20570C4D0Ev();
extern void _ZN8S20570C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20570C4__9S20570C18[] = {
  ABISELECT(-624,-448),
  0,
  (VTBL_ENTRY)&(_ZTI8S20570C4[0]),
  (VTBL_ENTRY)&_ZN8S20570C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20570C4D0Ev,
  (VTBL_ENTRY)&_ZN8S20570C42v4Ev,
};
static  VTT_ENTRY vtt_S20570C18[] = {
  {&(_ZTV9S20570C18[7]),  7,49},
  {&(_tg__ZTV9S20570C16__9S20570C18[6]),  6,10},
  {&(_tg__ZTV8S20570C99S20570C16__9S20570C18[3]),  3,7},
  {&(_tg__ZTV9S20570C108S20570C99S20570C16__9S20570C18[3]),  3,6},
  {&(_tg__ZTV8S20570C7__9S20570C16__9S20570C18[5]),  5,8},
  {&(_tg__ZTV9S20570C12__9S20570C16__9S20570C18[6]),  6,9},
  {&(_tg__ZTV8S20570C6__9S20570C16__9S20570C18[3]),  3,3},
  {&(_ZTV9S20570C18[26]),  26,49},
  {&(_ZTV9S20570C18[35]),  35,49},
  {&(_ZTV9S20570C18[41]),  41,49},
  {&(_ZTV9S20570C18[46]),  46,49},
  {&(_tg__ZTV9S20570C12__9S20570C18[3]),  3,6},
  {&(_tg__ZTV8S20570C6__9S20570C18[3]),  3,3},
  {&(_tg__ZTV8S20570C4__9S20570C18[3]),  3,6},
};
extern VTBL_ENTRY _ZTI9S20570C18[];
extern  VTBL_ENTRY _ZTV9S20570C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C18[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20570C18D0Ev,_ZTv0_n16_N9S20570C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4736_N9S20570C18D0Ev,_ZThn3472_N9S20570C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20570C18D1Ev,_ZTv0_n16_N9S20570C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4736_N9S20570C18D1Ev,_ZThn3472_N9S20570C18D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20570C18 = {  "S20570C18", // class name
  bases_S20570C18, 14,
  &(vtc_S20570C18[0]), // expected_vtbl_contents
  &(vtt_S20570C18[0]), // expected_vtt_contents
  ABISELECT(4800,3516), // object size
  NSPAIRA(_ZTI9S20570C18),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S20570C18),49, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20570C18),14, //virtual table table var
  9, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20570C15  : S20570C16 , virtual S20570C4 , S20570C18 , S20570C14 {
  char s20570c15f0;
  virtual void  v13(); // _ZN9S20570C153v13Ev
  ~S20570C15(); // tgen
  S20570C15(); // tgen
};
//SIG(-1 S20570C15) C1{ BC2{ VBC3{ BC4{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} v2 v3 v4 FD Fs:16 Fi[7] FD Fc:6 FL:64 FL[2] Fi} VBC5{ BC3 VBC4 FC6{} FL Fi:23 Fs Fi Fl[2]} BC7{ BC8{ VBC4 vd v5 FC4[5] FL Fs:5 Fc:0 Fp[2] Fi FL} BC4 BC3 v6 FD Fp Fs[6] Fp Fi FD Fi} VBC9{ VBC4 Fp Fi FC3 Fi Fp} vd Fc:5 Fl[4] Fc[6] FC10{ vd m Fp Fl Fi Fp}} VBC11{ VBC4 vd v7 Fl[3] FL Fs Fi FL Fi} BC12{ BC2 VBC11 v8 v9 v10 v11 v12 Fs Fc Fs[5] FC8 Fs:16 Fi} BC13{ BC8 BC5 BC11 Fi:0} v1 Fc}


void  S20570C15 ::v13(){vfunc_called(this, "_ZN9S20570C153v13Ev");}
S20570C15 ::~S20570C15(){ note_dtor("S20570C15", this);} // tgen
S20570C15 ::S20570C15(){ note_ctor("S20570C15", this);} // tgen

static void Test_S20570C15()
{
  extern Class_Descriptor cd_S20570C15;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(524,1535)];
    init_test(&cd_S20570C15, buf);
    S20570C15 *dp, &lv = *(dp=new (buf) S20570C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8368,6136), "sizeof(S20570C15)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20570C15)");
    /*is_ambiguous_... S20570C15::S20570C7 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20570C7*), ABISELECT(6960,5096), "S20570C15");
    /*is_ambiguous_... S20570C15::S20570C16 */ AMB_check_base_class_offset(lv, (S20570C7*)(S20570C16*), ABISELECT(6944,5092), "S20570C15");
    /*is_ambiguous_... S20570C16::S20570C7 */ AMB_check_base_class_offset(lv, (S20570C7*)(S20570C16*)(S20570C18*), ABISELECT(6944,5092), "S20570C15");
    /*is_ambiguous_... S20570C15::S20570C12 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20570C7*)(S20570C12*), ABISELECT(7312,5356), "S20570C15");
    /*is_ambiguous_... S20570C15::S20570C12 */ AMB_check_base_class_offset(lv, (S20570C7*)(S20570C12*), ABISELECT(7296,5352), "S20570C15");
    /*is_ambiguous_... S20570C15::S20570C12 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20570C12*), ABISELECT(7680,5644), "S20570C15");
    /*is_ambiguous_... S20570C15::S20570C16 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20570C10*)(S20570C9*)(S20570C16*), ABISELECT(7680,5644), "S20570C15");
    check_base_class_offset(lv, (S20570C5*)(S20570C6*), ABISELECT(7680,5644), "S20570C15");
    /*is_ambiguous_... S20570C15::S20570C4 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20570C4*), ABISELECT(7680,5644), "S20570C15");
    check_base_class_offset(lv, (S20570C5*)(S20570C10*)(S20570C9*)(S20570C16*)(S20570C18*), ABISELECT(7680,5644), "S20570C15");
    check_base_class_offset(lv, (S20570C5*)(S20570C10*)(S20570C14*), ABISELECT(7680,5644), "S20570C15");
    /*is_ambiguous_... S20570C12::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20570C12*)(S20570C14*), ABISELECT(7680,5644), "S20570C15");
    check_base_class_offset(lv, (S20570C5*)(S20570C4*)(S20570C14*), ABISELECT(7680,5644), "S20570C15");
    /*is_ambiguous_... S20570C15::S20570C16 */ AMB_check_base_class_offset(lv, (S20570C12*)(S20570C16*), ABISELECT(7296,5352), "S20570C15");
    check_base_class_offset(lv, (S20570C12*)(S20570C16*)(S20570C18*), ABISELECT(7296,5352), "S20570C15");
    /*is_ambiguous_... S20570C15::S20570C16 */ AMB_check_base_class_offset(lv, (S20570C10*)(S20570C9*)(S20570C16*), 0, "S20570C15");
    /*is_ambiguous_... S20570C15::S20570C16 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20570C9*)(S20570C16*), ABISELECT(1184,876), "S20570C15");
    /*is_ambiguous_... S20570C15::S20570C16 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20570C7*)(S20570C9*)(S20570C16*), ABISELECT(1424,1048), "S20570C15");
    /*is_ambiguous_... S20570C15::S20570C16 */ AMB_check_base_class_offset(lv, (S20570C7*)(S20570C9*)(S20570C16*), ABISELECT(1408,1044), "S20570C15");
    /*is_ambiguous_... S20570C15::S20570C16 */ AMB_check_base_class_offset(lv, (S20570C9*)(S20570C16*), 0, "S20570C15");
    /*is_ambiguous_... S20570C15::S20570C16 */ AMB_check_base_class_offset(lv, (S20570C6*)(S20570C16*), ABISELECT(7904,5812), "S20570C15");
    check_base_class_offset(lv, (S20570C6*)(S20570C16*)(S20570C18*), ABISELECT(7904,5812), "S20570C15");
    /*is_ambiguous_... S20570C15::S20570C16 */ AMB_check_base_class_offset(lv, (S20570C16*), 0, "S20570C15");
    /*is_ambiguous_... S20570C15::S20570C4 */ AMB_check_base_class_offset(lv, (S20570C4*), ABISELECT(8304,6092), "S20570C15");
    check_base_class_offset(lv, (S20570C4*)(S20570C18*), ABISELECT(8304,6092), "S20570C15");
    check_base_class_offset(lv, (S20570C10*)(S20570C9*)(S20570C16*)(S20570C18*), ABISELECT(1936,1404), "S20570C15");
    /*is_ambiguous_... S20570C9::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20570C9*)(S20570C16*)(S20570C18*), ABISELECT(3120,2280), "S20570C15");
    check_base_class_offset(lv, (S20570C5*)(S20570C7*)(S20570C9*)(S20570C16*)(S20570C18*), ABISELECT(3360,2452), "S20570C15");
    check_base_class_offset(lv, (S20570C7*)(S20570C9*)(S20570C16*)(S20570C18*), ABISELECT(3344,2448), "S20570C15");
    check_base_class_offset(lv, (S20570C9*)(S20570C16*)(S20570C18*), ABISELECT(1936,1404), "S20570C15");
    check_base_class_offset(lv, (S20570C16*)(S20570C18*), ABISELECT(1936,1404), "S20570C15");
    check_base_class_offset(lv, (S20570C18*), ABISELECT(1936,1404), "S20570C15");
    check_base_class_offset(lv, (S20570C10*)(S20570C14*), ABISELECT(5312,3876), "S20570C15");
    check_base_class_offset(lv, (S20570C5*)(S20570C7*)(S20570C12*)(S20570C14*), ABISELECT(6512,4756), "S20570C15");
    check_base_class_offset(lv, (S20570C7*)(S20570C12*)(S20570C14*), ABISELECT(6496,4752), "S20570C15");
    check_base_class_offset(lv, (S20570C12*)(S20570C14*), ABISELECT(6496,4752), "S20570C15");
    check_base_class_offset(lv, (S20570C4*)(S20570C14*), ABISELECT(6880,5044), "S20570C15");
    check_base_class_offset(lv, (S20570C14*), ABISELECT(5312,3876), "S20570C15");
    check_field_offset(lv, s20570c15f0, ABISELECT(6940,5088), "S20570C15.s20570c15f0");
    test_class_info(&lv, &cd_S20570C15);
    dp->~S20570C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20570C15(Test_S20570C15, "S20570C15", ABISELECT(8368,6136));

#else // __cplusplus

extern void _ZN9S20570C15C1Ev();
extern void _ZN9S20570C15D1Ev();
Name_Map name_map_S20570C15[] = {
  NSPAIR(_ZN9S20570C15C1Ev),
  NSPAIR(_ZN9S20570C15D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C7;
extern VTBL_ENTRY _ZTI8S20570C7[];
extern  VTBL_ENTRY _ZTV8S20570C7[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C7;
extern VTBL_ENTRY _ZTI8S20570C7[];
extern  VTBL_ENTRY _ZTV8S20570C7[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C12;
extern VTBL_ENTRY _ZTI9S20570C12[];
extern  VTBL_ENTRY _ZTV9S20570C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C12[];
extern Class_Descriptor cd_S20570C10;
extern VTBL_ENTRY _ZTI9S20570C10[];
extern  VTBL_ENTRY _ZTV9S20570C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C10[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C7;
extern VTBL_ENTRY _ZTI8S20570C7[];
extern  VTBL_ENTRY _ZTV8S20570C7[];
extern Class_Descriptor cd_S20570C9;
extern VTBL_ENTRY _ZTI8S20570C9[];
extern  VTBL_ENTRY _ZTV8S20570C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20570C9[];
extern Class_Descriptor cd_S20570C6;
extern VTBL_ENTRY _ZTI8S20570C6[];
extern  VTBL_ENTRY _ZTV8S20570C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20570C6[];
extern Class_Descriptor cd_S20570C16;
extern VTBL_ENTRY _ZTI9S20570C16[];
extern  VTBL_ENTRY _ZTV9S20570C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C16[];
extern Class_Descriptor cd_S20570C4;
extern VTBL_ENTRY _ZTI8S20570C4[];
extern  VTBL_ENTRY _ZTV8S20570C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20570C4[];
extern Class_Descriptor cd_S20570C10;
extern VTBL_ENTRY _ZTI9S20570C10[];
extern  VTBL_ENTRY _ZTV9S20570C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C10[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C7;
extern VTBL_ENTRY _ZTI8S20570C7[];
extern  VTBL_ENTRY _ZTV8S20570C7[];
extern Class_Descriptor cd_S20570C9;
extern VTBL_ENTRY _ZTI8S20570C9[];
extern  VTBL_ENTRY _ZTV8S20570C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20570C9[];
extern Class_Descriptor cd_S20570C16;
extern VTBL_ENTRY _ZTI9S20570C16[];
extern  VTBL_ENTRY _ZTV9S20570C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C16[];
extern Class_Descriptor cd_S20570C18;
extern VTBL_ENTRY _ZTI9S20570C18[];
extern  VTBL_ENTRY _ZTV9S20570C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C18[];
extern Class_Descriptor cd_S20570C10;
extern VTBL_ENTRY _ZTI9S20570C10[];
extern  VTBL_ENTRY _ZTV9S20570C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C10[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C7;
extern VTBL_ENTRY _ZTI8S20570C7[];
extern  VTBL_ENTRY _ZTV8S20570C7[];
extern Class_Descriptor cd_S20570C12;
extern VTBL_ENTRY _ZTI9S20570C12[];
extern  VTBL_ENTRY _ZTV9S20570C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C12[];
extern Class_Descriptor cd_S20570C4;
extern VTBL_ENTRY _ZTI8S20570C4[];
extern  VTBL_ENTRY _ZTV8S20570C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20570C4[];
extern Class_Descriptor cd_S20570C14;
extern VTBL_ENTRY _ZTI9S20570C14[];
extern  VTBL_ENTRY _ZTV9S20570C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C14[];
static Base_Class bases_S20570C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(6960,5096), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20570C7,    ABISELECT(6944,5092), //bcp->offset
    56, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S20570C5,    ABISELECT(7312,5356), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20570C7,    ABISELECT(7296,5352), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(7680,5644), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S20570C12,    ABISELECT(7296,5352), //bcp->offset
    64, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S20570C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(1184,876), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(1424,1048), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20570C7,    ABISELECT(1408,1044), //bcp->offset
    12, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20570C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20570C6,    ABISELECT(7904,5812), //bcp->offset
    73, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S20570C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20570C4,    ABISELECT(8304,6092), //bcp->offset
    76, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20570C10,    ABISELECT(1936,1404), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(3120,2280), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(3360,2452), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S20570C7,    ABISELECT(3344,2448), //bcp->offset
    33, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20570C9,    ABISELECT(1936,1404), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S20570C16,    ABISELECT(1936,1404), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S20570C18,    ABISELECT(1936,1404), //bcp->offset
    17, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20570C10,    ABISELECT(5312,3876), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(6512,4756), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S20570C7,    ABISELECT(6496,4752), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S20570C12,    ABISELECT(6496,4752), //bcp->offset
    44, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S20570C4,    ABISELECT(6880,5044), //bcp->offset
    50, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    32, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S20570C14,    ABISELECT(5312,3876), //bcp->offset
    38, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20570C15[];
extern void _ZN9S20570C15D1Ev();
extern void _ZN9S20570C15D0Ev();
extern void _ZN9S20570C102v8Ev();
extern void _ZN8S20570C93v12Ev();
extern void _ZN9S20570C153v13Ev();
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
extern void ABISELECT(_ZThn1936_N9S20570C15D1Ev,_ZThn1404_N9S20570C15D1Ev)();
extern void ABISELECT(_ZThn1936_N9S20570C15D0Ev,_ZThn1404_N9S20570C15D0Ev)();
extern void _ZN9S20570C102v8Ev();
extern void _ZN8S20570C93v12Ev();
extern void _ZN9S20570C183v14Ev();
extern void _ZN9S20570C183v15Ev();
extern void _ZN9S20570C183v16Ev();
extern void _ZN9S20570C183v17Ev();
extern void _ZN9S20570C183v18Ev();
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
extern void ABISELECT(_ZThn5312_N9S20570C15D1Ev,_ZThn3876_N9S20570C15D1Ev)();
extern void ABISELECT(_ZThn5312_N9S20570C15D0Ev,_ZThn3876_N9S20570C15D0Ev)();
extern void _ZN9S20570C102v8Ev();
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
extern void ABISELECT(_ZThn6880_N9S20570C15D1Ev,_ZThn5044_N9S20570C15D1Ev)();
extern void ABISELECT(_ZThn6880_N9S20570C15D0Ev,_ZThn5044_N9S20570C15D0Ev)();
extern void _ZN8S20570C42v4Ev();
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
extern void ABISELECT(_ZTv0_n32_N9S20570C15D1Ev,_ZTv0_n16_N9S20570C15D1Ev)();
extern void ABISELECT(_ZThn8304_N9S20570C15D1Ev,_ZThn6092_N9S20570C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20570C15D0Ev,_ZTv0_n16_N9S20570C15D0Ev)();
extern void ABISELECT(_ZThn8304_N9S20570C15D0Ev,_ZThn6092_N9S20570C15D0Ev)() __attribute__((weak));
extern void _ZN8S20570C42v4Ev();
static  VTBL_ENTRY vtc_S20570C15[] = {
  ABISELECT(8304,6092),
  ABISELECT(7904,5812),
  ABISELECT(7296,5352),
  ABISELECT(6944,5092),
  ABISELECT(7680,5644),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C15[0]),
  (VTBL_ENTRY)&_ZN9S20570C15D1Ev,
  (VTBL_ENTRY)&_ZN9S20570C15D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20570C93v12Ev,
  (VTBL_ENTRY)&_ZN9S20570C153v13Ev,
  ABISELECT(-1408,-1044),
  (VTBL_ENTRY)&(_ZTI9S20570C15[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
  ABISELECT(6368,4688),
  ABISELECT(5968,4408),
  ABISELECT(5360,3948),
  ABISELECT(5008,3688),
  ABISELECT(5744,4240),
  ABISELECT(-1936,-1404),
  (VTBL_ENTRY)&(_ZTI9S20570C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1936_N9S20570C15D1Ev,_ZThn1404_N9S20570C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1936_N9S20570C15D0Ev,_ZThn1404_N9S20570C15D0Ev),
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20570C93v12Ev,
  (VTBL_ENTRY)&_ZN9S20570C183v14Ev,
  (VTBL_ENTRY)&_ZN9S20570C183v15Ev,
  (VTBL_ENTRY)&_ZN9S20570C183v16Ev,
  (VTBL_ENTRY)&_ZN9S20570C183v17Ev,
  (VTBL_ENTRY)&_ZN9S20570C183v18Ev,
  ABISELECT(-3344,-2448),
  (VTBL_ENTRY)&(_ZTI9S20570C15[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
  ABISELECT(2368,1768),
  ABISELECT(-5312,-3876),
  (VTBL_ENTRY)&(_ZTI9S20570C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn5312_N9S20570C15D1Ev,_ZThn3876_N9S20570C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn5312_N9S20570C15D0Ev,_ZThn3876_N9S20570C15D0Ev),
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
  ABISELECT(1184,892),
  ABISELECT(-6496,-4752),
  (VTBL_ENTRY)&(_ZTI9S20570C15[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
  ABISELECT(800,600),
  ABISELECT(-6880,-5044),
  (VTBL_ENTRY)&(_ZTI9S20570C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn6880_N9S20570C15D1Ev,_ZThn5044_N9S20570C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn6880_N9S20570C15D0Ev,_ZThn5044_N9S20570C15D0Ev),
  (VTBL_ENTRY)&_ZN8S20570C42v4Ev,
  0,
  0,
  0,
  ABISELECT(-6944,-5092),
  (VTBL_ENTRY)&(_ZTI9S20570C15[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
  0,
  0,
  0,
  ABISELECT(384,292),
  ABISELECT(-7296,-5352),
  (VTBL_ENTRY)&(_ZTI9S20570C15[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
  ABISELECT(-224,-168),
  ABISELECT(-7904,-5812),
  (VTBL_ENTRY)&(_ZTI9S20570C15[0]),
  0,
  ABISELECT(-8304,-6092),
  ABISELECT(-624,-448),
  ABISELECT(-8304,-6092),
  (VTBL_ENTRY)&(_ZTI9S20570C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20570C15D1Ev,_ZTv0_n16_N9S20570C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20570C15D0Ev,_ZTv0_n16_N9S20570C15D0Ev),
  (VTBL_ENTRY)&_ZN8S20570C42v4Ev,
};
extern VTBL_ENTRY _ZTV9S20570C15[];
extern void _ZN9S20570C16D1Ev();
extern void _ZN9S20570C16D0Ev();
extern void _ZN9S20570C102v8Ev();
extern void _ZN8S20570C93v12Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C16__9S20570C15[] = {
  ABISELECT(7904,5812),
  ABISELECT(7296,5352),
  ABISELECT(6944,5092),
  ABISELECT(7680,5644),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C16[0]),
  (VTBL_ENTRY)&_ZN9S20570C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20570C16D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20570C93v12Ev,
};
extern void _ZN8S20570C9D1Ev();
extern void _ZN8S20570C9D0Ev();
extern void _ZN9S20570C102v8Ev();
extern void _ZN8S20570C93v12Ev();
static  VTBL_ENTRY _tg__ZTV8S20570C99S20570C16__9S20570C15[] = {
  ABISELECT(7680,5644),
  0,
  (VTBL_ENTRY)&(_ZTI8S20570C9[0]),
  (VTBL_ENTRY)&_ZN8S20570C9D1Ev,
  (VTBL_ENTRY)&_ZN8S20570C9D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20570C93v12Ev,
};
extern void _ZN9S20570C10D1Ev();
extern void _ZN9S20570C10D0Ev();
extern void _ZN9S20570C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C108S20570C99S20570C16__9S20570C15[] = {
  ABISELECT(7680,5644),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C10[0]),
  (VTBL_ENTRY)&_ZN9S20570C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20570C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
};
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
static  VTBL_ENTRY _tg__ZTV8S20570C7__9S20570C16__9S20570C15[] = {
  0,
  0,
  0,
  ABISELECT(-6944,-5092),
  (VTBL_ENTRY)&(_ZTI9S20570C16[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
};
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C12__9S20570C16__9S20570C15[] = {
  0,
  0,
  0,
  ABISELECT(384,292),
  ABISELECT(-7296,-5352),
  (VTBL_ENTRY)&(_ZTI9S20570C16[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20570C6__9S20570C16__9S20570C15[] = {
  ABISELECT(-224,-168),
  ABISELECT(-7904,-5812),
  (VTBL_ENTRY)&(_ZTI9S20570C16[0]),
};
extern void _ZN9S20570C18D1Ev();
extern void _ZN9S20570C18D0Ev();
extern void _ZN9S20570C102v8Ev();
extern void _ZN8S20570C93v12Ev();
extern void _ZN9S20570C183v14Ev();
extern void _ZN9S20570C183v15Ev();
extern void _ZN9S20570C183v16Ev();
extern void _ZN9S20570C183v17Ev();
extern void _ZN9S20570C183v18Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C18__9S20570C15[] = {
  ABISELECT(6368,4688),
  ABISELECT(5968,4408),
  ABISELECT(5360,3948),
  ABISELECT(5008,3688),
  ABISELECT(5744,4240),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C18[0]),
  (VTBL_ENTRY)&_ZN9S20570C18D1Ev,
  (VTBL_ENTRY)&_ZN9S20570C18D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20570C93v12Ev,
  (VTBL_ENTRY)&_ZN9S20570C183v14Ev,
  (VTBL_ENTRY)&_ZN9S20570C183v15Ev,
  (VTBL_ENTRY)&_ZN9S20570C183v16Ev,
  (VTBL_ENTRY)&_ZN9S20570C183v17Ev,
  (VTBL_ENTRY)&_ZN9S20570C183v18Ev,
};
extern void _ZN9S20570C16D1Ev();
extern void _ZN9S20570C16D0Ev();
extern void _ZN9S20570C102v8Ev();
extern void _ZN8S20570C93v12Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C169S20570C18__A1__9S20570C15[] = {
  ABISELECT(5968,4408),
  ABISELECT(5360,3948),
  ABISELECT(5008,3688),
  ABISELECT(5744,4240),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C16[0]),
  (VTBL_ENTRY)&_ZN9S20570C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20570C16D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20570C93v12Ev,
};
extern void _ZN8S20570C9D1Ev();
extern void _ZN8S20570C9D0Ev();
extern void _ZN9S20570C102v8Ev();
extern void _ZN8S20570C93v12Ev();
static  VTBL_ENTRY _tg__ZTV8S20570C99S20570C169S20570C18__A1__9S20570C15[] = {
  ABISELECT(5744,4240),
  0,
  (VTBL_ENTRY)&(_ZTI8S20570C9[0]),
  (VTBL_ENTRY)&_ZN8S20570C9D1Ev,
  (VTBL_ENTRY)&_ZN8S20570C9D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20570C93v12Ev,
};
extern void _ZN9S20570C10D1Ev();
extern void _ZN9S20570C10D0Ev();
extern void _ZN9S20570C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C108S20570C99S20570C169S20570C18__A1__9S20570C15[] = {
  ABISELECT(5744,4240),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C10[0]),
  (VTBL_ENTRY)&_ZN9S20570C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20570C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
};
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
static  VTBL_ENTRY _tg__ZTV8S20570C7__9S20570C169S20570C18__A1__9S20570C15[] = {
  0,
  0,
  0,
  ABISELECT(-5008,-3688),
  (VTBL_ENTRY)&(_ZTI9S20570C16[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
};
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C12__9S20570C169S20570C18__A1__9S20570C15[] = {
  0,
  0,
  0,
  ABISELECT(384,292),
  ABISELECT(-5360,-3948),
  (VTBL_ENTRY)&(_ZTI9S20570C16[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20570C6__9S20570C169S20570C18__A1__9S20570C15[] = {
  ABISELECT(-224,-168),
  ABISELECT(-5968,-4408),
  (VTBL_ENTRY)&(_ZTI9S20570C16[0]),
};
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
static  VTBL_ENTRY _tg__ZTV8S20570C7__9S20570C18__9S20570C15[] = {
  0,
  0,
  0,
  ABISELECT(-5008,-3688),
  (VTBL_ENTRY)&(_ZTI9S20570C18[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
};
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C12__9S20570C18__9S20570C15[] = {
  0,
  0,
  0,
  ABISELECT(384,292),
  ABISELECT(-5360,-3948),
  (VTBL_ENTRY)&(_ZTI9S20570C18[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20570C6__9S20570C18__9S20570C15[] = {
  ABISELECT(-224,-168),
  ABISELECT(-5968,-4408),
  (VTBL_ENTRY)&(_ZTI9S20570C18[0]),
};
extern void ABISELECT(_ZTv0_n32_N9S20570C18D1Ev,_ZTv0_n16_N9S20570C18D1Ev)();
extern void ABISELECT(_ZThn6368_N9S20570C18D1Ev,_ZThn4688_N9S20570C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20570C18D0Ev,_ZTv0_n16_N9S20570C18D0Ev)();
extern void ABISELECT(_ZThn6368_N9S20570C18D0Ev,_ZThn4688_N9S20570C18D0Ev)() __attribute__((weak));
extern void _ZN8S20570C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20570C4__9S20570C18__9S20570C15[] = {
  0,
  ABISELECT(-6368,-4688),
  ABISELECT(-624,-448),
  ABISELECT(-6368,-4688),
  (VTBL_ENTRY)&(_ZTI9S20570C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20570C18D1Ev,_ZTv0_n16_N9S20570C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20570C18D0Ev,_ZTv0_n16_N9S20570C18D0Ev),
  (VTBL_ENTRY)&_ZN8S20570C42v4Ev,
};
extern void _ZN9S20570C14D1Ev();
extern void _ZN9S20570C14D0Ev();
extern void _ZN9S20570C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C14__9S20570C15[] = {
  ABISELECT(2368,1768),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C14[0]),
  (VTBL_ENTRY)&_ZN9S20570C14D1Ev,
  (VTBL_ENTRY)&_ZN9S20570C14D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
};
extern void _ZN9S20570C10D1Ev();
extern void _ZN9S20570C10D0Ev();
extern void _ZN9S20570C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C109S20570C14__A2__9S20570C15[] = {
  ABISELECT(2368,1768),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C10[0]),
  (VTBL_ENTRY)&_ZN9S20570C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20570C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
};
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C129S20570C14__A1__9S20570C15[] = {
  ABISELECT(1184,892),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C12[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
};
extern void _ZN8S20570C4D1Ev();
extern void _ZN8S20570C4D0Ev();
extern void _ZN8S20570C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20570C49S20570C14__A1__9S20570C15[] = {
  ABISELECT(800,600),
  0,
  (VTBL_ENTRY)&(_ZTI8S20570C4[0]),
  (VTBL_ENTRY)&_ZN8S20570C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20570C4D0Ev,
  (VTBL_ENTRY)&_ZN8S20570C42v4Ev,
};
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C12__9S20570C14__9S20570C15[] = {
  ABISELECT(1184,892),
  ABISELECT(-1184,-876),
  (VTBL_ENTRY)&(_ZTI9S20570C14[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
};
extern void ABISELECT(_ZThn1568_N9S20570C14D1Ev,_ZThn1168_N9S20570C14D1Ev)();
extern void ABISELECT(_ZThn1568_N9S20570C14D0Ev,_ZThn1168_N9S20570C14D0Ev)();
extern void _ZN8S20570C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20570C4__9S20570C14__9S20570C15[] = {
  ABISELECT(800,600),
  ABISELECT(-1568,-1168),
  (VTBL_ENTRY)&(_ZTI9S20570C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1568_N9S20570C14D1Ev,_ZThn1168_N9S20570C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1568_N9S20570C14D0Ev,_ZThn1168_N9S20570C14D0Ev),
  (VTBL_ENTRY)&_ZN8S20570C42v4Ev,
};
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C12__9S20570C15[] = {
  ABISELECT(384,292),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C12[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20570C6__9S20570C15[] = {
  ABISELECT(-224,-168),
  0,
  (VTBL_ENTRY)&(_ZTI8S20570C6[0]),
};
extern void _ZN8S20570C4D1Ev();
extern void _ZN8S20570C4D0Ev();
extern void _ZN8S20570C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20570C4__9S20570C15[] = {
  ABISELECT(-624,-448),
  0,
  (VTBL_ENTRY)&(_ZTI8S20570C4[0]),
  (VTBL_ENTRY)&_ZN8S20570C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20570C4D0Ev,
  (VTBL_ENTRY)&_ZN8S20570C42v4Ev,
};
static  VTT_ENTRY vtt_S20570C15[] = {
  {&(_ZTV9S20570C15[7]),  7,84},
  {&(_tg__ZTV9S20570C16__9S20570C15[6]),  6,10},
  {&(_tg__ZTV8S20570C99S20570C16__9S20570C15[3]),  3,7},
  {&(_tg__ZTV9S20570C108S20570C99S20570C16__9S20570C15[3]),  3,6},
  {&(_tg__ZTV8S20570C7__9S20570C16__9S20570C15[5]),  5,8},
  {&(_tg__ZTV9S20570C12__9S20570C16__9S20570C15[6]),  6,9},
  {&(_tg__ZTV8S20570C6__9S20570C16__9S20570C15[3]),  3,3},
  {&(_tg__ZTV9S20570C18__9S20570C15[7]),  7,16},
  {&(_tg__ZTV9S20570C169S20570C18__A1__9S20570C15[6]),  6,10},
  {&(_tg__ZTV8S20570C99S20570C169S20570C18__A1__9S20570C15[3]),  3,7},
  {&(_tg__ZTV9S20570C108S20570C99S20570C169S20570C18__A1__9S20570C15[3]),  3,6},
  {&(_tg__ZTV8S20570C7__9S20570C169S20570C18__A1__9S20570C15[5]),  5,8},
  {&(_tg__ZTV9S20570C12__9S20570C169S20570C18__A1__9S20570C15[6]),  6,9},
  {&(_tg__ZTV8S20570C6__9S20570C169S20570C18__A1__9S20570C15[3]),  3,3},
  {&(_tg__ZTV8S20570C7__9S20570C18__9S20570C15[5]),  5,8},
  {&(_tg__ZTV9S20570C12__9S20570C18__9S20570C15[6]),  6,9},
  {&(_tg__ZTV8S20570C6__9S20570C18__9S20570C15[3]),  3,3},
  {&(_tg__ZTV8S20570C4__9S20570C18__9S20570C15[5]),  5,8},
  {&(_tg__ZTV9S20570C14__9S20570C15[3]),  3,6},
  {&(_tg__ZTV9S20570C109S20570C14__A2__9S20570C15[3]),  3,6},
  {&(_tg__ZTV9S20570C129S20570C14__A1__9S20570C15[3]),  3,6},
  {&(_tg__ZTV8S20570C49S20570C14__A1__9S20570C15[3]),  3,6},
  {&(_tg__ZTV9S20570C12__9S20570C14__9S20570C15[3]),  3,6},
  {&(_tg__ZTV8S20570C4__9S20570C14__9S20570C15[3]),  3,6},
  {&(_ZTV9S20570C15[61]),  61,84},
  {&(_ZTV9S20570C15[70]),  70,84},
  {&(_ZTV9S20570C15[76]),  76,84},
  {&(_ZTV9S20570C15[81]),  81,84},
  {&(_ZTV9S20570C15[24]),  24,84},
  {&(_ZTV9S20570C15[41]),  41,84},
  {&(_ZTV9S20570C15[47]),  47,84},
  {&(_ZTV9S20570C15[53]),  53,84},
  {&(_tg__ZTV9S20570C12__9S20570C15[3]),  3,6},
  {&(_tg__ZTV8S20570C6__9S20570C15[3]),  3,3},
  {&(_tg__ZTV8S20570C4__9S20570C15[3]),  3,6},
};
extern VTBL_ENTRY _ZTI9S20570C15[];
extern  VTBL_ENTRY _ZTV9S20570C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C15[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20570C18D0Ev,_ZTv0_n16_N9S20570C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6368_N9S20570C18D0Ev,_ZThn4688_N9S20570C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20570C18D1Ev,_ZTv0_n16_N9S20570C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6368_N9S20570C18D1Ev,_ZThn4688_N9S20570C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20570C15D0Ev,_ZTv0_n16_N9S20570C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8304_N9S20570C15D0Ev,_ZThn6092_N9S20570C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20570C15D1Ev,_ZTv0_n16_N9S20570C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8304_N9S20570C15D1Ev,_ZThn6092_N9S20570C15D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20570C15 = {  "S20570C15", // class name
  bases_S20570C15, 27,
  &(vtc_S20570C15[0]), // expected_vtbl_contents
  &(vtt_S20570C15[0]), // expected_vtt_contents
  ABISELECT(8368,6136), // object size
  NSPAIRA(_ZTI9S20570C15),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S20570C15),84, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20570C15),35, //virtual table table var
  19, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20570C1  : virtual S20570C2 , virtual S20570C6 , S20570C8 , virtual S20570C11 , S20570C5 {
  void *s20570c1f0[10];
  short s20570c1f1;
  char s20570c1f2:3;
  short s20570c1f3:16;
  ::S20570C11 s20570c1f4;
  ::S20570C15 s20570c1f5;
  void *s20570c1f6;
  char s20570c1f7;
  short s20570c1f8[6];
  long s20570c1f9[2];
  virtual void  v1(); // _ZN8S20570C12v1Ev
  virtual void  v2(); // _ZN8S20570C12v2Ev
  virtual void  v3(); // _ZN8S20570C12v3Ev
  ~S20570C1(); // tgen
  S20570C1(); // tgen
};
//SIG(1 S20570C1) C1{ VBC2{ VBC3{ BC4{ VBC5{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} vd v4 Fl[3] FL Fs Fi FL Fi} v5 v6 Fi Fp Fi FD[9] Fl Fi FL Fp[5] FL} vd v7 Fi:26 Fc[2]} VBC6{ VBC5 Fp Fi FC7{ BC5 v9 v10 v11 FD Fs:16 Fi[7] FD Fc:6 FL:64 FL[2] Fi} Fi Fp} BC8{ VBC5 BC9{ BC10{ VBC5 vd v8 FC5[5] FL Fs:5 Fc:0 Fp[2] Fi FL} BC5 BC7 v12 FD Fp Fs[6] Fp Fi FD Fi} BC10 vd FD[9] Fs} VBC11{ BC10 BC12{ BC7 VBC5 FC13{} FL Fi:23 Fs Fi Fl[2]} Fp[13] Fi[2] Fl Fp[2] Fs FC14{ BC10 BC12 BC4 Fi:0} Fi} BC5 v1 v2 v3 Fp[10] Fs Fc:3 Fs:16 FC11 FC15{ BC16{ VBC7 VBC12 BC9 VBC6 vd Fc:5 Fl[4] Fc[6] FC17{ vd m Fp Fl Fi Fp}} VBC4 BC18{ BC16 VBC4 v14 v15 v16 v17 v18 Fs Fc Fs[5] FC10 Fs:16 Fi} BC14 v13 Fc} Fp Fc Fs[6] Fl[2]}


void  S20570C1 ::v1(){vfunc_called(this, "_ZN8S20570C12v1Ev");}
void  S20570C1 ::v2(){vfunc_called(this, "_ZN8S20570C12v2Ev");}
void  S20570C1 ::v3(){vfunc_called(this, "_ZN8S20570C12v3Ev");}
S20570C1 ::~S20570C1(){ note_dtor("S20570C1", this);} // tgen
S20570C1 ::S20570C1(){ note_ctor("S20570C1", this);} // tgen

static void Test_S20570C1()
{
  extern Class_Descriptor cd_S20570C1;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1268,3705)];
    init_test(&cd_S20570C1, buf);
    S20570C1 *dp, &lv = *(dp=new (buf) S20570C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(20272,14816), "sizeof(S20570C1)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20570C1)");
    check_base_class_offset(lv, (S20570C5*)(S20570C4*)(S20570C3*), ABISELECT(16064,11740), "S20570C1");
    check_base_class_offset(lv, (S20570C5*)(S20570C6*), ABISELECT(16064,11740), "S20570C1");
    /*is_ambiguous_... S20570C8::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20570C8*), ABISELECT(16064,11740), "S20570C1");
    check_base_class_offset(lv, (S20570C5*)(S20570C10*)(S20570C9*)(S20570C8*), ABISELECT(16064,11740), "S20570C1");
    /*is_ambiguous_... S20570C8::S20570C10 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20570C10*)(S20570C8*), ABISELECT(16064,11740), "S20570C1");
    check_base_class_offset(lv, (S20570C5*)(S20570C10*)(S20570C11*), ABISELECT(16064,11740), "S20570C1");
    /*is_ambiguous_... S20570C12::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20570C12*)(S20570C11*), ABISELECT(16064,11740), "S20570C1");
    check_base_class_offset(lv, (S20570C4*)(S20570C3*), ABISELECT(15760,11532), "S20570C1");
    check_base_class_offset(lv, (S20570C3*)(S20570C2*), ABISELECT(15760,11532), "S20570C1");
    check_base_class_offset(lv, (S20570C2*), ABISELECT(15736,11520), "S20570C1");
    check_base_class_offset(lv, (S20570C6*), ABISELECT(16288,11908), "S20570C1");
    check_base_class_offset(lv, (S20570C10*)(S20570C9*)(S20570C8*), 0, "S20570C1");
    /*is_ambiguous_... S20570C9::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20570C9*)(S20570C8*), ABISELECT(1184,876), "S20570C1");
    check_base_class_offset(lv, (S20570C5*)(S20570C7*)(S20570C9*)(S20570C8*), ABISELECT(1424,1048), "S20570C1");
    check_base_class_offset(lv, (S20570C7*)(S20570C9*)(S20570C8*), ABISELECT(1408,1044), "S20570C1");
    check_base_class_offset(lv, (S20570C9*)(S20570C8*), 0, "S20570C1");
    /*is_ambiguous_... S20570C8::S20570C10 */ AMB_check_base_class_offset(lv, (S20570C10*)(S20570C8*), ABISELECT(1856,1356), "S20570C1");
    check_base_class_offset(lv, (S20570C8*), 0, "S20570C1");
    check_base_class_offset(lv, (S20570C10*)(S20570C11*), ABISELECT(16688,12188), "S20570C1");
    check_base_class_offset(lv, (S20570C5*)(S20570C7*)(S20570C12*)(S20570C11*), ABISELECT(17888,13068), "S20570C1");
    check_base_class_offset(lv, (S20570C7*)(S20570C12*)(S20570C11*), ABISELECT(17872,13064), "S20570C1");
    check_base_class_offset(lv, (S20570C12*)(S20570C11*), ABISELECT(17872,13064), "S20570C1");
    check_base_class_offset(lv, (S20570C11*), ABISELECT(16688,12188), "S20570C1");
    /*is_ambiguous_... S20570C1::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*), ABISELECT(3200,2344), "S20570C1");
    check_field_offset(lv, s20570c1f0, ABISELECT(3424,2512), "S20570C1.s20570c1f0");
    check_field_offset(lv, s20570c1f1, ABISELECT(3504,2552), "S20570C1.s20570c1f1");
    set_bf_and_test(lv, s20570c1f2, ABISELECT(3506,2554), 0, 3, 1, "S20570C1");
    set_bf_and_test(lv, s20570c1f2, ABISELECT(3506,2554), 0, 3, hide_sll(1LL<<2), "S20570C1");
    set_bf_and_test(lv, s20570c1f3, ABISELECT(3508,2556), 0, 16, 1, "S20570C1");
    set_bf_and_test(lv, s20570c1f3, ABISELECT(3508,2556), 0, 16, hide_sll(1LL<<15), "S20570C1");
    check_field_offset(lv, s20570c1f4, ABISELECT(3520,2560), "S20570C1.s20570c1f4");
    check_field_offset(lv, s20570c1f5, ABISELECT(7328,5356), "S20570C1.s20570c1f5");
    check_field_offset(lv, s20570c1f6, ABISELECT(15696,11492), "S20570C1.s20570c1f6");
    check_field_offset(lv, s20570c1f7, ABISELECT(15704,11496), "S20570C1.s20570c1f7");
    check_field_offset(lv, s20570c1f8, ABISELECT(15706,11498), "S20570C1.s20570c1f8");
    check_field_offset(lv, s20570c1f9, ABISELECT(15720,11512), "S20570C1.s20570c1f9");
    test_class_info(&lv, &cd_S20570C1);
    dp->~S20570C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20570C1(Test_S20570C1, "S20570C1", ABISELECT(20272,14816));

#else // __cplusplus

extern void _ZN8S20570C1C1Ev();
extern void _ZN8S20570C1D1Ev();
Name_Map name_map_S20570C1[] = {
  NSPAIR(_ZN8S20570C1C1Ev),
  NSPAIR(_ZN8S20570C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C4;
extern VTBL_ENTRY _ZTI8S20570C4[];
extern  VTBL_ENTRY _ZTV8S20570C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20570C4[];
extern Class_Descriptor cd_S20570C3;
extern VTBL_ENTRY _ZTI8S20570C3[];
extern  VTBL_ENTRY _ZTV8S20570C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20570C3[];
extern Class_Descriptor cd_S20570C2;
extern VTBL_ENTRY _ZTI8S20570C2[];
extern  VTBL_ENTRY _ZTV8S20570C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20570C2[];
extern Class_Descriptor cd_S20570C6;
extern VTBL_ENTRY _ZTI8S20570C6[];
extern  VTBL_ENTRY _ZTV8S20570C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20570C6[];
extern Class_Descriptor cd_S20570C10;
extern VTBL_ENTRY _ZTI9S20570C10[];
extern  VTBL_ENTRY _ZTV9S20570C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C10[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C7;
extern VTBL_ENTRY _ZTI8S20570C7[];
extern  VTBL_ENTRY _ZTV8S20570C7[];
extern Class_Descriptor cd_S20570C9;
extern VTBL_ENTRY _ZTI8S20570C9[];
extern  VTBL_ENTRY _ZTV8S20570C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20570C9[];
extern Class_Descriptor cd_S20570C10;
extern VTBL_ENTRY _ZTI9S20570C10[];
extern  VTBL_ENTRY _ZTV9S20570C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C10[];
extern Class_Descriptor cd_S20570C8;
extern VTBL_ENTRY _ZTI8S20570C8[];
extern  VTBL_ENTRY _ZTV8S20570C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20570C8[];
extern Class_Descriptor cd_S20570C10;
extern VTBL_ENTRY _ZTI9S20570C10[];
extern  VTBL_ENTRY _ZTV9S20570C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C10[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C7;
extern VTBL_ENTRY _ZTI8S20570C7[];
extern  VTBL_ENTRY _ZTV8S20570C7[];
extern Class_Descriptor cd_S20570C12;
extern VTBL_ENTRY _ZTI9S20570C12[];
extern  VTBL_ENTRY _ZTV9S20570C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C12[];
extern Class_Descriptor cd_S20570C11;
extern VTBL_ENTRY _ZTI9S20570C11[];
extern  VTBL_ENTRY _ZTV9S20570C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20570C11[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
static Base_Class bases_S20570C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(16064,11740), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20570C4,    ABISELECT(15760,11532), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20570C3,    ABISELECT(15760,11532), //bcp->offset
    34, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20570C2,    ABISELECT(15736,11520), //bcp->offset
    25, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20570C6,    ABISELECT(16288,11908), //bcp->offset
    46, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20570C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(1184,876), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(1424,1048), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20570C7,    ABISELECT(1408,1044), //bcp->offset
    14, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20570C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20570C10,    ABISELECT(1856,1356), //bcp->offset
    19, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20570C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20570C10,    ABISELECT(16688,12188), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(17888,13068), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20570C7,    ABISELECT(17872,13064), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S20570C12,    ABISELECT(17872,13064), //bcp->offset
    60, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20570C11,    ABISELECT(16688,12188), //bcp->offset
    49, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20570C5,    ABISELECT(3200,2344), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20570C1[];
extern void _ZN8S20570C1D1Ev();
extern void _ZN8S20570C1D0Ev();
extern void _ZN9S20570C102v8Ev();
extern void _ZN8S20570C93v12Ev();
extern void _ZN8S20570C12v1Ev();
extern void _ZN8S20570C12v2Ev();
extern void _ZN8S20570C12v3Ev();
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
extern void ABISELECT(_ZThn1856_N8S20570C1D1Ev,_ZThn1356_N8S20570C1D1Ev)();
extern void ABISELECT(_ZThn1856_N8S20570C1D0Ev,_ZThn1356_N8S20570C1D0Ev)();
extern void _ZN9S20570C102v8Ev();
extern void ABISELECT(_ZTv0_n40_N8S20570C1D1Ev,_ZTv0_n20_N8S20570C1D1Ev)();
extern void ABISELECT(_ZThn15736_N8S20570C1D1Ev,_ZThn11520_N8S20570C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S20570C1D0Ev,_ZTv0_n20_N8S20570C1D0Ev)();
extern void ABISELECT(_ZThn15736_N8S20570C1D0Ev,_ZThn11520_N8S20570C1D0Ev)() __attribute__((weak));
extern void _ZN8S20570C22v7Ev();
extern void ABISELECT(_ZTv0_n32_N8S20570C1D1Ev,_ZTv0_n16_N8S20570C1D1Ev)();
extern void ABISELECT(_ZThn15760_N8S20570C1D1Ev,_ZThn11532_N8S20570C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20570C1D0Ev,_ZTv0_n16_N8S20570C1D0Ev)();
extern void ABISELECT(_ZThn15760_N8S20570C1D0Ev,_ZThn11532_N8S20570C1D0Ev)() __attribute__((weak));
extern void _ZN8S20570C42v4Ev();
extern void _ZN8S20570C32v5Ev();
extern void _ZN8S20570C32v6Ev();
extern void ABISELECT(_ZTv0_n32_N8S20570C1D1Ev,_ZTv0_n16_N8S20570C1D1Ev)();
extern void ABISELECT(_ZThn16688_N8S20570C1D1Ev,_ZThn12188_N8S20570C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20570C1D0Ev,_ZTv0_n16_N8S20570C1D0Ev)();
extern void ABISELECT(_ZThn16688_N8S20570C1D0Ev,_ZThn12188_N8S20570C1D0Ev)() __attribute__((weak));
extern void _ZN9S20570C102v8Ev();
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
static  VTBL_ENTRY vtc_S20570C1[] = {
  ABISELECT(16688,12188),
  ABISELECT(16288,11908),
  ABISELECT(15760,11532),
  ABISELECT(15736,11520),
  ABISELECT(16064,11740),
  0,
  (VTBL_ENTRY)&(_ZTI8S20570C1[0]),
  (VTBL_ENTRY)&_ZN8S20570C1D1Ev,
  (VTBL_ENTRY)&_ZN8S20570C1D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20570C93v12Ev,
  (VTBL_ENTRY)&_ZN8S20570C12v1Ev,
  (VTBL_ENTRY)&_ZN8S20570C12v2Ev,
  (VTBL_ENTRY)&_ZN8S20570C12v3Ev,
  ABISELECT(-1408,-1044),
  (VTBL_ENTRY)&(_ZTI8S20570C1[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
  ABISELECT(14208,10384),
  ABISELECT(-1856,-1356),
  (VTBL_ENTRY)&(_ZTI8S20570C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1856_N8S20570C1D1Ev,_ZThn1356_N8S20570C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1856_N8S20570C1D0Ev,_ZThn1356_N8S20570C1D0Ev),
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
  0,
  ABISELECT(-15736,-11520),
  ABISELECT(328,220),
  ABISELECT(24,12),
  ABISELECT(-15736,-11520),
  (VTBL_ENTRY)&(_ZTI8S20570C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20570C1D1Ev,_ZTv0_n20_N8S20570C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20570C1D0Ev,_ZTv0_n20_N8S20570C1D0Ev),
  (VTBL_ENTRY)&_ZN8S20570C22v7Ev,
  0,
  0,
  0,
  ABISELECT(-15760,-11532),
  ABISELECT(304,208),
  ABISELECT(-15760,-11532),
  (VTBL_ENTRY)&(_ZTI8S20570C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20570C1D1Ev,_ZTv0_n16_N8S20570C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20570C1D0Ev,_ZTv0_n16_N8S20570C1D0Ev),
  (VTBL_ENTRY)&_ZN8S20570C42v4Ev,
  (VTBL_ENTRY)&_ZN8S20570C32v5Ev,
  (VTBL_ENTRY)&_ZN8S20570C32v6Ev,
  ABISELECT(-224,-168),
  ABISELECT(-16288,-11908),
  (VTBL_ENTRY)&(_ZTI8S20570C1[0]),
  ABISELECT(1184,876),
  ABISELECT(1184,876),
  ABISELECT(1184,876),
  0,
  ABISELECT(-16688,-12188),
  ABISELECT(-624,-448),
  ABISELECT(-16688,-12188),
  (VTBL_ENTRY)&(_ZTI8S20570C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20570C1D1Ev,_ZTv0_n16_N8S20570C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20570C1D0Ev,_ZTv0_n16_N8S20570C1D0Ev),
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
  ABISELECT(-1808,-1324),
  ABISELECT(-17872,-13064),
  (VTBL_ENTRY)&(_ZTI8S20570C1[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
};
extern VTBL_ENTRY _ZTV8S20570C1[];
extern void _ZN8S20570C8D1Ev();
extern void _ZN8S20570C8D0Ev();
extern void _ZN9S20570C102v8Ev();
extern void _ZN8S20570C93v12Ev();
static  VTBL_ENTRY _tg__ZTV8S20570C8__8S20570C1[] = {
  ABISELECT(16064,11740),
  0,
  (VTBL_ENTRY)&(_ZTI8S20570C8[0]),
  (VTBL_ENTRY)&_ZN8S20570C8D1Ev,
  (VTBL_ENTRY)&_ZN8S20570C8D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20570C93v12Ev,
};
extern void _ZN8S20570C9D1Ev();
extern void _ZN8S20570C9D0Ev();
extern void _ZN9S20570C102v8Ev();
extern void _ZN8S20570C93v12Ev();
static  VTBL_ENTRY _tg__ZTV8S20570C98S20570C8__8S20570C1[] = {
  ABISELECT(16064,11740),
  0,
  (VTBL_ENTRY)&(_ZTI8S20570C9[0]),
  (VTBL_ENTRY)&_ZN8S20570C9D1Ev,
  (VTBL_ENTRY)&_ZN8S20570C9D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20570C93v12Ev,
};
extern void _ZN9S20570C10D1Ev();
extern void _ZN9S20570C10D0Ev();
extern void _ZN9S20570C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C108S20570C98S20570C8__8S20570C1[] = {
  ABISELECT(16064,11740),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C10[0]),
  (VTBL_ENTRY)&_ZN9S20570C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20570C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
};
extern void _ZN9S20570C10D1Ev();
extern void _ZN9S20570C10D0Ev();
extern void _ZN9S20570C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C108S20570C8__A1__8S20570C1[] = {
  ABISELECT(14208,10384),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C10[0]),
  (VTBL_ENTRY)&_ZN9S20570C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20570C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
};
extern void ABISELECT(_ZThn1856_N8S20570C8D1Ev,_ZThn1356_N8S20570C8D1Ev)();
extern void ABISELECT(_ZThn1856_N8S20570C8D0Ev,_ZThn1356_N8S20570C8D0Ev)();
extern void _ZN9S20570C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C10__A1__8S20570C8__8S20570C1[] = {
  ABISELECT(14208,10384),
  ABISELECT(-1856,-1356),
  (VTBL_ENTRY)&(_ZTI8S20570C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1856_N8S20570C8D1Ev,_ZThn1356_N8S20570C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1856_N8S20570C8D0Ev,_ZThn1356_N8S20570C8D0Ev),
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
};
extern void _ZN8S20570C2D1Ev();
extern void _ZN8S20570C2D0Ev();
extern void _ZN8S20570C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20570C2__8S20570C1[] = {
  ABISELECT(328,220),
  ABISELECT(24,12),
  0,
  (VTBL_ENTRY)&(_ZTI8S20570C2[0]),
  (VTBL_ENTRY)&_ZN8S20570C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20570C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20570C22v7Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S20570C2D1Ev,_ZTv0_n16_N8S20570C2D1Ev)();
extern void ABISELECT(_ZThn24_N8S20570C2D1Ev,_ZThn12_N8S20570C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20570C2D0Ev,_ZTv0_n16_N8S20570C2D0Ev)();
extern void ABISELECT(_ZThn24_N8S20570C2D0Ev,_ZThn12_N8S20570C2D0Ev)() __attribute__((weak));
extern void _ZN8S20570C42v4Ev();
extern void _ZN8S20570C32v5Ev();
extern void _ZN8S20570C32v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20570C3__8S20570C2__8S20570C1[] = {
  0,
  0,
  0,
  ABISELECT(-24,-12),
  ABISELECT(304,208),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S20570C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20570C2D1Ev,_ZTv0_n16_N8S20570C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20570C2D0Ev,_ZTv0_n16_N8S20570C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20570C42v4Ev,
  (VTBL_ENTRY)&_ZN8S20570C32v5Ev,
  (VTBL_ENTRY)&_ZN8S20570C32v6Ev,
};
extern void _ZN8S20570C3D1Ev();
extern void _ZN8S20570C3D0Ev();
extern void _ZN8S20570C42v4Ev();
extern void _ZN8S20570C32v5Ev();
extern void _ZN8S20570C32v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20570C3__8S20570C1[] = {
  ABISELECT(304,208),
  0,
  (VTBL_ENTRY)&(_ZTI8S20570C3[0]),
  (VTBL_ENTRY)&_ZN8S20570C3D1Ev,
  (VTBL_ENTRY)&_ZN8S20570C3D0Ev,
  (VTBL_ENTRY)&_ZN8S20570C42v4Ev,
  (VTBL_ENTRY)&_ZN8S20570C32v5Ev,
  (VTBL_ENTRY)&_ZN8S20570C32v6Ev,
};
extern void _ZN8S20570C4D1Ev();
extern void _ZN8S20570C4D0Ev();
extern void _ZN8S20570C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20570C48S20570C3__8S20570C1[] = {
  ABISELECT(304,208),
  0,
  (VTBL_ENTRY)&(_ZTI8S20570C4[0]),
  (VTBL_ENTRY)&_ZN8S20570C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20570C4D0Ev,
  (VTBL_ENTRY)&_ZN8S20570C42v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20570C6__8S20570C1[] = {
  ABISELECT(-224,-168),
  0,
  (VTBL_ENTRY)&(_ZTI8S20570C6[0]),
};
extern void _ZN9S20570C11D1Ev();
extern void _ZN9S20570C11D0Ev();
extern void _ZN9S20570C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C11__8S20570C1[] = {
  ABISELECT(-624,-448),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C11[0]),
  (VTBL_ENTRY)&_ZN9S20570C11D1Ev,
  (VTBL_ENTRY)&_ZN9S20570C11D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
};
extern void _ZN9S20570C10D1Ev();
extern void _ZN9S20570C10D0Ev();
extern void _ZN9S20570C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C109S20570C11__A2__8S20570C1[] = {
  ABISELECT(-624,-448),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C10[0]),
  (VTBL_ENTRY)&_ZN9S20570C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20570C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20570C102v8Ev,
};
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C129S20570C11__8S20570C1[] = {
  ABISELECT(-1808,-1324),
  0,
  (VTBL_ENTRY)&(_ZTI9S20570C12[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
};
extern void _ZN8S20570C72v9Ev();
extern void _ZN8S20570C73v10Ev();
extern void _ZN8S20570C73v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20570C12__9S20570C11__8S20570C1[] = {
  ABISELECT(-1808,-1324),
  ABISELECT(-1184,-876),
  (VTBL_ENTRY)&(_ZTI9S20570C11[0]),
  (VTBL_ENTRY)&_ZN8S20570C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20570C73v11Ev,
};
static  VTT_ENTRY vtt_S20570C1[] = {
  {&(_ZTV8S20570C1[7]),  7,66},
  {&(_tg__ZTV8S20570C8__8S20570C1[3]),  3,7},
  {&(_tg__ZTV8S20570C98S20570C8__8S20570C1[3]),  3,7},
  {&(_tg__ZTV9S20570C108S20570C98S20570C8__8S20570C1[3]),  3,6},
  {&(_tg__ZTV9S20570C108S20570C8__A1__8S20570C1[3]),  3,6},
  {&(_tg__ZTV9S20570C10__A1__8S20570C8__8S20570C1[3]),  3,6},
  {&(_ZTV8S20570C1[31]),  31,66},
  {&(_ZTV8S20570C1[41]),  41,66},
  {&(_ZTV8S20570C1[49]),  49,66},
  {&(_ZTV8S20570C1[22]),  22,66},
  {&(_ZTV8S20570C1[57]),  57,66},
  {&(_ZTV8S20570C1[63]),  63,66},
  {&(_tg__ZTV8S20570C2__8S20570C1[4]),  4,7},
  {&(_tg__ZTV8S20570C3__8S20570C2__8S20570C1[7]),  7,12},
  {&(_tg__ZTV8S20570C3__8S20570C1[3]),  3,8},
  {&(_tg__ZTV8S20570C48S20570C3__8S20570C1[3]),  3,6},
  {&(_tg__ZTV8S20570C6__8S20570C1[3]),  3,3},
  {&(_tg__ZTV9S20570C11__8S20570C1[3]),  3,6},
  {&(_tg__ZTV9S20570C109S20570C11__A2__8S20570C1[3]),  3,6},
  {&(_tg__ZTV9S20570C129S20570C11__8S20570C1[3]),  3,6},
  {&(_tg__ZTV9S20570C12__9S20570C11__8S20570C1[3]),  3,6},
};
extern VTBL_ENTRY _ZTI8S20570C1[];
extern  VTBL_ENTRY _ZTV8S20570C1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20570C1[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S20570C2D0Ev,_ZTv0_n16_N8S20570C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S20570C2D0Ev,_ZThn12_N8S20570C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S20570C2D1Ev,_ZTv0_n16_N8S20570C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S20570C2D1Ev,_ZThn12_N8S20570C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S20570C1D0Ev,_ZTv0_n16_N8S20570C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16688_N8S20570C1D0Ev,_ZThn12188_N8S20570C1D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn15760_N8S20570C1D0Ev,_ZThn11532_N8S20570C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S20570C1D1Ev,_ZTv0_n16_N8S20570C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16688_N8S20570C1D1Ev,_ZThn12188_N8S20570C1D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn15760_N8S20570C1D1Ev,_ZThn11532_N8S20570C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S20570C1D0Ev,_ZTv0_n20_N8S20570C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15736_N8S20570C1D0Ev,_ZThn11520_N8S20570C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S20570C1D1Ev,_ZTv0_n20_N8S20570C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15736_N8S20570C1D1Ev,_ZThn11520_N8S20570C1D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20570C1 = {  "S20570C1", // class name
  bases_S20570C1, 18,
  &(vtc_S20570C1[0]), // expected_vtbl_contents
  &(vtt_S20570C1[0]), // expected_vtt_contents
  ABISELECT(20272,14816), // object size
  NSPAIRA(_ZTI8S20570C1),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S20570C1),66, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20570C1),21, //virtual table table var
  13, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7388C2  : virtual S20570C5 {
  long s7388c2f0[3];
  __tsi64 s7388c2f1;
  short s7388c2f2;
  int s7388c2f3;
  __tsi64 s7388c2f4;
  int s7388c2f5;
  virtual  ~S7388C2(); // _ZN7S7388C2D2Ev
  virtual void  v1(); // _ZN7S7388C22v1Ev
  S7388C2(); // tgen
};
//SIG(-1 S7388C2) C1{ VBC2{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} vd v1 Fl[3] FL Fs Fi FL Fi}


 S7388C2 ::~S7388C2(){ note_dtor("S7388C2", this);}
void  S7388C2 ::v1(){vfunc_called(this, "_ZN7S7388C22v1Ev");}
S7388C2 ::S7388C2(){ note_ctor("S7388C2", this);} // tgen

static void Test_S7388C2()
{
  extern Class_Descriptor cd_S7388C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(19,54)];
    init_test(&cd_S7388C2, buf);
    S7388C2 *dp, &lv = *(dp=new (buf) S7388C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(288,212), "sizeof(S7388C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7388C2)");
    check_base_class_offset(lv, (S20570C5*), ABISELECT(64,44), "S7388C2");
    check_field_offset(lv, s7388c2f0, ABISELECT(8,4), "S7388C2.s7388c2f0");
    check_field_offset(lv, s7388c2f1, ABISELECT(32,16), "S7388C2.s7388c2f1");
    check_field_offset(lv, s7388c2f2, ABISELECT(40,24), "S7388C2.s7388c2f2");
    check_field_offset(lv, s7388c2f3, ABISELECT(44,28), "S7388C2.s7388c2f3");
    check_field_offset(lv, s7388c2f4, ABISELECT(48,32), "S7388C2.s7388c2f4");
    check_field_offset(lv, s7388c2f5, ABISELECT(56,40), "S7388C2.s7388c2f5");
    test_class_info(&lv, &cd_S7388C2);
    dp->~S7388C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7388C2(Test_S7388C2, "S7388C2", ABISELECT(288,212));

#else // __cplusplus

extern void _ZN7S7388C2C1Ev();
extern void _ZN7S7388C2D2Ev();
Name_Map name_map_S7388C2[] = {
  NSPAIR(_ZN7S7388C2C1Ev),
  NSPAIR(_ZN7S7388C2D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
static Base_Class bases_S7388C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S7388C2[];
extern void _ZN7S7388C2D1Ev();
extern void _ZN7S7388C2D0Ev();
extern void _ZN7S7388C22v1Ev();
static  VTBL_ENTRY vtc_S7388C2[] = {
  ABISELECT(64,44),
  0,
  (VTBL_ENTRY)&(_ZTI7S7388C2[0]),
  (VTBL_ENTRY)&_ZN7S7388C2D1Ev,
  (VTBL_ENTRY)&_ZN7S7388C2D0Ev,
  (VTBL_ENTRY)&_ZN7S7388C22v1Ev,
};
extern VTBL_ENTRY _ZTV7S7388C2[];
static  VTT_ENTRY vtt_S7388C2[] = {
  {&(_ZTV7S7388C2[3]),  3,6},
};
extern VTBL_ENTRY _ZTI7S7388C2[];
extern  VTBL_ENTRY _ZTV7S7388C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7388C2[];
Class_Descriptor cd_S7388C2 = {  "S7388C2", // class name
  bases_S7388C2, 1,
  &(vtc_S7388C2[0]), // expected_vtbl_contents
  &(vtt_S7388C2[0]), // expected_vtt_contents
  ABISELECT(288,212), // object size
  NSPAIRA(_ZTI7S7388C2),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7S7388C2),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7388C2),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7388C6  : S20570C5 {
  long double s7388c6f0;
  short s7388c6f1:16;
  int s7388c6f2[7];
  long double s7388c6f3;
  char s7388c6f4:6;
  __tsi64 s7388c6f5:64;
  __tsi64 s7388c6f6[2];
  int s7388c6f7;
  virtual void  v2(); // _ZN7S7388C62v2Ev
  virtual void  v3(); // _ZN7S7388C62v3Ev
  virtual void  v4(); // _ZN7S7388C62v4Ev
  ~S7388C6(); // tgen
  S7388C6(); // tgen
};
//SIG(-1 S7388C6) C1{ BC2{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} v1 v2 v3 FD Fs:16 Fi[7] FD Fc:6 FL:64 FL[2] Fi}


void  S7388C6 ::v2(){vfunc_called(this, "_ZN7S7388C62v2Ev");}
void  S7388C6 ::v3(){vfunc_called(this, "_ZN7S7388C62v3Ev");}
void  S7388C6 ::v4(){vfunc_called(this, "_ZN7S7388C62v4Ev");}
S7388C6 ::~S7388C6(){ note_dtor("S7388C6", this);} // tgen
S7388C6 ::S7388C6(){ note_ctor("S7388C6", this);} // tgen

static void Test_S7388C6()
{
  extern Class_Descriptor cd_S7388C6;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(23,66)];
    init_test(&cd_S7388C6, buf);
    S7388C6 *dp, &lv = *(dp=new (buf) S7388C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(352,260), "sizeof(S7388C6)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7388C6)");
    check_base_class_offset(lv, (S20570C5*), ABISELECT(16,4), "S7388C6");
    check_field_offset(lv, s7388c6f0, ABISELECT(240,172), "S7388C6.s7388c6f0");
    set_bf_and_test(lv, s7388c6f1, ABISELECT(256,184), 0, 16, 1, "S7388C6");
    set_bf_and_test(lv, s7388c6f1, ABISELECT(256,184), 0, 16, hide_sll(1LL<<15), "S7388C6");
    check_field_offset(lv, s7388c6f2, ABISELECT(260,188), "S7388C6.s7388c6f2");
    check_field_offset(lv, s7388c6f3, ABISELECT(288,216), "S7388C6.s7388c6f3");
    set_bf_and_test(lv, s7388c6f4, ABISELECT(304,228), 0, 6, 1, "S7388C6");
    set_bf_and_test(lv, s7388c6f4, ABISELECT(304,228), 0, 6, hide_sll(1LL<<5), "S7388C6");
    set_bf_and_test(lv, s7388c6f5, ABISELECT(312,232), 0, 64, 1, "S7388C6");
    set_bf_and_test(lv, s7388c6f5, ABISELECT(312,232), 0, 64, hide_sll(1LL<<63), "S7388C6");
    check_field_offset(lv, s7388c6f6, ABISELECT(320,240), "S7388C6.s7388c6f6");
    check_field_offset(lv, s7388c6f7, ABISELECT(336,256), "S7388C6.s7388c6f7");
    test_class_info(&lv, &cd_S7388C6);
    dp->~S7388C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7388C6(Test_S7388C6, "S7388C6", ABISELECT(352,260));

#else // __cplusplus

extern void _ZN7S7388C6C1Ev();
extern void _ZN7S7388C6D1Ev();
Name_Map name_map_S7388C6[] = {
  NSPAIR(_ZN7S7388C6C1Ev),
  NSPAIR(_ZN7S7388C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
static Base_Class bases_S7388C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S7388C6[];
extern void _ZN7S7388C62v2Ev();
extern void _ZN7S7388C62v3Ev();
extern void _ZN7S7388C62v4Ev();
static  VTBL_ENTRY vtc_S7388C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S7388C6[0]),
  (VTBL_ENTRY)&_ZN7S7388C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v3Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v4Ev,
};
extern VTBL_ENTRY _ZTI7S7388C6[];
extern  VTBL_ENTRY _ZTV7S7388C6[];
Class_Descriptor cd_S7388C6 = {  "S7388C6", // class name
  bases_S7388C6, 1,
  &(vtc_S7388C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(352,260), // object size
  NSPAIRA(_ZTI7S7388C6),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7S7388C6),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S7388C7  {
  long double s7388c7f0;
  void *s7388c7f1;
  short s7388c7f2:5;
  void *s7388c7f3;
  long double s7388c7f4;
  void *s7388c7f5;
  long double s7388c7f6;
  int s7388c7f7[7];
  void *s7388c7f8;
  void *s7388c7f9;
  void  mf7388c7(); // _ZN7S7388C78mf7388c7Ev
};
//SIG(1 S7388C7) U1{ m FD Fp Fs:5 Fp FD Fp FD Fi[7] Fp Fp}

#endif // __cplusplus
#ifdef __cplusplus

union  S7388C8  {
  long double s7388c8f0[10];
  short s7388c8f1;
  short s7388c8f2;
  void *s7388c8f3;
  long s7388c8f4;
  void *s7388c8f5;
  long double s7388c8f6[9];
  void  mf7388c8(); // _ZN7S7388C88mf7388c8Ev
};
//SIG(1 S7388C8) U1{ m FD[10] Fs Fs Fp Fl Fp FD[9]}

#endif // __cplusplus
#ifdef __cplusplus

struct  S7388C5  : virtual S7388C6 {
  ::S7388C7 s7388c5f0[5];
  char s7388c5f1[3];
  void *s7388c5f2;
  void *s7388c5f3;
  short s7388c5f4[4];
  int s7388c5f5[6];
  ::S7388C2 s7388c5f6;
  int s7388c5f7;
  void *s7388c5f8[8];
  int s7388c5f9;
  ::S7388C8 s7388c5f10;
  char s7388c5f11;
  int s7388c5f12;
  int s7388c5f13[7];
  ~S7388C5(); // tgen
  S7388C5(); // tgen
};
//SIG(-1 S7388C5) C1{ VBC2{ BC3{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} v1 v2 v3 FD Fs:16 Fi[7] FD Fc:6 FL:64 FL[2] Fi} FU4{ m FD Fp Fs:5 Fp FD Fp FD Fi[7] Fp Fp}[5] Fc[3] Fp Fp Fs[4] Fi[6] FC5{ VBC3 vd v4 Fl[3] FL Fs Fi FL Fi} Fi Fp[8] Fi FU6{ m FD[10] Fs Fs Fp Fl Fp FD[9]} Fc Fi Fi[7]}


S7388C5 ::~S7388C5(){ note_dtor("S7388C5", this);} // tgen
S7388C5 ::S7388C5(){ note_ctor("S7388C5", this);} // tgen

static void Test_S7388C5()
{
  extern Class_Descriptor cd_S7388C5;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(74,215)];
    init_test(&cd_S7388C5, buf);
    S7388C5 *dp, &lv = *(dp=new (buf) S7388C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1168,856), "sizeof(S7388C5)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7388C5)");
    check_base_class_offset(lv, (S20570C5*)(S7388C6*), ABISELECT(832,600), "S7388C5");
    check_base_class_offset(lv, (S7388C6*), ABISELECT(816,596), "S7388C5");
    check_field_offset(lv, s7388c5f0, ABISELECT(16,4), "S7388C5.s7388c5f0");
    check_field_offset(lv, s7388c5f1, ABISELECT(176,144), "S7388C5.s7388c5f1");
    check_field_offset(lv, s7388c5f2, ABISELECT(184,148), "S7388C5.s7388c5f2");
    check_field_offset(lv, s7388c5f3, ABISELECT(192,152), "S7388C5.s7388c5f3");
    check_field_offset(lv, s7388c5f4, ABISELECT(200,156), "S7388C5.s7388c5f4");
    check_field_offset(lv, s7388c5f5, ABISELECT(208,164), "S7388C5.s7388c5f5");
    check_field_offset(lv, s7388c5f6, ABISELECT(240,188), "S7388C5.s7388c5f6");
    check_field_offset(lv, s7388c5f7, ABISELECT(528,400), "S7388C5.s7388c5f7");
    check_field_offset(lv, s7388c5f8, ABISELECT(536,404), "S7388C5.s7388c5f8");
    check_field_offset(lv, s7388c5f9, ABISELECT(600,436), "S7388C5.s7388c5f9");
    check_field_offset(lv, s7388c5f10, ABISELECT(608,440), "S7388C5.s7388c5f10");
    check_field_offset(lv, s7388c5f11, ABISELECT(768,560), "S7388C5.s7388c5f11");
    check_field_offset(lv, s7388c5f12, ABISELECT(772,564), "S7388C5.s7388c5f12");
    check_field_offset(lv, s7388c5f13, ABISELECT(776,568), "S7388C5.s7388c5f13");
    test_class_info(&lv, &cd_S7388C5);
    dp->~S7388C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7388C5(Test_S7388C5, "S7388C5", ABISELECT(1168,856));

#else // __cplusplus

extern void _ZN7S7388C5C1Ev();
extern void _ZN7S7388C5D1Ev();
Name_Map name_map_S7388C5[] = {
  NSPAIR(_ZN7S7388C5C1Ev),
  NSPAIR(_ZN7S7388C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S7388C6;
extern VTBL_ENTRY _ZTI7S7388C6[];
extern  VTBL_ENTRY _ZTV7S7388C6[];
static Base_Class bases_S7388C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(832,600), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S7388C6,    ABISELECT(816,596), //bcp->offset
    3, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S7388C5[];
extern void _ZN7S7388C62v2Ev();
extern void _ZN7S7388C62v3Ev();
extern void _ZN7S7388C62v4Ev();
static  VTBL_ENTRY vtc_S7388C5[] = {
  ABISELECT(816,596),
  0,
  (VTBL_ENTRY)&(_ZTI7S7388C5[0]),
  0,
  0,
  0,
  ABISELECT(-816,-596),
  (VTBL_ENTRY)&(_ZTI7S7388C5[0]),
  (VTBL_ENTRY)&_ZN7S7388C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v3Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v4Ev,
};
extern VTBL_ENTRY _ZTV7S7388C5[];
static  VTT_ENTRY vtt_S7388C5[] = {
  {&(_ZTV7S7388C5[3]),  3,11},
  {&(_ZTV7S7388C5[8]),  8,11},
};
extern VTBL_ENTRY _ZTI7S7388C5[];
extern  VTBL_ENTRY _ZTV7S7388C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7388C5[];
Class_Descriptor cd_S7388C5 = {  "S7388C5", // class name
  bases_S7388C5, 2,
  &(vtc_S7388C5[0]), // expected_vtbl_contents
  &(vtt_S7388C5[0]), // expected_vtt_contents
  ABISELECT(1168,856), // object size
  NSPAIRA(_ZTI7S7388C5),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7S7388C5),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7388C5),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7388C13  : virtual S20570C5 {
  ::S20570C5 s7388c13f0[5];
  __tsi64 s7388c13f1;
  short s7388c13f2:5;
  char  :0;
  void *s7388c13f4;
  void *s7388c13f5;
  int s7388c13f6;
  __tsi64 s7388c13f7;
  virtual  ~S7388C13(); // _ZN8S7388C13D2Ev
  virtual void  v5(); // _ZN8S7388C132v5Ev
  S7388C13(); // tgen
};
//SIG(-1 S7388C13) C1{ VBC2{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} vd v1 FC2[5] FL Fs:5 Fc:0 Fp[2] Fi FL}


 S7388C13 ::~S7388C13(){ note_dtor("S7388C13", this);}
void  S7388C13 ::v5(){vfunc_called(this, "_ZN8S7388C132v5Ev");}
S7388C13 ::S7388C13(){ note_ctor("S7388C13", this);} // tgen

static void Test_S7388C13()
{
  extern Class_Descriptor cd_S7388C13;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(89,262)];
    init_test(&cd_S7388C13, buf);
    S7388C13 *dp, &lv = *(dp=new (buf) S7388C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1408,1044), "sizeof(S7388C13)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7388C13)");
    check_base_class_offset(lv, (S20570C5*), ABISELECT(1184,876), "S7388C13");
    check_field_offset(lv, s7388c13f0, ABISELECT(16,4), "S7388C13.s7388c13f0");
    check_field_offset(lv, s7388c13f1, ABISELECT(1136,844), "S7388C13.s7388c13f1");
    set_bf_and_test(lv, s7388c13f2, ABISELECT(1144,852), 0, 5, 1, "S7388C13");
    set_bf_and_test(lv, s7388c13f2, ABISELECT(1144,852), 0, 5, hide_sll(1LL<<4), "S7388C13");
    check_field_offset(lv, s7388c13f4, ABISELECT(1152,856), "S7388C13.s7388c13f4");
    check_field_offset(lv, s7388c13f5, ABISELECT(1160,860), "S7388C13.s7388c13f5");
    check_field_offset(lv, s7388c13f6, ABISELECT(1168,864), "S7388C13.s7388c13f6");
    check_field_offset(lv, s7388c13f7, ABISELECT(1176,868), "S7388C13.s7388c13f7");
    test_class_info(&lv, &cd_S7388C13);
    dp->~S7388C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7388C13(Test_S7388C13, "S7388C13", ABISELECT(1408,1044));

#else // __cplusplus

extern void _ZN8S7388C13C1Ev();
extern void _ZN8S7388C13D2Ev();
Name_Map name_map_S7388C13[] = {
  NSPAIR(_ZN8S7388C13C1Ev),
  NSPAIR(_ZN8S7388C13D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
static Base_Class bases_S7388C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(1184,876), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7388C13[];
extern void _ZN8S7388C13D1Ev();
extern void _ZN8S7388C13D0Ev();
extern void _ZN8S7388C132v5Ev();
static  VTBL_ENTRY vtc_S7388C13[] = {
  ABISELECT(1184,876),
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C13[0]),
  (VTBL_ENTRY)&_ZN8S7388C13D1Ev,
  (VTBL_ENTRY)&_ZN8S7388C13D0Ev,
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
};
extern VTBL_ENTRY _ZTV8S7388C13[];
static  VTT_ENTRY vtt_S7388C13[] = {
  {&(_ZTV8S7388C13[3]),  3,6},
};
extern VTBL_ENTRY _ZTI8S7388C13[];
extern  VTBL_ENTRY _ZTV8S7388C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7388C13[];
Class_Descriptor cd_S7388C13 = {  "S7388C13", // class name
  bases_S7388C13, 1,
  &(vtc_S7388C13[0]), // expected_vtbl_contents
  &(vtt_S7388C13[0]), // expected_vtt_contents
  ABISELECT(1408,1044), // object size
  NSPAIRA(_ZTI8S7388C13),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S7388C13),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7388C13),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7388C12  : S7388C13 , S20570C5 , S7388C6 {
  long double s7388c12f0;
  void *s7388c12f1;
  short s7388c12f2[6];
  void *s7388c12f3;
  int s7388c12f4;
  long double s7388c12f5;
  int s7388c12f6;
  virtual void  v6(); // _ZN8S7388C122v6Ev
  ~S7388C12(); // tgen
  S7388C12(); // tgen
};
//SIG(-1 S7388C12) C1{ BC2{ VBC3{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} vd v2 FC3[5] FL Fs:5 Fc:0 Fp[2] Fi FL} BC3 BC4{ BC3 v3 v4 v5 FD Fs:16 Fi[7] FD Fc:6 FL:64 FL[2] Fi} v1 FD Fp Fs[6] Fp Fi FD Fi}


void  S7388C12 ::v6(){vfunc_called(this, "_ZN8S7388C122v6Ev");}
S7388C12 ::~S7388C12(){ note_dtor("S7388C12", this);} // tgen
S7388C12 ::S7388C12(){ note_ctor("S7388C12", this);} // tgen

static void Test_S7388C12()
{
  extern Class_Descriptor cd_S7388C12;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(131,382)];
    init_test(&cd_S7388C12, buf);
    S7388C12 *dp, &lv = *(dp=new (buf) S7388C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2080,1524), "sizeof(S7388C12)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7388C12)");
    check_base_class_offset(lv, (S20570C5*)(S7388C13*), ABISELECT(1856,1356), "S7388C12");
    check_base_class_offset(lv, (S7388C13*), 0, "S7388C12");
    /*is_ambiguous_... S7388C12::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*), ABISELECT(1184,876), "S7388C12");
    check_base_class_offset(lv, (S20570C5*)(S7388C6*), ABISELECT(1424,1048), "S7388C12");
    check_base_class_offset(lv, (S7388C6*), ABISELECT(1408,1044), "S7388C12");
    check_field_offset(lv, s7388c12f0, ABISELECT(1760,1304), "S7388C12.s7388c12f0");
    check_field_offset(lv, s7388c12f1, ABISELECT(1776,1316), "S7388C12.s7388c12f1");
    check_field_offset(lv, s7388c12f2, ABISELECT(1784,1320), "S7388C12.s7388c12f2");
    check_field_offset(lv, s7388c12f3, ABISELECT(1800,1332), "S7388C12.s7388c12f3");
    check_field_offset(lv, s7388c12f4, ABISELECT(1808,1336), "S7388C12.s7388c12f4");
    check_field_offset(lv, s7388c12f5, ABISELECT(1824,1340), "S7388C12.s7388c12f5");
    check_field_offset(lv, s7388c12f6, ABISELECT(1840,1352), "S7388C12.s7388c12f6");
    test_class_info(&lv, &cd_S7388C12);
    dp->~S7388C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7388C12(Test_S7388C12, "S7388C12", ABISELECT(2080,1524));

#else // __cplusplus

extern void _ZN8S7388C12C1Ev();
extern void _ZN8S7388C12D1Ev();
Name_Map name_map_S7388C12[] = {
  NSPAIR(_ZN8S7388C12C1Ev),
  NSPAIR(_ZN8S7388C12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S7388C13;
extern VTBL_ENTRY _ZTI8S7388C13[];
extern  VTBL_ENTRY _ZTV8S7388C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7388C13[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S7388C6;
extern VTBL_ENTRY _ZTI7S7388C6[];
extern  VTBL_ENTRY _ZTV7S7388C6[];
static Base_Class bases_S7388C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(1856,1356), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S7388C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20570C5,    ABISELECT(1184,876), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20570C5,    ABISELECT(1424,1048), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7388C6,    ABISELECT(1408,1044), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7388C12[];
extern void _ZN8S7388C12D1Ev();
extern void _ZN8S7388C12D0Ev();
extern void _ZN8S7388C132v5Ev();
extern void _ZN8S7388C122v6Ev();
extern void _ZN7S7388C62v2Ev();
extern void _ZN7S7388C62v3Ev();
extern void _ZN7S7388C62v4Ev();
static  VTBL_ENTRY vtc_S7388C12[] = {
  ABISELECT(1856,1356),
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C12[0]),
  (VTBL_ENTRY)&_ZN8S7388C12D1Ev,
  (VTBL_ENTRY)&_ZN8S7388C12D0Ev,
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
  (VTBL_ENTRY)&_ZN8S7388C122v6Ev,
  ABISELECT(-1408,-1044),
  (VTBL_ENTRY)&(_ZTI8S7388C12[0]),
  (VTBL_ENTRY)&_ZN7S7388C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v3Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v4Ev,
};
extern VTBL_ENTRY _ZTV8S7388C12[];
extern void _ZN8S7388C13D1Ev();
extern void _ZN8S7388C13D0Ev();
extern void _ZN8S7388C132v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C13__8S7388C12[] = {
  ABISELECT(1856,1356),
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C13[0]),
  (VTBL_ENTRY)&_ZN8S7388C13D1Ev,
  (VTBL_ENTRY)&_ZN8S7388C13D0Ev,
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
};
static  VTT_ENTRY vtt_S7388C12[] = {
  {&(_ZTV8S7388C12[3]),  3,12},
  {&(_tg__ZTV8S7388C13__8S7388C12[3]),  3,6},
};
extern VTBL_ENTRY _ZTI8S7388C12[];
extern  VTBL_ENTRY _ZTV8S7388C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7388C12[];
Class_Descriptor cd_S7388C12 = {  "S7388C12", // class name
  bases_S7388C12, 5,
  &(vtc_S7388C12[0]), // expected_vtbl_contents
  &(vtt_S7388C12[0]), // expected_vtt_contents
  ABISELECT(2080,1524), // object size
  NSPAIRA(_ZTI8S7388C12),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S7388C12),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7388C12),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7388C11  : virtual S20570C5 , S7388C12 , S7388C13 {
  long double s7388c11f0[9];
  short s7388c11f1;
  virtual  ~S7388C11(); // _ZN8S7388C11D2Ev
  S7388C11(); // tgen
};
//SIG(-1 S7388C11) C1{ VBC2{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} BC3{ BC4{ VBC2 vd v1 FC2[5] FL Fs:5 Fc:0 Fp[2] Fi FL} BC2 BC5{ BC2 v2 v3 v4 FD Fs:16 Fi[7] FD Fc:6 FL:64 FL[2] Fi} v5 FD Fp Fs[6] Fp Fi FD Fi} BC4 vd FD[9] Fs}


 S7388C11 ::~S7388C11(){ note_dtor("S7388C11", this);}
S7388C11 ::S7388C11(){ note_ctor("S7388C11", this);} // tgen

static void Test_S7388C11()
{
  extern Class_Descriptor cd_S7388C11;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(215,629)];
    init_test(&cd_S7388C11, buf);
    S7388C11 *dp, &lv = *(dp=new (buf) S7388C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(3424,2512), "sizeof(S7388C11)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7388C11)");
    /*is_ambiguous_... S7388C11::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*), ABISELECT(3200,2344), "S7388C11");
    check_base_class_offset(lv, (S20570C5*)(S7388C13*)(S7388C12*), ABISELECT(3200,2344), "S7388C11");
    /*is_ambiguous_... S7388C11::S7388C13 */ AMB_check_base_class_offset(lv, (S20570C5*)(S7388C13*), ABISELECT(3200,2344), "S7388C11");
    check_base_class_offset(lv, (S7388C13*)(S7388C12*), 0, "S7388C11");
    /*is_ambiguous_... S7388C12::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S7388C12*), ABISELECT(1184,876), "S7388C11");
    check_base_class_offset(lv, (S20570C5*)(S7388C6*)(S7388C12*), ABISELECT(1424,1048), "S7388C11");
    check_base_class_offset(lv, (S7388C6*)(S7388C12*), ABISELECT(1408,1044), "S7388C11");
    check_base_class_offset(lv, (S7388C12*), 0, "S7388C11");
    /*is_ambiguous_... S7388C11::S7388C13 */ AMB_check_base_class_offset(lv, (S7388C13*), ABISELECT(1856,1356), "S7388C11");
    check_field_offset(lv, s7388c11f0, ABISELECT(3040,2232), "S7388C11.s7388c11f0");
    check_field_offset(lv, s7388c11f1, ABISELECT(3184,2340), "S7388C11.s7388c11f1");
    test_class_info(&lv, &cd_S7388C11);
    dp->~S7388C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7388C11(Test_S7388C11, "S7388C11", ABISELECT(3424,2512));

#else // __cplusplus

extern void _ZN8S7388C11C1Ev();
extern void _ZN8S7388C11D2Ev();
Name_Map name_map_S7388C11[] = {
  NSPAIR(_ZN8S7388C11C1Ev),
  NSPAIR(_ZN8S7388C11D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S7388C13;
extern VTBL_ENTRY _ZTI8S7388C13[];
extern  VTBL_ENTRY _ZTV8S7388C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7388C13[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S7388C6;
extern VTBL_ENTRY _ZTI7S7388C6[];
extern  VTBL_ENTRY _ZTV7S7388C6[];
extern Class_Descriptor cd_S7388C12;
extern VTBL_ENTRY _ZTI8S7388C12[];
extern  VTBL_ENTRY _ZTV8S7388C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7388C12[];
extern Class_Descriptor cd_S7388C13;
extern VTBL_ENTRY _ZTI8S7388C13[];
extern  VTBL_ENTRY _ZTV8S7388C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7388C13[];
static Base_Class bases_S7388C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(3200,2344), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7388C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(1184,876), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(1424,1048), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7388C6,    ABISELECT(1408,1044), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7388C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7388C13,    ABISELECT(1856,1356), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7388C11[];
extern void _ZN8S7388C11D1Ev();
extern void _ZN8S7388C11D0Ev();
extern void _ZN8S7388C132v5Ev();
extern void _ZN8S7388C122v6Ev();
extern void _ZN7S7388C62v2Ev();
extern void _ZN7S7388C62v3Ev();
extern void _ZN7S7388C62v4Ev();
extern void ABISELECT(_ZThn1856_N8S7388C11D1Ev,_ZThn1356_N8S7388C11D1Ev)();
extern void ABISELECT(_ZThn1856_N8S7388C11D0Ev,_ZThn1356_N8S7388C11D0Ev)();
extern void _ZN8S7388C132v5Ev();
static  VTBL_ENTRY vtc_S7388C11[] = {
  ABISELECT(3200,2344),
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C11[0]),
  (VTBL_ENTRY)&_ZN8S7388C11D1Ev,
  (VTBL_ENTRY)&_ZN8S7388C11D0Ev,
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
  (VTBL_ENTRY)&_ZN8S7388C122v6Ev,
  ABISELECT(-1408,-1044),
  (VTBL_ENTRY)&(_ZTI8S7388C11[0]),
  (VTBL_ENTRY)&_ZN7S7388C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v3Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v4Ev,
  ABISELECT(1344,988),
  ABISELECT(-1856,-1356),
  (VTBL_ENTRY)&(_ZTI8S7388C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1856_N8S7388C11D1Ev,_ZThn1356_N8S7388C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1856_N8S7388C11D0Ev,_ZThn1356_N8S7388C11D0Ev),
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
};
extern VTBL_ENTRY _ZTV8S7388C11[];
extern void _ZN8S7388C12D1Ev();
extern void _ZN8S7388C12D0Ev();
extern void _ZN8S7388C132v5Ev();
extern void _ZN8S7388C122v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C12__8S7388C11[] = {
  ABISELECT(3200,2344),
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C12[0]),
  (VTBL_ENTRY)&_ZN8S7388C12D1Ev,
  (VTBL_ENTRY)&_ZN8S7388C12D0Ev,
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
  (VTBL_ENTRY)&_ZN8S7388C122v6Ev,
};
extern void _ZN8S7388C13D1Ev();
extern void _ZN8S7388C13D0Ev();
extern void _ZN8S7388C132v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C138S7388C12__8S7388C11[] = {
  ABISELECT(3200,2344),
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C13[0]),
  (VTBL_ENTRY)&_ZN8S7388C13D1Ev,
  (VTBL_ENTRY)&_ZN8S7388C13D0Ev,
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
};
extern void _ZN8S7388C13D1Ev();
extern void _ZN8S7388C13D0Ev();
extern void _ZN8S7388C132v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C13__A1__8S7388C11[] = {
  ABISELECT(1344,988),
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C13[0]),
  (VTBL_ENTRY)&_ZN8S7388C13D1Ev,
  (VTBL_ENTRY)&_ZN8S7388C13D0Ev,
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
};
static  VTT_ENTRY vtt_S7388C11[] = {
  {&(_ZTV8S7388C11[3]),  3,18},
  {&(_tg__ZTV8S7388C12__8S7388C11[3]),  3,7},
  {&(_tg__ZTV8S7388C138S7388C12__8S7388C11[3]),  3,6},
  {&(_tg__ZTV8S7388C13__A1__8S7388C11[3]),  3,6},
  {&(_ZTV8S7388C11[15]),  15,18},
};
extern VTBL_ENTRY _ZTI8S7388C11[];
extern  VTBL_ENTRY _ZTV8S7388C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7388C11[];
Class_Descriptor cd_S7388C11 = {  "S7388C11", // class name
  bases_S7388C11, 7,
  &(vtc_S7388C11[0]), // expected_vtbl_contents
  &(vtt_S7388C11[0]), // expected_vtt_contents
  ABISELECT(3424,2512), // object size
  NSPAIRA(_ZTI8S7388C11),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S7388C11),18, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7388C11),5, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7388C14  {
  long double s7388c14f0;
  int s7388c14f1;
  int s7388c14f2;
  char s7388c14f3;
  void *s7388c14f4;
  ::S20570C17 s7388c14f5;
  int s7388c14f6;
  void *s7388c14f7;
  int s7388c14f8[2];
  virtual  ~S7388C14(); // _ZN8S7388C14D1Ev
  virtual void  v9(); // _ZN8S7388C142v9Ev
  S7388C14(); // tgen
};
//SIG(-1 S7388C14) C1{ vd v1 FD Fi[2] Fc Fp FC2{ vd m Fp Fl Fi Fp} Fi Fp Fi[2]}


 S7388C14 ::~S7388C14(){ note_dtor("S7388C14", this);}
void  S7388C14 ::v9(){vfunc_called(this, "_ZN8S7388C142v9Ev");}
S7388C14 ::S7388C14(){ note_ctor("S7388C14", this);} // tgen

static void Test_S7388C14()
{
  extern Class_Descriptor cd_S7388C14;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(9,18)];
    init_test(&cd_S7388C14, buf);
    S7388C14 *dp, &lv = *(dp=new (buf) S7388C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,68), "sizeof(S7388C14)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7388C14)");
    check_field_offset(lv, s7388c14f0, ABISELECT(16,4), "S7388C14.s7388c14f0");
    check_field_offset(lv, s7388c14f1, ABISELECT(32,16), "S7388C14.s7388c14f1");
    check_field_offset(lv, s7388c14f2, ABISELECT(36,20), "S7388C14.s7388c14f2");
    check_field_offset(lv, s7388c14f3, ABISELECT(40,24), "S7388C14.s7388c14f3");
    check_field_offset(lv, s7388c14f4, ABISELECT(48,28), "S7388C14.s7388c14f4");
    check_field_offset(lv, s7388c14f5, ABISELECT(56,32), "S7388C14.s7388c14f5");
    check_field_offset(lv, s7388c14f6, ABISELECT(96,52), "S7388C14.s7388c14f6");
    check_field_offset(lv, s7388c14f7, ABISELECT(104,56), "S7388C14.s7388c14f7");
    check_field_offset(lv, s7388c14f8, ABISELECT(112,60), "S7388C14.s7388c14f8");
    test_class_info(&lv, &cd_S7388C14);
    dp->~S7388C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7388C14(Test_S7388C14, "S7388C14", ABISELECT(128,68));

#else // __cplusplus

extern void _ZN8S7388C14C1Ev();
extern void _ZN8S7388C14D1Ev();
Name_Map name_map_S7388C14[] = {
  NSPAIR(_ZN8S7388C14C1Ev),
  NSPAIR(_ZN8S7388C14D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S7388C14[];
extern void _ZN8S7388C14D1Ev();
extern void _ZN8S7388C14D0Ev();
extern void _ZN8S7388C142v9Ev();
static  VTBL_ENTRY vtc_S7388C14[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C14[0]),
  (VTBL_ENTRY)&_ZN8S7388C14D1Ev,
  (VTBL_ENTRY)&_ZN8S7388C14D0Ev,
  (VTBL_ENTRY)&_ZN8S7388C142v9Ev,
};
extern VTBL_ENTRY _ZTI8S7388C14[];
extern  VTBL_ENTRY _ZTV8S7388C14[];
Class_Descriptor cd_S7388C14 = {  "S7388C14", // class name
  0,0,//no base classes
  &(vtc_S7388C14[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(128,68), // object size
  NSPAIRA(_ZTI8S7388C14),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S7388C14),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7388C9  : S7388C2 , S20570C17 , virtual S7388C11 {
  void *s7388c9f0;
  int s7388c9f1;
  ::S7388C14 s7388c9f2;
  char s7388c9f3[9];
  ::S7388C8 s7388c9f4;
  __tsi64 s7388c9f5:64;
  virtual  ~S7388C9(); // _ZN7S7388C9D2Ev
  virtual void  v7(); // _ZN7S7388C92v7Ev
  S7388C9(); // tgen
};
//SIG(-1 S7388C9) C1{ BC2{ VBC3{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} vd v2 Fl[3] FL Fs Fi FL Fi} BC4{ vd m Fp Fl Fi Fp} VBC5{ VBC3 BC6{ BC7{ VBC3 vd v3 FC3[5] FL Fs:5 Fc:0 Fp[2] Fi FL} BC3 BC8{ BC3 v4 v5 v6 FD Fs:16 Fi[7] FD Fc:6 FL:64 FL[2] Fi} v7 FD Fp Fs[6] Fp Fi FD Fi} BC7 vd FD[9] Fs} vd v1 Fp Fi FC9{ vd v8 FD Fi[2] Fc Fp FC4 Fi Fp Fi[2]} Fc[9] FU10{ m FD[10] Fs Fs Fp Fl Fp FD[9]} FL:64}


 S7388C9 ::~S7388C9(){ note_dtor("S7388C9", this);}
void  S7388C9 ::v7(){vfunc_called(this, "_ZN7S7388C92v7Ev");}
S7388C9 ::S7388C9(){ note_ctor("S7388C9", this);} // tgen

static void Test_S7388C9()
{
  extern Class_Descriptor cd_S7388C9;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(243,699)];
    init_test(&cd_S7388C9, buf);
    S7388C9 *dp, &lv = *(dp=new (buf) S7388C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(3872,2792), "sizeof(S7388C9)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7388C9)");
    check_base_class_offset(lv, (S20570C5*)(S7388C2*), ABISELECT(448,280), "S7388C9");
    /*is_ambiguous_... S7388C11::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S7388C11*), ABISELECT(448,280), "S7388C9");
    check_base_class_offset(lv, (S20570C5*)(S7388C13*)(S7388C12*)(S7388C11*), ABISELECT(448,280), "S7388C9");
    /*is_ambiguous_... S7388C11::S7388C13 */ AMB_check_base_class_offset(lv, (S20570C5*)(S7388C13*)(S7388C11*), ABISELECT(448,280), "S7388C9");
    check_base_class_offset(lv, (S7388C2*), 0, "S7388C9");
    check_base_class_offset(lv, (S20570C17*), ABISELECT(64,44), "S7388C9");
    check_base_class_offset(lv, (S7388C13*)(S7388C12*)(S7388C11*), ABISELECT(672,448), "S7388C9");
    /*is_ambiguous_... S7388C12::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S7388C12*)(S7388C11*), ABISELECT(1856,1324), "S7388C9");
    check_base_class_offset(lv, (S20570C5*)(S7388C6*)(S7388C12*)(S7388C11*), ABISELECT(2096,1496), "S7388C9");
    check_base_class_offset(lv, (S7388C6*)(S7388C12*)(S7388C11*), ABISELECT(2080,1492), "S7388C9");
    check_base_class_offset(lv, (S7388C12*)(S7388C11*), ABISELECT(672,448), "S7388C9");
    /*is_ambiguous_... S7388C11::S7388C13 */ AMB_check_base_class_offset(lv, (S7388C13*)(S7388C11*), ABISELECT(2528,1804), "S7388C9");
    check_base_class_offset(lv, (S7388C11*), ABISELECT(672,448), "S7388C9");
    check_field_offset(lv, s7388c9f0, ABISELECT(104,64), "S7388C9.s7388c9f0");
    check_field_offset(lv, s7388c9f1, ABISELECT(112,68), "S7388C9.s7388c9f1");
    check_field_offset(lv, s7388c9f2, ABISELECT(128,72), "S7388C9.s7388c9f2");
    check_field_offset(lv, s7388c9f3, ABISELECT(256,140), "S7388C9.s7388c9f3");
    check_field_offset(lv, s7388c9f4, ABISELECT(272,152), "S7388C9.s7388c9f4");
    set_bf_and_test(lv, s7388c9f5, ABISELECT(432,272), 0, 64, 1, "S7388C9");
    set_bf_and_test(lv, s7388c9f5, ABISELECT(432,272), 0, 64, hide_sll(1LL<<63), "S7388C9");
    test_class_info(&lv, &cd_S7388C9);
    dp->~S7388C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7388C9(Test_S7388C9, "S7388C9", ABISELECT(3872,2792));

#else // __cplusplus

extern void _ZN7S7388C9C1Ev();
extern void _ZN7S7388C9D2Ev();
Name_Map name_map_S7388C9[] = {
  NSPAIR(_ZN7S7388C9C1Ev),
  NSPAIR(_ZN7S7388C9D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S7388C2;
extern VTBL_ENTRY _ZTI7S7388C2[];
extern  VTBL_ENTRY _ZTV7S7388C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7388C2[];
extern Class_Descriptor cd_S20570C17;
extern VTBL_ENTRY _ZTI9S20570C17[];
extern  VTBL_ENTRY _ZTV9S20570C17[];
extern Class_Descriptor cd_S7388C13;
extern VTBL_ENTRY _ZTI8S7388C13[];
extern  VTBL_ENTRY _ZTV8S7388C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7388C13[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S7388C6;
extern VTBL_ENTRY _ZTI7S7388C6[];
extern  VTBL_ENTRY _ZTV7S7388C6[];
extern Class_Descriptor cd_S7388C12;
extern VTBL_ENTRY _ZTI8S7388C12[];
extern  VTBL_ENTRY _ZTV8S7388C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7388C12[];
extern Class_Descriptor cd_S7388C13;
extern VTBL_ENTRY _ZTI8S7388C13[];
extern  VTBL_ENTRY _ZTV8S7388C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7388C13[];
extern Class_Descriptor cd_S7388C11;
extern VTBL_ENTRY _ZTI8S7388C11[];
extern  VTBL_ENTRY _ZTV8S7388C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7388C11[];
static Base_Class bases_S7388C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(448,280), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S7388C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20570C17,    ABISELECT(64,44), //bcp->offset
    8, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7388C13,    ABISELECT(672,448), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(1856,1324), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(2096,1496), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S7388C6,    ABISELECT(2080,1492), //bcp->offset
    25, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S7388C12,    ABISELECT(672,448), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S7388C13,    ABISELECT(2528,1804), //bcp->offset
    30, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S7388C11,    ABISELECT(672,448), //bcp->offset
    12, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S7388C9[];
extern void _ZN7S7388C9D1Ev();
extern void _ZN7S7388C9D0Ev();
extern void _ZN7S7388C22v1Ev();
extern void _ZN7S7388C92v7Ev();
extern void ABISELECT(_ZThn64_N7S7388C9D1Ev,_ZThn44_N7S7388C9D1Ev)();
extern void ABISELECT(_ZThn64_N7S7388C9D0Ev,_ZThn44_N7S7388C9D0Ev)();
extern void ABISELECT(_ZTv0_n32_N7S7388C9D1Ev,_ZTv0_n16_N7S7388C9D1Ev)();
extern void ABISELECT(_ZThn672_N7S7388C9D1Ev,_ZThn448_N7S7388C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S7388C9D0Ev,_ZTv0_n16_N7S7388C9D0Ev)();
extern void ABISELECT(_ZThn672_N7S7388C9D0Ev,_ZThn448_N7S7388C9D0Ev)() __attribute__((weak));
extern void _ZN8S7388C132v5Ev();
extern void _ZN8S7388C122v6Ev();
extern void _ZN7S7388C62v2Ev();
extern void _ZN7S7388C62v3Ev();
extern void _ZN7S7388C62v4Ev();
extern void ABISELECT(_ZTvn1856_n32_N7S7388C9D1Ev,_ZTvn1356_n16_N7S7388C9D1Ev)();
extern void ABISELECT(_ZTvn1856_n32_N7S7388C9D0Ev,_ZTvn1356_n16_N7S7388C9D0Ev)();
extern void _ZN8S7388C132v5Ev();
static  VTBL_ENTRY vtc_S7388C9[] = {
  ABISELECT(672,448),
  ABISELECT(448,280),
  0,
  (VTBL_ENTRY)&(_ZTI7S7388C9[0]),
  (VTBL_ENTRY)&_ZN7S7388C9D1Ev,
  (VTBL_ENTRY)&_ZN7S7388C9D0Ev,
  (VTBL_ENTRY)&_ZN7S7388C22v1Ev,
  (VTBL_ENTRY)&_ZN7S7388C92v7Ev,
  ABISELECT(-64,-44),
  (VTBL_ENTRY)&(_ZTI7S7388C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S7388C9D1Ev,_ZThn44_N7S7388C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S7388C9D0Ev,_ZThn44_N7S7388C9D0Ev),
  ABISELECT(1408,1044),
  ABISELECT(1408,1044),
  ABISELECT(1408,1044),
  0,
  0,
  ABISELECT(-672,-448),
  ABISELECT(-224,-168),
  ABISELECT(-672,-448),
  (VTBL_ENTRY)&(_ZTI7S7388C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S7388C9D1Ev,_ZTv0_n16_N7S7388C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S7388C9D0Ev,_ZTv0_n16_N7S7388C9D0Ev),
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
  (VTBL_ENTRY)&_ZN8S7388C122v6Ev,
  ABISELECT(-2080,-1492),
  (VTBL_ENTRY)&(_ZTI7S7388C9[0]),
  (VTBL_ENTRY)&_ZN7S7388C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v3Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v4Ev,
  ABISELECT(-2080,-1524),
  ABISELECT(-2528,-1804),
  (VTBL_ENTRY)&(_ZTI7S7388C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1856_n32_N7S7388C9D1Ev,_ZTvn1356_n16_N7S7388C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1856_n32_N7S7388C9D0Ev,_ZTvn1356_n16_N7S7388C9D0Ev),
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
};
extern VTBL_ENTRY _ZTV7S7388C9[];
extern void _ZN7S7388C2D1Ev();
extern void _ZN7S7388C2D0Ev();
extern void _ZN7S7388C22v1Ev();
static  VTBL_ENTRY _tg__ZTV7S7388C2__7S7388C9[] = {
  ABISELECT(448,280),
  0,
  (VTBL_ENTRY)&(_ZTI7S7388C2[0]),
  (VTBL_ENTRY)&_ZN7S7388C2D1Ev,
  (VTBL_ENTRY)&_ZN7S7388C2D0Ev,
  (VTBL_ENTRY)&_ZN7S7388C22v1Ev,
};
extern void _ZN8S7388C11D1Ev();
extern void _ZN8S7388C11D0Ev();
extern void _ZN8S7388C132v5Ev();
extern void _ZN8S7388C122v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C11__7S7388C9[] = {
  ABISELECT(-224,-168),
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C11[0]),
  (VTBL_ENTRY)&_ZN8S7388C11D1Ev,
  (VTBL_ENTRY)&_ZN8S7388C11D0Ev,
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
  (VTBL_ENTRY)&_ZN8S7388C122v6Ev,
};
extern void _ZN8S7388C12D1Ev();
extern void _ZN8S7388C12D0Ev();
extern void _ZN8S7388C132v5Ev();
extern void _ZN8S7388C122v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C128S7388C11__7S7388C9[] = {
  ABISELECT(-224,-168),
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C12[0]),
  (VTBL_ENTRY)&_ZN8S7388C12D1Ev,
  (VTBL_ENTRY)&_ZN8S7388C12D0Ev,
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
  (VTBL_ENTRY)&_ZN8S7388C122v6Ev,
};
extern void _ZN8S7388C13D1Ev();
extern void _ZN8S7388C13D0Ev();
extern void _ZN8S7388C132v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C138S7388C128S7388C11__7S7388C9[] = {
  ABISELECT(-224,-168),
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C13[0]),
  (VTBL_ENTRY)&_ZN8S7388C13D1Ev,
  (VTBL_ENTRY)&_ZN8S7388C13D0Ev,
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
};
extern void _ZN8S7388C13D1Ev();
extern void _ZN8S7388C13D0Ev();
extern void _ZN8S7388C132v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C138S7388C11__A1__7S7388C9[] = {
  ABISELECT(-2080,-1524),
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C13[0]),
  (VTBL_ENTRY)&_ZN8S7388C13D1Ev,
  (VTBL_ENTRY)&_ZN8S7388C13D0Ev,
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
};
extern void ABISELECT(_ZThn1856_N8S7388C11D1Ev,_ZThn1356_N8S7388C11D1Ev)();
extern void ABISELECT(_ZThn1856_N8S7388C11D0Ev,_ZThn1356_N8S7388C11D0Ev)();
extern void _ZN8S7388C132v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C13__A1__8S7388C11__7S7388C9[] = {
  ABISELECT(-2080,-1524),
  ABISELECT(-1856,-1356),
  (VTBL_ENTRY)&(_ZTI8S7388C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1856_N8S7388C11D1Ev,_ZThn1356_N8S7388C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1856_N8S7388C11D0Ev,_ZThn1356_N8S7388C11D0Ev),
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
};
static  VTT_ENTRY vtt_S7388C9[] = {
  {&(_ZTV7S7388C9[4]),  4,36},
  {&(_tg__ZTV7S7388C2__7S7388C9[3]),  3,6},
  {&(_ZTV7S7388C9[21]),  21,36},
  {&(_ZTV7S7388C9[27]),  27,36},
  {&(_ZTV7S7388C9[33]),  33,36},
  {&(_tg__ZTV8S7388C11__7S7388C9[3]),  3,7},
  {&(_tg__ZTV8S7388C128S7388C11__7S7388C9[3]),  3,7},
  {&(_tg__ZTV8S7388C138S7388C128S7388C11__7S7388C9[3]),  3,6},
  {&(_tg__ZTV8S7388C138S7388C11__A1__7S7388C9[3]),  3,6},
  {&(_tg__ZTV8S7388C13__A1__8S7388C11__7S7388C9[3]),  3,6},
};
extern VTBL_ENTRY _ZTI7S7388C9[];
extern  VTBL_ENTRY _ZTV7S7388C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7388C9[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S7388C9D0Ev,_ZTv0_n16_N7S7388C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn672_N7S7388C9D0Ev,_ZThn448_N7S7388C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S7388C9D1Ev,_ZTv0_n16_N7S7388C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn672_N7S7388C9D1Ev,_ZThn448_N7S7388C9D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7388C9 = {  "S7388C9", // class name
  bases_S7388C9, 10,
  &(vtc_S7388C9[0]), // expected_vtbl_contents
  &(vtt_S7388C9[0]), // expected_vtt_contents
  ABISELECT(3872,2792), // object size
  NSPAIRA(_ZTI7S7388C9),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S7388C9),36, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7388C9),10, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7388C4  : virtual S7388C5 , virtual S7388C9 {
  ::S7388C5 s7388c4f0;
  long s7388c4f1;
  int s7388c4f2;
  char s7388c4f3;
  char s7388c4f4:4;
  __tsi64 s7388c4f5;
  virtual  ~S7388C4(); // _ZN7S7388C4D2Ev
  virtual void  v8(); // _ZN7S7388C42v8Ev
  S7388C4(); // tgen
};
//SIG(-1 S7388C4) C1{ VBC2{ VBC3{ BC4{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} v2 v3 v4 FD Fs:16 Fi[7] FD Fc:6 FL:64 FL[2] Fi} FU5{ m FD Fp Fs:5 Fp FD Fp FD Fi[7] Fp Fp}[5] Fc[3] Fp Fp Fs[4] Fi[6] FC6{ VBC4 vd v5 Fl[3] FL Fs Fi FL Fi} Fi Fp[8] Fi FU7{ m FD[10] Fs Fs Fp Fl Fp FD[9]} Fc Fi Fi[7]} VBC8{ BC6 BC9{ vd m Fp Fl Fi Fp} VBC10{ VBC4 BC11{ BC12{ VBC4 vd v6 FC4[5] FL Fs:5 Fc:0 Fp Fp Fi FL} BC4 BC3 v7 FD Fp Fs[6] Fp Fi FD Fi} BC12 vd FD[9] Fs} vd v8 Fp Fi FC13{ vd v9 FD Fi Fi Fc Fp FC9 Fi Fp Fi[2]} Fc[9] FU7 FL:64} vd v1 FC2 Fl Fi Fc Fc:4 FL}


 S7388C4 ::~S7388C4(){ note_dtor("S7388C4", this);}
void  S7388C4 ::v8(){vfunc_called(this, "_ZN7S7388C42v8Ev");}
S7388C4 ::S7388C4(){ note_ctor("S7388C4", this);} // tgen

static void Test_S7388C4()
{
  extern Class_Descriptor cd_S7388C4;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(392,1133)];
    init_test(&cd_S7388C4, buf);
    S7388C4 *dp, &lv = *(dp=new (buf) S7388C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(6256,4528), "sizeof(S7388C4)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7388C4)");
    /*is_ambiguous_... S7388C4::S7388C6 */ AMB_check_base_class_offset(lv, (S20570C5*)(S7388C6*), ABISELECT(2048,1480), "S7388C4");
    check_base_class_offset(lv, (S7388C6*)(S7388C5*), ABISELECT(2032,1476), "S7388C4");
    check_base_class_offset(lv, (S7388C5*), ABISELECT(1216,880), "S7388C4");
    check_base_class_offset(lv, (S20570C5*)(S7388C2*)(S7388C9*), ABISELECT(2832,2016), "S7388C4");
    /*is_ambiguous_... S7388C11::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S7388C11*), ABISELECT(2832,2016), "S7388C4");
    check_base_class_offset(lv, (S20570C5*)(S7388C13*)(S7388C12*)(S7388C11*), ABISELECT(2832,2016), "S7388C4");
    /*is_ambiguous_... S7388C11::S7388C13 */ AMB_check_base_class_offset(lv, (S20570C5*)(S7388C13*)(S7388C11*), ABISELECT(2832,2016), "S7388C4");
    check_base_class_offset(lv, (S7388C2*)(S7388C9*), ABISELECT(2384,1736), "S7388C4");
    check_base_class_offset(lv, (S20570C17*)(S7388C9*), ABISELECT(2448,1780), "S7388C4");
    check_base_class_offset(lv, (S7388C13*)(S7388C12*)(S7388C11*), ABISELECT(3056,2184), "S7388C4");
    /*is_ambiguous_... S7388C12::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S7388C12*)(S7388C11*), ABISELECT(4240,3060), "S7388C4");
    check_base_class_offset(lv, (S20570C5*)(S7388C6*)(S7388C12*)(S7388C11*), ABISELECT(4480,3232), "S7388C4");
    check_base_class_offset(lv, (S7388C6*)(S7388C12*)(S7388C11*), ABISELECT(4464,3228), "S7388C4");
    check_base_class_offset(lv, (S7388C12*)(S7388C11*), ABISELECT(3056,2184), "S7388C4");
    /*is_ambiguous_... S7388C11::S7388C13 */ AMB_check_base_class_offset(lv, (S7388C13*)(S7388C11*), ABISELECT(4912,3540), "S7388C4");
    check_base_class_offset(lv, (S7388C11*)(S7388C9*), ABISELECT(3056,2184), "S7388C4");
    check_base_class_offset(lv, (S7388C9*), ABISELECT(2384,1736), "S7388C4");
    check_field_offset(lv, s7388c4f0, ABISELECT(16,4), "S7388C4.s7388c4f0");
    check_field_offset(lv, s7388c4f1, ABISELECT(1184,860), "S7388C4.s7388c4f1");
    check_field_offset(lv, s7388c4f2, ABISELECT(1192,864), "S7388C4.s7388c4f2");
    check_field_offset(lv, s7388c4f3, ABISELECT(1196,868), "S7388C4.s7388c4f3");
    set_bf_and_test(lv, s7388c4f4, ABISELECT(1197,869), 0, 4, 1, "S7388C4");
    set_bf_and_test(lv, s7388c4f4, ABISELECT(1197,869), 0, 4, hide_sll(1LL<<3), "S7388C4");
    check_field_offset(lv, s7388c4f5, ABISELECT(1200,872), "S7388C4.s7388c4f5");
    test_class_info(&lv, &cd_S7388C4);
    dp->~S7388C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7388C4(Test_S7388C4, "S7388C4", ABISELECT(6256,4528));

#else // __cplusplus

extern void _ZN7S7388C4C1Ev();
extern void _ZN7S7388C4D2Ev();
Name_Map name_map_S7388C4[] = {
  NSPAIR(_ZN7S7388C4C1Ev),
  NSPAIR(_ZN7S7388C4D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S7388C6;
extern VTBL_ENTRY _ZTI7S7388C6[];
extern  VTBL_ENTRY _ZTV7S7388C6[];
extern Class_Descriptor cd_S7388C5;
extern VTBL_ENTRY _ZTI7S7388C5[];
extern  VTBL_ENTRY _ZTV7S7388C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7388C5[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S7388C2;
extern VTBL_ENTRY _ZTI7S7388C2[];
extern  VTBL_ENTRY _ZTV7S7388C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7388C2[];
extern Class_Descriptor cd_S20570C17;
extern VTBL_ENTRY _ZTI9S20570C17[];
extern  VTBL_ENTRY _ZTV9S20570C17[];
extern Class_Descriptor cd_S7388C13;
extern VTBL_ENTRY _ZTI8S7388C13[];
extern  VTBL_ENTRY _ZTV8S7388C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7388C13[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S7388C6;
extern VTBL_ENTRY _ZTI7S7388C6[];
extern  VTBL_ENTRY _ZTV7S7388C6[];
extern Class_Descriptor cd_S7388C12;
extern VTBL_ENTRY _ZTI8S7388C12[];
extern  VTBL_ENTRY _ZTV8S7388C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7388C12[];
extern Class_Descriptor cd_S7388C13;
extern VTBL_ENTRY _ZTI8S7388C13[];
extern  VTBL_ENTRY _ZTV8S7388C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7388C13[];
extern Class_Descriptor cd_S7388C11;
extern VTBL_ENTRY _ZTI8S7388C11[];
extern  VTBL_ENTRY _ZTV8S7388C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7388C11[];
extern Class_Descriptor cd_S7388C9;
extern VTBL_ENTRY _ZTI7S7388C9[];
extern  VTBL_ENTRY _ZTV7S7388C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7388C9[];
static Base_Class bases_S7388C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(2048,1480), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S7388C6,    ABISELECT(2032,1476), //bcp->offset
    13, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S7388C5,    ABISELECT(1216,880), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20570C5,    ABISELECT(2832,2016), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S7388C2,    ABISELECT(2384,1736), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S20570C17,    ABISELECT(2448,1780), //bcp->offset
    32, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S7388C13,    ABISELECT(3056,2184), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(4240,3060), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(4480,3232), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S7388C6,    ABISELECT(4464,3228), //bcp->offset
    49, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7388C12,    ABISELECT(3056,2184), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S7388C13,    ABISELECT(4912,3540), //bcp->offset
    54, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S7388C11,    ABISELECT(3056,2184), //bcp->offset
    36, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S7388C9,    ABISELECT(2384,1736), //bcp->offset
    21, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S7388C4[];
extern void _ZN7S7388C4D1Ev();
extern void _ZN7S7388C4D0Ev();
extern void _ZN7S7388C42v8Ev();
extern void _ZN7S7388C62v2Ev();
extern void _ZN7S7388C62v3Ev();
extern void _ZN7S7388C62v4Ev();
extern void ABISELECT(_ZTv0_n40_N7S7388C4D1Ev,_ZTv0_n20_N7S7388C4D1Ev)();
extern void ABISELECT(_ZThn2384_N7S7388C4D1Ev,_ZThn1736_N7S7388C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S7388C4D0Ev,_ZTv0_n20_N7S7388C4D0Ev)();
extern void ABISELECT(_ZThn2384_N7S7388C4D0Ev,_ZThn1736_N7S7388C4D0Ev)() __attribute__((weak));
extern void _ZN7S7388C22v1Ev();
extern void _ZN7S7388C92v7Ev();
extern void ABISELECT(_ZTvn64_n40_N7S7388C4D1Ev,_ZTvn44_n20_N7S7388C4D1Ev)();
extern void ABISELECT(_ZTvn64_n40_N7S7388C4D0Ev,_ZTvn44_n20_N7S7388C4D0Ev)();
extern void ABISELECT(_ZTv0_n32_N7S7388C4D1Ev,_ZTv0_n16_N7S7388C4D1Ev)();
extern void ABISELECT(_ZThn3056_N7S7388C4D1Ev,_ZThn2184_N7S7388C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S7388C4D0Ev,_ZTv0_n16_N7S7388C4D0Ev)();
extern void ABISELECT(_ZThn3056_N7S7388C4D0Ev,_ZThn2184_N7S7388C4D0Ev)() __attribute__((weak));
extern void _ZN8S7388C132v5Ev();
extern void _ZN8S7388C122v6Ev();
extern void _ZN7S7388C62v2Ev();
extern void _ZN7S7388C62v3Ev();
extern void _ZN7S7388C62v4Ev();
extern void ABISELECT(_ZTvn1856_n32_N7S7388C4D1Ev,_ZTvn1356_n16_N7S7388C4D1Ev)();
extern void ABISELECT(_ZTvn1856_n32_N7S7388C4D0Ev,_ZTvn1356_n16_N7S7388C4D0Ev)();
extern void _ZN8S7388C132v5Ev();
static  VTBL_ENTRY vtc_S7388C4[] = {
  ABISELECT(3056,2184),
  ABISELECT(2832,2016),
  ABISELECT(2384,1736),
  ABISELECT(2032,1476),
  ABISELECT(1216,880),
  0,
  (VTBL_ENTRY)&(_ZTI7S7388C4[0]),
  (VTBL_ENTRY)&_ZN7S7388C4D1Ev,
  (VTBL_ENTRY)&_ZN7S7388C4D0Ev,
  (VTBL_ENTRY)&_ZN7S7388C42v8Ev,
  ABISELECT(816,596),
  ABISELECT(-1216,-880),
  (VTBL_ENTRY)&(_ZTI7S7388C4[0]),
  0,
  0,
  0,
  ABISELECT(-2032,-1476),
  (VTBL_ENTRY)&(_ZTI7S7388C4[0]),
  (VTBL_ENTRY)&_ZN7S7388C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v3Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v4Ev,
  0,
  0,
  ABISELECT(-2384,-1736),
  ABISELECT(672,448),
  ABISELECT(448,280),
  ABISELECT(-2384,-1736),
  (VTBL_ENTRY)&(_ZTI7S7388C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7388C4D1Ev,_ZTv0_n20_N7S7388C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7388C4D0Ev,_ZTv0_n20_N7S7388C4D0Ev),
  (VTBL_ENTRY)&_ZN7S7388C22v1Ev,
  (VTBL_ENTRY)&_ZN7S7388C92v7Ev,
  ABISELECT(-2448,-1780),
  (VTBL_ENTRY)&(_ZTI7S7388C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn64_n40_N7S7388C4D1Ev,_ZTvn44_n20_N7S7388C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn64_n40_N7S7388C4D0Ev,_ZTvn44_n20_N7S7388C4D0Ev),
  ABISELECT(1408,1044),
  ABISELECT(1408,1044),
  ABISELECT(1408,1044),
  0,
  0,
  ABISELECT(-3056,-2184),
  ABISELECT(-224,-168),
  ABISELECT(-3056,-2184),
  (VTBL_ENTRY)&(_ZTI7S7388C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S7388C4D1Ev,_ZTv0_n16_N7S7388C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S7388C4D0Ev,_ZTv0_n16_N7S7388C4D0Ev),
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
  (VTBL_ENTRY)&_ZN8S7388C122v6Ev,
  ABISELECT(-4464,-3228),
  (VTBL_ENTRY)&(_ZTI7S7388C4[0]),
  (VTBL_ENTRY)&_ZN7S7388C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v3Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v4Ev,
  ABISELECT(-2080,-1524),
  ABISELECT(-4912,-3540),
  (VTBL_ENTRY)&(_ZTI7S7388C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1856_n32_N7S7388C4D1Ev,_ZTvn1356_n16_N7S7388C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1856_n32_N7S7388C4D0Ev,_ZTvn1356_n16_N7S7388C4D0Ev),
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
};
extern VTBL_ENTRY _ZTV7S7388C4[];
static  VTBL_ENTRY _tg__ZTV7S7388C5__7S7388C4[] = {
  ABISELECT(816,596),
  0,
  (VTBL_ENTRY)&(_ZTI7S7388C5[0]),
};
extern void _ZN7S7388C62v2Ev();
extern void _ZN7S7388C62v3Ev();
extern void _ZN7S7388C62v4Ev();
static  VTBL_ENTRY _tg__ZTV7S7388C6__7S7388C5__7S7388C4[] = {
  0,
  0,
  0,
  ABISELECT(-816,-596),
  (VTBL_ENTRY)&(_ZTI7S7388C5[0]),
  (VTBL_ENTRY)&_ZN7S7388C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v3Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v4Ev,
};
extern void _ZN7S7388C9D1Ev();
extern void _ZN7S7388C9D0Ev();
extern void _ZN7S7388C22v1Ev();
extern void _ZN7S7388C92v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7388C9__7S7388C4[] = {
  ABISELECT(672,448),
  ABISELECT(448,280),
  0,
  (VTBL_ENTRY)&(_ZTI7S7388C9[0]),
  (VTBL_ENTRY)&_ZN7S7388C9D1Ev,
  (VTBL_ENTRY)&_ZN7S7388C9D0Ev,
  (VTBL_ENTRY)&_ZN7S7388C22v1Ev,
  (VTBL_ENTRY)&_ZN7S7388C92v7Ev,
};
extern void _ZN7S7388C2D1Ev();
extern void _ZN7S7388C2D0Ev();
extern void _ZN7S7388C22v1Ev();
static  VTBL_ENTRY _tg__ZTV7S7388C27S7388C9__7S7388C4[] = {
  ABISELECT(448,280),
  0,
  (VTBL_ENTRY)&(_ZTI7S7388C2[0]),
  (VTBL_ENTRY)&_ZN7S7388C2D1Ev,
  (VTBL_ENTRY)&_ZN7S7388C2D0Ev,
  (VTBL_ENTRY)&_ZN7S7388C22v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N7S7388C9D1Ev,_ZTv0_n16_N7S7388C9D1Ev)();
extern void ABISELECT(_ZThn672_N7S7388C9D1Ev,_ZThn448_N7S7388C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S7388C9D0Ev,_ZTv0_n16_N7S7388C9D0Ev)();
extern void ABISELECT(_ZThn672_N7S7388C9D0Ev,_ZThn448_N7S7388C9D0Ev)() __attribute__((weak));
extern void _ZN8S7388C132v5Ev();
extern void _ZN8S7388C122v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C11__7S7388C9__7S7388C4[] = {
  ABISELECT(1408,1044),
  ABISELECT(1408,1044),
  ABISELECT(1408,1044),
  0,
  0,
  ABISELECT(-672,-448),
  ABISELECT(-224,-168),
  ABISELECT(-672,-448),
  (VTBL_ENTRY)&(_ZTI7S7388C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S7388C9D1Ev,_ZTv0_n16_N7S7388C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S7388C9D0Ev,_ZTv0_n16_N7S7388C9D0Ev),
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
  (VTBL_ENTRY)&_ZN8S7388C122v6Ev,
};
extern void _ZN7S7388C62v2Ev();
extern void _ZN7S7388C62v3Ev();
extern void _ZN7S7388C62v4Ev();
static  VTBL_ENTRY _tg__ZTV7S7388C68S7388C128S7388C11__7S7388C9__7S7388C4[] = {
  ABISELECT(-2080,-1492),
  (VTBL_ENTRY)&(_ZTI7S7388C9[0]),
  (VTBL_ENTRY)&_ZN7S7388C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v3Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v4Ev,
};
extern void ABISELECT(_ZTvn1856_n32_N7S7388C9D1Ev,_ZTvn1356_n16_N7S7388C9D1Ev)();
extern void ABISELECT(_ZTvn1856_n32_N7S7388C9D0Ev,_ZTvn1356_n16_N7S7388C9D0Ev)();
extern void _ZN8S7388C132v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C138S7388C11__A1__7S7388C9__7S7388C4[] = {
  ABISELECT(-2080,-1524),
  ABISELECT(-2528,-1804),
  (VTBL_ENTRY)&(_ZTI7S7388C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1856_n32_N7S7388C9D1Ev,_ZTvn1356_n16_N7S7388C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1856_n32_N7S7388C9D0Ev,_ZTvn1356_n16_N7S7388C9D0Ev),
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
};
extern void _ZN8S7388C11D1Ev();
extern void _ZN8S7388C11D0Ev();
extern void _ZN8S7388C132v5Ev();
extern void _ZN8S7388C122v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C11__7S7388C4[] = {
  ABISELECT(-224,-168),
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C11[0]),
  (VTBL_ENTRY)&_ZN8S7388C11D1Ev,
  (VTBL_ENTRY)&_ZN8S7388C11D0Ev,
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
  (VTBL_ENTRY)&_ZN8S7388C122v6Ev,
};
extern void _ZN8S7388C12D1Ev();
extern void _ZN8S7388C12D0Ev();
extern void _ZN8S7388C132v5Ev();
extern void _ZN8S7388C122v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C128S7388C11__7S7388C4[] = {
  ABISELECT(-224,-168),
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C12[0]),
  (VTBL_ENTRY)&_ZN8S7388C12D1Ev,
  (VTBL_ENTRY)&_ZN8S7388C12D0Ev,
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
  (VTBL_ENTRY)&_ZN8S7388C122v6Ev,
};
extern void _ZN8S7388C13D1Ev();
extern void _ZN8S7388C13D0Ev();
extern void _ZN8S7388C132v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C138S7388C128S7388C11__7S7388C4[] = {
  ABISELECT(-224,-168),
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C13[0]),
  (VTBL_ENTRY)&_ZN8S7388C13D1Ev,
  (VTBL_ENTRY)&_ZN8S7388C13D0Ev,
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
};
extern void _ZN8S7388C13D1Ev();
extern void _ZN8S7388C13D0Ev();
extern void _ZN8S7388C132v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C138S7388C11__A1__7S7388C4[] = {
  ABISELECT(-2080,-1524),
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C13[0]),
  (VTBL_ENTRY)&_ZN8S7388C13D1Ev,
  (VTBL_ENTRY)&_ZN8S7388C13D0Ev,
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
};
extern void ABISELECT(_ZThn1856_N8S7388C11D1Ev,_ZThn1356_N8S7388C11D1Ev)();
extern void ABISELECT(_ZThn1856_N8S7388C11D0Ev,_ZThn1356_N8S7388C11D0Ev)();
extern void _ZN8S7388C132v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C13__A1__8S7388C11__7S7388C4[] = {
  ABISELECT(-2080,-1524),
  ABISELECT(-1856,-1356),
  (VTBL_ENTRY)&(_ZTI8S7388C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1856_N8S7388C11D1Ev,_ZThn1356_N8S7388C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1856_N8S7388C11D0Ev,_ZThn1356_N8S7388C11D0Ev),
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
};
static  VTT_ENTRY vtt_S7388C4[] = {
  {&(_ZTV7S7388C4[7]),  7,60},
  {&(_ZTV7S7388C4[13]),  13,60},
  {&(_ZTV7S7388C4[18]),  18,60},
  {&(_ZTV7S7388C4[28]),  28,60},
  {&(_ZTV7S7388C4[34]),  34,60},
  {&(_ZTV7S7388C4[45]),  45,60},
  {&(_ZTV7S7388C4[51]),  51,60},
  {&(_ZTV7S7388C4[57]),  57,60},
  {&(_tg__ZTV7S7388C5__7S7388C4[3]),  3,3},
  {&(_tg__ZTV7S7388C6__7S7388C5__7S7388C4[5]),  5,8},
  {&(_tg__ZTV7S7388C9__7S7388C4[4]),  4,8},
  {&(_tg__ZTV7S7388C27S7388C9__7S7388C4[3]),  3,6},
  {&(_tg__ZTV8S7388C11__7S7388C9__7S7388C4[9]),  9,13},
  {&(_tg__ZTV7S7388C68S7388C128S7388C11__7S7388C9__7S7388C4[2]),  2,5},
  {&(_tg__ZTV8S7388C138S7388C11__A1__7S7388C9__7S7388C4[3]),  3,6},
  {&(_tg__ZTV8S7388C11__7S7388C4[3]),  3,7},
  {&(_tg__ZTV8S7388C128S7388C11__7S7388C4[3]),  3,7},
  {&(_tg__ZTV8S7388C138S7388C128S7388C11__7S7388C4[3]),  3,6},
  {&(_tg__ZTV8S7388C138S7388C11__A1__7S7388C4[3]),  3,6},
  {&(_tg__ZTV8S7388C13__A1__8S7388C11__7S7388C4[3]),  3,6},
};
extern VTBL_ENTRY _ZTI7S7388C4[];
extern  VTBL_ENTRY _ZTV7S7388C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7388C4[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S7388C9D0Ev,_ZTv0_n16_N7S7388C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn672_N7S7388C9D0Ev,_ZThn448_N7S7388C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S7388C9D1Ev,_ZTv0_n16_N7S7388C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn672_N7S7388C9D1Ev,_ZThn448_N7S7388C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S7388C4D0Ev,_ZTv0_n16_N7S7388C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3056_N7S7388C4D0Ev,_ZThn2184_N7S7388C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S7388C4D1Ev,_ZTv0_n16_N7S7388C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3056_N7S7388C4D1Ev,_ZThn2184_N7S7388C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7388C4D0Ev,_ZTv0_n20_N7S7388C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2384_N7S7388C4D0Ev,_ZThn1736_N7S7388C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7388C4D1Ev,_ZTv0_n20_N7S7388C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2384_N7S7388C4D1Ev,_ZThn1736_N7S7388C4D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7388C4 = {  "S7388C4", // class name
  bases_S7388C4, 14,
  &(vtc_S7388C4[0]), // expected_vtbl_contents
  &(vtt_S7388C4[0]), // expected_vtt_contents
  ABISELECT(6256,4528), // object size
  NSPAIRA(_ZTI7S7388C4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S7388C4),60, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7388C4),20, //virtual table table var
  10, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7388C15  : S7388C6 , virtual S20570C5 {
  ::S5217C45 s7388c15f0;
  __tsi64 s7388c15f1;
  int s7388c15f2:23;
  short s7388c15f3;
  int s7388c15f4;
  long s7388c15f5[2];
  ~S7388C15(); // tgen
  S7388C15(); // tgen
};
//SIG(-1 S7388C15) C1{ BC2{ BC3{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} v1 v2 v3 FD Fs:16 Fi[7] FD Fc:6 FL:64 FL[2] Fi} VBC3 FC4{} FL Fi:23 Fs Fi Fl[2]}


S7388C15 ::~S7388C15(){ note_dtor("S7388C15", this);} // tgen
S7388C15 ::S7388C15(){ note_ctor("S7388C15", this);} // tgen

static void Test_S7388C15()
{
  extern Class_Descriptor cd_S7388C15;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(39,116)];
    init_test(&cd_S7388C15, buf);
    S7388C15 *dp, &lv = *(dp=new (buf) S7388C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(608,460), "sizeof(S7388C15)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7388C15)");
    check_base_class_offset(lv, (S20570C5*)(S7388C6*), ABISELECT(16,4), "S7388C15");
    check_base_class_offset(lv, (S7388C6*), 0, "S7388C15");
    /*is_ambiguous_... S7388C15::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*), ABISELECT(384,292), "S7388C15");
    check_field_offset(lv, s7388c15f0, ABISELECT(340,260), "S7388C15.s7388c15f0");
    check_field_offset(lv, s7388c15f1, ABISELECT(344,264), "S7388C15.s7388c15f1");
    set_bf_and_test(lv, s7388c15f2, ABISELECT(352,272), 0, 23, 1, "S7388C15");
    set_bf_and_test(lv, s7388c15f2, ABISELECT(352,272), 0, 23, hide_sll(1LL<<22), "S7388C15");
    check_field_offset(lv, s7388c15f3, ABISELECT(356,276), "S7388C15.s7388c15f3");
    check_field_offset(lv, s7388c15f4, ABISELECT(360,280), "S7388C15.s7388c15f4");
    check_field_offset(lv, s7388c15f5, ABISELECT(368,284), "S7388C15.s7388c15f5");
    test_class_info(&lv, &cd_S7388C15);
    dp->~S7388C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7388C15(Test_S7388C15, "S7388C15", ABISELECT(608,460));

#else // __cplusplus

extern void _ZN8S7388C15C1Ev();
extern void _ZN8S7388C15D1Ev();
Name_Map name_map_S7388C15[] = {
  NSPAIR(_ZN8S7388C15C1Ev),
  NSPAIR(_ZN8S7388C15D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S7388C6;
extern VTBL_ENTRY _ZTI7S7388C6[];
extern  VTBL_ENTRY _ZTV7S7388C6[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
static Base_Class bases_S7388C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S7388C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20570C5,    ABISELECT(384,292), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7388C15[];
extern void _ZN7S7388C62v2Ev();
extern void _ZN7S7388C62v3Ev();
extern void _ZN7S7388C62v4Ev();
static  VTBL_ENTRY vtc_S7388C15[] = {
  ABISELECT(384,292),
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C15[0]),
  (VTBL_ENTRY)&_ZN7S7388C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v3Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v4Ev,
};
extern VTBL_ENTRY _ZTV8S7388C15[];
static  VTT_ENTRY vtt_S7388C15[] = {
  {&(_ZTV8S7388C15[3]),  3,6},
};
extern VTBL_ENTRY _ZTI8S7388C15[];
extern  VTBL_ENTRY _ZTV8S7388C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7388C15[];
Class_Descriptor cd_S7388C15 = {  "S7388C15", // class name
  bases_S7388C15, 3,
  &(vtc_S7388C15[0]), // expected_vtbl_contents
  &(vtt_S7388C15[0]), // expected_vtt_contents
  ABISELECT(608,460), // object size
  NSPAIRA(_ZTI8S7388C15),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S7388C15),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7388C15),1, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7388C18  : virtual S20570C5 {
  void *s7388c18f0;
  int s7388c18f1;
  ::S7388C6 s7388c18f2;
  int s7388c18f3;
  void *s7388c18f4;
  ~S7388C18(); // tgen
  S7388C18(); // tgen
};
//SIG(-1 S7388C18) C1{ VBC2{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} Fp Fi FC3{ BC2 v1 v2 v3 FD Fs:16 Fi[7] FD Fc:6 FL:64 FL[2] Fi} Fi Fp}


S7388C18 ::~S7388C18(){ note_dtor("S7388C18", this);} // tgen
S7388C18 ::S7388C18(){ note_ctor("S7388C18", this);} // tgen

static void Test_S7388C18()
{
  extern Class_Descriptor cd_S7388C18;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(40,113)];
    init_test(&cd_S7388C18, buf);
    S7388C18 *dp, &lv = *(dp=new (buf) S7388C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(624,448), "sizeof(S7388C18)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7388C18)");
    check_base_class_offset(lv, (S20570C5*), ABISELECT(400,280), "S7388C18");
    check_field_offset(lv, s7388c18f0, ABISELECT(8,4), "S7388C18.s7388c18f0");
    check_field_offset(lv, s7388c18f1, ABISELECT(16,8), "S7388C18.s7388c18f1");
    check_field_offset(lv, s7388c18f2, ABISELECT(32,12), "S7388C18.s7388c18f2");
    check_field_offset(lv, s7388c18f3, ABISELECT(384,272), "S7388C18.s7388c18f3");
    check_field_offset(lv, s7388c18f4, ABISELECT(392,276), "S7388C18.s7388c18f4");
    test_class_info(&lv, &cd_S7388C18);
    dp->~S7388C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7388C18(Test_S7388C18, "S7388C18", ABISELECT(624,448));

#else // __cplusplus

extern void _ZN8S7388C18C1Ev();
extern void _ZN8S7388C18D1Ev();
Name_Map name_map_S7388C18[] = {
  NSPAIR(_ZN8S7388C18C1Ev),
  NSPAIR(_ZN8S7388C18D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
static Base_Class bases_S7388C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(400,280), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7388C18[];
static  VTBL_ENTRY vtc_S7388C18[] = {
  ABISELECT(400,280),
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C18[0]),
};
extern VTBL_ENTRY _ZTV8S7388C18[];
static  VTT_ENTRY vtt_S7388C18[] = {
  {&(_ZTV8S7388C18[3]),  3,3},
};
extern VTBL_ENTRY _ZTI8S7388C18[];
extern  VTBL_ENTRY _ZTV8S7388C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7388C18[];
Class_Descriptor cd_S7388C18 = {  "S7388C18", // class name
  bases_S7388C18, 1,
  &(vtc_S7388C18[0]), // expected_vtbl_contents
  &(vtt_S7388C18[0]), // expected_vtt_contents
  ABISELECT(624,448), // object size
  NSPAIRA(_ZTI8S7388C18),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S7388C18),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7388C18),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7388C17  : virtual S7388C6 , virtual S7388C15 , S7388C12 , virtual S7388C18 {
  char s7388c17f0:5;
  long s7388c17f1[4];
  char s7388c17f2[6];
  ::S20570C17 s7388c17f3;
  virtual  ~S7388C17(); // _ZN8S7388C17D2Ev
  S7388C17(); // tgen
};
//SIG(-1 S7388C17) C1{ VBC2{ BC3{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} v1 v2 v3 FD Fs:16 Fi[7] FD Fc:6 FL:64 FL[2] Fi} VBC4{ BC2 VBC3 FC5{} FL Fi:23 Fs Fi Fl[2]} BC6{ BC7{ VBC3 vd v4 FC3[5] FL Fs:5 Fc:0 Fp[2] Fi FL} BC3 BC2 v5 FD Fp Fs[6] Fp Fi FD Fi} VBC8{ VBC3 Fp Fi FC2 Fi Fp} vd Fc:5 Fl[4] Fc[6] FC9{ vd m Fp Fl Fi Fp}}


 S7388C17 ::~S7388C17(){ note_dtor("S7388C17", this);}
S7388C17 ::S7388C17(){ note_ctor("S7388C17", this);} // tgen

static void Test_S7388C17()
{
  extern Class_Descriptor cd_S7388C17;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(207,602)];
    init_test(&cd_S7388C17, buf);
    S7388C17 *dp, &lv = *(dp=new (buf) S7388C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(3296,2404), "sizeof(S7388C17)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7388C17)");
    /*is_ambiguous_... S7388C17::S7388C6 */ AMB_check_base_class_offset(lv, (S20570C5*)(S7388C6*), ABISELECT(1952,1408), "S7388C17");
    /*is_ambiguous_... S7388C17::S7388C6 */ AMB_check_base_class_offset(lv, (S7388C6*), ABISELECT(1936,1404), "S7388C17");
    check_base_class_offset(lv, (S20570C5*)(S7388C6*)(S7388C15*), ABISELECT(2304,1668), "S7388C17");
    check_base_class_offset(lv, (S7388C6*)(S7388C15*), ABISELECT(2288,1664), "S7388C17");
    /*is_ambiguous_... S7388C15::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S7388C15*), ABISELECT(2672,1956), "S7388C17");
    check_base_class_offset(lv, (S20570C5*)(S7388C13*)(S7388C12*), ABISELECT(2672,1956), "S7388C17");
    check_base_class_offset(lv, (S20570C5*)(S7388C18*), ABISELECT(2672,1956), "S7388C17");
    check_base_class_offset(lv, (S7388C15*), ABISELECT(2288,1664), "S7388C17");
    check_base_class_offset(lv, (S7388C13*)(S7388C12*), 0, "S7388C17");
    /*is_ambiguous_... S7388C12::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S7388C12*), ABISELECT(1184,876), "S7388C17");
    check_base_class_offset(lv, (S20570C5*)(S7388C6*)(S7388C12*), ABISELECT(1424,1048), "S7388C17");
    check_base_class_offset(lv, (S7388C6*)(S7388C12*), ABISELECT(1408,1044), "S7388C17");
    check_base_class_offset(lv, (S7388C12*), 0, "S7388C17");
    check_base_class_offset(lv, (S7388C18*), ABISELECT(2896,2124), "S7388C17");
    set_bf_and_test(lv, s7388c17f0, ABISELECT(1844,1356), 0, 5, 1, "S7388C17");
    set_bf_and_test(lv, s7388c17f0, ABISELECT(1844,1356), 0, 5, hide_sll(1LL<<4), "S7388C17");
    check_field_offset(lv, s7388c17f1, ABISELECT(1848,1360), "S7388C17.s7388c17f1");
    check_field_offset(lv, s7388c17f2, ABISELECT(1880,1376), "S7388C17.s7388c17f2");
    check_field_offset(lv, s7388c17f3, ABISELECT(1888,1384), "S7388C17.s7388c17f3");
    test_class_info(&lv, &cd_S7388C17);
    dp->~S7388C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7388C17(Test_S7388C17, "S7388C17", ABISELECT(3296,2404));

#else // __cplusplus

extern void _ZN8S7388C17C1Ev();
extern void _ZN8S7388C17D2Ev();
Name_Map name_map_S7388C17[] = {
  NSPAIR(_ZN8S7388C17C1Ev),
  NSPAIR(_ZN8S7388C17D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S7388C6;
extern VTBL_ENTRY _ZTI7S7388C6[];
extern  VTBL_ENTRY _ZTV7S7388C6[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S7388C6;
extern VTBL_ENTRY _ZTI7S7388C6[];
extern  VTBL_ENTRY _ZTV7S7388C6[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S7388C15;
extern VTBL_ENTRY _ZTI8S7388C15[];
extern  VTBL_ENTRY _ZTV8S7388C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7388C15[];
extern Class_Descriptor cd_S7388C13;
extern VTBL_ENTRY _ZTI8S7388C13[];
extern  VTBL_ENTRY _ZTV8S7388C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7388C13[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S7388C6;
extern VTBL_ENTRY _ZTI7S7388C6[];
extern  VTBL_ENTRY _ZTV7S7388C6[];
extern Class_Descriptor cd_S7388C12;
extern VTBL_ENTRY _ZTI8S7388C12[];
extern  VTBL_ENTRY _ZTV8S7388C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7388C12[];
extern Class_Descriptor cd_S7388C18;
extern VTBL_ENTRY _ZTI8S7388C18[];
extern  VTBL_ENTRY _ZTV8S7388C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7388C18[];
static Base_Class bases_S7388C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(1952,1408), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S7388C6,    ABISELECT(1936,1404), //bcp->offset
    15, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20570C5,    ABISELECT(2304,1668), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S7388C6,    ABISELECT(2288,1664), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(2672,1956), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S7388C15,    ABISELECT(2288,1664), //bcp->offset
    23, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7388C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(1184,876), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(1424,1048), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S7388C6,    ABISELECT(1408,1044), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7388C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7388C18,    ABISELECT(2896,2124), //bcp->offset
    32, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7388C17[];
extern void _ZN8S7388C17D1Ev();
extern void _ZN8S7388C17D0Ev();
extern void _ZN8S7388C132v5Ev();
extern void _ZN8S7388C122v6Ev();
extern void _ZN7S7388C62v2Ev();
extern void _ZN7S7388C62v3Ev();
extern void _ZN7S7388C62v4Ev();
extern void _ZN7S7388C62v2Ev();
extern void _ZN7S7388C62v3Ev();
extern void _ZN7S7388C62v4Ev();
extern void _ZN7S7388C62v2Ev();
extern void _ZN7S7388C62v3Ev();
extern void _ZN7S7388C62v4Ev();
static  VTBL_ENTRY vtc_S7388C17[] = {
  ABISELECT(2896,2124),
  ABISELECT(2288,1664),
  ABISELECT(1936,1404),
  ABISELECT(2672,1956),
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C17[0]),
  (VTBL_ENTRY)&_ZN8S7388C17D1Ev,
  (VTBL_ENTRY)&_ZN8S7388C17D0Ev,
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
  (VTBL_ENTRY)&_ZN8S7388C122v6Ev,
  ABISELECT(-1408,-1044),
  (VTBL_ENTRY)&(_ZTI8S7388C17[0]),
  (VTBL_ENTRY)&_ZN7S7388C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v3Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v4Ev,
  0,
  0,
  0,
  ABISELECT(-1936,-1404),
  (VTBL_ENTRY)&(_ZTI8S7388C17[0]),
  (VTBL_ENTRY)&_ZN7S7388C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v3Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v4Ev,
  0,
  0,
  0,
  ABISELECT(384,292),
  ABISELECT(-2288,-1664),
  (VTBL_ENTRY)&(_ZTI8S7388C17[0]),
  (VTBL_ENTRY)&_ZN7S7388C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v3Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v4Ev,
  ABISELECT(-224,-168),
  ABISELECT(-2896,-2124),
  (VTBL_ENTRY)&(_ZTI8S7388C17[0]),
};
extern VTBL_ENTRY _ZTV8S7388C17[];
extern void _ZN8S7388C12D1Ev();
extern void _ZN8S7388C12D0Ev();
extern void _ZN8S7388C132v5Ev();
extern void _ZN8S7388C122v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C12__8S7388C17[] = {
  ABISELECT(2672,1956),
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C12[0]),
  (VTBL_ENTRY)&_ZN8S7388C12D1Ev,
  (VTBL_ENTRY)&_ZN8S7388C12D0Ev,
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
  (VTBL_ENTRY)&_ZN8S7388C122v6Ev,
};
extern void _ZN8S7388C13D1Ev();
extern void _ZN8S7388C13D0Ev();
extern void _ZN8S7388C132v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C138S7388C12__8S7388C17[] = {
  ABISELECT(2672,1956),
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C13[0]),
  (VTBL_ENTRY)&_ZN8S7388C13D1Ev,
  (VTBL_ENTRY)&_ZN8S7388C13D0Ev,
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
};
extern void _ZN7S7388C62v2Ev();
extern void _ZN7S7388C62v3Ev();
extern void _ZN7S7388C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C15__8S7388C17[] = {
  ABISELECT(384,292),
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C15[0]),
  (VTBL_ENTRY)&_ZN7S7388C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v3Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S7388C18__8S7388C17[] = {
  ABISELECT(-224,-168),
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C18[0]),
};
static  VTT_ENTRY vtt_S7388C17[] = {
  {&(_ZTV8S7388C17[6]),  6,35},
  {&(_tg__ZTV8S7388C12__8S7388C17[3]),  3,7},
  {&(_tg__ZTV8S7388C138S7388C12__8S7388C17[3]),  3,6},
  {&(_ZTV8S7388C17[20]),  20,35},
  {&(_ZTV8S7388C17[29]),  29,35},
  {&(_ZTV8S7388C17[35]),  35,35},
  {&(_tg__ZTV8S7388C15__8S7388C17[3]),  3,6},
  {&(_tg__ZTV8S7388C18__8S7388C17[3]),  3,3},
};
extern VTBL_ENTRY _ZTI8S7388C17[];
extern  VTBL_ENTRY _ZTV8S7388C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7388C17[];
Class_Descriptor cd_S7388C17 = {  "S7388C17", // class name
  bases_S7388C17, 12,
  &(vtc_S7388C17[0]), // expected_vtbl_contents
  &(vtt_S7388C17[0]), // expected_vtt_contents
  ABISELECT(3296,2404), // object size
  NSPAIRA(_ZTI8S7388C17),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S7388C17),35, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7388C17),8, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7388C1  : S7388C2 , S7388C4 , virtual S7388C15 , S20570C5 , virtual S7388C17 {
  long double s7388c1f0;
  void *s7388c1f1;
  virtual  ~S7388C1(); // _ZN7S7388C1D2Ev
  S7388C1(); // tgen
};
//SIG(1 S7388C1) C1{ BC2{ VBC3{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} vd v1 Fl[3] FL Fs Fi FL Fi} BC4{ VBC5{ VBC6{ BC3 v2 v3 v4 FD Fs:16 Fi[7] FD Fc:6 FL:64 FL[2] Fi} FU7{ m FD Fp Fs:5 Fp FD Fp FD Fi[7] Fp Fp}[5] Fc[3] Fp Fp Fs[4] Fi[6] FC2 Fi Fp[8] Fi FU8{ m FD[10] Fs Fs Fp Fl Fp FD[9]} Fc Fi Fi[7]} VBC9{ BC2 BC10{ vd m Fp Fl Fi Fp} VBC11{ VBC3 BC12{ BC13{ VBC3 vd v5 FC3[5] FL Fs:5 Fc:0 Fp Fp Fi FL} BC3 BC6 v6 FD Fp Fs[6] Fp Fi FD Fi} BC13 vd FD[9] Fs} vd v7 Fp Fi FC14{ vd v9 FD Fi Fi Fc Fp FC10 Fi Fp Fi[2]} Fc[9] FU8 FL:64} vd v8 FC5 Fl Fi Fc Fc:4 FL} VBC15{ BC6 VBC3 FC16{} FL Fi:23 Fs Fi Fl[2]} BC3 VBC17{ VBC6 VBC15 BC12 VBC18{ VBC3 Fp Fi FC6 Fi Fp} vd Fc:5 Fl[4] Fc[6] FC10} vd FD Fp}


 S7388C1 ::~S7388C1(){ note_dtor("S7388C1", this);}
S7388C1 ::S7388C1(){ note_ctor("S7388C1", this);} // tgen

static void Test_S7388C1()
{
  extern Class_Descriptor cd_S7388C1;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(582,1684)];
    init_test(&cd_S7388C1, buf);
    S7388C1 *dp, &lv = *(dp=new (buf) S7388C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(9296,6732), "sizeof(S7388C1)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7388C1)");
    /*is_ambiguous_... S7388C1::S7388C2 */ AMB_check_base_class_offset(lv, (S20570C5*)(S7388C2*), ABISELECT(1536,1108), "S7388C1");
    check_base_class_offset(lv, (S20570C5*)(S7388C2*)(S7388C9*), ABISELECT(1536,1108), "S7388C1");
    /*is_ambiguous_... S7388C11::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S7388C11*), ABISELECT(1536,1108), "S7388C1");
    check_base_class_offset(lv, (S20570C5*)(S7388C13*)(S7388C12*)(S7388C11*), ABISELECT(1536,1108), "S7388C1");
    /*is_ambiguous_... S7388C11::S7388C13 */ AMB_check_base_class_offset(lv, (S20570C5*)(S7388C13*)(S7388C11*), ABISELECT(1536,1108), "S7388C1");
    /*is_ambiguous_... S7388C15::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S7388C15*), ABISELECT(1536,1108), "S7388C1");
    check_base_class_offset(lv, (S20570C5*)(S7388C13*)(S7388C12*)(S7388C17*), ABISELECT(1536,1108), "S7388C1");
    check_base_class_offset(lv, (S20570C5*)(S7388C18*), ABISELECT(1536,1108), "S7388C1");
    /*is_ambiguous_... S7388C1::S7388C2 */ AMB_check_base_class_offset(lv, (S7388C2*), 0, "S7388C1");
    /*is_ambiguous_... S7388C1::S7388C6 */ AMB_check_base_class_offset(lv, (S20570C5*)(S7388C6*), ABISELECT(2592,1876), "S7388C1");
    check_base_class_offset(lv, (S7388C6*)(S7388C5*), ABISELECT(2576,1872), "S7388C1");
    /*is_ambiguous_... S7388C17::S7388C6 */ AMB_check_base_class_offset(lv, (S7388C6*)(S7388C17*), ABISELECT(2576,1872), "S7388C1");
    check_base_class_offset(lv, (S7388C5*)(S7388C4*), ABISELECT(1760,1276), "S7388C1");
    check_base_class_offset(lv, (S7388C2*)(S7388C9*), ABISELECT(2928,2132), "S7388C1");
    check_base_class_offset(lv, (S20570C17*)(S7388C9*), ABISELECT(2992,2176), "S7388C1");
    check_base_class_offset(lv, (S7388C13*)(S7388C12*)(S7388C11*), ABISELECT(3376,2412), "S7388C1");
    /*is_ambiguous_... S7388C12::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S7388C12*)(S7388C11*), ABISELECT(4560,3288), "S7388C1");
    check_base_class_offset(lv, (S20570C5*)(S7388C6*)(S7388C12*)(S7388C11*), ABISELECT(4800,3460), "S7388C1");
    check_base_class_offset(lv, (S7388C6*)(S7388C12*)(S7388C11*), ABISELECT(4784,3456), "S7388C1");
    check_base_class_offset(lv, (S7388C12*)(S7388C11*), ABISELECT(3376,2412), "S7388C1");
    /*is_ambiguous_... S7388C11::S7388C13 */ AMB_check_base_class_offset(lv, (S7388C13*)(S7388C11*), ABISELECT(5232,3768), "S7388C1");
    check_base_class_offset(lv, (S7388C11*)(S7388C9*), ABISELECT(3376,2412), "S7388C1");
    check_base_class_offset(lv, (S7388C9*)(S7388C4*), ABISELECT(2928,2132), "S7388C1");
    check_base_class_offset(lv, (S7388C4*), ABISELECT(64,44), "S7388C1");
    check_base_class_offset(lv, (S20570C5*)(S7388C6*)(S7388C15*), ABISELECT(6592,4760), "S7388C1");
    check_base_class_offset(lv, (S7388C6*)(S7388C15*), ABISELECT(6576,4756), "S7388C1");
    check_base_class_offset(lv, (S7388C15*), ABISELECT(6576,4756), "S7388C1");
    check_base_class_offset(lv, (S7388C15*)(S7388C17*), ABISELECT(6576,4756), "S7388C1");
    /*is_ambiguous_... S7388C1::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*), ABISELECT(1280,924), "S7388C1");
    check_base_class_offset(lv, (S7388C13*)(S7388C12*)(S7388C17*), ABISELECT(6960,5048), "S7388C1");
    /*is_ambiguous_... S7388C12::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S7388C12*)(S7388C17*), ABISELECT(8144,5924), "S7388C1");
    check_base_class_offset(lv, (S20570C5*)(S7388C6*)(S7388C12*)(S7388C17*), ABISELECT(8384,6096), "S7388C1");
    check_base_class_offset(lv, (S7388C6*)(S7388C12*)(S7388C17*), ABISELECT(8368,6092), "S7388C1");
    check_base_class_offset(lv, (S7388C12*)(S7388C17*), ABISELECT(6960,5048), "S7388C1");
    check_base_class_offset(lv, (S7388C18*)(S7388C17*), ABISELECT(8896,6452), "S7388C1");
    check_base_class_offset(lv, (S7388C17*), ABISELECT(6960,5048), "S7388C1");
    check_field_offset(lv, s7388c1f0, ABISELECT(1504,1092), "S7388C1.s7388c1f0");
    check_field_offset(lv, s7388c1f1, ABISELECT(1520,1104), "S7388C1.s7388c1f1");
    test_class_info(&lv, &cd_S7388C1);
    dp->~S7388C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7388C1(Test_S7388C1, "S7388C1", ABISELECT(9296,6732));

#else // __cplusplus

extern void _ZN7S7388C1C1Ev();
extern void _ZN7S7388C1D2Ev();
Name_Map name_map_S7388C1[] = {
  NSPAIR(_ZN7S7388C1C1Ev),
  NSPAIR(_ZN7S7388C1D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S7388C2;
extern VTBL_ENTRY _ZTI7S7388C2[];
extern  VTBL_ENTRY _ZTV7S7388C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7388C2[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S7388C6;
extern VTBL_ENTRY _ZTI7S7388C6[];
extern  VTBL_ENTRY _ZTV7S7388C6[];
extern Class_Descriptor cd_S7388C5;
extern VTBL_ENTRY _ZTI7S7388C5[];
extern  VTBL_ENTRY _ZTV7S7388C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7388C5[];
extern Class_Descriptor cd_S7388C2;
extern VTBL_ENTRY _ZTI7S7388C2[];
extern  VTBL_ENTRY _ZTV7S7388C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7388C2[];
extern Class_Descriptor cd_S20570C17;
extern VTBL_ENTRY _ZTI9S20570C17[];
extern  VTBL_ENTRY _ZTV9S20570C17[];
extern Class_Descriptor cd_S7388C13;
extern VTBL_ENTRY _ZTI8S7388C13[];
extern  VTBL_ENTRY _ZTV8S7388C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7388C13[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S7388C6;
extern VTBL_ENTRY _ZTI7S7388C6[];
extern  VTBL_ENTRY _ZTV7S7388C6[];
extern Class_Descriptor cd_S7388C12;
extern VTBL_ENTRY _ZTI8S7388C12[];
extern  VTBL_ENTRY _ZTV8S7388C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7388C12[];
extern Class_Descriptor cd_S7388C13;
extern VTBL_ENTRY _ZTI8S7388C13[];
extern  VTBL_ENTRY _ZTV8S7388C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7388C13[];
extern Class_Descriptor cd_S7388C11;
extern VTBL_ENTRY _ZTI8S7388C11[];
extern  VTBL_ENTRY _ZTV8S7388C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7388C11[];
extern Class_Descriptor cd_S7388C9;
extern VTBL_ENTRY _ZTI7S7388C9[];
extern  VTBL_ENTRY _ZTV7S7388C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7388C9[];
extern Class_Descriptor cd_S7388C4;
extern VTBL_ENTRY _ZTI7S7388C4[];
extern  VTBL_ENTRY _ZTV7S7388C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7388C4[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S7388C6;
extern VTBL_ENTRY _ZTI7S7388C6[];
extern  VTBL_ENTRY _ZTV7S7388C6[];
extern Class_Descriptor cd_S7388C15;
extern VTBL_ENTRY _ZTI8S7388C15[];
extern  VTBL_ENTRY _ZTV8S7388C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7388C15[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S7388C13;
extern VTBL_ENTRY _ZTI8S7388C13[];
extern  VTBL_ENTRY _ZTV8S7388C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7388C13[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S7388C6;
extern VTBL_ENTRY _ZTI7S7388C6[];
extern  VTBL_ENTRY _ZTV7S7388C6[];
extern Class_Descriptor cd_S7388C12;
extern VTBL_ENTRY _ZTI8S7388C12[];
extern  VTBL_ENTRY _ZTV8S7388C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7388C12[];
extern Class_Descriptor cd_S7388C18;
extern VTBL_ENTRY _ZTI8S7388C18[];
extern  VTBL_ENTRY _ZTV8S7388C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7388C18[];
extern Class_Descriptor cd_S7388C17;
extern VTBL_ENTRY _ZTI8S7388C17[];
extern  VTBL_ENTRY _ZTV8S7388C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7388C17[];
static Base_Class bases_S7388C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(1536,1108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S7388C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20570C5,    ABISELECT(2592,1876), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S7388C6,    ABISELECT(2576,1872), //bcp->offset
    26, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S7388C5,    ABISELECT(1760,1276), //bcp->offset
    23, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    15, //immediately_derived
  0, 1},
  {&cd_S7388C2,    ABISELECT(2928,2132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20570C17,    ABISELECT(2992,2176), //bcp->offset
    45, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S7388C13,    ABISELECT(3376,2412), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(4560,3288), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(4800,3460), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7388C6,    ABISELECT(4784,3456), //bcp->offset
    62, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S7388C12,    ABISELECT(3376,2412), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    31, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S7388C13,    ABISELECT(5232,3768), //bcp->offset
    67, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S7388C11,    ABISELECT(3376,2412), //bcp->offset
    49, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    30, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S7388C9,    ABISELECT(2928,2132), //bcp->offset
    34, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    15, //immediately_derived
  0, 1},
  {&cd_S7388C4,    ABISELECT(64,44), //bcp->offset
    13, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20570C5,    ABISELECT(6592,4760), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S7388C6,    ABISELECT(6576,4756), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S7388C15,    ABISELECT(6576,4756), //bcp->offset
    73, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20570C5,    ABISELECT(1280,924), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7388C13,    ABISELECT(6960,5048), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    38, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(8144,5924), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(8384,6096), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S7388C6,    ABISELECT(8368,6092), //bcp->offset
    98, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S7388C12,    ABISELECT(6960,5048), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    37, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S7388C18,    ABISELECT(8896,6452), //bcp->offset
    103, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    42, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    26, //immediately_derived
  0, 1},
  {&cd_S7388C17,    ABISELECT(6960,5048), //bcp->offset
    82, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    36, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S7388C1[];
extern void _ZN7S7388C1D1Ev();
extern void _ZN7S7388C1D0Ev();
extern void _ZN7S7388C22v1Ev();
extern void ABISELECT(_ZThn64_N7S7388C1D1Ev,_ZThn44_N7S7388C1D1Ev)();
extern void ABISELECT(_ZThn64_N7S7388C1D0Ev,_ZThn44_N7S7388C1D0Ev)();
extern void _ZN7S7388C42v8Ev();
extern void _ZN7S7388C62v2Ev();
extern void _ZN7S7388C62v3Ev();
extern void _ZN7S7388C62v4Ev();
extern void ABISELECT(_ZTv0_n40_N7S7388C1D1Ev,_ZTv0_n20_N7S7388C1D1Ev)();
extern void ABISELECT(_ZThn2928_N7S7388C1D1Ev,_ZThn2132_N7S7388C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S7388C1D0Ev,_ZTv0_n20_N7S7388C1D0Ev)();
extern void ABISELECT(_ZThn2928_N7S7388C1D0Ev,_ZThn2132_N7S7388C1D0Ev)() __attribute__((weak));
extern void _ZN7S7388C22v1Ev();
extern void _ZN7S7388C92v7Ev();
extern void ABISELECT(_ZTvn64_n40_N7S7388C1D1Ev,_ZTvn44_n20_N7S7388C1D1Ev)();
extern void ABISELECT(_ZTvn64_n40_N7S7388C1D0Ev,_ZTvn44_n20_N7S7388C1D0Ev)();
extern void ABISELECT(_ZTv0_n32_N7S7388C1D1Ev,_ZTv0_n16_N7S7388C1D1Ev)();
extern void ABISELECT(_ZThn3376_N7S7388C1D1Ev,_ZThn2412_N7S7388C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S7388C1D0Ev,_ZTv0_n16_N7S7388C1D0Ev)();
extern void ABISELECT(_ZThn3376_N7S7388C1D0Ev,_ZThn2412_N7S7388C1D0Ev)() __attribute__((weak));
extern void _ZN8S7388C132v5Ev();
extern void _ZN8S7388C122v6Ev();
extern void _ZN7S7388C62v2Ev();
extern void _ZN7S7388C62v3Ev();
extern void _ZN7S7388C62v4Ev();
extern void ABISELECT(_ZTvn1856_n32_N7S7388C1D1Ev,_ZTvn1356_n16_N7S7388C1D1Ev)();
extern void ABISELECT(_ZTvn1856_n32_N7S7388C1D0Ev,_ZTvn1356_n16_N7S7388C1D0Ev)();
extern void _ZN8S7388C132v5Ev();
extern void _ZN7S7388C62v2Ev();
extern void _ZN7S7388C62v3Ev();
extern void _ZN7S7388C62v4Ev();
extern void ABISELECT(_ZTv0_n56_N7S7388C1D1Ev,_ZTv0_n28_N7S7388C1D1Ev)();
extern void ABISELECT(_ZThn6960_N7S7388C1D1Ev,_ZThn5048_N7S7388C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N7S7388C1D0Ev,_ZTv0_n28_N7S7388C1D0Ev)();
extern void ABISELECT(_ZThn6960_N7S7388C1D0Ev,_ZThn5048_N7S7388C1D0Ev)() __attribute__((weak));
extern void _ZN8S7388C132v5Ev();
extern void _ZN8S7388C122v6Ev();
extern void _ZN7S7388C62v2Ev();
extern void _ZN7S7388C62v3Ev();
extern void _ZN7S7388C62v4Ev();
static  VTBL_ENTRY vtc_S7388C1[] = {
  ABISELECT(8896,6452),
  ABISELECT(6960,5048),
  ABISELECT(6576,4756),
  ABISELECT(3376,2412),
  ABISELECT(2928,2132),
  ABISELECT(2576,1872),
  ABISELECT(1760,1276),
  ABISELECT(1536,1108),
  0,
  (VTBL_ENTRY)&(_ZTI7S7388C1[0]),
  (VTBL_ENTRY)&_ZN7S7388C1D1Ev,
  (VTBL_ENTRY)&_ZN7S7388C1D0Ev,
  (VTBL_ENTRY)&_ZN7S7388C22v1Ev,
  ABISELECT(3312,2368),
  ABISELECT(1472,1064),
  ABISELECT(2864,2088),
  ABISELECT(2512,1828),
  ABISELECT(1696,1232),
  ABISELECT(-64,-44),
  (VTBL_ENTRY)&(_ZTI7S7388C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S7388C1D1Ev,_ZThn44_N7S7388C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S7388C1D0Ev,_ZThn44_N7S7388C1D0Ev),
  (VTBL_ENTRY)&_ZN7S7388C42v8Ev,
  ABISELECT(816,596),
  ABISELECT(-1760,-1276),
  (VTBL_ENTRY)&(_ZTI7S7388C1[0]),
  0,
  0,
  0,
  ABISELECT(-2576,-1872),
  (VTBL_ENTRY)&(_ZTI7S7388C1[0]),
  (VTBL_ENTRY)&_ZN7S7388C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v3Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v4Ev,
  0,
  0,
  ABISELECT(-2928,-2132),
  ABISELECT(448,280),
  ABISELECT(-1392,-1024),
  ABISELECT(-2928,-2132),
  (VTBL_ENTRY)&(_ZTI7S7388C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7388C1D1Ev,_ZTv0_n20_N7S7388C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7388C1D0Ev,_ZTv0_n20_N7S7388C1D0Ev),
  (VTBL_ENTRY)&_ZN7S7388C22v1Ev,
  (VTBL_ENTRY)&_ZN7S7388C92v7Ev,
  ABISELECT(-2992,-2176),
  (VTBL_ENTRY)&(_ZTI7S7388C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn64_n40_N7S7388C1D1Ev,_ZTvn44_n20_N7S7388C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn64_n40_N7S7388C1D0Ev,_ZTvn44_n20_N7S7388C1D0Ev),
  ABISELECT(1408,1044),
  ABISELECT(1408,1044),
  ABISELECT(1408,1044),
  0,
  0,
  ABISELECT(-3376,-2412),
  ABISELECT(-1840,-1304),
  ABISELECT(-3376,-2412),
  (VTBL_ENTRY)&(_ZTI7S7388C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S7388C1D1Ev,_ZTv0_n16_N7S7388C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S7388C1D0Ev,_ZTv0_n16_N7S7388C1D0Ev),
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
  (VTBL_ENTRY)&_ZN8S7388C122v6Ev,
  ABISELECT(-4784,-3456),
  (VTBL_ENTRY)&(_ZTI7S7388C1[0]),
  (VTBL_ENTRY)&_ZN7S7388C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v3Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v4Ev,
  ABISELECT(-3696,-2660),
  ABISELECT(-5232,-3768),
  (VTBL_ENTRY)&(_ZTI7S7388C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1856_n32_N7S7388C1D1Ev,_ZTvn1356_n16_N7S7388C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1856_n32_N7S7388C1D0Ev,_ZTvn1356_n16_N7S7388C1D0Ev),
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
  0,
  0,
  0,
  ABISELECT(-5040,-3648),
  ABISELECT(-6576,-4756),
  (VTBL_ENTRY)&(_ZTI7S7388C1[0]),
  (VTBL_ENTRY)&_ZN7S7388C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v3Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v4Ev,
  ABISELECT(1408,1044),
  ABISELECT(1408,1044),
  ABISELECT(1408,1044),
  0,
  0,
  ABISELECT(-6960,-5048),
  ABISELECT(1936,1404),
  ABISELECT(-384,-292),
  ABISELECT(-4384,-3176),
  ABISELECT(-5424,-3940),
  ABISELECT(-6960,-5048),
  (VTBL_ENTRY)&(_ZTI7S7388C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7388C1D1Ev,_ZTv0_n28_N7S7388C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7388C1D0Ev,_ZTv0_n28_N7S7388C1D0Ev),
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
  (VTBL_ENTRY)&_ZN8S7388C122v6Ev,
  ABISELECT(-8368,-6092),
  (VTBL_ENTRY)&(_ZTI7S7388C1[0]),
  (VTBL_ENTRY)&_ZN7S7388C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v3Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v4Ev,
  ABISELECT(-7360,-5344),
  ABISELECT(-8896,-6452),
  (VTBL_ENTRY)&(_ZTI7S7388C1[0]),
};
extern VTBL_ENTRY _ZTV7S7388C1[];
extern void _ZN7S7388C2D1Ev();
extern void _ZN7S7388C2D0Ev();
extern void _ZN7S7388C22v1Ev();
static  VTBL_ENTRY _tg__ZTV7S7388C2__7S7388C1[] = {
  ABISELECT(1536,1108),
  0,
  (VTBL_ENTRY)&(_ZTI7S7388C2[0]),
  (VTBL_ENTRY)&_ZN7S7388C2D1Ev,
  (VTBL_ENTRY)&_ZN7S7388C2D0Ev,
  (VTBL_ENTRY)&_ZN7S7388C22v1Ev,
};
extern void _ZN7S7388C4D1Ev();
extern void _ZN7S7388C4D0Ev();
extern void _ZN7S7388C42v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7388C4__7S7388C1[] = {
  ABISELECT(3312,2368),
  ABISELECT(1472,1064),
  ABISELECT(2864,2088),
  ABISELECT(2512,1828),
  ABISELECT(1696,1232),
  0,
  (VTBL_ENTRY)&(_ZTI7S7388C4[0]),
  (VTBL_ENTRY)&_ZN7S7388C4D1Ev,
  (VTBL_ENTRY)&_ZN7S7388C4D0Ev,
  (VTBL_ENTRY)&_ZN7S7388C42v8Ev,
};
static  VTBL_ENTRY _tg__ZTV7S7388C5__7S7388C4__7S7388C1[] = {
  ABISELECT(816,596),
  ABISELECT(-1696,-1232),
  (VTBL_ENTRY)&(_ZTI7S7388C4[0]),
};
extern void _ZN7S7388C62v2Ev();
extern void _ZN7S7388C62v3Ev();
extern void _ZN7S7388C62v4Ev();
static  VTBL_ENTRY _tg__ZTV7S7388C6__7S7388C4__7S7388C1[] = {
  0,
  0,
  0,
  ABISELECT(-2512,-1828),
  (VTBL_ENTRY)&(_ZTI7S7388C4[0]),
  (VTBL_ENTRY)&_ZN7S7388C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v3Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v4Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S7388C4D1Ev,_ZTv0_n20_N7S7388C4D1Ev)();
extern void ABISELECT(_ZThn2864_N7S7388C4D1Ev,_ZThn2088_N7S7388C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S7388C4D0Ev,_ZTv0_n20_N7S7388C4D0Ev)();
extern void ABISELECT(_ZThn2864_N7S7388C4D0Ev,_ZThn2088_N7S7388C4D0Ev)() __attribute__((weak));
extern void _ZN7S7388C22v1Ev();
extern void _ZN7S7388C92v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7388C9__7S7388C4__7S7388C1[] = {
  0,
  0,
  ABISELECT(-2864,-2088),
  ABISELECT(448,280),
  ABISELECT(-1392,-1024),
  ABISELECT(-2864,-2088),
  (VTBL_ENTRY)&(_ZTI7S7388C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7388C4D1Ev,_ZTv0_n20_N7S7388C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7388C4D0Ev,_ZTv0_n20_N7S7388C4D0Ev),
  (VTBL_ENTRY)&_ZN7S7388C22v1Ev,
  (VTBL_ENTRY)&_ZN7S7388C92v7Ev,
};
extern void ABISELECT(_ZTvn64_n40_N7S7388C4D1Ev,_ZTvn44_n20_N7S7388C4D1Ev)();
extern void ABISELECT(_ZTvn64_n40_N7S7388C4D0Ev,_ZTvn44_n20_N7S7388C4D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20570C177S7388C9__7S7388C4__7S7388C1[] = {
  ABISELECT(-2928,-2132),
  (VTBL_ENTRY)&(_ZTI7S7388C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn64_n40_N7S7388C4D1Ev,_ZTvn44_n20_N7S7388C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn64_n40_N7S7388C4D0Ev,_ZTvn44_n20_N7S7388C4D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N7S7388C4D1Ev,_ZTv0_n16_N7S7388C4D1Ev)();
extern void ABISELECT(_ZThn3312_N7S7388C4D1Ev,_ZThn2368_N7S7388C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S7388C4D0Ev,_ZTv0_n16_N7S7388C4D0Ev)();
extern void ABISELECT(_ZThn3312_N7S7388C4D0Ev,_ZThn2368_N7S7388C4D0Ev)() __attribute__((weak));
extern void _ZN8S7388C132v5Ev();
extern void _ZN8S7388C122v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C11__7S7388C4__7S7388C1[] = {
  ABISELECT(1408,1044),
  ABISELECT(1408,1044),
  ABISELECT(1408,1044),
  0,
  0,
  ABISELECT(-3312,-2368),
  ABISELECT(-1840,-1304),
  ABISELECT(-3312,-2368),
  (VTBL_ENTRY)&(_ZTI7S7388C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S7388C4D1Ev,_ZTv0_n16_N7S7388C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S7388C4D0Ev,_ZTv0_n16_N7S7388C4D0Ev),
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
  (VTBL_ENTRY)&_ZN8S7388C122v6Ev,
};
extern void _ZN7S7388C62v2Ev();
extern void _ZN7S7388C62v3Ev();
extern void _ZN7S7388C62v4Ev();
static  VTBL_ENTRY _tg__ZTV7S7388C68S7388C128S7388C11__A1__7S7388C4__7S7388C1[] = {
  ABISELECT(-4720,-3412),
  (VTBL_ENTRY)&(_ZTI7S7388C4[0]),
  (VTBL_ENTRY)&_ZN7S7388C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v3Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v4Ev,
};
extern void ABISELECT(_ZTvn1856_n32_N7S7388C4D1Ev,_ZTvn1356_n16_N7S7388C4D1Ev)();
extern void ABISELECT(_ZTvn1856_n32_N7S7388C4D0Ev,_ZTvn1356_n16_N7S7388C4D0Ev)();
extern void _ZN8S7388C132v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C138S7388C11__A1__7S7388C4__7S7388C1[] = {
  ABISELECT(-3696,-2660),
  ABISELECT(-5168,-3724),
  (VTBL_ENTRY)&(_ZTI7S7388C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1856_n32_N7S7388C4D1Ev,_ZTvn1356_n16_N7S7388C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1856_n32_N7S7388C4D0Ev,_ZTvn1356_n16_N7S7388C4D0Ev),
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
};
static  VTBL_ENTRY _tg__ZTV7S7388C5__7S7388C1[] = {
  ABISELECT(816,596),
  0,
  (VTBL_ENTRY)&(_ZTI7S7388C5[0]),
};
extern void _ZN7S7388C62v2Ev();
extern void _ZN7S7388C62v3Ev();
extern void _ZN7S7388C62v4Ev();
static  VTBL_ENTRY _tg__ZTV7S7388C6__7S7388C5__7S7388C1[] = {
  0,
  0,
  0,
  ABISELECT(-816,-596),
  (VTBL_ENTRY)&(_ZTI7S7388C5[0]),
  (VTBL_ENTRY)&_ZN7S7388C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v3Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v4Ev,
};
extern void _ZN7S7388C9D1Ev();
extern void _ZN7S7388C9D0Ev();
extern void _ZN7S7388C22v1Ev();
extern void _ZN7S7388C92v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7388C9__7S7388C1[] = {
  ABISELECT(448,280),
  ABISELECT(-1392,-1024),
  0,
  (VTBL_ENTRY)&(_ZTI7S7388C9[0]),
  (VTBL_ENTRY)&_ZN7S7388C9D1Ev,
  (VTBL_ENTRY)&_ZN7S7388C9D0Ev,
  (VTBL_ENTRY)&_ZN7S7388C22v1Ev,
  (VTBL_ENTRY)&_ZN7S7388C92v7Ev,
};
extern void _ZN7S7388C2D1Ev();
extern void _ZN7S7388C2D0Ev();
extern void _ZN7S7388C22v1Ev();
static  VTBL_ENTRY _tg__ZTV7S7388C27S7388C9__A1__7S7388C1[] = {
  ABISELECT(-1392,-1024),
  0,
  (VTBL_ENTRY)&(_ZTI7S7388C2[0]),
  (VTBL_ENTRY)&_ZN7S7388C2D1Ev,
  (VTBL_ENTRY)&_ZN7S7388C2D0Ev,
  (VTBL_ENTRY)&_ZN7S7388C22v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N7S7388C9D1Ev,_ZTv0_n16_N7S7388C9D1Ev)();
extern void ABISELECT(_ZThn448_N7S7388C9D1Ev,_ZThn280_N7S7388C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S7388C9D0Ev,_ZTv0_n16_N7S7388C9D0Ev)();
extern void ABISELECT(_ZThn448_N7S7388C9D0Ev,_ZThn280_N7S7388C9D0Ev)() __attribute__((weak));
extern void _ZN8S7388C132v5Ev();
extern void _ZN8S7388C122v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C11__7S7388C9__7S7388C1[] = {
  ABISELECT(1408,1044),
  ABISELECT(1408,1044),
  ABISELECT(1408,1044),
  0,
  0,
  ABISELECT(-448,-280),
  ABISELECT(-1840,-1304),
  ABISELECT(-448,-280),
  (VTBL_ENTRY)&(_ZTI7S7388C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S7388C9D1Ev,_ZTv0_n16_N7S7388C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S7388C9D0Ev,_ZTv0_n16_N7S7388C9D0Ev),
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
  (VTBL_ENTRY)&_ZN8S7388C122v6Ev,
};
extern void _ZN7S7388C62v2Ev();
extern void _ZN7S7388C62v3Ev();
extern void _ZN7S7388C62v4Ev();
static  VTBL_ENTRY _tg__ZTV7S7388C68S7388C128S7388C11__7S7388C9__7S7388C1[] = {
  ABISELECT(-1856,-1324),
  (VTBL_ENTRY)&(_ZTI7S7388C9[0]),
  (VTBL_ENTRY)&_ZN7S7388C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v3Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v4Ev,
};
extern void ABISELECT(_ZTvn1856_n32_N7S7388C9D1Ev,_ZTvn1356_n16_N7S7388C9D1Ev)();
extern void ABISELECT(_ZTvn1856_n32_N7S7388C9D0Ev,_ZTvn1356_n16_N7S7388C9D0Ev)();
extern void _ZN8S7388C132v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C138S7388C11__A1__7S7388C9__7S7388C1[] = {
  ABISELECT(-3696,-2660),
  ABISELECT(-2304,-1636),
  (VTBL_ENTRY)&(_ZTI7S7388C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1856_n32_N7S7388C9D1Ev,_ZTvn1356_n16_N7S7388C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1856_n32_N7S7388C9D0Ev,_ZTvn1356_n16_N7S7388C9D0Ev),
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
};
extern void _ZN8S7388C11D1Ev();
extern void _ZN8S7388C11D0Ev();
extern void _ZN8S7388C132v5Ev();
extern void _ZN8S7388C122v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C11__7S7388C1[] = {
  ABISELECT(-1840,-1304),
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C11[0]),
  (VTBL_ENTRY)&_ZN8S7388C11D1Ev,
  (VTBL_ENTRY)&_ZN8S7388C11D0Ev,
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
  (VTBL_ENTRY)&_ZN8S7388C122v6Ev,
};
extern void _ZN8S7388C12D1Ev();
extern void _ZN8S7388C12D0Ev();
extern void _ZN8S7388C132v5Ev();
extern void _ZN8S7388C122v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C128S7388C11__7S7388C1[] = {
  ABISELECT(-1840,-1304),
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C12[0]),
  (VTBL_ENTRY)&_ZN8S7388C12D1Ev,
  (VTBL_ENTRY)&_ZN8S7388C12D0Ev,
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
  (VTBL_ENTRY)&_ZN8S7388C122v6Ev,
};
extern void _ZN8S7388C13D1Ev();
extern void _ZN8S7388C13D0Ev();
extern void _ZN8S7388C132v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C138S7388C128S7388C11__7S7388C1[] = {
  ABISELECT(-1840,-1304),
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C13[0]),
  (VTBL_ENTRY)&_ZN8S7388C13D1Ev,
  (VTBL_ENTRY)&_ZN8S7388C13D0Ev,
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
};
extern void _ZN8S7388C13D1Ev();
extern void _ZN8S7388C13D0Ev();
extern void _ZN8S7388C132v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C138S7388C11__A1__7S7388C1[] = {
  ABISELECT(-3696,-2660),
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C13[0]),
  (VTBL_ENTRY)&_ZN8S7388C13D1Ev,
  (VTBL_ENTRY)&_ZN8S7388C13D0Ev,
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
};
extern void ABISELECT(_ZThn1856_N8S7388C11D1Ev,_ZThn1356_N8S7388C11D1Ev)();
extern void ABISELECT(_ZThn1856_N8S7388C11D0Ev,_ZThn1356_N8S7388C11D0Ev)();
extern void _ZN8S7388C132v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C13__A1__8S7388C11__7S7388C1[] = {
  ABISELECT(-3696,-2660),
  ABISELECT(-1856,-1356),
  (VTBL_ENTRY)&(_ZTI8S7388C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1856_N8S7388C11D1Ev,_ZThn1356_N8S7388C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1856_N8S7388C11D0Ev,_ZThn1356_N8S7388C11D0Ev),
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
};
extern void _ZN7S7388C62v2Ev();
extern void _ZN7S7388C62v3Ev();
extern void _ZN7S7388C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C15__7S7388C1[] = {
  ABISELECT(-5040,-3648),
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C15[0]),
  (VTBL_ENTRY)&_ZN7S7388C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v3Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v4Ev,
};
extern void _ZN8S7388C17D1Ev();
extern void _ZN8S7388C17D0Ev();
extern void _ZN8S7388C132v5Ev();
extern void _ZN8S7388C122v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C17__7S7388C1[] = {
  ABISELECT(1936,1404),
  ABISELECT(-384,-292),
  ABISELECT(-4384,-3176),
  ABISELECT(-5424,-3940),
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C17[0]),
  (VTBL_ENTRY)&_ZN8S7388C17D1Ev,
  (VTBL_ENTRY)&_ZN8S7388C17D0Ev,
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
  (VTBL_ENTRY)&_ZN8S7388C122v6Ev,
};
extern void _ZN8S7388C12D1Ev();
extern void _ZN8S7388C12D0Ev();
extern void _ZN8S7388C132v5Ev();
extern void _ZN8S7388C122v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C128S7388C17__A1__7S7388C1[] = {
  ABISELECT(-5424,-3940),
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C12[0]),
  (VTBL_ENTRY)&_ZN8S7388C12D1Ev,
  (VTBL_ENTRY)&_ZN8S7388C12D0Ev,
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
  (VTBL_ENTRY)&_ZN8S7388C122v6Ev,
};
extern void _ZN8S7388C13D1Ev();
extern void _ZN8S7388C13D0Ev();
extern void _ZN8S7388C132v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C138S7388C128S7388C17__A2__7S7388C1[] = {
  ABISELECT(-5424,-3940),
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C13[0]),
  (VTBL_ENTRY)&_ZN8S7388C13D1Ev,
  (VTBL_ENTRY)&_ZN8S7388C13D0Ev,
  (VTBL_ENTRY)&_ZN8S7388C132v5Ev,
};
extern void _ZN7S7388C62v2Ev();
extern void _ZN7S7388C62v3Ev();
extern void _ZN7S7388C62v4Ev();
static  VTBL_ENTRY _tg__ZTV7S7388C6__8S7388C17__7S7388C1[] = {
  0,
  0,
  0,
  ABISELECT(4384,3176),
  (VTBL_ENTRY)&(_ZTI8S7388C17[0]),
  (VTBL_ENTRY)&_ZN7S7388C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v3Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v4Ev,
};
extern void _ZN7S7388C62v2Ev();
extern void _ZN7S7388C62v3Ev();
extern void _ZN7S7388C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S7388C15__8S7388C17__7S7388C1[] = {
  0,
  0,
  0,
  ABISELECT(-5040,-3648),
  ABISELECT(384,292),
  (VTBL_ENTRY)&(_ZTI8S7388C17[0]),
  (VTBL_ENTRY)&_ZN7S7388C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v3Ev,
  (VTBL_ENTRY)&_ZN7S7388C62v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S7388C18__8S7388C17__7S7388C1[] = {
  ABISELECT(-7360,-5344),
  ABISELECT(-1936,-1404),
  (VTBL_ENTRY)&(_ZTI8S7388C17[0]),
};
static  VTBL_ENTRY _tg__ZTV8S7388C18__7S7388C1[] = {
  ABISELECT(-7360,-5344),
  0,
  (VTBL_ENTRY)&(_ZTI8S7388C18[0]),
};
static  VTT_ENTRY vtt_S7388C1[] = {
  {&(_ZTV7S7388C1[10]),  10,106},
  {&(_tg__ZTV7S7388C2__7S7388C1[3]),  3,6},
  {&(_tg__ZTV7S7388C4__7S7388C1[7]),  7,10},
  {&(_tg__ZTV7S7388C5__7S7388C4__7S7388C1[3]),  3,3},
  {&(_tg__ZTV7S7388C6__7S7388C4__7S7388C1[5]),  5,8},
  {&(_tg__ZTV7S7388C9__7S7388C4__7S7388C1[7]),  7,11},
  {&(_tg__ZTV9S20570C177S7388C9__7S7388C4__7S7388C1[2]),  2,4},
  {&(_tg__ZTV8S7388C11__7S7388C4__7S7388C1[9]),  9,13},
  {&(_tg__ZTV7S7388C68S7388C128S7388C11__A1__7S7388C4__7S7388C1[2]),  2,5},
  {&(_tg__ZTV8S7388C138S7388C11__A1__7S7388C4__7S7388C1[3]),  3,6},
  {&(_ZTV7S7388C1[20]),  20,106},
  {&(_ZTV7S7388C1[26]),  26,106},
  {&(_ZTV7S7388C1[31]),  31,106},
  {&(_ZTV7S7388C1[41]),  41,106},
  {&(_ZTV7S7388C1[47]),  47,106},
  {&(_ZTV7S7388C1[58]),  58,106},
  {&(_ZTV7S7388C1[64]),  64,106},
  {&(_ZTV7S7388C1[70]),  70,106},
  {&(_ZTV7S7388C1[79]),  79,106},
  {&(_ZTV7S7388C1[94]),  94,106},
  {&(_ZTV7S7388C1[100]),  100,106},
  {&(_ZTV7S7388C1[106]),  106,106},
  {&(_tg__ZTV7S7388C5__7S7388C1[3]),  3,3},
  {&(_tg__ZTV7S7388C6__7S7388C5__7S7388C1[5]),  5,8},
  {&(_tg__ZTV7S7388C9__7S7388C1[4]),  4,8},
  {&(_tg__ZTV7S7388C27S7388C9__A1__7S7388C1[3]),  3,6},
  {&(_tg__ZTV8S7388C11__7S7388C9__7S7388C1[9]),  9,13},
  {&(_tg__ZTV7S7388C68S7388C128S7388C11__7S7388C9__7S7388C1[2]),  2,5},
  {&(_tg__ZTV8S7388C138S7388C11__A1__7S7388C9__7S7388C1[3]),  3,6},
  {&(_tg__ZTV8S7388C11__7S7388C1[3]),  3,7},
  {&(_tg__ZTV8S7388C128S7388C11__7S7388C1[3]),  3,7},
  {&(_tg__ZTV8S7388C138S7388C128S7388C11__7S7388C1[3]),  3,6},
  {&(_tg__ZTV8S7388C138S7388C11__A1__7S7388C1[3]),  3,6},
  {&(_tg__ZTV8S7388C13__A1__8S7388C11__7S7388C1[3]),  3,6},
  {&(_tg__ZTV8S7388C15__7S7388C1[3]),  3,6},
  {&(_tg__ZTV8S7388C17__7S7388C1[6]),  6,10},
  {&(_tg__ZTV8S7388C128S7388C17__A1__7S7388C1[3]),  3,7},
  {&(_tg__ZTV8S7388C138S7388C128S7388C17__A2__7S7388C1[3]),  3,6},
  {&(_tg__ZTV7S7388C6__8S7388C17__7S7388C1[5]),  5,8},
  {&(_tg__ZTV8S7388C15__8S7388C17__7S7388C1[6]),  6,9},
  {&(_tg__ZTV8S7388C18__8S7388C17__7S7388C1[3]),  3,3},
  {&(_tg__ZTV8S7388C18__7S7388C1[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7S7388C1[];
extern  VTBL_ENTRY _ZTV7S7388C1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7388C1[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S7388C9D0Ev,_ZTv0_n16_N7S7388C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn448_N7S7388C9D0Ev,_ZThn280_N7S7388C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S7388C9D1Ev,_ZTv0_n16_N7S7388C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn448_N7S7388C9D1Ev,_ZThn280_N7S7388C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S7388C4D0Ev,_ZTv0_n16_N7S7388C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3312_N7S7388C4D0Ev,_ZThn2368_N7S7388C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S7388C4D1Ev,_ZTv0_n16_N7S7388C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3312_N7S7388C4D1Ev,_ZThn2368_N7S7388C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7388C4D0Ev,_ZTv0_n20_N7S7388C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2864_N7S7388C4D0Ev,_ZThn2088_N7S7388C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7388C4D1Ev,_ZTv0_n20_N7S7388C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2864_N7S7388C4D1Ev,_ZThn2088_N7S7388C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7388C1D0Ev,_ZTv0_n28_N7S7388C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6960_N7S7388C1D0Ev,_ZThn5048_N7S7388C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7388C1D1Ev,_ZTv0_n28_N7S7388C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6960_N7S7388C1D1Ev,_ZThn5048_N7S7388C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S7388C1D0Ev,_ZTv0_n16_N7S7388C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3376_N7S7388C1D0Ev,_ZThn2412_N7S7388C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S7388C1D1Ev,_ZTv0_n16_N7S7388C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3376_N7S7388C1D1Ev,_ZThn2412_N7S7388C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7388C1D0Ev,_ZTv0_n20_N7S7388C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2928_N7S7388C1D0Ev,_ZThn2132_N7S7388C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7388C1D1Ev,_ZTv0_n20_N7S7388C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2928_N7S7388C1D1Ev,_ZThn2132_N7S7388C1D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7388C1 = {  "S7388C1", // class name
  bases_S7388C1, 27,
  &(vtc_S7388C1[0]), // expected_vtbl_contents
  &(vtt_S7388C1[0]), // expected_vtt_contents
  ABISELECT(9296,6732), // object size
  NSPAIRA(_ZTI7S7388C1),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV7S7388C1),106, //virtual function table var
  10, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7388C1),42, //virtual table table var
  19, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20571C4  : virtual S20570C5 {
  __tsi64 s20571c4f0[4];
  short s20571c4f1;
  int s20571c4f2;
  __tsi64 s20571c4f3;
  int s20571c4f4;
  virtual  ~S20571C4(); // _ZN8S20571C4D2Ev
  virtual void  v4(); // _ZN8S20571C42v4Ev
  S20571C4(); // tgen
};
//SIG(-1 S20571C4) C1{ VBC2{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} vd v1 FL[4] Fs Fi FL Fi}


 S20571C4 ::~S20571C4(){ note_dtor("S20571C4", this);}
void  S20571C4 ::v4(){vfunc_called(this, "_ZN8S20571C42v4Ev");}
S20571C4 ::S20571C4(){ note_ctor("S20571C4", this);} // tgen

static void Test_S20571C4()
{
  extern Class_Descriptor cd_S20571C4;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(19,57)];
    init_test(&cd_S20571C4, buf);
    S20571C4 *dp, &lv = *(dp=new (buf) S20571C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(288,224), "sizeof(S20571C4)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20571C4)");
    check_base_class_offset(lv, (S20570C5*), ABISELECT(64,56), "S20571C4");
    check_field_offset(lv, s20571c4f0, ABISELECT(8,4), "S20571C4.s20571c4f0");
    check_field_offset(lv, s20571c4f1, ABISELECT(40,36), "S20571C4.s20571c4f1");
    check_field_offset(lv, s20571c4f2, ABISELECT(44,40), "S20571C4.s20571c4f2");
    check_field_offset(lv, s20571c4f3, ABISELECT(48,44), "S20571C4.s20571c4f3");
    check_field_offset(lv, s20571c4f4, ABISELECT(56,52), "S20571C4.s20571c4f4");
    test_class_info(&lv, &cd_S20571C4);
    dp->~S20571C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20571C4(Test_S20571C4, "S20571C4", ABISELECT(288,224));

#else // __cplusplus

extern void _ZN8S20571C4C1Ev();
extern void _ZN8S20571C4D2Ev();
Name_Map name_map_S20571C4[] = {
  NSPAIR(_ZN8S20571C4C1Ev),
  NSPAIR(_ZN8S20571C4D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
static Base_Class bases_S20571C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(64,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20571C4[];
extern void _ZN8S20571C4D1Ev();
extern void _ZN8S20571C4D0Ev();
extern void _ZN8S20571C42v4Ev();
static  VTBL_ENTRY vtc_S20571C4[] = {
  ABISELECT(64,56),
  0,
  (VTBL_ENTRY)&(_ZTI8S20571C4[0]),
  (VTBL_ENTRY)&_ZN8S20571C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20571C4D0Ev,
  (VTBL_ENTRY)&_ZN8S20571C42v4Ev,
};
extern VTBL_ENTRY _ZTV8S20571C4[];
static  VTT_ENTRY vtt_S20571C4[] = {
  {&(_ZTV8S20571C4[3]),  3,6},
};
extern VTBL_ENTRY _ZTI8S20571C4[];
extern  VTBL_ENTRY _ZTV8S20571C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20571C4[];
Class_Descriptor cd_S20571C4 = {  "S20571C4", // class name
  bases_S20571C4, 1,
  &(vtc_S20571C4[0]), // expected_vtbl_contents
  &(vtt_S20571C4[0]), // expected_vtt_contents
  ABISELECT(288,224), // object size
  NSPAIRA(_ZTI8S20571C4),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S20571C4),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20571C4),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20571C3  : S20571C4 {
  int s20571c3f0;
  void *s20571c3f1;
  int s20571c3f2;
  long double s20571c3f3[9];
  long s20571c3f4;
  int s20571c3f5;
  __tsi64 s20571c3f6;
  void *s20571c3f7[5];
  __tsi64 s20571c3f8;
  virtual void  v5(); // _ZN8S20571C32v5Ev
  virtual void  v6(); // _ZN8S20571C32v6Ev
  ~S20571C3(); // tgen
  S20571C3(); // tgen
};
//SIG(-1 S20571C3) C1{ BC2{ VBC3{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} vd v3 FL[4] Fs Fi FL Fi} v1 v2 Fi Fp Fi FD[9] Fl Fi FL Fp[5] FL}


void  S20571C3 ::v5(){vfunc_called(this, "_ZN8S20571C32v5Ev");}
void  S20571C3 ::v6(){vfunc_called(this, "_ZN8S20571C32v6Ev");}
S20571C3 ::~S20571C3(){ note_dtor("S20571C3", this);} // tgen
S20571C3 ::S20571C3(){ note_ctor("S20571C3", this);} // tgen

static void Test_S20571C3()
{
  extern Class_Descriptor cd_S20571C3;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(34,98)];
    init_test(&cd_S20571C3, buf);
    S20571C3 *dp, &lv = *(dp=new (buf) S20571C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(528,388), "sizeof(S20571C3)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20571C3)");
    check_base_class_offset(lv, (S20570C5*)(S20571C4*), ABISELECT(304,220), "S20571C3");
    check_base_class_offset(lv, (S20571C4*), 0, "S20571C3");
    check_field_offset(lv, s20571c3f0, ABISELECT(60,56), "S20571C3.s20571c3f0");
    check_field_offset(lv, s20571c3f1, ABISELECT(64,60), "S20571C3.s20571c3f1");
    check_field_offset(lv, s20571c3f2, ABISELECT(72,64), "S20571C3.s20571c3f2");
    check_field_offset(lv, s20571c3f3, ABISELECT(80,68), "S20571C3.s20571c3f3");
    check_field_offset(lv, s20571c3f4, ABISELECT(224,176), "S20571C3.s20571c3f4");
    check_field_offset(lv, s20571c3f5, ABISELECT(232,180), "S20571C3.s20571c3f5");
    check_field_offset(lv, s20571c3f6, ABISELECT(240,184), "S20571C3.s20571c3f6");
    check_field_offset(lv, s20571c3f7, ABISELECT(248,192), "S20571C3.s20571c3f7");
    check_field_offset(lv, s20571c3f8, ABISELECT(288,212), "S20571C3.s20571c3f8");
    test_class_info(&lv, &cd_S20571C3);
    dp->~S20571C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20571C3(Test_S20571C3, "S20571C3", ABISELECT(528,388));

#else // __cplusplus

extern void _ZN8S20571C3C1Ev();
extern void _ZN8S20571C3D1Ev();
Name_Map name_map_S20571C3[] = {
  NSPAIR(_ZN8S20571C3C1Ev),
  NSPAIR(_ZN8S20571C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20571C4;
extern VTBL_ENTRY _ZTI8S20571C4[];
extern  VTBL_ENTRY _ZTV8S20571C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20571C4[];
static Base_Class bases_S20571C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(304,220), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20571C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20571C3[];
extern void _ZN8S20571C3D1Ev();
extern void _ZN8S20571C3D0Ev();
extern void _ZN8S20571C42v4Ev();
extern void _ZN8S20571C32v5Ev();
extern void _ZN8S20571C32v6Ev();
static  VTBL_ENTRY vtc_S20571C3[] = {
  ABISELECT(304,220),
  0,
  (VTBL_ENTRY)&(_ZTI8S20571C3[0]),
  (VTBL_ENTRY)&_ZN8S20571C3D1Ev,
  (VTBL_ENTRY)&_ZN8S20571C3D0Ev,
  (VTBL_ENTRY)&_ZN8S20571C42v4Ev,
  (VTBL_ENTRY)&_ZN8S20571C32v5Ev,
  (VTBL_ENTRY)&_ZN8S20571C32v6Ev,
};
extern VTBL_ENTRY _ZTV8S20571C3[];
extern void _ZN8S20571C4D1Ev();
extern void _ZN8S20571C4D0Ev();
extern void _ZN8S20571C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20571C4__8S20571C3[] = {
  ABISELECT(304,220),
  0,
  (VTBL_ENTRY)&(_ZTI8S20571C4[0]),
  (VTBL_ENTRY)&_ZN8S20571C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20571C4D0Ev,
  (VTBL_ENTRY)&_ZN8S20571C42v4Ev,
};
static  VTT_ENTRY vtt_S20571C3[] = {
  {&(_ZTV8S20571C3[3]),  3,8},
  {&(_tg__ZTV8S20571C4__8S20571C3[3]),  3,6},
};
extern VTBL_ENTRY _ZTI8S20571C3[];
extern  VTBL_ENTRY _ZTV8S20571C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20571C3[];
Class_Descriptor cd_S20571C3 = {  "S20571C3", // class name
  bases_S20571C3, 2,
  &(vtc_S20571C3[0]), // expected_vtbl_contents
  &(vtt_S20571C3[0]), // expected_vtt_contents
  ABISELECT(528,388), // object size
  NSPAIRA(_ZTI8S20571C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S20571C3),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20571C3),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20571C2  : virtual S20571C3 {
  int s20571c2f0:26;
  char s20571c2f1[2];
  virtual  ~S20571C2(); // _ZN8S20571C2D2Ev
  virtual void  v7(); // _ZN8S20571C22v7Ev
  S20571C2(); // tgen
};
//SIG(-1 S20571C2) C1{ VBC2{ BC3{ VBC4{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} vd v2 FL[4] Fs Fi FL Fi} v3 v4 Fi Fp Fi FD[9] Fl Fi FL Fp[5] FL} vd v1 Fi:26 Fc[2]}


 S20571C2 ::~S20571C2(){ note_dtor("S20571C2", this);}
void  S20571C2 ::v7(){vfunc_called(this, "_ZN8S20571C22v7Ev");}
S20571C2 ::S20571C2(){ note_ctor("S20571C2", this);} // tgen

static void Test_S20571C2()
{
  extern Class_Descriptor cd_S20571C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(35,101)];
    init_test(&cd_S20571C2, buf);
    S20571C2 *dp, &lv = *(dp=new (buf) S20571C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(544,400), "sizeof(S20571C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20571C2)");
    check_base_class_offset(lv, (S20570C5*)(S20571C4*)(S20571C3*), ABISELECT(320,232), "S20571C2");
    check_base_class_offset(lv, (S20571C4*)(S20571C3*), ABISELECT(16,12), "S20571C2");
    check_base_class_offset(lv, (S20571C3*), ABISELECT(16,12), "S20571C2");
    set_bf_and_test(lv, s20571c2f0, ABISELECT(8,4), 0, 26, 1, "S20571C2");
    set_bf_and_test(lv, s20571c2f0, ABISELECT(8,4), 0, 26, hide_sll(1LL<<25), "S20571C2");
    check_field_offset(lv, s20571c2f1, ABISELECT(12,8), "S20571C2.s20571c2f1");
    test_class_info(&lv, &cd_S20571C2);
    dp->~S20571C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20571C2(Test_S20571C2, "S20571C2", ABISELECT(544,400));

#else // __cplusplus

extern void _ZN8S20571C2C1Ev();
extern void _ZN8S20571C2D2Ev();
Name_Map name_map_S20571C2[] = {
  NSPAIR(_ZN8S20571C2C1Ev),
  NSPAIR(_ZN8S20571C2D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20571C4;
extern VTBL_ENTRY _ZTI8S20571C4[];
extern  VTBL_ENTRY _ZTV8S20571C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20571C4[];
extern Class_Descriptor cd_S20571C3;
extern VTBL_ENTRY _ZTI8S20571C3[];
extern  VTBL_ENTRY _ZTV8S20571C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20571C3[];
static Base_Class bases_S20571C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(320,232), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20571C4,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20571C3,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20571C2[];
extern void _ZN8S20571C2D1Ev();
extern void _ZN8S20571C2D0Ev();
extern void _ZN8S20571C22v7Ev();
extern void ABISELECT(_ZTv0_n32_N8S20571C2D1Ev,_ZTv0_n16_N8S20571C2D1Ev)();
extern void ABISELECT(_ZThn16_N8S20571C2D1Ev,_ZThn12_N8S20571C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20571C2D0Ev,_ZTv0_n16_N8S20571C2D0Ev)();
extern void ABISELECT(_ZThn16_N8S20571C2D0Ev,_ZThn12_N8S20571C2D0Ev)() __attribute__((weak));
extern void _ZN8S20571C42v4Ev();
extern void _ZN8S20571C32v5Ev();
extern void _ZN8S20571C32v6Ev();
static  VTBL_ENTRY vtc_S20571C2[] = {
  ABISELECT(320,232),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI8S20571C2[0]),
  (VTBL_ENTRY)&_ZN8S20571C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20571C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20571C22v7Ev,
  0,
  0,
  0,
  ABISELECT(-16,-12),
  ABISELECT(304,220),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8S20571C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20571C2D1Ev,_ZTv0_n16_N8S20571C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20571C2D0Ev,_ZTv0_n16_N8S20571C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20571C42v4Ev,
  (VTBL_ENTRY)&_ZN8S20571C32v5Ev,
  (VTBL_ENTRY)&_ZN8S20571C32v6Ev,
};
extern VTBL_ENTRY _ZTV8S20571C2[];
extern void _ZN8S20571C3D1Ev();
extern void _ZN8S20571C3D0Ev();
extern void _ZN8S20571C42v4Ev();
extern void _ZN8S20571C32v5Ev();
extern void _ZN8S20571C32v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20571C3__8S20571C2[] = {
  ABISELECT(304,220),
  0,
  (VTBL_ENTRY)&(_ZTI8S20571C3[0]),
  (VTBL_ENTRY)&_ZN8S20571C3D1Ev,
  (VTBL_ENTRY)&_ZN8S20571C3D0Ev,
  (VTBL_ENTRY)&_ZN8S20571C42v4Ev,
  (VTBL_ENTRY)&_ZN8S20571C32v5Ev,
  (VTBL_ENTRY)&_ZN8S20571C32v6Ev,
};
extern void _ZN8S20571C4D1Ev();
extern void _ZN8S20571C4D0Ev();
extern void _ZN8S20571C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20571C48S20571C3__8S20571C2[] = {
  ABISELECT(304,220),
  0,
  (VTBL_ENTRY)&(_ZTI8S20571C4[0]),
  (VTBL_ENTRY)&_ZN8S20571C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20571C4D0Ev,
  (VTBL_ENTRY)&_ZN8S20571C42v4Ev,
};
static  VTT_ENTRY vtt_S20571C2[] = {
  {&(_ZTV8S20571C2[4]),  4,19},
  {&(_ZTV8S20571C2[14]),  14,19},
  {&(_tg__ZTV8S20571C3__8S20571C2[3]),  3,8},
  {&(_tg__ZTV8S20571C48S20571C3__8S20571C2[3]),  3,6},
};
extern VTBL_ENTRY _ZTI8S20571C2[];
extern  VTBL_ENTRY _ZTV8S20571C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20571C2[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S20571C2D0Ev,_ZTv0_n16_N8S20571C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S20571C2D0Ev,_ZThn12_N8S20571C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S20571C2D1Ev,_ZTv0_n16_N8S20571C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S20571C2D1Ev,_ZThn12_N8S20571C2D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20571C2 = {  "S20571C2", // class name
  bases_S20571C2, 3,
  &(vtc_S20571C2[0]), // expected_vtbl_contents
  &(vtt_S20571C2[0]), // expected_vtt_contents
  ABISELECT(544,400), // object size
  NSPAIRA(_ZTI8S20571C2),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S20571C2),19, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20571C2),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20571C7  : S20570C5 {
  long double s20571c7f0;
  short s20571c7f1:16;
  int s20571c7f2[7];
  long double s20571c7f3;
  char s20571c7f4:6;
  int s20571c7f5:32;
  __tsi64 s20571c7f6[2];
  int s20571c7f7;
  virtual void  v9(); // _ZN8S20571C72v9Ev
  virtual void  v10(); // _ZN8S20571C73v10Ev
  virtual void  v11(); // _ZN8S20571C73v11Ev
  ~S20571C7(); // tgen
  S20571C7(); // tgen
};
//SIG(-1 S20571C7) C1{ BC2{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} v1 v2 v3 FD Fs:16 Fi[7] FD Fc:6 Fi:32 FL[2] Fi}


void  S20571C7 ::v9(){vfunc_called(this, "_ZN8S20571C72v9Ev");}
void  S20571C7 ::v10(){vfunc_called(this, "_ZN8S20571C73v10Ev");}
void  S20571C7 ::v11(){vfunc_called(this, "_ZN8S20571C73v11Ev");}
S20571C7 ::~S20571C7(){ note_dtor("S20571C7", this);} // tgen
S20571C7 ::S20571C7(){ note_ctor("S20571C7", this);} // tgen

static void Test_S20571C7()
{
  extern Class_Descriptor cd_S20571C7;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(22,65)];
    init_test(&cd_S20571C7, buf);
    S20571C7 *dp, &lv = *(dp=new (buf) S20571C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(336,256), "sizeof(S20571C7)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20571C7)");
    check_base_class_offset(lv, (S20570C5*), ABISELECT(16,4), "S20571C7");
    check_field_offset(lv, s20571c7f0, ABISELECT(240,172), "S20571C7.s20571c7f0");
    set_bf_and_test(lv, s20571c7f1, ABISELECT(256,184), 0, 16, 1, "S20571C7");
    set_bf_and_test(lv, s20571c7f1, ABISELECT(256,184), 0, 16, hide_sll(1LL<<15), "S20571C7");
    check_field_offset(lv, s20571c7f2, ABISELECT(260,188), "S20571C7.s20571c7f2");
    check_field_offset(lv, s20571c7f3, ABISELECT(288,216), "S20571C7.s20571c7f3");
    set_bf_and_test(lv, s20571c7f4, ABISELECT(304,228), 0, 6, 1, "S20571C7");
    set_bf_and_test(lv, s20571c7f4, ABISELECT(304,228), 0, 6, hide_sll(1LL<<5), "S20571C7");
    set_bf_and_test(lv, s20571c7f5, ABISELECT(308,232), 0, 32, 1, "S20571C7");
    set_bf_and_test(lv, s20571c7f5, ABISELECT(308,232), 0, 32, hide_sll(1LL<<31), "S20571C7");
    check_field_offset(lv, s20571c7f6, ABISELECT(312,236), "S20571C7.s20571c7f6");
    check_field_offset(lv, s20571c7f7, ABISELECT(328,252), "S20571C7.s20571c7f7");
    test_class_info(&lv, &cd_S20571C7);
    dp->~S20571C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20571C7(Test_S20571C7, "S20571C7", ABISELECT(336,256));

#else // __cplusplus

extern void _ZN8S20571C7C1Ev();
extern void _ZN8S20571C7D1Ev();
Name_Map name_map_S20571C7[] = {
  NSPAIR(_ZN8S20571C7C1Ev),
  NSPAIR(_ZN8S20571C7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
static Base_Class bases_S20571C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20571C7[];
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
static  VTBL_ENTRY vtc_S20571C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S20571C7[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
};
extern VTBL_ENTRY _ZTI8S20571C7[];
extern  VTBL_ENTRY _ZTV8S20571C7[];
Class_Descriptor cd_S20571C7 = {  "S20571C7", // class name
  bases_S20571C7, 1,
  &(vtc_S20571C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(336,256), // object size
  NSPAIRA(_ZTI8S20571C7),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S20571C7),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20571C6  : virtual S20570C5 {
  void *s20571c6f0;
  int s20571c6f1;
  ::S20571C7 s20571c6f2;
  int s20571c6f3;
  void *s20571c6f4;
  ~S20571C6(); // tgen
  S20571C6(); // tgen
};
//SIG(-1 S20571C6) C1{ VBC2{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} Fp Fi FC3{ BC2 v1 v2 v3 FD Fs:16 Fi[7] FD Fc:6 Fi:32 FL[2] Fi} Fi Fp}


S20571C6 ::~S20571C6(){ note_dtor("S20571C6", this);} // tgen
S20571C6 ::S20571C6(){ note_ctor("S20571C6", this);} // tgen

static void Test_S20571C6()
{
  extern Class_Descriptor cd_S20571C6;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(39,112)];
    init_test(&cd_S20571C6, buf);
    S20571C6 *dp, &lv = *(dp=new (buf) S20571C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(608,444), "sizeof(S20571C6)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20571C6)");
    check_base_class_offset(lv, (S20570C5*), ABISELECT(384,276), "S20571C6");
    check_field_offset(lv, s20571c6f0, ABISELECT(8,4), "S20571C6.s20571c6f0");
    check_field_offset(lv, s20571c6f1, ABISELECT(16,8), "S20571C6.s20571c6f1");
    check_field_offset(lv, s20571c6f2, ABISELECT(32,12), "S20571C6.s20571c6f2");
    check_field_offset(lv, s20571c6f3, ABISELECT(368,268), "S20571C6.s20571c6f3");
    check_field_offset(lv, s20571c6f4, ABISELECT(376,272), "S20571C6.s20571c6f4");
    test_class_info(&lv, &cd_S20571C6);
    dp->~S20571C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20571C6(Test_S20571C6, "S20571C6", ABISELECT(608,444));

#else // __cplusplus

extern void _ZN8S20571C6C1Ev();
extern void _ZN8S20571C6D1Ev();
Name_Map name_map_S20571C6[] = {
  NSPAIR(_ZN8S20571C6C1Ev),
  NSPAIR(_ZN8S20571C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
static Base_Class bases_S20571C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(384,276), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20571C6[];
static  VTBL_ENTRY vtc_S20571C6[] = {
  ABISELECT(384,276),
  0,
  (VTBL_ENTRY)&(_ZTI8S20571C6[0]),
};
extern VTBL_ENTRY _ZTV8S20571C6[];
static  VTT_ENTRY vtt_S20571C6[] = {
  {&(_ZTV8S20571C6[3]),  3,3},
};
extern VTBL_ENTRY _ZTI8S20571C6[];
extern  VTBL_ENTRY _ZTV8S20571C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20571C6[];
Class_Descriptor cd_S20571C6 = {  "S20571C6", // class name
  bases_S20571C6, 1,
  &(vtc_S20571C6[0]), // expected_vtbl_contents
  &(vtt_S20571C6[0]), // expected_vtt_contents
  ABISELECT(608,444), // object size
  NSPAIRA(_ZTI8S20571C6),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S20571C6),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20571C6),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20571C10  : virtual S20570C5 {
  ::S20570C5 s20571c10f0[5];
  __tsi64 s20571c10f1;
  short s20571c10f2:5;
  char  :0;
  void *s20571c10f4[2];
  int s20571c10f5;
  __tsi64 s20571c10f6;
  virtual  ~S20571C10(); // _ZN9S20571C10D2Ev
  virtual void  v8(); // _ZN9S20571C102v8Ev
  S20571C10(); // tgen
};
//SIG(-1 S20571C10) C1{ VBC2{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} vd v1 FC2[5] FL Fs:5 Fc:0 Fp[2] Fi FL}


 S20571C10 ::~S20571C10(){ note_dtor("S20571C10", this);}
void  S20571C10 ::v8(){vfunc_called(this, "_ZN9S20571C102v8Ev");}
S20571C10 ::S20571C10(){ note_ctor("S20571C10", this);} // tgen

static void Test_S20571C10()
{
  extern Class_Descriptor cd_S20571C10;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(89,262)];
    init_test(&cd_S20571C10, buf);
    S20571C10 *dp, &lv = *(dp=new (buf) S20571C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1408,1044), "sizeof(S20571C10)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20571C10)");
    check_base_class_offset(lv, (S20570C5*), ABISELECT(1184,876), "S20571C10");
    check_field_offset(lv, s20571c10f0, ABISELECT(16,4), "S20571C10.s20571c10f0");
    check_field_offset(lv, s20571c10f1, ABISELECT(1136,844), "S20571C10.s20571c10f1");
    set_bf_and_test(lv, s20571c10f2, ABISELECT(1144,852), 0, 5, 1, "S20571C10");
    set_bf_and_test(lv, s20571c10f2, ABISELECT(1144,852), 0, 5, hide_sll(1LL<<4), "S20571C10");
    check_field_offset(lv, s20571c10f4, ABISELECT(1152,856), "S20571C10.s20571c10f4");
    check_field_offset(lv, s20571c10f5, ABISELECT(1168,864), "S20571C10.s20571c10f5");
    check_field_offset(lv, s20571c10f6, ABISELECT(1176,868), "S20571C10.s20571c10f6");
    test_class_info(&lv, &cd_S20571C10);
    dp->~S20571C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20571C10(Test_S20571C10, "S20571C10", ABISELECT(1408,1044));

#else // __cplusplus

extern void _ZN9S20571C10C1Ev();
extern void _ZN9S20571C10D2Ev();
Name_Map name_map_S20571C10[] = {
  NSPAIR(_ZN9S20571C10C1Ev),
  NSPAIR(_ZN9S20571C10D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
static Base_Class bases_S20571C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(1184,876), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20571C10[];
extern void _ZN9S20571C10D1Ev();
extern void _ZN9S20571C10D0Ev();
extern void _ZN9S20571C102v8Ev();
static  VTBL_ENTRY vtc_S20571C10[] = {
  ABISELECT(1184,876),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C10[0]),
  (VTBL_ENTRY)&_ZN9S20571C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20571C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
};
extern VTBL_ENTRY _ZTV9S20571C10[];
static  VTT_ENTRY vtt_S20571C10[] = {
  {&(_ZTV9S20571C10[3]),  3,6},
};
extern VTBL_ENTRY _ZTI9S20571C10[];
extern  VTBL_ENTRY _ZTV9S20571C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C10[];
Class_Descriptor cd_S20571C10 = {  "S20571C10", // class name
  bases_S20571C10, 1,
  &(vtc_S20571C10[0]), // expected_vtbl_contents
  &(vtt_S20571C10[0]), // expected_vtt_contents
  ABISELECT(1408,1044), // object size
  NSPAIRA(_ZTI9S20571C10),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV9S20571C10),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20571C10),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20571C9  : S20571C10 , S20570C5 , S20571C7 {
  long double s20571c9f0;
  void *s20571c9f1;
  short s20571c9f2[6];
  void *s20571c9f3;
  int s20571c9f4;
  long double s20571c9f5;
  int s20571c9f6;
  virtual void  v12(); // _ZN8S20571C93v12Ev
  ~S20571C9(); // tgen
  S20571C9(); // tgen
};
//SIG(-1 S20571C9) C1{ BC2{ VBC3{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} vd v2 FC3[5] FL Fs:5 Fc:0 Fp[2] Fi FL} BC3 BC4{ BC3 v3 v4 v5 FD Fs:16 Fi[7] FD Fc:6 Fi:32 FL[2] Fi} v1 FD Fp Fs[6] Fp Fi FD Fi}


void  S20571C9 ::v12(){vfunc_called(this, "_ZN8S20571C93v12Ev");}
S20571C9 ::~S20571C9(){ note_dtor("S20571C9", this);} // tgen
S20571C9 ::S20571C9(){ note_ctor("S20571C9", this);} // tgen

static void Test_S20571C9()
{
  extern Class_Descriptor cd_S20571C9;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(130,381)];
    init_test(&cd_S20571C9, buf);
    S20571C9 *dp, &lv = *(dp=new (buf) S20571C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2064,1520), "sizeof(S20571C9)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20571C9)");
    check_base_class_offset(lv, (S20570C5*)(S20571C10*), ABISELECT(1840,1352), "S20571C9");
    check_base_class_offset(lv, (S20571C10*), 0, "S20571C9");
    /*is_ambiguous_... S20571C9::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*), ABISELECT(1184,876), "S20571C9");
    check_base_class_offset(lv, (S20570C5*)(S20571C7*), ABISELECT(1424,1048), "S20571C9");
    check_base_class_offset(lv, (S20571C7*), ABISELECT(1408,1044), "S20571C9");
    check_field_offset(lv, s20571c9f0, ABISELECT(1744,1300), "S20571C9.s20571c9f0");
    check_field_offset(lv, s20571c9f1, ABISELECT(1760,1312), "S20571C9.s20571c9f1");
    check_field_offset(lv, s20571c9f2, ABISELECT(1768,1316), "S20571C9.s20571c9f2");
    check_field_offset(lv, s20571c9f3, ABISELECT(1784,1328), "S20571C9.s20571c9f3");
    check_field_offset(lv, s20571c9f4, ABISELECT(1792,1332), "S20571C9.s20571c9f4");
    check_field_offset(lv, s20571c9f5, ABISELECT(1808,1336), "S20571C9.s20571c9f5");
    check_field_offset(lv, s20571c9f6, ABISELECT(1824,1348), "S20571C9.s20571c9f6");
    test_class_info(&lv, &cd_S20571C9);
    dp->~S20571C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20571C9(Test_S20571C9, "S20571C9", ABISELECT(2064,1520));

#else // __cplusplus

extern void _ZN8S20571C9C1Ev();
extern void _ZN8S20571C9D1Ev();
Name_Map name_map_S20571C9[] = {
  NSPAIR(_ZN8S20571C9C1Ev),
  NSPAIR(_ZN8S20571C9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20571C10;
extern VTBL_ENTRY _ZTI9S20571C10[];
extern  VTBL_ENTRY _ZTV9S20571C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C10[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20571C7;
extern VTBL_ENTRY _ZTI8S20571C7[];
extern  VTBL_ENTRY _ZTV8S20571C7[];
static Base_Class bases_S20571C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(1840,1352), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20571C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20570C5,    ABISELECT(1184,876), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20570C5,    ABISELECT(1424,1048), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20571C7,    ABISELECT(1408,1044), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20571C9[];
extern void _ZN8S20571C9D1Ev();
extern void _ZN8S20571C9D0Ev();
extern void _ZN9S20571C102v8Ev();
extern void _ZN8S20571C93v12Ev();
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
static  VTBL_ENTRY vtc_S20571C9[] = {
  ABISELECT(1840,1352),
  0,
  (VTBL_ENTRY)&(_ZTI8S20571C9[0]),
  (VTBL_ENTRY)&_ZN8S20571C9D1Ev,
  (VTBL_ENTRY)&_ZN8S20571C9D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20571C93v12Ev,
  ABISELECT(-1408,-1044),
  (VTBL_ENTRY)&(_ZTI8S20571C9[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
};
extern VTBL_ENTRY _ZTV8S20571C9[];
extern void _ZN9S20571C10D1Ev();
extern void _ZN9S20571C10D0Ev();
extern void _ZN9S20571C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C10__8S20571C9[] = {
  ABISELECT(1840,1352),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C10[0]),
  (VTBL_ENTRY)&_ZN9S20571C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20571C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
};
static  VTT_ENTRY vtt_S20571C9[] = {
  {&(_ZTV8S20571C9[3]),  3,12},
  {&(_tg__ZTV9S20571C10__8S20571C9[3]),  3,6},
};
extern VTBL_ENTRY _ZTI8S20571C9[];
extern  VTBL_ENTRY _ZTV8S20571C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20571C9[];
Class_Descriptor cd_S20571C9 = {  "S20571C9", // class name
  bases_S20571C9, 5,
  &(vtc_S20571C9[0]), // expected_vtbl_contents
  &(vtt_S20571C9[0]), // expected_vtt_contents
  ABISELECT(2064,1520), // object size
  NSPAIRA(_ZTI8S20571C9),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S20571C9),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20571C9),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20571C8  : virtual S20570C5 , S20571C9 , S20571C10 {
  long double s20571c8f0[9];
  short s20571c8f1;
  virtual  ~S20571C8(); // _ZN8S20571C8D2Ev
  S20571C8(); // tgen
};
//SIG(-1 S20571C8) C1{ VBC2{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} BC3{ BC4{ VBC2 vd v1 FC2[5] FL Fs:5 Fc:0 Fp[2] Fi FL} BC2 BC5{ BC2 v2 v3 v4 FD Fs:16 Fi[7] FD Fc:6 Fi:32 FL[2] Fi} v5 FD Fp Fs[6] Fp Fi FD Fi} BC4 vd FD[9] Fs}


 S20571C8 ::~S20571C8(){ note_dtor("S20571C8", this);}
S20571C8 ::S20571C8(){ note_ctor("S20571C8", this);} // tgen

static void Test_S20571C8()
{
  extern Class_Descriptor cd_S20571C8;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(214,628)];
    init_test(&cd_S20571C8, buf);
    S20571C8 *dp, &lv = *(dp=new (buf) S20571C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(3408,2508), "sizeof(S20571C8)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20571C8)");
    /*is_ambiguous_... S20571C8::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*), ABISELECT(3184,2340), "S20571C8");
    check_base_class_offset(lv, (S20570C5*)(S20571C10*)(S20571C9*), ABISELECT(3184,2340), "S20571C8");
    /*is_ambiguous_... S20571C8::S20571C10 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20571C10*), ABISELECT(3184,2340), "S20571C8");
    check_base_class_offset(lv, (S20571C10*)(S20571C9*), 0, "S20571C8");
    /*is_ambiguous_... S20571C9::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20571C9*), ABISELECT(1184,876), "S20571C8");
    check_base_class_offset(lv, (S20570C5*)(S20571C7*)(S20571C9*), ABISELECT(1424,1048), "S20571C8");
    check_base_class_offset(lv, (S20571C7*)(S20571C9*), ABISELECT(1408,1044), "S20571C8");
    check_base_class_offset(lv, (S20571C9*), 0, "S20571C8");
    /*is_ambiguous_... S20571C8::S20571C10 */ AMB_check_base_class_offset(lv, (S20571C10*), ABISELECT(1840,1352), "S20571C8");
    check_field_offset(lv, s20571c8f0, ABISELECT(3024,2228), "S20571C8.s20571c8f0");
    check_field_offset(lv, s20571c8f1, ABISELECT(3168,2336), "S20571C8.s20571c8f1");
    test_class_info(&lv, &cd_S20571C8);
    dp->~S20571C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20571C8(Test_S20571C8, "S20571C8", ABISELECT(3408,2508));

#else // __cplusplus

extern void _ZN8S20571C8C1Ev();
extern void _ZN8S20571C8D2Ev();
Name_Map name_map_S20571C8[] = {
  NSPAIR(_ZN8S20571C8C1Ev),
  NSPAIR(_ZN8S20571C8D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20571C10;
extern VTBL_ENTRY _ZTI9S20571C10[];
extern  VTBL_ENTRY _ZTV9S20571C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C10[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20571C7;
extern VTBL_ENTRY _ZTI8S20571C7[];
extern  VTBL_ENTRY _ZTV8S20571C7[];
extern Class_Descriptor cd_S20571C9;
extern VTBL_ENTRY _ZTI8S20571C9[];
extern  VTBL_ENTRY _ZTV8S20571C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20571C9[];
extern Class_Descriptor cd_S20571C10;
extern VTBL_ENTRY _ZTI9S20571C10[];
extern  VTBL_ENTRY _ZTV9S20571C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C10[];
static Base_Class bases_S20571C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(3184,2340), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20571C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(1184,876), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(1424,1048), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20571C7,    ABISELECT(1408,1044), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20571C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20571C10,    ABISELECT(1840,1352), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20571C8[];
extern void _ZN8S20571C8D1Ev();
extern void _ZN8S20571C8D0Ev();
extern void _ZN9S20571C102v8Ev();
extern void _ZN8S20571C93v12Ev();
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
extern void ABISELECT(_ZThn1840_N8S20571C8D1Ev,_ZThn1352_N8S20571C8D1Ev)();
extern void ABISELECT(_ZThn1840_N8S20571C8D0Ev,_ZThn1352_N8S20571C8D0Ev)();
extern void _ZN9S20571C102v8Ev();
static  VTBL_ENTRY vtc_S20571C8[] = {
  ABISELECT(3184,2340),
  0,
  (VTBL_ENTRY)&(_ZTI8S20571C8[0]),
  (VTBL_ENTRY)&_ZN8S20571C8D1Ev,
  (VTBL_ENTRY)&_ZN8S20571C8D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20571C93v12Ev,
  ABISELECT(-1408,-1044),
  (VTBL_ENTRY)&(_ZTI8S20571C8[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
  ABISELECT(1344,988),
  ABISELECT(-1840,-1352),
  (VTBL_ENTRY)&(_ZTI8S20571C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1840_N8S20571C8D1Ev,_ZThn1352_N8S20571C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1840_N8S20571C8D0Ev,_ZThn1352_N8S20571C8D0Ev),
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
};
extern VTBL_ENTRY _ZTV8S20571C8[];
extern void _ZN8S20571C9D1Ev();
extern void _ZN8S20571C9D0Ev();
extern void _ZN9S20571C102v8Ev();
extern void _ZN8S20571C93v12Ev();
static  VTBL_ENTRY _tg__ZTV8S20571C9__8S20571C8[] = {
  ABISELECT(3184,2340),
  0,
  (VTBL_ENTRY)&(_ZTI8S20571C9[0]),
  (VTBL_ENTRY)&_ZN8S20571C9D1Ev,
  (VTBL_ENTRY)&_ZN8S20571C9D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20571C93v12Ev,
};
extern void _ZN9S20571C10D1Ev();
extern void _ZN9S20571C10D0Ev();
extern void _ZN9S20571C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C108S20571C9__8S20571C8[] = {
  ABISELECT(3184,2340),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C10[0]),
  (VTBL_ENTRY)&_ZN9S20571C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20571C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
};
extern void _ZN9S20571C10D1Ev();
extern void _ZN9S20571C10D0Ev();
extern void _ZN9S20571C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C10__A1__8S20571C8[] = {
  ABISELECT(1344,988),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C10[0]),
  (VTBL_ENTRY)&_ZN9S20571C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20571C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
};
static  VTT_ENTRY vtt_S20571C8[] = {
  {&(_ZTV8S20571C8[3]),  3,18},
  {&(_tg__ZTV8S20571C9__8S20571C8[3]),  3,7},
  {&(_tg__ZTV9S20571C108S20571C9__8S20571C8[3]),  3,6},
  {&(_tg__ZTV9S20571C10__A1__8S20571C8[3]),  3,6},
  {&(_ZTV8S20571C8[15]),  15,18},
};
extern VTBL_ENTRY _ZTI8S20571C8[];
extern  VTBL_ENTRY _ZTV8S20571C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20571C8[];
Class_Descriptor cd_S20571C8 = {  "S20571C8", // class name
  bases_S20571C8, 7,
  &(vtc_S20571C8[0]), // expected_vtbl_contents
  &(vtt_S20571C8[0]), // expected_vtt_contents
  ABISELECT(3408,2508), // object size
  NSPAIRA(_ZTI8S20571C8),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S20571C8),18, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20571C8),5, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20571C12  : S20571C7 , virtual S20570C5 {
  ::S5217C45 s20571c12f0;
  __tsi64 s20571c12f1;
  int s20571c12f2:23;
  short s20571c12f3;
  int s20571c12f4;
  __tsi64 s20571c12f5[2];
  ~S20571C12(); // tgen
  S20571C12(); // tgen
};
//SIG(-1 S20571C12) C1{ BC2{ BC3{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} v1 v2 v3 FD Fs:16 Fi[7] FD Fc:6 Fi:32 FL[2] Fi} VBC3 FC4{} FL Fi:23 Fs Fi FL[2]}


S20571C12 ::~S20571C12(){ note_dtor("S20571C12", this);} // tgen
S20571C12 ::S20571C12(){ note_ctor("S20571C12", this);} // tgen

static void Test_S20571C12()
{
  extern Class_Descriptor cd_S20571C12;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(39,117)];
    init_test(&cd_S20571C12, buf);
    S20571C12 *dp, &lv = *(dp=new (buf) S20571C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(608,464), "sizeof(S20571C12)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20571C12)");
    check_base_class_offset(lv, (S20570C5*)(S20571C7*), ABISELECT(16,4), "S20571C12");
    check_base_class_offset(lv, (S20571C7*), 0, "S20571C12");
    /*is_ambiguous_... S20571C12::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*), ABISELECT(384,296), "S20571C12");
    check_field_offset(lv, s20571c12f0, ABISELECT(332,256), "S20571C12.s20571c12f0");
    check_field_offset(lv, s20571c12f1, ABISELECT(336,260), "S20571C12.s20571c12f1");
    set_bf_and_test(lv, s20571c12f2, ABISELECT(344,268), 0, 23, 1, "S20571C12");
    set_bf_and_test(lv, s20571c12f2, ABISELECT(344,268), 0, 23, hide_sll(1LL<<22), "S20571C12");
    check_field_offset(lv, s20571c12f3, ABISELECT(348,272), "S20571C12.s20571c12f3");
    check_field_offset(lv, s20571c12f4, ABISELECT(352,276), "S20571C12.s20571c12f4");
    check_field_offset(lv, s20571c12f5, ABISELECT(360,280), "S20571C12.s20571c12f5");
    test_class_info(&lv, &cd_S20571C12);
    dp->~S20571C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20571C12(Test_S20571C12, "S20571C12", ABISELECT(608,464));

#else // __cplusplus

extern void _ZN9S20571C12C1Ev();
extern void _ZN9S20571C12D1Ev();
Name_Map name_map_S20571C12[] = {
  NSPAIR(_ZN9S20571C12C1Ev),
  NSPAIR(_ZN9S20571C12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20571C7;
extern VTBL_ENTRY _ZTI8S20571C7[];
extern  VTBL_ENTRY _ZTV8S20571C7[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
static Base_Class bases_S20571C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20571C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20570C5,    ABISELECT(384,296), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20571C12[];
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
static  VTBL_ENTRY vtc_S20571C12[] = {
  ABISELECT(384,296),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C12[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
};
extern VTBL_ENTRY _ZTV9S20571C12[];
static  VTT_ENTRY vtt_S20571C12[] = {
  {&(_ZTV9S20571C12[3]),  3,6},
};
extern VTBL_ENTRY _ZTI9S20571C12[];
extern  VTBL_ENTRY _ZTV9S20571C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C12[];
Class_Descriptor cd_S20571C12 = {  "S20571C12", // class name
  bases_S20571C12, 3,
  &(vtc_S20571C12[0]), // expected_vtbl_contents
  &(vtt_S20571C12[0]), // expected_vtt_contents
  ABISELECT(608,464), // object size
  NSPAIRA(_ZTI9S20571C12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S20571C12),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20571C12),1, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20571C14  : S20571C10 , S20571C12 , S20571C4 {
  int  :0;
  ~S20571C14(); // tgen
  S20571C14(); // tgen
};
//SIG(-1 S20571C14) C1{ BC2{ VBC3{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} vd v1 FC3[5] FL Fs:5 Fc:0 Fp[2] Fi FL} BC4{ BC5{ BC3 v2 v3 v4 FD Fs:16 Fi[7] FD Fc:6 Fi:32 FL[2] Fi} VBC3 FC6{} FL Fi:23 Fs Fi FL[2]} BC7{ VBC3 vd v5 FL[4] Fs Fi FL Fi} Fi:0}


S20571C14 ::~S20571C14(){ note_dtor("S20571C14", this);} // tgen
S20571C14 ::S20571C14(){ note_ctor("S20571C14", this);} // tgen

static void Test_S20571C14()
{
  extern Class_Descriptor cd_S20571C14;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(117,350)];
    init_test(&cd_S20571C14, buf);
    S20571C14 *dp, &lv = *(dp=new (buf) S20571C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1856,1396), "sizeof(S20571C14)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20571C14)");
    check_base_class_offset(lv, (S20570C5*)(S20571C10*), ABISELECT(1632,1228), "S20571C14");
    /*is_ambiguous_... S20571C12::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20571C12*), ABISELECT(1632,1228), "S20571C14");
    check_base_class_offset(lv, (S20570C5*)(S20571C4*), ABISELECT(1632,1228), "S20571C14");
    check_base_class_offset(lv, (S20571C10*), 0, "S20571C14");
    check_base_class_offset(lv, (S20570C5*)(S20571C7*)(S20571C12*), ABISELECT(1200,880), "S20571C14");
    check_base_class_offset(lv, (S20571C7*)(S20571C12*), ABISELECT(1184,876), "S20571C14");
    check_base_class_offset(lv, (S20571C12*), ABISELECT(1184,876), "S20571C14");
    check_base_class_offset(lv, (S20571C4*), ABISELECT(1560,1172), "S20571C14");
    test_class_info(&lv, &cd_S20571C14);
    dp->~S20571C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20571C14(Test_S20571C14, "S20571C14", ABISELECT(1856,1396));

#else // __cplusplus

extern void _ZN9S20571C14C1Ev();
extern void _ZN9S20571C14D1Ev();
Name_Map name_map_S20571C14[] = {
  NSPAIR(_ZN9S20571C14C1Ev),
  NSPAIR(_ZN9S20571C14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20571C10;
extern VTBL_ENTRY _ZTI9S20571C10[];
extern  VTBL_ENTRY _ZTV9S20571C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C10[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20571C7;
extern VTBL_ENTRY _ZTI8S20571C7[];
extern  VTBL_ENTRY _ZTV8S20571C7[];
extern Class_Descriptor cd_S20571C12;
extern VTBL_ENTRY _ZTI9S20571C12[];
extern  VTBL_ENTRY _ZTV9S20571C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C12[];
extern Class_Descriptor cd_S20571C4;
extern VTBL_ENTRY _ZTI8S20571C4[];
extern  VTBL_ENTRY _ZTV8S20571C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20571C4[];
static Base_Class bases_S20571C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(1632,1228), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20571C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20570C5,    ABISELECT(1200,880), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20571C7,    ABISELECT(1184,876), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20571C12,    ABISELECT(1184,876), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20571C4,    ABISELECT(1560,1172), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20571C14[];
extern void _ZN9S20571C14D1Ev();
extern void _ZN9S20571C14D0Ev();
extern void _ZN9S20571C102v8Ev();
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
extern void ABISELECT(_ZThn1560_N9S20571C14D1Ev,_ZThn1172_N9S20571C14D1Ev)();
extern void ABISELECT(_ZThn1560_N9S20571C14D0Ev,_ZThn1172_N9S20571C14D0Ev)();
extern void _ZN8S20571C42v4Ev();
static  VTBL_ENTRY vtc_S20571C14[] = {
  ABISELECT(1632,1228),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C14[0]),
  (VTBL_ENTRY)&_ZN9S20571C14D1Ev,
  (VTBL_ENTRY)&_ZN9S20571C14D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
  ABISELECT(448,352),
  ABISELECT(-1184,-876),
  (VTBL_ENTRY)&(_ZTI9S20571C14[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
  ABISELECT(72,56),
  ABISELECT(-1560,-1172),
  (VTBL_ENTRY)&(_ZTI9S20571C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1560_N9S20571C14D1Ev,_ZThn1172_N9S20571C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1560_N9S20571C14D0Ev,_ZThn1172_N9S20571C14D0Ev),
  (VTBL_ENTRY)&_ZN8S20571C42v4Ev,
};
extern VTBL_ENTRY _ZTV9S20571C14[];
extern void _ZN9S20571C10D1Ev();
extern void _ZN9S20571C10D0Ev();
extern void _ZN9S20571C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C10__9S20571C14[] = {
  ABISELECT(1632,1228),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C10[0]),
  (VTBL_ENTRY)&_ZN9S20571C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20571C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
};
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C12__9S20571C14[] = {
  ABISELECT(448,352),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C12[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
};
extern void _ZN8S20571C4D1Ev();
extern void _ZN8S20571C4D0Ev();
extern void _ZN8S20571C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20571C4__9S20571C14[] = {
  ABISELECT(72,56),
  0,
  (VTBL_ENTRY)&(_ZTI8S20571C4[0]),
  (VTBL_ENTRY)&_ZN8S20571C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20571C4D0Ev,
  (VTBL_ENTRY)&_ZN8S20571C42v4Ev,
};
static  VTT_ENTRY vtt_S20571C14[] = {
  {&(_ZTV9S20571C14[3]),  3,18},
  {&(_tg__ZTV9S20571C10__9S20571C14[3]),  3,6},
  {&(_tg__ZTV9S20571C12__9S20571C14[3]),  3,6},
  {&(_tg__ZTV8S20571C4__9S20571C14[3]),  3,6},
  {&(_ZTV9S20571C14[9]),  9,18},
  {&(_ZTV9S20571C14[15]),  15,18},
};
extern VTBL_ENTRY _ZTI9S20571C14[];
extern  VTBL_ENTRY _ZTV9S20571C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C14[];
Class_Descriptor cd_S20571C14 = {  "S20571C14", // class name
  bases_S20571C14, 6,
  &(vtc_S20571C14[0]), // expected_vtbl_contents
  &(vtt_S20571C14[0]), // expected_vtt_contents
  ABISELECT(1856,1396), // object size
  NSPAIRA(_ZTI9S20571C14),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S20571C14),18, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20571C14),6, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20571C11  : S20571C10 , S20571C12 {
  void *s20571c11f0[13];
  int s20571c11f1[2];
  long s20571c11f2;
  void *s20571c11f3[2];
  short s20571c11f4;
  ::S20571C14 s20571c11f5;
  int s20571c11f6;
  ~S20571C11(); // tgen
  S20571C11(); // tgen
};
//SIG(-1 S20571C11) C1{ BC2{ VBC3{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} vd v1 FC3[5] FL Fs:5 Fc:0 Fp[2] Fi FL} BC4{ BC5{ BC3 v2 v3 v4 FD Fs:16 Fi[7] FD Fc:6 Fi:32 FL[2] Fi} VBC3 FC6{} FL Fi:23 Fs Fi FL[2]} Fp[13] Fi[2] Fl Fp[2] Fs FC7{ BC2 BC4 BC8{ VBC3 vd v5 FL[4] Fs Fi FL Fi} Fi:0} Fi}


S20571C11 ::~S20571C11(){ note_dtor("S20571C11", this);} // tgen
S20571C11 ::S20571C11(){ note_ctor("S20571C11", this);} // tgen

static void Test_S20571C11()
{
  extern Class_Descriptor cd_S20571C11;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(239,705)];
    init_test(&cd_S20571C11, buf);
    S20571C11 *dp, &lv = *(dp=new (buf) S20571C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(3808,2816), "sizeof(S20571C11)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20571C11)");
    check_base_class_offset(lv, (S20570C5*)(S20571C10*), ABISELECT(3584,2648), "S20571C11");
    /*is_ambiguous_... S20571C12::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20571C12*), ABISELECT(3584,2648), "S20571C11");
    check_base_class_offset(lv, (S20571C10*), 0, "S20571C11");
    check_base_class_offset(lv, (S20570C5*)(S20571C7*)(S20571C12*), ABISELECT(1200,880), "S20571C11");
    check_base_class_offset(lv, (S20571C7*)(S20571C12*), ABISELECT(1184,876), "S20571C11");
    check_base_class_offset(lv, (S20571C12*), ABISELECT(1184,876), "S20571C11");
    check_field_offset(lv, s20571c11f0, ABISELECT(1560,1172), "S20571C11.s20571c11f0");
    check_field_offset(lv, s20571c11f1, ABISELECT(1664,1224), "S20571C11.s20571c11f1");
    check_field_offset(lv, s20571c11f2, ABISELECT(1672,1232), "S20571C11.s20571c11f2");
    check_field_offset(lv, s20571c11f3, ABISELECT(1680,1236), "S20571C11.s20571c11f3");
    check_field_offset(lv, s20571c11f4, ABISELECT(1696,1244), "S20571C11.s20571c11f4");
    check_field_offset(lv, s20571c11f5, ABISELECT(1712,1248), "S20571C11.s20571c11f5");
    check_field_offset(lv, s20571c11f6, ABISELECT(3568,2644), "S20571C11.s20571c11f6");
    test_class_info(&lv, &cd_S20571C11);
    dp->~S20571C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20571C11(Test_S20571C11, "S20571C11", ABISELECT(3808,2816));

#else // __cplusplus

extern void _ZN9S20571C11C1Ev();
extern void _ZN9S20571C11D1Ev();
Name_Map name_map_S20571C11[] = {
  NSPAIR(_ZN9S20571C11C1Ev),
  NSPAIR(_ZN9S20571C11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20571C10;
extern VTBL_ENTRY _ZTI9S20571C10[];
extern  VTBL_ENTRY _ZTV9S20571C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C10[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20571C7;
extern VTBL_ENTRY _ZTI8S20571C7[];
extern  VTBL_ENTRY _ZTV8S20571C7[];
extern Class_Descriptor cd_S20571C12;
extern VTBL_ENTRY _ZTI9S20571C12[];
extern  VTBL_ENTRY _ZTV9S20571C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C12[];
static Base_Class bases_S20571C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(3584,2648), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20571C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20570C5,    ABISELECT(1200,880), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20571C7,    ABISELECT(1184,876), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20571C12,    ABISELECT(1184,876), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20571C11[];
extern void _ZN9S20571C11D1Ev();
extern void _ZN9S20571C11D0Ev();
extern void _ZN9S20571C102v8Ev();
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
static  VTBL_ENTRY vtc_S20571C11[] = {
  ABISELECT(3584,2648),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C11[0]),
  (VTBL_ENTRY)&_ZN9S20571C11D1Ev,
  (VTBL_ENTRY)&_ZN9S20571C11D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
  ABISELECT(2400,1772),
  ABISELECT(-1184,-876),
  (VTBL_ENTRY)&(_ZTI9S20571C11[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
};
extern VTBL_ENTRY _ZTV9S20571C11[];
extern void _ZN9S20571C10D1Ev();
extern void _ZN9S20571C10D0Ev();
extern void _ZN9S20571C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C10__9S20571C11[] = {
  ABISELECT(3584,2648),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C10[0]),
  (VTBL_ENTRY)&_ZN9S20571C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20571C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
};
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C12__9S20571C11[] = {
  ABISELECT(2400,1772),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C12[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
};
static  VTT_ENTRY vtt_S20571C11[] = {
  {&(_ZTV9S20571C11[3]),  3,12},
  {&(_tg__ZTV9S20571C10__9S20571C11[3]),  3,6},
  {&(_tg__ZTV9S20571C12__9S20571C11[3]),  3,6},
  {&(_ZTV9S20571C11[9]),  9,12},
};
extern VTBL_ENTRY _ZTI9S20571C11[];
extern  VTBL_ENTRY _ZTV9S20571C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C11[];
Class_Descriptor cd_S20571C11 = {  "S20571C11", // class name
  bases_S20571C11, 5,
  &(vtc_S20571C11[0]), // expected_vtbl_contents
  &(vtt_S20571C11[0]), // expected_vtt_contents
  ABISELECT(3808,2816), // object size
  NSPAIRA(_ZTI9S20571C11),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S20571C11),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20571C11),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20571C16  : virtual S20571C7 , virtual S20571C12 , S20571C9 , virtual S20571C6 {
  char s20571c16f0:5;
  __tsi64 s20571c16f1[4];
  char s20571c16f2[6];
  ::S20570C17 s20571c16f3;
  virtual  ~S20571C16(); // _ZN9S20571C16D2Ev
  S20571C16(); // tgen
};
//SIG(-1 S20571C16) C1{ VBC2{ BC3{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} v1 v2 v3 FD Fs:16 Fi[7] FD Fc:6 Fi:32 FL[2] Fi} VBC4{ BC2 VBC3 FC5{} FL Fi:23 Fs Fi FL[2]} BC6{ BC7{ VBC3 vd v4 FC3[5] FL Fs:5 Fc:0 Fp[2] Fi FL} BC3 BC2 v5 FD Fp Fs[6] Fp Fi FD Fi} VBC8{ VBC3 Fp Fi FC2 Fi Fp} vd Fc:5 FL[4] Fc[6] FC9{ vd m Fp Fl Fi Fp}}


 S20571C16 ::~S20571C16(){ note_dtor("S20571C16", this);}
S20571C16 ::S20571C16(){ note_ctor("S20571C16", this);} // tgen

static void Test_S20571C16()
{
  extern Class_Descriptor cd_S20571C16;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(204,604)];
    init_test(&cd_S20571C16, buf);
    S20571C16 *dp, &lv = *(dp=new (buf) S20571C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(3248,2412), "sizeof(S20571C16)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20571C16)");
    /*is_ambiguous_... S20571C16::S20571C7 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20571C7*), ABISELECT(1936,1420), "S20571C16");
    /*is_ambiguous_... S20571C16::S20571C7 */ AMB_check_base_class_offset(lv, (S20571C7*), ABISELECT(1920,1416), "S20571C16");
    check_base_class_offset(lv, (S20570C5*)(S20571C7*)(S20571C12*), ABISELECT(2272,1676), "S20571C16");
    check_base_class_offset(lv, (S20571C7*)(S20571C12*), ABISELECT(2256,1672), "S20571C16");
    /*is_ambiguous_... S20571C12::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20571C12*), ABISELECT(2640,1968), "S20571C16");
    check_base_class_offset(lv, (S20570C5*)(S20571C10*)(S20571C9*), ABISELECT(2640,1968), "S20571C16");
    check_base_class_offset(lv, (S20570C5*)(S20571C6*), ABISELECT(2640,1968), "S20571C16");
    check_base_class_offset(lv, (S20571C12*), ABISELECT(2256,1672), "S20571C16");
    check_base_class_offset(lv, (S20571C10*)(S20571C9*), 0, "S20571C16");
    /*is_ambiguous_... S20571C9::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20571C9*), ABISELECT(1184,876), "S20571C16");
    check_base_class_offset(lv, (S20570C5*)(S20571C7*)(S20571C9*), ABISELECT(1424,1048), "S20571C16");
    check_base_class_offset(lv, (S20571C7*)(S20571C9*), ABISELECT(1408,1044), "S20571C16");
    check_base_class_offset(lv, (S20571C9*), 0, "S20571C16");
    check_base_class_offset(lv, (S20571C6*), ABISELECT(2864,2136), "S20571C16");
    set_bf_and_test(lv, s20571c16f0, ABISELECT(1828,1352), 0, 5, 1, "S20571C16");
    set_bf_and_test(lv, s20571c16f0, ABISELECT(1828,1352), 0, 5, hide_sll(1LL<<4), "S20571C16");
    check_field_offset(lv, s20571c16f1, ABISELECT(1832,1356), "S20571C16.s20571c16f1");
    check_field_offset(lv, s20571c16f2, ABISELECT(1864,1388), "S20571C16.s20571c16f2");
    check_field_offset(lv, s20571c16f3, ABISELECT(1872,1396), "S20571C16.s20571c16f3");
    test_class_info(&lv, &cd_S20571C16);
    dp->~S20571C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20571C16(Test_S20571C16, "S20571C16", ABISELECT(3248,2412));

#else // __cplusplus

extern void _ZN9S20571C16C1Ev();
extern void _ZN9S20571C16D2Ev();
Name_Map name_map_S20571C16[] = {
  NSPAIR(_ZN9S20571C16C1Ev),
  NSPAIR(_ZN9S20571C16D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20571C7;
extern VTBL_ENTRY _ZTI8S20571C7[];
extern  VTBL_ENTRY _ZTV8S20571C7[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20571C7;
extern VTBL_ENTRY _ZTI8S20571C7[];
extern  VTBL_ENTRY _ZTV8S20571C7[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20571C12;
extern VTBL_ENTRY _ZTI9S20571C12[];
extern  VTBL_ENTRY _ZTV9S20571C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C12[];
extern Class_Descriptor cd_S20571C10;
extern VTBL_ENTRY _ZTI9S20571C10[];
extern  VTBL_ENTRY _ZTV9S20571C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C10[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20571C7;
extern VTBL_ENTRY _ZTI8S20571C7[];
extern  VTBL_ENTRY _ZTV8S20571C7[];
extern Class_Descriptor cd_S20571C9;
extern VTBL_ENTRY _ZTI8S20571C9[];
extern  VTBL_ENTRY _ZTV8S20571C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20571C9[];
extern Class_Descriptor cd_S20571C6;
extern VTBL_ENTRY _ZTI8S20571C6[];
extern  VTBL_ENTRY _ZTV8S20571C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20571C6[];
static Base_Class bases_S20571C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(1936,1420), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20571C7,    ABISELECT(1920,1416), //bcp->offset
    15, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20570C5,    ABISELECT(2272,1676), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20571C7,    ABISELECT(2256,1672), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(2640,1968), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S20571C12,    ABISELECT(2256,1672), //bcp->offset
    23, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20571C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(1184,876), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(1424,1048), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20571C7,    ABISELECT(1408,1044), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20571C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20571C6,    ABISELECT(2864,2136), //bcp->offset
    32, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20571C16[];
extern void _ZN9S20571C16D1Ev();
extern void _ZN9S20571C16D0Ev();
extern void _ZN9S20571C102v8Ev();
extern void _ZN8S20571C93v12Ev();
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
static  VTBL_ENTRY vtc_S20571C16[] = {
  ABISELECT(2864,2136),
  ABISELECT(2256,1672),
  ABISELECT(1920,1416),
  ABISELECT(2640,1968),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C16[0]),
  (VTBL_ENTRY)&_ZN9S20571C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20571C16D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20571C93v12Ev,
  ABISELECT(-1408,-1044),
  (VTBL_ENTRY)&(_ZTI9S20571C16[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
  0,
  0,
  0,
  ABISELECT(-1920,-1416),
  (VTBL_ENTRY)&(_ZTI9S20571C16[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
  0,
  0,
  0,
  ABISELECT(384,296),
  ABISELECT(-2256,-1672),
  (VTBL_ENTRY)&(_ZTI9S20571C16[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
  ABISELECT(-224,-168),
  ABISELECT(-2864,-2136),
  (VTBL_ENTRY)&(_ZTI9S20571C16[0]),
};
extern VTBL_ENTRY _ZTV9S20571C16[];
extern void _ZN8S20571C9D1Ev();
extern void _ZN8S20571C9D0Ev();
extern void _ZN9S20571C102v8Ev();
extern void _ZN8S20571C93v12Ev();
static  VTBL_ENTRY _tg__ZTV8S20571C9__9S20571C16[] = {
  ABISELECT(2640,1968),
  0,
  (VTBL_ENTRY)&(_ZTI8S20571C9[0]),
  (VTBL_ENTRY)&_ZN8S20571C9D1Ev,
  (VTBL_ENTRY)&_ZN8S20571C9D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20571C93v12Ev,
};
extern void _ZN9S20571C10D1Ev();
extern void _ZN9S20571C10D0Ev();
extern void _ZN9S20571C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C108S20571C9__9S20571C16[] = {
  ABISELECT(2640,1968),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C10[0]),
  (VTBL_ENTRY)&_ZN9S20571C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20571C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
};
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C12__9S20571C16[] = {
  ABISELECT(384,296),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C12[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20571C6__9S20571C16[] = {
  ABISELECT(-224,-168),
  0,
  (VTBL_ENTRY)&(_ZTI8S20571C6[0]),
};
static  VTT_ENTRY vtt_S20571C16[] = {
  {&(_ZTV9S20571C16[6]),  6,35},
  {&(_tg__ZTV8S20571C9__9S20571C16[3]),  3,7},
  {&(_tg__ZTV9S20571C108S20571C9__9S20571C16[3]),  3,6},
  {&(_ZTV9S20571C16[20]),  20,35},
  {&(_ZTV9S20571C16[29]),  29,35},
  {&(_ZTV9S20571C16[35]),  35,35},
  {&(_tg__ZTV9S20571C12__9S20571C16[3]),  3,6},
  {&(_tg__ZTV8S20571C6__9S20571C16[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20571C16[];
extern  VTBL_ENTRY _ZTV9S20571C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C16[];
Class_Descriptor cd_S20571C16 = {  "S20571C16", // class name
  bases_S20571C16, 12,
  &(vtc_S20571C16[0]), // expected_vtbl_contents
  &(vtt_S20571C16[0]), // expected_vtt_contents
  ABISELECT(3248,2412), // object size
  NSPAIRA(_ZTI9S20571C16),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S20571C16),35, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20571C16),8, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20571C18  : S20571C16 , virtual S20571C4 {
  short s20571c18f0;
  char s20571c18f1;
  short s20571c18f2[5];
  ::S20571C10 s20571c18f3;
  short s20571c18f4:16;
  int s20571c18f5;
  virtual void  v14(); // _ZN9S20571C183v14Ev
  virtual void  v15(); // _ZN9S20571C183v15Ev
  virtual void  v16(); // _ZN9S20571C183v16Ev
  virtual void  v17(); // _ZN9S20571C183v17Ev
  virtual void  v18(); // _ZN9S20571C183v18Ev
  ~S20571C18(); // tgen
  S20571C18(); // tgen
};
//SIG(-1 S20571C18) C1{ BC2{ VBC3{ BC4{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} v6 v7 v8 FD Fs:16 Fi[7] FD Fc:6 Fi:32 FL[2] Fi} VBC5{ BC3 VBC4 FC6{} FL Fi:23 Fs Fi FL[2]} BC7{ BC8{ VBC4 vd v9 FC4[5] FL Fs:5 Fc:0 Fp[2] Fi FL} BC4 BC3 v10 FD Fp Fs[6] Fp Fi FD Fi} VBC9{ VBC4 Fp Fi FC3 Fi Fp} vd Fc:5 FL[4] Fc[6] FC10{ vd m Fp Fl Fi Fp}} VBC11{ VBC4 vd v11 FL[4] Fs Fi FL Fi} v1 v2 v3 v4 v5 Fs Fc Fs[5] FC8 Fs:16 Fi}


void  S20571C18 ::v14(){vfunc_called(this, "_ZN9S20571C183v14Ev");}
void  S20571C18 ::v15(){vfunc_called(this, "_ZN9S20571C183v15Ev");}
void  S20571C18 ::v16(){vfunc_called(this, "_ZN9S20571C183v16Ev");}
void  S20571C18 ::v17(){vfunc_called(this, "_ZN9S20571C183v17Ev");}
void  S20571C18 ::v18(){vfunc_called(this, "_ZN9S20571C183v18Ev");}
S20571C18 ::~S20571C18(){ note_dtor("S20571C18", this);} // tgen
S20571C18 ::S20571C18(){ note_ctor("S20571C18", this);} // tgen

static void Test_S20571C18()
{
  extern Class_Descriptor cd_S20571C18;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(298,885)];
    init_test(&cd_S20571C18, buf);
    S20571C18 *dp, &lv = *(dp=new (buf) S20571C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(4752,3536), "sizeof(S20571C18)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20571C18)");
    /*is_ambiguous_... S20571C18::S20571C7 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20571C7*), ABISELECT(3376,2488), "S20571C18");
    /*is_ambiguous_... S20571C16::S20571C7 */ AMB_check_base_class_offset(lv, (S20571C7*)(S20571C16*), ABISELECT(3360,2484), "S20571C18");
    check_base_class_offset(lv, (S20570C5*)(S20571C7*)(S20571C12*), ABISELECT(3712,2744), "S20571C18");
    check_base_class_offset(lv, (S20571C7*)(S20571C12*), ABISELECT(3696,2740), "S20571C18");
    /*is_ambiguous_... S20571C12::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20571C12*), ABISELECT(4080,3036), "S20571C18");
    check_base_class_offset(lv, (S20570C5*)(S20571C10*)(S20571C9*)(S20571C16*), ABISELECT(4080,3036), "S20571C18");
    check_base_class_offset(lv, (S20570C5*)(S20571C6*), ABISELECT(4080,3036), "S20571C18");
    check_base_class_offset(lv, (S20570C5*)(S20571C4*), ABISELECT(4080,3036), "S20571C18");
    check_base_class_offset(lv, (S20571C12*)(S20571C16*), ABISELECT(3696,2740), "S20571C18");
    check_base_class_offset(lv, (S20571C10*)(S20571C9*)(S20571C16*), 0, "S20571C18");
    /*is_ambiguous_... S20571C9::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20571C9*)(S20571C16*), ABISELECT(1184,876), "S20571C18");
    check_base_class_offset(lv, (S20570C5*)(S20571C7*)(S20571C9*)(S20571C16*), ABISELECT(1424,1048), "S20571C18");
    check_base_class_offset(lv, (S20571C7*)(S20571C9*)(S20571C16*), ABISELECT(1408,1044), "S20571C18");
    check_base_class_offset(lv, (S20571C9*)(S20571C16*), 0, "S20571C18");
    check_base_class_offset(lv, (S20571C6*)(S20571C16*), ABISELECT(4304,3204), "S20571C18");
    check_base_class_offset(lv, (S20571C16*), 0, "S20571C18");
    check_base_class_offset(lv, (S20571C4*), ABISELECT(4688,3480), "S20571C18");
    check_field_offset(lv, s20571c18f0, ABISELECT(1912,1416), "S20571C18.s20571c18f0");
    check_field_offset(lv, s20571c18f1, ABISELECT(1914,1418), "S20571C18.s20571c18f1");
    check_field_offset(lv, s20571c18f2, ABISELECT(1916,1420), "S20571C18.s20571c18f2");
    check_field_offset(lv, s20571c18f3, ABISELECT(1936,1432), "S20571C18.s20571c18f3");
    set_bf_and_test(lv, s20571c18f4, ABISELECT(3344,2476), 0, 16, 1, "S20571C18");
    set_bf_and_test(lv, s20571c18f4, ABISELECT(3344,2476), 0, 16, hide_sll(1LL<<15), "S20571C18");
    check_field_offset(lv, s20571c18f5, ABISELECT(3348,2480), "S20571C18.s20571c18f5");
    test_class_info(&lv, &cd_S20571C18);
    dp->~S20571C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20571C18(Test_S20571C18, "S20571C18", ABISELECT(4752,3536));

#else // __cplusplus

extern void _ZN9S20571C18C1Ev();
extern void _ZN9S20571C18D1Ev();
Name_Map name_map_S20571C18[] = {
  NSPAIR(_ZN9S20571C18C1Ev),
  NSPAIR(_ZN9S20571C18D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20571C7;
extern VTBL_ENTRY _ZTI8S20571C7[];
extern  VTBL_ENTRY _ZTV8S20571C7[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20571C7;
extern VTBL_ENTRY _ZTI8S20571C7[];
extern  VTBL_ENTRY _ZTV8S20571C7[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20571C12;
extern VTBL_ENTRY _ZTI9S20571C12[];
extern  VTBL_ENTRY _ZTV9S20571C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C12[];
extern Class_Descriptor cd_S20571C10;
extern VTBL_ENTRY _ZTI9S20571C10[];
extern  VTBL_ENTRY _ZTV9S20571C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C10[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20571C7;
extern VTBL_ENTRY _ZTI8S20571C7[];
extern  VTBL_ENTRY _ZTV8S20571C7[];
extern Class_Descriptor cd_S20571C9;
extern VTBL_ENTRY _ZTI8S20571C9[];
extern  VTBL_ENTRY _ZTV8S20571C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20571C9[];
extern Class_Descriptor cd_S20571C6;
extern VTBL_ENTRY _ZTI8S20571C6[];
extern  VTBL_ENTRY _ZTV8S20571C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20571C6[];
extern Class_Descriptor cd_S20571C16;
extern VTBL_ENTRY _ZTI9S20571C16[];
extern  VTBL_ENTRY _ZTV9S20571C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C16[];
extern Class_Descriptor cd_S20571C4;
extern VTBL_ENTRY _ZTI8S20571C4[];
extern  VTBL_ENTRY _ZTV8S20571C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20571C4[];
static Base_Class bases_S20571C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(3376,2488), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20571C7,    ABISELECT(3360,2484), //bcp->offset
    21, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S20570C5,    ABISELECT(3712,2744), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20571C7,    ABISELECT(3696,2740), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(4080,3036), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S20571C12,    ABISELECT(3696,2740), //bcp->offset
    29, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S20571C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(1184,876), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(1424,1048), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20571C7,    ABISELECT(1408,1044), //bcp->offset
    16, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20571C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20571C6,    ABISELECT(4304,3204), //bcp->offset
    38, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S20571C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20571C4,    ABISELECT(4688,3480), //bcp->offset
    41, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20571C18[];
extern void _ZN9S20571C18D1Ev();
extern void _ZN9S20571C18D0Ev();
extern void _ZN9S20571C102v8Ev();
extern void _ZN8S20571C93v12Ev();
extern void _ZN9S20571C183v14Ev();
extern void _ZN9S20571C183v15Ev();
extern void _ZN9S20571C183v16Ev();
extern void _ZN9S20571C183v17Ev();
extern void _ZN9S20571C183v18Ev();
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
extern void ABISELECT(_ZTv0_n32_N9S20571C18D1Ev,_ZTv0_n16_N9S20571C18D1Ev)();
extern void ABISELECT(_ZThn4688_N9S20571C18D1Ev,_ZThn3480_N9S20571C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20571C18D0Ev,_ZTv0_n16_N9S20571C18D0Ev)();
extern void ABISELECT(_ZThn4688_N9S20571C18D0Ev,_ZThn3480_N9S20571C18D0Ev)() __attribute__((weak));
extern void _ZN8S20571C42v4Ev();
static  VTBL_ENTRY vtc_S20571C18[] = {
  ABISELECT(4688,3480),
  ABISELECT(4304,3204),
  ABISELECT(3696,2740),
  ABISELECT(3360,2484),
  ABISELECT(4080,3036),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C18[0]),
  (VTBL_ENTRY)&_ZN9S20571C18D1Ev,
  (VTBL_ENTRY)&_ZN9S20571C18D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20571C93v12Ev,
  (VTBL_ENTRY)&_ZN9S20571C183v14Ev,
  (VTBL_ENTRY)&_ZN9S20571C183v15Ev,
  (VTBL_ENTRY)&_ZN9S20571C183v16Ev,
  (VTBL_ENTRY)&_ZN9S20571C183v17Ev,
  (VTBL_ENTRY)&_ZN9S20571C183v18Ev,
  ABISELECT(-1408,-1044),
  (VTBL_ENTRY)&(_ZTI9S20571C18[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
  0,
  0,
  0,
  ABISELECT(-3360,-2484),
  (VTBL_ENTRY)&(_ZTI9S20571C18[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
  0,
  0,
  0,
  ABISELECT(384,296),
  ABISELECT(-3696,-2740),
  (VTBL_ENTRY)&(_ZTI9S20571C18[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
  ABISELECT(-224,-168),
  ABISELECT(-4304,-3204),
  (VTBL_ENTRY)&(_ZTI9S20571C18[0]),
  0,
  ABISELECT(-4688,-3480),
  ABISELECT(-608,-444),
  ABISELECT(-4688,-3480),
  (VTBL_ENTRY)&(_ZTI9S20571C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20571C18D1Ev,_ZTv0_n16_N9S20571C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20571C18D0Ev,_ZTv0_n16_N9S20571C18D0Ev),
  (VTBL_ENTRY)&_ZN8S20571C42v4Ev,
};
extern VTBL_ENTRY _ZTV9S20571C18[];
extern void _ZN9S20571C16D1Ev();
extern void _ZN9S20571C16D0Ev();
extern void _ZN9S20571C102v8Ev();
extern void _ZN8S20571C93v12Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C16__9S20571C18[] = {
  ABISELECT(4304,3204),
  ABISELECT(3696,2740),
  ABISELECT(3360,2484),
  ABISELECT(4080,3036),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C16[0]),
  (VTBL_ENTRY)&_ZN9S20571C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20571C16D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20571C93v12Ev,
};
extern void _ZN8S20571C9D1Ev();
extern void _ZN8S20571C9D0Ev();
extern void _ZN9S20571C102v8Ev();
extern void _ZN8S20571C93v12Ev();
static  VTBL_ENTRY _tg__ZTV8S20571C99S20571C16__9S20571C18[] = {
  ABISELECT(4080,3036),
  0,
  (VTBL_ENTRY)&(_ZTI8S20571C9[0]),
  (VTBL_ENTRY)&_ZN8S20571C9D1Ev,
  (VTBL_ENTRY)&_ZN8S20571C9D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20571C93v12Ev,
};
extern void _ZN9S20571C10D1Ev();
extern void _ZN9S20571C10D0Ev();
extern void _ZN9S20571C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C108S20571C99S20571C16__9S20571C18[] = {
  ABISELECT(4080,3036),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C10[0]),
  (VTBL_ENTRY)&_ZN9S20571C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20571C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
};
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
static  VTBL_ENTRY _tg__ZTV8S20571C7__9S20571C16__9S20571C18[] = {
  0,
  0,
  0,
  ABISELECT(-3360,-2484),
  (VTBL_ENTRY)&(_ZTI9S20571C16[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
};
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C12__9S20571C16__9S20571C18[] = {
  0,
  0,
  0,
  ABISELECT(384,296),
  ABISELECT(-3696,-2740),
  (VTBL_ENTRY)&(_ZTI9S20571C16[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20571C6__9S20571C16__9S20571C18[] = {
  ABISELECT(-224,-168),
  ABISELECT(-4304,-3204),
  (VTBL_ENTRY)&(_ZTI9S20571C16[0]),
};
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C12__9S20571C18[] = {
  ABISELECT(384,296),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C12[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20571C6__9S20571C18[] = {
  ABISELECT(-224,-168),
  0,
  (VTBL_ENTRY)&(_ZTI8S20571C6[0]),
};
extern void _ZN8S20571C4D1Ev();
extern void _ZN8S20571C4D0Ev();
extern void _ZN8S20571C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20571C4__9S20571C18[] = {
  ABISELECT(-608,-444),
  0,
  (VTBL_ENTRY)&(_ZTI8S20571C4[0]),
  (VTBL_ENTRY)&_ZN8S20571C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20571C4D0Ev,
  (VTBL_ENTRY)&_ZN8S20571C42v4Ev,
};
static  VTT_ENTRY vtt_S20571C18[] = {
  {&(_ZTV9S20571C18[7]),  7,49},
  {&(_tg__ZTV9S20571C16__9S20571C18[6]),  6,10},
  {&(_tg__ZTV8S20571C99S20571C16__9S20571C18[3]),  3,7},
  {&(_tg__ZTV9S20571C108S20571C99S20571C16__9S20571C18[3]),  3,6},
  {&(_tg__ZTV8S20571C7__9S20571C16__9S20571C18[5]),  5,8},
  {&(_tg__ZTV9S20571C12__9S20571C16__9S20571C18[6]),  6,9},
  {&(_tg__ZTV8S20571C6__9S20571C16__9S20571C18[3]),  3,3},
  {&(_ZTV9S20571C18[26]),  26,49},
  {&(_ZTV9S20571C18[35]),  35,49},
  {&(_ZTV9S20571C18[41]),  41,49},
  {&(_ZTV9S20571C18[46]),  46,49},
  {&(_tg__ZTV9S20571C12__9S20571C18[3]),  3,6},
  {&(_tg__ZTV8S20571C6__9S20571C18[3]),  3,3},
  {&(_tg__ZTV8S20571C4__9S20571C18[3]),  3,6},
};
extern VTBL_ENTRY _ZTI9S20571C18[];
extern  VTBL_ENTRY _ZTV9S20571C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C18[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20571C18D0Ev,_ZTv0_n16_N9S20571C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4688_N9S20571C18D0Ev,_ZThn3480_N9S20571C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20571C18D1Ev,_ZTv0_n16_N9S20571C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4688_N9S20571C18D1Ev,_ZThn3480_N9S20571C18D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20571C18 = {  "S20571C18", // class name
  bases_S20571C18, 14,
  &(vtc_S20571C18[0]), // expected_vtbl_contents
  &(vtt_S20571C18[0]), // expected_vtt_contents
  ABISELECT(4752,3536), // object size
  NSPAIRA(_ZTI9S20571C18),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S20571C18),49, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20571C18),14, //virtual table table var
  9, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20571C15  : S20571C16 , virtual S20571C4 , S20571C18 , S20571C14 {
  char s20571c15f0;
  virtual void  v13(); // _ZN9S20571C153v13Ev
  ~S20571C15(); // tgen
  S20571C15(); // tgen
};
//SIG(-1 S20571C15) C1{ BC2{ VBC3{ BC4{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} v2 v3 v4 FD Fs:16 Fi[7] FD Fc:6 Fi:32 FL[2] Fi} VBC5{ BC3 VBC4 FC6{} FL Fi:23 Fs Fi FL[2]} BC7{ BC8{ VBC4 vd v5 FC4[5] FL Fs:5 Fc:0 Fp[2] Fi FL} BC4 BC3 v6 FD Fp Fs[6] Fp Fi FD Fi} VBC9{ VBC4 Fp Fi FC3 Fi Fp} vd Fc:5 FL[4] Fc[6] FC10{ vd m Fp Fl Fi Fp}} VBC11{ VBC4 vd v7 FL[4] Fs Fi FL Fi} BC12{ BC2 VBC11 v8 v9 v10 v11 v12 Fs Fc Fs[5] FC8 Fs:16 Fi} BC13{ BC8 BC5 BC11 Fi:0} v1 Fc}


void  S20571C15 ::v13(){vfunc_called(this, "_ZN9S20571C153v13Ev");}
S20571C15 ::~S20571C15(){ note_dtor("S20571C15", this);} // tgen
S20571C15 ::S20571C15(){ note_ctor("S20571C15", this);} // tgen

static void Test_S20571C15()
{
  extern Class_Descriptor cd_S20571C15;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(520,1547)];
    init_test(&cd_S20571C15, buf);
    S20571C15 *dp, &lv = *(dp=new (buf) S20571C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8304,6184), "sizeof(S20571C15)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20571C15)");
    /*is_ambiguous_... S20571C15::S20571C7 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20571C7*), ABISELECT(6928,5136), "S20571C15");
    /*is_ambiguous_... S20571C15::S20571C16 */ AMB_check_base_class_offset(lv, (S20571C7*)(S20571C16*), ABISELECT(6912,5132), "S20571C15");
    /*is_ambiguous_... S20571C16::S20571C7 */ AMB_check_base_class_offset(lv, (S20571C7*)(S20571C16*)(S20571C18*), ABISELECT(6912,5132), "S20571C15");
    /*is_ambiguous_... S20571C15::S20571C12 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20571C7*)(S20571C12*), ABISELECT(7264,5392), "S20571C15");
    /*is_ambiguous_... S20571C15::S20571C12 */ AMB_check_base_class_offset(lv, (S20571C7*)(S20571C12*), ABISELECT(7248,5388), "S20571C15");
    /*is_ambiguous_... S20571C15::S20571C12 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20571C12*), ABISELECT(7632,5684), "S20571C15");
    /*is_ambiguous_... S20571C15::S20571C16 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20571C10*)(S20571C9*)(S20571C16*), ABISELECT(7632,5684), "S20571C15");
    check_base_class_offset(lv, (S20570C5*)(S20571C6*), ABISELECT(7632,5684), "S20571C15");
    /*is_ambiguous_... S20571C15::S20571C4 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20571C4*), ABISELECT(7632,5684), "S20571C15");
    check_base_class_offset(lv, (S20570C5*)(S20571C10*)(S20571C9*)(S20571C16*)(S20571C18*), ABISELECT(7632,5684), "S20571C15");
    check_base_class_offset(lv, (S20570C5*)(S20571C10*)(S20571C14*), ABISELECT(7632,5684), "S20571C15");
    /*is_ambiguous_... S20571C12::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20571C12*)(S20571C14*), ABISELECT(7632,5684), "S20571C15");
    check_base_class_offset(lv, (S20570C5*)(S20571C4*)(S20571C14*), ABISELECT(7632,5684), "S20571C15");
    /*is_ambiguous_... S20571C15::S20571C16 */ AMB_check_base_class_offset(lv, (S20571C12*)(S20571C16*), ABISELECT(7248,5388), "S20571C15");
    check_base_class_offset(lv, (S20571C12*)(S20571C16*)(S20571C18*), ABISELECT(7248,5388), "S20571C15");
    /*is_ambiguous_... S20571C15::S20571C16 */ AMB_check_base_class_offset(lv, (S20571C10*)(S20571C9*)(S20571C16*), 0, "S20571C15");
    /*is_ambiguous_... S20571C15::S20571C16 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20571C9*)(S20571C16*), ABISELECT(1184,876), "S20571C15");
    /*is_ambiguous_... S20571C15::S20571C16 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20571C7*)(S20571C9*)(S20571C16*), ABISELECT(1424,1048), "S20571C15");
    /*is_ambiguous_... S20571C15::S20571C16 */ AMB_check_base_class_offset(lv, (S20571C7*)(S20571C9*)(S20571C16*), ABISELECT(1408,1044), "S20571C15");
    /*is_ambiguous_... S20571C15::S20571C16 */ AMB_check_base_class_offset(lv, (S20571C9*)(S20571C16*), 0, "S20571C15");
    /*is_ambiguous_... S20571C15::S20571C16 */ AMB_check_base_class_offset(lv, (S20571C6*)(S20571C16*), ABISELECT(7856,5852), "S20571C15");
    check_base_class_offset(lv, (S20571C6*)(S20571C16*)(S20571C18*), ABISELECT(7856,5852), "S20571C15");
    /*is_ambiguous_... S20571C15::S20571C16 */ AMB_check_base_class_offset(lv, (S20571C16*), 0, "S20571C15");
    /*is_ambiguous_... S20571C15::S20571C4 */ AMB_check_base_class_offset(lv, (S20571C4*), ABISELECT(8240,6128), "S20571C15");
    check_base_class_offset(lv, (S20571C4*)(S20571C18*), ABISELECT(8240,6128), "S20571C15");
    check_base_class_offset(lv, (S20571C10*)(S20571C9*)(S20571C16*)(S20571C18*), ABISELECT(1920,1416), "S20571C15");
    /*is_ambiguous_... S20571C9::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20571C9*)(S20571C16*)(S20571C18*), ABISELECT(3104,2292), "S20571C15");
    check_base_class_offset(lv, (S20570C5*)(S20571C7*)(S20571C9*)(S20571C16*)(S20571C18*), ABISELECT(3344,2464), "S20571C15");
    check_base_class_offset(lv, (S20571C7*)(S20571C9*)(S20571C16*)(S20571C18*), ABISELECT(3328,2460), "S20571C15");
    check_base_class_offset(lv, (S20571C9*)(S20571C16*)(S20571C18*), ABISELECT(1920,1416), "S20571C15");
    check_base_class_offset(lv, (S20571C16*)(S20571C18*), ABISELECT(1920,1416), "S20571C15");
    check_base_class_offset(lv, (S20571C18*), ABISELECT(1920,1416), "S20571C15");
    check_base_class_offset(lv, (S20571C10*)(S20571C14*), ABISELECT(5280,3900), "S20571C15");
    check_base_class_offset(lv, (S20570C5*)(S20571C7*)(S20571C12*)(S20571C14*), ABISELECT(6480,4780), "S20571C15");
    check_base_class_offset(lv, (S20571C7*)(S20571C12*)(S20571C14*), ABISELECT(6464,4776), "S20571C15");
    check_base_class_offset(lv, (S20571C12*)(S20571C14*), ABISELECT(6464,4776), "S20571C15");
    check_base_class_offset(lv, (S20571C4*)(S20571C14*), ABISELECT(6840,5072), "S20571C15");
    check_base_class_offset(lv, (S20571C14*), ABISELECT(5280,3900), "S20571C15");
    check_field_offset(lv, s20571c15f0, ABISELECT(6900,5128), "S20571C15.s20571c15f0");
    test_class_info(&lv, &cd_S20571C15);
    dp->~S20571C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20571C15(Test_S20571C15, "S20571C15", ABISELECT(8304,6184));

#else // __cplusplus

extern void _ZN9S20571C15C1Ev();
extern void _ZN9S20571C15D1Ev();
Name_Map name_map_S20571C15[] = {
  NSPAIR(_ZN9S20571C15C1Ev),
  NSPAIR(_ZN9S20571C15D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20571C7;
extern VTBL_ENTRY _ZTI8S20571C7[];
extern  VTBL_ENTRY _ZTV8S20571C7[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20571C7;
extern VTBL_ENTRY _ZTI8S20571C7[];
extern  VTBL_ENTRY _ZTV8S20571C7[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20571C12;
extern VTBL_ENTRY _ZTI9S20571C12[];
extern  VTBL_ENTRY _ZTV9S20571C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C12[];
extern Class_Descriptor cd_S20571C10;
extern VTBL_ENTRY _ZTI9S20571C10[];
extern  VTBL_ENTRY _ZTV9S20571C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C10[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20571C7;
extern VTBL_ENTRY _ZTI8S20571C7[];
extern  VTBL_ENTRY _ZTV8S20571C7[];
extern Class_Descriptor cd_S20571C9;
extern VTBL_ENTRY _ZTI8S20571C9[];
extern  VTBL_ENTRY _ZTV8S20571C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20571C9[];
extern Class_Descriptor cd_S20571C6;
extern VTBL_ENTRY _ZTI8S20571C6[];
extern  VTBL_ENTRY _ZTV8S20571C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20571C6[];
extern Class_Descriptor cd_S20571C16;
extern VTBL_ENTRY _ZTI9S20571C16[];
extern  VTBL_ENTRY _ZTV9S20571C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C16[];
extern Class_Descriptor cd_S20571C4;
extern VTBL_ENTRY _ZTI8S20571C4[];
extern  VTBL_ENTRY _ZTV8S20571C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20571C4[];
extern Class_Descriptor cd_S20571C10;
extern VTBL_ENTRY _ZTI9S20571C10[];
extern  VTBL_ENTRY _ZTV9S20571C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C10[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20571C7;
extern VTBL_ENTRY _ZTI8S20571C7[];
extern  VTBL_ENTRY _ZTV8S20571C7[];
extern Class_Descriptor cd_S20571C9;
extern VTBL_ENTRY _ZTI8S20571C9[];
extern  VTBL_ENTRY _ZTV8S20571C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20571C9[];
extern Class_Descriptor cd_S20571C16;
extern VTBL_ENTRY _ZTI9S20571C16[];
extern  VTBL_ENTRY _ZTV9S20571C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C16[];
extern Class_Descriptor cd_S20571C18;
extern VTBL_ENTRY _ZTI9S20571C18[];
extern  VTBL_ENTRY _ZTV9S20571C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C18[];
extern Class_Descriptor cd_S20571C10;
extern VTBL_ENTRY _ZTI9S20571C10[];
extern  VTBL_ENTRY _ZTV9S20571C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C10[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20571C7;
extern VTBL_ENTRY _ZTI8S20571C7[];
extern  VTBL_ENTRY _ZTV8S20571C7[];
extern Class_Descriptor cd_S20571C12;
extern VTBL_ENTRY _ZTI9S20571C12[];
extern  VTBL_ENTRY _ZTV9S20571C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C12[];
extern Class_Descriptor cd_S20571C4;
extern VTBL_ENTRY _ZTI8S20571C4[];
extern  VTBL_ENTRY _ZTV8S20571C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20571C4[];
extern Class_Descriptor cd_S20571C14;
extern VTBL_ENTRY _ZTI9S20571C14[];
extern  VTBL_ENTRY _ZTV9S20571C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C14[];
static Base_Class bases_S20571C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(6928,5136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20571C7,    ABISELECT(6912,5132), //bcp->offset
    56, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S20570C5,    ABISELECT(7264,5392), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20571C7,    ABISELECT(7248,5388), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(7632,5684), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S20571C12,    ABISELECT(7248,5388), //bcp->offset
    64, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S20571C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(1184,876), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(1424,1048), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20571C7,    ABISELECT(1408,1044), //bcp->offset
    12, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20571C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20571C6,    ABISELECT(7856,5852), //bcp->offset
    73, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S20571C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20571C4,    ABISELECT(8240,6128), //bcp->offset
    76, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20571C10,    ABISELECT(1920,1416), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(3104,2292), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(3344,2464), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S20571C7,    ABISELECT(3328,2460), //bcp->offset
    33, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20571C9,    ABISELECT(1920,1416), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S20571C16,    ABISELECT(1920,1416), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S20571C18,    ABISELECT(1920,1416), //bcp->offset
    17, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20571C10,    ABISELECT(5280,3900), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(6480,4780), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S20571C7,    ABISELECT(6464,4776), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S20571C12,    ABISELECT(6464,4776), //bcp->offset
    44, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S20571C4,    ABISELECT(6840,5072), //bcp->offset
    50, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    32, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S20571C14,    ABISELECT(5280,3900), //bcp->offset
    38, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20571C15[];
extern void _ZN9S20571C15D1Ev();
extern void _ZN9S20571C15D0Ev();
extern void _ZN9S20571C102v8Ev();
extern void _ZN8S20571C93v12Ev();
extern void _ZN9S20571C153v13Ev();
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
extern void ABISELECT(_ZThn1920_N9S20571C15D1Ev,_ZThn1416_N9S20571C15D1Ev)();
extern void ABISELECT(_ZThn1920_N9S20571C15D0Ev,_ZThn1416_N9S20571C15D0Ev)();
extern void _ZN9S20571C102v8Ev();
extern void _ZN8S20571C93v12Ev();
extern void _ZN9S20571C183v14Ev();
extern void _ZN9S20571C183v15Ev();
extern void _ZN9S20571C183v16Ev();
extern void _ZN9S20571C183v17Ev();
extern void _ZN9S20571C183v18Ev();
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
extern void ABISELECT(_ZThn5280_N9S20571C15D1Ev,_ZThn3900_N9S20571C15D1Ev)();
extern void ABISELECT(_ZThn5280_N9S20571C15D0Ev,_ZThn3900_N9S20571C15D0Ev)();
extern void _ZN9S20571C102v8Ev();
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
extern void ABISELECT(_ZThn6840_N9S20571C15D1Ev,_ZThn5072_N9S20571C15D1Ev)();
extern void ABISELECT(_ZThn6840_N9S20571C15D0Ev,_ZThn5072_N9S20571C15D0Ev)();
extern void _ZN8S20571C42v4Ev();
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
extern void ABISELECT(_ZTv0_n32_N9S20571C15D1Ev,_ZTv0_n16_N9S20571C15D1Ev)();
extern void ABISELECT(_ZThn8240_N9S20571C15D1Ev,_ZThn6128_N9S20571C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20571C15D0Ev,_ZTv0_n16_N9S20571C15D0Ev)();
extern void ABISELECT(_ZThn8240_N9S20571C15D0Ev,_ZThn6128_N9S20571C15D0Ev)() __attribute__((weak));
extern void _ZN8S20571C42v4Ev();
static  VTBL_ENTRY vtc_S20571C15[] = {
  ABISELECT(8240,6128),
  ABISELECT(7856,5852),
  ABISELECT(7248,5388),
  ABISELECT(6912,5132),
  ABISELECT(7632,5684),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C15[0]),
  (VTBL_ENTRY)&_ZN9S20571C15D1Ev,
  (VTBL_ENTRY)&_ZN9S20571C15D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20571C93v12Ev,
  (VTBL_ENTRY)&_ZN9S20571C153v13Ev,
  ABISELECT(-1408,-1044),
  (VTBL_ENTRY)&(_ZTI9S20571C15[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
  ABISELECT(6320,4712),
  ABISELECT(5936,4436),
  ABISELECT(5328,3972),
  ABISELECT(4992,3716),
  ABISELECT(5712,4268),
  ABISELECT(-1920,-1416),
  (VTBL_ENTRY)&(_ZTI9S20571C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1920_N9S20571C15D1Ev,_ZThn1416_N9S20571C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1920_N9S20571C15D0Ev,_ZThn1416_N9S20571C15D0Ev),
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20571C93v12Ev,
  (VTBL_ENTRY)&_ZN9S20571C183v14Ev,
  (VTBL_ENTRY)&_ZN9S20571C183v15Ev,
  (VTBL_ENTRY)&_ZN9S20571C183v16Ev,
  (VTBL_ENTRY)&_ZN9S20571C183v17Ev,
  (VTBL_ENTRY)&_ZN9S20571C183v18Ev,
  ABISELECT(-3328,-2460),
  (VTBL_ENTRY)&(_ZTI9S20571C15[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
  ABISELECT(2352,1784),
  ABISELECT(-5280,-3900),
  (VTBL_ENTRY)&(_ZTI9S20571C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn5280_N9S20571C15D1Ev,_ZThn3900_N9S20571C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn5280_N9S20571C15D0Ev,_ZThn3900_N9S20571C15D0Ev),
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
  ABISELECT(1168,908),
  ABISELECT(-6464,-4776),
  (VTBL_ENTRY)&(_ZTI9S20571C15[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
  ABISELECT(792,612),
  ABISELECT(-6840,-5072),
  (VTBL_ENTRY)&(_ZTI9S20571C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn6840_N9S20571C15D1Ev,_ZThn5072_N9S20571C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn6840_N9S20571C15D0Ev,_ZThn5072_N9S20571C15D0Ev),
  (VTBL_ENTRY)&_ZN8S20571C42v4Ev,
  0,
  0,
  0,
  ABISELECT(-6912,-5132),
  (VTBL_ENTRY)&(_ZTI9S20571C15[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
  0,
  0,
  0,
  ABISELECT(384,296),
  ABISELECT(-7248,-5388),
  (VTBL_ENTRY)&(_ZTI9S20571C15[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
  ABISELECT(-224,-168),
  ABISELECT(-7856,-5852),
  (VTBL_ENTRY)&(_ZTI9S20571C15[0]),
  0,
  ABISELECT(-8240,-6128),
  ABISELECT(-608,-444),
  ABISELECT(-8240,-6128),
  (VTBL_ENTRY)&(_ZTI9S20571C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20571C15D1Ev,_ZTv0_n16_N9S20571C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20571C15D0Ev,_ZTv0_n16_N9S20571C15D0Ev),
  (VTBL_ENTRY)&_ZN8S20571C42v4Ev,
};
extern VTBL_ENTRY _ZTV9S20571C15[];
extern void _ZN9S20571C16D1Ev();
extern void _ZN9S20571C16D0Ev();
extern void _ZN9S20571C102v8Ev();
extern void _ZN8S20571C93v12Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C16__9S20571C15[] = {
  ABISELECT(7856,5852),
  ABISELECT(7248,5388),
  ABISELECT(6912,5132),
  ABISELECT(7632,5684),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C16[0]),
  (VTBL_ENTRY)&_ZN9S20571C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20571C16D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20571C93v12Ev,
};
extern void _ZN8S20571C9D1Ev();
extern void _ZN8S20571C9D0Ev();
extern void _ZN9S20571C102v8Ev();
extern void _ZN8S20571C93v12Ev();
static  VTBL_ENTRY _tg__ZTV8S20571C99S20571C16__9S20571C15[] = {
  ABISELECT(7632,5684),
  0,
  (VTBL_ENTRY)&(_ZTI8S20571C9[0]),
  (VTBL_ENTRY)&_ZN8S20571C9D1Ev,
  (VTBL_ENTRY)&_ZN8S20571C9D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20571C93v12Ev,
};
extern void _ZN9S20571C10D1Ev();
extern void _ZN9S20571C10D0Ev();
extern void _ZN9S20571C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C108S20571C99S20571C16__9S20571C15[] = {
  ABISELECT(7632,5684),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C10[0]),
  (VTBL_ENTRY)&_ZN9S20571C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20571C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
};
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
static  VTBL_ENTRY _tg__ZTV8S20571C7__9S20571C16__9S20571C15[] = {
  0,
  0,
  0,
  ABISELECT(-6912,-5132),
  (VTBL_ENTRY)&(_ZTI9S20571C16[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
};
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C12__9S20571C16__9S20571C15[] = {
  0,
  0,
  0,
  ABISELECT(384,296),
  ABISELECT(-7248,-5388),
  (VTBL_ENTRY)&(_ZTI9S20571C16[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20571C6__9S20571C16__9S20571C15[] = {
  ABISELECT(-224,-168),
  ABISELECT(-7856,-5852),
  (VTBL_ENTRY)&(_ZTI9S20571C16[0]),
};
extern void _ZN9S20571C18D1Ev();
extern void _ZN9S20571C18D0Ev();
extern void _ZN9S20571C102v8Ev();
extern void _ZN8S20571C93v12Ev();
extern void _ZN9S20571C183v14Ev();
extern void _ZN9S20571C183v15Ev();
extern void _ZN9S20571C183v16Ev();
extern void _ZN9S20571C183v17Ev();
extern void _ZN9S20571C183v18Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C18__9S20571C15[] = {
  ABISELECT(6320,4712),
  ABISELECT(5936,4436),
  ABISELECT(5328,3972),
  ABISELECT(4992,3716),
  ABISELECT(5712,4268),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C18[0]),
  (VTBL_ENTRY)&_ZN9S20571C18D1Ev,
  (VTBL_ENTRY)&_ZN9S20571C18D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20571C93v12Ev,
  (VTBL_ENTRY)&_ZN9S20571C183v14Ev,
  (VTBL_ENTRY)&_ZN9S20571C183v15Ev,
  (VTBL_ENTRY)&_ZN9S20571C183v16Ev,
  (VTBL_ENTRY)&_ZN9S20571C183v17Ev,
  (VTBL_ENTRY)&_ZN9S20571C183v18Ev,
};
extern void _ZN9S20571C16D1Ev();
extern void _ZN9S20571C16D0Ev();
extern void _ZN9S20571C102v8Ev();
extern void _ZN8S20571C93v12Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C169S20571C18__A1__9S20571C15[] = {
  ABISELECT(5936,4436),
  ABISELECT(5328,3972),
  ABISELECT(4992,3716),
  ABISELECT(5712,4268),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C16[0]),
  (VTBL_ENTRY)&_ZN9S20571C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20571C16D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20571C93v12Ev,
};
extern void _ZN8S20571C9D1Ev();
extern void _ZN8S20571C9D0Ev();
extern void _ZN9S20571C102v8Ev();
extern void _ZN8S20571C93v12Ev();
static  VTBL_ENTRY _tg__ZTV8S20571C99S20571C169S20571C18__A1__9S20571C15[] = {
  ABISELECT(5712,4268),
  0,
  (VTBL_ENTRY)&(_ZTI8S20571C9[0]),
  (VTBL_ENTRY)&_ZN8S20571C9D1Ev,
  (VTBL_ENTRY)&_ZN8S20571C9D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20571C93v12Ev,
};
extern void _ZN9S20571C10D1Ev();
extern void _ZN9S20571C10D0Ev();
extern void _ZN9S20571C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C108S20571C99S20571C169S20571C18__A1__9S20571C15[] = {
  ABISELECT(5712,4268),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C10[0]),
  (VTBL_ENTRY)&_ZN9S20571C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20571C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
};
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
static  VTBL_ENTRY _tg__ZTV8S20571C7__9S20571C169S20571C18__A1__9S20571C15[] = {
  0,
  0,
  0,
  ABISELECT(-4992,-3716),
  (VTBL_ENTRY)&(_ZTI9S20571C16[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
};
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C12__9S20571C169S20571C18__A1__9S20571C15[] = {
  0,
  0,
  0,
  ABISELECT(384,296),
  ABISELECT(-5328,-3972),
  (VTBL_ENTRY)&(_ZTI9S20571C16[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20571C6__9S20571C169S20571C18__A1__9S20571C15[] = {
  ABISELECT(-224,-168),
  ABISELECT(-5936,-4436),
  (VTBL_ENTRY)&(_ZTI9S20571C16[0]),
};
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
static  VTBL_ENTRY _tg__ZTV8S20571C7__9S20571C18__9S20571C15[] = {
  0,
  0,
  0,
  ABISELECT(-4992,-3716),
  (VTBL_ENTRY)&(_ZTI9S20571C18[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
};
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C12__9S20571C18__9S20571C15[] = {
  0,
  0,
  0,
  ABISELECT(384,296),
  ABISELECT(-5328,-3972),
  (VTBL_ENTRY)&(_ZTI9S20571C18[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20571C6__9S20571C18__9S20571C15[] = {
  ABISELECT(-224,-168),
  ABISELECT(-5936,-4436),
  (VTBL_ENTRY)&(_ZTI9S20571C18[0]),
};
extern void ABISELECT(_ZTv0_n32_N9S20571C18D1Ev,_ZTv0_n16_N9S20571C18D1Ev)();
extern void ABISELECT(_ZThn6320_N9S20571C18D1Ev,_ZThn4712_N9S20571C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20571C18D0Ev,_ZTv0_n16_N9S20571C18D0Ev)();
extern void ABISELECT(_ZThn6320_N9S20571C18D0Ev,_ZThn4712_N9S20571C18D0Ev)() __attribute__((weak));
extern void _ZN8S20571C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20571C4__9S20571C18__9S20571C15[] = {
  0,
  ABISELECT(-6320,-4712),
  ABISELECT(-608,-444),
  ABISELECT(-6320,-4712),
  (VTBL_ENTRY)&(_ZTI9S20571C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20571C18D1Ev,_ZTv0_n16_N9S20571C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20571C18D0Ev,_ZTv0_n16_N9S20571C18D0Ev),
  (VTBL_ENTRY)&_ZN8S20571C42v4Ev,
};
extern void _ZN9S20571C14D1Ev();
extern void _ZN9S20571C14D0Ev();
extern void _ZN9S20571C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C14__9S20571C15[] = {
  ABISELECT(2352,1784),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C14[0]),
  (VTBL_ENTRY)&_ZN9S20571C14D1Ev,
  (VTBL_ENTRY)&_ZN9S20571C14D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
};
extern void _ZN9S20571C10D1Ev();
extern void _ZN9S20571C10D0Ev();
extern void _ZN9S20571C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C109S20571C14__A2__9S20571C15[] = {
  ABISELECT(2352,1784),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C10[0]),
  (VTBL_ENTRY)&_ZN9S20571C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20571C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
};
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C129S20571C14__A1__9S20571C15[] = {
  ABISELECT(1168,908),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C12[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
};
extern void _ZN8S20571C4D1Ev();
extern void _ZN8S20571C4D0Ev();
extern void _ZN8S20571C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20571C49S20571C14__A1__9S20571C15[] = {
  ABISELECT(792,612),
  0,
  (VTBL_ENTRY)&(_ZTI8S20571C4[0]),
  (VTBL_ENTRY)&_ZN8S20571C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20571C4D0Ev,
  (VTBL_ENTRY)&_ZN8S20571C42v4Ev,
};
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C12__9S20571C14__9S20571C15[] = {
  ABISELECT(1168,908),
  ABISELECT(-1184,-876),
  (VTBL_ENTRY)&(_ZTI9S20571C14[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
};
extern void ABISELECT(_ZThn1560_N9S20571C14D1Ev,_ZThn1172_N9S20571C14D1Ev)();
extern void ABISELECT(_ZThn1560_N9S20571C14D0Ev,_ZThn1172_N9S20571C14D0Ev)();
extern void _ZN8S20571C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20571C4__9S20571C14__9S20571C15[] = {
  ABISELECT(792,612),
  ABISELECT(-1560,-1172),
  (VTBL_ENTRY)&(_ZTI9S20571C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1560_N9S20571C14D1Ev,_ZThn1172_N9S20571C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1560_N9S20571C14D0Ev,_ZThn1172_N9S20571C14D0Ev),
  (VTBL_ENTRY)&_ZN8S20571C42v4Ev,
};
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C12__9S20571C15[] = {
  ABISELECT(384,296),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C12[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20571C6__9S20571C15[] = {
  ABISELECT(-224,-168),
  0,
  (VTBL_ENTRY)&(_ZTI8S20571C6[0]),
};
extern void _ZN8S20571C4D1Ev();
extern void _ZN8S20571C4D0Ev();
extern void _ZN8S20571C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20571C4__9S20571C15[] = {
  ABISELECT(-608,-444),
  0,
  (VTBL_ENTRY)&(_ZTI8S20571C4[0]),
  (VTBL_ENTRY)&_ZN8S20571C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20571C4D0Ev,
  (VTBL_ENTRY)&_ZN8S20571C42v4Ev,
};
static  VTT_ENTRY vtt_S20571C15[] = {
  {&(_ZTV9S20571C15[7]),  7,84},
  {&(_tg__ZTV9S20571C16__9S20571C15[6]),  6,10},
  {&(_tg__ZTV8S20571C99S20571C16__9S20571C15[3]),  3,7},
  {&(_tg__ZTV9S20571C108S20571C99S20571C16__9S20571C15[3]),  3,6},
  {&(_tg__ZTV8S20571C7__9S20571C16__9S20571C15[5]),  5,8},
  {&(_tg__ZTV9S20571C12__9S20571C16__9S20571C15[6]),  6,9},
  {&(_tg__ZTV8S20571C6__9S20571C16__9S20571C15[3]),  3,3},
  {&(_tg__ZTV9S20571C18__9S20571C15[7]),  7,16},
  {&(_tg__ZTV9S20571C169S20571C18__A1__9S20571C15[6]),  6,10},
  {&(_tg__ZTV8S20571C99S20571C169S20571C18__A1__9S20571C15[3]),  3,7},
  {&(_tg__ZTV9S20571C108S20571C99S20571C169S20571C18__A1__9S20571C15[3]),  3,6},
  {&(_tg__ZTV8S20571C7__9S20571C169S20571C18__A1__9S20571C15[5]),  5,8},
  {&(_tg__ZTV9S20571C12__9S20571C169S20571C18__A1__9S20571C15[6]),  6,9},
  {&(_tg__ZTV8S20571C6__9S20571C169S20571C18__A1__9S20571C15[3]),  3,3},
  {&(_tg__ZTV8S20571C7__9S20571C18__9S20571C15[5]),  5,8},
  {&(_tg__ZTV9S20571C12__9S20571C18__9S20571C15[6]),  6,9},
  {&(_tg__ZTV8S20571C6__9S20571C18__9S20571C15[3]),  3,3},
  {&(_tg__ZTV8S20571C4__9S20571C18__9S20571C15[5]),  5,8},
  {&(_tg__ZTV9S20571C14__9S20571C15[3]),  3,6},
  {&(_tg__ZTV9S20571C109S20571C14__A2__9S20571C15[3]),  3,6},
  {&(_tg__ZTV9S20571C129S20571C14__A1__9S20571C15[3]),  3,6},
  {&(_tg__ZTV8S20571C49S20571C14__A1__9S20571C15[3]),  3,6},
  {&(_tg__ZTV9S20571C12__9S20571C14__9S20571C15[3]),  3,6},
  {&(_tg__ZTV8S20571C4__9S20571C14__9S20571C15[3]),  3,6},
  {&(_ZTV9S20571C15[61]),  61,84},
  {&(_ZTV9S20571C15[70]),  70,84},
  {&(_ZTV9S20571C15[76]),  76,84},
  {&(_ZTV9S20571C15[81]),  81,84},
  {&(_ZTV9S20571C15[24]),  24,84},
  {&(_ZTV9S20571C15[41]),  41,84},
  {&(_ZTV9S20571C15[47]),  47,84},
  {&(_ZTV9S20571C15[53]),  53,84},
  {&(_tg__ZTV9S20571C12__9S20571C15[3]),  3,6},
  {&(_tg__ZTV8S20571C6__9S20571C15[3]),  3,3},
  {&(_tg__ZTV8S20571C4__9S20571C15[3]),  3,6},
};
extern VTBL_ENTRY _ZTI9S20571C15[];
extern  VTBL_ENTRY _ZTV9S20571C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C15[];
static VTBL_ENTRY alt_thunk_names10[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20571C18D0Ev,_ZTv0_n16_N9S20571C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6320_N9S20571C18D0Ev,_ZThn4712_N9S20571C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20571C18D1Ev,_ZTv0_n16_N9S20571C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6320_N9S20571C18D1Ev,_ZThn4712_N9S20571C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20571C15D0Ev,_ZTv0_n16_N9S20571C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8240_N9S20571C15D0Ev,_ZThn6128_N9S20571C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20571C15D1Ev,_ZTv0_n16_N9S20571C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8240_N9S20571C15D1Ev,_ZThn6128_N9S20571C15D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20571C15 = {  "S20571C15", // class name
  bases_S20571C15, 27,
  &(vtc_S20571C15[0]), // expected_vtbl_contents
  &(vtt_S20571C15[0]), // expected_vtt_contents
  ABISELECT(8304,6184), // object size
  NSPAIRA(_ZTI9S20571C15),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S20571C15),84, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20571C15),35, //virtual table table var
  19, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names10,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20571C1  : virtual S20571C2 , virtual S20571C6 , S20571C8 , virtual S20571C11 , S20570C5 {
  void *s20571c1f0[10];
  short s20571c1f1;
  char s20571c1f2:3;
  short s20571c1f3:16;
  ::S20571C11 s20571c1f4;
  ::S20571C15 s20571c1f5;
  void *s20571c1f6;
  char s20571c1f7;
  short s20571c1f8[6];
  long s20571c1f9[2];
  virtual void  v1(); // _ZN8S20571C12v1Ev
  virtual void  v2(); // _ZN8S20571C12v2Ev
  virtual void  v3(); // _ZN8S20571C12v3Ev
  ~S20571C1(); // tgen
  S20571C1(); // tgen
};
//SIG(1 S20571C1) C1{ VBC2{ VBC3{ BC4{ VBC5{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} vd v4 FL[4] Fs Fi FL Fi} v5 v6 Fi Fp Fi FD[9] Fl Fi FL Fp[5] FL} vd v7 Fi:26 Fc[2]} VBC6{ VBC5 Fp Fi FC7{ BC5 v9 v10 v11 FD Fs:16 Fi[7] FD Fc:6 Fi:32 FL[2] Fi} Fi Fp} BC8{ VBC5 BC9{ BC10{ VBC5 vd v8 FC5[5] FL Fs:5 Fc:0 Fp[2] Fi FL} BC5 BC7 v12 FD Fp Fs[6] Fp Fi FD Fi} BC10 vd FD[9] Fs} VBC11{ BC10 BC12{ BC7 VBC5 FC13{} FL Fi:23 Fs Fi FL[2]} Fp[13] Fi[2] Fl Fp[2] Fs FC14{ BC10 BC12 BC4 Fi:0} Fi} BC5 v1 v2 v3 Fp[10] Fs Fc:3 Fs:16 FC11 FC15{ BC16{ VBC7 VBC12 BC9 VBC6 vd Fc:5 FL[4] Fc[6] FC17{ vd m Fp Fl Fi Fp}} VBC4 BC18{ BC16 VBC4 v14 v15 v16 v17 v18 Fs Fc Fs[5] FC10 Fs:16 Fi} BC14 v13 Fc} Fp Fc Fs[6] Fl[2]}


void  S20571C1 ::v1(){vfunc_called(this, "_ZN8S20571C12v1Ev");}
void  S20571C1 ::v2(){vfunc_called(this, "_ZN8S20571C12v2Ev");}
void  S20571C1 ::v3(){vfunc_called(this, "_ZN8S20571C12v3Ev");}
S20571C1 ::~S20571C1(){ note_dtor("S20571C1", this);} // tgen
S20571C1 ::S20571C1(){ note_ctor("S20571C1", this);} // tgen

static void Test_S20571C1()
{
  extern Class_Descriptor cd_S20571C1;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1262,3728)];
    init_test(&cd_S20571C1, buf);
    S20571C1 *dp, &lv = *(dp=new (buf) S20571C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(20176,14908), "sizeof(S20571C1)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20571C1)");
    check_base_class_offset(lv, (S20570C5*)(S20571C4*)(S20571C3*), ABISELECT(15984,11816), "S20571C1");
    check_base_class_offset(lv, (S20570C5*)(S20571C6*), ABISELECT(15984,11816), "S20571C1");
    /*is_ambiguous_... S20571C8::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20571C8*), ABISELECT(15984,11816), "S20571C1");
    check_base_class_offset(lv, (S20570C5*)(S20571C10*)(S20571C9*)(S20571C8*), ABISELECT(15984,11816), "S20571C1");
    /*is_ambiguous_... S20571C8::S20571C10 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20571C10*)(S20571C8*), ABISELECT(15984,11816), "S20571C1");
    check_base_class_offset(lv, (S20570C5*)(S20571C10*)(S20571C11*), ABISELECT(15984,11816), "S20571C1");
    /*is_ambiguous_... S20571C12::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20571C12*)(S20571C11*), ABISELECT(15984,11816), "S20571C1");
    check_base_class_offset(lv, (S20571C4*)(S20571C3*), ABISELECT(15680,11596), "S20571C1");
    check_base_class_offset(lv, (S20571C3*)(S20571C2*), ABISELECT(15680,11596), "S20571C1");
    check_base_class_offset(lv, (S20571C2*), ABISELECT(15656,11584), "S20571C1");
    check_base_class_offset(lv, (S20571C6*), ABISELECT(16208,11984), "S20571C1");
    check_base_class_offset(lv, (S20571C10*)(S20571C9*)(S20571C8*), 0, "S20571C1");
    /*is_ambiguous_... S20571C9::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*)(S20571C9*)(S20571C8*), ABISELECT(1184,876), "S20571C1");
    check_base_class_offset(lv, (S20570C5*)(S20571C7*)(S20571C9*)(S20571C8*), ABISELECT(1424,1048), "S20571C1");
    check_base_class_offset(lv, (S20571C7*)(S20571C9*)(S20571C8*), ABISELECT(1408,1044), "S20571C1");
    check_base_class_offset(lv, (S20571C9*)(S20571C8*), 0, "S20571C1");
    /*is_ambiguous_... S20571C8::S20571C10 */ AMB_check_base_class_offset(lv, (S20571C10*)(S20571C8*), ABISELECT(1840,1352), "S20571C1");
    check_base_class_offset(lv, (S20571C8*), 0, "S20571C1");
    check_base_class_offset(lv, (S20571C10*)(S20571C11*), ABISELECT(16592,12260), "S20571C1");
    check_base_class_offset(lv, (S20570C5*)(S20571C7*)(S20571C12*)(S20571C11*), ABISELECT(17792,13140), "S20571C1");
    check_base_class_offset(lv, (S20571C7*)(S20571C12*)(S20571C11*), ABISELECT(17776,13136), "S20571C1");
    check_base_class_offset(lv, (S20571C12*)(S20571C11*), ABISELECT(17776,13136), "S20571C1");
    check_base_class_offset(lv, (S20571C11*), ABISELECT(16592,12260), "S20571C1");
    /*is_ambiguous_... S20571C1::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*), ABISELECT(3184,2340), "S20571C1");
    check_field_offset(lv, s20571c1f0, ABISELECT(3408,2508), "S20571C1.s20571c1f0");
    check_field_offset(lv, s20571c1f1, ABISELECT(3488,2548), "S20571C1.s20571c1f1");
    set_bf_and_test(lv, s20571c1f2, ABISELECT(3490,2550), 0, 3, 1, "S20571C1");
    set_bf_and_test(lv, s20571c1f2, ABISELECT(3490,2550), 0, 3, hide_sll(1LL<<2), "S20571C1");
    set_bf_and_test(lv, s20571c1f3, ABISELECT(3492,2552), 0, 16, 1, "S20571C1");
    set_bf_and_test(lv, s20571c1f3, ABISELECT(3492,2552), 0, 16, hide_sll(1LL<<15), "S20571C1");
    check_field_offset(lv, s20571c1f4, ABISELECT(3504,2556), "S20571C1.s20571c1f4");
    check_field_offset(lv, s20571c1f5, ABISELECT(7312,5372), "S20571C1.s20571c1f5");
    check_field_offset(lv, s20571c1f6, ABISELECT(15616,11556), "S20571C1.s20571c1f6");
    check_field_offset(lv, s20571c1f7, ABISELECT(15624,11560), "S20571C1.s20571c1f7");
    check_field_offset(lv, s20571c1f8, ABISELECT(15626,11562), "S20571C1.s20571c1f8");
    check_field_offset(lv, s20571c1f9, ABISELECT(15640,11576), "S20571C1.s20571c1f9");
    test_class_info(&lv, &cd_S20571C1);
    dp->~S20571C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20571C1(Test_S20571C1, "S20571C1", ABISELECT(20176,14908));

#else // __cplusplus

extern void _ZN8S20571C1C1Ev();
extern void _ZN8S20571C1D1Ev();
Name_Map name_map_S20571C1[] = {
  NSPAIR(_ZN8S20571C1C1Ev),
  NSPAIR(_ZN8S20571C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20571C4;
extern VTBL_ENTRY _ZTI8S20571C4[];
extern  VTBL_ENTRY _ZTV8S20571C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20571C4[];
extern Class_Descriptor cd_S20571C3;
extern VTBL_ENTRY _ZTI8S20571C3[];
extern  VTBL_ENTRY _ZTV8S20571C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20571C3[];
extern Class_Descriptor cd_S20571C2;
extern VTBL_ENTRY _ZTI8S20571C2[];
extern  VTBL_ENTRY _ZTV8S20571C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20571C2[];
extern Class_Descriptor cd_S20571C6;
extern VTBL_ENTRY _ZTI8S20571C6[];
extern  VTBL_ENTRY _ZTV8S20571C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20571C6[];
extern Class_Descriptor cd_S20571C10;
extern VTBL_ENTRY _ZTI9S20571C10[];
extern  VTBL_ENTRY _ZTV9S20571C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C10[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20571C7;
extern VTBL_ENTRY _ZTI8S20571C7[];
extern  VTBL_ENTRY _ZTV8S20571C7[];
extern Class_Descriptor cd_S20571C9;
extern VTBL_ENTRY _ZTI8S20571C9[];
extern  VTBL_ENTRY _ZTV8S20571C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20571C9[];
extern Class_Descriptor cd_S20571C10;
extern VTBL_ENTRY _ZTI9S20571C10[];
extern  VTBL_ENTRY _ZTV9S20571C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C10[];
extern Class_Descriptor cd_S20571C8;
extern VTBL_ENTRY _ZTI8S20571C8[];
extern  VTBL_ENTRY _ZTV8S20571C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20571C8[];
extern Class_Descriptor cd_S20571C10;
extern VTBL_ENTRY _ZTI9S20571C10[];
extern  VTBL_ENTRY _ZTV9S20571C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C10[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20571C7;
extern VTBL_ENTRY _ZTI8S20571C7[];
extern  VTBL_ENTRY _ZTV8S20571C7[];
extern Class_Descriptor cd_S20571C12;
extern VTBL_ENTRY _ZTI9S20571C12[];
extern  VTBL_ENTRY _ZTV9S20571C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C12[];
extern Class_Descriptor cd_S20571C11;
extern VTBL_ENTRY _ZTI9S20571C11[];
extern  VTBL_ENTRY _ZTV9S20571C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20571C11[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
static Base_Class bases_S20571C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(15984,11816), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20571C4,    ABISELECT(15680,11596), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20571C3,    ABISELECT(15680,11596), //bcp->offset
    34, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20571C2,    ABISELECT(15656,11584), //bcp->offset
    25, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20571C6,    ABISELECT(16208,11984), //bcp->offset
    46, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20571C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(1184,876), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(1424,1048), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20571C7,    ABISELECT(1408,1044), //bcp->offset
    14, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20571C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20571C10,    ABISELECT(1840,1352), //bcp->offset
    19, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20571C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20571C10,    ABISELECT(16592,12260), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20570C5,    ABISELECT(17792,13140), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20571C7,    ABISELECT(17776,13136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S20571C12,    ABISELECT(17776,13136), //bcp->offset
    60, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20571C11,    ABISELECT(16592,12260), //bcp->offset
    49, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20570C5,    ABISELECT(3184,2340), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20571C1[];
extern void _ZN8S20571C1D1Ev();
extern void _ZN8S20571C1D0Ev();
extern void _ZN9S20571C102v8Ev();
extern void _ZN8S20571C93v12Ev();
extern void _ZN8S20571C12v1Ev();
extern void _ZN8S20571C12v2Ev();
extern void _ZN8S20571C12v3Ev();
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
extern void ABISELECT(_ZThn1840_N8S20571C1D1Ev,_ZThn1352_N8S20571C1D1Ev)();
extern void ABISELECT(_ZThn1840_N8S20571C1D0Ev,_ZThn1352_N8S20571C1D0Ev)();
extern void _ZN9S20571C102v8Ev();
extern void ABISELECT(_ZTv0_n40_N8S20571C1D1Ev,_ZTv0_n20_N8S20571C1D1Ev)();
extern void ABISELECT(_ZThn15656_N8S20571C1D1Ev,_ZThn11584_N8S20571C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S20571C1D0Ev,_ZTv0_n20_N8S20571C1D0Ev)();
extern void ABISELECT(_ZThn15656_N8S20571C1D0Ev,_ZThn11584_N8S20571C1D0Ev)() __attribute__((weak));
extern void _ZN8S20571C22v7Ev();
extern void ABISELECT(_ZTv0_n32_N8S20571C1D1Ev,_ZTv0_n16_N8S20571C1D1Ev)();
extern void ABISELECT(_ZThn15680_N8S20571C1D1Ev,_ZThn11596_N8S20571C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20571C1D0Ev,_ZTv0_n16_N8S20571C1D0Ev)();
extern void ABISELECT(_ZThn15680_N8S20571C1D0Ev,_ZThn11596_N8S20571C1D0Ev)() __attribute__((weak));
extern void _ZN8S20571C42v4Ev();
extern void _ZN8S20571C32v5Ev();
extern void _ZN8S20571C32v6Ev();
extern void ABISELECT(_ZTv0_n32_N8S20571C1D1Ev,_ZTv0_n16_N8S20571C1D1Ev)();
extern void ABISELECT(_ZThn16592_N8S20571C1D1Ev,_ZThn12260_N8S20571C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20571C1D0Ev,_ZTv0_n16_N8S20571C1D0Ev)();
extern void ABISELECT(_ZThn16592_N8S20571C1D0Ev,_ZThn12260_N8S20571C1D0Ev)() __attribute__((weak));
extern void _ZN9S20571C102v8Ev();
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
static  VTBL_ENTRY vtc_S20571C1[] = {
  ABISELECT(16592,12260),
  ABISELECT(16208,11984),
  ABISELECT(15680,11596),
  ABISELECT(15656,11584),
  ABISELECT(15984,11816),
  0,
  (VTBL_ENTRY)&(_ZTI8S20571C1[0]),
  (VTBL_ENTRY)&_ZN8S20571C1D1Ev,
  (VTBL_ENTRY)&_ZN8S20571C1D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20571C93v12Ev,
  (VTBL_ENTRY)&_ZN8S20571C12v1Ev,
  (VTBL_ENTRY)&_ZN8S20571C12v2Ev,
  (VTBL_ENTRY)&_ZN8S20571C12v3Ev,
  ABISELECT(-1408,-1044),
  (VTBL_ENTRY)&(_ZTI8S20571C1[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
  ABISELECT(14144,10464),
  ABISELECT(-1840,-1352),
  (VTBL_ENTRY)&(_ZTI8S20571C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1840_N8S20571C1D1Ev,_ZThn1352_N8S20571C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1840_N8S20571C1D0Ev,_ZThn1352_N8S20571C1D0Ev),
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
  0,
  ABISELECT(-15656,-11584),
  ABISELECT(328,232),
  ABISELECT(24,12),
  ABISELECT(-15656,-11584),
  (VTBL_ENTRY)&(_ZTI8S20571C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20571C1D1Ev,_ZTv0_n20_N8S20571C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20571C1D0Ev,_ZTv0_n20_N8S20571C1D0Ev),
  (VTBL_ENTRY)&_ZN8S20571C22v7Ev,
  0,
  0,
  0,
  ABISELECT(-15680,-11596),
  ABISELECT(304,220),
  ABISELECT(-15680,-11596),
  (VTBL_ENTRY)&(_ZTI8S20571C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20571C1D1Ev,_ZTv0_n16_N8S20571C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20571C1D0Ev,_ZTv0_n16_N8S20571C1D0Ev),
  (VTBL_ENTRY)&_ZN8S20571C42v4Ev,
  (VTBL_ENTRY)&_ZN8S20571C32v5Ev,
  (VTBL_ENTRY)&_ZN8S20571C32v6Ev,
  ABISELECT(-224,-168),
  ABISELECT(-16208,-11984),
  (VTBL_ENTRY)&(_ZTI8S20571C1[0]),
  ABISELECT(1184,876),
  ABISELECT(1184,876),
  ABISELECT(1184,876),
  0,
  ABISELECT(-16592,-12260),
  ABISELECT(-608,-444),
  ABISELECT(-16592,-12260),
  (VTBL_ENTRY)&(_ZTI8S20571C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20571C1D1Ev,_ZTv0_n16_N8S20571C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20571C1D0Ev,_ZTv0_n16_N8S20571C1D0Ev),
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
  ABISELECT(-1792,-1320),
  ABISELECT(-17776,-13136),
  (VTBL_ENTRY)&(_ZTI8S20571C1[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
};
extern VTBL_ENTRY _ZTV8S20571C1[];
extern void _ZN8S20571C8D1Ev();
extern void _ZN8S20571C8D0Ev();
extern void _ZN9S20571C102v8Ev();
extern void _ZN8S20571C93v12Ev();
static  VTBL_ENTRY _tg__ZTV8S20571C8__8S20571C1[] = {
  ABISELECT(15984,11816),
  0,
  (VTBL_ENTRY)&(_ZTI8S20571C8[0]),
  (VTBL_ENTRY)&_ZN8S20571C8D1Ev,
  (VTBL_ENTRY)&_ZN8S20571C8D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20571C93v12Ev,
};
extern void _ZN8S20571C9D1Ev();
extern void _ZN8S20571C9D0Ev();
extern void _ZN9S20571C102v8Ev();
extern void _ZN8S20571C93v12Ev();
static  VTBL_ENTRY _tg__ZTV8S20571C98S20571C8__8S20571C1[] = {
  ABISELECT(15984,11816),
  0,
  (VTBL_ENTRY)&(_ZTI8S20571C9[0]),
  (VTBL_ENTRY)&_ZN8S20571C9D1Ev,
  (VTBL_ENTRY)&_ZN8S20571C9D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
  (VTBL_ENTRY)&_ZN8S20571C93v12Ev,
};
extern void _ZN9S20571C10D1Ev();
extern void _ZN9S20571C10D0Ev();
extern void _ZN9S20571C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C108S20571C98S20571C8__8S20571C1[] = {
  ABISELECT(15984,11816),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C10[0]),
  (VTBL_ENTRY)&_ZN9S20571C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20571C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
};
extern void _ZN9S20571C10D1Ev();
extern void _ZN9S20571C10D0Ev();
extern void _ZN9S20571C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C108S20571C8__A1__8S20571C1[] = {
  ABISELECT(14144,10464),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C10[0]),
  (VTBL_ENTRY)&_ZN9S20571C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20571C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
};
extern void ABISELECT(_ZThn1840_N8S20571C8D1Ev,_ZThn1352_N8S20571C8D1Ev)();
extern void ABISELECT(_ZThn1840_N8S20571C8D0Ev,_ZThn1352_N8S20571C8D0Ev)();
extern void _ZN9S20571C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C10__A1__8S20571C8__8S20571C1[] = {
  ABISELECT(14144,10464),
  ABISELECT(-1840,-1352),
  (VTBL_ENTRY)&(_ZTI8S20571C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1840_N8S20571C8D1Ev,_ZThn1352_N8S20571C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1840_N8S20571C8D0Ev,_ZThn1352_N8S20571C8D0Ev),
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
};
extern void _ZN8S20571C2D1Ev();
extern void _ZN8S20571C2D0Ev();
extern void _ZN8S20571C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20571C2__8S20571C1[] = {
  ABISELECT(328,232),
  ABISELECT(24,12),
  0,
  (VTBL_ENTRY)&(_ZTI8S20571C2[0]),
  (VTBL_ENTRY)&_ZN8S20571C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20571C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20571C22v7Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S20571C2D1Ev,_ZTv0_n16_N8S20571C2D1Ev)();
extern void ABISELECT(_ZThn24_N8S20571C2D1Ev,_ZThn12_N8S20571C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20571C2D0Ev,_ZTv0_n16_N8S20571C2D0Ev)();
extern void ABISELECT(_ZThn24_N8S20571C2D0Ev,_ZThn12_N8S20571C2D0Ev)() __attribute__((weak));
extern void _ZN8S20571C42v4Ev();
extern void _ZN8S20571C32v5Ev();
extern void _ZN8S20571C32v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20571C3__8S20571C2__8S20571C1[] = {
  0,
  0,
  0,
  ABISELECT(-24,-12),
  ABISELECT(304,220),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S20571C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20571C2D1Ev,_ZTv0_n16_N8S20571C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20571C2D0Ev,_ZTv0_n16_N8S20571C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20571C42v4Ev,
  (VTBL_ENTRY)&_ZN8S20571C32v5Ev,
  (VTBL_ENTRY)&_ZN8S20571C32v6Ev,
};
extern void _ZN8S20571C3D1Ev();
extern void _ZN8S20571C3D0Ev();
extern void _ZN8S20571C42v4Ev();
extern void _ZN8S20571C32v5Ev();
extern void _ZN8S20571C32v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20571C3__8S20571C1[] = {
  ABISELECT(304,220),
  0,
  (VTBL_ENTRY)&(_ZTI8S20571C3[0]),
  (VTBL_ENTRY)&_ZN8S20571C3D1Ev,
  (VTBL_ENTRY)&_ZN8S20571C3D0Ev,
  (VTBL_ENTRY)&_ZN8S20571C42v4Ev,
  (VTBL_ENTRY)&_ZN8S20571C32v5Ev,
  (VTBL_ENTRY)&_ZN8S20571C32v6Ev,
};
extern void _ZN8S20571C4D1Ev();
extern void _ZN8S20571C4D0Ev();
extern void _ZN8S20571C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20571C48S20571C3__8S20571C1[] = {
  ABISELECT(304,220),
  0,
  (VTBL_ENTRY)&(_ZTI8S20571C4[0]),
  (VTBL_ENTRY)&_ZN8S20571C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20571C4D0Ev,
  (VTBL_ENTRY)&_ZN8S20571C42v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20571C6__8S20571C1[] = {
  ABISELECT(-224,-168),
  0,
  (VTBL_ENTRY)&(_ZTI8S20571C6[0]),
};
extern void _ZN9S20571C11D1Ev();
extern void _ZN9S20571C11D0Ev();
extern void _ZN9S20571C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C11__8S20571C1[] = {
  ABISELECT(-608,-444),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C11[0]),
  (VTBL_ENTRY)&_ZN9S20571C11D1Ev,
  (VTBL_ENTRY)&_ZN9S20571C11D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
};
extern void _ZN9S20571C10D1Ev();
extern void _ZN9S20571C10D0Ev();
extern void _ZN9S20571C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C109S20571C11__A2__8S20571C1[] = {
  ABISELECT(-608,-444),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C10[0]),
  (VTBL_ENTRY)&_ZN9S20571C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20571C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20571C102v8Ev,
};
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C129S20571C11__8S20571C1[] = {
  ABISELECT(-1792,-1320),
  0,
  (VTBL_ENTRY)&(_ZTI9S20571C12[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
};
extern void _ZN8S20571C72v9Ev();
extern void _ZN8S20571C73v10Ev();
extern void _ZN8S20571C73v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20571C12__9S20571C11__8S20571C1[] = {
  ABISELECT(-1792,-1320),
  ABISELECT(-1184,-876),
  (VTBL_ENTRY)&(_ZTI9S20571C11[0]),
  (VTBL_ENTRY)&_ZN8S20571C72v9Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v10Ev,
  (VTBL_ENTRY)&_ZN8S20571C73v11Ev,
};
static  VTT_ENTRY vtt_S20571C1[] = {
  {&(_ZTV8S20571C1[7]),  7,66},
  {&(_tg__ZTV8S20571C8__8S20571C1[3]),  3,7},
  {&(_tg__ZTV8S20571C98S20571C8__8S20571C1[3]),  3,7},
  {&(_tg__ZTV9S20571C108S20571C98S20571C8__8S20571C1[3]),  3,6},
  {&(_tg__ZTV9S20571C108S20571C8__A1__8S20571C1[3]),  3,6},
  {&(_tg__ZTV9S20571C10__A1__8S20571C8__8S20571C1[3]),  3,6},
  {&(_ZTV8S20571C1[31]),  31,66},
  {&(_ZTV8S20571C1[41]),  41,66},
  {&(_ZTV8S20571C1[49]),  49,66},
  {&(_ZTV8S20571C1[22]),  22,66},
  {&(_ZTV8S20571C1[57]),  57,66},
  {&(_ZTV8S20571C1[63]),  63,66},
  {&(_tg__ZTV8S20571C2__8S20571C1[4]),  4,7},
  {&(_tg__ZTV8S20571C3__8S20571C2__8S20571C1[7]),  7,12},
  {&(_tg__ZTV8S20571C3__8S20571C1[3]),  3,8},
  {&(_tg__ZTV8S20571C48S20571C3__8S20571C1[3]),  3,6},
  {&(_tg__ZTV8S20571C6__8S20571C1[3]),  3,3},
  {&(_tg__ZTV9S20571C11__8S20571C1[3]),  3,6},
  {&(_tg__ZTV9S20571C109S20571C11__A2__8S20571C1[3]),  3,6},
  {&(_tg__ZTV9S20571C129S20571C11__8S20571C1[3]),  3,6},
  {&(_tg__ZTV9S20571C12__9S20571C11__8S20571C1[3]),  3,6},
};
extern VTBL_ENTRY _ZTI8S20571C1[];
extern  VTBL_ENTRY _ZTV8S20571C1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20571C1[];
static VTBL_ENTRY alt_thunk_names11[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S20571C2D0Ev,_ZTv0_n16_N8S20571C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S20571C2D0Ev,_ZThn12_N8S20571C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S20571C2D1Ev,_ZTv0_n16_N8S20571C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S20571C2D1Ev,_ZThn12_N8S20571C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S20571C1D0Ev,_ZTv0_n16_N8S20571C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16592_N8S20571C1D0Ev,_ZThn12260_N8S20571C1D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn15680_N8S20571C1D0Ev,_ZThn11596_N8S20571C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S20571C1D1Ev,_ZTv0_n16_N8S20571C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16592_N8S20571C1D1Ev,_ZThn12260_N8S20571C1D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn15680_N8S20571C1D1Ev,_ZThn11596_N8S20571C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S20571C1D0Ev,_ZTv0_n20_N8S20571C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15656_N8S20571C1D0Ev,_ZThn11584_N8S20571C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S20571C1D1Ev,_ZTv0_n20_N8S20571C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15656_N8S20571C1D1Ev,_ZThn11584_N8S20571C1D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20571C1 = {  "S20571C1", // class name
  bases_S20571C1, 18,
  &(vtc_S20571C1[0]), // expected_vtbl_contents
  &(vtt_S20571C1[0]), // expected_vtt_contents
  ABISELECT(20176,14908), // object size
  NSPAIRA(_ZTI8S20571C1),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S20571C1),66, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20571C1),21, //virtual table table var
  13, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names11,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7389C2  : virtual S20570C5 {
  __tsi64 s7389c2f0[4];
  short s7389c2f1;
  int s7389c2f2;
  __tsi64 s7389c2f3;
  int s7389c2f4;
  virtual  ~S7389C2(); // _ZN7S7389C2D2Ev
  virtual void  v1(); // _ZN7S7389C22v1Ev
  S7389C2(); // tgen
};
//SIG(-1 S7389C2) C1{ VBC2{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} vd v1 FL[4] Fs Fi FL Fi}


 S7389C2 ::~S7389C2(){ note_dtor("S7389C2", this);}
void  S7389C2 ::v1(){vfunc_called(this, "_ZN7S7389C22v1Ev");}
S7389C2 ::S7389C2(){ note_ctor("S7389C2", this);} // tgen

static void Test_S7389C2()
{
  extern Class_Descriptor cd_S7389C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(19,57)];
    init_test(&cd_S7389C2, buf);
    S7389C2 *dp, &lv = *(dp=new (buf) S7389C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(288,224), "sizeof(S7389C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7389C2)");
    check_base_class_offset(lv, (S20570C5*), ABISELECT(64,56), "S7389C2");
    check_field_offset(lv, s7389c2f0, ABISELECT(8,4), "S7389C2.s7389c2f0");
    check_field_offset(lv, s7389c2f1, ABISELECT(40,36), "S7389C2.s7389c2f1");
    check_field_offset(lv, s7389c2f2, ABISELECT(44,40), "S7389C2.s7389c2f2");
    check_field_offset(lv, s7389c2f3, ABISELECT(48,44), "S7389C2.s7389c2f3");
    check_field_offset(lv, s7389c2f4, ABISELECT(56,52), "S7389C2.s7389c2f4");
    test_class_info(&lv, &cd_S7389C2);
    dp->~S7389C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7389C2(Test_S7389C2, "S7389C2", ABISELECT(288,224));

#else // __cplusplus

extern void _ZN7S7389C2C1Ev();
extern void _ZN7S7389C2D2Ev();
Name_Map name_map_S7389C2[] = {
  NSPAIR(_ZN7S7389C2C1Ev),
  NSPAIR(_ZN7S7389C2D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
static Base_Class bases_S7389C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(64,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S7389C2[];
extern void _ZN7S7389C2D1Ev();
extern void _ZN7S7389C2D0Ev();
extern void _ZN7S7389C22v1Ev();
static  VTBL_ENTRY vtc_S7389C2[] = {
  ABISELECT(64,56),
  0,
  (VTBL_ENTRY)&(_ZTI7S7389C2[0]),
  (VTBL_ENTRY)&_ZN7S7389C2D1Ev,
  (VTBL_ENTRY)&_ZN7S7389C2D0Ev,
  (VTBL_ENTRY)&_ZN7S7389C22v1Ev,
};
extern VTBL_ENTRY _ZTV7S7389C2[];
static  VTT_ENTRY vtt_S7389C2[] = {
  {&(_ZTV7S7389C2[3]),  3,6},
};
extern VTBL_ENTRY _ZTI7S7389C2[];
extern  VTBL_ENTRY _ZTV7S7389C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7389C2[];
Class_Descriptor cd_S7389C2 = {  "S7389C2", // class name
  bases_S7389C2, 1,
  &(vtc_S7389C2[0]), // expected_vtbl_contents
  &(vtt_S7389C2[0]), // expected_vtt_contents
  ABISELECT(288,224), // object size
  NSPAIRA(_ZTI7S7389C2),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7S7389C2),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7389C2),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7389C6  : S20570C5 {
  long double s7389c6f0;
  short s7389c6f1:16;
  int s7389c6f2[7];
  long double s7389c6f3;
  char s7389c6f4:6;
  int s7389c6f5:32;
  __tsi64 s7389c6f6[2];
  int s7389c6f7;
  virtual void  v2(); // _ZN7S7389C62v2Ev
  virtual void  v3(); // _ZN7S7389C62v3Ev
  virtual void  v4(); // _ZN7S7389C62v4Ev
  ~S7389C6(); // tgen
  S7389C6(); // tgen
};
//SIG(-1 S7389C6) C1{ BC2{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} v1 v2 v3 FD Fs:16 Fi[7] FD Fc:6 Fi:32 FL[2] Fi}


void  S7389C6 ::v2(){vfunc_called(this, "_ZN7S7389C62v2Ev");}
void  S7389C6 ::v3(){vfunc_called(this, "_ZN7S7389C62v3Ev");}
void  S7389C6 ::v4(){vfunc_called(this, "_ZN7S7389C62v4Ev");}
S7389C6 ::~S7389C6(){ note_dtor("S7389C6", this);} // tgen
S7389C6 ::S7389C6(){ note_ctor("S7389C6", this);} // tgen

static void Test_S7389C6()
{
  extern Class_Descriptor cd_S7389C6;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(22,65)];
    init_test(&cd_S7389C6, buf);
    S7389C6 *dp, &lv = *(dp=new (buf) S7389C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(336,256), "sizeof(S7389C6)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7389C6)");
    check_base_class_offset(lv, (S20570C5*), ABISELECT(16,4), "S7389C6");
    check_field_offset(lv, s7389c6f0, ABISELECT(240,172), "S7389C6.s7389c6f0");
    set_bf_and_test(lv, s7389c6f1, ABISELECT(256,184), 0, 16, 1, "S7389C6");
    set_bf_and_test(lv, s7389c6f1, ABISELECT(256,184), 0, 16, hide_sll(1LL<<15), "S7389C6");
    check_field_offset(lv, s7389c6f2, ABISELECT(260,188), "S7389C6.s7389c6f2");
    check_field_offset(lv, s7389c6f3, ABISELECT(288,216), "S7389C6.s7389c6f3");
    set_bf_and_test(lv, s7389c6f4, ABISELECT(304,228), 0, 6, 1, "S7389C6");
    set_bf_and_test(lv, s7389c6f4, ABISELECT(304,228), 0, 6, hide_sll(1LL<<5), "S7389C6");
    set_bf_and_test(lv, s7389c6f5, ABISELECT(308,232), 0, 32, 1, "S7389C6");
    set_bf_and_test(lv, s7389c6f5, ABISELECT(308,232), 0, 32, hide_sll(1LL<<31), "S7389C6");
    check_field_offset(lv, s7389c6f6, ABISELECT(312,236), "S7389C6.s7389c6f6");
    check_field_offset(lv, s7389c6f7, ABISELECT(328,252), "S7389C6.s7389c6f7");
    test_class_info(&lv, &cd_S7389C6);
    dp->~S7389C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7389C6(Test_S7389C6, "S7389C6", ABISELECT(336,256));

#else // __cplusplus

extern void _ZN7S7389C6C1Ev();
extern void _ZN7S7389C6D1Ev();
Name_Map name_map_S7389C6[] = {
  NSPAIR(_ZN7S7389C6C1Ev),
  NSPAIR(_ZN7S7389C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
static Base_Class bases_S7389C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S7389C6[];
extern void _ZN7S7389C62v2Ev();
extern void _ZN7S7389C62v3Ev();
extern void _ZN7S7389C62v4Ev();
static  VTBL_ENTRY vtc_S7389C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S7389C6[0]),
  (VTBL_ENTRY)&_ZN7S7389C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7389C62v3Ev,
  (VTBL_ENTRY)&_ZN7S7389C62v4Ev,
};
extern VTBL_ENTRY _ZTI7S7389C6[];
extern  VTBL_ENTRY _ZTV7S7389C6[];
Class_Descriptor cd_S7389C6 = {  "S7389C6", // class name
  bases_S7389C6, 1,
  &(vtc_S7389C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(336,256), // object size
  NSPAIRA(_ZTI7S7389C6),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7S7389C6),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7389C5  : virtual S7389C6 {
  ::S7388C7 s7389c5f0[5];
  char s7389c5f1[3];
  void *s7389c5f2;
  void *s7389c5f3;
  short s7389c5f4[4];
  int s7389c5f5[6];
  ::S7389C2 s7389c5f6;
  int s7389c5f7;
  void *s7389c5f8[8];
  int s7389c5f9;
  ::S7388C8 s7389c5f10;
  char s7389c5f11;
  int s7389c5f12;
  int s7389c5f13[7];
  ~S7389C5(); // tgen
  S7389C5(); // tgen
};
//SIG(-1 S7389C5) C1{ VBC2{ BC3{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} v1 v2 v3 FD Fs:16 Fi[7] FD Fc:6 Fi:32 FL[2] Fi} FU4{ m FD Fp Fs:5 Fp FD Fp FD Fi[7] Fp Fp}[5] Fc[3] Fp Fp Fs[4] Fi[6] FC5{ VBC3 vd v4 FL[4] Fs Fi FL Fi} Fi Fp[8] Fi FU6{ m FD[10] Fs Fs Fp Fl Fp FD[9]} Fc Fi Fi[7]}


S7389C5 ::~S7389C5(){ note_dtor("S7389C5", this);} // tgen
S7389C5 ::S7389C5(){ note_ctor("S7389C5", this);} // tgen

static void Test_S7389C5()
{
  extern Class_Descriptor cd_S7389C5;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(73,217)];
    init_test(&cd_S7389C5, buf);
    S7389C5 *dp, &lv = *(dp=new (buf) S7389C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1152,864), "sizeof(S7389C5)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7389C5)");
    check_base_class_offset(lv, (S20570C5*)(S7389C6*), ABISELECT(832,612), "S7389C5");
    check_base_class_offset(lv, (S7389C6*), ABISELECT(816,608), "S7389C5");
    check_field_offset(lv, s7389c5f0, ABISELECT(16,4), "S7389C5.s7389c5f0");
    check_field_offset(lv, s7389c5f1, ABISELECT(176,144), "S7389C5.s7389c5f1");
    check_field_offset(lv, s7389c5f2, ABISELECT(184,148), "S7389C5.s7389c5f2");
    check_field_offset(lv, s7389c5f3, ABISELECT(192,152), "S7389C5.s7389c5f3");
    check_field_offset(lv, s7389c5f4, ABISELECT(200,156), "S7389C5.s7389c5f4");
    check_field_offset(lv, s7389c5f5, ABISELECT(208,164), "S7389C5.s7389c5f5");
    check_field_offset(lv, s7389c5f6, ABISELECT(240,188), "S7389C5.s7389c5f6");
    check_field_offset(lv, s7389c5f7, ABISELECT(528,412), "S7389C5.s7389c5f7");
    check_field_offset(lv, s7389c5f8, ABISELECT(536,416), "S7389C5.s7389c5f8");
    check_field_offset(lv, s7389c5f9, ABISELECT(600,448), "S7389C5.s7389c5f9");
    check_field_offset(lv, s7389c5f10, ABISELECT(608,452), "S7389C5.s7389c5f10");
    check_field_offset(lv, s7389c5f11, ABISELECT(768,572), "S7389C5.s7389c5f11");
    check_field_offset(lv, s7389c5f12, ABISELECT(772,576), "S7389C5.s7389c5f12");
    check_field_offset(lv, s7389c5f13, ABISELECT(776,580), "S7389C5.s7389c5f13");
    test_class_info(&lv, &cd_S7389C5);
    dp->~S7389C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7389C5(Test_S7389C5, "S7389C5", ABISELECT(1152,864));

#else // __cplusplus

extern void _ZN7S7389C5C1Ev();
extern void _ZN7S7389C5D1Ev();
Name_Map name_map_S7389C5[] = {
  NSPAIR(_ZN7S7389C5C1Ev),
  NSPAIR(_ZN7S7389C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S7389C6;
extern VTBL_ENTRY _ZTI7S7389C6[];
extern  VTBL_ENTRY _ZTV7S7389C6[];
static Base_Class bases_S7389C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(832,612), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S7389C6,    ABISELECT(816,608), //bcp->offset
    3, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S7389C5[];
extern void _ZN7S7389C62v2Ev();
extern void _ZN7S7389C62v3Ev();
extern void _ZN7S7389C62v4Ev();
static  VTBL_ENTRY vtc_S7389C5[] = {
  ABISELECT(816,608),
  0,
  (VTBL_ENTRY)&(_ZTI7S7389C5[0]),
  0,
  0,
  0,
  ABISELECT(-816,-608),
  (VTBL_ENTRY)&(_ZTI7S7389C5[0]),
  (VTBL_ENTRY)&_ZN7S7389C62v2Ev,
  (VTBL_ENTRY)&_ZN7S7389C62v3Ev,
  (VTBL_ENTRY)&_ZN7S7389C62v4Ev,
};
extern VTBL_ENTRY _ZTV7S7389C5[];
static  VTT_ENTRY vtt_S7389C5[] = {
  {&(_ZTV7S7389C5[3]),  3,11},
  {&(_ZTV7S7389C5[8]),  8,11},
};
extern VTBL_ENTRY _ZTI7S7389C5[];
extern  VTBL_ENTRY _ZTV7S7389C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7389C5[];
Class_Descriptor cd_S7389C5 = {  "S7389C5", // class name
  bases_S7389C5, 2,
  &(vtc_S7389C5[0]), // expected_vtbl_contents
  &(vtt_S7389C5[0]), // expected_vtt_contents
  ABISELECT(1152,864), // object size
  NSPAIRA(_ZTI7S7389C5),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7S7389C5),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7389C5),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7389C13  : virtual S20570C5 {
  ::S20570C5 s7389c13f0[5];
  __tsi64 s7389c13f1;
  short s7389c13f2:5;
  char  :0;
  void *s7389c13f4;
  void *s7389c13f5;
  int s7389c13f6;
  __tsi64 s7389c13f7;
  virtual  ~S7389C13(); // _ZN8S7389C13D2Ev
  virtual void  v5(); // _ZN8S7389C132v5Ev
  S7389C13(); // tgen
};
//SIG(-1 S7389C13) C1{ VBC2{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} vd v1 FC2[5] FL Fs:5 Fc:0 Fp[2] Fi FL}


 S7389C13 ::~S7389C13(){ note_dtor("S7389C13", this);}
void  S7389C13 ::v5(){vfunc_called(this, "_ZN8S7389C132v5Ev");}
S7389C13 ::S7389C13(){ note_ctor("S7389C13", this);} // tgen

static void Test_S7389C13()
{
  extern Class_Descriptor cd_S7389C13;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(89,262)];
    init_test(&cd_S7389C13, buf);
    S7389C13 *dp, &lv = *(dp=new (buf) S7389C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1408,1044), "sizeof(S7389C13)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7389C13)");
    check_base_class_offset(lv, (S20570C5*), ABISELECT(1184,876), "S7389C13");
    check_field_offset(lv, s7389c13f0, ABISELECT(16,4), "S7389C13.s7389c13f0");
    check_field_offset(lv, s7389c13f1, ABISELECT(1136,844), "S7389C13.s7389c13f1");
    set_bf_and_test(lv, s7389c13f2, ABISELECT(1144,852), 0, 5, 1, "S7389C13");
    set_bf_and_test(lv, s7389c13f2, ABISELECT(1144,852), 0, 5, hide_sll(1LL<<4), "S7389C13");
    check_field_offset(lv, s7389c13f4, ABISELECT(1152,856), "S7389C13.s7389c13f4");
    check_field_offset(lv, s7389c13f5, ABISELECT(1160,860), "S7389C13.s7389c13f5");
    check_field_offset(lv, s7389c13f6, ABISELECT(1168,864), "S7389C13.s7389c13f6");
    check_field_offset(lv, s7389c13f7, ABISELECT(1176,868), "S7389C13.s7389c13f7");
    test_class_info(&lv, &cd_S7389C13);
    dp->~S7389C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7389C13(Test_S7389C13, "S7389C13", ABISELECT(1408,1044));

#else // __cplusplus

extern void _ZN8S7389C13C1Ev();
extern void _ZN8S7389C13D2Ev();
Name_Map name_map_S7389C13[] = {
  NSPAIR(_ZN8S7389C13C1Ev),
  NSPAIR(_ZN8S7389C13D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
static Base_Class bases_S7389C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(1184,876), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7389C13[];
extern void _ZN8S7389C13D1Ev();
extern void _ZN8S7389C13D0Ev();
extern void _ZN8S7389C132v5Ev();
static  VTBL_ENTRY vtc_S7389C13[] = {
  ABISELECT(1184,876),
  0,
  (VTBL_ENTRY)&(_ZTI8S7389C13[0]),
  (VTBL_ENTRY)&_ZN8S7389C13D1Ev,
  (VTBL_ENTRY)&_ZN8S7389C13D0Ev,
  (VTBL_ENTRY)&_ZN8S7389C132v5Ev,
};
extern VTBL_ENTRY _ZTV8S7389C13[];
static  VTT_ENTRY vtt_S7389C13[] = {
  {&(_ZTV8S7389C13[3]),  3,6},
};
extern VTBL_ENTRY _ZTI8S7389C13[];
extern  VTBL_ENTRY _ZTV8S7389C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7389C13[];
Class_Descriptor cd_S7389C13 = {  "S7389C13", // class name
  bases_S7389C13, 1,
  &(vtc_S7389C13[0]), // expected_vtbl_contents
  &(vtt_S7389C13[0]), // expected_vtt_contents
  ABISELECT(1408,1044), // object size
  NSPAIRA(_ZTI8S7389C13),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S7389C13),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7389C13),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7389C12  : S7389C13 , S20570C5 , S7389C6 {
  long double s7389c12f0;
  void *s7389c12f1;
  short s7389c12f2[6];
  void *s7389c12f3;
  int s7389c12f4;
  long double s7389c12f5;
  int s7389c12f6;
  virtual void  v6(); // _ZN8S7389C122v6Ev
  ~S7389C12(); // tgen
  S7389C12(); // tgen
};
//SIG(-1 S7389C12) C1{ BC2{ VBC3{ m Fc Fp Fi FL Fi[7] Fs:3 FL FD[9]} vd v2 FC3[5] FL Fs:5 Fc:0 Fp[2] Fi FL} BC3 BC4{ BC3 v3 v4 v5 FD Fs:16 Fi[7] FD Fc:6 Fi:32 FL[2] Fi} v1 FD Fp Fs[6] Fp Fi FD Fi}


void  S7389C12 ::v6(){vfunc_called(this, "_ZN8S7389C122v6Ev");}
S7389C12 ::~S7389C12(){ note_dtor("S7389C12", this);} // tgen
S7389C12 ::S7389C12(){ note_ctor("S7389C12", this);} // tgen

static void Test_S7389C12()
{
  extern Class_Descriptor cd_S7389C12;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(130,381)];
    init_test(&cd_S7389C12, buf);
    S7389C12 *dp, &lv = *(dp=new (buf) S7389C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2064,1520), "sizeof(S7389C12)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7389C12)");
    check_base_class_offset(lv, (S20570C5*)(S7389C13*), ABISELECT(1840,1352), "S7389C12");
    check_base_class_offset(lv, (S7389C13*), 0, "S7389C12");
    /*is_ambiguous_... S7389C12::S20570C5 */ AMB_check_base_class_offset(lv, (S20570C5*), ABISELECT(1184,876), "S7389C12");
    check_base_class_offset(lv, (S20570C5*)(S7389C6*), ABISELECT(1424,1048), "S7389C12");
    check_base_class_offset(lv, (S7389C6*), ABISELECT(1408,1044), "S7389C12");
    check_field_offset(lv, s7389c12f0, ABISELECT(1744,1300), "S7389C12.s7389c12f0");
    check_field_offset(lv, s7389c12f1, ABISELECT(1760,1312), "S7389C12.s7389c12f1");
    check_field_offset(lv, s7389c12f2, ABISELECT(1768,1316), "S7389C12.s7389c12f2");
    check_field_offset(lv, s7389c12f3, ABISELECT(1784,1328), "S7389C12.s7389c12f3");
    check_field_offset(lv, s7389c12f4, ABISELECT(1792,1332), "S7389C12.s7389c12f4");
    check_field_offset(lv, s7389c12f5, ABISELECT(1808,1336), "S7389C12.s7389c12f5");
    check_field_offset(lv, s7389c12f6, ABISELECT(1824,1348), "S7389C12.s7389c12f6");
    test_class_info(&lv, &cd_S7389C12);
    dp->~S7389C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7389C12(Test_S7389C12, "S7389C12", ABISELECT(2064,1520));

#else // __cplusplus

extern void _ZN8S7389C12C1Ev();
extern void _ZN8S7389C12D1Ev();
Name_Map name_map_S7389C12[] = {
  NSPAIR(_ZN8S7389C12C1Ev),
  NSPAIR(_ZN8S7389C12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S7389C13;
extern VTBL_ENTRY _ZTI8S7389C13[];
extern  VTBL_ENTRY _ZTV8S7389C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7389C13[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S20570C5;
extern VTBL_ENTRY _ZTI8S20570C5[];
extern Class_Descriptor cd_S7389C6;
extern VTBL_ENTRY _ZTI7S7389C6[];
extern  VTBL_ENTRY _ZTV7S7389C6[];
static Base_Class bases_S7389C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20570C5,    ABISELECT(1840,1352), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S7389C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20570C5,    ABISELECT(1184,876), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20570C5,    ABISELECT(1424,1048), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7389C6,    ABISELECT(1408,1044), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7389C12[];
extern void _ZN8S7389C12D1Ev();
extern void _ZN8S7389C12D0Ev();
extern void _ZN8S7389C132v5Ev();
extern void _ZN8S7389C122v6Ev();
extern void _ZN7S7389C62v2Ev();
extern void _ZN7S7389C62v3Ev();
extern void _ZN7S7389C62v4Ev();
static  VTBL_ENTRY vtc_S7389C12[] = {
  ABISELECT(1840,1352),
  0,
  (VTBL_ENTRY)&(_ZTI8S7389C12[0]),
  (VTBL_ENTRY)&_ZN8S7389C12D1Ev,
  (VTBL_ENTRY)&_ZN8S7389C12D0Ev,
  (VTBL_ENTRY)&_ZN8S7389C132v5Ev,
  (VTBL_ENTRY)&_ZN8S7389C122v6Ev,
  ABISELECT(-1408,-1044),
  (VTBL_ENTRY)&(_ZTI8